﻿USE sofia;
DROP TABLE IF EXISTS sofia.guj2009_vpl;
CREATE TABLE guj2009_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guj2009_vpl WRITE;
INSERT INTO guj2009_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","આરંભમાં દેવે આકાશ અને પૃથ્વીનું સર્જન કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","પૃથ્વી ખાલી અને અસ્તવ્યસ્ત હતી. જમીન પર કશું જ ન હતું. સમુદ્ર પર અંધકાર છવાયેલો હતો અને દેવનો આત્માં પાણી પર હાલતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ત્યારે દેવે કહ્યું, “પ્રકાશ પ્રગટો” અને પ્રકાશ પ્રગટયો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","દેવે પ્રકાશને જોયો અને તેમણે જાણ્યું કે, તે સારું છે. ત્યારે દેવે પ્રકાશને અંધકારથી જુદો પાડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","દેવે પ્રકાશનું નામ “દિવસ” અને અંધકારનું નામ “રાત” રાખ્યું. સાંજ પડી અને પછી સવાર થઇ તે પહેલો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","પછી દેવે કહ્યું, “પાણીને બે ભાગમાં જુદું પાડવા માંટે વચ્ચે અંતરિક્ષ થાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","એટલે દેવે અંતરિક્ષ બનાવ્યું અને પાણીને જુદું પાડયું. કેટલુંક પાણી અંતરિક્ષની ઉપર હતું અને કેટલુંક પાણી અંતરિક્ષની નીચે હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","દેવે અંતરિક્ષને “આકાશ” કહ્યું. પછી સાંજ પડી અને સવાર થઇ તે બીજો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","પછી દેવે કહ્યું, “પૃથ્વી પરનું પાણી એક જગ્યાએ ભેગું થાઓ જેથી સૂકી જમીન નજરે પડે.” અને એ જ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","દેવે સૂકી જમીનને “પૃથ્વી” કહી અને જે પાણી ભેગું થયેલું હતું તે પાણીને “સાગર” કહ્યો. દેવે જોયું કે, તે સારું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","પછી દેવે કહ્યું, “પૃથ્વી વનસ્પતિ પેદા કરો: અનાજ આપનાર છોડ અને ફળ આપનાર વૃક્ષો પેદા કરો. પ્રત્યેકમાં પોતપોતાની જાતનાં બીજ થાઓ. આ પ્રકારના છોડ પૃથ્વી પર પેદા થાઓ.” અને એ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","પૃથ્વીએ અનાજ ઉત્પન્ન કરનાર ઘાસ અને છોડ ઉગાડયા અને એવાં વૃક્ષો અને છોડ ઉગાડયાં જેનાં ફળોની અંદર બીજ હોય છે. પ્રત્યેક છોડવાએ પોતપોતાની જાતનાં બીજ પેદા કર્યા અને દેવે જોયું કે, તે સારું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","પછી સાંજ પડી અને સવાર થઇ તે ત્રીજો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","પછી દેવે કહ્યું, “આકાશમાં જયોતિઓ થાઓ. આ જયોતિઓ દિવસોને રાતોથી જુદા પાડશે. આ જયોતિઓનો વિશેષ ચિહનોરૂપે ઉપયોગ થશે. અને વિશેષ સભાઓ જ્યારે શરુ થશે તે દર્શાવશે અને તેનો ઉપયોગ ઋતુઓ, દિવસો અને વષોર્નો સમય નિશ્ચિત કરવામાં થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","અને તેઓ પૃથ્વી પર પ્રકાશ પાથરવા માંટે આકાશમાં સ્થિર થાઓ.” અને એમ જ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","પછી દેવે બે મોટી જયોતિઓ બનાવી. દેવે તેમાંની મોટી જયોતિને દિવસ પર અમલ કરવા બનાવી અને નાની જયોતિને રાત પર અમલ કરવા બનાવી. દેવે તારાઓ પણ બનાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","દેવે આ જયોતિઓને આકાશમાં એટલા માંટે રાખી કે, તે પૃથ્વી પર ચમકે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","દેવે આ જયોતિઓને આકાશમાં એટલાં માંટે રાખી કે, જેથી તે દિવસ અને રાત પર અમલ ચલાવે. આ જયોતિઓએ પ્રકાશને અંધકારથી જુદો પાડયો અને દેવે જોયું કે, આ સારું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ત્યારે સાંજ થઈને સવાર થઇ. તે ચોથો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","પછી દેવે કહ્યું, “પાણી અનેક જળચરોથી ઊભરાઈ જાઓ અને પક્ષીઓ પૃથ્વી પર અને આકાશમાં ઊડો.” ");
INSERT INTO guj2009_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","એથી દેવે સમુદ્રમાં રાક્ષસી જળચર પ્રાણી બનાવ્યાં. દેવે સમુદ્રમાં રહેનાર બધાં સજીવ પ્રાણીઓ બનાવ્યાં. સમુદ્રમાં જુદી જુદી જાતિનાં જીવજંતુ હોય છે. દેવે આ બધાંની સૃષ્ટિ રચી. દેવે આકાશમાં ઉડનારાં દરેક જાતનાં પક્ષીઓ પણ બનાવ્યાં. દેવે જોયું કે, આ સારું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","પછી દેવે તે પ્રાણીઓને આશીર્વાદ આપ્યા. અને કહ્યું, “જાઓ, ઘણાં બધાં બચ્ચાં પેદા કરો અને સાગરનાં પાણીને ભરી દો. અને પક્ષીઓ પણ બહુ જ વધી જાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","પછી સાંજ થઇ અને સવાર થઇ. તે પાંચમો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","પછી દેવે કહ્યું, “પૃથ્વી બધી જાતનાં પ્રાણીઓ પેદા કરો: ‘પ્રત્યેક જાતનાં ઢોર, પેટે ચાલનારાં પ્રાણીઓ અને મોટાં જંગલી પ્રાણીઓ.’ અને આ પ્રાણીઓ પોતપોતાની જાતિ પ્રમાંણે વધારે પ્રાણીઓ ઉત્પન્ન કરે.” અને આ બધું થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","તે પછી દેવે પ્રત્યેક જાતિનાં પ્રાણીઓ બનાવ્યાં. દેવે જંગલી પ્રાણીઓ, પાળી શકાય તેવાં પ્રાણીઓ, અને પેટે ચાલનારાં પ્રાણીઓ બનાવ્યાં અને દેવે જોયું કે, આ સારું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","પછી દેવે કહ્યું, “હવે આપણે મનુષ્ય બનાવીએ, જે આપણી પ્રતિમાંરૂપ અને આપણને મળતો આવતો હોય; જે સમુદ્રમાંનાં માંછલાં પર, અને આકાશમાંનાં પક્ષીઓ પર શાસન કરે. તે પૃથ્વીનાં બધાં પ્રાણીઓ અને નાનાં પેટે ચાલનારાં જીવો પર શાસન કરે.” ");
INSERT INTO guj2009_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","આથી દેવે પોતાની પ્રતિમાંરૂપ મનુષ્ય પેદા કર્યો. તેણે માંણસો એટલે સ્ત્રી અને પુરુષ બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","દેવે તેઓને આશીર્વાદ આપ્યા. દેવે તેઓને કહ્યું, “ઘણાં સંતાનો પ્રાપ્ત કરો, પૃથ્વીને ભરી દો અને તેનું નિયંત્રણ કરો. સાગરનાં માંછલાં પર અને આકાશના પક્ષીઓ પર શાસન કરો. પૃથ્વી પરનાં પ્રત્યેક જીવ પર શાસન કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","દેવે કહ્યું, “જુઓ, મેં તમને જમીનમાં ઊગનારાં, બધી જ જાતનાં અનાજ પેદા કરનારા છોડ અને પ્રત્યેક જાતનાં બીવાળા ફળનાં વૃક્ષો આપ્યાં છે: એ તમને સૌને ખાવાના કામમાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","પૃથ્વી પરનાં પ્રત્યેક પ્રાણીને અને આકાશમાંના પ્રત્યેક પક્ષીને તથા પૃથ્વી પર પેટે ચાલનારાં પ્રત્યેક જીવને ખાવા માંટે મેં લીલું ઘાસ અને છોડ આપ્યા છે.” અને એમ જ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","દેવે પોતાના દ્વારા તૈયાર થયેલી પ્રત્યેક વસ્તુઓ જોઈ અને દેવે જોયું કે, પ્રત્યેક વસ્તુ ઘણી જ સારી છે. સાંજ પડી અને સવાર થઇ, તે છઠ્ઠો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","આ રીતે પૃથ્વી, આકાશ અને તેમાંની બધી જ વસ્તુઓનું સર્જન પૂરું થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","દેવ પોતે જે કામ કરતા હતા તે તેમણે પૂરું કર્યું. તેથી સાતમાં દિવસે દેવે પોતાનું કામ બંધ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","દેવે સાતમાં દિવસને આશીર્વાદ આપ્યો અને તેને પવિત્ર બનાવ્યો. કેમ કે, તે દિવસે દેવ સંસારનું સર્જન કરતી વખતે જે કામ કરી રહ્યા હતા તે બધાં જ કાર્યો બંધ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","આ છે આકાશ અને પૃથ્વીનાં સર્જનનો ઈતિહાસ. જયારે દેવે પૃથ્વી અને આકાશ બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","તે વખતે પૃથ્વી પર કોઇ વૃક્ષ કે, છોડ ન હતા. અને ખેતરોમાં કાંઈ જ ઊગતું ન હતું કારણ કે યહોવા દેવે પૃથ્વી પર વરસાદ વરસાવ્યો ન હતો. અને વૃક્ષો અને છોડવાંઓની સંભાળ રાખનાર કોઈ મનુષ્ય પણ ન હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","પરંતુ પૃથ્વી પરથી ધૂમસ ઊચે ચઢતું હતું અને પૃથ્વીની બધી જ જમીનને તેણે ભીંજવી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ત્યારે યહોવા દેવે ભૂમિ પરથી માંટી લીધી અને મનુષ્યનું સર્જન કર્યું. અને તેના નસકોરામાં પ્રાણ ફૂંકયો તેથી મનુષ્યમાં જીવ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","પછી યહોવા દેવે પૂર્વ દિશામાં એદનમાં એક બાગ બનાવ્યો અને તેમણે જે મનુષ્યનું સર્જન કર્યુ હતું તેને તે બાગમાં મૂકયો. ");
INSERT INTO guj2009_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","યહોવા દેવે આ બાગમાં દરેક જાતનાં વૃક્ષો ઉગાડયાં, જે દેખાવમાં સુંદર હોય અને જેનાં ફળ ખાવામાં સારાં હોય. બાગમાં વચ્ચે જીવનનું વૃક્ષ અને સારાભૂંડાની સમજનું વૃક્ષ પણ ઉગાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","એદનમાં થઈને એક નદી વહેતી હતી અને તે બાગને પાણી સીંચતી હતી. આ નદી આગળ જતાં ચાર નાની નદીઓ થઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","પહેલી નદીનું નામ પીશોન છે તે હવીલાહના આખા પ્રદેશની ફરતે વહે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(આ પ્રદેશમાં સોનું છે અને તે સોનું સારું છે. ત્યાં બદોલાખ અને અકીક પાષાણ પણ મળે છે.) ");
INSERT INTO guj2009_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","બીજી નદીનું નામ ગીહોન છે; તે કૂશના આખા પ્રદેશની ફરતી વહે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ત્રીજી નદીનું નામ હીદેકેલ છે, જે આશ્શૂરની પૂર્વમાં વહે છે, અને ચોથી નદી તે ફ્રાત છે. ");
INSERT INTO guj2009_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","યહોવા દેવે તે માંણસને એદનના બગીચાને ખેડવા તથા તેનું રક્ષણ કરવા ત્યાં મૂકયો. તેનું કામ બાગમાં વૃક્ષો અને છોડવાં ઉગાડવાનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","યહોવા દેવે મનુષ્યને આજ્ઞા કરી કે, “તારે બાગમાંનાં કોઈ પણ વૃક્ષનાં ફળો ખાવાં. ");
INSERT INTO guj2009_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","પરંતુ તમે સારાનરસાની સમજ આપનારાં વૃક્ષનાં ફળ તારે ખાવાં નહિ, જો તું એ વૃક્ષનાં ફળ ખાઈશ તો તારું મૃત્યુ અવશ્ય તે જ દિવસે થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ત્યારે યહોવા દેવે કહ્યું, “હું સમજું છું કે, માંણસનું એકલા રહેવું તે સારું નથી, હું તેને માંટે એક યોગ્ય મદદ કરનાર બનાવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","તેથી યહોવા દેવે ભૂમિની માંટીમાંથી બધી જાતનાં જંગલી પ્રાણીઓ અને બધી જાતનાં આકાશનાં પક્ષીઓ બનાવ્યાં. યહોવા દેવે બધાં જ પ્રાણીઓને મનુષ્યની સામે લાવ્યાં અને તે એ મનુષ્ય તે બધાંનાં નામ પાડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","મનુષ્ય પાળી શકે તેવાં પ્રાણીઓ, આકાશનાં બધાં જ પક્ષીઓ અને જંગલનાં બધાં જ પ્રાણીઓનાં નામ પાડયાં; મનુષ્યઓ અનેક પ્રાણી અને પક્ષી જોયાં પરંતુ મનુષ્ય પોતાને યોગ્ય મદદ કરનાર મેળવી શકયો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","તેથી યહોવા દેવે મનુષ્યને ગાઢ નિંદ્રામાં નાખ્યો. અને જયારે તે ઊંઘતો હતો ત્યારે તેના શરીરમાંથી એક પાંસળી કાઢીને તેની જગ્યાએ માંસ ભર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","યહોવા દેવે મનુષ્યની પાંસળીમાંથી સ્ત્રીની રચના કરી. અને તે સ્ત્રીને મનુષ્યની પાસે લાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","અને મનુષ્યે કહ્યું: “બરાબર માંરા જેવી એક વ્યકિત. તેના હાડકાં માંરા હાડકામાંથી અને તેનું માંસ માંરાં માંસમાંથી થયું છે. તેણી ‘નારી’ કહેવાશે, કારણ તેને નરમાંથી લેવાવામાં આવી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","આ જ કારણે પુરુષ પોતાના માંતાપિતાને છોડી જાય છે અને પોતાની પત્ની સાથે રહીને તે બંન્ને એક દેહ બની જાય છે. ");
INSERT INTO guj2009_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","તે મનુષ્ય અને તેની પત્ની બન્ને નવસ્ત્રો હોવા છતાં શરમાંતાં નહોતા. ");
INSERT INTO guj2009_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","યહોવા દેવ દ્વારા બનાવેલાં કોઈ પણ જંગલી પ્રાણી કરતાં સાપ વધારે કપટી હતો. (તે સ્ત્રીને દગો કરવા ઈચ્છતો હતો.) સાપે સ્ત્રીને કહ્યું, “હે સ્ત્રી, તમને દેવે ખરેખર એમ કહ્યું છે કે, તમાંરે બાગનાં કોઈ પણ વૃક્ષનાં ફળ ખાવાં નહિ?” ");
INSERT INTO guj2009_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","સ્ત્રીએ સાપને કહ્યું, “ના, દેવે એવું કહ્યું નથી. અમે બાગનાં વૃક્ષોનાં ફળ ખાઈ શકીએ છીએ. ");
INSERT INTO guj2009_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","પણ એક વૃક્ષ છે જેનાં ફળ અમે ખાઈ શકતાં નથી. દેવે અમને કહ્યું છે કે, ‘બાગની વચ્ચોવચ્ચ જે વૃક્ષ છે તેનાં ફળ તમાંરે ખાવાં નહિ, તેમજ તેને અડવું પણ નહિ, નહિ તો મૃત્યુ પામશો.’” ");
INSERT INTO guj2009_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","પરંતુ સાપે સ્ત્રીને કહ્યું, “તમે મરશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","દેવને ખબર છે કે, જો તમે એ વૃક્ષનાં ફળો ખાશો તો તમને ખરાખોટાની સમજ પડશે અને તમે દેવ જેવા થઈ જશો.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","સ્ત્રીએ જોયું કે, વૃક્ષ સુંદર છે અને તેનાં ફળ પણ ખાવા માંટે સારાં છે અને વૃક્ષ તેને બુદ્વિશાળી બનાવશે. પછી સ્ત્રીએ તે વૃક્ષનું ફળ લીધું અને ખાધું. તેનો પતિ પણ તેની સાથે હતો, તેથી તેણીએ થોડાં ફળ તેને પણ આપ્યાં અને તેણે પણ તે ખાધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","પછી પુરુષ અને સ્ત્રી બંન્ને બદલાઈ ગયાં. અને તેઓની આંખો ઉઘડી ગઇ. તેઓેએે જોયું કે, તેઓ વસ્રહીન છે; એટલે તેમણે અંજીરીનાં પાંદડાં સીવીને પોતાના અંગ ઢાંકયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","પછી પેલા પુરુષ અને સ્ત્રીએ દિવસના ઠંડા પહોરમાં બાગમાં યહોવા દેવના ફરવાનો અવાજ સાભળ્યો. તેઓ બાગના વૃક્ષોમાં છુપાઈ ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","યહોવા દેવે બૂમ માંરીને મનુષ્યને પૂછયું, “તું કયાં છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","પુરુષે કહ્યું, “બાગમાં તમાંરો પગરવ સાંભળીને હું ડરી ગયો, હું વસ્રહીન હતો, એટલે સંતાઈ ગયો.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","યહોવા દેવે પુરુષને પૂછયું, “તને કોણે કહ્યું કે, તું વસ્રહીન છે? તું શા કારણે શરમાંયો? જે ઝાડનાં ફળ ખાવાની મેં મનાઈ કરી હતી તે ઝાડનાં ફળ તેં ખાધાં તો નથી ને?” ");
INSERT INTO guj2009_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","પુરુષે કહ્યું, “તમે જે સ્ત્રી માંરા માંટે બનાવી, તેણે મને એ વૃક્ષનાં ફળ આપ્યાં, ને મેં ખાધાં.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","પછી યહોવા દેવે સ્ત્રીને કહ્યું, “તેં આમ શા માંટે કર્યું?” સ્ત્રીએ કહ્યું, “સાપે માંરી સાથે બનાવટ કરી, તેણે મને મૂર્ખ બનાવી અને મેં ફળ ખાધું.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","પછી યહોવા દેવે સર્પને કહ્યું: “તેં આ ઘણું ખરાબ કામ કર્યું છે, તેથી તારું ખોટું જ થશે. બીજા જંગલનાં પ્રાણીઓ કરતાં તારું ભૂંડું વધારે થશે. તારે જીવનપર્યંત પેટ ઘસડીને ચાલવું પડશે, અને ધૂળ ફાકીને રહેવું પડશે. ");
INSERT INTO guj2009_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","હું તારી અને આ સ્ત્રીની વચ્ચે અને તારાં બાળકો અને એનાં બાળકો વચ્ચે દુશ્મનાવટ રખાવીશ. એનો વંશ તારું માંથું કચરશે અને તું એના પગને કરડીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","પછી યહોવા દેવે સ્ત્રીને કહ્યું, “તારે ગર્ભાવસ્થા દરમ્યાન ભારે વેદના વેઠવી પડે એમ હું કરીશ. તું જયારે બાળકને જન્મ આપીશ ત્યારે તને અસહ્ય વેદના થશે. તું તારા પતિને ખૂબ ઈચ્છીશ પણ તે તારા પર રાજ કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","પછી યહોવા દેવે મનુષ્યને કહ્યું: “મેં તને આજ્ઞા કરી હતી કે, તું આ વિશિષ્ટ વૃક્ષનાં ફળ ખાઈશ નહિ, પરંતુ તેં તારી પત્નીની વાત માંની અને તે વૃક્ષનાં ફળ ખાધાં. એટલે તારે લીધે આ ભૂમિ શ્રાપિત થઈ છે. જીવનપર્યંત પરિશ્રમ કરીશ ત્યારે તું એમાંથી ખાવા પામીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","આ ભૂમિ કાંટા અને ઝાંખરાં ઉગાડશે. તું ખેતરમાં ઉગતા જંગલી છોડવાં ખાઇશ. ");
INSERT INTO guj2009_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","તારે તારા પોતાનાં ભોજન માંટે ખૂબ પરિશ્રમ કરવો પડશે. જયાં સુધી પરસેવો ન થાય ત્યાં સુધી તું પરિશ્રમ કરીશ. જયાં સુધી તારું મૃત્યુ ન થાય ત્યાં સુધી તું સખત પરિશ્રમ કરીશ. તે સમયે તું ફરીવાર માંટી થઈ જઈશ. જયારે મેં તને બનાવ્યો ત્યારે માંટીમાંથી જ બનાવ્યો હતો. અને જયારે તું મૃત્યુ પામીશ ત્યારે એ જ માંટીમાં પાછો મળી જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","આદમે પોતાની પત્નીનું નામ હવા પાડયું. કારણ કે તે સર્વ માંનવજીવોની જનેતા હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","પછી યહોવા દેવે આદમ અને તેની પત્ની માંટે પશુઓનાં ચામડાનાં વસ્રો બનાવ્યાં અને તેઓને પહેરાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","યહોવા દેવે કહ્યું, “જુઓ, હવે માંણસ આપણામાંના એકના જેવો થઈ ગયો છે; મનુષ્યને સારાનરસાની સમજ આવી છે. અને હવે પુરુષ જીવનના વૃક્ષનાં ફળ પણ લઈ શકે, છે. જો પુરુષ તે ફળને ખાશે તો તે સદા અમર થઈ જશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","આથી યહોવા દેવે પુરુષને એદનના બાગને છોડવા માંટે મજબૂર કર્યો, જે માંટીમાંથી આદમ પેદા થયો હતો તે જ પૃથ્વી પર આદમને સખત પરિશ્રમ કરવો પડ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","યહોવા દેવે આદમને બાગની બહાર કાઢી મૂકયો. અને પછી દેવે બાગના દરવાજાની ચોકી કરવા માંટે સ્વર્ગના દૂતોને મૂકયા. યહોવા દેવે ત્યાં એક અગ્નિમય સતત વીંઝાતી તરવાર પણ મૂકી, જે તરવાર જીવનના વૃક્ષના માંર્ગની ચોકી કરતી ચારેબાજુએ ચમકતી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","આદમ અને તેની પત્ની હવા વચ્ચે જાતિય સંબંધ થયો અને તે ગર્ભવતી થઈ અને એક બાળકને જન્મ આપ્યો. જેનું નામ તેઓએ “કાઈન” રાખ્યું. હવાએ કહ્યું, “યહોવાની સહાયથી મને પુત્ર મળ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","એ પછી હવાએ બીજા બાળકને જન્મ આપ્યો. તે બાળક “કાઈન” નો ભાઈ હાબેલ હતો. હાબેલ ભરવાડ બન્યો અને કાઈન ખેડૂત બન્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","પાકના સમયે કાઈન યહોવા પાસે એક અર્પણ લાવ્યો, પોતાની જમીનમાં પેદા કરેલા અનાજમાંથી થોડું અનાજ તે લાવ્યો. પરંતુ હાબેલ પોતાનાં ઘેટા અને બકરાના સમૂહમાંથી થોડા પ્રાણીઓ લાવ્યો. હાબેલ પોતાના સૌથી શ્રેષ્ઠ ઘેટાં અને બકરાંનાં પહેલાં બચ્ચાં તેમની ચરબી સાથે લાવ્યો. યહોવાએ હાબેલ અને તેના અર્પણોનો સ્વીકાર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","પરંતુ યહોવાએ કાઈન તથા તેના અર્પણનો અસ્વીકાર કર્યો તેથી કાઈન ખૂબ ગુસ્સે થયો અને દુ:ખી થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","યહોવાએ કાઈનને પૂછયું, “તું કેમ રોષે ભરાયો છે? તારું મોંઢું ઉતરેલું કેમ દેખાય છે? ");
INSERT INTO guj2009_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","જો તું સારાં કામ કરીશ, તો માંરી નજરમાં તું યોગ્ય ઠરીશ. અને પછી હું તારો સ્વીકાર કરીશ. પરંતુ જો તું ખરાબ કામ કરીશ તો તે પાપ તારા જીવનમાં રહેશે. તારાં પાપો તને તેના વશમાં રાખવા ઈચ્છશે પરંતુ તારે તારાં પાપોને તારા પોતાના વશમાં રાખવા પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","કાઈને પોતાના ભાઈ હાબેલને કહ્યું, “ચાલો, આપણે બહાર મેદાનમાં જઈએ.” તેથી કાઈન અને હાબેલ મેદાનમાં ગયા. અને પછી કાઈને પોતાના ભાઈ પર હુમલો કર્યો અને તેની હત્યા કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","પછી યહોવાએ કાઈનને પૂછયું, “તારો ભાઈ હાબેલ કયાં છે?” કાઈને જવાબ આપ્યો, “હું નથી જાણતો, શું એ માંરું કામ છે કે, હું માંરા ભાઈની ચોકી કરું, ને સંભાળ રાખું?” ");
INSERT INTO guj2009_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","પછી યહોવાએ કહ્યું, “તેં આ શું કર્યું? તારા ભાઈનું લોહી ધરતીમાંથી મને પોકાર આપતા અવાજ જેવું છે ");
INSERT INTO guj2009_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","તેં તારા પોતાના ભાઈની હત્યા કરી છે. અને હવે તારા ભાઈનું રકત તારા હાથથી લેવાને જે ધરતીએ પોતાનું મોં ખોલ્યું છે, તેથી હવે હું આ ભૂમિને ખરાબ કરવાવાળી વસ્તુઓ હું ઉત્પન્ન કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ભૂતકાળમાં તેં વાવણી કરી હતી અને તે મોટા પ્રમાંણમાં ઊગી હતી. પરંતુ હવે તું એ જમીનને ખેડીશ ત્યારે એ તને પાક નહિ આપે; તારે પૃથ્વી પર રઝળતાં રખડતાં ફરવું પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ત્યારે કાઈને કહ્યું, “આ સજા સહન કરવી તે માંરા ગજા બહારની છે. ");
INSERT INTO guj2009_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","તમે મને આજે જમીનને ખેડવામાંથી હાંકી કાઢયો છે. એટલે માંરે તમાંરી આગળથી સંતાતા ફરવું પડશે, માંરે આ ભૂમિ પર રઝળતા રખડતાં ફરવું પડશે. અને પૃથ્વી પર માંરો વિનાશ થશે. અને જો કોઈ મનુષ્ય મને મળશે તો તે મને માંરી નાખશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ત્યારે યહોવાએ કાઈનને કહ્યું, “હું એમ થવા દઈશ નહિ. જો કોઈ તને માંરશે તો હું તે માંણસને સાતગણી કડક શિક્ષા કરીશ.” પછી યહોવાએ કાઈન પર એક નિશાન બનાવ્યું. એ નિશાન એમ દર્શાવતું હતું કે, કાઈનને કોઈ માંરે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","પછી કાઈન યહોવા પાસેથી ચાલ્યો ગયો. અને એદનની પૂર્વમાં આવેલા નોદની ભૂમિમાં રહેવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","કાઈને પોતાની પત્ની સાથે શારીરિક સંબંધ કર્યો જેથી તે ગર્ભવતી થઈ અને તેણે હનોખ નામના બાળકને જન્મ આપ્યો. કાઈને એક શહેર વસાવ્યું અને પોતાના પુત્રના નામ પરથી તેનું નામ હનોખ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","હનોખથી ઇરાદ જન્મ્યો અને ઇરાદથી મહૂયાએલ જન્મ્યો. મહૂયાએલથી મથૂશાએલ અને મથૂશાએલથી લામેખ જન્મ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","લામેખે બે સ્ત્રીઓ સાથે લગ્ન કર્યા. એક પત્નીનું નામ આદાહ અને બીજીનું નામ સિલ્લાહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","આદાહે યાબાલને જન્મ આપ્યો. જેઓ તંબુઓમાં રહે છે અને પશુપાલન કરે છે તેઓના તે પિતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","આદાહનો બીજો પુત્ર યૂબાલ પણ હતો. યૂબાલ યાબાલનો ભાઈ હતો. વીણા અને વાંસળી વગાડનારાઓનો તે પિતા હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","સિલ્લાહે તૂબાલ-કાઈનને જન્મ આપ્યો. તે કાંસાંનાં અને લોખંડનાં બધી જ જાતનાં ઓજારો બનાવનારાઓનો પિતા હતો. તૂબાલ-કાઈનની બહેનનું નામ નાઅમાંહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","લામેખે પોતાની પત્નીઓને કહ્યું: “આદાહ અને સિલ્લાહ, માંરી વાત સાંભળો. હે લામેખની પત્નીઓ માંરે જે કહેવું પડે છે તે કાળજીપૂર્વક સાંભળો. મને દુ:ખ પહોંચાડનાર એક માંણસને, મેં માંરી નાખ્યો છે. મને માંરતાં એક છોકરાને મેં માંરી નાખ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","કાઈનની હત્યાનો દંડ ઘણો ભારે હતો. તેથી માંરી હત્યાનો દંડ પણ તેનાથી વધારેને વધારે ભારે હશે. જો કાઇનનું વેર સાતગણું લેવાશે, તો લામેખનું જરૂર સિત્તોતેરગણું લેવાશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","આદમે હવા સાથે ફરીવાર જાતિય સંબંધ બાંધ્યો અને હવાએ બીજા એક પુત્રને જન્મ આપ્યો. તેઓએ તે બાળકનું નામ “શેથ” પાડયું. હવાએ કહ્યું, “દેવે મને બીજો પુત્ર આપ્યો છે. કાઈને હાબેલને માંરી નાખ્યો પરંતુ હવે ‘શેથ’ માંરી પાસે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","“શેથ”ને પણ એક પુત્ર હતો. એનું નામ “અનોશ” હતું. તે સમયે, લોકોએ યહોવાને પ્રાર્થના કરવાનું શરૂ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","આ પ્રકરણ આદમના પરિવારનો આ ઇતિહાસ છે. દેવે મનુષ્યને પોતાના સ્વરૂપમાં જ બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","દેવે એક પુરુષ અને એક સ્ત્રીને બનાવ્યાં. જે દિવસે દેવે એમને બનાવ્યા ત્યારે તેઓને આશીર્વાદ આપ્યા અને એમનું નામ આદમ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","જયારે આદમ 130 વર્ષનો થયો, ત્યારે તે એક બીજા બાળકનો પિતા બન્યો. તે પુત્ર બરાબર આદમ જેવો જ દેખાતો હતો. આદમે તે પુત્રનું નામ શેથ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","શેથના જન્મ પછી આદમ 800 વર્ષ સુધી જીવ્યો. તે સમય દરમ્યાન તેને બીજા પુત્ર અને પુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","આમ, આદમ એકંદરે 930 વર્ષ જીવ્યો, અને પછી મૃત્યુ પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","જયારે શેથ 105 વર્ષનો થયો, ત્યારે તેને ત્યાં અનોશનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","અનોશના જન્મ પછી શેથ 807 વર્ષ જીવ્યો અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","આમ, શેથનું એકંદરે આયુષ્ય 912 વર્ષનું હતું. પછી તેનું મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","અનોશ જયારે 90 વર્ષનો થયો, ત્યારે તેને ત્યાં કેનાન જન્મ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","કેનાનના જન્મ પછી અનોશ 815 વર્ષ જીવ્યો અને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","આમ, અનોશનું એકંદરે આયુષ્ય 905 વર્ષનું હતું. પછી તેનું મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","જયારે કેનાન 70 વર્ષનો થયો, ત્યારે તેને ત્યાં માંહલાલએલ જન્મ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","માંહલાલએલના જન્મ પછી કેનાન 840 વર્ષ જીવ્યો, અને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","આમ, કેનાનનું કુલ આયુષ્ય 910 વર્ષનું હતું ત્યારબાદ તેનું મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","જયારે માંહલાલએેલ 65 વર્ષનો થયો, ત્યારે તેને ત્યાં યારેદનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","યારેદના જન્મ પછી માંહલાલએલ 830 વર્ષ જીવ્યો, અને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","આમ, માંહલાલએલનું કુલ આયુષ્ય 895 વર્ષનું હતું. ત્યારબાદ તેનું મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","જયારે યારેદ 162 વર્ષનો થયો, ત્યારે તેને ત્યાં એક હનોખ નામનો બાળક જન્મ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","હનોખના જન્મ પછી યારેદ 800 વર્ષ જીવ્યો અને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","આમ, યારેદ કુલ 962 વર્ષ જીવ્યો અને પછી મરણ પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","જયારે હનોખ 65 વર્ષનો થયો ત્યારે તેને ત્યાં મથૂશેલાહનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","મથૂશેલાહના જન્મ પછી 300 વર્ષ સુધી “હનોખ” દેવની સાથે સાથે ચાલ્યો, અને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","આમ, હનોખ કુલ 365 વર્ષ જીવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","એક દિવસ હનોખ દેવની સાથે ચાલી રહ્યો હતો, ત્યારે તે એકદમ અદ્રશ્ય થઈ ગયો; કેમ કે, દેવે તેને લઇ લીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","જયારે મથૂશેલાહ 187 વર્ષનો થયો, ત્યારે તેને ત્યાં લામેખનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","લામેખના જન્મ પછી મથૂશેલાહ 782 વર્ષ જીવ્યો, ને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","આમ, મથૂશેલાહ કુલ 969 વર્ષ જીવ્યા પછી મરણ પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","જયારે લામેખ 182 વર્ષનો થયો, ત્યારે તે એક પુત્રનો પિતા બન્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","લામેખના પુત્રનું નામ નૂહ રાખ્યું. લામેખે કહ્યું, “અમે ખેડૂત લોકો ઘણી સખત મહેનત કરીએ છીએ કારણ કે દેવે ભૂમિને શ્રાપ આપ્યો છે. પરંતુ નૂહ અમને લોકોને મહેનતમાંથી દિલાસો આપશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","નૂહના જન્મ પછી લામેખ 595 વર્ષ જીવ્યો, ને તેને બીજા પુત્રપુત્રી થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","આમ, લામેખનું કુલ આયુષ્ય 777 વર્ષનું હતું; ત્યાર પછી તેનું મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","જ્યારે નૂહ 500 વર્ષનો થયો, ત્યારે તેને ત્યાં શેમ, હામ અને યાફેથનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","પૃથ્વી પર મનુષ્યોની વસતી વધતી ગઈ. અને તેમને ત્યાં પુત્રીઓ જન્મી. જયારે દેવના દીકરાઓએ જોયું કે, આ કન્યાઓ સુંદર છે એટલે તેઓએ તેમની ઈચ્છા પ્રમાંણે તેઓની સાથે લગ્ન કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","4","અને આ સ્ત્રીઓએ બાળકોને જન્મ આપ્યા. તે સમય દરમ્યાન અને તે પછી પણ પૃથ્વી પર નેફિલિમ વસતા હતા. તેઓ દેવના પુત્રો અને માંનવોની પુત્રીઓના જાતિય સંબંધથી જન્મ્યા હતા. તેઓ પ્રાચીનકાળના વિખ્યાત પુરુષો હતા. ત્યારે યહોવાએ કહ્યું, “માંરા આત્માંને હું કાયમ માંટે મનુષ્યો દ્વારા દુ:ખી નહિ થવા દઉં, કારણકે તેઓ આખરે તો મનુષ્યો જ છે. તેઓનું આયુષ્ય 120 વર્ષનું થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","યહોવાએ જોયું કે, પૃથ્વી પરના લોકો બહુ જ દુષ્ટ છે. યહોવાએ જોયું કે, સતત મનુષ્ય માંત્ર વાતો જ વિચારે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ત્યારે પૃથ્વી પર મનુષ્યોને ઉત્પન્ન કરવા માંટે તેમને ખૂબ દુ:ખ થયું. અને પસ્તાવો થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","આથી યહોવાએ કહ્યું, “મેં બનાવેલ પૃથ્વીના બધાં જ લોકોનો હું વિનાશ કરીશ. હું પ્રત્યેક વ્યકિત, પ્રાણી અને પૃથ્વી પર પેટે ચાલવાવાળા પ્રત્યેક પ્રાણીઓનો નાશ કરીશ. હું આકાશમાં ઊડનારાં પક્ષીઓનો પણ નાશ કરીશ. કારણ કે મને એ બાબતનું દુ:ખ છે કે, મેં આ બધું શા માંટે બનાવ્યું?” ");
INSERT INTO guj2009_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","પરંતુ પૃથ્વી પર યહોવાને પ્રસન્ન કરવાવાળી એક વ્યકિત હતી અને તેનું નામ નૂહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","નૂહના પરિવારની આ કથા છે. આખું જીવન નૂહ દેવને અનુસર્યો. તેના સમયમાં નૂહ એક પ્રામાંણીક માંણસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","નૂહને ત્રણ પુત્રો હતા: શેમ, હામ અને યાફેથ. ");
INSERT INTO guj2009_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","દેવે પૃથ્વી પર નજર કરી અને તેમણે જોયું કે, લોકોએ પૃથ્વીને ભ્રષ્ટ કરી દીધી છે. પ્રત્યેક જગ્યાએ ઉત્પાત દેખાતો હતો. લોકો પાપી અને દુરાચારી થઈ ગયા હતા. અને તેઓએ પૃથ્વી પર પોતાનું જીવન નષ્ટ કરી નાખ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","આથી દેવે નૂહને કહ્યું, “બધાં માંણસોએ પૃથ્વીને ક્રોધ અને હિંસાથી ભરી દીધી છે તેથી હું બધાં જ જીવિત પ્રાણીઓનો નાશ કરીશ. હું તેઓને પૃથ્વી પરથી દૂર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","તું તારા માંટે દેવદારના લાકડાનું એક વહાણ બનાવજે; તેમાં ઓરડીઓ બનાવજે. અને તેની અંદર અને બહાર ડામર ચોપડજે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“હું જે વહાણ બનાવડાવવા ઈચ્છું છું તેનું માંપ, લંબાઈ 300 હાથ, પહોળાઈ 50 હાથ અને ઊંચાઈ 30 હાથ રાખજે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","વહાણમાંથી 18 ઇંચ નીચે એક બારી રાખજે, અને વહાણની એક બાજુએ બારણું રાખજે. વહાણમાં ત્રણ માંળ રાખજે: નીચલો, વચલો અને ઉપલો. ");
INSERT INTO guj2009_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“હું તને જે કહી રહ્યો છું તે તું સમજ. હું આકાશ નીચેનાં બધાં જ પ્રાણીઓનો અને જીવોનો નાશ કરવા માંટે પૃથ્વી પર જળપ્રલય લાવનાર છું. આકાશની નીચેના તમાંમ જીવોનો હું નાશ કરીશ. પૃથ્વી પરનાં બધાં જ જીવો મરી જશે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","પણ હું તારી સાથે એક વિશિષ્ટ કરાર કરીશ. તારા પુત્રો, તારી પત્ની, અને તારા પુત્રોની પત્નીઓ પણ તારી સાથે વહાણમાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","વળી તારી સાથે દરેક જાતનાં પ્રાણીઓમાંથી બબ્બેને તું વહાણમાં લઈને આવજે એક નર અને એક માંદા. જેથી તેઓ તારી સાથે જીવતાં રહે. ");
INSERT INTO guj2009_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","પૃથ્વી પરના દરેક જાતના પક્ષીઓના જોડા પણ શોધો. અને દરેક જાતનાં પશુઓમાંથી તથા પેટે ચાલનારાં પ્રત્યેક જોડાંને પણ શોધો. પૃથ્વી પરના પ્રત્યેક પ્રકારના પ્રાણીઓના જોડામાં નર અને માંદા તમાંરી સાથે હશે. વહાણમાં તેઓને જીવતાં રાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","પૃથ્વી પરના તમાંમ પ્રકારનાં ખોરાકને પણ વહાણમાં લાવજે. એ ખોરાક તમને અને અન્ય પ્રાણીઓને ખાવા ચાલશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","નૂહે આ બધું જ કર્યું. નૂહે દેવની બધી જ આજ્ઞાઓનું પાલન કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","પછી યહોવાએ નૂહને કહ્યું, “મેં જોયું છે કે, આ સમયે પાપી લોકોમાં તું જ એક ન્યાયી વ્યકિત છે એટલે તું તારા પરિવારને ભેગો કર. અને તમે બધા વહાણમાં જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","પ્રત્યેક શુદ્ધ પ્રાણીઓની સાત સાત જોડ (સાત નર અને સાત માંદા) સાથે લઈ લો અને પૃથ્વીના બીજા અશુદ્વ પ્રાણીઓની એક એક જોડ જેમાં એક નર અને એક માંદા હોય તે લઈ લો. ");
INSERT INTO guj2009_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","હવામાં ઉડનારાં બધાં જ પક્ષીઓની સાત જોડ (સાત નર અને સાત માંદા) લઈ આવો. આથી આ બધાં જ પ્રાણીઓ પૃથ્વી પર જીવતા રહેશે. જયારે બીજા પ્રાણીઓ નાશ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","હવે હું સાત દિવસ પછી 40 દિવસ અને 40 રાત પૃથ્વી પર વરસાદ વરસાવીશ. અને મેં ઉત્પન્ન કરેલ એક એક જીવને હું પૃથ્વી પરથી ભૂંસી નાખીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","અને નૂહે યહોવાની બધી જ વાતો સ્વીકારી અને યહોવાની આજ્ઞા પ્રમાંણે કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","પૃથ્વી પર જળપ્રલય થયો, ત્યારે નૂહને 600 વર્ષ થયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","નૂહ અને તેનો પરિવાર જળપ્રલયથી બચવા માંટે વહાણમાં ચાલ્યા ગયાં. નૂહની પત્ની, તેના પુત્રો અને પુત્રવધૂઓ તેમની સાથે હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","દેવની નૂહને આજ્ઞા પ્રમાંણે, શુધ્ધ પ્રાણીઓ અને અશુધ્ધ પ્રાણીઓ અને પક્ષીઓ તથા પેટે ચાલનારા પ્રાણીઓએ દરેકમાંથી બે નર અને બે માંદા વહાણમાં નૂહ સાથે ચઢી ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","સાત દિવસ પછી પ્રલયનાં પાણી પૃથ્વી પર ફરી વળ્યાં. ધરતી પર વર્ષા થઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","બીજા મહિનાના સત્તરમાં દિવસે જયારે નૂહ 600 વર્ષની ઉમરનો હતો, જમીનમાંથી પાતાળના ઝરણાંઓ ફૂટી નીકળ્યાં. અને જમીનમાંથી પાણી વહેવા માંડયું. તે દિવસે પૃથ્વી પર ભારે વર્ષા થઈ. જાણે કે, આકાશની બારીઓ ઉઘડી ગઈ. 40 દિવસ અને 40 રાત સુધી પૃથ્વી પર વરસાદ વરસતો રહ્યો. બરાબર તે જ દિવસે નૂહ તેની પત્ની, તેના પુત્રો, શેમ, હામ, અને યાફેથ અને તેમની પત્નીઓ વહાણમાં ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","તેઓ તેમજ દરેક જાતનાં પૃથ્વી પરનાં પ્રાણીઓ વહાણમાં હતાં. દરેક જાતના પશુ, દરેક જાતનાં પેટે ચાલનારાં પ્રાણીઓ અને દરેક જાતનાં પક્ષી તેમજ પાંખવાળા જીવો વહાણમાં ચઢી ગયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","તે બધાં જ પ્રાણીઓ નૂહની સાથે વહાણમાં ગયાં હતા, દરેક પ્રકારના જીવિત જાનવરોનાં તે જોડાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","દેવની આજ્ઞા પ્રમાંણે બધાં જ પ્રાણીઓ જોડીમાં વહાણમાં ચઢી ગયા. તેઓના વહાણમાં આવી ગયા બાદ યહોવાએ તેની પાછળનો દરવાજો બંધ કરી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ચાળીસ દિવસ સુધી પૃથ્વી પર જળપ્રલય ચાલુ રહ્યો. પાણી વધતાં ગયાં. અને વહાણ પૃથ્વીથી અધ્ધર ઊંચકાવા લાગ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","પાણી ચઢતાં જ ગયા અને ખૂબ વધી ગયા, અને વહાણ પાણી ઉપર તરવા લાગ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","પાણી પૃથ્વી પર એટલા બધાં ચઢયાં કે, આકાશ નીચેના બધાં જ ઊંચા પર્વતો ઢંકાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","અને પાણી વધીને ઉંચામાં ઉંચા પર્વતોથી ઉપર 20 ફૂટ ચઢી ગયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","પૃથ્વી પરના બધાં જ જીવો મરી ગયા. દરેક પુરુષ અને સ્ત્રી મરી ગયાં. બધાં જ પક્ષીઓ અને બધી જ જાતનાં પ્રાણીઓ પણ મરી ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","આ રીતે દેવે પૃથ્વી પરના બધાંજ જીવિત, મનુષ્ય, બધાં જ પ્રાણી, બધાં જ પેટે ચાલનારાં જીવો અને બધાં જ પક્ષીઓનો નાશ કર્યો. એ બધાં જ પૃથ્વી પરથી ભૂંસાઈ ગયાં. માંત્ર નૂહ અને તેની સાથે વહાણમાં જેઓ હતાં તેઓ જ બચ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","અને 150 દિવસ સુધી જમીન લગાતાર પાણીથી ઢંકાયેલી રહી. ");
INSERT INTO guj2009_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","પરંતુ દેવ નૂહને ભૂલ્યા નહિ. દેવે નૂહ અને વહાણમાં તેની સાથે રહેનારાં બધાં જ પશુઓ અને પ્રાણીઓને યાદ રાખ્યા. દેવે પૃથ્વી પર પવન વહેતો કર્યો અને પાણી ઊતરી ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","આકાશમાંથી વરસતો વરસાદ બંધ થઈ ગયો. અને જમીનમાંથી નીચેથી વહેતાં પાણી પણ બંધ થઈ ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","પૃથ્વીને ડૂબાડનારાં પાણી પણ બરાબર પાછા હઠવાં લાગ્યાં. 150 દિવસ પછી પાણી ઓસરી ગયાં અને વહાણ પાછું જમીન પર આવી ગયું. ");
INSERT INTO guj2009_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","સાતમાં મહિનાના સત્તરમેં દિવસે વહાણ અરારાટના પર્વતો પર સ્થિર થઈ ગયું. ");
INSERT INTO guj2009_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","દશમાં મહિના સુધી પાણી ઓસરતાં ગયાં અને દશમાં મહિનાના પહેલા દિવસે પર્વતોનાં શિખરો દેખાવા લાગ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","વહાણમાં બનાવેલી બારીઓ નૂહે 40 દિવસ પછી ઉઘાડી. ");
INSERT INTO guj2009_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","અને નૂહે એક કાગડાને બહાર ઉડાડી મૂકયો. તે કાગડો જમીન પૂરી ન સુકાઈ ત્યાં સુધી આવજા કરતો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ત્યારપછી નૂહે પૃથ્વી પરથી પાણી ઉતરી ગયાં છે કે, કેમ તે જોવા માંટે એક કબૂતરને મોકલ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","કબૂતરને કયાંય આરામ કરવાની જગ્યા મળી નહિ કારણકે પૃથ્વી પર હજુ પાણી પથરાયેલું હતું. તેથી તે નૂહની પાસે વહાણમાં ઉડીને પાછું ફર્યું. નૂહે હાથ લંબાવ્યો તેને પકડયું અને વહાણમાં પાછું લાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","તેણે બીજા સાત દિવસ પછી ફરીથી પેલા કબૂતરને વહાણની બહાર મોકલ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","તે દિવસે બપોરે તે કબૂતર તેની પાસે પાછું આવ્યું, ત્યારે તેની ચાંચમાં જૈતૂનનું તાજુ પાંદડું હતું. એટલે નૂહ સમજી ગયો કે, પાણી પૃથ્વી પરથી ઓસરી ગયાં છે. ");
INSERT INTO guj2009_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","નૂહે સાત દિવસ પછી ફરીવાર કબૂતરને બહાર મોકલ્યું, પણ તે પાછું આવ્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","તે પછી નૂહે વહાણના દરવાજા ઉઘાડયા. ને જોયું કે, ધરતી કોરી હતી. નૂહના આયુષ્યના 601 વર્ષમાં પહેલા મહિનાની પહેલી તારીખે પૃથ્વી પરથી પાણી સુકાઈ ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","બીજા મહિનાની 27મી તારીખે પૃથ્વી કોરી થઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ત્યારે દેવે નૂહને કહ્યું: ");
INSERT INTO guj2009_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“હવે, વહાણને છોડો. તું, તારી પત્ની, તારા છોકરાઓ અને તારા છોકરાઓની પત્નીઓ સાથે વહાણમાંથી બહાર નીકળો. ");
INSERT INTO guj2009_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","તારી સાથે જે બધી જાતના જીવો, પંખીઓ અને પશુઓ તથા પૃથ્વી પર પેટે ચાલનારાં પ્રાણીઓ છે તે બધાંને પણ તારી સાથે બહાર લઈ આવ. જેથી તેઓ તેમનો વંશ વધારે અને પૃથ્વી પર વૃદ્વિ પામે.” ");
INSERT INTO guj2009_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","તેથી નૂહ, પોતાના પુત્રો, પત્ની, પુત્રવધૂઓ વગેરેની સાથે બહાર આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","બધાં જ પ્રાણીઓ, બધાં જ પેટે ચાલનારા જીવો અને બધાં જ પક્ષીઓ વહાણ છોડી બહાર આવ્યાં. બધાં જ પ્રાણીઓ નર અને માંદાનાં જોડાંમાંજ બહાર આવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","પછી નૂહે યહોવા માંટે એક વેદી બાંધી. તેણે કેટલાંક શુદ્ધ પક્ષીઓ અને કેટલાંક શુદ્ધ પ્રાણીઓમાંથી અમુક અમુક લઈને વેદી પર આહુતિ આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","યહોવા બલિની સુવાસથી પ્રસન્ન થયા તે મનોમન બોલી ઊઠયા કે, “મનુષ્ય નાનપણથી જ દુષ્ટ હોય છે, તેથી હું કદી મનુષ્યને કારણે ધરતીને શ્રાપ આપીશ નહિ, અને હું કદી પણ બધા જીવોનો અત્યારે કર્યો તેવો નાશ કરીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","જયાં સુધી આ પૃથ્વી રહેશે ત્યાં સુધી વાવણી અને લણણી, ઠંડી અને ગરમી, ઉનાળો અને શિયાળો અને દિવસ અને રાત ચાલુ જ રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","પછી દેવે નૂહ અને તેના પુત્રોને આશીર્વાદ આપ્યા અને તેમને કહ્યું કે, બાળકો પેદા કરો, અને તમાંરા લોકોથી પૃથ્વીને ભરી દો. ");
INSERT INTO guj2009_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","પૃથ્વી પરના બધા પ્રાણીઓ, આકાશમાં ઊડતાં બધાં પંખીઓ, જમીન પર પેટે ચાલનારા જીવો અને સમુદ્રમાંની બધી માંછલીઓ તમાંરા તાબામાં રહેશે અને તમાંરાથી બીશે. મેં તે બધાને તમાંરા હાથમાં સોંપ્યાં છે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ભૂતકાળમાં મેં તમને જેમ બધી લીલોતરી ખાવા માંટે આપી હતી, તેમ બધા જીવો પણ આપું છું; એકેએક જીવ તમાંરો ખોરાક બનશે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","હું તમને જયાં સુધી તે પ્રાણીમાં જીવ (લોહી) હોય ત્યાં સુધી તેને ન ખાવા આજ્ઞા કરું છું. ");
INSERT INTO guj2009_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","જો કોઈ તમાંરો પ્રાણ લેશે તો હું તેનો પ્રાણ લઈશ. પછી એ પશુ હોય કે, મનુષ્ય હોય; દરેક મનુષ્ય પાસે હું તેના માંનવબંધુના પ્રાણનો હિસાબ માંગીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“દેવે મનુષ્યને પોતાના સ્વરૂપમાં બનાવ્યો છે તેથી જો કોઈ માંણસનું લોહી રેડશે, તો તેનું લોહી માંણસ રેડશે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“અને હવે તમે સંતતિ પેદા કરો, વંશવેલો વધારો અને પૃથ્વી પર પુષ્કળ સંતાન પેદા કરો, વૃદ્વિ પામો.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","પછી દેવે નૂહ અને તેના પુત્રોને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“હવે હું તને અને તમાંરા વંશજોને વચન આપું છું. ");
INSERT INTO guj2009_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","હું તમાંરી સાથે અને તમાંરા વંશજો સાથે, અને તમાંરી સાથેના બધા જીવો સાથે-પક્ષીઓ, ઢોરો અને જંગલી પ્રાણીઓ-જે બધા તમાંરી સાથે વહાણમાંથી બહાર આવ્યાં છે તે બધાની સાથે કરાર કરું છું. ");
INSERT INTO guj2009_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","હું તમને વચન આપું છું કે, હવે પછી કદાપિ બધા જીવોનો જળપ્રલયથી નાશ નહિ થાય અને હવે પછી કદાપિ જળપ્રલય આવીને પૃથ્વીનો નાશ નહિ કરે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","અને દેવે કહ્યું, “તમાંરી તથા તમાંરી સાથેના બધા જીવોની સાથે હું જે કરાર કાયમ માંટે કરું છું તેની આ એંધાણી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","મેં વાદળોમાં મેઘધનુષ્ય બનાવ્યું છે. અને તે માંરી અને પૃથ્વી વચ્ચે થયેલ કરારની એંધાણી બની રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","જયારે હું પૃથ્વી પર વાદળાં લાવીશ અને તે વાદળોમાં મેઘધનુષ્ય દેખાશે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","એટલે માંરી અને તમાંરી તથા બધી જાતનાં પ્રાણીઓ વચ્ચે જે કરાર થયો છે તેની મને યાદ આવશે. અને પાણી કદી પ્રલયનું રૂપ ધારણ કરી બધા જીવોનો વિનાશ નહિ કરે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","જયારે હું ધ્યાનથી વાદળોમાં મેઘધનુષ્યને જોઈશ ત્યારે મને માંરી અને પૃથ્વી પરના બધા જીવો વચ્ચેનો કાયમનો કરાર યાદ આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","આ રીતે યહોવાએ નૂહને કહ્યું, “માંરી અને પૃથ્વી પરનાં બધા જીવો વચ્ચે મેં જે કરાર કર્યો છે, તેની આ એંધાણી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","નૂહના પુત્રો તેમની સાથે વહાણમાંથી બહાર આવ્યા. તેમનાં નામ શેમ, હામ અને યાફેથ હતા. (હામ તો કનાનનો પિતા હતો.) ");
INSERT INTO guj2009_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","એ ત્રણેય નૂહના પુત્રો હતા. અને દુનિયાના બધાજ લોકો આ ત્રણથી જ પેદા થયા. (વંશવેલામાંથી) ");
INSERT INTO guj2009_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","નૂહ પોતે ખેડૂત બન્યો. તેણે દ્રાક્ષની વાડી વાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","નૂહે તેમાંથી દ્રાક્ષારસ બનાવ્યો. અને તે પીધો પછી તે છાકટો બની ગયો અને પોતાનાં વસ્ર કાઢી નાંખી પોતાના તંબુમાં વસ્રહીન પડયો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","કનાનના બાપ હામે પોતાના બાપને વસ્રહીન જોયો એટલે તેણે બહાર જઈને પોતાના બે ભાઈઓને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ત્યારપછી શેમ અને યાફેથે એક ચાદર લઈ ખભા પરથી પીઠ પાછળ પકડી પાછે પગે ચાલતા તંબુમાં જઈ વસ્રહીન પિતાને ઓઢાડી દીધી. તેમને વસ્રહીન ન જોવા પડે એટલા માંટે મોં ફેરવીને ગયા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","પછી નૂહ ઊંઘીને ઊઠયો. તે દ્રાક્ષારસને કારણે સૂઈ રહ્યો હતો. જયારે નશો ઊતરી ગયો ત્યારે તેને ખબર પડી કે, નાના છોકરાએ શું કર્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","તેણે કહ્યું, “કનાનને માંથે શ્રાપ ઉતરો! તે પોતાના ભાઈઓનો ગુલામ થઈને રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","નૂહે એમ પણ કહ્યું, “શેમના દેવ યહોવાની સ્તુતિ થાઓ! કનાન શેમનો ગુલામ બનશે. ");
INSERT INTO guj2009_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","દેવ યાફેથને વધારે જમીન આપો. દેવ શેમના મંડપમાં રહે અને કનાન તેનો ચાકર બનશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","જળપ્રલય પછી નૂહ 350 વર્ષ જીવતો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","અને નૂહ પૂરાં 950 વર્ષની ઉમરે અવસાન પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","નૂહના પુત્રો શેમ, હામ અને યાફેથ હતા. જળપ્રલય પછી એ ત્રણે ઘણા પુત્રોના પિતા થયા. અહીં ત્રણેય ના પુત્રોની યાદી આપવામાં આવી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","યાફેથના પુત્રો હતા: ગોમેર, માંગોગ, માંદાય, યાવાન, તુબાલ, મેશેખ અને તીરાસ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ગોમેરના પુત્રો હતા: આસ્કનાજ, રીફાથ અને તોગાર્માંહ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","યાવાનના પુત્રો હતા: એલિશા, તાશીર્શ, કિત્તીમ, અને દોદાનીમ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ભૂમધ્ય-સમુદ્રની ચારે બાજુ અને તેના કાંઠા પ્રદેશમાં અને ટાપુઓમાં રહેનારા લોકો યાફેથના વંશજો જ હતા. પ્રત્યેક પુત્રને પોતાની ભૂમિ હતી. બધા પરિવારોનો વિકાસ થયો અને જુદા રાષ્ટો બની ગયાં. પ્રત્યેક રાષ્ટને પોતાની ભાષા હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","હામના પુત્રો હતા: કૂશ, મિસરાઈમ, પૂટ અને કનાન. ");
INSERT INTO guj2009_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","કૂશના પુત્રો હતા: સબા, હવીલાહ, સાબ્તાહ, રાઅમાંહ અને સાબ્તેકા. રાઅમાંહના પુત્રો હતા: શબા અને દદાન. ");
INSERT INTO guj2009_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","કૂશને નિમ્રોદ નામે એક પુત્ર હતો. નિમ્રોદ પૃથ્વી પર પહેલો મહાન યોદ્વો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","તે યહોવાની કૃપાથી એક મોટો શિકારી પણ હતો. અને તેથી જ લોકો કહે છે, “દેવ તમને નિમ્રોદ જેવા મોટા શિકારી બનાવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","શિનઆરના દેશમાં આવેલા બાબિલ, એરેખ, આક્કાદ અને કાલ્નેહમાં નિમ્રોદના રાજયની શરૂઆત થઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","નિમ્રોદ આશ્શૂરમાં પણ ગયો. ત્યાં તેણે નિનવેહ, રેહોબોથ-ઈર, કાલાહ અને ");
INSERT INTO guj2009_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","રેસેન નગરો વસાવ્યાં. રેસેન એ નિનવેહ અને મહાનગરી કાલાહ વચ્ચે આવેલું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","મિસરાઇમાંથી લૂદીમ, અનામીમ, લહાબીમ, નાફતુહીમ, ");
INSERT INTO guj2009_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","પાથરૂસીમ, કાસ્લુહીમ અને કાફતોરીમ ઊતરી આવેલા છે અને કાફતોરીમમાંથી પલિસ્તીઓ ઊતરી આવેલા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","કનાનને બે પુત્ર થયા: સૌથી મોટો સિદોન અને બીજો હેથ, તેઓ એ નામે ઓળખાતી પ્રજાઓના પૂર્વજો હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","કનાનના બીજા વંશજો: યબૂસીઓ, અમોરીઓ, ગિર્ગાશીઓ, ");
INSERT INTO guj2009_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","હિવ્વીઓ, આરકીઓ, સીનીઓ, ");
INSERT INTO guj2009_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","આરવાદીઓ, સમાંરીઓ અને હમાંથીઓ. પછી કનાનીઓની જુદીજુદી જાતિઓ ફેલાવા લાગી. ");
INSERT INTO guj2009_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","કનાનીઓની ભૂમિ ઉત્તરમાં સિદોનથી દક્ષિણમાં ગેરાર, પશ્ચિમમાં ગાઝાથી પૂર્વમાં સદોમ અને ગમોરાહ અને આદમાંહ અને સબોઇમથી લાશા સુધી વિસ્તરેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","આ બધા હતા હામના વંશજો. આ બધા પરિવારોની પોતપોતાની ભાષાઓ અને પોતપોતાના પ્રદેશો હતા. તે બધા જુદા જુદા રાષ્ટો થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","યાફેથનો મોટો ભાઈ શેમ હતો. શેમનો એક વંશજ હેબેર હિબ્રૂ લોકોનો પિતા હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","શેમના પુત્રો હતા: એલામ, આશુર, આર્પાકશાદ, લૂદ અને અરામ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","અરામના પુત્રો હતા: ઉસ, હૂલ, ગેથેર અને માંશ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","આર્પાકશાદને ત્યાં શેલાહ જન્મ્યો અને શેલાહને ત્યાં હેબેર. ");
INSERT INTO guj2009_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","હેબેરને બે પુત્રો હતા: એકનું નામ પેલેગ હતું, કારણ એના સમયમાં પૃથ્વીના લોકોમાં ભાગલા પડયા. એના ભાઈનું નામ યોકટાન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","યોકટાનના દીકરાઓ: આલ્મોદાદ, શેલેફ, હસાર્માંવેથ, યેરાહ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","હદોરામ, ઉઝાલ, દિકલાહ. ");
INSERT INTO guj2009_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ઓબાલ, અબીમાંએલ, શબા, ");
INSERT INTO guj2009_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ઓફીર, હવીલાહ, અને યોબાબ, એ નામે ઓળખાતી પ્રજાઓના પૂર્વજો હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","તેમનો પ્રદેશ મેશાથી પૂર્વના પહાડી પ્રદેશમાં આવેલા સફાર સુધી વિસ્તરેલો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","આ થયા શેમના વંશજો, જેઓના પરિવાર ભાષા, પ્રદેશ અને રાષ્ટના એકમોમાં વ્યવસ્થિત હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","એમના રાષ્ટો પ્રમાંણે, નૂહમાંથી ઊતરી આવેલા આ લોકો છે. વિનાશક જળપ્રલય પછી પૃથ્વીની બધી પ્રજાઓ નૂહના વંશજોમાંથી ઊતરી આવેલી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","જળપ્રલય પછી આખી પૃથ્વી પર એક જ ભાષા બોલાતી હતી. બધા લોકો એક સરખા જ શબ્દ-સમૂહોનો ઉપયોગ કરતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","લોકો પૂર્વમાંથી આગળ વધ્યા અને શિનઆરના મેદાનમાં આવી પહોચ્યા. અને ત્યાં જ ઠરીઠામ થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","લોકોએ એક બીજાને કહ્યું, “ચાલો, આપણે ઈંટો બનાવીએ અને ભઠ્ઠામાં પકવીએ.” આમ, લોકો પોતાના ઘર બનાવવા માંટે પથ્થરોની જગ્યાએ ઇટોનો ઉપયોગ કરવા લાગ્યા. તથા છોની જગ્યાએ ડામર વાપરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","પછી લોકોએ કહ્યું, “ચાલો, આપણે આપણા માંટે એક નગર બનાવીએ અને એક ગગનચુંબી ઇમાંરત ઊભી કરીએ. પછી આપણે લોકો નામના મેળવીશું. જો આપણે લોકો આમ કરીશું તો પૃથ્વી પર કદી વેરવિખેર થઈશું નહિ અને એક જ જગ્યાએ એક સાથે રહીશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ગગનચુંબી ઇમાંરત અને નગર જોવા માંટે યહોવા નીચે ઊતરી આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","યહોવાએ લોકોને આ બધું બાંધતા જોયા. તેથી તેમણે કહ્યું, “આ બધા લોકો એક છે, અને તેઓની ભાષા પણ એક જ છે. હું જોઉ છું કે, તેમની યોજનાઓ મુજબ કરવા માંટે તેઓ ભેગા થયા છે. આ તો ફકત તેઓ શું કરી શકે છે તેની શરુઆત છે અને હવે તેઓ જે કંઈ કરવા માંગે છે તે કરતાં એમને કોઈ રોકી શકશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","એટલા માંટે, ચાલો આપણે નીચે જઈએ અને એમની ભાષાને ગૂંચવી નાખીએ, જેથી તેઓ એકબીજાની ભાષા સમજી ન શકે.” ");
INSERT INTO guj2009_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","આથી યહોવાએ તે લોકોને તે જગ્યાએથી આખી પૃથ્વી પર વિખેરી નાખ્યા, અને તે લોકોએ શહેર બાંધવાનું છોડી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","તે એ જગ્યા હતી જયાં યહોવાએ આખી પૃથ્વીની ભાષાને ગૂંચવી નાખી હતી. આથી આ જગ્યાનું નામ બાબિલ પડયું. અને અહીંથી જ યહોવાએ એ લોકોને આખી પૃથ્વી પર વિખેરી નાખ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","આ શેમના પરિવારની કથા છે. વિનાશક જળપ્રલય પછીના બીજા વષેર્ શેમ જ્યારે 100 વર્ષનો હતો ત્યારે, તેને ત્યાં આર્પાકશાદનો જન્મ થયો હતો. આર્પાકશાદના જન્મ પછી ");
INSERT INTO guj2009_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","શેમ 500 વર્ષ જીવ્યો. અને તેને બીજા પુત્રપુત્રીઓ થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","આર્પાકશાદ જ્યારે 35 વર્ષનો હતો, ત્યારે તેને ત્યાં શેલાહનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","આર્પાકશાદ 403 વર્ષ જીવતો રહ્યો. અને તે અરસામાં તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","જયારે શેલાહ 30 વર્ષનો હતો, ત્યારે તેને ત્યાં હેબેરનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","હેબેરના જન્મ પછી શેલાહ 403 વર્ષ જીવ્યો, અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","જયારે હેબર 34 વર્ષનો હતો, ત્યારે તેને ત્યાં પેલેગનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","પેલેગના જન્મ પછી હેબેર 430 વર્ષ જીવતો રહ્યો અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","જયારે પેલેગ 30 વર્ષનો થયો, ત્યારે તેને ત્યાં “રેઉ” નો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","રેઉના જન્મ પછી પેલેગ 209 વર્ષ જીવ્યો, અને તેને બીજા પુત્રપુત્રીઓ થયાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","જયારે રેઉ 32 વર્ષનો થયો, ત્યારે તેને ત્યાં સરૂગનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","સરૂગના જન્મ પછી રેઉ 207 વર્ષ જીવ્યો અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","જયારે સરૂગ 30 વર્ષનો હતો, ત્યારે તેને ત્યાં નાહોર જન્મ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","નાહોરના જન્મ પછી સરૂગ 200 વરસ જીવ્યો અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","જયારે નાહોર 29 વર્ષનો થયો, ત્યારે તેના પુત્ર “તેરાહ”નો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","તેરાહના જન્મ પછી નાહોર 119 વર્ષ જીવ્યો. અને તેને બીજા પુત્રપુત્રીઓ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","જયારે તેરાહ 70 વર્ષનો થયો, ત્યારે તેને ત્યાં ઇબ્રામ, નાહોર અને હારાનનો જન્મ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","આ તેરાહના પરિવારની કથા છે. તેરાહને ત્યાં ઇબ્રામ, નાહોર અને હારાન જન્મ્યા હતાં. હારાન લોતનો પિતા હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","હારાન તેની જન્મભૂમિ કાસ્દીઓના “ઉર” નગરમાં મૃત્યુ પામ્યો. જયારે હારાન મૃત્યુ પામ્યો ત્યારે તેનો પિતા “તેરાહ” જીવતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ઇબ્રામ અને નાહોર બંન્નેએ લગ્ન કર્યા. ઇબ્રામની પત્નીનું નામ સારાય હતું. અને નાહોરની પત્નીનું નામ મિલ્કાહ હતું. મિલ્કાહ હારાનની પુત્રી હતી. હારાનને યિસ્કાહ નામે બીજો એક પુત્ર હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","સારાય વાંઝણી હતી. એને કોઈ સંતાન નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","તેરાહએ પોતાના પરિવારને સાથે લીધો અને કાસ્દીઓના “ઉર” નગરને છોડી દીધું. તેઓએ કનાન યાત્રા કરવાની ઈચ્છા પ્રદશિર્ત કરી. તેરાહએ પોતાના પુત્ર ઇબ્રામ, પોતાનો પૌત્ર લોત (હારાનનો પુત્ર) પોતાની પુત્રવધૂ (ઇબ્રામની પત્ની) સારાયને સાથે લીધા. તેઓએ હારાન સુધીની યાત્રા તો કરી અને ત્યાં જ રહેવાનું નક્કી કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","તેરાહ 205 વર્ષ જીવ્યો પછી હારાનમાં અવસાન પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","યહોવાએ ઇબ્રામને કહ્યું, “તું તારો દેશ, તારા સગાંસંબંધી, અને તારા પિતાના પરિવારને છોડી દે અને હું બતાવું તે દેશમાં ચાલ્યો જા. ");
INSERT INTO guj2009_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","હું તને આશીર્વાદિત કરીશ. હું તને એક મહાન રાષ્ટ બનાવીશ. હું તારા નામને પ્રસિધ્ધ કરીશ. લોકો તારા નામ દ્વારા બીજાને આશીર્વાદ આપશે. ");
INSERT INTO guj2009_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","જે લોકો તારું ભલું કરશે તે લોકોને હું આશીર્વાદ આપીશ. પરંતુ જેઓ તને શ્રાપ આપશે તેઓને હું શાપ દઈશ. પૃથ્વી પરના બધા મનુષ્યોને આશીર્વાદ આપવા માંટે હું તારો ઉપયોગ કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ઇબ્રામે યહોવાની આજ્ઞાનો સ્વીકાર કર્યો. તેણે હારાન છોડયું. અને લોત તેની સાથે ગયો. તે સમયે ઇબ્રામ 75 વર્ષનો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ઇબ્રામે જયારે હારાન છોડયું ત્યારે તે એકલો ન હતો. ઇબ્રામે પોતાની પત્ની સારાયને અને પોતાના ભાઈના દીકરા લોતને હારાનમાં હતા ત્યારે તેમણે ભેગી કરેલી બધી સંપત્તિને તથા તેમણે રાખેલા બધા નોકરોને સાથે લીધાં અને તેઓ કનાન દેશ જવા નીકળ્યાં અને ત્યાં પહોંચ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ઇબ્રામે કનાનના પ્રદેશમાં થઇને શખેમ નગર સુધી યાત્રા કરી. અને મોરેહના મોટા વૃક્ષ સુધી ગયો. એ સમયે તે દેશમાં કનાની લોકો વસતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","યહોવાએ ઇબ્રામને દર્શન આપીને કહ્યું કે, “હું આ દેશ તારા વંશજોને આપીશ.” આથી યહોવા ઇબ્રામ સામે જે જગ્યાએ પ્રગટ થયો તે જગ્યાએ ઇબ્રામે યહોવાની ઉપાસના માંટે એક વેદી બંધાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","તે પછી ઇબ્રામે તે જગ્યા છોડી અને તે બેથેલની પૂર્વમાં આવેલા પહાડી પ્રદેશમાં ગયો અને ત્યાં સ્થાયી થયો. પશ્ચિમમાં બેથેલ શહેર અને પૂર્વમાં આય શહેર હતુ, અને ત્યાં તેણે યહોવાને માંટે બીજી એક વેદી બંધાવી. અને ઇબ્રામે યહોવાની પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ત્યાંથી ઇબ્રામે ફરી યાત્રાનો આરંભ કર્યો અને નેગેબ તરફ આગળ વધ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","તે દિવસો દરમ્યાન દેશમાં દુકાળ હતો. વરસાદ પડતો ન હતો અને કોઇ પણ જાતનું અનાજ ઊગતું ન હતું. તેથી ઇબ્રામ જીવતો રહેવા માંટે થોડા સમય માંટે મિસર ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ઇબ્રામે જોયું કે, તેની પત્ની સારાય દેખાવમાં રૂપાળી હતી, તેથી મિસરમાં પ્રવેશ કરતાં પહેલા ઇબ્રામે સારાયને કહ્યું, “હું જાણું છું કે, તું દેખાવમાં બહુ રૂપાળી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","મિસરના લોકો તને જોશે એટલે કહેશે કે, ‘આ સ્ત્રી તેની પત્ની છે.’ અને પછી મને તેઓ માંરી નાખશે અને તને જીવતી રાખશે કારણકે તેઓ તને મેળવવા ઈચ્છશે. ");
INSERT INTO guj2009_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","એટલા માંટે તું લોકોને કહેજે કે, તું માંરી બહેન છે તેથી તે લોકો મને માંરશે નહિ. તેઓ માંરા પર દયા કરશે કારણકે તે લોકો સમજશે કે, હું તારો ભાઈ છું. જેથી તારા કારણે એ લોકો માંરી સાથે સારો વ્યવહાર રાખશે. આ રીતે તું માંરો જીવ બચાવી શકીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","આ રીતે ઇબ્રામ મિસર પહોંચ્યો. મિસરવાસીઓએ જોયું કે, સારાય એક ખૂબ રૂપાળી સ્ત્રી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","મિસરના કેટલાક અધિકારીઓએ પણ તેને જોઈ. તે અધિકારીઓ તે સ્ત્રીને ફારુનના ઘરમાં લઈ ગયા. અને તેનાં વખાણ કર્યા કે, તે સ્ત્રી ખૂબ રૂપાળી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ફારુન ઇબ્રામ પ્રત્યે દયાળુ હતો કારણ કે તે સારાયનો ભાઈ છે એમ તેણે ભાળ્યું હતું. અને એ સ્ત્રીને કારણે ફારુન ઇબ્રામ સાથે સારું વત્ર્યો અને તેને ઘેટાં, બકરાં, ઢોરઢાંખર, ગધેડાઓ, ગુલામો અને ઊટો આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ફારુને ઇબ્રામની પત્નીને રાખી તેથી યહોવાએ ફારુન અને તેના પરિવારના માંણસો પર ખરાબ બિમાંરીઓ ફેલાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","તેથી ફારુને ઇબ્રામને બોલાવીને કહ્યું, “તેં માંરી સાથે બહુજ ખોટું કર્યું છે. તેં મને કેમ કહ્યું નહિ કે, સારાય તારી પત્ની છે? ");
INSERT INTO guj2009_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","તેં એમ શા માંટે કહ્યું કે, ‘એ માંરી બહેન છે?’ મેં એને એટલા માંટે રાખી કે, તે માંરી પત્ની થશે. પરંતુ હવે હું તને તારી પત્ની પાછી આપું છું તેને લઈ જા.” ");
INSERT INTO guj2009_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","પછી ફારુને પોતાના પુરુષોને આજ્ઞા કરી કે, ઇબ્રામને મિસરની બહાર પહોંચાડી દો. આમ, ઇબ્રામ અને તેની પત્નીએ તે જગ્યા છોડી. અને જે વસ્તુઓ પોતાની હતી તે પોતાની સાથે લઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ઇબ્રામે મિસર છોડયું. તે પોતાની પત્ની અને પોતાનો બધો સામાંન સાથે લઈને મિસરથી નેગેબ તરફ પાછો ગયો. લોત પણ તેની સાથે હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","તે સમયે ઇબ્રામ ઘણો ધનવાન હતો. તેની પાસે ઘણાં પશુઓ, પુષ્કળ રૂપું તથા સોનુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ઇબ્રામ બધી બાજુ પ્રવાસ કરતો રહ્યો. તે નેગેબથી મજલ કરતાં કરતાં બેથેલ નજીક, જે સ્થળે એમણે શરૂઆતમાં બેથેલ અને આય વચ્ચે મુકામ કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","એ એ જ જગ્યા હતી જયાં ઇબ્રામે પહેલાં વેદી બાંધી હતી. ત્યાં સુધી તેઓ ગયા અને ત્યાં તેમણે યહોવાની પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","તે સમય દરમ્યાન લોત પણ ઇબ્રામ સાથે પ્રવાસ કરી રહ્યો હતો. લોત પાસે પણ મોટી સંખ્યામાં ઢોરઢાંખર ઘેટાંબકરાં તથા તંબુઓ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ઇબ્રામ અને લોતની પાસે એટલા બધાં ઢોરઢાંખર હતાં કે, તે ભૂમિ એક સાથે તે બધાને ઘાસચારો પૂરો પાડી શકે નહિ, એ પ્રદેશ એવો હતો કે, તે બંન્ને એક સાથે રહીને ગુજારો ન કરી શકે. ");
INSERT INTO guj2009_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ઇબ્રામ અને લોતના ગોવાળો વચ્ચે અંદરો અંદર ઝગડા ચાલતા હતા. તે દિવસો દરમ્યાન કનાનીઓ અને પરિઝીઓ એ પ્રદેશમાં રહેતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ઇબ્રામે લોતને કહ્યું, “માંરી અને તારી વચ્ચે તેમ જ માંરા ગોવાળ અને તારા ગોવાળ વચ્ચે ઝગડા થવા જોઈએ નહિ. આપણે બધા ભાઈઓ છીએ. ");
INSERT INTO guj2009_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","આપણે જુદા થઈ જવું જોઇએ. તારી આગળ આખો દેશ પડેલો છે. તું જો ડાબી બાજુ જઈશ, તો હું જમણી બાજુ જઈશ અથવા જો તું જમણી બાજુ જઈશ, તો હું ડાબી બાજુ જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","લોતે જ્યારે નજર ફેરવી તેને દેખાયુ કે યર્દન ખીણથી સોઆર સુધીનો સમગ્ર પ્રદેશ યહોવાના બગીચા જેવો લાગતો હતો. ત્યા ઘણુંજ પાણી હતું. તે મિસર જેવો સારો પ્રદેશ હતો. યહોવાએ સદોમ અને ગમોરાહનો નાશ કર્યો તે પહેલાં તે આવો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","તેથી લોતે પોતાને રહેવા માંટે યર્દનખીણનો પ્રદેશ પસંદ કર્યો. આમ બંન્ને એકબીજાથી જુદા પડયા. અને લોતે પૂર્વ તરફ પ્રયાણ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ઇબ્રામ કનાન પ્રદેશમાં રહ્યો અને લોત યર્દનખીણના નગરોમાં વસવા લાગ્યો, તેણે સદોમની દક્ષિણે મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","સદોમના લોકો ઘણા દુષ્ટ હતા; તેઓ હંમેશા યહોવાની વિરુધ્ધ ભયંકર પાપો આચરતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","જયારે લોત ચાલ્યો ગયો ત્યારે યહોવાએ ઇબ્રામને કહ્યું, “તારી ચારે બાજુ જો, તું જયાં ઊભો છે ત્યાંથી ઉત્તરમાં અને દક્ષિણમાં, પૂર્વમાં અને પશ્ચિમમાં નજર કર. ");
INSERT INTO guj2009_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","આ બધી જ ભૂમિ, જેને તું જુએ છે, તે હું તને અને તારા પછી તારા વંશજોને સદાને માંટે આપું છું. આ પ્રદેશ હમેશને માંટે હવે તમાંરો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","હું તારા વંશજોની સંખ્યા પૃથ્વીની રજ જેટલી અસંખ્ય બનાવી દઈશ. જો કોઈ વ્યકિત પૃથ્વીની રજને ગણી શકે તો જ તારા વંશજોને ગણી શકે. ");
INSERT INTO guj2009_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","એટલા માંટે ઊઠ, તારા પ્રદેશમાં એક છેડેથી બીજા છેડા સુધી ફરી વળ, કારણ કે હું એ પ્રદેશ તને આપી દેનાર છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","તેથી ઇબ્રામે પોતાનો તંબુ ખસેડ્યો અને તે હેબ્રોનમાં આવેલા માંમરેનાં વિશાળ એલોન વૃક્ષો પાસે રહેવા ગયો. ત્યાં ઇબ્રામે યહોવા માંટે એક વેદી બાંધી. ");
INSERT INTO guj2009_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","આમ્રાફેલ શિનઆરનો રાજા હતો. આર્યોખ એલ્લાસારનો રાજા હતો. કદોરલાઓમેર એલામનો રાજા હતો. અને તિદાલ ગોઈમનો રાજા હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","આ બધાં ચાર રાજાઓ સદોમના રાજા બેરા, ગમોરાહના રાજા બિર્શા, આદમાંહના રાજા શિનાબ, સબોઈમના રાજા શેમેબેર અને બેલાના, રાજા (બેલાને સોઆર પણ કહે છે). ");
INSERT INTO guj2009_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","એટલે કે, સોઆરના રાજા સાથે યુદ્વે ચડયા. આ પાંચ રાજાઓએ સિદ્દીમની ખીણમાં. (અર્થાત ખારા સમુદ્રમાં) સેનાઓ ભેગી કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","એમણે બાર વર્ષ સુધી કદોરલાઓમેરની સેવા કરી હતી. પરંતુ તેરમાં વષેર્ તે બધા તેની વિરુધ્ધ થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","તેથી ચૌદમાં વષેર્ કદોરલાઓમેર બીજા રાજાઓ સાથે તેમની વિરુધ્ધ લડવા માંટે આવ્યો. તેમણે રફીઓને લોકો આશ્તરોથ-કારનાઇમ, ઝુઝી લોકોને હામમાં, એમી લોકોને શાવેહ કિર્યાથાઈમમાં, ");
INSERT INTO guj2009_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","અને સેઇરનાં પર્વતીય પ્રદેશમાં રહેતા હોરી લોકોને એલપારાનમાં (જે રણની નજીક છે) હાંકી કાઢયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ત્યારપછી રાજા કદોલવિમેર પાછો ફર્યો અને એન-મિશ્પાટ એટલે કે, કાદેશ આવીને તેમણે અમાંલેકીઓના સમગ્ર પ્રદેશને તથા હાસસોનતામાંરમાં રહેતા અમોરીઓને પણ તાબે કર્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","તે સમય પછી સદોમનો રાજા, ગમોરાહનો રાજા, આદમાંહનો રાજા, સબોઈમનો રાજા અને બેલાનો એટલે કે, સોઆરનો રાજા, તેઓ બધા ભેગા મળીને પોતાના શત્રુઓ સામે લડવા માંટે ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","તેઓ સિદીમની ખીણમાં એલામના રાજા કદોરલાઓમેર તથા ગોઈમના રાજા તિદાલ. શિનઆરના રાજા આમ્રાફેલ અને એલ્લાસારના રાજા આર્યોખ સામે યુદ્વે ચઢવા તૈયાર થયા. ચાર રાજાઓ સામે પાંચ રાજાઓ લડી રહ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","સિદ્દીમની ખીણમાં ડામરથી ભરેલા અનેક ખાડાઓ હતા. અને સદોમ અને ગમોરાહના રાજાઓ ભાગતા હતા ત્યારે એ ખાડાઓમાં પડી ગયા. અને બાકીના ડુંગરાઓમાં નાસી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","સદોમ અને ગમોરાહની પાસે જે કંઈ હતું તેને તેના શત્રુઓએ લઈ લીધું. તેઓએ તેમનો આખો અન્નભંડાર અને માંલમિલકત લઈ લીધાં અને ચાલ્યા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ઇબ્રામના ભાઈનો પુત્ર લોત સદોમમાં રહેતો હતો, તેને શત્રુઓએ પકડી લીધો. તેની પાસે જે કાંઈ હતું તેને પણ દુશ્મનો લઈને ચાલ્યા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","પછી એક ન પકડાયેલા માંણસે ઇબ્રામ જે હિબ્રૂ હતો તેને આ બધાનો અહેવાલ આપ્યો. ત્યારે ઇબ્રામ અમોરી માંમરેનાં વિશાળ વૃક્ષો પાસે રહેતો હતો. માંમરે એશ્કોલ અને આનેરનો ભાઈ થતો હતો. તેઓએ ઇબ્રામને મદદ કરવા એક સંધિ કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","જ્યારે ઇબ્રામને ખબર પડી કે, પોતાના ભાઈને પકડી ગયા છે, ત્યારે તેણે પોતાના પરિવારના નીવડેલા 318 માંણસોને લઇને દાન સુધી તે લોકોનો પીછો પકડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","તે અને તેના લોકો ટોળીઓમાં વહેંચાઈ ગયા, દુશ્મન પર રાત્રે હુમલો કર્યો, તેમને હરાવ્યા અને દમસ્કની ઉત્તરે આવેલ હોબાહ સુધી તેમનો પીછો કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","અને ઇબ્રામ દુશ્મનો દ્વારા ચોરાયેલી બધી વસ્તુઓ પાછી લાવ્યા. અને પોતાના કુટુંબી લોતને તથા તેની માંલમત્તા અને સ્ત્રીઓ તેમજ બાકીના લોકોને પણ તે પાછા લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","કદોરલાઓમેરને અને તેની સાથેના રાજાઓને હરાવીને ઇબ્રામ પાછો આવ્યો ત્યારે સદોમનો રાજા તેને મળવા માંટે શાવેહની ખીણમાં, એટલે કે, રાજાની ખીણમાં સામો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","શાલેમનો રાજા મલ્ખીસદેક પણ ઇબ્રામને મળવા ગયો. મલ્ખીસદેક પરાત્પર દેવનો યાજક હતો. મલ્ખીસદેક રોટલી અને દ્રાક્ષારસ લઈને આવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","અને તેણે ઇબ્રામને આશીર્વાદ આપતાં કહ્યું: “પૃથ્વી અને આકાશના સર્જનહાર પરાત્પર દેવના આશીર્વાદ ઇબ્રામ પર ઊતરો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","તમને તમાંરા દુશ્મનોને હરાવીને પઢડવા માંટે મદદ કરનાર પરાત્પર દેવની આપણે સ્તુતિ કરીએ.” અને ઇબ્રામે યુદ્વ દરમ્યાન લધેલી બધી વસ્તુઓમાંથી તેને દશમો ભાગ આપ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","પદ્ધી સદોમના રાજાએ કહ્યું, “તમે આ બધી વસ્તુઓ પોતાની પાસે રાખી શકો છો. ફકત માંરા જે મૅંણસોને દુશ્મનો પઢડીને લઈ ગયા હતા તે મને સુપ્રત કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","પરંતુ ઇબ્રામે સદોમના રાજાને કહ્યું, “મેં પૃથ્વી અને આકાશના સર્જનહાર યહોવા, પરાત્પર દેવ સમક્ષ સમ લધા છે કે, ");
INSERT INTO guj2009_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","જે તમાંરી વસ્તુઓ છે તેમાંથી કંઈ પણ લઈશ નહિ. તારો એક તાંતણો કે, જોડાની વૅંધરી સુદ્વાં નહિ લઉ. હું એ નથી ઈચ્દ્ધતો કે, તું એમ કહે કે, ‘મેં ઇબ્રામને ધનવાન બનાવ્યો છે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","હું તો ફકત એ જ ભોજનનો સ્વીકાર કરીશ જે માંરા જુવાનોએ ખાધું છે. પરંતુ તમે બીજા લોકોને તેનો ભાગ આપો. આપણી લડાઈમાં જીતેલી વસ્તુઓ તમે લઈ લો અને તેમાંથી થોડીક આનેર એશ્કોલ અને માંમરેને આપો. આ લોકોએ લડાઈમાં મને મદદ કરી હતી.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","આ બધી ઘટનાઓ થઈ ગયા પછી એક દર્શનમાં ઇબ્રામને યહોવાની વાણી સંભળાઈ, દેવે કહ્યું, “ઇબ્રામ, ડરીશ નહિ ઇબ્રામ, હું તારી ઢાલ છું. હું તારું રક્ષણ કરીશ અને હું તને એક મોટો પુરસ્કાર આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","પરંતુ ઇબ્રામે કહ્યું, “હે યહોવા દેવ, એવું કશું જ નથી, જે તું મને આપશે અને તે મને પ્રસન્ન કરશે. કારણ કે માંરે પુત્ર નથી. હું તો આ વાંઝિયામહેણું લઈને જાઉં છું. અને માંરો દાસ અલીએઝેર દમસ્કનો છે, તે માંરા અવસાન બાદ માંરો વારસદાર થશે ને, તેને જ માંરું બધું મળશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ઇબ્રામે કહ્યું, “તું જ જોને, તેં મને કંઇ સંતાન આપ્યું નથી એટલે માંરા ઘરમાં જન્મેલો કોઇ ગુલામ માંરો વારસદાર થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","પછી યહોવાએ ઇબ્રામ સાથે વાતો કરી. દેવે કહ્યું, “તમાંરી માંલમિલકત તમાંરો આ દાસ નહિ મેળવે. તને એક પુત્ર થશે, ને તે જ તારી માંલમિલકત પ્રાપ્ત કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","પછી દેવ ઇબ્રામને બહાર લઈ ગયા. દેવે કહ્યું, “આકાશને જો, અસંખ્ય તારાઓને જો, એ એટલા બધા છે કે, તું ગણી શકે નહિ. ભવિષ્યમાં તારું કુટુંબ આટલું મોટું થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ઇબ્રામે દેવ પર વિશ્વાસ કર્યો અને દેવે એને તેના ન્યાયીપણા તરીકે, સ્વીકાર્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","દેવે ઇબ્રામને કહ્યું, “હું જ એ યહોવા છું જે તને આ ભૂમિનો માંલિક બનાવવા માંટે ખાલદીઓના ઉર શહેરમાંથી લઈ આવ્યો છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","પરંતુ ઇબ્રામે કહ્યું, “હે યહોવા, માંરા માંલિક, માંરે કેવી રીતે વિશ્વાસ કરવો કે, આ પ્રદેશ મને જ મળશે?” ");
INSERT INTO guj2009_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","પછી દેવે ઇબ્રામને કહ્યું, “આપણે એક કરાર કરીશું. માંરી આગળ એક ત્રણ વર્ષની બકરી, એક ત્રણ વર્ષની ગાય, એક ત્રણ વર્ષનો ઘેટો, એક હોલો અને એક કબૂતરનું બચ્ચું લઈ આવ.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ઇબ્રામ એ બધી વસ્તુઓ દેવની પાસે લાવ્યો. અને ઇબ્રામે તે પ્રાણીઓને માંરી નાખ્યાં. અને દરેકના વચ્ચેથી કાપીને તેણે બબ્બે ટુકડા કર્યા અને ટુકડાઓ સામસામે ગોઠવ્યા; પરંતુ પક્ષીઓને તેણે કાપ્યા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","થોડા સમય પછી એ માંસાહારી પક્ષીઓ વેદી પર ચઢાવેલા મૃત પ્રાણીઓને ખાવા માંટે તૂટી પડયા. પણ ઇબ્રામે તેમને ઉડાડી મૂકયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","પછી સૂરજ આથમતી વખતે ઇબ્રામ ભર ઊંઘમાં પડયો. ઘનઘોર અંધકાર એને ચારેબાજુથી ઘેરી વળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ત્યારે યહોવાએ ઇબ્રામને કહ્યું, “તારે એ બાબતો જાણી લેવી જોઈએ. તારા વંશજો વિદેશી બની જશે અને તેઓ એવા દેશમાં જશે જે એમનો નહિ હોય. તેઓ ત્યાં ગુલામ બનશે. 400 વર્ષ સુધી તેમના પર ભારે અત્યાચારો થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","હું તે રાષ્ટનો ન્યાય કરીશ અને તેમને સજા કરીશ અને પાછળથી તેઓ ઘણી માંલમિલકત લઈને ત્યાંથી બહાર નીકળશે. ");
INSERT INTO guj2009_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“તું ઘણું લાંબુ આયુષ્ય ભોગવીશ. તું શાંતિથી મૃત્યુ પામીશ અને તને તારા પૂર્વજોની સાથે દફનાવવામાં આવ્યો હશે. ");
INSERT INTO guj2009_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ચાર પેઢીઓ પછી તારા વંશજો આ પ્રદેશમાં પાછા આવશે. તે સમયે તમાંરા લોકો અમોરીઓને હરાવશે. અહીં રહેનારા અમોરીઓને સજા કરવા માંટે હું તમાંરા લોકોનો જ ઉપયોગ કરીશ. આ ઘટના ભવિષ્યમાં બનશે કારણ કે અમોરીઓના પાપનો ઘડો હજુ ભરાયો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","જયારે સૂર્યાસ્ત થયો અને ગાઢ અંધકાર આજુબાજુ બધેય છવાઈ ગયો, ત્યારે પણ મૃત પ્રાણીઓ જમીન પર પડેલાં હતાં, તે પ્રત્યેક પ્રાણી બે ટુકડાઓમાં કપાયેલા હતાં. તે વખતે એક ધુમાંડાનો સ્તંભ અને અગ્નિની મશાલ પ્રાણીઓના બે ભાગ વચ્ચે થઈને પસાર થઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","આ રીતે તે જ દિવસે યહોવાએ ઇબ્રામ સાથે કરાર કર્યો કે, “હું મિસરની નદીથી મહા નદી ફાત સુધીનો આખો પ્રદેશ – ");
INSERT INTO guj2009_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","એટલે કે, કેનીઓ, કનિઝીઓ, કાદમોનીઓ, ");
INSERT INTO guj2009_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","હિત્તીઓ, પરિઝીઓ, રફાઈઓ, ");
INSERT INTO guj2009_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","અમોરીઓ, કનાનીઓ, ગિર્ગાશીઓ અને યબૂસીઓનો પ્રદેશ તારા વંશજોને આપું છું. આમ, યહોવાએ ઇબ્રામને કહ્યું.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ઇબ્રામની પત્ની સારાયને કોઈ બાળક ન હતું. સારાયની પાસે હાગાર નામે એક મિસરી દાસી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","સારાયે ઇબ્રામને કહ્યું, “જુઓ, યહોવાએ મને કોઈ બાળક આપ્યું નથી તેથી તમે માંરી દાસીને રાખી લો. હું તેનાં બાળકને આપણું બાળક માંનીશ.” ઇબ્રામે પોતાની પત્નીનું કહ્યું માંની લીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","એટલે ઇબ્રામની પત્ની સારાયે પોતાની દાસી હાગારને પોતાના પતિ ઇબ્રામને પત્ની તરીકે આપી. તે વખતે ઇબ્રામને કનાનમાં રહેતાં 10 વર્ષ થયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","હાગાર ઇબ્રામથી ગર્ભવતી થઈ. જયારે તેને ખબર પડી કે, તે ગર્ભવતી હતી, ત્યારે તે પોતાની જાતને તેણીની શેઠાણી સારાય કરતાં વધારે સારી માંનવા લાગી. અને તેનો તિરસ્કાર કરવા લાગી. ");
INSERT INTO guj2009_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","પરંતુ સારાયે ઇબ્રામને કહ્યું, “માંરી દાસી મને નફરત કરે છે અને તે માંટે હું તમને દોષિત માંનું છું. મેં માંરી દાસી તમને આપી અને તેણીને જયારે ખબર પડી કે, તેણી ગર્ભવતી છે, ત્યારે તે મને તિરસ્કારવા લાગી. અમાંરા બેમાં કોણ સાચું છે એનો ન્યાય યહોવાએ કરવો જોઇએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","પરંતુ ઇબ્રામે સારાયને કહ્યું, “તું હાગારની શેઠાણી છે. તું તને ઠીક લાગે તેમ એની સાથે કરી શકે છે. તેથી સારાયએ હાગાર સાથે સખતાઈ કરવા માંડી, તેથી તેની દાસી નાસી ગઈ.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","રણપ્રદેશમાં શૂરને રસ્તે આવેલા ઝરણા પાસે હાગારને યહોવાનો દૂત મળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","દૂતે કહ્યું, “હાગાર, તું સારાયની દાસી છે. તું અહીં કયાંથી? તું કયાં જઇ રહી છે?” હાગારે કહ્યું, “હું માંરી શેઠાણી સારાય પાસેથી ભાગીને આવી છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","યહોવાના દૂતે તેણીને કહ્યું, “તું તારી શેઠાણી પાસે પાછી જા, અને તેની આજ્ઞા માંન.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","યહોવાના દૂતે તેને એ પણ કહ્યું, “હું તારો વંશવેલો એટલો બધો વધારીશ કે, તેની ગણતરી પણ થઈ શકશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","યહોવાના દૂતે એમ પણ કહ્યું, “તું અત્યારે ગર્ભવતી છે, અને તું એક પુત્ર જણીશ અને તેનું નામ ઇશ્માંએલ રાખીશ. કારણ કે યહોવાએ સાંભળ્યું છે કે, તારી સાથે ખરાબ વર્તાવ થયો છે, અને તે તારી મદદ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ઇશ્માંએલ જંગલી અને આઝાદ થશે. તે એક જંગલી ગધેડા જેવો થશે. તે એક ઠેકાણેથી બીજે ઠેકાણે જશે, તે બધા માંણસોનો વિરોધ કરશે. અને બધા માંણસો તેનો વિરોધ કરશે. તે એક જગ્યાએથી બીજી જગ્યાએ જશે. તે તેના ભાઈઓની પાસે તેનો પડાવ નાખશે. પરંતુ તે તેમની વિરુદ્ધ થશે. અને સામે થઈ જુદો રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","પછી યહોવાએ હાગાર સાથે વાતો કરી. તેણે પોતાની સાથે વાત કરનાર દેવને એક નવા નામથી પોકાર્યો. તેણે કહ્યું, “તમે તે યહોવા છો જે મને જુઓ છે.” “ખરેખર મને દેવના દર્શન થયા પછી હું જીવતી રહી છું!” ");
INSERT INTO guj2009_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","તેથી એ કૂવો બેર-લાહાય-રોઇનો કૂવો કહેવાયો. એ કૂવો કાદેશ અને બેરેદની વચમાં આવેલો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","પછી હાગારે ઇબ્રામથી એક પુત્રને જન્મ આપ્યો, અને ઇબ્રામે હાગારથી જન્મેલા પુત્રનું નામ ઇશ્માંએલ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","જયારે ઇબ્રામથી હાગારે ઇશ્માંએલને જન્મ આપ્યો ત્યારે, ઇબ્રામની ઉંમર 86 વર્ષની હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","જયારે ઇબ્રામ 99 વર્ષનો થયો, ત્યારે યહોવાએ તેને દર્શન આપીને કહ્યું, “હું સર્વસમર્થ દેવ છું. માંરા માંટે આ કામ કર. માંરી આજ્ઞા માંથે ચઢાવી કોઈ પણ દોષમાં પડયા વિના ચાલ. ");
INSERT INTO guj2009_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","જો તું આમ કરીશ, તો હું તારી અને માંરી વચ્ચે કરાર કરીશ. હું તમાંરા લોકોનું એક મોટું રાષ્ટ બનાવવાનું વચન આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ઇબ્રામે પોતાનું મસ્તક જમીન તરફ નમાંવ્યું, સાષ્ટાંગ દંડવત પ્રણામ કર્યા. ત્યારે દેવે તેની સાથે વાતચીત કરી અને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“જો, હું તારી સાથે આ કરાર કરું છું; તું અનેક પ્રજાઓનો પિતા થઈશ. ");
INSERT INTO guj2009_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","હવેથી તારું નામ ઇબ્રામ નહિ રહે. તારું નામ ઇબ્રાહિમ રહેશે, કારણ મેં તને અનેક દેશનો પૂર્વજ બનાવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","હું તારા વંશજો ખૂબ ખૂબ વધારીશ, તારા વંશજોમાંથી હું પ્રજાઓનું નિર્માંણ કરીશ. અને તારા વંશમાં રાજાઓ થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","હું માંરી અને તારી વચ્ચે તથા પેઢી-દરપેઢી તારા વંશજો વચ્ચે કાયમનો કરારા કરીશ કે, તારો અને તારા પછી તારા બધા વંશજોનો હું દેવ થઈશ. ");
INSERT INTO guj2009_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","અને હું તને અને તારા વંશજોને જે ભૂમિમાં તું પ્રવાસ કરી રહ્યો છે તે કનાનની ભૂમિ કાયમને માંટે આપીશ અને હું તમાંરો દેવ રહીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","દેવે ઇબ્રાહિમને કહ્યું, “તું અને તારા પછી તારા વંશજો પેઢી દરપેઢી માંરો આ કરાર પાળશો. ");
INSERT INTO guj2009_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","માંરી અને તારી વચ્ચેનો તથા તારા પછી તારા વંશજો સાથેનો તમાંરે પાળવાનો કરાર આ છે: ");
INSERT INTO guj2009_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","તમાંરામાંના એકે એેક વ્યકિતની સુન્નત કરવી. તમાંરે તમાંરી ચામડીની સુન્નત કરવી. ");
INSERT INTO guj2009_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","જયારે બાળક 8 દિવસનું થાય ત્યારે તેની સુન્નત કરાવવી, પછી તે તમાંરા ઘરમાં જન્મેલો હોય કે, કોઈ પરદેશી પાસેથી પૈસા આપીને ખરીદેલો ગુલામ હોય. તેની સુન્નત અવશ્ય કરવાની રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","તમાંરા ઘરમાં જન્મેલો ગુલામ હોય, તેની તેમજ પૈસાથી જેને ખરીદવામાં આવ્યો હોય, તેની બંન્નેની સુન્નત કરાવવી જ જોઈએ. આ રીતે તમાંરા રાષ્ટમાં પ્રત્યેક બાળકની સુન્નત થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","આ માંરો નિયમ છે. અને તે માંરા અને તમાંરા વચ્ચે છે. જે કોઈની સુન્નત થયેલી ના હોય તેનો સમાંજમાંથી બહિષ્કાર કરવો, કારણ, તેણે માંરા કરારનો ભંગ કર્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","દેવે ઇબ્રાહિમને કહ્યું, “સારાય જે તારી પત્ની છે એને હું નામ આપીશ. તેનું નામ સારા રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","હું તેને આશીર્વાદ આપીશ. હું તેને પુત્ર આપીશ અને તું પિતા બનીશ. તે ઘણી નવી દેશજાતિઓની માંતા થશે. એને પેટે પ્રજાઓના રાજા જન્મ ધારણ કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","પછી ઇબ્રાહિમે સાષ્ટાંગ નમસ્કાર કરીને દેવની ભકિત દર્શાવી. અને મનમાં હસ્યો. તે મનોમન વિચારવા લાગ્યો, “હું તો 100 વર્ષનો વૃદ્વ છું. હું પુત્ર કેવી રીતે ઉત્પન્ન કરી શકું? અને સારા 90 વર્ષની વૃદ્વા છે, તે બાળકને જન્મ આપી શકે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","પછી ઇબ્રાહિમે દેવને તેના કહેવાનો હેતુ પૂછયો, “શું ઇશ્માંએલ જીવતો રહે અને તારી સેવા કરે?” ");
INSERT INTO guj2009_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","દેવે કહ્યું, “ના, મેં કહ્યુંને કે, તારી પત્ની સારાને તારાથી એક પુત્ર જરૂર અવતરશે. અને તારે તેનું નામ ઇસહાક પાડવું. હું તેની સાથે માંરો કરાર કરીશ અને તે તેના વંશજો માંટે પણ કાયમનો રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“તેં મને ઇશ્માંએલની બાબતમાં પૂછયું, અને મેં તારી વાત સાંભળી. હું તેને આશીર્વાદ આપીશ, તેને ઘણાં સંતાનો થશે. તે મોટા બાર સરદારોનો પિતા થશે. અને હું તેનાથી એક મોટી પ્રજાનું નિર્માંણ કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","પરંતુ હું માંરો કરાર તો આવતે વષેર્ ઠરાવેલ સમયે સારા ઇસહાકને જન્મ આપશે તેની સાથે કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","દેવે જયારે ઇબ્રાહિમ સાથે વાત કરવાની બંધ કરી ત્યારે તે એકલો જ રહ્યો કારણ કે દેવ તેની પાસેથી આકાશ તરફ ચાલ્યા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","દેવે કહ્યું હતું કે, તું તારા કુટુંબના બધા પુત્રોની તથા પુરુષોની સુન્નત કરાવજે. તેથી ઇબ્રાહિમે ઇશ્માંએલ તથા પોતાના ઘરમાં જન્મેલાં બધા તથા પૈસાથી ખરીદેલા બધા ગુલામોને એક સાથે બોલાવ્યા અને દેવના કહ્યા પ્રમાંણે બધા ગુલામોની સુન્નત કરાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ઇબ્રાહિમની સુન્નત થઈ, ત્યારે તેની ઉંમર 99 વર્ષની થઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","અને તેના પુત્ર ઇશ્માંએલની સુન્નત થઈ ત્યારે તે 13 વર્ષનો થયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ઇબ્રાહિમ તથા તેના પુત્ર ઇશ્માંએલની સુન્નત એક જ દિવસે થઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","તે જ દિવસે ઇબ્રાહિમના ઘરના તમાંમ પુરુષોની સુન્નત કરવામાં આવી હતી. તેના ઘરમાં જન્મેલા અને પરદેશીઓ પાસેથી પૈસા આપીને ખરીદેલા ઘરના બધા ગુલામોની સુન્નત પણ તેની સાથે કરવામાં આવી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","પછી ફરીથી યહોવા ઇબ્રાહિમ આગળ માંમરેનાં એલોનવૃક્ષો પાસે પ્રગટ થયા. તે દિવસે બપોરે, ઇબ્રાહિમ તેના તંબુના પ્રવેશદ્વાર આગળ બેઠો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ઇબ્રાહિમે આંખ ઊંચી કરીને જોયું, તો પોતાની સામે ત્રણ માંણસોને ઊભેલા જોયા. તે તેમની પાસે દોડતો દોડતો ગયો અને તેઓને પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ઇબ્રાહિમે કહ્યું, “માંરા સ્વામી, જો માંરા પર આપની કૃપાદૃષ્ટિ હોય, તો આ સેવકની સાથે થોડીવાર ઊભા રહો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","હું તમાંરા લોકોના ચરણો ધોવા માંટે પાણી લાવું છું. તમે પેલા વૃક્ષ નીચે આરામ કરો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","હું તમાંરા લોકો માંટે થોડું ભોજન લાવું છું. આપની ઈચ્છા હોય તેટલું આપ ખાઓ, તાજા થાઓ અને પછી તમે લોકો આગળની યાત્રાનો આરંભ કરો.” ત્રણેએ કહ્યું, “હા, એ ઘણું સારું છે. તું જેમ કહે છે તેમ ભલે કર.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ઇબ્રાહિમ ઉતાવળો ઉતાવળો તંબુમાં ગયો અને સારાને કહ્યું, “ઝટપટ ત્રણ માંપિયાં ઝીણો મેંદાનો લોટ લઈને ગૂંદીને રોટલી બનાવી નાખ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","પછી ઇબ્રાહિમ ઢોરના ધણ તરફ દોડતો દોડતો ગયો અને એક કુમળું વાછરડું લાવીને તેણે નોકરોને આપ્યો અને કહ્યું, “તમે આ વાછરડાને વધેરી ભોજન તૈયાર કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","પછી ઇબ્રાહિમ એ ત્રણેય ને ભોજન માંટે માંસ આપ્યું. અને દૂધ દહીં પણ પીરસ્યાં, જયાં સુધી એ ત્રણે જણ ખાતાં રહ્યાં ત્યાં સુધી ઇબ્રાહિમ તેમની પાસે વૃક્ષ નીચે ઊભો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","તે વ્યકિતઓએ ઇબ્રાહિમને કહ્યું, “તારી પત્ની સારા કયાં છે?” ઇબ્રાહિમે કહ્યું, “તે તંબુમાં છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ત્યારે યહોવાએ કહ્યું, “હું વસંતમાં આવતા વરસે પાછો આવીશ. તે સમયે તારી પત્ની સારા એક બાળકને જન્મ આપશે.” સારા તંબુમાં બારણા પાસે ઊભી રહીને આ વાતો સાંભળતી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ઇબ્રાહિમ અને સારા ઘણા વૃદ્વ થઈ ગયા હતા. સારાનો તો સ્ત્રીધર્મ પણ બંધ થઈ ગયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","એટલે સારા મનોમન હસી. તેને પોતાના પર વિશ્વાસ ન રહ્યો, તેણે પોતાની જાતને કહ્યું, “હું અને માંરો પતિ બંન્ને વૃદ્વ છીએ. હું બાળકને જન્મ આપવા માંટેની ઉમર વટાવી ચૂકી છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","યહોવાએ ઇબ્રાહિમને કહ્યું, “સારા હસીને કેમ બોલી કે, ‘મને બાળક જન્મશે ખરું?’ હું તો ઘરડી થઈ છું! ");
INSERT INTO guj2009_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","શું યહોવાને માંટે કશું અસંભવ છે? નહિ, હું ફરી વસંતમાં નક્કી કરેલા સમયે આવતા વષેર્ તારે ત્યાં જરૂર આવીશ. અને તારી પત્ની સારાના ખોળામાં પુત્ર રમતો હશે જ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","પરંતુ સારાએ કહ્યું, “હું હસી નહોતી.” (એણે એમ કહ્યું, કારણકે તે ડરી ગઈ હતી.) પરંતુ યહોવાએ કહ્યું, “ના, હું જાણું છું કે, તારું કહેવું સાચું નથી. તું સાચે જ હસી હતી.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","પછી તે પુરુષો જવા માંટે ઊઠયા, તેઓએ સદોમ તરફ નજર કરી અને તે તરફ ચાલી નીકળ્યાં. ઇબ્રાહિમ તેઓને વિદાય આપવા માંટે થોડે દૂર સુધી તેમની સાથે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","યહોવાએ વિચાર્યું, “જે હું હમણા કરવાનો છું તે શું ઇબ્રાહિમને કહી દઉં? ");
INSERT INTO guj2009_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ઇબ્રાહિમમાંથી એક મહાન અને શકિતશાળી પ્રજા ઉત્પન્ન થનાર છે. અને તેને કારણે પૃથ્વીની બધી પ્રજાઓ આશીર્વાદ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","મેં જ એને પસંદ કર્યો છે કે, જેથી એ પોતાનાં સંતાનોને અને પોતાના પછીના વંશજોને ધર્મ અને ન્યાયનું આચરણ કરીને યહોવાને માંગેર્ વળવાની આજ્ઞા કરે, અને એ રીતે ઇબ્રાહિમને આપેલું વચન હું પાળી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","પછી યહોવાએ કહ્યું, “મેં ઘણી વખત સાંભળ્યું છે કે, સદોમ અને ગમોરાહના લોકો ઘણાં જ ખરાબ છે, તે જગ્યાએથી આવતાં આર્તનાદનું કારણ તેઓ છે. તેમનાં પાપ ઘણા ગંભીર છે. ");
INSERT INTO guj2009_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","એટલા માંટેં હું ત્યાં જઈશ અને જોઈશ કે, મેં સાંભળ્યું છે તેટલી ખરાબ હાલત છે? પછી મને બરાબર ખબર પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","પછી તે લોકો ત્યાંથી નીકળીને સદોમ તરફ ગયા. પરંતુ ઇબ્રાહિમ હજુ પણ યહોવાની સામે ઊભો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","પછી ઇબ્રાહિમે યહોવાને કહ્યું, “હે યહોવા! તમે દુષ્ટ લોકોની સાથે સારા લોકોનો પણ નાશ કરવાનું ખરેખર વિચારો છો? ");
INSERT INTO guj2009_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","જો તે નગરમાં 50 સારા માંણસો હોય તો પણ તમે એ નગરનો નાશ કરશો? એ 50 સારા માંણસોને માંટે તમે નગરને બચાવી નહિ લો? ");
INSERT INTO guj2009_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","દુષ્ટોની સાથે સારા માંણસોને પણ માંરી નાખશો? એ તો તમને ના શોભે! તો તો સારા માંણસોની દશા પણ દુષ્ટોના જેવી જ થાય! એ તમને શોભે નહિ. હું જાણું છું આખી પૃથ્વીનો ન્યાય કરનાર સાચો ન્યાય કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ત્યારે યહોવાએ કહ્યું, “જો મને સદોમ નગરમાં 50 સારા લોકો મળશે તો, હું આખા નગરને બચાવી લઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ત્યારે ઇબ્રાહિમે કહ્યું, “હે યહોવા, તમાંરી સામે તો હું રાખ અને ધૂળ બરાબર છું. પરંતું તું મને થોડું વધારે કષ્ટ આપવાની તક આપ. અને મને એ પૂછવા દે. ");
INSERT INTO guj2009_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ધારો કે, સારા માંણસો પૂરા 45ના હોય, અને 5 ઓછા હોય તો એ પાંચને કારણે તમે આખા શહેરનો નાશ કરશો?” ત્યારે યહોવાએ કહ્યું, “જો મને ત્યાં 45 મળશે, તોપણ હું નાશ નહિ કરુ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ઈબ્રાહિમે ફરીથી યહોવાને કહ્યું, “ધારો કે, કદાચ તમને 40 સારા માંણસો મળે, તો શું તમે નગરનો નાશ કરશો?” યહોવાએ કહ્યું, “જો મને 40 સારા માંણસો મળશે તો પણ હું નગરનો નાશ કરીશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ત્યારે ઇબ્રાહિમે કહ્યું, “હે યહોવ, કૃપા કરીને માંરા પર નારાજ ના થશો. મને એમ પૂછવા દો, ધારો કે, નગરમાં માંત્ર 30 સારા લોકો મળ્યા, તો તમે શું નગરનો નાશ કરશો?” યહોવાએ કહ્યું, “જો મને 30 સારા માંણસો મળશે તોપણ હું તે નગરનો નાશ નહિ કરું.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ત્યારે ઇબ્રાહિમે કહ્યું, “હે યહોવા, હું તમને ફરીવાર તકલીફ આપીને પૂછું છું કે, ધારો કે, ત્યાં 20 જ સારા લોકો હોય તો?” યહોવાએ ઉત્તર આપ્યો, “જો મને 20 સારા માંણસો મળશે, તો પણ હું નગરનો નાશ નહિ કરું.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ત્યારે ઇબ્રાહિમે કહ્યું, “હે યહોવા, જો તમે ગુસ્સે ના થાવ તો આ છેલ્લી વાર પૂછું છું, ધારો કે ત્યાં દશ જ સારા માંણસો મળે તો તમે શું કરશો?” યહોવાએ કહ્યું, “જો મને નગરમાં માંત્ર 10 સારા માંણસો મળશે તો પણ હું નગરનો નાશ કરીશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","યહોવાએ ઇબ્રાહિમ સાથે બોલવાનું બંધ કરી દીધું, એટલે યહોવા ચાલ્યા ગયા; અને ઇબ્રાહિમ પોતાને ઘેર પાછો ફર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","તેમાંના બે દેવદૂતો સાંજે સદોમ નગરમાં આવ્યા ત્યારે લોત સદોમના દરવાજામાં બેઠો હતો. તેણે દેવદૂતોને જોયા. લોતે વિચાર્યું કે આ લોકો નગરમાંથી યાત્રા કરી રહ્યા છે, તેથી તેઓને મળવા ઊભો થયો અને તેમની પાસે જઈને સાષ્ટાંગ નમસ્કાર કરીને બોલ્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","તેણે કહ્યું “માંરા સ્વામીઓ, કૃપા કરીને માંરે ઘેર પધારો. હું તમાંરી સેવા કરીશ. તમાંરા ચરણ ધુઓ અને રાત વિશ્રામ કરો, પછી આવતીકાલે તમાંરી યાત્રા શરૂ કરજો.” દેવદૂતોએ કહ્યું “ના, અમે રામના ચોકમાં રાત વિતાવીશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","પરંતુ લોત પોતાને ઘરે પધારવા વારંવાર આગ્રહ કરતો હતો. એટલે તેઓ લોતને ઘેર જવા તૈયાર થયા. અને જયારે તેઓ લોતને ઘેર પહોચ્યાં ત્યારે લોતે પીવા માંટે કાંઈક આપ્યું. અને તેમના માંટે ખમીર વગરની રોટલી બનાવી. દેવદૂતોએ તે ખાધું. ");
INSERT INTO guj2009_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","તે સાંજે સૂવાના સમય પહેલા જ નગરના તમાંમ સ્થળોએથી લોકો લોતના ઘેર આવ્યા. સદોમના માંણસોએ લોતના ઘરને ઘેરી લીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","અને તેઓએ કહ્યું, “આજે રાત્રે જે બે માંણસો તારે ઘેર આવ્યા તેઓ કયાં છે? તે માંણસોને બહાર કાઢ અને અમને સુપ્રત કર. અમે એમની સાથે સંભોગ કરવા માંગીએ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","લોતે બહાર નીકળીને પોતાની પાછળથી બારણું બંધ કરી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","લોતે લોકોને કહ્યું, “ના, માંરા ભાઈઓ, હું વિનંતી કરું છું કે, તમે આ ખરાબ કામ ના કરો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","જુઓ, માંરે બે પુત્રીઓ છે, તે કુંવારી છે. હું માંરી બે પુત્રીઓને તમાંરી આગળ લાવું છું, તેની સાથે તમે લોકો જે કરવું હોય તે કરો, પણ આ લોકને કશું કરશો નહિ. એ લોકો અમાંરે ઘરે આવ્યા છે અને હું અવશ્ય તેમનું રક્ષણ કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ઘરની આજુબાજુના લોકોએ કહ્યું, “રસ્તામાંથી ખસી જા,” ત્યારે તે લોકોએ વિચાર્યું. “આ માંણસ લોત અમાંરા નગરમાં અતિથિ તરીકે આવ્યો છે અને હવે અમને શીખવે છે કે, અમે લોકો શું કરીએ!” ત્યારે લોકોએ લોતને કહ્યું, “અમે લોકો એ માંણસો કરતાં ય તારા ભૂંડા હાલ કરીશું.” તેથી એ લોકોએ લોતને ઘેરી વળીને તેની નજીક આવવાનું શરૂ કર્યું. તે બારણું તોડીને અંદર પ્રવેશવા ઈચ્છતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","પરંતુ લોતની સાથે રહેલા માંણસોએ દરવાજો ઉઘાડયો અને લોતને ઘરની અંદર ખેંચી લીધો. અને પછી બારણું બંધ કરી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","બંન્ને જણે દરવાજાની બહારના માંણસોને આંધળા બનાવી દીધા અને ઘરમાં ઘૂસવા વાળા જુવાન અને વૃદ્વ બધાં જ આંધળા થઈ ગયા. તેઓ બારણાં શોધી શોધીને થાકી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","બંન્ને જણે લોતને કહ્યું, “શું આ નગરમાં કોઈ એવો માંણસ તમાંરા પરિવારનો છે? શું તમાંરા જમાંઈ, તમાંરી પુત્રીઓ કે અન્ય કોઈ તમાંરા પરિવારનો માંણસ છે? જો કોઈ બીજો માંણસ તમાંરા પરિવારનો આ નગરમાં રહેતો હોય તો તેને હમણાં જ આ નગર છોડી જવા કહી દો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","અમે લોકો આ નગરનો નાશ કરીશું. યહોવાએ આ બધી બુરાઇઓને સાંભળી લીધી છે. જે આ નગરમાં છે એટલા માંટે યહોવાએ અમને એનો વિનાશ કરવા મોકલ્યા છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","એટલા માંટે લોત બહાર ગયો અને પોતાની બીજી પુત્રીઓ સાથે લગ્ન કરવાવાળા જમાંઈઓને વાત કરી. લોતે કહ્યું, “ઊતાવળ કરો અને આ નગરને છોડી જાઓ. યહોવા એનો તરત વિનાશ કરશે.” પરંતુ એ લોકો એવું સમજયા કે, લોત મશ્કરી કરી રહ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","બીજે દિવસે સવારના સમયે દેવદૂતોએ લોતને તાકીદ કરીને કહ્યું, “ઊઠ, તારી પત્ની અને તારી બે પુત્રીઓ જે અહીં છે તેમને સાથે લઈ લે; અને આ જગ્યા છોડી દે, જેથી તમે બધા આ નગરની સાથે નાશ નહિ પામો.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","પરંતુ લોત મૂઝવણમાં હતો તેથી નગર છોડવાની તેણે ઉતાવળ ન કરી. પણ એના પર દેવની મહેરબાની હતી એટલે પેલા માંણસો તેને, તેની પત્નીને અને તેની બે પુત્રીઓને હાથ પકડીને શહેરની બહાર લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","બંન્નેએ લોત અને તેના પરિવારને નગરની બહાર પહોંચાડયા. જયારે તેઓ બહાર આવી ગયા ત્યારે બંન્નેમાંના એકે કહ્યું, “તમાંરો જીવ બચાવવા ભાગો, પાછું વળીને જોશો નહિ, અને આ નદીકાંઠાના પ્રદેશમાં કયાંય ઊભા રહેશો નહિ. પર્વતો ન આવે ત્યાં સુધી દોડો અને પર્વતો પાછળ ચાલ્યા જાઓ. નહિ તો તમે હતા ન હતા થઈ જશો.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ત્યારે લોતે બંન્નેને કહ્યું, “ના, ના, માંરા સ્વામી! કૃપા કરીને આટલા દૂર દોડવા માંટે મને મજબૂર ન કરો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","તમે આ માંરા સેવક પર દયા કરી છે અને દયા કરીને આપે માંરો જીવ બચાવ્યો છે. પરંતુ હું પર્વતો સુધી દોડી શકું તેમ નથી અને જો હું જરૂર કરતા ધીમે દોડીશ તો તે ક્ષેત્રમાં થયેલા વિનાશમાં હું માંર્યો જઇશ. ");
INSERT INTO guj2009_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","પરંતુ જુઓ, અહીં નજીકમાં એક બહુ નાનું નગર છે, અમને એ નગર સુધી દોડવા દો, તો અમાંરો જીવ બચી જશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","દેવદૂતે લોતને કહ્યું, “સારું, હું તમને એવું કરવા દઈશ, જયાં તમે જઈ રહ્યા છો એ નગરનો નાશ હું કરીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","પરંતુ તે જગ્યા સુધી ઝડપથી દોડો, જયાં સુધી તમે એ નગરમાં સુરક્ષિત પહોંચી નહિ જાઓ ત્યાં સુધી હું સદોમનો નાશ નહિ કરી શકુ.” (તે શહેરનું નામ સોઆર પડયું કારણ કે, તે નાનું ગામ છે.) ");
INSERT INTO guj2009_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","લોત જયારે સોઆરમાં પહોચ્યો ત્યારે પૃથ્વી પર સૂરજ ઊગતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","આ વખતે યહોવાએ સદોમ અને ગમોરાહનો નાશ કરવાનો આરંભ કર્યો. તેણે આકાશમાંથી સળગતા ગંધક અને આગ વરસાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","આ રીતે યહોવાએ તે દેશનો, નદીકાંઠાના સમગ્ર પ્રદેશનો, શહેરોમાંના બધા નિવાસીઓનો અને જમીન પર જે કાંઈ ઊગ્યું હતું તે સર્વનો નાશ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","જયારે તેઓ ભાગી રહ્યા હતા, ત્યારે લોતની પત્નીએ પાછું વળીને જોયું અને તે મીઠાનો થાંભલો થઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","તે દિવસે વહેલી સવારે ઇબ્રાહિમ ઊઠયો અને જે જગ્યાએ યહોવાને રૂબરૂ મળ્યો હતો ત્યાં ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ઇબ્રાહિમે સદોમ અને ગમોરાહ નગર તરફ નજર કરી અને નદી કાંઠાના સમગ્ર પ્રદેશ તરફ જોયું તો એમાંથી ધુમાંડો ઉપર ચઢતો હતો, જાણે ભઠ્ઠીનો ધુમાંડો ન હોય! ");
INSERT INTO guj2009_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","આમ દેવે કોતરોમાંના શહેરોનો વિનાશ કર્યો. જયારે દેવ આમ કરી રહ્યાં હતા, ત્યારે ઇબ્રાહિમે જે માંગ્યું છે તેનું સ્મરણ થયું અને લોતને બચાવ્યો. તેણે જે નગરનો નાશ કર્યો હતો ત્યાથી લોતને દૂર મોકલી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","લોત સોઆરમાં સતત રહેવાથી ડર્યો, તેથી તે અને તેની બંન્ને પુત્રીઓ પર્વતોમાં ચાલ્યા ગયા. અને ત્યાં રહેવા લાગ્યા. તેઓ ત્યાં એક ગુફામાં રહેતા હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","એક દિવસ મોટી દીકરીએ નાનીને કહ્યું, “પૃથ્વી પર બધી જ જગાએ પુરુષો અને સ્ત્રીઓના વિવાહ થાય છે, પરંતુ પૃથ્વી ઉપર કોઈ પુરુષ નથી જેની સાથે આપણે પતિ-પત્ની તરીકે ઘર માંડી શકીએ. આપણા પિતા પણ વૃદ્વ થયા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","એટલા માંટે ચાલો આપણે આપણા પિતાને દ્રાક્ષારસ પાઈએ અને તેની સાથે સૂઈએ, જેથી આપણા બાપથી આપણે વંશવેલો જાળવી શકીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","તેથી તે રાત્રે બંન્ને પુત્રીઓ પોતાના પિતા પાસે ગઈ અને પિતાને તેઓએ દ્રક્ષારસ પાયો અને મોટી પુત્રી પિતા સાથે તેની પથારીમાં સૂઈ ગઈ. અને તેની સાથે સંભોગ કર્યો, તેણી કયારે સૂઈ ગઈ અને કયારે ઊઠી તેની લોતને ખબર પડી નહિ (કેમકે તે નશામાં હતો.) ");
INSERT INTO guj2009_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","બીજે દિવસે મોટી પુત્રીએ નાનીને કહ્યું, “જો ગઈકાલે રાત્રે હું પિતા સાથે સૂઈ ગઈ હતી. આજે પણ આપણે તેને દ્રાક્ષારસ પાઈએ, પછી તું જઈને તેમની સાથે સૂઈ જજે. આ રીતે આપણે આપણા પિતાથી આપણો વંશવેલો જાળવી શકીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","એટલે તે રાત્રે પણ તેમણે પોતાના પિતાને દ્રાક્ષારસ પાયો. અને નાની પુત્રી તેણીના પિતા પાસે તેની પથારીમાં ગઇ અને તેની સાથે સૂઈ ગઈ અને તેની સાથે સંભોગ કર્યો. આ વખતે પણ લોતને ખબર પડી નહિ કે, તેણી ક્યારે સૂતી અને ક્યારે ઊઠી. (કેમકે તે નશામાં હતો.) ");
INSERT INTO guj2009_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","આ રીતે લોતની બંન્ને પુત્રીઓ તેમના પિતાથી ગર્ભવતી થઈ. તેમનો પિતાજ તેમનાં બાળકોનો પિતા હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","મોટી પુત્રીએ એક પુત્રને જન્મ આપ્યો. તેણે તેનું નામ મોઆબ રાખ્યું. મોઆબ તે જ આજના મોઆબીઓનો પૂર્વજ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","નાની પુત્રીએ પણ એક પુત્રને જન્મ આપ્યો, તેણે પોતાના પુત્રનું નામ બેન-આમ્મી રાખ્યું; તે જે આજના બધા આમ્મોનીઓનો પૂર્વજ છે જે આજે પણ રહે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ઇબ્રાહિમે એ સ્થળ છોડયું અને નેગેબ તરફ પ્રયાણ કર્યુ. અને કાદેશ અને શૂર વચ્ચે ગેરારમાં વસવાટ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","તે સમયે ઇબ્રાહિમે ગેરારના લોકોને કહ્યું, “સારા માંરી બહેન છે.” ગેરારના રાજા અબીમેલેખે આ સાંભળ્યું, અબીમેલેખ સારાને ચાહતો હતો તેથી સારાને લઈ આવવા માંટે અબીમેલેખે કેટલાક નોકરોને મોકલ્યા. અને સારાને રાખી. ");
INSERT INTO guj2009_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","પરંતુ એક વખત રાત્રે દેવે અબીમેલેખને સ્વપ્નમાં દર્શન આપ્યા અને વાત કરી. દેવે કહ્યું, “જો, જે સ્ત્રીને તેં ઘરમાં રાખી છે તેને કારણે તારું આવી બન્યું છે. કારણ તે પરસ્ત્રી છે. તું મરવાનો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","પરંતુ અબીમેલેખે હજુ સુધી તેનો સંગ કર્યો નહોતો, તેથી અબીમેલેખે કહ્યું, “હે યહોવા, હું દોષિત નથી. શું તમે નિદોર્ષ વ્યકિતનો પણ સંહાર કરશો? ");
INSERT INTO guj2009_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ઇબ્રાહિમે જ મને કહ્યું હતું કે, ‘આ સ્ત્રી માંરી બહેન છે.’ અને એ સ્ત્રીએ પણ કહ્યું, ‘આ પુરુષ માંરો ભાઈ છે.’ હું નિદોર્ષ છું. મને તો ખબર જ નહોતી કે, હું શું કરી રહ્યો છું? મેં તો શુદ્વ વૃત્તિથી જ આ કર્યુ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ત્યારે દેવે અબીમેલેખને સ્વપ્નમાં કહ્યું, “હા, મને ખબર છે કે, તું નિદોર્ષ છે અને મને એ પણ ખબર છે કે, તને ખબર ન હતી કે, તું શું કરી રહ્યો હતો! મેં જ તને ઉગાર્યો, મેં જ તને માંરી વિરુધ્ધ પાપ કરવા દીધું નથી. અને એટલે જ મેં તને તેનો સ્પર્શ કરવા દીધો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","તેથી હવે તું ઇબ્રાહિમની પત્નીને તેની પાસે પાછી મોકલ. ઇબ્રાહિમ એક પ્રબોધક છે. તે તમાંરા માંટે પ્રાર્થના કરશે અને તું જીવીશ પરંતુ જો તું સારાને પાછી નહિ આપે તો સમજી લેજે કે, તારું અને તારા બધાં જ લોકોનું એક સાથે મૃત્યુ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","તેથી બીજે દિવસે વહેલી સવારે અબીમેલેખે પોતાના બધા નોકરોને બોલાવ્યા અને સ્વપ્નમાં થયેલી બધી વાતો કહી સંભળાવી, નોકરો બહું જ ગભરાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","પછી અબીમેલેખે ઇબ્રાહિમને બોલાવ્યો અને તેને કહ્યું, “તમે માંરી સાથે આમ કેમ કર્યું? મેં તમાંરો શો ગુનો કર્યો હતો કે, તમે ‘આ માંરી બહેન છે.’ એમ જૂઠું બોલીને મને અને માંરા રાજયને મોટાં પાપમાં નાખ્યાં? તમાંરે માંરી સાથે આવો વર્તાવ નહોતો કરવો જોઈતો, તમે શું સમજીને આમ કર્યું? ");
INSERT INTO guj2009_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","તમે કઈ બાબતથી ડરતા હતા? તમે માંરી સાથે આવું કેમ કર્યું?” ");
INSERT INTO guj2009_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","પછી ઇબ્રાહિમે કહ્યું, “હું ડરતો હતો કારણ કે મને થયું કે, આ દેશમાં કોઈ પણ દેવને માંન આપતું નથી અને તેનાથી ડરતું નથી અને માંરી પત્ની સારાને મેળવવા માંટે આ લોકો મને માંરી નાખશે. ");
INSERT INTO guj2009_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","અને તમને, સાચું કહું તો તે માંરી બહેન જ છે, કારણ કે તેણી માંરા બાપની દીકરી છે, જો કે, તેણી માંરી માંની પુત્રી નથી. અને તેણી માંરી પત્ની બની. ");
INSERT INTO guj2009_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","દેવે મને માંરા પિતાના ઘરથી દૂર મોકલ્યો હતો. દેવે મને એક જગ્યાએથી બીજી જગ્યાએ ભટકતો, કર્યો હતો, તેથી મેં સારાને કહ્યું હતું કે, ‘તારે માંરા પર આટલી કૃપા કરવી પડશે. આપણે જયાં જયાં જઈએ ત્યાં ત્યાં તારે કહેવું પડશે કે, આ માંરો ભાઈ છે!’” ");
INSERT INTO guj2009_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ત્યારે અબીમેલેખે જાણ્યું કે, આમ શાથી બન્યું છે. તેથી તેણે ઈબ્રાહિમને સારા સુપ્રત કરી અને ઘેટાં, બકરાં, ગાય, બળદ તેમજ દાસદાસી આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","અબીમેલેખે કહ્યું, “જો, આ માંરો સમગ્ર દેશ તારી આગળ છે. તારી મરજી હોય ત્યાં તું જઈને રહી શકે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","અબીમેલેખે સારાને પણ કહ્યું, “જો મેં તારા ભાઈને 1,000 રૂપામહોર આપી છે. હું આ બધા માંટે દિલગીર છું તે બતાવવા માંટે મેં આમ કર્યુ હતું. હું ઈચ્છું છું કે, પ્રત્યેક વ્યકિત જુએ કે, મેં સાચું કામ કર્યુ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","દેવે અબીમેલેખના ઘરની બધી સ્ત્રીઓને ગર્ભધારણથી અટકાવી દીધી હતી કારણકે ઇબ્રાહિમની પત્ની સારાને અબીમેલેખે લીધી હતી, તેથી હવે ઇબ્રાહિમે યહોવાને પ્રાર્થના કરી, તેથી દેવે અબીમેલેખને અને તેની પત્નીને અને તેની દાસીઓને સાજાં કર્યા અને તેમને સંતાનો થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","યહોવાએ સારાને આપેલ વચન જાળવી રાખ્યું. અને યહોવાએ પોતાના વચન અનુસાર સારા પર કૃપા કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","સારા ગર્ભવતી થઈ અને તેણે વૃદ્વાવસ્થામાં ઇબ્રાહિમને માંટે દેવે કહેલા સમયે એક પુત્રને જન્મ આપ્યો. દેવે જે વચન આપ્યું હતું તે જ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","સારાએ પુત્રને જન્મ આપ્યો અને ઇબ્રાહિમે તેનું નામ ઇસહાક પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","અને દેવની આજ્ઞા અનુસાર તેણે પોતાનો દીકરો ઇસહાક આઠ દિવસનો થયો, ત્યારે તેની સુન્નત કરાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","જયારે ઇબ્રાહિમનો પુત્ર ઇસહાક જન્મ્યો ત્યારે એની ઉંમર 100 વર્ષની થઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","અને સારાએ કહ્યું, “દેવે મને સુખનાં દિવસ આપ્યા છે. જે કોઈ વ્યકિત આ સાંભળશે તે પણ માંરી સાથે પ્રસન્ન થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","કોઈ પણ એમ ધારતું નહોતું કે, સારા ઇબ્રાહિમ માંટે પુત્રને જન્મ આપશે, છતાં મેં એના ઘડપણમાં દીકરાને જન્મ આપ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","હવે બાળક મોટો થયો અને તેને ધાવણ છોડાવવામાં આવ્યું. તે દિવસે ઇબ્રાહિમે એક મોટી ઉજવણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","પછી મિસરી દાસી હાગારથી ઇબ્રાહિમને એક પુત્ર થયો હતો. એક વાર સારાએ હાગારના પુત્રને ઇસહાકની મશ્કરી કરતા જોયો. ");
INSERT INTO guj2009_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","તેથી સારાએ ઇબ્રાહિમને કહ્યું, “આ દાસી સ્ત્રી તથા તેના પુત્રને અહીંથી કાઢી મૂકો, આપણા મૃત્યુ પછી આપણી સંપત્તિનો માંલિક ઇસહાક જ થશે. હું નથી ઈચ્છતી કે, આ દાસીનો દીકરો માંરા દીકરા ઇસહાક સાથે વારસ થાય.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","આ બધી વાતોથી ઇબ્રાહિમ બહુજ દુ:ખી થયો. તે પોતાના પુત્ર ઇશ્માંએલને કારણે ખૂબ દુ:ખી હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","પરંતુ દેવે ઇબ્રાહિમને કહ્યું, “એ પુત્રને કારણે તથા દાસી સ્ત્રીને કારણે મનમાં દુ:ખી થઈશ નહિ. સારા તને જે કંઈ કહે તે તેના કહ્યાં પ્રમાંણે કર. કારણ કે તારો વંશવેલો ઇસહાકથી ચાલુ રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","પરંતુ હું તારા દાસીપુત્રને પણ આશીર્વાદ આપીશ અને હું એ દાસ્ત્રીના પુત્રને પણ મોટો પરિવાર આપીશ, અને તે પરિવારનું પણ એક મોટું રાષ્ટ બનાવીશ. કારણ કે એ તારું સંતાન છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","તેથી બીજે દિવસે વહેલી સવારે ઇબ્રાહિમે રોટલા અને પાણીના મશક લઈને હાગારને આપ્યાં અને છોકરાંને ખભે ચઢાવીને તેને વિદાય કરી. તે ચાલી ગઈ અને બેર-શેબાના રણમાં ભટકવા લાગી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","થોડા સમય પછી હાગારની મશકનું પાણી ખૂટી ગયું ત્યારે તેણે તે બાળકને એક નાના ઝાડ નીચે છોડી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","હાગાર ત્યાંથી થોડા અંતરે ગઇ અને નીચે બેઠી. હાગારે વિચાર્યું કે, ત્યાં પાણી નથી તેથી તેણીનો પુત્ર મૃત્યુ પામશે. તેણી તેને મૃત્યુ પામતો જોવા નહોતી ઈચ્છતી. તેણી ત્યાં બેઠી હતી ત્યારે રડવા લાગી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","દેવે બાળકને રડતો સાંભળ્યો. અને આકાશમાંથી એક દૂતે હાગારને બોલાવી તેણે હાગારને પૂછયું, “હાગાર, તારે શી સમસ્યા છે? દેવે બાળકને રડતો સાંભળ્યો છે, ડરીશ નહિ, ");
INSERT INTO guj2009_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ઊઠ, બાળકને ઉપાડી લે, અને તેનો હાથ પકડ અને તેને દોરવ, કારણ કે, હું તેનાથી એક મહાન રાષ્ટ બનાવવાનો છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","પછી દેવે હાગારને પાણીથી ભરેલો કૂવો દેખાય તેવું કર્યુ. તે ત્યા ગઇ અને મશકમાં પાણી ભરી લીધું. અને બાળકને પાણી પાયું. ");
INSERT INTO guj2009_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","બાળક જયાં સુધી મોટો ન થયો ત્યાં સુધી દેવ તેની સાથે રહ્યો. તે રણપ્રદેશમાં રહેતો હતો અને તેથી તે ધનુષ્ય ચલાવતા શીખ્યો અને નિપુણ શિકારી થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","તેની માંતા તેના માંટે મિસરની વહુ લાવી અને તેઓએ પારાનના રણમાં રહેવાનું ચાલુ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","તે સમયે અબીમેલેખ તેના સેનાપતિ ફીકોલ સાથે જઈ ઇબ્રાહિમને કહ્યું, “તું જે કાંઈ કહે છે તેમાં દેવ તને સહાય કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","તેટલા માંટે આ ઘડીએ તું માંરી આગળ દેવના નામે એવા સમ લે અને વચન આપ કે, તું માંરી સાથે અને માંરા બધા વંશજો સાથે ન્યાયી બનશે, અને હું જેમ તારી સાથે દયાળુ રહ્યો છું તેમ તું માંરી સાથે અને જે દેશમાં તું રહ્યો છે તેના વતનીઓ સાથે દયાળુ રહીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ત્યારે ઇબ્રાહિમે કહ્યું, “હું વચન આપું છું કે, તેં જે વ્યવહાર માંરી સાથે કર્યો છે એવો જ વ્યવહાર હું તારી સાથે પણ રાખીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ત્યારે ઇબ્રાહિમે અબીમેલેખને ફરિયાદ કરી. કારણ કે અબીમેલેખના નોકરોએ એક કૂવો પડાવી લીધો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","અબીમેલેખે કહ્યું, “આના વિષે મેં પહેલી વાર સાંભળ્યું છે. મને ખબર નથી કે, આ કોણે કર્યુ છે અને તેં મને કહ્યું નથી, અને આજપર્યત માંરે કાને આવ્યું નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","એટલે ઈબ્રાહિમ અને અબીમેલેખે એક સંધિ કરી. ઇબ્રહિમે સંધિના પ્રમાંણના રૂપમાં અબીમેલેખને ઘેટાં-બકરાં અને બળદો આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ઇબ્રાહિમે પ્રાણીઓના ટોળામાંથી સાત ઘેટીઓ અલગ કરીને તેમને અબીમેલેખની સામે મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","અબીમેલેખે ઇબ્રાહિમને પૂછયું, “તેં આ સાત ઘેટીઓ તેમને તેમ કેમ મૂકી છે? તેનો અર્થ શો?” ");
INSERT INTO guj2009_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ઇબ્રાહિમે કહ્યું, “જયારે તમે આ સાત ઘેટીઓ માંરી પાસેથી લેશો ત્યારે આ કૂવો મેં ખોદાવ્યો છે એનો એ પુરાવો થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","એટલા માંટે એ જગ્યાનું નામ બેર-શેબા પાડયું કારણ કે ત્યાં બંને જણે સમ ખાધા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","આ રીતે બેર-શેબામાં અબીમેલેખે ઇબ્રાહિમ સાથે સંધિ કરી. પછી અબીમેલેખ અને તેનો સેનાપતિ ફીકોલ પલિસ્તિઓના પ્રદેશમાં પાછા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ઇબ્રાહિમે બેર-શેબામાં એક એશેલ ઝાડ રોપ્યું અને ત્યાં ઇબ્રાહિમે યહોવા જે સનાતન દેવ છે તેની પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","અને ઇબ્રાહિમ પલિસ્તીઓની ભૂમિમાં ઘણો સમય રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","આ બધું થઈ ગયા પછી દેવે ઇબ્રાહિમના વિશ્વાસની કસોટી કરવાનું નકકી કર્યુ. દેવે તેને કહ્યું, “ઇબ્રાહિમ!” ત્યારે ઇબ્રાહિમે ઉત્તર આપ્યો, “હું આ રહ્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","દેવે કહ્યું, “તારા પુત્રને, તારા એકનાએક પુત્રને, જે તને વહાલો છે તે ઇસહાકને લઈને તું મોરિયા પ્રદેશમાં જા. અને ત્યાં હું કહું તે ડુંગર ઉપર તું તેનું દહનાર્પણ કર.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","તેથી ઇબ્રાહિમ સવારે વહેલો ઊઠયો અને તેણે ગધેડા પર જીન નાખ્યું. ઇબ્રાહિમે તેના પુત્ર ઇસહાક અને બે નોકરોને સાથે લીધા. ઇબ્રાહિમે યજ્ઞ માંટે લાકડાં કાપીને તૈયાર કર્યા. અને પછી દેવે કહ્યું હતું તે જગ્યાએ જવા નીકળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ત્રણ દિવસના પ્રવાસ પછી ઇબ્રાહિમે ઉપર જોયું અને જે જગ્યાએ એ જતાં હતા તે જગ્યા દૂર નજરે પડી. ");
INSERT INTO guj2009_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","પછી ઇબ્રાહિમે પોતાના નોકરોને કહ્યું, “તમે અહીં ગધેડા પાસે રહો, હું માંરા પુત્રને તે જગ્યાએ લઈ જઈશ અને ઉપાસના વિધી કરીશ, પછી અમે પાછા આવીશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ઇબ્રાહિમે યજ્ઞ માંટેનાં લાકડાં લીધાં અને પોતાના પુત્ર ઇસહાકના ખભા પર ચઢાવ્યાં. અને ઇબ્રાહિમે પોતાના હાથમાં અગ્નિ અને છરો લીધો પછી ઇબ્રાહિમ અને તેનો પુત્ર બંને ઉપાસના માંટે તે જગ્યાએ એક સાથે ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ઇસહાકે પોતાના પિતા ઇબ્રાહિમને કહ્યું, “પિતાજી!” ઇબ્રાહિમે ઉત્તર આપ્યો, “હા, બેટા, શું છે?” ઇસહાક બોલ્યો, “જુઓ, અગ્નિ અને લાકડાં હું જોઉં છું. પણ દહનાર્પણ માંટે ઘેટું કયાં છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ઇબ્રાહિમે ઉત્તર આપ્યો, “બેટા, દહનાર્પણ માંટેનું ઘેટું દેવ જાતે જ આપણને પૂરું પાડશે.” તેથી, તેઓ બંને આગળ વધ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","જયારે તેઓ દેવે કહેલી જગ્યાએ આવી પહોંચ્યા ત્યારે ઇબ્રાહિમે એક વેદી તૈયાર કરી, તેના પર લાકડાં ગોઠવ્યાં અને પોતાના પુત્ર ઇસહાકને બાંધીને વેદી પરનાં લાકડાં ઉપર ચઢાવી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","પછી ઇબ્રાહિમે પોતાનો છરો કાઢયો અને પુત્રનો વધ કરવાની તૈયારી કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ત્યારે યહોવાના દૂતે ઇબ્રાહિમને રોકયો. દેવદૂતે આકાશમાંથી બોલાવ્યો. “ઇબ્રાહિમ, ઇબ્રાહિમ!” ઇબ્રાહિમે ઉત્તર આપ્યો, “જી!” ");
INSERT INTO guj2009_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","દેવદૂતે કહ્યું, “તારા પુત્રને માંરીશ નહિ, તેને કોઇ સજા કરીશ નહિ, મેં જોયું કે, તું દેવનો આદર કરે છે અને તેની આજ્ઞાનું પાલન કરે છે. મેં જોઇ લીધું છે કે, તું તારા એકના એક પુત્રને માંરા માંટે બલિ ચઢાવતાં ખચકાયો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ઇબ્રાહિમે ઊંચી નજર કરીને જોયું તો તેની પાછળ ઝાડીમાં એક ઘેટો શિંગડા ભરાઈ જવાથી ફસાઈ ગયો હતો. ઇબ્રાહિમે તેને પકડયો અને પોતાના પુત્રને બદલે દહનાર્પણ તરીકે ચઢાવ્યો. અને ઇબ્રાહિમનો પુત્ર બચી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","તેથી ઇબ્રાહિમે તે જગ્યાનું નામ યહોવા-યિરેહ પાડયું. આજે પણ લોકો કહે છે, “આ પર્વત પર યહોવાને જોઇ શકાય છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","યહોવાના દૂતે આકાશમાંથી બીજી વાર ઇબ્રાહિમને સાદ કરીને કહ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","દેવદૂતે કહ્યું, “યહોવાની આ વાણી છે: હું માંરી જાતના સમ લઉં છું કે, તેં આ કામ માંરે માંટે કર્યુ છે, અને તારા પુત્રને, તારા એકના એક પુત્રને મને બલિ ચઢાવતાં તું ખચકાયો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","તેથી હું જરૂર તને આશીર્વાદ આપીશ. હું આકાશના તારા જેટલા, દરિયાકાંઠાની રેતી જેટલા તારા વંશજો વધારીશ. અને તારા વંશજો પોતાના દુશ્મનોને કબજે કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","અને તારા વંશજો દ્વારા ધરતી પરની તમાંમ પ્રજા આશીર્વાદ પામશે, કારણ કે તેં માંરું કહ્યું માંન્યું છે અને તે પ્રમાંણે કર્યુ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","પછી ઇબ્રાહિમ પોતાના નોકરો પાસે પાછો આવ્યો. તેઓ સાથે મળીને બેર-શેબા ગયા અને ઇબ્રાહિમ બેર-શેબામાં જ રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ત્યારબાદ ઇબ્રાહિમને ખબર મળી કે, “તારા ભાઈ નાહોરથી મિલ્કાહને પણ બાળકો થયા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","સૌથી મોટો પુત્ર ઉસ, તેનો ભાઈ બૂઝ, અરામનો પિતા કમુએલ. ");
INSERT INTO guj2009_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","કેસેદ, હઝો, પિલ્દાશ, યિદલાફ અને બથુએલ.” ");
INSERT INTO guj2009_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","બથુએલ રિબકાનો પિતા હતો. ઇબ્રાહિમના ભાઈ નાહોરથી મિલ્કાહને આ આઠ સંતાનો થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","આ ઉપરાંત તેની રઉમાંહ નામની દાસીને ટેબાહ, ગાહામ, તાહાશ અને માંઆકાહ જન્મ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","સારા 127 વર્ષ સુધી જીવતી રહી; એનું આયુષ્ય એટલા વર્ષનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","સારાનું મૃત્યુ કનાન ભૂમિમાં આવેલા કિર્યાથ-આર્બા (હેબ્રોન)માં થયું. ઇબ્રાહિમ બહુ જ દુ:ખી હતો અને તે તેણીના મૃત્યુ પર ખૂબ રડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","પછી તે મૃત પત્નીને ત્યાં છોડી તે હિત્તી લોકો સાથે વાત કરવા ગયો. તેણે કહ્યું ");
INSERT INTO guj2009_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“હું તો ફકત આ પ્રદેશમાં રહેતો મુસાફર માંત્ર છું. એટલે માંરી પાસે માંરી પત્નીને દફનાવવા માંટે કોઈ જગ્યા નથી. તેથી તમે મને કબરસ્તાન માંટે કોઈ જગ્યા તમાંરા ગામમાં આપો, કે, જેથી હું માંરી પત્નીને દફનાવું.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","હિત્તી લોકોએ ઇબ્રાહિમને જવાબ આપ્યો; ");
INSERT INTO guj2009_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“શ્રીમાંન, તમે અમાંરી વચ્ચે દેવના સૌથી મહાન આગેવાનોમાંના એક છો. અમાંરી પાસે જે જગ્યા છે તેમાંથી તમને સૌથી સારી લાગે તે જગ્યા તમાંરી પત્નીને દફનાવવા લઈ શકો છો. અમાંરામાંથી કોઈ પણ તમને તમાંરી પત્નીને દફનાવવાની ના પાડે તેમ નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ઇબ્રાહિમે ઊભા થઈને તે લોકોને પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ઇબ્રાહિમે તે લોકોને કહ્યું, “હું માંરી પત્નીને દફનાવું એમાં તમે મને મદદ કરવા ઈચ્છતા હો તો મને સાંભળો, માંરા તરફથી સોહારના પુત્ર એફ્રોનને માંરા માંટે વાત કરો: ");
INSERT INTO guj2009_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","હું માંખ્પેલાહની ગુફા, જે તેની માંલિકીની છે તે ખરીદવા ઈચ્છું છું તે મને આપે. એ તેના ખેતરને છેડે આવેલી છે. હું તેની પૂરેપૂરી કિંમત આપીશ. હું ઈચ્છું છું કે, તમે લોકો તેના સાક્ષી રહો કે, હું આ જમીન તમાંરી હાજરીમાં કબરસ્તાન માંટે ખરીદી રહ્યો છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","એફ્રોન તે લોકોની વચમાં જ બેઠેલો હતો. એફ્રોને ઇબ્રાહિમને ઉત્તર આપ્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ના, શ્રીમાંન, માંરી વાત સાંભળો. હું તમને એ ખેતર અને તેમાં આવેલી ગુફા બંને આપી દઉં છું. માંરા લોકોની સાક્ષીએ હું તમને તે આપી દઉં છું. તમે તેમાં તમાંરી પત્નીને દફનાવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","પછી ઇબ્રાહિમે હિત્તી લોકો આગળ પોતાનું માંથું નમાંવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ઇબ્રાહિમે બધા લોકોની હાજરીમાં એફ્રોનને કહ્યું, “પરંતુ હું તો આ ખેતરની પૂરેપૂરી કિંમત આપવા માંગું છું. તેનો તમે સ્વીકાર કરો તો હું માંરી પત્નીને ત્યાં દફનાવી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","એફ્રોને ઇબ્રાહિમને જવાબ આપ્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“શ્રીમાંન, માંરી વાત સાંભળો, તમાંરી અને માંરી વચ્ચે 400 શેકેલ ચાંદીની જમીનની શી વિસાત? તમે તમાંરી પત્નીને દફનાવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ઇબ્રાહિમ સમજયો કે, એફ્રોન તેને જમીનની કિંમત કહી રહ્યો છે. એટલે હિત્તી લોકોને સાક્ષી માંનીને તે રકમ, એટલે કે, 400 શેકેલ ચાંદી, વેપારીઓના ચાલુ વજન પ્રમાંણે તોલી આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","આ પ્રમાંણે એફ્રોનના ખેતરનો માંલિક બદલાઈ ગયો. આમ, માંમરેની પૂર્વમાં માંખ્પેલાહમાં આવેલા એફ્રોનના ખેતર તેમાં આવેલી ગુફા તેમજ તેમાંના ઝાડનો કબજો ઇબ્રાહિમને આપ્યો, હિત્તી લોકોની સાક્ષીએ આ સોદો ઇબ્રાહિમને મળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","એ પછી ઇબ્રાહિમે પોતાની પત્ની સારાને માંમરે (હેબ્રોન)ની નજીક આવેલા માંખ્પેલાહની ગુફામાં કનાનના પ્રદેશમાં દફનાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","પછી ખેતર અને તેમાંની ગુફાનો કબ્રસ્તાન તરીકે ઉપયોગ કરવા માંટે ઇબ્રાહિમે હિત્તી લોકો પાસેથી ખરીદી લીધું. તે હવે તેની સંપત્તિ થઈ ગઈ હતી, અને તેણે તેનો ઉપયોગ કબ્રસ્તાન તરીકે કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","હવે ઇબ્રાહિમ ખૂબ વૃદ્વ થયો હતો. યહોવાએ ઇબ્રાહિમને આશીર્વાદ આપ્યા અને તેના પ્રત્યેક કામમાં સફળતા પ્રદાન કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ઇબ્રાહિમે પોતાના ઘરના જૂનામાં જૂના નોકરને બોલાવ્યો અને કહ્યું, “માંરી જાંઘ નીચે તારો હાથ મૂક. ");
INSERT INTO guj2009_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","હું તને આકાશ અને પૃથ્વીના દેવ યહોવાને નામે સમ દેવા ઈચ્છું છું કે, તું કનાનીઓની કોઈ પણ કન્યા સાથે માંરા પુત્રના વિવાહ થવા દઈશ નહિ. અમે લોકો કનાનીઓની વચમાં રહીએ છીએ, પરંતુ કોઈ પણ કનાની કન્યા સાથે તેના લગ્ન થવા ન દેશો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","તમે માંરા દેશમાં માંરાં સગાંસંબંધીઓમાં જાઓ અને ત્યાં શોધો. પછી ત્યાંથી માંરા દીકરા માંટે સ્ત્રી લાવજો.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","નોકરે તેમને કહ્યું, “કદાચ તે કન્યા માંરી સાથે આ દેશમાં આવવા તૈયાર ન પણ થાય. ત્યારે માંરે તમાંરા પુત્રને તમે જે દેશમાંથી આવ્યા છો ત્યાં પાછો લઈ જવો?” ");
INSERT INTO guj2009_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ઇબ્રાહિમે તેને કહ્યું, “ના, તું માંરા પુત્રને એ દેશમાં લઈ જઈશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","યહોવા આકાશના દેવે મને માંરી જન્મભૂમિનો અને માંરા બાપના ઘરનો ત્યાગ કરાવ્યો હતો. અને જેણે સમ ખાઈને મને એવું વચન આપ્યું હતું: ‘હું તારા વંશજોને આ દેશ આપીશ.’ તે તારી આગળ તને દોરવવા તેના દૂતને ત્યાંથી માંરા પુત્ર માંટે પત્ની લાવવા મોકલશે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","પરંતુ કન્યા જો તારી સાથે આવવા તૈયાર ન હોય તો તું માંરા આ સમથી મુકત છે. પરંતુ તું માંરા પુત્રને તે દેશમાં પાછો લઈ જઈશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","આ રીતે નોકરે પોતાના ધણી ઇબ્રાહિમની જાંધ નીચે હાથ મૂકયો અને એ પ્રકારના સમ લીધા. ");
INSERT INTO guj2009_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","પછી નોકરે ઇબ્રાહિમના દશ ઊંટ લીધાં. અને ધણી પાસેથી જાતજાતની સારામાં સારી ભેટસોગાદો લઈને અરામ-નાહશ-ઇમનામાં આવેલા નાહોર નગરમાં જવા નીકળી પડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","તે નગર બહાર કૂવા પાસે ગયો, ત્યારે સંધ્યાકાળે સ્ત્રીઓ ત્યાં પાણી ભરવા જતી હતી. તે વખતે તેણે શહેર બહાર કૂવા પાસે ઊંટને બેસાડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","નોકરે કહ્યું, “હે યહોવા, તું માંરા ધણી ઇબ્રાહિમનો દેવ છે. આજે તું માંરા ધણીના પુત્ર માંટે એક વહુ મેળવી આપ. કૃપા કરીને માંરા ધણી ઇબ્રાહિમ પર દયા કર. ");
INSERT INTO guj2009_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","હું આ પાણી ભરવાના કૂવા પાસે ઊભો છું અને નગરની કન્યાઓ પાણી ભરવા આવે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","હું એક વિશિષ્ટ પ્રકારના ચિન્હની પ્રતીક્ષા કરી રહ્યો છું, જેના વડે હું જાણી શકું કે, ઇસહાકને યોગ્ય કઈ કન્યા છે. હું કન્યાને કહું કે, ‘તારો ઘડો જરા વાંકો કર, એટલે હું પાણી પી શકું.’ અને જે કન્યા કહે કે, ‘પીઓને; અને હું તમાંરાં ઊંટને પણ પાઈશ.’ તે જ તારા સેવક ઇસહાકની વહુ થવા તેં નક્કી કરેલી કન્યા હોય. આના પરથી હું જાણીશ કે, માંરા ધણી પર તારી કૃપા છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","પછી નોકરની પ્રાર્થના પૂરી થતાં પહેલા જ ત્યાં રિબકા નામની કન્યા ખભા પર ઘડો લઈને આવી. રિબકા બથુએલની પુત્રી હતી. અને બથુએલ ઇબ્રાહિમના ભાઈ નાહોર અને મિલ્કાહનો પુત્ર હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","કન્યા ખૂબ રૂપાળી હતી અને કુંવારી હતી. કોઈ પુરુષનો સ્પર્શ તેને થયો ન હતો. તે પોતાનો ઘડો ભરવા માંટે કૂવા ઉપર આવી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","અને જ્યારે તેણી ગાગર ભરીને પાછી આવી, નોકર તેની તરફ દોડ્યો અને બોલ્યો, “કૃપા કરીને તમાંરા ઘડામાંથી થોડું પાણી પીવા આપશો?” ");
INSERT INTO guj2009_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","રિબકાએ જલદીથી ખભા પરથી ઘડો ઉતાર્યો અને તેને પાણી પાયું. રિબકાએ કહ્યું, “શ્રીમાંન, લો આ પીઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","જયારે તે પાણી પીવડાવી રહી એટલે તે બોલી, “તમાંરા ઊંટ માંટે પણ તેઓ પી રહે ત્યાં સુધી હું પાણી લાવી આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","એમ કહીને તેણે ઝટપટ ઘડો હવાડામાં ઠાલવી દીધો અને ફરી ભરવા માંટે કૂવે દોડી ગઈ. અને તેણે બધાં જ ઊંટોને પાણી પીવડાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","નોકરે ચૂપચાપ ધ્યાનથી તેને જોઈ. એ નક્કી જાણવા માંગતો હતો કે, કદાચ યહોવાએ એની વાત સ્વીકારીને તેનો પ્રવાસ સફળ કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ઊંટો પાણી પી રહ્યાં એટલે પેલા માંણસે અર્ધા તોલા સોનાની એક વાળી અને દશ તોલા સોનાની બે બંગડીઓ પેલી યુવતીને આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","પછી નોકરે પૂછયું, “તારા પિતા કોણ છે? તારા પિતાના ઘરમાં અમે રાતવાસો કરીએ એટલી જગ્યા છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","રિબકાએ જવાબ આપ્યો, “માંરા પિતા બથુએલ છે, જે મિલ્કાહ અને નાહોરના પુત્ર છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","પછી તેને કહ્યું, “હા, અમાંરી પાસે તમાંરા ઊંટો માંટે પુષ્કળ ઘાસચારો છે. અને રાતવાસો કરવા માંટે જગ્યા પણ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","નોકરે માંથું નમાંવીને યહોવાની ઉપાસના કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","નોકરે કહ્યું, “માંરા ધણી ઇબ્રાહિમના દેવ યહોવાની પ્રશંસા થાઓ. યહોવા માંરા ધણી પ્રત્યે દયાળુ અને વફાદાર રહ્યાં છે. યહોવાએ મને માંરા ધણીના સગાઓના ઘરે દોરવ્યો છે. અને માંરા ધણીના પુત્ર માંટે યોગ્ય કન્યા તરફ દોરવ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","પછી રિબકાએ ઘેર દોડી જઈને જે કાંઈ બન્યું હતું તે પોતાના પરિવારને જણાવ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","રિબકાના ભાઈનું નામ લાબાન હતું. રિબકાએ તે વ્યકિતએ જે વાત કરી હતી તે વાતો ભાઈને કહી. લાબાન તેની વાતો સાંભળી રહ્યો હતો ત્યારે, ");
INSERT INTO guj2009_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","તેણે પોતાની બહેનના હાથ પર બંગડીઓ અને વાળી જોઈ, તેથી તે દોડીને પેલા માંણસને મળવા ગયો. તે માંણસ કૂવા આગળ ઉંટો પાસે ઊભો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","લાબાને કહ્યું, “પધારો શ્રીમાંન, આપનું સ્વાગત કરું છું, તમે અહીં બહાર કેમ ઊભા છો? મેં તમાંરા ઊંટોને માંટે એક જગ્યા તૈયાર રાખી છે, અને તમાંરા માંટે સૂવાનો ઓરડો પણ તૈયાર કરી દીધો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","તેથી ઇબ્રાહિમનો નોકર ઘરમાં ગયો. લાબાને ઊંટના બંધનો છોડી નાખ્યા, ઊંટો માંટે ઘાસચારો આપ્યો. અને તેને અને તેના માંણસોને પગ ધોવા માંટે પાણી આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","પછી લાબાને તેમને ખાવા માંટે ભોજન આપ્યું. પરંતુ તેણે કહ્યું, “હું શા કામે આવ્યો છું તે કહ્યાં પહેલા હું જમીશ નહિ.” લાબાન બોલ્યો, “તો કહો.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","નોકરે કહ્યું, “હું ઇબ્રાહિમનો નોકર છું, યહોવાએ અમાંરા ધણી ઉપર દરેક બાબતમાં કૃપા કરી છે. માંરા ધણી મહાન વ્યકિત થઈ ગયા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","યહોવાએ તેમને ઘેટાંબકરાં, ઊંટો અને ગધેડાં, ઢોરઢાંખર, સોનુંરૂપું, દાસ દાસીઓ આપ્યાં છે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","માંરા ધણીની પત્ની સારાને વૃદ્વાવસ્થામાં એક પુત્ર અવતર્યો અને માંરા ધણીએ તેને બધી મિલકત સોંપી દીધી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","માંરા માંલિકે મને એવા સમ દીધા છે કે, ‘જે કનાનીઓના દેશમાં હું વસું છું તેમની પુત્રીઓમાંથી તારે માંરા પુત્ર માંટે સ્ત્રી લાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","એટલા માંટે તારે વચન આપવું પડશે કે, તું માંરા પિતાના દેશમાં અને માંરા કુટુંબમાં જઈને ત્યાંથી માંરા પુત્ર માંટે કન્યા લાવીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","મેં માંરા ધણીને કહ્યું, ‘કદાચ એમ પણ બને કે, સ્ત્રી માંરી સાથે આ દેશમાં આવવા તૈયાર ન થાય.’ ");
INSERT INTO guj2009_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","પરંતુ માંરા ધણીએ કહ્યું, ‘હું યહોવાની સેવા કરું છું. અને યહોવા તારી સાથે એમનો દૂત મોકલશે, જે તમાંરી મદદ કરશે. ત્યાં તને અમાંરા લોકોમાં માંરા પુત્ર માંટે સ્ત્રી મળશે. ");
INSERT INTO guj2009_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","એ પછી તું મને આપેલા તારા વચનથી મુકત થઇશ. પરંતુ જો તું માંરા પિતાના દેશમાં જા અને તે લોકો માંરા પુત્ર માંટે કન્યા આપવાની ના પાડે તો પણ તું તારા સમથી મુકત છે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“આજે હું આ કૂવા આગળ આવ્યો અને મેં કહ્યું, ‘હે યહોવા, માંરા ધણીના દેવ, કૃપા કરીને માંરા પ્રવાસને સફળ બનાવો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","જો હું આ કૂવા આગળ ઊભો રહું છું. હવે જે યુવાન કન્યા પાણી ભરવા આવે અને જેને હું કહું કે, “તારા ઘડામાંથી મને થોડું પાણી પા.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","અને જો તેણી મને કહે, “પાણી પીઓ, હું તમાંરાં ઊંટો માંટે પણ પાણી લાવીશ.” એ રીતે હું જાણીશ કે, તેણી માંરા ધણીના પુત્ર માંટે યહોવાએ પસંદ કરેલ યોગ્ય કન્યા છે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“માંરી પ્રાર્થના પૂરી થતાં પહેલા જ રિબકા કૂવા પર પાણી ભરવા આવી. પાણીનો ઘડો તેના ખભા પર હતો તે ઊતારીને પાણી ભર્યું. મેં તેને કહ્યું, કૃપા કરીને મને થોડું પાણી આપો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","તેણીએ તરત જ ઘડો નમાંવ્યો અને કહ્યું, ‘પીઓ અને હું તમાંરા ઊંટો માંટે પણ પાણી લાવીશ.’ તેથી મેં પાણી પીધું અને તેણીએ માંરા ઉંટોને પણ પીવા માંટે પાણી આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","પછી મેં એને પૂછયું, ‘તારા પિતા કોણ છે?’ એણે ઉત્તર આપ્યો, ‘માંરા પિતા બથુએલ છે. માંરા પિતાના માંતાપિતા મિલ્કાહ અને નાહોર છે.’ એટલે મેં એના નાકમાં વાળી અને હાથમાં બંગડીઓ પહેરાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","પછી મેં સાષ્ટાંગ પ્રણામ કર્યા અને માંરા ધણીના દેવની સ્તુતિ કરી. કારણ કે તે મને સાચા માંર્ગે દોરી લાવ્યા, જેથી હું માંરા ધણીના પુત્ર માંટે તેના ભાઈની પુત્રી પસંદ કરી શકું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","હવે તમે શું કરશો? તે કહો. શું તમે માંરા ધણી પ્રત્યે દયાળુ અને શ્રધ્ધાળુ બનશો અને તમાંરી પુત્રી તેને આપશો? કે, પછી તમાંરી પુત્રી આપવાની ના પાડશો? એ મને જણાવો, જેથી માંરે કયે રસ્તે જવું તેની ખબર પડે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","પછી લાબાને અને બથુએલે જવાબ આપ્યો, “અમે જોઈએ છીએ કે, આ બધું યહોવાની ઈચ્છાથી થયું છે. તેથી અમે તેને બદલવા માંટે કઇ પણ કહી શકીએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","આ રિબકા તમાંરી આગળ છે, એને લઈ જાઓ અને તમાંરા ધણીના પુત્ર સાથે પરણાવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ઇબ્રાહિમના નોકરે આ સાંભળ્યું અને તેણે યહોવાને સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","પછી તેણે પોતે જે સાથે લાવ્યો હતો તે ભેટો રિબકાને આપી. તેણે રિબકાને સોનારૂપાના દાગીના તથા સુંદર વસ્રો કાઢીને રિબકાને આપ્યાં. તેણે તેના ભાઈ અને તેની માંને કિંમતી ભેટો આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","તેણે અને તેની સાથેના માંણસોએ ત્યાં ખાધુંપીધું અને ત્યાં જ રાત રહ્યાં. બીજે દિવસે સવારે ઊઠયા અને બોલ્યા, “હવે અમે અમાંરા ધણીની પાસે જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","રિબકાની માં અને ભાઈએ કહ્યું, “રિબકાને અમાંરા લોકોની સાથે થોડા દિવસ રહેવા દો; કંઈ નહિ તો દશ દિવસ તો રહેવા દો, ત્યાર પછી તે આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","પરંતુ નોકરે તેઓને કહ્યું, “મને રોકશો નહિ, યહોવાએ માંરો પ્રવાસ સફળ બનાવ્યો છે. હવે મને જવા દો જેથી હું માંરા ધણીને જઈને મળું.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","રિબકાના ભાઈ અને માંએ કહ્યું, “અમે રિબકાને બોલાવીને પૂછીએ છીએ કે, તે શું ઈચ્છે છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","તેઓએ રિબકાને બોલાવી અને તેને પૂછયું, “શું તું આ માંણસ સાથે હમણા જ જવા ઈચ્છે છે?” રિબકાએ કહ્યું, “હા, હું જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","તેથી તેઓએ રિબકાને ઇબ્રાહિમના નોકર અને તેના સાથીઓ સાથે વિદાય કર્યા. રિબકાની દાસી પણ તેની સાથે ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","જયારે તે વિદાય થતી હતી ત્યારે આશીર્વાદ આપ્યા કે, “અમાંરી બહેન, લાખો પુત્રોની માંતા થાઓ, અને તારા વંશજો દુશ્મનોના શહેરો કબજે કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","પછી રિબકા અને તેની દાસીઓ ઊંટ પર સવાર થઈ અને નોકર તથા તેની સાથીઓની પાછળ પાછળ ચાલવા લાગી. આ રીતે નોકરે રિબકાને સાથે લીધી અને ઘેર પાછા ફરવા માંટેની યાત્રા શરુ કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","તે સમયે ઇસહાકે બેર-લાહાય-રોઇ છોડી દીધું હતું અને નેગેબમાં રહેવાનું શરૂ કર્યુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","એક દિવસ સાંજે તે ખેતરમાં ફરવા ગયો હતો. ત્યાં તેણે આંખ ઊંચી કરીને જોયું તો ઊંટો આવતાં દેખાયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","રિબકાએ નજર કરી અને ઈસહાકને જોયો. એટલે તે ઊંટ પરથી ઊતરી પડી. ");
INSERT INTO guj2009_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","તેણે નોકરને પૂછયું, “પેલો માંણસ ખેતરમાં ફરનારો, આપણને મળવા આવે છે તે કોણ છે?” નોકરે કહ્યું, “તે માંરા ધણીનો પુત્ર છે.” એટલે રિબકાએ પોતાનો ચહેરો બુરખામાં છુપાવી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","નોકરે ઇસહાકને જે જે બન્યું હતું તે બધું કહી સંભળાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","પછી ઇસહાક રિબકાને પોતાની માંતાના તંબુમાં લઈ ગયો. તે દિવસે ઇસહાકે રિબકા સાથે વિવાહ કરી લીધા. તે તેની સાથે ખૂબ પ્રેમભાવ રાખતો હતો, તેથી તેને માંતાના મૃત્યુ પછી પણ સાંત્વન પ્રાપ્ત થયું. માંતાના મરણનું દુ:ખ તે ભૂલી શકયો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","પછી ઇબ્રાહિમે બીજા લગ્ન કર્યા, તેની બીજી પત્નીનું નામ કટૂરાહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","કટૂરાહે ઝિમ્રાન, યોકશાન, મદાન, મિદ્યાન, યિશ્બાક અને શૂઆહને જન્મ આપ્યા. યોકશાનને શબા અને દદાન બે પુત્રો થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","અને દદાનના વંશજો આશૂરીમ, લટુશીમ અને લઉમીમ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","મિદ્યાનના પુત્રો એફાહ, એફેર, હનોખ, અબીદા અને એલ્દાઆહ હતા. આ બધા ઇબ્રાહિમ અને કટૂરાહના વંશજો હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","પોતાની બધી મિલકત ઇબ્રાહિમે ઇસહાકને આપી અને દાસીઓના પુત્રોને તેણે ઉપહારો આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ઇબ્રાહિમે મૃત્યુ પહેલા પોતાની દાસીઓના પુત્રોને ઇસહાકથી દૂર પૂર્વના પ્રદેશમાં મોકલી દીધા. તે પછી ઇબ્રાહિમે પોતાની બધી મિલકત ઇસહાકને આપી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ઇબ્રાહિમ 175 વર્ષની ઉંમર સુધી જીવતો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ઇબ્રાહિમ દિવસેને દિવસે વધુને વધુ નબળો પડતો ગયો. પછી સંતોષકારક જીવન જીવીને ખૂબ મોટી ઉંમરે તે મૃત્યુ પામ્યો અને તેને તેના પૂર્વજોની સાથે દફનાવવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","તેના પુત્ર ઇસહાકે અને ઇશ્માંએલે તેને માંમરેની પૂર્વમાં આવેલા સોહાર હિત્તીના એફ્રોનના ખેતરમાં, માંખ્પેલાહની ગુફામાં દફનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","આ એ જ ગુફા અને ખેતર છે જે ઇબ્રાહિમે હિત્તી લોકો પાસેથી ખરીદયા હતાં. ત્યાં ઇબ્રાહિમને તેની પત્ની સારા સાથે દફનાવવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ઇબ્રાહિમના મૃત્યુ પછી દેવે તેના પુત્ર ઇસહાક પર આશીર્વાદો વરસાવ્યા અને તે બેર-લહાય-રોઇ રહેવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ઇશ્માંએલના પરિવારની આ યાદી છે. ઇશ્માંએલ સારાની મિસરી દાસી હાગાર અને ઇબ્રાહિમનો પુત્ર હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ઇશ્માંએલના પુત્રો તેમના જન્મના ક્રમ પ્રમાંણે આ છે: તેનો મોટો પુત્ર નબાયોથ હતો. પછી કેદાર, ");
INSERT INTO guj2009_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","પછી આદબએલ, પછી મિબ્સામ, પછી ");
INSERT INTO guj2009_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","મિશમાં, પછી દુમાંહ, અને પછી માંસ્સા, પછી હદાદ, પછી તેમાં, પછી યટુર, પછી નાફીશ, અને પછી કેદમાંહ, આ ઇશ્માંએલના પુત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","અને એમનાં ગામો અને છાવણીઓનાં નામ એમનાં નામ પરથી જ પડયા છે. અને એ બારે વ્યકિતઓ પોતપોતાના કબીલાના આગેવાન હતા. એ બારે પુત્રો લોકોમાં બાર રાજકુમાંરો સમાંન હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ઇશ્માંએલની ઉંમર 137 વર્ષની થઈ ત્યારે તેનું અવસાન થયું. ");
INSERT INTO guj2009_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ઇશ્માંએલના વંશજો આશૂરને રસ્તે મિસરની પૂર્વ દિશામાં હવીલાહથી શૂર સુધીની ભૂમિમાં વસ્યાં હતા. ઇશ્માંઇલના વંશજોએ તેના ભાઇના લોકો પર ધણી વખત હુમલાઓ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","આ ઇસહાકની કથા છે. ઇબ્રાહિમનો એક પુત્ર ઇસહાક હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ઇસહાકે 40 વર્ષની વયે રિબકા સાથે લગ્ન કર્યા. રિબકા પાદાનારામની વતની હતી. તે અરામના બથુએલની પુત્રી અને અરામના લાબાનની બહેન હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","તેની પત્નીને બાળકો થતાં ન હતા. આથી ઇસહાકે તેના માંટે યહોવાને પ્રાર્થના કરી. યહોવાએ ઇસહાકની પ્રાર્થના સાંભળી અને માંન્ય રાખી અને રિબકા ગર્ભવતી થઇ. ");
INSERT INTO guj2009_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","જયારે રિબકા ગર્ભવતી હતી ત્યારે તેણીનાં ગર્ભમાં બે બાળકો થવાને કારણે તેણીએ સહન કર્યુ. ગર્ભમાં બાળકો એકબીજા સાથે ધક્કામુક્કી કરતાં, એટલે તેણી બોલી, “માંરી સાથે આવું શું કામ બની રહ્યું છે?” તેણીએ યહોવાને પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ત્યારે યહોવાએ તેને કહ્યું, “તારા પેટમાં બે પ્રજાઓ છે, બે પરિવારોના રાજા તમાંરામાંથી જ થશે. જન્મથી જ પરસ્પર વિરોધી એવી બે પ્રજાઓ, એકબીજા કરતાં વધારે બળવાન થશે; મોટો પુત્ર નાના પુત્રની સેવા કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","પૂરા દિવસો થતા રિબકાએ બે જોડકાં બાળકોને જન્મ આપ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","પ્રથમ જનીત બાળક તે લાલ હતો. તેના આખા શરીરે વાળ હતા, જાણે તેણે વાળનો ઝભ્ભો ન પહેર્યો હોય, આથી તેણીએ તેનું નામ એસાવ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","જયારે બીજો બાળક જન્મ્યો ત્યારે તેના હાથે એસાવની એડી પકડેલી હતી, આથી તેનું નામ યાકૂબ પાડયું. એ પુત્રો જન્મ્યા, ત્યારે ઇસહાકની ઉંમર 60 વર્ષની થઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","બાળકો મોટા થયાં ત્યારે “એસાવ” કુશળ શિકારી થયો, અને તે ખેતરોમાં રહેવાનું પસંદ કરતો. જયારે યાકૂબ શાંત પ્રકૃતિનો હતો. અને તંબુઓમાં સ્થિર થઈને રહેતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ઇસહાક એસાવને ખૂબ પ્રેમ આપતો, તે તેને ખૂબ વહાલો હતો. એસાવ શિકાર કરીને જે પશુને લાવતો તેનું માંસ તે ખાતો હતો. પરંતુ યાકૂબ રિબકાને વહાલો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","એક વખત એસાવ શિકાર કરીને પાછો ફર્યોં. તે થાકેલો હતો, ને ભૂખથી પરેશાન હતો. યાકૂબ શાક રાંધી રહ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","તેથી તેણે યાકૂબને કહ્યું, “આ લાલ શાકમાંથી મને થોડું ખાવા માંટે આપ. મને ખૂબ ભૂખ લાગી છે.” (આથી તેનું નામ અદોમ પડયું) ");
INSERT INTO guj2009_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","પરંતુ યાકૂબે કહ્યું, “પહેલાં તું તારો જયેષ્ઠપણાનો હક્ક મને આપ.” ");
INSERT INTO guj2009_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","એસાવે કહ્યું, “હું ભૂખથી મરવા પડયો છું. જો હું મરી જઈશ તો માંરા પિતાનું ધન પણ મને મદદ કરી શકવાનું નથી. તેથી હું તને માંરો ભાગ આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","પરંતુ યાકૂબે કહ્યું, “પહેલાં તું સમ લે કે, તું મને તે આપીશ.” તેથી એસાવે યાકૂબ આગળ સમ ખાધા. અને એસાવે પોતાના પિતાની મિલકતનો પોતાનો ભાગ યાકૂબને આપ્યો અને પોતાનો પ્રથમ પુત્રનો હક્ક પણ યાકૂબને વેચી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","પછી યાકૂબ એસાવને રોટલી અને મસૂરની દાળ આપી. પછી ખાધા-પીધા પછી તે ઊઠીને ચાલ્યો ગયો. આ રીતે એસાવે એ દશાર્વ્યુ કે, તે પોતાના પ્રથમ પુત્ર હોવાના હક્કની પરવા કરતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","એ દેશમાં પહેલાં ઇબ્રાહિમના સમયમાં દુકાળ પડયો હતો, તે સિવાય આ બીજો દુકાળ પડયો. તેથી ઇસહાક ગેરાર નગરના પલિસ્તીઓના રાજા અબીમેલેખ પાસે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","યહોવાએ ઇસહાક સાથે વાત કરી. યહોવાએ ઇસહાકને કહ્યું, “મિસર જઈશ નહિ, હું તને કહું તે દેશમાં જ તું રહેજે. ");
INSERT INTO guj2009_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","અત્યારે તું આ જ દેશમાં રહે; હું તારી સાથે રહીશ અને તને આશીર્વાદ આપીશ. હું તને અને તારા વંશજોને બધા પ્રદેશો આપીશ. અને તારા પિતા ઇબ્રાહિમ આગળ મેં જે સમ ખાધા હતા તે પૂરા કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","હું તારા વંશજોને આકાશના અસંખ્ય તારા જેટલા વધારીશ. અને એમને આ બધા પ્રદેશો આપીશ. અને તારા વંશજોને કારણે પૃથ્વીની બધી પ્રજાઓ આશીર્વાદિત થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","આ હું એટલા માંટે કરીશ, કારણ કે તારા પિતા ઇબ્રાહિમે માંરી આજ્ઞાનું પાલન કર્યું અને મેં જે કહ્યું તે તેણે કર્યુ છે, માંરા આદેશો માંરા વિધિઓ અને માંરા નિયમોનું પાલન કર્યુ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","આમ ઇસહાક ત્યાં રોકાયો અને ગેરારમાં રહેવા લાગ્યો. ત્યાંના લોકોએ તેને તેની સ્ત્રી વિષે પૂછયું ત્યારે તેણે કહ્યું કે, “એ તો માંરી બહેન છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","“રિબકા માંરી પત્ની છે.” એમ કહેવાની ઇસહાકમાં હિંમત નહોતી. તેને ડર હતો કે, લોકો તેની પત્નીને મેળવવા માંટે કદાચ તેને માંરી નાખશે. ");
INSERT INTO guj2009_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ઠીક ઠીક પ્રમાંણમાં ત્યાં રહ્યા બાદ એક દિવસ પલિસ્તીઓના રાજા અબીમેલેખે બારીમાંથી જોયું, તો તેણે ઇસહાકને પત્ની રિબકાને લાડ લડાવતો જોયો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","અબીમેલેખે ઇસહાકને બોલાવ્યો અને કહ્યું, “આ સ્ત્રી તારી પત્ની છે, તેં અમને લોકોને એમ શા માંટે કહ્યું કે, એ માંરી બહેન છે?” ઇસહાકે તેમને કહ્યું, “હું ડરતો હતો, કદાચ તમે તેણીને મેળવવા માંટે મને માંરી નાખશો.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","અબીમેલેખે કહ્યું, “તેં અમાંરા લોકો માંટે આ બહુ જ ખરાબ કર્યુ છે. અમાંરામાંનો કોઈ વ્યકિત તારી પત્ની સાથે સહેજે સૂઈ ગયો હોત અને તેં અમને પાપના દોષમાં નાખ્યા હોત.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","એટલા માંટે અબીમેલેખે બધા લોકોને ચેતવણી આપી કે, “જે કોઈ વ્યકિત આ માંણસને કે, તેની પત્નીને અડકશે તેને માંરી નાખવામાં આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ઇસહાકે તે પ્રદેશમાં ખેતી કરી અને તે જ વષેર્ મબલખ પાક ઉતર્યો. યહોવાએ તેના પર ધણી કૃપા કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ઇસહાક ધનવાન બની ગયો. જયાં સુધી તે મોટો ધનવાન ન બને ત્યાં સુધી તેની સંપત્તિ વધતી જ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","તેની પાસે એટલાં બધાં ઘેટાં-બકરાં અને ઢોરઢાંખર તેમજ નોકર-ચાકર હતા કે, પલિસ્તીઓ તેની ઈર્ષા કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","અને તેથી તે લોકોએ ઇસહાકના પિતા ઇબ્રાહિમના વખતમાં તેના નોકરોએ જે કૂવાઓ ખોધ્યા હતા તે બધા કૂવાઓનો નાશ કર્યો અને તે કૂવાઓને માંટીથી પૂરી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","અબીમેલેખે ઇસહાકને કહ્યું, “તું અમાંરો દેશ છોડી જા, તું અમાંરા લોકો કરતાં વધારે બળવાન થઈ ગયો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","તેથી ઇસહાકે તે જગ્યા છોડી દીધી અને ગેરારની નાની નદીના કાંઠે સપાટ પ્રદેશમાં મુકામ કર્યો, અને ત્યાં જ રહેવા ગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ઇસહાકે તેના પિતા ઇબ્રાહિમના સમયમાં જે કૂવાઓ ખોદાવ્યા હતા તે ફરીથી ખોદાવ્યા. કારણ કે ઇબ્રાહિમના મૃત્યુ પછી પલિસ્તીઓએ તે કૂવાઓ માંટીથી પૂરી દીધા હતા. અને ઇસહાકે તે કૂવાઓનાં નામ તેના પિતાએ જે પાડયાં હતાં તે જ રાખ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ઇસહાકના નોકરોએ નાની નદીની પાસે એક કૂવો ખોદ્યો. તે કૂંવામાંથી એક પાણીનો ઝરો મળી આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ત્યારે ત્યાં ગેરારના ગોવાળોએ ઇસહાકના ગોવાળો સાથે ઝઘડો કર્યો અને કહેવા લાગ્યા, “આ પાણી અમાંરું છે.” તેથી ઇસહાકે તે કૂવાનું નામ એસેક પાડયું. કારણ કે તે જગ્યા પર તે લોકોએ ઝઘડો કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","પછી ઇસહાકના નોકરોએ બીજો કૂવો ખોધ્યો. ત્યાંના લોકોએ તે કૂવા માંટે પણ ઝગડો કર્યો, તેથી તેનું નામ તેણે સિટનાહ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","પછી ત્યાંથી દૂર જઈને બીજો કૂવો ખોધ્યો, તે કૂવા માંટે કોઈ ઝગડો કરવા આવ્યું નહિ તેથી તેણે તેનું નામ “રહોબોથ” રાખ્યું અને કહ્યું, “યહોવાએ અમાંરા માંટે આ જગ્યા નક્કી કરી છે. અમે પ્રગતિ કરીશું. અને આ ભૂમિમાં અમને લાભ મળશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","આ જગ્યાએથી ઈસહાક બેર-શેબા ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ત્યાં તે જ રાત્રે યહોવાએ તેને દર્શન આપીને કહ્યું, “હું તારા પિતા ઇબ્રાહિમનો દેવ છું. ડરીશ નહિ, હું તારી સાથે જ છું અને હું તને આશીર્વાદ આપીશ. હું તારા વંશજોની વૃદ્વિ કરીશ. હું માંરા સેવક ઇબ્રાહિમના માંટે આ બધું કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","એથી ઇસહાકે તે સ્થળે એક વેદી બનાવડાવી અને યહોવાના નામે પ્રાર્થના કરી. ઇસહાકે ત્યાં મુકામ કર્યો, અને ત્યાં તેના નોકરોએ એક કૂવો ખોધ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","પછી અબીમેલેખ ગેરારથી ઇસહાકને મળવા આવ્યો, તે તેની સાથે પોતાના સલાહકાર અહુઝાથ અને પોતાના સેનાપતિ ફીકોલને પણ લાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ઇસહાકે તેમને પૂછયું, “તમે મને મળવા કેમ આવ્યા છો? પહેલા તો તમે માંરી સાથે મિત્રતા રાખતા નહોતા, તમે તો મને માંરા દેશમાંથી કાઢી મૂકયો હતો.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","તેઓએ જવાબ આપ્યો, “હવે અમે લોકોએ જાણ્યું છે કે, યહોવા તમાંરી સાથે છે. એટલે અમે ઈચ્છીએ છીએ કે, તમે અમાંરી સાથે કરાર કરો. ");
INSERT INTO guj2009_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","અમે લોકોએ તમાંરું કોઈ નુકસાન કર્યુ નહોતું, હવે તમાંરે સમ ખાવા જોઈએ કે, અમને લોકોને કોઈ નુકસાન કરશો નહિ. અમે લોકોએ તમને શાંતિથી સહીસલામત રીતે વિદાય કર્યા છે. અને હવે એ સ્પષ્ટ છે કે, યહોવાએ તમને આશીર્વાદ આપ્યાં છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","તેથી ઇસહાકે તેઓને મિજબાની આપી. બધાએ ખાધું ને પીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","બીજે દિવસે સવારે વહેલા ઊઠીને તેમણે અરસપરસ સમ ખાધા; પછી ઇસહાકે તેમને શાંતિથી વિદાય કર્યા. તેઓ ક્ષેમકુશળ મિત્રભાવે જુદા પડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","તે જ દિવસે ઇસહાકના નોકરોએ આવીને પોતે જે કૂવો ખોદ્યો હતો તેની વાત કરી અને કહ્યું, “અમને કૂવામાંથી પીવા માંટે પાણી મળ્યું છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ઇસહાકે એનું નામ શિબાહ પાડયું. આથી એ શહેર આજપર્યંત બેર-શેબા કહેવાય છે. ");
INSERT INTO guj2009_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","જયારે એસાવ 40 વર્ષનો થયો, ત્યારે તેણે હિત્તી બએરીની દીકરી યહૂદીથ અને હિત્તી એલોનની દીકરી બાસમાંથ સાથે લગ્ન કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","આ લગ્નોએ ઇસહાક અને રિબકાને ખૂબ દુ:ખી કરી મૂકયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","જયારે ઈસહાક વૃદ્વ થયો, ત્યારે તેની આંખોની દૃષ્ટિ નબળી પડી અને તેને કઇં પણ ચોખ્ખું દેખાતું ન હતું. એક દિવસ તેણે તેના મોટા પુત્ર એસાવને બોલાવ્યો. ઈસહાકે કહ્યું, “માંરા દીકરા.” ઈસહાકને એસાવે જવાબ આપ્યો, “જી, પિતાજી, હું આ રહ્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ઇસહાકે કહ્યું, “જુઓ, હું વૃદ્વ થઈ ગયો છું. હવે હું જલ્દી મરી જઇશ, ");
INSERT INTO guj2009_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","એટલે તું તારાં હથિયાર, બાણો અને ધનુષ્ય લે અને જંગલમાં જઈને માંરે માંટે શિકાર કરીને કંઈક લાવ. ");
INSERT INTO guj2009_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","અને મને ભાવતી સ્વાદિષ્ટ વાનગી બનાવીને માંરા માંટે લઈ આવ. જેથી હું ખાઉં અને મરતાં પહેલાં તને આશીર્વાદ આપું.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","એટલે એસાવ શિકાર કરવા ગયો. રિબકાએ તે વાતો સાંભળી હતી, જે ઇસહાકે પોતાના પુત્ર એસાવ સાથે કરી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","રિબકાએ તેના પુત્ર યાકૂબને કહ્યું, “સાંભળ, મેં તારા પિતાને તારા ભાઈ સાથે વાતો કરતાં સાંભળ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","તારા પિતાએ કહ્યું, ‘માંરા ખાવા માંટે શિકાર કરીને કંઈક લઈ આવ, અને સ્વાદિષ્ટ ભોજન તૈયાર કર, જેથી હું ખાઉં અને મરતાં પહેલાં દેવની સાક્ષીએ તને આશીર્વાદ આપું.’ ");
INSERT INTO guj2009_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","એટલા માંટે હવે માંરા પુત્ર, હું તને કહું તે પ્રમાંણે કર. ");
INSERT INTO guj2009_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","આપણી બકરીઓનાં ઝુંડમાં જા અને બે સરસ લવારાં માંરી પાસે લઈ આવ. જેથી હું તેમાંથી તારા પિતાને ભાવતી સ્વાદિષ્ટ વાનગી બનાવીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","પછી તું તે તારા પિતાની આગળ લઈ જજે, જેથી તે ખાઈને મરતાં પહેલાં તને આશીર્વાદ આપે.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","પરંતુ યાકૂબે પોતાની માંતા રિબકાને કહ્યું, “પરંતુ માંરા ભાઈ એસાવને તો આખા શરીરે વાળ છે, અને માંરું શરીર વાળ વગરનું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","કદાચ માંરા પિતા જો મને અડકશે તો જાણી જશે કે, હું એસાવ નથી. પછી તે મને આશીર્વાદ આપશે નહિ. તે મને શાપ આપશે કારણકે, મેં તેમને છેતરવાનો પ્રયત્ન કર્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","તેથી રિબકાએ તેને કહ્યું, “કોઈ મુશ્કેલી ઊભી થશે તો તે હું માંરા માંથે લઈ લઇશ. હું જે કહું છું તે કર. જા, અને માંરા માંટે બે લવારાં લઈ આવ.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","એટલે યાકૂબ બહાર ગયો. તેણે બે બકરીઓ પકડી. અને તે તેને તેની માંતા પાસે લાવ્યો. રિબકાએ ઇસહાકની પસંદગી પ્રમાંણે સ્વાદિષ્ટ વાનગી બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","પછી રિબકાએ તે પોષાક જે તેનો મોટો પુત્ર એસાવ પહેરવા માંટે પસંદ કરતો હતો, તે લઈને પોતાના નાના પુત્ર યાકૂબને પહેરાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","અને લવારાંની ખાલ યાકૂબના હાથ પર અને તેની ડોકીના સુંવાળા ભાગ પર ઢાંકી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","પછી તેણે પોતે તૈયાર કરેલી પેલી સ્વાદિષ્ટ વાનગી અને રોટલી પોતાના પુત્ર યાકૂબના હાથમાં આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","યાકૂબે તેના પિતા પાસે જઈને કહ્યું, “પિતાજી!” ઇસહાકે, પૂછયું, “શું છે બેટા? તું કોણ છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","યાકૂબે પોતાના પિતાને કહ્યું, “હું તમાંરો મોટો પુત્ર એસાવ છું, તમે જે કહ્યું હતું તે પ્રમાંણે મેં કર્યુ છે. હવે તમે બેઠા થાઓ, અને મેં જે શિકાર તમાંરા માંટે કર્યો છે તેની વાનગી ખાઈને મને આશીર્વાદ આપો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","પરંતુ ઇસહાકે પોતાના પુત્રને કહ્યું, “બેટા, તને આટલો જલદી કેવી રીતે શિકાર મળી ગયો?” યાકૂબે જવાબ આપ્યો, “કારણ કે તમાંરા દેવ યહોવાએ મને જલદીથી શિકાર ઉપલબ્ધ કરાવ્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","પછી ઇસહાકે યાકૂબને કહ્યું, “બેટા, માંરી પાસે આવ, જેથી હું તારો સ્પર્શ કરી શકું અને જાણી શકું કે, તું માંરો પુત્ર એસાવ છે કે, નહિ?” ");
INSERT INTO guj2009_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","યાકૂબ તેના પિતા ઇસહાક પાસે ગયો. ઇસહાકે, તેનો સ્પર્શ કર્યો અને કહ્યું, “તારો અવાજ તો યાકૂબના અવાજ જેવો જ છે. પરંતુ તારા હાથ તો એસાવના રૂવાંટીવાળા હાથ જેવા જ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ઇસહાકને એ ખબર ના પડી કે, આ યાકૂબ છે, કારણ કે તેના હાથ એસાવના હાથની જેમ રૂવાંટીવાળા હતા. તેથી ઇસહાકે, યાકૂબને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ઇસહાકે કહ્યું, “શું, તું ખરેખર માંરો પુત્ર એસાવ જ છે?” યાકૂબે જવાબ આપ્યો, “હાજી!” ");
INSERT INTO guj2009_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","પછી ઇસહાકે કહ્યું, “ખાવાનું લાઓ. હું તે ખાઈશ અને તને આશીર્વાદ આપીશ.” એથી યાકૂબે તેમને ખાવાનું આપ્યું અને તેમણે ખાધું. પછી તેણે દ્રાક્ષારસ આપ્યો, અને તેણે તે પીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","પછી ઈસહાકે તેને કહ્યુ, “પુત્ર, માંરી પાસે આવ, અને મને ચુંબન કર.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","તેથી યાકૂબ પોતાના પિતાની પાસે ગયો અને ચુંબન કર્યુ. ઇસહાકે, એસાવનાં વસ્રોની ગંધ પારખી અને તેને આશીર્વાદ આપ્યા. ઇસહાકે કહ્યું, “અરે! માંરા પુત્રના શરીરની વાસ તો યહોવાએ આશીર્વાદ આપેલા ખેતરની વાસ જેવી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","દેવ તારા માંટે આકાશમાંથી ઝાકળ વરસાવો. જેથી તમને મબલખ પાક અને દ્રાક્ષારસ મળે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","બધા લોકો તમાંરી સેવા કરે. રાષ્ટ તમાંરી શરણે આવે, તમે તમાંરા ભાઈઓ ઉપર શાસન કરો. તારી માંતાના પુત્રો તારા ચરણોમાં નમે. અને તારી આજ્ઞાનું પાલન કરો. પ્રત્યેક વ્યકિત જે તમને શાપ આપશે તે શાપ તેના પર ઊતરશે અને જે વ્યકિત આશીર્વાદ આપશે, તે આશીર્વાદ પામશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ઇસહાકે યાકૂબને આશીર્વાદ આપવાના પૂરા કર્યા. પછી તરત જ યાકૂબ પિતા ઇસહાક પાસેથી ચાલ્યો ગયો. તે જ સમયે એસાવ શિકાર કરીને અંદર આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","એસાવે પોતાના પિતાની પસંદગીનું વિશિષ્ટ ભોજન બનાવીને પોતાના પિતા પાસે મૂકયું. તેણે તેના પિતાને કહ્યું, “પિતાજી, ઊઠો અને ભોજન કરો. તમાંરા પુત્રએ તમાંરા માંટે શિકાર કર્યો છે, તે જમો. પછી તમે મને આશીર્વાદ આપી શકો છો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","પરંતુ ઇસહાકે તેને કહ્યું, “તું કોણ છે?” તેણે જવાબ આપ્યો, “હું આપનો મોટો પુત્ર એસાવ.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","પછી ઇસહાક ખળભળી ઊઠયો, તેણે પૂછયું, “તો પછી તું આવ્યો તે પહેલાં શિકાર કરીને માંરી આગળ લઈ આવ્યો તે કોણ? મેં તો ખાઈને તેને આશીર્વાદ પણ આપ્યો! આશીર્વાદને પાછો ખેંચવાનો સમય તો જતો રહ્યો. અને એ તો હવે કાયમ જ રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","એસાવે પોતાના પિતાનાં વચનો સાંભળ્યા. તેનું મન કડવાશ અને ગુસ્સાથી ભરાઈ ગયું. તેણે ખૂબ મોટેથી કારમી બૂમ પાડીને પોતાના પિતાને કહ્યું, “પિતાજી, તો પછી મને પણ આશીર્વાદ આપો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ઇસહાકે કહ્યું, “તારા ભાઈએ માંરી સાથે છળ કરીને તારા આશીર્વાદ લઈ ગયો.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","એસાવે કહ્યું, “એનું નામ જ યાકૂબ કપટી છે. તે નામ તેને યોગ્ય છે. તેને એ નામ બરાબર આપવામાં આવ્યું છે. તેણે માંરી સાથે બે વાર કપટ કર્યુ છે; તેણે માંરો જ્યેષ્ઠપુત્ર તરીકેનો હક્ક તો લઈ જ લીધો હતો અને હવે માંરે લેવાના આશીર્વાદ પણ તેણે લઈ જ લીધા. શું તમે માંરા માંટે કોઈ આશીર્વાદ રાખ્યા છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ઇસહાકે જવાબ આપ્યો, “નાજી, હવે તો ઘણું મોડું થઇ ગયું છે. મેં યાકૂબને તારા પર શાસન કરવાનો અધિકાર આપી દીધો છે. મેં એમ પણ કહી દીધું છે કે, બધા ભાઇઓ એના સેવક બનશે. મેં તેને પુષ્કળ અનાજ અને દ્રાક્ષારસની જોગવાઇના આશીર્વાદ આપ્યા છે. બેટા, તને આપવા માંટે હવે માંરી પાસે કશું જ રહ્યું નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","પરંતુ એસાવ પોતાના પિતા પાસે માંગતો જ રહ્યો, “પિતાજી, શું તમાંરી પાસે એક પણ આશીર્વાદ નથી? પિતાજી, મને પણ આશીર્વાદ આપો.” એમ કહીને એસાવ મોટા સાદે રડવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","પછી ઇસહાકે તેને કહ્યું, “તારો વાસ સારી ફળદ્રુપ ભૂમિ પર નહિ હોય, જયાં જમીન ફળતી નહિ હોય અને આકાશમાંથી ઝાકળ પણ વરસતું નહિ હોય. તારી પાસે વધારે અનાજ પણ નહિ હોય. ");
INSERT INTO guj2009_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","તારે જીવવા માંટે સંઘર્ષ કરવો પડશે, તારે તારા ભાઈનો સેવક બની જવું પડશે. પરંતુ તું સ્વતંત્રતા માંટે લડીશ અને તેની ઝૂંસરી ફગાવીને મુકત થઈ જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","તે પછી આ આશીર્વાદને કારણે એસાવ યાકૂબની ઘૃણા કરતો રહ્યો. તેણે મનોમન વિચાર્યુ, “માંરા પિતા જલદીથી મૃત્યુ પામશે અને હું તેનો શોક મનાવીશ. પરંતુ તે પછી હું યાકૂબને માંરી નાખીશ.” એસાવના મનમાં યાકૂબ પ્રત્યે વેરવૃત્તિ જાગી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","રિબકાને એસાવ દ્વારા યાકૂબને માંરી નાખવાના ષડયંત્રની જાણ થઈ. તેણે યાકૂબને બોલાવીને કહ્યું, “સાંભળ, તારો ભાઈ એસાવ તને માંરી નાખવાનું ષડયંત્ર કરી રહ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","તેથી હવે, હે પુત્ર, હું કહું તેમ કરજે, માંરો ભાઈ લાબાન હારાનમાં રહે છે. તેની પાસે જા અને ત્યાં છુપાઈને રહે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","તારા ભાઈનો ક્રોધ ના શમે ત્યાં સુધી થોડો સમય તું તેની પાસે રહે. ");
INSERT INTO guj2009_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","થોડા સમય પછી તેં જે કાંઈ કર્યુ છે તે તારો ભાઈ ભૂલી જશે પછી હું તને તેડાવી લઈશ. હું એક જ દિવસે તમને બન્નેને ગુમાંવવા માંગતી નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","પછી રિબકાએ ઇસહાકને કહ્યું, “તારા પુત્ર એસાવે હિત્તી કન્યાઓ સાથે વિવાહ કરી લીધા છે. હું એ સ્ત્રીઓથી કંટાળી ગઈ છું. કારણ કે તેઓ આપણા લોકોમાંની નથી. અને જો યાકૂબ પણ આ કન્યાઓમાંથી કોઈ એકની સાથે વિવાહ કરશે તો પછી માંરે તો મરવા સિવાય કોઈ રસ્તો નહિ રહે.” ");
INSERT INTO guj2009_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ઇસહાકે યાકૂબને બોલાવીને આશીર્વાદ આપ્યા. પછી તેને આદેશ આપીને કહ્યું, “તારે કોઈ કનાની કન્યા સાથે વિવાહ કરવાના નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","તેથી તું આ સ્થળ છોડીને પાદૃાનારામ જા, તારા દાદા બથુએલને ત્યાં જા. જયાં તારા માંમાં લાબાન રહે છે. તેમની પુત્રીઓમાંથી કોઈ એક સાથે તું વિવાહ કર. ");
INSERT INTO guj2009_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","હું પ્રાર્થના કરું છું કે, સર્વસમર્થ દેવ તને આશીર્વાદ આપો અને તમને ઘણા પુત્રો આપે. અને તારો વંશવેલો એટલો વધારો કે, તારામાંથી અનેક પ્રજાઓ પેદા થાય. ");
INSERT INTO guj2009_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","હું પ્રાર્થના કરું છું કે, જે પ્રમાંણે દેવે ઇબ્રાહિમને વરદાન આપ્યું હતું તે જ પ્રમાંણે તમને પણ આશીર્વાદ આપે. હું પ્રાર્થના કરું છું કે, દેવ તમને ઇબ્રાહિમના આશીર્વાદ આપે. તે તને અને તારી ભાવિપેઢીને આ જગ્યા કે, જયાં તમે પરદેશીની જેમ રહો છો તેને સદાને માંટે તમાંરી સંપત્તિ બનાવી દે.” ");
INSERT INTO guj2009_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","આ રીતે ઇસહાકે યાકૂબને પાદૃાનારામમાંના પ્રદેશમાં મોકલ્યો, યાકૂબ ત્યાં તેના માંમાંને ત્યાં ગયો. અરામી બથુએલ, લાબાન અને રિબકાનો પિતા હતો. અને રિબકા યાકૂબ અને એસાવની માંતા હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","એસાવને ખબર પડી કે, તેના પિતા ઇસહાકે યાકૂબને આશીર્વાદ આપ્યા છે અને તેમણે યાકૂબને પાદૃાનારામમાં પત્નીની શોધ માંટે મોકલ્યો છે. અને એસાવને એ પણ ખબર પડી ગઈ કે, ઇસહાકે યાકૂબને આદેશ આપ્યો છે કે, તે કનાની કન્યા સાથે લગ્ન ન કરે. ");
INSERT INTO guj2009_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","આથી એસાવ સમજયો કે, યાકૂબ પોતાનાં માંતાપિતાનું કહ્યું માંનીને પાદ્દાનારામ ચાલ્યો ગયો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","તે પરથી એસાવે વિચાર્યુ કે, તેના પિતા એવું ઈચ્છતા નથી કે, તેમનો પુત્ર કનાની સ્ત્રી સાથે લગ્ન કરે. ");
INSERT INTO guj2009_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","એસાવને પહેલાની બે પત્નીઓ તો હતી, પરંતુ તેણે ઇશ્માંએલની પુત્રી નબાયોથની બહેન માંહાલાથ સાથે વિવાહ કર્યા. (ઇશ્માંએલ ઇબ્રાહિમનો પુત્ર હતો.) ");
INSERT INTO guj2009_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","યાકૂબે બેર-શેબા છોડયું અને ત્યાંથી તે હારાન તરફ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","યાત્રા સમયે સૂર્યાસ્ત થઈ ગયો હોવાથી તે એક જગ્યાએ રાતવાસો કરવા માંટે રોકાયો. યાકૂબે ત્યાં એક પથ્થર જોયો, તેથી સૂઈ જવા માંટે તેના પર માંથું મૂકયું. ");
INSERT INTO guj2009_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","યાકૂબને એક સ્વપ્ન આવ્યું; તેણે જોયું કે, એક સીડી પૃથ્વી પર મૂકેલી છે, જેની ટોચ આકાશ સુધી પહોંચે છે, ");
INSERT INTO guj2009_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","અને યાકૂબે જોયું તો દેવદૂતો સીડી ઉપરથી ચઢતા-ઊતરતા હતા. અને યહોવા સીડી પાસે ઊભા હતા. યહોવાએ કહ્યું, “હું તમાંરા પિતા ઇબ્રાહિમનો દેવ યહોવા છું. હું ઇસહાકનો દેવ છું. જે જમીન પર તું સૂતો છે તે જમીન હું તને અને તારા વંશજોને આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","પૃથ્વી પર માંટીના જેટલાં રજકણ છે તેટલા તારા વંશજો હશે. તેઓ પૂર્વ-પશ્ચિમ તથા ઉત્તર દક્ષિણમાં ફેલાશે. અને તારા તથા તારા વંશજોને કારણે પૃથ્વી પરની બધી પ્રજાઓ આશીર્વાદ પ્રાપ્ત કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“હું તમાંરી સાથે છું અને હું તમાંરું રક્ષણ કરીશ. તમે જયાં જશો ત્યાંથી હું તમને પાછો આ ભૂમિ પર લઈ આવીશ. મેં તને જે કરવાનું વચન આપ્યું છે તે જયાં સુધી પૂરું નહિ કરી લઉં ત્યાં સુધી હું તારો સાથ છોડવાનો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","પછી યાકૂબ ઊંઘમાંથી જાગ્યો અને બોલ્યો, “મને ખબર છે કે, યહોવા આ જગ્યા પર છે. પરંતુ જયાં સુધી હું અહીં સૂતો ન હતો, ત્યાં સુધી જાણતો નહોતો કે, તે અહીં છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","યાકૂબને બીક લાગી, તેણે કહ્યુ, “આ તો કોઈ મહાન જગ્યા છે. આ તો દેવનું ઘર છે. આ તો આકાશનું દ્વાર છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","બીજે દિવસે સવારે યાકૂબ વહેલો ઊઠયો, અને જે પથ્થર તેને માંથા નીચે મૂકયો હતો તે ઊઠાવ્યો. અને તેને સ્માંરકસ્તંભ તરીકે ઊભો મૂકી દીધો. પછી તેણે તેના પર તેલ રેડ્યું. આ રીતે તેણે આ પથ્થરને દેવનો સ્માંરક સ્તંભ બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","આ જગ્યાનું નામ પહેલાં લૂઝ હતું પરંતુ યાકૂબે તે જગ્યાનું નામ બેથેલ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","પછી યાકૂબે એક પ્રતિજ્ઞા કરી. તેણે કહ્યું, “જો દેવ માંરી સાથે રહેશે, અને હું પ્રવાસમાં જયાં જયાં જાઉં ત્યાં દેવ માંરી રક્ષા કરશે અને મને ખાવાને અન્ન અને પહેરવાને વસ્રો આપશે. ");
INSERT INTO guj2009_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","જેથી હું માંરા પિતાને ઘેર સુરક્ષિત પાછો આવીશ. તો યહોવાને હું માંરા દેવ માંનીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","આ જગ્યા પર જયાં મેં પથ્થર ઊભો કર્યો છે, તે જગ્યા પવિત્ર સ્થાન બનશે. અને દેવ તું મને જે કાંઈ આપશે તેનો દશમો ભાગ હું તને અર્પણ કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","પછી યાકૂબે પોતાનો પ્રવાસ ચાલુ રાખ્યો, તે પૂર્વના લોકોના પ્રદેશમાં પહોંચ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","યાકૂબે એક નજર કરી, તો ત્યાં તેણે વગડામાં એક કૂવો જોયો. અને કૂવા પાસે ઘેટાંનાં ત્રણ ટોળાં હતાં. એ કૂવામાંથી ઘેટાંનાં ટોળાને પાણી પીવડાવવામાં આવતું હતું. એક મોટા પથ્થરથી કૂવાનું મોઢું ઢાંકેલું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","અને જયારે બધાં ઘેટાં ભેગાં થઈ જતાં ત્યારે ઘેટાંપાળકો કૂવાના મોં પરથી પથ્થર હટાવતા હતા. પછી બધાં ઘેટાં તેનું પાણી પી શકતાં હતાં. જયારે બધાં ઘેટાં પાણી પી લેતાં એટલે ઘેટાંપાળકો કૂવાના મોં પર ફરીથી પથ્થર ઢાંકી દેતા. ");
INSERT INTO guj2009_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","યાકૂબે ઘેટાંપાળકોને પૂછયું, “ભાઈઓ, તમે લોકો કયાંથી આવો છો?” તેઓએ જવાબ આપ્યો, “અમે હારાનના છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","પછી યાકૂબે પૂછયું, “શું તમે લોકો નાહોરના પુત્ર લાબાનને ઓળખો છો?” ગોવાળિયાઓએ કહ્યું, “અમે લોકો તેને ઓળખીએ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","પછી યાકૂબે પૂછયું, “તે કુશળ તો છે ને?” તેઓએ કહ્યું, “તેઓ કુશળ છે. બધુ જ સરસ છે. જુઓ, પેલી તેની પુત્રી રાહેલ તેનાં ઘેટાં સાથે આવી રહી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","યાકૂબે કહ્યું, “જુઓ, હજુ દિવસ છે અને સૂર્યાસ્ત થવાને હજુ ધણી વાર છે. રાતને માંટે ઢોરોને એકઠાં કરવાનો વખત થયો નથી. તેથી તેને પાણી પાઈને ફરીથી મેદાનમાં ચરવા માંટે જવા દો.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","પરંતુ તે ઘેટાંપાળકે કહ્યું, “જયાંસુધી બધાં ઘેટાંનાં ટોળાં ભેગા થાય નહિ ત્યાં સુધી અમે એમ કરી શકીએ નહિ, બધા ટોળાં ભેગાં થાય તે પછી જ કૂવાના મુખ પરથી પથ્થર હઠાવીશું અને બધા ઘેટાં પાણી પીશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","યાકૂબ ઘેટાંપાળકો સાથે વાત કરતો હતો ત્યારે જ રાહેલ પોતાનાં પિતાનાં ઘેટાં સાથે આવી. (રાહેલનું કામ ઘેટાં ચારવાનું હતું.) ");
INSERT INTO guj2009_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","રાહેલ લાબાનની પુત્રી હતી. લાબાન રિબકાનો ભાઈ હતો. અને રિબકા યાકૂબની માંતા હતી. જયારે યાકૂબે રાહેલને જોઈ, ત્યારે તેણે કૂવા પરનો પથ્થર હઠાવ્યો અને ઘેટાંઓને પાણી પાયું. ");
INSERT INTO guj2009_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","પછી યાકૂબ રાહેલને ચૂમીને પોક મૂકીને રડ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","પછી યાકૂબે રાહેલને જણાવ્યું કે, હું તારા પિતાના પરિવારનો છું અને રિબકાનો પુત્ર યાકૂબ છું. એટલે રાહેલ દોડતી ઘરે ગઈ અને પિતાને આ બધી વાત કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","લાબાને પોતાની બહેનના પુત્ર યાકૂબના સમાંચાર સાંભળ્યા, તેથી તે ભાણેજને મળવા માંટે દોડયો. અને તેને ભેટી પડયો, ચુંબન કરવા લાગ્યો અને પોતાને ઘેર લઈ આવ્યો. યાકૂબે જે કાંઈ થયું હતું તે બધુંજ લાબાનને કહી સંભળાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","પછી લાબાને કહ્યું, “આશ્ચર્ય! તમે અમાંરા પરિવારના છો!” તેથી યાકૂબ લાબાન સાથે એક મહિના સુધી રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","એક દિવસ લાબાને યાકૂબને કહ્યું, “તું અમાંરે ત્યાં મફતમાં કામ કરતો રહે તે શું યોગ્ય છે? તમે સંબંધી છો, ગુલામ નહિ, બોલો, હું તમને શી મજૂરી આપું?” ");
INSERT INTO guj2009_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","લાબાનને બે પુત્રીઓ હતી. મોટીનું નામ “લેઆહ” અને નાનીનું નામ રાહેલ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","રાહેલ સુંદર હતી અને લેઆહની આંખો સૌમ્ય હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","યાકૂબ રાહેલને પ્રેમ કરતો હતો. યાકૂબે લાબાનને કહ્યું, “જો તમે તમાંરી નાની પુત્રી રાહેલને માંરી સાથે પરણાવો, તો હું તમાંરે માંટે સાત વર્ષ સુધી કામ કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","લાબાને કહ્યું, “હું એને બીજા કોઈની સાથે પરણાવું તેના કરતાં તારી સાથે પરણાવું તે એના માંટે સારું છે. તેથી માંરી સાથે રહો.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","એટલા માંટે યાકૂબ ત્યાં રહ્યો. અને સાત વર્ષ સુધી લાબાન માંટે કામ કરતો રહ્યો. છતાં એ સાત વરસ તેને સાત દિવસ જેવા લાગ્યા, કારણ કે તે રાહેલને ખૂબ પ્રેમ કરતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","સાત વર્ષ પછી તેણે લાબાનને કહ્યું, “હવે મને રાહેલ સોંપી દો, જેથી હું તેની સાથે લગ્ન કરું. તમાંરે ત્યાં કામ કરવાની માંરી મુદત પૂરી થઈ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","તેથી લાબાને તે પ્રદેશના બધા લોકોને ભેગા કર્યા અને ભોજન આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","તે રાત્રે લાબાન પોતાની પુત્રી લેઆહને યાકૂબ પાસે લાવ્યો. યાકૂબે અને લેઆહએ પરપસ્પર શારીરિક સંબંધ બાંધ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","લાબાને પોતાની દાસી ઝિલ્પાહ લેઆહને દાસી તરીકે આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","સવારે યાકૂબે જોયુ કે, તે લેઆહ સાથે સૂતો હતો. યાકૂબે લાબાનને કહ્યું, “તેં માંરી સાથે છળ કર્યુ છે, હું રાહેલ સાથે લગ્ન કરી શકું તે માંટે મેં તમાંરે ત્યાં કેવો સખત પરિશ્રમ કર્યો છે! તમે મને શા માંટે છેતર્યો?” ");
INSERT INTO guj2009_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","લાબાને કહ્યું, “અમાંરા દેશમાં મોટી પુત્રી પહેલાં નાની પુત્રીને પરણાવવાનો રિવાજ અમાંરા લોકોમાં નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","પરંતુ લગ્નોત્સવની વિધિ પૂરા અઠવાડિયા સુધી માંણો, અને હું રાહેલને પણ તારી સાથે પરણાવીશ. પરંતુ એ માંટે તારે બીજા સાત વર્ષ માંરી સેવા કરવી પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","તેથી યાકૂબે તેનો સ્વીકાર કર્યો અને તેણે લેઆહના લગ્નની વિધિનું સપ્તાહ પૂરું કર્યુ. ત્યાર પછી લાબાને પોતાની દીકરી રાહેલ પણ તેને પરણાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","લાબાને પોતાની દાસી બિલ્હાહ પોતાની પુત્રી રાહેલને દાસી તરીકે આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","તેથી યાકૂબે રાહેલની સાથે પણ શારીરિક સંબંધ બાંધ્યો. અને લેઆહ કરતાં વધારે પ્રેમ રાહેલને આપ્યો. અને યાકૂબે લાબાનને માંટે બીજા સાત વર્ષ સુધી કામ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","યહોવાએ જોયું કે, યાકૂબ લેઆહ કરતાં વધારે રાહેલને પ્રેમ કરે છે, તેથી યહોવાએ લેઆહને બાળકોને જન્મ આપવા યોગ્ય બનાવી, પરંતુ રાહેલને કોઈ સંતાન થયું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","લેઆહે એક પુત્રને જન્મ આપ્યો, તેણે તેનું નામ રૂબેન રાખ્યું. તેણે કહ્યું, “યહોવાએ માંરાં દુ:ખો સામે જોયું છે. માંરા પતિ મને પ્રેમ કરતાં નથી. તેથી કદાચ એવું બને કે, માંરા પતિ મને પ્રેમ કરે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","લેઆહ ફરીવાર ગર્ભવતી થઈ. અને તેણે બીજા પુત્રને જન્મ આપ્યો. તેણે આ પુત્રનું નામ “શિમયોન” રાખ્યું. લેઆહે કહ્યું, “યહોવાએ સાંભળ્યું કે, મને પ્રેમ મળતો નથી તેથી તેણે મને આ પુત્ર આપ્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","લેઆહ ફરીથી ગર્ભવતી થઈ અને ત્રીજા એક પુત્રને જન્મ આપ્યો. તેણે તે પુત્રનું નામ લેવી રાખ્યું. લેઆહએ કહ્યું, “હવે તો નક્કી મને માંરા પતિ પ્રેમ કરશે. મેં તેમના ત્રણ પુત્રોને જન્મ આપ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","પછી લેઆહને ચોથો પુત્ર થયો. તેણીએ એ બાળકનું નામ યહૂદા પાડયું. અને તેણી બોલી, “આ વખતે હું યહોવાની પ્રસંશા કરીશ.” આથી તેણીએ તેનું નામ યહૂદા પાડયું. એ પછી તેણીને સંતાન થતાં બંધ થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","રાહેલે જોયું કે, તે યાકૂબને માંટે બાળકને જન્મ આપવા માંટે અશકિતમાંન છે, તેથી તેને પોતાની બહેન લેઆહની ઈર્ષા થવા માંડી, તેથી તેણે યાકૂબને કહ્યું, “મને સંતાન આપ, નહિ તો હું મરી જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","યાકૂબ રાહેલ પર ક્રોધે ભરાયો, તેણે કહ્યું, “હું દેવ નથી, તને માંતા બનવાથી વંચિત રાખનાર તો એ જ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ત્યારે રાહેલે કહ્યું, “તમે માંરી દાસી બિલ્હાહને તો લઈ શકો છો ને? તમે એને ઋતુદાન કરો એટલે એ માંરા માંટે બાળકને જન્મ આપશે. પછી એના માંરફતે હું માં થઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","આથી રાહેલે પોતાની દાસી બિલ્હાહ યાકૂબને પત્ની તરીકે સોંપી. યાકૂબે બિલ્હાહને ઋતુદાન કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","બિલ્હાહ ગર્ભવતી થઈ અને યાકૂબ માંટે તેણે એક પુત્રને જન્મ આપ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","રાહેલે કહ્યું, “આખરે દેવે માંરી પ્રાર્થના સાંભળી ખરી, તેણે મને એક પુત્ર આપવાનો ન્યાય કર્યો.” તેથી રાહેલે એ પુત્રનું નામ દાન રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","બિલ્હાહ ફરી ગર્ભવતી થઈ, અને તેને યાકૂબથી બીજો પુત્ર અવતર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","રાહેલે કહ્યું, “મેં માંરી બહેન સાથે મુકાબલામાં ભારે લડત આપી છે. અને મને વિજય મળ્યો છે.” એથી તેણે એ પુત્રનું નામ નફતાલી રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","પછી લેઆહે વિચાર્યુ કે, તે હવે વધારે બાળકોને જન્મ આપી શકે તેમ નથી. એટલે પોતાની દાસી ઝિલ્પાહ યાકૂબને પત્ની તરીકે આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","પછી ઝિલ્પાહને યાકૂબથી એક પુત્ર અવતર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","લેઆહે કહ્યું, “હું ભાગ્યશાળી છું.” હવે સ્ત્રીઓ મને સદભાગી કહેશે. તેથી તેણે પુત્રનું નામ ગાદ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ઝિલ્પાહએ બીજા પુત્રને જન્મ આપ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","લેઆહ બોલી, “હું કેવી સુખી છું!” તેથી તેણે એ પુત્રનું નામ આશેર રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ઘઉંની કાપણીના સમયે રૂબેન ખેતરે ગયો ત્યાં તેણે કેટલાંક વિશેષ પ્રકારનાં ફૂલો જોયાં. રૂબેને તે ફૂલો લાવીને પોતાની માંતા લેઆહને આપ્યાં. ત્યારે રાહેલે લેઆહને કહ્યું, “કૃપા કરીને મને તારો પુત્ર જે ફૂલો લાવ્યો છે તેમાંથી થોડાં ફૂલો આપ.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","લેઆહે જવાબ આપ્યો, “તેં તો માંરા પતિને પહેલાંથી જ લઈ લીધો છે, હવે તું માંરા પુત્રનાં ફૂલોને પણ લઈ લેવા માંગે છે?” પરંતુ રાહેલે કહ્યું, “જો તું તારા પુત્રનાં ફૂલ મને આપીશ તો તેના બદલામાં આજે રાત્રે તું યાકૂબની સાથે સૂવા જઈ શકીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","તે રાત્રે યાકૂબ ખેતરેથી પાછો ફર્યો એટલે લેઆહ તેને મળવા ગઈ. તેણે યાકૂબને કહ્યું, “આજે રાત્રે તમાંરે માંરી સાથે સૂવાનું છે. મેં માંરા પુત્રનાં ફૂલો રાહેલને તમાંરી કિંમતનાં રૂપમાં આપ્યા છે.” તેથી યાકૂબ તે રાત્રે લેઆહ સાથે સૂતો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","તેથી દેવે લેઆહને ફરીથી ગર્ભવતી થવા દીધી. તેણે યાકૂબના પાંચમાં પુત્રને જન્મ આપ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","લેઆહ બોલી, “મેં માંરી દાસી માંરા પતિને આપી તેથી દેવે મને તેનો બદલો આપ્યો છે.” તેથી લેઆહે પોતાના પુત્રનું નામ ઈસ્સાખાર રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","લેઆહ ફરી વાર ગર્ભવતી થઈ અને તેણે છઠ્ઠા પુત્રને જન્મ આપ્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","લેઆહે કહ્યું, “દેવે મને એક સુંદર ભેટ આપી છે. હવે જરૂર યાકૂબ મને અપનાવશે, કારણ કે મેં એને છ બાળકો આપ્યાં છે.” એટલે લેઆહે તે પુત્રનું નામ ઝબુલોન રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","એ પછી લેઆહને એક પુત્રી અવતરી. તેણે પુત્રીનુ નામ દીનાહ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","પછી દેવે રાહેલની અરજ સાંભળી, દેવે રાહેલને વાંઝિયામેહણું ટાળવા માંટે સમર્થ બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","રાહેલ ગર્ભવતી થઈ અને તેણે એક પુત્રને જન્મ આપ્યો. રાહેલે કહ્યું, “દેવે મને વાંઝણી બનવાથી બચાવી અને મને એક પુત્ર આપ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","તેથી રાહેલે પોતાના પુત્રનું નામ યૂસફ રાખ્યું એમ કહેતાં દેવ હજુ મને બીજો દીકરો આપે. ");
INSERT INTO guj2009_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","યૂસફના જન્મ પછી યાકૂબે લાબાનને કહ્યું, “હવે મને માંરે ઘેર જવા દો. ");
INSERT INTO guj2009_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","જેમને માંટે મેં તમાંરી નોકરી કરી તે માંરી પત્નીઓ અને બાળકો મને સોંપી દો, એટલે હું ઘરભેગો થાઉં. તમે જાણો છો કે, મેં તમાંરી કેવી નોકરી કરી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","લાબાને તેને કહ્યું, “મને થોડું કહેવા દે, મને અનુભવ થયો છે કે, તારા કારણે યહોવાએ માંરા પર કૃપા કરી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","માંટે તું કહે, હું તને શું આપું? તું જે મજૂરી કહેશે તે હું આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","યાકૂબે જવાબ આપ્યો, “તમે પોતે જાણો છો કે, મેં તમાંરે માંટે કેવો સખત પરિશ્રમ કર્યો છે. અને તમાંરાં ઘેટાંબકરાંની મેં કેવી સંભાળ રાખી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","હું આવ્યો ત્યારે તમાંરી પાસે તે થોડાં હતાં અને હવે તેમાં ઘણો વધારો થયો છે. જયારે જયારે મેં તમાંરા માંટે જે કાંઈ કર્યું છે, ત્યારે ત્યારે યહોવાએ તમાંરા પર કૃપા કરી છે. હવે, માંરા માંટે સમય પાકી ગયો છે જેથી હું પોતાના માંટે કાંઈ કરું. પછી હું માંરા પોતાના પરિવાર માંટે ઘરની જોગવાઈ કયારે કરીશ?” ");
INSERT INTO guj2009_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","પછી લાબાને પૂછયું, “તો પછી હું તને શું આપું?” યાકૂબે જવાબ આપ્યો, “હું નથી ઈચ્છતો કે, તમે મને કશું આપો. હું તો ફકત એટલું જ ઈચ્છું છું કે, મેં જે કાંઈ કામ કર્યુ છે તેની કિંમત મને ચૂકવી દો. તમે જો આટલું કરશો તો હું ફરી તમાંરાં ઘેટાંબકરાં ચરાવીશ અને તેમની સંભાળ રાખીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","આજે મને તમાંરાં ઘેટાંબકરાંનાં બધાં ટોળામાં જે દરેક ઘેટાં અને બકરાં કાબરચીતરાં હોય અને જે દરેક ઘેટાં અને બકરાં ટપકાં વાળા હોય અને દરેક યુવાન કાળી બકરી હોય તે લેઇ જવા દો. અને એ માંરી મજૂરી હશે. ");
INSERT INTO guj2009_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ભવિષ્યમાં તમે સરળતાથી જોઈ શકશો કે, હું કેટલો પ્રામાંણિક અને વફાદાર છું. તમે તપાસ કરવા આવશો ત્યારે માંરી પ્રામાંણિકતા પુરવાર થશે. માંરી પાસેનાં ઘેટાંબકરાંમાંનું જે કોઈ બકરું કાબરચીતરું કે, ટપકાંવાળું ન હોય અને જે ઘેટું કાળું ન હોય તે ચોરેલું છે એમ ગણાશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","લાબાને કહ્યું, “સારું, તારી વાત મને મંજૂર છે, અમે તને તું જે કાંઈ માંગીશ તે આપીશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","પરંતુ તે દિવસે લાબાને જેટલાં બકરાં કાબરચીતરાં અને ટપકાંવાળા હતા અને જેટલી બકરીઓ કાબરચીતરી અને ટપકાવાળી હતી અને જે ઘેટાં કાળાં હતાં તે બધાં જુદાં પાડી સંતાડી દીધાં અને પોતાના પુત્રોને સાચવવા માંટે સોંપી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","તેથી તેના પુત્રોએ બધાં કાબરચીતરાં ઘેટાંબકરાં લઈ લીધાં અને બીજી જગ્યાએ ચાલ્યા ગયા. તેઓએ ત્રણ દિવસ સુધી પ્રવાસ કર્યો. અને પોતાની તથા યાકૂબની વચ્ચે ત્રણ દિવસની મુસાફરી જેટલું અંતર રાખ્યું. યાકૂબે લાબાનનાં બાકીનાં ઘેટાંબકરાં સંભાળી લીધા. પરંતુ તેમાં કોઈ કાબરચીતરાં કે, કાળાં ન હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","તેથી યાકૂબે સફેદ, બદામ, અને ચિનારની લીલી સોટીઓ લઈને તેને છોલીને સોટીઓનો સફેદ ભાગ ખુલ્લો કરીને સફેદ પટા પાડયા. ");
INSERT INTO guj2009_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","યાકૂબે પાણી પીવડાવવાની જગ્યાએ ઘેટાંબકરાંની સામે છોલેલી સોટીઓ રાખી, ઘેટાંબકરાં પાણી પીવા આવતાં ત્યારે તેઓ જોતા. ");
INSERT INTO guj2009_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","પછી જયારે બકરીઓ ડાળીઓની પાસે સવાણે આવતી એટલે તેમને કાબરચીતરાં ચટાપટાવાળાં અને ટપકાંવાળાં અને કાળા બચ્ચાં અવતર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","યાકૂબે કાબરચીતરાં અને કાળાં ઘેટાંઓને બીજા બધાંથી જૂદા પાડયાં. એ રીતે યાકૂબે પોતાનાં પશુઓને લાબાનનાં પશુઓથી જુદાં પાડયાં. તેણે પોતાનાં ઘેટાંઓને લાબાનનાં ઘેટાંઓ સાથે ભળવા દીધા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","જયારે જયારે ટોળામાંનાં મજબૂત ઘેટાંબકરાં જોતા ત્યારે તે તેમની આગળ નીકોમાં અને હવાડાઓમાં પેલી સોટીઓ મૂકતો, જેથી તેઓ સોટીઓ આગળ ગર્ભધાન કરે; ");
INSERT INTO guj2009_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","પણ ટોળામાંનાં નબળાં ઘેટાંબકરાં માંટે તે નીકમાં કે, હવાડામાં સોટીઓ મૂકતો નહિ, આથી નબળાં ઘેટાં બકરાં લાબાનનાં રહ્યાં અને સશકત મજબૂત ઘેટા યાકૂબનાં થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","આમ, યાકૂબ ખૂબ શ્રીમંત થઈ ગયો અને તેની પાસે ઘેટાં બકરાંનાં મોટા મોટા ટોળાં, નોકર ચાકરો, દાસદાસીઓ, ઊંટો અને ગધેડાં થયાં. તે ખૂબ સમૃધ્ધ બન્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","એક દિવસ યાકૂબે લાબાનના પુત્રોને વાતો કરતાં સાંભળ્યા, તેઓએ કહ્યું કે, “યાકૂબે અમાંરા પિતાજીનું સર્વસ્વ લઈ લીધું છે. તે ધનવાન બની ગયો છે અને તેણે અમાંરા પિતાની બધી મિલકત લઇ લીધી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","યાકૂબને એમ પણ થયું કે, લાબાન હવે પહેલાની જેમ મીઠો પ્રેમભાવ રાખતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","યહોવાએ યાકૂબને કહ્યું, “તું તારા પિતૃઓની ભૂમિમાં તારી જન્મભૂમિમાં પાછો ચાલ્યો જા. હું તારી સાથે રહીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","તેથી યાકૂબે રાહેલ અને લેઆહને, જે ખેતરમાં ઘેટાંબકરાં હતાં ત્યાં મળવા માંટે આવવા કહેવડાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","યાકૂબે રાહેલ અને લેઆહને કહ્યું, “હું જાણું છું કે, તમાંરા પિતાજી માંરા પ્રત્યે રોષે ભરાયેલ છે, તેમનો માંરા પ્રત્યે પહેલા જેવો મૈત્રી ભાવ નથી. પણ માંરા પિતાનો દેવ માંરી સાથે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","તમે બંને જાણો છો કે, મેં તમાંરા પિતા માંટે માંરાથી શકય તેટલી સખત મહેનત કરી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","પરંતુ તમાંરા પિતાએ માંરી સાથે દગો કર્યો. દશ વખત તો માંરી મજૂરીના દરમાં ફેરફાર કર્યો છે. છતાં બધાં જ સમયે દેવે મને લાબાનના પ્રપંચમાંથી બચાવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“એક વખત લાબાને મને કહ્યું, ‘તારી મજૂરીના બદલામાં બધી જ ટપકાંવાળી બકરીઓ રાખી શકે છે.’ એણે આમ કહ્યું ત્યારથી બધાં જ ઘેટાંબકરાંને ટપકાંવાળાં બચ્ચાં જ જનમતાં. આ પ્રકારનાં બધાં જ પ્રાણીઓ માંરા હતાં. પરંતુ પછી લાબાને કહ્યું, ‘હું ટપકાંવાળાં પ્રાણીઓ રાખીશ, તું ચટાપટાવાળાં રાખી શકે છે. તે તારી મજૂરી ગણાશે.’ તેના એમ કહ્યા પછી બધાં જ પ્રાણીઓને ચટાપટાવાળાં જ બચ્ચાં જનમતાં, ");
INSERT INTO guj2009_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","આ રીતે દેવે તમાંરા પિતાના ઢોર લઈને મને આપ્યાં છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“જે સમયે ઘેટાંબકરાં ગર્ભધારણ કરવા મળી રહ્યા હતા ત્યારે મેં એક સ્વપ્ન જોયું. મેં જોયું કે, ગર્ભધારણ કરાવનારા નર જાતિનાં ઢોર ચટાપટાવાળા, ટપકાંવાળા અને કાબરચીતરાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","પછી દેવના દૂતે મને સ્વપ્નમાં કહ્યું, ‘યાકૂબ!’ “એટલે મેં કહ્યું, ‘જી!’ ");
INSERT INTO guj2009_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“દેવના દૂતે કહ્યું, ‘જો, ગર્ભધારણ કરનારાં ટોળામાં નર ઢોર બધાં જ ચટાપટાવાળા, ટપકાવાળાં અને કાબરચીતરા છે; હું આમ કહી રહ્યો છું કારણ કે લાબાનનો તારી સાથે દુર્વ્યવહાર મેં જોયો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","હું એ દેવ છું, જે બેથેલમાં તારી પાસે આવેલ એ જગ્યાએ તેં એક વેદી બનાવી અને તેલથી તેનો અભિષેક કર્યો હતો. અને માંરી આગળ શપથ લીધા હતા. હવે ઊભો થા, અને અત્યારે જ આ જગ્યા છોડી દે, અને તારા જન્મસ્થળે પાછો જા.’” ");
INSERT INTO guj2009_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ત્યારે રાહેલ અને લેઆહે જવાબ આપ્યો, “અમાંરા પિતા પાસે તેમના મૃત્યુ પછી અમને વારસામાં આપવા કશું બાકી રહ્યું છે ખરું?” ");
INSERT INTO guj2009_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","“તેણે અમાંરી સાથે એક અજાણ્યા વ્યકિત જેવું વર્તન કર્યુ છે. તેણે અમને તમાંરી પાસે વેચી દીધા છે અને બધા પૈસા ખચીર્ નાખ્યાં છે જે અમાંરા હોવા જોઇએ. ");
INSERT INTO guj2009_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","દેવે તે બધી જ સંપત્તિ અમાંરા પિતા પાસેથી લઈ લીધી છે, તે બધી અમાંરી છે, અને અમાંરાં બાળકોની છે; માંટે દેવે જે કરવા માંટે કહ્યું છે તે જ તમે કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","તેથી યાકૂબે મુસાફરીની તૈયારી કરી. તેણે પોતાની પત્નીઓ અને પુત્રોને ઊંટ પર બેસાડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","પછી તે તેના પિતા જયાં રહેતા હતા તે કનાન દેશમાં મેસોપોટામિયામાં જે કાંઈ મળ્યું હતું તે બધું લઈને, પોતાનાં બધાં ઢોરને હાંકતો હાંકતો પોતાના પિતા ઇસહાકને મળવા નીકળી પડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","તે સમયે લાબાન પોતાનાં ઘેટાંનું ઊન કાપવા ગયો હતો. તે દરમ્યાન રાહેલે તેના ઘરમાં ધૂસી જઈને પોતાના પિતાના કુળદેવતા ચોરી લાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","યાકૂબે અરામી લાબાનને દગો કર્યો. તેણે લાબાનને બતાવ્યું નહિ કે, તે ત્યાંથી જઈ રહ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","યાકૂબે પોતાનો પરિવાર અને બધી જ મિલકત જલદી જલદી લઈ લીધી અને પછી નદી (ફાત) ઓળંગીને ગિલઆદના પહાડી પ્રદેશ તરફ ચાલવા માંડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ત્રીજે દિવસે લાબાનને ખબર પડી કે, યાકૂબ ભાગી ગયો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","તેથી તેણે પોતાના માંણસોને સાથે લીધા અને સાત દિવસ સુધી તેનો પીછો કયો, છેવટે યાકૂબ ગિલઆદના પહાડી પ્રદેશમાં પકડાઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","પણ તે રાત્રે દેવે લાબાનને સ્વપ્નમાં દર્શન આપીને કહ્યું, “યાકૂબને જે કાંઈ કહો તેના એક-એક શબ્દ માંટે સાવચેત રહેજો, યાકૂબને સારું કે, માંઠું કાંઈ કહીશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","જયારે યાકૂબને લાબાને પકડી પાડયો, ત્યારે તેણે પહાડી પ્રદેશમાં મુકામ કયો હતો. તેથી તેના માંણસોએ એ જ પહાડી પ્રદેશમાં મુકામ કયો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","લાબાને યાકૂબને કહ્યું, “તેં માંરી સાથે દગો શા માંટે કર્યો? અને તું માંરી પુત્રીઓને યુદ્વમાં પકડાયેલી હોય તેમ શા માંટે લઈ જાય છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","તું મને છેતરીને કહ્યા વગર જ ચૂપચાપ કેમ ભાગી ગયો? જો તેં મને જણાવ્યું હોત તો મેં ઉજવણી કરીને વાજતેગાજતે વિદાય આપી હોત. ");
INSERT INTO guj2009_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","તેં મને માંરાં પૌત્રપૌત્રીઓને તથા માંરી પુત્રીઓને છેલ્લી વાર ભેટવા તથા ચુંબન કરવા દીધા નહિ, તેં આમ કરીને બહુ મૂર્ખામીભર્યુ વર્તન કર્યુ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","તને નુકસાન કરવું એ તો માંરા ડાબા હાથની વાત છે. પરંતુ ગઈકાલે રાત્રે તારા પિતાના દેવે મને સ્વપ્નમાં આવીને ચેતવણી આપીને કહ્યું, “ખબરદાર, યાકૂબને જરા પણ સારું કે, માંઠું કહીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","મને ખબર છે કે, તું તારે ઘેર જવા ઘણો આતુર છે, એટલે તું ચાલી નીકળ્યો, એ તો જાણે સમજયા, પરંતુ તેં માંરા ઘરમાંથી દેવોને શા માંટે ચોરી લીધા?” ");
INSERT INTO guj2009_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","યાકૂબે લાબાનને કહ્યું, “હું તમને કહ્યાં વિના એટલા માંટે ચાલી નીકળ્યો કારણ કે હું ડરી ગયો હતો. મને એમ કે તમે તમાંરી પુત્રીઓને જબરજસ્તી માંરી પાસેથી લઈ લેશો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","પરંતુ મેં તમાંરા દેવોની ચોરી કરી નથી. અહીં માંરા કોઈ પણ માંણસ પાસેથી જો તમાંરા દેવો નીકળે તો હું તેને માંરી નાખીશ. તમાંરા માંણસો જે માંરા સાક્ષી બનશે. આપણા માંણસોના દેખતાં માંરી પાસે તમાંરું જે કંઈ હોય તે ઓળખી બતાવો અને લઈ જાઓ.” હવે, યાકૂબને તો ખબર જ નહોતી કે, રાહેલે લાબાનને ઘરેથી દેવો ચોર્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","તેથી લાબાન યાકૂબના તંબુમાં ગયો. તેણે ત્યાં શોધ શરૂ કરી. લેઆહના તંબુમાં પણ ગયો અને બે દાસીઓના તંબુમાં પણ ગયો. પણ તેને દેવ મળ્યાં નહિ, પછી તે લેઆહના તંબુમાંથી નીકળી રાહેલના તંબુમાં પ્રવેશ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","રાહેલે ઊંટના જીનમાં દેવતાઓને સંતાડી દીધા હતા. અને તે તેના પર બેઠી હતી. લાબાને આખા તંબુમાં તપાસ કરી પણ દેવો મળ્યા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","પછી રાહેલે તેણીના પિતાને કહ્યું, “પિતાજી, માંરા પર ગુસ્સો ન કરતા. હું તમાંરી સામે ઊભી રહેવા માંટે પણ અસમર્થ છું. આ સમયે માંરો માંસિકધર્મ ચાલી રહ્યો છે.” તેથી લાબાને આખા તંબુમાં દેવોની તપાસ કરી, પરંતુ તે તેઓને શોધી શકયો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","પછી યાકૂબ બહુ જ ગુસ્સે થયો, યાકૂબે કહ્યું, “મેં શો અપરાધ કર્યો છે? મેં કયા નિયમનો ભંગ કરીને પાપ કર્યુ છે? તમે માંરી પાછળ શા માંટે પડયા છો? ");
INSERT INTO guj2009_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","માંરું જે કાંઈ છે તે બધું તેં તપાસ્યું છતાં તારા ઘરની કોઈ ચીજ તારા હાથમાં આવી ખરી? જો તારા હાથમાં કોઈ ચીજ આવી હોય તો તારા માંણસો અને માંરા માંણસો આગળ રજૂ કર. એ આપણા બંન્નેનો ન્યાય કરે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","મેં તમાંરા માંટે વીસ વર્ષ સુધી કામ કર્યુ છે. તે બધાં જ સમય દરમ્યાન કોઈ પણ બચ્ચું ઘેટીઓનું જન્મ થતી વખતે મૃત્યુ પામ્યું નથી અને ઘેટી પણ મૃત્યુ પામી નથી. મેં તારાં ઘેટાં-બકરાંનાં ટોળામાંથી એક પણ ઢોર ખાધું નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","જો કોઈ જંગલી પ્રાણીઓએ કોઈ ઘેટાને ફાડી નાખ્યું હોય તો મેં તેને તારી આગળ રજૂ કર્યા નથી! એ નુકસાન મેં પોતે ભરપાઈ કર્યુ છે. દિવસે કે, રાતે જે કાંઈ ચોરાઈ જતું તે બધું તમે માંરી પાસે વસૂલ કરતા. ");
INSERT INTO guj2009_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","દિવસના સખત તાપથી અને રાતની સખત ઠંડીથી હું થાકી ગયો હતો. તેથી કાતિલ ઠંડી રાત્રિઓને લીધે હું સૂઇ શકતો નહોતો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","મેં માંરા જીવનનાં વીસ વર્ષ એક ગુલામની જેમ તમાંરા ઘરમાં વિતાવ્યાં છે. પહેલાંના ચૌદ વરસ તમાંરી બે પુત્રીઓને પરણીને મેળવવા માંટે અને છેલ્લા છ વર્ષ મેં તમાંરાં ઘેટાં-બકરાંને સંભાળ્યાં છે, અને તે દરમ્યાન તમે દશ વાર માંરી મજૂરીનાં દરમાં ફેરફાર કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","પરંતુ જો માંરા પૂર્વજોના દેવ, ઇબ્રાહિમના દેવ અને દેવ જેની ઈસહાક ઉપાસના કરે છે તે દેવ માંરા પક્ષમાં ના હોત તો તમે મને ખાલી હાથે કાઢી મૂકયો હોત. પરંતુ દેવે માંરી વેદના અને માંરા કામને ધ્યાનમાં લીધાં. અને ગઇ રાતે દેવે સાબિત કર્યુ કે, હું સાચો છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","લાબાને યાકૂબને કહ્યું, “આ છોકરીઓ તો માંરી પુત્રીઓ છે. તેમનાં બાળકો માંરાં છે. આ ઘેટાંબકરાં માંરાં છે, અને જે બધું તમે અહીં જુઓ છો તે માંરું છે. પરંતુ હું માંરી પુત્રીઓ અને તેનાં બાળકોને રાખવા માંટે કશું જ કરી શકતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","એટલા માંટે હું તમાંરી સાથે કરાર કરવા માંગુ છું કે, આપણે પથ્થરોનો એક ઢગલો કરીશું. જે આપણી વચ્ચે સાક્ષી રહેશે કે, આપણે કરાર કર્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","પછી યાકૂબે એક મોટો પથ્થર કરારના સ્માંરકસ્તંભ તરીકે ઉભો કર્યો કે, જેથી તે પુરવાર કરે કે, તેમણે કરાર કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","પછી તેણે પોતાના માંણસોને પથ્થરા ભેગા કરવા માંટે કહ્યું. તેમણે પથ્થરા ભેગા કરીને એક ઢગલો કર્યો. અને તે ઢગલા પાસે બેસીને તેમણે ભોજન કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","એ જગ્યાનું નામ લાબાને યગાર-સાહદૂથા રાખ્યું અને યાકૂબે તે જગ્યાનું નામ ગાલએદ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","લાબાને યાકૂબને કહ્યું, “આ ખડકોનો ઢગલો આપણને આપણા કરારનું સ્મરણ કરવા મદદ કરશે.” એટલા માંટે યાકૂબે તે જગ્યાનું નામ ગાલએદ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","એટલે લાબાને કહ્યું, “યહોવા આપણા ‘બે’ જુદા થવાના સાક્ષી રહે, અને તે આપણા ઉપર નજર રાખે.” માંટે એ જગ્યાનું બીજું નામ મિસ્પાહ રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","પછી લાબાને કહ્યું. “જો તમે માંરી પુત્રીઓને દુ:ખ આપશો અથવા બીજી સ્ત્રીઓને પરણશો તો દેવ તમને સજા કરશે, અહીં આપણા વચ્ચે કરારનો કોઇ સાક્ષી નથી. અને છતાં, યાદ રાખજો કે, દેવ તમાંરી અને માંરી વચ્ચે સાક્ષી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","પછી લાબાને કહ્યું, “તારી અને માંરી વચ્ચે આ ઢગલો અને આ સ્માંરકસ્તંભ મેં ઊભો કર્યો છે તે આપણને તેનું સ્મરણ કરાવશે કે, આપણે કરાર કર્યો છે. તેનું ધ્યાન રાખજે. ");
INSERT INTO guj2009_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","આ પથ્થરનો ઢગલો અને આ સ્માંરકસ્તંભ પણ સાક્ષી છે, તે આપણને આપણા કરારનું સ્મરણ કરાવવામાં મદદરૂપ થશે કે, આ ઢગલાને ઓળંગી માંરે તારી પાસે અથવા આ ઢગલાને અને થાંભલાને ઓળંગીને તારે માંરી પાસે લડવા માંટે કે નુકશાન કરવા આવવાનું નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","જો આપણાંમાંથી કોઇ પણ આ કરારનો ભંગ કરે તો ઇબ્રાહિમના દેવ અને નાહોરના દેવ આપણો ન્યાય કરો.” આથી યાકૂબે પોતાના પિતા ઇસહાક જેની ઉપાસના કરતા હતા તે દેવના સમ ખાધા. ");
INSERT INTO guj2009_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","પછી યાકૂબે એક પશુનો વધ કરી અને પહાડ પર યજ્ઞના રૂપમાં ભેટ ધરીને પોતાના માંણસોને ભોજન કરવા માંટે બોલાવ્યા. ભોજન કર્યા પછી તેઓએ પહાડ પર રાત વિતાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","બીજે દિવસે સવારે લાબાન વહેલી સવારે ઉઠયોે પોતાના પૌત્ર-પૌત્રીઓ અને પુત્રીઓને ચુમ્યા અને તેઓને આશીર્વાદ આપ્યા; પછી તે ઘરે પાછો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","યાકૂબે પણ તે સ્થળ છોડયું. જયારે તે પ્રવાસ કરી રહ્યો હતો ત્યારે તેણે દેવના દૂતો જોયા. ");
INSERT INTO guj2009_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","તેમને જોઈને યાકૂબે કહ્યું, “આ તો દેવની છાવણી છે!” આથી તેણે તે જગ્યાનું નામ “માંહનાઈમ” પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","યાકૂબનો ભાઈ એસાવ “સેઇર” પ્રદેશમાં રહેતો હતો. તે અદોમનો પહાડી પ્રદેશ હતો. યાકૂબે એસાવની પાસે ખેપિયાઓને મોકલ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","યાકૂબે ખેપિયાઓને કહ્યું કે, “માંરા વડીલ એસાવને તમે એવું કહેજો કે, તમાંરો સેવક યાકૂબ કહે છે કે, ‘હું લાબાનને ત્યાં જઈ વસ્યો હતો અને અત્યાર સુધી ત્યાં રહ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","માંરી પાસે ગાય, બળદ, ગધેડાં, બકરાં, ઘેટાં અને સેવકો મોટી સંખ્યામાં છે. અમને સ્વીકારવાનું કહેવા હું તમને આ સંદેશો મોકલું છું.’” ");
INSERT INTO guj2009_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ખેપિયાઓ પાછા આવીને યાકૂબને કહ્યું, “અમે તમાંરા ભાઈ એસાવ પાસે ગયા હતા. તે તમને મળવા આવી રહ્યો છે. તેની સાથે 400 સશસ્ર યોદ્વાઓ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ખેપિયાઓની વાત સાંભળી યાકૂબ ગભરાઈ ગયો. તેણે પોતાની સાથેના બધા માંણસોને બે ટોળીમાં વહેંચી નાખ્યા અને પોતાનાં બધાં જ ઢોરો, ઘેટાંબકરાં અને ઊંટોને પણ બે ભાગમાં જુદા પાડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","યાકૂબે વિચાર્યુ, “એસાવ આવીને એક ટોળી પર હુમલો કરે, તો બીજી ટોળી ભાગી જઈને બચી જાય.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","યાકૂબે કહ્યું, “હે માંરા પૂર્વજ ઇબ્રાહિમના દેવ, હે માંરા પિતા ઇસહાકના દેવ! તેં જ મને કહ્યું હતું કે, ‘તારા દેશમાં તારા વતનમાં પાછો જા, હું તારું ભલું કરીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","તેં માંરા પર ધણી કરુણા બતાવી છે. તમે માંરા માંટે જે બધું સારું કર્યુ છે. તે માંટે હું યોગ્ય નથી. મે યર્દન નદી પહેલી વાર ઓળંગી ત્યારે માંરી પાસે ફકત માંરી લાકડી જ હતી, અને અત્યારે માંરી પાસે એટલી બધી વસ્તુઓ છે કે, હું તે બધીને પૂરા બે ભાગમાં અને બે ટોળીમાં વહેંચી શકું. ");
INSERT INTO guj2009_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","હું તમને પ્રાર્થના કરું છું કે, કૃપા કરીને મને માંરા ભાઈ એસાવના હાથમાંથી બચાવો. મને એનો ભય છે કે, રખેને તે આવીને અમને બધાંને, માંરા દીકરાઓને તેઓની માંઓ સુદ્વાંને માંરી નાખે. ");
INSERT INTO guj2009_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","હે યહોવા, તમે મને વચન આપ્યું હતું કે, ‘હું તારું ભલું કરીશ, અને તારા વંશજોને સમુદ્રની રેતીના રજ જેટલા બનાવીશ કે, જેને કોઈ ગણી ન શકે.’” ");
INSERT INTO guj2009_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","તે રાત્રે યાકૂબે ત્યાં જ મુકામ કર્યો. યાકૂબે પોતાની પાસે જે કાંઈ હતું તેમાંથી કેટલીક વસ્તુઓ પોતાના ભાઈ એસાવને ભેટ આપવા પસંદ કરી: ");
INSERT INTO guj2009_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","બકરીઓ 200, બકરાઓ 20, અને 200 ઘેટીઓ, 20 ધેટા, ");
INSERT INTO guj2009_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ઊઁટડીઓ 30, તેઓના બચ્ચાં સાથે, તથા 40 ગાયો અને 10 ગોધાઓ, 20 ગધેડીઓ અને 10 વછેરા. ");
INSERT INTO guj2009_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","આ બધાં તેણે જુદાં જુદાં ટોળાંમાં પોતાના નોકરોને સોંપ્યાં અને કહ્યું, “માંરી આગળ ચાલો, અને એક ટોળાં અને બીજા ટોળાં વચ્ચે જગ્યા રાખજો.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","યાકૂબે તેમને હુકમ કર્યો અને પ્રાણીઓના પહેલા ટોળા સાથેના સેવકને સૂચના આપી કે, “જો માંરો ભાઈ એસાવ તમને મળે અને પૂછે કે, ‘તમે કોના સેવક છો? તમે કયાં જાઓ છો? અને આ તમાંરી આગળનાં ઢોરનાં માંલિક કોણ છે?’ ");
INSERT INTO guj2009_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ત્યારે જવાબ આપજો, ‘એ તો આપના સેવક યાકૂબનાં છે, અને એના વડીલ એસાવ માંટે ભેટમાં મોકલ્યાં છે; અને યાકૂબ પોતે અમાંરી પાછળ જ આવે છે.’” ");
INSERT INTO guj2009_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","એ જ રીતે તેણે ઢોરોના ટોળાં પાછળ ચાલતા બીજા માંણસને, ત્રીજા માંણસને અને બધાં જ માંણસોને સૂચના આપી કે, “જયારે તમે લોકો એસાવને મળો ત્યારે આ એક જ વાત કહેજો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","વધુમાં કહેજો કે, ‘આ તમાંરી ભેટ છે, અને આપનો સેવક યાકૂબ પણ લોકોની પાછળ આવી રહ્યો છે.’” યાકૂબે વિચાર્યુ, “જો હું આ માંણસોને ભેટ સાથે આગળ મોકલું તો શકય છે કે, કદાચ એસાવ મને માંફ કરે અને માંરો સ્વીકાર કરે.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","એટલા માંટે યાકૂબે એસાવને ભેટ તેની આગળ આગળ મોકલી પરંતુ યાકૂબ પોતે તે રાત્રે પોતાની છાવણીમાં જ રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","તે રાત્રે મોડેથી યાકૂબ ઊઠયો અને પોતાની બે પત્નીઓ, બે દાસીઓ, અને અગિયાર બાળકોની સાથે યાબ્બોક નદીને પાર ચાલ્યો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","યાકૂબે પોતાની પત્નીઓ અને બાળકોને તેમજ પોતાની બધી મતાને નદીની પાર મોકલી દીધાં અને તે એકલો રહી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","યાકૂબ નદીને પાર કરનાર છેલ્લો માંણસ હતો. પરંતુ પાર કરતા પહેલાં જયારે તે એકલો હતો ત્યારે એક માંણસ આવ્યો અને તેની સાથે કુસ્તી કર્યા કરી. જયાં સુધી સૂરજ ના ઊંગ્યો ત્યાં સુધી તે વ્યકિએ યાકૂબ સાથે કુસ્તી કર્યા કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","તે વ્યકિતએ જયારે જોયું કે, પોતે યાકૂબને હરાવી શકતો નથી ત્યારે તેણે યાકૂબના જાંઘના સાંધા પર ઠોંસો માંર્યો અને યાકૂબ કુસ્તી કરતો હતો ત્યાં જ તેની જાંઘનો સાંધો ઊતરી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","પછી તે વ્યકિતએ યાકૂબને કહ્યું, “પરોઢ થવા આવ્યું છે, એટલે મને છોડી દો.” પરંતુ યાકૂબે કહ્યું, “જયાં સુધી તું મને આશીર્વાદ નહિ આપે ત્યાં સુધી હું તને છોડીશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","એટલે પેલા વ્યકિતએ પૂછયું, “તારું નામ શું છે?” અને યાકૂબે કહ્યું, “માંરું નામ યાકૂબ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","પછી પુરુષે કહ્યું, “હવે તારું નામ યાકૂબ નહિ પણ ઇસ્રાએલ કહેવાશે. કારણ કે તેં દેવ સાથે તથા પુરુષો સાથે લડીને વિજય મેળવ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","પછી યાકૂબે પેલાને પૂછયું, “કૃપા કરીને મને જરા તમાંરું નામ કહેશો?” પરંતુ પેલી વ્યકિતએ કહ્યું, “તું માંરું નામ શા માંટે પૂછે છે?” અને પછી તે સમયે પેલી વ્યકિતએ યાકૂબને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","એટલા માંટે યાકૂબે તે જગ્યાનું નામ પનુએલ પાડયું. યાકૂબે કહ્યું, “આ જગ્યાએ મેં દેવના પ્રત્યક્ષ દર્શન કર્યા છે. પરંતુ માંરો જીવ બચી ગયો.” ");
INSERT INTO guj2009_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","જેવો તે પનુએલ આગળથી પસાર થયો કે, તરત જ સૂર્યોદય થયો. યાકૂબ પોતાના પગને કારણે લંગડો ચાલતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","એટલા માંટે આજે પણ ઈસ્રાએલના લોકો પ્રાણીની જાંઘના સાંધાનો સ્નાયુ ખાતા નથી. કારણ કે યાકૂબની જાંઘના સાંધાના સ્નાયુ પર તેણે ઈજા પહોચાડી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","યાકૂબે સામે નજર કરી તો એસાવને આવતો જોયો; તેની સાથે 400 માંણસો હતા. યાકૂબે તેના પરિવારને ચાર સમૂહોમાં વહેંચ્યો. લેઆહ અને તેનાં બાળકો એક સમૂહમાં હતા. રાહેલ અને યૂસફ એક સમૂહમાં હતા. દાસીઓ અને તેનાં બાળકો બે સમૂહમાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","યાકૂબે દાસીઓ અને તેમનાં બાળકોને મોખરે રાખ્યાં. તેમની પાછળ લેઆહ અને તેનાં બાળકોને રાખ્યાં. અને યાકૂબે છેલ્લાં રાહેલ અને યૂસફને રાખ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","યાકૂબ પોતે એસાવની પાસે ગયો. તેથી એ પહેલો માંણસ હતો જેની પાસે એસાવ આવ્યો. તેના ભાઈ સુધી ચાલતાં યાકૂબે સાત વાર સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","જયારે એસાવે યાકૂબને જોયો. તે તેને મળવા દોડી આવ્યો અને તે તેને ભેટીને તેને ગળે વળગી પડીને ચુંબન કરવા લાગ્યો. બંન્ને ભાઈની આંખમાં આનંદના અશ્રુ આવ્યાં. બંન્ને રડી પડયા. ");
INSERT INTO guj2009_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","જયારે એસાવે નજર ઊંચી કરીને સ્ત્રીઓ અને બાળકોને જોયા ત્યારે તેણે પૂછયું, “તારી સાથે આ બધાં કોણ છે?” યાકૂબે જવાબ આપ્યો, “આ એ બાળકો છે જે મને દેવની કૃપાથી પ્રાપ્ત થયા છે. દેવ માંરા પ્રત્યે દયાળુ રહ્યાં છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","પછી દાસીઓ તેમનાં બાળકો સાથે તેમની નજીક આવી અને પગે લાગી. ");
INSERT INTO guj2009_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","એ જ રીતે લેઆહ અને તેનાં બાળકો નજીક આવ્યા અને પગે લાગ્યાં. અને છેવટે યૂસફ અને રાહેલ નજીક આવ્યા અને પગે પડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","એસાવે કહ્યું, “મેં જે બધા લોકોને અહીં આવતાં જોયા, તે લોકો કોણ છે? અને આ બધાં પશુઓ શા માંટે છે?” યાકૂબે જવાબ આપ્યો, “એ તમાંરા માંટે માંરા તરફથી ભેટ છે. જેથી તમે માંરો સ્વીકાર કરી શકો. અને માંરા માંલિકની માંરા તરફ દયા રહે.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","પરંતુ એસાવે કહ્યું, “ભાઈ, તારે મને કોઈ ભેટ આપવાની જરૂર નથી. માંરી પાસે પૂરતું છે, તારું તારી પાસે રાખ.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","યાકૂબે કહ્યું, “ના,ના; હું તમાંરી પાસે માંગુ છું કે, માંરા પર કૃપા કરીને હું જે ભેટો આપું છું તેનો સ્વીકાર કરો. હું તમને ફરીથી જોઈને પ્રસન્ન થયો છું. કારણકે માંરે મન એ દેવનું મુખ જોવા જેવું છે. તમે માંરો સ્વીકાર કર્યો છે તે જાણીને હું પ્રસન્ન થયો છું. ");
INSERT INTO guj2009_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","તેથી હું વિનંતી કરું છું કે, જે ભેટો હું તમને આપું છું તેનો તમે સ્વીકાર કરો, દેવ માંરા પર ખૂબ દયાળું રહ્યાં છે અને માંરી પાસે મને જોઇતું બધું જ છે.” આમ તેણે એસાવને ભેટો સ્વીકારવા આજીજી કરી. તેથી એસાવે તે સ્વીકારી. ");
INSERT INTO guj2009_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","પછી એસાવે કહ્યું, “હવે તું તારી યાત્રા શરૂ કરી શકે છે. હું તારી સાથે આવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","પરંતુ યાકૂબે તેને કહ્યું, “તમે એ જાણો છો કે, માંરાં બાળકો હજુ નાનાં અને નિર્બળ છે, અને માંરી સાથે ધાવણાં બચ્ચાંવાળાં ઘેટાંબકરાં અને ઢોર છે. તેમની મને ચિંતા છે. એમને એક દિવસ પણ વધારે ઝડપથી ચલાવીએ તો બધાં જ ઢોરો મરી જશે. ");
INSERT INTO guj2009_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","તેથી મહેરબાની કરી તમે માંરાથી આગળ જાઓ, અને હું ધીમે ધીમે તમાંરી પાછળ આવીશ, હું માંરા બાળકો અને માંરા ઢોરોના રક્ષણ માંટે ધીમે ધીમે જઇશ જેથી તેઓ વધારે થાકી ન જાય. હું તમને સેઈરમાં મળીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","એટલા માંટે એસાવે કહ્યું, “તો પછી હું માંરા માંણસોને તમાંરી સહાયતા માંટે મૂકતો જાઉ.” પરંતુ યાકૂબે કહ્યું, “એ તો તમાંરી વિશેષ દયા છે. શી જરૂર છે? આપની દયા છે એટલું બસ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","એટલે એસાવ તે જ દિવસે સેઇર જવા પાછો વળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","પરંતુ યાકૂબ મજલ કાપતો કાપતો સુક્કોથ પહોચ્યો. ત્યાં તેણે તેને માંટે એક ઘર બનાવ્યું અને પોતાનાં ઢોરો માંટે નાનાં નાનાં (માંડવા) તબેલા બનાવ્યા, તેથી તે જગ્યાનું નામ “સુક્કોથ” રાખવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","આમ, યાકૂબે પોતાનું જે કાંઈ હતું તે બધું સુરક્ષિત પદ્દાંનારામમાંથી આવતાં કનાન દેશના શખેમ નગરમાં મોકલી દીધું અને તે નગર આગળ મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","તેણે જે જમીન પર તંબુ તાણ્યા હતા તે જમીન તેણે શખેમના પિતા હમોરના પુત્રો પાસેથી 100 તોલા ચાંદીમાં વેચાતી લીધી. ");
INSERT INTO guj2009_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","યાકૂબે દેવની ઉપાસના માંટે ત્યાં એક વેદી ઊભી કરી ને તેનું નામ “એલ-એલોહે ઇસ્રાએલ” રાખ્યું અને તે ઇસ્રાએલના દેવના નામે અર્પણ કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","દીનાહ લેઆહ અને યાકૂબની પુત્રી હતી. એક દિવસે તે, એ પ્રદેશની સ્ત્રીઓને મળવા બહાર નીકળી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","તે પ્રદેશના રાજા હિવ્વી હમોરના પુત્ર શખેમે તેને જોઈ એટલે તેણે તેને પકડી અને તેના પર બળાત્કાર કર્યો અને તેની આબરૂ લીધી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","પણ શખેમ દીનાહને પ્રેમ કરવા લાગ્યો અને તેની સાથે લગ્ન કરવાની ઈચ્છા પ્રગટ કરતો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","તેણે પોતાના પિતા હમોરને કહ્યું કે, “મને એ છોકરી મેળવી આપો જેથી હું તેની સાથે લગ્ન કરી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","યાકૂબને સમાંચાર મળ્યા કે, શખેમે તેની પુત્રી દીનાહની આબરૂ લીધી હતી. પણ તેના પુત્રો ઢોરો સાથે ખેતરમાં હતા એટલે તેઓના આવ્યા સુધી તેણે શાંતિ રાખી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","પછી શખેમના પિતા હમોર યાકૂબની સાથે વાત કરવા ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ખેતરમાં યાકૂબના પુત્રોને જે કાંઈ બન્યુ હતું તેના સમાંચાર મળ્યા, જયારે તેઓએ આ સાંભળ્યું ત્યારે તેઓ ઘણા ગુસ્સે થઈ ગયા હતા, કારણ કે શખેમે યાકૂબની પુત્રી પર બળાત્કાર કરીને ઈસ્રાએલ વિરુધ્ધ ન કરવા જેવો ભયંકર ગુનો કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","પરંતુ હમોરે તેમને કહ્યું, “માંરો પુત્ર શખેમ તમાંરી પુત્રી દીનાહને ખૂબ ચાહે છે, કૃપા કરીને તેને તેણીની સાથે પરણવા દો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","અમાંરી સાથે લગ્નસંબંધ બાંધો, તમાંરી કન્યાઓ અમને આપો અને અમાંરી કન્યાઓ તમે લો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","તમે લોકો આ પ્રદેશમાં અમાંરી સાથે રહી શકશો અને આ દેશ તમાંરા માંટે ખુલ્લો રહેશે. તમે લોકો અહીં રહો, વ્યાપાર રોજગાર કરો અને માંલમિલકતવાળા થાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","પછી શખેમે પણ યાકૂબ અને ભાઈઓને વાત કરી. શખેમે કહ્યું, “કૃપા કરીને માંરો સ્વીકાર કરો અને મેં જે કાંઈ કર્યુ છે તે બદલ મને માંફી આપો. તમે લોકો મને જે કરવાનું કહેશો તે હું કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","જો તમે મને દીનાહ સાથે પરણવા દેશો તો, હું તમે જે કાંઈ ભેટ માંગશો તે હું આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","યાકૂબના પુત્રોએ શખેમ તથા તેના પિતાને કપટભર્યો જવાબ આપ્યો, કારણ કે શખેમે તેઓની બહેન દીનાહની આબરૂ લીધી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","એટલા માંટે તેમણે કહ્યું, “જેણે સુન્નત કરાવી નથી એવા માંણસને અમાંરી બહેન પરણાવવી એ તો અમાંરાથી બને જ નહિ, કારણ, એથી અમાંરી બદનામી થાય. ");
INSERT INTO guj2009_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","છતાં અમે લોકો તને એની સાથે લગ્ન કરવા દઈશું, જો તમે પણ અમાંરા જેવા બની જાઓ. તમાંરા નગરના સર્વ પુરૂષોની અમાંરી જેમ સુન્નત થઈ જાય. ");
INSERT INTO guj2009_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","પછી તમાંરા પુરુષો અમાંરી કન્યાઓ સાથે લગ્ન કરી શકશે અને અમાંરા પુરુષો તમાંરી કન્યાઓ સાથે લગ્ન કરી શકશે. આપણે એકબીજા સાથે રહીએ અને એક પ્રજા બની જઈએ. ");
INSERT INTO guj2009_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","પણ જો તમે લોકો સુન્નત ન કરાવો, તો અમે લોકો દીનાહને લઈ ચાલ્યા જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","આ કરારથી હમોર અને શખેમ બહું પ્રસન્ન થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","દીનાહના ભાઈઓએ જે કાંઈ કહ્યું તે પ્રમાંણે કરવામાં શખેમને આનંદ થયો. કારણ તે યાકૂબની પુત્રીને ખૂબ પ્રેમ કરતો હતો. વળી, તે આખા કુટુંબમાં તેનું સૌથી વધારે માંન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","એટલા માંટે હમોર અને તેનો પુત્ર શખેમ ગામના ભાગળે આવ્યા અને લોકોને કહેવા લાગ્યા કે, ");
INSERT INTO guj2009_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ઇસ્રાએલના આ લોકો આપણા મિત્રો થવા માંગે છે. અને અમે લોકો તેઓને આપણા પ્રદેશમાં રહેવા દેવા માંગીએ છીએ. તેઓ આપણી સાથે શાંતિ કાયમ રાખવા ઈચ્છે છે. આપણી પાસે આપણા લોકો માંટે પર્યાપ્ત ભૂમિ છે. તો ભલે તેઓ રહે અને વેપારધંધો કરે. આપણે તેમની કન્યાઓ સાથે લગ્ન કરીએ અને આપણી કન્યાઓ તેમને આપીએ. ");
INSERT INTO guj2009_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","પરંતુ એક શરતે કે, આપણામાંના સર્વ પુરુષોની તેમની જેમ સુન્નત કરાવવામાં આવે. એ લોકો પણ આપણી સાથે રહેવા અને એક પ્રજા બનવા તૈયાર છે. ");
INSERT INTO guj2009_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","જો આપણે એમ કરીશું, તો તેમનાં ઢોરઢાંખર અને મિલકતથી આપણે ધનવાન થઈ જઈશું. એટલા માંટે ચાલો આપણે તેમની સાથે કરાર કરીએ અને તેઓ અહીં અમાંરા લોકો સાથે રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ભાગળો પર જે લોકોએ આ વાત સાંભળી તે બધા હમોર અને શખેમ સાથે સંમત થઇ ગયા અને શહેરના બધા વડીલોએ હમોર અને તેના પુત્ર શખેમની વાત સ્વીકારી, અને સર્વ પુરુષોની સુન્નત કરાવવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ત્રીજે દિવસે સુન્નત થયેલા પુરુષોની બળતરા શમી નહોતી, ત્યાં જ યાકૂબના બે પુત્રો શિમયોન અને લેવી, જેઓ દીનાહના સગા ભાઈઓ હતા તેઓ તરવાર, લઈને ઓચિંતા શહેર પર ચઢી આવ્યા અને તેમણે બધા પુરુષોને માંરી નાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","દીનાહના ભાઈ શિમયોન અને લેવીએ હમોર અને તેના પુત્ર શખેમને માંરી નાખ્યા. તેઓએ શખેમના ઘરમાંથી દીનાહને બહાર આણી અને તેને લઈને ચાલ્યા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","વળી, યાકૂબના બીજા પુત્રોએ ઘાયલ થયેલાઓ પર હુમલો કર્યો અને નગરને લૂંટી લીધું, કારણ કે હજુ સુધી તેમની બહેનની લાજ લૂંટવાથી ઉત્પન્ન થયેલ ક્રોધ શમ્યો નહોતો. ");
INSERT INTO guj2009_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","એટલા માંટે દીનાહના ભાઈઓએ તેમનાં બધાં જ ઢોર લૂંટી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","તેમણે તેમની બધી માંલમત્તા, બધાં બાળકો અને બધી સ્ત્રીઓ પણ કબજે કરી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","પરંતુ યાકૂબે શિમયોન અને લેવીને કહ્યું, “તમે લોકોએ મને બહુ દુ:ખી કર્યો છે; આ પ્રદેશના વતનીઓ કનાનીઓ અને પરિઝીઓમાં તમે મને અપ્રિય બનાવ્યો છે. તે બધા લોકો આપણા વિરોધી થઈ જશે. અહીં માંરી પાસે તો થોડા જ માંણસો છે, અને જો એ લોકો એકઠા થઈને માંરી વિરુધ્ધ જઈને માંરા પર હુમલા કરે તો માંરા પરિવારનો તો વિનાશ જ થાય.” ");
INSERT INTO guj2009_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","પરંતુ ભાઈઓએ ઉત્તર આપ્યો, “તો શું અમાંરે અમાંરી બહેન સાથે આ લોકોને વેશ્યા જેવો વ્યવહાર કરવા દેવો? ના, અમાંરી બહેન સાથે આવો વ્યવહાર કરનારા લોકો ખરાબ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","દેવે યાકૂબને કહ્યું, “ચાલ, ઊઠ બેથેલ જા અને ત્યાં રહે. અને ત્યાં ઉપાસના માંટે વેદી બનાવ. દેવનું સ્મરણ કર. કારણ કે તું તારા ભાઈ એસાવ પાસેથી ભાગી આવ્યો ત્યારે તને દેવે દર્શન આપ્યા હતા.” ");
INSERT INTO guj2009_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","આથી યાકૂબે પોતાના પરિવારને અને પોતાની સાથેના બધા માંણસોને કહ્યું, “તમાંરી પાસે લાકડાના અને ધાતુના જે પારકા મિથ્યા દેવો હોય તેને ફેંકી દો અને તમાંરી દેહશુદ્વિ કરીને વસ્ત્રો બદલી નાખો. ");
INSERT INTO guj2009_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","પછી આપણે બધા આ સ્થળને છોડીને બેથેલ જઈશું. ત્યાં હું માંરા વિપત્તિના સમયે માંરો પોકાર સાંભળનાર અને હું જયાં જયાં ગયો ત્યાં ત્યાં માંરો સાથ કરનાર દેવને માંટે હું વેદી બનાવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","આથી જે લોકોની પાસે પારકા મિથ્યા દેવો હતા, તે બધા દેવો તેમણે યાકૂબને આપી દીધા. તેઓએ પોતાના કાનોમાં પહેરેલી કડીઓ પણ યાકૂબને સોંપી દીધી. યાકૂબે આ બધી વસ્તુઓને શખેમ નગરની બાજુમાં એલોન વૃક્ષ નીચે દાટી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","યાકૂબ અને તેના પુત્રોએ તે જગ્યા છોડી દીધી. તે ભૂમિના લોકો તેમનો પીછો કરીને તેમને માંરી નાખવા માંગતા હતા. પરંતુ તેઓ ખુબજ ભયભીત હતા તેથી તેઓએ યાકૂબનો પીછો કર્યો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","યાકૂબ અને તેની સાથેના બધા લોકો કનાન દેશમાં લૂઝ એટલે કે, બેથેલ આવી પહોંચ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","યાકૂબે ત્યાં એક વેદી બાંધી અને તે સ્થળનું નામ તેણે “એલ-બેથેલ” પાડયું. કારણ કે તે જયારે પોતાના ભાઈ પાસેથી ભાગી નીકળ્યો હતો, ત્યારે દેવે તેને તે સ્થળે દર્શન દીધાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","રિબકાની સાસુ દબોરાહ અહીં મૃત્યુ પામી હતી. ત્યારે તેને બેથેલ નજીક એલોન વૃક્ષ નીચે દફનાવવામાં આવી હતી. આથી એનું નામ “રુદનનું એલોન વૃક્ષ” (એલોન-બાખૂથ) રાખવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","જયારે યાકૂબ પાદ્દાનારામથી પાછો ફર્યો ત્યારે દેવે ફરીથી તેને દર્શન દીધા અને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","દેવે યાકૂબને કહ્યું, “તારું નામ યાકૂબ છે. પણ હવે ઇસ્રાએલ રહેશે.” આથી તેનું નામ ઇસ્રાએલ પડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","દેવે તેને કહ્યું, “હું સર્વસમર્થ દેવ છું. હું તને આશીર્વાદ આપું છું, તને ઘણા સંતાનો થાઓ અને તારા વંશજો વધો. એક મહાનરાષ્ટ બનો, જાઓ તમાંરાથી બીજા રાષ્ટ તથા રાજાઓ થશે. ");
INSERT INTO guj2009_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","મેં ઇબ્રાહિમ અને ઇસહાકને જે વિશેષ ભૂમિ આપી હતી તે હવે હું તમને તથા તમાંરા વંશજોને આપું છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","પછી દેવ અંર્તધ્યાન થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","યાકૂબે તે જગ્યા પર જયાં દેવે તેની સાથે વાત કરી હતી ત્યાં, એક સ્માંરકસ્તંભ ઊભો કર્યો અને તેના પર તેણે પેયાર્પણ અપીર્ અને તેલનો અભિષેક કર્યો. અને તે જગ્યાનું નામ બેથેલ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","યાકૂબ અને તેના માંણસોએ બેથેલ છોડયું. અને જ્યારે તેઓ એફ્રાથથી હજી થોડે અંતરે હતા ત્યાં જ રાહેલને પ્રસૂતિની પીડા શરૂ થઇ. ");
INSERT INTO guj2009_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","પરંતુ રાહેલને કષ્ટાતી જોઈને દાઈએ તેને કહ્યું, “રાહેલ, તું ડરીશ નહિ, કારણ કે આ વખતે પણ તું પુત્રને જન્મ આપી રહી છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","પુત્રને જન્મ આપતી વખતે રાહેલનું અવસાન થયું. જીવ જતાં જતાં તેણે તેનું નામ “બેનોની” પાડયું હતું. પરંતુ તેના પિતા યાકૂબે તેનું નામ “બિન્યામીન” પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","આમ, રાહેલનું અવસાન થયું અને તેને એફ્રાથ, એટલે કે, બેથલેહેમને રસ્તે દફનાવવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","યાકૂબે તેની કબર પર એક આધારસ્તંભ ઊભો કર્યો, અને તે આધારસ્તંભ આજે પણ રાહેલની કબરના સ્તંભ તરીકે ઊભો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","પછી ઈસ્રાએલ આગળ વધ્યો. તેણે એદેર સ્તંભની બરાબર દક્ષિણમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ઇસ્રાએલ ત્યાં થોડો સમય રોકાયો. જયારે તે ત્યાં હતો ત્યારે રૂબેન ઇસ્રાએલની દાસી બિલ્હાહ સાથે સૂઈ ગયો. ઇસ્રાએલે જયારે આ જાણ્યું ત્યારે તે બહું જ ગુસ્સે થયો. યાકૂબને બાર પુત્રો હતા: ");
INSERT INTO guj2009_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","લેઆહના પેટે જન્મેલા પુત્રો છ હતા: રૂબેન, શિમયોન, લેવી, યહૂદા, ઈસ્સાખાર અને ઝબુલોન. યાકૂબના પહેલા ખોળાનો પુત્ર રૂબેન. ");
INSERT INTO guj2009_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","તેની પત્ની રાહેલના બે પુત્રો હતા: યૂસફ અને બિન્યામીન. ");
INSERT INTO guj2009_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","રાહેલની દાસી બિલ્હાહને પેટે જન્મેલા બે પુત્રો હતા: દાન અને નફતાલી. ");
INSERT INTO guj2009_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","અને લેઆહની દાસી ઝિલ્પાહથી જન્મેલા બે પુત્રો હતા: ગાદ અને આશેર. આ બધા યાકૂબના પુત્રો પાદ્દાંનારામમાં જન્મેલા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","યાકૂબ માંમરે એટલે કિર્યાથ-આર્બા (હેબ્રોન) આગળ પોતાનો પિતા ઇસહાક હતો ત્યાં પહોંચી ગયો. આ તે જગ્યા છે, જયાં ઇબ્રાહિમ અને ઇસહાક જઈને રહ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ઇસહાકની ઉંમર 180 વર્ષની થઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ઇસહાક ઘણા વષોર્ જીવ્યો, તે લાંબુ અને પૂર્ણ જીવન જીવ્યો પછી તે મૃત્યુ પામ્યોં. અને તેના દીકરાઓ એસાવ અને યાકૂબે તેને તેના પિતા ઇબ્રાહિમને જ્યાં દફનાવ્યા હતા ત્યાં દફનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","એસાવ ઉફેર્ અદોમના વંશજો આ પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","એસાવે કનાની સ્ત્રીઓ સાથે લગ્ન કર્યા હતા: એલોન હિત્તીની પુત્રી આદાહ, સિબઓન હિવ્વીના પુત્ર અનાહની પુત્રી ઓહલીબામાંહ, ");
INSERT INTO guj2009_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","અને ઇશ્માંએલની પુત્રી નબાયોથની બહેન બાસમાંથ સાથે તેણે લગ્ન કર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","આદાહને એસાવથી અલીફાઝ અવતર્યો. બાસમાંથને રેઉએલ અવતર્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","અને ઓહલીબામાંહને યેઉશ, યાલામ તથા કોરાહ અવતર્યો. આ કનાનમાં જન્મેલા એસાવના પુત્રો હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ત્યાર બાદ એસાવ પોતાની પત્નીઓ, પુત્રો, પુત્રીઓ અને પરિવારના બધાં માંણસો તથા ઢોરો અને બધાં જાનવરોને અને કનાન દેશમાં મેળવેલી બધી માંલમિલકતને લઈને પોતાના ભાઈ યાકૂબથી દૂરના પ્રદેશમાં ચાલ્યો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","તેમની માંલમિલકત એટલી બધી હતી કે, તેઓ ભેગા ન રહી શકે અને તેઓ જયાં રહેતા હતા તે ભૂમિ એવી હતી કે, તેમનાં બંનેનાં ઢોરોનો નિભાવ ન થઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","આથી એસાવ સેઈરના પહાડી દેશમાં રહેવા લાગ્યો, એસાવ એ જ અદોમ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","એસાવ અદોમીઓના આદિપિતા છે. સેઈરના પહાડી પ્રદેશના અદોમીઓના વડવા એસાવના વંશજો આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","એસાવના પુત્રોના નામ આ છે: એસાવની પત્ની આદાહનો પુત્ર અલીફાઝ, ને એસાવની પત્ની બાસમાંથનો પુત્ર રેઉએલ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","અલીફાઝના પુત્રો તેમાંન, ઓમાંર, સફો, ગાતામ અને કનાઝ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","તિમ્ના એસાવના પુત્ર અલીફાઝની ઉપપત્ની હતી. તેને અલીફાઝથી અમાંલેક અવતર્યો હતો. આ એસાવની પત્ની આદાહના પૌત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","એસાવની પત્ની બાસમાંથનો દીકરો રેઉએલ. રેઉએલના પુત્રો નાહાથ, ઝેરાહ, શામ્માંહ અને મિઝઝાહ. આ એસાવની પત્ની બાસમાંથના પૌત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","સિબઓનના પુત્ર અનાહની પુત્રી ઓહલીબામાંહ એસાવની પત્ની હતી. તેને એસાવથી યેઉશ, યાલામ અને કોરાહ અવતર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","એસાવના વંશજોમાં નીચેના સરદારો હતા. એસાવના સૌથી મોટા પુત્ર અલીફાઝના પુત્ર: સરદાર તેમાંન, સરદાર ઓમાંર, સરદાર સફો, સરદાર કનાઝ, ");
INSERT INTO guj2009_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","કોરાહ, ગાતામ, અને અમાંલેક. આ અદોમની ભૂમિમાંના અલીફાઝના પરિવારનાં સરદારો છે. એ બધા આદાહના પૌત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","એસાવનો પુત્ર રેઉએલ આ પરિવારોનો આદિ પિતા હતો. રેઉએલના પુત્રો નીચે પ્રમાંણે છે: સરદાર નાહાથ, સરદાર ઝેરાહ, સરદાર શામ્માંહ, અને સરદાર મિઝઝાહ, આ અદોમના પ્રદેશમાંના રેઉએલના સરદારો છે. એ એસાવની પત્ની બાસમાંથના પૌત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","એસાવની પત્ની ઓહલીબામાંહના દીકરા: સરદાર યેઉશ, સરદાર યાલામ અને સરદાર કોરાહ, અનાહની પુત્રી એસાવની પત્ની ઓહલીબામાંહના આ પુત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","આ એસાવના ઉફેર્ અદોમના પુત્રો છે અને એ સરદારો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","એસાવના પહેલાં અદોમમાં હોરી સેઈરના એ પ્રદેશમાં જ વસતા પુત્રો આ છે: લોટાન, શોબાલ, સિબઓન, અનાહ, દીશોન, એસેર અને દીશાન. ");
INSERT INTO guj2009_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","અદોમ પ્રદેશમાંના હોરીઓના આ સરદારો સેઈરના પુત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","લોટાનના દીકરા હોરી અને હેમાંમ હતા. અને લોટાનની બહેન તિમ્ના હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","આ શોબાલના પુત્રો હતા: આલ્વાન, માંનાહાથ, એબાલ, શફો અને ઓનામ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","અને સિબઓનના પુત્રો: આયાહ તથા અનાહ છે. અનાહને રણપ્રદેશમાં પોતાના પિતા સિબઓનનાં ગધેડાં ચરાવતાં ગરમ ઝરણાં જડયા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","અને અનાહના પુત્રો આ છે: એટલે દીશોન તથા અનાહની પુત્રી ઓહલીબામાંહ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","અને દીશોનના પુત્રો આ છે: એટલે હેમ્દાન તથા એશ્બાન તથા યિર્થાન તથા ખરાન. ");
INSERT INTO guj2009_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","આ એસેરના પુત્રો આ છે: એટલે બિલ્હાન, ઝાઅવાન તથા અકાન. ");
INSERT INTO guj2009_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","આ દીશાનના પુત્રો આ છે: એટલે ઉસ તથા અરાન. ");
INSERT INTO guj2009_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","હોરીઓથી જે સરદારો થયા તે આ છે: એટલે લોટાન સરદાર, શોબાલ સરદાર, સિબઓન સરદાર, અનાહ સરદાર. ");
INSERT INTO guj2009_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","સરદાર દીશોન, સરદાર એસેર અને સરદાર દીશાન. આ સેઈરના પ્રદેશના જાતિવાર હોરીઓના સરદારો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","તે સમયે અદોમમાં અનેક રાજાઓ હતા. ઇસ્રાએલી રાજાઓ પહેલાં અદોમના પ્રદેશ પર રાજય કરનાર રાજાઓ આ પ્રમાંણે હતા: ");
INSERT INTO guj2009_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","અદોમમાં બેઔરના પુત્ર બેલાએ રાજય કર્યુ હતું. તેના પાટનગરનું નામ દીનહાબાહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","બેલાના અવસાન બાદ બોસરાહ નગરના ઝેરાહનો પુત્ર યોબાબ ગાદીએ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","યોબાબના અવસાન બાદ તેમાંન દેશનો હુશામ ગાદીએ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","હુશામના અવસાન બાદ બદાદનો પુત્ર હદાદ ગાદીએ આવ્યો. તેણે મોઆબ પ્રદેશમાં મિધાનીઓને પરાજય આપ્યો. તેનું પાટનગર અવીથ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ત્યારબાદ હદાદનું અવસાન થયું. ને તેની જગ્યાએ માંસરેકાહમાંના સામ્લાહે રાજય કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","અને સામ્લાહના અવસાન બાદ નદી પાસેના રહોબોથના શાઉલે રાજય શાસન કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","શાઉલના અવસાન પછી આખ્બોરનો પુત્ર બાઆલ-હનાન ગાદીએ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","આખ્બોરના દીકરા બાઆલ-હનાનના અવસાન પછી હદાર ગાદીએ આવ્યો અને તેનું પાટનગર “પાઉ” હતું. તેની પત્નીનું નામ મહેટાબએલ હતું, તે મેઝાહાબની પુત્રી માંટરેદની પુત્રી થતી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","પછી એસાવથી જે સરદારો થયા તેઓનાં નામ, પોતપોતાનાં પરિવાર તથા જગાઓ મુજબ તેઓના નામ આ છે: સરદાર તિમ્ના, સરદાર આલ્વાહ, સરદાર યથેથ, ");
INSERT INTO guj2009_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","સરદાર ઓહલીબામાંહ, સરદાર એલાહ, સરદાર પીનોન, ");
INSERT INTO guj2009_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","સરદાર કનાઝ, સરદાર તેમાંન, સરદાર મિબ્સાર, સરદાર માંગ્દીએલ, અને સરદાર ઇરામ. ");
INSERT INTO guj2009_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","પોતપોતાના વતનના દેશ પ્રમાંણે અદોમના સરદારો છે. અદોમ લોકોનો પૂર્વજ તે જ એસાવ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","યાકૂબ જે પ્રદેશમાં એના પિતા આવીને વસ્યા હતાં તે દેશમાં એટલે કે, કનાન દેશમાં રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","યાકૂબના પરિવારની આ કથા છે. યૂસફ 17 વર્ષનો યુવાન હતો. તેનું કામ ઘેટાંબકરાંને ચરાવવાનું અને તેમની દેખભાળ રાખવાનું હતું. યૂસફ આ કામ પોતાના ભાઈઓ એટલે કે, બિલ્હાહ તથા ઝિલ્પાહના પુત્રોની સાથે કરતો હતો. (બિલ્હાહ અને ઝિલ્પાહ તેના પિતાની પત્નીઓ હતી.) ");
INSERT INTO guj2009_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","યૂસફ પોતાના ભાઈઓના દુકૃત્યો વિષે તેના પિતાને જાણ કરતો હતો. તેના પિતા ઇસ્રાએલ વૃદ્વ હતાં ત્યારે યૂસફનો જન્મ થયો હતો. તેથી ઇસ્રાએલ બીજા પુત્રો કરતા વધારે પ્રેમ યૂસફને કરતો હતો; અને તેણે યૂસફ માંટે એક લાંબી બાંયનો રંગીન ઝભ્ભો પણ સિવડાવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","બીજા પુત્રો કરતા પિતાને યૂસફ પર વિશેષ પ્રેમ છે તેના ભાઈઓએ જોતા તેઓ તેના ભાઇ યૂસફને ઘૃણા કરવા લાગ્યા અને તેઓ તેની સાથે મૈત્રીભાવથી વાત કરી શકતા નહોતા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","એક વખત યૂસફે એક વિચિત્ર સ્વપ્ન જોયું. અને પછી યૂસફે આ સ્વપ્નની બાબતમાં પોતાના ભાઈઓને વાત કરી. તેથી તેના ભાઈઓ તેને પહેલા કરતાં વધુ ઘૃણા કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","યૂસફે કહ્યું, “સાંભળો, મેં એક સ્વપ્ન જોયું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","આપણે બધા ખેતરમાં ઘઉંના પૂળા બાંધતા હતા. એવામાં માંરો પૂળો ટટાર ઊભો રહ્યો અને તમાંરા પૂળાએ તેની આસપાસ ભેગા થઈને માંરા પૂળાને પ્રણામ કર્યા.” ");
INSERT INTO guj2009_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","તેના ભાઈઓએ કહ્યું, “શું તું એમ માંને છે કે, આનો અર્થ એ છે કે, તું રાજા થઈને અમાંરા પર શાસન કરીશ?” આ સ્વપ્ન વિષે યૂસફે જે વાત કરી તેને કારણે તેઓ તેના પર પહેલાં કરતાં વધારે ઘૃણા કરતા થયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","પછી યૂસફને બીજું સ્વપ્ન આવ્યું, તે તેણે પોતાના ભાઈઓને કહ્યું. “મેં બીજા સ્વપ્નમાં સૂર્ય, ચંદ્ર અને અગિયાર નક્ષત્રોને મને વંદન કરતા જોયા.” ");
INSERT INTO guj2009_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","જ્યારે યૂસફે પિતાને તેનાં સ્વપ્ન વિષે કહ્યું ત્યારે તેના પિતાએ તેને ઠપકો આપ્યો અને કહ્યું, “તારા આ સ્વપ્નનો અર્થ શો? શું તું એમ સમજે છે કે, હું તારી માંતા તથા તારા ભાઈઓ તને સાષ્ટાંગ પ્રણામ કરીશુ?” ");
INSERT INTO guj2009_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","તેના ભાઈઓ તો તેની ઈર્ષ્યા કરતાં રહ્યાં. પણ તેના પિતા આ બાબતનો ગંભીરતાથી વિચાર કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","એક વખત યૂસફના ભાઈઓ પિતાના ઘેટાંબકરાં ચરાવવા માંટે શખેમ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","પછી ઇસ્રાએલે યૂસફને કહ્યું, “શખેમ જા, તારા ભાઈઓ શખેમમાં ઘેટાં બકરાં ચરાવે છે. ચાલ, હું તને તેમની પાસે મોકલું છું.” યૂસફે કહ્યું, “હું જઈશ, હું તૈયાર છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","યૂસફના પિતાએ કહ્યું, “જા અને તપાસ કર. તારા ભાઇઓ અને ઘેટાં બકરાં કુશળ છે કે, કેમ? જોઈ આવ ને મને કહે.” એમ કહીને તેણે તેને હેબ્રોનની ખીણમાં થઈ શખેમ જવા મોકલ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","યૂસફ શખેમમાં ખોવાઈ ગયો. એક માંણસે તેના ખેતરમાં આમતેમ રખડતો જોયો. તે માંણસે પૂછયું. “તું કોને શોધે છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","યૂસફે જવાબ આપ્યો, “હું માંરા ભાઈઓને શોધું છું; શું તમે બતાવી શકો છો કે, તેઓ કઈ જગ્યાએ ઘેટાંબકરાં ચરાવે છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","પેલા માંણસે કહ્યું, “તેઓ તો ચાલ્યા ગયા છે. મેં તેમને એમ વાત કરતાં સાંભળ્યા હતા કે, ચાલો, આપણે દોથાન જઈએ.” આથી યૂસફ પોતાના ભાઈઓની પાછળ ગયો અને તેઓ તેને દોથાનમાં મળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","યૂસફના ભાઈઓએ તેને દૂરથી આવતાં જોયો અને એ તેમની પાસે આવી પહોંચે તે પહેલાં જ એને માંરી નાખવા માંટેનું ષડયંત્ર તેમણે રચ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ભાઈઓએ એકબીજાને કહ્યું, “જુઓ, પેલો સ્વપ્ન જોવાવાળો યૂસફ આવે છે! ");
INSERT INTO guj2009_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ચાલો તક મળતાં આપણે તેને માંરી નાખીએ અને કોઈ હવડ કૂવામાં નાખી દઈએ. અને આપણે આપણા પિતાને કહીશું કે, તેને કોઈ જંગલી જાનવર ખાઈ ગયું છે. પછી આપણે જોઈશું કે, એના સ્વપ્નોનું શું થાય છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","પરંતુ રૂબેન યૂસફને બચાવવા માંગતો હતો. રૂબેને કહ્યું, “આપણે એનો જીવ ન લઈએ. ");
INSERT INTO guj2009_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","રણના આ ખાલી કૂવામાં એને નાખી દો, પણ એને કોઈ ઈજા ન કરશો.” રૂબેનની યોજના એને બીજા ભાઇઓના હાથમાંથી બચાવી લઈને પિતાને સુપ્રત કરવાની હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","યૂસફ તેના ભાઈઓની પાસે આવ્યો ત્યારે એણે પેલો લાંબી બાંયનો સુંદર ડગલો પહેર્યો હતો, તેને ફાડીને ઉતારી લીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","પછી તેઓએ એને લઈ જઈને હવડ કૂવામાં ફેંકી દીધો. કૂવામાં પાણી નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","પછી યૂસફના ભાઈઓ ખાવા બેઠા. તેમણે નજર કરી, તો ઇશ્માંએલીઓનો એક સંઘ ગિલઆદથી આવતો હતો; અને તેઓ ઊંટ પર અનેક સુગંધીઓ તથા લોબાન તથા બોળ લાદીને મિસર લઈ જતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","યહૂદાએ પોતાના ભાઈઓને કહ્યું, “આપણે આપણા ભાઈની હત્યા કરીએ અને તેનું રકત છુપાવી દઈએ તેથી શો ફાયદો? ");
INSERT INTO guj2009_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ચાલો, આપણે તેને ઇશ્માંએલીઓને વેચી દઈએ, અને તેને કોઈ ઈજા ન કરીએ, કારણ તે આપણો ભાઈ છે તથા આપણું જ લોહી છે.” અને તેના ભાઈઓ તેની સાથે સંમત થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","તે સમયે ત્યાંથી કેટલાક મિદ્યાની વેપારીઓ પસાર થતાં હતા; તેથી ભાઈઓએ યૂસફને કૂવામાંથી બહાર કાઢયો અને 20 રૂપામહોરમાં વેપારીઓને વેચી દીધો. તેથી તેઓ યૂસફને મિસર લઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","રૂબેન કૂવા પાસે પાછો આવ્યો; જોયું તો કૂવામાં યૂસફ ન હતો; શોકના માંર્યા તેણે પોતાનાં લૂંગડાં ફાડયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","પછી તેણે પોતાના ભાઈઓ પાસે પાછા આવીને કહ્યું, “અરે! છોકરો તો નથી; હવે હું શું કરું?” ");
INSERT INTO guj2009_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","પછી તેઓએ યૂસફનો ઝભ્ભો લીધો, અને બકરાંને કાપીને તેના રકતમાં તે ઝભ્ભો બોળી કાઢયો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","અને પછી તે રંગીન લીલી બાંયવાળો ઝભ્ભો પોતાના પિતાને મોકલી આપ્યો અને કહેવડાવ્યું કે, “આ અમને જડયો છે; તે તમાંરા પુત્રનો છે કે, નહિ એ તમે ઓળખી લેજો.” ");
INSERT INTO guj2009_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","તે ઓળખ્યો, ને કહ્યું, “આ તો માંરા પુત્રનો ઝભ્ભો છે; કોઈ જંગલી પશુએ તેને ફાડી ખાધો છે; જરૂર યૂસફને ફાડી ખાધો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","પછી યાકૂબે પોતાનાં વસ્રો ફાડી નાંખ્યાં અને ઢીલો ઝભ્ભો પહેર્યો અને ધણા દિવસ સુધી તેણે પુત્રના મરણનો શોક પાળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","અને એના બધા પુત્ર-પુત્રીઓએ તેને દિલાસો આપવાનો પ્રયત્ન કર્યો; પણ તે શાંત થયો નહિ અને તેણે કહ્યું, “માંરા મરવાના દિવસ સુધી હું શોક કર્યા કરીશ.” આમ તેના પિતાએ વિલાપ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","તે સમય દરમ્યાન પેલા મિધાનીઓએ યૂસફને મિસરમાં ફારુનના એક અમલદાર, અંગરક્ષકોના અધિકારી પોટીફારને વેચી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","એ દિવસો દરમ્યાન યહૂદાએ પોતાના ભાઈઓને છોડી દીધા અને અદુલ્લામ નગરના વતની હીરાહ નામના વ્યકિત સાથે રહેવા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ત્યાં તેમને એક કનાની સ્ત્રી મળી. અને તે સ્ત્રી સાથે તેમણે લગ્ન કરી લીધા. તે સ્ત્રીનું નામ શૂઆ હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","તે સ્ત્રી ગર્ભવતી થઈ, ને તેણે એક પુત્રને જન્મ આપ્યો; અને યહૂદાએ તેનું નામ એર પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ફરીથી તેણે ગર્ભ ધારણ કર્યો અને પુત્રને જન્મ આપ્યો. તેણે તેનું નામ ઓનાન પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","અને ફરી તેને એક પુત્ર જન્મ્યો જેનું નામ તેણે શેલાહ પાડયું. જયારે તેનો જન્મ થયો ત્યારે યહૂદા ખઝીબમાં રહેતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","પછી યહૂદાએ પોતાના મોટા પુત્ર એર માંટે તામાંર નામની વહુ લાવી. ");
INSERT INTO guj2009_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","યહોવાએ યહૂદાના મોટા પુત્રને માંરી નાખ્યો કારણ કે તેની દૃષ્ટિમાં તે ભૂંડો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","પછી યહૂદાએ ઓનાનને કહ્યું, “તું તારા ભાઈની પત્ની સાથે શારીરિક સંબંધ રાખ. દિયર તરીકેની તારી ફરજ અદા કર, અને તારા ભાઈ માંટે પ્રજા પેદા કર.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","અને ઓનાનને ખબર હતી કે, એ સંતાનો તેના ગણાશે નહિ. એટલે જયારે જયારે એ પોતાની ભાભી પાસે જતો ત્યારે તે ભૂમિ પર પાડયું જેથી તેના ભાઈની પ્રજા પેદા ન થાય. ");
INSERT INTO guj2009_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","આ રીતે તે જે કરતો તે યહોવાની દૃષ્ટિમાં ભૂડું હતું. તેથી તેણે તેનું પણ મોંત નિપજાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","પછી પોતાની પુત્રવધૂ તામાંરને યહૂદાએ કહ્યું, “માંરો પુત્ર શેલાહ મોટો થાય, ત્યાં સુધી તું તારા પિયરમાં જઇને વિધવા તરીકે રહે.” કારણ કે કદાચ તે શેલાહ પણ તેના ભાઈઓની જેમ માંર્યો જાય. તેથી તામાંર તેના બાપને ઘેર જઈને રહી. ");
INSERT INTO guj2009_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","સમય જતાં યહૂદાની પત્ની, શૂઆની પુત્રીનું મૃત્યુ થયું. શોકનો સમય પૂરો થયા પછી યહૂદા પોતાના મિત્ર અદુલ્લામી હીરાહ સાથે તેનાં ઘેટાં કાતરનારાઓ પાસે તિમ્નાહ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","પછી તામાંરને જાણ થઈ કે, “જો, તારા સસરા તેમનાં ઘેટાં કાતરવાને તિમ્નાહ જાય છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","તેથી તેણીએ પોતાનાં વૈધવ્યનાં વસ્રો ઉતારી અને પોતાનો ચહેરો બુરખાથી ઢાંકી દીધો. અને પોતાનો દેહ ઢાંકીને તિમ્નાહને રસ્તે આવેલ એનાઇમની ભાગોળ આગળ એક સ્થળે બેઠી. તે જાણતી હતી કે, શેલાહ મોટો થયો છે. તેમ છતાં તેને તેણીની સાથે પરણવાની મંજૂરી આપવામાં આવી ન હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","અને જયારે યહૂદાએ તેને જોઈ, ત્યારે તેને વેશ્યા જાણી, કારણ કે તેણે પોતાનું મુખ ઢાંકયું હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","રસ્તાની બાજુમાં તેની પાસે જઈને તેણે કહ્યું, “હવે મને તારી પાસે આવવા દે;” કેમ કે, તે જાણતો નહોતો કે, એ એની પુત્રવધૂ છે. તે બોલી, “માંરી પાસે આવવા સારું તમે મને શું આપશો?” ");
INSERT INTO guj2009_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","તેણે જવાબ આપ્યો, “માંરાં બકરાંના ટોળામાંથી એક લવારું મોકલીશ.” તેણીએ કહ્યું, “તમે મને લવારું મોકલો ત્યાં સુધી કોઈ વસ્તુ આપો તો જ!” ");
INSERT INTO guj2009_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","તેથી તેણે તેને કહ્યું, “હું શું સાનમાં આપું?” તેણીએ કહ્યું, “તમાંરી મુદ્રા, તથા તમાંરો અછોડો તથા તમાંરા હાથમાંની ડાંગ.” આથી યહૂદાએ તે વસ્તુઓ આપી અને તેની પાસે ગયો, ને તેનાથી તે ગર્ભવતી થઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","પછી તે ઊઠીને ચાલી ગઈ, અને બુરખો કાઢીને તેણે વિધવાનાં વસ્રો પહેરી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","પછી જયારે યહૂદાએ સાનમાં મૂકેલી વસ્તુઓ તે સ્ત્રી પાસેથી મેળવવા અદુલ્લામવાસી મિત્ર સાથે લવારું મોકલ્યું ત્યારે તેને તે મળી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","એટલે તેણે તે ગામના માંણસોની પૂછપરછ કરી, કે, “જે વેશ્યા એનાઇમ પાસે રસ્તા પર બેઠી હતી તે કયાં છે?” તેમણે જવાબ આપ્યો, “અહીં કોઈ વેશ્યા હતી જ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","તેથી યહૂદા પાસે પાછા આવીને તેણે કહ્યું, “મને તો તે ન મળી; અને ત્યાંના માંણસોએ પણ કહ્યું કે, અહીં કોઈ વેશ્યા નહોતી.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","એટલે યહૂદા બોલ્યો, “એની પાસે જે છે તે છોને એની પાસે રહે; નહિ તો આપણે અપમાંનિત થઈશું. મેં તો તેને માંટે આ લવારું મોકલ્યું હતું. પણ તને તે મળી નહિ એ જુદી વાત.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","આસરે ત્રણ મહિના બાદ યહૂદાને જાણ થઈ કે, “તારી પુત્રવધૂએ તામાંરે વ્યભિચાર કર્યો છે, પરિણામે તે ગર્ભવતી થઈ છે.” તેથી યહૂદાએ કહ્યું, “તેને બહાર લાવીને બાળી નાખો.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","પરંતુ તેને બાળવા લઈ જતા હતા, ત્યારે તેણે પોતાના સસરાની પાસે માંણસ મોકલીને કહેવડાવ્યું. “આ વસ્તુઓ જેની છે તે માંણસથી મને ગર્ભ રહ્યો છે. આ મુદ્રા તથા અછોડો અને ડાંગ કોના છે? ઓળખો.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","પછી યહૂદાએ વસ્તુઓ ઓળખીને કબૂલ કર્યુ અને કહ્યું, “તે નિદોર્ષ છે, દોષ માંરો છે, કારણ કે મેં એને માંરા પુત્ર શેલાહ સાથે પરણાવી નહિ તેનું આ પરિણામ છે.” તે પછી તેણે તેને ફરીથી જાણી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","પ્રસવકાળે તેને ખબર પડી કે, તેના પેટમાં જોડ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","પ્રસૂતિ વખતે તેમાંના એકે હાથ બહાર કાઢયો, એટલે તરત જ દાયણે તેને પકડી લઈને લાલ દોરાથી બાંધીને કહ્યું, “આ પહેલો આવ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","પણ તેણે તેનો હાથ પાછો ખેંચી લીધો તેથી તેનો ભાઈ પહેલો બહાર આવ્યો, ત્યારે દાયણ બોલી, “તું કેવી રીતે ફાટ પાડીને નીકળ્યો?” તેથી તેનું નામ પેરેસ પડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","પછી લાલ દોરા સાથે તેનો ભાઈ બહાર આવ્યો. જેથી તેનું નામ ઝેરાહ પડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","પછી ઇશ્માંએલીઓ યૂસફને મિસર લઈ આવ્યા અને ત્યાંથી ફારુનના એક મિસરી અમલદાર, અંગરક્ષકોના સરદાર પોટીફારે તેને તેમની પાસેથી વેચાતો લીધો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","પરંતુ યહોવાએ યૂસફને મદદ કરી. તેથી તે બધી બાબતોમાં સફળ થયો. તે તેના મિસરી શેઠના ઘરમાં રહેતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","પોટીફારે જોયું કે, યહોવા યૂસફની સાથે છે. તેથી યૂસફ જે કઈ કરે છે તેમાં યહોવા એને સફળતા બક્ષે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","એટલે પોટીફાર યૂસફને પ્રાપ્ત કરીને પ્રસન્ન થયો. યૂસફ પર તેની કૃપાદૃષ્ટિ હતી. તેથી તેણે તેને પોતાની અંગત સેવામાં રાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","તેણે તેને ઘરનો કારભારી બનાવ્યો અને પોતાની મિલકત તેને સોંપી. જ્યારથી યૂસફને એણે પોતાના ઘરનો અને પોતાની બધી મિલકતનો કારભાર સોંપ્યો ત્યારથી યહોવાએ મિસરીના ઘર પર અને પોટીફારના ઘરમાં અને ખેતરમાં જે કાંઈ હતું તે બધા પર આશીર્વાદ વરસાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","તેથી પોટીફારે ઘરની તમાંમ વસ્તુઓની જવાબદારી યૂસફને સોંપી દીધી. અને પોટીફારે બધી જ ચિંતા છોડી દીધી, તે જે અન્ન ખાતો તે સિવાય બીજી કોઈ ચિંતા કરતો નહિ. યૂસફ સુંદર અને રૂપાળો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","થોડા સમય પછી યૂસફના શેઠના પત્નીએ યૂસફ તરફ તીવ્ર લાલસાથી જોયુ; અને કહ્યું, “માંરી સાથે સૂઈ જા અને માંરી સાથે સૂ.” ");
INSERT INTO guj2009_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","પરંતુ યૂસફે તેની સ્પષ્ટ ના પાડી અને પોતાના શેઠની પત્નીને કહ્યું, “જુઓ, હું છું તેથી માંરા શેઠને ઘરમાં કોઈ વસ્તુની ચિંતા નથી, તેમણે તેમનું જે કાંઈ છે તે બધું એક તમાંરા અપવાદ સિવાય મને સોંપી દીધું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","આ ઘરમાં માંરા કરતાં કોઈનું વધારે ચલણ નથી. તેમ શેઠે કોઈ વસ્તુથી મને બાકાત રાખ્યો નથી, એક તમાંરા વિના, કારણ કે તમે તેમનાં પત્ની છો. માંટે આવું મોટું કુકર્મ કરીને, હું દેવનો ગુનેગાર શી રીતે થઈ શકું?” ");
INSERT INTO guj2009_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","તેણી દરરોજ યૂસફને ઉશ્કેરવા પ્રયત્ન કરી તેણીની સાથે સૂવા માંટે કહેતી, છતાં યૂસફ તેણી સાથે સુવા થતો નહોતો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","એક દિવસ યૂસફ કોઈ કારણસર ઘરમાં ગયો; ત્યારે ઘરમાં ઘરનું કોઈ માંણસ ન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","એટલે તે સ્ત્રીએ એનો ઝભ્ભો પકડીને કહ્યું, “માંરી સાથે સૂઈ જા.” પણ યૂસફ તો તેનો ઝભ્ભો તેના હાથમાં રહેવા દઈને ઘરની બહાર નાસી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","જયારે પેલી સ્ત્રીએ જોયું કે, યૂસફ તેનો ઝભ્ભો એના હાથમાં રહેવા દઈને બહાર નાસી ગયો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","તેણીએ પોતાના ઘરમાંના પુરુષોને બોલાવ્યા અને કહ્યું, “જુઓ, આપણને શરમાંવવા એક હિબ્રૂ માંણસ મોકલાવાયો છે; તે માંરી સાથે સૂવા અંદર આવ્યો હતો, ");
INSERT INTO guj2009_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","એટલે મેં મોટા સાદે બૂમ પાડી, એટલે તે બૂમ સાંભળીને તેનુ વસ્ર માંરા હાથમાં મૂકીને ભાગી ગયો.” ");
INSERT INTO guj2009_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","પછી તેણીએ તેના પતિના આવતા સુધી ઝભ્ભો પોતાની પાસે રાખી મૂકયો, ");
INSERT INTO guj2009_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","અને પોતાના પતિને પણ તેણીએ એ પ્રમાંણે કહ્યું કે, “તમે જે હિબ્રૂ ગુલામ લાવ્યા છો, તે માંરી લાજ લૂંટવા માંટે માંરી પાસે આવ્યો હતો; ");
INSERT INTO guj2009_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","પણ મેં જેવી મોટા સાદે બૂમ પાડી કે, તરત જ તે ઝભ્ભો માંરી પાસે રહેવા દઈને નાસી ગયો.” ");
INSERT INTO guj2009_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","પછી શેઠે જયારે પોતાની પત્નીની વાત સાંભળી કે, “તમાંરા નોકરે માંરી સાથે આવું વર્તન કર્યુ છે,” ત્યારે તે ગુસ્સામાં રાતોપીળો થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","પછી તેણે યૂસફને પકડીને જેલમાં પૂરી દીધો. જે ઠેકાણે રાજાના બંદીવાન કેદ કરાતા હતા. આમ તે ત્યાં કેદખાનામાં રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","પણ યૂસફને યહોવાનો સાથ હતો. તેણે તેના પર દયા કરી અને કેદખાનાના સંત્રીની તેના પર દયા થાય તેમ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","કેદખાનાના સંત્રીએ જેલમાંના બધાં જ કેદીઓને યૂસફના હાથમાં સોંપી દીધા. અને પછી તો તેના હુકમ પ્રમાંણે જ બધું થવા લાગ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","અને યૂસફના હાથમાં જે બાબતો હતી તેના પર સંત્રીએ દેખરેખ રાખવાનું રહ્યું નહિ, કારણ કે યૂસફને યહોવાનો સાથ હતો; તેથી યૂસફ જે કંઇ કરતો તેમાં યહોવા તેનું ભલું કરતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","આ બધું થયા પછી એમ બન્યું કે, મિસરના રાજાના પાત્રવાહકે તથા ભઠિયારાએ તેમના માંલિક મિસરના રાજાનો અપરાધ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","તેથી ફારુન તેના બંને સેવકો પાત્રવાહક અને ભઠિયારા પર કોપાયમાંન થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","અને તેણે તેઓને કેદખાનામાં નાખ્યાં, તે એ કેદખાનું હતું જેના માંટે ફારુનના રક્ષકોનો અમલદાર પોટીફાર અધિકારી હતો, ત્યાં યૂસફ કેદ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","અંગરક્ષકોના સરદારે યૂસફને તેમના તાબામાં સોંપ્યો. તે તેમની સેવા કરતો; આમ તેઓ કેટલાક સમય માંટે કેદમાં રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","એક દિવસ રાત્રે કેદખાનામાં પુરાયેલા મિસરના રાજાના પાત્રવાહકને અને ભઠિયારાને બન્નેને એક સાથે સ્વપ્ન આવ્યું. બન્નેનાં સ્વપ્ન જુદાં હતાં. તથા પ્રત્યેક સ્વપ્નનો અર્થ પણ જુદો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","પછી સવારે જયારે યૂસફે અંદર આવીને જોયું, તો તેઓ ચિંતિત હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","તેથી તેણે તેમને પૂછયું, “આજે તમે કેમ ચિંતિત દેખાઓ છો?” ");
INSERT INTO guj2009_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","એટલે તેઓએ તેને કહ્યું, “અમને દરેકને સ્વપ્ન આવ્યું હતું, પણ તેનો અર્થ કરનાર કોઈ નથી.” એટલે યૂસફે તેઓને કહ્યું, “એક માંત્ર દેવ જ સ્વપ્નોનો ખુલાસો કરી શકે, છે. કૃપા કરી મને તમાંરું સ્વપ્ન કહો.” ");
INSERT INTO guj2009_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","એટલે દ્રાક્ષારસ આપનારા નોકરે પોતાનું સ્વપ્ન યૂસફને કહ્યું, “મેં સ્વપ્નમાં એક દ્રાક્ષનો વેલો જોયો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","તે દ્રાક્ષના વેલાને ત્રણ ડાળીઓ હતી, મેં ડાળીઓ પર કળીઓ બેસતી અને તેમાંથી ફૂલ ફૂટતાં જોયા. અને ગુચ્છામાં પાકી દ્રાક્ષો જોઈ; ");
INSERT INTO guj2009_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ફારુનનો પ્યાલો માંરા હાથમાં હતો. મેં દ્રાક્ષો લઈને તે પ્યાલામાં નિચોવી અને પ્યાલો ફારુનના હાથમાં આપ્યો.” ");
INSERT INTO guj2009_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","પછી યૂસફે કહ્યું, “હું તને સ્વપ્નનો અર્થ સમજાવું છું. ત્રણ ડાળીઓનો અર્થ ત્રણ દિવસ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ત્રણ દિવસમાં ફારુન તને મુકત કરી માંફ કરશે, અને તને તારા પોતાના કામ પર પાછો રાખશે; તું પહેલાં જેમ એનો દ્રાક્ષારસ પીરસનાર હતો તેમ તેના હાથમાં ફારુનનો પ્યાલો આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","પણ જયારે તારા સુખના દિવસો આવે ત્યારે કૃપા કરીને મને સંભારજે. માંરા પર દયા રાખજે. ફારુનને માંરી વાત કરજે અને મને આ કારાગારમાંથી મુકત કરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","અહીંયા હિબ્રૂઓના દેશમાંથી માંરી ઇચ્છા વિરુધ્ધ લાવવામાં આવ્યો છે. મેં અહીં એવું કશુંય ખોટું કર્યુ નથી જેને કારણે મને કારાગૃહમાં નાખવો પડે.” ");
INSERT INTO guj2009_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","રોટલી બનાવનારાએ જોયું કે, બીજા નોકરનું સ્વપ્ન સારું હતું. તેથી તેણે યૂસફને કહ્યું, “મેં પણ એક સ્વપ્ન જોયું હતું. માંરા માંથા પર રોટલીઓની ત્રણ નેતરની છાબડીઓ હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","સૌથી ઉપરની છાબડીમાં ફારુન માંટે દરેક જાતનાં પકવાન હતાં. પરંતુ તેને પંખીઓ ખાઈ જતાં હતાં.” ");
INSERT INTO guj2009_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","યૂસફે કહ્યું, “ત્રણ છાબડીઓનો અર્થ ત્રણ દિવસ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ત્રણ દિવસમાં ફારુન તમને મુકત તો કરશે, પરંતુ તારું માંથું કાપીને તને ઝાડ પર લટકાવશે, અને પંખીઓ તારું માંસ ફોલી ખાશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ત્રીજે દિવસે ફારુનની વર્ષગાંઠ હતી, તે દિવસે તેણે તેના બધા સેવકોને મિજબાની આપી; અને ફારુને તેના સેવકોમાં મુખ્યપાત્રવાહકનો અને ભઠિયારાનો ન્યાય કર્યો, અને બંનેને કારાગૃહમાંથી બહાર આવવા દીધા. ");
INSERT INTO guj2009_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","અને તેણે મુખ્ય પાત્રવાહકને તેની પદવી પર પાછો રાખ્યો; અને તેણે ફારુનના હાથમાં પ્યાલો આપ્યો, ");
INSERT INTO guj2009_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","પણ યૂસફે જે અર્થ કરી બતાવ્યો હતો તે પ્રમાંણે ભઠિયારાને ફાંસીએ ચઢાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","છતાં મુખ્ય પાત્રવાહકએ યૂસફને યાદ કર્યો નહિ, અને તે તેને ભૂલી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","બે વર્ષ પૂરા થયા પછી ફારુનને સ્વપ્ન આવ્યું, જોયું તો પોતે નાઈલ નદીની પાસે ઊભો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","પછી ફારુને સાત સુંદર તંદુરસ્ત પુષ્ટ ગાયોને નદીમાંથી બહાર નીકળીને બરુમાં ચરતી જોઇ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ત્યારબાદ બીજી સાત કદરૂપી અને સુકાઈ ગયેલી ગાયો તેઓની પછવાડે નદીમાંથી બહાર આવી અને કિનારે પેલી બીજી ગાયો સાથે ઊભી રહી. ");
INSERT INTO guj2009_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","પછી તે સાત કદરૂપી સૂકાઈ ગયેલી ગાયો સુંદર તથા પુષ્ટ ગાયોને ખાઈ ગઈ. એટલામાં ફારુનની આંખો ઉઘડી ગઈ. તે જાગી ઊઠયો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ફરી પાછો તે ઊંધી ગયો, ને એણે બીજું સ્વપ્ન જોયું. તેણે એક જ સાંઠા પર ભરેલાં અને સારાં દાણાવાળા સાત ડૂંડાં જોયા. ");
INSERT INTO guj2009_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","અને પછી તેઓની પછવાડે સાત પાતળા અને લૂથી બળી ગયેલા ડૂંડા ફૂટી નીકળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","પછી એ પાતળાં ડૂડાં પેલાં સાત ભરેલાં અને સારાં ડૂંડાને ગળી ગયાં. ત્યાં તો ફારુન જાગી ગયો. અને જાણ્યું કે, આ તો સ્વપ્ન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","સવારે તે આ સ્વપ્નો વિષે ચિંતીત હતો. તેણે મિસરના બધા જયોતિષીઓને તથા શાણા પુરુષોને નિમંત્રણ મોકલ્યા. જ્યારે તેઓ આવ્યા, ફારુને તેમને પોતાના સ્વપ્નો કહ્યાં; પરંતુ તેઓમાંથી કોઈ પણ તેનો અર્થ કહી શકયો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ત્યારે મુખ્ય પાત્રવાહકએ ફારુનને કહ્યું, “આજે મને માંરો ગુનો યાદ આવે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","જ્યારે ફારુને તેના સેવકો પર ક્રોધે ભરાઈ મને તથા મુખ્ય ભઠિયારાને તેણે કારાગૃહમાં નાખ્યા, કે, જે અંગરક્ષકોના ઉપરી ચલાવતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ત્યારે એકજ રાત્રે અમને બંનેને જુંદું જુંદું સ્વપ્ન આવ્યું હતું. અને દરેકને આવેલ સ્વપ્નનો અર્થ જુદો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","અંગરક્ષકોના ઉપરી અમલદારનો સેવક એક જુવાન હિબ્રૂ પણ ત્યાં અમાંરી સાથે હતો; અમે તેને અમાંરાં સ્વપ્નો કહ્યાં એટલે તેણે તે સ્વપ્નોનો અર્થ સમજાવ્યો અને અમને દરેકને પોતપોતાનાં સ્વપ્નનો અર્થ કહી બતાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","તેણે અમને જે અર્થ કહ્યો હતો તે પ્રમાંણે જ બન્યું; મને માંરી પદવી પર પાછો મૂકયો અને ભઠિયારાને ફાંસીની સજા થઇ.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","પછી ફારુનને યૂસફને તેડવા માંટે માંણસો મોકલ્યા, ને તેઓ તેને ઝટપટ કારાગારમાંથી બહાર કાઢી લાવ્યા; પછી તેણે હજામત કરાવી, કપડાં બદલ્યાં અને તે ફારુન પાસે આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ફારુને યૂસફને કહ્યું, “મને એક સ્વપ્ન આવ્યું છે, પણ તેનો અર્થ સમજાવનાર કોઇ નથી. મેં તમાંરા વિષે એવું સાંભળ્યું છે કે, જો તમને સ્વપ્ન કહેવામાં આવે તો તમે તેનો અર્થ કહી શકો છો.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","પછી યૂસફે ફારુનને જવાબ આપતા કહ્યું, “અર્થ કરનાર હું કોણ? ફારુનનું જેમાં કલ્યાણ હોય એવો જવાબ તો દેવ જ આપશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","પછી ફારુનને યૂસફને કહ્યું, “જુઓ, માંરા સ્વપ્નમાં હું નાઇલ નદીને કાંઠે ઊભો હતો; ");
INSERT INTO guj2009_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","અને સાત સુંદર તંદુરસ્ત પુષ્ટ ગાયો નદીમાંથી નીકળીને બીડમાં ચરતી હતી; ");
INSERT INTO guj2009_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","અને જુઓ, તેમની પછવાડે બીજી સાત પાતળી, કદરૂપી અને સૂકલકડી ગાયો નીકળી, આવી કદરૂપી ગાયો મેં કદી આખા મિસરમાં જોઈ નહોતી. ");
INSERT INTO guj2009_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","અને એ સૂકલકડી કદરૂપી ગાયો પેલી હૃષ્ટપુષ્ટ સાત ગાયોને ખાઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","પણ તેમ છતા કોઇ ન કહી શકે કે, તેમણે સ્વસ્થ ગાયો ખાધી છે, કેમકે તેઓ તો પહેલાંના જેવી જ કદરૂપી અને પાતળી જ લાગતી હતી. પછી હું જાગી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ફરી આંખ મળતાં બીજું સ્વપ્ન આવ્યું. મેં એક જ સાંઠા ઉપર ઊગેલાં સાત સારાં ભરાયેલાં દાણાવાળાં ડૂંડા જોયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","અને પછી તેઓની પાછળ જ સૂકાયેલાં તથા હલકાં, ચિમળાઈ ગયેલાં પાતળાં અને લૂથી બળી ગયેલાં ડૂંડા ફૂટી નીકળ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","અને પછી તે હલકાં-પાતળાં ડૂંડા પેલા સાત સારાં ડૂંડાને ગળી ગયાં. “તેથી મેં માંરા જોષીઓને તથા જાદુગરોને આ સ્વપ્ન વિષે પૂછયું, પણ તેઓમાંથી પણ કોઇ મને એનો અર્થ બતાવી શક્યું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ત્યારબાદ યૂસફે ફારુનને કહ્યું, “ફારુનનાં બંને સ્વપ્નનો અર્થ તો એક જ છે. હવે દેવ શું કરનાર છે એ તેણે ફારુનને દર્શાવ્યું છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","સાત સારી ગાયો અને સાત સારાં ડૂંડા એ સાત સારાં વર્ષ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","તેમની પછવાડે જે સાત પાતળી અને કદરૂપી ગાયો નીકળી તે પણ સાત વર્ષ છે. અને લૂથી બળી ગયેલાં સાત ખાલી ડૂંડાં પણ દુકાળનાં સાત વર્ષ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","દેવે તમને તે શું કરવા માંગે છે અને નજીકના ભવિષ્યમાં શું થવાનું છે તેની ફારુનને જાણ કરી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","જુઓ, સમગ્ર મિસરમાં તમાંરી આબાદીનાં તથા ધણી જ પુષ્કળતાના સાત વર્ષ આવશે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","અને ત્યારબાદ સાત વર્ષ દુકાળના આવશે. આખા મિસરમાં લોકો આબાદીની વાતો ભૂલી જશે. એ દુકાળ દેશનો સર્વનાશ કરશે; ");
INSERT INTO guj2009_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","અને એ દુકાળ એવો ભયંકર હશે કે, દેશમાં કયાંય આબાદીનું નામનિશાન જોવા પણ નહિ મળે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“અને ફારુનને બે વાર સ્વપ્ન આવ્યાં તેનો અર્થ એ કે, દેવ તરફથી આ વાત નક્કી થઈ ગયેલ છે. અને દેવ તેને થોડા સમયમાંજ પૂર્ણ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","તેથી કરીને હવે ફારુને કોઈ બુદ્વિમાંન અને જ્ઞાની પુરુષને પસંદ કરીને મિસર દેશનો વહીવટ સોંપી દેવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","દેશભરમાં ફારુને અમલદારો નિયુકત કરવા જોઈએ અને સમૃદ્વિનાં સાત વર્ષ દરમ્યાન મિસરમાંથી પાકનો પાંચમો ભાગ વસૂલ કરવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","અને જે સાત સારાં વર્ષ આવે તે દરમ્યાન બધી જ જાતનું અનાજ ભેગું કરવું જ. અને ફારુનના તાબા નીચે પ્રત્યેક શહેરમાં તેને સાચવવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","અને મિસરમાં દુકાળનાં જે સાત વર્ષ આવશે, ત્યારે એ અનાજનો જથ્થો કામ આવશે. અને દુકાળથી દેશનો નાશ થતો અટકી જશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","આ સલાહ ફારુન અને તેના બધા અમલદારોને પસંદ પડી. તેથી ફારુને પોતાના અમલદારોને કહ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","“આ યોજનાને પાર પાડવા માંટે યૂસફ યોગ્ય માંણસ છે. એનાથી સારો માંણસ આપણને ન મળે, તેની અંદરનો દેવનો આત્માં તેને ઘણો શાણો બનાવે છે!” ");
INSERT INTO guj2009_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","તેથી ફારુને યૂસફને કહ્યું, “યૂસફ જ આ કામ સંભાળવા માંટે લાયક વ્યકિત છે, આની કરતા વધારે લાયકાતવાળું આપણને કોઇ નહિ મળે. દેવનો આત્માં એનામાં છે, જેનાથી એ ખૂબ બુધ્ધિમાંન છે. ");
INSERT INTO guj2009_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","માંટે તું જ માંરો દેશ સંભાળી લે. તારી આજ્ઞાનું પાલન માંરી બધી જ પ્રજા કરશે. ફકત આ રાજગાદીને કારણે જ હું તારા કરતાં મોટો હોઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","વળી તેણે યૂસફને કહ્યું, “જો મેં તને આખા મિસરનો વહીવટ સોંપ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","આમ કહીને ફારુને પોતાના હાથની મુદ્રા લઈને યૂસફના હાથે પહેરાવી દીધી, ને તેને મલમલનાં વસ્ર પહેરાવ્યાં અને ગળામાં સોનાનો હાર પહેરાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","પછી તેણે યૂસફને પોતાના પછીના ઉત્તમ રથમાં બેસાડીને ફેરવ્યો. લોકોએ તેની આગળ દયા પોકારી: “વંદન હો” એવી છડી પોકારી. ફારુને આ રીતે યૂસફને આખા મિસર દેશનો શાસનકર્તા બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","અને તેણે યૂસફને કહ્યું, “હું ફારુન છું; રાજા છું, તેથી માંરી મરજી મુજબ વતીર્શ, પરંતુ તારી પરવાનગી વિના આખા મિસર દેશમાં કોઈ હાથ કે, પગ હલાવશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","પછી ફારુને યુસફનું નામ સાફનાથ-પાનેઆહ રાખ્યું. અને તેને ઓનના યાજક પોટીફેરાની પુત્રી આસનાથને પરણાવી. પછી યૂસફ મિસર દેશમાં ફરવા માંટે નીકળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","જયારે યૂસફ 30 વર્ષનો હતો, ત્યારે ફારુનની નોકરીમાં જોડાયો. તે આખા મિસર દેશમાં ફરી વળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","અને સમૃદ્વિનાં સાત વર્ષ દરમ્યાન મબલખ પાક ઉતર્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","સમગ્ર મિસર દેશમાં એ સાત વર્ષ દરમ્યાન જે અનાજનું ઉત્પાદન થયું તે તેણે એકઠું કર્યુ. ને તે અનાજ દરેક નગરમાં આજુબાજુના ખેતરોમાં ભરી રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","યૂસફે સમુદ્રની રેતી જેટલું ખૂબ ખૂબ અનાજ ભેગુ કર્યુ. તે એટલે સુધી કે, તેનો હિસાબ રાખવાનું પણ છોડી દેવું પડયું. કારણ કે તે બેશુમાંર હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","દુકાળનાં વષોર્ આવતાં પહેલાં ઓનના યાજક પોટીફેરાની પુત્રી આસનાથથી યૂસફને બે પુત્રો થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","દેવે મને માંરી બધી વિપત્તિઓ અને પિતાનું ઘર ભૂલાવી દીધાં છે. એમ કહીને યૂસફે મોટા પુત્રનું નામ મનાશ્શા પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","તેણે તેના બીજા પુત્રનું નામ એફ્રાઇમ પાડ્યું. તેણે કહ્યું, “દેવે મને વષોર્ના દુ:ખો પછી આ ભૂમિમાં બાળકો આપીને સફળ બનાવ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","સમૃદ્વિનાં સાત વર્ષ મિસરનાં આવ્યાં હતાં તે વીતી ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","અને યૂસફના કહ્યા પ્રમાંણે દુકાળનાં સાત વર્ષની શરૂઆત થઈ. બીજા બધા દેશોમાં તો દુકાળ હતો પરંતુ સમગ્ર મિસરમાં અનાજની ખોટ નહોતી. ");
INSERT INTO guj2009_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","પછી જયારે મિસરમાં પણ લોકોને ખાવાના સાંસા પડવા લાગ્યા, ત્યારે તેમણે અનાજ માંટે ફારુનની આગળ કાલાવાલા કર્યા; એટલે ફારુને સર્વ મિસરવાસીઓને કહ્યું, “યૂસફ પાસે જાઓ; અને એ તમને જે કહે તે પ્રમાંણે કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","અને જયારે સમગ્ર દેશમાં દુષ્કાળ પડયો એટલે યૂસફે અનાજના બધા કોઠારો ખોલી નાખ્યા અને મિસરવાસીઓને અનાજ વેચવા માંડ્યુ. કારણ કે સમગ્ર મિસર દેશને દુકાળે ભરડો લીધો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","અને બીજા તમાંમ દેશોમાંથી લોકો મિસર દેશમાં યૂસફની પાસે અનાજ વેચાતું લેવાને આવ્યાં; કારણ કે, સમગ્ર વિસ્તારમાં ભયંકર દુષ્કાળ પડ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","એ સમયે યાકૂબના પ્રદેશમાં ભૂખમરો હતો. પરંતુ તેને ખબર પડી કે, મિસરમાં અનાજ વેચાય છે, એટલે યાકૂબે તેના પુત્રોને કહ્યું, “તમે શા માંટે એકબીજાના મોઢા સામે જોયા કરો છો? ");
INSERT INTO guj2009_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","મને જાણવા મળ્યું છે કે, મિસરમાં અનાજ વેચાય છે, માંટે ત્યાં જાઓ, ને ત્યાંથી આપણા માંટે અનાજ ખરીદી લાવો. જેથી આપણે જીવતા રહીએ, ને ભૂખે ના મરીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","આ સાંભળીને યૂસફના દશ ભાઈઓ અનાજ ખરીદવા માંટે મિસરમાં ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","પરંતુ યાકૂબે યૂસફના સગા ભાઈ બિન્યામીનને તેઓ સાથે મોકલ્યો નહિ. કદાચ એની સાથે કોઇ દુર્ભાગ્ય ઘટના થાય. ");
INSERT INTO guj2009_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","આમ, કનાનના પ્રદેશમાં દુકાળ હતો એટલે બીજા લોકોની સાથે ઇસ્રાએલના પુત્રો પણ અનાજની ખરીદી માંટે આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","મિસર દેશનો શાસનકર્તા યુસફ હતો. દેશના તમાંમ લોકોને તે જ અનાજ વેચાતું આપતો હતો; તેથી યૂસફના ભાઈઓએ તેમની સામે આવીને ભોય લગી મસ્તક નમાંવીને સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","પરંતુ યૂસફે પોતાના ભાઈઓને જોયા અને ઓળખ્યા, છતાં પણ જાણે અજાણ્યો હોય તે રીતે તેઓની સાથે વત્ર્યો. અને કડકાઈથી તેઓને સવાલ કર્યો, “તમે કયાંથી આવો છો?” તેઓએ જવાબ આપ્યો, “અમો કનાનના પ્રદેશમાંથી અનાજ ખરીદવા આવ્યા છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","અને યૂસફે તો તેના ભાઈઓને ઓળખ્યા પણ તે લોકોએ તેને ના ઓળખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","પોતાને એ લોકો વિષે જે સ્વપ્નો આવ્યા હતાં તેનું સ્મરણ થયું. અને યૂસફે તેમને કહ્યું, “તમે જાસૂસ છો; દેશનાં છિદ્રો જોવા આવ્યા છો.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","પણ તેમણે કહ્યું, “ના, સાહેબ, અનાજ ખરીદવા માંટે આપના સેવકો આવ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","અમે બધા એક જ પિતાના પુત્રો છીએ, અમે પ્રામાંણિક લોકો છીએ. આપના સેવકો જાસૂસો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","છતાં યૂસફે કહ્યું, “એમ નહિ, તમે દેશનાં છિદ્રો જોવા જ આવ્યા છો.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","તેથી તેઓએ કહ્યું, “અમે, બધા ભાઈઓ છીએ. અમો કુલ 12 ભાઇઓ છીએ, અમે તમાંરી સામે સેવકો જેવા છીએ. અમો કનાન દેશના એક જ માંણસના પુત્રો છીએ; સૌથી નાનો પુત્ર અમાંરા પિતા પાસે છે, અને બીજા એક પુત્રનો કોઈ પત્તો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","અને યૂસફે તેઓને કહ્યું, “મેં કહ્યું તેમ તમે જાસૂસ જ છો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","એટલા માંટે તમાંરી પરીક્ષા કરવામાં આવશે; ફારુનના જીવના સમ ખાઈને કહું છું કે, તમાંરો સૌથી નાનો ભાઈ અહીં ન આવે, ત્યાં સુધી તમાંરે અહીંથી જવાનું નથી. તમાંરામાંથી ગમે તે એક જણને મોકલીને તમાંરા ભાઈને બોલાવો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ત્યાં સુધી તમાંરે કારાગારમાં બંદીવાન બનવું પડશે; આમ, તમે સાચું બોલો છો કે, કેમ તેની કસોટી થશે, નહિ તો ફારુનના જીવના સમ ખાઈને કહું છું કે, તમે જાસૂસ જ છો.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","અને પછી તેણે તે લોકોને ત્રણ દિવસ સુધી કારાગારમાં રાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","પછી ત્રીજે દિવસે યૂસફે તેઓને કહ્યું, “જો તમે આમ કરશો તો જરૂર બચવા પામશો, કારણ કે હું તો દેવથી ડરીને ચાલનારો માંણસ છું; ");
INSERT INTO guj2009_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","જો તમે ખરેખર સાચા હો તો તમાંરામાંનો ગમે તે એક ભાઈ કારાગારમાં રહે; અને બાકીના સૌ તમાંરા ભૂખે મરતા કુટુંબ માંટે અનાજ લઈને જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","પછી તમાંરા સૌથી નાના ભાઈને માંરી આગળ લઈને આવો; તે પરથી તમાંરી વાત સાચી ઠરશે અને તમાંરે મરવું પણ નહિ પડે.” પછી તે લોકો એમ કરવા સંમત થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","તેઓ એકબીજાને કહેવા લાગ્યા. “ખરેખર આપણે આપણા ભાઈની બાબતમાં ગુનેગાર છીએ. કારણ કે જયારે તેણે આપણને કાલાવાલા કર્યા હતા, ને આપણે તેને થતું કષ્ટ જોયું હતું, છતાં પણ આપણે સાંભળ્યું નહિ; એટલા માંટે જ આ સંકટ આપણા પર આવી પડ્યું છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","રૂબેને તેઓને કહ્યું, “શું મેં તમને નહોતું કહ્યું કે, એ છોકરા પર અત્યાચાર કરીને પાપમાં પડશો નહિ? છતાં તમે માંન્યું નહિ; તેથી હવે તેના રકતનો બદલો ચૂકવવો પડે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","તે લોકો જાણતા નહોતા કે, યૂસફ તેમની વાત સમજે છે; કારણ કે, તેમની વચ્ચે દુભાષિયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","અને પછી યૂસફ તેઓની પાસેથી ચાલ્યો ગયો અને રડી પડયો. પાછળથી તેઓની પાસે પાછા ફરીને તેણે તેઓની સાથે વાત કરી, પછી તેમનામાંથી શિમયોનને લઇને તેમના દેખતાં જ તેને દોરડે બાંધ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ત્યારબાદ યૂસફે તેઓની ગુણોમાં અનાજ ભરવાની દરેકના પૈસા તેના થેલામાં પાછા મૂકવાની તથા તેમને મુસાફરી માંટે ભાતું આપવાની આજ્ઞા કરી; અને તેઓને તે પ્રમાંણે કરી આપવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","પછી તેઓ પોતાનાં ગધેડાંઓ ઉપર અનાજની ગુણો લાદીને ત્યાંથી નીકળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","પછી એક ઉતારામાં તેઓમાંના એકે પોતાના ગધેડાને દાણા ખવડાવવા માંટે પોતાની ગુણ છોડી, ત્યારે થેલાના મોં આગળ જ તેણે પોતાના પૈસા જોયા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","એટલે તરત જ તેણે પોતાના ભાઇઓને કહ્યું, “માંરા પૈસા મને પાછા મળ્યાં છે. જુઓ, આ રહ્યા માંરા થેલામાં!” આ સાંભળીને તે બધા મનમાં ખૂબ ગભરાયા, અને ધ્રૂજતા ધ્રૂજતા તેઓ એકબીજાના મો જોવા લાગ્યાં, અને બોલવા લાગ્યા, “દેવે આપણને આ શું કર્યુ?” ");
INSERT INTO guj2009_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","પછી જયારે તેઓ કનાનમાં પોતાના પિતા યાકૂબ પાસે આવ્યા, ને જે કાંઈ બન્યું હતું તે બધું જ તેમને કહી સંભળાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","તેમણે કહ્યું, “જે માંણસ તે દેશનો શાસનકર્તા છે તેણે અમાંરી સાથે કડકાઈથી વાત કરી અને અમને કઠોર વેણ કહ્યાં, ને અમને દેશના જાસૂસ ગણ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","પણ અમે તો તેને કહ્યું કે, ‘અમે સાચા માંણસો છીએ. અમે જાસૂસ નથી; ");
INSERT INTO guj2009_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","અમે બાર ભાઈઓ એક જ પિતાના પુત્રો છીએ. સૌથી નાનો અત્યારે અમાંરા પિતા પાસે છે. અને એકનો તો કશો પત્તો જ નથી.’ ");
INSERT INTO guj2009_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“તે પછી એ માંણસે તે પ્રદેશના શાસનકર્તાએ અમને કહ્યું, ‘જો તમે હું કહું તેમ કરશો, તો હું જાણીશ કે, તમે પ્રામાંણિક છો, તમાંરામાંના એકને માંરી પાસે રહેવા દો અને બાકીના તમે પાછા જઇ શકો અને તમાંરા ભૂખે મરતા કુટુંબ માંટે અનાજ લઈ જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","અને તમાંરા સૌથી નાના ભાઈને માંરી પાસે લઈને આવો તો હું માંનીશ કે, તમે જાસૂસો નથી, પણ સાચા માંણસ છો. અને હું તમાંરા ભાઈને પાછો તમને સોંપી દઈશ અને તમે આ દેશમાં વેપાર કરજો.’” ");
INSERT INTO guj2009_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","પછી એમ થયું કે, જ્યારે તેઓ પોતપોતાની ગુણો ખાલી કરતાં હતા ત્યારે દરેક જણને તેમના પૈસાની કોથળી ગુણોમાંથી મળી આવી. પછી એ પૈસાની થેલીઓ જોઈને તેઓ તથા તેમના પિતા ગભરાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","પછી તેઓના પિતા યાકૂબે તેમને કહ્યું, “તમે ઇચ્છો છો કે, હું માંરા બધા સંતાનો ગુમાંવી દઉ? યૂસફ ન રહ્યો, શિમયોન ન રહ્યો અને હવે તમે બિન્યામીનને લઈ જાઓ છો; પણ શું આ બધી મુશ્કેલીઓ માંરે સહન કરવાની છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","પછી રૂબેને પોતાના પિતાને કહ્યું, “જો હું એને તમાંરી પાસે પાછો ન લાવું તો તમે માંરા બે પુત્રોને માંરી નાખજો. એને તમે માંરા હાથમાં સોંપો, હું અવશ્ય એને તમાંરી પાસે પાછો લઇને જ આવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","પણ યાકૂબે તેને કહ્યું, “માંરો પુત્ર તમાંરી સાથે નહિ આવે, કારણ કે એનો ભાઇ મરી ગયો છે, અને એ એક જ જીવતો છે. અને મુસાફરી દરમ્યાન જો તેના પર કોઈ આફત આવી પડે તો, તમે માંરાં વૃદ્વત્વને નાશવંત બનાવી અને મને ઉડાં શોક અને દુ:ખમાં મરવા મજબૂર કરશો.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","દેશમાં ભયંકર કારમો દુકાળ હતો. ખાવા માંટેનું કોઈ અનાજ ત્યાં ઊગતું ન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","એટલે તેઓ મિસરમાંથી જે અનાજ લાવ્યા હતા તે બધું જ ખાવામાં વપરાઈ ગયું એટલે તેમના પિતાએ તેમને કહ્યું, “તમે પાછા જાઓ અને આપણા માંટે થોડું અનાજ ખરીદી લાવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","પણ યહૂદાએ કહ્યું, “તે પ્રદેશના શાસનકર્તાએ અમને સખત ચેતવણી આપીને કહ્યું છે કે, ‘તમાંરો ભાઈ સાથે હશે તો જ તમે મને મળી શકશો.’ ");
INSERT INTO guj2009_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","જો તમે અમાંરા ભાઈને અમાંરી સાથે મોકલો તો અમે અનાજ ખરીદવા માંટે જવા તૈયાર છીએ; ");
INSERT INTO guj2009_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","પણ જો તમે તેને નહિ મોકલો તો અમે નહિ જઈએ; કારણ કે પેલા માંણસે અમને સ્પષ્ટ શબ્દોમાં કહ્યું છે કે, ‘તમાંરો ભાઈ સાથે હશે તો જ તમે મને મળવા પામશો.’” ");
INSERT INTO guj2009_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","એટલે ઇસ્રાએલે કહ્યું, “તમાંરો બીજો ભાઈ છે એવું એને જણાવીને તમે મને શા માંટે મુસીબતમાં મૂકયો?” ");
INSERT INTO guj2009_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","તેમણે જવાબ આપ્યો, “પેલા માંણસે આપણા વિષે તેમજ આપણા પરિવાર વિષે પૂછપરછ કરી કે ‘શું, તમાંરા પિતા હજી જીવે છે? તમાંરે બીજા ભાઈ છે?’ એટલે અમાંરે કહેવું પડયું, અમને ખબર ન હતી કે, તે એમ કહેશે કે, તમાંરા ભાઈને અહીં લઈ આવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","પછી યહૂદાએ પોતાના પિતા ઇસ્રાએલને કહ્યું, “એ છોકરાને અમાંરી સાથે મોકલો એટલે અમે ઝટ ચાલી નીકળીએ. જેથી તમે, અમે અને આપણાં બાળકો જીવતાં રહીએ અને મુત્યુના મુખમાંથી ઉગરીએ. ");
INSERT INTO guj2009_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","એની જવાબદારી માંરા માંથે. હું એનો જામીન થાઉં છું. જો એને પાછો લાવીને તમાંરી આગળ રજૂ ન કરું તો તેનો દોષ સદા માંરા પર રહો. ");
INSERT INTO guj2009_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ખરું જોતાં, આપણે જો આટલું મોડું ના કર્યુ હોત તો, અત્યારે તો અમે બે વાર જઈ આવ્યા હોત.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ત્યારે તેમના પિતા ઇસ્રાએલે તેમને કહ્યું, “જો એ સિવાય કોઈ રસ્તો ના હોય તો પછી આમ કરો: બિન્યામીનને તમાંરી સાથે લઈ જાઓ. આપણા દેશની કેટલીક ઉત્તમ વસ્તુઓ તમાંરા સરસામાંનમાં પેલા માંણસ માંટે ભેટરૂપે આપવા લઈ જાઓ, થોડું ગૂગળ, થોડું મધ, થોડા તેજાના, તથા બોળ, પિસ્તાં તથા બદામ; ");
INSERT INTO guj2009_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","તથા તમાંરી સાથે બમણું નાણું લઈ જજો; વળી તમાંરી ગુણોમાં જે નાણું પાછું આવ્યું હતું તે પાછું આપી દેજો; કદાચ કંઈ ભૂલ થઈ હોય; ");
INSERT INTO guj2009_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ઊઠો, અને તમાંરા ભાઈને લઈને તે માંણસ પાસે જાઓ; ");
INSERT INTO guj2009_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","અને સર્વસમર્થ દેવ કરે, ને તે માંણસ તમાંરા પર કૃપાળુ થાય, જેથી તે તમાંરી સાથે તમાંરા બીજા ભાઈને તથા બિન્યામીનને પાછા મોકલે. નહિ તો હું ફરી પાછો માંરો પુત્ર ગુમાંવ્યાનો શોક કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","પછી તે માંણસોએ તેમની સાથે ભેટો, પહેલી વખત કરતાં બમણું નાણું અને બિન્યામીનને લઈને તેઓ ઊપડયા. અને મિસરમાં પહોંચતા તેઓ યૂસફની આગળ આવીને ઊભા રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","પછી યૂસફે તેમની સાથે બિન્યામીનને જોયો તેથી તેણે પોતાના ઘરના કારભારીને કહ્યું, “આ માંણસોને ઘેર લઈજા, કોઈ જાનવરને કાપીને ભોજન તૈયાર કર. કારણ કે આ માંણસો માંરી સાથે જમનાર છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","પછી યૂસફે જેમ કહ્યું તેમ પેલા માંણસે કર્યું; એટલે પેલો માંણસ યૂસફને ઘેર તે માંણસોને લઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","પેલા માંણસોને યૂસફને ઘેર લઈ જવામાં આવ્યા એથી તેઓ ગભરાયા અને કહેવા લાગ્યા, “પહેલી વાર આપણી ગુણોમાં નાણું મૂકેલું હતું તેને લીધે તે આપણને અંદર લઈ આવ્યા છે. હવે એ લોકો આપણા પર તૂટી પડશે અને આપણને જબરજસ્તીથી ગુલામ બનાવશે. તથા આપણા ગધેડાં પણ લઈ લેશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","આથી તેઓ યૂસફના ઘરના બારણા આગળ આવ્યા અને યૂસફના કારભારી પાસે જઈને તેને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“અરે, માંરા સાહેબ! ખરેખર અમે પહેલી વાર આવ્યા ત્યારે અનાજ વેચાતુ લેવા માંટે જ આવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","પણ જયારે અમે મુકામ પર પહોંચીને અમે અમાંરી ગૂણો ઉઘાડી, તો તેના મોઢા આગળ જ અમાંરા દરેકના પૂરેપૂરા પૈસા મૂકેલા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","પણ અમે તે પૈસા પાછા લાવ્યા છીએ; વળી અનાજ ખરીદવા માંટે અમે અમાંરી સાથે બીજા પૈસા પણ લાવ્યા છીએ; અને એ પૈસા અમાંરી ગૂણોમાં કોણે મૂકયા, એ અમે નથી જાણતા.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","કારભારીએ કહ્યું, “શાંતિ રાખો, ગભરાશો નહિ, તમાંરા તથા તમાંરા પિતાના દેવે તમાંરી ગૂણોમાં એ નાણું મૂકયું હતું. મને તો અનાજનાં નાણાં મળી ગયાં હતા.” પછી તેઓ શિમયોનને બહાર કાઢીને તેમની આગળ લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","અને પેલા માંણસે યૂસફના ઘરમાં તે માંણસોને લાવીને તેમને પાણી આપ્યું, પછી તેઓએ પગ ધોયાં; અને તેમનાં ગધેડાંને ચારો નાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","બપોર સુધીમાં યૂસફના આવતા પહેલાં તેઓએ ભેટો તૈયાર કરી; અને યૂસફ જમવા આવે તેની રાહ જોવા લાગ્યા, કારણ કે ત્યાં તેઓએ જમવાનું છે એમ તેમને ખબર હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","પછી જયારે યૂસફ ઘેર આવ્યો ત્યારે તેઓના હાથમાં જે ભેટ હતી તે તેઓ તેની પાસે ઘરમાં લાવ્યા; અને તેમને સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","અને પછી તેમણે તેઓની ખબરઅંતર પૂછીને કહ્યું, “તમાંરા વૃદ્વ પિતા, જેને વિષે તમે મને વાત કરી હતી તે કુશળ છે ને? તેઓ હજી જીવે છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","અને તેઓએ ઉત્તર આપ્યો, “હાજી, આપના સેવક અમાંરા પિતા કુશળ છે અને હજી જીવે છે.” અને તેઓએ ઝૂકીને દંડવત્ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","યૂસફે પોતાની આંખો ઊંચી કરીને પોતાના ભાઈ બિન્યામીનને, જે એની સગી માંનો પુત્ર હતો તેને જોઈને કહ્યું, “તમે જેના વિષે કહ્યું હતું તે જ આ તમાંરો સૌથી નાનો ભાઈ છે? માંરા પુત્ર! દેવ તારા પર કૃપા કરો.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","યૂસફ ઝડપથી બહાર ચાલ્યો ગયો; કારણ કે પોતાના ભાઈને જોઈને તેનું હૈયું ભરાઈ આવ્યું, તે રડી પડવાની તૈયારીમાં હતો. તેથી પોતાની ઓરડીમાં જઈને તે ત્યાં રડવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","પછી મોઢું ધોઈને બહાર આવીને પોતાની જાત પર કાબુ રાખીને તે બોલ્યો, “ભાણાં પીરસો.” ");
INSERT INTO guj2009_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","પછી સેવકોએ યૂસફ માંટે મેજ પાથર્યુ. ત્યારબાદ ભાઇઓ માંટે બીજુ મેજ પાથર્યુ અને તેની સાથે જમતા મિસરીઓ માંટે બીજુ એક મેજ પાથર્યુ કારણ, મિસરીઓ હિબ્રૂઓ સાથે જમવા બેસતા નથી; કારણ કે મિસરીઓની એવી માંન્યતા હતી કે, હિબ્રૂઓ સાથે જમવાનું તેમના માંટે અનુચિત છે. ");
INSERT INTO guj2009_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","યૂસફના ભાઇઓ યૂસફની સામે મોટેથી નાના સુધી ક્રમ પ્રમાંણે બેઠા; અને તેઓ આ બધાથી આશ્ચર્ય પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","તેઓ એકબીજા સામે જોવા લાગ્યા. યૂસફે પોતાના ભાણામાંથી વાનગીઓ લઈને તેઓની આગળ પિરસાવી પણ પ્રત્યેકના ભાણા કરતાં બિન્યામીનનું ભાણું પાંચગણું હતું; તેઓએ તેની સાથે ખાધુંપીધુંને મોજમાં આવી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","પછી યૂસફે પોતાના સેવકને હુકમ કર્યો કે, “એ લોકોની ગૂણોમાં એ લોકો જેટલું લઈ જઈ શકે, તેટલું અનાજ ભરો. અને દરેક જણનાં પૈસા તેની ગુણમાં મોઢા આગળ મૂકી દો; ");
INSERT INTO guj2009_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","સૌથી નાના ભાઈની ગૂણમાં પૈસાની સાથે માંરો પેલો ચાંદીનો પ્યાલો પણ મૂકી દેજો.” અને તેણે યૂસફના હુકમ પ્રમાંણે કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","બીજે દિવસે વહેલી સવારે એ લોકોને તેમનાં ગધેડાં સાથે વિદાય કરવામાં આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","જયારે એ લોકો શહેરથી નીકળીને થોડે દૂર ગયા એટલે યૂસફે કારભારીને કહ્યું, “જા, પેલા લોકોની પાછળ પડ, તેમને પકડી પાડ, અને કહેકે ‘તમે આ શું કર્યુ? ઉપકાર પર અપકાર? તમે માંરા શેઠનો ચાંદીનો પ્યાલો શા માંટે ચોર્યો? ");
INSERT INTO guj2009_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","આ એ જ પ્યાલો છે જે માંરા ધણી પીવા માંટે અને રહસ્યો જાણવા માંટે વાપરે છે. તમે ખરેખર ખોટું કર્યુ છે.’” ");
INSERT INTO guj2009_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","પછી જયારે તેણે તેમને પકડી પાડયા ત્યારે તેણે તેમને આ જ વચનો કહ્યાં; ");
INSERT INTO guj2009_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","પણ તેમણે તેને પૂછયું, “અમાંરા ધણી આવું શા માંટે કહે છે? અમને આમ કરવાનો વિચાર સરખોય આવે ખરો! ");
INSERT INTO guj2009_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","જરા જુઓ તો ખરા, જે પૈસા અમને અમાંરી ગૂણોના મોઢા આગળથી મળ્યા તે અમે છેક કનાન દેશથી તેમને આપવા પાછા લાવ્યા; પછી તારા ધણીના ઘરમાંથી સોનાચાંદીની ચીજો ચોરીએ એવું બને ખરું? ");
INSERT INTO guj2009_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","તારા સેવકો એવા અમાંરી પાસેથી જેની પાસે એ નીકળે તેને ફાંસીની સજા કરજો. અમે પણ અમાંરા ધણીના ગુલામો થઇશું” ");
INSERT INTO guj2009_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","આ સાંભળીને કારભારીએ કહ્યું, “તમાંરી વાત બરાબર છે; જેની પાસેથી એ નીકળે તે માંરો ગુલામ થાય; અને બાકીના નિદોર્ષ પુરવાર થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","પછી તરત જ તે બધાએ પોતપોતાની ગુણો નીચે ઉતારી, ને દરેકે, પોતપોતાની ગુણ ઉઘાડી. ");
INSERT INTO guj2009_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","એટલે કારભારીએ મોટાથી શરૂ કરીને તે નાના સુધીની બધાની ગુણો તપાસી તો બિન્યામીનની ગુણમાંથી ચાંદીનો પ્યાલો મળી આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","જયારે તેઓએ આ જોયું ત્યારે તેઓએ દુ:ખના માંર્યા પોતાનાં કપડાં ફાંડી નાખ્યાં અને દરેક જણે પોતપોતાનાં ગધેડાં બાધ્યા. અને પછી તેઓ નગરમાં પાછા ફર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","જયારે યહૂદા અને તેના ભાઇઓ, યૂસફને ઘેર પહોંચ્યા ત્યારે હજીપણ તે ત્યાં જ હતો; એટલે તેઓ તેનાં ચરણોમાં પડયા. ");
INSERT INTO guj2009_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","યૂસફે તેઓને પૂછયું, “આ તમે શું કર્યુ? તમે એટલું પણ નથી જાણતા કે, માંરા જેવો માંણસ જે શુકન જુએ છે તેને ખબર પડયા વિના રહેશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","યહૂદાએ કહ્યું, “હે ધણી! અમે તમને શું કહીએ? અમાંરી નિદોર્ષતા સાબિત કરવા શું બોલીએ? અમે અમાંરી જાતને કેવી રીતે નિદોર્ષ પૂરવાર કરીએ? દેવે તમાંરા સેવકનો ગુનો ઉઘાડો પાડયો છે; જુઓ, જેની પાસેથી ચાંદીનું પ્યાલું મળ્યું છે તે અને અમે સૌ તમાંરા ગુલામ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","પછી યૂસફે કહ્યું, “માંરાથી એવું થાય કેવી રીતે? માંત્ર જેની પાસેથી પ્યાલો મળ્યો તે જ માંરો ગુલામ બનશે; અને બાકીના તમે બધા તો શાંતિથી તમાંરા પિતાની પાસે જાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","પછીથી યૂસફ પાસે જઈને યહૂદાએ કહ્યું, “ઓ માંરા ધણી, કૃપા કરીને આપના આ સેવકને ખાનગીમાં આપની સાથે બે વાત કરવા દો, અને આપના સેવક પર ક્રોધ ન કરશો. માંરા માંટે તો આપ પોતે ફારુન સમાંન છો. ");
INSERT INTO guj2009_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","માંરા ધણીએ સેવકોને સવાલ કર્યો હતો કે, ‘તમાંરે પિતા અથવા ભાઈ છે?’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","તેથી અમે માંલિકને જવાબ આપ્યો હતો, ‘અમાંરે વૃદ્વ પિતા અને એક નાનો ભાઈ છે, જે એમને પાછલી અવસ્થામાં પ્રાપ્ત થયો હતો. એનો ભાઈ અવસાન પામેલ છે, તેથી તે તેની માંતાનો એકનો એક પુત્ર છે, વળી તેના પિતાને તે ખૂબ વહાલો છે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","અને તમે અમને સેવકોને જણાવેલું કે, ‘તેને માંરી પાસે લઈને આવો એટલે તેને હું જોઉં તો ખરો.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","અને અમે અમાંરા ધણીને કહ્યું હતું કે, ‘તે છોકરો તેના પિતાને મૂકીને આવી શકે, એમ નથી, કારણ કે જો તે પિતાને મૂકીને જાય તો તેના પિતા મૃત્યુ પામે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","અને તમે અમને તમાંરા સેવકોને કહ્યું હતું, ‘જો તમે તમાંરા સૌથી નાના ભાઇને તમાંરી સાથે ન લાવો તો તમે માંરું મુખ ફરી નહિ જોશો.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","પછી અમે આપના સેવકો-અમાંરા પિતા પાસે ગયા અને તેમને અમે ધણીના શબ્દો કહી સંભળાવ્યા, ");
INSERT INTO guj2009_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“અને પછી જયારે અમાંરા પિતાએ કહ્યું, ‘પાછા જાઓ અને આપણા માંટે થોડું અનાજ ખરીદી લાવો.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","એટલે અમે કહ્યું, ‘અમાંરાથી કેવી રીતે જવાય? અમાંરો સૌથી નાનો ભાઈ જો અમાંરી સાથે આવતો હોય તો જ અમે જઇ શકીએ, કારણ, અમાંરો નાનો ભાઇ અમાંરી સાથે ના હોય, તો અમે તે માંણસનું મુખ જોઈ શકીશું નહિ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","એટલે તમાંરા સેવકે અર્થાત્ અમાંરા પિતાએ અમને કહ્યું, ‘તમે જાણો છો કે, માંરાં પત્નીને બે પુત્રો અવતર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","અને તેઓમાંનો એક ગયો ત્યારે મેં કહ્યું કે, “જરૂર એને કોઈ જંગલી પ્રાણીએ ફાડી ખાધો હશે.” અને ત્યાર પછી આજપર્યંત મેં તેને ફરી જોયો નથી. ");
INSERT INTO guj2009_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","અને હવે જો તમે આને પણ માંરી આગળથી લઈ જાઓ, અને જો તેની સાથે કઇ ખોટું થાય તો હું મરવા જેટલો દુ:ખી થઇશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","તેથી કરીને હવે તમાંરા સેવકની એટલે કે, માંરા પિતાની પાસે હું જાઉં, અને એ છોકરો અમાંરી સાથે નહિ હોય તો ");
INSERT INTO guj2009_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","તેનો જીવ એટલો બધો એ છોકરામાં છે કે, અમાંરી સાથે એ છોકરો નથી એ જોતાંની સાથે જ એનું મોત થશે; અને આપના આ સેવકોએ આપના સેવક અમાંરા પિતાને ઘરડેઘડપણ શોક કરતા દફનાવવા પડશે. ");
INSERT INTO guj2009_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“વાત એવી છે કે, હું માંરા પિતા આગળ એ છોકરા માંટે જામીન થયો છું કે, ‘જો હું એની તમાંરી પાસેથી એમની પાસે પાછો ન લાવું તો હું એમનો જીવનભર ગુનેગાર ગણાઈશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","એટલે હવે કૃપા કરીને આ છોકરાને બદલે તમાંરા સેવકને માંરા ધણી પાસે સેવક થઈને રહેવા દો; અને પેલા છોકરાને તેના ભાઈઓની સાથે પાછો જવા દો. ");
INSERT INTO guj2009_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","કારણ કે એ છોકરો જો આપણી સાથે ના હોય, તો આપણાથી પિતા પાસે જવાય શી રીતે? માંરા પિતાનું શું થશે એનો મને બહુ જ ડર લાગે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","યૂસફ પોતાની લાગણીઓને વધુ વખત નિયંત્રિત કરી શકયો નહિ. તેની પાસે ઊભા રહેલા બધાની ઉપસ્થિતિમાં રડી પડ્યો અને બોલી ઊઠયો, “માંરી આગળથી બધાને દૂર કરો.” આથી જયારે યૂસફે પોતાના ભાઈઓ આગળ પોતાની જાતને પ્રગટ કરી ત્યારે ત્યાં બીજુ કોઇ ન હતું. ");
INSERT INTO guj2009_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","તે એટલા મોટા સાદે રડયો કે, મિસરીઓએ તે સાંભળ્યું અને ફારુનના પરિવારને પણ તેની ખબર પડી. પછી યૂસફે પોતાના ભાઈઓને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","“હું યૂસફ છું. શું માંરો બાપ હજુ જીવે છે?” યૂસફની સામે જોતાં જ તેના ભાઈઓ એવા તો ડઘાઈ ગયા કે, તેઓ કોઈ જવાબ આપી શક્યા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","પછી યૂસફે તેના ભાઈઓને કહ્યું, “માંરી નજીક આવશો.” એટલે તેઓ પાસે ગયા, અને તેણે કહ્યું, “હું તમાંરો ભાઈ યૂસફ છું. જેને તમે મિસરની મુસાફરી કરતા વેપારીઓને ગુલામ તરીકે વેચી દીધો હતો. એ તમાંરો ભાઇ હું જ છું. ");
INSERT INTO guj2009_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","માંટે મને અહીં વેચી દેવા માંટે તમે હવે દુ:ખી થશો નહિ, તેમજ જીવ બાળશો નહિ, કારણ આ તો માંરા માંટે દેવની યોજના હતી કે, હું અહીં આવું અને તમને બધાને હું બચાવું. ");
INSERT INTO guj2009_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","કારણ કે છેલ્લાં બે વર્ષથી દેશમાં દુકાળ છે, અને હજુ બીજા પાંચ વર્ષ એવાં જ આવનાર છે, જેમાં કોઇ પણ પ્રકારની ખેતી કે, વાવણી કાપણી થઈ શકશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","તેથી દેવે તમાંરો પરિવાર બચાવવા અને તમાંરા બધાના જીવોનું રક્ષણ કરવા તમાંરી સમક્ષ મોકલ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","એ માંટે મને અહીં મોકલનાર દેવ છે, તમે નથી; અને તેણે જ મને ફારુનના પિતા સમાંન અને તેના આખા ઘરનો વહીવટદાર તથા આખા મિસરનો શાસનકર્તા બનાવ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“તમે ઝટ માંરા પિતા પાસે જાઓ, ને તેમને આ સંદેશ આપો: તમાંરો પુત્ર યૂસફ આ કહે છે: ‘દેવે મને સમગ્ર મિસરનો શાસનકર્તા બનાવ્યો છે, માંટે વિલંબ કર્યા વગર હમણાં જ માંરી પાસે આવો. ");
INSERT INTO guj2009_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","અને તમે તમાંરા પુત્રો સાથે, તમાંરા પ્રપૌત્રો સાથે, તમાંરાં ઘેટાં-બકરાંના ઝુડો અને ઢોરઢાંખરના ટોળાઓ તથા ઘરવખરી સાથે “ગોશેન” પ્રાંતમાં માંરી સાથે રહેશો. જ્યાં હું તમાંરા બધા માંટે બધી જાતની તૈયારી કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","કારણ કે હજુ દુકાળગ્રસ્ત બીજા પાંચ વર્ષ કાઢવાનાં છે. તેથી તું અને તારું કુટુંબ તથા જે બધાં તારાં સગાંસંબંધીઓ છે તે બધુ ગુમાંવીને ગરીબ ન થઇ જાય તે માંટે હું સૌની જાળવણી રાખીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“અને જુઓ, તમે અને માંરો ભાઈ બિન્યામીન નજરોનજર જુઓ છો કે, હું આ માંરા મુખ દ્વારા જ કહી રહ્યો છું. ");
INSERT INTO guj2009_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","અને તમે મિસરમાં માંરો મહિમાં અને બીજું જે કંઈ જોયું છે તે માંરા પિતાને કહેજો; હવે, ઝટ જાઓ અને માંરા પિતાને અહીં લઈ આવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","પછી તે તેના ભાઈ બિન્યામીનને બાથભરી અને રડ્યો. બિન્યામીન પણ તેને ભેટતી વખતે રડવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ત્યાર બાદ યૂસફે પોતાના બધાં જ ભાઈઓને ચુંબન કર્યા અને તેમને ભેટીને રડ્યો. પછી તેના ભાઈઓએ તેની સાથે વાતચીત કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","પછી જયારે ફારુનના મહેલમાં સમાંચાર વહેતાં થયા કે, યૂસફના ભાઈઓ આવ્યા છે; ત્યારે ફારુન તથા તેના સેવકો ખુશ થયા. ");
INSERT INTO guj2009_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","અને ફારુને યૂસફને કહ્યું, “તું તારા ભાઈઓને કહે કે, ‘આ પ્રમાંણે કરો; તમાંરાં જાનવરોને લઈને કનાન દેશમાં ચાલ્યા જાઓ; ");
INSERT INTO guj2009_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","અને તમાંરા પિતાને અને પરિવારને લઈને ઝટ માંરી પાસે પાછા આવો; હું તમને મિસરની ઉત્તમ ફળદ્રુપ જમીન આપીશ અને તમને સૌને ધરતીનું નવનીત ખાવા મળશે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","હવે તમને બીજી આજ્ઞા છે તે પ્રમાંણે કરો, ‘તમાંરાં સંતાનો માંટે તથા તમાંરી પત્નીઓ માંટે મિસર દેશમાંથી ગાડાં લેતાં જાઓ, અને તમાંરા પિતાને લઈને આવો. ");
INSERT INTO guj2009_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","વળી તમાંરી માંલમિલકત જે છે તેને છોડીને આવવાની જરા પણ ચિંતા કરશો નહિ, કારણ કે મિસર દેશમાં જે ઉત્તમ છે તે જમીન તમાંરી છે.’” ");
INSERT INTO guj2009_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","પછી ઇસ્રાએલના પુત્રોએ તે મુજબ કર્યુ; અને ફારુનની આજ્ઞા અનુસાર યૂસફે તેઓને ગાડાં આપ્યાં; ને માંર્ગને માંટે સીધું પણ આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","પછી તેણે તેના દરેક ભાઇને એક જોડ કપડાં આપ્યાં; પરંતુ બિન્યામીનને 300 તોલા ચાંદી અને પાંચ જોડ સારાં કપડાં આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","વધુમાં તેણે પોતાના પિતાના માંટે મિસરની સૌથી બહુમૂલ્ય ચીજોથી લાદેલાં દશ ગધેડાં, અને તેના પિતાની મુસાફરી માંટે અનાજ, રોટલી અને અન્ય જાતના ખાણાથી લાદેલી દશ ગધેડીઓ મોકલી આપી. ");
INSERT INTO guj2009_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","પછી તેણે પોતાના ભાઈઓને વિદાય આપી. વિદાય આપતી વખતે તેણે તેઓને કહ્યું, “માંર્ગમાં ઝઘડો કરશો નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","પછીથી તેઓ મિસરમાંથી નીકળીને કનાન દેશમાં પોતાના પિતા યાકૂબ પાસે આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","અને તેઓએ તેને કહ્યું, “યૂસફ હજુ જીવે છે, અને સમગ્ર મિસરનો તે શાસનકર્તા છે.” આ સાંભળીને યાકૂબ તો સ્તબ્ધ થઈ ગયો. તેને ગળે એ વાત ન ઉતરી. ");
INSERT INTO guj2009_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","પરંતુ યૂસફે તેઓેને જે બધી વાતો કહેલી તે તેને કહી અને તેને મિસર લઈ જવા માંટે યૂસફે મોકલેલાં ગાડાંઓ પર તેની નજર પડી ત્યારે તે ઉત્તેજીત અને ખુશ થયો. ");
INSERT INTO guj2009_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","પછી ઇસ્રાએલ બોલ્યો, “બસ, માંરો પુત્ર યૂસફ હજુ જીવે છે; એટલે મરતાં પહેલાં હું તેને જઇને મળીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","એટલા માંટે ઇસ્રાએલે પોતાની મિસરની યાત્રાનો પ્રારંભ કર્યો. પહેલાં તે બેર-શેબા પહોંચી ગયો. ત્યાં તેમણે પોતાના પિતા ઇસહાકના દેવની ઉપાસના કરીને યજ્ઞો અર્પણ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","રાત્રે દેવે ઇસ્રાએલને સ્વપ્નમાં કહ્યું, “યાકૂબ, યાકૂબ.” અને ઇસ્રાએલે જવાબ આપ્યો, “હું અહીં છું.” ");
INSERT INTO guj2009_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","પછી દેવે કહ્યું, “હું દેવ છું. તમાંરા પિતાનો દેવ. મિસર જતાં જરા પણ ગભરાઈશ નહિ, કારણ કે હું ત્યાં તારાથી એક મોટી પ્રજા નિર્માંણ કરીશ; ");
INSERT INTO guj2009_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","હું તારી સાથે મિસર આવીશ; અને હું ચોક્કસ તને પાછો લાવીશ; અને યૂસફને હાથે જ તારી આંખો મીંચાશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","પછી યાકૂબે બેર-શેબા છોડયું અને મિસર સુધી યાત્રા કરી. તેને લેવા માંટે ફારુને જે ગાડાં મોકલ્યાં હતાં તેમાં ઇસ્રાએલના પુત્રો પોતાના પિતા યાકૂબને, પોતાના પુત્રોને અને વહુઓને લઈ ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","તેઓ પોતાનાં ઢોરઢાંખર તથા માંલમિલકત જે કનાન દેશમાંથી પ્રાપ્ત કરી હતી તે લઈને યાકૂબ તથા તેમનું આખું કુટુંબ તેમની સાથે મિસર આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","એટલે તેના પુત્રો તથા તેની સાથે તેના પુત્રોના પુત્રો, ને તેની પુત્રીઓ તથા તેના પુત્રોની પુત્રીઓને તથા તેનાં સર્વ સંતાનને તે પોતાની સાથે મિસરમાં લાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","યાકૂબની સાથે મિસરમાં આવનારાઓનાં નામ આ છે, એટલે યાકૂબ તથા તેના પુત્રો: યાકૂબનો સૌથી મોટો પુત્ર રૂબેન. ");
INSERT INTO guj2009_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","અને રૂબેનના પુત્રો: હનોખ, પાલ્લૂ, હેસરોન અને કામીર્. ");
INSERT INTO guj2009_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","શિમયોનના પુત્રો: યમુએલ, યામીન, ઓહાદ, યાખીન, સોહાર અને શાઉલ, જે એક કનાની સ્ત્રીથી જન્મ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","લેવીના પુત્રો: ગેશોર્ન, કહાથ તથા મરારી. ");
INSERT INTO guj2009_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","અને યહૂદાના પુત્રો: એર, ઓનાન, શેલાહ, પેરેસ, અને ઝેરાહ. પરંતુ એર અને ઓનાન તો કનાનમાં જ અવસાન પામ્યા હતા. પેરેસના પુત્રો: હેસરોન અને હામૂલ. ");
INSERT INTO guj2009_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ઈસ્સાખારના પુત્રો: તોલા, પુવાહ, યોબ અને શિમ્રોન. ");
INSERT INTO guj2009_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ઝબુલોનના પુત્રો: સેરેદ, એલોન અને યાહલએલ હતો. ");
INSERT INTO guj2009_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","એ લેઆહના પુત્રો છે, જેઓ મેસોપોટામિયામાં યાકૂબથી લેઆહના પેટે જન્મેલા છે. એ ઉપરાંત તેની પુત્રી દીનાહ હતી. તેના પુત્રો અને પુત્રીઓ સર્વ મળીને 33 જણ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","અને ગાદના પુત્રો: સિફયોન, હાગ્ગી, શૂની, એસ્બોન, એરી, અરોદી અને આરએલી. ");
INSERT INTO guj2009_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","આશેરના પુત્રો: યિમ્નાહ, યિસ્યા, યિસ્વી, બરીઆહ અને તેમની બહેન સેરાહ, બરીઆહના પુત્રો: હેબર અને માંલ્કીએલ. ");
INSERT INTO guj2009_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","લાબાને પોતાની પુત્રી લેઆહને આપેલી. ઝિલ્પાહને યાકૂબથી થયેલા આ પુત્રો છે. તેઓ સર્વ મળીને કુલ સોળ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","યાકૂબની પત્ની રાહેલના પુત્રો: યૂસફ તથા બિન્યામીન. ");
INSERT INTO guj2009_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","અને યૂસફને મિસર દેશમાં ઓનના યાજક પોટીફેરાની પુત્રી આસનાથને પેટે મનાશ્શા અને એફ્રાઈમ અવતર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","બિન્યામીનના પુત્રો: બેલા, બેખેર, આશ્બેલ, ગેરા, નાઅમાંન, એહી, રોશ, મુપ્પીમ, હુપ્પીમ અને આર્દ. ");
INSERT INTO guj2009_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","તે યાકૂબથી રાહેલને પેટે જન્મેલા કુલ ચૌદ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","દાનનો પુત્ર: હુશીમ. ");
INSERT INTO guj2009_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","નફતાલીના પુત્રો: યાદસએેલ, ગૂની, યેસર, અને શિલ્લેમ. ");
INSERT INTO guj2009_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","લાબાને પોતાની પુત્રી રાહેલને જે બિલ્હાહ આપી હતી તેના પુત્રો એ છે, ને જેઓ યાકૂબથી તેને થયા તે સર્વ મળીને કુલ સાત જણ હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","યાકૂબના પુત્રોની પત્નીઓ સિવાય તેનાથી જન્મેલા જે સર્વ માંણસ યાકૂબ સાથે મિસરમાં આવ્યાં તેઓ કુલ છાસઠ જણ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","યૂસફને મિસરમાં બે પુત્રો પ્રાપ્ત થયા હતા, તેના પરિવારમાં મિસર આવનારા કુલ સિત્તેર હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","યહૂદાને ઇસ્રાએલે પોતાના પહેલાં યૂસફ પાસે મોકલી આપ્યો જેથી યૂસફ તેને ગોશેનમાં મળે. ");
INSERT INTO guj2009_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","પછી તેઓ ગોશેનમાં પહોચ્યાં. ત્યારે યૂસફ રથ જોડીને તેના પિતા ઇસ્રાએલને મળવા માંટે ગોશેનમાં ગયો; અને તેને જોતાની સાથે જ તે તેને કોટે વળગી પડયો અને તેને ભેટીને ઘણા સમય સુધી રડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ઇસ્રાએલે યૂસફને કહ્યું, “મેં તારું મુખ જોયું, તને જીવતો જોયો, હવે ભલે માંરું મરણ શાંતિથી થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","પછી યૂસફે પોતાના ભાઈઓને અને પોતાના પિતાના પરિવારને કહ્યું, “હું જઈને ફારુનને જાણ કરું છું કે, ‘કનાનમાં રહેતા માંરા ભાઈઓ અને માંરા પિતાના પરિવારના માંણસો માંરી પાસે આવી પહોંચ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","એ લોકો ભરવાડ છે, કારણ કે તેઓ પશુ પાલનનો ધંધો કરે છે. એ લોકો પોતાનાં ઘેટાંબકરાં અને ઢોરઢાંખર તથા તમાંમ ઘરવખરી લઈને આવ્યા છે.’ ");
INSERT INTO guj2009_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","અને કદાચ ફારુન તમને બોલાવે અને પૂછે કે, ‘તમે શો ધંધો કરો છો?’ ");
INSERT INTO guj2009_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ત્યારે તમે કહેજો કે, ‘તમાંરા સેવકોનો, એટલે અમાંરો તથા અમાંરા પિતૃઓનો ધંધો નાનપણથી આજપર્યંત ઢોર ઉછેરનો છે;’ કે, જેને કારણે તમે ગોશેન પ્રાંતમાં રહી શકશો. કારણ કે ભરવાડ માંત્રને મિસરીઓ નફરત કરે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","પછી યૂસફે ફારુન પાસે જઇને કહ્યું, “માંરા પિતા, માંરા ભાઈઓ અને તેમનાં બધાં જ કુટુંબો પોતાનાં ઢોરઢાંખર, ઘેટાં-બકરાં તથા ઘરવખરી લઈને કનાનથી આવી ગયા છે; અને હાલમાં તેઓ ગોશેન પ્રાંતમાં છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","અને તેણે તેના ભાઈઓમાંથી પાંચને લઈ તેમને એણે ફારુન સમક્ષ રજૂ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","પછી ફારુને તેના ભાઈઓને પ્રશ્ર્ન કર્યો, “તમે શો વ્યવસાય કરો છો?” એટલે તેમણે કહ્યું, “આપના સેવકો એટલે અમે અને અમાંરા પિતૃઓ ભરવાડ છીએ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","કનાન દેશમાં ભયંકર દુકાળ પડયો છે એટલે અમાંરા ઘેટાંબકરાં માંટે ત્યાં બિલકુલ ચારો નથી. જેથી અમાંરે આ દેશમાં રહેવા આવવું પડયું છે; માંટે આપના સેવકોની નમ્ર અરજ છે કે, આપ અમને ગોશેન પ્રાંતમાં વસવાટ કરવા દો.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","અને ફારુને યૂસફને કહ્યું, “તારા પિતા અને તારા ભાઈઓ તારી પાસે આવ્યા છે; ");
INSERT INTO guj2009_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","મિસર દેશ તો તારી આગળ છે જ; તેથી દેશમાં ઉત્તમ સ્થળે તારા પિતાને તથા તારા ભાઇઓને રહેવા દે; તેઓ ભલે ગોશેન પ્રાંતમાં વસતા. અને જો એમનામાં કોઈ સમજુ માંણસો તારી નજરમાં હોય તો તેમને માંરાં ઢોર ચરાવવા માંટેના કામનો હવાલો તેમને સોંપી દો.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","અને પછી યૂસફે તેના પિતા યાકૂબને લાવીને ફારુન સમક્ષ રજૂ કર્યા, અને યાકૂબે ફારુનને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ફારુને યાકૂબને પૂછયું, “તમાંરી ઉંમર કેટલી?” ");
INSERT INTO guj2009_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","યાકૂબે કહ્યું, “હું એકસો ત્રીસ વર્ષ જીવ્યો છું. માંરી જીંદગી ટૂંકી અને મુશ્કેલીઓથી ભરપૂર હતી, માંરા પિતા અને માંરા પિતૃઓ માંરા કરતા ઘણા વૃધ્ધ હતા ત્યાં સુધી જીવ્યા.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","પછી ફારુનને આશીર્વાદ આપ્યા બાદ યાકૂબ તેમની પાસેથી ચાલ્યો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","પછી યૂસફે મિસર દેશની સૌથી સારી જગ્યામાં, એટલે રામસેસમાં, ફારુનની આજ્ઞા પ્રમાંણે તેના પિતાને તથા તેના ભાઈઓને ");
INSERT INTO guj2009_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","તથા તેના પિતાના ઘરનાં સર્વને તેમનાં છોકરાં પ્રમાંણે અનાજ પૂરું પાડ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","આખા દેશમાં આકરો દુકાળ હોવાથી કયાંય અનાજ મળતું ન હતું. મિસર તથા કનાન દેશ હેરાન-પરેશાન થઈ ગયા હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","મિસર અને કનાન દેશમાં જે કાંઈ ધન હતું તે બધું લોકો જે અનાજ ખરીદતા હતા તેના બદલામાં લઈને યૂસફે એકઠું કર્યુ હતું તે બધુ જ ધન તેણે ફારુનના મહેલમાં પહોંચાડી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","પછી મિસર અને કનાન દેશમાં નાણું ખૂટયું. બધા મિસરવાસીઓ યૂસફ પાસે આવ્યા અને કહેવા લાગ્યા, “અમને અનાજ આપો. આપની રૂબરૂમાં અમાંરે શા માંટે મરી જવું? હવે અમાંરી પાસે નાણું તો રહ્યું નથી.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","એટલે યૂસફે કહ્યું, “જો નાણું ખૂટી ગયું હોય તો તમાંરાં ઢોર આપો; ઢોરોનાં બદલામાં હું તમને અનાજ આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","તેથી તેઓ પોતાનાં ઢોર લઈને યૂસફ પાસે આવ્યા; અને યૂસફે ઘોડા, ઘેટાં-બકરાં, ર્ઢાર તથા ગધેડાંના બદલામાં તેમને અનાજ આપ્યું. આમ, તેઓનાં બધાં ઢોરઢાંખરના બદલામાં તે વષેર્ અનાજ પૂરું પાડીને તેઓનું ગુજરાન ચલાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","તે વર્ષ પૂર્ણ થયા બાદ બીજે વષેર્ તેઓએ આવીને તેને કહ્યું, “માંલિકથી એ વાત છાની રાખી શકાય તેમ નથી કે, નાણું ખૂટી ગયું છે. અને અમાંરાં ઢોર પણ માંલિકના કબજામાં ચાલ્યાં ગયાં છે; હવે તો અમાંરી પાસે માંત્ર અમાંરી જાત તથા જમીન સિવાય કાંઈ જ બાકી રહ્યું નથી; ");
INSERT INTO guj2009_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","તમાંરી નજર સમક્ષ અમો ચોક્કસ મરી જશું? પણ જો તમે અમને ખાવાનું આપશો તો અમે અમાંરી જમીનો ફારુનને આપી એના ગુલામો બની જશું, માંટે અમને બીજ આપો જેથી અમે મરતા બચી જઈએ અને જીવવા પામીએ, ને જમીન પડતર બની રહે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","અને યૂસફે મિસરવાસીઓની બધી જ જમીન ફારુન માંટે ખરીદી લીધી કારણ કે દુકાળ એટલો બધો કારમો હતો કે, બધાએ પોતાનાં ખેતરો વેંચી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","આમ દેશની જમીન ફારુનની માંલિકીમાં આવી ગઈ અને તેણે દેશના એક સીમાંડાથી બીજા છેડા સુધીના લોકોને શહેરોમાં મોકલ્યા અને તેમને ફારુનના ગુલામ બનાવી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ફકત યાજકોની જમીન તેણે ખરીદી નહિ; કારણ કે તેઓને ફારુન તરફથી નિયત ભથ્થું મળતું તેના આધારે તેઓ જીવતા, જેથી જમીન વેચવી પડી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","પછી યૂસફે લોકોને જણાવ્યું, “જુઓ, આજે મેં ફારુન વતી તમને અને તમાંરી જમીનને વેચાતાં લીધાં છે. લો, આ રહ્યાં બી. તમે જમીનમાં વાવો. ");
INSERT INTO guj2009_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","અને પાક ઊતરવાનો સમય આવે ત્યારે પાકનો પાંચમો ભાગ તમાંરે ફારુનને આપવો, અને ચાર ભાગ તમાંરી પાસ બિયારણ તરીકે અને તમાંરા, પરિવારના અને સંતાનોનાં માંટે ખોરાક તરીકે વાપરવો.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","તેઓ બોલ્યા, “તમે અમાંરા જીવ બચાવ્યા છે; અમાંરા પર અમાંરા માંલિકની કૃપાદૃષ્ટિ થાઓ. અને અમે ફારુનના દાસ થઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","પછી યૂસફે મિસર દેશમાં એવો કાયદો કર્યો કે, તમાંમ જમીનનો પાંચમો ભાગ ફારુનને મળે. એ કાયદો હજી આજે પણ ચાલે છે; માંત્ર યાજકોની જમીન ફારુનનાં કબજામાં આવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","પછી ઇસ્રાએલના પુત્રો મિસર દેશના ગોશેન પ્રાંતમાં આવીને રહ્યાં; અને ત્યાં તેમને માંલમિલકત પ્રાપ્ત થઇ. તેમનો વંશવેલો વધ્યો. અને તેમની સંખ્યા પણ ધણી વધી ગઇ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","યાકૂબ મિસર દેશમાં 17 વર્ષ રહ્યો એટલે તેની ઉંમર 147 વર્ષની થઈ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","પછી ઇસ્રાએલનો અંતકાળ નજીક આવ્યો ત્યારે તેણે પોતાના પુત્ર યૂસફને બોલાવીને કહ્યું, “માંરા પર તારી કૃપાદૃષ્ટિ હોય તો તારો હાથ માંરી જાંધ નીચે મૂક અને માંરી સાથે ખરા મનથી વર્તવાનું મને વચન આપ. ");
INSERT INTO guj2009_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","મને મિસરમાં દફનાવીશ નહિ, પણ જયારે હું માંરા પિતૃઓ પાસે ઊંઘી જાઉ, ત્યારે તું મને મિસરમાંથી લઈ જજે અને માંરા બાપદાદાઓના કબરસ્તાનમાં દફનાવજે.” પછી યૂસફે કહ્યું, “બધું જ હું તમાંરા કહ્યાં પ્રમાંણે કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","અને યાકૂબે કહ્યું, “માંરી આગળ સમ ખા;” એટલે તેણે તેની આગળ સમ ખાધા. પછી ઇસ્રાએલ ઓશીકા તરફ પથારીમાં ઢળી પડ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","સમય જતાં યૂસફને કોઈકે, સમાંચાર આપ્યા કે, તારા પિતાજી માંદા પડયા છે. તેથી તરત જ તે પોતાના બે પુત્રો મનાશ્શા અને એફ્રાઈમને લઈને મળવા ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","જયારે કોઈકે યાકૂબને ખબર આપી કે, “તારો પુત્ર યૂસફ મળવા આવ્યો છે.” એટલે તે શરીરની બધી તાકાત ભેગી કરીને ખાટલા પર બેઠો થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","અને ઇસ્રાએલે યૂસફને કહ્યું, “કનાન દેશના લૂઝ ગામે સર્વસમર્થ દેવે મને દર્શન આપ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","પછી આશીર્વાદ આપીને કહ્યું હતું કે, ‘જો, હું તારો વંશવેલો વધારીશ, તારાં સંતાનોની વૃધ્ધિ કરીશ; અને તારા પછી તારા વંશજોને આ દેશના કાયમના ધણી બનાવીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","અને માંરા મિસરમાં આવતા પહેલાં મિસરમાં તને પ્રાપ્ત થયેલા બે પુત્રો હવે માંરા પુત્રો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","રૂબેન અને શિમયોનની જેમ હવે એફ્રાઈમ અને મનાશ્શા માંરા પુત્રો ગણાશે. એમના પછી થયેલાં તારાં સંતાનો તારાં કહેવાશે; અને તેમનો પ્રદેશ તેમના ભાઈઓનાં નામે ઓળખાશે. ");
INSERT INTO guj2009_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","જયારે હું પાદાનથી આવતો હતો ત્યારે એફ્રાથ પહોંચવાને થોડો રસ્તો બાકી હતો તે દરમ્યાન રસ્તામાં જ કનાન દેશમાં જ રાહેલનું દુ:ખદ અવસાન થયું; એટલે મેં તેને એફ્રાથના એટલે બેથલેહેમના માંર્ગમાં જ દફનાવી.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","અને પછી જયારે યૂસફના પુત્રોને ઇસ્રાએલે જોયા ત્યારે તેણે તેમને સવાલ કર્યો, “આ કોણ છે?” ");
INSERT INTO guj2009_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","એટલે યૂસફે કહ્યું, “એ તો માંરા પુત્રો છે, જે દેવે મને અહીં આપ્યાં છે.” ઇસ્રાએલે કહ્યું, “એમને માંરી પાસે લાવ, જેથી હું એમને આશીર્વાદ આપું.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","હવે વૃદ્વાવસ્થાને કારણે ઇસ્રાએલની આંખોનું તેજ ઓછું થયું હતું. તેને દેખાતું ન હતું. તેથી યૂસફ તેઓને તેમની પાસે લઈ આવ્યો એટલે તેણે તેઓને ચુંબન કર્યુ અને પછી તે તેઓને કોટે વળગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","પછી ઇસ્રાએલે કહ્યું, “મને તો સ્વપ્નમાંય ખબર નહોતી કે, હું તારું મોઢું જોઈ શકીશ. પરંતુ દેવે તો મને તારાં સંતાનોનાં મુખ પણ બતાવ્યાં.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","પછી યૂસફે તેમને તેમના ખોળામાંથી લઈ લીધા અને જમીનને માંથું અડાડીને પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ત્યાર બાદ યૂસફે તે બંનેને લીધા, એફ્રાઈમને જમણી બાજુએ રાખ્યો જેથી તે ઇસ્રાએલની ડાબી બાજુએ રહે અને મનાશ્શાને ડાબી બાજુએ રાખ્યો, જેથી તે ઇસ્રાએલની જમણી બાજુએ રહે; ને એમ તે તેઓને ઇસ્રાએલની પાસે લઈને આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","પરંતુ ઇસ્રાએલે પોતાનો જમણો હાથ લાંબો કરીને એફ્રાઈમ જે નાનો હતો તેના માંથા પર મૂક્યો, અને પોતાનો ડાબો હાથ આંટી પાડીને મનાશ્શાના માંથા પર મૂકયો, જો કે, મનાશ્શા જયેષ્ઠ હતો; ");
INSERT INTO guj2009_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","પછી તેણે યૂસફને આશીર્વાદ આપતાં કહ્યું, “જે દેવની સાક્ષીએ માંરા પિતૃઓ ઇબ્રાહિમ અને ઇસહાક ચાલતા હતા, જે દેવે મને સમગ્ર જીવનપર્યત સંભાળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","જે દેવદૂતે મને સર્વ અનિષ્ટોમાંથી ઉગાર્યો છે, તે આ છોકરાઓને આશીર્વાદ આપો; અને માંરું નામ તથા માંરા પિતૃઓ ઇબ્રાહિમ અને ઇસહાકનાં નામ એમના વડે અમર રહો. અને આ પૃથ્વી પર એમના વંશની વૃદ્વિ થાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","પરંતુ જયારે યૂસફે જોયું કે, તેના બાપે પોતાનો જમણો હાથ એફ્રાઈમને માંથે મૂકયો તો એ બાબતે નાખુશ હતો; અને એફ્રાઈમના માંથા પરથી હાથ ખસેડીને મનાશ્શાના માંથા પર લઈ જવા તેણે પોતાના પિતાનો હાથ ઉપાડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","અને પિતાને કહ્યું, “એમ નહિ, પિતાજી, કારણ કે આ જયેષ્ઠ છે; તમાંરો જમણો હાથ એના માંથા પર મૂકો.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","પરંતુ તેના પિતાજીએ એમ કરવાની ના પાડીને કહ્યું, “હું જાણું છું, બેટા, મને ખબર છે. એ પણ એક પ્રજાનો પિતા થશે, અને મહાન પણ થશે; પરંતુ તેનો નાનો ભાઈ તો તેના કરતાં પણ મોટો થશે, ને તેનાં સંતાનોમાંથી અનેક પ્રજાઓ થશે અને અતિ બહોળી દેશ જાતિ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","આમ, તે દિવસે તેમને આશીર્વાદ આપી ઇસ્રાએલે કહ્યું, “ઇસ્રાએલના લોકો જ્યારે પણ કોઇને આશીર્વાદ આપશે ત્યારે તમાંરા નામનો ઉપયોગ કરશે, તેઓ કહેશે, ‘દેવ તમને એફ્રાઈમ અને મનાશ્શા જેવા બનાવો.’” આમ તેણે એફ્રાઈમને મનાશ્શાથી આગળ મૂકયો. ");
INSERT INTO guj2009_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","પછી યૂસફને ઇસ્રાએલે કહ્યું, “જુઓ, હવે માંરો અંત નજીક છે, પરંતુ દેવ તમને સાથ આપશે. અને ફરીથી તમને તમાંરા પિતૃઓના દેશમાં લઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","પરંતુ મે તને તારા ભાઈઓ કરતાં એક ભાગ વધારે આપ્યો છે, શખેમ પહાડ આપું છું જે મેં અમોરીઓ પાસેથી માંરી તરવાર તથા માંરા ધનુષ્યની તાકાતથી એ જીતી લીધો હતો.” ");
INSERT INTO guj2009_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","પછી યાકૂબે પોતાના પુત્રોને પાસે બોલાવ્યા અને કહ્યું, “તમે બધા ભેગા થાઓ એટલે હું તમને તમાંરા પર ભવિષ્યમાં જે વીતશે તે તમને કહું, ");
INSERT INTO guj2009_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“યાકૂબના પુત્રો તમે ભેગા થાઓ, ને સાંભળો; અને તમાંરા પિતા ઇસ્રાએલની વાત ધ્યાનપૂર્વક સાંભળો. ");
INSERT INTO guj2009_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“રૂબેન, તું તો માંરો જયેષ્ઠ પુત્ર છે, માંરું સાર્મથ્ય અને માંરા પુરૂષત્વનું પ્રથમ ફળ છે. તું માંનમર્યાદામાં સૌથી મોખરે અને શકિતમાં પણ મોખરે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","પૂર જેવાં તારા તીવ્રં આવેશને તું રોકી ન શક્યો; તેથી તું માંરા સૌથી માંનીતો પુત્ર નહિ બને, તું તારા પિતાની શૈયા પર ચઢીને તેની પત્નીઓમાંથી એક સાથે સુતો. તું જે શૈયા પર સૂતો તેને શરમજનક બનાવી છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“વળી શિમયોન તથા લેવી બંને સગાં ભાઈઓ છે, એમની તરવાર હિંસાનુ હથિયાર છે, ");
INSERT INTO guj2009_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","હું એમના કાવતરામાં ભાગ નહિ લઉ. એમના ગુપ્ત મેળાપોમાં સામેલ નહિ થાઉં, કારણ કે તેઓ ક્રોધને વશ થઈને માંણસોનો વધ કરે છે, અને માંત્ર મજાક કરવા પ્રાણીઓને ઇજા પહોંચાડે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","એમનો ક્રોધ એક શાપ છે. એ ખુબ મજબૂત છે. તેઓ જ્યારે ક્રોધમાં ગાંડાતૂર થાય છે ત્યારે ખૂબ જ નિર્દય બને છે. યાકૂબની ભૂમિમાં તેઓની પોતાની જમીન નહિ હોય. તેઓ આખા ઇસ્રાએલમાં પથરાઇ જશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“યહૂદા, તારા ભાઈઓ તારી પ્રશંસા કરશે. તારો હાથ તારા શત્રુઓની ગરદન પર રહેશે; તારા પિતાના પુત્રો તારી આગળ પ્રણામ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","યહૂદા યુવાન સિંહ છે, તે ખૂન કરીને આવ્યો છે, તે સિંહની જેમ થાક ખાવા બેઠો છે. એને છંછેડવા જેટલું બહાદુર કોઇ નથી? ");
INSERT INTO guj2009_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","યહૂદા પરિવારના (પુરુષ) માંણસો રાજા થશે. તેના પરિવારનો રાજદંડ જ્યાં સુધી વાસ્તવિક રાજા ન આવે ત્યાં સુધી જશે નહિ. પછી અનેક લોકો તેનું પાલન કરશે અને તેની સેવા કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","તે પોતાના ગધેડાને દ્રાક્ષના વેલા સાથે બાંધે છે, પોતાના ખોલકાને સૌથી ઉત્તમ દ્રાક્ષના વેલા સાથે બાંધે છે. વળી પોતાનાં વસ્રો દ્રાક્ષારસમાં ધૂએ છે, અને પોતાનો પોષાક દ્રાક્ષના રકતમાં ધૂએ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","દ્રાક્ષારસથી તેની આંખો રાતી થઈ છે, અને તેના દાંત દૂધથી ઉજળા થયા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ઝબુલોન દરિયાકાંઠે રહેશે જે વહાણોનું બંદર બનશે. અને તેની સીમાં છેક સિદોન સુધી પહોંચશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ઈસ્સાખાર બળવાન ગધેડો છે, પણ ઘેટાંઓના વાડામાં જઈને તે આરામથી બેઠો છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","અને તેણે એક આરામ સ્થાન જોયું તો તે સારું હતું. તેને આરામ મીઠો અને પ્રદેશ ખુશનુમાં લાગ્યો. તેથી તેણે બોજો ઉઠાવવા માંટે ખાંધ નમાંવી, અને વેઠ કરનારો ગુલામ બન્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ઇસ્રાએલના અન્ય પરિવારની જેમ જ દાન પોતાના લોકોનો ન્યાય પોતે કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","દાન માંર્ગ પાસેનો સર્પ છે, તે એક સર્પ જેવો છે જે ઘોડાના પગને ડંખ માંરે છે, ને સવાર જોરથી પછાડ ખાઈને જમીન પર પડે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ઓ યહોવા! તું કયારે તારણ કરે એની હું વાટ જોઉં છું. ");
INSERT INTO guj2009_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ગાદ પર હુમલાખોરો આક્રમણ કરશે, અને તે તેમનો પીછો કરીને વળતો હુમલો કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“આશેર પાસે શ્રેષ્ઠ જમીન હશે કે, જેમાં પુષ્કળ પ્રમાંણમાં સારા અનાજની ઊપજ થતી હોય અને તે રાજાને લાયક શ્રેષ્ઠ અનાજ ઉત્પન કરશે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“નફતાલી છૂટથી દોડતુ હરણ છે, એના શબ્દો હરણીના સુંદર બચ્ચાં જેવા છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“યૂસફ ફળદ્રુપ ડાળ છે, ઝરા પાસેથી ફળવંત વેલ, દ્રાક્ષ એક વેલ જેવી શાખા જે દીવાલ સાથે વધે છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","તીરંદાજો તેની વિરુધ્ધ લડ્યાં, તેઓએ તેમના તીરો વડે ક્રૂરતાથી તેના પર આક્રમણ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","પણ તેમનાં ધનુષ્ય થંભી ગયાં, તેમના બાહુ ધ્રુજી ઊઠયા, યાકૂબના સમર્થ દેવના પ્રતાપે આ બધું બન્યું. ");
INSERT INTO guj2009_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","તેને ઇસ્રાએલના ખડક, તમાંરા પૂર્વજોના દેવ, તરફથી શકિત મળી હતી. “અને તમે સર્વસમર્થ દેવથી આશીર્વાદિત થશો. તે તમને ઉપર આકાશ અને ખૂબ નીચેથી આશીર્વાદ આપે. એ તમને છાતી અને ગર્ભમાંથી આશીર્વાદો આપે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","તારા પિતાને મળેલા આશીર્વાદો, તારા પિતૃઓને મળેલા આશીર્વાદો કરતાં મોટા છે, સદાકાળ ટકી રહેનારા પર્વતોની અત્યંત દૂરની સીમાં સુધી વધ્યા છે; તારા ભાઈઓએ તારા માંટે કાંઇ મૂક્યું નથી પરંતુ હવે હું પર્વત જેટલા ઉંચા આશીર્વાદોનો ઢગલો તારા પર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“બિન્યામીન તો ફાડી ખાનાર વરુ છે. સવારે તે શિકાર ખાય છે અને સંધ્યાકાળે એ શિકાર વહેંચે છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","એ બધાં ઇસ્રાએલના બાર કુળ છે; તેમના વડવાએ તેમને જે કહીને આશીર્વાદ આપ્યા તે આ છે; તેણે પ્રત્યેકને પોતપોતાની યોગ્યતા પ્રમાંણે તેઓને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","યાકૂબે પોતાના પુત્રોને આજ્ઞા કરી કે, “હવે હું માંરા પિતૃઓને ભેગા થવાની અણી પર છું. મને માંરા પિતૃઓ ભેગો એફ્રોન હિત્તીના ખેતરમાં આવેલી ગુફામાં દફનાવજો. ");
INSERT INTO guj2009_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","એ ગુફા કનાન દેશમાં માંમરેની સામે માંખ્પેલાહના ખેતરમાં છે. ઇબ્રાહીમે તે એફ્રોન હિત્તી પાસેથી કબ્રસ્તાન તરીકે વાપરવા ખરીદી હતી. ");
INSERT INTO guj2009_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","જ ઇબ્રાહીમ અને તેની પત્ની સારાને દફનાવેલાં છે. ત્યાં જ ઇસહાક અને તેની પત્ની રિબકાને પણ દફનાવ્યાં છે. અને ત્યાં જ મેં પણ લેઆહને દફનાવેલ છે. ");
INSERT INTO guj2009_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","હેથના પુત્રો પાસેથી જે ખેતર તેમાંની ગુફા સાથે ખરીદવામાં આવેલ છે.” ");
INSERT INTO guj2009_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","યાકૂબે પોતાના પુત્રોને સૂચના આપ્યા પછી પોતાના પગ પથારીમાં લઈ સૂઈ ગયો અને પ્રાણ છોડયો, અને તે પોતાના પૂર્વજોની સાથે ભળી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","જયારે ઇસ્રાએલનું અવસાન થયું, યૂસફ બહુજ દુ:ખી થયો. તે પિતાની કોટે વળગી પડયો, અને આંસુ સારવા લાગ્યો. અને ચુંબન કરવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","તેણે પોતાના સેવકોમાંના જે વૈદ્યો હતા, તેઓને પોતાના પિતાના મૃતદેહમાં સુંગંધી દ્રવ્યો ભરવાની આજ્ઞા કરી. એટલે તેઓએ ઇસ્રાએલના મૃતદેહમાં સુગંધીદાર દ્રવ્યો ભર્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","સુગંધી દ્રવ્યો ભરતાં 40 દિવસ લાગે છે તેથી એમાં ચાળીસ દિવસો લાગ્યા. અને તેમને માંટે મિસરીઓએ 70 દિવસ શોક પાળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","તેના શોકના દિવસો પૂરા થયા પછી યૂસફે ફારુનના ઘરના કુટુંબીજનોને કહ્યું, “હવે જો માંરા પર તમાંરી કૃપાદ્દૃષ્ટિ હોય, તો ફારુનના કાનમાં એમ કહો, ");
INSERT INTO guj2009_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","માંરા પિતાએ મને સમ ખવડાવીને કહ્યું હતું, ‘માંરો મરણકાળ નજીક છે, મેં માંરે માંટે કનાનમાં જે કબર ખોદાવેલી છે તેમાં મને દફનાવજો. એટલે કૃપા કરીને મને જવા દો અને માંરા પિતાને દફનાવવાની રજા આપો. એ પછી હું પાછો આવીશ.’” ");
INSERT INTO guj2009_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ફારુને કહ્યું, “સારું, જા, અને તારા પિતાએ સમ ખવડાવ્યા હતા તે પ્રમાંણે જ તેમને દફનાવ.” ");
INSERT INTO guj2009_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","એટલે યૂસફ તેના પિતાને દફનાવવા ગયો; અને ફારુનના બધા અમલદારો તેના વડીલો, મિસર દેશના બધા આગેવાનો, ");
INSERT INTO guj2009_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","તેમ જ યૂસફનો આખો પરિવાર, તેના ભાઈઓ અને તેના પિતાનો પરિવાર પણ ગયો, માંત્ર તેમનાં છોકરાં, ઘેટાંબકરાં અને ઢોરો જ ગોશેનમાં રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","તેમના ઘણા મોટા સમૂહમાં રથો અને ઘોડેસવારો પણ સાથે હતા. ");
INSERT INTO guj2009_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","પછી યર્દન નદીને પાર આટાદની ખળી છે ત્યાં તેઓ આવ્યા. તેઓએ મોટા અને ભારે વિલાપ સાથે રૂદન કર્યુ; અને તેમણે તથા યૂસફે પોતાના પિતા માંટે સાત દિવસનો શોક પાળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","અને જ્યારે કનાનીઓએ આટાદના ખળીમાં પળાતો શોક જોયો ત્યારે કહેવા લાગ્યા, “મિસરીઓ ખૂબજ દુ:ખી શોકસભા કરી રહ્યાં છે.” આથી એ જગ્યાનું નામ આબેલ-મિસરાઈમ પડયું. જે યર્દનને પેલે પાર છે. ");
INSERT INTO guj2009_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","આમ, યાકૂબના પુત્રોએ, પિતાની આજ્ઞા અનુસાર તેમની વ્યવસ્થા કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","તેમના પુત્રો તેને કનાન દેશમાં લઇ ગયા. અને માંમરેની પૂર્વમાં આવેલા માંખ્પેલાહના ખેતરમાંથી ઇબ્રાહિમે જે ગુફા હિત્તીઓ પાસે ખરીદીને કબ્રસ્તાન તરીકેનો ઉપયોગ કરવા માંટે કબજો મેળવ્યો હતો, તે જ ગુફામાં તેને દફનાવવાની વિધિ કરી. ");
INSERT INTO guj2009_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","પોતાના પિતાને દફનાવ્યા પછી યૂસફે પોતાના ભાઈઓ અને જે કોઈ તેની સાથે તેના પિતાને દફનાવવા ગયા હતા તે સર્વને લઈને મિસર પાછા ફરવા માંટે પ્રયાણ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","પોતાના પિતાના મૃત્યુ પછી યૂસફના ભાઈઓને થયું કે, કદાચ યૂસફ અમાંરા પર દ્વેષ કરશે, અને આપણે એના ઉપર જે જે અપકાર્ય કર્યા છે તે બધાનો પૂરો બદલો લે તો? ");
INSERT INTO guj2009_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","એટલે તેઓએ યૂસફને સંદેશો મોકલ્યો કે, “તમાંરા પિતાએ મૃત્યુ પામતાં પહેલાં આજ્ઞા કરી હતી: ");
INSERT INTO guj2009_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","તમે યૂસફને આ પ્રમાંણે કહેજો, ‘તારા ભાઈઓએ તારી સાથે ભૂંડો વ્યવહાર કરીને અપરાધ કર્યો હતો, હવે તું તેઓના અપરાધના પાપને માંફ કરજે, એટલું હું માંગું છું.’ તેથી અમે તમને અરજ કરીએ છીએ કે, તમાંરા પિતાના દેવના આ સેવકોનો અપરાધ માંફ કરો.” યૂસફને આ સંદેશો જેવો પહોંચાડવામાં આવ્યો તેવો જ તે રડી પડયો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","એટલે તેના ભાઈઓ પોતે તેની આગળ આવ્યા અને ચરણોમાં પડીને કહેવા લાગ્યા, “જુઓ, અમે તમાંરા ગુલામ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","પણ યૂસફે તેઓને કહ્યું, “ગભરાશો નહિ, હું કંઇ થોડો જ દેવ છું? ");
INSERT INTO guj2009_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","તમે માંરી સાથે દુષ્ટતા કરવા ચાહી પણ દેવની યોજના સારું કરવાની હતી, કે, જેથી ઘણા લોકોના જીવન બચી જાય, અને આજે એમજ થયું છે. ");
INSERT INTO guj2009_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","તેથી હવે જરા પણ ડરવાની જરૂર નથી. હું તમાંરું તથા તમાંરા પરિવારનાં બાળકોનું ભરણપોષણ કરતો રહીશ.” આમ તેણે તેઓને દિલાસો આપીને હૃદયસ્પશીર્ શબ્દોથી શાંત પાડ્યા. ");
INSERT INTO guj2009_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","યૂસફ તેના પિતાના પરિવાર સાથે મિસરમાં રહ્યો. તે 110 વર્ષ જીવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","અને તેણે એફ્રાઈમની ત્રીજી પેઢીનાં સંતાનો જોયાં, મનાશ્શાના પુત્ર માંખીરનાં દીકરાઓ પણ યૂસફના ખોળામાં ઊછર્યાં. ");
INSERT INTO guj2009_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","યૂસફે તેના ભાઈઓને કહ્યું, “હું તો મરવા પડયો છું; પણ દેવ જરુર તારી સંભાળ લેશે, દોરશે, જેના વિષે તેણે ઇબ્રાહિમ, ઇસહાક, તથા યાકૂબની આગળ શપથ લીધાં હતા, તે દેશમાં તમને તે આ દેશમાંથી લઇ જશે.” ");
INSERT INTO guj2009_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","પછી યૂસફે ઇસ્રાએલના પુત્રોને સમ ખવડાવીને કહ્યું, “દેવ તમને સહાય કરશે ત્યારે તમે માંરાં હાડકાં અહીંથી લઇ જજો.” ");
INSERT INTO guj2009_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","આમ યૂસફ 110 વર્ષનો થઈને મૃત્યુ પામ્યો, અને તેના દેહને મિસરમાં સુગંધી દ્રવ્યો ભરીને એક શબ પેટીમાં મૂકવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","યાકૂબે પોતાના પુત્રો તથા પુત્રોના પરિવાર સહિત મિસરની યાત્રા કરી. ઇસ્રાએલના પુત્રોનાં નામ આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","રૂબેન, શિમયોન, લેવી અને યહૂદા, ");
INSERT INTO guj2009_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ઈસ્સાખાર, ઝબુલોન અને બિન્યામીન, ");
INSERT INTO guj2009_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","દાન અને નફતાલી, ગાદ અને આશેર. ");
INSERT INTO guj2009_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","યાકૂબના પોતાના કુલ સિત્તેર વંશજો હતા. યૂસફ યાકૂબના બાર દીકરામાંથી એક હતો, વળી તે પહેલેથી મિસરમાં જ હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ત્યારબાદ સમય જતાં યૂસફનું અવસાન થયું. પછી તેના બધાજ ભાઈઓ અને તે આખી પેઢીના માંણસો અવસાન પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","પરંતુ ઇસ્રાએલની વસ્તીમાં અનહદ વધારો થતો જ રહ્યો. તેઓની સંખ્યા પુષ્કળ વધી અને તેઓ એટલા બધા શક્તિશાળી બન્યા કે સમગ્ર દેશમાં તેઓ છવાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","હવે મિસરમાં એક નવા રાજાનું શાસન શરૂ થયું. તે વ્યક્તિને યૂસફ વિષે કશી જ ખબર નહોતી. ");
INSERT INTO guj2009_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","તે રાજાએ પોતાની પ્રજાને કહ્યું, “ઇસ્રાએલની, પ્રજાને જુઓ, તેમની વસ્તિ પુષ્કળ છે, અને આપણા લોકો કરતાં તે વધુ શક્તિશાળી છે. ");
INSERT INTO guj2009_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","માંટે હવે આપણે તેમની વિરુદ્ધ કોઈ ચોક્કસ યોજના ઘડવી જોઈએ. જેથી તેઓમાં વધારો થતો અટકી જાય. નહિ તો યુદ્ધ ફાટી નીકળે ત્યારે તેઓ આપણા દુશ્મનો સાથે ભળી જઈને આપણી સામે લડશે અને આપણા દેશમાંથી ભાગી જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","એટલા માંટે તેમણે મજૂરી કરાવીને ઇસ્રાએલીઓને દબાવવા માંટે તેમના ઉપર મુકાદમો નીમ્યા. આ રીતે ઇસ્રાએલીઓએ ફારુનને માંટે પીથોમ અને રામસેસ નગરો વખારો માંટે બાંધ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","પણ જેમ જેમ તેમના પર ત્રાસ વધતો ગયો તેમ તેમ તેમની વૃદ્ધિ થતી ગઈ. વિસ્તાર વધતો ગયો અને મિસરના લોકો ઇસ્રાએલી લોકોથી વધારેને વધારે ભયભીત થવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","આથી તે લોકોએ ઇસ્રાએલીઓ પાસે ચાકરની જેમ સખત મજૂરી કરાવવા માંડી. ");
INSERT INTO guj2009_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","તેમની પાસે બધીજ જાતની કાળી મજૂરી કરાવવા માંડી. ઈંટ અને ચૂનો પાડવાના તથા ખેતરમાં બધીજ જાતનાં સખત કામો કરાવીને તેમનું જીવન અસહ્ય બનાવી દીઘું. ");
INSERT INTO guj2009_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ત્યાં શિફાહ અને પૂઆહ નામની બે હિબ્રૂ દાયણો હતી. તે હિબ્રૂ દાયણોને મિસરના રાજાએ કહ્યું: ");
INSERT INTO guj2009_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“જ્યારે તમે હિબ્રૂ સ્ત્રીઓની પ્રસૂતિ કરાવવા માંટે ખાટલા પાસે જાઓ ત્યારે તેમનાં સંતાનની જાતિ પર ધ્યાન રાખો; છોકરો હોય તો તેને માંરી નાખવો, અને જો છોકરી હોય તો તેને જીવતી રહેવા દેવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","પરંતુ દાયણો દેવથી ડરીને ચાલનારી અને દેવમાં વિશ્વાસ કરતી હતી, એટલે તેણે મિસરના રાજાની આજ્ઞાનું પાલન ન કરતાં તેઓ છોકરાઓને જીવતા રહેવા દેતી. ");
INSERT INTO guj2009_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","તેથી મિસરના રાજાએ દાયણોને બોલાવીને કહ્યું, “તમે આવું શા માંટે કર્યું? તમે લોકોએ છોકરાઓને શા માંટે જીવતા રહેવા દીધા?” ");
INSERT INTO guj2009_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ત્યારે દાયણોએ ફારુનને કહ્યું, “હિબ્રૂ સ્ત્રીઓ મિસરી સ્ત્રીઓ જેવી નથી. તેઓ સશકત અને ખડતલ હોય છે તેથી દાયણના આવતાં પહેલાં જ બાળકને જન્મ આપી દે છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","તેથી દેવે એ દાયણોનું ભલું કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","અને હિબ્રૂ પ્રજા પણ સંખ્યામાં અને શક્તિમાં વૃદ્ધિ પામતી રહી. દાયણો દેવથી ડરીને ચાલતી હતી એટલે તેણે તેમને કુટુંબકબીલાવાળી ઘરવાળી બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","એટલા માંટે ફારુને પોતાના બધા લોકોને આજ્ઞા કરી કે, “હિબ્રૂઓને જન્મેલા પ્રત્યેક છોકરાને નદીમાં ફેંકી દેવા, પણ છોકરીઓને જીવતી રહેવા દેવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","લેવીઓના ઘરનો એક પુરુષ જઈને પોતાની જાતની કન્યાને પરણ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","તે સ્ત્રી ગર્ભવતી થતાં તેને પુત્ર અવતર્યો. પુત્ર રૂપાળો હતો તેથી તેણે તે બાળકને ત્રણ મહિના સુધી સંતાડી રાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","પણ પછી તેને સંતાડી રાખવાનું શક્ય ન રહ્યું એટલે તેણે નેતરનો એક કરંડિયો લીધો, તેને ડામરથી લીપ્યો જેથી તે તરતો રહે. તેમાં બાળકને સુવાડીને કરંડિયો તે નદી કિનારે બરુઓમાં મૂકી આવી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","પછી તે છોકરાનું શું થાય છે, તે જોવા માંટે તેની બહેનને દૂર ઊભી રાખી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","હવે પછી એવું બન્યું કે ફારુનની કુવરી નદીમાં સ્નાન કરવા માંટે આવી અને તેની દાસીઓ નદી કિનારે આમતેમ ફરવા લાગી. કુવરીએ બરુઓમાં પેલો કરંડિયો જોઈને પોતાની દાસીને મોકલીને તે મંગાવી લીધો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","પછી તેણે ઉધાડીને જોયું, તો અંદર એક બાળક રડતું હતું, તેથી તેને તેના પર દયા આવી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","અને તેને કહ્યું, “આ કોઈ હિબ્રૂનું બાળક હોવું જોઈએ. પછી તે બાળકની બહેને ફારુનની દીકરીને કહ્યું, હું જઈને કોઈ હિબ્રૂ ઘાવને બોલાવી લાવું જે બાળકની સાચવણી કરે અને તેના લાલનપાલન કરવા માંટે તમાંરી મદદ કરે?” ");
INSERT INTO guj2009_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ફારુનની કુવરીએ કહ્યું, “જા, બોલાવી લાવ.” એટલે તે છોકરી જઈને બાળકની માંને બોલાવી લાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","કુવરીએ તેને કહ્યું, “આ બાળકને લઈ જા અને માંરા વતી તેની સાચવણી કર અને તેને ઘવડાવ. હું તને તે બદલ પગાર આપીશ.” તેથી સ્ત્રી તેનું બાળક લઈ ગઈ અને તેની સાચવણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","પછી તે બાળક મોટું થયું એટલે તે તેને ફારુનની કુંવરી આગળ લઈ આવી અને તેણે તેને પુત્રની જેમ રાખ્યો. “મેં એને પાણીમાંથી બહાર કાઢયો હતો, ‘એમ કહીને કુવરીએ પુત્રનું નામ મૂસા રાખ્યું.’” ");
INSERT INTO guj2009_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","મૂસા મોટો થયો. અને એક દિવસ પોતાના લોકો પાસે ગયો. તેણે પોતાના માંણસો પર સખ્ત કામ કરવા માંટે બળજબરી થતા જોઈ. અને તેણે એક મિસરીને એક હિબ્રૂને માંરતા જોયો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","તેણે આમતેમ નજર કરી છતાં તેને કોઈ દેખાયું નહિ એટલે તેણે મિસરીને માંરી નાખીને રેતીમાં દાટી દીઘો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","અને બીજે દિવસે તે બહાર ફરવા નીકળ્યો, ત્યારે તેણે બે હિબ્રૂઓને લડતાં જોયા. તેણે જેનો વાંક હતો તે માંણસને કહ્યું, “શા માંટે તું તારા જાતભાઈને માંરે છે?” ");
INSERT INTO guj2009_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","એટલે તે માંણસે તેને કહ્યું, “તને અમાંરો ઉપરી અને ન્યાયાધીશ કોણે બનાવ્યો છે? તે જેમ પેલા મિસરીની હત્યા કરી તેમ માંરી હત્યા કરવા માંગે છે?” તે સાંભળીને મૂસા ડરી ગયો તેથી વિચાર કરવા લાગ્યો કે, “હવે બધાંને ખબર પડી ગઈ છે કે મેં શું કર્યુ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","આ વાતની જાણ ફારુનને થતા, તે મૂસાને માંરી નાખવા તૈયાર થયો. પણ મૂસા ફારુનને ત્યાંથી નાસી જઈને મિધાન દેશમાં જઈને વસ્યો. એક વખત તે કૂવા પાસે બેઠો હતો ");
INSERT INTO guj2009_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ત્યારે મિધાનના યાજકની સાત પુત્રીઓ ત્યાં આવી. અને પોતાના બાપનાં ઘેટાંબકરાને પાણી પીવડાવવા માંટે કૂવામાંથી પાણી ખેંચીને હવાડા ભરવા લાગી. ");
INSERT INTO guj2009_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ત્યાં તો ભરવાડો ત્યાં આવ્યા અને તેમને કાઢી મૂકવા લાગ્યા, પણ મૂસા તેમની જોડે આવી પહોંચ્ચોં અને તેમનાં ઘેટાંબકરાંને પાણી પાયું. ");
INSERT INTO guj2009_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","જ્યારે તેઓ તેમના પિતા રેઉએલ પાસે ગઈ ત્યારે તે બોલ્યા, “આજે તમે આટલાં વહેલાં કેમ આવ્યાં?” ");
INSERT INTO guj2009_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","એટલે તેમણે જવાબ આપ્યો, “અમને એક મિસરીએ ભરવાડોથી બચાવી અને છોડાવી વળી અમને પાણી પણ કાઢી આપ્યું, અને ઘેટાંબકરાંને પાયું.” ");
INSERT INTO guj2009_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","એટલે પછી તેણે પોતાની પુત્રીઓને પૂછયું, “તે કયાં છે? અને તમે તેને મૂકીને શા માંટે આવ્યાં? જાઓ, તેને જમવા માંટે બોલાવી લાવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","મૂસા તે માંણસ સાથે રહેવા સંમત થયો, અને પોતાની પુત્રી સિપ્પોરાહના લગ્ન મૂસા સાથે તેણે કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","પછી તેણે એક પુત્રને જન્મ આપ્યો અને તેનું નામ મૂસાએ ગેર્શોમ એટલા માંટે પાડયું કે, મૂસા બીજાનાં દેશમાં અજાણ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","હવે ઘણો સમય પસાર થયા પછી મિસરના રાજાનું અવસાન થયું. ઇસ્રાએલીઓ ગુલામીમાં પીડાતા હતા. તેઓ આક્રદ કરીને મદદ માંટે પોકાર કરતા હતા તેથી ગુલામીમાંથી કરેલો એ પોકાર દેવ સુધી પહોંચ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","દેવે તેમનું રૂદન અને ઊહંકાર સાંભળ્યો અને ઈબ્રાહિમ, ઈસહાક અને યાકૂબ સાથે કરેલા કરારનું તેમને સ્મરણ થયું. ");
INSERT INTO guj2009_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","અને દેવે ઇસ્રાએલીઓની સ્થિતી જોઈ અને તેમને ખબર હતી કે તે વહેલા તેઓની મદદ કરવાના છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","હવે મૂસા પોતાના સસરાના એટલે મિધાનના યાજક યિથ્રોનાં ઘેટાંબકરાં ચરાવતો અને સાચવતો હતો; એક દિવસ તે ઘેટાંબકરાંને રણની પશ્ચિમ દિશામાં દેવના પર્વત હોરેબ પર દોરી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ત્યાં યહોવાના દૂતે ઝાડવાંમાંથી નીકળતા ભડકારૂપે તેને દર્શન દીઘાં. તેણે જોયું તો ઝાડી સળગતી હતી, પણ બળીને ભસ્મ થતી નહોંતી. ");
INSERT INTO guj2009_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","તેથી મૂસાને વિચાર આવ્યો, “હું નજીક જઈને આ ચમત્કાર જોઉં. આ ઝાડી શા માંટે બળી જતી નથી?” ");
INSERT INTO guj2009_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","યહોવાએ જોયું કે મૂસા ઝાડીને જોવા આવી રહ્યો છે, તેથી દેવે ઝાડીમાંથી તેને બૂમ પાડી, “મૂસા, મૂસા!” અને મૂસાએ જવાબ આપ્યો, “હા, હું અહીં છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ત્યારે યહોવાએ કહ્યું, “નજીક આવીશ નહિ, પગરખાં ઉતારી નાખ, કારણ કે જ્યાં તું ઊભો છે તે ભૂમિ પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","હું તારા પિતૃઓ ઈબ્રાહિમ, ઈસહાક અને યાકૂબનો દેવ છું.” અને મૂસાએ પોતાનું મુખ છુપાવી દીઘું. કારણ કે દેવ તરફ જોતાં તેને ડર લાગતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","પછી યહોવાએ કહ્યું, “મેં મિસરમાં માંરા લોકોને દુઃખ સહન કરતાં જોયા છે. તે તેમના મુકાદમો તેમને પીડા કરે છે ત્યારે તેમના રૂદન મેં સાંભળ્યાં છે, તેમની હાડમાંરીની મને ખબર છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","હું તેમને મિસરીઓનાં પંજામાંથી મુક્ત કરાવવા અને તેમને એ દેશમાંથી બીજા એક સારા વિશાળ દેશમાં લઈ જવા માંટે હું નીચે આવ્યો છું. જ્યાં દૂધ મઘની રેલછેલ છે અને જ્યાં કનાનીઓ, હિત્તીઓ, અમોરીઓ, પરીઝીઓ, હિવ્વીઓ અને યબૂસીઓ વસે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","મેં ઇસ્રાએલના લોકોનું રૂદન સાંભળ્યું છે, અને મિસરીઓ તેમના ઉપર જે ત્રાસ અત્યાચાર કરે છે તે મેં નજરે નિહાળ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ચાલ, એટલા માંટે હું તને ફારુન પાસે મોકલું છું. જાઓ, તમે ઇસ્રાએલના માંરા લોકોને મિસરમાંથી બહાર લઈ આવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","પરંતુ મૂસાએ દેવને કહ્યું, “હું કોણ કે ફારુન પાસે જનારો અને ઇસ્રાએલના લોકોને મિસરની બહાર લાવનારો?” ");
INSERT INTO guj2009_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","પણ દેવે કહ્યું, “હું ચોક્કસ તારી સાથે હોઈશ, અને મેં તને મોકલ્યો છે એની એંધાણી તારા માંટે એ હશે કે જ્યારે તું એ લોકોને મિસરમાંથી બહાર કાઢી લાવીશ પછી તમે સૌ આ પર્વત પર માંરી ઉપાસના કરશો.” ");
INSERT INTO guj2009_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","મૂસાએ દેવને કહ્યું, “હું ઇસ્રાએલના લોકો પાસે જાઉં અને કહું કે, ‘તમાંરા પિતૃઓના દેવે મને તમાંરી પાસે મોકલ્યો છે.’ અને તેઓ મને પૂછે કે, ‘તેનું નામ શું છે?’ તો માંરે તેમને શો જવાબ આપવો?” ");
INSERT INTO guj2009_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ત્યારે દેવે મૂસાને કહ્યું, “એમને કહો, ‘હું એ જ છું જે હું છું.’ જ્યારે તમે ઇસ્રાએલના લોકો પાસે જાઓ ત્યારે તેમને કહો, ‘હું એ છું’ જેણે મને તમાંરી પાસે મોકલ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","દેવે મૂસાને એ પણ કહ્યું, “તમે લોકોને જે કહેશો તે એ કે, ‘તમાંરા પિતૃઓના દેવ યહોવાઓ, ઈબ્રાહિમ, ઈસહાક અને યાકૂબના દેવે મને તમાંરી પાસે મોકલ્યો છે. માંરું નામ સદાને માંટે યહોવા રહેશે અને પેઢી દરપેઢી લોકો મને એ નામે જ ઓળખશે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","યહોવાએ એ પણ કહ્યું, “જાઓ, અને ઇસ્રાએલના વડીલોને (આગેવાનોને) ભેગા કરો અને તેમને કહો કે, ‘તમાંરા પિતૃઓના દેવે, ઈબ્રાહિમ, ઈસહાક અને યાકૂબના દેવે, મને દર્શન આપ્યા અને કહ્યું કે આ સંદેશો તમને આપું, હું તમાંરી પર નજર રાખી રહ્યો છું. મિસરમાં તમે જે મુશ્કેલીઓ સહન કરી છે તે મેં નજરે જોઈ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","અને મેં નિર્ણય કર્યો છે કે હું તમને દુર્દશામાંથી મુક્ત કરાવી કનાનીઓ, હિત્તીઓ, અમોરીઓ, પરીઝીઓ, હિવ્વીઓ અને યબૂસીઓના દેશમાં લઈ જઈશ, જ્યાં દૂધ અને મધની રેલછેલ છે.’ ");
INSERT INTO guj2009_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“વડીલો તમાંરી વાણી સાંભળશે, પછી તમે અને ઇસ્રાએલના વડીલો મિસરના રાજા પાસે જઈને તેને કહેજો કે, ‘હિબ્રૂ લોકોના દેવ યહોવા છે. અમાંરા દેવ અમાંરા લોકો પાસે આવ્યા હતા, તેમણે અમને ત્રણ દિવસ રણમાં પ્રવાસ કરવા માંટે કહ્યું હતું. અમને રજા આપો તો અમે અમાંરા દેવ યહોવાને યજ્ઞ અર્પણ કરી શકીએ.’ ");
INSERT INTO guj2009_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“પરંતુ મને ખબર છે કે મિસરનો રાજા તમને જવા નહિ દે. હા, માંત્ર મહાન શક્તિ જ તેને વિવશ કરશે અને તમને જવા દેશે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","આથી હું માંરું બળ બતાવીશ, અને ત્યાં વિવિધ પ્રકારનાં પરાક્રમો કરીને મિસરને ખોખરું કરીશ, ત્યાર પછી તે તમને જવા દેશે. ");
INSERT INTO guj2009_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ઇસ્રાએલી લોકો પર મિસરના લોકોને દયા થાય તેમ હું કરીશ, પરિણામે જ્યારે તમે નીકળશો, ત્યારે ખાલી હાથે નહિ નીકળો. ");
INSERT INTO guj2009_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“પણ દરેક સ્ત્રી તેની મિસરી પડોશણ પાસેથી અને તેના ઘરમાં રહેનારી મિસરી સ્ત્રી પાસેથી સોનારૂપાનાં દાગીનાં અને સુંદર કિમતી વસ્ત્રો માંગી લેશે, અને તે તમે તમાંરાં પુત્રપુત્રીઓને પહેરવા આપશો; આમ તમે મિસરીઓનું ધન લૂંટી શકશો.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ત્યારે મૂસાએ દેવને કહ્યું, “જ્યારે હું ઇસ્રાએલના લોકોને કહીશ કે તમે મને મોકલ્યો છે, ત્યારે એ લોકો માંરા પર વિશ્વાસ નહિ કરે અને કહેશે, ‘યહોવા તને પ્રત્યક્ષ નથી થયા.’” ");
INSERT INTO guj2009_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","પરંતુ દેવે મૂસાને કહ્યું, “તેં તારા હાથમાં શું રાખ્યું છે?” મૂસાએ જવાબ આપ્યો, “લાકડી, એ તો માંરા ફરવા માંટેની છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ત્યારે દેવે કહ્યું, “તારી લાકડીને જમીન પર ફેંકી દે.” એટલે મૂસાએ તેની લાકડી જમીન પર ફેંકી દીઘી, ને તે સાપ બની ગઈ. અને તે તેનાથી ડરી ગયો ને ભાગવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","પરંતુ યહોવાએ મૂસાને કહ્યું, “આગળ જા, અને સાપની પૂંછડી પકડી લે.” જ્યારે મૂસાએ તેમ કર્યુ તો, હાથમાં સાપ ફરી પાછી લાકડી બની ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","તેથી દેવે કહ્યું, “તારી લાકડીનો આ પ્રમાંણે ઉપયોગ કર, એટલે લોકોને વિશ્વાસ બેસશે કે તેઓના પિતૃઓના દેવ યહોવાએ એટલે ઈબ્રાહિમ, ઈસહાક, અને યાકૂબના દેવે તને દર્શન દીઘાં હતાં.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","પછી યહોવાએ મૂસાને કહ્યું, “હું તને બીજો એક પુરાવે આપુ છું. તારો હાથ ડગલાની અંદર છાતી પર મૂક.” તેણે હાથ અંદર મૂક્યો; અને જ્યારે પાછો કાઢયો ત્યારે, હાથે કોઢ થયેલો હતો, અને હાથ બરફ જેવો સફેદ થઈ ગયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","પછી દેવે કહ્યું, “તારો હાથ પાછો ડગલાની અંદર છાતી પર મૂક.” એટલે તેણે ફરી હાથ ડગલાની અંદર મૂક્યો, અને જ્યારે તેણે તે બહાર કાઢયો ત્યારે, જુએ છે તો ફરી તેના બાકીના શરીર જેવો જ સાજો થઈ ગયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","પછી દેવે કહ્યું, “જો લોકો તારા વિસ્મય લાકડીની નિશાની પછી પણ તારો વિશ્વાસ ના કરે, તો આ બીજા પરચાથી તેમને વિશ્વાસ બેસશે. ");
INSERT INTO guj2009_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","અને જો આ બે નિશાની પરચાઓ બતાવ્યા પછી પણ જો તેમને વિશ્વાસ ના બેસે અને તેઓ તારી વાત ના સાંભળે, તો તારે નાઈલ નદીમાંથી થોડું પાણી લઈને જમીન પર રેડવું જેથી તે લોહી થઈ જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","પરંતુ મૂસાએ યહોવાને કહ્યું, “હે યહોવા, હું સાચું કહું છું કે, હું કંઈ સારો વક્તા નથી. હું લોકો સાથે કુશળતાપૂર્વક વાત કરવાને યોગ્ય નથી. અને હવે તમાંરી સાથે વાતચીત કર્યા પછી પણ, હું કુશળ વક્તા નથી. તમને ખબર છે કે બોલવામાં હું મંદ છું અને ઉત્તમ શબ્દોનો પ્રયોગ કરી શક્તો નથી.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ત્યારે યહોવાઓ તેને કહ્યું, “માંણસને મોઢું કોણે આપ્યું છે? અને તેને મૂંગો કે બહેરો કોણ બનાવે છે? અને માંણસને નજરે દેખતો કે આંધળો કોણ બનાવે છે? એ હું છું યહોવા, જે આ વધું જ કરી શકું છું. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","માંટે હવે જા, જ્યારે તું બોલીશ ત્યારે હું તારી સાથે રહીશ. હું તને બોલવા માંટે શબ્દો આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","છતાં મૂસાએ કહ્યું, “હે માંરા યહોવા, કૃપા કરીને ગમે તે બીજા કોઈને મોકલો, મને નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","યહોવા મૂસા પર ગુસ્સે થયા, અને કહ્યું, “હું તને મદદ કરવા માંટે એક માંણસ મોકલીશ. હું તારા ભાઈ હારુનનો ઉપયોગ કરીશ. તે કુશળ વક્તા છે અને જો, તે તને મળવા આવી રહ્યો છે, તને જોઈને તેનું હૃદય આનંદ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","તે તમાંરી સાથે ફારુનને ધેર આવશે. તારે શું કહેવાનું છે તે હું તને કહીશ, તે તું તેને કહેજે. હું તમને બંનને તમાંરે શું કરવાનું છે તેનો આદેશ આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","હારુન જ તમાંરા માંટે લોકો સાથે વાત કરશે. તું તેમના માંટે મહાન તરીકે રહીશ અને તે તારો અધિકૃત વક્તા હશે. તે તારું મોઢું અને તું તેનો દેવ. ");
INSERT INTO guj2009_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","એટલા માંટે જા, અને તારી લાકડી સાથે લઈ જા. એના વડે તારે પેલા લોકોને ચમત્કારો કરી બતાવવાના છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","પછી મૂસાએ પોતાના સસરા યિથ્રો પાસે પાછા જઈને કહ્યું, “કૃપા કરીને મને જરા માંરા લોકો પાસે મિસર પાછો જવા દો. હું એ જોવા માંગું છું કે તેઓ હજી જીવે છે કે નહિ!” યિથ્રોએ તેને કહ્યું, “સુખશાંતિથી જા.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","તે સમયે મૂસા મિધાનમાં હતો. દેવે તેને કહ્યું, “આ સમયે તારા માંટે મિસર જવું સુરક્ષિત છે. જે વ્યક્તિઓ તને માંરવા ઈચ્છતા હતા તે બધા મરી ગયા છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","આથી મૂસા પોતાની પત્ની અને પુત્રોને ગધેડા પર ચઢાવી પાછો મિસર જવા નીકળ્યો. મૂસાએ પેલી લાકડીને પોતાની સાથે રાખી, જેમાં દેવની શક્તિ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","જે સમયે મૂસા મિસર પાછો જઈ રહ્યો હતો, તે વખતે દેવે તેને કહ્યું, “જ્યારે તું ફારુન સાથે વાત કરે ત્યારે મેં તને જે જે ચમત્કાર બતાવવાની શક્તિ આપી છે તે બધા ફારુન આગળ કરી બતાવજે. પણ હું તેને હઠાગ્રહી બનાવી દઈશ એટલે તે તારા લોકોને જવા દેશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ત્યારે તું ફારુનને કહેજે: ");
INSERT INTO guj2009_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","યહોવા કહે છે કે, ‘ઇસ્રાએલ માંરો પહેલો ખોળાનો પુત્ર છે. અને મેં તને કહ્યું છે કે, માંરા પુત્રને માંરી ઉપાસના કરવા જવા દે. જો તું એને જવા દેવાની ના પાડશે, તો હું તારા પહેલા ખોળાના પુત્રની હત્યા કરીશ.’” ");
INSERT INTO guj2009_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","મૂસા પોતાની મિશરની યાત્રા કરી રહ્યો હતો. મુસાફરોને વિરામ કરવા બનાવેલા એક સ્થાને તે સૂવા માંટે રોકાયો. યહોવા તે મુકામે તેને મળ્યા. અને તેને માંરી નાખવા માંટે પ્રયત્ન કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","પણ સિપ્પોરાહે એક ચકમકનો ધારદાર પથ્થર લઈ પોતાના પુત્રની સુન્નત કરી અને તે ચામડી મૂસાના પગે અડાડીને તે બોલી: “ખરેખર તમે તો માંરા લોહીથી વરેલા વરરાજા છો!” ");
INSERT INTO guj2009_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","સિપ્પોરાહે આ એટલા માંટે કહ્યું, કારણ કે તેને તેના પોતાના પુત્રની સુન્નત કરવી પડી હતી. એટલા માંટે દેવે મૂસાને માંફી આપી અને તેની હત્યા કરી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","યહોવાએ હારુન સાથે વાત કરી હતી. યહોવાએ તેને કહ્યું હતું, “રણમાં જા અને મૂસાને મળ.” એટલા માંટે હારુન દેવના પર્વત પર જઈને તેને મળ્યો અને ભેટી પડ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","મૂસાએ પોતાને યહોવાએ જે જે કહીને મોકલ્યો હતો તે, અને તેને જે જે ચમત્કારો બતાવવાનું કહ્યું હતુ તે બધું કહી સંભળાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ત્યારબાદ મૂસા અને હારુન ગયા અને ઇસ્રાએલના લોકોના બધા વડીલોને એકત્રીત કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","પછી હારુને લોકોને યહોવાએ જે જે કહ્યું હતું, તે બધુંજ કહી સંભાળાવ્યું. તથા મૂસાએ લોકો સમક્ષ ચમત્કાર કરી બતાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","લોકોને વિશ્વાસ બેઠો કે દેવે જ મૂસાને મોકલ્યો છે. તેઓએ મસ્તક નમાંવી તેને પ્રણામ કર્યા અને દેવની સેવા કરી, કારણ કે તેઓને ખબર હતી કે, દેવ ઇસ્રાએલના લોકોની મદદ કરવા આવ્યા હતા. અને તેમણે દેવની ઉપાસના કરી કારણ કે તેઓ જાણતા હતા કે યહોવાએ તેમના દુઃખો જોયાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","લોકોની સાથે વાત કર્યા પછી મૂસા અને હારુન મિસરના રાજા ફારુન પાસે ગયા. તેઓએ કહ્યું, “ઇસ્રાએલના દેવ યહોવા કહે છે, ‘માંરા લોકોને માંરા માંનમાં ઉત્સવ ઊજવવા રણમાં જવા દે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","પરંતુ ફારુને કહ્યું, “યહોવા વળી કોણ છે? હું શા માંટે તેના આદેશ માંનું? શા માંટે હું ઇસ્રાએલીઓને જવા દઉં? તમે જેને યહોવા કહો છો, તેને હું ઓળખતો નથી, તેથી હું ઇસ્રાએલીઓને જવા દેવાની ના પાડું છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ત્યારે હારુન અને મૂસાએ કહ્યું, “હિબ્રૂઓના દેવે અમને લોકોને દર્શન આપ્યાં છે, એટલા માંટે અમે તમને વિનંતી કરીએ છીએ કે તમે અમને રણમાં ત્રણ દિવસ પ્રવાસ કરવા દો. ત્યાં અમે અમાંરા દેવ યહોવાને એક યજ્ઞ અર્પણ કરીશું, જો અમે એ પ્રમાંણે નહિ કરીએ તો તેમનો ક્રોધ ભભૂકી ઊઠશે અને અમાંરો નાશ કરશે. તે અમને મરકી કે તરવારનો ભોગ બનાવશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","પરંતુ ફારુને તેમને કહ્યું, “હે મૂસા અને હારુન, તમે લોકોને હેરાન શા માંટે કરો છો? તમે તે લોકોના કામમાં આડા આવો છો, તેમને તેમનું કામ કરવા દો. તમાંરે બન્નેએ પણ તમાંરું કામ શરુ કરવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","જુઓ, હમણા અહીં ઘણા મજૂરો છે અને તમે તે લોકોને કામમાંથી આરામ આપવા ઈચ્છો છો?” ");
INSERT INTO guj2009_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","બરાબર તે જ દિવસે ફારુને ઇસ્રાએલના લોકો પાસે સખત કામ લેવાનો આદેશ મુકાદમોને આપ્યો. અને ઇસ્રાએલના મુખીઓને હુકમ કર્યો કે, ");
INSERT INTO guj2009_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“હવે તમાંરે એ લોકોને ઈંટો બનાવવા માંટે પરાળ આપવું નહિ; એ લોકોને જાતે જઈને પરાળ ભેગું કરવા દો. ");
INSERT INTO guj2009_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","પરંતુ ધ્યાન રાખજો, અત્યાર સુધી એ લોકો જેટલી ઈંટો બનાવતા આવ્યા હતા તેટલી જ ઈંટો એમની પાસે બનાવડાવજો, એમાં ઘટાડો થવો જોઈએ નહિ, કારણ કે, હવે તે લોકો આળસુ થઈ ગયા છે. તેથી બૂમો પાડે છે કે, અમને અમાંરા દેવના યજ્ઞો કરવા અમને જવા દો. ");
INSERT INTO guj2009_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","એટલા માંટે તે લોકો પાસે વધારે સખત કામ લો. એમને કામમાં રોકી રાખો. પછી એમની પાસે મૂસાની જૂઠી વાતો સાંભળવાનો સમય જ નહિ રહે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","તેથી એ લોકોના મુકાદમોએ અને મુખીઓએ લોકોની પાસે જઈને કહ્યું, “ફારુને નિર્ણય કર્યો છે કે, તે તમને લોકોને ઈંટો બનાવવા માંટે પરાળ નહિ આપે. ");
INSERT INTO guj2009_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","તમાંરે જાતે જ તમાંરા માંટે પરાળ ભેગું કરવા જવું પડશે. તેથી જાઓ, પરાળ ભેગું કરો. પરંતુ તમે લોકો પહેલા જેટલી ઈંટો બનાવતા હતા તેમાં સહેજ પણ ઘટાડો કરવામાં નહિ આવે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","આથી પ્રત્યેક વ્યક્તિ આખા મિસર દેશમાં પરાળ બનાવવા માંટે ખૂંપરા વીણવા ફેલાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","મુકાદમો સખત કામ કરવા માંટે તાકીદ કરતા જ રહ્યા. “પહેલાં પરાળ મળતું હતું, ને રોજ જેટલું કામ કરતા હતા તેટલું જ તમાંરે પૂરું કરવું પડશે. ");
INSERT INTO guj2009_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ફારુનના મુખીઓએ ઇસ્રાએલીઓ ઉપર જે મુકાદમો દેખરેખ રાખવા નિયુક્ત કર્યા હતા તેમને ખૂબ માંર માંરીને પૂછવામાં આવતું કે, ઈટો અત્યાર સુધી જેટલી બનાવતા હતા તેટલી આજકાલ અગાઉની જેમ કેમ પૂરી કરતા નથી?” ");
INSERT INTO guj2009_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","એટલે ઇસ્રાએલીઓના મુખીઓ ફારુનની સમક્ષ આવીને પોકાર કરવા લાગ્યા, “તમે તમાંરા સેવકો સાથે આવો વર્તાવ કેમ રાખો છો? ");
INSERT INTO guj2009_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","તમાંરા સેવકોને પરાળ આપવામાં આવતું નથી તેમ છતાં અમને એમ કહેવામાં આવે છે કે ઈંટો પાડો; જરા જુઓ તો ખરા, તમાંરા સેવકોને કેવો માંર માંરવામાં આવે છે! ખરેખર, વાંક તો તમાંરા માંણસોનો છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","એટલે ફારુને કહ્યું, “તમે બધા તો આળસુ લોકો છો, તેથી કહો છો કે અમને યહોવાના યજ્ઞો કરવા જવા દો. ");
INSERT INTO guj2009_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","માંટે હવે જાઓ, કામે લાગી જાઓ, તમને પરાળ આપવામાં નહિ આવે; અને નક્કી કરેલી ઈંટો તો તમાંરી વરઘી પ્રમાંણે પૂરી કરવી જ પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","હિબ્રૂ મુકાદમોને જાણમાં આવ્યું કે તેઓ તકલીફમાં છે. તેમને ખબર હતી કે તેઓ માંણસો પાસેથી પહેલા જેટલી ઈંટો તૈયાર નથી કરાવી શકતા. ");
INSERT INTO guj2009_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","અને પછી ફારુનની પાસેથી તેઓ નીકળ્યા ત્યારે મૂસા અને હારુન તેઓને રસ્તામાં મળ્યા. તેઓ તેમની રાહ જોતા ઊભા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","તેઓએ મૂસા અને હારુનને કહ્યું, “તમે શું કર્યુ છે એ યહોવા જુએ અને તમને સજા કરે. કારણ તમે અમને ફારુન અને તેના સેવકોની નજરમાં તિરસ્કૃત બનાવી દીઘા છે; અને અમાંરી હત્યા કરવા માંટે તેઓને એક બહાનું આપી દીધું છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ત્યારે મૂસાએ યહોવાને પ્રાર્થના કરી અને કહ્યું, “હે યહોવા, તમે આ લોકોના આવા ભૂંડા હાલ શા માંટે કર્યા? વળી તમે મને જ શા માંટે મોકલ્યો? ");
INSERT INTO guj2009_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","કારણ કે હું તમાંરા નામે ફારુન સાથે વાત કરવા આવ્યો ત્યારથી તેણે આ લોકોનું ભૂંડુ કરવા માંડયુ છે, અને તમે તમાંરા લોકોને બચાવવાં માંટે કશું જ કર્યુ નથી.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","પછી યહોવાએ મૂસાને કહ્યું, “હવે તું જોઈશ કે હું ફારુનની શી હાલત કરું છું. હું માંરી મહાન શક્તિનો ઉપયોગ તેના વિરોધમાં કરીશ. અને હું તેને માંરા લોકોને બહાર જવા દેવાની ફરજ પાડીશ. અને તે બળવાન હાથથી એ લોકોને તેના દેશમાંથી હાંકી કાઢશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","અને દેવે મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“એ હું યહોવા છું જે ઈબ્રાહિમ, ઈસહાક અને યાકૂબ સમક્ષ પ્રગટ થયો હતો; તેમણે મને એલ શદાય (સર્વસમર્થ દેવ) કહ્યો. પરંતુ મેં માંરું યહોવા નામ તેમને જણાવ્યું નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","મેં તેમની સાથે કરાર કર્યો, તેઓ જે દેશમાં જઈને વસ્યા હતા તે કનાન દેશનું મેં તેમને વચન આપ્યું હતું. તેઓ ત્યા રહેતા હતા, પણ તે તેમનો પોતાનો પ્રદેશ ન હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","મેં ઇસ્રાએલના લોકોનાં ઊહંકાર સાંભળ્યા છે. હું જાણું છું કે તેઓ મિસરના ચાકરો છે અને મેં માંરો કરાર સંભાર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","એટલા માંટે ઇસ્રાએલના લોકોને કહો કે, ‘હું તેમને કહું છું, હું યહોવા છું. હું તમાંરા લોકોનું રક્ષણ કરીશ. હું તમને લોકોને મિસરીઓની મજૂરીમાંથી છોડાવીશ અને ગુલામીમાંથી મુક્ત કરીશ. હું માંરી મહાન શક્તિનો ઉપયોગ કરીને મિસરીઓને ભયંકર શિક્ષા કરીશ પછી હું તમાંરો ઉધ્ધાર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","તમે બધા લોકો માંરા થશો, ને હું તમાંરા બધાનો દેવ થઈશ. હું યહોવા તમાંરા લોકોનો દેવ છું એની તમને ત્યારે ખબર પડશે જ્યારે હું તમને મજૂરીમાંથી મુક્તિ અપાવીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","હું યહોવા છું, મેં ઈબ્રાહિમ, ઈસહાક અને યાકૂબને જે દેશ આપવાનું પ્રતિજ્ઞાપૂર્વક વચન આપ્યું હતું, તે દેશમાં હું તમને લઈ જઈશ અને તમને તેના વારસદાર બનાવીશ.’” ");
INSERT INTO guj2009_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","એટલા માંટે મૂસાએ એ વાત ઇસ્રાએલના લોકોને કહી. પણ તે વખતે તે લોકો આકરી ગુલામીથી એવા હતાશ થઈ ગયા હતા કે તેમણે તેની વાત સાંભળી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ત્યારે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“જાઓ, અને મિસરના રાજા ફારુનને કહો કે, તે ઇસ્રાએલના લોકોને આ દેશમાંથી જરૂર બહાર જવા દે.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","પરંતુ મૂસાએ યહોવાને કહ્યું, “ઇસ્રાએલના લોકો માંરી વાત સાંભળવા પણ નથી માંગતા, તો પછી ફારુન શી રીતે સાંભળશે? મને તો સારી રીતે બોલતાં પણ નથી આવડતું.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","પરંતુ યહોવાએ મૂસા અને હારુન સાથે વાતચીત કરી. દેવે તેમને આજ્ઞા કરી કે, તમાંરે મિસરના રાજા ફારુન પાસે જવું અને ઇસ્રાએલીઓને મિસર બહાર લઈ આવવા. ");
INSERT INTO guj2009_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ઇસ્રાએલના પરિવારોના આગેવાનોનાં નામ આ પ્રમાંણે છે: ઇસ્રાએલના સૌથી મોટા પુત્ર રૂબેનને ચાર પુત્રો હતા. તેઓ હનોખ, પાલ્લુ, હેસ્રોન અને કાર્મી હતા; ");
INSERT INTO guj2009_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","શિમયોનના પુત્રો; યમુએલ, યારીન, ઓહાદ, યાખીન, સોહારને શાઉલ, જે એક કનાની સ્ત્રીને પેટે અવતર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","લેવીના પુત્રો: ગેર્શોન, કહાથ અને મરારી હતા. તેઓ એમને નામે ઓળખાતાં પરિવારોના પૂર્વપુરુષો હતા. લેવીનું આયુષ્ય 137 વર્ષનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ગેર્શોનના પુત્રો: લિબ્ની અને શિમઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","કહાથના પુત્રો: આમ્રામ, યિસ્હાર, હેબ્રોન અને ઉઝઝીએલ, કહાથનું આયુષ્ય 133 વર્ષનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","મરારીના પુત્રો: માંહલી અને મૂશી હતા. આ બધા પરિવાર ઇસ્રાએલના પુત્ર લેવીના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","આમ્રામ પોતાની ફોઈ યોખેબેદ સાથે પરણ્યો, અને તેને હારુન અને મૂસાના જન્મ થયા. આમ્રામનું આયુષ્ય 137 વર્ષનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","યિસ્હારના પુત્રો: કોરાલ, નેફેગ અને ઝિખ્રી. ");
INSERT INTO guj2009_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ઉઝઝીએલના પુત્રો: મીશાએલ, એલ્સાફાન અને સિથ્રી. ");
INSERT INTO guj2009_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","હારુનના વિવાહ આમ્મીનાદાબની પુત્રી અને નાહશોનની બહેન અલીશેબા સાથે થયા. અને અલીશેબાને નાદાબ, અબીહૂ, એલઆઝાર અને ઈથામાંર અવતર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","કોરાહના પુત્રો: આસ્સીર, એલ્કાનાહ અને અબિઆસાફ. આ પરિવારો કોરાહીઓનાં પિતૃઓ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","હારુનના પુત્ર એલઆઝારે પૂટીએલની પુત્રી સાથે લગ્ન કર્યા અને તેણે ફીનહાસને જન્મ આપ્યો. આ બધાજ પૂર્વપુરુષો લેવી વંશના પરિવારના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","આ રીતે હારુન અને મૂસા આ કૂળ-સમૂહના હતા અને તે એ જ વ્યક્તિઓ છે જેની સાથે દેવે વાત કરી હતી. અને કહ્યું હતું કે, “ઇસ્રાએલીઓને ટૂકડી પ્રમાંણે મિસરમાંથી બહાર કાઢો.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","હારુન અને મૂસાએ જ મિસરના રાજા ફારુન સાથે વાત કરી. તેમણે ફારુનને કહ્યું કે, “તે ઇસ્રાએલના લોકોને મિસરની બહાર લઈ જવા દે.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","મિસર દેશના દેવે મૂસા સાથે વાત કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","તેમણે કહ્યું, “હું યહોવા છું, હું તને કહું છું, તે બધું જ મિસરના રાજા ફારુનને કહેજે.” ");
INSERT INTO guj2009_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","અને મૂસાએ કહ્યું, “હું સ્પષ્ટ રીતે બોલતો નથી તો પછી ફારુન માંરી વાત શી રીતે સાંભળશે?” ");
INSERT INTO guj2009_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","યહોવાએ મૂસાને કહ્યું, “હું તારી સાથે રહીશ. હું તારો દેખાવ એવો કરીશ કે તું ફારુનની સામે એક મહાન રાજા લાગીશ અને તારો ભાઈ હારુન તારો પ્રવકતા બનશે. ");
INSERT INTO guj2009_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","હું તને જે આદેશ આપુ તે બધા તારે હારુનને કહેવા, હું જે કહું તે રાજા ફારુનને કહેશે, પછી ફારુન ઇસ્રાએલી લોકોને આ નગર છોડવા દેશે. ");
INSERT INTO guj2009_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","પણ હું ફારુનને હઠાગ્રહી બનાવી દઈશ, જેથી તું જે કંઈ કહીશ તેને તે માંનશે નહિ. એથી હું કોણ છું તે સાબિત કરવા હું મિસર દેશમાં અનેક ચમત્કારો કરીશ. પરંતુ તે છતાં પણ તે સાંભળશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","એટલા માંટે હું મિસર દેશ પર માંરો હાથ ઉગામીશ અને તેને કારમી સજા કરીને માંરાં સૈન્યોને, માંરી ઇસ્રાએલી પ્રજાને, મિસરની બહાર કાઢી લાવીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ત્યારે મિસરના લોકોને ખબર પડશે કે હું યહોવા છું, હું તેમની વિરુદ્ધ થઈ જઈશ અને તેઓ જાણશે કે હું યહોવા છું, જ્યારે હું માંરા લોકોને તેમના દેશમાંથી બહાર લઈ જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","મૂસાએ અને હારુને યહોવાએ જે આજ્ઞા કરી હતી તેનું પાલન કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","તે સમયે જ્યારે તેમણે ફારુન સાથે વાત કરી ત્યારે મૂસાની ઉમર 80 વર્ષની અને હારુનની ઉમર 83 વર્ષની હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","યહોવાએ મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“જ્યારે ફારુન તમને એમ કહે કે, તમાંરી શક્તિ સાબિત કરવા માંટે, ‘કોઈ ચમત્કાર બતાવો.’ ત્યારે તારે હારુનને કહેવું કે, તારી લાકડી લઈને ફારુનની આગળ જમીન પર નાખી દે એટલે એ સાપ બની જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","એટલા માંટે મૂસા અને હારુન મિસરના રાજા ફારુન પાસે ગયા, અને યહોવાની આજ્ઞા પ્રમાંણે તેમણે કર્યુ. હારુને ફારુન અને તેના અમલદારો સમક્ષ જમીન પર પોતાની લાકડી નાખી દીધી અને તે સાપ બની ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ત્યારે ફારુને જ્ઞાની પંડિતોને અને જાદુગરોને બોલાવ્યા. મિસરના જાદુગરોએ પણ તેમની મેલી વિધા વડે હારુનના જેવો ચમત્કાર કરી બતાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","તેઓએ તેમની લાકડીઓ જમીન પર ફેંકી અને તે સાપ બની ગઈ. પણ હારુનની લાકડી તેમની લાકડીઓને ગળી ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ફારુને તેમ છતાં હઠાગ્રહ છોડયો નહિ અને લોકોને જવાની ના પાડી. અને યહોવાએ કહ્યું હતું તેમ, મૂસા અને હારુનની વાત સાંભળી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","પછી યહોવાએ હારુન અને મૂસાને કહ્યું, “ફારુને હઠ પકડી છે, એ માંરી પ્રજાને જવા દેવાની ના પાડે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ફારુન સવારે નદી કિનારે આવશે. તમે નાઈલ નદીના કિનારે-કિનારે જાઓ. અને જે લાકડી સાપ થઈ ગઈ હતી, તે સાથે લઈને નદીકાંઠે તમે તેની રાહ જોતા ઊભા રહેજો. અને તેને કહેજો કે, ");
INSERT INTO guj2009_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","હિબ્રૂ લોકોના દેવ યહોવાએ મને તમાંરી પાસે મોકલ્યો છે અને કહેવડાવ્યું છે કે, ‘માંરા લોકોને માંરી ઉપાસના કરવા માંટે રણમાં જવા દે: જો અત્યાર સુધી તેં યહોવાની વાત કાને ધરી નથી.’ ");
INSERT INTO guj2009_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","હવે, યહોવા કહે છે કે, ‘હું યહોવા છું એની તમને આના પરથી ખબર પડી જશે. જો હું નાઈલ નદીના પાણી પર માંરા હાથમાંની લાકડી પછાડીશ એટલે તે લોહી થઈ જશે; ");
INSERT INTO guj2009_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ત્યારે નાઈલ નદીની માંછલીઓ મરી જશે. અને નદીમાંથી દુર્ગંધ આવશે અને મિસરવાસીઓને માંટે એનું પાણી પીવાલાયક પણ રહેશે નહિ.’” ");
INSERT INTO guj2009_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","પછી યહોવાએ મૂસાને કહ્યું, “તું હારુનને એમ કહે કે, તારી લાકડી લઈને મિસરનાં તમાંમ જળાશયો પર, નદીઓ ઉપર, નહેરો અને તળાવો ઉપર તારો હાથ ફેલાવ એટલે તે બધું જ પાણી લોહી બની જાય. અને સમગ્ર મિસર દેશમાં લાકડાના અને પથ્થરનાં બધાં વાસણોમાં પણ પાણીનું લોહી થઈ જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","એટલા માંટે મૂસા અને હારુને યહોવાની જેવી આજ્ઞા હતી તે પ્રમાંણે કર્યું. હારુને ફારુન અને તેના અમલદારોના દેખતા લાકડી ઉપાડીને નાઈલના પાણી પર પ્રહાર કર્યો. અને બધું જ પાણી લોહી થઈ ગયું. ");
INSERT INTO guj2009_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","નદીમાં બધી માંછલીઓ મરી ગઈ અને નદીમાંથી દુર્ગંધ આવવા લાગી. અને મિસરના લોકો માંટે નદીનું પાણી પીવા માંટે નકામું થઈ ગયું. સમગ્ર મિસરમાં લોહી થઈ ગયું. ");
INSERT INTO guj2009_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","મિસરના જાદુગરોએ પણ પોતાની મેલીવિદ્યાથી તે પ્રમાંણે કર્યું, તેથી ફારુને મૂસા અને હારુનની વાત કાને ન ધરી. યહોવાએ જેવું કહ્યું હતું બરાબર એ જ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","આ બાબતને ધ્યાનમાં લીધા વિનાજ ફારુન પોતાના મહેલમાં પાછો ફરી ગયો. મૂસા અને હારુને જે કાંઈ કર્યુ તેની તેણે ઉપેક્ષા કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","મિસરવાસીઓ નાઈલ નદીનું પાણી પી શકતા ન હતા તેથી તેમણે નદીની આજુબાજુ ચારેબાજુ કૂવાઓ ખોધ્યા અને વીરડા ગાળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","યહોવા દ્વારા નાઈલ નદી પર પ્રહાર કર્યાને પૂરા સાત દિવસ વીતી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","પછી યહોવાએ મૂસાને કહ્યું, “ફારુન પાસે જઈને તેને કહો કે, યહોવા આમ કહે છે: ‘માંરા લોકોને માંરી સેવા કરવા જવા દે. ");
INSERT INTO guj2009_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","પણ જો ફારુન તેમને જવા દેવાની ના પાડશે તો, હું મિસર દેશમાં દેડકાંઓનો ઉપદ્રવ મચાવીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","નાઈલ નદી દેડકાંઓથી ભરાઈ જશે. તે નદીમાંથી નીકળીને તમાંરાં ઘરોમાં, તમાંરા શયનખંડમાં, તમાંરા પલંગ ઉપર, તમાંરા અમલદારોના તથા તમાંરી પ્રજાનાં ઘરોમાં, તેમના રસોડામાં અને તેમના પાણીના ઘડાઓમાં ચઢી આવશે. ");
INSERT INTO guj2009_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","દેડકાંઓ તમાંરા ઉપર, તમાંરી પ્રજા ઉપર અને તમાંરા અમલદારો પર ફેલાશે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","પછી યહોવાએ મૂસાને કહ્યું, “હારુનને કહે કે, તે પોતાના હાથની લાકડીને નહેરો, નદીઓ અને સરોવરો ઉપર ફેલાવે, જેથી મિસર દેશ પર દેડકાંઓ ચઢી આવે.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ત્યારે હારુને મિસર દેશમાં જયાં જ્યાં જળાશયો હતા તેના ઉપર હાથ ઉઠાવ્યો અને દેડકાંઓ પાણીમાંથી બહાર આવીને સમગ્ર મિસર દેશમાં છવાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","મિસરના જાદુગરોએ પણ એવું જ કર્યું. તેઓ પણ મિસર દેશમાં દેડકાંઓ લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","પછી ફારુને મૂસા અને હારુનને બોલાવીને કહ્યું, “યહોવાને તમે પ્રાર્થના કરો કે તે મને અને માંરી પ્રજાને દેડકાંઓના ઉપદ્રવથી છોડાવે, તો પછી હું તમાંરા લોકોને યહોવાને યજ્ઞો અર્પવા જવા દઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","મૂસાએ ફારુનને કહ્યું, “તમે કૃપા કરીને મને કહો કે માંરે તમાંરા માંટે, તમાંરા અમલદારો માંટે અને તમાંરી પ્રજા માંટે યહોવાને પ્રાર્થના ક્યારે કરવી અને દેડકાં તમાંરી પાસેથી અને તમાંરા ઘરોમાંથી હઠી જાય અને માંત્ર નદીમાં જ રહે એવું કરવું.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ફારુને કહ્યું, “આવતી કાલે.” મૂસાએ કહ્યું, “તમે જેવું કહો છો તેવું જ થશે. જેથી તમને ખબર પડી જશે કે અમાંરા દેવ યહોવા સમાંન બીજું કોઈ નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","દેડકાં તમાંરી આગળથી અને તમાંરા ઘરોમાંથી અને તમાંરા અમલદારો તેમજ પ્રજા આગળથી ચાલ્યા જશે, અને માંત્ર નાઈલ નદીમાં જ રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","પછી મૂસા અને હારુન ફારુન પાસેથી વિદાય થયા. પછી મૂસાએ ફારુન સાથે નક્કી થયા પ્રમાંણે દેડકાંઓ વિષે યહોવાને વિનંતી કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","અને યહોવાએ મૂસાના કહ્યાં પ્રમાંણે કર્યુ. ઘરોમાંના, ઘરના ચોકમાંનાં તથા ખેતરોમાંનાં દેડકાંઓ મરી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","તેથી મરેલાં દેડકાંઓના ઢગલા ભેગા થયા. પરિણામે તેમનાં ફોહવાઈ જવાને કારણે સમગ્ર દેશમાં દુર્ગંધ પ્રસરી ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ફારુને જોયું કે, એ તો દેવનું કરેલું છે. અને દેશ દેડકાઓથી મુક્ત છે પણ તે પાછો હઠીલો થઈ ગયો. અને મૂસા અને હારુનની વાત સાંભળી નહિ. આ તો જેમ દેવે કહ્યું હતું તેમજ બન્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","પછી યહોવાએ મૂસાને કહ્યું, “હારુનને કહે કે, તે પોતાની લાકડી ઉઠાવીને જમીન પરની ધૂળ પર માંરે. અને આખા મિસર દેશમાં સર્વત્ર ધૂળની જૂ થઈ જાય.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","તેમણે તે પ્રમાંણે કર્યુ; અને હારુને લાકડી લઈને પોતાનો હાથ ઊચો કરીને જમીનની ધૂળ પર પ્રહાર કર્યો, એટલે સર્વત્ર ધૂળની જૂ થઈ ગઈ. અને તે જૂઓ માંણસો અને ઢોરઢાંખર પર છવાઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","મિસરના જાદુગરોએ પોતાના જંતરમંતરનો ઉપયોગ કર્યો અને એવું જ કરવાનો પ્રયત્ન કર્યો. પરંતુ જાદુગર ધૂળમાંથી જૂઓ બનાવી શકયા નહિ. અને મનુષ્યો તથા ઢોરઢાંખર પર જૂઓ છવાઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","એટલા માંટે જાદુગરોએ ફારુનને કહ્યું કે, દેવની શક્તિથી જ આ બન્યું છે. પરંતુ ફારુને તેમને સાંભળ્યા નહિ અને હઠીલો જ રહ્યો. જેવું યહોવાએ કહ્યું હતું બરાબર એ જ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","યહોવાએ મૂસાને કહ્યું, “સવારે વહેલો ઊઠીને ફારુન પાસે જા, ફારુન નદી કિનારે ફરવા નીકળે ત્યારે તેની રાહ જોઈને ત્યાં ઊભો રહેજે. અને તેને કહેજે કે, યહોવા એમ કહે છે કે, ‘માંરા લોકોને માંરી ઉપાસના કરવા જવા દે. ");
INSERT INTO guj2009_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","જો તું માંરા લોકોને નહિ જવા દે તો તારા ઘરમાં, તારા ઉપર, તથા તારા અમલદારો ઉપર તથા તારી પ્રજા ઉપર, ઘરોમાં માંખીઓ મોકલીશ. અને મિસરના લોકોનાં ઘરો માંખીઓથી ભરાઈ જશે; અને માંખીઓ આખી જમીન પર પણ હશે. ");
INSERT INTO guj2009_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","પણ તે દિવસે હું ઇસ્રાએલના લોકો સાથે આવો વ્યવહાર કરીશ નહિ, અને ગોશેન પ્રાંતમાં જયાં માંરા લોકો વસે છે ત્યાં કોઈ માંખી હશે નહિ, એટલે તને ખબર પડશે કે હું યહોવા આ દેશમાં છું. ");
INSERT INTO guj2009_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","આમ હું માંરી પ્રજા અને તારી પ્રજા વચ્ચે જુદો વર્તાવ રાખીશ; તે માંરો પરચો અને એંધાણ હશે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","અને પછી યહોવાએ એ પ્રમાંણે કર્યું. તેમના કહ્યા પ્રમાંણે ફારુનના મહેલમાં, અને તેના અમલદારોના ઘરોમાં તથા આખા મિસર દેશમાં માંખીઓનાં મોટાં મોટાં ઝુંડ ધસી આવ્યાં અને સમગ્ર દેશ માંખીઓથી પાયમાંલ થઈ રહ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","એટલે ફારુને મૂસા અને હારુનને બોલાવ્યા, ફારુને કહ્યું, “તમે લોકો તમાંરા દેવને આ દેશમાં યજ્ઞો અર્પો.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","પરંતુ મૂસાએ કહ્યું, “એ પ્રમાંણે કરવું એ યોગ્ય નથી, કારણ કે અમે અમાંરા દેવ યહોવાને પશુઓને યજ્ઞમાં અર્પીએ તેને મિસરના લોકો અપવિત્ર ગણે છે. એથી મિસરના લોકો જેને પવિત્ર ગણે છે તે પશુઓની આહુતિ આપીએ તો તેઓ અમને પથ્થરો માંરીને માંરી નહિ નાંખે? ");
INSERT INTO guj2009_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","અમને લોકોને ત્રણ દિવસ રણમાંથી પસાર થઈ જવા દો. અને અમાંરા દેવ યહોવાને યજ્ઞો અર્પવા દો. યહોવાએ અમને આમ કરવા કહેલ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","એટલે ફારુને કહ્યું, “હું તમને લોકોને તમાંરા દેવ યહોવાને યજ્ઞો અર્પવા માંટે રણમાં જવા દઈશ, પરંતુ ફક્ત તમાંરે બહુ દૂર જવું નહિ અને માંરા માંટે પણ પ્રાર્થના કરવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","મૂસાએ કહ્યું, “સારું, હું અહીંથી તમાંરી પાસેથી જઈને તરત જ યહોવાને પ્રાર્થના કરીશ કે, તમે અને તમાંરા અમલદારો અને તમાંરી પ્રજા આવતી કાલે સવારે માંખીઓના ત્રાસથી મુક્ત થાઓ તેમ કરે. પણ તમાંરે અમને મૂર્ખ નથી બનાવવાના. યહોવાને યજ્ઞો અર્પવા અમને રણમાં જવા દો. અમને રોકશો નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","એટલે મૂસા ફારુન પાસેથી વિદાય થઈને યહોવા પાસે ગયો અને પ્રાર્થના કરી, ");
INSERT INTO guj2009_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","અને યહોવાએ મૂસાએ જે કહ્યું તે પ્રમાંણે કર્યુ. અને ફારુન, તેના અમલદારો અને તેની પ્રજા માંખીઓના ત્રાસથી મુક્ત થયા. એક પણ માંખી ક્યાંય જોવા મળી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","પરંતુ ફારુન ફરી પાછો હઠાગ્રહી થઈ ગયો અને ઇસ્રાએલના લોકોને જવા ન દીધા. ");
INSERT INTO guj2009_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ત્યારે યહોવાઓ મૂસાને કહ્યું, “ફારુનની પાસે જા અને તેને કહે કે, હિબ્રૂઓના દેવ યહોવા એમ કહે છે કે, ‘માંરા લોકોને માંરી ઉપાસના કરવા દે.’ ");
INSERT INTO guj2009_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","હજુ પણ જો તું ના પાડશે અને તેમને રોકી રાખશે તો ધ્યાનથી સાંભળ, ");
INSERT INTO guj2009_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","હું તારાં ખેતરનાં ઢોરોમાં, ઘોડાઓમાં અને ગધેડાંઓમાં, ઊટોમાં અને ગાયબળદોમાં અને ઘેટાંબકરાંઓમાં મોટો ભયંકર રોગચાળો ફેલાવીશ અને તને સજા કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","પરંતુ યહોવા ઇસ્રાએલીઓનાં ઢોર અને મિસરનાં ઢોર વચ્ચે જુદો વ્યવહાર કરશે. જેથી ઇસ્રાએલીઓની માંલિકીનું કોઈ પણ ઢોર મરશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","અને યહોવાએ સમય નક્કી કરીને કહ્યું, ‘હું આવતી કાલે આ દેશમાં એનો અમલ કરીશ.’” ");
INSERT INTO guj2009_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","અને બીજે દિવસે સવારે મિસરમાં યહોવાએ એ પ્રમાંણે કર્યુ, મિસરવાસીઓનાં બધાં ઢોર મરી ગયાં પરંતુ ઇસ્રાએલીઓનું એક પણ ઢોર મર્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ફારુને પોતાના માંણસોને તપાસ કરવા મોકલ્યા કે ઇસ્રાએલના લોકોનું એકે ઢોર મર્યુ છે કે નહિ. તેને જણાવવામાં આવ્યુ કે ઇસ્રાએલીઓનું કોઈ પણ ઢોર મર્યુ નથી. ફારુને હઠાગ્રહ ચાલુ રાખ્યો, તેણે લોકોને જવા દીધા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","યહોવાએ મૂસા અને હારુનને કહ્યું, “તમાંરા હાથમાં ભઠ્ઠીમાંથી મુઠ્ઠીઓ ભરીને રાખ લો, અને ફારુનના દેખતા મૂસાએ હવામાં ફેંકવી. ");
INSERT INTO guj2009_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","પછી એ ઝીણી રજની જેમ આખા મિસર દેશમાં ફેલાઈ જશે. અને તેનાથી સમગ્ર મિસરના માંણસો અને ઢોરોને ગૂમડાં થશે અને ત ફાટીને ધારાં બની જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","એટલે મૂસા અને હારુને ભઠ્ઠીમાંથી રાખ લીધી. પછી ફારુનની આગળ ઊભા રહીને મૂસાએ આકાશ તરફ રાખ ફેંકી એટલે માંણસોને અને ઢોરોને ગૂમડાં થયાં, અને તે ફાટીને ધારાં પડી ગયાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","મિસરના જાદુગરો મૂસાને આવું કરતા રોકી શક્યા નહિ, કારણ કે જાદુગરોને તથા બધાજ મિસરના લોકોને ગૂમડાં ફૂટી નીકળ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","પરંતુ યહોવાએ ફારુનને હઠે ચડાવ્યો, અને કહ્યું હતું તે પ્રમાંણે ફારુને મૂસાની અને હારુનની વાત સાંભળી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","પછી યહોવાએ મૂસાને કહ્યું, “સવારમાં વહેલા ઊઠીને ફારુન પાસે ઊભો રહીને તેને કહેજે કે, હિબ્રૂઓના દેવ યહોવા એમ કહે છે કે, ‘માંરા લોકોને માંરી ઉપાસના કરવા જવા દે. ");
INSERT INTO guj2009_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","જો તું આમ નહિ કરે તો હું માંરી બધી શક્તિ તારા ઉપર, તારા અમલદારો ઉપર અને તારા લોકો ઉપર વાપરીશ. ત્યારે તને ખબર પડશે કે જગતમાં માંરા જેવો બીજો કોઈ દેવ નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","કારણ કે અત્યાર સુધીમાં મેં કયારની, તારા ઉપર અને તારી પ્રજા ઉપર રોગચાળો મોકલી, તને સજા કરી હોત તો તું ભૂમિ ઉપરથી નષ્ટ થઈ ગયો હોત. ");
INSERT INTO guj2009_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","પણ મેં તેને એટલા માંટે જીવતો રાખ્યો છે કે હું તને માંરી તાકાત બતાવી શકું. અને સમગ્ર પૃથ્વી પર માંરું નામ પ્રગટ થાય. ");
INSERT INTO guj2009_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","શું તું હજુ પણ માંરા લોકોની વિરુદ્ધ છે? તું માંરા લોકો સાથે ઘમંડી વર્તાવ રાખી તેમને જવા દેતો નથી? ");
INSERT INTO guj2009_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","યાદ રાખજે, આવતી કાલે આ જ સમયે હું એવો તો ભારે કરાનો વરસાદ વરસાવીશ કે મિસરમાં કદી પડ્યો નથી, મિસર દેશ બન્યો ત્યારથી તો નહિ જ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","એટલે અત્યારે જ માંણસ મોકલીને તારા ઢોરોને તથા ખેતરમાં જે કાંઈ હોય તે બધાંને સુરક્ષિત જગ્યાએ મંગાવી લેજે. કારણ જે કોઈ માંણસ કે ઢોર ખેતરમાં હશે, એને ઘરમાં રાખવામાં નહિ આવ્યું હોય તો તેના પર કરા વરસશે અને તેઓ મરણ પામશે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","પછી ફારુનના કેટલાક અમલદારોએ યહોવાના વચન સાંભળ્યાં. તેઓ ગભરાઈ ગયા. તેઓએ વહેલા વહેલા પોતાના ચાકરોને અને ઢોરોને ઘરમાં લાવી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","પણ જેમણે યહોવાના વચનને ધ્યાનમાં લીધાં નહિ તેમણે પોતાના ગુલામોને અને ઢોરોને ખેતરમાં જ રહેવા દીઘાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","પછી યહોવાએ મૂસાને કહ્યું, “તારા હાથ આકાશ તરફ લંબાવ, જેથી આખા મિસર દેશમાં માંણસો, ઢોરો અને ખેતરના બધા છોડ ઉપર કરા પડે.” ");
INSERT INTO guj2009_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","પછી મૂસાએ પોતાની લાકડી આકાશ ભણી ઊચી કરી એટલે યહોવાએ વીજળીના કડાકા સાથે જમીન પર કરા વરસાવ્યા અને કરા આખા મિસર દેશ પર પડયા. ");
INSERT INTO guj2009_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","કરા પડી રહ્યાં હતા અને કરાની સાથે વીજળી ઝબકારા માંરતી હતી. મિસર દેશ રાષ્ટ્ર બન્યો ત્યારથી આજસુધી કદી ન પડયો હોય એવો ભારે કરાનો વરસાદ આખા દેશમાં પડયો. ");
INSERT INTO guj2009_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","તોફાનને કારણે મિસરના ખેતરોમાં જે કાંઈ હતું તે બધાનો નાશ થઈ ગયો. કરાના કારણે આખા મિસર દેશમાં માંણસો, પશુઓ, તથા જે કાંઈ ખેતરમાં હતુ તે બધુ કરાના માંરથી નાશ પામ્યું. કરાએ ખેતરમાંના એકેએક છોડને તેમ જ એકેએક ઝાડને ભોંયભેગાં કરી દીઘાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ગોશેન પ્રાંતમાં જ્યાં ઇસ્રાએલીઓ રહેતા હતા ત્યાં જ ફક્ત કરા ન પડયા. ");
INSERT INTO guj2009_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","પછી ફારુને મૂસા અને હારુનને બોલાવડાવ્યા, અને કહ્યું, “આ વખતે મેં પાપ કર્યુ છે, યહોવા સાચા છે અને હું તથા માંરી પ્રજા ગુનેગાર છીએ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","તમે યહોવાને અરજ કરો, કારણ કે આ કરા અને કટકાથી અમે ઘરાઈ ગયા છીએ. હું તમને જવા દઈશ, હવે તમાંરે અહીં રોકાવું નહિ પડે.” ");
INSERT INTO guj2009_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","મૂસાએ ફારુનને કહ્યું, “જ્યારે હું નગર છોડીશ ત્યારે હું પ્રાર્થના માંટે યહોવાની આગળ માંરા હાથ લંબાવીશ. એટલે વીજળીના કડાકા બંધ થઈ જશે. અને કરા પણ નહિ પડે. આ પરથી તને ખબર પડશે કે આખા જગતનો માંલિક યહોવા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","પણ મને ખબર છે કે તમે અને તમાંરા અમલદારો હજુ પણ યહોવાથી ગભરાતા નથી અને તેમનું સન્માંન પણ કરતા નથી.” ");
INSERT INTO guj2009_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","શણ અને જવનો તો ઘાણ વળી ગયો હતો. કારણ કે જવને કંટી આવી હતી અને શણને ફૂલ બેઠાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","પરંતુ ઘઉ અને કઠોળ મોડાં થાય છે એટલે તે ખૂંદાઈ ગયાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","મૂસા ફારુનને છોડીને નગર બહાર આવ્યો. અને યહોવા સમક્ષ પોતાના હાથ લંબાવી પ્રાર્થના કરી. એટલે કડાકા અને કરા પડતા બંધ થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","પછી જ્યારે ફારુને જોયું કે વર્ષા, કરા અને કડાકા બંધ થઈ ગયા એટલે ફરીથી તેણે ખોટું કર્યુ. તે અને તેના અમલદારો ફરીથી હઠે ચડયા. ");
INSERT INTO guj2009_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ફારુને ઇસ્રાએલના લોકોને સ્વતંત્ર રીતે જવા દેવાની ના પાડી દીધી. યહોવાએ મૂસાને કહ્યું હતું બરાબર તે જ પ્રમાંણે થયું. ");
INSERT INTO guj2009_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","પછી યહોવાએ મૂસાને કહ્યું, “તું ફારુન પાસે જા. કારણ મેં તેને અને તેના અમલદારોને એટલા માંટે હઠાગ્રહી બનાવ્યા છે કે જેથી હું તેમને માંરા શક્તિશાળી ચમત્કાર બતાવી શકું. ");
INSERT INTO guj2009_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","અને તું તારા પુત્રને અને પૌત્રોને કહી શકે કે મેં આ મિસરના લોકોને કેવી સખત સજા આપી હતી, અને મેં તેમને શું ચમત્કાર બતાવ્યા હતા. આથી તમને ખબર પડશે કે હું જ યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","એટલા માંટે મૂસા અને હારુન ફારુન પાસે ગયા અને કહ્યું, “હિબ્રૂઓના દેવ યહોવા આ કહે છે; ‘તું કયાં સુધી માંરી આજ્ઞાનું પાલન કરવા ના કરીશ? માંરા લોકોને માંરી ઉપાસના કરવા જવા દે. ");
INSERT INTO guj2009_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ધ્યાન રાખ, જો તું માંરા લોકોને માંરી ઉપાસના કરવા જવા દેવાની ના પાડશે તો યાદ રાખજે આવતી કાલે હું તારા દેશમાં તીડો લાવીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","અને તે લોકો જમીનને એવી ઢાંકી દેશે કે કોઈ જમીન જોવા જ પામશે નહિ. અને કરાની વર્ષા પછી તારી પાસે જે કાંઈ વધ્યું છે, તે તેઓ ખાઈ જશે; તેઓ તારા ખેતરમાંનું એકેએક વૃક્ષ ખાઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","તેઓ તારા મહેલોને તથા તારા અમલદારોના અને તમાંમ મિસરવાસીઓનાં ઘરોને ભરી દેશે. તારા પિતૃઓએ મિસરમાં રહેવાનું શરુ કર્યુ ત્યારથી કદી ન જોયા હોય તેના કરતા વધારે તીડો હશે.’” ત્યારબાદ મૂસા ફારુન પાસેથી ચાલ્યો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ફારુનના અમલદારોએ તેને કહ્યું, “અમે ક્યાં સુધી આ લોકોની જાળમાં ફસાએલા રહીશું? એ લોકોને એમના દેવ યહોવાની ઉપાસના કરવા જવા દો. તમે એમને જવા નહિ દો તો, તમને ખબર પડે તે પહેલા, મિસરનો વિનાશ થઈ જશે!” ");
INSERT INTO guj2009_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","એટલે મૂસાને અને હારુનને ફારુન પાસે પાછા બોલાવવામાં આવ્યા. પછી ફારુને તેમને કહ્યું, “ભલે, તમે જાઓ અને તમાંરા દેવ યહોવાની ઉપાસના કરો, પણ તમે કોણ કોણ જશો?” ");
INSERT INTO guj2009_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","મૂસાએ જવાબ આપ્યો, “અમાંરા યુવાન અને વૃદ્ધ બધાંજ જશે; અને અમે અમાંરા પુત્રપુત્રીઓ તથા ઘેટાંબકરાં અને ઢોરને પણ લઈ જઈશું. અમે બધાં જ જઈશું, કારણ એ અમાંરા માંટે અમાંરા યહોવાનો ઉત્સવ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ફારુને તેમને કહ્યું, “હું તમને અને તમાંરાં સર્વ બાળબચ્ચાંને મિસરમાંથી જવા દઉ તે પહેલા દેવ ખરેખર તમાંરી સાથે હોવા જોઈયે. મને લાગે છે કે તમે કઈ ખરાબ વિચારી રહ્યાં છો. ");
INSERT INTO guj2009_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ના ભાઈ ના, જાઓ, એકલા પુરુષો જાઓ અને યહોવાની ઉપાસના કરો. એટલી જ તમાંરી માંગણી હતી. હવે તમાંરા બધાજ લોકો જઈ શકે નહિ.” પછી ફારુને મૂસા અને હારુનને જવા દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","પછી યહોવાએ મૂસાને કહ્યું, “મિસરની ભૂમિ પર તારો હાથ ફેલાવ એટલે મિસર ઉપર તીડો આવશે. તીડો મિસરની તમાંમ ભૂમિ પર પ્રસરી જશે અને કરાથી બચી ગયેલાં તમાંમ વૃક્ષો અને છોડોને ખાઈ જશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","મૂસાએ પોતાની લાકડીને મિસર દેશ પર ઉઠાવી અને યહોવાએ તે આખો દિવસ અને આખી રાત પૂર્વ તરફથી પવન ફૂંકાવ્યો, અને સવાર થતાં સુધીમાં તો એ તોફાની પૂર્વનો પવન તીડોના ટોળાં લઈ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","સમગ્ર મિસર પર તીડો ચડી આવ્યાં અને દેશભરમાં પ્રવેશી અને ભૂમિ પર બેસી ગયાં. આવાં તીડોનાં ટોળાં અગાઉ કદી આવ્યાં નહોતાં અને ભવિષ્યમાં કદાપિ આવશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","તીડોનાં ટોળે ટોળાં સમગ્ર ભૂમિ પર છવાઈ ગયા અને ધરતી કાળી કાળી થઈ ગઈ. કરામાંથી બચી ગયેલા મિસર દેશના તમાંમ છોડો અને વૃક્ષો ઉપરનાં બધાંજ ફળ તેઓ ખાઈ ગયાં. સમગ્ર મિસર દેશનાં લીલાં વૃક્ષો અને છોડો નામશેષ થઈ ગયા. કોઈ પણ છોડ પર એકે પાંદડું રહ્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ફારુને મૂસા અને હારુનને વહેલા બોલાવડાવ્યા, અને તેણે કહ્યું, “મેં તમાંરા દેવ અને તમાંરી વિરુધ્ધ પાપ કર્યુ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","આ વાર માંરો ગુનો માંફ કરો, અને તમાંરા દેવ યહોવાને પ્રાર્થના કરો અને તેમને અરજ કરો કે તે મને આ ‘મોત’ ના તીડો માંરામાંથી બહાર કાઢે.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","મૂસા ફારુનની પાસેથી વિદાય થયો અને તેણે યહોવાને પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","એટલે યહોવાએ પવનની દિશા બદલી નાંખી; અને પશ્ચિમમાંથી ભારે તોફાની પવન ફૂંકાવા લાગ્યો. અને તેણે તીડોને ઉપાડીને રાતા સમુદ્રમાં હાંકી કાઢયાં. સમગ્ર મિસરમાં એક પણ તીડ રહ્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","પરંતુ યહોવાએ ફારુનને વળી પાછો હઠાગ્રહી બનાવ્યો અને તેણે ઇસ્રાએલીઓને જવા ન દીધા. ");
INSERT INTO guj2009_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","પછી યહોવાએ મૂસાને કહ્યું, “તારા હાથોને આકાશ તરફ ફેલાવ. એટલે ગાઢ અંધકાર મિસર દેશને ઢાંકી દેશે, એ અંધકાર એટલો બધો ગાઢ હશે કે તમે તેને સ્પર્શ કરીને અનુભવી શકશો.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","એટલે મૂસાએ હવામાં આકાશ તરફ હાથ ઉગામ્યો અને પ્રગાઢ અંધકારે મિસર દેશને ઢાંકી દીધો. મિસરમાં ત્રણ દિવસ સુધી અંધકાર રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","કોઈ પણ વ્યક્તિ બીજા કોઈને જોઈ શક્તી ન હતી. અને ત્રણ દિવસ સુધી કોઈ પોતાની જગ્યાએથી ઊભું થઈ શક્યું નહિ, પરંતુ તે બધી જ જગ્યાઓ પર જ્યાં ઇસ્રાએલના લોકો રહેતા હતા ત્યાં પ્રકાશ હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ફારુને મૂસાને ફરી બોલાવ્યો અને કહ્યું, “જાઓ, અને યહોવાની ઉપાસના કરો. તમે તમાંરી સાથે તમાંરા બાળકોને પણ લઈ જઈ શકો છો. ફકત તમાંરાં ઘેટાંબકરાં અને ઢોરને પાછળ મૂક્તા જજો.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","મૂસા એ કહ્યું, “અમે અમાંરા ઘેટાંબકરાં અને ઢોર અમાંરી સાથે લઈ જઈશું એટલું જ નહિ પરંતુ જ્યારે અમે લોકો જઈશું ત્યારે તમે અમને યજ્ઞ માંટેના અર્પણો પણ આપશો અને અમે લોકો એ અર્પણોનો દેવ યહોવાની ઉપાસના માંટે ઉપયોગ કરીશું. ");
INSERT INTO guj2009_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","અમે લોકો અમાંરાં ઢોર અમાંરી સાથે અમાંરા દેવ યહોવાની ઉપાસના માંટે લઈ જઈશું. એક પણ ઢોરના પગની ખરી પાછળ રહેવી જોઈએ નહિ. અમાંરા ઢોરોમાંથી અમે અમાંરા દેવ યહોવાને યજ્ઞ ચઢાવવાના છીએ, અને જ્યાં સુધી અમે તે જગ્યાએ પહોંચીએ નહિ ત્યાં સુધી અમને કેવી રીતે ખબર પડે કે અમાંરે યહોવાને શું અર્પણ કરવાનું છે? તેથી આ બધી જ વસ્તુઓ તો જરૂર અમે અમાંરી સાથે લઈ જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","યહોવાએ ફારુનને પાછો હઠાગ્રહી બનાવ્યો, તેથી ફારુને તેમને જવા દેવા માંટે ના પાડી. ");
INSERT INTO guj2009_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","પછી ફારુને મૂસાને કહ્યું, “માંરી પાસેથી દૂર હઠ, હું નથી ઈચ્છતો કે તું ફરીવાર અહીં આવે. એમ છતાં જો તું મને મળવા આવીશ તો માંર્યો જઈશ, ખબરદાર! મને ફરી મોઢું બતાવ્યું તો! અને જો બતાવ્યું તો તે જ દિવસે મૂઓ જાણજે.” ");
INSERT INTO guj2009_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","પછી મૂસાએ ફારુનને કહ્યું, “તું જે કહે છે તે સાચું છે. હું ફરીથી તમને મળવા કદાપી આવીશ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ત્યારે યહોવાએ મૂસાને કહ્યું, “હજી ફારુન અને મિસરની વિરુદ્ધ હું એક વધારે આફત લાવીશ. ત્યાર પછી તે તમને લોકોને અહીંથી જવા દેશે; નિશ્ચે તે તમને બધાંને અહીંથી જવા માંટે અરજ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","તમે ઇસ્રાએલના લોકોને આ સંદેશો અવશ્ય આપજો; ‘પ્રત્યેક પુરુષ પોતાના પડોશી પાસે અને પ્રત્યેક સ્ત્રી પોતાની પડોશણ પાસે સોનાચાંદીના અલંકારો માંગી લે. અને ");
INSERT INTO guj2009_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","યહોવા મિસરવાસીઓના હૃદયમાં ઇસ્રાએલી લોકો માંટે સદભાવ પેદા કરશે. મિસરના અમલદારો અને લોકો મૂસાને બહુ મોટો માંનવ માંનવા લાગ્યા.’” ");
INSERT INTO guj2009_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","મૂસાએ લોકોને કહ્યું, “યહોવા એમ કહે છે કે, ‘આજે મધરાત્રે હું મિસરમાંથી પસાર થઈશ. ");
INSERT INTO guj2009_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","અને મિસરમાં પહેલા ખોળાનાં બધાંજ બાળકોનાં મૃત્યુ થશે. રાજગાદી ઉપર બેસનાર ફારુનના પ્રથમજનિત રાજકુમાંરથી માંડીને ઘંટીએ દળણાં દળનારી દાસીના પ્રથમજનિત સુધીનાં તમાંમ ઉપરાંત પશુઓનાં પણ બધાંજ પ્રથમજનિત બચ્ચાં પણ મૃત્યુ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","અને સમગ્ર મિસર દેશમાં ભારે રડારોળ થશે, તે પહેલાં કદી ન હતો એના કરતા વધારે ખરાબ હશે અને ભવિષ્યમાં કદી થશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","પરંતુ ઇસ્રાએલના કોઈ પણ મનુષ્યને કશી પણ ઈજા થશે નહિ. કૂતરું પણ તેમની સામે ભસશે નહિ, ઇસ્રાએલના કોઈ પણ માંણસ અથવા તેમના કોઈ પણ જાનવરોને ઈજા થશે નહિ. એના પરથી તમે જાણી શકશો કે યહોવા મિસરીઓ તથા ઇસ્રાએલ પુત્રો વચ્ચે ભેદ રાખે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","અને પછી તમાંરા આ બધાજ ચાકરો, મિસરવાસીઓ માંથા નમાંવીને માંરી પૂજા કરશે. તેઓ કહેશે કે, “ચાલ્યા જાઓ! તમાંરા બધાં લોકોને તમાંરી સાથે લઈ જાવ” અને પછી હું ક્રોધથી ફારુન પાસેથી નીકળી જઈશ.’” ");
INSERT INTO guj2009_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","પછી યહોવાએ મૂસાને કહ્યું, “ફારુને તમાંરી વાત સાંભળી નથી, કેમ? તેથી હું મિસર દેશમાં વધુ મહાન પરચા બતાવી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","અને એ જ કારણે મૂસાએ અને હારુને ફારુનના દેખતાં જ આ બધા ચમત્કારો કરી બતાવ્યા. અને યહોવાએ ફારુનને હઠાગ્રહી બનાવ્યો અને તેણે ઇસ્રાએલી લોકોને પોતાના દેશની બહાર જવા દીઘા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","મૂસા અને હારુન જ્યારે મિસરમાં હતા ત્યારે યહોવાએ તેમને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“તમાંરા લોકો માંટે આ મહિનો વર્ષનો પહેલો મહિનો ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ઇસ્રાએલના આખા સમાંજને આદેશ છે કે: આ મહિનાના દશમાં દિવસે પ્રત્યેક વ્યક્તિ પોતાના પરિવારના માંટે એક ઘેટાનુ બચ્ચું પ્રાપ્ત કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","અને જો પૂરતાં પ્રમાંણમાં પરિવારમાં એક હલવાનને ખાઈ શકે તેટલા માંણસો ના હોય તો પોતાના કેટલાક પડોશીઓને નિમંત્રણ આપવું. પ્રત્યેક વ્યક્તિને પુરતું ખાવા મળી રહે તેટલું હલવાનનું માંસ હોવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","તમે પસંદ કરેલ હલવાન ખોડ-ખાંપણ વગરનું એક વર્ષનું નરજાતિનું અને તે ઘેટા અથવા બકરામાંથી જ પસંદ કરવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","તમાંરે આ હલવાનને મહીનાના ચૌદમાં દિવસ સુધી સંભાળપૂર્વક રાખવું જોઈએ. તે દિવસે ઇસ્રાએલી સમાંજના તમાંમ લોકો સંધ્યાકાળે તેમનાં હલવાનનો વધ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","તમાંરે તે હલવાનોનું લોહી ભેગું કરવું જોઈએ. જે જે ઘરમાં એ ખાવાનું હોય તે તે ઘરની બંને બારસાખ ઉપર અને ઓતરંગ ઉપર છાંટવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“તે જ રાત્રે તમાંરે હલવાનના માંસને શેકી લેવું અને પછી બેખમીર રોટલી તથા કડવી ભાજી સાથે ખાવું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","અને એ માંસ કાચુ કે પાણીમાં બાફીને ન ખાવું. પણ પગ, માંથું, અને આંતરડા સાથે શેકીને ખાવું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","તે જ રાત્રે બધું જ માંસ ખાઈ લેવું જોઈએ. અને જો એમાંનું કંઈ સવાર સુધી રહે તો તે માંસને તમાંરે આગમાં બાળી મૂકવું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“અને તે તમાંરે આ રીતે જ ખાવું જોઈએ; તમાંરે યાત્રામાં જતા હોય તેવા કપડા પહેરવા, પગમાં પગરખાં પહેરીને, હાથમાં લાકડી લઈને, ઉતાવળે ઉતાવળે ખાવું, કેમકે આ દેવનુ દુર્લક્ષ છે-એ સમય જ્યારે દેવે પોતાનાં લોકોનું રક્ષણ કર્યુ અને તેમને વહેલા મિસરની બહાર લઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“આજે રાત્રે હું મિસરમાં થઈને જઈશ, અને આખા મિસર દેશનાં બધાં પ્રથમજનિત બાળકોને માંરી નાખીશ. પછી તે માંણસ હોય કે પશુ: મિસરના બધા દેવોને પણ હું સજા કરીશ. અને હું તેમને બતાવીશ કે હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","પરંતુ તમાંરા ઘર ઉપર લાગેલું એ લોહી એ તમે ત્યાં રહ્યાં છો તેની નિશાની બની રહેશે અને જ્યારે હું લોહી જોઈશ એટલે તમને છોડીને આગળ ચાલ્યો જઈશ. હું મિસરના લોકો માંટે વિનાશક કાર્યો કરીશ પણ તેમાંના કોઈ પણ ખરાબ રોગો તમાંરો નાશ નહિ કરે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“તેથી તમે લોકો આજની આ રાતનું સદા સ્મરણ કરશો, અને તમાંરે એને યહોવાના ઉત્સવ તરીકે ઊજવવો. અને નિત્ય નિયમાંનુસાર તમાંરા વંશજોએ યહોવાના માંનમાં તેની ઊજવણી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","આ પવિત્ર પર્વના સાત દિવસો સુધી તમાંરે બેખમીર રોટલી ખાવી. આ પવિત્ર પર્વના પહેલે દિવસે પોતપોતાના ઘરોમાંથી બધું જ ખમીર હઠાવી દેવું. અને જો કોઈ વ્યક્તિ આ સાત દિવસ સુધી ખમીરવાળી રોટલી ખાય તો તેને ઇસ્રાએલથી જુદો કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","આ પવિત્ર પર્વના પ્રથમ દિવસે અને સાતમાં અંતિમ દિવસે પવિત્ર ધર્મસભાઓ ભરવી. એ દિવસો દરમ્યાન બીજું કોઈ કામ કરવું નહિ. માંત્ર પ્રત્યેકને જમવા માંટે રસોઈ તૈયાર કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","તમાંરે બેખમીર રોટલીનું પર્વ ઉજવવું, કારણ કે એ જ દિવસે મેં તમાંરા લોકોને ટુકડીવાર મિસર દેશમાંથી બહાર કાઢયાં હતાં, તેથી એ દિવસે તમાંરા વંશજોએ કાનૂન પાળવો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","પ્રથમ મહિનાના ચૌદમાં દિવસની સાંજથી માંડીને તે માંસના એકવીસમાં દિવસની સાંજ સુધી તમાંરે બેખમીર રોટલી ખાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","સાત દિવસ સુધી તમાંરા ઘરમાં ખમીર હોવું જોઈએ નહિ. જો કોઈ વ્યક્તિ ખમીરવાળી વસ્તુ ખાશે તો તેનો ઇસ્રાએલી સમાંજમાંથી બહિષ્કાર કરવામાં આવશે. પછી તે દેશનો વતની હોય કે વિદેશનો હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ખમીરવાળી કોઈ પણ વસ્તુ તમાંરે ખાવી નહિ અને તમાંરાં બધાં જ ઘરોમાં તમાંરે બેખમીર રોટલી જ ખાવાની છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","તેથી મૂસાએ બધા જ વડીલોને એક જગ્યાએ બોલાવ્યા અને તેમને કહ્યું, “જાઓ, તમાંરા પરિવાર પ્રમાંણે હલવાન લઈ આવો અને એ પાસ્ખાના બલિને કાપો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","પછી પાંદડાનો ઝુફો લઈને રકતના કૂંડામાં બોળી ઓતરંગને અને બન્ને બારસાખ પર તે રકત લગાડજો, અને સવાર સુધી તમાંરામાંથી કોઈએ ઘરમાંથી બહાર નીકળવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","કારણ કે મિસરવાસીઓના બધાં પ્રથમ જનિતોનો સંહાર કરવા યહોવા દેશમાંથી પસાર થશે. અને તે સમયે તેઓ તમાંરા ઘરની બે બારસાખ પર અને ઓતરંગ પર રકત જોશે એટલે તે તમાંરું બારણું ટાળીને આગળ જશે અને મોતના દેવદૂતને તમાંરા ઘરમાં પ્રવેશીને કોઈનો સંહાર કરવા દેશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","તમે લોકો આ વિધિને સદા યાદ રાખજો. આ નિયમ તમાંરા પોતાને માંટે અને તમાંરા વંશજોને માંટે કાયમી નિયમ તરીકે સમજીને પાળજો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","અને યહોવાએ તમને જે દેશ આપવાનું વચન આપેલું છે તે દેશમાં તમે પહોંચો ત્યારે પણ તમાંરે આ નિયમનું પાલન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","જ્યારે તમને લોકોને તમાંરાં બાળકો પૂછશે, ‘આપણે આ ઉત્સવ શા માંટે ઉજવીએ છીએ?’ ");
INSERT INTO guj2009_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ત્યારે તમે લોકો કહેશો, ‘એ તો યહોવાના માંનમાં પાસ્ખા યજ્ઞ છે, કારણ કે જ્યારે યહોવાએ મિસર વાસીઓનો સંહાર કર્યો, ત્યારે આપણાં ઘરોને ટાળીને આગળ ચાલ્યા જઈને તેમણે આપણાં ઘરોને ઉગારી લીધાં હતા.’” ત્યારે ઇસ્રાએલીઓએ મસ્તક નમાંવી પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","યહોવાએ આ આદેશ મૂસાને અને હારુનને આપ્યો હતો. તેથી ઇસ્રાએલના લોકોએ યહોવાના આદેશ પ્રમાંણે કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","અને મધરાતે યહોવાએ મિસર દેશના બધાં જ પ્રથમજનિત બાળકોનો-ગાદી ઉપર બેસનારા ફારુનના પાટવીકુંવરથી માંડીને જેલમાં કેદ કરાયેલા કેદીઓના પ્રથમજનિત સુધીના તમાંમ ઉપરાંત ઢોરોનો પણ બધાં જ પ્રથમજનિત બચ્ચાંઓનો સંહાર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ફારુન અને તેના બધાં જ અમલદારો તથા બધા મિસરવાસીઓ મધરાતે જાગી ઊઠયા. સમગ્ર મિસરમાં ભયંકર આકંદ હતો. કારણ કે જેના ઘરમાં કોઈ પ્રથમજનિત પુત્રનું મરણ ન થયું હોય, એવું કોઈ ઘર મિસરમાં નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","એટલે તે રાત્રે ફારુને મૂસાને અને હારુનને બંનેને તેડાવી મંગાવ્યા અને કહ્યું, “તૈયાર થઈ જાઓ, અને માંરી પ્રજામાંથી ચાલ્યા જાઓ! તમે અને ઇસ્રાએલીઓ બંન્ને જાઓ, અને તમે જે કહ્યું હતું તે પ્રમાંણે યહોવાની ઉપાસના કરો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","અને તમાંરા કહ્યાં પ્રમાંણે તમે તમાંરાં ઘેટાંબકરાં અને ઢોરઢાંખર પણ લઈ જાઓ, માંરી વિદાય લો, અને મને આશિષ આપો.” ");
INSERT INTO guj2009_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","મિસરવાસીઓ, એ લોકોને જેમ બને તેમ વહેલા દેશ છોડી જવા દબાણ કરીને કહેવા લાગ્યા, “જો તમે લોકો નહિ જાઓ તો અમે બધા મરી જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ઇસ્રાએલના લોકો પાસે રોટલીના લોટમાં ખમીર નાખવા જેટલો પણ સમય ન હતો, તેથી તે લોકોએ આથો ચડયા વગરનો જ લોટ અને કથરોટ ચાદરમાં બાંધીને ખભે લઈ લીધું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","પછી ઇસ્રાએલના લોકોએ મૂસાના કહ્યા પ્રમાંણે કર્યુ, તેમણે પોતાના પડોશીઓ પાસેથી સોનાચાંદીના ઘરેણાં અને વસ્ત્રો માંગી લીધાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","યહોવાએ મિસરવાસીઓના હૃદયમાં એ લોકોના માંટે સદભાવ પેદા કર્યો હતો, તેથી તેઓએ ઇસ્રાએલીઓએ જે જે માંગ્યું તે તેમણે આપ્યું. આમ ઇસ્રાએલી લોકોને મિસરવાસીઓનું ધન પ્રાપ્ત થયું. ");
INSERT INTO guj2009_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ઇસ્રાએલના લોકો પગપાળા રામસેસથી સુક્કોથ જવા નીકળ્યા. લગભગ 6,00,000 પુરુષો અને સ્ત્રી બાળકો તો જુદાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","જુદી જુદી જાતના લોકો મોટી સંખ્યામાં તેમની સાથે આવ્યા. અને પુષ્કળ ઘેટાંબકરાં અને ઢોરઢાંખર પણ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","પરંતુ લોકો પાસે લોટમાં ખમીર નાખવાનો સમય ન હતો, તેથી મિસરથી જે લોટ લાવ્યા હતા તેની બેખમીર રોટલી બનાવી. આથો ચડયો નહોતો, કારણ કે તેમને મિસરમાંથી એકદમ હાંકી કાઢવામાં આવ્યા હતા; તેમને ભાથું તૈયાર કરવાનો પણ સમય મળ્યો નહોતો. ");
INSERT INTO guj2009_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ઇસ્રાએલના લોકો મિસરમાં 430 વર્ષ રહ્યાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","અને 430 વર્ષ પૂરાં થતાં જ તે જ દિવસે યહોવાના લોકોની બધી ટુકડીઓ મિસર દેશમાંથી ચાલી નીકળી. ");
INSERT INTO guj2009_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","તે આ એક બહુ જ ખાસ રાતે લોકોએ યાદ રાખવું કે દેવે શું કર્યું હતું. ઇસ્રાએલનાં સર્વ લોકો તે રાતને હમેશા યાદ રાખશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","પછી યહોવાએ મૂસાને અને હારુનને કહ્યું, “આ પાસ્ખાનો વિધિ છે. કોઈ પણ વિદેશી પાસ્ખાનું ખાઈ શકે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","પરંતુ જો કોઈ વ્યક્તિ પૈસા આપીને ચાકર ખરીદશે અને જો તેની સુન્નત કરશે તો તે ચાકર તેમાંથી ખાઈ શકશે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","કોઈ પરદેશી બહારથી આવીને તમાંરા દેશમાં વસ્યો હોય અથવા કોઈ માંણસ પગારથી કામ કરતો હોય તો તે માંણસ કે મજૂર પણ એ ખાઈ શકે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“દરેક પરિવારે પસાર થયેલું જમણ ઘરમાં ખાવું, જરાપણ માંસ તમાંરે બહાર લઈ જવાનું નથી. તમાંરે બલિનું એક હાડકુ સુધ્ધાં ભાગવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","સમગ્ર ઇસ્રાએલી સમુદાય આ ઉત્સવને અવશ્ય પાળે અને ઉજવે. ");
INSERT INTO guj2009_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","પણ કોઈ વિદેશી તમાંરી સાથે રહેતો હોય અને તે જો તમાંરી પાસે યહોવાના માંનમાં પાસ્ખાપર્વ પાળવા માંગતો હોય તો તે તેના પરિવારના બધા પુરુષોની સુન્નત કરાવ્યા પછી તે પર્વમાં જોડાઈ શકે; તેને દેશનો જ વતની માંનવો. પરંતુ સુન્નત કરાવ્યા વિનાના કોઈ પણ માંણસે તે ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","દેશમાં જન્મ ધારણ કરનાર વતનીઓ માંટે અને તમાંરી સાથે રહેતા વિદેશીઓ માંટે પણ નિયમો તો એક જ રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ઇસ્રાએલના બધા લોકોએ એમ જ કર્યુ, યહોવાએ મૂસાને અને હારુનને આજ્ઞા કરી હતી તે પ્રમાંણે તેમણે કર્યુ, ");
INSERT INTO guj2009_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","અને તે જ દિવસે યહોવા ઇસ્રાએલી લોકોને જૂથોમાં મિસર દેશમાંથી બહાર કાઢી લાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“પ્રત્યેક ઇસ્રાએલીઓએ તેમનાં બધાં જ પ્રથમજનિત બાળકો મને સમર્પિત કરવાં. હવે ઇસ્રાએલીઓમાં જે કોઈ પ્રથમ પ્રસવનું હોય, પછી તે માંણસ હોય કે પશુ હોય તે માંરું ગણાશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","મૂસાએ લોકોને કહ્યું, “તમે આ દિવસને યાદ રાખજો, જે દિવસે તમે મિસરમાંથી ગુલામીના દેશમાંથી બહાર નીકળ્યા છો, યહોવાએ પોતાના બાહુબળથી બહાર લાવ્યા છે, તેથી કોઈ પણ ખમીરવાળી વસ્તુ ખાશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","આજે તમે આબીબ મહિનામાં નીકળ્યાં છો. ");
INSERT INTO guj2009_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","અને જ્યારે યહોવા તમને કનાનીઓ, હિત્તીઓ, અમોરીઓ, હિવ્વીઓ, અને યબૂસીઓના દેશમાં લઈ જાય-તેણે તમાંરા પિતૃઓને જે દેશ તમને આપવાનું વચન આપ્યું હતું અને જયાં દૂધ અને મધની રેલછેલ છે, ત્યાં લઈ જાય, ત્યારે તમાંરે ઉપાસના આ માંસમાં કરવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“સાત દિવસ સુધી તમે ખમીર વગરની રોટલી ખાજો. સાતમે દિવસે એક મોટો ભોજન સમાંરંભ થશે, એ ઉત્સવ યહોવાના સન્માંનમાં યોજાશે. ");
INSERT INTO guj2009_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","તેથી સાત દિવસ સુધી તમાંરે ખમીર વગરની જ રોટલી ખાવી. તમાંરા આખા પ્રદેશમાં ક્યાંય પણ ખમીરવાળી રોટલી બિલકુલ હોવી જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","તે દિવસે તમાંરે તમાંરાં બાળકોને કહેવું કે, ‘અને મિસરમાંથી બહાર લાવ્યા ત્યારે યહોવાએ અમાંરા માંટે જે કર્યુ હતું તે માંટે અમે આ ઉત્સવ ઉજવી રહ્યાં છીએ.’ ");
INSERT INTO guj2009_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“અને આ ઉત્સવ તમાંરા હાથ પરના એંધાણી અને તમાંરા કપાળ પરના સ્મરણચિહ્ન જેવા બનીને રહેશે, તે તમાંરી આંખો સામે એક ચિહ્ન તરીકે રહેશે, આ પર્વ તમને યહોવાનો ઉપદેશ યાદ રખાવશે. તે તમને યાદ રખાવશે કે યહોવા તેમની મહાન શક્તિથી તમને મિસરમાંથી બહાર લઈ આવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","એટલા માંટે તમાંરે આ ઉત્સવ દર વર્ષે નિયત સમયે યાદ કરીને પાળવો. ");
INSERT INTO guj2009_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“યહોવા તમને અને તમાંરા વડવાઓને વચન આપ્યા પ્રમાંણે તમને કનાનીઓના દેશમાં લઈ જશે અને દેવ તે દેશ તમને તમાંરા પિતૃઓને આપેલ વચન મુજબ આપશે. ");
INSERT INTO guj2009_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","જ્યારે તમને દેવ આ પ્રદેશ આપે ત્યાર બાદ તમે બધા તમાંરા પ્રથમજનિત પુત્રને યહોવાને સમર્પિત કરવાનું યાદ રાખજો. અને તમાંરાં પશુઓનાં પ્રથમ વેતરનાં બધાં નર બચ્ચાઓ યહોવાને સમર્પિત થવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","પ્રત્યેક ગધેડાંનું પ્રથમ બચ્ચુ તેની જગ્યામાં એક હલવાન અર્પણ કરીને, યહોવા પાસેથી પાછું મેળવી શકાય છે. તમે લોકો જો ન છોડાવો તો તમાંરે તેની ડોકી ભાંગી નાખવી. તે ભોગ બનશે. તમાંરે પ્રત્યેક પ્રથમ જન્મેલો નર સંતાન દેવ પાસેથી પાછો ખરીદવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ભવિષ્યમાં તમાંરાં બાળકો કદાચ પૂછશે કે, ‘આનો અર્થ શો? તમે આ કેમ કરો છો?’ ત્યારે તમાંરે કહેવું કે, ‘પોતાના બાહુબળથી યહોવા અમને મિસરમાંથી ગુલામીના દેશમાંથી બહાર કાઢી લાવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ફારુન હઠે ચડયો હતો, તેથી તેણે અમને બહાર જવા દેવાની ના પાડી, ત્યારે યહોવાએ મિસર દેશનાં બધાં પ્રથમ જન્મેલાં સંતાનોને, માંણસનાં અને ઢોરનાં બંનેનાં પહેલાં સંતાનોને માંરી નાંખ્યાં હતાં, તેથી અમે પ્રથમજનિત બધાં નર પશુઓ યહોવાને અર્પણ કરીએ છીએ, પણ અમાંરા પુત્રોમાંના અર્પણ કરેલા સર્વ પ્રથમજનિતોને અમે નાણાં આપીને છોડાવીએ છીએ.’ ");
INSERT INTO guj2009_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","અને એ ઉત્સવ તમાંરા હાથ પર ચિહનરૂપ તથા તમાંરી આંખોની વચ્ચે કપાળ પર ચાંદરૂપ બની રહેશે; કારણ કે યહોવા આપણને પોતાના બાહુબળથી મિસરની બહાર લઈ આવ્યા હતા એની એ સ્મૃતિ બની રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","જ્યારે ફારુને લોકોને જવા દીઘા ત્યારે એમ બન્યું કે યહોવા તેમને પલિસ્તીઓના દેશમાં થઈને જવાનો રસ્તો ટૂંકો હોવા છતાં તે રસ્તે તેમને લઈ ગયા નહિ. કારણ કે યહોવાએ વિચાર્યુ કે, “જો યુદ્ધ થાય તો કદાચ લોકો પોતાનો વિચાર બદલી પાછા મિસર ચાલ્યા જાય.” ");
INSERT INTO guj2009_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","એટલે યહોવા તેમને બીજા રસ્તેથી લઈ ગયા. રેતીના રણપ્રદેશને રસ્તે રાતા સમુદ્ર તરફ દેવ તેમને લઈ ગયા. મિસર છોડ્યું ત્યારે ઇસ્રાએલ પુત્રો શસ્ત્રસજજ હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","મૂસાએ યૂસફનાં હાડકાં સાથે લઈ લીધાં હતાં. યૂસફે ઇસ્રાએલ પુત્રોની પાસે એના માંટે આ કરવા સમ લેવડાવ્યા એમ કહેતા, “યહોવા જરૂર તમાંરી મદદ કરવા આવશે, તે સમયે તમે માંરાં હાડકા અહીંથી લઈ જજો.” ");
INSERT INTO guj2009_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","પછી ઇસ્રાએલી લોકોએ સુક્કોથ નગર છોડયું અને રણની સરહદ પર એથામમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","તેઓને દિવસે રસ્તો બતાવવા માંટે યહોવા વાદળના થાંભલા રૂપે આગળ આગળ ચાલતા તેમજ રાત્રે તેમને પ્રકાશ મળે તેથી અગ્નિસ્તંભરૂપે ચાલતા. જેથી તેઓ સતત રાતદિવસ યાત્રા કરી શકતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","એક ઊંચા વાદળના સ્તંભરૂપે દિવસે અને અગ્નિસ્તંભ તરીકે રાત્રે સતત યહોવા તેમની સાથે રહ્યાં. તેમની આગળથી જરા પણ ખસ્યા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“તમે ઇસ્રાએલના લોકોને કહો કે, પાછા ફરીને પીહાહીરોથની આગળ, મિગ્દોલ અને લાલસમુદ્રની વચ્ચે બાલ-સફોનની આગળ મુકામ કરે, અને તમાંરે એ જગ્યાની બરાબર સામે સમુદ્રને કિનારે મુકામ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ફારુન વિચારશે કે, ઇસ્રાએલીઓ રણપ્રદેશમાં ભૂલા પડી ગયા છે અને રણ એમને ઘેરી વળ્યું છે. ");
INSERT INTO guj2009_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","હું ફારુનને હઠે ચઢાવીશ જેથી તે તમાંરો પીછો કરશે અને તેના લશ્કરનો પરાજય કરીને હું માંરો મહિમાં વધારીશ. ત્યારે મિસરવાસીઓ જાણશે કે, હું યહોવા છું.” અને ઇસ્રાએલીઓએ એ મુજબ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","જ્યારે ફારુનને ખબર આપવામાં આવી કે, ઇસ્રાએલના લોકો ભાગી ગયા છે. ત્યારે તેનું અને તેના અમલદારોનું વલણ બદલાઈ ગયું. તેમણે કહ્યું આપણે શું કર્યુ, “ઇસ્રાએલીઓને આપણે જવા કેમ દીધાં? આપણે આપણા ચાકરોને ગુમાંવ્યા છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","એટલે ફારુને પોતાનો રથ તૈયાર કર્યો અને પોતાનું લશ્કર ભેગું કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ફારુને પોતાના લોકોમાંથી 600 સૌથી શ્રેષ્ઠ સેનાનીઓને અને તેના બધાં રથો તેની સાથે લીધા. પ્રત્યેક રથમાં એક અમલદાર હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","અને યહોવાએ મિસરના રાજા ફારુનને હિંમતવાન બનાવ્યો, તેથી તે ઇસ્રાએલી લોકોની પાછળ પડ્યો જે પોતાના હાથ ઉચા કરી નીકળી રહ્યાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","મિસરના લશ્કરમાં અસંખ્ય ઘોડા, સૈનિકો અને રથો હતા. તે બધાએ એટલે કે ઘોડેસવારોએ તથા રથ સવારોએ તથા સૈનિકોએ ઇસ્રાએલીઓનો પીછો પકડયો. અને તેઓ બાલસફોનની આગળ પીહાહીરોથની પાસે સમુદ્ર કિનારે પડાવ નાખીને રહ્યા હતા ત્યાં તેમને પકડી પાડ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","જે સમયે ફારુન તેમની નજીક આવી પહોંચ્યો, તે સમયે ઇસ્રાએલીઓએ નજર કરીને જોયું તો ખબર પડી કે તેમની પાછળ મિસરીઓ પડ્યા છે! ત્યારે તેઓ ખૂબ ભયભીત થયા અને સહાય માંટે યહોવાને પોકાર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","તેમણે મૂસાને કહ્યું, “તમે અમને મિસરમાંથી બહાર શા માંટે લાવ્યા? શું મિસરમાં કબરો નથી? તમે અમને આ રણપ્રદેશમાં મરવા શા માંટે લાવ્યા? અમે લોકો મિસરમાં શાંતિપૂર્વક મૃત્યુ પામત, મિસરમાં ઘણી કબરો હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","અમે લોકોએ મિસરમાં જ તમને નહોતું કહ્યું કે, ‘અમને લોકોને અમે જેમ છીએ તેમ રહેવા દો, મિસરવાસીઓની સેવા કરવા દો?’ આ રણપ્રદેશમાં મરવું તેના કરતાં મિસરવાસીઓની ગુલામી કરવી વધારે સારી છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","પરંતુ મૂસાએ લોકોને ઉત્તર આપ્યો, “ગભરાશો નહિ, ભાગો નહિ, મક્કમ રહો, ને થોડી વાર ઊભા રહો અને જુઓ કે આજે યહોવા તમાંરા લોકોનો શી રીતે ઉદ્ધાર કરે છે! આજ પછી તમે આ મિસરવાસીઓને ફરી કયારેય જોશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","તમાંરે લોકોએ શાંત રહેવા સિવાય બીજું કાંઈ કરવાનું નથી. યહોવા તમાંરા માંટે લડતા રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","પછી યહોવાએ મૂસાને કહ્યું, “તું મને શા માંટે પોકાર કરે છે? ઇસ્રાએલના લોકોને આગળ વધવા માંટે આજ્ઞા કર. ");
INSERT INTO guj2009_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","તું તારી લાકડીને રાતા સમુદ્ર ઉપર ઉઠાવી, હાથ લાંબો કર. સમુદ્રના બે ભાગ થઈ જશે. જેથી ઇસ્રાએલના લોકો સૂકી જમીન પર થઈને સમુદ્ર પાર કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","પછી હું મિસરવાસીઓને હિંમતવાન બનાવીશ એટલે તેઓ તમને સમુદ્રમાં હાકી કાઢશે. અને ફારુન તથા તેની આખી સેના, તેના રથો અને તેના ઘોડેસવારોને હરાવીશ અને તેઓ મને માંન આપે તેમ કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","એટલે મિસરવાસીઓને ખબર પડશે કે હું યહોવા છું. અને જ્યારે હું ફારુન, તેના ઘોડેસવારો અને રથપતિઓને હરાવીશ ત્યારે તેઓ માંરું સન્માંન કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","પછી ઇસ્રાએલી લોકોના સૈન્યની આગળ ચાલતો યહોવાનો દૂત ત્યાંથી ખસીને તેની પાછળ ચાલ્યો ગયો, તેથી મેધસ્તંભ તેમની આગળથી ખસીને તેમની પાછળ ઊભો રહ્યો; ");
INSERT INTO guj2009_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","આ રીતે વાદળા મિસરીઓના સૈન્ય અને ઇસ્રાએલીઓના સૈન્યની વચ્ચે આવી ઉભા રહ્યાં. પણ ઇસ્રાએલી લોકો માંટે પ્રકાશ હતો. એટલે આખી રાત મિસરની સેના અંધકારને કારણે ઇસ્રાએલીઓ પાસે આવી ન શકી. ");
INSERT INTO guj2009_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","મૂસાએ પોતાનો હાથ લાલ સમુદ્ર ઉપર લંબાવ્યો, એટલે યહોવાએ આખી રાત પૂર્વ તરફથી ભારે પવન ફૂંકાવીને સમુદ્રને પાછો હઠાવ્યો, તેથી તેના પાણીના બે ભાગ પડી ગયા. અને સમુદ્રની જગ્યાએ સૂકી જમીન બનાવી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ઇસ્રાએલના લોકો સૂકી જમીન પર ચાલીને સમુદ્રમાંથી પાર ગયા. ઇસ્રાએલીઓની ડાબી અને જમણી બાજુએ પાણીની ભીત બની ગઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","અને મિસરીઓ તેમની પાછળ પડયા. ફારુનના બધા જ રથો, ઘોડાઓ અને ઘોડેસવારો તેમની પાછળ તેઓ સમુદ્રની વચ્ચે પહોંચી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","પછી પ્રભાતના પ્રથમ પહોરમાં વાદળ અને અગ્નિના સ્તંભમાંથી યહોવાએ મિસરીઓના સૈન્ય પર દૃષ્ટિપાત કરીને તેમના પર હુમલો કરી તેમનો પરાજય કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","યહોવાએ તેમના રથનાં પૈડાં જમીનમાં એવા ખુંપાવી દીધાં કે માંડ માંડ ફરતાં હતા. આથી તેઓ બૂમ પાડવા લાગ્યા, “આ તો યહોવા ઇસ્રાએલીઓને પક્ષે આપણી સામે લડી રહ્યાં છે. ચાલો, આપણે પાછા ફરીએ.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","પછી યહોવાએ મૂસાને કહ્યું, “હવે તું તારો હાથ સમુદ્ર ઉપર લંબાવ. જેથી મિસરવાસીઓ પર, તેમના રથો પર અને તેમના ઘોડેસવારો પર પાછાં પાણી ફરી વળે.” ");
INSERT INTO guj2009_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","એટલે દિવસ બરાબર શરૂ થાય તે પહેલાં મૂસાએ સમુદ્ર ઉપર હાથ લાંબો કર્યો અને સવાર થતાં જ સમુદ્ર પહેલાં જેવો હતો તેવો પાછો થઈ ગયો. મિસરવાસીઓએ સમુદ્રમાં નાસભાગ કરવા માંડી અને યહોવાએ સમુદ્રમાં વચ્ચોવચ્ચ તેમનો ઘાણ કાઢી નાખ્યો, સૌને ડુબાડી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","સમુદ્રના પાણીએ પાછાં વળીને, રથોને, ઘોડેસવારોને અને ઇસ્રાએલીઓનો પીછો પકડી સમુદ્રમાં ઘસી ગયેલા ફારુનના સમગ્ર સૈન્યને ડુબાડી દીધું. તેઓમાંથી એક પણ બચી શકયો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","પરંતુ ઇસ્રાએલના લોકો સમુદ્રની વચ્ચેથી સૂકી જમીન પર થઈને ચાલ્યા ગયા હતા. અને પાણીની ભીંત તેમની ડાબી અને જમણી બાજુએ થઈ ગઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","આ રીતે તે દિવસે યહોવાએ ઇસ્રાએલીઓને મિસરીઓના હાથમાંથી બચાવી લીધા. અને ઇસ્રાએલીઓએ મિસરીઓને સમુદ્ર કિનારે મૃત હાલતમાં પડેલા જોયા. ");
INSERT INTO guj2009_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","અને યહોવાએ મિસરીઓ વિરુધ્ધ જે પરાક્રમ કર્યું હતું તે જોઈને તેઓ ગભરાઈ ગયા અને યહોવા પર અને તેના સેવક મૂસા પર તેમને વિશ્વાસ બેઠો. ");
INSERT INTO guj2009_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","પછી મૂસાએ અને ઇસ્રાએલના લોકોએ યહોવાના માંનમાં આ ગીત ગાયું: “હું યહોવાના માંનમાં ગાયન કરીશ, એણે મહાન વિજય પ્રાપ્ત કર્યો! સાગરની અંદર કઈક અશ્વોના અસવારને ડુબાડયાં, ");
INSERT INTO guj2009_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","દેવ માંરું સાર્મથ્ય છે; મને જેણે ઉગાર્યો, હું આ ગીતમાં એની સ્તુતિ કરું. એ જ માંરો દેવ છે અને હું એના ગુણગાન ગાઉ. તે માંરા પિતાનો દેવ છે. હું સન્માંન કરું છું. હું એનાં યશગાન ગાઉં. ");
INSERT INTO guj2009_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","યહોવા તો યોદ્ધા છે, જેનું યહોવા નામ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ફારુનનાં રથો અને સૈન્ય, જેણે લાલ સમુદ્રમાં ફેંકી દીધાં; ફારુનના વીર સરદારને સમુદ્રમાં ડુબાડી દીઘા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","પથ્થરની જેમ સાગરની નીચે પહોચ્યા, સાગરમાં જળનિધિઓ ઉપર ફરી વળ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“યહોવા! તમાંરો જમણો હાથ, પરાક્રમે મહિમાંવાન છે. હે યહોવા! તમાંરા જમણા હાથે શત્રુઓને છિન્ન ભિન્ન કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","તારી શ્રેષ્ઠતાના માંહાત્મ્યથી, જે તારી સામે થયા તેનો નાશ કર્યો. તારા ક્રોધે તેમને ઘાસના પૂળાની જેમ બાળી નાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","યહોવા, તેં ક્રોધથી ફૂકેલા પવનથી ઊભા ઢગલા થઈ ગયા સાગરજળ. મોજાઓ જે હતા ઉછળતા અને વહેતા ઊભા અધવચ ભીત થઈ; સાગરની જેમ પાતાળની વચ્ચે; તે સમયે સાગરજળ ભેગા થયા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“શત્રુ મનમાં બબડે છે, ‘હું પકડીશ પાછળ પડી, અને હું તેમનું ધન સધળુ લઈશ. હું બધું જ માંરી તરવાર વડે લઈ જઈશ. હું માંરે માંટે બધુંજ રાખીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","પરંતુ યહોવા! એક માંત્ર પ્રબળ ફૂંક લગાવીને તમે મધદરિયે, સમાંવી લીઘા. પ્રચંડ મહા જળરાશિમાં, સૌ સીસાની જેમ ડુબ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“હે યહોવા, કોણ છે તમાંરા જેવો બીજો દેવ? છે કોણ તમાંરા જેવું પરમપવિત્ર મહિમાંવાન? તમાંરા જેવા ચમત્કાર કોણ કરી શકે? સ્તોત્રોમાં ભયજનક પરાક્રમ કરનાર, કોણ છે? ");
INSERT INTO guj2009_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","પૃથ્વી તેઓને તત્કાળ ગળી ગઈ, જયાં તેં કેવળ જમણો હાથ ઊંચો કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","યહોવા, તમે તમાંરા લોકોને છોડાવ્યા, તમાંરા પ્રેમ અને કરુણાથી તમે એમને તમાંરા બાહુબળના પરાક્રમે; તમાંરા પવિત્ર રોચક ધામમાં લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“પ્રજા આ સાંભળી કંપીને ગભરાઈ, સહુ પલેશેથવાસીઓ ભયથી ગભરાય છે. ");
INSERT INTO guj2009_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","અદોમના સરદારો તે સમયે ભયભીત થયા, મોઆબના શક્તિશાળી અને પરાક્રમી પુરુષો ધ્રૂજે છે; એ બધાં કનાનવાસીઓ પણ હિંમત હારે; માંથાં પર ભયના ઓળા ભારે ઊતરતાં જોઈ, ");
INSERT INTO guj2009_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","તેઓ ઉપર ભય અને ત્રાસ આવી પડયા, તમાંરા બાહુબળે સ્તબ્ધ બની પથ્થર જેવા થયા, અને તું જ છોડાવી લાવ્યો, ઊભા એટલામાં; એ ‘યહોવા’ સમૂહમાં તારી પ્રજા ચાલી જાય. ");
INSERT INTO guj2009_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","જયાં તમાંરો આવાસ છે, લોકોને એ પર્વત પર તમાંરી પાસે લઈ જાય; જે જગ્યા તમે સિંહાસન માંટે તૈયાર કરી ત્યાં તેમને વસવાટ કરવા દેશો. હે માંલિક, ત્યાં તમે મંદિર તમાંરું બાંધશો! ");
INSERT INTO guj2009_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“યહોવા, તમાંરું રાજ સદાસર્વકાળ અમર તપશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","હા, ખરેખર આમ બન્યું, જ્યારે ફારુનના ઘોડા, રથો અને ઘોડેસવારોએ સમુદ્રમાં સાથે પ્રવેશ કર્યો, ત્યારે યહોવાએ તેમના પર સમુદ્રના પાણી પાછાં વાળીને તેઓ પર ફેરવી વાળ્યાં; પરંતુ ઇસ્રાએલના લોકો સમુદ્ર મધ્યે થઈને સૂકી જમીન પર ચાલ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","પછી હારુનની બહેન મરિયમ પ્રબોધિકાએ ખંજરી હાથમાં લીધી અને તમાંમ સ્ત્રીઓ તેમની પાછળ પાછળ ખંજરીઓ લઈને નાચવા લાગી. મરિયમે અને સ્ત્રીઓએ નાચગાન શરૂ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","મરિયમ તેમને ગવડાવતી હતી: “આપો આપો યહોવાને માંન, ગાઓ યહોવાના મહિમાં-ગાન, એનો વિજય છે કેવો મહાન! એની ફતેહ છે મહિમાંવાન, ડુબાડયા સમુદ્રને પેટાળ, એનાં ઘોડોને અસવાર.” ");
INSERT INTO guj2009_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","પછી મૂસા ઇસ્રાએલના લોકોને રાતા સમુદ્રથી આગળ લઈ ગયો. અને તેઓ ત્યાંથી નીકળીને શૂરના અરણ્યમાં ગયા; તેઓ ત્રણ દિવસ અરણ્યમાં ચાલ્યા. છતાં પાણી ન મળ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","પછી તેઓ માંરાહ નામની જગ્યાએ આવી પહોંચ્યા પણ ત્યાંના પાણી પણ ના પી શક્યા, કારણ કે તે કડવા હતા. એને લીધે આ જગ્યાનું નામ માંરાહ પડયું. ");
INSERT INTO guj2009_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","પછી તે બધા લોકોએ મૂસાની વિરુદ્ધ બબડાટ કરતાં કહ્યું કે, “આપણે પીશું શું?” ");
INSERT INTO guj2009_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","એટલે મૂસાએ યહોવાને પોકાર કર્યો એટલે યહોવાએ તેને ઝાડનું એક થડ બતાવ્યું. પછી મૂસાએ તે પાણીમાં નાખ્યું અને પાણી મીઠું થઈ ગયું. ત્યાં દેવે લોકોને ન્યાય કર્યો તથા એક વિધિ તથા એક નિયમ ઠરાવ્યો. અને ત્યાંજ તેમની કસોટી કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","યહોવાએ કહ્યું, “તમે લોકો તમાંરા દેવની યહોવાની વાણી ધ્યાનપૂર્વક સાંભળશો, અને તેની નજરમાં જે સારું હોય તે કરશો. અને તેની આજ્ઞાઓ માંથે ચઢાવશો. અને માંરા બધા કાનૂનોનું પાલન કરશો તો મેં મિસરીઓ ઉપર જે રોગો મોકલ્યા હતા તેમાંનો કોઈ તમાંરા ઉપર મોકલીશ નહિ. કારણ કે હું યહોવા તમાંરા રોગોનો કરનાર છું. તમને સાજા હરનાર છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","પછી તે લોકો એલીમ આવી પહોંચ્યા, ત્યાં બાર પાણીના ઝરા હતા અને 70 ખજૂરીઓ ઝાડ હતાં, તેથી પાણીની નજીક તેઓએ પડાવ નાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ઇસ્રાએલીઓના સમગ્ર સમાંજે એલીમથી યાત્રાનો આરંભ કર્યો અને તેઓ એલીમ અને સિનાઈની વચ્ચે આવેલા સીનના રણપ્રદેશમાં આવ્યા. મિસરમાંથી નીકળ્યા પછી બીજા મહિનાનો તે 15 મો દિવસ હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","તે પછી ઇસ્રાએલના બધા લોકોએ મૂસા અને હારુનની વિરુદ્ધ ફરીથી ફરિયાદ કરવાની શરૂઆત કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","તે લોકોએ મૂસા અને હારુનને કહ્યું, “કઈ નહિ તો આપણે માંસથી ભરેલા વાસણ પાસે પેટ ભરાય ત્યાં સુધી ખાતા બેઠા હતાં. જો યહોવાએ અમને મિસરમાં માંરી નાખ્યા હોત તો સારું થાત. તમે તો સમગ્ર સમાંજને ભૂખે માંરી નાખવા આ રણમાં લાવ્યા છો.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ત્યારે યહોવાએ મૂસાને કહ્યું, “હું આકાશમાંથી તમાંરા લોકો માંટે અનાજનો વરસાદ વરસાવીશ. અને આ બધા લોકોએ પ્રતિદિન બહાર નીકળીને તે દિવસ પૂરતું અનાજ વીણી લાવવું. જેને કારણે હું તેમની પરીક્ષા કરી શકું કે તેઓ માંરા નિયમ પ્રમાંણે વર્તશે કે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","રોજ લોકો એક દિવસ પૂરતું જ અનાજ ભેગું કરે, પરંતુ છઠ્ઠા દિવસે રોજ કરતાં બમણું ભેગું કરીને રાંધી રાખવું.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","એટલા માંટે મૂસા અને હારુને ઇસ્રાએલના લોકોને કહ્યું, “આજે રાત્રે તમે યહોવાની શક્તિ જોશો, અને તમને ખબર પડશે કે મિસર દેશમાંથી તમને લોકોને બચાવીને બહાર લાવનાર તે યહોવા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","કાલે સવારે તમે લોકો યહોવાનું ગૌરવ જોશો કારણ કે તેમણે તેમની વિરુદ્ધની તમાંરી ફરિયાદ સાંભળી છે, તમે હમેશા અમને ફરિયાદ કરો છો, હવે કદાચ અમને થોડો આરામ મળે.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","પછી મૂસાએ તેમને કહ્યું, “યહોવા, સાંજે તમને માંસ ખાવા માંટે આપશે, વળી સવારે ઘરાઈને ખાવા માંટે રોટલી આપશે, કારણ કે તમે તેમની વિરુદ્ધ જે ફરિયાદો કરો છો તે તેમણે સાંભળી છે. પણ હવે કદાચ અમને થોડો આરામ મળે. યાદ રાખજો કે તમાંરી ફરિયાદ અમાંરી વિરુદ્ધ નથી, પણ યહોવાની વિરુદ્ધ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","પછી મૂસાએ હારુનને કહ્યું, “તું ઇસ્રાએલના લોકોને સંબોધન કર, તેમને કહે, યહોવાની સમક્ષ સૌ ભેગા થાઓ, કારણ કે તેમણે તમાંરી ફરિયાદો સાંભળી છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","હારુને ઇસ્રાએલના સમગ્ર લોકસમુદાયને સંબોધન કર્યું; તે બધા એક જ સ્થાન પર ભેગા થયા હતા. તે સભાને કહેતો હતો તે દરમ્યાન તેમણે રણ તરફ જોયું, તો તે લોકોને વાદળમાં યહોવાનાં ગૌરવનાં દર્શન થયાં, ");
INSERT INTO guj2009_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“મેં ઇસ્રાએલના લોકોની ફરિયાદ સાંભળી છે; એટલા માંટે તેમને કહો કે, ‘સાંજે તમે માંસ ખાશો અને સવારે તમે રોટલી ઘરાઈને ખાશો; અને તમને વિશ્વાસ થશે કે તમાંરા દેવ યહોવા હું છું.’” ");
INSERT INTO guj2009_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","તે રાત્રે એવું બન્યું કે લાવરીઓએ ઊડી આવીને છાવણી ઢાંકી દીધી; અને સવારમાં છાવણીની આસપાસ ઝાકળનું પડ બાઝી ગયું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","સૂરજ ઊગતાં ઝાકળ ઊડી ગયું અને હિમના પડ જેવું બારીક નાનો ગોળ પદાર્થ રણની સપાટી પર હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ઇસ્રાએલના લોકો આ જોઈ પરસ્પર એક બીજાને પૂછવા લાગ્યા, “આ શું છે?” કારણ કે એમને ખબર ન હતી કે એ શું છે. ત્યારે તેઓને મૂસાએ કહ્યું, “એ તો યહોવાએ તમને ખાવા માંટે આપેલો ખોરાક છે. ");
INSERT INTO guj2009_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","યહોવાની એવી આજ્ઞા છે કે, ‘તમે પ્રત્યેક જણ પોતાનાથી ખાઈ શકાય તેટલું ભેગું કરી લો, માંથાદીઠ બે પાયા પ્રમાંણે તમાંરા તંબુમાં રહેનારા માંણસોના પ્રમાંણે લઈ લો.’” ");
INSERT INTO guj2009_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","અને ઇસ્રાએલના લોકોએ એ પ્રમાંણે કર્યું, કેટલાકે વધુ તો કેટલાકે ઓછું ભેગું કરી લીધું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","અને પછી તેઓએ ઓમેરથી માંપિયાથી માંપ્યું ત્યારે જેણે વધુ લીધું હતું તેનું વધ્યું નહિ કે જેણે ઓછું ભેગું કર્યુ હતું તેનું ઘટયું નહિ. પ્રત્યેક માંણસે પોતાના ખાવા પૂરતું જ એકઠું કર્યુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","પછી મૂસાએ તેમને કહ્યું, “તમાંરામાંથી કોઈએ સવારને માંટે રાખી મૂકવું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","પરંતુ તેઓએ મૂસાનું કહ્યું માંન્યું નહિ અને તેમાંના કેટલાકે થોડું સવાર માંટે રાખ્યું તો તેમાં કીડા પડયા, અને તે ગંધાઈ ઊઠયું તેથી મૂસા તેમના પર ક્રોધે ભરાયો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","રોજ સવારે પ્રત્યેક જણ પોતાનાથી ખવાય તેટલો ખોરાક ભેગો કરતાં, અને સૂર્ય તપતો ત્યારે જે વધતું હોય તે બધું ઓગળી જતું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","અને પછી અઠવાડિયાના છઠ્ઠે દિવસે તેઓએ બમણો ખોરાક ભેગો કર્યો. પ્રત્યેક વ્યક્તિ દીઠ 16 કપ. પછી એ સમાંજના બધા આગેવાનોએ આવીને મૂસાને તે વિષે જણાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","અને તેણે તેઓને કહ્યું, “યહોવાની આજ્ઞા એવી છે કે, આવતી કાલે વિશ્રામવાર છે, યહોવાનો પવિત્ર સાબ્બાથ છે; તેથી તમાંરે જે રાંધવુ હોય તે રાંધી લો, અને જે વધે તે તમાંરા માંટે સવાર સુધી રાખી મૂકો.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","આથી મૂસાની આજ્ઞા પ્રમાંણે તેઓએ તેમાંથી સવારને માંટે રાખી મૂકયું, તો તેમાં કીડા પડયા નહિને ગંધાઈ પણ ઊઠ્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","અને મૂસાએ કહ્યું, “આજે તો ખાઓ, કારણ કે આજે વિશ્રામવાર છે, યહોવાનો દિવસ છે; આજે તમને ખેતરમાં અનાજ નહિ મળે. ");
INSERT INTO guj2009_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","સપ્તાહના છ દિવસ તમે એ ભેગું કરો; પણ સાતમો દિવસ સાબ્બાથ છે, તેથી તે દિવસે તમને તે ખાસ ખોરાક જમીન પર થોડો પણ નહિ મળે.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","સાતમાં દિવસે કેટલાક લોકો ભેગું કરવા માંટે બહાર ગયા, પણ તેમને કંઈ મળ્યું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ત્યારે યહોવાએ મૂસાને કહ્યું, “કયાં સુધી તમાંરા લોકોએ માંરી આજ્ઞાઓ અને નિયમોનું પાલન કરવાની ના પાડવી છે? ");
INSERT INTO guj2009_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","જુઓ, યહોવાએ તમાંરા માંટે વિશ્રામવાર આપ્યો છે, તેથી છઠ્ઠે દિવસે તે તમને બે દિવસ માંટે ચાલે તેટલુ અન્ન આપશે, તેથી સાતમે દિવસે પ્રત્યેક જણે પોતપોતાના ઘરમાં રહેવું અને કોઈએ બહાર નીકળવું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","તેથી તે લોકોએ વિશ્રામવારે વિશ્રામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ઇસ્રાએલના લોકોએ તે વિશિષ્ટ ભોજનનનું નામ “માંન્ના” રાખ્યું. માંન્ના ધાણાની દાળ જેવું સફેદ હતું. અને તેનો સ્વાદ મધવાળી પાતળી ભાખરી જેવો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ત્યારે મૂસાએ કહ્યું, “યહોવાએ આદેશ આપ્યો છે કે, ‘તમાંરા વંશજોને માંટે તેમાંથી 8 કપ ભરીને માંન્ના રાખી મૂકો; જેથી હું તમને મિસરમાંથી બહાર લઈ આવ્યો ત્યારે મેં તમને લોકોને જે ભોજન ખવડાવ્યું હતું તે તેઓ જોઈ શકે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","પછી મૂસાએ હારુનને કહ્યું કે, “એક બરણી લઈને તેમાં 8 કપ માંન્ના ભરીને તમાંરા વંશજોના ભવિષ્ય માંટે સાચવી રાખવા તેને યહોવાની આગળ મૂક.” ");
INSERT INTO guj2009_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","યહોવાએ મૂસાને આજ્ઞા આપ્યા મુજબ હારુને તેને સાચવવા માંટે કરારકોશ સમક્ષ મુકયું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","પછી ઇસ્રાએલના લોકોએ 40 વર્ષ પર્યંત વસવાટ કરવા યોગ્ય પ્રદેશમાં તેઓ આવ્યા ત્યાં સુધી-માંન્ના ખાધું. તેઓ કનાન દેશની સરદહમાં પહોંચ્યા ત્યાં સુધી તેઓએ માંન્ના ખાધું. ");
INSERT INTO guj2009_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","એક ઓમેર લગભગ આઠ પ્યાલા બરાબર હતું. માંન્ના તોલવા માંટેનું એક માંપ ઓમેર હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ઇસ્રાએલના લોકોના સમગ્ર સમાંજે સીનના રણમાંથી છાવણી ઉઠાવીને યહોવાની આજ્ઞા મુજબ યાત્રા કરતા કરતા આગળ વધીને તેમણે રફીદીમમાં છાવણી નાખી રોકાણ કર્યું. પરંતુ ત્યાં લોકોને પીવા માંટે પાણી પણ દુર્લભ હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","તેથી લોકોએ મૂસા સાથે તકરાર કરી અને કહ્યું, “અમને પીવા માંટે પાણી આપો.” એટલે મૂસાએ તેમને કહ્યું, “તમે લોકો માંરી સાથે શા માંટે તકરાર કરો છો? તમે યહોવાની કસોટી શા માંટે કરો છો? તમે એમ સમજો છો કે દેવ આપણી સાથે નથી?” ");
INSERT INTO guj2009_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","પરંતુ લોકો બહુ તરસ્યા હતા. તેથી તે લોકોએ મૂસા વિરુદ્ધ બડબડાટ કરતાં કહ્યું કે, “તમે અમને, અમાંરાં બાળબચ્ચાંને અને ઢોરઢાંખરને તરસે માંરવા શા માંટે મિસર દેશમાંથી અહીં લઈ આવ્યા?” ");
INSERT INTO guj2009_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","આથી મૂસાએ યહોવાને પોકાર કર્યો, “આ લોકો સાથે હું શું કરું? તેઓ મને માંરી નાખવા તૈયાર છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","યહોવાએ મૂસાને કહ્યું, “જા, ઇસ્રાએલના કેટલાક વડીલોને સાથે લઈને તું લોકોની આગળ ચાલતો થા. જે લાકડીથી તેં નાઈલ નદી પર પ્રહાર કર્યો હતો તે તારા હાથમાં રાખજે. ");
INSERT INTO guj2009_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","જો, હોરેબ પર્વતના એક ખડક ઉપર હું તારી સામે ઊભો રહીશ, પછી તું તે ખડક ઉપર પ્રહાર કરજે, એટલે તે ખડકમાંથી પાણી નીકળશે, જેથી લોકોને પીવા પાણી મળશે.” ઇસ્રાએલીઓના વડીલોના દેખતાં મૂસાએ તે મુજબ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","અને મૂસાએ તે જગ્યાનું નામ માંસ્સાહ અને મરીબાહ રાખ્યું. કારણ કે આ એ જ જગ્યા હતી જ્યાં ઇસ્રાએલના લોકો એની વિરુદ્ધ થયા હતા. અને તેઓએ યહોવાની પરીક્ષા કરી હતી, તે લોકો જાણવા માંગતા હતા કે યહોવા અમાંરી વચ્ચે છે કે નહિ? ");
INSERT INTO guj2009_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","અમાંલેકીઓએ રફીદીમ આગળ આવીને ઇસ્રાએલના લોકો પર હુમલો કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","પછી મૂસાએ યહોશુઆને કહ્યું કે, “તું આપણામાંથી માંણસો પસંદ કરીને આવતી કાલે અમાંલેકીઓ સામે યુદ્ધ કરવા જા. હું દેવની લાકડી લઈને પર્વતની ટોચ પર ઊભો રહીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","યહોશુઆએ મૂસાની આજ્ઞાનો સ્વીકાર કર્યો. અને અમાંલેકીઓ સામે જંગે ચડયો. પછી મૂસા તથા હારુન અને હૂર પર્વતની ટોચ પર પહોંચી ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","અને મૂસા જ્યારે પોતાનો હાથ ઊચો કરતો, ત્યારે ઇસ્રાએલના લોકોનો વિજય થતો; પરંતુ જ્યારે તે પોતાનો હાથ નીચો કરતો, ત્યારે અમાંલેકીઓનો વિજય થતો. ");
INSERT INTO guj2009_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","પણ મૂસાના હાથ થાક્યા એટલે તે લોકોએ એક પથ્થર લઈ મૂસાની પાછળ મૂક્યો અને તે તેના પર બેસી ગયો; અને હારુને તથા હૂરે ટેકો દઈને તેના હાથોને ઊંચા રાખ્યા, એક જણે એક બાજુથી અને બીજાએ બીજી બાજુથી, આમ સૂર્યાસ્ત થતાં સુધી હાથ સ્થિર રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","યહોશુઆ અને તેના લોકોએ અમાંલેક લોકોને યુધ્ધમાં હરાવી નાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","પછી યહોવાએ મૂસાને કહ્યું, “એ હકીકતને યાદગીરી માંટે પુસ્તકમાં લખ. અને યહોશુઆને જરૂર કહેશો કે, હું અમાંલેકીનું નામનિશાન પૃથ્વી પરથી સદાયને માંટે ભૂસી નાખીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ત્યાર બાદ મૂસાએ એક વેદી બનાવી અને તેનું નામ “યહોવા નિસ્સી” રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","તેણે કહ્યું કે, “મેં માંરા હાથ યહોવાના સિંહાસન તરફ લંબાવ્યા એટલા માંટે યહોવાએ હંમેશની જેમ અમાંલેકી સાથે યુદ્ધ કર્યુ.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","મૂસાના સસરા યિથ્રો મિધાનમાં યાજક હતા. દેવે મૂસા અને ઇસ્રાએલના લોકોને જે અનેક પ્રકારે સહાય કરી હતી, તે બાબતમાં તથા જે રીતે તે ઇસ્રાએલના લોકોને મિસરમાંથી બહાર લાવ્યા હતા તે બાબતમાં સાંભળ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","તેથી મૂસા જ્યારે દેવના પર્વત પાસે છાવણી નાખીને રહ્યો હતો, ત્યારે યિથ્રો મૂસા પાસે ગયો. અને તેની સાથે મૂસાની પત્ની સિપ્પોરાહ ને લાવ્યો, જેને પહેલા મૂસાએ તેમના બે પુત્રો સાથે યિથ્રો પાસે મોકલાવેલ હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","યિથ્રો મૂસાના બે પુત્રોને સાથે લાવ્યો હતો. પ્રથમ પુત્રનું નામ ગેર્શોમ હતું; કારણ તે જન્મ્યો ત્યારે મૂસાએ કહ્યું કે, “હું પરદેશમાં અજાણ્યો છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","બીજા પુત્રનું નામ અલીએઝેર હતું. કારણ કે મૂસાએ કહ્યું હતું કે, “માંરા પિતાના દેવે મને મદદ કરીને ફારુનની તરવારથી ઉગાર્યો હતો.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","એટલા માંટે યિથ્રો મૂસાની પત્ની અને પુત્રને લઈને રણમાં દેવના પર્વત આગળ જયાં મૂસાએ છાવણી નાખીને મુકામ કર્યો હતો ત્યાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","તેના સસરા યિથ્રોએ મૂસાને સંદેશો મોકલ્યો કે, “હું તમાંરો સસરો યિથ્રો છું અને તમાંરી પત્ની અને બે પુત્રોને તમાંરી પાસે લાવું છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","એટલા માંટે મૂસા તેના સસરાને મળવા સામો ગયો અને પ્રણામ કરીને ચુંબન કર્યુ. બંનેએ પરસ્પર એકબીજાને ક્ષેમકુશળતાના સમાંચાર પૂછયા. પછી તેઓ મૂસાની છાવણીમાં વધારે વાતો કરવા માંટે ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ત્યાં મૂસાએ પોતાના સસરા યિથ્રોને યહોવાએ ઇસ્રાએલના લોકો માંટે ફારુન અને મિસરના લોકોના જે હાલ કર્યા હતા તથા ઇસ્રાએલના લોકોને માંર્ગમાં જે જે વિંટંબણાઓનો સામનો કરવો પડયો હતો અને યહોવાએ તે લોકોને કેવી રીતે ઉગાર્યા હતા, તે બધું કહી સંભળાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","યહોવાએ ઇસ્રાએલના લોકોને મિસરના લોકોના હાથમાંથી છોડાવીને તેમના પર જે ઉપકાર કર્યો હતો તે જાણીને યિથ્રો ખૂબ પ્રસન્ન થયો. ");
INSERT INTO guj2009_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","અને યિથ્રોએ કહ્યું, “યહોવાની સ્તુતિ કરો, જેણે ઇસ્રાએલી લોકોને મિસર વાસીઓના અને ફારુનના હાથમાંથી છોડવ્યા છે! ");
INSERT INTO guj2009_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","હવે મને ખાતરી થઈ છે કે, યહોવા, બધા દેવોમાં મહાન છે; કારણ કે મિસરવાસીઓએ તમાંરી સાથે ગેરવર્તાવ રાખ્યો ત્યારે તમને સૌને એમના હાથમાંથી છોડાવ્યા.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","પછી મૂસાના સસરા યિથ્રોએ દેવને યજ્ઞો અને દહનાર્પણો ચઢાવ્યાં, અને હારુન ઇસ્રાએલના સર્વ વડીલોને સાથે લઈને દેવ સમક્ષ મૂસાના સસરા સાથે રોટલી ખાવાને માંટે આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","પછી બીજે દિવસે સવારે મૂસાએ ઘણા લોકોનો ન્યાય કરવાનું શરું કર્યુ જેઓ સવારથી સાંજ સુધી આવતા રહેતા અને પોતાનો વારો આવે ત્યાં સુધી રાહ જોતા. ");
INSERT INTO guj2009_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","મૂસા લોકો માંટે જે કંઈ કરતો હતો તે સઘળું મૂસાના સસરાએ જોયું, તેથી તેણે મૂસાને કહ્યું, “લોકોના માંટે તમે આ શું કરો છો? તું એકમાંત્ર ન્યાયાધીશ તરીકે બેસી રહે છે અને લોકો તારી પાસે સવારથી સાંજ સુધી આવ્યા જ કરે છે!” ");
INSERT INTO guj2009_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ત્યારે મૂસાએ પોતાના સસરાને કહ્યું, “લોકો માંરી પાસે આવે છે; અને તેમની સમસ્યાઓના સંબંધમાં દેવની ઈચ્છાની બાબતમાં પૂછે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","એ લોકોમાં કોઈ વિવાદ થયો હોય, તો તેઓ માંરી પાસે આવે છે. અને કોણ સાચું છે તે નક્કી કરુ છું. આ રીતે હું તેઓને દેવના કાનૂનો અને ઉપદેશો શીખવું છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","પરંતુ મૂસાને તેના સસરાએ કહ્યું, “તું જે રીતે આ કરી રહ્યો છે તે યોગ્ય નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","તારા એકલાથી આ કામ થઈ શકશે નહિ. તું એકલો આ કામ નહિ કરી શકે. આમ તો તમે અને તમાંરી સાથેના આ માંણસો થાકી જશો. ");
INSERT INTO guj2009_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","હું તને સલાહ આપું છું, તારે શું કરવું જોઈએ, એ હું તને બતાવું છું. હું દેવને પ્રાર્થના કરું છું કે દેવ તને મદદ કરે. તારે દેવ સમક્ષ એ લોકોના પ્રતિનિધિ થવું જોઈએ અને તે લોકોના પ્રશ્નો તેમની આગળ રજૂ કરવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","અને તારે તો લોકોને દેવના કાનૂનો અને ઉપદેશો અને આ કાયદાઓ ન તોડવા ચેતવવાના છે, શીખવવાના છે. તેઓને જીવનનો સાચો માંર્ગ અને શું કરવું તે જણાવવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“વધારામાં દેવનો ડર રાખનાર, તથા સર્વ લોકોમાંથી હોશિયાર અને વિશ્વાસપાત્ર હોય, તથા લાંચરૂશ્વતને ધિક્કારતા હોય એવા માંણસોને પસંદ કરીને તેઓને હજાર હજાર, સો સો, પચ્ચાસ પચ્ચાસ અને દશ દશ માંણસોના ઉપરીઓ નિયુક્ત કરો. ");
INSERT INTO guj2009_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","પછી એ ઉપરીઓ પ્રતિનિધિઓને લોકોનો ન્યાય કરવા દો. જો કોઈ બહુ જ ગંભીર સમસ્યા હોય તો ઉપરી પ્રતિનિધિ નિર્ણય કરશે અને પછી તેઓ તમાંરી પાસે આવી શકશે. પરંતુ બીજા નાના નાના પ્રશ્નોનો નિર્ણય તેઓ કરશે. આમ તમાંરા કાર્યમાં તેઓ સહભાગી થશે અને તમાંરું કામ હળવું થશે. ");
INSERT INTO guj2009_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","હવે જો તું આ બધુંજ કરીશ, તો દેવના ઈચ્છતા તું કદી થાકીશ નહિ અને આ બધાં લોકો પણ સંપૂર્ણપણે સંતોષી થઈ પોતાના ધરે પાછા ફરશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","પછી મૂસાએ પોતાના સસરાનું કહ્યું સ્વીકાર્યું, અને તેણે તે પ્રમાંણે કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","પછી તેણે સર્વ ઇસ્રાએલના લોકોમાંથી સારા માંણસો પસંદ કર્યા અને તેમને હજારના, સોના, પચાસના, તથા દશ માંણસોના ઉપરી નિયુક્ત કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ત્યાર બાદ તે લોકો જ બધો સમય લોકોનો ન્યાય કરવા લાગ્યા. ફક્ત મુશ્કેલ પ્રશ્નો હોય તો જ તેઓ મૂસા આગળ લાવતા, અને નાના પ્રશ્નો તેઓ જાતે પતાવતા. ");
INSERT INTO guj2009_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ત્યાર બાદ મૂસાએ પોતાના સસરા યિથ્રોને વિદાય આપી અને પછી યિથ્રો તેના વતનમાં પાછો ફર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","મિસર દેશમાંથી નીકળ્યા પછી ત્રીજા મહિનાના પ્રથમ દિવસે જ ઇસ્રાએલના લોકો સિનાઈના રણમાં આવી પહોંચ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","પછી તેઓ રફીદીમથી નીકળીને સિનાઈના રણમાં આવ્યા અને ત્યાં આગળ સિનાઈ પર્વતની સામે નજીકમાં જ મૂકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ત્યાર બાદ મૂસા પર્વત ચઢીને દેવ સમક્ષ ઊભો રહ્યો; અને દેવે તેની સાથે પર્વત પરથી વાતો કરીને કહ્યુ, “ઇસ્રાએલના લોકોને અને યાકૂબના ઘરને આ કહેજે: ");
INSERT INTO guj2009_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘તમે તમાંરી નજરે જોયું કે મે મિસરવાસીઓને શું કર્યુ અને તમને મિસરમાંથી ગરૂડની જેમ ઉપાડીને માંરી પાસે કેવી રીતે લાવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","તેથી હવે જો તમે માંરા કહ્યાં પ્રમાંણે કરશો અને માંરા કરારને ધ્યાન રાખશો, તો સર્વ પ્રજાઓમાં તમે માંત્ર ખાસ પ્રજા થશો. સમગ્ર પૃથ્વી માંરી છે. પણ હું તમને માંરા ખાસ લોકો તરીકે પસંદ કરુ છું. ");
INSERT INTO guj2009_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","તમે માંરે સારું એક ખાસ યાજકોનું રાષ્ટ્ર બનશો તથા પવિત્ર દેશજાતિ થશો.’ આ બધું તમાંરે ઇસ્રાએલના લોકોને કહેવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","આથી મૂસાએ આવીને તે લોકોના વડીલોને બોલાવડાવ્યા. અને યહોવાએ તેને જણાવેલાં બધાં વચનો તેઓની સમક્ષ કહી સંભળાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","તે સાંભળીને સર્વ લોકોએ એક સાથે જવાબ આપ્યો, “યહોવાએ જે ફરમાંવ્યું છે તે બધાનું અમે પાલન કરીશું.” અને લોકોએ જે જવાબ આપ્યો તે મૂસાએ દેવને પહોંચાડ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","પછી યહોવાએ મૂસાને કહ્યું, “જો હું એક ગાઢ વાદળમાં તારી પાસે આવું છું, જેથી હું તારી સાથે બોલું ત્યારે લોકો સાંભળી શકે, અને તારા પર સદાસર્વદા વિશ્વાસ રાખે.” અને લોકોનાં વચન મૂસાએ દેવને કહી સંભળાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","અને યહોવાએ મૂસાને કહ્યું, “તું લોકો પાસે જા અને તેઓને કહે કે, આજ અને આવતી કાલે તેઓ દેહશુદ્ધિ કરે, અને તેઓ પોતાનાં વસ્ત્રો ધુએ, ");
INSERT INTO guj2009_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","અને ત્રીજા દિવસને માંટે તૈયાર થઈ જાય; કારણ કે, ત્રીજે દિવસે હું સર્વ લોકોના દેખતાં સિનાઈના પર્વત ઉપર ઊતરનાર છું. ");
INSERT INTO guj2009_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","અને તું પર્વતની ચારે બાજુ લોકોને માંટે હદ બાંધી આપજે, અને તેમને કહેજે કે, ખબરદાર રહેજો, પર્વત પર ચઢતા નહિ, ને તેની તળેટીને પણ અડકતા નહિ, અને જે કોઈ તેને અડકશે તેનો વધ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","જો કોઈ વ્યક્તિ તેને હાથ અડકાડે, તો તેને પથ્થરે માંરવો અથવા તીરથી વીંધી નાખવો, પછી તે પશુ હોય કે માંણસ હોય, તે બચશે નહિ, જયારે રણશિંગડુ ફૂંકાય, ત્યારે માંત્ર એ લોકો પર્વત પર ચઢી શકશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","આથી મૂસા પર્વત પરથી નીચે ઊતરીને લોકો પાસે ગયો અને તેણે તેઓને શુદ્ધ કર્યા. અને લોકોએ પોતાનાં વસ્ત્રો ધોઈ નાખ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","અને પછી મૂસાએ તે લોકોને કહ્યું, “ત્રીજા દિવસ સુધીમાં તૈયાર થઈ જજો. સ્ત્રી સંગ કરશો નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","પછી ત્રીજે દિવસે સવારમાં આકાશમાં મેઘગર્જનાઓ અને વીજળીઓ થવા લાગ્યાં. પર્વત ઉપર કાળું ઘાડું વાદળ છવાઈ ગયું, અને રણશિંગડાનો બહુ મોટો અવાજ થયો, જેથી છાવણીમાં સર્વ લોકો ધ્રૂજી ઊઠયા. ");
INSERT INTO guj2009_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","એટલે મૂસાએ સર્વ લોકોને દેવને મળવા માંટે છાવણીમાંથી બહાર કાઢયા; અને તેઓ પર્વતની તળેટીમાં ઊભા રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","અગ્નિરૂપે યહોવા સિનાઈ પર્વત ઉપર ઊતર્યા, એટલે આખો પર્વત બહુ કંપ્યો. તે ઘુમાંડો ભઠ્ઠીના ઘુમાંડાની જેમ ઉપર ચઢવા લાગ્યો. અને આખો પર્વત જોરથી ધ્રૂજવા લાગ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","અને પછી જ્યારે રણશિંગડાનો અવાજ વધારને વધારે મોટો થતો ગયો, ત્યારે મૂસા બોલતો અને દેવ તેને ગડગડાટના અવાજથી જવાબ આપતો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","અને યહોવા સિનાઈ પર્વતના શિખર ઉપર ઊતર્યો; પછી યહોવાએ મૂસાને પર્વતના શિખર ઉપર બોલાવ્યો; તેથી મૂસા પર્વત ઉપર ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","પછી યહોવાએ મૂસાને કહ્યું, “નીચે જા, અને લોકોને સાવધાન કર કે, તેઓ માંરા દર્શનાર્થે હદ ઓળંગીને ઘસી આવે નહિ, નહિ તો ઘણા લોક માંર્યા જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","વળી જે યાજકો માંરી નજીક આવે, તેઓ પોતાને શુદ્ધ કરે નહિ તો હું તેમને સખત સજા કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","એટલે મૂસાએ યહોવાને કહ્યું, “લોકો સિનાઈ પર્વત ઉપર આવી શકે નહિ, કારણ કે તમે પોતે અમને આજ્ઞા કરી હતી કે, પર્વતની ચારે બાજૂ હદ બાંધી લેજો અને લોકો તેને પાર કરી પવિત્ર મેદાનમાં ન આવે.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","એટલે યહોવાએ તેને કહ્યું, “જા, નીચે ઊતર; અને હારુનને ઉપર લઈ આવ, પરંતુ યાજકો કે લોકો હદ ઓળંગીને માંરી પાસે ઘસી આવે નહિ એનું ધ્યાન રાખજે, નહિ તો હું તે લોકો ઉપર તૂટી પડીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","એટલે મૂસાએ નીચે ઉતરીને તેઓને એ વાત કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","પછી દેવે એ સર્વ વચનો ઉચ્ચારતા કહ્યું કે, ");
INSERT INTO guj2009_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“હું તમાંરો દેવ યહોવા છું, જે તમને મિસર દેશમાંથી જ્યાં તમે ગુલામ હતાં ત્યાંથી બહાર લઈ આવ્યો હતો. તેથી તમાંરે આ આદેશો માંનવા પડશે: ");
INSERT INTO guj2009_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“માંરા સિવાય તમાંરે બીજા કોઈ દેવોની પૂજા કરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“તમાંરે આકાશમાંથી કે પૃથ્વી ઉપરની કે પૃથ્વી નીચેના પાણીમાંની કોઈ પણ વસ્તુની મૂર્તિ કે પ્રતિમાં બનાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","તમાંરે તેમને સાષ્ટાંગ પ્રણામ કરવા નહિ કે તેમની પૂજા કરવી નહિ. કારણ કે હું જ તમાંરો દેવ યહોવા છું. માંરા લોકો બીજા દેવોની પૂજા કરે એ મને પસંદ નથી. જે માંરી વિરુદ્ધ પાપ કરે છે, તેઓ માંરા દુશ્મન બને છે, અને હું તેમને અને તેમના સંતાનોને ત્રીજી અને ચોથી પેઢી સુધી સજા કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","પરંતુ માંરા પર પ્રીતિ રાખનાર અને માંરી આજ્ઞાનું પાલન કરનારની હજારો પેઢી પર હું દયાભાવ દર્શાવનાર છું. ");
INSERT INTO guj2009_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“તમાંરે માંરું એટલે તમાંરા દેવ યહોવાના નામનો દુરુપયોગ ન કરવો, કારણ કે તે માંણસોને હું નિર્દોષ ગણીશ નહિ. જેઓ માંરા નામનો દુરુપયોગ કરે છે તેને સજા કર્યા વિના હું રહેતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“વિશ્રામવારની પવિત્રતા જાળવવાનું યાદ રાખો. ");
INSERT INTO guj2009_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","છ દિવસ તમાંરે તમાંરાં બધાં કામકાજ કરવાં, પરંતુ સાતમો દિવસ વિશ્રામવાર તો તમાંરા દેવ યહોવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","તેથી તે દિવસે તમાંરે કે તમાંરા પુત્રોએ કે તમાંરી પુત્રીઓએ, તમાંરા દાસ-દાસીઓએ કે તમાંરાં ઢોરઢાંખરો કે તમાંરા ગામમાં રહેતા વિદેશીએ કોઈ કામ કરવું નહિ, કારણ કે, ");
INSERT INTO guj2009_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","છ દિવસમાં યહોવાએ આકાશ તથા પૃથ્વી, સમુદ્ર તથા તેમાંની તમાંમ વસ્તુઓ બનાવી હતી અને સાતમે દિવસે વિશ્રામ કર્યો હતો, તેથી યહોવાએ વિશ્રામવારને આશીર્વાદ આપીને તેને પવિત્ર ઠરાવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“તમાંરા માંતાપિતાનું સન્માંન કરો, જેથી હું તમને જે દેશ આપનાર છું તેમાં તમે લાંબુ આયુષ્ય પામો. ");
INSERT INTO guj2009_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“તમાંરે ખૂન કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“તમાંરે વ્યભિચાર કરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“તમાંરે ચોરી કરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“તમાંરે પડોશી કે માંનવબંધુ વિરુદ્ધ જૂઠી સાક્ષી પુરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“તમાંરા પડોશીના ઘરની લાલસા રાખવી નહિ; તમાંરા પડોશીની પત્ની, કે તેના દાસ, કે તેની દાસી, કે તેનો બળદ, કે તેનું ગધેડું, કે તમાંરા પડોશીની કોઈ પણ વસ્તુની લાલસા રાખવી નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","બધા લોકો ગર્જના, અને રણશિંગડાનો નાદ સાંભળીને તથા વીજળીના ચમકારા અને પર્વતમાંથી નીકળતો ઘુમાંડો જોઈને ભયભીત થઈને થરથર ઘ્રૂજતાં દૂર જ ઊભા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","પછી તેઓએ મૂસાને કહ્યું, “અમાંરી સાથે તમે જ બોલો, તો અમે સાંભળીશું, પણ દેવ અમાંરી સાથે ન બોલે. નહિ તો અમે બધા મરી જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","એટલે મૂસાએ તે લોકોને કહ્યું, “ગભરાશો નહિ, કારણ કે દેવ તો તમાંરી કસોટી કરવા આવ્યા છે, જેથી તમે બધા ગભરાતા રહો અને પાપ ન કરો.” ");
INSERT INTO guj2009_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","પરંતુ લોકો તો તેમ છતાં દૂર જ ઊભા રહ્યાં, ને મૂસા ઘનઘોર વાદળ નજીક જયાં દેવ હતા ત્યાં ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","પછી યહોવાએ મૂસાને કહ્યું, “તું ઇસ્રાએલના લોકોને એ પ્રમાંણે કહે કે, મેં તમાંરી સાથે આકાશમાંથી વાત કરી છે એ તમે જાતે જોયું છે. ");
INSERT INTO guj2009_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","તેથી માંરી આગળ તમાંરે કોઈ સોનાચાંદીની મૂર્તિઓ ન બનાવવી. તમાંરે આ ખોટા દેવો બનાવવા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“માંરા માંટે તમે લોકો એક માંટીની વેદી બનાવજો, અને તેના પર તમાંરાં ઘેટાંબકરાં અને ઢોરોમાંથી મને દહનાર્પણ અને શાંત્યર્પણ ચઢાવજો. અને જે સર્વ જગાએ હું માંરું નામ સ્થાપીશ, ત્યાં હું તમાંરી પાસે આવીશ અને તમને આશીર્વાદ આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","જો તમે માંરા માંટે પથ્થરની વેદી બાંધો, તો ઘડેલા પથ્થરની ન કરાવશો. કારણ કે તમે જો તેના પર કોઈ પણ ઓજાર વાપરો તો તે અશુદ્ધ બની જાય. ");
INSERT INTO guj2009_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","તેમ જ તમાંરે પગથિયાં ઉપર થઈને માંરી વેદી ઉપર ચઢવું નહિ, જેથી તમાંરી નગ્નતા દેખાય નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","પછી દેવે મૂસાને કહ્યું, “હવે તારે કાનૂનો તેઓની આગળ રજૂ કરવાના છે તે આ છે: ");
INSERT INTO guj2009_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“જો તમે કોઈ હિબ્રૂ દાસ ખરીદો, તો તે છ વરસ પર્યંત તમાંરી સેવા કરે અને સાતમે વરસે તે છૂટો થઈ જાય અને તેણે ચુકવવાંનુ નહિ રહે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ગુલામ થતાં પહેલા જો તે પરણેલો નહિ હોય, તો તે પત્નીના સિવાય છુટો થઈ જાય અને એકલો ચાલ્યો જાય. પરંતુ જો ગુલામ થતી વખતે જો તે પરણેલો હશે, તો છૂટો થતી વખતે તે તેની પત્નીને સાથે લઈને જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","જો કદાચ તે અવિવાહિત હશે તો ધણી તેને પત્ની આપી શકશે. અને જો તે પત્ની, પુત્ર કે પુત્રીઓને જન્મ આપશે, તો તે સ્ત્રી તથા તેનાં બાળકો તેના ધણીનાં ગણાશે. અને તે એકલો છૂટો થાય. ");
INSERT INTO guj2009_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“પરંતુ જો તે દાસ સ્પષ્ટ કહે કે; ‘હું તો માંરા ધણીને તથા માંરી પત્નીને તથા માંરાં બાળકોને ચાહું છું; માંરે તો છૂટવું નથી.’ ");
INSERT INTO guj2009_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","જો આવું બને તો ગુલામના ધણીએ તેને ન્યાયધીશોને સમક્ષ લાવવો અને બારસાખ આગળ ઉભો રાખીને સોય વતી તેનો કાન વીંધવો; એટલે તે તેના ધણીનો સદાને માંટે દાસ બની રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“અને જો કોઈ વ્યક્તિ પોતાની દીકરીને દાસી તરીકે વેચે, તો તેને છુટી કરવાના કાયદા, પુરુષોને છુટા કરવાના કાયદા જેવા નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","જે વ્યક્તિએ તેને ખરીદી હોય તેને જો તે ન ગમે, તો તે તેના પિતાને પાછી વેચી શકે છે, જો ધણીએ તેની સાથે લગ્ન કરવાનું વચન આપ્યુ હોય, તો તે તેણે બીજા લોકોને વેચવાનો હક્ક ગુમાંવે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","પરંતુ જો તેણે તેના પોતાના પુત્ર માંટે રાખી હોય તો તેની સાથે તેણે પુત્રી જેવો વ્યવહાર રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“જો તે બીજી પત્ની કરે, તો તેણે તેની પ્રથમ પત્નીના ખોરાક-પોષાક કે તેનાં પત્ની તરીકેના હક્કમાં કશો ઘટાડો કરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","અને જો તે તેની પત્ની પ્રત્યે આ ત્રણ ફરજો કરી ન શકે, તો તે મફત એટલે પૈસા ચૂકવ્યા વગર એમને એમ છૂટી થઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“જો કોઈ એક વ્યક્તિને માંરી તેની હત્યા કરે, તો તેને મોતની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","પરંતુ જો એ વ્યક્તિએ કોઈ ચોક્કસ હેતુપૂર્વક ખૂન ના કર્યુ હોય, અને આકસ્મિક રીતે તેનું મૃત્યુ થયું હોય, તો તે વ્યક્તિને માંરી પસંદ કરેલી જગ્યાએ નાસી જશે, જ્યાં લોકો પોતાની રક્ષા માંટે ભાગી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","પરંતુ જો કોઈ ક્રોધે ભરાઈને જાણી જોઈને બીજાની હત્યા કરે, પોતાના પડોશી પર ઘસી જઈને તેને દગાથી માંરી નાખે; તો તેને માંરી વેદી આગળથી પણ લઈ જઈને મૃત્યુદંડ આપવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“અને જો કોઈ પોતાના પિતાને કે માંતાને માંરે, તો તેને મૃત્યુદંડની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“જો કોઈ ચોરીછૂપીથી માંનવહરણ કરે અને તેને વેચે, અથવા તો તેને પોતાના તાબામાં રાખે, તો તેને મૃત્યુદંડની સજા કરવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“અને જો કોઈ પોતાના પિતાને કે માંતાને શાપ આપે તો પણ તેને મૃત્યુદંડની સજા કરવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“અને જો કોઈ બે માંણસો એક બીજા સાથે ઝઘડો કરતા હોય, અને એક માંણસ બીજા માંણસને પથ્થરથી કે મુઠ્ઠીથી એવો માંરે કે તે મરી ન જાય પરંતુ ખાટલે પડે; ");
INSERT INTO guj2009_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","પછી જ્યારે તે સાજો થઈને લાકડી લઈને હરતો-ફરતો થઈ જાય, તો જે માંણસે તેને માંર્યો હોય તે છૂટી જાય ખરો, પરંતુ તેણે પેલા માંણસને સમય અને કામની નુકસાની ભરપાઈ કરવી અને સંપૂર્ણ સાજો થાય ત્યાં સુધી આધાર આપવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“અને જો કોઈ વ્યક્તિ પોતાના દાસ કે દાસીને લાકડી વડે માંરે અને તેનું મૃત્યુ થાય, તે તો ગુનેગાર ગણાય અને સજાપાત્ર બને. ");
INSERT INTO guj2009_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","પરંતુ જો તે દાસ કે દાસી મરી ન જાય અને થોડા દિવસો પછી સાજા થઈ જાય તો ધણીને સજા ન કરવી. કારણ એ દાસ કે દાસી તેની પોતાની મિલકત છે” ");
INSERT INTO guj2009_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“જો કોઈ માંણસો લડતાં-ઝઘડતાં હોય ત્યારે કોઈ માંણસ ગર્ભવતી સ્ત્રીને ઈજા પહોંચાડે અને તે તેના બાળકને સમય પહેલા જન્મ આપે પણ ગંભીર ઈજા ના થાય તો તે સ્ત્રીનો પતિ માંગે તેટલો દંડ ન્યાયાધીશના ચુકાદા પ્રમાંણે આપવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","પણ જો પછીથી બીજું કંઈ નુકસાન થાય, તો તેની શિક્ષા પ્રાણને બદલે પ્રાણ. ");
INSERT INTO guj2009_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","આંખને બદલે આંખ, દાંતને બદલે દાંત, હાથને બદલે હાથ, પગને બદલે પગ. ");
INSERT INTO guj2009_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ડામને બદલે ડામ, ઘાને બદલે ઘા, ચીરાના બદલે ચીરો એ રીતે બદલો લેવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“અને જો કોઈ વ્યક્તિ પોતાના દાસ કે દાસીને આંખ પર માંરીને તે ફોડી નાખે, તો તેણે આંખની નુકસાનીના બદલામાં તેમને છૂટાં કરી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","અને જો તે પોતાના દાસનો કે પોતાની દાસીનો દાંત તોડી પાડે, તો તેના દાંતની માંટે નુકસાનીના બદલામાં તેને છોડી દેવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“અને જો કોઈ બળદ સ્ત્રી કે પુરુષને શિંગડું માંરેને તેનું મૃત્યુ થાય, તો તે બળદને પથ્થરા માંરીને માંરી નાખવો. અને તેનું માંસ ખાવું નહિ, બળદના ધણીને ગુનેગાર ગણવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","પણ જો તે બળદને પહેલાંથી શિંગડું માંરવાની ટેવ હોય, ને તેનો ધણી તે જાણતો હોય, તેમ છતાં તેણે તેને કાબૂમાં રાખ્યો ના હોય, અને તે બળદ કોઈ પુરુષ કે સ્ત્રીને માંરી નાખે, તો તે બળદને પથ્થરો માંરીને માંરી નાખવો અને તેના ધણીને પણ મોતની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","પરંતુ મૃત્યુદંડને બદલે જો તેનો દંડ કરવામાં આવ્યો હોય, તો તેના જીવના બદલામાં જે કાંઈ મૂલ્ય ઠરાવવામાં આવ્યું હોય તે તેણે ચૂકવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“અને જો તેણે કોઈના પુત્ર કે પુત્રીને શિંગડું માંર્યુ હોય, તો પણ આ જ કાનૂન લાગું પડે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","જો એ બળદ કોઈ દાસ કે દાસીને શિંગડું માંરે તો તેના ધણીએ દાસ કે દાસીને ધણીને ત્રીસ તોલા ચાંદી આપવી અને બળદને પથ્થરો માંરીને માંરી નાખવો. ");
INSERT INTO guj2009_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“જો કોઈ વ્યક્તિ કુવાનું ઢાંકણુ ખોલી નાખે અથવા કોઈ વ્યક્તિ ખાડો ખોદેને તેને ઢાંકે નહિ, ને જો તેમાં કોઈનો બળદ કે કોઈનું ગધેડું પડે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","તો ખાડાના ધણીએ નુકસાન ભરપાઈ કરવું. તેણે એ પશુના ધણીને નાણામાં બદલો આપવો. અને મરેલું પશુ પોતે લઈ જવું. ");
INSERT INTO guj2009_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“અને જો કોઈ માંણસનો બળદ બીજાના બળદને શિંગડું માંરે અને તે મરી જાય, તો તે બન્ને જીવતો બળદ વેચી નાખે અને તેની કિંમત તથા મરેલું પશુ વહેંચી લે. ");
INSERT INTO guj2009_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","અથવા જો અને પહેલેથી જ ખબર હોય કે એ બળદને કેટલાક સમયથી માંરવાની ટેવ છે અને એના ધણીએ એને કાબૂમાં રાખ્યો ન હોય, તો તેનું નુકસાન ભરપાઈ કરી આપવું. બળદને બદલે બળદ આપવો, અને એ મૃત પશુ તેનું થાય. ");
INSERT INTO guj2009_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“જો કોઈ માંણસ બળદ કે ઘેટું ચોરે અને તેને કાપે અથવા વેચી નાખે, તો તેણે એક બળદને બદલે પાંચ બળદ અને એક ઘેટાને બદલે ચાર ઘેટા આપવા. ");
INSERT INTO guj2009_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","જો કોઈ ચોર રાતના ખાતર પાડતા પકડાય અને તેની હત્યા થાય તો એ ખૂન ન ગણાય, પણ ");
INSERT INTO guj2009_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","જો તે સૂર્યોદય પછી ખાતર પાડીને ઘરમાં ઘૂસે અને પકડાઈ જતાં તેને માંરી નાખવામાં આવે તો એ ખૂન ગણાય. ચોરેલા માંલની નુકસાની ચોરી કરનાર ભરી આપે; અને જો તે કંગાલ હોય તો તેની ચોરીને કારણે પોતે વેચાઈ જાય. ");
INSERT INTO guj2009_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","પરંતુ જો ચોરેલી વસ્તુ તેના તાબામાં જીવતી મળી આવે, પછી તે બળદ હોય કે ગધેડું હોય કે ઘેટું હોય; તો તે બમણું ભરપાઈ કરી આપે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“જો કોઈ વ્યક્તિ પોતાનાં ઢોર ખેતરમાં કે દ્રાક્ષની વાડીમાં છૂટાં મૂકે અને તેઓ બીજાનાં ખેતરોમાં ભેલાણ કરે, તો તેણે પોતાના ખેતરની અથવા દ્રાક્ષની વાડીની સર્વોત્તમ ઊપજમાંથી નુકસાની ભરપાઈ કરી આપવી. ");
INSERT INTO guj2009_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“જો કોઈ વ્યક્તિ પોતાના ખેતરમાં કાંટા-ઝાખરાં સળગાવવા આગ પેટાવે અને આગ પડોશીના ખેતરમાં ફેલાઈ જાય અને તેના પાક અથવા અનાજ બળી જાય; તો જેણે આગ લગાડી હોય તેણે પૂરું નુકસાન ભરપાઈ કરી આપવું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“જો કોઈ વ્યક્તિ પોતાના પડોશીને નાણાં કે મિલકત સાચવવા માંટે સોંપે અને તે પેલા માંણસના ઘરમાંથી ચોરાઈ જાય; અને જો ચોર પકડાય, તો તેણે બમણું ભરપાઈ કરી આપવું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","પરંતુ જો ચોર પકડાઈ ના જાય તો તે ઘર ધણીએ પોતાને ન્યાયધીશો આગળ રજુ કરવો અને ન્યાયધીશ તેની ચોરીનો ફેસલો કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“જો કોઈ બે વ્યક્તિ બળદ વિષે કે ગધેડા વિષે કે ઘેટા વિષે કે વસ્ત્ર વિષે કે કોઈ ખોવાયેલી વસ્તુ વિષે અસહમત હોય અને તેમાંનો એક કહે: ‘આ માંરુ છે.’ પણ બીજો કહે: ‘ના આ માંરુ છે’ તો બન્નેએ દેવ પાસે જવુંને દેવ ન્યાય આપશે કે કોણ ખોટુ છે. જે ખોટો નીકળે તેણે બીજા વ્યક્તિને બમણું ભરપાઈ કરી આપવું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“જો કોઈ માંણસ પોતાના પડોશીને ગધેડું, બળદ, ઘેટું કે બીજું કોઈ પશુ સાચવવા સોંપે; અને તે મરી જાય, અથવા તેને કોઈ ઈજા થાય, અથવા કોઈ ઉપાડી જાય, અને કોઈ સાક્ષી હોય નહિ, ");
INSERT INTO guj2009_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","તો પછી તે માંણસે સમજાવવું કે તેણે ચોરી નથી કરી અથવા પ્રાણીને ઈજા નથી પહોચાડી. તેણે યહોવાને સમ સાથે કહેવાનું કે તેણે ચોરી નથી કરી; અને તેના ધણીએ એ કબૂલ રાખવું; અને પછી પડોશીએ નુકસાન ભરપાઈ કરવાનું રહેતું નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","પરંતુ જો પડોશી એ તે પશુની ચોરી કરી હોય, તો તેણે ધણીને નુકસાન ભરપાઈ કરી આપવું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","જો કોઈ જંગલી પ્રાણીએ તેને ફાડી ખાધું હોય, તો તેનો વધેલો ભાગ પુરાવા તરીકે રજૂ કરવો. પછી ફાડી ખાધેલાં પશુનું નુકસાન ભરપાઈ કરવાનું રહેતું નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“અને જો કોઈ વ્યક્તિ પોતાના પડોશી પાસેથી કોઈ પ્રાણી ઉછીનું માંગી લે, અને તેનો ધણી તેની સાથે ના હોય તે સ્થિતીમાં તેને કંઈ ઈજા થાય અથવા તે મરી જાય, તો ઉછીનું લેનારે તેનો પુરેપુરો બદલો આપવો. ");
INSERT INTO guj2009_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ધણી તેની સાથે હોય, તો ઉછીનું લેનારે નુકસાન ભરપાઈ કરવાનું રહેતું નથી. અને જો ભાડે લીધું હોય તો ફકત ભાડું ચુકવવાનું રહે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“જો કોઈ વ્યક્તિ અપરણીત કુમાંરિકાને લલચાવીને તેની સાથે મેળાપ કરે, તો તેણે તેનું કન્યામૂલ્ય ચૂકવીને તેની સાથે લગ્ન કરે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","જો તેનો બાપ તેની સાથે પરણાવાની ના પાડે, તો કુમાંરિકાના કન્યામૂલ્ય જેટલું નાણું આપવાનું રહે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“મેલીવિધાનો ઉપયોગ કરનાર સ્ત્રીને જીવતી રહેવા ન દે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“જાનવરની સાથે કુકર્મ કરનારને મૃત્યુદંડની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“માંરા સિવાય એટલે કે યહોવા સિવાય બીજા કોઈ પણ દેવને યજ્ઞ કરે અને આહુતિ આપે તો તે વ્યક્તિનું નામનિશાન રહેવા દેવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“તમાંરે વિદેશીઓને હેરાન કરવા નહિ, તેમના પર ત્રાસ કરવો નહિ, કારણ કે, તમે પોતે મિસર દેશમાં વિદેશી હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“કોઈ વિધવા કે અનાથ બાળકને રંજાડશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","જો તમે કોઈ પણ પ્રકારે ત્રાસ અથવા તેમને દુઃખી કરશો તો તેઓ મને પોકારશે અને હું તેમનો પોકાર સાંભળીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","અને માંરો ક્રોધ ભભૂકી ઊઠશે. અને હું તરવારથી તમને રહેંસી નાખીશ; તો તમાંરી પત્ની વિધવા થશે અને તમાંરાં પોતાનાં બાળકો અનાથ થશે. ");
INSERT INTO guj2009_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“તમે માંરા લોકોમાંના કોઈ ગરીબ માંણસને નાણાં ધીરો, તો તેના પ્રત્યે લેણદાર જેવો વ્યવહાર ન રાખશો, ને તેની પાસે વ્યાજ લેશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","જો તમે તમાંરા પડોશીનું વસ્ત્ર ગીરવે રાખો, તો સૂર્યાસ્ત થતાં અગાઉ તમાંરે તે તેને પાછું આપવું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","કારણ કે એ એકમાંત્ર એનું પાગરણ છે. તેથી તે બીજું શું ઓઢીને સૂએ? જો તે મને પોકારશે, તો હું તેને સાંભળીશ, કારણ કે હું કૃપાળુ છું. ");
INSERT INTO guj2009_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“તમાંરા ન્યાયધીશોની નિંદા ન કર તથા તમાંરા પોતાના લોકોના કોઈ આગેવાનને શાપ આપવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“તમાંરે તમાંરા ખેતરની ઊપજ તથા તમાંરા દ્રાક્ષારસની પુષ્કળતામાંથી અર્પણ કરવામાં ઢીલ કરવી નહિ અને તમાંરો જયેષ્ઠ પુત્ર મને આપવો. ");
INSERT INTO guj2009_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“તમાંરાં બળદો અને ઘેટાનું પ્રથમ જનિત મને આપવું. સાત દિવસ ભલે તે પોતાની માંતાની સાથે રહે. આઠમે દિવસે તમાંરે તે મને આપી દેવો. ");
INSERT INTO guj2009_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“અને તમે લોકો માંરા પવિત્ર માંણસો થાઓ; તમાંરે જંગલી પશુએ માંરેલા કોઈ પશુનું માંસ ન ખાવું, તે કૂતરાંને નાખી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“તમાંરે જૂઠી અફવા માંનવી નહિ, કે ફેલાવવી નહિ, દુષ્ટ માંણસને સાથ આપીને ખોટી સાક્ષી પૂરવી નહિ, ");
INSERT INTO guj2009_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“બહુમતીથી દોરવાઈને તમાંરે ખોટું કામ કરવું નહિ, તેમ જ ન્યાયલયમાં સાક્ષી આપતી વખતે ન્યાયના ભોગે બહુમતીનો પક્ષ લેવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“માંણસ ગરીબ હોય તો તેની ગરીબીના કારણે ન્યાયાલયમાં તેના પ્રત્યે પક્ષપાત ન કરવો. જો તે સાચો હોય તો જ એનો પક્ષ લેવો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“તમાંરા શત્રુનો બળદ કે ગધેડો ભટકતો નજરે પડે તો તમાંરે તેના માંલિકને ત્યાં પાછો પહોંચાડવો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“જો તમે તમાંરા દુશ્મનના ગધેડાને ભારથી ચગદાઈને પડેલો જુઓ, તો તેને એમને એમ છોડીને ચાલ્યા ન જતાં, તમાંરે તેને સહાય આપીને બેઠો કરવો પછી જ તેને છૂટું કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“તમાંરે ગરીબ માંણસને તેના ન્યાયશાસનમાં અન્યાય ન કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“જૂઠા આક્ષેપો કરવા નહિ, તથા નિર્દોષ અને ન્યાયીને મૃત્યુદંડની સજા કરવી નહિ. હું નિર્દોષ માંણસ ને માંરી નાખે તેવા ખરાબ માંણસને નિર્દોષ નહિ માંનું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“તમાંરે કદાપી લાંચ લેવી નહિ. કારણ કે લાંચ દેખતાને અંધ બનાવે છે, જેથી તેઓ સત્ય જોઈ શકતા નથી. તે સારા માંણસને ખોટુ બોલતા કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“તમાંરે વિદેશી લોકો પર ત્રાસ કરવો નહિ, તમે લોકો મિસરમાં વિદેશી હતા, એટલે તમે વિદેશીઓની લાગણીને જાણો છો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“અને છ વર્ષ પર્યંત તમાંરે ખેતરમાં વાવેતર કરવું અને તેની ઊપજ એકત્રીત કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","પણ તમાંરે સાતમે વર્ષે કશુંય વાવ્યા વિના જમીન પડતર રહેવા દેવી. જમીનને એક વર્ષ આરામ કરવા દેવો. જે કઈ ઉગે વાવ્યા વગર તે વર્ષે તે ગરીબોને લેવા દેવું અને વધેલું વનનાં પશુઓ ખાઈ શકે. વળી તમાંરે તમાંરી દ્રાક્ષની અને જૈતૂનની વાડીમાં પણ આ પ્રમાંણે કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“તમાંરે છ દિવસ કામ કરવું પણ સાતમે દિવસે વિશ્રામ કરવો, જેથી તમાંરા બળદને અને ગધેડાને આરામ મળે અને તમાંરા ઘરમાં કામ કરતા દાસ-દાસી અને પરદેશી આરામ કરીને તાજા થાય. ");
INSERT INTO guj2009_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“અને મેં જે બધું તમને કહ્યું છે તેનું ધ્યાન રાખજો. અને અન્ય દેવોની પૂજા કરશો નહિ. તથા તમાંરા મોઢેથી તેઓનું નામ સાંભળવા મળવું જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“પ્રતિવર્ષ તમાંરે માંરો ઉત્સવ ત્રણ વાર ઊજવવો, આ રજાઓમાં, તમાંરે માંરી ખાસ જગ્યાએ માંરી ઉપાસના કરવા આવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","પહેલી રજા આબીબ મહિનામાં બેખમીર રોટલીના ઉત્સવની હશે. તે વખતે સાત દિવસ માંરી આજ્ઞા મુજબ તમાંરે ખમીર વગરની રોટલી ખાવી. કારણ કે, એ મહિનામાં તમે મિસરમાંથી બહાર આવ્યા હતા, અને કોઈએ માંરી પાસે ખાલી હાથે આવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“બીજી રજા કાપણીના પર્વની હશે. આ રજા વહેલા ઉનાળામાં તમે ખેતરમાં જે વાવેતર કર્યુ હોય તેની પ્રથમ ઊપજ પ્રાપ્ત થાય ત્યારે હશે. “ત્રીજી રજા આશ્રયના પર્વમાં જ્યારે ખેતરમાંથી ઉપજ ભેગી કરો ત્યારે રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“પ્રતિવર્ષ ત્રણ વખત તમાંરામાંના પ્રત્યેક પુરુષોએ માંરી ખાસ જગ્યાએ, માંરી સાથે તમાંરા માંલિક સાથે હાજર રહેવું. ");
INSERT INTO guj2009_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“તમાંરે માંરા યજ્ઞનું લોહી ખમીરવાળી રોટલી સાથે ધરાવવું નહિ તેમજ માંરા પર્વની ચરબી સવાર સુધી રાખી મૂકવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“તમાંરી જમીનની પ્રથમ ઊપજનો ઉત્તમોત્તમ ભાગ તમાંરે તમાંરા યહોવા દેવના મંદિરમાં લઈ આવવો. “વળી લવારાને તેની માંતાના દૂધમાં રાંધવું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“અને તમાંરા માંટે મેં જે જગ્યા તૈયાર કરી છે ત્યાં તમને લઈ જવા માંટે હવે હું તમાંરી આગળ એક દેવદૂત મોકલું છું તે રસ્તામાં તમાંરું રક્ષણ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","તમે લોકો તેનાથી જાળવીને રહેજો અને તેનું કહ્યું કરજો. તેના વિરુદ્ધ બળવો ન કરશો, તે તમાંરો ગુનો માંફ કરશે નહિ કારણ કે માંરુ નામ તેનામાં છે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","પરંતુ જો તમે તેની આજ્ઞાઓનું પાલન કરશો અને હું જે કહું તે બધુ કરશો, તો હું તમાંરી સાથે રહીશ અને તમાંરા શત્રુઓ સાથે લડીશ. અને તમને હેરાન અને ત્રાસ કરનારને હું સજા આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“કારણ કે માંરો દેવદૂત તમાંરી આગળ આગળ ચાલશે અને તમને અમોરીઓ, હિત્તીઓ, પરીઝીઓ, કનાનીઓ, હિવ્વીઓ અને યબૂસીઓના પ્રદેશમાં લઈ જશે, અને હું તેઓનો સર્વનાશ કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“તે લોકોના દેવોની પૂજા કરવી નહિ, તેમની આગળ નમવું નહિ. તમાંરે તે લોકોની જેમ રહેવાનું નથી; તમાંરે તેઓની મૂર્તિઓને ઉથલાવી પાડવાની છે. અને તે લોકોના સ્તંભોના ભાંગીને ભુક્કા કરી નાખવાના છે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","વળી તમાંરે તમાંરા યહોવા દેવની જ સેવા કરવાની છે, અને હું તમાંરા અન્ન-જળ પર આશીર્વાદ વરસાવીશ. અને તમાંરા તમાંમ રોગો હું દૂર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","તમાંરા દેશમાં કોઈ પણ સ્ત્રીનો ગર્ભપાત થશે નહિ, તથા કોઈ સ્ત્રી વાંઝણી પણ હશે નહિ; હું તમને લોકોને પૂરેપૂરું આયુષ્ય આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“તમે જ્યારે દુશ્મનો સાથે લડતા હશો, ત્યારે હું માંરુ મહાબળ તમાંરી સામે મોકલીશ અને તે બધાંને હું થથરાવી દઈશ. તથા તમાંરા બધા જ દુશ્મનો તમાંરાથી ભાગી જાય એવું હું કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","તદુપરાંત હું તમાંરી આગળ હું ભમરીઓને મોકલીશ, ને તે હિવ્વી તથા કનાની તથા હિતી લોકોને તમાંરી આગળથી કાંકી કાઢશે. ");
INSERT INTO guj2009_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","હું એક જ વર્ષમાં એ બધાને હાંકી કાઢીશ નહિ, રખેને બધી જમીન વેરાન થઈ જાય અને જગંલમાં જંગલી જાનવરોની સંખ્યા વધી જતાં તમે બધા મુશ્કેલીમાં મુકાઈ જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","તમાંરી સંખ્યાનો એટલો બધો વધારો થાય અને તમે સમગ્ર દેશનો કબજો લઈ શકો ત્યાં સુધીમાં તો હું તેમને ધીરે ધીરે હાંકી કાઢીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“અને હું રાતા સમુદ્રથી ફ્રાત નદી સુધી તમાંરી સરહદ નક્કી કરી આપીશ. પલિસ્તીઓના સમુદ્ર પશ્ચિમી સરહદે રહેશે અને પૂર્વી સરહદે અરબી રણ રહેશે. અને એ દેશના વતનીઓને હું તમાંરા હાથમાં સોંપી દઈશ, અને તમે તેમને હાંકી કાઢજો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“તમે તેઓની સાથે કે તેઓના દેવો સાથે કોઈ સંબંધ બાંધશો નહિ, કે તેમને તમાંરા શહેરમાં રહેવા ન દેશો. ");
INSERT INTO guj2009_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","નહિ તો તેઓ તમને ફસાવી, તેમના દેવોની પૂજા કરશે અને માંરી વિરુદ્ધ પાપ કરવા પ્રેરશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","દેવે મૂસાને કહ્યું, “તું અને હારુન, તથા નાદાબ તથા અબીહૂ તથા ઇસ્રાએલના વડીલોમાંના સિત્તેર માંરી સમક્ષ આવો; અને થોડે દૂર રહીને માંરુ ભજન કરજો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","પછી તું એકલો માંરી પાસે આવજે, અન્ય કોઈ ન આવે. અને લોકો તો તારી સાથે ઉપર આવે જ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ત્યારબાદ મૂસાએ આવીને લોકોને યહોવાનાં બધાં વચનો અને બધી આજ્ઞાઓ કહી સંભળાવી. પછી બધા લોકો એકી અવાજે બોલી ઊઠયા, “યહોવાએ જે બધી વાતો કહી છે તે બધાનું પાલન અમે કરીશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","પછી મૂસાએ યહોવાનાં બધાં આદેશો લખી નાખ્યાં અને સવારમાં વહેલા ઊઠીને તેણે પર્વતની તળેટીમાં એક વેદી બાંધી અને ઇસ્રાએલના બાર કુળસમૂહ પ્રમાંણે બાર સ્તંભ બાંધ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","પછી તેણે કેટલાક ઇસ્રાએલી નવયુવાનોને યજ્ઞો અર્પવા મોકલ્યા. અને તેમણે યહોવાને દહનાર્પણ અને શાંત્યર્પણ તરીકે બળદો અર્પણ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","અને મૂસાએ યજ્ઞનું અડધું લોહી એક વાસણમાં રાખ્યું અને અડધું લોહી તેણે વેદી પર છાંટયું. ");
INSERT INTO guj2009_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","પછી તેણે કરારનું પુસ્તક લીધું અને બધા લોકોને મોટેથી વાંચી સંભળાવ્યું એટલે તેઓ બોલી ઊઠયા, “યહોવાએ જે જે કહ્યું છે તે બધું અમે માંથે ચઢાવીશું અને તે પ્રમાંણે કરીશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","પછી મૂસાએ વાસણમાંથી લોહી લઈને લોકો પર છાટયું અને કહ્યું, “આ પુસ્તકમાં લખેલાં વચનો પ્રમાંણે યહોવાએ તમાંરી સાથે જે કરાર કર્યો છે, તેને પાકો કરનાર આ લોહી છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","તે પછી મૂસા, હારુન, નાદાબ, અબીહૂ અને ઇસ્રાએલીઓના 70 વડીલોને સાથે લઈને તે ઉપર ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ત્યાં તેમણે ઇસ્રાએલના દેવના દર્શન કર્યા. તેમના પગ નીચે જાણે નીલમના જેવી ફરસબંધી હતી-સ્વચ્છ નિર્મળ આકાશ જ જોઈ લો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ઇસ્રાએલના બધા આગેવાનોએ દેવનું આ દ્રશ્ય જોયું, પણ યહોવાએ તેમનો નાશ ન કર્યો. તેઓ બધાએ સાથે ખાધું અને પીધું. ");
INSERT INTO guj2009_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","યહોવાએ મૂસાને કહ્યું, “તું માંરી પાસે પર્વત પર આવ અને ત્યાં રહે; અને મેં જે શિલાઓ ઉપર નિયમો અને આજ્ઞાનો લખ્યાં છે, તે હું તને આપીશ જેથી તું લોકોને સમજાવી શકે.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","આથી મૂસા તથા તેનો સેવક યહોશુઆ ઊઠયા, અને મૂસા દેવના પર્વત પર ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","જતાં જતાં તેણે વડીલોને કહ્યું, “અમે પાછા આવીએ, ત્યાં સુધી તમે અહી અમાંરી રાહ જુઓ. અને જુઓ, હારુન અને દૂર તમાંરી સાથે છે; જો કોઈને કંઈ તકરાર હોય તો તે એ બે જણ પાસે જાય.” ");
INSERT INTO guj2009_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","પછી મૂસા પર્વત પર ચઢયો અને વાદળોએ પર્વતને ઢાંકી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","યહોવાનું ગૌરવ સિનાઈ પર્વત પર ઊતર્યુ. અને છ દિવસ સુધી વાદળોએ એ પર્વતને ઢાંકી રાખ્યો, અને સાતમે દિવસે યહોવાએ વાદળમાંથી મૂસાને હાંક માંરીને બોલાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","અને યહોવાનું ગૌરવ ઇસ્રાએલીઓને પર્વતની ટોચે સર્વભક્ષી અગ્નિ જેવું લાગ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","અને મૂસા વાદળમાં પ્રવેશ કરીને પર્વત પર ચઢયો; અને તે ત્યાં 40 દિવસ અને 40 રાત રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ઇસ્રાએલના લોકોને કહે કે, તેઓ માંરા માંટે ભેટ ઉધરાવે; પ્રત્યેક માંણસ રાજીખુશીથી જે કંઈ આપે તે તમાંરે ભેટ તરીકે સ્વીકારવું. ");
INSERT INTO guj2009_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","તમાંરે તેમની પાસેથી આટલી વસ્તુઓ ભેટમાં સ્વીકારવી; સોનું, ચાંદી તાંબું અને ભૂરા, જાંબુડિયા તથા કિરમજી રંગનું કિંમતી ઊન; ");
INSERT INTO guj2009_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","શણનું ઝીણું કાપડ તથા બકરાંના વાળ, ");
INSERT INTO guj2009_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ઘેટાનાં પકવેલાં લાલ રંગમાં રંગેલાં ચામડાં, તથા સીલ (માંછલી) નાં કુમાંશદાર ચામડાં, અને બાવળનાં લાકડાં. ");
INSERT INTO guj2009_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","દીવા માંટે તેલ, અભિષેકના તેલને માંટે તથા સુવાસિત ધૂપને માંટે સુગંધીઓ, ");
INSERT INTO guj2009_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ઉરપત્ર અને એફોદમાં જડવા માંટે ગોમેદ પાષાણો અને અન્ય પાષાણો.” ");
INSERT INTO guj2009_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“અને તેઓ માંરા માંટે એક પવિત્ર સ્થાન બનાવે, જેથી હું તેમની વચ્ચે રહી શકું. ");
INSERT INTO guj2009_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","હું મંડપનો નમૂનો તથા તેના સર્વ સામાંનનો નમૂનો બતાવું તે પ્રમાંણે તમાંરે તે બનાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“બાવળના લાકડાનો અઢી હાથ લાંબો, દોઢ હાથ પહોળો, અને દોઢ હાથ ઊંચો એક પવિત્રકોશ બનાવવો. ");
INSERT INTO guj2009_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","અને તેને અંદરથી ને બહારથી ચોખ્ખા સોનાથી મઢી લેવો અને તેની ફરતે સોનાની પટ્ટી જડવી. ");
INSERT INTO guj2009_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","પછી તેને ઊંચકવાનાં ચાર સોનાનાં કડાં બનાવવાં અને તેના ચાર ખૂણે જડી દેવાં; એક બાજુએ બે કડાં અને બીજી બાજુએ બે કડાં. ");
INSERT INTO guj2009_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","બાવળના દાંડા બનાવીને પછી તું તેમને સોનાથી મઢજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","અને કોશને ઉપાડવા માંટે એ દાંડા દરેક બાજુના કડામાં પરોવી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","દાંડા કોશનાં કડામાં રહેવા દેવા, બહાર કાઢવા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“અને હું તને કરારના સ્માંરક તરીકે જે બે પાટીઓ આપું તે તું તેમાં મૂકજે, ");
INSERT INTO guj2009_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","વળી ચોખ્ખા સોનાનું અઢી હાથ લાંબું અને દોઢ હાથ પહોળું ઢાંકણું તમાંરે બનાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","અને બે કરૂબ દેવદૂતો ટીપેલા સોનામાંથી ઘડીને ઢાંકણના બે છેડા માંટે બનાવવા. ");
INSERT INTO guj2009_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","અને એક દેવદૂત એક છેડા પર, ને બીજા ઢાંકણના બીજા છેડા પર બેસાડવો, એ દેવદૂત ઢાંકણની સાથે એવી રીતે જોડી દેવા કે ઢાંકણ અને દેવદૂતો એક થઈ જાય. ");
INSERT INTO guj2009_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","એ દેવદૂતોની પાંખો ઊચે આકાશ તરફ ફેલાયેલી રાખવી. તેમનાં મોં એકબીજાની સામે હોય અને તે ઢાંકણ તરફ વળેલાં હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“એ ઢાંકણ કોશ ઉપર મૂકવું અને કોશમાં હું તને આપું તે કરારની બે પાટીઓ મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","પછી હું તને ત્યાં મળીશ. અને કરારકોશ ઉપરના બે કરૂબદેવદૂતોની વચ્ચેથી હું તને ઇસ્રાએલીઓ માંટેની માંરી બધી આજ્ઞાઓ આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“વળી તું બાવળના લાકડાનો બે હાથ લાંબો, એક હાથ પહોળો, અને દોઢ હાથ ઊંચો એક મેજ બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","અને તું તેને શુદ્ધ સોનાથી મઢજે, ને તેને ફરતી સોનાની કિનારી બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","અને તેને ફરતી તું ચાર આંગળની કોર બનાવજે, અને કોરની આસપાસ સોનાની કિનારી બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","અને એને ઉપાડવા માંટે સોનાનાં ચાર કડાં બનાવજે અને તેને ચાર ખૂણે ચાર પાયા સાથે જડી દેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","મેજને ઉપાડવા માંટેની દાંડીઓ પરોવવાના કડાં કિનારની પાસે મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","અને મેજ ઊચકવા માંટે બાવળના દાંડા બનાવજે અને તેને સોનાથી મઢજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","મેજ માંટે વાસણો બનાવજે; રકાબીઓ, વાટકા, પેય અને નૈવેધ માંટેના વાટકા તથા કડછીઓ; એ બધાં શુદ્ધ સોનાનાં બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","અને એ મેજ પર હંમેશા માંરી સંમુખ મને ધરાવેલી રોટલી મૂકી રાખજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“વળી, એક શુદ્ધ સોનાની દીવી બનાવજે. તે દીવીની બેસણી અને થાંભલી સોનામાંથી ઘડીને બનાવજે, તેનાં શોભાના ફૂલો, કળીઓ અને પાંદડીઓ, દીવી સાથે જડીને એક કરી દેવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“એ દીવીને છ શાખા હોય-બંને બાજુએ ત્રણ ત્રણ. ");
INSERT INTO guj2009_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","એ છમાંની દરેક શાખાને બદામના ફૂલના ઘાટનાં ત્રણ શોભાનાં ફૂલ હોય, અને પ્રત્યેકને કળીઓ અને પાંદડીઓ હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","દીવીની થાંભલીને બદામનાં ફૂલના ઘાટનાં ચાર શોભાના ફૂલ હોય અને દરેકને કળીઓ અને પાંખડીઓ હોય, ");
INSERT INTO guj2009_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","દીવીને છ ડાળી હોવી જોઈએ-દાંડીની બન્ને બાજુથી ત્રણ શાખા નીકળવી જોઈએ, શાખાની દરેક જોડીની નીચે એક એક કળી હોય, એ કળીએ અને ડાળીઓ દીવીની સાથે જડી દીધેલી હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","અને બધુંજ શુદ્ધ સોનાની એક જ ડાળકીમાંથી ઘડીને બનાવેલું હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","દીવી માંટે સાત કોડિયાં બનાવવાં અને એવી રીતે ગોઠવવાં કે તેમનો પ્રકાશ સામેની બાજુએ પડે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","એના ચીપિયા અને તાસક શુદ્ધ સોનાના હોવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","આ બધાં સાધનો બનાવવા માંટે 75 પૌંડ શુદ્ધ સોનું વાપરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","તેં પર્વત પર જોયેલા નમૂના પ્રમાંણે આ બધું બનાવવાની કાળજી રાખજે.” ");
INSERT INTO guj2009_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","યહોવાએ મૂસાને કહ્યું, “વળી તું મંડપ દશ પડદાનો બનાવજે. આ પડદા ઝીણા કાંતેલા શણના હોવા જોઈએ અને ભૂરા, કિરમજી અને લાલ ઊનના બનાવજે. એ પડદાઓ ઉપર જરીથી કળામય રીતે કરૂબ દેવદૂતો ભરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","પ્રત્યેક પડદો અઠ્ઠાવીસ હાથ લાંબો, ને ચાર હાથ પહોળો હોય; બધાજ પડદા એક સરખા માંપના હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","પાંચ પડદા એકબીજા સાથે જોડાય અને બીજા પાંચ પડદા એકબીજા સાથે જોડાય. ");
INSERT INTO guj2009_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","પડદાના એક સમૂહ પર જાંબુડિયા રંગના કાપડનાં નાકાં મૂકવાં. બીજા સમૂહના છેલ્લા પડદા પર પણ એમ જ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","એક પડદામાં તું 50 નાકાં બનાવજે, ને બીજા સમૂહના પડદામાં 50 નાકાં બનાવજે અને નાકાં એકબીજાની સામસામાં આવવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","પછી 50 કડીઓ સોનાની બનાવને બંને પડદાને સાંધી દેવા જેથી મંડપનો એક સળંગ તંબુ બનશે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“આ પવિત્ર મંડપ ઉપર તંબુ બનાવવા માંટેનું બકરાંના વાળના કાપડના અગિયાર પડદા તૈયાર કરવા. ");
INSERT INTO guj2009_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","અગિયાર પડદા એક સરખા માંપના હોવા જોઈએ, પ્રત્યેક 30 હાથ લાંબા અને 4 હાથ પહોળા. ");
INSERT INTO guj2009_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","એમાંના પાંચ પડદાને એક સાથે સીવીને એક પડદો બનાવવો; બાકીના છ પડદાને ભેગા સીવીને બીજો પડદો બનાવવો. એમાંનો છઠ્ઠો પડદો મંદિરના પ્રવેશદ્વાર ઉપર બેવડ વાળવો. ");
INSERT INTO guj2009_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","અને સમૂહનો જે છેલ્લો પડદો છે તેની બાજુએ પચાસ નાકાં; ને બીજા સમૂહના પડદાની બાજુએ પચાસ નાકાં બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","અને કાસા 50 કડીઓ બનાવજે અને તેને પેલા નાકાંમાં પરોવી બંને પડદાંને જોડી દઈને એક સળંગ તંબુ બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","અને તંબુ ઉપરથી વધારાનો લટકતો રહેતો અડઘો પડદો મંડપના પાછલા ભાગ પર લટકતો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","તંબુની બંને બાજુએ પડદાઓ એક હાથ તંબુના છેડેથી નીચા રહેશે. આથી આ તંબુ પવિત્ર તંબુને સંપૂર્ણ રીતે ઢાંકશે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","તંબુ માંટે ઘેટાંના લાલ રંગેલાં ચામડાંનો બીજો ઓઢો બનાવવો અને તેના પર આચ્છાદન માંટે કુમાંશદાર ચામડાનું ઢાંકણ બનાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“પવિત્રમંડપની આધાર તરીકે બાવળનાં પાટિયાં બનાવી ઊભાં મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","પ્રત્યેક પાટિયું 10 હાથ લાંબુ અને દોઢ હાથ પહોળું હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","પ્રત્યેક પાટિયામાં એકબીજાની સાથે જોડાયેલી બે સાલ હોય; પવિત્ર મંડપની બધી જ બારસાખો સરખી હોવી જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","પવિત્ર મંડપની દક્ષિણની બાજુ માંટે 20 પટિયા બનાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","અને પ્રત્યેક પાટિયાનાં બે સાલને બેસાડવા માંટે તેની નીચે બે કૂંભી એમ કુલ 40 ચાંદીની કૂભીઓ બનાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","એ જ પ્રમાંણે મંડપની ઉત્તરની બાજુ માંટે પણ 20 પાટિયાં, ");
INSERT INTO guj2009_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","અને 40 ચાંદીની કૂભીઓ બનાવવી જેથી દરેક પાટિયા નીચે બબ્બે કૂભી આવે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","પવિત્ર મંડપની પશ્ચિમ તરફની પાછલા ભાગ માંટે છ પાટિયાં બનાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","અને મંડપના પાછલા ભાગના બે ખૂણાને માંટે તું બે પાટિયાં બનાવ. ");
INSERT INTO guj2009_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","આ ખૂણા પરનાં પાટિયાં નીચેથી એકબીજા સાથે બંધ બેસતાં હોય અને તે ઠેઠ ઉપર એક કડી બધાં પાટિયાંને સાથે રાખે. બન્ને ખુણાઓમાં એમ કરવું. બે ખૂણા માંટેનાં બે પાટિયાં આ રીતે બનાવવાં એટલે બે ખૂણા બની જશે, ");
INSERT INTO guj2009_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","આમ, આઠ પાટિયાં અને 16 ચાંદીની કૂભી હશે. પ્રત્યેક પાટિયા નીચે બબ્બે કૂભીઓ રાખજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“વળી તું બાવળના લાકડાની આડી વળીઓ બનાવજે. પવિત્ર મંડપની એક બાજુના પાટિયાંને માંટે પાંચ, ");
INSERT INTO guj2009_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ને પવિત્ર મંડપની બીજી બાજુના પાટિયાં માંટે પણ પાંચ ભૂંગળો, તેમજ પશ્ચિમ તરફથી પાછલી બાજુ માંટે પાંચ. ");
INSERT INTO guj2009_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","વચલી વળી પાટિયાની વચ્ચે તંબુના એક છેડાથી બીજા છેડા સુધી આવે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“વળી પાટિયા સોનાથી મઢાવવાં. અને વળીઓ ભેરવવા માંટે તેમાં સોનાનાં કડાં બેસાડવાં અને વળીઓને પણ તું સોનાથી મઢાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","પર્વત પર તને પવિત્ર મંડપનો જે નમૂનો મેં બતાવ્યો છે તે પ્રમાંણે તું પવિત્ર મંડપ ઊભો કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“તું ભૂરા, કિરમજી અને લાલ ઊનનો અને ઝીણા કાંતેલા શણાનો એક ખાસ પડદો તંબુમાં ભાગ પાડવા માંટે બનાવજે. એના ઉપર જરીની કલામય રીતે કરૂબ દેવદૂતોની આકૃતિઓ ભરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","સોનાની કૂંભીઓમાં બેસાડેલી બાવળની સોનાથી મઢેલી અને આંકડીઓવાળી ચાર થાંભલીઓ ઉપર તેને લટકાવવો. ");
INSERT INTO guj2009_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","એ આંકડીઓ નીચે તું પડદો લટકાવજે. અને કરારનો તકતીઓવાળો કોશ એ પડદા પાછળ મૂકજે. એ પડદો પવિત્રસ્થાનને પરમ પવિત્રસ્થાનથી જુદો પાડશે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","પરમ પવિત્રસ્થાનમાં કરારકોશ પર ઢાંકણ ઢાંકી દેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“પવિત્ર જગ્યાની અંદર પડદાની પેલી બાજુએ તે ખાસ મેજ બનાવ્યુ છે તે મુકવું. તે તંબુની ઉત્તર બાજુએ મુકવું, પછી દીવી ને દક્ષિણ તરફ બાજઠની સામે મુકવી. ");
INSERT INTO guj2009_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“વળી, તું પવિત્ર મંડપના પ્રવેશદ્વાર માંટે ભૂરા, કિરમજી અને લાલ ઊનનો અને ઝીણા કાંતેલા શણનો જરીનું સુંદર ભરતકામ કરેલો પડદો કરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","અને એ પડદા માંટે બાવળના લાકડાની સોનાથી મઢેલી અને સોનાની કડીવાળી પાંચ થાંભલી કરાવજે અને એ થાંભલીઓ માંટે કાંસાની ઢાળેલી પાંચ કૂંભીઓ બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“વેદી બાવળના લાકડાની બનાવવી, જે ચોરસ હોય અને 5 હાથ લાંબી, 5 હાથ પહોળી અને 3 હાથ ઊંચી હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ચારે ખૂણે ચાર ટોચકાં બનાવવાં, અને તે વેદીના લાકડામાંથી જ બનાવવા અને તેના ચારે બાજુથી ખુણા જોડી લેવા, જેથી તે એક બની જાય ત્યારબાદ વેદીને કાંસાથી ઢાંકી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“અને તેનાં ભસ્મપાત્રો, પાવડાંઓ, તપેલાં તથા પંજેટી તથા સગડીઓ તું બનાવજે, અને તેનાં સધળાં પાત્રો કાંસાનાં બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","અને વળી વેદી માંટે તું કાંસાની જાળી બનાવજે; તથા જાળીના ચાર ખૂણામાં તું કાંસાના ચાર કડાં બનાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","અને પછી તું એ જાળી વેદીના છાજલી નીચે એવી રીતે મૂકજે જેથી તે વેદીની ઊંચાઈને અડધે સુધી પહોંચે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“અને વેદીને માંટે તું બાવળના દાંડા બનાવજે અને તેને કાંસાથી મઢી દેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","વળી વેદીને ઊચકતી વખતે એ દાંડા વેદીની દરેક બાજુએ આવેલા કડામાં ભેરવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","વેદી પાટિયાના ખોખા જેવી પોલી બનાવજે. પર્વત પર મેં જેમ તને બતાવ્યું હતું તેમ તેઓ તેને બનાવે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“મંડપની આજુબાજુ ચોક બનાવવો. તેની દક્ષિણ બાજુએ ઝીણો કાંતેલો શણનો 100 હાથ લાંબો પડદો બનાવવો. ");
INSERT INTO guj2009_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","પડદાઓ લટકાવવા માંટે કાંસાની 20 થાંભલીઓ, કાંસાની 20 કૂંભીઓ બેસાડવી અને એ થાંભલીઓના આડા સળિયા અને આંકડા ચાંદીના બનાવવા. ");
INSERT INTO guj2009_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ચોકની ઉત્તર બાજુએ પણ એ જ પ્રમાંણે કરવાનું છે. કાંસાની કૂંભીઓમાં બેસાડેલા 20 સ્તંભો સાથે જોડેલા ચાંદીના સળિયાઓ ઉપર ચાંદીના આંકડાઓ વડે 100 હાથ લાંબા પડદાઓ લટકાવવાના છે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“એ ચોકની પશ્ચિમ બાજુને ઢાંકવા માંટે 50 હાથ લાંબા પડદા હોય અને તેને માંટે દશ થાંભલી અને દશ કૂંભીઓ હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","પૂર્વ દિશામાં પણ તે જ રીતે 50 હાથ લાંબા પડદાઓ લટકાવવા. ");
INSERT INTO guj2009_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","પ્રવેશદ્વારની એક બાજુએ 15 હાથના પડદા હોય અને તેને માંટે ત્રણ થાંભલી અને ત્રણ કૂંભી હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","અને બીજી બાજુએ પણ 15 હાથના પડદા અને ત્રણ થાંબલી અને ત્રણ કૂંભી હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“પ્રવેશદ્વારને માંટે 20 હાથ લાંબો પડદો બનાવવો. તે ઝીંણા કાંતેલા શણનો ભૂરા, જાંબુડા અને કિરમજી રંગનો, સુંદર ભરતકામવાળો બનાવવો, ચાર કૂંભીઓમાં બેસાડેલા ચાર સ્તંભો પર તેને લટકાવવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ચોકની આજુબાજુની બધી થાંભલીઓ ચાંદીના સળીયાથી જોડાયેલી હોય, તેમના સાંકળા ચાંદીના હોય અને તેમની કૂંભીઓ કાંસાની હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","આ પ્રમાંણે ચોક ઝીંણા કાંતેલા શણના કાપડનો બનશે. અને 100 હાથ લાંબો અને 50 હાથ પહોળો થશે. ચોકને ફરતા પડદાની દીવાલો 5 હાથ ઊચી થશે. પડદાઓ ઝીંણા કાંતેલા શણના હોય. તેના તળીયા કાંસાના હોવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","પવિત્ર મંડપમાં વપરાતાં તમાંમ ઓજારો, તંબુના ખીલાઓ અને બીજી વસ્તુઓ કાંસાની હોવી જોઈએ. ચોકને ફરતા પડદાઓની ખીલીઓ કાંસાની બનેલી હોવી જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“દીવી ઉપર મૂકવાના અખંડ દીવા માંટે જૈતૂનનું ધાણીએ પીલેલું ઉત્તમ તેલ લાવી આપવા ઇસ્રાએલીઓને આજ્ઞા કરો. ");
INSERT INTO guj2009_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","હારુન તથા તેના પુત્રોએ એ દીવો સંભાળવાનો છે. તેઓએ મુલાકાત મંડપની પહેલી ઓરડીમાં જવાનું છે. આ કરાર મુકેલી ઓરડીની બહાર છે, જે બંન્ને ઓરડાને અલગ કરે છે. આ જગ્યામાં તેઓ દીવો રાખશે જે સાંજથી સવાર સુધી યહોવાની સામે બળતો રહેશે. આ કાયમી વિધિનું ઇસ્રાએલીઓએ અને તેના વંશજોએ પેઢી દર પેઢી પાલન કરવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","દેવે મૂસાને કહ્યું, “ઇસ્રાએલીઓમાંથી તું તારા ભાઈ હારુનને અને તેના પુત્રો નાદાબ, અબીહૂ, એલઆઝાર, અને ઈથામાંરને અલગ કરીને માંરી સેવા કરવા માંટે યાજકો તરીકે સમર્પિત કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“તારા ભાઈ હારુનને માંટે પવિત્ર પોષાક તૈયાર કરાવજે, જેથી તેનો મોભો અને ગૌરવ જળવાય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","મેં જે કારીગરોને કુશળતા આપી છે તેઓને સૂચના આપ કે હારુન માંટે પોષાક તૈયાર કરે જેથી યાજક તરીકે તે માંરી સંમુખ સેવા કરે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","તેઓએ આ પોષાક બનાવવાનાં છે. ઉરપત્ર, એફોદ, ઝભ્ભો, સફેદ ગૂંથેલો ડગલો, પાઘડી તથા કમરબંધ; તેમણે તારા ભાઈ હારુન તથા તેના પુત્રો માંટે માંરા યાજકો તરીકે સેવા બજાવે ત્યારે પહેરવાં માંટે પવિત્ર વસ્ત્રો બનાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","એ વસ્ત્રો સોનેરી ઘેરો, ભૂરા, જાંબુડા અને કિરમજી રંગના ઊન અને ઝીણા કાંતેલા શણમાંથી જ બનાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“તેઓ એફોદ સોનેરી દોરો તથા ભૂરા, જાંબુડિયા અને કિરમજી રંગનો અને ઝીણા કાંતેલા શણનું બનાવે; સૌથી વધુ નિષ્ણાત કારીગરો તેમાંથી એફોદ તૈયાર કરે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","એના બે છેડા જોડવા માંટે એને ખભા પાસે બે સ્કંધપેટી હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“કમરબંધ પણ એવી જ બનાવટનો હોય. સોનેરી દોરો, ભૂરા, જાંબુડા અને કિરમજી રંગના ઊન અને ઝીણા કાંતેલા શણના દોરાઓમાંથી ગૂંથીને બનાવેલો હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ત્યારે ગોમેદના બે પાષાણે લેવા અને પછી તેના પર ઇસ્રાએલનાં પુત્રોનાં નામ કોતરવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","પ્રત્યેક પાષાણ પર છ નામ ઉંમરના ઉતરતા ક્રમ પ્રમાંણે આવે. આમ, તેઓના જન્મ દિવસના ક્રમમાં બારે કુળનાં નામો કોતરવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","આ મુદ્રા બનાવનાર કારીગર પાસે તારે બે પાષાણ પર ઇસ્રાએલના પુત્રોનાં નામ કોતરાવવાં અને તેમને સોનાનાં ચોકઠામાં જડવાં અને ઇસ્રાએલના પુત્રોના સ્માંરક તરીકે ઉરાવરણના ખભાના પટા સાથે જડી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","હારુને આ નામો પોતાના બે ખભા ઉપર ધારણ કરીને યહોવા પાસે જવું જેથી તેને એમનું સ્મરણ થાય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","એફોદ પર પત્થરને બેસાડવા માંટે શુધ્ધ સોનાનો ઉપયોગ કરવો. ઉપર તારે સોનાનાં ચોકઠાં લગાડવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","અને દોરીની જેમ વણેલી શુદ્ધ સોનાની બે સાંકળી બનાવવી અને તે ચોકઠાં સાથે જોડી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“પછી ખૂબ કાળજીપૂર્વક એફોદ બનાવવામાં ઉપયોગી એવી કારીગરીવાળું ન્યાયકરણનું ઉરપત્ર બનાવવું, એ સોનરી દોરો, ભૂરા, જાંબુડિયા અને લાલ ઊનનું તેમ જ ઝીણા કાંતેલા શણનું હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","જે સમચોરસ તથા બેવડું વાળેલું હોય, તે એક વેંત લાંબુ અને એક વેંત પહોળું હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","વળી તેમાં ચાર હારમાં નંગ જડવા, પહેલી હારમાં માંણેક, પોખરાજ અને લાલ હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","બીજી હારમાં લીલમ, નીલમ તથા હીરો હોય; ");
INSERT INTO guj2009_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ત્રીજી હારમાં શનિ, અકીક, અને યાકૂત હોય, ");
INSERT INTO guj2009_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","અને ચોથી હારમાં પીરોજ, ગોમેદ તથા યાસપિસ હોય. આ બધાને સોનામાંજ જડવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","પ્રત્યેક પથ્થર પર ઇસ્રાએલના બારમાંના એક પુત્રનું નામ કોતરાવવું. પ્રત્યેક પાષાણ ઇસ્રાએલના એક કુળસમૂહનું પ્રતીક બનશે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ઉરપત્ર માંટે દોરીની જેમ વણેલી શુદ્ધ સોનાની સાંકળીઓ કરાવવી, તે સાંકળીઓ વડે ઉરપત્રનો ઉપરનો છેડો એફોદ સાથે જોડવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","વળી બે સોનાની કડી કરાવવી અને તે ઉરપત્રને ઉપરને છેડે જોડી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","અને એ બે કડીઓ સાથે પેલી બે સોનાની સાંકળી જોડી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","સાંકળીના બીજા બે છેડા બે ચોકઠાં સાથે જોડી દેવા, અને એ રીતે એફોદની ખભાપટીઓના આગલા ભાગ ઉપર તેમને જોડી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","પછી સોનાની બીજી બે કડીઓ બનાવવી અને ઉરપત્રમાં અંદરની બાજુએ નીચેના છેડે લગાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","કમરબંધ પર આવતા એફોદના આગળના ભાગના નીચેના છેડા ઉપર સોનાની બીજી બે કડીઓ લગાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ઉરપત્રનો નીચેનો ભાગ ભૂરા રંગની પટ્ટીઓ વડે એફોદના નીચેના છેડા પર આવેલી કડીઓ સાથે જોડવી. આમ કરવાથી ઉરપત્ર એફોદથી છૂટું પડી જશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“જ્યારે હારુન પવિત્ર સ્થાનમાં પ્રવેશે, ત્યારે તેની પાસે ન્યાયકરણના ઉરપત્ર પર ઇસ્રાએલના બાર પુત્રોનાં નામ ધારણ હોવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","અને હંમેશા તેઓ દેવની યાદીમાં રહેશે. ઉરીમ અને તુમ્મીમને ન્યાયકરણના ઉરપત્રમાં મૂકવા. તે હારુન જ્યારે યહોવા સમક્ષ જાય, ત્યારે તેઓ તેની છાતી પર રહે. આ રીતે હારુન હંમેશા ઇસ્રાએલીઓના ન્યાય કરવાનું સાધન પોતાની સાથે રાખશે જ્યારે તે યહોવા સમક્ષ રહેશે ત્યારે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“એફોદનો જામો આખો ભૂરા રંગના કાપડનો બનાવવો, ને તેની વચમાં માંથા માંટે એક કાણું રાખવું. ");
INSERT INTO guj2009_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","એ કાણાની કોર ચામડાના ડગલાનાં ગળાની જેમ ફરતેથી ગૂંથીને ઓટી લેવી, જેથી તે ફાટી જાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","અને ડગલાની નીચેની કિનારીએ ભૂરા, જાંબુડા અને કિરમજી રંગના દાડમનું ભરતકામ કરાવવું. અને બે દાડમોની વચમાં સોનાની ઘૂઘરીઓ મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","જેથી નીચલી કોર ઉપર ફરતે પહેલાં સોનાની ઘૂઘરી, પછી દાડમ, ફરી ઘૂઘરી, પછી દાડમ એ રીતે હાર થઈ જાય. હારુન જ્યારે યાજક તરીકે સેવા કરે ત્યારે એ પહેરે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","જ્યારે તે પવિત્રસ્થાનમાં યહોવાના સાન્નિધ્યમાં જાય અથવા ત્યાંથી બહાર આવે, ત્યારે એ ઘૂઘરીઓનો અવાજ સંભળાશે, જેથી તે મૃત્યુ પામશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“પછી શુદ્ધ સોનાનું એક પત્ર બનાવવું અને તેના પર ‘યહોવાને સમર્પિત’ એમ કોતરાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","એ પત્ર પાધડીના આગળના ભાગમાં ભૂરી દોરી વડે બાંધવું. ");
INSERT INTO guj2009_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","હારુને એ પોતાના કપાળ પર ધારણ કરવું જેથી ઇસ્રાએલીઓ જે દાન આપે તેમાં કોઈ દોષ હોય તો તે દોષ હારુન પોતાને માંથે લઈ લે. અને હારુને તે કાયમ પોતાના કપાળ પર પહેરી રાખવું જેથી યહોવા એ પવિત્ર દાનથી પ્રસન્ન રહે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“હારુનનો ડગલો ઝીણા કાંતેલા શણનો બનાવવો અને પાઘડી પણ ઝીણા કાંતેલા શણની જ બનાવવી અને કમરપટા ઉપર સુંદર જરીકામ કરેલું હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","હારુનના પ્રત્યેક પુત્રોને માંટે તેને માંન અને આદર આપવા જામો, કમરબંધ અને પાઘડી બનાવવા જેથી તેનો મોભો અને ગૌરવ જળવાય. ");
INSERT INTO guj2009_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","હારુન અને તેના પુત્રોને આ પોષાક પહેરાવ અને તેઓને સેવા માંટે અર્પણ કર. તેઓને માંથા ઉપર જૈતતેલનો અભિષેક કરીને યાજકપદ માંટે પવિત્ર કર. તેઓ માંરી યાજકો તરીકે સેવા કરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“તેઓને માંટે કમરથી તે સાથળ સુધી પહોંચે એવા જાંધિયા બનાવવા, જેથી તેઓનું નાગાપણુ કોઈની નજરે ન પડે. ");
INSERT INTO guj2009_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","હારુન અને તેના પુત્રો જ્યારે પણ મુલાકાત મંડપમાં અથવા પવિત્રસ્થાનમાંની વેદી પાસે જાય, ત્યારે તેઓ હંમેશા જાંધિયા પહેરે, જેથી તેઓ દોષમાં ન પડે અને તેઓ મૃત્યુ ન પામે. હારુન અને તેના વંશજો માંટે આ કાયમી કાનૂન સદાને માંટે છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","દેવે મૂસાને કહ્યું, “યાજકો તરીકે હારુન અને તેના પુત્રોના સમર્પણ માંટેની દીક્ષા વિધિ આ પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ખોડ વિનાના બે ઘેટાં અને એક જુવાન બળદ લેવો. બેખમીર રોટલી, તેલથી મોહેલી બેખમીર ભાખરી, અને તેલ ચોપડેલી બેખમીર રોટલી લેવી. આ બધું ઘઉના મેદાનું બનાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","તેઓને ટોપલીમાં મૂકવાં અને જુવાન બળદ અને બે ઘેટાં સાથે તે લાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“ત્યારબાદ હારુન અને તેના પુત્રોને મુલાકાત મંડપમાં દ્વાર પાસે લાવીને તેમને સ્નાન કરાવ. ");
INSERT INTO guj2009_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","પછી હારુનને જામો, ભરતકામવાળો ઝભ્ભો, એફોદ, ઉરપત્ર અને કમરબંધ પહેરાવ. ");
INSERT INTO guj2009_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","અને તેના માંથા પર પાઘડી મૂકાને તેની સાથે દીક્ષાનો પવિત્ર મુગટ બાંધ. ");
INSERT INTO guj2009_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","પછી અભિષેકનું તેલ લઈ તે તું તેના માંથા પર રેડી, તેનો અભિષેક કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“ત્યારબાદ તેના પુત્રોને લાવી, તેમને ડગલા પહેરાવવા કમરે કમરબંધ બાંધવા તથા માંથે ફેંટા બાંધવા. ");
INSERT INTO guj2009_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","માંરા શાશ્વત કાનૂનનુસાર તેઓ યાજકપદે કાયમ રહેશે. આ રીતે હારુનની અને તેના પુત્રોની યાજકપદે પ્રતિષ્ઠા કરવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ત્યારબાદ બળદને મુલાકાતમંડપની આગળ લઈ આવવો. અને હારુન અને તેના પુત્રોએ તેના માંથા ઉપર હાથ મૂકવા. ");
INSERT INTO guj2009_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","પછી યહોવાની સંમુખ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ બળદનો વધ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","બળદનું થોડું લોહી લઈને આંગળી વડે વેદીનાં ટોચકાંઓને લગાડવું, પછી બાકીનું બધું લોહી વેદીના પાયા આગળ રેડી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","પછી અંદરના ભાગો પર આવેલી બધીજ ચરબી લેવી, પિત્તાશય અને બે મૂત્રપિંડની ઉપર આવેલી ચરબી પણ લઈ લેવી અને વેદી પર તેનું દહન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","પરંતુ બળદના માંસને, ચામડીને અને તેના અંદરના અવયવોને છાવણીની બહાર અગ્નિથી બાળી મૂકવાં. તે પાપાર્થાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ત્યારબાદ એક ઘેટો લેવો. હારુને અને તેના પુત્રોએ તેના માંથ પર હાથ મૂકવા. ");
INSERT INTO guj2009_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","પછી એ ઘેટાનો વધ કરીને, તેનું લોહી લઈને વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","પછી તે ઘેટાંને કાપીને કકડા કરવા. અને તેનાં આંતરડાં તથા પગ ધોઈ નાખવાં અને પછી તેઓને માંથા અને શરીરના બીજા અવયવો સાથે મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","પછી આખા ઘેટાંનું વેદી પર દહન કરવું એ યહોવાના માંનમાં આપેલ દહનાર્પણ છે. એની સુવાસથી હું પ્રસન્ન થાઉં છું, એ માંરા માંનમાં કરેલો હોમયજ્ઞ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“હવે પછી બીજો ઘેટો લેવો. હારુને અને તેના પુત્રોએ તેના માંથા પર હાથ મૂકવા. ");
INSERT INTO guj2009_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","પછી તે ઘેટાનો વધ કરીને તેનું થોડું લોહી લઈને હારુન અને તેના પુત્રોના જમણા કાનની બૂટને, જમણા હાથના અંગૂઠાને તથા જમણા પગના અંગૂઠાને લગાડવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ત્યારબાદ બાકીનું લોહી વેદીની ચારે બાજુ છાંટી દેવું, વેદી ઉપરના લોહીમાંથી થોડું લોહી અને અભિષેકનું તેલ લઈ હારુન અને તેનાં વસ્ત્રો પર તથા તેના પુત્રો અને તેમનાં વસ્ત્રો પર છાંટવું એટલે આમ તેઓ તથા તેઓનાં વસ્ત્રો યહોવાને અર્થે પવિત્ર ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“પછી ઘેટાંના ચરબીવાળા ભાગ લેવા; તેની પૂંછડી, અંદરના અવયવો પરની ચરબી, કાળજા પરની ચરબી, ચરબી સાથે જ મૂત્રપિંડો અને જમણી જાંધ. કારણ કે હારુન અને તેના દીકરાઓની દીક્ષા માંટેનો આ ઘેટો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","યહોવા આગળના બેખમીર રોટલીના ટોપલામાંથી એક રોટલી, એક મોવણવાળી ભાખરી અને એક તેલ ચોપડેલી રોટલી લેવી. ");
INSERT INTO guj2009_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","એ બધું હારુનના અને તેના પુત્રોના હાથ પર મૂકવું અને એના વડે યહોવાની ઉપાસના કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","પછી તેઓના હાથમાંથી તું તે લે અને યહોવા સમક્ષ દહનાર્પણ તરીકે વેદી પર તેનું દહન કરવું. એની સુવાસથી હું પ્રસન્ન છું. એ માંરા માંનમાં કરેલું દહનાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“પછી હારુનની દીક્ષા માંટે વપરાયેલા ઘેટાની છાતી લઈને તેના વડે યહોવાની ઉપાસના કરવી પછી એ તારો હિસ્સો ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","હારુન અને તેના પુત્રોની દીક્ષા માંટે વપરાયેલા, જેના વડે ઉપાસના કરી છે તે, અને ભેટ ધરાવેલી છાતી અને જાંધ તારે યાજકો માંટે અલગ રાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","માંરા શાશ્વત નિયમાંનુસાર એ હારુનને અને તેના પુત્રોને ઇસ્રાએલીઓ તરફથી મળવો જોઈતો હિસ્સો છે; કારણ કે ઇસ્રાએલીઓએ શાંત્યર્પણમાંથી યહોવાને ધરાવેલી એ ભેટ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“હારુનનાં આ પવિત્ર વસ્ત્રો સાચવી રાખવાં. હારુનના મૃત્યુ બાદ તેના પુત્રોને વારસામાં મળે. પેઢી દર પેઢી તેઓ તેમની પોતાની અભિષેકની દીક્ષા વિધિ વખતે તે પહેરે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","હારુન પછી જે કોઈ મુખ્ય યાજક થાય તે મુલાકાત મંડપમાં અને પવિત્રસ્થાનમાં સેવા શરૂ કરે તે અગાઉ સાત દિવસ સુધી આ વસ્ત્રો ધારણ કરે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“દીક્ષા માંટે અર્પણ કરાયેલ ઘેટાનું માંસ લઈને કોઈ પવિત્રસ્થાને તેને બાફવું; ");
INSERT INTO guj2009_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ત્યારબાદ હારુન અને તેના પુત્રોએ મુલાકાતમંડપમાં પ્રવેશદ્વાર આગળ એ ઘેટાનું માંસ અને ટોપલામાંની રોટલીનું ભોજન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","તેમની દીક્ષાવિધિ વખતે તેમની પ્રાયશ્ચિત વિધિ માંટે ઉપયોગમાં લેવાયેલ પદાર્થો જ ખાવા; યાજકો સિવાય અન્ય કોઈ પણ વ્યક્તિએ તે ખાવા નહિ. કારણ એ પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","સવાર સુધી જો માંસ કે રોટલીમાંથી કાંઈ વધે તો તેને અગ્નિમાં બાળી મૂકવું, ખાવું નહિ, કારણ એ પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“હારુન અને તેના પુત્રોને બાબતમાં મે આજ્ઞા કરી છે તે મુજબ જ કરવું. એમની દીક્ષાની વિધિ સાત દિવસ ચલાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","દરરોજ પ્રાયશ્ચિત વિધિ માંટે એક બળદનું બલિદાન આપવું. વેદી ઉપર પ્રાયશ્ચિતવિધિ કરવાથી તું એને પાપમુકત કરશે. ત્યાર પછી તારે વેદી પર તેલનો અભિષેક કરી અને પવિત્ર બનાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","સાત દિવસ સુધી વેદીને શુધ્ધ અને પવિત્ર બનાવવી. ત્યાર બાદ વેદી સંપૂર્ણપણે અત્યંત પવિત્ર બનશે, એના પછી વેદી જ અત્યંત પવિત્ર બનશે. અને જો કોઈ તેના સંપર્કમાં આવશે તે પવિત્ર બની જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“તારે વેદી પર આટલી બલિ ચઢાવવી: પ્રતિદિન કાયમને માંટે એક વર્ષની ઉંમરના બે હલવાન અર્પણ કરવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","એક સવારે અને બીજું સાંજે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","પ્રથમ ઘેટા સાથે તમાંરે એક કિલો શુદ્ધ તેલમાં મોહેલો એક કિલો ઝીણો ઘઉંનો લોટ તેમજ પેયાર્પણ તરીકે એક લીટર દ્રાક્ષારસ અર્પણ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","સાંજે અર્પણ થતા હલવાનની સાથે સવારની જેમ ઝીણા ઘઊનાં લોટનું અને દ્રાક્ષારસનું અર્પણ કર. દેવની સમક્ષ તે સુવાસિત અર્પણ અને અગ્નિમાં થયેલ અર્પણ લેખાશે. એ યજ્ઞની સુવાસથી હું પ્રસન્ન થાઉં છું. ");
INSERT INTO guj2009_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“આ દહનાર્પણ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ માંરી નજર સમક્ષ નિયમિત પેઢી-દર પેઢી આપવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","હું ત્યાં જ તમને મળીશ; અને ત્યાં જ હું ઇસ્રાએલીઓને પણ મળીશ. અને માંરા મહિમાંથી એ સ્થાન પવિત્ર થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“હા, હું મુલાકાતમંડપને, વેદીને અને યાજકો તરીકે માંરા સેવકો હારુન તથા તેના પુત્રોને પવિત્ર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","અને હું ઇસ્રાએલના લોકો મધ્યે નિવાસ કરીશ અને તેમનો દેવ થઈશ. ");
INSERT INTO guj2009_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","તેઓને ખાતરી થશે કે તેમની વચ્ચે રહેવા માંટે તેમને મિસરમાંથી બહાર લાવનાર હું યહોવા તેઓનો દેવ છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","દેવે મૂસાને કહ્યું, “ધૂપદાની માંટે તારે એક વેદી બનાવવી. એ બાવળના લાકડાની બનાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","તે એક હાથ ઊચી અને એક હાથ સમચોરસ બનાવવી અને વેદીના લાકડામાંથી જ કોતરીને તેનાં શિંગ બનાવવા, શિંગ જુદા બનાવીને વેદી પર જોડવા નહિ. તે વેદી સાથે એક નંગ હોવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","વેદીનો ઉપરનો ભાગ, બાજુઓ અને શિંગ શુદ્ધ સોનાથી મઢી લેવો અને આખી વેદીની ચારે બાજુ સોનાની કિનારી બનાવવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","એની બે સામસામી બાજુઓએ કિનારીની નીચે ઉપાડવાના દાંડા ભેરવવા માંટે સોનાનાં બબ્બે કડાં મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","એ બે દાંડા બાવળના લાકડાના બનાવવા અને સોનાથી મઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","દશ આજ્ઞાઓ જેમાં મૂકી છે તે સાક્ષ્યકોશ આગળના પડદા સામે એ વેદી મૂકવી ત્યાં હું તેમને દર્શન દઈશ. ");
INSERT INTO guj2009_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“એ વેદી પર પ્રતિદિન સવારે દીવાબત્તી તૈયાર કરતી વખતે હારુને સુગંધી ધૂપ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","અને રોજ સાંજે તે દીવાઓ પ્રગટાવે ત્યારે યહોવાની સંમુખ ધૂપ કરવો. તારે પેઢી-દર-પેઢી કાયમ યહોવા સમક્ષ ધૂપ કરવો, ");
INSERT INTO guj2009_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","તારે એ વેદી પર નિષિદ્ધ ધૂપ કરવો નહિ, કે દહનાર્પણ કે ખાધાર્પણ કે પેયાર્પણ અર્પણ કરવાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“વર્ષમાં એક વાર હારુને પ્રાયશ્ચિતને માંટે પાપાર્થાર્પણનું રકત લઈને શિંગ ઉપર લગાડી વેદીને પવિત્ર કરવાની છે. પેઢી-દર-પેઢી નિયમિત રીતે આ વાર્ષિક વિધિનું પાલન કરવું, કારણ કે આ વેદી યહોવાની પરમપવિત્ર વેદી છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“તું જ્યારે ઇસ્રાએલીઓની વસ્તીગણતરી કરે ત્યારે જે પુરુષોનું નામ નોંધાય તેણે જ પોતાના જીવન માંટે યહોવા સમક્ષ ખંડણી ભરવી, જેથી તું ગણતરી કરે ત્યારે લોકો પર કોઈ આફત ન આવે. ");
INSERT INTO guj2009_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","વસ્તીગણતરીમાં નોંધાયેલા દરેક માંણસો ખંડણી પેટે અડધો શેકેલ યહોવાને અર્પણ તરીકે આપવો. (એટલે અધિકૃત માંત્રામાં અડધો શેકેલ જે 20 ગેરાહનું વજન હોય છે). ");
INSERT INTO guj2009_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","વસ્તીગણતરીમાં નોંધાયેલા વીસ વરસના કે તેથી વધુ ઉમરના દરેક માંણસે આ જકાત આપવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","મને તમાંરા જીવનના બદલામાં આ જકાત આપતી વખતે ધનવાને વધારે કે ગરીબે ઓછું આપવાનું નથી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ઇસ્રાએલીઓ પાસેથી મળેલાં જીવનના બદલામાં ચૂકવાતાં પ્રાયશ્ચિતના નાણાં મુલાકાતમંડપની સેવામાં ખર્ચવાં. આ અર્પણ યહોવાને ઇસ્રાએલી લોકોની યાદ અને તેમના જીવનની કિંમત તરીકે આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“હાથપગ ધોવા તારે કાંસાની ઘોડીવાળી એક કાંસાની કૂડી બનાવવી, અને તેને વેદી અને મુલાકાતમંડપની વચ્ચે મૂકી તેમાં પાણી ભરવું. ");
INSERT INTO guj2009_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","હારુને અને તેના પુત્રોએ હાથપગ ધોવામાં એ પાણીનો ઉપયોગ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","જો તેમણે એ પાણીથી હાથપગ ધોયા હશે તો તેઓ મુલાકાતમંડપમાં સેવા કરવા જશે અથવા બલિ ચઢાવવા વેદી પાસે જશે ત્યારે તેઓ મૃત્યુ પામશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","તેઓ મૃત્યુ ન પામે તેટલા માંટે તેમણે અચૂક હાથપગ ધોવા. આ શાશ્વત કાનૂન તેમણે અને તેમના વંશજોએ પેઢી દર પેઢી પાળવાનો છે. હારુન અન તેના પુત્રો માંટે આ સૂચનાઓ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“શ્રેષ્ઠ ગુણવત્તાવાળી સુગંધીઓ લેવી, 12 પૌંડ ચોખ્ખો બોળ, 6 પૌંડ સુગંધીદાર તજ, 6 પૌંડ સંગધીદાર બરુ ");
INSERT INTO guj2009_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","અને 12 પૌંડ દાલચીનીએ બધું પવિત્રસ્થાનના વજન પ્રમાંણે લેવું. અને એક ગેલન જૈતૂનનું તેલ લેવું. ");
INSERT INTO guj2009_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“નિષ્ણાંત સુગંધીઓ બનાવનારાઓ પાસે આ સર્વ પદાર્થોનું મિશ્રણ કરીને અભિષેકનું તેલ તૈયાર કરાવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","તારે મુલકાતમંડપને, કરારકોશનો, ");
INSERT INTO guj2009_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","બાજઠ અને તેની બધી સામગ્રીઓનો, દીવીનો અને તેનાં સાધનોનો, ધૂપની વેદીનો, ");
INSERT INTO guj2009_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","દહનાર્પણની વેદીનો અને તેનાં સાધનોનો તથા ઘોડી સહિત હાથપગ ધોવાની કૂંડીનો અભિષેક કરવો. ");
INSERT INTO guj2009_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","આ પ્રમાંણે આ બધી વસ્તુઓની શુદ્ધિ કરવી એટલે તે બધી પરમપવિત્ર બની જશે. અને જે કોઈ તેમને અડકે તે પવિત્ર થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ત્યાર પછી તારે હારુનને અને તેના પુત્રોને અભિષેક કરી માંરા યાજકો તરીકે દીક્ષા આપવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","તારે ઇસ્રાએલીઓને કહેવું, તમાંરે પેઢી દર પેઢી આ અભિષેકના તેલના પવિત્રતા સાચવી રાખવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","સામાંન્ય માંણસોને શરીરે એ ન લગાડવું. અને એ નુસખા પ્રમાંણે બીજું તેલ બનાવવું નહિ એ પવિત્ર છે અને તમાંરે એને પવિત્ર ગણીને ચાલવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","જે કોઈ આ સુગંધીઓનું મિશ્રણ કરી આવું તેલ બનાવે અથવા જે યાજક નથી તેવી કોઈ વ્યક્તિ ઉપર તે રેડે તેને સમાંજમાંથી જુદો કરવામાં આવે.” ");
INSERT INTO guj2009_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","યહોવાએ મૂસાને ધૂપ બનાવવા માંટે આ સૂચનાઓ આપી: ");
INSERT INTO guj2009_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","“તારે રાજન, કેરબા, શિલારસ, અને શુદ્ધ લોબાન સરખે ભાગે લઈ તે મિશ્રણમાંથી સુગંધી ધૂપ બનાવવો, તેને સરૈયો બનાવે તેવીજ રીતે બનાવવો. એ ધૂપને શુધ્ધ અને પવિત્ર રાખવા તેમાં મીઠુ મેળવવું. ");
INSERT INTO guj2009_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","એમાંથી થોડો ઝીણો ખાંડીને તેનો ઉપયોગ મુલાકાતમંડપમાં કરારકોશ આગળ, જયાં હું તને દર્શન આપવાનો છું ત્યાં કરવો. તમાંરે આ ધૂપને અત્યંત પવિત્ર સમજવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","આ નુસખા પ્રમાંણેનો ધૂપ તમાંરે પોતાના ઉપયોગ માંટે બનાવવાનો નથી. તમાંરે એને માંરે માંટે જ અલગ રાખેલી પવિત્રવસ્તુ ગણવી. ");
INSERT INTO guj2009_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","જો કોઈ પોતાના ઉપયોગ માંટે તે બનાવે, તો તેનો યહોવાના સમાંજમાંથી બહિષ્કાર કરવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","વળી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“જુઓ, મેં યહૂદાના કુળસમૂહના હૂરના પુત્ર ઉરીના દીકરા બસાલએલને ખાસ પસંદ કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","મેં તેનામાં દૈવી શક્તિભરી દીધી છે અને તેને દરેક પ્રકારની કારીગરીમાં કુશળતા, સમજદારી, અને પુષ્કળ જ્ઞાન અને હોશિયારી આપી છે. ");
INSERT INTO guj2009_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","મેં તેને નવી નવી ભાતો ઉપજાવી કાઢવામાં સોનાચાંદીને કાંસાની વસ્તુઓ બનાવવામાં, ");
INSERT INTO guj2009_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","રત્નોને પહેલ પાડવામાં, લાકડામાં કોતરણી કરવામાં તથા બધી જાતના નકશીકામ કરવામાં કુશળ બનાવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","વળી તેની સાથે કામ કરવા માંટે મેં દાનના કુળસમૂહના અહી સામાંખના પુત્ર આહોલીઆબને પસંદ કર્યો છે, તથા બીજા બધા કુશળ કારીગરોને પણ મેં કુશળતા આપી છે. જેથી તેઓ મેં તને જે જણાવ્યું તે બધી વસ્તુઓ બનાવી શકે: ");
INSERT INTO guj2009_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","મુલાકાત મંડપ, કરારકોશ, તેનું ઢાંકણું, મંડપનું બધું રાચરચીલું; ");
INSERT INTO guj2009_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","બાજઠ અને તેનાં સાધનો, શુદ્ધ સોનાની દીવી અને તેનાં સાધનો, ધૂપ કરવાની વેદી, ");
INSERT INTO guj2009_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","દહનાર્પણની વેદી અને તેનાં બધાં સાધનો, હાથપગ ધોવાની કૂંડી અને તેની ધોડી. ");
INSERT INTO guj2009_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","યાજક હારુન અને તેના પુત્રો માંટે સેવા સમયે પહેરવાનાં પવિત્ર પોષાક, ");
INSERT INTO guj2009_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","અભિષેક માંટેનું તેલ અને પવિત્રસ્થાનક માંટેનો સુગંધીદાર ધૂપ. તેમણે આ બધી જ સામગ્રી મેં જણાવ્યું છે તે પ્રમાંણે બરાબર બનાવવી.” ");
INSERT INTO guj2009_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ઇસ્રાએલના લોકોને કહે, ‘સાબ્બાથ દિને વિશ્રામ કરે. કારણ કે “સાબ્બાથ” માંરી અને તમાંરી વચ્ચે બધી પેઢીઓ માંટે નિશાની છે. એ તમને યાદ આપશે કે મેં તમને માંરી ખાસ પ્રજા તરીકે બનાવ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘આથી તમાંરે વિશ્રામવારનું પાલન કરવાનું છે, કારણ કે તમાંરા માંટે એ પવિત્ર દિવસ છે, જે કોઈ એની પવિત્રતાનો ભંગ કરે, તેને મોતની સજા કરવી જે કોઈ વિશ્રામવારે કામ કરે તેનો સમાંજમાંથી બહિષ્કાર કરજો. ");
INSERT INTO guj2009_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","તમને છ દિવસ કામ કરવાની છૂટ છે, પણ સાતમે દિવસ સંપૂર્ણ વિશ્રામનો દિવસ છે, એ મને સમર્પિત થયેલો પવિત્ર દિવસ છે. જે કોઈ તે દિવસે કામ કરે તેને મોતની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ઇસ્રાએલના લોકોએ માંરી અને તેમની વચ્ચેના કરારની સ્મૃતિ તરીકે વિશ્રામવાર પેઢી દર પેઢી પાળવાનો છે. કારણ કે, ");
INSERT INTO guj2009_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","સાબ્બાથ માંરી અને ઇસ્રાએલી લોકોની વચ્ચે હમેશની નિશાની રહેશે,’” કેમકે મેં, યહોવાએ છ દિવસ સુધી આકાશ અને પૃથ્વીની રચના કરી અને સાતમે દિવસે મેં કામ બંધ કર્યુ અને વિશ્રામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","સિનાઈના પર્વત ઉપર મૂસા સાથેનો વાર્તાલાપ પૂર્ણ કરીને યહોવાએ તેને બે સ્માંરક તકતીઓ અર્પણ કરી; એ પથ્થરની તકતીઓ દેવની આંગળી વડે લખાયેલ દશ આજ્ઞાઓવાળી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","મૂસાને પર્વત પરથી આવવામાં વિલંબ થતો જોઈને લોકોએ હારુન પાસે ભેગા થઈને કહ્યું, “ચાલ, અમને દોરવણી આપવા માંટે દેવ બનાવ. કારણ કે મિસરમાંથી અમને અહીં લઈ આવનાર મૂસા હવે અદ્રશ્ય થઈ ગયો છે; તેનું શું થયું એની અમને ખબર પડતી નથી.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","એટલે હારુને તેમને કહ્યું, “તમાંરી પત્નીઓ અને પુત્રપુત્રીઓના કાનમાંથી સોનાની કડીઓ કાઢી માંરી પાસે લાવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","તેથી તેઓએ પુરુષો; સ્ત્રીઓ, છોકરાઓ અને છોકરીઓએ તેમ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","હારુને કડીઓ લઈને તે ઓગાળી અને ધાતુના બીબામાં ઢાળીને એક વાછરડાંની મૂર્તિ બનાવી એટલે લોકો બોલી ઊઠયા, “ઇસ્રાએલીઓ! આ રહ્યા તમાંરા દેવ, જે તમને મિસર દેશમાંથી બહાર લઈ આવ્યા હતા.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","હારુને જોયું કે લોકો બહુ આનંદમાં આવી ગયા છે, તેથી તેની આગળ હારુને વેદી બાંધી અને એવી જાહેરાત કરી કે, “આવતી કાલે યહોવાના માંનમાં ઉત્સવ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","બીજે દિવસે સવારમાં વહેલા ઊઠીને લોકોએ દહનાર્પણો અને શાંત્યર્પણો ચઢાવ્યાં અને ત્યાર પછી તેઓએ ખાધું પીધું અને મોજમજા કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","પછી યહોવાએ મૂસાને કહ્યું, “તરત નીચે જા, કારણ, તારા લોકો, જેમને તું મિસરમાંથી બહાર લઈ આવ્યો છે, તેઓ એ ભયંકર પાપ કર્યુ છે. ");
INSERT INTO guj2009_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","મેં તેમને જે માંર્ગે ચાલવાની આજ્ઞા કરી હતી તેનાથી આટલા વહેલા તેઓ ફરી ગયા છે. તેમણે પોતાના માંટે એક વાછરડાની મૂર્તિ બનાવી છે અને તેને પગે લાગીને તેને ભોગ ધરાવીને એમ બોલ્યા છે કે, ‘હે ઇસ્રાએલના પુત્રો, આ રહ્યા તમાંરા દેવ, જે તમને લોકોને મિસરમાંથી બહાર લઈ આવ્યા હતા.’” ");
INSERT INTO guj2009_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","પછી યહોવાએ કહ્યું, “મને ખબર પડી છે કે આ લોકો કેટલા બધા હઠીલા અને બળવાખોર છે. ");
INSERT INTO guj2009_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","એટલે હવે તમે મને અટકાવશો નહિ, એમના પર માંરો ક્રોધ ભભૂકી ઊઠયો છે અને હું તેમનો નાશ કરીશ, અને તેઓના સ્થાને હે મૂસા, હું તમાંરામાંથી મહાન પ્રજા પેદા કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","પરંતુ મૂસાએ યહોવા દેવને વિનંતી કરી કે તે તેમ ન કરે; તેણે આજીજી કરીને કહ્યું, “હે દેવ યહોવા, શા માંટે તારે તારા આ લોકો ઉપર ક્રોધ કરવો જોઈએ? તું તો એ લોકોને તારા બાહુના અપૂર્વ સાર્મથ્યથી મિસરમાંથી બાહર લાવ્યો હતો; ");
INSERT INTO guj2009_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","શું તમે એમ ઈચ્છો છો કે મિસરવાસીઓ કહે, ‘દેવ તેઓને ફસાવીને પર્વતો મધ્યે લઈ ગયા છે, જેથી તે તેઓનો સંહાર કરે, અને પૃથ્વીની સપાટી પરથી સદંતર સમાંપ્ત કરે?’ તમાંરા ક્રોધને ઠંડો પાડો અને તમાંરા લોકોનું ખોટું કરવાનું છોડી દો. ");
INSERT INTO guj2009_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","તમાંરા સેવકો, ઈબ્રાહિમ, ઈસહાક અને ઇસ્રાએલને આપેલું તમાંરું વચન યાદ કરો. અને તમે વચન કહ્યું હતું, ‘આકાશના તારા જેટલા હું તારા સંતાન વધારીશ. અને તારા વંશજોને જે દેશ આપવાનું મેં વચન આપ્યું છે તે સમગ્ર દેશ હું તેઓને આપીશ, તેઓનો સદાનો વારસો થશે. અને તેઓ સદાસર્વદા તેના વારસદાર બનશે.’” ");
INSERT INTO guj2009_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","તેથી યહોવાએ પોતાના લોકોનું ખોટું કરવાનો જે વિચાર કર્યો હતો તે જતો કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","પછી મૂસા પાછો ફરીને કરારની બંને તકતીઓ હાથમાં લઈને પર્વત પરથી નીચે ઊતર્યો. તકતીઓની બંને બાજુએ દશ આજ્ઞાઓ લખેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","તે તકતીઓ દેવે બનાવેલી હતી અને તેના ઉપરનું લખાણ પણ દેવે કોતરીને લખેલું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","નીચે તળેટીમાં લોકોની બૂમાંબૂમનો અવાજ સાંભળીને યહોશુઆએ મૂસાને કહ્યું, “એવું લાગે છે કે એ લોકો યુદ્ધની તૈયારી કરી રહ્યા હોય!” ");
INSERT INTO guj2009_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","પણ મૂસાએ કહ્યું, “આ કોઈ વિજયનો નાદ નથી તેમ પરાજયનો પોકાર પણ નથી. આ તો ગાવાનો અવાજ સંભળાય છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","જ્યારે તેઓ છાવણી પાસે આવ્યા ત્યારે મૂસાએ વાછરડું અને નાચગાન જોયાં, મૂસાનો ક્રોધ ભભૂકી ઊઠયો અને તેણે પર્વતની તળેટીમાં હાથમાંની તકતીઓ નીચે પછાડીને ચૂરેચૂરા કરી નાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","પછી તે લોકોએ જે વાછરડું બનાવ્યું હતું તે લઈને તેણે અગ્નિમાં ઓગળાવી નાખ્યું. પછી તેનો વાટીને ભૂકો કરી નાખ્યો અને તે પાણીમાં ભભરાવી ઇસ્રાએલીઓને પાઈ દીધો. ");
INSERT INTO guj2009_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","પછી હારુન તરફ ફરીને તેણે કહ્યું, “આ લોકોએ તમાંરું શું બગાડ્યું છે કે તમે એ લોકોને આવા મોટા પાપમાં નાખ્યાં?” ");
INSERT INTO guj2009_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","હારુને કહ્યું, “ગુસ્સે ના થાઓ, ભાઈ એ લોકો કેવા દુષ્ટ સ્વભાવના છે, તે તમે સારી રીતે જાણો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","એ લોકોએ મને કહ્યું, ‘અમને દોરવણી આપવા માંટે દેવો બનાવી આપો, કારણ કે અમને મિસર દેશમાંથી બહાર લાવનાર મૂસાનું શું થયું એની અમને ખબર પડતી નથી.’ ");
INSERT INTO guj2009_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","એટલે મેં તેમને કહ્યું, ‘તમાંરામાંથી જેમની પાસે સોનાનાં ઘરેણાં હોય તે ઉતારી નાખો.’ તેમણે મને આપ્યાં અને મેં તે અગ્નિમાં નાખ્યાં અને આ વાછરડું બહાર નીકળી આવ્યું.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","મૂસાએ જોયું કે હારુને લોકો પરનો પોતાનો કાબૂ જવા દીધો અને પરિણામે તેઓ જંગલીપણું કરતા હતા, અને તેઓના બધા દુશ્મનો તેઓને મૂર્ખની જેમ જોતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","છાવણીના પ્રવેશદ્વાર આગળ ઊભા રહીને તેણે મોટા અવાજે પોકાર કર્યો. “યહોવાના પક્ષમાં હોય તે માંરી પાસે આવે.” એટલે બધા લેવીઓ તેની પાસે ભેગા થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","તેણે તેઓને કહ્યું, “ઇસ્રાએલના દેવ યહોવાની આજ્ઞા છે: ‘તમે બધા પોતપોતાની તરવાર લઈને સજજ થઈ જાઓ, છાવણીમાં બધે ફરી વળો, અને તમાંરા ભાઈઓ, મિત્રો અને પડોશીઓને માંરી નાખો.’” ");
INSERT INTO guj2009_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","લેવીઓએ મૂસાના કહ્યા પ્રમાંણે કર્યું અને લગભગ 3,000 લોકો તે દિવસે કપાઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","પછી મૂસાએ કહ્યું, “આજે તમને યહોવાની દીક્ષા મળી છે, કારણ તમે પોતાના પુત્રની અને ભાઈની વિરુદ્ધ પડીને આશીર્વાદને પાત્ર બન્યા છો.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","બીજે દિવસે મૂસાએ લોકોને કહ્યું, “તમે મહાપાપ કર્યુ છે: અત્યારે હું યહોવા પાસે જાઉ છું; કદાચ હું તમાંરા પાપની માંફી મેળવી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","આમ કહીને મૂસાએ ફરી યહોવા પાસે જઈને કહ્યું, “દિલગીરી વ્યક્ત કરું છું! આ લોકોએ મોટું પાપ કર્યું છે! એમણે પોતાને માંટે સોનાના દેવ બનાવ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","તમે જો એમને માંફ કરતા હો તો માંફ કરો. નહિ તો તમાંરા ચોપડામાંથી માંરું નામ ભૂંસી નાખો.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","પરંતુ યહોવાએ મૂસાને જવાબ આપ્યો, “નહિ, જે લોકોએ માંરી વિરુદ્ધ જઈને પાપ કર્યુ છે તેમનું જ નામ હું માંરા ચોપડામાંથી ભૂસી નાખીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","પણ હવે તું જા, અને મેં તને કહ્યું છે તે જગ્યાએ આ લોકોને દોરી જા. માંરો દેવદૂત તમાંરી આગળ આગળ ચાલશે, પણ એક દિવસ એવો આવશે જ્યારે હું તેમને તેમના પાપની સજા કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","આમ, હારુને બનાવેલા વાછરડાની ઉપાસના કરવા બદલ યહોવાએ લોકોને આકરી સજા કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","યહોવાએ મૂસાને કહ્યું, “તું અહીંથી નીકળીને જે લોકોને તું મિસર દેશમાંથી બહાર લઈ આવ્યો છે, તેઓને ઈબ્રાહિમ, ઈસહાક અને યાકૂબને જે દેશનું વચન આપ્યું છે ત્યાં દોરી જા, કેમ કે મેં વચન આપેલું છે કે, આ દેશ હું તમાંરા વંશજોને આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","હું તારી આગળ માંરા એક દેવદૂતને મોકલીશ અને કનાનીઓ, અમોરીઓ, હિત્તીઓ, પરીઝીઓ, હિવ્વીઓ અને યબૂસીઓને હાંકી કાઢીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","હું દૂધ અને મધની જયાં રેલછેલ છે એવા દેશમાં તમને લઈ જઈશ, પણ હું તમાંરી સાથે નહિ આવું, કારણ કે તમે લોકો હઠીલા છો અને કદાચ હું તમાંરો રસ્તામાં જ સંહાર કરી નાખું.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","લોકોએ જયારે આ કઠોર શબ્દો સાંભળ્યા ત્યારે તેઓએ શોક કર્યો અને કોઈએ પોતાના શરીર ઉપર દાગીના પહેચાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","યહોવાએ મૂસાને કહ્યું, “ઇસ્રાએલના લોકોને કહે કે, ‘તમે લોકો હઠીલા છો, જો હું તમાંરી સાથે થોડી ઘડીવાર પણ આવું તો તમાંરો સંહાર કરી નાખું. એટલે તમે તમાંરાં દાગીના, ઘરેણાં ઉતારી નાખો, જ્યારે હું વિચારીશ કે માંરે તમાંરી સાથે શું કરવું?’” ");
INSERT INTO guj2009_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","તેથી ઇસ્રાએલીઓએ પોતાનાં ઘરેણાં ઉતારી નાખ્યાં અને હોરેબ પર્વત છોડયા પછી ફરી પહેચાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","મૂસા હંમેશા છાવણીની બહાર દૂર માંડવો ઊભો કરતો હતો અને જે કોઈને યહોવાની ઈચ્છા જાણવી હોય તે છાવણી બહાર “મુલાકાતમંડપમાં” જતો. જે મૂસાએ છાવણી બહાર ઊભો કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","મૂસા જયારે જયારે મૂલાકાતમંડપમાં જતો ત્યારે ત્યારે બધા લોકો ઊઠીને પોતપોતાના તંબુના દરવાજા આગળ ઊભા રહીને, મૂસા મૂલાકાતમંડપમાં દાખલ થાય ત્યાંસુધી તેને જોઈ રહેતા. ");
INSERT INTO guj2009_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","મૂસા જયારે માંડવા પ્રવેશ કરતો એટલે વાદળનો થંભ નીચે ઊતરી માંડવાના દરવાજા આગળ ઊભો રહેતો અને યહોવા મૂસા સાથે વાત કરતા. ");
INSERT INTO guj2009_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","વાદળના થંભને દેવ દરવાજા આગળ જોતાં જ દરેક માંણસ પોતપોતાના માંડવાના દરવાજા આગળ ભજન કરતા. ");
INSERT INTO guj2009_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","યહોવા મૂસા સાથે એક માંણસ બીજા માંણસ સાથે વાત કરે એ રીતે મોઢામોઢ વાત કરતા. ત્યાર પછી મૂસા પાછો છાવણીમાં આવતો. તેનો નવયુવાન સેવક નૂનનો પુત્ર યહોશુઆ કદી તંબુમાંથી બહાર નીકળતો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","મૂસાએ યહોવાને કહ્યું, “તમે મને આ લોકોને લઈ જવાનું તો કહ્યું પણ તમે એ મને ન કહ્યું કે, તમે માંરી સાથે કોને મોકલવાના છો, તમે મને એમ પણ કહ્યું કે, ‘હું તને નામથી ઓળખું છું અને તારાથી પ્રસન્ન છું.’ ");
INSERT INTO guj2009_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","જો ખરેખર મેં તમને પ્રસન્ન કર્યા હોય, તો મને તમાંરા માંર્ગો શીખવાડો. માંરે તમને ઓળખવા છે. તો હું તમને પ્રસન્ન કરતો રહું. વળી, યાદ રાખજે કે આ લોકો તો તમાંરી જ પ્રજા છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","યહોવાએ જવાબ આપ્યો, “હું પોતે તારી સાથે જઈશ અને તને માંર્ગદર્શન આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","કેમ કે મૂસાએ કહ્યું હતું, “તમે જો માંરી સાથે ન આવવાના હો તો અમને અહીંથી આગળ મોકલશો નહિ; ");
INSERT INTO guj2009_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","અને તમે અમાંરી સાથે આવો એ સિવાય બીજી કઈ રીતે જાણી શકાય કે તમે અમાંરા પર પ્રસન્ન છો? તમે અમાંરી સાથે આવો તો જ અમે, તમાંરા લોકો અને હું પૃથ્વી પરના બીજા બધા લોકો કરતાં જુદા તરી આવીશું.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","જવાબમાં યહોવાએ મૂસાને કહ્યું હતું, “હા, તેં જે માંગ્યું છે તે હું ચોક્કસ આપીશ. કારણ કે હું તારા પર પ્રસન્ન છું અને તને બહુ સારી રીતે જાણું છું.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","મૂસાએ વિનંતી કરી, “મને તમાંરા ગૌરવના દર્શન કરાવો.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","યહોવાએ કહ્યું, “હું માંરી સંપૂર્ણ ભલમનસાઈ તને દેખાડીશ, અને તારી સમક્ષ માંરું નામ ‘યહોવા દેવ’ તરીકે જાહેર કરીશ. હું જેને પસંદ કરીશ એ લોકો પર દયા અને કરુણા વરસાવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","વધુમાં તેમણે કહ્યું, “પણ માંરું મુખ તું જોઈ શકીશ નહિ, કારણ, કોઈ પણ માંણસ મને જોઈને જીવતો રહી શકે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“તેમ છતાં માંરી બાજુમાં આ ખડક પર ઊભો રહેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","અને માંરું ગૌરવ તારી નજર આગળથી પસાર થાય ત્યારે હું તને આ ખડકની ફાટમાં મૂકી દઈશ. અને હું પોતે પસાર થઈ જાઉં ત્યાં સુધી માંરા હાથ વડે તને હું ઢાંકી દઈશ. ");
INSERT INTO guj2009_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","પછી હું માંરો હાથ લઈ લઈશ અને તું માંરી પીઠ જોવા પામીશ, પણ માંરું મુખ તને દેખાશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","યહોવાએ મૂસાને કહ્યું, “પ્રથમના જેવી જ પથ્થરની બે તકતીઓ બનાવ, અને તારા વડે ભાંગી ગયેલી તકતીઓ ઉપર જે વચનો લખેલાં હતાં તે હું તેના પર લખીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","સવારમાં સિનાઈ પર્વત ઉપર આવવા માંટે તું તૈયાર રહેજે અને સિનાઈ પર્વતના શિખર પર ચઢી ટોચ પર માંરી રાહ જોતો ઊભો રહેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","તારી સાથે કોઈએ ઉપર આવવાનું નથી. એટલું જ નહિ, પર્વત ઉપર કોઈ માંણસ નજરે પણ ચઢવો જોઈએ નહિ, અથવા તે પર્વતની આસપાસ ઘેટાંબકરાં કે ઢોરઢાંખર પણ ચરતાં હોવા જોઈએ નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","તેથી મૂસાએ પ્રથમની તકતીઓનાં જેવી જ પથ્થરની બે તકતીઓ બનાવી અને સવારમાં તે વહેલો ઊઠયો અને યહોવાએ તેને કહ્યું હતું તે પ્રમાંણે તેના હાથમાં તકતીઓ લઈને તે સિનાઈ પર્વત ઉપર ચઢી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","પછી યહોવા મેઘસ્તંભના રૂપમાં નીચે ઊતરી આવ્યા અને તેની સાથે ઊભા રહ્યા. અને પોતાનું નામ “યહોવા” જાહેર કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ત્યારબાદ યહોવા તેની આગળથી જાહેર કરતા પસાર થયા કે, “હું યહોવા છું. હું દયાળુ અને કૃપાળુ દેવ છું. ક્રોધ કરવામાં મંદ અને કરૂણાથી ભરપૂર અને વિશ્વાસપાત્ર છું. ");
INSERT INTO guj2009_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","હું યહોવા હજારો પેઢી સુધી કરૂણા રાખું છું અને તેઓના પાપોની માંફી આપું છું. તેમ છતાં ગુનેગારને નિર્દોષ ઠરાવવા ના પાડું છું. અને પિતાના અધર્મની સજા ત્રીજી અને ચોથી પેઢી સુધી પુત્રો અને પૌત્રોને કરું છું!” ");
INSERT INTO guj2009_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","મૂસાએ એકદમ ભોંય પર લાંબા થઈને સાષ્ટાંગ નમસ્કાર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","તેણે કહ્યું, “હે યહોવા, તમે કહો છો કે તમે માંરા પર પ્રસન્ન છો તે જો સત્ય હોય તો કૃપા કરી અમાંરી સાથે આવો. આ લોકો ગમે તેટલા હઠીલા હોય તો પણ તમે અમાંરો અધર્મ અને અમાંરાં પાપ માંફ કરો અને તમાંરાં પોતાના લોકો તરીકે અમાંરો સ્વીકાર કરો.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","યહોવાએ કહ્યું, “જુઓ, હું અત્યારે જ તમાંરી સાથે આ કરાર કરનાર છું. અગાઉ પૃથ્વી પર કોઈ પણ દેશમાં ન થયા હોય તેવા ચમત્કારો હું કરીશ. તારા લોકો તે જોશે કે હું, દેવ ખૂબ મહાન છું. હું જે તારા માંટે અદભુત કાર્યો કરીશ, તે લોકો જોશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","કરારનો તારો ભાગ આ છે કે તું માંરી સર્વ આજ્ઞાઓને આધીન થા. પછી હું તમાંરી વચ્ચેથી અમોરી, કનાની, હિત્તી, પરિઝઝી, હિવ્વી અને યબૂસી લોકોને હાંકી કાઢીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","પણ સાવધાન રહેજે. તું જે દેશમાં જાય છે, ત્યાંના વતનીઓ સાથે કરાર કરવો નહિ, નહિતર તેઓ તને જાળમાં ફસાવશે. ");
INSERT INTO guj2009_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","પણ યાદ રાખો, તમાંરે તેમની વેદીઓ તોડી પાડવાની છે, તેમના પૂજાસ્તંભો તોડી નાખવાના છે. અને તેઓની અશેરાહ દેવીની મૂર્તિઓ ભાંગી નાખવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","તમાંરે અન્ય કોઈ દેવોની પૂજા કરવી નહિ કારણ કે માંરું નામ યહોવા છે માંરું નામ હું એટલે કાનાહ છું-ઈર્ષાળુ દેવ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“એ દેશના વતનીઓ સાથે કોઈ કરાર કરવો નહિ, નહિ તો તેઓ જયારે પોતાના દેવોને યજ્ઞ ચઢાવે, ત્યારે કદાચ તમને બોલાવે અને તમે એ યજ્ઞ ખાઓ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","કદાચ તમે તમાંરાં પુત્રોને તેમની પુત્રીઓ સાથે પરણાવો અને એ કન્યાઓ વ્યભિચારીની જેમ પોતાના દેવોની પૂજા કરે ત્યારે તમાંરા પુત્રોને પણ એ રસ્તે ચઢાવી દે અને પૂજા કરાવે. પછી તારા પુત્રો તેઓની પત્નીઓના દેવોની ઉપાસના કરીને માંરી વિરુદ્ધ પાપ આચરશે. ");
INSERT INTO guj2009_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“તેઓની મૂર્તિઓ સાથે કોઈ સંબંધ હોય નહિ, તેથી તમાંરે તે દેવોની મૂર્તિઓ બનાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“મેં તમને આજ્ઞા કરી છે તે મૂજબ સાત દિવસ સુધી તમાંરે આબીબ મહિનામાં નક્કી કરેલ સમયે ખમીર વગરની રોટલી ખાવી. અને તમાંરે ખમીર વગરની રોટલીનો ઉત્સવ પાળવો; કારણ કે આબીબ મહિનામાં તમે મિસર દેશમાંથી બહાર નીકળ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“બધાં પ્રથમ પ્રસવનાં સંતાન માંરાં છે; તમાંરા પશુઓનાં બધા પહેલા વેતરના નર માંરા છે, પછી એ ગાયનો હોય કે બકરીનો હોય. ");
INSERT INTO guj2009_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","જો તમે ગધેડાના પ્રથમ બચ્ચાંને રાખવા માંગતા હોય તો તેને બદલે હલવાન આપીને તેને ખરીદી શકાય. જો તું તેને ખંડી લેવા ના ઈચ્છતો હોય તો તેની ડોક ભાંગી નાખવી, અને તારા બધા જ પ્રથમજનિત પુત્રોને તારે ખંડી લેવાના છે. ભેટ લાવ્યા વિના કોઈએ માંરી સમક્ષ ખાલી હાથે આવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“છ દિવસ તમાંરે ખેડવાનું કે વાવણીનું કામ કરવું. સાતમાં દિવસે વિશ્રામ કરવો. માંત્ર છ દિવસ કામ કરવું અને સાતમે દિવસે આરામ પાળવો. ");
INSERT INTO guj2009_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“તમાંરે અઠવાડિયાનો પર્વ ઊજવવો. આ પર્વ માંટે ધઉંનો પ્રથમ ફળ અને શરદ ઋતુમાં કાપણી નો પર્વ ઊજવવો. ");
INSERT INTO guj2009_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“પ્રત્યેક વર્ષમાં ત્રણ વાર ઇસ્રાએલના સર્વ પુરુષો અને સંતાનોએ ઇસ્રાએલના દેવ યહોવા સમક્ષ ઉપસ્થિત થવું. ");
INSERT INTO guj2009_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“પ્રતિવર્ષ ત્રણ વાર તમે તમાંરા દેવ યહોવાના દર્શને જાઓ અને તે વખતે તમાંરા દેશ પર કોઈ આક્રમણ કરશે નહિ અને તેને જીતી લેશે નહિ. કારણ, તમાંરી ભૂમિ પરથી હું બીજી પ્રજાઓને હાંકી કાઢીને તમાંરી સરહદ વિસ્તારી આપીશ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“તમાંરે યજ્ઞ ચઢાવીને એનું લોહી ખમીરવાળી રોટલી સાથે મને ધરાવવું નહિ. “પાસ્ખાપર્વ યજ્ઞનો કોઈ ભાગ સવાર સુધી રાખી મૂકવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“પ્રતિવર્ષ તમાંરી જમીનનો પ્રથમ પાકનો ઉત્તમોત્તમ ભાગ તમાંરે તમાંરા દેવ યહોવાના મંદિરમાં લઈને આવવું. “તમાંરે લવારાને તેની માંતાના દૂધમાં રાંધવું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","યહોવાએ મૂસાને કહ્યું, “આ શબ્દો તું લખી લે, કારણ તારી સાથે અને ઇસ્રાએલ સાથે મેં એ પ્રમાંણે કરાર કર્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","તેથી મૂસા 40 દિવસ અને 40 રાત અન્નજળ લીધા વિના યહોવા સાથે રહ્યો અને તેણે કરારના શબ્દો-દશ આજ્ઞાઓ તકતી ઉપર લખી. ");
INSERT INTO guj2009_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","છેલ્લે મૂસા કરારની બે તકતીઓ લઈને સિનાઈ પર્વત ઉપરથી નીચે ઊતર્યો, ત્યારે તે જાણતો ન હતો કે યહોવાની સમક્ષ રહેવાથી તેનો ચહેરો પ્રકાશતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","હારુન અને ઇસ્રાએલીઓ મૂસાના ચહેરાને પ્રકાશતો જોઈને તેની પાસે જતાં ગભરાતાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","આથી મૂસાએ તેઓને પાસે બોલાવ્યા ત્યારે હારુન અને લોકોના આગેવાનો મૂસા પાસે ગયા અને મૂસાએ તેમની સાથે વાત કરી. ");
INSERT INTO guj2009_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","તે પછી સર્વ ઇસ્રાએલીઓ તેની પાસે આવ્યા અને તેને સિનાઈ પર્વત ઉપર યહોવાએ જે બધાં આદેશો આપ્યા હતા તે બધા તેણે લોકોને સંભળાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","જ્યારે મૂસાએ તેઓની સાથે બોલવાનું પૂરું કર્યું ત્યારે તેણે પોતાના મોં ઉપર ઘૂંઘટ ઢાંકી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","જ્યારે જ્યારે તે યહોવા સમક્ષ વાત કરવા જતો, ત્યારે ત્યારે ઘૂંઘટ દૂર કરતો અને બહાર આવતાં સુધી ઘૂંઘટ પાછો ઢાંકતો નહિ. પછી બહાર આવીને પોતાને જે જે આજ્ઞાઓ મળી હોય તે તે ઇસ્રાએલીઓને કહી સંભળાવતો, ");
INSERT INTO guj2009_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","તે સમયે ઇસ્રાએલીઓને મૂસાનો ચહેરો પ્રકાશતો દેખાયો તેથી તે યહોવા સાથે ફરી વાત કરવા જતાં સુધી ઉપર પાછો ઘૂંઘટ નાખી દેતો. ");
INSERT INTO guj2009_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","મૂસાએ સર્વ ઇસ્રાએલી લોકોની એક સભા ભેગી કરી તેઓને કહ્યું, “યહોવાએ તમને આટલા નિયમોનું પાલન કરવાની આજ્ઞા કરી છે: ");
INSERT INTO guj2009_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“માંત્ર છ દિવસ તમાંરે કામ કરવું. સાતમો દિવસ યહોવાને સમર્પિત કરેલ વિશ્રામનો દિવસ છે. તે દિવસે જે કોઈ કામ કરે તેને મોતની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","સાબ્બાથના દિવસે તમે જ્યા પણ રહેતા હોય ત્યાં આગ પેટાવાની મનાઈ છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","પછી મૂસાએ ઇસ્રાએલીઓના સમગ્ર સમાંજને કહ્યું, “યહોવાએ આ આજ્ઞા આપી છે: ");
INSERT INTO guj2009_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","દેવ માંટે ખાસ ભેટો ભેગી કરો. તમાંરામાંથી પ્રત્યેકે તમાંરા હૃદયમાં નક્કી કરવું કે તમાંરે શું આપવું છે. જેઓના હૃદય ઉદાર હોય તેઓ યહોવા પાસે અર્પણો લાવે: સોનું, ચાંદી અને કાંસા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ભૂરા, જાંબુડિયા અને કિરમજી રંગનું ઊન, શણનું ઝીણું કાપડ, બકરાંના વાળ, ");
INSERT INTO guj2009_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ઘેટાનું પકવેલું ચામડું, કુમાંશદાર ચામડાં, બાવળનાં લાકડાં, ");
INSERT INTO guj2009_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","દીવા માંટે તેલ, અભિષેકના તેલ માંટે અને ધૂપને માંટે તેજાના, સુંગધીદાર ધૂપ માંટે સુગંધી દ્રવ્યો, ");
INSERT INTO guj2009_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","યાજકના એફોદ અને ઉરપત્ર ઉપર જડવા માંટે ગોમેદ પાષાણ અને અન્ય પાષાણો. ");
INSERT INTO guj2009_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“તમાંરામાંથી જેઓ ખાસ કુશળ કારીગરો છે તેઓ આવે અને યહોવાએ જે બનાવવાની આજ્ઞા કરી છે તે બનાવે: ");
INSERT INTO guj2009_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","પવિત્રમંડપનો તંબુ, તેનાં આચ્છાદન, તેની કડીઓ, પાટિયાં, વળીઓ, થાંભલી અને કૂભીઓ: ");
INSERT INTO guj2009_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","પવિત્રકોશ અને તેની દાંડાઓ, ઢાંકણ અને દયાસન, પવિત્રસ્થાનને બંધ કરવાનો પડદો; ");
INSERT INTO guj2009_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","બાજઠ અને તેને ઊંચકવાની દાંડીઓ, અને તેનાં બધાં પાત્રો; ધરાવેલી રોટલી. ");
INSERT INTO guj2009_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","દીપવૃક્ષ અને દીવાઓ, તેનાં સાધનો, કોડિયાં અને પૂરવાનું તેલ. ");
INSERT INTO guj2009_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ધૂપની વેદી અને તેની દાંડીઓ, અભિષેક માંટેનું તેલ, સુગંધીદાર ધૂપ, અને મૂલાકાતમંડપનો પ્રવેશદ્વાર માંટેનો પડદો. ");
INSERT INTO guj2009_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","આહુતિ માંટે વેદી, અને તેની કાંસાની જાળી; થાંભલાઓ અને વેદી પર વપરાતી બધી વસ્તુઓ અને કાંસાનું પહોળુ વાસણ અને તેનું તળ. વેદીને ઊચકવાનાં બધાં સાધનો, દાંડા, કડી અને તેની ધોડી; ");
INSERT INTO guj2009_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","આંગણાની ભીતો માંટેના પડદાઓ, સ્તંભો, તેઓની કૂભીઓ અને આંગણાનાં પ્રવેશદ્વાર માંટેના પડદાઓ; ");
INSERT INTO guj2009_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","મુલાકાતમંડપના અને તેના આંગણાં માંટેના સ્તંભો, આંગણાની ખૂટીઓ અને તેની દોરીઓ, ");
INSERT INTO guj2009_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","પવિત્રસ્થાનમાં સેવા કરવાના સમયે યાજકોએ ધારણ કરવાના દબદબાભર્યા વસ્ત્રો, એટલે કે યાજક હારુન અને તેના પુત્રો માંટેનાં યાજક તરીકે સેવા કરવા માંટેનાં પવિત્ર વસ્ત્રો.” ");
INSERT INTO guj2009_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","પછી ઇસ્રાએલીઓના સમગ્ર સમુદાયે ભેટો આપવા માંટેની વસ્તુઓ તૈયાર કરવા માંટે મૂસા આગળથી રજા લીધી. અને પોતપોતાના તંબુઓમાં પાછા ફર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","પછી યહોવાના આત્માંથી જેઓના હૃદયોને સ્પર્શ થયો હતો, તે દરેક પોતાની રાજીખુશીથી મુલાકાતમંડપનાં સાધનો માંટે, તેની સામગ્રી માંટે અને પવિત્ર વસ્ત્રો માંટે તેઓનાં અર્પણો લઈને યહોવાને ભેટ ધરવા પાછા આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","સ્ત્રીઓ અને પુરુષો પણ આવ્યા અને તેમણે દરેકે રાજીખુશીથી-કોઈએ નથ, તો કોઈએ લવિંગિયાં કોઈએ વીટી, તો કોઈએ હાર. એમ વિવિધ પ્રકારના સોનાનાં ઘરેણાં યહોવાને ભેટ ધર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","બીજાં કેટલાક ભૂરા, જાંબુડા અને કિરમજી રંગનાં ઊન ઝીણા કાંતેલા શણના કાપડ અને બકરાંના વાળનાં કાપડ લાવ્યાં. વળી લાલા રંગ કરેલાં ઘેટાનાં ચામડાં અને ખાસ રીતે પકવેલાં બકરાંના ચામડાં પણ તેઓ લઈ આવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","જે કોઈ યહોવાને ચાંદી કે કાંસાની ભેટ ધરાવી શકે તેમ હતા તે સૌ તે લાવ્યા, તો કેટલાક બાંધકામ માંટે જરૂરી બાવળનું લાકડું લાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","જે સ્ત્રીઓ કાંતવામાં કુશળ હતી, તેમણે ભૂરું, જાંબુડિયું અને કિરમજી ઊન તથા બારીક શણ કાંતી આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","બીજી કેટલીક કુશળ સ્ત્રીઓએ બકરાંના વાળ કાંતીને કાપડ તૈયાર કરી આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","યાજકોના ઉરપત્રમાં અને એફોદમાં જડવા માંટે આગેવાનો ગોમેદ પાષાણ અને અન્ય પાષાણ લાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","તેમ જ દીવા માંટે તથા અભિષેક અને સુગંધીદાર ધૂપ માંટે સુગંધી દ્રવ્યો અને તેલ લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","આ પ્રમાંણે ઇસ્રાએલના લોકોએ યહોવાએ મૂસા માંરફતે જે જે કામો કરવાની આજ્ઞા કરી હતી તેને માંટે તે કાર્યમાં મદદ કરવાની ઈચ્છા જે સ્ત્રી પુરૂષોની હતી તે સૌએ પોતાના અર્પણો રાજીખુશીથી તેમને આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","પછી મૂસાએ ઇસ્રાએલીઓને કહ્યું, “જુઓ, યહોવાએ યહૂદાના કુળસમૂહના હૂરના દીકરા ઊરીના દીકરા, બઝાલએલને મંદિરનાં હસ્તકલાનાં કામ માંટે પસંદ કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","અને તેનામાં દેવના આત્માંનો સંચાર કરીને તેને દરેક પ્રકારની કારીગરીમાં કુશળતા, સમજદારી તથા હોંશિયારી ભરપૂર આપ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","સોનાચાંદી અને કાંસાના સાધનો બનાવવામાં, નવી નવી ભાતો ઉપજાવી કાઢવામાં, ");
INSERT INTO guj2009_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","રત્નોને પહેલ, પાડવામાં, જડવામાં, તથા લાકડામાં કોતરણી કરવામાં, તથા બધા પ્રકારના નકશીકામ કરવામાં તેને કુશળ બનાવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","યહોવાએ તેને અને દાનકુળના અહીસામાંખના પુત્ર આહોલીઆવને બીજાને શીખવવાની શક્તિ આપી છે. ");
INSERT INTO guj2009_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","તેણે તેમને સર્વ પ્રકારનું કામ કરવાનું કૌશલ્ય આપ્યું છે; કોતરણીનું, સિલાઈનું, ભરતકામના કિરમજી રંગના કાપડના પડદાઓની ભાત તૈયાર કરવાનું, ભૂરાં, જાંબુડિયા અને કિરમજી ઊનના અને બારીક શણના ભરતગૂંથણનું અને વણાંટનું, તેઓ સર્વ પ્રકારનું કામ કરી શકે છે અને ભાત રચી શકે છે, સર્વમાં તેઓ શ્રેષ્ઠ પુરવાર થશે. ");
INSERT INTO guj2009_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“બઝાલએલ, આહોલીઆબ અને અન્ય બધા કારીગરો, જેઓને યહોવાએ કૌશલ્ય અને સમજ આપ્યાં છે જેથી તેઓને મુલાકાતમંડપના બાંધકામને લગતું બધું કામ કરતાં આવડે, તેમણે બરાબર યહોવાની આજ્ઞા મુજબ જ બધું બનાવવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","પછી મૂસાએ બઝાલએલને, આહોલીઆબને અને જે કારીગરોને યહોવાએ કૌશલ્ય આપ્યું હતું અને જેઓ કામ કરવાને તૈયાર હતા તે બધાને બોલાવ્યા અને સૌને કામ શરૂ કરવા જણાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ઇસ્રાએલીઓએ મંદિર બાંધવા માંટે જે જે ભેટો આપી હતી તે બધી મૂસાએ તેમને સોંપી દીધી. તેમ છતાં ઇસ્રાએલીઓ પ્રતિદિન સવારમાં ભેટ લાવતા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","તેથી મંદિરનું કામ કરનારા બધાજ કારીગરો પોતપોતાનું કામ છોડીને મૂસા સમક્ષ આવીને કહેવા લાગ્યા, ");
INSERT INTO guj2009_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“યહોવાએ જે કામ કરવાની આજ્ઞા કરી છે તે પૂરુ કરવા માંટે જરૂરી હોય તેના કરતાં ધણું વધારે લોકો લાવ્યા કરે છે.” ");
INSERT INTO guj2009_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","તેથી મૂસાએ આખી છાવણીમાં ઢંઢેરો પિટાવ્યો કે હવે વધુ ભેટ લાવવાની જરૂર નથી. એટલે લોકોએ ભેટ લાવવાનું બંધ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","અત્યાર સુધીમાં જે કાંઈ આવ્યું હતું તે બધું કામ પૂરુ કરવા માંટે જોઈએ તેના કરતાં વધારે હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","સૌથી કુશળ કારીગરોએ પવિત્રમંડપ બનાવ્યો. ઝીણાં કાંતેલા શણ અને ભૂરા કિરમજી અને લાલ ઊનના દશ પડદાઓથી તેમણે તંબુ બનાવ્યો. એના ઉપર કરૂબ દેવદૂતોની આકૃતિઓ ભરેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","પ્રત્યેક પડદો 28 વાર લાંબો અને 4 વાર પહોળો હતો. બધા જ પડદા સમાંન માંપના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","તેમણે પાંચ તાકા જોડીને એક મોટો પડદો બનાવ્યો, અને બીજા પાંચનો બીજો મોટો પડદો બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","તેમણે દરેક મોટા પડદાની બહારની બાજુએ ભૂરા કાપડની પટ્ટીથી પચાસ નાકાં બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","તેમણે એક મોટા પડદાના પહેલાં પડદાને 50 નાકા બનાવ્યા, અને બીજા મોટા પડદાના છેલ્લા પડદાને એની બરાબર સામે આવે એ રીતે 50 નાકાં બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","આ નાકાંઓને જોડવા માંટે તેમણે 50 સોનાની કડીઓ બનાવી. અને તેના વડે આ બે પડદાઓને જોડી દીઘા એટલે પવિત્રમંડપનો એક સળંગ તંબુ રચાયો. ");
INSERT INTO guj2009_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","એ પવિત્રમંડપ ઉપર તંબુ બનાવવા માંટે તેમણે બકરાંના વાળના કાપડના અગિયાર પડદાઓ બનાવ્યા. તે બધા સરખા માંપના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","પ્રત્યેક પડદો 30 હાથ લાંબો અને 4 હાથ પહોળો હતો. બધા પડદા એક જ માંપના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","બઝાલએલ પાંચ પડદા એકબીજા સાથે જોડી દઈને એક મોટો પડદો બનાવ્યો અને બીજા છ નો બીજો એક મોટો પડદો બનાવ્યો; ");
INSERT INTO guj2009_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","પછી તેમણે પહેલા મોટા પડદાના છેલ્લા તાકાને 50 નાકાં મૂક્યાં અને બીજા મોટા પડદાની બાજુએ બીજા પચાસ નાકાં મૂક્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","આ નાકાંઓને જોડવા માંટે કાંસાની નાના કદની 50 કડીઓ બનાવી તેના વડે એ બે પડદા જોડી દીધા એટલે એક સળંગ તંબુ થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","તેમણે પવિત્રમંડપની છતનું સૌથી ઉપરનું આવરણ બનાવ્યુ. પહેલું ઘેટાનાં લાલ રંગેલાં ચામડાઓમાંથી તથા બીજુ બકરાંના પકવેલાં કુમાંશદાર ચામડાનું બનાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","પવિત્રમંડપની બાજુની ભીતો માંટે ઊભા ગોઠવવા તેમણે બાવળનાં પાટિયાં તૈયાર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","પ્રત્યેક પાટિયું 10 હાથ લાંબું અને દોઢ હાથ પહોળું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","પ્રત્યેક પાટિયાંને એકબીજા સાથે જોડવા માંટે દરેકને બબ્બે સાલ કાઢયાં હતાં; ");
INSERT INTO guj2009_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","દક્ષિણ બાજુએ ભીત માંટે 20 પાટિયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","તે 20 પાટિયાં ચાંદીની 40 કૂભીઓમાં ઊભા કર્યા હતા, પ્રત્યેક પાટિયું બે કૂભીઓમાં ઊભું કર્યુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ઉત્તર બાજુએ ભીત માંટે પણ 20 પાટિયાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","તે 20 પાટિયાં ચાંદીની 40 કૂભીઓમાં ઊભા કર્યા હતાં. પ્રત્યેક પાટિયું બે કૂભીઓ વચ્ચે ઊભુ કર્યુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","મુલાકાતમંડપનો પાછળનો ભાગ પશ્ચિમ દિશામાં હતો અને તેની પછીત માંટે છ પાટિયાં બનાવ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","અને પછીતના ખૂણાઓ માંટે બે પાટિયાં બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","પછીતનાં અને ખૂણાઓનાં પાટિયાં નીચેથી જોડેલાં હતાં અને ઠેઠ ઉપરથી પહેલી કડી સુધી જોડી દીધેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","આમ, પશ્ચિમ બાજુએ કુલ આઠ પાટિયાં, ચાંદીની 16 કૂભીઓમાં ઊભા કરેલાં હતાં. અને પ્રત્યેક પાટિયું બે કૂભીઓમાં બેસાડેલું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","પછી તેમણે આ પાટિયાઓને તેમની બાજુએથી એક બીજા સાથે જોડી દેવા માંટે બાવળનાં લાકડાંની ભૂંગળો બનાવી, પાંચ તંબુની એક બાજુનાં પાટિયાં માંટે અને બીજી પાંચ બીજી બાજુનાં પાટિયાં માંટે. ");
INSERT INTO guj2009_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","અને પાંચ ભૂગળો પશ્ચિમની પછીતના પાટિયાં માંટે, ");
INSERT INTO guj2009_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","આ પાંચ ભૂંગળોમાંથી વચલી ભૂંગળ પાટિયાઓની અડધી ઊચાઈને એક છેડાથી તે બીજા છેડા સુધી લાગેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","આ પાટિયાઓ અને ભૂંગળો સોનાંથી મઢેલાં હતાં અને કડાંઓ શુદ્ધ સોનાનાં બનાવ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","અંદરનો પડદો વણાંટકામના કાપડનો બનાવેલો હતો. અને ભૂરા, જાંબુડા અને કિરમજી ઊનનો હતો. તેના ઉપર જરીથી કલાત્મક રીતે કરૂબદેવદૂતોની આકૃતિઓનું ભરત કરવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","પડદાને લટકાવવા માંટે બાવળની ચાર થાંભલીઓ બનાવી અને તેને સોને મઢીને, સોનાની વાળી મુકી. અને થાંભળીઓ માંટે ચાર ચાંદીની કૂભીઓ બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","માંડવાના પ્રવેશદ્વાર માંટે બઝાલએલે ભૂરા, કિરમજી અને લાલ ઊનનો તથા ઝીણા કાંતેલા શણનો ભરત ભરેલો પડદો બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","બાવળના લાકડામાંથી પાંચ થાભલી અને કડીઓ તૈયાર કરી સોનાથી મઢી, પછી તેઓને કાંસાની પાંચ કૂભીઓમાં ઊભી કરી. તેના ટોચકાઓને અને પડદાની દાંડીને. પછી સોનાની પાંચ કડીઓ વડે આ પડદો લટકાવવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","પછી બઝાલએલે બાવળના લાકડામાંથી પવિત્રકોશ બનાવ્યો, જેની લંબાઈ અઢી હાથ, પહોળાઈ દોઢ હાથ અને ઊંચાઈ દોઢ હાથ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","તેણે તેને અંદર બહાર શુદ્ધ સોનાથી મઢીને તેની ફરતે સોનાની પટી મૂકી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","તેના ચાર પગોમાં સોનાનાં ચાર કડાં જોડેલા હતાં. પ્રત્યેક છેડા ઉપર બે કડાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","પછી તેણે બાવળના લાકડાના દાંડા બનાવ્યા અને તેને સોનાથી મઢી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","અને કોશ ઉપાડવા માંટે બંને બાજુના કડામાં પરોવી દીઘા. ");
INSERT INTO guj2009_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ત્યારબાદ તેણે શુદ્ધ સોનામાંથી અઢી હાથ લાંબુ અને દોઢ હાથ પહોળું ઢાંકણ તૈયાર કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","તેણે બે કરૂબદેવદૂતોની આકૃતિઓ સોનામાંથી ઘડીને ઢાંકણના બે છેડા માંટે બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","એક છેડે એક કરૂબદેવદૂત અને બીજે છેડે એક કરૂબદેવદૂત; તેણે તેને ઢાંકણ સાથે જોડી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","દેવદૂતોની પાંખો ઊંચે પસારેલી હોવાથી ઢાંકણ પાંખોથી ઢંકાઈ જતું હતું. દેવદૂતોનાં મોં એકબીજાની સામસામે હતાં, અને ઢાંકણ તરફ વાળેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","બાવળના લાકડામાંથી તેણે 2 હાથ લાંબો, 1 હાથ પહોળો અને દોઢ હાથ ઊચો બાજઠ બનાવ્યો, ");
INSERT INTO guj2009_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","આખા બાજઠને શુદ્ધ સોનાથી મઢી લઈને બાજઠની ચારે તરફની ધાર પર સોનાની કિનારી બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","પછી તેણે તેની ફરતે ચાર ઈચની કિનાર બનાવી અને તેની ફરતે સોનાની કોર મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","તેણે એને ઉપાડવા માંટે સોનાનાં ચાર કડાં બનાવ્યાં અને ચાર ખૂણે ચાર પાયે જડી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","બાજઠ ઉપાડવાની દાંડીની જગાઓ એટલે કડાં એ કિનારીની નજીક હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","દાંડીઓ બાવળના લાકડાની બનાવી અને તેને સૂવર્ણથી મઢી લીધી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","પછી તેણે બાજઠને માંટેનાં વાસણો-રકાબીઓ, વાટકા, બરણીઓ અને પેયાર્પણ માંટેના વાટકા શુદ્ધ સોનાનાં બનાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","તેણે શુદ્ધ સોનાની દીવી બનાવી; દીવીની બેસણી અને થાંભલી સોનામાંથી ઘડીને બનાવ્યાં અને તેના ઉપરનાં શોભાનાં ફૂલો, કળીઓ અને પાંદડીઓ તેની સાથે જડી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","દીપવૃક્ષની બંને બાજુએ ત્રણ ત્રણ એમ કુલ છ શાખાઓ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","પ્રત્યેક શાખા ઉપર શોભા માંટે કળીઓ અને પાંદડીઓ સાથે બદામ ઘાટનાં ત્રણ ત્રણ ફૂલ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","દીપવૃક્ષની થાંભલીઓને કળીઓ અને પાંદડીઓવાળાં ચાર શોભાનાં ફૂલ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","દીપવૃક્ષનાં સ્તંભ ઉપર બબ્બે શાખાઓની દરેક જોડી નીચે એક એક ફૂલ હતું. વળી ટોચની શાખાની જોડીના ઉપરના ભાગમાં પણ એક ફૂલ હતું. અને નીચેની શાખાઓની જોડીના નીચેના ભાગમાં એક ફૂલ હતું. આમ ચાર ફૂલ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","દીવીની થાંભલી સાથે શાખાઓ અને કળીઓ જોડી દેવામાં આવ્યા હતાં, અને એ બધું શુદ્ધ સોનાની એક જ ઢાળકીમાંથી ઘડીને બનાવવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","દીવી માંટે તેણે સાત કોડિયાં બનાવ્યાં. દિવેટની વાટ સમાંરવાની કાતર અને રાખદાનીઓ શુદ્ધ સોનામાંથી બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","દીપવૃક્ષ અને એનો સાજ બનાવવામાં તેણે 75 પૌંડ શુદ્ધ સોનું વાપર્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ધૂપ માંટેની વેદી તેણે બાવળના લાકડામાંથી બનાવી. તે 1 હાથ લાંબી, 1 હાથ પહોળી અને 2 હાથ ઊચી ને સમચોરસ હતી. વેદી પર ચાર શિંગ હતાં દરેક ખૂણામાં એક શિંગ હતું. આ શિંગો એકબીજા સાથે જોડેલા હતા, એક નંગ બનાવવા એક ભાગ તરીકે એક જ એકમમાં તેના ખુણાઓ ઉપર શિંગ તૈયાર કરેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","આખી વેદીને શુદ્ધ સોનાથી મઢી લેવામાં આવી અને તેની ચારે તરફની ધાર ઉપર સોનાની કિનારી બનાવવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","તેણે તેને માંટે બે સોનાનાં કડા બનાવીને બંને બાજુએ કિનારીની નીચે જડી દીધાં. જેમાં ઉપાડતી વખતે દાંડા પરોવી શકાય. ");
INSERT INTO guj2009_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","પછી તેણે બાવળનાં લાકડાના દાંડા બનાવીને સોનાથી મઢયા. ");
INSERT INTO guj2009_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","વળી તેણે અભિષેક માંટેનું તેલ તેમજ સરૈયો બનાવે તેવો શુદ્ધ સુગંધીદાર ધૂપ પણ બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","તેણે 5 હાથ લાંબી, 5 હાથ પહોળી અને 3 હાથ ઊચી ચોરસ યજ્ઞ માંટેની વેદી બાવળના લાકડામાંથી બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","તેના ચાર ખૂણા પર ચાર શિંગ હતાં, તે વેદીના લાકડામાંથી જ બનાવેલાં હતાં. આ વેદી ઉપર કાંસાનું આવરણ ચઢાવવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","પછી તેણે વેદીનાં બધાં જ પાત્રો-ભસ્મપાત્રો, તાવડીઓ, તપેલાં, ડોયા, પંજેટી અને સગડીઓ-કાંસાનાં બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","પછી તેણે વેદીની અંદરના ભાગમાં જયાં અગ્નિ પ્રગટે છે ત્યાં અડધી ઊચાઈએ ટેકા માંટેની ધાર બનાવીને તેના ઉપર કાંસાની જાળી ગોઠવી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","આ વેદીની ચાર બાજુઓ માંટે ચાર કડાં બનાવીને કઠેરાના ચાર ખૂણે મૂક્યાં જેથી તેમાં દાંડા ભેરવી શકાય. ");
INSERT INTO guj2009_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","આ દાંડા બાવળના લાકડાના બનાવીને તેને કાંસાથી મઢી લીધા, ");
INSERT INTO guj2009_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","પછી તેને વેદીની બાજુએ આવેલાં કડાંઓમાં પરોવી દીધા. વેદી લાકડાંના પાટિયાંમાંથી બનાવેલી હતી અને અંદરથી પોલી રાખી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","મુલાકાતમંડપના પ્રવેશદ્વાર પાસે ભેગી થયેલી સ્ત્રીઓનાં દાન કરેલા કાંસાના દર્પણમાંથી ઢાળીને તેણે હાથ પગ ધોવાની કાંસાની કૂડી અને તેની કાંસાની ઘોડી બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","પછી તેણે આંગણું બનાવ્યું; તેની દક્ષિણ બાજુના પડદાની ભીંત 100 હાથ લાંબી હતી અને તે ઝીણા કાંતેલા શણના પડદાઓની બનાવેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","આ પડદાને પકડી રાખવા માંટે 20 થાંભલીઓ અને 20 કૂભીઓ કાંસાની હતી. તથા એ થાંભલીઓના આંકડા અને આડા સળિયા ચાંદીના બનાવેલા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ઉત્તરની બાજુએ 100 હાથ લાંબા પડદા હતા અને તેને માંટે કાંસાની 20 થાંભલીઓ અને 20 કૂભીઓ હતી, તથા આંકડા અને સળિયા ચાંદીના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","આંગણાની પશ્ચિમ બાજુએ 50 હાથ લાંબા પડદા હતા. તથા 10 થાંભલીઓ અને 10 કૂભીઓ હતી. અને આંકડા અને સળિયા ચાંદીના હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","આંગણાની પૂર્વ તરફ 50 હાથ લાંબી ભીંત હતી. આંગણનો પ્રવેશદ્વાર આ તરફ હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","પ્રવેશદ્વારની એક બાજુએ 15 હાથનો પડદો હતો અને તેને થોભવા માંટે ત્રણ થાંભલીઓ અને ત્રણ કૂભીઓ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","અને આંગણાના પ્રવેશદ્વારની બીજી બાજુએ 15 હાથ લાંબા પડદા હતા, અને તેમને ત્રણ થાંભલીઓ અને ત્રણ કૂભીઓ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ભીતો બનાવવા માંટે વપરાયેલા બધા જ પડદાઓ ઝીણા કાંતેલા શણના બનાવેલા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","પ્રત્યેક થાંભલીઓ માંટેની કૂભીઓ કાંસાની હતી અને આંકડા તથા દાંડીઓ ચાંદીના હતાં. થાંભલીઓનો ટોચકા ચાંદીના પતરાથી મઢેલી હતી, આંગણાની બધી થાંભલીઓને ચાદીની દાંડીઓ હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","આંગણાના પ્રવેશદ્વારનો પડદો ભૂરા, કિરમજી, તથા લાલ રંગના ઊનનો અને ઝીણા કાંતેલા શણનો હતો, તેના પર ભરતકામ કરેલું હતું. અને તે 20 હાથ લાંબો અને આંગણાને ફરતા પડદાની જેમ 5 હાથ ઊંચો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","તે ચાર કાંસાની કૂભીઓમાં બેસાડેલી ચાર કાંસાની થાંભલીઓ ઉપર લટકાવેલો હતો. તેના આંકડાઓ અને સળિયાઓ ચાંદીના હતા. થાંભલીઓના મથાળાં ચાંદીથી મઢેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","પવિત્રમંડપ તથા આંગણાના બાંધકામમાં વપરાયેલી બધી ખૂંટીઓ કાંસાની બનાવેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","પવિત્ર તંબુ એટલે કે કરારકોશના તંબુના બાંધકામમાં વપરાયેલ વિવિધ ધાતુનો હિસાબ આ મુજબ છે. મૂસાએ એ યાદી તૈયાર કરવાનો આદેશ આપ્યો હતો, અને તે યાજક હારુનના પુત્ર ઈથામાંરના નિરીક્ષણ હેઠળ તૈયાર કરેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","યહૂદાના કુળસમૂહના હૂરના દીકરા ઊરીના દીકરા બઝાલએલે યહોવાએ મૂસાને જે જે બનાવવાની આજ્ઞા કરી હતી તે બધું બનાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","તેને મદદ કરનાર દાનના વંશના અહીસામાંખનો પુત્ર આહોલીઆબ કોતરકામ કરનાર, નવી ભાતો બનાવનાર, અને ભૂરા કિરમજી અને લાલ ઊન તેમજ ઝીણા કાંતેલા શણનું ભરત ભરનાર હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","એ પવિત્રસ્થાનક માંટે યહોવાને સમર્પિત કુલ સોનાનું વજન મંદિરના માંપના ધોરણ મુજબ 2 ટન કરતા વધારે હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","વસ્તીગણતરીની નોંધણી વખતે લોકો પાસેથી મળેલ ચાદીનું વજન મંદિરના માંપ ધોરણ પ્રમાંણે 3 3/4 ટન કરતા વધારે હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","વસ્તીગણતરીમાં વીસની અને તેની ઉપરની ઉંમરના 6,03,550 માંણસો નોંધાયેલ હતાં. અને તેમાંના પ્રત્યેક એક બેકા ચાંદીની ખંડણી ભરી હતી (અધીકૃત માંપ વાપરતા એક બેકા એટલે અડધો શેકેલ). ");
INSERT INTO guj2009_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","પવિત્રસ્થાન માંટેની અને પડદા માંટેની કૂભીઓ બનાવવામાં 3-3/4 ટન ચાંદી વપરાઈ હતી: તેમાંથી 100 કૂભીઓ બનાવી. તેથી દરેક કૂભીમાં 75 પૌંડ ચાંદી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","બાકીની 50 પૌંડ ચાંદીમાંથી તેણે થાંભલીઓના આંકડા, તેમનાં મથાળાં અને દાંડીઓ બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","યહોવાને સમર્પિત કુલ કાંસા સાડા છવ્વીસ ટન કરતા વધારે હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","આ કાંસાનો ઉપયોગ મુલાકાતમંડપના પ્રવેશદ્વારની કૂભીઓ, કાંસાની વેદી અને તેની કાંસાની જાળી, વેદીનાં બધાં સાધનો, ");
INSERT INTO guj2009_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","આંગણા માંટેના પાયા તથા તેના પ્રવેશદ્વાર અને પવિત્રમંડપ અને આંગણાનાં બાંધકામ માંટે વપરાયેલા સર્વ અને ખીલીઓ બનાવવા માંટે થયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","પવિત્રસ્થાનમાં સેવા કરતી વખતે યાજકોએ પહેરવાના દબદબાભર્યા પોષાક, લોકોએ ભૂરા, જાંબુડા અને કિરમજી રંગના કાપડમાંથી બનાવ્યા. યહોવાએ મૂસાને આજ્ઞા કરી હતી તે મુજબ તેમણે હારુનને માંટેનાં વસ્ત્રો બનાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","તેમણે એફોદ સોનાનું તથા જાંબુડિયા, કિરમજી અને લાલ ઊન અને ઝીણા કાંતેલા શણનું બનાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","સોનાને ટીપીને બઝાલએલે સોનાના પાતળાં પતરાં બનાવ્યાં. અને તેને કાપીને તેના તાર બનાવ્યા. આ તાર ભૂરા, જાંબુડા, અને કિરમજી રંગના કાપડમાં વણી લેવામાં આવ્યા. આ કાર્ય એક બહુ જ કુશળ કારીગરનું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","એફોદને ખભે બાંધવાના પટા બનાવીને તેની બે બાજુએ જોડી દીધા. જેથી તે બાંધી શકાય. ");
INSERT INTO guj2009_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","એના ઉપરનો કમરપટો પણ યહોવાએ મૂસાને આજ્ઞા કર્યા મુજબ એફોદના જેવી ન કારીગરીવાળો અને સોનેરી, જાંબુડિયા, કિરમજી અને લાલ ઊન તથા ઝીણા કાંતેલા શણ સાથે ગૂંથીને બનાવેલો હતો અને તેની સાથે જોડી દીધેલો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","પછી તેમણે બે ગોમેદ પાષાણો સોનાના ચોકઠામાં જડયા, આ પાષાણો ઉપર ઇસ્રાએલના કુળોનાં નામ કોતરેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","અને પછી તેઓએ તેને એફોદના ખભાના પટ્ટા સાથે, દેવને ઇસ્રાએલીઓની યાદી તરીકે જોડી દીધા. યહોવાએ જેમ મૂસાને આજ્ઞા કરી હતી તે પ્રમાંણે કરવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","તેમણે ન્યાયકરણ ઉરપત્ર એફોદની જેમ સુંદર કારીગરીથી બનાવ્યું હતું. તેને બનાવવા માંટે તેમણે સોનાના દોરા, જાબુંડિયા, કિરમજી, અને લાલ ઉન તથા ઝીણા કાંતેલા શણનો ઉપયોગ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","તે એક સમચોરસ બેવડ વાળેલું એક વેંત લાંબું અને એક વેંત પહોળું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","એમાં નંગોની ચાર હાર બેસાડેલી હતી; પ્રથમ હારમાં માંણેક, પોખરાજ અને લાલ રત્ન હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","બીજી હારમાં લીલમ, નીલમ અને હીરા. ");
INSERT INTO guj2009_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ત્રીજી હારમાં શનિ, અકીક અને યાકૂત ");
INSERT INTO guj2009_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","અને ચોથી હારમાં ગોમેદ, પિરોજ અને યાસપિસની, એ બધાં સોનાનાં નકશીકામવાળા ચોકઠામાં જડેલા હતા. ");
INSERT INTO guj2009_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","આ રીતે તેમાં બાર નંગો હતા અને તેના પર ઇસ્રાએલના પુત્રોનાં નામ કોતરેલાં હતાં. પ્રત્યેક નંગ પર ઇસ્રાએલના એક વંશનું નામ કળાથી કોતરેલું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","તેમણે ન્યાયકરણ ઉરપત્ર માંટે શુદ્ધ સોનાની ગૂંથેલી દોરી જેવી સાંકળીઓ બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","તદુપરાંત તેમણે સોનાની બે વાળી બનાવી ન્યાયકરણ ઉરપત્રના બે ખૂણાઓમાં બેસાડી દીધી. તેઓએ ખભાના ટુકડાઓ માંટે બે સોનાની નકશી બનાવી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","પછી ન્યાયકરણ ઉરપત્રના છેડા પર મૂકેલી કડીઓમાં સોનાની સાંકળીઓ જોડી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","એ સાંકળીના બીજા બે છેડા બે ચોકઠાં સાથે જોડી દીધાં અને એ રીતે એ ચોકઠાં ન્યાયકોથળીની સ્કંધપટીઓના આગળના ભાગ પર જોડી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","તે પછી સોનાની બીજી બે કડીઓ બનાવી એફોદની નજીકના ન્યાયકરણ ઉરપત્રની અંદરની બાજુના નીચલા ખૂણાએ મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ત્યારબાદ બીજી બે સોનાની કડીઓ બનાવીને એફોદના ખભાના બે પટાના સામેના નીચેના છેડે સાંધા નજીક અને સુંદર ગૂંથેલા કમરપટાની ઉપરના ભાગમાં લગાવી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ન્યાયકરણ ઉરપત્રના નીચલા છેડાને ભૂરી દોરી વડે એફોદની કડીઓ સાથે બાંધી દીધો, જેથી યહોવાએ મૂસાને આજ્ઞા કરી હતી તે મુજબ ન્યાયકરણ ઉરપત્ર કરમપટા ઉપર રહે અને છૂટ્ટુ ન પડી જાય. ");
INSERT INTO guj2009_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","અફોદ પરનો જામો આખો ભૂરા રંગના કાપડનો એક કુશળ કારીગરે બનાવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","તેમણે જામાંની વચ્ચે એક કાણું પાડ્યું અને તેની કિનાર સીવી લીધી. તેની કિનાર ફાટી ન જાય તે માંટે સીવવામાં આવી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","જામાંની નીચેની બાજુએ દાડમ ભરેલાં હતાં. તે કાંતેલા શણના તથા ભૂરા તથા જાંબુડા તથા કિરમજી રંગના ભરતકામથી બનાવેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","તેમજ શુદ્ધ સોનાની ઘૂઘરીઓ બનાવી એ દાડમો વચ્ચે આખી નીચલી બાજુએ મૂકી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","એ જ રીતે ઝભ્ભાની નીચેની બાજુએ વારાફરતી દાડમ અને ઘૂઘરી આવતાં હતાં. યહોવાએ મૂસાને આજ્ઞા કરી હતી તે પ્રમાંણે હારુન યહોવાની સેવા કરતી વખતે આ ઝભ્ભો પહેરતો હતો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","તેમણે હારુન અને તેના પુત્રો માંટે ઝીણા કાંતેલા શણના અંગરખાં બનાવ્યાં, ");
INSERT INTO guj2009_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","વળી ઝીણા કાંતેલા શણમાંથી પાધડીઓ, ફાળિયા, અને પાયજામાં બનાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","તથા યહોવાની આજ્ઞા મુજબ ભૂરા, કિરમજી, અને લાલ ઊનનો ભરત ભરેલો ઝીણા કાંતેલા શણનો કમરપટો બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","અંતે તેમણે શુદ્ધ સોનામાંથી એક તકતી બનાવી જેની પર પવિત્ર શબ્દો કોતરેલા હતા, “યહોવા પવિત્રતા” તે મુગટ ઉપર જડેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","એ ભુરા રંગની પટ્ટી સાથે બાંધેલી હતી, જે પાઘડી ઉપર બંધાએલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","આ રીતે યહોવાએ મૂસાને આપેલી આજ્ઞા અનુસાર પવિત્રમંડપનું કામ પૂર્ણ થયું. આ બધુંજ ઇસ્રાએલીઓએ આજ્ઞા મુજબ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","પછી તેઓએ પવિત્રમંડપ, તેનો તંબુ અને તેનું બધું રાચરચીલું, તેની કડીઓ, પાટિયાં, વળીઓ, થાંભલીઓ અને કૂભીઓ, ");
INSERT INTO guj2009_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","તેઓએ તેને સુકવેલા રાતા રંગેલા ચામડાંમાંથી બનાવેલા મંડપના ઢાંકણ અને ઝીણા ચામડામાંથી બનાવેલા ઢાંકણ અને અત્યંત પવિત્રજગ્યાનાં પ્રવેશ દ્વારનો પડદો બનાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","કરારકોશ, તેના દાંડા, તેનું ઢાંકણ, ");
INSERT INTO guj2009_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","મેજ અને તેનાં બધાં સાધનો, અર્પણ કરેલી રોટલી, ");
INSERT INTO guj2009_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","શુદ્ધ સોનાનું દીપવૃક્ષ-તેનાં કોડિયા, જે હારબંધ ગોઠવવાનાં હતાં, અને તેનાં બધાં સાધનો, અને પૂરવાનું તેલ, ");
INSERT INTO guj2009_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","સોનાની વેદી, અભિષેક માંટેનું તેલ, સુગંધીદાર ધૂપ, મુલાકાત મંડપના પ્રવેશદ્વારનો પડદો, ");
INSERT INTO guj2009_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","કાંસાની વેદી, તેની કાંસાની બનાવેલી જાળી, તેના દાંડા, અને તેનાં બધાં સાધનો કૂડી અને તેની ધોડી, ");
INSERT INTO guj2009_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","આંગણાની ભીંતો માંટેના પડદાઓ, અને તેને લટકાવવા માંટેની થાંભલીઓ અને કૂભીઓ, તેમજ આંગણાંના પ્રવેશદ્વાર માંટેના પડદાઓ અને તેના સ્તંભો, દોરી અને ખીલાઓ તથા મુલાકાતમંડપમાં સેવા માંટે વાપરવાનાં બધાં સાધનો. ");
INSERT INTO guj2009_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","પવિત્રસ્થાનમાં સેવા કરવાના સમયે પહેરવાનાં સુંદર દબદબાભર્યા વસ્ત્રો તથા યાજક તરીકે ફરજ બજાવતી વખતે હારુન અને તેના પુત્રોએ પહેરવાનાં પવિત્ર વસ્ત્રો મૂસાને બતાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","યહોવાએ મૂસાને જણાવ્યા મુજબ બધું જ કામ ઇસ્રાએલીઓએ પૂર્ણ કર્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","પછી મૂસાએ બધું જ તપાસી લીધું અને યહોવાએ જણાવ્યા મુજબ બનાવ્યુ છે એની ખાતરી કરી લીધી અને પછી મૂસાએ તેમને આશીર્વાદ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","હવે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“પ્રથમ માંસના પ્રથમ દિવસે તું પવિત્રમડંપ ઊભો કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","પછી જેમાં દશ આજ્ઞાઓ મૂકેલી છે, તે સાક્ષ્યકોશ મંડપમાં મૂકજે; અને પરમપવિત્ર સ્થાનમાં સાક્ષ્યકોશને પડદાથી ઢાંકી દેજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","પછી મેજ લાવીને તેના પર પાત્રો ગોઠવજે, અને દીવી લાવીને તેના પર કોડિયાં ગોઠવીને દીવાઓ પ્રગટાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ત્યારબાદ સાક્ષ્યકોશ આગળ સોનાની ધૂપદાની ગોઠવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“પ્રવેશદ્વારનો પડદો મુલાકાતમંડપમાં યથાસ્થાને લટકાવજે. અને મુલાકાતમંડપના પ્રવેશદ્વાર સામે દહનાર્પણ માંટે વેદી મૂકજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","મુલાકાતમંડપ અને વેદીની વચ્ચે કૂડી મૂકજે અને તેમાં પાણી ભરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","મુલાકાત મંડપના બહારના ભાગમાં ચારે બાજુ આંગણું તૈયાર કરજે અને આંગણાના પ્રવેશદ્વારે પડદો લટકાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“પછી અભિષેકનું તેલ લઈ પવિત્રમંડપનો તથા તેમાંની સર્વ વસ્તુઓનો અભિષેક કરી, તેની તથા તેમાંના બધા રાચરચીલાની શુદ્ધિ કરજે તેથી એ પવિત્ર થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","વેદીનો અને તેનાં સર્વ સાધનોનો પણ અભિષેક કરી તેમની શુદ્ધ કરજે તેથી તે પણ અત્યંત પવિત્ર થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","કૂડી અને તેની ઘોડીની પણ શુદ્ધિ કરવા માંટે અભિષેક કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“પછી તું હારુનને અને તના પુત્રોને મુલાકાત મંડપના પ્રવેશદ્વાર આગળ લાવજે અને તેમને જળથી સ્નાન કરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ત્યારબાદ હારુનને પવિત્ર પોશાક પહેરાવજે અને તેનો અભિષેક કરજે, અને યાજક તરીકે માંરી સેવા કરવા માંટે તેને પવિત્ર કરજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ત્યાર પછી તું તેના પુત્રોને આગળ લાવીને અંગરખાં પહેરાવજે. ");
INSERT INTO guj2009_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","તેમના પિતાની જેમ તમને પણ અભિષેક કરી યાજકપદે દીક્ષિત કરજે. તેમનો અભિષેક કરવાથી તેઓ અને તેમના વંશજો કાયમ માંટે યાજકો બનશે.” ");
INSERT INTO guj2009_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","યહોવાએ મૂસાને જે આજ્ઞા કરી હતી તે પ્રમાંણે કરવા માંટે મૂસા આગળ વધ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","બીજા વર્ષના પ્રથમ માંસના પ્રથમ દિવસે પવિત્રમંડપ ઊભો કરવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","મૂસાએ કૂભીઓ ગોઠવી. પાટિયાં બેસાડયાં, વળીઓ જડી દીધી અને થાંભલીઓ ઊભી કરી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","યહોવાએ તેને કહ્યું હતું તે પ્રમાંણે પવિત્રમંડપ ઉપર આવરણ પાથરી દીધું અને છેક ઉપર આચ્છાદન લગાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","અને તેની પર યહોવાની આજ્ઞા મુજબ ઢાંકણ પાથરી દીધું. તેણે સાક્ષ્યલેખ કોશમાં મૂકી, કડાંમાં દાંડીઓ બેસાડી કરારકોશને મથાળે ઢાંકણ મૂકી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","પછી પવિત્રકોશને તે પવિત્રમંડપમાં લાવ્યો અને યહોવાની આજ્ઞા અનુસાર તેને ઢાંકવા પડદો લટકાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","મુલાકાતમંડપમાં ઉત્તર બાજુએ તેણે પડદાની બહાર મેજ મૂકયો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","અને તેના ઉપર યહોવાની આજ્ઞા અનુસાર યહોવાને ધરાવેલી રોટલી મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","મુલાકાત મંડપની અંદર મેજની સામે દક્ષિણ બાજુએ તેમણે દીવી મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","અને યહોવાની આજ્ઞા મુજબ તેના ઉપર યહોવા સમક્ષ દીવા સળગાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","મુલાકાતમંડપમાં પડદાની આગળ તેણે સોનાની વેદી મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","યહોવાની આજ્ઞા અનુસાર તેમાં સુંગધી ધૂપ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","પવિત્રમંડપના પ્રવેશદ્વારે તેણે પડદો લટકાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","તેણે મુલાકાતમંડપના પ્રવેશદ્વાર પર અર્પણોને બાળવા માંટે વેદી ગોઠવી, અને તેના ઉપર બળેલાં દહનાર્પણ અને ખાધાર્પણ અર્પવા આ બધું તેણે દેવની આજ્ઞા મુજબ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","તેણે મુલાકાતમંડપ અને વેદીની વચ્ચે કૂડી ગોઠવી અને તેમાં હાથપગ ધોવા માંટે પાણી રેડયું; ");
INSERT INTO guj2009_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","મૂસા અને હારુન અને તેના પુત્રો મુલાકાતમંડપમાં પ્રવેશ કરવા અથવા આહુતિ અર્પણ કરવા વેદી પાસે જતા. ");
INSERT INTO guj2009_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ત્યારે યહોવાએ મૂસાને આજ્ઞા કર્યા મુજબ એમાંથી હાથપગ ધોતા. ");
INSERT INTO guj2009_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","તેણે પવિત્રમંડપ અને વેદીની ચારેબાજુ આંગણું ઊભું કર્યુ. અને આંગણાના પ્રવેશદ્વારે પડદા વડે દરવાજો બનાવ્યો. આ પ્રમાંણે મૂસાએ કાર્ય પરિપૂર્ણ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ત્યારબાદ મુલાકાતમંડપને વાદળે ઘેરી લીધો. અને યહોવાનું ગૌરવ મંડપમાં વ્યાપી ગયું. ");
INSERT INTO guj2009_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","મૂસા મુલાકાત મંડપમાં પ્રવેશી શકયો નહિ, કેમ કે, વાદળ તેના પર સ્થિર થયું હતું, અને યહોવાનું ગૌરવ મંડપમાં પ્રસરી ગયું હતું. ");
INSERT INTO guj2009_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ઇસ્રાએલીઓના પ્રવાસના પ્રત્યેક મુકામે જયારે વાદળ મંડપ પરથી હઠી જતું ત્યારે તે લોકો મુકામ ઉપાડતા. ");
INSERT INTO guj2009_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","પણ જો વાદળ પવિત્રમંડપ ઉપર સ્થિર થતું તો વાદળ હઠે નહિ ત્યાં સુધી તેઓ મુકામ ઉપાડતા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","દિવસ દરમ્યાન મુલાકાતમંડપ પર વાદળ આચ્છાદન કરે અને રાતે વાદળ અગ્નિમય બની જાય, એટલે ઇસ્રાએલી લોકો સમગ્ર પ્રવાસ દરમ્યાન પ્રત્યેક મુકામને જોઈ શકતા. ");
INSERT INTO guj2009_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","યહોવા દેવે મૂસાને મુલાકાતમંડપમાં બોલાવીને તેને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“તું ઇસ્રાએલના પુત્રોને આ પ્રમાંણે આજ્ઞા કર; જયારે તમાંરામાંથી કોઈ પણ વ્યક્તિ યહોવાને અર્પણ ચઢાવે ત્યારે તેણે કાં તો કોઈ ઢોર અર્પણ કરવું કાં તો ઘેટાંબકરાં અર્પણ કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“જો કોઈ અર્પણ ઢોરના દહનાર્પણનું હોય, તો તે બળદ હોવું જોઈએ અને તે ખોડખાંપણ વગરનું હોવું જોઈએ. તેણે ઢોરને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લાવવું જેથી યહોવા માંટેના તે અર્પણનો યાજકો સ્વીકાર કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","જે વ્યક્તિ તે ઢોરને લઈને આવે તેણે પોતાનો હાથ તે દહનાર્પણના માંથા પર મૂકવો એટલે પ્રાયશ્ચિત્ત કરવા તેનો સ્વીકાર કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“પછી તે દહનાર્પણને યહોવા સમક્ષ વધેરે; અને હારુનના પુત્રો – યાજકો તેનું લોહી યહોવાને ધરાવી મુલાકાતમંડપના પ્રવેશદ્વાર આગળ આવેલી વેદીની ચારે બાજુએ છાંટે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","પછી યાજકો તે દહનાર્પણનું ચામડું ઉતારી તેના ટુકડા કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","પછી હારુનના પુત્રો યાજકોએ વેદી પર લાકડાં ગોઠવીને તેમાં આગ ચાંપે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ત્યાર પછી તેમણે તે ઢોરના ટુકડા, માંથું અને ચરબી, વેદી પરના બળતા લાકડાની અગ્નિમાં હોમવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","યાજકે ઢોરના આંતરડાં અને પગ પાણીથી ધોઈ નાખવાં અને યાજકે તે બધુ દહનાર્પણ તરીકે વેદી પર મૂકવું. સુવાસિત દહનાર્પણ યહોવા સ્વીકાર કરશે અને પ્રસન્ન થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“જો દહનાર્પણ તરીકે પસંદ કરેલું પ્રાણી ઘેટું કે બકરું હોય, તો તે ખોડખાંપણ વગરનું નર પ્રાણી જ હોવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","જે વ્યક્તિ તે અર્પણ લાવે તે યહોવાની સમક્ષ વેદીની ઉત્તર બાજુએ તેને વધેરે, અને હારુનના પુત્રો-યાજકો તેનું લોહી વેદીની આગળ પાછળ અને ચારે બાજુએ છાંટે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","પછી યાજક ઢોરના ટુકડા કરે અને તે ટુકડાઓને (માંથાને તથા પગને) વેદી પર ગોઠવેલાં લાકડાં પર હોમે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","પછી યાજક ઢોરના આંતરડાં અને પગ પાણીમાં ધોઈ નાખે તેણે ઢોરના બધા અંગોને વેદી પર હોમીને યહોવાને અર્પણ કરવા. કેમકે આ દહનાર્પણ છે અને એ દહનાર્પણની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“જો કોઈ દહનાર્પણો તરીકે યહોવાને પક્ષી ચઢાવે તો તેણે કાં તો હોલાનું બચ્ચું ચઢાવવું, કાં તો કબૂતરનું બચ્ચું ચઢાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","યાજક તેને વેદી આગળ ઘરાવે અને તેની ડોક મરડીને માંથું જુદું કરે અને તેનું વેદી પર દહન કરે, અને લોહી વેદીની એક બાજુએ રેડી દે. ");
INSERT INTO guj2009_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","પછી યાજકે તેના પીછાં અને ગળા પાસેની કોથળી કાઢી નાખવી અને તેને વેદીની પૂર્વ બાજુએ રાખ નાખવાની જગા ઉપર ફેંકી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","પછી યાજક તે પક્ષીને બે પાંખો વચ્ચેથી ચીરે પરંતુ તેના બે ભાગ જુદા થવા ન દે, અને તેને વેદી પરના અગ્નિમાંનાં લાકડાં પર હોમી દે, આ પણ એક દહનાર્પણ છે અને એ યજ્ઞની સુવાસથી યહોવા પ્રસન્ન થાય છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","જો કોઈ વ્યક્તિ યહોવા દેવને ખાદ્યાર્પણ ચઢાવવા ઈચ્છે, તો તેણે મેંદાનો લોટ લાવવો અને તેમાં તેલ રેડવું અને તે પર લોબાન મૂકવો. ");
INSERT INTO guj2009_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","પછી તેણે એ હારુનના પુત્રો – યાજકો સમક્ષ લાવવું. પછી એક યાજક તેમાંથી એક મૂઠી લોટ, તેલ અને બધો લોબાન લઈને તેને પ્રતીકરૂપે વેદી પર હોમે. આ ખાદ્યાર્પણ અગ્નિ દ્વારા થાય છે તેની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ખાદ્યાર્પણનો બાકીનો ભાગ યાજકોને મળે છે. તે અત્યંત પવિત્ર છે. કારણ કે યહોવાને ધરાવેલા દાણાના અર્પણમાંથી તે લેવામાં આવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“જો કોઈ વ્યક્તિ ભઠ્ઠીમાં બનાવેલી રોટલી યહોવા સમક્ષ ખાદ્યાર્પણ તરીકે લાવે તો તે પણ મેંદાની જ હોય, અને તે તેલથી મોયેલા લોટની બેખમીર પોળીઓ અથવા તેલ ચોપડેલા બેખમીર ખાખરા જ હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","જો તમે તમાંરું ખાદ્યાર્પણ કડાઈમાં રાંધેલું લાવો, તો તે પણ તેલથી મોયેલા મેંદાનું જ બનાવેલું અને ખમીરવાળુ હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","તેના ટુકડા કરીને તેના પર તેલ રેડવું; એ ખાદ્યાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","જો કોઈનું ખાદ્યાર્પણ તવા પર શેકેલું હોય તો તે તેલનું મોણ નાખેલા મેંદાનું બનાવેલું હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“આ રીતે શેકેલું, તળેલું આ ખાદ્યાર્પણ યાજક પાસે લાવવું અને તે તેને વેદી પર યહોવા સમક્ષ અર્પણ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","અને પછી યાજક તેમાંથી પ્રતીકરૂપે થોડો ભાગ લઈ ખાદ્યાર્પણ તરીકે વેદીમાંના અગ્નિમાં હોમશે. એની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ખાદ્યાર્પણનો બાકીનો ભાગ યાજકોનો ગણાય. એ અત્યંત પવિત્ર છે, કારણ, યહોવાને ધરાવેલા હોમયજ્ઞમાંથી એ ગ્રહણ કરવામાં આવેલ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“યહોવાને અર્પણ કરવાના કોઈ પણ પ્રકારના ખાદ્યાર્પણમાં આથો ન વાપરવો, અર્થાત ખમીરનો ઉપયોગ કરવો નહિ. કોઈ પણ વ્યક્તિએ દહનાર્પણમાં ખમીર કે મધનો ઉપયોગ કરવો નહિ, કારણ કે તેની છૂટ નથી. ");
INSERT INTO guj2009_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","કોઈ પણ વ્યક્તિ તે વસ્તુઓ ખમીર અને મધ પાકના પ્રથમ ભાગ તરીકે એ ધરાવી શકે પરંતુ તે વસ્તુઓ આહુતિ તરીકે વેદીમાં મીઠો ધુમાંડો બને એ રીતે હોમવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","પરંતુ તમાંરે તમાંમ પ્રકારની ખાદ્યાર્પણમાં મીઠું નાખવું. તમાંરા ખાદ્યાર્પણ પર દેવનો અતૂટ કરાર છે, તેથી તેના પ્રતીકરૂપ મીઠું નાખવાનું કદી ભૂલવું નહિ. બધાજ અર્પણોમાં મીઠું ઉમરેવું અને ચઢાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“જો કોઈ વ્યક્તિ પાકના પ્રથમ ભાગ તરીકે અનાજ ખાદ્યાર્પણ તરીકે ચઢાવે તો તેણે તાજાં કણસલાંના પોંકરૂપે અથવા દળેલા લોટરૂપે ચઢાવે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ખાદ્યાર્પણનાં પર તેલ રેડવું અને ઉપર લોબાન મૂકવો, એ ખાદ્યાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","યાજક પ્રતીકરૂપે તેમાંથી થોડો લોટ અને તેલ તથા બધો લોબાન લઈ યહોવાને ખાદ્યાર્પણ તરીકે વેદીની અગ્નિમાં હોમવો.” ");
INSERT INTO guj2009_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","જો કોઈ વ્યક્તિ યહોવા સમક્ષ શાંત્યર્પણ લાવવા ઈચ્છતો હોય, તે પશુ ગાય પણ હોઈ શકે, તે અર્પણ પશુ હોય તો નર હોય કે માંદા હોય, પણ તે ખોડખાંપણ વગરનું હોવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","જે વ્યક્તિ તે પશુ લાવે તે તેના માંથા પર પોતાનો હાથ મૂકે અને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તેને વધેરે, ત્યાર પછી હારુનના પુત્રો-યાજકો તેનું લોહી વેદીની ચારે બાજુએ છાંટે. ");
INSERT INTO guj2009_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","તે વ્યક્તિએ પશુના નીચેનો ભાગ યહોવાને શાંત્યર્પણ તરીકે ચઢાવવા: આંતરડાં ઉપરની અને તેની આજુબાજુની બધી ચરબી, ");
INSERT INTO guj2009_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","બંને મૂત્રપિંડ અને તે ઉપરની કમર પાસેની ચરબી, તેમજ કાળજા અને મૂત્રપિંડ પરની ચરબી. ");
INSERT INTO guj2009_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","આ તમાંમ યાજકોએ દહનાર્પણ ઉપરાંત વેદી પરના લાકડાંના અગ્નિમાં હોમવું. એ યજ્ઞની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“જો કોઈ વ્યક્તિ શાંત્યર્પણ તરીકે બકરું કે ઘેટું યહોવા સમક્ષ લાવે, તો પણ તેનામાં કોઈ ખોડખાંપણ હોવી જોઈએ નહિ, વળી તે નર કે માંદા કોઈપણ હોઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","જો કોઈ વ્યક્તિ ઘેટું ચઢાવતો હોય તો; ");
INSERT INTO guj2009_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","તેણે યહોવા સમક્ષ ઘરાવી તેના માંથા પર હાથ મૂકી મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તેને વધેરવું. ત્યારબાદ હારુનના પુત્રો – યાજકોએ તેનું લોહી વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","પછી પ્રાણીના નીચે જણાવેલા ભાગો શાંત્યર્પણમાંથી હોમયજ્ઞ તરીકે યહોવા સમક્ષ ચઢાવવા: બધી ચરબી, મેરુ દંડને અડીને કાપી નાખેલી આખી જાડી પૂછડી, આંતરડાં ઉપરની અને તેની આસપાસની બધી જ ચરબી ");
INSERT INTO guj2009_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","બંને મૂત્રપિંડો અને તેમના પરની કમર પાસેની ચરબી, કાળજા અને મૂત્રપિંડો પરની ચરબી, ");
INSERT INTO guj2009_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","યાજકે યહોવા સમક્ષ શાંત્યર્પણ તરીકે આ બધું હોમી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“જો કોઈ વ્યક્તિ બકરું અર્પણ કરવા લાવે તો, ");
INSERT INTO guj2009_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","તેણે યહોવા સમક્ષ ઘરાવીને તેના માંથા પર હાથ મૂકી મુલાકાતમંડપમાં પ્રવેશદ્વાર આગળ તેને વધેરવું. ત્યારબાદ હારુનના પુત્રો-યાજકોએ તેનું લોહી વેદીની ચારે બાજુએ છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","યાજકે તેના નીચેના ભાગ યહોવાને શાંત્યર્પણ તરીકે ચઢાવવા: આંતરડાં પરની અને તેની આસપાસની બધી જ ચરબી, ");
INSERT INTO guj2009_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","બંને મૂત્રપિંડો અને તેની પરની કમર પાસેની ચરબી, કાળજા તેમજ મૂત્રપિંડો પરની ચરબી. ");
INSERT INTO guj2009_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","આ તમાંમ યાજકે શાંત્યર્પણ તરીકે હોમી દેવું. એની સુવાસથી યહોવા પ્રસન્ન થાય છે. બધી જ ચરબી યહોવાની ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","તમે ગમે ત્યાં નિવાસ કરતા હો, તમાંરી બધી જ પેઢીઓ માંટે તમાંરા દેશમાં સર્વત્ર આ કાયમી નિયમ છે; તમાંરે કદી પણ ચરબી કે લોહી ખાવા નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","તે પછી યહોવાએ મૂસાને બીજી સૂચનાઓ આપી અને તેને કહ્યું કે, “ઇસ્રાએલના લોકોને કહે જે કૃત્યો કરવાની યહોવાએ મના કરી છે તે ન કરવા તેનું પાલન કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","જો કોઈ વ્યક્તિ અજાણતા માંરા આદેશોનું ઉલ્લંઘન કરે તેને માંટે આ નિયમો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“જો અભિષિક્ત યાજક એવી રીતે ભૂલ કરે અને લોકોને દોષમાં નાખે. તો તેણે પોતે કરેલાં પાપના પ્રાયશ્ચિત રૂપે યહોવાને એક ખોડખાંપણ વગરનો બળદ તેણે કરેલા પાપાર્થાર્પણ માંટે અર્પણ તરીકે ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","તેણે બળદને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લાવી તેના માંથા પર હાથ મૂકી તેને યહોવાની સમક્ષ વધેરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","પછી અભિષિક્ત યાજક તેનું લોહી લઈને મુલાકાત મંડપમાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","અને પછી લોહીમાં પોતાની આંગળી બોળી યહોવા સમક્ષ સાત વખત પરમપવિત્રસ્થાનના પડદા પર લોહીના છાંટા નાખે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ત્યારબાદ તેણે થોડું લોહી મુલાકાતમંડપની અંદર યહોવા સમક્ષ ધૂપની વેદીના ખૂણાઓ ઉપર રેડવું અને બાકીનું લોહી મુલાકાત મંડપના પ્રવેશદ્વાર આગળના યજ્ઞવેદીના પાયા આગળ રેડી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","પછી તેણે પાપાર્થાર્પણના બળદની બધી ચરબી કાઢી લેવી; આંતરડાં પરની અને તેની આસપાસની ચરબી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","બે મૂત્રપિંડો અને તેની પરની કમર પાસેની ચરબી અને કાળજા તેમજ મૂત્રપિંડો પરની બધી જ ચરબી કાઢીને બાજુએ રાખવી, ");
INSERT INTO guj2009_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","અને પછી તે બધી ચરબી યાજકે યજ્ઞવેદી પર હોમી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","પરંતુ જુવાન વાછરડાનો બાકીનો ભાગચામડું, માંસ, માંથું, પગ, આંતરડાં, ");
INSERT INTO guj2009_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","અને છાણ, છાવણીની બહાર પવિત્રસ્થાને લઈ જઈ ત્યાં રાખ નાખવાની જગ્યાએ લાકડાં સળગાવીને તેને બાળી મૂકવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“જો સમગ્ર ઇસ્રાએલની પ્રજા અજાણતાં પાપ કરીને યહોવાની આજ્ઞાનો ભંગ કરી દોષમાં પડે તો, ");
INSERT INTO guj2009_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","તેની જાણ થતાં જ મંડળીએ પાપાર્થાર્પણ તરીકે ખોડખાંપણ વગરનો બળદ ચઢાવવો. બળદને મુલાકાતમંડપ આગળ લાવી, ");
INSERT INTO guj2009_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","વડીલોએ તેના માંથા પર હાથ મૂકી યહોવા સમક્ષ તેને વધેરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ત્યાર પછી અભિષિક્ત યાજકે તેનું થોડું લોહી મુલાકાતમંડપમાં લાવી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","તેમાં આંગળી બોળી યહોવા સમક્ષ સાત વખત પડદા પર છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ત્યારબાદ થોડું લોહી તેણે મુલાકાતમંડપની અંદર યહોવા સમક્ષ વેદીના ખૂણાઓ પર રેડવું, અને બાકીનું બધું લોહી મુલાકાતમંડપના પ્રવેશદ્વાર આગળની યજ્ઞ વેદીનાં પાયામાં રેડી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ત્યારબાદ તેણે બળદની ચરબી કાઢી લઈ વેદીના લાકડાંના અગ્નિમાં બાળી મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","તેણે પાપાર્થાર્પણના બળદની જેમજ એ બળદનું પણ કરવું, એ રીતે યાજક લોકોને શુદ્ધ કરશે અને યહોવા તેમને માંફ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","પછી પેલા બળદની જેમ આને પણ છાવણીની બહાર લઈ જઈ બાળી મૂકવો, આ વખતે આ પાપાર્થાર્પણ સમગ્ર પ્રજાને માંટે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“જો કોઈ પ્રજાના આગેવાનોમાંથી અજાણતા પાપ કરે અને દેવના નિયમનું ઉલ્લંઘન કરી દોષિત ઠરે, ");
INSERT INTO guj2009_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ત્યારે એની જાણમાં આવતાં જ તેણે ખોડખાંપણ વગરનો નર બકરો લાવી, જ્યાં આહુતિ ચઢાવવામાં આવે છે, ");
INSERT INTO guj2009_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ત્યાં યહોવા સમક્ષ તેના માંથા પર હાથ મૂકી તેને વધેરવો. આ પાપાર્થાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ત્યારબાદ યાજકે પશુનું લોહી આંગળી વડે લઈ યજ્ઞવેદીનાં ટોચકાં પર લગાડવું, અને બાકીનું લોહી યજ્ઞવેદીના પાયામાં રેડી દેવું અને અર્પણની આહુતિની ચરબીની જેમ એની બધી જ ચરબી વેદી પર બાળી મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","આમ યાજક રાજાને શુદ્ધ કરશે અને યહોવા તેને માંફ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“જો કોઈ સામાંન્ય માંણસ અજાણતા પાપ કરે અને યહોવાની કોઈ આજ્ઞાનો ભંગ કરીને દોષમાં પડે તો, ");
INSERT INTO guj2009_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","તેની જાણ થતાં તેણે પોતે કરેલાં પાપોના પ્રાયશ્ચિત માંટે એક ખોડખાંપણ વગરની બકરી પાપાર્થાર્પણ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","તેણે તેના માંથા પર હાથ મૂકી, જયાં યજ્ઞ ચઢાવવામાં આવે છે ત્યાં તેનો વધ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","યાજકે તેનું થોડું લોહી આંગળી પર લઈને યજ્ઞવેદીનાં ખુણાઓ પર લગાડવું, અને બાકીનું બધું જ લોહી વેદીના પાયામાં રેડી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","શાંત્યાર્પણની વિધિની જેમ યાજકે તેની બધી ચરબી કાઢી લેવી અને વેદી પર તેનું દહન કરવું; અને યહોવા તેનો સ્વીકાર કરશે. એની સુવાસથી યહોવા પ્રસન્ન થાય છે. યાજક આ રીતે તે માંણસને માંટે પ્રાયશ્ચિત કરશે અને યહોવા તેને માંફ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“પણ જો કોઈ માંણસ પાપાર્થાર્પણ તરીકે હલવાન લાવે તો તે માંદા હોવું જોઈએ અને ખોડખાંપણ વગરનું હોવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","તેણે તેના માંથા પર હાથ મૂકી જયાં દહનાર્પણના પશુનો વધ કરવામાં આવે છે, ત્યાં પાપાર્થાર્પણ તરીકે તેનો વધ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","પછી યાજકે પાપાર્થાર્પણનું થોડું લોહી આંગળી પર લઈને યજ્ઞવેદીનો ખૂણાઓ પર લગાડવું. અને બાકીનું બધું લોહી વેદીના પાયામાં રેડી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","યાજકે શાંત્યાર્પણના પશુની જેમ તેની બધી જ ચરબી કાઢી લેવી અને યહોવાને બીજા કોઈપણ અગ્નિના અર્પણની જેમ યાજકે તેને વેદી પર હોમી દેવું. આ રીતે યાજક તે વ્યક્તિને તેના પાપમાંથી શુદ્ધ કરે છે, અને યહોવા તે વ્યક્તિને માંફ કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ગુન્હા વિષે જાણનાર વ્યક્તિને ન્યાયાલયમાં સાક્ષી પૂરવા બોલાવવામાં આવે અને તે પોતે જ જોયેલું કે જાણેલું હોય તે ન જણાવે તો તે પાપમાં પડે અને તેની સજા તેણે ભોગવવી પડે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“જો કોઈ માંણસ અજાણતાં કોઈ પણ અશુદ્ધ વસ્તુ, જેવી કે ખોરાક માંટે ના કરી હોય એવા જંતુના મૃત શરીરને અથવા જંગલી કે પાળેલા પ્રાણીના મૃત શરીરને સ્પર્શ તો તે દોષિત ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“જો કોઈ માંણસ અજાણતાં માંણસનો કોઈ પણ જાતની મલિનતાનો સ્પર્શ કરે અને જેવી તેના વિષે તેને જાણ થાય કે તરત જ તે દોષપાત્ર ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“જો કોઈ માંણસ ઉતાવળમાં સમ ખાય અને તેને પાળવાનું ભૂલી જાય અને મોડેથી તેની જાણ થાય, તો તે દોષિત ગણાય; ");
INSERT INTO guj2009_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","આમાંની કોઈ પણ બાબતમાં, જો કોઈ વ્યક્તિ દોષિત હોય તો તેણે પોતાનો દોષ કબૂલ કરવો, ");
INSERT INTO guj2009_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","અને પોતાના પાપના પ્રાયશ્ચિતરૂપે યહોવા સમક્ષ માંદા હલવાન કે બકરી લાવે, અને યાજકે તેનો પ્રાયશ્ચિતવિધિ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“પરંતુ જો તે ગરીબ હોય અને માંદા હલવાન કે બકરી ચઢાવી ન શકે, તો તેણે યહોવાને બે હોલા અથવા કબૂતરનાં બે બચ્ચાં ચઢાવવાં, એક પાપાર્થાર્પણ તરીકે અને એક દહનાર્પણ તરીકે, ");
INSERT INTO guj2009_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","તેણે એ લાવીને યાજકને આપવાં, યાજકે પહેલાં પાપાર્થાર્પણ ચઢાવવું, તેણે તેની ડોક મરડી પંખીને માંરી નાખવું, અને તેનું માંથું તેની ડોકથી જુદુ કરી નાખવું, પણ તેને પંખીના બે ભાગ ન કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","પછી તેનું થોડું લોહી વેદીની બાજુ પર છાંટવું. અને બાકીનું લોહી વેદીના પાયામાં રેડી દેવું એ પાપાર્થાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ત્યારબાદ બીજું પક્ષી તેણે વિધિપૂર્વક દહનાર્પણ તરીકે હોમી દેવું. આ રીતે તેનું અર્પણ થાય છે. આ રીતે યાજક તે વ્યક્તિને પાપમાંથી શુદ્ધ કરે છે અને તેને માંફ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“જો કોઈ માંણસ બે હોલા કે કબૂતરનાં બે બચ્ચાં ચઢાવી શકે તેમ ના હોય, તો તેણે પાપાર્થાર્પણ તરીકે આઠ વાટકા લોટ ચઢાવવો. અને તેણે તેમાં તેલ કે લોબાન ન મૂકવાં, કારણ, તે પાપાર્થાર્પણ છે, ");
INSERT INTO guj2009_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","તેણે એ લાવીને યાજકને સોંપવા અને તેણે પ્રતીક તરીકે તેમાંથી મૂઠી ભરીને લોટ લઈ વેદી પર યહોવાને ચઢાવેલાં અન્નના અર્પણ ભેગો હોમી દેવો. એ પ્રાયશ્ચિત માંટેનું અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","યાજકે આ રીતે તેના પાપનું પ્રાયશ્ચિત કરવા માંટેની વિધિ કરવી, એટલે તે માંણસને માંફ કરવામાં આવશે, બાકીનો લોટ ખાદ્યાર્પણની જેમ યાજકનો થશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“જો કોઈ વ્યક્તિ અજાણતાં પવિત્રવસ્તુઓ સાથે કઈ ખોટુ કરીને પાપ કરે; તો તેણે દોષાર્થપણ માંટે ખોડખાંપણ વગરનો એક ઘેટો લાવવો. તેણે પોતાનું પાપ શુદ્ધ કરવા ઘેટાને યહોવા સમક્ષ લાવવો. તમાંરે અધીકૃત માંપ વાપરી ઘેટાની કિંમત આંકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","અને જે પવિત્ર વસ્તુને ખોટું થયું છે તેની કિંમત તે ભરપાઈ કરે, તેણે જેના સમ લીધા હોય તે લાવવું. અને તેમાં પાંચમો ભાગ ઉમેરીને તે પૈસા યાજકને આપવા. ત્યારબાદ યાજક તેને દોષાર્થાપણના ઘેટાંથી તેને શુદ્ધ કરશે અને તેને માંફ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“જો કોઈ વ્યક્તિ અજાણતાં યહોવાએ આપેલા કોઈ પણ નિયમનું ઉલ્લંઘન કરી પાપ કરે; તો તે દોષિત ઠરે અને તેના પાપની જવાબદારી તેને માંથે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","આ દોષાર્થાર્પણ ને માંટે ખોડખાંપણ વગરનો ઘેટો હોય, અને તેને લાવીને યાજકને આપવો, અને તે તેની કિંમત મંદિરના ધોરણે ઠરાવવી. યાજકે તેણે અજાણતાં કરેલા પાપનો પ્રાયશ્ચિતવિધિ કરવો એટલે તેને માંફ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","આ દોષાથાર્પણ માંટેનું અર્પણ છે, કારણ, તેણે યહોવાનો ગુનો કર્યો છે, અને તે યહોવા સમક્ષ દોષિત છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","અને યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“જો કોઈ વ્યક્તિ કોઈની થાપણ પાછી ન આપે અથવા પોતે ભાડે આપેલી વસ્તુની લીધેલી અનામત અથવા તેની પર વિશ્વાસ કરીને તેને સોંપેલી વસ્તુ પાછી આપવાની ના પાડે, ચોરી કરે, છેતરે કે પોતાના પડોશી પર અન્યાય કરીને કોઈ વસ્તુ મેળવે, ");
INSERT INTO guj2009_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","અથવા કોઈની ખોવાયેલી વસ્તુ તેને જડી હોય, ને તેની ના પાડે, અથવા આવા કોઈ પણ પાપની બાબતમાં ખોટા સમ ખાય, અને એ રીતે યહોવાનો ગુનેગાર બને; ");
INSERT INTO guj2009_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","તો તે દોષિત છે, તેણે જે કાંઈ ચોરી લીધું હોય, બળજબરીથી લીધું હોય અથવા છેતરીને લીધું હોય, અથવા રાખવા લીધું હોય અથવા મળ્યું હોય અને તેના વિષે ખોટુ બોલ્યો હોય અથવા બીજી કોઈપણ વાતમાં તેણે ખોટા સમ ખાધા હોય તો. ");
INSERT INTO guj2009_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","તેને આખી કિંમત વીસ ટકા ઉમેરીને તે રકમ સાચા માંલિક ને આપવી; અને એ જ દિવસે તેને પોતાનું દોષાર્થાર્પણ લાવે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","તેણે એક ખોડખાંપણ વગરનો ઘેટો યાજક પાસે યહોવાને પ્રાયશ્ચિત તરીકે લાવવો અને તેની કિંમત મંદિરના ધોરણે ઠરાવવી. ");
INSERT INTO guj2009_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","પછી યાજકે યહોવા સમક્ષ તેનો પ્રાયશ્ચિતવિધિ કરવો, એટલે તેણે જે કાંઈ પાપ કર્યું હશે તેને માંફ કરવામાં આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“હારુન અને તેના પુત્રોને દહનાર્પણને લગતા આ નિયમો આપ: “દહનાર્પણો વેદી પરની કઢાઈ ઉપર આખી રાત રાખવામાં આવે અને વેદીનો અગ્નિ સતત સળગતો રહે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","અને યાજક પોતાના અંદર અને બહાર શણનાં કપડાં પહેરે અને દહનાર્પણની રાખ સાફ કરે અને તેને વેદીની બાજુમાં ભેગી કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ત્યાર પછી તેણે વસ્ત્રો બદલવાં અને એ રાખ છાવણી બહાર સ્વચ્છ જગ્યાએ લઈ જવી. ");
INSERT INTO guj2009_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","તે દરમ્યાન વેદીનો અગ્નિ સતત બળતો રાખવો, તેને કદી હોલવવા ન દેવો. પ્રતિદિન સવારે યાજકે તેમાં લાકડાં મૂકવાં અને તેના ઉપર દહનાર્પણ ગોઠવવું, અને તેના ઉપર શાંત્યર્પણની ચરબીનુ દહન કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","વેદીનો અગ્નિ સતત બળતો રાખવો તે કદી ઓલવાવો જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ખાદ્યાર્પણ માંટેના નિયમો આ પ્રમાંણે છે: હારુનના પુત્રો-યાજકો ખાદ્યાર્પણ યહોવાને ચઢાવવા વેદી સમક્ષ ઊભા રહે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","પછી તેણે એ ખાદ્યાર્પણોમાંથી મૂઠી ભરીને મેંદો. તેલ અને બધો જ લોબાન પ્રતીક તરીકે લઈને યહોવાને માંટે વેદીમાં હોમી દેવો, એની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“મૂઠ્ઠીભર લોટ લીધા પછી જે બાકી રહે તે, ખોરાક માંટે હારુન અને તેના પુત્રો-યાજકોનો ગણાય; મુલાકાત મંડપનાં ચોકમાં તેને ખમીર વગર ખાવો. ");
INSERT INTO guj2009_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","એમાં ખમીર ન નાખવું. મેં અગ્નિ દ્વારા મળેલ ખાદ્યાર્પણના તેમના ભાગરૂપે તેમને આપેલા છે. પાપાર્થાર્પણ અને દોષાથાર્પણના અર્પણની જેમ એ પરમ પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","હારુનના વંશનો કોઈ પણ વ્યક્તિ એ ખાઈ શકશે, યહોવાને ચઢાવેલા ખાદ્યાર્પણના અર્પણનો તેમને પેઢી દર પેઢી કાયમનો ભાગ મળશે, એનો સ્પર્શ જે કોઈ કરશે તે શુદ્ધ બની જશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“હારુન અને તેના પુત્રોએ પોતાના અભિષેકના દિવસે એટલે કે તેઓ યાજક વર્ગમાં પ્રવેશે તે દિવસે તેઓ યહોવા સમક્ષ ખાદ્યાર્પણ લાવે, એટલે કે આઠ વાટકા લોટ જેને રોજના અર્પણના સમયે અર્પણ કરવામાં આવશે, અડધો સવારે અને અડધો સાંજે, એને તેલથી મોહીને તવા પર શેકીને, ");
INSERT INTO guj2009_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","તેને ભઠ્ઠીમાં તવી ઉપર તેલથી તળવામાં આવે અને તેને બરાબર શેકવામાં આવે, પછી તેને યહોવા સમક્ષ અર્પણ તરીકે લાવવામાં આવે, તમાંરે અર્પણના ટુકડા કરી નાખવા. તેની સુવાસથી યહોવાને બહુ આનંદ થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“જયારે યાજકના પુત્ર પોતાના પિતાની (હારુનની) ઊચા યાજક તરીકે જગ્યા ધારણ કરે ત્યારે તેણે આ ખાદ્યાર્પણને સંપૂર્ણ રીતે બાળી નાખીને અર્પણ કરવું. આ કાયમી નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","યહોવાને ચઢાવેલો એ ખાદ્યાર્પણ પૂરેપૂરો હોમી દેવાનો છે, તેમાંનું કશુંય કોઈએ પણ જમવાના ઉપયોગમાં લેવું નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“હારુન અને તેના પુત્રોને પાપાર્થર્પણ વિષેના આ નિયમો કહે: પાપાર્થાર્પણનું પશુ યહોવા સમક્ષ જયાં દહનાર્પણના પશુને વધેરવામાં આવે છે, ત્યાં વધેરવું એ અત્યંત પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","વિધિ કરનાર યાજકે એ મુલાકાત મંડપના ચોકમાં પવિત્રસ્થાને જમવું. ");
INSERT INTO guj2009_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","જે કાંઈ એને અડે તે પવિત્ર ગણાય. “જો એના લોહીના છાંટા કોઈ કપડાં પર પડયા હોય તો તે પવિત્રસ્થાને ધોઈ નાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","માંટીનાં જે વાસણમાં માંસને ઉકાળ્યું હોય તેને ભાંગી નાખવું અથવા જો કાંસાનું વાસણ વાપર્યુ હોય તો તેને ઘસીને ચકચકિત કરવું અને વીછળી નાખીને બરાબર ધોઈ નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“યાજકના પરિવારનો કોઈ પણ માંણસ આ પાપાર્થાર્પણમાંથી જમી શકે, કારણ કે તે અત્યંત પવિત્ર અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","પરંતુ જો પાપાર્થાર્પણનું લોહી મુલાકાત મંડપમાં લાવીને પાપાર્થાર્પણમાં વપરાયું હોય તો પાપાર્થાર્પણ યાજકોએ ખાવો નહિ. અને અગ્નિમાં પૂરેપૂરો હોમી દેવો. ");
INSERT INTO guj2009_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“દોષાર્થાર્પણ માંટે લવાતાં અતિ પવિત્ર અર્પણો માંટેના નિયમો આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","દોષાર્થર્પણ માંટેના અર્પણના પશુનો વધ, જયાં દહનાર્પણના પશુનો વધ થતો હોય ત્યાં કરવો અને તેનું લોહી વેદી પર અને ફરતું છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“યાજકે એની બધી ચરબી કાઢી લઈ વેદી પર ચઢાવવી, જાડી પૂંછડી, આંતરડા પરની ચરબી, ");
INSERT INTO guj2009_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","બંને મૂત્રપિંડો અને કમરના નીચલા ભાગના સ્નાયુ પરની ચરબી, અને કાળજાનો ચરબીવાળો ભાગ આ સર્વ આહુતિ માંટે એક બાજુ રાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","યાજકે યહોવાને ચઢાવવામાં આવેલી આહુતિ તરીકે વેદી પર હોમી દેવી. એ દોષાર્થાર્પણની આહુતિ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“યાજકના પરિવારનો કોઈ પણ પુરુષ સભ્ય તે જમી શકે. તે અતિ પવિત્ર છે; તેથી તે પવિત્ર જગ્યાએ જ જમવું. ");
INSERT INTO guj2009_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","પાપાર્થાર્પણ તથા દોષાર્થાર્પણ માંટે એક જ નિયમ છે. એ યજ્ઞ કરનાર યાજકને મળે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","કોઈ વ્યક્તિને ચઢાવેલા દહનાર્પણના પશુનું ચામડું હોમનાર યાજકને મળે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ભઠ્ઠીમાં બનાવેલું, અથવા કડાઈમાં તળેલુ કે તવામાં શેકેલું ખાદ્યાર્પણ તેને ધરાવનાર યાજકનું થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","અન્ય બીજાં બધાં ખાદ્યાર્પણો તેલમાં મોહ્યેલા કે મોહ્યા વગરના હારુનના પુત્રોની-યાજકોની સહિયારી માંલિકીના ગણય. તેથી બધા યાજકોએ તે સરખે ભાગે વહેંચી લેવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“યહોવાને ચઢાવવામાં આવતા શાંત્યર્પણો યજ્ઞો માંટે આ પ્રમાંણેના નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","જો કોઈ વ્યક્તિ આભાર માંટે અર્પણ ચઢાવતો હયો, તો શાંત્યર્પણ ઉપરાંત તેણે મોંયેલી બેખમીર રોટલી, તેલ ચોપડેલી બેખમીર ખાખરા તથા મોંયેલા લોટની પોળીઓ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","શાંત્યર્પણના અર્પણ સાથે ખમીરવાળી રોટલી ભેગી મુકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","આમાંની એક રોટલી જે યાજક શાંત્યર્પણનુ લોહી છાંટે તેને આપવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","જે દિવસે એ અર્પણ ધરાવેલ હોય તે જ દિવસે એનું માંસ જમી લેવું. એમાંથી કશુંય બીજા દિવસે જમવા માંટે રાખવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“જો કોઈ વ્યક્તિ બાધાનો કે સ્વેચ્છાનો અર્પણ ચઢાવતો હોય તો તે ચઢાવે તે જ દિવસે અને તે પછીના દિવસે પણ જમી શકાય. ");
INSERT INTO guj2009_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","પણ ત્રીજા દિવસ સુધી જે વધે તેને બાળી નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","કારણ કે જો તે શાંત્યર્પણ ત્રીજા દિવસે પણ જમવામાં આવે તો યહોવા તેનો સ્વીકાર કરે નહિ. અર્પણ તરીકે તેની કિંમત રહે નહિ: અને જે વ્યક્તિ તે અર્પણ લાવી હશે તેને કોઈ લાભ થશે નહિ અને તે અર્પણ અશુદ્ધ બની જશે. જે માંણસ તે ખાશે તે પોતાના પાપનો જવાબદાર બનશે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“જો માંસ કોઈ અપવિત્ર વસ્તુને અડેલું હોય, તો તે જમી શકાય નહિ, તેથી તેને અગ્નિમાં બાળી મૂકવું. જે વ્યક્તિ શુદ્ધ હોય તે શાંત્યર્પણનું માંસ જમી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","જો કોઈ માંણસ અશુદ્ધ હોય છતાં શાંત્યર્પણમાંથી તે જમે તો તેને તેના લોકોથી જુદો કરવો, કારણ કે તેણે જે પવિત્ર છે તેને અશુદ્ધ કર્યુ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“જો કોઈ વ્યક્તિ અશુદ્ધ માંણસને, કે અશુદ્ધ પશુને કે અશુદ્ધ પેટે ચાલનાર પ્રાણીને અડયો હોય અને પછી યહોવાને ચઢાવેલા શાંત્યર્પણનું માંસ જમે તો તેને તેના લોકોથી તેને જૂદો કરવો.” ");
INSERT INTO guj2009_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ઇસ્રાએલી પ્રજાને કહે કે તમાંરે કોઈ બળદ, ઘેટાં કે બકરાની ચરબી ખાવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","કુદરતી રીતે મૃત્યુ પામેલ અથવા કોઈ જંગલી પ્રાણીએ માંરી નાખેલા પશુની ચરબીનો બીજો ગમે તે ઉપયોગ કરવો પણ તમાંરે તે ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","જો કોઈ વ્યક્તિ યહોવાને આહુતિ તરીકે ધરાવેલા પશુની ચરબી ખાય તો તેનો સમાંજમાંથી બહિષ્કાર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“તમે ગમે ત્યાં રહેતા હોય, પણ તમાંરે પશુનું કે પંખીનું લોહી ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","છતાં જો કોઈ લોહી ખાય તો તેનો સમાંજમાંથી બહિષ્કાર કરવો.” ");
INSERT INTO guj2009_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ઇસ્રાએલી લોકોને આ કહે કે જે કોઈએ યહોવાને શાંત્યર્પણ ચઢાવવા લાવે તેણે તેનો અમુક ભાગ યહોવાને વિશેષ ભેટ તરીકે ધરાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","તેણે પોતાને હાથે એ ભાગ લાવવો. તેણે ચરબી અને પ્રાણીની છાતી યાજક પાસે લાવવા. યાજકે છાતીને ઉચી કરવી અને આરતી અર્પણ કરીને યહોવાને અર્પણ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","યાજકે ચરબી વેદીમાં હોમી દેવી, પણ છાતીનો ભાગ હારુનના વંશના યાજકોનો થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","તમાંરા શાંત્યર્પણના પશુની જમણી જાંઘ પણ યાજકને આપવી. ");
INSERT INTO guj2009_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","એ જમણી જાંઘ જે યાજક શાંત્યર્પણને પશુનું લોહી અને તેની ચરબી ધરાવે તેના ભાગમાં જાય. ");
INSERT INTO guj2009_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ઇસ્રાએલીઓએ ધરાવેલા આરતીનાં પશુઓની છાતીનો ભાગ અને જાંઘ હું રાખી લઉ છું અને યાજક હારુનને અને તેના વંશજોને આપું છું. ઇસ્રાએલીઓ તરફથી એમને મળવું જોઈતું આ કાયમનું દાપું છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","જે દિવસે હારુન અને તેના પુત્રોનો યાજક પદે અભિષેક કરવામાં આવ્યો તે દિવસે તેમને યહોવાને ધરાવેલા અભિષેકના હિસ્સામાંથી એ દાપુ આપ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","જે દિવસે અભિષેક કરવામાં આવ્યો તે દિવસે યહોવાએ આ ભાગો તેમને આપવાની ઇસ્રાએલીઓને આજ્ઞા કરી હતી, આ નિયમ સદા માંટે તેમના બધા વંશજોને માંટે બંધનકર્તા છે. વંશપરંપરા આ તેઓનો અધિકાર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","દહનાર્પણ, ખાદ્યાર્પણ, પાપાથાર્પણ અને દોષાર્થાર્પણ અને શાંત્યાર્પણને લગતા નિયમો આ પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","સિનાઈના રણમાં યહોવાએ ઇસ્રાએલપુત્રોને અર્પણ ચઢાવવા માંટેની આજ્ઞા કરી હતી, ત્યારે તે દિવસે યહોવાએ સિનાઈ પર્વત પર મૂસાને આ પ્રમાંણે આજ્ઞા કરી હતી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“હવે હારુન અને તેના પુત્રોને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લઈ જા અને સાથે તેમના પોશાક, અભિષેકનું તેલ તેમજ પાપાર્થાર્પણનો બળદ, બે ઘેટાં અને બેખમીર રોટલીની ટોપલી લઈ જા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","અને બધી જ ઇસ્રાએલની પ્રજાને ત્યાં ભેગા થવાનું કહે.” ");
INSERT INTO guj2009_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","મૂસાએ યહોવાના કહેવા પ્રમાંણે કર્યું. તેથી સમગ્ર સમાંજ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ ભેગો થયો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","અને મૂસાએ તે લોકોને જણાવ્યું કે, “યહોવાએ આ પ્રમાંણે કરવાનું કહ્યું છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ત્યારબાદ તેણે હારુનને અને તેના પુત્રોને આગળ લાવીને પાણીથી સ્નાન કરાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","પછી તેણે હારુનને અંગરખો, અને જામો પહેરાવી કમરબંધ બાંધીને એફોદ ચઢાવી તેનો ગુથેલો પટો કમરે બાંધી દીધો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","પછી તેણે તેને ઉરપત્ર પહેરાવીને તેમાં ઉરીમ અને તુમ્મીમ જોડી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ત્યારબાદ યહોવાની આજ્ઞા મુજબ તેણે તેના માંથે પાધડી પહેરાવી અને આગળના ભાગમાં પવિત્ર મુગટરૂપે સોનાનું પદક એટલે કે પવિત્ર મુગટ લગાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","પછી મૂસાએ અભિષેકનું તેલ લઈને મુલાકાતમંડપ ઉપર અને તેમાંની બધી જ વસ્તુઓ પર છાંટીને તે બધાંયને પવિત્ર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","તે વેદી પાસે આવ્યો અને તેના પર સાત વખત અભિષેકનું તેલ છાંટયું અને વેદી અને તેનાં બધાં વાસણો તથા કૂડી અને તેની ધોડી યહોવાને સમર્પણ કરી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ત્યારબાદ તેણે હારુનના માંથા પર અભિષેકનું તેલ રેડયું અને દીક્ષાવિધિ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ત્યારબાદ યહોવાની આજ્ઞા પ્રમાંણે મૂસાએ હારુનના પુત્રોને ઝભ્ભો પહેરાવ્યો, કમરે કમરબંધ બાંધ્યા અને માંથે પાઘડી બાંધી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","પછી પાપાથાર્પણના બળદને આગળ લાવ્યો અને હારુને અને તેના પુત્રોએ તેના માંથા પર હાથ મૂક્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","પછી મૂસાએ તેનો વધ કર્યો, અને તેનું થોડું લોહી લઈ તેની આંગળીથી વેદીનાં ટોચકાઓને લગાડ્યું અને આ રીતે તેને શુદ્ધ કરી, પછી બાકીનું લોહી વેદીના પાયામાં રેડી દીધું. આ રીતે મૂસાએ વેદીને લોકોને શુદ્ધ કરવાના અર્પણો માંટે તૈયારી કરી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","પછી તેણે આંતરડાં પરની બધી જ ચરબી, કાળજા પરની ચરબી અને બંને મૂત્રપિંડ અને તે પરની ચરબી લીધી અને વેદીમાં હોમી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","અને બળદનું ચામડું, તેનું માંસ અને છાણ, યહોવાની આજ્ઞા અનુસાર છાવણી બહાર કોઈ જગ્યા પર તેણે બાળી નાખ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","પછી તે યહોવા સમક્ષ દહનાર્પણ માંટેનો ઘેટો લઈને આગળ આવ્યો. હારુને અને તેના પુત્રોએ તેના માંથા પર હાથ મૂક્યા, ");
INSERT INTO guj2009_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","પછી મૂસાએ તેનો વધ કર્યો અને તેનું લોહી વેદીની ચારેબાજુએ છાંટ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ત્યારબાદ તેણે ઘેટાના ટુકડા કરી યહોવાની આજ્ઞા મુજબ, તેનું માંથું, ચરબી તથા બધા ટુકડાવેદીમાં હોમી દીધા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","તેણે આંતરડાં તથા પગ પાણીથી ધોયા પછી આખા ઘેટાને વેદીમાં હોમી દીધો. યહોવાએ મૂસાને કરેલી આજ્ઞા મુજબનું એ દહનાર્પણ હતું. એ યજ્ઞની સુવાસથી યહોવા પ્રસન્ન થયા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","એ પછી મૂસા બીજા ઘેટાને એટલે કે યાજકના દીક્ષાવિધિ માંટેના ઘેટાને આગળ લાવ્યો; હારુન અને તેના પુત્રોએ તેના માંથા પર હાથ મૂકયા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","મૂસાએ તેનો વધ કર્યો અને તેનું થોડું લોહી લઈને હારુનના જમણા કાનની બુટ પર અને જમણા હાથના અંગૂઠા પર તથા જમણા પગના અંગૂઠા પર લગાડ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","પછી તે હારુનના પુત્રોને વેદી પાસે લાવ્યો અને તેમના જમણા કાનની બૂટે તથા તેમના જમણા હાથના અને જમણા પગના અંગૂઠાએ થોડું લોહી લગાડયું. પછી મૂસાએ વેદીને ફરતું લોહી છાંટયું. ");
INSERT INTO guj2009_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","પછી તેણે જાડી પૂંછડી, આંતરડાં પરની ચરબી, કાળજા પરની ચરબી બન્ને મૂત્રપિંડ અને તેની ચરબી તેમજ જમણી જાઘ લીધી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","પછી આ બધા પર એક રોટલો, એક તેલ ચોપડલો રોટલો, અને બેખમીર રોટલીનો એક ટુકડો જે દરરોજ દેવની સામે મુકવામાં આવે છે તે ચરબી પર એને જમણા જાંઘ પર મૂકયો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","અને આ બધું હારુન અને તેના પુત્રોના હાથમાં મૂકીને યહોવા સમક્ષ આરતી કરી. ");
INSERT INTO guj2009_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","પછી મૂસાએ તે બધું પાછું લઈને દહનાર્પણ ભેગું વેદીમાં હોમી દીધું. આ યાજકના દીક્ષાવિધિનો અર્પણ હતો અને તેની સુવાસથી યહોવા પ્રસન્ન થયા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","અર્પણના પછી મૂસાએ પશુની છાતી લીધી અને યહોવાની સામે આરતી કરી, આ રીતે યાજકના દીક્ષાવિધિના અર્પણમાંથી તેનો ભાગ મૂસાને મળ્યો હતો. આ બધું યહોવાએ મૂસાને જે આજ્ઞા કરી હતી તે મૂજબ કરવામાં આવ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ત્યારબાદ મૂસાએ થોડું અભિષેકનું તેલ અને થોડું વેદી પરનું લોહી લઈને હારુન અને તેનાં વસ્ત્રો પર તથા તેના પુત્રો અને તેમનાં વસ્ત્રો પર છાંટીને યહોવાના ઉપયોગ માંટે પવિત્ર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","પછી મૂસાએ હારુનને અને તેના પુત્રોને કહ્યું, “યહોવાની આજ્ઞા મુજબ આ માંસ મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લઈ જઈ ત્યાં રાંધીને યાજકના દીક્ષાવિધિના અર્પણની ટોપલીમાંની રોટલી સાથે ખાજો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","માંસ અને રોટલીમાંથી જે કાંઈ વધે તે બાળી મૂકજો. ");
INSERT INTO guj2009_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","સાત દિવસ સુધી તમાંરે મુલાકતમંડપનું પ્રવેશદ્વાર છોડવું નહિ. તમાંરી દીક્ષાની વિધિ સાત દિવસ ચાલશે ત્યાર પછી તે પૂર્ણ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","તને શુદ્ધ કરવા માંટે આજે જે કરવામાં આવ્યુ છે તેનો આદેશ યહોવાએ કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","તમાંરે સાત દિવસ અને સાત રાત સુધી મુલાકાત મંડપના પ્રવેશદ્વાર આગળ યહોવાની આજ્ઞાનું પાલન કરતા રહેવાનું છે. અને ચેતવણી આપતાં કહ્યું, “જો તમે તેના આદેશ નહિ માંનો તો તમે મૃત્યુ પામશો. આ યહોવાની આજ્ઞા છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","હારુન અને તેના પુત્રોએ યહોવાએ મૂસાને આપેલી આજ્ઞાઓ મુજબ બધું જ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","આઠમે દિવસે મૂસાએ હારુનને અને તેના પુત્રોને તથા ઇસ્રાએલના વડીલોને બોલાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","મૂસાએ હારુનને કહ્યું, “તું ખોડખાંપણ વગરનો એક બળદ પાપાર્થાર્પણ તરીકે અને એવો જ એક ઘેટો દહનાર્પણ માંટે લાવ અને તેમને યહોવા સમક્ષ અર્પણ કર. ");
INSERT INTO guj2009_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ત્યારબાદ તું ‘ઇસ્રાએલીઓને પાપાર્થાર્પણ તરીકે એક બકરો અને આહુતિ તરીકે ખોડખાંપણ વગરનો એક વરસનો વાછરડો અને એવું જ એક ઘેટાનું બચ્ચું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","તદુપરાંત શાંત્યર્પણ તરીકે એક બળદ અને એક ઘેટો યહોવા સમક્ષ વધેરવાનું કહે, વળી તેઓએ તેલથી મોયેલા લોટને ખાદ્યાર્પણ તરીકે ચઢાવવો; કારણ કે આજે યહોવા તમને દર્શન આપશે.’” ");
INSERT INTO guj2009_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","આથી તેઓ મૂસાએ કહ્યું હતું તે પ્રમાંણે બધું મુલાકાતમંડપના પ્રવેશદ્વાર આગળ લાવ્યા અને ઇસ્રાએલના લોકો ત્યાં યહોવાની સમક્ષ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","તેઓને મૂસાએ કહ્યું, “યહોવાએ તમને આ પ્રમાંણે કરવાનું કહ્યું છે. અને જો તમે એ પ્રમાંણે કરશો એટલે તમને યહોવાના ગૌરવનાં દર્શન થશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","પછી મૂસાએ હારુનને કહ્યુ, “તું અગ્નિની વેદી પાસે આવ અને તારા પાપાર્થાર્પણ, દહનાર્પણ અને દોષાર્થાર્પણ ચઢાવ અને તારે પોતાને માંટે અને બધા લોકોને માંટે પ્રાયશ્ચિત કર. ત્યાર પછી લોકોએ ધાર્મિક વિધિ કરી કરેલા અર્પણો ચઢાવ અને યહોવાના આદેશ પ્રમાંણે તેમને શુદ્ધ કર.” ");
INSERT INTO guj2009_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","હારુન વેદી પાસે જઈને પોતાના પાપાર્થાર્પણ માંટે વાછરડાનો વધ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","તેના પુત્રોએ તેને માંટે લોહી તેની આગળ ધર્યું. અને તેમાં આંગળી બોળીને થોડું લોહી વેદીનાં ટોચકાંઓને લગાડયું અને બાકીનું લોહી વેદીના પાયામાં રેડી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ત્યારબાદ પાપાર્થાર્પણની ચરબી, મૂત્રપિંડો અને કાળજા પરનો ચરબીનો ભાગ, હારુને યહોવાએ મૂસાને આપેલી આજ્ઞા મુજબ વેદી પર હોમી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","પરંતુ માંસ અને ચામડું તેણે છાવણી બહાર બાળી મૂક્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ત્યારબાદ હારુને દહનાર્પણના પ્રાણીનો વધ કર્યો. તેના પુત્રોએ તેને લોહી આપ્યું અને તેણે તે વેદીની ચારે બાજુએ છાંટયું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","પછી તેણે પ્રાણીના ટુકડાઓને માંથાં સહિત એક પછી એક તેની આગળ લઈ આવ્યા અને વેદીમાં હોમી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","પછી તેણે આંતરડાં અને પાછલા પગ ધોઈ નાખ્યાં અને દહનાર્પણ વેદીમાં હોમી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","પછી તે લોકો માંટે અર્પણ લાવ્યો, અને પોતાના પાપાર્થાર્પણની વિધિ પ્રમાંણે તેણે બકરાનો વધ કર્યો અને બલિદાન આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","પછી તેણે દહનાર્પણ યહોવાની આજ્ઞા પ્રમાંણે વિધિપૂર્વક અર્પણ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","પછી તેણે ખાદ્યાર્પણ ચઢાવ્યો, તેમાંથી એક મૂઠી લઈ સવારના દહનાર્પણ સાથે વેદીમાં હોમી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","તેણે લોકોના શાંત્યર્પણ તરીકે બળદ અને ઘેટાનો પણ વધ કર્યો, તેના પુત્રોએ તેને લોહી આપ્યું જેને તેણે વેદીની ચારે બાજુએ છાંટ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","અને બળદના ચરબીવાળા ભાગો, ઘેટાની ચરબીવાળી પૂંછડી, આંતરડા પરની ચરબી, બે મૂત્રપિંડો અને તેના પરની ચરબી તથા કાળજા પરની ચરબીવાળો ભાગ. ");
INSERT INTO guj2009_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","આ બધું તેણે પહેલાં પશુઓના છાતીના ભાગ ઉપર મૂક્યું, અને પછી વેદીમાં હોમી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","અને મૂસાની આજ્ઞા પ્રમાંણે હારુનને પશુઓની છાતીના ભાગો અને જમણી જાઘ તરીકે યહોવાને આરત્યર્પણ તરીકે ધરાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ત્યારબાદ હારુને હાથ ઊચા કરીને લોકોને આશીર્વાદ આપ્યા. આમ પાપાર્થાર્પણ, દહનાર્પણ અને શાંત્યર્પણ ચઢાવ્યા પછી તે વેદી પરથી નીચે ઊતર્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","મૂસા અને હારુન મુલાકાતમંડપમાં ગયા. પછી બહાર આવ્યા અને લોકોને આશીર્વાદ આપ્યા અને બધા લોકોને યહોવાના ગૌરવના દર્શન થયા. ");
INSERT INTO guj2009_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","યહોવા તરફથી એકાએક અગ્નિ પ્રગટયો અને તે આવીને વેદી પરના દહનાર્પણ અને ચરબીવાળા ભાગો ભસ્મ કરી ગયો. આ જોઈને બધા લોકોએ હર્ષના પોકારો કર્યા અને યહોવા સમક્ષ સાષ્ટાંગ નમસ્કાર કરી જમીન પર ઊધા સૂઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","હારુનના પુત્રો નાદાબ તથા અબીહૂએ ધૂપદાનીમાં અપવિત્ર આગ્નિ મૂકયો અને તે અગ્નિ પર ધૂપ નાખ્યો. અને તે ધૂપ યહોવાને ચઢાવ્યો. યહોવાએ તે ચઢાવવાની આજ્ઞા કરી નહોતી તેથી એ અગ્નિ અપવિત્ર હતો. ");
INSERT INTO guj2009_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","તેથી યહોવાની આગળથી અગ્નિ ધસી આવ્યો અને તે બંનેને ભસ્મ કરી ગયો. અને તેઓ યહોવા સમક્ષ મૃત્યુ પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","પછી મૂસાએ હારુનને કહ્યું, “યહોવાએ એમ કહ્યું હતું કે, ‘જે યાજકો માંરી સેવા કરે છે તેમણે માંરી પવિત્રતા જાળવવી જોઈએ; સર્વ લોકોની સંમુખ હું માંરો મહિમાં પ્રગટ કરી ગૌરવવાન મનાઈશ. તેનો અર્થ આ છે.’” હારુન મૌન થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ત્યાર પછી મૂસાએ હારુનના કાકા ઉઝઝીએલના પુત્રો મીશાએલને અને એલસાફાનને બોલાવડાવીને તેઓને કહ્યું, “આમ આવો, અને તમાંરા પિતરાઈ ભાઈઓને મંદિરના તંબુમાંથી છાવણી બહાર લઈ જાઓ.” ");
INSERT INTO guj2009_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","આથી તેઓ ત્યાં ગયા અને મૂસાની આજ્ઞા પ્રમાંણે પોતાના પિતરાઈ ભાઈઓને પહેરેલા અંગરખા સહિત છાવણી બહાર લઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ત્યાદબાદ મૂસાએ હારુન અને તેના પુત્રો એલઆઝાર અને ઈથામાંરને કહ્યું, “તમે શોક ન કરો, શોકમાં તમાંરા વાળ છૂટા ન રાખો અને તમાંરાં કપડાં ન ફાડો, જો તમે તેમ કરશો તો દેવ તમને પણ માંરી નાખશે અને યહોવા ઇસ્રાએલી સમાંજ પર રોષે ભરાશે; પરંતુ બીજા બધા ઇસ્રાએલીઓ ભલે યહોવાએ મોકલેલા અગ્નિનો ભોગ બનેલા એ લોકોને માંટે આફ્રદ કરે ને શોક પાળે. ");
INSERT INTO guj2009_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","પણ તમે મુલાકાતમંડપના પ્રવેશદ્વાર આગળથી ખસસો નહિ. નહિ તો મૃત્યુ દંડ તમાંરા પર આવશે. કારણ, યહોવાના તેલથી તમાંરો અભિષેક કરવામાં આવેલો છે.” તેમણે મૂસાનાં કહ્યાં પ્રમાંણે કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","યહોવાએ હારુનને આજ્ઞા કરી, ");
INSERT INTO guj2009_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“તું અને તારા પુત્રો મુલાકાતમંડપમાં પ્રવેશ કરો ત્યારે દ્રાક્ષારસ કે કેફી પીણું પીવું નહિ, જો પીશો તો મૃત્યુ પામશો, આ નિયમ તારા પુત્રોને અને વંશ પરંપરા સદાને માંટે લાગુ પડે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","તમાંરી જવાબદારી છે કે તમાંરે પવિત્ર અને અપવિત્ર વચ્ચે તથા શુદ્ધ અને અશુદ્ધ વચ્ચેનો ભેદ તેઓને સમજાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","અને યહોવાએ જે નિયમો મૂસાને આપ્યા હતા તે બધા નિયમો ઇસ્રાએલી લોકોને સમજાવવા.” ");
INSERT INTO guj2009_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","મૂસાએ હારુનને અને તેના બાકી રહેલા પુત્રો એલઆઝાર અને ઈથામાંરને કહ્યું, “યહોવાને ધરાવેલા ખાદ્યાર્પણમાંથી વધેલો લોટ તમાંરે લેવો અને તેની બેખમીર રોટલી બનાવીને વેદી પાસે જમવી, કારણ કે તે અત્યંત પવિત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","મને એવી આજ્ઞા કરવામાં આવી છે કે તમાંરે એ પવિત્ર સ્થાને જમવી, યહોવાને ચઢાવેલા અર્પણમાંથી એ ભાગ તારો અને તારા પુત્રોનો થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“યહોવા સમક્ષ ધરાવેલાં આરત્યાર્પણનાં પશુનો છાતીનો ભાગ અને જાંઘનો ભાગ તારે અને તારા પુત્રોએ તથા પુત્રીઓએ કોઈ પવિત્ર સ્થળે જમવો. કારણ કે ઇસ્રાએલીઓએ યહોવાને ધરાવેલ શાંત્યર્પણમાંથી એ ભાગનો અધિકાર તારો અને તારાં પુત્રપુત્રીઓનો થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ચરબી હોમવા લાવતી વખતે આરત્યર્પણનો છાતીનો ભાગ અને જાંઘનો ભાગ પણ યાજકો માંટે યહોવાને ચઢાવવા લોકોએ સાથે લાવવો, આ ચઢાવાની યહોવા સામે આરતી કરવી. યહોવાએ જણાવ્યા મુજબ એ તને અને તારા પુત્રોને તમાંરા કાયમી અધિકારના ભાગની જેમ મળવો જોઈએ.” ");
INSERT INTO guj2009_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","મૂસાએ પાપાર્થાર્પણના અર્પણના બકરાની તપાસ કરી, તો ખબર પડી કે તેને હોમી દેવામાં આવ્યો હતો, તે હારુનના જીવતા રહેલા પુત્રો એલઆઝાર અને ઈથામાંર પર ગુસ્સે થયો. ");
INSERT INTO guj2009_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","અને તેણે કહ્યું, “તમે એ પાપાર્થાર્પણ પવિત્રસ્થઆનમાં શા માંટે ન ખાધું? તે અત્યંત પવિત્ર છે, એ તમને લોકોના દોષ દૂર કરી, યહોવા સમક્ષ લોકોનું પ્રાયશ્ચિત કરવા આપેલ હતું. ");
INSERT INTO guj2009_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","તેનું લોહી પવિત્રસ્થાનમાં લાવવામાં આવ્યું ન હતું, તેથી પ્રાયશ્ચિતનો એ અર્પણ તમાંરે માંરી આજ્ઞા મુજબ પવિત્રસ્થાનમાં જ જમવો જોઈતો હતો.” ");
INSERT INTO guj2009_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","પરંતુ હારુને મૂસાને કહ્યું, “જુઓ, આજે એ લોકોએ પોતાના પાપાર્થાર્પણ અને દહનાર્પણ યહોવા સમક્ષ ધરાવ્યો છે, અને માંરી આ દશા થઈ છે. પરંતુ જો હું આજે પાપાર્થાર્પણ જમ્યો હોત, તો શું તેથી યહોવા પ્રસન્ન થયા હોત?” ");
INSERT INTO guj2009_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","જ્યારે મૂસાએ આ સાંભળ્યું ત્યારે તેને એ સાચું લાગ્યું અને સંતોષ થયો. ");
INSERT INTO guj2009_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","પછી યહોવાએ મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“તમે ઇસ્રાએલી પ્રજાને આ પ્રમાંણે જણાવો: તમે પૃથ્વી પરનાં પ્રાણીઓમાંથી આટલાં જમવા માંટે ઉપયોગમાં લઈ શકો: ");
INSERT INTO guj2009_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","જે પ્રાણીઓની ખરી ફાટવાળી હોય અને જે વાગોળતું હોય તેને તમે જમી શકો. ");
INSERT INTO guj2009_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“પરંતુ જે પ્રાણીઓની માંત્ર ખરી ફાટવાળી હોય અથવા જે માંત્ર વાગોળતાં હોય તે પ્રાણીઓ તમાંરે જમવા જોઈએ નહિ, જેમ કે ઊટ, એ વાગોળે છે પણ એની ખરીને ફાટ નથી, તમાંરે એને અશુદ્ધ ગણવું; ઘોર ખોદિયું અને સસલું, એ વાગોળે છે, પણ એના પગને ફાટ નથી; ");
INSERT INTO guj2009_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","તમાંરે એને અશુદ્ધ ગણવાં, ડુક્કરના પગે ફાટ હોય છે, પણ એ વાગોળતું નથી, તમાંરે એને અશુદ્ધ ગણવું. ");
INSERT INTO guj2009_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","તમાંરે તેનું માંસ ખાવું નહિ કે તેમના શબને અડવું નહિ. તમાંરે તેમને અશુદ્ધ ગણવાં.” ");
INSERT INTO guj2009_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“જળચર પ્રાણીઓમાંથી તમે આટલાં ખાઈ શકો: ખારા પાણીનાં કે મીઠાં પાણીનાં બધાં પરવાળા તેમજ ભિંગડાઁવાળાં પ્રાણીઓ, ");
INSERT INTO guj2009_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","પરંતુ ખારા કે મીઠાં પાણીનાં નાનાં મોટાં જે પ્રાણીઓને કાં તો પર ન હોય કે ભિંગટાં પણ ન હોય તે તમે ખાઈ શકો નહિ, તમાંરા માંટે તે અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","તમાંરે તેમનું માંસ ખાવું જોઈએ નહિ કે તેમના શબને અડવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","હું ફરીથી કહું છું કે જે કોઈ જળચર પ્રાણીને પર ન હોય કે ભિંગડાં ના હોય તે ખાવાની તમને મનાઈ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“આટલાં પક્ષીઓમાંથી નીચેના તમાંરે ન ખાવા અને અછુત ગણવા: ગરૂડ તથા ફરસ તથા ગીધ; ");
INSERT INTO guj2009_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","બાજ, સમડી; ");
INSERT INTO guj2009_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","કાગડા બધી જ દાતના, ");
INSERT INTO guj2009_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","શાહમૃગ, રાતશકરી, શકરો, શાખાફ બધી જ જાતના ");
INSERT INTO guj2009_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ચીબરી, કરઢોક, ધૂવડ; ");
INSERT INTO guj2009_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","રાજહંસ, ઢીંચ, ગીધ; ");
INSERT INTO guj2009_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","બગલો, બધી જ જાતનાં હંસ, લક્કડખોદ અને વાગોળ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“બધા પાંખવાળા ચોપગા કીડાઓને તમાંરે ખાવા નહિ, ");
INSERT INTO guj2009_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","પણ જેઓ ઠેકડા માંરી કૂદકા માંરે છે તેમનામાંથી આટલા તમે ખાઈ શકો: ");
INSERT INTO guj2009_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","બધી જ જાતનાં તીડ, બધી જ જાતનાં તમરાં, બધી જ જાતના તીતીધોડા, દરેક રણનાં તીડ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“તે સિવાયના જે સર્વ જંતુઓ ઊડે છે અને પગથી ચાલે છે કે પેટે ચાલે છે તે બધાને ખાવાની તમને મનાઈ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“તેઓના શબને પણ જો કોઈ સ્પર્શ કરે તો સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","જે કોઈ તેમના શબને ઉપાડી લે તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવા. વિધિ પ્રમાંણે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“જે પશુઓને ફાટવાળી ખરીઓ હોય પણ તેમના બરાબર બે સરખા ભાગ થતાં ન હોય અથવા જે પશુઓ વાગોળતાં ના હોય, અથવા જે જે ચોપગાં રાની પશુઓ પંજા ઉપર ચાલતાં હોય તે બધાં પશુઓને અશુદ્ધ ગણવા જે કોઈ તેમના શબને અડે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","અને જે કોઈ તેમના શબને ઉપાડે, તો તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, પણ તે સાંજ સુધી અશુદ્ધ ગણાય. કારણ કે તે માંટેની તમને મનાઈ કરેલી છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“પેટે ચાલનારા આટલાં પ્રાણીઓની પણ તમને મનાઈ કરવામાં આવેલ છે: બધી જ જાતની ગરોળીઓ, નોળિયો, ઉદર, ");
INSERT INTO guj2009_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ચંદન ધો, પાટલા ઘો, મગર સરડો તથા કાચીંડો. ");
INSERT INTO guj2009_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","પેટે ઘસીને ચાલનારાં પ્રાણીઓમાં આટલાંને તમાંરે અશુદ્ધ ગણવાં, જે કોઈ એમના શબને અડકે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“જે કોઈ વસ્તુ ઉપર એમનું શબ પડે તે અશુદ્ધ ગણાય. એવી કોઈ પણ લાકડાની અથવા કપડાંની અથવા ચામડાની અથવા કંતાનની નિત્યના વપરાશની વસ્તુને પાણીમાં ધોઈ નાખવી. પણ તે સાંજ સુધી અશુદ્ધ ગણાય. ત્યાર પછી તેનો ઉપયોગ થઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","જો આમાંનું કોઈ પણ પ્રાણી એક માંટીનાં વાસણ પર મરીને પડે તો તેમાંની વસ્તુ અશુદ્ધ થઈ જાય, તેથી એ વાસણને તોડી નાંખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","જે કોઈ ખાવાના પદાર્થ પર એવાં માંટલામાંથી પાણી રેડયું હોય તે અશુદ્ધ ગણાય. અશુદ્ધ થયેલાં વાસણોમાંનું કોઈ પણ પીણું હોય તો તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","જે કોઈ વસ્તુ પર આવા પ્રાણીનું શબ પડે તે અશુદ્ધ ગણાય, અને એ જો ભઠ્ઠી કે સગડી હોય તો તેને ભાંગી નાખવી. કારણ કે એ અશુદ્ધ છે, અને તમાંરે એને અશુદ્ધ ગણવી જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“જો આવું શબ પાણીના ટાંકામાં, કૂવામાં કે ઝરણાંમાં કે કોઈ જળાશયમાં પડે તો તે પાણી અશુદ્ધ ન ગણાય, જો કે જે કોઈ તેમનાં શબને અડે તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","જો એમાંના કોઈનું શબ વાવવાના દાણા પર પડે તો તે શુદ્ધ રહે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","પણ જો તે દાણા ભીના હોય અને તેના પર શબ પડે, તો તમાંરે તેને અશુદ્ધ ગણવા. ");
INSERT INTO guj2009_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“તમને ખાવાની છૂટ આપવામાં આવી છે એવું પ્રાણી મરી જાય; તો તેના શબને જે કોઈ અડે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","જે કોઈ એ શબમાંથી તેનું માંસ ખાય અથવા તેના શબને ઉઠાવીને દૂર લઈ જાય, તો તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, પણ તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“જમીન પર પેટ ઘસીને ચાલતાં તમાંમ નાનાં પ્રાણીઓ ખાવાની મનાઈ છે. માંટે તે ખાવાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","સર્વ પેટે ચાલનારાં ચોપગાં કે વધુ પગવાળાં જમીન પર પેટે ચાલનારાં નાનાં પ્રાણી પણ તમાંરે ખાવા નહિ કારણ કે તે અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","તમાંરે એ પ્રાણીઓને તમને આભડવા દેવા નહિ, તમાંરે અશુદ્ધ ન બનવું. ");
INSERT INTO guj2009_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","કારણ કે હું યહોવા તમાંરો દેવ છું. આ બાબતો વિષે તમે તમાંરી જાતને પવિત્ર રાખો, કારણ, હું પવિત્ર છું. જમીન પર પેટે ચાલતાં કોઈ પ્રાણીથી તમાંરે તમાંરી જાતને અભડાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","હું યહોવા છું, જે તમને મિસરમાંથી લાવ્યો હતો જેથી હું તમાંરો દેવ બની શકું. તમાંરે પવિત્ર થવું જ જોઈએ. કેમકે હું પવિત્ર છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","એટલે પશુઓ, પક્ષીઓ, જળચર પ્રાણીઓ અને જમીન પર પેટઘસીને ચાલનારા જીવોને લગતો નિયમ આ મુજબ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","એનો હેતું અશુદ્ધ અને શુદ્ધ ખાદ્ય અને અખાદ્ય જીવોને જુદુ પાડવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","પછી યહોવાએ મૂસાને જણાવ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“તું ઇસ્રાએલી પ્રજાને આ નિયમો જણાવ: “જયારે કોઈ સ્ત્રીગર્ભ ધારણ કરે અને પુત્રને જન્મ આપે ત્યારે ઋતુકાળની જેમ તે સાત દિવસ સુધી તે અશુદ્ધ ગણાય તેથી તેને સાત દિવસ સૂતકના મર્યાદાના બંધનો લાગુ પડે. ");
INSERT INTO guj2009_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","તેના પુત્રની સુન્નત આઠમાં દિવસે અચૂક કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ત્યારબાદ તે સ્ત્રીઓ બીજા તેત્રીસ દિવસ સુધી તેનું લોહી શુદ્ધ થાય ત્યાં સુધી તેણે કોઈ અન્ય પવિત્ર વસ્તુને સ્પર્શ કરવો નહિ તથા મુલાકાતમંડપમાં દાખલ થવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","વળી જો પુત્રી અવતરે તો તેના ઋતુકાળની જેમ તે ચૌદ દિવસ સુધી અશુદ્ધ ગણાય. તેથી ત્યાં સુધી ઋતુકાળની જેમ તેણે રહેવું. અને બીજા છાસઠ દિવસ સુધી તેણે તેનું લોહી શુદ્ધ થવાની રાહ જોવી. ");
INSERT INTO guj2009_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“તે પછી જયારે તેને શુદ્ધ કરવાનો સમય પૂરોથાય ત્યારે એક છોકરી અથવા છોકરાની નવી માંતાએ દહનાર્પણ માંટે એક વર્ષનું ઘેટાનું બચ્ચું અને પાપાર્થાર્પણ માંટે કબૂતરનું એક બચ્ચું કે હોલો મુલાકાતમંડપમાં લઈ જવું અને પ્રવેશદ્વારે યાજકને આપી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","યાજક તેને યહોવા સમક્ષ ધરાવે અને તેના માંટે પ્રાયશ્ચિત કરે. એટલે તે તેના બાળકના જન્મ પછીના રકતસ્રાવની અશુદ્ધિમાંથી શુદ્ધ ગણાય. પ્રસૂતાને લગતો આ નિયમ ઉપર પ્રમાંણે છે. બાળકના જન્મ પછીની આ સર્વ વિધિ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","પરંતુ જો સ્ત્રીની શક્તિ ઘેટાનું બચ્ચું લાવવાની ના હોય, તો તે બે હોલા કે બે કબૂતરનાં બચ્ચાં પણ લાવી શકે, એક દહનાર્પણ માંટે અને બીજું પાપાર્થાર્પણને માંટે. યાજકે પ્રાયશ્ચિત માંટેની વિધિ કરવી તે પોતાના લોહીની નુકસાનથી શુદ્ધ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","યહોવાએ મૂસા તથા હારુનને જણાવ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“જો કોઈ વ્યક્તિના શરીરની ચામડી પર સોજો આવે, અથવા ચાંદું કે ગૂમડું થાય, અને એ કોઢમાં પરિણમે એમ લાગતું હોય. તો તેને યાજક હારુનની પાસે અથવા તેના કોઈ યાજક દીકરા પાસે લઈ જવો.” ");
INSERT INTO guj2009_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","પછી યાજકે એ ચામડી પરનું ચાઠું તપાસવું. જો તે જગ્યા ઉપરના વાળ સફેદ થઈ ગયા હોય, અને તે ભાગ ચામડી કરતાં ઊંડે ઊતરેલો લાગે તો તે કોઢ છે. અને યાજકે તે માંણસને એક અશુદ્ધ કોઢિયો જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“પરંતુ જો ચામડી પરનો સફેદ ડાઘ ચામડીની નીચે ઊડે ઊતરેલો ના લાગતો હોય, વળી તેમાંના વાળ સફેદ થઈ ગયા ના હોય, તો યાજકે તે રોગીને સાત દિવસ સુધી જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","પછી સાતમે દિવસે યાજકે તેને ફરીથી તપાસવો અને જો એ સફેદ ડાઘ જેવો હતો તેવો જ રહ્યો હોય અને ચામડીના બીજા ભાગમાં પ્રસર્યો ના હોય, તો યાજકે તેને બીજા સાત દિવસ સુધી જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","યાજક ફરીથી સાતમાં દિવસે તપાસે અને તે સફેદ ડાઘ ઝાંખો થઈ ગયો હોય અને તે પ્રસર્યો ન હોય તો યાજકે તેને શુદ્ધ જાહેર કરવો. તે ફકત ચાંદું જ હતું એમ માંનવું. પછી તે વ્યક્તિ વસ્ત્રો ધોઈ નાખે એટલે શુદ્ધ થઈ જાય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“પરંતુ શુદ્ધ જાહેર કર્યા પછી ફરી તે ડાઘ ફેલાયેલો લાગે તો વ્યક્તિ એ ફરીથી તપાસ માંટે યાજક પાસે આવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","યાજકે તેને ફરીથી તપાસવો અને જો સફેદ ડાઘ કે ચાંદું ફેલાતું જતું લાગે, તો યાજકે તે માંણસને એક અશુદ્ધ કોઢિયો જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“જો કોઈ વ્યક્તિને કોઢનું ચાંદું હોય અને કોઢ હોવાની શંકા જાય, તો તેને યાજક આગળ લઈ જવો. અને યાજકે તેને તપાસવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","જો ચામડી પર સફેદ ચાંઠું પડયું હોય, અને વાળ ધોળા થઈ ગયા હોય અને સોજા પરની ચામડી કાચી લાગતી હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","તો એ કોઢની શરૂઆત થઈ ચૂકી છે. એ ર્જીણ કોઢ છે, તેથી યાજકે તે વ્યક્તિને અશુદ્ધ જાહેર કરવો. એને જુદો રાખવાની જરૂર નથી, કારણ કે તે અશુદ્ધ જાહેર થઈ જ ચુક્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“પણ જો યાજકને ખબર પડે કે કોઢ ફાટી નીકળ્યો છે અને તેના સમગ્ર શરીર પર પગથી માંથા સુધી ફેલાઈ ગયો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","એટલે યાજકે તેને તપાસવો, અને સમગ્ર શરીર રોગ પ્રસરી ગયેલો ખબર પડે તો તેને યાજકે શુદ્ધ જાહેર કરવો, આખું શરીર સફેદ થઈ ગયું છે, તે શુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","પણ જો માંણસ પર કાચી ચામડી હોય, તો કાચી ચામડી જ્યારથી દેખાઈ હોય, ત્યારથી અશુદ્ધ ગણવો, યાજકે કાચી ચામડી તપાસવી અને માંણસને અશુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","શરીર પરની કાચી ચામડી એ સાબિત કરે છે કે તે કોઢ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“પરંતુ જો કાચી ચામડી રૂઝાઈ જાય અને સફેદ થઈ જાય, તો તે વ્યક્તિએ યાજક પાસે જવું. ");
INSERT INTO guj2009_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","યાજકે ફરીથી તેને તપાસવો, અને જો તે ચાંદા સંપૂર્ણ સફેદ થઈ ગયાં હોય, તો તેને શુદ્ધ જાહેર કરવો એ શુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“જો શરીરની ચામડીમાં ગૂમડું થઈને રૂજાઈ ગયું હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","અને ગૂમડાની જગ્યાએ સફેદ ડાઘ કે રતાશ પડતો સફેદ સોજો ખબર પડે તો તે યાજકને બતાવી તપાસ કરાવવી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","જો યાજકને લાગે કે રોગ ચામડીની નીચે અંદર સુધી પ્રસરી ગયો છે અને તે ચાઠા પરના વાળ સફેદ થઈ ગયા છે, તો યાજક તેને અશુદ્ધ જાહેર કરે, કારણ કે ગુમડામાંથી કોઢ ફાટી નીકળ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","પણ જો તપાસતાં યાજકને એમ ખબર પડે કે એમાંના વાળ સફેદ થયેલા નથી તે ચામડી કરતાં ઊડે ઊતરેલું નથી, અને ઝાખું પડી ગયું છે, તો તેણે તે વ્ય્કતિને સાત દિવસ જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","જો રોગ ચામડીમાં ફેલાયો હોય તો યાજકે તેને અશુદ્ધ જાહેર કરવો, કારણકે તે કોઢ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","પરંતુ જો ચાઠું એવું ન એવું રહે, પ્રસરે નહિ, તો એ ગૂમડાનું ચાઠું છે, અને યાજકે તે વ્યક્તિને શુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“જો કોઈ વ્યક્તિની ચામડી દાઝી જાય અને દાઝેલી જગ્યાએ ચમકતું લાલાશ પડતું સફેદ ચાઠું થઈ જાય, ");
INSERT INTO guj2009_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","તો યાજકે તે ચાંઠાની તપાસ કરવી જોઈએ. જો ચાઠાનાં વાળ સફેદ થઈ ગયા હોય અને રોગ ચામડીની નીચેના ભાગ સુધી ફેલાઈ ગયો હોય, તો દાઝવાના ધામાંથી કોઢ ફેલાયો છે અને યાજકે તે વ્યક્તિને એક અશુદ્ધ કોઢી જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","પરંતુ યાજક જુએ કે ચાઠાંમાં સફેદ વાળ નથી, અને તે ચામડીની નીચે સૂધી પ્રસરેલ નથી અને ચાઠું ઝાખું પડતું જાય છે, તો યાજકે તે વ્યક્તિને સાત દિવસ માંટે જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","સાતમે દિવસે યાજક તેને તપાસે ત્યારે જો ચાઠું ચામડીમાં ફેલાયું હોય, તો યાજકે તેને અશુદ્ધ જાહેર કરવો એ કોઢ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","પરંતુ જો ચાઠું ચામડી પર ફેલાયું ના હોય અને ઝાંખું થઈ ગયું હોય, તો તે દાઝેલા ધાનું ચાઠું છે માંટે યાજકે તે શુદ્ધ જાહેર કરવું કેમકે તે દાઝેલાનું ચાઠું છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“જો કોઈ પુરુષ કે સ્ત્રીના માંથા પર કે દાઢી એ પર રોગ હોય ");
INSERT INTO guj2009_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","તો યાજકે તેની તપાસ કરવી, અને જો તે ચામડી કરતાં ઊડું ખબર પડે અને વાળ પીળા અને આછા થઈ ગયા હોય, તો યાજકે તે વ્યક્તિને અશુદ્ધ જાહેર કરવો, તે ઉંદરી પ્રકારનો માંથાનો કે હડપચીનો એક કોઢ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","પરંતુ યાજક ઉંદરી તપાસે ત્યારે તે ચામડી કરતાં ઊડી ખબર ન પડે અને ત્યાંના વાળ હજી પણ કાળા હોય, તો યાજકે તે વ્યક્તિને સાત દિવસ જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","યાજકે સાતમાં દિવસે ફરીથી તેની તપાસ કરવી જો ચાઠું ફેલાયું ન હોય અને વાળ પણ પીળા થયા ન હોય, તેમજ તે ચામડી કરતાં ઊડી ખબર ના પડે, ");
INSERT INTO guj2009_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","તો તે માંણસે ઉંદરીવાળા ભાગ સિવાય ચાઠાની આજુબાજુના વાળ કપાવી નાખવા અને યાજકે તેને બીજા સાત દિવસ માંટે જુદો રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","યાજકે સાતમાં દિવસે ફરીથી તેને તપાસવો, અને જો ઉંદરી ચામડીમાં ફેલાઈ ન હોય, અને ચામડી કરતાં ઊડી ખબર ન પડે, તો યાજકે તે વ્યક્તિને શુદ્ધ જાહેર કરવો. પછી તે વ્યક્તિએ વસ્ત્રો ધોઈ નાખવાં એટલે તે શુદ્ધ થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","છતાં તે વ્યક્તિને શુદ્ધ જાહેર કર્યા પછી જો ઉંદરી ચામડીમાં ફેલાય, ");
INSERT INTO guj2009_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","તો યાજકે તેને ફરીથી તપાસવો, અને જો ઉંદરી ચામડીમાં ફેલાઈ હોય, તો યાજકે તેના વાળ પીળા છે કે નહિ એ પણ જોવાની જરૂર નથી. તેને અશુદ્ધ કોઢી જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","પણ જો ઉંદરી હતી એવી ને એવી રહે અને તેમાં કાળા વાળ ઊગવા માંડે તો તે કોઢી નથી. પણ શુદ્ધ છે અને યાજકે તેને શુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“જો કોઈ પુરુષ કે સ્ત્રીને ચામડીમાં સફેદ રંગના ચાઠાં પડયાં હોય, તો યાજકે તે તપાસવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","જો તે સફેદ હોય અને ઝાખાં પડતા જતા હોય તો તે કોઢ નથી, એમ સમજવું કે ચામડી પર કરોળિયો થયો છે અને એ માંણસ શુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“જો કોઈ વ્યક્તિના માંથાના વાળ ખરી પડયા હોય અને માંથાના પાછળના ભાગમાં તેને ટાલ પડી હોય તો પણ તે શુદ્ધ છે, કોઢી નથી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","જો માંથાના આગળના ભાગમાંથી વાળ ખરી ગયા હોય, તો આગળના ભાગમાં માંથા પર ટાલ પડે છતાં તે શુદ્ધ છે તેને કોઢ નથી એમ કહેવાય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","પરંતુ માંથા પરની આગળ કે પાછળની ટાલમાં રતાશ પડતા સફેદ ડાઘ હોય, તો કોઢની શરૂઆત થઈ છે એમ મનાય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","યાજકે તેને તપાસવો અને પાછળની કે કપાળ પરની ટાલમાંનો ડાઘ રતાશ પડતો સફેદ હોય તો તેને કોઢ થયો છે, ને તે અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","યાજકે તેને માંથામાં થયેલા રોગને કારણે અચૂક અશુદ્ધ જાહેર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“જે વ્યક્તિને કોઢ થયો હોય તેણે પોતાનાં વસ્ત્રો ફાડવાં, પોતાના વાળ વિખરાયેલા રહેવા દેવા, ઉપરનો હોઠ સુધીનો ભાગ ઢાંકી દેવો. અને બૂમો પાડવી, હું અશુદ્ધ છું, હું કોઢી છું. ");
INSERT INTO guj2009_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","જયાં સુધી તે વ્યક્તિમાં રોગ રહે ત્યાં સુધી તે અશુદ્ધ ગણાય, અને એણે છાવણીની બહાર નિવાસમાં રહેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“જો ઊનના કે શણના કપડા ઉપર, ");
INSERT INTO guj2009_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","અથવા શણના કે ઊનના તાણા કે વાણામાં અથવા ચામડામાં કે ચામડાની બનાવેલી કોઈ વસ્તુમાં ફુગનો ડાધ હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","તે લીલાશ પડતો કે રતાશ પડતો હોય, તો તેને તપાસ માંટે યાજક પાસે લઈ જવો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","યાજકે સાત દિવસ સુધી ડાઘવાળી વસ્તુને તપાસીને જુદી રાખવી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","અને સાતમે દિવસે તેણે ફરીથી તે તપાસવી અને જો ડાઘ ફેલાયેલા હોય, તો એ ભયાનક ફૂગ છે. તે અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","તેણે એ ફૂગવાળી વસ્તુ બાળી નાખવી જોઈએ. કારણ એને ભયાનક ફૂગનો ચેપ લાગ્યો હોય છે, તેથી તેનો અગ્નિમાં બાળીને નાશ કરવો જોઈએ. પછી તે ચામડુ હોય કે કપડું પછી કાપડ વણેલુ અથવા ગુંથેલુ હોય અને ચામડુ તે કામે વપરાયેલુ હોય તેનાથી કોઈ ફરક નથી પડતો. ");
INSERT INTO guj2009_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“પરંતુ સાતમે દિવસે યાજક તેની તપાસ કરે ત્યારે ડાઘ ફેલાયેલો ન જણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","યાજકે તે વસ્તુને ધોઈ નાખવા માંટે આજ્ઞા કરવી જોઈએ. અને તેને બીજા સાત દિવસ જુદી રાખવી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","પછી તે સમય બાદ યાજકે ફરી જોવું, જો ડાઘનો રંગ ન બદલાય કે તે ના ફેલાય તો પણ તે ફૂગ છે, અને તેથી તે અશુદ્ધ છે. તે વસ્તુને ચેપ લાગેલો હોવાથી તેને બાળી નાખીને નાશ કરવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“પણ યાજકને લાગે કે ધોયા પછી ડાઘ ઝાખો થયો છે, તો તેણે તે વસ્તુનો ડાઘવાળો, તો તેણે તે વસ્તુનો ડાઘવાળો ભાગ તે વસ્ત્ર હોય કે પછી ચામડાની બનાવેલી વસ્તુ હોય કે બીજી કોઈ વસ્તુ હોય, તેને તાણાવાણામાંથી ફાડી નાખવી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","છતાં જો વસ્ત્રમાં તાણાવાણામાં કે ચામડાની વસ્તુમાં ફરીથી ડાઘ દેખાય તો ચેપ નવેસરથી ફેલાય છે એમ માંનવું અને જેને ચેપ લાગ્યો હોય તે વસ્તુને અગ્નિમાં બાળી મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","જો વસ્ત્ર, કે તાણાવાણો કે ચામડાની કોઈ પણ વસ્તુ ધોવાથી ડાઘ જતો રહે તો તેને બીજી વખત ધોઈ નાખવી, એટલે તે શુદ્ધ થઈ જશે અને ફરી એક વાર તેને ઉપયોગમાં લઈ શકાશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ઊનના કે શણનાં વસ્ત્રો પર તાણાવાણામાંના વાણામાંના કે ચામડાની કોઈ પણ વસ્તુ ઉપર ફૂંગનો ડાઘ પડયો હોય તો તેને માંટે આ નિયમ છે, એને અનુસરીને વસ્તુને શુદ્ધ કે અશુદ્ધ જાહેર કરવી, વળી ક્યારે જાહેર કરવી અને કયારે નહિ, તે આ નિયમને આધારે નક્કી કરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“જે કોઈ કોઢમાંથી મુક્ત થયા છે તેઓની શુદ્ધિની વિધિ આ પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","યાજકે છાવણીની બહાર જઈને તેની તપાસ કરવી. યાજકને ખબર પડે કે કોઢનો રોગ મટી ગયો છે, ");
INSERT INTO guj2009_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","તો યાજકે જેની શુદ્ધિ કરવાની છે તે વ્યક્તિને અશુદ્ધ નહિ એવાં બે જીવતાં પક્ષીઓ, દેવદારનું થોડું લાકડું, કિરમજી રંગનું કાપડ અને ઝુફો લાવવાને આદેશ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","પછી યાજકે એક પક્ષીને વહેતાં પાણીની ઉપર રાખેલા માંટીના વાસણમાં વધેરવાની આજ્ઞા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ત્યાર પછી તેણે બીજું પંખી. દેવદારનું લાકડું, કિરમજી કાપડ અને ઝુફો લઈને ઝરાના પાણી ઉપર વધેરેલા પંખીના લોહીમાં બોળવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","જે વ્યક્તિની કોઢમાંથી શુદ્ધિ કરવાની હોય તેના પર તેણે 7 વાર લોહી છાંટી તેને શુદ્ધ કરવો, અને પેલા જીવતા પંખીને તેણે ખુલ્લા ખેતરમાં છોડી મૂકવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“જે માંણસ સાજો થયો છે તેને પોતાના વસ્ત્રો ધોઈ નાખવા. પોતાના માંથે મૂંડન કરાવવું અને પાણીમાં સ્નાન કરવું, એટલે તે શુદ્ધ થયો ગણાય, અને છાવણીમાં રહેવા માંટે પાછો ફરે. પરંતુ સાત દિવસ પર્યંત તેણે પોતાના તંબુની બહાર રહેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","સાતમે દિવસે તેણે માંથાના, દાઢીના અને પોતાનાં ભમર તેમજ શરીર પરના બીજા બધા વાળ મૂંડાવી નાખવા. વસ્ત્રો ધોઈ નાખવાં અને પાણીમાં સ્નાન કરવું, પછી તે કોઢથી સંપૂર્ણ રીતે સાજે થયો એમ જાહેર થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“આઠમે દિવસે તેણે એક વરસની ઉમરના બે ખોડખાંપણ વગરનાં નરઘેટાં, એક વરસની ખોડખાંપણ વગરની ઘેટી, 24 વાટકા મોયેલા લોટનો ખાદ્યાર્પણ અને પા કિલો તેલ લઈને મુલાકાતમંડપ પર જવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","શુદ્ધિની વિધિ કરાવનાર યાજકે જેની શુદ્ધિ કરવાની છે તે વ્યક્તિને તેના અર્પણો સાથે મુલાકાતમંડપના પ્રવેશદ્વારે યહોવા સમક્ષ રજૂ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ત્યાર પછી તેણે એક ઘેટો લઈને પા કિલો તેલ સાથે દોષાર્થાર્પણને આરત્યર્પણ તરીકે યહોવાને ધરાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ત્યાર પછી તેણે એ ઘેટાના બચ્ચાંને જે પવિત્ર સ્થળે પાપાર્થાર્પણને અને દહનાર્પણના હલવાનને વધેરવામાં આવે છે ત્યાં વધેરવો. પાપાર્થાર્પણની જેમ જ દોષાર્થાર્પણ યાજકને ખોરાક માંટે આપી દેવું. તે પરમપવિત્ર અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“પછી યાજકે આ દોષાર્થાર્પણનું લોહી લઈને જે વ્યક્તિ શુદ્ધ થયો છે તેના જમણા કાનની બૂટ પર, જમણા હાથના અંગૂઠા પર તથા જમણા પગના અંગૂઠા પર લગાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","પછી યાજકે સાથે લાવેલા તેલમાંથી થોડું પોતાના ડાબા હાથના પંજા પર રેડવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","પછી તેણે જમણા હાથની આંગળી તેમાં બોળવી અને યહોવાની સમક્ષ સાત વખત એ તેલનો છંટકાવ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ત્યારબાદ હથેલીમાં રહેલા તેલમાંથી થોડું લઈને જેની શુદ્ધિ કરવાની હોય તે વ્યક્તિના જમણા કાનની બૂટે અને જમણા હાથ અને જમણા પગના અંગૂઠા પર જયાં પહેલાં દોષાર્થાર્પણનું લોહી લગાડયું હતું ત્યાં લગાડવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","પછી યાજકના હાથમાંનું બાકીનું તેલ તેણે જે વ્યક્તિની શુદ્ધિ કરવી હોય તેના માંથા પર લગાડીને યહોવા સમક્ષ તેનીપ્રાયશ્ચિતવિધિ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ત્યાર પછી યાજકે પાપાર્થાર્પણ ધરાવવો અને જેની શુદ્ધિ કરવાની હોય, તે માંણસની પ્રાયશ્ચિતવિધિ કરવી અને ત્યાર પછી તે દહનાર્પણના પ્રાણીને માંરી નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","પછી યાજકે વેદીની અગ્નિ પર દહનાર્પણ તથા ખાદ્યાર્પણ બાળવા અને તે વ્યક્તિ માંટે પ્રાયશ્ચિત કરવું, અને ત્યારે તે વ્યક્તિ શુદ્ધ થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“જો તે માંણસ ગરીબ હોય અને આ બધું ધરાવી શકે એમ ના હોય, તો તેણે માંત્ર એક જ ઘેટો દોષાર્થાર્પણ તરીકે લાવવો. યાજકે તેને તે વ્યક્તિના પ્રાયશ્ચિત માંટે આરતીમાં ધરાવવો અને તે તેને શુદ્ધ કરશે. તેણે ખાદ્યાર્પણ તરીકે ફકત તેલથી મોંયેલો 8 વાટકા લોટ અને પા કિલો તેલ લાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","તથા બે હોલાં કે બે કબૂતરનાં બચ્ચાં, જે તે લાવી શકે તેમ હોય તે લાવવાં, એક પાપાર્થાર્પણ માંટે અને બીજું દહનાર્પણ માંટે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“આઠમે દિવસે યાજક પાસે મુલાકાત મંડપના પ્રવેશદ્વાર આગળ તે યહોવાની સમક્ષ પોતાના શુદ્ધિકરણની વિધિને માંટે આ પક્ષીઓને સાથે લાવે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","યાજક ઘેટાનાં બચ્ચાંને દોષાર્થાર્પણ તરીકે લે અને તેલ પણ લે અને વેદી આગળ યહોવાની સમક્ષ આરત્યર્પણ કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ત્યારબાદ દોષાર્થાર્પણ માંટેના ઘેટાનો વધ કરે અને તેનું થોડું લોહી લઈ તે વ્યક્તિના જમણા કાનની બૂટે અને તેના જમણા હાથના અને જમણા પગના અંગૂઠે લગાવે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ત્યાર પછી યાજકે થોડું તેલ પોતાની ડાબી હથેલીમાં રેડવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","અને પોતાના જમણા હાથની આંગળી વડે તેમાંનુ થોડું સાત વખત યહોવાની સમક્ષ છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","તે પછી દોષાર્થાર્પણનું લોહી લગાડયું હતું તે જ જગ્યાએ યાજકે પેલા માંણસના જમણા કાનની બૂટ પર અને જમણા હાથના અંગૂઠા પર અને જમણા પગના અંગૂઠા પર તેલ લગાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","અને હાથમાં બાકી રહેલું તેલ જે માંણસની શુદ્ધિ કરવાની હોય તેના માંથા પર રેડવું અને યહોવા સમક્ષ તેણે શુદ્ધિકરણ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","31","“પછી તે માંણસે એક હોલો કે કબૂતરનું બચ્ચું, જે તેને પરવડતું હોય, યાજકને પાપાર્થાર્પણ તરીકે અને બીજું દહનાર્પણ તરીકે ખાદ્યાર્પણની સાથે વેદી પર ચઢાવવું. અને યાજક યહોવાની સમક્ષ તે માંણસને માંટે પ્રાયશ્ચિત કરે અને તે શુદ્ધ બની જશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","કોઢમાંથી સાજા થયેલા જે માંણસનું શુદ્ધિ માંટે જરૂરી અર્પણો લાવવા અશક્ત હોય તેને માંટે આ નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","પછી યહોવાએ મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“મેં તમને આપેલા કનાન દેશમાં જયારે તમે આવી પહોંચો અને હું ત્યાં કોઈ ઘરમાં કોઢનો રોગ મૂકું; ");
INSERT INTO guj2009_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","તો ઘરનો માંલિક યાજક પાસે આવીને માંહિતી આપે, ‘માંરા ઘરમાં કોઢ હોય એવું મને લાગે છે!’ ");
INSERT INTO guj2009_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“યાજકે તપાસ કરવા જતાં પહેલાં ઘર ખાલી કરવા જણાવવું. નહિ તો ઘરમાંનું બધું જ અશુદ્ધ ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ત્યાર પછી યાજકે તપાસ કરવા ઘરની અંદર જવું. તપાસ કરતાં જો તેને ખબર પડે કે ભીંત પરના લીલાશ કે રતાશ પડતાં કાણા ભીંતમાં ઊડા ઊતરતાં જાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","તો તેણે ઘરમાંથી બહાર નીકળી સાત દિવસ માંટે ઘરને બંધ કરી દેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“સાતમે દિવસે યાજકે પાછા આવીને ફરી તપાસ કરવી, જો તે કાણાઓ ભીંતમાં વધારે પ્રસર્યા હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","તો યાજકે ભીંતનામ ફૂગવાળા ભાગને કાઢી નાખીને તેને શહરેની બહાર કોઈ અશુદ્ધ જગ્યાએ ફેંકી દેવા માંલિકને આદેશ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ત્યારબાદ ઘરની અંદરની ભીંતોને ખોતરી નાખવાની આજ્ઞા તેણે આપવી અને ખોતરી કાઢેલું બધું જ શહેરની બહાર કોઈ અશુદ્ધ જગ્યાએ ઠાલવી આવવા જણાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","જે જગ્યા ખાલી પડી હોય ત્યાં બીજા પથ્થરો લાવીને ગોઠવવા અને ચૂનાનો કોલ પણ નવો જ વાપરવો તથા ઘરને નવેસરથી પ્લાસ્ટર કરાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“જો પથ્થરો કાઢી નાંખ્યા પછી અને ઘરને નવેસરથી પ્લાસ્ટર કર્યા પછી જો ફરીથી ફૂગ દેખાય, ");
INSERT INTO guj2009_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","તો યાજકે ફરીથી આવીને ઘરની તપાસ કરવી. અને તેને ખબર પડે કે ફૂગ પ્રસર્યુ છે તો તે જલદી પ્રસરે તેવો ચેપ છે અને તે ઘર અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","પછી તે ઘરને તોડી પાડવાની આજ્ઞા આપવી. અને એ ઘરના પથ્થરો, લાકડાં અને ગારો બધું શહરેની બહાર કોઈ અશુદ્ધ જગ્યાએ લઈ જવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","એ ઘર બંધ રહ્યું હોય તે દરમ્યાન કોઈ ઘરમાં પ્રવેશે તો તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","જો કોઈ વ્યક્તિ તેમાં સૂઈ જાય અથવા જમે તો તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","પરંતુ યાજક ઘરમાં જઈને તપાસે ત્યારે તેને ખબર પડે કે નવેસરથી પ્લાસ્ટર કર્યા પછી ફૂગ ફેલાયેલો નથી, તો તે ઘરને તે શુદ્ધ જાહેર કરે કે ફૂગનો ચેપ હવે ઘરમાં નથી. ");
INSERT INTO guj2009_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“મકાનની શુદ્ધિ માંટે તેણે બે નાનાં પંખીઓ, દેવદારનું લાકડું, લાલ રંગના કાપડનો ટુકડો અને ઝુફો લેવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","એક પંખીને તેણે ઝરાના વહેતાં પાણી ઉપર માંટીના ઉપર વધેરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ત્યાર પછી દેવદારનું લાકડું, ઝુફો અને કિરમજી રંગનું કાપડ લઈ જીવતા પંખી સાથે વધેરેલા પંખીના લોહીમાં અને ઝરાના વહેતાં પાણીમાં બોળવાં અને સાત વખત ઘર ઉપર છંટકાવ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","આ પ્રમાંણે તેણે પંખીનું લોહી, ઝરાનું પાણી, જીવતું પંખી, દેવદારનું લાકડું, ઝુફો અને કિરમજી કાપડ, એનાથી ઘરની શુદ્ધિ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ત્યારબાદ યાજકે શહેરની બહાર ખુલ્લા મેદાનમાં બીજા પક્ષીને છૂટ્ટુ કરી ઉડી જવા દેવું. આ રીતે યાજક ઘરને શુદ્ધ કરશે અને ઘર સાફ થશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","બધી જ જાતના કોઢ માંટે સોજા-ચાંદાં-ગૂમડાં માંટે, કપડાંને તેમજ ઘરમાં લાગેલા કોઢના રોગ માંટે આ નિયમો છે: ");
INSERT INTO guj2009_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","વસ્ત્રોમાં કે ઘરમાં, ");
INSERT INTO guj2009_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","કોઈની ચામડીના સોજામાં કે દાઝવાથી થયેલા ઘામાં કે ચાંદામાં; ");
INSERT INTO guj2009_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","આ રીતે તમે જાણી શકશો કે સાચે જ તે કોઢ છે કે નહિ, તે માંટે જ આ નિયમો આપવામાં આવેલ છે, કોઢની બાબતમાં કોઈ અશુદ્ધ કયારે કહેવાય, ને શુદ્ધ કયારે કહેવાય, તેની સમજ માંટે આ નિયમો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","યહોવાએ મૂસા તથા હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ઇસ્રાએલના લોકોને આ કહો; જયારે કોઈ માંણસને તેના શરીરમાંથી સ્રાવ થતો હોય ત્યારે તે માંણસ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","સ્રાવ ચાલુ હોય ત્યારે અને તેમાંથી સાજા થાય પછી પણ થોડા સમય માંટે તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“સ્રાવવાળો માંણસ જે પથારીમાં સૂએ કે બેસે તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","તેથી જે કોઈ વ્યક્તિ તે માંણસની પથારીને સ્પર્શ કરે તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","વળી અશુદ્ધ વ્યક્તિ જે જગ્યા પર બેઠી હતી તે જગ્યા પર કોઈ બેસે, તો તે પણ સાંજ સુધી અશુદ્ધ ગણાય. તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં અને સ્નાન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","સ્રાવવાળા પુરુષને જે કોઈ સ્પર્શ કરે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","જો સ્રાવવાળો માંણસ કોઈના પર થૂંકે તો તે માંણસે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ રહેશે, ");
INSERT INTO guj2009_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","સ્રાવવાળો માંણસ જે જીન પર બેસીને સવારી કરે તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","સ્રાવવાળો માંણસ જયાં બેઠો હોય તે વસ્તુને જો કોઈ સ્પર્શ કરે તો સાંજ સુધી તે અશુદ્ધ ગણાય, અને જે કોઈ તે વસ્તુને ઉપાડે તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","સ્રાવવાળો માંણસ પોતાના હાથ ધોયા વિના જો કોઈ વ્યક્તિને અડે તો તેણે પોતાના વસ્ત્રો ધોઈ નાખવા, પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“અશુદ્ધ વ્યક્તિ માંટીના વાસણને સ્પર્શ કરે તો તે વાસણને ફોડી નાખવું, અને લાકડાનું વાસણ હોય તો પાણીથી વીછળી નાખવું જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“જ્યારે તે વ્યક્તિનો સ્રાવ થોભી જાય ત્યારે તેણે શુદ્ધિકરણની વિધિ માંટે સાત દિવસની હાર જોવી. અને પોતાનાં વસ્ત્રો ધોઈ નાખવાં, અને ઝરણાનાં પાણીમાં સ્નાન કરવું, ત્યાર પછી તે શુદ્ધ ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","તે વ્યક્તિએ આઠમે દિવસે તેણે બે હોલા અથવા કબૂતરનાં બે બચ્ચાં લાવીને મુલાકાતમંડપના પ્રવેશદ્વાર યહોવા સમક્ષ આવીને યાજકને આપવા. ");
INSERT INTO guj2009_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","યાજકોમાંના એકને પાપાર્થાર્પણ તરીકે અને બીજાને દહનાર્પણ તરીકે યહોવાને ધરાવીને સ્રાવવાળા માંણસની શુદ્ધિ માંટે યહોવા સમક્ષ પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“જો કોઈ પુરુષને વીર્યસ્રાવ થાય, તે તેણે આખા શરીર પર પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","જે કોઈ વસ્ત્રો કે ચામડા પર વીર્ય પડયું હોય તે ધોઈ નાખવું. સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","જે કોઈ સ્ત્રી પુરુષે જાતીય સંબંધ કર્યો હોય અને પુરુષને વીર્ય સ્રાવ થયો હોય, તો તેમણે બંનેએ પાણીથી સ્નાન કરવું અને સાંજ સુધી તેઓ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“સ્ત્રી માંસિક ઋતુમાં હોય તો તે સાત દિવસ સુધી અશુદ્ધ ગણાય અને તે દિવસો દરમ્યાન જે કોઈ તેને સ્પર્શ કરે તે સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","તે અશુદ્ધ હોય ત્યારે એ જેના પર સૂતી હોય કે બેઠી હોય તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","જે કોઈ વ્યકિત તેની પથારીને સ્પર્શ કરે તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","એ સ્ત્રી જેના પર બેઠી હોય એવી કોઈ પણ વસ્તુને જો કોઈ સ્પર્શ કરે તો તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, પાણીથી સ્નાન કરવું, સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","તે સ્ત્રી જેના પર બેઠી હોય તે પથારી અથવા આસન પરની કોઈ વસ્તુને જો કોઈ સ્પર્શે તો પોતાનાં વસ્ત્રો ધોઈ નાખે અને સ્નાન કરે. સાંજ સુધી તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“આ સમય દરમ્યાન જો કોઈ પુરુષ તેની સાથે જાતીય સંબંધ કરે, તો તેના ઋતુકાળની અશુદ્ધિ તેને પણ લાગે અને તે સાત દિવસ સુધી અશુદ્ધ ગણાય, તે જે પથારીમાં સૂએ તે પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“જો કોઈ સ્ત્રીને ઋતુકાળ સિવાય ઘણા દિવસો સુધી રક્તસ્રાવ થાય અથવા તેના ઋતુકાળ ઉપરાંત લાંબા સમય સુધી તેનો અટકાવ ચાલુ રહે, તો જયાં સુધી અટકાવ આવે ત્યાં સુધી તે ઋતુકાળની જેમ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","એ સમય દરમ્યાન પણ તે જે પથારીમાં સૂએ તે તેના ઋતુકાળના સામાંન્ય દિવસોની જેમ અશુદ્ધ ગણાય. અને તે જયાં બેસે તે જગ્યા પણ અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","જે કોઈ તે પથારી કે આસનને અડે તે અશુદ્ધ ગણાય. તેણે પોતાનાં કપડાં ધોઈ નાખવાં, પાણીથી સ્નાન કરવું અને સાજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","સ્રાવ બંધ થયા પછી સાત દિવસ પછી તે શુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","આઠમે દિવસે તેણે બે હોલાં અથવા કબૂતરનાં બચ્ચાં લાવીને મુલાકાતમંડપના પ્રવેશદ્વાર પાસે યાજકને આપવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","યાજકે તેમાંના એકને પાપાર્થાર્પણ માંટે અને બીજાને દહનાર્પણ તરીકે યહોવાને ધરાવવા અને તેણીના લોહીના સ્રાવની શુદ્ધિ માંટે પ્રાયશ્ચિત કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“આ રીતે ઇસ્રાએલના લોકોને અશુદ્ધિની બાબતમાં ચેતવવા. તમે તેઓને ચેતવશો નહિ, તો તેઓ માંરો પવિત્રમંડપ અશુદ્ધ કરશે, અને તેઓને મરવું પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","જે કોઈ પુરુષને સ્રાવ હોય તો તે અશુદ્ધ છે. સ્રાવ અથવા વીર્યપાત તે પુરુષને અશુદ્ધ કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ઋતુસ્રાવમાં સ્ત્રી અશુદ્ધ હોય છે તેથી ઋતુમતી સ્ત્રી સાથે જાતીય સંબંધ કરનાર પુરુષ પણ અશુદ્ધ છે. શરીરના સ્રાવથી પીડાતા લોકો માંટેના નિયમો ઉપર પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","યહોવા સમક્ષ ધૂપ અર્પણ કરતી વખતે હારુનના બે પુત્રો અવસાન પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","પછી યહોવાએ મૂસાને કહ્યું, “તારા ભાઈ હારુનને ચેતવણી આપ કે, તેણે પરમ પવિત્રસ્થાનમાં એટલે કે તંબુના પડદાની અંદરની બાજુએ પવિત્ર કોશ પરના ઢાંકણ સમક્ષ ઠરાવેલા સમયે જ પ્રવેશ કરવો, નહિ તો તેનું મૃત્યુ થશે. કારણ કે તે ઢાંકણના પરના ભાગમાં વાદળરૂપે હું દર્શન દઉ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ત્યાં તેને પ્રવેશ કરવા માંટેની શરતો: તેણે પાપાર્થાર્પણ માંટે એક વાછરડો તથા દહનાર્પણ તરીકે એક ઘેટો લાવવો અને પછી જ પરમ પવિત્રસ્થાનમાં પ્રવેશ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","તેણે શણનો પવિત્ર અંગરખો અને પાયજામો પહેરવો તથા કમરે શણનો કમરપટો બાંધવો અને માંથે શણનો ફેંટો બાંધવો. આ બધાં પવિત્ર વસ્ત્રો છે. તેથી એ પહેરતાં પહેલાં તેણે પાણીથી સ્નાન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“ઇસ્રાએલી પ્રજાએ તેઓના પાપાર્થાર્પણ માંટે બે બકરા તથા દહનાર્પણ તરીકે એક ઘેટો આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","તેણે પોતાના પાપાર્થાર્પણ માંટે યહોવાની સમક્ષ વાછરડાને વધેરવું અને પોતાના અને પોતાના પરિવારના પાપની પ્રાયશ્ચિતવિધિ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“ત્યાર પછી તેણે પેલા બે બકરાઓ લઈને મુલાકાત મંડપના પ્રવેશદ્વાર આગળ યહોવા સમક્ષ રજૂ કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","પછી તેણે ચિઠ્ઠી ઉપાડીને એ બકરામાંથી એક યહોવાને માંટે અને એક અઝાઝેલ માંટે નક્કી કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“યહોવા માંટે નક્કી થયેલ બકરો તેણે પાપાર્થાર્પણ તરીકે ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","પરંતુ તેણે અઝાઝેલ માંટે પોતે પસંદ કરેલા બીજા બકરાને લાવવો અને તેને જીવતો યહોવાની સમક્ષ મૂકવો, પછી તેની પ્રાયશ્ચિતવિધિ કરીને તેને બીજા લોકોના પાપોને ધરનાર તરીકે અઝાઝેલ પાસે અરણ્યમાં મોકલવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“હારુનને પોતાના અને પોતાના પરિવારના પાપાર્થાર્પણને માંટે વાછરડો ધરાવીને પ્રાયશ્ચિત વિધિ કરવો અને તેને વધેરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","પછી તેણે એક ધૂપદાનીમાં યહોવા આગળની વેદીમાંથી સળગતા અંગારા લેવા, અને બે મૂઠી ઝીણો દળેલો ધૂપ લેવો, અને તેને પડદાની પાછળ ઓરડીમાં લઈ જવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","પછી યહોવા સમક્ષ અંગારા ઉપર ધૂપ નાખવો જેથી કરાર ઉપરનું ઢાંકણ ધુમાંડાથી ઢંકાઈ જશે અને પોતે તેને જોવા નહિ પામે, અને મરી નહિ જાય. ");
INSERT INTO guj2009_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ત્યાર પછી તેણે વાછરડાના લોહીમાંથી થોડું લોહી ઢાંકણની પૂર્વ બાજુએ આંગળી વતી છાંટવું અને ઢાંકણની સામે તેણે આંગળી વતી સાત વાર લોહીના છાંટા નાખવા. ");
INSERT INTO guj2009_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ત્યાર પછી તેણે લોકોના પાપાર્થાર્પણના બકરાનું બલિદાન કરવું અને તેનું લોહી પડદાની અંદરની બાજુ લાવવું અને વાછરડાના લોહીની જેમ મંજૂષાના ઢાંકણ ઉપર અને તેની સામે છાંટવું. ");
INSERT INTO guj2009_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","આ રીતે તેણે ઇસ્રાએલીઓની શુદ્ધિથી તેમના અપરાધો અને તેમનાં પાપોથી પરમ પવિત્રસ્થાન ને મુકત કરવા; પ્રાયશ્ચિતવિધિ કરવી, એજ રીતે તેણે ઇસ્રાએલીઓની વસ્તીની વચમાં આવેલો હોવાને કારણે મુલાકાતમંડપને લાગેલી અશુદ્ધિઓની શુદ્ધિ માંટે પ્રાયશ્ચિતવિધિ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“હારુન પ્રાયશ્ચિત કરવા માંટે પરમ પવિત્ર સ્થાનમાં દાખલ થાય ત્યારથી તે પાછો આવે ત્યાં સુધી કોઈને મુલાકાતમંડપમાં રહેવા ન દેવો. પોતાના માંટે, પોતાના પરિવારને માંટે તેમજ સમગ્ર ઇસ્રાએલી સમાંજ માંટે પ્રાયશ્ચિત વિધિ પતાવ્યા બાદ ");
INSERT INTO guj2009_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","બહાર આવીને તેણે યહોવાની સમક્ષ વેદી પાસે જઈને તેનો પણ પ્રાયશ્ચિત વિધિ કરવો. તેણે વાછરડાના અને બકરાના લોહીમાંથી થોડું થોડું લઈને વેદીનાં ટોચકાંઓને લગાડવું ");
INSERT INTO guj2009_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","એ લોહીમાંથી આંગળી વડે તેણે વેદી ઉપર સાત વખત છાંટા નાખવા, આ રીતે તેણે ઇસ્રાએલીઓની અશુદ્ધિથી મુકત કરી તેને પવિત્ર કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“પરમ પવિત્ર સ્થાનની, મુલાકાતમંડપની અને વેદીની શુદ્ધિ પતી ગયા પછી તેણે જીવતો રહેલો બકરો લાવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","અને પછી હારુનને તેના માંથા પર હાથ મૂકીને ઇસ્રાએલીઓના બધા દોષ, બધા અપરાધ, અને બધાં પાપ કબૂલ કરવાં અને તે બધાં એ બકરાંને માંથે નાખવાં, અને તે પછી તેણે આ કામ માંટે નક્કી કરેલા માંણસ સાથે તે બકરાને રણમાં મોકલી આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","પછી તે બકરો લોકોનાં સર્વ પાપ, જે જગ્યાએ કોઈ રહેતું ના હોય તેવી નિર્જન જગ્યાએ લઈ જશે, અને આ માંણસ તેને નિર્જન અરણ્યમાં છોડી દેશે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“હારુનને બકરાને નિર્જન અરણ્યમાં છોડી દીધા બાદ મુલાકાતમંડપમાં પાછા આવીને પવિત્રસ્થાનમાં દાખલ થતી વખતે ધારણ કરેલાં શણનાં વસ્ત્રો કાઢી નાખવાં, અને ત્યાં જ રહેવા દેવા. ");
INSERT INTO guj2009_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","અને એક પવિત્ર સ્થાનમાં સ્નાન કરીને પોતાનાં બીજાં વસ્ત્રો ધારણ કરીને બહાર જઈ પોતાના અને લોકોના દહનાર્પણ અર્પણ કરવા, આ રીતે તે પોતાને અને લોકોને શુદ્ધ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","તેણે પાપાર્થાર્પણની ચરબી વેદીમાં હોમી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“અઝાઝેલ માંટેના બકરાને લઈ જનાર માંણસે પોતાનાં કપડાં ધોઈ નાખવાં અને સ્નાન કરવું, ત્યાર પછી જ તે છાવણીમાં પાછો આવી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“પછી પાપાર્થાર્પણ તરીકે ધરાવેલા વાછરડાને અને બકરાંને-જેમનું લોહી પ્રાયશ્ચિતવિધિ માંટે પવિત્ર સ્થાનમાં લઈ જવામાં આવ્યું હતું, તેમને છાવણી બહાર લઈ જવા અને ચામડાં, માંસ અને આંતરડાં સહિત બાળી નાખવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","આ બધું બાળનાર માંણસે પોતાનાં વસ્ત્રો ધોઈ નાખવાં, સ્નાન કરવું અને પછી છાવણીમાં પાછા ફરવું. ");
INSERT INTO guj2009_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“નીચે દર્શાવેલ નિયમ તમાંરે સદાય પાળવાનો છે: તમાંરે તથા તમાંરી મધ્યે વસતા વિદેશીઓએ સાતમાં મહિનાના દશમાં દિવસે ઉપવાસ કરવો અને કોઈ કામ કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","તે દિવસે તમને શુદ્ધ કરવા માંટે પ્રાયશ્ચિત વિધિ કરવામાં આવશે; તમાંરે યહોવાની દ્રષ્ટિએ બધાં પાપોથી શુદ્ધ થવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","તમાંરા માંટે તે બહુ ખાસ વિશ્રામનો દિવસ છે. તમાંરે ઉપવાસ કરવાનો છે અને કંઈ કામ કરવાનું નથી. આ કાયમ માંટેનો નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“આ પ્રાયશ્ચિતવિધિ મુખ્ય યાજકે જે તેના પિતાના સ્થાને વિધિપૂર્વક દીક્ષિત કરવામાં આવ્યો હોય તેણે કરવો, તે યાજકે પવિત્ર શણના કપડા પહેરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","તેણે શણનાં પવિત્ર વસ્ત્રો ધારણ કરવાં અને પરમ પવિત્રસ્થાનને માંટે, મુલાકાતમંડપને માંટે, વેદી માંટે, યાજકો માંટે, તથા લોકોના સમગ્ર સમાંજ માંટે પ્રાયશ્ચિતવિધિ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","આ કાયમી નિયમ છે, પ્રતિવર્ષ આ રીતે એક વખત ઇસ્રાએલીઓનાં પાપો માંટે પ્રાયશ્ચિત કરવું.” યહોવાએ મૂસાને આપેલી આ સર્વ આજ્ઞાનો હારુને અમલ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“તું હારુનને તેના પુત્રોને તેમજ બધા ઇસ્રાએલીઓને આ પ્રમાંણે જણાવ: યહોવાએ આ મુજબ જણાવ્યું છે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","જો કોઈ ઇસ્રાએલી પહેલા મુલાકાતમંડપનાં પ્રવેશદ્વાર એટલે કે યહોવાના પવિત્ર મંડપ આગળ બળદ, હલવાન અથવા બકરાનો યહોવાને ધરાવ્યા વિના છાવણીમાં કે છાવણી બહાર વધ કરશે, તો તે રક્તપાતનો ગુનેગાર ગણાશે; તેને સમાંજમાંથી જુદો કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","આ નિમય આપવામાં આવ્યો જેથી ઇસ્રાએલીઓ ખુલ્લા મેદાનોમાં વધેરેલા પશુઓ યહોવાને ભેટ અર્પણ કરવા લાવશે. તેઓએ તેને મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યાજક સમક્ષ લાવીને યહોવાને ભોગ તરીકે ધરાવવાં, ");
INSERT INTO guj2009_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","અને યાજકે અર્પણનું લોહી મુલાકાતમંડપના પ્રવેશદ્વાર આગળની યહોવાની વેદી પર છાંટવું અને ચરબી વેદીમાં હોમી દેવી. એની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","તેઓ ખુલ્લા મેદાનોમાં તેમના ‘વન દેવતાઓને’ અર્પણ ચઢાવે છે તે બંધ થવું જોઈએ. ઇસ્રાએલીઓ ખોટા દેવોની પાછળ પડ્યા છે. આ રીતે તેઓએ વારાંગના જેવો વર્તાવ કર્યો છે. ઇસ્રાએલીઓ અને તેમના વંશજો માંટે આ કાયમી નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“જો કોઈ ઇસ્રાએલી અથવા ઇસ્રાએલીઓ વચ્ચે રહેતો વિદેશી મુલાકાતમંડપના પ્રવેશદ્વાર આગળ યહોવાને ધરાવ્યા વગર દહનાર્પણ કે બીજો કોઈ યજ્ઞ ચઢાવે, ");
INSERT INTO guj2009_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","તો તેનો સમાંજમાંથી બહિષ્કાર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“અને જો કોઈ ઇસ્રાએલી અથવા ઇસ્રાએલીઓ વચ્ચે વસતો વિદેશી લોહીવાળું માંસ જમશે, તો હું (દેવ) તેની વિમુખ થઈશ અને હું તેને તેના લોકોથી જુદો કરીશ. કારણ લોહી એ જ પ્રાણીનો પ્રાણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","કારણ કે શરીરનો જીવ લોહીમાં છે અને મેં તમને તે લોહીને વેદી પર રેડવાના કાયદા આપ્યા છે. આ તમાંરે પોતાની શુદ્ધિ માંટે કરવાનું છે. તમાંરે તે લોહી મને જીવની કિંમત તરીકે આપવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ઇસ્રાએલના લોકોને આપવામાં આવેલી આ આજ્ઞા પાછળનું કારણ એ છે કે તે લોકો કે તેઓમાં વસતો કોઈ વિદેશી લોહીનો ખોરાકમાં ઉપયોગ ન કરે. ");
INSERT INTO guj2009_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“જે કોઈ ઇસ્રાએલી અથવા ઇસ્રાએલીઓ વચ્ચે વસતો વિદેશી ખાદ્ય પક્ષીનો શિકાર કરે ત્યારે તેણે તેનું બધું લોહી વહી જવા દેવું. અને તેના પર માંટી ઢાંકી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","કારણ કે લોહીમાં તેનો જીવ છે, તેથી જ મેં ઇસ્રાએલની પ્રજાને કહ્યું છે કે કદાપિ રકત ખાવું નહિ, કેમકે દરેક પ્રાણી અને પક્ષીનો જીવ તેના લોહીમાં છે, તેથી જો કોઈ ખાય તો તેનો સામાંજિક બહિષ્કાર કરવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“જે કોઈ ઇસ્રાએલી કે વિદેશી કુદરતી રીતે મૃત્યુ પામેલું અથવા જંગલી પ્રાણીઓ માંરી નાખેલું પ્રાણી ખાય તો તેણે પોતાનાં વસ્ત્રો ધોઈ નાખવાં. પાણીથી સ્નાન કરવું અને સાંજ સુધી તે અશુદ્ધ ગણાય તેથી કશાને અડવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","પછીથી જ તે શુદ્ધ જાહેર થશે, જો તે પોતાનાં વસ્ત્રો ધોઈ ન નાખે અને સ્નાન ન કરે, તો તેનું પરિણામ તેને માંથે, તેને પાપની સજા ભોગવવી પડે.” ");
INSERT INTO guj2009_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ઇસ્રાએલી પ્રજાને કહે: હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","માંટે તમાંરે લોકોએ પહેલા તમે જયાં રહેતા હતા, તે મિસરના અથવા હું તમને લઈ જાઉ છું તે કનાન દેશના લોકોની જેમ વર્તવુ નહિ, તમાંરે તેમના રિવાજો પાળવા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","તમાંરે ફકત માંરા જ વિધિઓ પાળવા, અને તમાંરે તેનો અમલ સંપૂર્ણ રીતે કરવો. અને તે અનુસાર તમાંરે તમાંરું જીવન ગાળવું. હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","તમાંરે માંરા વિધિઓ અને નિયમો પાળવા. જે માંણસ તેનું પાલન કરશે તે જીવવા પામશે, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“તમાંરામાંના કોઈએ પણ લોહીની સગાઈવાળા સાથે જાતીય સંબંધ કરવો નહિ, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“કોઈ પણ પુત્રએ પોતાની માંતા સાથે જાતીય સંબંધ કરીને પિતાને કલંક લગાડવું નહિ. એ તમાંરી માંતા છે તેને તમાંરે કલંકિત ન કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","પોતાના પિતાની પત્નીઓમાંથી કોઈની સાથે જાતીય સંબંધ કરવો નહિ કારણ કે તેમાં પિતાનું અપમાંન છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“પોતાની બહેન કે ઓરમાંન બહેન, સાથે જાતીય સંબંધ કરવો નહિ પછી તે તમાંરા બાપની પુત્રી હોય કે માંતાની પુત્રી હોય; તે એક જ ઘરમાં જન્મી હોય તેથી તમાંરે તેની સાથે લગ્ન ન કરવાં કે જાતીય સંબંધ પણ ન કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“તમાંરે તમાંરા પુત્રની પુત્રી, કે પુત્રીની પુત્રી સાથે લગ્ન કે જાતીય સંબંધ ન કરવો, એ તમાંરી પોતાની જાતને કલંકિત કરવા બરાબર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“તમાંરે તમાંરાં પિતાની પત્નીને તમાંરા પિતાથી થયેલ પુત્રી સાથે લગ્ન કે જાતીય સંબંધ ન કરવો, તે તમાંરી બહેન છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“તમાંરે તમાંરા પિતાની બહેન સાથે જાતીય સંબંધ ન કરવો, કારણ કે તમાંરા પિતાની સાથે લોહીની સગાઈ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","તમાંરે તમાંરી માંતાની બહેન સાથે જાતીય સંબંધ ન કરવો, કારણ કે એને તમાંરી માંતા સાથે લોહીની સગાઈ છે, ");
INSERT INTO guj2009_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","તમાંરે તમાંરા પિતાના ભાઈને બદનામ ન કરવા, તમાંરે તેની પત્ની સાથે જાતીય સંબંધ ન કરવો, કારણ કે તમાંરી કાકી છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“તમાંરે તમાંરી પુત્રવધૂ સાથે જાતીય સંબંધ ન કરવો, તે તમાંરા પુત્રની પત્ની છે, તમાંરે તેને કલંકિત ન કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“તમાંરે તમાંરી ભાઈની પત્ની સાથે જાતીય સંબંધ ન કરવો, કારણ એ તમાંરા ભાઈને કલંકિત કર્યા બરાબર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“તમાંરે કોઈ સ્ત્રી સાથે તેમજ તેની પુત્રી, પૌત્રી કે દોહિત્રી સાથે જાતીય સંબંધ કરવો નહિ, કારણ કે તેઓ નજીકનાં સગાં છે, અને એમ કરવું એ અતિશય દુષ્ટ કર્મ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“તમાંરી પત્ની જીવતી હોય ત્યા સુધી તેની બહેન સાથે લગ્ન ન કરવા. કેમકે તમે બન્નેને પરણો તો તેમના વચ્ચે અણગમો થાય. તમાંરે તમાંરી સાળી સાથે જાતીય સંબંધ ન કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“તમાંરે કોઈ ઋતુમતિ સ્ત્રી સાથે જાતીય સંબંધ ન કરવો, કારણકે તે આ સમયમાં અશુદ્ધ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“તમાંરે પારકાની સ્ત્રી સાથે વ્યભિચાર ન કરવો: પરસ્ત્રીથી તમાંરી જાતને અશુદ્ધ ન કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“તમાંરે તમાંરું કોઈ બાળક મોલેખને ચઢાવવા આપવું નહિ. મોલેખની વેદી પર તમાંરા બાળકની આહુતિ ન આપવી. આ રીતે તમે કરશો તો તમાંરા દેવનો અનાદર થશે અને તેમના નામને કલંક લાગશે, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“સજાતીય શારીરિક સંબંધની સંપૂર્ણ મનાઈ છે. તમાંરે કોઈ પુરુષ સાથે સ્ત્રીની જેમ જાતીય સંબંધ ન કરવો, કેમકે એ તો ભયંકર પાપ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“તમાંરે કોઈ માંદા પશુ સાથે સ્ત્રીની જેમ જાતીય સંબંધ ન કરવો, એથી તમે અશુદ્ધ થશો, કોઈ સ્ત્રીએ કોઈ નર પશુ સાથે જાતીય સંબંધ ન કરવો, એ વિકૃતિ છે, તે ભયંકર દુષ્ટતા છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“આમાંની કોઈ પણ રીતે તમાંરે તમાંરી જાતને અશુદ્ધ ન કરવી. હું જે પ્રજાઓને તમાંરા માંટે સ્થાન ખાલી કરવા હાંકી કાઢનાર છું તેઓ આવી રીતે અશુદ્ધ થયેલ પ્રજા છે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","એ સમગ્ર દેશ આ પ્રકારની દુષ્ટ પ્રવૃતિઓથી ભ્રષ્ટ બની ગયો છે, તેથી ત્યાં રહેતા લોકોને એમના દોષની સજા કરીને હું તેઓને તે દેશમાંથી હાંકી કાઢવાનો છું. ");
INSERT INTO guj2009_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“પરંતુ તમાંરે માંરા વિધિઓ અને નિયમોનું પાલન કરવું. તમાંરે આમાંનું કોઈ ઘૃણાજનક કાર્ય કરવું નહિ, પછી ભલે તમે ઇસ્રાએલ પ્રજામાં જન્મેલા હોય કે વિદેશથી આવીને વસ્યા હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","તમાંરા પહેલા જે પ્રજા આ દેશમાં રહેતી હતી, તે આ બધા ઘૃણાજનક કાર્યો કરતી હતી તેથી દેશ અશુદ્ધ થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","તમે આ પ્રમાંણે કરશો નહિ, નહિ તો તે પ્રજાની જેમ તમને પણ તે દેશમાંથી હું હાંકી કાઢીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","જે કોઈ આમાંનું કોઈ પણ ભયંકર પાપ કરશે તેનો સમાંજમાંથી બહિષ્કાર થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","માંટે ફરમાંનનું પાલન ચોકસાઈ પૂર્વક કરજો, તમાંરા પહેલાના લોકો ઘૃણાપાત્ર રિવાજો પાળતા હતા, તેનું પાલન કરીને તમાંરી જાતને અશુદ્ધ ન બનાવશો. હું તમાંરો દેવ યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ઇસ્રાએલીઓના સમગ્ર સમાંજને આ પ્રમાંણે જણાવ: તમે પવિત્ર થાઓ, કારણ હું તમાંરો દેવ યહોવા પવિત્ર છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“તમાંરામાંના પ્રત્યેક વ્યક્તિએ પોતાના માંતાપિતાને માંન આપવું અને માંરા ખાસ વિશ્રામવારોનું પાલન કરવું. હું તમાંરો દેવ યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ધાતુની મૂર્તિઓ બનાવશો નહિ, ને મૂર્તિપૂજા કરશો નહિ. હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“તમે જ્યારે યહોવાની આગળ ભેટ અર્પણ ચઢાવો ત્યારે તેને સરખી રીતે ચઢાવો જેથી તેનો સ્વીકાર થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","જે દિવસે તમે અર્પણ કરો તે જ દિવસે જમી લેવું જોઈએ. અને પછી તે દિવસે જે કાંઈ બચ્યું હોય તે જમી લેવું; પરંતુ ત્રીજા દિવસ સુધી એમાંનું જે બચે તે અગ્નિમાં બાળી નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","કારણ, તે દૂષિત છે અને તે ત્રીજે દિવસે સહેજપણ ખાવું નહિ, કારણ કે તે અમંગળ છે, એનો સ્વીકાર નહિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","જે કોઈ તે ખાય તેણે સજા ભોગવવી પડશે, કારણ, તે દોષિત છે. તેણે યહોવાને ચઢાવેલું પવિત્ર અર્પણ ભ્રષ્ટ કર્યુ છે, તેથી તેનો લોકોએ સામાંજીક બહિષ્કાર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“જયારે તમે ખેતરમાં પાકની કાપણી કરો ત્યારે છેક ખૂણા સુધી લણશો નહિ અને ધઉની કાપણીનો મોડ પણ વીણી લેશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","એ જ પ્રમાંણે દ્રાક્ષના વેલાને પૂરેપૂરા વીણશો નહિ, તેમજ નીચે પડેલી દ્રાક્ષ પણ વીણશો નહિ. ગરીબો તેમજ મૂસાફરો માંટે તે રહેવા દેજો. હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“તમાંરે ચોરી કરવી નહિ, કે કોઈને છેતરવું કે ઠગવું પણ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","તમાંરે ખોટી વાત માંટે માંરા નામના સમ ખાઈને તમાંરા દેવ યહોવાનું નામ વગોવવું નહિ, કારણ, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“તમાંરે કોઈને લૂંટવો નહિ કે કોઈનું શોષણ કરવું નહિ, ત્રાસ આપવો નહિ, મજૂરીએ રાખેલા માંણસનું મહેનતાણું સમયસર ચૂકવી દેવું. તેઓના મહેનતાણાંમાંથી તારી પાસે કાંઈ બાકી રહે તો તે સવાર થતાં સુધી તારી પાસે રાખવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“બહેરા માંણસને કદી શાપ ના દેવો, અને અંધજનના માંર્ગમાં અડચણ ન મુકવા. માંરી બીક રાખજો. હું તમાંરો દેવ યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ન્યાયધીશોએ પોતાના ન્યાયમાં સદા પ્રામાંણિક રહેવું, ગરીબો પ્રત્યે ખોટી દયા દર્શાવીને કે મોટાની આણ રાખીને અન્યાયી ચુકાદો આપવો નહિ, હંમેશા ઉચિત ન્યાય કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","દેશબાંધવોમાં તમાંરે કોઈની કૂથલી કરવી નહિ, કોઈના પર ખોટો આરોપ મૂકીને એનું જીવન જોખમમાં મૂકવું નહિ, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“તમાંરે તમાંરા ભાઈના વિષે મનમાં ડંખ રાખીને તેનો તિરસ્કાર કરવો નહિ, તારા પડોશીને પાપ કરે તો તેનો દોષ બતાવી ઠપકો આપવો અને તેને છોડી મૂકવો. એટલે તેનું પાપ તમાંરા માંથે આવે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","કોઈના પર વૈર વાળીને બદલો લેવાની ભાવના રાખવી નહિ, પરંતુ જેમ પોતાના પર પ્રેમ રાખીએ તેમ પડોશીઓ પર પણ પ્રેમ રાખવો. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“માંરા નિયમો પાળજો. તમાંરાં પશુઓને જુદી જાતનાં પશુ સાથે ગર્ભાધાન કરાવશો નહિ. તમાંરા ખેતરમાં એકી સાથે બે જાતનાં બી વાવશો નહિ તેમજ જુદી જુદી બે જાતના તારનું વણેલું કાપડ પણ પહેરશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“જો કોઈ માંણસ બીજા માંણસની દાસીનાપર ઉપભોગ કરે, જે તેણે તેને ખરીદી ન હતી અથવા આઝાદ ન હતી તો શિક્ષા થવી જોઈયે પણ બન્નેને મૃત્યુદંડ ન થાય, કારણ કે તે આઝાદ ન હતી. ");
INSERT INTO guj2009_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","તેથી તેમાં સંડોવાયેલ વ્યક્તિએ દોષાર્થાર્પણ માંટે મુલાકાતમંડપના દ્વાર આગળ યહોવા સમક્ષ ઘેટો લઈને આવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","અને યાજકે તે વ્યક્તિના પાપના નિવારણાર્થે યહોવા સમક્ષ પ્રાયશ્ચિતવિધિ કરવી, એટલે તેને માંફ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“કનાન દેશમાં તમે જ્યારે પ્રવેશ કરો અને કોઈ પણ ફળનું વૃક્ષ રોપો તો તેનાં ફળને ત્રણ વર્ષ સુધી અશુદ્ધ હોવાને કારણે ખાશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ચોથે વર્ષે તેના બધા જ ફળને યહોવાનું સ્તવન કરવા માંટે અર્પણ કરી દેજો. ");
INSERT INTO guj2009_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","છેવટે પાંચમે વરસે તમે તેનાં ફળ ખાઈ શકો. જો એમ કરશો તો તેનો ફાલ વધુ ઊતરશે. હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“તમાંરે લોહીવાળું માંસ ખાવું નહિ, તેમજ કામણ ટૂમણ પણ કરવું નહિ, તેમજ તમાંરે જ્યોતિષીઓ કે જાદુગરો પાસે જવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“તમાંરા કાનની બાજુના વાળ મૂર્તિપૂજાકોની જેમ કાપો નહિ, તમાંરી દાઢી બોડવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","કોઈના મૃત્યુના શોકમાં તમાંરા શરીર પર ઘા કરવા નહિ તથા તમાંરા શરીર પર છૂંદણાં છૂંદાવવા નહિ, હું યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“તમાંરી પુત્રીને દેવદાસી બનીને ભ્રષ્ટ થવા દેશો નહિ; તમાંરા દેશના લોકોને વારાંગના બનવા દેતા નહિ. તે પ્રકારનું પાપ તમાંરા આખા દેશમાં પ્રચલિત ન થવા દેતા. ");
INSERT INTO guj2009_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“તમે માંરા સાબ્બાથો પાળજો, અને માંરા પવિત્રસ્થાનનું માંન જાળવજો, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ભૂવા કે જાદુગરો પાસે જઈને તેમને પ્રશ્નો પૂછીને તેમની સલાહ લઈને તમાંરી જાતને અશુદ્ધ કરશો નહિ, કારણ કે હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“દેવનો ડર રાખો અને વડીલોનું સન્માંન કરો, તેઓ જ્યારે ઓરડીમાં આવે ત્યારે ઉભા થાવ, હું તમાંરો દેવ યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“જો કોઈ વિદેશી તમાંરા દેશમાં આવે, ને તમાંરી સાથે રહે તો તમાંરે તેને છેતરવો કે તેની પર ત્રાસ કરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","તેને તમાંરે તમાંરા જેવો જ વતની માંનવો અને તેના પર તમાંરી જાત જેટલો જ પ્રેમ રાખો. તમે પણ મિસરમાં પરદેશી હતા તેનું સ્મરણ કરો. હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“તમાંરે લોકોનો ન્યાય કરતી વખતે નિષ્પક્ષ રહેવું. લંબાઈ માંપવામાં, કે વસ્તુઓનું વજન કરવામાં અને માંપવામાં ખોટાં માંપ વાપરી કોઈની સાથે છેતરપિંડી કરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","તમાંરે સાચાં ત્રાજવાં, સાચાં કાટલાં, અને સાચાં માંપ રાખવાં, હું તમને મિસર દેશમાંથી બહાર લઈ આવનાર તમાંરો દેવ યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“તમાંરે માંરા બધા જ નિયમો આજ્ઞાઓ અને માંરી વિધિઓ પ્રત્યે સંપૂર્ણ ધ્યાન આપવું અને કાળજીપૂર્વક તેનું પાલન કરવું અને તેમનો અમલ કરવો, કારણ, હું યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“તું ઇસ્રાએલી પ્રજાને આ આજ્ઞાઓ આપ: જો કોઈ ઇસ્રાએલી કે તેઓની વચમાં રહેતો વિદેશી પોતાનાં બાળક મોલેખ દેવને ચઢાવવા આપે તો તેને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","હું પોતે તે માંણસની વિરુદ્ધ થઈશ, અને તેના લોકોમાંથી તેનો બહિષ્કાર કરીશ, કારણ તેણે મોલેખને પોતાનું બાળક ચઢાવીને માંરા પવિત્રસ્થાનને ભ્રષ્ટ કર્યુ છે. અને માંરા પવિત્ર નામને કલંકિત કર્યુ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","જો કોઈ માંણસ પોતાનું બાળક મોલેખને ચઢાવે, ત્યારે દેશના લોકો જો આંખ આડા કાન કરે અને તેને મૃત્યુદંડ આપવાની ના પાડે, ");
INSERT INTO guj2009_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","તો હું જાતે તેની અને તેના પરિવારની વિમુખ થઈ જઈશ, અને તેનો તથા તેની સાથે મોલેખની પૂજા કરનારા તથા માંરા તરફ વિશ્વાસઘાત દાખવનાર સૌ કોઈનો તેના લોકોમધ્યેથી બહિષ્કાર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“જે કોઈ માંરા પ્રત્યે વિશ્વાસઘાત દાખવશે અને મધ્યસ્થી તથા જાદુગરો પાસે જઈને તેમની સલાહ લેશે, તેની હું વિમુખ થઈશ અને તેમના લોકોમાંથી તેનો હું બહિષ્કાર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“તેથી તમાંરી જાતને શુદ્ધ અને પવિત્ર રાખો, કારણ કે, હું યહોવા તમાંરો દેવ પવિત્ર છું. ");
INSERT INTO guj2009_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","તમાંરે કાળજીપૂર્વક માંરા સર્વ વિધિઓનું પાલન કરવું, કારણ હું તમને શુદ્ધ કરનાર યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“જો કોઈ પોતાના પિતાને અને માંતાને શાપ આપે તો તેને મૃત્યુદંડ આપવો. એણે પોતાના પિતાને કે માંતાને શાપ આપ્યો છે તેથી તે પોતાના મોત માંટે પોતે જ જવાબદાર ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“જે કોઈ પુરુષ પરસ્ત્રી સાથે વ્યભિચાર કરે તો તેને અને સ્ત્રીને બંનેને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","જો કોઈ પુરુષ પોતાના પિતાની પત્ની સાથે કૂકર્મ કરે, તો તેણે પોતાના પિતાને કલંક લગાડયું છે, તે બંને મૃત્યુદંડને પાત્ર થાય. તેમના મોતની જવાબદારી તેમને માંથે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“જો કોઈ પુરુષ પોતાની પુત્રવધુ સાથે વ્યભિચાર કરે, તો તે બંનેને મૃત્યુદંડ આપવો. તેમણે અગમ્યગમન કર્યુ હોવાથી પોતાના મોત માંટે તેઓ પોતે જ જવાબદાર ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“જો કોઈ પુરુષ અન્ય પુરુષ સાથે સ્ત્રીની જેમ વ્યભિચાર કરે તો તે બંનેએ અમંગળ કર્યુ છે, તેમને મૃત્યુદંડ આપવો. તેમના મૃત્યુ માંટે તેઓ પોતેજ જવાબદાર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“જો કોઈ પુરુષ કોઈ સ્ત્રીને તેની માંતાને બંનેને પરણે કે વ્યભિચાર કરે તો તે દુષ્ટતા છે. તે પુરુષને અને તે સ્ત્રીઓને અગ્નિમાં બાળી મૂકવાં, તમાંરામાં લંપટતા હોવી જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“જો કોઈ પુરુષ કોઈ પશુ સાથે કુકર્મ કરે, તો તેને મૃત્યુદંડ આપવો અને તે પશુને માંરી નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","અને જો કોઈ સ્ત્રી કોઈ પશુ સાથે જાતીય સંબંધ કરે, તો તે સ્ત્રીને અને પશુને બંનેને માંરી નાખવાં કારણ, તેઓ એ જ શિક્ષાને લાયક છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“જો કોઈ પુરુષ પોતાના પિતાની કે માંતાની પુત્રીને પરણે અને તેની સાથે જાતીય સંબંધ કરે તો એ અત્યંત લજ્જાસ્પદ છે. તેમનો વઘ જાહેરમાં કરવો. એ વ્યક્તિએ પોતાની બહેન સાથે વ્યભિચાર કર્યો છે માંટે તેનો સમાંજમાં બહિષ્કાર કરવો. તેનો દોષ પુરુષને માંથે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“જો કોઈ પુરુષ કોઈ સ્ત્રી સાથે તેના ઋતુકાળ દરમ્યાન શારીરિક જાતીય સંબંધ કરે તો નિયમોનો ભંગ કરવા બદલ બંનેનો સમાંજમાંથી બહિષ્કાર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“કોઈ પણ પુરુષે તેની માંસી કે ફોઈની સાથે શારીરિક જાતીય સંબંધ કરવો નહિ. એ અગમ્યગમન છે, કારણ, તેઓ તેના નજીકનાં સગાં છે, તેમને તેમના પાપની સજા થવી જ જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“જો કોઈ માંણસ પોતાની કાકી સાથે કુકર્મ કરે તો તે પોતાના કાકાને કલંક લગાડે છે. એ બંનેને તેમનાં પાપની સજા થવી જ જોઈએ. તેઓ નિઃસંતાન અવસાન પામશે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“જો કોઈ પુરુષ પોતાના ભાઈની સ્ત્રી સાથે પરણે તો તે વ્યભિચાર ગણાય; તેણે એના ભાઈને કલંક લગાડયું છે એ બંને નિઃસંતાન રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“તમાંરે માંરા તમાંમ વિધિઓ અને નિયમોનું પાલન કરવું અને તેને અનુસરવું; હું તમને તમાંરા નવા દેશમાં લઈ જઈશ અને તમે માંરા કાયદાઓ અને નિયમોનું પાલન કરશો તો તે દેશ તમને હાંકી કાઢશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","તમાંરે ત્યાંના લોકોના રિવાજો પાળવા નહિ. એ બધા કૂકર્મો કરવા બદલ હું તેમને ધિક્કારું છું અને તે સૌને તમાંરી આગળથી હાંકી કાઢીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","મેં તમને તેઓનો દેશ આપવાનું વચન આપ્યું છે. તમે તે દેશના માંલિક બનો. હું જાતે તમને જયાં દૂધ અને મધનીરેલછેલ છ એવી એ ભૂમિનો કબજો આપીશ. “હું તામરો દેવ યહોવા છું. મેં તમને અન્ય પ્રજાઓથી જૂદા પાડયા છે. ");
INSERT INTO guj2009_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","તેથી તમાંરે ખાદ્ય અને અખાદ્ય પશુઓ અને પંખીઓનો ભેદ પરખવો. તમાંરે એ અખાદ્ય પશુઓ, પંખીઓ અને પેટે ચાલનારા જીવો ખાઈને અશુદ્ધ થવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","મેં એ બધાંને અખાદ્ય ઠરાવ્યાં છે, એમને ખાવાથી અશુદ્ધ થશો, તમે માંરાજ છો અને પવિત્ર રહેવા બંધાયેલા છો, કારણ હું યહોવા પવિત્ર છું, મેં તમને આ બધા લોકોથી જુદા પાડયા છે જેથી તમે માંરા થઈ શકો.” ");
INSERT INTO guj2009_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“તમાંરામાંથી જે કોઈ પુરુષ કે સ્ત્રી ભૂતવૈદ હોય કે જાદુગર હોય તેને મૃત્યુદંડ આપવો. લોકોએ તેઓને પથ્થરો વડે માંરી નાખવાં તેઓના મોતની જવાબદારી તેમની પોતાની જ છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","“હારુનના વંશના યાજકોને કહે કે, ");
INSERT INTO guj2009_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","કોઈ યાજકે પોતાનાં માંતા, પિતા, પુત્ર, પુત્રી, ભાઈ અથવા ઘરમાં રહેતી કુંવારી સગી બહેન જેવાં લોહીની સગાઈ સિવાયના બીજાં સગાંના મૃત્યુ વખતે શબ પાસે જઈને કે અડીને અભડાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","કારણ, યાજક તેના લોકોનો આગેવાન છે તેથી તેણે જે લોકો તેના નજીકના સગા નથી, તેઓના મૃતદેહને અડીને પોતાની જાતને અશુદ્ધ કરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“યાજકોએ શોક પાળવા માંટે પોતાના માંથાના વાળ મૂંડાવવા નહિ, તેમજ દાઢીની કિનાર પણ મૂંડાવવી નહિ અને પોતાના શરીર પર કોઈ ઘા પણ પાડવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","તેઓ માંરા છે તેથી પવિત્ર રહેવા બંધાયેલા છે, તેમણે માંરા નામને કલંક લગાડવું નહિ, કારણ તેઓ યહોવાના હોમયજ્ઞો એટલે પોતાના અર્પણ મને ધરાવનાર છે, તેથી તેમણે પવિત્રતા જાળવવી જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“તેમણે વારાંગનાને અથવા કૌમાંર્ય ગુમાંવેલી કે છૂટાછેડા લીધેલી સ્ત્રીને પરણવું નહિ, કારણ યાજક તો દેવને સમર્પિત થયેલ હોય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","તમાંરે યાજકને પવિત્ર ગણવો જોઈએ, કારણ કે મને અર્પણ ધરાવનાર તે છે. તમાંરે તેને પવિત્ર ગણવો જોઈએ, કારણ હું યહોવા પવિત્ર છું અને તમને પવિત્ર બનાવું છું. ");
INSERT INTO guj2009_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“જો કોઈ યાજકની પુત્રી વારાંગના થઈ જાય તો તે પોતાના પિતાને કલંકિત કરે છે, તેથી તેને બાળી મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“તેલથી અભિષેક થયેલા અને યાજકનાં વસ્ત્રો પરિધાન કરી દીક્ષિત થયેલા વડા યાજકે શોક પાળવા પોતાના વાળ છૂટા મૂકવા નહિ તથા પોતાનાં વસ્ત્રો ફાડવા નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","જે જગ્યાએ માંણસનું શબ પડયું હોય ત્યાં તેણે જવું નહિ, અશુદ્ધ થવું નહિ, પછી ભલે તે શબ પોતાના પિતા કે માંતાનું હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","તેલથી અભિષિક્ત થઈને તે મને સમર્પિત થયેલ છે, એટલે તે ફરજ પર હાજર હોય ત્યારે પવિત્રસ્થાનની બહાર જાય નહિ તેમજ ત્યાં જવા માંટે માંરા મુલાકાતમંડપને છોડી તેણે તેને ભ્રષ્ટ કરવાનો નથી, કારણ હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“જેનું કૌમાંર્ય કાયમ હોય તેવી સ્ત્રી સાથે જ તેને લગ્ન કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","તેણે કોઈ વિધવાને, કે વારાંગનાને, કે છૂટાછેડા લીધેલી સ્ત્રીને પરણવું નહિ, પણ પોતાના લોકમાંની જ કોઈ કુમાંરિકા સાથે જ પરણવું. ");
INSERT INTO guj2009_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","નહિ તો તેનાં સંતાનો વગળવંશી થઈ જશે, તેમનું અડધું લોહી યાજકનું અને અડધું લોહી સામાંન્ય હોય તેમ બનવું જોઈએ નહિ. હું યહોવા છું. મેં મહા યાજકને પવિત્ર બનાવેલો છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“તું હારુનને કહે કે, તારા શારીરિક ખોડખાંપણવાળા કોઈ પણ વંશજે મને અર્પણ ધરાવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","શારીરિક ખોડખાંપણવાળા કોઈ પણ માંણસે પછી તે આંધળો હોય, કે લૂલો હોય, કોઈ અંગ અતિશય મોટું હોય કે નાનું હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","અથવા ઠૂંઠો હોય કે લંગડો હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ખૂંધો હોય કે વામણો હોય, કે નેત્રનો રોગ કે ચામડીનો રોગ થયેલો હોય, કે વ્યંઢળ હોય અર્પણ ધરાવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“હારુનના શારીરિક ખોડખાંપણવાળા કોઈ પણ વંશજે મને આહુતિ ધરાવવી નહિ, જો તેનામાં કોઈ ખોડ હોય તો તેણે માંરું અર્પણ ધરાવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","તેમ છતાં દેવ સમક્ષ ધરાવેલ અર્પણ પવિત્ર તેમજ પરમપવિત્ર અર્પણોમાંથી યાજકોનો જે ભાગ છે તેમાંથી તે જમી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","પરંતુ તેણે પડદાની નજીક કે પડદાની પાછળ અગ્નિની વેદીની નજીક જવું નહિ કારણ તેનામાં શારીરિક ખોડ છે, અને તેણે માંરી પવિત્ર જગ્યાઓને ભ્રષ્ટ કરવાની નથી; કારણ મેં યહોવાએ તેને પવિત્ર કરેલી છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","મૂસાએ હારુનને અને તેના પુત્રોને અને સૌ ઇસ્રાએલીઓને આ પ્રમાંણે જણાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“હારુનને તથા તેના પુત્રોને આ આજ્ઞાઓ આપ: લોકોએ આપેલી પવિત્ર ભેટોને અપવિત્ર કરીને તેઓ માંરા પવિત્ર નામને કલંક ન લગાવે. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","તું તેમને કહે: તમાંરો કોઈ પણ વંશજ પોતે અશુદ્ધ હોય ત્યારે ઇસ્રાએલીઓએ મને ધરાવેલા અર્પણની પાસે આવે તો તેને માંરી સેવામાંથી યાજકપદેથી દૂર કરવો. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“હારુનના વંશના જે કોઈને કોઢ થયો હોય અથવા સ્રાવ થતો હોય; તેણે શુદ્ધ થતાં સુધી પવિત્ર અર્પણમાંથી કશું ખાવું નહિ, જો યાજક મૃતદેહને અડે અથવા યાજકને વીર્ય સ્રાવ થયો હોય. ");
INSERT INTO guj2009_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","અથવા સર્પવર્ગના પ્રાણીનો કે મનાઈ કરેલી વસ્તુઓ સ્પર્શ કરે અથવા કોઈ કારણસર અશુદ્ધ થયેલી વ્યક્તિને અકડે; ");
INSERT INTO guj2009_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","તો તે યાજક સાંજ સુધી અશુદ્ધ ગણાય અને સાંજે તે સ્નાન કરીને શુદ્ધ ન થાય ત્યાં સુધી તેણે પવિત્ર અર્પણમાંથી કશુંય ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","સૂર્યાસ્ત થયા પછી તે શુદ્ધ ગણાય, અને ત્યારે તે પવિત્ર ખોરાક ખાઈ શકે, કારણ તે પર તેના જીવનનો આધાર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“તેણે કુદરતી રીતે મૃત્યુ પામેલું કે જંગલી જનાવરે ફાડી નાખેલું પ્રાણી ખાવું નહિ. જો તે ખાય તો અશુદ્ધ ગણાય. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“તું યાજકોને ચેતવણી આપ કે યાજકોએ માંરા નિયમોનું પાલન કરવું: નહિ તો તેમને પાપ લાગશે, અને માંરા નિયમોનો ભંગ કરવા તેમણે મરવું પડશે. તેઓને પવિત્ર કરનાર હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","યાજક પરિવારના ના હોય એવા કોઈ પણ માંણસે પછી તે યાજકનો મહેમાંન હોય કે પછી તેણે મજૂરીએ રાખેલો નોકર હોય. યાજકના ભાગની પવિત્ર અર્પણની રોટલી ખાવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","આમાં એક અપવાદ છે જો યાજકે પોતાના નાણાથી ચાકર ખરીદેલો હોય તો તે ચાકર અને યાજકના ઘરમાં જન્મેલા ચાકર બાળકો આ પવિત્ર અર્પણ જમી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","યાજકની દીકરીના લગ્ન જે માંણસ યાજક ન હોય તેની સાથે થયા હોય, તો તેણે પવિત્ર અર્પણોમાંથી ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","“પણ જો તે વિધવા હોય અથવા છૂટાછેડા આપેલી હોય અને તેનું ભરણપોષણ કરવાને કોઈ પુત્ર ન હોય અને તે પોતાના પિતાના પરિવારમાં પાછી ફરી હોય, તો તે પોતાના પિતાના પવિત્ર અર્પણોમાંથી ખાવાનુ ખાઈ શકે છે. આ સિવાય જેઓ યાજકોના પરિવારમાં નથી તેઓએ આ અર્પણોમાંથી ખાવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“જો કોઈ વ્યક્તિ અજાણતા આ પવિત્ર અર્પણોમાંથી ખાય તો, તેની કિંમતના 20 ટકા ઉમેરીને યાજકને તે મૂલ્ય ભરપાઈ કરી આપે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“યાજકોએ ઇસ્રાએલીઓએ યહોવાને ધરાવેલાં અર્પણનો પોતાનો ભાગ યાજક ન હોય એવા લોકોને ખાવા દઈ એને ભ્રષ્ટ કરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","યાજકે પવિત્ર અર્પણોને બીજા લોકોને ખાવા દઈને તેમના પાપમાં વધારો ન કરવો અને તેને અપવિત્ર ન કરવું. હું યહોવા અર્પણોને પવિત્ર કરનાર છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","યહોવા દેવે મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“તું હારુનને અને તેના પુત્રોને તથા તમાંમ ઇસ્રાએલીઓને કહે કે જો કોઈ ઇસ્રાએલી અથવા તેઓની વચ્ચે રહેતો વિદેશી માંનતા પૂરી કરવા માંટે દહનાર્પણ તરીકે યહોવાને ઢોર કે ઘેટાં બકરાંની આહુતિ ચઢાવે, ");
INSERT INTO guj2009_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","તો તે પશ ખોડખાંપણ વગરનું નર હોય તો જ સ્વીકાર્ય બને. ");
INSERT INTO guj2009_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","તેથી તમાંરે ખોડવાળું પશુ ચઢાવવું નહિ, નહિ તો તે અસ્વીકાર્ય થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“જો કોઈ વ્યક્તિ માંનતા પૂરી કરવા અથવા ઐચ્છિકાર્પણ તરીકે યહોવા સમક્ષ વિશેષ ભેટ તરીકે લાવે, તો તે પ્રાણી બળદ અથવા ઘેટું હોઈ શકે પણ તેમાં કોઈ દોષ હોવો ન જોઈએ, નહિ તો તે અમાંન્ય થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","તમાંરે યહોવાને આંધળું, લૂલું, અપંગ, ઈજા પામેલ અંગવાળું, વહેતા ધારાવાળું, ગદગૂમડાવાળું કે પરુંવાળું પ્રાણી ચઢાવવું નહિ, એવું કોઈ પ્રાણી યહોવાને અર્પણ તરીકે વેદી પર ધરાવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“જો કોઈ બળદ અથવા ઘેટું યહોવાને અર્પણ કરવામાં આવે અને જો તેને બહુ લાંબો પગ હોય અથવા પગનો સરખો વિકાસ ન થયો હોય, તો તેનો વિશેષ ભેટ તરીકે વધ કરી શકાય પણ તેને માંનતા કે પ્રતિજ્ઞા પૂરી કરવા માંટે અર્પણ કરી શકાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“જે પશુના અંડકોશ છૂંદી, કચડી, ચીરી કે કાપી નાખવામાં આવ્યા હોય તેને તમાંરે યહોવાને ધરાવવું નહિ, તમાંરા દેશમાં એવું કદી કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“જે વિદેશીઓ તેવા પશુઓને યહોવાને અર્પણ તરીકે લાવે, તો તમાંરે એનો સ્વીકાર ન કરવો. કારણકે પ્રાણી અપંગ હોઈ શકે અને તેમને ખોડખાંપણ હોઈ શકે, તેથી તે સ્વીકારાય નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“જયારે કોઈ વાછરડું, લવારુ કે બકરું જન્મે ત્યારે સાત દિવસ સુધી તેને તેની માં પાસેથી કોઈએ લઈ લેવું નહિ. આઠમાં દિવસે અને તે પછી તે યહોવા સમક્ષ અગ્નિ દ્વારા યજ્ઞ માંટે માંન્ય થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","તમાંરે એક જ દિવસે બચ્ચાંનો તથા તેની માંનો વધ કરવો નહિ. પછી તે ગાય હોય કે ઘેટી. ");
INSERT INTO guj2009_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“જો તમને વિશેષ આભારાર્થે દેવને અર્પણ આપવાની ઈચ્છા હોય, તો તે ભેટ આપવાની તમને છૂટ છે. પણ તે તમાંરે એ રીતે આપવું જેથી તેઓ પ્રસન્ન થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","તમાંરે તે જ દિવસે તે આખુ પ્રાણી જમી લેવું. બીજા દિવસે સવાર માંટે તેમાંથી કાંઈ રાખવું નહિ. હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“તમાંરે માંરી સર્વ આજ્ઞાઓનું પાલન કરવું અને તેનો અમલ કરવો, કારણ કે હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","તમાંરે માંરા પવિત્ર નામને ભ્રષ્ટ કરવું નહિ; બધા ઇસ્રાએલીઓએ માંરી પવિત્રતા જાળવવી. હું તમને પવિત્ર કરનાર યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","હું તમને મિસરમાંથી તમાંરો દેવ થવા માંટે લઈ આવ્યો હતો. હું યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ઇસ્રાએલી લોકોને તું આ કહે: યહોવાના ઉત્સવો નીચે મુજબ છે, તમાંરે યહોવાના પસંદ કરેલા ઉત્સવોને ધર્મસંમેલનો તરીકે જાહેર કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“છ દિવસ કામ કરવું, પણ સાતમો દિવસ તો સંપૂર્ણ વિશ્રામનો દિવસ છે, એ તો પવિત્ર સંમેલનનો દિવસ છે, એ દિવસે કામ ન કરવું. તમે ગમે ત્યાં રહેતા હોય, તે યહોવાનો દિવસ છે, વિશ્રામવાર છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“પ્રતિવર્ષ યહોવાના જે ઉત્સવો ઉજવવાના, ધર્મસંમેલનો બોલાવવાના પવિત્ર પર્વો છે તે નીચે મુજબ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","આ પર્વની ઊજવણી પહેલા મહિનાના ચૌદમે દિવસે પરોઢે શરુ થવી જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“એ મહિનામાં પંદરમાં દિવસથી બેખમીર રોટલીનો ઉત્સવ શરુ થાય છે. સાત દિવસ સુધી તમાંરે ખમીર વગરની રોટલી ખાવી. ");
INSERT INTO guj2009_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","આ પર્વના પ્રથમ દિવસે ધર્મસંમેલન રાખવું અને કોઈ દૈનિક સાંસારિક કાર્ય કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","પર્વના સાતમાં દિવસે પણ તમાંરે ફરી ધર્મસંમેલન કરવું. રોજના કામ કરવાં નહિ અને પ્રથમ દિવસ અને છેલ્લા દિવસની વચ્ચેના દિવસોએ રોજ તમાંરે યહોવા સમક્ષ અગ્નિમાં આહુતિ માંટે અર્પણ લાવવું.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ઇસ્રાએલીઓને કહો, હું તમને આપું છું તે દેશમાં તમે દાખલ થાઓ અને પાક લણો ત્યારે તમાંરે પહેલા પાકનો પહેલો દાણાનો પૂળો તમાંરે સાબ્બાથના પછીના દિવસે યાજક પાસે લઈને આવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","યાજક સાબ્બાથના પછીના દિવસે પૂળો યહોવાને ઉપાસનાની જેમ ધરાવવો અને યહોવા તમાંરી ભેટ સ્વીકારશે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“જે દિવસે તમે પૂળો ધરાવો તે દિવસે તમાંરે એક વર્ષનું ખોડખાંપણ વગરનું નર ઘેટું યહોવાને દહનાર્પણ તરીકે ધરાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","તેની ઉપરાંત તમાંરે અગ્નિમાં ખાદ્યાર્પણ તરીકે તેલમાં મોયેલો 16 વાટકા ઝીણો લોટ તથા પેયાર્પણ તરીકે એક લિટર દ્રાક્ષારસ લાવવો, એની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","તમે આ પ્રમાંણે અર્પણો ધરાવો નહિ ત્યાં સુધી એટલે કે તે પહેલા તમાંરે નવા પાકમાંથી કાંઈ ખાવું નહિ. તાજો પોંક, નવું અનાજ, કાચું શેકેલું કે રોટલી કે લીલાં કણસલાં, આમાંનું કશું જ ખાવું નહિ. આ નિયમ તમાંરે સૌએ સમગ્ર દેશમાં વંશપરંપરાગત પાળવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“પચાસમાં દિવસનું પર્વ: “વિશ્રામવાર પછીના દિવસથી તમે જે દિવસે પૂળાની ભેટ ધરાવો તે દિવસથી પૂરા સાત અઠવાડિયા ગણવાં. ");
INSERT INTO guj2009_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","સાતમાં આઠવાડિયા પછીના રવિવારે એટલે કે પચાસમાં દિવસે, તમાંરે યહોવાને નવા પાકમાંથી ખાદ્યાર્પણ કરવું: ");
INSERT INTO guj2009_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","તમાંરે તમાંરાં ઘરમાંથી વિશેષ ભેટ તરીકે ખમીર નાખીને બનાવેલી 16 વાટકા લોટની બે રોટલી લાવવી. એ તમાંરા પાકના પ્રથમ દાણાનું યહોવાને અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“રોટલી ઉપરાંત યહોવાને દહનાર્પણરૂપે તમાંરે એક વર્ષના ખોડખાંપણ વગરનાં સાત ઘેટાંના બચ્ચા, એક વાછરડું, અને બે ઘેટાં અર્પણ કરવા. આ સર્વને અનુરૂપ ખાદ્યાર્પણ અને પેયાર્પણ પણ હોવા જો ઈએ, જે અગ્નિમાં આહુતિ માંટેના અર્પણો છે. એની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","તમાંરે એક બકરો પાપાર્થાર્પણ તરીકે, અને શાંત્યર્પણ તરીકે એક વર્ષના બે નર ઘેટાં પણ ધરાવવા. ");
INSERT INTO guj2009_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“યાજકે તેમને નવા પાકના પહેલા દાણામાંથી બનાવેલી રોટલી સાથે યાજકના ભાગ તરીકે યહોવા સામે ઉપાસના સાથે ધરાવવા. એ યાજકને માંટેની યહોવાને ધરાવેલી ભેટ ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","એ જ દિવસે તમાંરે ધર્મસંમેલન બોલાવવું. અને તે દિવસે કોઈ સાંસારિક કામ કરવાં નહિ, તમે ગમે ત્યાં રહેતા હોય છતાં તમાંરા વંશજોએ કાયમ માંટે આ નિયમ પાળવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“તમે જયારે પાક લણો, ત્યારે તમાંરે છેક ખેતરના શેઢા સૂધી વાઢવું નહિ. તેમજ મોડ પણ વીણી લેવા નહિ. તમાંરે તેને ગરીબો તથા વિદેશીઓ માંટે રહેવા દેવા. હું તમાંરો દેવ યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ઇસ્રાએલના લોકોને એમ જણાવ: સાતમાં મહિનાના પહેલા દિવસે તમાંરે સંપૂર્ણ વિશ્રામના સ્મરણના દિવસ તરીકે પાળવો. ");
INSERT INTO guj2009_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","એ દિવસે તમાંરે રણશિંગડા ફૂંકવા અને ધર્મસંમેલન કરવું. તમાંરે રોજનું કોઈ કામ કરવું નહિ પરંતુ યહોવાની સમક્ષ અગ્નિમાં આહુતિ આપવી.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“સાતમાં મહિનાનો દશમો દિવસ પ્રાયશ્ચિતનો દિવસ છે. એ દિવસે પવિત્ર મેળાવડો રાખવો. ઉપવાસ કરવો અને યહોવા સમક્ષ અગ્નિમાં આહુતિ આપવી. ");
INSERT INTO guj2009_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","એ દિવસે તમાંરે કોઈ કામ કરવું નહિ, કારણ કે તે પ્રાયશ્ચિતનો દિવસ છે. તે દિવસે યાજકો તમાંરા દેવ યહોવા સમક્ષ તમને શુદ્ધ કરવાની વિધિ કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“એટલે તે દિવસે જો કોઈ પશ્ચાતાપમાં અને પાપ માંટે દિલગીરી વ્યક્ત કરી ઉપવાસ નહિ કરે તો તેનો સમાંજમાંથી બહિષ્કાર કરવો. ");
INSERT INTO guj2009_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","જે કોઈ આ દિવસે કોઈ પણ કામ કરશે તો હું (યહોવા) તેના લોકોમાંથી તેનો નાશ કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ઇસ્રાએલની પ્રજાએ આ કાનૂન વંશપરંપરા પાળવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","કારણ, આ તો પવિત્ર વિશ્રામનો સાબ્બાથ છે, માંટે તમે ઉપવાસ કરો અને દુઃખી થાઓ. પશ્ચાતાપના આ સમય દરમ્યાન નવમાં દિવસની સાંજથી પછીના દિવસની સાંજ સુધી તમાંરે વિશ્રામ પાળવાનો છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ઇસ્રાએલના લોકોને એમ કહે કે, આ સાતમાં મહિનાના પંદરમાં દિવસથી યહોવાનો માંડવાપર્વ શરૂ થાય છે અને તે સાત દિવસ ચાલે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","પ્રથમ દિવસે તમાંરે ધર્મસંમેલન ભરવું. તમાંરે એ દિવસે કોઈ કાર્ય કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","પર્વના સાતે દિવસ તમાંરે યહોવા સમક્ષ હોમયજ્ઞો અર્પણ કરવા. આઠમાં દિવસે ફરીથી પવિત્ર મેળાવડો કરવો અને ફરીથી હોમયજ્ઞો અર્પણ કરવા. આ પછી પર્વની ઊજવણી પૂરી થાય, આ દિવસે પણ તમાંરે કોઈ પણ સાંસારિક કામ કરવાં નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“આ બધા યહોવાના વાર્ષિક પર્વો નિયમિત ઉજવવાના છે. આ પ્રસંગો પર પવિત્ર મેળાવડા યોજવા, એ દિવસો દરમ્યાન નક્કી કરેલા નિયમ મુજબ દહનાર્પણ, ખાદ્યાર્પણ અને પેયાર્પણ યહોવાને અર્પણ કરવા. ");
INSERT INTO guj2009_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","આ પર્વોત્સવો પ્રતિસપ્તાહ આવતા વિશ્રામવાર ઉપરાંતના છે અને બધી આહુતિઓ, અર્પણો બાધાઓ, અને સ્વેચ્છાએ ખાસ ભેટો તરીકે ધરાવેલ અર્પણો ઉપરાંતના છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“તેમ છતાં સાતમાં માંસના પંદરમાં દિવસે જમીનની ઉપજનો સંગ્રહ કરી રહ્યાં બાદ તમાંરે યહોવાને પ્રસન્ન કરવા માંટે સાત દિવસ સુધી આ પર્વ ઊજવવું. પહેલો દિવસ અને આઠમો દિવસ સંપૂર્ણ વિશ્રામ પાળવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","પ્રથમ દિવસે તમાંરે તાડનાં પાંદડાં અને ખાસફળો અને સુદંર વૃક્ષોની ડાળીઓ ભેગી કરવી અને સાત દિવસ સુધી તમાંરા દેવ યહોવા સમક્ષ આનંદોત્સવ ઊજવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","તમાંરે પ્રતિવર્ષ યહોવાના માંનમાં સાત દિવસ આ ઉત્સવ ઊજવવો. તમાંરા વંશજોએ કાયમ આ કાનૂન પાળવાનો છે. સાતમાં મહિનામાં તમાંરે આ ઉત્સવ ઊજવવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","એ સાત દિવસો દરમ્યાન ઇસ્રાએલના તમાંમ વતનીઓએ સાત દિવસ મંડપોમાં રહેવું. ");
INSERT INTO guj2009_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","જેથી તમાંરા વંશજોને યાદ રહે કે હું તમને ઇસ્રાએલીઓને મિસરમાંથી બહાર લઈ આવ્યો ત્યારે મેં તમને માંડવાઓમાં વસાવ્યા હતા. હું યહોવા તમાંરો દેવ છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","મૂસાએ યહોવાના માંનમાં પાળવાના ઉત્સવોને લગતા નિયમો ઇસ્રાએલના તમાંમ લોકોને જણાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ઇસ્રાએલના લોકોને કહે કે, તેઓ મુલાકાતમંડપમાં કરાર કોશની આગળના પડદા બહારની દીવીમાં અખંડ દીપ પ્રગટતો રાખવા માંટે ચોખ્ખું જૈતૂનનું તેલ લાવી આપે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","હારુને તે દીપ સાંજથી સવાર સુધી યહોવા સમક્ષ પ્રગટતો રહે તેની કાળજી રાખવાની છે. આ કાનૂન તમને અને તમાંરા વંશજોને કાયમ માંટે બંધનકર્તા છે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","હારુને શુદ્ધ સોનાની દીવી ઉપરના દીવા યહોવા સમક્ષ અંખડ પ્રગટતા રહે તે માંટે કાળજી રાખવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“તમાંરે ઘઉનો લોટ લઈને તેમાંથી 16 વાટકાનો એક એવા બાર રોટલી બનાવવી. ");
INSERT INTO guj2009_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","તમાંરે તે બાર રોટલા શુદ્ધ સોનાના બાજઠ ઉપર યહોવા સમક્ષ છ છની બે થપ્પીમાં ગોઠવવા. ");
INSERT INTO guj2009_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","તે બંને થપ્પી પર તમાંરે શુદ્ધ લોબાન મૂકવો, આથી યહોવાને પોતાની સમક્ષ અગ્નિ આહુતીનું અર્પણ યાદ રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","પ્રતિ વિશ્રામવારે તે યહોવા સમક્ષ નિયમિત ગોઠવવા. તે ઇસ્રાએલી લોકોનું કાયમી કામ છે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","પવિત્ર જગાએ હારુન અને તેના પુત્રો આ રોટલી ખાય. એ એમનો હક છે. કારણ, તે યહોવાને ચઢાવાતા અગ્નિ ખાદ્યાર્પણોનો યાજકને મળતો પવિત્ર ભાગ છે. યાજકને આ ભાગ હંમેશા આપવાના છે.” ");
INSERT INTO guj2009_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","એક દિવસ ઇસ્રાએલી માંતા અને મિસરી પિતાના યુવાનને છાવણીમાં એક ઇસ્રાએલી વ્યક્તિ સાથે ઝધડો થયો. ");
INSERT INTO guj2009_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ઝધડા દરમ્યાન આ ઇસ્રાએલી યુવતીના દીકરાએ યહોવાને શાપ આપ્યો. તેથી ન્યાય માંટે મૂસા સમક્ષ રજૂ કરવામાં આવ્યો. તેની માંતાનું નામ શલોમીથ હતું, તે દાનના કુળના દિબ્રીની પુત્રી હતી. ");
INSERT INTO guj2009_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","યહોવાનો ચૂકાદો ના આવે ત્યાં સુધી તેને ચોકી પહેરા હેઠળ રાખવાનું નક્કી થયું. ");
INSERT INTO guj2009_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“તેને છાવણીમાંથી બહાર લઈ જા અને જેઓને તેને નિંદા કરતા સાંભળ્યો હતો તે સર્વને તેના માંથા પર હાથ મૂકવાનું કહે; પછી બધા લોકો પથ્થરો માંરી તેને માંરી નાખે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ત્યારબાદ તું ઇસ્રાએલીઓને કહે કે, જે કોઈ દેવની નિંદા કરશે તેણે પોતાના પાપની સજા ભોગવવી પડશે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","જે કોઈ યહોવાના નામની નિંદા કરે તેને મૃત્યુદંડ આપવો, પછી તે ઇસ્રાએલી હોય કે વિદેશી; સમગ્ર સમાંજે તેને પથ્થરો માંરવા; અને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“જે કોઈ વ્યક્તિ બીજાની હત્યા કરે તો તેને મોતની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","જે કોઈ પશુને માંરી નાખે તેણે તેની નુકસાની ભરપાઈ કરવી જીવને બદલે જીવ. ");
INSERT INTO guj2009_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“જો કોઈ વ્યક્તિ અન્યને ઈજા પહોંચાડે તો તેણે જે કર્યુ હોય તે તેને કરવું: ");
INSERT INTO guj2009_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","હાડફું ભાંગનારનું હાડફું ભાંગવું, આંખ ફોડનારની આંખ ફોડવી, દાંત પાડનારનો દાંત પાડવો, એણે સામી વ્યક્તિને જેવી ઈજા કરી હોય તેવી જ ઈજા તેને કરીને બદલો આપવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","જે કોઈ વ્યક્તિ કોઈ પશુને માંરી નાખે તો તેણે નુકસાની ભરપાઈ કરવી, પણ જો કોઈ માંણસને માંરી નાખે તો તેને મૃત્યુદંડ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“વિદેશી કે ઇસ્રાએલી પ્રજામાં જન્મ ધારણ કરનાર નાગરિક સર્વને સમાંન કાનૂન લાગુ પડે, કારણ હું યહોવા તમાંરો દેવ છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","મૂસાએ ઇસ્રાએલીઓને આ પ્રમાંણે કહ્યા પછી તેમણે દેવનિંદા કરનાર માંણસને છાવણી બહાર લઈ જઈને યહોવાએ મૂસાને કરેલી આજ્ઞા પ્રમાંણે તેને પથ્થરો માંરીને માંરી નાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","સિનાઈ પર્વત પર યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“તું ઇસ્રાએલી લોકોને આ પ્રમાંણે કહે: તમને જે દેશ હું આપવાનો છું તેમાં તમે પ્રવેશ કરો અને વસો ત્યારે તે દેશને પણ યહોવાના માંનમાં વિશ્રામ પાળવા દેવો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","છ વર્ષ સુધી તમાંરે તમાંરા ખેતરોમાં વાવણી કરવી, છ વરસ સુધી તમાંરે દ્રાક્ષની વાડીઓને છાંટવી, અને તમાંરી પાકની કાપણી કરવી, ");
INSERT INTO guj2009_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","પરંતુ સાતમે વર્ષે જમીનને યહોવાના માંનમાં સંપૂર્ણ વિશ્રામ પાળવા દેવો. એ વર્ષે ન તો ખેતરમાં કંઈ વાવવું કે ન તો દ્રાક્ષની વાડીઓ છાંટવી. ");
INSERT INTO guj2009_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","જમીન પર પડેલા દાણામાંથી જે કંઈ પાકે અથવા છાંટયા વગરની દ્રાક્ષની વાડીઓમાં જે દ્રાક્ષ બેસે તે તમાંરે લેવાં નહિ, એ વર્ષે જમીનને સંપૂર્ણ વિશ્રામ આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“એ વિશ્રામના વર્ષમાં ખેડયા વગરની જમીનમાં આપોઆપ જે કંઈ ઊપજ થશે તે તમને તેમજ તમાંરાં સ્ત્રીપુરુષ, ચાકરોને, તમે મજૂરીએ રાખેલા માંણસોને, તમાંરા ઘરમાં રહેતા વિદેશીઓને, ");
INSERT INTO guj2009_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","તમાંરાં ઢોરોને તથા દેશના જંગલી જાનવરોને ખાવા કામ લાગશે, તેથી જે કંઈ આપોઆપ પેદા થાય તેનો ખાવામાં ઉપયોગ કરી શકશો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“તમાંરે પોતાના માંટે સાત વર્ષનાં સાત જૂથ ગણવાં, એટલે કે સાત વાર સાત વરસ, એટલે 49 વર્ષ. તે સમય દરમ્યાન ભૂમિને સાત વરસનો વિશ્રામ રહેશે ");
INSERT INTO guj2009_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","પછી સાતમાં મહિનાના દશમે દિવસે પ્રાયશ્ચિતને દિવસે તમાંરે આખા દેશમાં ઘેટાનું શિંગ વગડાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","અને પચાસમાં વર્ષને પવિત્ર જાહેર કરી દેશના બધા વતનીઓ માંટે ઘોષણા કરવી. તમાંરા માંટે એ રણ શિંગડાનું જુબિલીનું વર્ષ છે. જો કોઈની મિલકત વેચાઈ ગઈ હોય તો એ વર્ષે છૂટી થઈ જાય અને મૂળ માંલિકને પાછી મળે, વળી જો કોઈ ચાકર તરીકે વેચાયો હોય તો તે છૂટો થઈ પોતાના પરિવારમાં પાછો જાય. ");
INSERT INTO guj2009_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","એ પચાસમું વર્ષ તમાંરા માંટે ખાસ ઉજવણીનું વર્ષ છે, એ વર્ષે તમાંરે કાંઈ વાવવું નહિ, અને આપોઆપ જે ઊગ્યું હોય તે લણવું નહિ, તેમજ છાંટયા વિનાની દ્રાક્ષની વાડીમાંથી દ્રાક્ષ ઉતારવી નહિ, ");
INSERT INTO guj2009_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","કારણ, તમાંરા માંટે એ રણશિંગડાનું પવિત્ર મુક્તિવર્ષ છે, અને તમાંરે તેને પવિત્ર રાખવાનું છે એટલે એ વર્ષે ખેતરોમાં આપમેળે ઊગી નીકળેલો પાક તમાંરે ખાવાના ઉપયોગમાં લેવો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","આ મુક્તિ વર્ષે પ્રત્યેક વ્યક્તિએ પોતાને ઘેર, પોતાના પરિવારની મિલકતવાળા મકાનમાં પાછા ફરવું, જો તેણે તે વેચી દીધું હોય, તો તે ફરીથી તેને પ્રાપ્ત થશે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“એટલે તમે અરસપરસ જમીન વેંચો કે ખરીદો ત્યારે કોઈ પણ પક્ષે એક બીજાને છેતરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","જમીનની કિંમત ઉત્સવના પછીના વર્ષોની ગણતરી પર થાય છે, કેમકે માંલિક ફકત આવતા ઉત્સવ સુધીનો કાપણીનો હક્ક વેચે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","જો વર્ષો વધારે બાકી હોય તો કિંમત વધારે ઠરાવવી અને વર્ષ ઓછા બાકી હોય તો કિમત ઓછી ઠરાવવી, કારણ જે વેચાય છે તે અમુક પાક કુલ મળશે તે છે, અને નહિ કે જમીન. ");
INSERT INTO guj2009_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","આથી તમાંરે એકબીજાને છેતરવા નહિ, દેવથી ડરીને ચાલવું. હું તમાંરો દેવ યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“માંરા કાનૂનો અને માંરા નિયમોનું પાલન કરશો અને તેનો અમલ કરશો તો તમે દેશમાં સુરક્ષિત રહી શકશો; ");
INSERT INTO guj2009_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","જો તમે નિયમોને આધીન થશો તો ભૂમિ મબલખ પાક આપશે તેથી તમે સુરક્ષિત રહેશો અને તૃપ્ત થશો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“તમે કહેશો કે, ‘જો અમે દાણા ન વાવીએ અથવા લણીએ તો સાતમાં વર્ષે અમને કંઈ ખાવા નહિ રહે.’ ");
INSERT INTO guj2009_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","તેનો ઉત્તર આ છે, છઠ્ઠા વર્ષે હું તમને ત્રણ વર્ષ ચાલે તેટલા મબલખ પાકથી આશીર્વાદિત કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","તમે આઠમે વરસે વાવશો ત્યારે પણ તમે આગળના વર્ષના પાકમાંથી ખાતા હશો, નવમે વર્ષે તમે નવો પાક ઘરમાં લાવશો ત્યાં સુધી તમે છઠ્ઠા વર્ષના પાકમાંથી તમે ખાશો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“યાદ રાખો, જમીન માંરી છે, તેથી જમીનનું કાયમી વેચાણ થઈ શકે નહિ, તમે માંત્ર વિદેશીઓ અને યાત્રીઓ તરીકે માંરી જમીન પર રહો છો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","વેચાણ ખરીદમાં એક શરત એવી હોવી જ જોઈએ કે જમીનને વેચનાર ગમે ત્યારે પાછી મેળવી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","કોઈ વાર કોઈ માંણસ ગરીબ થઈ જાય અને તેની જમીનને થોડો ભાગ વેચે, તો તેનો સૌથી નજીકનો સગો તે જમીનને પાછી લઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","પરંતુ જો તેને છોડાવનાર કોઈ નજીકનો સગો ના હોય અને તે પોતે ફરી ખરીદવાની સ્થિતિમાં આવ્યો હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","તો તેણે વેચાણ પછી વીતેલાં વર્ષો હિસાબમાં ગણી, બીજા મુક્તિવર્ષને જેટલાં વર્ષ બાકી હોય તે પ્રમાંણે ખરીદનારને કિંમત ચૂકવવી, અને તેણે એની મિલકત પાછી આપવી. ");
INSERT INTO guj2009_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","અસલ માંલિક જમીનને ન છોડાવી શકે તો તે જમીન જુબિલીના વર્ષ સુધી ખરીદનાર પાસે રહે; પણ જુબિલી વર્ષમાં તે જમીન અસલ માંલિકને પાછી આપી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“જો કોઈ માંણસ નગરમાંનું તેનું મકાન વેચે, તો વેચાણ પછી પૂરા એક વર્ષ સૂધી તેને ફરીથી ખરીદી લેવાનો હક્ક રહે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","એક પૂરા વર્ષ દરમ્યાન તે પાછું ખરીદી લેવામાં ના આવે તો તે મકાનની કાયમની માંલિકી નવા માંલિકની અને તેના વંશજોની થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","જુબિલી વર્ષમાં પણ તે મૂળ માંલિકને પાછું ન મળે, કોટ વગરનાં ગામડાંમાંનાં મકાનો જમીન જેવાં ગણાય, તે પાછાં ખરીદી લેવાના હક્ક કાયમ રહે, અને જુબિલી વર્ષમાં તો તે મકાન મૂળ માંલિકને પાછું મળે જ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“તેમાં એક અપવાદ છે: લેવીના મકાનો કોટવાળાં નગરોમાં હોય તો પણ ગમે ત્યારે છોડાવી શકાય; ");
INSERT INTO guj2009_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","જો કોઈ લેવી એવા શહેરમાં આવેલું પોતાનું મકાન પાછું ન ખરીદી લે, તો તે જુબિલીના વર્ષમાં તેને પાછું મળી જાય; કારણ, લેવીઓનાં શહેરમાંનાં મકાન એ તેમની ઇસ્રાએલમાંની મિલકત છે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","લેવી પોતાના નગરોની આસપાસ આવેલી સહિયારી જમીન વેચી શકે નહિ, કારણ કે તે તેઓની કાયમી મિલકત છે અને તેના પર અન્ય કોઈનો હક રહે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“અને જો કોઈ ઇસ્રાએલી બંધુ ગરીબીમાં આવી પડે અને પોતાનું ભરણપોષણ કરી શકે નહિ, તો તેને મદદ કરવાની જવાબદારી તારી છે; તારે ઘેર મહેમાંન તરીકે આવવા માંટે તેને નિમંત્રણ આપ. જેથી તે તમાંરી સાથે રહી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","દેવનો ડર રાખીને તારા ભાઈને તારી સાથે રહેવા દે; તેને ધીરેલા પૈસાનું વ્યાજ તમાંરે ન લેવું, અને તમે ધીરેલા કરતા વધારાની આશા તેની પાસે ન કરતા. ");
INSERT INTO guj2009_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","તમાંરે તેને ધીરેલાં નાણાં ઉપર વ્યાજ લેવું નહિ, તેમજ વધારે ભાવે અનાજ વેચવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","તમને કનાનનો પ્રદેશ આપવા માંટે અને તમાંરો દેવ થવા માંટે તમને મિસરમાંથી બહાર લાવનાર હું તમાંરો દેવ યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“જો કોઈ ઇસ્રાએલી બંધુ ગરીબાઈમાં આવી પડે અને પોતે તમને વેચાઈ જાય તો તમાંરે તેની પાસે ચાકર તરીકે કામ કરાવવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","તેણે નોકરીએ રાખેલ ચાકર અથવા મહેમાંન તરીકેનો વ્યવહાર તેની સાથે કરવો. અને તેને વસવાટી માંણસ જેવો ગણવો. જુબિલી વર્ષ સુધી તે તમાંરું કામ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","પછી તમાંરી સેવા તે છોડી જશે અને પોતાનાં વંશજો સાથે પાછો પોતાના પરિવારમાં જઈ પોતાની મિલકતનો માંલિક બનશે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","કારણ કે હું ઇસ્રાએલીઓને મિસરમાંથી બહાર લાવ્યો હતો એટલે તેઓ માંરા સેવકો છે. ચાકરોની જેમ તેમને વેચી શકાશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","તમાંરે દેવનો ડર રાખીને એવા માંણસ પાસે ચાકરની જેમ મજૂરી કરાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“અને જો તમાંરે ચાકરોની જરૂર હોય તો તે તમાંરી આસપાસ રહેતા લોકોમાંથી તમે ખરીદી શકો છો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","તદુપરાંત તમાંરી વચ્ચે રહેતા વિદેશીઓના સંતાનોને તમાંરા દેશમાં જન્મ્યા હોય તો પણ તમે ચાકરો ખરીદી શકો છો. એ લોકો તમાંરી મિલકત ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","અને તમે તે લોકોને તમાંરા વંશજોને વારસામાં આપી શકો છો, તેમજ તમે તેમનો કાયમ માંટે ચાકર તરીકે ઉપયોગ કરી શકો છો, પણ તમાંરા ઇસ્રાએલી ભાઈઓ પાસે ચાકરોની જેમ મજૂરી કરાવી શકો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“જયારે કોઈ પરદેશી કે તમાંરી સાથે રહેતો વસવાટી ધનવાન થઈ જાય અને તમાંરો ઇસ્રાએલી ભાઈ ગરીબીમાં આવી પડતાં પોતાની જાત તે માંણસને વેચી દે, ");
INSERT INTO guj2009_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","તેને તેનો એકાદ ભાઈ પાછો ખરીદી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","અથવા કાકા કે ભત્રીજે કે અન્ય કોઈ નજીકનો સગો તેને પાછો ખરીદી લઈ શકે, અથવા તેની પાસે પૈસા થયા હોય, તો તે પોતે પોતાની જાતને છોડાવી શકે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“તેના છુટકારાની કિંમત જુબિલી વર્ષને જેટલા વર્ષ બાકી હોય તે પ્રમાંણે ગણવામાં આવે, બાકી રહેલાં વર્ષો માંટે પગારે રાખેલા ચાકરનો ખર્ચ કેટલો થાય તે, ");
INSERT INTO guj2009_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","જો આગલી જુબિલીને ઘણા વર્ષો બાકી હોય તો વ્યક્તિએ કિંમતનો મોટો ભાગ પાછો આપવો. એ વર્ષોની ગણતરી પર આધારીત છે. ");
INSERT INTO guj2009_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ઘણાં વર્ષો વીતી ગયાં હોય અને જુબિલી વર્ષને થોડાં જ વર્ષ બાકી હોય, તો પોતાની જાતને વેચી જે નાણાં પ્રાપ્ત કર્યા હોય તેનો થોડોજ ભાગ તેણે પાછો આપવો. ");
INSERT INTO guj2009_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","તેનો હોદ્દો મજૂરીએ રાખેલા માંણસનો ગણાશે, અને તમાંરે તેના માંલિકને તેની પાસે સખતાઈથી કામ લેવા દેવું જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“જો જુબિલી વર્ષના વચગાળાનાં વરસો દરમ્યાન તેને પાછો ખરીદી લેવામાં ન આવ્યો હોય, તો તેને અને તેનાં બાળકોને જુબિલીના વર્ષમાં છૂટાં કરી દેવાં જોઈએ, ");
INSERT INTO guj2009_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","કેમ કે, ઇસ્રાએલીઓ માંરા સેવકો છે; હું તેમને ચાકરીમાંથી મિસર દેશમાંથી બહાર લઈ આવ્યો છું; હું યહોવા તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“તમાંરે પૂજા કરવા માંટે દેવોની મૂર્તિઓ બનાવવી નહિ, તેમજ કોતરેલી મૂર્તિ, સ્તંભ કે કંડારેલા પથ્થરની પૂજા કરવી નહિ, કારણ ‘હું યહોવા તમાંરો દેવ છું.’ ");
INSERT INTO guj2009_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“તમાંરે માંરા વિશ્રામવાર પાળવા અને માંરા મુલાકાતમંડપની પવિત્રતા જાળવવી, હું યહોવા છું. ");
INSERT INTO guj2009_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“જો તમે માંરા સર્વ કાનૂનો પ્રમાંણે ચાલશો અને માંરી સર્વ આજ્ઞાઓનું પાલન કરીને તેનો અમલ કરશો; ");
INSERT INTO guj2009_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","તો હું તમાંરા માંટે નિયમિત ઋતુ પ્રમાંણે વરસાદ મોકલીશ, જમીન તમને પાક આપશે અને વૃક્ષો ફળ આપશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","તમાંરે ત્યાં પુષ્કળ પાક ઊતરશે, વાવણીનો સમય આવે ત્યાં સુધી દ્રાક્ષ પાકયા કરશે, અને લણવાનું કામ વાવણીના સમય સુધી ચાલશે, તમે ધરાતાં સુધી જમશો અને દેશમાં સુરક્ષિત રહેશો. ");
INSERT INTO guj2009_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","હું તમને દેશમાં શાંતિ આપીશ, અને તમે રાત્રે નિર્ભય બની નિરાંતે ઊધી શકશો, હું દેશમાંથી હિંસક પ્રાણીઓને ભગાડી મૂકીશ અને યુદ્ધ થવા દઈશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“તમે તમાંરા દુશ્મનોને હાંકી કાઢશો, અને તેઓ તમાંરી તરવારનો ભોગ બનશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","તમાંરામાંના પાંચ એકસોને હાંકી કાઢશે અને તમાંરામાંના 100 હાંકશે 10,000ને! તમાંરા સર્વ શત્રુઓનો પરાજય થશે અને તમાંરી તરવારથી માંર્યા જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“હું તમાંરા તરફ થઈશ, તમાંરી સંભાળ રાખીશ, અને તમાંરું સંખ્યાબળ વધારીશ. તમને ઘણાં સંતાન આપીશ, અને તમાંરી સાથેનો માંરો કરાર હું પૂર્ણ કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","તમાંરી પાસે પુષ્કળ અનાજ હશે, આખું વરસ ખાવા છંતા તે ખૂટશે નહિ. નવો પાક તૈયાર થશે ત્યારે તેને સંધરવા જૂના પાકનો વધેલો ભાગ ફેંકી દેવો પડશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","હું તમાંરી વચ્ચે માંરું નિવાસ કરીશ. હું તમાંરો ત્યાગ કરીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","હું તમાંરી મધ્યે વાસો કરીશ. હું તમાંરો દેવ થઈશ અને તમે માંરી પ્રજા થશો. ");
INSERT INTO guj2009_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","કારણ કે તમને ચાકરીમાંથી છોડાવી મિસરની બહાર લાવનાર હું તમાંરો દેવ યહોવા છું. તમાંરી ચાકરીની ઝૂસરી તોડી નાખીને તમને ઉન્નત મસ્તકે ચાલતા મેં કર્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“પરંતુ જો તમે માંરું કહ્યું સાંભળશો નહિ અને માંરી આજ્ઞાઓનું ઉલંઘન કરશો, ");
INSERT INTO guj2009_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","તથા માંરા કાનૂનોને ફગાવી દેશો, માંરા કાયદાઓની ઉપેક્ષા કરશો અને માંરી પ્રત્યેક આજ્ઞાનું પાલન ન કરીને માંરા કરારનો ભંગ કરશો, ");
INSERT INTO guj2009_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","તો હું તમને આ પ્રમાંણે સજા કરીશ: હું તમાંરા પર અત્યંત ત્રાસ વર્તાવીશ. હું તમાંરા પર એવા રોગો અને જવર મોકલીશ કે જે તમને અંધ બનાવી દેશે, અને તમાંરા જીવનનો નિકાસ કરી નાખશે. તમે વાવશો દાણા છતાં તમાંરો પાક જમી શકશો નહિ, કારણ કે તે તમાંરો શત્રુ જમશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","હું તમાંરી વિરુદ્ધ થઈ જઈશ અને તમાંરો પરાજય તમાંરા દુશ્મનોને હાથે હું કરાવીશ તમાંરા શત્રુઓ તમાંરા પર રાજ કરશે, અને કોઈ તમાંરી પાછળ નહિ પડયું હોય છતાં તમે ભાગતા ફરશો. ");
INSERT INTO guj2009_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“આટલી મુશ્કેલીઓ પડવા છતાં તમે જો માંરું કહ્યું નહિ માંનો, તો હું તમને તમાંરા પાપો બદલ સાત ગણી વધુ શિક્ષા કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","હું તમાંરું શક્તિનું અભિમાંન ઉતારી નાખીશ, તમાંરા આકાશને લોખંડના તવા જેવું બનાવીશ જેથી એક ટીપું ય વરસાદ પડશે નહિ, અને તમાંરી જમીનને પિત્તળ જેવી સૂકી ભઠ્ઠ બનાવી દઈશ; ");
INSERT INTO guj2009_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","તમાંરી મહેનત વ્યર્થ જશે. તમાંરી જમીનમાં કશુંય પાકશે નહિ અને તમાંરાં વૃક્ષોને ફળ પણ આવશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“અને તે છતાંય તમે માંરી આજ્ઞાની વિરુદ્ધ વર્તન કરવાનું ચાલુ રાખશો અને માંરું નહિ સાંભળો તો હું તમાંરાં પાપોને કારણે સાતગણી વધુ આફતો ઉતારીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","પછી હું તમાંરા ઉપર જંગલી જાનવરો છોડી મૂકીશ, જે તમાંરાં બાળકોને માંરી નાખશે અને તમાંરાં પશુઓનો નાશ કરશે, પરિણામે તમાંરી સંખ્યા ઘટી જતા તમાંરા રસ્તાઓ ઉજજડ થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“આમ છતાં પણ જો તમાંરું પરિવર્તન નહિ થાય અને તમે નહિ સુધરો અને માંરી વિરુદ્ધ વર્તન કરવાનું ચાલુ રાખશો; ");
INSERT INTO guj2009_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","તો હું તમાંરી વિરુદ્ધ થઈશ, અને હું પોતે તમને તમાંરાં પાપો માંટે સાતગણી વધુ આકરી સજા કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","માંરા કરાર ભંગનો બદલો લેવા હું તમાંરા ઉપર યુદ્ધ મોકલીશ. તમે તમાંરાં નગરોમાં અદૃશ્ય થઈ જશો તો હું ત્યાં તમાંરી મધ્યે મરકી મોકલીશ; તમાંરે તમાંરા શત્રુઓને શરણે જવું પડશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","હું તારા અનાજના પૂરવઠાનો નાશ કરીશ જેથી દશ પરિવારો માંટે રોટલી શેકવા માંટે ફકત એક ભઠ્ઠી પૂરતી થઈ પડશે; તેઓ તમને માંપી તોલીને રોટલી વહેંચશે, અને તમાંરું પેટ નહિ ભરાતા તમે ભૂખ્યાં જ રહેશો. ");
INSERT INTO guj2009_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“આટઆટલું વીતવા છતાંય તમે માંરું નહિ સાંભળો અને માંરી સામે થશો, ");
INSERT INTO guj2009_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","તો હું પણ ક્રોધે ભરાઈને તમાંરી સામે પડીશ અને તમાંરાં પાપોની સાતગણી મોટી શિક્ષા તમને કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","તમાંરે તમાંરા પુત્ર અને પુત્રીઓનું માંસ જમવાનો સમય આવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","હું તમે જયાં તમાંરી મૂર્તિઓની પૂજા કરો છો તે ટેકરીઓ ઉપરનાં મુલાકાતમંડપનો નાશ કરીશ અને તમાંરી મૂર્તિઓના ભંગાર ઉપર હું તમાંરાં મૃતદેહો ખડકીશ. હું તમને તિરસ્કૃત કરી નાખીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","હું તમાંરા નગરોને વેરાન ખંડેર બનાવી દઈશ. તમાંરાં પવિત્ર સ્થાનોનો વિનાશ કરીશ, અને તમાંરાં સુવાસિત અર્પણોનો અસ્વીકાર કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","હું તમાંરા દેશને એવો તારાજ કરી નાખીશ કે તમાંરા દુશ્મનો જે તેમાં વસશે તેઓ પણ તમાંરી દુર્દશા જોઈને આભા બની જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","હું તમને અનેક દેશોમાં વેરવિખેર કરી નીખીશ, હું તરવાર લઈને તમાંરી પાછળ પડીશ અને તમાંરો દેશ ઉજજડ વેરાન થઈ જશે, અને તમાંરાં શહેરો ખંડેર થઈ જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“અને જયારે તમે દુશ્મનોના પ્રદેશમાં રહેતા હશો તે વર્ષોમાં જમીન ઉજજડ પડી રહેશે, અને તે તેનો વિશ્રામવાર ભોગવશે અને તેના વિશ્રામ વર્ષોના આનંદ માંણશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","જયારે તમે ત્યાં વસતા હતા ત્યારે દરેક સાતમે વર્ષે તમે આપ્યો ન્હોતો તે વિશ્રામ હવે તે પ્રાપ્ત કરશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","જે લોકો તમાંરામાંથી બચી જઈને દુશ્મનોના દેશમાં દેશવટો ભોગવી રહ્યા હશે તેમને હું એવા ભયભીત કરીશ કે એક પાંદડુ પડવાનો અવાજ થતાં તેઓ જાણે મોત પાછળ પડયું હોય તેમ ભાગવા માંડશે, ને કોઈ પાછળ પડયું ના હોવા છતાં તેઓ ભોંય પર ઢળી પડશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","વળી કોઈ પાછળ પડયું ના હોવા છતાં યુદ્ધમાંથી મૂઠીવાળીને ભાગતા હોય તેમ તેઓ ભાગતાં એકબીજા સાથે ભટકાઈને, ઠોકરો ખાઈને પડશે અને શત્રુઓનો સામનો કરવાની શક્તિ પણ તેઓનામાં રહેશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","“વિદેશી પ્રજાઓ વચ્ચે તમાંરો અંત આવશે અને તમાંરા દુશ્મનોની ભૂમિ તમને ગળી જશે, અને તમે મૃત્યુ પામશો. ");
INSERT INTO guj2009_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","જેઓ દુશ્મનોના દેશમાં બચી જશે તેઓ પોતાના અને પોતાના પિતૃઓનાં પાપોને કારણે ઝૂરી ઝૂરીને ક્ષય પામતા જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“પરંતુ કદાચ તેઓ પોતાનાં અને પોતાના પિતૃઓનાં પાપો કબૂલ કરશે, મને વિશ્વાસઘાત કરીને માંરી વિરુદ્ધ પડીને તેમણે જે પાપો કર્યા છે તે કબૂલ કરશે, ");
INSERT INTO guj2009_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","તેઓના પાપોએ મને તે લોકોની વિરુદ્ધ કર્યો, તેથી મેં તેઓને વિદેશી પ્રજાઓમાં દેશનિકાલ કર્યા. છેલ્લે તમાંરા વંશજો નમ્ર થશે અને માંરી વિરુદ્ધ આચરેલા પાપ અને બંડને કારણે થયેલી શિક્ષા ભોગવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ત્યારે હું યાકૂબ સાથેનો ઈસહાક સાથેનો અને ઈબ્રાહિમ સાથેનો માંરો કરાર અને આ ભૂમિને સંભારીશ. ");
INSERT INTO guj2009_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“કારણ કે ભૂમિ જયાં સુધી ઉજજડ પડી રહેશે તેટલો સમય તે પોતાના સાબ્બાથો વિશ્રામના વર્ષો માંણશે, પરંતુ માંરી આજ્ઞાઓના ઉલ્લંઘન કર્યા બદલ અને માંરા નિયમોને ધિક્કારવાના કારણે જ તેઓ ઉપર આ ભારી શિક્ષા આવી પડી છે તેનું તેઓને ભાન થશે, અને તેઓ પૂરેપૂરી સજા ભોગવશે. ");
INSERT INTO guj2009_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","છતાં, તેઓ તેમના દુશ્મનોના દેશમાં હશે ત્યારે પણ હું તેમનો સંપૂર્ણ નાશ નહિ કરું. તેમનો પૂરેપૂરો ત્યાગ પણ નહિ કરું અને માંરો જે કરાર તેઓની સાથે છે તેનો ભંગ કરીશ નહિ, કારણ કે હું યહોવા તેમનો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","તેઓના પિતૃઓને તેમનો દેવ થવા માંટે હું બીજા દેશોના જોતા જ મિસરમાંથી બહાર લઈ આવ્યો હતો અને તેમની સાથે જે કરાર કર્યો હતો તે સંભારીને તેમનું કલ્યાણ કરીશ. હું યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","યહોવાએ સિનાઈ પર્વત પર મૂસા માંરફતે ઇસ્રાએલીઓને આપેલા કાનૂનો, નિયમો અને ઉપદેશો ઉપર પ્રમાંણે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ઇસ્રાએલ પુત્રોને આ કહે, જો કોઈ માંણસ યહોવાને ખાસ પ્રતિજ્ઞા કરે કે તે કોઈ બીજા વ્યક્તિને દેવને અર્પણ કરશે, તો યાજકે તે માંણસની કિંમત ઠરાવવી જેથી બીજુ કોઈ તેને દેવ પાસેથી પાછો ખરીદી શકે. તે વ્યક્તિની કિંમત નીચે જણાવ્યા મુજબ નક્કી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","વીસથી તે સાઠ વર્ષ સુધીની ઉમરના પુરુષની કિંમત મુલાકાતમંડપના ધોરણ અનુસાર 50 શેકેલ ચાંદી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","વીસથી તે સાઠ વર્ષ સુધીની સ્ત્રી હોય તો 30 શેકેલ ચાંદી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","પાંચથી વીસ વર્ષની ઉમરના છોકરાની કિંમત 20 શેકેલ અને છોકરીની કિંમત 10 શેકેલ. ");
INSERT INTO guj2009_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","એક મહિનાથી 5 વર્ષ સુધીના છોકરાની કિંમત 5 શેકેલ અને છોકરીની કિંમત 3 શેકેલ. ");
INSERT INTO guj2009_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","સાઠ અને ઉપરની ઉમરના પુરુષની કિંમત 15 શેકેલ; સ્ત્રીની કિંમત 10 શેકેલ ચુકવે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“પણ જો કોઈ વ્યક્તિ આ કિંમત ચુકવી શકે તેમ ના હોય, તો તેણે તે વ્યક્તિને યાજક સમક્ષ રજૂ કરવી અને યાજકે તેની કિંમત પ્રતિજ્ઞા લેનાર વ્યક્તિ ચૂકવી શકે તેટલી નક્કી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“જો યહોવાને ધરાવી શકાય એવું કોઈ પ્રાણી અર્પણ કરવાની પ્રતિજ્ઞા લીધી હોય તો તે અર્પણ થનાર પ્રાણી પવિત્ર બની જશે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","પ્રતિજ્ઞા બદલી શકાય નહિ, તે પ્રાણીની બીજા પ્રાણી સાથે અદલાબદલી થઈ શકે નહિ સારાને બદલે ખરાબ અને ખરાબને બદલે સારું તેવો ફેરફાર કરી શકાય નહિ. છતાં જો અદલાબદલી કરી હોય તો બંને પશુઓ પવિત્ર બની જાય અને યહોવાના થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“પરંતુ પ્રતિજ્ઞા લઈ અર્પણ કરવાનું પ્રાણી નિયમ પ્રમાંણે અશુદ્ધ હોય અને તેનું અર્પણ ન થઈ શકે તો તે પ્રાણી યાજક પાસે લાવવું. ");
INSERT INTO guj2009_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","યાજક તેની કિંમત નક્કી કરે, પછી પ્રાણી સારું હોય કે ખરાબ તેથી ફરક ન પડે વ્યક્તિએ યાજકે ઠરાવેલ કિંમત માંન્ય રાખવી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","જો તે વ્યક્તિ તેને છોડાવવા ઈચ્છતો હોય તો તેણે કિંમત કરતાં પાંચમો ભાગ વધુ ચુકવવો. ");
INSERT INTO guj2009_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“જો કોઈ વ્યક્તિ પોતાનું મકાન યહોવાને સમર્પણ કરી દે, તો તે સારું હોય કે ખરાબ તેનાથી કોઈ ફરક ન પડે, યાજક તેની કિંમત નક્કી કરશે અને તે વ્યક્તિએ એ બાંધેલો ભાવ સ્વીકારવો. ");
INSERT INTO guj2009_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","પછી જો સમર્પણ કરનાર વ્યક્તિ મકાન છોડાવવા ઈચ્છે તો તેણે કિંમત ઉપરાંત વધુ 20 ટકા આપવા, એટલે મકાન પાછું તેની માંલિકીનું થઈ જાય.” ");
INSERT INTO guj2009_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“જો કોઈ વ્યક્તિ પોતાની માંલિકીની જમીનનો અમુક ભાગ યહોવાને સમર્પણ કરી દે તો તમાંરે તેની કિંમત એમાં જેટલું બિયારણ વાવી શકાતું હોય તેને આધારે નક્કી કરવી, જેમ કે 20 મણ જવની (1 હોમર) જરૂર પડે તો તેનું મૂલ્ય પચાસ શેકેલ થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","જો કોઈ માંણસ જુબિલી વર્ષમાં પોતાનું ખેતર સ્વેચ્છાએ સમર્પણ કરે તો યાજકે ઠરાવેલી પૂરી કિંમત તેને લાગુ પડે; ");
INSERT INTO guj2009_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","પણ જો તે જુબિલી વર્ષ પછીથી સમર્પણ કરે તો યાજકે પછીના જુબિલી વર્ષના જેટલા વર્ષ બાકી હોય તેના પ્રમાંણમાં રોકડ કિંમત નક્કી કરવી અને તે આકડાં મુજબ કિંમત ઠરાવવી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","પરંતુ જો સમર્પણ કરનાર જમીન છોડાવવા માંગતો હોય તો તેણે ઠરાવેલી કિંમત કરતાં વીસ ટકા વધુ આપવા એટલે તે ખેતરની માંલિકી ફરીથી તેની થાય. ");
INSERT INTO guj2009_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","પરંતુ જો તે જમીન નહિ છોડાવતાં બીજા કોઈને વેચી દે તો તેને તે કદી પાછું મળે નહિ, કારણ જુબિલી વર્ષના તેના હક્કો યહોવાને આપેલા હોય છે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","જ્યારે જુબિલી વર્ષમાં તે ખેતર મુકત થાય, ત્યારે યહોવાને અર્પિત ખેતર તરીકે તે યાજકોને આપવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“જો કોઈ વ્યક્તિ પોતે ખરીદેલું ખેતર સમર્પણ કરે, અને તે તેના પરિવારની મિલકતનો ભાગ નથી, ");
INSERT INTO guj2009_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","યાજકે બીજા જુબિલી વર્ષને જેટલા વર્ષ બાકી હોય તેને આધારે તેની કિંમત ઠરાવવી, અને તે વ્યક્તિએ નક્કી કરેલી કિંમત યહોવાને તાત્કાલિક અર્પણ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","જુબિલી વર્ષે એ ખેતર તેના મૂળ માંલિક, જેની પાસેથી તે ખરીધું હોય તેને પાછું મળે, જેની એ પોતાના વતનની મિલકત છે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“અધીકૃત માંપ પ્રમાંણે શેકેલમાં ઠરાવાય, એ માંપ પ્રમાંણે શેકેલનુ વજન 10 ગેરાહ હોય.” ");
INSERT INTO guj2009_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“કોઈ પણ વ્યક્તિએ બળદ અથવા ઘેટાનાં પ્રથમજનિતને ઐચ્છિકાર્પણ તરીકે યહોવાને ચઢાવવું નહિ, કારણ, એ તો યહોવાનું જ છે; પછી ભલે તે કોઈ પણ પશુનું હોય, ");
INSERT INTO guj2009_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","પરંતુ જો યહોવાએ માંન્ય કર્યુ ના હોય તો તેવા પ્રાણીના પ્રથમજનિતને અર્પણ તરીકે લાવવામાં આવે, તો યાજક તેની કિંમત ઠરાવે તે ઉપરાંત વીસ ટકા વધુ તે માંલિક આપે. જો તેનો માંલિક તેને છોડાવવા માંગતો ન હોય તો યાજક તે પ્રાણી બીજા કોઈને વેચી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“પરંતુ યહોવાને માંત્ર કરેલું કોઈ પણ અર્પણ પછી તે માંણસ હોય, પ્રાણી અથવા વારસામાં મળેલું ખેતર, તો તેને વેચી અથવા છોડાવી શકાય નહિ. કારણ તે યહોવાને પરમપવિત્ર અર્પણ છે, ");
INSERT INTO guj2009_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","જો તે ખાસ અર્પણ માંણસ હોય તો, તે વ્યક્તિને પાછો ખરીદી ન શકાય તેને માંરી નાખવો. ");
INSERT INTO guj2009_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“જમીનની ઉપજનો ઠરાવેલો દશમો ભાગ પછી તે ખેતરના અનાજનો હોય કે વૃક્ષનાં ફળોનો હોય તે યહોવાનો ગણાય, તે પવિત્ર છે, કારણ કે યહોવાને સમર્પિત થેયેલો છે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","જો કોઈ વ્યક્તિ આ અનાજ કે ફળનો એ દશમો ભાગ પાછો ખરીદવા ઈચ્છે તો તેની કિંમતમાં વીસ ટકા ઉમેરીને ચૂકવે. ");
INSERT INTO guj2009_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“ઢોરઢાંખર તથા ઘેટાબકરાંની તથા બીજા જાનવરોની ગણતરી થાય ત્યારે લાકડી નીચેથી પસાર થતાં દર દશમું પ્રાણી યહોવાનું ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","પસંદ કરેલુ પ્રાણી સારું છે કે ખરાબ તેની ચિંતા માંલિકે ન કરવી. તેને એ પ્રાણી બીજા પ્રાણી સાથે અદલા બદલી ન કરવી. અને તેને જો બીજા પ્રાણીથી બદલવા માંગે, તો બન્ને પ્રાણીઓ દેવના થશે. તે પ્રાણી પાછું ન ખરીદાય.” ");
INSERT INTO guj2009_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","મૂસાને યહોવાએ ઇસ્રાએલી લોકો માંટે સિનાઈ પર્વત પર આ આજ્ઞાઓ આપી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ઇસ્રાએલીઓ મિસર દેશમાંથી નીકળી ગયા ત્યાર પછી બીજા વર્ષના બીજા મહિનાના પ્રથમ દિવસે સિનાઈના અરણ્યમાં મુલાકાતમંડપમાં યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“સમગ્ર ઇસ્રાએલી સમાંજની વસ્તી ગણતરી કરો, દરેક વ્યક્તિની તેના કુટુંબ તથા કુળસમૂહ સાથે યાદી તૈયાર કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","જેઓ વીસ વર્ષ અને તેનાથી મોટી ઉમરના હોય અને જે બધા લશ્કરમાં જોડાવા લાયક હોય તેમની ગણતરી તેમનાં સમૂહો પ્રમાંણે કરીને યાદી તૈયાર કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","પ્રત્યેક કુળસમૂહના એક આગેવાન પુરુષને તમાંરી મદદમાં રહેવા કહો. ");
INSERT INTO guj2009_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","અને તમને મદદ કરનારાઓનાં નામ આ પ્રમાંણે છે: રૂબેનના કુળસમૂહમાંથી અલીસૂર જે શદેઉરનો પુત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","શિમયોનના કુળસમૂહમાંથી શલુમીએલ જે સૂરીશાદાયનો પુત્ર છે. ");
INSERT INTO guj2009_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","યહૂદાનાં કુળસમૂહમાંથી આમ્મીનાદાબનો પુત્ર નાહશોન. ");
INSERT INTO guj2009_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ઈસ્સાખારના કુળસમૂહમાંથી સૂઆરનો પુત્ર નથાનિયેલ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ઝબુલોનનાં કુળસમૂહમાંથી હેલોનનો પુત્ર અલીઆબ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","યૂસફના કુટુંબોમાંથી: એફ્રાઈમના કુળસમૂહમાંથી આમ્મીહૂદનો પુત્ર એલીશામાં. અને મનાશ્શાના કુળસમૂહમાંથી પદાહસૂરનો પુત્ર ગમાંલ્યેલ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","બિન્યામીનનાં કુળસમૂહમાંથી ગિદિયોનીનો પુત્ર અબીદાન. ");
INSERT INTO guj2009_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","દાનનાં કુળસમૂહમાંથી આમ્મીશાદાયનો પુત્ર અહીએઝેર. ");
INSERT INTO guj2009_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","આશેરનાં કુળસમૂહમાંથી ઓક્રાનનો પુત્ર પાગીએલ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ગાદનાં કુળસમૂહમાંથી દેઉએલનો પુત્ર એલ્યાસાફ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","નફતાલીના કુળસમૂહમાંથી એનાનનો પુત્ર અહીરા.” ");
INSERT INTO guj2009_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","તે બધા પુરુષો તેઓના કુટુંબોના આગેવાનો હતા. લોકોએ તેઓને તેમના કુળસમૂહના આગેવાન તરીકે પસંદ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","મૂસાએ અને હારુને ઉપર દર્શાવેલ આગેવાન ઇસ્રાએલીઓને સાથે લીધા. ");
INSERT INTO guj2009_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","બીજા મહિનાના પ્રથમ દિવસે તેમણે સમગ્ર ઇસ્રાએલ સમાંજને એકત્ર કરીને તેમના કુટુંબો અને કુળસમૂહો અનુસાર નોંધણી કરી, વીસ વર્ષ અને તેથી વધારે ઉમર ના સર્વ પુરુષોનાં નામની નોંધણી કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","યહોવાએ જે આજ્ઞા આપી હતી તે મુજબ મૂસાએ સિનાઈના રણમાં તેઓની ગણતરી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ઇસ્રાએલના જયેષ્ઠ પુત્ર રૂબેનના કુળસમૂહના 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની છેવટની સંખ્યા નોંધવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","તો તેઓની સંખ્યાની ગણના રૂબેનના કુળસમૂહમાં 46,500 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","શિમયોનનાં કુળસમૂહના 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની ગણના કુટુંબવાર કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","શિમયોનના કુળસમૂહની કુલ સંખ્યા 59,300 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ગાદનાં કુળસમૂહના 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી ");
INSERT INTO guj2009_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","તો તેમની કુલ સંખ્યા 45,650 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","યહૂદાનાં કુળસમૂહના 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી, ");
INSERT INTO guj2009_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","તો તેમની કુલ સંખ્યા 74,600 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ઈસ્સાખારનાં પુત્રોના કુળસમૂહમાં, 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","તો તેમની કુલ સંખ્યા 54,400 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ઝબુલોનનાં પુત્રોના કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી, ");
INSERT INTO guj2009_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","તો તેમની એકંદર સંખ્યા 57,400 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","યૂસફના પુત્રોના, એટલે એફ્રાઈમના કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના બધા જે લશ્કરમાં જોડાવા શક્તિમાંન હોય તે પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી, ");
INSERT INTO guj2009_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","તો તેમની કુલ સંખ્યા 40,500 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","મનશ્શાનાં કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા માંટે શક્તિમાંન હોય તે બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી ");
INSERT INTO guj2009_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","તો તેમની કુલ સંખ્યા 32,200 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","બિન્યામીનનાં કુળસમૂહના 20 વર્ષના અને તેમની ઉપરના બધાં જ પુરુષો જે લશ્કરમાં જોડાવા શક્તિમાંન હોય તેમની કુટુંબવાર નોંધ કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","તેમની કુલ સંખ્યા 35,400 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","દાનના કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","તો તેમની કુલ સંખ્યા 62,700 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","આશેરનાં કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તે બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","તો તેમની કુલ સંખ્યા 41,500 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","નફતાલીનાં કુળસમૂહમાં 20 વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા બધા પુરુષોની કુટુંબવાર નોંધ કરવામાં આવી, ");
INSERT INTO guj2009_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","તો તેમની કુલ સંખ્યા 53,400 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","મૂસા અને હારુને તથા ઇસ્રાએલના પ્રત્યેક કુળસમૂહના અધિપતિ તરીકે આવેલા બાર કુળસમૂહના આગેવાનોએ સાથે મળીને નોંધેલી સંખ્યા આ પ્રમાંણે હતી: ");
INSERT INTO guj2009_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","વીસ વર્ષના અને તેની ઉપરના લશ્કરમાં જોડાવા શક્તિમાંન હોય તેવા પુરુષોની તેઓના કુટુંબો અનુસાર ગણતરી કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","તો તેઓની કુલ સંખ્યા 6,03,550 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","પણ બાકીના કુળસમૂહોની સાથે લેવીઓની કુટુંબવાર નોંધણી કરવામાં આવી નહોતી, કારણ, ");
INSERT INTO guj2009_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","યહોવાએ મૂસાને કહ્યું હતું કે, ");
INSERT INTO guj2009_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“લશ્કરમાં જોડાઈ શકે તેવા લાયક પુરુષોની તમે ગણતરી કરો ત્યારે લેવીના કુળસમૂહની સંખ્યા નોંધવાની નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","કારણ કે લેવીઓને પવિત્રમંડપની સેવાનું તથા તેને ઊંચકી લેવાનું કામ સોંપવાનું છે, તેઓએ એકલાએ જ હાજરમાં રહેવા માંટે પવિત્રમંડપની પાસે જ તેની ચારે બાજુ પોતાની છાવણી રાખવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","જ્યારે એ પવિત્રમંડપે બીજે લઈ જવાનો પ્રસંગ ઊભો થાય, ત્યારે લેવીઓએ જ એ ઉઠાવવાનો એટલે કે છૂટો પાડવાનો અને ફરીથી ઊભો કરવાનો છે. લેવી કુળસમૂહના સદસ્ય સિવાય જે કોઈ વ્યક્તિ પવિત્રમંડપની સંભાળ રાખવાનો પ્રયાસ કરે તો તેને મૃત્યુદંડની સજા કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ઇસ્રાએલના દરેક કુળની છાવણી અલગ રાખવી, અને પોતપોતાના કુળની પોતાની ટુકડી સાથે અને ધ્વજ સાથે પડાવ નાખવો. ");
INSERT INTO guj2009_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","પણ લેવીઓએ પવિત્રમંડપની આસપાસ જ પોતાની છાવણી નાખવી. તેઓ પવિત્ર મુલાકાત મંડપની રક્ષા કરશે. જેથી ઇસ્રાએલી લોકોનું કશું ખોટું થશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","યહોવાએ મૂસાને કહ્યું હતું તે પ્રમાંણે સર્વ આજ્ઞાઓનો અમલ ઇસ્રાએલીઓએ બરાબર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","યહોવાએ મૂસાને અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“પ્રત્યેક ઇસ્રાએલી કુળને છાવણી માંટે પોતાનું અલગ સ્થાન હોય તથા પોતાના કુળનું અલગ નિશાન અને અલગ ધ્વજ હોય; કુળોની સર્વ છાવણીઓની મધ્યમાં મુલાકાત મંડપ રહે અને બધા જ પ્રવેશદ્વાર મુલાકાત મંડપ તરફ હોય. ");
INSERT INTO guj2009_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“પૂર્વની બાજુએ, સૂર્યોદય તરફ યહૂદાના કુળસમૂહના ધ્વજ નીચે આવતાં લોકોએ તેમની ટુકડી પ્રમાંણે પડાવ નાખવા. આમ્મીનાદાબનો દીકરો નાહશોન યહૂદાના દીકરાઓનો આગેવાન રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 74,600 પુરુષો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“એના પછી ઈસ્સાખારનું કુળસમૂહ છાવણી કરે; સૂઆરનો પુત્ર નથાનિયલ ઈસ્સાખારના પુત્રોના અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","તેના સૈન્યમાં તેમાંના જેઓની નોંધણી થઈ છે તેવા 54,400 પુરુષો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“અને ઝબુલોનના કુળસમૂહો પણ યહૂદાના કુળસમૂહોની બાજુમાં જ છાવણી કરે અને હેલોનનો પુત્ર અલીઆબ તે ઝબુલોનના પુત્રોનો અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","અને તેના સૈન્યમાં તેઓમાંના જેઓની ગણના થઈ છે તેવા 57,400 પુરુષો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“યહૂદાના કુળસમૂહોની છાવણીના માંણસોની કુલ સંખ્યા 1,86,400 છે એ લોકો કૂચ કરતી વખતે પહેલા ઊપડશે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“દક્ષિણ બાજુએ રૂબેનના કુળની સેનાના ધ્વજ હેઠળના લોકોએ નીચેના આગેવાનો હેઠળ ટુકડીવાર છાવણી નાખવી; શદેઉરનો પુત્ર એલીસૂર તે રૂબેનના પુત્રોનો અધિપતિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 46,500 સૈનિકો તેની સાથે રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“એ પછી શિમયોનનો કુળસમૂહ તેની પાસે છાવણીમાં પડાવ નાખે; અને સૂરીશાદાયનો પુત્ર શલુમીએલ તે શિમયોનના પુત્રોનો અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 59,300 સૈનિકો સાથે રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“અને તે પછી ગાદનું કુળસમૂહ પડાવ નાખશે; અને રેઉએલનો પુત્ર એલ્યાસાફ તે ગાદના પુત્રોનો અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 45,650 સૈનિકો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“રૂબેનના કુળોની છાવણીના માંણસોની કુલ સંખ્યા 1,51,450 હતી, અને તેઓ કૂચ કરતી વખતે બીજું સ્થાન લેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","એ પછી પ્રથમ બે ટુકડીઓ અને પછીની બે ટુકડીઓ વચ્ચે લેવીઓ મુલાકાત મંડપને ઉપાડીને ચાલશે. પ્રત્યેક ટુકડી છાવણી નાખ્યાના ક્રમે જ ઊપડશે અને પ્રત્યેક પુરુષ પોતાના ધ્વજ હેઠળ પોતાનું સ્થાન જાળવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“પશ્ચિમ બાજુએ એફ્રાઇમના કુળસમૂહની સેનાના ધ્વજ હેઠળ તેમની ટુકડીઓ આગેવાનો હેઠળ છાવણી નાખશે; અને આમ્મીહૂદનો પુત્ર એલીશામાં તે એફ્રાઈમના પુત્રોનો અધિપતિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 40,500 સૈનિકો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“અને તેની પાસે મનાશ્શાનું કુળસમૂહ રહે; અને પદાહસૂરનો પુત્ર ગમાંલ્યેલ તે મનાશ્શાના પુત્રોનો અધિપતિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 32,200 સૈનિકો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“તે પછી બિન્યામીનનું કુળસમૂહ પડાવ નાખશે આગેવાન ગિદિયોનીનો પુત્ર અબીદાન તે બિન્યામીનના પુત્રોનો અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 35,400 સૈનિકો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“એફ્રાઈમની છાવણીમાં જે બધાની ગણના થઈ તેઓ છે, પોતાનાં સૈન્યો પ્રમાંણે, 1,08,100 છે અને તેઓ કૂચ કરતી વખતે ત્રીજા ક્રમે ચાલી નીકળે એમ ગોઠવણી કરવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“ઉત્તર બાજુએ દાનના કુળસમૂહોની સેનાના ધ્વજ હેઠળના લોકોએ તેમના આગેવાનો હેઠળ ટુકડીવાર છાવણી તેમના ભાગલા પ્રમાંણે નાખવી; આમ્મીશાદાયનો પુત્ર અહીએઝેર તે દાનના પુત્રોનો આગેવાન છે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","અને તેના સૈન્યમાં નોંધણી થઈ હોય તેવા 62,700 સૈનિકો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“અને તેની પાસે આશેરના કુળસમૂહો છાવણી કરે; અને ઓક્રાનનો પુત્ર પાગીએલ તેનો અધિપતિ થાય; ");
INSERT INTO guj2009_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","અને તેના સૈન્યમાં નોંધણી થઈ છે તેવા 41,500 સૈનિકો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“પછી તફતાલીના કુળસમૂહો; અને એનાનનો પુત્ર અહીરા તે નફતાલીના પુત્રોનો અધિપતિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","અને તેના સૈન્યમાં તેઓમાંના જેઓની નોંધણી થઈ છે તેવા 53,400 સૈનિકો રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“દાનના કુળોની છાવણીના માંણસોની કુલ સંખ્યા 1,57,600 હશે, તેઓ કૂચ કરતી વખતે છેલ્લા રહેશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ઇસ્રાએલ પ્રજાની કુટુંબવાર નોંધણી કરવામાં આવી ત્યારે તેમની સંખ્યા 6,03,550 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","યહોવાએ મૂસાને આજ્ઞા કરી તે પ્રમાંણે આ ગણતરી કરવામાં આવી ત્યારે લેવીઓને ગણવામાં આવ્યા નહોતા. ");
INSERT INTO guj2009_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","યહોવાએ મૂસાને કહ્યું હતું તે જ પ્રમાંણે બરાબર વ્યવસ્થા થઈ. તેઓ પોતપોતાના સમૂહના ધ્વજ હેઠળ છાવણી નાખતા. અને કૂચ કરતી વખતે પ્રત્યેક વ્યક્તિ પોતાના કુળસમૂહની ટુકડીમાં પોતાના સ્થાને જ રહેતા. ");
INSERT INTO guj2009_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","સિનાઈ પર્વત પર યહોવાએ મૂસા સાથે વાત કરી ત્યારે હારુન અને મૂસાના વંશાવળી આ પ્રમાંણે હતી: ");
INSERT INTO guj2009_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","હારુનના જ્યેષ્ઠ પુત્રનું નામ નાદાબ, તે પછી અબીહૂ, એલઆઝાર અને ઈથામાંર. ");
INSERT INTO guj2009_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","એમનો યાજકો તરીકે અભિષેક કરવામાં આવ્યો હતો અને તેમને યાજકના અધિકારો આપવામાં આવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","પરંતુ નાદાબ અને અબીહૂ એ અપવિત્ર અગ્રિ યહોવાને ધરાવ્યો તેથી તેઓ સિનાઈના રણમાં જ મૃત્યુ પામ્યા. તેઓને એક પણ પુત્ર ન હતો. અને તેથી એલઆઝાર અને ઈથામાંર તેઓના પિતાના જીવનકાળ દરમ્યાન યાજકપદમાં સેવાઓ આપતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","યહોવાએ મૂસાને કહ્યુ, ");
INSERT INTO guj2009_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“લેવીના કુળસમૂહોને બોલાવી લાવ અને તેમને યાજક હારુનની સેવામાં નિયુક્ત કર. ");
INSERT INTO guj2009_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","તેમણે યાજકો અને સમગ્ર સમાંજ તરફથી મુલાકાતમંડપની સેવામાં ઉપસ્થિત રહીને ફરજો બજાવવાની છે; ");
INSERT INTO guj2009_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","અને તેઓએ મુલાકાત મંડપની સાધન સામગ્રી સંભાળવાની છે અને તેમણે બધા ઇસ્રાએલી પ્રજાજનો તરફથી થાનકની ફરજો બજાવવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“અને તારે હારુનના તથા તેના પુત્રોના હવાલામાં લેવીઓને સોંપી દેવા કારણ કે બધા ઇસ્રાએલીઓમાંથી તેમને સેવા કરવા માંટે પસંદ કરવામાં આવ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“અને તારે હારુનને અને તેના કુળોને યાજકની ફરજો બજાવવા નિયુક્ત કરવા. જો કોઈ બિનઅધિકૃત વ્યક્તિ એ ફરજ બજાવવા જાય તો તેને મોતની સજા કરવી.” ");
INSERT INTO guj2009_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ઇસ્રાએલ પ્રજાના પ્રથમજનિત પુત્રોની અવેજીમાં મેં લેવીઓનો સ્વીકાર કર્યો છે, તેથી ઇસ્રાએલના સર્વ પ્રથમ જન્મેલા પુત્રોના સ્થાને લેવીઓ માંરી સેવામાં રહેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","એ લોકો માંરા ગણાશે, કારણ કે પ્રત્યેક પ્રથમ પુત્ર ઉપર માંરો હક છે, જ્યારે મેં મિસરના બધા પ્રથમ પુત્રોને માંરી નાખ્યા હતા ત્યારે મેં ઇસ્રાએલનાં બધાં જ પ્રથમ અવતરેલાંને માંરે માંટે રાખી લીધાં હતાં, પછી એ માંણસ હોય કે પશુ હોય, તેઓ માંરાં છે; હું યહોવા છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","સિનાઈના અરણ્યમાં યહોવાએ ફરીથી મૂસા સાથે વાત કરી અને કહ્યુ, ");
INSERT INTO guj2009_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“લેવી કુળસમૂહના બધા પુરુષોની નોંધણી કર; એક મહિના અને તેથી વધારે ઉમરના સર્વ પુરુષોની કુટુંબ પ્રમાંણે ગણતરી કર.” ");
INSERT INTO guj2009_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","યહોવાની આજ્ઞા પ્રમાંણે મૂસાએ તેમની યાદી તૈયાર કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","લેવીના પુત્રોનાં નામ આ મુજબ છે: ગેર્શોન, કહાથ, અને મરારી, ");
INSERT INTO guj2009_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ત્રણેય એમના નામે ઓળખાતાં કુળસમૂહોના મૂળ પુરુષો હતા. ગેર્શોનના કુળસમૂહો લિબ્ની અને શિમઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","કહાથના કુળસમૂહો; આમ્રામ, યિસ્હાર, હેબ્રોન અને ઉઝઝીએલ. ");
INSERT INTO guj2009_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","મરારીના કુળસમૂહ; માંહલી અને મૂશી. આ સર્વનાં નામો પરથી લેવીઓનાં ગોત્રોનાં નામ ગણાયા. આ થઈ લેવીના કુળસમૂહોની કુટુંબવાર યાદી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ગેર્શોનના કુળસમૂહોમાં લિબ્ની અને શિમઈ એ બે કુટુંબો થયા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","એક મહિનાના અને તેથી વધારે ઉમરના પુરુષોની સંખ્યા ગણતા તે 7,500 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","તેઓની છાવણીનું સ્થાન પવિત્રમંડપની પાછળ પશ્ચિમ દિશામાં હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","લાએલનો પુત્ર એલ્યાસાફ તેમનો આગેવાન હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","એ લોકોએ પવિત્રમંડપમાં એની અંદરનું આવરણ, બહારનું આવરણ, પ્રવેશદ્વારનો પડદો, ");
INSERT INTO guj2009_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","પવિત્રમંડપની અને વેદીની આસપાસના ચોકના પડદાઓની, ચોકના પ્રવેશદ્વારના પડદાની, એની દોરીઓની, તેમજ એ બધાંને લગતાં કામકાજની સંભાળ રાખવાની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","કહાથના કુળસમૂહમાં આમ્રામી, ઈસ્હાર, હેબ્રોન અને ઉઝઝીએલ એટલાં કુટુંબો હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","એક મહિનાના અને તેથી વધારે ઉમરના પુરુષોની સંખ્યા 8,600 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","તેમની છાવણીનું સ્થાન પવિત્રમંડપની દક્ષિણમાં હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ઉઝઝીએલનો પુત્ર અલીસાફાન તેમનો આગેવાન હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","તે લોકોએ પવિત્રકોશની, બાજઠની, દીવીની અને વેદીઓની, ઉપાસનામાં વપરાતાં પવિત્ર વાસણોની, ગર્ભગૃહ આગળના પડદાની તથા એ બધાને લગતાં સર્વ કામકાજની અને ઉપયોગની સંભાળ રાખવાની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","લેવીઓના આગેવાનોનો મુખી, યાજક હારુનનો પુત્ર એલઆઝાર હતો; પવિત્રસ્થાનની સેવામાં જે બધા હતા તે સૌનો તે ઉપરી હતો, તેમના કાર્ય ઉપર દેખરેખ રાખવાની જવાબદારી તેની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","મરારીના કુળસમૂહોમાં માંહલી અને મૂશી એ બે કુટુંબો હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","એક મહિના અને તેથી વધારે ઉમરના પુરુષોની સંખ્યા કુલ 6,200 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","તેમની છાવણીનું સ્થાન પવિત્રમંડપની ઉત્તરના વિસ્તારમાં હતું. અબીહાઈલનો પુત્ર સૂરીએલ મરારી કુળસમૂહનો આગેવાન હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","એ લોકોએ થાનકના મંડપના પાટિયાં, તેની વળીઓ, સ્તંભો, કૂંભીઓ, ઓજારો તથા આ સર્વને લગતાં કામકાજની સંભાળ રાખવાની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","તદુપરાંત આંગણાની આસપાસના સ્તંભો, કૂંભીઓ, ખીલીઓ, અને દોરીઓની સંભાળ પણ તેમણે જ રાખવાની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","મૂસા હારુન અને તેના પુત્રોનો મુકામ થાનકના પવિત્રમંડપની સામે ઉગમણી દિશામાં હતો. ઇસ્રાએલીઓ તરફથી મુલાકાતમંડપની પૂરી જવાબદારી તેઓને માંથે હતી. જો કોઈ બિનઅધિકૃત વ્યક્તિ એ ફરજ બજાવવા જાય તો તેને મૃત્યુદંડની સજા થતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","યહોવાની આજ્ઞા અનુસાર મૂસાએ અને હારુને કુટુંબવાર ગણેલા એક મહિનાના અને તેની ઉપરની ઉમરના લેવી પુરુષોની સંખ્યા કુલ 22,000 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","યહોવાએ મૂસાને કહ્યુ, “એક મહિનાના અને તેની ઉપરની ઉમરના બધા પ્રથમજનિત ઇસ્રાએલી પુરુષોની નોંધણી કર અને તેમની સંખ્યા ગણ. ");
INSERT INTO guj2009_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","અને તું એ પ્રથમજનિત ઇસ્રાએલના પુરુષોની અવેજીમાં મને લેવીઓ સમર્પી દે. હું યહોવા છું, એ જ રીતે ઇસ્રાએલીઓનાં ઢોરના પ્રથમ વેતરના વાછરડાના અવેજીમાં લેવીઓનાં ઢોર મને સોંપી દે.” ");
INSERT INTO guj2009_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","યહોવાના કહ્યાં મુજબ મૂસાએ ઇસ્રાએલીઓના પ્રથમજનિત પુત્રોની યાદી તૈયાર કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","એક મહિનાના અને તેની ઉપરના પ્રથમજનિત પુત્રોની નામવાર યાદી કરી તો તેમની કુલ સંખ્યા 22,273 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ત્યાર પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“‘બધા પ્રથમજનિત ઇસ્રાએલીઓના પુરુષોની અવેજીમાં મને લેવીઓ આપ; અને ઇસ્રાએલીઓનાં ઢોરના પ્રથમ વેતરનાં વાછરડાંના બદલામાં લેવીઓનાં ઢોર સોંપી દે. ");
INSERT INTO guj2009_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","લેવીઓની સંખ્યા કરતાં ઇસ્રાએલીઓના પ્રથમજનિત પુત્રોની સંખ્યા 273 જેટલી વધુ છે. એટલે તું તેઓને એ વધારના પુત્રોને છોડાવી લેવા કહે. ");
INSERT INTO guj2009_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","અધિકૃત માંપ પ્રમાંણે ખંડી લેવાના પ્રત્યેક પુરુષ દીઠ 5 શેકેલ ચાંદી આપવી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","અને તે નાણાં તારે હારુનને અને તેના પુત્રોને આપવાં.’” ");
INSERT INTO guj2009_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ઇસ્રાએલના પ્રથમજનિત પુરુષો લેવીઓના પુરુષો કરતા 273 વધારે હતા: આ વધારના પ્રથમજનિતોને છોડાવવાં મૂસાએ ઇસ્રાએલીઓ પાસેથી નાણાં એકઠા કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","અધિકૃત માંપ અનુસાર એ રકમ 1,365 શેકેલ ચાંદી જેટલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","યહોવાએ આજ્ઞા કરી હતી તે મુજબ મૂસાએ તે રકમ હારુનને અને તેના પુત્રોને આપી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","યહોવાએ મૂસા અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","3","“લેવીના કુળસમૂહમાં કહાથના કુળસમૂહના તેઓના કુટુંબો પ્રમાંણે તથા તેઓના પિતાઓના ઘર પ્રમાંણે ત્રીસથી પચાસ વર્ષની ઉમરના મુલાકાત મંડપમાં સેવા કરવા લાયક બધા પુરુષોની કુટુંબવાર નૌંધણી કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","કહાથના કુળસમૂહોએ મુલાકાત મંડપને લગતી નીચે મુજબની સેવાએ કરવાની છે જે પરમપવિત્ર વસ્તુઓને લગતી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“જયારે છાવણીનો મુકામ ઉપાડવાનો સમય આવે ત્યારે હારુન અને તેના પુત્રોએ પવિત્ર કરારકોશ આગળનો પડદો ઉતારી લઈ તેનાથી સાક્ષ્કોશને ઢાંકી દેવો, ");
INSERT INTO guj2009_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ત્યારબાદ તેઓ બકરાના કુમાંશદાર ચામડા વડે પડદાને ઢાકે, બકરાના ચામડાને ભૂરા જાંબુડિયાં રંગના કપડાથી ઢાંકે અને પવિત્રકોશને ઉપાડવાના દાંડા તેની કડીઓમાં નાખે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“પછી તેઓએ રોટલી ઘરાવવાના બાજઠ પર એક ભુરા જાંબુડિયા રંગનું કાપડ પાથરી દેવું, અને થાળીઓ, ચમચા, વાટકા, ધૂપદાની અને પેયાર્પણ અને ખાસ રોટલો હમેશા તેની ઉપર હોવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","નૈવેધની રોટલી તેના ઉપર રાખવી, અને એ બધા ઉપર કિરમજી રંગનું કાપડ પાથરવું. કિરમજી રંગના આ કપડા પર બકરાનું ચામડું ઢાંકવું, અને પછી ઊચકવા માંટેના દાંડા દાખલ કરવા. ");
INSERT INTO guj2009_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ત્યારબાદ તેઓએ એક ભૂરા જાંબુડિયા રંગનું કપડું લઈ તેના વડે દીપવૃક્ષ, દીવાઓ, ચીપિયા, તાસકો અને દીવામાં વપરાતા તેલપાત્રોને ઢાંકવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","તે પછી આ બધી જ વસ્તુઓ સહિત એ દીવીને કુમાંશદાર ચામડામાં લપેટીને તેમને લઈ જવા માંટેની પાલખી ઉપર મૂકી દેવી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“પછી તેઓએ સોનાની વેદી ભૂરા જાંબૂડિયા રંગના કપડાથી ઢાંકવી, તેઓએ તેને બકરાના કુમાંશદાર ચામડાથી ઢાંકવું અને તેને ઊચકવાના દાંડા દાખલ કરી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“પછી પવિત્રજગ્યામાં ઉપાસનામાં વપરાતાં બધાં વાસણોને ભૂરા રંગનું કાપડ ઢાંકવું અને તેના પર બકરાનું કુમાંશદાર ચામડું ઢાંકી દેવું અને તેને પાલખી પર મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ત્યારબાદ તેમણે વેદી પરથી રાખ સાફ કરી નાખવી અને તેના પર જાંબુડિયા રંગનું કપડું ઢાંકવું. ");
INSERT INTO guj2009_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","અને વેદીની ઉપાસનામાં વપરાતાં સર્વ વાસણોને દેવતા ભરવાની તબકડી, ચીપિયા, પાવડી અને પાણી છાંટવાના ડોયા-વગેરે ઉપર બકરાનું કુમાંશદાર ચામડું ઢાંકવું અને પછી ઉપાડવાના દાંડા દાખલ કરવા. ");
INSERT INTO guj2009_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“હારુન અને તેના પુત્રો મુકામ ઉપાડતી વખતે પવિત્રસ્થાનને અને તેની બધી સાધનસામગ્રીને ઢાંકે અને તે પછી કહાથના કુળોએ તે ઉપાડવા માંટે હાજર થઈ જવું, અને જયાં છાવણી કરવાની હોય ત્યાં બધું લઈ જવું; પરંતુ તેઓએ પવિત્ર વસ્તુઓને અડવું નહિ, અડે તો રખેને તેઓ મૃત્યુ પામે. કહાથના કુળોએ મુલાકાત મંડપમાંથી વસ્તુઓ ઉપાડવાનું પવિત્રકાર્ય કરવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“યાજક હારુનના પુત્ર એલઆઝારે દીવાના તેલની, સુવાસિત સુગંધીની, રોજના ખાધાર્પણ તથા અભિષેકના તેલની જવાબદારી બજાવવાની છે, તથા સમગ્ર પવિત્રમંડપ અને તેમાંની સર્વ વસ્તુઓની સંભાળ રાખવાની જવાબદારી પણ તેમણે જ કરવાની છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","પછી યહોવાએ મૂસાને તથા હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“તમાંરે કહાથના કુળસમૂહના કુટુંબોના લેવીઓમાંથી ઉચ્છેદ થવા દેવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","પરમપવિત્ર વસ્તુઓ ઊચકીને લઈ જતાં મૃત્યુ ન પામે તે માંટે તારે આ પ્રમાંણે કરવું: હારુને અને તેના પુત્રોએ આવીને પ્રત્યેકને તેમનું કામ અને તેમને જે ઉપાડવાનું હોય તે સુપ્રત કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","તથા તે પવિત્ર વસ્તુઓ બંધાતી હોય ત્યારે કહાથના કુળસમૂહોએ પવિત્રસ્થાનમાં પ્રવેશ કરવો નહિ, રખેને તેઓની નજર પવિત્ર વસ્તુઓ પર ત્યાં પડે અને તેઓ મૃત્યુ પામે.” ");
INSERT INTO guj2009_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“તમાંરે લેવી કુળના ગેર્શોનના કુળસમૂહોની પણ કુટુંબવાર નોંધણી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","પવિત્રમંડપમાં સેવા કરવાને લાયક હોય તેવા ત્રીસથી પચાસ વર્ષની ઉમરના જે પુરુષો હોય તેમની નોંધણી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ગેર્શોનના કુળસમૂહના પુરુષોએ નીચેની વસ્તુઓ ઉપાડવાની સેવા બજાવવાની છે: ");
INSERT INTO guj2009_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","તેમણે પવિત્ર મંડપના અંદરના પડદા, પવિત્રમંડપનું બહારનું આવરણ, છત તરીકેનું બકરાના ચામડાનું આવરણ અને પવિત્રમંડપના પ્રવેશદ્વારનો પડદો. ");
INSERT INTO guj2009_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","તથા ચોકના પડદા, પવિત્રમંડપ અને વેદીની આસપાસના ચોકના પ્રવેશદ્વારનો પડદો-દોરડાંઓ, અને એ સર્વને લગતી બધી સાધન-સામગ્રી ઉપાડવાની જવાબદારી તેઓની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","આ બધાં કામો તેમણે હારુન અને તેના પુત્રોની આજ્ઞા મુજબ ગેર્શોનીઓએ કરવાનાં છે. અને ભાર ઊચકવાનું પવિત્રમંડપની કે સેવાનું જે કામ સોંપે તે તેઓએ કરવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ગેર્શોનના કુળસમૂહોએ પવિત્ર મંડપની લગતી આ સેવાઓ કરવાની છે, અને યાજક હારુનના પુત્ર ઈથામાંરે એમના ઉપર દેખરેખ રાખવાની છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“પછીથી તમાંરે મરારીના કુળસમૂહોની કુટુંબવાર નોંધણી કરવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","પવિત્રમંડપના પવિત્ર કાર્ય માંટે લાયક હોય તેવા 30 વર્ષથી 50 વર્ષની ઉમરના પુરુષોની ગણતરી તારે કરવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","તેમણે પવિત્રમંડપમાંની નીચેની વસ્તુઓ ઉપાડવાની છે: તંબુનાં પાટિયાં, તેની વળીઓ, થાંભલીઓ અને કૂંભીઓ, ");
INSERT INTO guj2009_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","આંગણાની ચારે બાજુની દીવાલના સ્તંભો, કૂંભીઓ, ખુંટીઓ, દોરડીઓ અને તેની સાધનસામગ્રી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","પ્રત્યેક પુરુષને તેણે ઉપાડવાની વસ્તુઓ સોંપવામાં આવે. મરારીના કુળસમૂહો પણ આટલી સેવા કરે. પવિત્રમંડપના તેઓનાં બધાં કામો ઉપર યાજક હારુનના પુત્ર ઈથામાંરે દેખરેખ રાખવાની ફરજ બજાવવાની છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","યહોવાની આજ્ઞા મુજબ મૂસા તથા હારુને અને અન્ય આગેવાનોએ કોહાથના કુળસમૂહોની કુટુંબવાર નોંધણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","પવિત્રમંડપની સેવા માંટે યોગ્ય એવા 30 વર્ષથી 50 વર્ષની ઉમર ના સર્વ પુરુષોની નોંધણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","તેઓની કુલ સંખ્યા 2,750 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","યહોવાની આજ્ઞા અનુસાર મૂસા અને હારુને નોંધણીનું આ કાર્ય કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","એ જ રીતે ગેર્શોનના કુળસમૂહની કુટુંબવાર નોંધણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","પવિત્રમંડપની સેવા માંટે યોગ્ય એવા 30 વર્ષથી 50 વર્ષની ઉમરના બધા જ પુરુષોની નોંધણી કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","તેઓના કુળસમૂહની કુટુંબવાર નોંધણીની કુલ સંખ્યા 2,630 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","યહોવાએ આપેલી આજ્ઞા મુજબ મૂસા અને હારુને નોંધણીનું આ કાર્ય કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","મરારી કુળસમૂહની કુટુંબવાર નોંધણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","પવિત્રમંડપની સેવા માંટે યોગ્ય એવા 30 વર્ષથી 50 વર્ષની ઉમરના સર્વ પુરુષોની નોંધણી કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","તેઓની કુટુંબવાર નોંધણી અનુસાર કુલ સંખ્યા 3,200 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","યહોવાની આજ્ઞા મુજબ મૂસાએ અને હારુને આ નોંધણીનું કાર્ય કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","આ રીતે મૂસાએ અને હારુને તથા ઇસ્રાએલના સર્વ આગેવાનોએ બધા જ લેવીઓની વંશાનુસાર તથા કુટુંબવાર નોંધણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ત્રીસ વર્ષથી પચાસ વર્ષની ઉમરના જે લેવી પુરુષો પવિત્રમંડપની સેવા કરવા તથા તેને ઉપાડી લઈ જવાનું કામ કરવા આવ્યા ");
INSERT INTO guj2009_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","તેઓની કુલ સંખ્યા 8,580 થઈ. ");
INSERT INTO guj2009_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","યહોવાએ મૂસાને આપેલી આજ્ઞા અનુસાર દરેકને સેવાની અને ભાર ઉપાડવાની જવાબદારી સોંપવામાં આવી. આમ, યહોવાએ મૂસાને કરેલી આજ્ઞા અનુસાર તેઓની નોંધણી કરવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ઇસ્રાએલી પ્રજાને તું એવું જણાવ કે, તેઓ પોતાની છાવણીમાંથી બધા જરફતપિત્તના દર્દીઓને, જેમના શરીરમાંથી સ્ત્રાવ થતો હોય તેઓને, તથા જેઓ શબના સ્પર્શથી અશુદ્ધ થયા હોય તેઓને છાવણીમાંથી બહાર કાઢી મૂકે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","સ્ત્રી હોય કે પુરુષ, બંનેને બહાર કાઢી મૂકવાં, જેથી જે છાવણીમાં હું તમાંરી વચ્ચે રહું છું તેને તેઓ અશુદ્ધ કરે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","યહોવાએ મૂસાને કરેલી આજ્ઞા અનુસાર ઇસ્રાએલીઓએ છાવણી બહાર એ લોકોને કાઢી મૂકયાં. ");
INSERT INTO guj2009_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“તું ઇસ્રાએલીઓને કહે કે, જે પુરુષ અથવા સ્ત્રી યહોવાની આજ્ઞાઓનો ભંગ કરીને અન્યને નુકસાન કરે, તો તે દોષિત બને છે, તેથી તેણે તે બદલ પ્રાયશ્ચિત કરવું જ જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","પોતે કરેલાં પાપની તેણે કબૂલાત કરવી અને જેનું તેણે જે કાંઈ નુકસાન કર્યુ હોય તે પૂરેપૂરું ભરપાઈ કરી આપવા ઉપરાંત વીસ ટકા જેટલું વધારે ચૂકવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","પણ જેને નુકસાન કર્યું છે તે જો મૃત્યુ પામ્યો હોય અને ક્ષતિપૂર્તી માંટે તેનું નજીકનું કોઈ સગું ના હોય, તો તે રકમ યહોવાને આપવી અને યાજકને ચૂકવવી અને જે ઘેટો પાપોના પ્રાયશ્ચિત માંટે વધેરવા આપવાનો હોય છે, તે ઉપરાંત આ રકમ આપવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“ઇસ્રાએલીઓ દેવને જે કંઈ ઉચ્છાલીયાર્પણ ઘરાવે છે, તે યાજકની ગણાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","યાજકોને માંણસો જે કોઈ ભેટ આપે છે તે યાજકો પોતાને માંટે રાખે.” ");
INSERT INTO guj2009_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ઇસ્રાએલી પ્રજાને તું આ પ્રમાંણે કહે: જો કોઈ પુરુષની પત્ની આડે રસ્તે જાય અને વિશ્વાસઘાતી નીવડે, કોઈ પર પુરુષ સાથે સૂઈને વ્યભિચાર કરે, ");
INSERT INTO guj2009_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","પરંતુ તેની સાબિતી ના હોય અને સાક્ષી આપનાર કોઈ ના હોય, ");
INSERT INTO guj2009_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","અને છતાં તેના પતિને તેના પર શંકા જાય; અથવા પત્નીએ વ્યભિચારનું પાપ કર્યુ ના હોય તો પણ તેના પતિના મનમાં વહેમ જાગ્યો હોય તો પતિએ તેને યાજક પાસે લઈ જવી. ");
INSERT INTO guj2009_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","તેણે 8 વાટકા જવનો લોટ (એક દશાંશ એફાહ) લઈ યહોવાને અર્પણ કરે. તેણે તેના પર તેલ રેડવું નહિ કે ધૂપ પણ મૂકવો નહિ, કારણ કે એ વહેમને કાઢવા ગુનાનું પારખું કરવા માંટેનું સ્મરણદાયક ખાધાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“યાજકે તે સ્ત્રીને યહોવા સમક્ષ રજૂ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","પછી યાજકે માંટીના પાત્રમાં પવિત્ર જળ લેવું, અને તેમાં પવિત્રમંડપની પવિત્ર ભૂમિ પરની ધૂળ લઈને તેમાં નાખવી. ");
INSERT INTO guj2009_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","પછી તેણે તે સ્ત્રીને યહોવા સમક્ષ ઊભી રાખી તેના વાળ છોડી નાખશે, અને તેણીના હાથમાં ખાધાર્પણ મૂકશે. પતિની ઈર્ષ્યાને કારણે આપવામાં આવેલો આ જવનો લોટ છે. પછી યાજક નક્કી કરે કે તેના પતિનો વહેમ સાચો છે કે નહિ, યાજકે શ્રાપ આપવા માંટેના કડવા જળનું પાત્ર પોતાના હાથમાં રાખવું. ");
INSERT INTO guj2009_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“ત્યારબાદ યાજકે સ્ત્રી પાસે સોગન લેવડાવવા, તેને કહેવું કે, ‘જો તેં કુમાંર્ગે જઈને કોઈ માંણસ સાથે વ્યભિચાર કર્યો ન હોય, તો આ શ્રાપના કડવા જળથી તને કશું જ નુકસાન નહિ થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","પણ જો તેં કુમાંર્ગે જઈને કોઈ માંણસ સાથે વ્યભિચાર કર્યો હશે તો ");
INSERT INTO guj2009_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","યહોવા તારા નામને તારા લોકમાં શ્રાપરૂપ બનાવી દો. તારી જાંધોમાં સડો પેદા કરો, અને તારા શરીરને ફુલાવી દો.’ ");
INSERT INTO guj2009_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","“આ જળ તારા પેટમાં પ્રવેશીને તેને ફુલાવી દો, અને તારા ગર્ભાશયને સંકોચાવી દો. પછી તે સ્ત્રીએ ‘આમીન’ ‘આમીન’ એમ જવાબ આપે.” ");
INSERT INTO guj2009_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“પછી યાજકે તે શ્રાપ સૂચિપત્રમાં લખવા અને તેને કડવા જળમાં ધોઈ નાખવા, ");
INSERT INTO guj2009_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ત્યારબાદ યાજક તે સ્ત્રીને તે પાણી પીવડાવે, જેથી તે ગુનેગાર હોય તો ખૂબ હેરાન થાય. ");
INSERT INTO guj2009_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“પણ જળ પીવડાવતાં પહેલાં યાજક પાપની કસોટી કરવા ખાધાર્પણને સ્ત્રીના હાથમાંથી લઈને યહોવા સમક્ષ ઘરાવીને વેદી પર અર્પણ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","એ પછી યાજકે તે ખાધાર્પણમાંથી એક મૂઠી ભરી વેદીમાં હોમવું. અને પછી સ્ત્રીને જળ પાઈ દેવું. ");
INSERT INTO guj2009_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","જો તે સ્ત્રીએ વ્યભિચાર કર્યો હશે તો શ્રાપનું પાણી પેટમાં જતાં જ તેનું પેટ ફૂલી જશે અને તેનું ગર્ભાશય સંકોચાઈ જશે, અને તેનું નામ તેના લોકોમાં શ્રાપરૂપ થઈ પડશે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","પણ જો તે સ્ત્રી પવિત્ર હશે અને પોતાની જાતને કલંકિત નહિ કરી હોય તો તેને કંઈ પણ હાનિ થશે નહિ અને થોડા સમય પછી તે ગર્ભ ધારણ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“આ નિયમો સ્વચ્છંદી પત્ની માંટે અથવા જેના પર પતિને વહેમ હોય એવી પત્ની માંટે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","પછી એ સ્ત્રીએ ખરેખર વ્યભિચાર કર્યો હોય કે ખાલી વહેમ આવ્યો હોય પતિએ આવી સ્ત્રીને યહોવા સમક્ષ લાવવી અને યાજકે ઉપર દર્શાવેલી રીત અનુસાર નક્કી કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","પછી સ્ત્રી જો પોતાની સજા ભોગવે તો તે માંટે પતિ જવાબદાર ઠરશે નહિ. સ્ત્રી પોતે જ તેના પાપોના પરિણામ માંટે જવાબદાર છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“તું ઇસ્રાએલી પ્રજાને આ પ્રમાંણે કહે: જો કોઈ સ્ત્રી કે પુરુષ ‘નાજીર’ થઈને યહોવાની સેવા કરવાનું ખાસ વ્રત લે, ");
INSERT INTO guj2009_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","તો યહોવાને કરેલા સમર્પણના પૂર્ણ સમય દરમ્યાન તેણે દ્રાક્ષારસનો અને કેફી પીણાનો ત્યાગ કરવો, તદુપરાંત તેણે દ્રાક્ષામાંથી બનાવેલું કોઈ પણ પ્રકારનું પીણું પીવું નહિ, કે દ્રાક્ષ કે કિસમિસ ખાવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","જયાં સુધી તેનું વ્રત ચાલુ હોય ત્યાં સુધી તેણે દ્રાક્ષમાંથી કોઈ પણ વસ્તુ દ્રાક્ષના બી કે છાલ પણ ખાવા નહિ! ");
INSERT INTO guj2009_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“વળી એ સમય દરમ્યાન તેણે વાળ કપાવવા નહિ, કારણ કે તેનું વ્રત ચાલુ હોય છે, અને જયાં સુધી વ્રત પૂરું પૂર્ણ ન થાય ત્યાં સુધી તે દેવને સમર્પિત થયેલો છે તેથી તેણે પોતાના વાળ વધારવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“તેણે લીધેલા વ્રતના સર્વ દિવસો દરમ્યાન તેણે કદી મૃતદેહ નજીક જવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","તેનાં માંતા-પિતા કે ભાઈ બહેન મરી જાય તો પણ તેણે મૃતદેહ નજીક જઈ પોતાની જાતને અશુદ્ધ કરવી નહી, કારણ તેના માંથા પરના વાળ તેના દેવના સમર્પિત થયાની નિશાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","વ્રતના પૂરા સમય દરમ્યાન તે ‘નાજીર’ વ્રતી હોવાથી ત્યાં સુધી તે યહોવાને સમર્પિત થયેલ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","પરંતુ જો કોઈ વ્યક્તિનું અચાનક તેની પડખે જ અવસાન થાય અને તે અશુદ્ધ બને, તો સાત દિવસ પછી તેણે પોતાના અશુદ્ધ થયેલા માંથાના વાળ કપાવવા. કારણ કે તે દિવસે તેની શુદ્ધિ થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","અને આઠમાં દિવસે તેણે પવિત્ર મંડપના પ્રવેશદ્વાર આગળ યાજક સમક્ષ બે હોલા અથવા કબૂતરના બે બચ્ચાં લાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","યાજકે એમાંનું એક પાપાર્થાર્પણ તરીકે અને બીજું દહનાર્પણ તરીકે ચઢાવીને તે માંણસના પાપનો પ્રાયશ્ચિતવિધિ કરવો, કારણ કે તે મૃતદેહના સ્પર્શથી અશુદ્ધ થયો હતો. તે સમયે વ્યક્તિ ફરીથી પોતાના વાળ કપાવ્યા વિના દેવને સમર્પિત કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","અને તે જ દિવસે તેણે ‘નજીરી’ ના વ્રતની નવેસરથી શરૂઆત કરીને વાળ વધારવા. આ અગાઉના તેના સમર્પણના દિવસો ગણવામાં આવશે નહિ, કારણ, તેનો વ્રતભંગ થયો હતો જેના દોષાર્થાર્પણરૂપે તેણે એક વર્ષનું નર હલવાન લાવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“યહોવાની સેવા માંટેના ‘નાજીરી’ વ્રતની સમય પૂર્ણ થતાં તે દિવસે તેણે નીચે પ્રમાંણે વિધિ કરવી; તેને પવિત્રમંડપના પ્રવેશદ્વાર આગળ લઈ જવો. ");
INSERT INTO guj2009_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","અને ખોડ વિનાના એક વર્ષનાં નર ઘેટાનું દહનાર્પણ, ખોડ વિનાની એક વર્ષની ઘેટીનું પાપાર્થાર્પણ અને ખોડ વિનાના નર ઘેટાનું શાંત્યાર્પણ કરવું: ");
INSERT INTO guj2009_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","તથા એક ટોપલી ભરીને મોહેલા લોટની બેખમીર રોટલી તથા તેલ ચોપડેલા બેખમીર ખાખરા, અને ખાધાર્પણ તથા પેયાર્પણ તે ચઢાવે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“યાજકે આ બધું યહોવાને ઘરાવવું અને તે માંણસનાં પ્રથમ પાપાર્થાર્પણ અને દહનાર્પણ ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","પછી તેણે નર ઘેટાને યહોવા સમક્ષ શાંત્યાર્પણ તરીકે સમર્પિત કરવું. રોટલીની ટોપલી, ખાધાર્પણ અને પેયાર્પણ સાથે તે યહોવાને અર્પણ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“નાઝારી વ્રત ધારણ કરનારે પવિત્રમંડપના પ્રવેશદ્વાર આગળ વાળ કપાવી નાખવાં, અને એ સમર્પિત કરી શાંત્યાર્પણની નીચેના અગ્નિમાં હોમી દેવા. ");
INSERT INTO guj2009_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“વ્રતધારીએ વાળ ઉતરાવ્યા પછી યાજકે નર ઘેટાનો બાફેલો ખભો તથા ટોપલીમાંથી એક બેખમીર રોટલી અને એક બેખમીર ખાખરો લઈને તેના હાથમાં મૂકવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ત્યારવાદ યાજક અર્પણ તરીકે એ વસ્તુઓ યહોવાની સમક્ષ ઝુલાવે. એ અર્પણો યાજકને માંટેનો પવિત્ર ભાગ ગણાય છે. એની ઉપરાંત, ઘેટાની છાતીનો ભાગ અને જાંધ દેવને ઘરવા, આ અર્પણો પણ યાજકના ગણાય, હવે તે વ્યક્તિ નાજીરી વ્રતમાંથી મુક્ત થઈને ફરી દ્રાક્ષારસ પી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“નાજીરી માંટે અને બલિદાનો માંટેના આ નિયમો છે. નાજીરી થવાની પ્રતિજ્ઞા લીધી હોય ત્યારે તેણે અન્ય અર્પણો માંટે વચન આપ્યું હોય તો નક્કી કરેલાં બલિદાનો સાથે તે અર્પણો પણ લાવીને ચઢાવવાં.” ");
INSERT INTO guj2009_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“હારુન અને તેના પુત્રોને કહે કે, તેઓ ઇસ્રાએલી પ્રજાને આ ખાસ આશીર્વાદ આપે: ");
INSERT INTO guj2009_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘યહોવા તમને આશીર્વાદ આપો અને તમાંરું રક્ષણ કરો; ");
INSERT INTO guj2009_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","યહોવાની તમાંરા પર કૃપાદૃષ્ટિ અને મહેરબાની થાવ. ");
INSERT INTO guj2009_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","યહોવા તમાંરા પર પ્રસન્ન હો અને તમને શાંતિ આપો.’” ");
INSERT INTO guj2009_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","પછી યહોવાએ મૂસાને કહ્યું, “આ રીતે હારુન અને તેના પુત્રો માંરા આશીર્વાદ ઇસ્રાએલી લોકોને આપે અને હું પોતે વ્યક્તિગત માંરા આશીર્વાદ તેઓને આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","જે દિવસે મૂસાએ પવિત્રમંડપ ઊભો કરવાનું કાર્ય સંપૂર્ણ કર્યુ, તે દિવસે તેણે મંડપનો તેમજ તેમાંની બધી સાધન-સામગ્રી વેદી તથા તેનાં બધાં સાધનોનો અભિષેક કરી તેમના બધાં પાત્રોનો અભિષેક કરીને પવિત્ર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ત્યારપછી ઇસ્રાએલનાં કુળસમૂહોના આગેવાનોમાંથી પસંદ કરેલા પુરુષો પોતાનાં અર્પણો લાવ્યા. તેઓ કુળોના મુખ્ય આગેવાનો હતાં અને તેઓએ વસ્તી ગણતરીના કામમાં મદદ કરી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","તેમણે યહોવાની સંમુખ બે બળદ જોડેલા છત્તરાવાળાં છ ગાડાં તેઓ લાવ્યા બે કુટુંબના વડાઓ દીઠ એક ગાડું અને પ્રત્યેક આગેવાન દીઠ એક બળદ. આ બધુ તેઓએ પવિત્ર મંડપમાં પ્રવેશદ્વાર પાસે યહોવાની સમક્ષ રજૂ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“તેઓની ભેટોનો સ્વીકાર કર, મુલાકાતમંડપની સેવામાં આ ગાડાનો ઉપયોગ કરજે. લેવીઓને તું એ તેમના કાર્યમાં ઉપયોગ કરે, તે માંટે તેમણે બજાવવાની સેવા અનુસાર સોંપી દેજે.” ");
INSERT INTO guj2009_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","તેથી મુસાએએ ગાડાં અને બળદો સ્વીકાર્યા અને લેવીઓને સોંપી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","તેણે ગેર્શોનના સમૂહને તેઓને જે સેવાઓ કરવાની હતી તે માંટે બે ગાડાં અને ચાર બળદો આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","મરારીના સમૂહે યાજક હારુનના પુત્ર ઈથામાંરની આગેવાની હેઠળ જે સેવાએ કરવાની હતી તેને માંટે તેણે તેમને ચાર ગાડાં અને આઠ બળદો આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","પરંતુ કહાથના વંશજોને કાંઈ જ આપ્યું નહિ, કારણ કે તેઓને જે પવિત્ર વસ્તુઓ સોંપવામાં આવી હતી તેની જવાબદારી તેઓ પોતાના માંથે જ રાખતા અને પોતાના ખભા ઉપર ઊચકી લેતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","જે દિવસે યજ્ઞવેદીને અભિષિક્ત અને સમર્પિત કરવામાં આવી તે દિવસે આગેવાનો પોતાના અર્પણો લાવ્યા અને વેદી આગળ રજૂ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","યહોવાએ મૂસાને કહ્યું, “વેદીની પ્રતિષ્ઠા કરવા સારું અર્પણ વારાફરતી એક દિવસે એક જણેજ ધરાવવા.” ");
INSERT INTO guj2009_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","પ્રત્યેક વંશના આગેવાન એક સરખાં જ અર્પણ લઈને આવ્યાં. પ્રથમ દિવસે યહૂદાના કુળસમૂહનો આગેવાન આમ્મીનાદાબનો પુત્ર નાહશોન અર્પણ લઈને આવ્યો. બીજે દિવસે ઈસ્સાખાર વંશનો સૂઆરનો પુત્ર નથાનિયેલે અર્પણ લઈને આવ્યો. ત્રીજે દિવસે ઝબુલોનના વંશનો વડો અને હેલોનનો પુત્ર અલીઆબ અર્પણ લાવ્યો. ચોથે દિવસે રૂબેન વંશનો શદેઉરનો પુત્ર અલીસૂર અર્પણ લાવ્યો. પાંચમે દિવસે શિમયોન વંશના વડા સૂરીશાદાયના પુત્ર શલુમીએલે અર્પણ લાવીને ઘરાવ્યું. છઠ્ઠે દિવસે ગાદના વંશના વડા દેઉએલના પુત્ર એલ્યાસાફે અર્પણ લાવીને ઘરાવ્યું. સાતમે દિવસે એફ્રાઈમના વંશના વડા આમ્મીહૂદના પુત્ર અલીશામાંએ અર્પણ લાવીને ધરાવ્યું. આઠમાં દિવસે મનાશ્શા વંશના વડા પદાહસૂરના પુત્ર ગમાંલ્યેલ અર્પણ લાવીને ધરાવ્યું. નવમાં દિવસે બિન્યામીન વંશના વડા ગિદિયોનીના પુત્ર અબીદાને અર્પણ લાવીને ધરાવ્યું. દશમે દિવસે દાનના વંશના વડા આમ્મીશાદાયના પુત્ર અહીએઝેર અર્પણ ધરાવ્યું. અગિયારમે દિવસે આશેરના વંશના વડા ઓક્રાનના પુત્ર પાગીએલે અર્પણ લાવીને ધરાવ્યું. બારમે દિવસે નફતાલીના વંશના વડા એનાનના પુત્ર અહીરાએ અર્પણ લાવીને ધરાવ્યું. પ્રત્યેકના ઉપહારમાં અધિકૃત માંપ પ્રમાંણે 130 શેકેલ વજનની ચાંદીની કથરોટ તથા 70 શેકેલ વજનનો એક ચાંદીનો પ્યાલો હતો. આ બંનેમાં ખાધાર્પણ તરીકે તેલથી મોયેલો લોટ ભરેલો હતો. તદુપરાંત દશ શેકેલ વજનની સોનાની ધૂપદાની ધૂપથી ભરેલી હતી, તથા દહનાર્પણ માંટે એક વર્ષનું વાછરડું, તથા પ્રાયશ્ચિતના બલિ માંટે એક ઘેટું તથા એક વર્ષનો એક હલવાન; શાંત્યર્પણ માંટે બે બળદ, પાંચ ઘેટા, પાંચ લવારા અને એક વર્ષની ઉપરના પાંચ હલવાન હતાં. ઉપરના ક્રમાંનુસાર આગેવાનો ઉપર પ્રમાંણેનાં અર્પણો લાવ્યાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","આ રીતે વેદીના અભિષેકના પ્રસંગે ઇસ્રાએલના વંશના આગેવાનો સમર્પણવિધિમાં પોતપોતાનાં અર્પણો લાવ્યાં; ચાંદીની 12 કથરોટ, ચાંદીના 12 પ્યાલા, તથા સોનાની 12 ધૂપદાનીઓ, ");
INSERT INTO guj2009_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ચાંદીની પ્રત્યેક કથરોટનું વજન અધિકૃત માંપ અનુસારે 130 શેકેલ હતું, અને ચાંદીના પ્રત્યેક પ્યાલાનું વજન 70 શેકેલ હતું. ચાંદીની કથરોટો અને ચાંદીના પ્યાલાઓનું કુલ વજન 2,400 શેકેલ હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","તદુપરાંત ધૂપથી ભરેલાં 12 સોનાનાં પાત્રો હતાં, તે પ્રત્યેકનું વજન અધિકૃત માંપ પ્રમાંણે દશ શેકેલ હતું. એ પાત્રોના સોનાનું કુલ વજન મંદિરના માંપ પ્રમાંણે 120 શેકેલ હતું, ");
INSERT INTO guj2009_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","દહનાર્પણો માંટે કુલ 12 બળદો, 12 ઘેટાઓ એક વર્ષની ઉમરના 12 હલવાન હતા. પાપાર્થાપણ માંટે 12 નર બકરાં પણ હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","તથા શાંત્યર્પણ માંટે કુલ 24 બળદો, 60 ઘેટા, 60 બકરાં, અને એક વર્ષની ઉમરના 60 હલવાન હતા, આ અર્પણો વેદીનો અભિષેક કરી તેના સમર્પણના પ્રસંગે અર્પણ થયા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","જે સમયે મૂસા યહોવા સાથે વાત કરવા માંટે પવિત્રમંડપમાં પ્રવેશ્યો તે સમયે તેણે કરારકોશના ઢાંકણા ઉપરના બે કરૂબ દેવદૂતોની વચ્ચેનો અવાજ સાંભળ્યો. યહોવા આ રીતે તેની સાથે બોલતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“તું હારુનને જણાવ કે તે દીપવૃક્ષની સાત દીવીઓને પ્રગટાવે ત્યારે તેનો પ્રકાશ દીપવૃક્ષના આગળના ભાગમાં પડે તે ધ્યાનમાં રાખજે.” ");
INSERT INTO guj2009_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","હારુને યહોવાની સૂચના પ્રમાંણે કર્યુ. તેણે દીવીઓને ઉચિત સ્થાને રાખી અને તેમનું મોઢું એવી રીતે રાખ્યું અને દીપવૃક્ષનો આગળનો ભાગ પ્રકાશીત કર્યો. આ તેણે દેવે મૂસાને કરેલ આજ્ઞા પ્રમાંણે કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","દીપવૃક્ષ તથા ફૂલોથી સુશોભિત તેની બેઠક તથા ડાળીઓ, સંપૂર્ણ સોનાના ધડેલા હતાં. મૂસાને યહોવાએ દર્શાવેલા નમૂના પ્રમાંણે ખૂબ કાળજીપૂર્વક તે બનાવવામાં આવી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“હવે બાકીના ઇસ્રાએલીઓમાંથી લેવીઓને અલગ કરીને તારે તેઓની વિધિપૂર્વક શુદ્ધિ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","એમની શુદ્ધિ આ મુજબ કરવી: પ્રથમ તેના પર પવિત્ર શુદ્ધિકરણનાં જળનો છંટકાવ કરવો. ત્યારબાદ તેમણે આખા શરીરે મૂડન કરાવવું, કપડા ધોઈ નાખવાં તથા શીરને ધોઈને સ્વચ્છ કરવું ત્યારે તેમની શુદ્ધિ થઈ ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“ત્યારબાદ તેમણે એક વાછરડું તથા મોયેલા લોટનો ખાધાર્પણ લાવવો, અને સાથે તારે એક બીજો વાછરડો પાપાર્થાર્પણ માંટે પણ લેવો, પછી લેવીઓને મુલાકાત મંડપ પાસે લાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","પછી બધા મુલાકાતમંડપ આગળ ઇસ્રાએલીઓના સમગ્ર સમાંજને ભેગો કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","અને તું લેવીઓને યહોવા સમક્ષ લાવે ત્યારે ઇસ્રાએલીઓએ પોતાના હાથ લેવીઓના મસ્તક પર મૂકવા, ");
INSERT INTO guj2009_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","પછી હારુને લેવીઓને ઇસ્રાએલીઓ તરફથી ખાસ ઉપહાર તરીકે મને ધરાવવા અને માંરી સેવા માંટે સમર્પિત કરવા. ઇસ્રાએલી પ્રજાના પ્રતિનિધિ તરીકે લેવીઓ યહોવાની સેવા કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ત્યારબાદ લેવીએ બંને બળદોના માંથા પર હાથ મૂકવા અને એક બળદ પાપાર્થાર્પણ તરીકે અને બીજો દહનાર્પણ તરીકે યહોવાને ધરાવવા, લેવીઓને શુદ્ધ કરવા માંટે પ્રાયશ્ચિત કરવાની આ વિધિ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","પછી સર્વ લેવીઓને હારુન અને તેના પુત્રો સમક્ષ ઉભા કરવા અને યહોવાને ઉપાસના તરીકે ધરાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","આ રીતે તારે લેવીઓને બીજા ઇસ્રાએલીઓથી અલગ કરીને વિધિસર મને અર્પણ કરવા, જેથી લેવીઓ માંરા પોતાના થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“આ પ્રમાંણે લેવીઓનું શુદ્ધિકરણ અને અરત્યર્પણ થયા પછી જ તેઓ મુલાકાતમંડપમાં સેવા કરવાનું શરૂ કરી શકે. તારે લેવીઓની શુદ્ધ કરીને મને સમર્પિત કરવા. ");
INSERT INTO guj2009_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","કારણ કે બધાં જ ઇસ્રાએલીઓ તરફથી તેઓ મને ઈનામરૂપે અપાયેલા છે. તેથી તેઓ માંરા પોતાના છે. ઇસ્રાએલી કુળના સર્વ પ્રથમજનિતોના બદલામાં મેં લેવીઓનો સ્વીકાર કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","કારણ કે ઇસ્રાએલીઓનું પ્રથમજનિત બાળક પછી તે મનુષ્યનું હોય કે પશુનું હોય, માંરું છે, જે દિવસે મેં મિસરના એકેએક પ્રથમજનિત બાળક, પછી તે મનુષ્યનું હોય કે પશુનું હોય, સર્વને માંરી નાખ્યાં, તે દિવસે મેં ઇસ્રાએલનાં પ્રથમજનિત પુત્રોને મેં માંરા માંટે રાખી લીધા હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","હવે મેં ઇસ્રાએલ સમાંજના સર્વ જ્યેષ્ઠ પુત્રોની અવેજીમાં લેવીઓને સ્વીકાર્યો છે, ");
INSERT INTO guj2009_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","હું તેમને હારુનને તથા તેના પુત્રોને ઇસ્રાએલીઓ તરફથી સેવા કરવા અને તેમના બદલે પ્રાયશ્ચિતવિધિ કરવા મુલાકાત મંડપમાં ભેટો તરીકે આપીશ. જેથી જ્યારે ઇસ્રાએલીઓ પવિત્રસ્થાનની પાસે આવે ત્યારે મરકી કે કોઈ મુશ્કેલી તેમના પર ન પડે.” ");
INSERT INTO guj2009_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","પછી યહોવાએ મૂસાને લેવીઓની દીક્ષાવિધી વિષે જે સૂચનાઓ આપી હતી તેનો મૂસાએ, હારુને તથા સમગ્ર ઇસ્રાએલી સમાંજે અમલ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","લેવીઓએ પોતાની જાતને શુદ્ધ કરી અને વસ્ત્રો પણ ધોયાં. હારુને તે સૌને અર્પણ તરીકે યહોવાને ધરાવી દીધા, અને તેમને શુદ્ધ કરવા માંટે પ્રાયશ્ચિતવિધિ કરીને સૌને શુદ્ધ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ત્યારવાદ લેવીઓને મુલાકાતમંડપમાં હારુન અને તેના પુત્રોના હાથ નીચે સેવા કરવાની છૂટ મળી. આમ યહોવાએ લેવીઓ અંગે જે આજ્ઞાઓ મૂસાને જણાવી હતી તેનું અક્ષરસ: પાલન કરવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“પચ્ચીસ વર્ષની ઉમરે લેવીઓ મૂલાકાતમંડપની સેવા શરૂ કરી શકે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","પચાસ વર્ષની ઉમરે તેઓ સેવામાંથી નિવૃત્ત થાય અને સેવા કરવાનું બંધ કરે. ");
INSERT INTO guj2009_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","તેઓ મુલાકાતમંડપમાં સેવા કરતા પોતાના સાથીને ભલે મદદ કરે, પણ પોતે નિયમસરની સેવા ન કરે, લેવીઓની સેવા માંટે આ વ્યવસ્થાનું આયોજન કરવું.” ");
INSERT INTO guj2009_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","મિસરમાંથી પ્રસ્થાન કર્યા પછી બીજા વર્ષના પ્રથમ મહિનામાં ઇસ્રાએલી પ્રજા અને મૂસા સિનાઈના અરણ્યમાં હતા ત્યારે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ઇસ્રાએલી પ્રજાએ નિયત સમયે પાસ્ખાપર્વ પાળવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","પાસ્ખાપર્વ પ્રથમ મહિનામાં ચૌદમાં દિવસની સંધ્યાઓ શરૂ થાય છે. તમાંરે એને લગતા બધા નિયમો અને વિધિઓનું ચુસ્તપણે પાલન કરવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","તેથી મૂસાએ ઇસ્રાએલી પ્રજાને પાસ્ખાપર્વ ઉજવવાની આજ્ઞા કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ઇસ્રાએલી પ્રજાએ પાસ્ખા પર્વની ઉજવણી સિનાઈના અરણ્યમાં પ્રથમ મહિનાના ચૌદમાં દિવસે સંધ્યાકાળે શરૂ કરી હતી. યહોવાએ મૂસાને સૂચવ્યું હતું તે મુજબ ઇસ્રાએલીઓએ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","પરંતુ એવું બન્યું કે કેટલાક માંણસો મૃતદેહના સ્પર્શથી અશુદ્ધ થયા હતા, તેઓ દફનક્રિયામાં હતા તેથી તે દિવસે પાસ્ખાપર્વ પાળી શકે એમ નહોતું. તેમણે તે જ દિવસે મૂસા અને હારુનની પાસે જઈને પોતાની હકીકત દર્શાવી. ");
INSERT INTO guj2009_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","તેઓએ મૂસાને કહ્યું, “અમે મૃત દેહના સ્પર્શથી અશુદ્ધ થયેલા છીએ. સર્વ ઇસ્રાએલીઓ નિયત સમયે યહોવાને બલિદાન અર્પણ કરે છે. તે અમને શા માંટે તેમ કરવાની મનાઈ કરવામાં આવે છે?” ");
INSERT INTO guj2009_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","મૂસાએ તેમને કહ્યું, “તમાંરી બાબતમાં યહોવાની આજ્ઞા શી છે તે હું જાણી લઉ ત્યાં સુધી તમે ધીરજ ધરો.” ");
INSERT INTO guj2009_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“તારે ઇસ્રાએલીઓને આ પ્રમાંણે કહેવું કે: તમાંરામાંથી અથવા તમાંરા વંશજોમાંથી કોઈ મૃતદેહના સ્પર્શને કારણે અશુદ્ધ થયો હોય અથવા દૂર પ્રવાસમાં હોય, તો પણ માંરા માંનમાં પાસ્ખા નીચે પ્રમાંણે પાળી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","આવા લોકો બીજા મહિનાના ચૌદમાં દિવસે સંધ્યાકાળે ઉજવણી શરૂ કરી શકે છે. તેઓએ અર્પણ કરેલુ હલવાન બેખમીર રોટલી તથા કડવી ભાજી સાથે ખાવું; ");
INSERT INTO guj2009_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","એમાંનું કશું સવાર સુધી રહેવા દેવું નહિ, તેમજ એ બલિના પશુનું કોઈ હાડકું ભાંગવું પણ નહિ. તેમણે એ પાસ્ખાને લગતા બધા નિયમો અને વિધિઓનું પાલન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","પરંતુ જો કોઈ વ્યક્તિ અશુદ્ધ ના હોય તે લાંબા પ્રવાસમાં હોય અને પાસ્ખાનું પાલન ન કરે, તો તેને તેના લોકોથી જુદો કરવો. કારણ, એણે નિયત સમયે યહોવાને બલિદાન અર્પણ નથી કર્યુ, તેથી તે દોષિત ગણાય અને એનું પાપ એણે ભોગવવું જ જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“પરંતુ તમાંરી વચ્ચે કોઈ વિદેશી રહેતો હોય અને તે પાસ્ખા ઊજવવા ઈચ્છતો હોય તો તેણે પણ એના બધા નિયમો અને વિધિઓ પ્રમાંણે એ ઊજવવું જોઈએ. દેશના વતનીઓ તથા વિદેશીઓ સૌને માંટે એક જ નિયમ છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","જે દિવસે કરારનો પવિત્રમંડપ એટલે કરારમંડપ ઊભો કરવામાં આવ્યો તે જ દિવસે તેના પર વાદળે આચ્છાદન કર્યુ. અને સાંજે વાદળનું સ્થાન અગ્નિએ લીધું અને આખી રાત તે ઝળહળતો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","આ પ્રમાંણે હંમેશા થતું રહ્યું. દિવસે વાદળ આચ્છાદન કરતો અને રાત્રે અગ્નિની જેમ ઝળહળતું. ");
INSERT INTO guj2009_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","જ્યારે જ્યારે પવિત્ર મંડપ ઉપરથી વાદળ હઠી જતું, ત્યારે ત્યારે ઇસ્રાએલી પ્રજા મુકામ ઉઠાવતી, અને આગળ મુસાફરી કરતી અને જયાં જયાં વાદળ થોભે ત્યાં ત્યાં મુકામ કરતી. ");
INSERT INTO guj2009_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","આમ યહોવાની આજ્ઞા પ્રમાંણે તેઓ મુકામ ઉઠાવતા મુસાફરી કરતા અને મુકામ કરતા. જયાં સુધી વાદળનું આચ્છાદન લાંબા સમય સુધી રહે તો ત્યાં સુધી તેઓ મુકામ ચાલુ રાખતા. ");
INSERT INTO guj2009_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","જો વાદળ લાંબા સમય સુધી પવિત્રમંડપ પર રહેતું તો ઇસ્રાએલી પ્રજા યહોવાની આજ્ઞા માંથે ચઢાવીને આગળ પ્રવાસ કરતી નહિ અને લાંબા સમય સુધી ત્યાં જ રોકાતી. ");
INSERT INTO guj2009_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","પરંતુ કેટલીક વખત વાદળ થોડા દિવસ જ મુલાકાત મંડપ પર રહેતું ત્યારે પણ તેઓ યહોવાની આજ્ઞા થતાં મુકામ કરતા અને યહોવાની આજ્ઞા થતા મુકામ ઉઠાવતા. ");
INSERT INTO guj2009_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","કેટલીક વખત વાદળ સાંજથી સવાર સુધી રહેતું, સવારે વાદળ હઠતાં જ તેઓ મુકામ ઉઠાવતા, અને તેને અનુસરતાં. જો તે રાતના હઠતાં તો તેને અનુસરતા. ");
INSERT INTO guj2009_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","જયાં સુધી વાદળ પવિત્રમંડપ પર ભલે રહે પછી એ બે દિવસ માંટે હોય, એક મહિના માંટે હોય કે એક વર્ષ માંટે હોય ત્યાં સુધી ઇસ્રાએલીઓ મુકામ ઉઠાવતા નહિ; જયારે વાદળ હઠતું ત્યારે જ તેઓ મુકામ ઉઠાવી પ્રવાસ કરતા. ");
INSERT INTO guj2009_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","આમ તેઓ યહોવાની આજ્ઞા અનુસાર છાવણી કરતાં અથવા પ્રવાસ કરતા, યહોવા મૂસા દ્વારા તેઓને જે આજ્ઞા કરે તે પ્રમાંણે તેઓ કરતા. ");
INSERT INTO guj2009_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“બે ચાંદીનાં ધડેલાં રણશિંગડાં બનાવડાવ અને લોકોને ભેગા થવા કહેવા માંટે તથા પડાવને આગળ વધવા કહેવા માંટે તેનો ઉપયોગ કરજે. ");
INSERT INTO guj2009_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","જે સમયે બંને રણશિંગડા વગાડવામાં આવે, ત્યારે સમગ્ર સમાંજે મુલાકાતમંડપના પ્રવેશદ્વાર આગળ તારી સમક્ષ એકત્ર થવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","પરંતુ જો એક જ રણશિંગડું વગાડવામાં આવે, તો ફકત ઇસ્રાએલ પ્રજાના કુળોના મુખ્ય આગેવાનોએ તારી સમક્ષ આવવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“જ્યારે પહેલીવાર તૂટક તૂટક રણશિંગડાં વગાડવામાં આવે, ત્યારે પૂર્વ દિશામાં નાખેલી છાવણીઓએ કૂચ કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","બીજી વખતે રણશિંગડાં તૂટક તૂટક વાગે, ત્યારે દક્ષિણ દિશામાંની છાવણીએ કૂચ કરવી. આમ મુકામ ઉઠાવવાના સંકેત તરીકે તૂટક તૂટક રણશિંગડું વગાડવું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","પણ ઇસ્રાએલ સમાંજને સભા માંટે એકત્ર થવા જણાવવું હોય તો એકધારું રણશિંગડું વગાડવું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","હારુનના વંશજોએ એટલે કે યાજકોએ જ રણશિંગડાં વગાડવાનાં છે. આ કાયમી કાનૂનનો અમલ તમાંરે પેઢી દરપેઢી કરવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“તમાંરી ભૂમિમાં દુશ્મનો સાથે લડતા પહેલાં જોરથી રણશિંગડા ફૂંકો, ત્યારે યહોવા રણશિંગડાંનો અવાજ સાંભળશે અને તમને યાદ કરશે અને તમને તમાંરા દુશ્મનોથી બચાવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","વળી ઉત્સવો વખતે, દર અમાંસના દિવસે તેમજ તમે દહનાર્પણે અને શાંત્યર્પણો ધરાવો તે દિવસે પણ રણશિંગડાં વગાડવાં, યહોવા તમને સંભારે તે માંટે આમ કરો. હું તમાંરો દેવ યહોવા, તમને સંભારીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ઇસ્રાએલીઓ મિસરમાંથી પ્રસ્થાન કરી આવ્યા તેના બીજા વર્ષના બીજા મહિનાના વીસમાં દિવસે કરારના પવિત્રમંડપ ઉપરથી વાદળ હઠી ગયું અને ");
INSERT INTO guj2009_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ઇસ્રાએલી પ્રજાએ સિનાઈના અરણ્યમાંથી કૂચ શરૂ કરી ત્યાં તો પારાનના અરણ્યમાં વાદળ પાછુ સ્થિર થયું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","યહોવા તરફથી મૂસાને યાત્રા સંબંધી સૂચનાઓ મળ્યા પછીની તેઓની આ પ્રથમ યાત્રા હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","કૂચ વખતે યહૂદાના વંશના ધ્વજ નીચેનું સૈન્ય પ્રથમ ચાલતું: આમ્મીનાદાબનો પુત્ર નાહશોન તેમનો આગેવાન હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","તેઓની પાછળ ઈસ્સાખારના કુળસમૂહનું સૈન્ય હતું, જેનો આગેવાન સૂઆરનો પુત્ર નથાનિયેલ હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","અને હેલોનના પુત્ર અલીઆબની સરદારી હેઠળ ઝબુલોનના કુળસમૂહનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ત્યાર પછી પવિત્ર મંડપ ઉઠાવી લેવામાં આવતો અને તેને ઉપાડનાર ગેર્શોન તથા મરારીના વંશજો કૂચ કરતા. પવિત્રમંડપને ઉતારીને તેઓ પોતાના ખભા ઉપર ઊચકીને ચાલતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","એ પછી રૂબેનના કુળસમૂહના ધ્વજ હેઠળની સેના કુટુંબવાર કૂચ કરતી: શદેઊરનાં પુત્ર અલીસૂરની સરદારી હેઠળ રૂબેનના કુળસમૂહોનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","તેમની પાછળ સૂરીશાદાઈના પુત્ર શલુમીએલની સરદારી હેઠળ શિમયોનના કુળસમૂહોની સેના હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","અને તે પછી દેઊએલના પુત્ર એલ્યાસાફની સરદારી હેઠળ ગાદના કુળસમૂહોનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","તેઓની પાછળ કહાથના વંશજો પવિત્રસ્થાનમાંની વિવિધ સાધનસામગ્રી ઊચકીને ચાલતા હતા. તેઓ બીજે મુકામે પહોંચે તે પહેલાં ત્યાં પવિત્રમંડપ ઊભો કરી દેવામાં આવતો. ");
INSERT INTO guj2009_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","તેમની પાછળ એફ્રાઈમના વંશના ધ્વજ હેઠળનું સૈન્ય કૂચ કરતું. આમ્મીહૂદના પુત્ર અલીશામાંની સરદારી હેઠળ એફ્રાઈમના વંશજોનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","તે લોકોની પાછળ પદાહસૂર ના પુત્ર ગમાંલ્યેલની ગણતરી હેઠળ મનાશ્શાના કુળસમૂહોનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ગિદિયોનીના પુત્ર અબીદાનની સરદારી હેઠળ બિન્યામીનના કુળસમૂહોનું સૈન્ય હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","છેક છેવટે રક્ષક તરીકે દાનના વંશના ધ્વજ હેઠળ બધી સેનાઓના રક્ષક તરીકે ટુકડીવાર કૂચ કરતી. આમ્મીશાદાયનો પુત્ર અહીએઝેર તે ટુકડીનો આગેવાન હતો. તેની સરદારી હેઠળ દાનના કુળસમૂહોની ટુકડી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ઓફ્રાનના પુત્ર પાગીએલની સરદારી હેઠળ આશેરના કુળસમૂહોની ટુકડી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","અને એનાનના પુત્ર અહીરાની સરદારી હેઠળ નફતાલીના કુળસમૂહોની ટુકડી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","હંમેશા આ ક્રમમાં જ ઇસ્રાએલના કુળ ટુકડીવાર કૂચ કરતા. ");
INSERT INTO guj2009_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","એક દિવસ મૂસાના સસરા મિધાની રેઉએલના પુત્ર હોબાબને મૂસાએ કહ્યું, “છેવટે દેવે અમને જે દેશ આપવાનું વચન આપ્યું હતું ત્યાં જવા માંટે અમે પ્રસ્થાન કરીએ છીએ. તમે પણ અમાંરી સાથે ચાલો. અમે તમાંરા શુભચિંતક બનીશું; કારણ કે યહોવાએ ઇસ્રાએલને અદભુત સુરક્ષા અને જનસમૂહ માંટે વચનો આપ્યાં છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","હોબાબે પ્રત્યુત્તર આપ્યો, “ના, હું તમાંરી સાથે નહિ આવું. હું તો માંરા પોતાના દેશમાં માંરાં સંગાઓ પાસે પાછો જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","મૂસાએ વિનંતી કરી કહ્યું, “અમને છોડીને ન જશો, કારણ કે અરણ્યમાં કેવા રસ્તાઓ છે તે તું જાણે છે, ક્યાં મુકામ કરવો તે પણ તમે જાણો છો એટલે તમે તો અમાંરી આંખ બની રહેશો. ");
INSERT INTO guj2009_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","અને જો તમે અમાંરી સાથે આવશો, તો યહોવા અમને જે સુખસંપત્તિ આપશે તેમાં અમે તમને ભાગીદાર બનાવીશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","અને હોબાબ સંમત થયો, ત્યારબાદ તેમણે યહોવાના સિનાઈ પર્વતથી નીકળી ત્રણ દિવસ યાત્રા કરી. તે ત્રણે દિવસ દરમ્યાન યહોવાના પવિત્ર કોશ તેમને માંટે મુકામ કરવાની જગ્યા શોધવા સૌથી આગળ રહેતો. ");
INSERT INTO guj2009_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","જયારે તેઓ મુકામ ઉઠાવતા ત્યારે તે દિવસે યહોવાનું વાદળ તેમના ઉપર રહેતું. ");
INSERT INTO guj2009_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","જયારે જયારે કરારકોશ ચાલી નીકળતો, ત્યારે મૂસા પોકાર કરતો: “હે યહોવા, તમે ઊઠો અને તમાંરા દુશ્મનોને વેરવિખેર કરી નાખો, અને તમાંરો તિરસ્કાર કરનારને હાંકી કાઢો.” ");
INSERT INTO guj2009_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","અને જયારે કરારકોશને નીચે મૂકવામાં આવતો ત્યારે તે કહેતો; “લાખો ઇસ્રાએલીઓ વચ્ચે, હે યહોવા, પાછા પધારજો.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","લોકો પોતાની હાડમાંરીઓની ફરિયાદો યહોવા સમક્ષ કરવા લાગ્યા. યહોવા તે સાંભળીને તેઓના પર ગુસ્સે થયો. યહોવાનો અગ્નિ છાવણીના છેવાડેના લોકો વચ્ચે ભડભડી ઊઠયો અને તેનો છેડો બળી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","લોકોએ મૂસાને સહાય માંટે પોકાર કરી, તેથી તેણે લોકો માંટે યહોવાને પ્રાર્થના કરી તેથી અગ્નિ શાંત થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ત્યારબાદ તે જગ્યાનો વિસ્તાર તાબએરાહ નામે પ્રચલિત થયો. કારણ, ત્યાં યહોવાનો અગ્નિ તે લોકોની વચ્ચે ભડભડી ઊઠયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ઇસ્રાએલીઓ સાથેના કેટલાક લોકો સારું સારું ખાવાના લાલચુ હતા; તેઓને મિસરનો ખોરાક યાદ આવ્યો. ઇસ્રાએલીઓમાં પણ અસંતોષ વધતાં તેઓએ રોદણાં રડવા લાગ્યા. “અરે! અમને ખાવા માંટે માંસ કોણ આપશે? ");
INSERT INTO guj2009_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","મિસરમાં તો અમે મફતમાં મજાથી માંછલીઓ ખાતા હતા, ત્યાં તો કાકડી, તડબૂચ, ડુંગળી, પ્યાજ અને લસણ પણ મળતાં હતા! ");
INSERT INTO guj2009_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","અહીં તો અમાંરા શરીર દિવસે દિવસે નબળા પડી ગયા છે. દરરોજ ફકત આ માંન્ના જ અમને મળે છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","માંન્નાનું કદ ધણાના દાણા જેટલું હતું. તેનો રંગ પીળાશ પડતો ધોળો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","લોકો ખેતરમાં ફરીને માંન્ના વીણીને એકત્ર કરી લાવતા અને ઘંટીમાં દળતા અથવા ખાંડણિયામાં ખાંડી લેતા અને લોટ બનાવીને તેને તપેલીમાં બાફીને તેની ભાખરી બનાવતા. ");
INSERT INTO guj2009_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","એનો સ્વાદ મોવણ નાખેલી ભાખરી જેવો લાગતો. રાતના સમયે છાવણી ઉપર ઝાકળ પડતું ત્યારે તેની સાથે માંન્ના પણ પડતું. ");
INSERT INTO guj2009_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","મૂસાએ બધા લોકોને પોતપોતાના તંબુના બારણા આગળ ઊભા રહીને રોદણાં રડતા સાંભળ્યા. યહોવાનો ક્રોધ ભભૂકી ઊઠતા મૂસા પણ ભારે ચિંતામાં પડયો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","મૂસાએ યહોવાને કહ્યું, “તમે માંરી આવી ભૂંડી દશા શા માંટે કરી? તમને દ્વિધા થાય એવું મે શું કર્યુ છે? સમગ્ર ઇસ્રાએલી લોકોની જવાબદારી લેવા તમે મને કેમ પસંદ કર્યો? ");
INSERT INTO guj2009_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","શું હું તેઓનો પિતા છું? શું તે બધાં માંરાં બાળકો છે? તમે તેઓના પિતૃઓને જે દેશ આપવાનું વચન આપ્યું હતું તે દેશમાં તમે, કોઈ ધાવણા બાળકને છાતીએ વળગાડીને લઈ જાય તેમ તેઓની સંભાળ રાખવાનું કાર્ય મને શા માંટે સૌપ્યું છે? ");
INSERT INTO guj2009_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","આ બધા લોકોને માંટે મને માંસ કયાંથી મળી શકે? તેઓ રૂદન કરીને મને કહે છે, ‘અમને માંસ આપો.’ પણ માંરે આ લોકો માંટે માંસ લાવવું કયાંથી? ");
INSERT INTO guj2009_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","હવે હું એકલો આ સમગ્ર પ્રજાનો ભાર સહન કરવા અસમર્થ છું. ");
INSERT INTO guj2009_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","જો માંરી પાસેથી તમે આ બધું કામ કરાવવા માંગતા હો, તો કૃપા કરીને હમણા જ મને માંરી નાખો; તમે માંરા ઉપર ભલાઈ કરતા હો, તો મને આગળ પણ દુઃખ ન જોવા દેતા.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","પછી યહોવાએ મૂસાને કહ્યું, “ઇસ્રાએલના સિત્તેર વડીલોને માંરી સમક્ષ મુલાકાત મંડપ આગળ લઈ આવ જેઓને વિષે તને ખાતરી હોય, અને ત્યાં તારી સાથે ઊભા રહેવાનું તેઓને કહે. ");
INSERT INTO guj2009_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","હું નીચે ઊતરીને ત્યાં આવીશ અને તારી સાથે વાત કરીશ, મેં તને જે આત્માં આપ્યો છે તેમાંથી લઈને હું એ લોકોને આપીશ તેથી તેઓ પણ તારી સાથે લોકોનો ભાર ઊચકશે, પછી તારે એકલાએ તે ભાર સહન કરવો પડશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","યહોવાએ મૂસાને કહ્યું, “તું લોકોને આ પ્રમાંણે કહે; દેહ શુદ્ધ કરી આવતીકાલને માંટે તૈયાર થાઓ, તમને માંસ ખાવા મળશે, તેઓને એ પણ કહે કે, યહોવાએ તમને રડતાં અને ફરિયાદ કરતાં સાભળ્યાં છે કે, ‘અમને માંસ કોણ આપશે? અમે મિસરમાં જ સારા હતાં!’ તે તમને માંસ આપશે, ને તમે તે જમશો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","એક દિવસ કે બે દિવસ નહિ, પાંચ, દશ કે વીસ દિવસ નહિ, ");
INSERT INTO guj2009_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","પરંતુ એક મહિના સુધી, તમે એનાથી કંટાળી જાઓ, તમને ચીતરી ચડે ત્યાં સુધી તમાંરે તે જમવું પડશે. કારણ કે તમે તમાંરી વચ્ચે વસતા યહોવાનો અનાદર કર્યો છે, અને તેમની આગળ એમ કહીને રોદણાં રડયા છો કે, ‘અમે મિસર છોડીને ન આવ્યા હોત તો સારું થાત.’” ");
INSERT INTO guj2009_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","મૂસાએ કહ્યું, “અત્યારે અહીં માંરી સાથે 6,00,000 પુરુષો કૂચ કરી રહ્યા છે, ‘અને તમે એમને એક આખા મહિના સુધી માંસ આપવાનું વચન આપો છો?’ ");
INSERT INTO guj2009_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","અરે! અમે અમાંરાં બધાં જ ઘેટાં બકરાં તથા ઢોરઢાંખર કાપીએ, તો પણ તેમાંથી આટલું બધું માંસ મળી શકે નહિ. દરિયાની બધી માંછલીઓ પકડીએ તો પણ તે પૂરી પડે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","યહોવાએ મૂસાને કહ્યું, “માંરી શક્તિ તો અમર્યાદિત છે, તૂં હમણાં જ જોશે કે, માંરું વચન સાચું સાબિત થાય છે કે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","પછી મૂસાએ બહાર આવીને યહોવાએ જે કહ્યું હતું તે લોકોને કહી સંભળાવ્યું. તેણે લોકોમાંથી સિત્તેર વડીલો પસંદ કરીને ભેગા કર્યા. અને તેઓને તંબુની આજુબાજુ ઊભા રાખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ત્યારબાદ યહોવા વાદળમાંથી ઊતરી આવ્યા અને મૂસા સાથે વાત કરી, પછી તેમણે મૂસાને જે આત્માં આપ્યો હતો તે લઈ અને તે સિત્તેર વડીલોને આપ્યો એટલે તેઓનામાં આત્માંનો સંચાર થયો. એટલે થોડા સમય સુધી પ્રબોધકના જેવા ભાવાવેશમાં પ્રબોધ કર્યો, પણ ત્યાર પછી તેઓએ એમ કર્યુ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","પરંતુ સિત્તેર પસંદગી પામેલા વડીલોમાંથી બે એલ્દાદ અને મેદાદ હજુ છાવણીમાં જ હતા, તેઓ તંબુ આગળ ગયા નહોતા તેમ છતાં તેઓનામાં પણ આત્માંનો સંચાર થયો જેણે તેમને પ્રબોધ કરાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","એક યુવાને દોડી જઈને મૂસાને કહ્યું કે, “એલ્દાદ અને મેદાદ છાવણીમાં પ્રબોધકના જેવા ભાવાવેશમાં પ્રબોધ કરી રહ્યા છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","નૂનના પુત્ર યહોશુઆ, જે નાનો હતો ત્યારથી મૂસાની સેવામાં રહ્યો હતો, તેણે વિરોધ દર્શાવતાં કહ્યું, “માંરા ધણી, મૂસા, મહેરબાની કરી તેમને રોકો.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","પણ મૂસાએ પ્રત્યુત્તર આપ્યો, “શું તને માંર પ્રતિષ્ઠાની ચિંતા છે? હું તો ઈચ્છું છું કે યહોવાના બધા લોકો પ્રબોધકો થાય યહોવા સૌને આત્માં આપે.” ");
INSERT INTO guj2009_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ત્યારબાદ મૂસા તથા સિત્તેર આગેવાનો છાવણીમાં પાછા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","એના પછી તરત યહોવાએ પવનને મોકલ્યો, અને તે દરિયામાંથી તેની સાથે લાવરીઓને ઉપાડી લાવ્યો. લાવરીઓ છાવણીમાં તથા તેની આસપાસ ઘસડાઈને પડવા લાગી. તેઓએ જમીનને ત્રણ ફુટ ઉડી ઢાંકી દીધી. માંણસ એક દિવસમાં જેટલું અંતર કાપી શકે તેટલાં અંતરમાં દરેક દિશામાં લાવરીઓ ફેલાયલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","તેથી લોકોએ તે આખો દિવસ અને આખી રાત અને પછીનો આખો દિવસ લાવરીઓ ભેગી કરી. કોઈ પણ વ્યક્તિએ દશ હોમેરથી ઓછી લાવરીઓ ભેગી કરી ન્હોતી. તેઓએ તેને છાવણીની ફરતા સુકાવા માંટે ફેલાવી દીધી. ");
INSERT INTO guj2009_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","પણ હજું માંસ તેમના દાંત વચ્ચે જ હતું. તેમણે ચાવ્યું પણ નહોતું ત્યાં તો તેમના ઉપર યહોવાનો રોષ ભભૂકી ઊઠયો; છાવણીમાં ભયંકર રોગનો ઉપદ્રવ ફાટી નીકળ્યો. મરકીમાં અસંખ્ય લોકો મૃત્યુ પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","તેથી તેમણે એ જગ્યાનું નામ “કિબ્રોથ-હાત્તાવાહ” એટલે કે લાલચુઓની કબરો પાડયું. કારણ કે ત્યાં લોકોએ માંસની અને મિસરની લાલસા કરનારાઓને દફનાવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ત્યારબાદ તે લોકોએ તે સ્થળનો ત્યાગ કર્યો અને યાત્રા કરીને હસેરોથ આવ્યા, અને ત્યાં તેઓએ થોડા સમય માંટે મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","મૂસા એક કૂશી સ્ત્રીને પરણ્યો હતો. એકવાર મરિયમ અને હારુને મૂસાની ટીકા કરી, કેમકે તે તેને પરણ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","તેઓએ કહ્યું, “શું ફકત મૂસા સાથે જ યહોવાએ વાત કરી છે? તેમણે શું આપણી સાથે પણ વાત નથી કરી?” યહોવાએ તેમના આ શબ્દો સાંભળ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","મૂસા તો ખૂબ નમ્ર માંણસ હતો એના જેવો નમ્ર માંણસ વિશ્વમાં પણ મળે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","યહોવાએ તાત્કાલિક મૂસા, હારુન અને મરિયમને મુલાકાત મંડપમાં હાજર થવા આજ્ઞા કરી; “તમે ત્રણે જણ અહીં આવો.” તેથી તેઓ યહોવા સમક્ષ ઊભા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","પછી તંબુના પ્રવેશદ્વાર પાસે યહોવા મેખસ્તંભમાં નીચે ઊતર્યા, અને તંબુના પ્રવેશદ્વાર આગળ ઊભા રહી તેમણે “હારુનને અને મરિયમને” બોલાવ્યાં, ");
INSERT INTO guj2009_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","“જ્યારે તે બંને જણ આગળ ગયાં એટલે દેવે કહ્યું, હું કહું તે ધ્યાનથી સાંભળો. પ્રબોધકોની સાથે હું સ્વપ્નમાં દર્શન આપીને વાત કરું છું. ");
INSERT INTO guj2009_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","પરંતુ માંરા સેવક મૂસાની વાત તો ન્યારી છે. માંરું આખું ઘર મેં એના વિશ્વાસે છોડયું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","હું એની સાથે તો મોઢામોઢ વાત કરું છું, હું ચોખ્ખી વાત કહું છું, મર્મોમાં બોલતો નથી, તેણે માંરું સ્વરૂપ નિહાળ્યું છે. તે પછી માંરા સેવક મૂસાની ટીકા કરતાં તમને ડર કેમ લાગતો નથી?” ");
INSERT INTO guj2009_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","પછી યહોવાનો કોપ તેમના પર ઉતર્યો અને તેઓ ત્યાંથી ચાલ્યા ગયા. ");
INSERT INTO guj2009_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","તંબુ પરથી વાદળ હઠી જતાંની સાથે જ મરિયમને કોઢ ફૂટી નીકળ્યો અને તેની ચામડી કોઢથી ધોળી થઈ ગઈ. હારુને તે જોયું. ");
INSERT INTO guj2009_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ત્યારે તેણે મૂસાને પોકાર કર્યો, “માંરા ધણી, દયા કરીને મૂર્ખાઈમાં અમે જે પાપ કરી બેઠાં છીએ તેને માંટે અમને શિક્ષા કરશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","જન્મ વખતે જ જેનું અડધું માંસ ખવાઈ ગયું હોય એવા મરેલા જન્મેલા બાળક જેવી એને થવા ન દેશો.” ");
INSERT INTO guj2009_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","એટલે મૂસાએ યહોવાને પોકાર કર્યો, “ઓ દેવ, તેને સાજી કરો, હું તમને વિનંતી કરું છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","યહોવાએ મૂસાને કહ્યું, “જો તેનો પિતા તેના મુખ પર થૂંકયો હોત, તો સાત દિવસ તે લજજીત ગણાત. તેથી તેને સાત દિવસ છાવણી બહાર એકાંતમાં મોકલો, ત્યારબાદ તેને પાછી છાવણીમાં લઈ આવજો.” ");
INSERT INTO guj2009_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","આથી મરિયમને સાત દિવસ સુધી છાવણીની બહાર જુદી રાખવામાં આવી, અને લોકોએ તે છાવણીમાં પાછી ન આવી ત્યાં સુધી મુકામ ઉપાડીને આગળ મૂસાફરી કરી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ત્યારવાદ તેમણે હસેરોથથી આગળ પ્રવાસ કર્યો અને પારાનના અરણ્યપ્રદેશમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“હું જે કનાની ભૂમિ ઇસ્રાએલીઓને આપવાનો છું. તેની ફરીને જાસૂસી કરવા માંટે માંણસો મોકલ. દરેક કુળસમૂહમાંથી એક એક માંણસ જે આગેવાન હોય તેને પસંદ કરીને મોકલ.” ");
INSERT INTO guj2009_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","યહોવાની આજ્ઞા અનુસાર પારાનના અરણ્યમાંથી મૂસાએ ઇસ્રાએલીઓના નીચે પ્રમાંણેના આગેવાનોને મોકલી આપ્યાં: ");
INSERT INTO guj2009_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","રૂબેન કુળસમૂહમાંથી ઝાક્કૂરનો પુત્ર શામ્મૂઆ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","શિમયોનના કુળસમૂહમાંથી હોરીનો પુત્ર શાફાટ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","યહૂદાના કુળસમૂહમાંથી યફૂન્નેહનો પુત્ર કાલેબ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ઈસ્સાખારના કુળસમૂહમાંથી યૂસફનો પુત્ર ઈગાલ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","એફ્રાઈમના કુળસમૂહમાંથી નૂનનો પુત્ર હોશિયા; ");
INSERT INTO guj2009_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","બિન્યામીનના કુળસમૂહમાંથી રાફ્રુનો પુત્ર પાલ્ટી; ");
INSERT INTO guj2009_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ઝબૂલોનના કુળસમૂહમાંથી સોદીનો પુત્ર ગાદીએલ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","યૂસફના મનાશ્શા કુળસમૂહમાંથી સૂસીનો પુત્ર ગાદી; ");
INSERT INTO guj2009_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","દાન કુળસમૂહમાંથી ગમાંલ્લીનો પુત્ર આમ્મીએલ; ");
INSERT INTO guj2009_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","આશેરના કુળસમૂહ તરફથી મિખાયેલનો પુત્ર સથૂર; ");
INSERT INTO guj2009_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","નફતાલીના કુળસમૂહ તરફથી વોફસીનો પુત્ર નાહબી; ");
INSERT INTO guj2009_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ગાદના કુળસમૂહમાંથી માંખીનો પુત્ર ગેઉએલ. ");
INSERT INTO guj2009_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","જે પુરુષોને મૂસાએ દેશની જાસૂસી કરવા મોકલ્યા તેઓનાં નામ એ હતા. મૂસાએ નૂનના પુત્ર હોશિયાનું નામ બદલીને યહોશુઆ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","મૂસાએ તેઓને કનાનભૂમિની ફરીને તપાસ કરવા મોકલતી વખતે સૂચનાઓ આપી: “તમે નેગેબની દક્ષિણમાં થઈને ઉચ્ચ પ્રદેશમાં જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","અને ત્યાં જઈને જુઓ કે તે પ્રદેશ કેવો છે; ત્યાં રહેનારા લોકો કેવા છે-બળવાન છે કે નબળા, વસ્તી વધારે છે કે ઓછી; ");
INSERT INTO guj2009_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","તે દેશની જમીન ઉપજાઉ છે કે નહિ; તેઓ જે શહેરોમાં રહે છે તે અરક્ષિત છે કે કિલ્લેબંદીવાળા નગરો; ");
INSERT INTO guj2009_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ત્યાંની જમીન ફળદ્રુપ છે કે ઉજજડ, ત્યાં જંગલો છે કે નહિ, નિર્ભય થઈને જાઓ અને ત્યાંના કેટલાંક ફળોના નમૂના લઈને આવો.” એ સમય દ્રાક્ષની ઋતુનો પ્રથમ પાકનો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","તેઓએ સમગ્ર દેશમાં જઈને સીનના અરણ્યથી માંડીને હમાંથની ઘાટી પાસે આવેલા રહોબ સુધીનો પ્રદેશ તપાસ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ઉત્તર તરફ જતાં તેઓ નેગેબમાંથી પસાર થયા અને હેબ્રોન પહોંચ્યા. ત્યાં તેઓએ રાક્ષસ અનાકના વંશજોના અહીમાંન, શેશાય અને તાલ્માંય કુટુંબોને વસેલાં જોયાં. (મિસરમાં સોઆન સ્થપાયું તેના સાત વર્ષ પહેલાં હેબ્રોન સ્થપાયું હતું.) ");
INSERT INTO guj2009_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","તેઓ પછી હાલમાં જે એશ્કોલની ખીણ તરીકે ઓળખાય છે ત્યાં આવ્યા. તેઓએ ત્યાં દ્રાક્ષના એક ઝૂમખા સાથેની દ્રાક્ષની વેલની એક ડાળી કાપી લીધી. બે માંણસોએ તેને એક વાંસ ઉપર ઉપાડવી પડી, પછી તેમણે દાડમ અને અંજીરના પણ કેલટાક નમૂના ભેગા કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ઇસ્રાએલીઓએ ત્યાંથી દ્રાક્ષનો એક ઝૂમખો કાપી લીધો હોવાથી એ જગ્યાનું નામ એશ્કોલનું કોતર પાડવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","તે દેશમાં ફરીને તે લોકોએ 40 દિવસ સુધી તપાસ કરી. પછી પાછા એ લોકો પારાનના અરણ્યમાં કાદેશ મુકામે મૂસા અને હારુનની તેમજ સમગ્ર ઇસ્રાએલી સમાંજની પાસે પાછા આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ત્યાં પારાનના અરણ્યમાં કાદેશ મુકામે તેમણે તેમની આગળ અહેવાલ રજૂ કર્યો અને તે દેશનાં ફળોનાં નમૂના બતાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","તેઓએ મૂસાને આ મુજબ કહ્યું, “તમે અમને જે દેશમાં તપાસ કરવા મોકલ્યા હતા ત્યાં અમે ગયા, ત્યાં ખરેખર દૂધ અને મધની રેલછેલ છે. આ રહ્યાં ત્યાંનાં ફળ. ");
INSERT INTO guj2009_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","પણ ત્યાંના લોકો શક્તિશાળી છે, તેઓનાં નગરો વિશાળ અને કિલ્લેબંધીવાળા છે. વળી અમે ત્યાં અનાકના રાક્ષસીઓને પણ જોયા. ");
INSERT INTO guj2009_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","અમાંલેકીઓ દક્ષિણમાં રહે છે, હિત્તીઓ, યબૂસીઓ અને અમોરીઓ પહાડી પ્રદેશોમાં રહે છે, અને કનાનીઓ દરિયાકાંઠે અને યર્દનને કાંઠે રહે છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","પછી કાલેબે મૂસાની આગળ ઊભા રહેલા લોકોને શાંત પાડ્યા અને કહ્યું, “આપણે, તરત એ દેશનો કબજો લઈએ, આપણે એને જીતી શકવા માંટે સાચે જ સમર્થ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","પણ તેમની સાથે ગયેલા બીજા જાસૂસોએ કહ્યું, “આપણે એ લોકોને જીતી શકીએ તેમ છે જ નહિ, તેઓ આપણા કરતાં વધુ બળવાન છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","તેમણે તપાસેલી ભૂમિ વિરુદ્ધ ઇસ્રાએલીઓને કહેવાનું તેઓએ શરુ કર્યુ; “અમે જે ભૂમિ તપાસી તે શક્તિશાળી લોકોથી ભરેલી છે કે જેઓ ત્યાં જતી કોઈ પણ વ્યક્તિને સરળતાથી હરાવવા સક્ષમ છે. ત્યાં અમે જોયેલા બધા માંણસો કદાવર અને બળવાન હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","તદુપરાંત અમે ત્યાં અનાકના વંશજો પુરાતન સમયના રાક્ષસોના વંશજોને પણ જોયા, તેઓ ખૂબ ઊચા અને કદાવર છે, અને અમે તો તેમની આગળ તીતીધોડા જેવા છીએ. એમ અમને લાગતું હતું. અને તે લોકોને પણ અમે તીતીધોડા જેવા જ લાગ્યા હોઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","એ સાંભળીને સમગ્ર ઇસ્રાએલી સમાંજ મોટે સાદે આખી રાત રુદન કરતો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","તેઓ બધા મૂસા અને હારુનની વિરુદ્ધ બડબડાટ કરવા લાગ્યા. “આના કરતાં તો અમે મિસરમાં કે અહીં અરણ્યમાં જ મૃત્યુ પામ્યાં હોત તો વધારે સારું થાત. ");
INSERT INTO guj2009_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","યહોવા અમને એ દેશમાં શા માંટે લઈ જાય છે? ત્યાં અમે યુદ્ધમાં માંર્યા જઈશું અને અમાંરી સ્ત્રીઓ તથા બાળકોને તેઓ બાનમાં પકડી લેશે. આના કરતાં તો મિસર પાછા જવું સારું!” ");
INSERT INTO guj2009_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","આમ તેઓ એકબીજાને કહેવા લાગ્યા કે, “ચાલો, આપણે કોઈને આગેવાન તરીકે પસંદ કરીએ અને પાછા મિસર જઈએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","આ સાંભળીને મૂસા તથા હારુન ઇસ્રાએલીઓના ભેગા મળેલા સમગ્ર સમાંજ સમક્ષ ઊધે મસ્તકે ભૂમિ પર પડયા. ");
INSERT INTO guj2009_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","અને દેશમાં ફરીને તપાસ કરવા ગયેલામાંના બે જણે, નૂનના પુત્ર યહોશુઆએ તથા યફૂન્નેહના પુત્ર કાલેબે દુઃખના માંર્યા પોતાનાં કપડાં ફાડી નાખ્યાં, ");
INSERT INTO guj2009_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","અને ઇસ્રાએલીઓના સમગ્ર સમાંજને ઉદેશીને કહ્યું, “અમે જે દેશની તપાસ કરવા ગયા હતા તે અદભૂત ખૂબ સારો દેશ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","જો યહોવા આપણા પર પ્રસન્ન હશે, તો તે આપણને એ દેશમાં લઈ જશે અને જ્યાં દૂધ અને મધની રેલછેલ છે તેવી ભૂમિ તે આપણને આપશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","યહોવાની વિરુદ્ધ બંડ ન કરશો, એ લોકોથી ડરશો નહિ, તે બધાને હરાવવા આપણે શક્તિમાંન છીએ. હવે તેમનું રક્ષણ કરનાર કોઈ રહ્યો નથી અને યહોવા આપણી સાથે છે, તેથી તેમનાથી જરાય ડરશો નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","તેમ છતાં લોકો યહોશુઆ અને કાલેબને પથ્થરે માંરવાની ધમકી આપતા હતા, પરંતુ તે જ સમયે યહોવાનું ગૌરવ મુલાકાતમંડપ પર બધા ઇસ્રાએલીઓ સમક્ષ પ્રગટ થયું. ");
INSERT INTO guj2009_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","યહોવાએ મૂસાને કહ્યું, “એ લોકો કયાં સુધી માંરી વિમુખ રહેશે? એમની વચ્ચે મેં આટલા બધા ચમત્કારો કર્યા છતાં પણ તેઓ માંરામાં વિશ્વાસ રાખતા નથી કયાં, સુધી તેઓ માંરા પર વિશ્વાસ રાખવાની ના પાડયા કરશે? હું મરકીનો રોગચાળો ફેલાવીને તેમનો નાશ કરીશ અને તારામાંથી હું એક નવી વધારે મહાન અને બળવાન પ્રજા ઉત્પન્ન કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","13","પણ મૂસાએ યહોવાને કહ્યું, “પરંતુ મિસરના લોકો જાણે છે કે, તમે તમાંરા બાહુબળથી તેઓને મિસરમાંથી લઈ આવ્યા છો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","તેમણે આ દેશની પ્રજાને પણ તે જણાવ્યું છે. એ લોકો જાણે છે કે, યહોવા અમાંરી વચ્ચે વસે છે અને તે અમને મોઢામોઢ દર્શન આપે છે, અમને તેમના વાદળની ઓથે મળે છે, એ લોકો જાણે છે કે, તમે દિવસે વાદળના સ્તંભરૂપે અને રાત્રે અગ્નિના સ્તંભરૂપે અમાંરી આગળ ચાલો છો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","હવે, જો તમે તમાંરી પ્રજાનો સંહાર કરશો, તો જે પ્રજાઓએ તમાંરી એ બધી વાતો સાંભળી છે તેઓ કહેશે, ");
INSERT INTO guj2009_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘યહોવાએ આ લોકોને જે દેશ આપવાનું વચન આપ્યું હતું તેમાં તે એમને લઈ જઈ શક્યા નહિ; એટલે તેમણે તે બધાને અરણ્યમાં એકસામટા મોતને ઘાટ ઉતારી દીધા.’ ");
INSERT INTO guj2009_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“એટલે માંરી તમને વિનંતી છે કે, જેમ તમે કહ્યું હતું તેમ તમાંરું સાર્મથ્ય બતાવો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","તમે કહ્યું હતું કે, ‘હું યહોવા એકદમ ગુસ્સે થતો નથી, હું મહાન પ્રેમ અને વિશ્વાસ દર્શાવું છું, અને પાપ તથા અપરાધોની માંફી આપું છું તેમ છતાં પાપીઓના પાપની સજા ત્રીજી અને ચોથી પેઢીનાં બાળકો સુધી કરવાનું હું ચુકતો નથી.’ એ હવે સાચું પુરવાર કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","અમે મિસરમાંથી બહાર નીકળ્યા ત્યારથી આજપર્યંત દરેક સમયે તમે તેઓને માંફી આપી છે, તેમજ આજે પણ તમાંરી મહાનતા અને તમાંરા અટલ પ્રેમને કારણે તમે આ લોકોનાં પાપોને માંફ કરો એવી હું તમને આગ્રહપૂર્વક વિનંતિ કરું છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","યહોવાએ કહ્યું, “તમાંરી વિનંતી મુજબ હું તેઓને માંફી આપીશ, ");
INSERT INTO guj2009_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","માંરા જીવ જેટલી ચોકસાઈથી હું માંરા પોતાના ગૌરવ કે જે આખી પૃથ્વીમાં વ્યાપેલું છે તેનાથી સમ ખાઈને કહું છું કે, ");
INSERT INTO guj2009_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","જે લોકોએ માંરું ગૌરવ અને મિસરમાં તથા અરણ્યમાં માંરાં પરાક્રમો જોયાં છતાં દશદશ વખત માંરું પારખું કર્યુ છે અને માંરું કહ્યું માંન્યું નથી, ");
INSERT INTO guj2009_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","મેં એમના પિતૃઓને જે દેશ આપવાનું વચન આપ્યું હતું તેમાં તેઓમાંનો એક પણ દાખલ થવા પામશો નહિ, માંરી વિરુદ્ધ ફરી જનાર કોઈ પણ તે દેશને જોવા પામશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","પરંતુ માંરો સેવક કાલેબ અલગ પ્રકૃતિનો માંણસ છે, તે મને સંપૂર્ણપણે વફાદાર રહ્યો છે, તેથી જે દેશમાં એ જઈને આવ્યો છે તે દેશમાં હું એને લઈ જઈશ અને તેના સંતાન એના ધણી થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","એ દેશના સપાટ ભાગોમાં અત્યારે અમાંલેકીઓ અને કનાનીઓ વસે છે. તેથી કાલે જ તમાંરે આ જગ્યા છોડી દેવાની છે અને રાતા સમુદ્રને રસ્તે પાછા રણમાં જજો.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ત્યારબાદ યહોવાએ મૂસાને અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“આ દુષ્ટ લોકો કયાં સુધી માંરી વિરુદ્ધ ફરિયાદો કર્યા કરશે? તેઓએ જે કહ્યું છે તે સર્વ મેં સાંભળ્યું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","તું એ લોકોને જણાવ કે, ‘આ યહોવાનાં વચન છે: હું માંરા સમ ખાઈને કહું છું કે, તમે માંરા સાંભળતા જે બોલ્યા હતા તે જ પ્રમાંણે હું કરીશ. ");
INSERT INTO guj2009_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","તમે લોકોએ માંરા વિરુદ્ધ ફરિયાદ કરી છે તેથી તમાંરાં સૌના મૃતદેહ આ અરણ્યમાં રઝળશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","મેં તમને જે દેશમાં વસાવવાનું વચન આપ્યું હતું તેમાં વીસ વર્ષના અને તેની ઉપરના તમાંરામાંના કોઈ પ્રવેશવા પામશે નહિ. ફકત યફૂન્નેહનો પુત્ર કાલેબ અને નૂનનો પુત્ર યહોશુઆ તેમાં પ્રવેશ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","તમે એમ પણ કહ્યું હતું કે, દુશ્મનો તમાંરા બાળકો બાનમાં પકડશે પણ હું તે બાળકોને તે ભૂમિમાં પાછા લઈ આવીશ અને તમે અસ્વીકાર કરેલી ભૂમિનો તેઓ આનંદ માંણશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","પણ તમાંરાં મૃતદેહો તો આ અરણ્યમાં રઝળશે. ");
INSERT INTO guj2009_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘અને તમાંરામાંનો છેલ્લો માંણસ અરણ્યમાં મૃત્યુ પામશે નહિ ત્યાં સુધી તમાંરાં બાળકો અરણ્યમાં 40 વર્ષ સુધી ભરવાડ તરીકે રઝળશે; તેઓ દુઃખી થશે કેમકે તમે મને વફાદાર ન હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ચાળીસ દિબસ સુધી તમે દેશમાં ફરીને તપાસ કરી હતી; તેમ તમે 40 વર્ષ સુધી અરણ્યમાં એકદિવસને બદલે એક વર્ષ સુધી તમાંરાં પાપોનો બોજ માંથે ઊચકીને ભટકશો ત્યારે તમને સમજાશે કે માંરી નારાજગીનું પરિણામ કેવું આવે છે?’ ");
INSERT INTO guj2009_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“હું યહોવા આ બોલું છું. માંરો વિરોધ કરવા એકત્ર થયેલા આ દુષ્ટ લોકોના હું ભૂડાં હાલ કરીશ. તેઓ એકે એક આ અરણ્યમાં મૃત્યુ પામશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","જે દશ માંણસોને મૂસાએ દેશમાં ફરીને તપાસ કરવા મોકલ્યા હતા તેમણે ખોટો હેવાલ આપ્યો, જેને કારણે લોકોએ યહોવા વિરુદ્ધ બંડ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","તેઓ બધા યહોવા સમક્ષ રોગનો ભોગ બન્યા અને મરી ગયા, કારણ, તેમણે એ દેશને વખોડી કાઢયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","જેઓ દેશમાં તપાસ કરવા ગયા હતા, તે જાસૂસોમાંથી ફકત નૂનનો દીકરો યહોશુઆ અને યફૂન્નેહનો દીકરો કાલેબ જ જીવતા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","જયારે મૂસાએ સમગ્ર ઇસ્રાએલી પ્રજાને યહોવાના વચન કહી સંભળાવ્યાં ત્યારે છાવણીમાં ભારે શોક છવાઈ ગયો અને તેઓ ખૂબ પસ્તાવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","બીજે દિવસે વહેલી સવારે તેઓ ઊઠયા અને બોલ્યા, “જુઓ, યહોવાએ જે ભૂમિની વાત કરી હતી ત્યાં જવા અમે તૈયાર છીએ, અમે કરેલાં પાપનું અમને ભાન થયું છે. હવે અમે યહોવાએ જે દેશનું વચન આપ્યું હતું ત્યાં જવા તૈયાર છીએ, એમ કહેતાં તેઓ પહાડી પ્રદેશ ઉપર ચઢાઈ કરવા નીકળી પડયા.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","પછી મૂસાએ કહ્યું, “હવે તે માંટે ઘણું મોડું થયું કહેવાય. યહોવાએ તમને અરણ્યમાં પાછા જવાની આજ્ઞા કરેલ છે, તમે હવે યહોવાની આજ્ઞાનું ઉલ્લંઘન શા માંટે કરો છો? એમાં તમને કોઈ લાભ થશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","હવે તમે જરાય આગળ વધશો નહિ, નહિ તો તમાંરા દુશ્મનો તમને પરાસ્ત કરશે. કારણ કે યહોવા હવે તમાંરી સાથે નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","અમાંલેકીઓ અને કનાનીઓ તમાંરો સામનો કરવા ઊભા છે અને તમે તેમના શિકારનો ભોગ બનશો. કારણ તમે યહોવાને અનુસરવાનું ત્યજી દીધું છે, અને તેથી હવે યહોવા તમાંરી સાથે નથી.” ");
INSERT INTO guj2009_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","કરારકોશ અને મૂસા છાવણીમાંથી બહાર ગયા નથી એ હકીકત જાણવા છતાં તેમણે હઠપૂર્વક પહાડી પ્રદેશ તરફની કૂચ ચાલુ રાખી. ");
INSERT INTO guj2009_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","પછી પહાડી પ્રદેશમાં વસતા અમાંલેકીઓ અને કનાનીઓ તેમના પર તૂટી પડયા અને તેઓને હરાવ્યા, અને છેક હોર્માંહ સુધી તેઓને માંરી નસાડ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ઇસ્રાએલી પ્રજાને તું આ મુજબ કહે: જે દેશની ભૂમિ હું તમને વસવાટ માંટે આપવાનો છું ત્યાં પ્રવેશો ત્યારે આ નિયમોનું પાલન કરવું જ. ");
INSERT INTO guj2009_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","નીચેનામાંથી કોઈ પણ અર્પણ માંટે બલિદાન કરવા યહોવા સમક્ષ તમે બળદ, ઘેટું કે બકરું લાવી શકો: દહનાર્પણ, પ્રતિજ્ઞા પૂર્ણ કરવા માંટેનું અર્પણ, કે પ્રતિજ્ઞાની ભેટ, કે ઉજાણી દરમ્યાન થતાં અર્પણો એ અર્પણોની સુવાસથી યહોવા પ્રસન્ન થાય છે, તેથી તમાંરે નીચેના નિયમોનું પાલન કરવું: ");
INSERT INTO guj2009_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“બલિ અર્પણ કરતી વખતે અર્પણ ચઢાવનારે એની સાથે આઠ વાટકા જીણા દળેલા લોટમાં ગેલનના ચોથા ભાગનું જૈતૂન તેલ ભેળવીને ખાદ્યાર્પણ તરીકે અર્પણ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","અને હલવાનને દહનાર્પણ તરીકે અર્પણ કરતી વખતે એક લીટર દ્રાક્ષારસ પણ પેયાર્પણ તરીકે અર્પણ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“જો ઘેટાનું અર્પણ ચઢાવવું હોય તો, ");
INSERT INTO guj2009_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","તમાંરે 16 વાટકા ઝીણા દળેલા લોટમાં ગેલનના ચોથા ભાગનું તેલ ભેળવીને ખાદ્યાર્પણ તરીકે અને દોઢ લીટર દ્રાક્ષારસ પેયાર્પણ તરીકે ચઢાવવો, આ બલિદાનની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“દહનાર્પણ કે પ્રતિજ્ઞા પૂર્ણ કરવા માંટે રજૂ કરવાનું અર્પણ કે શાંત્યર્પણ માંટે વાછરડાનું અર્પણ લાવે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","અને તે વાછરડા સાથે ખાદ્યાર્પણ પણ લાવે; અડધા ગેલન જૈતૂન તેલ સાથે 24 વાટકા ઝીણો દળેલો લોટ ભેળવી અર્પે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","અને અડધો ગેલન દ્રાક્ષારસ પણ પેયાર્પણ તરીકે ચઢાવવાં. એ અર્પણની સૌરભથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","પ્રત્યેક બલિદાન બળદ, ઘેટું કે બકરુ ચઢાવતી વખતે આ પ્રમાંણે કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","જો એક કરતાં વધારે પ્રાણીઓનાં બલિદાન હોય તો પ્રત્યેક પ્રાણી દીઠ ઉપર જણાવ્યા પ્રમાંણે ખાદ્યાર્પણ તથા પેયાર્પણમાં વધારો કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“યહોવાને અર્પણ ચઢાવનાર ઇસ્રાએલનો વતની હોય તો તેણે ઉપરના નિયમો પાળવા, આવા અર્પણની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","યહોવાને અર્પણ ચઢાવનાર તમાંરી સાથે કાયમી ધોરણે કે થોડા સમય માંટે વસતો વિદેશી હોય તો પણ તેણે એ જ નિયમનું પાલન કરવું, અર્પણની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","આ કાનૂનો તમાંરે માંટે તથા તમાંરી સાથે રહેતા વિદેશીઓ માંટે સમાંન છે, અને તે કાયમ માંટે તમે અને તમાંરા વંશજોને બંધનકર્તા છે. યહોવા સમક્ષ સ્વદેશી અને વિદેશી સરખા જ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","તમને અને તમાંરી વચ્ચે વસતા વિદેશીઓને આ જ કાનૂનો અને નિયમો લાગુ પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“તું ઇસ્રાએલી પ્રજાને કહે કે, હું તમને જે દેશમાં લઈ જવાનો છું ત્યાં ગયા પછી ");
INSERT INTO guj2009_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","તમે એ ભૂમિનું અનાજ ખાઓ ત્યારે તમાંરે યહોવાને ધરાવવા થોડો ભાગ અલગ રાખવો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","પહેલી કાપણીના દાણામાંથી બાંધેલા લોટને તમાંરે એક તરફ રાખવો તે પ્રથમ બાંધેલા લોટને ભેટ તરીકે યહોવાને આપો. તે ખળામાંથી આવતા ખાદ્યાર્પણ જેવું ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","તમે બાંધેલી પ્રથમ કણકનો અમુક ભાગ તમાંરે યહોવાને માંટે અલગ રાખવો, આ ઉચ્છાલીયાર્પણ તમાંરે લાવવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“આ નિયમ તમાંરા વંશજોને પણ લાગુ પડે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","યહોવાએ મૂસા માંરફતે તમને આપેલી આ આજ્ઞાઓમાંથી કોઈનો તમાંરામાંથી આજે કે ભવિષ્યમાં ભૂલથી ભંગ થઈ જાય તો તમાંરે આ પ્રમાંણે કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","અને જો આખા સમાંજે અજ્ઞાનતાને કારણે ભૂલ કરી હોય, તો તેઓ દહનાર્પણ તરીકે વાછરડું બલિદાનમાં આપે. અને તેની સાથે નિયમ પ્રમાંણે ખાદ્યાર્પણ તથા પેયાર્પણ રજૂ કરે. તેની સુવાસથી યહોવા પ્રસન્ન થશે. આ સાથે પાપાર્થાર્પણ માંટે એક બકરાનું પણ બલિદાન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“યાજકે સમગ્ર ઇસ્રાએલી સમાંજ માંટે પ્રાયશ્ચિતની વિધિ કરવી, તેથી તેમને પણ માંફ કરવામાં આવશે. કારણ, એ શરતચૂક હતી અને એ શરતચૂક માંટે તેઓએ યહોવાને આહુતિ પણ ચઢાવ્યાં છે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","તેથી સમગ્ર ઇસ્રાએલી સમાંજને અને તેમની ભેગા વસતા વિદેશીઓને માંફ કરવામાં આવશે, કારણ કે શરતયૂકથી એ સૌની થયેલી ભૂલ હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“જો કોઈ વ્યક્તિ અજાણતા પાપ કરી બેસે તો તેણે એક વર્ષની બકરી પાપાર્થાર્પણને માંટે બલિ તરીકે ચઢાવવી. ");
INSERT INTO guj2009_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","અને યાજક યહોવા સમક્ષ તેને માંટે પ્રાયશ્ચિતવિધિ કરે તો તેને માંફ કરવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","અજાણતા ભૂલથી પાપ કરનાર પ્રત્યેક માંટે આ કાનૂન છે. પછી તે દેશનો વતની ઇસ્રાએલી હોય કે તેમની સાથે રહેતો વિદેશી હોય. ");
INSERT INTO guj2009_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“પણ જો કોઈ વ્યક્તિ પછી તે ઇસ્રાએલી વતની હોય કે વિદેશી હોય, જાણી જોઈને ઈરાદાપૂર્વક પાપ કરે તો તે યહોવાનું અપમાંન કરે છે. એવા માંણસનો બહિષ્કાર કરવો અને સમાંજથી અલગ રાખવો, ");
INSERT INTO guj2009_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","કારણ કે, તેણે યહોવાની આજ્ઞાનું ઉલ્લંઘન ઈરાદાપૂર્વક કર્યું છે. તેણે યહોવાની અવજ્ઞા કરી છે. તેથી એ માંણસનો સંપૂર્ણ બહિષ્કાર કરવો. એના પાપની જવાબદારી એના એકલાના જ માંથે છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ઇસ્રાએલી પ્રજા અરણ્યમાં હતી ત્યારે એક વ્યક્તિ વિશ્રામવારે લાકડાં વીણતાં પકડાઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","જે લોકોએ તેને લાકડા વીણતો જોયો હતો તેઓએ એની ધરપકડ કરી અને તેને મૂસા, હારુન અને સમગ્ર સમાંજ સમક્ષ રજૂ કરવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","તેને બંદીખાનામાં રાખવામાં આવ્યો, કારણ, એને શો દંડ આપવો તે હજી નક્કી થયું નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","પછી યહોવાએ મૂસાને કહ્યું, “આ માંણસને મૃત્યુદંડની શિક્ષા કરવી જોઈએ. સમગ્ર સમાંજે એને છાવણી બહાર ઈટાળી કરીને મોતને ઘાટ ઉતારવો જોઈએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","તેથી યહોવાએ મૂસાને આજ્ઞા કરી હતી તે મુજબ તેઓ તેને છાવણીની બહાર લઈ ગયા અને ઈટાળી કરીને માંરી નાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ઇસ્રાએલી પ્રજાને તું કહે કે, તમાંરાં વંશજોએ અને તમાંરે તમાંરાં વસ્ત્રને ખૂણે ફૂમતાં મૂકવા અને એ ફૂમતામાં ભૂરા રંગનો દોરો ગૂંથવો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","40","તમને એ ફૂમતું જોઈને માંરી બધી આજ્ઞાઓનું સ્મરણ થશે, તમે એનું પાલન કરશો તથા આ રીતે માંરી સેવામાં સમર્પિત રહેશો. તમે માંરાથી દૂર ભટકી જશો નહિ અને તમાંરા શરીરની ઈચ્છાઓ અને તમાંરી નજર જે જુએ છે તેની પાછળ ખેંચાશો નહિ, જેથી તમે એ ફૂમતાઓને જોશો ત્યારે માંરી બધી આજ્ઞાઓને યાદ કરી તેનું પાલન કરશો પછી તમે દેવના ખાસ લોકો બનશો. ");
INSERT INTO guj2009_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","તમાંરો દેવ બનવા તમને મિસરમાંથી બહાર લાવનાર હું તમાંરો દેવ યહોવા છું. હા, હું યહોવા તમાંરો દેવ છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","લેવી કુળના વંશજ કોરાહ, જે કહાથના પુત્ર યિસ્હારનો પુત્ર હતો, રૂબેનના વંશજો દાથાન તથા અબીરામ જે અલીઆબના પુત્રો હતા તથા રૂબેન કુળ સમૂહનો હજુ એક વંશજ ઓન જે પેલેથનો પુત્ર હતો એ ચારે જણ ભેગા થયા અને મૂસા સામે ઉભા થયા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","તેમની સાથે 250 ઇસ્રાએલી તેમની ઉશ્કેરણીથી મૂસા વિરુદ્ધ બંડમાં જોડાયા. તેઓ બધા સમાંજના આગેવાનો, પંચના ચૂંટાયેલા અગ્રણી તથા પ્રતિષ્ઠિત માંણસો હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","તેઓ બધા મૂસા અને હારુનની વિરુદ્ધ થયા અને તેમને કહ્યું, “તમે હવે હદ વટાવો છો, તમાંરી આગેવાનીથી અમે થાકી ગયા છીએ. ઇસ્રાએલના સર્વ લોકો પવિત્ર છે? તેઓની વચ્ચે યહોવાનો વાસ નથી? તમે તમાંરી જાતને યહોવાની મંડળી કરતાં ઊંચી શા માંટે ગણાવો છો?” ");
INSERT INTO guj2009_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","આ શબ્દો કાને પડતાં જ મૂસા જમીન પર પછાડ ખાઈને પડયો. ");
INSERT INTO guj2009_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","પછી તેણે કોરાહને અને તેના બધા સાથીમિત્રોને કહ્યું, “આવતી કાલે સવારે યહોવા જાહેર કરશે કે, કોણ યહોવાના છે, અને કોણ ખરેખર પવિત્ર છે, યહોવા એ વ્યક્તિને પસંદ કરી અને તેને પોતાની નજીક બોલાવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","કોરાહ, તું અને તારા સાથીઓ આ મુજબ કરો: ");
INSERT INTO guj2009_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","આવતીકાલે તમાંરે ધૂપદાની લઈને તેમાં અગ્નિ અને ધૂપ મૂકવો અને યહોવાને ધરાવવી. યહોવા પસંદ કરશે તે જ ખરેખરો પવિત્ર બનશે. લેવીના પુત્રો તમે જ છો. જે મર્યાદા વટાવો છો.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","વળી મૂસાએ વધુમાં કોરાહને કહ્યું, “ઓ લેવીઓ, માંરી વાત સાંભળો. ");
INSERT INTO guj2009_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","સમગ્ર ઇસ્રાએલી સમાંજમાંથી દેવે તમને પસંદ કર્યા, અને અલગ કર્યા, મંદિરમાં સેવા ઉપાસના અને ઇસ્રાએલી લોકોને દેવની ઉપાસના કરવામાં મદદ કરવા માંટે. એટલું તમાંરા માંટે શું પૂરતું નથી? ");
INSERT INTO guj2009_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ફકત તને કોરાહને, તથા તારા અન્ય લેવીબંધુઓને પોતાની આટલી સેવા કરવાનો અધિકાર આપ્યો છે અને હવે તમે યાજકપદની અભિલાષા કરો છો? ");
INSERT INTO guj2009_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","હારુને કઈ ખોટું કર્યુ છે કે તમે એની સામે ફરિયાદ કરો છો? તું અને તારા સાથીઓ યહોવાની વિરુદ્ધ બળવો કરો છો?” ");
INSERT INTO guj2009_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ત્યારબાદ મૂસાએ અલીઆવના પુત્ર દાથાનને અને અબીરામને તેડાવ્યા, પણ તેમણે કહેવડાવ્યું, “અમે નથી આવતા, ");
INSERT INTO guj2009_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","તું અમને દૂધ અને મધની રેલછેલ હતી એવા દેશમાંથી આ અરણ્યમાં મરવા માંટે લઈ આવ્યો એટલું ઓછું છે કે તું અમાંરા પર પાછો દોર ચલાવવા માંગે છે? ");
INSERT INTO guj2009_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","તદુપરાંત જે અદભૂત દેશનું તેં વચન આપ્યું હતું તેમાં તું અમને લાવ્યો નથી, તેં અમને ખેતરો કે દ્રાક્ષાવાડીઓ પણ આપી નથી, તને શું લોકોની આંખો કાઢી નાખીશ જેથી તેઓ ઉપર કરેલું નુકશાન જુએ નહિ? ના, અમે તારી પાસે આવવાના નથી.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","પછી મૂસાએ ગુસ્સે થઈને યહોવાને કહ્યું, “એમના અર્પણ કરેલાં બલિદાનોનો સ્વીકાર કરશો નહિ, મેં તે લોકો પાસેથી એક ગધેડું પણ લીધું નથી કે તેઓમાંના કોઈનું કશું નુકસાન પણ કર્યુ નથી.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","એટલે મૂસાએ કોરાહને કહ્યું, “તું અને તારા સર્વ સાથીઓ આવતીકાલે યહોવા સમક્ષ અહીં હાજર થજો. હારુન પણ આવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","તમાંરામાંનો પ્રત્યેક વ્યક્તિ પોતાની ધૂપદાની સાથે લઈને યહોવા સમક્ષ આવે. ત્યાં આગેવાનો માંટે 250 ધૂપદાનીઓ અને તારા અને હારુન માંટે એક-એક ધૂપદાની હશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","તેથી તે બધા પોતાની ધૂપદાનીઓ સાથે લાવ્યા અને તેમાં દેવતા મૂકી ધૂપ નાખ્યો; અને મૂસા અને હારુનની સાથે મુલાકાત મંડપના પ્રવેશદ્વાર આગળ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","તે દરમ્યાન કોરાહે સમગ્ર સમાંજને મૂસા અને હારુન વિરુદ્ધ ઉશ્કેરીને એ બે જણની સામે ભેગા કર્યા હતા. ત્યાં તો યહોવાના ગૌરવે સમગ્ર સમાંજને દર્શન દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","યહોવાએ મૂસાને અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“તમે આ લોકોના સમાંજમાંથી બહાર નીકળી જાઓ, એટલે હું તત્કાળ એ સર્વનો નાશ કરું.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","પરંતુ મૂસાએ અને હારુને યહોવા સમક્ષ સાષ્ટાંગ નમસ્કાર કર્યા અને કહ્યું, “હે દેવ, તમે જ બધા જીવોના જીવનદાતા છો, એક જ વ્યક્તિના પાપને કારણે શું તમે સમગ્ર સમાંજ પ્રત્યે ક્રોધાયમાંન થશો?” ");
INSERT INTO guj2009_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","એટલે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“તું એ લોકોને કહે કે તેઓ કોરાહ, દાથાન અને અબીરામના તંબુ આગળથી દૂર ખસી જાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ત્યારપછી મૂસાએ ઇસ્રાએલીઓના વડીલો સાથે દાથાન અને અબીરામની પાસે જઈને આખા સમાંજને ઉદેશીને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","“તમે આ દુષ્ટ માંણસોના તંબુઓથી આધા ખસી જાઓ. એમની કોઈ વસ્તુને અડશો નહિ. નહિ તો તેમનાં બધાં પાપોને કારણે તમે પણ તેમની સાથે નાશ પામશો.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","તેથી કોરાહ, દાથાન અને અબીરામના તંબુઓ આગળથી બધા લોકો દૂર ચાલ્યા ગયા, દાથાન અને અબીરામ પોતાની પત્નીઓ, પુત્રો અને બાળકો સાથે પોતાના તંબુમાંથી બહાર આવીને પ્રવેશદ્વાર આગળ આવીને ઊભા રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","મૂસાએ કહ્યું, “આ દ્વારા તમને ખાતરી થશે કે મેં જે કંઈ કર્યું છે તે કરવા માંટે મને યહોવાએ મોકલ્યો છે; કારણ કે હું કાંઈ માંરી મરજી મુજબ આ બધાં કાર્યો કરતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","જો આ લોકો બીજા બધા માંણસોની જેમ કુદરતી રીતે મૃત્યુ પામે તો માંનવું કે યહોવાએ મને મોકલ્યો નથી, ");
INSERT INTO guj2009_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","પણ જો યહોવા ચમત્કાર કરે અને ધરતી પોતાનું મુખ ઉધાડે અને તેઓને તથા તેઓની બધી જ વસ્તુઓને ગળી જાય અને તેઓ જીવતા મૃત્યુલોકોમાં પહોંચી જાય તો તમાંરે જાણવું કે, એ લોકોએ યહોવાનું અપમાંન કર્યું છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","મૂસા બોલી રહ્યો કે તરત જ તે લોકોના પગ નીચેની ધરતી ફાટી; ");
INSERT INTO guj2009_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ધરતીએ ખોલેલા મુખમાં તેમનાં કુટુંબો, તેમનાં તંબુઓ, તેઓ અને તેઓના સાથીઓ અને તેઓનું સર્વસ્વ જતુ રહ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","તેઓ પોતાના સર્વસ્વ સાથે જીવતા મૃત્યુલોકમાં પહોંચી ગયા; ધરતી પાછી સંધાઈ ગઈ. આમાં તેઓનો સર્વનાશ થઈ ગયો, તેઓ સમુદાયમાંથી જતાં રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","તેમની ચીસો સાંભળીને ત્યાં આસપાસ ઊભેલા બધાં ઇસ્રાએલીઓ ભયભીત થઈને ભાગવા માંડયા. રખેને તેઓને પણ “ધરતી હડપ કરી જાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","પછી યહોવાનો અગ્નિ આવ્યો અને ધૂપ ચઢાવવા આવેલા 250 માંણસોને ભશ્મ કરી ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“તું યાજક હારુનના પુત્ર એલઆઝારને કહે કે, અગ્નિમાંથી ધૂપદાનીઓ ઉપાડી લે; કેમકે તેમાંનો ધૂપ પવિત્ર છે કારણ એ યહોવાને અર્પિત થયેલ છે. અને એમને કહો કે તેમાંનો કોલસો અને રાખ આમતેમ વેરી દે. ");
INSERT INTO guj2009_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","યહોવાની વેદી સમક્ષ તે રજૂ થઈ હતી તેથી તે ધૂપદાનીઓ પવિત્ર છે, તેથી પાપ કરીને મૃત્યુને ભેટનાર એ લોકોની ધૂપદાનીઓમાંથી પતરાં બનાવડાવી તેના વડે વેદીના ઢાંકણને મઢાવજે, એ ઇસ્રાએલી લોકો માંટે ચેતવણીરૂપ થઈ પડશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","યહોવાએ મૂસા માંરફતે કરેલી આજ્ઞા મુજબ યાજક એલઆઝારે ધૂપ ઘરાવતી વખતે અગ્નિનો ભોગ લોકોની ધૂપદાનીઓ લઈને તેની વેદીને ઢાંકવા માંટે પતરાં બનાવડાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","જેને જોઈને ઇસ્રાએલીઓને યાદ રહે કે જે હારુનના કુટુંબમાંથી ના હોય અને બિનઅધિકૃત હોય તેણે યહોવા સમક્ષ ધૂપ ધરાવવા આવવું નહિ. નહિ તો તેની હાલત કોરાહ અને તેના સાથીઓ જેવી થશે. આમ મૂસા દ્વારા યહોવાએ એલઆઝારને આપેલી આજ્ઞા અનુસાર બધું કરવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","પરંતુ બીજે દિવસે સમગ્ર ઇસ્રાએલી સમાંજ મૂસાની અને હારુનની વિરૂદ્ધ એમ કહેતા કચવાટ કરવા લાગ્યો, “તમે જ યહોવાના માંણસોના મોત નિપજાવ્યા છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","થોડા સમયમાં જ ફરિયાદ કરતા લોકોનું મોટું ટોળું ભેગું થયું. તેઓએ મુલાકાત મંડપ તરફ જોયું તો એકાએક તેના પર એક વાદળો આચ્છાદન કર્યું હતું. અને યહોવાના ગૌરવે ત્યાં દર્શન દીથાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","મૂસા અને હારુન મુલાકાત મંડપના પ્રવેશદ્વાર આગળ જઈને ઊભા રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","એટલે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“આ લોકોથી દૂર ખસી જા, જેથી હું એ લોકોનો એક પળમાં નાશ કરું.” એટલે મૂસા અને હારુને જમીન પર લાંબા થઈને તેમને સાંષ્ટાંગ નમસ્કાર કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","અને મૂસાએ હારુનને કહ્યું, “જલદીથી ધૂપદાની લઈને તેમાં વેદીમાંથી દેવતા ભર અને તેમાં ધૂપ નાખ, અને તે લઈને દોડતો દોડતો લોકો પાસે જા અને તેમના પાપનું પ્રાયશ્ચિત કર, કારણ કે યહોવાનો કોપ તેઓના પર ઊતર્યો છે અને રોગચાળો ફાટી નીકળ્યો છે. લોકોમાં મરકી શરૂ થઈ ગઈ છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","આથી મૂસાએ કહ્યું તે મુજબ હારુને કર્યુ. અને ઝડપથી ધૂપદાની લઈને ભેગા મળેલા લોકો વચ્ચે દોડી ગયો, તો ખબર પડી કે તેઓમાં રોગચાળો શરૂ થઈ ગયો હતો. તેણે ધૂપદાનીમાં ધૂપ નાખી મરેલાં ");
INSERT INTO guj2009_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","અને જીવતા વચ્ચે ઊભા રહી લોકોના પાપનું પ્રાયશ્ચિત કર્યું. રોગચાળો બંધ થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","પરંતુ તેટલા સમયમાં 14,700 લોકો મૃત્યુ પામ્યાં હતાં અને કોરાહના બંડ વખતે મૃત્યુ પામેલા તે તો જુદા. ");
INSERT INTO guj2009_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","આમ રોગચાળો બંધ થઈ ગયો એટલે હારુન મુલાકાત મંડપના પ્રવેશ દ્વાર આગળ મૂસા પાસે પાછો ચાલ્યો ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“તું ઇસ્રાએલી લોકોને કહે કે તેમના કુળસમૂહના આગેવાનો તને કુળદીઠ એક એટલે એકંદરે બાર લાકડીઓ આપે. દરેકની લાકડી પર તેમનું નામ કોતરાવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","લેવીના કુળસમૂહની લાકડી પર હારુનનું નામ કોતરાવવું; કારણ કે લેવીના વંશની પણ એક જ લાકડી હોય. ");
INSERT INTO guj2009_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","પછી હું તેને મુલાકાત મંડપમાં કરારકોશ સમક્ષ મળું છું ત્યાં તારે આ લાકડીઓ મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","મેં જે માંણસને પસંદ કર્યો છે તેની લાકડીને કળીઓ ફૂટશે. આ રીતે હું ઇસ્રાએલી પ્રજાની તારી સામેની ફરિયાદોનો અંત લાવીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","મૂસાએ ઇસ્રાએલીઓને વાત કરી, તેથી કુળસમૂહોના આગેવાનો તેની પાસે પોતપોતાની લાકડી લાવ્યા. અને હારુનની લાકડી પણ તે લાકડીઓ સાથે મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","મૂસાએ એ લાકડીઓ મુલાકાત મંડપની અંદરની સાક્ષ્યમંડપમાં યહોવા સમક્ષ મૂકી. ");
INSERT INTO guj2009_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","બીજે દિવસે જયારે મૂસા અંદર ગયો ત્યારે લેવીના કુળનું પ્રતિનિધિત્વ કરતી હારુનની લાકડીને કળીઓ બેઠી હતી. ફૂલ ખીલ્યાં હતાં, અને પાકી બદામો પણ લાગી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","મૂસાએ યહોવા આગળથી એ લાકડીઓ બહાર લાવીને બધા ઇસ્રાએલીઓને બતાવી. તેમણે લાકડી સામે જોયુ, પ્રત્યેક આગેવાન તેની લાકડી પાછી લઈ લીધી. ");
INSERT INTO guj2009_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","યહોવાએ મૂસાને કહ્યું, “હારુનની લાકડી પાછી કરાર સમક્ષ મૂકી દે. એ બંડખોર ઇસ્રાએલીઓ માંટે ચેતવણીરૂપ છે, જેથી માંરી વિરુદ્ધના તેમના આ કચવાટનો અંત આવે અને એમને મરવું પડે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","યહોવાએ જણાવ્યું હતું તે મુજબ મૂસાએ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","છતાં ઇસ્રાએલી પ્રજાએ મૂસા સમક્ષ ફરિયાદ કરવાનું ચાલુ રાખ્યું: “આપણે જાણીએ છીએ કે આપણું મૃત્યુ નિશ્ચિત છે, આપણે ગુમાંવેલાં છીએ! આપણો બધાનો વિનાશ થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","જે કોઈ યહોવાનાં પવિત્ર સ્થાનની નજીક જાય છે, તેનું મૃત્યુ થાય છે. તો શું અમે બધા આમ જ મરી જવાના? શું અમાંરા સર્વનો નાશ થશે?” ");
INSERT INTO guj2009_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","યહોવાએ હારુનને કહ્યું, “પવિત્રસ્થાનની સેવાની જવાબદારી તારી, તારા પુત્રોની તેમજ લેવી વંશના બીજા બધા માંણસોની છે. સેવામાં દોષ ન આવે તથા યાજક તરીકેના કાર્યમાં કોઈ પણ દોષ ન રહે તે તારે તથા તારા પુત્રોને જોવાનું છે. તે જવાબદારી પણ તમાંરી જ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","તું અને તારા પુત્રો કરારનાં મંડપમાં સેવા કરો, ત્યારે તારા પિતાએ લેવીના કુળસમૂહના તારા બીજા જાતભાઈઓને પણ સાથે મદદમાં રાખવા. ");
INSERT INTO guj2009_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","તેઓ તારા હાથ નીચે રહીને તંબુને લગતી બધી જવાબદારી પુરી કરી શકે, માંત્ર તેમણે પવિત્રસ્થાનનાં પાત્રો કે વેદીની નજીક જવું નહિ. જો તેઓ જશે તો તેઓ બધાજ મૃત્યુ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","લેવી વંશ સિવાયના કોઈ પણ વ્યક્તિને તે કામમાં સાથે રાખવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“પવિત્રસ્થાનમાં અને વેદી સમક્ષ ફકત યાજકોએ જ પવિત્ર ફરજો બજાવવાની છે, જેથી ઇસ્રાએલી પ્રજા ઉપર ફરી કદી માંરો કોપ ઊતરશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","હું તને ફરીથી કહું છું, મેં પોતે બધા ઇસ્રાએલીઓમાંથી તારા કુટુંબી લેવીઓને મુલાકાતમંડપમાં સેવા બજાવવા માંટે પસંદ કર્યો છે. તેઓ મને સમર્પિત થયેલા છે. જે મેં તમને ભેટ આપ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","પરંતુ વેદીને લગતી અને પડદાની અંદર પરમપવિત્રસ્થાનમાં લગતી યાજક તરીકેની બધી જ ફરજો તારે અને તારા પુત્રોએ જ પુરી કરવાની છે. કારણ કે, તમાંરી યાજક તરીકેની સેવા મેં તમને ભેટો તરીકે આપી છે. બીજુ કોઈ જે માંરા પવિત્રસ્થાનની નજીક આવે તો તેને મૃત્યુદંડની જ શિક્ષા કરવી.” ");
INSERT INTO guj2009_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","વળી યહોવાએ હારુનને કહ્યું, “મને અર્પણ કરવામાં આવેલ બધી વસ્તુઓ મેં યાજકોને આપી છે. ઇસ્રાએલી પ્રજા મને જે કઈ ધરાવશે તે હું તારા ભાગ તરીકે તને અને તારા વંશજોને કાયમ માંટે આપું છું. ");
INSERT INTO guj2009_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","અગ્નિમાં હોમવામાં ન આવેલા અર્પણનાં ભાગો સિવાય આ બધા અતિ પવિત્ર અર્પણો તારા ગણાશો; બધા ખાદ્યાર્પણો, પાપાર્થાર્પણો અને દોષાર્થાર્પણો એ બધા પવિત્ર અર્પણો તારા અને તારા વંશજોના ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","તારે આ અર્પણો ફકત પવિત્રસ્થાનમાં જ જમવા. અને તે પણ ફકત પુરુષોએ જ જમવા; અને તારે પવિત્ર ગણવા. ");
INSERT INTO guj2009_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ઇસ્રાએલીઓ મને બીજા જે ઉચ્છાલીયાર્પણો ધરાવે તે પણ તારા જ ગણાશે. તે પણ હું તને અને તારાં પુત્રપુત્રીઓને કાયમ માંટે આપું છું. માંત્ર તે સમયે જે અશુદ્ધ હોય તે સિવાયના તમાંરાં કુટુંબના સર્વ સભ્યો આ જમી શકે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“અને યહોવાને અર્પણ કરવા માંટે લોકો પાકના પ્રથમ ફળ લાવે. ઉત્તમ જૈતતેલ, બધો ઉત્તમ નવો દ્રાક્ષારસ અને ઘઉ. તે બધા તારે લેવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","લોકો પોતાની ભૂમિના પ્રથમ પાક તરીકે જે કંઈ મને ધરાવવા લાવે તે બધુ તારું થશે. તમાંરાં કુટુંબના બધાં સભ્યો તે જમી શકે. સિવાય કે તે સમયે જે અશુદ્ધ હોય. ");
INSERT INTO guj2009_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ઇસ્રાએલમાં મને સમર્પિત પ્રત્યેક વસ્તુઓ તારી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“તેઓ મને પ્રથમજનિત બાળકો અને પશુઓ અર્પણ કરે તે પણ તારાં છે. છતાં પ્રત્યેક પ્રથમજનિત બાળકની તથા અશુદ્ધ પ્રાણીની કિંમત લઈને તારે તેમને મુકત કરવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","પ્રત્યેક પ્રથમજનિત બાળકને મુકત કરવાની કિંમતરૂપે અધિકારયુક્ત અધિકૃત માંપ પાંચ શેકેલ ચાંદી લેવી. અને બાળક એક મહિનાનું થાય ત્યારે તેને મુક્ત કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“પરંતુ ગાય, ઘેટા, અને બકરાના પ્રથમજનિતોને બદલામાં નાણાં લઈને મુકત ન કરવાં, કારણ કે, તેઓ સંપૂર્ણપણે યહોવાને સમર્પિત છે. તારે તેમનું લોહી વેદી પર છાંટવું અને તેમની ચરબી અર્પણ તરીકે હોમવી. તેની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","પરંતુ આરત્યર્પણ તરીકે ધરાવવામાં આવેલા પ્રાણીની છાતી અને જમણી જાંઘની જેમ એનું માંસ તારું ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","વેદી આગળ યહોવાને અર્પણ માંટે ઇસ્રાએલીઓ જે કોઈ પવિત્ર ભેટો ધરાવે તે બધી કાયમ માંટે તને, અને તારાં પુત્ર અને પુત્રીઓને આપેલ છે. તારી અને તારા વંશજોની સાથે મેં કરેલો આ કાયમી કરાર છે, જેનો કદી ભંગ થઈ શકે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","યહોવાએ હારુનને કહ્યું, “તમને યાજકોને બીજા ઇસ્રાએલીઓની જેમ તમાંરી પોતાની ભૂમિ કે ભૂમિમાં ભાગ હોય નહિ. કારણ કે હું જ ઇસ્રાએલીઓ મધ્યે તમાંરો હિસ્સો અને તમાંરો વારસો છું. ");
INSERT INTO guj2009_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“લેવીઓ મુલાકાત મંડપની જે સેવા બજાવે છે તેના બદલામાં હું તેમને ઇસ્રાએલમાંથી ઉઘરાવાતી બધી વસ્તુઓનો દશમો ભાગ આપું છું. ");
INSERT INTO guj2009_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","હવે પછી યાજકો અને લેવીઓ સિવાય અન્ય કોઈ પણ ઇસ્રાએલી મુલાકાત મંડપમાં પ્રવેશ કરશે નહિ. જો પ્રવેશ કરશે તો મોતની સજા વહોરી લેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","મુલાકાત મંડપની સેવા ફકત લેવીઓએ જ કરવી અને તેની બધી જ જવાબદારી ઉઠાવવી. આ કાયમી કાનૂન છે અને જ તમાંરા વંશજોને પણ બંધનકર્તા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","લોકોએ તેમની પાસે જે કાઈ હોય તેનો દશમો ભાગ યહોવાને અર્પણ કરવા. તે અર્પણો લેવીઓના છે. તે હું તેમને તેમના વારસા તરીકે આપુ છું; તેથી જ મેં આ શબ્દો લેવીઓ વિષે કહ્યાં હતાં, તેઓને બીજા ઇસ્રાએલીઓની જેમ જમીન જાગીર મળે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“તું લેવીઓને જણાવ કે, મેં તમાંરે માંટે ઠરાવેલો ઇસ્રાએલીઓ તરફથી મળવો જોઈતો દશમો ભાગ મને વિશેષ ભેટ તરીકે ધરાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","આમ યહોવાને અર્પણ કરવામાં આવેલું અનાજ અને દ્રાક્ષારસ જાણે કે તમાંરી પ્રથમ પાકનું અર્પણ છે અને તમાંરી પોતાની જ સંપતિમાંથી અર્પણ કરેલું છે તેમ યહોવા તેનો સ્વીકાર કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","આ રીતે ઇસ્રાએલીઓ તરફથી તમને મળેલા દશમાં ભાગમાંથી માંરે માંટે એક ભાગ જુદો કાઢી મુકશો, તો તે તમાંરી કમાંણીનો દશમો ભાગ મને અર્પણ તરીકે ગણાશે. તમે માંરે માંટે જુદો રાખેલો ભાગ યાજક હારુનને આપજો. ");
INSERT INTO guj2009_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","તમને જે મળે તેમાંથી જે શ્રેષ્ઠ છે તે યહોવાનો ભાગ બને છે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“મૂસા, લેવીઓને કહો! તે જાણો તમાંરી જ જમીનની તથા દ્રાક્ષાકુંડની ઊપજનો દશમો ભાગ હોય તેમ ગણવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","હારુન અને તેના પુત્રો તથા તેઓનાં કુટુંબો પોતપોતાનાં ઘરોમાં અથવા પોતાને ગમે તે જગ્યાએ તેઓ તેને જમી શકશે, કારણ કે મુલાકાત મંડપમાંની તેઓની સેવાનું તે વેતન ગણાશે, બદલો ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","તમે એ પ્રમાંણે યાજકોને તમાંરો દશાંશ શ્રેષ્ઠ ભાગ આપશો, તો પછી ઇસ્રાએલીઓએ ધરાવેલી પવિત્ર ભેટો ભ્રષ્ટ કરવાનો દોષ તમાંરે માંથે આવશે નહિ, અને તમાંરે મૃત્યુ પામવું પડશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","યહોવાએ મૂસાને અને હારુનને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ઇસ્રાએલના લોકોને આ કાનૂનો જણાવ: તેઓ ખોડખાંપણ વગરની અને કદી જોતરાઈ ના હોય તેવી એક લાલ ગાય મૂસા અને હારુન પાસે લાવે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","તારે એ ગાય યાજક એલઆઝારને આપવી. અને તેણે તેને છાવણી બહાર લઈ જવી અને ત્યાં તેને માંરી નાખવી. ");
INSERT INTO guj2009_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","એલઆઝાર તેનું થોડું લોહી પોતાની આંગળી પર લે અને મુલાકાતમંડપની આગળ તેનાં સાત વખત છંટકાવ કરે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ત્યારબાદ યાજકની સમક્ષ બીજી કોઈ પવિત્ર વ્યક્તિ ગાયનું ચામડું, માંસ, રક્ત તથા છાણનું દહન કરે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ત્યારબાદ યાજકે ગંધતરુંનું લાકડું, ઝુફો અને કિરમજી રંગની દોરી લઈને ગાયનું દહન થતું હોય ત્યારે તે અગ્નિમાં નાખવું. ");
INSERT INTO guj2009_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ત્યારબાદ તેણે પોતાનાં કપડાં ધોઈ નાખવાં અને આખા શરીરે સ્નાન કરવું અને છાવણીમાં પાછા ફરવું. સાંજ સુધી વિધિ અનુસાર તે અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","જેણે ગાયનું દહન કર્યુ હોય તેણે પોતાનાં કપડાં ધોઈ નાખવાં અને આખા શરીરે સ્નાન કરવું, છતાં તે પણ સાંજ સુધી અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“તે પછી વિધિ મુજબ જે શુદ્ધ ન હોય તેવી વ્યક્તિએ ગાયની રાખ ભેગી કરવી, અને છાવણી બહાર શુદ્ધ કરેલી જગ્યાએ તેની ઢગલી કરવી. અને તે રાખ વ્યક્તિના પાપ દૂર કરવાની વિધિ માંટેનું પાવકજળ બનાવવા રાખી મૂકવી. ");
INSERT INTO guj2009_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“જે માંણસે ગાયની રાખ ભેગી કરી હોય તેણે પોતાનાં કપડાં ધોઈ નાખવાં, પણ તે સાંજ સુધી અશુદ્ધ ગણાશે. “ઇસ્રાએલી પ્રજા માંટે અને તમાંરી ભેગા રહેતા વિદેશીઓ માંટે આ કાયમી નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","જે કોઈ મનુષ્યના મૃતદેહને સ્પર્શ કરે તેને સાત દિવસ સૂતક પાળવું. ");
INSERT INTO guj2009_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","પછી તેણે ત્રીજે અને સાતમે દિવસે પાવકજળ વડે પોતાની શુદ્ધિ કરાવવી. ત્યારબાદ તે શુદ્ધ થયો ગણાશે. પણ જો તે આ પ્રમાંણે ત્રીજા દિવસે અને સાતમે દિવસે પોતાની શુદ્ધિ નહિ કરાવે તો તે શુદ્ધ નહિ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","જે કોઈ મનુષ્ય મૃતદેહને સ્પર્શ કર્યા પછી જણાવેલી રીત મુજબ પોતાને શુદ્ધ નહિ કરે તો તે યહોવાના મુલાકાતમંડપને અશુદ્ધ કરે છે. તેના પર શુદ્ધિજળ છાંટવામાં આવ્યું નથી તેથી તેવા માંણસનો બહિષ્કાર કરવો, કારણ કે તે યહોવાના મંદિરને અપવિત્ર કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“જો કોઈ માંણસ તંબુમાં મૃત્યુ પામે તો તે માંટે આ નિયમો છે: તંબુમાં તે વખતે પ્રવેશ કરનારા અને મૃત્યુ સમયે હાજર રહેનારા સૌને સાત દિવસનું સૂતક લાગે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","મંડપમાંનું ઢાકણ વગરનું પ્રત્યેક માંત્ર અશુદ્ધ ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","જો કોઈ મંડપની બહાર હથિયારથી અથવા કુદરતી રીતે મૃત્યુ પામેલા માંણસને સ્પર્શ કરે અથવા હાડકાંને કે કબરને સ્પર્શ કરે તો તે સાત દિવસ સૂતકી ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“આવા સૂતક માંટે પાપાર્થાર્પણની લાલ ગાયની રાખને વાસણમાં લઈ ઝરાના પાણી સાથે મિશ્ર કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ત્યારબાદ જે વ્યક્તિ શુદ્ધ ના હોય તેણે ઝુફો લઈને એ પાણીમાં બોળીને તેના વડે મંડપ ઉપર અને તેમાંનાં બધાં પાત્રો ઉપર તથા તેમાંના બધા માંણસો ઉપર છાંટવું, જેણે વ્યક્તિના હાડકાને કે મરેલા કે માંરી નાખવામાં આવેલા વ્યક્તિના મૃતદેહને કે કબરને સ્પર્શ કર્યો હોય તો તે વ્યક્તિ ઉપર પણ છાટવું. ");
INSERT INTO guj2009_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“સૂતક વગરના માંણસે સૂતકવાળા માંણસ ઉપર ત્રીજે અને સાતમે દિવસે પાણી છાંટવું. અને સાતમે દિવસે તેણે તે માંણસની શુદ્ધિ કરવી. સૂતકી માંણસે એ દિવસે પોતાના કપડા ધોઈ નાખવાં, પોતે આખા શરીરે સ્નાન કરવું, એટલે સાંજે તે શુદ્ધ થયો ગણાશે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“પરંતુ જો કોઈ સૂતકી પોતાની શુદ્ધિ ન કરાવે તો તેનો સમાંજમાંથી બહિષ્કાર કરવો, કારણ, તેણે પવિત્ર મંડપને ભ્રષ્ટ કર્યુ છે, તેના પર શુદ્ધિજળ છાંટવામાં આવ્યું નથી, તેથી તે સૂતકી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","આ તમાંરે માંટે કાયમી નિયમ છે. પાણીનો છંટકાવ કરનાર વ્યક્તિ ત્યારબાદ પોતાનાં કપડાં ધોઈ નાખે. વળી જે કોઈ તે પાણીને સ્પર્શ કરે તે પણ સાંજ સુધી સૂતકી ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","સૂતકી વ્યક્તિ જે કોઈ વસ્તુને સ્પર્શ કરે તે પણ સાંજ સુધી અશુદ્ધ ગણાય; અને તે વસ્તુને સ્પર્શ કરનાર વ્યક્તિ પણ સાંજ સુધી અશુદ્ધ ગણાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","પહેલા મહિનામાં બધાં ઇસ્રાએલીઓ સીનના અરણ્યમાં આવ્યાં અને કાદેશમાં પડાવ નાખ્યો. ત્યાં મરિયમનું અવસાન થતાં તેને દફનાવવામાં આવી. ");
INSERT INTO guj2009_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","તે સ્થળે સમાંજ માંટે પૂરતું પાણી નહોતું તેથી બધા લોકો મૂસાની અને હારુનની વિરુદ્ધ ટોળે વળીને કચકચ કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","એ લોકો મૂસા સાથે ઝઘડવા લાગ્યા, “યહોવાની સામે જ અમાંરા ભાઈઓ મૃત્યુ પામ્યા ત્યારે જ અમે પણ મરી ગયા હોત તો સારૂ થાત. ");
INSERT INTO guj2009_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","તું યહોવાના સમાંજને ઈરાદાપૂર્વક આ અરણ્યમાં લાવ્યો છે, અમે અને અમાંરા ઘેટાંબકરાં તથા ઢોરઢાંખર અહીં મરી જઈએ એટલા માંટે તું લઈ આવ્યો છે? ");
INSERT INTO guj2009_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","તું શા માંટે અમને મિસરમાંથી બહાર લઈ આવ્યો? શા માંટે તું અમને આ ખરાબ જગ્યાએ લઈ આવ્યો? આ જગ્યાએ નથી અનાજ કે અંજીર કે દ્રાક્ષ કે દાડમ. અહી તો પીવાનું પાણી પણ નથી.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","મૂસા અને હારુન તેઓ પાસેથી મુલાકાત મંડપના પ્રવેશદ્વાર આગળ ગયા. તેમણે ભૂમિ પર પડીને સાષ્ટાંગ નમસ્કાર કર્યા. અને યહોવાના ગૌરવે તેમને દર્શન દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“તું કરારકોશ પાસે પડેલી લાકડી લે, અને પછી તારા ભાઈ હારુન સાથે સમગ્ર સમાંજને ભેગો કર અને સૌના દેખતા ખડકને કહે કે તે પોતાનું પાણી આપે! આમ તું કહીશ એટલે એમાંથી તેઓને અને તેઓનાં પશુઓને પીવા માંટે પાણી પુષ્કળ પ્રમાંણમાં નીકળશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","યહોવાએ આજ્ઞા કરી તે પ્રમાંણે મૂસાએ યહોવા સમક્ષ મૂકેલી લાકડી લીધી. ");
INSERT INTO guj2009_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","પછી મૂસાએ અને હારુને સમગ્ર સમાંજને ખડક આગળ ભેગો કર્યો અને તેણે તેઓને કહ્યું, “ઓ બંડખોરો, સાંભળો, અમે શું આ ખડકમાંથી તમાંરા માંટે પાણી કાઢીએ?” ");
INSERT INTO guj2009_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","પછી મૂસાએ હાથ ઊચો કરીને લાકડી બે વખત ખડક પર પછાડી એટલે ખડકમાંથી પુષ્કળ પાણી ધસારા સાથે બહાર નીકળ્યું. તે સૌએ તથા પશુઓએ ધરાઈને પીધું. ");
INSERT INTO guj2009_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","પણ યહોવાએ મૂસાને અને હારુનને કહ્યું, “બધા ઇસ્રાએલીઓ સમક્ષ તમે તમાંરું માંરા પ્રત્યે સન્માંન બતાવ્યું નહિ. તમે તેઓને બતાવ્યું નહિ કે પાણી કાઢવાની શક્તિ માંરામાંથી આવી હતી તેઓને તમે બતાવ્યું નહિ કે તમે માંરામાં વિશ્વાસ કર્યો હતો તેથી મેં તેઓને જે ભૂમિ આપવાનું વચન આપ્યું હતું ત્યાં તમે તે લોકોને લઈ જશો નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","આ સ્થળનું નામ “મરીબાહ” નું પાણી એટલે “તકરારનું પાણી” પાડવામાં આવ્યું કારણ કે, “મરીબાહ” ના ઝરા આગળ આ બન્યું હતું. જયાં ઇસ્રાએલીઓએ યહોવા વિરુદ્ધ ઝઘડો કર્યો હતો અને જયાં યહોવાએ તેમને પરચો બતાવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","કાદેશથી મૂસાએ આ સંદેશા સાથે સંદેશવાહકો એદોમના રાજાને મોકલ્યા, “આ સંદેશો તમાંરા ઇસ્રાએલી ભાઈઓ તરફથી છે. અમાંરે કેવી હાડમાંરી સહન કરવી પડી છે એ તમે જાણો છો. ");
INSERT INTO guj2009_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","અમાંરા પિતૃઓ મિસર ગયા હતા અને ત્યાં અમે લાંબો સમય રહ્યાં હતાં પરિણામે તેઓ મિસરવાસીઓના ગુલામો બન્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","પરંતુ અમે યહોવાને પોકારીને કહ્યું ત્યારે તેમએ અમાંરો પોકાર સાંભળીને એક દેવદૂતને મોકલી આપ્યો, જે અમને મિસરમાંથી બહાર લઈ આવ્યો. “અત્યારે અમે તમાંરી સરહદે આવેલા કાદેશમાં છાવણી કરી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","કૃપા કરીને અમને તમાંરા દેશમાં થઈને જવાની રજા આપો. અમે તમાંરા ખેતરમાંથી કે દ્રાક્ષનીવાડીઓમાંથી પસાર થઈશું નહિ, કે તમાંરા કૂવાનું પાણી પણ પીશું નહિ, અમે આમ કે તેમ વાંકાચૂકા ગયા વિના રાજમાંર્ગે તમાંરો દેશ વટાવી જઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","પરંતુ અદોમના રાજાઓ કહ્યું, “તમાંરે અમાંરા દેશમાં થઈને જવાનું નથી. જો તમે ગયા તો અમે તરવાર લઈને સામાં થઈશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ઇસ્રાએલીઓએ કહ્યું, “અમે રાજમાંર્ગ થઈને ચાલ્યા જઈશું. જો અમે અને અમાંરાં પશુઓ તમાંરું પાણી પીશું તો અમે તેની રકમ ચૂકવીશું. અમે ફકત તમાંરા દેશમાં થઈને પગપાળા જવાની રજા માંગીએ છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","છતાં અદોમના રાજાએ ચેતવણી આપીને કહ્યું, “નહિ, તમાંરે જવાનું નથી. માંરા દેશની બહાર રહો.” પછી પોતાનું સૈન્ય એકત્ર કરીને પૂરી તાકાતથી તેમની સામે લડવા માંટે ઘસી આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","અદોમીઓએ ઇસ્રાએલીઓને પોતાના દેશમાં થઈને જવા દેવાની ના પાડી એટલે ઇસ્રાએલીઓ ફરીને બીજે રસ્તે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ઇસ્રાએલીઓનો આખો સમાંજ કાદેશથી નીકળીને અદોમની સરહદે આવેલા હોર પર્વત પાસે આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ત્યાં યહોવાએ મૂસાને અને હારુનને કહ્યુ, ");
INSERT INTO guj2009_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“હારુન પિતૃલોક ભેગો થનાર છે. મેં ઇસ્રાએલીઓને જે ભૂમિ આપવાનું વચન આપ્યું છે તેમાં એ દાખલ થઈ શકશે નહિ, કારણ કે, મરીબાહના ઝરણા આગળ તમે માંરી આજ્ઞાનું ઉલ્લંઘન કર્યુ હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“હારુન અને તેના પુત્ર એલઆઝારને લઈને તું હોર પર્વત ઉપર જા. ");
INSERT INTO guj2009_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ત્યાં તું હારુનના યાજક તરીકેનાં વસ્ત્રો ઉતારી લઈને તેના પુત્ર એલઆજારને એ પહેરાવજે. હારુન ત્યાં અવસાન પામશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","મૂસાએ યહોવાના કહ્યા પ્રમાંણે કર્યું. સમગ્ર સમાંજના દેખતાં જ તે લોકો હોર પર્વત પર ગયા. ");
INSERT INTO guj2009_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","જયારે પર્વતના શિખર પર પહોંચ્યા ત્યારે મૂસાએ હારુનના યાજક તરીકેના વસ્ત્રો ઉતારી લઈને તેના પુત્ર એલઆઝારને પહેરાવ્યાં. ત્યાં પર્વતના શિખર પર હારુનનું મૃત્યુ થયું, પછી મૂસા અને એલઆઝાર પાછા ફર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","સમગ્ર સમાંજને ખબર પડી કે હારુનું મૃત્યુ થઈ ગયું છે, ત્યારે બધા ઇસ્રાએલીઓએ ત્રીસ દિવસ સુધી તેને માંટે શોક પાળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","જયારે નેગેબમાં રહેતા અરાદના કનાની રાજાએ સાંભળ્યું કે ઇસ્રાએલી પ્રજા અથારીમ તરફ જઈ રહી છે ત્યારે તેણે પોતાના સૈન્યને એકત્ર કરીને તેમના ઉપર હુમલો કરીને તેમાંના કેટલાકને બંદીવાન તરીકે પકડી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","તેથી ઇસ્રાએલીઓએ યહોવાને વચન આપ્યું કે, “તું જો આ લોકોને અમાંરા હાથમાં સોંપી દે તો અમે એમનાં ગામો યહોવાને અર્પણ કરીશું અને તેઓનો સંપૂર્ણ નાશ કરીશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","યહોવાએ ઇસ્રાએલીઓની વિનંતી માંન્ય રાખી કનાનીઓને હરાવ્યા અને ઇસ્રાએલીઓના હાથમાં સોંપી દીધા. ઇસ્રાએલીઓએ તેઓનો તથા તેમના નગરોનો સંપૂર્ણ નાશ કર્યો. અને તે જગ્યાનું નામ હોર્માંહ પાડયું. ");
INSERT INTO guj2009_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ઇસ્રાએલીઓ હોર પર્વત પાછા ફર્યા, ત્યાંથી તેઓ દક્ષિણ તરફ રાતા સમુદ્રને રસ્તે થઈને અદોમ દેશ ફરતાં આગળ ગયા; હવે લોકોની ધીરજ ખૂટી ગઈ હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","તેઓ દેવની અને મૂસાની વિરુદ્ધ બોલવા લાગ્યા, “તમે શા માંટે અમને મિસરમાંથી લઈ આવ્યા. અહી મરવા માંટે? અહીં ખાવા અનાજ નથી, પીવાને પાણી નથી. આ સ્વાદરહિત માંન્નાથી તો અમે કંટાળી ગયા છીએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ત્યારે યહોવાએ તેમની વચ્ચે તેઓને શિક્ષા કરવા ઝેરી સાપ મોકલ્યા અને ઘણા ઇસ્રાએલી લોકો સાપ કરડવાથી મૃત્યુ પામ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","તેથી લોકો મૂસા પાસે આવ્યા અને કહેવા લાગ્યા, “અમે યહોવાની અને તારી વિરુદ્ધ બોલીને પાપ કર્યુ છે, તું અમને આ સર્પોથી છોડાવવા માંટે યહોવાને પ્રાર્થના કર.” તેથી મૂસાએ લોકો માંટે પ્રાર્થના કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","અને યહોવાએ મૂસાને કહ્યું, “ઝેરી સાપના આકાર વાળો એક પિત્તળનો સાપ બનાવ અને તેને લાકડીની ટોચ પર મૂક, જેથી જેને સાપ કરડયા હોય તે તેને જોઈને સાજાં થઈ જાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","તેથી મૂસાએ પિત્તળનો સાપ બનાવીને સ્તંભ પર મૂકયો, અને જેને જેને સાપ કરડયો હોય તે તેના તરફ જોતાં જ સાજા થઈ જતાં. ");
INSERT INTO guj2009_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ઇસ્રાએલી પ્રજાએ આગળ મુસાફરી કરીને ઓબોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","અને ઓબોથથી નીકળી તેમણે મોઆબની પૂર્વ સરહદે આવેલા અરણ્યમાં ઈયેઅબારીમમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","અને ત્યાંથી નીકળીને તેમણે ઝેરેદના ઝરાની ખીણ આગળ મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ત્યારબાદ તેમણે ઝેરેદથી નીકળી આર્નોન નદીની ઉત્તર બાજુએ અમોરીઓ વચ્ચેની સરહદ સુધી જતા અરણ્યમાં મુકામ કર્યો. આર્નોન મોઆબીઓ અને અમોરીઓ વચ્ચેની સરહદ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","આથી યહોવાના યુદ્ધોના ગ્રંથમાં લખ્યું છે, “આર્નોન નદી અને સૂફામાં વાહેબની ખીણો, ");
INSERT INTO guj2009_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","અને આર શહેરને મળતા ખીણો પર્વતો. આ જગ્યાઓ મોઆબની સરહદ પર આવેલી છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ત્યારબાદ ઇસ્રાએલી પ્રજા મુસાફરી કરીને બએર (કૂવો) આવી. અહીંના કૂવા આગળ યહોવાએ મૂસાને કહ્યું હતું કે, “તું લોકોને એકઠા કર અને હું તેઓને પાણી આપીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","અને તે સમયે ઇસ્રાએલી લોકોએ આ ગીત ગાયું હતું: “હે કૂવા, તારું પાણી ઉપર આવો, તમને ગીતથી વધાવીશું અમે. ");
INSERT INTO guj2009_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","પ્રજાના આગેવાનોએ આ કૂવો ખોદ્યો છે અને, રાજદંડને લાકડીઓથી તેઓએ ખોદ્યો છે, આ તો અરણ્યમાં ભેટ છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ત્યાંથી તેઓ અરણ્યમાં થઈને માંત્તાનાહ ગયા અને માંત્તાનાહથી નાહલીએલ, અને નાહલીએલથી બામોથ, ");
INSERT INTO guj2009_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","અને બામોથથી મોઆબીઓના પ્રદેશમાં પિસ્ગાહના શિખરની તળેટીમાં રણ તરફ આવેલી ખીણ તરફ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ત્યાર પછી ઇસ્રાએલે પોતાના કાસદો માંરફતે અમોરીઓના રાજા સીહોનને સંદેશો મોકલ્યો કે, ");
INSERT INTO guj2009_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“કૃપા કરીને અમને તમાંરા દેશમાં થઈને જવા માંટે રજા આપો, અમે તમાંરા ખેતરો કે દ્રાક્ષની વાડીઓમાં થઈને જઈશું નહિ, અમે તમાંરા કૂવાઓમાંથી પાણી પણ પીશું નહિ. અમે તમાંરી સરદહને પેલે પાર નહિ જઈએ ત્યાં સુધી અમે ફકત મુખ્ય રસ્તાઓ ઉપર જ ચાલીશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","પરંતુ સીહોને ઇસ્રાએલીઓને પોતાના દેશમાં થઈને જવા દીધા નહિ. તેણે પોતાના સૈન્યને એકત્ર કર્યુ અને રણમાં ઇસ્રાએલીઓ ઉપર હુમલો કર્યો અને યાહાસ પાસે પહોંચી ગયો. ત્યાં તેઓની સાથે યુદ્ધ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","પણ ઇસ્રાએલીઓએ તેમનો સંહાર કર્યો અને આર્નોનથી યાબ્બોક, આમ્મોનીઓની સરહદ સુધીનો તેમનો પ્રદેશ કબજે કરી લીધો. અહીં તેઓ અટકી ગયા; કારણ કે આમ્મોનની સરહદે રક્ષણ મજબૂત હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ઇસ્રાએલીઓએ હેશ્બોન અને તેની આસપાસનાં ગામો સહિત અમોરીઓનાં બધાં શહેરો જીતી લીધાં અને તેમાં તેમણે રહેવાનું શરૂ કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","હેશ્બોન અમોરીઓના રાજા સીહોનની રાજધાનીનું નગર હતું. અગાઉના મોઆબના રાજા સામે સીહોને યુદ્ધ કરીને આર્નોન સુધીનો તેનો બધો પ્રદેશ લઈ લીધો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","તેથી ગાયકોએ આ ગીત ગાયું છે: “જાઓ અને હેશ્બોન ફરીથી બાંધો, હાં, ચાલો આપણે સીહોનના શહેરને; મજબૂત બનાવી અને તેને ફરી વસાવીએ. ");
INSERT INTO guj2009_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","એક વખત હેશ્બોનમાંથી નીકળ્યાં હતાં આગ, જેમ સીહોનનાં લશ્કર; આર્નોનના પર્વતને ગળી જઈ, ભસ્મ કર્યુ મોઆબનું આર નગર. ");
INSERT INTO guj2009_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","આ શી તમાંરી દશા! મોઆબ તને દિલગીરી! કમોશના ભજનિકોનો નાશ! નિરાશ્રિત બનાવ્યો તને તારા દેવે, દિલગીરી! અને તમાંરી સ્ત્રીઓ બની, અમોરીઓના રાજા સીહોનની કેદી, દિલગીરી! ");
INSERT INTO guj2009_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","અને હવે કર્યો છે એના ઉપર આપણે હલ્લો, હેશ્બોન, દીબોન, નોફાહ, ને મેદબાનો થયો વિનાશ!” ");
INSERT INTO guj2009_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","આ રીતે ઇસ્રાએલીઓ અમોરીઓના પ્રદેશમાં વસવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","મૂસાએ યાઝેર નગર પર કેવી રીતે હુમલો કરવો તેની જાસૂસી કરવા માંટે માંણસો મોકલ્યા. અને ઇસ્રાએલીઓએ આસપાસનાં ગામો સહિત યાઝેરનો કબજો લીધો અને ત્યાં વસતા અમોરીઓને હાંકી કાઢયા. ");
INSERT INTO guj2009_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","પછી તેઓએ બાશાન તરફના રસ્તા પર મુસાફરી કરી, બાશાનનો રાજા ઓગ યુદ્ધ માંટે પોતાના સૈન્ય સાથે એડ્રેઈ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","યહોવાએ મૂસાને કહ્યું, “એનાથી ડરતો નહિ, કારણ કે મેં તેને, એની પ્રજાને અને તેના દેશને તમાંરા હાથમાં સોંપી દીધાં છે. હેશ્બોનમાં રહેતાં અમોરીઓના રાજા સીહોનની જેવી હાલત કરી, તેવી જ હાલત તમે તેની કરજો.” ");
INSERT INTO guj2009_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","અને એ પ્રમાંણે જ થયું. ઇસ્રાએલનો વિજય થયો. ઇસ્રાએલીઓએ રાજા ઓગ, તેના પુત્રો અને તેના સર્વ લોકોનો સંહાર કર્યો જીવતો પાછો જવા પામ્યો નહિ. અને ઇસ્રાએલીઓએ તેનો પ્રદેશ કબજે કરી લીધો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","પછી ઇસ્રાએલી લોકો આગળ યાત્રા કરીને મોઆબના મેદાનમાં યર્દન નદીને પૂર્વકાંઠે યરીખોની સામે આવ્યા અને ત્યાં પડાવ નાખ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","અમોરીઓના જે હાલ ઇસ્રાએલીઓએ કર્યા હતા તે મોઆબના રાજા સિપ્પોરના પુત્ર બાલાકે જોયા, ત્યારે તે અને તેના લોકો ઇસ્રાએલીઓથી થથરી ગયા. એમની બહુ મોટી સંખ્યા જોઈને મોઆવીઓ ભયભીત થઈ ગયા. ");
INSERT INTO guj2009_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","અને એમણે મિદ્યાનના આગેવાનોને કહ્યું, “જેમ કોઈ બળદ ચરામાંનું ઘાસ ખાઈ જાય છે, તેમ આ ધાડા આપણને ખાઈ જશે.” અને તે સમયે સિપ્પોરનો દીકરો બાલક મોઆબનો રાજા હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","તેથી રાજા બાલાકે, બયોરના પુત્ર બલામને બોલાવી લાવવા માંટે તેણે તેના માંણસોને મોકલ્યા. તે વખતે બલામ તેના વતનમાં યુફ્રેતિસ નદીને કિનારે પથોરમાં રહેતો હતો; તે તેને આ સંદેશો આપવાના હતા, “મિસરમાંથી સમગ્ર પ્રજા આવી ગઈ છે, તેઓ એટલા બધા છે કે તેઓ સમગ્ર ભૂમિ ઢાંકી દે. તેઓએ માંરી પાસે જ પડાવ નાંખ્યો છે. માંટે તમે આવીને મને મદદ કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","એ લોકો અમાંરા કરતાં વધારે મજબૂત છે, તેથી કૃપા કરીને તરત આવો અને એ લોકોને શ્રાપ આપો, તો કદાચ હું એ લોકોને હરાવીને દેશમાંથી હાંકી કાઢી શકું, મને ખબર છે કે, તમે જેને આશીર્વાદ આપો છો તેઓની સાથે સારું થાય છે અને તમે જેને શ્રાપ આપો છો તેઓની સાથે ખોટું થાય છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","તેણે મોઆબના અને મિદ્યાનના ઉચ્ચકક્ષાના આગેવાનોને સંદેશવાહકો તરીકે મોકલ્યા હતા. જદુમંતરની દક્ષિણા સાથે તેઓએ બલામ પાસે આવીને તેને બાલાકનો સંદેશો કહી સંભળાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","બલામે તેઓને કહ્યું, “આજની રાત તમે અહીં રહો, હું તમને યહોવા કહેશે તે જવાબ આપીશ.” તેથી મોઆબના આગેવાનો બલામ સાથે રાત રહ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","તે રાત્રે દેવે બલામ પાસે આવીને પૂછયું, “તારી સાથે આ માંણસો કોણ છે?” ");
INSERT INTO guj2009_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","બલામે જવાબ આપ્યો, “મોઆબના રાજા સિપ્પોરના પુત્ર બાલાક પાસેથી તેઓ આવ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","તેમણે કહેવડાવ્યું છે કે મિસરમાંથી એક પ્રજા માંરી સરહદે આવી પહોંચી છે, તેઓ સંખ્યામાં એટલા બધા છે કે તેઓ સમગ્ર ભૂમિ ઢાંકી દે. કૃપા કરીને આવો અને એ લોકોને શ્રાપ આપો, તો હું એ લોકોને હરાવીને દેશમાંથી હાંકી કાઢી શકુ.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","દેવે બલામને કહ્યું, “તારે એમની સાથે જવાનું નથી કે તે લોકોને શ્રાપ આપવાનો નથી, કારણ કે મેં તેઓને આશીર્વાદ આપેલા છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","તેથી બલામે બીજી સવારે વહેલા ઊઠીને બાલાકના કર્મચારીઓને કહ્યું, “તમે તમાંરા દેશમાં પાછા જાઓ, કારણ કે, યહોવાએ મને તમાંરી સાથે આવવાની ના પાડી છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","તેથી મોઆબના આગેવાનોએ ત્યાંથી નીકળીને પાછા બાલાક પાસે જઈને તેને કહ્યું, “બલામે અમાંરી સાથે આવવાની ના પાડી છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","બાલાકે ફરીથી પ્રયત્ન કર્યો, અને પહેલાં કરતાં સંખ્યામાં વધારે અને વધારે પ્રતિષ્ઠિત આગેવાનોને મોકલ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","એટલે તેમણે બલામ પાસે આવીને જણાવ્યું, “સિપ્પોરના પુત્ર બાલાકે આ મુજબ સેદેશો મોકલ્યો છે. કૃપા કરીને તમે માંરી પાસે જલદી આવી પહોંચવામાં કોઈ અવરોધ ઊભો થવા દેશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","હું તમને ભારે મોટો બદલો આપીશ અને તમે જે કહેશો તે હું કરીશ, માંટે જરૂર આવશો અને આ લોકોને શ્રાપ આપશો.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","બલામે બાલાકના માંણસોને જવાબ આપ્યો, “જો તે મને તેના મહેલમાંનું તમાંમ સોનું અને ચાંદી આપે તોયે હું નાની કે મોટી કોઈ પણ બાબતમાં માંરા દેવ યહોવાની આજ્ઞા વિરુદ્ધ કંઈ કરી શકું તેમ નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","એટલે આજની રાત પેલા લોકોની જેમ તમે પણ રોકાઈ જાઓ એટલે યહોવાએ પહેલાં જે કહ્યું હતું તે કરતાં કંઈક વિશેષ કહેવું હોય તો તે હું જાણી શકું.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","રાત્રી દરમ્યાન દેવે આવીને બલામને કહ્યું, “જો આ લોકો તને બોલાવવા આવ્યા હોય, તો તું ઝટ ઊઠીને તેમની સાથે જા, પણ હું તને કહું એટલું જ તું કરજે, અને તેનું ધ્યાન રાખજે.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","આથી બલામ બીજી સવારે પોતાની ગધેડી ઉપર જીન બાંધીને મોઆબના આગેવાનો સાથે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","પરંતુ બલામ તેઓની સાથે ગયો તેથી દેવને તેના પર રોષ ચઢયો, જ્યારે બલામ પોતાના બે નોકરો સાથે ગધેડી પર સવાર થઈને જતો હતો ત્યારે તેને રોકવા માંટે તેના રસ્તામાં યહોવાનો દૂત ઊભો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","અચાનક રસ્તાની વચ્ચે તરવાર ખેચીને ઊભેલા યહોવાના દૂતને ગધેડીએ જોયો, તેથી ગધેડીએ પોતાનો રસ્તો બદલ્યો અને ખેતરમાં વળી ગઈ. બલામ તેને માંરીને ફરી રસ્તા પર લઈ આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","પછી યહોવાનો દૂત એક નાળિયા આગળ જઈને ઊભો રહ્યો, જેની બંને બાજુએ પથ્થરોની વાડ કરેલી દ્રાક્ષની વાડીઓ આવેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","યહોવાના દૂતને જોતા ગધેડી એક તરફ પથ્થરની વાડની નજીક ચાલવા લાગી અને બલામનો પગ દિવાલમાં ચગદાયો, તેથી તેણે ગધેડીને ફરી માંરી. ");
INSERT INTO guj2009_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ત્યાંથી આગળ જઈને યહોવાનો દૂત એક એવી સાંકડી જગ્યાએ ઊભો રહ્યો કે, જયાંથી ગધેડી આમતેમ ડાબીજમણી બાજુએ ફંટાઈ શકે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","યહોવાના દૂતને જોઈ તે બલામ સાથે જમીન પર બેસી પડી, તેથી બલામ એકદમ ગુસ્સે થઈ ગયો અને તેણે ગધેડીને ફરીથી લાકડીએ લાકડીએ માંરી. ");
INSERT INTO guj2009_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","પછી યહોવાએ ગધેડીને વાચા આપી. તેણે બલામને કહ્યું, “મેં તારું શું બગાડયું છે? તેં મને ત્રણ વખત શા માંટે માંરી?” ");
INSERT INTO guj2009_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","બલામે મોટા સાદે જવાબ આપ્યો, “કારણ કે તું માંરી ફજેતી કરે છે, અત્યારે જો માંરી પાસે તરવાર હોત તો મેં તને અત્યારે જ કાપી નાખી હોત.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ગધેડીએ બલામને પૂછયું, “જો હું કંઈ તારાથી અજાણી છું? તેં આખુ જીવન તો માંરા પર સવારી કરી છે. માંરા સમગ્ર જીવનમાં મેં પહેલા કદી આવું કર્યુ છે ખરું?” બલામે કહ્યું, “ના, કદાપી નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","પછી યહોવાએ બલામની આંખો ખોલી, અને તેણે યહોવાના દૂતને રસ્તાની વચ્ચે ઉઘાડી તરવાર લઈને ઊભેલો જોયો અને તેને સાષ્ટાંગ પ્રણામ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","યહોવાના દૂતે તેને કહ્યું, “તેં આ ગધેડીને ત્રણ વખત શા માંટે માંરી! તને અટકાવવા માંટે હું જાતે રસ્તામાં આવીને ઊભો હતો. કારણ કે મને તું જાય એ ગમતું નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ગધેડીએ મને જોયો એટલે એ ત્રણ વાર બાજુએ ખસી ગઈ. જો એ ખસી ગઈ ના હોત તો મેં તને માંરી નાખ્યો હોત, અને ગધેડીનો બચાવ કર્યો હોત.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","પછી બલામે યહોવાના દૂતને કહ્યું, “મેં પાપ કર્યુ છે. માંરી ભૂલ થઈ ગઈ છે, મને ખબર નહોતી કે, તમે માંરા માંર્ગમાં આડા ઊભા છો, તમાંરી ઈચ્છા હું ત્યાં ન જાઉં તેવી હોય તો હું પાછો ઘેર જઈશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","યહોવાના દૂતે બલામને જણાવ્યું, “તું આ લોકો સાથે જા, પણ હું જેટલું કહું તેટલાં શબ્દો જ કહેજે.” આથી બલામ બાલાકના માંણસો સાથે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","રાજા બાલાકે જયારે સાંભળ્યું કે બલામ આવી રહ્યો છે, ત્યારે તે પાટનગર છોડીને તેને મળવા માંટે મોઆબની સરહદ પર આર્નોન પાસે આવેલા આર સુધી ગયો, ");
INSERT INTO guj2009_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","તેણે બલામને પૂછયું, “મે તમને બોલાવવા માંણસો ન્હોતા મોકલ્યા? તમે આટલો બધો વિલંબ શા માંટે કર્યો? તમને શું એમ લાગ્યું હતું કે હું તમને બદલો નહિ આપી શકું?” ");
INSERT INTO guj2009_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","એટલે બલામે બાલાકને કહ્યું, “હું અહીં આવ્યો છું તે તું જુએ છે, શું તું એમ માંને છે કે હું ધારું તે કરી શકું છું? હું તો દેવ મને જે બોલાવે છે તે જ બોલું છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","પછી બલામ બાલાક સાથે કિર્યાથ-હુસોથ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","બાલાકે તે જગ્યાએ બળદો અને ઘેટાનો યજ્ઞ ચઢાવ્યો તથા બલામ અને તેની સાથેના આગેવાનોને તેઓનાં બલિદાનો માંટે પ્રાણીઓ આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","બીજે દિવસે સવારે બાલાક બલામને બામોથ-બાલ ઉપર લઈ ગયો. ત્યાંથી તેઓ ઇસ્રાએલી પડાવનો એક ભાગ જોઈ શકતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","બલામે બાલાકને કહ્યું, “અહીં માંરે માંટે સાત વેદીઓ બાંધો અને સાદ બળદ તથા સાત નર ઘેટા મને લાવી આપો.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","બાલાકે બલામની સૂચનાઓ પ્રમાંણે કર્યુ, અને તેણે અને બલામે દરેક વેદી પર એક વળદ અને એક નર ઘેટાની આહુતિ ચઢાવી. ");
INSERT INTO guj2009_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","બલામે પછી રાજાને કહ્યું, “તું તારી વેદી પાસે ઊભો રહે. હું એકલો જાઉ છું. કદાચ યહોવા મને મળે પણ ખરા. એ મને જે કહેશે તે હું તને જણાવીશ.” અને પછી તે એક ખુલ્લી ટેકરી પર ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ત્યાં તેને દેવનો મેળાપ થયો. બલામે યહોવાને કહ્યું, “મેં સાત વેદીઓ તૈયાર કરી છે અને દરેક પર એક બળદ અને એક નર ઘેટાની આહુતિ ચઢાવી છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","પછી યહોવાએ બલામને શું કહેવું તે જણાવ્યું, અને કહ્યું, “તું પાછો બાલાક પાસે જા અને માંરા કહ્યાં પ્રમાંણે તેને કહેજે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","બાલાક જ્યારે બલામ પાસે પાછો ફર્યો ત્યારે તે હજી આહુતિ પાસે મોઆબના આગેવાનો સાથે જ ઊભો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","બલામે યહોવા તરફથી પોતાને મળેલો સંદેશો પ્રગટ કર્યો તેણે કહ્યું: “મોઆબનો રાજા બાલાક મને અરામમાંથી, પૂર્વના પર્વતોમાંથી લઈ આવ્યો છે, અને મને કહ્યું છે, ‘આવ, માંરે માંટે યાકૂબને શ્રાપ દે! આવ અને ઇસ્રાએલને શ્રાપ દે.’ ");
INSERT INTO guj2009_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","જેને દેવ શ્રાપ ન આપતો હોય તેને હું શી રીતે શ્રાપ આપું? દેવ જેનું ભૂડું ઈચ્છતો નથી તેનું ભૂંડું હું શી રીતે ઈચ્છું? ");
INSERT INTO guj2009_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","હું ઊચા ખડકની ટોચ પરથી તે લોકોને નિહાળું છું, એ પ્રજા એકલી રહે છે, તે અન્ય પ્રજાઓથી પોતાને ભિન્ન ગણે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ઇસ્રાએલની પ્રજા અસંખ્ય છે! ગણ્યા ગણાય નહિ તેટલા છે. માંરું મૃત્યુ સજ્જન જેવું થાઓ. ભલે માંરું જીવન ઇસ્રાએલીઓની જેમ પૂરું થાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","રાજા બાલાકે આ સાંભળીને બલામને કહ્યું, “આ તે શું કર્યું? મેં તમને માંરા દુશ્નનોને શ્રાપ આપવા તેડાવ્યો અને તમે તો તેમને આશીર્વાદ આપ્યા.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","પરંતુ બલામે પ્રત્યુત્તર આપ્યો, “માંરે તો યહોવા બોલાવે તે જ બોલવાનું હોય છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ત્યાર પછી બાલાકે તેમને કહ્યું, “માંરી સાથે બીજી જગ્યાએ આવો, ત્યાંથી તમે ઇસ્રાએલી પ્રજાને જોઈ શકો. તમે ફકત એક ભાગને જ જોઈ શકશો, કદાચ તે જગ્યાએથી તમે તેઓને માંરા માંટે શ્રાપિત કરી શકો.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","એમ કહીને રાજા બાલાક બલામને પિસ્ગાહ પર્વતની ટોચે આવેલા ચોકીના મેદાનમાં લઈ ગયો, ત્યાં તેણે સાત વેદીઓ બાંધી અને પ્રત્યેક વેદી ઉપર એક બળદ અને એક ઘેટાનું બલિદાન આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","બલામે રાજા બાલાકને કહ્યું, “હું યહોવાનો મેળાપ કરવા જાઉ છું. તું તારી વેદી પાસે ઊભો રહે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","યહોવા બલામને મળવા આવ્યા અને બલામે શું કહેવું તે યહોવાએ તેને જણાવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","આથી રાજા અને મોઆબના સર્વ સરદારો તેઓની આહુતિ પાસે ઊભા હતા ત્યાં બલામ બાલાક પાસે પાછો ગયો. રાજા બાલાકે આતુરતાથી પૂછયું: “યહોવાએ તને શું કહ્યું છે?” ");
INSERT INTO guj2009_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","એટલે બલામે જવાબ આપ્યો: “બાલાક ઊઠ, ઊભો થા અને ધ્યાનથી સાંભળ. હે સિપ્પોરના પુત્ર, હું જે કહું તે કાને ધર. ");
INSERT INTO guj2009_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","દેવ તે કાંઈ મનુષ્ય નથી કે જૂઠું બોલે, વળી તે કંઈ માંણસ નથી કે પોતાના વિચાર બદલે. તે તો જે બોલે તે પાળે, ને જે કહે તે પ્રમાંણે કરે. ");
INSERT INTO guj2009_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","હું તેઓને આશીર્વાદ આપું તેવી મને આજ્ઞા મળી છે. દેવ તેઓને આશીર્વાદ આપે તે હું ફેરવી શકું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","દેવે યાકૂબના લોકોમાં કઈ જ ખોટું ન જોયું. દેવે ઇસ્રાએલના લોકોમાં કોઈ પાપ જોયું ન હતું. તેઓના દેવ યહોવા તેમની સાથે છે; તેઓની વચ્ચે તેનો જયજયકાર રાજાની જેમ થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","એ જ તેમને મિસરમાંથી બહાર લઈ આવ્યા છે, અને તે જ એમને ઇસ્રાએલીઓને જંગલી આખલા જેવી તાકાત આપે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ઇસ્રાએલી પ્રજા વિરુદ્ધ કોઈ જંતરમંતર ચાલે તેમ નથી. કોઈ પણ કામણટૂમણ સફળ થાય તેમ નથી. ઇસ્રાએલ વિષે લોકો કહેશે; ‘જુઓ તો ખરા દેવે તેઓને માંટે કેવાં અદભૂત કાર્યો કર્યા છે!’ ");
INSERT INTO guj2009_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","એ પ્રજા તો સિંહની જેમ છલાંગ માંરવાને તાકી રહી છે; એ શિકારને ફાડી ખાધા વિના અને તેનું લોહી પીધા વિના જંપીને બેસનાર નથી.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","પછી બાલાકે બલામને કહ્યું, “ભલે, તું તેમને શ્રાપ ન આપે તો કંઈ નહિ, પણ ઓછામાં ઓછું તું એમને આશીર્વાદ ન આપતો.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","બલામે જવાબ આપ્યો, “મેં તમને કહ્યું નહીનું કે માંરે તો યહોવા મને જે કહે તે જ બોલવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","પછી રાજા બાલાકે બલામને કહ્યું, “ચાલ, હું તને બીજી કોઈ એક જગ્યાએ લી જાઉ, કદાચ દેવ પ્રસન્ન થાય અને ત્યાંથી તને માંરા તરફથી તેમને શ્રાપ આપવા દે.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","તેથી રાજા બાલાક, બલામને રણને કાંઠે આવેલા પેઓર પર્વતના શિખર પર લઈ ગયો, જયાંથી રણ જોઈ શકાતું હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","પછી બલામે બાલાકને કહ્યું, “તું મને સાત વેદી બાંધી આપ અને સાત બળદ અને સાત ઘેટાં બલિદાન માંટે લઈ આવ.” ");
INSERT INTO guj2009_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","બલામે જે કહ્યું તે જ પ્રમાંણે બાલાકે કર્યું અને પ્રત્યેક વેદી પર એક બળદ અને એક ઘેટાનું બલિદાન આપવામાં આવ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","બલામને ખબર પડી કે યહોવા ઇસ્રાએલને આશીર્વાદ આપવા ઈચ્છે છે, તેથી તેણે જાદૂઈ ખેલો કરીને તેને બદલવા પ્રયત્ન કર્યો નહિ. તેને બદલે તે રણ તરફ ઇસ્રાએલી છાવણી તરફ ફરીને ઊભો રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","તેણે જોયું તો ઇસ્રાએલીઓએ કુળસમૂહો પ્રમાંણે છાવણી નાંખી હતી. પછી દેવના આત્માંએ તેનામાં પ્રવેશ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","અને તેણે ભવિષ્યવાણી ઉચ્ચારતા કહ્યું, “બયોરનો પુત્ર બલામ કહે છે, જે સ્પષ્ટ નિહાળે છે તે દિવ્ય દૃષ્ટિ ધરાવનારની વાણી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","દેવના શબ્દો સાંભળનારની વાણી છે. સમાંધિમગ્ન છતાં ખુલ્લાં અંતઃચક્ષુથી સર્વસમર્થ દેવે બતાવેલાં દિવ્યદર્શનો જોનારની વાણી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“હે યાકૂબના લોકો, તમાંરા મંડપ કેવા સુંદર છે! હે ઇસ્રાએલીઓ તમાંરા ઘરો કેવા રઢિયાળ છે! ");
INSERT INTO guj2009_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","જાણે નદીકાંઠે વિસ્તરેલા બાગબગીચા, જાણે યહોવાએ રોપેલા કુવારના છોડ, ");
INSERT INTO guj2009_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","અને પાણી પાસેના એરેજ વૃક્ષના જેવા છે, તેઓને ભરપૂર પાણીથી આશીર્વાદિત કરવામાં આવશે. ઘણું જળસીંચન કરેલા ખેતરોમાં તે બી વાવશે. તેઓનો રાજા અગાગ રાજા કરતાં મહાન થશે; તેઓનું રાજ્ય પ્રતાપી રાજ્ય બનશે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“દેવ તેઓને મિસરમાંથી લઈ આવ્યા તે જ રાની બળદના શીંગડાની જેમ તેમનું રક્ષણ કરે છે. તેઓ સિંહ જેવા છે; પોતાની વિરુદ્ધ થનાર પ્રજાઓને તે ખાઈ જશે; તે તેઓનાં હાડકાં ભાંગીને ચૂરા કરશે, અને તે અસંખ્ય તીરોથી તેઓને વીંધી નાખશે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","પછી તે આડો પડીને ઊઘે છે, તેને ઉઠાડવાની હિંમત કોણ કરે? હે ઇસ્રાએલીઓ, તમને જે આશીર્વાદ આપે તેના પર આશીર્વાદ ઊતરો, તમને જે શ્રાપ આપે તેના પર શ્રાપ ઊતરો.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","આ સાંભળીને રાજા બાલાક બલામ પર ખૂબ ગુસ્સે થયો. ક્રોધાવેશમાં મુક્કી પછાડીને તેણે અણગમો વ્યક્ત કરતાં ઊંચા સાદે કહ્યું, “હું માંરા દુશ્મનોને શ્રાપ આપવા માંટે તને લઈ આવ્યો અને તેં ત્રણ ત્રણ વાર તેમને આશીર્વાદ આપ્યા! ");
INSERT INTO guj2009_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ચાલ, ભાગ, અહીંથી ચાલ્યો જા. ઘર ભેગો થઈ જા! મેં તને ભારે સન્માંન આપવાનું વચન આપ્યું હતું, પણ યહોવાએ તને તેનાથી વંચિત રાખ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","બલામે પ્રત્યુત્તર આપ્યો, “મેં તો તેં મોકલેલા માંણસોને કહ્યું હતું કે, ");
INSERT INTO guj2009_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘બાલાક મને તેના ઘરનું બધું સોનું અને ચાંદી આપે, તોયે હું યહોવાની આજ્ઞાની વિરુદ્ધ જઈને માંરી મરજી મુજબ સારું કે ખરાબ કઈ જ ન કરી શકું. હું તો યહોવા જે કહેવાનું મને કહેશે તે જ કહીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","હવે હું માંરા લોકો પાસે જાઉ છું પણ તે પહેલા તને સાવધાન કરતો જાઉ છું કે આ ઇસ્રાએલીઓ ભવિષ્યમાં તમાંરા મોઆબીઓના શા હાલ કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","એમ કહીને તેણે નીચે પ્રમાંણે ભવિષ્યવાણી પ્રગટ કરી: “બયોરના પુત્ર બલામની, દિવ્ય દ્રષ્ટિ ધરાવનારની આ વાણી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","દેવના શબ્દો સાંભળનારની, જેને પરાત્પર દેવ પાસે જ્ઞાન પ્રાપ્ત કર્યુ છે તેની આ વાણી છે. સમાંધિમગ્ન છતાં ખુલ્લાં અંતઃચક્ષુથી સર્વસમર્થ દેવે બતાવેલા દિવ્યદર્શનો જોનારની આ વાણી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“હું જે જોઉ છું તે દૃશ્ય આજનું નથી, પણ ભવિષ્યનું છે. યાકૂબના વંશમાંથી એક તારો ઊગશે, ઇસ્રાએલના લોકોમાંથી એક નવો શાસક આવશે, તે પોતાના રાજદંડથી મોઆબીઓનાં પ્રાણ હરશે. અને શેથના પુત્રોનો તે નાશ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ઇસ્રાએલ મજબૂત બનશે! તેને અદોમની ભૂમિ પ્રાપ્ત થશે. તેને તેના દુશ્મન સેઈરની ભૂમિ પ્રાપ્ત થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“યાકૂબના કુટુંબમાંથી એક નવો શાસક આવશે. તે શાસક શહેરમાં બાકી રહેલા લોકોનો વિનાશ કરશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","પછી બલામે અમાંલેકીઓને જોયા અને ભવિષ્યવાણી પ્રગટ કરી: “અમાંલેકીઓ સર્વ પ્રજાઓમાં આગળ હતા; પણ તેનો અંત સંપૂર્ણ વિનાશમાં આવશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","પછી કેનીઓને જોયા પછી બલામે ભવિષ્યવાણી કરી: “તમાંરું આશ્રયસ્થાન લાગે છે તો સુરક્ષિત, તે ખડકોમાં બાંધેલા માંળા સમાંન છે. ");
INSERT INTO guj2009_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","પણ એ બળી જવા નિમાંયો છે. કેનીઓનો વિનાશ થશે. તમે કયાં સુધી આશ્શૂરના કેદી બની રહેશો?” ");
INSERT INTO guj2009_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","અંતમાં તેણે ભવિષ્યવાણી પ્રગટ કરતાં કહ્યું: “દેવ આ પ્રમાંણે કરે ત્યારે કોણ જીવી શકે? ");
INSERT INTO guj2009_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","કિત્તીમમાંથી (સાયપ્રસ) કિનારા પરથી વહાણો આવશે. તેઓ આશ્શૂરને અને એબેરને કચડી નાખશે, પછી છેવટે વિજેતા પણ વિનાશ પામશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","પછી બલામ ઊઠીને પોતાને ઘેર ફર્યો અને બાલાક પણ પોતાના રસ્તે પડયો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","જયારે ઇસ્રાએલીઓએ શિટ્ટીમમાં મુકામ કર્યો હતો, ત્યારે એ લોકો મોઆબી સ્ત્રીઓ સાથે વ્યભિચાર કરવા લાગ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","આ સ્ત્રીઓ તે લોકોને પોતાના દેવોને બલિદાન અર્પણ કરવાના પ્રસંગોએ નિમંત્રણ પાઠવતી, એ લોકો યજ્ઞનો જમણ લેતા અને મોઆબીઓના દેવોની પૂજા કરતા. ");
INSERT INTO guj2009_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","આમ ઇસ્રાએલીઓ પેઓરના બઆલને પૂજતા થઈ ગયા; એટલે યહોવા તેમના પર કોપાયમાંન થયા. ");
INSERT INTO guj2009_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","યહોવાએ મૂસાને આજ્ઞા કરી કે, “તું ઇસ્રાએલી લોકોના બધા આગેવાનોને લઈને તેમનો ધોળે દિવસે માંરી સમક્ષ વધ કર, જેથી ઇસ્રાએલ પરથી માંરો ક્રોધ શમી જાય.” ");
INSERT INTO guj2009_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","તેથી મૂસાએ ઇસ્રાએલના ન્યાયાધીશોને હુકમ કર્યો, “તમાંરામાંની પ્રત્યેક વ્યક્તિ પોતપોતાના અધિકાર નીચેના માંણસોમાંથી જેણે જેણે પેઓરના બઆલની પૂજા કરી હોય તે સૌનો વધ કરે.” ");
INSERT INTO guj2009_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","પરંતુ મૂસા અને સમગ્ર ઇસ્રાએલી સંઘ મુલાકાત મંડપના પ્રવેશદ્વાર આગળ રૂદન કરતા હતા તે સમયે તેમના દેખતાં જ એક ઇસ્રાએલી એક મિદ્યાની સ્ત્રીને પોતાની છાવણીમાં ખેંચી લાવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","તેથી યાજક હારુનના પુત્ર એલઆઝારનો પુત્ર ફીનહાસ આ જોઈને સભામાંથી ઊભો થઈ ગયો અને પોતાના હાથમાં ભાલો લીધો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","તે પેલા ઇસ્રાએલી વ્યક્તિની પાછળ છાવણીમાં ઝડપથી દોડી ગયો અને ભાલાનો એક ઘા કરીને તે ઇસ્રાએલી વ્યક્તિના દેહને અને સ્ત્રીના પેટને વીંધી નાખ્યો, અને પરિણામે ઇસ્રાએલીઓમાં મરકીનો રોગચાળો ફાટી નીકળ્યો હતો તે બંધ થઈ ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","પરંતુ ત્યાં સુધીમાં તો 24,000 ઇસ્રાએલીઓ તે માંદગીથી મોતનો ભોગ બની ચૂક્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“હારુન યાજકના પુત્ર એલઆઝારના પુત્ર ફીનહાસે ઇસ્રાએલીઓ પરનો માંરો ક્રોધ શાંત કર્યો, એ લોકોમાં માંરા પ્રત્યેની નિષ્ઠાનો અભાવ જોઈ એણે એટલો બધો રોષ વ્યક્ત કર્યો, માંરો ક્રોધ શમી ગયો, જેથી મેં એમનો નાશ ન કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","તેથી તું તેને હવે કહે કે; હું એની સાથે હંમેશ માંટે શાંતિનો કરાર કરીને એને અને એના વંશજોને યાજકપદનો હક્ક આપું છું. જે હક્ક તેઓ સદાને માંટે ભોગવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","કારણ કે, તેણે પોતાના દેવ માંટેની શ્રદ્ધાનું ઉલ્લંઘન સહન ન્હોતું કર્યુ અને તેણે ઇસ્રાએલી પ્રજાના પાપોનું પ્રાયશ્ચિત કર્યુ હતું.” ");
INSERT INTO guj2009_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","પછી મિદ્યાની સ્ત્રીની સાથે માંરી નાખવામાં આવેલા ઇસ્રાએલી પુરુષનું નામ ઝિમ્રી હતું, તે શિમયોન કુળસમૂહના પરિવારના આગેવાન સાલૂનો પુત્ર હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","એ મિદ્યાની સ્ત્રીનું નામ કોઝબી હતું, તે મિદ્યાનીઓના એક કુટુંબના વડા સૂરની પુત્રી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","પછી યહોવાએ મૂસાને આજ્ઞા કરી, ");
INSERT INTO guj2009_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“જા, મિદ્યાનીઓ પર હુમલો કર અને તેઓનો સંહાર કર. ");
INSERT INTO guj2009_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","પેઓરમાં તેમણે મિદ્યાની સ્ત્રીઓ દ્વારા તને ખેલ કરાવી, તમને મિથ્યા દેવ બઆલની પૂજા કરતા કર્યા, મિદ્યાની આગેવાનની પુત્રી કોઝબી નામની સ્ત્રી દ્વારા તેઓએ તમને ફસાવ્યાં. પછી મૂર્તિપૂજાને કારણે ઇસ્રાએલીઓ એક રોગથી મૃત્યુ પામ્યા. તેથી તેઓ તમાંરા દુશ્મનો છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","રોગચાળો બંધ થઈ ગયા પછી યહોવાએ મૂસાને તથા યાજક હારુનના પુત્ર એલઆઝારને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ઇસ્રાએલમાં જેઓ વીસ વર્ષ કે તેનાથી મોટી વચના છે, તેઓની વસ્તી ગણતરી કર, તથા પ્રત્યેક કુળ અને ગોત્રમાંથી જે લોકો લશ્કરમાં નોકરી કરવા લાયક હોય તે સર્વની કુટુંબવાર ગણતરી કર.” ");
INSERT INTO guj2009_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","તેથી યર્દન નદીને કિનારે યરીખો સામે, મોઆબના મેદાનમાં મૂસાએ અને યાજક એલઆઝારે ઇસ્રાએલના આગેવાનોને જણાવ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“યહોવાએ મૂસાને આજ્ઞા આપી છે તે પ્રમાંણે વીસ વર્ષ અને તેનાથી વધારે ઉમરના પુરુષોની વસ્તી ગણતરી કરો.” મિસરમાંથી આવેલા જે ઇસ્રાએલીઓ છે તે નીચે મુજબ છે: ");
INSERT INTO guj2009_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ઇસ્રાએલના જયેષ્ઠ પુત્ર રૂબેનના વંશનાં કુટુંબો: હનોખનું કુટુંબ. પાલ્લૂનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","હેસ્રોનનું કુટુંબ. અને કાર્મીનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","રૂબેનના કુળસમૂહના આટલાં કુટુંબો હતાં, તેમની કુળ સંખ્યા 43,730ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","પાલ્લૂના વંશજો: અલીઆબ, ");
INSERT INTO guj2009_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","અને તેના પુત્રો: નમુએલ, દાથાન, અને અબીરામ. દાથાન અને અબીરામ એટલે મૂસાની અને હારુનની સામે બંડ પોકારનાર પંચાચતના સભ્યો, કોરાહે અને તેની ટોળકીએ યહોવા સામે બળવો કર્યો ત્યારે એમણે તેઓને સાથ આપ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","પરંતુ પૃથ્વીએ પોતાનું મુખ ખોલ્યું અને તેઓને ગળી ગઈ; તથા સમગ્ર પ્રજાને ચેતવણી મળે તે માંટે તે જ દિવસે યહોવાના અગ્નિએ 250 માંણસોને ભસ્મીભૂત કર્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","તેમ છતાં કોરાહના વંશજો મૃત્યુ પામ્યા નહોતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","શિમયોનના કુળસમૂહો: નમુએલનું કુટુંબ. યામીનનું કુટુંબ. યાખીનનું કુટુંબ, ");
INSERT INTO guj2009_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ઝેરાહનું કુટુંબ. શાઉલનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","શિમયોનના કુળસમૂહના આટલાં કુટુંબો હતાં જેમની કુલ સંખ્યા 22,200ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ગાદના કુળસમૂહમાં તેના પુત્રોનાં નામ ઉપરથી ગોત્રો હતા. સફોનથી સફોનીઓનું કુટુંબ. હાગ્ગીથી હાગ્ગીઓનું કુટુંબ. શૂનીથી શૂનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ઓઝનીથી ઓઝનીઓનું કુટુંબ. એરીથી એરીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","અરોદથી અરોદીઓનું કુટુંબ. આરએલીથી આરએલીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","આ ગાદના કુળસમૂહનાં આટલાં કુટુંબો હતા જેમની કુલ સંખ્યા 40,500ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","યહૂદાના કુળસમૂહનાં કુટુંબો: એર અને ઓનાન યહૂદાના પુત્રો હતા. પણ તેઓ કનાન દેશમાં મૃત્યુ પામ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","યહૂદાના વંશ માંત્રના પુત્રોના નામ ઉપરથી ગોત્રો હતા: શેલાથી શેલાનીઓનું કુટુંબ. પેરેસથી પેરેસીઓનું કુટુંબ. ઝેરાહથી ઝેરાહીઓનું કુટુંબ. પેરેસના કુટુંબોનો પણ આ વસ્તી ગણતરીમાં સમાંવેશ થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","પેરેસના પુત્રોનાં નામ ઉપરથી પણ કુટુંબોના નામ આવ્યા: હેસ્રોનથી હેસ્રોનીઓનું કુટુંબ. તેઓના પૂર્વજ હેસ્રોનના નામ ઉપરથી જ આ નામ હતું. હામૂલથી હામૂલીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","આ યહૂદાના કુળસમૂહનાં કુટુંબો છે; તેઓની કુળ સંખ્યા 76,500 હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ઈસ્સાખારના કુળસમૂહમાં તેના દીકરાઓનાં નામ ઉપરથી કુટુંબો હતા: તોલાથી તોલાઈઓનું કુટુંબ. પૂઆહથી પૂઆહથીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","યાશૂબથી યાશૂબીઓનું કુટુંબ. શિમ્રોનથી શિમ્રોનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","આ ઈસ્સાખારના કુળસમૂહોનાં કુટુંબો છે; તેઓની કુળસંખ્યા 64,300ની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ઝબુલોનના કુળસમૂહમાં તેના પુત્રોનાં નામ ઉપરથી કુટુંબો હતા: સેરેદથી સેરેદીઓનું કુટુંબ. એલોનથી એલોનીઓનું કુટુંબ. યાહલએલથી યાહલએલીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ઝબુલોનના કુળસમૂહના આટલાં કુટુંબો હતા. એમની કુલ સંખ્યા 60,500ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","યૂસફના કુળસમૂહમાં તેના પુત્ર મનાશ્શા અને એફ્રાઈમના પુત્રોના નામ ઉપરથી કુટુંબો હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","મનાશ્શાનાં વંશનાં કુટુંબો: માંખીરથી માંખીરીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","માંખીરના પુત્ર ગિલયાદમાંથી આટલાં કુટુંબો ઊતરી આવે છે: ઈએઝેરથી ઈએઝેરીઓનું કુટુંબ. હેલેકથી હેલેકીઓનું કુટુંબ, અને ");
INSERT INTO guj2009_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","આસ્રીએલથી આસ્રીએલીઓનું કુટુંબ. અને શખેમથી શખેમીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","શમીદાથી શમીદાઈઓનું કુટુંબ. હેફેરથી હેફેરીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","હેફેરના પુત્ર સલોફહાદને પુત્ર નહોતા, તેની પુત્રીઓનાં નામ આ પ્રમાંણે છે: માંહલાહ, નોઆહ, હોગ્લાહ, મિલ્કાહ અને તિર્સાહ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","મનાશ્શાના કુળસમૂહના આટલાં કુટુંબો હતા: તેમની કુલ સંખ્યા 52,700ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","એફ્રાઈમના કુળસમૂહના કુટુંબો તેના પુત્રોનાં નામ ઉપરથી હતા. શૂથેલાહથી શૂથેલાહીઓનું કુટુંબ. બેખેરથી બેખેરીઓનું કુટુંબ. તાહાનથી તાહાનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","શૂથેલાહના વંશજો. એરાનથી એરાનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","એફ્રાઈમના કુળસમૂહનાં આટલાં કુટુંબો હતાં. એમની સંખ્યા 32,500ની હતી. આ બધાં યૂસફના કુળસમૂહોનાં કુટુંબો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","બિન્યામીનના કુળસમૂહનાં તેમના પુત્રોનાં નામ ઉપરથી કુટુંબો હતાં: બેલાથી બેલાઈઓનું કુટુંબ. આશ્બેલથી આશ્બેલીઓનું કુટુંબ. અહીરામથી અહીરામીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","શફુફામથી શુફામીઓનું કુટુંબ. હુફામથી હૂફામીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","બેલાના વંશાનાં કુટુંબો: આર્દથી આર્દીઓનું કુટુંબ. નામાંનથી નામાંનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","આ બિન્યામીનના કુળસમૂહનાં આટલાં કુટુંબો હતા, જેમની કુલ સંખ્યા 45,600ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","દાનના કુળસમૂહમાં તેઓના પુત્રનાં નામ ઉપરથી કુટુંબ હતું: શૂહામથી શૂહામીઓનું કુટુંબ. આમ દાનના કુળસમૂહનું માંત્ર એક જ કુટુંબ હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","શૂહામના કુળસમૂહના સભ્યોની કુલ સંખ્યા 64,400ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","આશેરના કુળસમૂહમાં તેના પુત્રોનાં નામ ઉપરથી કુટુંબો હતા. યિમ્નાહથી યિમ્નીઓનું કુટુંબ. યિશ્વીથી યિશ્વીઓનું કુટુંબ. તેઓનાં પૂર્વજ યિશ્વીના નામ ઉપરથી હતું. બરીઆહ બહીઆહીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","બહીઆહના વંશનાં કુટુંબો. તેના પુત્રોનાં નામ ઉપરથી હતા. હેબેરથી હેબેરીઓનું કુટુંબ. માંલ્કીએલથી માંલ્કીએલીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","આશેરને એક પુત્રી હતી, જેનું નામ સેરાહ હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","આ આશેરના કુળસમૂહનાં આટલાં કુટુંબો હતા, જેમની કુલ સંખ્યા 53, 400ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","નફતાલીના કુળસમૂહમાં તેના પુત્રોનાં નામ ઉપરથી કુટુંબો હતા: યાહસએલથી યાહસએલીઓનું કુટુંબ. ગૂનીથી ગુનીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","યેસેરથી યેસેરીઓનું કુટુંબ. શિલ્લેમથી શિલ્લેમીઓનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","નફતાલીના કુળસમૂહના આટલાં કુટુંબો હતા. જેમની કુલ સંખ્યા 45,400ની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ઇસ્રાએલના કુલ વંશજો 6,01,730 હતા, જે યુદ્ધમાં જઈ શકે તેવા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","પછી યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“વસ્તી ગણતરીના આધારે કુળસમુહોને આ જમીન તેમની સંખ્યાના પ્રમાંણમાં વહેંચી આપવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","જેમની સંખ્યા મોટી છે તેમને વધુ જમીન આપવાની છે, જેમની સંખ્યા નાની છે તેમને ઓછી જમીન આપવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","પ્રત્યેક કુળસમૂહે નોંધાવેલી સંખ્યા પ્રમાંણે જમીન આપવાની છે. પરંતુ જમીનની વહેંચણી ચિઠ્ઠી નાખીને કરવાની છે. દરેકને તેમના કુળસમૂહના વ્યક્તિઓની સંખ્યાના પ્રમાંણમાં જમીન આપવાની છે. ");
INSERT INTO guj2009_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","પ્રત્યેક વંશને ચિઠ્ઠીના આધારે જમીન મળશે. તેથી જમીન દરેક કુટુંબને મળશે ભલે તે નાનું હોય કે મોટું.” ");
INSERT INTO guj2009_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","લેવીઓના નોંધયેલા કુળસમૂહો અને કુટુંબો નીચે મુજબ હતા: ગેર્શોનનું કુટુંબ. કહાથનું કુટુંબ. મરારીનું કુટુંબ, ");
INSERT INTO guj2009_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","લેવીઓનાં કુળસમુહોમાંથી બીજાં કુટુંબો નીચે મુજબ છે: લીબ્નીનું કુટુંબ. હેબ્રોનનું કુટુંબ. માંહલીનું કુટુંબ. મૂશીનું કુટુંબ. તથા કોરાહનું કુટુંબ. ");
INSERT INTO guj2009_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","કહાથનો પુત્ર આમ્રામ હતો. આમ્રાનની પત્નીનું નામ યોખેબેદ હતું. તે લેવીની પુત્રી હતી. અને મિસરમાં જન્મી હતી, તેનાથી આમ્રાનને હારુન, મૂસા અને તેમની બહેન મરિયમ જન્મ્યાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","હારુનના પુત્ર નાદાબ અબીહુ, એલઆઝાર અને ઈથામાંર હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","નાદાબ અને અબીહૂ નિષિદ્ધ અગ્નિ યહોવા સમક્ષ અર્પણ કરવાથી મૃત્યુ પામ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","લેવી કુળસમૂહની વસ્તી ગણતરીમાં એક મહિનો અને તેનાથી વધારે ઉમરના પુરુષોની કુળ સંખ્યા 23,000 થઈ. એમની નોંધણી બીજા ઇસ્રાએલીઓ ભેગી કરવામાં ન્યોતી અવી, કારણ કે એમને જમીન મળી ન્હોતી. ");
INSERT INTO guj2009_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","મૂસાએ અને યાજક એલઆઝારે યર્દન નદીને કાંઠે યરીખો સામે મોઆબના મેદાનમાં ઇસ્રાએલીઓની વસ્તી ગણતરી કરી ત્યારે આટલાં માંણસો નોંધાયાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","મૂસાએ અને યાજક હારુને સિનાઈના રણમાં વસ્તી ગણતરી કરી હતી, ત્યારે નોંધાયેલાઓમાંથી એક પણ માંણસ હયાત ન્હોતો. ");
INSERT INTO guj2009_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","કારણ, યહોવાએ તેમને કહ્યું હતું કે યફૂન્નેહનો પુત્ર કાલેબ, અને નૂનના પુત્ર યહોશુઆ સિવાય બધા જ લોકો રણમાં મરણ પામશે. અને ખરેખર બધાજ મરણ પામ્યા. સિવાય કાલેબ અને યહોશુઆ. ");
INSERT INTO guj2009_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","અને યૂસફના પુત્ર મનાશ્શાના કુટુંબોમાંથી મનાશ્શાના પુત્ર માંખીરના પુત્ર ગિલયાદના પુત્ર હેફેરના પુત્ર સલોફહાદની પુત્રીઓનાં નામ માંહલાહ, નોઆહ, હોગ્લાહ, મિલ્કાહ અને તિર્સાહ હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","તેમણે મૂસાની તથા એલઆઝારની અને સમગ્ર સમાંજના આગેવાનોની સમક્ષ મુલાકાત મંડપના પ્રવેશદ્વાર આગળ હાજર થઈને દાવો રજૂ કર્યો કે, ");
INSERT INTO guj2009_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“અમાંરા પિતા રણમાં મૃત્યુ પામ્યા હતા. યહોવા સામે બળવો કરનાર કોરાહની ટોળીમાં તે ન્હોતા. તે તેમના પોતાના પાપે જ મૃત્યુ પામ્યા હતા અને તેમને કોઈ પુત્ર ન્હોતો. ");
INSERT INTO guj2009_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","અમાંરા પિતા અપુત્ર હતા એટલા જ કારણસર તેમનું નામ કુટુંબમાંથી શા માંટે ભૂંસાઈ જાય? અમાંરા પિતાના ભાઈઓની સાથે અમે પણ વારસો આપવામાં આવે.” ");
INSERT INTO guj2009_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","એટલે મૂસાએ આ બાબત યહોવા સમક્ષ લાવી. ");
INSERT INTO guj2009_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","અને યહોવાએ તેને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“સલોફહાદની પુત્રીઓની વાત બરાબર છે. એ લોકોને પણ એમના પિતાના ભાઈઓની સાથે તું તેમને ભાગ આપ; તેમના પિતા જીવતાં હોત તો જે વારસો તેમને આપવામાં આવ્યો હોત તે તું તેઓને આપ. ");
INSERT INTO guj2009_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“તે ઉપરાંત તમાંરા સૌ માંટે આ સામાંન્ય કાનૂન છે: ‘તું ઇસ્રાએલીઓને આ પ્રમાંણે કહે; જો કોઈ વ્યક્તિ અપુત્ર મૃત્યુ પામે તો તેની મિલકત તેની પુત્રીને મળે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","જો તેને પુત્રી પણ ના હોય, તો તેની મિલકત તેના ભાઈઓને મળે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","જો તેને ભાઈઓ પણ ના હોય, તો તેની મિલકત તેના કાકાઓને મળે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","અને જો તેને કાકાઓ ન હોય, તો તેની મિલકત તેના સૌથી નજીકનાં સગાને મળે, અને તે તેનો માંલિક બને. મેં યહોવાએ મૂસાને આજ્ઞા કરી છે તે મુજબ આ કાયદો સૌ ઇસ્રાએલી પ્રજાએ પાળવાનો છે.’” ");
INSERT INTO guj2009_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","યહોવાએ મૂસાને કહ્યું, “તું આ અબારીમના પર્વત પર ચઢી જા અને ઇસ્રાએલી પ્રજાને મેં જે ભૂમિ આપી છે તે જોઈ લે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","તારો ભાઈ હારુન મૃત્યુ પામ્યો તેમ તું પણ તે ભૂમિને જોયા પછી મૃત્યુ પામશે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","કારણ કે સીનના રણમાં જયારે સમગ્ર સમાંજે ઝરણા આગળ માંરી સામે ઝઘડો કર્યો હતો, ત્યારે તમે માંરી આજ્ઞાનો ભંગ કર્યો હતો: તમે તેમની આગળ માંરી શક્તિ વિષે અવિશ્વાસ પ્રગટ કર્યો અને લોકોને બતાવ્યુ નહિ કે હું પવિત્ર છું.” સીનના રણમાં આવેલા કાદેશ નજીકના “મરીબાહ”ના ઝરણાની આ વાત છે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ત્યારબાદ મૂસાએ યહોવાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“હે યહોવા, સર્વ માંનવજાતના આત્માંઓના દેવ, આ તમને માંરી અરજ છે કે હવે આ સમાંજનો કોઈ આગેવાન પસંદ કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","જે એમની આગળ રહે અને બધી જ બાબતોમાં માંર્ગદર્શન આપે, જેથી તમાંરા લોકો ભરવાડ વગરનાં ઘેટાં જેવા ન રહે.” ");
INSERT INTO guj2009_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","યહોવાએ મૂસાને જવાબ આપ્યો, “નૂનનો પુત્ર યહોશુઆ શક્તિશાળી માંણસ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","તું તેને યાજક એલઆઝાર તથા સમગ્ર સમાંજ સમક્ષ ઊભો કર, પછી તેના માંથા પર હાથ મૂકી તેમના દેખતાં જ તેને તારો ઉત્તરાધિકારી નિયુક્ત કર. ");
INSERT INTO guj2009_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“અને પછી તારી કેટલીક સત્તા તેને સોંપ, જેથી ઇસ્રાએલીઓનો સમગ્ર સમાંજ તેની આજ્ઞામાં રહે. ");
INSERT INTO guj2009_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","તેણે માંરી ઈચ્છા જાણવા માંટે યાજક એલઆજાર પાસે જવું પડશે. પછી એલઆઝાર યહોવા સમક્ષ ઉરીમ પાસો નાખીને યહોવાને જવાબ મેળવશે. આ રીતે એલઆઝાર યહોશુઆને અને સમગ્ર ઇસ્રાએલી સમાંજને તેમની બધી બાબતમાં માંર્ગદર્શન આપશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","એટલે મૂસાએ યહોવાના કહ્યા પ્રમાંણે કર્યું. તેણે યહોશુઆને લઈ જઈને યાજક એલઆઝાર તથા સમગ્ર ઇસ્રાએલી સમાંજ સમક્ષ રજૂ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","અને સૌ લોકોની હાજરીમાં મૂસાએ તેને માંથે હાથ મૂકીને તેને યહોવાએ જણાવ્યા મુજબ ઉત્તરાધિકારી નિયુક્ત કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ઇસ્રાએલી પ્રજાને આ પ્રમાંણે આજ્ઞા કર: ");
INSERT INTO guj2009_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","તમાંરે નિયત સમયે મને આગમાં બનાવેલું ખાદ્યાર્પણ ધરવું, તેની સુગંધ મને પ્રસન્ન કરે છે. તેથી તમાંરે નીચે મુજબ અર્પણ ચઢાવવું. પ્રતિદિન તમાંરે એક વર્ષના ખોડખાંપણ વગરના બે નર હલવાનોનું દહનાર્પણ કરવું જ. ");
INSERT INTO guj2009_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","એક હલવાનની આહુતિ સવારે અને બીજાની સંધ્યાકાળે અને રાત્રિની વચ્ચે આહુતિ આપવી. ");
INSERT INTO guj2009_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ઝીણા દળેલા આઠ વાટકા મેંદાના લોટમાં એક કવાર્ટ જૈતૂન તેલ ભેળવીને તે પણ ખાદ્યાર્પણ તરીકે અર્પણ કરો.” ");
INSERT INTO guj2009_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","તેઓએ સિનાઈ પર્વત પર દૈનિક અર્પણો આપવાનું શરૂ કર્યું, આ અર્પણો આગથી બનાવેલા હતા, તેની સુગંધ યહોવાને પ્રસન્ન કરે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","પેયાર્પણ તરીકે પા ગેલન દ્રાક્ષારસ દરેક હલવાન સાથે અર્પણ કરવો. તમાંરે તેને દેવને પેયાર્પણ તરીકે પવિત્ર જગ્યામાંની વેદી પર રેડી દેવો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","બીજા હલવાનની આહુતિ પણ તમાંરે સંધ્યા અને રાત્રિ વચ્ચે આપવી, અને તેની સાથે સવારના જેવા જ ખાદ્યાર્પણ તથા પેયાર્પણ ધરાવવાં. આ હોમયજ્ઞની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“વિશ્રામવારને દિવસે તમાંરે ખોડખાંપણ વિનાના એક વર્ષની ઉમરના બે હલવાન, ખાદ્યાર્પણ તરીકે તેલે મોયેલા 16 વાટકા મેંદાનો લોટ અને નક્કી કરાયેલી માંત્રામાં દ્રાક્ષારસ ધરાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","પ્રત્યેક વિશ્રામવારે આ અર્પણ નિયમિત દહનાર્પણ અને પેયાર્પણ ઉપરાંત લાવવાનું છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“પ્રત્યેક મહિનાના પ્રથમ દિવસે તમાંરે યહોવાને દહનાર્પણમાં 2 વાછરડા, એક ઘેટો અને 1 વર્ષની ઉમર ના 7 નર હલવાનો ખોડખાંપણ વગરના ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","પ્રત્યેક બળદ સાથે તમાંરે 24 વાટકા ઝીણો દળેલો લોટ જૈતૂન તેલ સાથે ભેળવી અર્પણ કરવો. અને નર ઘેટા સાથે 16 વાટકા ઝીણો દળેલો લોટ જૈતૂન તેલ સાથે ભેળવી અર્પણ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","અને પ્રત્યેક હલવાન માંટે તેલે મોયેલા 8 વાટકા ઝીણા દળેલા લોટમાં જૈતૂન તેલ ભેળવી અગ્નિમાં બનાવી તારે અર્પણ કરવું તેની સુંગધથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","તમાંરે પેયાર્પણમાં વાછરડા દીઠ અડધો ગેલન દ્રાક્ષારસ, ઘેટા દીઠ સવા ગેલન દ્રાક્ષારસ અને હલવાન દીઠ પા ગેલન દ્રાક્ષારસ ચઢાવવો, વર્ષના પ્રત્યેક મહિનામાં બારે માંસ અર્પણ કરવાનું આ દહનાર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","પ્રત્યેક માંસના પ્રથમ દિવસે એક બકરો પાપાર્થાર્પણ તરીકે તમાંરે યહોવાને ચઢાવવો. અને દૈનિક દહનાર્પણ અને તે સાથેના પેયાર્પણ ઉપરાંતનુ આ અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“પહેલા મહિનાનો ચૌદમો દિવસ તે યહોવાનો પાસ્ખાનો દિવસ છે, દર વર્ષે પહેલા મહિનાની 14મી તારીખ તેની ઉજવણી કરવી. ");
INSERT INTO guj2009_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","આ માંસને પંદરમે દિવસે બેખમીર રોટલીનો પર્વ શરૂ થશે અને સાત દિવસ સુધી તે ચાલુ રહેશે જે દરમ્યાન તમાંરે બેખમીર રોટલી ખાવી. ");
INSERT INTO guj2009_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","પ્રથમ દિવસે યહોવાની સમક્ષ સર્વ લોકોની ધર્મસભા રાખવી. તે દિવસે રોજનું પરિશ્રમનું કામ કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","તમાંરે યહોવાને દહનાર્પણમાં 2 વાછરડા, 1 ઘેટો અને 1 વર્ષની ઉમરનાં ખોડખાંપણ વિનાનાં 7 હલવાનો ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","પ્રત્યેક વાછરડા દીઠ 24 વાટકા ઝીણા દળેલા લોટમાં જૈતૂન તેલ ભેળવી તથા નર ઘેટા સાથે 16 વાટકા ઝીણા દળેલા લોટમાં જૈતૂન તેલ ભેળવી અર્પણ કરવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","અને પ્રત્યેક હલવાન સાથે 8 વાટકા તેલથી મોયેલો લોટ. ");
INSERT INTO guj2009_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","અને તમાંરા પોતાના માંટે પ્રાયશ્ચિત કરવા પાપાર્થાર્પણ તરીકે તમાંરે એક બકરાનું અર્પણ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","દરરોજના દહનાર્પણો ઉપરાંત આ અર્પણો તમાંરે સાત દિવસ સુધી લાવવાનાં છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“ઉત્સવના સાતે દિવસ દરરોજ યહોવાને માંટે સુવાસિત હોમયજ્ઞનું અન્ન; જાથુના દહનાર્પણ સાથેના પેયાર્પણ ઉપરાંત ચઢાવવાનાં છે. ");
INSERT INTO guj2009_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“સાતમાં દિવસે ફરીથી પવિત્ર ધર્મસભા માંટે સર્વ લોકોએ ભેગા થવું અને તે દિવસે રોજનું પરિશ્રમનું કામ કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“કાપણીના પર્વના પ્રથમ દિવસે, નવા પાકની ઉજવણી કરવા યહોવા સમક્ષ સર્વ લોકોએ ધર્મસભામાં ભેગા થવું, તે દિવસે તમાંરે તમાંરા નવા પાકનું પ્રથમ ફળ યહોવાને ખાદ્યાર્પણ તરીકે અર્પણ કરવું. અને રોજનું કામ કરવું નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","તે દિવસે એક ખાસ દહનાર્પણ યહોવા સમક્ષ ચઢાવવું. તેની સુવાસથી યહોવા પ્રસન્ન થાય છે, તે માંટે તમાંરે 2 વાછરડા, 1 ઘેટો અને એક વર્ષના 7 નર હલવાનો લાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","એની સાથે બળદ દીઠ 24 વાટકા, ઘેટા દીઠ 16 વાટકા ");
INSERT INTO guj2009_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","અને હલવાન દીઠ 8 વાટકા તેલથી મોયેલો લોટ ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","તદુપરાંત તમાંરા પોતાના પ્રાયશ્ચિતને માંટે એક બકરો અર્પણ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","પ્રતિદિન નિયમિત ચઢાવવામાં આવતાં દહનાર્પણ, ખાદ્યાર્પણ અને પેયાર્પણ ઉપરાંત આ અર્પણો તમાંરે લાવવાનાં છે. બલિદાન માંટેનાં પ્રાણીઓ ખોડખાંપણ વિનાના હોય તેની કાળજી રાખવી. ");
INSERT INTO guj2009_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“પ્રતિવર્ષ સાતમાં મહિનાના પ્રથમ દિવસે તમાંરે ધર્મસંમેલન રાખવું. એ દિવસે રણશિંગડાં વગાડવાનો ઉત્સવ ઉજવવો. રોજનું કામ તે દિવસે કરવું નહિ. તે દિવસે તમાંરે સૌએ આનંદના પોકારો કરવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","તે દિવસે તમાંરે યહોવાને દહનાર્પણમાં એક વાછરડો, એક ઘેટો અને એક વર્ષની વયનાં ખોડખાંપણ વિનાના 7 હલવાન અર્પણ કરવાં. તેની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","તેની સાથે વાછરડા દીઠ 24 વાટકા, ");
INSERT INTO guj2009_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ઘેટા દીઠ 16 વાટકા લોટ અને હલવાન દીઠ 8 વાટકા લોટ તેલમાં મોયીને ખાદ્યાર્પણ માંટે લાવીને ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","આ ઉપરાંત તમાંરા પોતાના માંટે પ્રાયશ્ચિત કરવા પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","અમાંવાસ્યાના દહનાર્પણ તથા દૈનિક યજ્ઞો અને તે સાથેના ખાદ્યાર્પણ અને પેયાર્પણ ઉપરાંત આ વિશિષ્ટ અર્પણો છે. એ યહોવાની સુવાસિત આહુતિ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“આ સાતમાં મહિનાના દશમે દિવસે ધર્મ સંમેલન રાખવું, તે દિવસે તમાંરે ઉપવાસ કરવો અને રોજનું કોઈ કામ ન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","તે દિવસે તમાંરે યહોવા સમક્ષ દહનાર્પણમાં એક વાછરડો, એક ઘેટો અને એક વર્ષની વયના સાત નર હલવાનો ખોડખાંપણ વિનાના અર્પણ કરવાં. આની સુવાસથી યહોવા પ્રસન્ન થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","તમાંરે વાછરડા સાથે 24 વાટકા તેલમાં ભેળવેલો લોટ અર્પણ કરવો, ");
INSERT INTO guj2009_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","પ્રત્યેક ઘેટા દીઠ 16 વાટકા, અને હલવાન દીઠ 8 વાટકા, તેલથી મોયેલો લોટ ચઢાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","વળી પાપાર્થાર્પણ માંટે તમાંરે એક બકરાનું બલિદાન આપવું. પ્રાયશ્ચિતના દિવસનું પાપાર્થાર્પણ વર્ષમાં એક વખત તે પ્રાયશ્ચિતના દિવસે અર્પણ કરવામાં આવતું અને પ્રતિદિન થતાં દહનાર્પણો, ખાદ્યાર્પણો અને પેયાર્પણો ઉપરાંતનું આ અર્પણ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“પછી સાતમાં મહિનાના પંદરમે દિવસે તમાંરે ધર્મસંમેલન રાખવું. રોજનું કામ કરવું નહિ, અને સાત દિવસ સુધી તમાંરે યહોવાનો ઉત્સવ ઊજવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","તે દિવસે યહોવા જેનાથી પ્રસન્ન થાય છે તે અર્પણ કરવું. તમાંરા આ વિશિષ્ટ દહનાર્પણમાં 13 વાછરડા. 2 ઘેટા અને એક વર્ષની ઉમરનાં ખોડખાંપણ વિનાનાં 14 નર હલવાન ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","એની સાથે ખાદ્યાર્પણમાં વાછરડા દીઠ 24 વાટકા, ");
INSERT INTO guj2009_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ઘેટા દીઠ 16 વાટકા અને હલવાન દીઠ 8 વાટકા તેલથી મોયેલો લોટ ધરાવવો. ");
INSERT INTO guj2009_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","તદુપરાંત પ્રાયશ્ચિત્તાર્પણ તરીકે એક બકરો ચઢાવવો. પ્રતિદિન નિયમિત થતા યજ્ઞો, ખાદ્યાર્પણો અને પેયાર્પણ ઉપરાંત આ અર્પણ કરવાનું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“બીજે દિવસે 12 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 14 નર હલવાનો ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","તેની સાથે નિયમ પ્રમાંણે ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","તદુપરાંત નિયમિત પ્રતિદિન થતા યજ્ઞ ઉપરાંત પાપાર્થાર્પણ માંટે એક બકરાનું બલિદાન અને તે સાથેનાં ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ત્રીજે દિવસે 11 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વિનાના 14 હલવાનો, ");
INSERT INTO guj2009_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","તથા તેની સાથે પ્રાણીઓની સંખ્યા અનુસાર નકકી કરેલા ધોરણ મુજબ ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ઉપરાંત, પ્રાયશ્ચિત્તાર્પણ તરીકે એક બકરો ચઢાવવો. આ પ્રતિદિન થતાં દહનાર્પણો, ખાદ્યાર્પણો અને પેયાર્પણ ઉપરાંત ચઢાવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ચોથે દિવસે 10 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 14 હલવાનો, ");
INSERT INTO guj2009_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","તથા તેની સાથે પ્રાણીઓની સંખ્યા મુજબ ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","તદુપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. આ પ્રતિદિન અપાતાં દહનાર્પણ, ખાદ્યાર્પણ તથા પેયાર્પણ ઉપરાંત ચઢાવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“પાંચમે દિવસે 9 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 14 હલવાન. ");
INSERT INTO guj2009_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","તથા તેની સાથે પ્રાણીઓની સંખ્યા મુજબ યોગ્ય પૂરતા ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","પ્રતિદિન થતાં યજ્ઞ અને તે સાથે નિયમ પ્રમાંણે ખાદ્યાર્પણ અને પેયાર્પણ ઉપરાંત પાપાર્થાર્પણ માંટે એક બકરાનું બલિદાન આપવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“છઠ્ઠે દિવસે 8 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 14 હલવાન ");
INSERT INTO guj2009_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","તથા તેની સાથે પ્રાણીઓની સંખ્યા અનુસાર જરૂરી પૂરતાં ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","આ બધું પ્રતિદિન નિયમિત થતાં યજ્ઞ અને તે સાથે નિયમ પ્રમાંણે ખાદ્યાર્પણ તથા પેયાર્પણ ઉપરાંત પાપાર્થાર્પણને માંટે એક બકરાનું બલિદાન અર્પણ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“સાતમે દિવસે 7 વાછરડા, 2 ઘેટા અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 14 હલવાન. ");
INSERT INTO guj2009_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","તથા તેની સાથે પ્રાણીઓની સંખ્યા અનુસાર નિયમ મુજબ ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ઉપરાંત પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. આ અર્પણ પ્રતિદિન થતાં ખાદ્યાર્પણ અને પેયાર્પણ ઉપરાંતના હશે. ");
INSERT INTO guj2009_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“આઠમાં દિવસે તમાંરા માંટે ખૂબજ વિશિષ્ટ સભાનો દિવસ હશે, ");
INSERT INTO guj2009_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","તે દિવસે તમાંરે રોજના કામ ન કરવા. તમાંરે યહોવાને દહનાર્પણો અર્પવા. તેની સુવાસ યહોવાને પ્રસન્ન કરે છે. આ તમાંરા ખાસ દહનાર્પણમાં એક બળદ, એક ઘેટો અને એક વર્ષની ઉમરના ખોડખાંપણ વગરના 7 હલવાન હોવા જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","તથા તેની સાતે સંખ્યા અનુસાર નિયમ મુજબ ખાદ્યાર્પણ તથા પેયાર્પણ ચઢાવવા. ");
INSERT INTO guj2009_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ઉપરાંત તમાંરે પાપાર્થાર્પણ તરીકે એક બકરો ચઢાવવો. આ અર્પણ પ્રતિદિન દહનાર્પણ અને ખાદ્યાર્પણ તથા પેયાર્પણ ઉપરાંત ચઢાવવું. ");
INSERT INTO guj2009_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“તમાંરા ઠરાવેલા વાર્ષિક ઉસ્તવો દરમ્યાન આ અર્પણો ફરજિયાત છે. આ અર્પણો તમાંરી બાધાના પૂર્ણ કરવાના અર્પણો, અથવા ખાસ ભેટના અર્પણો અથવા દહનાર્પણો, ખાદ્યાર્પણો, પેયાર્પણો તથા શાંત્યર્પણોની ઉપરાંત અર્પણ કરવાના છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","મૂસાએ આ સર્વ સૂચનાઓ યહોવાની આજ્ઞા પ્રમાંણે ઇસ્રાએલી પ્રજાને કહી સંભળાવી. ");
INSERT INTO guj2009_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","મૂસાએ ઇસ્રાએલીઓના કુળસમૂહોના વડાઓને કહ્યું, યહોવાની આજ્ઞા આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“જો કોઈ વ્યક્તિ કોઈ બાબત માંટે અથવા કોઈ વસ્તુનો ત્યાગ કરવા માંટે દેવ સમક્ષ વચન આપે તો તેણે તેનો ભંગ કરવો નહિ. વચનનું પાલન અચૂક કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“જો કોઈ કુંવારી સ્ત્રી પોતાના પિતાને ઘેર હોય ત્યારે યહોવાને કશું ચઢાવવાનું વચન આપે અગર અન્ય કોઈ વસ્તુનો ત્યાગ કરવાનું વ્રત લે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","અને તેના પિતાને તે વચન વિષે જાણ થાય છતાં તે કશો વાંધો ઉઠાવે નહિ, તો તે વચન તે સ્ત્રીને બંધનકર્તા બને છે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","પરંતુ જો તેના પિતાને જે દિવસે જાણ થાય તે જ દિવસે તેણીને વચન પુરુ કરવાની મનાઈ કરે તો તે તેને પુરુ કરવા બંધનકર્તા ન રહે, તેના પિતાએ તેને રોકી હોવાથી યહોવા તેને વચન તોડવા માંટે દોષિત ગણે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“પરંતુ જો કોઈ સ્ત્રી કઈ કરવાની પ્રતિજ્ઞા લે, અને પછી લગ્ન કરે, ");
INSERT INTO guj2009_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","અને તેના પતિને તેના વચન વિષેની ખબર પડે અને જે દિવસે ખબર પડે તે દિવસે તે વિષે કશું ન કરે તો તેનું વચન બંધનકર્તા બને છે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","જો તેનો પતિ તેની પ્રતિજ્ઞા અથવા વચન પુરું કરવા ન દે તો તે પ્રતિજ્ઞા અથવા વચન મુક્ત થઈ જાય છે. તેથી યહોવા તેને માંફ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“જો કોઈ વિધવા કે છૂટાછેડા આપેલી સ્ત્રીનું વચન હોય તો તે તેને બંધનકર્તા ગણાય, તે અચૂક પૂર્ણ કરવાં. ");
INSERT INTO guj2009_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“જો કોઈ પરણેલી સ્ત્રીએ સાસરે આવ્યા પછી યહોવાને કોઈ વચન આપ્યું હોય, ");
INSERT INTO guj2009_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","અને તેની જાણ થવા છતાં તેનો પતિ તેને કાંઈ જ કહે નહિ કે ના પાડે નહિ, તો તેનું વચન તેને બંધનકર્તા ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","પણ જો પતિને જાણ થતાં તેને રદ કરે તો તેણે જે વચન આપ્યું હોય તે બંધનકર્તા રહે નહિ. તેના પતિએ તેને રદ કર્યા હોવાથી યહોવા તેને માંફ કરી દેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","પત્નીના કોઈ પણ વચનને પતિ મંજૂર કે રદ કરી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","પરંતુ જો જાણ થયા પછી બીજા દિવસ સુધીમાં પતિએ તેને કંઈજ કહ્યું ના હોય તો એનો અર્થ એ કે તે એના વચન સાથે સંમત છે, અને પતિએ જાણ થઈ તે જ દિવસે તેણે કશું જ કહ્યું નહિ, એટલે એ મંજૂર રાખ્યું ગણાય. ");
INSERT INTO guj2009_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","પણ જો જાણ્યા પછી થોડા સમય બાદ પતિ ના કરે તો તેણીના વચનોનાં ભંગનો જવાબદાર તેનો પતિ છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","પતિ અને પત્નીને વિષે તેમજ પિતા અને તેના ઘરમાં રહેતી કુંવારી કન્યા વિષે યહોવાએ મૂસાને આ પ્રમાંણે નિયમો જણાવ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“મૂર્તિપૂજામાં ઇસ્રાએલને લઈ જનાર મિદ્યાનીઓ ઉપર તું પૂરેપૂરું વેર વસૂલ કરજે. તે પછી તું પિતૃઓ ભેગો પોઢી જશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","પછી મૂસાએ લોકોને કહ્યું, “તમાંરામાંથી કેટલાકે શસ્ત્રસજજ થઈને મિદ્યાનીઓ ઉપર હુમલો કરો, અને યહોવા તમાંરા દ્વારા મિદ્યાનીઓ ઉપર બદલો લેશે. ");
INSERT INTO guj2009_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","તમાંરે ઇસ્રાએલના પ્રત્યેક કુળસમૂહમાંથી 1,000 માંણસોને યુદ્ધમાં મોકલવા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","આથી પ્રત્યેક કુળસમૂહમાંથી હજાર માંણસો મુજબ મૂસાએ 12,000 માંણસો ભેગા કરીને તેમને શસ્ત્રસજજ કરીને યુદ્ધમાં મોકલ્યા.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","અને યાજક એલઆઝારનો પુત્ર ફીનહાસ પવિત્ર સામગ્રી અને યુદ્ધનાદ કરવાનાં રણશિંગડાં લઈને સાથે ગયો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","યુદ્ધમાં મિદ્યાનના સર્વ પુરુષોનો સંહાર કરવામાં આવ્યો. કારણ કે મૂસાએ યહોવાની આજ્ઞા મુજબ મિદ્યાનીઓ પર હુમલો કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","યુદ્ધમાં માંર્યા ગયેલા માંણસોમાં મિદ્યાની રાજાઓ અવી, રેકેમ, સૂર, હૂર અને રેબા હતા. ઉપરાંત બયોરના પુત્ર બલામને પણ માંરી નાખ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ઇસ્રાએલીઓએ મિદ્યાનીઓની સર્વ સ્ત્રીઓને અને બાળકોને કેદ પકડયાં, તેમના બધાં ઢોર, ઘેટાં બકરાં અને સરસામાંન લૂંટી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","તેમણે તેમના બધાં શહેરોને અને છાવણીઓને લૂટયાં. ");
INSERT INTO guj2009_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ત્યાર પછી તેઓ બધી લૂટ અને કબજે કરેલાં પશુઓ અને માંણસોને ");
INSERT INTO guj2009_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","મોઆબના મેદાનમાં યરીખોની સામે યર્દન નદીને કાંઠે આવેલી છાવણીમાં મૂસા, યાજક એલઆઝાર અને સમગ્ર ઇસ્રાએલી સમાંજ સમક્ષ લાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","મૂસા, એલઆઝાર યાજક અને લોકોના આગેવાનો વિજયી સૈન્યને મળવા માંટે બહાર આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","મૂસા યુદ્ધમાંથી પાછા ફરતા લશ્કરના સેનાપતિઓ, અને લશ્કરના નાનામોટા અધિકારીઓ ઉપર ક્રોધે ભરાયો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","તેણે તેઓને પૂછયું, “તમે આ બધી સ્ત્રીઓને શા માંટે જીવતી રહેવા દીધી? ");
INSERT INTO guj2009_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","આ એ જ સ્ત્રીઓ છે જેઓએ બલામની શિખામણ મુજબ પેઓરના પર્વત પર ઇસ્રાએલીઓને યહોવાનો ત્યાગ કરવા તથા મૂર્તિપૂજામાં લલચાવી ગઈ હતી, અને તેને કારણે જ ઇસ્રાએલી સમાંજમાં મરકીનો રોગચાળો ફાટી નીકળ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","આથી બધાં પુરુષ સંતાનોને માંરી નાખો, અને જેમણે શારીરિક સંબંધ કર્યો હોય એવી બધી સ્ત્રીઓને પણ માંરી નાખો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","પરંતુ જે સ્ત્રીઓએ શારીરિક સંબંધ ન કર્યો હોય તેઓને તમાંરે માંટે જીવતી રાખો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","અને જેઓએ કોઈનો સંહાર કર્યો છે અથવા મૃતદેહનો સ્પર્શ કર્યો છે તેઓ બધાએ સાત દિવસ સુધી છાવણીની બહાર રહેવું. તમાંરે અને તમાંરા કેદીઓએ ત્રીજે અને સાતમે દિવસે દેહશુદ્ધિ કરવી, ");
INSERT INTO guj2009_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","વળી તમાંરાં બધા કપડાં તથા જે કાંઈ ચામડાનું કે બકરાના વાળનું કે લાકડાનું બનાવેલુ હોય તે બધું ય શુદ્ધ કરવાનું યાદ રાખો.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","પછી યાજક એલઆઝારે યુદ્ધમાંથી પાછા ફરેલા યોદ્ધાઓને કહ્યું, “યહોવાએ મૂસા માંરફતે જણાવેલા આ શાસ્ત્રનો નિયમ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","જે કાંઈ અગ્નિમાં મૂકી શકાય જેમકે સોનું, ચાંદી, કાંસા, લોખંડ, કલાઈ અને સીસાને ");
INSERT INTO guj2009_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","શુદ્ધ કરવા માંટે અગ્નિમાંથી પસાર કરવું પડશે; પછી શુદ્ધિના પાણી વડે તેને શુદ્ધ કરવામાં આવશે, જો કાંઈ અગ્નિમાં મૂકી ન શકાય તે બધાને પાણીથી શુદ્ધ કરવું. ");
INSERT INTO guj2009_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","સાતમે દિવસે તમાંરે કપડાં ધોઈ નાખવાં, ત્યાર પછી તમે શુદ્ધ થશો, અને પાછા છાવણીમાં દાખલ થઈ શકશો.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","અને યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“તું તથા એલઆઝાર યાજક અને કુળના વડાલો સાથે મળીને કબજે કરાયેલાં માંણસો અને પશુઓ સહિત બધાની ગણતરી કર, ");
INSERT INTO guj2009_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","અને એ યુદ્ધમાં ગલેયા યોદ્ધાઓ અને બાકીના સમાંજ વચ્ચે સરખે ભાગે વહેંચી આપ. ");
INSERT INTO guj2009_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","યુદ્ધમાં ગયેલા યોદ્ધાઓના ભાગમાંથી તારે દર 500 કેદીઓ, બળદો, ગધેડાં કે ઘેટાં દીઠ એક યહોવાને માંટે કાઢી લેવું. ");
INSERT INTO guj2009_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","પેલી વસ્તુઓ સૈનિકોએ યુદ્ધમાં લીધેલી વસ્તુઓના અડધા ભાગમાંથી લેવી અને તેને યાજક એલઆઝારને આપવી તે ભાગ યહોવાનો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","લોકોના અડધા ભાગમાંથી, દર 50 માંણસ દીઠ, બળદો, ગધેડાં, ઘેટાં અને બીજાં બધાં પશુઓમાંથી એક લઈને યહોવાના પવિત્રમંડપની સંભાળ લેતા લેવીઓને તે આપ. તે દેવનો ભાગ છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","તેથી યહોવાએ આજ્ઞા કરી હતી તે પ્રમાંણે મૂસાએ અને યાજક એલઆઝારે કર્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","યોદ્ધાઓએ જે લૂંટ એકત્ર કરી હતી તેની યાદી: 6,75,000 ઘેટાં, ");
INSERT INTO guj2009_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","બોંતેર હજારઢોર, ");
INSERT INTO guj2009_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","એકસઠ હજાર ગધેડા, ");
INSERT INTO guj2009_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","બત્રીસ હજાર કુંવારી કન્યાઓ. ");
INSERT INTO guj2009_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","યુદ્ધમાં ગયેલા સૈનિકોને લૂંટમાંથી જે અડધો ભાગ તેની વિગતો: 3,37,500 ઘેટા; ");
INSERT INTO guj2009_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","તેમાંથી 675 કર તરીકે યહોવાને આપવામાં આવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","છત્રીસ હજાર ઢોર, તેમાંથી 72 કર તરીકે યહોવાને આપવામાં આવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ત્રીસ હજારને પાંચસૌ ઘેડાં; તેમાંથી 61 કર તરીકે યહોવાને આપવામાં આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","સોળ હજાર માંણસો, તેમાંથી 32 કર તરીકે યહોવાને આપવામાં આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","યહોવાએ મૂસાને કહ્યું હતું તે પ્રમાંણે યહોવાને સર્વ ભાગ યાજક એલઆઝારને આપવામાં આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","લૂંટનો અડધો ભાગ ઇસ્રાએલી લોકો માંટે હતો, મૂસાએ યુદ્ધમાં ગયેલા યોદ્ધાઓના ભાગથી તેને જુદો રાખ્યો હતો, તેની વિગતો; ");
INSERT INTO guj2009_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","અડધા ભાગમાં 3,37,500 ઘેટાં ");
INSERT INTO guj2009_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","છત્રીસ હજાર ગાયો. ");
INSERT INTO guj2009_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ત્રીસ હજારને પાંચસૌ ગધેડાં, ");
INSERT INTO guj2009_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ને સોળ હજાર પુરુષોઓ હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","યહોવાની આજ્ઞા અનુસાર મૂસાએ લોકોને મળેલા અડધા ભાગમાંથી દર 50 માંણસોમાંથી એક માંણસ અને દર 50 પશુઓમાંથી એક પશુ લઈને યહોવાના પવિત્ર મંડપની સંભાળ રાખનાર લેવીઓને તે આપ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","પછી સેનાપતિઓ અને લશ્કરના નાનામોટા અધિકારીઓએ આવીને ");
INSERT INTO guj2009_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","મૂસાને જણાવ્યું, “અમે આપના સેવકોએ તેમના હાથ નીચેને માંણસોની ગણતરી કરી છે અને એક પણ માંણસ ઓછો થયો નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","આથી લૂંટના અમાંરા ભાગમાંથી ખાસ સ્તુત્યાર્પણો યહોવાને અર્પણ કરવા લાવ્યા છીએ: સોનાનાં ધરેણાં, સાંકળા, કડાં, વીટીઓ, કુડળો અને હારો-અમાંરા પ્રાણ બચાવવા બદલ યહોવાને ધરાવવા આવ્યા છીએ. યહોવા સમક્ષ અમાંરા આત્માંઓના પ્રાયશ્ચિતને માંટે આ સર્વ અર્પણો છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","મૂસાએ અને યાજક એલઆઝારે તેમની પાસેથી દાગીનાઓ સ્વીકારી લીધા. તે વધા શોભાયમાંન અલંકારના રૂપમાં હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","તેમણે યહોવાને ધરાવેલી આ સોનાની ભેટનું કુલ વજન બસો કિલો હતું. તેની કિંમત 420 પાઉંડ હતી. એ 1,000 માંણસોના અને 100 માંણસોના આગેવાનોએ આપેલ હતું. ");
INSERT INTO guj2009_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","અધિકારી નહોતા તેવા યોદ્ધાઓએ પોતપોતાની લૂંટ પોતાની પાસે રાખી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","મૂસા અને યાજક એલઆઝાર “હજાર-હજાર” ના અને સોસોના સેનાનાયકો પાસેથી સોનું સ્વીકારીને મુલાકાત મંડપમાં લઈ આવ્યા, ઇસ્રાએલ પ્રજાના સ્મરણાર્થે યહોવા સમક્ષ તે રાખવામાં આવ્યું, જેથી યહોવા ઇસ્રાએલનું રક્ષણ કરે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ઇસ્રાએલી પ્રજા યાઝેર અને ગિલયાદના પ્રદેશમાં આવી, રૂબેન અને ગાદના કુળસમૂહો પાસે ઘેટાનાં મોટાં મોટાં ઘણ હતા. તેમણે જોયું કે આ પ્રદેશ ઢોરઢાંખરના ઉછેર માંટે ઉત્તમ અને અનુકુળ છે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","તેથી તેઓએ મૂસા; યાજક એલઆઝાર અને સમાંજના આગેવાનો સમક્ષ આવીને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“ઇસ્રાએલી સમાંજને યહોવાએ જીતી આપેલો પ્રદેશ, અટારોથ, દીબોન, યાઝેર, નિમ્રાહ, હેશ્બોન, એલઆલેહ, સબામ, નબો અને બેઓન. ");
INSERT INTO guj2009_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","આ સમગ્ર પ્રદેશ ઢોરઢાંખરના ઉછેર માંટે ખૂબ અનુકૂળ છે, અને આપના સેવકો પાસે પુષ્કળ ઢોરો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","અમાંરા પર કૃપા હોય તો યર્દન નદી ઓળંગીને તે તરફના વિસ્તારને બદલે આ પ્રદેશ અમાંરા ભાગમાં આપો.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","મૂસાએ ગાદ અને રૂબેનના કુળસમૂહોને કહ્યું, “તમાંરા બીજા ઇસ્રાએલી ભાઈઓ તો યુદ્ધમાં જાય છે ત્યારેશું તમે અહી રહેવા માંગો છો? ");
INSERT INTO guj2009_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ઇસ્રાએલીઓ યર્દન નદી ઓળંગીને યહોવાએ તેમને આપેલી ભૂમિમાં દાખલ થવા જાય છે, ત્યારે તમે શા માંટે તેમને નિરૂત્સાહી કરો છો? ");
INSERT INTO guj2009_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","9","જ્યારે મેં તમાંરા પિતૃઓને કાદેશ બાર્નેઆથી દેશની જાસૂસી કરવા મોકલ્યા હતા, ત્યારે તેઓએ આવુ જ વર્તન કર્યુ હતું, તે લોકો એશ્કોલ ખીણ સુધી ગયા. પ્રદેશ જોયો અને જે પ્રદેશ યહોવાએ ઇસ્રાએલીઓને આપ્યો હતો ત્યાં જવાનો તેમનો ઉત્સાહ તોડી પાડયો. ");
INSERT INTO guj2009_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","આથી તે દિવસે યહોવાનો ક્રોધ ભભૂકી ઊઠયો હતો અને તેણે વચન આપ્યું કે, ");
INSERT INTO guj2009_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘તે લોકો મને વિશ્વાસુ રહ્યા નથી તેથી મિસરમાંથી આવેલા એમાંના 20 વર્ષ અને તેથી વધારે ઉમરના ઇસ્રાએલીઓ ઈબ્રાહિમ, ઈસહાક અને યાકૂબને જે ભૂમિ આપવાનું વચન આપ્યુ હતું તેમાં તે પ્રવેશ કરશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","અપવાદરૂપે ફકત માંરામાં સંપૂર્ણ વિશ્વાસ રાખનાર કનિઝઝી યફૂન્નેહનો પુત્ર કાલેબ અને નૂનનો પુત્ર યહોશુઆ જેઓએ વચનના દેશમાં જવા માંટે લોકોને અનુરોધ કર્યો હતો.’ ");
INSERT INTO guj2009_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“ઇસ્રાએલીઓ ઉપર યહોવાનો કોપ ભભૂકી ઊઠયો, અને તેણે તેમને 40 વર્ષ સુધી રણમાં રઝળાવ્યા, અને આખેર યહોવાને દુઃખ આપનારી આખી પેઢી સમાંપ્ત થઈ ગઈ ");
INSERT INTO guj2009_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","અને હવે તમે, પાપી લોકો, પણ તમાંરા પિતાઓએ કર્યુ તેમ કરો છો. શું તમાંરે યહોવાને તેના લોકો વિરુદ્ધ હજુ વધારે ગુસ્સે કરવા છે? ");
INSERT INTO guj2009_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","કારણ, જો તમે અત્યારે આ પ્રમાંણે દેવથી વિમુખ થશો તો તે આ બધા લોકોને રણમાં રઝળતાં છોડી દેશે અને તમે તેમના વિનાશનું નિમિત્ત બનશો.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","તેથી તેમણે મૂસાની પાસે જઈને કહ્યું, “અમે અહીં અમાંરાં ઘેટાંબકરાં માંટે વાડા બાંધીશું અને અમાંરાં સ્ત્રી બાળકો માંટે કિલ્લેબંધી નગરો બાંધીશું; ");
INSERT INTO guj2009_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ત્યાર બાદ અમે જાતે શસ્ત્રસજજ થઈને ઇસ્રાએલી પ્રજાની આગળ રહી તેમને તેમની ભૂમિમાં પહોંચાડતા સુધી લડીશું, એ સમય દરમ્યાન અમાંરાં સ્ત્રી બાળકો એ ગામોમાં દેશના મૂળ વતનીઓના હુમલાથી સુરક્ષિત રહી શકશે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","અને બધા ઇસ્રાએલીઓને તેઓનો વારસો-પોતાના ભાગની જમીનનો પાછો નહિ મળે ત્યાં સુધી અમે પાછા નહિ ફરીએ. ");
INSERT INTO guj2009_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","વળી અમે યર્દન નદીને પેલે પારના પ્રદેશમાં તેમની સાથે જમીનમાં ભાગ માંગીશું નહિ, કારણ કે, તેના બદલે અમને યર્દન નદીને પૂર્વકાંઠે અમાંરા ભાગની જમીન મળેલી છે ત્યાં રહેવાનું અમે પસંદ કરીશું.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","એટલે મૂસાએ કહ્યું, “ઠીક, તો તમે જે કહ્યું છે તે પ્રમાંણે કરો અને યહોવાના યુદ્ધ માંટે પોતાને સજજ કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","અને યહોવા પોતાના શત્રુઓને તે દેશમાંથી હાંકી કાઢે ત્યાં સુધી તમાંરી સેનાની ટુકડીઓને યર્દન નદીને પાર રાખો અને ત્યાં રહો. ");
INSERT INTO guj2009_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","પછી તે ભૂમિ યહોવાના તાબામાં આવી જાય ત્યાર બાદ જ તમે પાછા ફરો તો, તમે યહોવા અને ઇસ્રાએલ પ્રત્યેના કર્તવ્યથી મુકત થશો અને આ ભૂમિ યહોવાની દ્રષ્ટિએ તમાંરી માંલિકીની થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","પરંતુ જો તમે જે કહ્યું, તે પ્રમાંણે નહિ કરો તો, તે યહોવાની વિરુદ્ધનું તમાંરું પાપ ગણાશે, અને તમાંરે તમાંરું પાપ અચૂક ભોગવવું પડશે. ");
INSERT INTO guj2009_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ભલે, જાઓ અને તમાંરાં કુટુંબો, સ્ત્રી બાળકો માંટે નગરો તથા તમાંરાં ઢોરઢાંખર માંટે વાડા બાંધો, અને તમે કહ્યું છે તે બધું તમે કરો. તમાંરું વચન પાળજો.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ગાદ અને રૂબેનના કુળસમૂહોએ મૂસાને કહ્યું, “ધણી, અમે આપના સેવકો આપ કહેશો તેમ કરીશું, અને તમાંરી સૂચનાઓ અક્ષઃરશ પાળીશું. ");
INSERT INTO guj2009_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","અમાંરાં બાળકો અને સ્ત્રીઓ, અમાંરાં ઘેટાબકરાં અને બીજાં બધાં પ્રાણીઓ અહીં ગિલયાદનાં ગામોમાં રહેશે, ");
INSERT INTO guj2009_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","પણ અમે આપના સેવકો બધા હથિયાર ધારણ કરીશું અને યર્દન પાર જઈશું યહોવાની સમક્ષ લડવા માંટે અમાંરા ધણીએ કહ્યા મુજબ.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","તેથી મૂસાએ યાજક એલઆઝાર, યહોશુઆ અને ઇસ્રાએલના કુળસમૂહના આગેવાનોને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“જો ગાદના અને રૂબેનના વંશજો હથિયાર ધારણ કરીને તમાંરી સાથે યહોવા સમક્ષ લડવાને યર્દન ઓળંગીને આવે, અને જો તે પ્રદેશ તમાંરા તાબામાં આવી જાય તો તમાંરે તેમને ગિલયાદનો પ્રદેશ તેમાં ભાગ તરીકે આપવો. ");
INSERT INTO guj2009_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","પણ જો તેઓ હથિયાર ધારણ કરીને તમાંરી સાથે યર્દન ઓળંગીને ન આવે તો તેમને તેમનો ભાગ કનાનમાં જ તમાંરી સાથે મળશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ગાદના અને રૂબેનના લોકોએ કહ્યું, “ધણી, અમે યહોવાએ જણાવ્યા મુજબ કરીશું. ");
INSERT INTO guj2009_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","અમે હથિયાર ધારણ કરીને યહોવા સમક્ષ યર્દન પાર કરીને કનાનના પ્રદેશમાં જઈશું. પણ અમને યર્દન નદીના આ પૂર્વકાંઠે અમાંરા ભાગની જમીન મળવી જોઈએ.” ");
INSERT INTO guj2009_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","આથી મૂસાએ ગાદના અને રૂબેનના વંશજોને તથા યૂસફના પુત્ર મનાશ્શાના અર્ધકુળસમૂહને અમોરીઓના રાજા સીહોનનું રાજ્ય અને બાશાનના રાજા ઓગનું રાજ્ય, એ સમગ્ર પ્રદેશ અને તેમાંના શહેરો તથા આજુબાજુની જમીન બધું આપી દીધું. ");
INSERT INTO guj2009_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","પછી ગાદના વંશજોએ કોટવાળાં નગરો બાંધ્યાં; દીબોન, અટારાથ, અરોએર, ");
INSERT INTO guj2009_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","આટ્રોથ-શોફાન, યાઝેર, યોગ્બહાહ, ");
INSERT INTO guj2009_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","બેથ-નિમ્રાહ અને બેન-હારાન, તથા ઘેટાબકરાંઓ માંટે વાડાઓ બાંધ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","રૂબેનના વંશજોએ હેશ્બોન, ");
INSERT INTO guj2009_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","એલઆલેહ, કિર્યાથાઈમ, નબો, બઆલ-મેઓન અને સિબ્માંહ આ રીતે નબો અને બઆલ-મેઓનને નવા નામ આપ્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ત્યારબાદ મનાશ્શાના વંશજોમાંથી માંખીરના કુળસમૂહના લોકોએ ગિલયાદ પર ચઢાઈ કરીને તે જીત લીધું અને ત્યાંથી અમોરીઓને હાંકી કાઢયા. ");
INSERT INTO guj2009_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","આથી મૂસાએ મનાશ્શાના કુળસમૂહના માંખીરને ગિલયાદ આપ્યું અને તે ત્યાં સ્થિર થયો. ");
INSERT INTO guj2009_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","મનાશ્શાના કુળસમૂહમાંથી યાઈરના ગોત્રના માંણસોએ ગિલયાદના અનેક નગરો પર ચઢાઈ કરી તેમનાં ગામડાં કબજે કરી લીધાં અને તેઓના પ્રદેશનું નામ બદલીને હાવ્વોથ-યાઈર નામ આપ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","વળી નોબાહ નામનો વ્યક્તિ લશ્કર લઈને કનાથ અને તેની આસપાસના ગામડાં પર ચઢી આવ્યો અને તે કબજે કરી લીધાં અને તેનું નામ પોતાના નામ ઉપરથી “નોબાહ” રાખ્યું. ");
INSERT INTO guj2009_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","મૂસા અને હારુનની આગેવાની હેઠળ ઇસ્રાએલ પ્રજા મિસરમાંથી બહાર આવ્યા પછી તે લોકોએ જે જે ઠેકાણે મુસાફરી કરી હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","તે તે સ્થળોનાં નામ યહોવાની આજ્ઞા અનુસાર મૂસાએ નોંધી લીધાં હતા. તે આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","પાસ્ખા પર્વની રાત્રિ પછીના દિવસે એટલે પહેલા મહિનાના 15 માં દિવસે તેઓ મિસરના રામસેસ નગરથી નીકળ્યા. મિસરવાસીઓના દેખતાં તેઓ યહોવાના રક્ષણ હેઠળ ઉઘાડે છોગે નીકળ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","તે વખતે મિસરીઓ યહોવાએ માંરી નાખેલાં તેમનાં પહેલાં સંતાનોને દફનાવતા હતા. આમ યહોવા મિસરના બધા જ દેવો પર પરાક્રમી દેવ પૂરવાર થયા. ");
INSERT INTO guj2009_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ત્યારબાદ ઇસ્રાએલીઓએ રામસેસથી નીકળીને સુક્કોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","તે પછી તેમણે સુક્કોથથી નીકળીને રણને કિનારે આવેલા એથામમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ત્યાંથી નીકળીને તેઓ બઆલ-સફોનની પાસે આવેલ પી-હાહીરોથ તરફ જઈને મિગ્દોલ પર્વતની તળેટીમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","પછી પી-હાહીરોથથી નીકળી રાતા સમુદ્રમાં થઈને તેઓ રણમાં પહોંચ્યા. પછી એથામના રણમાં ત્રણ દિવસનો રસ્તો કાપીને તેઓએ માંરાહમાં મુકામ કર્યો, ");
INSERT INTO guj2009_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","અને પછી માંરાહથી નીકળી તેઓ એલીમ આવ્યા, ત્યાં પાણીના 12 ઝરા અને તાડનાં 70 ખજૂરીનાં વૃક્ષો હતાં, ત્યાં તેમણે મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","પછી એલીમથી નીકળીને તેમણે રાતા સમુદ્ર પાસે મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","તેઓએ રાતાં સમુદ્ર છોડીને સીનના રણમાં મુકામ કર્યો, ");
INSERT INTO guj2009_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","તે પછી સીનના રણમાંથી નીકળીને દોફકાહમાં છાવણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","દોફકાહથી નીકળીને પછી આલૂશમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","આલૂશથી નીકળીને તેમણે રફીદીમમાં મુકામ કર્યો. પણ ત્યાં પીવાનું પાણી નહોતું. ");
INSERT INTO guj2009_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","પછી રફીદીમથી નીકળીને તેઓએ સિનાઈના રણમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","સિનાઈના રણમાંથી નીકળીને તેમણે કિબ્રોથ-હત્તાવાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","કિબ્રોથ-હત્તાવાહથી નીકળી તેમણે હસેરોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","હસેરોથથી તેમણે રિથ્માંહમાંથી મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","રિથ્માંહમાંથી નીકળીને તેઓએ રિમ્મોન-પેરેસમાં છાવણી કરી. ");
INSERT INTO guj2009_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","રિમ્મોન-પેરેસથી નીકળીને તેઓએ લિબ્નાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","પછી લિબ્નાહથી નીકળીને તેમણે રિસ્સાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","રિસ્સાહથી નીકળી તેમણે કહેલાથાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","કહેલાથાહથી નીકળીને તેઓએ શેફેર પર્વત આગળ મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","શેફેર પર્વતથી નીકળીને તેઓએ હરાદાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","હરાદાહથી નીકળીને તેમણે માંકેહેલોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","માંકેહેલોથથી નીકળી તેમણે તાહાથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","તાહાથથી નીકળી તેમણે તેરાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","તેરાહથી નીકળી તેમણે મિથ્કાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","મિથ્કાહમાંથી નીકળી તેમણે હાશ્મોનાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","હાશ્મોનાહથી નીકળી તેઓએ મોસેરોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","મોસેરોથથી નીકળીને તેમણે બની-યાઅકાનમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","બની-યાઅકાનથી નીકળીને તેઓએ હોર-હાગિદગાદમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","હોર-હાગિદગાદથી નીકળીને તેમણે યોટબાથાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ચોટબાથાહથી નીકળીને તેમણે આબ્રોનાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","આબ્રોનાહથી નીકળીને તેઓએ એસ્યોન-ગેબેરમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","એસ્યોન-ગેબેરથી નીકળીને તેમણે સીનના રણમાં એટલે કે કાદેશમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","કાદેશથી નીકળી તેમણે અદોમની સરહદે આવેલા હોર પર્વત આગળ મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","યહોવાએ આજ્ઞા આપી તે પ્રમાંણે યાજક હારુન હોર પર્વત ઉપર ગયો અને ત્યાં જ તે ઇસ્રાએલીઓએ મિસરમાંથી મહાપ્રસ્થાન કર્યા પછી ચાળીસમાં વર્ષે, પાંચમાં મહિનાના પ્રથમ દિવસે તે મૃત્યુ પામ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","તે મૃત્યુ પામ્યો ત્યારે તેની ઉમર 123 વર્ષની હતી. ");
INSERT INTO guj2009_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","કનાની ભૂમિમાં નેગેબમાં આવેલા શહેર અરાદના કનાની રાજાઓ સાંભળ્યુ કે ઇસ્રાએલી લોકો તેના દેશ તરફ આવી રહ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","પછી ઇસ્રાએલી પ્રજાએ હોર પર્વતથી યાત્રા કરી અને સાલ્મોનાહમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","સાલ્મોનાહથી નીકળીને તેઓએ પૂનોનમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","પૂનોનથી નીકળીને તેઓએ ઓબોથમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ઓબોથથી નીકળીને તેઓએ મોઆબીઓના પ્રદેશમાં અબારીમનાં ખંડેરોમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ત્યાંથી નીકળીને તેઓએ હીબોન-ગાદમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","હીબોન-ગાદથી નીકળીને તેઓએ આલ્મોન દિબ્લાથાઈમમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","આલ્મોન દિબ્લાથાઈમમાંથી નીકળીને તેમણે નબોની સામે આવેલા અબારીમ પર્વત આગળ મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","અબારીમ પર્વતથી નીકળીને અંતે તેઓએ યરીખોની સામે યર્દન નદીના કાંઠે મોઆબના મેદાનોમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","પછી તેઓએ યર્દનને કાંઠે બેથ-યશીમોથથી આબેલ-શિટ્ટીમ સુધી મોઆબના મેદાનમાં મુકામ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ત્યાં મોઆબના મેદાનોમાં યર્દનને કિનારે યરીખોની સામે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“તું ઇસ્રાએલી પ્રજાને કહે કે, તમે યર્દન નદી પાર કરીને કનાન દેશમાં પ્રવેશ કરો; ");
INSERT INTO guj2009_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ત્યારે તમાંરે દેશના બધા વતનીઓને હાંકી કાઢવા, તમાંરે તેમની બધી પથ્થરની કે ધાતુની મૂર્તિઓનો નાશ કરવો, તેમનાં બધાં કોતરેલા પથ્થરો, ધાતુની ગાળેલી પ્રતિમાંઓ તથા પર્વતોમાં આવેલાં મૂર્તિઓની પૂજા કરવાનાં દેવસ્થાનોનો તમાંરે પૂરો નાશ કરવો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","તમાંરે તે પ્રદેશનો કબજો લેવો અને તેમાં વસવાટ કરવો, કારણ કે, મે એ પ્રદેશ તમને જ આપી દીધો છે, તમાંરે ચિઠ્ઠી નાખીને એ પ્રદેશ તમાંરા વંશો અને કુળો વચ્ચે વહેંચી આપવો. ");
INSERT INTO guj2009_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","વધારે સંખ્યા ધરાવતા કુળસમૂહોને વધારે વિસ્તાર ધરાવતા પ્રદેશો અને ઓછી વસ્તી ધરાવતા કુળસમૂહોને ઓછો વિસ્તાર ધરાવતા પ્રદેશો વહેંચી આપવામાં આવશે. ");
INSERT INTO guj2009_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“તમે તે દેશમાં વસતા લોકોને ત્યાંથી હાંકી નહિ કાઢશો, અને ત્યાં રહેવા દીધા હશે તો તેઓ તમાંરી આંખમાં કણાની જેમ અને તમાંરા પડખામાં શૂળની જેમ ખૂંચ્યા કરશે, દેશની માંલિકી બાબત તેઓ સતત તમાંરી સાથે ઝધડયા કરશે, ");
INSERT INTO guj2009_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","અને મેં તેમની જે દશા કરવા ધાર્યુ હતું તેવી દશા હું તમાંરી કરીશ અને તમાંરો વિનાશ કરીશ.” ");
INSERT INTO guj2009_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ઇસ્રાએલીઓને તું આ પ્રમાંણે આજ્ઞા કર: હવે તમે કનાનના પ્રદેશમાં દાખલ થશો, તમાંરા તાબામાં આવનાર એ પ્રદેશની સરહદ આ પ્રમાંણે છે: ");
INSERT INTO guj2009_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","એનો દક્ષિણ છેડો અદોમની સરહદે આવેલા સીનના રણ આગળ પૂરો થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","એની દક્ષિણની સરહદ પૂર્વમાં મૃત સમુદ્રના છેડાથી શરૂ થઈ દક્ષિણમાં આક્રાબ્બીમ ઘાટ સુધી જઈ સીનમાં થઈને દક્ષિણમાં કાદેશ-બાર્નેઆ સુધી જાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ત્યાંથી તે હસાર આદાર થઈને છેક આસ્મોન સુધી જશે. ત્યાંથી મિસરના કોતર તરફ વળી ભૂમધ્ય સમુદ્ર આગળ પૂરી થાય છે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ભૂમધ્ય સમુદ્ર એ તમાંરી પશ્ચિમ સરહદ હશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","તમાંરી ઉત્તરની સરહદ ભૂમધ્ય સમુદ્રથી શરૂ થઈ હોર પર્વત સુધી જશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ત્યાંથી લબોહમાંથ થઈને સદાદ સુધી જશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ત્યાંથી એ ઝિફ્રોન થઈને હસાર-એનાન આગળ પૂરી થશે. આ તમાંરી ઉત્તરની સરહદ થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","તમાંરી પૂર્વની સરહદ હસાર એનાનથી શરૂ થઈ શક્રામ જશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","શક્રામથી એ આયિનની પૂર્વે આવેલ રિબ્લાહ થઈ નીચે ઊતરી કિન્નેરેથના સરોવરના પૂર્વ કિનારે પહોંચશે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ત્યાંથી એ સરહદ યર્દનને કિનારે આગળ વધી મૃત સમુદ્ર આગળ પૂરી થશે. આ થઈ તમાંરા દેશની ચારે દિશાની સરહદો.” ");
INSERT INTO guj2009_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","મૂસાએ ઇસ્રાએલીઓને આ પ્રમાંણે આજ્ઞા આપી, “આ પ્રદેશ તમાંરે ચિઠ્ઠી નાખીને વહેંચી લેવાનો છે, યહોવાએ એ પ્રદેશ નવ આખા અને એક અડધા કુળસમૂહોને સોંપી દેવા જણાવ્યું છે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","રૂબેન અને ગાદના કુળસમૂહોને અને મનાશ્શાના અર્ધકુળને વારસો વહેંચી આપવામાં આવ્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","યરીખોની સામે યર્દન નદીની પૂર્વ તરફનો પ્રદેશ તેઓને આપ્યો છે.” ");
INSERT INTO guj2009_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“નીચેના માંણસો તને જમીનની વહેંચણીમાં મદદ કરશે; યાજક એલઆઝાર અને નૂનનો પુત્ર યહોશુઆ. ");
INSERT INTO guj2009_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ઉપરાત જમીન વહેંચણી માંટે તેઓને મદદ કરવા તારે દરેક કુળસમૂહમાંથી એક આગેવાન લેવો. ");
INSERT INTO guj2009_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","એમનાં નામ આ પ્રમાંણે છે: યહૂદાના કુળસમૂહમાંથી યફૂન્નેહનો પુત્ર કાલેબ, ");
INSERT INTO guj2009_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","શિમયોનના કુળસમૂહમાંથી આમ્મીહુદનો પુત્ર શિમયોન. ");
INSERT INTO guj2009_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","બિન્યામીનના કુળસમૂહમાંથી કિસ્લોનનો પુત્ર અલીદાદ. ");
INSERT INTO guj2009_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","દાનના કુળસમૂહમાંથી યોગ્લીનો પુત્ર બુક્કી, ");
INSERT INTO guj2009_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","યૂસફના વંશજ મનાશ્શાના કુળસમૂહમાંથી એફોદનો પુત્ર હાન્નીએલ ");
INSERT INTO guj2009_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","એફ્રાઈમના કુળસમૂહમાંથી શિફાટાનનો પુત્ર કમુએલ, ");
INSERT INTO guj2009_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ઝબુલોનના કુળસમૂહમાંથી પાર્નાખનો પુત્ર અલીસાફાન. ");
INSERT INTO guj2009_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ઈસ્સાખારના કુળસમૂહમાંથી અઝઝાનનો પુત્ર પાલ્ટીએલ. ");
INSERT INTO guj2009_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","આશેરના કુલસમૂહમાંથી શલોમીનો પુત્ર આહીહૂદ, ");
INSERT INTO guj2009_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","નફતાલીના કુળસમૂહમાંથી આમ્મીહૂદનો પુત્ર પદાહએલ.” ");
INSERT INTO guj2009_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","કનાન પ્રદેશમાં કુળો મધ્યે ઇસ્રાએલીઓને જમીન વહેંચવા માંટે આ માંણસોની નિમણૂક મેં કરી છે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","મોઆબના મેદાનમાં યરીખો નજીક યર્દનને કાંઠે યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“તું ઇસ્રાએલીઓને આજ્ઞા કર કે, તેઓ લેવીઓને તેઓના વારસા તરીકે કેટલાંક નગરો અને આસપાસની ગૌચર જમીન આપે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","તે નગરોમાં તેઓ વસવાટ કરશે અને ગૌચરની જમીનમાં તેઓ પોતાનાં ઢોરો, ઘેટાંબકરાં અને અન્ય પશુઓ રાખશે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","તમે લેવીઓને જે નગરો આપો તેની ગૌચરની જમીન ગામાંના કોટની ચારે બાજુએ 1,000 હાથ હોય. ");
INSERT INTO guj2009_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","નગરથી 2,000 હાથ પૂર્વ સુધીનો, 2,000 હાથ દક્ષિણ સુધીનો, 2,000 હાથ પશ્ચિમ સુધીનો અને 2,000 હાથ ઉત્તર સુધીની બધી ભૂમિ લેવીઓની થશે. નગર તે સમગ્ર ભૂમિની મધ્યમાં આવેલું હશે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","તમાંરે લેવીઓને એકંદરે 48 ગામો ગૌચર જમીન સાથે સોંપવાના છે, તેમાંથી 6 આશ્રયનગરો તરીકે આપવાના છે. અજાણતા જેનાથી માંનવહત્યા થઈ ગઈ હોય તેમાંના એક આશ્રયનગરમાં નાસી જઈને ત્યા આશ્રય મેળવી શકે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","આમ, કુલ ઉડતાળીસ નગરો અને તેની આસપાસની ગૌચરની જમીન લેવીઓને સોંપવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","આ નગરો દેશના વિવિધ ભાગોમાં આવેલા હોય, મોટાં કુળસમૂહો પાસે વધુ નગરો છે, તેથી તેઓ વધુ નગરો આપે અને નાનાં કુળસમૂહો પાસે ઓછાં નગરો છે તેથી તેઓ લેવીઓને થોડાં નગરો આપે.” ");
INSERT INTO guj2009_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","યહોવાએ મૂસાને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“તું ઇસ્રાએલી લોકોને આ પ્રમાંણે કહે: જયારે તમે યર્દન નદી ઓળંગીને કનાનના પ્રદેશમાં પ્રવેશ કરો. ");
INSERT INTO guj2009_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ત્યારે તમાંરે અમુક નગરોને આશ્રયનાં નગરો તરીકે પસંદ કરવાં જેમાં જે માંણસે અકસ્માંતે હત્યા કરી હોય તે આશ્રય લઈ શકે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","એ નગરમાં તે મરનારનું વેર લેવા ઈચ્છતા સગાથી તે સુરક્ષિત રહી શકે. સમાંજ સમક્ષ ન્યાય ચલાવ્યા વિના તેને માંરી શકાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","તેથી તમાંરે આશ્રયનાં નગરો તરીકે છ શહેરો પસંદ કરવાં, ");
INSERT INTO guj2009_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ત્રણ યર્દન નદીની પૂર્વ બાજુએ અને ત્રણ કનાનમાં. ");
INSERT INTO guj2009_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","એ છ શહેરો આશ્રયનગરો ગણાશે અને તેમાં જેણે અકસ્માંતે ખૂન કર્યુ હોય તેવો ઇસ્રાએલી કે વિદેશી કે તમાંરી સાથે વસતો હોય તેવો કોઈ પણ વ્યક્તિ આશ્રય લઈ શકશે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“જો કોઈએ લોખંડના સાધનથી કોઈને માંરી નાખ્યો હોય, તો તે ખૂન ગણાશે, તે ખૂનીને દેહાતદંડની સજા આપવામાં આવે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","અથવા મોટો પથ્થર માંરીને કોઈની હત્યા કરી હોય, તો પણ તે ખૂન ગણાશે. તે ખૂનીને દેહાતદંડની સજા થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","એ જ પ્રમાંણે લાકડાથી ઈજા પહોંચાડી કોઈને માંરી નાખ્યો હોય, તો તે પણ ખૂન ગણાશે અને તે ખૂનીને દેહાતદંડની સજા થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","મોતનો બદલો લેનાર, ખૂનીને મળે ત્યારે તે પોતે જ તેને માંરી નાખે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“તેથી જો કોઈ દ્વેશને કારણે બીજી વ્યક્તિ પર કોઈ વસ્તુનો ઘા કરીને માંરી નાખે અથવા છુપાઈને લાગ જોઈને માંરી નાખે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","અથવા ગુસ્સે થઈને મુક્કા માંરી બીજી વ્યક્તિને માંરી નાખે તો તે ખૂની છે. મોતનો બદલો લેનાર વ્યક્તિ જ્યારે તે ખૂનીને મળે ત્યારે તેને માંરી નાખે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“પણ જો કોઈ વ્યક્તિ દુશ્મનાવટ વગર કોઈને અકસ્માંતે ગબડાવી મૂકે અથવા તેને માંરી નાખવામના ઈરાદા વગત તેના ઉપર કોઈ હથિયાર ફેંકે, ");
INSERT INTO guj2009_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","અથવા જોયા વગર પથ્થર ફેંકે અને તે કોઈને વાગે અને તે મરી જાય, અને જો મરનાર માંણસ માંરનારનો દુશ્મન ના હોય અને તેને ઈજા કરવાના ઈરાદાથી માંર્યો ના હોય, ");
INSERT INTO guj2009_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","તો સમાંજે એ માંરનાર અને મરનારના સૌથી નજીકના સગા વચ્ચેનો ન્યાય આ નિયમો પ્રમાંણે કરવો; ");
INSERT INTO guj2009_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","સમાંજે એ માંરનારનું મરનારના બદલો લેવા ઈચ્છતા સોથી નજીકના સગાના હાથથી રક્ષણ કરવું અને તેને એણે જે શહેરમાં આશ્રય લીધો હોય ત્યાં પાછો લાવવો, પ્રમુખ યાજકનું મૃત્યુ થાય ત્યાં સુધી તેણે એ નગરમાં રહેવું. ");
INSERT INTO guj2009_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","27","“જો મોત નીપજાવનાર આશ્રયનગર છોડીને બહાર જાય, અને મોતનો બદલો લેનાર તેને મળે અને તેને માંરી નાખે તો તે ખૂન ગણાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","કારણ કે મુખ્ય યાજકનું મૃત્યુ થાય ત્યાં સુધી મોત નીપજાવનારે આશ્રયનગરમાં જ રહેવું જોઈતું હતું. મુખ્ય યાજકના મૃત્યુ પછી તે વ્યક્તિ પોતાના પ્રદેશમાં અને પોતાને ઘરે પાછો ફરી શકે છે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","તમને અને તમાંરા વંશજોને આ નિયમો સર્વત્ર અને સર્વદા બંધનકર્તા છે. ");
INSERT INTO guj2009_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“મનુષ્યવધ કરનારને એકથી વધુ સાક્ષીઓના પુરાવાને આધારે જ ખૂની ઠરાવીને દેહાતદંડની સજા કરી શકાય. ફકત એક જ સાક્ષીનો પુરાવો દેહાંતદંડ આપવા માંટે પૂરતો ગણાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“દેહાતદંડની સજા થઈ હોય તેવા ખૂનીને પૈસા લઈને છોડી શકાય નહિ. તેનો વધ થવો જ જોઈએ. તેના માંટે કોઈ પણ ખંડાણીનો સ્વીકાર કરવામાં આવે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“મુખ્ય યાજકનું મરણ થાય તે પહેલાં આશ્રયનગરમાં રક્ષણ લેનાર હત્યારા પાસેથી કોઈ પણ પ્રકારની રકમ સ્વીકારીને તેને ઘરે પાછા ફરવા માંટેની રજા આપી શકાય નહિ. ");
INSERT INTO guj2009_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“તમે જે ભૂમિમાં વસો છો તેને ભ્રષ્ટ ન કરશો. ખૂનથી ભૂમિ ભ્રષ્ટ થાય છે. જે ભૂમિ પર ખૂન થયું છે તેનું પ્રાયશ્ચિત બીજી કોઈ રીતે થઈ શકે નહિ, ખૂનીને દેહાતદડંની સજા થવી જ જોઈએ. પ્રાયશ્ચિત કરવા માંટે ખૂનીના લોહી સિવાય બીજો કોઈ રસ્તો નથી. ");
INSERT INTO guj2009_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","તમે જે દેશમાં વસવા માંટે જાઓ છો, તેને તમે અપવિત્ર ન કરો, કારણ કે હું યહોવા તમાંરી મધ્યે નિવાસ કરનાર છું. તમે જે ભૂમિમાં વસો છો, જેમાં હું વસુ છું તેને તમાંરે ભ્રષ્ટ ન કરવી, કારણ હું યહોવા ઇસ્રાએલીઓ વચ્ચે વસુ છું.” ");
INSERT INTO guj2009_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","પછી યૂસફના પુત્રોનાં-કુટુંબોમાંના મનાશ્શાના પુત્ર-માંખીરના પુત્ર ગિલયાદના પુત્રોના કુટુંબના પિતૃઓનાં ઘરના વડીલોએ પાસે આવીને મૂસાની આગળ; તથા ઇસ્રાએલપુત્રોના કૂળસમૂહોના વડીલો એટલે અધિપતિઓની આગળ જઈને નમ્ર વિનંતી કરી કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“યહોવાએ તમને ચિઠ્ઠી ઉપાડીને ઇસ્રાએલી પ્રજા વચ્ચે જમીન વહેંચી આપવા આદેશ કર્યો છે, અને તેમણે અમાંરા ભાઈ સલોફદાહની જમીન તેની પુત્રીઓને આપવાનું પણ આદેશ કર્યો છે. ");
INSERT INTO guj2009_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","પરંતુ હવે જો તેઓ ઇસ્રાએલીઓના કોઈ બીજા કુળસમૂહમાં પરણે, તો તેમની જમીન તે કૂળસમૂહને જશે, અને અમાંરા કુળસમૂહના ભાગની જમીનમાં એટલો ઘટાડો થશે. ");
INSERT INTO guj2009_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","અને જ્યારે ઇસ્રાએલીઓનું જુબિલીનું વર્ષ આવે, ત્યારે પણ તેમની જમીન તેઓ જે કૂળસમૂહમાં પરણી હશે તે કુળસમૂહની જમીનમાં જ કાયમ રહેશે, અને અમાંરો કૂળસમૂહ એ કાયમને માંટે ગુમાંવશે.” ");
INSERT INTO guj2009_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","આથી મૂસાએ જાહેરમાં યહોવા તરફથી મળેલી આજ્ઞા અનુસાર ઇસ્રાએલીઓને આ નિર્ણય કહી સંભળાવ્યો: “યૂસફના કૂળસમૂહની ફરિયાદ સાચી છે, ");
INSERT INTO guj2009_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","સલોફદાહની પુત્રીઓ સંબંધી યહોવાએ વધારમાં આ આજ્ઞાઓ આપી છે: પોતાની પસંદગીની વ્યક્તિ સાથે તેઓ લગ્ન કરી શકે છે; પણ તે પોતાના જ કૂળસમૂહનો હોવો જોઈએ. ");
INSERT INTO guj2009_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ઇસ્રાએલીઓની જમીન એક કૂળસમૂહમાંથી બીજા કૂળસમૂહમાં જઈ શકે નહિ. પરંતુ દરેક ઇસ્રાએલી પોતાના પૂર્વજોની જમીન રાખશે. ");
INSERT INTO guj2009_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","જે તે કૂળસમૂહની જમીન જે તે કૂળસમૂહમાં જ વારસામાં સદાને માંટે જળવાઈ રહેવી જોઈએ, કોઈ પણ ઇસ્રાએલી સ્ત્રીને પિતાની જમીનનો વારસો મળ્યો હોય તો તેણે પોતાના કૂળસમૂહના જ કોઈ કુટુંબમાં પરણવું, ");
INSERT INTO guj2009_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","જેથી દરેક ઇસ્રાએલીની વંશપરંપરાગત જમીન સચવાઈ રહે, આ રીતે વારસાનો કોઈ ભાગ એક કૂળસમૂહમાંથી બીજા કૂળસમૂહમાં જશે નહિ.” ");
INSERT INTO guj2009_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","યહોવાએ મૂસાને જણાવ્યું હતું તે પ્રમાંણે જ સલોફદાહની પુત્રીઓએ કર્યુ, ");
INSERT INTO guj2009_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","તેથી માંહલાહ, નિર્સાહ, હોગ્લાહ, મિલ્કાહ અને નોઆહએ તેઓના પિતરાઈ ભાઈઓ એટલે કે પોતાના કાકાઓના પુત્રો સાથે લગ્ન કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","તેઓએ યૂસફના પુત્ર મનાશ્શાના કુળસમૂહમાં તેમના કુટુંબમાં જ લગ્ન કર્યા, એટલે તેમની જમીન તેમના કૂળસમૂહમાં જ રહીં અને તેમનો વારસો સુરક્ષિત રહ્યો. ");
INSERT INTO guj2009_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","યર્દન નદીને કાંઠે મોઆબના મેદાનમાં યરીખો સામે યહોવાએ મૂસા માંરફતે ઇસ્રાએલીઓ માંટે જણાવેલા કાનૂનો અને નિયમો ઉપર પ્રમાંણે હતા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","જયારે સર્વ ઇસ્રાએલી પ્રજા યર્દન નદીને પૂવેર્ આવેલા મોઆબના રણ પ્રદેશમાં હતી, મૂસાએ તે લોકોને જે વચનો કહ્યાં હતાં તે આ પ્રમાંણે છે, તે વખતે તેઓ યર્દનકાંઠામાં સૂફની સામે હતા. તેમની એક તરફ પારાનનું રણ આવેલું હતું અને બીજી તરફ તોફેલ, લાબાન, હસેરોથ અને દીઝાહાબ આવેલાં હતાં. ");
INSERT INTO guj2009_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","હોરેબ પર્વતથી સેઇર પર્વતે કાદેશ-બાનેર્આ દ્વારા યાત્રાને અગિયાર દિવસ થતા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ઇસ્રાએલી લોકોએ મિસર છોડયા પછી ચાળીસમાં વષેના અગિયારમાં મહિનાના પ્રથમ દિવસે મૂસાએ, યહોવાની આજ્ઞા મુજબ આ વચનો તે લોકોને કહી સંભળાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","યહોવાએ હેશ્બોનમાં અમોરીઓના રાજા સીહોનને અને એડેઇ પાસે આશ્તારોથમાં બાશાનના રાજા ઓગને હરાવ્યા હતા ત્યાર પછીનું આ હતું. ");
INSERT INTO guj2009_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","મૂસાએ લોકોને સંબોધ્યા અને દેવે ઇસ્રાએલ માંટે બનાવેલા નિયમો તેમને સમજાવ્યાં. તે સમયે ઇસાએલના લોકો મોઆબના દેશમાં યર્દન નદીની પૂર્વ દિશા પર હતાં. ");
INSERT INTO guj2009_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“જયારે આપણે હોરેબમાં હતા ત્યારે આપણા દેવ યહોવાએ આપણને આમ કહ્યું હતું કે, ‘તમે આ પર્વત આગળ ઘણું લાંબુ રહ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","હવે આ જગ્યા છોડો, આગળ વધો અને અમોરીઓનો પર્વતીય પ્રદેશ, યર્દનની ખીણ, મધ્યનો પર્વતીય દેશ, દક્ષિણનો રણ પ્રદેશ, ભૂમધ્ય સમુદ્ર કિનારો, કનાન અને લબાનોનની જમીનો, છેક મહાનદી ફ્રાંત સુધી કબજે કરો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","જુઓ, એ સમગ્ર પ્રદેશ હું તમને સોંપી દઉ છું; તમાંરા પૂર્વજો ઇબ્રાહિમ, ઇસહાક અને યાકૂબને તથા તેમના વંશજોને યહોવાએ જે દેશ આપવાનું વચન આપ્યું હતું, તે પ્રદેશમાં તમે જાઓ અને તેનો કબજો મેળવો.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“તે વખતે મેં તમને લોકોને જણાવ્યું હતું કે ‘હવે હું એકલો તમાંરા બધાનો બોજો ઉપાડી શકું તેમ નથી. ");
INSERT INTO guj2009_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","કારણ કે યહોવાએ તમાંરો વંશવેલો ઘણો વધાર્યો છે, આજે તમે આકાશના તારાઓ જેટલા થઈ ગયા છો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","તમાંરા પૂર્વજોના દેવ યહોવાએ તમાંરી સંખ્યા 1,000 ગણી વધારી છે. તે તમને તેના વચન પ્રમાંણે આશીર્વાદ આપે. ");
INSERT INTO guj2009_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","પણ હું એકલો તમાંરા સૌના ઝઘડા અને પ્રશ્ર્નોનું નિરાકરણ કેવી રીતે કરી શકું? ");
INSERT INTO guj2009_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","માંટે તમે પ્રત્યેક કુળસમૂહમાંથી શાણા, સમજુ અને અનુભવી માંણસોને પસંદ કરો અને હું તેમને તમાંરા આગેવાન તરીકે નિયુકત કરીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“અને તમે સૌ સંમત થયા હતા અને કહ્યું કે ‘તમાંરો અભિપ્રાય સારો છે અમે તે કરીશું.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“તેથી પ્રત્યેક કુળમાંથી હોશિયાર અને અનુભવી માંણસોને મેં પસંદ કર્યા અને તેઓને તમાંરા આગેવાનો અને અમલદારો તરીકે નિમ્યા; કેટલાકને 1,000ના, કેટલાકને 100ના, કેટલાકને 50ના તો કેટલાકને 10ના આગેવાનો બનાવ્યા. અને મેં બીજાને પ્રત્યેક કુળસમૂહના અમલદારો નીમ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“મેં તમાંરા અધિકારીઓને તે વખતે આ પ્રમાંણે આજ્ઞા કરેલી: ‘તમાંરા જાતિભાઈઓ વચ્ચે જે ઝઘડા થાય તે તમાંરે સાંભળવા, કોઈને પોતાના જાતિભાઈઓ સાથે કે તમાંરી વચ્ચે રહેતા વિદેશીઓ સાથે ઝઘડો હોય તો તેનો નિષ્પક્ષ રહીને નાનામોટા સૌનો ઉચિત ન્યાય કરવો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ન્યાય કરતી વખતે તમાંરા ઉપર કોઇનો પ્રભાવ ન પડવા દેવો. નાનામોટા સૌની સાથે સમાંન વ્યવહાર કરવો. જે ચુકાદો તમે આપો છો તે દેવનો ચુકાદો છે, તેથી કોઇનાથી ડરવું નહિ. જો કોઈ મુકદમો તમને અઘરો લાગે તો તે તમાંરે માંરી પાસે લાવવો, હું તેનો નિકાલ કરીશ.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","તે જ વખતે મેં તેઓને તેમને કરવાની બધી બાબતો વિષે સૂચાનાઓ આપી હતી. ");
INSERT INTO guj2009_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“ત્યારબાદ આપણે દેવ યહોવાની આજ્ઞાને અનુસરીને હોરેબ પર્વત છોડીને પેલા વિશાળ અને ભયંકર રણપ્રદેશમાં થઈને અમોરીઓના પર્વતીય પ્રદેશ તરફ જવા નીકળી પડયા, અને કાદેશ-બાનેર્આ પહોંચ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ત્યારે મેં તમને કહ્યું હતું: ‘હવે તમે અમોરીઓના પ્રદેશમાં આવી પહોંચ્યા છો, જે આપણા દેવ યહોવાએ આપણને આપવાનું વચન આપ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","જુઓ, તમાંરા દેવ યહોવાએ તમને આ પ્રદેશ સોંપી દીધો છે. તમાંરા પિતૃઓના દેવ યહોવાની આજ્ઞાને અનુસરો, જાઓ અને એનો કબજો લઈ લો, ડરશો નહિ કે નાહિંમત પણ થશો નહિ.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“પરંતુ તમે બધાએ માંરી પાસે આવીને મને જણાવ્યું કે, ‘આપણે પહેલાં દેશની તપાસ કરવા જાસૂસો મોકલીએ, તેઓ આવીને આપણને કહેશે કે આપણે ક્યા માંગેર્ જવું અને ત્યાંનાં નગરો કેવાં છે?’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“મને આ સૂચના ઠીક લાગી, તેથી મેં પ્રત્યેક વંશમાંથી એક એમ બાર વંશમાંથી બાર માંણસો પસંદ કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","તે બધા પર્વતીય દેશમાં એશ્કોલના કોતર સુધી ગયા અને જમીનને જોઇ, ");
INSERT INTO guj2009_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ત્યાંથી તેમણે કેટલાંક ફળ ભેગાં કર્યા અને ત્યાંથી તેઓ પાછા આવ્યા અને જણાવ્યું કે, ‘આપણા દેવ યહોવાએ આપણને જે પ્રદેશ આપ્યો છે તે સમૃદ્ધ છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“પણ તમે લોકોએ તે પ્રદેશમાં જવાની ના પાડી અને યહોવાની આજ્ઞાનો અનાદર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","તમે લોકોએ તમાંરા તંબુમાં બબડાટ શરૂ કર્યો કે, ‘યહોવા આપણને ધિક્કારે છે, તેથી જ તેમણે આપણને મિસરમાંથી બહાર લાવીને અમોરીઓના હાથમાં સોંપી દીધાં જેથી તેઓ આપણા સૌનો વિનાશ કરે. ");
INSERT INTO guj2009_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","આપણે કયાં જઈ રહ્યા છીએ? આપણા જ જાતિભાઈઓએ એમ કહી આપણામાં ખૂબ ભય ઉત્પન કર્યો છે કે, “ત્યાંના લોકો આપણા કરતાં કદમાં મોટાં અને શકિતશાળી છે, તેમનાં નગરો મોટાં છે અને તેના કોટ આકાશે અડે તેવા ઊચા છે અને અમે ત્યાં કદાવરો પણ જોયાં!’” ");
INSERT INTO guj2009_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“ત્યારે મેં તમને કહ્યું, ‘તમે ગભરાશો નહિ, એમનાથી ડરશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","તમાંરા દેવ યહોવા તમાંરી આગળ જશે, અને તમે મિસરમાં હતા ત્યારે તમાંરા માંટે જેમ પરાક્રમી કૃત્યો કર્યા તેમ તમાંરા માંટે લડશે. ");
INSERT INTO guj2009_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","રણપ્રદેશની યાત્રા દરમ્યાન તમે જોયું છે કે કોઈ પિતા પોતાના બાળકને ઉપાડી લે તેમ યહોવા તમને અહીં સુધી સતત તમાંરી સંભાળ રાખીને લાવ્યા છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“છતાં માંરા કહેવાનો કોઈ પ્રભાવ તમાંરા પર પડયો નહિ, તમે તમાંરા દેવ યહોવા ઉપર વિશ્વાસ ન કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","યહોવા આખા રસ્તે તમાંરા મુકામ માંટે જગ્યા શોધવા તમાંરી આગળ ચાલતા હતા. રાત્રે અગ્નિસ્તંભ દ્વારા અને દિવસે મેઘસ્તંભ દ્વારા તે આગળ રહી તમને માંર્ગ બતાવતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“યહોવા તમાંરો બડબડાટ સાંભળીને ખૂબ કોપાયમાંન થયા અને તેમણે પ્રતિજ્ઞા કરી કે, ");
INSERT INTO guj2009_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘તમાંરા પિતૃઓને મેં જે સમૃદ્વ પ્રદેશ આપવાનું વચન આપ્યું હતું તે આ લોકોમાંના કોઈને-આ દુષ્ટ પેઢીમાંના કોઈને, જોવા ન દેવો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ફકત યફૂન્નેહના પુત્ર કાલેબને તે પ્રદેશ જોવા મળશે. તે જે ભૂમિમાંથી ફરી આવ્યો છે તે હું તેને અને તેના વંશજોને આપીશ, કારણ, તે મને પૂરેપૂરો વિશ્વાસુ રહ્યો છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“વળી તમાંરા કારણે યહોવાએ માંરા ઉપર રોષે ભરાઈને કહ્યું, ‘તું પણ એ પ્રદેશમાં પ્રવેશ કરી શકશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","પણ તારો સેવક યહોશુઆ જે નૂનનો પુત્ર છે તે લોકોને દોરી જશે, તેને હિંમત આપજે, કારણ કે એ જ ઇસ્રાએલને એ પ્રદેશનો કબજો અપાવનાર છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","પણ તે તમાંરા બાળકો છે જે ત્યાં જશે તે બાળકો કે જેના વિષે તમે કહેલું કે, ‘તેઓ રણમાં મૃત્યુ પામશે અને તે દિવસોમાં જેઓને સારા અને દુષ્ટ વચ્ચેના અંતરની ખબર ન હતી. હું જમીન તે બાળકોને આપી દઇશ અને તેઓ તેને કબજે કરશે. ");
INSERT INTO guj2009_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","હવે તમાંરે સૌએ તો પાછા ફરીને રાતા સમુદ્રનાં રસ્તે પાછા રણમાં જ જવાનું છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“ત્યારે તમે કબૂલ થયા અને મને એવો જવાબ આપ્યો હતો કે, ‘અમે યહોવાનો ગુનો કરીને પાપ કર્યું છે, હવે અમે અમાંરા દેવ યહોવાની આજ્ઞા મુજબ જઈશું અને તે પ્રદેશ કબજે કરવા યુદ્ધ કરીશું.’ “પછી તેઓ બધાએ હથિયાર ધારણ કર્યા અને પર્વતીય પ્રદેશ ઉપર હુમલો કરવા અધીરા થઇ નીકળી પડ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","પરંતુ યહોવાએ મને કહ્યું, ‘તું એ લોકોને જણાવી કે, તેઓ યુદ્ધ કરવા જાય નહિ, હું તેઓની સાથે નથી, તેઓ તેમના શત્રુઓ સામે હાર પામશે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","“મેં તે બધાને એ મુજબ કહ્યું, પણ તે લોકોએ સાંભળ્યું નહિ, અને તેઓએ ફરીથી યહોવાની આજ્ઞાનો અનાદર કર્યો અને આવેશમાં પર્વતીય પ્રદેશ ઉપર હુમલો કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","પરંતુ ત્યાં પર્વતોમાં વસતા અમોરીઓ તમાંરો સામનો કરવા બહાર નીકળી આવ્યા અને મધમાંખીઓ જેમ તમાંરો પીછો પકડી સેઇરમાં આવેલા હોર્માંહ આગળ તમાંરી સેનાને ભયંકર નુકસાન પહોચાડ્યું અને હાર આપી. ");
INSERT INTO guj2009_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","એટલે તમે પાછા આવ્યા અને યહોવા સમક્ષ આક્રંદ કરવા લાગ્યા, છતાં પણ યહોવાએ તમાંરો પોકાર સાંભળ્યો નહિ, ");
INSERT INTO guj2009_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","આથી તમાંરે કાદેશમાં લાંબા સમય સુધી રોકાવું પડ્યું. ");
INSERT INTO guj2009_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“પછી યહોવાએ મને આપેલી આજ્ઞા મુજબ આપણે પાછા ફર્યા અને રાતા સમુદ્રને રસ્તે રણપ્રદેશમાં આગળ વધ્યા. ઘણા વષોર્ સુધી આપણે સેઇરના પર્વતીય પ્રદેશની આજુબાજુ ભટકયા. ");
INSERT INTO guj2009_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","પછી યહોવાએ મને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘આ પર્વતીય પ્રદેશમાં તમે બહુ સમય ભટકયા હવે ઉત્તરમાં જાઓ. ");
INSERT INTO guj2009_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","લોકોને આમ કહે: હવે તમે સેઇરની ભૂમિમાંથી પસાર થવાના છો, જ્યાં એસાવના વંશજો, તમાંરા સગાંઓ રહે છે. તેઓ તમાંરાથી ડરી જશે. છતાં કાળજી રાખજો. ");
INSERT INTO guj2009_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","તેઓની સાથે યુદ્ધ શરૂ કરશો નહિ. કારણ કે સેઇર પર્વતનો એ સમગ્ર પર્વતીય પ્રદેશ મેં એસાવને કાયમી વારસા તરીકે સોંપી દીધો છે. હું તમને એમના પ્રદેશમાંથી એક વેંત જેટલી જમીન પણ આપીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","તમે જે કંઈ ખાઓ કે જળ પીઓ તેની રકમ ચૂકવી દેજો; પૈસા ચૂકવ્યા વિના કશું જ ખાશો-પીશો નહિ, ");
INSERT INTO guj2009_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","કારણ કે અત્યાર સુધી તમાંરાં બધાં જ કાર્યોમાં યહોવા તમાંરા દેવે તમને સફળતા આપી છે, અને આ વિશાળ રણપ્રદેશમાં 40 વર્ષ યહોવા તમાંરા દેવે મુસાફરી દરમ્યાન તમાંરું રક્ષણ કર્યુ છે, તે સદાય તમાંરી સાથે રહ્યા છે અને તમને જોઇતું બધું તમને મળી ગયું હતું.’ ");
INSERT INTO guj2009_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“આથી આપણે સેઇરમાં વસતા આપણા સગાંઓ એસાવના વંશજોમાંથી પસાર થયા અને એલાથ અને એશ્યોન-ગેબેરથી મૃત સરોવર જતા માંગેર્ મુસાફરી કરી. પછી અમે વળ્યાં અને મોઆબના રણ તરફ આગળ વધ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“ત્યાં યહોવાએ આપણને ચેતવણી આપતાં કહ્યું, ‘લોટના વંશજો મોઆબીઓને પણ છેડશો નહિ કે તેમની સાથે યુદ્ધ પણ કરશો નહિ, કારણ કે, તેઓના પ્રદેશમાંથી પણ હું તમને જમીન આપીશ નહિ. મેં આરનગર અને તે પ્રદેશ લોટના વંશજોને આપી દીધો છે.’” ");
INSERT INTO guj2009_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(અગાઉ એમીઓ ત્યાં રહેતા હતા. તેઓની વસતી ઘણી હતી અને તેઓ અનાકીઓ જેવા ઊચા તથા કદાવર હતા. ");
INSERT INTO guj2009_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","અનાકીઓની જેમ તેઓ પણ રફાઇમીઓ ગણાતા હતા પણ મોઆબીઓ તેમને એમીઓ કહેતા હતા. ");
INSERT INTO guj2009_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","હોરીઓ પહેલા સેઇરમાં રહેતા હતા, પણ એસાવના વંશજો તેઓને હાંકી કાઢીને તેમની ભૂમિ પડાવી લીધી, અને તેમનું નામનિશાન ભૂંસી નાખ્યું. અને તેમની જગ્યાએ પોતે વસવા લાગ્યા, જેમ ઇસ્રાએલીઓએ યહોવાએ, તેમને આપેલી ભૂમિનાં મૂળ વતનીઓની સાથે કર્યુ તેમ.) ");
INSERT INTO guj2009_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","પછી યહોવાએ આપણને કહ્યું, “‘હવે, ઝેરેદની ખીણ ઓળંગો.’ આથી આપણે ઝેરેદની ખીણ ઓળંગી. ");
INSERT INTO guj2009_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","આપણી મુસાફરી કાદેશ બાનેર્આથી નીકળીને ઝેરેદનું કોતર ઓળંગતા સુધીમાં આપણને આડત્રીસ વષોર્ લાગ્યાં. અને એ સમય દરમ્યાન યહોવાના કહ્યા પ્રમાંણે યોદ્વાઓની એક આખી પેઢી સમાંપ્ત થઈ ગઈ. ");
INSERT INTO guj2009_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","તેઓ બધા મૃત્યુ પામે અને તેઓને ઇસ્રાએલી પડાવમાંથી દૂર કરવામાં આવે તેમ યહોવાએ કર્યુ. ");
INSERT INTO guj2009_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“જયારે એ લોકોમાંના બધા જ યોદ્વા મરી ગયા ");
INSERT INTO guj2009_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ત્યારે યહોવાએ મને કહ્યું, ");
INSERT INTO guj2009_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘આજે તારે મોઆબની સરહદે આવેલા આરને વટાવીને લોટના વંશજો ");
INSERT INTO guj2009_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","આમ્મોનીઓના પ્રદેશમાં પહોંચી જવાનું છે. પરંતુ તેમને છેડશો નહિ કે તેમની સાથે યુદ્ધ પણ કરશો નહિ, કારણ કે, તેઓની ભૂમિમાંથી હું તમને એક વસ્તુ પણ આપવાનો નથી. મેં તે પ્રદેશ તો લોટના વંશજોને આપી દીધો છે.’” ");
INSERT INTO guj2009_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","એ પ્રદેશ પણ રફાઈઓનો ગણાતો કારણ કે, એક વખતે તેઓ ત્યાં વસતા હતા, જો કે આમ્મોનીઓ તેમને “ઝામઝુમીઓ” કહે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","તે પ્રજા પણ અનાકીઓની જેમ કદમાં ઊચી અને કદાવર હતી. તેઓની વસ્તી ઘણી વધારે હતી. પરંતુ આમ્મોનીઓનો ધસારો થતાં યહોવાએ તેઓનો નાશ કર્યો અને આમ્મોનીઓ તેઓની જગ્યાએ વસ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","તેવી જ રીતે સેઇરમાં વસતા એસાવના વંશજોને દેવે મદદ કરી. જ્યારે હોરીઓએ એમના ઉપર હુમલો કર્યો ત્યારે દેવે હોરીઓનો નાશ કરવામાં તેમની મદદ કરી. અને એસાવના વંશજોએ તે લોકોના પ્રદેશનો કબજો લઈને ત્યાં વસવાટ કર્યો અને આજે પણ તેઓ ત્યાં રહે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","છેક ગાઝા સુધીના ગામોમાં રહેતા આવ્વીઓનું પણ એમ જ થયું હતું. કાફતોરથી આવેલા કાફતોરીઓએ તેઓનું નિકંદન કાઢીને તેઓની જગ્યાએ વસવા માંડ્યું. ");
INSERT INTO guj2009_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“પદ્ધી યહોવાએ આપણને કહ્યું, ‘હવે, ચાલો, નીકળી પડો અને આનોર્નંની ખીણ વટાવી જાઓ, કારણ, મેં હેશ્બોનના રાજા અમોરી સીહોનને તેમજ તેના પ્રદેશને તમાંરા હાથમાં સોંપી દીધા છે. તેના ઉપર હુમલો કરો અને પ્રદેશ કબજે લેવા માંડો. ");
INSERT INTO guj2009_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","આકાશ નીચે વસતા બધા લોકોને આદ્વથી તમાંરાથી ગભરાતા અને બીતા રહે એમ હું કરીશ; બધા ભયથી થથરશે જ્યારે તેઓ તમાંરા વિષે સાંભળશે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“ત્યારબાદ મેં કદેમોથના વગડામાંથી હેશ્બોનના રાજા સીહોનને આ મુજબ શાંતિનો સંદેશો એલચીઓ માંરફતે મોકલાવ્યો કે, ");
INSERT INTO guj2009_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘મહેરબાની કરીને અમને તમાંરા પ્રદેશમાંથી પસાર થવાદો. ડાબી કે જમણી બાજુ ફંટાયા વિના અમે સધા ધોરી માંર્ગે ચાલ્યા જઈશું. ");
INSERT INTO guj2009_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","રસ્તામાં અમે જે કાંઈ ખાઈશું કે જલપાન કરીશું એના પૈસા ચૂકવી દઈશું; અમાંરે ફકત તમાંરા પ્રદેશમાંથી પસાર થઇ. ");
INSERT INTO guj2009_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","યર્દન નદી ઓળંગીને અમાંરા દેવ યહોવા અમને જે ભૂમિ આપે છે ત્યાં અમાંરે જવું છે. અમને પસાર થવા દે જેમ સેઇરમાં વસતા એસાવના વંશજોએ તથા આરમાં વસતા મોઆબીઓએ થવા દીધાં.’ ");
INSERT INTO guj2009_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“પરંતુ હેશ્બોનના રાજા સીહોને આપણને માંર્ગ આપવાની ના પૅંડી, કારણ, તમાંરા દેવ યહોવાએ તેને હઠીલો અને બળવાખોર બનાવી દીધો, જેથી તે તમાંરા હાથે સીહોનનો વિનાશ કરે અને તેના પ્રદેશનો તમે કબજો કરી શકો, જે હજી પણ અમાંરી પાસે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“પદ્ધી યહોવાએ મને કહ્યું, ‘જો મેં સીહોનને અને તેના પ્રદેશને તારા હાથમાં સોંપી દેવા માંડયા છે, એની ભૂમિનો કબજો લેવાનું તું શરૂ કરી દે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“ત્યારબાદ સીહોન પોતાનું સમગ્ર સૈન્ય લઈને યાહાસ આગળ આપણી સામે યદ્ધ કરવાને બહાર પડ્યો, ");
INSERT INTO guj2009_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","પરંતુ આપણા દેવ યહોવાએ તેને આપણા હાથમાં સોંપી દીધા; અંતે આપણે તેને તેના પુત્રોને તથા તેના સમગ્ર સૈન્યને હરાવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ત્યારબાદ આપણે તેનાં બધાં શહેરો કબજે કર્યા, અને દરેક શહેરમાંના બધાં જ સ્ત્રી, પુરુષો અને બાળકોની હત્યા કરી, કોઈનેય જીવતા રહેવા ન દીધા; ");
INSERT INTO guj2009_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","પણ આપણે જીતેલાં નગરોમાંથી મળેલી લૂંટ તથા પશધન આપણે રાખ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","અનોર્નની ખીણની ધારે આવેલા અરોએરથી માંડીને ગિલયાદ સધીના સપાટ પ્રદેશમાં એક પણ નગર આપણી સામે ટકી શકયું નહોતું, આપણા દેવ યહોવાએ બધાં જ નગરો આપણા હાથમાં સોંપી દીધાં. ");
INSERT INTO guj2009_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","પરંતુ આમ્મોનીઓના પ્રદેશમાં-યબ્બોક ખીણની આસપાસના કે પર્વતીય પ્રદેશમાં આવેલાં ગામોમાં જયાં જયાં જવાની આપણા દેવ યહોવાએ આપણને મનાઈ કરી હતી ત્યાં ત્યાં આપણે ગયા જ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“ત્યારબાદ આપણે વળીને બાશાનને માંગેર્ આગળ વધ્યા. બાશાનનો રાજા ઓગ પોતાનું આખું સૈન્ય લઈને એડેઇ મુકામે આપણી સામે યુદ્ધ કરવા ધસી આવ્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","પરંતુ યહોવાએ મને કહ્યું, ‘એનાથી તું ડરતો ના, કારણ કે, મેં તેને એની આખી સેના અને તેના પ્રદેશ સાથે તારા હાથમાં સોંપી દીધો છે. મેં જે હાલ હેશ્બોનના રહેતા આમ્મોનીઓના રાજા સીહોનના કર્યા તેવા જ હાલ તું એના કર.’ ");
INSERT INTO guj2009_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“આમ, આપણા દેવ યહોવાએ બાશાનના રાજા ઓગને પણ તેના સમગ્ર સૈન્ય સાથે હરાવવામાં આપણને મદદ કરી અને આપણે તે તમાંમનો સંહાર કર્યો, એકને ય જીવતો જવા દીધો નહિ, ");
INSERT INTO guj2009_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","તે વખતે આપણે ઓગના સર્વ એટલે કુલ સાઠ નગરોથી સંપૂર્ણ આગોર્બ પ્રદેશ એટલે કે રાજા ઓગનું બાશાન રાજ્ય કબજે કર્યુ, તેવું એક પણ નગર ન હતું જે અમે કબજે ન કર્યુ હોય. ");
INSERT INTO guj2009_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","આ બધાં નગરો ઊચા કોટ અને દરવાજાં સાથે ભૂંગળોવાળાં હતાં. ઉપરાંત, કોટ વગરનાં અનેક ગામો આપણે કબજે કર્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","હેશ્બોનના રાજા સીહોનની બાબતમાં પણ આપણે જે કર્યુ હતું તેમ, આખાને આખા બાશાનનાં નગરો અને તેના સ્ત્રી, પુરુષ, બાળકોનો નાશ કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","પરંતુ કબજે કરેલાં નગરોમાંથી પ્રાપ્ત થયેલ લૂંટ અને પશુધન આપણે માંટે રાખી લીધાં. ");
INSERT INTO guj2009_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“એ વખતે આપણે યર્દન નદીની પૂર્વ બાજુએ અમોરીઓના એ બે રાજાઓનો સમગ્ર પ્રદેશ-આનોર્નની ખીણથી હેમોર્ન પર્વત સુધીનો કબજે કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","સિદોનીઓ હેમોર્ન પર્વતને સીર્યોનન કહે છે અને અમોરીઓ તેને સનીર કહે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","આપણે ઓગના તાબા હેઠળનાં સપાટ પ્રદેશમાંનાં તમાંમ નગરો, સમગ્ર ગિલયાદ તેમ જ છેક સાલખાહ અને એડેઇ સુધીનો બાશાનનો સમગ્ર પ્રદેશ જીતી લીધો હતો.” ");
INSERT INTO guj2009_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","જ્રરાક્ષસી રફાઈઓમાંથી ફકત બાશાનનો રાજા ઓગ એકલો જ બાકી રહ્યો હતો. આજે પણ આમ્મોનીઓના રાબ્બાહ નગરમાં તેનો લોખંડનો સાડાતેર હાથ લાંબો અને છ હાથ પહોળો પલંગ જોવા મળે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“આપણે જે ભૂમિ કબજે કરી હતી, તે મેં રૂબેન અને ગાદના વંશજોને આપી: અરોએરનો આનોર્ન નદીના કાંઠા પરનો પ્રદેશ તથા ગિલયાદના પર્વતીય પ્રદેશનો અડધો ભાગ તેના નગરો સહિત. ");
INSERT INTO guj2009_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","અને ગિલયાદનો બાકીનો પ્રદેશ, બાશાનનો સમગ્ર પ્રદેશ, ઓગનું રાજ્ય, એટલે કે આગોર્બનો સમગ્ર પ્રદેશ મેં મનાશ્શાના અડધા વંશને આપ્યો.” (જ્રબાશાનનો સમગ્ર પ્રદેશ રફાઈઓનો દેશ કહેવાય છે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","મનાશ્શાના વંશજ યાઈરે ગશૂરીઓ અને માંઅખાથીઓની સરહદ સુધીનો સમગ્ર આગોર્બનો એટલે કે બાશાનનો પ્રદેશ કબજે કર્યો, અને પોતાના નામ ઉપરથી ત્યાંનાં ગામડાઓનું નામ “યાઈરના ગામડાઓ” પાડયું. આજે પણ તે પ્રદેશ એ નામથી જ ઓળખાય છે.) ");
INSERT INTO guj2009_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“મે માંખીરના વંશજોને ગિલયાદ આપ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","અને રૂબેનના અને ગાદના વંશજોને મેં ગિલયાદથી માંડીને આનોર્નના કોતર સુધીનો પ્રદેશ આપ્યો હતો. કોતરનો મધ્ય ભાગ તે તેની દક્ષિણ સરહદ હતી અને આમ્મોનીઓની સરહદે આવેલી યાબ્બોક નદીએ એની ઉત્તર સરહદ હતી. ");
INSERT INTO guj2009_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","પશ્ચિમમાં તેમની જમીન યર્દન નદી સુધી વિસ્તરેલી હતી. ઉત્તરમાં કિન્નેરેથના સરોવરથી દક્ષિણમાં અરાબાનાહ સમુદ્ર સુધી એટલે કે ખારા સમુદ્ર સુધી, અને પૂર્વમાં પિસ્ગાહ પર્વતની તળેટીના ઢાળ સુધી તે પ્રદેશ વિસ્તરેલો હતો, જમીન ખેચાયેલી હતી. ");
INSERT INTO guj2009_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“એ વખતે મેં રૂબેન અને ગાદના કુળસમૂહોને અને મનાશ્શાના અર્ધકુળને આજ્ઞા કરી હતી કે; ‘તમાંરા દેવ યહોવાએ આ ભૂમિ તમાંરા કબજામાં સોંપી છે. દેવે તમને તમાંરો ભાગ આપ્યો છે. તમાંરા બધા યોદ્ધાઓએ હથિયાર ધારણ કરીને ઇસ્રાએલના બીજા કુળસમૂહોને દોરવીને યર્દન નદીને પેલે પારના પ્રદેશ તરફ આગળ વધવું જે પ્રદેશ દેવે તેમને આપવાનું વચન આપ્યું હતું. ");
INSERT INTO guj2009_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","મેં તેઓને એ પણ કહ્યું હતું કે, મેં તમને જે નગરો આપ્યા છે તેમાં તમાંરી સ્ત્રીઓ અને બાળકો તથા પશુઓ પાછળ જ રહે. મને ખબર છે તમાંરી પાસે ઘણા ઢોર છે અને સ્ત્રીઓ તેની સંભાળ રાખે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","યર્દનને પેલે પાર તમાંરા દેવ યહોવાએ તેમને આપેલી ભૂમિનો કબજો તેઓ પ્રાપ્ત કરે અને જેમ તેમને પણ યહોવા સ્થાયી થવા દે ત્યાં સુધી તમાંરે એમને સાથ આપવાનો છે. ત્યાર પછી તમાંરે મેં તમને આપેલી ભૂમિમાં પાછા ફરવાનું છે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“ત્યારબાદ મેં યહોશુઆને એવો આદેશ આપ્યો કે, ‘યહોવાએ આ બે રાજાઓના જે હાલ કર્યા તે, તેં તારી સગી આંખે જોયા છે, અને તું જે પ્રદેશમાં જાય છે ત્યાંના રાજાઓના પણ એવા જ હાલ કરશે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ત્યાં રહેતી પ્રજાઓથી તું જરાય ગભરાઈશ નહિ, કારણ કે તમાંરા દેવ યહોવા તમાંરા પક્ષે લડશે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“તે સમયે મેં દેવને આગ્રહપૂર્વક અરજ કરી; ");
INSERT INTO guj2009_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘હે યહોવા દેવ, તમે અમાંરી મધ્યે તમાંરી મહાનતા તથા સાર્મથ્ય પ્રગટ કરો છો તેનું પરિણામ જોવાની માંરી ઇચ્છા છે; આકાશમાં કે પૃથ્વી પર એવો કોઈ દેવ નથી જે તમે અમાંરા માંટે કરેલાં કાર્યોની સરસાઇ કરી શકે. ");
INSERT INTO guj2009_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","હે યહોવા, મને કૃપા કરીને યર્દન નદી ઓળંગીને સામે કિનારે આવેલી સમૃદ્વ ભૂમિ, પેલો રમણીય પર્વતીય પ્રદેશ તથા લબાનોનમાં જવા દો.’ ");
INSERT INTO guj2009_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“પરંતુ તમાંરા કારણે યહોવા માંરા પર રોષે ભરાયા હતા અને માંરી અરજ સાંભળી નહોતી; તેમણે મને કહ્યું, ‘બસ, હવે એ વિષે ફરી વાત કરીશ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","પરંતુ પિસ્ગાહ પર્વતની ટોચે જઈને પશ્ચિમમાં, ઉત્તરમાં, દક્ષિણમાં અને પૂર્વમાં નજર કર, ધ્યાનપૂર્વક જોજે, કારણ કે, તું આ યર્દન નદી ઓળંગીને સામે પાર જવાનો નથી. ");
INSERT INTO guj2009_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","તું તારું સ્થાન લેવા માંટે યહોશુઆને આદેશ આપજે, તેને હિંમત આપજે, બળ આપજે, કારણ કે, પર્વતની ટોચ પરથી તું જે દેશ જોશે તેને જીતવા માંટે, લોકોને માંટે તે પેલે પાર આગળ લઈ જશે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“એ પ્રમાંણે આપણે બેથ-પેઓરની સામેની ખીણમાં મુકામ કર્યો.” ");
INSERT INTO guj2009_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","મૂસાએ લોકોને જણાવ્યું, “હે ઇસ્રાએલી પ્રજાજનો, હું તમને જે કાયદાઓ અને નિયમો શીખવું છું તે ધ્યાનથી સાંભળો અને તેનું પાલન કરો; તો તમે જીવતા રહી શકશો અને તમાંરા પિતૃઓના દેવ યહોવા જે ભૂમિ તમને આપી રહ્યા છે, તેમાં પ્રવેશ કરી શકશો અને તેનો કબજો પણ તમને મળશે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","હું તમને જે આજ્ઞા કરું છું તેમાં તમાંરે કશો વધારો કે ઘટાડો કરવો નહિ. હું તમને તમાંરા દેવ યહોવાની જે આજ્ઞાઓ જણાવું તેનું જ તમાંરે પાલન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“બઆલ-પેઓરમાં યહોવાએ જે કંઈ કર્યુ તે તમે પ્રત્યક્ષ જોયું છે. તમાંરા દેવ યહોવાએ તમાંરામાંથી જે કોઈ બઆલ દેવની પૂજા કરવા લાગ્યા હતા તે બધાનો સંહાર કર્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","પરંતુ તમે કે જેઓ તમાંરા દેવ યહોવાને દૃઢતાથી વફાદાર રહ્યા તે આજે જીવતા રહ્યા છો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“યહોવા માંરા દેવે મને આજ્ઞા કરી તે મુજબ મેં તમને કાનૂનો અને નિયમો શીખવ્યા છે, જયારે તમે તે પ્રદેશમાં પ્રવેશ કરો અને તેનો કબજો લો, ત્યારે તમાંરે સૌએ એ કાનૂનો અને નિયમોનું પાલન કરવું. ");
INSERT INTO guj2009_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","અને જો તમે તેનું કાળજીપૂર્વક પાલન કરશો તો તમે સચેત અને જ્ઞાની રાષ્ટ થશો, અને આજુબાજુના રાષ્ટો આ કાનૂનો વિષે સાંભળશે ત્યારે તેઓ કહેશે, ‘આ મહાન રાષ્ટને કેવી દક્ષતા અને સમજદારી છે!’ ");
INSERT INTO guj2009_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“આપણે જેમ આપણા દેવ યહોવાને જયારે પોકારીએ છીએ ત્યારે તે આપણી સાથે જ હોય છે. એવો દેવ સાથેનો નિકટનો સંબંધ બીજી કંઈ મોટી કે નાની પ્રજાને છે? ");
INSERT INTO guj2009_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","બીજી કઈ પ્રજા એવી મહાન છે કે જેના કાયદા અને નિયમો આજે હું તમાંરી આગળ રજૂ કરું છું એ સમગ્ર આચારસંહિતા જેવા ન્યાયી હોય? ");
INSERT INTO guj2009_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","પણ ધ્યાન રાખીને સાવધ રહેજો, તમે તમાંરી સગી અાંખે જે જોયું છે તે ભૂલી જશો નહિ, અને મૃત્યુ પામો ત્યાં સુધી તેને તમાંરા મનમાંથી દૂર કરશો નહિ, પરંતુ તમાંરા સંતાનોને અને તેમનાં સંતાનોને એ શીખવજો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","એ દિવસને તમે કદાપિ ભૂલશો નહિ, જે દિવસે તમે હોરેબમાં તમાંરા દેવ યહોવા સંમુખ ઊભા હતા, અને યહોવાએ મને કહ્યું હતું કે, ‘લોકોને માંરી સમક્ષતામાં ભેગા કર. હું તે બધાને માંરાં વચનો સંભળાવીશ અને તેઓ પૃથ્વી પર જીવશે ત્યાં સુધી માંરાથી ડરીને ચાલતાં શીખશે અને પોતાનાં સંતાનોને પણ તેમ કરતાં શીખવશે.’ ");
INSERT INTO guj2009_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","તેથી તમે નજીક આવીને પર્વતની તળેટી આગળ ઊભા રહ્યા હતા. પર્વત અગ્નિથી ભડભડતો હતો અને જવાળાઓ આકાશ સુધી પહોંચતી હતી. સર્વત્ર અંધકાર, વાદળ અને ગાઢ ઘુમ્મસ છવાયેલાં હતાં, ");
INSERT INTO guj2009_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ત્યારે યહોવા તમાંરા દેવ અગ્નિમાંથી તમાંરી સાથે બોલ્યો. તેણે જે કહ્યું તમે સાંભળ્યું, પણ તમે તેમની આકૃતિ જોઈ નહિ તમે ફકત અવાજ સાંભળ્યો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","તેમણે તમને પોતાના કરારના દશ નિયમોનું પાલન કરવાનું કહ્યું. અને તે તેમણે પથ્થરની બે તકતીઓ પર લખ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","તે જ સમયે યહોવાએ તમે જે ભૂમિમાં પ્રવેશ કરીને કબજો લેવાના છો તે ભૂમિમાં તમાંરે એ જ કાયદાઓ અને નિયમો પાળવાના છે, તે તમને શિખવવાની મને આજ્ઞા કરી. ");
INSERT INTO guj2009_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“સાવધાન રહેજો. જે દિવસે તમે હોરેબમાં યહોવાને અગ્નિમાંથી તમાંરી સાથે બોલતા સાંભળ્યા તે દિવસે તમે દેવની કોઈ આકૃતિ જોઈ નહોતી, ");
INSERT INTO guj2009_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","તેથી દેવની મૂર્તિ બનાવીને પાપ કરશો નહિ, પુરુષ અથવા સ્ત્રી જેવી દેખાય તેવી મૂર્તિ બનાવશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","પૃથ્વી પર ચાલનારા કોઈ પ્રાણીની કે આકાશમાં ઊડતા પંખીની, ");
INSERT INTO guj2009_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","પૃથ્વી તળેના પાણીમાંની માંછલીની મૂર્તિ કે આકૃતિ બનાવી ભ્રષ્ટ થશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","તમે, આકાશ તરફ નજર કરો ત્યારે સૂર્ય, ચંદ્ર કે તારાઓની સેવાપૂજા કરશો નહિ. તમાંરા દેવ યહોવાએ એમને તો પૃથ્વી પર વસતા બધાં લોકોના લાભ માંટે આપેલા છે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","પરંતુ તમને તો યહોવા મિસરની ભડભડતી ભઠ્ઠીમાંથી બહાર લઈ આવ્યો હતો, જેથી તમે એની પોતાની પ્રજા બની રહો અને તેમનો પોતાનો વારસો બનો, જેમ તમે આજે છો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“પરંતુ તમાંરે કારણે યહોવા માંરા પર રોષે ભરાયા હતા અને તેમણે સમ પૂર્વક જણાવ્યું હતું કે, “તું યર્દન નદી ઓળંગી હું જે સમૃદ્વ ભૂમિનો કબજો તમાંરા લોકોને સોંપી રહ્યો છું તેમાં પ્રવેશ પામશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","હું યર્દન નદી ઓળંગી શકવાનો નથી. માંરે નદીની આ બાજુના દેશમાં જ મરવાનું છે. પણ તમે યર્દન ઓળંગીને તે સમૃદ્વ ભૂમિનો કબજો પ્રાપ્ત કરશો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","પણ સાવધાન! તમાંરા દેવ યહોવાએ તમાંરી સાથે જે કરાર કર્યો છે, તેને ભૂલશો નહિ, તમાંરા દેવ યહોવાએ જેની સ્પષ્ટ મનાઈ કરી છે એવી કોઈ પણ મૂર્તિ બનાવશો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","દેવ તો ભસ્મ કરી નાખનાર અગ્નિરૂપ છે. એ તો સંપૂર્ણ નિષ્ઠા માંગનાર દેવ છે, તે મૂર્તિ પૂજા સહન નહિ કરે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“ભવિષ્યમાં તમને સંતાનો અને સંતાનોનાં પણ સંતાનો થાય અને તમે બધાં તે દેશમાં સ્થાયી થશો, તમે જો મૂર્તિઓ બનાવીને પાપ કરશો તો તમાંરા દેવ યહોવા તમાંરા પાપને કારણે અતિ ક્રોધિત થશે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","અને હું આકાશ તથા પૃથ્વીની સાક્ષીએ તમને કહું છું કે, તમે યર્દન ઓળંગ્યા પછી જે ભૂમિનો કબજો લેવાના છો તેમાંથી તમે થોડા જ સમયમાં સમાંપ્ત થઈ જશો. ત્યાં તમે લાંબો સમય નહિ રહો અને તમાંરો નાશ થશે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","યહોવા તમને અન્ય પ્રજાઓમાં વેરવિખેર કરી નાખશે અને તમને જે લોકોમાં તે દોરી જશે તેમની વચ્ચે તમે બહુ થોડા જ બાકી રહેશો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","તમે ત્યાં લાકડાની અને પથ્થરની બનાવેલી મૂર્તિઓ કે જે જોઈ શકતી નથી કે સાંભળી શકતી નથી અને ખાતી નથી કે સૂંઘતી પણ નથી, ને શ્વાસ પણ નથી લેતી, તેની સેવા પૂજા કરશો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","જો તમે યહોવા તમાંરા દેવ માંટે આ બીજી ભૂમિઓમાં શોધખોળ કરશો તો તમને તે મળી જશે. પણ તમાંરે શોધ પૂર્ણ હૃદય પૂર્વક કરવી પડશે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","તો પાછલા દિવસોમાં જયારે આફતમાં આવી પડશો અને તમને આ બધું વીતશે ત્યારે તમે ફરી તમાંરા દેવ યહોવા તરફ વળશો અને તેમની આજ્ઞા મસ્તક પર ઘારણ કરશો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","તમાંરા દેવ યહોવા દયાળુ છે; તે તમાંરો ત્યાગ કરશે નહિ કે, તમાંરો નાશ પણ કરશે નહિ કે, તમાંરા પૂર્વજોને આપેલાં વચનો પણ ભૂલશે નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“દેવે પૃથ્વી પર માંનવીનું સર્જન કર્યું ત્યારથી માંડીને આજ સુધીના ઇતિહાસના પૃષ્ઠો તપાસી જાઓ, આકાશના એક છેડાથી બીજા છેડા સુધી ફરી વળો અને પૂછો કે, પહેલાં કદી આ પ્રમાંણેની અદૃભૂત ઘટના બનેલી જોઈ છે કે સાંભળી છે? ");
INSERT INTO guj2009_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","તમે લોકોએ જેમ દેવને અગ્નિમાંથી બોલતા સાંભળ્યા છે તેમ અન્ય કોઈ પ્રજાએ સાંભળ્યા છે ખરા? અને છતાં પણ તે જીવતી રહી છે? ");
INSERT INTO guj2009_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","અથવા તમાંરા દેવ યહોવાની જેમ કોઈએ એક પ્રજાને બીજી પ્રજા પાસેથી પોતાને માંટે લઈ લેવાની હિંમત કરી છે? તેમણે તો મિસરમાં તમાંરે માંટે તમાંરા દેખતાં, પોતાના પ્રચંડ બાહુબળના ચમત્કારો બતાવીને ભયંકર આફતોનો વરસાદ વરસાવ્યો હતો. યુદ્ધો, ચમત્કારો, પરાક્રમો અને ભયાનક કૃત્યો કર્યા હતાં. ");
INSERT INTO guj2009_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","આ તમાંમ તેમણે એટલા માંટે કર્યુ કે પોતે જ દેવ છે, બીજું કોઈ નથી, એની ખાતરી તમને કરાવી શકાય. ");
INSERT INTO guj2009_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","તમને ઉપદેશ મળે એ માંટે યહોવાએ આકાશમાંથી તેમની બોધ આપતી વાણી સંભળાવી. અને તમને પૃથ્વી પર પોતાના મહાઅગ્નિનાં દર્શન કરાવ્યાં. અને એ જ અગ્નિમાંથી તમે તેમનાં વચનો સાંભળ્યાં ");
INSERT INTO guj2009_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","“યહોવા તમાંરા પૂર્વજો પર પ્રેમ રાખતા હતા. અને તેઓના વંશજોને આશીર્વાદ આપવા માંટે તેમણે પસંદ કર્યા હતા. એટલે એ જાતે જ તમને પ્રચંડ બાહુબળથી મિસરમાંથી બહાર લઈ આવ્યા. ");
INSERT INTO guj2009_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","તમાંરા કરતા મોટા અને શકિતશાળી રાષ્ટોને તેમણે હાંકી કાઢી અને તેઓના દેશો તમને સોંપ્યા, જેમ આજે છે તેમ. ");
INSERT INTO guj2009_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“એટલે તમે ચોક્કસ રીતે મનમાં રાખો કે યહોવા જ દેવ છે, અને બીજા કોઇ દેવ નથી. તે આકાશમાં અને પૃથ્વી ઉપર દેવ છે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","આજે હું તમને જે કાનૂનો અને નિયમો આપું છું તેનું તમે પાલન કરજો, જેથી તમાંરું અને તમાંરાં સંતાનોનું ભલું થાય અને તમાંરા યહોવા દેવ જે ભૂમિ તમને આપે છે તેમાં તમે દીર્ધકાળ વસો અને દીર્ધાયુ ભોગવો.” ");
INSERT INTO guj2009_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ત્યાર બાદ મૂસાએ ઇસ્રાએલી લોકોને યર્દન નદીની પૂર્વમાં ત્રણ નગરોમાં અલગ કાઢયાં. ");
INSERT INTO guj2009_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","જયાં કોઈ માંણસે અગાઉના કોઈ પણ વેરઝેર વગર અજાણતાં કોઈ વ્યકિતનું ખૂન કર્યુ હોય, તો તે ત્યાં આશ્રય લઈ શકે. એવો માંણસ જો આ નગરમાંના કોઈનું શરણું લે તો તેનો જીવનો બચાવ થાય. ");
INSERT INTO guj2009_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","એ ત્રણ નગરો આ પ્રમાંણે હતા: રૂબેનીઓના વંશજોને માંટે રણના સપાટ પ્રદેશમાં આવેલું “બેસેર” ગાદના વંશજો માંટે ગિલયાદમાં આવેલું રામોથ અને મનાશ્શાના વંશજો માંટે બાશાનમાં આવેલું ગોલાન. ");
INSERT INTO guj2009_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ઇસ્રાએલી પ્રજાને મૂસાએ દેવની નિયમસંહિતા આપી. ");
INSERT INTO guj2009_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","તેઓ મિસરમાંથી નીકળ્યા ત્યારે મૂસાએ તે લોકોને આ નિયમો આપ્યા હતા. ");
INSERT INTO guj2009_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","યર્દન નદીની પૂર્વમાં બેથ-પેઓર નગર પાસે મૂસાએ આ વચનો કહી સંભળાવ્યાં. અગાઉ આ દેશ અમોરીઓના રાજા સીહોનના કબજામાં હતો, તેની રાજધાની હેશ્બોન હતી. મૂસા તથા ઇસ્રાએલીઓએ મિસરમાંથી આવતાં એ રાજાને હરાવ્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","અને તેના પ્રદેશનો તેમ જ બાશાનના રાજા ઓગના પ્રદેશનો એમ યર્દનના પૂર્વકાંઠે આવેલા બે અમોરી રાજાઓના પ્રદેશનો કબજો લીધો હતો. ");
INSERT INTO guj2009_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","આમ ઇસ્રાએલે આનોર્નની ખીણની સરહદે આવેલા અરોએરથી તે સિયોન પર્વત જે હેમોર્ન પર્વત તરીકે પણ ઓળખાય છે. ");
INSERT INTO guj2009_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","અને યર્દન નદીની પૂર્વે આવેલો સમગ્ર અરાબાહનો પ્રદેશ તેમજ પિસ્ગાહ પર્વતના ઢોળાવ નીચે આવેલો મૃત સમુદ્ર અરાબાહ સુધીનો પ્રદેશ કબજે કરી લીધો. ");
INSERT INTO guj2009_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","બધા ઇસ્રાએલી લોકોને બોલાવીને મૂસાએ તેઓને કહ્યું, “હે ઇસ્રાએલીઓ, આજે હું તમને જે કાયદાઓ અને નિયમો સંભળાવું છું તે ધ્યાનથી સાંભળો અને એ શીખી લો અને ચોક્કસ એનું પાલન કરો. ");
INSERT INTO guj2009_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","આપણા દેવ યહોવાએ આપણી સાથે હોરેબમાં કરાર કર્યો હતો. ");
INSERT INTO guj2009_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","એ કરાર યહોવાએ આપણા પિતૃઓ સાથે નહિ પણ આપણી સાથે કર્યો હતો, જેઓ આજે અહીં જીવતા રહ્યા છે. ");
INSERT INTO guj2009_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","યહોવા તમાંરી સાથે ત્યાં પર્વત પર અગ્નિમાંથી પ્રત્યક્ષ બોલ્યા હતા, ");
INSERT INTO guj2009_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","તે સમયે યહોવાના શબ્દો તમને સંભળાવવા હું મધ્યસ્થ તરીકે ઊભો હતો, કારણ કે, તમને અગ્નિનો ભય લાગતો હતો અને તમે પર્વત પર તેમની પાસે ગયા ન્હોતા. અને મેં તમને તે કહી સંભળાવ્યા હતા. તેમણે કહ્યું હતું: ");
INSERT INTO guj2009_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘ગુલામીના દેશ મિસરમાંથી તમને મુકત કરી બહાર લાવનાર હું જ તમાંરો દેવ છું. ");
INSERT INTO guj2009_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","‘માંરા સિવાય તમાંરે કોઈ પણ અન્ય દેવની ઉપાસના કરવી જોઈએ નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","‘ઉપર આકાશમાં કે નીચે પૃથ્વી પર કે પૃથ્વી નીચેના જળમાં વસનાર પશુ, પક્ષી કે જળચર પ્રાણીની મૂર્તિ તમાંરે બનાવવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","અને તમાંરે તેને નમસ્કાર કરીને તેમની પૂજા કરવી નહિ. કારણ કે, હું તમાંરો દેવ યહોવા અનન્ય નિષ્ઠાની અપેક્ષા રાખનાર દેવ છું. જે માંરો તિરસ્કાર કરે છે, તેમનાં સંતાનોને હું ત્રીજી તથા ચોથી પેઢી સુધી તેમનાં પાપોની શિક્ષા કરું છું. ");
INSERT INTO guj2009_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","પરંતુ જે લોકો માંરા પર પ્રેમભાવ રાખે છે અને માંરી આજ્ઞાઓનું પાલન કરે છે, તેઓની હજારો પેઢી સુધી હું તેમના પર કૃપા કરું છું. ");
INSERT INTO guj2009_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","‘તમાંરી ઇચ્છા તમે લીધેલી પ્રતિજ્ઞા પૂર્ણ કરવાની ના હોય તો તમાંરે તમાંરા દેવનું યહોવાનું નામ નકામું ના લેવું. જે કોઈ યહોવાનું નામ નકામું લે છે તેને તે શિક્ષા કર્યા વગર રહેતો નથી. ");
INSERT INTO guj2009_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","‘તમાંરા દેવ યહોવાની આજ્ઞા મુજબ વિશ્રામવારને પવિત્ર રાખજો. ");
INSERT INTO guj2009_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","બાકીના છ દિવસો તમાંરે તમાંરા રોજના બધા કામકાજ કરવાં. ");
INSERT INTO guj2009_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","પરંતુ સાતમો દિવસ તો વિશ્રામવાર છે, તમાંરા દેવ યહોવાનો દિવસ છે. તે દિવસે તમાંરે કોઈ પણ પ્રકારનું કામ કરવું નહિ, તમાંરે કે તમાંરા પુત્રો કે તમાંરી પુત્રીઓએ, તમાંરા દાસ કે તમાંરી દાસીએ, તમાંરા બળદોએ કે ગધેડાઓએ કે પછી બીજા કોઈ પશુએ, તેમજ તમાંરા ગામોમાં વસતા કોઈ પણ વિદેશીએ પણ કામ ન કરવું, જેથી તમાંરા દાસ–દાસીઓ પણ તમાંરી જેમ આરામ કરે. ");
INSERT INTO guj2009_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","તમાંરે વિશ્રામ દિવસનું પાલન કરવાનું છે. યહોવા તમને આ આજ્ઞા આપે છે કે જેથી તમે યાદ રાખો કે તમે મિસરમાં ગુલામો હતાં, અને યહોવા તમાંરા દેવે તેની મહાન હાથ વડે તમને ગુલામીમાંથી મુકત કર્યા અને તમને મિસરમાંથી બહાર લાવ્યાં. ");
INSERT INTO guj2009_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","‘યહોવાની આજ્ઞા પ્રમાંણે તમાંરે તમાંરા માંતા અને પિતાનો આદર કરવો, કે જેથી યહોવા તમાંરા દેવ તમને જે ભૂમિ આપી રહ્યાં છે તેમાં તમે લાંબા સમય માંટે સારુ જીવો. ");
INSERT INTO guj2009_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","‘તારે હત્યા કરવી નહિ, ");
INSERT INTO guj2009_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","‘તારે વ્યભિચાર કરવો નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","‘તારે ચોરી કરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","‘તારે બીજા લોકો વિરુદ્ધ ખોટી સાક્ષી પૂરવી નહિ. ");
INSERT INTO guj2009_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","‘તમાંરા પડોશીની પત્નીની કામના કરવી નહિ, તેમ તેના ઘર કે ખેતર, દાસ કે દાસી, પશુ, ગધેડાં કે અન્ય કોઈ પણ વસ્તુનો કબજો કરવાની ઇચ્છા કરવી નહિ.’” ");
INSERT INTO guj2009_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“આ દશ આજ્ઞાઓ તમાંરા સમગ્ર સમુદાયને યહોવાએ તે પર્વત ઉપર અગ્નિ તથા ગાઢ વાદળમાંથી મોટા સાદે સંભળાવી હતી. એ પછી તે કશું બોલ્યા ન્હોતા અને તેમણે એ આજ્ઞાઓ મને પથ્થરની બે તકતીઓ ઉપર લખીને આપી હતી. ");
INSERT INTO guj2009_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“પર્વત જયારે અગ્નિથી ભડભડ બળતો હતો, ત્યારે તમે અંધકારમાંથી એ અવાજ સાંભળ્યો, પછી તમાંરા કુળસમૂહોના બધાં આગેવાનો અને વડીલો માંરી પાસે આવ્યાં અને વિનંતી કરી, ");
INSERT INTO guj2009_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","‘આપણા દેવ યહોવાએ અમને પોતાના ગૌરવ અને માંહાત્મ્ય દર્શન કરાવ્યાં છે, અને અમે અગ્નિમાંથી તેમનો અવાજ સાંભળ્યો છે; આજે અમે જોયું અને જાણ્યું છે કે દેવ માંણસ સાથે બોલે છતાં માંણસ જીવતો રહે છે. ");
INSERT INTO guj2009_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","પરંતુ અમાંરે મોતનું જોખમ ફરી શા માંટે લેવું? આ મહાભયંકર અગ્નિ તો અમને સૌને ભસ્મીભૂત કરી નાખશે. જો અમે ફરી વાર અમાંરા દેવ યહોવાનો અવાજ સાંભળીશું તો અમે જરૂર મૃત્યુ પામીશું. ");
INSERT INTO guj2009_vpl VALUES ("DT5_26