﻿USE sofia;
DROP TABLE IF EXISTS sofia.guiNT_vpl;
CREATE TABLE guiNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guiNT_vpl WRITE;
INSERT INTO guiNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tamombeu cuae tupapire pe Jesucristo itenondegua reta. Jesucristo co jae David iñemoña reta pegua. Jae ramiño vi jae co Abraham iñemoña reta pegua. ");
INSERT INTO guiNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham iñemoña Isaac, jare Isaac iñemoña Jacob, jare Jacob iñemoña reta Judá jare tɨqueɨ reta jare tɨvɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jare Judá omoñemoña Tamar güi Fares jare Zara. Jare Fares iñemoña Esrom, jare Esrom iñemoña Aram. ");
INSERT INTO guiNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jare Aram iñemoña Aminadab, jare Aminadab iñemoña Naasón, jare Naasón iñemoña Salmón. ");
INSERT INTO guiNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jare Salmón omoñemoña Rahab güi Booz. Jare Booz omoñemoña Rut güi Obed. Jare Obed iñemoña Isaí. ");
INSERT INTO guiNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jare Isaí iñemoña David. Jae co Israel pegua reta juvicha guasu. Jare mburuvicha guasu David omoñemoña Urías jembirecogüe güi Salomón. ");
INSERT INTO guiNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jare Salomón iñemoña Roboam, jare Roboam iñemoña Abías, jare Abías iñemoña Asa. ");
INSERT INTO guiNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jare Asa iñemoña Josafat, jare Josafat iñemoña Joram, jare Joram iñemoña Uzías. ");
INSERT INTO guiNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jare Uzías iñemoña Jotam, jare Jotam iñemoña Acaz, jare Acaz iñemoña Ezequías. ");
INSERT INTO guiNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jare Ezequías iñemoña Manasés, jare Manasés iñemoña Amón, jare Amón iñemoña Josías. ");
INSERT INTO guiNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jare Josías iñemoña reta Jeconías jare tɨvɨ reta. Jare Jeconías oico yave, ɨvɨ Babilonia pegua reta omoamɨri Israel pegua reta jare güɨraja jeta Israel pegua reta Babilonia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jare yogüɨraja ma Babilonia pe yave, Jeconías iñemoña Salatiel, jare Salatiel iñemoña Zorobabel. ");
INSERT INTO guiNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jare Zorobabel iñemoña Abiud, jare Abiud iñemoña Eliaquim, jare Eliaquim iñemoña Azor. ");
INSERT INTO guiNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jare Azor iñemoña Sadoc, jare Sadoc iñemoña Aquim, jare Aquim iñemoña Eliud. ");
INSERT INTO guiNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jare Eliud iñemoña Eleazar, jare Eleazar iñemoña Matán, jare Matán iñemoña Jacob. ");
INSERT INTO guiNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jare Jacob iñemoña José - jae co María ime. Jare María imembɨ Jesús - jae co Cristo jee vae. ");
INSERT INTO guiNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jae rambue yaipapa catorce ñemoña Abraham güi David pe. Jae ramiño vi yaipapa catorce ñemoña David güi Jeconías pe. Echa Jeconías oico yave, Israel pegua reta oyererajauca Babilonia pe. Jae ramiño vi yaipapa catorce ñemoña Jeconías güi Cristo pe. ");
INSERT INTO guiNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Añave tamombeu quirai Jesucristo oa ichɨ güi. María José ndive omendata yave, ndei José güɨreco mbove, oyecuaa ipurúa oi. Ipurúa co Espíritu Santo imbaepuere pe. ");
INSERT INTO guiNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jayave José oñemongueta jei vaera chupe ngaraa omenda jae ndive, erei mbaeti oipota oyapo opaete tenta pegua reta jovaque. Echa José metei cuimbae jupi vae co jare mbaeti oipota omomarai María opaete tenta pegua reta jovaque. ");
INSERT INTO guiNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Erei cuae re oñemongueta oi rambueve, metei araɨgua ñandeYa pe oyeócuai vae oyecuaa chupe ipaɨu pe jare jei chupe: —José. Nde co jae David iñemoña reta pegua. Ndepuere remenda María ndive requɨye mbae reve. Echa ipurúa oi Espíritu Santo imbaepuere pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jare imembɨta metei cuimbae jare rembojeeta Jesús. Echa jae omboasata jenta pegua reta. Echa omboaita imbaeyoa reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jare opaete cuae oyeapo, Tumpa iñee aracae omombeu vae rupi ñandeYa jeigüe vae oyeapo vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Echa jei corai: Mase, metei cuñatai cuimbae mbaeti etei güɨreco vae ipuruata jare imembɨta metei cuimbae. Jare ombojee retata Emanuel. Jocorai jei. Cuae tee oipota jei: Tumpa oime ñande ndive oi. ");
INSERT INTO guiNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jayave José oicove ye jare omenda María ndive araɨgua ñandeYa pe oyeócuai vae jei chupe rami. ");
INSERT INTO guiNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Erei José mbaeti mbae oyapo María pe ndei imembɨrɨpɨ oa mbove. Jare María imembɨ oa ma yave, José ombojee Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús oa ma yave tenta Belén ɨvɨ Judea pegua pe, Herodes oico mburuvicha guasura. Jare jocuae ara reta pe yogüeru cuimbae yasɨtata reta re oñemboe vae reta cuaraɨ oea cotɨ güi ovae tenta Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jare jei reta: —¿Quiape pa oime oi michia judío reta juvicha guasura oicota vae? Echa roecha yasɨtata oicuauca oreve vae cuaraɨ oea cotɨ. Jae rambue royu ma rovae romboete vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mburuvicha guasu Herodes cuae oendu yave, oquɨye. Opaete Jerusalén pegua reta vi oquɨye. ");
INSERT INTO guiNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jayave Herodes omboatɨuca opaete sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta, jare oparandu chupe reta quiape ra oata Cristo. ");
INSERT INTO guiNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jare jae reta jei chupe: —Oata Belén Judea pegua pe. Echa Tumpa iñee aracae omombeu vae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén Judea pegua metei tenta Judea pegua icavi yae vae. Echa joco pe oata metei mburuvichara. Jae oyocuaita Israel pegua reta. Israel pegua reta chembae reta co. Jocorai jei —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jayave Herodes oeniuca vɨari jocuae yasɨtata reta re oñemboe vae reta, jare oparandu chupe reta quirai yave ra oyecuaa jocuae yasɨtata. ");
INSERT INTO guiNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jayave Herodes jei chupe reta: —Pecua Belén pe peeca cavi jocuae michia. Jare pevae ma yave, peyu ye cuae pe pemombeu cheve, che vi aja vaera amboete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Oendu reta ma yave mburuvicha guasu jei vae, cuimbae reta yogüɨraja Jerusalén güi. Jare oecha reta ye jocuae yasɨtata cuaraɨ oea cotɨ ñogüɨnoi yave oecha vae. Jare yasɨtata ojo jae reta jenonde opɨta michia oicoa iárambue. ");
INSERT INTO guiNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jocuae yasɨtata oecha reta yave, cuimbae reta oyerovia yae. ");
INSERT INTO guiNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jare oique reta yave michia oicoa pe, oecha reta michia ichɨ María ndive. Jayave jae reta oyeatɨca jare omboete michia. Jayave oipea ivoɨta reta jare omee michia pe mbota reta - oro jare mbae ipiche cavi vae reta incienso jare mirra jee vae. ");
INSERT INTO guiNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jare Tumpa omombeu cuimbae reta pe ipaɨu pe agüɨye vaera yogüɨraja ye Herodes jenta rupi. Jae rambue yogüɨraja ye iɨvɨ ae cotɨ ambué tape rupi. ");
INSERT INTO guiNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jare cuimbae reta yogüɨraja ma yave, metei araɨgua ñandeYa pe oyeócuai vae oyecuaa José pe ipaɨu pe jare jei chupe: —Epúa. Eraja michia jare ichɨ petecuarai Egipto pe. Pepɨta joco pe amombeu ye ndeve regua. Echa Herodes oecaucata michia oyucauca vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jayave José opúa, jare pɨtu reve güɨraja michia jare ichɨ ɨvɨ Egipto cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jare jae reta opɨta Egipto pe Herodes omano regua. Jocorai oyapo José, oyeapo vaera Tumpa iñee aracae omombeu vae rupi ñandeYa jeigüe vae. Echa jei corai: Egipto güi aruruca cheRaɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jayave Herodes oicuaa jocuae yasɨtata reta re oñemboe vae reta mbaeti co oyapo jeigüe. Jae rambue pochɨ yae jare omondo sundaro reta oyuca vaera opaete michia reta Belén pe jare Belén iyɨvɨri ñogüɨnoi vae ndei mócoi año güɨnoi vae. Echa yasɨtata reta re oñemboe vae reta opou Herodes pɨri yave, Herodes oparandu cavi chupe reta quirai yave ra oecha yasɨtata. ");
INSERT INTO guiNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jare jocorai oyeapo Tumpa iñee aracae omombeu vae Jeremías jeigüe vae. ");
INSERT INTO guiNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Echa jei corai: Ramá pe oñeendu ñee. Oñeendu oyaeo ñogüɨnoi ipɨatɨtɨ yae vae reta. Raquel oyaeo oi imembɨ reta re. Mbaeti etei quia ipuere ombopɨacatu imembɨ reta omano ma rambue. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erei Herodes omano ma yave, José Egipto pe oi rambueve, metei araɨgua ñandeYa pe oyeócuai vae oyecuaa José pe ipaɨu pe. ");
INSERT INTO guiNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jare jei chupe: —Epúa. Eraja michia jare ichɨ Israel pegua reta iɨvɨ pe. Echa oipota tei oyucauca michia vae reta omano ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jayave José opúa jare güɨraja michia jare ichɨ Israel pegua reta iɨvɨ cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Erei oendu quirai Arquelao oico mburuvicha guasura Judea pe. Echa Arquelao Herodes taɨ co. Jayave José oquɨye ojo vaera Judea pe. Erei Tumpa omombeu José pe ipaɨu pe ojo vaera ɨvɨ Galilea pe. Jae rambue jocotɨ ojo. ");
INSERT INTO guiNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jare José ojo ovae metei tenta Nazaret jee vae pe jare oico joco pe, oyeapo vaera Tumpa iñee aracae omombeu vae reta jeigüe vae. Echa jei reta corai: Iru vae reta ombojeeta metei Nazaret pegua. ");
INSERT INTO guiNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jocuae ara reta pe Juan ou ñuu Judea pe oi vae pe oporombobautiza jare omombeu Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jae jei: —Peeya peñemongueta icavi mbae vae pepɨa pe oi vae. Echa outa ma ovae mboroocuaia ara pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tumpa iñee aracae omombeu vae Isaías jee vae imiari Juan re. Echa Isaías jei corai: Jae iñeeata reve jeita ñuu pe: Peyapocavi ñandeYa japera. Pemosɨmbi tape. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jare Juan jemimonde maemɨmba camello jee vae jaagüe pegua co, jare icuacuaa co jae metei guasupi. Jare jou tucu reta jare ei ñana rupigua. ");
INSERT INTO guiNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jare opaete Jerusalén pegua reta jare Judea pegua reta jare opaete tenta ɨaca Jordán iyɨ́vɨri ñogüɨnoi vae pegua reta yogüɨraja Juan oia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jare Juan ombobautiza reta Jordán pe imbaeyoa reta opa omombeu güire. ");
INSERT INTO guiNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jare jeta fariseo reta jare saduceo reta yogüeru Juan oia pe, jae ombobautiza vaera. Jare Juan oecha reta yave, jei chupe reta: —Pe reta co jae mboi reta rami. ¿Quia pa omombeu peve peyerova vaera Tumpa cotɨ agüɨye vaera Tumpa pochɨ peve? ");
INSERT INTO guiNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Peyapo icavi vae, jocorai peicuauca vaera añetete peeya co peñemongueta icavi mbae vae pepɨa pe oi vae. ");
INSERT INTO guiNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Agüɨye pere peyeupe pepɨa pe: Ñanetenondegua co jae Abraham. Echa che jae peve cuae: Tumpa ipuere oyapo cuae ita reta güi Abraham iñemoña retara —jei Juan chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ñamojaanga metei ɨvɨra. Ɨvɨra ia mbaeti yave icavi, ɨvɨra iya oyasɨa jare oapɨ. Jae ramiño vi mbaeti yave peyapo icavi vae, Tumpa oiporaraucata peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Che pombobautiza ɨ pe peñemongueta icavi mbae vae pepɨa pe oi vae peeya yave. Erei cheraɨcue outa ipuere yae chegüi vae. Mbaeti jupi che avoɨ vaera ipɨapaa. Jae pembobautizata Espíritu Santo pe jare tata pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jae co trigo oarɨvo vae rami. Echa trigo oarɨvo vae omboveve trigo omboyao vaera trigo etei trigo ipire güi. Jayave oñovatu trigo etei jɨru pe. Erei oapɨ trigo ipire tata pe. Tata Cristo oiporuta vae opa mbae vae co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jare Jesús ou Galilea güi ovae Jordán pe Juan oia pe, Juan ombobautiza vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Erei Juan ñateɨ ombobautiza Jesús. Jae rambue jei chupe: —¿Maera pa reipota che rombobautiza vaera? Echa icavi co nde chembobautiza vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jayave Jesús jei chupe: —Icavi co nde chembobautiza vaera añave. Echa jocorai icavi co yayapo vaera opaete jupi vae —jei. Jayave Juan ombobautiza Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jare Juan ombobautiza ma yave, Jesús oe voi ɨ güi. Jare jupivei oecha ara oyepea oi, jare oecha vi Tumpa iEspíritu ogüeyɨ jese pɨcasu rami. ");
INSERT INTO guiNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jare jupivei oñeendu ñee ara güi jei: —Cuae co jae cheRaɨ. Aaɨu yae. Ayerovia yae jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jayave Espíritu Santo güɨraja Jesús ñuu pe. Jare joco pe aña guasu imiari Jesús pe oyapouca vaera tei mbaeyoa chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jare Jesús mbaeti mbae jou cuarenta ara. Jae rambue cuarenta ara oasa ma yave, ñɨmbɨaɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jayave aña guasu imiari Jesús pe oyapouca vaera tei mbaeyoa chupe. —Nde co jae Tumpa Taɨ yave, ere cuae ita reta pe oyeapo vaera mbɨyapera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Erei Jesús jei chupe: —Tumpa iñee pe oyecuatía oi corai: Icavi co ɨvɨ pegua reta jou vaera mbɨyape güɨnoi vaera tecove. Erei icavi yae co oyeapɨsaca vaera Tumpa iñee re jare oyapo vaera jeigüe güɨnoi vaera tecove opa mbae vae. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jayave aña guasu güɨraja Jesús Jerusalén pe - jae co tenta oñeñono tee Tumpa peguara vae - jare omboyeupi Tumpa jo iyapɨte re. ");
INSERT INTO guiNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jayave jei chupe: —Nde co jae Tumpa Taɨ yave, ea cuae güi. Echa Tumpa iñee pe oyecuatía oi corai: Tumpa oyocuaita araɨgua reta oñangareco vaera nderé. Ipo pe ndepɨɨ retata, agüɨye vaera ndepɨ rembopere ita re. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jayave Jesús jei chupe: —Tumpa iñee pe oyecuatía oi corai: Che co jae ndeYa Tumpa. Agüɨye mbae eyapo reicuaa vaera tuicha ra chepɨaguasu. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jayave aña guasu güɨraja Jesús metei ɨvɨtɨ ɨvate yae vae re jare oechauca chupe opaete mburuvicha guasu reta iporoocuaia ɨvɨ pe ñogüɨnoi vae reta opaete imaemboete reve. ");
INSERT INTO guiNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jayave aña guasu jei chupe: —Tamee ndeve opaete cuae, reyeatɨca yave chemboete vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jayave Jesús jei chupe: —Ecua chegüi, Satanás. Echa Tumpa iñee pe oyecuatía oi corai: Che co jae ndeYa Tumpa. Chemboete. Jaeño cheporoócuai eyapo. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jayave aña guasu ojo ye Jesús güi, jare jupivei yogüeru araɨgua reta oyeócuai Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jare Jesús oicuaa yave Juan oñemoingueuca ma co tembipɨɨrɨru pe, ojo Galilea pe. ");
INSERT INTO guiNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ojo Nazaret güi ovae tenta Capernaum pe jare joco pe oico, (Capernaum oi ɨ guasu jembeɨ pe Zabulón jare Neftalí iɨvɨ pe.) ");
INSERT INTO guiNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","oyeapo vaera Tumpa iñee aracae omombeu vae Isaías jeigüe vae. Echa jae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón iɨvɨ jare Neftalí iɨvɨ, ɨ guasu jembeɨ pe, Jordán jovaicho pe, Galilea judío mbae vae reta pegua. ");
INSERT INTO guiNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pɨtumimbi pe yogüɨreco vae reta oecha ma tembipe tuicha vae. Mano icuaraɨa pe yogüɨreco vae reta pe oyecuaa tembipe. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jayave Jesús omboɨpɨ omombeu Tumpa iñee. Jae jei: —Peeya peñemongueta icavi mbae vae pepɨa pe oi vae. Echa outa ovae mboroocuaia ara pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jare oguata rambueve Galilea pe ɨ guasu jembeɨ rupi, Jesús oecha Simón - jae co Pedro jee vae - jare Simón tɨvɨ Andrés jee vae. Jae reta omombo ñogüɨnoi ipɨsa ɨ guasu pe, jevae omboa vaera. Echa jae reta oyeporaca vae reta co. ");
INSERT INTO guiNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jare Jesús jei chupe reta: —Peyu cherupíe, jare che poapota cuimbae reta peru vaera cheve. ");
INSERT INTO guiNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jayave oeya reta voi ipɨsa, jare yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús oguata ye joco güi, jare oecha Zebedeo taɨ reta. Metei jee co Jacobo jare Jacobo tɨvɨ jee co Juan. Omboyoapɨ ñogüɨnoi ipɨsa osogüe reta chalana pe tu Zebedeo ndive. Jayave Jesús oeni. ");
INSERT INTO guiNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jayave jae reta oeya voi chalana jare tu, jare yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jare Jesús ojo opaete Galilea rupi, jare oporomboe judío reta itupao ñavo pe. Omombeu ñee icavi vae Tumpa iporoocuaia pegua, jare ombogüera imbaerasɨ vae reta oipotagüe mbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jare opaete ɨvɨ Siria pegua reta oendu Jesús oyapo vae regua. Jare iru vae reta güeru jae oia pe imbaerasɨ vae reta. Amogüe vae oiporara yae jasɨ, jare aña oya amogüe vae re, jare amogüe vae imboquere, jare amogüe vae mbaeti etei ipuere omɨi. Jayave Jesús ombogüera reta. ");
INSERT INTO guiNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jare yogüɨraja Jesús jaɨcue jeta yae vae Galilea güi, jare ɨvɨ Decápolis jee vae güi, jare Jerusalén güi, jare Judea güi, jare Jordán jovaicho güi. ");
INSERT INTO guiNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jare Jesús jeta yae vae oecha yave, oyeupi metei ɨvɨtɨ re. Joco pe oguapɨ oi, jare jemimboe reta yogüeru jae oia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jayave Jesús omboɨpɨ omboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jei chupe reta: —Toyerovia mbaeti etei oñemboete vae reta. Echa Tumpa omeeta chupe reta yogüɨreco vaera mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Toyerovia ipɨatɨtɨ vae reta. Echa Tumpa ombopɨacatu retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Toyerovia oñemomichi vae reta. Echa Tumpa omeeta chupe reta ɨvɨ imbaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Toyerovia iquɨreɨ yae jupi vae oyapo vae reta. Echa Tumpa ombojupi retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Toyerovia iru vae reta oiparareco vae reta. Echa Tumpa oiparareco retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Toyerovia ipɨa iquɨa mbae vae reta. Echa oecha retata Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Toyerovia iru vae reta ombopɨacatu vae reta. Echa oñembojee retata Tumpa taɨ reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Toyerovia jupi vae oyapo rambue iru vae reta icavi mbae vae oyapo chupe vae reta. Echa Tumpa omeeta chupe reta yogüɨreco vaera mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Iru vae reta jeita icavi mbae vae peve jare oyapota icavi mbae vae peve. Oipotagüe icavi mbae vae jeita pecotɨ yapu reve, pe reta cheraɨu rambue. Erei peyerovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Peyerovia yae. Echa Tumpa güɨnoi ara pe mbae icavi yae vae peveguara. Echa jae reta itenondegua reta oyapo cuae nunga icavi mbae vae Tumpa iñee aracae omombeu vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Pe reta co jae yuquɨ rami cuae ɨvɨ pe. Erei yuquɨ mbaeti ma yave jembochɨ, ¿quiraita ra jembochɨ ye? Mbaeti ma mbaera icavi. Icavi co ñamombo vaera jare ñapɨro jese vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Pe reta co jae metei mechero ɨvɨ pegua reta pe tembipe omee vae rami. Yayapo yave tenta metei ɨvɨtɨ re, mbaeti etei ñandepuere ñañomi. Opaete vae ipuere oecha —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jae ramiño vi mechero ñamoendɨ yave, mbaeti etei ñañono yapepo oñembovapɨ oi vae igüɨ pe. Ñañono co mechero jenda pe, opaete o pe ñogüɨnoi vae reta güɨnoi vaera tembipe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mechero omee ñandeve tembipe. Jae ramiño vi pe reta peico cavi iru vae reta jovaque, jae reta oicuaa vaera pe reta peyapo co icavi vae. Echa jocorai yave, omboete retata peRu ara pe oi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Güɨramoi peñemongueta che ayu co amboai vaera Moisés iporoócuai jare Tumpa iñee aracae omombeu vae reta jeigüe. Erei mbaeti jocorai. Che ayu ayapo vaera, mbaeti amboai vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Añete che jae peve, ara jare ɨvɨ oasa regua ngaraa oñemboai metei cuatía michi yae vae yepe Moisés iporoócuai güi ndei opaete oyeapo mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oime yave quia metei mboroócuai michi vae mbaeti oyapo jare omombeu iru vae reta pe agüɨye vaera oyapo vae, iru vae reta jeita jae co taɨcuegua vae mboroocuaia ara pegua pe. Erei oime yave quia oyapo jare omombeu iru vae reta pe oyapo vaera vae, iru vae reta jeita jae co tenondegua vae mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Echa che jae peve cuae: Jupi vae pe reta peyapo vae mbaeti yave jupi yae jupi vae mboroócuai re oporomboe vae reta jare fariseo reta oyapo vae güi, ngaraa etei peico mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Peendu ma quirai Moisés jei ñanetenondegua reta pe corai: “Agüɨye eporoyuca. Echa oporoyuca vae oñejaaucata co”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Erei che jae peve, oime yave quia pochɨ tɨvɨ pe vae, oñejaaucata co. Jare oime yave quia tɨvɨ güɨroɨro vae, judío reta itenondegua reta ojaata. Jare oime yave quia tɨvɨ pe: Nemboquere, jei vae, tata guasu jasɨ oiporarata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jae rambue reru yave metei mbota Tumpa peguara maemɨmba oyeyucagüe oñererocuaveea pe, jare joco pe nemaendúa yave quirai nderɨvɨ pochɨ ndeve mbae re, ");
INSERT INTO guiNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","eeya joco pe jocuae mbota maemɨmba oyeyucagüe oñererocuaveea jóvai. Ecua rani eñemoicavi nderɨvɨ ndive. Jayave taɨcue rupi ndepuereta remee jocuae mbota Tumpa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Eñemoicavi ɨmambae oipota oñeapo nderé mbae re vae ndive jae ndive reo rambueve tape rupi ɨvɨraiya oia cotɨ. Echa mbaeti yave, oñeapota nderé ɨvɨraiya pe, jare ɨvɨraiya nemondota tembipɨɨrɨru iñangarecoa pe jare tembipɨɨrɨru iñangarecoa neñonota tembipɨɨrɨru pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Añete che jae ndeve, ngaraa etei ree tembipɨɨrɨru güi ndei opaete ndepía remboepɨ mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Peendu ma quirai Moisés jei ñanetenondegua reta pe corai: “Agüɨye eñuvanga menda re”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Erei che jae peve, oime yave quia omae cuña re oipota reve vae, oñuvanga ma menda re ipɨa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jare nderesa ndeacatu oyapouca mbaeyoa ndeve yave, enoe emombo ndeyeugüi. Icavi co metei nderesa ocañɨ vaera ndegüi, tata guasu pe opaete nderete reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jae ramiño vi ndepo ndeacatu oyapouca mbaeyoa ndeve yave, eyasɨa emombo ndeyeugüi. Icavi co metei ndepo ocañɨ vaera ndegüi, tata guasu pe opaete nderete reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aracae Moisés jei vi corai: “Jembireco omombo vae tomee chupe tupapire omombeu vaera pɨpe omombo ma co”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Erei che jae peve, metei cuimbae ipuere omombo jembireco, cuña aguasa oyapo yave. Erei cuña mbaeti yave oyapo aguasa, cuimbae omombo yave, cuña oñuvanga co menda re omenda yave iru cuimbae ndive. Jae ramiño vi jocuae iru cuimbae cuña ndive omenda vae oñuvanga co menda re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Peendu ma quirai Moisés jei ñanetenondegua reta pe corai: “Agüɨye ere: ÑandeYa jee re ayapota, reporombotavɨ vaera. Echa rere yave: ÑandeYa jee re ayapota, eyapo”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Erei che jae peve, agüɨye ere jocorai. Agüɨye ere: Ara jee re ayapota. Echa ara Tumpa iguapɨa co. ");
INSERT INTO guiNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Agüɨye vi ere: Ɨvɨ jee re ayapota. Echa ɨvɨ Tumpa ipɨ jendara co. Agüɨye vi ere: Jerusalén jee re ayapota. Echa Jerusalén Mburuvicha Guasu mbaepuere güɨnoi vae jenta co. ");
INSERT INTO guiNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Agüɨye vi ere: Cheaca jee re ayapota. Echa mbaeti ndepuere reyapo ndea ti ani ju —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Erei reipota yave rere: Ayapota, ere: Ayapota. Jae ramiño vi reipota yave rere: Ngaraa ayapo, ere: Ngaraa ayapo. Echa jeta yae cuae güi rere yave, reyapota icavi mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Peendu ma quirai Moisés aracae jei corai: “Oime yave quia iru vae jesa güɨrocomegua vae, iru vae reta togüɨrocomegua vi jae jesa. Jae ramiño vi oime yave quia iru vae jai omope vae, iru vae reta tomope vi jae jai”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Erei che jae peve, emaeño iru vae re oyapo vaera ndeve icavi mbae vae. Oime yave quia ocua nderovaɨque re vae, erova ipuere vaera ocua ye jovaicho re. ");
INSERT INTO guiNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jae ramiño vi oime yave quia oñeapo nderé necamisa opɨro vaera ndegüi vae, emaeño jese opɨro vaera ndegüi ndeasoya vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jae ramiño vi oime yave quia ndeócuai reraja vaera ivoɨta metei kilómetro, eraja mócoi kilómetro —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jae ramiño vi oime yave quia oyerure ndeve mbae re vae, emee chupe, jare oime yave quia mbae oiporu ndeve vae, eiporuca chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Peendu ma quirai Moisés aracae jei corai: “Eaɨu neiru jare emotareɨ nderovaicho”. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Erei che jae peve, peaɨu perovaicho reta. Peyerure Tumpa pe omovendise vaera oyepopeyu peré vae reta. Peyapo icavi vae pemotareɨ vae reta pe. Peyerure Tumpa pe icavi mbae vae oyapo peve vae reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jocorai peyapo yave, peicota peRu ara pe oi vae taɨ retara. Echa peRu omee cuaraɨ icavi mbae vae oyapo vae reta jare icavi vae oyapo vae reta pe, opaete vae güɨnoi vaera tembipe. Jae ramiño vi omee ama jupi vae reta jare jupi mbae vae reta pe, opaete vae güɨnoi vaera ɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Echa peaɨu yave peraɨu vae retaño, jocuae mbaeti etei co mbae icavi vae. Jae rambue Tumpa ngaraa omee peve mbae jocuae jeco pegua. Echa mburuvicha peguara ocovara vae reta vi oyapo jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jae ramiño vi peicuava yave perɨvɨ retaño, jocuae mbaeti etei co mbae icavi vae. Echa mburuvicha peguara ocovara vae reta vi oyapo jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jae rambue jecuaeño peyapo icavi vae. Echa peRu ara pe oi vae jecuaeño oyapo icavi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jupi vae peyapo yave, agüɨye peyapo opaete vae jovaque jae reta oecha vaeraño. Echa peyapo yave opaete vae jovaque, peRu ara pe oi vae ngaraa omee peve mbae jocuae jupi vae peyapo vae jeco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jae rambue rembopota paravete vae reta yave, agüɨye eyapo oporombotavɨ vae reta oyapo rami. Echa jae reta omondo jenonde judío reta itupao reta pe jare calle reta rupi oñemimbɨ vae, iru vae reta omboete vaera ombopota paravete vae reta yave. Añete che jae peve, jocuae oporombotavɨ vae reta güɨnoi ma imbaera jocorai oyapo rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Erei nde rembopota paravete vae reta yave, agüɨye toicuaa ndepo ndeasu ndepo ndeacatu oyapo vae, ");
INSERT INTO guiNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agüɨye vaera quia ye oicuaa nde reyapo vae regua. Erei ndeRu oicuaata nde reyapo vɨari vae jare omeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jare reyerure Tumpa pe yave, agüɨye eyapo oporombotavɨ vae reta oyapo rami. Echa jae reta oyerure Tumpa pe yave, oipota yae iru vae reta oecha vaera. Jae rambue oñemboɨ judío reta itupao reta pe jare calle reta pe oyerure Tumpa pe yave. Añete che jae peve, jocuae oporombotavɨ vae reta güɨnoi ma imbaera jocorai oyapo rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Erei nde reyerure Tumpa pe yave, eique ndero pe jare eñoquenda onque. Jayave eyerure ndeRu pe iru vae reta oicuaa mbae reve. Jare ndeRu oicuaata nde reyapo vɨari vae jare omeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Erei peyerure Tumpa pe yave, agüɨye eyapo judío mbae vae reta oyapo rami. Echa jae reta jecuaeño omboaɨcuerecuere jei metei vaeño. Echa oñemongueta tei Tumpa oyeapɨsacata jese reta jocorai oyapo yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jae rambue agüɨye peyapo jae reta oyapo rami. Echa peRu oicuaa mbae oata peve vae ndei peyerure chupe jese mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jae rambue peyerure Tumpa pe corai: OreRu ara pe oi vae, toñemboeteuca nderee. ");
INSERT INTO guiNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tou ndeporoocuaia. Toyeapo neremimbota cuae ɨvɨ pe ara pe oyeapo oi rami. ");
INSERT INTO guiNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Emee oreve ara ñavo orerembiura. ");
INSERT INTO guiNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Neɨro oreve orembaeyoa reta re, ore oreɨro oipotagüe iyoa orecotɨ vae pe rami. ");
INSERT INTO guiNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jare agüɨye emaeño aña guasu re imiari vaera oreve ore oreyoa vaera. Orerepɨ aña guasu güi. Echa nembae co mboroocuaia. Nde renoi opaete mbaepuere. Opaete vae nemboeteta jecuaecuae aveiño. Amén. Jocorai peyerure —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Echa pe reta peɨro yave iyoa pecotɨ vae reta pe, peRu ara pe oi vae iñɨrota vi peve pembaeyoa reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Erei mbaeti yave peɨro iyoa pecotɨ vae reta pe, peRu ngaraa vi iñɨro peve pembaeyoa reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Peyecuacu tembíu güi yave, agüɨye peyapo oporombotavɨ vae reta oyapo rami. Echa jae reta oyecuacu tembíu güi yave, oyecuaa ipɨatɨtɨ yae, iru vae reta oicuaa vaera oyecuacu co ñogüɨnoi tembíu güi. Añete che jae peve, jae reta güɨnoi ma imbaera jocorai oyapo rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Erei nde tembíu güi reyecuacu yave, eyapocavi ndea jare eyuvae, ");
INSERT INTO guiNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agüɨye vaera iru vae reta oicuaa reyecuacu rei tembíu güi. Jaeño ndeRu oicuaata reyecuacu co rei tembíu güi. NdeRu oicuaata nde reyapo vɨari vae jare omeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Agüɨye peñovatu cuae ɨvɨ pe jeta mbaembae icavi vae peyeupeguara. Echa cuae ɨvɨ pe cupii reta güɨrocomegua mbaembae jare iru mbaembae iyuquɨrɨ güɨrocomegua, jare imonda vae reta oique vɨari o pe mbaembae oñomi vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Peñovatu mbaembae icavi vae peyeupeguara ara pe. Echa joco pe ngaraa cupii reta güɨrocomegua vaera mbaembae jare ngaraa mbae iyuquɨrɨ, jare ngaraa imonda vae reta oique vɨari mbaembae oñomi vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Echa peñovatu yave mbaembae icavi vae peyeupeguara ɨvɨ pe, jecuaeño peñemonguetata ɨvɨ pegua re. Erei peñovatu yave mbaembae icavi vae peyeupeguara ara pe, jecuaeño peñemonguetata ara pegua re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tembipe oique ñanderete pe ñanderesa rupi. Icavi yave nderesa, nderete tɨnɨeta tembipe pe. ");
INSERT INTO guiNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Erei mbaeti icavi yave nderesa, nderete tɨnɨeta pɨtumimbi pe. Nderete tɨnɨeta tei tembipe pe. Erei tɨnɨe yave pɨtumimbi pe, pɨtumimbi yae co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Metei tembiócuai oipota yave oyeócuai mócoi iya reta pe, omotareɨta metei iya jare oaɨuta iru iya, ani oparavɨquɨ cavita metei iya pe jare güɨroɨrota iru iya. Mbaeti pepuere peyeócuai Tumpa pe corepoti peaɨu reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jae rambue che jae peve, agüɨye peñemambeco mbae re. Agüɨye peñemambeco perembiura re. Jae ramiño vi agüɨye peñemambeco peremimondera re. Ngaraa pepuere peico cavi jecuaeño peñemambeco yave perembiura re, jare perete mbaeti oipota jeta temimonde ipora vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pemae güɨra reta re. Jae reta mbaeti omaetɨ jare mbaeti vi ombaarɨvo. Mbaeti vi oñovatu avati avatío pe. Erei peRu ara pe oi vae omongaru reta. Jare Tumpa peraɨu yae güɨra reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Güɨramoi peñemambeco peipota tei pepucu rambue. Erei ngaraa etei pepuere peñembocuacuaa pepucu yae vaera peñemambeco jese rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Maera pa peñemambeco peremimondera re? Peñemongueta mbaepotɨ reta re, quirai ocuacuaa reta. Mbaeti oparavɨquɨ reta. Mbaeti vi omaepova reta. ");
INSERT INTO guiNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Erei che jae peve, mbaepotɨ reta ipora yae Salomón jemimonde ipora yae vae güi. ");
INSERT INTO guiNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tumpa omopora yae ñana, yepe tei metei ara ñana oi co pe jare pɨareve pe ócai. Jae rambue Tumpa omeeta co peve peremimondera. Michi co peporogüɨrovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Agüɨye peñemambeco mbae re. Agüɨye peñemambeco perembiura re. Jae ramiño vi agüɨye peñemambeco peremimondera re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Echa opaete ɨvɨ pegua reta oñemambeco cuae mbaembae re. Jare peRu ara pe oi vae oicuaa icavi co penoi vaera opaete cuae mbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Erei icavi co peipota yae vaera Tumpa iporoocuaia jare peipota vaera peyapo jupi vae Tumpa jupi vae oyapo rami. Jocorai yave, Tumpa omeeta peve opaete cuae mbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jae rambue agüɨye peñemambeco pɨareve peguara vae re. Echa pɨareve oyeapo yeta mbae pemambeco vaera. Ara ñavo oyeapo mbaembae pemambeco vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Agüɨye pejaa iru vae, agüɨye vaera iru vae peraa. ");
INSERT INTO guiNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Echa pejaa yave iru vae, iru vae peraata co. Jae ramiño vi icavi vae peyapo yave iru vae pe, iru vae oyapota icavi vae peve. Jae ramiño vi icavi mbae vae peyapo yave iru vae pe, iru vae oyapota icavi mbae vae peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Agüɨye jecuaeño emae ɨtɨ michi vae neiru jesa pe oi vae re, oime yave renoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ngaraa ndepuere rere neiru pe: Cherɨvɨ, taequi nderesa güi jocuae ɨtɨ michi vae. Echa nde renoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nde co jae oporombotavɨ vae. Eequi rani ɨtɨ tuicha vae nderesa güi. Jayave remae cavita ndepuere vaera reequi ɨtɨ michi vae neiru jesa güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Agüɨye pemee mbae oñeñono tee Tumpa peguara vae ñaɨmba reta pe. Jae ramiño vi agüɨye peñono ita ipora yae vae reta cuchi reta jóvai. Echa jocorai peyapo yave, opɨro retata jese reta jare güɨramoi oyerovata pesuu vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Peyerure Tumpa pe mbae re jare Tumpa omeeta peve. Peeca jare pevaeta. Pembopu onque jare onque oyepeata peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Echa peyerure yave Tumpa pe mbae re, Tumpa omeeta peve. Jare peeca yave mbae, pevaeta. Jare pembopu yave onque, onque oyepeata peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nde renoi yave metei nderaɨ, nderaɨ oyerure yave ndeve mbɨyape re, ngaraa remee chupe metei ita mbɨyape jecovia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jae ramiño vi nderaɨ oyerure yave ndeve jevae ɨ rupigua re, ngaraa remee chupe metei mboi jevae ɨ rupigua jecovia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yepe tei pe reta jecuaeño peyapo icavi mbae vae, erei pemee co mbaembae icavi vae pemichia reta pe. Jae rambue peRu ara pe oi vae iquɨreɨ yae omee mbaembae icavi vae oyerure chupe jese vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jae rambue peyapo iru vae reta pe peipota iru vae reta oyapo vaera peve vae rami. Echa cuae co jae mboroócuai jeigüe jare Tumpa iñee aracae omombeu vae reta jeigüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Peique taraquera ipɨmí vae rupi. Echa taraquera ipɨguasu vae rupi oique vae reta oguata tape ipɨguasu vae pe, erei yogüɨraja cañɨtei pe. Jare jeta vae oique jocuae taraquera ipɨguasu vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Echa taraquera ipɨmí vae rupi oique vae reta oguata tape ipɨmí vae pe, erei yogüɨraja tecove opa mbae vae güɨnoi vae reta ñogüɨnoia pe. Jare mbovɨño ovae jocuae taraquera ipɨmí vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Amogüe oporombotavɨ vae reta jeita: Che co jae Tumpa iñee omombeu vae. Agüɨye perovia. Jae reta jei peve oipota co omombeu peve Tumpa iñee, erei oipota oyapo icavi mbae vae peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Peicuaata jae reta oporombotavɨ vae reta co icavi mbae vae oyapo rambue. Mbaeti yaequi uva metei yai güi. Jae ramiño vi mbaeti yaequi ɨva metei yai güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Metei ɨvɨra icavi vae omee ia icavi vae. Jae ramiño vi metei ɨvɨra icavi mbae vae omee ia icavi mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Metei ɨvɨra icavi vae mbaeti omee ia icavi mbae vae. Jae ramiño vi metei ɨvɨra icavi mbae vae mbaeti omee ia icavi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɨvɨra ia mbaeti yave icavi, ɨvɨra iya oyasɨa jare oapɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jae rambue peicuaata jae reta oporombotavɨ vae reta co icavi mbae vae oyapo rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jeta vae jeita cheve: CheYa, cheYa. Erei amogüe jocorai jei vae ngaraa yogüɨreco mboroocuaia ara pegua pe. Echa jaeño cheRu ara pe oi vae jemimbota oyapo vae reta yogüɨrecota joco pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jeta vae jeita cheve jocuae ara: CheYa, cheYa, ore romombeu Tumpa iñee nderee re. Jae ramiño vi nderee re romondo aña reta oya jese vae reta güi. Jae ramiño vi nderee re royapo jeta mɨacañɨ reta. Jocorai jeita —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Erei che jaeta chupe reta: Che mbaeti etei pocuaa. Pecua chegüi. Echa pe reta peyapo icavi mbae vae. Jocorai jaeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jae rambue oime yave quia oyeapɨsaca cheré vae, jae oyapo yave che jae chupe oyapo vaera vae, jae co metei cuimbae iyaracuaa vae jora oyapo vae rami. Echa cuimbae iyaracuaa vae oñono o iguapɨara ita tuicha vae ɨvɨgüɨ pe oi vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jayave oquɨ tanta jare jeta yae ɨ osɨrɨ o cotɨ. Ɨvɨtu yae vi o re. Ɨ jare ɨvɨtu omboyaparata tei o. Erei o mbaeti oyapara. Echa iguapɨa oi metei ita tuicha vae ɨvɨgüɨ pe oi vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Erei oime yave quia oyeapɨsaca cheré vae, mbaeti yave oyapo che jae chupe oyapo vaera vae, jae co metei cuimbae mbaeti iyaracuaa vae jora oyapo vae rami. Echa cuimbae mbaeti iyaracuaa vae oyapo jora ɨvɨcuiti re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jayave oquɨ tanta jare jeta yae ɨ osɨrɨ o cotɨ. Ɨvɨtu yae vi o re. Ɨ jare ɨvɨtu omboyapara o. Opa oñemboai jocuae o —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jare Jesús opaete cuae jei ma yave, opaete oyeapɨsaca jese vae reta ipɨacañɨ iporomboe re. ");
INSERT INTO guiNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Echa omboe reta mbaepuere güɨnoi vae rami. Mbaeti jocorai oporomboe mboroócuai re oporomboe vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jare Jesús ogüeyɨ ma ɨvɨtɨ güi yave, jeta yae vae yogüɨraja jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jayave ou Jesús oia pe metei cuimbae ipire ocúi vae. Oyeatɨca Jesús jóvai. —CheYa, reipota yave, ndepuere chembogüera —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jayave Jesús oñono ipo jese. —Aipota. Ecuera —jei chupe. Jare jupiveiño cuimbae ocuera imbaerasɨ güi. Mbaeti ma ocúi ipire. ");
INSERT INTO guiNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jayave Jesús jei ye chupe: —Agüɨye emombeu quia pe. Ecua eyeechauca sacerdote pe, jare emee mbota Moisés peócuai rami, tenta pegua reta oicuaa vaera recuera ma co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jare Jesús ojo ovae yave Capernaum pe, ou jae oia pe metei cien sundaro vae juvicha oyerure vaera chupe mbae re. ");
INSERT INTO guiNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jae jei Jesús pe: —CheYa, cherembiócuai imbaerasɨ. Oñeno oi chero pe. Mbaeti ipuere omɨi. Oiporara yae jasɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jayave Jesús jei chupe: —Taja tambogüera. ");
INSERT INTO guiNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Erei cien sundaro vae juvicha jei chupe: —CheYa, agüɨye ecua chero pe. Echa che mbaeti co mbae. Ndepuere rere cuae güiño cherembiócuai ocuera vaera jare ocuerata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Echa oime mburuvicha mbaepuere güɨnoi cheré vae reta. Jae ramiño vi che anoi mbaepuere sundaro reta re. Che jae metei sundaro pe: Ecua, jare jae ojo. Jae ramiño vi che jae iru sundaro pe: Eyu, jare jae ou. Jae ramiño vi che jae cherembiócuai pe: Eyapo cuae, jare jae oyapo —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jare Jesús cuae oendu yave, ipɨacañɨ cien sundaro vae juvicha re, jare jei yogüɨraja jaɨcue vae reta pe: —Añete che jae peve, mbaeti avae cuae nunga mborogüɨrovia tuicha vae Israel pegua reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jare che jae peve, jeta vae yogüeruta cuaraɨ oea cotɨ güi jare cuaraɨ oiquea cotɨ güi jare oguapɨ retata Abraham jare Isaac jare Jacob ndive mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Erei mboroocuaia pe yogüɨrecota tei vae reta oñemomboucata pɨtumimbi oia pe mboroocuaia icatu pe. Joco pe jae reta oyaeota jare jai omboquɨrɨrɨuta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jayave Jesús jei cien sundaro vae juvicha pe: —Ndepuere reo. Ayapo ma reipota ayapo vaera vae rerovia cheré rambue —jei. Jare jocuae ora pe etei cien sundaro vae juvicha jembiócuai ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jare Jesús oique Pedro jo pe yave, oecha Pedro jaicho oñeno oi jupa pe jacu oi rambue. ");
INSERT INTO guiNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jayave Jesús oipopɨɨ jare jacu opɨta chugüi. Jayave cuña opúa jare omee mbae jou reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jare cuaraɨ oique ma yave, tenta pegua reta güeru Jesús pɨri jeta aña oya jese vae reta. Jayave Jesús oyócuai aña reta yogüɨraja vaera opaete oya jese vae reta güi, jare ombogüera opaete imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jocorai oyapo Jesús oyeapo vaera Tumpa iñee aracae omombeu vae Isaías jeigüe vae. Echa jae jei corai: Jae etei güɨraja ñandegüi ñanembaerasɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jare jeta yae vae yogüeru Jesús oia pe. Jare Jesús oecha yave, jei jemimboe reta pe yogüɨraja vaera ɨ guasu jovaicho pe. ");
INSERT INTO guiNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jare metei mboroócuai re oporomboe vae ou Jesús oia pe jare jei chupe: —Oporomboe vae, taja nderupíe opaete que rupi reoa rupi. ");
INSERT INTO guiNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jayave Jesús jei chupe: —Aguara reta güɨnoi icua reta, jare güɨra reta güɨnoi jaitɨ reta. Echa che cuimbaera ayeapo vae mbaeti anoi cherora —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jare iru Jesús jemimboe jei Jesús pe: —CheYa, emaeño rani cheré aja vaera añotɨ cheru. ");
INSERT INTO guiNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Erei Jesús jei chupe: —Eyu cherupíe. Mbaeti tecove opa mbae vae güɨnoi vae reta toñotɨ omano vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jayave Jesús oyeupi chalana pe jare jemimboe reta vi oyeupi pɨpe. ");
INSERT INTO guiNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jare ou ɨvɨtu tanta oyepeyu, jare ɨaparúa oñeñoña chalana pe, jare omotɨnɨe seri ma. Erei Jesús oque oi. ");
INSERT INTO guiNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jayave Jesús jemimboe reta yogüɨraja omoingove. Jei reta chupe: —OreYa, orerepɨ. Ñamanota ma. ");
INSERT INTO guiNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jayave Jesús jei chupe reta: —¿Maera pa pequɨye? Michi yae co peporogüɨrovia —jei. Jayave opúa jare oñeengata ɨvɨtu jare ɨ pe. Jare opaete quirii. ");
INSERT INTO guiNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jare Jesús jemimboe reta ipɨacañɨ jare jei: —¿Mbae nunga cuimbae ra cuae? Ɨvɨtu jare ɨ guasu oyapo oyocuaigüe. ");
INSERT INTO guiNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jayave yogüɨraja ovae ɨ guasu jovaicho pe, gadareno reta iɨvɨ pe. Jare yogüeru teogüerɨrurenda güi oovaiti Jesús mócoi cuimbae aña oya jese vae reta. Pochɨ yae reta. Jae rambue mbaeti quia ipuere oguata jocuae tape rupi. ");
INSERT INTO guiNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jare jae reta iñeeata reve jei: —¿Maera pa reyu oremambeco, Jesús? Nde co jae Tumpa Taɨ. ¿Reyu pa reiporarauca oreve añave? Taɨcue rupi ramo reiporaraucata tei co oreve —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jare mombɨrɨ chugüi reta jeta cuchi reta ocaru ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jare aña reta oyerure Jesús pe: —Cuae cuimbae reta güi oremondo yave, emaeño oreré rojo vaera roya cuchi reta re. ");
INSERT INTO guiNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jayave Jesús jei chupe reta: —Pecua. Jare yogüɨraja ma yave cuimbae reta güi, aña reta yogüɨraja oya cuchi reta re. Jayave opaete cuchi reta osɨi tanta oa ɨ guasu pe ɨvɨa güi jare joco pe ipɨtupa. ");
INSERT INTO guiNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jayave cuchi iñangarecoa reta otecuarai, jare yogüɨraja tenta pe, jare omombeu tenta pegua reta pe opaete oyeapo vae regua. Omombeu vi chupe reta mbae aña oya jesegüe vae reta pe oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jayave opaete tenta pegua reta yogüeru oovaiti Jesús. Jare oecha yave, oyerure chupe ojo vaera iɨvɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jare Jesús oyeupi ye metei chalana pe jare ojo ye ɨ guasu jovaicho pe. Jayave ojo ovae jenta ae pe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jayave amogüe vae güeru metei cuimbae imbaerasɨ vae. Cuae cuimbae mbaeti ipuere omɨi. Oñeno oi jupa pe. Jesús cuae oecha yave, oicuaa jae reta güɨrovia co jese, jare jei cuimbae mbaeti ipuere omɨi vae pe: —Eyerovia, cherɨvɨ. Nembaeyoa reta oñemboai ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jayave amogüe mboroócuai re oporomboe vae reta oñemongueta ipɨa pe: Cuae cuimbae jei icavi mbae vae Tumpa cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Erei Jesús oicuaa jae reta iñemongueta, jare jei chupe reta: —¿Maera pa penoi pepɨa pe ñemongueta icavi mbae vae reta? ");
INSERT INTO guiNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chepuere jae cuae cuimbae pe: Nembaeyoa reta oñemboai ma. Jae ramiño vi chepuere jae chupe: Epúa eguata. ¿Mbae nunga pa mbaetita yavai jae vaera? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Erei aipota peicuaa vaera cuae: Che cuimbaera ayeapo vae chepuere cheɨro quia pe imbaeyoa reta re ɨvɨ pe ai rambueve —jei. Jayave jei cuimbae mbaeti ipuere omɨi vae pe: —Epúa evoɨ nderupa, jare ecua ndero pe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jayave cuimbae opúa, jare oe ojo jo cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Erei jeta yae vae joco pe ñogüɨnoi vae oecha yave, oquɨye jare omboete Tumpa, mbaepuere tuicha vae omee Jesús pe rambue. ");
INSERT INTO guiNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jare Jesús joco güi ojo yave, oecha metei cuimbae Mateo jee vae oguapɨ oi mburuvicha peguara ocovara ñogüɨnoia pe, jare jei chupe: —Eyu cherupíe. Jayave Mateo opúa, jare ojo jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jare Jesús ocaru oi rambueve Mateo jo pe, jeta mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta yogüeru ocaru vaera Jesús jare jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jare fariseo reta cuae oecha yave, jei Jesús jemimboe reta pe: —¿Maera pa ocaru pemboe vae ocovara vae reta jare teco icavi mbae vae oyapo vae reta ndive? ");
INSERT INTO guiNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Erei Jesús cuae oendu yave, jei chupe reta: —Mbaeti mbae jasɨ chupe vae reta mbaeti oeca oporopoano vae. Imbaerasɨ vae retaño oeca —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pecua peñemboe mbae oipota jei cuae: “Aipota peporoparareco vaera, mbaeti maemɨmba oyeyucagüe reta perocuavee vaeraño”. Echa che ayu aeni vaera iyoa vae reta, mbaeti jupi vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jayave yogüeru Juan jemimboe reta Jesús oia pe jare oparandu chupe: —¿Maera pa ore jare fariseo reta royecuacu tembíu güi, erei neremimboe reta mbaeti oyecuacu tembíu güi? ");
INSERT INTO guiNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jayave Jesús jei chupe reta: —Omendata vae pɨri ñogüɨnoi vae reta ngaraa etei oyecuacu tembíu güi, omendata vae jae reta ndive oi rambueve. Erei outa ovae ara omendata vae oyererajauca vaera chugüi reta. Jayave ramo jae reta oyecuacuta tembíu güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mbaeti icavi ñamboya vaera temimonde indechi vae maemboyaa ipɨau vae pe. Echa jocorai yayapo yave, maemboyaa ipɨau vae omoata temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jae ramiño vi mbaeti icavi ñamboɨru vaera vino ipɨau vae vino jɨru guasupi indechi vae pe. Echa jocorai yayapo yave, vino omondoro jɨru, jare vino oyepɨyere, jare jɨru mbaeti ma icavi. Jae rambue ñamboɨru vino ipɨau vae jɨru ipɨau vae pe. Echa jocorai yayapo yave, jɨru mbaeti osoro jare vino mbaeti oyepɨyere —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jare Jesús cuae jei chupe reta rambueve, ou Jesús oia pe ovae metei mburuvicha. Jae oyeatɨca Jesús jóvai jare jei: —Cherayɨ omanota ma oi. Erei yaja eñono ndepo jese embogüera, agüɨye vaera omano —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jayave Jesús jare jemimboe reta yogüɨraja mburuvicha jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jare metei cuña doce año ma oiporara tugüɨguasu vae oya Jesús re icupe cotɨ jare oyavɨquɨ jemimonde jembeɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Echa jae jei ma iyeupe ipɨa pe: —Yepe tei jemimondeño tayavɨquɨ, acuerata co. ");
INSERT INTO guiNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Erei Jesús oyerova, jare oecha yave, jei chupe: —Chereindɨ, ndepɨacatu. Recuera ma rerovia cheré rambue. Jare jupiveiño cuña ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jare Jesús oique mburuvicha jo pe yave, oecha oñemimbɨ vae reta jare jeta joco pe yatɨ vae reta omboɨapu yae ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jayave jei chupe reta: —Pecua icatu pe. Cuae cuñatai mbaeti co omano. Oqueño co oi —jei. Erei joco pe ñogüɨnoi vae reta oyóyai Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jayave Jesús omoe opaete vae oca pe. Jayave oique ye o pe jare oipɨɨ cuñatai ipo pe, jare cuñatai opúa voi. ");
INSERT INTO guiNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jare opaete jocuae ɨvɨ pegua reta oendu quirai Jesús oyapo cuae mɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jare Jesús joco güi ojo yave, mócoi cuimbae jesa mbae vae reta yogüɨraja jaɨcue, jare iñeeata reve jei chupe: —Nde co jae David Taɨ. Oreparareco. ");
INSERT INTO guiNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jare Jesús oique ma yave o pe, cuimbae jesa mbae vae reta vi oique jaɨcue. Jayave Jesús oparandu chupe reta: —¿Perovia pa chepuere co ayapo cuae peve? —Rogüɨrovia, oreYa —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jayave Jesús oyavɨquɨ jae reta jesa, jare jei chupe reta: —Perovia rambue, pemae. ");
INSERT INTO guiNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jare mócoi reve ipuere omae. Jayave Jesús jei chupe reta: —Agüɨye pemombeu quia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Erei jae reta yogüɨraja ma yave, omombeu jeta yae vae jocuae ɨvɨ pegua reta pe Jesús oyapo chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jare jae reta yogüɨraja ma yave, iru vae reta güeru Jesús oia pe metei iupa vae. Metei aña oya ma cuae iupa vae re. ");
INSERT INTO guiNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jayave Jesús omondo aña chugüi jare iupa vae omboɨpɨ imiari. Jare jeta yae vae ipɨacañɨ jare jei reta: —Mbaeti etei yaecha cuae nunga mɨacañɨ Israel pe. ");
INSERT INTO guiNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Erei fariseo reta jei: —Aña guasu imbaepuere pe omondo aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jare Jesús ojo opaete tenta tuicha vae reta jare tenta michi vae reta rupi, jare oporomboe judío reta itupao ñavo pe. Omombeu ñee icavi vae Tumpa iporoocuaia pegua, jare ombogüera imbaerasɨ vae reta oipotagüe mbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Erei oecha yave jeta yae vae, oiparareco omae jese reta. Echa jae reta oñemambeco jare ipɨatɨtɨ. Vecha mbaeti iñangarecoa güɨnoi vae reta rami co. ");
INSERT INTO guiNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jayave Jesús jei jemimboe reta pe: —Jeta yae co yaarɨvo vaera. Erei mbovɨ yae co oarɨvo vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jae rambue pe reta peyerure ñandeYa pe omondo vaera oparavɨquɨ vae reta oarɨvo reta vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Metei ara Jesús oeni jocuae doce jemimboe reta, jare omee chupe reta mbaepuere omondo vaera aña reta oya jese vae reta güi jare ombogüera vaera imbaerasɨ vae reta oipotagüe mbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cuae co jae jocuae doce Jesús jemimondo reta jee: Simón (Pedro jee vae), jare Simón tɨvɨ Andrés jee vae, jare Zebedeo taɨ reta Jacobo jare Juan jee vae, ");
INSERT INTO guiNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ocovara vae, Alfeo taɨ Jacobo jee vae, Lebeo Tadeo, ");
INSERT INTO guiNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (jae co metei cananita), jare Judas Iscariote (cuae cuimbae omoeterenga Jesús jovaicho reta pe). ");
INSERT INTO guiNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jare ndei omondo reta mbove, Jesús oyócuai cuae doce reve. —Agüɨye pecua judío mbae vae reta ñogüɨnoia pe. Agüɨye pecua samaritano jenta reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pecua Israel pegua reta ñogüɨnoia pe. Echa jae reta vecha ocañɨ vae reta rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jare peguata rambueve, pemombeu iru vae reta pe corai: Mboroocuaia ara pegua outa ma ovae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pembogüera imbaerasɨ vae reta. Pembogüera ipire ocúi vae reta. Pemoingove ye omanogüe vae reta. Pemondo aña reta oya jese vae reta güi. Che amee ma peve cuae mbaepuere jepɨ mbae reve. Jae rambue agüɨye pecovara mbae quia pe peyapota chupe vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Agüɨye peraja oro jare corepoti pecuacuaa pe. ");
INSERT INTO guiNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Agüɨye vi peraja peaporoca, jare agüɨye pemonde mócoi camisa. Peraja jaeño metei pepopoca jare pepɨapaa pemonde vae. Echa icavi co iru vae reta omboepɨ vaera oparavɨquɨ vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jare peo yave metei tenta tuicha vae pe ani metei tenta michi vae pe, peparandu quia ra pepuere perovia catu joco pe. Jayave peico jae jo pe jocuae tenta güi peo ye regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jare peique metei o pe yave, pere: Tumpa tomee peve mbɨacatu. ");
INSERT INTO guiNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jare pepuere yave perovia catu joco pe yogüɨreco vae reta, Tumpa omeeta chupe reta mbɨacatu. Erei mbaeti yave pepuere perovia catu, pe retaño penoita mbɨacatu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jare oime yave metei tenta pegua reta mbaeti oipota pepɨta vaera joco pe jare mbaeti oipota oyeapɨsaca peré vae, pecuaño joco güi jare pemotumo ɨvɨtimbo pepɨ güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Añete che jae peve, Tumpa ojaa yave ɨvɨ pegua reta, jocuae tenta pegua reta oiporara yaeta Sodoma jare Gomorra pegua reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mase, pomondo icavi mbae vae oyapo vae reta ipɨte rupi. Pe reta vecha reta rami co. Jae reta aguarañaɨmba reta rami co. Jae rambue pearacuaa catu mboi iyaracuaa catu rami. Jae ramiño vi agüɨye peyapo icavi mbae vae pɨcasu mbaeti oyapo icavi mbae vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Peñeandu. Echa iru vae reta pererajata mburuvicha reta yatɨa pe, oñeapo vaera peré. Jare penupata judío reta itupao reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jare peyererajaucata mburuvicha reta jare mburuvicha guasu reta jóvai chereco pegua, pepuere vaera chemombeu chupe reta jare judío mbae vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Erei jae reta pemoeterenga yave, agüɨye peñemambeco mbae pereta mburuvicha reta pe vae re. Echa Espíritu Santo oicuaucata peve jocuae ora pe etei mbae pere vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Echa peRu iEspíritu imiarita pe reta rupi, mbaeti pe retaiño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jare metei cuimbae omoeterengata tɨvɨ oyeyucauca vaera. Jae ramiño vi metei cuimbae omoeterengata taɨ oyeyucauca vaera. Jare michia reta oyovaicho retata tu jare ichɨ ndive, jare oyucauca retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jare peñemotareɨucata opaete vae pe chereco pegua. Erei josa ojo ovae iyapɨ pe vae oñemboasaucata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Erei metei tenta pe oyapo reta icavi mbae vae peve yave, petecuarai iru tenta pe. Añete che jae peve, ngaraa peo opaete Israel pegua reta jenta pe ndei che cuimbaera ayeapo vae ayu ye mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Metei oñemboe oi vae mbaeti oicuaa jeta yae oporomboe vae oicuaa vae güi. Jae ramiño vi metei oyeócuai vae imbaepuere mbaeti tuicha yae iya imbaepuere güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Icavi co metei oñemboe oi vae oñemboe cavi vaera oporomboe vae oicuaa vae re. Jae ramiño vi icavi co metei oyeócuai vae oiporu cavi vaera mbaepuere iya omee chupe vae. Che co jae peYa, jare iru vae reta chembojee Beelzebú. Jae rambue pembojeeta Beelzebú taɨ reta. Echa pe reta peyeócuai cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Erei agüɨye pequɨye chugüi reta. Oime yave mbae oyeasoi vae, oyeechaucañotai co. Jare oime yave mbae oñemi vae, oyecuaañotai co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pɨtumimbi pe che jae peve vae re pemiari tembipe pe. Jare che jae vɨari peve vae pemombeu opaete vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Agüɨye pequɨye oporoyuca vae reta güi. Echa pereteño ipuere oyuca. Mbaeti ipuere oyuca perecove. Pequɨye Tumpa güi. Echa jae ipuere omondo quia jete jare jecove tata guasu pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Peicuaa co quirai omaemee vae reta omee mócoi güɨra-raɨ mbovɨ yae corepoti re. Erei mbaeti metei yepe omano oa ɨvɨ re peRu mbaeti oicuaa reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tumpa oicuaa mbovɨ pea penoi peaca re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jae rambue agüɨye pequɨye. Echa Tumpa peraɨu yae jeta güɨra-raɨ güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Oime yave quia iru vae reta jovaque chemboete vae, che amboeteucata cheRu ara pe oi vae jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Erei oime yave quia iru vae reta jovaque checuacu vae, che vi aicuacuta cheRu ara pe oi vae jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Güɨramoi peñemongueta che ayu co amee vaera mbɨacatu ɨvɨ pegua reta pe. Erei mbaeti jocorai. Che ayu oñemboyao vaera oyougüi ɨvɨ pegua reta, mbaeti güɨnoi vaera mbɨacatu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayu metei cuimbae oyovaicho vaera tu ndive, jare cuñatai oyovaicho vaera ichɨ ndive, jare cuña oyovaicho vaera imendɨ ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jare cuimbae jo pegua reta oyovaichota cuimbae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oime yave quia oaɨu yae tu jare ichɨ chegüi vae, ngaraa ipuere oico cheremimboera. Jae ramiño vi oime yave quia oaɨu yae imichia reta chegüi vae, ngaraa ipuere oico cheremimboera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jare oime yave quia mbaeti ovoɨ güɨraja icurusu ojo vaera cherupíe vae, ngaraa ipuere oico cheremimboera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oipota oñovatu jecove vae ngaraa ipuere oñovatu. Erei omoeterengata jecove chereco pegua vae oñovatuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Oime yave quia pemboresive vae, che co chemboresive. Jare chemboresive vae omboresive co chembou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oime yave quia metei Tumpa iñee omombeu vae Tumpa iñee omombeu rambue omboresive vae, Tumpa omeeta chupe iñee omombeu vae pe omeeta vae. Jae ramiño vi oime yave quia metei jupi vae oyapo vae jupi vae oyapo rambue omboresive vae, Tumpa omeeta chupe jupi vae oyapo vae pe omeeta vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Añete che jae peve, oime yave quia omee metei taza ɨ iroɨsagüe yepe metei michia jou vaera vae, oyapo yave jocorai jae co cheremimboe rambue, amboecoviata co chupe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jare Jesús opa ma oyócuai yave jocuae doce jemimboe reta, jae etei ojo joco güi oporomboe vaera jare omombeu vaera Tumpa iñee Israel pegua tenta reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jare Juan tembipɨɨrɨru pe oi rambueve, oendu Cristo oyapo oi vae regua. Jayave ombou mócoi jemimboe reta Jesús oia pe ");
INSERT INTO guiNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","jei vaera chupe: —¿Nde pa co jae Cristo outa vae? ani ¿roarota pa iru vae ou vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jayave Jesús jei chupe reta: —Pecua ye pemombeu Juan pe peendu jare peecha vae. ");
INSERT INTO guiNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jesa mbae vae reta omae. Mbaeti ipuere oguata vae reta oguata. Ipire ocúi vae reta ocuera. Iyapɨsa mbae vae reta oendu. Omanogüe vae reta oicove ye. Paravete vae reta oyeapɨsaca ñee icavi vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jare Tumpa omovendiseta jecuae güɨrovia cheré vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jare yogüɨraja ye yave Juan ombou vae reta, Jesús omboɨpɨ imiari joco pe ñogüɨnoi vae reta pe Juan re. Jei chupe reta: —¿Quia re pa co peo ñuu pe pemae? Jae mbaeti co ipɨrata mbae vae tacuarasɨ omɨi ɨvɨtu oipeyu yave vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Quia re pa co peo pemae? Jae mbaeti omonde temimonde ipora vae. Mase, temimonde ipora vae omonde vae reta yogüɨreco mburuvicha guasu reta jo pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Quia re pa co peo pemae? ¿Peo ra pemae metei Tumpa iñee omombeu vae re? Añete che jae peve, Tumpa omee chupe oyapo vaera jeta yae iru Tumpa iñee omombeu vae reta oyapo vae güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tumpa iñee pe oyecuatía oi jese corai: Mase —jei Tumpa—, che amondota cheñee güɨrajata vae nerenonde, oyapocavi vaera nderapera. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Añete che jae peve, Tumpa omee Juan oporombobautizase vae pe oyapo vaera jeta yae iru Tumpa iñee omombeu vae reta oyapo vae güi. Erei taɨcuegua vae ara pegua mboroocuaia pegua oñemboeteuca yaeta Juan güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan oporombobautizase vae omboɨpɨ Tumpa iporoocuaia regua omombeu güive, opaete vae oipota yae oique jocuae mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Echa opaete Tumpa iñee aracae omombeu vae reta oicuatía vae jare mboroócuai vi oicuauca Tumpa iporoocuaia regua ndei Juan ou mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jare peipota yave perovia, jae co Elías. Echa Tumpa iñee aracae omombeu vae jei outa co Elías —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ipuere oendu vae toyeapɨsaca cuae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tamombeu peve mbae ndive amboyovaque añave yogüɨreco vae reta. Jae reta co michia maemeea pe oguapɨ ñogüɨnoi vae reta rami. Jae reta jei oyoupe corai: ");
INSERT INTO guiNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Roñemimbɨ ma peve, erei pe reta mbaeti pepɨrae. Orepɨatɨtɨ perovaque, erei pe reta mbaeti peyaeo. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Echa Juan ou, jare jae oyecuacu tembíu jare vino güi. Jae rambue oicuaa vae reta jei aña oya co Juan re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Che cuimbaera ayeapo vae ayu, jare che mbaeti ayecuacu tembíu jare vino güi. Jae rambue checuaa vae reta jei corai: Mase, jae jou jeta tembíu jare vino. Jae co mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta iamingo. Jocorai jei —jei—. Erei opaete iyaracuaa vae reta oicuauca aracuaa icavi co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jayave Jesús omboɨpɨ oñeengata jocuae tenta jeta yae mɨacañɨ oyapo pɨpe vae reta pe. Echa jocuae tenta pegua reta mbaeti oeya iñemongueta icavi mbae vae ipɨa pe oi vae. Jae jei: ");
INSERT INTO guiNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazín pegua reta oiporarata co. Betsaida pegua reta oiporarata co. Echa jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jocorai ayapo yave mona Tiro jare Sidón pe, Tiro jare Sidón pegua reta oeyata tei aracae ma iñemongueta icavi mbae vae ipɨa pe oi vae. Omondeta tei temimonde jaimbe vae jare oñonota tei tanimbu iñaca re oicuauca vaera ipɨatɨtɨ co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Erei che jae peve, Tumpa ojaa yave ɨvɨ pegua reta, Corazín jare Betsaida pegua reta oiporara yaeta Tiro jare Sidón pegua reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jare Capernaum pegua reta oñemongueta tei icavi co yogüɨreco vaera Tumpa ndive. Erei Tumpa omondo retata yogüɨreco vaera cañɨtei pe. Echa jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jocorai ayapo yave mona Sodoma pe, Sodoma ngaraa tei oñemboai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Erei che jae peve, Tumpa ojaa yave ɨvɨ pegua reta, Capernaum pegua reta oiporara yaeta Sodoma pegua reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jayave Jesús jei: —CheRu, nde co jae ara pegua reta jare ɨvɨ pegua reta iYa. Amee yasoropai ndeve quirai nde mbaeti remaeño cuae ɨvɨ pegua iyaracuaa vae reta re oicuaa vaera cuae mbaembae, erei reicuauca michia rami vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Icavi co, cheRu. Echa icavi co ndeve reyapo vaera jocorai —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jayave jei ye: —CheRu omee ma cheve opaete. Mbaeti quia oicuaa cavi cheregua, jaeño cheRu. Jae ramiño vi mbaeti quia oicuaa cavi cheRu regua, jaeño che jare che aicuauca chupe vae. Che co jae cheRu Taɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Opaete peñemambeco jare pepɨatɨtɨ vae reta peyu checotɨ. Che tamombutuu perecove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Peñemboyuayu che ndive jare peñemboe che aipota pomboe jese vae re. Echa che añemomichi. Mbaeti etei añemboete. Jocorai peyapo yave, perecove oputuuta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Echa peñemboyuayu yave che ndive, ngaraa peñemambeco jare ngaraa pepɨatɨtɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mbutuu iara pe Jesús ojo co reta rupi jemimboe reta ndive. Jesús jemimboe reta ñɨmbɨaɨ jare omboɨpɨ oipoo trigo jou. ");
INSERT INTO guiNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Erei fariseo reta oecha yave, jei Jesús pe: —Mase, neremimboe reta oyapo ñogüɨnoi agüɨyeta tei oyapo mbutuu iara pe vae. ");
INSERT INTO guiNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jayave Jesús jei chupe reta: —¿Mbaeti etei pa pemongueta David oyapogüe vae regua, jae jare jae ndive ñogüɨnoi vae reta ñɨmbɨaɨ yave? ");
INSERT INTO guiNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David oique Tumpa jo pe jare jou mbɨyape Tumpa jo pe oñeñono tee vae reta. Agüɨyeta tei co David jare jae ndive ñogüɨnoi vae reta jou jocuae mbɨyape. Jaeño sacerdote reta ipuere jou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jare ¿mbaeti etei pa pemongueta mboroócuai pe quirai mbutuu iara pe sacerdote Tumpa jo pe ñogüɨnoi vae reta oyapo agüɨyeta tei quia oyapo mbutuu iara pe vae? Erei Tumpa mbaeti omboeco reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Erei che jae peve, che cuae pe ai vae añemboeteuca yae Tumpa jo güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Erei mbaeti peicuaa mbae oipota jei cuae Tumpa iñee pe oyecuatía oi vae: Aipota peporoparareco vaera —jei Tumpa—, mbaeti maemɨmba oyeyucagüe reta perocuavee vaeraño. Jocorai oyecuatía oi. Echa peicuaa yave mona, ngaraa tei pemboeco mbaeti teco güɨnoi vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Echa che cuimbaera ayeapo vae chepuere jae mbae icavi oyeapo vaera mbutuu iara pe vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jare Jesús ojo joco güi oique judío reta itupao pe. ");
INSERT INTO guiNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jare oi joco pe metei cuimbae iporovaicho omano vae. Jare joco pe ñogüɨnoi vae reta oparandu Jesús pe: —¿Icavi pa ñambogüera vaera quia mbutuu iara pe? ¿Mbae pa jei mboroócuai cuae re? —jei reta. Echa jae reta oipota tei omboeco Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jayave Jesús jei chupe reta: —Metei cuimbae güɨnoi yave metei vecha, jare vecha oa yave ɨvɨcua pe mbutuu iara pe, cuimbae oipɨɨ voita güɨnoe ɨvɨcua güi. ");
INSERT INTO guiNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Erei metei cuimbae jepɨ yae metei vecha güi. Jae rambue jupi co yayapo vaera icavi vae mbutuu iara pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jayave jei cuimbae pe: —Eupi ndepo. Jayave cuimbae oupi, jare ipo ocuera cavi ma. Oyovaque ma iporovaicho ipo icavi vae ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jayave fariseo reta oe judío reta itupao güi, jare oñomomiari quirai ra oyucaucata Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Erei Jesús cuae oicuaa yave, ojo joco güi. Jare jeta yae vae yogüɨraja jaɨcue, jare Jesús ombogüera opaete imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jare Jesús oyócuai reta agüɨye vaera omombeu quia co jae. ");
INSERT INTO guiNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cuae oyapo, oyeapo vaera Tumpa iñee aracae omombeu vae Isaías jeigüe vae. Echa jae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mase, jae co cherembiócuai aiparavo vae —jei Tumpa—. Aaɨu yae. Ayerovia yae jese. Ameeta chupe cheEspíritu, jare jae ojaata judío mbae vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngaraa oyoaca quia ndive. Ngaraa vi quia oendu iñee calle reta rupi. ");
INSERT INTO guiNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ngaraa oaquɨo tacuarasɨ ñape vae. Ngaraa vi ombogüe mechero michi yae jendɨ oi vae, ndei oporomoamɨri oporojaa vaera mbove. ");
INSERT INTO guiNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jare jae jee re judío mbae vae reta güɨroviata. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jayave amogüe vae güeru Jesús oia pe metei cuimbae aña oya jese vae. Cuimbae jesa mbae jare iupa vae. Jare Jesús ombogüera. Cuimbae mbaeti ma jesa mbae. Omae ma. Mbaeti ma iupa. Iñee ma. ");
INSERT INTO guiNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jare opaete joco pe ñogüɨnoi vae reta ipɨacañɨ jare jei: —¿Cuae ra co jae David Taɨ? ");
INSERT INTO guiNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Erei fariseo reta cuae oendu yave, jei reta: —Aña guasu Beelzebú imbaepuere peño omondo aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús oicuaa fariseo reta iñemongueta jare jei chupe reta: —Metei tenta pegua reta oyovaicho oyoupi yave, opata co jocuae tenta. Jae ramiño vi metei o pegua reta oyovaicho oyoupi yave, opata co jocuae o —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jare Satanás omondo yave Satanás oya jese vae reta güi, imbaepuere oñemboyao ma co. Jae rambue ngaraa etei ma oi iporoocuaia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Erei che amondo yave aña reta oya jese vae reta güi Beelzebú imbaepuere pe, ¿quia imbaepuere pe ra omondo aña reta oya jese vae reta güi perentara reta? Pepuere peparandu chupe reta jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Erei che amondo aña reta oya jese vae reta güi Tumpa iEspíritu imbaepuere pe. Jae rambue pepuere peicuaa ou ma co peve Tumpa iporoocuaia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Oime yave quia oipota oique cuimbae ipɨrata vae jo pe opɨro vaera imbaembae chugüi vae, oipocuata rani cuimbae ipɨrata vae. Jayave ramo ipuereta opɨro imbaembae chugüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Oime yave quia mbaeti oipota oico cheirura vae, oyovaicho co che ndive. Jae ramiño vi oime yave quia mbaeti chemborɨ vae, oyapo co icavi mbae vae checotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jae rambue che jae peve, opaete ɨvɨ pegua reta imbaeyoa reta jare opaete iñee icavi mbae Tumpa cotɨ vae Tumpa ipuere omboai. Erei Tumpa ngaraa etei iñɨro jei icavi mbae vae Espíritu Santo cotɨ vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jare oime yave quia jei icavi mbae vae che cuimbaera ayeapo vae cotɨ vae, Tumpa ipuere iñɨro chupe. Erei oime yave quia jei icavi mbae vae Espíritu Santo cotɨ vae, Tumpa ngaraa etei iñɨro chupe, añave jare ara reta outa vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Penoi yave ɨvɨra icavi vae, penoita vi ia icavi vae. Jae ramiño vi penoi yave ɨvɨra icavi mbae vae, penoita vi ia icavi mbae vae. Echa peecha yave ɨvɨra ia, peicuaata icavi ra ɨvɨra —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pe reta co jae mboi pochɨ vae reta rami. Echa pe reta peyapo icavi mbae vae. Jae rambue mbaeti etei pepuere pere icavi vae. Echa oipotagüe vae imiari ipɨa pe güɨnoi vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Quia nunga jecocavi vae güɨnoi icavi vae ipɨa pe. Jae rambue jei icavi vae. Jae ramiño vi quia nunga jecopochɨ vae güɨnoi icavi mbae vae ipɨa pe. Jae rambue jei icavi mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Erei che jae peve, jocuae ara Tumpa oporojaa yave, jae omboecota ɨvɨ pegua reta opaete ñee ñurunguiche pegua re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Echa Tumpa jeita icavi vae co peyapo, icavi vae pere yave. Jae ramiño vi Tumpa jeita icavi mbae vae co peyapo, icavi mbae vae pere yave —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jayave amogüe mboroócuai re oporomboe vae reta jare fariseo reta jei Jesús pe: —Oporomboe vae, roipota reyapo vaera mbae reicuauca vaera oreve quia co nde. ");
INSERT INTO guiNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jayave Jesús jei chupe reta: —Añave yogüɨreco vae reta icavi mbae vae oyapo vae reta co. Mbaeti oporogüɨrovia. Jae rambue oipota ayapo vaera mɨacañɨ chupe reta. Erei jaeño oyeapota mbae Tumpa iñee aracae omombeu vae Jonás pe oyeapo vae rami, jae reta oicuaa vaera quia co che —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Echa Jonás opɨta mboapɨ ara jare mboapɨ pɨtu jocuae jevae ɨ rupigua tuicha yae vae jɨe pe. Jae ramiño vi che cuimbaera ayeapo vae apɨtata mboapɨ ara jare mboapɨ pɨtu ɨvɨgüɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tumpa oporojaa yave, Nínive pegua reta opuata omboeco vaera añave yogüɨreco vae reta. Echa jae reta oeya iñemongueta icavi mbae vae ipɨa pe oi vae, Jonás omombeu chupe reta yave Tumpa iñee. Erei chembaepuere tuicha yae co Jonás imbaepuere güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tumpa oporojaa yave, jocuae mburuvicha guasu cuña ɨvɨtu yevɨ cotɨ güi ou vae opuata omboeco vaera añave yogüɨreco vae reta. Echa jae ou mombɨrɨ ete güi oyeapɨsaca vaera Salomón iyaracuaa catu vae re. Erei che chearacuaa catu yae Salomón güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Metei aña ojo ma yave oya jese vae güi, oguata ñuu rupi oeca oicoara. Erei mbaeti yave ipuere ovae oicoara, ");
INSERT INTO guiNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","jei iyeupe: Taja ye jocuae chero ayu chugüi vae pe —jei, jei—. Echa ñandepuere ñamojaanga metei o jocuae cuimbae aña ojo ma chugüi vae re. Aña ou ye ovae yave jocuae o pe oecha ipo mbae. O iya otupei ma jare oyapocavi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jayave ojo ye aña güeru siete aña icavi mbae yae chugüi vae reta jocuae o pe. Jayave ocho reve oique o pe, joco pe yogüɨreco vaera. Tenonde yave, metei aña oya jese yave, jocuae cuimbae oiporara. Erei taɨcue rupi ocho aña reta oya jese. Jae rambue oiporara yae. Jae ramiño vi oyeapota añave yogüɨreco vae icavi mbae vae oyapo vae reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jare Jesús imiari rambueve joco pe ñogüɨnoi vae reta pe, Jesús ichɨ jare tɨvɨ reta yogüeru ovae jae oia pe, jare oñemboɨ ñogüɨnoi o icatu pe. Jae reta oipota imiari Jesús ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jayave metei joco pe oi vae jei Jesús pe: —¡Aipo! Ndesɨ jare nderɨvɨ reta oñemboɨ ñogüɨnoi icatu pe. Oipota imiari nde ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Erei Jesús jei chupe: —¿Quia nunga pa co jae chesɨ jare cherɨvɨ reta? ");
INSERT INTO guiNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jayave oupi ipo jemimboe reta cotɨ, jare jei: —Cuae nunga reta co jae chesɨ jare cherɨvɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Echa opaete cheRu ara pe oi vae jemimbota oyapo vae reta co jae cherɨvɨ, jare chereindɨ, jare chesɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jocuae ara Jesús oe o güi ojo oguapɨ ɨ guasu jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jare jeta yae vae oñemboatɨ Jesús oia pe. Jae rambue Jesús oyeupi metei chalana ɨ guasu pe oi vae pe, jare oguapɨ pɨpe. Jare yatɨ vae reta oñemboɨ ñogüɨnoi ɨ guasu jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jare Jesús imiari chupe reta jeta mbaembae re omojaanga reve. Jei chupe reta: —Metei cuimbae ojo omaetɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Omaetɨ yave, omoai temitɨ, jare amogüe oa tape rupi. Jayave yogüeru güɨra reta opa jou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iru temitɨ oa mbovɨño ɨvɨ ita guasu iárambue oia pe. Cuae ɨmambae oe, mbaeti jeta ɨvɨ chupe rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Erei cuaraɨ jasɨ yave, ipiru. Jare japo mbaeti icavi rambue, otini —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iru temitɨ oa ñanapɨte pe. Ñana ocuacuaa yave, ombopɨtupa temitɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jare iru temitɨ oa ɨvɨcavi pe. Cuae reta ocuacuaa cavi jare ia. Amogüe jeta yae jaɨ, jare iru jeta jaɨ, jare iru mbovɨ catu jaɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ipuere oendu vae toyeapɨsaca cuae re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jayave Jesús jemimboe reta yogüeru oparandu chupe: —¿Maera pa nemiari chupe reta remojaanga reve? ");
INSERT INTO guiNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jayave Jesús jei chupe reta: —Amombeu ma peve mboroocuaia ara pegua regua. Cuae mbaeti oyecuaa iru vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Echa güɨnoi vae pe oñemoiruta, jeta yae güɨnoi vaera. Erei mbaeti güɨnoi vae güi michi yae güɨnoi vae oyeequita —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jae rambue chemiari chupe reta amojaanga reve, agüɨye vaera oecha cavi, yepe tei omae, jare agüɨye vaera oicuaa, yepe tei oendu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jare oyeapo chupe reta Tumpa iñee aracae omombeu vae Isaías jeigüe vae. Echa jae jei corai: Peenduta, erei ngaraa peicuaa. Pemaeta, erei ngaraa peecha —jei Tumpa—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Echa cuae reta ipɨatanta ma, jare mbaeti ipuere oyeapɨsaca iyapɨsa pe, jare osapɨmi, agüɨye vaera oecha jesa pe, jare agüɨye vaera oendu iyapɨsa pe, jare agüɨye vaera oicuaa ipɨa pe, jare agüɨye vaera oyerova checotɨ, jare agüɨye vaera ambogüera —jei Tumpa. Jocorai jei Isaías —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Erei Tumpa pemovendise ma. Echa pe reta peecha peresa pe, jare peyeapɨsaca peapɨsa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Añete che jae peve, jeta Tumpa iñee aracae omombeu vae reta jare jupi vae reta oipota tei oecha pe reta peecha ma vae, erei mbaeti oecha. Jae ramiño vi jae reta oipota tei oendu pe reta peendu ma vae, erei mbaeti oendu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Amombeu ma peve amojaanga reve cuimbae omaetɨ vae. Jae rambue peyeapɨsaca ye jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oime yave quia oyeapɨsaca Tumpa iporoocuaia re vae, mbaeti yave oicuaa cavi oendu vae, ou voi jocuae icavi mbae vae jare omoacañɨ Tumpa iñee güi. Amojaanga cuae nunga re temitɨ tape rupi oa vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jae ramiño vi jocuae temitɨ oñeotɨ mbovɨño ɨvɨ ita guasu iárambue oia pe vae oñemojaanga iru vae reta Tumpa iñee oendu vae re. Jupiveiño oyerovia reta, jare oipota yae cuae ñee —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Erei cuae reta jocuae temitɨ japo mbaeti icavi vae rami co. Jae rambue ɨmambae icuérai reta. Mbaesusere oyeapo chupe reta ani iru vae reta oyapo icavi mbae vae chupe reta Tumpa iñee jeco pegua. Jare jupiveiño mbaeti oipota reta oyeapɨsaca Tumpa iñee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jae ramiño vi jocuae temitɨ oñeotɨ ñanapɨte pe vae oñemojaanga iru vae reta Tumpa iñee oendu vae re. Erei jae reta omboɨpɨ oñemambeco ɨvɨ pe oyeapo vae re, jare oñembotavɨ oipota yae oicocatu vaera rambue. Jare opaete cuae omoacañɨ reta Tumpa iñee güi. Jae rambue jae reta jocuae temitɨ mbaeti ia vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Erei jocuae temitɨ oñeotɨ ɨvɨcavi pe vae oñemojaanga iru vae reta Tumpa iñee oendu vae re. Cuae reta oicuaa cavi Tumpa iñee. Amogüe vae jocuae temitɨ jeta yae jaɨ vae rami co. Iru vae reta jocuae temitɨ jeta jaɨ vae rami co. Jare iru vae reta jocuae temitɨ mbovɨ catu jaɨ vae rami co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús imiari ye yatɨ vae reta pe omojaanga reve. Jei chupe reta: —Mboroocuaia ara pegua metei cuimbae temitɨ icavi vae ico pe oñotɨ vae rami co. ");
INSERT INTO guiNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Erei opaete vae oque rambueve, cuimbae jovaicho ou oñotɨ trigo-raanga trigo ipɨte rupi, jare ojo ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo ocuacuaa jare ia. Erei ocuacuaa vi trigo-raanga trigo ipɨte rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jae rambue co iya jembiócuai reta yogüeru iya pe jei chupe: Oreya, ¿mbaeti pa reñotɨ trigo icavi vae ndeco pe? ¿Maera pa ocuacuaa trigo-raanga? —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jayave iya jei chupe reta: Metei cherovaicho oñotɨ. Jayave jembiócuai reta jei ye chupe: ¿Reipota pa rojo vaera roequi trigo-raanga? ");
INSERT INTO guiNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Erei iya jei: Agüɨye peequi. Echa peequi yave trigo-raanga, güɨramoi peequita vi trigo trigo-raanga ndive —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tocuacuaa pave mócoi reve trigo yaarɨvo regua. Jare yaarɨvo yave, jaeta oarɨvo vae reta pe: Pemboatɨ rani trigo-raanga peyocua peapɨ vaera. Erei pemboatɨ trigo jɨru pe —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús imiari ye yatɨ vae reta pe omojaanga reve. Jei chupe reta: —Mboroocuaia ara pegua metei mostaza jaɨgüe cuimbae güɨraja oñotɨ ico pe vae rami co. ");
INSERT INTO guiNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cuae jaɨgüe michi yae opaete iru temitɨ reta jaɨgüe güi. Erei ocuacuaa ma yave, tuicha yae opaete iru temitɨ metei año peguaño ocuacuaa vae reta güi. Oyeapo metei ɨvɨra. Jae rambue güɨra reta ipuere oyapo jaitɨra jaca reta re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús imiari ye yatɨ vae reta pe omojaanga reve. Jei chupe reta: —Mboroocuaia ara pegua levadura rami co. Cuña omboyea levadura jeta catu trigo iachi ndive, levadura oñemoai vaera opaete achi rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Opaete cuae jei Jesús yatɨ vae reta pe omojaanga reve. Jare imiari chupe reta ñavo, imiari chupe reta omojaanga reve, ");
INSERT INTO guiNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","oyeapo vaera Tumpa iñee aracae omombeu vae jeigüe vae. Echa jei corai: Chemiarita amojaanga reve. Amombeuta ɨvɨ oyeapo güive mbaeti oyecuaa vae. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jayave Jesús omondo ye yatɨ vae reta, jare oique o pe. Jare Jesús jemimboe reta yogüeru jei chupe: —Remombeu ma oreve remojaanga reve jocuae co trigo-raanga ocuacuaa pɨpe vae. Emombeu oreve mbae oipota jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jayave Jesús jei chupe reta: —Temitɨ icavi vae oñotɨ vae oñemojaanga che cuimbaera ayeapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jocuae co oñemojaanga opaete ɨvɨ re. Trigo icavi vae oñemojaanga Tumpa iporoocuaia pegua reta re. Erei trigo-raanga oñemojaanga icavi mbae vae oyapo vae reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jocuae co iya jovaicho trigo-raanga oñotɨ vae oñemojaanga aña guasu re. Mbaarɨvo oñemojaanga cuae ara reta iyapɨ re. Ombaarɨvo vae reta oñemojaanga araɨgua reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jocuae trigo-raanga oñemboatɨuca jare ócai tata pe. Jae ramiño vi jocoraita oyeapo cuae ara reta iyapɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Che cuimbaera ayeapo vae ambouta araɨgua cheve oyeócuai vae reta, jare jae reta omboatɨta opaete iyoa vae reta jare icavi mbae vae oyapo vae reta, omombo reta vaera cheporoocuaia güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jare omombo retata tata guasu pe. Joco pe jae reta oyaeota jare jai omboquɨrɨrɨuta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jayave jupi vae reta oyecuaata Tu iporoocuaia pe cuaraɨ oesape rami. Ipuere oendu vae toyeapɨsaca cuae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mboroocuaia ara pegua metei mbae icavi vae co pe oñemi vae rami co. Echa metei cuimbae ovae yave jocuae mbae icavi vae, oñomi ye, jare oyerovia reve ojo omee corepoti re opaete imbaembae ogua vaera jocuae co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mboroocuaia ara pegua metei omaemee vae ita ipora yae vae reta oeca vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ovae yave metei ita ipora yae vae jepɨ yae vae, ojo omee corepoti re opaete imbaembae ogua vaera jocuae ita ipora yae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mboroocuaia ara pegua metei pɨsa rami co. Echa cuimbae reta omombo pɨsa ɨ guasu pe omboa vaera oipotagüe jevae ɨ rupigua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jare pɨsa tɨnɨe ma yave, cuimbae reta güeru ɨ guasu jembeɨ pe. Jayave oguapɨ joco pe jare omboatɨ omboɨru jevae ɨ rupigua icavi vae reta jɨru reta pe, erei omombo jevae ɨ rupigua icavi mbae vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jae ramiño vi jocoraita oyeapo cuae ara reta iyapɨ pe. Araɨgua reta yogüeruta jare omboatɨta icavi mbae vae oyapo vae reta omombo vaera jupi vae reta ipɨte güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jare omombo retata tata guasu pe. Joco pe jae reta oyaeota jare jai omboquɨrɨrɨuta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jayave Jesús oparandu chupe reta: —¿Peicuaa cavi ma pa opaete cuae? —Roicuaa cavi, oreYa —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jayave Jesús jei ye chupe reta: —Mboroócuai re oporomboe vae mboroocuaia ara pegua re oñemboe vae ñavo metei o iya rami co. Echa o iya omee jo pegua reta pe mbaembae ipɨau vae jare mbaembae indechi vae jo pe oñovatu vae güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jare Jesús opa ma yave cuae jei omojaanga reve, ojo ye joco güi. ");
INSERT INTO guiNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jare ojo ovae yave iɨvɨ ae pe, oporomboe judío reta itupao pe, jare oyeapɨsaca jese vae reta ipɨacañɨ jare jei: —¿Quiape ra oñemboe cuae cuimbae iyaracuaa catu vaera? ¿Quia ra omee chupe mbaepuere cuae mɨacañɨ reta oyapo vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jae co carpintero taɨ. Jae co María imembɨ. Jae co Jacobo jare José jare Simón jare Judas tɨqueɨ —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jare opaete jeindɨ reta yogüɨreco ñanerenta pe. Jae rambue ¿quirai ra ipuere oyapo opaete cuae? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jae rambue jae reta pochɨ Jesús pe. Jayave Jesús jei chupe reta: —Opaete vae omboete metei Tumpa iñee omombeu vae. Jaeño jentaɨgua reta jare jo pegua reta mbaeti omboete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jare joco pe mbaeti ipuere oyapo jeta mɨacañɨ reta jae reta mbaeti güɨrovia jese rambue. ");
INSERT INTO guiNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jare jocuae ara reta pe mburuvicha guasu Herodes oendu Jesús regua. ");
INSERT INTO guiNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jare jei jembiócuai reta pe: —Jae co Juan oporombobautizase vae. Oicove ye ma co ou omanogüe vae reta ipɨte güi. Jae rambue oyapo cuae mɨacañɨ reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Echa ndei Juan omano mbove, Herodes oipɨɨuca Juan jare oñonouca tembipɨɨrɨru pe, Herodías oipota rambue. Herodías co jae Herodes tɨvɨ Felipe jee vae jembireco. ");
INSERT INTO guiNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Echa tenonde yave Juan jei Herodes pe: Agüɨyeta tei remenda nderɨvɨ jembireco ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jae rambue Herodes oipota tei oyucauca Juan. Erei oquɨye tenta pegua reta güi. Echa jae reta güɨrovia Juan co jae metei Tumpa iñee omombeu vae. ");
INSERT INTO guiNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erei Herodes omboarete oaa yave, Herodías imembɨ cuña ou opɨrae arete iyapoa reta ipɨte pe jare omboyerovia Herodes. ");
INSERT INTO guiNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jayave Herodes jei Tumpa jee re omeeta co cuñatai pe oipotagüe oyerure chupe jese vae. ");
INSERT INTO guiNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jayave cuñatai jei Herodes pe: —Emee cheve cuae pe etei Juan oporombobautizase vae iñaca metei ñae pe. Echa cuñatai ichɨ omombeu ma chupe jocorai jei vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jayave mburuvicha guasu ipɨatɨtɨ yae. Erei Tumpa jee re jei chupe rambue, jare iru vae reta oendu rambue, omondo sundaro Juan iñaca güeru vaera omee chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jayave ojo sundaro tembipɨɨrɨru pe oiñacasɨa Juan. ");
INSERT INTO guiNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jayave güeru iñacagüe metei ñae pe, jare omee cuñatai pe. Jayave cuñatai güɨraja omee ichɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jare Juan jemimboe reta yogüeru güɨraja jetegüe oñotɨ. Jayave yogüɨraja omombeu Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jare Jesús cuae oendu yave, ojo metei chalana pe mbaeti quia oicoa pe. Erei jeta yae vae oicuaa yave, yogüɨraja ɨvɨ rupiño tenta reta güi Jesús ojoa pe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús ogüeyɨ yave chalana güi, oecha jeta yae vae, jare oiparareco reta. Jayave ombogüera imbaerasɨ vae joco pe ñogüɨnoi vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Caaru ma yave, Jesús jemimboe reta yogüeru jei chupe: —Mbaeti quia oico cuae pe, jare caaru ma co. Emondo cuae jeta yae vae, yogüɨraja vaera tenta reta pe. Joco pe togua jembiura —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Erei Jesús jei chupe reta: —Agüɨye toyogüɨraja. Pe reta pemee tocaru —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Jaeño oime cuae pe rogüɨnoi cinco mbɨyape jare mócoi jevae ɨ rupigua —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Peru cheve cuae pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jayave Jesús oyócuai jocuae jeta yae vae oguapɨ vaera capiata re. Jayave oipɨɨ jocuae cinco mbɨyape jare mócoi jevae ɨ rupigua, jare omae ara re, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape reta, jare omee jemimboe reta pe, jae reta omee vaera yatɨ vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Opareve ocaru, jare jɨvata. Jayave Jesús jemimboe reta omboatɨ tembíu oñepɨsaegüe jembɨre vae, jare omotɨnɨe doce canasta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jare ocaru vae reta güi cuimbaegüeño oyepapa cinco mil rupi. Mbaeti oyepapa cuña reta jare michia reta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jare jupiveiño Jesús oyócuai jemimboe reta oyeupi vaera chalana pe, jare yogüɨraja vaera jenonde ɨ guasu jovaicho pe, jae omondo rambueve yatɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jare opa omondo yave yatɨ vae reta, Jesús oyeupi ɨvɨtɨ re oyerure vaera Tumpa pe. Jare pɨtu ma yave, jaeño Jesús joco pe oi. ");
INSERT INTO guiNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Erei chalana ojo ma ovae ɨ guasu mbɨte pe. Yavai yae Jesús jemimboe reta güɨroata vaera. Echa tuicha yae ɨaparúa jare ɨvɨtu tanta oovaiti. ");
INSERT INTO guiNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jare coe seri ma yave, Jesús oguata ojo ɨ iárambue oupitɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jare Jesús jemimboe reta oecha yave oguata ou ɨ iárambue, ipɨacañɨ yae. Jei reta: —Metei mbae iagüe co. Osapúcai reta oquɨye güi. ");
INSERT INTO guiNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Erei jupiveiño Jesús ombou iñee chupe reta. —Peñemoatangatu. Che co. Agüɨye pequɨye —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jayave Pedro jei chupe: —CheYa, jae co nde yave, cheócuai aguata vaera aja ɨ iárambue ndecotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Eyu —jei Jesús chupe. Jayave Pedro ogüeyɨ chalana güi, jare omboɨpɨ oguata ɨ iárambue ojo vaera Jesús cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Erei oecha yave quirai ɨvɨtu tanta chupe, Pedro oquɨye. Jayave omboɨpɨ osacambu, jare iñeeata reve jei: —CheYa, cherepɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jupiveiño Jesús oupi ipo jare oipɨɨ Pedro. Jayave jei chupe: —Michi yae ndeporogüɨrovia. ¿Maera pa mbaeti rerovia cheré? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jare oyeupi reta yave chalana pe, opɨta ɨvɨtu. ");
INSERT INTO guiNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jare chalana pe ñogüɨnoi vae reta omboete Jesús. Jei reta: —Añete co, nde co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jare ɨ guasu oasa reta yave, yogüɨraja ovae ɨvɨ Genesaret pe. ");
INSERT INTO guiNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jare joco pegua reta oicuaa jae co Jesús. Jae rambue jae reta yogüɨraja opaete jocuae ɨvɨ rupi, jare güeru Jesús oia pe opaete imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jare güeru vae reta oyerure Jesús pe imbaerasɨ vae reta oyavɨquɨ vaera jemimonde jembeɨ yepe. Jare opaete jemimonde oyavɨquɨ vae reta ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jayave fariseo reta jare mboroócuai re oporomboe vae reta yogüeru Jerusalén güi Jesús oia pe jare jei chupe: ");
INSERT INTO guiNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Maera pa neremimboe reta mbaeti oyapo ñanetenondegua reta iporomboe? ¿Maera pa ocaru reta oyepoe mbae reve? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jayave Jesús jei chupe reta: —¿Maera pa pe reta peyavɨ Tumpa iporoócuai peyapo vaera ñanetenondegua reta iporoócuai? ");
INSERT INTO guiNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tumpa oporoócuai corai: “Eaɨu nderu jare ndesɨ”. Jare oporoócuai ye corai: “Jei icavi mbae vae tu ani ichɨ cotɨ vae omanota co”. Jocorai oporoócuai Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Erei pe reta pere corai: Metei vae ipuere jei tu jare ichɨ pe omeeta tei chupe reta omborɨ vaera vae omee ma Tumpa pe. Jocorai pere —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jare jocorai mbaeti omborɨ tu jare ichɨ. Jocorai pe reta pemombo Tumpa iporoócuai peyeugüi peyapo vaera ñanetenondegua reta iporoócuai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pe reta co jae oporombotavɨ vae reta. Añete yepe Isaías imiari pe reta re. Echa jae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Cuae reta chemboete imiari yave —jei Tumpa—. Erei ipɨa pe mbaeti etei chemboete. ");
INSERT INTO guiNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chemboete-raangaiño. Oporomboe cuimbae iporoócuai re. Che mbaeti jocorai aporoócuai —jei. Jocorai jei Isaías —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jare Jesús oeni opaete joco pe ñogüɨnoi vae reta. —Peyeapɨsaca cuae re, peicuaa cavi vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oipotagüe mbae peu vae mbaeti ipuere omonguɨa pepɨa. Jocuae pere vae omonguɨa pepɨa —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jayave Jesús jemimboe reta yogüeru jei chupe: —¿Reicuaa pa fariseo reta pochɨ co ndeve jocuae rere chupe reta vae re? ");
INSERT INTO guiNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jayave Jesús jei chupe reta: —Opaete temitɨ reta cheRu ara pe oi vae mbaeti oñotɨ vae oyeequita co. ");
INSERT INTO guiNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pemaeño jese reta. Echa jae reta jesa mbae vae reta oechauca ñogüɨnoi tape iru jesa mbae vae reta pe vae rami co. Jare jesa mbae vae oechauca yave tape iru jesa mbae vae pe, mócoi reve oasavita ɨvɨcua pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jayave Pedro jei Jesús pe: —Emombeu oreve mbae oipota jei cuae remojaanga reve rere vae. ");
INSERT INTO guiNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jayave Jesús jei chupe reta: —Pe reta vi ¿mbaeti pa peicuaa? ");
INSERT INTO guiNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Peicuaa cavi cuae: Oipotagüe mbae peu vae oique perɨe pe, jare pemombo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Erei pere vae omonguɨa pepɨa. Echa pere vae ou pepɨa güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Echa pepɨa pe peñemongueta icavi mbae vae, peporoyuca, peñuvanga menda re, peyapo aguasa, pemonda, peapu iru vae reta re, icavi mbae vae pere iru vae reta cotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Cuae reta omonguɨa pepɨa. Erei pecaru yave peyepoe mbae reve, jocuae mbaeti omonguɨa pepɨa —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jayave Jesús ojo ye joco güi tenta reta Tiro jare Sidón iyɨ́vɨri ñogüɨnoia cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jare metei cuña ɨvɨ Canaán pegua oico joco pe. Jae ou Jesús oia pe jare iñeeata reve jei chupe: —CheYa, cheparareco. Nde co jae David Taɨ. Chemembɨ cuña oiporara yae oi. Echa metei aña oya ma jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Erei Jesús mbaeti mbae jei chupe. Jayave Jesús jemimboe reta yogüeru jei chupe: —Emondo jocuae cuña. Echa iñeeata ou ñanderaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jayave Jesús jei: —Tumpa chembou Israel pegua reta peño. Jae reta vecha ocañɨ vae reta rami co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jayave cuña ou oyeatɨca Jesús jóvai, jare jei chupe: —CheYa, chemborɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Erei Jesús jei chupe: —Mbaeti icavi yaequi vaera tembíu michia reta güi, ñamee vaera ñaɨmba-raɨ reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Añete tei co, cheYa —jei cuña Jesús pe—. Erei ñaɨmba-raɨ reta jou tembíu oñemonguigüe iya imesa güi oa vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jayave Jesús jei chupe: —Cuña, tuicha yae co ndeporogüɨrovia. Toyeapo ndeve nde reipota rupi —jei. Jare jupiveiño cuña imembɨ ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jayave Jesús ojo joco güi ovae ɨ guasu Galilea pe oi vae pe. Jayave oyeupi metei ɨvɨtɨ re, jare oguapɨ joco pe. ");
INSERT INTO guiNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jare jeta yae vae yogüeru jae oia pe. Jae reta güeru icocho vae reta, jare iporovaicho mbae vae reta, jare jesa mbae vae reta, jare iupa vae reta oñono Jesús jóvai. Jayave Jesús ombogüera reta. ");
INSERT INTO guiNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jae rambue joco pe yatɨ vae reta ipɨacañɨ. Echa oendu iupa vae reta iñee, jare oecha iporovaicho mbae vae reta ocuera, jare icocho vae reta oguata cavi, jare jesa mbae vae reta omae. Jare opaete vae omboete Israel pegua reta iTumpa. ");
INSERT INTO guiNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jayave Jesús oeni jemimboe reta jare jei chupe reta: —Aiparareco cuae yatɨ vae reta. Echa mboapɨ ara ma ñogüɨnoi che ndive, jare mbaeti mbae güɨnoi jou vaera. Ngaraa amondo reta ocaru mbae reve, agüɨye vaera ipɨtu tape rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jayave Jesús jemimboe reta oparandu chupe: —¿Quiraita pa ñandepuere ñamee mbɨyape cuae jeta yae vae pe cuae mbaeti quia oicoa pe, jae reta ocaru cavi vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jayave Jesús oparandu chupe reta: —¿Mbovɨ mbɨyape pa penoi? —Oime rogüɨnoi siete, jare mbovɨ jevae ɨ rupigua reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jayave Jesús oyócuai yatɨ vae reta oguapɨ vaera ɨvɨ re. ");
INSERT INTO guiNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jayave oipɨɨ jocuae siete mbɨyape jare mbovɨ jevae ɨ rupigua, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape reta jare jevae ɨ rupigua reta, jare omee jemimboe reta pe, jae reta omee vaera yatɨ vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Opareve ocaru, jare jɨvata. Jayave Jesús jemimboe reta omboatɨ tembíu oñepɨsaegüe jembɨre vae, jare omotɨnɨe siete canasta. ");
INSERT INTO guiNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jare ocaru vae reta güi cuimbaegüeño oyepapa cuatro mil rupi. Mbaeti oyepapa cuña reta jare michia reta. ");
INSERT INTO guiNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jayave Jesús omondo yatɨ vae reta. Jayave oyeupi metei chalana pe, jare ojo ovae ɨvɨ Magdala pe. ");
INSERT INTO guiNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jare fariseo reta jare saduceo reta yogüeru Jesús oia pe, jare jei chupe oechauca vaera chupe reta mɨacañɨ ara güi. Echa jae reta oipota oicuaa oyapota ra mɨacañɨ chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Erei Jesús jei chupe reta: —Amo pe pɨtuta ma yave pe reta pere: Ara cavita co pɨareve. Echa pɨta co amapɨtu reta. ");
INSERT INTO guiNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jae ramiño vi amo pe neimbove yave pere: Ara pochɨta co cuae ara. Echa pɨta co amapɨtu reta jare ara oyeasoi oi —pere, jei—. Pe reta co jae oporombotavɨ vae reta. Echa ara re pemae yave, peicuaa mbae oyeapota vae. Erei mbaeti etei peicuaa mbae añave oyeapo oi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Añave yogüɨreco vae reta icavi mbae vae oyapo vae reta co. Mbaeti oporogüɨrovia. Jae rambue oipota ayapo vaera mɨacañɨ chupe reta. Erei jaeño oyeapota mbae Tumpa iñee aracae omombeu vae Jonás pe oyeapo vae rami, jae reta oicuaa vaera quia co che —jei. Jayave Jesús ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jare Jesús jare jemimboe reta oyeupi chalana pe yogüɨraja ɨ guasu jovaicho cotɨ. Jare ɨ guasu jovaicho pe yogüɨraja ovae yave ramo, Jesús jemimboe reta oicuaa iñacañɨ co güeru vaera mbɨyape. ");
INSERT INTO guiNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jare Jesús jei chupe reta: —Peñeandu fariseo reta jare saduceo reta ilevadura güi. ");
INSERT INTO guiNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jayave jemimboe reta jei oyoupe: —Cuae jei, mbaeti yaru mbɨyape rambue. ");
INSERT INTO guiNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús oicuaa mbae jei reta vae, jare jei chupe reta: —Michi yae co peporogüɨrovia. ¿Maera pa pemiari oyoupe mbaeti mbɨyape peru vae re? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mbaeti pa peicuaa vɨteri? ¿Mbaeti pa pemaendúa? Cue yave apɨsae cinco mbɨyape ocaru vaera cinco mil vae. Tembíu oñepɨsaegüe pemboatɨ yave, ¿mbovɨ canasta pa pemotɨnɨe? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jare siete mbɨyape apɨsae vi, ocaru vaera cuatro mil vae. Tembíu oñepɨsaegüe pemboatɨ yave, ¿mbovɨ canasta pa pemotɨnɨe? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Maera pa mbaeti peicuaa che jae peve vae? Che jae peve peñeandu vaera fariseo reta jare saduceo reta ilevadura güi. Mbaeti jae peve mbɨyape re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jayave ramo jemimboe reta oicuaa Jesús jei co chupe reta oñeandu vaera fariseo reta jare saduceo reta iporomboe güi, mbaeti mbɨyape ilevadura güi. ");
INSERT INTO guiNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jare Jesús coiño ma ojo ovae tenta Cesarea Filipo güi. Jayave oparandu jemimboe reta pe: —¿Quia pa co che cuimbaera ayeapo vae iru vae reta pe? ");
INSERT INTO guiNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jayave jae reta jei chupe: —Amogüe vae jei nde co jae Juan oporombobautizase vae, jare iru vae reta jei nde co jae Elías, jare iru vae reta jei nde co jae Jeremías ani iru Tumpa iñee aracae omombeu vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jayave Jesús oparandu ye chupe reta: —Erei ¿quia pa co che peve? ");
INSERT INTO guiNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jayave Simón Pedro jei chupe: —Nde co jae Cristo. Nde co jae Tumpa jecuaeño oico vae Taɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jayave Jesús jei Pedro pe: —Simón, nde co jae Jonás taɨ. Tumpa nemovendise ma. Echa cheRu ara pe oi vae oicuauca ndeve cuae. Mbaeti quia ye oicuauca ndeve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jare che jae ndeve, nde co jae Pedro. Jare che etei amomɨratata aiparavo vae reta, ipɨrata vaera metei o ita guasu iárambue oi vae ipɨrata rami. Jae rambue cañɨtei ngaraa ipuere jese reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jare ameeta ndeve mboroocuaia ara pegua illave reta. Jare oime yave mbae ɨvɨ pe reñapɨtita vae, Tumpa vi oñapɨtita ara pe. Jae ramiño vi oime yave mbae ɨvɨ pe reyorata vae, Tumpa vi oyorata ara pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jayave Jesús oyócuai jemimboe reta agüɨye vaera omombeu quia pe jae co Cristo. ");
INSERT INTO guiNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jare jocuae ara reta güive Jesús omombeu jemimboe reta pe quirai jae ojota co Jerusalén pe, jare quirai tenta pegua reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oiporaraucata co chupe, jare quirai jae oyeyucaucata, jare quirai mboapɨ ara rupi oicove yeta ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jayave Pedro güɨraja Jesús iru reta ipɨte güi, jare omboɨpɨ oñeengata chupe. Jei: —Tumpa tanemborɨ, cheYa. Agüɨye etei toyeapo ndeve cuae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Erei Jesús oyerova jare jei Pedro pe: —Ecua chegüi, Satanás. Reipota chemboavai. Echa nde reñemongueta rei ɨvɨ pegua reta oñemongueta rami, mbaeti Tumpa oñemongueta rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jayave Jesús jei jemimboe reta pe: —Oime yave quia oipota ojo cherupíe vae, tiñacañɨ iyeugüi, tovoɨ togüɨraja icurusu, jare tojo cherupíe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Oipota oñovatu jecove vae ngaraa ipuere oñovatu. Erei omoeterengata jecove chereco pegua vae oñovatuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Mbae ra omonganata quia, omongana yave opaete ɨvɨ pegua, erei mbaeti yave ipuere oñovatu jecove? ¿Mbovɨ ra omboepɨta quia ogua ye vaera jecove? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Echa che cuimbaera ayeapo vae ayu yeta cheRu imaemboete reve araɨgua cheve oyeócuai vae reta ndive. Jare jayave ameeta opaete vae pe oyapo vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Añete che jae peve, ndei amogüe cuae pe ñogüɨnoi vae reta omano mbove, cherechata che cuimbaera ayeapo vae cheporoocuaia pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis ara cuae jei güire, Jesús güɨraja Pedro jare Jacobo jare Juan - jae co Jacobo tɨvɨ - iru reta ipɨte güi metei ɨvɨtɨ ɨvate vae re. ");
INSERT INTO guiNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jare joco pe oyepoepɨ jae reta jóvai. Jova oesape cuaraɨ oesape rami, jare jemimonde tiasɨ yae jare oesape. ");
INSERT INTO guiNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jare oyecuaa chupe reta Moisés jare Elías imiari ñogüɨnoi Jesús ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jayave Pedro jei Jesús pe: —OreYa, icavi co ñai vaera cuae pe. Nde reipota yave, toroyapo cuae pe mboapɨ cuaraɨa yai pegua, metei ndeveguara, metei Moisés peguara, jare metei Elías peguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro imiari oi rambueve, amapɨtu oesape vae omocuaraɨa reta, jare amapɨtu güi oñeendu ñee. —Cuae co jae cheRaɨ. Aaɨu yae. Ayerovia yae jese. Peyeapɨsaca jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jare Jesús jemimboe reta cuae oendu yave, oa ɨvɨ re. Echa oquɨye yae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jayave Jesús ou oñono ipo jese reta jare jei: —Pepúa. Agüɨye pequɨye. ");
INSERT INTO guiNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jare omae reta ye yave, mbaeti ma oecha quia jae reta ndive, jaeño Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jare ɨvɨtɨ güi ogüeyɨ yogüeru rambueve, Jesús oyócuai reta: —Agüɨye pemombeu quia pe cuae peecha vae, ndei che cuimbaera ayeapo vae aicove ye ayu omanogüe vae reta ipɨte güi mbove. ");
INSERT INTO guiNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jayave jemimboe reta oparandu chupe: —¿Maera pa jei mboroócuai re oporomboe vae reta Elías rani co outa? ");
INSERT INTO guiNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Añete Elías rani co outa —jei Jesús—, jare opaete oyapocavita. ");
INSERT INTO guiNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Erei che jae peve, Elías ou ma co, jare Israel pegua reta mbaeti oicuaa. Jae rambue oyapo reta chupe jae reta oipota vae. Jae ramiño vi jae reta oiporaraucata cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jayave Jesús jemimboe reta oicuaa jae imiari oi chupe reta Juan oporombobautizase vae re. ");
INSERT INTO guiNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jare yogüeru ovae yave jeta vae ñogüɨnoia pe, metei cuimbae ou oovaiti Jesús. Oyeatɨca jae jóvai, jare jei chupe: ");
INSERT INTO guiNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—CheYa, eiparareco cheraɨ. Echa imbaerasɨ iñaca pe jare oiporara yae. Jeta vese ma oa tata pe. Oa vi ɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aru neremimboe reta pe ombogüera vaera tei, erei jae reta mbaeti ipuere —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jayave Jesús jei joco pe ñogüɨnoi vae reta pe: —Yavai yae pe reta cuae ɨvɨ pe peico vae peporogüɨrovia vaera. ¿Quirai regua ra apɨtata pe reta ndive? ¿Quirai regua ra cherosata peve? Peru cheve cuae pe jocuae cunumi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jayave Jesús oñeengata aña pe, jare aña ojo cunumi güi. Jare jupiveiño cunumi ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jayave Jesús jemimboe reta yogüeru Jesús oia pe oparandu chupe, jae retaño jae ndive ñogüɨnoi yave: —¿Maera pa ore mbaeti orepuere romondo aña? ");
INSERT INTO guiNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Mbaeti peporogüɨrovia rambue —jei Jesús chupe reta—. Añete che jae peve, güɨramoi peporogüɨrovia michi yae metei mostaza jaɨgüe michi yae rami. Erei jocuae nunga mborogüɨrovia penoi yave, pepuereta pere cuae ɨvɨtɨ pe: Ecua cuae güi epɨta joco pe, jare ojota co. Ngaraa mbae yavai peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Erei ngaraa pepuere pemondo cuae nunga aña, jaeño peyerure yave Tumpa pe peyecuacu reve tembíu güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jare Galilea pe ñogüɨnoi rambueve, Jesús jei jemimboe reta pe: —Che cuimbaera ayeapo vae metei vae chemoeterengata iru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jae reta cheyucata. Erei amano ma yave, mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei. Jayave jemimboe reta ipɨatɨtɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jare Capernaum pe yogüɨraja ovae yave, mburuvicha peguara ocovara vae reta yogüeru oparandu Pedro pe: —¿Omboepɨ pa pemboe vae mburuvicha ocovara vae? ");
INSERT INTO guiNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Omboepɨ co —jei Pedro chupe reta. Jare oique yave ñogüɨnoi metei o pe, Jesús oique Pedro jenonde jare jei chupe: —Simón, mburuvicha ɨvɨ pegua reta ocovara iru vae reta pe. ¿Ocovara reta vi pa taɨ reta pe ani iru vae reta peño? ¿Mbae pa reñemongueta cuae re? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Iru vae reta peño —jei Pedro. Jayave Jesús jei ye chupe: —Jae rambue taɨ reta mbaeti omboepɨ chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Erei agüɨye vaera yayapo icavi mbae vae echa chupe reta, ecua ɨ guasu pe emboa jevae ɨ rupigua. Eipɨɨ jare eipea iyuru. Joco pe revaeta metei corepoti. Eraja emee mburuvicha peguara ocovara vae reta pe cheveguara jare ndeveguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jayave jemimboe reta yogüeru jei Jesús pe: —¿Quia pa co jae tenondegua vae mboroocuaia ara pegua pe? ");
INSERT INTO guiNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jayave Jesús oeni metei michia, jare oñono jae reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Añete che jae peve, mbaeti yave peyerova Tumpa cotɨ jare peyeapo michia reta rami, ngaraa peique mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Oime yave quia oñemomichi cuae michia rami vae, jae oicota tenondegua vaera mboroocuaia ara pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jare oime yave quia omboresive cuae nunga michia chereco pegua vae, che co chemboresive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Oime michia cheré güɨrovia vae reta. Oime yave quia metei cuae nunga pe mbaeyoa oyapouca vae, icavita tei co iru vae reta oñapɨti vaera iyayu rupi metei ita tuicha vae ombaeso pɨpe vae, jae ipɨtupa vaera ɨ guasu pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Amogüe ɨvɨ pegua reta oiporara iru vae reta oyapouca chupe reta mbaeyoa rambue. Jecuaeño amogüe vae reta oyapouca mbaeyoa iru vae reta pe. Erei jocuae mbaeyoa oyapouca vae reta oiporarata vi co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jae rambue ndeporovaicho ani ndepɨrovaicho oyapouca mbaeyoa ndeve yave, eyasɨa emombo ndeyeugüi. Icavi co tecove opa mbae vae renoi vaera ndeporovaicho mbae reve ani ndepɨrovaicho mbae reve, tata guasu opa mbae vae pe mócoi ndepo reve ani mócoi ndepɨ reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jae ramiño vi nderesarovaicho oyapouca mbaeyoa ndeve yave, eequi emombo ndeyeugüi. Icavi co tecove opa mbae vae renoi vaera nderesarovaicho mbae reve, tata guasu pe mócoi nderesa reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Agüɨye peroɨro metei cuae nunga michia. Che jae peve, ara pe araɨgua oñangareco cuae nunga michia reta re vae reta jecuaeño ñogüɨnoi cheRu ara pe oi vae jóvai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Echa che cuimbaera ayeapo vae ayu amboasa vaera ocañɨ vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Peñemongueta cuae re. Oime yave metei cuimbae cien vecha güɨnoi vae, metei vecha ocañɨ yave, cuimbae oeya jocuae noventa y nueve vecha reta ojo ɨvɨtɨ reta rupi oeca ocañɨ vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jare ovae chupe yave, añete che jae peve, oyerovia yae jocuae vecha re noventa y nueve vecha mbaeti ocañɨ vae reta re güi. ");
INSERT INTO guiNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jae ramiño vi peRu ara pe oi vae mbaeti oipota cuae michia reta güi metei ave ocañɨtei vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jare nderɨvɨ iyoa yave ndecotɨ, ecua emombeu chupe oyapo vae regua mbaeti quia ye oicuaa reve. Jare nderɨvɨ oyeapɨsaca nderé yave, reñemoicavita jae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Erei mbaeti yave oipota oyeapɨsaca nderé, eraja nderupíe metei ani mócoi neirura, iru vae reta oicuaa vaera mócoi ani mboapɨ vae rupi mbae pere vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jare mbaeti yave oipota oyeapɨsaca jese reta, emombeu oporogüɨrovia vae reta pe. Erei nderɨvɨ mbaeti yave oipota oyeapɨsaca oporogüɨrovia vae reta re, emae jese metei judío mbae vae rami ani mburuvicha peguara ocovara vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Añete che jae peve, oime yave mbae ɨvɨ pe peñapɨtita vae, Tumpa vi oñapɨtita ara pe. Jae ramiño vi oime yave mbae ɨvɨ pe peyorata vae, Tumpa vi oyorata ara pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jare che jae ye peve, mócoi vae ɨvɨ pegua omboyovaque iñemongueta jei yave: Yayerure Tumpa pe jocuae re, cheRu ara pe oi vae oyapota chupe reta oyerure chupe jese vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Echa mócoi ani mboapɨ vae oñemboatɨ yave cheree re, joco pe etei ipɨte pe che aita —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jayave Pedro ou jei Jesús pe: —CheYa, cherɨvɨ iyoa yave checotɨ jeta vese, ¿mbovɨ vese pa cheɨrota chupe? ¿Siete vese pa? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jayave Jesús jei Pedro pe: —Che jae ndeve, neɨro chupe setenta vese siete, mbaeti siete veseño. ");
INSERT INTO guiNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Echa mboroocuaia ara pegua metei mburuvicha guasu jembiócuai reta pe ipía oipota ocovara vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mburuvicha guasu omboɨpɨ ocovara chupe reta yave, ou oñemboɨ jae jóvai metei jembiócuai jeta yae corepoti re ipía chupe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jocuae jembiócuai mbaeti etei ipuere omboepɨ. Jae rambue mburuvicha guasu oyócuai oñemee vaera corepoti re jembiócuai jare jembiócuai jembireco jare imichia reta jare opaete imbaembae, jembiócuai ipuere vaera omboepɨ chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jayave jembiócuai oyeatɨca mburuvicha guasu jóvai, jare jei chupe: Agüɨye ndepochɨ cheve. Ndepɨaguasu checotɨ yave, amboepɨta ndeve opaete —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jayave mburuvicha guasu oiparareco jocuae jembiócuai jare oyora. Iñɨro chupe ipía re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Erei jocuae tembiócuai oe mburuvicha guasu oia güi jare ovae iru tembiócuai mbovɨ yae corepoti re ipía chupe vae. Jayave oiyayupɨɨ jare jei chupe: Emboepɨ cheve ndepía. ");
INSERT INTO guiNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jayave jocuae iru tembiócuai oyeatɨca jae jóvai, jare oyerure chupe: Agüɨye ndepochɨ cheve. Ndepɨaguasu checotɨ yave, amboepɨta ndeve opaete —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Erei mbaeti oipota ipɨaguasu icotɨ. Omombo tembipɨɨrɨru pe opaete ipía omboepɨ regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jare iru tembiócuai reta oicuaa yave oyeapo vae, ipɨatɨtɨ yae, jare yogüɨraja omombeu mburuvicha guasu pe opaete oyeapo vae regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jayave mburuvicha guasu oeni jocuae jembiócuai, jare jei chupe: Nde co jae metei cherembiócuai icavi mbae vae. Che cheɨro ndeve opaete ndepía re, nde reyerure cheve jese rambue —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Maera pa mbaeti reiparareco jocuae iru cherembiócuai, che roparareco rami? —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jayave mburuvicha guasu pochɨ yae jembiócuai pe, jare oyócuai iru vae reta oiporarauca vaera chupe opaete ipía omboepɨ regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jae ramiño vi cheRu ara pe oi vae oyapota jocorai peve, mbaeti yave peɨro opaete pepɨa reve perɨvɨ iyoa pecotɨ vae pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jare Jesús opaete cuae jei ma yave, ojo Galilea güi Judea pe Jordán jovaicho pe. ");
INSERT INTO guiNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jare jeta yae vae yogüɨraja jaɨcue. Jayave Jesús ombogüera imbaerasɨ vae joco pe ñogüɨnoi vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yogüeru vi fariseo reta Jesús oia pe. Jae reta oipota tei oyavɨuca chupe. Jae rambue oparandu reta chupe: —¿Jupi pa cuimbae omombo vaera jembireco oipotagüe mbae jeco pegua? ");
INSERT INTO guiNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jayave Jesús jei chupe reta: —¿Mbaeti pa pemongueta Tumpa iñee pe quirai Tumpa oyapoɨpɨ yave, oyapo cuimbae jare cuña? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jare Tumpa jei corai: Jae rambue cuimbae oeyata tu jare ichɨ, jare ojota oico vaera jembireco ndive. Jare mócoi vae oyeapota metei ramiño. Jocorai jei Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jae rambue mbaeti ma mócoi vae rami. Yogüɨreco metei ramiño. Tumpa omoiru reta rambue, agüɨye quia tomboyao —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jayave fariseo reta jei ye chupe: —¿Maera pa Moisés oyócuai cuimbae oicuatía vaera tupapire jembireco omombo vae regua jembireco omombo vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Moisés omaeño peré pemombo vaera perembireco pepɨatanta rambue —jei Jesús—. Erei Tumpa oyapoɨpɨ yave, mbaeti jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jare che jae peve, metei cuimbae ipuere omombo jembireco, cuña aguasa oyapo yave. Erei cuña mbaeti yave oyapo aguasa, cuimbae omombo yave, oñuvanga co menda re omenda yave iru cuña ndive. Jae ramiño vi iru cuimbae omenda yave jocuae cuña oñemombouca vae ndive, jae vi oñuvanga menda re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jayave Jesús jemimboe reta jei chupe: —Jocorai yaveño cuimbae ipuere omombo jembireco, mbaeti icavi cuimbae omenda vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Erei Jesús jei chupe reta: —Amogüe vaeño ipuere oicuaa cuae che jae peve vae. Jaeño Tumpa omee oicuaa vaera vae reta ipuere oicuaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Echa amogüe vae oa güive ichɨ güi yogüɨreco eunuco retara. Jare amogüe vae yogüɨreco eunuco retara iru vae reta oapiao reta rambue. Jare amogüe vae yogüɨreco eunuco retara jae reta etei oyeapiaouca rambue. Jocorai oyapo reta mboroocuaia ara pegua jeco pegua. Oime yave quia ipuere oicuaa cuae, toicuaa —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jare amogüe vae güeru Jesús oia pe michia reta, Jesús oñono vaera ipo jese reta jare oyerure vaera Tumpa pe jese reta. Erei jemimboe reta oñeengata güeru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Erei Jesús jei: —Pemaeño michia reta re yogüeru vaera checotɨ. Echa cuae nunga oyeócuai Tumpa pe mboroocuaia ara pegua pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jayave oñono ipo jese reta. Jayave ojo joco güi. ");
INSERT INTO guiNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jare metei cuimbae ou jei Jesús pe: —Oporomboe vae, nde ndepɨacavi co. ¿Mbae nunga mbae icavi vae pa ayapota, anoi vaera tecove opa mbae vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jayave Jesús jei chupe: —¿Maera pa rere cheve: Ndepɨacavi co? Mbaeti quia ipɨacavi, jaeño Tumpa. Erei reipota yave renoi tecove opa mbae vae, eyapo mboroócuai reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Mbae nunga reta pa? —jei Jesús pe. Jayave Jesús jei ye chupe: —Agüɨye eporoyuca. Agüɨye eñuvanga menda re. Agüɨye nemonda. Agüɨye ndeapu iru vae reta re. ");
INSERT INTO guiNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Eaɨu nderu jare ndesɨ. Jare eaɨu iru vae nde reyeaɨu rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jayave cuimbae jei Jesús pe: —Mbaeti ayavɨ metei ave cuae mboroócuai reta chemichi güive. ¿Mbae pa oata cheve vɨteri ayapo vaera? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jayave Jesús jei chupe: —Reipota yave reyapo opaete icavi reyapo vaera vae, ecua emee opaete mbaembae renoi vae corepoti re, jare emee corepoti paravete vae reta pe, jare reicocatuta ara pe. Jayave eyu cherupíe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Erei cuae oendu yave, cuimbae ojo ipɨatɨtɨ reve. Echa jeta mbaembae güɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jayave Jesús jei jemimboe reta pe: —Añete che jae peve, yavai yaeta co oicocatu vae oique vaera mboroocuaia ara pegua pe. ");
INSERT INTO guiNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Che jae ye peve, yavai yaeta oicocatu vae oique vaera Tumpa iporoocuaia pe, maemɨmba camello jee vae yuu mi jesacua rupi oasa vaera güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesús jemimboe reta cuae oendu yave, ipɨacañɨ yae jare jei: —Jocorai yave, ¿quia pa ipuere oñemboasauca? ");
INSERT INTO guiNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jayave Jesús omae jese reta jare jei: —Ɨvɨ pegua reta mbaeti ipuere oñemboasa. Erei Tumpa ipuere omboasa reta. Echa Tumpa ipuere oyapo opaete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jayave Pedro jei chupe: —Mase, ore opaete mbae roeya, royu vaera nde ndive. ¿Mbae pa rogüɨnoita ore? ");
INSERT INTO guiNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jayave Jesús jei jemimboe reta pe: —Añete che jae peve, che cuimbaera ayeapo vae aguapɨta cheguapɨa pe añemboeteuca vaera, opaete oyeapocavi yave. Jae ramiño vi pe reta che ndive peyu vae peguapɨta doce guapɨa pe, jare pejaata doce atɨ Israel pegua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jare oime yave quia oeya jo, ani tɨqueɨ reta, ani tɨvɨ reta, ani jeindɨ reta, ani tu, ani ichɨ, ani jembireco, ani imichia reta, ani iɨvɨ reta chereco pegua vae, cien rupi jecoviata co chupe, jare güɨnoita imbaera tecove opa mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Erei Tumpa ombotaɨcueta oñemboete vae reta, jare omotenondeta oñemomichi vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Echa mboroocuaia ara pegua metei co iya rami co. Co iya oe neimbove asɨ oeca ico pe oparavɨquɨ vae retara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oparandu amogüe vae pe oparavɨquɨta ra chupe omboepɨ yave chupe reta metei denario ara, jare jae reta jei chupe oparavɨquɨta co chupe. Jayave co iya omondo reta ico pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jayave co iya oe ye cuaraɨ ɨvate catu mi yave, jare oecha iru vae reta oñemboɨ ñogüɨnoi maemeea pe. Mbaeti co jae reta iparavɨquɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jayave co iya jei chupe reta: Pe reta vi pecua peparavɨquɨ checo pe. Tamboepɨ peve jupi co amboepɨ peve vaera vae —jei, jei—. Jayave jae reta yogüɨraja co pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jayave co iya oe ye cuaraɨ ara mbɨte yave, jare omondo iru vae reta ico pe oparavɨquɨ vaera. Jae ramiño vi oe ye mboapɨ ora ma caaru yave, jare omondo ye iru vae reta ico pe oparavɨquɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jare co iya oe ye caaru yae yave, jare oecha iru vae reta oñemboɨ ñogüɨnoi mbaeti iparavɨquɨ rambue. Jayave jei chupe reta: ¿Maera pa pei cuae pe opaete ara peparavɨquɨ mbae reve? —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mbaeti quia oremombaravɨquɨ rambue —jei reta, jei—. Jayave co iya jei chupe reta: Pe reta vi pecua peparavɨquɨ checo pe. Tamboepɨ peve jupi co amboepɨ peve vaera vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cuaraɨ oique ma yave, co iya jei jembiócuai pe: Eeni oparavɨquɨ vae reta emboepɨ. Emboepɨ rani taɨcue rupi omboɨpɨ oparavɨquɨ vae reta pe, jare taɨcue rupi emboepɨ tenonde yave omboɨpɨ oparavɨquɨ vae reta pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jare co güi yogüeru ye yave caaru yae omboɨpɨ oparavɨquɨ vae reta, co iya jembiócuai omee metei ñavo pe metei denario —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jare neimbove asɨ omboɨpɨ oparavɨquɨ vae reta co güi yogüeru yave, oñemongueta tei co iya jembiócuai omboepɨta co chupe reta jeta yae caaru yae omboɨpɨ oparavɨquɨ vae reta pe omboepɨ vae güi. Erei co iya jembiócuai omboepɨ vi chupe reta metei denario iru reta rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jayave metei denarioño güɨnoi yave, iñeenguru co iya pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jae reta jei chupe: Cuae taɨcue rupi omboɨpɨ oparavɨquɨ vae reta metei oraño oparavɨquɨ. Erei nde remboepɨ chupe reta metei denario oreve remboepɨ rami, yepe tei ore roparavɨquɨ tanta cuaraɨ jasɨ yae reve —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Erei co iya jei metei vae pe: Cheamingo, mbaeti etei ayapo icavi mbae vae ndeve. Echa nde rere cheve reparavɨquɨta checo pe che amboepɨ ndeve yave metei denario —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ecua eraja cuae remongana vae. Aipota amboepɨ taɨcue rupi omboɨpɨ oparavɨquɨ vae pe metei denario ndeve amboepɨ rami —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Echa jupi co che ayapo vaera aipota vae chembaembae ndive. Agüɨye eñemoagüɨro cuae iru vae re che ayapo icavi vae chupe rambue —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jae ramiño vi Tumpa ombotaɨcueta oñemboete vae reta, jare omotenondeta oñemomichi vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jare Jesús Jerusalén cotɨ ojo rambueve, oeni jocuae doce jemimboe reta iru reta ipɨte güi, jare jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mase, yaja co Jerusalén cotɨ. Jare che cuimbaera ayeapo vae metei vae chemoeterengata sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta pe. Jae reta jeita amano vaera, ");
INSERT INTO guiNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jare chemoeterengata judío mbae vae reta pe. Jae reta cheyoyaita, chenupata chicote pe, jare checututa curusu re. Erei mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cuae jaɨcue rupi ou Jesús oia pe Jacobo jare Juan ichɨ. Jae co Zebedeo jembireco. Jacobo jare Juan vi yogüeru ichɨ ndive. Cuña oyeatɨca Jesús jóvai jare jei chupe oipota oyapo vaera mbae chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jayave Jesús oparandu cuña pe: —¿Mbae pa reipota? —Emaeño cuae mócoi chemembɨ re oguapɨ vaera ndeɨque pe reporoócuai yave, metei ndeacatu cotɨ jare iru ndeasu cotɨ —jei cuña chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Erei Jesús jei Jacobo jare Juan pe: —Mbaeti peicuaa mbae peyerure jese vae. ¿Pepuereta pa peiporara che aiporarata rami? ¿Pepuereta pa peñembobautizauca che añembobautizaucata rami? —jei. —Orepuereta co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Añete pe reta peiporarata che aiporarata rami, jare pe reta peñembobautizaucata che añembobautizaucata rami —jei Jesús chupe reta—. Erei mbaeti chepuere jae peve peguapɨ vaera cheɨque pe, metei cheacatu cotɨ, jare iru cheasu cotɨ. Echa cheRu omocatɨro ma joco pe oguapɨta vae reta peguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jare iru diez Jesús jemimboe reta cuae oendu, jare pochɨ reta Jacobo jare Juan pe. ");
INSERT INTO guiNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jayave Jesús oeni reta. —Peicuaa cavi co cuae —jei chupe reta—. Mburuvicha ɨvɨ pegua reta oporoócuai, jare mbaepuere güɨnoi vae reta jei iru reta pe mbae oyapo vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Erei pe reta agüɨye peyapo jocorai —jei—. Oime yave metei pepɨte pe oi vae oipota mbaepuere güɨnoi vae, toyeócuai iru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jare oime yave metei pepɨte pe oi vae oipota tenondeguara oico vae, toyeócuai iru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Echa che cuimbaera ayeapo vae ayu ayeócuai vaera iru vae reta pe. Mbaeti ayu iru vae reta oyeócuai cheve vaera. Ayu amano vaera, jeta vae aepɨ vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jare yogüɨraja yave tenta Jericó güi, jeta vae yogüɨraja Jesús jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jare mócoi cuimbae jesa mbae vae oguapɨ ñogüɨnoi joco pe tape jembeɨ pe. Jare oicuaa reta yave Jesús oasa co ojo, iñeeata reve jei reta: —OreYa, oreparareco. Nde co jae David Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jeta joco pe ñogüɨnoi vae reta oñeengata chupe reta. Oipota tei omoquirii. Erei jae reta iñeeata yae reve jei: —OreYa, oreparareco. Nde co jae David Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jayave Jesús opɨta jare oeniuca cuimbae jesa mbae vae reta. —¿Mbae pa peipota ayapo vaera peve? —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Toromae, oreYa —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jayave Jesús oiparareco reta jare oyavɨquɨ jesa. Jare jupiveiño mócoi reve ipuere omae, jare yogüɨraja Jesús jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jare coiño ma Jerusalén güi ñogüɨnoi yave, yogüɨraja ovae tenta Betfagé iyɨpɨ pe. Jayave ɨvɨtɨ Oliva jóvai ñogüɨnoi yave, Jesús oyócuai mócoi jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Pecua pea tenta ñanderóvai oi vae pe —jei—. Peo pevae yave, pevaeta metei mburica mi oñeapɨti oi, jare pevaeta vi mburica mi taɨrusu vae jae ndive. Peyora reta peru —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jare oime yave quia mbae jei peve, pere chupe: ÑandeYa oipota oiporu, erei ɨmambae güeruruca yeta cuae pe —pere, jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Opaete cuae oyeapo, Tumpa iñee aracae omombeu vae jeigüe vae oyeapo vaera. Echa jae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pemombeu Sion tayɨ pe: Mase, ndeRuvicha Guasu ou ndeve. Oñemomichi oi. Echa opo ou mburica mi re. Opo ou mburica mi taɨrusu vae re. Jocuae co mburica mi imembɨ. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jayave Jesús jemimboe reta yogüɨraja jare oyapo Jesús jei chupe reta oyapo vaera vae. ");
INSERT INTO guiNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jare güeru mburica mi jare mburica mi taɨrusu vae Jesús oia pe. Jayave Jesús jemimboe reta oñono iyasoya maemɨmba reta icupe re jare Jesús opo mburica mi taɨrusu vae re. ");
INSERT INTO guiNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jare jeta vae oipɨso iyasoya tape rupi mburica mi taɨrusu vae jenonde, jare iru vae reta oyasɨa ñanaroquɨ jare oñono tape rupi. ");
INSERT INTO guiNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jare Jesús jenonde yogüɨraja vae reta jare jaɨcue yogüɨraja vae reta iñeeata reve jei: —¡Hosanna! Cuae co jae David Taɨ. Toñemboeteuca ñandeYa jee re ou vae. Tei reta Hosanna ara pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jare Jesús ojo ma ovae yave Jerusalén pe, opaete Jerusalén pegua reta ipɨacañɨ reve jei: —¿Quia pa co jae? ");
INSERT INTO guiNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jare jeta vae jei: —Cuae co jae Jesús. Jae co metei Tumpa iñee omombeu vae Nazaret pegua. Nazaret Galilea pegua co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jayave Jesús oique Tumpa jo pe jare omoe joco güi opaete Tumpa jo pe omaemee vae reta jare ombaegua vae reta, jare omboyapara corepoti oipoepɨ vae reta imesa reta jare pɨcasu reta omee vae reta iguapɨa reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jare jei chupe reta: —Tumpa iñee pe oyecuatía oi corai: “Chero oñembojeeta o yerure pegua pe”. Jocorai oyecuatía oi. Erei pe reta peyapo ma imonda vae reta oñemia rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jare yogüeru Jesús oia pe Tumpa jo pe jesa mbae vae reta jare icocho vae reta, jare Jesús ombogüera reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oecha mɨacañɨ Jesús oyapo vae reta, jare oendu vi michia Tumpa jo pe ñogüɨnoi vae reta iñeeata reve jei: —¡Hosanna! Cuae co jae David Taɨ. Jae rambue jae reta pochɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jayave jei reta Jesús pe: —¿Reendu pa cuae reta jei vae? Jayave Jesús jei chupe reta: —Aendu co. ¿Mbaeti pa pemongueta cuae Tumpa iñee pe oyecuatía oi vae? Nde remee michia reta jare ocambu vɨteri vae reta pe nemboete vaera. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jayave Jesús oeya reta. Ojo Jerusalén güi Betania pe, jare joco pe oico. ");
INSERT INTO guiNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pɨareve pe neimbove yave Jesús ojo ye Jerusalén cotɨ, jare ñɨmbɨaɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jare oecha metei ɨva coiño tape güi. Jayave ojo omae jese, erei mbaeti ovae ia, jaeño joo. Jayave jei ɨva pe: —Ngaraa etei ma ndeía. Jare ɨmambae ɨva yɨpi. ");
INSERT INTO guiNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jare Jesús jemimboe reta oecha yave ɨva yɨpi vae, ipɨacañɨ jese jare jei: —Ɨmambae yae yɨpi jocuae ɨva. ");
INSERT INTO guiNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jayave Jesús jei chupe reta: —Añete che jae peve, peporogüɨrovia yave, pe reta vi pepuereta peyapo che ayapo ɨva pe vae rami. Erei peporogüɨrovia yave, pepuereta vi pere cuae ɨvɨtɨ pe: Pecua cuae güi peñemombo ɨ guasu pe, jare jocoraita oyeapo. Mbaeti yave pere pepɨa pe: Ngaraa ndipo oyeapo, oyeapota co peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jare oime yave mbae peipota vae, peyerure Tumpa pe jese. Jare perovia yave Tumpa omeeta co peve, penoita co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jare Jesús oique ye yave Tumpa jo pe, sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta yogüeru jae oia pe oporomboe rambueve, jare oparandu chupe: —¿Mbae nunga mbaepuere pa renoi cuae mbaembae reyapo vaera? ¿Quia pa omee ndeve mbaepuere cuae reyapo vaera? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jayave Jesús jei chupe reta: —Che vi taparandu peve mbae re. Pemombeu yave cheve, che vi amombeuta peve mbae nunga mbaepuere anoi cuae mbaembae ayapo vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Quia pa ombou Juan oporombobautiza vaera? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? —jei. Jayave jae reta jei oyoupe: —Yae yave: Tumpa co ombou, jae jeita ñandeve: Jocorai yave, ¿maera pa mbaeti perovia? —jei reta oyoupe—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Erei mbaeti ñandepuere yae: Ɨvɨ pegua reta co ombou. Echa yaquɨye tenta pegua reta güi. Echa opaete vae güɨrovia Juan co jae metei Tumpa iñee omombeu vae —jei reta oyoupe. ");
INSERT INTO guiNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jayave jei reta Jesús pe: —Mbaeti roicuaa. —Che vi ngaraa amombeu peve mbae nunga mbaepuere anoi cuae mbaembae ayapo vaera —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Quirai pa peñemongueta cuae re? Metei cuimbae güɨnoi mócoi taɨ reta. Ou jei metei taɨ pe: Cheraɨ, cuae ara ecua eparavɨquɨ checo pe. ");
INSERT INTO guiNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Taɨ jei chupe: Ngaraa aja aparavɨquɨ. Erei taɨcue rupi iquɨreɨ ojo. Jae rambue ojo oparavɨquɨ tu ico pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jare cuimbae jei iru taɨ pe: Cheraɨ, cuae ara ecua eparavɨquɨ checo pe. Taɨ jei chupe: Taja taparavɨquɨ, cheru. Erei mbaeti ojo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Quia nunga pa cuae mócoi vae güi oyapo tu jemimbota? —jei. Jayave jae reta jei chupe: —Jocuae tenonde voi tu oyócuai vae. Jayave Jesús jei chupe reta: —Añete che jae peve, mburuvicha peguara ocovara vae reta jare cuña aguasa rupi yogüɨreco vae reta oiqueta Tumpa iporoocuaia pe perenonde. ");
INSERT INTO guiNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Echa Juan ou oicuauca peve jupi vae, erei pe reta mbaeti perovia. Erei mburuvicha peguara ocovara vae reta jare cuña aguasa rupi yogüɨreco vae reta güɨrovia. Jare yepe tei cuae peicuaa, erei mbaeti peeya peñemongueta icavi mbae vae pepɨa pe oi vae. Jecuae peateɨ perovia Juan —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tamombeu ye peve amojaanga reve cuae: Oico metei cuimbae icora oiquese vae. Jayave oñotɨ pɨpe jeta uva. Jayave oyoo ɨvɨ, jare oyapo uva oitɨami pɨpe vaera. Oyapo vi metei chapapa, omae vaera ɨvate güi opaete co re. Jayave oiporuca ico iru vae reta pe, jae reta oñangareco vaera jese. Jayave co iya ojo mombɨrɨ ambué ɨvɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jare uva yagüɨye ma yave, co iya ombou amogüe jembiócuai reta co iporúa reta pe, jae reta omboyao vaera tei uva reta, iya güɨnoi vaera imbaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Erei co iporúa reta oipɨɨ co iya jembiócuai reta, jare oinupa metei vae, jare oyuca iru vae, jare oyapi ita pe iru vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jayave co iya ombou ye amogüe jembiócuai reta. Erei co iporúa reta jecuae jocorai oyapo ye chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jayave taɨcue rupi co iya ombou taɨ. Jei tei iyeupe: Güɨramoi omboeteta cheraɨ —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Erei co iporúa reta oecha yave co iya taɨ, jei reta oyoupe: Cuae co jae iyara vae. Yaja yayuca, jare ñande yaicota co iya retara —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jayave jae reta oipɨɨ co iya taɨ oyuca omombo co güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jae rambue co iya ou ye yave, ¿mbae ra oyapota jocuae co iporúa reta pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jayave jae reta jei Jesús pe: —Opata oyuca jocuae cuimbae icavi mbae vae reta, jare oiporucata ico ambué vae reta pe. Jae reta omeeta co iya pe imbaera uva yagüɨye ma yave —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jayave Jesús jei chupe reta: —¿Mbaeti pa pemongueta cuae Tumpa iñee pe oyecuatía oi vae? Ita o iyapoa reta omombo vae oyeapo ma ita tenondegua vae. ÑandeYa oyapo cuae. Yaecha ma, jare ñanepɨacañɨ jese. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Jae rambue che jae peve, pe reta ngaraa peico Tumpa iporoocuaia pe. Tumpa omeeta iru tenta pegua reta pe yogüɨreco vaera joco pe. Jae reta oyapota jupi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jare sacerdote reta itenondegua reta jare fariseo reta cuae oendu yave, oicuaa Jesús omojaanga reve jei vae oicuauca quirai jae reta teco güɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jare jae reta oipota tei oipɨɨ Jesús. Erei mbaeti ipuere. Echa oquɨye jeta vae güi. Echa jocuae jeta vae güɨrovia Jesús co jae metei Tumpa iñee omombeu vae. ");
INSERT INTO guiNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jare Jesús imiari ye joco pe ñogüɨnoi vae reta pe omojaanga reve. Jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Mboroocuaia ara pegua metei mburuvicha guasu rami co. Jocuae mburuvicha guasu taɨ omendata. Jae rambue mburuvicha guasu oyapo arete —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oparea ma amogüe vae pe yogüeru vaera oyapo arete. Jayave omondo jembiócuai reta oeni reta vaera. Erei jae reta ñateɨ yogüeru —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jayave mburuvicha guasu oyócuai ye iru jembiócuai reta. Jei chupe reta: Pecua pemombeu aparea chupe vae reta pe: Mase, ayapocavi ma peu vaera. Ayucauca ma chegüeye reta jare iru cherɨmba iquɨra vae reta. Opa ma ayapocavi opaete. Pecua arete pe —pere, jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Erei jae reta mbaeti oipota yogüɨraja. Metei vae ojo ico pe. Iru vae ojo omaemee. ");
INSERT INTO guiNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jare iru reta oipɨɨ mburuvicha guasu jembiócuai reta, oyapo icavi mbae vae chupe reta jare oyuca reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Erei mburuvicha guasu oendu yave cuae regua, pochɨ co. Jae rambue omondo isundaro reta opa vaera oyuca jocuae oporoyuca vae reta jare oapɨ vaera jenta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jayave mburuvicha guasu jei jembiócuai reta pe: Opaete oyeapocavi ma oi yayapo vaera arete. Erei aparea chupe vae reta mbaeti oyapo jupi vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jae rambue pecua tape reta rupi jare pere opaete pevae chupe vae reta pe yogüeru vaera arete pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jayave mburuvicha guasu jembiócuai reta yogüɨraja tape reta rupi jare omboatɨ opaete ovae chupe vae reta - icavi vae oyapo vae reta jare icavi mbae vae oyapo vae reta. Jare mburuvicha guasu jo tɨnɨe ma —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jare mburuvicha guasu ou ovae yave omae vaera yogüeru vae reta re, oecha joco pe metei cuimbae temimonde menda pegua mbaeti güɨnoi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jayave jei chupe: Cheamingo, ¿quirai pa reique cuae pe temimonde menda pegua mbae reve? Erei cuimbae mbaeti mbae jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jayave mburuvicha guasu jei jembiócuai reta pe: Peñapɨti ipo rupi jare ipɨ rupi, jare peraja cuae güi pemombo pɨtumimbi icatu pe oi vae pe. Joco pe oyaeota jare jai omboquɨrɨrɨuta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Echa Tumpa oeni jeta vae erei mbovɨño oiparavo —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jayave fariseo reta oñemboatɨ, jare oñomomiari quirai ipuere oyavɨuca Jesús pe jae imiari yave. ");
INSERT INTO guiNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jayave jae reta omondo jemimboe reta Jesús oia pe herodiano reta ndive. Jae reta jei Jesús pe: —Oporomboe vae, roicuaa nde rere vae añete co. Nde reporomboe cavi quirai Tumpa oipota yaico vaera vae re. Nde mbaeti reipoɨu oipotagüe vae güi. Mbaeti remboete metei vae iru vae güi —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jae rambue emombeu oreve, ¿quirai pa reñemongueta cuae re? César ñandeócuai ñamboepɨ vaera chupe corepoti pe. ¿Jupi pa ñamboepɨ vaera chupe? ani ¿mbaeti pa jupi? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Erei Jesús oicuaa jae reta oipota tei co oyapo icavi mbae vae chupe, jare jei chupe reta: —¿Maera pa peipota peyavɨuca cheve? Pe reta co jae oporombotavɨ vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Peechauca cheve corepoti mburuvicha guasu ocovara peve vae —jei. Jayave güeru reta chupe metei denario. ");
INSERT INTO guiNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jayave Jesús oparandu chupe reta: —¿Quia iagüe pa cuae? ¿Quia jee pa cuae oyecuatía oi vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Jocuae César imbae co —jei reta. Jayave Jesús jei chupe reta: —Pemee César pe César pegua, jare pemee Tumpa pe Tumpa pegua. ");
INSERT INTO guiNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cuae oendu reta yave, ipɨacañɨ yae reta jese. Jayave jae reta yogüɨraja Jesús güi. ");
INSERT INTO guiNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jare jocuae ara etei amogüe saduceo reta yogüeru Jesús oia pe. Opaete saduceo reta jei omanogüe vae reta mbaeti co oicove ye. Saduceo yogüeru vae reta jei Jesús pe: ");
INSERT INTO guiNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Oporomboe vae, Moisés jei oeya oreve corai: “Metei cuimbae tɨvɨ güɨnoi vae omano yave, jembirecogüe mbaeti imembɨ chupe yave, cuimbae tɨvɨgüe tomenda cuae cuña ndive. Jayave cuña imembɨ yave, cuimbae tombojee michia tɨqueɨ amɨri jee pe”. Jocorai jei Moisés —jei reta chupe—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oico orepɨte pe metei cuimbae seis tɨvɨ reta güɨnoi vae. Cuae cuimbae omenda, jare omano mbaeti omomembɨ reve. Cuimbae amɨri jaɨcuerigua omenda jembirecogüe ndive —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Erei jae vi omano mbaeti omomembɨ reve. Jae ramiño vi oyeapo jaɨcuerigua ye pe. Opaete siete reve omenda cuae cuña ndive, jare opaete siete reve omano mbaeti omomembɨ reve —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Taɨcue rupi cuña vi omano. ");
INSERT INTO guiNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jayave omanogüe vae reta oicove ye yave, ¿quia nunga vae jembirecora pa oicota cuae cuña? Echa opaete siete reve omenda jae ndive —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Erei Jesús jei chupe reta: —Pe reta peyavɨ co. Echa mbaeti peicuaa Tumpa iñee oyecuatía oi vae jare Tumpa imbaepuere —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Omanogüe vae reta oicove ye yave, cuimbae reta jare cuña reta ngaraa omenda. Yogüɨrecota araɨgua ara pe ñogüɨnoi vae reta rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tamombeu peve omanogüe vae reta regua. Oicove yeta co. ¿Mbaeti pa pemongueta Tumpa iñee pe oyecuatía oi vae? ");
INSERT INTO guiNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Echa oyecuatía oi corai: “Che co jae Abraham, Isaac, jare Jacob iTumpa —jei Tumpa”. Jocorai oyecuatía oi —jei—. Tumpa mbaeti co omanogüe vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jare yatɨ vae reta cuae oendu yave, ipɨacañɨ Jesús iporomboe re. ");
INSERT INTO guiNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Erei fariseo reta oicuaa yave saduceo reta mbaeti ma co mbae ipuere jei Jesús pe, amogüe jae reta oñemboatɨ Jesús oia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jayave metei fariseo - jae co metei mboroócuai re oporomboe vae vi - oparandu Jesús pe mbae re. Oipota tei oyavɨuca chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Jei chupe: —Oporomboe vae, ¿mbae nunga mboroócuai pa co jae tenondegua vae? ");
INSERT INTO guiNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jayave Jesús jei chupe: —Mboroócuai tenondegua vae co cuae: “Eaɨu ndeYa Tumpa opaete ndepɨa reve, opaete nderecove reve, jare opaete neñemongueta reve” —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Cuae co jae mboroócuai tenondegua vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jare jaɨcuerigua vae co cuae: “Eaɨu iru vae nde reyeaɨu rami” —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cuae mócoi mboroócuai reyapo yave, reyapo ma co opaete Moisés iporoócuai jeigüe jare Tumpa iñee aracae omombeu vae reta jeigüe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jare fariseo reta Jesús oia pe oñemboatɨ yave, Jesús oparandu chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Mbae pa peñemongueta Cristo re? ¿Quia taɨ pa co jae? —Jae co David Taɨ —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Jocorai yave, ¿maera pa David etei jei chupe: CheYa? Echa Espíritu Santo oicuauca David pe jocorai jei vaera —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Echa David jei corai: ÑandeYa jei cheYa pe: Eguapɨ cheɨque pe cheacatu cotɨ, nderovaicho reta opa añono ndepɨ igüɨ pe regua —jei ñandeYa. Jocorai jei David aracae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Quirai pa ipuere oico David Taɨra? Echa David etei jei chupe: CheYa —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jare mbaeti quia ipuere omombeu chupe. Jare jocuae ara güive mbaeti quia oipota oparandu Jesús pe mbae re. ");
INSERT INTO guiNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jayave Jesús jei jeta vae jare jemimboe reta pe: ");
INSERT INTO guiNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Mboroócuai re oporomboe vae reta jare fariseo reta omombeu peve Moisés iporoócuai reta. ");
INSERT INTO guiNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jae rambue jecuaeño peyapo jei reta peve peyapo vaera vae. Erei agüɨye peyapo oyapo reta rami. Echa jae reta etei mbaeti oyapo jei peve peyapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jae reta jei iru vae reta pe oyapo vaera yavai yae oyapo vaera vae. Ñamojaanga metei voɨta. Jae reta jei iru vae reta pe ovoɨ vaera metei voɨta ipoɨ yae vae. Erei jae reta mbaeti etei omborɨ ovoɨ vaera. Mbaeti etei oyavɨquɨ reta ivoɨta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mboroócuai re oporomboe vae reta jare fariseo reta mbae oyapo yave, oipota iru vae reta oecha vaera. Echa jae reta oñono iyee Tumpa iñee jɨru tuicha yae vae jare oyapo jemimonde ipucu yae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yogüɨraja yave itupao pe jare aretea pe, jecuaeño oipota yae oguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jare oipota yae iru vae reta oyapo vaera maraetei chupe reta omaemee vae reta ñogüɨnoia rupi jare jei vaera chupe reta: Oporomboe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Erei agüɨye peipota iru vae reta jei vaera peve: Oporomboe vae. Echa che co jae pomboe vae, jare opaete pe reta cherɨvɨ reta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jare agüɨye pere: CheRu, metei cuimbae ɨvɨ pegua pe. Echa meteiño co jae peRu, jare jae oico ara pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jare agüɨye peipota iru vae reta jei vaera peve: CheYa. Echa meteiño co jae peYa. Jae co che. Echa che co jae Cristo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Oime yave quia oipota tenondeguara oico vae, toyeócuai opaete iru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Echa oñemboete vae oñemomichiucata co. Jae ramiño vi oñemomichi vae oñemboeteucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jayave Jesús jei mboroócuai re oporomboe vae reta jare fariseo reta pe: —Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa pe reta peyopia iru vae reta agüɨye vaera oique mboroocuaia ara pegua pe. Pe reta etei mbaeti peique. Iru vae reta oipota tei oique, erei pe reta peyopia reta agüɨye vaera oique —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa pepɨro cuña imemano vae reta güi opaete imbaembae jare ipucu yae peyerure Tumpa pe peporombotavɨ vaera. Jae rambue peiporara yaeta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa peo peeca opaete ɨ guasu rupi jare ɨvɨ rupi pevae vaera metei pepuere pemoquɨreɨ peporomboe güɨrovia vaera vae. Jare güɨrovia yave peporomboe, jecuae pemboe mbaembae re. Jocuae jeco pegua jae oyeapo icavi mbae yae vaera. Icavi co pe reta peo vaera tata guasu pe. Erei jae omboasa ete oyapo rambue, icavi yae co jae ojo vaera joco pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Pe reta co jae jesa mbae vae oechauca ñogüɨnoi tape iru vae reta pe vae reta rami. Peiporarata co. Echa pe reta pere: Oime yave quia: Tumpa jo jee re ayapota, jei vae, jocuae mbaeti co mbae. Erei oime yave quia: Oro Tumpa jo pegua jee re ayapota, jei vae, oyapota co jocuae jei oyapota vae —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pe reta co jae jesa mbae vae reta rami. Pe reta mbaeti pearacuaa. Echa jocuae oro oñeñono tee Tumpa peguara, Tumpa jo pegua co rambueño. Jae rambue Tumpa jo oñemboeteuca yae jocuae oro Tumpa jo pegua güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jae ramiño vi pe reta pere: Oime yave quia: Maemɨmba oyeyucagüe oñererocuaveea jee re ayapota, jei vae, jocuae mbaeti co mbae. Erei oime yave quia: Mbota maemɨmba oyeyucagüe oñererocuaveea pe oi vae jee re ayapota, jei vae, oyapota co jei oyapota vae —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pe reta co jae jesa mbae vae reta rami. Pe reta mbaeti pearacuaa. Echa jocuae mbota oñeñono tee Tumpa peguara, maemɨmba oyeyucagüe oñererocuaveea pe oi rambueño. Jae rambue maemɨmba oyeyucagüe oñererocuaveea oñemboeteuca yae mbota güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jae rambue oime yave quia: Maemɨmba oyeyucagüe oñererocuaveea jee re ayapota, jei vae, opaete maemɨmba oyeyucagüe oñererocuaveea pe oi vae oñemoiru maemɨmba oyeyucagüe oñererocuaveea ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jae ramiño vi oime yave: Tumpa jo jee re ayapota, jei vae, Tumpa jo pe oico vae oñemoiru Tumpa jo ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jae ramiño vi oime yave quia: Ara jee re ayapota, jei vae, Tumpa oñemoiru ara ndive. Echa ara Tumpa iguapɨa co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa pemee Tumpa pe diezmo caavo reta penoi vae güi. Erei cuae michi yae. Mboroócuai jei peve peyapo vaera jeta yae cuae güi. Echa jei peve peyapo vaera jupi vae jare peporoparareco vaera jare peporogüɨrovia vaera. Mbaeti peyapo opaete cuae. Icavi co pemee vaera Tumpa pe jocuae nunga diezmo. Erei peyapota tei jupi vae jare peporopararecota tei jare peporogüɨroviata tei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pe reta co jae jesa mbae vae oechauca ñogüɨnoi tape iru vae reta pe vae reta rami. Pe reta peateɨ pemócoi metei ñeti, erei pemócoi metei camello —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Pe reta co taza jare ñae icatu rupiño oyeyoe vae rami. Erei pepɨa iquɨa yae co. Echa peipota iru vae reta imbaembae jare peyapo icavi mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pe reta co jae fariseo reta. Pe reta co jae jesa mbae vae reta rami. Peyoe rani pepɨa, taza jare ñae japɨpe rupi peyoe rami. Jayave icatu rupi vi oyeyoeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa pe reta co jae teogüerɨru oñemoti cavi vae reta rami. Jocuae nunga teogüerɨru ipora yae echa, erei japɨpe pe tɨnɨe omanogüe vae reta icagüegüe reta pe jare iquɨa yae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jae ramiño vi iru vae reta oñemongueta tei pe reta co jae jupi vae reta, erei pepɨa tɨnɨe tavɨ jare icavi mbae vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Pe reta co jae oporombotavɨ vae reta. Echa pe reta peyapo Tumpa iñee aracae omombeu vae reta iteogüerɨru reta, jare pemopora jupi vae reta iteogüerɨru reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jare pere: Ñande yaico yave mona ñanetenondegua reta yogüɨreco yave, ñande mbaetita tei ñamborɨ jae reta oyuca yave Tumpa iñee aracae omombeu vae reta —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jocorai pere rambue, peicuauca quirai pe reta co jae Tumpa iñee aracae omombeu vae reta oyuca vae reta iñemoña reta pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jae rambue icavi co pe reta peyapo vaera jae reta oyapo rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pe reta mboi reta rami co. Añete co, pe reta mboi reta iñemoña reta rami co. Ngaraa etei peyeepɨ Tumpa peraa yave peo vaera tata guasu pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Echa Tumpa jei: Amondota peve cheñee omombeu vae reta jare iyaracuaa catu vae reta jare cheporoócuai re oporomboe vae reta. Peicututa curusu re amogüe vae peyuca, jare peinupata chicote pe amogüe vae petupao reta pe jare peaɨcuemoña retata metei tenta güi iru tenta pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jare pe reta penoita teco opaete jupi vae reta imano re. Tenonde voi Abel oyeyucauca - jae co jupi vae - jare taɨcue rupi Berequías taɨ Zacarías jee vae oyeyucauca. Echa Zacarías omano maemɨmba oyeyucagüe oñererocuaveea jare Tumpa jo ipau pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Añete che jae peve, cuae reta jare opaete iru vae reta imano re pe reta añave peico vae peñemboecota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén pegua reta, pe reta peyuca Tumpa iñee aracae omombeu vae reta. Pe reta peyapi ita pe peyuca Tumpa ombou peve vae reta. Jeta vese ma chequɨreɨ tei pomboatɨ, uru omboatɨ imembɨ reta ipepo igüɨ pe rami, erei pe reta mbaeti peipota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mase, perenta oñemboaita. ");
INSERT INTO guiNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Che jae peve, ngaraa ma cherecha pere regua: Toñemboeteuca ñandeYa jee re ou vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jayave Jesús oe Tumpa jo güi. Jare jemimboe reta yogüeru oechauca Jesús pe opaete o Tumpa jo pe ñogüɨnoi vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jare Jesús jei chupe reta: —¿Pemae pa pei opaete cuae o reta re? Añete che jae peve, ngaraa opɨta metei ave ita iru ita iárambue. Opaete oyeitɨta co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jare Jesús oguapɨ oi rambueve ɨvɨtɨ Oliva re, jemimboe reta yogüeru jae oia pe jare jei chupe, jae retaño jae ndive ñogüɨnoi yave: —Emombeu oreve, ¿quirai yave pa cuae oyeapota? Jare reyu yeta ma yave, ¿quiraita pa roicuaa? Jare cuae ara reta opata ma yave, ¿quiraita pa roicuaa? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jayave Jesús jei chupe reta: —Peñeandu agüɨye vaera petavɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Echa yogüeruta jeta cheree pe oñembojeeta vae reta. Jae reta jeita: Che co jae Cristo. Jare ombotavɨta jeta vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Oimeta co ñoraro reta coiño pegüi. Oimeta vi ñoraro reta mombɨrɨ pegüi. Peendu yave cuae reta regua, agüɨye peñemambeco. Cuae susere reta oyeapota co. Erei cuae susere reta mbaetita co taɨcuegua vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Metei ɨvɨ pegua reta oñorarota ambué ɨvɨ pegua reta ndive, jare mburuvicha reta oñorarota iru mburuvicha reta ndive. Jare oimeta caruai reta jare ɨvɨ ocanata jeta que rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Erei cuae susere reta tenondeguaño co vɨteri —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jayave iru vae reta pemoeterengata oiporaraucata peve vae reta pe, jare peyeyucaucata. Jare peñemotareɨucata opaete vae pe chereco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jare jeta vae pochɨta oyoupe jare oñomoeterengata jare oñomotareɨta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jare jeta oporombotavɨ vae reta jeita: Che co jae metei Tumpa iñee omombeu vae. Jae rambue jae reta ombotavɨta jeta vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jare jeta vae oyapota icavi mbae vae. Jae rambue jeta tenonde yave oporoaɨu vae reta ngaraa ma oporoaɨu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Erei josa ojo ovae iyapɨ pe vae oñemboasaucata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jare cuae ñee icavi vae Tumpa iporoocuaia pegua jeracuata opaete ɨvɨ rupi opaete tenta pegua reta oicuaa vaera. Jayave cuae ara reta opata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jare peechata icavi mbae vae opaete güɨrocomegua vae oñemboɨ oi o oñeñono tee Tumpa peguara vae pe. Tumpa iñee aracae omombeu vae Daniel jei oimeta co joco pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jayave Judea pe ñogüɨnoi vae reta totecuarai ɨvɨtɨ reta ñogüɨnoia cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jare ovapɨa iárambue oi vae agüɨye toique jo pe güɨraja vaera imbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jare ico pe oi vae agüɨye tojo ye jo pe, güɨraja vaera iyasoya —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jare ipurúa vae reta jare omocambu vae reta oiporara yaeta jocuae ara reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jare peyerure Tumpa pe agüɨye vaera petecuarai ama oquɨ yave ani mbutuu iara pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Echa jocuae ara reta pe ɨvɨ pegua reta oiporara yaeta. Mbaeti jocorai oiporara reta ɨvɨ oyeapo güire, jare ngaraa ye jocorai oiporara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jare ñandeYa mbaeti yave oipota opa vaera jocuae ara reta, mbaetita tei quia ipuere oico. Erei Tumpa oiparavogüe vae reta jeco pegua opata jocuae ara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Güɨramoi jocuae ara reta pe quia jeita peve: Mase, co oi Cristo, ani jeita: Mase, pee oi Cristo. Jocorai jei yave, agüɨye perovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amogüe oporombotavɨ vae reta jeita: Che co jae Cristo, jare iru oporombotavɨ vae reta jeita: Che co jae Tumpa iñee omombeu vae. Jare jae reta oyapota mɨacañɨ reta, ombotavɨ vaera tei Tumpa oiparavogüe vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mase, amombeu ma peve, ndei oyeapo mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jayave iru vae reta jei yave peve: Mase, oime co ñuu pe oi, agüɨye pecua. Jare iru vae reta jei yave peve: Mase, oime co cuae o pe oi, agüɨye perovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tamojaanga amavera. Echa amavera oyecuaa opaete ara re cuaraɨ oea cotɨ güi cuaraɨ oiquea cotɨ pe. Jae ramiño vi che cuimbaera ayeapo vae ayecuaata opaete vae pe che ayu ye yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Omano vae reta ñogüɨnoia pe etei oñemboatɨ chucha reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jayave opa oiporara reta jocuae ara reta pe güire, cuaraɨ oñemopɨtumimbita, jare yasɨ ngaraa oesape, jare yasɨtata reta oata ara güi, jare opaete ara re mbaepuere güɨnoi vae reta ocanata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jayave mbae oyecuaata ara re. Jocuae oicuaucata ɨvɨ pegua reta pe che cuimbaera ayeapo vae ayu yeta co. Jayave opaete atɨ Israel pegua reta ipɨatɨtɨta jare cherechata ayu amapɨtu reta reve. Che cuimbaera ayeapo vae anoita mbaepuere tuicha vae jare añemboeteucata opaete vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jare amondota araɨgua cheve oyeócuai vae reta mimbɨ guasu iñee reve, jae reta güeru vaera aiparavogüe vae reta opaete ɨvɨ rupi güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ñandepuere ñamojaanga ɨva. Peñemboe jese —jei—. Joquɨ yave, peicuaa oyearo co ama oquɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jae ramiño vi pe reta peecha opaete cuae mbaembae oyeapo ñogüɨnoi yave, peicuaata che coiño yae ma co ai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Añete che jae peve, cuae tenta pegua reta ngaraa opa omano ndei opaete cuae mbaembae oyeapo mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ara jare ɨvɨ opata, erei cheñee ngaraa opa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Erei mbaeti quia oicuaa mbae ara ani mbae ora pe yepe cuae oyeapota, jaeño cheRu. Araɨgua ara pe ñogüɨnoi vae reta mbaeti oicuaa. Che co jae Tumpa Taɨ. Erei che vi mbaeti aicuaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé oico rambueve, ɨvɨ pegua reta oyapo icavi mbae vae. Jae ramiño vi che cuimbaera ayeapo vae ayu ye yave, ɨvɨ pegua reta oyapota icavi mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndei ɨporu guasu ou mbove, ɨvɨ pegua reta ocaruñoi jare ocauñoi, jare jecuaeño cuimbae reta omenda cuñatai reta ndive jare tu reta omee tayɨ reta cuimbae reta pe omenda jae ndive vaera. Erei metei ara Noé oique jocuae buque pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jare oyepocouca reta, ɨporu guasu ou yave. Jae rambue ɨporu guasu opa oyuca reta. Jocoraita vi oyeapo che cuimbaera ayeapo vae ayu ye yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jocuae ara mócoi cuimbae oimeta co pe ñogüɨnoi. Metei vae oyererajaucata jare iru vae opɨtata co pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jae ramiño vi mócoi cuña ombaesota ñogüɨnoi metei angúa pe. Metei vae oyererajaucata jare iru vae opɨtata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jae rambue jecuaeño peñemocatɨro. Echa mbaeti peicuaa mbae ara ayu yeta. Che co jae peYa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aipota peicuaa vaera cuae: Metei o iya oicuaa yave mbae ora pe outa ovae imonda vae oñomi vaera imbaembae jo güi, oñemocatɨrota tei jare ngaraa tei omaeño imonda vae re güɨraja vaera imbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jae ramiño vi pe reta peñemocatɨro. Echa che cuimbaera ayeapo vae ayu yeta avae mbaeti peñemongueta pei jese yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Metei tembiócuai iyaracuaa vae oyapo iya jei chupe oyapo vaera vae. Jare iya omee chupe oico vaera iru jembiócuai reta juvichara, jare omee vaera chupe reta jembiura ara ñavo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Iya ou ye ovae yave jo pe, oecha yave jocuae jembiócuai oyapo oi iparavɨquɨ, jocuae jembiócuai oyeroviata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Añete che jae peve, iya omeeta chupe oñangareco vaera opaete imbaembae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Erei güɨramoi tembiócuai oyapo icavi mbae vae jare jei iyeupe ipɨa pe: CheYa ngaraa ou ye raivi. ");
INSERT INTO guiNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jare omboɨpɨ oinupa iru tembiócuai reta, jare ocaru jare ocau osavaɨpo vae reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jayave metei ara iya ou yeta ovae jembiócuai oaro mbae reve. Jocuae ora pe etei iya oipocouta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jayave iya oiporarauca yaeta chupe jare omondota oico vaera opaete iru oporombotavɨ vae reta ndive. Joco pe jae reta oyaeota jare jai omboquɨrɨrɨuta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mboroocuaia ara pegua diez cuñatai cuimbae mbaeti etei güɨreco vae reta rami co. Cuñatai ñavo güɨraja ilámpara oe ojo oñoovaiti vaera cuimbae omendata vae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jare cinco jocuae cuñatai reta iyaracuaa, jare iru cinco vae reta mbaeti iyaracuaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jocuae mbaeti iyaracuaa vae reta güɨraja ilámpara, erei mbaeti güɨraja aceite lámpara peguara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Erei iyaracuaa vae reta güɨraja vi aceite lámpara peguara aceite jɨru pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jare mbaeti vɨteri ou ovae cuimbae omendata vae. Jae rambue opaete cuñatai reta jopeɨ jare oque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jare pɨare mbɨte yave oñeendu ñee. Mase, outa ma ovae cuimbae omendata vae. Pecua peovaiti —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jayave opaete jocuae cuñatai reta opúa jare oyapocavi ilámpara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jare cuñatai mbaeti iyaracuaa vae reta jei cuñatai iyaracuaa vae reta pe: Pemee oreve mbovɨ peaceite. Echa orelámpara ogüe ma —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Erei cuñatai iyaracuaa vae reta jei: Ani. Romee yave peve, ngaraa ndipo oupitɨ oreve. Icavi ndipo pe reta peo vaera aceite omee vae reta pɨri pegua vaera peyeupe —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jare cuñatai mbaeti iyaracuaa vae reta yogüɨraja aceite oeca rambueve, ou ovae cuimbae omendata vae. Jare cuñatai oñemocatɨro ma vae reta oique jae ndive o pe oyapo vaera arete. Jayave onque oñeoquenda —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jare taɨcue rupi yogüeru jocuae iru cuñatai reta o pe jare jei: Oreya, oreya, eipea oreve onque. ");
INSERT INTO guiNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Erei cuimbae jei chupe reta: Añete che jae peve, mbaeti pocuaa. ");
INSERT INTO guiNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jae rambue jecuaeño peñemocatɨro. Echa mbaeti peicuaa mbae ara jare mbae ora pe che cuimbaera ayeapo vae ayu yeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tamojaanga metei cuimbae iɨvɨ ae güi ambué ɨvɨ mombɨrɨ oi vae pe ojota vae. Ndei ojo mbove, oeni jembiócuai reta jare jei chupe reta oñangareco vaera imbaembae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jayave omee metei jembiócuai pe cinco corepoti talento jee vae. Jare omee iru jembiócuai pe mócoi talento. Jare omee iru jembiócuai pe metei talento. Echa omee chupe reta metei ñavo ipuere oyapo vae rupi. Jayave cuimbae ojo ambué ɨvɨ cotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jayave cinco talento güɨnoi vae omboɨpɨ omombaravɨquɨ icorepoti, jare jocorai omoiru jocuae cinco talento ndive cinco ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jae ramiño vi mócoi talento güɨnoi vae omboɨpɨ omombaravɨquɨ icorepoti, jare jocorai omoiru jocuae mócoi talento ndive mócoi ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Erei metei talento güɨnoi vae ojo oyoo ɨvɨ jare oñomi ɨvɨgüɨ pe corepoti iya omee chupe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Jare ɨma güire jocuae tembiócuai reta iya ou ye ovae iɨvɨ ae pe jare oparandu chupe reta mbae ra oyapo icorepoti omee chupe reta vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jare tenonde yave cinco talento güɨnoi vae güeru jocuae cinco talento iru cinco talento omoiru vae reve, jare jei iya pe: Cheya, nde remee cheve cinco talento. Mase, amoiru jae reta ndive cinco talento ye —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jayave iya jei chupe: Icavi reyapo. Nde co jae metei cherembiócuai icavi vae. Reyeócuai cavi cheve cuae mbovɨ vae re. Jae rambue tamee ndeve jeta mbaembae reñangareco jese vaera. Eyerovia che ndive —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jae ramiño vi tenonde yave mócoi talento güɨnoi vae ou jei iya pe: Cheya, nde remee cheve mócoi talento. Mase, amoiru jae reta ndive mócoi talento ye —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jayave iya jei chupe: Icavi reyapo. Nde co jae metei cherembiócuai icavi vae. Reyeócuai cavi cheve cuae mbovɨ vae re. Jae rambue tamee ndeve jeta mbaembae reñangareco jese vaera. Eyerovia che ndive —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jayave tenonde yave metei talento güɨnoi vae ou jei iya pe: Cheya, che rocuaa co. Aicuaa nde co jae metei cuimbae jecopochɨ vae. Nde repɨro mbaembae iru vae reta güi, jare rearɨvo iru vae reta oñotɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jae rambue aquɨye ndegüi rambue, aja añomi ndecorepoti ɨvɨgüɨ pe. Mase, co oi nembae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jayave iya jei chupe: Nde co jae cherembiócuai icavi mbae vae. Ndeaquɨ co. Nde reicuaa quirai apɨro mbaembae iru vae reta güi jare quirai aarɨvo iru vae reta oñotɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jae rambue rerajata tei checorepoti banco pe. Echa jocorai reyapo yave, ayu ye yave remeeta tei co cheve corepoti amee ndeve vae jare mbovɨ ye banco pegua reta omoiruta tei jae ndive vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jayave iya jei jembiócuai reta pe: Eequi chugüi jocuae metei talento emee diez talento güɨnoi vae pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Echa güɨnoi vae pe oñemoiruta. Jeta yaeta güɨnoi. Erei mbaeti güɨnoi vae güi michi yae güɨnoi vae oyeequita —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Erei pemombo cuae cherembiócuai mbaeti oyeócuai cavi cheve vae pɨtumimbi icatu pe oi vae pe. Joco pe oyaeota jare jai omboquɨrɨrɨuta —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Che cuimbaera ayeapo vae ayu ye yave añemboeteuca vaera, opaete araɨgua oñeñono tee Tumpa peguara vae reta yogüeruta che ndive. Jayave aguapɨta cheguapɨa maemboete pegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jare oñemboatɨta cheróvai opaete tenta pegua reta. Jare amboyaota amogüe vae iru vae reta güi, metei cuimbae omboyao ivecha reta icavara reta güi rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jare añonoucata vecha reta cheacatu cotɨ jare cavara reta cheasu cotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Che co jae Mburuvicha Guasu. Jaeta cheacatu cotɨ ñogüɨnoi vae reta pe: Peyu peico mboroocuaia ɨvɨ oyeapo güive oñemocatɨro peve vae pe. CheRu pemovendise ma —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Echa cheñɨmbɨaɨ yave, pemee acaru. Ɨ ayúe yave, chemboɨu. Yepe tei che co jae ambué tenta pegua, erei pemaeño cheré aico vaera perenta pe —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chenandi yave, pemee cheve cheremimondera. Chembaerasɨ yave, pepou chepɨri. Tembipɨɨrɨru pe ai yave, peyu pepou chepɨri —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jayave jupi vae reta jeita cheve: OreYa, ¿quirai yave pa roecha neñɨmbɨaɨ yave jare romee recaru? ¿Quirai yave pa roecha ɨ reyúe yave jare romboɨu? —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Quirai yave pa roecha metei ambué tenta peguara reico yave, jare romaeño nderé reico vaera orerenta pe? ¿Quirai yave pa roecha nenandi jare romee ndeve neremimondera? —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Quirai yave pa roecha nembaerasɨ ani tembipɨɨrɨru pe jare ropou ndepɨri? —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jayave che jaeta chupe reta: Añete che jae peve, jocorai peyapo cherɨvɨ reta pe, yepe tei oñereroɨrouca. Jare jocorai peyapo yave, peyapo co cheve vi —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jayave jaeta cheasu cotɨ ñogüɨnoi vae reta pe: Pecua chegüi tata opa mbae vae pe. Jocuae tata oñemocatɨro ma oi aña guasu jare opaete araɨgua chupe oyeócuai vae reta pe. Tumpa oyepopeyu peré —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Echa cheñɨmbɨaɨ yave, mbaeti pemee acaru. Ɨ ayúe yave, mbaeti chemboɨu —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Che co jae ambué tenta pegua jare mbaeti pemaeño cheré aico vaera perenta pe. Chenandi yave, mbaeti pemee cheve cheremimondera. Chembaerasɨ yave jare tembipɨɨrɨru pe ai yave, mbaeti pepou chepɨri —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jayave jae reta vi jeita cheve: OreYa, ¿quirai yave pa roecha neñɨmbɨaɨ yave, ani ɨ reyúe yave, ani ambué tenta peguara reico yave, ani nenandi yave, ani nembaerasɨ yave, ani tembipɨɨrɨru pe rei yave, jare mbaeti romborɨ? —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jayave che jaeta chupe reta: Añete che jae peve, mbaeti pemborɨ cherɨvɨ oñereroɨrouca vae reta. Jare jocorai co mbaeti chemborɨ —jaeta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jare cuae reta yogüɨrajata tata guasu pe. Joco pe oiporara retata jecuaecuae aveiño. Erei jupi vae reta güɨnoita tecove opa mbae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jare opaete cuae jei ma yave, Jesús jei jemimboe reta pe: ");
INSERT INTO guiNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Peicuaa mócoi ara co oata pascua iyarete iara ovae vaera, jare che cuimbaera ayeapo vae añemoeterengaucata co ayecutuca vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jare sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta oñemboatɨ sacerdote tenondegua joca pe. Sacerdote tenondegua jee co Caifás. ");
INSERT INTO guiNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jare oñomomiari reta quirai ipuere oipɨɨ vɨari Jesús oyucauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Erei jei reta: —Agüɨye yaipɨɨ arete iara pe, agüɨye vaera tenta pegua reta oyapo tecorai. ");
INSERT INTO guiNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jare Jesús oi rambueve tenta Betania pe Simón ipire ocuise vae jo pe, ");
INSERT INTO guiNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","oique metei cuña. Cuña güeru ɨru-raɨ ita alabastro jee vae pegua. Cuae ɨru-raɨ tɨnɨe mbae ipiche cavi vae jepɨ yae vae pe. Jare cuña opɨyere mbae ipiche cavi vae Jesús iñaca re, Jesús mesa pe oguapɨ oi rambueve. ");
INSERT INTO guiNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jare Jesús jemimboe reta cuae oecha yave, pochɨ cuña pe. Jei reta: —¿Maera pa omombúcai? ");
INSERT INTO guiNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Echa omee yave corepoti re, guɨnoita tei jeta corepoti omee vaera paravete vae reta pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Erei Jesús oicuaa jei reta vae, jare jei chupe reta: —¿Maera pa pemambeco cuña? Icavi vae co oyapo cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Echa yogüɨrecoñotai co paravete vae reta pe reta ndive, erei che ngaraa jecuaeño ai pe reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cuae mbae ipiche cavi vae opɨyere cheré vae pe chembopiche cavi ma, ndei añeotɨuca mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Añete che jae peve, opaete ɨvɨ rupi ñee icavi vae jeracuaa rupi, cuae oyapo vae vi jeracuata, iru vae reta imaendúa vaera jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jayave jocuae doce jemimboe reta güi metei Judas Iscariote jee vae ojo sacerdote reta itenondegua reta ñogüɨnoia pe, ");
INSERT INTO guiNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jare jei chupe reta: —¿Mbae pa pemeeta cheve, amoeterenga yave Jesús peve? Jayave jae reta jei omeeta co chupe treinta corepoti. ");
INSERT INTO guiNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jayave jocuae güive Judas oeca quirai ipuere omoeterenga Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jare jocuae ara judío reta omboɨpɨ jou mbɨyape ovu mbae vae yave, Jesús jemimboe reta yogüeru jei chupe: —¿Quiape pa reipota royapocavi vaera, vecha isoo pascua pegua reu vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jayave Jesús jei chupe reta: —Pecua tenta pe pere cuimbae amombeu peve vae pe: Oporomboe vae jei: Ora ovae ma. Jauta vecha isoo pascua pegua ndero pe cheremimboe reta ndive —jei, pere chupe, jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jayave jemimboe reta oyapo Jesús jei chupe reta oyapo vaera vae. Jare oyapocavi reta vecha isoo pascua pegua jou reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jare pɨtu ma yave Jesús oguapɨ ocaru vaera jocuae doce jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jare ocaru ñogüɨnoi rambueve, Jesús jei chupe reta: —Añete che jae peve, metei pepɨte pe oi vae chemoeterengata cherovaicho reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jayave jae reta ipɨatɨtɨ yae, jare jei Jesús pe meteitei rupi: —CheYa, ¿che pa co jae? ");
INSERT INTO guiNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jayave Jesús jei chupe reta: —Mbɨyape omoaquɨ oi che ndive ñae pe vae co jae. ");
INSERT INTO guiNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Che cuimbaera ayeapo vae ajañotai amano vaera, oyecuatía oi cheregua rami. Erei jocuae cuimbae chemoeterengata vae oiporarata co. Icavi tei viña jocuae cuimbae mbaeti oico yave —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jayave Judas (Jesús omoeterenga vae) jei chupe: —Oporomboe vae, ¿che pa co jae? —Rere ma co —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jare ocaru ñogüɨnoi rambueve, Jesús oipɨɨ mbɨyape, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape jare omee jemimboe reta pe. —Peu —jei chupe reta—. Cuae co jae cherete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jayave Jesús oipɨɨ vi metei vaso, jare yasoropai omee ye güire Tumpa pe, omee jemimboe reta pe. —Peu opaete pe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cuae co jae cherugüɨ. Cherugüɨ oyepɨyereta, Tumpa güɨrocuaveegüe vae oyeapo vaera, jare Tumpa iñɨro vaera jeta vae pe imbaeyoa reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Erei che jae peve, ngaraa ma jau uva tɨgüe, cheRu iporoocuaia pe uva tɨgüe ipɨau vae pe reta ndive jau regua —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jare opa güire omboete reta Tumpa canta pe, oe reta yogüɨraja ɨvɨtɨ Oliva cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jayave Jesús jei chupe reta: —Opaete pe reta chereyata cuae pɨtu. Echa Tumpa iñee pe oyecuatía oi corai: Ayucata vecha reta iñangarecoa, jare vecha reta opata oñemoai. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Erei aicove ye ayu güire omanogüe vae reta ipɨte güi, ajata perenonde Galilea pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jayave Pedro jei Jesús pe: —Yepe tei opaete iru reta tandereya, erei che ngaraa roeya. ");
INSERT INTO guiNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Añete che jae ndeve —jei Jesús chupe—, cuae pɨtu etei, ndei tacareo oñee pɨipɨi mbove, mboapɨ ma checuacuta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Erei Pedro jei ye chupe: —Yepe tei tamano nde ndive, erei ngaraa rocuacu. Jare jocorai vi jei opaete Jesús jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jayave Jesús ojo jae reta jupíe ovae ɨvɨra reta ñogüɨnoia Getsemaní jee vae pe. Jare Jesús jei jemimboe reta pe: —Peguapɨ cuae pe, che aja pea pe ayerure Tumpa pe rambueve. ");
INSERT INTO guiNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jayave güɨraja Pedro jare jocuae mócoi Zebedeo taɨ reta, jare omboɨpɨ ipɨatɨtɨ jare oiporara yae. ");
INSERT INTO guiNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jayave jei jocuae mboapɨ jemimboe reta pe: —Chepɨatɨtɨ yae, jare amano pota echa. Pepɨta cuae pe, jare agüɨye peque —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jayave Jesús ojo mombɨrɨ catu chugüi reta, jare oyeatɨca ɨvɨ re jare oyerure Tumpa pe. —CheRu, nde reipota yave, emboasa chegüi cuae aiporarata vae. Erei toyeapo cheve neremimbota. Agüɨye toyeapo cheremimbota —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jayave Jesús ou ye jemimboe reta ñogüɨnoia pe, jare oecha oque ñogüɨnoi. Jayave jei Pedro pe: —¿Mbaeti pa pepuere metei ora yepe peque mbae pei chemborɨ vaera? ");
INSERT INTO guiNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Agüɨye peque. Peyerure Tumpa pe, agüɨye vaera peyoa. Pepɨa pe peratangatu co, erei perete iyaquɨ co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jayave Jesús ojo ye oyerure Tumpa pe. —CheRu, nde reipota yave aiporara vaera, toyeapo cheve neremimbota —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jayave ou ye jemimboe reta ñogüɨnoia pe, jare oecha oque ye ñogüɨnoi. Echa jae reta jopeɨ yae ete ma. ");
INSERT INTO guiNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jayave Jesús ojo ye chugüi reta oyerure Tumpa pe. Oyerure ye tenonde yave oyerure rami. ");
INSERT INTO guiNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jayave ou ye jemimboe reta ñogüɨnoia pe jare jei chupe reta: —Jecuaeño peque jare peputuu. Mase, ora ovae ma. Che cuimbaera ayeapo vae metei vae chemoeterengata cuimbae pochɨ vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pepúa. Yaja mo. Mase, chemoeterengata vae coiño ma ou —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jare imiari oi rambueve, ou Judas - jae co jocuae doce vae güi metei - jeta vae ndive. Jae reta güeru quɨsepucu reta jare ɨvɨra reta. Sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta ombou Jesús pe cuae reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jare omoeterengata vae omombeu ma iru reta pe mbae oyapota vae. Jei ma chupe reta: —Jocuae aiyurupɨte vae co jae. Peipɨɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas ou voi Jesús oia pe. —Pɨtu ma, oporomboe vae —jei chupe. Jayave oiyurupɨte. ");
INSERT INTO guiNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jayave Jesús jei chupe: —Cheamingo, ¿maera pa reyapo jocorai? Jayave iru reta yogüeru oipɨɨ Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jare metei Jesús ndive oi vae oipɨɨ iquɨsepucu jare oequi jɨru güi, jare oiporu sacerdote tenondegua jembiócuai inambi re, jare inambi oyeequi. ");
INSERT INTO guiNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jayave Jesús jei chupe: —Peñono ye quɨsepucu jɨru pe. Echa opaete quɨsepucu oiporu vae reta oyeyucaucata quɨsepucu pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aipota yave, chepuere ayerure cheRu pe ombou voi vaera jeta yae araɨgua reta cherepɨ vaera. ¿Mbaeti pa reicuaa cuae? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Erei jocorai yave, ¿quiraita pa oyeapo Tumpa iñee pe oyecuatía oi vae? Echa jei jocoraita co oyeapo cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jayave Jesús jei yogüeru vae reta pe: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨɨ vaera, imonda vae peipɨɨ yave rami? Ara ñavo aguapɨ pe reta ndive Tumpa jo pe. Joco pe aporomboe, jare mbaeti chepɨɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Erei opaete cuae oyeapo oi Tumpa iñee aracae omombeu vae reta oicuatía vae oyeapo vaera —jei. Jayave opaete jemimboe reta oeya Jesús, jare otecuarai. ");
INSERT INTO guiNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jayave Jesús oipɨɨ vae reta güɨraja sacerdote tenondegua Caifás jo pe. Jare joco pe oñemboatɨ ma mboroócuai re oporomboe vae reta jare tenta pegua reta itenondegua reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jare Pedro vi ojo Jesús jaɨcue. Erei mombɨrɨ chugüi ojo. Jae oique sacerdote tenondegua joca pe, jare oguapɨ sacerdote tenondegua jembiócuai reta ndive, oecha vaera mbae oyeapota vae. ");
INSERT INTO guiNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jare sacerdote reta itenondegua reta jare opaete iru mburuvicha reta oeca quia oñeapo vaera Jesús re yapu reve, oyucauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Erei mbaeti ovae reta teco jese, yepe tei jeta vae yapu reve oñeapo jese. Taɨcue rupi mócoi vae yapu reve oñeapo jese. ");
INSERT INTO guiNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jae reta jei: —Cuae cuimbae jei: Chepuere ambosururu Tumpa jo jare ayapo ye mboapɨ ara pe —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jayave sacerdote tenondegua opúa oñemboɨ jare jei Jesús pe: —¿Maera pa mbaeti neñee remoe? ¿Mbae re pa cuae reta oñeapo nderé? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Erei Jesús quiriiño. Jayave sacerdote tenondegua oparandu ye chupe: —¿Nde pa co jae Cristo? ¿Nde pa co jae Tumpa Taɨ? Che roócuai Tumpa jecuaeño oico vae jee re remombeu vaera oreve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jayave Jesús jei chupe: —Nde rere rami jae co che. Erei che jae peve, che cuimbaera ayeapo vae cherechata co aguapɨ ai Tumpa mbaepuere güɨnoi vae iyɨque pe iyacatu cotɨ. Cherechata vi ayu amapɨtu reta reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jayave sacerdote tenondegua omondoro jemimonde ae, jare jei: —Jei ma icavi mbae vae Tumpa cotɨ. ¿Maera pa yaeca ye iru vae reta oñeapo vaera jese? Mase, pe reta peendu ma icavi mbae vae Tumpa cotɨ jei vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mbae pa peñemongueta jese? —jei. Iru reta jei chupe: —Icavi mbae yae co. Icavi co yayucauca vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jayave amogüe vae ondɨvɨ Jesús jova re, jare oinupa. Jare iru vae reta ocua jese, ");
INSERT INTO guiNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jare jei chupe: —Nde co jae Cristo. Emombeu oreve quia ra ocua oi nderé. ");
INSERT INTO guiNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jare Pedro oguapɨ oi icatu pe oca pe. Jare metei cuñatai ou jei chupe: —Nde vi co jae Jesús Galilea pegua iñeiru. ");
INSERT INTO guiNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Che mbaeti co jae iñeiru —jei Pedro opaete vae jovaque—. Mbaeti aicuaa mbae rere vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jayave Pedro ojo taraquera cotɨ. Jare iru cuñatai oecha jare jei joco pe ñogüɨnoi vae reta pe: —Cuae cuimbae co jae metei Jesús Nazaret pegua iñeiru. ");
INSERT INTO guiNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Erei Pedro jei ye: —Che mbaeti co jae iñeiru. Tumpa jee re mbaeti aicuaa jocuae cuimbae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jare ɨma mi yave joco pe ñogüɨnoi vae reta yogüeru jei Pedro pe: —Añete co, nde co jae metei Jesús iñeiru. Echa nde nemiari Jesús iñeiru reta imiari rami —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jayave Pedro oyepopeyu iyee jare jei ye Tumpa jee re: —Mbaeti aicuaa jocuae cuimbae. Jare jupivei tacareo oñee. ");
INSERT INTO guiNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jare Pedro imaendúa Jesús jei chupegüe vae re: Ndei tacareo oñee pɨipɨi mbove, mboapɨ ma checuacuta. Jayave Pedro oe joco güi, jare tanta yae oyaeo. ");
INSERT INTO guiNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jare coe ma yave, opaete sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta oñomomiari Jesús re, oyucauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jayave oñapɨti Jesús jare güɨraja mburuvicha guasu Poncio Pilato pe omoeterenga. ");
INSERT INTO guiNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jayave Judas (Jesús omoeterenga vae) ipɨatɨtɨ oyapogüe vae re. Echa oicuaa ma quirai Jesús jovaicho reta omboeco ma Jesús. Jayave güɨraja ye jocuae treinta corepoti sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta ñogüɨnoia pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jare jei chupe reta: —Ayapo mbaeyoa. Echa amoeterenga peve jocuae cuimbae teco mbaeti güɨnoi vae peyucauca vaera —jei. Jayave jae reta jei Judas pe: —Jocuae mbaeti co mbae oreve. Nde co renoi teco. ");
INSERT INTO guiNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jayave Judas omombo corepoti Tumpa jo pe. Jayave oe Tumpa jo güi ojo oyeyuvɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jayave sacerdote reta itenondegua reta omonoo jocuae corepoti jare jei: —Mbaeti co jupi ñañono ye vaera cuae corepoti jɨru Tumpa jo pe oi vae pe. Echa ñamee Judas pe ñandepuere vaera yayucauca Jesús —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jayave oñomomiari oicuaa vaera mbae ra oyapota corepoti pe. Jayave ogua ñaeu iyapoa ico, oñeotɨuca vaera joco pe ambué tenta pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jae rambue ombojee jocuae co: Ɨvɨ tugüɨ jepɨgüe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jare jocorai oyeapo Tumpa iñee aracae omombeu vae Jeremías jeigüe vae. Echa jae jei corai: Jare jae reta omonoo jocuae treinta corepoti. Echa Israel pegua reta omboepɨ treinta corepoti jocuae cuimbae re. Jepɨ co treinta corepoti. ");
INSERT INTO guiNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jayave ogua pɨpe ñaeu iyapoa ico, ñandeYa jei cheve rami. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jare Jesús oñemboɨ mburuvicha guasu jóvai. Jayave mburuvicha guasu oparandu chupe: —¿Nde pa co jae judío reta juvicha guasu? —jei. —Nde rere rami jae co che —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jare sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta oñeapo Jesús re yave, Jesús mbaeti mbae jei. ");
INSERT INTO guiNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jayave Pilato jei chupe: —¿Mbaeti pa reendu quirai jeta mbaembae re oñeapo reta nderé? ");
INSERT INTO guiNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Erei Jesús mbaeti etei mbae jei chupe. Jae rambue mburuvicha guasu ipɨacañɨ yae jese. ");
INSERT INTO guiNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jare jocuae arete ñavo Pilato oyorauca metei tembipɨɨ tenta pegua reta oipota vae. ");
INSERT INTO guiNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jare tembipɨɨrɨru pe oi metei cuimbae jeracua yae vae. Jee co Barrabás. ");
INSERT INTO guiNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jayave Pilato oparandu yatɨ vae reta pe: —¿Peipota pa ayorauca vaera peve Barrabás ani Jesús Cristo jee vae? ");
INSERT INTO guiNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Echa jae oicuaa judío reta omoeterenga Jesús chupe oñemoagüɨro jese rambue. ");
INSERT INTO guiNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jare Pilato oguapɨ oi yave ojaa vaera Jesús, jembireco ombou quia jei vaera chupe: —Agüɨye eyapo mbae jocuae cuimbae jupi vae pe. Echa aiporara yae pɨare chepaɨu pe jae jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Erei sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta omboemboe yatɨ vae reta oyerure vaera Pilato pe oyorauca vaera Barrabás jare oyucauca vaera Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jayave Pilato oparandu chupe reta: —¿Quia nunga pa cuae mócoi cuimbae güi peipota ayorauca vaera peve? —Barrabás —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jayave Pilato oparandu ye chupe reta: —Jocorai yave, ¿mbae pa peipota ayapo vaera Jesús Cristo jee vae pe? Jayave opaete vae jei: —Toyecutuca curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Erei Pilato oparandu ye chupe reta: —¿Mbae nunga teco icavi mbae vae pa oyapo? Erei jae reta iñeeata yae reve jei: —Toyecutuca curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jare Pilato oicuaa yave mbaeti co mbae ipuere oyapo oyorauca vaera Jesús - echa judío reta omboɨpɨ oyapo tecorai - jei güeru vaera chupe ɨ jare oyepoe yatɨ vae reta jóvai. Jayave jei chupe reta: —Che mbaeti anoi teco cuae cuimbae jupi vae imano re. Pe reta penoi teco —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jayave opaete yatɨ vae reta jei: —Ore jare oreñemoña reta torogüɨnoi teco imano re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jayave Pilato oyorauca chupe reta Barrabás. Jare oinupauca güire Jesús chicote pe, omoeterenga sundaro reta pe, oicutu vaera curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jayave mburuvicha guasu isundaro reta güɨraja Jesús pretorio jee vae pe, jare omboatɨ opaete iru sundaro reta joco pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jayave sundaro reta omboi Jesús güi jemimonde jare omondeuca chupe temimonde pɨta vae. ");
INSERT INTO guiNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jayave oñope reta yuu catuai vae jare omboapúa oñono Jesús iñaca re. Omee reta vi chupe metei tacuarasɨ oipɨɨ vaera ipo iyacatu pe. Jayave oyeatɨca reta jae jóvai jare oyóyai. —¡Viva! Judío reta juvicha guasu —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jare ondɨvɨ reta jese. Jayave oipɨɨ reta tacuarasɨ oiporu iñaca re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jare opa oyóyai güire, sundaro reta omboi chugüi temimonde pɨta vae, jare omondeuca ye chupe jemimonde ae. Jayave güɨraja reta mburuvicha guasu joca güi, oicutu vaera curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jare oguata reta rambueve, oecha metei cuimbae Simón jee vae. (Cuae Simón tenta Cirene pegua co.) Jayave sundaro reta güɨrajauca Simón pe Jesús icurusu. ");
INSERT INTO guiNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jare sundaro reta güɨraja Jesús Gólgota jee vae pe. (Cuae oipota jei: Acagüerenda.) ");
INSERT INTO guiNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jayave omee reta Jesús pe vino oyea hiel ndive vae. Erei Jesús oicuaa yave mbae jocuae, mbaeti jou. ");
INSERT INTO guiNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jayave sundaro reta oicutu curusu re. Jayave oñuvanga reta Jesús jemimonde reta re, oicuaa vaera mbae nunga metei ñavo güɨrajata vae. Jocorai oyapo reta oyeapo vaera Tumpa iñee aracae omombeu vae jeigüe vae. Echa jei corai: Oñuvanga reta cheremimonde reta re, oicuaa vaera mbae nunga metei ñavo güɨrajata vae. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jayave sundaro reta oguapɨ joco pe jare omae Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jare oñono reta curusu re Jesús iñaca iárambue oyecuatía jesegua vae: Cuae co Jesús, judío reta juvicha guasu. ");
INSERT INTO guiNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jare sundaro reta oicutu vi mócoi imonda vae reta, jare oñono metei Jesús iyacatu cotɨ jare iru iyasu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jare oasa vae reta jei icavi mbae vae oñeacambovava reve Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Nde rere rembosururuta co Tumpa jo jare reyapo yeta mboapɨ ara pe —jei reta chupe—. Eyeepɨ. Nde co jae Tumpa Taɨ yave, egüeyɨ curusu güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jae ramiño vi sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta jare tenta pegua reta itenondegua reta oyóyai. ");
INSERT INTO guiNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jae oepɨ iru vae reta —jei reta—. Erei mbaeti ipuere oyeepɨ. Jae co Israel pegua reta juvicha guasu. Togüeyɨ añave curusu güi, yarovia vaera jese —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Güɨrovia Tumpa re. Tumpa toepɨ añave, oipota yave. Echa jae jei: Che co jae Tumpa Taɨ —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jare imonda vae Jesús ndive oyecutuca vae reta jei icavi mbae vae chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jare cuaraɨ ara mbɨte güive mboapɨ ora rupi oñemopɨtumimbi opaete ɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jayave mboapɨ ora ma caaru yave Jesús iñeeata yae reve jei: —Elí, Elí, ¿lama sabactani? (Cuae oipota jei: CheTumpa, cheTumpa, ¿maera pa chereya?) ");
INSERT INTO guiNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amogüe joco pe ñogüɨnoi vae reta oendu jare jei tei: —Mase, Elías oeni. ");
INSERT INTO guiNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jare jupivei metei vae osɨi omoaquɨ esponja vinagre pe, jare oñono tacuarasɨ re, jare omondo Jesús iyuru cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Erei iru reta jei: —Earo. Yaecha ou Elías ombogüeyɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jayave Jesús tanta osapúcai, jare omano. ");
INSERT INTO guiNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jayave Tumpa jo omboyao vae osoro mbɨte rupi ɨvate güi ɨvɨ cotɨ. Jare ɨvɨ ocana jare ita tuicha vae reta ovo. ");
INSERT INTO guiNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jare teogüerɨru reta oyepea, jare jeta oñeñono tee Tumpa peguara omanogüe vae reta oicove ye, ");
INSERT INTO guiNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","jare oe teogüerɨru reta güi Jesús oicove ye güire ou omanogüe vae reta ipɨte güi. Jae reta yogüɨraja Jerusalén pe - jae co tenta oñeñono tee Tumpa peguara vae - jare oyecuaa jeta vae pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jare cien sundaro vae juvicha Jesús re omae oi vae jare jae ndive ñogüɨnoi vae reta oecha yave quirai ɨvɨ ocana jare opaete oyeapo vae, oquɨye yae jare jei: —Añete yepe, cuae cuimbae co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jare jeta cuña reta omae ñogüɨnoi mombɨrɨ güi. Cuae cuña reta yogüeru Jesús ndive Galilea güi oyeócuai vaera chupe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cuae reta ipɨte pe ñogüɨnoi María Magdalena, jare Jacobo jare José ichɨ María jee vae, jare Zebedeo taɨ reta ichɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jare cuaraɨ oique ma yave, metei cuimbae oicocatu vae tenta Arimatea pegua José jee vae - jae vi co metei Jesús jemimboe - ");
INSERT INTO guiNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ojo Pilato pɨri, jare oyerure chupe Jesús jetegüe re. Jayave Pilato oyócuai oñemee vaera chupe Jesús jetegüe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jayave José ombogüeyɨ Jesús jetegüe, jare oñoma metei lienzo iquɨa mbae vae pe. ");
INSERT INTO guiNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jayave oñono metei teogüerɨru ipɨau vae ita guasu oyeyoo vae pe, (José imbae co jocuae teogüerɨru) jare omboyeapayere ita tuicha vae teogüerɨru jonque re. Jayave José ojo ye teogüerɨru güi. ");
INSERT INTO guiNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jare María Magdalena jare iru cuña María jee vae oguapɨ ñogüɨnoi teogüerɨru jóvai. ");
INSERT INTO guiNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jare jocuae ara opaete judío reta oyeapocavi ñogüɨnoi pɨareve peguara. Jayave pɨareve pe sacerdote reta itenondegua reta jare fariseo reta yogüɨraja Pilato pɨri, ");
INSERT INTO guiNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","jare jei chupe: —Oreruvicha, oremaendúa ma quirai jocuae cuimbae oporombotavɨse vae ndei omano mbove jei mboapɨ ara rupi oicove yeta ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eyócuai nesundaro reta oñangareco vaera teogüerɨru re mboapɨ ara pegua, agüɨye vaera jemimboe reta yogüɨraja joco pe pɨtu yave oñomi vaera jetegüe. Echa jocorai yave, jei retata opaete vae pe oicove ye ma co ou omanogüe vae reta ipɨte güi. Jare jocorai yave, jae reta ombotavɨta jeta yae Jesús ombotavɨ vae reta güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jayave Pilato jei chupe reta: —Pe reta vi penoi pesundaro reta. Pecua peñangareco cavi jese pepuere rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jayave jae reta yogüɨraja jare oñoquenda cavi teogüerɨru jonque. Echa oñono mbae ita tuicha vae re agüɨye vaera quia oipea, jare oeya joco pe sundaro reta oñangareco vaera teogüerɨru re. ");
INSERT INTO guiNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mbutuu iara oasa ma yave, neimbove asɨ semana iara tenondegua vae pe María Magdalena jare iru cuña María jee vae yogüɨraja teogüerɨru cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jare ɨvɨ ocana yae. Echa metei araɨgua ñandeYa pe oyeócuai vae ogüeyɨ ara güi jare omboyeapayere ita tuicha vae teogüerɨru jonque güi. Jayave araɨgua oguapɨ ita re. ");
INSERT INTO guiNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jare jova oyecuaa amavera rami. Jare jemimonde ti asɨ yae iroɨ ti asɨ yae vae rami. ");
INSERT INTO guiNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jare teogüerɨru re oñangareco vae reta orɨrɨi oquɨye güi, jare opa tanta omano vae reta rami. ");
INSERT INTO guiNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jayave araɨgua jei cuña reta pe: —Agüɨye pequɨye. Echa aicuaa peeca co Jesús curusu re oyecutuca vae. ");
INSERT INTO guiNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mbaeti ma oi cuae pe. Oicove ye ma ou omanogüe vae reta ipɨte güi, jae jei rami. Peyu pemae oñeñonoagüe re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jare pecua voi pere jemimboe reta pe jae oicove ye ma ou omanogüe vae reta ipɨte güi. Jae ojota perenonde Galilea pe. Joco pe peechata. Amombeu ma co peve —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jayave cuña reta oe voi teogüerɨru güi. Oquɨye reta jare oyerovia yae reta. Jare osɨi reta omombeu vaera Jesús jemimboe reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jare Jesús oñoovaiti jae reta ndive jare jei chupe reta: —Peyerovia catu. Jayave cuña reta oicuava ipɨ rupi jare omboete. ");
INSERT INTO guiNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jayave Jesús jei chupe reta: —Agüɨye pequɨye. Pecua pemombeu cherɨvɨ reta pe yogüɨraja vaera Galilea pe. Joco pe cherechata —jei. ");
INSERT INTO guiNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jare cuña reta yogüɨraja ye rambueve teogüerɨru güi, amogüe sundaro tenonde yave teogüerɨru re oñangareco vae reta yogüɨraja vi tenta pe, jare omombeu sacerdote reta itenondegua reta pe opaete oyeapogüe vae. ");
INSERT INTO guiNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jare sacerdote reta itenondegua reta oñemboatɨ tenta pegua reta itenondegua reta ndive. Jare oñomomiari ma yave, omee jeta corepoti sundaro reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jare jei chupe reta: —Pere: Jesús jemimboe reta yogüɨraja teogüerɨru pe pɨtu yave, jare oñomi Jesús jetegüe ore roque rambueve —pere, jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jare mburuvicha guasu cuae oendu yave, romombeuta chupe pe reta mbaeti co penoi teco —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jayave sundaro reta oipɨɨ corepoti jare oyapo sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta jei chupe reta oyapo vaera vae. Jare jecuaeño opaete judío reta jei jocorai co oyeapo. ");
INSERT INTO guiNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jayave jocuae once Jesús jemimboe reta yogüɨraja Galilea pe metei ɨvɨtɨ re Jesús omombeu chupe reta rami. ");
INSERT INTO guiNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jare jemimboe reta oecha yave Jesús, omboete. Erei amogüe vae mbaeti ipuere güɨrovia jae co Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jare Jesús ou jei chupe reta: —Opaete mbaepuere oñemee ma cheve ara pe jare ɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jae rambue pecua pemboe opaete tenta pegua reta jare pembobautiza cheRu jee re jare cheree re jare Espíritu Santo jee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jare pemboe reta opaete che poócuai vae re. Jare che aita pe reta ndive jecuaecuae aveiño cuae ara reta opa regua —jei.");
INSERT INTO guiNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cuae pe oñemboɨpɨ ñee icavi vae Jesucristo regua. Jesucristo co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías co jae metei Tumpa iñee aracae omombeu vae. Jae oicuatía corai: Mase —jei Tumpa—, che amondota cheñee güɨraja vae nerenonde, oyapocavi vaera nderapera. ");
INSERT INTO guiNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jae iñeeata reve jeita ñuu pe: Peyapocavi ñandeYa japera. Pemosɨmbi tape —jeita, jei Tumpa. Jocorai oicuatía Isaías. ");
INSERT INTO guiNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jae rambue Juan ou oporombobautiza ñuu pe, jare omombeu yatɨ vae reta pe: —Peeya peñemongueta icavi mbae vae pepɨa pe oi vae, jare che pombobautizata, Tumpa iñɨro vaera peve pembaeyoa reta re —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jare opaete ɨvɨ Judea pegua reta jare tenta Jerusalén pegua reta yogüɨraja Juan oia pe. Jare Juan ombobautiza reta ɨaca Jordán pe, imbaeyoa reta opa omombeu güire. ");
INSERT INTO guiNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jare Juan jemimonde maemɨmba camello jee vae jaagüe pegua co, jare icuacuaa co jae metei guasupi. Jare jou tucu reta jare ei ñana rupigua. ");
INSERT INTO guiNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jae omombeu yatɨ vae reta pe: —Cheraɨcue outa ipuere yae chegüi vae. Mbaeti jupi che añaɨvɨ amboi vaera ipɨapaa. ");
INSERT INTO guiNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Che pombobautiza ɨ pe, erei jae pembobautizata Espíritu Santo pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jare mbovɨ ara rupi ou Jesús tenta Nazaret ɨvɨ Galilea pegua güi. Jare Juan ombobautiza Jesús Jordán pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jare Jesús oe ɨ güi yave, oecha ara oyepea oi, jare oecha vi Espíritu Santo ogüeyɨ jese pɨcasu rami. ");
INSERT INTO guiNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jayave oñeendu ñee ara güi jei: —Nde co jae cheRaɨ. Roaɨu yae. Ayerovia yae nderé —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jayave Espíritu Santo omondo Jesús ñuu pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jare opɨta ñuu pe cuarenta ara, jare Satanás imiari chupe oyapouca vaera tei mbaeyoa chupe. Jare oico Jesús maemɨmba ñuu rupigua reta ñogüɨnoia pe. Jare yogüeru araɨgua reta oyeócuai chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan oñemoingueuca ma tembipɨɨrɨru pe yave, ojo Jesús Galilea pe, jare omombeu iru vae reta pe ñee icavi vae Tumpa iporoocuaia regua. ");
INSERT INTO guiNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús jei: —Ara ovae ma. Outa ovae Tumpa iporoocuaia. Peeya peñemongueta icavi mbae vae pepɨa pe oi vae, jare perovia Tumpa iñee icavi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jare oguata rambueve Galilea pe ɨ guasu jembeɨ rupi, Jesús oecha Simón jare Simón tɨvɨ Andrés jee vae. Jae reta omombo ñogüɨnoi ipɨsa ɨ guasu pe, jevae omboa vaera. Echa jae reta oyeporaca vae reta co. ");
INSERT INTO guiNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jayave Jesús jei chupe reta: —Peyu cherupíe, jare che poapota cuimbae reta peru vaera cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jayave oeya reta ipɨsa, jare yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ndei mombɨrɨ ojo mbove, Jesús oecha Zebedeo taɨ reta. Metei jee co Jacobo, jare iru jee co Juan. Omboyoapɨ ñogüɨnoi ipɨsa osogüe reta chalana pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jare Jesús oeni voi. Jayave jae reta oeya Zebedeo jare oparavɨquɨ chupe vae reta chalana pe, jare yogüɨraja Jesús jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jare yogüɨraja ovae tenta Capernaum pe. Jare mbutuu iara ñavo Jesús oique judío reta itupao pe, jare oporomboe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jare oyeapɨsaca jese vae reta ipɨacañɨ iporomboe re. Echa omboe reta mbaepuere güɨnoi vae rami. Mbaeti jocorai oporomboe mboroócuai re oporomboe vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jare oique tupao pe cuimbae aña oya jese vae. Jae iñeeata reve jei: ");
INSERT INTO guiNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Maera pa reyu oremambeco, Jesús Nazaret pegua? ¿Reyu pa oremboai vaera? Che rocuaa. Nde co jae jupi vae. Nde reyu co Tumpa güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jayave Jesús oñeengata chupe. —¡Nequirii! Ecua chugüi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jayave aña omborɨrɨi yae cuimbae, jare tanta osapúcai reve ojo chugüi. ");
INSERT INTO guiNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jare opaete oecha vae reta ipɨacañɨ, jare oparandu oyoupe: —¿Mbae pa co cuae? ¡Moromboe ipɨau vae ndipo! Mbaepuere pe oyócuai aña reta yogüɨraja vaera oya jese vae reta güi, jare jae reta oyapo oyocuaigüe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jayave ɨmambaeño jeracua jese opaete Galilea rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jare Jesús tupao güi oe yave, oique Simón jare Andrés jo pe Jacobo jare Juan ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón jaicho jupa pe oi, jacu rambue. Jare iru reta omombeu Jesús pe jesegua. ");
INSERT INTO guiNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jayave Jesús ojo oipopɨɨ, jare omopúa. Jare jacu opɨta chugüi. Jayave cuña omee mbae jou reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jare cuaraɨ oique ma yave, tenta pegua reta güeru Jesús pɨri opaete imbaerasɨ vae reta jare aña oya jese vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jare opaete tenta pegua reta oñemboatɨ jocuae o jonque pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jayave Jesús ombogüera jeta imbaerasɨ vae reta oipotagüe mbaerasɨ güi, jare omondo jeta aña reta oya jese vae reta güi. Jare mbaeti omaeño aña reta imiari vaera. Echa jae reta oicuaa quia co jae. ");
INSERT INTO guiNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pɨareve pe Jesús opúa ndei coe mbove, jare oe ojo mbaeti quia oicoa pe. Joco pe oyerure oi Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jayave Simón jare jae ndive ñogüɨnoi vae reta yogüɨraja oeca. ");
INSERT INTO guiNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jare ovae chupe yave, —Opaete vae ndereca ñogüɨnoi —jei reta Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jayave Jesús jei chupe reta: —Yaja iru tenta reta coiño ñogüɨnoia pe, joco pe vi amombeu vaera Tumpa iñee. Echa ayu cuae ayapo vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jare ojo opaete Galilea rupi, jare omombeu Tumpa iñee judío reta itupao ñavo pe, jare omondo aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jayave ou Jesús oia pe metei cuimbae ipire ocúi vae. Oyeatɨca Jesús jóvai jare oyerure chupe: —Reipota yave, ndepuere chembogüera —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús oiparareco omae jese, jare oñono ipo jese. —Aipota. Ecuera —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jare jupiveiño cuimbae ocuera imbaerasɨ güi. Mbaeti ma ocúi ipire. ");
INSERT INTO guiNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jare jupiveiño Jesús oyócuai yae, ndei omondo mbove: ");
INSERT INTO guiNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Agüɨye emombeu quia pe. Ecua eyeechauca sacerdote pe, jare recuera ma rambue, emee mbota Moisés peócuai rami, tenta pegua reta oicuaa vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Erei cuimbae ojo, jare omboɨpɨ omombeu iru vae reta pe. Jecuae omombeu jeta vae pe. Jae rambue Jesús mbaeti ma ipuere ojo tenta reta pe tenta pegua reta jovaque. Opɨta mbaeti quia oicoa pe, jare yogüeru jae oia pe opaete que rupi güi. ");
INSERT INTO guiNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mbovɨ ara rupi Jesús ojo ye Capernaum pe, jare jeracua tenta pegua reta pe jae oime oi jo pe. ");
INSERT INTO guiNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jayave jeta vae oñemboatɨ joco pe, jare tɨnɨe yae ma o, jare yatɨ vi icatu pe onque rupi. Jare Jesús omombeu Tumpa iñee chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jayave amogüe yogüeru vae reta güeru metei cuimbae imbaerasɨ vae. Cuae cuimbae mbaeti ipuere omɨi. Oyevoɨuca ou irundɨ cuimbae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Erei güeru vae reta mbaeti ipuere güɨroique cuimbae Jesús oia pe yatɨ vae reta jeco pegua. Jae rambue oyeupi reta ovapɨa re jare oequi mbovɨ ovapɨa güi Jesús iárambue. Jare oequi ma yave, ombogüeyɨ reta cuimbae mbaeti ipuere omɨi vae jupa reve. ");
INSERT INTO guiNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús cuae oecha yave, oicuaa jae reta güɨrovia co jese, jare jei cuimbae mbaeti ipuere omɨi vae pe: —Nembaeyoa reta oñemboai ma, cherɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amogüe mboroócuai re oporomboe vae reta oguapɨ ñogüɨnoi joco pe, jare oñemongueta reta ipɨa pe: ");
INSERT INTO guiNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Maera pa jei corai cuae cuimbae? Jei icavi mbae vae Tumpa cotɨ. Tumpaño co ipuere iñɨro quia pe imbaeyoa reta re. Jocorai oñemongueta reta ipɨa pe. ");
INSERT INTO guiNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jare Jesús oicuaa voi jae reta iñemongueta, jare jei chupe reta: —¿Maera pa peñemongueta jocorai pepɨa pe? ");
INSERT INTO guiNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chepuere jae cuae cuimbae mbaeti ipuere omɨi vae pe: Nembaeyoa reta oñemboai ma. Jae ramiño vi chepuere jae chupe: Epúa evoɨ nderupa, jare eguata. ¿Mbae nunga pa mbaetita yavai jae vaera? —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Erei aipota peicuaa vaera cuae: Che cuimbaera ayeapo vae chepuere cheɨro quia pe imbaeyoa reta re ɨvɨ pe ai rambueve —jei. Jayave jei cuimbae mbaeti ipuere omɨi vae pe: ");
INSERT INTO guiNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Che jae ndeve: Epúa evoɨ nderupa, jare ecua ndero pe. ");
INSERT INTO guiNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jayave cuimbae opúa, jare ovoɨ jupa, jare oe ojo opaete joco pe ñogüɨnoi vae reta jovaque. Opareve ipɨacañɨ yae, jare omboete Tumpa. —Mbaeti ete yaecha yepi cuae nunga —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jayave Jesús oe, jare ojo ye ɨ guasu jembeɨ pe. Jare opaete vae oñemboatɨ jae oia pe, jare jae omboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jare joco güi ojo yave, oecha Alfeo taɨ Leví jee vae oguapɨ oi mburuvicha peguara ocovara ñogüɨnoia pe, jare jei chupe: —Eyu cherupíe. Jayave Leví opúa, jare ojo jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jare Jesús ocaru oi rambueve Leví jo pe, jeta mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta ocaru vi ñogüɨnoi Jesús jare jemimboe reta ndive. Echa jecuaeño jeta jae reta yogüɨraja Jesús ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jayave mboroócuai re oporomboe vae reta jare fariseo reta oecha yave Jesús ocaru oi ocovara vae reta jare teco icavi mbae vae oyapo vae reta ndive, jei jemimboe reta pe: —¿Maera pa ocaru ocovara vae reta jare teco icavi mbae vae oyapo vae reta ndive? ");
INSERT INTO guiNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús cuae oendu yave, jei chupe reta: —Mbaeti mbae jasɨ chupe vae reta mbaeti oeca oporopoano vae. Imbaerasɨ vae retaño oeca. Che ayu aeni vaera iyoa vae reta, mbaeti jupi vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jare Juan jemimboe reta jare fariseo jemimboe reta oyecuacu ñogüɨnoi tembíu güi. Jayave amogüe vae yogüeru, jare oparandu Jesús pe: —¿Maera pa Juan jemimboe reta jare fariseo jemimboe reta oyecuacu tembíu güi, erei neremimboe reta mbaeti oyecuacu chugüi? ");
INSERT INTO guiNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jayave Jesús jei chupe reta: —Omendata vae pɨri ñogüɨnoi vae reta ngaraa etei oyecuacu tembíu güi, omendata vae jae reta ndive oi rambueve. Echa omendata vae jae reta ndive oi rambueve, mbaeti ipuere oyecuacu tembíu güi. ");
INSERT INTO guiNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Erei outa ovae ara omendata vae oyererajauca vaera chugüi reta. Jayave ramo oyecuacuta tembíu güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mbaeti icavi ñamboya vaera temimonde indechi vae maemboyaa ipɨau vae pe. Echa jocorai yayapo yave, maemboyaa ipɨau vae omoata temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jae ramiño vi mbaeti icavi ñamboɨru vaera vino ipɨau vae vino jɨru guasupi indechi vae pe. Echa jocorai yayapo yave, vino omondoro jɨru, jare vino oyepɨyere, jare jɨru mbaeti ma icavi. Jae rambue ñamboɨru vino ipɨau vae jɨru ipɨau vae pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mbutuu iara pe Jesús ojo co reta rupi jemimboe reta ndive. Oasa rambueve, jemimboe reta oipoo trigo. ");
INSERT INTO guiNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jayave fariseo reta jei Jesús pe: —Mase, ¿maera pa oyapo reta agüɨyeta tei oyapo mbutuu iara pe vae? ");
INSERT INTO guiNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","—¿Mbaeti etei pa pemongueta David oyapogüe vae regua —jei Jesús chupe reta—, jae jare jae ndive ñogüɨnoi vae reta mbaeti ma mbae güɨnoi jare ñɨmbɨaɨ reta yave? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David oique Tumpa jo pe, sacerdote tenondegua Abiatar jee vae oico yave, jare jou mbɨyape reta Tumpa jo pe oñeñono tee vae. Agüɨyeta tei co quia jou jocuae mbɨyape, jaeño sacerdote reta. Jare David omee vi jae ndive ñogüɨnoi vae reta pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jayave Jesús jei ye chupe reta: —Mbutuu iara oyeapo ñanemborɨ vaera. Ñande mbaeti yayeapo mbutuu iara peguara. ");
INSERT INTO guiNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jae rambue che cuimbaera ayeapo vae chepuere jae mbae icavi oyeapo vaera mbutuu iara pe vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús oique ye judío reta itupao pe, jare oi joco pe metei cuimbae iporovaicho omano vae. ");
INSERT INTO guiNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jare joco pe ñogüɨnoi vae reta omae ngatu Jesús re, oecha vaera ombogüerata ra mbutuu iara pe. Echa jae reta oipota tei omboeco Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jayave Jesús jei cuimbae iporovaicho omano vae pe: —Eyu eñemboɨ cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jare Jesús oparandu joco pe ñogüɨnoi vae reta pe: —¿Yayapota pa icavi vae ani icavi mbae vae mbutuu iara pe? ¿Icavi pa yaporoepɨ ani yaporoyuca vaera mbutuu iara pe? ¿Mbae pa jei mboroócuai cuae re? —jei chupe reta. Erei jae reta mbaeti mbae jei. ");
INSERT INTO guiNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pochɨ reve Jesús omae iyɨpɨ rupi ñogüɨnoi vae reta re, jare ipɨatɨtɨ yae jae reta ipɨatanta rambue. —Eupi ndepo —jei cuimbae pe. Jayave cuimbae oupi, jare ipo ocuera cavi ma. ");
INSERT INTO guiNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jayave fariseo reta oe judío reta itupao güi, jare oñomomiari voi herodiano reta ndive Jesús re, quiraita ra oyucauca. ");
INSERT INTO guiNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jayave Jesús jare jemimboe reta yogüɨraja ɨ guasu pe, jare yogüɨraja vi jaɨcue jeta yae vae Galilea güi. Jare yogüeru vi jae oia pe jeta yae Judea pegua reta, Jerusalén pegua reta, ɨvɨ Idumea pegua reta, Jordán jovaicho pegua reta, jare tenta reta Tiro jare Sidón iyɨvɨrigua reta, oendu yave opaete Jesús oyapogüe vae regua. ");
INSERT INTO guiNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jare Jesús oyócuai jemimboe reta omocatɨro vaera chalana, agüɨye vaera yatɨ vae reta oyopɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Echa jae ombogüera ma jeta vae, jare opaete iru imbaerasɨ vae reta oñomoañaaña yogüeru icotɨ. Echa oipota oya jese, opoco vaera jemimonde re. ");
INSERT INTO guiNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jare aña reta oecha Jesús yave, oyeatɨca jae jóvai jare iñeeata reve jei: —Nde co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jare Jesús oyócuai yae agüɨye vaera omombeu quia co jae. ");
INSERT INTO guiNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jayave Jesús ojo ɨvɨtɨ re, jare oeni jae oipota yogüeru vaera vae reta. Jare jae reta yogüeru jae oia pe. ");
INSERT INTO guiNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jare oiparavo doce cuimbae reta opɨta vaera jae ndive. Jae omondota omombeu reta vaera Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Omeeta vi chupe reta mbaepuere ombogüera vaera imbaerasɨ vae reta jare omondo vaera aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cuae co jae oiparavogüe vae reta jee: Simón (Jesús ombojee Pedro), ");
INSERT INTO guiNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","jare Zebedeo taɨ reta Jacobo jare Juan jee vae (Jesús ombojee cuae mócoi reve Boanerges. Cuae jee oipota jei: Ara jɨapu vae rami), ");
INSERT INTO guiNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","jare Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeo taɨ Jacobo jee vae, Tadeo, Simón (jae co metei cananita), ");
INSERT INTO guiNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jare Judas Iscariote (cuae cuimbae omoeterenga Jesús jovaicho reta pe). Jayave Jesús ou ye jo pe jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jare oñemboatɨ ye jeta vae. Jae rambue Jesús jare jemimboe reta mbaeti ipuere ocaru. ");
INSERT INTO guiNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús jentara reta cuae oicuaa yave, yogüeru güɨraja vaera tei. —Mbaeti ma iyaracuaa oi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jare mboroócuai re oporomboe vae yogüeru Jerusalén güi vae reta jei: —Aña guasu Beelzebú jee vae oya ma jese, jare aña guasu imbaepuere pe omondo aña reta oya jese vae reta güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jayave Jesús oeni reta, jare jei chupe reta omojaanga reve: —¿Quirai pa ipuere Satanás omondo Satanás etei? ");
INSERT INTO guiNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Metei tenta pegua reta oyovaicho oyoupi yave, opata co jocuae tenta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jae ramiño vi metei o pegua reta oyovaicho oyoupi yave, opata co jocuae o. ");
INSERT INTO guiNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jare Satanás pochɨ iyeupe yave, jare imbaepuere oñemboyao yave, ngaraa tei ma oico. Opata tei co —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Oime yave quia oipota oique cuimbae ipɨrata vae jo pe opɨro vaera imbaembae chugüi vae, oipocuata rani cuimbae ipɨrata vae. Jayave ramo ipuereta opɨro imbaembae chugüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Añete che jae peve, opaete ɨvɨ pegua reta imbaeyoa reta jare opaete iñee icavi mbae Tumpa cotɨ jei reta vae Tumpa ipuere omboai. ");
INSERT INTO guiNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Erei Tumpa ngaraa etei iñɨro jei icavi mbae vae Espíritu Santo cotɨ vae pe. Oñemboecota jecuaecuae aveiño —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Echa tenonde yave jae reta jei: —Aña oya ma jese—. Jae rambue Jesús jei jocorai chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jayave Jesús ichɨ jare tɨvɨ reta yogüeru ovae Jesús oia pe, jare icatu güi omondo oeniuca. ");
INSERT INTO guiNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jare oguapɨ ñogüɨnoi iyɨpɨ rupi vae reta jei chupe: —¡Aipo! ndesɨ jare nderɨvɨ reta icatu pe ñogüɨnoi, jare ndereca. ");
INSERT INTO guiNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—¿Quia nunga pa co jae chesɨ jare cherɨvɨ reta? —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jayave omae iyɨpɨ rupi oguapɨ ñogüɨnoi vae reta re. —Cuae nunga reta co jae chesɨ jare cherɨvɨ reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Echa opaete Tumpa jemimbota oyapo vae reta co jae cherɨvɨ, jare chereindɨ, jare chesɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús omboɨpɨ ye oporomboe ɨ guasu jembeɨ pe. Jayave jeta yae vae yogüeru oñemboatɨ jae oia pe. Jae rambue Jesús oyeupi chalana ɨ guasu pe oi vae pe, jare oguapɨ pɨpe. Jare yatɨ vae reta ñogüɨnoi ɨ guasu jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jare omboe reta jeta mbaembae re omojaanga reve. Jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Peyeapɨsaca cheré. Metei cuimbae ojo omaetɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Omaetɨ yave, omoai temitɨ, jare amogüe oa tape rupi. Jayave yogüeru güɨra reta opa jou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iru temitɨ oa mbovɨño ɨvɨ ita guasu iárambue oia pe. Cuae ɨmambae oe, mbaeti jeta ɨvɨ chupe rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Erei cuaraɨ jasɨ yave, ipiru. Jare japo mbaeti icavi rambue, otini —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Iru temitɨ oa ñanapɨte pe. Ñana ocuacuaa yave, ombopɨtupa temitɨ. Jae rambue temitɨ mbaeti ia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jare iru temitɨ oa ɨvɨcavi pe. Cuae reta oe, jare ocuacuaa, jare ia. Amogüe mbovɨ catu jaɨ, jare iru jeta jaɨ, jare iru jeta yae jaɨ —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jayave Jesús jei ye chupe reta: —Ipuere oendu vae toyeapɨsaca cuae re. ");
INSERT INTO guiNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mbovɨño ma opɨta jae ndive yave, jocuae doce oiparavogüe vae reta jare iru opɨta vae reta oparandu Jesús pe omojaanga reve jei vae re. ");
INSERT INTO guiNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jayave Jesús jei chupe reta: —Amombeu ma peve Tumpa iporoocuaia regua. Cuae mbaeti oyecuaa iru vae reta pe. Jae rambue amboe iru vae reta amojaanga reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Cuae ayapo agüɨye vaera oecha cavi, yepe tei omae, jare agüɨye vaera oicuaa, yepe tei oendu, jare agüɨye vaera oyerova Tumpa cotɨ, imbaeyoa reta oñemboai vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jayave Jesús jei ye chupe reta: —¿Mbaeti pa peicuaa mbae cuae amojaanga reve jae peve vae oipota jei vae? Mbaeti yave, ¿quiraita pa peicuaa mbae opaete amojaanga reve jaeta peve vae oipota jei vae? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jocuae omaetɨ vae oñemojaanga Tumpa iñee omombeu vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Temitɨ tape rupi oa vae oñemojaanga amogüe Tumpa iñee oendu vae re. Erei jupiveiño ou Satanás, jare omoacañɨ Tumpa iñee güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jae ramiño vi jocuae temitɨ oñeotɨ mbovɨño ɨvɨ ita guasu iárambue oia pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. Jupiveiño oyerovia reta, jare oipota yae cuae ñee. ");
INSERT INTO guiNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Erei cuae reta jocuae temitɨ japo mbaeti icavi vae rami co. Jae rambue ɨmambae icuérai reta. Mbaesusere oyeapo chupe reta ani iru vae reta oyapo icavi mbae vae chupe reta Tumpa iñee jeco pegua. Jare jupiveiño mbaeti oipota reta oyeapɨsaca Tumpa iñee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jae ramiño vi jocuae temitɨ oñeotɨ ñanapɨte pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. ");
INSERT INTO guiNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Erei jae reta omboɨpɨ oñemambeco ɨvɨ pe oyeapo vae re, jare oñembotavɨ, oipota yae oicocatu vaera rambue. Oipota vi güɨnoi jeta mbaembae reta. Jare opaete cuae omoacañɨ reta Tumpa iñee güi. Jae rambue jae reta jocuae temitɨ mbaeti ia vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Erei jocuae temitɨ oñeotɨ ɨvɨcavi pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. Cuae reta güɨrovia. Amogüe vae jocuae temitɨ mbovɨ catu jaɨ vae rami co. Iru vae reta jocuae temitɨ jeta jaɨ vae rami co. Jare iru vae reta jocuae temitɨ jeta yae jaɨ vae rami co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jayave Jesús jei ye chupe reta: —Mechero yaroique yave o pe, mbaeti etei ñañono yapepo oñembovapɨ oi vae igüɨ pe, ani güɨrapembɨ igüɨ pe. Ñañono co mechero jenda pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Oime yave mbae oñemi vae, oyeechaucañotai co. Jae ramiño vi oime yave mbae oyeasoi vae, oyecuaañotai co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ipuere oendu vae toyeapɨsaca cuae re —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jare jei ye chupe reta: —Peñemongueta cavi peendu vae re. Iru vae reta ojaata peve pejaa iru vae reta pe rami, jare omoiruta vi peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Echa güɨnoi vae pe oñemoiruta, jare mbaeti güɨnoi vae güi michi yae güɨnoi vae oyeequita —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jare Jesús jei ye chupe reta: —Tumpa iporoocuaia metei cuimbae ojo omaetɨ vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuimbae oque pɨtu ñavo, jare opúa ara ñavo. Temitɨ oe jare ocuacuaa, jare omaetɨ vae mbaeti oicuaa quirai ra ocuacuaa. ");
INSERT INTO guiNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Echa temitɨ ocuacuaa ñamborɨ mbae reve, tenonde iɨ, jayave avatiquɨ, jayave avati —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jare yagüɨye ma yave, iya oarɨvo voi. Echa ovae ma ara oarɨvo vaera —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jare Jesús jei ye: —¿Mbae ra ipuere oñemojaanga Tumpa iporoocuaia re? ¿Mbae ra ñamojaangata jese? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ñandepuere ñamojaanga jese metei mostaza jaɨgüe —jei—. Oñeotɨ yave, cuae jaɨgüe michi yae opaete iru temitɨ reta jaɨgüe ɨvɨ pe oi vae güi. ");
INSERT INTO guiNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Erei oñeotɨ güire, ocuacuaa, jare tuicha yae opaete iru temitɨ metei año peguaño ocuacuaa vae reta güi, jare tuicha jaca oyeapo. Jae rambue güɨra reta ipuere oyapo jaitɨra jese cuaraɨa pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeta corai Jesús omombeu Tumpa iñee chupe reta omojaanga reve, jae reta ipuere oicuaa rupiño. ");
INSERT INTO guiNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jare imiari chupe reta ñavo, imiari chupe reta omojaanga reve. Erei jemimboe reta peño omombeu cavi mbae oipota jei vae. ");
INSERT INTO guiNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jocuae ara cuaraɨ oique ma yave, —Yaja ɨ guasu jovaicho pe —jei Jesús jemimboe reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jayave jae reta omondo yatɨ vae reta, jare güɨraja Jesús jocuae chalana pɨpe oi vae pe. Jare iru vae reta vi yogüɨraja iru chalana reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jare ou ɨvɨtu tanta oyepeyu, jare ɨaparúa oñeñoña chalana pe, jare omotɨnɨe seri ma. ");
INSERT INTO guiNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jare Jesús oñemoacanguɨta chalana iyapɨ pe, jare oque oi. Jayave jae reta omomba jare jei chupe: —¡Oporomboe vae! ¿mbaeti pa mbae reipota reyapo, agüɨye vaera ñamano? ");
INSERT INTO guiNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jayave Jesús opúa, jare oñeengata ɨvɨtu pe. —¡Epɨta! ¡Nequirii! —jei ɨ guasu pe. Jare mbaeti ma ɨvɨtu, jare opaete quirii. ");
INSERT INTO guiNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jayave Jesús oparandu chupe reta: —¿Maera pa pequɨye? ¿Mbaeti pa peporogüɨrovia? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jare oquɨye yae reta, jare jei oyoupe: —¿Mbae nunga cuimbae pa cuae? Ɨvɨtu jare ɨ guasu oyapo oyocuaigüe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jayave yogüɨraja ovae ɨ guasu jovaicho pe gadareno reta iɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús ogüeyɨ ma chalana güi rupive, ou oovaiti teogüerɨrurenda güi cuimbae aña oya jese vae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jae oico teogüerɨrurenda rupi, jare mbaeti ma quia ipuere oñapɨti, yepe tei oñapɨti cadena pe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jeta vese ma jae reta oñapɨti tei cadena pe jare oipocua tei jiero pe. Erei jae omondoo cadena reta, jare opa oyoca ipocuaa. Jare mbaeti quia ipuere jese. ");
INSERT INTO guiNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jare jecuaeño pɨtu rupi jare ara rupi oi teogüerɨrurenda rupi jare ɨvɨtɨ rupi, jare jecuae osapúcai jare oñembopere ita pe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cuae cuimbae oecha yave Jesús mombɨrɨ güi, osɨi icotɨ jare oyeatɨca jóvai. ");
INSERT INTO guiNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jare iñeeata reve jei: —¿Maera pa reyu chemambeco, Jesús? Nde co jae Tumpa ara pe oi vae Taɨ. Ayerure ndeve Tumpa jee re agüɨye eiporarauca cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Echa Jesús jei aña pe: —Ecua cuae cuimbae güi, aña. ");
INSERT INTO guiNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jayave Jesús oparandu chupe: —¿Mbae pa nderee? —Cheree co jae jeta vae. Echa jeta yae co ore —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jare aña reta oyerure yae Jesús pe agüɨye vaera omondo reta jocuae ɨvɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jare joco pe jeta cuchi reta ocaru ñogüɨnoi coiño ɨvɨtɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jayave aña reta oyerure Jesús pe: —Oremondo cuchi reta pe. Emaeño toroya jese reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jayave Jesús omaeño jese reta. Jare aña reta yogüɨraja cuimbae güi, jare oya cuchi reta re. Jayave cuchi reta osɨi tanta oa ɨ guasu pe ɨvɨa güi, jare joco pe ipɨtupa. Oyepapa dos mil rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jayave cuchi iñangarecoa reta otecuarai, jare omombeu tenta pegua reta pe jare icatu rupigua reta pe oyeapo vae regua. Jare oendu vae reta yogüeru, oecha vaera mbae oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jare yogüeru ovae yave Jesús oia pe, oecha cuimbae aña oya jesegüe vae oguapɨ oi joco pe. Oecha oñemonde ma jare iyaracuaa cavi ma oi. Jae co tenonde yave jeta aña oya jese vae. Jare opaete yogüeru vae reta oquɨye. ");
INSERT INTO guiNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jare jocuae cuchi iñangarecoa tenonde yave oecha vae reta omombeu iru reta pe quirai oyeapo cuimbae aña oya jesegüe vae pe jare cuchi reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jayave yatɨ vae reta omoñera Jesús ojo vaera iɨvɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jare Jesús oyeupi ye yave chalana pe, cuimbae aña oya jesegüe vae oyerure chupe: —Emaeño cheré aja vaera nderupíe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Erei Jesús mbaeti omaeño jese. —Ecua ndero pe emombeu nerentara reta pe mbae icavi yae vae ndeYa oyapo ndeve vae —jei chupe—, jare quirai ndeparareco —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jayave cuimbae ojo, jare omboɨpɨ omombeu ɨvɨ Decápolis jee vae pe mbae icavi yae vae Jesús oyapo chupe vae. Jare opaete vae ipɨacañɨ jese. ");
INSERT INTO guiNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús ojo ovae yave ɨ guasu jovaicho pe chalana pe, yogüeru jeta yae vae jae oia pe. Jare Jesús opɨta ɨ guasu jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jayave ou metei cuimbae Jairo jee vae. Jae co judío reta itupao re oñangareco vae. Oecha yave Jesús, oyeatɨca jóvai. ");
INSERT INTO guiNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jare oyerure yae chupe: —Cherayɨ omanota ma oi —jei—. Yaja eñono ndepo jese embogüera, agüɨye vaera omano —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jayave Jesús ojo jae jupíe. Jare jeta yae vae yogüɨraja Jesús jupíe, jare oyopɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jare jae reta jupíe ojo metei cuña doce año ma oiporara tugüɨguasu vae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jare oiporara yae ma jeta oporopoano vae reta oipoano tei reve, jare opaete icorepoti omee ma oporopoano vae reta pe. Erei mbaeti etei ocuera. Jeseve jeieteño ma imbaerasɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jae oendu Jesús regua yave, oya Jesús re icupe cotɨ jeta vae reta ipɨte rupi, jare oyavɨquɨ jemimonde. ");
INSERT INTO guiNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Yepe tei jemimondeño tayavɨquɨ, erei acuerata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jare jupiveiño jugüɨguasu opɨta chugüi, jare oñandu jete ocuera ma imbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jayave Jesús oicuaa ombogüera ma co quia imbaepuere pe. Jae rambue oyerova omae jeta vae re, jare oparandu: —¿Quia pa cheremimonde oyavɨquɨ? ");
INSERT INTO guiNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jayave jemimboe reta jei chupe: —Reecha co cuae jeta vae ndeopɨ ñogüɨnoi. ¿Maera pa rere: Quia pa cheremimonde oyavɨquɨ? —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Erei Jesús omae iyɨpɨ rupi, oecha vaera quia ra jocorai oyapo. ");
INSERT INTO guiNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cuña oicuaa oyeapo ma chupe vae, jare ou icotɨ. Oquɨye güi orɨrɨi, jare oyeatɨca Jesús jóvai, jare omombeu chupe opaete oyeapo ma vae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jayave Jesús jei chupe: —Recuera ma, chereindɨ, rerovia cheré rambue. Ecua ndepɨacatu reve. Recuera ma co nembaerasɨ güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jare Jesús imiari oi rambueve, yogüeru ovae amogüe vae tupao re oñangareco vae jo güi. —Nderayɨ omano ma —jei reta—. Agüɨye mo emambeco oporomboe vae —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Erei Jesús cuae oendu yave, jei tupao re oñangareco vae pe: —Agüɨye ndepɨatɨtɨ. Eporogüɨroviaño —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jare mbaeti omaeño iru reta re yogüɨraja vaera jae ndive, jaeño Pedro, Jacobo, jare Juan - jae co Jacobo tɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yogüɨraja ovae yave tupao re oñangareco vae jo pe, Jesús oecha jeta osapúcai vae reta. Oyaeo jare jase yae ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús oique yave o pe, jei chupe reta: —¿Maera pa pesapúcai jare peyaeo? Cuae cuñatai mbaeti co omano. Oqueño co oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Erei jae reta oyóyai. Jayave Jesús omoe opaete vae oca pe, jare güɨroique cuñatai oia pe cuñatai tu jare ichɨ, jare jemimboe jae ndive yogüɨraja vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jayave Jesús oipɨɨ cuñatai ipo pe. —Talita cumi —jei chupe. (Cuae oipota jei: ¡Cuñatai! che jae ndeve: ¡Epúa!) ");
INSERT INTO guiNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jayave cuñatai opúa jare omboɨpɨ oguata. Echa doce año ma güɨnoi. Jare Jesús ndive ñogüɨnoi vae reta ipɨacañɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jayave Jesús oyócuai yae reta agüɨye vaera omombeu quia pe, jare oyócuai vi omongaru vaera cuñatai. ");
INSERT INTO guiNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús ojo joco güi iɨvɨ ae pe, jare jemimboe reta vi yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jayave mbutuu iara pe Jesús omboɨpɨ oporomboe judío reta itupao pe. Jare jeta vae oyeapɨsaca jese, jare ipɨacañɨ. Jei reta oyoupe: —¿Quiape pa oñemboe cuae cuimbae opaete cuae re? ¿Mbae nunga aracuaa pa oñemee chupe? ¿Mbae nunga mɨacañɨ pa cuae oyapo ipo pe vae? —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Cuae co jae carpintero. Jae co María imembɨ. Jae co Jacobo, José, Judas, jare Simón tɨqueɨ. Jare jeindɨ reta yogüɨreco vi ñanerenta pe —jei reta. Jae rambue jae reta pochɨ Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jayave Jesús jei chupe reta: —Opaete vae omboete metei Tumpa iñee omombeu vae. Jaeño jentaɨgua reta, jentara reta, jare jo pegua reta mbaeti omboete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jare joco pe mbaeti ipuere oyapo mɨacañɨ tuicha vae. Jaeño oñono ipo mbovɨ imbaerasɨ vae reta re ombogüera vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jare Jesús ipɨacañɨ jese reta, jae reta mbaeti güɨrovia jese rambue. Jayave Jesús ojo oporomboe iru tenta jocoropi ñogüɨnoi vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Metei ara Jesús oeni jocuae doce jemimboe reta, jare omondo mocomócoi pe, jare omee chupe reta mbaepuere omondo vaera aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jare oyócuai: —Peo yave, agüɨye mbae peraja, jaeño pepopoca. Agüɨye peraja peaporoca, perembiura, jare corepoti —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pemonde pepɨapaa, jare agüɨye pemonde mócoi camisa —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jare jei ye chupe reta: —Peo pevae yave metei o pe, joco pe pei, jocuae tenta güi peo regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jare oime yave metei tenta pegua reta mbaeti oipota pepɨta vaera joco pe jare mbaeti oipota oyeapɨsaca peré vae, pecuaño joco güi, jare pemotumo ɨvɨtimbo pepɨ güi, oicuaa vaera jae reta co teco güɨnoi —jei—. Añete che jae peve, Tumpa ojaa yave ɨvɨ pegua reta, jocuae tenta pegua reta oiporara yaeta Sodoma jare Gomorra pegua reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jayave jae reta yogüɨraja, jare omombeu iru vae reta pe: —Peeya peñemongueta icavi mbae vae pepɨa pe oi vae. ");
INSERT INTO guiNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jare jae reta omondo jeta aña reta oya jese vae reta güi, jare jeta imbaerasɨ vae reta re oñono mbaequɨra ombogüera vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Opaete vae oendu ma Jesús regua. Mburuvicha guasu Herodes jee vae oendu vi. Jae jei: —Juan oporombobautizase vae oicove ye ma ou omanogüe vae reta ipɨte güi. Jae rambue oyapo cuae mɨacañɨ reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Iru vae reta jei: —Jae co Elías. Jare iru vae reta jei: —Jae co metei Tumpa iñee omombeu vae Tumpa iñee aracae omombeu vae rami. ");
INSERT INTO guiNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erei Herodes oendu yave, jei: —Jae co Juan aiñacasɨauca vae. Oicove ye ma ou omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Echa ndei Juan omano mbove, Herodes omenda Felipe jembireco Herodías jee vae ndive. Felipe co jae Herodes tɨvɨ. Jayave Herodes omondo oipɨuca Juan, jare oñonouca tembipɨɨrɨru pe, Herodías oipota rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Echa tenonde yave Juan jei Herodes pe: —Mbaeti icavi remenda vaera nderɨvɨ jembireco ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jae rambue Herodías pochɨ Juan pe, jare oipota tei oyucauca, erei mbaeti ipuere. ");
INSERT INTO guiNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Echa Herodes oicuaa Juan co jae cuimbae jupi vae. Jae rambue oquɨye chugüi, jare mbaeti omaeño quia re oyapo vaera icavi mbae vae chupe. Jare oendu yave Juan jei vae, oñemambeco yae. Erei jecuaeño oipota oyeapɨsaca jese. ");
INSERT INTO guiNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erei ovae ara Herodías oyapo vaera icavi mbae vae Juan pe. Jocuae ara Herodes omboarete oaa, jare omboatɨuca iru mburuvicha reta, sundaro reta juvicha reta, jare oicocatu vae Galilea pegua reta, omongaru vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jare Herodías imembɨ cuña oique opɨrae yave, omboyerovia Herodes jare jae ndive ocaru ñogüɨnoi vae reta. Jayave Herodes jei cuñatai pe: —Eyerure cheve mbae reipota vae re, jare che ameeta ndeve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jare jei ye chupe Tumpa jee re: —Oipotagüe reyerure cheve jese vae ameeta ndeve, cheɨvɨ mbɨte rupi yepe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jayave cuñatai oe ojo oparandu ichɨ pe: —¿Mbae re pa ayerureta chupe? —Eyerure chupe Juan oporombobautizase vae iñaca re —jei ichɨ chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jayave ɨmambaeño cuñatai oique ye mburuvicha guasu oia pe. —Aipota remee vaera cheve añave voi Juan oporombobautizase vae iñaca metei ñai pe —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jayave mburuvicha guasu ipɨatɨtɨ yae. Erei Tumpa jee re jei chupe rambue, jare iru vae reta oendu rambue, mbaeti oipota jei chupe: Ani. ");
INSERT INTO guiNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jae rambue omondo sundaro tembipɨɨrɨru pe, Juan iñaca güeru vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jayave ojo sundaro tembipɨɨrɨru pe oiñacasɨa Juan. Jayave güeru iñacagüe metei ñae pe, jare omee cuñatai pe. Jare cuñatai omee ichɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jare Juan jemimboe reta cuae oicuaa yave, yogüeru güɨraja jetegüe oñotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús jemimondo reta oñemboatɨ ye yave ipɨri, omombeu reta chupe opaete oyapogüe jare oporomboe jese vae. ");
INSERT INTO guiNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jayave Jesús jei chupe reta: —Pe retaño peyu yaja mbaeti quia oicoa pe, peputuu vaera michi pegua —jei. Echa jecuaecuae jeta vae yogüeru opou ipɨri. Jae rambue Jesús jare jemimboe reta mbaeti ipuere ocaru. ");
INSERT INTO guiNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jayave jae retaño yogüɨraja chalana pe mbaeti quia oicoa pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Erei jeta vae oecha yogüɨraja, jare oicuaa quia co jae. Jare yogüɨraja ɨvɨ rupiño tenta reta güi Jesús ojoa pe, jare yogüɨraja ovae ndei Jesús ojo ovae mbove, jare oñemboatɨ joco pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús ogüeyɨ yave chalana güi, oecha jeta yae vae, jare oiparareco reta. Echa jae reta vecha iñangarecoa mbae vae reta rami. Jare omboɨpɨ omboe reta jeta mbaembae re. ");
INSERT INTO guiNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Caaru ma yave, Jesús jemimboe reta yogüeru jei chupe: —Mbaeti quia oico cuae pe jare caaru ma co. ");
INSERT INTO guiNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Emondo cuae reta, yogüɨraja vaera tenta oime coropi ñogüɨnoi vae reta pe. Joco pe togua jembiura. Echa mbaeti mbae jou reta vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Erei Jesús jei chupe reta: —Pe reta pemee tocaru. —¿Rojota pa rogua doscientos denario pegua mbɨyape, romee vaera ocaru reta? —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús jei chupe reta: —¿Mbovɨ mbɨyape pa oime penoi? Pecua peeca —jei. Jae reta oicuaa ma yave, omombeu Jesús pe: —Oime rogüɨnoi cinco mbɨyape jare mócoi jevae ɨ rupigua —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jayave Jesús oyócuai opaete vae oñemboatɨatɨ vaera oguapɨ capiata joquɨ vae re. ");
INSERT INTO guiNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jayave oñemboatɨatɨ reta oguapɨ cien rupi jare cincuenta rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jayave Jesús oipɨɨ jocuae cinco mbɨyape jare mócoi jevae ɨ rupigua, jare omae ara re, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape reta, jare omee jemimboe reta pe, jae reta omee vaera yatɨyatɨ ñogüɨnoi vae reta pe. Jesús opɨsae vi jocuae mócoi jevae ɨ rupigua, oñemee vaera opaete vae pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Opareve ocaru, jare jɨvata. ");
INSERT INTO guiNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jayave Jesús jemimboe reta omboatɨ tembíu oñepɨsaegüe jembɨre vae, jare omotɨnɨe doce canasta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jare ocaru vae reta güi cuimbaegüeño oyepapa cinco mil. ");
INSERT INTO guiNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jare jupiveiño Jesús oyócuai jemimboe reta oyeupi vaera chalana pe, jare yogüɨraja vaera jenonde ɨ guasu jovaicho pe tenta Betsaida pe, jae omondo rambueve yatɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jare opa omondo yave yatɨ vae reta, jae oyeupi ɨvɨtɨ re oyerure vaera Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pɨtu ma yave, chalana jemimboe reta yogüɨraja pɨpe vae ɨ guasu mbɨte pe ma ojo, jare Jesusño opɨta ɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jare Jesús oecha tanta ma oparavɨquɨ reta, güɨroata vaera chalana. Echa ɨvɨtu tanta oovaiti. Jare coe seri ma yave, Jesús oguata ojo ɨ iárambue oupitɨ. Jare oasata tei chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jae reta oecha yave oguata ojo ɨ iárambue, oñemongueta tei oecha mbae iagüe, jare osapúcai reta. ");
INSERT INTO guiNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Echa opaete jae reta oecha, jare ipɨacañɨ yae. Erei jupiveiño Jesús ombou iñee chupe reta: —Peñemoatangatu. Che co. Agüɨye pequɨye —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jayave Jesús ou oyeupi chalana pe, jare opɨta ɨvɨtu. Jare jae reta ipɨacañɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Echa jocuae mɨacañɨ mbɨyape regua oyapo yave, Jesús oipota tei jae reta oicuaa cavi vaera. Erei ndeiño oicuaa. Echa ipɨatanta vɨteri. ");
INSERT INTO guiNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Ɨ guasu oasa reta yave, yogüɨraja ovae ɨvɨ Genesaret pe. Jare ogüeyɨ reta yave chalana güi ɨ guasu jembeɨ pe, jupiveiño joco pegua reta oicuaa jae co Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jare yogüɨraja opaete jocuae ɨvɨ rupi, jare omboɨpɨ güeru imbaerasɨ vae reta jupa reve Jesús oia pe. Iru vae reta omombeu chupe reta quiape oi. ");
INSERT INTO guiNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jare Jesús ojo tenta michi vae reta pe, jare tenta tuicha vae reta pe, jare tenta reta icatu rupi. Jare ojoa rupi joco pegua reta güeru oñono imbaerasɨ vae reta tape reta pe, jare oyerure Jesús pe imbaerasɨ vae reta oyavɨquɨ vaera jemimonde jembeɨ yepe. Jare opaete jemimonde oyavɨquɨ vae reta ocuera. ");
INSERT INTO guiNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo reta jare amogüe mboroócuai re oporomboe vae Jerusalén güi yogüeru vae reta oñemboatɨ Jesús oia pe. ");
INSERT INTO guiNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jae reta oecha amogüe Jesús jemimboe reta ocaru ñogüɨnoi oyepoe mbae reve - ipo iquɨa vae judío reta jei chupe vae. Jae rambue omboeco reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Echa fariseo reta jare opaete judío reta jecuaeño jeta oyepoe ndei ocaru mbove, oyapo vaera itenondegua reta iporomboe. ");
INSERT INTO guiNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jare yogüeru yave omaemee vae reta ñogüɨnoia güi, jecuaeño oyepoe ndei ocaru mbove. Jare oyapo reta jeta iru itenondegua reta iporomboe. Echa oyoe vaso reta, yapepo reta, paila reta, jare tupa reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jayave fariseo reta jare mboroócuai re oporomboe vae reta oparandu Jesús pe: —¿Maera pa neremimboe reta mbaeti oyapo ñanetenondegua reta iporomboe? ¿Maera pa ocaru reta oyepoe mbae reve? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jayave Jesús jei chupe reta: —Añete yepe Isaías imiari pe reta re. Echa jae oicuatía oporombotavɨ vae reta re corai: Cuae reta chemboete imiari yave —jei Tumpa—. Erei ipɨa pe mbaeti etei chemboete. ");
INSERT INTO guiNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chemboete-raangaiño. Oporomboe cuimbae iporoócuai re. Che mbaeti jocorai aporoócuai —jei. Jocorai oicuatía Isaías —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Echa pe reta mbaeti peyapo Tumpa iporoócuai, erei peyapo cavi ñanetenondegua reta iporomboe. Peyoe yapepo reta jare vaso reta, jare jeta cuae nunga peyapo —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jare Jesús jei ye chupe reta: —Tumpa iporoócuai pemombo co, peyapo vaera ñanetenondegua reta iporoócuai. ");
INSERT INTO guiNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés jei corai: “Eaɨu nderu jare ndesɨ”. Jare jei ye corai: “Jei icavi mbae vae tu ani ichɨ cotɨ vae omanota co”. Jocorai jei Moisés —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Erei pe reta pere corai: Metei cuimbae ipuere jei tu ani ichɨ pe omeeta tei chupe omborɨ vaera vae Corbán co. Jocorai pere —jei—. (Corbán oipota jei: Amee ma Tumpa pe.) ");
INSERT INTO guiNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jayave pe reta mbaeti ma pemaeño jese omborɨ vaera tu jare ichɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jare jeta cuae nunga peyapo. Corai pe reta pemombo Tumpa iporoócuai peyapo vaera ñanetenondegua reta iporoócuai. Jare pere vi pemichia reta pe oyapo vaera ñanetenondegua reta iporoócuai —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jare Jesús oeni opaete joco pe ñogüɨnoi vae reta. —Peyeapɨsaca cuae re opaete pe reta, peicuaa cavi vaera —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Oipotagüe mbae peu vae oique perete pe icatu güi. Jae rambue mbaeti ipuere omonguɨa pepɨa. Jocuae peyapo jare pere vae omonguɨa pepɨa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ipuere oendu vae toyeapɨsaca cuae re —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jare Jesús oeya yatɨ vae reta yave, oique jo pe. Jayave jemimboe reta oparandu chupe omojaanga reve jei vae re. ");
INSERT INTO guiNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jayave Jesús jei chupe reta: —Pe reta vi ¿mbaeti pa peicuaa? Peicuaa cavi cuae: Oipotagüe mbae peu vae mbaeti ipuere omonguɨa pepɨa. ");
INSERT INTO guiNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Echa mbaeti oique pepɨa pe. Oique perɨe pe jare pemombo. Jocorai oyeapo opaete tembíu pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jare Jesús jei ye: —Jocuae peyapo jare pere vae omonguɨa pepɨa. ");
INSERT INTO guiNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Echa pepɨa pe peñemongueta icavi mbae vae, peñuvanga menda re, peyapo aguasa, peporoyuca, ");
INSERT INTO guiNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pemonda, peipota iru vae reta imbaembae, peyapo icavi mbae vae, peporombotavɨ, pemboquere, peipota peñemotenonde, icavi mbae vae pere iru vae cotɨ, peñembotuicha, jare peico iyaracuaa mbae vae reta rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Opaete cuae icavi mbae vae oe pepɨa güi. Jare cuae reta omonguɨa pepɨa —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jayave Jesús ojo ye joco güi Tiro jare Sidón iyɨ́vɨri. Jare oique yave metei o pe, mbaeti tei oipota quia oicuaa vaera jae joco pe oi. Erei oicuaañoi joco pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jare metei cuña aña oya imembɨ cuña re vae oendu Jesús regua, jare ou oyeatɨca jae jóvai. ");
INSERT INTO guiNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jae co metei sirofenicia griega pe imiari vae. Jae oyerure Jesús pe omondo vaera aña imembɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Erei Jesús jei chupe: —Tiɨvata rani michia reta. Mbaeti icavi yaequi vaera tembíu michia reta güi, ñamee vaera ñaɨmba-raɨ reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Añete tei co, carai —jei cuña Jesús pe—. Erei ñaɨmba-raɨ mesa igüɨ pe ñogüɨnoi vae reta jou tembíu oñemongüigüe michia reta oitɨ vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jayave Jesús jei chupe: —Cuae rere vae jeco pegua ndepuere reo. Aña ojo ma nemembɨ güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jayave cuña ojo jo pe, jare oecha imembɨ jupa pe oi. Aña ojo ma chugüi. ");
INSERT INTO guiNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jayave Jesús ou Tiro iyɨ́vɨri güi, jare oasa Sidón jare Decápolis rupi, jare ou ovae ɨ guasu Galilea pe oi vae pe. ");
INSERT INTO guiNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jare amogüe vae güeru chupe metei cuimbae. Cuae cuimbae upaupa jare iyapɨsa mbae. Güeru vae reta oyerure Jesús pe oñono vaera ipo jese. ");
INSERT INTO guiNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jayave Jesús güɨraja cuimbae yatɨ vae reta ipɨte güi. Oñono ipoaca cuimbae iyapɨsa pe. Jayave ondɨvɨ, jare opoco cuimbae icu re. ");
INSERT INTO guiNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jayave omae ara re, jare tanta ipɨtué, jare jei: —¡Efata! (Cuae oipota jei: ¡Eyepea!) ");
INSERT INTO guiNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jayave cuimbae oendu ma, jare icu omɨi cavi ma, jare iñee cavi. ");
INSERT INTO guiNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jayave Jesús oyócuai reta agüɨye vaera omombeu quia pe. Erei yepe tei oyócuai yae, erei jeseve jae reta omombeu iru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jae reta ipɨacañɨ yae, jare jei: —Opaete oyapo vae icavi yae. Ombogüera iyapɨsa mbae vae reta oendu cavi vaera, jare ombogüera vi upa reta iñee cavi vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Metei ara jeta yae vae oñemboatɨ yave, mbaeti ma mbae güɨnoi reta jou vaera. Jayave Jesús oeni jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Aiparareco cuae yatɨ vae reta —jei—. Echa mboapɨ ara ma ñogüɨnoi che ndive, jare mbaeti ma mbae güɨnoi jou vaera —jei jemimboe reta pe—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amondo yave jenta cotɨ ocaru mbae reve, ipɨtuta tape rupi. Echa amogüe yogüeru mombɨrɨ güi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—¿Quiraita pa ñandepuere ñamee mbɨyape chupe reta cuae mbaeti quia oicoa pe? —jei jemimboe reta Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jayave Jesús oparandu chupe reta: —¿Mbovɨ mbɨyape pa penoi? —Oime rogüɨnoi siete —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jayave Jesús oyócuai yatɨ vae reta oguapɨ vaera ɨvɨ re. Jayave oipɨɨ jocuae siete mbɨyape, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape reta, jare omee jemimboe reta pe, jae reta omee vaera yatɨ vae reta pe. Jayave jocorai oyapo reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jare güɨnoi vi mbovɨ jevae ɨ rupigua michi vae reta. Cuae re vi Jesús omee yasoropai Tumpa pe, jare jei jemimboe reta pe cuae vi omee vaera yatɨ vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Opareve ocaru, jare jɨvata. Jayave Jesús jemimboe reta omboatɨ tembíu oñepɨsaegüe jembɨre vae, jare omotɨnɨe siete canasta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jare joco pe ñogüɨnoi vae reta cuatro mil rupi. Jayave Jesús omondo yatɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jayave jae jare jemimboe reta oyeupi chalana pe, jare yogüɨraja ɨvɨ Dalmanuta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jayave yogüeru fariseo reta, jare omboɨpɨ oyoaca Jesús ndive. —Eechauca oreve mɨacañɨ ara güi —jei reta chupe. Jae reta oipota oicuaa oyapota ra mɨacañɨ chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jayave Jesús iayeequi. —¿Maera pa añave yogüɨreco vae reta oipota aechauca vaera chupe reta mɨacañɨ? —jei—. Añete che jae peve, ngaraa oyeechauca mɨacañɨ cuae reta pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jayave Jesús oeya, jare oyeupi ye chalana pe, jare ojo ɨ guasu jovaicho pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jare Jesús jemimboe reta iñacañɨ güeru vaera mbɨyape. Jaeño metei mbɨyape oi chalana pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jare Jesús jei chupe reta: —Peñeandu fariseo reta jare Herodes ilevadura güi. ");
INSERT INTO guiNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jayave jemimboe reta jei oyoupe: —Cuae jei mbaeti yaru mbɨyape rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús oicuaa mbae jei reta vae, jare jei chupe reta: —¿Maera pa pemiari oyoupe mbaeti mbɨyape peru vae re? ¿Mbaeti pa peicuaa vɨteri? ¿Tanta yae pa co pepɨa? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Peresa jare peapɨsa penoi. ¿Mbaeti pa peecha jare peendu? ¿Mbaeti pa pemaendúa? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cue yave apɨsae cinco mbɨyape, ocaru vaera cinco mil vae. Tembíu oñepɨsaegüe pemboatɨ yave, ¿mbovɨ canasta pa pemotɨnɨe? —jei. —Romotɨnɨe doce —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Jare siete mbɨyape apɨsae vi, ocaru vaera cuatro mil vae. Tembíu oñepɨsaegüe pemboatɨ yave, ¿mbovɨ canasta pa pemotɨnɨe? —jei ye Jesús. —Romotɨnɨe siete —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jayave Jesús jei ye chupe reta: —¿Mbaeti pa peicuaa vɨteri? ");
INSERT INTO guiNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jare yogüɨraja ovae Betsaida pe. Jayave amogüe vae güeru Jesús pe cuimbae jesa mbae vae, jare jae reta oyerure chupe oñono vaera ipo jese. ");
INSERT INTO guiNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jayave Jesús oipoco güɨraja cuimbae jesa mbae vae tenta güi. Jayave ondɨvɨ cuimbae jesa re. Jayave oñono ipo jese. —¿Ndepuere pa mbae reecha? —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cuimbae omae. —Cuimbae reta aecha —jei Jesús pe—. Erei ɨvɨra reta echa cheve. Erei aecha oguata ñogüɨnoi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jayave Jesús oñono ye ipo jesa re, oecha cavi vaera. Jare jesa ocuera, jare opaete mbaembae oecha cavi ma. ");
INSERT INTO guiNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jayave Jesús oyócuai: —Agüɨye ecua tenta rupi. Jare agüɨye emombeu metei ave cuae tenta pegua pe —jei chupe. Jayave omondo jenta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Coiño tenta Cesarea Filipo güi ñogüɨnoi amogüe tenta reta. Jocotɨ yogüɨraja Jesús jare jemimboe reta. Jare tape rupi Jesús oparandu jemimboe reta pe: —¿Quia pa co che iru vae reta pe? ");
INSERT INTO guiNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jae reta omombeu chupe: —Amogüe vae jei nde co jae Juan oporombobautizase vae, jare iru vae reta jei nde co jae Elías, jare iru vae reta jei nde co jae metei Tumpa iñee omombeu vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jayave Jesús oparandu ye chupe reta: —Jare ¿quia pa co che peve? Jayave Pedro jei chupe: —Nde co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jayave Jesús oyócuai reta agüɨye vaera omombeu quia pe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jayave Jesús omombeu chupe reta: —Che cuimbaera ayeapo vae jetata aiporara. Jare tenta pegua reta itenondegua reta, sacerdote reta itenondegua reta, jare mboroócuai re oporomboe vae reta chereroɨrota jare cheyucaucata. Erei mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cuae omombeu cavi chupe reta. Jayave Pedro güɨraja Jesús iru reta ipɨte güi, jare omboɨpɨ oñeengata chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Erei Jesús oyerova omae iru jemimboe reta cotɨ, jare oñeengata Pedro pe. —Ecua chegüi, Satanás —jei chupe—. Echa nde reñemongueta rei ɨvɨ pegua reta oñemongueta rami, mbaeti Tumpa oñemongueta rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jare Jesús oeni jemimboe reta jare iru joco pe ñogüɨnoi vae reta. —Oime yave quia oipota ojo cherupíe vae —jei chupe reta—, tiñacañɨ iyeugüi, tovoɨ togüɨraja icurusu, jare tojo cherupíe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oipota oñovatu jecove vae ngaraa ipuere oñovatu. Erei jocuae omoeterengata jecove chereco pegua jare Tumpa iñee icavi vae jeco pegua vae oñovatuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Mbae pa omonganata quia, omongana yave opaete ɨvɨ pegua, erei mbaeti yave ipuere oñovatu jecove? ");
INSERT INTO guiNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mbovɨ pa omboepɨta quia ogua ye vaera jecove? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨvɨ pegua añave yogüɨreco vae reta oñuvanga menda re jare oyapo teco icavi mbae vae. Oime yave quia imara cheré jare cheñee re cuae reta ipɨte pe vae, che cuimbaera ayeapo vae chemarata vi jese, ayu ye yave cheRu jesape reve araɨgua jupi vae reta ndive —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús jei ye chupe reta: —Añete che jae peve, ndei amogüe cuae pe ñogüɨnoi vae omano mbove, oecha retata Tumpa iporoocuaia mbaepuere pegua. ");
INSERT INTO guiNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis ara cuae jei güire, Jesús güɨraja Pedro, Jacobo, jare Juan iru reta ipɨte güi metei ɨvɨtɨ ɨvate vae re, jare joco pe oyepoepɨ jae reta jóvai. ");
INSERT INTO guiNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jemimonde omboɨpɨ oesape jare tiasɨ yae. Mbaeti metei ave ombaeputuca vae ipuere omotiasɨ jocorai. ");
INSERT INTO guiNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jare oyecuaa chupe reta Elías jare Moisés imiari ñogüɨnoi Jesús ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jayave Pedro jei Jesús pe: —Oporomboe vae, icavi co ñai vaera cuae pe. Toroyapo mboapɨ cuaraɨa yai pegua, metei ndeveguara, metei Moisés peguara, jare metei Elías peguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Echa Jesús jemimboe reta oquɨye yae, jare Pedro mbaeti oicuaa mbae jei vae. ");
INSERT INTO guiNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jayave ou amapɨtu omocuaraɨa reta, jare amapɨtu güi oñeendu ñee jei: —Cuae co jae cheRai. Aaɨu yae. Peyeapɨsaca jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jare güɨramoiño omae reta yave, mbaeti ma oecha quia jae reta ndive, jaeño Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jare ɨvɨtɨ güi ogüeyɨ yogüeru rambueve, Jesús oyócuai reta: —Agüɨye pemombeu quia pe cuae peecha vae, ndei che cuimbaera ayeapo vae aicove ye ayu omanogüe vae reta ipɨte güi mbove. ");
INSERT INTO guiNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jae rambue mbaeti omombeu quia pe, erei oparandu reta oyoupe: —¿Mbae pa oipota jei cuae omombeu ñandeve vae? ¿Quiraita pa oicove ye ou omanogüe vae reta ipɨte güi? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jayave jae reta oparandu Jesús pe: —¿Maera pa jei mboroócuai re oporomboe vae reta Elías rani co outa? ");
INSERT INTO guiNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Añete Elías rani co outa —jei Jesús chupe reta—, jare opaete oyapocavita. Jare ¿mbae ra oyecuatía oi Tumpa iñee pe che cuimbaera ayeapo vae re? Oyecuatía oi che jetata aiporara jare iru vae reta chereroɨrota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Erei che jae peve, Elías ou ma co, jare amogüe vae oyapo chupe jae reta oipota vae, Tumpa iñee pe oyecuatía oi rami —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jare yogüeru ovae yave iru jemimboe reta ñogüɨnoia pe, oecha jeta yae vae yatɨ ñogüɨnoi iyɨpɨ rupi, jare mboroócuai re oporomboe vae reta oyoaca ñogüɨnoi jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jayave opaete joco pe ñogüɨnoi vae reta oecha Jesús, jare ipɨacañɨ yae reta. Jayave osɨi reta icotɨ, jare oyapo chupe maraetei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jayave Jesús oparandu chupe reta: —¿Mbae re pa peyoaca pei jae reta ndive? ");
INSERT INTO guiNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jayave metei cuimbae yatɨ vae reta ipɨte pe oi vae jei chupe: —Oporomboe vae, aru ndeve cheraɨ. Aña oya jese jare omboupa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jare que rupi oia pe aña oya jese yave, joco pe omborɨrɨi yae, jare cunumi iyuru tɨrɨyui, jai omboquɨrɨrɨu, jare tanta jete —jei—. Ayerure tei ma neremimboe reta pe omondo vaera aña chugüi, erei mbaeti ipuere —jei cuimbae Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jayave Jesús jei chupe reta: —Pe reta cuae ɨvɨ pe peico vae mbaeti peporogüɨrovia. ¿Quirai regua ra apɨtata pe reta ndive? ¿Quirai regua ra cherosata peve? Peru cheve jocuae cunumi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jayave güeru cunumi chupe, jare aña oecha yave Jesús, jupiveiño omborɨrɨi tanta yae cunumi. Jare cunumi oa ɨvɨ re, jare oyeapayere, jare iyuru tɨrɨyui. ");
INSERT INTO guiNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jayave Jesús oparandu tu pe: —¿Yerae ma pa oyeapo chupe cuae? —Michi güive oyeapo chupe —jei tu—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jare jeta vese ma oitɨ tata pe jare ɨ pe, oyuca vaera tei. Erei nde ndepuere yave mbae reyapo chupe, oreparareco jare oremborɨ —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jayave Jesús jei chupe: —¿Ndepuere pa reporogüɨrovia? Oporogüɨrovia vae ipuere oyapo opaete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jayave cunumi tu iñeeata reve jei: —Rogüɨrovia. Mbaeti aporogüɨrovia yave, chemborɨ aporogüɨrovia vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jare Jesús oecha yave jeta vae oñemboatɨ joco pe, oñeengata aña pe. —Aña oporomboupa jare oporomboapɨsa mbae vae —jei chupe—, che roócuai reo vaera cuae cunumi güi, jare agüɨye eya ye jese —jei aña pe. ");
INSERT INTO guiNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jare aña osapúcai ma yave, omborɨrɨi tanta yae cunumi, jare ojo chugüi. Jare cunumi omano echa opɨta. Jare jeta joco pe ñogüɨnoi vae reta jei: —Omano ma. ");
INSERT INTO guiNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Erei Jesús oipɨɨ cunumi ipo pe, jare omopúa. Jare cunumi oñemboɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jare Jesús oique yave metei o pe, jemimboe reta oparandu chupe, jae retaño jae ndive ñogüɨnoi yave: —¿Maera pa ore mbaeti orepuere romondo aña? ");
INSERT INTO guiNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ngaraa pepuere pemondo cuae nunga aña —jei Jesús chupe reta—, jaeño peyerure yave Tumpa pe peyecuacu reve tembíu güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús jare jemimboe reta yogüɨraja yave joco güi, oasa Galilea rupi. Jare Jesús mbaeti oipota quia oicuaa vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Echa omboe güɨnoi jemimboe reta. —Che cuimbaera ayeapo vae metei vae chemoeterengata iru vae reta pe —jei—. Jae reta cheyucata —jei chupe reta—. Erei amano ma yave, mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Erei jae reta mbaeti oicuaa mbae re ra Jesús jei chupe reta, jare oipoɨu reta oparandu vaera chupe jese. ");
INSERT INTO guiNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jayave yogüɨraja ovae Capernaum pe. Jare jo pe oi yave, Jesús oparandu jemimboe reta pe: —¿Mbae re pa pemiari peyu oyoupe tape rupi? ");
INSERT INTO guiNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Erei jae reta quiriiño. Echa tape rupi jae reta imiari yogüeru oyoupe quia ra tenondegua iru reta güi vae. ");
INSERT INTO guiNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jayave Jesús oguapɨ, jare oeni jocuae doce jemimboe reta. —Oime yave quia oipota tenondeguara oico vae —jei chupe reta—, toñemomichi opaete vae güi, jare toyeócuai opaete iru reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jayave oeni metei michia, jare oñono jae reta ipɨte pe. Jayave ovoɨ michia, jare jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Oime yave quia omboresive cuae nunga michia chereco pegua vae, che co chemboresive. Jare jocuae chemboresive vae omboresive co chembou vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jayave Juan jei Jesús pe: —Oporomboe vae, roecha metei cuimbae nderee re omondo aña reta oya jese vae reta güi, jare roe chupe agüɨye vaera mo oyapo. Echa jae mbaeti co ñaneiru —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Agüɨye pere chupe jocorai —jei Jesús chupe—. Echa cheree re mɨacañɨ oyapo vae ngaraa jupiveiño jei icavi mbae vae checotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Echa mbaeti oyovaicho ñande ndive vae ñanemborɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Güɨramoi quia omeeta peve metei vaso ɨ chereco pegua. Jocorai oyapo yave cheré perovia rambue, añete che jae peve, amboecoviata co chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Oime michia cheré güɨrovia vae reta. Oime yave quia metei cuae nunga pe mbaeyoa oyapouca vae, icavita tei co iru vae reta oñapɨti vaera iyayu rupi metei ita tuicha vae ombaeso pɨpe vae, jare omombo vaera ɨ guasu pe —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ndeporovaicho oyapouca yave mbaeyoa ndeve, eyasɨa ndeyeugüi. Icavi co tecove opa mbae vae renoi vaera ndeporovaicho mbae reve, tata guasu opa mbae vae pe mócoi ndepo reve reo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Echa tata guasu pe taso ngaraa omano, jare tata ngaraa ogüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jae ramiño vi ndepɨrovaicho oyapouca yave mbaeyoa ndeve, eyasɨa vi ndeyeugüi. Icavi co tecove opa mbae vae renoi vaera ndepɨrovaicho mbae reve, tata guasu opa mbae vae pe mócoi ndepɨ reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tata guasu pe taso ngaraa omano, jare tata ngaraa ogüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jae ramiño vi nderesarovaicho oyapouca yave mbaeyoa ndeve, eequi ndeyeugüi. Icavi co reico vaera Tumpa iporoocuaia pe nderesarovaicho mbae reve, tata guasu pe mócoi nderesa reve Tumpa nemondo vaera tei güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tata guasu pe taso ngaraa omano, jare tata ngaraa ogüe —jei ye chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Echa tata oñeñonoucata opaete re, yuquɨ oñeñonouca tembíu re rami. Yuquɨ oñeñonoucata vi opaete mbota Tumpa pe oyeyuca vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yuquɨ icavi co yau vaera. Erei mbaeti ma yave jembochɨ, ¿quiraita ra jembochɨ ye? —jei—. Peyapo yuquɨ oyapo rami, jare peico cavi oyoupive —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jayave Jesús ojo joco güi Judea pe Jordán jovaicho pe. Joco pe jeta vae oñemboatɨ ye jae oia pe. Jayave Jesús omboe reta, jecuaeño oyapo rami. ");
INSERT INTO guiNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jayave fariseo reta yogüeru Jesús oia pe. Jae reta oipota tei oyavɨuca chupe. Jae rambue oparandu reta chupe: —¿Jupi pa cuimbae omombo vaera jembireco? ");
INSERT INTO guiNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Mbae pa peócuai Moisés? —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisés omaeño cuimbae re oicuatía vaera tupapire jembireco omombo vae regua —jei reta chupe—, jembireco omombo vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Moisés oicuatía cuae mboroócuai pepɨatanta rambue —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Erei Tumpa oyapoɨpɨ yave, oyapo cuimbae jare cuña —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jae rambue cuimbae oeyata tu jare ichɨ, jare ojota oico vaera jembireco ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jare mócoi vae oyeapota metei ramiño. Jae rambue mbaeti ma mócoi rami. Yogüɨreco metei ramiño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jae rambue agüɨye quia tomboyao Tumpa omoiru vae reta —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jare o pe ñogüɨnoi yave, jemimboe reta oparandu ye Jesús pe cuae re. ");
INSERT INTO guiNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jayave Jesús jei chupe reta: —Cuimbae omombo jembireco jare omenda iru ndive vae oñuvanga menda re jembireco omombo vae cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jare cuña oeya ime jare omenda iru cuimbae ndive vae vi oñuvanga menda re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jare amogüe vae güeru Jesús oia pe michia reta, Jesús oñono vaera ipo jese reta. Erei jemimboe reta oñeengata güeru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús cuae oecha yave, pochɨ jemimboe reta pe, jare jei chupe reta: —Pemaeño michia reta re yogüeru vaera checotɨ. Agüiye peyopia —jei—. Echa cuae nunga oyeócuai Tumpa pe iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Añete che jae peve, mbaeti yave peipota Tumpa peócuai vaera metei michia oipota rami, ngaraa peico Tumpa iporoocuaia pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jayave Jesús ovoɨ michia reta, jare oñono ipo jese reta, jare oyerure Tumpa pe jese reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jare Jesús joco güi ojo yave, metei cuimbae osɨi ou icotɨ. Oyeatɨca Jesús jóvai. —Oporomboe vae, nde ndepɨacavi co —jei Jesús pe—. ¿Mbae pa ayapota anoi vaera tecove opa mbae vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Maera pa rere cheve: Ndepɨacavi co? —jei Jesús chupe—. Mbaeti quia ipɨacavi, jaeño Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nde reicuaa co mboroócuai reta: “Agüɨye eñuvanga menda re. Agüɨye eporoyuca. Agüɨye nemonda. Agüɨye ndeapu iru vae re. Agüɨye eporombotavɨ. Eaɨu nderu jare ndesɨ” —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Oporomboe vae —jei cuimbae—, mbaeti ayavɨ metei ave cuae mboroócuai reta chemichi güive —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús omae jese oaɨu reve. —Oime mbae oata reyapo vaera —jei chupe—. Ecua emee opaete mbaembae renoi vae corepoti re, jare emee corepoti paravete vae reta pe, jare reicocatuta ara pe. Jayave evoɨ eraja ndecurusu, jare eyu cherupíe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Erei cuae oendu yave, cuimbae ojo ipɨatɨtɨ reve. Echa jeta mbaembae güɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jayave Jesús omae iyɨpɨ rupi, jare jei jemimboe reta pe: —Yavai yaeta co oicocatu vae reta oique vaera Tumpa iporoocuaia pe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jemimboe reta ipɨacañɨ Jesús jei vae re. Erei Jesús jei ye: —Yavai yae co, cherɨvɨ reta, oicocatu vae reta oique vaera Tumpa iporoocuaia pe. Echa jei tei ipɨa pe: Icavi yaeta co cheve. Echa jeta mbaembae anoi —jei, jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yavai yae oicocatu vae oique vaera Tumpa iporoocuaia pe, maemɨmba camello jee vae yuu mi jesacua rupi oasa vaera güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jayave jae reta ipɨacañɨ yae, jare oparandu oyoupe: —Jocorai yave, ¿quia pa ipuere oñemboasauca? ");
INSERT INTO guiNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús omae jese reta jare jei: —Ɨvɨ pegua reta mbaeti ipuere oñemboasa. Erei Tumpa ipuere omboasa reta. Echa Tumpa ipuere oyapo opaete —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jayave Pedro jei Jesús pe: —Mase, ore opaete mbae roeya, royu vaera nderupíe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Añete che jae peve —jei Jesús—, oime yave quia oeya jo, ani tɨqueɨ reta, ani tɨvɨ reta, ani jeindɨ reta, ani tu, ani ichɨ, ani jembireco, ani imichia reta, ani iɨvɨ reta chereco pegua jare Tumpa iñee icavi vae jeco pegua vae, ");
INSERT INTO guiNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cien rupi jecoviata co chupe ɨvɨ pe oico rambueve. Jecoviata jo reta, tɨqueɨ reta, tɨvɨ reta, jeindɨ reta, ichɨ reta, imichia reta, jare iɨvɨ reta —jei—. Erei iru vae reta oyapota icavi mbae vae chupe. Erei taɨcue rupi Tumpa omeeta chupe tecove opa mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Erei Tumpa ombotaɨcueta oñemboete vae reta, jare omotenondeta oñemomichi vae reta —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús jare jae ndive ñogüɨnoi vae reta yogüɨraja tape Jerusalén cotɨ ojo vae rupi, jare Jesús tenonde ojo. Jare jaɨcue yogüɨraja vae reta ipɨacañɨ jare oquɨye. Jayave Jesús oeni ye jocuae doce jemimboe reta iru reta ipɨte güi, jare omboɨpɨ omombeu chupe reta mbae oyeapota chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Mase, yaja co Jerusalén cotɨ —jei chupe reta—. Jare che cuimbaera ayeapo vae metei vae chemoeterengata sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta pe. Jae reta jeita amano vaera, jare chemoeterengata judío mbae vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jae reta cheyoyaita, chenupata chicote pe, ondɨvɨta cheré, jare cheyucata. Erei mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cuae jaɨcue rupi Zebedeo taɨ reta Jacobo jare Juan jee vae yogüeru Jesús cotɨ jare jei chupe: —Oporomboe vae, roipota reyapo vaera oreve royerureta ndeve jese vae. ");
INSERT INTO guiNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Mbae pa peipota ayapo vaera peve? —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Emaeño oreré roguapɨ vaera ndeɨque pe, metei ndeacatu cotɨ jare iru ndeasu cotɨ, reñemboeteuca yave —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Mbaeti peicuaa mbae peyerure jese vae —jei Jesús—. ¿Pepuereta pa peiporara che aiporarata rami? ¿Pepuereta pa peñembobautizauca che añembobautizaucata rami? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Orepuereta co —jei reta. —Añete pe reta peiporarata che aiporarata rami, jare pe reta peñembobautizaucata che añembobautizaucata rami —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Erei mbaeti chepuere jae peve peguapɨ vaera cheɨque pe, metei cheacatu cotɨ jare iru cheasu cotɨ. Echa Tumpa omocatɨro ma joco pe oguapɨta vae reta peguara —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jare iru diez Jesús jemimboe reta cuae oendu, jare pochɨ reta Jacobo jare Juan pe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jayave Jesús oeni reta. —Peicuaa cavi co cuae —jei chupe reta—. Mburuvicha ɨvɨ pegua reta oporoócuai, jare mbaepuere güɨnoi vae reta jei iru reta pe mbae oyapo vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Erei pe reta agüɨye peyapo jocorai —jei—. Oime yave metei pepɨte pe oi vae oipota mbaepuere güɨnoi vae, toyeócuai iru reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jare oime yave metei pepɨte pe oi vae oipota tenondeguara oico vae, toyeócuai iru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Echa che cuimbaera ayeapo vae ayu ayeócuai vaera iru vae reta pe. Mbaeti ayu iru vae reta oyeócuai cheve vaera. Ayu amano vaera, jeta vae aepɨ vaera —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jayave yogüɨraja ovae tenta Jericó pe. Jare Jesús ojo ye Jericó güi jemimboe reta jare jeta vae ndive. Jare Timeo taɨ Bartimeo jee vae - jae co jesa mbae vae - oguapɨ oyerure oi tape jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jare oicuaa yave Jesús Nazaret pegua oasa co ojo, iñeeata reve jei: —Cheparareco, Jesús. Nde co jae David Taɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jeta joco pe ñogüɨnoi vae reta oñeengata chupe. Oipota tei omoquirii. Erei jae iñeeata yae reve jei: —David Taɨ, cheparareco. ");
INSERT INTO guiNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jayave Jesús opɨta. —Peeni —jei. Jayave oeni reta jesa mbae vae. —Eñemoatangatu —jei reta chupe—. Epúa. Nereni ma —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jayave jesa mbae vae omombo iyasoya, jare opúa voi ojo Jesús cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús oparandu chupe: —¿Mbae pa reipota ayapo vaera ndeve? —Tamae ye, oporomboe vae —jei jesa mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jayave Jesús jei chupe: —Ndepuere reo. Recuera ma, rerovia cheré rambue —jei. Jupiveiño ipuere omae, jare ojo Jesús jaɨcue tape rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jare coiño ma Jerusalén güi ñogüɨnoi yave, yogüɨraja ovae tenta reta Betfagé jare Betania iyɨpɨ pe. Jayave ɨvɨtɨ Oliva jóvai ñogüɨnoi yave, Jesús oyócuai mócoi jemimboe reta: ");
INSERT INTO guiNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Pecua pea tenta ñanderóvai oi vae pe —jei chupe reta—. Peo pevae rupive, pevaeta metei mburica mi taɨrusu vae oñeapɨti oi. Mbaeti etei vɨteri quia opo jese. Peyora jare peru —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jare oime yave quia jei peve vae: ¿Maera pa cuae peyapo? pere chupe: ÑandeYa oipota oiporu, erei ɨmambae güeruruca yeta cuae pe —pere, jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jayave Jesús jemimboe reta yogüɨraja, jare ovae mburica mi taɨrusu vae. Oñeapɨti oi tape pe metei onque jóvai. Jayave jae reta oyora. ");
INSERT INTO guiNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jare amogüe joco pe ñogüɨnoi vae jei Jesús jemimboe reta pe: —¿Maera pa peyora pei mburica mi? ");
INSERT INTO guiNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús jemimboe reta jei chupe reta Jesús oyócuai jei vaera vae. Jayave joco pe ñogüɨnoi vae reta omaeño güɨraja vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jayave güɨraja mburica mi taɨrusu vae Jesús oia pe. Jayave Jesús jemimboe reta oñono iyasoya mburica mi icupe re, jare Jesús opo jese. ");
INSERT INTO guiNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jare jeta vae oipɨso iyasoya tape rupi mburica mi jenonde, jare iru vae reta oyasɨa ñanaroquɨ jare oñono tape rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jare Jesús jenonde yogüɨraja vae reta jare jaɨcue yogüɨraja vae reta iñeeata reve jei: —¡Hosanna! Opaete tomboete ñandeYa ombou vae. ");
INSERT INTO guiNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oporoocuaita ñanetenondegua David jee vae oporoócuai rami. Toñemboeteuca. Tei reta Hosanna ara pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jare Jesús ojo ovae Jerusalén pe, jare oique Tumpa jo pe. Joco pe omae opaete mbaembae re. Jare caaru ma yave, ou ye Betania pe jocuae doce jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pɨareve pe yogüɨraja ye Betania güi, jare Jesús ñɨmbɨaɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jare mombɨrɨ güi oecha metei ɨva joo reve, jare ojo icotɨ oecha vaera oime ra ia. Erei oeca yave, mbaeti ovae ia, jaeño joo. Echa ndei ovae ɨva ia vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jayave Jesús jei ɨva pe: —Ngaraa etei ma quia jou ndeía. Jare jemimboe reta oendu. ");
INSERT INTO guiNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jare yogüɨraja ovae Jerusalén pe. Jayave Jesús oique Tumpa jo pe, jare omboɨpɨ omoe joco güi Tumpa jo pe omaemee vae reta jare ombaegua vae reta, jare omboyapara corepoti oipoepɨ vae reta imesa reta jare pɨcasu reta omee vae reta iguapɨa reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jare mbaeti omaeño quia re ivoɨta reve oguata vaera Tumpa jo rupi. ");
INSERT INTO guiNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jare jei joco pe ñogüɨnoi vae reta pe: —Tumpa iñee pe oyecuatía oi corai: “Chero oñembojeeta o opaete ɨvɨ pegua reta ipuere oyerure Tumpa pe pɨpe vae pe”. Jocorai oyecuatía oi. Erei pe reta peyapo ma imonda vae reta oñemia rami —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jayave sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta cuae oendu yave, oeca quirai ipuere oyucauca Jesús. Echa jae reta oquɨye chugüi, opaete vae ipɨacañɨ iporomboe re rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jare pɨtu ma yave, Jesús ou ye Jerusalén güi. ");
INSERT INTO guiNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pɨareve pe neimbove yave oasa yogüɨraja ye yave, oecha ɨva yɨpi ma iyɨpɨ güive. ");
INSERT INTO guiNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jayave Pedro imaendúa jese, jare jei Jesús pe: —¡Emae! oporomboe vae. Ɨva reyepopeyu jese vae yɨpi ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús jei jemimboe reta pe: —Perovia Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Añete che jae peve, yae yave cuae ɨvɨtɨ pe: Ecua eñemombo ɨ guasu pe, yarovia yave yaegüe oyeapota, oyeapota co ñandeve. Mbaeti yave yae ñandepɨa pe: Ngaraa ndipo oyeapo, oyeapota co ñandeve —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jae rambue che jae peve, oime yave mbae peipota vae, peyerure Tumpa pe jese. Jare perovia yave Tumpa omeeta co peve, penoita co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jare peyerure pei Tumpa pe yave, peɨro iru icavi mbae vae oyapo pecotɨ vae pe, peRu ara pe oi vae iñɨro vaera vi peve pembaeyoa reta re. ");
INSERT INTO guiNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Erei mbaeti yave peɨro iru icavi mbae vae oyapo pecotɨ vae pe, peRu ara pe oi vae ngaraa vi iñɨro peve pembaeyoa reta re —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jare yogüɨraja ovae ye Jerusalén pe. Jare Jesús oguata rambueve Tumpa jo rupi, yogüeru jae oia pe sacerdote reta itenondegua reta, mboroócuai re oporomboe vae reta, jare tenta pegua reta itenondegua reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jae reta oparandu chupe: —¿Mbae nunga mbaepuere pa renoi cuae mbaembae reyapo vaera? ¿Quia pa omee ndeve mbaepuere cuae reyapo vaera? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jayave Jesús jei chupe reta: —Che vi taparandu peve mbae re. Pemombeu yave cheve, che amombeuta vi peve mbae nunga mbaepuere anoi cuae mbaembae ayapo vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Quia pa ombou Juan oporombobautiza vaera? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? Pemombeu cheve —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jayave jae reta jei oyoupe: —Yae yave: Tumpa co ombou, jae jeita ñandeve: Jocorai yave, ¿maera pa mbaeti perovia? ");
INSERT INTO guiNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ani ¿yaeta pa: Ɨvɨ pegua reta co ombou? —jei reta. Erei jae reta oquɨye tenta pegua reta güi. Echa opaete vae güɨrovia Juan co jae añetete metei Tumpa iñee omombeu vae. ");
INSERT INTO guiNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jae rambue jei reta Jesús pe: —Mbaeti roicuaa. —Che vi ngaraa amombeu peve mbae nunga mbaepuere anoi cuae mbaembae ayapo vaera —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jayave Jesús omboɨpɨ imiari chupe reta omojaanga reve. —Oico metei cuimbae icora oiquese vae, jare oñotɨ pɨpe jeta uva —jei—. Jayave oyoo ɨvɨ, jare oyapo iva oitɨami pɨpe vaera. Oyapo vi metei chapapa, omae vaera ɨvate güi opaete co re. Jayave oiporuca ico iru vae reta pe, jae reta oñangareco vaera jese. Jayave co iya ojo mombɨrɨ ambué ɨvɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jare uva yagüɨye ma yave, co iya ombou metei jembiócuai co iporúa reta pe, jae reta omboyao vaera tei uva reta, iya güɨnoi vaera imbaera. ");
INSERT INTO guiNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Erei jae reta oipɨɨ oinupa co iya jembiócuai, jare omondo ye. Mbaeti mbae omee chupe güɨraja vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jayave co iya ombou ye tei iru jembiócuai. Erei co iporúa reta oyapi ita pe ombopere iñaca rupi, jare oyapo reta icavi mbae vae chupe. Jayave omondo ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jayave co iya ombou ye tei iru jembiócuai. Erei co iporúa reta oyuca cuae. Jare jocoraiñoi oyapo reta jeta iru co iya jembiócuai reta pe. Jae reta oinupa amogüe vae, jare oyuca iru vae reta —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Co iya güɨnoi ma jaeño metei taɨ. Oaɨu yae. Taɨcue ete ombou cuae taɨ co iporúa reta pe. Co iya jei tei: Güɨramoi jae reta omboeteta cheraɨ —jei, jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Erei co iporúa reta jei oyoupe: Cuae co jae iyara vae. Yaja yayuca, jare ñande yaicota co iya retara —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jayave jae reta oipɨɨ co iya taɨ oyuca omombo co güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Mbae ra oyapota co iya? —jei—. Outa, opa oyuca vaera jocuae co iporúa reta, jare oiporucata ico ambué vae reta pe —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Mbaeti pa pemongueta cuae Tumpa iñee pe oyecuatía oi vae? Ita o iyapoa reta omombo vae oyeapo ma ita tenondegua vae. ");
INSERT INTO guiNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ÑandeYa oyapo cuae. Yaecha ma, jare ñanepɨacañɨ jese. Jocorai oyecuatía oi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jayave jocuae oyeapɨsaca jese vae reta oipota tei oipɨɨ Jesús. Echa oicuaa catu cuae omojaanga reve jei vae oicuauca quirai jae reta teco güɨnoi. Erei oquɨye tenta pegua reta güi. Jae rambue oeyaño, jare yogüɨraja. ");
INSERT INTO guiNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jayave jae reta ombou amogüe fariseo reta jare herodiano reta, oyavɨuca vaera tei chupe jae imiari yave. ");
INSERT INTO guiNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jae reta yogüeru ovae yave, jei Jesús pe: —Oporomboe vae, roicuaa nde rere vae añete co. Nde mbaeti reipoɨu oipotagüe vae güi. Mbaeti remboete metei vae iru vae güi. Nde reporomboe cavi quirai Tumpa oipota yaico vaera vae re —jei reta—. César ñandeócuai ñamboepɨ vaera chupe corepoti. ¿Jupi pa ñamboepɨ vaera chupe? ani ¿mbaeti pa jupi? ¿Ñamboepɨta pa chupe? ani ¿mbaetita pa ñamboepɨ chupe? —jei reta Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Erei Jesús oicuaa jae reta oipota co ombotavɨ, jare jei chupe reta: —¿Maera pa peipota peyavɨuca cheve? Peru cheve metei denario taecha —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jae reta güeru chupe. Jayave jae oparandu chupe reta: —¿Quia iagüe pa cuae? ¿Quia jee pa cuae oyecuatía oi vae? —jei. —Cuae César imbae co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Pemee César pe César pegua —jei Jesús chupe reta—, jare pemee Tumpa pe Tumpa pegua —jei. Jare jae reta ipɨacañɨ yae jese. ");
INSERT INTO guiNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jayave yogüeru vi Jesús oia pe amogüe saduceo reta. Opaete saduceo reta jei omanogüe vae reta mbaeti co oicove ye. Saduceo yogüeru vae reta jei Jesús pe: ");
INSERT INTO guiNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Oporomboe vae, Moisés oicuatía oeya oreve corai: “Metei cuimbae tɨvɨ güɨnoi vae omano yave, jembirecogüe mbaeti imembɨ chupe yave, cuimbae tɨvɨgüe tomenda cuae cuña ndive. Jayave cuña imembɨ yave, cuimbae tombojee michia tɨqueɨ amɨri jee pe”. Jocorai oicuatía Moisés —jei reta chupe—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oico metei cuimbae seis tɨvɨ reta güɨnoi vae. Cuae cuimbae omenda, jare omano mbaeti omomembɨ reve —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Cuimbae amɨri jaɨcuerigua omenda jembirecogüe ndive, erei omano vi mbaeti omomembɨ reve. Jae ramiño vi oyeapo jaɨcuerigua ye pe. ");
INSERT INTO guiNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Opaete siete reve omenda cuae cuña ndive, jare opaete siete reve omano mbaeti omomembɨ reve. Taɨcue rupi cuña omano vi —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jayave omanogüe vae reta oicove ye yave, ¿quia nunga vae jembirecora pa oicota cuae cuña? Echa opaete siete reve omenda jae ndive —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Pe reta peyavɨ co —jei Jesús chupe reta—. Echa mbaeti peicuaa Tumpa iñee oyecuatía oi vae jare Tumpa imbaepuere —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Echa omanogüe vae reta oicove ye yave, cuimbae reta jare cuña reta ngaraa omenda. Yogüɨrecota araɨgua ara pe ñogüɨnoi vae reta yogüɨreco rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tamombeu peve omanogüe vae reta regua. Oicove yeta co. ¿Mbaeti pa pemongueta Moisés oicuatía vae? —jei—. Oyecuatía oi jocuae ɨvɨra regua, jare quirai Tumpa ɨvɨra güi jei Moisés pe: “Che co Abraham, Isaac, jare Jacob iTumpa” —jei, jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tumpa mbaeti co omanogüe vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa. Tuicha co peyavɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ou vi Jesús oia pe metei mboroócuai re oporomboe vae. Oendu oyoaca reta, jare oicuaa Jesús omombeu cavi co chupe reta. Jayave jae oparandu Jesús pe: —¿Mbae nunga mboroócuai pa co jae tenondegua vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús jei chupe: —Mboroócuai tenondegua vae co cuae: “Israel pegua, eyeapɨsaca. ÑandeYa Tumpa, jaeño co Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eaɨu ndeYa Tumpa opaete ndepɨa reve, opaete nderecove reve, opaete neñemongueta reve, jare opaete ndepoaca reve”. Cuae co jae mboroócuai tenondegua vae —jei chupe—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jare jaɨcuerigua co cuae: “Eaɨu iru vae nde reyeaɨu rami”. Mbaeti iru mboroócuai tenondegua cuae reta güi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jayave mboroócuai re oporomboe vae jei Jesús pe: —Añete co, oporomboe vae. Icavi yae rere Tumpa meteiño co jare mbaeti ye iru. ");
INSERT INTO guiNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jare yaaɨu yave Tumpa opaete ñandepɨa reve, opaete ñanderecove reve, opaete ñaneñemongueta reve, jare opaete ñandepoaca reve, jare yaaɨu yave iru vae ñande yayeaɨu rami, jocuae icavi opaete mbota Tumpa peguara yaapɨ vae reta jare mbota Tumpa peguara yayuca vae reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jare Jesús oendu yave jae jei jupi cavi vae, jei chupe: —Mbaeti jeta oata reyeócuai vaera Tumpa pe iporoocuaia pe. Jare mbaeti ma quia oipota oparandu chupe mbae re. ");
INSERT INTO guiNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jare Jesús oporomboe oi Tumpa jo pe. —¿Maera pa jei mboroócuai re oporomboe vae reta Cristo co jae David Taɨ? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Echa David etei jei Espíritu Santo rupi corai: ÑandeYa jei cheYa pe: Eguapɨ cheɨque pe cheacatu cotɨ, nderovaicho reta opa añono ndepɨ igüɨ pe regua —jei. Jocorai jei David aracae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Quirai pa ipuere oico David Taɨra? Echa David etei jei chupe: CheYa —jei Jesús chupe reta. Jare jeta yae vae oyeapɨsaca ñogüɨnoi Jesús re oyerovia reve. ");
INSERT INTO guiNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jare Jesús oporomboe yave, jei chupe reta: —Peñeandu mboroócuai re oporomboe vae reta güi —jei—. Jae reta jecuaeño oipota oguata jemimonde ipucu vae reve, jare oipota yae iru vae reta oyapo vaera maraetei chupe reta omaemee vae reta ñogüɨnoia rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yogüɨraja yave itupao pe jare aretea pe, jecuaeño oipota oguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jare opɨro reta cuña imemano vae reta güi opaete imbaembae, jare ipucu yae oyerure Tumpa pe oporombotavɨ vaera —jei—. Jae reta oiporara yaeta —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Metei ara Jesús oguapɨ oi corepoti jɨru Tumpa jo pe oi vae jóvai, jare oecha quirai jeta yogüeru vae reta oitɨ corepoti pɨpe. Jeta oicocatu vae reta oitɨ jeta corepoti. ");
INSERT INTO guiNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jare ou vi metei cuña imemano paravete vae. Jae oitɨ mócoi reare. Jocuae michi yae co. ");
INSERT INTO guiNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jare Jesús oeni jemimboe reta. —Añete che jae peve —jei chupe reta—, cuae cuña imemano paravete vae oyapo jeta yae opaete iru oitɨ vae reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Echa opaete iru reta güeru oitɨ jeta güɨnoi vae güi. Erei cuae cuña, yepe tei paravete yae, oitɨ opaete güɨnoi vae. Jocuae co jembíu jepɨra tei vae —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús oe yave Tumpa jo güi, metei jemimboe jei chupe: —Mase, oporomboe vae, icavi yae co cuae ita reta jare o reta. ");
INSERT INTO guiNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—¿Remae pa rei cuae o tuicha vae reta re? —jei Jesús chupe—. Ngaraa opɨta metei ave ita iru ita iárambue. Opaete oyeitɨta co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jare Jesús oguapɨ oi rambueve ɨvɨtɨ Oliva re Tumpa jo jóvai, Pedro, Jacobo, Juan, jare Andrés oparandu chupe, jae retaño jae ndive ñogüɨnoi yave: ");
INSERT INTO guiNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Emombeu oreve, ¿quirai yave pa cuae oyeapota? Jare opaete cuae oyeapota ma yave, ¿quiraita pa roicuaa? —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jayave Jesús jei chupe reta: —Peñeandu agüɨye vaera petavɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Echa yogüeruta jeta cheree pe oñembojeeta vae. Jae reta jeita: Che co jae Cristo. Jare ombotavɨta jeta vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oimeta ñoraro reta coiño pegüi. Oimeta vi ñoraro reta mombɨrɨ pegüi. Peendu yave cuae reta regua, agüɨye peñemambeco. Cuae susere reta oyeapota co. Erei cuae susere reta mbaetita co taɨcuegua vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Metei ɨvɨ pegua reta oñorarota ambué ɨvɨ pegua reta ndive, jare mburuvicha reta oñorarota iru mburuvicha reta ndive. Jare ɨvɨ ocanata jeta que rupi. Jare oimeta caruai reta jare tecorai reta. Erei cuae susere reta tenondeguaño co vɨteri —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Peñeandu. Echa iru vae reta pererajata mburuvicha reta yatɨa pe, oñeapo vaera peré. Jare penupata judío reta itupao reta pe. Jare pererajata mburuvicha guasu reta jóvai chereco pegua, chemombeu vaera chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jare Tumpa iñee icavi vae jeracuata rani opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jare iru vae reta pereraja yave pemoeterenga vaera mburuvicha reta pe, agüɨye peñemambeco pereta vae re, jare agüɨye peñemongueta pepɨa pe jese —jei—. Pemoeterenga yave, Tumpa oicuaucata peve mbae pere vaera. Jocuaeño pere. Echa Espíritu Santo imiarita, mbaeti pe retaiño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tɨqueɨ omoeterengata tɨvɨ, oyucauca vaera. Jare tu omoeterengata imichia. Jare michia oyovaichota tu jare ichɨ ndive, jare oyucaucata. ");
INSERT INTO guiNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jare peñemotareɨucata opaete vae pe chereco pegua. Erei josata ojo ovae iyapɨ pe vae oñemboasaucata co —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jare peechata icavi mbae vae opaete güɨrocomegua vae oñemboɨ oi mbaetita tei oia pe. Tumpa iñee aracae omombeu vae Daniel jei oyecuaata co. (Omongueta vae toicuaa) —jei—. Jayave Judea pe ñogüɨnoi vae reta totecuarai ɨvɨtɨ reta ñogüɨnoia cotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jare ovapɨa iárambue oi vae ogüeyɨ yave, agüɨye toique jo pe, güɨraja vaera imbaembae. ");
INSERT INTO guiNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jare ico pe oi vae agüɨye tou ye jo pe, güɨraja vaera iyasoya —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jare ipurúa vae reta jare omocambu vae reta oiporara yaeta jocuae ara reta pe —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Peyerure Tumpa pe corai: Agüɨye emaeño toyeapo ama oquɨ yave. ");
INSERT INTO guiNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Echa jocuae ara reta pe ɨvɨ pegua reta oiporara yaeta. Mbaeti jocorai oiporara reta Tumpa ɨvɨ oyapo güive, jare ngaraa ye jocorai oiporara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jare ñandeYa mbaeti yave oipota opa vaera jocuae ara reta, mbaetita tei quia ipuere oico. Erei Tumpa oiparavogüe vae reta jeco pegua opata jocuae ara reta —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Güɨramoi jocuae ara reta pe quia jeita peve: Mase, co oi Cristo, ani jeita: Mase, pee oi Cristo. Jocorai jei yave, agüɨye perovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Amogüe oporombotavɨ vae reta jeita: Che co jae Cristo, jare iru oporombotavɨ vae reta jeita: Che co jae metei Tumpa iñee omombeu vae. Jare jae reta oyapota mɨacañɨ reta, ombotavɨ vaera tei Tumpa oiparavogüe vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Peñeandu. Amombeu ma peve opaete, ndei oyeapo mbove —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jayave opa oiporara reta jocuae ara reta pe güire, cuaraɨ oñemopɨtumimbita, jare yasɨ ngaraa oesape. ");
INSERT INTO guiNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yasɨtata reta oata ara güi, jare opaete ara re mbaepuere güɨnoi vae reta ocanata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jayave ɨvɨ pegua reta cherechata ayu amapɨtu reta reve. Che cuimbaera ayeapo vae anoita mbaepuere tuicha vae, jare añemboeteucata opaete vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jayave amondota araɨgua reta güeru vaera aiparavogüe vae reta opaete ɨvɨ rupi güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ñandepuere ñamojaanga ɨva. Peñemboe jese —jei—. Joquɨ yave, peicuaa oyearo co ama oquɨ vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jae ramiño vi pe reta peecha yave cuae mbaembae oyeapo ñogüɨnoi, peicuaata che coiño yae ma co ai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Añete che jae peve, cuae tenta pegua reta ngaraa omano ndei opaete cuae mbaembae oyeapo mbove —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ara jare ɨvɨ opata, erei cheñee ngaraa opa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Erei mbaeti quia oicuaa mbae ara pe ani mbae ora pe yepe cuae oyeapota, jaeño cheRu. Araɨgua ara pe ñogüɨnoi vae reta mbaeti oicuaa. Che co jae Tumpa Taɨ. Erei che vi mbaeti aicuaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jecuaeño peñeandu, jare peyerure Tumpa pe. Echa mbaeti peicuaa quirai yave ra oyeapota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ñamojaanga metei cuimbae ojo ambué ɨvɨ pe vae. Ojota ma jo güi yave, omee mbaepuere jembiócuai reta pe, jare oyócuai metei ñavo oyapo vaera iparavɨquɨ, jare oyócuai vi taraquera jaroa oaro cavi vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mbaeti peicuaa quirai yave ra o iya ou yeta ovae. Güɨramoi outa ovae javeta ma yave, ani pɨare catu, ani tacareo oñee yave, ani neimbove yave —jei—. Jae rambue peñeandu, ");
INSERT INTO guiNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","agüɨye vaera, güɨramoiño ou ovae yave, pepocou peque pei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jare cuae jae peve vae jae vi opaete vae pe: Peñeandu —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mócoi ara oata arete pascua jee vae iara ovae vaera. Jocuae arete pe judío reta jou mbɨyape ovu mbae vae. Jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oeca ñogüɨnoi quirai ipuere oipɨɨ vɨari Jesús, oyucauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Erei jei reta: —Agüɨye yaipɨɨ arete iara pe, agüɨye vaera tenta pegua reta oyapo tecorai. ");
INSERT INTO guiNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jare Jesús ocaru oi rambueve Betania pe Simón ipire ocuise vae jo pe, oique metei cuña. Cuña güeru ɨru-raɨ ita alabastro jee vae pegua. Cuae ɨru-raɨ tɨnɨe mbae ipiche cavi vae nardo jee vae pe. Cuae nardo jepɨ yae. Cuña oyoca ɨru-raɨ, jare opɨyere nardo Jesús iñaca re. ");
INSERT INTO guiNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jayave amogüe joco pe ñogüɨnoi vae pochɨ jare jei oyoupe: —¿Maera pa omombúcai? ");
INSERT INTO guiNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Omee yave corepoti re, güɨnoita tei trescientos denario omee vaera paravete vae reta pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Erei Jesús jei chupe reta: —Pemaeño jese. ¿Maera pa pemambeco? Icavi vae co oyapo cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Echa yogüɨrecoñotai co paravete vae reta pe reta ndive, jare peipota yave, pepuereta pemborɨ. Erei che ngaraa jecuaeño ai pe reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cuae cuña oyapo ipuere vae. Chembopiche cavi ma, ndei añeotɨuca mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Añete che jae peve, opaete ɨvɨ rupi Tumpa iñee icavi vae jeracuaa rupi, cuae oyapo vae vi jeracuata, iru vae reta imaendúa vaera jese —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jayave jocuae doce jemimboe reta güi metei Judas Iscariote jee vae ojo sacerdote reta itenondegua reta ñogüɨnoia pe, omoeterenga vaera Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuae oicuaa reta yave, oyerovia yae, jare jei Judas pe omeeta co chupe corepoti. Jayave Judas omboɨpɨ oeca quirai ipuere omoeterenga Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua iara pe judío reta oyuca vecha reta. Jocuae ara omboɨpɨ jou mbɨyape ovu mbae vae. Jayave Jesús jemimboe reta jei chupe: —¿Quiape pa reipota royapocavi vaera, vecha isoo pascua pegua reu vaera? ");
INSERT INTO guiNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jayave Jesús oyócuai mócoi jemimboe reta: —Pecua tenta pe —jei chupe reta—. Peovaitita joco pe metei cuimbae ɨ güɨraja ɨru pe vae. Pecua jaɨcue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jare oique yave o pe, pere o iya pe: Oporomboe vae jei: ¿Quiape pa oime oi checuartora? Jauta vecha isoo pascua pegua joco pe cheremimboe reta ndive —jei, pere chupe, jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jayave o iya oechaucata peve metei cuarto tuicha vae jo ɨvate pe, opaete mbaembae yaiporuta vae reve. Joco pe peyapocavi ñandeve —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jare Jesús jemimboe reta yogüɨraja ovae yave tenta pe, ovae opaete Jesús jei chupe reta rami. Jare oyapocavi reta vecha isoo pascua pegua jou reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jare pɨtu ma yave, Jesús ojo jocuae doce jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jare mesa pe oguapɨ ocaru ñogüɨnoi rambueve, Jesús jei chupe reta: —Añete che jae peve, metei pepɨte pe oi vae chemoeterengata cherovaicho reta pe. Jae co metei ocaru oi che ndive vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jayave jae reta ipɨatɨtɨ jare oparandu Jesús pe meteitei rupi: —¿Che pa co jae? ");
INSERT INTO guiNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Pe reta co jae doce cheremimboe reta —jei Jesús chupe reta—. Metei pepɨte pe oi vae co jae. Mbɨyape omoaquɨ oi che ndive ñae pe vae co jae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Che cuimbaera ayeapo vae ajañotai amano vaera, Tumpa iñee pe oyecuatía oi cheregua rami. Erei jocuae cuimbae chemoeterengata vae oiporarata co. Icavi tei viña jocuae cuimbae mbaeti oico yave —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jare jae reta ocaru ñogüɨnoi rambueve, Jesús oipɨɨ mbɨyape, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape jare omee chupe reta. —Peu —jei chupe reta—. Cuae co jae cherete —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jayave Jesús oipɨɨ vi metei vaso, jare yasoropai omee ye güire Tumpa pe, omee jemimboe reta pe. Jare opareve jou vaso güi. ");
INSERT INTO guiNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús jei chupe reta: —Cuae co jae cherugüɨ. Cherugüɨ oyepɨyereta, Tumpa güɨrocuaveegüe oyeapo vaera, jare jeta vae oyeepɨ vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Añete che jae peve, ngaraa ma jau uva tɨgüe, Tumpa iporoocuaia pe uva tɨgüe ipɨau vae jau regua —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jare opa güire omboete reta Tumpa canta pe, oe reta yogüɨraja ɨvɨtɨ Oliva cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jayave Jesús jei chupe reta: —Opaete pe reta chereyata cuae pɨtu. Echa Tumpa iñee pe oyecuatía oi corai: “Ayucata vecha reta iñangarecoa, jare vecha reta opata oñemoai”. Jocorai oyecuatía oi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Erei aicove ye güire ayu omanogüe vae reta ipɨte güi, ajata perenonde Galilea pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jayave Pedro jei Jesús pe: —Yepe tei opaete iru reta tandereya, che ngaraa roeya. ");
INSERT INTO guiNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Añete che jae ndeve —jei Jesús chupe—, cuae pɨtu etei, ndei tacareo oñee pɨipɨi mbove, mboapɨ vese checuacuta —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Erei Pedro jeiete jei: —Yepe tei tamano nde ndive, erei ngaraa rocuacu. Jare jocorai vi jei opaete Jesús jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jayave yogüɨraja ovae ɨvɨra reta ñogüɨnoia Getsemaní jee vae pe. —Peguapɨ cuae pe, che ayerure Tumpa pe rambueve —jei Jesús jemimboe reta pe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jayave güɨraja Pedro, Jacobo, jare Juan, jare omboɨpɨ ipɨatɨtɨ jare oiporara yae. ");
INSERT INTO guiNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Chepɨatɨtɨ yae —jei jocuae mboapɨ jemimboe reta pe—, jare amano pota echa. Pepɨta cuae pe, jare agüɨye peque —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jayave Jesús ojo cutɨ mi chugüi reta, jare oyeatɨca ɨvɨ re. Oyerure Tumpa pe, Tumpa oipota yave, omboasa vaera chugüi jocuae oyeapota chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jei Tumpa pe: —CheRu, cheRu, opaete mbae ndepuere reyapo. Emboasa chegüi cuae aiporarata vae. Erei toyeapo cheve neremimbota. Agüɨye toyeapo cheremimbota —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jayave Jesús ou jemimboe reta ñogüɨnoia pe, jare oecha oque ñogüɨnoi. Jayave jei Pedro pe: —Simón, ¿reque pa? ¿Mbaeti pa ndepuere reque mbae rei metei ora yepe? —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jei vi jemimboe reta pe: —Agüɨye peque. Peyerure Tumpa pe, agüɨye vaera peyoa. Pepɨa pe peratangatu co, erei perete iyaquɨ co —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jayave Jesús ojo ye oyerure Tumpa pe. Oyerure ye tenonde oyerure rami. ");
INSERT INTO guiNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jayave ou ye jemimboe reta ñogüɨnoia pe, jare oecha oque ye ñogüɨnoi. Echa jae reta jopeɨ yae ete ma. Jare mbaeti oicuaa mbae jei vaera Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jayave Jesús ojo ye mboapɨa re, jare ou ye yave, jei chupe reta: —Jecuaeño peque jare peputuu. Jaeño ma. Ora ovae ma. Che cuimbaera ayeapo vae metei vae chemoeterengata cuimbae pochɨ vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pepúa. Yaja mo. Mase, chemoeterengata vae coiño ma ou —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jare imiari oi rambueve, ou Judas - jae co jocuae doce vae güi metei - jeta vae ndive. Jae reta güeru quɨsepucu reta jare ɨvɨra reta. Sacerdote reta itenondegua reta, mboroócuai re oporomboe vae reta, jare tenta pegua reta itenondegua reta ombou Jesús pe cuae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jare omoeterengata vae omombeu ma iru reta pe mbae oyapota vae. Jei ma chupe reta: —Jocuae aiyurupɨteta vae co jae. Peipɨɨ, jare peraja. Agüɨye totecuarai —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ou ovae yave, ou voi Jesús oia pe. —Oporomboe vae, oporomboe vae —jei chupe. Jayave oiyurupɨte. ");
INSERT INTO guiNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jayave yogüeru vae reta oipɨɨ Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jare metei cuimbae joco pe oi vae oequi iquɨsepucu jɨru güi, jare oiporu sacerdote tenondegua jembiócuai inambi re, jare inambi oyeequi. ");
INSERT INTO guiNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jayave Jesús jei yogüeru vae reta pe: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨɨ vaera, imonda vae peipɨɨ yave rami? ");
INSERT INTO guiNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ara ñavo ai pe reta ndive Tumpa jo pe. Joco pe aporomboe, jare mbaeti chepɨɨ. Erei peyapo cuae, Tumpa iñee oyecuatía oi vae oyeapo vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jayave opaete jemimboe reta oeya Jesús jare otecuarai. ");
INSERT INTO guiNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jare metei cunumi oñeoma metei tɨru pe vae ojo Jesús jaɨcue. Jare amogüe joco pe ñogüɨnoi vae oipɨɨ tei itɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Erei jae oeya itɨru, jare nandi otecuarai. ");
INSERT INTO guiNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jayave güɨraja reta Jesús sacerdote tenondegua jo pe. Jare joco pe oñemboatɨ opaete sacerdote reta itenondegua reta, tenta pegua reta itenondegua reta, jare mboroócuai re oporomboe vae reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jare Pedro ojo vi Jesús jaɨcue. Erei mombɨrɨ ojo chugüi. Jae oique sacerdote tenondegua joca pe, jare oguapɨ sacerdote tenondegua jembiócuai reta ndive oyepee tata pe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jare sacerdote reta itenondegua reta jare opaete iru mburuvicha reta oeca quia oñeapo vaera Jesús re, oyucauca vaera. Erei mbaeti ovae reta teco jese. ");
INSERT INTO guiNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yepe tei jeta vae yapu reve oñeapo jese, erei jeigüe reta mbaeti oyovaque. ");
INSERT INTO guiNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jare amogüe opúa yapu reve oñeapo jese vae jei: ");
INSERT INTO guiNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ore roendu jei: Ambosururuta Tumpa jo cuimbae reta oyapo vae, jare mboapɨ ara pe che ayapota iru Tumpa jo cuimbae reta mbaetita oyapo vae —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Erei yepe tei jocorai jei reta, erei jeigüe reta mbaeti oyovaque. ");
INSERT INTO guiNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jayave sacerdote tenondegua opúa oñemboɨ yatɨ vae reta ipɨte pe, jare oparandu Jesús pe: —¿Maera pa mbaeti neñee remoe? ¿Mbae re pa cuae reta oñeapo nderé? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Erei Jesús quiriiño. Mbaeti mbae jei. Jayave sacerdote tenondegua oparandu ye chupe: —¿Nde pa co jae Cristo? ¿Nde pa co jae Tumpa Taɨ? —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jae co che —jei Jesús chupe—. Jare che cuimbaera ayeapo vae cherechata co aguapɨ ai Tumpa mbaepuere güɨnoi vae iyɨque pe iyacatu cotɨ. Cherechata vi ayu amapɨtu reta reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jayave sacerdote tenondegua omondoro jemimonde ae jare jei: —¿Maera pa yaeca ye iru vae reta oñeapo vaera jese? ");
INSERT INTO guiNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Peendu ma icavi mbae vae Tumpa cotɨ jei vae —jei—. ¿Mbae pa peñemongueta jese? —jei. Jayave opaete vae jei: —Icavi mbae yae co. Icavi co yayucauca vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jare amogüe vae omboɨpɨ ondɨvɨ jese, jare oesaocua, jare ocua jese. Jare jei Jesús pe: —Emombeu oreve quia ra ocua oi nderé. Jare sacerdote tenondegua jembiócuai reta vi ocua jese. ");
INSERT INTO guiNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jare Pedro oca pe oi rambueve, ou metei cuñatai sacerdote tenondegua pe oyeócuai vae. ");
INSERT INTO guiNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jare oecha yave Pedro oyepee oi, omae jese. —Nde vi co jae Jesús Nazaret pegua iñeiru —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jayave Pedro oicuacu Jesús. —Mbaeti aicuaa jocuae cuimbae —jei Pedro chupe—, jare mbaeti aicuaa mbae rere vae —jei. Jayave Pedro ojo taraquera cotɨ. Jare tacareo oñee. ");
INSERT INTO guiNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jayave cuñatai oecha ye, jare imiari joco pe ñogüɨnoi vae reta pe: —Cuae cuimbae co jae metei Jesús iñeiru —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Erei Pedro oicuacu ye. Jare ndei ɨma mbove joco pe ñogüɨnoi vae reta jei ye Pedro pe: —Añete nde co jae metei Jesús iñeiru. Echa nde vi co jae metei Galilea pegua. Nde nemiari jae reta imiari rami —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jayave Pedro oyepopeyu iyee, jare jei Tumpa jee re: —Mbaeti aicuaa jocuae cuimbae pemiari jese vae. ");
INSERT INTO guiNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jayave tacareo oñee pɨipɨi. Jare Pedro imaendúa Jesús jei chupegüe re: Ndei tacareo oñee pɨipɨi mbove, mboapɨ vese checuacuta. Jare cuae re oñemongueta ipɨa pe yave, omboɨpɨ oyaeo. ");
INSERT INTO guiNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jayave coe rupive sacerdote reta itenondegua reta, tenta pegua reta itenondegua reta, mboroócuai re oporomboe vae reta, jare opaete iru mburuvicha reta oñemboatɨ imiari ñogüɨnoi oyoupe. Jayave oñapɨti Jesús jare güɨraja Pilato pe omoeterenga. ");
INSERT INTO guiNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jayave Pilato oparandu Jesús pe: —¿Nde pa co jae judío reta juvicha guasu? —Nde rere rami jae co che —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jayave sacerdote reta itenondegua reta oñeapo Jesús re jeta mbaembae re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jayave Pilato oparandu ye Jesús pe: —¿Maera pa mbaeti neñee remoe? Mase, jeta mbaembae re oñeapo reta nderé —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Erei Jesús mbaeti mbae jei chupe. Jae rambue Pilato ipɨacañɨ yae jese. ");
INSERT INTO guiNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jare jocuae arete ñavo Pilato oyorauca metei tembipɨɨ tenta pegua reta oipota vae. ");
INSERT INTO guiNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jare tembipɨɨrɨru pe ñogüɨnoi amogüe oporoyuca vae reta. Cuae reta oporoyuca mburuvicha reta ndive oñoraro yave. Metei jee co Barrabás. ");
INSERT INTO guiNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jare jeta vae yogüeru oyerure Pilato pe oyapo vaera chupe reta año ñavo oyapo rami. ");
INSERT INTO guiNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jayave Pilato jei chupe reta: —¿Peipota pa ayorauca vaera peve judío reta juvicha guasu? ");
INSERT INTO guiNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Echa jae oicuaa sacerdote reta itenondegua reta omoeterenga Jesús chupe oñemoagüɨro jese rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Erei sacerdote reta itenondegua reta omboemboe yatɨ vae reta: —Peyerure Pilato pe oyorauca vaera peve Barrabás. Agüɨye toyorauca Jesús —jei reta. Jayave jocorai oyerure reta Pilato pe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jayave Pilato oparandu ye chupe reta: —Jocorai yave, ¿mbae pa peipota ayapo vaera cuae cuimbae judío reta juvicha guasu pere chupe vae pe? ");
INSERT INTO guiNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jayave jae reta iñeeata reve jei: —Eicutuca curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Erei Pilato oparandu ye chupe reta: —¿Mbae nunga teco icavi mbae vae pa oyapo? Erei jae reta iñeeata yae reve jei: —Eicutuca curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jayave Pilato oyorauca chupe reta Barrabás, oipota omboyerovia reta rambue. Jare Pilato oinupauca güire Jesús chicote pe, omoeterenga sundaro reta pe, oicutu vaera curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jayave sundaro reta güɨraja Jesús juvicha joca pretorio jee vae pe, jare oeni opaete iru sundaro reta. ");
INSERT INTO guiNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jayave sundaro reta omondeuca Jesús pe temimonde pɨta vae, jare oñope yuu catuai vae jare omboapúa oñono Jesús iñaca re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jayave omboɨpɨ omboete-raanga. —¡Viva! Judío reta juvicha guasu —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jare oiporu reta iñaca re ɨvɨra. Jare ondɨvɨ reta jese, jare oyeatɨca reta jae jóvai omboete-raanga vaera. ");
INSERT INTO guiNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jare opa oyóyai güire, sundaro reta omboi chugüi temimonde pɨta vae, jare omondeuca ye chupe jemimonde ae. Jayave güɨraja reta mburuvicha joca güi, oicutu vaera curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jare metei cuimbae tenta Cirene pegua Simón jee vae ou tenta icatu güi oasa ojo. Jae co Alejandro jare Rufo tu. Jare sundaro reta güɨrajauca Simón pe Jesús icurusu. ");
INSERT INTO guiNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jare sundaro reta güɨraja Jesús Gólgota jee vae pe. (Cuae oipota jei: Acagüerenda.) ");
INSERT INTO guiNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jayave omee reta Jesús pe vino oyea mirra ndive vae. Erei Jesús mbaeti jou. ");
INSERT INTO guiNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jayave sundaro reta oicutu curusu re. Jayave oñuvanga reta Jesús jemimonde reta re, oicuaa vaera mbae nunga metei ñavo güɨrajata vae. ");
INSERT INTO guiNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jare cuaraɨ ɨvate catu mi yave, oicutu reta Jesús curusu re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jare oñono reta curusu re Jesús iñaca iárambue oyecuatía jesegua vae: Judío reta juvicha guasu. ");
INSERT INTO guiNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jare sundaro reta oicutu vi mócoi imonda vae reta, jare oñono metei Jesús iyacatu cotɨ jare iru iyasu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jare oyeapo ma Tumpa iñee oyecuatía oi vae: “Iru vae reta oñemongueta tei jae vi co metei icavi mbae vae”. ");
INSERT INTO guiNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jare oasa vae reta jei icavi mbae vae oñeacambovava reve Jesús pe. —¡Aa! —jei reta—. Nde rere rembosururuta co Tumpa jo jare reyapo yeta mboapɨ ara pe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eyeepɨ añave, jare egüeyɨ curusu güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jae ramiño vi sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta imiari oyoupe yave, oyóyai reta. —Jae oepɨ iru vae reta —jei reta—. Erei mbaeti ipuere oyeepɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jae co Cristo. Jae co Israel pegua reta juvicha guasu. Togüeyɨ añave curusu güi, yaecha vaera, jare yarovia vaera —jei reta. Jare Jesús ndive oyecutu vae reta vi jei icavi mbae vae chupe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jare cuaraɨ ara mbɨte güive mboapɨ ora rupi oñemopɨtumimbi opaete ɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jayave mboapɨ ora rupi cuaraɨ ara mbɨte güire, Jesús iñeeata yae reve jei: —Eloi, Eloi, ¿lama sabactani? (Cuae oipota jei: CheTumpa, cheTumpa, ¿maera pa chereya?) ");
INSERT INTO guiNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Amogüe joco pe ñogüɨnoi vae oendu jare jei tei: —Mase, Elías oeni. ");
INSERT INTO guiNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jare metei vae osɨi omoaquɨ esponja vinagre pe, jare oñono ɨvɨra re, jare omondo Jesús iyuru cotɨ. —Pearo —jei—. Yaecha ou Elías ombogüeyɨ vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jayave Jesús tanta osapúcai, jare omano. ");
INSERT INTO guiNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jayave Tumpa jo omboyao vae osoro mbɨte rupi ɨvate güi ɨvɨ cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jare cien sundaro vae juvicha Jesús jóvai oñemboɨ oi vae oecha yave quirai osapúcai jare omano, jei: —Añete yepe, cuae cuimbae co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jare amogüe cuña reta omae ñogüɨnoi mombɨrɨ güi. Cuae reta ipɨte pe ñogüɨnoi María Magdalena, jare Salomé, jare María. Cuae María imembɨ reta co jae Jacobo taɨrusu vae jare José. ");
INSERT INTO guiNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea pe oicose yave, cuae cuña reta yogüɨraja jae ndive oyeócuai vaera chupe. Jare jeta iru cuña yogüeru jae ndive Jerusalén pe vae reta joco pe ñogüɨnoi vi. ");
INSERT INTO guiNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jocuae ara opaete judío reta oñemocatɨro ñogüɨnoi pɨareve peguara. Echa pɨareve pe outa ovae mbutuu iara. Jae rambue cuaraɨ oique ma yave, ");
INSERT INTO guiNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","metei cuimbae tenta Arimatea pegua José jee vae oñemoatangatu ojo Pilato pɨri, jare oyerure chupe Jesús jetegüe re. José co jae metei mburuvicha. Opaete tenta pegua reta omboete cuae José. Jae oaro oico Tumpa iporoocuaia. ");
INSERT INTO guiNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jare Pilato ipɨacañɨ Jesús omano ma vae re. Jayave oeni cien sundaro vae juvicha, jare oparandu chupe quirai yave ra omano Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jare cien sundaro vae juvicha omombeu chupe. Jayave Pilato jei José pe: —Ndepuere reraja Jesús jetegüe. ");
INSERT INTO guiNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jayave José ogua lienzo. Jare ombogüeyɨ ma yave Jesús jetegüe, oñoma lienzo pe. Jayave oñono metei teogüerɨru ita guasu oyeyoo vae pe, jare omboyeapayere ita tuicha vae teogüerɨru jonque re. ");
INSERT INTO guiNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jare María Magdalena jare José ichɨ María jee vae oecha quiape oñono Jesús. ");
INSERT INTO guiNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mbutuu iara oasa ma yave, María Magdalena, Jacobo ichɨ María jee vae, jare Salomé ogua mbae ipiche cavi vae, jare yogüɨraja oipichɨ vaera Jesús jetegüe re. ");
INSERT INTO guiNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jare neimbove asɨ semana iara tenondegua vae pe cuae cuña reta yogüɨraja teogüerɨru cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jare jei reta oyoupe: —¿Quia ra ombosɨrɨta ñandeve ita tuicha vae teogüerɨru jonque güi? ");
INSERT INTO guiNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Erei omae reta yave, oecha ita oñembosɨrɨ ma teogüerɨru jonque güi. Jocuae ita tuicha yae co. ");
INSERT INTO guiNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jare oique reta yave teogüerɨru pe, oecha metei cunumi oguapɨ oi iyacatu cotɨ. Jemimonde ipucu jare ti. Jare ipɨacañɨ reta jese. ");
INSERT INTO guiNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Erei cunumi jei chupe reta: —Agüɨye pepɨacañɨ. Peeca co pei Jesús Nazaret pegua oyecutuca curusu re vae. Jae oicove ye ma ou omanogüe vae reta ipɨte güi. Mbaeti ma oi cuae pe. Pemae oñeñonoagüe re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pecua pere jemimboe reta pe jare Pedro pe: Jae ojota perenonde Galilea pe. Joco pe peechata, jae jei peve rami —pere chupe reta, jei. ");
INSERT INTO guiNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jayave cuña reta oe teogüerɨru güi, jare tanta osɨi yogüɨraja. Oquɨye güi omboɨpɨ orɨrɨi. Jare mbaeti mbae jei quia pe, oquɨye rambue. ");
INSERT INTO guiNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús oicove ye ou omanogüe vae reta ipɨte güi neimbove asɨ semana iara tenondegua vae pe. Jayave oyeechauca tenonde ete María Magdalena pe. Tenonde yave Jesús omondo siete aña reta cuae cuña güi. ");
INSERT INTO guiNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María ojo omombeu Jesús ndive yogüɨrecose vae reta pe. Jae reta ipɨatɨtɨ güi oyaeo ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María jei chupe reta: —Jesús oicove ye ma oi. Aecha ma —jei chupe reta. Erei oendu yave, mbaeti güɨrovia reta. ");
INSERT INTO guiNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cuae jaɨcue rupi Jesús oyeechauca mócoi jemimboe reta pe, jae reta yogüɨraja rambueve tenta güi icatu cotɨ. Ambué vae echa Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jae reta yogüeru ye tenta pe omombeu iru reta pe. Erei jeseve mbaeti güɨrovia reta. ");
INSERT INTO guiNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cuae jaɨcue rupi Jesús oyeechauca jocuae once jemimboe reta pe etei, jae reta ocaru ñogüɨnoi rambueve, jare oñeengata chupe reta, mbaeti oporogüɨrovia jare ipɨatanta rambue. Echa iru vae reta oecha Jesús, oicove ye güire ou omanogüe vae reta ipɨte güi, jare omombeu tei jemimboe reta pe. Erei jae reta mbaeti güɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jayave Jesús jei chupe reta: —Pecua opaete ɨvɨ rupi. Pemombeu Tumpa iñee icavi vae opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jocuae güɨroviata jare oñembobautizaucata vae oñemboasata. Erei jocuae mbaetita güɨrovia vae ocañɨteita co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jare iru vae reta oechata güɨrovia vae reta oyapo ñogüɨnoi cuae nunga mɨacañɨ reta. Cheree re jae reta omondota aña reta oya jese vae reta güi. Imiarita ambué vae iñee pe. ");
INSERT INTO guiNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Oipɨɨta mboi reta. Jou yave imbayachi vae, ngaraa mbae oyeapo chupe reta. Oñonota ipo imbaerasɨ vae reta re ombogüera vaera —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jayave ñandeYa opa imiari güire chupe reta, ojo ara pe, jare oguapɨ Tumpa iyɨque pe iyacatu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jare jemimboe reta yogüɨraja omombeu Tumpa iñee opaete que rupi. Jare ñandeYa omborɨ, jare oicuauca iru vae reta pe jemimboe reta jeigüe añete vae mɨacañɨ reta oyapo vae pe. Jaeño ma.");
INSERT INTO guiNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jeta vae omombeu ma oicuatía reve opaete ñandepɨte pe oyeapo vae regua. ");
INSERT INTO guiNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jocuae oyeapo vae iyɨpɨ güive oecha vae reta jocorai omombeu ñandeve. Echa jae reta omombeu Tumpa iñee iru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jae rambue icavi echa cheve che vi aicuatía vaera ndeve, mburuvicha Teófilo, amombeu vaera ndeve quirai opaete oyeapo. Echa che aicuaa cavi opaete iyɨpɨ güive oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aicuatía ai ndeve cuae, reicuaa vaera añete co jocuae reñemboe jese vae. ");
INSERT INTO guiNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes oico yave ɨvɨ Judea pegua reta juvicha guasura, oico vi metei sacerdote Zacarías jee vae. Jae co sacerdote atɨ Abías jee vae pegua. Zacarías jembireco co jae Aarón iñemoña reta pegua jare jee co Elisabet. ");
INSERT INTO guiNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías jare jembireco oyapo jupi vae jare jocorai omboyerovia Tumpa. Echa jecuaeño oyapo ñandeYa iporoócuai reta. Mbaeti quia ipuere omboeco reta mbae re. ");
INSERT INTO guiNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Erei mbaeti co Zacarías imichia. Echa Elisabet mbaeti etei ipuere imembɨ. Jare Zacarías indechi ma jare Elisabet itɨaro ma. ");
INSERT INTO guiNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Metei ara atɨ Abías jee vae pegua sacerdote reta oparavɨquɨ ñogüɨnoi Tumpa jo pe. Jae rambue Zacarías oyapo oi iparavɨquɨ joco pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jare jocuae ara Zacarías iparavɨquɨ co oique vaera ñandeYa jo japɨpe pe etei oapɨ vaera mbae ipiche cavi vae. Echa jecuaeño oyapo jocorai sacerdote reta. ");
INSERT INTO guiNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jare jeta yae Israel pegua reta yatɨ ma oyerure ñogüɨnoi Tumpa jo icatu pe, Zacarías mbae ipiche cavi vae oapɨ oi rambueve. ");
INSERT INTO guiNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jare oyecuaa Zacarías pe metei araɨgua ñandeYa pe oyeócuai vae. Araɨgua oñemboɨ oi mbae ipiche cavi vae imesa iyacatu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jare Zacarías oecha yave araɨgua, ipɨacañɨ jare oquɨye vi. ");
INSERT INTO guiNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Erei araɨgua jei chupe: —Agüɨye equɨye, Zacarías. Tumpa oendu ma ndeyerure, jare nerembireco Elisabet imembɨta renoi vaera nderaɨra. Jare rembojeeta Juan —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jare nde reyerovia yaeta co. Jare jeta yae vi oyeroviata jae jeco pegua —jei araɨgua Zacarías pe—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Echa ñandeYa omboeteuca yaeta co. Jae ngaraa etei ocau. Jare tɨnɨeta Espíritu Santo pe ichɨ güi oa güive —jei chupe—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jare omboyerovata ñandeYa Tumpa cotɨ jeta Israel pegua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jae ojota ñandeYa jenonde oaɨuca vaera tu ñavo pe imichia reta jare Tumpa jeigüe mbaeti oyapo vae reta oyeapo vaera iyaracuaa vae retara jare jupi vae retara. Jae oicota Elías oicose rami jare güɨnoita mbaepuere Elías güɨnoise rami —jei araɨgua Zacarías pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jayave Zacarías jei araɨgua pe: —¿Quiraita pa aicuaa añete ra cuae nde rere cheve vae? Echa che chendechi ma jare cherembireco itɨaro ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jayave araɨgua jei ye Zacarías pe: —Che co jae Gabriel. Che añemboɨ Tumpa jóvai. Tumpa chembou chemiari vaera ndeve jare amombeu vaera ndeve cuae ñee icavi vae —jei chupe—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mase, mbaetita neñee cuae amombeu ndeve vae oyeapo regua. Echa mbaeti rerovia che jae ndeve vae. Erei che jae ndeve vae oyeapota co ara ou oyeapo vaera yave —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jare Israel pegua reta oaro ñogüɨnoi Zacarías oe vaera Tumpa jo güi, jare ipɨacañɨ reta quirai Zacarías opɨta ɨma Tumpa jo japɨpe pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jare Zacarías oe yave, mbaeti ipuere omoe iñee chupe reta. Jae rambue jae reta oicuaa Zacarías oecha mbae Tumpa jo pe oi rambueve. Echa jae omopúa iyɨva icotɨ reta. Erei mbaeti etei mbae ipuere jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jare opa ma yave Zacarías iparavɨquɨ Tumpa jo pe, ojo ye jo ae pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jare mbovɨ ara rupi Zacarías jembireco Elisabet ipurúa. Jayave Elisabet oñemi cinco yasɨ jo pe. Echa jae jei: ");
INSERT INTO guiNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Corai ñandeYa oyapo cheve. Ɨma ma chemara iru vae reta güi mbaeti chemembɨ rambue. Erei añave ñandeYa chemborɨ agüɨye vaera chemara chugüi reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jare Elisabet seis yasɨ ma ipurúa yave, Tumpa ombou araɨgua Gabriel tenta Nazaret ɨvɨ Galilea pegua pe ");
INSERT INTO guiNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María pɨri. María co jae metei cuñatai mbaeti etei cuimbae güɨreco vae. Erei oñererocuavee ma omenda vaera José ndive. José co jae metei David iñemoña reta pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jare araɨgua oique María oia pe jare jei chupe: —Eyerovia. ÑandeYa ipɨacavi ndeve. ÑandeYa oi nde ndive. ÑandeYa nemovendise yae iru cuña reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María cuae oendu yave, ipɨacañɨ yae. Echa mbaeti oicuaa mbae ra oipota jei araɨgua jei chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jayave araɨgua jei chupe: —Agüɨye equɨye, María. Echa Tumpa ipɨacavi ndeve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mase, ndepuruata co jare nemembɨta. Jare rembojeeta nemembɨ Jesús —jei María pe—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jae güɨnoita mbaepuere tuicha yae vae, jare jeeta co Tumpa Taɨ. Jare ñandeYa Tumpa oyapota Israel pegua reta juvicha guasura itenondegua David rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jare jae oicota Jacob iñemoña reta juvicha guasura jecuaecuae aveiño. Jare jae iporoocuaia ngaraa opa —jei araɨgua chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jayave María jei araɨgua pe: —¿Quiraita pa oyeapo cuae? Echa mbaeti vɨteri areco cuimbae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jayave araɨgua jei ye María pe: —Espíritu Santo outa ndeve. Tumpa imbaepuere rupi cuae oyeapota ndeve. Jae rambue nemembɨ oata iyoa mbae reve jare jeeta co Tumpa Taɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mase, nerentara Elisabet vi ipurúa, yepe tei itɨaro ma. Seis yasɨ ma ipurúa güire, yepe tei iru vae reta ombojee ‘Imembɨ mbae vae’ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Echa Tumpa ipuere oyapo opaete —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jayave María jei araɨgua pe: —Mase, che co jae ñandeYa pe oyeócuai vae. Tove toyeapo cheve nde rere cheve vae rami —jei. Jayave araɨgua ojo ye María oia güi. ");
INSERT INTO guiNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jayave mbovɨ ara rupi María oe jenta güi ojo voi ɨvɨtɨ reta Judea pegua cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jare ojo ovae Zacarías jo pe, jare joco pe oicuava Elisabet. ");
INSERT INTO guiNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jare Elisabet oendu yave María jei chupe vae, Elisabet imembɨ opoopo jɨe pe. Jare Elisabet tɨnɨe Espíritu Santo pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jayave Elisabet iñeeata reve jei: —Tumpa nemovendise yae iru cuña reta güi. Jare omovendise yaeta nemembɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jare yepe tei nde co jae cheYa ichɨra, erei nde reyu repou chepɨri. Chepɨacañɨ yae cuae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mase, nde remboɨpɨ nemiari cheve rupive, chemembɨ opoopo cherɨe pe oyerovia yae rambue —jei Elisabet María pe—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nde rerovia ñandeYa oyapota co jae jei ndeve oyapota vae. Jae rambue jae nemovendise ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jayave María jei: —Amboete ñandeYa. ");
INSERT INTO guiNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ayerovia Tumpa re. Jae co chemboasa vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yepe tei che cheparavete, erei jae oñemongueta cheré. Mase, añave güive opaete ñaneñemoña reta jeita Tumpa chemovendise co. ");
INSERT INTO guiNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Echa Tumpa imbaepuere tuicha yae co. Jae oyapo icavi yae vae cheve imbaepuere pe. Jae co iyoa mbae vae jee vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jare Tumpa oipararecota opaete ñaneñemoña oquɨye chugüi vae reta —jei María—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Oicuauca quirai imbaepuere tuicha yae co. Omoai oñemboete vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jae oequi imbaepuere mburuvicha reta güi, jare omboeteuca oñemomichi vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Omoangapɨɨ ñɨmbɨaɨ vae reta tembíu icavi vae pe. Erei mbaeti mbae omee oicocatu vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Omborɨ Israel pegua oyeócuai chupe vae reta. Echa imaendúa quirai jei oipararecota co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Echa jocorai jei ñanetenondegua reta pe - jae reta co Abraham jare iñemoña reta. Echa jei chupe reta oipararecota co jecuaecuae aveiño —jei María. ");
INSERT INTO guiNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jare María opɨta Elisabet pɨri mboapɨ yasɨ. Jayave ojo ye jenta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jare ara ou ovae yave Elisabet imembɨ vaera, oa imembɨ cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jare jeracua Elisabet jentaɨgua reta jare jentara reta pe quirai ñandeYa oiparareco yae Elisabet. Jare jae reta oyerovia Elisabet ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jare michia ocho ara ma güɨnoi yave, jentara reta yogüeru omocircuncidauca vaera. Jare jae reta oipota oñono jese tu jee Zacarías. ");
INSERT INTO guiNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Erei michia ichɨ jei chupe reta: —Ani. Ñambojeeta co Juan. ");
INSERT INTO guiNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Erei jae reta jei chupe: —Mbaeti etei co nerentara jocuae tee güɨnoi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jayave jae reta iñaca omomɨi Zacarías pe oparandu vaera chupe mbae nunga tee ra oipota oñono taɨ re. ");
INSERT INTO guiNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jayave Zacarías oechauca chupe reta jae oipota mbae oicuatía jese vae. Jayave oicuatía corai: Jee co Juan. Jare opaete joco pe ñogüɨnoi vae reta ipɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jayave jupivei Zacarías ipuere omoe ye iñee. Jare imiari chupe reta omboete reve Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jare opaete Zacarías jentaɨgua reta oquɨye cuae re. Jare opaete cuae oyeapo vae jeracua opaete ɨvɨtɨ Judea pegua reta rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jare opaete oendu vae reta oñemongueta yae ipɨa pe cuae oyeapo vae re jare jei reta iyeupe: —¿Mbae nunga michia ra co aipo cuae? Echa ñandeYa imbaepuere oi jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jayave Zacarías - jae co Juan tu - tɨnɨe Espíritu Santo pe jare omombeu Tumpa iñee. Echa jae jei: ");
INSERT INTO guiNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Toñemboeteuca ñandeYa Tumpa. Ñande co jae Israel pegua reta. Echa Tumpa oñemongueta ñanderé rambue, ñanderepɨ ma —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jae ombou ñandeve jembiócuai David iñemoña reta pegua ñanemboasa vaera imbaepuere tuicha vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jocorai Tumpa jei iyɨpɨ güive Tumpa iñee omombeu vae reta rupi. Jae reta oñeñono tee Tumpa peguara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tumpa ñanemboasata ñanderovaicho reta güi. Jae ñanemboasata opaete ñanemotareɨ vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Tumpa oiparareco Abraham jare iru ñanetenondegua reta. Echa Tumpa etei omee morogüɨrocuavee Abraham pe, jare añave imaendúa ma jocuae morogüɨrocuavee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jae rambue omeeta ñandeve yayeócuai vaera chupe yaquɨye mbae reve. Echa jae ñanderepɨta ñanderovaicho reta güi —jei Zacarías—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tumpa ñaneñono teeta iyeupeguara jare yayapota jupi vae, jare jae oicota ñande ndive cuae ɨvɨ pe yaico rambueve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jare iru vae reta imiari nderé yave, jeita: Jae co metei Tumpa iñee omombeu vae. Echa nde, cheraɨ reota ñandeYa jenonde reyapocavi vaera japera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Remombeuta ñandeYa imbae reta pe quirai Tumpa iñɨrota chupe reta imbaeyoa reta re jare jocorai oñemboasaucata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Corai Tumpa oyapota, ñandeparareco yae rambue. Jare iporoparareco jeco pegua ombouta ñanemboasa vaera, ara ñavo ombou cuaraɨ ñanemborɨ vaera rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jae ñanemborɨta cuaraɨ jembipe ñanemborɨ rami. Echa cuaraɨ omee ñandeve tembipe agüɨye vaera yaico pɨtumimbi pe. Jae ñanemborɨta agüɨye vaera yaquɨye mano güi. Jae ñanemborɨta yaico vaera ñandepɨacatu reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jare michia ocuacuaa, jare jatangatu yae. Jare oico ñuu reta rupi oyecuaa Israel pegua reta pe regua. ");
INSERT INTO guiNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Juan ichɨ güi oa güire, romano reta juvicha guasu Augusto César jee vae oyócuai opaete vae oyepapauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tenonde yave opaete vae oyepapauca Cirenio oico ɨvɨ Siria pegua reta juvicha guasura yave. ");
INSERT INTO guiNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jare opaete vae yogüɨraja itenondegua jenta pe oyepapauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jare José vi ojo Nazaret Galilea pegua güi tenta Belén Judea pegua pe. Echa jae co David iñemoña reta pegua, jare David jenta co jae Belén. ");
INSERT INTO guiNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jae rambue José ojo Belén pe oyepapauca vaera, jare güɨraja jembireco María. Jare María ipurúa ma. ");
INSERT INTO guiNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jare Belén pe ñogüɨnoi rambueve, ara ou ovae María imembɨ oa vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jare María imembɨrɨpɨ cuimbae oa. Jayave María oñoma metei asoya pe jare omoñeno metei maemɨmba icaruarɨru pe. Echa mbaeti co José jare María jendara o pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jare jocuae pɨtu amogüe vecha reta iñangarecoa reta oñangareco ñogüɨnoi ivecha reta re tenta güi icatu pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jare oyecuaa chupe reta metei araɨgua ñandeYa pe oyeócuai vae, jare jembipe yae jae reta ñogüɨnoia pe. Echa ñandeYa imaemboete oyecuaa chupe reta. Jare jae reta oquɨye yae. ");
INSERT INTO guiNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jayave araɨgua jei chupe reta: —Agüɨye pequɨye. Mase, amombeu peve ñee icavi vae peyerovia yae vaera. Cuae ñee opaete perentaɨgua reta pegua co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Echa cuae pɨtu oa oporomboasa vae David jenta pe. Jae co ñandeYa Cristo —jei araɨgua chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jare corai peicuaata: Pevaeta michia oñeoma oi metei asoya pe jare oñeno oi metei maemɨmba icaruarɨru pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jare jupivei oyecuaa jocuae araɨgua ndive jeta yae araɨgua reta. Opaete vae omboete Tumpa. Echa jei reta: ");
INSERT INTO guiNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Toñemboeteuca Tumpa ara pe oi vae, jare ɨvɨ pegua reta Tumpa ipɨacavi chupe reta vae tipɨacatu —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jare araɨgua reta yogüɨraja ye yave chugüi reta ara pe, vecha reta iñangarecoa reta jei oyoupe: —Yaja Belén pe yaecha vaera cuae oyeapo vae. Echa ñandeYa oicuauca ñandeve —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jayave iñangueco yogüɨraja joco pe, jare ovae María jare José jare michia. Jocuae michia oñeno oi metei maemɨmba icaruarɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jare oecha ma yave, yogüɨraja ye omombeu iru vae reta pe araɨgua jei chupe reta jocuae michia re vae. ");
INSERT INTO guiNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jare opaete oendu vae reta ipɨacañɨ vecha reta iñangarecoa reta omombeu chupe reta vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Erei María imaendúa opaete cuae re jare oñemongueta cavi jese ipɨa pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jare vecha reta iñangarecoa reta yogüɨraja ye tenta güi icatu pe. Omboete reta Tumpa jare omee yasoropai chupe opaete oendu jare oecha vae re. Echa jae reta oecha ma michia araɨgua jei chupe reta rami. ");
INSERT INTO guiNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jare michia ocho ara ma güɨnoi yave, tu jare ichɨ omocircuncidauca jare ombojee Jesús. Echa araɨgua omombeu María pe jocorai ombojee vaera ndei María ipurúa mbove. ");
INSERT INTO guiNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jare ara ou ovae María ojo vaera ñandeYa jo pe oyetɨo vaera ñandeYa cotɨ. Echa jocorai oyecuatía oi Moisés iporoócuai pe cuña imembɨ vae oyapo vaera. Jayave tu jare ichɨ güɨraja Jesús tenta Jerusalén pe ñandeYa jo pe oñonouca tee vaera Tumpa peguara. ");
INSERT INTO guiNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Echa ñandeYa iporoócuai pe oyecuatía oi corai: Cuña imembɨrɨpɨ cuimbae oa yave, michia oñeñono teeta ñandeYa peguara. Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jae rambue Jesús tu jare ichɨ oyucauca güɨrocuavee vaera ñandeYa pe mócoi güɨra tórtola jee vae ani mócoi pɨcasu taɨrusu vae. Echa jocorai jei oyapo vaera mboroócuai ñandeYa omee chupe reta vae pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jare jocuae ara metei Jerusalén pegua Simeón jee vae oi Tumpa jo pe. Simeón jecuaeño oyapo jupi vae jare omboete Tumpa. Jae oaro oi omborɨta Israel pegua reta vae ou vaera. Jare jae tɨnɨe Espíritu Santo pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jare Espíritu Santo oicuauca ma Simeón pe quirai ngaraa omano ndei oecha Cristo ñandeYa ombouta vae mbove. ");
INSERT INTO guiNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jare jocuae ara Espíritu Santo oicuauca ma Simeón pe ojo vaera oique Tumpa jo pe. Jare Jesús tu jare ichɨ güɨraja Jesús güɨroique Tumpa jo pe oyapo vaera mboroócuai jeigüe rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jayave Simeón ovoɨ Jesús jare omboete Tumpa. Jae jei: ");
INSERT INTO guiNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—CheYa, jecuaeño ayeócuai ndeve. Añave ndepuere remaeño cheré amano vaera chepɨacatu reve. Echa corai nde rere cheve oyeapota co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aecha ma oporomboasa vae nde rembou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nde reiparavo opaete vae peguara —jei Simeón—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jae co metei tembipe rami. Oime tembipe yave yaecha cavi mbaembae. Jae ramiño vi jae ndecuauca cavita judío mbae vae reta pe. Jare Israel pegua reta oñemboeteucata jae jeco pegua. Echa Israel pegua reta nembae reta co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jare José jare Jesús ichɨ ipɨacañɨ Simeón jei Jesús re vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jare Simeón jei Tumpa tomovendise José jare María. Jayave jei María pe: —Mase, Tumpa oiparavo ma cuae nemembɨ. Jae oicuaucata Israel pegua reta pe quia co jae. Erei jeta Israel pegua reta oyeapota jovaicho retara. Jae rambue Tumpa oyapota icavi mbae vae chupe reta. Erei taɨcue rupi oyapota icavi vae chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Echa oyecuaata opaete vae ipɨa pe oi vae. Jare nde etei ndepɨatɨtɨ yaeta jese —jei Simeón María pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jare oico vi metei cuña Ana jee vae. Jae co Fanuel tayɨ. Jocuae Fanuel co jae atɨ Aser jee vae pegua. Ana co jae Tumpa iñee omombeu vae. Itɨaro yae ma. Jaeño siete año oico ime ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Echa jayave ime omano chugüi. Ana güɨnoi ma ochenta y cuatro año. Jecuaeño opɨta Tumpa jo pe jare oyeócuai Tumpa pe. Echa oyecuacu tembíu güi jare oyerure Tumpa pe ara rupi jare pɨtu rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jae ou ovae José jare María jare Jesús ñogüɨnoia pe. Jayave jae vi omee yasoropai ñandeYa pe, jare imiari Jesús re opaete Jerusalén pegua oaro ñogüɨnoi Cristo ou oepɨ vaera vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jare José jare María oyapo ñandeYa jo pe opaete ñandeYa iporoócuai jei oyapo vaera vae. Jayave yogüɨraja ye Galilea pe jenta ae Nazaret pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jare michia ocuacuaa jare jatangatu yae. Iyaracuaa yae. Jare Tumpa ipɨacavi oi jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jare año ñavo Jesús tu jare ichɨ yogüɨraja Jerusalén pe pascua iyarete pe. ");
INSERT INTO guiNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jare Jesús doce año ma güɨnoi yave, ojo jae reta jupíe arete pe, jae reta jeco rami. ");
INSERT INTO guiNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jare arete opa ma yave, Jesús tu jare ichɨ oe Jerusalén güi yogüeru ye vaera jenta pe. Erei Jesús opɨta Jerusalén pe tu jare ichɨ oicuaa mbae reve. ");
INSERT INTO guiNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Echa jae reta oñemongueta tei Jesús ojo vi iguatairu reta jupíe. Erei jave ma yave, oeca reta tei jentara reta jare iru oicuaa vae reta ñogüɨnoia rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Erei mbaeti ovae chupe. Jayave Jesús tu jare ichɨ yogüɨraja ye Jerusalén pe oeca vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jare mboapɨ ara ma oasa yave, ovae reta Jesús Tumpa jo pe. Jesús oguapɨ oi mboroócuai re oporomboe vae reta ipɨte pe. Oyeapɨsaca oi jese reta jare oparandu chupe reta mbaembae re. ");
INSERT INTO guiNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jare opaete vae ipɨacañɨ yae. Echa Jesús oicuaa cavi opaete iporomboe jare ipuere omombeu cavi chupe reta jae reta oparandu chupe mbae re yave. ");
INSERT INTO guiNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jare Jesús tu jare ichɨ oecha yave, jae reta vi ipɨacañɨ yae. Jayave ichɨ jei Jesús pe: —Chemembɨ, ¿maera pa reyapo corai oreve? Mase, nderu jare che roeca tei opaete que rupi orepɨatɨtɨ yae reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jayave Jesús jei chupe reta: —¿Maera pa chereca opaete que rupi? Icavi co apɨta vaera cuae pe ayapo vaera cheRu iparavɨquɨ. ¿Mbaeti pa peicuaa cuae? —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Erei jae reta mbaeti oicuaa mbae oipota jei Jesús jei chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jayave Jesús ou ye Nazaret pe jae reta jupíe, jare jecuaeño oyapo jae reta jeigüe. Jare Jesús ichɨ imaendúa opaete oyeapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jare Jesús jecuae ocuacuaa. Jare iyaracuaa yae. Jecuaeño omboyerovia Tumpa jare iru vae reta vi. ");
INSERT INTO guiNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Jare Tiberio César quince año ma romano reta juvicha guasura oico yave, Tumpa ombou iñee Juan pe. Juan co jae Zacarías taɨ, jare oico ñuu pe. Jocuae ara reta pe Poncio Pilato oico Judea pegua reta juvicha guasura, jare Herodes oico Galilea pegua reta juvicha guasura, jare Herodes tɨvɨ Felipe jee vae oico ɨvɨ Iturea pegua reta jare ɨvɨ Traconite pegua reta juvicha guasura, jare Lisanias oico ɨvɨ Abilinia pegua reta juvicha guasura. Jare Anás jare Caifás yogüɨreco Israel pegua reta isacerdote tenondegua retara. ");
INSERT INTO guiNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jayave Juan oguata oico opaete ɨaca Jordán iyɨvɨ rupi. Jare omombeu opaete vae pe oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae jare oñembobautizauca vaera, Tumpa iñɨro vaera chupe reta imbaeyoa reta re. ");
INSERT INTO guiNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías co jae metei Tumpa iñee aracae omombeu vae. Jae oicuatía corai: Jae iñeeata reve jeita ñuu pe: Peyapocavi ñandeYa japera. Pemosɨmbi tape —jeita. ");
INSERT INTO guiNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Opaete jugua reta oñemotɨnɨeta ɨvɨ pe. Jare opaete ɨvɨtɨ reta oyeapota ñuu rami. Jare tape ñape vae reta oñemosɨmbiucata. Jare tape ipɨcoe yae vae reta ipecavita. ");
INSERT INTO guiNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jare opaete vae oicuaata quirai Tumpa ipuere oporomboasa. Jocorai oicuatía Isaías. ");
INSERT INTO guiNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jare jeta vae yogüeru Juan oia pe oñembobautizauca vaera. Jayave Juan jei chupe reta: —Pe reta co jae mboi reta rami. ¿Quia pa omombeu peve peyerova vaera Tumpa cotɨ agüɨye vaera Tumpa pochɨ peve? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Peyapo icavi vae, jocorai peicuauca vaera añetete peeya co peñemongueta icavi mbae vae pepɨa pe oi vae. Agüɨye pere peyeupe pepɨa pe: Ñanetenondegua co jae Abraham. Echa che jae peve cuae: Tumpa ipuere oyapo cuae ita reta güi Abraham iñemoña retara —jei Juan chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ñamojaanga metei ɨvɨra. Ɨvɨra ia mbaeti yave icavi, ɨvɨra iya oyasɨa japo omboyapara vaera, jare taɨcue rupi oapɨ. Jae ramiño vi mbaeti yave peyapo icavi vae, Tumpa oiporaraucata peve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jayave joco pe ñogüɨnoi vae reta oparandu Juan pe: —¿Mbae pa royapota? ");
INSERT INTO guiNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jayave Juan jei chupe reta: —Oime yave quia mócoi temimonde güɨnoi vae, tomee metei mbaeti temimonde güɨnoi vae pe. Jare oime yave quia jeta tembíu güɨnoi vae, tomee mbovɨ mbaeti tembíu güɨnoi vae pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yogüeru vi Juan oia pe mburuvicha peguara ocovara vae reta oñembobautizauca vaera. Jae reta oparandu Juan pe: —Oporomboe vae, ¿mbae pa royapota? ");
INSERT INTO guiNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jayave Juan jei chupe reta: —Agüɨye mo pemoiru pecovara mburuvicha reta omombeu peve vae ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sundaro reta vi oparandu Juan pe: —¿Mbae pa royapota? Jayave Juan jei chupe reta: —Agüɨye pemomburu iru vae reta jare agüɨye peapu iru vae reta re. Jare agüɨye jecuaeño peipota jeta yae peruvicha omboepɨ peve vae güi. ");
INSERT INTO guiNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Opaete vae oaro ñogüɨnoi Cristo ou vaera, jare oñemongueta ipɨa pe quirai güɨramoi Juan co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jae rambue Juan jei chupe reta: —Che pombobautiza ɨ pe. Erei outa ipuere yae chegüi vae. Mbaeti jupi che amboi vaera ipɨapaa. Jae pembobautizata Espíritu Santo pe jare tata pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jae co trigo oarɨvo vae rami. Echa trigo oarɨvo vae omboveve trigo omboyao vaera trigo etei trigo ipire güi. Jayave oñovatu trigo etei jɨru pe. Erei oapɨ trigo ipire tata pe. Tata Cristo oiporuta vae opa mbae vae co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jare Juan jeta yae jei chupe reta omombeu vaera chupe reta ñee icavi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jare mburuvicha guasu Herodes omenda tɨvɨ Felipe jembireco Herodías jee vae ndive jare oyapo jeta mbae icavi mbae vae. Jare Juan iñeengueta Herodes pe opaete icavi mbae vae oyapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jayave Herodes oyapo ye icavi mbae vae. Echa oñonouca Juan tembipɨɨrɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Erei ndei Juan oñeñonouca tembipɨɨrɨru pe mbove, metei ara Jesús ou Juan oia pe. Jare Juan iru vae reta ombobautiza güire, ombobautiza vi Jesús. Jare Jesús oyerure Tumpa pe rambueve, ara oyepea. ");
INSERT INTO guiNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jare oyecuaa Espíritu Santo ogüeyɨ Jesús re pɨcasu rami. Jayave oñeendu ñee ara güi jei: —Nde co jae cheRaɨ. Roaɨu yae. Ayerovia yae nderé —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jare Jesús güɨnoi ma treinta año rupi. Iru vae reta oñemongueta tei jae co José taɨ ete. José co jae Elí taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí co jae Matat taɨ. Matat co jae Leví taɨ. Leví co jae Melqui taɨ. Melqui co jae Jana taɨ. Jana co jae José taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José co jae Matatías taɨ. Matatías co jae Amós taɨ. Amós co jae Nahum taɨ. Nahum co jae Esli taɨ. Esli co jae Nagai taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai co jae Maat taɨ. Maat co jae Matatías taɨ. Matatías co jae Semei taɨ. Semei co jae José taɨ. José co jae Judá taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá co jae Joana taɨ. Joana co jae Resa taɨ. Resa co jae Zorobabel taɨ. Zorobabel co jae Salatiel taɨ. Salatiel co jae Neri taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri co jae Melqui taɨ. Melqui co jae Adi taɨ. Adi co jae Cosam taɨ. Cosam co jae Elmodam taɨ. Elmodam co jae Er taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er co jae Josué taɨ. Josué co jae Eliezer taɨ. Eliezer co jae Jorim taɨ. Jorim co jae Matat taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat co jae Leví taɨ. Leví co jae Simeón taɨ. Simeón co jae Judá taɨ. Judá co jae José taɨ. José co jae Jonán taɨ. Jonán co jae Eliaquim taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim co jae Melea taɨ. Melea co jae Mainán taɨ. Mainán co jae Matata taɨ. Matata co jae Natán taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán co jae David taɨ. David co jae Isaí taɨ. Isaí co jae Obed taɨ. Obed co jae Booz taɨ. Booz co jae Salmón taɨ. Salmón co jae Naasón taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón co jae Aminadab taɨ. Aminadab co jae Aram taɨ. Aram co jae Esrom taɨ. Esrom co jae Fares taɨ. Fares co jae Judá taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá co jae Jacob taɨ. Jacob co jae Isaac taɨ. Isaac co jae Abraham taɨ. Abraham co jae Taré taɨ. Taré co jae Nacor taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor co jae Serug taɨ. Serug co jae Ragau taɨ. Ragau co jae Peleg taɨ. Peleg co jae Heber taɨ. Heber co jae Sala taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala co jae Cainán taɨ. Cainán co jae Arfaxad taɨ. Arfaxad co jae Sem taɨ. Sem co jae Noé taɨ. Noé co jae Lamec taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec co jae Matusalén taɨ. Matusalén co jae Enoc taɨ. Enoc co jae Jared taɨ. Jared co jae Mahalaleel taɨ. Mahalaleel co jae Cainán taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán co jae Enós taɨ. Enós co jae Set taɨ. Set co jae Adán taɨ. Adán co jae Tumpa taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jare Jesús ou ye Jordán güi. Jae tɨnɨe Espíritu Santo pe. Jayave Espíritu Santo omondo Jesús ñuu pe. ");
INSERT INTO guiNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jare Jesús opɨta ñuu pe cuarenta ara, jare aña guasu imiari chupe oyapouca vaera tei mbaeyoa chupe. Jare jocuae ara reta pe Jesús mbaeti mbae jou. Jae rambue jocuae ara reta opa ma yave, ñɨmbɨaɨ co. ");
INSERT INTO guiNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jayave aña guasu jei Jesús pe: —Nde co jae Tumpa Taɨ yave, ere cuae ita pe oyeapo vaera mbɨyapera. ");
INSERT INTO guiNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Erei Jesús jei chupe: —Tumpa iñee pe oyecuatía oi corai: Icavi co ɨvɨ pegua reta jou vaera mbɨyape güɨnoi vaera tecove. Erei icavi yae co oyeapɨsaca vaera Tumpa iñee re jare oyapo vaera jeigüe güɨnoi vaera tecove opa mbae vae. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jayave aña guasu güɨraja Jesús metei ɨvɨtɨ re jare oechauca chupe metei jeia pe opaete mburuvicha guasu reta iporoocuaia ɨvɨ pe ñogüɨnoi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jayave aña guasu jei Jesús pe: —Tamee ndeve mbaepuere reyeapo vaera opaete cuae juvicha guasura, opaete vae nemboete vaera. Echa cuae mbaepuere oñemee co cheve jare chepuere amee aipota amee chupe vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nde reyeatɨca yave chemboete vaera, tamee ndeve nembaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jayave Jesús jei chupe: —Ecua chegüi, Satanás. Echa Tumpa iñee pe oyecuatía oi corai: Che co jae ndeYa Tumpa. Chemboete —jei Tumpa—. Jaeño cheve eyeócuai. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jayave aña guasu güɨraja Jesús Jerusalén pe jare omboyeupi Tumpa jo iyapɨte re. Jayave jei chupe: —Nde co jae Tumpa Taɨ yave, ea cuae güi. ");
INSERT INTO guiNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Echa Tumpa iñee pe oyecuatía oi corai: Tumpa oyocuaita araɨgua reta oñangareco vaera nderé. ");
INSERT INTO guiNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ipo pe ndepɨɨ retata agüɨye vaera ndepɨ rembopere ita re. Jocorai oyecuatía oi —jei aña guasu chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jayave Jesús jei chupe: —Tumpa iñee pe oyecuatía oi corai: Che co jae ndeYa Tumpa. Agüɨye mbae eyapo reicuaa vaera tuicha ra chepɨaguasu. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jare aña guasu opa ma imiari chupe yave oyapouca vaera tei mbaeyoa chupe, ojo ye chugüi michi pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jayave Jesús ou ye Galilea pe. Jare güɨnoi mbaepuere Espíritu Santo omee chupe vae. Jare jeracua jese opaete jocuae ɨvɨ rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jare jae oporomboe judío reta itupao reta pe jare opaete vae omboete. ");
INSERT INTO guiNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jayave ou ye Nazaret pe - joco pe jae ocuacuaa. Jayave mbutuu iara pe oique judío reta itupao pe jeco ae rami, jare oñemboɨ Tumpa iñee omongueta vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jare oñemee Jesús pe metei libro. Jocuae libro pe oi Tumpa iñee aracae omombeu vae Isaías oicuatía vae. Jayave Jesús oipea libro jare ovae omongueta vaera. Jayave omongueta corai: ");
INSERT INTO guiNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ÑandeYa iEspíritu oime che ndive oi. Jae cheparavo amombeu vaera ñee icavi vae paravete vae reta pe. Jae chembou ambopɨacatu vaera ipɨatɨtɨ vae reta. Chembou vi amombeu vaera tembipɨɨ reta pe ipuere ma oyeyora, jare amombeu vaera jesa mbae vae reta pe omae vaera. Chembou vi ayora vaera oiporara vae reta oiporarauca chupe vae reta imbaepuere güi. ");
INSERT INTO guiNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chembou vi amombeu vaera ñandeYa ipɨacavita opaete vae pe. Jocorai omongueta. ");
INSERT INTO guiNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jayave Jesús oñoquenda ye libro jare omee ye libro iñangarecoa pe. Jayave oguapɨ ye. Jare opaete tupao pe ñogüɨnoi vae reta omae ngatu Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jayave Jesús jei chupe reta: —Cuae ara cuae oyecuatía oi vae oyeapo ma perovaque. ");
INSERT INTO guiNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jare opaete joco pe ñogüɨnoi vae reta imiari cavi jese. Echa ipɨacañɨ yae iñee icavi yae vae re. Jae reta jei: —¿Jaea yera cuae José taɨ? ");
INSERT INTO guiNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jayave Jesús jei chupe reta: —Pereta co cheve jocuae ñamojaanga reve yae vae: Nde co jae metei oporopoano vae. Jae rambue eñepoano. Echa jeracua oreve quirai mbaembae reyapo Capernaum pe. Jae rambue eyapo vi cuae pe ndeɨvɨ ae pe —pereta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Añete che jae peve, oime yave quia Tumpa iñee jentaɨgua reta pe omombeu vae, jae reta mbaeti güɨrovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Añete che jae peve, jeta cuña imemano vae reta yogüɨreco Israel pe Elías oico rambueve. Mboapɨ año jare seis yasɨ mbaeti oquɨ jare caruai yae opaete que rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Erei Tumpa mbaeti omondo Elías metei cuña imemano vae Israel pegua pɨri. Jaeño omondo metei cuña imemano vae tenta Sarepta Sidón pegua pɨri —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jae ramiño vi jeta ipire ocúi vae reta yogüɨreco Israel pe Tumpa iñee aracae omombeu vae Eliseo oico rambueve. Erei Tumpa mbaeti omondo Eliseo ombogüera vaera metei ipire ocúi vae Israel pegua. Jaeño omondo ombogüera vaera Naamán, jare Naamán co jae Siria pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cuae oendu reta yave, opaete tupao pe ñogüɨnoi vae reta pochɨ yae Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jayave jae reta opúa jare güɨraja Jesús tenta güi icatu pe ɨvɨtɨ iyapɨte re omombo vaera tei ɨvɨ cotɨ joco güi. Jocuae tenta oi ɨvɨtɨ re. ");
INSERT INTO guiNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Erei Jesús oasa jae reta ipɨte rupi jare ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jayave Jesús ojo tenta Capernaum Galilea pegua pe. Joco pe Jesús oporomboe mbutuu iara ñavo. ");
INSERT INTO guiNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jare oyeapɨsaca jese vae reta ipɨacañɨ iporomboe re. Echa omboe reta mbaepuere güɨnoi vae rami. ");
INSERT INTO guiNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jare oique tupao pe cuimbae aña oya jese vae. Jae iñeeata reve jei: ");
INSERT INTO guiNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Maera pa reyu oremambeco, Jesús Nazaret pegua? ¿Reyu pa oremboai vaera? Che rocuaa. Nde co jae iyoa mbae vae. Nde reyu co Tumpa güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jayave Jesús oñeengata chupe. —¡Nequirii! ¡Ecua chugüi! —jei. Jayave aña oitɨ ɨvɨ re cuimbae jare ojo chugüi. Oeya caviño. ");
INSERT INTO guiNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jare opaete oecha vae reta ipɨacañɨ jare oparandu oyoupe: —¿Mbae nunga ñee pa cuae? Echa mbaepuere pe oyócuai aña reta yogüɨraja vaera oya jese vae reta güi, jare jae reta oyapo oyocuaigüe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jare jeracua jese opaete jocuae ɨvɨ rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jare Jesús tupao güi oe yave, oique Simón jo pe. Jare Simón jaicho jacu yae oi. Iru joco pe ñogüɨnoi vae reta oyerure Jesús pe ombogüera vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jayave Jesús ojo cuña oia pe jare jei jacu opɨta vaera chugüi. Jayave jacu opɨta chugüi. Jayave jupiveiño cuña opúa jare omee mbae jou reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jare cuaraɨ oique ma yave, opaete jentara imbaerasɨ vae güɨnoi vae reta güeru imbaerasɨ vae reta Jesús oia pe. Jare Jesús oñono ipo metei ñavo re jare ombogüera reta. ");
INSERT INTO guiNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jare aña reta yogüɨraja oya jese vae reta güi. Osapúcai reta jare jei: —Nde co jae Tumpa Taɨ. Erei Jesús oñeengata chupe reta. Mbaeti omaeño aña reta re imiari vaera. Echa jae reta oicuaa jae co Cristo. ");
INSERT INTO guiNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pɨareve pe Jesús oe tenta güi ojo mbaeti quia oicoa pe. Jayave tenta pegua reta yogüɨraja oeca. Jare yogüɨraja ovae yave jae oia pe, oyerure tei chupe agüɨye vaera ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Erei Jesús jei chupe reta: —Icavi co aja vaera iru tenta reta pe amombeu vaera joco pe vi ñee icavi vae Tumpa iporoocuaia regua. Echa cuaera Tumpa chembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jare ojo opaete Galilea rupi jare omombeu Tumpa iñee judío reta itupao ñavo pe. ");
INSERT INTO guiNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jare metei ara Jesús oñemboɨ rambueve ɨ guasu Genesaret jee vae jembeɨ pe, jeta vae yogüeru jae oia pe oendu vaera Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jare Jesús oecha mócoi chalana ɨ jembeɨ pe. Iya reta oyeporaca vae reta co. Oeya reta joco pe, pɨsa reta oyoe rambueve. ");
INSERT INTO guiNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jayave Jesús oyeupi metei chalana pe, jare oyerure metei oyeporaca vae Simón jee vae pe güɨroique mi vaera chalana ɨ pe. Echa Simón imbae co jocuae chalana. Jayave Jesús oguapɨ chalana pe jare omboe joco pe ñogüɨnoi vae reta joco güi. ");
INSERT INTO guiNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jare opa ma imiari yave, Jesús jei Simón pe: —Ecua ɨ tɨpɨa pe pemombo pepɨsa reta ɨ pe pemboa vaera jevae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jayave Simón jei Jesús pe: —Carai, orecoe ma roparavɨquɨ tei. Mbaeti mbae romboa. Erei tamombo pɨsa reta nde rere cheve rambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jare jocorai oyapo reta ma yave, jeta yae jevae reta oique pɨsa pe. Jare pɨsa oñemboɨpɨ osoro. ");
INSERT INTO guiNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jayave Simón oyepueru iñeiru iru chalana pe ñogüɨnoi vae reta pe yogüeru vaera omborɨ. Jayave jae reta yogüeru jare omotɨnɨe reta mócoi reve chalana. Jare mócoi reve ipoɨ yae jare osacambu pota echa. ");
INSERT INTO guiNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jare Simón Pedro cuae oecha yave, oyeatɨca Jesús jóvai jare jei chupe: —Ecua chegüi, cheYa. Echa che co jae metei cuimbae iyoa vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Echa Pedro jare opaete jae ndive ñogüɨnoi vae reta ipɨacañɨ jeta yae jevae omboa vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jae ramiño vi Simón iñeiru reta Jacobo jare Juan jee vae ipɨacañɨ jese. Jacobo jare Juan Zebedeo taɨ reta co. Jayave Jesús jei Simón pe: —Agüɨye equɨye. Che roapota iru vae reta reru vaera cheve cuae ara güive —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jayave jae reta güeru ichalana reta ɨ jembeɨ pe. Jayave oeya reta opaete, yogüɨraja vaera Jesús jupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jare Jesús ojo ovae yave metei tenta pe, joco pe oi metei cuimbae ipire ocúi yae vae. Cuimbae oecha Jesús yave, oyeatɨca jae jóvai jare oyerure chupe. —CheYa —jei—, reipota yave, ndepuere chembogüera. ");
INSERT INTO guiNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jayave Jesús oñono ipo jese. —Aipota. Ecuera —jei chupe. Jare jupiveiño cuimbae ocuera imbaerasɨ güi. Mbaeti ma ocúi ipire. ");
INSERT INTO guiNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jayave Jesús oyócuai: —Agüɨye emombeu quia pe. Ecua eyeechauca sacerdote pe, jare recuera ma rambue, emee mbota Moisés peócuai rami, tenta pegua reta oicuaa vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Erei jeta yae vae oendu Jesús oyapo vae regua. Jayave jeta yae vae oñemboatɨ jae oia pe oyeapɨsaca vaera jese jare jae ombogüera vaera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Erei Jesús ojo chugüi reta mbaeti quia oicoa pe oyerure vaera Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jare metei ara Jesús oporomboe oi, jare amogüe fariseo reta jare mboroócuai re oporomboe vae reta oguapɨ ñogüɨnoi jocoropi. Jae reta yogüeru Jerusalén jare opaete tenta Galilea jare Judea pegua reta güi. Jare Jesús güɨnoi ñandeYa imbaepuere ombogüera vaera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jayave amogüe yogüeru vae reta güeru metei cuimbae imbaerasɨ vae. Cuae cuimbae imbaerasɨ vae mbaeti ipuere omɨi. Güeru vae reta oipota tei güɨroique imbaerasɨ vae o pe, oñono vaera Jesús jóvai. ");
INSERT INTO guiNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Erei mbaeti ipuere güɨroique Jesús oia pe, yatɨ vae reta jeco pegua. Jae rambue oyeupi reta ovapɨa re imbaerasɨ vae ndive. Jayave oequi reta mbovɨ ovapɨa güi Jesús iárambue, jare ombogüeyɨ reta cuimbae mbaeti ipuere omɨi vae jupa reve opaete vae ipɨte pe Jesús jóvai. ");
INSERT INTO guiNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús cuae oecha yave, oicuaa jae reta güɨrovia co jese, jare jei cuimbae mbaeti ipuere omɨi vae pe: —Nembaeyoa reta oñemboai ma, cherɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jayave mboroócuai re oporomboe vae reta jare fariseo reta oñemongueta ipɨa pe: ¿Quia pa co jae corai jei vaera? Jei icavi mbae vae Tumpa cotɨ. Tumpaño co ipuere iñɨro quia pe imbaeyoa reta re. ");
INSERT INTO guiNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Erei Jesús oicuaa jae reta iñemongueta, jare jei chupe reta: —¿Maera pa peñemongueta jocorai pepɨa pe? ");
INSERT INTO guiNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chepuere jae cuae cuimbae pe: Nembaeyoa reta oñemboai ma. Jae ramiño vi chepuere jae chupe: Epúa eguata. ¿Mbae nunga pa mbaetita yavai jae vaera? —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Erei aipota peicuaa vaera cuae: Che cuimbaera ayeapo vae chepuere cheɨro quia pe imbaeyoa reta re ɨvɨ pe ai rambueve —jei. Jayave jei cuimbae mbaeti ipuere omɨi vae pe: —Che jae ndeve: Epúa evoɨ nderupa, jare ecua ndero pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jayave jupivei cuimbae opúa, jare ovoɨ jupa, jare oe ojo jo cotɨ opaete joco pe ñogüɨnoi vae reta jovaque. Jare ojo rambueve, omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jae ramiño vi opaete joco pe ñogüɨnoi vae reta omboete Tumpa. Echa opareve ipɨacañɨ jare oquɨye yae. Jei reta: —Cuae añave yaecha vae ñanemopɨacañɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jayave Jesús oe jare oecha mburuvicha peguara ocovara vae Leví jee vae oguapɨ oi mburuvicha peguara ocovara ñogüɨnoia pe, jare jei chupe: —Eyu cherupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jayave Leví opúa jare ojo jae jupíe. Oeya opaete imbaembae joco pe. ");
INSERT INTO guiNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jare Leví oyapo arete tuicha vae jae jo pe Jesús peguara. Jare joco pe jeta mburuvicha peguara ocovara vae reta jare iru vae reta ocaru vi ñogüɨnoi Jesús jare iru reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Erei mboroócuai re oporomboe vae reta jare fariseo reta iñeenguru Jesús jemimboe reta pe. Jei reta: —¿Maera pa pecaru mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta ndive? ");
INSERT INTO guiNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jayave Jesús jei chupe reta: —Mbaeti mbae jasɨ chupe vae reta mbaeti oeca oporopoano vae. Imbaerasɨ vae retaño oeca —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Che ayu aeni vaera iyoa vae reta oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae, mbaeti jupi vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jare amogüe vae yogüeru Jesús oia pe jare jei chupe: —Juan jemimboe reta jeta vese oyecuacu tembíu güi oyerure reve Tumpa pe. Jae ramiño vi oyapo jocorai fariseo reta jemimboe reta. Erei neremimboe reta ocaruñoi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jayave Jesús jei chupe reta: —Omendata vae pɨri ñogüɨnoi vae reta ngaraa etei oyecuacu tembíu güi, omendata vae jae reta ndive oi rambueve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Erei outa ovae ara omendata vae oyererajauca vaera chugüi reta. Jayave ramo oyecuacuta tembíu güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jayave imiari chupe reta omojaanga reve. —Mbaeti icavi ñamboya vaera temimonde indechi vae maemboyaa ipɨau vae pe. Echa jocorai yayapo yave, maemboyaa ipɨau vae omoata temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jae ramiño vi mbaeti icavi ñamboɨru vaera vino ipɨau vae vino jɨru guasupi indechi vae pe. Echa jocorai yayapo yave, vino ipɨau vae omondoro jɨru, jare vino oyepɨyere jare jɨru mbaeti ma icavi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jae rambue ñamboɨru vino ipɨau vae jɨru ipɨau vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jare oime yave quia vino indechi vae jou vae, mbaeti jupivei oipota jou vino ipɨau vae. Echa jae jei vino indechi vae icavi yae vino ipɨau vae güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mbutuu iara pe Jesús ojo co reta rupi jemimboe reta ndive. Jare jemimboe reta oipoo trigo. Jayave oipoquɨtɨ oequi vaera ipire, trigo jou vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jare amogüe fariseo reta jei chupe reta: —¿Maera pa peyapo agüɨyeta tei peyapo mbutuu iara pe vae? ");
INSERT INTO guiNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jayave Jesús jei fariseo reta pe: —¿Mbaeti etei pa pemongueta David oyapogüe vae regua, jae jare jae ndive ñogüɨnoi vae reta ñɨmbɨaɨ yave? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David oique Tumpa jo pe jare jou mbɨyape reta Tumpa jo pe oñeñono tee vae, jare omee vi jae ndive ñogüɨnoi vae reta pe. Agüɨyeta tei co quia jou jocuae mbɨyape, jaeño sacerdote reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jayave Jesús jei ye chupe reta: —Che cuimbaera ayeapo vae chepuere jae mbae icavi oyeapo vaera mburuu iara pe. ");
INSERT INTO guiNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jare iru mbutuu iara pe Jesús oique judío reta itupao pe jare oporomboe. Jare joco pe oi metei cuimbae ipo iyacatu omano vae. ");
INSERT INTO guiNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jare mboroócuai re oporomboe vae reta jare fariseo reta omae ngatu Jesús re oecha vaera ombogüerata ra quia mbutuu iara pe. Echa oipota tei ovae omboeco vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Erei Jesús oicuaa jae reta iñemongueta, jare jei cuimbae iporovaicho omano vae pe: —Epúa eyu eñemboɨ cuae pe. Jayave cuimbae opúa oñemboɨ joco pe ñogüɨnoi vae reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jayave Jesús jei chupe reta: —Taparandu peve cuae: ¿Mbae pa jei mboroócuai? ¿Yayapota pa icavi vae ani icavi mbae vae mbutuu iara pe? ¿Icavi pa yaporoepɨ ani yaporoyuca vaera mbutuu iara pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jayave omae opaete iyɨpɨ rupi ñogüɨnoi vae reta re, jare jei cuimbae pe: —Eupi ndepo. Jayave cuimbae oupi jare ipo ocuera cavi ma. ");
INSERT INTO guiNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jayave mboroócuai re oporomboe vae reta jare fariseo reta pochɨ yae Jesús pe jare oñomomiari mbae ra oyapota Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jayave metei pɨtu Jesús ojo ɨvɨtɨ re oyerure vaera Tumpa pe, jare icoe joco pe oyerure reve Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jare coe ma yave, oeni jemimboe reta. Jayave oiparavo doce ombojee temimondo reta vae: ");
INSERT INTO guiNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón (Jesús ombojee Pedro), jare Simón tɨvɨ Andrés jee vae, jare Jacobo jare Juan, jare Felipe, Bartolomé, ");
INSERT INTO guiNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeo taɨ Jacobo jee vae, Simón (Zelote jee vae), ");
INSERT INTO guiNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobo tɨvɨ Judas jee vae, jare Judas Iscariote (cuae cuimbae omoeterenga Jesús jovaicho reta pe). ");
INSERT INTO guiNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jayave Jesús ogüeyɨ ye ɨvɨtɨ güi ñuu pe jae reta ndive. Jare joco pe ñogüɨnoi jeta Jesús jemimboe reta jare jeta yae Judea pegua reta jare Jerusalén pegua reta jare tenta reta Tiro jare Sidón iyɨvɨrigua reta. Tiro jare Sidón coiño co ñogüɨnoi ɨ guasu güi. Opaete vae yogüeru oyeapɨsaca vaera Jesús re, jare Jesús ombogüera vaera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús ombogüera vi aña oya jese vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jare opaete vae oipota oyavɨquɨ Jesús. Echa jae güɨnoi mbaepuere ombogüera vaera opaete imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jayave Jesús omae jemimboe reta re jare jei: —Toyerovia paravete vae reta. Echa Tumpa omeeta chupe reta yogüɨreco vaera iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Toyerovia añave ñɨmbɨaɨ vae reta. Echa Tumpa jeta yae omeeta chupe reta. Toyerovia añave oyaeo vae reta. Echa opuca retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Iru vae reta pemotareɨta jare ngaraa oipota yogüɨreco peirura. Jae reta jeita icavi mbae vae peve jare peangaota. Corai oyapo retata peve pe reta perovia cheré rambue. Che co jae cuimbaera oyeapo vae. Erei peyerovia —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jocuae ara ou ovae yave, peyerovia. Echa Tumpa güɨnoi ara pe mbae icavi yae vae peveguara. Echa jocorai oyapo retata peve vae itenondegua reta oyapo jocuae nunga icavi mbae vae Tumpa iñee aracae omombeu vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Erei oicocatu vae reta oiporarata co. Echa jae reta oyerovia yae ma jeta corepoti güɨnoi vae re —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jare jeta yae güɨnoi vae reta oiporarata co. Echa ñɨmbɨaɨ retata. Añave opuca reta. Erei ipɨatɨtɨ retata jare oyaeo retata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jare opaete vae jei icavi vae jese vae reta oiporarata co. Echa jocoraiño vi oyapo itenondegua reta oporombotavɨ vae reta pe. Jocuae oporombotavɨ vae reta jei yapu reve: Che co jae metei Tumpa iñee omombeu vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Erei che jae pe reta peyeapɨsaca cheré vae pe cuae: Peaɨu perovaicho reta, jare peyapo icavi vae pemotareɨ vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iru vae reta oyepopeyu peré yave jare icavi mbae vae jei peve yave, peyerure Tumpa pe jae omovendise reta vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Oime yave quia ocua nderovaɨque re vae, erova ipuere vaera ocua ye jovaicho re. Jare oime yave quia ndeasoya opɨro ndegüi vae, emaeño jese opɨro vaera ndegüi necamisa vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Oime yave quia oyerure ndeve mbae re vae, emee chupe. Jare oime yave quia nembaembae opɨro ndegüi vae, agüɨye eñemoacateɨ chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Peyapo iru vae reta pe peipota iru vae reta oyapo peve vae rami —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Echa peaɨu yave peraɨu vae retaño, jocuae mbaeti co mbae icavi vae. Echa iyoa vae reta yae chupe vae oyapo vi jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jare peyapo yave icavi vae icavi vae oyapo peve vae reta peño, jocuae mbaeti co mbae icavi vae. Echa iyoa vae reta yae chupe vae oyapo vi jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jare peiporuca yave mbae iru vae pe jae omee ye peve vaeraño, jocuae mbaeti co mbae icavi vae. Echa iyoa vae reta yae chupe vae oiporuca mbaembae iru vae pe jocuae iru vae omboecovia ye chupe vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Erei peaɨu perovaicho reta, jare peyapo icavi vae chupe reta. Peiporuca mbae iru vae pe jare agüɨye pearo omboecovia ye peve vaera. Jocorai peyapo yave, Tumpa omeeta peve mbae icavi yae vae jare peapota taɨ retara. Echa Tumpa ipɨacavi mbaeti omee yasoropai chupe vae reta pe jare icavi mbae vae oyapo vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Peiparareco iru vae reta, peRu oiparareco rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Agüɨye pejaa iru vae, agüɨye vaera iru vae peraa. Agüɨye pemboeco iru vae mbae re, agüɨye vaera iru vae pemboeco mbae re. Peɨro iru vae pe, iru vae iñɨro vaera peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pemee mbaembae iru vae reta pe, jare iru vae reta omeeta mbaembae peve. Jae reta omeeta peve jeta yae iru vae reta pe pemee vae güi. Echa icavi vae peyapo yave iru vae reta pe, iru vae reta oyapota icavi vae peve. Erei icavi mbae vae peyapo yave iru vae reta pe, iru vae reta oyapota icavi mbae vae peve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jayave Jesús jei ye chupe reta omojaanga reve: —Metei jesa mbae vae mbaeti etei ipuere oechauca tape iru jesa mbae vae pe. Jocorai oyapo yave, mócoi reve oasavita ɨvɨcua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Metei oñemboe oi vae mbaeti oicuaa mbatee oporomboe vae oicuaa vae güi. Erei opaete re oñemboe yave, oicuaata oporomboe vae oicuaa rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Agüɨye jecuaeño emae ɨtɨ michi vae neiru jesa pe oi vae re, oime yave renoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ngaraa ndepuere rere neiru pe: Cherɨvɨ, taequi nderesa güi jocuae ɨtɨ michi vae. Echa nde renoi ɨtɨ tuicha vae nderesa pe. Nde co jae oporombotavɨ vae. Eequi rani ɨtɨ tuicha vae nderesa güi. Jayave remae cavita ndepuere vaera reequi ɨtɨ michi vae neiru jesa güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Metei ɨvɨra icavi vae mbaeti omee ia icavi mbae vae. Jae ramiño vi metei ɨvɨra icavi mbae vae mbaeti omee ia icavi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Echa yaicuaa metei ɨvɨra icavi co ia icavi yave. Mbaeti yaequi ɨva metei yai güi. Jae ramiño vi mbaeti yaequi uva metei yai güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Quia nunga jecocavi vae güɨnoi icavi vae ipɨa pe. Jae rambue jei icavi vae. Jae ramiño vi quia nunga jecopochɨ vae güɨnoi icavi mbae vae ipɨa pe. Jae rambue jei icavi mbae vae. Echa metei ñavo ipɨa pe güɨnoi vae rupi imiari —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Maera pa pere cheve: OreYa, oreYa? Echa mbaeti peyapo che jae peve peyapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Oime yave quia ou cheve oyeapɨsaca vaera cheré vae, jae oyapo yave che jae chupe oyapo vaera vae, tamojaanga peve mbae rami co jae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jae co metei cuimbae jora oyapo vae rami. Oyoo ipɨpucu oñono vaera o iguapɨara ita tuicha vae ɨvɨgüɨ pe oi vae re. Jare o oyeapo ma yave, oquɨ tanta jare jeta yae ɨ osɨrɨ o iyɨpɨ rupi. Erei o mbaeti etei omɨi. Echa iyapoa oñono ita tuicha vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Erei oime yave quia oyeapɨsaca cheré vae, mbaeti yave oyapo che jae chupe oyapo vaera vae, jae co iru cuimbae jora oyapo vae rami. Erei jae mbaeti oyoo oñono vaera o iguapɨara ita tuicha vae ɨvɨgüɨ pe oi vae re. Oñono jora ɨvɨ iárambue eteiño. Jayave oquɨ tanta jare jeta yae ɨ osɨrɨ o iyɨpɨ rupi jare opa omboyapara. Opa oñemboai jocuae o —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jare opa ma imiari yave oyeapɨsaca jese vae reta pe, Jesús ojo Capernaum pe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jare jocuae tenta pe oico metei cien sundaro vae juvicha jembiócuai. Cuae cuimbae imbaerasɨ. Omano pota echa. Jare cien sundaro vae juvicha oaɨu cuae jembiócuai. ");
INSERT INTO guiNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jare cien sundaro vae juvicha oendu Jesús regua. Jae rambue omondo Jesús oia pe amogüe judío reta itenondegua reta, jae reta oyerure vaera Jesús pe ojo vaera ombogüera cien sundaro vae juvicha jembiócuai. ");
INSERT INTO guiNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jare yogüeru ovae yave Jesús oia pe oyerure yae chupe cuae re. Jei reta chupe: —Cuae mburuvicha ipɨacavi co. Jae rambue icavi co nde reyapo vaera cuae chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Echa jae ñanderaɨu jare oyapo ñandeve metei tupao —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Jayave Jesús ojo jae reta jupíe. Jare yogüɨraja ma ovae yave coiño mburuvicha jenta güi, mburuvicha ombou amogüe iñeiru reta oñoovaiti vaera Jesús ndive. Jae reta jei chupe: —Mburuvicha jei: Agüɨye reñemambeco, cheYa, reyu vaera chero pe. Echa che mbaeti co mbae. Jae rambue mbaeti aja roovaiti. Ndepuere rere joco güiño cherembiócuai ocuera vaera, jare ocuerata co —jei, jei reta chupe—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Echa oime mburuvicha mbaepuere güɨnoi cheré vae reta. Jae ramiño vi che anoi mbaepuere sundaro reta re. Che jae metei sundaro pe: Ecua, jare jae ojo. Jae ramiño vi che jae iru sundaro pe: Eyu, jare jae ou. Jae ramiño vi che jae cherembiócuai pe: Eyapo cuae, jare jae oyapo —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jare Jesús cuae oendu yave, ipɨacañɨ cien sundaro vae juvicha re. Jayave oyerova jare jei jeta vae yogüɨraja jaɨcue vae pe: —Che jae peve, mbaeti avae cuae nunga mborogüɨrovia tuicha vae Israel pegua reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jayave cien sundaro vae juvicha ombou vae reta yogüɨraja ye cien sundaro vae juvicha jo pe, jare oecha ocuera ma co tembiócuai imbaerasɨ vae. ");
INSERT INTO guiNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jayave pɨareve pe Jesús ojo tenta Naín pe. Jare jeta jemimboe reta jare iru vae reta yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jare ojo ma ovae yave coiño tenta itaraquera güi, omano vae güeru vae reta yogüeru tenta güi icatu cotɨ. Omano vae metei cuimbae co jare ichɨ metei cuña imemano vae co. Omano vae jocuae cuña imembɨ jae vaeño co. Jare jeta tenta pegua reta yogüeru jocuae cuña jupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jare ñandeYa oecha yave cuña, oiparareco jare jei chupe: —Agüɨye eyaeo. ");
INSERT INTO guiNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jayave Jesús ojo oyavɨquɨ omano vae oñeno jese vae. Jare ovoɨ güeru vae reta opɨta. Jayave Jesús jei: —Taɨrusu, che jae ndeve: Epúa. ");
INSERT INTO guiNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jayave omano vae oguapɨ jare omboɨpɨ imiari. Jayave Jesús omee ichɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jayave opaete vae oquɨye yae. Omboete reta Tumpa. Jei reta: —Metei Tumpa iñee omombeu vae ipuere yae vae ou ma ñandepɨte pe. Tumpa ombou ñandeve ñanderaɨu rambue. Echa ñande co jae imbae reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jare Jesús oyapo vae jeracua opaete Judea rupi jare opaete Judea iyɨvɨri rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jare Juan jemimboe reta omombeu Juan pe opaete cuae regua. ");
INSERT INTO guiNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jayave Juan oeni mócoi jemimboe reta jare ombou ñandeYa oia pe jei vaera chupe: —¿Nde pa co Cristo outa vae? ani ¿roarota pa iru vae ou vaera? ");
INSERT INTO guiNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jayave jocuae cuimbae reta yogüeru ovae Jesús oia pe jare jei chupe: —Juan oporombobautizase vae orembou ndeve. Jae jei: ¿Nde pa co jae Cristo outa vae? ani ¿roarota pa iru vae ou vaera? —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jayave jocuae ora pe etei Jesús ombogüera jeta imbaerasɨ vae reta jare omondo aña reta oya jese vae reta güi. Jae ramiño vi ombogüera jeta jesa mbae vae reta, jae reta omae vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jayave Jesús jei Juan ombou chupe vae reta pe: —Pecua ye pemombeu Juan pe peecha jare peendu vae. Jesa mbae vae reta ipuere ma omae. Mbaeti ipuere oguata vae reta ipuere ma oguata. Ipire ocúi vae reta ocuera ma. Iyapɨsa mbae vae reta ipuere ma oendu. Omano vae reta oicove ye. Paravete vae reta oyeapɨsaca ñee icavi vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jare Tumpa omovendiseta jecuae güɨrovia cheré vae reta —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jare yogüɨraja ye yave Juan ombou vae reta, Jesús omboɨpɨ imiari joco pe ñogüɨnoi vae reta pe Juan re. Jei chupe reta: —¿Quia re pa co peo ñuu pe pemae? Jae mbaeti co ipɨrata mbae vae tacuarasɨ omɨi ɨvɨtu oipeyu yave vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Quia re pa co peo pemae? Jae mbaeti omonde temimonde ipora vae. Mase, temimonde ipora vae omonde vae reta yogüɨreco mburuvicha guasu reta jo pe jare icavi yae yogüɨreco —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Peo ra pemae vaera metei Tumpa iñee omombeu vae re? Añete che jae peve, Tumpa omee chupe oyapo vaera jeta yae iru Tumpa iñee omombeu vae reta oyapo vae güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tumpa iñee pe oyecuatía oi jese corai: Mase —jei Tumpa—, che amondota cheñee güɨrajata vae nerenonde, oyapocavi vaera nderapera. Jocorai oyecuatía oi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Che jae peve, Tumpa omee Juan oporombobautizase vae pe oyapo vaera jeta yae iru Tumpa iñee omombeu vae reta oyapo vae güi. Erei taɨcuegua vae Tumpa iporoocuaia pegua oñemboeteuca yaeta Juan güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jare mburuvicha peguara ocovara vae reta jare opaete oyeapɨsaca Juan re vae reta oicuauca Tumpa jupi co. Echa Juan ombobautiza reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Erei Fariseo reta jare mboroócuai re oporomboe vae reta mbaeti oyapo Tumpa jei oyapo vaera vae. Echa mbaeti oñembobautizauca Juan pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jayave Jesús jei ye chupe reta: —Tamombeu peve mbae ndive amboyovaque añave yogüɨreco vae reta. Tamombeu peve mbae rami co jae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jae reta co michia maemeea pe oguapɨ ñogüɨnoi vae reta rami. Jae reta jei oyoupe corai: Roñemimbɨ ma peve, erei pe reta mbaeti pepɨrae. Orepɨatɨtɨ perovaque, erei pe reta mbaeti peyaeo. Jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Echa Juan oporombobautizase vae ou, jare jae oyecuacu tembíu jare vino güi. Jae rambue pe reta pere aña oya co Juan re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Che cuimbaera ayeapo vae ayu, jare che mbaeti ayecuacu tembíu jare vino güi. Jae rambue pe reta pere: Mase, jae jou jeta tembíu jare vino. Jae co mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta iamingo —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Erei opaete iyaracuaa vae reta oicuauca aracuaa icavi co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jare metei fariseo oparea Jesús pe ojo vaera ocaru jae ndive. Jayave Jesús ojo fariseo jo pe jare oguapɨ ocaru vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jare metei cuña aguasa rupi oico vae jocuae tenta pegua oicuaa Jesús ocaru co oi fariseo jo pe, jare güeru mbae ipiche cavi vae jɨru alabastro pegua pe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jayave cuña oñemboɨ Jesús icupe cotɨ jare oyaeo. Jare omboɨpɨ omoaquɨ Jesús ipɨ jesaɨ pe. Jayave cuña omotini Jesús ipɨ ia pe jare oipɨte vi. Jayave oipichɨ mbae ipiche cavi vae ipɨ re. ");
INSERT INTO guiNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jare fariseo Jesús pe oparea vae cuae oecha yave, jei iyeupe ipɨa pe: —Cuae cuimbae metei Tumpa iñee omombeu vae yave, oicuaata tei quia co cuae cuña jare mbae nunga cuña co jae. Echa iyoa vae co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jayave Jesús jei fariseo pe: —Simón, aipota mbae jae ndeve. —Ere cheve, oporomboe vae —jei Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jayave Jesús jei chupe: —Mócoi cuimbae ipía iru cuimbae pe. Metei cuimbae ipía chupe quinientos denario, jare iru cuimbae ipía chupe cincuenta denario —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Erei mócoi reve mbaeti güɨnoi corepoti ipía omboepɨ vaera. Jayave oporombopía vae iñɨro ete mócoi reve pe ipía re —jei—. Emombeu cheve, oporombopía vae cuae oyapo rambue, cuae mócoi vae güi ¿quia nunga pa oaɨu yaeta oporombopía vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jayave Simón jei Jesús pe: —Che añemongueta jocuae cuimbae ipía jeta yae re iñɨro chupe vae. Jayave Jesús jei ye chupe: —Jaecavi rere. ");
INSERT INTO guiNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jayave Jesús oyerova cuña cotɨ jare jei Simón pe: —Mase, emae cuae cuña re. Che aique ndero pe yave, mbaeti remee cheve ɨ ayoe vaera chepɨ. Erei jae omoaquɨ ma chepɨ jesaɨ pe jare omotini ia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nde mbaeti cheyurupɨte. Erei cuae cuña aique güive oipɨte chepɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nde mbaeti reñono aceite cheaca re. Erei cuae cuña oipichɨ mbae ipiche cavi vae chepɨ re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jae rambue che jae ndeve, yepe tei jeta yae cuae cuña imbaeyoa reta, erei cheɨro chupe jese. Echa jae cheraɨu yae. Erei oime yave quia michi yae re iru vae iñɨro chupe vae, jae michi yae vi oaɨu jocuae iru vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jayave Jesús jei cuña pe: —Cheɨro ndeve nembaeyoa reta re. ");
INSERT INTO guiNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jayave Jesús ndive ocaru ñogüɨnoi vae reta jei iyeupe ipɨa pe: —¿Quia ra co cuae? ¿Quiraita ra ipuere iñɨro quia pe imbaeyoa reta re? ");
INSERT INTO guiNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Erei Jesús jei cuña pe: —Reñemboasauca ma rerovia cheré rambue. Ecua ndepɨacatu reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jare cuae jaɨcue rupi Jesús ojo opaete tenta tuicha vae reta jare tenta michi vae reta rupi, jare omombeu ñee icavi vae Tumpa iporoocuaia regua. Jare jocuae doce vae yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Jare jeta cuña reta yogüɨraja vi jae jupíe jare omborɨ Jesús jare jemimboe reta. Mbaembae oata Jesús jare jemimboe reta pe yave, jocuae cuña reta ogua chupe reta. Tenonde yave amogüe jocuae cuña reta imbaerasɨ jare aña reta oya amogüe vae re. Erei Jesús ombogüera. Metei cuña jee co María Magdalena. Jesús omondo siete aña reta chugüi. Iru jee co Juana. Jae co Chuza jembireco. Chuza co jae mburuvicha guasu Herodes jembiócuai. Iru jee co Susana. ");
INSERT INTO guiNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jare jeta vae yogüeru opaete tenta reta güi oñemboatɨ Jesús oia pe. Jayave Jesús jei chupe reta omojaanga reve: ");
INSERT INTO guiNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Metei cuimbae ojo omaetɨ vaera. Omaetɨ yave, omoai temitɨ, jare amogüe oa tape rupi. Jayave iru vae reta opɨro temitɨ re jare güɨra reta jou vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iru temitɨ oa mbovɨño ɨvɨ ita guasu iárambue oia pe. Erei oe rupive, ipiru, jocuae ɨvɨ mbaeti ñaquɨ rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Iru temitɨ oa ñanapɨte pe. Ñana ocuacuaa yave, ombopɨtupa temitɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iru temitɨ oa ɨvɨcavi pe. Cuae oe jare ocuacuaa jare jeta yae ia —jei. Jare cuae jei ma chupe reta yave, iñeeata reve jei ye: —Ipuere oendu vae toyeapɨsaca cuae re. ");
INSERT INTO guiNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jayave Jesús jemimboe reta oparandu Jesús pe: —¿Mbae pa oipota jei cuae remojaanga reve rere vae? ");
INSERT INTO guiNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jayave Jesús jei chupe reta: —Amombeu ma peve Tumpa iporoocuaia regua. Cuae mbaeti oyecuaa iru vae reta pe. Jae rambue amboe iru vae reta amojaanga reve. Cuae ayapo agüɨye vaera oecha cavi, yepe tei omae, jare agüɨye vaera oicuaa, yepe tei oendu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cuae amojaanga reve che jae peve vae oipota jei cuae: Temitɨ oñemojaanga Tumpa iñee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jocuae temitɨ tape rupi oa vae oñemojaanga amogüe Tumpa iñee oendu vae re. Jayave ou aña guasu chupe reta jare omoacañɨ Tumpa iñee güi, agüɨye vaera güɨrovia Tumpa oñemboasauca vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jae ramiño vi jocuae temitɨ oñeotɨ mbovɨño ɨvɨ ita guasu iárambue oia pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. Jae reta oendu rupive, güɨrovia oyerovia reve. Erei cuae reta jocuae temitɨ japo mbaeti icavi vae rami co. Echa michi peguaño güɨrovia ñee. Erei mbaesusere oyeapo chupe yave, mbaeti ma oipota oyeapɨsaca Tumpa iñee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jae ramiño vi jocuae temitɨ oñeotɨ ñanapɨte pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. Erei omboɨpɨ oñemambeco ɨvɨ pe oyeapo vae re jare corepoti oipota güɨnoi vaera vae re jare yerovia ɨvɨ pegua re. Jae rambue jae reta jocuae temitɨ mbaeti ia vae rami co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Erei jocuae temitɨ oñeotɨ ɨvɨcavi pe vae oñemojaanga iru Tumpa iñee oendu vae reta re. Cuae reta oyeapɨsaca cavi Tumpa iñee re ipɨacavi reve, jare oyapo Tumpa iñee jei oyapo vaera vae. Jae rambue jae reta jocuae temitɨ ia cavi vae rami co. Jae reta oyapo icavi vae ipɨaguasu reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mechero ñamoendɨ yave, mbaeti etei ñañono yapepo oñembovapɨ oi vae igüɨ pe, ani güɨrapembɨ igüɨ pe. Ñañono co mechero jenda pe, o pe oique vae reta güɨnoi vaera tembipe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Oime yave mbae oñemi vae, oyeechaucañotai co. Jae ramiño vi oime yave mbae oyeasoi vae, oyecuaañotai co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Peñemongueta cavi peendu vae re. Echa güɨnoi vae pe oñemoiruta, jare mbaeti güɨnoi vae güi michi yae güɨnoi echa vae oyeequita —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jayave Jesús ichɨ jare tɨvɨ reta yogüeru ovae Jesús oia pe. Erei mbaeti ipuere oya Jesús re jeta joco pe ñogüɨnoi vae reta jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jayave amogüe vae jei Jesús pe: —Ndesɨ jare nderɨvɨ reta oñemboɨ ñogüɨnoi icatu pe. Ndereca ñogüɨnoi —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jayave Jesús jei chupe reta: —Cuae reta oyeapɨsaca Tumpa iñee re jare oyapo jeigüe. Cuae nunga reta co jae chesɨ jare cherɨvɨ reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jare metei ara Jesús oyeupi metei chalana pe jemimboe reta ndive. Jayave Jesús jei chupe reta: —Yaja ɨ guasu jovaicho pe. Jayave omboɨpɨ yogüɨraja ɨ guasu rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Erei yogüɨraja rambueve, Jesús oque oi. Jare ou ɨ guasu pe ɨvɨtu tanta oyepeyu, jare ɨaparúa oñeñoña chalana pe, jare omotɨnɨe seri ma. Jae reta oñemongueta omanota co. ");
INSERT INTO guiNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jayave omoingove reta Jesús, jare jei chupe: —¡Oporomboe vae, oporomboe vae! Ñamanota ma. Jayave Jesús opúa, jare oñeengata ɨvɨtu jare ɨ guasu pe. Jayave mbaeti ma ɨvɨtu jare opa ma ɨaparúa, jare opaete quirii. ");
INSERT INTO guiNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jayave Jesús jei chupe reta: —¿Maera pa mbaeti peporogüɨrovia? Jare jae reta oquɨye jare ipɨacañɨ, jare jei oyoupe: —¿Mbae nunga cuimbae pa cuae? Echa jae oyócuai ɨvɨtu jare ɨ guasu, jare jae reta oyapo oyocuaigüe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jayave yogüɨraja Galilea güi ovae ɨ guasu jovaicho pe gadareno reta iɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús ogüeyɨ ma chalana güi yave, ou oovaiti metei cuimbae jocuae tenta pegua. Ɨma ma aña reta oya jese. Nandi co. Mbaeti etei oico o pe. Teogüerɨrurenda rupiño ma oico. ");
INSERT INTO guiNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cuae cuimbae oecha Jesús yave, osapúcai jare oyeatɨca Jesús jóvai. Jayave iñeeata reve jei: —¿Maera pa reyu chemambeco, Jesús? Nde co jae Tumpa ara pe oi vae Taɨ. Ayerure ndeve agüɨye vaera reiporarauca cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Echa Jesús oyócuai ma aña ojo vaera cuimbae güi. Jeta vese ma aña oipɨɨ cuimbae. Jare iru vae reta oñapɨti tei cadena reta pe jare oipocua tei jiero reta pe. Erei jae omondoo cadena reta jare opa omope ipocuaa. Jare jecuaeño ojo ñuu cotɨ aña omondo rambue. ");
INSERT INTO guiNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jare Jesús oparandu chupe: —¿Mbae pa nderee? —Cheree co jae jeta vae —jei. Echa jeta aña reta oya jese. ");
INSERT INTO guiNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jayave aña reta oyerure Jesús pe agüɨye vaera oyócuai reta yogüɨraja vaera omanogüe vae reta pɨri. ");
INSERT INTO guiNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jare joco pe jeta cuchi reta ocaru ñogüɨnoi ɨvɨtɨ re. Jayave aña reta oyerure Jesús pe omaeño vaera jese reta oya vaera cuchi reta re. Jayave Jesús omaeño jese reta. ");
INSERT INTO guiNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jayave aña reta yogüɨraja cuimbae güi jare oya cuchi reta re. Jayave cuchi reta osɨi tanta oa ɨ guasu pe ɨvɨa güi, jare joco pe ipɨtupa reta. ");
INSERT INTO guiNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jare cuchi reta iñangarecoa reta cuae oecha yave, otecuarai yogüɨraja tenta pe omombeu tenta pegua reta jare icatu rupigua reta pe cuae oyeapo vae regua. ");
INSERT INTO guiNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jayave oendu vae reta yogüeru oecha vaera mbae oyeapo vae. Jare yogüeru ovae yave Jesús oia pe, oecha cuimbae aña reta oya jesegüe vae oguapɨ oi Jesús jóvai. Oecha oñemonde ma jare iyaracuaa cavi a oi. Jare opaete yogüeru vae reta oquɨye. ");
INSERT INTO guiNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jare jocuae cuchi reta iñangarecoa tenonde yave oecha vae reta omombeu iru reta pe quirai oyeapo cuimbae aña reta oya jesegüe vae pe jae ocuera vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jayave opaete gadareno reta omoñera Jesús ojo vaera iɨvɨ güi. Echa oquɨye yae reta. Jayave Jesús oyeupi ye chalana pe yogüɨraja ye vaera chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jare cuimbae aña reta oya jesegüe vae oyerure Jesús pe omaeño vaera jese ojo vaera jae jupíe. Erei Jesús mbaeti omaeño jese. Jei chupe: ");
INSERT INTO guiNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ecua ndero pe emombeu iru vae reta pe mbae icavi yae vae Tumpa oyapo ndeve vae. Jayave cuimbae ojo jare omombeu iru vae reta pe opaete tenta rupi mbae icavi yae vae Jesús oyapo chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jare Jesús ojo ovae yave ɨ guasu jovaicho pe, joco pe ñogüɨnoi vae reta omae jese oyerovia reve. Echa oaro ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jayave ou metei cuimbae Jairo jee vae. Jae co judío reta itupao re oñangareco vae. Jae oyeatɨca Jesús jóvai, jare oyerure chupe ojo vaera jae jo pe. ");
INSERT INTO guiNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Echa jae güɨnoi meteiño tayɨ doce año rupi güɨnoi vae. Omano pota echa ma. Jayave Jesús ojo jae jupíe. Jare jeta yae vae yogüɨraja Jesús jupíe jare oyopɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jare jae reta jupíe ojo metei cuña doce año ma oiporara tugüɨguasu vae. Cuña omee ma opaete icorepoti oporopoano vae reta pe. Erei mbaeti metei ave ipuere ombogüera. ");
INSERT INTO guiNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jayave cuña oya Jesús re icupe cotɨ, jare oyavɨquɨ jemimonde jembeɨ. Jare jupivei jugüɨguasu opɨta chugüi. ");
INSERT INTO guiNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jayave Jesús jei: —¿Quia pa cheremimonde oyavɨquɨ? Opaete vae jei mbaeti co oyavɨquɨ jemimonde. Jare Pedro jei Jesús pe: —Oporomboe vae, jeta yae vae cuae pe ñogüɨnoi jare ndeopɨ reta co. ¿Maera pa rere: Quia pa cheremimonde oyavɨquɨ? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Erei Jesús jei: —Quia nunga vae oyavɨquɨ co cheremimonde. Echa aicuaa ambogüera ma co quia chembaepuere pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jayave cuña oicuaa mbaeti ma ipuere oñemi Jesús güi. Jayave ou icotɨ orɨrɨi reve jare oyeatɨca Jesús jóvai. Jayave omombeu Jesús pe opaete vae jovaque maera oyavɨquɨ jemimonde jare quirai jupivei ocuera. ");
INSERT INTO guiNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jayave Jesús jei chupe: —Recuera ma, chereindɨ, rerovia cheré rambue. Ecua ndepɨacatu reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jare Jesús imiari oi rambueve, metei vae ou ovae tupao re oñangareco vae jo güi. —Omano ma nderayɨ —jei—. Agüɨye mo emambeco oporomboe vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Erei Jesús cuae oendu yave, jei tupao re oñangareco vae pe: —Agüɨye ndepɨatɨtɨ. Eporogüɨroviaño. Ocuerata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jare ojo ovae yave o pe, Jesús mbaeti omaeño iru reta re oique vaera jae ndive, jaeño Pedro, Jacobo, jare Juan, jare cuñatai tu jare ichɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jare opaete joco pe ñogüɨnoi vae reta oyaeo jare jase ñogüɨnoi. Jayave Jesús jei chupe reta: —Agüɨye peyaeo. Mbaeti co omano. Oqueño co oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Erei jae reta oyóyai. Echa oicuaa reta omano co. ");
INSERT INTO guiNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jayave Jesús oipɨɨ cuñatai ipo pe. —¡Cuñatai! ¡Epúa! —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jayave cuñatai oicove ye, jare jupivei opúa. Jayave Jesús oyócuai omongaru vaera cuñatai. ");
INSERT INTO guiNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jare cuñatai tu jare ichɨ ipɨacañɨ. Erei Jesús oyócuai reta agüɨye vaera omombeu quia pe mbae oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Metei ara Jesús oeni jocuae doce jemimboe reta jare omee chupe reta mbaepuere omondo vaera aña reta oya jese vae reta güi jare ombogüera vaera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jayave omondo reta omombeu vaera Tumpa iporoocuaia jare ombogüera vaera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jare jei chupe reta: —Agüɨye mbae peraja. Agüɨye peraja pepopoca. Agüɨye peraja peaporoca, perembiura, jare corepoti. Jare agüɨye pemonde mócoi camisa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Peo pevae yave metei o pe, joco pe pei jocuae tenta güi peo regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jare oime yave metei tenta pegua reta mbaeti oipota pepɨta vaera joco pe vae, peo joco güi yave, pemotumo ɨvɨtimbo pepɨ güi, jae reta oicuaa vaera teco güɨnoi co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jayave jae reta yogüɨraja tenta reta rupi. Omombeu reta iru vae reta pe ñee icavi vae jare opaete oguataa rupi ombogüera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jare mburuvicha guasu Herodes oendu opaete Jesús oyapo vae regua. Jayave ipɨacanɨ. Echa amogüe vae jei: —Juan oicove ye ma ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jare iru vae reta jei: —Jae co Elías ou ye vae. Jare iru vae reta jei: —Jae co metei Tumpa iñee aracae omombeu vae oicove ye ma ou omanogüe vae reta ipɨte güi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erei Herodes jei: —Aiñacasɨauca co Juan. Erei ¿quia ra co cuae? Echa aendu ma jeta jesegua —jei. Jae rambue Herodes oipota oecha Jesús. ");
INSERT INTO guiNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jare Jesús jemimondo reta yogüeru ye Jesús oia pe, jare omombeu Jesús pe opaete oyapogüe vae. Jayave Jesús güɨraja reta mbaeti quia oicoa pe coiño tenta Betsaida güi. ");
INSERT INTO guiNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Erei jeta vae oicuaa yave, yogüɨraja jaɨcue. Jare Jesús omboresive cavi jare imiari chupe reta Tumpa iporoocuaia re jare ombogüera imbaerasɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Caaru ma yave, jocuae doce vae yogüeru Jesús oia pe jare jei chupe: —Emondo cuae jeta vae, yogüɨraja vaera tenta reta oime coropi ñogüɨnoi vae pe, joco pe ocaru vaera jare oque vaera. Echa mbaeti quia oico cuae pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Erei Jesús jei chupe reta: —Pe reta pemee tocaru. —Jaeño oime rogüɨnoi cinco mbɨyape jare mócoi jevae ɨ rupigua —jei reta—. ¿Rojota ra rogua opaete cuae reta jembiura? ");
INSERT INTO guiNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Echa cuimbaegüeño oyepapa cinco mil rupi. Jayave Jesús jei jemimboe reta pe: —Toñemboatɨatɨ cincuenta rupi toguapɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jayave jocorai oyapo reta. Jei reta opaete joco pe ñogüɨnoi vae reta pe oguapɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jayave Jesús oipɨɨ jocuae cinco mbɨyape jare mócoi jevae ɨ rupigua, jare omae ara re, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape reta jare jevae ɨ rupigua reta, jare omee jemimboe reta pe, jae reta omee vaera opaete joco pe oguapɨ ñogüɨnoi vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Opareve ocaru, jare jɨvata. Jayave Jesús jemimboe reta omboatɨ tembíu oñepɨsaegüe jembɨre vae, jare omotɨnɨe doce canasta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Metei ara Jesús ojo jeta vae ipɨte güi oyerure vaera Tumpa pe. Jare jemimboe reta joco pe ñogüɨnoi jae ndive. Jayave Jesús oparandu chupe reta: —¿Quia pa co che iru vae reta pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jae reta jei chupe: —Amogüe vae jei nde co jae Juan oporombobautizase vae, jare iru vae reta jei nde co jae Elías, jare iru vae reta jei nde co jae metei Tumpa iñee aracae omombeu vae oicove ye ma ou omanogüe vae reta ipɨte güi vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jayave Jesús oparandu ye chupe reta: —Jare ¿quia pa co che peve? —jei. Jayave Pedro jei chupe: —Nde co jae Cristo. Tumpa nembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jayave Jesús oyócuai reta agüɨye vaera omombeu quia pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jayave Jesús jei chupe reta: —Che cuimbaera ayeapo vae aiporara yaeta. Jare judío reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta ngaraa oipota ayeapo vaera juvicha guasura, jare cheyucaucata. Erei mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jayave Jesús jei opaete vae pe: —Oime yave quia oipota ojo cherupíe vae, tiñacañɨ iyeugüi, tovoɨ togüɨraja icurusu ara ñavo, jare tojo cherupíe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Oipota oñovatu jecove vae ngaraa ipuere oñovatu. Erei omoeterengata jecove chereco pegua vae oñovatuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Mbae pa omonganata quia, omongana yave opaete ɨvɨ pegua, erei mbaeti yave ipuere oñovatu jecove? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oime yave quia imara imiari vaera cheré jare omombeu vaera cheñee vae, che cuimbaera ayeapo vae aromarata vi, ayu ye yave añemboeteuca vaera. Jae ramiño vi cheRu oñemboeteucata jare araɨgua oñeñono tee Tumpa peguara vae reta vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Erei añete che jae peve, ndei amogüe cuae pe ñogüɨnoi vae omano mbove, oecha retata Tumpa iporoocuaia —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jare ocho ara rupi cuae jei güire, Jesús güɨraja Pedro, Juan, jare Jacobo iru vae reta ipɨte güi, jare oyeupi metei ɨvɨtɨ re oyerure vaera Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jare Jesús oyerure Tumpa pe rambueve, jova oyepoepɨ jare jemimonde ti asɨ jare oesape. ");
INSERT INTO guiNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jare mócoi cuimbae imiari ñogüɨnoi Jesús ndive. Jae reta co Moisés jare Elías. ");
INSERT INTO guiNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mócoi reve ipora yae jare imiari Jesús pe Jesús imano re, quirai omanota co Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Erei Pedro jare jae ndive ñogüɨnoi vae jopeɨ yae jare oque vi. Erei oicove ye, jare oecha Jesús ipora yae, jare oecha vi jocuae mócoi cuimbae Jesús ndive oñemboɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jare Moisés jare Elías yogüɨraja yeta yave, Pedro jei Jesús pe: —Oporomboe vae, icavi co ñai vaera cuae pe. Toroyapo mboapɨ cuaraɨa yai pegua, metei ndeveguara, metei Moisés peguara, jare metei Elías peguara —jei. Echa Pedro mbaeti oicuaa mbae jei vae. ");
INSERT INTO guiNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jare Pedro cuae jei rambueve, ou amapɨtu omocuaraɨa reta. Jare jae reta oquɨye amapɨtu omocuaraɨa yave. ");
INSERT INTO guiNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jayave oñeendu ñee amapɨtu güi jei: —Cuae co jae cheRaɨ. Aaɨu yae. Peyeapɨsaca jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jare ñee opa ma yave, jae reta mbaeti oecha quia joco pe, jaeño Jesús. Jare jae reta mbaeti omombeu quia pe mbaembae oecha vae. ");
INSERT INTO guiNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jare pɨareve pe ɨvɨtɨ güi ogüeyɨ reta yave, jeta vae yogüeru oñoovaiti jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jayave metei cuimbae yatɨ vae reta ipɨte pe oi vae jei Jesús pe: —Oporomboe vae, ayerure ndeve remae vaera cheraɨ re. Jae co cheraɨ jae vaeño. ");
INSERT INTO guiNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Güɨramoiño metei aña oya jese jare ombosapúcai. Jayave omborɨrɨi yae jare cunumi iyuru tɨrɨyui. Jayave ombopere. Jecuaeño oyapo jocorai chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ayerure tei ma neremimboe reta pe omondo vaera chugüi aña, erei mbaeti ipuere —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jayave Jesús jei joco pe ñogüɨnoi vae reta pe: —Yavai yae pe reta cuae ɨvɨ pe peico vae peporogüɨrovia vaera. ¿Quirai regua ra apɨtata pe reta ndive? ¿Quirai regua ra cherosata peve? —jei. Jayave jei cunumi tu pe: —Eru nderaɨ cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jare cunumi ou rambueve, aña oitɨ jare omborɨrɨi yae. Jayave Jesús oñeengata aña pe. Jayave ombogüera cunumi jare omee ye tu pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jare opaete joco pe ñogüɨnoi vea reta ipɨacañɨ Tumpa imbaepuere tuicha vae re. Erei ipɨacañɨ rambueve opaete Jesús oyapogüe vae re, Jesús jei jemimboe reta pe: ");
INSERT INTO guiNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Peyeapɨsaca cavi cuae jae peve vae re. Echa che cuimbaera ayeapo vae metei vae chemoeterengata cherovaicho reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Erei jae reta mbaeti oicuaa mbae Jesús jei chupe reta vae, jare oipoɨu reta oparandu vaera chupe jese. ");
INSERT INTO guiNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jayave jae reta omboɨpɨ imiari oyoupe quia ra tenondegua iru reta güi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jare Jesús oicuaa iñemongueta reta. Jayave oeni metei michia jare oñono iyɨpɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jayave jei jemimboe reta pe: —Oime yave quia omboresive cuae nunga michia chereco pegua vae, che co chemboresive. Jare jocuae chemboresive vae omboresive vi co chembou vae. Echa pepɨte pe oi vae oñemomichi vae oicota tenondeguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jayave Juan jei Jesús pe: —Oporomboe vae, roecha metei cuimbae nderee re omondo aña reta oya jese vae reta güi, jare roe chupe agüɨye vaera mo oyapo. Echa jae mbaeti co ñaneiru —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Agüɨye pere chupe jocorai —jei Jesús chupe—. Echa mbaeti oyovaicho ñande ndive vae ñanemborɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jare outa ma ovae Jesús ojo ye vaera ara pe. Jae rambue iquɨreɨ yae ojo Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jayave omondo amogüe jemimboe reta jenonde. Jae reta yogüɨraja metei tenta ɨvɨ Samaria pegua pe oyapocavi vaera Jesús peguara. ");
INSERT INTO guiNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Erei jocuae tenta pegua reta mbaeti oipota Jesús opɨta vaera joco pe. Echa oicuaa reta jae ojo Jerusalén cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jare Jesús jemimboe reta Jacobo jare Juan cuae oicuaa yave, jei reta Jesús pe: —OreYa, ¿reipota pa ore royócuai tata ou vaera ara güi opa vaera oapɨ cuae tenta pegua reta Elías oyapo rami? ");
INSERT INTO guiNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Erei Jesús oyerova icotɨ jare oñeengata chupe reta. Jei chupe reta: —Agüɨye peñemongueta jocorai. ");
INSERT INTO guiNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Echa che cuimbaera ayeapo vae ayu aporomboasa vaera. Mbaeti ayu aporomocañɨtei vaera —jei. Jayave yogüɨraja iru tenta cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jare tape rupi oguata reta rambueve, metei cuimbae jei Jesús pe: —Taja nderupíe opaete que rupi reoa rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jayave Jesús jei chupe: —Aguara reta güɨnoi icua reta, jare güɨra reta güɨnoi jaitɨ reta. Erei che cuimbaera ayeapo vae mbaeti anoi cherora —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jare Jesús jei iru cuimbae pe: —Eyu cherupíe. Erei cuimbae jei: —Emaeño rani cheré aja vaera añotɨ cheru. ");
INSERT INTO guiNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jayave Jesús jei chupe: —Mbaeti tecove opa mbae vae güɨnoi vae reta toñotɨ omano vae reta. Ecua emombeu Tumpa iporoocuaia —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jayave iru cuimbae jei Jesús pe: —Taja nderupíe, cheYa. Erei emaeño rani cheré aja vaera cherenta pe amombeu vaera chupe reta jaema co aja —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Erei Jesús jei chupe: —Tamojaanga oara vae. Oara vae omae yave jaɨcue cotɨ, ngaraa isɨmbi ojo. Jae ramiño vi che amombaravɨquɨ yave quia, mbaeti yave oyapo cavi iparavɨquɨ, ngaraa icavi oico vaera Tumpa iporoocuaia pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cuae jaɨcue rupi ñandeYa oiparavo iru setenta cuimbae reta jare omondo jenonde mocomócoi pe opaete tenta reta jae ojota joco pe vae pe. ");
INSERT INTO guiNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jare jei chupe reta: —Jeta yae co yaarɨvo vaera. Erei mbovɨ yae co ombaarɨvo vae reta. Jae rambue pe reta peyerure ñandeYa pe omondo vaera oparavɨquɨ vae reta ombaarɨvo reta vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pecua. Mase, pomondo icavi mbae vae oyapo vae reta ipɨte rupi. Pe reta vecha-raɨ reta rami co. Jae reta aguarañaɨmba reta rami co —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Agüɨye peraja corepoti, jare peaporoca, jare pepɨapaa. Jare agüɨye pemiarieiño peñoovaiti yave tape rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jare peique yave metei o pe, pere rani: Tipɨacatu cuae o pegua reta —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jare oime yave quia jocuae o pe mbɨacatu oipota vae, jae ipɨacatuta co. Mbaeti yave, ngaraa ipɨacatu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jare pepɨta jocuae o pe etei. Peu oipotagüe omee peu vaera vae. Echa icavi co iru vae reta omboepɨ vaera oparavɨquɨ vae pe. Agüɨye cotɨcotɨ peyacavo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jare metei tenta pe peo pevae yave, tenta pegua reta pemboresive cavi yave, peu oipotagüe omee peu vaera vae —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pembogüera imbaerasɨ vae joco pe ñogüɨnoi vae reta. Jare pere chupe reta: Tumpa iporoocuaia oyearo ma peve —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Erei peo yave metei tenta pe, jocuae tenta pegua reta mbaeti yave oipota pepɨta vaera joco pe, peguata tenta rupi jare pere tenta pegua reta pe: ");
INSERT INTO guiNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Romotumo orepɨ güi ɨvɨtimbo, cuae tenta pegua reta peicuaa vaera pe reta co penoi teco. Erei toromombeu peve cuae: Tumpa iporoocuaia oyearo ma peve —pere, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Erei che jae peve, Tumpa ojaa yave ɨvɨ pegua reta, jocuae tenta pegua reta oiporara yaeta Sodoma pegua reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Corazín pegua reta oiporarata co. Betsaida pegua reta oiporarata co. Echa jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jocorai ayapo yave mona Tiro jare Sidón pe, Tiro jare Sidón pegua reta oeyata tei aracae ma iñemongueta icavi mbae vae ipɨa pe oi vae. Omondeta tei temimonde jaimbe vae jare oñonota tei tanimbu iñaca re oicuauca vaera ipɨatɨtɨ co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Erei Tumpa oporojaa yave, Corazín jare Betsaida pegua reta oiporara yaeta Tiro jare Sidón pegua reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jare Capernaum pegua reta oñemongueta tei icavi co yogüɨreco vaera Tumpa ndive. Erei Tumpa omondo retata yogüɨreco vaera cañɨtei pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oyeapɨsaca peré vae oyeapɨsaca co cheré. Erei pereroɨro vae chereroɨro co. Jare chereroɨro vae güɨroɨro chembou vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jare jocuae setenta vae reta yogüeru ye yave Jesús oia pe, oyerovia jare jei Jesus pe: —OreYa, nderee re rogüɨnoi mbaepuere aña reta re. ");
INSERT INTO guiNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jayave Jesús jei chupe reta: —Che aecha Satanás oa ara güi amavera rami. ");
INSERT INTO guiNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mase, amee ma peve mbaepuere pepuere vaera pepɨro mboi reta re jare tumɨcarape reta re, jare penoi vaera mbaepuere ñanderovaicho reta re, yepe tei jae reta vi güɨnoi mbaepuere. Mbaetita mbae ipuere oyapo peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Erei agüɨye peyerovia mbaepuere aña reta re penoi vae re. Erei peyerovia peree oñemboguapɨ ma ara pe rambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jocuae ora pe etei Jesús oyerovia jare jei: —Amee yasoropai ndeve, cheRu, quirai nde mbaeti remaeño cuae ɨvɨ pegua iyaracuaa vae reta re oicuaa vaera cuae mbaembae, erei reicuauca michia rami vae reta pe. Icavi co, cheRu. Echa icavi co ndeve reyapo vaera jocorai. Nde co jae ara pegua reta jare ɨvɨ pegua reta iYa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jayave jei ye: —CheRu omee ma cheve opaete. Mbaeti quia oicuaa cavi cheregua, jaeño cheRu. Jae ramiño vi mbaeti quia oicuaa cavi cheRu regua, jaeño che jare che aicuauca chupe vae. Che co jae cheRu Taɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jayave oyerova omae jemimboe reta re jare jei chupe retaño: —Tumpa pemovendise ma. Echa omaeño peré peecha vaera jeta mbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Che jae peve, jeta Tumpa iñee aracae omombeu vae reta jare mburuvicha guasu reta oipota tei oecha pe reta peecha vae. Erei jae reta mbaeti oecha. Jae ramiño vi oipota tei oendu pe reta peendu vae. Erei jae reta mbaeti oendu —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Metei ara metei mboroócuai re oporomboe vae oñemboɨ Jesús jóvai jare jei chupe: —Oporomboe vae, ¿mbae pa ayapota, anoi vaera tecove opa mbae vae? Oipota tei oyavɨuca Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jayave Jesús jei chupe: —¿Mbae pa oyecuatía oi mboroócuai pe? ¿Mbae pa remongueta joco pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jayave jei Jesús pe: —Oyecuatía oi corai: “Eaɨu ndeYa Tumpa opaete ndepɨa reve jare opaete nderecove reve jare opaete nepɨrata reve jare opaete neñemongueta reve. Jae ramiño vi eaɨu iru vae nde reyeaɨu rami”. Jocorai oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jayave Jesús jei chupe: —Icavi co rere. Corai eyapo jare renoita tecove opa mbae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mboroócuai re oporomboe vae oipota oicuauca jupi co jae. Jae rambue oparandu Jesús pe: —¿Quia pa co jae jocuae iru vae? ");
INSERT INTO guiNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jayave Jesús jei chupe: —Metei cuimbae ojo Jerusalén güi tenta Jericó cotɨ. Jare güɨramoiño imonda vae reta oipɨɨ. Jae reta omboi jemimonde jare ombopere. Oyuca rairai oeya reta tape pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jare güɨramoiño ou metei sacerdote jocuae tape rupi. Jare oecha yave cuimbae ipere vae, mbaeti etei oipota oya jese. Mombɨrɨ rupiño oasa chugüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jae ramiño vi ou metei levita jocuae tape rupi. Jare oecha yave cuimbae ipere vae, mbaeti etei oipota oya jese. Mombɨrɨ rupiño vi oasa chugüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Erei metei Samaria pegua ou jocuae tape rupi, jare ou ovae cuimbae ipere vae oia pe. Jare Samaria pegua oecha yave, oiparareco —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jayave oya jese jare oñono moa reta ipere reta ñogüɨnoia re jare oyasoi ipere reta lienzo pe. Jayave oupi imburica re jare güɨraja metei o pe, jare joco pe oñangareco jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jare pɨareve pe Samaria pegua ojota ma joco güi yave, oequi mócoi denario jare omee o iya pe. Jei chupe: Eñangareco jese. Jare jeta yae cuae güi remongata yave, amboepɨta ndeve ayu ye yave —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Añave taparandu ndeve: ¿Quia nunga pa co jae jocuae imonda vae reta oipɨɨ vae iñeiru? Echa mboapɨ cuimbae oasa jocoropi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jare mboroócuai re oporomboe vae jei Jesús pe: —Jocuae oiparareco vae. Jayave Jesús jei chupe: —Ecua eyapo jae oyapo rami. ");
INSERT INTO guiNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús jare jemimboe reta jecuae yogüɨraja Jerusalén cotɨ. Jayave yogüɨraja ovae metei tenta pe. Joco pe metei cuña Marta jee vae omboresive cavi jo pe Jesús. ");
INSERT INTO guiNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jare Marta ipɨquɨɨ jee co María. Jare María oguapɨ ñandeYa ipɨ iyɨpɨ pe oyeapɨsaca vaera jese. ");
INSERT INTO guiNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Erei Marta oñemambeco yae tembiura oyapo oi vae re. Jayave ou Jesús oia pe jare jei chupe: —CheYa, chepɨquɨɨ mbaeti chemborɨ. Jae rambue cheiño ayapo ai tembiura. ¿Icavi ra ndeve oyapo vaera corai? Eyócuai chemborɨ vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jayave ñandeYa jei chupe: —Marta, Marta, reñemambeco yae jeta mbaembae re. ");
INSERT INTO guiNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Erei mbaeti yaipota jeta mbaembae. Cuae María oiparavo vae icavi ndeve vi. Ngaraa quia ipuere oequi María güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jare metei ara Jesús oyerure oi Tumpa pe. Jare opa ma yave, metei jemimboe jei chupe: —CheYa, oremboe royerure vaera Tumpa pe Juan vi omboe jemimboe reta rami. ");
INSERT INTO guiNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jayave Jesús jei chupe reta: —Peyerure Tumpa pe yave, pere corai: OreRu ara pe oi vae, toñemboeteuca nderee. Tou ndeporoocuaia. Toyeapo neremimbota cuae ɨvɨ pe ara pe oyeapo oi rami. ");
INSERT INTO guiNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Emee oreve ara ñavo orerembiura. ");
INSERT INTO guiNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Neɨro oreve orembaeyoa reta re, ore oreɨro oipotagüe iyoa orecotɨ vae pe rami. Jare agüɨye emaeño aña guasu re imiari vaera oreve ore royapo vaera mbaeyoa. Orerepɨ aña guasu güi —pere, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jayave jei ye chupe reta: —Ñamojaanga metei cuimbae jare iamingo. Cuimbae ojo yave iamingo jo pe pɨare mbɨte rupi oyerure vaera chupe mbae re, güɨramoi jeita chupe: Amingo, eiporuca cheve mboapɨ mbɨyape. ");
INSERT INTO guiNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Echa metei cheamingo iguataa güi ou ma ovae chepɨri, jare mbaeti mbae anoi amee jou vaera. Güɨramoi jocoraita jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jare güɨramoi iamingo ombouta chupe iñee jo japɨpe güi: Agüɨye chemambeco. Echa oñeoquenda ma oi cheronque, jare che jare opaete chemichia reta roñeno ma roque vaera. Mbaeti ma chepuere apúa amee vaera ndeve. Güɨramoi jocoraita jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Che jae peve, yepe tei mbaeti oipota opúa, jocuae cuimbae co jae iamingo rambue, erei jocuae cuimbae jecuae oeni yave, opuata co omee vaera chupe opaete oipota vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jare che jae peve, peyerure Tumpa pe mbae re, jare Tumpa omeeta peve. Peeca, jare pevaeta. Pembopu onque, jare onque oyepeata peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Echa oyerure yave quia Tumpa pe mbae re, Tumpa omeeta chupe. Jare oeca yave quia mbae, ovaeta. Jare ombopu yave quia onque, onque oyepeata chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nde renoi yave metei nderaɨ, nderaɨ oyerure yave ndeve mbɨyape re, ngaraa remee chupe metei ita mbɨyape jecovia pe. Jae ramiño vi nderaɨ oyerure yave ndeve jevae ɨ rupigua re, ngaraa remee chupe metei mboi jevae ɨ rupigua jecovia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jae ramiño vi nderaɨ oyerure yave ndeve ururupía re, ngaraa remee chupe metei tumɨcarape ururupía jecovia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yepe tei pe reta jecuaeño peyapo icavi mbae vae, erei pemee co mbaembae icavi vae pemichia reta pe. Jae rambue peRu ara pe oi vae iquɨreɨ yae omee Espíritu Santo oyerure chupe jese vae reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Metei ara Jesús omondo aña metei cuimbae iupa vae güi. Jare aña ojo ma yave, cuimbae iñee. Jare jeta vae joco pe ñogüɨnoi vae ipɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Erei amogüe vae jei: —Aña guasu Beelzebú imbaepuere pe omondo aña reta oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jare iru vae reta oipota oicuaa mbae ra Jesús ipuere oyapo. Jae rambue jei reta Jesús pe oyeapo vaera mbae ara re jae reta oicuaa vaera quia co jae. ");
INSERT INTO guiNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Erei Jesús oicuaa iñemongueta, jare jei chupe reta: —Metei tenta pegua reta oyovaicho oyoupi yave, opata co jocuae tenta. Jae ramiño vi metei o pegua reta oyovaicho oyoupi yave, opata co jocuae o —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jae ramiño vi Satanás pochɨ iyeupe yave, opata co iporoocuaia. Echa pe reta pere che amondo aña reta oya jese vae reta güi aña guasu Beelzebú imbaepuere pe —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Erei che amondo yave aña reta oya jese vae reta güi Beelzebú imbaepuere pe, ¿quia imbaepuere pe ra omondo aña reta oya jese vae reta güi perentara reta? Pepuere peparandu chupe reta jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Erei che amondo aña reta oya jese vae reta güi Tumpa imbaepuere pe. Jae rambue pepuere peicuaa ou ma co peve Tumpa iporoocuaia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Metei cuimbae ipɨrata vae mboca güɨnoi vae oñangareco yave jo re, mbaeti quia ipuere opɨro chugüi imbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Erei ou yave iru cuimbae ipɨrata yae chugüi vae oñoraro vaera jae ndive, omoamɨrita co jare opɨrota chugüi imboca güɨrovia catu tei oyeepɨ vaera pɨpe vae. Jae ramiño vi opɨrota chugüi imbaembae omboyao vaera omee iñeiru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oime yave quia mbaeti oipota oico cheirura vae, oyovaicho co che ndive. Jae ramiño vi oime yave quia mbaeti chemborɨ vae, oyapo co icavi mbae vae checotɨ —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Metei aña ojo ma yave oya jese vae güi, oguata ñuu rupi oeca oicoara. Erei mbaeti yave ipuere ovae oicoara, jei iyeupe: Taja ye jocuae chero ayu chugüi vae pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Echa ñandepuere ñamojaanga metei o jocuae cuimbae aña ojo ma chugüi vae re. Aña ou ye ovae yave jocuae o pe, oecha o iya otupei ma jare oyapocavi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jayave ojo ye aña güeru siete aña icavi mbae yae chugüi vae reta jocuae o pe. Jayave ocho reve oique o pe, joco pe yogüɨreco vaera. Tenonde yave, metei aña oya jese yave, jocuae cuimbae oiporara. Erei taɨcue rupi ocho ma aña reta oya jese. Jae rambue oiporara yae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jare Jesús cuae mbaembae re imiari yave, metei cuña joco pe ñogüɨnoi vae reta ipɨte pe oi vae iñeeata reve jei: —Tumpa tomovendise ndesɨ. Echa nde rea co chugüi jare jae nemocambu —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Erei Jesús jei: —Añete co. Erei Tumpa omovendiseta opaete oyeapɨsaca iñee re vae reta, oyapo yave jeigüe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jare jeta yae vae yogüeru Jesús oia pe. Jayave Jesús jei chupe reta: —Añave yogüɨreco vae reta icavi mbae vae oyapo vae reta co. Jae reta oipota ayapo vaera mbae aicuauca vaera chupe reta quia co che. Erei jaeño oyeapota mbae Jonás pe oyeapo vae rami, jae reta oicuaa vaera quia co che —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Echa Jonás pe oyeapo vae oicuauca Nínive pegua reta pe Jonás jei chupe reta vae añete vae co. Jae ramiño vi oyeapota cheve vae oicuaucata añave yogüɨreco vae reta pe quia co che. Che co jae cuimbaera oyeapo vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tumpa oporojaa yave, ɨvɨtu yevɨ cotɨ pegua juvicha guasu cuña opuata omboeco vaera añave yogüɨreco vae reta. Echa jae ou mombɨrɨ ete güi oyeapɨsaca vaera Salomón iyaracuaa catu vae re. Erei che chearacuaa catu yae Salomón güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tumpa oporojaa yave, Nínive pegua reta opuata omboeco vaera añave yogüɨreco vae reta. Echa jae reta oeya iñemongueta icavi mbae vae ipɨa pe oi vae Jonás omombeu chupe reta yave Tumpa iñee. Erei chembaepuere tuicha yae co Jonás imbaepuere güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mechero ñamoendɨ yave, mbaeti etei ñañomi quiape. Mbaeti ñañono yapepo oñembovapɨ oi vae igüɨ pe. Ñañono co mechero jenda pe, o pe oique vae reta güɨnoi vaera tembipe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tembipe oique ñanderete pe ñanderesa rupi. Icavi yave nderesa, nderete tɨnɨeta tembipe pe. Erei icavi mbae yave nderesa, nderete tɨnɨeta pɨtumimbi pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jae rambue eñeandu agüɨye vaera nderete tɨnɨe pɨtumimbi pe. Echa tɨnɨeta tei tembipe pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nderete tɨnɨe yave tembipe pe, ngaraa oico joco pe pɨtumimbi. Opaete tɨnɨeta tembipe pe, metei tembipe tuicha vae nemboesape yave rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jare jocorai imiari ma yave Jesús, metei fariseo oparea chupe ocaru vaera jae ndive. Jayave Jesús ojo fariseo jo pe jare oguapɨ ocaru vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jare fariseo cuae oecha yave, ipɨacañɨ jese. Echa Jesús mbaeti oyepoe rani ndei ocaru mbove. ");
INSERT INTO guiNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jayave ñandeYa jei: —Pe reta co jae fariseo reta. Pe reta co jae taza jare ñae icupe rupiño oyeyoe vae rami. Erei pepɨa iquɨa yae co. Echa peipota iru vae reta imbaembae jare peyapo icavi mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pe reta co jae mbaeti iyaracuaa vae reta. Echa Tumpa oyapo opaete ñandepuere yaecha vae. Erei oyapo vi opaete mbaeti ñandepuere yaecha vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pemee pequɨreɨ reve mbaembae paravete vae reta pe. Cuae peyapo yave, peicuaucata iru vae reta pe iquɨa mbae co pepɨa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pe reta co jae fariseo reta. Peiporarata co. Echa pemee Tumpa pe diezmo caavo reta penoi vae güi. Erei mbaeti peyapo jupi co peyapo vaera vae, jare mbaeti peaɨu Tumpa. Icavi co pemee vaera Tumpa pe jocuae nunga diezmo. Erei peyapota tei jupi co peyapo vaera vae, jare peaɨuta tei Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pe reta co jae fariseo reta. Peiporarata co. Echa peipota yae peguapɨ tenda tenondegua vae reta pe tupao pe, jare iru vae reta oyapo vaera maraetei peve omaemee vae reta ñogüɨnoia rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pe reta co jae mboroócuai re oporomboe vae reta jare fariseo reta. Peiporarata co. Echa peporombotavɨñoi. Pe reta co jae teogüerɨru reta mbaeti quia oecha vae rami. Yepe tei iru vae reta opɨro jese reta, mbaeti oicuaa joco pe ñogüɨnoi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jayave metei mboroócuai re oporomboe vae jei Jesús pe: —Cuae añave rere vae rupi rere vi icavi mbae vae orecotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jayave Jesús jei: —Pe reta co jae mboroócuai re oporomboe vae reta. Pe reta vi peiporarata co. Echa pe reta pere iru vae reta pe oyapo vaera yavai yae oyapo vaera vae. Ñamojaanga metei voɨta. Pe reta pere iru vae reta pe ovoɨ vaera metei voɨta ipoɨ yae vae. Erei pe reta mbaeti etei pemborɨ ovoɨ vaera. Pe reta mbaeti etei peyavɨquɨ ivoɨta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Peiporarata co. Echa pe reta peyapo Tumpa iñee aracae omombeu vae reta iteogüerɨru reta. Jare petenondegua reta oyuca reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jocorai peicuauca petenondegua reta oyapo vae icaviño co peve. Echa jae reta oyuca reta, jare pe reta peyapo iteogüerɨru reta —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jocoraiño vi Tumpa iyaracuaa catu vae jei: Amondota peve cheñee omombeu vae reta jare cheremimondo reta, jare pe reta peyucata amogüe vae jare peyapota icavi mbae vae iru reta pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jare pe reta añave peico vae penoita teco opaete Tumpa iñee omombeu vae reta ɨvɨ oyeapo güive oyeyucauca vae imano re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tenonde voi Abel oyeyucauca, jare taɨcue rupi Zacarías oyeyucauca. Echa Zacarías omano maemɨmba oyeyucagüe oñererocuaveea jare Tumpa jo ipau pe. Añete che jae peve, cuae reta jare opaete iru vae reta imano re pe reta añave peico vae peñemboecota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pe reta co jae mboroócuai re oporomboe vae reta. Peiporarata co. Echa mbaeti pemboe iru vae reta oicuaa vaera Tumpa. Pe reta etei mbaeti peicuaa Tumpa. Iru vae reta oipota tei oicuaa Tumpa, erei pe reta peyopia agüɨye vaera oicuaa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jare jocorai imiari ma yave chupe reta, mboroócuai re oporomboe vae reta jare fariseo reta pochɨ yae chupe, jare omboɨpɨ oparandu chupe jeta mbaembae re. ");
INSERT INTO guiNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jecuaeño jae reta oyeapɨsaca cavi jese. Echa oipota tei oendu jei mbae ipuere omboeco jese vae. ");
INSERT INTO guiNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jare jeta yae vae oñemboatɨ Jesús oia pe, jare oñomoañaaña. Jayave Jesús jei jemimboe reta pe rani: —Peñeandu fariseo reta güi. Echa jae reta oporombotavɨ vae reta co. Jare tavɨ ipuere oñemoai levadura rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oime yave mbae oyeasoi vae, oyeechaucañotai co. Jae ramiño vi oime yave mbae oñemi vae, oyecuaañotai co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jae rambue pɨtumimbi pe pere vae oñeenduta tembipe pe, jare pero japɨpe pe pere vɨari vae jeracuata opaete vae oendu vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jare che jae peve, cherɨvɨ reta, agüɨye pequɨye oporoyuca vae reta güi. Echa oporoyuca güire, mbaeti ye mbae icavi mbae vae ipuere oyapo peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Erei tamombeu peve quia icavi co pequɨye vaera chugüi vae. Pequɨye Tumpa güi. Echa jae güɨnoi mbaepuere oporoyuca vaera jare oporomondo vaera cañɨtei pe. Añete che jae peve, pequɨye chugüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Peicuaa co quirai omaemee vae reta omee cinco güɨra-raɨ mbovɨ yae corepoti re. Erei Tumpa mbaeti iñacañɨ metei yepe güɨra-raɨ güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tumpa oicuaa mbovɨ pea penoi peaca re. Jae rambue agüɨye pequɨye. Echa Tumpa peraɨu yae jeta güɨra-raɨ güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jae ramiño vi che jae peve cuae: Oime yave quia iru vae reta jovaque chemboete vae, che cuimbaera ayeapo vae amboeteucata araɨgua Tumpa pe oyeócuai vae reta jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Erei oime yave quia iru vae reta jovaque checuacu vae, che vi aicuacuta araɨgua Tumpa pe oyeócuai vae reta jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jare oime yave quia jei icavi mbae vae che cuimbaera ayeapo vae cotɨ vae, Tumpa iñɨrota chupe jese. Erei oime yave quia jei icavi mbae vae Espíritu Santo cotɨ vae, Tumpa ngaraa iñɨro chupe jese —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jare iru vae reta pereraja yave pemoeterenga vaera tupao reta pe jare mburuvicha reta pe jare iru vae reta mbaepuere güɨnoi vae pe, agüɨye peñemambeco mbae pereta chupe reta vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Echa Espíritu Santo oicuaucata peve jocuae ora pe etei mbae pere vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jayave metei cuimbae jeta yae vae ipɨte pe oi vae jei Jesús pe: —Oporomboe vae, ere cherɨqueɨ pe omboyao vaera cheve oreru oeya vae. ");
INSERT INTO guiNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jayave Jesús jei chupe: —Cuimbae, che mbaeti co aporojaa jocuae nunga mbae re. Ngaraa amboyao peve nderu oeya vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jayave Jesús jei opaete vae pe: —Peñeandu agüɨye vaera peipota iru vae reta imbaembae. Echa mbaetita yaico cavi jeta mbaembae ñanoi vae jeco peguaño —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jayave jei ye chupe reta omojaanga reve: —Metei cuimbae oicocatu vae iyavati oñemee cavi. ");
INSERT INTO guiNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jare cuimbae jei iyeupe ipɨa pe: ¿Mbae ra ayapota? Mbaeti ma cheavati jendara —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jayave jei ye iyeupe ipɨa pe: Aicuaa ma. Amboaita cheavatío reta jare ayapota cheavatío retara tuicha yae vae, jare joco pe añovatuta opaete cheavati jare opaete aarɨvota vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jayave che jaeta cherecove pe corai: Cherecove, jeta yae ma mbaarɨvo reñovatu. Oupitɨta jeta año pegua. Eputuu, ecaru, ecau, jare eyerovia. Corai jaeta —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Erei Tumpa jei jocuae cuimbae pe: Nde co jae mbaeti iyaracuaa vae. Echa cuae pɨtu aequita nderecove ndegüi. Jare jayave ¿quia ra güɨnoita opaete jocuae mbaembae reñovatu ndeyeupeguara vae? —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jayave Jesús jei chupe reta: —Oime yave quia jeta mbaembae oñovatu iyeupeguara vae, mbaeti yave oicocatu Tumpa cotɨ, oyeapota chupe jocuae cuimbae oicocatu vae pe oyeapo rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jayave Jesús jei ye jemimboe reta pe: —Jae rambue che jae peve, agüɨye peñemambeco perembiura re. Jae ramiño vi agüɨye peñemambeco peremimondera re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngaraa pepuere peico cavi jecuaeño peñemambeco yave perembiura re, jare perete mbaeti oipota jeta temimonde ipora vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Peñemongueta güɨra reta re. Echa jae reta mbaeti omaetɨ jare mbaeti vi ombaarɨvo. Mbaeti vi güɨnoi avatío oñovatu vaera iyavati. Erei Tumpa omongaru reta. Jare Tumpa peraɨu yae güɨra reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Güɨramoi peñemambeco peipota tei pepucu rambue. Erei ngaraa etei pepuere peñembocuacuaa pepucu yae vaera peñemambeco jese rambue —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mbaeti etei mbae pepuere peyapo cuae re. Erei cuae mbaeti co yavai Tumpa pe. Jae rambue agüɨye peñemambeco iru mbaembae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Peñemongueta mbaepotɨ reta re, quirai ocuacuaa reta. Mbaeti oparavɨquɨ reta. Mbaeti omaepova reta. Erei che jae peve, mbaepotɨ reta ipora yae Salomón jemimonde ipora yae vae güi. ");
INSERT INTO guiNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tumpa omopora yae ñana, yepe tei metei ara ñana oi co pe jare pɨareve pe ócai. Jae rambue Tumpa omeeta co peve peremimondera. Michi co peporogüɨrovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Agüɨye peñemambeco perembiura re, jare agüɨye peñemambeco iru mbaembae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Echa opaete ɨvɨ pegua reta oñemambeco cuae mbaembae re. Jare peRu oicuaa icavi co penoi vaera cuae mbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Erei icavi co peipota yae vaera Tumpa iporoocuaia, jare Tumpa omeeta peve opaete cuae mbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Agüɨye pequɨye, yepe tei pe reta mbovɨ yae co. Echa Tumpa jemimbota co pe reta peico vaera iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pemee corepoti re pembaembae, jare pemee corepoti mbaembae oata chupe vae reta pe. Corai peyapo yave, penoita mbaembae ara pegua. Jae co peaporoca ara pe penoita vae rami. Jocuae nunga aporoca ngaraa etei indechi jare jocuae mbaembae icavi vae peaporoca ara pegua pe penoi vae ngaraa ocañɨ. Echa imonda vae ngaraa oya jese jare cupii reta ngaraa güɨrocomegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Echa peñovatu yave mbaembae icavi vae peyeupeguara ɨvɨ pe, jecuaeño peñemonguetata ɨvɨ pegua re. Erei peñovatu yave mbaembae icavi vae peyeupeguara ara pe, jecuaeño peñemonguetata ara pegua re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ñamojaanga peré tembiócuai reta. Tembiócuai reta iya ojo omenda vaera yave, tembiócuai reta oaro ñogüɨnoi iya ou ye rupi. Oñemocatɨro reta jare jecuaeño jendɨ imechero reta. Jare iya ou ye ovae yave ombopu onque, jupivei jembiócuai reta oipea onque iya ipuere vaera oique jo pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tembiócuai reta jecuaeño oaro ñogüɨnoi yave iya ou ye ovae yave, oyerovia retata. Añete che jae peve, iya omboyecuacuata toalla pe, jare jeita jembiócuai reta pe oguapɨ vaera mesa pe, jare iya etei omongaruta jembiócuai reta —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Güɨramoi iya ou yeta ovae pɨtu ma yave ani pɨare mbɨte rupi. Erei jae oecha yave jembiócuai reta oaro ñogüɨnoi, jae reta oyeroviata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aipota peicuaa vaera cuae: Metei o iya oicuaa yave mbae ora pe outa ovae imonda vae oñomi vaera mbaembae, oñemocatɨrota tei jare ngaraa tei omaeño imonda vae re güɨraja vaera imbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jae ramiño vi pe reta peñemocatɨro. Echa che cuimbaera ayeapo vae ayu yeta avae mbaeti peñemongueta pei jese yave —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jayave Pedro jei Jesús pe: —CheYa, cuae rere ma remojaanga reve. ¿Oreveguaraño pa co cuae? ani ¿opaete vae peguara pa? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jayave ñandeYa jei: —Metei tembiócuai iyaracuaa vae oyapo iya jei chupe oyapo vaera vae. Jare iya omee chupe oico vaera iru jembiócuai reta juvichara, jare omee vaera chupe reta jembiura ara ñavo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Iya ou ye ovae yave jo pe, oecha yave jocuae jembiócuai oyapo oi iparavɨquɨ, jocuae jembiócuai oyeroviata co —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Añete che jae peve, iya omeeta chupe oñangareco vaera opaete imbaembae re —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Erei güɨramoi tembiócuai jei iyeupe ipɨa pe: Cheya ngaraa ou ye raivi. Jare omboɨpɨ oinupa iru tembiócuai reta - cuimbae reta jare cuñatai reta - jare ocaru jare ocau jare osavaɨpo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jayave metei ara iya ou yeta ovae jembiócuai mbaeti oaro oi yave. Jayave iya oiporarauca yaeta chupe jare omondota oico vaera iya iporoócuai mbaeti oyapo vae reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Iya oiporarauca yaeta. Echa tembiócuai oicuaa tei iya iporoócuai, erei mbaeti oyapo —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Erei oime yave tembiócuai mbaeti oicuaa iya iporoócuai vae, yepe tei oiporarata co mbaeti oyapo iya iporoócuai rambue, erei iya ngaraa oiporarauca yae chupe. Echa iya oicuauca yave jembiócuai pe iporoócuai, icavi co jembiócuai oyapo vaera oicuaagüe rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Che ayu cuae ɨvɨ pe tata amoendɨ vaera, jare chequɨreɨ yae opa cheparavɨquɨ ayapo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Che aiporara yaeta co jare yavai yaeta cheve opa oyeapo regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Peñemongueta pa che ayu amee vaera mbɨacatu ɨvɨ pegua reta pe? Che jae peve, mbaeti co. Che ayu oñemboyao vaera oyougüi ɨvɨ pegua reta —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Echa añave güive yogüɨreco yave cinco metei o pe, oñemboyaota co oyougüi. Mboapɨ oyovaichota mócoi ndive, jare mócoi oyovaichota mboapɨ ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tu oyovaichota taɨ ndive, jare taɨ oyovaichota tu ndive. Ichɨ oyovaichota imembɨ cuña ndive, jare imembɨ cuña oyovaichota ichɨ ndive. Cuña imendɨ oyovaichota cuña ndive, jare cuña imembɨtatɨ oyovaichota cuña ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jare Jesús jei ye yatɨ vae reta pe: —Peecha yave amapɨtu oyeapo oi cuaraɨ oiquea cotɨ, jupivei pere: Oquɨta co. Jare jocorai oyeapo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jae ramiño vi ɨvɨtu guasu ou yave, pere: Aracuta co. Jare jocorai oyeapo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pe reta co jae oporombotavɨ vae reta. Echa ara jare ɨvɨ re pemae yave, peicuaa mbae oyeapota vae. Erei mbaeti etei peicuaa mbae añave oyeapo oi vae —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Maera pa peateɨ peicuaa mbae jupi peyapo vaera vae? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Reo yave oipota oñeapo nderé mbae re vae ndive ɨvɨraiya oia cotɨ, tape rupi peo rambueve eñemoicavi jae ndive, agüɨye vaera jae oñeapo nderé ɨvɨraiya pe. Echa ɨvɨraiya nemondota tembipɨɨrɨru iñangarecoa pe, jare tembipɨɨrɨru iñangarecoa neñonota tembipɨɨrɨru pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Che jae ndeve, ngaraa etei ree tembipɨɨrɨru güi ndei opaete ndepía remboepɨ mbove —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jare amogüe joco pe ñogüɨnoi vae reta omombeu Jesús pe quirai Pilato oyucauca amogüe Galilea pegua reta, jae reta maemɨmba oyeyucagüe reta güɨrocuavee Tumpa pe ñogüɨnoi rambueve. ");
INSERT INTO guiNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jayave Jesús jei chupe reta: —Güɨramoi pe reta peñemongueta jocorai oyeapo jocuae Galilea pegua reta pe, jae reta iyoa yae opaete iru Galilea pegua reta güi rambue. ");
INSERT INTO guiNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Che jae peve, mbaeti co. Jare mbaeti yave peeya peñemongueta icavi mbae vae pepɨa pe oi vae, pe reta vi pecañɨteita —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jare jocuae torre Siloé pe oise vae osururu jocuae dieciocho vae re jare oyuca reta. Güɨramoi pe reta peñemongueta jocuae dieciocho vae iyoa yae opaete iru Jerusalén pegua reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Che jae peve, mbaeti co. Jare mbaeti yave peeya peñemongueta icavi mbae vae pepɨa pe oi vae, pe reta vi pecañɨteita —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jayave Jesús jei ye chupe reta omojaanga reve: —Metei cuimbae güɨnoi ico pe metei ɨva. Ojo tei oeca ɨva ia. Mbaeti ovae chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jayave jei ico pe oparavɨquɨ chupe vae pe: Mase, mboapɨ año ma ayu tei aeca cuae ɨva ia jare mbaeti avae chupe. Eyasɨa. Ñañotɨta tei iru temitɨ jendagüe pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jayave co pe oparavɨquɨ vae jei co iya pe: Cheya, emaeño opɨta vaera cuae año pegua. Tayoo rani iyɨ́vɨri jare tañono vacarepoti iyɨ́vɨri —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jayave ia yave, icavita co. Erei mbaeti yave ia, ndepuereta reyasɨauca —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jare Jesús oporomboe oi metei judío reta itupao pe mbutuu iara pe. ");
INSERT INTO guiNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jare oecha joco pe metei cuña dieciocho año ma imbaerasɨ vae. Jecuaeño oñaɨvɨ yae. Mbaeti etei ipuere oñemboɨ cavi. ");
INSERT INTO guiNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jare Jesús oecha ma yave, jei chupe: —Eyu checotɨ, cuña. Recuera ma co nembaerasɨ güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jayave Jesús oñono ipo cuña iñaca re. Jare jupivei cuña ipuere oñemboɨ cavi jare omboɨpɨ omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jayave tupao re oñangareco vae pochɨ yae cuae re. Echa Jesús ombogüera cuña mbutuu iara pe. Jae rambue tupao re oñangareco vae jei joco pe ñogüɨnoi vae reta pe: —Icavi co yaparavɨquɨ vaera seis ara. Peyu jocuae seis ara pecuera vaera. Agüɨye peyu pecuera vaera mbutuu iara pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Erei ñandeYa jei chupe: —Pe reta co jae oporombotavɨ vae reta. Pe reta metei ñavo peyora pegüeye jare pemburica jenda güi mbutuu iara pe peraja vaera pemboɨu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mase, cuae cuña Abraham iñemoña reta pegua co. Erei Satanás dieciocho año ma omombaerasɨ. ¿Mbaeti pa icavi che ambogüera vaera cuae mbaerasɨ güi mbutuu iara pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jare cuae Jesús jei ma yave, opaete Jesús jovaicho reta imara. Echa opaete joco pe ñogüɨnoi vae reta oyerovia opaete Jesús oyapo vae re jare omboete Jesús. ");
INSERT INTO guiNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jayave Jesús jei: —¿Mbae ra ipuere oñemojaanga Tumpa iporoocuaia re? ¿Mbae ra amojaangata jese? ");
INSERT INTO guiNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ñandepuere ñamojaanga jese metei mostaza jaɨgüe —jei—. Oñeotɨ yave, ocuacuaa jare oyeapo ɨvɨra tuicha vae. Jare güɨra reta yogüeru oyapo jaitɨra jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jayave jei ye chupe reta: —¿Mbae ra amojaangata Tumpa iporoocuaia re? ");
INSERT INTO guiNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ñandepuere ñamojaanga jese levadura —jei—. Cuña omboyea levadura jeta catu trigo iachi ndive, levadura oñemoai vaera opaete achi rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jare Jesús ojo oguata opaete tenta tuicha vae reta jare tenta michi vae reta rupi, jare oporomboe joco pe. Jare jecuaeño ojo Jerusalén cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jayave metei vae oparandu Jesús pe: —CheYa, ¿oime pa mbovɨ catu oñemboasaucata vae? Jayave Jesús jei joco pe ñogüɨnoi vae reta pe: ");
INSERT INTO guiNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Peñemomɨrata peique vaera onque ipɨmí vae rupi. Echa che jae peve, jeta vae oipota teita oique, erei ngaraa ipuere —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Echa o iya oñoquenda ma yave onque, pe reta pepɨtata oca pe. Jayave pemboputa onque jare pereta: OreYa, eipea onque oreve. Erei jae jeita peve: Che mbaeti pocuaa —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jayave pereta: Rocaru nderovaque, jare nde reporomboe orerenta pe —pereta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Erei jae jeita peve: Che jae peve, che mbaeti pocuaa. Pe reta co jae icavi mbae vae oyapo vae reta. Pecua cuae güi —jeita peve, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jayave peyaeota jare perai pemboquɨrɨrɨuta. Echa peechata Abraham jare Isaac jare Jacob jare opaete Tumpa iñee aracae omombeu vae reta Tumpa iporoocuaia pe ñogüɨnoi. Erei pe reta icatu pe peita —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yogüeruta cuaraɨ oea cotɨ güi jare cuaraɨ oiquea cotɨ güi jare ɨvɨtu guasu cotɨ güi jare ɨvɨtu yevɨ cotɨ güi, jare oguapɨ retata Tumpa iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Erei pemaendúa cuae re: Amogüe añave oñemomichi vae oñemboeteucata co, jare amogüe añave oñemboete vae oñembotaɨcueucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jocuae ara yogüeru Jesús oia pe amogüe fariseo reta. Jae reta jei Jesús pe: —Ecua cuae güi. Echa Herodes oipota ndeyucauca. ");
INSERT INTO guiNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jayave Jesús jei chupe reta: —Herodes co jae metei aguara rami. Pecua ipɨri jare pemombeu chupe quirai jecuae amondota aña reta oya jese vae reta güi jare ambogüerata imbaerasɨ vae reta añave jare pɨareve. Jare coerambue opata co cheparavɨquɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Añete co, icavi co aparavɨquɨ vaera añave jare pɨareve jare coerambue. Echa Jerusalén peño judío reta oyuca Tumpa iñee omombeu vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén pegua reta, pe reta peyuca Tumpa iñee omombeu vae reta. Pe reta peyapi ita pe peyuca Tumpa ombou peve vae reta. Jeta vese ma chequɨreɨ tei pomboatɨ, uru omboatɨ imembɨ reta ipepo igüɨ pe rami, erei pe reta mbaeti peipota —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mase, perenta oñemboaita. Che jae peve, ngaraa ma cherecha pere regua: Toñemboeteuca ñandeYa jee re ou vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jare metei mbutuu iara pe Jesús ojo oique metei fariseo reta itenondegua jo pe ocaru vaera jae ndive. Jare fariseo reta omae ñogüɨnoi Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jare Jesús oecha joco pe metei cuimbae opaete jete iruru vae. ");
INSERT INTO guiNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jayave Jesús oparandu mboroócuai re oporomboe vae reta jare fariseo reta pe: —¿Jei pa mboroócuai ñandepuere ñambogüera quia mbutuu iara pe? ");
INSERT INTO guiNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Erei jae reta quiriiño. Jayave Jesús oñono ipo cuimbae imbaerasɨ vae re jare ombogüera. Jayave jei chupe ojo vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jayave Jesús jei ye joco pe ñogüɨnoi vae reta pe: —Pemburica ani pegüeye oasavi yave metei ɨvɨcua pe mbutuu iara pe, jupivei peo penoe joco güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jare joco pe ñogüɨnoi vae reta mbaeti mbae ipuere jei Jesús pe cuae regua. ");
INSERT INTO guiNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jayave Jesús oecha quirai opaete o iya oparea chupe vae reta oiparavo tenda icavi vae. Jayave jei chupe reta omojaanga reve: ");
INSERT INTO guiNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Metei cuimbae oparea ndeve yave mendaa pe, agüɨye eguapɨ tenda tenondegua vae pe. Echa güɨramoi o iya oparea vi iru omboete yae ndegüi vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jayave o iya güeruta jocuae iru vae reguapɨa pe jare jeita ndeve: Emee cuae cuimbae pe nerenda. Jayave nde nemarata co reo reguapɨ tenda taɨcuegua vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Erei o iya oparea ndeve yave, ecua eguapɨ tenda taɨcuegua vae pe. Echa ou yave o iya, güɨramoi jeita ndeve: Cheamingo, ecua eguapɨ metei tenda tenondegua vae pe. Jocorai reñemboeteucata opaete yogüeru ocaru vaera vae reta jovaque —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Echa oime yave quia oñemboete vae, oñemomichiucata co. Jare oime yave quia oñemomichi vae, oñemboeteucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jayave Jesús jei o iya pe: —Reipota yave reporomongaru, agüɨye eparea neamingo reta jare nerentara reta jare nerentaɨgua oicocatu vae reta pe. Echa chupe reta reparea yave, jae reta opareata ndeve nde reparea chupe reta rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Erei reipota yave reporomongaru, eparea paravete vae reta jare iporovaicho mbae vae reta jare icocho vae reta jare jesa mbae vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jocorai reyapo yave, Tumpa nemovendiseta. Echa jae reta ngaraa ipuere nemongaru. Erei Tumpa omboecoviata ndeve jupi vae reta oicove ye yave yogüeru omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jare metei jae ndive oguapɨ oi mesa pe vae cuae oendu yave, jei Jesús pe: —Tumpa iporoocuaia pe ocaruta vae oñemovendiseta co. ");
INSERT INTO guiNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jayave Jesús jei chupe: —Metei cuimbae oyapouca jeta tembíu jare oparea jeta vae pe ocaru vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tembíu oyɨ ma yave, omondo jembiócuai jei vaera oparea chupe vae reta pe: Peyu. Echa opaete oñemocatɨro ma —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Erei metei ñavo jei tembiócuai pe mbaeti co ipuere ojo. Metei vae jei chupe: Agua ma checora jare icavi co aja vaera amae jese. Jae rambue mbaeti chepuere aja. Ere ndeya pe iñɨro vaera cheve —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jare iru vae jei chupe: Agua ma diez güeye. Ajata amboporova reta. Jae rambue mbaeti chepuere aja. Ere ndeya pe iñɨro vaera cheve —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jare iru vae jei chupe: Amenda ramo ete. Jae rambue mbaeti chepuere aja —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jayave tembiócuai ou ye iya pɨri jare omombeu chupe opaete cuae regua. Jayave iya jei jembiócuai pe: Ecua voi opaete tape reta rupi jare eru cuae pe paravete vae reta jare iporovaicho mbae vae reta jare icocho vae reta jare jesa mbae vae reta —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Oyapo ma yave jocorai, tembiócuai jei iya pe: Cheya, ayapo ma ndeporoócuai, jare oime vɨteri iru vae reta jendara —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jayave iya jei jembiócuai pe: Ecua ye opaete tape reta rupi jare ere revae chupe vae reta pe yogüeru vaera, tɨnɨe vaera chero —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Echa che jae peve, mbaeti metei ave jocuae tenonde voi aparea chupe vae ocaruta chero pe —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jare jeta yae vae oñemboatɨ Jesús oia pe. Jayave Jesús omae jese reta jare jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Oime yave quia oipota ojo cherupíe vae, mbaeti yave cheraɨu yae tu jare ichɨ jare jembireco jare imichia reta jare jentara reta güi, jare oyeaɨu yae yave chegüi, ngaraa ipuere oico cheremimboera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jare oime yave quia mbaeti ovoɨ güɨraja icurusu ojo vaera cherupíe vae, ngaraa ipuere oico cheremimboera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Metei cuimbae iquɨreɨ yave oyapo torre, oguapɨta rani oipapa vaera mbovɨ ra jepɨta, oicuaa vaera icorepoti oupitɨta ra opa oyapo vaera —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Echa mbaeti yave oyapo jocorai, güɨramoi oñonota torre iguapɨara, erei ngaraa oupitɨ icorepoti opa oyapo vaera. Jae rambue opaete oecha vae reta oyoyaita jocuae cuimbae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Echa jei retata: Jocuae cuimbae omboɨpɨ tei oyapo torre, erei mbaeti ipuere opa oyapo —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jae ramiño vi metei mburuvicha guasu iquɨreɨ yave ojo oñoraro iru mburuvicha guasu ndive, oguapɨta rani oñemongueta cavi vaera jese, oicuaa vaera jocuae diez mil isundaro reta ipuereta ra omoamɨri jocuae veinte mil sundaro reta jovaicho güɨnoi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Echa oñemongueta yave isundaro reta ngaraa omoamɨri jovaicho isundaro reta, mombɨrɨ vɨteri jovaicho güi oi rambueve, omondota quia oyerure vaera chupe agüɨye vaera oñoraro jae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jae ramiño vi oime yave quia pepɨte pe opaete imbaembae mbaeti oeya vae, ngaraa ipuere oico cheremimboera —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yuquɨ icavi co yau vaera. Erei mbaeti ma yave jembochɨ, ¿Quiraita ra jembochɨ ye? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mbaeti ma mbaera icavi. Mbaeti yepe ɨvɨ peguara icavi. Ñamomboño. Ipuere oendu vae toyeapɨsaca cuae re —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jayave oñemboatɨ Jesús oia pe jeta mburuvicha peguara ocovara vae reta jare teco icavi mbae vae oyapo vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jayave fariseo reta jare mboroócuai re oporomboe vae reta iñeenguru jese. Jae reta jei: —Cuae cuimbae oñemoiru teco icavi mbae vae oyapo vae reta ndive, jare ocaru jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jayave Jesús jei chupe reta omojaanga reve: ");
INSERT INTO guiNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Metei cuimbae güɨnoi yave cien vecha reta, omocañɨ yave metei, oeya iru noventa y nueve ñuu pe jare ojo oeca ocañɨ vae ovae chupe rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jare ovae ma chupe yave, ovoɨ güeru ye iyatiɨ re oyerovia reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jare ou ye ovae yave jenta pe, omboatɨ opaete iamingo reta jare jentaɨgua reta, jare jei chupe reta: Peyerovia che ndive. Avae ma chevecha ocañɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Che jae peve, jae ramiño vi ara pegua reta oyerovia yaeta iyoa vae oeya yave iñemongueta icavi mbae vae ipɨa pe oi vae. Mbaetita jocorai oyerovia noventa y nueve jupi vae reta re. Echa jae reta mbaeti güɨnoi ñemongueta icavi mbae vae ipɨa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jae ramiño vi metei cuña güɨnoi yave diez corepoti, omocañɨ yave metei, omoendɨ mechero jare otupei opaete o rupi. Oeca cavi ovae chupe rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jare ovae ma chupe yave, omboatɨ opaete iaminga reta jare jentaɨgua reta, jare jei chupe reta: Peyerovia che ndive. Avae ma corepoti amocañɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Che jae peve, jae ramiño vi araɨgua Tumpa pe oyeócuai vae reta oyerovia yae iyoa vae oeya yave iñemongueta icavi mbae vae ipɨa pe oi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jayave Jesús jei ye chupe reta: —Metei cuimbae güɨnoi mócoi taɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jare taɨ taɨcuegua vae jei tu pe: Cheru, emee cheve añave voi mbaembae nde remano ma yave anoita vae —jei, jei—. Jayave tu omboyao imbaembae omee taɨ reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jayave mbovɨ ara rupi taɨ taɨcuegua vae omboatɨ opaete imbaembae jare ojo mombɨrɨ ambué ɨvɨ pe. Joco pe oyapo jeta arete jare jocorai omongata opaete icorepoti —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jare opa icorepoti omongata yave, ou caruai tuicha vae jocuae ɨvɨ pe, jare cuimbae mbaeti ma mbae güɨnoi jou vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jayave ojo oyerure metei jocuae tenta pegua pe omee vaera chupe mbaravɨquɨ. Jayave jocuae tenta pegua omondo cuimbae ico pe omongaru vaera cuchi reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jare cuimbae oipota tei oñemoɨvata ɨvope reta cuchi reta jou vae pe. Jare mbaeti quia omee chupe jou vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jare cuimbae oicuaa ma quirai oyapo mbaeti iyaracuaa vae oyapo rami. Jayave jei iyeupe ipɨa pe: Cheru omombaravɨquɨ vae reta jeta yae güɨnoi jou vaera. Erei che amanota ai ñɨmbɨaɨ güi —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Taja cuae güi cheru pɨri jare tae chupe: Cheru, cheyoa ma Tumpa cotɨ jare ndecotɨ vi. ");
INSERT INTO guiNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mbaeti ma jupi aico vaera nderaɨra. Emee cheve mbaravɨquɨ iru remombaravɨquɨ vae reta pe remee rami —jaeta, jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jayave ojo joco güi tu jenta cotɨ. Erei mombɨrɨ vɨteri oi rambueve, tu oecha jare oiparareco. Jayave tu osɨi oovaiti taɨ, jare oicuava jare oiyurupɨte —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jayave taɨ jei tu pe: Cheru, cheyoa ma Tumpa cotɨ jare ndecotɨ vi. Mbaeti ma jupi aico vaera nderaɨra —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Erei tu jei jembiócuai reta pe: Peru voi temimonde icavi yae vae pemondeuca chupe. Jae ramiño vi peñono moacavera ipoaca re jare mbɨapaa ipɨ re —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jare peru cuae pe vaca-raɨ amonguɨra vae peyuca. Yacaru jare yayapo arete —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Echa tenonde yave cuae cheraɨ metei omanogüe vae rami co cheve, erei añave oicove ye ma cheve. Tenonde yave ocañɨ chegüi, erei añave avae ye ma chupe —jei, jei—. Jare omboɨpɨ reta oyapo arete —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jare taɨ tenondegua vae oparavɨquɨ oi co pe. Jare ou ye ovae yave coiño o güi, oendu oñemimbɨ ñogüɨnoi o pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jayave oeni metei tu jembiócuai jare oparandu chupe mbae ra co jocuae oendu vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jayave tembiócuai jei chupe: Nderɨvɨ ou ye ma, jare nderu oyucauca vaca-raɨ omonguɨra vae, taɨ ou ye icavi ovae rambue —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jayave taɨ tenondegua vae pochɨ jare mbaeti oique o pe. Jayave tu oe o güi jare jei taɨ pe oique vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jayave taɨ tenondegua vae jei tu pe: Mase, jeta año ma ayeócuai ndeve. Jecuaeño ayapo ndeporoócuai. Erei mbaeti etei remee cheve cavara-raɨ yepe, ayapo vaera arete cheamingo reta ndive —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jare cuae nderaɨ oico cuña aguasa rupi oico vae reta ndive jare jocorai omongata opaete nde remee chupe vae. Erei jae ou ye ovae rupive, reyucauca chupe vaca-raɨ remonguɨra vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jayave tu jei taɨ tenondegua vae pe: Cheraɨ, jecuaeño nde reico che ndive, jare opaete chembae nembae co —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Icavi co arete yayapo vaera, jare yayerovia vaera. Echa tenonde yave cuae nderɨvɨ metei omanogüe vae rami co cheve, erei añave oicove ye ma cheve. Tenonde yave ocañɨ chegüi, erei añave avae ye ma chupe —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jare Jesús jei jemimboe reta pe: —Oico metei cuimbae oicocatu vae jare jembiócuai vi. Jeracua cuimbae pe quirai jembiócuai omongata imbaembae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jayave cuimbae oeni jembiócuai jare jei chupe: ¿Mbae pa co cuae nereracua cheve vae? Emombeu cheve mbae reyapo opaete chembaembae ndive vae. Echa romoeta co —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jayave tembiócuai jei iyeupe ipɨa pe: ¿Mbae ra ayapota? Echa cheya chemoeta. Mbaeti chepuere ayoo ɨvɨ corepoti amongana vaera. Mbaeti vi chepuere ayerure iru vae reta pe mbaembae re. Echa chemarata co —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aicuaa ma mbae ayapota vae. Corai ayapo yave, cheya chemoe ma yave, iru vae reta oñangarecota cheré —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jayave omondo omombeu vaera opaete iya pe mbae re ipía vae reta yogüeru vaera ipɨri. Jayave oparandu metei vae pe: ¿Mbovɨ pa ndepía cheya pe? —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Cien litro aceite —jei, jei—. Jayave tembiócuai jei chupe: Co oi ndetupapire. Eguapɨ voi jare eicuatía cincuenta litro —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jayave oparandu iru vae pe: ¿Mbovɨ pa ndepía cheya pe? —jei, jei—. Cien arroba trigo —jei, jei—. Jayave tembiócuai jei chupe: Co oi ndetupapire. Eicuatía ochenta arroba —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jare cuimbae oicocatu vae jei jembiócuai jupi mbae vae oyapo vae pe: Icavi yae reyapo ndeyeupe. Ndearacuaa co —jei, jei—. Echa cuae ɨvɨ pegua reta iyaracuaa yae corepoti re Tumpa pe oyeócuai vae reta güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jeta vese corepoti oyeporu icavi mbae vae oyeapo vaera. Erei che jae peve, peiporu pecorepoti peyapo vaera peamingo retara. Echa pemano yave, peeyata pecorepoti mbaeti peiporu vae. Erei peyapo yave peamingo retara, jae reta pemboresiveta perenta opa mbae vae pe —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oime yave quia ñandepuere yarovia catu mbae michi vae re vae, ñandepuere vi yarovia catu mbae tuicha vae re. Jae ramiño vi oime yave quia oporombotavɨ mbae michi vae re vae, oporombotavɨta vi mbae tuicha vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jae rambue mbaeti yave Tumpa ipuere pererovia catu corepoti re - echa jeta vese corepoti oyeporu icavi mbae vae oyeapo vaera - ngaraa vi pererovia catu mbaembae icavi vae ara pegua re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jare oime yave quia mbaeti ñandepuere yarovia catu iru vae icorepoti re vae, ngaraa ñamee chupe corepoti güɨnoi vaera iyeupeguara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Metei tembiócuai oipota yave oyeócuai mócoi iya pe, omotareɨta metei iya jare oaɨuta iru iya, ani oparavɨquɨ cavita metei iya pe jare güɨroɨrota iru iya. Mbaeti pepuere peyeócuai Tumpa pe corepoti peaɨu reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jare fariseo reta cuae oendu yave, oyóyai Jesús. Echa jae reta oipota yae corepoti. ");
INSERT INTO guiNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jayave Jesús jei chupe reta: —Pe reta peñembojupi iru vae reta jovaque. Erei Tumpa oicuaa pepɨa pe oi vae. Jare yepe tei iru vae reta pemboete yae, erei Tumpa oicuaa peyapo vae icavi mbae yae co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ndei Juan ou mbove, Tumpa omombeu ñandeve yayapo vaera mboroócuai jare Tumpa iñee aracae omombeu vae reta jeigüe. Erei Juan omboɨpɨ omombeu ñee icavi vae Tumpa iporoocuaia regua, jare opaete vae oipota yae oique Tumpa iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ara jare ɨvɨ opata. Erei mbaeti etei ñandepuere ñamboai mboroócuai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Oime yave quia omombo jembireco vae, güɨreco yave iru vae jembirecora, oñuvanga menda re. Jare oime yave quia oñemombo ma vae güɨreco vae, jae vi oñuvanga menda re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Oico metei cuimbae oicocatu vae temimonde ipora yae vae güɨnoi vae. Jecuaeño oñemonde cavi yae jare ara ñavo oyapo arete —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jare oico vi iru cuimbae Lázaro jee vae. Cuae cuimbae jecuaeño oyerure iru vae reta pe mbaembae re. Lázaro icaracha yae. Ara ñavo iru vae reta omoñeno Lázaro cuimbae oicocatu vae jonque jóvai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro oipota jou tembíu iperasoraso cuimbae oicocatu vae imesa güi oa vae. Jare ñaɨmba reta yogüeru oere Lázaro icaracha reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jare metei ara cuimbae jecuaeño oyerure iru vae reta pe mbaembae re vae omano, jare araɨgua reta güɨraja Abraham oia pe. Jae ramiño vi cuimbae oicocatu vae omano jare oñeotɨuca —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jare cañɨtei pe cuimbae oicocatuse vae oiporara yae oi. Jayave jovaɨva jare oecha Abraham mombɨrɨ oi chugüi. Oecha vi Lázaro Abraham ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jayave iñeeata reve jei: Cheru Abraham, cheparareco. Embou Lázaro oñono vaera ipoacaapɨ ɨ pe omoaquɨ vaera checu. Echa aiporara yae ai cuae tata pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Erei Abraham jei chupe: Cheraɨ, nemaendúa quirai nde reico ɨvɨ pe rambueve, nde renoi mbaembae icavi vae. Jae ramiño vi Lázaro oico ɨvɨ pe rambueve, mbaembae icavi mbae vae oyeapo chupe. Erei añave jae ipɨacatu oi jare nde reiporara rei —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jae ramiño vi oime ñanepau pe mbaeti etei ñandepuere yaasa vae. Jae rambue roipota yave rojo pepɨri, mbaeti orepuere. Jae ramiño vi peipota yave peyu orepɨri, mbaeti pepuere —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jayave cuimbae oicocatuse vae jei ye Abraham pe: Cuae jeco pegua ayerure ndeve, cheru, remondo vaera Lázaro cheru jenta pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Echa che oime anoi cinco cherɨvɨ. Emondo omombeu vaera chupe reta, agüɨye vaera jae reta vi yogüeru cuae roiporaraa pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jayave Abraham jei chupe: Oime güɨnoi Moisés iporoócuai jare Tumpa iñee aracae omombeu vae reta oicuatiagüe vae. Tomongueta reta jocuae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jayave cuimbae oicocatuse vae jei Abraham pe: Ngaraa omongueta reta, cheru Abraham. Erei oyecuaa yave chupe reta omanogüe vae, oeya retata iñemongueta icavi mbae vae ipɨa pe oi vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jayave Abraham jei ye chupe: Mbaeti yave oipota oyeapɨsaca Moisés iporoócuai jare Tumpa iñee aracae omombeu vae reta oicuatiagüe vae re, ngaraa oyapo Tumpa jei oyapo vaera vae yepe tei quia oicove ye ojo chupe reta omanogüe vae reta ipɨte güi —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jayave Jesús jei jemimboe reta pe: —Jecuaeño yogüɨrecota oporomboavai vae reta. Erei oporomboavai vae ñavo oiporarata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Icavita tei co iru vae reta oñapɨti vaera iyayu rupi metei ita tuicha vae ombaeso pɨpe vae jare omombo vaera ɨ guasu pe agüɨye vaera oyapouca tei metei cuae michia pe mbaeyoa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Peñeandu. Nderɨvɨ oyapo yave icavi mbae vae ndeve, neñeengueta chupe. Jare jae ipɨatɨtɨ yave jese, neɨro chupe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jare oyapo yave icavi mbae vae ndeve siete vese metei ara pe, jare jei yave ndeve siete vese jocuae ara pe ipɨatɨtɨ co jese, neɨro chupe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jayave ñandeYa jemimondo reta jei chupe: —Emombeu oreve quirai oreporogüɨrovia ipuere oñemoiru. ");
INSERT INTO guiNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jayave ñandeYa jei chupe reta: —Güɨramoi peporogüɨrovia michi yae metei mostaza jaɨgüe michi yae rami. Erei jocuae nunga mborogüɨrovia penoi yave, pepuereta pere cuae ɨvɨra sicómoro jee vae pe: Ecua cuae güi epɨta ɨ guasu pe, jare ɨvɨra oyapota peregüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Güɨramoi metei tembiócuai ojo co pe oara vaera ani omongaru vaera maemɨmba reta. Iparavɨquɨ opa ma oyapo yave, ou ye iya jo pe. Erei iya mbaeti etei jei chupe: Eyu eguapɨ cuae mesa pe ecaru. Mbaeti jocorai jei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Echa iya jei chupe: Ecua rani emboyɨ mbae jau vaera. Jayave eipoepɨ neremimonde reru vaera cheve cherembiura. Jare che opa ma acaru yave, ndepuereta recaru —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jare iya mbaeti etei omee yasoropai jembiócuai pe jembiócuai oyapo jeigüe rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jae ramiño vi pe reta peyapo ma yave opaete Tumpa jei peve peyapo vaera vae, pere peyeupe: Mbaeti mbae ayapo añemboeteuca vaera cheYa pe. Echa jaeño ayapo jupi ayapo vaera vae. Jocorai pere —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jare Jesús ojoñoi Jerusalén cotɨ. Jayave ojo ovae Samaria jare Galilea ipau pe. ");
INSERT INTO guiNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jare ojo metei tenta pe ovae, jare joco pe yogüeru Jesús cotɨ diez cuimbae ipire ocúi vae reta. Erei jae reta opɨta mombɨrɨ Jesús güi. ");
INSERT INTO guiNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jayave jae reta iñeeata reve jei Jesús pe: —Jesús, oporomboe vae, oreparareco. ");
INSERT INTO guiNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jare Jesús oecha reta yave, jei chupe reta: —Pecua sacerdote reta pɨri, jae reta omae vaera peré —jei. Jare yogüɨraja rambueve, güɨramoiño mbaeti ma ocúi ipire. ");
INSERT INTO guiNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jare metei cuimbae ou ye iru cuimbae reta ipɨte güi jare iñeeata reve jei: —Tumpa toñemboeteuca. Echa oicuaa ocuera ma co imbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jayave oyeatɨca Jesús jóvai jare omee yasoropai chupe. Jae co Samaria pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jayave Jesús jei: —Ambogüera diez cuimbae reta. Erei nueve mbaeti yogüeru ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cuae meteiño ou ye omboete vaera Tumpa. Jare cuae mbaeti co judío —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jayave jei cuimbae pe: —Epúa eñemboɨ jare ecua nerenta pe. Recuera ma, rerovia cheré rambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jare fariseo reta oparandu Jesús pe quirai yave ra oyecuaata Tumpa iporoocuaia. Jayave Jesús jei chupe reta: —Tumpa iporoocuaia ngaraa oyecuaa pe reta pesareco jese vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jae ramiño vi ngaraa quia jei: Mase, co oi, ani: Mase, pee oi. Echa Tumpa iporoocuaia pepɨte pe oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jayave Jesús jei jemimboe reta pe: —Outa ara reta peipota vaera tei cherecha - che cuimbaera ayeapo vae - metei ara yepe, erei ngaraa cherecha —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jayave iru vae reta jeita peve: Mase, co oi, ani: Mase, pee oi. Erei agüɨye pecua jae reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tamojaanga amavera. Amavera oyecuaa opaete ara re. Jae ramiño vi che cuimbaera ayeapo vae ayecuaata opaete vae pe ayu ye yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Erei aiporara yaeta rani jare añave yogüɨreco vae reta ngaraa oipota ayeapo vaera juvicha guasura —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Peicuaa co quirai ɨvɨ pegua reta oyapo icavi mbae vae Noé oico rambueve. Jae ramiño vi oyapo retata icavi mbae vae che cuimbaera ayeapo vae ayu yeta yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Echa Noé oico rambueve, ɨvɨ pegua reta ocaruñoi jare ocauñoi, jecuaeño cuimbae reta omenda cuñatai reta ndive jare tu reta omee tayɨ reta cuimbae reta pe omenda jae ndive vaera. Erei metei ara Noé oique jocuae buque pe. Jayave ou ɨporu guasu jare oyuca opaete vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jae ramiño vi Lot oico rambueve, Sodoma pegua reta ocaruñoi jare ocauñoi jare jecuaeño ogua mbaembae jare omee mbaembae, jare jecuaeño omaetɨ jare oyapo jo retara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Erei jocuae ara Lot oe Sodoma güi yave, Tumpa ombou tata jare azufre jare opa oyuca Sodoma pegua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jocoraita vi oyeapo che cuimbaera ayeapo vae ayecuaa yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jocuae ara oime yave metei cuimbae ovapɨa re oparavɨquɨ oi vae, ovapɨa güi ogüeyɨ yave, agüɨye toique jo pe güɨraja vaera imbaembae. Jae ramiño vi oime yave metei cuimbae co pe oparavɨquɨ oi vae, agüɨye tojo ye jo pe —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pemaendúa Lot jembireco pe oyeapo vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Oipota oñovatu jecove vae ngaraa ipuere oñovatu. Erei jocuae omoeterengata jecove vae oñovatuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Che jae peve, jocuae pɨtu mócoi vae oñenota ñogüɨnoi jupa pe. Tumpa güɨrajaucata metei vae jare iru vae opɨtata jupa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jae ramiño vi mócoi cuña reta ombaesota ñogüɨnoi. Tumpa güɨrajaucata metei cuña jare iru cuña opɨtata joco pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jae ramiño vi mócoi cuimbae reta oparavɨquɨta ñogüɨnoi co pe. Tumpa güɨrajaucata metei cuimbae jare iru cuimbae opɨtata co pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jayave Jesús jemimboe reta oparandu chupe: —OreYa, ¿quiape pa oyeapota cuae? Jayave Jesús jei chupe reta: —Omano vae jetegüe oia pe oñemboatɨta chucha reta. ");
INSERT INTO guiNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jare metei ara Jesús imiari ye jemimboe reta pe omojaanga reve. Oipota oicuauca chupe reta quirai icavi co jecuaeño oyerure vaera Tumpa pe jare agüɨye vaera icuérai chugüi. ");
INSERT INTO guiNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jae rambue jei chupe reta: —Oico metei tenta pe metei cuimbae oporojaa vae. Mbaeti oquɨye Tumpa güi jare güɨroɨro iru vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jae ramiño vi oico jocuae tenta pe metei cuña imemano vae. Metei ara cuña imemano vae ojo oporojaa vae pɨri jare jei chupe: Cherepɨ cherovaicho güi —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Oporojaa vae mbaeti mbae oyapo oepɨ vaera cuña. Erei mbovɨ ara rupi jei iyeupe ipɨa pe: Yepe tei mbaeti aquɨye Tumpa güi jare aroɨro iru vae reta, ");
INSERT INTO guiNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","erei cuae cuña imemano vae chemambeco rambue, aepɨta co. Echa mbaeti yave, jecuaeño outa chepɨri jare ngaraa omaeño aputuu —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jayave ñandeYa jei ye: —Jocorai co jei jocuae oporojaa vae jupi mbae vae oyapo vae. ");
INSERT INTO guiNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Erei Tumpa jupi co. Jae rambue oepɨta co oiparavo vae ara rupi jare pɨtu rupi oyerure chupe vae reta, yepe tei güɨramoi ngaraa oepɨ raivi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Che jae peve, ɨmambae Tumpa oepɨ retata. Erei che cuimbaera ayeapo vae ayu ye yave ɨvɨ pe, ¿oimeta ra ñogüɨnoi oporogüɨrovia vae reta? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jare Jesús oia pe ñogüɨnoi amogüe oñembojupi iñemongueta pe vae. Jae reta güɨroɨro iru vae reta. Jare Jesús jei chupe reta omojaanga reve: ");
INSERT INTO guiNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Mócoi cuimbae yogüɨraja Tumpa jo pe oyerure vaera Tumpa pe. Metei vae fariseo co jare iru vae mburuvicha peguara ocovara vae co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo oñemboɨ jare oyerure iyeupe ipɨa pe corai: Tumpa, amee yasoropai ndeve. Echa che mbaeti aico iru cuimbae reta yogüɨreco rami. Che mbaeti aporombotavɨ apɨro vaera quia güi imbaembae. Mbaeti ayapo jupi mbae vae. Mbaeti añuvanga menda re. Mbaeti vi ayapo jocuae mburuvicha peguara ocovara vae oyapo rami —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Che ayecuacu tembíu güi mócoi vese semana ñavo, jare amee ndeve diezmo opaete anoi vae güi —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jare mburuvicha peguara ocovara vae oñemboɨ mombɨrɨ fariseo güi, jare mbaeti oipota jovaɨva. Jaeño ocua iyee ipɨtía re jare jei: Tumpa, cheparareco. Echa che cheyoa co —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Che jae peve, Tumpa iñɨro mburuvicha peguara ocovara vae pe imbaeyoa reta re, jare jae ojo ye jenta pe. Erei mbaeti iñɨro fariseo pe imbaeyoa reta re. Echa oime yave quia oñemboete vae, oñemomichiucata co. Jare oime yave quia oñemomichi vae, oñemboeteucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jare amogüe vae güeru Jesús oia pe michia reta Jesús oñono vaera ipo jese reta. Erei Jesús jemimboe reta oecha reta yave, oñeengata güeru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Erei Jesús oeni michia reta jare jei jemimboe reta pe: —Pemaeño michia reta re yogüeru vaera che aia pe. Agüɨye peyopia. Echa cuae nunga oyeócuai Tumpa pe iporoocuaia pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Añete che jae peve, mbaeti yave peipota Tumpa peócuai vaera metei michia oipota rami, ngaraa peico Tumpa iporoocuaia pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jare metei mburuvicha jei Jesús pe: —Oporomboe vae, nde ndepɨacavi co. ¿Mbae pa ayapota, anoi vaera tecove opa mbae vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jayave Jesús jei chupe: —¿Maera pa rere cheve: Ndepɨacavi co? Mbaeti quia ipɨacavi, jaeño Tumpa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nde reicuaa co mboroócuai reta: “Agüɨye eñuvanga menda re. Agüɨye eporoyuca. Agüɨye nemonda. Agüɨye ndeapu iru vae re. Emboete nderu jare ndesɨ” —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Mbaeti ayavɨ metei ave cuae mboroócuai reta chemichi güive —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jare Jesús cuae oendu yave, jei chupe: —Oime mbae oata reyapo vaera. Emee opaete mbaembae renoi vae corepoti re, jare emee corepoti paravete vae reta pe, jare reicocatuta ara pe. Jayave eyu cherupíe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Erei mburuvicha cuae oendu yave, ipɨatɨtɨ yae. Echa oicocatu yae. ");
INSERT INTO guiNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jare Jesús oecha yave mburuvicha ipɨatɨtɨ opɨta, jei: —Yavai yaeta co oicocatu vae reta oique vaera Tumpa iporoocuaia pe. ");
INSERT INTO guiNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yavai yae oicocatu vae oique vaera Tumpa iporoocuaia pe, maemɨmba camello jee vae yuu mi jesacua rupi oasa vaera güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jayave cuae oendu vae reta jei: —Jocorai yave, ¿quia pa ipuere oñemboasauca? ");
INSERT INTO guiNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jayave Jesús jei chupe reta: —Ɨvɨ pegua reta mbaeti ipuere oñemboasa. Erei Tumpa ipuere oporomboasa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jayave Pedro jei Jesús pe: —Mase, ore opaete mbae roeya, royu vaera nderupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Añete che jae peve —jei Jesús—, oime yave quia oeya jo, ani tu, ani ichɨ, ani tɨqueɨ reta, ani tɨvɨ reta, ani jembireco, ani imichia reta Tumpa iporoocuaia jeco pegua vae, ");
INSERT INTO guiNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jeta yae jecoviata chupe ɨvɨ pe oico rambueve, jare taɨcue rupi Tumpa omeeta chupe tecove opa mbae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jayave Jesús oeni jocuae doce jemimboe reta, jare jei chupe reta: —Mase, yaja co Jerusalén cotɨ, jare opaete Tumpa iñee aracae omombeu vae reta oicuatiagüe cuimbaera oyeapo vae regua oyeapota co cheve —jei— ");
INSERT INTO guiNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Echa iru vae reta chemoeterengata judío mbae vae reta pe. Jare jae reta cheyoyaita, oyapota icavi mbae vae cheve, jare ondɨvɨta cheré —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jayave chenupata chicote pe jare cheyucata. Erei mboapɨ ara rupi aicove yeta ayu omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Erei Jesús jemimboe reta mbaeti oicuaa mbae ra oipota jei cuae Jesús jei chupe reta vae. Yavai yae chupe reta oicuaa vaera mbae jei vae. ");
INSERT INTO guiNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jare Jesús coiño ma ou Jericó güi yave, metei cuimbae jesa mbae vae oguapɨ oyerure oi tape jembeɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jae oendu jeta vae oasa ñogüɨnoi jocoropi, jare oparandu mbae ra oyeapo oi. ");
INSERT INTO guiNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jayave oasa vae reta omombeu chupe Jesús Nazaret pegua oasa co ojo. ");
INSERT INTO guiNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jayave jesa mbae vae iñeeata reve jei: —Cheparareco, Jesús. Nde co jae David Taɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jeta joco pe ñogüɨnoi vae reta oñeengata chupe. Oipota tei omoquirii. Erei jesa mbae vae jecuae iñeeata reve jei: —Nde co jae David Taɨ. Cheparareco —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jayave Jesús opɨta, jare jei joco pe ñogüɨnoi vae reta pe güeru vaera jesa mbae vae. Jare jesa mbae vae ou yave Jesús oia pe, Jesús oparandu chupe: ");
INSERT INTO guiNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mbae pa reipota ayapo vaera ndeve? —Tamae, cheYa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jayave Jesús jei chupe: —Emae. Recuera ma, rerovia cheré rambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jare jupivei ipuere omae, jare ojo Jesús jaɨcue omboete Tumpa reve. Jare opaete joco pe ñogüɨnoi vae reta vi cuae oecha yave, omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jare Jesús oique Jericó pe jare ojo ye joco güi. ");
INSERT INTO guiNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jare oico joco pe metei cuimbae Zaqueo jee vae. Jae co mburuvicha peguara ocovara vae reta itenondegua. Oicocatu co. ");
INSERT INTO guiNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jare Zaqueo oipota tei oecha Jesús. Erei mbaeti ipuere. Echa jeta yae vae ñogüɨnoi Jesús oasaa rupi, jare Zaqueo mbaeti co ipucu. ");
INSERT INTO guiNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jae rambue Zaqueo osɨi metei ɨvɨra sicómoro jee vae tape jembeɨ pe oi vae pe, jare oyeupi jese oecha vaera Jesús. Echa Jesús oasata jocoropi. ");
INSERT INTO guiNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jare Jesús ojo ovae yave ɨvɨra oia pe, jovaɨva jare oecha Zaqueo. Jayave jei chupe: —Egüeyɨ, Zaqueo. Echa añave aipota apou ndepɨri —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jayave Zaqueo ogüeyɨ voi, jare güɨraja Jesús jo pe oyerovia reve. ");
INSERT INTO guiNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jare opaete iru vae reta cuae oecha yave, iñeenguru. Jei reta: —Jae ojo opou metei cuimbae iyoa vae pɨri. ");
INSERT INTO guiNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Erei Zaqueo oñemboɨ ñandeYa jóvai jare jei chupe: —Mase, cheYa, ameeta chembaembae mbɨte rupi paravete vae reta pe. Jare oime yave quia apɨro mbae chugüi vae irundɨ ye ye amboecoviata chupe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jayave Jesús jei chupe: —Cuae ara ñemboasa ou cuae o pegua reta pe. Echa nde vi co jae Abraham iñemoña reta pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Echa che cuimbaera ayeapo vae ayu aeca vaera jare amboasa vaera ocañɨ Tumpa güi vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jare Jesús ndive ñogüɨnoi vae reta cuae oendu ma yave, Jesús imiari ye chupe reta omojaanga reve. Echa ojo ma ovae coiño Jerusalén güi, jare jae ndive ñogüɨnoi vae reta oñemongueta tei ɨmambae yae oyecuaata co Tumpa iporoocuaia. ");
INSERT INTO guiNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jae rambue Jesús jei chupe reta: —Metei mburuvicha ojota iɨvɨ ae güi ambué ɨvɨ mombɨrɨ oi vae pe oyeapo vaera iɨvɨ ae pegua reta juvicha guasura. Jare taɨcue rupi ou yeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jare ndei ojo mbove, oeni diez jembiócuai reta jare omee metei ñavo pe corepoti jepɨ yae vae, jare jei chupe reta: Peiporu cuae corepoti ayu ye regua —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Erei mburuvicha jentaɨgua reta omotareɨ mburuvicha, jare mburuvicha ojo ma yave ambué ɨvɨ pe, jae reta omondo jei vaera: Mbaeti roipota jocuae cuimbae oico vaera oreruvicha guasura —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Erei mburuvicha oyeapo jentaɨgua reta juvicha guasura. Jayave ou ye ovae iɨvɨ ae pe jare oyócuai jembiócuai corepoti omee chupe vae reta oñemboatɨ vaera ipɨri, jae oicuaa vaera mbovɨ ra metei ñavo omongana —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Metei jembiócuai jei chupe: Cheya, amombaravɨquɨ corepoti remee cheve vae, jare añave anoi diez corepoti —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jayave iya jei jocuae jembiócuai pe: Icavi reyapo. Nde co jae cherembiócuai icavi vae. Cuae amee ndeve vae michi yae. Erei remombaravɨquɨ cavi. Jae rambue che toroñono diez tenta pegua reta juvichara —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jayave iru jembiócuai jei chupe: Cheya, amombaravɨquɨ corepoti remee cheve vae, jare añave anoi cinco corepoti —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jayave iya jei jocuae jembiócuai pe: Icavi reyapo. Che toroñono cinco tenta pegua reta juvichara —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jayave iru jembiócuai jei chupe: Mase, cheya, co oi corepoti remee cheve vae. Ayapɨcua añovatu ndeve —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Echa aquɨye ndegüi ndepɨapochɨ rambue. Nde repɨro mbaembae iru vae reta güi jare rearɨvo iru vae reta oñotɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jayave iya jei jocuae jembiócuai pe: Nde rere vae rupi etei che rojaata co. Nde co jae cherembiócuai icavi mbae vae. Reicuaa chepɨapochɨ co jare quirai apɨro mbaembae iru vae reta güi jare quirai aarɨvo iru vae reta oñotɨ vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Maera pa mbaeti reraja checorepoti banco pe? Echa jocorai reyapo yave, ayu ye yave remeeta tei co cheve corepoti amee ndeve vae jare mbovɨ ye banco pegua reta omoiruta tei jae ndive vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jayave iya jei iru jembiócuai joco pe ñogüɨnoi vae reta pe: Pepɨro chugüi jocuae corepoti jare pemee diez corepoti güɨnoi vae pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Erei jae reta jei iya pe: Oreya, jae güɨnoi ma diez corepoti. ");
INSERT INTO guiNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Añete co —jei iya chupe reta, jei—. Erei che jae peve, güɨnoi vae pe oñemoiruta, jare mbaeti güɨnoi vae güi michi yae güɨnoi vae oyeequita —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Erei peru cuae pe jocuae cherovaicho reta. Jae reta mbaeti oipota che aico vaera juvicha guasura. Peyuca cherovaque —jei, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jare Jesús cuae jei ma chupe reta yave, oguata ye iru vae reta jenonde ojo Jerusalén cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jare yogüɨraja ovae coiño tenta reta Betfagé jare Betania güi. Joco pe oi ɨvɨtɨ Oliva. Jayave Jesús oyócuai mócoi jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Pecua pea tenta ñanderóvai oi vae pe —jei chupe reta—. Peo pevae rupive, pevaeta metei mburica mi taɨrusu vae oñeapɨti oi. Mbaeti etei vɨteri quia opo jese. Peyora jare peru —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jare oime yave quia jei peve vae: ¿Maera pa peyora? pere chupe corai: ÑandeYa oipota oiporu —pere, jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jayave Jesús omondo vae reta yogüɨraja, jare ovae mburica mi taɨrusu vae Jesús omombeu chupe reta rami. ");
INSERT INTO guiNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jare oyora ñogüɨnoi yave, mburica mi iya reta oparandu chupe reta: —¿Maera pa peyora pei mburica mi? ");
INSERT INTO guiNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—ÑandeYa oipota oiporu —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jayave güeru reta mburica mi taɨrusu vae Jesús oia pe. Jayave Jesús jemimboe reta oñono iyasoya mburica mi icupe re, jare Jesús opo jese. ");
INSERT INTO guiNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jare Jesús ojo rambueve Jerusalén cotɨ, joco pe ñogüɨnoi vae reta oipɨso iyasoya tape rupi mburica mi jenonde. ");
INSERT INTO guiNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jare omboɨpɨ reta ogüeyɨ ɨvɨtɨ Oliva güi. Coiño ma yogüeru Jerusalén güi. Jayave opaete Jesús jemimboe reta omboɨpɨ oyerovia. Omboete reta Tumpa iñeeata reve opaete mɨacañɨ oecha Jesús oyapo vae reta re. ");
INSERT INTO guiNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jare jei reta: —Toñemboeteuca ñanderuvicha guasura ñandeYa jee re ou vae. Mbɨacatu toi ara pe. Ara pegua reta tomboete Tumpa —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jare amogüe fariseo reta jeta yae vae ipɨte pe ñogüɨnoi vae jei Jesús pe: —Oporomboe vae, eñeengata neremimboe reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Erei Jesús jei chupe reta: —Che jae peve, cuae reta quirii yave, jupiveiño ita reta imiarita iñeeata reve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jare Jesús coiño ma Jerusalén güi ou ovae yave, omae Jerusalén re jare omboɨpɨ oyaeo. ");
INSERT INTO guiNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jare jei: —Mbaeti reicuaa quirai ra ndepuere renoi mbɨacatu. Cuae ara reta pe reicuaata tei co. Erei añave ngaraa reicuaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Outa ma ovae nderovaicho reta nequese vaera jare ngaraa omaeño nderapɨpe pe yogüɨreco vae reta re oe vaera ndegüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jare jae reta opata nembosururu jare oyucata opaete nderapɨpe pe yogüɨreco vae reta. Ngaraa oeya reta metei ita iru ita iárambue, mbaeti reicuaa Tumpa omeeta tei mbɨacatu ndeve rambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jayave Jesús oique Tumpa jo pe jare omboɨpɨ omoe joco güi omaemee vae reta jare ombaegua vae reta. ");
INSERT INTO guiNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jare jei chupe reta: —Tumpa iñee pe oyecuatía oi corai: “Chero co jae peyerure cheve pɨpe vae”. Jocorai oyecuatía oi. Erei pe reta peyapo ma imonda vae reta oñemia rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jayave Jesús oporomboe Tumpa jo pe ara ñavo. Erei sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta jare tenta pegua reta itenondegua reta oeca quirai ipuere oyucauca Jesús. ");
INSERT INTO guiNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Erei mbaeti oicuaa reta quiraita ra oyucauca. Echa opaete tenta pegua reta oipota yae oyeapɨsaca Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jare metei ara Jesús oporomboe oi Tumpa jo pe, jare omombeu joco pe ñogüɨnoi vae reta pe ñee icavi vae. Jayave yogüeru vi joco pe sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta jare tenta pegua reta itenondegua reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jayave jae reta jei Jesús pe: —Emombeu oreve, ¿mbae nunga mbaepuere pa renoi cuae mbaembae reyapo vaera? ¿Quia pa omee ndeve mbaepuere cuae reyapo vaera? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jayave Jesús jei chupe reta: —Che vi taparandu peve mbae re. Yaecha pepuere pemombeu cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Quia pa ombou Juan oporombobautiza vaera? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jayave jae reta jei oyoupe: —Yae yave: Tumpa co ombou, jae jeita ñandeve: Jocorai yave, ¿maera pa mbaeti perovia? ");
INSERT INTO guiNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Erei yae yave: Ɨvɨ pegua reta co ombou, opaete tenta pegua reta ñandeapita ita pe ñandeyuca. Echa jae reta güɨrovia Juan co jae metei Tumpa iñee omombeu vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jae rambue jei reta Jesús pe: —Mbaeti roicuaa quia ra ombou Juan. ");
INSERT INTO guiNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jayave Jesús jei ye chupe reta: —Che vi ngaraa amombeu peve mbae nunga mbaepuere anoi cuae mbaembae ayapo vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jayave Jesús omboɨpɨ ye imiari joco pe ñogüɨnoi vae reta pe omojaanga reve. —Metei cuimbae oñotɨ jeta uva ico pe. Jayave oiporuca ico iru vae reta pe, jae reta oñangareco vaera jese. Jayave co iya ojo mombɨrɨ ambué ɨvɨ pe opɨta vaera ɨma pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jare uva yagüɨye ma yave, co iya ombou metei jembiócuai co iporúa reta pe, jae reta omboyao vaera tei uva reta, iya güɨnoi vaera imbaera. Erei co iporúa reta oinupa co iya jembiócuai jare omondo ye. Mbaeti mbae omee chupe güɨraja vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jayave co iya ombou ye tei iru jembiócuai. Erei co iporúa reta oinupa jare oyapo icavi mbae vae chupe jare omondo ye. Mbaeti mbae omee chupe güɨraja vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jayave co iya ombou ye tei iru jembiócuai. Erei co iporúa reta ombopere jare omondo ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jayave co iya jei iyeupe: ¿Mbae ra ayapota? Amondota cheraɨ aaɨu yae vae. Güɨramoi jae reta omboeteta cheraɨ —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Erei co iporúa reta oecha yave co iya taɨ, jei reta oyoupe: Cuae co jae iyara vae. Yaja yayuca, jare ñande yaicota co iya retara —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jayave jae reta oyuca omombo co güi. Jae rambue ¿mbae ra oyapota co iya jocuae co iporúa reta pe? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Outa, opa oyuca vaera jocuae co iporúa reta, jare oiporucata ico ambué vae reta pe —jei. Jayave cuae oendu vae reta jei: —Tumpa mona oipota agüɨye oyeapo. ");
INSERT INTO guiNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jayave Jesús omae jese reta jare jei: —¿Mbae ra oipota jei cuae Tumpa iñee pe oyecuatía oi vae? Ita o iyapoa reta omombo vae oyeapo ma ita tenondegua vae. ");
INSERT INTO guiNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oime yave quia jocuae ita re oñetinga vae, oñemopeta co. Jare oime yave quia jocuae ita oa jese vae, ita opata omboperasoraso —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jayave jupivei sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oipota tei oipɨɨ Jesús. Echa oicuaa cuae Jesús omojaanga reve jei vae oicuauca quirai jae reta teco güɨnoi. Erei oquɨye tenta pegua reta güi. ");
INSERT INTO guiNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jare jecuaeño jae reta omae Jesús re. Jare omondo vi iru vae reta oipiaro vaera Jesús. Cuae reta oipota tei ombotavɨ Jesús, Jesús oñemongueta vaera tei jae reta jupi co. Erei jae reta oipota tei omboeco mbae jei vae re, oñeapo vaera jese mburuvicha pe. ");
INSERT INTO guiNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jayave jae reta jei Jesús pe: —Oporomboe vae, roicuaa nde rere vae jare reporomboe jese vae añete co. Nde mbaeti remboete metei vae iru vae güi. Nde reporomboe cavi quirai Tumpa oipota yaico vaera vae re —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","César ñandeócuai ñamboepɨ vaera chupe corepoti pe. ¿Jupi pa ñamboepɨ vaera chupe? ani ¿mbaeti pa jupi? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Erei Jesús oicuaa jae reta oipota co ombotavɨ, jare jei chupe reta: —¿Maera pa peipota peyavɨuca cheve? ");
INSERT INTO guiNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Peru cheve metei denario taecha —jei—. ¿Quia iagüe pa cuae? ¿Quia jee pa cuae oyecuatía oi vae? —jei. —Cuae César imbae co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jayave Jesús jei chupe reta: —Pemee César pe César pegua, jare pemee Tumpa pe Tumpa pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jare jae reta mbaeti ipuere omboeco Jesús mbae jei vae re tenta pegua reta jovaque. Ipɨacañɨ cuae jei vae re, jare mbaeti ye mbae jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jayave yogüeru Jesús oia pe amogüe saduceo reta. Opaete saduceo reta jei omanogüe vae reta mbaeti co oicove ye. Saduceo yogüeru vae reta jei Jesús pe: ");
INSERT INTO guiNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Oporomboe vae, Moisés oicuatía oeya oreve corai: “Metei cuimbae tɨvɨ güɨnoi vae omano yave, jembirecogüe mbaeti yave imembɨ chupe, cuimbae tɨvɨgüe tomenda jocuae cuña ndive. Jayave cuña imembɨ yave, cuimbae tombojee michia tɨqueɨ amɨri jee pe”. Jocorai oicuatía Moisés —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oico metei cuimbae seis tɨvɨ reta güɨnoi vae. Cuae cuimbae omenda, jare omano mbaeti omomembɨ reve. ");
INSERT INTO guiNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Cuimbae amɨri jaɨcuerigua omenda jembirecogüe ndive, erei omano vi mbaeti omomembɨ reve. ");
INSERT INTO guiNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jayave jaɨcuerigua ye omenda cuña ndive, jare omano vi mbaeti omomembɨ reve. Opaete siete reve omenda cuae cuña ndive, jare opaete siete reve omano mbaeti omomembɨ reve —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Taɨcue rupi cuña vi omano. ");
INSERT INTO guiNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jayave omanogüe vae reta oicove ye yave, ¿quia nunga vae jembirecora pa oicota cuae cuña? Echa opaete siete reve omenda cuae cuña ndive —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jayave Jesús jei chupe reta: —Cuae ɨvɨ pe yogüɨreco rambueveño cuimbae reta omenda cuña reta ndive jare cuña reta omenda cuimbae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Erei icavita co Tumpa pe omoingove ye vaera amogüe vae güeru omanogüe vae reta ipɨte güi. Jae reta yogüɨreco yeta co, erei cuimbae reta ngaraa omenda cuña reta ndive jare cuña reta ngaraa omenda cuimbae reta ndive oicove reta ye yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jae ramiño vi ngaraa omano ye. Echa yogüɨrecota araɨgua reta yogüɨreco rami. Yogüɨrecota Tumpa taɨ retara. Echa Tumpa omoingove yeta güeru omanogüe vae reta ipɨte güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tamombeu peve omanogüe vae reta regua. Oicove yeta co. Moisés oicuauca cuae oicuatía yave jocuae yai regua. Echa Moisés omombeu quirai ñandeYa Tumpa jei: “Che co jae Abraham, Isaac, jare Jacob iTumpa”. Cuae omombeu Moisés —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Echa Tumpa mbaeti co omanogüe vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa. Jare opaete vae oicove ñogüɨnoi Tumpa oñemboeteuca vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jayave amogüe mboroócuai re oporomboe vae reta jei Jesús pe: —Oporomboe vae, icavi rere. ");
INSERT INTO guiNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jare jocuae güive oquɨye reta oparandu vaera chupe mbae re. ");
INSERT INTO guiNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jayave Jesús oparandu joco pe ñogüɨnoi vae reta pe: —¿Maera pa jei mboroócuai re oporomboe vae reta Cristo co jae David Taɨ? ");
INSERT INTO guiNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Echa David etei jei Salmo reta pe corai: ÑandeYa Tumpa jei cheYa pe: Eguapɨ cheɨque pe cheacatu cotɨ, ");
INSERT INTO guiNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nderovaicho reta opa añono ndepɨ igüɨ pe regua —jei Tumpa. Jocorai jei David —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Maera pa jei reta Cristo co jae David Taɨ? Echa David etei jei chupe: CheYa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jayave Jesús jei jemimboe reta pe opaete joco pe ñogüɨnoi vae reta jovaque: ");
INSERT INTO guiNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Peñeandu mboroócuai re oporomboe vae reta güi. Jae reta jecuaeño oipota oguata jemimonde ipucu vae reve, jare iru vae reta oyapo vaera maraetei chupe reta omaemee vae reta ñogüɨnoia rupi. Jare yogüɨraja yave tupao pe jare aretea pe, jecuaeño oipota yae oguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jae reta opɨro cuña imemano vae reta güi opaete imbaembae, jare ipucu yae oyerure Tumpa pe oporombotavɨ vaera. Jae reta oiporara yaeta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jare Jesús Tumpa jo pe oi yave, oecha oicocatu vae reta oitɨ icorepoti corepoti jɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jare oecha vi metei cuña imemano vae paravete vae oitɨ mócoi reare corepoti jɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jayave Jesús jei: —Añete che jae peve, cuae cuña imemano vae paravete vae oyapo jeta yae opaete iru oitɨ vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Echa opaete iru reta güeru oitɨ mbovɨ jeta güɨnoi vae güi. Erei cuae cuña, yepe tei paravete yae, erei oitɨ opaete güɨnoi vae. Jocuae co jembíu jepɨra tei vae —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jare amogüe vae imiari ñogüɨnoi Tumpa jo re. Jei reta icavi yae co ita reta jare mbaembae tenta pegua reta güeru omopora vaera vae. Jayave Jesús jei: ");
INSERT INTO guiNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Outa co ovae ara reta cuae o reta añave peecha vae oyeitɨ vaera. Ngaraa opɨta metei ave ita iru ita iárambue —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jayave Jesús jemimboe reta oparandu chupe: —Oporomboe vae, ¿quirai yave pa cuae oyeapota? Jare opaete cuae oyeapota ma yave, ¿quiraita pa roicuaa? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jayave Jesús jei chupe reta: —Peñeandu agüɨye vaera petavɨ. Echa yogüeruta jeta cheree pe oñembojeeta vae. Jae reta jeita: Che co jae Cristo. Outa co ovae jocuae ara reta —jeita, jei—. Erei agüɨye peñemoiru jae reta ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Oimeta ñoraro reta jare tecorai reta. Erei peendu yave cuae reta regua, agüɨye pequɨye. Cuae susere reta oyeapota co. Erei cuae susere reta mbaetita co taɨcuegua vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Metei ɨvɨ pegua reta oñorarota ambué ɨvɨ pegua reta ndive, jare mburuvicha reta oñorarota iru mburuvicha reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jare ɨvɨ ocana yaeta jeta que rupi. Jare oimeta caruai reta jare mbaerasɨ reta jeta yae vae oyucata vae. Jare mbaembae ara re oyecuaata vae oporomonguɨyeta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Erei ndei cuae oyeapo mbove, iru vae reta pepɨɨta jare oyapota icavi mbae vae peve. Jae reta pererajata itupao reta pe jare peñonota tembipɨɨrɨru reta pe, jare pererajata mburuvicha guasu reta jóvai chereco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Erei jocorai oyapo reta peve yave, pepuereta pemombeu cheregua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Agüɨye peñemambeco cuae re jare agüɨye peñemongueta mbae ra pereta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Echa che aicuaucata peve mbae pere vaera, jare che pomboaracuaata agüɨye vaera perovaicho reta oicuaa mbae ra ipuere jei peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jare peru jare pesɨ, jare perɨqueɨ reta jare perɨvɨ reta, jare perentara reta jare peamingo reta pemoeterengata perovaicho reta pe, jare amogüe pe reta peyeyucaucata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jare peñemotareɨucata opaete vae pe chereco pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Erei ngaraa metei ave pea ocañɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jare perosa peo pevae iyapɨ pe yave, peñemboasaucata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jare peecha yave jeta sundaro reta Jerusalén iyɨ́vɨri, peicuaata ou ma co ovae Jerusalén oñemboai vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jayave Judea pe ñogüɨnoi vae reta totecuarai ɨvɨtɨ reta ñogüɨnoia cotɨ. Jare Jerusalén pe ñogüɨnoi vae reta toe totecuarai chugüi. Jare Jerusalén icatu pe ñogüɨnoi vae reta agüɨye toyogüɨraja Jerusalén pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Echa jocuae ara reta pe ɨvɨ pegua reta oiporara yaeta, jare opaete Tumpa iñee pe oyecuatía oi vae oyeapota co —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jare ipurúa vae reta jare omocambu vae reta oiporara yaeta jocuae ara reta pe. Echa cuae ɨvɨ pegua reta oiporara yaeta. Echa Tumpa pochɨta co chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jare jeta cuae ɨvɨ pegua reta oyeyucaucata quɨsepucu pe. Jare jovaicho reta güɨrajata jeta cuae ɨvɨ pegua reta ambué ɨvɨ reta pe. Jare judío mbae vae reta yogüɨrecota Jerusalén pe judío mbae vae reta iara reta opa regua —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jayave ɨvɨ pegua reta oechata mbae oyecuaa oi cuaraɨ jare yasɨ jare yasɨtata reta re. Jare opaete ɨvɨ pegua reta oiporarata jare ngaraa oicuaa mbae oyapo vaera. Jare ɨ guasu reta jɨapu yaeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jare ɨvɨ pegua reta oquɨye yaeta. Oquɨye yaeta mbae ɨvɨ pe oyeapo oi vae güi. Jare ara re mbaepuere güɨnoi vae reta ocanata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jayave ɨvɨ pegua reta cherechata ayu amapɨtu reta reve. Che cuimbaera ayeapo vae anoita mbaepuere tuicha vae jare añemboeteucata opaete vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jare opaete cuae mbaembae oñemboɨpɨ oyeapo yave, pepúa pemae ara re. Echa ɨmambae Tumpa perepɨta —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jayave Jesús jei chupe reta omojaanga reve: —Tamojaanga ɨva jare opaete ɨvɨra reta. ");
INSERT INTO guiNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Oñemboɨpɨ joquɨ yave, peicuaa coiño ma co ou ama oquɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jae ramiño vi pe reta peecha yave cuae mbaembae oyeapo ñogüɨnoi, peicuaata coiño ma co ou Tumpa iporoocuaia —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Añete che jae peve, cuae tenta pegua reta ngaraa opa omano ndei opaete cuae mbaembae oyeapo mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ara jare ɨvɨ opata, erei cheñee ngaraa opa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Peñeandu, agüɨye vaera pecau jare pesavaɨpo, jare agüɨye vaera peñemambeco mbaembae ɨvɨ pegua re. Echa jocorai peyapo yave, outa ovae jocuae ara mbaeti peñemocatɨro reve —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Echa jocuae ara oipocouta opaete ɨvɨ pegua reta ñovai oporomboa rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jae rambue peñeandu, jare jecuaeño peyerure Tumpa pe icavi vaera chupe perepɨ vaera opaete cuae oyeapota vae güi jare peñemboɨ vaera cheróvai. Che co jae cuimbaera oyeapo vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jare ara ñavo Jesús oporomboe oi Tumpa jo pe. Erei jave ma yave ojo joco güi opɨta ɨvɨtɨ Oliva re. ");
INSERT INTO guiNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jare opaete tenta pegua reta yogüeru neimbove asɨ Tumpa jo pe oyeapɨsaca vaera Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jare arete pascua jee vae oyearo oi. Jocuae arete pe judío reta jou mbɨyape ovu mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jayave sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oeca ñogüɨnoi quirai ipuere oyucauca Jesús. Erei oquɨye tenta pegua reta güi. ");
INSERT INTO guiNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jayave Satanás etei oya Judas Iscariote re - Judas co jae jocuae doce vae güi metei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jayave Judas ojo sacerdote reta itenondegua reta jare Tumpa jo re oñangareco vae reta ñogüɨnoia pe imiari vaera jae reta ndive quirai ra ipuere omoeterenga Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jayave jae reta oyerovia, jare jei Judas pe omeeta co chupe corepoti. ");
INSERT INTO guiNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jayave Judas jei chupe reta omoeterengata co Jesús chupe reta. Jayave omboɨpɨ oeca quirai ipuere omoeterenga Jesús chupe reta tenta pegua reta mbaeti Jesús ndive ñogüɨnoi yave. ");
INSERT INTO guiNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jare ou ovae pascua. Jocuae ara judío reta jecuaeño oyuca vecha reta jare omboɨpɨ jou mbɨyape ovu mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jayave Jesús jei Pedro jare Juan pe: —Pecua peyapocavi yau vaera vecha isoo pascua pegua. ");
INSERT INTO guiNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jayave jei reta chupe: —¿Quiape pa reipota royapocavi vaera? ");
INSERT INTO guiNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Mase, peo pevae yave tenta pe, peovaitita metei cuimbae ɨ güɨraja ɨru pe vae —jei—. Pecua jaɨcue. Jae oiqueta metei o pe. Peique vi pe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jayave pere o iya pe: Oporomboe vae jei: ¿Quiape pa oime oi o cheveguara? Che jare cheremimboe reta routa joco pe vecha isoo pascua pegua —jei, pere chupe, jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jayave o iya oechaucata peve metei o tuicha vae jo ɨvate pe opaete mbaembae yaiporuta vae reve. Joco pe peyapocavi ñandeve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jayave Pedro jare Juan yogüɨraja jare ovae Jesús jei chupe reta rami. Jare oyapocavi reta Jesús jare jemimboe reta vecha isoo pascua pegua jou vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jare ora ou ma ovae yave, Jesús oguapɨ mesa pe jocuae doce jemimondo reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jayave jei chupe reta: —Chequɨreɨ yae jau cuae vecha isoo pascua pegua pe reta ndive, ndei amano mbove. ");
INSERT INTO guiNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Che jae peve, ngaraa ye jau, opaete cuae oñemojaanga jese vae Tumpa iporoocuaia pe oyeapo regua —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jayave Jesús oipɨɨ vaso jare omee yasoropai Tumpa pe. Jayave jei: —Opaete pe reta peu cuae vino. ");
INSERT INTO guiNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Che jae peve, ngaraa ye jau vino, Tumpa iporoocuaia oyecuaa regua —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jayave Jesús oipɨɨ mbɨyape, jare omee yasoropai Tumpa pe. Jayave opɨsae mbɨyape jare omee chupe reta. —Cuae co jae cherete —jei—. Añemoeterengata amano vaera peré. Peu cuae cheré pemaendúa vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jae ramiño vi oipɨɨ vaso, opa ma ocaru reta yave, jare jei: —Cuae vino co jae morogüɨrocuavee ipɨau vae cherugüɨ pe ayapota vae. Cherugüɨ oyepɨyereta peré —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Erei ñandepɨte pe oguapɨ oi cherovaicho reta pe chemoeterengata vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Añete co, che cuimbaera ayeapo vae amanota. Cuae Tumpa jemimbota co. Erei jocuae cuimbae chemoeterengata vae oiporarata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jayave jemimboe reta omboɨpɨ oparandu oyoupe quia ra oyapota chupe jocorai. ");
INSERT INTO guiNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jare Jesús jemimboe reta omboɨpɨ imiari oyoupe quia ra oicota tenondeguara vae. ");
INSERT INTO guiNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jayave Jesús jei chupe reta: —Ɨvɨ pegua reta juvicha guasu reta oyócuai reta. Jare jembiócuai reta jei juvicha reta oyapo co icavi vae chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Erei pepɨte pe mbaeti icavi jocorai peyapo vaera. Oime yave quia pepɨte pe oipota oico vaera tenondeguara vae, toyeapo metei taɨrusu vae iru vae reta pe oyeócuai vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mesa pe oguapɨ ocaru vaera vae co tenondegua tembíu güeru vae güi. Erei che aico pepɨte pe ayeócuai peve vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pe reta jecuaeño pepɨta che ndive opaete cuae aiporara rambueve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jare che poparavo ma peico vaera Tumpa iporoocuaia pe, cheRu cheparavo rami —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jae rambue pecaruta chemesa pe cheporoocuaia pe. Jae ramiño vi penoita mbaepuere pejaa vaera jocuae doce atɨ Israel pegua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simón, Simón, mase, Satanás oipota tei güɨnoi mbaepuere nderé, metei omaemboveve vae trigo re mbaepuere güɨnoi rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Erei che ayerure Tumpa pe nderé jecuae renoi vaera mborogüɨrovia. Jare reyerova ye yave Tumpa cotɨ, emborɨ nderɨvɨ reta ipɨrata vaera iporogüɨrovia re —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jayave Pedro jei Jesús pe: —CheYa, apɨtata co nde ndive, tembipɨɨrɨru pe neñono reta yave. Ngaraa roeya, yepe tei güɨramoi iru vae reta cheyuca —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Che jae ndeve, Pedro —jei Jesús—, ndei tacareo oñee pɨipɨi mbove, mboapɨ ma checuacuta —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jayave Jesús jei ye jemimboe reta pe: —Che pomondo yave peñemoñee vaera, amombeu peve agüɨye vaera peraja corepoti, jare peaporoca, jare pepɨapaa. ¿Oata pa mbae peve? —jei. —Mbaeti —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jayave jei ye chupe reta: —Erei añave tamombeu peve cuae: Corepoti penoi yave, peraja. Jae ramiño vi peaporoca penoi yave, peraja. Jare mbaeti yave penoi quɨsepucu, pemee peremimonde pegua vaera quɨsepucu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Echa che jae peve, oyeapota co cheve Tumpa iñee pe oyecuatía oi vae. Echa oyecuatía oi corai: Jei reta jae co mboroócuai oyavɨ vae. Jocorai oyecuatía oi. Jare opaete cheré oyecuatía oi vae oyeapota co cheve —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jayave jae reta jei chupe: —Mase, oreYa, co oime rogüɨnoi mócoi quɨsepucu. —Icaviño ma co —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jayave Jesús oe o güi ojo vaera ɨvɨtɨ Oliva pe jae jeco rami. Jare jemimboe reta vi yogüɨraja jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jare ojo ovae yave opɨtaa pe, Jesús jei jemimboe reta pe: —Peyerure Tumpa pe agüɨye vaera peyoa. ");
INSERT INTO guiNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jayave Jesús ojo mombɨrɨ catu chugüi reta, jare oyeatɨca oyerure Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—CheRu —jei—, reipota yave, emboasa chegüi cuae aiporarata vae. Erei toyeapo cheve neremimbota. Agüɨye toyeapo cheremimbota —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jayave oyecuaa Jesús pe metei araɨgua ara güi ou vae omomɨrata vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús oiporara yae oi, jare jeiete oyerure Tumpa pe. Jɨai yae. Tugüɨ rami otɨquɨ ɨvɨ re. ");
INSERT INTO guiNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jare Tumpa pe oyerure ma yave, opúa ye jare ou ye jemimboe reta ñogüɨnoia pe. Oecha oque ñogüɨnoi ipɨatɨtɨ yae güi. ");
INSERT INTO guiNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jayave Jesús jei chupe reta: —¿Maera pa peque pei? Pepúa peyerure Tumpa pe, agüɨye vaera peyoa —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jare imiari oi rambueve, oyecuaa jeta vae. Jare Judas - jae co jocuae doce vae güi metei - ou jocuae jeta vae jenonde. Jayave ou ovae Jesús oia pe, jare oiyurupɨte. ");
INSERT INTO guiNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jayave Jesús jei chupe: —Judas, ¿maera pa cheyurupɨte chemoeterenga vaera cuae reta pe? ");
INSERT INTO guiNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jare Jesús jemimboe reta oñemboɨ ñogüɨnoi Jesús iyɨ́vɨri. Jare oicuaa mbae oyeapota vae rambue, jei Jesús pe: —OreYa, ¿roiporuta pa quɨsepucu jese reta? ");
INSERT INTO guiNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jayave metei Jesús jemimboe oiporu iquɨsepucu sacerdote tenondegua jembiócuai inambi re, jare inambi oyeequi. ");
INSERT INTO guiNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jayave Jesús jei: —Pemaeño cheré ayapo vaera cuae. Jayave oyavɨquɨ cuimbae inambi jendagüe, jare cuimbae ocuera. ");
INSERT INTO guiNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yogüeru vi joco pe sacerdote reta itenondegua reta jare Tumpa jo re oñangareco vae reta jare tenta pegua reta itenondegua reta. Jare Jesús jei chupe reta: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨɨ vaera, imonda vae peipɨɨ yave rami? ");
INSERT INTO guiNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ara ñavo che ai pe reta ndive Tumpa jo pe, erei pe reta mbaeti chepɨɨ. Erei ora ovae ma chepɨɨ vaera. Corai peyapo pei Satanás imbaepuere pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jayave oipɨɨ reta Jesús jare güɨraja sacerdote tenondegua jo pe. Jare Pedro ojo jae reta jaɨcue, erei mombɨrɨño ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jayave joco pe ñogüɨnoi vae reta oyapo tata sacerdote tenondegua joca pe jare oguapɨ joco pe. Jare Pedro vi oguapɨ joco pe jae reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Erei metei cuñatai oecha Pedro oguapɨ oi tata iyɨpɨ pe. Omae ngatu jese. Jayave jei: —Cuae cuimbae vi oicose jocuae iru cuimbae ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jayave Pedro oicuacu Jesús. —Mbaeti aicuaa jocuae cuimbae —jei Pedro cuñatai pe. ");
INSERT INTO guiNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ndei ɨma mbove metei cuimbae vi oecha Pedro jare jei chupe: —Nde vi co jae iñeiru. —Mbaeti co —jei Pedro cuimbae pe. ");
INSERT INTO guiNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jare metei ora rupi ma oasa yave, iru cuimbae jeiete jei: —Añete co, cuae cuimbae oicose jocuae iru cuimbae ndive. Echa Galilea pegua co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—Mbaeti aicuaa mbae rere vae —jei Pedro cuimbae pe. Jare imiari rupive, tacareo oñee. ");
INSERT INTO guiNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jayave ñandeYa oyerova jare omae Pedro re. Jayave Pedro imaendúa ñandeYa jei chupegüe vae re: Ndei tacareo oñee pɨipɨi mbove, mboapɨ ma checuacuta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jayave Pedro oe joco güi jare tanta yae oyaeo. ");
INSERT INTO guiNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jare cuimbae oñangareco ñogüɨnoi Jesús re vae reta oyóyai jare oinupa. ");
INSERT INTO guiNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jayave jae reta oesaocua Jesús jare ocua jova re. Jayave jei reta chupe: —Emombeu oreve quia ra ocua nderé. ");
INSERT INTO guiNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jare jeta icavi mbae vae jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jare coe ma yave, tenta pegua reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oñemboatɨ. Jayave güeruruca reta Jesús. Jayave jei reta chupe: ");
INSERT INTO guiNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Nde pa co jae Cristo? Emombeu oreve. —Che amombeu yave peve, ngaraa chererovia —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jare che aparandu yave peve mbae re, ngaraa pemombeu cheve, jare ngaraa cheyora —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Erei che cuimbaera ayeapo vae aguapɨta curi Tumpa mbaepuere güɨnoi vae iyɨque pe iyacatu cotɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jayave opaete jae reta oparandu chupe: —¿Nde pa co jae Tumpa Taɨ? —Pe reta pere rami jae co che —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jayave jae reta jei: —¿Maera pa yaeca ye iru vae reta oñeapo vaera jese? Echa ñande etei ñaendu mbae jei vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jayave opaete jae reta opúa jare güɨraja Jesús Pilato pɨri. ");
INSERT INTO guiNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jare omboɨpɨ reta oñeapo Jesús re. Jei reta: —Cuae cuimbae omombeu tenta pegua reta pe oyapo vaera icavi mbae vae. Echa jei chupe reta agüɨye vaera omboepɨ corepoti César peguara. Jare jei jae co mburuvicha guasu Cristo jee vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jayave Pilato oparandu Jesús pe: —¿Nde pa co jae judío reta juvicha guasu? —Nde rere rami jae co che —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jayave Pilato jei sacerdote reta itenondegua reta jare tenta pegua reta pe: —Mbaeti avae teco icavi mbae vae cuae cuimbae re. ");
INSERT INTO guiNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jayave jae reta jeiete jei: —Omboepochɨ tenta pegua reta. Oporomboe opaete Judea rupi. Omboɨpɨ Galilea pe jare añave ou ovae cuae pe oporomboe oi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato oendu yave jei reta vae, oparandu metei Galilea pegua ra jocuae cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jayave omombeu reta Pilato pe Galilea pegua co Jesús. Jayave Pilato güɨrajauca Jesús Herodes pɨri. Echa Herodes co jae Galilea pegua reta juvicha guasu. Jare jocuae ara reta pe Herodes opou oi Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jare Herodes oecha Jesús yave, oyerovia yae, ɨma ma oipota oecha rambue. Echa oendu ma jeta Jesús regua, jare oipota oecha Jesús oyapo metei mɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jayave Herodes oparandu Jesús pe jeta mbaembae re, erei Jesús mbaeti mbae jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jare sacerdote reta itenondegua reta jare mboroócuai re oporomboe vae reta oñemboɨ Herodes jóvai jare iñeeata reve oñeapo Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jare Herodes jare isundaro reta güɨroɨro jare oyóyai Jesús. Jayave omondeuca chupe temimonde ipora yae vae. Jayave Herodes güɨrajauca ye Pilato pɨri. ");
INSERT INTO guiNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jare jocuae ara etei Pilato jare Herodes oñomoicavi ye. Echa tenonde yave oñomotareɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jayave Pilato omboatɨuca sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jare jei chupe reta: —Pe reta peru cuae cuimbae cheve jare pere cheve omboepochɨ co tenta pegua reta. Mase, che aparandu chupe jocuae re perovaque, jare mbaeti etei teco avae jocuae pe reta peñeapo cheve jese vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jae ramiño vi Herodes mbaeti ovae teco cuae cuimbae re. Echa che pomondo Herodes pɨri. Mase, mbaeti mbae teco oyapo omano vaera —jei Pilato chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jae rambue ainupauca güire, ayoraucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Echa año ñavo tenta pegua reta oyerure chupe oyorauca vaera metei tembipɨɨ jocuae arete pe, jare jecuaeño Pilato oyorauca metei tembipɨɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jayave opaete vae iñeeata reve jei: —Eyucauca cuae cuimbae. Eyorauca oreve Barrabás —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Tenonde yave Barrabás oporoyuca Jerusalén pe, mburuvicha reta ndive oñoraro yave. Jae rambue oñeñonouca tembipɨɨrɨru pe.) ");
INSERT INTO guiNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Erei Pilato oipota tei oyorauca Jesús. Jae rambue imiari ye chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Erei iñeeata reve jei reta: —Eicutuca curusu re. Eicutuca curusu re. ");
INSERT INTO guiNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jayave Pilato oparandu ye chupe reta: —¿Mbae pa oyapo? Mbaeti mbae icavi mbae vae avae jese omano vaera. Jae rambue ainupauca güire, ayoraucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Erei jeiete iñeeata reve jei reta oicutuca vaera Jesús curusu re. Jare sacerdote reta itenondegua reta jare iru joco pe ñogüɨnoi vae reta iñee omoquɨreɨ Pilato. ");
INSERT INTO guiNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jayave Pilato jei oyeapo vaera Jesús pe jae reta oipota vae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jayave oyorauca chupe reta tenonde yave mburuvicha reta ndive oñoraro yave oporoyuca rambue tembipɨɨrɨru pe oñeñonouca vae, jae reta oipota rami. Erei omoeterenga Jesús chupe reta oyeapo vaera chupe jae reta oipota vae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jayave güɨraja reta Jesús joco güi. Jare metei cuimbae tenta Cirene pegua Simón jee vae ou tenta icatu güi oasa ojo. Jayave sundaro reta oipɨɨ Simón jare güɨrajauca chupe Jesús icurusu. Jayave Simón güɨraja curusu Jesús jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jare yogüɨraja vi Jesús jaɨcue jeta yae vae. Jare jae reta ipɨte pe yogüɨraja cuña reta. Jae reta oapiro yogüɨraja Jesús. ");
INSERT INTO guiNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Erei Jesús oyerova omae jese reta jare jei chupe reta: —Jerusalén pegua cuña reta, agüɨye peyaeo cheré. Peyaeo peyee jare pemembɨ reta re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mase, outa ovae ara reta jei reta vaera: Oyerovia co mbaeti imembɨ vae. Oyerovia co mbaeti etei omocambu vae —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jayave omboɨpɨta jei ɨvɨtɨ reta pe: Peyapara oreárambue. Oreasoi —jeita, jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ɨvɨra joquɨ oi yave oyapo reta cuae mbaembae, ¿mbae ra oyapota ɨvɨra otini ma yave? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jare sundaro reta güɨraja vi Jesús ndive mócoi cuimbae icavi mbae vae oyapo vae oyuca vaera. ");
INSERT INTO guiNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jare yogüɨraja ovae Acagüerenda jee vae pe. Jayave joco pe sundaro reta oicutu curusu re Jesús jare cuimbae reta icavi mbae vae oyapo vae. Oñono reta metei vae Jesús iyacatu cotɨ jare iru vae Jesús iyasu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jayave Jesús jei: —CheRu, neɨro chupe reta. Mbaeti oicuaa mbae oyapo ñogüɨnoi vae —jei. Jayave sundaro reta oñuvanga Jesús jemimonde reta re, oicuaa vaera mbae nunga metei ñavo güɨrajata vae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jare tenta pegua reta oñemboɨ ñogüɨnoi jocoropi omae Jesús re. Jare tenta pegua reta itenondegua joco pe ñogüɨnoi vae reta oyóyai Jesús. Jei reta: —Jae oepɨ iru vae reta. Añave toyeepɨ, jae co Cristo yave, jae co Tumpa oiparavo vae yave —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jare sundaro reta vi oyóyai Jesús. Oya reta jese jare güɨrocuavee vinagre chupe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jare jei reta: —Nde co jae judío reta juvicha guasu yave, eyeepɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jare oñono reta curusu re Jesús iñaca iárambue oyecuatía jese vae: Cuae co jae judío reta juvicha guasu. Oyecuatía oi griego iñee pe jare latín pe jare hebreo iñee pe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jare metei cuimbae icavi mbae vae oyapo vae oyecutuca vae oñeengata Jesús pe. —Nde co jae Cristo yave, eyeepɨ jare orerepɨ vi —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Erei iru cuimbae oñeengata chupe. —¿Mbaeti pa requɨye Tumpa güi? Echa nde vi remano rei cuae iru vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jare jupi co ñande ñamano vaera. Echa ñande ñamanota ñai icavi mbae vae yayapo vae jeco pegua. Erei cuae cuimbae mbaeti mbae icavi mbae vae oyapo —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jayave jei Jesús pe: —Jesús, nemaendúa cheré ndeporoocuaia pe rei yave. ");
INSERT INTO guiNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jayave Jesús jei chupe: —Añete che jae ndeve, cuae ara reita che ndive paraíso pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jare cuaraɨ ara mbɨte güive mboapɨ ora rupi oñemopɨtumimbi opaete ɨvɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Cuaraɨ jembipe mbaeti oyecuaa. Jayave Tumpa jo omboyao vae osoro mbɨte rupi. ");
INSERT INTO guiNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jayave Jesús tanta osapúcai. Jayave jei: —CheRu, amee ndeve cherecove. Jare cuae jei ma yave, omano. ");
INSERT INTO guiNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jare cien sundaro vae juvicha joco pe oi vae oecha mbae oyeapo vae. Jayave omboete Tumpa jare jei: —Añete co, cuae cuimbae co jae jupi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jare opaete tenta pegua joco pe yatɨ vae reta vi oecha mbae oyeapo vae jare ocua iyee ipɨtía re. Jayave opaete vae yogüɨraja ye tenta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jare opaete Jesús oicuaa vae reta jare cuña Jesús ndive Galilea güi yogüeru vae reta oñemboɨ ñogüɨnoi mombɨrɨ curusu güi. Omae ñogüɨnoi mbae oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jare joco pe oi vi metei cuimbae José jee vae. Jae co metei mburuvicha. Ipɨacavi jare jupi. ");
INSERT INTO guiNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Jae mbaeti tei oipota iru mburuvicha reta oyapo vaera icavi mbae vae Jesús pe.) Jae co tenta Arimatea pegua. (Arimatea Judea pegua co.) José vi oaro oico Tumpa iporoocuaia. ");
INSERT INTO guiNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Cuae cuimbae ojo Pilato pɨri jare oyerure chupe Jesús jetegüe re. ");
INSERT INTO guiNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jayave ombogüeyɨ Jesús jetegüe, jare oñoma lienzo pe. Jayave oñono metei teogüerɨru ita guasu oyeyoo vae pe. Ndei Jesús jetegüe joco pe oñeñono mbove, mbaeti quia oñeñono jocuae teogüerɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jocuae ara opaete judío reta oyeapocavi ñogüɨnoi pɨareve peguara. Echa pɨareve pe outa ovae mbutuu iara. ");
INSERT INTO guiNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jare cuña Jesús ndive Galilea güi yogüeru vae reta, yogüɨraja José jaɨcue jare oecha teogüerɨru jare quirai José oñono pɨpe Jesús jetegüe. ");
INSERT INTO guiNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jayave yogüɨraja ye tenta pe jare omoicavi mbae ipiche cavi vae. Jayave oputuu reta mbutuu iara pe. Echa jocorai oyecuatía oi mboroócuai pe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jare neimbove asɨ semana iara tenondegua vae pe cuña reta yogüɨraja ye teogüerɨru cotɨ. Güɨraja reta mbae ipiche cavi vae omoicavi ma vae. ");
INSERT INTO guiNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jare oecha ita tuicha vae oñembosɨrɨ ma teogüerɨru jonque güi. ");
INSERT INTO guiNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jayave oique reta teogüerɨru pe, erei mbaeti ovae ñandeYa Jesús jetegüe joco pe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ipɨacañɨ yae reta cuae re, erei güɨramoiño oyecuaa oñemboɨ ñogüɨnoi iyɨpɨ pe mócoi cuimbae. Jocuae mócoi cuimbae jemimonde oesape yae oi. ");
INSERT INTO guiNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jae rambue cuña reta oquɨye jare oñaɨvɨ cuimbae reta jóvai. Jayave cuimbae reta jei chupe reta: —¿Maera pa peeca pei oicove ye vae omanogüe vae reta ipɨte pe? ");
INSERT INTO guiNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mbaeti cuae pe oi. Jae oicove ye ou omanogüe vae reta ipɨte güi. Pemaendúa jae oico vɨteri pe ndive Galilea pe yave jei peve vae re —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Echa jae jei peve: Chemoeterengata cuimbae icavi mbae vae oyapo vae reta pe. Jae reta checututa curusu re. Erei che cuimbaera ayeapo vae aicove yeta ayu omanogüe vae reta ipɨte güi mboapɨ ara rupi —jei, jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jayave jae reta imaendúa Jesús jei chupe reta vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jayave yogüeru ye teogüerɨru güi jare omombeu opaete oyeapo vae jocuae once vae jare opaete iru vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jocuae cuña reta co jae María Magdalena, jare Juana, jare Jacobo ichɨ María jee vae, jare iru cuña jae reta jupíe yogüɨraja vae reta. Cuae reta omombeu Jesús jemimondo reta pe mbae oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Erei yapu reta echa Jesús jemimondo reta pe. Mbaeti güɨrovia reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jayave Pedro osɨi ojo teogüerɨru cotɨ. Jare joco pe ojo ovae yave, oñaɨvɨ omae vaera teogüerɨru japɨpe pe, jare oecha lienzo reta joco pe oi. Jayave ou ye joco güi. Ipɨacañɨ cuae oyeapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jare jocuae ara etei mócoi Jesús jemimboe reta yogüɨraja tape rupi Jerusalén güi tenta Emaús cotɨ. Emaús oi diez kilómetro Jerusalén güi. ");
INSERT INTO guiNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jare tape rupi yogüɨraja rambueve, imiari oyoupe opaete oyeapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jare güɨramoiño imiari ñogüɨnoi rambueve, Jesús oyecuaa chupe reta jare ojo jae reta jupíe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Erei jae reta mbaeti oicuaa Jesús. Echa Jesús mbaeti vɨteri oipota oyecuauca chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jayave Jesús oparandu chupe reta: —¿Mbae re pa pemiari oyoupe peguata rambueve? ¿Maera pa pepɨatɨtɨ? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jare metei Cleofas jee vae oparandu Jesús pe: —¿Mbaeti pa reico Jerusalén pe? ¿Mbaeti pa reicuaa cuae ara reta pe opaete oyeapo vae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Mbae pa? —jei chupe reta. —Jesús Nazaret pegua pe oyeapo vae —jei reta chupe—. Jae co metei Tumpa iñee omombeu vae. Oyapo jeta mbae icavi vae mbaepuere reve, jare icavi yae oporomboe. Oyeócuai cavi Tumpa pe jare opaete tenta pegua reta omboete —jei reta Jesús pe—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Erei sacerdote reta itenondegua reta jare oretenondegua reta omoeterenga mburuvicha guasu pe, jae oyucauca vaera. Jare oicutuca reta curusu re —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Erei ore rogüɨrovia tei jae oepɨta Israel pegua reta. Jare cuae ara mboapɨ ara ma opaete cuae oyeapo güire —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Erei amogüe cuña ore ndive oyeocuaise Jesús pe vae reta yei neimbove yogüɨraja teogüerɨru pe, jare yogüeru ye yave, oremopɨacañɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Echa jae reta mbaeti ovae Jesús jetegüe, jare yogüeru ye yave, jei oreve quirai oecha araɨgua reta joco pe jare quirai araɨgua reta jei Jesús oicove co oi —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jayave amogüe ore ndive ñogüɨnoi vae vi yogüɨraja teogüerɨru pe, jare yogüeru ye yave, omombeu oreve mbaeti joco pe oi Jesús jetegüe cuña reta jei oreve rami —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jayave Jesús jei chupe reta: —Pe reta co jae mbaeti iyaracuaa vae reta rami. Yavai co oi peve perovia vaera opaete Tumpa iñee aracae omombeu vae reta oicuatiagüe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Peicuaata tei ma jae reta oicuatía co quirai Cristo oiporarañotai rani co jare quirai jocuae jaɨcue rupi oñemboeteucata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jayave Jesús omombeu chupe reta jeta Moisés jare Tumpa iñee aracae omombeu vae reta oicuatiagüe vae güi, jare omombeu cavi chupe reta quirai opaete jocuae oyecuatía oi vae imiari Cristo re. ");
INSERT INTO guiNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jare yogüɨraja ma ovae coiño Emaús güi. Echa jocuae mócoi vae opɨtata joco pe. Jare Jesús oasata tei ojo cutɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Erei jae reta jei chupe: —Epɨta ore ndive. Echa caaru ma. Javeta co ndeve —jei reta. Jayave Jesús opɨta jae reta jo pe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jare oguapɨ rambueve mesa pe ocaru vaera, Jesús oipɨɨ mbɨyape jare omee yasoropai Tumpa pe. Jayave opɨsae omee chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jayave ramo oicuaa reta Jesús. Echa Jesús omaeño ma jese reta oicuaa vaera. Jayave jupiveiño Jesús ocañɨ chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jayave jei reta oyoupe: —Añete co, jae ñanemboyerovia yae, tape rupi imiari ñandeve rambueve. Echa oicuauca ñandeve Tumpa iñee oyecuatía oi vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jayave jocuae ora pe etei jae reta opúa mesa güi jare yogüɨraja ye Jerusalén pe. Joco pe ovae jocuae once vae yatɨ iru vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Añete co, ñandeYa oicove ye ma ou omanogüe vae reta ipɨte güi —jei yatɨ vae reta—. Echa oyecuaa co Simón pe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jayave jocuae mócoi vae vi omombeu yatɨ vae reta pe mbae tape rupi oyeapo vae jare quirai Jesús oyecuaa chupe reta mbɨyape opɨsae yave. ");
INSERT INTO guiNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jare imiari ñogüɨnoi rambueve, Jesús etei oyecuaa oñemboɨ oi ipɨte pe, jare jei chupe reta: —Mbɨacatu toi pe ndive. ");
INSERT INTO guiNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Erei jae reta oquɨye yae. Oñemongueta tei jocuae co Jesús iagüe. ");
INSERT INTO guiNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Erei Jesús jei chupe reta: —¿Maera pa pequɨye? ¿Maera pa peñemongueta pepɨa pe jocorai? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pemae chepo jare chepɨ re. Jae co che. Pepuere cheavɨquɨ peicuaa vaera jae co che. Echa metei vae iagüe mbaeti güɨnoi isoo jare icagüe reta. Erei pepuere peecha che anoi co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jare cuae jei ma yave, oechauca chupe reta ipo jare ipɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jae reta ipɨacañɨ yae, jare oyerovia güi mbaeti vɨteri ipuere güɨrovia ete. Jayave Jesús oparandu chupe reta: —¿Oime pa penoi cuae pe mbae jau vaera? ");
INSERT INTO guiNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jayave omee reta chupe jevae ɨ rupigua oyɨgüe iperaso jare mbovɨ ei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jare Jesús oipɨɨ jou jae reta jovaque. ");
INSERT INTO guiNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jayave jei chupe reta: —¿Mbaeti pa pemaendúa pe reta ndive aico rambueve che jae peve vae re? Echa Moisés iporoócuai jare Tumpa iñee aracae omombeu vae reta oicuatiagüe vae jare Salmo reta chemombeu. Jare amombeu peve quirai opaete cuae chemombeu vae oyeapota co —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jayave omee chupe reta oicuaa cavi vaera Tumpa iñee oyecuatía oi vae. ");
INSERT INTO guiNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jayave jei chupe reta: —Corai oyecuatía oi quirai Cristo oiporarañotai co jare oicove yeta co ou omanogüe vae reta ipɨte güi mboapɨ ara rupi, ");
INSERT INTO guiNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","jare quirai jeracuata iru vae reta pe Cristo jee re oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae Tumpa iñɨro vaera chupe reta imbaeyoa reta re. Jeracuata rani Jerusalén pe. Jayave jocuae güire jeracuata opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jare pe reta pemombeuta opaete cuae regua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mase, ambouta peve cheRu güɨrocuavee omeeta co peve vae. Erei pepɨta tenta Jerusalén pe mbaepuere güɨnoi vae ara güi ou peve regua —jei. ");
INSERT INTO guiNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jayave Jesús güɨraja reta Betania pe. Jayave oupi ipo ara cotɨ jare omovendise reta. ");
INSERT INTO guiNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jare omovendise oi rambueve, ojo chugüi reta ara cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jayave jae reta omboete. Jayave yogüɨraja ye Jerusalén pe oyerovia yae reve. ");
INSERT INTO guiNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jare jecuaeño yogüɨraja Tumpa jo pe omboete reve Tumpa. Amén.");
INSERT INTO guiNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ndei mbae oyeapo mbove, oico Ñee. Jare Ñee oico Tumpa ndive. Jae co Tumpa etei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ñee oico Tumpa ndive ndei mbae oyeapo mbove. ");
INSERT INTO guiNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jae oyapo opaete. Opaete oyeapo vae jae etei oyapo. ");
INSERT INTO guiNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jae omee tecove opaete pe, jare cuae tecove rupi jae oyecuaa ɨvɨ pegua reta pe mbaembae oyecuaa tembipe rupi rami. ");
INSERT INTO guiNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jae co tembipe rami. Tembipe jecuaeño oesape pɨtumimbi pe, jare pɨtumimbi mbaeti etei ipuere ombogüe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Oico metei cuimbae Juan jee vae. Tumpa ombou cuae cuimbae omombeu vaera tembipe, iru vae reta oporogüɨrovia vaera oendu yave. ");
INSERT INTO guiNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jae mbaeti co jocuae tembipe. Jaeño ou omombeu vaera jocuae tembipe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tembipe etei ou ma cuae ɨvɨ pe. Jae oyecuaa opaete vae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jae oico cuae ɨvɨ pe, jare jae oyapo cuae ɨvɨ. Erei ɨvɨ pegua reta mbaeti oicuaa. ");
INSERT INTO guiNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ou jenta pe, erei jentaɨgua reta mbaeti omboresive. ");
INSERT INTO guiNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Erei amogüe vae omboresive. Güɨrovia jese. Jae rambue jae omee cuae reta pe Tumpa taɨ reta jare tayɨ reta yogüɨreco vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tumpa etei omee cuae reta pe tecove. Cuae tecove mbaeti ichɨ güi. Mbaeti güɨnoi cuae tecove tu jemimbota jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jocuae Ñee oyeapo cuimbaera. Ou cuae ɨvɨ pe oico vaera ñande ndive. Jare ore roecha maemboete pegua co jae. Jaeño Tumpa Taɨ jae vaeño cuae maemboete güɨnoi. Jae ipɨacavi yae jare opaete jei vae añete co. ");
INSERT INTO guiNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Echa Juan omombeu iru vae reta pe: —Cuae co jae chemiari jese vae —jei chupe reta—. Che jae ma peve: Cheraɨcue outa vae ipuere yae chegüi. Echa jae oico ndei aico mbove —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jocuae Ñee ipɨacavi yae. Jae rambue jecuaeño oyapo icavi vae ñandeve. ");
INSERT INTO guiNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tumpa omombeu mboroócuai Moisés rupi. Erei Jesucristo rupi Tumpa omombeu ipɨacavi co jare ñanemboe añete vae re. ");
INSERT INTO guiNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mbaeti etei quia oecha Tumpa. Erei Tumpa Taɨ jae vaeño oicuauca ñandeve. Tumpa oaɨu Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Metei ara yogüɨraja ovae Juan oia pe sacerdote reta jare levita reta. Jerusalén pegua judío reta omondo cuae reta chupe. Jae reta jei Juan pe: —¿Quia pa co nde? ");
INSERT INTO guiNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan omombeu cavi. Mbaeti iyapu chupe reta. —Che mbaeti co Cristo jee vae —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jayave oparandu reta ye chupe: —Mbaeti yave, ¿nde pa co jae Elías jee vae? Juan jei ye: —Mbaeti co. Jei reta ye chupe: —¿Nde pa co jocuae Tumpa iñee omombeu vae? —Mbaeti —jei ye Juan chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jayave oparandu reta ye chupe: —¿Quia pa co nde? Echa roipota romombeu orembou vae reta pe. ¿Mbae pa rere ndeyeupe? —jei reta Juan pe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jayave Juan jei: —Che co jae metei ñee mbae omombeu vae. Cheñeeata ñuu pe: Peyapocavi ñandeYa japera. Jocorai che jae —jei Juan—. Echa jocorai jei Isaías aracae Tumpa iñee omombeu vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cuae Juan oia pe yogüɨraja vae reta fariseo reta co. ");
INSERT INTO guiNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Oparandu reta ye Juan pe: —Nde mbaeti yave Cristo ani Elías ani jocuae Tumpa iñee omombeu vae, ¿maera pa reporombobautiza? ");
INSERT INTO guiNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","—Che aporombobautiza ɨ pe —jei Juan—. Erei yepe tei mbaeti peicuaa, erei oime pepɨte pe jocuae cheraɨcue outa vae. Mbaeti jupi che amboi vaera ipɨapaa —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Opaete cuae oyeapo Betábara pe ɨaca Jordán jee vae jovaicho pe. Echa joco pe oporombobautiza Juan. ");
INSERT INTO guiNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pɨareve pe Juan oecha Jesús ou icotɨ jare jei: —Mase, pee oi Tumpa ombou vae. Jae co vecha rami. Ou güɨraja vaera opaete ɨvɨ pegua reta imbaeyoa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cuae co jae chemiari jese vae. Che jae ma peve: Cheraɨcue outa vae ipuere yae chegüi. Echa jae oico ndei aico mbove. Cuae co jae —jei Juan—. ");
INSERT INTO guiNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Che mbaeti aicuaa. Erei ayu aporombobautiza ɨ pe jae oyecuaa vaera Israel pegua reta pe —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan omombeu ye chupe reta: —Aecha Espíritu Santo ogüeyɨ ara güi pɨcasu rami jare ou opɨta jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Che mbaeti aicuaa. Erei chembou aporombobautiza vaera ɨ pe vae jei cheve: “Reechata Espíritu Santo ogüeyɨ ou opɨta metei cuimbae re. Jocuae cuimbae oporombobautizata Espíritu Santo pe” —jei, jei Juan—. ");
INSERT INTO guiNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jocuae aecha ma jare amombeu peve cuae co jae Tumpa Taɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pɨareve pe Juan oñemboɨ ye oi joco pe mócoi jemimboe ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jayave ou Jesús oasa jocoropi. Juan omae ngatu jese. —Mase, pee oi Tumpa ombou vae. Jae co vecha rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jocuae mócoi jemimboe oendu jare yogüɨraja Jesús jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús oyerova yave, oecha yogüeru icotɨ. —¿Mbae pa peeca? —jei chupe reta. —¿Quiape pa reico, Rabí? —jei reta. (Rabí oipota jei: Oporomboe vae.) ");
INSERT INTO guiNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Peyu peecha —jei Jesús. Jayave yogüɨraja Jesús oicoa pe oecha, jare opɨta jocuae ara jae ndive. Echa cuaraɨ ara mbɨte seri ma. ");
INSERT INTO guiNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mócoi cuimbae co jocuae Jesús jaɨcue yogüɨraja vae. Echa yogüɨraja jaɨcue oendu yave Juan jei chupe reta vae. Metei cuimbae jee co Andrés. Jae co Simón Pedro tɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés ojo rani ovae tɨqueɨ Simón jare jei chupe: —Rovae ma Mesías. (Cuae oipota jei hebreo iñee pe: Cristo.) ");
INSERT INTO guiNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jayave Andrés güeru Simón Jesús oia pe. Jesús omae ngatu Simón re jare jei: —Nde co jae Simón. Nde co jae Jonás taɨ. Torombojee Cefas. (Cuae oipota jei: Pedro.) ");
INSERT INTO guiNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Pɨareve pe Jesús oipota ojo Galilea pe. Jare ovae Felipe Betsaida pegua. Andrés jare Pedro Betsaida pegua vi. Jesús jei Felipe pe: —Eyu cherupíe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jayave Felipe ojo ovae Natanael jare jei chupe: —Rovae ma Moisés mboroócuai pe imiari jese vae. Aracae Tumpa iñee omombeu vae reta vi imiari jese —jei—. Jae co Jesús Nazaret pegua. Jae co José taɨ —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Oime pa mbae icavi vae Nazaret pegua? —jei Natanael. —Yaja eecha —jei Felipe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús oecha Natanael ou icotɨ jare jei: —Mase, co ou metei Israel pegua añetete vae. Jecuaeño oyapo añete vae rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael oparandu Jesús pe: —¿Quirai pa checuaa? Jesús jei chupe: —Ndei Felipe imiari ndeve mbove, che roecha ɨva igüɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Nde co jae Tumpa Taɨ, Rabí —jei Natanael—. Nde co jae Israel pegua reta juvicha guasu —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús jei ye chupe: —Amombeu ndeve che roecha ɨva igüɨ pe. ¿Cuae jeco pegua ra reporogüɨrovia ma? —jei—. Reechata mbaembae reporogüɨrovia yae vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Añete che jae ndeve, reechata ara oyepea oi, jare reechata vi araɨgua Tumpa pe oyeócuai vae reta oyeupi ñogüɨnoi jare ogüeyɨ ñogüɨnoi che aia pe. Che co jae cuimbaera oyeapo vae —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mboapɨ ara rupi metei cuimbae omenda cuñatai ndive Caná Galilea pegua pe, jare Jesús ichɨ oi joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jare oparea reta vi Jesús jare jemimboe reta pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino opa ma yave, Jesús ichɨ jei Jesús pe: —Opa ma vino. ");
INSERT INTO guiNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—¿Ndepɨatɨtɨ pa cuae re? Che mbaeti co chepɨatɨtɨ jese, cuña —jei Jesús—. Ndei ovae cheparavɨquɨ ayapo vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jayave Jesús ichɨ jei joco pe oyeócuai vae reta pe: —Peyapo omombeuta peve vae. ");
INSERT INTO guiNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Joco pe ñogüɨnoi seis ɨrɨru tuicha vae ita pegua. Judío reta oiporu jocuae nunga ɨrɨru mbaembae oyoe vaera. Oñemongueta oyetɨo cavi Tumpa cotɨ jocorai oyapo yave. Ɨrɨru ñavo ipuere tɨnɨe cinco ɨru ɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús jei tembiócuai reta pe: —Pemotɨnɨe cavi ɨrɨru reta ɨ pe. Jayave jae reta omotɨnɨe cavi. ");
INSERT INTO guiNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús jei ye chupe reta: —Añave peñoe peraja peruvicha pe. Jayave jocorai oyapo reta. ");
INSERT INTO guiNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tembiócuai reta juvicha jou jocuae ɨ vinora oyeapo vae. Jae mbaeti oicuaa quia güi ra ou jocuae jou vae, erei jembiócuai reta oicuaa catu quia güi co oñoe. Jayave mburuvicha oeni cuimbae omenda vae. ");
INSERT INTO guiNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Opaete iru vae reta omee vino icavi vae rani mboupa reta pe. Jayave jeta vino jou yave ramo omee chupe reta vino mbaeti icavi mbatee vae —jei chupe—. Erei nde añave ramo remee vino icavi yae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús cuae oyapo Caná Galilea pegua pe. Corai Jesús omboɨpɨ oicuauca jemimboe reta pe jae imbaepuere tuicha yae co. Jare cuae oyapo vae jeco pegua jemimboe reta güɨrovia jese. ");
INSERT INTO guiNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cuae jaɨcue rupi Jesús ojo Capernaúm pe. Yogüɨraja vi jae jupíe ichɨ jare tɨvɨ reta jare jemimboe reta. Jare opɨta reta joco pe mbovɨ ara. ");
INSERT INTO guiNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jare coiño ma ou judío reta iyarete pascua jee vae iara. Jayave Jesús ojo Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Joco pe Tumpa jo pe oecha omaemee vae reta. Omee ñogüɨnoi güeye reta jare vecha reta jare pɨcasu reta. Oecha vi corepoti omocambio vae reta oguapɨ ñogüɨnoi joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jayave Jesús oyapo chicote piola pegua jare omoe omaemee vae reta jare vecha reta jare güeye reta Tumpa jo güi. Jayave opɨyere corepoti omocambio vae reta icorepoti jare omboyapara imesa reta. ");
INSERT INTO guiNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jare jei pɨcasu omee vae reta pe: —Peraja cuae güi cuae reta. Agüɨye pemee mbaembae cheRu jo pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jayave jemimboe reta imaendúa quirai oime Tumpa iñee pe oyecuatía oi corai: “Aipota yae Tumpa jo oñemboeteuca vaera. Cheratangatu yae jese. Jae rambue cuae jeco pegua iru vae reta oyapota icavi mbae vae cheve.” Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jayave judío reta oparandu Jesús pe: —¿Mbae nunga mɨacañɨ pa reechaucata oreve roicuaa vaera oime ra renoi mbaepuere cuae mbaravɨquɨ reyapo vae reyapo vaera? ");
INSERT INTO guiNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús jei chupe reta: —Pembosururu yave cuae Tumpa jo, amoicavi yeta co mboapɨ ara pe. ");
INSERT INTO guiNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Oparavɨquɨ reta cuarenta y seis año oyapo vaera cuae Tumpa jo —jei judío reta—. ¿Remoicavi yeta ra nde mboapɨ ara pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Erei Jesús imiari chupe reta jete ae re. Echa jete co jae Tumpa jo. ");
INSERT INTO guiNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jae rambue Jesús oicove ye yave ou omanogüe vae reta ipɨte güi, jemimboe reta imaendúa cuae jei vae re. Jayave güɨrovia aracae Tumpa iñee pe oyecuatía oi vae jare jocuae Jesús jei chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús opɨta Jerusalén pe arete pascua iara pe. Joco pe oi rambueve, omombeu iru vae reta pe quia co jae. Jayave jeta oendu vae güɨrovia jese mɨacañɨ oyapo jae reta oicuaa vaera vae reta oecha reta yave. ");
INSERT INTO guiNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Erei Jesús mbaeti güɨrovia añetete cuae reta iporogüɨrovia. Echa oicuaa cavi opaete ɨvɨ pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jae mbaeti omonesesita quia omombeu vaera chupe ɨvɨ pegua reta regua. Echa jae oicuaa cavi ɨvɨ pegua reta ipɨa pe oi vae. ");
INSERT INTO guiNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oico metei fariseo Nicodemo jee vae. Jae co judío reta juvicha. ");
INSERT INTO guiNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cuae cuimbae ou Jesús oia pe pɨtu yave jare jei chupe: —Rabí, roicuaa co Tumpa nembou reporomboe vaera. Echa mbaeti quia ipuere oyapo jocuae nunga mɨacañɨ reyapo vae Tumpa mbaeti yave oi jae ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Añete che jae ndeve —jei Jesús Nicodemo pe—, oime yave quia oipota oico Tumpa iporoocuaia pe vae, güɨnoita rani co tecove ipɨau vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Quiraita pa co ñandepuere tecove ipɨau vae ñanoi ñanendechi ma yave? —jei Nicodemo—. Mbaeti etei ñandepuere yaique ye ñandesɨ jɨe pe yaa ye vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús jei ye chupe: —Añete che jae ndeve, oime yave quia oipota oico Tumpa iporoocuaia pe vae, güɨnoita rani co tecove ipɨau vae ɨ jare Espíritu Santo rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yaa yave ñandesɨ güi, ñanoi tecove ɨvɨ peguaraño. Erei Espíritu Santo omee ñandeve tecove Espíritu pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amombeu ma ndeve quirai penoita rani co tecove ipɨau vae. Agüɨye nepɨacañɨ cuae re —jei chupe—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ɨvɨtu oyepeyu oipotagüe rupi güi jare reendu jɨapu. Erei mbaeti reicuaa quetɨ güi ra ou jare quetɨ ra ojo. Jocorai co oi Espíritu Santo omee tecove chupe vae —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo oparandu ye Jesús pe: —¿Quiraita pa co oyeapo cuae? ");
INSERT INTO guiNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús oparandu Nicodemo pe: —¿Mbaeti pa reicuaa cuae? Echa nde co jae Israel pegua reta omboe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Añete che jae ndeve, oremiari roicuaa vae re jare romombeu roecha vae. Erei mbaeti perovia romombeu peve vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amombeu ma peve mbaembae oyeapo ɨvɨ pe vae, erei mbaeti chererovia. ¿Quiraita pa pepuere chererovia mbaembae oyeapo ara pe vae amombeu peve yave? —jei Jesús Nicodemo pe—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","14","Mbaeti quia ye oyeupi ojo ara pe, jaeño che ara güi agüeyɨ ayu vae. Che co jae cuimbaera oyeapo vae ara pe oi vae —jei chupe—. Moisés aracae oupi jocuae mboi, ñuu pe oico yave. Jocorai vi iru vae reta chereupita co, ");
INSERT INTO guiNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","oipotagüe güɨrovia cheré vae güɨnoi vaera tecove opa mbae vae. Ngaraa ojo cañɨtei pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Echa Tumpa oaɨu yae ɨvɨ pegua reta. Jae rambue omee Taɨ jae vaeño, oipotagüe güɨrovia jese vae güɨnoi vaera tecove opa mbae vae. Ngaraa ojo cañɨtei pe. ");
INSERT INTO guiNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tumpa ombou Taɨ ɨvɨ pe, ɨvɨ pegua reta oñemboasauca vaera jae jeco pegua. Taɨ mbaeti ou ojaa vaera ɨvɨ pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Güɨrovia Tumpa Taɨ re vae reta ngaraa ma oñejaauca. Erei iru vae reta oñejaauca ma co. Echa Tumpa Taɨ jae vaeño omombeu ma quia co jae. Erei jae reta mbaeti güɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tembipe ou ma ɨvɨ pe, erei ɨvɨ pegua reta oipota yae yogüɨreco pɨtumimbi pe. Mbaeti oipota yogüɨreco tembipe pe. Echa oyapo reta icavi mbae vae. Jae rambue oñejaauca reta ma co. ");
INSERT INTO guiNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Oipotagüe icavi mbae vae oyapo vae omotareɨ tembipe. Mbaeti ou tembipe oia pe agüɨye vaera iru vae reta oicuaa mbae oyapo vae. ");
INSERT INTO guiNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Erei añete pegua rupi oico vae ou tembipe oia pe, iru vae reta oicuaa vaera mbaravɨquɨ oyapo vae oyapo co Tumpa jemimbota rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cuae jaɨcue rupi Jesús jare jemimboe reta yogüɨraja ɨvɨ Judea jee vae pe. Joco pe opɨta Jesús jae reta ndive jare oporombobautizauca oi. ");
INSERT INTO guiNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan vi oporombobautiza oi Enón pe. Enón coiño oi Salim güi. Echa joco pe jeta ɨ oi. Jare amogüe vae yogüeru jare Juan ombobautiza reta. ");
INSERT INTO guiNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Echa Juan ndei oyererajauca tembipɨɨrɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jayave Juan jemimboe reta oyoaca ñogüɨnoi judío reta ndive quirai ipuere oyetɨo cavi Tumpa peguara vae re. ");
INSERT INTO guiNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jayave yogüeru Juan oia pe jare jei chupe: —Rabí, nde remombeu ma oreve Jordán jovaicho pe nde ndive oise vae regua. Mase, jae oporombobautiza oi, jare opaete vae yogüɨraja ñogüɨnoi jae oia pe —jei reta Juan pe. ");
INSERT INTO guiNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jayave Juan jei chupe reta: —Tumpa omee ñandeve vaeño ñandepuere ñanoi. ");
INSERT INTO guiNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Che jae ma peve: Che mbaeti co Cristo. Jaeño Tumpa che rani chembou chugüi. Pe reta etei peicuaa corai co che jae peve —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jae co metei cuimbae omendata vae rami. Che co omendata vae iamingo rami. Echa omendata vae iamingo opɨta omendata vae ndive jare oyeapɨsaca jese jare oyerovia yae iñee oendu yave. Jocoraiño vi co che ayerovia yae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Echa jeta vae yogüɨrajata jae oia pe erei mbovɨño ma co yogüeruta che aia pe —jei Juan chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ara güi ou vae ipuere opaete iru vae reta güi. Ɨvɨ pegua reta ɨvɨ peguaño co jare imiari mbaembae ɨvɨ pe oi vae re. Ara güi ou vae ipuere opaete iru vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jae omombeu oecha jare oendu vae, erei mbaeti quia güɨrovia jae omombeu vae. ");
INSERT INTO guiNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jae omombeu vae güɨrovia vae oicuauca iru vae reta pe güɨrovia co Tumpa iñee añete co. ");
INSERT INTO guiNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Echa jocuae Tumpa ombou vae omombeu Tumpa iñee, jare Tumpa omee chupe Espíritu Santo opaete imbaepuere reve. ");
INSERT INTO guiNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tu oaɨu Taɨ jare oyapo ma opaete mbaembae juvichara. ");
INSERT INTO guiNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tumpa Taɨ re güɨrovia vae güɨnoi ma tecove opa mbae vae. Tumpa Taɨ re mbaeti güɨrovia vae ngaraa güɨnoi tecove. Tumpa jecuaeño pochɨ chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ÑandeYa Jesús oendu jeracua ma co fariseo reta pe corai: Jesús oyapo oi jare ombobautiza oi jeta jemimboe retara Juan güi. Jocorai jeracua. ");
INSERT INTO guiNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Erei Jesús etei mbaeti oporombobautiza. Jemimboe retaño oporombobautiza ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jayave cuae oicuaa yave, Jesús oe Judea güi ojo ye Galilea pe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jare ojo Samaria rupi. Echa tape oasa jocoropi. ");
INSERT INTO guiNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jayave ojo ovae tenta Sicar jee vae pe. Jocuae tenta Samaria pegua co, jare coiño oi ɨvɨ Jacob aracae omee taɨ José pe vae güi. ");
INSERT INTO guiNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jocuae ɨvɨ pe oi metei ɨcua. Jocuae ɨcua jee Jacob iyɨcua. Jayave Jesús oguapɨ ɨcua iyɨpɨ pe. Echa mombɨrɨ ma oguata, jare icanguɨ yae. Jare cuaraɨ ara mbɨte ma. ");
INSERT INTO guiNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jayave ou ovae metei cuña Samaria pegua ɨ güɨnoe vaera. Jare Jesús jei chupe: —Emee taɨu. ");
INSERT INTO guiNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Echa Jesús jemimboe reta yogüɨraja tenta pe jembiura ogua vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jayave cuña Samaria pegua jei Jesús pe: —Nde co jae metei judío jare che co jae metei Samaria pegua. ¿Maera pa nde rere cheve: Emee taɨu? —jei. (Echa judío reta mbaeti etei oipota imiari Samaria pegua reta ndive.) ");
INSERT INTO guiNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jayave Jesús jei cuña pe: —Che jae ma ndeve: Emee taɨu. Reicuaa yave Tumpa oipota omee ndeve vae jare reicuaa yave quia co che, reyerureta tei co cheve jare che ameeta tei co ndeve ɨ tecove güɨnoi vae —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Carai —jei cuña Jesús pe—, nde mbaeti mbae renoi ɨ renoe pɨpe vaera, jare cuae ɨ mombɨrɨ oi ɨvɨgüɨ pe. ¿Quia güi pa reruta jocuae ɨ tecove güɨnoi vae? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Tuicha yae pa nembaepuere ñanetenondegua Jacob imbaepuere güi? Echa Jacob omee ñandeve cuae ɨ. Jae etei jare taɨ reta jare jɨmba reta oɨu cuae güi —jei cuña. ");
INSERT INTO guiNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús jei chupe: —Oipotagüe cuae ɨ güi oɨu vae ɨ oyúe yeta co. ");
INSERT INTO guiNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Erei oipotagüe ɨ che ameeta oɨu vae ngaraa ye iyúe —jei—. Echa jocuae ɨ che ameeta chupe vae oyeapota ipɨa pe metei ɨ jesaɨ vae rami. Jecuaeño omeeta chupe tecove opa mbae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Carai —jei cuña—, emee cheve cuae ɨ, agüɨye ye vaera ɨ ayúe jare agüɨye ye vaera ayu cuae pe ɨ anoe vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jayave Jesús jei chupe: —Ecua eeni neme peyu cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Mbaeti cheme —jei cuña. —Añete co rere: “Mbaeti cheme” —jei Jesús cuña pe—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Echa renoi ma cinco neme, jare jocuae cuimbae añave renoi vae mbaeti co neme. Añete co rere —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Carai —jei cuña—, añave aicuaa nde co jae metei Tumpa iñee omombeu vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ñanetenondegua reta omboete Tumpa cuae ɨvɨtɨ re. Erei pe reta pere Jerusalén pe oi Tumpa jo, jare joco peño iru vae reta vi omboeteta tei Tumpa —jei cuña. ");
INSERT INTO guiNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Chererovia, cuña —jei Jesús—. Outa ma ara agüɨye vaera pemboete cheRu cuae ɨvɨtɨ reño ani Jerusalén peño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pe reta pemaemboete yave, mbaeti peicuaa cavi mbae pemboete vae. Ore romaemboete yave, roicuaa cavi co mbae romboete vae. Echa iru vae reta oñemboasauca judío reta rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Erei outa ma ara - ou ma co - añetete Tumpa omboete vae omboete vaera Espíritu Santo rupi. Omboeteta añete vae rupi —jei—. Echa cheRu oeca cuae nunga jae reta omboete vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tumpa co jae Espíritu. Omboete vae reta tomboete Espíritu Santo rupi jare añete vae rupi —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jayave cuña jei Jesús pe: —Aicuaa Mesías outa co - jae co Cristo jee vae - jare jae ou yave, omombeuta ñandeve opaete mbaembae regua —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Jae co che chemiari ai nde ndive vae —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cuae jei oi yave, Jesús jemimboe reta yogüeru ovae. Ipɨacañɨ Jesús imiari oi cuña ndive vae re. Erei mbaeti metei ave jei chupe: “¿Mbae pa reipota?” ani “¿Maera pa nemiari jae ndive?” ");
INSERT INTO guiNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jayave cuña oeya iyɨru joco pe jare ojo ovae tenta pe. Jei cuimbae tenta pegua reta pe: ");
INSERT INTO guiNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Pecua peecha cuimbae opaete ayapogüe omombeu cheve vae. ¿Jae yepe ra Cristo? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jayave cuimbae reta oe tenta güi yogüeru Jesús cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuña ojo ma yave, Jesús jemimboe reta jei chupe: —Rabí, ecaru. ");
INSERT INTO guiNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Oime anoi cherembiura pe reta mbaeti peicuaa vae —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jayave jemimboe reta jei oyoupe: —¿Güeru ma ra quia mbae jou vaera? ");
INSERT INTO guiNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Che ayapo chembou vae oipota ayapo vaera vae, jare opaete iparavɨquɨ ayapo —jei Jesús—. Cuae co cherembiura rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pe reta pere: “Irundɨ yasɨ rupi mbaarɨvo oita ma co”. Erei che jae peve: Mase, pemae co reta re. Joco pe oi vae yagüɨye ma co. Ovae ma mbaarɨvo —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jare tecove opa mbae vae oñemee chupe vae oyearɨvo vae rami co. Jare temitɨ iya omboepɨ ombaarɨvo vae pe, omaetɨ vae jare ombaarɨvo vae oyerovia pave vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jocorai añete co cuae: “Metei vae omaetɨ jare iru vae ombaarɨvo” —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Che pomondo pearɨvo vaera mbaeti peparavɨquɨ jese vae. Iru vae reta oparavɨquɨ jese, jare pe reta pearɨvo jae reta oparavɨquɨ rambue —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jare jeta jocuae tenta pegua reta - Samaria pegua reta co - güɨrovia Jesús re cuña omombeu chupe reta vae jeco pegua. Echa cuña jei ma chupe reta: “Opaete ayapogüe omombeu cheve”. ");
INSERT INTO guiNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jayave Samaria pegua reta yogüeru ovae yave Jesús oia pe, jei chupe: —Ecua orerenta pe epɨta ore ndive. Jayave Jesús ojo opɨta joco pe mócoi ara. ");
INSERT INTO guiNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jare jeta iru vae reta oporogüɨrovia Jesús etei jei chupe reta vae jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jayave jei reta cuña pe: —Tenonde yave roporogüɨrovia nde rere oreve vae jeco pegua. Erei añave roporogüɨrovia ore etei roendu rambue, jare añave roicuaa cuae co jae ɨvɨ pegua reta omboasa vae Cristo jee vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mócoi ara rupi Jesús ojo joco güi Galilea cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Echa Jesús etei jei metei Tumpa iñee omombeu vae jentaɨgua reta mbaeti omboete. ");
INSERT INTO guiNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jayave Jesús ojo ovae yave Galilea pe, joco pegua reta omboresive cavi. Echa oecha reta ma opaete Jesús oyapo Jerusalén pe arete pe vae. Echa jae reta vi yogüɨraja arete pe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jayave Jesús ojo ovae Caná Galilea pegua pe. Joco pe tenonde yave oyapo ɨ vinora. Jare oico Capernaum pe metei mburuvicha. Cuae cuimbae taɨ imbaerasɨ oi. ");
INSERT INTO guiNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jare oicuaa yave Jesús ou ma co Judea güi ovae Galilea pe, ou ovae Jesús oia pe jare oyerure chupe taɨ re. —Ecua cherenta pe embogüera cheraɨ —jei—. Echa omanota ma. ");
INSERT INTO guiNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Mbaeti yave aechauca peve mɨacañɨ reta, ngaraa perovia cheré —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Carai —jei mburuvicha—, ecua cherenta pe agüɨye vaera cheraɨ omano. ");
INSERT INTO guiNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Ecua —jei Jesús chupe—. Nderaɨ oicove catu ye ma oi —jei. Jayave mburuvicha güɨrovia Jesús jei chupe vae jare ojo ye jenta cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jare ojo rambueve jenta cotɨ, jembiócuai reta yogüeru oovaiti jare jei chupe: —Oicove catu ye ma oi nderaɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jayave mburuvicha oparandu chupe reta: —¿Mbae ora pe pa omboɨpɨ ocuera? —Carumbue neimbove nungaño jacu opɨta chugüi —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jare cunumi tu oicuaa jocuae ora pe etei co Jesús jei chupe: “Nderaɨ oicove catu ye ma oi”. Jayave oporogüɨrovia jae jare opaete jo pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cuae mɨacañɨ oyapo Jesús oicuauca vaera quia co jae, ou yave Judea güi Galilea pe. Mocoia co cuae mɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cuae jaɨcue rupi judío reta oyapo ñogüɨnoi arete, jare Jesús ojo Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jare oime Jerusalén pe vecha reta oñemeea jonque iyɨpɨ pe metei ɨ jesaɨ vae tɨpɨ vae hebreo iñee pe Betesda jee vae. Oime cuae ɨ iyɨ́vɨri cinco o-raɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","O-raɨ japɨpe pe oñeno ñogüɨnoi jeta imbaerasɨ vae reta. Joco pe ñogüɨnoi jesa mbae vae reta, mbaeti ipuere oguata vae reta, jare mbaeti ipuere omɨi vae reta. Opaete cuae reta oaro ñogüɨnoi ɨ omɨi vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Echa amoamo pe ogüeyɨ metei araɨgua omomɨi vaera ɨ. Jare ɨ omɨi ma yave, jocuae imbaerasɨ vae tenonde voi oique ɨ pe vae ocuera oipotagüe imbaerasɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jare imbaerasɨ vae reta ipɨte pe oi metei cuimbae treinta y ocho año ma mbaeti ipuere oguata vae. ");
INSERT INTO guiNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús oecha cuimbae oñeno oi joco pe, jare oicuaa ɨma yae ma imbaerasɨ. Jayave oparandu chupe: —¿Reipota pa recuera? ");
INSERT INTO guiNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Carai —jei cuimbae—, mbaeti anoi quia cheñono vaera ɨ pe ɨ omɨi yave. Che aja rambueve, iru vae oique ɨ pe tenonde chegüi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jayave Jesús jei ye chupe: —Epúa evoɨ nderupa jare eguata. ");
INSERT INTO guiNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jayave cuimbae ocuera voi, jare ovoɨ jupa oguata. Jare jocuae ara mbutuu iara co. ");
INSERT INTO guiNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jayave judío reta jei cuimbae ocuera ma vae pe: —Cuae ara mbutuu iara co. Mbaeti jupi revoɨ vaera nderupa mbutuu iara pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cuimbae jei chupe reta: —Cuimbae chembogüera vae jei cheve: “Evoɨ nderupa jare eguata” —jei cheve, jei. ");
INSERT INTO guiNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jayave oparandu reta chupe: —¿Quia pa jae “Evoɨ nderupa jare eguata” jei ndeve vae? ");
INSERT INTO guiNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Erei ocuera vae - tenonde yave mbaeti ipuere oguata vae - mbaeti oicuaa. Echa jeta yae vae joco pe ñogüɨnoi jare Jesús ojo ma joco güi. ");
INSERT INTO guiNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ndei ɨma mbove Jesús ovae cuimbae Tumpa jo pe. —Recuera ma co. Jae rambue agüɨye ye eyapo icavi mbae vae. Echa reyapo ye yave, mbae icavi mbae yae vae oyeapota ndeve —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jayave cuimbae ojo omombeu judío reta pe Jesús co jae ombogüera ma vae. ");
INSERT INTO guiNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jare Jesús oyapo ma amogüe cuae nunga mɨacañɨ mbutuu iara pe. Cuae jeco pegua judío reta oipota oyapo icavi mbae vae chupe. Oipota vi oyuca. ");
INSERT INTO guiNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Erei Jesús jei chupe reta: —CheRu jecuae oparavɨquɨ, jare che vi aparavɨquɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cuae jeco pegua judío reta oipota yae oyuca Jesús. Echa Jesús oyapo mbutuu iara pe jae reta jei mbaeti jupi oyeapo vaera vae, jare Jesús imiari yave, jei: “Tumpa etei co cheRu”, jare cuae oipota jei jae vi co Tumpa etei. ");
INSERT INTO guiNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jayave Jesús jei ye chupe reta: —Añete che jae peve, che co jae Tumpa Taɨ. Che aeiño mbaeti mbae chepuere ayapo. Ayapo jocuae aecha cheRu oyapo oi vaeño. CheRu oyapo oi vae che vi ayapo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Echa cheRu cheraɨu jare oicuauca ma cheve opaete iparavɨquɨ. Jare oicuaucata vi cheve mbaravɨquɨ tuicha yae cuae reta güi vae, pepɨacañɨ yae vaera jese —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","CheRu omee tecove omanogüe vae reta pe. Jae ramiño vi che amee tecove amogüe vae reta pe. Amee aipota vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","CheRu ngaraa ojaa ɨvɨ pegua reta. Echa omaeñota cheré ajaa vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jocorai opaete vae chemboeteta omboete cheRu rami. Mbaeti chemboete vae mbaeti vi omboete cheRu. Echa che co jae Tumpa Taɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Añete che jae peve, cheñee peendu yave jare chembou vae perovia yave, penoi ma tecove opa mbae vae. Ngaraa ma peñejaauca. ");
INSERT INTO guiNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Añete che jae peve, outa ma ara - jaema ou - omanogüe vae reta oendu vaera cheñee - che co jae Tumpa Taɨ - jare oendu vae reta oicove yeta co —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Echa cheRu ipuere omee tecove. Jae ramiño vi omaeño cheré amee vaera tecove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jare cheRu omee cheve mbaepuere ajaa vaera ɨvɨ pegua reta che ayeapo cuimbaera rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Agüɨye pepɨacañɨ cuae re. Echa outa ma ara opaete omanogüe oñeotɨ oi vae reta oendu vaera cheñee —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Icavi vae oyapo vae reta oicove yeta yogüeru tecove opa mbae vae güɨnoi vaera, jare icavi mbae vae oyapo vae reta oicove yeta yogüeru oñejaauca vaera —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Che aeiño mbaeti mbae chepuere ayapo. Che aporojaa cheRu omombeu cheve vae rupi. Jae rambue aporojaa jupi vae rupi. Echa mbaeti ayapo cheremimbotaiño rupi. Ayapo chembou vae jemimbota rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yepe tei chemiari peve cheyee, erei añete vae co che amombeu peve vae. ");
INSERT INTO guiNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Oime iru chemombeu vae, jare aicuaa jae jei peve cheré vae añete co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Echa pe reta pemondo cuimbae reta Juan re oyeapɨsaca vaera, jare jae jei cheré vae añete co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Che mbaeti amonesesita quia chemombeu vaera, erei cuae che jae peve peñemboasauca vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan co jae metei mechero rami. Echa mechero jendɨ jare omee ñandeve tembipe. Ɨma ngatu mi rupi icavi echa peve peyerovia vaera tembipe Juan omee peve vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cuae mbaravɨquɨ ayapo vae reta chemombeu yae Juan güi. CheRu oipota opa ayapo vaera cuae mbaravɨquɨ reta, jare cuae ayapo vae rupi aicuauca iru vae reta pe cheRu chembou co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","CheRu chembou jare jae etei chemombeu. Mbaeti etei peendu cheRu iñee jare mbaeti etei peecha —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mbaeti peyapo cheRu jei peve peyapo vaera vae. Echa jae chembou, erei mbaeti chererovia —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jecuaeño pemongueta Tumpa iñee pe oyecuatía oi vae. Echa peñemongueta joco pe pevae quirai pepuere penoi tecove opa mbae vae. Jare Tumpa iñee pe oyecuatía oi vae che co chemombeu —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Erei mbaeti peipota perovia cheré tecove opa mbae vae amee vaera peve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Che mbaeti ayeco maemboete ɨvɨ pegua reta omee vae re. ");
INSERT INTO guiNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Echa aicuaa pe reta mbaeti peaɨu Tumpa pepɨa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Che ayu cheRu chembou rambue, erei pe reta mbaeti chemboresive. Iru vae ou yave jemimbota ae rupi, pemboresiveta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mbaeti etei pepuere peporogüɨrovia. Echa jecuaeño pe reta peñomboete, erei mbaeti peipota maemboete Tumpa oipota tei penoi vaera vae. Tumpa co jae meteiño —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Agüɨye peñemongueta che ayu pomboeco vaera cheRu jóvai. Echa Moisés oicuatía vae co pemboeco, yepe tei pe reta pere: “Ore royapo Moisés oicuatía vae rupi. Jae rambue icavita oreve”. Jocorai pere tei —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Echa Moisés oicuatía vae perovia yave, chereroviata tei co. Echa Moisés oicuatía vae chemombeu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Erei mbaeti perovia Moisés oicuatía vae rambue, ngaraa vi perovia cheñee —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cuae jaɨcue rupi Jesús ojo ovae ɨ guasu Galilea jovaicho pe. Jocuae ɨ guasu jee vi Tiberias. ");
INSERT INTO guiNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jare tenonde yave Jesús ombogüera amogüe imbaerasɨ vae reta, jare jeta yae vae oecha ma mɨacañɨ Jesús oyapo vae reta. Jae rambue añave cuae reta yogüɨraja Jesús jaɨcue. ");
INSERT INTO guiNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jayave Jesús ojo oyeupi ɨvɨtɨ re jare oguapɨ joco pe jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jare coiño ma ou judío reta iyarete pascua jee vae iara. ");
INSERT INTO guiNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jare Jesús omae yave, oecha jeta yae vae yogüeru icotɨ. Jayave oparandu Felipe pe: —¿Quiape pa ñandepuereta yagua mbɨyape cuae reta jou vaera? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jare cuae Jesús jei oicuaa vaera mbae ra jeita Felipe. Echa Jesús oicuaa ma mbae oyapota vae. ");
INSERT INTO guiNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe jei chupe: —Doscientos denario pegua mbɨyape ngaraa oupitɨ cuae reta jou vaera, metei ñavo mbovɨño jou yave. ");
INSERT INTO guiNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Metei Jesús jemimboe Andrés jee vae - jae co Simón Pedro tɨvɨ - jei Jesús pe: ");
INSERT INTO guiNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Oime cuae pe oi metei cunumi cinco mbɨyape jare mócoi jevae ɨ rupigua güɨnoi vae. Erei jocuae mbovɨ yae co cuae jeta yae vae jou vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Pemombeu chupe reta oguapɨ vaera —jei Jesús. Jare jeta capiata oi joco pe. Jayave oguapɨ reta. Jare cuimbae reta cinco mil rupi ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jayave Jesús oipɨɨ jocuae mbɨyape jare omee yasoropai Tumpa pe. Jayave omee mbɨyape jemimboe reta pe, jare jemimboe reta omee oguapɨ vae reta pe. Jae ramiño vi omee jevae ɨ rupigua chupe reta. Jare opaete vae jou jare jɨvata. ");
INSERT INTO guiNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jayave jɨvata reta ma yave, Jesús jei jemimboe reta pe: —Pemboatɨ tembíu oñepɨsaegüe jembɨre vae, agüɨye vaera mbae oñemombo —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Echa jocuae cinco mbɨyape güi jembɨre mbɨyape oñepɨsaegüe jare oyeeya joco pe, opa ma ocaru reta yave. Jayave Jesús jemimboe reta omboatɨ jare omotɨnɨe doce canasta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jare joco pe ñogüɨnoi vae reta oecha ma yave cuae mɨacañɨ Jesús oyapo vae, jei reta: —Cuae cuimbae jocuae Tumpa iñee omombeu vae etei co. Echa Tumpa iñee pe oyecuatía oi outa co ɨvɨ pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jare Jesús oicuaa yogüeruta oipɨɨ oyapo vaera juvicha guasura, yepe tei jae mbaeti oipota. Jayave ojo chugüi reta ɨvɨtɨ re. Jaeiño ojo. ");
INSERT INTO guiNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jare caaru yae ma yave, Jesús jemimboe reta ogüeyɨ yogüɨraja ɨ guasu pe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joco pe oyeupi chalana pe jare omboɨpɨ oasa ɨ guasu rupi Capernaum cotɨ. Pɨtumimbi ma oi, jare Jesús mbaetiño ou jae reta ñogüɨnoia pe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jayave tanta oyepeyu ɨvɨtu jare ɨaparúa tuicha yae ma. ");
INSERT INTO guiNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Güɨroata reta ma yave chalana metei legua rupi ndipo, oecha Jesús oguata ou ɨ iárambue jare ou coiño ma chalana güi. Jayave oquɨye reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Erei Jesús jei chupe reta: —Che co. Agüɨye pequɨye —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jayave oyerovia reve jae reta omboyeupi Jesús chalana pe, jare jupiveiño chalana ojo ovae ɨvɨ pe oipota yogüɨraja ovaea pe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pɨareve pe jeta yae vae jecuaeño opɨta ɨ guasu jovaicho pe. Oecha meteiño chalana joco pe oi ndei Jesús jemimboe reta yogüɨraja pɨpe mbove. Jare oicuaa Jesús mbaeti ojo chalana pe jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Erei iru chalana tenta Tiberias güi yogüeru vae reta opɨta coiño ocaru ñogüɨnoia güi. Echa joco pe jae reta jou mbɨyape ñandeYa omee güire yasoropai Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oicuaa reta ma Jesús jare jemimboe reta mbaeti joco pe ñogüɨnoi. Jayave oyeupi reta jocuae chalana reta pe jare yogüɨraja Capernaum cotɨ, Jesús oeca vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɨ guasu oasa reta ma yave, ovae Jesús jare jei reta chupe: —Rabí, ¿quirai yave pa reyu cuae pe? ");
INSERT INTO guiNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jayave Jesús jei chupe reta: —Añete che jae peve, pe reta chereca jocuae mbɨyape pemoɨvata vae jeco peguaño, mbaeti chereca jocuae mɨacañɨ pe aipota aicuauca peve vae jeco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Agüɨye peparavɨquɨ perembiura mbaeti ɨma ondurata vae jeco peguaño. Erei peparavɨquɨ perembiura ameeta peve vae jeco pegua. Che ayeapo cuimbaera vae ameeta peve perembiura ɨma yae ondurata vae. Echa penoita tecove opa mbae vae. Echa cheRu Tumpa oicuauca ma peve chepuere ayapo jocorai —jei Jesús chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jayave oparandu reta Jesús pe: —¿Mbae pa royapota? ¿Quirai pa orepuere royapo mbaravɨquɨ Tumpa oipota royapo vaera vae? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jayave Jesús jei: —Perovia cheré. Cuae co mbaravɨquɨ Tumpa oipota peyapo vaera vae. Echa jae chembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jayave jei reta chupe: —¿Mbae nunga mɨacañɨ pa reyapota, roecha vaera jare rogüɨrovia vaera nderé? ¿Mbae nunga mbaravɨquɨ pa reyapota nde? —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ñanetenondegua reta jou maná ñuu pe. Echa Tumpa iñee pe oyecuatía oi: “Omee chupe reta jembiura ara güi jou reta vaera” —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Añete che jae peve —jei Jesús—, Moisés mbaeti co omee jembiura ara güi ou vae. Añave cheRu omeeta peve perembiura añetete vae ara güi ou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Echa tembíu Tumpa añave omeeta vae jocuae ara güi ou vae co. Jae omeeta tecove ɨvɨ pegua reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Carai —jei reta—, jecuaeño emee oreve cuae nunga orerembiura. ");
INSERT INTO guiNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Che co jae jocuae tembíu tecove omeeta vae —jei Jesús—. Oipotagüe cheré guɨrovia vae ngaraa ñɨmbɨaɨ, jare oipotagüe cheré güɨrovia vae ngaraa iyúe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Erei che jae ma peve corai: Mbaeti perovia, yepe tei cherecha ma. ");
INSERT INTO guiNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Opaete cheRu omee cheve vae reta güɨroviata co cheré —jei—, jare oipotagüe cheré güɨrovia vae ngaraa amombo. ");
INSERT INTO guiNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Echa agüeyɨ ayu ara güi ayapo vaera chembou vae jemimbota. Mbaeti ayu cheremimbota aeño ayapo vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ngaraa amocañɨ metei ave opaete cheRu omee ma cheve vae reta güi. Echa amoingove yeta aru omanogüe vae reta ipɨte güi ara taɨcuegua pe. Cuae oipota chembou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Oipotagüe cherecha vae güɨnoita tecove opa mbae vae cheré güɨrovia yave, jare che amoingove yeta aru omanogüe vae reta ipɨte güi ara taɨcuegua pe. Cuae oipota cheRu —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jayave judío reta iñeenguru oyoupe. Echa Jesús jei ma: “Che co jae tembíu ara güi ou vae”. ");
INSERT INTO guiNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jare judío reta jei: —Cuae co jae Jesús. Jae co José taɨ. Yaicuaa co tu jare ichɨ. ¿Quirai pa ipuere jei “Agüeyɨ ayu ara güi”? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jayave Jesús jei chupe reta: —Agüɨye peñeenguru oyoupe checotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","CheRu chembou —jei—. CheRu güɨroviauca cheré vaeño ipuere güɨrovia cheré. Jare che amoingove yeta aru omanogüe vae reta ipɨte güi ara taɨcuegua pe —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tumpa iñee aracae omombeu vae oicuatía corai: “Jare Tumpa omboeta opaete vae”. Jocorai oicuatía —jei—. Oipotagüe oyeapɨsaca Tumpa re jare oñemboe Tumpa jei chupe vae re vae outa cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mbaeti quia oecha cheRu, jaeño che ayu Tumpa güi vae. Che aecha ma co cheRu —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Añete che jae peve, cheré güɨrovia vae güɨnoi tecove opa mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Che co jae jocuae tembíu tecove omee vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Petenondegua reta jou jocuae maná ñuu pe jare omano reta ma. ");
INSERT INTO guiNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Che co jae tembíu ara güi ou vae. Cuae tembíu jou vae ngaraa omano —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Che co jae tembíu tecove omee vae. Che agüeyɨ ayu ara güi. Oipotagüe cuae tembíu jou vae güɨnoita tecove opa mbae vae —jei Jesús chupe reta—. Jare jocuae tembíu ameeta vae cherete co. Ameeta cherete ɨvɨ pegua reta güɨnoi vaera tecove —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jayave judío reta oyoaca oyoupi. —¿Quiraita ra ipuere cuae cuimbae omee ñandeve jete yau vaera? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Añete che jae peve —jei Jesús chupe reta—, mbaeti yave peu cherete jare cherugüɨ, ngaraa tecove opa mbae vae penoi. Che co jae cuimbaera oyeapo vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cherete jare cherugüɨ jou vae güɨnoi tecove opa mbae vae, jare amoingove yeta aru omanogüe vae reta ipɨte güi ara taɨcuegua pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Echa cherete jare cherugüɨ tembíu añetete vae co —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cherete jare cherugüɨ jou vae oico che ndive jare che aico jae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","CheRu güɨnoi tecove opa mbae vae jare jae chembou, jare che anoi tecove opa mbae vae cheRu güi. Jae ramiño vi jocuae cherete jou vae güɨnoita tecove opa mbae vae chegüi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Che co jae tembíu ara güi ou vae. Cuae tembíu mbaeti co jocuae tembíu petenondegua reta jou vae rami. Echa jae reta omano. Erei oipotagüe cuae tembíu jou vae güɨnoita tecove opa mbae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jocorai jei Jesús judío reta itupao pe, Capernaum pe oporomboe oi yave. ");
INSERT INTO guiNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cuae oendu reta yave, jeta Jesús jemimboe reta jei oyoupe: —Mbaeti co icavi cuae jei vae. Agüɨye yayeapɨsaca cuae nunga ñee re —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús oicuaa jemimboe reta iñeenguru co icotɨ. Jayave jei chupe reta: —¿Maera pa peñeenguru checotɨ cuae re? ");
INSERT INTO guiNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Mbae pa peyapota cherecha yave ayeupi aja tenonde aicoa pe? Che co jae cuimbaera oyeapo vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jaeño Espíritu Santo ipuere omee tecove opa mbae vae. Ñanderete mbaeti ipuere omee ñandeve cuae nunga tecove. Cuae amombeu ma peve vae mbaeti co ɨvɨ peguaño. Jae co tecove opa mbae vae pegua —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Erei amogüe pe reta mbaeti perovia cheré —jei. Echa Jesús oicuaa iyɨpɨ güive quia reta mbaeti güɨrovia jese jare quia omoeterengata jovaicho reta pe. ");
INSERT INTO guiNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jayave jei ye chupe reta: —Jae rambue amombeu ma peve quirai cheRu güɨroviauca cheré vaeño ipuere güɨrovia cheré —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cuae jaɨcue rupi jeta jemimboe reta yogüɨraja ye Jesús güi, jare mbaeti ye yogüɨraja jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jayave Jesús oparandu jocuae doce vae reta pe: —¿Peota pa chegüi pe reta vi? ");
INSERT INTO guiNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—¿Quia nunga cotɨ pa rojota, oreYa? —jei Simón Pedro chupe—. Nde co remombeu oreve tecove opa mbae vae regua. ");
INSERT INTO guiNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jare rogüɨrovia ma nderé jare roicuaa ma nde co jae Tumpa oñono tee iyeupeguara vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jayave Jesús jei: —Che poparavo. Pe reta co doce. Jare metei pepɨte pe oi vae oyeócuai aña guasu pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Corai imiari Judas re. Judas co jae Simón Iscariote taɨ. Echa Jesús oiparavo doce jare jae reta güi metei co jae Judas. Judas omoeterengata Jesús jovaicho reta pe. ");
INSERT INTO guiNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cuae jaɨcue rupi Jesús ojo tenta Galilea pegua reta pe. Mbaeti ojo Judea pe. Echa judío reta oipota oyuca. ");
INSERT INTO guiNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jare outa ma ovae judío reta iyarete tabernáculos jee vae iara. ");
INSERT INTO guiNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jayave Jesús tɨvɨ reta jei chupe: —Ecua cuae güi Judea pe, neremimboe reta oecha vaera mbaravɨquɨ reyapo vae. ");
INSERT INTO guiNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Echa oime yave quia oipota iru vae reta oicuaa cavi vaera jesegua vae, mbaeti oyapo vɨari iparavɨquɨ. Reyapo co cuae mbaravɨquɨ. Jae rambue eyapo opaete vae jovaque —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Echa tɨvɨ reta vi mbaeti güɨrovia jese. ");
INSERT INTO guiNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jayave Jesús jei chupe reta: —Ndei ovae jocorai ayapo vaera, erei jecuaeño pe reta pepuere peyapo peparavɨquɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɨvɨ pegua reta mbaeti ipuere pemotareɨ, erei ɨvɨ pegua reta chemotareɨ. Echa che amombeu chupe reta icavi mbae vae co jae oyapo reta vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pe reta pecua arete pe. Che ndei rani ajata cuae arete pe. Echa ndei ovae che aja joco pe vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jocorai jei chupe reta Jesús, jare opɨta Galilea pe. ");
INSERT INTO guiNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cuae jaɨcue rupi tɨvɨ reta yogüɨraja ma yave arete pe, Jesús vi ojo. Mbaeti ojo jeta vae jupíe agüɨye vaera oecha reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jare judío reta oeca ñogüɨnoi Jesús arete pe. —¿Quiape pa oime oi? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jare joco pe ñogüɨnoi vae reta oyoaca yae oyoupi Jesús re. Amogüe vae jei: —Cuimbae jecocavi vae co jae. Iru vae reta jei: —Mbaeti co jecocavi. Oporombotavɨ vae co. ");
INSERT INTO guiNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Erei opaete vae oquɨye judío reta güi. Jae rambue imiari vɨariño. ");
INSERT INTO guiNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Arete mbɨte ma yave, Jesús ojo Tumpa jo pe omboɨpɨ oporomboe. ");
INSERT INTO guiNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jare judío reta ipɨacañɨ. —¿Quirai ra jeta oicuaa cuae cuimbae mbaeti mbaembae re oñemboe vae? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jayave Jesús jei chupe reta: —Cheporomboe mbaeti co chembae aeño. Jae co chembou vae iporomboe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Oipotagüe Tumpa jemimbota oipota oyapo vae oicuaata cheporomboe Tumpa iporomboe co. Oicuaata mbaeti co chembae aeño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oipotagüe vae iporomboe imbae aeño yave, jae oipota iru vae reta omboete vaera. Erei oporomboe vae oipota yave iru vae reta omboete vaera ombou vae, jae oporomboe añete vae re. Mbaeti co iyapu —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés omee peve mboroócuai. Erei mbaeti metei ave pe reta peyapo mboroócuai pe oyecuatía oi vae rupi —jei—. ¿Maera pa peipota cheyuca? —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jayave judío reta jei: —Aña oya ma nderé. ¿Quia pa oipota ndeyuca? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Ayapo ma metei mbaravɨquɨ —jei Jesús—, jare opaete pe reta pepɨacañɨ jese. ");
INSERT INTO guiNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés omombeu peve peñemocircuncidauca vaera. Erei mbaeti oñemboɨpɨ Moisés omombeu yave. Echa Moisés itenondegua reta oyapo jocorai. Jare pe reta peporomocircuncidauca mbutuu iara pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Che ambogüera ma metei cuimbae mbutuu iara pe. Opaete jete ocuera cavi ma. ¿Maera pa pepochɨ cheve cuae jeco pegua? Echa pe reta peporomocircuncidauca mbutuu iara pe mboroócuai Moisés omombeu peve vae mbaeti peipota peyavɨ rambue —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Agüɨye peporojaa peecha vae rupiño. Peporojaa cavi jupi vae rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jae rambue amogüe Jerusalén pegua reta jei: —¿Jaea ra cuae judío reta oipota oyuca vae? ");
INSERT INTO guiNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mase, co oi cuae pe, jare imiari oi opaete vae pe. Erei mbaeti quia mbae jei chupe. Güɨramoi ñanderuvicha reta oicuaa ma jae co Cristo —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Erei yaicuaa quetɨ güi ou cuae cuimbae. Echa Cristo oyecuaa yave, ngaraa quia oicuaa quetɨ güi ou —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jae rambue Jesús oporomboe oi rambueve Tumpa jo pe, iñeeata reve jei: —Pe reta checuaa co, jare peicuaa co quetɨ güi ayu. Erei mbaeti ayu cheremimbota rupiño. Echa chembou vae imiari añete vae re, jare pe reta mbaeti peicuaa chembou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Erei che aicuaa. Echa ayu jae oia güi. Jae chembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jae rambue judío reta oipota tei oipɨɨ. Erei mbaeti quia oipɨɨ. Echa ndei ovae oyepɨɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jare jeta joco pe ñogüɨnoi vae güɨrovia jese. Echa jei reta: —Cristo ou yave, ¿oyapota ra jeta yae mɨacañɨ cuae cuimbae oyapo vae güi? ");
INSERT INTO guiNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jare fariseo reta oendu jeta vae iñeenguru ñogüɨnoi Jesús re. Jayave sacerdote reta itenondegua reta jare fariseo reta ombou jembiócuai reta oipɨɨ vaera Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jayave Jesús jei: —Aita pe reta ndive michi peguaño. Jayave ajata chembou vae pɨri. ");
INSERT INTO guiNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cherecata co, erei ngaraa chevae. Ngaraa peo che aitaa pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jayave judío reta jei oyoupe: —¿Quetɨ ra ojota cuae cuimbae agüɨye vaera ñavae chupe? Ojota ndipo judío reta judío mbae vae reta ipɨte rupi oñemoai vae pɨri. Omboeta ndipo judío mbae vae reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mbae ra oipota jei, imiari yave corai: “Cherecata co, erei ngaraa chevae. Ngaraa peo che aitaa pe”? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jocuae ara arete opata yave icavi yae opaete iru arete iara reta güi. Jayave Jesús oñemboɨ jare iñeeata reve jei: —Oime yave quia iyúe vae tou cheve toɨu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cheré güɨrovia vae güi osɨrɨta jeta ɨ tecove omee vae. Jocorai Tumpa iñee pe oyecuatía oi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jocorai imiari Jesús Espíritu Santo re. Oipota jei omeeta Espíritu Santo güɨrovia jese vae reta pe. Echa ndei omee Espíritu Santo. Echa Jesús ndei ojo ye ara pe. ");
INSERT INTO guiNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cuae oendu yave, amogüe joco pe ñogüɨnoi vae jei: —Cuae cuimbae jocuae Tumpa iñee omombeu vae etei co. ");
INSERT INTO guiNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iru vae reta jei: —Cuae cuimbae Cristo co. Erei amogüe vae jei: —¿Galilea pegua ra Cristo? ");
INSERT INTO guiNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Echa Tumpa iñee pe oyecuatía oi Cristo co jae David iñemoña reta pegua jare Belén pegua co. Echa David joco pegua co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesús jei chupe reta vae jeco pegua, joco pe ñogüɨnoi vae reta oyoaca oyoupi. ");
INSERT INTO guiNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jare amogüe vae oipota tei oipɨɨ Jesús, erei mbaeti quia oipɨɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jayave tembiócuai sacerdote reta itenondegua reta jare fariseo reta ombou vae reta yogüɨraja ye chupe reta. Jayave sacerdote reta itenondegua reta jare fariseo reta jei jembiócuai reta pe: —¿Maera pa mbaeti peru? ");
INSERT INTO guiNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jembiócuai reta jei: —Echa mbaeti etei quia imiari jocuae cuimbae imiari rami. ");
INSERT INTO guiNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jayave fariseo reta jei: —¿Peñembotavɨ ma pa pe reta vi? ");
INSERT INTO guiNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Güɨrovia ma ra jese mburuvicha reta jare fariseo reta? Mbaeti metei ave —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Erei cuae jeta vae mbaeti oicuaa mboroócuai pe oyecuatía oi vae. Tumpa oiporaraucata co chupe reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jayave metei jae reta ipɨte pe oi vae jei iru reta pe - jae co Nicodemo jee vae - tenonde yave jae ojo opou Jesús pɨri pɨtu yave: ");
INSERT INTO guiNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Mboroócuai pe oyecuatía oi vae rupi mbaeti ñandepuere ñajaa oipotagüe vae ndei yayeapɨsaca jese mbove. Echa yayeapɨsaca jese yave, yaicuaa mbae oyapo vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iru reta jei chupe: —¿Nde vi ra Galilea pegua? Reeca yave, reicuaata mbaeti co metei ave Tumpa iñee omombeu vae Galilea pegua —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jayave opaete vae yogüɨraja jo ae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Erei Jesús ojo ɨvɨtɨ Oliva jee vae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pɨareve pe neimbove asɨ Jesús ojo ye Tumpa jo pe. Jayave jeta vae yogüeru jae oia pe, jare jae oguapɨ omboe reta oi. ");
INSERT INTO guiNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jayave mboroócuai re oporomboe vae reta jare fariseo reta güeru metei cuña. Oipocou reta cuña menda re oñuvanga oi yave. Jayave oñono reta joco pe ñogüɨnoi vae reta jenonde. ");
INSERT INTO guiNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Oporomboe vae —jei reta Jesús pe—, cuae cuña roipocou menda re oñuvanga oi yave. ");
INSERT INTO guiNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mboroócuai pe Moisés ñandeócuai yayuca vaera cuae nunga cuña ita pe. ¿Mbae pa rere nde cuae re? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cuae jei reta oicuaa vaera mbae ra jeita Jesús. Echa oipota omboeco. Jayave Jesús oñaɨvɨ jare oicuatía mbae ɨvɨ re ipoaca pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jecuaecuae oparandu reta chupe cuae re. Jayave Jesús oñemboɨ jare jei chupe reta: —Mbaeti mbaeyoa güɨnoi pepɨte pe vae rani toyapi ita pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jayave oñaɨvɨ ye jare oicuatía ye mbae ɨvɨ re ipoaca pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Erei cuae oendu reta yave, ipɨa ñavo omboeco jeco re jare yogüɨraja joco güi meteitei pe. Tenonde yogüɨraja indechi vae reta. Jayave opaete vae yogüɨraja. Jaeño Jesús opɨta joco pe cuña jae jóvai oñemboɨ oi vae ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jayave Jesús oñemboɨ ye omae jese, jare jei: —¿Jama pa jocuae cuimbae reta, cuña? ¿Mbaeti ma pa quia nemboeco? ");
INSERT INTO guiNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Mbaeti co quia, carai —jei cuña chupe. Jayave Jesús jei: —Che vi mbaeti romboeco. Ecua, agüɨye ye eyapo jocuae mbaeyoa —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cuae jaɨcue rupi Jesús jei yatɨ vae reta pe: —Che co jae metei tembipe rami. Ayu co ɨvɨ pegua reta oecha cavi vaera. Oico che ndive vae ngaraa oguata pɨtumimbi pe. Echa güɨnoita tecove ipuere vaera oecha cavi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jayave fariseo reta jei Jesús pe: —Remombeu oreve vae ngaraa rogüɨrovia. Echa nde nemiari ndeyee —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Amombeu ma peve vae pepuere perovia, yepe tei chemiari peve cheyee —jei Jesús—. Echa che aicuaa co quetɨ güi ayu jare quetɨ aja. Erei pe reta mbaeti peicuaa quetɨ güi ayu jare quetɨ aja. ");
INSERT INTO guiNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pe reta peporojaa opaete ɨvɨ pegua reta oporojaa rami. Che mbaeti quia ajaa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Erei aporojaa yave, aporojaa añete vae rupi. Echa cheRu chembou. Jare che jare cheRu roporojaa - mbaeti che aeiño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Peporoócuai pe oyecuatía oi corai: “Mócoi jeigüe oyovaque yave, peroviata co”. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chemiari peve cheyee jare cheRu chemombeu peve - jae co chembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jayave judío reta jei: —¿Jama pa ndeRu? —Pe reta mbaeti checuaa jare mbaeti peicuaa cheRu —jei Jesús chupe reta—. Checuaa yave mona, cheRu vi peicuaata tei co —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Cuae jei Jesús Tumpa jo pe corepoti Tumpa pegua jɨru reta ñogüɨnoia pe. Echa joco pe oporomboe. Erei mbaeti quia oipɨɨ. Echa ndei ovae oyepɨɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jare Jesús jei ye chupe reta: —Ajata ma cuae güi. Pe reta cherecata co, erei pemanota pembaeyoa oñemboai mbae reve. Pe reta ngaraa pepuere peo che ajataa pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—¿Oyeyucata ra? —jei judío reta—. Echa jei ma: “Pe reta ngaraa pepuere peo che ajataa pe”. ");
INSERT INTO guiNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jayave Jesús jei: —Pe reta ɨvɨ pegua reta co, erei che ara pegua co. Pe reta ɨvɨ pegua reta co, erei che mbaeti co cuae ɨvɨ pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amombeu ma peve pemanota pembaeyoa oñemboai mbae reve. Echa pemanota co pembaeyoa oñemboai mbae reve, mbaeti yave perovia che co jae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jayave jei reta Jesús pe: —¿Quia pa co nde? —Jocuae tenonde güive amombeu ma peve vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jeta mbaembae re chepuere chemiari peré jare jeta mbae re chepuere pojaa. Erei chembou vae imiari añete vae re, jare amombeu ɨvɨ pegua reta pe chembou vae omombeu cheve vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jae reta mbaeti oicuaa Jesús imiari chupe reta Tu ara pe oi vae re. ");
INSERT INTO guiNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jayave Jesús jei: —Pe reta chereupi ma yave - che ayeapo cuimbaera vae - peicuaata che co jae. Mbaeti mbae ayapo cheremimbota rupiño. CheRu omombeu cheve vae rupiño chemiari —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jare chembou vae oico che ndive. Mbaeti chereya cheiño aico vaera. Echa jecuaeño ayapo jae oipota vae rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jare jocorai Jesús imiari yave, jeta vae güɨrovia jese. ");
INSERT INTO guiNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jayave Jesús jei jocuae judío güɨrovia jese vae reta pe: —Jecuaeño peyapo yave che jae peve peyapo vaera vae, peicota co cheremimboe añetete vae retara. ");
INSERT INTO guiNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jare peicuaata añete vae, jare añete vae peyorata co —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Judío reta jei chupe: —Abraham iñemoña reta co ore. Mbaeti etei royeócuai quia pe. ¿Maera pa rere royeyorata co? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Añete che jae peve —jei Jesús—, iyoa vae oyeócuai oi mbaeyoa pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Oyeócuai vae mbaeti jecuaeño opɨta o pe. Erei o iya taɨ jecuaeño opɨta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Che co jae Tumpa Taɨ. Che poyora yave mbaeyoa güi, peyeyora eteta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Che aicuaa Abraham iñemoña reta co pe reta. Erei peipota cheyuca, mbaeti peipota peyapo che jae peve peyapo vaera vae rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chemiari peve cheRu ndive aico yave aecha vae re, jare pe reta peyapo peru omombeu peve peyapo vaera vae rupi —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abraham co jae oreru —jei reta. —Pe reta Abraham taɨ reta añetete vae yave mona —jei Jesús—, peyapota tei co Abraham oyapo vae rami. ");
INSERT INTO guiNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Erei añave peipota cheyuca, yepe tei amombeu ma peve añete vae. Jae co Tumpa omombeu cheve vae. Mbaeti corai oyapo Abraham —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pe reta peyapo pei peru iparavɨquɨ —jei Jesús chupe reta. —Mbaeti co oremoñemoña aguasa pe oreru reta —jei reta—. Tumpaño co jae oreRu. ");
INSERT INTO guiNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jayave Jesús jei chupe reta: —Tumpa co jae peRu yave mona, pe reta cheraɨuta tei co. Echa che ayu Tumpa güi. Che Tumpa pegua co. Mbaeti che aipota rambueño ayu. Jae co chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Maera pa mbaeti peicuaa amombeu peve vae? Mbaeti peipota peyeapɨsaca cheñee re. Jae rambue mbaeti peicuaa —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aña guasu co jae peru, jare pe reta peipota peyapo peru oipota vae rupi. Peru jecuaeño oporoyuca oico, jare mbaeti etei oyapo añete vae rupi. Echa mbaeti etei añete vae pegua. Jae co aña guasu. Jae rambue jecuaeño iyapu. Echa jae co iyapu vae jare omboe ɨvɨ pegua reta iyapu vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Erei pe reta mbaeti chererovia, añete vae amombeu peve rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mbaeti metei yepe pepuere pere cheve: “Ndeyoa co”. Echa che amombeu peve añete vae. ¿Maera pa mbaeti chererovia? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tumpa taɨ reta oyeapɨsaca Tumpa iñee re. Pe reta mbaeti co Tumpa taɨ reta. Jae rambue mbaeti peyeapɨsaca jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jayave judío reta jei: —Roe ma nde co jae metei Samaria pegua, jare aña oya ma nderé. Añete co cuae roe vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Mbaeti co oya cheré aña —jei Jesús—. Che amboete ai cheRu, erei pe reta chereroɨro. ");
INSERT INTO guiNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Erei mbaeti aipota ɨvɨ pegua reta chemboete vaera. Oime co quia oipota chemboeteuca vae. Jae oporojaata co —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Añete che jae peve, oyapo che jae chupe oyapo vaera vae ngaraa omano —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jayave judío reta jei Jesús pe: —Añave roicuaa ma aña oya co nderé. Abraham jare Tumpa iñee aracae omombeu vae reta omano. Erei nde rere: “Oyapo che jae chupe oyapo vaera vae ngaraa omano”. ");
INSERT INTO guiNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tuicha yae pa nembaepuere ñanetenondegua Abraham imbaepuere güi? Echa Abraham omano. Jae ramiño vi Tumpa iñee aracae omombeu vae reta omano. ¿Quia pa co nde? ¿Mbae pa rere ndeyee? —jei reta Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Mbaeti etei añemboete —jei Jesús—. Echa jocorai ayapo yave, jocuae nunga maemboete mbaeti co mbae. Erei cheRu chemboeteuca, jare pe reta pere Tumpa co jae peRu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Erei pe reta mbaeti peicuaa Tumpa. Che aicuaa co. Che jae yave: “Mbaeti aicuaa”, cheaputa tei co pe reta peapu rami. Erei aicuaa co, jare ayapo jei cheve ayapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Petenondegua Abraham oyerovia cherechata rambue. Cherecha co jare oyerovia —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jayave judío reta jei chupe: —Nde ndei renoi cincuenta año. ¿Quirai pa ndepuere rere reecha co Abraham? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Añete che jae peve —jei Jesús—, ndei Abraham oico mbove, che jecuaeño mai aico —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jayave judío reta omonoo ita reta oyapi vaera tei pɨpe Jesús. Erei Jesús oasa jae reta ipɨte rupi oe Tumpa jo güi, jare jae reta mbaeti ma oecha. ");
INSERT INTO guiNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jare Jesús oasa ojo yave, oecha metei cuimbae jesa mbae vae. Cuae cuimbae jocorai oico ichɨ güi oa güive. ");
INSERT INTO guiNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jayave Jesús jemimboe reta oparandu Jesús pe: —Rabí, ¿quia pa iyoa, ichɨ güi oa vaera jesa mbae? ¿Iyoa pa jae etei? ¿Iyoa pa tu jare ichɨ? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Mbaeti jae imbaeyoa jeco pegua jare mbaeti tu jare ichɨ imbaeyoa jeco pegua corai oi —jei Jesús—. Corai oi Tumpa imbaepuere oyecuaa vaera ocuera yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Icavi co ayapo vaera ara rupi chembou vae iparavɨquɨ. Echa ara rupi ñanoi tembipe. Erei outa pɨtu, jare pɨtu yave mbaeti quia ipuere oparavɨquɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cuae ɨvɨ pe aico rambueve, che co jae metei tembipe rami. Ayu co ɨvɨ pegua reta oecha cavi vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cuae jei ma yave, ondɨvɨ ɨvɨ re jare jocuae güi oyapo tuyuapo. Jayave oñono tuyuapo cuimbae jesa re. ");
INSERT INTO guiNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jayave jei chupe: —Ecua eyoe nderesa ɨ Siloé pe. (Cuae Siloé oipota jei: Oñemondo.) Jayave cuimbae ojo oyoe jesa jare ou ye yave, omae ma. ");
INSERT INTO guiNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jayave cuimbae jenta pegua reta jare iru tenonde oecha oyerure oi corepoti re vae reta jei: —¿Jaea ra cuae oguapɨ oyerure corepoti re vae? ");
INSERT INTO guiNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amogüe vae jei: —Jae co. Iru vae reta jei: —Mbaeti co. Erei oguacatu vae co. Erei cuimbae jei: —Che etei co. ");
INSERT INTO guiNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jayave jei reta chupe: —¿Quirai pa añave ndepuere remae? ");
INSERT INTO guiNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jocuae cuimbae Jesús jee vae oyapo tuyuapo oñono cheresa re —jei cuimbae chupe reta—. Jayave jei cheve: “Ecua Siloé pe eyoe nderesa” —jei cheve, jei—. Jae rambue aja ayoe cheresa, jare amae ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Quiape pa oime oi? —jei reta. —Mbaeti aicuaa —jei cuimbae chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jayave jae reta güɨraja fariseo ñogüɨnoia pe cuimbae tenonde yave jesa mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jare jocuae ara mbutuu iara co. Echa jocuae ara Jesús oyapo tuyuapo omomae vaera cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jayave fariseo reta vi oparandu cuimbae pe quirai ra ipuere omae. —Oñono tuyuapo cheresa re —jei cuimbae—. Jayave ayoe cheresa, jare amae ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amogüe fariseo reta jei: —Mbaeti co Tumpa pegua cuae cuimbae. Echa oyapo mbutuu iara pe mboroócuai pe jei agüɨye yayapo vaera vae. Erei iru fariseo reta jei: —¿Quirai ra ipuere cuimbae iyoa vae oyapo cuae nunga mɨacañɨ? Jare oyoaca reta oyoupi. ");
INSERT INTO guiNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jayave jei reta ye cuimbae tenonde yave jesa mbae vae pe: —¿Mbae pa rere nde jocuae nemomae vae re? —Jae co metei Tumpa iñee omombeu vae —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judío reta mbaeti güɨrovia tenonde yave jesa mbae vae co jocuae cuimbae. Mbaeti güɨrovia vi jaeramo co omae. Jae rambue oeniuca cuimbae omae ma vae tu jare ichɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jayave oparandu reta tu jare ichɨ pe: —¿Jae pa co cuae nderaɨ jesa mbae co oa pere chupe vae? ¿Quirai pa añave omae? ");
INSERT INTO guiNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Aicuaa jae co cheraɨ jesa mbae co oa ichɨ güi vae —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Erei mbaeti roicuaa quirai ra añave omae. Mbaeti vi roicuaa quia ra omomae. Peparandu chupe. Echa ocuacuaa ma co jae. Jae etei ipuere omombeu peve —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jocorai jei cuimbae tu jare ichɨ, oquɨye judío reta güi rambue. Echa judío reta jei ma oyoupe: “Jocuae Jesús co jae Cristo jei vae toñemombo ñandetupao güi”. ");
INSERT INTO guiNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jae rambue tu jare ichɨ jei: “Ocuacuaa ma co jae. Peparandu chupe”. ");
INSERT INTO guiNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jayave judío reta oeni ye cuimbae tenonde yave jesa mbae vae. —Emboete Tumpa —jei reta chupe—. Echa roicuaa cuae cuimbae iyoa vae co. ");
INSERT INTO guiNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Mbaeti aicuaa iyoa vae ra jae —jei cuimbae—. Erei cuae co aicuaa: Tenonde yave cheresa mbae vae co, erei añave amae. ");
INSERT INTO guiNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jayave oparandu reta ye chupe: —¿Mbae pa oyapo ndeve? ¿Quirai pa nemomae? ");
INSERT INTO guiNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Amombeu ma peve —jei cuimbae—, erei mbaeti peipota peyeapɨsaca cheré. ¿Maera pa peipota peendu ye? ¿Peipota pa pe reta vi peyeapo jemimboe retara? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jayave judío reta oñeengata cuimbae pe. —Nde co jae jemimboe —jei reta—. Ore co jae Moisés jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ore roicuaa Tumpa imiari co Moisés pe. Erei mbaeti roicuaa quia pegua ra cuae cuimbae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Cuae co metei mɨacañɨ —jei cuimbae—. Pe reta mbaeti peicuaa quia pegua ra. Erei jae chemomae. ");
INSERT INTO guiNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yaicuaa Tumpa mbaeti oyeapɨsaca iyoa vae reta re. Erei oime yave quia omboete Tumpa jare oyapo Tumpa jemimbota vae, Tumpa oyeapɨsaca jese —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɨvɨ oyeapo güive mbaeti etei ipuere quia omomae jesa mbae oa ichɨ güi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mbaeti yave Tumpa pegua cuae cuimbae, mbaetita tei mbae ipuere oyapo —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jayave judío reta jei chupe: —Nde rea ndesɨ güi ndeyoa yae reve. Mbaeti mbae re ndepuere oremboe —jei reta. Jayave omombo reta cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jare Jesús oicuaa yave judío reta omombo ma cuimbae, ojo oeca. Jare ovae yave, jei chupe: —¿Rerovia pa cuimbaera oyeapo vae re? ");
INSERT INTO guiNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Quia pa co jae, carai? —jei Jesús pe—. Emombeu cheve, arovia vaera jese. ");
INSERT INTO guiNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Reecha ma —jei Jesús chupe—. Che chemiari ai nde ndive vae jae co. ");
INSERT INTO guiNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—CheYa, arovia ma —jei cuimbae. Jayave cuimbae oyeatɨca Jesús jóvai jare omboete. ");
INSERT INTO guiNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jayave Jesús jei: —Ayu ɨvɨ pe amboyao vaera oyougüi ɨvɨ pegua reta. Ayu mbaeti ipuere omae vae reta omae vaera, jare ipuere omae vae reta agüɨye vaera omae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amogüe fariseo joco pe ñogüɨnoi vae reta oendu cuae, jare oparandu chupe: —¿Ore vi pa co jae mbaeti omae vae reta? ");
INSERT INTO guiNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Mbaeti pemae yave, mbaetita tei teco penoi —jei Jesús—. Ere pere ma: “Romae co”. Jae rambue teco penoi vɨteri —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Añete che jae peve —jei Jesús—, imonda vae mbaeti oique taraquera rupi vecha-rocai pe. Oique ambué rupi. Echa oipota oñomi güɨraja ambué vae ivecha reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Erei vecha reta iñangarecoa oique taraquera rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jare vecha reta iñangarecoa oipota oique yave, taraquera jaroa oipea chupe. Jare vecha reta oendu iñangarecoa iñee. Echa iñangarecoa oeni vecha reta jee ñavo pe jare güɨraja vecha-rocai güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jare güɨraja yave opaete imbae reta vecha-rocai güi, jae ojo tenonde jare vecha reta yogüɨraja jaɨcue. Echa oicuaa iñee —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngaraa yogüɨraja cuimbae mbaeti oicuaa vae jaɨcue. Otecuaraita chugüi. Echa mbaetita oicuaa iñee —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Cuae ñee omojaanga vae pe Jesús omboe reta tei, erei jae reta mbaeti oicuaa mbae re ra omojaanga cuae jei chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jayave Jesús jei ye: —Añete che jae peve, che co jae vecha-rocai itaraquera rami. ");
INSERT INTO guiNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amogüe vae yogüeru ndei ayu mbove. Erei vecha reta mbaeti oyapo jocuae reta jemimbota. Echa jocuae reta imonda vae reta co. Jae reta oipota güɨraja ambué vae ivecha reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Che co jae taraquera rami. Che rupi vecha-rocai pe oique vae oñemboasaucata co. Oiqueta jare oeta jare ovaeta mbae jou vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Imonda vae ou güɨraja vaera ambué vae ivecha reta. Ou oyuca vaera vecha reta. Che ayu ɨvɨ pegua reta güɨnoi vaera tecove opa mbae vae, jare jocuae tecove güɨnoi yave oyerovia yaeta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Che co jae vecha reta iñangarecoa icavi vae rami. Echa vecha reta iñangarecoa icavi vae omano vecha reta oepɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jepɨ re vecha reta re oñangareco vae oecha yave aguarañaɨmba ou, oeya vecha reta jare otecuarai. Echa mbaeti vecha reta iñangarecoa añetete vae, jare vecha reta mbaeti imbae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jayave aguarañaɨmba ou oipɨɨ amogüe vecha reta, jare iru vecha reta opa oñemoai. Jocuae cuimbae otecuarai jepɨ re oñangareco vecha reta re rambue. Echa mbaeti ipɨatɨtɨ vecha reta oiporara yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Che co jae vecha reta iñangarecoa icavi vae rami. Aicuaa chevecha reta jare chevecha reta checuaa —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jocorai cheRu checuaa jare che aicuaa cheRu. Jare che amanota vecha reta aepɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jare oime anoi iru vecha reta. Jae reta mbaeti co cuae nunga pegua. Jae reta vi aruta co. Jae reta vi oyeapɨsacata cheñee re. Jayave oimeta metei atɨ jare metei vecha reta iñangarecoa —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","CheRu cheraɨu amanota rambue. Amanota co, cherecove anoi ye vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mbaeti quia ipuere oequi chegüi cherecove. Amanota aipota rambue. Chepuere amoeterenga cherecove amano vaera, jare chepuere anoi ye. Corai cheócuai cheRu —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús cuae jei rambue, judío reta oyoaca ye oyoupi. ");
INSERT INTO guiNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jeta jae reta jei: —Aña oya ma jese. Mbaeti ma oicuaa mbae jei. ¿Maera pa peyeapɨsaca jese? ");
INSERT INTO guiNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Iru vae reta jei: —Mbaeti quia aña oya jese vae ipuere imiari jocorai. Mbaeti etei ipuere aña omomae jesa mbae vae reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iroɨ ma Jerusalén pe, jare judío reta oyapo ñogüɨnoi arete Tumpa jo oyetɨo vaera vae. ");
INSERT INTO guiNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jare Jesús oguata Tumpa jo pe oca Salomón jee vae rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jayave judío reta oñemboatɨ Jesús iyɨpɨ rupi jare jei: —¿Quirai yave pa remombeu cavita oreve, agüɨye vaera orembojopa? Nde co jae Cristo yave, emombeu cavi oreve —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Amombeu ma peve —jei Jesús—, erei mbaeti perovia cheñee. CheRu chembou cuae mbaravɨquɨ ayapo vaera, jare cuae mbaravɨquɨ oicuauca quia co che —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amombeu ma peve pe reta mbaeti co chevecha reta. Jae rambue mbaeti perovia cheré. ");
INSERT INTO guiNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chevecha reta oyeapɨsaca cheñee re. Aicuaa chevecha reta, jare jae reta yogüɨraja cheraɨcue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jare amee chupe reta tecove opa mbae vae, jare ngaraa etei ojo cañɨtei pe. Mbaeti quia ipuere opɨro chegüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","CheRu omee ma cheve cuae reta, jare cheRu imbaepuere tuicha yae opaete vae imbaepuere güi. Jare mbaeti quia ipuere opɨro cheRu güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Che jare cheRu meteiño co —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jayave judío reta omonoo ye ita reta oyapi vaera tei pɨpe Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jayave Jesús jei chupe reta: —Aechauca ma peve jeta mbaravɨquɨ icavi vae. Cuae ayapo cheRu imbaepuere rupi. ¿Mbae nunga mbaravɨquɨ jeco pegua pa peipota cheapi ita pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Mbaeti metei mbaravɨquɨ icavi vae jeco pegua —jei judío reta chupe—. Nde rere icavi mbae vae Tumpa cotɨ. Jocuae jeco pegua roapita ita pe. Echa nde co jae metei cuimbaeño, erei rere ndeyeupe nde co jae Tumpa —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jayave Jesús jei chupe reta: —Mboroócuai penoi vae pe oyecuatía oi quirai Tumpa jei corai: “Pe reta co jae tumpa reta”. Jocorai jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Echa Tumpa imiari chupe reta yave, jae etei ombojee tumpa reta. Jare Tumpa iñee pe oyecuatía oi vae jecuaeño añete co. ");
INSERT INTO guiNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jae rambue ¿maera pa pere cheve: “Nde rere icavi mbae vae Tumpa cotɨ”, che jae vae jeco pegua? Echa che jae: “Che co jae Tumpa Taɨ”. Echa Tumpa cheñono tee cuae mbaravɨquɨ ayapo vaera, jare jae chembou cuae ɨvɨ pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbaeti yave mona ayapo cheRu iparavɨquɨ, agüɨyeta tei chererovia. ");
INSERT INTO guiNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Erei ayapo co cheRu iparavɨquɨ. Jae rambue yepe tei mbaeti chererovia, perovia mbaravɨquɨ ayapo vae cheRu pegua co, peicuaa vaera cheRu oico che ndive jare che aico cheRu ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jayave judío reta oipota ye tei oipɨɨ Jesús, erei jae ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jare Jesús ojo ye ɨ Jordán jovaicho pe tenonde yave Juan oporombobautiza oia pe, jare opɨta joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jare jeta vae yogüeru jae oia pe jare jei: —Juan mbaeti oyapo metei ave mɨacañɨ. Erei opaete Juan jei cuae cuimbae re vae añete co —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jare jeta vae güɨrovia Jesús re joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Metei cuimbae Lázaro jee vae imbaerasɨ oi. Jae jare María jare Marta - jae co María tɨque - Betania pegua reta co. ");
INSERT INTO guiNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jocuae María opɨyere mbae ipiche cavi yae vae ñandeYa re jare oyoe ipɨ ia pe. Jocuae Lázaro imbaerasɨ oi vae María iquɨvɨ co. ");
INSERT INTO guiNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jare Lázaro jeindɨ reta omondo omombeu vaera Jesús pe: —OreYa imbaerasɨ oi cuae reaɨu vae. ");
INSERT INTO guiNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús cuae oicuaa yave, jei: —Cuae imbaerasɨ ou chupe iru vae reta omboete vaera Tumpa. Mbaeti ou jae omano vaera. Echa che co jae Tumpa Taɨ, jare iru vae reta chemboeteta cuae mbaerasɨ jeco pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús oaɨu Marta jare ipɨquɨɨ jare Lázaro. ");
INSERT INTO guiNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Erei oicuaa ma yave Lázaro imbaerasɨ oi, opɨtaño mócoi ara joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cuae jaɨcue rupi jei jemimboe reta pe: —Yaja ye mo Judea pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Rabí —jei reta—, ndei co ɨma judío reta oipota tei ndeapi ita pe joco pe. Jae rambue ¿maera pa reo yeta? ");
INSERT INTO guiNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Oime doce ora güɨnoi ara —jei Jesús—. Ara rupi oguata vae ngaraa ipɨ güɨrocua. Echa güɨnoi tembipe cuae ɨvɨ pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Erei pɨtu yave oguata vae ipɨ güɨrocua. Echa mbaeti güɨnoi tembipe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jocorai jei Jesús. Jayave jei ye: —Ñaneamingo Lázaro oque ma oi. Erei che ajata amoingove —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jemimboe reta jei: —OreYa, oque oi yave, ocuera yeta co. ");
INSERT INTO guiNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Erei Jesús jocorai jei yave, oipota jei omano ma. Jae reta oñemongueta tei oipota jei oputuu co oque oi. ");
INSERT INTO guiNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jayave Jesús omombeu cavi chupe reta: —Lázaro omano ma. ");
INSERT INTO guiNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jare ayerovia mbaeti joco pe ai vae re. Cuae icavita co peve. Echa perovia yaeta co. Yaja mo icotɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jayave Tomás - jae co Chaguaqui pe oñemobojee vae - jei iru Jesús jemimboe reta pe: —Yaja mo ñande vi, ñamano vaera jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jare Jesús ou ovae yave, amogüe vae omombeu chupe irundɨ ara ma co Lázaro oi teogüerɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania coiño oi Jerusalén güi. Oupitɨ mboapɨ kilómetro rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jare jeta judío reta yogüeru ma Marta jare María pɨri ombopɨacatu vaera iquɨvɨ amɨri re. ");
INSERT INTO guiNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jare Marta oicuaa yave Jesús ou co ovae, ojo oovaiti. Erei María opɨta o pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jayave Marta jei Jesús pe: —CheYa, nde cuae pe rei yave, mbaetita tei omano chequɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jare añave aicuaa oipotagüe reyerure Tumpa pe jese vae Tumpa omeeta co ndeve —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ndequɨvɨ oicove yeta co ou omanogüe vae reta ipɨte güi —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Aicuaa oicove yeta co ou omanogüe vae reta ipɨte güi ara taɨcuegua pe —jei Marta—. Echa jocuae ara iru vae reta vi oicove yeta yogüeru omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Che co amee tecove omanogüe vae reta pe jare aru ye iru omanogüe vae reta ipɨte güi —jei Jesús—. Cheré güɨrovia vae, yepe tei omano oi, oicove yeta co. ");
INSERT INTO guiNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jare opaete oicove oi vae cheré güɨrovia vae ngaraa etei omano. ¿Rerovia pa cuae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Arovia, cheYa —jei Marta—. Añave arovia nde co jae Cristo. Nde co jae Tumpa Taɨ. Echa Tumpa iñee pe oyecuatía oi outa co Tumpa Taɨ ɨvɨ pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta cuae jei ma yave, ojo oeni María - jae co Marta ipɨquɨɨ. Jayave güɨraja iru vae reta ipɨte güi jare jei chupe: —Oporomboe vae oime cuae pe oi jare oipota reo vaera jae oia pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María cuae oendu yave, ɨmambae opúa ojo Jesús oia pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Marta oovaitia peño opɨta Jesús. Echa ndei oique tenta pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judío o pe imiari ñogüɨnoi María pe ombopɨacatu vaera vae reta oecha María ɨmambae opúa ojo o güi. Jayave yogüɨraja María jaɨcue. Echa oñemongueta tei jae ojo teogüerɨru oia pe oyaeo vaera joco pe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jayave María ojo ovae Jesús oia pe. Oecha rupive ojo oyeatɨca jae jóvai jare jei: —CheYa, nde cuae pe rei yave, mbaetita tei omano chequɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús oecha yave María jare judío María ndive yogüeru vae reta oyaeo ñogüɨnoi, iayequi jare ipɨatɨtɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jayave oparandu: —¿Quiape pa peñono? —Eyu eecha, carai —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jayave Jesús oyaeo. ");
INSERT INTO guiNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jare judío reta jei: —Mase, oaɨu yae co. ");
INSERT INTO guiNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Erei amogüe vae jei: —¿Mbaeti ra ipuere tei cuae cuimbae oyapo mbae agüɨye vaera omano Lázaro? Echa omomae cuimbae jesa mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús iayequi ye. Jayave ojo teogüerɨru oia pe. Jocuae teogüerɨru metei ita guasu oyeyoo vae co jare ita tuicha vae oi teogüerɨru jonque re. ");
INSERT INTO guiNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jayave Jesús jei: —Pembosɨrɨ ita joco güi. Marta - jae co cuimbae amɨri jeindɨ - jei chupe: —CheYa, ine ma co. Echa irundɨ ara ma omano güire —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús jei chupe: —Amombeu ma ndeve rerovia yave reechata mbae ayapota iru vae reta omboete vaera Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jayave ombosɨrɨ reta ita teogüerɨru jonque güi. Jayave Jesús omae ara re jare jei: —CheRu, amee yasoropai ndeve nde reendu cheve vae re. ");
INSERT INTO guiNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aicuaa jecuaeño reendu cheve, erei chemiari corai cuae cheɨpɨ rupi ñogüɨnoi vae reta jeco pegua, jae reta güɨrovia vaera nde co chembou —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jayave iñeeata. —Lázaro, ee joco güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jare cuimbae amɨri oe. Ipo jare ipɨ oyeocua tarapo pe, jare jova oñeoma lienzo pe. Jayave Jesús jei: —Peyora iyocuaa. Pemaeño toguata —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jare jeta judío yogüeru opou María pɨri vae reta oecha Jesús oyapo vae jare güɨrovia jese. ");
INSERT INTO guiNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Erei amogüe vae yogüɨraja fariseo reta pɨri omombeu Jesús oyapo vae. ");
INSERT INTO guiNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jayave sacerdote reta itenondegua reta jare fariseo reta omboatɨ opaete mburuvicha reta. —¿Mbae pa yayapota? —jei reta—. Cuae cuimbae jecuaeño oyapo jeta mɨacañɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ñamaeño yave corai oyapo vaera, opaete tenta pegua reta güɨroviata jese. Jayave romano reta yogüeruta ombosururu Tumpa jo jare oyucata opaete ñanerentaɨgua reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Erei metei ipɨte pe oi vae - Caifás jee vae - jae co sacerdote tenondegua jocuae año - jei: —Mbaeti etei mbae peicuaa. ");
INSERT INTO guiNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mbaeti peñemongueta cavi. Echa icavita co ñandeve metei cuimbae omano vaera opaete ñanerentaɨgua reta oyeepɨ vaera. Echa mbaeti yave, güɨramoi opaete ñanerentaɨgua reta omanota —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jare cuae omombeu chupe reta ndei oyeapo mbove. Mbaeti jaeiño omombeu. Echa jae sacerdote tenondegua co jocuae año. Omombeu Jesús omanota opaete judío reta oyeepɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Omanota omboatɨ vaera opaete Tumpa taɨ oñemoai vae reta - mbaetita omano judío reta reño. ");
INSERT INTO guiNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jae rambue jocuae ara güive oñomomiari quirai oyucauca vaera Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jae rambue Jesús mbaeti ma opɨta Judea pe, agüɨye vaera judío reta oecha. Ojo joco güi metei tenta Efraín jee vae pe. Jocuae tenta coiño oi ñuu güi. Jare joco pe Jesús opɨta jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jare coiño ma ou judío reta iyarete pascua jee vae iara, jare jeta judío reta yogüɨraja Jerusalén pe joco güi ndei arete iara ou ovae mbove. Echa oipota oyetɨo Tumpa cotɨ arete peguara. ");
INSERT INTO guiNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jayave oeca ñogüɨnoi Jesús, jare Tumpa jo pe ñogüɨnoi rambueve jei oyoupe: —¿Mbae pa peñemongueta? ¿Ngaraa pa ou cuae arete pe? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Echa sacerdote reta itenondegua reta jare fariseo reta oyócuai ma opaete vae corai: “Oime yave quia oicuaa quiape Jesús oime oi vae, tomombeu oreve orepuere roipɨɨ vaera”. ");
INSERT INTO guiNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis araño ma oata pascua ovae vaera. Jayave Jesús ojo ye Betania pe. Echa joco pe oico Lázaro tenonde yave omano vae Jesús omoingove ye güeru omanogüe vae reta ipɨte güi vae. ");
INSERT INTO guiNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pɨtu ma yave Lázaro jo pegua reta oyapo Jesús jou vaera. Marta güeru tembíu, jare Lázaro oguapɨ ocaru mesa pe Jesús ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jayave María güeru metei libra mbae ipiche cavi vae nardo jee vae jare opɨyere Jesús ipɨ re. Jayave oyoe ipɨ ia pe. Jare opaete o ipiche cavi yae. ");
INSERT INTO guiNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jayave metei Jesús jemimboe Judas Iscariote jee vae - jae co Simón taɨ - jae co omoeterengata Jesús jovaicho reta pe vae - jei: ");
INSERT INTO guiNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Maera pa mbaeti omee cuae mbae ipiche cavi vae trescientos denario pe? Echa ipuereta tei co omee corepoti paravete vae reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Erei jae mbaeti ipɨatɨtɨ paravete vae reta re. Echa jocorai jei imonda rambue. Echa jae güɨnoi corepoti iru vae reta omee chupe reta vae jɨru, jare jecuaeño oequi vɨari chugüi corepoti iyeupe. ");
INSERT INTO guiNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jayave Jesús jei: —Emaeño jese. Metei ara añeotɨucata co. Jocuae ara peguara oñovatu cuae mbae ipiche cavi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Paravete vae reta jecuaeño yogüɨrecota pe reta ndive. Erei che ngaraa jecuaeño aico pe reta ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jare jeta judío reta oicuaa Jesús joco pe oi. Jae rambue yogüeru. Jare mbaeti yogüeru Jesús joco pe oi rambueño. Erei yogüeru omae vaera Lázaro re vi. Echa Jesús omoingove ye Lázaro güeru omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jayave sacerdote reta itenondegua reta oñomomiari quirai oyucauca vaera Lázaro vi. ");
INSERT INTO guiNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Echa Lázaro jeco pegua jeta judío reta yogüɨraja chugüi reta. Echa güɨrovia ma Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pɨareve pe jeta yae arete pe yogüeru ma vae oicuaa Jesús outa ma co Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jayave oequi reta carandaɨ joo yogüɨraja oovaiti vaera Jesús. —¡Hosanna! —jei reta—. ÑandeYa tomovendise cuae ombou vae. Tumpa tomovendise Israel pegua reta juvicha guasu —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jare Jesús ovae metei mburica mi taɨrusu vae, jare opo jese. Echa Tumpa iñee pe oyecuatía oi corai: ");
INSERT INTO guiNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Agüɨye equɨye, Sion imembɨ. Mase, co ou ma nderuvicha guasu. Opo ou mburica mi taɨrusu vae re. Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jocuae ara Jesús jemimboe reta mbaeti oicuaa cavi cuae regua. Erei Jesús ojo ye ma ara pe yave, imaendúa cuae re. Echa jocorai Tumpa iñee pe oyecuatía oi jese, jare jocorai jae oyapo. ");
INSERT INTO guiNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jare amogüe joco pe ñogüɨnoi vae jei: —Ore roi Jesús ndive, jae omoingove ye yave Lázaro güeru omanogüe vae reta ipɨte güi jare oyócuai oe vaera teogüerɨru güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jae rambue jeta vae yogüɨraja oovaiti Jesús. Echa oicuaa ma oyapo cuae mɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jayave fariseo reta jei oyoupe: —Mase, mbaeti mbae ñandepuere yayapo. Echa opaete tenta pegua reta yogüɨraja omae vaera jese. ");
INSERT INTO guiNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jare amogüe griego reta yogüeru ma arete pe iru vae reta ndive omboete vaera Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jae reta yogüeru Felipe Betsaida pegua pe - jocuae Betsaida Galilea pegua co - jare jei chupe: —Carai, roipota roecha Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jayave Felipe ojo omombeu Andrés pe. Jayave mócoi reve yogüɨraja omombeu Jesús pe. ");
INSERT INTO guiNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jayave Jesús jei: —Ara ovae ma che ayeapo cuimbaera vae añemboeteuca vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Añete che jae peve, metei trigo jaɨgüe mbaeti yave oñeotɨ, jaeiño opɨta. Erei oñeotɨ yave, jeta yae oñemoña —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Oyeaɨu vae ngaraa oñemboasauca. Erei mbaeti oyeaɨu cuae ɨvɨ pe vae oñemboasaucata co. Güɨnoita tecove opa mbae vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Oyeócuai cheve vae tou cherupíe. Cherembiócuai oita che aitaa pe. Jare cheRu omboeteucata oyeócuai cheve vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chepɨatɨtɨ yae ma. Erei mbaeti chepuere jae: CheRu, cherepɨ cuae ora pe oyeapota cheve vae güi. Echa ovae ma cuae ora cuae oyeapo cheve vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","CheRu, eyapo cheve ɨvɨ pegua reta nemboete vaera —jei. Jayave ñee oñeendu ara güi: —Ayapo ma mbaembae nde rupi ɨvɨ pegua reta chemboete vaera, jare corai ayapo yeta co. ");
INSERT INTO guiNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jeta joco pe ñogüɨnoi vae reta oendu ñee jare jei ara co jɨapu. Iru reta jei: —Metei araɨgua ombou iñee chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jayave Jesús jei: —Cuae ñee oñeendu pereco pegua - mbaeti chereco pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Oñejaa ma ɨvɨ pegua reta, jare jae reta juvicha oñemombota co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jare iru vae reta chereupi yave ɨvɨ güi, arurucata opaete ɨvɨ pegua reta checotɨ —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cuae jei Jesús oicuauca vaera chupe reta quiraita co omano. ");
INSERT INTO guiNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jayave jae reta jei Jesús pe: —Mboroócuai pe oyecuatía oi vae omombeu oreve Cristo jecuaeño oico. ¿Mbae pa oipota jei jocuae nde rere vae? Echa nde rere iru vae reta oupita ɨvɨ güi cuimbaera oyeapo vae. ¿Quia pa co jae cuimbaera oyeapo vae? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","—Tembipe oico vɨteri pe reta ndive —jei Jesús—. Erei ngaraa ɨma opɨta pe reta ndive. Peguata tembipe oico pe reta ndive rambueve, agüɨye vaera pɨtu peve. Echa pɨtumimbi pe oguata vae mbaeti oicuaa quetɨ ojo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tembipe pe reta ndive oico rambueve, perovia tembipe re, pe reta pei vaera tembipe rami —jei chupe reta. Cuae jei ma yave, Jesús ojo chugüi reta, jare mbaeti ma ipuere reta ovae chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Erei yepe tei Jesús oyapo jeta mɨacañɨ reta jae reta jovaque oicuauca vaera tei chupe reta quia co jae, erei jae reta mbaeti güɨrovia jese, ");
INSERT INTO guiNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","oyeapo vaera Isaías oicuatía vae - Isaías co jae Tumpa iñee aracae omombeu vae. Echa Isaías oicuatía corai: CheYa, ¿quia pa güɨrovia romombeu vae? ¿Quia nunga vae pe pa reicuauca nembaepuere? Jocorai oicuatía Isaías aracae. ");
INSERT INTO guiNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jae rambue jae reta mbaeti ipuere güɨrovia. Echa Isaías oicuatía ye corai: ");
INSERT INTO guiNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tumpa oyapo reta jesa mbae vae reta rami jare omopɨatanta, agüɨye vaera omae cavi reta, jare agüɨye vaera oicuaa cavi reta, jare agüɨye vaera oyerova icotɨ. Echa oyerova yave Tumpa cotɨ, Tumpa ombogüerata tei co. Jocorai oicuatía Isaías ");
INSERT INTO guiNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías cuae jei, oecha yave maemboete pegua vae. Jae rambue imiari jocorai jese. ");
INSERT INTO guiNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Erei amogüe mburuvicha reta güɨrovia Jesús re. Erei mbaeti oipota jei jae co Cristo fariseo reta jeco pegua. Echa jocorai jei yave, fariseo reta omombota tei co judío reta itupao güi. ");
INSERT INTO guiNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Echa jae reta oipota yae japicha reta omboete vaera Tumpa omboeteuca vaera güi. ");
INSERT INTO guiNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jayave Jesús iñeeata reve jei: —Cheré güɨrovia vae mbaeti chereño güɨrovia. Güɨrovia chembou vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cherecha vae oecha chembou vae vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ayu ɨvɨ pe amee vaera tembipe ɨvɨ pegua reta pe, agüɨye vaera cheré güɨrovia vae opɨta pɨtumimbi pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Cheñee re oyeapɨsaca vae mbaeti yave oyapo che jae vae rupi, che mbaeti ajaa. Echa che ayu amboasa vaera ɨvɨ pegua reta. Mbaeti ayu ajaa vaera —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jocuae mbaeti güɨrovia cheré jare mbaeti oyapo che jae chupe oyapo vaera vae oñejaata co. Echa ara taɨcuega pe cuae che jae vae ojaata —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Echa cheporomboe mbaeti chembae aeño. Cheru chembou, jare jae cheócuai mbae jae vaera, jare quirai chemiari vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jare aicuaa cheRu cheócuai vae tecove opa mbae vae pegua co. Jae rambue che jae peve cheRu jei cheve vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Outa ma arete pascua jee vae iara. Jare Jesús oicuaa ara ovae ma oeya vaera cuae ɨvɨ ojo ye vaera Tu pɨri. Jecuaeño oaɨu imbae cuae ɨvɨ pe ñogüɨnoi vae reta, jare añave oicuaucata quirai oaɨu yae. ");
INSERT INTO guiNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Judas Iscariote - jae co Simón taɨ - oñemongueta ma omoeterenga vaera Jesús jovaicho reta pe. Echa jocorai oipota aña guasu Judas oñemongueta vaera. Jare Jesús oicuaa cavi ma opaete mbaravɨquɨ Tu oipota oyapo vaera vae. Oicuaa vi ou co Tumpa güi jare ojo yeta co Tumpa pɨri. Jare pɨtu yave Jesús jare jemimboe reta ocaru ñogüɨnoi yave, Jesús opúa mesa güi, omboi jemimonde iarambuegua, jare oyocua icúa metei toalla pe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jayave oñono ɨ metei ɨa pe jare omboɨpɨ oyoe jemimboe reta ipɨ, jare oyoe ma yave, omotini toalla icúa re oi vae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jare ojo ovae yave Simón Pedro oia pe, Pedro jei chupe: —CheYa, ¿nequɨreɨ pa reyoe chepɨ? ");
INSERT INTO guiNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Cuae ayapo ai vae mbaeti reicuaa cavi añave —jei Jesús—, erei reicuaa cavita co taɨcue rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Ngaraa etei reyoe chepɨ —jei Pedro. —Jocorai yave, nde mbaeti co cheiru —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jayave Simón Pedro jei ye: —CheYa, eyoe chepo jare cheaca vi - mbaeti chepɨño. ");
INSERT INTO guiNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Oyau ma vae mbaetita oipota ye oyau —jei Jesús—. Ipɨño ma oyoeta. Echa opaete jete iquɨa mbae ma. Jare pe reta pequɨa mbae ma. Erei mbaeti co opaete pe reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Echa Jesús oicuaa quia omoeterengata jovaicho reta pe. Jae rambue jei: “Erei mbaeti co opaete pe reta”. ");
INSERT INTO guiNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jayave opa güire ipɨ reta oyoe, oñemonde ye Jesús jare ojo oguapɨ jenda pe. Jayave oparandu chupe reta: —¿Peicuaa cavi pa ayapo ma peve vae? ");
INSERT INTO guiNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pe reta pere cheve: “Oporomboe vae”, jare pere vi: “OreYa”. Añete co cuae pere vae. Echa aporomboe jare che co jae peYa —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Erei yepe tei che pomboe jare che co jae peYa, erei ayoe ma pepɨ reta. Jae rambue icavi co pe reta peyoe vaera pepɨ oyougüi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Echa che cuae ayapo aicuauca vaera peve, pe reta vi peyapo vaera che ayapo peve vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Añete che jae peve, metei tembiócuai mbaeti oyócuai iya mbae oyapo vaera. Jae ramiño vi temimondo mbaeti oyócuai omondo vae mbae oyapo vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Cuae peicuaa cavi. Peyapo yave, Tumpa oyapota icavi vae peve —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mbaeti opaete pe reta re chemiari. Aicuaa quia reta co aiparavo. Erei Tumpa iñee pe oyecuatía oi vae oyeapota co. Echa oyecuatía oi corai: “Jocuae ocaru che ndive vae chemoeterengata co”. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cuae amombeu peve añave ndei oyeapo mbove, cuae oyeapo yave perovia vaera quia co che —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Añete che jae peve, cheremimondo omboresive vae che etei co chemboresive. Jare chemboresive vae omboresive chembou vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cuae jei ma yave, Jesús ipɨatɨtɨ yae jare jei: —Añete che jae peve, metei pepɨte pe oi vae chemoeterengata cherovaicho reta pe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jayave Jesús jemimboe reta omae oyoe. Mbaeti oicuaa quia re ra imiari. ");
INSERT INTO guiNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Metei jemimboe - jae co Jesús oaɨu vae - ocaru oi Jesús iyɨpɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jayave Simón Pedro omomɨi iñaca jocuae iru temimboe oecha vaera, jare jae oparandu vaera Jesús pe quia re ra imiari. ");
INSERT INTO guiNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jayave jocuae temimboe Jesús iyɨpɨ pe ocaru oi vae oparandu Jesús pe: —¿Quia pa co jae, cheYa? ");
INSERT INTO guiNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Ameeta chupe mbɨyape —jei Jesús—, tembíu pe amoaquɨ ma yave. Jocuae co jae —jei. Jayave tembíu pe omoaquɨ ma yave, güɨnoe omee Judas Iscariote pe - jae co Simón taɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jayave Judas jou ma yave, Satanás oya jese. Jayave Jesús jei Judas pe: —Eyapo voi jocuae reyapota vae. ");
INSERT INTO guiNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Erei mbaeti quia mesa pe oi vae oicuaa maera Jesús jei jocorai Judas pe. ");
INSERT INTO guiNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amogüe vae oñemongueta tei Jesús jei chupe vae oipota jei: “Ecua egua yaipota arete peguara vae”, ani: “Ecua emee mbae paravete vae reta pe”. Echa Judas güɨnoi corepoti jɨru. ");
INSERT INTO guiNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jayave opa güire jou mbɨyape, Judas oe voi ojo. Jare pɨtu ma co. ");
INSERT INTO guiNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jayave oe ma yave Judas, Jesús jei: —Che ayeapo cuimbaera. Añave ɨvɨ pegua reta chemboeteta. Jare omboeteta vi Tumpa chereco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɨvɨ pegua reta omboeteta Tumpa chereco pegua. Jae rambue Tumpa etei chemboeteucata ɨvɨ pegua reta pe. Añave voi chemboeteucata —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cherɨvɨ reta, michi peguaño ma apɨtata pe reta ndive. Jayave chereca teita, erei pe reta ngaraa pepuere peo che ajataa pe. Echa corai amombeu judío reta pe, jare añave amombeu peve vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Amee peve metei mboroócuai ipɨau vae. Peyoaɨu. Peyoaɨu che poaɨu rami —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Peyoaɨu yave, opaete ɨvɨ pegua reta oicuaata pe reta cheremimboe reta co —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro jei Jesús pe: —CheYa, ¿quetɨ pa reota? —Ngaraa añave ndepuere reo che ajataa pe —jei Jesús—. Erei taɨcue rupi reota co —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro jei ye: —CheYa, ¿maera pa mbaeti chepuere aja nde ndive añave? Che tamano nderecovia pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Nde rere remanota cherecovia pe —jei Jesús—. Añete che jae ndeve, ndei tacareo oñee pɨipɨi mbove, mboapɨ vese ma checuacuta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Agüɨye pepɨatɨtɨ. Perovia Tumpa re. Perovia vi cheré —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","CheRu jo pe oime jeta o. Mbaeti yave jocorai, amombeuta tei co peve. Ajata ayapocavi vaera perendara —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jare aja ma yave ayapocavi vaera perendara, ayu yeta pomboresive vaera, pe reta vi peico vaera che aicotaa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jare pe reta peicuaa tape que rupi ajata —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jayave Tomás jei: —OreYa, ore mbaeti roicuaa quetɨ reota. ¿Quiraita ra roicuaa tape? ");
INSERT INTO guiNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Che co jae tape —jei Jesús—. Che co jae añete vae re imiari vae. Che co jae tecove opa mbae vae omee vae. Mbaeti quia ipuere oñemoiru cheRu ndive jaeño che rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Checuaa cavi yave mona, peicuaata tei co cheRu vi. Erei añave güive peicuaa co. Echa peecha ma —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe jei chupe: —OreYa, eechauca oreve ndeRu. Jocuaeño roipota. ");
INSERT INTO guiNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Ɨma ma aico nde ndive, Felipe —jei Jesús—. ¿Ndei pa co checuaa cavi? Cherecha vae oecha ma co cheRu. ¿Maera pa rere: “Eechauca oreve ndeRu”? —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mbaeti pa perovia che aico cheRu ndive jare cheRu oico che ndive? Ñee amombeu peve vae mbaeti chembae aeño. Echa cheRu oico che ndive, jare jae oyapo mbaravɨquɨ reta —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Perovia cuae che jae peve vae: Che aico cheRu ndive, jare cheRu oico che ndive. Cuae mbaeti perovia yave, chererovia mbaravɨquɨ ayapo vae reta jeco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Añete che jae peve, cheré güɨrovia vae oyapota mbaravɨquɨ reta che ayapo ma vae reta rami. Jare iparavɨquɨ reta tuicha yaeta cheparavɨquɨ reta güi, che ajata cheRu pɨri rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pepuereta peyerure oipotagüe mbae re cheree re, jare che ayapota peve, cheRu oñemboeteuca vaera che ayapota vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Peyerure yave oipotagüe mbae re cheree re, ayapota co peve —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Cheraɨu yave, peyapo cheporoócuai reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jare che ayerureta cheRu pe jae ombou vaera peve iru vae. Jae jecuaeño oicota pe reta ndive pembopɨacatu vaera. Jae co Espíritu Santo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jae imiarita añete vae re. Oporogüɨrovia mbae vae reta ngaraa ipuere omboresive Espíritu Santo. Echa oporogüɨrovia mbae vae reta mbaeti oecha jare mbaeti oicuaa. Erei pe reta peicuaa. Echa jae oico pe reta ndive jare oicota pepɨa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Che aja ma yave, ngaraa peico jentara mbaeti güɨnoi vae reta rami. Echa che ayu yeta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Michi peguaño ma ɨvɨ pegua reta cherechata. Ngaraa ma cherecha ye. Erei pe reta cherecha yeta. Che jecuaeño aico rambue, pe reta peicota vi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jocuae ara peicuaata co che aico cheRu ndive, jare pe reta peico che ndive, jare che aico pepɨa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Oime yave quia oyeapɨsaca cheporoócuai reta re oyapo vaera vae, jae co cheraɨu. Jare cheRu oaɨuta cheraɨu vae, jare che aaɨuta, jare aicuaucata chupe quia co che —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jayave Judas - mbaeti co Judas Iscariote - jei chupe: —OreYa, ¿quiraita pa reicuauca oreve quia co nde, mbaeti yave reicuauca oporogüɨrovia mbae vae reta pe? ");
INSERT INTO guiNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Cheraɨu vae oyapota che jae chupe oyapo vaera vae —jei Jesús—. Jare cheRu oaɨuta. Jare royuta roico vaera jae ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mbaeti cheraɨu vae mbaeti oyapo che jae chupe oyapo vaera vae. Jare cheñee peendu vae mbaeti co chembae aeño. Echa cuae ñee cheRu iñee co. Jae co chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cuae mbaembae re chemiari ma peve, aico pe ndive rambueve. ");
INSERT INTO guiNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Erei jocuae pembopɨacatuta vae pemboeta opaete mbae re. CheRu ombouta peve cheree re. Jae co Espíritu Santo. Jae pemomaenduata opaete che jae peve vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mbɨacatu aeya pe ndive. Mbɨacatu che anoi vae amee peve. Ɨvɨ pegua reta mbaeti ipuere omee peve che amee peve vae nunga mbɨacatu. Agüɨye pepɨatɨtɨ. Agüɨye pequɨye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Peendu ma quirai che jae: “Ajata ma jare ayu yeta peve”. Cheraɨu yave mona, peyeroviata tei. Echa ajata cheRu pɨri, jare cheRu imbaepuere tuicha yae chembaepuere güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amombeu ma peve ndei oyeapo mbove, perovia vaera oyeapo yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngaraa ma ɨma chemiari peve. Echa ɨvɨ pegua reta juvicha ɨmambae outa ovae cheve. Erei ngaraa ipuere cheré —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Erei ayapota cheRu iporoócuai, ɨvɨ pegua reta oicuaa vaera che aaɨu cheRu. Pepúa, yaja mo cuae güi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Che co jae uva añetete vae rami, jare cheRu co jae uva iñangarecoa rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Opaete jaca mbaeti ia güɨnoi vae reta cheRu oyasɨata. Jare opaete jaca ia güɨnoi vae reta jae oitɨota, jeta ia güɨnoi vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pe reta peyetɨouca ma ñee amombeu peve vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Peico cheré perovia reve, jare che aicota pepɨa pe. Metei jaca oyeasɨa yave uva güi, ngaraa ipuere oyapo ia. Echa jaca aeño mbaeti ipuere oyapo ia. Jae ramiño vi pe reta mbaeti yave peico cheré perovia reve, ngaraa pepuere peyapo icavi vae Tumpa peguara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Che co jae uva rami, jare pe reta co jae jaca reta rami. Jocuae oico cheré güɨrovia reve vae oyapota jeta icavi vae Tumpa peguara. Echa che aico ipɨa pe. Erei mbaeti yave che aico pepɨa pe, mbaetita mbae pepuere peyapo Tumpa peguara —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jocuae mbaeti oico cheré güɨrovia reve vae oñemombota metei jaca oyeasɨa vae oñemombo yɨpi vaera vae rami. Jare jaca yɨpi vae reta oñemboatɨuca jare oñemondouca tata pe ócai vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Peico yave cheré perovia reve, jare peyapo yave che jae peve peyapo vaera vae, pepuereta peyerure peipota vae re jare penoita co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Peyapo yave jeta icavi vae cheRu peguara, ɨvɨ pegua reta omboeteta cheRu. Jare corai peicuaucata pe reta co cheremimboe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","CheRu cheraɨu. Jae ramiño vi che poaɨu, Jecuaeño peico cheraɨu reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Peyapo yave cheporoócuai reta, peicota co cheraɨu reve. Echa corai che ayapo cheRu iporoócuai reta, jare jecuaeño che aico aaɨu reve —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Corai chemiari ma peve peyerovia vaera che ayerovia rami. Corai ayapo peyerovia yae vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cuae co jae cheporoócuai: Peyoaɨu che poaɨu rami. ");
INSERT INTO guiNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Oime yave quia iquɨreɨ omano oepɨ vaera iamingo reta vae, iporoaɨu tuicha yae co iru mboroaɨu güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pe reta co jae cheamingo reta, peyapo yave che jae peve peyapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mbaeti ma che jae peve pe reta co cherembiócuai reta. Echa tembiócuai mbaeti oicuaa mbae ra oyapo iya. Erei che jae ma peve pe reta co jae cheamingo reta. Echa opaete cheRu omombeu cheve vae aicuauca ma co peve —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pe reta mbaeti cheparavo. Che co poparavo. Jare amee ma peve mbaepuere peo vaera peyapo icavi vae Tumpa peguara, jare jecuae jocorai peyapo vaera. Cuae ayapo cheRu omee vaera peve oipotagüe peyerureta chupe jese cheree re vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cuae co poócuai: Peyoaɨu —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Peñemotareɨuca oporogüɨrovia mbae vae reta pe yave, pemaendúa quirai jae reta che rani co chemotareɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Peico yave mona oporogüɨrovia mbae vae reta yogüɨreco rami, oporogüɨrovia mbae vae reta peraɨuta tei. Erei che poparavo ma oporogüɨrovia mbae vae reta ipɨte güi. Jae rambue mbaeti ma peico oporogüɨrovia mbae vae reta yogüɨreco rami. Jae rambue peñemotareɨuca oporogüɨrovia mbae vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pemaendúa cuae che jae peve vae re: “Metei tembiócuai mbaeti oyócuai iya mbae oyapo vaera”. Echa oporogüɨrovia mbae vae reta oyapo yave icavi mbae vae cheve, oyapota icavi mbae vae peve vi. Oyapo reta yave che jae chupe oyapo vaera vae, oyapota pe reta pere chupe oyapo vaera vae vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Erei oporogüɨrovia mbae vae reta oyapota peve opaete cuae mbaembae cheré perovia rambue. Echa jae reta mbaeti oicuaa chembou vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mbaeti yave mona ayu chemiari vaera chupe reta, ngaraa tei güɨnoi teco. Erei añave opaete vae ipuere oicuaa jae reta güɨnoi co teco —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chemotareɨ vae omotareɨ cheRu vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbaeti yave mona ayapo ipɨte pe mbaravɨquɨ mbaeti quia ye oyapo vae reta, ngaraa tei güɨnoi teco. Erei jae reta cherecha ma - jae co cheRu oecha rami - jare oremotareɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cuae oyapo reta oyeapo vaera mboroócuai pe oyecuatía oi vae. Echa oyecuatía oi corai: “Jae reta chemotareɨ mbaeti mbae icavi mbae vae ayapo chupe reta reve”. Jocorai oyecuatía oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Erei ambouta peve cheRu oicoa güi pembopɨacatuta vae - jae co Espíritu Santo añete vae re imiarita vae. Jae ou yave, chemombeuta co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jare pe reta vi chemombeuta. Echa tenonde güive peico che ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Opaete cuae che jae ma peve agüɨye vaera peyerova Tumpa güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Peñemomboucata co judío reta itupao reta güi. Añete co, outa ma ara peyeyucauca vaera. Jare jocuae reta peyucata vae oñemongueta teita oyeócuai co oi Tumpa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jae reta mbaeti oicuaa cheRu jare mbaeti vi checuaa. Jae rambue jocorai oyapota —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Erei cuae che jae ma peve, pemaendúa vaera corai amombeu peve vae re jocorai oyapo reta yave —jei—. Mbaeti amombeu peve cuae tenonde güive. Echa che aico pe ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Erei ajata chembou vae pɨri. Jare mbaeti metei ave añave peparandu cheve: “¿Quetɨ pa reota?” —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Erei cuae che jae peve vae jeco pegua pepɨatɨtɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Erei amombeu peve añete vae. Icavita co peve che aja vaera. Echa che mbaeti yave aja, ngaraa ou peve pembopɨacatuta vae. Erei aja yave, ambouta peve. ");
INSERT INTO guiNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Jare jae ou yave, oicuaucata ɨvɨ pegua reta pe jae reta oyapo co mbaeyoa. Echa mbaeti güɨrovia cheré. Oicuaucata jupi vae. Echa ajata cheRu oia pe jare pe reta ngaraa ye ma cherecha. Oicuaucata Tumpa ojaata ɨvɨ pegua reta. Echa ojaa ma ɨvɨ pegua reta juvicha —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Oime jeta aipota tei jae peve vae, erei mbaeti vɨteri pepuere peicuaa cavi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Erei Espíritu Santo añete vae re imiarita vae ou ma yave, omombeuta peve añete vae. Echa ñee omombeuta peve vae ngaraa imbae aeño. Imiarita Tumpa omombeu chupe vae re, jare omombeuta peve oyeapota vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jae chemboeteucata co. Echa jae pemboeta che pomboe rami —jei Jesús chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Opaete cheRu imbae chembae vi co. Jae rambue che jae corai: “Jae pemboeta che pomboe rami” —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Michi peguaño ma pe reta cherechata. Erei ɨmambae cherecha yeta. Echa ajata cheRu pɨri —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Amogüe jemimboe reta jei oyoupe: —¿Mbae pa oipota jei cuae jei ñandeve vae? Echa jei: “Michi peguaño ma pe reta cherechata. Erei ɨmambae cherecha yeta”. Jare jei vi: “Echa ajata cheRu pɨri”. ");
INSERT INTO guiNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Mbae pa oipota jei: “Michi peguaño ma”? Mbaeti yaicuaa mbae ra oipota jei —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús oicuaa jae reta oipota tei oparandu chupe cuae re. Jae rambue jei chupe reta: —Che jae peve corai: “Michi peguaño ma pe reta cherechata. Erei ɨmambae cherecha yeta”. Jare peparandu pei oyoupe mbae ra oipota jei cuae che jae peve vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Añete che jae peve, peyaeota jare pepɨatɨtɨta, erei oporogüɨrovia mbae vae reta oyeroviata. Pepɨatɨtɨta co, erei pepɨatɨtɨ güire peyeroviata co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Metei cuña imembɨ oata ma oi yave, cuña ipɨatɨtɨ jasɨ chupe rambue. Erei imembɨ oa ma yave, mbaeti ma imaendúa jasɨ chupe vae re. Echa oyerovia imembɨ oa ma rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jae ramiño vi pe reta pepɨatɨtɨ añave, erei poecha yeta, jare peyeroviata, jare ngaraa quia ipuere pembopɨatɨtɨ ye —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jocuae ara ngaraa peparandu cheve mbae re. Añete che jae peve, oipotagüe peyerureta cheRu pe jese vae cheRu omeeta peve cheree re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ndei rani peyerure mbae re cheree re. Peyerure Tumpa pe mbaembae re, jare cheRu omeeta co peve peyerovia yae vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Cuae amombeu ma peve amojaanga reve. Erei outa ma ara amombeu cavi vaera peve cheRu regua. Ngaraa ye amombeu peve amojaanga reve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jocuae ara reta pe peyerureta mbaembae re cheree re. Jare che mbaeti jae peve ayerureta cheRu pe jae oyapo vaera peyerure jese vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Echa cheRu etei peraɨu, pe reta cheraɨu jare perovia che ayu cheRu güi rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ayu co cheRu güi cuae ɨvɨ pe. Aja yeta ma cuae ɨvɨ güi cheRu pɨri —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jesús jemimboe reta jei chupe: —Añave remombeu cavi ma oreve remojaanga mbae reve. ");
INSERT INTO guiNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Añave roicuaa nde reicuaa co opaete, jare mbaeti remonesesita quia omombeu vaera ndeve mbae re. Cuae jeco pegua rogüɨrovia nde reyu co Tumpa güi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús jei chupe reta: —Pe reta pere perovia ma. ");
INSERT INTO guiNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Erei outa ma ara - ou ma co - pe reta peñemoai vaera. Chereyata jare metei ñavo peota pero pe. Cheño apɨtata. Erei ngaraa cheño aico. Echa cheRu oico che ndive —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cuae che jae ma peve pepɨacatu vaera cheré perovia rambue. Cuae ɨvɨ pe peico rambueve, peiporarata co. Erei agüɨye pepɨatɨtɨ. Echa che chepuere yae ɨvɨ pegua reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cuae jei ma yave, Jesús omae ara re jare jei: —CheRu, ara ovae ma. Che co jae ndeRaɨ. Chemboeteuca, chepuere vaera romboeteuca vi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Echa nde cheapo ma opaete vae iYara, amee vaera tecove opa mbae vae opaete nde remee cheve vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Oime yave quia ñandecuaa vae, jae güɨnoi tecove opa mbae vae. Nde co jae meteiño Tumpa añetete vae. Che co jae Jesucristo. Nde chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Che romboeteuca ma cuae ɨvɨ pe. Echa opa ma ayapo mbaravɨquɨ nde remee cheve ayapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndei ɨvɨ oyeapo mbove aico nde ndive yave añemboeteuca co. Jae ramiño vi añave chemboeteuca ye nderóvai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nde remee ma cheve cuae cuimbae reta oporogüɨrovia mbae vae reta ipɨte güi. Che amombeu ma nderegua cuae reta pe. Jae reta nembae co jare nde remee ma cheve. Jae reta oyapo nde rere chupe reta oyapo vaera vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jae reta oicuaa opaete nde remee cheve vae ou co ndegüi. ");
INSERT INTO guiNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Echa che amee ma chupe reta ñee nde remee cheve vae, jare jae reta güɨrovia neñee. Oicuaa cavi che ayu co ndegüi. Güɨrovia ma nde co chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ayerure ndeve jese reta. Mbaeti ayerure oporogüɨrovia mbae vae reta re. Ayerure ndeve nde remee cheve vae reta re. Echa jae reta nembae co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Opaete chembae nembae co, jare nembae chembae co. Jare che añemboeteuca ma jae reta jeco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jare ngaraa ma aico cuae ɨvɨ pe. Erei jae reta opɨtañota cuae ɨvɨ pe. Che ajata ma ndepɨri. CheRu, nde co jae jupi vae. Cuae reta remee ma cheve. Emborɨ nembaepuere pe, agüɨye vaera oyerova ndegüi, jare yogüɨreco vaera metei ramiño. Echa jocorai ñande yaico metei ramiño —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Che aico jae reta ndive rambueve, che amborɨ nembaepuere pe cuae remee cheve vae reta, agüɨye vaera oyerova ndegüi. Meteiño ojota cañɨtei pe, neñee pe oyecuatía oi vae oyeapo vaera. Erei amborɨ iru reta, agüɨye vaera yogüɨraja cañɨtei pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Erei ajata ma ndepɨri. Corai chemiari chupe reta ɨvɨ pe aico rambueve, jae reta oyerovia yae vaera che ayerovia yae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amee ma chupe reta neñee, jare oñemotareɨuca oporogüɨrovia mbae vae reta pe. Che mbaeti aico oporogüɨrovia mbae vae reta yogüɨreco rami. Jae ramiño vi jae reta mbaeti yogüɨreco oporogüɨrovia mbae vae reta yogüɨreco rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mbaeti ayerure ndeve nde reraja vaera cuae ɨvɨ güi. Ayerure ndeve remborɨ vaera, agüɨye vaera icavi mbae vae iya omoamɨri —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Che mbaeti aico oporogüɨrovia mbae vae reta yogüɨreco rami. Jae ramiño vi jae reta mbaeti yogüɨreco oporogüɨrovia mbae vae reta yogüɨreco rami. ");
INSERT INTO guiNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Eñono tee reta ndeyeupeguara añete vae rupi. Neñee co jae añete vae —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nde chembou ɨvɨ pe. Jae ramiño vi che amondo cuae reta opaete ɨvɨ rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cuae reta jeco pegua añeñono tee ma ndeveguara, jae reta vi oñeñono tee vaera ndeveguara añete vae rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Jare ayerure ndeve cheré güɨroviata vae re. Echa güɨroviata cuae reta iñee rupi. Mbaeti cuae reta reño ayerure ndeve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ayerure ndeve opaete jae reta yogüɨreco vaera metei ramiño. Nde reico che ndive, cheRu, jare che aico nde ndive. Jae ramiño vi ayerure ndeve cuae reta yogüɨreco vaera ñanderé güɨrovia reve, ɨvɨ pegua reta güɨrovia vaera nde co chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nde chemboeteuca co. Jae ramiño vi che amboeteuca cuae reta, jae reta yogüɨreco vaera metei ramiño. Echa jocorai ñande yaico metei ramiño —jei Jesús—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nde reicota che ndive jare che aicota ipɨa pe, añetete yogüɨreco vaera metei ramiño, ɨvɨ pegua reta oicuaa vaera nde co chembou jare nde reaɨu co cuae reta nde cheraɨu rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","CheRu, aipota cuae remee cheve vae reta vi yogüɨreco vaera che aicotaa pe, oecha vaera maemboete nde remee ma cheve vae. Echa ndei ɨvɨ oyeapo mbove nde cheraɨuño mai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","CheRu, nde co jae jupi vae. Oporogüɨrovia mbae vae reta mbaeti ndecuaa. Erei che co rocuaa, jare cuae reta oicuaa nde co chembou —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Che romombeu ma chupe reta jare romombeu yeta, jae reta nderaɨu vaera nde cheraɨu rami, jare che aico vaera ipɨa pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús cuae jei ma yave, oasa jemimboe reta ndive ɨaca Cedrón, jee vae jovaicho pe ojo ovae ɨvɨra reta ñogüɨnoia pe. Joco pe oique Jesús jare jemimboe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jare Judas - jae co omoeterenga jovaicho reta pe vae - oicuaa jocuae ɨvɨra reta ñogüɨnoia. Echa joco pe oñemboatɨñoi yepi Jesús jemimboe reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jayave Judas ojo sacerdote reta itenondegua reta jare fariseo reta ñogüɨnoia pe, jare jae reta omondo amogüe sundaro reta jare jembiócuai reta ɨvɨra reta ñogüɨnoia cotɨ Judas jupíe. Güɨraja reta mechero reta jare ɨvɨra reta jare quɨsepucu reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jayave Jesús ojo jae reta cotɨ jare jei: —¿Quia pa peeca? Echa jae oicuaa ma mbae oyeapota chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazaret pegua —jei reta. —Che co jae —jei Jesús. Jare Judas - jae co omoeterenga jovaicho reta pe vae - oñemboɨ oi joco pe jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús jei yave chupe reta: “Che co jae”, jae reta opa oñemoata jaɨcue cotɨ jare oa reta ɨvɨ re. ");
INSERT INTO guiNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jayave Jesús oparandu ye chupe reta: —¿Quia pa peeca? Jei reta ye: —Jesús Nazaret pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Amombeu ma peve che co jae —jei Jesús—. Pe reta che chereca. Jae rambue pemaeño cuae che ndive ñogüɨnoi vae reta re yogüɨraja vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cuae jei oyeapo vaera tenonde yave jei vae: “Mbaeti amocañɨ metei ave nde remee cheve vae reta güi”. Jocorai jei ma. ");
INSERT INTO guiNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jare Simón Pedro güɨnoi metei quɨsepucu. Jayave oequi jɨru güi jare oiporu sacerdote tenondegua jembiócuai inambi iyacatu re, jare inambi oyeequi. (Jocuae tembiócuai jee co Malco.) ");
INSERT INTO guiNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jayave Jesús jei Pedro pe: —Eñono ye ndequɨsepucu jɨru pe. Aiporarañotai co. Echa cheRu oipota aiporara vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jayave sundaro reta juvicha ndive jare judío reta itenondegua reta jembiócuai reta oipɨɨ Jesús oñapɨti. ");
INSERT INTO guiNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jayave güɨraja Jesús Anás pe rani - jae co Caifás jembireco tu - Caifás co jae sacerdote tenondegua jocuae año. ");
INSERT INTO guiNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tenonde yave cuae Caifás omombeu judío reta pe icavita co chupe reta metei cuimbae omano vaera opaete tenta pegua reta jecovia pe. ");
INSERT INTO guiNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jare Simón Pedro jare iru temimboe yogüɨraja Jesús jaɨcue. Jare cuae iru temimboe oique sacerdote tenondegua joca pe Jesús oique yave. Echa sacerdote tenondegua oicuaa cuae temimboe. ");
INSERT INTO guiNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Erei Pedro mbaeti oique oca pe. Opɨta oñemboɨ oi taraquera iyɨpɨ pe. Jayave iru temimboe sacerdote tenondegua oicuaa vae oe imiari cuñatai taraquera oaro vae pe jare güɨroique Pedro. ");
INSERT INTO guiNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jayave cuñatai taraquera oaro vae jei Pedro pe: —¿Jaea pa co nde metei jocuae cuimbae jemimboe? —Mbaeti co —jei Pedro. ");
INSERT INTO guiNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jare sacerdote tenondegua jembiócuai reta jare judío reta itenondegua reta jembiócuai reta oyapo ma tata jare oñemboɨ reta tata iyɨpɨ rupi oyepee vaera. Echa iroɨ ma. Pedro vi opɨta joco pe oñemboɨ jae reta ndive oyepee vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jayave sacerdote tenondegua oparandu Jesús pe jemimboe reta re jare iporomboe re. ");
INSERT INTO guiNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jayave Jesús jei chupe: —Che chemiari co opaete vae jovaque. Jecuaeño aporomboe judío reta itupao reta pe jare Tumpa jo pe. Echa joco pe jecuaeño oñemboatɨ judío reta. Mbaeti etei chemiari vɨari pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Maera pa reparandu cheve? Eparandu oyeapɨsaca cheré vae reta pe che jae chupe reta vae re. Jae reta oicuaa che jae vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuae jei ma yave Jesús, metei judío reta itenondegua reta jembiócuai joco pe oi vae ocua Jesús jova re. —¿Maera pa jocorai nemiari sacerdote tenondegua pe? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Mbaeti yave icavi chemiari, emombeu mbae ra mbaeti icavi —jei Jesús—. Erei icavi chemiari. ¿Maera pa recua cheré? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jayave Anás omondo Jesús iyocuaa reve Caifás pɨri - jae vi co sacerdote tenondegua. ");
INSERT INTO guiNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jare Simón Pedro oñemboɨ oyepee oi tata pe. Iru vae reta jei chupe: —¿Jaea pa co nde metei jemimboe? Pedro oicuacu. Jei: —Mbaeti co. ");
INSERT INTO guiNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Metei sacerdote tenondegua jembiócuai - jae co jocuae cuimbae oyeequi inambi Pedro ocua jese yave vae jentara - jei Pedro pe: —Che roecha co ɨvɨra reta ñogüɨnoia pe jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro jei ye: —Mbaeti co. Jare cuae jei ma yave, tacareo oñee. ");
INSERT INTO guiNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jayave güɨraja reta Jesús Caifás jo güi pretorio jee vae pe. Neimbove asɨ vɨteri. Jae reta mbaeti oique pretorio japɨpe pe. Echa oique yave joco pe jocuae ara, iporomboe omombeu chupe reta oñemonguɨata tei co, jare ngaraa tei ipuere jou vecha isoo pascua pegua. ");
INSERT INTO guiNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jayave Pilato oe chupe reta. —¿Mbae re pa pemboeco cuae cuimbae? —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Cuae cuimbae jecocavi yave mona, ngaraa tei romoeterenga ndeve —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Pe reta etei peraja pejaa vaera peporoócuai rupi —jei Pilato. —Romano reta mbaeti omaeño oreré royuca vaera quia —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jocorai jei reta, oyeapo vaera Jesús jei ma oyeapota chupe vae. Echa Jesús omombeu ma quiraita co omano. ");
INSERT INTO guiNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jayave Pilato oique ye pretorio pe jare oeni Jesús. —¿Nde pa co jae judío reta juvicha guasu? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Nde aeño pa reñemongueta jocorai, ani iru vae reta pa omombeu ndeve cheregua? —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Che mbaeti co metei judío —jei Pilato—. Nerentaɨgua reta jare sacerdote reta itenondegua reta nemoeterenga cheve. ¿Mbae pa reyapo? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Che co jae metei mburuvicha guasu —jei Jesús—, erei che mbaeti co mburuvicha guasu ɨvɨ pegua reta rami. Che jocuae reta rami yave mona, cherembiócuai reta oñorarota tei, agüɨye vaera añemoeterenga judío reta pe. Erei che mbaeti co mburuvicha guasu ɨvɨ pegua reta rami —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jayave Pilato jei chupe: —¿Nde pa co jae metei mburuvicha guasu? —Nde rere ma che co jae metei mburuvicha guasu —jei Jesús—. Cuaera ayeapo cuimbaera. Cuaera ayu ɨvɨ pe. Ayu amombeu vaera añete vae. Opaete añete vae güɨrovia vae reta oyeapɨsaca cheñee re —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jayave Pilato oparandu chupe: —¿Mbae pa jocuae añete vae? Jare cuae jei ma yave, Pilato oe ye judío reta jóvai jare jei chupe reta: —Mbaeti etei teco avae jese. ");
INSERT INTO guiNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Erei pe reta jecuaeño peipota ayora vaera peve metei tembipɨɨ pascua pe. ¿Peipota pa ayora vaera peve cuae judío reta juvicha guasu? —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jae reta iñeeata reve jei: —Agüɨye eyora jocuae cuimbae. Eyora oreve Barrabás —jei reta. Jocuae Barrabás imonda vae co. ");
INSERT INTO guiNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jayave Pilato güɨrajauca Jesús oinupauca chicote pe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jare sundaro reta oñope yuu catuai vae Jesús iñaca reguara, jare oñono Jesús iñaca re. Jare omondeuca reta Jesús pe temimonde pɨta vae. ");
INSERT INTO guiNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jayave jei reta chupe: —¡Viva! Judío reta juvicha guasu. Jayave ocua reta jese ipo pe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jayave Pilato oe ye, jare jei judío reta pe: —Mase, aruta peve peicuaa vaera mbaeti co avae teco jese. ");
INSERT INTO guiNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jayave Jesús oe. Güɨnoi jocuae yuu catuai vae iñaca re jare omonde temimonde pɨta vae. Jayave Pilato jei ye chupe reta: —Mase, co oi cuae cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote reta itenondegua reta jare jembiócuai reta oecha yave Jesús, iñeeata reve jei: —¡Eicutuca curusu re, eicutuca curusu re! Jayave Pilato jei chupe reta: —Pe reta etei peraja peicutuca curusu re. Echa che mbaeti etei teco avae jese —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío reta jei Pilato pe: —Ore rogüɨnoi metei mboroócuai, jare jocuae mboroócuai rupi omanota co. Echa jei jae co Tumpa Taɨ —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cuae oendu yave, Pilato oquɨye yae. ");
INSERT INTO guiNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jayave oique ye pretorio pe jare oparandu Jesús pe: —¿Quia pegua pa nde? Erei Jesús mbaeti mbae jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jayave Pilato jei ye chupe: —¿Maera pa mbaeti neñee remoe cheve? Che anoi mbaepuere rocutuca vaera curusu re. Anoi vi mbaepuere royora vaera. ¿Mbaeti pa reicuaa cuae? —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Mbaeti yave Tumpa omaeño nderé, ngaraa tei ndepuere cheré —jei Jesús—. Jae rambue chemoeterenga ndeve vae iyoa yae ma co. ");
INSERT INTO guiNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cuae oendu ma yave, Pilato oipota tei oyora Jesús. Erei judío reta iñeeata reve jei: —Cuae cuimbae reyora yave, nde mbaeti ma co reyeócuai César pe. Echa oipotagüe jei jae co mburuvicha guasu vae oyovaicho ma César ndive —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato cuae oendu yave, güɨnoe Jesús jare oguapɨ Empedrado jee vae pe. (Cuae co jee Gabata hebreo iñee pe.) Echa joco pe jecuaeño ojaa teco güɨnoi vae reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jare jocuae ara judío reta oyeapocatu ñogüɨnoi pascua peguara, jare neimbove asɨ vɨteri. Jayave Pilato jei judío reta pe: —Co oi peruvicha guasu. ");
INSERT INTO guiNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jayave jae reta iñeeata reve jei: —¡Erajauca cuae güi, erajauca cuae güi, eicutuca curusu re! Pilato oparandu chupe reta: —¿Aicutucata pa peruvicha guasu? Jayave sacerdote reta itenondegua reta jei: —Jaeño César oreruvicha guasu co. ");
INSERT INTO guiNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jayave Pilato omoeterenga Jesús chupe reta oicutuca vaera curusu re. Jayave jae reta oipɨɨ Jesús güɨraja. ");
INSERT INTO guiNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jayave Jesús oe jare ovoɨ güɨraja icurusu. Jayave sundaro reta güɨraja Jesús Acagüerenda jee vae pe. (Cuae co jee Gólgota hebreo iñee pe.) ");
INSERT INTO guiNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Joco pe oicutu reta Jesús curusu re. Oicutu reta vi iru mócoi cuimbae reta jare oñono metei Jesús iyacatu cotɨ jare iru iyasu cotɨ. Jesús oi ipau pe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jare Pilato oicuatía curusu re oñonouca vaera. Corai oyecuatía oi: “Jesús Nazaret pegua, judío reta juvicha guasu”. ");
INSERT INTO guiNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jare jeta judío reta omongueta cuae oyecuatía oi vae. Echa Jesús oyecutucaa coiño oi tenta güi. Jare oyecuatía oi hebreo iñee pe jare griego iñee pe jare latín pe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jayave judío reta isacerdote reta itenondegua reta jei Pilato pe: —Agüɨyeta tei co reicuatía: “Judío reta juvicha guasu”. Reicuatiata tei co: “Cuae cuimbae jei, Che co jae judío reta juvicha guasu” —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Cuae aicuatía vae aicuatía ma co —jei Pilato. ");
INSERT INTO guiNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jare sundaro reta oicutu ma yave Jesús, irundɨ reve oñemombae Jesús jemimonde reta re omboyao ma yave. Erei jemimonde ipucu vae mbaeti oñembovɨvɨ. Oyeapo metei güiño. Cuae vi sundaro reta oequi chugüi. ");
INSERT INTO guiNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jayave sundaro reta jei oyoupe: —Agüɨye ñamondoro. Ñañembosortea jese, yaicuaa vaera quia ra güɨrajata —jei reta. Corai oyeapo Tumpa iñee pe oyecuatía oi vae. Echa oyecuatía oi corai: “Omboyao iyeupe reta cheremimonde reta. Oñembosortea cheremimonde re, oicuaa vaera quia ra güɨrajata”. Jocorai oyecuatía oi, jare jocorai oyapo sundaro reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jare oñemboɨ ñogüɨnoi Jesús icurusu iyɨpɨ pe Jesús ichɨ, jare ichɨ ipɨquɨɨ, jare María - jae co Cleofas jembireco - jare María Magdalena. ");
INSERT INTO guiNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús oecha ichɨ jare jemimboe jae oaɨu vae oñemboɨ ñogüɨnoi coiño chugüi. Jare jei ichɨ pe: —Chesɨ, joco oi nemembɨra. ");
INSERT INTO guiNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cuae jaɨcue rupi jei jemimboe pe: —Joco oi ndesɨra. Jae rambue jocuae ora güive jocuae jemimboe güɨraja jenta pe Jesús ichɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cuae jaɨcue rupi Jesús jei: —Ɨ ayúe. Corai oyeapo ma Tumpa iñee pe oyecuatía oi vae. Echa Jesús oicuaa opaete iparavɨquɨ opa ma. ");
INSERT INTO guiNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jare joco pe oi vinagre metei yapepo pe. Jayave omoaquɨ reta esponja vinagre pe. Jayave oñono reta ɨvɨra re jare omondo Jesús iyuru pe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jare Jesús jou ma yave vinagre, jei: —Opa ma. Jayave iñacatindɨ jare omano. ");
INSERT INTO guiNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jare jocuae ara judío reta oyeapocatu ñogüɨnoi pascua peguara. Jae rambue oyerure reta Pilato pe omopeuca vaera curusu re ñogüɨnoi vae reta itɨmaca jare güɨrajauca vaera joco güi. Echa mbaeti oipota jetegüe reta opɨta vaera curusu reta re jocuae mbutuu iara pe. Echa jocuae mbutuu iara omboete yae reta. ");
INSERT INTO guiNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jae rambue sundaro reta yogüɨraja omope metei cuimbae Jesús ndive curusu re oyecutu oi vae itɨmaca. Jayave omope iru cuimbae itɨmaca. ");
INSERT INTO guiNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Erei yogüɨraja yave Jesús pe, oecha omano ma. Jae rambue mbaeti omope itɨmaca. ");
INSERT INTO guiNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Erei metei sundaro oicutu metei mi pe Jesús iyɨque, jare oe voi tugüɨ jare ɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jare oecha vae omombeu cuae, pe reta vi perovia vaera. Jare cuae omombeu vae añete co. Echa jae oicuaa cavi omombeu vae añete co. ");
INSERT INTO guiNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Echa opaete cuae oyeapo Tumpa iñee pe oyecuatía oi vae oyeapo vaera. Echa oyecuatía oi corai: “Ngaraa icagüe ave ope”. ");
INSERT INTO guiNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jare: “Omae retata jocuae oicutu reta vae re”. Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cuae jaɨcue rupi José Arimatea pegua oyerure Pilato pe güɨraja vaera Jesús jetegüe. Cuae José co jae metei Jesús jemimboe, erei mbaeti oyecuauca. Echa oquɨye judío reta güi. Jayave Pilato jei chupe ipuere güɨraja Jesús jetegüe. ");
INSERT INTO guiNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo vi ou —jae co tenonde yave ojo pɨtu yave Jesús pɨri vae. Jae güeru mirra jare áloes oyeagüe vae. Oupitɨ ipoɨ treinta kilo rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jayave ombogüeyɨ reta Jesús jetegüe, jare oñoma mbae ipiche cavi vae reta reve lienzo pe. Echa jocorai jecuaeño judío reta jeco jetegüe oñotɨ yave. ");
INSERT INTO guiNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jare Jesús oyecutucaa pe oi metei ɨvɨra reta ñogüɨnoia, jare jocuae ipɨte pe oi metei teogüerɨru ipɨau vae. Mbaeti quia oñeñono pɨpe vɨteri. ");
INSERT INTO guiNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jocuae ara judío reta oyeapocatu ñogüɨnoi pascua peguara. Jae rambue oñono reta Jesús jocuae teogüerɨru pe. Echa coiño oi. ");
INSERT INTO guiNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jare ndei coe ngatu mbove semana iara tenondegua vae pe María Magdalena ou teogüerɨru pe, jare oecha ita oñembosɨrɨ ma teogüerɨru güi. ");
INSERT INTO guiNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jayave osɨi ojo Simón Pedro jare iru temimboe Jesús oaɨu vae pe, jare jei chupe reta: —Güɨraja reta ma ñandeYa teogüerɨru güi, jare mbaeti roicuaa quiape ra oñono reta. ");
INSERT INTO guiNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jayave Pedro jare iru temimboe oe pave jare yogüɨraja teogüerɨru cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mócoi reve osɨi pave, erei iru temimboe iñacua yae Pedro güi, jare ojo ovae teogüerɨru pe Pedro jenonde. ");
INSERT INTO guiNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jayave oñaɨvɨ omae vaera japɨpe pe, jare oecha lienzo reta joco pe oi, erei mbaeti oique. ");
INSERT INTO guiNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jayave Simón Pedro ojo ovae jaɨcue, jare oique teogüerɨru pe. Jare oecha lienzo reta joco pe oi. ");
INSERT INTO guiNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Oecha vi lienzo Jesús iñaca re tenonde yave oñeñono vae oñeomaoma oi tee iru lienzo reta güi. ");
INSERT INTO guiNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jayave jocuae iru temimboe vi - jae Pedro jenonde ojo ovae vae - oique teogüerɨru pe, jare oecha yave, oporogüɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Echa ndei oicuaa cavi reta Tumpa iñee pe oyecuatía oi vae quirai Jesús oicove yeta ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jayave temimboe reta yogüɨraja ye jo ae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Erei María oñemboɨ oi teogüerɨru iyɨpɨ pe. Oyaeo oi. Jare oyaeo oi rambueve, oñaɨvɨ omae vaera teogüerɨru japɨpe pe. ");
INSERT INTO guiNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jare oecha mócoi araɨgua reta oguapɨ ñogüɨnoi Jesús jetegüe oñeñonoa pe. Metei oguapɨ oi Jesús iñaca jendagüe cotɨ jare iru Jesús ipɨta jendagüe cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Araɨgua reta jei María pe: —¿Maera pa reyaeo? —Güɨraja reta ma cheYa, jare mbaeti aicuaa quiape ra oñono reta —jei María. ");
INSERT INTO guiNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cuae jei ma yave, María oyerova jare oecha Jesús oñemboɨ oi joco pe. Erei mbaeti oicuaa jae co Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jayave Jesús jei chupe: —Cuña, ¿maera pa reyaeo? ¿Quia pa reeca? María oñemongueta tei jae co ɨvɨra reta ñogüɨnoia iñangarecoa. Jae rambue jei chupe: —Carai, nde reraja yave, emombeu cheve quiape reñono, jare che arajata. ");
INSERT INTO guiNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—¡María! —jei Jesús chupe. María oyerova ye icotɨ jare jei chupe: —Raboni. (Cuae oipota jei: Oporomboe vae.) ");
INSERT INTO guiNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jayave Jesús jei chupe: —Agüɨye chepɨɨ. Echa ndei ayeupi cheRu pɨri. Erei ecua emombeu cherɨvɨ reta pe che jae corai: Ajata ma cheRu pɨri - jae co peRu vi. Jae co cheTumpa - jae co peTumpa vi —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jayave María Magdalena ojo omombeu Jesús jemimboe reta pe. —Aecha ma ñandeYa —jei. Jayave omombeu chupe reta Jesús jei chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jare jocuae pɨtu - semana iara tenondegua vae co - Jesús jemimboe reta ñogüɨnoia jonque reta oñeoquenda ñogüɨnoi. Echa jae reta oquɨye judío reta güi. Jayave ou Jesús oñemboɨ ipɨte pe jare jei chupe reta: —Peñembopɨacatu. ");
INSERT INTO guiNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cuae jei ma yave, Jesús oechauca chupe reta ipo jare iyɨque. Jayave Jesús jemimboe reta oyerovia. Echa oecha ma iYa. ");
INSERT INTO guiNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jayave Jesús jei ye chupe reta: —Peñembopɨacatu. CheRu chembou. Jae ramiño vi che pomondo —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jare cuae jei ma yave, ipɨtué omoe icotɨ reta jare jei: —Amee ma peve Espíritu Santo. ");
INSERT INTO guiNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Peɨro yave oipotagüe vae pe imbaeyoa re, imbaeyoa oñemboaita co. Jare mbaeti yave peɨro oipotagüe vae pe imbaeyoa re, imbaeyoa ngaraa oñemboai —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jare jocuae doce jemimboe reta güi metei Tomás jee vae - jae co Chaguaqui pe oñembojee vae - mbaeti joco pe oi iru reta ndive Jesús ou yave. ");
INSERT INTO guiNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jare iru Jesús jemimboe reta jei Tomás pe: —Roecha ma ñandeYa. Erei Tomás jei: —Mbaeti yave aecha oyecutuagüe ipo re jare añono chepoaca oyecutuagüe pe jare añono chepo iyɨque pe, ngaraa arovia. ");
INSERT INTO guiNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Metei semana rupi temimboe reta ñogüɨnoi ye jocuae o pe. Tomás vi joco pe oi. Yepe tei onque reta oñeoquenda ñogüɨnoi, erei Jesús ou oñemboɨ ipɨte pe jare jei: —Peñembopɨacatu. ");
INSERT INTO guiNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jayave jei Tomás pe: —Emae chepo re. Eñono cuae pe nepoaca. Eupi ndepo eñono cheɨque pe. Agüɨye mo eico ndeporogüɨrovia mbae reve. Mborogüɨrovia reve mo eico —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Nde co jae cheYa jare cheTumpa —jei Tomás. ");
INSERT INTO guiNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jayave Jesús jei: —Reporogüɨrovia ma cherecha rambue. Oyerovia yaeta jocuae cherecha mbae reve oporogüɨroviata vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jare Jesús oyapo jemimboe reta jovaque jeta iru mɨacañɨ reta oicuauca vaera quia co jae, yepe tei mbaeti oyecuatía oi cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Erei aicuatía cuae pe oyecuatía oi vae, perovia vaera Jesús co jae Cristo - jae co Tumpa Taɨ - jare penoi vaera tecove opa mbae vae cuae perovia yave. ");
INSERT INTO guiNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cuae jaɨcue rupi Jesús oyecuaa ye jemimboe reta pe ɨ Tiberias jee vae iyɨpɨ pe. Oyecuaa chupe reta corai: ");
INSERT INTO guiNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro jare Tomás - jae co Chaguaqui pe oñembojee vae - jare Natanael Caná pegua - jocuae Caná Galilea pegua co - jare Zebedeo taɨ reta jare mócoi iru temimboe reta oñemboatɨ. ");
INSERT INTO guiNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jayave Simón Pedro jei iru reta pe: —Ajata ayeporaca vaera. —Ore vi rojota nde ndive —jei reta. Jayave yogüɨraja oyeupi chalana pe. Erei jocuae pɨtu mbaeti mbae omboa. ");
INSERT INTO guiNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jare coeta ma yave Jesús oñemboɨ oi ɨ jembeɨ pe. Erei temimboe reta mbaeti oicuaa jae co Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jayave Jesús jei chupe reta: —Cherɨvɨ reta, ¿pemboa ma pa mbae? —Mbaeti —jei reta chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Pemombo pepɨsa chalana iyacatu cotɨ jare pemboata co jevae reta —jei Jesús. Jayave jocorai oyapo reta, jare mbaeti ma ipuere omoata pɨsa ɨ güi jeta yae jevae omboa ma rambue. ");
INSERT INTO guiNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jayave jocuae temimboe Jesús oaɨu vae jei Pedro pe: —Jae co ñandeYa. Simón Pedro oendu yave jocuae cuimbae co jae iYa, oñemonde jare ogüeyɨ voi ɨ pe. Echa omboi jemimonde oparavɨquɨ cavi vaera. ");
INSERT INTO guiNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jare iru reta yogüeru chalana pe. Jae reta omoata pɨsa jevae reve. Echa coiño ñogüɨnoi ɨ jembeɨ güi - cien metro rupi. ");
INSERT INTO guiNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jare yogüeru oe ɨ güi yave, oecha tata tatapɨi pegua joco pe. Oecha vi jevae ɨ rupigua tata iárambue jare mbɨyape vi. ");
INSERT INTO guiNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jayave Jesús jei chupe reta: —Peru amogüe jevae pemboa ma vae. ");
INSERT INTO guiNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jayave Simón Pedro oyeupi ye chalana pe jare omoata pɨsa ɨ güi. Pɨsa tɨnɨe jevae tuicha vae pe - güɨnoi ciento cincuenta y tres. Erei yepe tei jeta yae, erei mbaeti omondoro pɨsa. ");
INSERT INTO guiNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jayave Jesús jei chupe reta: —Peyu rani pecaru. Jare mbaeti metei ave jemimboe iquɨreɨ oparandu chupe: “¿Quia pa co nde?” Echa oicuaa jae co iYa. ");
INSERT INTO guiNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jayave Jesús ojo oipɨɨ mbɨyape omee chupe reta. Jae ramiño vi omee chupe reta jevae. ");
INSERT INTO guiNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jare mboapɨ vese ma cuae re Jesús oyecuaa jemimboe reta pe oicove ye güire ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ocaru reta ma yave, Jesús jei Simón Pedro pe: —¡Simón, Jonás taɨ! ¿Cheraɨu yae pa cuae reta güi? —Roaɨu, cheYa —jei Pedro—. Reicuaa che roaɨu co. —Emongaru chevecha-raɨ reta —jei Jesús chupe. ");
INSERT INTO guiNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús jei ye chupe: —¡Simón, Jonás taɨ! ¿Cheraɨu pa? —Roaɨu, cheYa —jei ye Pedro—. Reicuaa che roaɨu co. —Eñangareco chevecha reta re —jei Jesús. ");
INSERT INTO guiNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús jei ye chupe mboapɨa re: —¡Simón, Jonás taɨ! ¿Cheraɨu pa? Pedro ipɨatɨtɨ. Echa mboapɨ vese ma Jesús jei chupe: “¿Cheraɨu pa?” Jayave jei ye: —CheYa. Nde reicuaa opaete. Nde reicuaa che roaɨu co. —Emongaru chevecha reta —jei Jesús chupe—. ");
INSERT INTO guiNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Añete che jae ndeve, nde ndetaɨrusu yave, reyecuacua jare reguata reipota reoa rupi. Erei nendechi yave, reupita ndeyɨva jare iru vae ndeocuata jare ndererajata mbaetita reipota reoa pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Cuae jei Jesús omombeu vaera quiraita co omano Pedro. Jare Pedro omano yave, Tumpa oñemboeteucata co imano rupi. Jayave Jesús jei ye Pedro pe: —Eyu che ndive. ");
INSERT INTO guiNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro oyerova yave, oecha jocuae temimboe Jesús oaɨu vae ou jaɨcue. Jocuae temimboe co jae tenonde yave ocaru ñogüɨnoi yave ocaru oi Jesús iyɨpɨ pe jare: “¿Quia pa nemoeterengata, cheYa?” jei chupe vae. ");
INSERT INTO guiNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jare Pedro oecha yave jocuae temimboe, oparandu Jesús pe: —¿Mbae pa oyeapota chupe, cheYa? ");
INSERT INTO guiNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús jei chupe: —Che aipota yave jae oico vaera che ayu ye regua, agüɨye ndepɨatɨtɨ jocuae re. Nde eyu che ndive —jei. ");
INSERT INTO guiNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jare opaete oporogüɨrovia vae reta oicuaa cuae Jesús jei vae, jare oñemongueta tei cuae oipota jei jocuae jemimboe ngaraa omano. Erei Jesús mbaeti jei ngaraa omano. Jaeño jei: “Che aipota yave jae oico vaera che ayu ye regua, agüɨye ndepɨatɨtɨ”. ");
INSERT INTO guiNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Che co jae jocuae Jesús jemimboe, jare che amombeu añete co cuae pe oyecuatía oi vae. Echa che aicuatía cuae. Jare opaete roicuaa cuae amombeu vae añete co. ");
INSERT INTO guiNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jare oime ye jeta mbaembae Jesús oyapo vae. Opaete cuae mbaembae regua oyecuatía oi yave meteitei rupi, oatata opaete tupapire jendara ɨvɨ pe. Amén.");
INSERT INTO guiNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, tenonde aicuatía ndeve vae pe amombeu ndeve opaete Jesús omboɨpɨ oyapo vae jare jocuae omboɨpɨ oporomboe jese vae. ");
INSERT INTO guiNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ndei ojo ye ara pe mbove, omee mboroócuai reta Espíritu Santo rupi jemimondo oiparavogüe vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús opa oiporara güire, oyecuaa chupe reta. Jae reta oicuaa catu jae oicove co jeta mbaembae oyapo jovaque vae jeco pegua. Jesús oyecuaa chupe reta cuarenta ara, jare imiari chupe reta Tumpa iporoocuaia re. ");
INSERT INTO guiNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jae reta oñemboatɨ yave, Jesús oyócuai agüɨye vaera yogüɨraja tenta Jerusalén güi. Oyócuai oaro vaera ñandeRu omeeta chupe reta vae. Jesús jei chupe reta: —Jocuae re chemiari ma peve. ");
INSERT INTO guiNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan oporombobautiza ɨ pe, erei pe reta peñembobautizaucata Espíritu Santo pe mbovɨ ara rupi —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jayave yatɨ vae reta oparandu Jesús pe: —OreYa, ¿remaeñota pa Israel pegua reta re oyeapo vaera mburuvicha retara jocuae ara? ");
INSERT INTO guiNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ngaraa peicuaa jocuae ara regua —jei Jesús—. Jaeño cheRu jeita jocuae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Erei pe reta penoita Espíritu Santo imbaepuere, ou yave peve, jare pe reta chemombeuta Jerusalén pe, opaete Judea rupi, Samaria rupi, jare opaete ɨvɨ rupi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jare Jesús opa imiari chupe reta yave, ojo ɨvate, jae reta omae jese rambueve. Jayave metei amapɨtu oyasoi Jesús, jare mbaeti ma oecha reta. ");
INSERT INTO guiNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jare omae ngatu ñogüɨnoi rambueve ara cotɨ, Jesús ojo rambueve, mócoi cuimbae oyecuaa iyɨpɨ pe. Cuae cuimbae reta jemimonde ti asɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Cuae reta jei chupe reta: —Cuimbae Galilea pegua reta, ¿maera pa peñemboɨ pemae pei ara re? Jesús ojo ma pegüi ara pe. Erei jae etei ou yeta jocoraiño, peecha ojo rami —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jayave temimondo reta yogüeru ye Jerusalén pe ɨvɨtɨ Oliva jee vae güi. Jocuae ɨvɨtɨ coiño oi Jerusalén güi. Judío reta iporoócuai omaeño oguata vaera joco pe Jerusalén güi mbutuu iara pe. ");
INSERT INTO guiNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yogüeru ovae yave, oique reta metei o pe, jare oyeupi o ɨvate vae pe. Joco pe yogüɨreco Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo taɨ Jacobo jee vae, Simón Zelote, jare Jacobo tɨvɨ Judas jee vae. ");
INSERT INTO guiNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Opaete cuae reta, jare Jesús ichɨ María jare iru cuña reta, jare Jesús tɨvɨ reta jecuae oyerure metei ramiño. ");
INSERT INTO guiNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Oporogüɨrovia vae joco pe ñogüɨnoi vae reta ciento veinte rupi. Jare metei ara Pedro oñemboɨ ipɨte pe jare jei: ");
INSERT INTO guiNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Cherɨvɨ reta, jupi co oyeapo vaera David aracae oicuatía Judas re vae. Espíritu Santo etei cuae omombeu ñandeve David rupi. Judas güɨraja Jesús oia pe oipɨɨ vae reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jae oicose ñande ndive, jare oyeparavo co oyapo vaera cuae mbaravɨquɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jae omboresive corepoti icavi mbae vae oyapo vae re. Jayave corepoti pe ogua metei ɨvɨ. Joco pe oa ɨvate güi, jare jɨe osoro, jare opaete ichuri oyeecuavo —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cuae jeracua opaete Jerusalén pegua reta pe. Jae rambue jocuae ɨvɨ jee Acéldama jae reta iñee ae pe —jei—. (Acéldama oipota jei: Ɨvɨ tugüɨ jepɨgüe.) ");
INSERT INTO guiNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Echa oyecuatía oi Tumpa iñee pe Salmo reta pe corai: Toyeapo ipo mbae oicoa, jare agüɨye quia toico pɨpe. Jare: Iru vae toyapo iparavɨquɨ. Jocorai oyecuatía oi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Oime cuae pe ñogüɨnoi cuae cuimbae reta. Jae reta yogüɨreco ñande ndive, ñandeYa Jesús oico ñande ndive rambueve. Echa yogüɨreco ñande ndive Juan ombobautiza Jesús güive Jesús ñandepɨte güi ojo regua —jei Pedro—. Jae rambue icavi co cuae cuimbae reta güi metei yaiparavo vaera. Jae omombeuta iru vae reta pe ñande ndive Jesús oicove ye co ou omanogüe vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jayave oiparavo reta mócoi cuimbae. Metei jee co José Barsabás - jae co oñembojee Justo pe vae. Iru cuimbae jee co Matías. ");
INSERT INTO guiNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jayave oyerure reta Tumpa pe corai: —OreYa, nde reicuaa opaete vae ipɨa. Eechauca oreve quia nunga ra reiparavo ma cuae mócoi cuimbae güi, ");
INSERT INTO guiNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","jae omborɨ vaera cuae mbaravɨquɨ pe, jare oico vaera neremimondora. Judas opia cuae mbaravɨquɨ güi, icavi mbae vae oyapo rambue, jare ojo ma jendara jae oiparavo vae pe —jei reta Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jayave oñuvanga reta jee re, oicuaa vaera quia nunga ra Tumpa oiparavo ma. Jare oiparavo Matías, jare jae oyeapo Jesús jemimondora iru once reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés iara pe opaete oporogüɨrovia vae reta metei ramiño oñemboatɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jare güɨramoiño ou ara güi jɨapu vae metei ɨvɨtu tanta oyepeyu vae rami. Tanta jɨapu oguapɨ ñogüɨnoia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jayave oyecuaa chupe reta tataendɨ rami. Cuae oyecuaa metei ñavo iyapɨte re. ");
INSERT INTO guiNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jayave opaete joco pe ñogüɨnoi vae reta tɨnɨe Espíritu Santo pe, jare omboɨpɨ imiari ambué vae iñee Espíritu Santo omee chupe reta imiari vaera vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jare jocuae ara reta pe yogüɨreco Jerusalén pe jeta judío ɨvɨ ñavo güi yogüeru vae reta. Cuae reta omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jare cuae jɨapu vae oñeendu yave, oñemboatɨ jeta vae, jare opaete vae ipɨacañɨ. Echa oporogüɨrovia vae reta imiari ñogüɨnoi, jare metei ñavo yatɨ vae reta oendu iñee ae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ipɨacañɨ reve jei reta: —¡Mase! Galilea pegua reta co opaete cuae imiari vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Quirai ra ñaendu imiari ñaneñee ñanemichi güive ñanemiari pɨpe vae pe? —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ñande co jae Parto pegua, Medo, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO guiNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Frigia, Panfilia, jare Egipto pegua, jare Africa pegua Cirene iyɨpɨ pe yaico vae, jare romano reta cuae pe yaico vae, Creta jare Arabia pegua. Ñande co jae judío reta jare judiora yayeapo vae reta. Opaete ñaendu ñaneñee ae pe imiari ñogüɨnoi mɨacañɨ Tumpa oyapo vae re —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jare opaete yatɨ vae reta ipɨacañɨ jare jei oyoupe: —¿Mbae ra co cuae? ");
INSERT INTO guiNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iru vae reta oyóyai. —Osavaɨpo yae ñogüɨnoi —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jayave Pedro oñemboɨ jocuae iru once Jesús jemimondo reta ndive, jare jei yatɨ vae reta pe iñeeata reve: —Cuimbae Judea pegua reta, jare opaete peico Jerusalén pe vae. Cuae regua peipota peicuaa yave, peyeapɨsaca cheñee re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pe reta peñemongueta tei cuae reta osavaɨpo ñogüɨnoi. Erei mbaeti jocorai. Echa neimbove vɨteri co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tumpa iñee aracae omombeu vae Joel imiari cuae re. Jae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jare ara taɨcuegua reta pe —jei Tumpa— ameeta cheEspíritu opaete vae pe. Jare peraɨ reta jare perayɨ reta omombeuta cheñee. Jare cunumi reta jare indechi vae reta opaɨuta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jare jocuae ara reta pe ameeta cheEspíritu cuimbae reta jare cuña reta oyeócuai cheve vae pe, jare omombeu retata cheñee. ");
INSERT INTO guiNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jare tambou mɨacañɨ reta ara re jare ɨvɨ pe. Oimeta tugüɨ, tata, jare tatati. ");
INSERT INTO guiNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cuaraɨ oñemopɨtumimbita, jare yasɨ oyeapota tugüɨ rami, ndei peya iara ou mbove. Jocuae ara opaete vae ipɨacañɨta co. ");
INSERT INTO guiNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jare opaete oyerureta peYa pe omborɨ vaera vae reta oñemboasaucata co —jei. Jocorai jei Joel —jei Pedro chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro jei ye chupe reta: —Cuimbae Israel pegua reta, peyeapɨsaca cuae re. Tumpa oyapouca pepɨte pe mɨacañɨ reta Jesús Nazaret pegua pe. Jocorai Tumpa oechauca peve Jesús añete vae co. Cuae peicuaa catu co pe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cuae Jesús oñemoeterenga omano vaera, Tumpa jemimbota oyeapo vaera. Tumpa oicuaa opaete ndei oyeapo mbove. Erei pe reta peipɨɨ peicutuca curusu re cuimbae jeco pochɨ vae reta pe peyucauca —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Erei Tumpa oyora mano ñandepɨɨ pɨpe vae güi, jare omoingove ye güeru omanogüe vae reta ipɨte güi. Echa mano mbaeti etei ipuere oyopia Jesús —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Echa David jei Jesús re corai: Aecha cheYa jecuaeño cheróvai. Cheacatu pe oi rambue, ngaraa aquɨye. ");
INSERT INTO guiNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jae rambue ayerovia chepɨa pe, jare chemiari ayecou reve. Aicota co aaro reve. ");
INSERT INTO guiNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Echa mbaetita reeya cherecove omanogüe vae reta ñogüɨnoia pe. Che co jae jupi vae. Mbaetita remaeño cheretegüe re oicomegua vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Reicuauca cheve quirai aico vaera ayerovia reve, jare ayerovia yaeta vi nde ndive ai yave. Jocorai jei David —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Cherɨvɨ reta, chepuere chemiari peve ñanetenondegua David re. Jae omano jare oñeotɨuca, jare iñeotɨa oimeño oi ñande ndive —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Erei Tumpa jei jee ae re David pe omboguapɨta co David iguapɨa pe David iñemoña reta güi metei oporoócuai vaera. Jocuae co jae Cristo. Opaete cuae David oicuaa. Echa David Tumpa iñee aracae omombeu vae oico rambue, ");
INSERT INTO guiNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","oicuaa ndei oyeapo mbove, jare imiari Cristo oicove yeta ou omanogüe vae reta ipɨte güi vae re. Echa jei Cristo re mbaetita co oyeeya jecove omanogüe vae reta ñogüɨnoia pe, jare mbaetita co oicomegua jetegüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tumpa omoingove ye cuae Jesús güeru omanogüe vae reta ipɨte güi, jare ore opareve cuae romombeu iru vae reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tumpa güɨraja ma ara pe imbaepuere pe, jare omee chupe jocuae güɨrocuavee chupe Espíritu Santo re vae. Jae rambue Jesús etei ombou cuae peecha jare peendu vae —jei Pedro chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Echa David mbaeti oyeupi ara pe. Erei jae etei jei corai: ÑandeYa jei cheYa pe: Eguapɨ cheɨque pe cheacatu cotɨ, ");
INSERT INTO guiNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nderovaicho reta amoamɨri regua —jei. Jocorai jei David —jei Pedro chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pe reta co jae Israel pegua reta. Jae rambue peicuaa catu cuae. Pe reta peicutuca Jesús, erei Tumpa oyapo ma ñandeYara - jae co Cristo —jei Pedro. ");
INSERT INTO guiNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuae oendu reta yave, ipɨatɨtɨ yae reta, jare oparandu Pedro jare iru Jesús jemimondo reta pe: —Orerɨqueɨ reta, ¿mbae pa royapota? ");
INSERT INTO guiNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jayave Pedro jei chupe reta: —Peeya peñemongueta icavi mbae vae pepɨa pe oi vae, jare peñembobautizauca Jesucristo jee re, Tumpa iñɨro vaera peve pembaeyoa reta re. Jare jae omeeta peve Espíritu Santo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Echa cuae Tumpa güɨrocuavee vae co jae peveguara, peraɨ reta peguara, opaete mombɨrɨ ñogüɨnoi vae reta peguara, jare opaete ñandeYa Tumpa oenita vae reta peguara —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jare Pedro omboaracuaa jeta iru ñee reta pe. Jei chupe reta: —Añave yogüɨreco vae reta icavi mbae vae oyapo. Peñemboasauca pe reta cuae reta güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jayave Pedro jeigüe güɨrovia vae reta oñembobautizauca, jare jocuae ara tres mil rupi oñemoiru oporogüɨrovia vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jare jecuae oporogüɨrovia vae reta oñemboe Jesús jemimondo reta iporomboe re, jare opaete metei ramiño ñogüɨnoi. Jecuae oñemboatɨ, omboyao tembíu oyoupe, jare oyerure Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jare opaete tenta pegua reta oquɨye, jare Jesús jemimondo reta oyapo jeta mɨacañɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jare opaete oporogüɨrovia vae reta oñemboatɨ, jare opaete imbaembae reta metei ramiño co. ");
INSERT INTO guiNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jare omee imbaembae reta, jare omboyao jepɨgüe mbaeti mbae güɨnoi vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jare ara ñavo yogüɨraja pave Tumpa jo pe. Jare o ñavo rupi omboyao tembíu oyoupe jare ocaru pave reta oyerovia jare ipɨacatu reve. ");
INSERT INTO guiNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jae reta omboete Tumpa, jare opaete tenta pegua reta omae cavi jese reta. Jare ara ñavo ñandeYa omoiru jae reta ndive oñemboasauca vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro jare Juan oyeupi pave Tumpa jo pe, Tumpa pe oyerure vaera, mboapɨ ora ma caaru yave. ");
INSERT INTO guiNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jare iru vae reta güeru ara ñavo metei cuimbae mbaeti ipuere oguata vae oñono Tumpa jo jonque pe. Cuae onque jee co ipora yae vae. Cuimbae ichɨ güi oa güive mbaeti ipuere oguata. Jocuae onque pe cuimbae oyerure corepoti re Tumpa jo pe oique vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cuimbae oecha Pedro jare Juan ndei oique Tumpa jo pe mbove, jare oyerure corepoti re chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jayave Pedro jare Juan omae ngatu jese, jare Pedro jei: —Emae oreré. ");
INSERT INTO guiNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jayave cuimbae oñemoicavi oaro jae reta mbae omee chupe vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Erei Pedro jei: —Mbaeti anoi corepoti jare oro. Erei anoigüe tamee ndeve. Jesucristo Nazaret pegua jee re epúa jare eguata —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jayave Pedro oipɨɨ cuimbae ipo iyacatu pe omopúa. Jare jupiveiño ipɨrata cuimbae ipɨ jare ipɨñúa. ");
INSERT INTO guiNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jare cuimbae oñemboɨ voi. Jayave oguata jare oique jae reta ndive Tumpa jo pe. Oguata jare opoopo ojo, jare omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jare opaete tenta pegua reta oecha oguata jare omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oicuaa reta jae co oguapɨse Tumpa jo jonque ipora yae vae pe oyerure corepoti re vae. Jare ipɨacañɨ reta. Oquɨye reta vi cuae oyeapo cuimbae pe vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cuimbae ocuera ma vae oipɨɨ Pedro jare Juan. Jare opaete tenta pegua reta osɨi oñemboatɨ ipɨacañɨ reve jae reta ñogüɨnoia pe oca Salomón jee vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jayave Pedro oecha yave, jei tenta pegua reta pe: —Cuimbae Israel pegua reta, ¿maera pa pepɨacañɨ cuae re? ¿Maera pa pemae ngatu oreré? ¿Peñemongueta pa ore aeño royapo oguata vaera cuae cuimbae orembaepuere rupi ani jupi vae royapo rambue? Mbaeti co jocorai —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, Jacob, jare ñanetenondegua reta iTumpa omboeteuca ma Jesús - jae co Tumpa Taɨ. Cuae Jesús pe reta pemoeterenga, jare peroɨro Pilato jóvai. Echa Pilato oñemongueta tei oyorauca vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Erei pe reta peroɨro cuae Jesús - jae co iyoa mbae jare jupi vae - jare peyerure Pilato pe oyorauca vaera peve metei oporoyuca vae —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jare peyucauca omee tecove ñandeve vae. Jae co Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi. Jocuae co ore romombeu roico —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mborogüɨrovia Jesús jee re vae jeco pegua, jae jee ombogüera cuae cuimbae pe reta peecha jare peicuaa vae. Añete co, jocuae mborogüɨrovia Jesús omee vae ombogüera cavi cuae cuimbae opaete pe reta perovaque —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Añave, cherɨvɨ reta, aicuaa peruvicha reta jare pe reta vi peyapo cuae icavi mbae vae, mbaeti peicuaa rambue —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Erei jocorai oyapo Tumpa, opaete iñee aracae omombeu vae reta jei rami. Echa jei reta Cristo oiporarañotai co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jayave peeya peñemongueta icavi mbae vae pepɨa pe oi vae jare peyerova Tumpa cotɨ, pembaeyoa reta oñemboai vaera, jare ou vaera ñandeYa güi ara mbɨacatu pegua reta, ");
INSERT INTO guiNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","jare Tumpa ombou ye vaera Jesucristo tenonde yave jeracua peve vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jae opɨtata ara pe opaete mbaembae oñemoicavi regua. Jocuae mbaembae re Tumpa imiari oñono tee iñee omombeu vaera vae reta rupi aracae güive —jei Pedro chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Echa Moisés jei ñanetenondegua reta pe: ÑandeYa Tumpa ombouta peve iñee omombeuta vae perɨvɨ reta ipɨte güi, chembou rami. Peyeapɨsacata jese opaete jeita peve vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jare oime yave quia mbaetita oyeapɨsaca jocuae Tumpa iñee omombeuta vae re vae, Tumpa omombota co iru vae reta ipɨte güi —jei, jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Jare jocorai vi jei opaete Tumpa iñee aracae omombeu vae reta Samuel güive. Opaete metei rami omoeracua cuae ara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pe reta co jae Tumpa iñee aracae omombeu vae reta iñemoña reta, jare petenondegua reta pe Tumpa jei vae oyeapota peve. Echa Tumpa jei Abraham pe: Neñemoña rupi ayapota co icavi vae opaete ɨvɨ pegua reta pe —jei, jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tumpa omoingove ye Taɨ güeru omanogüe vae reta ipɨte güi, jare ombou ma peve tenonde ete, oyapo vaera icavi vae peve, metei ñavo peyerova vaera Tumpa cotɨ pereco icavi mbae vae güi —jei Pedro chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro jare Juan imiari ñogüɨnoi rambueve tenta pegua reta pe, yogüeru sacerdote reta, Tumpa jo iñangarecoa reta juvicha, jare saduceo reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jae reta pochɨ Jesús jemimondo reta pe. Echa Jesús jemimondo reta omboe tenta pegua reta, jare omombeu chupe reta Jesús oicove ye co ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jayave jae reta oipɨɨ Pedro jare Juan, jare oñono tembipɨɨrɨru pe pɨareve regua. Echa caaru yae ma co. ");
INSERT INTO guiNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Erei jeta yae Tumpa iñee oendu vae reta güɨrovia. Cuimbae reta güɨroviagüe cinco mil rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pɨareve pe oñemboatɨ Jerusalén pe mburuvicha reta, tenta pegua reta itenondegua reta, mboroócuai re oporomboe vae reta, ");
INSERT INTO guiNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anás - jae co sacerdote tenondegua - Caifás, Juan, Alejandro, jare opaete sacerdote tenondegua jentara reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jayave jae reta oñono Pedro jare Juan ipɨte pe, jare oparandu chupe reta: —¿Mbae nunga mbaepuere pe pa peyapo cuae? Jare ¿quia jee re pa peyapo? ");
INSERT INTO guiNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jayave Pedro tɨnɨe Espíritu Santo pe, jare jei chupe reta: —Mburuvicha tenta pegua reta jare tenondegua Israel pegua reta, ");
INSERT INTO guiNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","añave peparandu pei oreve cuae icavigüe oyeapo vae re. Peipota peicuaa quirai ra cuae cuimbae ocuera ma imbaerasɨ güi —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Peicuaa catu opaete pe reta, jare toicuaa opaete Israel pegua reta, Jesucristo Nazaret pegua jee re ocuera ma cuae cuimbae perovaque oi vae. Pe reta peicutuca curusu re cuae Jesucristo, erei Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Cuae Jesús pe reta peroɨro, o ita pegua iyapoa reta metei ita güɨroɨro rami. Erei jae oyeapo ma ita oñeñono tenonde ora vae rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jare mbaeti ye quia re ñandepuere ñañemboasauca. Echa mbaeti oñemee ɨvɨ pegua reta pe iru tee, jese oñemboasauca vaera —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jayave yatɨ vae reta oecha quirai Pedro jare Juan oquɨye mbae reve imiari, yepe tei mócoi reve mbaeti oñemboe mbatee. Jae rambue ipɨacañɨ reta jese. Jare oicuaa Jesús ndive yogüɨrecose co. ");
INSERT INTO guiNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Erei oecha reta yave cuimbae ocuera vae oñemboɨ oi jae reta ndive, mbaeti mbae ipuere jei Jesús jemimondo reta cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jayave oyócuai Pedro jare Juan oe vaera rani ipɨte güi. Jayave imiari oyoupe. ");
INSERT INTO guiNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Mbae ra yayapota cuae cuimbae reta pe? Echa opaete Jerusalén pegua reta oicuaa metei mɨacañɨ tuicha vae oyapo reta co, jare ñande mbaeti ñandepuere yaicuacu —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jayave yayócuai cuae reta agüɨye vaera añave güive imiari quia pe cuae cuimbae jee re, agüɨye vaera iru vae reta oicuaa —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jayave oeni Pedro jare Juan, jare oyócuai: —Agüɨye ye pemiari ani peporomboe Jesús jee re. ");
INSERT INTO guiNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Erei Pedro jare Juan jei chupe reta: —¿Mbae ra Tumpa oipota royapo vaera? Royapo yave peporoócuai, ngaraa royapo Tumpa iporoócuai. ¿Mbae nunga mboroócuai ra royapota? Pe reta pemombeu oreve. ");
INSERT INTO guiNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Echa ore romombeuñotai co roecha jare roendu vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jayave yatɨ vae reta omonguɨye tei omondo Pedro jare Juan. Mbaeti oinupauca, tenta pegua reta güi oquɨye rambue. Echa opaete tenta pegua reta omboete Tumpa jocuae oyeapo vae jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Echa cuimbae mɨacañɨ pe ocuera vae cuarenta año oasa ma güɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jare Pedro jare Juan oyeyora ma yave, yogüɨraja iñeiru reta pɨri, jare omombeu chupe reta opaete sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta jei chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jae reta cuae oendu yave, oyerure Tumpa pe: —OreYa Tumpa, nde co jae ara, ɨvɨ, ɨ guasu, jare opaete mbaembae ñogüɨnoi pɨpe vae iyapoa —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nde rere nerembiócuai David jee vae rupi corai: ¿Maera pa pochɨ judío mbae vae reta? ¿Maera pa ɨvɨ pegua reta oñemongueta oyapo vaera icavi mbae vae? ");
INSERT INTO guiNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mburuvicha guasu ɨvɨ pegua reta jare ɨvɨ pegua reta itenondegua reta oñemboatɨ metei rami ñandeYa jare Cristo jovaicho retara. Jocorai nde rere David rupi —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Añete co, Herodes, Poncio Pilato, judío mbae vae reta, jare Israel pegua reta oñemboatɨ cuae tenta pe Jesús jovaicho retara. Jesús co jae ndeRaɨ. Jae co jupi vae nde reiparavo vae —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oñemboatɨ reta oyapo vaera nde reyapouca vae. Aracae güive nde reipota oyapo reta vaera —jei reta Tumpa pe—. ");
INSERT INTO guiNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Añave, oreYa, reicuaa oremonguɨye tei vae reta jeigüe. Jae rambue oremborɨ romombeu vaera neñee roquɨye mbae reve. Echa ore co nerembiócuai. ");
INSERT INTO guiNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jare eechauca nembaepuere reporombogüera vaera, jare eyapo vi mɨacañɨ reta Jesús jee re. Jae co ndeRaɨ jupi vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jare opa oyerure yave, yatɨ ñogüɨnoia ocana. Jare opaete jae reta tɨnɨe Espíritu Santo pe, jare imiari Tumpa iñee re oquɨye mbae reve. ");
INSERT INTO guiNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jare opaete oporogüɨrovia vae reta metei ramiño ñogüɨnoi. Mbaeti metei ave jei imbaembae re: Jocuae co chembae. Echa opaete imbaembae reta metei ramiño. ");
INSERT INTO guiNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jare mbaepuere tuicha vae reve Jesús jemimondo reta omombeu ñandeYa Jesús oicove ye co ou omanogüe vae reta ipɨte güi. Jare opaete jae reta ipɨacavi yae. ");
INSERT INTO guiNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mbaeti metei ave mbae oata chupe vae jae reta ipɨte pe. Echa opaete ɨvɨ reta jare o reta güɨnoi vae reta omee, jare güeru jepɨgüe, ");
INSERT INTO guiNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","jare oñono Jesús jemimondo reta jóvai. Jayave omboyao reta oata chupe vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Jare metei levita ɨvɨ Chipre pegua José jee vae güɨnoi vi metei ɨvɨ. Jesús jemimondo reta ombojee cuae cuimbae Bernabé (Cuae tee oipota jei: Oporombopɨacatu vae). Jae omee iɨvɨ jare güeru jepɨgüe oñono Jesús jemimondo reta jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Erei iru cuimbae Ananías jee vae jembireco Safira jee vae ndive omee metei iɨvɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jayave Ananías oñovatu iyeupe mbovɨ ɨvɨ jepɨgüe güi jembireco oicuaa reve, jare güeru mbovɨño oñono Jesús jemimondo reta jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jayave Pedro jei chupe: —Ananías, ¿maera pa remaeño Satanás re omotɨnɨe vaera ndepɨa icavi mbae vae pe? Reñovatu ndeyeupe mbovɨ ndeɨvɨ jepɨgüe güi. Ndeapu ma co Espíritu Santo pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndei remee ndeɨvɨ mbove, nembae co. Jare remee ma yave, jepɨgüe vi nembae co. ¿Maera pa reñemongueta ndepɨa pe icavi mbae vae reyapo vaera? Mbaeti co cuimbae reta peño ndeapu. Ndeapu Tumpa pe etei —jei Pedro Ananías pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cuae oendu yave, Ananías oa ɨvɨ re, jare omano. Jare opaete cuae regua oicuaa vae reta oquɨye yae. ");
INSERT INTO guiNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jayave opúa cuimbae taɨrusu vae reta, jare oñoma omanogüe, jare güɨraja oñotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mboapɨ ora ma oasa yave, oique jembireco. Jae mbaeti oicuaa mbae oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jayave Pedro oparandu chupe: —Emombeu cheve, ¿pemee pa peɨvɨ corai pe? Cuña jei chupe: —Añete, jocorai pe co —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—¿Maera pa pe reta peñomboemboe pemboavai vaera ñandeYa iEspíritu? —jei Pedro chupe—. Co onque pe ma yogüeru neme iñotɨa reta. Jae reta ndererajata vi —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jare jupiveiño Safira oa Pedro jóvai, jare omano. Oique ma yave cuimbae taɨrusu vae reta, oecha omano ma. Jayave güɨraja oñotɨ ime iyɨpɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jare oporogüɨrovia vae reta jare opaete cuae mbaembae regua oicuaa vae reta oquɨye yae. ");
INSERT INTO guiNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jare oyeapo jeta mɨacañɨ reta tenta pegua reta ipɨte pe Jesús jemimondo reta rupi. Jare opaete oporogüɨrovia vae reta oñemboatɨ oca Salomón jee vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jare opaete iru vae reta oquɨye oñemboatɨ vaera jae reta ndive. Erei tenta pegua reta omboete yae. ");
INSERT INTO guiNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jare jecuaeño jeta iru cuimbae reta jare cuña reta güɨrovia ñandeYa re. ");
INSERT INTO guiNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jare tenta pegua reta güɨraja imbaerasɨ vae reta icatu pe, jare oñono jupa reve tape reta pe. Cuae oyapo reta Pedro icuaraɨa yepe oi vaera amogüe vae re, jae oasa ojo yave. ");
INSERT INTO guiNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jare jeta vae yogüeru Jerusalén pe iru tenta coiño Jerusalén güi ñogüɨnoi vae reta güi, jare güeru imbaerasɨ vae reta jare aña oya jese vae reta. Jare opareve ocuera. ");
INSERT INTO guiNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jayave sacerdote tenondegua jare opaete saduceo jae ndive ñogüɨnoi vae reta oñemoagüɨro yae Jesús jemimondo reta re. ");
INSERT INTO guiNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jae rambue oipɨɨ reta, jare oñono tembipɨɨrɨru tenta pegua pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Erei metei araɨgua ñandeYa pe oyeócuai vae oipea tembipɨɨrɨru jonque reta. Jayave güɨraja Pedro jare Juan icatu pe, jare jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Pecua peñemboɨ Tumpa jo pe pemombeu tenta pegua reta pe cuae tecove regua. ");
INSERT INTO guiNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cuae oendu yave, Pedro jare Juan oique Tumpa jo pe neimbove asɨ jare oporomboe. Cuae oyeapo rambueve, sacerdote tenondegua jare jae ndive ñogüɨnoi vae reta oeni opaete mburuvicha reta jare tenondegua Israel pegua reta. Jayave jae reta omondo sacerdote tenondegua jembiócuai reta tembipɨɨrɨru pe, jae reta güeru vaera tei Jesús jemimondo reta. ");
INSERT INTO guiNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Erei tembiócuai reta yogüɨraja ovae yave, mbaeti ovae Jesús jemimondo reta tembipɨɨrɨru pe. Jayave yogüeru ye yave, jei reta yatɨ vae reta pe: ");
INSERT INTO guiNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Roecha tembipɨɨrɨru jonque reta oñeoquenda cavi oi, jare jaroa reta oñemboɨ ñogüɨnoi onque ñavo pe. Erei roipea yave, mbaeti quia rovae japɨpe pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cuae oendu yave, sacerdote tenondegua, Tumpa jo iñangarecoa reta juvicha, jare sacerdote reta itenondegua reta ipɨacañɨ yae. Jare mbaeti oicuaa mbae ra oyeapota. ");
INSERT INTO guiNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jayave ou metei vae, jare jei chupe reta: —Cuimbae peñono tembipɨɨrɨru pe vae reta oime Tumpa jo pe ñogüɨnoi, jare omboe ñogüɨnoi tenta pegua reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jayave Tumpa jo iñangarecoa reta juvicha ojo sacerdote tenondegua jembiócuai reta ndive, jare güeru cavi Jesús jemimondo reta oinupa mbae reve. Echa oquɨye reta tenta pegua reta güi. Oñemongueta güɨramoi oyapi retata ita pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jare güeru yave, oñono mburuvicha reta jóvai. Jayave sacerdote tenondegua jei Jesús jemimondo reta pe: ");
INSERT INTO guiNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Poócuai tei ma agüɨye ye vaera peporomboe jocuae cuimbae jee re. Echa pemombeu ma opaete Jerusalén pegua reta pe cuae moromboe. Jare peipota pemboya jocuae cuimbae imano oreré —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jayave Pedro jare iru Jesús jemimondo reta jei chupe reta: —Icavi co royapo vaera Tumpa iporoócuai, mbaeti peporoócuai. ");
INSERT INTO guiNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ñanetenondegua reta iTumpa omoingove ye Jesús güeru omanogüe vae reta ipɨte güi. Pe reta peicutuca ɨvɨra re cuae Jesús peyucauca —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imbaepuere pe Tumpa oyapo ma cuae Jesús tenondegua vae jare oporomboasa vae, Israel pegua reta oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae, jare Tumpa iñɨro vaera chupe reta imbaeyoa reta re. ");
INSERT INTO guiNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jare ore romombeu iru vae reta pe cuae, jare Espíritu Santo vi omombeu. Echa Tumpa omee Espíritu Santo jeigüe oyapo vae reta pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cuae oendu yave, yatɨ vae reta pochɨ chupe reta, jare oipota tei oyuca. ");
INSERT INTO guiNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Erei opúa metei fariseo Gamaliel jee vae yatɨ vae reta ipɨte pe. Jae co metei mboroócuai re oporomboe vae, jare opaete tenta pegua reta omboete. Jae oyócuai omondo reta vaera rani michi pegua Jesús jemimondo reta icatu pe. ");
INSERT INTO guiNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jayave jae jei yatɨ vae reta pe: —Cuimbae Israel pegua reta, peñemongueta cavi mbae peyapota cuae cuimbae reta pe vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Echa carambué yave oyecuaa Teudas jee vae, jare oñemboete iru vae reta jóvai. Jare jeta cuimbae reta, güɨramoi cuatrocientos, oñemboatɨ jae ndive. Erei jae oyeyucauca, jare opaete jae ndive ñogüɨnoi vae reta opa oñemoai, jare mbaeti mbae ipuere oyapo. ");
INSERT INTO guiNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jaɨcue rupi, mburuvicha reta oporopapa ñogüɨnoi yave, oyecuaa Galilea pegua Judas jee vae. Jae omboatɨ jeta tenta pegua reta. Erei jae vi omano, jare opaete jae ndive ñogüɨnoi vae reta opa oñemoai —jei Gamaliel chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jae rambue añave che jae peve cuae: Agüɨye mo peyapo mbae cuae cuimbae reta pe, jare pemaeño mo jese reta. Echa imbaepuere ae peño yave jocorai imiari reta jare cuae mbaembae oyapo reta, ngaraa mbae oyapo reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Erei cuae Tumpa güi ou yave, ngaraa pepuere pemboai. Echa güɨramoi peyovaichota Tumpa ndive —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jare cuae Gamaliel jei vae icavi chupe reta. Jayave oeni reta Jesús jemimondo reta, jare oinupa. Jayave oyócuai reta agüɨye vaera mo imiari ye Jesús jee re, jare omondo. ");
INSERT INTO guiNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jayave Jesús jemimondo reta oe yatɨ vae reta ñogüɨnoia güi. Oyerovia reta, Jesús omaeño oiporara reta rambue. Echa oñereroɨrouca reta, Jesús re güɨrovia rambue. ");
INSERT INTO guiNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jare ara ñavo jecuae oporomboe reta Tumpa jo jare o reta pe. Omombeu iru vae reta pe Jesucristo regua. ");
INSERT INTO guiNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jocuae ara reta pe iru vae reta oporogüɨrovia jare oñemoiru ñogüɨnoi oporogüɨrovia vae reta ndive yave, griego pe imiari vae reta iñeenguru hebreo pe imiari vae reta cotɨ. Echa mbaeti oñangareco reta imemano vae reta griego iñee pe imiari vae re, ara ñavo mbae oñemee yave. ");
INSERT INTO guiNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jayave jocuae doce Jesús jemimondo reta omboatɨ oporogüɨrovia vae reta, jare jei chupe reta: —Mbaeti icavi ore roeya vaera Tumpa iñee, cuae reta romongaru vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jae rambue peiparavo pepɨte güi, orerɨvɨ reta, siete cuimbae jeracua cavi jese vae reta, tɨnɨe Espíritu Santo pe jare iyaracuaa catu vae reta. Jae reta oyapota ñandeve cuae mbaravɨquɨ —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Erei ore jecuae royerureta Tumpa pe jare romombeuta Tumpa iñee —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Cuae jeigüe icavi opareve pe, jare oiparavo reta Esteban - jae co metei cuimbae oporogüɨrovia cavi jare tɨnɨe Espíritu Santo pe vae - Felipe, Prócoro, Nicanor, Timón, Parmenas, jare Nicolás - jae co tenta Antioquía pegua judiora oyeapo vae. ");
INSERT INTO guiNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jayave güeru reta cuae oiparavogüe reta Jesús jemimondo reta jóvai. Jayave Jesús jemimondo reta oyerure Tumpa pe, jare oñono ipo jese reta. ");
INSERT INTO guiNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jare Tumpa iñee jecuae oñemoai. Jeta yae vae oporogüɨrovia Jerusalén pe jare oñemoiru oporogüɨrovia vae reta ndive, jare jeta sacerdote reta vi oporogüɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jare Esteban ipɨacavi yae, jare mbaepuere reve oyapo mɨacañɨ tuicha vae reta tenta pegua reta ipɨte pe. ");
INSERT INTO guiNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jare yogüeru amogüe cuimbae metei judío reta itupao pegua reta oyoaca Esteban ndive. Jocuae judío reta itupao jee Liberto pegua. Cuae tupao pegua reta yogüeru tenta reta Cirene jare Alejandría, jare ɨvɨ reta Cilicia jare Asia güi. ");
INSERT INTO guiNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Erei jae reta mbaeti ipuere omoamɨri Esteban. Echa Esteban imiari iyaracuaa catu reve Espíritu Santo rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jayave jae reta omboemboe iru cuimbae reta yapu vaera Esteban re. —Roendu jei ñee icavi mbae vae Moisés jare Tumpa cotɨ —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jocorai jae reta omboarasɨuca tenta pegua reta, tenta pegua reta itenondegua reta, jare mboroócuai re oporomboe vae reta. Jayave cuae reta yogüeru oipɨɨ Esteban, jare güɨraja mburuvicha reta yatɨa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Joco pe jae reta güeru yapu reve oñeapo jese vae reta. Cuae reta jei: —Cuae cuimbae jecuaeñoi jei ñee icavi mbae vae Tumpa jo re jare mboroócuai re. ");
INSERT INTO guiNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Echa roendu jei jocuae Jesús Nazaret pegua omboaita cuae Tumpa jo, jare oipoepɨta teco Moisés omee ñandeve vae reta —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jayave opaete joco pe oguapɨ ñogüɨnoi vae reta omae ngatu Esteban re, jare jova metei araɨgua jova echa chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jayave sacerdote tenondegua oparandu Esteban pe: —¿Añete pa jocorai? ");
INSERT INTO guiNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jayave Esteban jei joco pe ñogüɨnoi vae reta pe: —Cherɨqueɨ reta, tenta pegua reta itenondegua reta, peyeapɨsaca cheré. Tumpa maemboete pegua oyecuaa ñanetenondegua Abraham pe, Mesopotamia pe oico yave, ndei ojo oico Harán pe mbove —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jare jei chupe: Ecua ndeɨvɨ güi jare eeya nerentara reta, jare ecua jocuae ɨvɨ aechaucata ndeve vae pe —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jayave Abraham ojo Caldeo reta iɨvɨ güi, jare oico Harán pe. Jare tu omano yave, Tumpa ombou joco güi cuae ɨvɨ añave peico pɨpe vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Erei Tumpa mbaeti omee Abraham pe iɨvɨ aera cuae pe, mbaeti ipɨ jendara yepe. Erei jei omeeta co chupe jare iñemoña reta pe iɨvɨ aera, yepe tei Abraham ndei taɨ —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jare Tumpa omombeu chupe: Neñemoña reta yogüɨrecota iru vae reta iɨvɨ pe, jare jocuae ɨvɨ pegua reta oyapota jembiócuai retara, jare oyapota icavi mbae vae chupe reta cuatrocientos año pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Erei che aiporaraucata jocuae ɨvɨ pegua oyapota jembiócuai retara vae reta pe, jare taɨcue rupi neñemoña reta oeta joco güi, jare oyeocuaita cheve cuae ɨvɨ pe —jei, jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Jare Tumpa jei Abraham pe jae jare opaete iñemoña cuimbaegüe oñemocircuncidauca vaera, imaendúa reta vaera Tumpa jeigüe oyapota co. Jae rambue Abraham taɨ Isaac oa ma yave, Abraham omocircuncida, Isaac ocho ara ma güɨnoi yave. Jae ramiño vi Isaac omocircuncida Jacob, jare Jacob omocircuncida jocuae doce ñanetenondegua reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jocuae ñanetenondegua reta omotareɨ José, jare omee corepoti re, José Egipto pe oyeócuai vaera. Erei Tumpa oico José ndive, ");
INSERT INTO guiNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","jare oepɨ opaete susere reta güi. Jare mburuvicha guasu Egipto pegua Faraón oicuaa Tumpa omee José pe ipɨacavi jare iyaracuaa catu vaera. Jae rambue Faraón oyapo mburuvichara, jare José oyócuai opaete Egipto pegua reta jare Faraón jentara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Erei caruai ou opaete Egipto jare Canaán pe, jare opaete vae oiporara yae. Jare jocuae ñanetenondegua reta mbaeti ovae jou vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Erei Jacob oicuaa oime tembíu Egipto pe yave, omondo jocuae ñanetenondegua reta joco pe. Jaeramo etei jae reta yogüɨraja Egipto pe. ");
INSERT INTO guiNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jare Jacob omondo reta ye yave, José oyecuauca tɨqueɨ reta pe, jare Faraón oicuaa José jentara reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jayave José ombou omombeu tu pe yogüɨraja vaera ipɨri jae jare opaete jentara reta. Opaete rupi ñogüɨnoi setenta y cinco —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jae rambue Jacob ojo Egipto pe. Jare joco pe jae jare jocuae ñanetenondegua reta omano. ");
INSERT INTO guiNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Taɨcue rupi iñemoña reta güeru jetegüe reta Siquem pe, jare joco pe oñotɨ reta teogüerenda Abraham oguagüe pe. Echa Abraham omboepɨ Hamor taɨ reta pe corepoti pe, Siquem pe oi yave —jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Erei coiño ma ou yave Tumpa oyapo vaera Abraham pe jeigüe, ñanetenondegua reta jeta oñemoña Egipto pe. ");
INSERT INTO guiNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jayave iru cuimbae José mbaeti oicuaa vae oyeapo Egipto pegua reta juvicha guasura —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cuae mburuvicha guasu iyaracuaa catu oyapo vaera icavi mbae vae ñanetenondegua reta pe. Jei chupe reta oechauca vaera taɨ reta oa yave, oyucauca vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jocuae ara reta pe oa Moisés. Tumpa oaɨu yae Moisés. Jare mboapɨ yasɨ Moisés oico tu jenta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jare oyecuaa yave, Faraón tayɨ oepɨ, jare ombocuacuaa imembɨ rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jare Moisés oñemboe opaete aracuaa Egipto pegua re, jare imiari cavi jare jatangatu yae —jei Esteban chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Jare Moisés cuarenta año güɨnoi yave, oipota oecha quirai ra yogüɨreco Israel pegua reta - jae reta co jae jentara reta. ");
INSERT INTO guiNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jare oecha metei Egipto pegua icavi mbae vae oyapo oi metei Israel pegua pe. Jayave oinupa oyuca Egipto pegua, jare jocorai oepɨ oiporara vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés oñemongueta tei jentara reta oicuaata co Tumpa oepɨta jae rupi, erei mbaeti oicuaa reta —jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pɨareve pe oecha mócoi jentara reta oñoraro ñogüɨnoi, jare oipota tei omoicavi reta. Jae rambue jei chupe reta: Cuimbae reta, pe reta metei tentara vae co. ¿Maera pa icavi mbae vae peyapo oyoupe? —jei, jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Erei jocuae cuimbae icavi mbae vae oyapo iru pe vae omoaña Moisés, jare jei chupe: ¿Quia pa ndeapo oreruvichara, oreraa vaera? ");
INSERT INTO guiNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Reipota pa cheyuca Egipto pegua carumbue reyuca rami? —jei, jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuae oendu yave, Moisés otecuarai, jare oico ɨvɨ ambué Madián jee vae pe. Joco pe oñemoña mócoi taɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta año ma oasa yave, ñuu pe coiño ɨvɨtɨ Sinaí jee vae güi oi yave, metei araɨgua oyecuaa Moisés pe metei yai jendɨ oi vae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés oecha yave, ipɨacañɨ yae. Erei oya jese yave, omae vaera jese coiño güi, oendu ñandeYa iñee jei: ");
INSERT INTO guiNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Che co jae netenondegua reta - jae co Abraham, Isaac, jare Jacob - iTumpa” —jei, jei—. Jayave Moisés orɨrɨi oquɨye güi, jare oipoɨu omae vaera jese. ");
INSERT INTO guiNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jayave ñandeYa jei ye chupe: Emboi ndepɨapaa ndepɨ güi. Echa reñemboɨ co rei Tumpa jupi vae jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Che añetete aecha quirai oiporara yae reta aiparavogüe vae reta Egipto pe, jare aendu iyaeo. Jae rambue agüeyɨ aepɨ vaera. Añave eyu toromondo Egipto pe —jei, jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Cuae Moisés co jae Israel pegua reta güɨroɨro vae. Echa jae reta jei chupe: ¿Quia pa ndeapo oreruvichara, oreraa vaera? —jei reta, jei—. Tumpa omondouca cuae Moisés araɨgua yai jendɨ vae pe oyecuaa chupe vae pe. Omondouca oico vaera jae reta juvichara jare oepɨ reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés güɨnoe reta güeru, jare oyapo mɨacañɨ reta Egipto pe, Ɨ Guasu Pɨta jee vae pe, jare cuarenta año ñuu rupi yogüɨreco rambueve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés jei Israel pegua reta pe: ÑandeYa Tumpa ombouta peve iñee omombeuta vae perɨvɨ reta ipɨte güi, chembou rami. Peyeapɨsacata jese —jei, jei Esteban—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Araɨgua imiari Moisés pe ɨvɨtɨ Sinaí re, ñuu pe oñemboatɨ yave Moisés jare ñanetenondegua reta. Tumpa omee Moisés pe iñee tecove pegua, jae omombeu vaera ñandeve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Erei ñanetenondegua reta mbaeti oipota oyapo Moisés jeigüe, jare güɨroɨro reta. Jae reta oñemongueta tei ipɨa pe yogüɨraja ye vaera Egipto pe. ");
INSERT INTO guiNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jare jei reta Aarón pe: Eyapo ñanetumpa retara yogüɨraja vaera ñanerenonde. Echa mbaeti yaicuaa mbae ra oyeapo cuae Moisés Egipto güi ñandereru vae pe —jei reta, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jayave oyapo reta metei vaca-raɨ-raanga, jare oyuca reta maemɨmba güɨrocuavee jocuae itumpa-raanga pe. Oyerovia reta jocuae ipo pe oyapogüe re. ");
INSERT INTO guiNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jae rambue Tumpa oyerova chugüi reta, jare omaeño omboete reta vaera opaete ara regua reta. Echa Tumpa iñee aracae omombeu vae reta itupapire pe oyecuatía oi corai: ¿Cheve ra perocuavee maemɨmba peyuca cuarenta año ñuu pe vae reta, Israel pegua reta? ");
INSERT INTO guiNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mbaeti co. Pevoɨ peraja tumpa-raanga Moloc jee vae oico pɨpe vae, jare petumpa-raanga Renfán jee vae iyasɨtata-raanga. Jae reta iagüe peyapo pemboete vaera. Jae rambue che pomondota Babilonia cutɨ. Jocorai oyecuatía oi —jei Esteban chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ñanetenondegua reta güɨrecose o Tumpa imiari chupe reta pɨpe vae ñuu pe. Echa Tumpa oyócuai Moisés jocuae tupao oyapo vaera jae oechauca chupe rami etei. ");
INSERT INTO guiNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jocuae tupao oñemee ñanetenondegua reta pe, jare jae reta Josué ndive güeru, cuae ɨvɨ judío mbae vae reta güi opɨro yave. Echa tumpa omombo reta ñanetenondegua reta güi. Jare David mburuvicha guasu yave, oimeño cuae pe oi jocuae tupao —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tumpa omae cavi David re, jare David oyerure Tumpa pe omaeño vaera oyapo Tumpa jo. Echa itenondegua Jacob omboete co Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Erei Salomón oyapo Tumpa jo, ");
INSERT INTO guiNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","yepe tei Tumpa ara pe oico vae mbaeti oico ñamboetearenda ñande yayapo vae reta pe. Echa Tumpa iñee aracae omombeu vae jei corai: ");
INSERT INTO guiNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ara co jae cheguapɨrenda, jare ɨvɨ co jae chepɨ jenda —jei Tumpa—. ¿Mbae nunga o ra peyapota cheve? ¿Quiape ra aputuuta? ");
INSERT INTO guiNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Chepo pe co ayapo opaete cuae mbaembae —jei. Jocorai jei Tumpa iñee aracae omombeu vae —jei Esteban chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pe reta pepɨatanta yae. Mbaeti peipota peyeócuai Tumpa pe, jare mbaeti ave peipota peyeapɨsaca jese. Jecuae peyovaicho Espíritu Santo ndive. Petenondegua reta oyapo rami, jocorai vi peyapo pe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Petenondegua reta oyapo icavi mbae vae opaete Tumpa iñee aracae omombeu vae reta pe. Amogüe Tumpa iñee aracae omombeu vae reta jei jocuae jupi vae outa co. Petenondegua reta oyuca reta. Jare añave pe reta vi pemoeterenga peyucauca jocuae jupi vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Echa Tumpa omeeuca peve iporoócuai araɨgua reta pe, erei mbaeti peyapo —jei Esteban. ");
INSERT INTO guiNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jare yatɨ vae reta cuae oendu ma yave, pochɨ yae, jare omboquɨrɨrɨu jai Esteban jei vae jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Erei Esteban tɨnɨe Espíritu Santo pe, jare omae ngatu ara cotɨ, jare oecha Tumpa maemboete pegua jare Jesús Tumpa iyacatu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jayave Esteban jei: —¡Mase! Aecha ara oyepea oi, jare aecha vi cuimbaera oyeapo vae oñemboɨ oi Tumpa iyacatu cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jayave jae reta osapúcai tanta, jare iyapɨsa oyopia. Jayave metei rami oepeña reta Esteban oipɨɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jare güɨraja ma tenta güi icatu pe yave, oyapi reta ita pe. Jare jocuae yapu reve oñeapo jese vae reta omboi jemimonde reta, jare oñono metei cuimbae taɨrusu Saulo jee vae jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jare oyapi reta rambueve, Esteban oyerure: —CheYa Jesús, eraja cherecove. ");
INSERT INTO guiNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jayave oyeatɨca, jare iñeeata reve jei: —CheYa, agüɨye toiporara reta cuae mbaeyoa jeco pegua. Jare cuae jei güire, omano. ");
INSERT INTO guiNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jare Esteban imano icavi Saulo pe. Jare jocuae ara oporogüɨrovia vae Jerusalén pe ñogüɨnoi vae reta jovaicho reta omboɨpɨ oiporarauca chupe reta. Jare Jesús jemimondo retaño opɨta Jerusalén pe. Opaete iru oporogüɨrovia vae reta oñemoai ɨvɨ reta Judea jare Samaria rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jare amogüe cuimbae omboete Tumpa vae reta oñotɨ Esteban, jare ipɨatɨtɨ yae reta jese. ");
INSERT INTO guiNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Erei Saulo oiporarauca oporogüɨrovia vae reta pe. Echa ojo o ñavo rupi, jare güɨraja cuimbae reta jare cuña reta oñono tembipɨɨrɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jayave jocuae oporogüɨrovia vae oñemoai vae reta omombeu ñee icavi vae yogüɨrajaa rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe ojo tenta Samaria pe, jare omombeu tenta pegua reta pe Cristo regua. ");
INSERT INTO guiNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jare tenta pegua reta oendu yave, metei rami oyeapɨsaca cavi Felipe omombeu chupe reta vae re. Oecha vi mɨacañɨ oyapo vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Echa aña reta ojo osapúcai reve oya jese vae reta güi. Jare jeta mbaeti ipuere omɨi vae reta jare jeta oguata mbae vae reta ocuera. ");
INSERT INTO guiNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jare jocuae tenta pegua reta oyerovia yae. ");
INSERT INTO guiNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jare joco pe oico metei cuimbae Simón jee vae. Cuae cuimbae ipaye vae co, jare omopɨacañɨ ombotavɨ Samaria pegua reta mbaembae oyapo vae pe. Jae rambue oñemboeteuca. ");
INSERT INTO guiNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jare opaete michia reta jare ocuacuaagüe reta oyeapɨsaca cavi jese, jare jei reta: —Cuae cuimbae güɨnoi Tumpa imbaepuere tuicha vae. ");
INSERT INTO guiNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jae rambue opaete vae oyeapɨsaca cavi jese. Echa jae ipaye vae rambue, ɨma ma oyapo mbaembae omopɨacañɨ reta vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Erei Felipe omombeu tenta pegua reta pe ñee icavi vae. Imiari chupe reta Tumpa iporoocuaia re jare Jesucristo re. Jayave cuimbae reta jare cuña reta güɨrovia jare oñembobautizauca. ");
INSERT INTO guiNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jare Simón vi güɨrovia, jare oñembobautizauca güive opɨta Felipe ndive. Jare oecha yave mɨacañɨ tuicha vae oyeapo vae reta, ipɨacañɨ yae. ");
INSERT INTO guiNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jare Jesús jemimondo Jerusalén pe ñogüɨnoi vae reta oicuaa yave quirai Samaria pegua reta güɨrovia ma Tumpa iñee, omondo reta Pedro jare Juan. ");
INSERT INTO guiNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jare jae reta yogüɨraja ovae yave Samaria pe, oyerure oporogüɨrovia vae reta re, Espíritu Santo ou vaera chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Echa ndeiño ou Espíritu Santo chupe reta. Jaeño oñembobautizauca Jesús jee re. ");
INSERT INTO guiNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jayave Pedro jare Juan oñono ipo jese reta, jare Espíritu Santo ou chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jare Simón oecha Espíritu Santo ou, Jesús jemimondo reta ipo oñono jese reta yave. Jayave güɨrocuavee corepoti chupe reta ");
INSERT INTO guiNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","jare jei: —Cheve vi pemee cuae mbaepuere, ou vaera oipotagüe vae pe Espíritu Santo, che añono chepo jese yave. ");
INSERT INTO guiNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Erei Pedro jei chupe: —Nde recañɨteita co ndecorepoti reve. Echa reñemongueta tei ndepuere regua corepoti pe mbota Tumpa omee vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nde mbaeti ndepuere renoi cuae nunga mbaepuere. Echa ndepɨa mbaeti jupi Tumpa cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eeya cuae ndereco icavi mbae vae, jare eyerure Tumpa pe. Güɨramoi iñɨrota ndeve cuae reñemongueta ndepɨa pe vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Echa aicuaa nde reñemɨro yae, jare mbaeyoa jeco pegua mbaeti ma ndepuere reyapo icavi vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jayave Simón jei chupe reta: —Peyerure cheré ñandeYa pe, agüɨye vaera cuae pere cheve vae oyeapo cheve. ");
INSERT INTO guiNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jayave Pedro jare Juan omombeu güire Tumpa iñee iru vae reta pe, yogüɨraja ye Jerusalén pe. Jare yogüɨraja rambueve, omombeu ñee icavi vae jeta iru Samaria pegua tenta reta rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jayave metei araɨgua ñandeYa pe oyeócuai vae jei Felipe pe: —Epúa ecua ara yevɨ cotɨ tape Jerusalén güi ojo Gaza cotɨ vae rupi. Cuae tape oasa ñuu rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jayave Felipe opúa ojo. Jare metei eunuco ɨvɨ Etiopía pegua ojo ye jenta cotɨ Jerusalén güi. Echa ou Jerusalén pe omboete vaera Tumpa. Cuae eunuco co jae metei mburuvicha. Jae oñangareco oico Candace icorepoti jare iru imbaembae icavi vae re. Candace co jae Etiopía pegua reta juvicha guasu. ");
INSERT INTO guiNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jare eunuco ojo ye yave jenta cotɨ, oguapɨ icarro pe omongueta ojo Isaías oicuatiagüe vae. Isaías co jae metei Tumpa iñee aracae omombeu vae. ");
INSERT INTO guiNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jare Espíritu Santo jei Felipe pe: —Ecua eñemoiru pea carro pe ojo vae ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Jayave Felipe osɨi ojo carro cotɨ, jare oendu cuimbae omongueta Tumpa iñee Isaías oicuatiagüe vae. Jayave oparandu chupe: —¿Reicuaa pa remongueta rei vae? ");
INSERT INTO guiNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jare eunuco jei Felipe pe: —¿Quiraita pa aicuaa, mbaeti yave quia omombeu cheve? Jare omoñera Felipe oyeupi vaera icarro pe oguapɨ jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jare Tumpa iñee omongueta vae pe oyecuatía oi corai: Metei vecha rami oyererajauca omano vaera. Jare jae quiriiño, metei vecha-raɨ jocuae oñapi vae jóvai oi vae quiriiño rami. ");
INSERT INTO guiNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Oñereroɨrouca yave, ojaa vae reta mbaeti jupi oyapo chupe. ¿Quia ra ipuere omoeracua jentaɨgua reta regua? Echa jecove ocañɨ ɨvɨ güi. Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jare eunuco jei Felipe pe: —Aipota remombeu vaera cheve quia re ra jei cuae Tumpa iñee omombeu vae. ¿Jei pa iyee ani iru vae re? —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jayave Felipe omboɨpɨ cuae Tumpa iñee oyecuatía oi vae güi omombeu chupe ñee icavi vae Jesús regua. ");
INSERT INTO guiNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Jare tape rupi yogüɨraja rambueve, yogüɨraja ovae ɨ jenda pe, jare eunuco jei: —Co oi ɨ. ¿Oime pa mbae ayapo vaera ndei añembobautizauca mbove? ");
INSERT INTO guiNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Reporogüɨrovia yave opaete ndepɨa pe, ndepuere reñembobautizauca —jei Felipe chupe. —Arovia Jesucristo co jae Tumpa Taɨ —jei eunuco Felipe pe. ");
INSERT INTO guiNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jayave eunuco omombɨtauca carro, jare mócoi reve ogüeyɨ ɨ pe. Jayave Felipe ombobautiza eunuco. ");
INSERT INTO guiNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jare oe reta ɨ güi yave, ñandeYa iEspíritu güɨraja joco güi Felipe. Jare eunuco mbaeti ma oecha ye. Jayave oyerovia reve ojo ye jenta cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jare Felipe oyecuaa tenta Azoto pe. Jare joco güi ojo tenta Cesarea pe. Jare ojo rambueve, omombeu ñee icavi vae opaete tenta reta rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jare Saulo omomburu oyuca vaera ñandeYa re güɨrovia vae reta, jare ojo sacerdote tenondegua pɨri. ");
INSERT INTO guiNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Jare oyerure sacerdote tenondegua pe omee vaera chupe tupapire, ipuere vaera ojo judío reta itupao tenta Damasco pegua reta pe, jare ovae yave joco pe cuimbae reta jare cuña reta Jesús re güɨrovia vae, ipuere vaera oipɨɨ güeru Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jare coiño ma Damasco güi ojo yave, güɨramoiño oesape Saulo re metei tembipe tuicha vae ara güi. ");
INSERT INTO guiNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jayave Saulo oa ɨvɨ re, jare oendu ñee jei chupe: —Saulo, Saulo, ¿maera pa reyapo icavi mbae vae cheve? ");
INSERT INTO guiNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jayave Saulo oparandu: —¿Quia pa co nde, cheYa? Jayave ñee jei chupe: —Che co jae Jesús. Nde reyapo icavi mbae vae cheve. Nde co jae metei güeye ɨvɨra jacuarovi vae re opatara vae rami. Jae rambue reiporara rei. ");
INSERT INTO guiNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo orɨrɨi oquɨye güi. —CheYa, ¿mbae pa reipota ayapo vaera? —jei. —Epúa ecua tenta pe, jare amombeucata ndeve mbae reyapota vae —jei ñandeYa Saulo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jare cuimbae Saulo jupíe yogüɨraja vae reta oñemboɨ quirii ñogüɨnoi ipɨacañɨ güi. Echa oendu ñee, erei mbaeti quia oecha. ");
INSERT INTO guiNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jayave Saulo opúa ɨvɨ güi, jare omae tei, erei mbaeti quia ipuere oecha. Jare jae jupíe yogüɨraja vae reta oipoco, jare güɨraja Damasco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jare Saulo joco pe oi mboapɨ ara omae mbae reve, jare mbaeti ocaru jare mbaeti oɨu. ");
INSERT INTO guiNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jare oico Damasco pe metei oporogüɨrovia vae Ananías jee vae. ÑandeYa jei chupe ique pe: —Ananías. Jare jae jei: —CheYa, co ai. ");
INSERT INTO guiNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jayave ñandeYa jei chupe: —Epúa ecua Tapesɨmbi jee vae pe, jare eeca Judas jo pe metei Tarso pegua. Jae jee co Saulo. Echa jae oyerure oi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jare jae oecha ma ique pe metei cuimbae Ananías jee vae oique jare oñono ipo jese, omae ye vaera —jei Tumpa chupe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Erei Ananías jei: —CheYa, jeta vae omombeu cheve cuae cuimbae regua, quirai jeta icavi mbae vae oyapo Jerusalén pe nderé güɨrovia vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jare cuae pe jae oime güɨnoi mbaepuere sacerdote reta itenondegua reta güi, oipɨɨ vaera opaete nderé güɨrovia vae reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","—Ecuaño —jei ñandeYa chupe—. Echa che aiparavo ma cherembiporura, ojo vaera omombeu cheregua judío mbae vae reta pe, mburuvicha reta pe, jare Israel pegua reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Echa che aicuaucata chupe quirai oiporara yaeta chereco pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jayave Ananías ojo oique o pe. Jare oñono ipo Saulo re jare jei chupe: —Cherɨvɨ Saulo, ñandeYa Jesús oyecuaa ndeve, reyu tape rupi rambueve. Jae chembou remae ye vaera, jare netɨnɨe vaera Espíritu Santo pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jare jupiveiño mbae oyeequi Saulo jesa güi ñanderesapira oyeequi rami, jare Saulo omae cavi. Jayave opúa oñembobautizauca. ");
INSERT INTO guiNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jayave ocaru jare ipɨrata ma. Jare opɨta mbovɨ ara oporogüɨrovia vae Damasco pe yogüɨreco vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jayave Saulo omboɨpɨ omombeu Jesús regua judío reta itupao reta pe. Jei chupe reta Jesús co jae Tumpa Taɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jare opaete oendu vae reta ipɨacañɨ, jare jei: —¿Jaea ra cuae Jerusalén pe cuae Jesús re güɨrovia vae reta opa omoai vae? Jare ou cuae pe vi oipɨɨ vaera cuae nunga reta güɨraja sacerdote reta itenondegua reta pe —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Erei Saulo oñemoatangatu yae, jare omoamɨri judío Damasco pegua reta. Echa oicuauca chupe reta Jesús co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jare ɨma ma oasa yave, judío reta oñomomiari oyuca vaera Saulo. ");
INSERT INTO guiNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Erei cuae jeracua Saulo pe. Jae reta oaro tenta itaraquera pe ara rupi jare pɨtu rupi, oyuca vaera tei. ");
INSERT INTO guiNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Erei oporogüɨrovia vae reta güɨraja Saulo pɨtu yave omboasa tenta iquesemba ita pegua vae iyapɨte rupi ombogüeyɨ canasta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jare Saulo ojo ovae yave Jerusalén pe, oipota tei oñemoiru oporogüɨrovia vae reta ndive. Erei opaete jae reta oipoɨu chugüi. Echa mbaeti güɨrovia jae Jesús re güɨrovia ma co. ");
INSERT INTO guiNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Erei Bernabé güɨraja Saulo Jesús jemimondo reta pe, jare omombeu chupe reta quirai Saulo oecha ñandeYa tape rupi, jare quirai ñandeYa imiari chupe. Jei vi chupe reta quirai Saulo omombeu oquɨye mbae reve Damasco pe Jesús regua. ");
INSERT INTO guiNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jayave Saulo oñemoiru oporogüɨrovia vae reta ndive Jerusalén pe. Jecuaeño oe Jerusalén güi jare oique ye. ");
INSERT INTO guiNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jare omombeu oquɨye mbae reve ñandeYa regua. Jare oyoaca vi griego pe imiari vae reta ndive. Jae rambue jae reta oipota oyuca. ");
INSERT INTO guiNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jare oporogüɨrovia vae reta cuae oicuaa yave, güɨraja reta Saulo Cesarea pe, jare joco güi omondo tenta Tarso cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jayave mbaeti ma quia omambeco oporogüɨrovia vae reta, jare jae reta oñemomɨrata opaete Judea rupi, Galilea rupi, jare Samaria rupi. Jare yogüɨreco reta omboete cavi reve ñandeYa, jare Espíritu Santo ombopɨacatu. Jare jecuaeño iru vae reta oñemoiru jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jare Pedro ojo opou yave opaete oporogüɨrovia vae reta ñogüɨnoia rupi, ojo ovae tenta Lida pegua reta pɨri. ");
INSERT INTO guiNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Joco pe ovae metei cuimbae Eneas jee vae ocho año ma oico jupa pe vae. Echa mbaeti ipuere omɨi. ");
INSERT INTO guiNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jare Pedro jei chupe: —Eneas, Jesucristo nembogüera ma. Epúa eipɨso nderupa —jei. Jare jupiveiño jae opúa. ");
INSERT INTO guiNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jare opaete Lida pegua reta jare tenta Sarón pegua reta oecha cuae cuimbae, jare oyerova reta ñandeYa cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jare oico tenta Jope pe metei cuña oporogüɨrovia vae Tabita jee vae. (Cuae tee oipota jei ambué ñee pe: Dorcas.) Cuae cuña oyapo jeta icavi vae, jare ombopota jeta paravete vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jayave imbaerasɨ, jare omano. Jare iru vae reta opa omboyau yave, oñono metei o ɨvate vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jare Lida coiño oi Jope güi. Jare oporogüɨrovia vae Jope pegua reta oicuaa ma yave Pedro oi Lida pe, omondo icotɨ mócoi cuimbae reta jei vaera chupe: —Ecua Jope pe ɨmambae. ");
INSERT INTO guiNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jayave Pedro opúa ou jae reta jupíe. Jare ou ovae yave, iru vae reta güɨraja o ɨvate vae pe. Joco pe opaete imemano vae reta yatɨ oyaeo ñogüɨnoi, jare oechauca Pedro pe temimonde Dorcas jae reta ndive oico yave oyapogüe vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jayave Pedro omoe opaete joco pe ñogüɨnoi vae reta. Jayave oyeatɨca jare oyerure Tumpa pe. Jayave oyerova omae teogüe re jare jei: —Tabita, epúa. Jayave cuña omae, jare oecha Pedro yave, opúa oguapɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jayave Pedro oipɨɨ ipo pe, jare omopúa. Jayave oeni oporogüɨrovia vae reta jare imemano vae reta, jare oechauca chupe reta oicove ma co. ");
INSERT INTO guiNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jare cuae jeracua opaete Jope pegua reta pe. Jare jeta vae güɨrovia ñandeYa re. ");
INSERT INTO guiNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jare Pedro opɨta ɨma ngatu Jope pe. Oico metei guasupi omopɨta vae Simón jee vae jo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Oico Cesarea pe metei cuimbae Cornelio jee vae. Jae co cien sundaro vae juvicha metei atɨ Italiana jee vae pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jae jare opaete jo pegua reta omboete Tumpa, jare jae ombopota jeta paravete vae reta, jare jecuaeñoi oyerure Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cuae cuimbae oecha cavi yae metei araɨgua Tumpa pe oyeócuai vae oique jae oia pe mboapɨ ora ma caaru yave. Araɨgua jei chupe: —Cornelio. ");
INSERT INTO guiNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio oquɨye reve omae ngatu araɨgua re jare oparandu: —¿Mbae pa, cheYa? Jare araɨgua jei chupe: —Tumpa imaendúa ndeyerure reta jare mbota remee vae reta re. ");
INSERT INTO guiNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Añave emondo cuimbae reta Jope pe, güeru vaera metei cuimbae Simón jee vae. Jae oñembojee Pedro pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jae oico metei guasupi omopɨta vae Simón pɨri. Simón jo oi ɨ guasu jembeɨ pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Araɨgua imiari jae ndive vae ojo ma yave, Cornelio oeni mócoi jembiócuai reta jare metei sundaro omboete Tumpa vae. Cuae sundaro vi oyeócuai Cornelio pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jare opa omombeu cavi chupe reta yave, omondo Jope cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pɨareve pe cuaraɨ ara mbɨteta ma yave, jae reta yogüɨraja tape rupi coiño ma Jope güi rambueve, Pedro oyeupi o iárambue, oyerure vaera Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jare ñɨmbɨaɨ yae, jare oipota ocaru. Erei iru vae reta omboyɨ ñogüɨnoi rambueve jembiura, Pedro iquera. ");
INSERT INTO guiNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jare oecha ara oyepea jare metei lienzo tuicha vae rami vae ogüeyɨ ou icotɨ. Cuae oñembogüeyɨ oyepɨɨ reve irundɨ jembeɨ reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Cuae lienzo japɨpe pe ñogüɨnoi oipotagüe maemɨmba oguata vae reta jare opoñɨ vae reta, jare oipotagüe güɨra reta. ");
INSERT INTO guiNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jare ou Pedro pe metei ñee: —Pedro, epúa eyuca jeu. ");
INSERT INTO guiNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Erei Pedro jei: —Ani, cheYa. Mbaeti etei co jau mboroócuai jei agüɨye vaera jau vae. Iquɨa co —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jayave ñee jei chupe: —Tumpa oitɨo ma vae agüɨye eeni iquɨa vae. ");
INSERT INTO guiNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Cuae mboapɨ vese ma oyeapo yave, lienzo rami vae oyereraja ye ara pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jare Pedro ipɨacañɨ reve oñemongueta oi rambueve mbae re ra oñemojaanga cuae iquera pe oecha vae, cuimbae Cornelio ombou vae reta oparandurandu yogüeru Simón jo re, jare yogüeru ma ovae onque pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jare jae reta oeni oparandu joco pe ra oico Simón oñembojee Pedro pe vae. ");
INSERT INTO guiNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jare Pedro oñemongueta oi rambueve jocuae iquera pe oecha vae re, Espíritu Santo jei chupe: —¡Mase! mboapɨ cuimbae reta ndereca. ");
INSERT INTO guiNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Epúa egüeyɨ ecua jae reta jupíe neateɨ mbae reve. Echa che co ambou —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jayave Pedro ogüeyɨ cuimbae Cornelio ombou vae reta ñogüɨnoia pe, jare jei chupe reta: —Che co jae pe reta peeca vae. ¿Mbae jeco pegua pa peyu chereca? ");
INSERT INTO guiNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jayave cuimbae reta jei Pedro pe: —Oime metei cuimbae Cornelio jee vae. Jae co cuimbae jupi vae. Omboete co Tumpa. Jae co cien sundaro vae juvicha opaete judío reta imiari cavi jese vae. Metei araɨgua Tumpa pe oyeócuai vae jei chupe ndereruruca vaera jenta pe, jae oyeapɨsaca vaera remombeuta chupe vae re —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jayave Pedro güɨroique cuimbae reta, jare omombɨta joco pe. Jayave pɨareve pe Pedro opúa ojo jae reta jupíe. Jare amogüe oporogüɨrovia vae Jope pegua reta yogüɨraja jae jupíe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jare pɨareve pe yogüɨraja ovae Cesarea pe. Jare Cornelio omboatɨ ma jentara reta jare iñeiru reta, jare oaro oi Pedro. ");
INSERT INTO guiNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jare Pedro oiqueta ma yave o pe, Cornelio oapependo jare oyeatɨca Pedro jóvai omboete. ");
INSERT INTO guiNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Erei Pedro jei chupe: —Epúa. Che cuimbaeño vi co. Jare omopúa. ");
INSERT INTO guiNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jare imiari jae ndive rambueve, Pedro oique o pe, jare oecha jeta vae yatɨ ñogüɨnoi joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jayave Pedro jei chupe reta: —Pe reta peicuaa cavi co quirai metei judío mbaeti ipuere oñemoiru metei judío mbae vae ndive, jare quirai mbaeti ipuere opou ipɨri. Erei Tumpa oechauca cheve quirai mbaeti icavi aeni vaera metei vae yepe iquɨa vae, yepe tei mbaeti oyapo mboroócuai. ");
INSERT INTO guiNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jae rambue pe reta chereniuca yave, ayu cheateɨ mbae reve. Añave taparandu peve, ¿maera pa chereniuca? —jei Pedro. ");
INSERT INTO guiNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jayave Cornelio jei chupe: —Irundɨ ara ma oasa corai yave ayerure ai ayecuacu reve tembíu güi cuae chero pe. Jare güɨramoiño mboapɨ ora ma caaru yave aecha metei cuimbae oñemboɨ oi cheróvai. Jemimonde oesape yae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jae jei cheve: Cornelio, ndeyerure oñeendu ma, jare Tumpa imaendúa ma mbota remee vae reta re. ");
INSERT INTO guiNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Emondo quia Jope pe, jare eruruca Simón oñembojee Pedro pe vae. Jae oico metei guasupi omopɨta vae Simón pɨri. Simón jo oi ɨ guasu jembeɨ pe. Ou yave, imiarita ndeve —jei cheve, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jae rambue jupiveiño amondo ndecotɨ, jare yasoropai reyu vae re. Añave ore co roi opaete cuae pe Tumpa jovaque, roendu vaera opaete Tumpa ndeócuai vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jayave Pedro jei chupe reta: —Añetete aicuaa ma quirai Tumpa mbaeti oaɨu metei vaeño iru vae güi. ");
INSERT INTO guiNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Echa jocuae omboete jare jupi vae oyapo vae oipotagüe ɨvɨ pegua icavi co Tumpa pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tumpa ombou ñee icavi vae Israel pegua reta pe. Jae omombeu chupe reta oime mbɨacatu Jesucristo re. Jesucristo co jae opaete vae iYa —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Juan omombeu oyeapɨsaca jese vae reta pe oñembobautizauca vaera. Cuae jaɨcue rupi Jesús Nazaret pegua jeracua Galilea pe jare opaete Judea rupi. Jeracua quirai Tumpa omee chupe Espíritu Santo jare mbaepuere, jare quirai jae ojo opaete que rupi oyapo icavi vae, jare quirai ombogüera opaete aña guasu oiporarauca chupe vae reta. Echa Tumpa oico jae ndive. Opaete cuae pe reta peicuaa co —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jare ore romombeu iru vae reta pe opaete Jesús oyapo Judea rupi jare Jerusalén pe vae. Jayave judío reta oicutuca ɨvɨra re oyucauca —jei Pedro chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Erei Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi mboapɨ ara omano güire, jare omboyecuaa. ");
INSERT INTO guiNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mbaeti omboyecuaa opaete vae pe, jaeño oreve. Echa tenonde ma Tumpa oreparavo romombeu vaera iru vae reta pe. Ore rocaru jare roɨu jae ndive, oicove ye güire ou omanogüe vae reta ipɨte güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jare jae oreócuai romombeu vaera iru vae reta pe quirai Tumpa oiparavo ojaa vaera oicove vae reta jare omanogüe vae reta —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Cuae regua co omombeu opaete Tumpa iñee aracae omombeu vae reta. Echa jae reta jei Tumpa iñɨrota opaete jese güɨrovia vae reta pe imbaeyoa reta re jae jeco pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jare Pedro imiari oi rambueve cuae ñee, Espíritu Santo ou opaete oendu vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jare judío oporogüɨrovia vae Pedro jupíe yogüeru vae reta ipɨacañɨ quirai judío mbae vae reta pe vi oñemee Espíritu Santo vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Echa jae reta oendu imiari reta ambué vae iñee pe. Jare oendu vi omboete Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jayave Pedro jei: —¿Quia pa omboavaita agüɨye vaera oñembobautizauca cuae reta? Echa Espíritu Santo ou ma chupe reta, ñandeve ou rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jayave Pedro oyócuai oñembobautizauca vaera ñandeYa Jesús jee re. Jayave joco pegua reta omoñera Pedro opɨta vaera jae reta ndive mbovɨ ara pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jayave Jesús jemimondo reta jare iru oporogüɨrovia vae Judea rupi ñogüɨnoi vae reta oicuaa quirai judío mbae vae reta vi güɨrovia Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jayave Pedro ojo ye ovae yave Jerusalén pe, judío oporogüɨrovia vae reta oñeengata chupe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Jae reta jei: —¿Maera pa reique judío mbae vae reta jo pe? ¿Maera pa recaru jae reta ndive? —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jayave Pedro iyɨpɨ güive omboɨpɨ omombeu cavi chupe reta opaete oyeapo vae. Jae jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Che ayerure ai yave tenta Jope pe, chequera rambueve, aecha metei lienzo tuicha vae rami vae ogüeyɨ ou checotɨ. Cuae oñembogüeyɨ ara güi oyepɨɨ reve irundɨ jembeɨ reta pe ou ovae cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Amae ngatu jese yave, aecha maemɨmba oguata vae reta, amogüe pochɨ vae jare amogüe pochɨ mbae vae, jare maemɨmba opoñɨ vae reta, jare güɨra reta. ");
INSERT INTO guiNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jare aendu vi metei ñee jei cheve: Pedro, epúa eyuca jeu —jei, jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Erei che jae: Ani, cheYa. Mbaeti etei co jau mboroócuai jei agüɨye vaera jau vae. Iquɨa co —jae chupe, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Erei ñee ou ara güi vae jei ye cheve: Tumpa oitɨo ma vae agüɨye eeni iquɨa vae —jei cheve, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jare cuae mboapɨ vese ma oyeapo yave, opaete oyereraja ye ara pe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jare jupiveiño yogüeru ovae che aicoa pe mboapɨ cuimbae Cesarea güi Cornelio ombou vae reta —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jare Espíritu Santo jei cheve aja vaera jae reta jupíe cheateɨ mbae reve. Jare cuae seis oporogüɨrovia vae reta vi yogüɨraja cherupíe, jare roique jocuae cuimbae jo pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jare jocuae cuimbae omombeu oreve quirai oecha metei araɨgua oñemboɨ oi jae jo pe, jare quirai araɨgua jei chupe: Emondo cuimbae reta Jope pe eruruca metei cuimbae Simón jee vae. Jae oñembojee Pedro pe —jei chupe, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jae omombeuta ndeve ñee, nde jare opaete ndero pegua reta peñemboasauca vaera —jei chupe, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jayave che amboɨpɨ chemiari chupe reta yave, Espíritu Santo ou chupe reta, ñandeve tenonde yave ou rami. ");
INSERT INTO guiNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jayave chemaendúa ñandeYa jei ñandeve vae re. Echa jei: Juan oporombobautiza ɨ pe. Erei pe reta peñembobautizauca Espíritu Santo pe —jei ñandeYa, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tumpa omee chupe reta jocuae mbota ñande yarovia ñandeYa Jesucristo re vae pe omee vae. Jae rambue che mbaeti etei chepuere amboavai Tumpa oyapo vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jayave cuae Pedro jei chupe reta vae oendu yave, jae reta mbaeti ma mbae ipuere jei. Omboeteño Tumpa, jare jei reta: —Tumpa omaeño vi judío mbae vae reta re oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae, güɨnoi vaera tecove opa mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jare Esteban oyuca güire, jovaicho reta oiporarauca oporogüɨrovia vae reta pe. Jare oporogüɨrovia vae reta oñemoai, jare yogüɨraja ovae ɨvɨ Fenicia, Chipre, jare Antioquía pe. Jare jae reta omombeu judío reta peño Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Erei jae reta ipɨte pe ñogüɨnoi amogüe cuimbae Chipre jare Cirene pegua. Cuae reta yogüɨraja ovae yave Antioquía pe, imiari griego reta pe vi, jare omombeu chupe reta ñee icavi vae ñandeYa Jesús regua. ");
INSERT INTO guiNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jare ñandeYa omborɨ, jare jeta vae güɨrovia jare oyerova ñandeYa cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jare cuae jeracua oporogüɨrovia vae Jerusalén pe ñogüɨnoi vae reta pe. Jayave jae reta omondo Bernabé Antioquía pe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jare jae ojo ovae yave, oecha jocuae oyeapo Tumpa ipɨacavi jeco pegua vae, jare oyerovia. Jayave jei chupe reta jecuaeño oguata cavi vaera ñandeYa ndive ipɨrata reve ipɨa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Echa Bernabé co jae cuimbae ipɨacavi vae. Jae oporogüɨrovia cavi yae, jare tɨnɨe Espíritu Santo pe. Jare jeta yae vae güɨrovia ñandeYa re jare oñemoiru oporogüɨrovia vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Cuae jaɨcue rupi Bernabé ojo Tarso pe, oeca vaera Saulo. Jare ovae chupe yave, güeru Antioquía pe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jare joco pe oñemoiru reta metei año oporogüɨrovia vae reta ndive, jare omboe jeta vae. Jare Antioquía pe jaeramo etei iru vae reta omboɨpɨ jei oporogüɨrovia vae reta re: —Cuae reta co jae cristiano reta. ");
INSERT INTO guiNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jare jocuae ara reta pe amogüe Tumpa iñee omombeu vae reta yogüeru Jerusalén güi Antioquía pe. ");
INSERT INTO guiNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Metei jee co Agabo. Jae opúa oñemboɨ, jare jei Espíritu Santo rupi oimeta co caruai tuicha vae opaete ɨvɨ rupi. Cuae oyeapo oico Claudio mburuvicha guasu yave. ");
INSERT INTO guiNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jayave metei ñavo oporogüɨrovia vae reta iquɨreɨ omondo oime güɨnoigüe güi, omborɨ vaera oporogüɨrovia vae Judea rupi ñogüɨnoi vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jare jocorai oyapo reta. Jare jae reta omondo oporogüɨrovia vae reta itenondegua reta pe Bernabé jare Saulo ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jocuae ara reta pe mburuvicha guasu Herodes oipɨuca amogüe oporogüɨrovia vae reta, oyapo vaera icavi mbae vae chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jare oyucauca quɨse pe Jacobo - jae co Juan tɨqueɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jare Herodes oicuaa yave cuae oyapogüe vae icavi judío reta pe, oipɨuca Pedro vi. Jocuae ara reta pe judío reta jou ñogüɨnoi mbɨyape ovu mbae vae. ");
INSERT INTO guiNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jare oipɨuca ma yave, oñonouca tembipɨɨrɨru pe. Omoeterenga irundɨ atɨ sundaro reta pe oñangareco jese vaera. Atɨ ñavo güɨnoi irundɨ sundaro. Herodes oipota tei güɨnoeuca Pedro tenta pegua reta jóvai pascua oasa ma yave. ");
INSERT INTO guiNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jayave sundaro reta oñangareco Pedro re tembipɨɨrɨru pe. Erei oporogüɨrovia vae reta oputuu mbae reve tanta oyerure Tumpa pe jese. ");
INSERT INTO guiNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pɨareve pe ma Herodes güɨnoeucata tei yave, jocuae pɨtu etei Pedro oque oi mócoi sundaro ipau pe, jare oñeapɨti oi mócoi cadena pe. Jare sundaro reta tembipɨɨrɨru jonque oaro ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jare güɨramoiño metei araɨgua ñandeYa pe oyeócuai vae oyecuaa, jare metei tembipe oesape tembipɨɨrɨru pe. Jayave araɨgua oñatai Pedro iyɨque pe omoingove vaera, jare jei chupe: —Epúa voi. Jare cadena reta oyera ipoapɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jayave araɨgua jei ye chupe: —Eñemonde jare emonde ndepɨapaa. Jare Pedro jocorai oyapo. Jayave araɨgua jei ye chupe: —Eñeoma ndeasoya pe, jare eyu cheraɨcue. ");
INSERT INTO guiNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jayave Pedro oe ojo araɨgua jaɨcue. Jae mbaeti oicuaa añete ra araɨgua oyapo vae. Oñemongueta tei opaete cuae oecha oi ique pe. ");
INSERT INTO guiNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Oasa ma yave mócoi sundaro tembipɨɨrɨru oaro vae, yogüɨraja ovae onque jiero tape cotɨ ojo vae pe. Cuae onque jaeiño oyepea chupe reta. Jare oe reta ma yave, oguata reta metei tape rupi. Jayave güɨramoiño araɨgua ojo Pedro güi oeya. ");
INSERT INTO guiNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jayave ramo Pedro oicuaa cuae oyeapo vae añete co, jare jei iyeupe: —Añave aicuaa cheYa co ombou araɨgua jare cherepɨuca Herodes güi jare opaete judío reta oipota oyapo cheve vae güi. ");
INSERT INTO guiNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cuae re oñemongueta rambueve, ojo ovae María jo pe. María co jae Juan Marcos ichɨ. Joco pe jeta vae yatɨ oyerure ñogüɨnoi Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro ombopu taraquera, jare oe o güi metei cuñatai Rode jee vae oyeapɨsaca vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Cuae cuñatai oicuaa Pedro iñee, erei oyerovia güi mbaeti oipea taraquera. Osɨi oique o pe, jare omombeu iru reta pe Pedro co oi taraquera pe. ");
INSERT INTO guiNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Erei jae reta jei chupe: —Nemboquere co. Erei jae jeiete jei añete co. Jayave jae reta jei: —Araɨgua oñangarecose jese vae co. ");
INSERT INTO guiNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Erei Pedro jecuae ombopu taraquera. Jare jae reta oipea yave, oecha jae co, jare ipɨacañɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Erei Pedro omopúa ipo omoquirii reta vaera, jare omombeu chupe reta quirai ñandeYa güɨnoe tembipɨɨrɨru güi. Jare jei chupe reta: —Peicuauca cuae Jacobo jare iru oporogüɨrovia vae reta pe. Jayave oe ojo ambué cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Jare coe rupive sundaro reta oñemambeco yae. Echa mbaeti oicuaa mbae ra oyeapo Pedro pe. ");
INSERT INTO guiNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jare Herodes oecauca tei yave, Pedro mbaeti oñevae. Jayave Herodes oparandu sundaro reta pe jese. Jayave oyócuai sundaro reta oyeyucauca vaera. Jayave Herodes ojo Judea güi Cesarea pe, jare opɨta joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jare Herodes pochɨ yae oico Tiro pegua reta jare Sidón pegua reta cotɨ. Jayave jae reta metei rami yogüeru ipɨri, jare oñemoiru reta metei mburuvicha guasu jembiócuai tenondegua vae Blasto jee vae ndive. Jae reta jei chupe agüɨye vaera mburuvicha guasu pochɨ chupe reta. Echa jae reta güeru jembiura mburuvicha guasu Herodes iɨvɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jare Herodes oiparavo metei ara imiari vaera chupe reta. Jayave jocuae ara Herodes oñemonde cavi yae, jare oguapɨ mburuvicha oporojaaa pe, jare imiari chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jare jae reta iñeeata reve jei: —Tumpa iñee co, mbaeti co cuimbae iñee. ");
INSERT INTO guiNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jare jupiveiño metei araɨgua ñandeYa pe oyeócuai vae omombaerasɨ yae Herodes taso pe. Echa Herodes mbaeti omboete Tumpa. Jae rambue omano. ");
INSERT INTO guiNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Erei Tumpa iñee oñemoai, jare jeta vae oporogüɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jare Bernabé jare Saulo yogüeru ye Jerusalén güi, iparavɨquɨ joco pe oyapo ma yave. Jare güeru jae reta jupíe Juan Marcos. ");
INSERT INTO guiNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jare yogüɨreco oporogüɨrovia vae Antioquía pe ñogüɨnoi vae reta ipɨte pe amogüe Tumpa iñee omombeu vae reta jare Tumpa iñee re oporomboe vae reta. Jae reta co Bernabé, Simón Niger, Lucio Cirene pegua, mburuvicha guasu Herodes jentara Manaén jee vae, jare Saulo. ");
INSERT INTO guiNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Cuae reta oyeócuai ñandeYa pe jare oyecuacu tembíu güi rambueve, Espíritu Santo jei chupe reta: —Pemondo Bernabé jare Saulo oyapo vaera mbaravɨquɨ che aiparavo ma chupeguara vae. ");
INSERT INTO guiNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jare oyecuacu reta tembíu güi, jare oyerure reta Tumpa pe. Jayave iru reta oñono ipo jese reta jare omondo. ");
INSERT INTO guiNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jayave Saulo jare Bernabé oñemondouca Espíritu Santo pe, jare yogüɨraja tenta Seleucia pe, jare joco güi oasa ɨ guasu rupi ɨvɨ Chipre pe. ");
INSERT INTO guiNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jare yogüɨraja ovae yave tenta Salamina pe, omombeu reta Tumpa iñee judío reta itupao reta pe. Jare Juan ojo jae reta ndive omborɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jare opaete Chipre omboapɨ yave, yogüɨraja ovae tenta Pafos pe, jare joco pe oñovae metei judío Barjesús jee vae ndive. Jae co metei ipaye vae, jare jei jae co metei Tumpa iñee omombeu vae. Cuae jei oporombotavɨ vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Cuae cuimbae oi mburuvicha Sergio Paulo jee vae ndive. Cuae mburuvicha iyaracuaa catu co. Jae oeni Bernabé jare Saulo, jare oipota oyeapɨsaca Tumpa iñee re. ");
INSERT INTO guiNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Erei Elimas (Cuae tee oipota jei: Ipaye vae.) omboavai, agüɨye vaera tei mburuvicha oporogüɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Erei Saulo (oñembojee vi Pablo pe vae) tɨnɨe Espíritu Santo pe, jare omae ngatu Elimas re ");
INSERT INTO guiNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","jare jei chupe: —Nde co jae aña guasu taɨ oporombotavɨ vae. Nde reyapo icavi mbae vae, jare mbaeti reipota iru vae reta oyapo vaera jupi vae. Jecuaeño reporopia ñandeYa jape icavi vae güi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","¡Mase! añave ñandeYa tombou ipo nderé, nderesa mbae reico vaera. Ngaraa reecha cuaraɨ mbovɨ ara pegua —jei. Jare jupiveiño Elimas mbaeti mbae ipuere oecha, pɨtumimbi oi yave rami, jare cotɨcotɨ oyerova oeca tei quia oipoco güɨraja vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jayave mburuvicha cuae oyeapo vae oecha yave, güɨrovia Tumpa iñee. Echa ipɨacañɨ ñandeYa iporomboe re. ");
INSERT INTO guiNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jayave Pablo jare jae ndive ñogüɨnoi vae reta yogüɨraja Pafos güi, jare oasa ɨ guasu rupi tenta Perge ɨvɨ Panfilia pegua pe. Erei Juan oeya reta ojo ye Jerusalén cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jayave jae reta yogüɨraja Perge güi tenta Antioquía Pisidia pegua cotɨ. Jare joco pe yogüɨraja ovae yave, oique reta judío reta itupao pe mbutuu iara pe, jare oguapɨ reta. ");
INSERT INTO guiNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jare iru vae reta omongueta güire mboroócuai güi jare Tumpa iñee aracae omombeu vae reta oicuatiagüe güi, tupao pegua reta itenondegua reta omondo jei chupe reta: —Orerɨvɨ reta, oime yave ñee penoi oremboaracuaa vaera, pepuere pemiari. ");
INSERT INTO guiNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jayave Pablo opúa, jare omopúa ipo omoquirii reta vaera. Jayave jei chupe reta: —Cuimbae Israel pegua reta, pe reta pemboete co Tumpa. Peyeapɨsaca cheré. ");
INSERT INTO guiNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel pegua reta iTumpa oiparavo ñanetenondegua reta, jare omboeteuca Egipto pe yogüɨreco rambueve. Erei Egipto mbaeti co jae reta iɨvɨ. Jare Tumpa imbaepuere tuicha vae pe güɨnoe joco güi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jare cuarenta año ipɨaguasu chupe reta ñuu rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jare opa omboai güire Canaán güi siete ɨvɨ ambuembué vae pegua reta, omee cuae reta iɨvɨgüe Israel pegua reta pe iɨvɨra —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cuae jaɨcue rupi cuatrocientos cincuenta año rupi Tumpa omee chupe reta mburuvicha reta ojaa vaera Samuel oi regua. Samuel co jae Tumpa iñee aracae omombeu vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jayave jae reta oyerure mburuvicha guasu re. Jayave Tumpa omee chupe reta Cis taɨ Saúl jee vae cuarenta año pegua. Jae co metei cuimbae Benjamín iñemoña pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jare Tumpa cuae cuimbae omombo yave, omee chupe reta David juvicha guasura. Jare Tumpa jei David re: Che aicuaa Isaí taɨ David. Jae co metei cuimbae cheremimbota oipota vae. Jae oyapota opaete che aipota vae —jei, jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Cuae David iñemoña güi Tumpa omee Jesús. Jae co oporomboasa vae. Jocorai Tumpa oyapo ma aracae jeigüe vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ndei Jesús ou mbove, Juan omombeu opaete Israel pegua reta pe oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae, jare oñembobautizauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jare Juan opata ma omombeu chupe reta yave, jei: Pe reta peñemongueta tei che co jae. Erei mbaeti jocorai. Co ou cheraɨcue iru vae. Mbaeti jupi che amboi vaera ipɨapaa —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Cherɨqueɨ reta, pe reta co jae Abraham iñemoña reta. Pe reta pemboete co Tumpa. Tumpa ombou peve cuae ñee peñemboasauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Echa Jerusalén pegua reta jare juvicha reta mbaeti oicuaa quia ra co jae Jesús. Mbaeti vi oicuaa Tumpa iñee aracae omombeu vae reta oicuatiagüe mbutuu iara ñavo jae reta omongueta tei vae. Jae rambue jae reta jei Jesús oyeyucauca vaera, jare jocorai oyeapo oyecuatía oi jese vae —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jare yepe tei mbaeti ovae teco Jesús re oyucauca reta vaera, erei oyerure Pilato pe oyucauca vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jare jae reta opa ma oyapo chupe yave opaete jese oyecuatía oi vae, ombogüeyɨuca reta ɨvɨra güi, jare oñonouca teogüerɨru pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Erei Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jare jeta ara oyecuaa jae jupíe yogüɨraja Galilea güi Jerusalén pe vae reta pe. Jae reta añave omombeu iru vae reta pe —jei Pablo chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Jare ore vi romombeu peve ñee icavi vae, quirai Tumpa jei ñanetenondegua reta pe vae Tumpa etei oyapo ma ñandeve. Echa omoingove ye Jesús güeru omanogüe vae reta ipɨte güi. Oyecuatía oi Salmo mocoia pe corai: “Nde co jae cheRaɨ. Cuae ara che co jae ndeRu”. Jocorai oyecuatía oi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi, agüɨye vaera etei jetegüe oicomegua. Jare cuae re jei: “Tamee ndeve morogüɨrocuavee David pe jae ameeta chupe vae” —jei Tumpa, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jae rambue jei iru Salmo pe: “Che co jae jupi vae. Mbaetita remaeño cheretegüe re oicomegua vaera” —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Echa David oyeócuai güire opaete jenta pegua reta pe Tumpa jemimbota rupi, omano, jare oñeotɨuca itenondegua reta ñogüɨnoia pe, jare jetegüe oicomegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Erei jocuae Tumpa omoingove ye güeru omanogüe vae reta ipɨte güi vae jetegüe mbaeti etei oicomegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jae rambue, cherɨqueɨ reta, peicuaa cavi cuae ore romombeu iru vae reta pe vae. Tumpa iñɨrota peve pembaeyoa reta re cuae Jesús jeco pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jare opaete güɨrovia jese vae reta oñembojupi ma. Echa mbaeti ñandepuere ñañembojupi Moisés iporoócuai re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jae rambue peñeandu, agüɨye vaera oyeapo peve Tumpa iñee aracae omombeu vae reta jei vae. Echa jei reta corai: ");
INSERT INTO guiNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","¡Mase! oporogüɨroɨro vae reta, pepɨacañɨ jare pecañɨtei —jei Tumpa—. Echa che ayapota metei mbaravɨquɨ peico rambueve. Pe reta ngaraa perovia, yepe tei quia omombeuta peve —jei. Jocorai jei reta —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jare oe reta yave judío reta itupao güi, judío mbae vae reta omoñera omombeu vaera chupe reta cuae ñee mbutuu iara outa vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jare tupao pe yatɨ vae reta opa yogüɨraja yave, jeta judío reta jare judiora oyeapo vae omboete Tumpa vae reta yogüɨraja Pablo jare Bernabé ndive. Cuae mócoi reve imiari chupe reta, jare oyócuai jecuaeño oyeco reta vaera Tumpa ipɨacavi re. ");
INSERT INTO guiNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jare mbutuu iara ou vae pe opaete seri tenta pegua reta oñemboatɨ, oyeapɨsaca vaera Tumpa iñee re. ");
INSERT INTO guiNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Erei judío reta oecha yave jeta yae vae yatɨ, oñemoagüɨro yae, jare jei mbaeti co añete Pablo jei vae, jare jei icavi mbae vae Pablo cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jayave Pablo jare Bernabé imiari oquɨye mbae reve chupe reta. Jei reta: —Añete icavi co ore romombeu vaera peve rani Tumpa iñee. Erei peroɨro ma. Mbaeti ma peipota. Jocorai peicuauca oreve mbaetita co penoi tecove opa mbae vae. Jae rambue añave romombeuta judío mbae vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Echa ñandeYa oreócuai corai: Pomondo judío mbae vae reta pe, peraja vaera tembipe chupe reta, jare pemombeu vaera opaete ɨvɨ pegua reta pe Tumpa omboasata co. Jocorai oreócuai —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jare judío mbae vae reta oendu yave cuae ñee, oyerovia yae, jare omboete Tumpa iñee. Jare güɨrovia opaete jocuae Tumpa oiparavo tecove opa mbae vae güɨnoi vaera vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jare Tumpa iñee oñemoai opaete jocuae ɨvɨ rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Erei judío reta omboemboe cuña tenta pegua reta itenondegua omboete Tumpa vae reta jare cuimbae tenta pegua reta itenondegua reta, jare omboɨpɨ oiporarauca Pablo jare Bernabé pe, jare omombo reta iɨvɨ güi. ");
INSERT INTO guiNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jayave Pablo jare Bernabé omotumo ɨvɨtimbo ipɨ güi, oechauca vaera tenta pegua reta co teco güɨnoi, jare yogüɨraja tenta Iconio cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Erei oporogüɨrovia vae reta oyerovia yae, jare tɨnɨe Espíritu Santo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jare Iconio pe Pablo jare Bernabé oique pave judío reta itupao pe, jare imiari reta joco pe ñogüɨnoi vae reta pe. Jae rambue jeta judío reta jare griego reta oporogüɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Erei judío mbaeti oporogüɨrovia vae reta omboemboe judío mbae vae reta, jare omotareɨuca chupe reta oporogüɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jae rambue Pablo jare Bernabé opɨta joco pe ɨma ngatu, jare imiari iru vae reta pe oquɨye mbae reve ñandeYa re. Jare ñandeYa oechauca añete co iñee mbɨacavi regua mɨacañɨ Pablo jare Bernabé oyapo vae reta rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Erei tenta pegua reta oñemboyao oyougüi. Amogüe oñemoiru judío reta ndive, jare amogüe oñemoiru Jesús jemimondo reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jare judío reta jare judío mbae vae reta juvicha reta ndive oipota oporepeña Jesús jemimondo reta re, oyapo vaera tei icavi mbae vae chupe reta jare oyapi vaera tei ita pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Erei Pablo jare Bernabé cuae oicuaa yave, otecuarai yogüɨraja tenta reta Listra jare Derbe pe jare cuae mócoi tenta iyɨvɨ rupi. Cuae tenta reta co ɨvɨ Licaonia pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jare joco pe vi jae reta omombeu ñee icavi vae. ");
INSERT INTO guiNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jare Listra pe oguapɨ oi metei cuimbae mbaeti ipuere oguata vae. Ichɨ jɨe güi oa güive mbaeti etei ipuere oguata. ");
INSERT INTO guiNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Cuae cuimbae oendu Pablo imiari oi. Jare Pablo omae ngatu jese, jare oecha güɨnoi mborogüɨrovia ocuera vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jayave Pablo iñeeata reve jei chupe: —Epúa eñemboɨ. Jare jae opúa voi oñemboɨ jare omboɨpɨ oguata. ");
INSERT INTO guiNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jayave yatɨ vae reta oecha yave Pablo oyapo vae, jei reta Licaonia pegua reta iñee pe iñeeata reve: —Tumpa cuimbae reta rami vae reta ogüeyɨ ñandeve. ");
INSERT INTO guiNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jare jae reta ombojee Bernabé Júpiter, jare ombojee Pablo Mercurio. Echa Pablo oicatu yae imiari vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jare jocuae tumpa-raanga Júpiter jee vae itupao oi tenta jóvai. Jare Júpiter isacerdote güeru güeye reta jare mbaepotɨ reta tenta itaraquera pe, jare jae jare yatɨ vae reta oipota tei oyuca güeye reta omboete vaera Pablo jare Bernabé. ");
INSERT INTO guiNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Erei Jesús jemimondo reta cuae oicuaa yave, omondoro reta jemimonde ae, jare osɨi yatɨ vae reta ipɨte pe, jare iñeeata reve jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Cuimbae reta! ¿maera pa peyapo cuae? Ore peiru retaño co. Jare romombeu peve peyerova vaera cuae icavi mbae vae peyapo vae güi Tumpa oicove vae cotɨ. Echa jae oyapo ara, ɨvɨ, ɨ guasu, jare opaete mbaembae oime ñogüɨnoi pɨpe vae reta —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tumpa omaeño aracae pegua reta re oyapo vaera jae reta oipota vae. ");
INSERT INTO guiNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Erei jae jecuaeño oyecuaa chupe reta mbaembae icavi vae jae oyapo vae rupi. Echa jae ombou ñandeve ama jare ombocuacuaa cavi temitɨ reta ñanerembiura oime vaera. Jare jocorai oyapo, yayerovia yae vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Cuae jei reta yave, jaimei omboavai tenta pegua reta agüɨye vaera oyuca güeye reta omboete vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jayave amogüe judío reta yogüeru Antioquía jare Iconio güi. Jae reta omboemboe tenta pegua reta oyapi vaera Pablo ita pe. Jare oyapi güire, ombotɨrɨrɨ tenta güi icatu pe. Omano echa chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Erei oporogüɨrovia vae reta yogüeru oñemboatɨ yave Pablo iyɨvɨ rupi, Pablo opúa ojo ye tenta pe. Jayave pɨareve pe ojo Bernabé ndive Derbe cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jare omombeu reta ñee icavi vae Derbe pe, jare jeta Derbe pegua reta güɨrovia Jesús re. Jayave Pablo jare Bernabé yogüeru ye Listra, Iconio, jare Antioquía pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jare cuae tenta reta pe jae reta omoatangatu oporogüɨrovia vae reta, jare omboaracuaa jecuae güɨnoi vaera mborogüɨrovia Tumpa cotɨ. Jare jei vi chupe reta: —Jetañotai co yaiporara yaique vaera Tumpa iporoocuaia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jare oporogüɨrovia vae reta oñemboatɨa ñavo pe Pablo jare Bernabé oiparavo oporogüɨrovia vae reta itenondegua retara. Jare oyerure reta oyecuacu reve tembíu güi. Oyerure ñandeYa pe jae oñangareco vaera cuae itenondegua reta re. Echa güɨrovia reta ma ñandeYa re. ");
INSERT INTO guiNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Jayave Pablo jare Bernabé oasa Pisidia rupi, jare yogüɨraja ovae Panfilia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jayave omombeu güire Tumpa iñee Perge pe, yogüɨraja tenta Atalia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jare joco güi oasa ɨ guasu rupi Antioquía cotɨ. Echa oporogüɨrovia vae reta Antioquía pegua tenonde yave oyerure Tumpa pe ipɨacavi oi vaera jae reta ndive cuae mbaravɨquɨ opa ma oyapo vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jare yogüɨraja ovae yave, Pablo jare Bernabé oñemboatɨ oporogüɨrovia vae reta ndive, jare omombeu chupe reta opaete Tumpa oyapo chupe reta vae, jare quirai Tumpa omaeño judío mbae vae reta re oporogüɨrovia vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jare opɨta reta joco pe ɨma ngatu oporogüɨrovia vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jare yogüeru Judea güi amogüe cuimbae reta, jare jei oporogüɨrovia vae reta pe: —Mbaeti peñemocircuncidauca yave Moisés iporoócuai pe jei rami, ngaraa pepuere peñemboasauca. ");
INSERT INTO guiNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jare Pablo jare Bernabé oyoaca yae jae reta ndive cuae re. Jayave oporogüɨrovia vae reta oiparavo Pablo jare Bernabé jare iru vae reta jae reta ipɨte güi, yogüɨraja vaera Jerusalén pe imiari cuae re Jesús jemimondo reta jare oporogüɨrovia vae reta itenondegua reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jayave iru oporogüɨrovia vae reta omondo ma yave, jae reta oasa Fenicia jare Samaria rupi jare omombeu joco pegua reta quirai judío mbae vae reta oyerova Tumpa cotɨ. Jare omboyerovia yae oporogüɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jare yogüɨraja ovae yave Jerusalén pe, Jesús jemimondo reta jare opaete oporogüɨrovia vae reta itenondegua reta ndive oyapo maraetei chupe reta. Jare Pablo jare Bernabé omombeu chupe reta opaete Tumpa oyapo chupe reta vae. ");
INSERT INTO guiNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Erei amogüe fariseo pegua oporogüɨrovia vae reta opúa jare jei: —Icavi co ñamocircuncidauca vaera, jare yayócuai oyapo vaera Moisés iporoócuai. ");
INSERT INTO guiNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jayave Jesús jemimondo reta jare oporogüɨrovia vae reta itenondegua reta oñemboatɨ, oñomomiari vaera cuae re. ");
INSERT INTO guiNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jare oyoaca yae ma oyoupi yave, Pedro opúa jare jei chupe reta: —Cherɨvɨ reta, peicuaa catu co quirai carambué yave Tumpa cheparavo amombeu vaera judío mbae vae reta pe ñee icavi vae, jae reta güɨrovia vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tumpa oicuaa opaete vae ipɨa pe oi vae, jare jae oechauca jae reta güɨrovia co. Echa omee chupe reta Espíritu Santo, ñandeve omee rami —jei Pedro—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jare Tumpa mbaeti etei omboyoavɨ ñandegüi. Echa oitɨo ipɨa, jae reta güɨrovia yave —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jayave ¿maera pa peipota pemboavai Tumpa? Echa mboroócuai metei voɨta rami. Pe reta peipota pembovoɨta jocuae oporogüɨrovia vae reta. Erei ñanetenondegua reta jare ñande vi mbaeti ñandepuere yavoɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ñande yarovia ñañemboasauca ma co ñandeYa Jesús ipɨacavi re, jae reta rami —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jayave opaete yatɨ vae reta quirii, jare oyeapɨsaca Bernabé jare Pablo jei vae re. Jae reta omombeu chupe reta opaete mɨacañɨ reta Tumpa oyapo jae reta rupi judío mbae vae reta ipɨte pe vae. ");
INSERT INTO guiNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jare jae reta opa imiari yave, Jacobo jei: —Cherɨvɨ reta, peyeapɨsaca cheré. ");
INSERT INTO guiNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón omombeu ma ñandeve quirai Tumpa jaeramo ete oparavɨquɨ judío mbae vae reta ipɨte pe, oiparavo vaera chugüi reta amogüe jae jee omboete vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cuae re co jei vi Tumpa iñee aracae omombeu vae reta. Oyecuatía oi corai: ");
INSERT INTO guiNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Cuae jaɨcue rupi ayu yeta, jare ayapo yeta David jenta opa osururu vae —jei ñandeYa—. Amopúa yeta osururugüe, jare ambopɨauta, ");
INSERT INTO guiNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","opaete iru ɨvɨ pegua reta chereca vaera, jare opaete judío mbae vae reta. Che co jae reta iYa. ");
INSERT INTO guiNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Che aicuauca cuae aracae güive —jei ñandeYa. Jocorai oyecuatía oi —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jae rambue che jae agüɨye ñamambeco jocuae judío mbae vae oyerova Tumpa cotɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Erei yaicuatía chupe reta agüɨye vaera jou soo tumpa-raanga pe oñererocuavee vae, jare maemɨmba oyeyuvɨ vae isoo, jare soo jugüɨ reve, jare agüɨye vaera oyapo aguasa —jei Jacobo—. ");
INSERT INTO guiNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Echa aracae güive yogüɨreco tenta ñavo pe Moisés iporoócuai omombeu vae reta. Mbutuu iara ñavo jae reta omongueta Moisés iporoócuai itupao reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jayave Jesús jemimondo reta jare opaete oporogüɨrovia vae reta itenondegua reta ndive jei icavi co oyeparavo vaera amogüe cuimbae reta jae reta ipɨte güi, omondo vaera Antioquía pe Pablo jare Bernabé ndive. Jayave oiparavo Judas Barsabás jare Silas. Jae reta co oporogüɨrovia vae reta itenondegua reta. ");
INSERT INTO guiNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jare jae reta güɨraja tupapire. Cuae tupapire pe jei corai: Ore co jae Jesús jemimondo reta jare opaete oporogüɨrovia vae reta itenondegua reta ndive. Romondo tamaraeme opaete judío mbae vae oporogüɨrovia vae Antioquía, Siria, jare Cilicia pegua reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jeracua oreve quirai amogüe orepɨte güi yogüɨraja pemambeco. Jocorai oyapo reta, yepe tei ore mbaeti royócuai. Jae rambue pe reta mbaeti peicuaa mbae peyapo vaera. Echa jei reta peñemocircuncidauca vaera jare peyapo vaera mboroócuai pe oyecuatía oi vae. ");
INSERT INTO guiNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Oremiari ma cuae re, jare ore opaete roe icavi co oyeparavo vaera amogüe orepɨte güi, romondo vaera pecotɨ Bernabé jare Pablo ndive. Roaɨu co Bernabé jare Pablo. ");
INSERT INTO guiNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jae reta iquɨreɨ omee jecove ñandeYa Jesucristo pe oyeócuai vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jae rambue romondo pepɨri Judas jare Silas. Jae reta iñee pe etei omombeuta vi peve cuae. ");
INSERT INTO guiNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ore ngaraa pomboavai. Cuae mbovɨño romombeuta peve. Cuae icavi Espíritu Santo pe jare oreve vi. ");
INSERT INTO guiNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Agüɨye peu soo tumpa-raanga pe oñererocuavee vae, jare maemɨmba oyeyuvɨ vae isoo, jare soo jugüɨ reve. Jare agüɨye peyapo aguasa. Cuae ore roe peve vae peyapo yave, icavita peico. Tumpa ndiveño. Jocorai oyecuatía oi tupapire pe. ");
INSERT INTO guiNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jayave oñemondouca vae reta yogüɨraja ovae Antioquía pe. Jare omboatɨ yave oporogüɨrovia vae reta, omee chupe reta tupapire. ");
INSERT INTO guiNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jare opa omongueta yave, opareve oyerovia cuae ñee ombopɨacatu vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jare Judas jare Silas Tumpa iñee omombeu vae reta co, jare jeta imiari oporogüɨrovia vae reta pe, ombopɨacatu jare omomɨrata vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jare ɨma ngatu joco pe ñogüɨnoi yave, oporogüɨrovia vae reta oipota omondo cavi ye ombou vae reta cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Erei icavi echa Silas pe opɨta vaera joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jare Pablo jare Bernabé opɨta Antioquía pe oporomboe Tumpa iñee re, jare omombeu ñee icavi vae jeta iru vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mbovɨ ara rupi Pablo jei Bernabé pe: —Yaja ye yapou oporogüɨrovia vae reta pɨri opaete tenta ñamombeu ma ñandeYa iñee pɨpe vae reta rupi, yaecha vaera quirai ra ñogüɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jare Bernabé oipota tei güɨraja jae reta jupíe Juan Marcos. ");
INSERT INTO guiNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Erei Pablo oñemongueta mbaeti icavi güɨraja vaera jae reta jupíe. Echa Juan Marcos ou ye Panfilia güi chugüi reta, jare mbaeti ojo jae reta jupíe Tumpa iparavɨquɨ oyapo vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jare oyoaca yae reta oyoupi cuae re. Jae rambue oñemboyao reta oyougüi. Marcos ojo Bernabé jupíe, jare jae reta oasa ɨ guasu rupi Chipre pe. ");
INSERT INTO guiNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Erei Pablo oiparavo Silas iguatairura, jare oporogüɨrovia vae reta oyerure ñandeYa pe ipɨacavi oi vaera jae reta ndive. Jayave jae reta yogüɨraja. ");
INSERT INTO guiNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jare oasa reta ɨvɨ reta Siria jare Cilisia rupi omoatangatu reve oporogüɨrovia vae reta oñemboatɨa ñavo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jayave yogüɨraja ovae Derbe pe, jare joco güi yogüɨraja Listra pe. Jare joco pe oico metei oporogüɨrovia vae Timoteo jee vae. Ichɨ co jae metei judía oporogüɨrovia vae, jare tu co jae metei griego. ");
INSERT INTO guiNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Oporogüɨrovia vae Listra jare Iconio pe ñogüɨnoi vae reta imiari cavi Timoteo re. ");
INSERT INTO guiNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo oipota güɨraja Timoteo jae reta jupíe. Jae rambue omocircuncidauca, jocoropi judío ñogüɨnoi vae reta jeco pegua. Echa opaete vae oicuaa jae tu griego co. ");
INSERT INTO guiNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jare yogüɨraja rambueve tenta reta rupi, omombeu oporogüɨrovia vae reta pe Jesús jemimondo reta jare oporogüɨrovia vae reta itenondegua Jerusalén pe ñogüɨnoi vae reta oicuatía chupe reta vae, jae reta oyapo vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jayave oporogüɨrovia vae reta oñemboatɨa ñavo pe oñemoatangatu Tumpa cotɨ, jare ara ñavo iru vae reta güɨrovia Jesús re jare oñemoiru jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jare Pablo jare jae ndive ñogüɨnoi vae reta oasa ɨvɨ reta Frigia jare Galacia rupi. Jare Espíritu Santo oyopia reta, agüɨye vaera omombeu Tumpa iñee Asia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Jare ɨvɨ Misia pe yogüɨraja ovae yave, oipota tei yogüɨraja ɨvɨ Bitinia pe. Erei Espíritu Santo mbaeti omaeño yogüɨraja vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jayave oasa reta coiño Misia güi, jare yogüɨraja ovae tenta Troas pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jare pɨtu yave Pablo oecha ique pe metei cuimbae ɨvɨ Macedonia pegua oñemboɨ oi joco pe. Jare cuimbae oyerure Pablo pe: —Ecua Macedonia pe oremborɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jare cuae oecha ma yave, jupiveiño roipota rojo Macedonia cotɨ. Echa roicuaa ma Tumpa orereni romombeu vaera Macedonia pegua reta pe ñee icavi vae. ");
INSERT INTO guiNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jayave rojo roasa isɨmbi ɨ guasu rupi Troas güi ɨvɨ Samotracia pe. Jayave pɨareve pe rojo rovae tenta Neápolis pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Jayave joco güi rojo tenta Filipos pe. Cuae co tenta tenondegua ɨvɨ Macedonia pegua, jare cuae pe yogüeru yogüɨreco vaera Roma pegua reta. Cuae tenta pe ropɨta mbovɨ ara. ");
INSERT INTO guiNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jare mbutuu iara pe rojo tenta itaraquera rupi ɨaca jembeɨ pe. Joco pe oi metei yerurearenda. Jare joco pe roguapɨ ma yave, oremiari cuña joco pe yatɨ vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jare metei cuña Lidia jee vae tenta Tiatira pegua oyeapɨsaca oi. Cuae cuña omboete Tumpa. Jae co temimonde pɨta vae omee vae. Jare ñandeYa oparavɨquɨ ipɨa pe, jae oyeapɨsaca cavi vaera Pablo jei vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jare jae jare jentara reta oñembobautizauca ma yave, jae jei oreve: —Peñemongueta yave che arovia cavi ñandeYa re, peyu pepɨta chero pe. Jare oremoñera yae ropɨta vaera joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jare rojo yave yerurearenda pe, orerovaiti metei cuñatai aña oya jese vae. Cuae cuñatai iya reta omongana jeta corepoti jese. Echa cuñatai omombeu iru vae reta pe aña imbaepuere rupi mbae oyeapota vae. ");
INSERT INTO guiNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Cuae cuñatai ojo oreraɨcue, jare iñeeata reve jei: —Cuae cuimbae reta Tumpa ɨvate pegua jembiócuai reta co. Jae reta omombeu ñandeve quirai ñandepuere ñañemboasauca —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jare jeta ara jocorai oyapo cuñatai. Jayave cuae omambeco Pablo, jare jae oyerova jei aña pe: —Jesucristo jee re roócuai: ¡Ecua chugüi! Jare jupiveiño aña ojo chugüi. ");
INSERT INTO guiNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Jare cuñatai iya reta oicuaa yave mbaetita ma co omongana jese, oipɨɨ reta Pablo jare Silas, jare güɨraja reta omaemee vae reta ñogüɨnoia pe mburuvicha reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jare mburuvicha reta pe güɨraja ma yave, jei reta: —Cuae cuimbae reta judío reta co, jare omambeco yae ñanerenta pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mbaeti jupi ñamboresive vaera ani yayapo vaera cuae teco omombeu ñandeve vae. Echa ñande Roma pegua reta co —jei reta mburuvicha reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jayave yatɨ vae reta metei rami oepeña reta. Jare mburuvicha reta omondoro Pablo jare Silas jemimonde reta, jare oinupauca ɨvɨra pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Jare jeta oinupauca reta güire, omoingueuca reta tembipɨɨrɨru pe. Jare oyócuai reta tembipɨɨrɨru iñangarecoa oaro cavi vaera, agüɨye vaera otecuarai. ");
INSERT INTO guiNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cuae oendu yave, tembipɨɨrɨru iñangarecoa omoingue reta tembipɨɨrɨru japɨpe cotɨ ete oi vae pe, jare oñono ipɨ reta ɨvɨracua pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Erei pɨare mbɨte yave Pablo jare Silas oyerure Tumpa pe, jare ocanta ñogüɨnoi omboete Tumpa vaera. Jare iru tembipɨɨ reta oyeapɨsaca ñogüɨnoi jese reta. ");
INSERT INTO guiNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jare güɨramoiño tanta yae ocana ɨvɨ, jare oñemocana tembipɨɨrɨru iguapɨa reta. Jare jupiveiño oyepea opaete onque reta, jare oyera opaete cadena tembipɨɨ reta oñeapɨti pɨpe vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jayave tembipɨɨrɨru iñangarecoa oicove, jare oecha oyepea ñogüɨnoi tembipɨɨrɨru jonque reta. Jayave oequi iquɨsepucu jɨru güi, oyeyuca vaera. Echa jae oñemongueta tei tembipɨɨ reta opa ma otecuarai. ");
INSERT INTO guiNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Erei Pablo iñeeata reve jei: —Agüɨye eyeyuca. Echa opareveño roi cuae pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jayave tembipɨɨrɨru iñangarecoa oeni quia güeru vaera chupe tembipe. Jayave osɨi tembipɨɨrɨru japɨpe pe, jare oyeatɨca Pablo jare Silas jóvai. Orɨrɨi oi oquɨye güi. ");
INSERT INTO guiNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jayave güɨnoe reta icatu pe jare jei chupe reta: —Carai reta, ¿mbae pa ayapota añemboasauca vaera? ");
INSERT INTO guiNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jayave jae reta jei chupe: —Erovia ñandeYa Jesucristo re, jare reñemboasaucata co, jare ndero pegua reta vi. ");
INSERT INTO guiNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jayave jae reta omombeu Tumpa iñee chupe jare opaete jo pegua reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jare jocuae ora voi tembipɨɨrɨru iñangarecoa güɨraja Pablo jare Silas oyoe iperea. Jayave jae jare opaete jo pegua reta oñembobautizauca. ");
INSERT INTO guiNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jayave tembipɨɨrɨru iñangarecoa güɨraja jo pe omongaru Pablo jare Silas. Jare jae jare opaete jo pegua reta oyerovia yae. Echa güɨrovia reta ma Tumpa re. ");
INSERT INTO guiNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Jare coe ma yave, mburuvicha reta ombou amogüe sundaro reta jei vaera: —Eyora jocuae cuimbae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jare tembipɨɨrɨru iñangarecoa omombeu cuae ñee Pablo pe. Jei chupe: —Mburuvicha reta ombou cheócuai poyora vaera. Jae rambue añave pepuere pee jare peo cavi. ");
INSERT INTO guiNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Erei Pablo jei sundaro reta pe: —Mburuvicha reta orenupauca opaete vae jovaque orereco mbae reve, jare oremoingueuca tembipɨɨrɨru pe, yepe tei ore co jae romano reta. Jare añave oipota oreyorauca vɨari. Ngaraa oyapo jocorai. Toyogüeru jae reta etei oreyora vaera —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jayave sundaro reta yogüɨraja omombeu cuae ñee mburuvicha reta pe. Jayave mburuvicha reta oquɨye, oicuaa yave jae reta romano reta co. ");
INSERT INTO guiNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jayave yogüeru tembipɨɨrɨru pe omoɨro Pablo jare Silas. Jayave güɨnoe icatu pe, jare omoñera yogüɨraja vaera tenta güi. ");
INSERT INTO guiNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jayave Pablo jare Silas yogüɨraja tembipɨɨrɨru güi Lidia jo pe. Jare oecha oporogüɨrovia vae reta, jare omboaracuaa. Jayave yogüɨraja joco güi. ");
INSERT INTO guiNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo jare Silas oasa güire tenta reta Anfípolis jare Apolonia rupi, yogüɨraja ovae tenta Tesalónica pe. Joco pe oi metei judío reta itupao. ");
INSERT INTO guiNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jare Pablo ojo tupao pe. Echa jocorai oyapo tenta ñavo pe. Jare mboapɨ mbutuu iara oyoaca judío reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Oechauca chupe reta Tumpa iñee oyecuatía oi vae, jare oicuauca quirai Cristo oiporarañotai co jare oicove yeñotai co ou omanogüe vae reta ipɨte güi. Jare jei chupe reta: —Cuae Jesús che amombeu peve vae co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jayave amogüe güɨrovia Pablo jei vae, jare jae reta, jare jeta griego omboete Tumpa vae reta, jare jeta cuña tenta pegua reta itenondegua reta oñemoiru Pablo jare Silas ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Erei judío mbaeti güɨrovia vae reta oñemoagüɨro Pablo jare Silas re, jare güeru amogüe cuimbae iyaquɨ vae reta. Jeco pochɨ co cuae cuimbae reta. Jayave omboatɨ jeta iru vae reta, jare oyapo tecorai. Jayave oporepeña reta Jasón jo re oeca tei Pablo jare Silas. Oipota tei güɨraja tenta pegua reta jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Erei mbaeti ovae chupe reta. Jayave oipɨɨ güɨraja Jasón jare amogüe oporogüɨrovia vae reta mburuvicha tenta pegua reta pe, jare iñeeata reve jei reta: —Jocuae cuimbae omambeco opaete ɨvɨ pegua reta vae reta yogüeru vi cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jare Jasón güɨnoi jo pe. Jare opaete jae reta oyovaicho César iporoócuai ndive. Echa jei reta oime iru mburuvicha guasu Jesús jee vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jayave tenta pegua reta jare juvicha reta cuae oendu yave, oñemambeco. ");
INSERT INTO guiNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jare Jasón jare iru vae reta omboepɨ chupe reta yave, jae reta omaeño yogüɨraja vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jare jupiveiño oporogüɨrovia vae reta omondo Pablo jare Silas pɨtu yave tenta Berea jee vae cotɨ. Jare jae reta yogüɨraja ovae yave joco pe, yogüɨraja judío reta itupao pe. ");
INSERT INTO guiNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jare joco pegua judío reta iyaracuaa catu yae Tesalónica pegua reta güi. Iquɨreɨ yae oyeapɨsaca Tumpa iñee re, jare ara ñavo omongueta cavi Tumpa iñee oyecuatía oi vae, oicuaa vaera añete ra Pablo jei vae. ");
INSERT INTO guiNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jare jeta joco pegua reta güɨrovia. Jare güɨrovia vi jeta griega reta itenondegua reta, jare jeta griego reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Erei judío Tesalónica pegua reta oicuaa yave Pablo omombeu Berea pegua reta pe vi Tumpa iñee, yogüɨraja joco pe omboemboe omambeco vaera joco pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jayave oporogüɨrovia vae reta omondo Pablo ɨ guasu cotɨ. Erei Silas jare Timoteo opɨta Berea pe. ");
INSERT INTO guiNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jare Pablo jupíe yogüɨraja vae reta güɨraja tenta Atenas pe. Jayave Pablo oyócuai jae reta omombeu vaera Silas jare Timoteo pe yogüeru vaera icotɨ ɨmambae, ipuere yave. Jayave jae reta yogüeru ye Berea cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jare Pablo oaro oi rambueve Atenas pe, oecha yave jeta tumpa-raanga reta ñogüɨnoi tenta rupi, pochɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jayave oyoaca judío reta itupao pe judío reta jare iru omboete Tumpa vae reta ndive. Jare oyoaca vi ara ñavo omaemee vae reta ñogüɨnoia pe joco pe ñogüɨnoi vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jare amogüe iyaracuaa vae reta oyoaca Pablo ndive. Jae reta co Epicureo jare Estoico jee vae reta. Amogüe jei: —¿Mbae ra oipota jei cuae iñeengatu vae? Jare iru vae reta jei: —Güɨramoi jae omombeu iru tumpa mbaeti yaicuaa vae reta regua. Echa Pablo omombeu chupe reta ñee icavi vae Jesús regua, jare quirai jae oicove ye ou omanogüe vae reta ipɨte güi. ");
INSERT INTO guiNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jare jae reta güɨraja Pablo ɨvɨtɨ Areópago jee vae pe. Jare jei reta chupe: —Emombeu oreve mbae nunga moromboe ipɨau vae ra cuae nemiari jese vae. ");
INSERT INTO guiNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Echa cuae remombeu ma oreve vae jaeramo roendu. Jae rambue roipota roicuaa mbae ra oipota jei cuae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Echa opaete Atenas pegua reta jare quiotɨ güi yogüeru yogüɨreco joco pe vae reta oñemoembiapo imiari jare oyeapɨsaca mbae ipɨau vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Jayave Pablo oñemboɨ Areópago mbɨte pe, jare jei chupe reta: —Cuimbae Atenas pegua reta, aecha ma pe reta pemboete yae co tumpa reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Echa aguata rambueve tenta rupi, amae jocuae pemboete vae reta re, jare aecha metei pemboetearenda, jare jese oyecuatía oi corai: Tumpa mbaeti yaicuaa vae. Jocorai oyecuatía oi. Jae rambue tamombeu peve pe reta mbaeti peicuaa reve pemboete vae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tumpa oyapo ɨvɨ jare opaete oi pɨpe vae. Jae co ara jare ɨvɨ iYa. Jae mbaeti oico ñamboetearenda ñande yayapo vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tumpa mbaeti etei oeca ɨvɨ pegua reta omee vaera mbae chupe. Echa jae etei co omee ñandeve tecove, jare ñandepɨtu, jare opaete mbaembae —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Jare Tumpa oyapo metei cuimbae, jare opaete ɨvɨ pegua reta iñemoña reta co. Jocorai Tumpa oyapo, jae reta yogüɨreco vaera opaete ɨvɨ iárambue. Tumpa etei co omee quirai yave tenta pegua reta yogüɨreco vaera, jare omboyaoyao ɨvɨ chupe reta yogüɨreco teetee vaera —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Opaete cuae Tumpa oyapo, ɨvɨ pegua reta oeca vaera Tumpa, jare güɨramoi ovae vaera iyeupe. Echa añetete jae mbaeti mombɨrɨ oi ñaneavo güi. ");
INSERT INTO guiNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jese yaicove jare ñamɨi, yaico vaera. Jare jocorai vi amogüe pepɨte pe oi vae jei oicuatiagüe pe: Echa jese yaico —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jare Tumpa omee ñandeve tecove rambue, mbaeti icavi ñañemongueta vaera Tumpa co jae oro pegua, ani corepoti pegua, ani ita pegua. Echa cuimbae reta oyapo cuae nunga iñemongueta ae ñavo rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aracae ɨvɨ pegua reta mbaeti oicuaa rambue, Tumpa omaeño jese reta. Erei añave jae oyócuai opaete ɨvɨ pegua reta oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Echa Tumpa oiparavo ma metei ara ojaauca vaera oyavɨ mbae reve ɨvɨ pegua reta jocuae cuimbae jae oiparavo vae pe. Jare cuae oicuauca opaete ɨvɨ pegua reta pe. Echa Tumpa omoingove ye jocuae oiparavo vae güeru omanogüe vae reta ipɨte güi —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jare oendu reta yave oicove ye ou omanogüe vae reta ipɨte güi vae regua, amogüe vae oyóyai. Erei iru vae reta jei Pablo pe: —Royeapɨsaca yeta nderé iru ara cuae re. ");
INSERT INTO guiNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jayave Pablo oeya reta. ");
INSERT INTO guiNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Erei amogüe vae güɨrovia Tumpa iñee, jare oñemoiru Pablo ndive. Cuae reta ipɨte pe ñogüɨnoi metei Areópago pegua Dionisio jee vae, metei cuña Dámaris jee vae, jare iru vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Cuae jaɨcue rupi Pablo ojo Atenas güi tenta Corinto pe. ");
INSERT INTO guiNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Jare oñovae joco pe metei judío Aquila jee vae ndive. Jae co Ponto pegua. Cuae judío ou ramo ovae Italia güi jembireco Priscila jee vae ndive. Echa mburuvicha guasu Claudio jee vae oyócuai opaete judío reta yogüɨraja vaera Roma güi. Jayave Pablo opou ipɨri. ");
INSERT INTO guiNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Jare Pablo oicatu oyapo Aquila iparavɨquɨ. Jae rambue Pablo opɨta jae reta ndive, jare oparavɨquɨ pave reta. Jae reta co o reta carpa pegua iyapoa. ");
INSERT INTO guiNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jare mbutuu iara ñavo Pablo oyoaca judío reta itupao pe. Cuae oyapo, judío reta jare griego reta güɨrovia vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jare Silas jare Timoteo yogüeru ovae yave Macedonia güi, Pablo oñemoembiapo yae omombeu Tumpa iñee. Omombeu judío reta pe Jesús co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Erei judío reta oyovaicho jae ndive, jare jei reta icavi mbae vae icotɨ. Jae rambue Pablo omotumo jemimonde, jare jei chupe reta: —Pecañɨteita co, jare pe retaño penoita teco. Che mbaeti ma anoi teco. Añave güive ajata amombeu judío mbae vae reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Jayave ojo joco güi cuimbae Justo jee vae jo pe. Cuae cuimbae omboete Tumpa, jare jae jo oi judío reta itupao iyɨpɨ pe. ");
INSERT INTO guiNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jare judío reta itupao pegua reta itenondegua Crispo jee vae jare opaete jo pegua reta güɨrovia ñandeYa re. Jare jeta Corinto pegua reta oendu Pablo omombeu vae yave, güɨrovia jare oñembobautizauca. ");
INSERT INTO guiNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jare ñandeYa jei Pablo pe pɨtu yave ique pe: —Agüɨye equɨye. Nemiari jare agüɨye nequirii. ");
INSERT INTO guiNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Echa che ai nde ndive, jare ngaraa quia ipuere nderé, oyapo vaera icavi mbae vae ndeve. Echa oime jeta cheré güɨrovia vae reta cuae tenta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jare Pablo opɨta joco pe metei año jare seis yasɨ, jare omombeu Tumpa iñee tenta pegua reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Erei Galión jee vae oico mburuvicha ɨvɨ Acaya pegua yave, judío reta oyovaicho metei rami Pablo ndive, jare güɨraja mburuvicha oporojaaa pe ");
INSERT INTO guiNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","jare jei reta: —Cuae cuimbae omboe yave tenta pegua reta omboete vaera Tumpa, mbaeti omboe mboroócuai pe oyecuatía oi vae rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Jare Pablo omoeta ma yave iñee, Galión jei judío reta pe: —Judío reta, cuae cuimbae oyapo yave icavi mbae vae pecotɨ, ani jeco pochɨ yave, icavita tei ayeapɨsaca vaera peré. ");
INSERT INTO guiNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Erei peipota yave ajaa vaera ñee reta re, tee reta re, jare peporoócuai re, ngaraa ayeapɨsaca peré. Pe reta etei pepuere pejaa. Echa che mbaeti aipota ajaa cuae nunga re —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jayave Galión omondo reta oporojaaa güi. ");
INSERT INTO guiNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jayave griego reta oipɨɨ judío reta itupao pegua itenondegua Sóstenes jee vae, jare ocua jese mburuvicha oporojaaa jóvai. Erei Galión mbaeti etei oñemambeco jese. ");
INSERT INTO guiNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Jare cuae güire Pablo opɨta vɨteri jeta ara joco pe. Jayave ojo oporogüɨrovia vae reta güi, jare oasa ɨ guasu rupi Siria cotɨ Priscila jare Aquila jupíe. Jare tenta Cencrea pe Pablo oñapiuca iñaca. Echa tenonde yave jei Tumpa pe oyapota mbae chupe ndei oñapiuca ye iñaca mbove. ");
INSERT INTO guiNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jare yogüɨraja ovae yave tenta Efeso pe, Pablo oeya Priscila jare Aquila. Jayave oique judío reta itupao pe, jare oyoaca judío reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jare judío reta omoñera yave opɨta vaera joco pe, mbaeti oipota. ");
INSERT INTO guiNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Jare ojota ma yave chugüi reta, jei: —Ajata co Jerusalén pe, ayapo vaera arete outa vae. Erei Tumpa oipota yave, tayu ye pepɨri —jei. Jayave ojo ɨ guasu rupi Efeso güi. ");
INSERT INTO guiNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Jare ojo ovae yave Cesarea pe, ojo oyapo maraetei oporogüɨrovia vae reta pe. Jayave ojo joco güi Antioquía pe. ");
INSERT INTO guiNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jare mbovɨ ara joco pe oi güire, ojo opaete tenta Galacia jare Frigia pegua reta pe omoatangatu vaera opaete oporogüɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jare ou Efeso pe metei judío Alejandría pegua Apolos jee vae. Cuae cuimbae ipuere imiari cavi, jare oicuaa cavi Tumpa iñee oyecuatía oi vae. ");
INSERT INTO guiNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Cuae cuimbae oñemboe ma ñandeYa iporomboe re. Jatangatu yae, jare imiari jare oporomboe jaecavi ñandeYa re. Erei oicuaa moromboe Juan oporombobautizase jese vaeño. ");
INSERT INTO guiNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Jae omboɨpɨ imiari oquɨye mbae reve judío reta itupao pe. Erei Priscila jare Aquila oendu yave jeigüe, güɨraja jo pe, jare omboe cavi quirai yaico vaera Tumpa cotɨ vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jare Apolos oipota ojo yave Acaya pe, oporogüɨrovia vae reta omoatangatu jese, jare oicuatía reta metei tupapire oporogüɨrovia vae reta pe, omboresive cavi reta vaera Apolos. Jare jae ojo ovae yave joco pe, omborɨ yae jocuae Tumpa ipɨacavi jeco pegua oporogüɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jae imiari mbaepuere reve, jare omoamɨri judío reta tenta pegua reta jovaque. Echa oechauca chupe reta Tumpa iñee oyecuatía oi vae pe Jesús co jae Cristo. ");
INSERT INTO guiNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corinto pe oi rambueve, Pablo ou ovae Efeso pe, opa güire oguata opaete tenta cuaraɨ oea cotɨ ñogüɨnoi vae reta rupi. Jare Efeso pe oñovae amogüe oporogüɨrovia vae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jare Pablo oparandu chupe reta: —¿Ou pa Espíritu Santo peve peporogüɨrovia yave? Jae reta jei chupe: —Mbaeti etei roicuaa Espíritu Santo ou vae regua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Jayave Pablo oparandu ye chupe reta: —¿Mbae nunga moromboe re pa peñembobautizauca? Jare jae reta jei chupe: —Juan iporomboe re roñembobautizauca. ");
INSERT INTO guiNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Jayave Pablo jei chupe reta: —Juan ombobautiza tenta pegua reta, oeya yave iñemongueta icavi mbae vae ipɨa pe oi vae. Jare jei chupe reta güɨrovia vaera outa jaɨcue vae re. Cuae oipota jei Jesús re. Jesús co jae Cristo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jare cuae oendu yave, oñembobautizauca ñandeYa Jesús jee re —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jayave Pablo oñono ipo jese reta, jare ou chupe reta Espíritu Santo, jare jae reta imiari ambué vae iñee pe, jare omombeu reta Tumpa iñee. ");
INSERT INTO guiNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jare cuae cuimbae reta oupitɨ doce rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Jayave Pablo ojo judío reta itupao pe, jare imiari oquɨye mbae reve. Jare mboapɨ yasɨ oyoaca judío reta ndive Tumpa iporoocuaia re. ");
INSERT INTO guiNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Erei amogüe ipɨatanta jare mbaeti oipota güɨrovia, jare jei reta ñee icavi mbae vae tenta pegua reta jovaque oporogüɨrovia vae reta iporogüɨrovia cotɨ. Jayave Pablo ojo chugüi reta, jare güɨraja jae ndive oporogüɨrovia vae reta, jare oyoaca ara ñavo Tiranno jo tuicha vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jare jocorai oyapo mócoi año. Jae rambue opaete judío jare griego Asia pegua reta oendu ñee ñandeYa Jesús regua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Jare Tumpa oyapo mɨacañɨ tuicha vae reta Pablo rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Echa iru vae reta güɨraja yave mbaembae Pablo omonde vae imbaerasɨ vae reta pe, imbaerasɨ vae reta ocuera, jare aña reta yogüɨraja oya jese vae reta güi. ");
INSERT INTO guiNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jayave amogüe judío reta omboɨpɨ tei oeni ñandeYa Jesús jee aña reta oya jese vae reta re. Cuae nunga judío reta oguata opaete que rupi omondo aña reta oya jese vae reta güi. Jae reta jei: —Poócuai Jesús Pablo omombeu vae jee re. ");
INSERT INTO guiNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jare metei judío Esceva jee vae güɨnoi siete taɨ reta. Esceva co jae metei sacerdote reta itenondegua. Jare cuae cuimbae taɨ reta vi jocorai jei aña pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Erei aña jei chupe reta: —Che aicuaa co Jesús, jare aicuaa catu quia co jae Pablo. Erei ¿quia pa co pe reta? ");
INSERT INTO guiNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Jare jocuae cuimbae aña oya jese vae oepeña reta, jare omoamɨri. Omonandi jare ombopere. Jare jae reta otecuarai jocuae o güi. ");
INSERT INTO guiNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jare cuae jeracua opaete judío jare griego Efeso pegua reta pe. Jae rambue opareve oquɨye, jare omboete ñandeYa Jesús jee. ");
INSERT INTO guiNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Jare jeta oporogüɨrovia vae reta yogüeru omombeu jeco icavi mbae vae oeya ma vae regua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jare jeta ipaye vae reta güeru itupapire reta, jare oapɨ opaete vae jovaque. Jare cuae tupapire reta jepɨ oyepapa yave, oupitɨ cincuenta mil corepoti ti vae. ");
INSERT INTO guiNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Echa Tumpa iñee mombɨrɨ rupi ma oñemoai, jare mbaepuere tuicha vae güɨnoi. ");
INSERT INTO guiNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cuae jaɨcue rupi Pablo oñemongueta ojo vaera Macedonia jare Acaya rupi Jerusalén pe. Jare jae jei: —Joco güi ajata vi co Roma pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jayave omondo Macedonia cotɨ mócoi imborɨa reta Timoteo jare Erasto jee vae. Erei jae opɨta ye mbovɨ ara Asia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jare jocuae ara reta pe oi tecorai oporogüɨrovia vae reta iporogüɨrovia re. ");
INSERT INTO guiNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Echa metei cuimbae Demetrio jee vae omondɨcui corepoti, jare oyapo tupao-raanga michi vae corepoti pegua reta. Efeso pegua reta omboete itumpa-raanga Diana jee vae cuae nunga tupao-raanga michi vae pe. Jare Demetrio omboepɨ cavi omborɨ oyapo vae reta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Cuae cuimbae omboatɨ omborɨ oyapo vae reta jare iru cuae nunga mbaravɨquɨ oyapo vae reta, jare jei chupe reta: —Cuimbae reta, peicuaa catu co cuae mbaravɨquɨ güi ñamongana yaicocatu vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Jare peecha jare peendu ma quirai cuae Pablo omboyerova jeta vae Efeso pe jare opaete seri Asia rupi jae iporomboe pe. Echa jae jei mbaembae cuimbae reta omojaanga oyapo vae mbaeti co tumpa reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jare güɨramoi tenta pegua reta güɨroɨrota cuae ñandeparavɨquɨ. Jare güɨramoi güɨroɨrota vi tumpa cuña oñemboete vae Diana itupao, jare ngaraa ma quia omboete. Echa añave opaete Asia pegua reta jare opaete ɨvɨ pegua reta omboete —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Cuae oendu reta yave, pochɨ yae, jare iñeeata reve jei: —Oñemboete yae co Diana Efeso pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jare tecorai oñemoai opaete tenta rupi. Jare jeta vae metei rami osɨi tenta pegua reta oñuvangaa pe. Jare oipɨɨ güɨraja joco pe Pablo iguatairu reta Gayo jare Aristarco. Cuae reta co Macedonia pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Jayave Pablo oipota tei oique tenta pegua reta yatɨ ñogüɨnoia pe. Erei oporogüɨrovia vae reta mbaeti omaeño jese. ");
INSERT INTO guiNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Jare amogüe Asia pegua mburuvicha Pablo ndive oyopocuaa vae reta omondo omombeu Pablo pe agüɨye vaera ojo tenta pegua reta oñuvangaa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jare opaete yatɨ vae reta iñeeata, erei mbaeti oyovaque iñee reta. Tecorai tuicha vaeño oyapo reta. Echa jeta joco pe ñogüɨnoi vae reta mbaeti oicuaa maera ra oñemboatɨ joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jayave judío reta omoaña jenonde Alejandro jee vae yatɨ vae reta ipɨte güi, iñee omoe vaera. Jayave Alejandro omopúa ipo omoquirii vaera tei. Echa oipota tei imiari tenta pegua reta pe, agüɨye vaera jae reta omboeco judío reta. ");
INSERT INTO guiNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Erei yatɨ vae reta oicuaa yave jae co judío, opaete metei rami mócoi ora seri iñeeata reve jei: —Oñemboete yae co Diana Efeso pegua. ");
INSERT INTO guiNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jayave tenta pegua reta juvicha omoquirii yatɨ vae reta, jare jei chupe reta: —Cuimbae Efeso pegua reta. Diana co jae tumpa cuña oñemboete yae vae. Cuae tenta pegua reta oñangareco Diana itupao re. Jare oñangareco vi ita Diana echa vae Júpiter güi ou vae re. Opaete vae oicuaa cuae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jayave mbaeti quia ipuere cuae oicuacu rambue, icavi co pequirii vaera, agüɨye vaera mbae peyapo peñemongueta mbae reve. ");
INSERT INTO guiNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Echa peru cuae cuimbae reta cuae pe, yepe tei mbaeti mbae oñomi ñandetupao güi, jare mbaeti vi jei mbae icavi mbae vae ñanetumpa cuña cotɨ —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio jare imborɨa reta oipota yave oñeapo quia re, oime mburuvicha reta ñogüɨnoi oyeapɨsaca vaera jese reta. ");
INSERT INTO guiNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Erei peipota yave peñeapo iru mbae re, mburuvicha reta oyapocavita, oñemboatɨ yave —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Echa güɨramoi mburuvicha reta ñanemboecota yayapo vae re. Oñemongueta teita yaipota ñañoraro jae reta ndive. Echa mbaetita yaicuaa mbae ra yaeta chupe reta, jae reta oparandu ñandeve yave maera ra yayapo cuae tecorai —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Jare tenta pegua reta juvicha cuae jei güire, opa omondo yatɨ vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Opa ma tecorai yave, Pablo oeni oporogüɨrovia vae reta. Jayave opa omboaracuaa reta yave, oicuava jare ojo chugüi reta Macedonia cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Jare oguata opaete jocuae tenta reta rupi omboaracuaa cavi reve oporogüɨrovia vae reta. Jayave ojo ovae ɨvɨ Grecia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Jare opɨta joco pe mboapɨ yasɨ. Jare ɨ guasu rupi ojota yave joco güi Siria cotɨ, judío reta oñomboemboe oyapo vaera icavi mbae vae chupe. Jae rambue Pablo jei ojota Macedonia rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jare yogüɨraja jae jupíe Sópater Berea pegua, Aristarco jare Segundo Tesalónica pegua reta, Gayo Derbe pegua, Timoteo, jare Tíquico jare Trófimo Asia pegua reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Cuae reta yogüɨraja orerenonde, jare oreraro Troas pe. ");
INSERT INTO guiNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Erei arete mbɨyape ovu mbae vae pegua oasa yave, ore rojo ɨ guasu rupi Filipos güi, jare cinco ara pe rojo rovae Troas pe. Joco pe roñovae iru reta ndive, jare ropɨta joco pe siete ara. ");
INSERT INTO guiNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jare semana iara tenondegua vae pe oporogüɨrovia vae reta oñemboatɨ tembíu omboyao vaera oyoupe. Jayave Pablo pɨareve pe ojota rambue, ipɨare catu imiari chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jare jeta tembipe ñogüɨnoi jocuae o ɨvate vae pe yatɨ ñogüɨnoia pe. ");
INSERT INTO guiNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jare jocuae o co mboapɨa ɨvate. Jare metei cunumi Eutico jee vae oguapɨ oi ventana pe, jare tanta oque oi. Jare Pablo jecuae imiari oi rambueve, cunumi oque oi rambue, oa joco güi icatu cotɨ ɨvɨ pe. Jare iru vae reta yogüɨraja oupi yave, oecha omano ma. ");
INSERT INTO guiNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Jayave Pablo ogüeyɨ jare oñaɨvɨ cunumi iárambue. Jayave oicuava jare jei: —Agüɨye pepɨatɨtɨ. Oicoveño co oi. ");
INSERT INTO guiNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jayave Pablo oyeupi ye, jare joco pe ñogüɨnoi vae reta omboyao oyoupe tembíu, jare ocaru reta. Jayave Pablo icoe imiari. Jayave ojo chugüi reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jare joco pe yatɨ vae reta güɨraja cunumi oicove ye vae, jare ipɨacatu yae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jare ore rani rojo roasa ɨ guasu rupi tenta Asón pe. Roipota roñovae Pablo ndive joco pe, jae jei rami. Echa jae oipota ojo ɨvɨ rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Jare roñovae yave jae ndive Asón pe, Pablo oyeupi buque pe, jare rojo pave ɨvɨ Mitilene pe. ");
INSERT INTO guiNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Jare joco güi rojo ye ɨ guasu rupi, jare pɨareve pe rojo rovae ɨvɨ Quío jóvai. Pɨareve pe rojo rovae ɨvɨ Samos pe. Jayave ropɨta ɨvɨ Trogilio pe, jare pɨareve pe rojo rovae tenta Mileto pe. ");
INSERT INTO guiNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo iquɨreɨ oasa güɨrae Efeso güi, agüɨye vaera oñemboavai Asia pe. Echa jae iñangueco yae oi vaera Jerusalén pe Pentecostés iara pe, ipuere yave. ");
INSERT INTO guiNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Jayave Mileto güi Pablo omondo Efeso pe oeniuca oporogüɨrovia vae reta itenondegua reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Jare jae reta yogüeru ovae yave Pablo oia pe, jae jei chupe reta: —Pe reta peicuaa catu co quirai aico pe reta ndive tenonde ete Asia pe ayu güive. ");
INSERT INTO guiNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayeócuai ñandeYa pe añemomichi reve jare ayaeo reve. Judío reta chemboavai yae. Echa jecuaeño iquɨreɨ reta oyapo icavi mbae vae cheve —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mbaeti aipoɨu amombeu vaera peve opaete icavi pevegua vae. Jare pomboe jeta vae ipɨte pe jare pero rupi vi. ");
INSERT INTO guiNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jare amombeu judío reta jare judío mbae vae reta pe oeya vaera iñemongueta icavi mbae vae ipɨa pe oi vae jare oyerova vaera Tumpa cotɨ, jare güɨrovia vaera ñandeYa Jesucristo re —jei chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Jare añave aja Jerusalén cotɨ, metei tembipɨɨ oyereraja rami. Jare mbaeti aicuaa mbae ra oyeapota cheve joco pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Erei tenta ñavo pe Espíritu Santo omombeu cheve iru vae reta cheñonota co tembipɨɨrɨru pe jare aiporarata. ");
INSERT INTO guiNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Erei mbaeti aquɨye. Mbaeti etei añemongueta ayeepɨ vaera. Jaeño aipota amboapɨ cheguata Tumpa cotɨ vae ayerovia reve. Aipota ayapo mbaravɨquɨ ñandeYa Jesús omee cheve vae. Echa jecuaeño aipota amombeu iru vae reta pe ñee icavi vae Tumpa ipɨacavi regua —jei Pablo chupe reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Amombeu ma pepɨte rupi Tumpa iporoocuaia regua, jare añave aicuaa catu co pe reta ngaraa ma cherecha ye. ");
INSERT INTO guiNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jae rambue añave amombeu peve che mbaeti etei co anoi teco pecotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Echa mbaeti etei aipoɨu amombeu vaera peve opaete Tumpa jei vae. ");
INSERT INTO guiNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jae rambue peñeandu, jare peñangareco opaete oporogüɨrovia vae reta re, metei vecha reta iñangarecoa vecha reta re oñangareco rami. Echa Espíritu Santo co peparavo peñangareco vaera jese reta. Jare pemombeu Tumpa iñee ñandeYa re güɨrovia vae reta pe, metei vecha reta iñangarecoa vecha reta omongaru rami. Echa ñandeYa oepɨ reta jae jugüɨ ae pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Che aicuaa catu co che aja ma yave, yogüeruta pepɨte pe iru vae reta. Cuae reta oyapota icavi mbae vae oporogüɨrovia vae reta pe, aguarañaɨmba jou vecha reta rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Jare pepɨte güi etei oimeta cuimbae moromboe pochɨi vae re oporomboeta vae reta. Cuae reta güɨrajata jae reta ndive oporogüɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jae rambue peñeandu, jare pemaendúa quirai cheyaeo reve pomboaracuaa vae re. Mboapɨ año ma jocorai ayapo, ara rupi jare pɨtu rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Añave ayerure Tumpa pe oñangareco vaera peré, jare aeya pe reta ndive iñee ipɨacavi regua. Echa cuae ñee ipuere pemomɨrata jare omee peve pembaera opaete jocuae iru oñeñono tee Tumpa peguara vae reta ndive —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mbaeti aipota anoi iru vae icorepoti, ioro, jare jemimonde. ");
INSERT INTO guiNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Pe reta peicuaa catu co quirai chepo pe etei aparavɨquɨ, mbaembae oata cheve vae anoi vaera, jare amee vaera cheiru reta pe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Opaete rupi aicuauca ma peve quirai icavi co yaparavɨquɨ vaera, ñamborɨ vaera mbae oata chupe vae reta. Ñanemaendúa ñandeYa Jesús etei jei vae re. Echa jae jei: Tumpa omboyerovia yaeta mbae omeeiño vae mbae omboresive vae güi —jei, jei Pablo. ");
INSERT INTO guiNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Jare cuae opa ma jei yave, Pablo oyeatɨca jare oyerure Tumpa pe opaete jae reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jayave opaete joco pe ñogüɨnoi vae reta oyaeo, jare oicuava reta Pablo jare oiyurupɨte reta. ");
INSERT INTO guiNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jare jae reta ipɨatɨtɨ yae, Pablo jei chupe reta ngaraa ma oecha ye rambue. Jayave jae reta yogüɨraja jae jupíe buque pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jare rojo ma yave chugüi reta, roasa isɨmbi ɨ guasu rupi tenta Cos pe. Jare pɨareve pe roasa tenta Rodas pe. Jayave joco güi roasa tenta Pátara pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Jare rovae joco pe buque ojota Fenicia pe vae. Jayave royeupi pɨpe, jare rojo. ");
INSERT INTO guiNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Jare Chipre roecha oreasu cotɨ, jare roasa. Jare jecuae rojo Siria cotɨ, jare rojo rovae tenta Tiro pe. Echa joco pe buque oeyata ivoɨta. ");
INSERT INTO guiNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jare roñovae oporogüɨrovia vae joco pegua reta ndive, jare ropɨta joco pe siete ara. Jare jae reta Espíritu Santo rupi jei Pablo pe agüɨye vaera ojo Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jocuae ara reta oasa yave, rojo tenta güi, jare opaete oporogüɨrovia vae reta jembireco reta jare imichia reta ndive oremoiru. Jayave royeatɨca ɨ guasu jembeɨ pe royerure Tumpa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Jayave roñocuava güire jae reta ndive, royeupi buque pe, jare jae reta yogüɨraja ye tenta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Jayave Tiro güi rojo rovae tenta Tolemaida pe. Jare joco pe royapo maraetei oporogüɨrovia vae reta pe, jare ropɨta jae reta pɨri metei ara. ");
INSERT INTO guiNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pɨareve pe rojo chugüi reta Pablo jupíe Cesarea pe, jare joco pe roique ropɨta Felipe ñee icavi vae omombeu vae jo pe. Jae co jocuae siete vae güi metei. ");
INSERT INTO guiNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Cuae cuimbae güɨnoi irundɨ tayɨ Tumpa iñee omombeu vae. Cuae irundɨ reve ndei omenda. ");
INSERT INTO guiNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Jare ropɨta joco pe mbovɨ ara. Jare Tumpa iñee omombeu vae Agabo jee vae ou Judea güi. ");
INSERT INTO guiNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jare jae ou ore roia pe, jare oequi Pablo icuacuaa. Jayave oñeapɨti ipɨ rupi jare ipo rupi jare jei: —Cuae jei Espíritu Santo: Corai Jerusalén pe judío reta oñapɨtita cuae cuacuaa iya, jare omoeterenga retata judío mbae vae reta pe —jei, jei Agabo. ");
INSERT INTO guiNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Cuae roendu yave, ore jare joco pegua reta romoñera tei Pablo agüɨye vaera ojo Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Erei Pablo jei: —¿Maera pa peyaeo jare chembopɨatɨtɨ? Echa mbaeti aipoɨu añeapɨti vaera Jerusalén pe. Mbaeti vi aipoɨu amano vaera joco pe ñandeYa Jesús jeco pegua —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jayave mbaeti ye oremiari chupe cuae re, jae mbaeti oñemaeño oreve rambue. Jayave roe: —Toyeapo ñandeYa jemimbota. ");
INSERT INTO guiNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Jare jocuae ara reta oasa yave, royupavo rojo Jerusalén cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jare yogüɨraja vi orerupíe Cesarea güi amogüe oporogüɨrovia vae joco pegua reta. Ojo vi jae reta jupíe Chipre pegua Mnasón jee vae. Echa ropɨtata Mnasón jo pe. Cuae Mnasón tenonde voi güɨrovia Jesús re. ");
INSERT INTO guiNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jare rojo rovae yave Jerusalén pe, oporogüɨrovia vae reta oremboresive oyerovia reve. ");
INSERT INTO guiNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Jayave pɨareve pe Pablo ojo ore ndive opou Jacobo pɨri. Jare opaete oporogüɨrovia vae reta itenondegua reta oñemboatɨ joco pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Jare opa ma maraetei oyapo yave, Pablo omombeu chupe reta quirai jae oparavɨquɨ judío mbae vae reta ipɨte rupi, jare quirai Tumpa jeta mbaembae oyapo chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jae reta oendu yave, omboete Tumpa. Jayave jei reta Pablo pe: —Orerɨvɨ, reicuaa ma quirai jeta yae judío reta güɨrovia ma co Jesús re, jare opaete jae reta oñemoatangatu yae mboroócuai re. ");
INSERT INTO guiNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Erei jeracua chupe reta quirai nde remboe opaete judío judío mbae vae reta ipɨte rupi ñogüɨnoi vae reta agüɨye vaera oyapo Moisés iporoócuai. Echa jeracua quirai nde rere chupe reta agüɨye vaera omocircuncidauca taɨ reta, jare agüɨye vaera oyapo ñandereco —jei reta Pablo pe—. ");
INSERT INTO guiNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Mbae pa yayapota? Oñemboatɨta co jeta vae. Echa jae reta oicuaata nde reyu ma co cuae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jae rambue eyapo cuae roeta ndeve vae. Oime cuae pe ñogüɨnoi irundɨ cuimbae tenonde yave güɨrocuavee mbae oyapota Tumpa pe vae. ");
INSERT INTO guiNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Eraja cuae cuimbae reta jare eyetɨo Tumpa cotɨ mboroócuai jei rami jae reta ndive, jare emboepɨ iñaca oñeapiuca reta vaera. Jayave opaete vae oicuaata mbaeti añete nereracua chupe reta vae. Echa jae reta oicuaata nde vi co reyapo reico mboroócuai —jei reta—. ");
INSERT INTO guiNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Erei yaicuatía ma judío mbae vae oporogüɨrovia vae reta pe agüɨye vaera oyapo mboroócuai. Jaeño agüɨye tou reta soo tumpa-raanga pe oñererocuavee vae, jare soo jugüɨ reve, jare maemɨmba oyeyuvɨ vae isoo, jare agüɨye toyapo aguasa —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Jayave Pablo ojo jocuae cuimbae reta jupíe, jare pɨareve pe oyetɨo Tumpa cotɨ mboroócuai jei rami jae reta ndive, jare oique Tumpa jo pe omombeu mbae ara pe opata oyetɨo. Echa jocuae ara metei ñavo omeeta mbota. ");
INSERT INTO guiNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jare cuae güire siete ara opata ma yave, judío Asia pegua reta oecha Pablo Tumpa jo pe, jare oyapo reta tecorai jeta vae ndive. Jayave oipɨɨ reta Pablo, ");
INSERT INTO guiNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","jare iñeeata reve jei: —Cuimbae Israel pegua reta, oremborɨ. Cuae cuimbae oporomboe opaete que rupi opaete iru vae reta oyovaicho vaera ñande ndive, mboroócuai ndive, jare cuae Tumpa jo ndive. Jare jae güeru griego reta güɨroique Tumpa jo pe, jare jocorai omonguɨauca cuae o Tumpa oi pɨpe vae —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Echa tenonde yave oecha reta tenta pe Efeso pegua Trófimo jee vae Pablo ndive. Jare oñemongueta tei Pablo güɨroique jocuae cuimbae Tumpa jo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jare opaete tenta pegua reta pochɨ. Jae rambue oñemboatɨ reta, jare oipɨɨ reta Pablo ombotɨrɨrɨ Tumpa jo güi icatu pe. Jare jupiveiño Tumpa jo iñangarecoa reta oñoquenda onque reta. ");
INSERT INTO guiNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Jayave yatɨ vae reta oipota tei oyuca Pablo. Erei jeracua sundaro reta juvicha pe opaete Jerusalén pegua reta oyapo ñogüɨnoi tecorai. ");
INSERT INTO guiNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Jare jupiveiño jae osɨi ou yatɨ vae reta cotɨ sundaro reta jare cien sundaro vae juvicha reta ndive. Jare tenta pegua reta oecha yave sundaro reta jare juvicha, mbaeti ma ocua Pablo re. ");
INSERT INTO guiNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Jayave sundaro reta juvicha ojo Pablo cotɨ jare oipɨɨ. Oyócuai sundaro reta oñapɨti vaera mócoi cadena pe. Jayave oparandu quia ra co jae jare mbae ra co oyapo. ");
INSERT INTO guiNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Amogüe tenta pegua reta iñeeata, erei mbaeti oyovaque iñee reta. Jare tecorai jeco pegua sundaro reta juvicha mbaeti ipuere oicuaa mbae ra añete vae. Jae rambue oyócuai sundaro reta güɨraja vaera Pablo jae reta yogüɨrecoa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Jare oyeupi ñogüɨnoi yave sundaro reta yogüɨrecoa pe, sundaro reta ovoɨ güɨraja Pablo, yatɨ vae reta oipota oipɨɨ rambue. ");
INSERT INTO guiNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Echa opaete yatɨ vae reta yogüɨraja sundaro reta jaɨcue, jare iñeeata reve jei: —Tomano jocuae cuimbae. ");
INSERT INTO guiNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jare sundaro reta güɨroiqueta ma yave yogüɨrecoa pe, Pablo jei sundaro reta juvicha pe: —¿Remaeñota pa mbae jae ndeve? Jae jei Pablo pe: —¿Reicuaa pa griego iñee? ");
INSERT INTO guiNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Carambué yave metei Egipto pegua omboemboe cuatro mil oporoyuca vae reta oñoraro vaera mburuvicha reta ndive, jare güɨraja ñuu pe. ¿Nde pa co jae jocuae Egipto pegua? —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Jayave Pablo jei chupe: —Che co jae metei judío Tarso pegua. Jocuae tenta oi Cilicia pe, jare tuicha co. Emaeño tachemiari tenta pegua reta pe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jayave sundaro reta juvicha jei Pablo pe imiari vaera. Jayave Pablo oñemboɨ oyeupi oia pe, jare omopúa ipo tenta pegua reta cotɨ. Jare opaete vae quirii yave, Pablo imiari chupe reta hebreo iñee pe. Jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Cherɨvɨ reta jare cherɨqueɨ reta, peyeapɨsaca che jaeta peve cheyee vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jare tenta pegua reta oendu yave jae imiari chupe reta hebreo iñee pe, opareve quirii ngatu. Jayave Pablo jei chupe reta: ");
INSERT INTO guiNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Che co jae metei judío. Aa Tarso Cilicia pegua pe, erei acuacuaa cuae tenta pe. Gamaliel chemboe cavi ñanetenondegua reta iporoócuai re. Che aipota yae ayapo Tumpa jeigüe, opaete pe reta añave peipota rami —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Che ayapo icavi mbae vae opaete Jesús re güɨrovia reve yogüɨreco vae reta pe. Jare aipɨɨ amoingueuca tembipɨɨrɨru pe cuimbae reta jare cuña reta. Ayucauca vi amogüe vae —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sacerdote tenondegua jare opaete tenta pegua reta itenondegua reta ipuere omombeu peve cheregua. Jae reta oicuatía omee cheve tupapire araja vaera iru judío reta pe. Jayave aja Damasco cotɨ, aipɨɨ vaera tei Jesús re güɨrovia vae joco pe ñogüɨnoi vae reta, jare aru vaera tei Jerusalén pe, aiporarauca vaera tei chupe reta —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Erei che coiño ma Damasco güi aja yave, cuaraɨ ara mbɨte rupi yave, güɨramoiño metei tembipe tuicha vae ara güi oesape cheré. ");
INSERT INTO guiNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Jare aa ɨvɨ re, jare aendu metei ñee jei cheve: Saulo, Saulo, ¿maera pa reyapo icavi mbae vae cheve? ");
INSERT INTO guiNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Jayave che jae: ¿Quia pa co nde, cheYa? Jayave jae jei cheve: Che co jae Jesús Nazaret pegua. Nde reyapo icavi mbae vae cheve —jei, jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Jare che ndive ñogüɨnoi vae reta oecha co tembipe, jare oquɨye reta. Erei mbaeti oendu mbae jei jocuae imiari cheve vae. ");
INSERT INTO guiNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Jayave che aparandu: ¿Mbae pa ayapota, cheYa? Jare ñandeYa jei cheve: Epúa ecua Damasco pe, jare joco pe amombeucata ndeve opaete mbae roocuaita jese vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Jayave che ndive ñogüɨnoi vae reta chepoco chereraja chererovae Damasco pe. Echa mbaeti etei chepuere amae, jocuae tembipe oesape yae cheré vae jeco pegua —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Jare oico joco pe metei cuimbae Ananías jee vae. Jae omboete Tumpa mboroócuai oyapo reve, jare opaete judío joco pe yogüɨreco vae reta imiari cavi jese. ");
INSERT INTO guiNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jae ou chepɨri. Oñemboɨ cheɨque pe jare jei: Saulo, nde co jae cherɨvɨ. Emae ye. Jare jupiveiño chepuere amae, jare aecha Ananías joco pe oi —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Jayave jae jei cheve: Ñanetenondegua reta iTumpa ndeparavo, reicuaa vaera jae jemimbota, jare reecha vaera jocuae jupi vae, jare reendu vaera iñee. ");
INSERT INTO guiNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Echa remombeuta co jesegua opaete ɨvɨ pegua reta pe. Remombeuta chupe reta reecha jare reendu vae —jei, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","¿Maera pa añave rearo rei? Epúa eñembobautizauca reyerure reve chupe, nembaeyoa reta oñemboai vaera —jei, jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jayave ayu ye Jerusalén pe, jare ayerure ai rambueve Tumpa jo pe, chequera. ");
INSERT INTO guiNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jare aecha Jesús, jare jae jei cheve: Neangueco ecua ɨmambae Jerusalén güi. Echa ngaraa oipota güɨrovia nde remombeuta cheregua chupe reta vae —jei cheve, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Jayave che jae chupe: CheYa, jae reta oicuaa catu co quirai che ajase opaete judío reta itupao reta rupi añonouca vaera tembipɨɨrɨru pe jare ainupauca vaera nderé güɨrovia vae reta. ");
INSERT INTO guiNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Jare oyuca reta yave Esteban nderegua omombeu vae, che vi ai joco pe, jare icavi cheve imano. Jare che añangareco oyuca vae reta jemimonde re —jae chupe, jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Jayave jae jei cheve: Ecua. Echa che romondota mombɨrɨ judío mbae vae reta cotɨ —jei cheve, jei. ");
INSERT INTO guiNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jare Pablo cuae jei yave, tenta pegua reta mbaeti ma oipota oyeapɨsaca jese. Iñeeata reve jei reta: —Tomano jocuae cuimbae. Echa mbaeti icavi oico vaera —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jare iñeeata reta rambueve, ombovava jemimonde, jare ɨvɨcúi omombo ɨvate. ");
INSERT INTO guiNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jayave sundaro reta juvicha oyócuai sundaro reta güɨroique vaera Pablo jae reta yogüɨrecoa pe. Jare oyócuai vi oinupa reta vaera chicote pe oparandu chupe reve, oicuaa cavi vaera maera ra tenta pegua reta iñeeata jocorai icotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Erei sundaro reta oñapɨti yave tɨmasa pe, Pablo jei cien sundaro vae juvicha joco pe oi vae pe: —¿Jupi pa peinupa vaera metei romano mbaeti pejaa reve? ");
INSERT INTO guiNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cuae oendu yave, cien sundaro vae juvicha ojo sundaro reta juvicha pe jare jei chupe: —¿Mbae pa reyapota? Echa jocuae cuimbae metei romano co. ");
INSERT INTO guiNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jayave sundaro reta juvicha ou Pablo oia pe jare jei chupe: —Emombeu cheve, ¿Romano pa co nde? Jayave Pablo jei chupe: —Jae co. ");
INSERT INTO guiNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jayave sundaro reta juvicha jei ye chupe: —Che jeta yae amboepɨ ayeapo vaera romanora. Jayave Pablo jei chupe: —Erei che pɨpe voi aa. ");
INSERT INTO guiNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Jayave yogüɨraja Pablo güi oparanduta tei chupe vae reta. Jare sundaro reta juvicha vi oquɨye, oicuaa yave jae romano co, oñapɨtiuca rambue. ");
INSERT INTO guiNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jare pɨareve pe sundaro reta juvicha oipota oicuaa cavi mbae re ra judío reta omboeco Pablo. Jae rambue oyora Pablo, jare oyócuai sacerdote reta itenondegua reta jare opaete iru mburuvicha reta oñemboatɨ vaera. Jayave güɨraja Pablo oñono jae reta jóvai. ");
INSERT INTO guiNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Jayave Pablo omae ngatu mburuvicha reta re jare jei: —Cherɨqueɨ reta, che jecuaeño aico cavi, chepɨa icavi anoi vaera Tumpa cotɨ. ");
INSERT INTO guiNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Jayave sacerdote tenondegua Ananías jee vae oyócuai Pablo iyɨpɨ pe ñogüɨnoi vae reta ocua vaera iyuru re. ");
INSERT INTO guiNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Jayave Pablo jei chupe: —Tumpa tocua nderé. Echa nde co jae ovapetea ti vae rami. Nde reguapɨ co rei chejaa vaera mboroócuai jei vae rupi. Erei reyavɨ mboroócuai. Echa reyócuai reta ocua vaera cheré —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Jayave joco pe ñogüɨnoi vae reta jei chupe: —¿Maera pa nde rere ñee icavi mbae vae Tumpa isacerdote tenondegua pe? ");
INSERT INTO guiNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Jayave Pablo jei: —Cherɨqueɨ reta, mbaeti aicuaa jae co sacerdote tenondegua. Echa oyecuatía oi: “Mbaetita rere ñee icavi mbae vae nderuvicha cotɨ” —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jare Pablo oecha yave amogüe jae reta saduceo reta jare amogüe fariseo reta, iñeeata reve jei mburuvicha reta ipɨte pe: —Cherɨqueɨ reta, che co jae metei fariseo, jare cheru vi co jae metei fariseo. Che arovia omanogüe vae reta oicove yeta co. Cuae jeco pegua pe reta chejaa pei —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Jare cuae jei yave, oñemboyao oyougüi yatɨ vae reta, jare fariseo reta oyoaca saduceo reta ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Echa saduceo reta jei omanogüe vae reta ngaraa ma oicove ye. Jei vi mbaeti co oi araɨgua jare espíritu. Erei fariseo reta güɨrovia oime co. ");
INSERT INTO guiNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Jare oyoaca reta oyoupi. Jare opúa amogüe fariseo pegua mboroócuai re oporomboe vae reta jare jei: —Mbaeti etei ore rovae teco cuae cuimbae re. Güɨramoi metei espíritu ani araɨgua imiari chupe. Agüɨye yayovaicho Tumpa ndive —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Jare jeiete oyoaca reta oyoupi yave, sundaro reta juvicha oñemongueta güɨramoi oyuca retata Pablo, jare oyócuai sundaro reta yogüeru vaera güɨraja Pablo jae reta ipɨte güi sundaro reta yogüɨrecoa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jare pɨareve pe pɨtu yave ñandeYa oyecuaa Pablo pe jare jei chupe: —Eñemoatangatu, Pablo. Chemombeu ma Jerusalén pe. Chemombeuta co Roma pe vi. ");
INSERT INTO guiNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Jayave pɨareve pe amogüe judío reta oñomboemboe, jare oyepopeyu reve iyee jei mbaetita ocaru jare oɨu, oyuca regua Pablo. ");
INSERT INTO guiNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jare cuimbae cuae jei oyepopeyu reve iyee vae reta cuarenta oasa. ");
INSERT INTO guiNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Jayave jae reta yogüɨraja sacerdote reta itenondegua reta jare tenta pegua reta itenondegua reta pe jare jei chupe reta: —Ore roe ma royepopeyu reve oreyee mbaetita rocaru, royuca regua Pablo. ");
INSERT INTO guiNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jae rambue pe reta iru mburuvicha reta ndive pemombeu sundaro reta juvicha pe togüeru Pablo peve pɨareve. Jae oñemongueta teita pe reta peipota peparandu cavi ete chupe mbae oyapo vae re. Jayave ore rocatɨrota roi jese royuca vaera, ndei ou ovae mbove —jei reta. ");
INSERT INTO guiNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Erei Pablo jeindɨ imembɨ cuimbae oicuaa yave jae reta ocatɨrota Pablo re, ojo oique sundaro reta yogüɨrecoa pe, jare omombeu Pablo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Jayave Pablo oeni metei cien sundaro vae juvicha jare jei chupe: —Eraja cuae cunumi nderuvicha pɨri. Echa oipota mbae omombeu chupe —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jayave cien sundaro vae juvicha güɨraja cunumi juvicha pɨri, jare jei chupe: —Pablo oyepɨɨ oi vae chereni, jare chemoñera aru vaera ndepɨri cuae cunumi. Echa oipota mbae omombeu ndeve —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jayave sundaro reta juvicha oipɨɨ cunumi ipo pe, jare güɨraja iru vae reta ñogüɨnoia güi. Jayave oparandu chupe: —¿Mbae pa remombeuta cheve? ");
INSERT INTO guiNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Jayave cunumi jei chupe: —Judío reta oñomboemboe ma, jare nemoñerata Pablo rerajauca vaera pɨareve mburuvicha reta pe. Oipota nde reñemongueta tei vaera jae reta oparandu cavi eteta chupe mbae oyapo vae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Erei agüɨye erovia. Echa judío reta ocatɨrota jese. Jae reta cuarenta oasa. Jei reta oyepopeyu reve iyee mbaetita ocaru jare oɨu, oyuca regua Pablo. Jare añave oaro ñogüɨnoi, güɨramoi rerajauca pegua —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jayave sundaro reta juvicha jei cunumi pe: —Agüɨye emombeu quia pe cuae remombeu cheve vae. Jayave omondo cunumi. ");
INSERT INTO guiNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Jayave sundaro reta juvicha oeni mócoi cien sundaro vae juvicha jare jei chupe reta: —Pemboyupavo doscientos sundaro reta, jare setenta sundaro cavayu re opo vae reta, jare doscientos sundaro mi güɨraja vae reta, yogüɨraja vaera Cesarea pe mboapɨ ora ma pɨtu yave. ");
INSERT INTO guiNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Jare peeca Pablo opoara, peraja cavi vaera mburuvicha guasu Félix pɨri —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jayave jae oicuatía metei tupapire pe corai: ");
INSERT INTO guiNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Félix. Nde co jae mburuvicha guasu oñemboeteuca vae. Che co jae Claudio Lisias. Amondo tamaraeme ndeve. ");
INSERT INTO guiNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judío reta oipɨɨ cuae cuimbae, jare oyucata tei. Jayave che aja sundaro reta ndive aepɨ chugüi reta. Echa jeracua cheve jae romano co. ");
INSERT INTO guiNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jare aipota aicuaa maera ra jae reta omboeco. Jae rambue araja judío reta juvicha reta yatɨa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Joco pe aicuaa jae reta omboeco iporoócuai re. Erei jae mbaeti oyapo teco omano vaera ani oi vaera tembipɨɨrɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Erei jeracua cheve judío reta ocatɨrota jese. Jae rambue jupiveiño amondo ndecotɨ. Jare ayócuai omboeco vae reta oñeapo vaera jese ndeve teco oyapo chupe reta vae re. Jaeño ma. Jocorai oicuatía. ");
INSERT INTO guiNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Jayave pɨtu yave sundaro reta güɨraja Pablo tenta Antípatris pe, juvicha oyócuai rami. ");
INSERT INTO guiNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Jayave pɨareve pe sundaro cavayu re opo vae reta güɨraja Pablo, jare iru sundaro reta yogüeru ye yogüɨrecoa pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Jare yogüɨraja ovae yave Cesarea pe, sundaro reta omoeterenga Pablo tupapire reve mburuvicha guasu pe. ");
INSERT INTO guiNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Jare opa omongueta yave tupapire, mburuvicha guasu oparandu Pablo pe quia tenta pegua ra jae. Jare oicuaa yave Cilicia pegua co, ");
INSERT INTO guiNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","jei Pablo pe: —Tayeapɨsaca nderé, yogüeru yave nemboeco vae reta. Jayave oyócuai sundaro reta oñangareco vaera jese Herodes jo tuicha vae pe. ");
INSERT INTO guiNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco ara ma oasa yave, yogüeru sacerdote tenondegua Ananías, amogüe tenta pegua reta itenondegua reta, jare metei cuimbae Tértulo jee vae. Cuae cuimbae iyaracuaa catu imiari vaera. Jae reta oñeapo Pablo re mburuvicha pe. ");
INSERT INTO guiNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Jare Pablo oñeeni ma yave, Tértulo omboɨpɨ omboeco Pablo. Jae jei Félix pe: —Ndereco pegua orepɨacatu roico. Ndearacuaa jeco pegua reporoócuai cavi jeta mbaembae re orerenta pe. ");
INSERT INTO guiNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nde co jae oreruvicha romboete vae. Opaete que rupi jecuaeño royapo yasoropai ndeve opaete cuae re —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ndepɨacavi rambue, romoñera reyeapɨsaca vaera oreñee re michi peguaño, agüɨye vaera romambeco mbatee —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Echa roicuaa ma cuae cuimbae oporomboavai metei mbaerasɨ rami. Jae omboemboe judío opaete ɨvɨ ñogüɨnoi vae reta. Jare jae co metei Nazareno pegua reta itenondegua —jei Tértulo Félix pe—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Jae oipota vi oyapo jupi mbae vae Tumpa jo pe. Erei ore roipɨɨ, jare rojaata tei oreporoócuai pe oyecuatía oi vae rupi. ");
INSERT INTO guiNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Erei sundaro reta juvicha Lisias ou omoata oregüi orenupa reve. ");
INSERT INTO guiNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jare oyócuai omboeco vae reta yogüeru vaera ndepɨri. Nde etei rejaa yave, reicuaata opaete romboeco vae —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Judío reta vi jei añete co opaete cuae mbaembae. ");
INSERT INTO guiNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Jayave mburuvicha guasu opovee Pablo re imiari vaera. Jayave Pablo jei: —Che aicuaa catu co nde ɨma yae ma rejaa cuae cherenta pegua reta. Jae rambue ayerovia reve chemiarita ayeepɨ vaera —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nde ndepuere reicuaa rami, doce ara ramo aja güire Jerusalén pe, amboete vaera Tumpa. ");
INSERT INTO guiNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jare cuae reta mbaeti cherecha ayoaca quia ndive, ani amboemboe tenta pegua reta Tumpa jo pe, ani itupao reta pe, ani tenta rupi —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Añete chemboeco ma cuae mbaembae re. Erei mbaeti mbae añete vae ipuere omombeu ndeve cuae mbaembae re —jei Pablo—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Erei cuae amombeu ndeve. Che aico Jesús re arovia reve, jare jocorai ayeócuai chetenondegua reta iTumpa pe, yepe tei judío reta jei aico metei moromboe mbaeti añete vae re. Echa che arovia opaete mboroócuai pe oyecuatía oi vae, jare Tumpa iñee aracae omombeu vae reta oicuatiagüe —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Che arovia Tumpa omoingove yeta co omanogüe vae reta. Jae omoingoveta jupi vae reta jare jupi mbae vae reta. Jocuae cuae reta vi güɨrovia. ");
INSERT INTO guiNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jae rambue che jecuaeño aipota chepɨa icavi anoi vaera Tumpa cotɨ jare ɨvɨ pegua reta cotɨ —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Che mbovɨ año ma mbaeti aico cherenta pe. Jaeramo ayu ye, mbota reta aru vaera paravete vae reta peguara jare Tumpa peguara. ");
INSERT INTO guiNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Jare cuae ayapo ai rambueve, amogüe Asia pegua judío reta cherecha Tumpa jo pe. Joco pe ayetɨo ai Tumpa cotɨ mboroócuai jei rami. Mbaeti co añemboatɨ jeta vae ndive. Mbaeti vi tecorai ayapo —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Icavi tei co jocuae judío reta yogüeru vaera cuae pe oñeapo ndeve cheré, oime yave mbae chemboeco jese vae —jei Pablo Félix pe—. ");
INSERT INTO guiNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Cuae reta etei tomombeu ndeve mbae nunga teco ovae cheré, mburuvicha reta jóvai añemboɨ yave. ");
INSERT INTO guiNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Güɨramoi jaeño metei mbae re ipuere chemboeco. Mburuvicha reta ipɨte pe ai rambueve, cheñeeata reve jae: Omanogüe vae reta oicove yeta vae re pe reta chejaa pei cuae ara. Jocorai jae —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jare Félix cuae oendu yave, oyopia judío reta. Echa jae oicuaa catu Jesús re güɨrovia vae reta iporogüɨrovia regua. Jae rambue jei judío reta pe: —Sundaro reta juvicha Lisias ou yave, ajaata cuae pemombeu cheve vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jayave Félix oyócuai cien sundaro vae juvicha oñangareco vaera Pablo re. Erei oyócuai vi omaeño vaera oicoiño, jare agüɨye vaera oyopia jentara reta, ou yave ipɨri oyeócuai chupe vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mbovɨ ara rupi Félix ou jembireco Drusila jee vae ndive. Drusila co jae metei judía. Jayave Félix oeni Pablo, jare oyeapɨsaca quirai yaroviata co Jesucristo re vae re. ");
INSERT INTO guiNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Jare Pablo jei chupe quirai icavi yayapo vaera jupi vae, jare yayeopia vaera ñanderete oipota vae güi, jare quirai Tumpa ojaata ɨvɨ pegua reta. Jayave Félix oquɨye jare jei Pablo pe: —Ecuaño rani. Chepuere yave, toroeni ye curi. ");
INSERT INTO guiNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Erei Félix oipota tei vi Pablo omee vaera corepoti chupe, oyorauca vaera. Jae rambue güeruruca aveiño, imiari vaera jae ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Erei mócoi año ma oasa yave, Porcio Festo ou oipoepɨ Félix. Jare Félix oipota omboyerovia judío reta rambue, oeya Pablo tembipɨɨrɨru pe. ");
INSERT INTO guiNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo ou ovae yave jocuae ɨvɨ pe, mboapɨ ara ma oasa yave, ojo Cesarea güi Jerusalén pe. ");
INSERT INTO guiNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Jayave sacerdote reta itenondegua reta jare judío reta itenondegua reta imiari chupe Pablo jeco re, jare omoñera ");
INSERT INTO guiNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","oyapo vaera icavi vae chupe reta, güeruruca vaera Pablo Jerusalén pe. Jare jae reta ocatɨrota jese tape rupi, oyuca vaera. ");
INSERT INTO guiNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Erei Festo jei chupe reta: —Ore roñangareco roi Pablo re Cesarea pe, jare che ajaata joco pe curi. ");
INSERT INTO guiNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pepuere yave, pecua cherupíe. Jare oyapo yave teco icavi mbae vae jocuae cuimbae, peñeapo jese —jei chupe reta. ");
INSERT INTO guiNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jayave Festo opɨta güire joco pe güɨramoi ocho ani diez ara, ou ye Cesarea pe. Jayave pɨareve pe oguapɨ oporojaaa pe, jare güeruruca Pablo. ");
INSERT INTO guiNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Jare Pablo ou ma yave, judío Jerusalén güi yogüeru vae reta oñemboɨ Pablo iyɨvɨ rupi jare omboeco jeta icavi mbae vae re. Erei mbaeti ipuere oicuauca cuae teco oipota omboya jese vae añete co. ");
INSERT INTO guiNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Jayave Pablo jei oyeepɨ vaera: —Mbaeti etei ayovaicho judío reta iporoócuai ndive, ani Tumpa jo ndive, ani César ndive. ");
INSERT INTO guiNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Erei Festo oipota omboyerovia judío reta. Jae rambue oparandu Pablo pe: —¿Reipota pa reo Jerusalén pe, che rojaa vaera joco pe cuae teco reta re? ");
INSERT INTO guiNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Erei Pablo jei chupe: —César ndeócuai reporojaa vaera, jare icavi co nde chejaa vaera cuae pe. Mbaeti etei teco ayapo judío reta cotɨ. Nde etei reicuaa cuae —jei—. ");
INSERT INTO guiNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Oime yave teco ayapo icotɨ, ani oime yave mbae ayapo amano vaera, ngaraa ayerure ndeve ayeepɨ vaera mano güi. Erei cuae teco oipota omboya cheré vae mbaeti ayapo yave, ngaraa quia ipuere chemoeterenga chupe reta. Aipota César chejaa vaera —jei chupe. ");
INSERT INTO guiNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Jayave Festo imiari iru mburuvicha reta ndive. Jayave jei Pablo pe: —Reipota César nejaa vaera. César pɨri reota —jei. ");
INSERT INTO guiNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Jare mbovɨ ara ma oasa yave, mburuvicha guasu Agripa jare jeindɨ Berenice yogüeru Cesarea pe, oyapo vaera maraetei Festo pe. ");
INSERT INTO guiNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Jare jeta ara ma joco pe ñ