﻿USE sofia;
DROP TABLE IF EXISTS sofia.guh_vpl;
CREATE TABLE guh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guh_vpl WRITE;
INSERT INTO guh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mapalivaisije Jesucristo pijasalinaivimi pelivaisi. Jesucristo rabaja Davidpijinë pemomoxiyajuvënënë. Davidpijinë pijinia Abrahampijinë pemomoxiyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Copiaya Abrahampijinëmi xaina pexënato. Pevënë Isaac. Isaacpijinë juya pexënato xaina. Pevënë Jacob. Jacobpijinë juya pexi xaina. Pexiyajuvënënë pevënë Judá. Judápijinë pematapijinëbeje, pejuyapijivi ata, xaina. ");
INSERT INTO guh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judápijinë juya pexënatobeje xaina. Itsanë pevënë Fares. Itsanë Zara. Bajaraponëmibeje penapijiva pevënë Tamar. Farespijinë juya pexënato xaina. Pevënë Esrom. Esrompijinë juya pexënato xaina. Pevënë Aram. ");
INSERT INTO guh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampijinë juya pexënato xaina. Pevënë Aminadab. Aminadabpijinë juya pexënato xaina. Pevënë Naasón. Naasónpijinë juya pexënato xaina. Pevënë Salmón. ");
INSERT INTO guh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónpijinë juya pexënato xaina. Pevënë Booz. Boozpijinë penapijiva pevënë Rahab. Boozpijinë juya pexënato xaina. Pevënë Obed. Obedpijinë penapijiva pevënë Rut. Obedpijinë juya pexënato xaina. Pevënë Isaí. ");
INSERT INTO guh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaípijinë juya pexënato xaina. Pevënë David. Bajaraponëmi nacuaevetsinëmi. Davidpijinë yacajërëta Uríaspijinë pijavami. Nexata bajarapajivibeje juya pexënato xainabeje. Pevënë Salomón. ");
INSERT INTO guh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónpijinë juya pexënato xaina. Pevënë Roboam. Roboampijinë juya pexënato xaina. Pevënë Abías. Abíaspijinë juya pexënato xaina. Pevënë Asa. ");
INSERT INTO guh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapijinë juya pexënato xaina. Pevënë Josafat. Josafatpijinë juya pexënato xaina. Pevënë Joram. Jorampijinë juya pexënato xaina. Pevënë Uzías. ");
INSERT INTO guh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíaspijinë juya pexënato xaina. Pevënë Jotam. Jotampijinë juya pexënato xaina. Pevënë Acaz. Acazpijinë juya pexënato xaina. Pevënë Ezequías. ");
INSERT INTO guh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíaspijinë juya pexënato xaina. Pevënë Manasés. Manaséspijinë juya pexënato xaina. Pevënë Amón. Amónpijinë juya pexënato xaina. Pevënë Josías. ");
INSERT INTO guh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíaspijinë juya pexi xaina. Pexiyajuvënënë pevënë Jeconías. Jeconías pematapijinë, pejuyapijivi ata, xaina. Pamatacabi Israel nacuapijivi cobecëbiaya caponatsi Babilonia nacuayabelia, bajarapamatacabi naexana Jeconíaspijinë. ");
INSERT INTO guh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bajaraxuacujinae Jeconíaspijinë juya pexënato xaina. Pevënë Salatiel. Salatielpijinë juya pexënato xaina. Pevënë Zorobabel. ");
INSERT INTO guh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpijinë juya pexënato xaina. Pevënë Abiud. Abiudpijinë juya pexënato xaina. Pevënë Eliaquim. Eliaquimpijinë juya pexënato xaina. Pevënë Azor. ");
INSERT INTO guh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpijinë juya pexënato xaina. Pevënë Sadoc. Sadocpijinë juya pexënato xaina. Pevënë Aquim. Aquimpijinë juya pexënato xaina. Pevënë Eliud. ");
INSERT INTO guh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpijinë juya pexënato xaina. Pevënë Eleazar. Eleazarpijinë juya pexënato xaina. Pevënë Matán. Matánpijinë juya pexënato xaina. Pevënë Jacob. ");
INSERT INTO guh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpijinë juya pexënato xaina. Pevënë José. Bajaraponëmi María pamona. Bajarapovami Jesús pena, ponë yabara: “Cristo, ponë Dioso athëbëvetsica itorobatsi jivi pecapanepaenexa,” jaitsi. ");
INSERT INTO guh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nexata Abrahampijinëmita petaxuxuabicujinae jivi penaexanaponaejava, trecenëta naexana Davidpijinë. Bajaraxuacujinae icatsia Davidpijinëmita petaxuxuabicujinae jivi penaexanaponaejava, trecenëta icatsia naexana Jeconíaspijinë. Pamatacabi Israel nacuapijivi cobecëbiaya caponatsi Babilonia nacuayabelia, naexana Jeconíaspijinë. Bajaraxuacujinae icatsia Jeconíaspijinëmita petaxuxuabicujinae jivi penaexanaponaejava, trecenë pijavata naexana Jesucristo jane baja, ponë Dioso athëbëvetsica itoroba jivi pecapanepaenexa. ");
INSERT INTO guh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo itsa naexana mapanacuataje, naexana mapacueniaje. Copiata Josébeje Maríabeje najumejaitabeje penapitsinexabeje. Nexata baja María jejai Josébeje penapitsinexabeje. Bajaraxuacujinae penapitsivajënaeyabeje, María nayapëtane penacoxitsijava Espíritu Santo pejamatabëcueneta. ");
INSERT INTO guh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, María jane baja pamonanexa, bitso penajamatabëcuenereviabinë. Bajaraxuata José apo jitsipae daxitajivi pitabarata pevajunupaebijava María penacoxitsijava. Nexata picani José bëpënëa jamatabëjumai tsaponaponae: —Itsanëjavabelia María nacoxita. Nexata ajumejibia copatsianajë. Apo pitsinë baja tsane María tajavanexa, jamatabëjai picani bëpënëa tsaponaponae José. ");
INSERT INTO guh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pamatacabi abaxë José bajarapacuenia najamatabëxainaponapona, majitsinaebota José tsitanaitajëtatsi Dioso pitorobinëtsica, ángel. Nexata ángel jumaitsi Joséjavabelia: —José, xamë raja Davidpijinë pemomomë. Pëtsa cujunavame nepitsijava María nijavanexa. Tsipaji raja panacueto María yacotaponapona, Espíritu Santo saya pejamatabëcueneta nacoxita. ");
INSERT INTO guh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bajarapova exanaena penacuetonëyo. Vënërubianame bajarapanacuetonëyo Jesús. Tsipaji raja bajaraponë capanepaena daxita pijajivi pibisiacuene pexanaeneconimivecua. ");
INSERT INTO guh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bajarapacuenia María penacuetonëyo exanaena pecopiapatsinexa pacuenia baja cajena bajayata Diosojumepaebinëmi profetanëmi Dioso pejamatabëcueneta tajëvelia vajunupaeba. Profetanëmi bajayata tajëvelia bajarapanacuetonëyo yabara jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Petiriva apo naperabëquenatsinejeva pebijavabelia, nacoxitsiana. Exanaena penacuetonëyo. Vënërubianatsi Emanuel. “Emanuel,” pejaijume: “Dioso nacayajava,” pejaijume, jai bajayata tajëvelia profetanëmi Dioso pejamatabëcueneta, jai ángel majitsinaebota Joséjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nexata José piamajitsinaecujinae naëcota. José jumecovënëta pacuenia itorobatsi ángel. Nexata baja José pijaboyaberena María barëpata pijavanexa. ");
INSERT INTO guh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Itsiata abaxë José apo imoxoyobi pijava penamataxainaenacuetonëyo pevecuanaexanaevajënaeyatsi. Bajarapanacuetonëyo jane baja José vënëruba JESUS. ");
INSERT INTO guh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús naexana Belén tomarata, Judea nacuata peecaetomarata. Bajarapamatacabi nacuaevetsinë Herodes Judeanacua eveta. Nexata Jesús penaexanaecujinae, pebijivi, tulupu perubenaejava pecanaëcobivi, pata tajënacuajavavetsina. Pata Jerusalén tomarajavabetsina. ");
INSERT INTO guh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tulupu perubenaejava pecanaëcobivi yanijobapona jivijavabelia: —¿Detsa jota barëecatsi panacuetonëyo naexana judíovi pepo pevetsinënexa? Payapëtaniji bajaraponëyo penaexanaejava. Tsipaji baja cajena pataniji bajaraponëyo penaexanaejavata penaitajëtsituluputo. Bajarapatuluputo pataniji patajanacuatareca. Bajaraxuata paponainajë mabetsinaje patataenexa bajaraponëyo, bajaraponëyo pitabarata yaiyataeya patamatabacabëta patatonubenaenexa, jai tsaponae jivijavabelia tulupu perubenaejava pecanaëcobivi. ");
INSERT INTO guh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nexata Herodes, Judeanacua pevetsinë, vënëlivaisitane tulupu perubenaejava pecanaëcobivi bajarapacuenia pejumaitsaponaejava jivijavabelia Jesúsnëyo yabara. Nexata Herodes bitso najamatabëxaina. Daxita Jerusalén tomarata pejinavanapaevi ata bitso najamatabëxaina. ");
INSERT INTO guh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nexata Herodes junata daxita sacerdotevi penamatacaitorobivi, judíovi pecujarubivi yajava, penacaetuatsinexa Herodes pijabota. Nexata Herodes jumaitsi penacaetuatsivijavabelia: —Bajayata profetanë tajëvelia itsa vajunupaeba Cristo penaexanaejavanexa, ¿detsa jota yabara: “Bajarajota Cristo naexanaena,” jai? jai Herodes. ");
INSERT INTO guh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nexata penacaetuatsivi jumaitsi Herodesjavabelia: —Belén tomarata raja naexanaeyapaeba, Judea nacuata peecaetomarata. Bajayata baja cajena Diosojumepaebinëmi profetanëmi tajëvelia vajunupaeba bajaraponë penaexanaejavanexa Belén tomarata. Bajayata Diosojumepaebinëmi profetanëmi peyaquinaelivaisita bajaraponë penaexanaejavanexa yabara tajëvelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén tomarata naexanaena jivi pepo pevetsinënexa. Bajaraponë jane baja evetsiana Dioso pijajivi, Israel nacuapijivi. Bajaraxuata Judea nacuata penaetomaraxi, daxita tomaraxivecua, Be léntomara cajena bitso peyaiyataetomaratsi tsane, jai baja cajena mapacueniaje bajayata tajëvelia Diosojumepaebinëmi profetanëmi peyaquinaelivaisita, jai penacaetuatsivi Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bajaraxuacujinae Herodes muetsia junata tajënacuavetsina pepatsivi, tulupu perubenaejava pecanaëcobivi. Nexata Herodes jumaitsi tulupu perubenaejava pecanaëcobivijavabelia: —¿Detsa baja pajuametobeje xaina bajarapatuluputo penaitajëtsicujinae? jai. ");
INSERT INTO guh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nexata petsipaebicujinaetsi Herodes itorobalia bajarapamonae Belén tomarabelia. Herodes jumaitsi tulupu perubenaejava pecanaëcobivijavabelia: —Paponaremelia Belén tomarabelia. Xaniavaetsia pajaitsianame bajaraponëyo. Itsa pacaxitajarabianame, panevajunucaponaeremena. Nexata xanë ata nalianë tsane. Yaiyataeya tamatabacabëta tonanucaejitsianë bajaraponëyo pitabarata, jai Herodes tulupu perubenaejava pecanaëcobivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nexata jane baja tulupu perubenaejava pecanaëcobivi ponalia Belén tomarabelia. Nexata bajarapamonae namutualia penajetarubenaejavata, jemata icatsia napebeta tuluputo, patuluputo bajarapamonae tane pijanacuatareca. Nexata bajarapatuluputo bajarapamonae matacanajetarucatsi. Matapania itsajota Jesúsnëyo pena barëecatsi pematatsënëatsia, bajarapatuluputo rucojopa. ");
INSERT INTO guh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tulupu perubenaejava pecanaëcobivi itsa tane bajarapatuluputo, bitso barëya. ");
INSERT INTO guh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nexata bajarapamonae boyalia itsa joneya, tane Jesúsnëyo, pena yajava. Nexata tulupu perubenaejava pecanaëcobivi yaiyataeya pematabacabëta tonubenajunua Jesúsnëyo pitabarata. Bajaraxuacujinae pecapatsicajonixi matapana, penamatamotsijavanë pejebicajonixi. Nexata Jesúsnëyo rajuta orojavanë. Rajutanua petuxujuvijavabeje. Itsajava inciensovënëjava. Itsajava mirravënëjava. ");
INSERT INTO guh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bajaraxuacujinae tulupu perubenaejava pecanaëcobivi meravi majitsinaebota Dioso itavetatsi penaviabiyaniva nacuaevetsinë Herodesjavabelia. Nexata tulupu perubenaejava pecanaëcobivi saicaya namutua baja naviaba pijanacuayabereca. ");
INSERT INTO guh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tulupu perubenaejava pecanaëcobivi penaviabicujinae, Dioso pijaángel meravi José majitsinaebota tsitanaitajëtatsi. Nexata ángel jumaitsi Joséjavabelia: —José, nonotapunare baja. Barëponare baja penacuetonëyo, pena yajava. Barënajetabajiravare Egipto nacuayabelia. Bajarajotalia barëponaponaename. Matapania icatsia itsa catsipaebianatsi, barënaviatsiaremena. Tsipaji raja nacuaevetsinë Herodes tsiquirinëyo tsimaxërenajitsiatsi pebeyaxuabinexatsi, jai ángel Joséjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nexata José nonotapuna. Piamajitsinaemeravi baja José barëpona Jesúsnëyo, pena yajava. Barënajetabajirava Egipto nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bajarajotalia José barëponapona bajayajebi. Matapania baja Herodes itsa tëpa, José barëpatsijitsiarena Israel nacuayaberena. Bajarapacuenia tocopiapatatsi tsipaji baja cajena bajayata Diosojumepaebinëmi profetanëmi Dioso pejamatabëcueneta tajëvelia jumaitsi Jesús yabara mapacueniaje: “Taxënato icatsia junatsiarenajë penaviatsinexa Egipto nacuaverena,” jai ra Dioso, jai baja cajena bajayata tajëvelia profetanëmi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nacuaevetsinë Herodes picani jumaitsi tulupu perubenaejava pecanaëcobivijavabelia: “Itsa pacaxitajarabianame bajarapanacuetonëyo, panevajunucaponaeremena,” jai picani Herodes Jesúsnëyo yabara. Itsiata tulupu perubenaejava pecanaëcobivi caxitajarabi ata Jesúsnëyo, apo vajunucaponae Herodesjavabelia. Nexata Herodes itsa yapëtane tulupu perubenaejava pecanaëcobivi apo pevajunucaponaejavatsirena, caxitajarabi ata Jesúsnëyo, Herodes bitso anaepana. Nexata Herodes pijajivi itoroba. Jumaitsi: —Pabeponaename daxita pebinacuetoxi Belén tomarata, Belén tomarajumavelia penaebonëjava ata. Daxita papebinacuetoxi abaxë apo xainae acueyabi pavaibeje, pabeponaename. Pejananaexanaenacuetoxi ata pabeponaenane, jai Herodes pijajivijavabelia. Bajarapacuenia Herodes pijajivi itoroba pebinacuetoxi pebeponaenexa, Jesúsnëyo picani peyajavabeyaxuabinexatsi. Tsipaji tulupu perubenaejava pecanaëcobivi Herodesjavabelia tsipaeba paepatota taxuxuaba petaejava tuluputo. ");
INSERT INTO guh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Itsa bajarapacuenia pebinacuetoxi beponatsi Belén tomarata, copiapata jane baja pacuenia baja cajena Diosojumepaebinëmi profeta Jeramíaspijinë bajayata tajëvelia yaquina pebinacuetoxi pebejavanexatsi yabara. Bajayata baja cajena profeta Jeramíaspijinë peyaquinaelivaisita tajëvelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Belén tomarajumaverena, Ramá tomarata, ayaicuenia matanueyabiana. Raquelpijiva pemomoxi pexi matanueyabiana. Itavetsi atatsi tsane, itsiata apo copatsi tsane bitso penajamatabëxainaejava. Tsipaji pexi totëpaenatsi, jai bajayata tajëvelia profeta Jeramíaspijinë peyaquinaelivaisita pecoxibeponaejavanexatsi yabara bajarapatomarata. ");
INSERT INTO guh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nacuaevetsinë baja Herodes pepuatëpae, Dioso icatsia pijaángel itoroba Joséjavabelia. Nexata ángel meravi majitsinaebota José tsitanaitajëtatsi Egipto nacuata. ");
INSERT INTO guh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nexata ángel jumaitsi Joséjavabelia: —José, nonotapunare. Barëponaename baja tsiquirinëyo, pena yajava. Barënaviaremelia baja icatsia Israel nacuayabelia. Tëpa rabaja ponë picani jamatabëbeyaxuabatsi tsiquirinëyo, jai ángel majitsinaebota Joséjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nexata baja José nonotapuna. Barëpona tsiquirinëyo, pena yajava. José icatsia barënaviata Israel nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nacuaevetsinëmi Herodespijinë pexënato pevënë Arquelao. Nexata Arquelao eveta Judeanacua paxa pevënamuto. Nexata José itsa vënëlivaisitane nacuaevetsinëmi Herodespijinë pexënato pevetsijava Judeanacua, José cujunava Jesúsnëyo pebarëponaejava Judea nacuayabelia. Majitsinaebota José Dioso itavetatsi Jesúsnëyo pebarëponaeyaniva Judea nacuayabelia. Nexata José barëpona Jesúsnëyo Galilea nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","José itsa barëpata Jesúsnëyo Galilea nacuayabelia, Nazaret tomarata barëpatajopa pebarëecaenexa Nazaret tomarata. Bajarapacuenia José Nazaret tomarata itsa barëeca Jesúsnëyo, copiapata jane baja pacuenia baja cajena bajayata Diosojumepaebivimi profetavi tajëvelia jumaitsi. Diosojumepaebivimi profetavi bajayata baja cajena tajëvelia jumaitsi Jesús yabara mapacueniaje: “Ponë Dioso itorobijitsiatsica jivi pecapanepaenexa, bajaraponë yabara jivi jumai tsane: ‘Mara ponëje Nazaret tomarapijinëje,’ jai tsane,” jai baja cajena bajayata tajëvelia profetavimi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús itsa baja xaina bejamatabëcuene treinta pavaibeje, Juan jivibautisabinë najetaruca Judea nacuatusatojava. ");
INSERT INTO guh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan jivibautisabinë Dioso pitorobilivaisi jivi tsipaebanajetaruca. Jumai tsanajetarucae mapacueniaje: —Dioso rabaja pijajivi pevetsimatacabinexa, imoxoyo baja pevajënae pecopiapatsinexa. Nexata baja pacopabare pibisiacuene paneexanabiabijava. Panajamatabëcuenepënëyorore Diosojavabelia, jai tsanajetarucae Juan jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bajarapacuenia Juan Dioso pitorobilivaisi jivi itsa tsipaebanajetaruca, copiapata jane baja pacuenia Diosojumepaebinëmi profeta, Isaíaspijinë, bajayata tajëvelia yaquina Juan pelivaisi. Juan jivibautisabinë Dioso pitorobilivaisi jivi petsipaebanajetarucaejavanexa yabara, yaquina. Profeta Isaíaspijinë peyaquinaelivaisita tajëvelia jumaitsi mapacueniaje: Tanejumelivaisipaebinë vavajai tsane petusato nacuata. Jumaitsi tsane jivijavabelia: “Jivi baxaneba panamutoverena najetarucaejitsia petuxanenë. Batoroviaexananua namuto. Bajara pijinia pacuenia paxamë ata panajamatabëcuenexaniavaere pepo petuxanenë pepatsivajënaeyarena,” jai tsane tanejumelivaisipaebinë, jai profeta Isaíaspijinë bajayata peyaquinaelivaisita Dioso pitorobilivaisi Juan jivi petsipaebanajetarucaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan naxatata camellonata pexanaejava. Naepacëta cuerobocoto. Pexaejava ëbosese, jabëra yajava. ");
INSERT INTO guh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juan petsipaebilivaisi pejumetaenexatsi, muxunapatabiabatsi Jerusalén tomarapijivi, Judea nacuapijivi ata, Jordánmene imoxoyopijivi ata. ");
INSERT INTO guh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nexata bajarapamonae pibisiacuene pexanaejavami, rovialia Diosojavabelia navecuapaebapona. Nexata bajarapamonae Juan bautisabapona Jordán meneta. ");
INSERT INTO guh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jivibitsaëtoxaneto pata Juanjavaberena pebautisabinexa picani Juan. Bajarapamonae apo jumecovënëtsi ata Dioso pitorobilivaisi, jamatabëcuenenavëxaniabiaya jamatabëjumaitsi: —Juan itsa nacabautisabiana, Dioso nacacapanepaena, jamatabëjai. Nexata Juan itsa tane ayaibitsaëtoxaneto fariseovi, saduceovi ata, pepatsijavarena Juan picani pebautisabinexa, nexata Juan jumaitsi bajarapamonaejavabelia: —¡Panejamatabëcuenenavëxaniabivi! Pacuenia jomo rëcëpa itsa tane isoto petajuenajetarucaejava, bajara saya paitsimë. Dioso rabaja papecananeconitsia exanaematacabinexa, pacaimoxoyotapona. Itsiata acuenebi tsane panevecuapanepaenexa Dioso papecananeconitsia exanaematacabinexa. ");
INSERT INTO guh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Itsa pajitsipame Dioso papecacapanepaejava, pacopabare pibisiacuene paneexanabiabijava. Dioso pajumecovënëtavanapare. Nexata daxitajivi pacayapëtaena pepacuene baja panecopabijava pibisiacuene paneexanabiabijavami. Pacayapëtaenanua panenajamatabëcuene pënëyorotsijava Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jamatabëcuenenavëxaniabiaya pëtsa panajumaitsimë: “Vaxaitsi cajena Abrahampijinë pemomoxitsi. Nexata Dioso nacacapanepaena,” panajamë pëtsa. Abrahampijinë picani papemomoxi atamë, itsiata pibisiacuene itsa paexanavanapame, nexata bajarapacuene apo pacatonamatamotsi tsipae Diosojavabelia papecacapanepaenexa. Dioso baja cajena caëjëpatsi jivi pexanaenexa mapaibotonëmi ataje, Abrahampijinë bepemomoxi Dioso petaenexa. Nexata bajarapamonae ata Dioso itsa apo jumecovënëtsi, Dioso apo capanepae tsipae. Nexata pacopabare pibisiacuene paneexanabiabijava papecacapanepaenexa Dioso. ");
INSERT INTO guh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Peubinaenë pexainaenë itsa apo tonacuaitsitsi pexaniacuai, nicata sipalita daxita ponaenë apo tonacuaitsitsi pexaniacuai. Nexata baja penicatsicujinae itsa niona bajaraponaenë, caetuata. Xuaba isotojavabelia. Nexata bajaraponaenëmi tajuatsi. Bajara pijinia pacuenia paxamë ata Dioso pacaxuabiana infiernojavabelia papecatajuenexa, Dioso apo panejumecovënëtsivi. ");
INSERT INTO guh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xanë raja saya jivi bautisabaponajë merata. Tsipaji baja bajarapamonae copaba pibisiacuene pexanabiabijava. Najamatabëcuenepënëyorotanua Diosojavabelia. Itsiata baitsi jane ponë tacovëverena najetarucaena, tabautisabivi Espíritu Santo tsijamatabëjoneyaexanaenatsi, pitarunutsicotia yajava. Xanë raja saya beveliajamatabëcuenenënë bajaraponëvecua. Nexata bajaraponë vecuaauranë pijazapato ata tatocaponaenexa bepijajivitonëcuenianë. ");
INSERT INTO guh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Arrozxainaenë baja itsa vereta arroz pesiricaejava, jëaba arroz pejëabijavata pepitsinexa ëpexu. Nexata pijaarroz pejëabijavata, saicaya tsatapona ëpexu pesivecua. Nexata ëpexu xaniavaeteta peetsibojavabelia. Pesi pijinia penetapona vayafuabelia petajuitsinexa. Bajara pijinia pacuenia paxamë ata Dioso pejumecovënëtsivivecua Dioso pacatsatsiana papecaxuabinexa infiernojavabelia panenaxuabinexa baja daxitamatacabijavabelianexa. Pamonae pijinia Dioso pejumecovënëtsivi, Dioso capanepaenatsi pijanacuayabetsia. Pamonae pijinia Dioso apo jumecovënëtsi, Dioso naneconitsiaexanaenatsi daxitamatacabijavabelianexa apo pevereverecaeisotojavabelia, jai Juan daxita bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús naropota Galilea nacuajavaverena. Nexata pata Jordán menejavaberena. Jordán menejavata Juan ponapona. Nexata Jesús pata Juanjavaberena pebautisabinexatsi Juan. ");
INSERT INTO guh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan picani apo jitsipae pebautisabijava Jesús. Juan nexata jumaitsi Jesúsjavabelia: —¿Detsa xuajitsia patame tacabautisabinexa? Xamë rajane biji xanë benebautisabame, jai Juan Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Itsiata Jesús jumaitsi Juanjavabelia: —Aeconoxae itsiata pacuenia baja cavajëtatsi, netoexanaename. Xanepana vajaexanaenexa daxita Dioso vajanacaitorobicuenia, jai Jesús Juanjavabelia. Nexata baja Juan jejai pebautisabinexa Jesús. ");
INSERT INTO guh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nexata jane baja Juan bautisaba Jesús. Jesús pebautisabicujinaetsi nonotajuna menevetsina. Bajarapaepatota Jesús tane athëbëtatsia itaboxo penapatsijava. Nexata Jesús tane Espíritu Santo perunaejavatsica beucucuto. Tsimatarunaicatsi. ");
INSERT INTO guh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nexata Juan jumetane athëbëvetsica Dioso pejumaitsijava: “Mara ponë taxënato tasivanëje. Sivajamatabëcuenebarëyanë bitso,” pejaijava. ");
INSERT INTO guh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesús pebautisabicujinaetsi, Espíritu Santo ponaeyaexanatsi petusato nacuayabelia. Bajarabelia ponaeyaexanatsi pejamatabëcueneëjëbinexatsi dovathi. ");
INSERT INTO guh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nexata petusato nacuata Jesús ponapona cuarenta pamatacabibeje, cuarenta pameravibeje yajava. Bajara pijinia pamatacabibeje Jesús apo xae pexaejava. Nexata Jesús bitso piajani. ");
INSERT INTO guh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nexata dovathi Jesús imoxoyotatsi pejamatabëcueneëjëbinexatsi Jesús picani pibisiacuene pexanaenexa. Dovathi jumaitsi Jesúsjavabelia: —Itsa pepacuene Dioso pexënatomë, itorobare mapaibotonëje penaexanaenexa pan, jai dovathi. ");
INSERT INTO guh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús nexata jumaitsi dovathijavabelia: —Jume raja. Dioso raja pejumelivaisibaxutota jumaitsi mapacueniaje: “Jivi raja apo namatavenonae ëpexaejava pexaenexa. Jivi raja namatavenona daxita Dioso pejumelivaisi ata pejumecovënëtsinexa pexainaenexa matacabi apo pevereverecaejava,” jai raja Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bajaraxuacujinae icatsia Jesús barëliatsi dovathi Jerusalén tomarabelia. Barëjunayatsi templobo matatuyabetsia. ");
INSERT INTO guh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nexata templobo matatutatsia dovathi icatsia jumaitsi Jesúsjavabelia: —Itsa pepacuene Dioso pexënatomë, jirevaremeca irabereca. Bajarapacuenia jirevaremeca irabereca tsipaji xamë nitsacueneyaniva pecaevetsinexa Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: Dioso itorobianica pijaángelevi pecaevetsinexa. Nexata ángelevi pecobeta cayotsiana pecataxutsaquitsiyaniva ibotonëjavabelia, jai Dioso pejumelivaisibaxutota xamë pecaevetsinexa ángelevi, jai dovathi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús nexata icatsia jumaitsi dovathijavabelia: —Jume raja. Dioso raja pijinia pejumelivaisibaxutota jumaitsi mapacueniaje: “Itsajivi ata jamatabëcuenenavëxaniabiaya pijacuata apo bejamatabëjumaitsi: ‘Xanë Dioso jamatabëcueneëjëtsianajë. Nexata exanaenajë pacuene bitso netsiayai tatëpaenexa. Itsiata Dioso neyavenonaena tavecuapanepaenexa bajaraxua. Nexata bajarapacuenia yapëtaenajë Dioso taneyavenonaejava,’ apo bejamatabëjai,” jai Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jesús icatsia barëliatsi dovathi pinijitsutoxanetojavabelia. Barëjunayatsi bajarapatsutojumabetsia. Nexata bajarapatsutojumavetsica dovathi Jesús tsitajëtatsi daxitanacuanë. Daxita bajarapanacuanëta daxitacuene pexainaejava yajavatsitajëtatsi. ");
INSERT INTO guh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nexata icatsia dovathi jumaitsi Jesúsjavabelia: —Ayaijamatabëcuenenënë netaeya taitabarata nematabacabëta itsa netonucajunuame, nexata daxita mapanacuanëtaje, daxitacuene xua xaina, cayajavarajutsianatsi, jai dovathi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nexata Jesús jumaitsi dovathijavabelia: —Dovathi, nevecuanatixire. Dioso raja pejumelivaisibaxutota jumaitsi mapacueniaje: “Daxitajivi vajëcae pematabacabëta caenë pepo petuxanenë Diosojavabelia. Tonacuenebinua bajaraëponënexa,” jai raja Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nexata baja dovathi Jesús vecuaponatsi. Bajaraxuacujinae ángelevi patsica Jesús peyavenonaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús vënëlivaisitane Juan peetsijavatsi penaneconitsivi pejebabiabibota. Nexata Jesús pona Galilea nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Itsiata Jesús apo ponaponae Nazaret tomarata. Ponapona Capernaum tomarata. Capernaum tomara eca Zabulónvënë nacuabeje Neftalivënë nacuabejejavata. Capernaumtomara eca pucaxanetoitapata. ");
INSERT INTO guh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bajarapacuenia Jesús itsa patajopa Capernaum tomarata Dioso pitorobilivaisi jivi petsipaebinexa, copiapata jane baja pacuenia bajayata Diosojumepaebinë profeta, Isaíaspijinë, tajëvelia yaquina Jesús pelivaisi. Dioso pitorobilivaisi Jesús Capernaum tomarata jivi petsipaebijavanexa yabara, Isaíaspijinë peyaquinaelivaisita tajëvelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Zabulón nacuapijivi, Neftali nacuapijivi ata, Jordánmene itsapanaverenapijivi ata, bitso apo yapëtae Dioso pitorobilivaisi. Galilea nacuata pejinavanapaevi ata, itsaxuayo jinavanapa ayaibitsaëtoxanetonë apo judíovi, bitso apo yapëtae Dioso pitorobilivaisi. Daxita bajarapanacuanëpijivi pexaniajailivaisi, Dioso pitorobilivaisi, apo peyapëtaexae, bepitaquirinacuanëjava jinavanapa. Nexata pacuenia pinijicotiaxaneto itayotsipatsi petaenexa xaniavaetsia, bajara pijinia pacuenia bajarapamonae jamatabëcueneitayotsianatsi itsa tsipaebianatsi Diosojavabelia pecapanepaelivaisinexatsi, jai tajëvelia Isaíaspijinë peyaquinaelivaisita Dioso pitorobilivaisi Jesús petsipaebijavanexa yabara bajarapanacuanëpijivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nexata Capernaum tomarata Jesús taxuxuaba Dioso pitorobilivaisi jivi petsipaebijava. Dioso pitorobilivaisi Jesús itsa tsipaeba, jivijavabelia jumai tsaponae mapacueniaje: —Dioso rabaja papecaevetsimatacabinexa, imoxoyo baja pevajënae pecopiapatsinexa. Nexata baja pacopabare pibisiacuene paneexanabiabijava. Panajamatabëcuenepënëyorore Diosojavabelia, jai tsaponae Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús najetaruca Galilea pucaxaneto itapaya. Nexata Galilea pucaitapata Jesús taenuta anijanëbeje nacaebananëbeje, Simónbeje Andrésbeje. Simón itsavënë Pedro. Bajaraponëbeje daxitamatacabi canacujitsia dujuai yamatajucabiababeje. Dujuai peyamatajucabiabijavatabeje, yamatajucaponaponabeje. ");
INSERT INTO guh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nexata Jesús jumaitsi Simónbeje Andrésbejejavabelia: —Naxanitsia. Panepënaponarebeje. Nexata pacacujarubianatsibeje jivi panejucaenexabeje. Pacuenia dujuai payamatajucabiabamebeje, bajarapacuenia jivi pajucaename Dioso pijajivinexa, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nexata Simónbeje Andrésbeje dujuai peyamatajucabiabijavamibeje, bajarajota puenetabuatabeje. Nexata baja naponabeje Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bajaraxuacujinae icatsia bebeliayo pevajënaeyabelia Jesús barëpona. Icatsia taenuta anijanëbeje nacaebananëbeje, Zebedeo pexënatobeje. Bajaraponëbeje Santiagobeje Juanbeje. Pijajeraënëta paxa yajava xanebaponaponabeje dujuai peyamatajucaejavanexabeje. Nexata icatsia Jesús junata Santiagobeje Juanbeje. ");
INSERT INTO guh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nexata bajarajota paxa puenetanutabeje jera yajava. Santiagobeje Juanbeje naponabeje baja Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús jane baja najetaruca daxita Galilea nacuajava. Dioso pitorobilivaisi tsipaebapona judíovi penacaetuatabiabibonëjava. Jesús tsipaebapona jivijavabelia pexanialivaisi. Tsipaebapona Dioso pijajivi pevetsijavanexa. Jamatejemayaexanaponanua daxitaviriavitane pexainaevimi. ");
INSERT INTO guh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nexata daxita Siria nacuajava pejinavanapaevi ata vënëlivaisitanetsi Jesús. Jesús tocapatatsi daxitaviriavitane pexainaevi. Tocapatatsinua dovathi peyajavajinavanapaevi. Tocapatatsinua pedevacaibivitsi. Tocapatatsinua petabusipacuenabivitsi. Jesús nexata jamatejemayaexanapona daxita bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nexata Jesús pënaponatsi jivi ayaibitsaëtoxaneto Galilea nacuapijivi, Decápolis nacuapijivi ata, Jerusalén tomarapijivi ata, Judea nacuapijivi ata, Jordánmene itsapanaverenapijivi ata. ");
INSERT INTO guh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús itsa tane jivibitsaëtoxaneto, nexata junaya petsutotsia. Bajarapatsutoyenepanata epatota ecaya. Nexata bajarajota Jesús pijajivi matatoyorotsia nacaetuatatsi. ");
INSERT INTO guh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nexata Jesús taxuxuaba livaisi petsipaebijava. ");
INSERT INTO guh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesús jumaitsi pijajivijavabelia mapacueniaje: —Jamatabëcuenebarëya tsavanapae tsane pamonae picani mapanacuata yajamatabëcuenebëjai tsavanapae pibisiacuene pexanabiabijava. Bajarapamonae jonena Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Jamatabëcuenebarëya tsavanapae tsane pamonae picani mapanacuata bejamatabëjiobi tsavanapae itsamonae pibisiacuene petoexanaexaetsi. Bajarapamonae Dioso jamatabëcueneyavenonaenatsi. ");
INSERT INTO guh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Jamatabëcuenebarëya tsavanapae tsane pamonae apo jamatabëbëjai tsabiabi mapanacuata, itsacueniababiabi atatsi itsamonae. Apo cuenecanaviatabiabinua. Bajarapamonae jinavanapaena Dioso pijanacuatatsia pacuenia Dioso najumecapanepaeya jumaitsi bajarapamonae yabara. ");
INSERT INTO guh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Jamatabëcuenebarëya tsavanapae tsane pamonae mapanacuata bitso daxitacuene matatoxenetsia jitsipabiaba pexanaenexa Dioso pitorobicueniatsi. Dioso baja cajena yavenonabiabianatsi pexanaenexa bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jamatabëcuenebarëya tsavanapae tsane pamonae mapanacuata itsamonae ata itaxutotsoniataeyabiaba. Dioso nexata juya itaxutotsoniataeyabiabianatsi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jamatabëcuenebarëya tsavanapae tsane pamonae mapanacuata ëpexaniacuene pexanaenexa najamatabëxainabiaba. Bajarapamonae taena Dioso. ");
INSERT INTO guh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jamatabëcuenebarëya tsavanapae tsane pamonae mapanacuata penaitoyavimi ata, nabarajamatabëcuene xanepanaeyaexanapona. Bajarapamonae yabara: “Taxi,” jai tsane Dioso. ");
INSERT INTO guh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Jamatabëcuenebarëya tsavanapae tsane pamonae mapanacuata bejiobiaexanabiabatsi Dioso pitorobicueniatsi pexanabiabijava yabara. Bajarapamonae jonena Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Patajajivixaemë, itsamonae pibisiacuenia itsa pacabaracuaicuaijai, itsiata pajamatabëcuenebarëyamë tsavanapae tsane. Bajarapamonae pacabejiobiaexanae ata tsane, najumetsënëtsiaya pacabaracuaicuaijai atanua tsane, itsiata pajamatabëcuenebarëyamë tsavanapae tsane. ");
INSERT INTO guh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bajara tsipaji pacuenia panevajënaeyapijivimi ata, Diosojumepaebivimi profetavi, bajayata bejiobiaexanatsi. Nexata pasivajamatabëcuenebarëyamë tsavanapae tsane paxamë ata bajarapacuenia itsa pacaexanaena. Tsipaji raja athëbëtatsia itsamatacabi Dioso pacarajutsiana bitso pexaniacuene, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Yajobeno xanepana vajaexabinexa pevi piabejeyaniva. Paxamë rabaja pijinia bepayajomë tsavanapae mapanacuapijivijavabeliaje, mapanacuapijivi bitso piabejeyaniva pibisiacuene pexanaeneconi yabara. Paxamë xaniavaetsia panetsipaebavanapaexae Dioso pejumelivaisi, bajarapamonae bitso pibisiacuene apo exanae. Itsiata yajo pexaicaejavami itsa ajibi tsipae, ¿detsa nexata pacuenia icatsia naxaicaeyaexanaejitsipa? Acuenebi. Itsacuenejavayonexa ata baja apo xanepanae tsipae. Saya pexuabinexa, jivi petaxunanonobinexa, xanepanaejitsipa. Bajara pijinia paxamë ata paitsimë tsipae itsa pacopatsipame Dioso panejumecovënëtsijava. Pajamatabëcuenesaëjibimë tsipae. Nexata itsacuenejavayonexa ata, apo paxanepanaemë tsipae. ");
INSERT INTO guh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Pacuenia piaitayotsicotia itayota piaitaquirijavata, bajara pijinia pacuenia paxamë ata Dioso panejumecovënëtsivi pajamatabëcueneitayotsianame piajamatabëcueneitaquirivimi. Bajarapacuenia pajamatabëcueneitayotsianame itsa patsitajinavanapaename xaniavaetsia daxitajivi pitabarata. Petsutojumata peecaetomara acuenebi penacaranatecaejava tsipae. ");
INSERT INTO guh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Itsajivi ata lámparabë pitanojotsicujinae, apo etsi cajoniënëalia. Biji rajane athëbëyo etsia daxitaboënë pitayotecaenexa. ");
INSERT INTO guh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bajara pijinia pacuenia paxamë ata paitsimëre. Xaniavaetsia patsitajinavanapare daxitajivi pitabarata. Nexata bajarapamonae pacacuenetaena pexaniacuene paneexanavanapaejava. Nexata bajarapamonae itsa pacacuenetaena pexaniacuene paneexanavanapaejava, jumai tsane paxamë yabara paneaxa Diosojavabelia: “Diosomë, bitso ayaijamatabëcuenenëmë. Yavenonabiabame nijajivi,” jai tsane bajarapamonae paneaxa, athëbëtatsia peecaenëjavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pëtsa panesivajamatabëjumaitsimë: “Maponë patajopaje piajibiayaexanaenexa Dioso Moiséspijinëta penajumecopatsilivaisi. Palivaisi ata Diosojumepaebivimi profetavi bajayata tsipaebapona piajibiaexanaenexa,” panesivajamatabëjamë pëtsa. Apo patajopaenë tajibiayaexanaenexa bajarapalivaisibeje. Biji rajane patajopajë taexanaenexa jane baja daxita pacuenia tajëvelia nevajunupaeba bajarapalivaisitabeje. ");
INSERT INTO guh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Xaniajanë pacuenia pacatsipaebijitsiatsi. Dioso Moiséspijinëta penajumecopatsilivaisi epatua itsalivaisicuenia, caeitanetoyo ata, Dioso apo itothianae tsane. Pacuenia baja Dioso najumecapanepaeya jumaitsi, bajarapacuenia tsitecaena. Nexata copiapatsiana daxita xua Dioso tajëvelia najumecapanepaeya jumaitsi bajarapalivaisitabeje. ");
INSERT INTO guh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nexata pajivi jumecovënëtsi ata Dioso Moiséspijinëta penajumecopatsilivaisi, itsiata itsa apo jumecovënëtsi caelivaisiyo bajarapayajuvënëlivaisiyo, naneconitsiana Diosojavabelia. Bajarapajivi itsa itavetsiananua itsamonae ata pejumecovënëtsiyaniva bajarapalivaisiyo, nexata bajarapaneconi yabara bajarapajivi beveliajamatabëcuenejivi taenatsi daxitajivivecua Dioso pijanacuatatsia. Pajivi jumecovënëta daxita bajarapalivaisi, itsa tsipaebanua itsamonae ata pejumecovënëtsinexa bajarapalivaisi, nexata bajarapajivi ayaijamatabëcuenejivi taenatsi Dioso pijanacuatatsia. ");
INSERT INTO guh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Xaniajanë pacuenia pacatsipaebijitsiatsi. Paxamë xaniavaetsia Dioso pajumecovënëre. Xaniavaetsia Dioso pajumecovënëre judíovi pecujarubivi Dioso pejumecovënëtsijava matatoxenetsia. Xaniavaetsia Dioso pajumecovënëre fariseovi ata Dioso pejumecovënëtsijava matatoxenetsia. Paxamë xaniavaetsia Dioso itsa apo pajumecovënëtsimë tsane, nexata pacuenia bajarapamonae apo jone tsane Dioso pijanacuayabetsia, bajara paxamë ata paitsimë tsane. Apo panajonemë tsane Dioso pijanacuayabetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Paxamë rabaja payapëtaneme pacuenia bajayata Moiséspijinë jumaitsi panijasalinaivimijavabelia. Moiséspijinë bajayata panijasalinaivimijavabelia jumaitsi mapacueniaje: “Pëtsa pabeyaxuabame jivitonë. Pajivi beyaxuaba jivitonë, bajarapajivi pananeconitsiaexanaename,” jai Moiséspijinë panijasalinaivimijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Itsiata baitsi jane xanë pacatsipaebatsi mapacueniaje. Pajivi baraanaepana itsajivijavabelia, bajarapajivi naneconita Diosojavabelia. Nutsianatsi Dioso pitabarata penaneconitsiayaexanaenexatsi. Pajivi itsajivi bijatane pibisiacuenia, bajarapajivi naneconita Diosojavabelia. Bajarapaneconi yabara nutsianatsi itsajota nacaetuatabiaba tomara pevetsivi. Nexata naneconitsiayaexanaenatsi. Pajivi itsajivi pitoyaxae, anaeya jumaitsi: “Xamë saya bitso pecamatajemabinë,” jai, bitso tsiayaitsi. Bajarapaneconi yabara bajarapajivi Dioso naneconitsiayaexanaenatsi infierno isotojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Itsa paponame altarvënëjavajavabelia panerajutsinexa ofrenda Diosojavabelia, nexata bajarapaepatota itsa panajamatabënapitame itsajivijavabelia itsacuene paneexanaejava, nexata mapacuenia paexanaenameje. ");
INSERT INTO guh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Altarvënëjava pitabarata abaxë papuenere ofrenda panerajutsijavanexa Diosojavabelia. Paponare caecuenia pajivijavabelia pananeconitame panenabarajamatabëcuene xanepanaenexabeje icatsia. Bajaraxuacujinae icatsia panaviatsiaremena altarvënëjavajavaberena panerajutsinexa jane baja ofrenda Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Itsa pananeconitame itsajivijavabelia, nexata itsa pacacapona bajarapajivi jueznëjavabelia papecaneconitsinexa, namutua xaniavaetsia panabarëcuaicuaijamërebeje panenasivajamatabë xanepanaenexabeje xua yabara picani pacaneconitsijitsia. Bajarapacuenia xaniavaetsia panabarëcuaicuaijamërebeje papecanutsiyaniva jueznë pitabarata. Tsipaji raja jueznë itorobijitsipa policíavi panijaneconi yabara papecacaponaenexa penaneconitsivi pejebabiabiboyabelia. Nexata policíavi pacananeconitsiaexanetsipa penaneconitsivi pejebabiabibota. ");
INSERT INTO guh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Xaniajanë pacuenia pacatsipaebijitsiatsi. Nexata penaneconitsivi pejebabiabibota itsa pacananeconitsiaexanetsipa, bajaraverena bepijia apo papitsapaemë tsipae. Matapania pamatamotsipame daxita xua yabara pacananeconitsiaexaneta, papitsapaejitsipame, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Paxamë rabaja payapëtaneme pacuenia bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi. Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Pëtsa jaitame itsava nijavavecua,” jai. ");
INSERT INTO guh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Itsiata baitsi jane xanë mapacuenia pacatsipaebatsije. Ponë petiriva itsa taenuta, nexata itsa jamatabëjumaitsi: “Jema xania tavitota pibisiacuene apo caexanaetsi mapovajavabeliaje,” itsa jamatabëjai, bajaraponë naneconita Diosojavabelia. Nexata najëpaeya naneconitabeje Diosojavabelia ponëbeje pepacuene itsavajavabelia pibisiacuene pevitota exana pijavavecua. ");
INSERT INTO guh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Panecujuaitaxutota panetaejava yabara pibisiacuene itsa paexaname, panaitaxutocajure. Tajë baja paxuare. Xanepana panenavecuaxuabinexa bajarapaitaxuto, padaxitaperabëtojivimë Dioso papecaxuabiyaniva infiernojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Panecujuacobeta pibisiacuene itsa paexaname, panacobecaucure. Tajë baja paxuare. Xanepana panenavecuaxuabinexa, bajarapacobe padaxitaperabëtojivimë Dioso papecaxuabiyaniva infiernojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Ponë jamatabëxuaba pijava, copiaya toyaquinae cuyalatobaxuto pijavajavabelia. Toyaquinae pijava pitavetsilivaisi. Nexata xuacujinae xuabi pijava,” jai bajayata Dioso Moiséspijinëta penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Itsiata baitsi jane xanë mapacuenia pacatsipaebatsije. Ponë pijava xuaba, itsanëjavabelia bajarapova pevitota pibisiacuene apo vecuaexanae atatsi, bajaraponë naneconita Diosojavabelia pijava pexuabixae. Petiriva pamona pexuabixaetsi, nacojiobijitsipa itsanëjavabelia. Nexata jane baja bajaraponë pijava pibisiacuene vecuaexanaejitsipatsi itsanëjavabelia. Tsipaji abaxë bajaraponë pijavacuenia Dioso totanetsi. Nexata pijinia ponë pita bajaraponë pexuabicovëvami, bajaraponë ata pibisiacuene exana pevitota. Tsipaji abaxë bajaraponë pijavacuenia Dioso totanetsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Paxamë rabaja payapëtaneme pacuenia bajayata Moiséspijinë jumaitsi panijasalinaivimijavabelia. Panijasalinaivimi penajumetsënëtsiyaniva, bajayata Moiséspijinë panijasalinaivimijavabelia jumaitsi mapacueniaje: “Itsa baja pepacuene najumecapanepaeya panavajunupaebame xua paexanaejitsiamë, itsamonae papecajumexaniataenexa itsa pajumaitsimë: ‘Xaniajanë raja. Cajumaitsitsi mapacueniaje Dioso pitabarata,’ itsa pajamë, pëtsa epatua panajamatabëcopatame bajaraxua paexanaenejevamë,” jai bajayata Moiséspijinë panijasalinaivimijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Itsiata baitsi jane xanë mapacuenia pacaitorobatsije. Najumecapanepaeya itsa panavajunupaebame xua paexanaejitsiamë, rovialia panavajunupaebare. Pëtsa pematatsënëa itsajumeyo ata yajava pajumaitsimë jivi papecajumexaniataenexa. Papecajumexaniataenexa itsajivi pëtsa pajumaitsimë mapacueniaje: “Xaniajanë raja. Cajumaitsitsi mapacueniaje Dioso pitabarata,” pajamë pëtsa. Pëtsa pajumaitsimënua: “Xaniajanë raja. Cajumaitsitsi mapacueniaje athëbënacua pevënëta,” pajamë pëtsa. Tsipaji bajarajotatsia Dioso eca pijatronovënëjavata, itsajota ecabiaba pitorobinexa pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pëtsa pajumaitsimënua: “Xaniajanë raja. Cajumaitsitsi mapacueniaje mapairaje pevënëta,” pajamë pëtsa. Tsipaji raja Dioso pijaira. Pëtsa bajarapacuenia pajumaitsimë Jerusaléntomara ata pevënëta. Tsipaji Jerusaléntomara Dioso pepo nacuaevetsinë pijatomara. ");
INSERT INTO guh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pëtsa pajumaitsimënua: “Xaniajanë cajena. Itsa apo xaniajanë tsane, nexata nacaevetsianajë tanematathinaxuabinexamë tatëpaenexa,” pajamë pëtsa. Tsipaji panematabocoto ata Dioso eveta. Nexata paxamë apo pacacaëjëpae caematanatoyo ata panenamatananiojaiyaexanaenexa, panenamatanatsaejaiyaexanaenexa ata. ");
INSERT INTO guh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Itsa pepacuene paexanaejitsiamë, “Jãjã, exanaenajë,” pajamëre rovialia. Itsa apo pajamatabëexanaemë, “Jume, apo exanaenë tsane,” pajamëre rovialia. Pematatsënëa pëtsa pajumaitsimë itsajumeyo ata jivi papecajumexaniataenexa. Tsipaji bajarapajume dovathi pejamatabëcueneta pajumaitsimë tsipae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Paxamë rabaja payapëtaneme pacuenia bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi. Bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Pajivi itsanë itaxutobijianatsi, juya bajarapajivi namatamoitaxutobijianae. Pajivi ata itsanë vonotanabiabatsi, juya bajarapajivi namatamovonotanabiabi,” jai bajayata Dioso Moiséspijinëta penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Itsiata baitsi jane xanë mapacuenia pacaitorobatsije. Itsanë itsa jamatabëpacabia, pëtsa panayajivibiame. Itsanë itsa pacaitabarapacabiaxuaba anaeya, nexata icatsia itsanenia ata papecaitabarapacataxuabinexa, panaitabaracaevere. ");
INSERT INTO guh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Itsajivi itsa pacaneconitsijitsia jueznëjavabelia paneamoneyabijamatabëcuene papecavecuapitsinexa panijacamisa, nexata patocopare panijacamisajumavelia panenaxatatsijava ata papecavecuapitsinexa. ");
INSERT INTO guh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Vajabitsaë itsa pacacaponaeyaexana pijajava anijakilómetrobejecuenia, nexata patocaponare pematatsënëa ata. Cuatro pakilómetrobejecuenia ata patocaponare. ");
INSERT INTO guh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bitso bepejiobijivi itsa pacavajëta itsacuenejavayo, parajure. Itsa pacacovaeta, patsicopare. “Jume,” pajamë pëtsa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Paxamë rabaja payapëtaneme pacuenia bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Pasivamëre papecayapëtaenë bitso. Paitoyamëre papecaitoyavi,” jai bajayata Dioso Moiséspijinëta penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Itsiata baitsi jane xanë mapacuenia pacaitorobatsije. Pasivamëre papecaitoyavi ata. Pamonae ata pibisiacuenia pacabaracuaicuaijai, bajarapamonae paxamë xaniavaetsia pabaracuaicuaijamëre. Pamonae ata pacaitoya, bajarapamonae pexaniacuene patoexanare. Pamonae ata pibisiacuenia pacabijatane, pibisiacuene pacaexanae ata, patovajëre Diosojavabelia peyavenonaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bajarapacuenia nexata paneaxa, athëbëtatsia peecaenë, papeximëcuenia patsitajinavanapaename. Bajaraponë, paneaxa, yavenonabiaba daxitajivi. Nexata pexaniajamatabëcuenevi, pibisiajamatabëcuenevi ata, najëpaeya pijapabianë petonaxaniabinexatsi icotia copata. Bajarapacuenia pijinia ema ata copata. ");
INSERT INTO guh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Itsa pasivamë tsipae ëpapecaasivavi, nexata pexaniacuene apo paxainaemë tsipae Diosojavabelia. Pataneme rabaja. Gobierno pejamatabëcueneta impuestomatamo peyanijobabiabivi bitso pibisiacuene exana. Itsiata bajarapamonae ata asiva piasivavitsi. ");
INSERT INTO guh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Xaniavaetsia itsa pacopiapitsipame ëpaneyapëtaevi, nexata pexaniacuene apo paexanaemë tsipae pamonae Dioso apo pejumecovënëtsivivecua. Tsipaji Dioso apo pejumecovënëtsivi ata xaniavaetsia copiapitabiaba peyapëtaevitsi. ");
INSERT INTO guh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pacuenia jamatabëcueneitsi pejamatabëcuenexanepanaenë, paneaxa, athëbëtatsia peecaenë, bajara paxamë ata pajamatabëcueneitsimëre, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —¡Xania baja tsane! Pëtsa pexaniacuene paexaname saya jivi papecacuenetaenexa, “Maponë bitso pexaniajamatabëcuenenëje,” papecasivajamatabëjainexa saya paneexanaejava yabara. Bajarapacuenia itsa paexanaejitsipame, nexata paneaxa, athëbëtatsia peecaenëjavabelia, apo paxainaemë tsipae itsacuenejavayo ata, pexaniacuenejavayo, papecarajutsinexa athëbëtatsia. ");
INSERT INTO guh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bajaraxuata itsa payavenoname bepejiobivi, pëtsa panavajunupaebame daxitajivijavabelia paneyavenonaejava bepejiobivi. Itsamonae xua exana, navajunupaebabiaba daxitajivi pitabarata judíovi penacaetuatabiabibonëjava, callejava ata. Bajarapamonae navajunupaebabiaba bepejiobivi peyavenonaejava, bepexaniajamatabëcuenevi saya petaenexatsi jivi. Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamonae bajarapacuenia navajunupaebabiaba, bajarapacuenia penavajunupaebabiabixae, Diosojavabelia apo xainae tsane athëbëtatsia perajutsijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Itsa payavenoname bepejiobivi, pëtsa panavajunupaebame itsajivijavabelia ata, bitso papecayapëtaejivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Muetsia payavenonare bepejiobivi. Nexata paneaxa, papecataenë muetsia paneexanaejava ata, pacarajutsiana bepejiobivi muetsia paneyavenonaematamo, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Itsa pavajëcame Diosojavabelia, pëtsa pavajëcame pacuenia itsamonae vajëcabiaba. Bajarapamonae saya jema vajëcabiaba Diosojavabelia jivi petaenexatsi Dioso bepejumecovënëtsivi. Bajarapamonae jitsipabiaba nucaeya pevajëtsinexa Diosojavabelia daxitajivi pitabarata judíovi penacaetuatabiabibonëjava, calle penaepacaxitajarabijava ata. Bajarapacuenia vajëcabiaba Diosojavabelia Dioso bepejumecovënëtsivi petaenexatsi jivi. Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamonae bajarapacuenia exanabiaba, bajarapacuenia pexanaexae, Diosojavabelia apo xainae tsane athëbëtatsia perajutsijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nexata paxamë Diosojavabelia itsa pavajëcame, pacaenëmë canacujitsia, pajonemeya panijaboyalia. Pabaupaxatare. Bajaraxuacujinae pavajëcare paneaxajavabelia. Nexata paneaxa pacayajava tsane bajarajota. Nexata paneaxa, papecataenë muetsia paneexanaejava ata, pacarajutsiana bajaraxua paneexanaematamo. ");
INSERT INTO guh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Itsa pavajëcame Diosojavabelia, pëtsa napëna pavajëcame saya piapianexa panevajëcaejava pacuenia Dioso apo peyapëtaevi vajëcabiaba. Dioso apo peyapëtaevi jamatabëcuenenavëxaniabiaya jamatabëjumai tsabiabi: “Itsa bitso apia vajavajëcaejava Diosojavabelia, nexata matapania Dioso nacajumetaena vajavajëcaejava,” jamatabëjai tsabiabi Dioso apo peyapëtaevi. ");
INSERT INTO guh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pëtsa bajarapacuenia paxamë pajamatabëcueneitsimë. Panevajëcaevajënaeya ata raja paneaxa, Dioso, yapëtane xua panamatavenoname. ");
INSERT INTO guh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bajaraxuata itsa pavajëcame Diosojavabelia, pavajëre mapacueniaje: Taxamë, athëbëtatsia neecaenë, jitsipajë pecayaiyataejava daxitajivi. ");
INSERT INTO guh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jitsipajë naxanitsiayo pecopiapatsijava daxita nijajivi nevetsijava mapanacuataje. Jitsipajë daxitajivi mapanacuata nejitsipaecuenia pecatoexanabiabinexa, pacuenia baja athëbëtatsia nijajivi nejitsipaecuenia catoexanabiaba, bajarapacuenia pecatoexanavanapaenexa mapanacuapijivi ataje. ");
INSERT INTO guh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ajena, pamatacabinexa, panerajure pataxaejavanexa pacuenia panamatavenonajë. ");
INSERT INTO guh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Panevecuaajibiaexanare pibisiacuene pataexanaeneconimi. Pacuenia paxanë pajamatabëcuenecaevajë, pabarajamatabëcuenexanepananua, itsamonae paxanëjavaberena pibisiacuene patanexanaejava, bajara pijinia pacuenia xamë ata nitabarata pibisiacuene pataexanaejava jamatabëcuenecaevare. Panebarajamatabëcuene xanepanarenua. ");
INSERT INTO guh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Panevecuatsare dovathi patanejamatabëcueneëjëbiyaniva. Panecapanepare jane pibisiacuenevecua. Pamatacabi xamë taxuxuabianame daxita nijajivi nevetsijava mapanacuataje, nejamatabëcuenesaëta evetsianame. Nexata nijajivi jumai tsane xamë yabara: “Dioso cajena bitso ayaijamatabëcuenenë,” jai tsane. Bajarapacuenia nijajivi evetsianame daxitamatacabijavabelianexa, pajamë tsane mapacueniaje itsa pavajëcame Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesús icatsia jumaitsi pijajivijavabelia: —Nexata paxamë itsamonae pibisiacuene pacaexanae ata, pajamatabëcuenecaevare. Pabarajamatabëcuenexanepanarenua. Nexata paxamë itsamonae pibisiacuene papecaexanaejava, itsa pajamatabëcuenecaevianame, itsa pabarajamatabëcuenexanepanaenamenua, nexata paneaxa, athëbëtatsia peecaenë, pitabarata pibisiacuene paneexanaejava jamatabëcuenecaeviana. Pacabarajamatabëcuenexanepanaenanua. ");
INSERT INTO guh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Paxamë itsa apo pajamatabëcuenecaevimë tsane itsamonae pibisiacuene papecaexanaejava, itsa apo pabarajamatabëcuenexanepanaemënua tsane, nexata paneaxa ata apo jamatabëcuenecaevi tsane. Apo pacabarajamatabëcuenexanepanaenua tsane, pitabarata pibisiacuene paneexanaejava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Itsa apo paxaemë panexaejava pamatacabibeje pavajëcame Diosojavabelia, pëtsa pajinavanapame panaitabaraquiatsinejevamë, panamatatiatsinejevamënua. Itsamonae Diosojavabelia itsa vajëcabiaba pexaejava xaenejeva, pamatacabibeje vajëcabiaba Diosojavabelia, apo naitabaraquiatabiabi, apo namatatiatabiabinua. Bajarapacuenia jinavanapabiaba pamatacabibeje vajëcabiaba Diosojavabelia tsipaji saya bajarapamonae jitsipa petaevitsi pesivajamatabëjumaitsinexatsi: “Mapamonaeje Dioso bitso pejumecovënëtsivi. Diosojavabelia bitso pevajëcaevi pexaejava xaenejeva. Nayapëtane Diosojavabelia bitso pevajëcaejava. Tsipaji naitabaraquiatsinejeva, namatatiatsinejevanua, jinavanapa,” pesivajamatabëjainexatsi petaevitsi. Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajarapamonae pexaejava xaenejeva vajëcabiabi ata Diosojavabelia, itsiata bajaraxua apo tonamatamotsitsi Diosojavabelia. Tsipaji saya jivi petaenexatsi Dioso bepejumecovënëtsivi, bajarapacuenia vajëcabiaba. ");
INSERT INTO guh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Paxamë itsa apo paxaemë panexaejava pamatacabibeje pavajëcame Diosojavabelia, itsiata panaitabaraquiare. Panamatatiarenua xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bajarapacuenia paexanaename jivi peyapëtaeyaniva Diosojavabelia panevajëcaponaejava panexaejava paxaenejevamë. Caenë paneaxa, papecayajavanë, yapëtaena. Nexata bajaraponë itsamatacabi pacarajutsiana panijamatamo, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pëtsa pacaetuataponame ayaijava panexainaejavanexa mapanacuataje. Tsipaji pacatobijianaejitsipa piucubaxaevi. Pacatotasibijitsipatsinua. Pacatonacobetoxotsipanua penacobetoxotsivi. ");
INSERT INTO guh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dioso jane xaniavaetsia patonacuenebavanapare. Nexata Diosojavabelia ayaijava pexaniacuene paxainaename athëbëtatsia. Nexata bajarajotatsia apo pacatobijianae tsane piucubaxaevi. Apo pacatotasibitsinua tsane. Penacobetoxotsivi ata apo pacatonacobetoxotsi tsane. ");
INSERT INTO guh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Panacuatatsia pacatoxaniavaeta panexainaejavanexa, bajarapanacua panejamatabëëthëtovetsina pajamatabënajinavanapaename, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Lámparabë bo ënëtuatuajëta itayoteca xaniavaetsia vajataenexa. Bajara pijinia itsi paneitaxuto ata. Paneitaxutoxanepanaexae xaniavaetsia panatsivajënaetaneme. Itsa paitaxutobejemë tsipae, nexata xaniavaetsia apo panatsivajënaetaemë tsipae. Pacatsitaaitaquiri saya tsipae. Bajara pijinia itsi panejamatabëcuene ata. Dioso itsa pacajamatabëcueneitayota, pajitsipaename paneexanabiabinexa pacuenia Dioso pacaitoroba. Nexata xaniavaetsia pajinavanapaename. Itsa panajamatabëxainaejitsipame bitso panexainaejava ëpaxamënexa, nexata bitso pajamatabëcueneitaquirimë tsipae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Itsajivi ata acuenebi caecuenia petonacuenebijava anijanëbeje pijatuxanenëbejejavabelia. Caenëjavabelia, ponë jitsipa petonacuenebinexa, tonacuenebijitsipa. Ponëjavabelia apo jitsipae petonacuenebijava, apo tonacuenebi tsipae. Bajara pijinia itsi pajivi bitso jitsipa Dioso. Pajivi bitso jitsipa Dioso, nexata itsa tonacueneba Dioso, acuenebi bitso pejitsipaejava palata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pëtsa pasivanajamatabëxainame ëpanexaejava, ëpaneapaejava ata, panevënajinavanapaenexa. Pëtsa pasivanajamatabëxainamenua ëpanenaxatabijavanexa ata. Apo jinavanapaetsi cajena ëvajaxaejavanexa. Apo jinavanapaetsinua ëvajanaperabëxatabinexa. ");
INSERT INTO guh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pataema baratsuimonae pepunaevi. Apo ubi pexaejavanexa. Apo notsinua penaveretaponaejava peetsinexa bota. Itsiata Dioso, paneaxa, athëbëtatsia peecaenë, rajutabiaba pexaejavanexa. ¡Paxamë rabiji bitsoyo Dioso pacaasiva baratsuimonae matatoxenetsia papecarajutsinexa daxita xua panamatavenoname! Bajaraxuata pëtsa bitso pasivanajamatabëxainame ëpanexaejavanexa. ");
INSERT INTO guh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Detsa jane ponë paxamëyajuvënënë caëjëpatsi pijacujiruta medio metrocuenia matavëjëa penavitsabiaexanaenexa? Ajibi. Bitso jamatabëbëjai ata tsipae pevitsabinexa, itsiata apo navitsabiaexanae tsipae pijacujiruta. ");
INSERT INTO guh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Bajaraxuata pëtsa bitso pasivanajamatabëxainame ëpanenaxatabijavanexa. Pacanaëjëre pacuenia vitsabapona pematono vayafojava. Bajarapamatono apo natsijumanacuenebi. Penaxatatsijavanexa ata apo natsijumaexanae. ");
INSERT INTO guh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bajayata nacuaevetsinëmi Salomónpijinë, bitso pexainaenëmi. Naitabëtsiaya naxatababiaba bitso pexaniaviriajavanë. Itsiata baitsi jane Salomónpijinë penaitabëtsijava matatoxenetsia bitso aitabë mapamatonotoxije. ");
INSERT INTO guh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Paxamë bevelia panejumecovënëtsivi Dioso, asaëya bepajumecovënëtame Dioso papecaevetsijava. Ajena pitsijavata vayafota tanetsi pexaniaponamatonotoxi. Bajaraxuacujinae, caematacabibejecujinae, tajuatsi baja bajarapaponamatonotoximi. Pacuenia Dioso aitabëyaexana ponamatonotoxi, bajara pijinia pacuenia paxamë ata Dioso pacaxatabiana piaitabëjava itsa pajumecovënëtame Dioso. ");
INSERT INTO guh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bajaraxuata pëtsa jamatabëbëjaiya pajamatabëjumaitsimë: “¿De tsaeta xua xaenatsi? ¿De tsaeta xua matavëjëa apaenatsi? ¿De tsaeta xua naxatabianatsi?” pajamatabëjamë pëtsa. ");
INSERT INTO guh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pamonae Dioso apo pejumecovënëtsivi, bajarapacuenia bitso sivanajamatabëxainabiaba ëpexaejavanexa, ëpenaxabijavanexa ata. Itsiata baitsi jane paneaxa paxainame, athëbëtatsia peecaenë. Bajaraponë yapëtane daxita xua panamatavenoname. ");
INSERT INTO guh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bajaraxuata, daxita xua panamatavenoname, matatoxenetsia, Dioso pijacuene bitso pasivanajamatabëxainabiabianame panetoexanavanapaenexa pacuenia Dioso pacaitoroba. Nexata Dioso pacarajutsiana daxita xua panamatavenoname. ");
INSERT INTO guh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Itsa baja pajamatabëcuenebëjamë ajena pitsijavata itsacuenejavayo yabara, pëtsa caecuenia payajavajamatabëcuenebëjamë xua yabara meravia pitsijavata pacatocopiapatsijitsia. Tsipaji xua caematacabi canacujitsia nacatocopiapatabiaba vajajamatabëcuenebëjainexa, ayaijava baja tsabiabi. Bajaraxuata ajena pitsijavata apo besivajamatabëcuenebëjaitsi xua meravia pitsijavata nacatocopiapatsijitsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pëtsa panataneme pepacuene bepaneaneconijibivi. Nexata itsamonae pibisiacuene pexanaejava xaniavaetsia payapëtaenejevamë, pëtsa pabaracuaicuaijamë mapacueniaje: “Bajarapitsipibisiacuene pexanaevi, Dioso bitso ayaicuenia naneconitsiaexanaenatsi,” pajamë pëtsa. Tsipaji paxamë ata pijinia bajarapitsineconi itsa paxainame, Dioso bitso ayaicuenia pacananeconitsiaexanaejitsipa. ");
INSERT INTO guh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Itsamonae pexanaejava xaniavaetsia payapëtaenejevamë, pëtsa pabaracuaicuaijamë mapacueniaje: “Bajarapitsicuene pexanaevi Dioso naneconitsiaexanaenatsi,” pajamë pëtsa. Tsipaji paxamë ata bajarapitsicuene itsa paexaname, itsamonae pijinia bajarapacuenia pacabaracuaicuaijai tsipae. ");
INSERT INTO guh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bajaraxuata paxamë pepacuene bepaneaneconijibivi nataeya pëtsa pamuxujiobame itsajivi pijaneconi yabara. Tsipaji raja apo payapëtaemë paxamë ata pijinia paneconivajëto paxainame. ");
INSERT INTO guh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nexata paxamë ata ayaineconixaneto itsa paxainame, nexata itsajivijavabelia apo bepajumaitsimë: “Papibisiacuene exaname, copare baja,” apo bepajamë. ");
INSERT INTO guh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yamaxëitojorobiaya saya bepexaniajamatabëcuenevi nataeya pacuaicuaijamë tsabiabi. Itsamonae pijaneconi yabara pabaracuaicuaijamë tsabiabi. Itsiata pijinia paxamë ata paneconivajëto paxainame, apo payapëtaemë. Paxamë copiaya pacopabare pibisiacuene paneexanabiabijava. Bajara jane xuacujinae paitavetsianame itsamonae ata pibisiacuene pexanaejava pecopabinexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pëtsa matavëjëa patsipaebaponame Dioso pejumelivaisi, pamonae patsipaebi atamë, apo yaiyatae bajarapalivaisi. Tsipaji saya capocaponabiaba bajarapalivaisi. Vaxaitsi itsanë pijaaviri pexaejavanexa rajutsi atatsi tsipae, saya nacaitoya tsipae. Nacasinijitsipanua. Bajara pijinia jamatabëcueneitsi pamonae apo yaiyatae Dioso pejumelivaisi, patsipaebi atamë. Pacuenia marrano ata itsa rajutsipatsi perlavënëjava, bitso penamatamotsijava, saya taxunanonobijitsipa, bajara saya jamatabëcueneitsi bajarapamonae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pavajëtaponare Diosojavabelia bajayajebi ata pacuenia bajayajebi ata pajaitsipame panecaxitajarabinexa itsa pacatonaxuaba itsacuenejavayo. Pavajëtaponare Diosojavabelia asaëyata pacuenia asaëyata padocodocotsipame baupa papecatobaupatsinexa itsa baupa xatatanuta. ");
INSERT INTO guh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bajarapacuenia asaëyata pavajëtaponare Diosojavabelia tsipaji pajivi vajëtabiaba, rajutabiabatsi. Pajivi ata jaitabiaba, caxitajarababiaba. Pajivi ata baupa docodocotabiaba, tobaupatabiabatsi. ");
INSERT INTO guh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Paxamë papebijivimë panexi panexainaevi. Panexënatonëyo itsa pacavajëta panbë, apo panacoxirajutsimë tsipae iboto. ");
INSERT INTO guh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Itsa pacavajëta dujuainëyo, apo panacoxirajutsimë tsipae jomo. ");
INSERT INTO guh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Paxamë paneajamatabëcuenebejevi ata, payapëtaneme panenacoxirajutsinexa pexaniajava. Paneaxa, athëbëtatsia peecaenë, bitso biji cajena pexaniajamatabëcuenenë paxamë matatoxenetsia. Bajaraponë pacarajutsiana pexaniacuene itsa pavajëtame. ");
INSERT INTO guh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Xua pexaniacuene, paxamë pajitsipame itsamonae papecatoexanaenexa, copiaya paxamë bajarapapexaniacuene patoexanare bajarapamonaejavabelia. Bajarapajamatabëcuene jëpa Dioso Moiséspijinëta penajumecopatsilivaisi. Diosojumepaebivimi profetavi peyaquinaelivaisianë ata jëpa bajarapajamatabëcuene, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pajonemeya tsiquiribaupayojavalia panepatsinexa Dioso pijanacuayabelia. Tsipaji pinijibaupa, pinijinamutonua, pata infiernojavabelia. Nexata jivi ayaibitsaëtoxanetonë bajaraxuayo jonepona. ");
INSERT INTO guh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pabaupa tsiquiribaupayo, tsiquirinamutoyonua, bajarapanamuto pata matacabi apo pevereverecaejava pexainaevi pijanacuayabelia. Nexata saya caejiviyobeje bajaraxuayo jonepona, jai Jesús pijajivijavabelia petsutoyenepanajavata. ");
INSERT INTO guh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Xania panayajivitaema. Pamonae saicayacuenia Dioso pejumelivaisivecua jivi tsipaebapona, bajarapamonae najumetsënëtsiaya pacajumai tsabiabi: “Paxanë raja Dioso patanitorobicuenia livaisi jivi patsipaebaponajë,” pacajai tsabiabi. Bajarapamonae Dioso pejumecovënëtsivi cuenecataeya najonena paxamëjavaberena. Itsiata baitsi jane pacuenia nevëthë pianaepanaevi jamatabëcueneitsi, bajara jamatabëcueneitsi. Jamatabëpacacopatsiaexana Dioso panejumecovënëtsijavami. ");
INSERT INTO guh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vaxaitsi rabaja yapëtanetsi mapacueneje. Peubinaenë itsa nacuaita, yapëtanetsi ponaecuai xanepana vajaxaenexa. Nexata bajaraponae cuaixanetsi. Ponae pijinia pibisiacuai nacuaita, yapëtanetsi piabejecuene. Nexata bajaraponae apo cuaixaetsi. Nexata pacuenia peubinaënë itsa nacuaita, nayapëtane ponaecuai xanepana vajacuaixaenexa, bajara pijinia pacuenia paxamë payapëtaename pacuenia jamatabëcueneitsi bajarapamonae itsa pacuenetaename xua exanavanapa. Uvaru apo paucutsimë cucunanaeta. Higovënëcuaito ata apo paucutsimë jomovaënaeta. ");
INSERT INTO guh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nexata ponae pexanianae, pexaniacuai pijinia nacuaita vajaxaenexa. Ponae pijinia pibisianae, ëpiabejecuai nacuaita. ");
INSERT INTO guh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pexanianae pexaniacuai nacuaita. Apo nacuaitsi piabejecuai. Pibisianae pijinia apo nacuaitsi pexaniacuai. ");
INSERT INTO guh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daxita ponaenë nacuaita pibisiacuai, apo vajaxaecuai, yapëtanetsi. Nexata daxita bajaraponaenëmi nicatatsi. Nexata tajuitatsi isotota. ");
INSERT INTO guh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bajara pijinia pacuenia paxamë ata payapëtaename itsa pacuenetaename xua exanavanapa pamonae saicayacuenia Dioso pejumelivaisivecua jivi tsipaebapona, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Daxita pamonae: “Tajatuxanenë,” tanejaivi ata, itsa apo jumecovënëtsi tsane taxa Dioso, athëbëtatsia peecaenë, nexata apo jone tsane taxa Dioso pijanacuayabetsia. Itsiata pamonae exanavanapa taxa, athëbëtatsia peecaenë, pejitsipaecuenia, ëbajarapamonae jonena taxa pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pamatacabi copiapatsiana pijaneconi pexainaevi Dioso penaneconitsiaexanaematacabinexa, bajarapamatacabi jivi ayaibitsaëtoxanetonë nejumaitsi tsane: “Patajatuxanenë, xamë baja cajena nejamatabëcueneta jivi patsipaebabiabajë Dioso pejumelivaisi. Nevënëtanua dovathi jivivecua pacapitsapaponajë. Nevënëtanua pinijicuene pataexanaejavanë, Dioso pesaëta paexanaponajë,” nejai tsane jivi ayaibitsaëtoxanetonë. ");
INSERT INTO guh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Itsiata baitsi jane xanë jumaitsinë tsane bajarapamonaejavabelia: “Apo pacayapëtaetsi cajena paxamë. Panevecuaponare pibisiacuene paneexanabiabivi,” janë tsane bajarapamonaejavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús icatsia jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pajivi nejumecovënëtsiana patacatsipaebilivaisi, nexata itsa exanaena taitorobicuenia, apo nacueratsi tsane. Bajarapajivi piatajairata pijabo bepexanetsinë tsane. Tsipaji ponë pijabo exanaejitsia, peyapëtaexae itsajota pijabo exanetsijitsia pebubutsijavanexa, nexata baja bajarajota apo exanetsi pijabo. Nexata pijabo exaneta bitso piatajairata. Nexata bajaraponë bo pexanaejava apo nacueratsi. ");
INSERT INTO guh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bo peveretetsicujinae ayaiemaxaneto jopa. Menianë avajubua tsaponae. Ira bubuta. Ayaijovibo bitso bubujai pijabojavaberena. Itsiata pijabo apo toxuabitsitsia. Tsipaji pijabo exaneta piatajairata. ");
INSERT INTO guh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pajivi nejumetae ata patacatsipaebilivaisi, apo nejumecovënëtsi tsane, nexata itsa apo exanae tsane taitorobicuenia, bajarapajivi nacueratsiana. Pacuenia tajetabota bo pexanetsinë nacuerata bo pexanaejava, bajara itsi tsane. Ponë tajetabota pijabo exaneta, yapëtae ata emarapae pecopiapatsijavanexa, bajaraponë nacuerata bo pexanaejava. ");
INSERT INTO guh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsipaji bo peveretetsicujinae ayaiemaxaneto jopa. Menianë avajubua tsaponae. Ira bubuta. Ayaijovibo bitso bubujai pijabojavaberena. Pijabo nexata toxuabayatsi. Pepacuene baja nexata bomi abeje, jai Jesús mapacueniaje pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Itsa baja Jesús najumevereta petsutoyenepanajavata bajarapalivaisi petsipaebijava, pejumetaevitsi bitso jamatabëcuenenabenajaca. ");
INSERT INTO guh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús pejumetaevitsi bitso jamatabëcuenenabenajaca tsipaji Jesús livaisi tsipaeba pinijijamatabëcuene pexainaenëcuenia. Apo tsipaebi pacuenia judíovi pecujarubivi tsipaebabiaba. ");
INSERT INTO guh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Itsa baja Jesús runaica petsutojumavetsica, jivi ayaibitsaëtoxaneto pënaponatsi. ");
INSERT INTO guh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nexata imoxoyotatsi bajayajebi bitso peperabëtsabanaenë. Pitabarata pematabacabëta tonucatsi. Bitso peperabëtsabanaenë jumaitsi Jesúsjavabelia: —Jesús, cacaëjëpa raja tanejamatejemayaexanaenexamë. Itsa jitsipame, nejamatejemayaexanare mapavitanevecuaje, jai bitso peperabëtsabanaenë. ");
INSERT INTO guh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nexata Jesús pecobeta perabëjayalia bitso peperabëtsabanaenë. Jesús jumaitsi bajaraponëjavabelia: —Jãjã, jitsipajë cajena. Jamatejemamë rabaja, jai Jesús bajayajebi bitso peperabëtsabanaenëjavabelia. Bajarapacuenia Jesús pejumaitsijavata peperabëtsabanaenëmi baja perabëxanepananajereca. ");
INSERT INTO guh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nexata icatsia Jesús jumaitsi bajaraponëjavabelia: —Nejumetaema. Pëtsa tsipaebame itsajivijavabelia ata tacajamatejemayaexanaejava. Naitajëtsiaremelia jane sacerdotenëjavabelia, templobota penacuenebinëjavabelia. Nexata jivi yapëtaena pepacuene baja pecavecuaajibijava niavitanejavami. Diosonexa rajuremelia ofrenda sacerdotenëjavabelia pecavecuaajibiaexanaexae niavitanejavami. Bajara tsipaji pacuenia bajayata vajasalinainëmi Moiséspijinë nacaitoroba. Nexata sacerdotenë cataena pecavecuaajibijava baja niavitanejavami, jai Jesús bajaraponëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Itsa baja Jesús pata Capernaum tomarabelia, Romano nacuapijivajabitsaëvi pijacapitán Jesús imoxoyorenatsi pevajëtsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Vajabitsaëvi pijacapitán bitso ayaicuenia vajëta Jesúsjavabelia. Jumaitsi: —Petuxanenë, tajajivitonë raja tajabota camata boboca. Bitso cuenabatsi. Pinijicuenia navixaetaeyabiaba, jai. ");
INSERT INTO guh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nexata Jesús jumaitsi capitánjavabelia: —Xanë ponaenajë nijaboyabelia. Nexata catojamatejemayaexanaenatsi nijajivitonë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nexata capitán jumaitsi Jesúsjavabelia: —Petuxanenë, xanë raja bitso beveliajamatabëcuenenënë xamëvecua. Nexata apo xanepanae tsipae nejonejava tajaboyabelia. Nexata saya maveliaje ënijume itorobare. Nexata tajajivitonë netojamatejema tsane. ");
INSERT INTO guh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xanë ata xainajë taneitorobabiabivi taneitorobicuenia tajumecovënëtabiabinexa. Xanë ata juya xainajë vajabitsaëvi tajajivi taitorobicuenia tanetoexanabiabinexa. Nexata itsa itorobajë caenë vajabitsaënë peponaenexa, bajaraponë ponabiaba. Itsa junarenajë itsanë vajabitsaënë pepatsinexa xanëjavaberena, bajaraponë patabiabarena. Itsa itorobajë tajajivitonë tanetoexanaenexa itsacuenejavayo, nexata netoexanabiaba. Bajara pijinia pacuenia xamë ata nexanaenexa cacaëjëpa. Nexata saya maveliaje ënijume itorobare saya ënijumeta tajajivitonë tanetojamatejemayaexanaenexamë, jai capitán Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús itsa jumetane bajarapacuenia capitán pejumaitsijavatsi, nexata Jesús jamatabëcuenenabenajaca. Nexata Jesús jumaitsi pepënaponaevitsijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Israel nacuapijivi nejumecovënëtsi ata, itsiata caeto ata apo caxitajarabaxuabinë xanëjavaberena bitso tanesivanajamatabëcuenecopatsinë pacuenia mapacapitán nesivajamatabëcuenecopatsiaya jumaitsije. ");
INSERT INTO guh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nexata pacatsipaebatsi paneyapëtaenexa. Apo judíovi ata raja, ayaibitsaëtoxanetonë daxitanacuanëpijivi, Dioso jumecovënëtsiana. Nexata apo judíovi ata capanepaenatsi Dioso pijanacuayabetsia. Nexata bajarapamonae Dioso pijanacuatatsia, Abrahampijinë yajava, nabaniana. Isaacpijinë ata, Jacobpijinë ata yajava, nabaniana. ");
INSERT INTO guh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Itsiata baitsi jane judíovi, pamonae picani Dioso athëbëtatsia toxaniavaetatsi peyajavajinavanapaenexatsi, bajarapamonae caranata apo jumecovënëtsi Dioso. Nexata bajarapamonae infiernojavabelia Dioso xuabianatsi. Bajarajota nuena. Navonosiniana bitso penavixaetaexae, jai Jesús mapacueniaje pepënaponaevitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nexata icatsia Jesús jumaitsi capitánjavabelia: —Ponare baja nijaboyabelia. Catoexanatsi rabaja pacuenia xanëjavaberena nesivanajamatabëcopatsiaya jumaitsimë tacatoexanaenexa, jai Jesús capitánjavabelia. Nexata bajarapaepatota capitán pijabotalia pijajivitonë baja tojamatejematsi. ");
INSERT INTO guh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús pona Pedro pijaboyabelia. Nexata Pedro pijabota Jesús taeyabuata Pedro pijava pena peromaebanucaejavatsi camata. ");
INSERT INTO guh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nexata Jesús cobejayata peromaebanucaevatsi. Jesús pecobejayatsijavata, bajarapova vecuaajibitsireca baja domae. Nexata baja bajarapova jamatejema. Jesúsbana pexaejava bajarapova toexanatsi. ");
INSERT INTO guh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Itsa baja ajena meravitsia, Jesúsjavaberena tocapatatsi ayaibitsaëto dovathi peyajavajinavanapaevi. Caejumeta saya Jesús caecuenia dovathi vecuacapitsapa bajarapamonae. Bajarajota jamatejemayaexananua daxita piavitanevi. ");
INSERT INTO guh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bajarapacuenia Jesús itsa exana, copiapata jane baja pacuenia Jesús yabara bajayata Diosojumepaebinëmi profeta Isaíaspijinë tajëvelia vajunupaeba. Profeta Isaíaspijinë bajayata tajëvelia jumaitsi mapacueniaje: “Bajaraponë nacavecuaajibiaexanaena vajaavitanejavami,” jai bajayata tajëvelia Isaíaspijinë Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nexata Jesús itsa tane jivi ayaibitsaëto pematatoyoronaejavatsi, pijajivi junata pepënaxuabinexatsi pucaxaneto itsapanabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nexata bajarapaepatota judíovi pecujarubinë Jesús imoxoyorenatsi. Judíovi pecujarubinë jumaitsi Jesúsjavabelia: —Petuxanenë, itsabelia poname, capënaponaenatsi cajena, jai. ");
INSERT INTO guh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nexata Jesús jumaitsi judíovi pecujarubinëjavabelia: —Itsa nepënaponaejitsipame, apo napatabiabimë tsipae tajabota nenacueraevetabiabinexa. Tsipaji tajabo apo xainaenë. Namo pijamëthëanë xaina pepatabiabinexa pemajitabiabinexa. Baratsui ata pematapenanë xaina. Itsiata baitsi jane xanë, Daxitajivi Pematapijinënë, itsajavabelia ata apo xainaenë itsajota nacueraevetabiabijitsianë, jai Jesús judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nexata Jesús pijajiviyajuvënënë jumaitsi Jesúsjavabelia: —Tajatuxanenë, caeepatoyo abaxë necopare tamëthëtsinexa taxa petëpaenë, jai. ");
INSERT INTO guh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús nexata jumaitsi pijajivitonëjavabelia: —Naxanitsia. Nepënaponare. Copare matacabi apo pevereverecaejava apo pexainaevinexa pemëthëcaenexatsi nijamonaemi itsa tëpa, jai Jesús pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús, pijajivi yajava, runa jera ënëabereca. Nexata Jesús pijajivi jerata yajavanajetaruca pucajava. ");
INSERT INTO guh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nexata jemata pinijijoviboxaneto najetaruca. Malatacaxanetonë bitso ayai. Nexata malataca jera ënëaberena mera epabajarabapona. Itsiata Jesús jamatejema majitanuca. ");
INSERT INTO guh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nexata Jesús pijajivi yaitavabatsi pemajitanucaenë. Jesús pijajivi jumaitsi: —¡Patajatuxanenë, panecapanepare! ¡Vaxaitsimi rabaja yaothopaenatsi! jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia bitso pajunavame? ¿Tsipaji apo payapëtaemë Dioso papecaevetsijava? jai Jesús pijajivijavabelia. Nexata Jesús namatacotapuna. Pinijijumeta itavetaxuaba jovibo, malataca yajava. Nexata baja daxita puca vainae ecaxuaba. ");
INSERT INTO guh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nexata Jesús pijajivi itsa tane bajaraxua, jamatabëcuenenabenajaca. Nexata Jesús pijajivi najumaitsi: —¿De meta tsipaji maponëje? ¡Itaveta jovibo, malataca yajava! ¡Jumecovënëtatsi baja rovia maponëje! ¡Nexata baja jovibo, malataca yajava, ajibi tsaxuabi! najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús pijajivi barëpata pucaxaneto itsapanabelia, Gerasa nacuayabelia. Jesús itsa pata Gerasa nacuata, Gadara tomarapijinëmibeje pitsaparenabeje jivimëthëanëjavaverena. Imoxoyorenatsibeje Jesús. Bajaraponëbeje dovathivi peyajavaponaponaenëbeje. Bitso anaepanabiababeje. Nexata itsajivi ata apo ponabiabi bajaraxuayo perucaenamutojava. ");
INSERT INTO guh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nexata dovathivi peyajavaponaponaenëbeje vavajaibeje. —Jesús, Dioso pexënatomë, ¿detsa xua namatavenoname paxanëbejejavaberena? ¿Dioso tsaja daxitajivi penaneconitsia exanaematacabinexavajënaeya patame patanenaneconitsiaexanaenexamëbeje? jaibeje Jesúsjavabelia dovathivi peyajavaponaponaenëbeje. ");
INSERT INTO guh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nexata bajarajota, imoxoyo petsutojavata, marranobitsaëtoxaneto xaevanapa. ");
INSERT INTO guh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nexata dovathivi bitso vajëca Jesúsjavabelia. Jumaitsi: —Itsa panexuabijitsiamë maponëbejevecuaje, panetocopare patajonenexa marranobitsaëtoxanetojavabelia, jai. ");
INSERT INTO guh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nexata Jesús jumaitsi dovathivijavabelia: —Paponare baja panejonenexa marranobitsaëtoxanetojavabelia, jai. Nexata bajaraponëbeje dovathivi vecuapitsapatsibeje. Nexata baja marranobitsaëtoxanetojavabelia junua dovathivi. Nexata daxita bajara pamarranobitsaëtoxanetomi cujinaeyeca. Pucaxaneto itapajanituareca othopareca. Bajarajota daxita marranobitsaëtoxanetomi meneta bubuna. ");
INSERT INTO guh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bajara pamarranobitsaëtoxanetomi pevetavanapaevi, rëcëpeca. Itsa bajarapamonae Gadara tomarabelia pata, tsipaeba pacuenia tane. Tsipaebanua pacuenia Jesús dovathivi vecuacapitsapa dovathivi peyajavaponaponaenëbeje. ");
INSERT INTO guh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nexata daxita bajarapatomarapijivi ponarena Jesúsjavaberena. Nexata itsa tanetsi Jesús, daxita bajarapamonae jumaitsi Jesúsjavabelia: —Pexaniacuene pacavajëtatsi. Ponare baja patajanacuavecua, jai bajarapamonae Jesúsjavabelia tsipaji cujunavatsi. ");
INSERT INTO guh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús runareca jera ënëabereca. Nicabalia puca itsapanabelia. Pata nexata pijatomarabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bajarajota Jesús tocapatatsi petabusipacuenabinëtsi. Pacamayota bocabiaba, yavëtacarapatatsi. Jesús jamatabëcueneyapëtane pacuenia sivanajamatabëxainatsi petocapatsivitsi. “Nacatojamatejemayaexanaenatsi cajena,” pesivajamatabëjaijavatsi Jesús jamatabëcueneyapëtane. Bajaraxuata petabusipacuenebinëtsijavabelia Jesús jumaitsi mapacueniaje: —Tajabananë, jamatabëcuenebarëyamëre. Pibisiacuene rabaja nexanaeneconimi cavecuaajibiaexanatsi, jai Jesús petabusipacuenabinëtsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nexata judíovi pecujarubivi itsa jumetaeyena bajarapacuenia Jesús pejumaitsijava, najamatabëxainena. —Maponë Jesúsje Dioso apo pejitsipaecuenia cuaicuaijai, jamatabëjai tsenae judíovi pecujarubivi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús jamatabëcueneyapëtane judíovi pecujarubivi bajarapacuenia pesivanajamatabëxainaejavatsi. Nexata Jesús jumaitsi judíovi pecujarubivijavabelia: —Panesivanajamatabëxainame xanëjavaberena pibisiajamatabëcuene. ");
INSERT INTO guh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Paxamë apo pacacaëjëpae ata itsajivi pibisiacuene pexanaeneconi panevecuaajibiaexanaenexa, pacacaëjëpa picani saya jema panejumaitsinexa petabusipacuenebinëtsijavabelia mapacueniaje: “Cavecuaajibiaexanatsi rabaja pibisiacuene nexanaeneconimi,” panejainexa. Tsipaji itsajivi ata apo yapëtae tsipae saya jema panejumaitsijava. Itsiata baitsi jane itsa apo pacacaëjëpae panejamatejemayaexanaenexa petabusipacuenebinëtsi, acuenebi panejumaitsinexa bajaraponëjavabelia mapacueniaje: “Nonotapunare. Nijacamayo pire. Ponare baja,” panejainexa. Tsipaji bajarapacuenia pajumaitsimë ata, itsa apo jamatejema tsipae bajaraponë, nexata daxitajivi pacayapëtaejitsipa apo papecacaëjëpaecuene panejamatejemayaexanaenexa, jai nexata Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Icatsia Jesús jumaitsi judíovi pecujarubivijavabelia: —Xanë Daxitajivi Pematapijinënë, mapanacuata necaëjëpa tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata pacuenia baja exanajë maponëjavabeliaje. Nexata patanecueneyapëtaenexamë tanecaëjëpaecuene tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata, pataema pacuenia jamatejemayaexanaejitsianë maponëje, jai Jesús judíovi pecujarubivijavabelia. Nexata icatsia Jesús jumaitsi petabusipacuenabinëtsijavabelia: —Nonotapunare baja. Nijacamayo pire. Nijaboyabelia baja ponare, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nexata bajarapacuenia Jesús pejumaitsijavata, petabusipacuenabinëmitsi nonotapuna. Pijaboyabelia baja pona. ");
INSERT INTO guh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nexata jivi itsa tane bajaraxua, junava cajena bitso. Nexata bajarapamonae jumaitsi Diosojavabelia: —Diosomë, bitso ayaijamatabëcuenenëmë. Tsipaji jivi caëjëpaeyaexaname pinijicuene pexanaenexa, jai. ");
INSERT INTO guh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús baja vecuapona itsajota jamatejemayaexana petabusipacuenabinëtsi. Nexata Jesús penajetarucaejavata taeyeta Mateo. Mateo gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabinë. Pabota jivijavabelia Mateo impuestomatamo matamoyanijobabiaba, bajarapabota eca Mateo. Nexata Jesús jumaitsi Mateojavabelia: —Mateo, nepënaponare, jai. Jejai Mateo. Nexata nonotapuna. Mateo baja napona Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nexata Mateo junata Jesús pebarënabaninexa pijabota. Nexata Mateo pijabota Jesús pexaejava naxane. Mateo pijabota naena ayaibitsaëto gobierno pejamatabëcuene jivijavabelia impuestomatamo petomatamoyanijobivi. Itsamonae ata nanabane, piajamatabëcuenebejevi. Jesús pijajivi nayajavaeca bajarapamesajavata. ");
INSERT INTO guh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nexata fariseovi itsa tane bajarapacuene, jamatabëcuenenavëxaniabiaya jumaitsi Jesús pijajivijavabelia: —Papecacujarubinë rabaja Jesús naneconita Diosojavabelia. Tsipaji gobierno pejamatabëcueneta impuestomatamo pematamoyanijobabiabivijavata, piajamatabëcuenebejevijavatanua, naxaeyeca pexaejava, jai fariseovi Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús nexata jumetaeyeca bajarapacuenia fariseovi pejumaitsijava. Nexata Jesús jumaitsi fariseovijavabelia: —Pevaëbinë raja apo vaëbi pejamatabëjemavi. Pevaëbinë raja piavitanevi vaëba. Bajara pijinia xanë ata itsinë. Sivapatajopajë tajunatsinexa pibisiajamatabëcuenevi pecapanepaenexatsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Paponare. Palebianame Dioso pejumelivaisibaxuto. Nexata payapëtaename pajamatabëcuene yabara jumaitsi Dioso pejumelivaisibaxutota mapacueniaje: “Jitsipajë paneitaxutotsoniataejava itsamonae. Apo jitsipaenë saya patanetobeyabiabijavamë dajubicuene ofrendacuenia patanerajutabiabinexamë,” jai Dioso pejumelivaisibaxutota. Xanë raja apo sivapatajopaenë tajunatsinexa pamonae baja aneconijibi tsavanapae. Biji rajane sivapatajopajë tajunatsinexa pijaneconi pexainaevi. Junataponajë bajarapamonae pecopabinexa pibisiacuene pexanaejava penajamatabëcuenepënëyorotsinexa Diosojavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan pijajivi Jesús imoxoyorenatsi. Nexata Juan pijajivi jumaitsi Jesúsjavabelia mapacueniaje: —Petuxanenë, paxanë pataxaejava apo paxaeyabiabinë pamatacabibeje pavajëtaponajë Diosojavabelia. Bajara pijinia itsi fariseovi ata pamatacabibeje vajëtapona Diosojavabelia. Pexaejava apo xaeyabiabi. ¿Detsa xuajitsia xamë nijajivi pamatacabibeje vajëtapona Diosojavabelia pexaejava xaeyabiaba? jai Juan pijajivi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nexata Jesús jumaitsi Juan pijajivijavabelia: —Pamonae junatatsi penacasabifiestajavabelia penanabaninexa, apo atsobi pexaejava itsa abaxë yajavaecatsi pejananacasabinë. Itsiata baitsi jane pejananacasabinë itsa tsimaxëpatsipatsi pevecuacaponaenexatsi itsajavabelia, nexata bajarapamonae pexaejava apo xae tsipae. Tsipaji bitso najamatabëxainaejitsipa pevecuacaponaexaetsi. Bajara pijinia itsi tajajivi ata. Tayajavaponaponaeepato abaxë apo atsobabiabi pexaejava pamatacabibeje Diosojavabelia vajëtapona. Itsiata pamatacabi xanë necaponaena bajarapamonaevecua, nexata jane baja bajarapamatacabi pexaejava apo xae tsane bitso tanesivanajamatabëxainaexae, jai Jesús Juan pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nexata Juan pijajivi perujujamatabëcuene baja penavecuacopatsinexa, Jesús livaisi tsipaeba comparacióncuenia, Juan pijajivi pejumecovënëtsinexa ëpejanalivaisi, Jesús petsipaebilivaisi. Juan pijajivi anijajamatabëcuenebeje pexainaeyaniva, perujujamatabëcuene baja pecopabinexa, Jesús livaisi tsipaeba comparacióncuenia. Perujujamatabëcuene yabara Jesús jumaitsi Juan pijajivijavabelia mapacueniaje: —Itsajivi ata raja apo catsatarutsi pejanapana perujunaxatatsiesetojavabelia. Itsa catsatarutsipa pejanapanata perujunaxatatsiesetojavabelia, nexata pejanapana yanarobotsipa perujuesetojavaverena. Nexata biji bitso pinijivojoto titinaejitsipa. ");
INSERT INTO guh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Itsajivi ata pijinia apo epacae pejanavinoranë perujubocodoruanëjavabelia bajayajebi peyajebinexa. Pejanavinoranë itsa epacaejitsipa perujubocodoruanëjavabelia, nexata pejanavinoranë yatititibia tsipae. Tsipaji perujubocodoruanë apo yanayeretsi tsipae. Tsipaji pejanavinoranë pejumalitsëxë abaxë xaina. Nexata itsa yatititibia tsipae, naxuabijitsipa vinoranëmi. Bajaraxuata bepaca pejanavinoranë pejanabocodoruanëjavabelia. Nexata vinoranë peyaxanepanaenexa bajayajebi ata pejanabocodoronëta, jai Jesús Juan pijajivijavabelia. Bajarapacuenia Jesús jumaitsi Juan pijajivi pejumecovënëtsinexa ëpejanalivaisi, Jesús petsipaebilivaisi, perujujamatabëcuene baja pecopabinexa. ");
INSERT INTO guh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús livaisi petsipaebanucaejavata Juan pijajivijavabelia, judíovi penacaetuatabiabibo pevetsinë parena Jesúsjavaberena. Nexata bajaraponë Jesús pitabarata yaiyataeya pematabacabëta nucajunua. Jumaitsi Jesúsjavabelia: —Taxënatovayo rabaja aeconoxae netotëpa. Itsiata baitsi jane itsa poname tajaboyabelia, nexata itsa netoperabëjayatsianame necobeta, icatsia netoasaë tsane, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nexata Jesús nonotapuna. Judíovi penacaetuatabiabibo pevetsinë pepëta Jesús, pijajivi yajava, napona. ");
INSERT INTO guh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nexata Jesús namutua penajetarucaejavata, pepënëverena imoxoyotatsi petiriva, piavitaneva. Bajarapova pijanacuene pecapunaecujinaetsi doce baja pavaibeje xaina. Nexata bajarapova Jesús pepënëvelia ponataba, jivibitsaëtoxaneto tuatuajëjavalia. Nexata bajarapova tojayataba Jesús penaxatatsijavacopia. ");
INSERT INTO guh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bajarapacuenia tojayataba Jesús penaxatatsijavacopia tsipaji bajarapova jamatabëjumaitsi mapacueniaje: —Itsa tojayatabianajë Jesús penaxatatsijavacopia, nexata tavitanejavami nevecuaajibi tsane, jamatabëjai bajarapova. ");
INSERT INTO guh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nexata Jesús napënëyorotaxuaba. Taenuta bajarapova. Nexata Jesús jumaitsi bajarapovajavabelia: —Jamatabëcuenebarëyamëre. Xamë nesivajamatabëjumaitsimë: “Itsa tojayatabianajë Jesús penaxatatsijava, nexata tavitanejavami nevecuaajibi tsane,” nesivajamatabëjamë. Bajaraxuata jamatejemamë baja, jai Jesús bajarapovajavabelia. Bajarapacuenia Jesús pejumaitsijavata bajarapova jamatejema baja. ");
INSERT INTO guh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bajaraxuacujinae Jesús jane baja pata judíovi penacaetuatabiabibo pevetsinë pijaboyabelia. Nexata Jesús itsa pata, tane pevajënae pepatsivi, flauta piobivinexa itsabelia caponaejitsia petëpaevayo pemëthëtsinexa piobinexa. Tanenua jivi bitso pinijicuenia pematanueyabavanapaejava petëpaevayo. ");
INSERT INTO guh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Papitsapare mapabovecuaje. Pejanava raja apo tëpae. Saya raja majita, jai Jesús tsipaji yapëtane Jesús piasaëyaexanaejavanexa bajarapovayo. Nexata saya bajarapamonae Jesús jumecapocaponatsi bajarapacuenia pejumaitsijava. ");
INSERT INTO guh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús nexata bajarapamonae bovecua pitsapaeyaexana. Nexata itsaxuayolia petëpaevayo boca, Jesús joneya. Cobepita petëpaevayo. Bajarapovayo baja namatacota. ");
INSERT INTO guh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nexata daxita bajarapanacuapijivi Jesús vënëlivaisitanetsi piasaëyaexanaejava petëpaevayomi. ");
INSERT INTO guh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Itsa baja Jesús pona judíovi penacaetuatabiabibo pevetsinë pijabovecua, anijanëbeje bitso pitaxutotsëcënaenëbeje Jesús pënaponatsi. Bajaraponëbeje vavajaiya jumai tsaponaebeje Jesúsjavabelia: —¡Jesús, Davidpijinë pemomo, paneitaxutotsoniataemabeje! jaibeje tsaponae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Itsa baja Jesús joneya pabojavabelia pona, nexata bajaraponëbeje pënajoneyatsibeje. Nexata Jesús bajarajota jumaitsi bajaraponëbejejavabelia: —¿Payapëtanemebeje tsaja tanecaëjëpaecuene patacaitaxutoxanepanaeya exanaejavanexabeje? jai Jesús bitso pitaxutotsëcënaenëbejejavabelia. Nexata bitso pitaxutotsëcënaenëbeje jumaitsibeje Jesúsjavabelia: —Jãjã, payapëtanijibeje cajena, jaibeje. ");
INSERT INTO guh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nexata Jesús itaxutojayata bitso pitaxutotsëcënaenëbeje. Jesús jumaitsi bitso pitaxutotsëcënaenëbejejavabelia: —Pacuenia baja xanëjavaberena nesivanajamatabëcuenecopatsiaya panesivanajamatabëxainamebeje patacaitaxutoxaniavaetsinexabeje, bajarapacuenia pacatoexanatsibeje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nexata bitso pitaxutotsëcënaenëmibeje itaxutoxanepanabeje baja. Bajaraxuacujinae Jesús asaëya jumeitaveta bajaraponëbeje. Jumaitsi: —Pëtsa panavajunupaebamebeje itsamonaejavabelia patacaitaxutoxaniavaetsijavabeje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Itsiata saya ajena bajarapabovecua pitsapaliabeje, navajunupaebaponabeje. Pacuenia Jesús itaxutoxaniavaetatsibeje, navajunupaebaponabeje daxita bajarapanacuajava. ");
INSERT INTO guh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Itsa baja bovecua pitsapabeje ponëbeje Jesús itaxutoxanepanaeyaexana, bitso pitaxutotsëcënaenëmibeje, nexata icatsia itsamonae Jesús tocaparenatsi apo pecuaicuaijainë. Bajaraponë dovathi peyajavaponaponaenë. ");
INSERT INTO guh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nexata apo pecuaicuaijainë Jesús dovathi itsa vecuacapitsapa, cuaicuaijai baja xaniavaetsia. Nexata petaevitsi bitso jamatabëcuenenabenajaca. Najumaitsi bajarapamonae: —Caeto ata cajena Israel nacuata itsajivi ata apo tae mapitsicueneje, najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Itsiata baitsi jane fariseovi jamatabëcuenenavëxaniabiaya jumaitsi Jesús yabara: —Mara ponëje dovathi jivivecua capitsapabiaba dovathivi pepo penamatacaitorobinë pesaëta, jai fariseovi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús najetaruca daxita tomaranëjava, tsiquiritomaraxijava ata. Nexata bajarapatomaranëjava judíovi penacaetuatabiabibonëjava pexanialivaisi Jesús jivi tsipaebanajetaruca. Tsipaebanajetaruca daxita Dioso pijajivi pevetsijavanexa. Piavitanevi ata Jesús jamatejemayaexanapona, daxitaviriavitane pexainaevimi. ");
INSERT INTO guh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesús jivi itsa tane, itaxutobejiobiatane. Tsipaji jivi bitso baja cajena cuerana. Apo caëjëpaetsinua jivi penatoexanaenexa itsacuenejavayo ata. Jesús jivi sivajamatabëjumaitsi mapacueniaje: —Pacuenia itsi ovejabitsaëtoxaneto itsa toajibitsi pevetsinëtsi, bajara itsi mapamonaeje, sivajamatabëjai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nexata Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pabita peubijava penaveretsijava abaxë bitso ayaijava sajina penotsinexa. Tsipaji saya caejiviyobeje penotsivi. Bajara pijinia itsi jivi ata Diosojavabelia penajamatabëcopabivinexa. Abaxë sajina ayaibitsaëtoxaneto. Itsiata baitsi jane Dioso panetonacuenebivi pacaejiviyomëbeje saya. ");
INSERT INTO guh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bajaraxuata Diosojavabelia pavajëcabiabare icatsia itsamonae Dioso pijajivi pitorobinexa papecayavenonaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús pijajivi ayaibitsaëtoxanetoyajuvënëvi junata saya doce ponëbeje Jesús pebarënacaetuatsinexa. Jesús pijajivi pecaëjëpaejamatabëcuenetsi jamatabëcuenecaëjëpaeyaexana dovathi peyajavajinavanapaevi pevecuacapitsapaponaenexa, pejamatejemayaexanaponaenexanua daxitaviriavitane pecapunaevitsi. ");
INSERT INTO guh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mara doce ponëbeje Jesús pijajivi, apóstolevi, pevënëanëje. Itsanë pevënë Simón. Itsavënë bajaraponë Pedro. Itsanë pevënë Andrés, Simón pejuyapijinë. Itsanëbeje pijinia Santiagobeje Juanbeje nacaebananëbeje, Zebedeo pexënatobeje. ");
INSERT INTO guh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Itsanë pevënë Felipe. Itsanë Bartolomé. Itsanë Tomás. Itsanë Mateo, impuestomatamo gobierno pejamatabëcuene jivijavabelia petomatamoyanijobinëmi. Itsanë pevënë Santiago, Alfeo pexënato. Itsanë pevënë Lebeo. Bajaraponë itsavënë Tadeo. ");
INSERT INTO guh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Itsanë Simón, celotenë. Itsanë pevënë Judas Iscariote. Bajaraponë bexëajavabelia canajetsijitsiatsi Jesús pijavajabitsaë pecobeyabelia pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús pijajivi pitorobivajënaeya jumaitsi pijajivijavabelia mapacueniaje: —Pëtsa paponame apo judíovi pijanacuayabelia. Pëtsa paponame Samaria nacuata penaetomaranëjavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Paponare jane Israel nacuapijivijavabelia. Pacuenia ovejabitsaëtoxaneto pevetsinëtsi vecuanaxuabavanapa, bajara pijinia pacuenia Israel nacuapijivi Diosovecua naxuabavanapa. ");
INSERT INTO guh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Patsipaebanajetarubenaename bajarapamonae imoxoyo baja pevajënae pecopiapatsijavanexa Dioso pijajivi pevetsimatacabinexa. ");
INSERT INTO guh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pajamatejemayaexanaponaename piavitanevi. Pasaëyaexanaponaenamenua petëpaevimi ata. Pajamatejemayaexanaponaenamenua bajayajebi bitso peperabëtsabanaevi. Pavecuacapitsapaponaenamenua dovathi peyajavajinavanapaevi. Amoneya raja pacacaëjëpaeyaexanatsi bajarapacuenia paneexanaponaenexa. Bajaraxuata amoneya jivi pajamatejemayaexanaponaename. Pëtsa pamatamoyanijobame panejamatejemaya exanaejamatabëcuene, jai Jesús pijajivijavabelia pitorobivajënaeya. ");
INSERT INTO guh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jesús icatsia jumaitsi pijajivijavabelia pitorobivajënaeya: —Panijanamutonexa pëtsa pacaponame palata. ");
INSERT INTO guh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pëtsa pacaponame panijadoro ata. Saya pajumaponaename caenaxatatsi. Panenataxuxatatsijava ata, pataxunaponaename caejava. Naeboyo ata pëtsa pacaponame. Pamonaejavabelia livaisi patsipaebianame, pacarajutsiana panexaejava. Bajarapacuenia pacarajutsiana tsipaji pajivi xaniavaetsia itsanëjavabelia tonacueneba, bajarapajivi juya pexaejava barajutatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Itsa papatabiabianame pinijitomarata, tsiquiritomarayojavata ata, bajarajota pajaitabiabianame ponë peyaiyataenëtsi. Nexata bajaraponë pijabota pamajitabiabianame. Pëtsa panatixitaponame itsaboyabelia panemajitsinexa. Matapania icatsia itsajavabelia itsa paponaename, bajarapabovecua papitsapaename. ");
INSERT INTO guh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Itsa pabota papatsijitsiamë, ajena pajonejitsiamëlia, pajumaitsimë tsabiabi tsane: “Diosojavabelia raja pacatovajëtsijitsiatsi xaniavaetsia panejinavanapaenexa,” pajamë tsabiabi tsane. ");
INSERT INTO guh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Itsa bajarapabopijivi pacacopiapitsiana xaniavaetsia, nexata pacuenia Diosojavabelia patovajëtame, yavenonaenatsi Dioso. Itsiata baitsi jane itsa apo pacacopiapitsi tsane xaniavaetsia, nexata pëtsa patovajëtame Diosojavabelia peyavenonaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Itsa apo pacacopiapitsi tsane, itsa apo jitsipaenua tsane papecanamuxunaevetsinexa panetsipaebilivaisi, bajarapabo pavecuaponaename. Bajarapatomara ata baja pavecuaponaename. Nexata baja itsa paponaejitsiamë bajarapatomaravecua, paneponaevajënae, bajarapatomarata panataxuatsapërëvarëbianame. Bajarapacuenia itsa panataxuatsapërëvarëbianame, bajarapatomarapijivi yapëtaena Diosojavabelia penaneconitsicuene apo papecacopiapitsixae papecanamuxunaevetsinexa panetsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi Dioso naneconitsiaexanaena daxita pijaneconi pexainaevi, bajarapamatacabi Dioso ayaicuenia naneconitsiaexanaenatsi patomarapijivi apo pacacopiapitsi tsane. Paneconivajëtota bajayata Dioso naneconitsiaexana Sodoma tomarapijivimi, Gomorra tomarapijivimi ata, bajarapaneconivajëto matatoxenetsia itsamatacabi Dioso naneconitsiaexanaena patomarapijivi apo pacacopiapitsi tsane, jai Jesús pijajivijavabelia pitorobivajënaeya. ");
INSERT INTO guh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Icatsia Jesús jumaitsi pijajivijavabelia: —¡Xania panayajivitaename! Pacaitorobianatsi raja bitso pibisiacuene pexanabiabivijavabelia. Pacuenia ovejaxi tsiayaitsi itsa jinavanapa pianaepanaevi nevëthë tuatuajëata, bajarapaitsimë tsane. Nexata pacuenia unupijivi nayajivitaeyajinavanapa pitsacueniabiyanivatsi, bajara paitsimë tsane. Pacuenia ata ucucu aneconijibia jinavanapa, bajara paitsimë tsavanapae tsane. ");
INSERT INTO guh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xania baja tsane. Patajajivixaemë raja jivi pacaneconitsiana papecananeconitsiaexanaenexa. Nexata itsajota nacaetuatabiaba tomara pevetsivi, bajarabelia pacacaponaena. Judíovi penacaetuatabiabibonëjava pacajumatitibabeyabiabiana penaneconitsivi pejumaconitabiabimacata. ");
INSERT INTO guh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Patajajivixaemë pacanubiananua nacuaevetsivi pitabarata, presidentevi pitabarata ata. Bajarajota nexata xanë talivaisi patsipaebianame bajarapamonaejavabelia, apo judíovi ata pitabarata. ");
INSERT INTO guh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Itsiata baitsi jane itsa pacanubiana nacuaevetsivi pitabarata, pëtsa pajamatabëbëjamë panenayajivicuaicuaijainexa bajarapamonaejavabelia. Tsipaji raja paepatota panayajivicuaicuaijamëjitsia, bajarapaepatota Dioso pejamatabëcueneta pacacuaicuaijaiyaexanaena. ");
INSERT INTO guh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Itsa panayajivicuaicuaijamë tsane, paxamë panijacuata apo pacuaicuaijamë tsane. Espíritu Santo raja pacacuaicuaijaiyaexanaena. ");
INSERT INTO guh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Itsamonae pematapijivi, pejuyapijivi ata, canajetsiana nacuaevetsivijavabelia pebeyaxuabinexatsi. Itsamonae nacoxicanajetsiana nacuaevetsivijavabelia pebeyaxuabinexatsi. Itsamonae canajetsiana paxa, pena ata, nacuaevetsivijavabelia pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Daxita nacuapijivi pacaitoya tsane patajajivixaemë. Pajivi bejiobiaexanae atatsi tsane, itsiata itsa casaë tsaponaponae tsane tanejumecovënëtsijava, bajarapajivi capanepaenatsi Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Itsa patomarata pacabejiobiaexanaena, bajarapatomaravecua parëcëpecaename itsatomarabelia. Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita Israel nacuata penaetomaranëjava abaxë patsipaebiveretsinejevamë pexanialivaisi, xanë, Daxitajivi Pematapijinënë, itacarajeta icatsia patsianicajë. ");
INSERT INTO guh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Itsajivi ata apo jamatabëcuenematatoxenetsi pecujarubinëtsi. Itsajivi ata pijinia itsanë itsa pijajivitonë, apo jamatabëcuenematatoxenetsi pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pacuenia pecujarubinë itsamonae copiaya bejiobiaexanatsi, bajarapacuenia icatsia bajaraponë pecujarubivi ata bejiobiaexanaenatsi. Pacuenia petuxanenë copiaya bejiobiaexanatsi, bajarapacuenia icatsia pijajivitonë ata cotocaevi bejiobiaexanaenatsi. Xanë panijatuxanenënë: “Beelzebú, daxita dovathivi pijatuxanenë,” nejai tsabiabi itsamonae. Nexata pijinia patajajivixaemë bitso pibisiavënëta paxamë ata cotocaevi pacajunatabiabiana, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Icatsia Jesús jumaitsi pijajivijavabelia: —Pëtsa pacujunavame jivi, pacaatiobi ata. Daxita xua jivi muetsia pibisiacuene exana, bexëajavabelia cueneyapëtaeponaenatsi daxitajivi. ");
INSERT INTO guh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Palivaisianë muetsia vajaepatojavata pacatsipaebaponatsi, bajarapalivaisianë paxamë pinijijumeta patsipaebaponaename jivi penacaetuatabiabijavata. ");
INSERT INTO guh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pëtsa pacujunavame jivibevi ata. Bajarapamonae pacabeyaxuabi ata tsipae, acuenebi matavëjëa papecaitsacueniabinexa pepo panejamatabëcuenejavabelia. Biji rajane pacujunavare Dioso, ponë caëjëpatsi papecaxuabinexa infiernojavabelia papecabeyaxuabicujinae. ");
INSERT INTO guh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Anijanëbeje baratsuitobeje namatamota saya caepalatanëyo. Itsiata baitsi jane caenë ata baratsuito Dioso pepëya jemata muetsia apo jopaetsica petëpaenë. Tsipaji paneaxa, Dioso, asiva baratsui ata. ");
INSERT INTO guh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dioso cajena bitso pacaasiva baratsui matatoxenetsia. Nexata panematanatoxi ata, caematanatoyo canacujitsia, Dioso namataëjëta. ");
INSERT INTO guh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bajaraxuata pëtsa pacujunavame itsacuenejavayo ata. Tsipaji paxamë Dioso bitso pacaasiva baratsuitoxi matatoxenetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Icatsia Jesús jumaitsi pijajivijavabelia: —Daxita pamonae tajajivi, jivi pitabarata itsa navajunupaebiana tajajivicuene, xanë ata vajunupaebianajë bajarapamonae tajajivicuene taxa, athëbëtatsia peecaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pamonae jumai tsane itsamonaejavabelia: “Xanë cajena Jesús apo pijajivitonënë,” jai tsane, nexata pijinia bajarapamonae yabara xanë jumaitsinë tsane taxa Diosojavabelia: “Mara pamonae apo tajajivije,” janë tsane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Icatsia Jesús jumaitsi pijajivijavabelia: —Pëtsa panesivajamatabëjumaitsimë mapacueniaje: “Jesús rabaja patsica mapanacuayabetsicaje daxitajivi mapanacuataje najamatabëcuenejëpaeya pejinavanapaeyaexanaenexa,” panesivajamatabëjamë pëtsa. Bajaraxuanexa apo patsinëtsica. Biji rajane xanë tapatsixaetsica mapanacuayabetsicaje, jivi itsa nejumecovënëtsiana, apo najamatabëcuenejëpae tsane pamonaejavabelia apo nejumecovënëtsi, nacaemonae ata. Napijavajabitsaë tsane namataenetsia. ");
INSERT INTO guh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xanë apo tanenajuajumecovënëtsixaebeje, pebibeje paxabeje apo najamatabëcuenejëpaebeje tsane. Petirivabeje ata, pexënatoyobeje xanë apo tanenajuajumecovënëtsixae penabeje apo najamatabëcuenejëpaebeje tsane. Pamebeje ata pecopenabeje apo najamatabëcuenejëpaebeje tsane. ");
INSERT INTO guh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nexata xanë apo tanenajuajumecovënëtsixae, caejivi canacujitsia bepijavajabitsaëjivi taenatsi pijamonaejivi ata. ");
INSERT INTO guh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Pajivi nejumecovënëtsi ata, apo niasiva tsane paxa, pena ata, piasivajava matatoxenetsia, bajarapajivi apo tajajivi tsane. Pajivi nejumecovënëtsi ata, apo niasiva tsane pexënato, pexënatoyo ata, piasivajava matatoxenetsia, bajarapajivi apo tajajivi tsane. ");
INSERT INTO guh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pajivi nejumecovënëtsi ata, pecajunavi apo nepënaponae tsane pebeyaxuabixaejitsiatsi xanë tajumelivaisi yabara, bajarapajivi apo tajajivi tsane. ");
INSERT INTO guh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pajivi nayavajunuaxaina tajajivicuene pebejiobiaexanaeyanivatsi, pebeyaxuabiyanivatsinua, bajarapajivi naxuabiana daxitamatacabijavabelianexa. Itsiata baitsi jane pajivi beyaxuabatsi tajajivixae, bajarapajivi daxitamatacabijavabelianexa Dioso capanepaenatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Icatsia Jesús jumaitsi pijajivijavabelia: —Pajivi pacacopiapitsiana patajajivixaemë, bajaraxua xanë taniji tanecopiapitsijava. Pajivi necopiapitsiana, bajaraxua taxa Dioso tane pecopiapitsijavatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Diosojumepaebinë Dioso matamotsianatsi petonacuenebimatamo. Nexata pajivi xaniavaetsia copiapita Diosojumepaebinë, bajarapajivi ata Dioso matamotsianatsi. Nexata xuavajëto Diosojumepaebinë Dioso matamotsianatsi, bajara pijinia xuavajëto Dioso matamotsianatsi pajivi copiapita Diosojumepaebinë. Pajivi ata exanabiaba Dioso pitorobicueniatsi, bajarapajivi ata Dioso matamotsianatsi. Nexata pajivi xaniavaetsia copiapita pajivi exanaponapona Dioso pitorobicueniatsi, bajarapajivi ata Dioso matamotsianatsi. Nexata xuavajëto Dioso matamotsianatsi pajivi exanaponapona Dioso pitorobicueniatsi, bajara pijinia xuavajëto bajarapajivi Dioso matamotsianatsi. ");
INSERT INTO guh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pajivi yavenonaena tajajivi, tsiquirijavayo ata mera rajutsiana piapaenexa, bajarapajivi pepacuene matamotsianatsi Dioso, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús baja najumevereta pijajivi doce ponëbejejavabelia livaisi petsipaebijava. Nexata baja Jesús pona livaisi petsipaebinexa bajarapanacuata penaetomaranëjava. ");
INSERT INTO guh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bajarapamatacabi Juan jivibautisabinë naneconitsiaponapona penaneconitsivi pejebabiabibota. Nexata Juan vënëlivaisitane Dioso pesaëta Jesús pinijicuene pexanaponaejava. Bajaraxuata Juan itoroba pijajiviyajuvënëvi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Juan itoroba pijajivi peyanijobinexa Jesúsjavabelia. Nexata Juan pijajivi jumaitsi Jesúsjavabelia: —¿Xamë tsabaja Cristomë? ¿Xamë tsabaja tajëvelia cavajunupaebapona nepatsijavanexatsica daxitajivi necapanepaenexa? Itsa apo Cristomë, ¿abaxë tsaja pacopiaevetavanapaenajë itsanë pepatsinexatsica? jai Juan pijajivi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nexata Jesús jumaitsi Juan pijajivijavabelia: —Paponare baja. Patsipaebianame Juan pacuenia baja pataneme taexanaponaejava. Patsipaebianamenua pacuenia baja pajumetaneme tatsipaebilivaisi jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Apo petaevimi ata itaxutoxaniavaetaponajë xaniavaetsia petaenexa. Petabusipacuenabivitsinua daxita jinavanapaeyaexanaponajë. Bajayajebi bitso peperabëtsabanaevinua vecuaajibiaexanaponajë. Bitso pemuxusipanaevinua jumetaeyaexanaponajë baja xaniavaetsia pejumetaenexa. Petëpaevimi ata icatsia asaëyaexanaponajë. Pexanialivaisinua pecapanepaelivaisinexatsi pibisiacuene pexanaeneconimivecua tsipaebaponajë bepejiobivijavabelia. Daxita bajaraxua taexanaponaejava patanetaejavamë, patsipaebianame Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pajumaitsimënua tsane Juanjavabelia: “Jesús raja jumaitsi: ‘Jamatabëcuenebarëya pajivi tsiteca jumecovënëta xanë Dioso pexënatocuenenë,’ jai raja Jesús,” pajamë tsane Juanjavabelia, jai Jesús Juan pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Itsa baja Juan pijajivi naviabalia, nexata bajarapamonae pecovëta Jesús taxuxuaba jivijavabelia petsipaebijava Juan pelivaisi. Jesús jumaitsi jivijavabelia mapacueniaje: —Itsa paponame petusato nacuayabelia, pamatacabi Juan ponapona petusato nacuata, ¿detsa pitsicuene pajamatabënaponaremelia panetaenexa bajarajotalia? ¿Paponaremelia tsaja saya panetaenexa musuli penajëabijava jovibota? ");
INSERT INTO guh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Itsa apo paponaemëlia panetaenexa musuli penajëabijava jovibota, ¿detsa nexata pitsicuene panetaenexa paponaremelia? ¿Paponaremelia tsaja saya panetaenexa naitabëtsiaya pexaniajava penaxatatsinë? Paxamë rabaja payapëtaneme mapacueneje. Pamonae naitabëtsiaya pexaniajava naxatababiaba, bajarapamonae jinavanapa nacuanë pevetsivi pijabonëjava. ");
INSERT INTO guh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Detsa nexata xua pajamatabënaponaremelia panetaenexa petusato nacuayabelia? Paponaremelia raja panetaenexa Diosojumepaebinë profetanë. Xaniajanë pacuenia pacatsipaebijitsiatsi. Juan itsa pataneme, pepacuene jane baja pepo profetanë, Diosojumepaebinë, pataneme. Nexata saya bevelia profetanë apo pataemë. ");
INSERT INTO guh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan pexanaejavanexa, bajayata tajëvelia Dioso pejumelivaisibaxutota vajunupaeba. Dioso tanejumaitsijava ata xanëjavaberena Juan yabara, Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: Itorobianajë nevajënaeyabelia tanejumelivaisipaebinënexa, jivi pecatsivajënae najamatabëcuenexaniavaetsinexa, jai bajayata Dioso pejumelivaisibaxutota tapatsivajënaeya Juan tanelivaisi paebanajetarucaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Xaniajanë pacuenia pacatsipaebijitsiatsi. Juan ayaijamatabëcuenenë mapanacuataje. Nexata bajayata Juan pevajënaeya paprofetavi jinavanapa, itsanë ata Juan apo jamatabëcuenematatoxenetsitsi. Itsiata baitsi jane pajivi beveliajamatabëcuenejivi ata, itsa nejumecovënëta tacapanepaejavanexa, bajarapajivi ayaijamatabëcuenejivi Dioso exanaenatsi Juan matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan jivibautisabinë petaxuxuabijavaveliacujinae, Dioso pitorobilivaisi jivi petsipaebanajetarucaejava mapamatacabijavaberena ataje, ayaibitsaëtoxaneto picani jivi jitsipa Dioso pitorobilivaisi pejumecovënëtsinexa. Itsiata itsamonae pesaëta caranatapona bajarapamonae pejumecovënëtsiyaniva Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan penaexanaevajënaeya, daxita Diosojumepaebivimi profetavi tajëvelia vajunupaebapona itsamatacabi Dioso pijajivi pevetsijavanexa. Dioso Moiséspijinëta penajumecopatsilivaisi ata, tajëvelia vajunupaeba Dioso pijajivi pevetsijavanexa. ");
INSERT INTO guh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Itsa baja jamatabëpajumecovënëtame, pajumecovënëre xua aeconoxae pacatsipaebijitsiatsi. Dioso pejumelivaisibaxutota tajëvelia jumaitsi mapacueniaje: “Elíaspijinë icatsia patsiana,” jai. Bajarapacuenia tajëvelia itsa jumaitsi, Juan jivibautisabinë yabara jumaitsi. Tsipaji pacuenia jamatabëcueneitsi profeta Elíaspijinë, bajara jamatabëcueneitsi Juan ata. Nexata Juan pepatsivajënaeya, tajëvelia yapëtanetsi pacuenia Juan exanaejitsia. ");
INSERT INTO guh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesús icatsia jumaitsi jivijavabelia: —¿Detsa meta pacuenia yapëtaeyaexanaenajë itsamonaejavabelia bajarapamonae xaniavaetsia papecayapëtaenexa pacuenia paxamë pajamatabëcueneitsimë tsavanapae? Jumaitsinë meta tsane paxamë yabara mapacueniaje: “Bajarapamonae abaxë saya bepejevaxijivixi, pajivixi tomara tuatuajëjava banamuxusitenavanapa. Pejevaxijivixi itsa namuxusitenavanapa, bavavajai tsenae penajua namuxusitenaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Pevavajaijavata bajumaitsi: ‘Pacatoobecatsi picani flauta. Itsiata apo payavajibimë. Pacatonaxëanecatsi picani penemuxunanuevajinexa ata. Itsiata apo panuemë,’ bajai tsenae pejevaxi penajua namuxusitenaejivixijavabelia. Bajara saya jamatabëcueneitsi pamonae aeconoxae jinavanapa mapanacuataje,” janë meta tsane paxamë yabara. ");
INSERT INTO guh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan jivibautisabinë Dioso pitorobilivaisi jivi tsipaebanajetaruca. Pexaejava itsajavata apo xaeyabiabi, pamatacabibeje Diosojavabelia vajëtapona. Vinora ata apo apaeyabiabi. Nexata bajaraponë yabara jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabi: “¡Juan raja dovathi yajavaponapona!” pajamë tsabiabi jamatabëcuenenavëxaniabiaya. ");
INSERT INTO guh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bajaraxuacujinae icatsia xanë, Daxitajivi Pematapijinënë, najetarucajë. Itaxutojema xaniji. Matavëjëa apaeyabiabajënua. Nexata xanë yabara icatsia jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabi: “¡Pataema maponëje! Ayaijava xaeyabiaba. Ayaira matavëjëa apaeyabiabanua piaitajibinexa. Barënajamatabëcuenejëpanua gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi. Pamonae ata piajamatabëcuenebejevi, barënajamatabëcuenejëpa,” pajamë tsabiabi xanë yabara. Itsiata baitsi jane xuanë paxanëbeje Juanbeje paexanaponajëbeje, bajaraxuanë Dioso pejamatabëcueneta pataexanaejavabeje itsamonae xaniavaetsia yapëtaena. Nexata daxita bajarapamonae yapëtaena pacuenia Dioso paneyapëtaeyaexanabeje pepacuene pepo pexaniajaijamatabëcuene, jai Jesús mapacueniaje jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Itsatomaranëjava Dioso pesaëta Jesús pinijicuene pexanaejavanë navitsia exanapona. Itsiata bajarapatomaranëpijivi apo copabi pibisiacuene pexanabiabijava. Apo najamatabëcuenepënëyorotsi Diosojavabelia. Nexata Jesús ajumesaëya jumaitsi bajara patomaranëpijivijavabelia: ");
INSERT INTO guh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Bitso bepajiobimë tsane paCorazín tomarapijivimë! ¡Bitso bepajiobimë tsane paBetsaida tomarapijivimë ata! Pinijicuene Dioso pesaëta taexanaejavanë patae atamë, itsiata apo panejumecovënëtsimë. Apo pacopabimë pibisiacuene paneexanabiabijava. Apo panajamatabëcuenepënëyorotsimë Diosojavabelia. Bajayata Tiro tomarapijivimi, Sidón tomarapijivimi ata, petuatuajëta bajarapitsipinijicuene itsa tsitaexanaejitsipajë, nexata bajarapamonaemi copabijitsipa pibisiacuene pexanaejava. Najamatabëcuenepënëyorotsipa Diosojavabelia. Bajarapamonaemi nexata pibisiacuene pexanabiabineconi bitso yajamatabëcuenebëjai tsipae. Nexata Diosojavabelia petsitanajamatabëcueneitajëtsinexa peyajamatabëcuenebëjaijava pibisiacuene pexanabiabineconi, naxatabijitsipa piayopapaëbërëjavanë. Enaejitsipa irata. Ipumana ata natsimataothocaejitsipa bitso peyajamatabëcuenebëjaixae pibisiacuene pexanabiabineconi. ");
INSERT INTO guh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Xaniajanë pacuenia pacatsipaebijitsiatsi. PaCorazín tomarapijivimë, paBetsaida tomarapijivimë ata, patae atamë pinijicuene Dioso pesaëta taexanaejavanë, apo panejumecovënëtsimë. Nexata pamatacabi Dioso naneconitsiaexanaena daxita pijaneconi pexainaevi, bajarapamatacabi bitso ayaicuenia Dioso pacananeconitsiaexanaena. Paneconivajëtota bajayata Dioso naneconitsiaexana Tiro tomarapijivimi, Sidón tomarapijivimi ata, bajarapaneconivajëto matatoxenetsia Dioso bitso ayaicuenia pacananeconitsiaexanaena. ");
INSERT INTO guh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Paxamë paCapernaum tomarapijivimë, jamatabëcuenenavëxaniabiaya pajamatabëjumaitsimë tsabiabi: “Vaxaitsi cajena ayaijamatabëcuenevitsi. Nexata Dioso nacacapanepaena athëbëabetsia,” pajamatabëjamë tsabiabi. Itsiata baitsi jane athëbëabetsia Dioso apo pacacapanepae tsane. Dioso raja pacaxuabiana infiernojavabelia apo patanejumecovënëtsixaemë. Bajayata Sodoma tomarapijivimijavata itsa exanaejitsipajë Dioso pesaëta pinijicuene taexanaejava, pacuenia paxamëjavata exanaponajë, nexata Sodoma tomarapijivimi copabijitsipa pibisiacuene pexanaejava. Najamatabëcuenepënëyorotsipa Diosojavabelia. Nexata bajarapamonae Dioso apo verebiabi tsipaetsi pibisiacuene pexanaeneconi yabara. Nexata abaxë mapamatacabi ataje jivi jinavanapaejitsipa bajarapatomarata. ");
INSERT INTO guh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi Dioso naneconitsiaexanaena pijaneconi pexainaevi, ayaicuenia Dioso pacananeconitsiaexanaena. Tsipaji Dioso pesaëta navitsia pinijicuene taexanaponaejava patae atamë, apo panejumecovënëtsimë. Nexata Sodoma tomarapijivimi matatoxenetsia Dioso bitso ayaicuenia pacananeconitsiaexanaena, jai Jesús patomarapijivijavabelia apo jumecovënëtsitsi. ");
INSERT INTO guh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesús pevajëtsijavata paxa Diosojavabelia jumaitsi: —Axa, nevetsinë athëbëtatsia. Nevetsinë mapanacuajava ataje. “Ayaijamatabëcuenenëmë bitso,” cajaitsi. Tsipaji pamonae bitso apo penacujarubivi ata, yapëtaeyaexanaename nevetsijavanexa daxita nijajivi mapanacuataje. Bajarapamonae yapëtaeyaexanaename pexanialivaisi, xanë talivaisi, palivaisi vecuamatayatame bitso peyapëtaevi mapanacuapijilivaisije. Bajarapalivaisi vecuamatayatame bitso penacujarubivi ata mapanacuapijicuene yabaraje. ");
INSERT INTO guh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bajarapacuenia exaname tsipaji baja exaname nejitsipaecuenia, jai Jesús paxa Diosojavabelia pevajëtsijavata. ");
INSERT INTO guh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Icatsia Jesús jumaitsi pijajivijavabelia: —Taxa Dioso baja cajena netocopata tayapëtaenexa daxitacuene. Itsajivi ata apo nejamatabëcueneyapëtae pacuenia xanë jamatabëcueneitsinë, Dioso pexënatonë. Caenë taxa Dioso nejamatabëcueneyapëtane. Itsajivi ata apo jamatabëcueneyapëtae pacuenia taxa Dioso jamatabëcueneitsi. Caenënë xanë, pexënatonë, jamatabëcueneyapëtaniji. Pamonae tojitsipajë tayapëtaeyaexanaenexa pacuenia taxa Dioso jamatabëcueneitsi, bajarapamonae ata yapëtaeyaexanaponaenajë. ");
INSERT INTO guh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pabita penacuenebabiabinë, piarevejava pejotabiabinë, bitso bavemaxëcuerana. Bajara pijinia pacuenia paxamë ata bitso itsa pajamatabëcuenecueraname pibisiacuene paneexanabiabijava yabara, xanëjavaberena paponare paneajamatabëcuenesaënexa icatsia. ");
INSERT INTO guh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bueyubeje banavësijumacaevetabeje petsivësijumabuatsinexatsibeje yugovënëjava penacuenebinexabeje. Bajara pijinia pacuenia paxamë ata panajamatabëcuenecaevere patacatsijamatabëcuenebuatsinexa patacatsipaebilivaisi. Panejumecovënëtsianame pacuenia pacaitorobatsi patanetonacuenebinexamë. Nexata panevajënaeyabelia panejamatabëcueneyapëtaeponaename. Tsipaji xanë xaniavaetsia pacatsipaebaponaenatsi. Xanë beayaijamatabëcuenenë apo nataenë. Nexata bajarajota panajamatabëcueneevetsianame paneajamatabëcuenesaënexa icatsia. ");
INSERT INTO guh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pacuenia bueyu tsivësijumabuatatsi yugovënëjava petoyapëxanepanaenexatsi penacuenebijava, bajara pijinia pacuenia paxamë ata pacatoyapëxanepanaeyaexanaenatsi paneexanaenexa xua pacaitorobijitsiatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Judíovi penacueraevetsimatacabita Jesús, pijajivi yajava, najetaruca trigo pabianëjava. Jesús pijajivi bitso piajani. Nexata trigoxu siricanajetarubena. Xuxaeyabuatapona. ");
INSERT INTO guh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nexata fariseovi tane Jesús pijajivi pesiricanajetarubenaejava trigoxu. Nexata fariseovi jumaitsi Jesúsjavabelia: —Taema mapamonaeje. Dioso Moiséspijinëta penajumecopatsilivaisi vajanacaitavetsicuene nijajivi exana. Apo nacaitavetsi ata trigoxu vajaxaejava, itsiata ajena penacueraevetsimatacabixae, nijajivi apo bexanae mapacueneje, jai fariseovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nexata Jesús jumaitsi fariseovijavabelia: —Ajena, penacueraevetsimatacabita, tajajivi bajarapacuenia exanae ata, itsiata apo pibisiacuene. Tsipaji bitso piajani. ¿Apo palebimë tsipaji Dioso pejumelivaisibaxuto paneyapëtaenexa pacuenia vajasalinainë Davidpijinë, pebarëponaevi yajava, exana pamatacabi bitso piajani? ");
INSERT INTO guh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidpijinë joneya Dioso pijatemploboyalia. Nexata Dioso pijatemploboënëta, mesajumata, bobena Diosonexa ofrendacuenia petojebipanbëanë. Bajarapapanbëanë apo tocopatsitsi picani Davidpijinë, pijajivi ata, pexaenexa penaneconitsiyaniva Diosojavabelia. Ësacerdotevi picani tocopatatsi pexaenexa. Davidpijinë apo sacerdotenë ata, pijajivi barëxae ata bajarapapanbëanë, itsiata apo vënananeconitsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Apo palebimë tsipaji Dioso Moiséspijinëta penajumecopatsilivaisi paneyapëtaenexa pacuenia jumaitsi sacerdotevi yabara? Sacerdotevi templobota penacuenebivi, penacueraevetsimatacabita ata apo nacueraevetabiabi. Penacueraevetsimatacabita sacerdotevi nacuenebabiabi ata templobota, itsiata apo naneconitsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Xanë cajena ayaijamatabëcuenenënë. Nexata Dioso netojitsipa jivi taneyaiyataenexa templobo matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: “Jitsipajë paneitaxutotsoniataenexa itsamonae ata. Apo jitsipaenë cajena saya patanetobeyabiabinexamë dajubicuene ofrendacuenia patanerajutabiabinexamë,” jai Dioso pejumelivaisibaxutota. Xua yabara jumaitsi bajarapacuenia, apo pajumeyapëtaemë baja cajena. Tsipaji itsa pajumeyapëtaejitsipame xua yabara jumaitsi, nexata tajajivi ata paitaxutotsoniataejitsipame. Nexata tajajivi trigoxu pexaejava yabara apo panejumaitsimë tsipae: “Dioso Moiséspijinëta penajumecopatsilivaisi vajanacaitavetsicuene nijajivi exanapona,” apo panejamë tsipae. Tsipaji tajajivi apo naneconitsi Diosojavabelia. Tsipaji tajajivi bitso piajanixae, trigoxu xane. ");
INSERT INTO guh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nexata xanë, Daxitajivi Pematapijinënë, netoxanepana cajena tatsipaebinexa xua xanepana jivi pexanaenexa penacueraevetsimatacabita ata, jai Jesús mapacueniaje fariseovijavabelia trigo pabianëjavata. ");
INSERT INTO guh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Trigo pabianëjavata Jesús livaisi petsipaebicujinae fariseovijavabelia, Jesús baja vecuapona pabianë. Nexata Jesús joneya judíovi penacaetuatabiabiboyalia. ");
INSERT INTO guh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nexata bajarajota pebi naeca, pecobetsaquenaenë. Itsamonae fariseovi bajarajota jamatabëneconitatsi Jesús. Nexata Jesús naitaxutocaevetatsi xua yabara neconitsijitsiatsi. Nexata fariseovi Jesús jamatabëcueneëjëbiaya yanijobatsi mapacueniaje. —¿Vajanacueraevetsimatacabita ata tsaja xanepana piavitanevi vajajamatejemayaexanaenexa? jai fariseovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús nexata jumaitsi fariseovijavabelia: —Paxamëyajuvënëvi pijaoveja itsa tojopaejitsiparecatsi meramëthëareca, penacueraevetsimatacabita ata ponaejitsipa. Nexata jutsipaina pijaoveja. ¿Baja tsabaitsi jane? ");
INSERT INTO guh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Biji ra jivitonë bitso namatamota oveja matatoxenetsia! Bajaraxuata itsiata nacatoxanepana vajaexanaenexa pexaniacuene vajanacueraevetsimatacabita ata, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nexata Jesús jumaitsi pecobetsaquenaenëjavabelia: —Namaxërovire, jai Jesús. Itsa bajaraponë namaxërovita, pacuenia itsanenia cobeitsi, bajara cobeitsi. Cobexanepanareca baja. Pecobetsaquenaejavami baja ajibi. ");
INSERT INTO guh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nexata fariseovi itsa tane Jesús pecobexanepanaeyaexanaejava pecobetsaquenaenë, fariseovi anaepana. Nexata pitsaparena judíovi penacaetuatabiabibovecua. Nexata jane baja fariseovi najumejaita Jesús pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús jamatabëcueneyapëtane pacuenia fariseovi sivanajamatabëxainatsi. Jesús picani fariseovi jamatabëbeyaxuabatsi. Nexata baja Jesús bajarapamonae vecuapona itsajavabelia. Jivi ayaibitsaëtoxaneto Jesús pënaponatsi. Jesús nexata jamatejemayaexana daxita piavitanevi. ");
INSERT INTO guh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesús jumeitaveta bajarapamonae petsipaebiyaniva itsamonaejavabelia Jesús Dioso pexënatocuene. ");
INSERT INTO guh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bajarapacuenia Jesús pejamatejemayaexanaevi itsa jumeitaveta petsipaebiyaniva itsamonaejavabelia, copiapata jane baja pacuenia bajayata Diosojumepaebinëmi profeta Isaíaspijinë tajëvelia jumaitsi. Dioso pejumaitsijava Jesús yabara profeta Isaíaspijinë bajayata tajëvelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Maponë taitapetsinë, taitorobicuenia exanabiaba. Bajaraponë tasivanë. Sivajamatabëcuenebarëyanë. Espíritu Santo runaeyaexanaenicajë bajaraponë pematatsënëatsica. Bajaraponë apo judíovijavabelia tsipaebiana tananeconitsiaexanaejavanexa daxita pibisiacuene pexanaevi. ");
INSERT INTO guh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bajaraponë itsajivijavabelia ata apo jumeanaenotsi tsane. Livaisi itsa tsipaebapona, pinijijumeta apo vavajai tsane. ");
INSERT INTO guh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pamonae xanë tajumelivaisi pejumecovënëtsijava abaxë apo ajamatabëcuenesaë ata, itsiata bajaraponë bajarapamonae apo xuabi tsane. Capanepaena. Pamatacabi tocopiapatsianatsi bajaraponë pijajivi pevetsimatacabinexa, xaniavaetsia bajaraponë evetsiana daxita pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nexata daxitajivi, apo judíovi ata, sivanajamatabëcuenecopatsianatsi bajaraponë pecapanepaenexa, jai bajayata tajëvelia profeta Isaíaspijinë Dioso pejumaitsijava Jesús yabara. Bajarapacuenia bajayata tajëvelia jumaitsi Isaíaspijinë peyaquinaebaxutota. ");
INSERT INTO guh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesús tocapatatsi bitso pitaxutotsëcënaenë, apo penatsipaebinë. Bajaraponë dovathi yajavaponapona. Bajaraponë Jesús jamatejemayaexana. Xaniavaetsia baja nexata tane. Natsipaebanua baja. ");
INSERT INTO guh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jivi itsa tane Jesús pejamatejemayaexanaejava bajaraponë, jamatabëcuenenabenajaca. Nexata jivi najumaitsi Jesús yabara: —¿Matsaeta ponë Davidpijinë pemomoje, Dioso pitorobinëtsicaje? najai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nexata fariseovi itsa jumetane bajarapacuenia jivi pejumaitsijava, fariseovi jumaitsi jivijavabelia: —Mara ponë Jesúsje, dovathi jivivecua capitsapabiaba Beelzebú pesaëta. Beelzebú raja daxita dovathivi pitorobinë, jai fariseovi jivijavabelia jamatabëcuenenavëxaniabiaya Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús jamatabëcueneyapëtane pacuenia fariseovi sivanajamatabëxainatsi. Nexata Jesús jumaitsi fariseovijavabelia: —Nacaenacuapijivi ata itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, namataenetsia naverebiabijitsipa nacaenacuapijivi ata. Bajara pijinia itsipae nacaetomarapijivi ata. Itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, nexata namataenetsia naverebiabijitsipa nacaetomarapijivi ata. Bajara pijinia itsipae nacaemonae ata. Itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, nexata namataenetsia naverebiabijitsipa nacaemonae ata. ");
INSERT INTO guh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bajara pijinia itsipae dovathi ata. Dovathi jivivecua itsa capitsapaponaejitsipa pijajivi, dovathivi, nexata bepijavajabitsaënë taejitsipatsitsi pijajivi. Itsajamatabëcuene vecuaxainaejitsipa pijajivi. Pesaë ata apo xainaponae tsipae. ");
INSERT INTO guh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Paxamë ata panijajivi dovathi jivivecua capitsapabiaba. Nexata xanë Beelzebú pesaëta dovathi jivivecua itsa capitsapabiabajë, ¿detsa nexata ponë pesaëta panijajivi ata dovathi jivivecua capitsapabiaba? Caenë rabaja Dioso pesaëta. Nexata panijajivi ata pacayapëtane bajarapacuenia jamatabëcuenenavëxaniabiaya panejumaitsijava xanë yabara. ");
INSERT INTO guh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Espíritu Santo raja pesaëta xanë dovathi jivivecua capitsapabiabajë. Nexata baja picani jivi beyapëtane Dioso baja petaxuxuabijava pijajivi pevetsijava paxamë tuatuajëta, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Fariseovi pecanaëjëtsinexa Jesús bitso piasaënëcuene dovathi matatoxenetsia, Jesús icatsia jumaitsi fariseovijavabelia mapacueniaje: —Itsajivi ata apo caëjëpaetsi pejonenexa bitso piasaënë pijaboyalia peyacajërëtsinexa xua xaina pijabota. Itsiata itsa patsipa bajaraponë matatoxenetsia bitso piasaënë, nexata cobecëtabuatsipatsi. Taxucëtabuatsipatsi yajava. Matapania bajarapacuenia yacajërëtsipatsi daxita xua xaina pijabota. ");
INSERT INTO guh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Pajivi apo neyavenonaeyacaetuatsi jivi Diosojavabelia, bajarapajivi betajavajabitsaëjivi. Tsipaji apo taneyavenonaeyacaetuatsixae, jivi nevecuanacayajata Dioso picani pejumecovënëtsiviminexa. ");
INSERT INTO guh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Bajaraxuata pacatsipaebijitsiatsi, Dioso caëjëpatsi daxitajivi pibisiacuene pexanaeneconimi pevecuaajibiaexanaenexa. Pibisiacuenia jivi Dioso baracuaicuaijai ata, bajarapaneconi ata Dioso caëjëpatsi pevecuaajibiaexanaenexa. Itsiata baitsi jane pajivi pibisiacuenia baracuaicuaijai Espíritu Santo, pacuenia paxamë pajumaitsimë, Dioso apo vecuaajibiaexanae tsane bajarapaneconi. ");
INSERT INTO guh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pajivi pibisiacuenia nebaracuaicuaijai ata, xanë, Daxitajivi Pematapijinënë, bajarapaneconi ata itsiata Dioso vecuaajibiaexanaenatsi itsa vajëta Diosojavabelia. Itsiata baitsi jane pajivi pibisiacuenia baracuaicuaijai Espíritu Santo, bajarapaneconi Dioso apo vecuaajibiaexanae tsanetsi. Daxitamatacabijavabelianexa apo vecuaajibiaexanae tsanetsi bajarapaneconi, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Icatsia Jesús jumaitsi fariseovijavabelia: —Pexaniavirianaenë itsa ubatsi, nacuaita pijinia pexaniacuai. Ponae pijinia pibisianae, nacuaita pibisiacuai. Caevirianae canacujitsia yapëtanetsi itsa nacuaita. ");
INSERT INTO guh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Bajara pijinia pacuenia paxamë ata dovathi papijajivimë, panayapëtaneme paneajamatabëcuenebejejava. Nexata apo pacacaëjëpae panecuaicuaijainexa pexaniacuene yabara. Pajamatabëcuene bëpënëa panejamatabëëthëtota panajamatabëxainame, panecuibovojotuatsina pitsapa panecuaicuaijainexa. ");
INSERT INTO guh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Itsamonae pijinia majamatabëcueneitsije. Pacuenia vajaubinae, pexanianae, pexaniacuai pijinia nacuaita, bajara pijinia jamatabëcueneitsi itsamonae. Ponë pexaniajamatabëcuenenë, pexaniacuene yabara cuaicuaijai. Tsipaji pexaniajamatabëcuene xaina pejamatabëëthëtota. Ponë pijinia pibisiajamatabëcuenenë pibisiacuene yabara cuaicuaijai. Tsipaji pibisiajamatabëcuene najamatabëxaina pejamatabëëthëtota. ");
INSERT INTO guh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi Dioso naneconitsiaexanaena daxita pijaneconi pexainaevi, caejivi canacujitsia, naneconitsiaexanaponaena caejumeyo canacujitsia pibisiacuenia pecuaicuaijaijava yabara. ");
INSERT INTO guh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pibisiacuenia panecuaicuaijaijava yabara Dioso pacananeconitsiaexanaena. Pexanialivaisi itsa pacuaicuaijamë tsabiabi tsane, nexata paneconijibimë tsane Diosojavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fariseovi, judíovi pecujarubivi ata, jumaitsi Jesúsjavabelia: —Jesús, pajitsipajë patataenexa Dioso pesaëta pinijicuene nexanaejava, patacayapëtaenexa pepacuene Dioso athëbëvetsica pecaitorobinëcuenetsica, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús nexata jumaitsi bajarapamonaejavabelia: —Bitso pibisiacuene paneexanaevi, Dioso panejumecovënëtsijavami panecopabivi. Paneitorobame picani Dioso pesaëta pinijicuene taexanaejava patacatsitaexanaenexa pataneyapëtaenexamë Dioso pepacuene athëbëvetsica taneitorobinëcuenetsica. Itsiata baitsi jane Dioso pesaëta pinijicuene taexanaejava apo pacatsitaexanae tsanetsi. Bajayata pacuenia Diosojumepaebinëmi profeta Jonáspijinë exanatsi, bajara ëpitsicuene taneexanaejava pacatsitajëtsianatsi. ");
INSERT INTO guh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bajayata Jonáspijinë boca ayainë dujuainë pënëta acueyabi pamatacabibeje, acueyabi pameravibeje yajava. Bajara pijinia pacuenia xanë ata, Daxitajivi Pematapijinënë, bocaenajë mëthëta acueyabi pamatacabibeje, acueyabi pameravibeje yajava. ");
INSERT INTO guh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bajayata Nínive tomarapijivimi itsa jumetane Dioso pitorobilivaisi, Jonáspijinë petsipaebilivaisi, copaba pibisiacuene pexanaejava. Najamatabëcuenepënëyorota Diosojavabelia. Copiapatsiana rabaja Dioso papecananeconitsia exanaematacabinexa daxita panijaneconi panexainaevi. Panijaneconi panexainaevi pacanubiana Dioso pitabarata. Nexata bajarapamatacabi Nínive tomarapijivimi nonobapunaena Diosojavabelia papecaneconitsinexa Dioso apo panejumecovënëtsivi. Xanë majotaje ponaponajë, bitso ayaijamatabëcuenenënë Jonáspijinëmi matatoxenetsia. Nexata pacatsipaebi atatsi Dioso pejumelivaisi, itsiata apo panejumecovënëtsimë. Apo panajamatabëcuene pënëyorotsimënua pibisiacuene paneexanaejavavecua. Bajaraxuata ayaineconi paxainame Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pamatacabi Dioso naneconitsiaexanaena pijaneconi pexainaevi, bajayata peponaponaevami, Saba nacuapijivi pevetsivami, nonotapunaena Diosojavabelia papecaconitsinexa Dioso apo panejumecovënëtsivi. Bajarapova pacaneconitsiana. Tsipaji bajayata bajarapovami tajë nacuatabuverena ata muxunarena pejumetaenexa Salomónpijinë, bitso daxitalivaisi peyapëtaenëmi, petsipaebilivaisi. Xanë majotaje ponaponajë, bitso ayaijamatabëcuenenënë Salomónpijinëmi matatoxenetsia. Nexata pacatsipaebi atatsi Dioso pejumelivaisi, itsiata apo panejumecovënëtsimë. Apo panenamuxunaevetsimënua. Bajaraxuata Dioso pacananeconitsiaexanaena, jai Jesús tajëvelia fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús jumaitsi fariseovijavabelia, judíovi pecujarubivijavabelia ata: —Dovathi itsa vejamatabëpitsapa jivitonë, nexata dovathi jinaruta petseviiranëjava. Jaitapona itsanëjavabelia petsijamatabëjonenexa penacueraevetsinexa bajaraponëjavata. Itsa apo caxitajarabi ponëjavabelia tsijamatabëjonejitsia, nexata dovathi jamatabëjumaitsi: ");
INSERT INTO guh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Naviatsianajë meta icatsia tajabomijavabelia, paboverena pitsapajë,” jamatabëjai dovathi, ponëjavaverena pitsapa icatsia petsijamatabëjonenexatsi. Dovathi baja caevëa itsa naviarena, caxitajaraba peyajavaponaponaenëmitsi. Nexata peyajavaponaponaenëmitsi pejamatabëëthëto, dovathi tane bepënësajinecaebo, bepënëxaniavaetetsibo, bepiracajuetetsibo. ");
INSERT INTO guh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nexata dovathi icatsia sivapona peyajavapatsinexarena itsadovathivi, siete ponëbeje. Bajarapadovathivi bitso piacujirubejevi copiaya padovathi matatoxenetsia. Daxita bajarapadovathivi pebi tsijamatabëjunuatsi peyajavaponaponaenexa. Belia jane baja pebi dovathivi bitso bejiobiaexanatsi. Copiaya abaxë caenë itsa tsijamatabëecatsi pacuenia bejiobiaexanabiabatsi, matatoxenetsia bejiobiaexanatsi. Bajara pijinia pacuenia tocopiapatsianatsi pamonae aeconoxae jinavanapa, piacujirubejevi, jai Jesús fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús abaxë jivi livaisi itsa tsipaeba bo ënëtuatuajëalia, pata Jesús pejuyapijivi, pena yajava. Nexata bojumavelia nubena bajarapamonae. Jamatabëbarëcuaicuaijaitsi picani Jesús. ");
INSERT INTO guh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nexata itsajivi Jesús tsipaebatsi. —Patajatuxanenë, ena raja, nejuyapijivi yajava, nuca bojumaverena. Bajarapamonae pina jitsipa pecabarëcuaicuaijaijava, jaitsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nexata Jesús jumaitsi petsipaebijivitsijavabelia: —¿Detsa pitsijamatabëcuenevi taena, tajuyapijivinua? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nexata Jesús pecobeta itaropita pijajivi. Jumaitsi petsipaebijivitsijavabelia: —Mara jane pamonae taenajivije, tajuyapijivinua. ");
INSERT INTO guh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tsipaji raja pajivi exana taxa, athëbëtatsia peecaenë, pitorobicueniatsi, bajarapajivi cajena tajuyapijinë, tajuyapijiva, taenanua, jai Jesús petsipaebijivitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesús baja itsa najumevereta jivijavabelia livaisi petsipaebijava, pitsapa baja bajarapabovecua. Pona baja itsajavabelia. Nexata Jesús ecojopa pucaxaneto itapata. ");
INSERT INTO guh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nexata pucaitapata jivi ayaibitsaëtoxaneto Jesús itaxutuanacaetuatatsi. Nexata Jesús runareca jera ënëabereca. Ecareca jera ënëtareca. Daxita jivibitsaëtoxaneto nubena tajetabovelia. ");
INSERT INTO guh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nexata Jesús daxitacuene livaisianë tsipaeba jivijavabelia. Jesús jumai tsaponae bajarapamonaejavabelia mapacueniaje: —Peubinë pona pabiabelia peubinexa. ");
INSERT INTO guh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nexata itsa pata pabita, peubixu pexucayajabajarabicuenia ubanajetaruca. Pexucayajabajarabijavata itsaxu othopa pabi tuatuajëjava penajetarucaenamutojumata. Nexata bajarajota pata baratsui. Xane bajarapaxumi juvinejeva. ");
INSERT INTO guh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Itsaxu pijinia othopa ibopananëjumata, itsajota bitso ira apo aitayaë. Nexata bajarapaxu bepijia juva. Tsipaji bitso ira apo aitayaë. ");
INSERT INTO guh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nexata icotia bitso itsa ataju, nexata bajarapaxu juvi ata, tsaquenapona. Tsipaji irabereca bitso apo atabunepepiareca. ");
INSERT INTO guh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Itsaxu pijinia othopa xanëebacabomijavata. Nexata peubixu xanëebotonë caecuenia itsa yajavajuva, bitso xanëebotonë matacënënatsi peubijavami. ");
INSERT INTO guh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Itsaxu pijinia othopa pexaniairata. Bajarapaxu itsa juva, vitsaba. Xaniavaetsia nacuaita. Itsabotonë capitsapa cien paxutoyobeje tsaponae. Itsabotonë capitsapa sesenta paxutoyobeje tsaponae. Itsabotonë capitsapa treinta paxutoyobeje tsaponae. ");
INSERT INTO guh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús bajarapalivaisi petsipaebivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesús pijajivi imoxoyotatsi. Nexata Jesús pijajivi jumaitsi Jesúsjavabelia: —Patajatuxanenë, jivijavabelia livaisi itsa tsipaebame, ¿detsa xuajitsia tsipaebame ëcomparacióncuenia? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nexata Jesús jumaitsi pijajivijavabelia: —Paxamë rabaja xaniavaetsia Dioso pacayapëtaeyaexana Dioso papijajivimë papecaevetsijava. Itsiata itsamonae apo yapëtae bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pajivi xaniavaetsia nejumeyapëtane tatsipaebilivaisi, bajarapajivi icatsia itsalivaisi pematatsënëa Dioso yapëtaeyaexanaenatsi. Itsiata pajivi apo jitsipae pematatsënëa pejumeyapëtaeponaenexa tatsipaebilivaisi, bajarapajivi xuayovajëto jumeyapëtane picani, nacofënëtsiana. ");
INSERT INTO guh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bajaraxuata livaisi itsa tsipaebajë bajarapamonae, ëcomparacióncuenia tsipaebajë. Nexata bajarapamonae tae ata Dioso pesaëta pinijicuene taexanaejava, itsiata apo yapëtae pajamatabëcuene yabara exanajë pinijicuene taexanaejava. Namuxunaevetsi ata tatsipaebilivaisi, itsiata apo jumeyapëtae pajamatabëcuene xaina tatsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bajarapacuenia apo jumeyapëtae tsipaji jane baja tocopiapatatsi pacuenia bajayata tajëvelia Diosojumepaebinëmi profeta Isaíaspijinë yaquina. Dioso pejumaitsijava apo tanejumeyapëtaevinexa yabara, bajayata profeta Isaíaspijinë peyaquinaelivaisita jumaitsi mapacueniaje: Bajarapamonae picani jumetaena. Itsiata apo jumeyapëtae tsane xua yabara tsipaebianatsi. Bajarapamonae taena picani. Itsiata apo yapëtae tsane pajamatabëcuene xaina petaejava. ");
INSERT INTO guh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bajarapamonae ajamatabëcuenetaja tsane. Bajaraxuata benamuxuacabiaya pejinavanapaevi tsane. Benaitaxutotsaquebiaya pejinavanapaevi tsane. Itsa bajarapacuenia apo itsipae, nexata yapëtaejitsipa pajamatabëcuene xaina xua taena. Jumeyapëtaejitsipanua palivaisi jumetaena. Pejamatabëëthëtojavavetsina jumeyapëtaejitsipa. Nexata xanëjavaberena najamatabëcuenepënëyorotsipa perujujamatabëcuenevecua. Nexata xanë jamatabëcuene xanepanaeyaexanaejitsipajë, jai bajayata tajëvelia Isaíaspijinë peyaquinaelivaisita xua yabara tsipaebajë bajarapamonae apo tanejumeyapëtaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Itsiata baitsi jane paxamë baja pajamatabëcuenebarëyamë. Tsipaji payapëtaneme pajamatabëcuene xaina xua pataneme. Pajumeyapëtanemenua pajamatabëcuene xaina palivaisi pajumetaneme. ");
INSERT INTO guh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajayatami ayaibitsaëto profetavimi necopiaevetavanapa tanetaenexa picani tapatsijavatsica. Itsamonae ata aneconijibia pejinavanapaevi Dioso pitabarata, necopiaevetavanapa picani tanetaenexa tapatsijavatsica. Itsiata apo netaenejeva, daxita bajarapamonaemi tëpa baja. Jamatabëjumetaeyabiabanua picani palivaisianë baja aeconoxae paxamë pacatsipaebaponatsi. Itsiata apo jumetaenejeva bajarapalivaisianë, bajarapamonaemi tëpa baja, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Icatsia Jesús jumaitsi pijajivijavabelia: —Xaniavaetsia panenamuxunaevere panejumeyapëtaenexa pajamatabëcuene xaina palivaisi pacatsipaebatsi pabita peubinë pelivaisicuenia. ");
INSERT INTO guh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pamonae jumetae ata Dioso pejumelivaisi, itsiata itsa apo jumeyapëtae pejamatabëëthëtota, bajarapamonae bepiothopaexu pabi tuatuajëjava penajetarucaenamutojumata. Nexata najetaruca dovathi. Nexata bajarapamonae tsijamatabëjuvinejevatsi, dovathi vecuapitatsi bajarapalivaisimi, petsijamatabëubilivaisimitsi. ");
INSERT INTO guh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pacuenia pijinia itsi paxu othopa ibopananëjumata, itsajota bitso ira apo aitayaë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae jumetane Dioso pitorobilivaisi. Nexata picani bajarapalivaisi barëyaya jumecovënëta. ");
INSERT INTO guh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Itsiata baitsi jane pacuenia irabereca apo atabunepepiareca paxu othopa ibopananëjumata, nexata nabijiana, bajara tsijamatabëcueneitsitsi bajarapamonae Dioso pitorobilivaisi. Tsipaji pepacuene pejamatabëëthëtovetsina apo jumecovënëtsi bajarapalivaisi. Nexata apo ajamatabëcuenesaë tsavanapae bajayajebi pejumecovënëtsinexa bajarapalivaisi. Nexata itsa tocopiapatatsi daxita petoayapëbejecuenetsi, itsa yalivaisibatsinua Dioso pitorobilivaisi yabara, nexata pejumecovënëtsijava bajarapalivaisi bepijia copaba. Pevajënaeyabelia apo jumecovënëtavanapae. ");
INSERT INTO guh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pacuenia pijinia paxu othopa xanëebacabomijavata, itsa juva, bitso matacënënatsi xanëebotonë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Jumetane picani bajarapamonae Dioso pitorobilivaisi. Itsiata baitsi jane bitso jamatabëcueneenatsi mapanacuapijicuene yabaraje. Tsipaji najamatabëxaina ayaijava palata pexainaenexa. Nexata pijacuata najamatabëcueneyamaxëitojoroba. Bajaraxuata Dioso pitorobilivaisi apo tovitsabitsi pejamatabëëthëtota. Nexata pacuenia itsi pabita piacuaijibibotonë, bajara itsi bajarapamonae. Tsipaji Dioso xaniavaetsia apo tojinavanapae. ");
INSERT INTO guh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pacuenia pijinia itsi paxu othopa pexaniairata, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae jumetane Dioso pitorobilivaisi. Jumeyapëtanenua. Nexata pevajënaeyabelia tsijamatabëcuenevitsabaponatsi Dioso pitorobilivaisi. Nexata pacuenia peubijava capitsapa itsabotonë cien paxutoyobeje tsaponae, itsabotonë sesenta paxutoyobeje tsaponae, itsabotonë treinta paxutoyobeje tsaponae, bajara tsijamatabëcueneitsitsi bajarapamonae Dioso pitorobilivaisi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dioso apo pejumecovënëtsivi, pamonae najinavanapa Dioso pejumecovënëtsivijavata, itsamatacabi Dioso naneconitsiaexanaena. Nexata jivi peyapëtaenexa bajarapamonae Dioso penaneconitsiaexanaejavanexa, Jesús comparacióncuenia livaisi tsipaeba jivi ayaibitsaëtoxanetojavabelia. Jesús jumaitsi mapacueniaje: —Mara pacuene jëpaje Dioso pijajivi pevetsijavaje. Pabi pexainaenë, ëpexaniaviriatrigoxu uba pijapabita. ");
INSERT INTO guh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Itsiata baitsi jane daxitajivi pemajitsijavata meravi, pabi pexainaenë pijavajabitsaënë tojunuatsi pijapabita. Nexata toubatsi trigo tuatuajëjava pibisiaviriajava, betrigobotonë pecataejava. Bajaraxuacujinae vemaxëpona baja. ");
INSERT INTO guh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nexata trigoxu juva. Vitsaba. Itsa baja trigobotonë namatonota, nexata matapania bajarajota nayapëtane pibisiaviriajava yajava penamatonotsijava. ");
INSERT INTO guh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nexata pabi pexainaenë pijajivi pata petsipaebinexatsi. Pabixainaenë pijajivi jumaitsi: “Nijapabita ubame ëpexaniaviriatrigoxu. ¿De tsaeta pacuenia pitsapa pibisiaviriaxu pibisiajava peyajavajuvinexa trigojava?” jai pabixainaenë pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nexata pabixainaenë jumaitsi pijajivijavabelia: “Tajavajabitsaënë raeta bajaraxua uba,” jai. Nexata pabixainaenë pijajivi jumaitsi: “¿Jitsipame tsaja bajaraxua pataxunaejava?” jai. ");
INSERT INTO guh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Itsiata baitsi jane pabixainaenë jumaitsi pijajivijavabelia: “Jume. Tsipaji panexunaejavata payajavaxunaejitsipame trigobotonë. ");
INSERT INTO guh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Copatsianatsi abaxë penacuaitsinexa. Nexata penotsimatacabi itorobianajë tanetonotsivi copiaya pecaetuatsinexa piabejejava. Pepacunuanë exanaena. Bajaraxuacujinae bajaraxua tajuitsiana. Bajaraxuacujinae ëtrigoxu netonotsiana taetabiabibota tanetoetsinexa,” jai pabixainaenë pijajivijavabelia, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús livaisi tsipaeba comparacióncuenia jivi ayaibitsaëtoxanetojavabelia. Jumaitsi mapacueniaje: —Dioso raja pijajivi pevetsijava maitsije. Pacuenia mostazaxutoyo pejuvicujinae, bepijia vitsaba mostazanae, bajara pijinia itsane Dioso pijajivi ata. Bepijia Dioso pijajivi ayaibitsaëtoxaneto naexanaena. Pabi pexainaenë mostazaxu uba pijapabita. ");
INSERT INTO guh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostazaxu raja bitso tsiquirixutoxi daxita peubixuvecua. Itsiata baitsi jane mostazanae itsa juva, bepijia vitsaba. Caevaita pinijinae naexana itsapeubinaenë matatoxenetsia. Nexata baratsui ata pata bajaraponaeta. Pematapenanë exana bajaraponaemaxërananëjava. Bajara pijinia itsane jivi ata. Bepijia ayaibitsaëto Dioso pijajivi naexanaena, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús livaisi tsipaeba comparacióncuenia jivi ayaibitsaëtoxanetojavabelia. Jumaitsi mapacueniaje: —Dioso raja pijajivi pevetsijava maitsije. Pacuenia pan pexanaematabënexa, levaduravënëjava yacaëjëpa daxita panmatabëjava, bajara pijinia itsi Dioso pijajivi pevetsijava. Yacaëjëpaena daxitanacuanëjava. Petiriva pan pexanaenexa, acueyabi patarroxanetobeje trigobenonë matajërëaba levaduravënëjavata. Nexata pan pexanaematabënexa, ayaimatabë ata, levaduravënëjava pijinia tsiquirijavayo ata, itsiata levaduravënëjava yacaëjëpa daxitamatabëjava. Nexata levaduravënëjava fufunaeyaexana daxita panmatabënexa. Bajara pijinia itsi Dioso pijajivi pevetsijava. Yacaëjëpa daxitanacuanëjava Dioso pijajivi pevetsicuene, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús itsa tsipaeba jivijavabelia Dioso pijajivi pevetsijavanexa, livaisianë tsipaebapona ëcomparacióncuenia. ");
INSERT INTO guh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bajarapacuenia Jesús jivi livaisianë itsa tsipaebapona ëcomparacióncuenia, tocopiapatatsi jane baja pacuenia Diosojumepaebinë profetanë bajayata tajëvelia yaquina Jesús petsipaebaponaejavanexa yabara. Jesús comparacióncuenia jivi livaisi petsipaebaponaejavanexa yabara, profetanë peyaquinaebaxutota jumaitsi mapacueniaje: Jivi itsa tsipaebajë, livaisi tsipaebianajë comparacióncuenia. Tsipaebianajë pitsicuene Dioso nacua pexanaejavaveliacujinae itsajivi ata abaxë apo yapëtae, jai tajëvelia bajayata profetanë peyaquinaebaxutota Jesús jivi livaisi comparacióncuenia petsipaebaponaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús naviabiaexana jivi ayaibitsaëtoxaneto. Bajaraxuacujinae Jesús boya joneya. Bajarapabota Jesús pijajivi imoxorenatsi. Nexata Jesús pijajivi jumaitsi: —Patajatuxanenë, panetsipaebare pajamatabëcuene xaina palivaisi tsipaebame jivi ayaibitsaëtoxanetojavabelia. Baitsi palivaisi tsipaebame trigobotonë tuatuajëa pejuvijava pelivaisicuenia, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nexata Jesús jumaitsi pijajivijavabelia: —“Ponë uba pexaniaviriatrigoxu,” itsa janë, xanë rabaja, Daxitajivi Pematapijinënë, yabara nayabarajumaitsinë. ");
INSERT INTO guh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Pijapabi,” itsa janë, mapanacua yabaraje jumaitsinë. “Pexaniaviriatrigoxu,” itsa janë, Dioso pijanacuayabetsia pejonevinexa yabara jumaitsinë. “Pibisiaviriajava pejuvijava,” itsa janë, dovathi pijajivinexa yabara jumaitsinë. ");
INSERT INTO guh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","“Pijavajabitsaënë, ponë pabi pexainaenë toubatsi pibisiaviriajava pejuvinexa,” itsa janë, dovathi yabara jumaitsinë. “Penotsimatacabi,” itsa janë, mapanacua pevereverecaejavanexa yabara jumaitsinë. “Tanetonotsivi itorobianajë,” itsa janë, ángelevi yabara jumaitsinë. ");
INSERT INTO guh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nexata pacuenia piabejejava caetuata pexuabinexa isotojavabelia, bajara pijinia pacuenia tocopiapatsianatsi dovathi pijajivi pexuabinexatsi isotojavabelia mapanacuaje pevereverecaematacabi. ");
INSERT INTO guh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bajarapamatacabi xanë, Daxitajivi Pematapijinënë, itorobianajë tajaángelevi taevetsinacua tanetovecuajutsinexa daxita pamonae pibisiacuene pexanabiabivi. Pamonae ata itsamonaejavabelia pibisiacuene exanaeyaexana, bajarapamonae ata taevetsinacua netovecuajutsiana tajaángelevi. ");
INSERT INTO guh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bajarapamonae xuabianatsi infiernojavabelia. Bajarajota nuena. Navonosiniana bitso penavixaetaexae. ");
INSERT INTO guh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pamonae jumecovënëtsiajinavanapa Dioso pitorobicueniatsi, bajarapamonae perabënaitayotsiana taxa Dioso pijanacuatatsia. Pacuenia matacabipijijuameto naitayota, bajarapacuenia perabënaitayotsiana. Pajivi jamatabënejumeyapëtane, patacatsipaebilivaisi nenamuxunaevetsi xaniavaetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Icatsia Jesús comparacióncuenia jumaitsi pijajivijavabelia: —Pebi irata mëthëteta bitso penamatamotsijavanë. Bajaraxuanë bitso xanepana. Nexata juya itsanë bexëajavabelia bajaraxuanë caxitajarabeta irata. Nexata abaxë bajaraponë apo jutsi bajaraxua. Abaxë saya mataacateta bajarajota. Nexata jamatabëcuenebarëyaya pona pijaboyabelia. Nexata xuacujinae bajaraponë canajeta daxita pexainaejavaximi. Nexata bajaraponë yacomuata bajarapaira. Tsipaji xua bajaraponë caxitajarabeta irata, bitso xanepana. Bitso namatamota. Nexata pacuenia bitso xanepana, bitso namatamotanua, xuanë bajaraponë bajarapaira yacomuata, bajara pijinia itsi Dioso pijajivi pevetsijava. Bitso xanepana. Bitso namatamotanua, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacuenia itsi bitso pexaniaviriajava perlavënëjava, bajara pijinia itsi Dioso pijajivi pevetsijava, bitso pexaniacuene. Perlavënëjavanë pecanajetarutsinë jaitapona pexaniaviriajavanë juya pecanajetaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nexata itsa caxitajarabaxuaba pexaniaviriaperlajava, bitso penamatamotsijava, pona pijaboyabelia pecanajetsinexa daxita pexainaejavami. Nexata comuata bajarapaperlajava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Icatsia Jesús comparacióncuenia jumaitsi pijajivijavabelia: —Dujuai peyamatajucaejavata, pibisiaviriadujuai itsa yamatajuta, bavecuatsatapona. Bajara pijinia itsi Dioso pijajivi pevetsijava. Dioso pijajivi vecuatsatapona apo pejumecovënëtsivitsi pexuabinexa infiernojavabelia. Dujuai peyamatajucaejava manuameneta copareca. Nexata daxitaviriadujuai yamatajuta. ");
INSERT INTO guh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Itsa vënëca bajaraxua, nexata juta tajetabojavabelia. Bajarajota itapetapona pexaniaviriadujuai. Pexaniaviriadujuai jebapona bemapirejavabelia. Pibisiaviriadujuai pijinia xuabapona. ");
INSERT INTO guh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bajara pijinia itsane nacua pevereverecaematacabi. Angelevi ponaena. Nexata pibisiacuene pexanaevi saicaya tsatsianatsi pexuabinexatsi. Dioso pijinia pitorobicueniatsi pejinavanapaevi saicaya tsatsianatsi pecapanepaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nexata pibisiacuene pexanaevi xuabianatsi infiernojavabelia. Bajarajota nuena. Navonosiniana bitso penavixaetaexae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús yanijoba pijajivijavabelia. —¿Panejumeyapëtaneme tsabaja daxita xua yabara pacatsipaebatsi? jai Jesús. Nexata Jesús pijajivi jumaitsi: —Jãjã, pacajumeyapëtanetsi rabaja, jai. ");
INSERT INTO guh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nexata Jesús jumaitsi pijajivijavabelia: —Ponë judíovi pecujarubinë ata, itsa nejumecovënëta, bajaraponë ata tajajivitonë tsane. Nexata pacuenia bo pexainaenë pijabovecua jutapona bitso penamatamotsijavanë, pejanajavanë, perujujavanë ata, bajara pijinia jamatabëcueneitsi tsane ponë nejumecovënëtsiana, judíovi pecujarubinë ata. Tsipaji bajaraponë yapëtaena pexanialivaisianë jivijavabelia petsipaebinexa. Bajaraponë yapëtaena xanë talivaisianë, pejanalivaisianë, perujulivaisianë ata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús baja penajumeveretsicujinae jivijavabelia livaisianë petsipaebijava comparacióncuenia, pona baja icatsia itsajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jesús baja naviata pevitsabinacuayabelia. Nexata Jesús pevitsabinacuata taxuxuaba livaisi petsipaebijava judíovi penacaetuatabiabibota. Nexata pejumetaevitsi sivajamatabëcuenenabenajacatsi. Nexata bajarapamonae Jesús jamatabëcueneaebiatanetsi. Bajarapamonae Jesús yabara najumaitsi mapacueniaje: —¿De tsaeta jota maponë nacujaruba peyapëtaenexa mapalivaisije? ¿De tsaeta pacuenia caëjëpatsi mapacuenia Dioso pesaëta pinijicuene pexanaenexaje? ");
INSERT INTO guh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Maponëje vaxaitsiyajuvënënë, carpinteronëmi pexënato. Maponëje María pexënato. Bajaraponë pejuyapijivi, Santiago, José, Simón, Judas. ");
INSERT INTO guh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Papetiriavi ata vajatomarata jinavanapa, maponëje pejuyapijivi. ¿Detsa verena nexata capitsapa palivaisianë nacatsipaebapona maponëje? najai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nacaetomarapijivixae, bajarapamonae Jesús apo jumexaniataetsi. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Bajara maitsabiabije. Diosojumepaebivi profetavi itsanacuapijivi yaiyataeyabiabatsi. Itsiata pijanacuapijivi, pijamonae ata, apo yaiyataeyabiabitsi, jai Jesús pijatomarapijivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesús pevitsabitomarata pejinavanapaevi apo jumecovënëtsitsi. Bajaraxuata Jesús Dioso pesaëta pinijicuene pexanaejava bajarapatomarata bitso apo tsitaexanae. ");
INSERT INTO guh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herodes, Galileanacua pevetsinë. Nexata Herodes Jesús vënëlivaisitanetsi Dioso pesaëta pinijicuene pexanaponaejava. ");
INSERT INTO guh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nexata Herodes pijajivijavabelia jamatabëcuenenavëxaniabiaya jumaitsi Jesús yabara: —Juanpijinëmi raeta jivibautisabinëmi icatsia asaë petëpaecujinae. Bajaraxuata caëjëpatsi Dioso pesaëta pinijicuene pexanaenexa, jai Herodes Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bajarapacuenia Herodes jumaitsi tsipaji abaxë Juanpijinë itsa asaë, Herodes pijajivi, vajabitsaëvi, itoroba Juanpijinë pevaetabinexatsi. Nexata vajabitsaëvi Juanpijinë cobecëtsiaya caponatsi penaneconitsivi pejebabiabiboyabelia. Bajarapacuenia Herodes pijajivi itoroba Herodes pijava, Herodíasva, pejamatabëcueneta. Herodíasva picani copiata pita Felipe, Herodes pejuyapijinë. Nexata Herodes pejuyapijinë pijava yacajërëta. ");
INSERT INTO guh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nexata Herodes pejuyapijinë pijava peyacajërëtsixae, Juanpijinë abaxë itsa apo vaetabitsi, Herodes muxujioba. Juanpijinë jumaitsi Herodesjavabelia: —Acuenebi raja nejuyapijinë pijava nepitsijava, jai Juanpijinë Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bajarapacuenia Juanpijinë Herodes pemuxujiobixae, Herodes picani jamatabëbeyaxuabatsi Juanpijinë. Itsiata baitsi jane abaxë apo beyaxuabitsi. Tsipaji Herodes cujunava jivi. Daxitajivi Juanpijinë yapëtanetsi Diosojumepaebinëcuene. ");
INSERT INTO guh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nexata Herodes itsa najamatabënapita penaexanaematacabi, fiesta exana. Herodes junata jivi ayaibitsaëto. Nexata bajarapafiestamatacabi pejionëyo, pijava pexënatoyo, pijacujirucuenia caevayo yavajiba daxita Herodes pejunatsivi pitabarata. Nexata Herodes bitso barëitajitsipa peyavajibijava pejionëyo. ");
INSERT INTO guh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nexata Herodes najumecapanepaeya pexaniajaijumeta jumaitsi pejionëyojavabelia: —Xua jitsipame nevajëtsianame. Nexata itsa nevajëtsianame, itsacuenejava ata carajutsianatsi, jai Herodes najumecapanepaeya pejionëyojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nexata bajarapovayo pena pitorobicueniatsi jumaitsi mapacueniaje Herodesjavabelia: —Nerajure platota Juan jivibautisabinë pematabocoto, jai bajarapovayo Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bajarapacuenia Herodes pejionëyo itsa jumaitsitsi, Herodes bejamatabëjiobi tsanajetsireca. Herodes nexata acuenebi: “Jume,” pejaijava. Tsipaji baja najumecapanepaeya jumaitsi pejionëyojavabelia pexaniajaijumeta daxita Herodes pejunatsivi pitabarata. Nexata Herodes jejai. ");
INSERT INTO guh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nexata Herodes pijajivi, vajabitsaëvi, itoroba penaneconitsivi pejebabiabiboyabelia pevësiucutaxuabinexatsi Juanpijinë. ");
INSERT INTO guh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bajaraxuacujinae vajabitsaëvi Juanpijinë pematabocoto tocaparenatsi platota. Nexata Herodes rajutsiaexana pejionëyojavabelia. Bajarapova juya pena rajuta. Nexata baja Herodíasva yapëtane capanepaeya baja Juanpijinë pebeyaxuabijavatsi. ");
INSERT INTO guh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nexata Juanpijinë pijajivi parena itsajota Juanpijinë boca petëpaenë. Pitatsi petëpaenë. Nexata Juanpijinë pijajivi mëthëtatsi. Bajaraxuacujinae bajarapamonae pona Jesúsjavabelia petsipaebinexa Juanpijinë pebeyaxuabijavatsi. ");
INSERT INTO guh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús vënëlivaisitane Juanpijinë pebeyaxuabijavatsi. Nexata Jesús ëpijajivi jerata barëpona itsabelia ajibi jivi. Itsiata baitsi jane jivi ayaibitsaëtoxaneto yapëtane itsabelia Jesús pona. Nexata pijatomaranë vecuapona. Matatsënëa najetarubena pepëjaitsivitsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Itsa Jesús nonotajuna jeravecua, tane jivibitsaëtoxaneto. Nexata Jesús itaxutobejiobiatane bajarapamonae. Tocapatatsi piavitanevi. Nexata Jesús tojamatejemayaexana piavitanevi. ");
INSERT INTO guh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Itsa baja caniviyo tsaponae, Jesús pijajivi cujibarenatsi. Nexata Jesús pijajivi jumaitsi: —Caniviyo rabaja bitso. Majotaje ajibi pexaejava. Tsipaji itsajivi ata pijabo apo xainae. Itorobare baja jivi peponaenexa tomaraxijavabelia pecomuacaenexa pexaejava, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nexata Jesús jumaitsi pijajivijavabelia: —Apo beponae raja abaxë. Paxamë parajure pexaejava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nexata Jesús pijajivi jumaitsi: —Paxainajë saya cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava, jai. ");
INSERT INTO guh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nexata Jesús jumaitsi pijajivijavabelia: —Panetocarenamëre pan maberenaje, dujuainëyobeje yajava, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nexata Jesús itoroba daxitajivi penaenexa ponajavata. Nexata Jesús pita cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava. Athëbëa benaëcotsia. Jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pataxaejava, jai Jesús Diosojavabelia. Bajaraxuacujinae Jesús pan epatsicacapona. Pijajivijavabelia rajuta bajarapapan. Nexata juya Jesús pijajivi tsicobetsana jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Daxita xaniavaetsia nabane. Bajaraxuacujinae Jesús pijajivi caetuata pan, dujuai yajava, jivi peyajuvënëcopabejebijavanë. Nexata vënëba doce xuabeje bemapirecuenia pexanaejavanë. ");
INSERT INTO guh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pamonae pexaejava xane, ayaibitsaëtoxaneto. Cinco mil ponëbeje namataëjëtatsi xaniavaetsia. Petiriavi, pejevaxi ata, apo namataëjëtsitsi. ");
INSERT INTO guh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesús jivi ayaibitsaëtoxaneto pexaejava perajutsicujinae, Jesús pijajivi bepijia runaeyaexanareca jera ënëabereca. Jesús pijajivi copiata itoroba penicabinexa puca itsapanabelia, Betsaida tomarabelia. Nexata Jesús abaxë caenë nacopatanuca bajarajota. ");
INSERT INTO guh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Itsa baja jivi napëvereta penaviabijava, Jesús junaya petsutojumabetsia caenë pevajëtsinexa Diosojavabelia. Nexata Jesús yameravibatsi bajarapatsutojumatatsia. ");
INSERT INTO guh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bajarapaepatota Jesús pijajivi jerata epatua nabuatapona pepatsinexa puca itsapanabelia. Nexata Jesús pijajivi pevajënaeverena joviboxaneto najetaruca, malataca bitso ayai. Nexata malataca mene epabajarabapona jera ënëaberena. Nexata mera vënëcapona jera ënëaberena. ");
INSERT INTO guh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bajaraxuacujinae bajayacunua, ajena matacabijitsia, Jesús pijajivi pecovëvelia imoxoyotanajetaruca. Jesús najetaruca mene itaboxoya. ");
INSERT INTO guh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesús pijajivi itsa tanetsi mene itaboxoya penajetarucaejava, nabenajaca. Vavajai pecajunavi. —¡Petëpaenë raeta pejumape najetaruca! jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nexata Jesús jumaitsi pijajivijavabelia: —Xanë raja. Pëtsa panecujunavame. Pajamatejemamëre saya, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nexata Pedro jumaitsi Jesúsjavabelia: —Tajatuxanenë, itsa pepacuene xamë, nexata nejunaremelia talianexa mene itaboxoyalia, xamëjavabelia, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nexata Jesús jumaitsi Pedrojavabelia: —Renamëre baitsi baja, jai Jesús. Pedro nexata jeravecua runareca meniabereca. Lia mene itaboxoyalia pepatsinexa Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Itsiata baitsi jane Pedro itsa tane jovibo piasaëjava, bitso cujunavataba. Nexata bubunanajereca. Pedro ajena bubunanajereca, vavajai. —¡Tajatuxanenë, nevaetabare! jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bepijia Jesús cobepitajaraba. Jumaitsi Pedrojavabelia: —Tsiquirijavayo saya nejumecovënëtame tacaevetsijava. ¿Detsa xuajitsia nejumeaebiataneme? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nexata baja Jesúsbeje Pedrobeje jera ënëabelia itsa nonoliabeje, joviboxanetomi baja ajibi tsaxuabi. ");
INSERT INTO guh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nexata daxita jerata peponaevi pematabacabëta tonubena Jesús pitabarata. Jumaitsi bajarapamonae: —Xaniajai rabaja. Xamë Dioso pexënatomë, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesús, pijajivi yajava, pata puca itsapanabelia. Pata Genesaret nacuata. ");
INSERT INTO guh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesaret nacuapijivi itsa yapëtanetsi Jesúscuene, nexata daxita bajarapanacuajava vajunupaebatsi pepatsijava. Nexata tocapatatsi daxita piavitanevi Jesúsjavaberena. ");
INSERT INTO guh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Piavitanevi pecapatsivi pinijicuenia jumai tsabiabi Jesúsjavabelia: —Pexaniacuene bitso netoexanare. Tocopatsianame maponëje pecatojayatsinexa nenaxatatsijavacopia, jai tsabiabi. Nexata daxita pamonae Jesús penaxatatsijavacopia tojayataponatsi, jamatejema tsaponae piavitanejavavecua. ");
INSERT INTO guh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseovi, judíovi pecujarubivi yajava, pata Jerusalén tomaraverena. Bajarapamonae Jesús imoxoyorenatsi. Nexata bajarapamonae jumaitsi Jesúsjavabelia: ");
INSERT INTO guh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Jesús, nijajivi naneconita Diosojavabelia. Tsipaji nijajivi apo jumecovënëtsiajinavanapae vajasalinaivi pijacuene. Nijajivi itsa xane pexaejava, xane anijatonë napëna nacobequiatsinejeva, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nexata Jesús jumaitsi fariseovijavabelia, judíovi pecujarubivijavabelia ata: —Paxamë apo pajumecovënëtsimë Dioso pitorobilivaisi saicaya vajasalinaivi pijacuene panecatsitecaenexa. ");
INSERT INTO guh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Axa yaiyataema. Ena ata yaiyataema. Pajivi pibisiacuenia bijatane paxa, pena ata, bajarapajivi pabeyaxuare,” jai Dioso Moiséspijinëta penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Itsiata baitsi jane paxamë jivi pamuxubijiapenetabiabame peyaiyataeyaniva paxajivi, penajivi ata. Paxamë jivijavabelia pajumaitsimë tsabiabi mapacueniaje: “Axa, ena ata, itsa cavajëta neyavenonaenexa, nexata itsa apo jitsipaemë neyavenonaejava, jumaitsimë tsane mapacueniaje: ‘Daxita xua pacarajutsipatsibeje picani patacayavenonaenexabeje, daxita bajaraxua tsipaebajë baja tarajutsinexa Diosojavabelia. Nexata acuenebi patacarajutsinexabeje,’ jamë tsane neyavenonaeyaniva,” pajamë tsabiabi jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nexata caranata Dioso pejumaitsijume: “Axa yaiyataema. Ena ata yaiyataema,” pejaijume jivi pejumecovënëtsijavami paxamë pacopatsiaexanaponame. Tsipaji paxamë patsipaebaponame saicaya vajasalinaivi pijalivaisi. ");
INSERT INTO guh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Paxamë saya jivi paneyamaxëitojorobivi! Diosojumepaebinëmi profeta Isaíaspijinë baja cajena bajayata tajëvelia xaniavaetsia pacavajunupaeba. Bajayata Dioso tajëvelia pejumaitsijava paxamë yabara, profeta Isaíaspijinë peyaquinaelivaisita jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bajarapamonae nejitsipaena saya pijumeta. Itsiata pepo tanejitsipaejamatabëcuene nevecuatajë tsane. ");
INSERT INTO guh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Saya baitsi bajarapamonae pijajumaitsita tsane: “Pacajitsipatsi,” nejai tsane itajara. Itsiata apo xaniajai tsane. Bajarapamonae saya jivi tsipaebaponaena pejamatabëcuenepijilivaisi. Pepo taitorobilivaisi apo tsipaebi tsane, jai tajëvelia Isaíaspijinë peyaquinaelivaisita Dioso pejumaitsijava paxamë yabara, jai Jesús fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nexata icatsia Jesús junata jivi. Jumaitsi jivijavabelia: —Panenamuxunaevere xaniavaetsia patanejumeyapëtaenexamë patacatsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Xua jivi xane pecuibovojotota, pexaevajënaeya napëna anijatonë apo nacobequiatsi ata, apo jamatabëcuenebijianaetsi. Apo vënananeconitsi Diosojavabelia. Baitsi rajane xua jivi pecuibota pibisiacuenia cuaicuaijai, bajara jane xua jivi bajamatabëcuenebijianatsi, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nexata Jesús pijajivi imoxoyorenatsi. Jesús pijajivi jumaitsi: —Patajatuxanenë, ¿yapëtaneme tsabaja fariseovi pecabaraanaepanaejava itsa cajumetane bajarapacuenia nejumaitsijava? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Nexata fariseovi yabara Jesús jumaitsi pijajivijavabelia: —Panamuxujemare saya bajarapamonae. Bajarapamonae saya apo yapëtae. Bajarapamonae bepitatsëcënaevi. Nexata bepematacaponaevi pitatsëcënaevi pijinia. Pitatsëcënaenë itsa matacaponaejitsipa itsanë pijinia pitatsëcënaenë, nexata najuajopaejitsiparecabeje mëthëxanetojavareca. Pabita piabejejava itsa juva, nexata yatabutopaya jonatsi vajaveretsinexa. Bajara pijinia pacuenia taxa, athëbëtatsia peecaenë, verebiabianatsi daxita bajarapamonae, jai Jesús pijajivijavabelia fariseovi yabara. ");
INSERT INTO guh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro nexata jumaitsi Jesúsjavabelia: —Patajatuxanenë, paneyapëtaeyaexanare pajamatabëcuene xaina palivaisi tsipaebame jivijavabelia. Palivaisi baitsi jumaitsimë: “Xua jivi xane pecuibota, apo jamatabëcuenebijianaetsi,” jamë, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nexata Jesús jumaitsi: —¿Paxamë ata tsarovia abaxë apo panejumeyapëtaemë? ");
INSERT INTO guh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Daxitacuene xua jivi xane pecuibovojotota, junua pecotsorotuabereca. Bajaraxuacujinae vecuapitsapatsi. ");
INSERT INTO guh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Baitsi rajane xua jivi pecuibuatsina pitsapa pecuaicuaijainexa pacuenia najamatabëxaina pejamatabëëthëtovetsina, bajara jane xua jivi jamatabëcuenebijianatsi. ");
INSERT INTO guh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsipaji rabaja jivi pejamatabëëthëtojavavetsina pitsapa pibisiacuene penajamatabëxainaenexa. Pitsapa jivi pebeyaxuabijamatabëcuenenexa. Pitsapa pebi pijava pevecuanamatayajitsi jamatabëcuenenexa. Pitsapa petiriavijavabelia pebi penaperabëquenetsiatae jamatabëcuenenexa. Pitsapa penacobetoxotsijamatabëcuenenexa. Pitsapa itsamonae pexanaejava yabara najumetsënëtsiaya pepaebijamatabëcuenenexa. Pitsapa itsamonae yabara najumetsënëtsiaya pebaracuaicuaijai jamatabëcuenenexa. Daxita bajarapajamatabëcuene pitsapa jivi pejamatabëëthëtojavavetsina. ");
INSERT INTO guh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Daxita bajarapajamatabëcuene jivi jamatabëcuenebijianatsi. Jivi raja pexaejava xae ata, anijatonë napëna nacobequiatsinejeva, apo jamatabëcuenebijianaetsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús baja Genesaret nacuavecua pona. Naropota itsanacuayabelia, itsabelia eca anijatomarabeje, Tiro tomarabeje Sidón tomarabeje. Jesús baja pata bajarapanacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nexata bajarapanacuata ponapona cananeaviriava. Bajarapova apo judíova. Bajarapova Jesúsjavaberena pata. Pinijijumeta bajarapova jumaitsi Jesúsjavabelia: —¡Petuxanenë, Davidpijinë pemomomë, nitaxutotsoniataema! Taxënatovayo dovathi yajavaponapona. Bitso bejiobiayaexanabiabatsi, jai bajarapova Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Itsiata Jesús apo jumepitsi. Nexata Jesús pijajivi imoxoyorenatsi. Jesús pijajivi jumaitsi Jesúsjavabelia: —Patajatuxanenë, ponaeyaexanare baja mapovaje. Bitso raxua nacapëvabanajetaruca, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nexata Jesús jumaitsi bajarapovajavabelia: —Dioso baja cajena nitoroba tayavenonaenexa ëjudíovi, Israel nacuapijivi, pamonae Dioso tane beoveja. Tsipaji bajarapamonae Diosovecua naxuabavanapa, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Itsiata bajarapova imoxoyorenatsi Jesús. Bajarapova Jesús yaiyataeya pematabacabëta nucajunua Jesús pitabarata. Nexata bajarapova jumaitsi Jesúsjavabelia: —¡Petuxanenë, neyavenonare! jai. ");
INSERT INTO guh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nexata Jesús jumaitsi bajarapovajavabelia: —Apo xanepanae copiaya xamë itsanacuapijivamë tacayavenonaenexa. Abaxë copiaya veyavenonajë tajanacuapijivi, judíovi. Xamë copiaya itsa cayavenonaejitsipatsi, nexata pacuenia pejevaxi pexaejavaminexa yacajërëtsipajë tarajutsinexa avirixijavabelia, bajara itsinë tsipae, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Itsiata baitsi jane bajarapova ajumesaë tsaponae. Icatsia jumaitsi Jesúsjavabelia: —Xaniajamë rabaja picani. Itsiata neyavenonare. Tsipaji avirixi ata baxane pexainaenëtsi pexaeyecaemesa bëxëpanareca piothopaepërë. Bajara pijinia pacuenia itsiata itsanacuapijiva atanë, neyavenonare, jai bajarapova Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nexata icatsia Jesús jumaitsi bajarapovajavabelia: —¡Petiriva, bitso najamatabëcuenecopatame Diosojavabelia pecayavenonaenexa! Nexata pacuenia jumaitsimë, bajarapacuenia Dioso baja cajena catoexanaena, jai Jesús. Bajarapaepatota bajarapova pexënatovayo Jesús pejamatabëcueneta tojamatejematsi baja pijabotalia. ");
INSERT INTO guh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Itsa panacuata eca Tiro tomarabeje Sidón tomarabeje, Jesús baja vecuapona. Nexata Jesús najetaruca Galilea pucaxaneto muxubërëa. Nexata Jesús petsutojumabetsia junaya. Nexata petsutojumatatsia Jesús ecojopa. ");
INSERT INTO guh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nexata jivi ayaibitsaëtoxaneto pata Jesúsjavaberena. Tocapatatsi pejayujayunaevi. Tocapatatsinua bitso pitaxutotsëcënaevi. Tocapatatsinua apo pecuaicuaijaivi. Tocapatatsinua penabejenaevi. Tocapatatsinua ayaibitsaëtoxaneto piavitanevi. Bajarapamonae tojebatsi Jesús pitabarata. Nexata Jesús jamatejemayaexana daxita bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nexata jivi jamatabëcuenenabenajaca itsa tane pecuaicuaijaijava apo pecuaicuaijaivimi. Jesús xanepanaeyaexana penabejenaevimi ata. Xanepanaeyaexana pejayujayunaevimi ata. Itaxutoxanepanaeyaexana bitso pitaxutotsëcënaevimi ata. Nexata jivi itsa tane bajarapacuene, jumaitsi Diosojavabelia: “Diosomë, bitso ayaijamatabëcuenenëmë, paIsrael nacuapijivinë patajaDiosomë,” jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús jivi ayaibitsaëtoxaneto pënajinavanapatsi. Nexata Jesús junata pijajivi. Jumaitsi pijajivijavabelia mapacueniaje: —Netsitabejiobi baja rovia mapamonaeje. Tsipaji baja ajena acueyabi pamatacabibeje xaina xanëjavata pejinavanapaecujinae. Pemarue baja tovereverecatsi. Pexaejava xaenejeva, apo jitsipaenë taitorobijava peponaenexa pijabonëjavabelia. Namuto epatua meta cuenabijitsipatsi piajani, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nexata Jesús pijajivi jumaitsi: —¿Detsa jane pacuenia pexaejava tocaxitajarabianatsi mapajivibitsaëtoxanetoje? Majotaje ajibi pexaejava. Tsipaji itsajivi ata pijabo apo xainae majotaje, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nexata Jesús yanijoba pijajivijavabelia. —¿Detsa papanbëbeje paxainame? jai. Nexata Jesús pijajivi jumaitsi: —Siete papanbëbeje paxainajë, dujuainëxi yajava, jai. ");
INSERT INTO guh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nexata Jesús itoroba daxitajivi penaenexa irata. ");
INSERT INTO guh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nexata Jesús pita siete papanbëbeje, dujuainëxi yajava. Nexata Jesús jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pataxaejava, jai. Bajaraxuacujinae Jesús epatsicacapona pan, dujuainëxi yajava. Nexata Jesús pepatsicacaepan rajuta pijajivijavabelia. Nexata juya Jesús pijajivi tsicobetsana bajarapajivi bitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Daxita bajarapamonae nabane xaniavaetsia. Nexata peyajuvënëcopabijavanë Jesús pijajivi caetuata. Vënëba siete xuabeje bemapirecuenia pexanaejavanë. ");
INSERT INTO guh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pamonae pexaejava xane, ayaibitsaëtoxaneto. Cuatro mil ponëbeje namataëjëtatsi xaniavaetsia. Petiriavi, pejevaxi ata, apo namataëjëtsitsi. ");
INSERT INTO guh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pexaecujinae pexaejava, Jesús baja naviabiayaexana jivi. Nexata Jesús runareca jera ënëabereca. Pona baja Magdala nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseovibeje saduceovibeje pata Jesúsjavaberena. Nexata bajarapamonae Jesús jamatabëcueneëjëbiaya itorobatsi picani pinijicuene pexanaejava Dioso pesaëta Jesús petsitaexanaenexa. Bajarapacuenia picani Jesús itorobatsi peyapëtaenexatsi Dioso pepacuene athëbëvetsica pitorobinëcuenetsitsica. ");
INSERT INTO guh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Pamatacabi caniviyo itaboxo tsobia, paxamë pajumaitsimë tsabiabi: “Meravia pexaniamatacabi tsane. Tsipaji itaboxo tsobia,” pajamë tsabiabi. ");
INSERT INTO guh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pamatacabi bajayacunua nacuaitaboxo itacaënanuca, pajumaitsimë tsabiabi: “Ajena anacuayaijitsia daxita matacabi. Tsipaji nacuaitaboxo itacaënanuca,” pajamë tsabiabi. Payapëtaneme picani xaniavaetsia pacuenia matacabi itsijitsia. Tsipaji itarërëbo pepitsapaexae, payapëtaeyabiabame. Itsiata baitsi jane patae atamë Juan jivibautisabinëmi pexanaponaejava, xanë ata taexanaponaejava patae atamë, itsiata apo payapëtaemë Dioso athëbëvetsica taneitorobinëcuenetsica. ");
INSERT INTO guh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bitso pibisiajamatabëcuene xaina pamonae copaba Dioso pejumecovënëtsijavami. Bajarapamonae picani nitoroba Dioso pesaëta pinijicuene taexanaejava tatsitaexanaenexa taneyapëtaenexa pepacuene Dioso athëbëvetsica taneitorobinëcuenetsica. Itsiata baitsi jane Dioso pesaëta pinijicuene taexanaejava, apo tsitaexanaenë tsane. Pacuenia bajayata Diosojumepaebinë profeta Jonáspijinë exanatsi, bajara ëpitsicuene taneexanaejava, tsitajëtsianajë, jai Jesús petëpaecujinae icatsia Dioso piasaëyaexanaejavanexatsi yabara. Jesús baja nexata bajarapamonae vecuapona. ");
INSERT INTO guh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús pijajivi nicabalia puca itsapanabelia. Nexata nacofënëta pemarue. Apo caponae pan. ");
INSERT INTO guh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nexata Jesús pijajivi muxujioba pejumecovënëtsiyaniva fariseovi, saduceovi ata, itsa tsipaebatsi saicayacuenia Dioso pejumelivaisivecua. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Panejumetaema. Xania panayajivitaema fariseovi pijalevadura. Panayajivitaema saduceovi ata pijalevadura, jai Jesús pijajivijavabelia. Bajarapacuenia Jesús jumaitsi fariseovi petsipaebaponaelivaisi, saduceovi ata petsipaebaponaelivaisi, Jesús pijajivi pejumecovënëtsiyaniva. ");
INSERT INTO guh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Itsiata Jesús pijajivi apo jumeyapëtaetsi. Bajaraxuata Jesús pijajivi nabarëcuaicuaijai bajarapacuenia Jesús pejumaitsijume yabara. Jesús pijajivi jamatabëcuenenavëxaniabiaya najumaitsi: —Jesús nacajumaitsi: “Xania panayajivitaema fariseovi pijalevadura. Panayajivitaema saduceovi ata pijalevadura,” nacajai. Baja raeta pacuenia Jesús nacajumaitsi pan apo vajacaponaexae, najai Jesús pijajivi jamatabëcuenenavëxaniabiaya. ");
INSERT INTO guh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús pijajivi jamatabëcueneyapëtane bajarapacuenia jamatabëcuenenavëxaniabiaya pejumaitsijava levadura yabara. Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia panajumaitsimë: “Baja raeta pacuenia Jesús nacajumaitsi pan apo vajacaponaexae,” panajamë? ¡Apo payapëtaemë tsipaji tanecaëjëpaejava taexanaenexa pan itsa namatavenonatsi! ");
INSERT INTO guh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Paxamë abaxë apo panejumeyapëtaemë. ¿Apo panajamatabënapitsimë tsipaji pacuenia exanajë pamatacabi pan namatavenonatsi? Tsicobetsanajë cinco papanbëmibeje cinco mil ponëbeje pexaenexa. ¿Detsa xuabeje pavënëbame peyajuvënënacopabijavanë bemapirecuenia pexanaejavanë? ");
INSERT INTO guh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Apo panajamatabënapitsimënua tsipaji pacuenia tsicobetsanajë siete papanbëmibeje cuatro mil pajivibeje pexaenexa? ¿Detsa xuabeje bajarapamatacabi pavënëbame peyajuvënënacopabijavanë bemapirecuenia pexanaejavanë? ");
INSERT INTO guh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Itsa pacajumaitsitsi: “Xania panayajivitaema fariseovi pijalevadura. Panayajivitaema saduceovi ata pijalevadura,” itsa pacajaitsi, pan yabara apo pacajumaitsitsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nexata jane baja Jesús pijajivi xaniavaetsia jumeyapëtanetsi. Nexata Jesús pijajivi najumaitsi: “Xania panayajivitaema fariseovi pijalevadura. Panayajivitaema saduceovi ata pijalevadura,” nacajai tsaena Jesús, fariseovi, saduceovi ata, itsa nacatsipaeba saicayacuenia Dioso pejumelivaisivecua vajajumecovënëtsiyaniva, najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús, pijajivi yajava, najetaruca Cesarea de Filipovënë tomaramuxunenia. Nexata Jesús pijajivijavabelia jumaitsi mapacueniaje: —Xanë, Daxitajivi Pematapijinënë. ¿Detsa jivi jumai tsabiabi xanë yabara? ¿De tsaeta xanë ponënë? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nexata Jesús pijajivi jumaitsi: —Itsamonae xamë yabara jumai tsabiabi: “Juanpijinëmi raeta jivibautisabinëmi icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Diosojumepaebinëmi raeta, profeta Elíaspijinë, ponëmi bajayata ponapona, icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Diosojumepaebinëmi raeta profeta Jeremíaspijinë, ponëmi bajayata ponapona, icatsia asaë. Itsa jume, nexata meta bajayata Diosojumepaebivimi profetavimiyajuvënënë icatsia asaë,” jai tsabiabi itsamonae xamë yabara, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa nexata paxamë pajamatabëitsimë xanë yabara? ¿Detsa xanë ponënë? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nexata Simón Pedro jumaitsi Jesúsjavabelia: —Xamë cajena Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenexa. Xamë Dioso piasaëtsaponaponaenë pexënatomë, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús nexata jumaitsi Pedrojavabelia: —Simón, Juan pexënatomë, xamë jamatabëcuenebarëyamë. Tsipaji itsajivi ata apo cayapëtaeyaexanae xanë taneyapëtaenexamë Cristocuenenë. Biji rajane taxa, athëbëtatsia peecaenë, cayapëtaeyaexana. ");
INSERT INTO guh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nexata catsipaebianatsi mapacueniaje. Xamë rabaja Pedromë, beibotomë. Pacuenia ibopanaxanetojumata pexanetsibo bajayajebi ajamatabësaë tsecae, bajara pijinia itsane tajajivi tanejumecovënëtsivi Cristocuenenë. Nexata dovathi apo jamatabëcuenematatoxenetsitsi tsane. ");
INSERT INTO guh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pacuenia baupaevetsinë evetsiaexanatsi llavianë, bajara pijinia pacuenia caevetsiaexanaenatsi athëbënacuapijilivaisianë. Xua itavetsianame mapanacuataje, bajaraxua Dioso ata athëbënacuatatsia itaveta. Xua tocopatsianame pexanaenexa mapanacuataje, bajaraxua Dioso ata athëbënacuatatsia tocopata pexanaenexa, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nexata Jesús pijajivi jumeitaveta petsipaebiyaniva itsajivijavabelia ata: “Mara ponë Cristoje, Dioso athëbëvetsica pitorobinëtsica jivi pecapanepaenexa,” pejaiyaniva. ");
INSERT INTO guh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba pijajivijavabelia. Jumaitsi mapacueniaje: —Ponaejitsianë Jerusalén tomarabelia. Nexata bajarajotalia nebejiobiaexanaena judíovi pijaancianovi, sacerdotevi penamatacaitorobivi ata, judíovi pecujarubivi ata. Bajaraxuacujinae nebeyaxuabiana. Itsiata baitsi jane tatëpaecujinae, acueyabi matacabita, icatsia asaënë tsane, jai Jesús tajëvelia pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nexata Pedro junata Jesús pebarëponatabinexa pesaicaeyojavabelia. Nexata Pedro pesaicaeyojavatalia jumaitsi Jesúsjavabelia: —¡Tajatuxanenë, Dioso caitaxutotsoniataena bajarapamonae pecaexanaeyaniva daxita pacuenia tajëvelia navajunupaebame! jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nexata Jesús Pedrovecua napënëyorotaxuaba. Taenuca pijajivi penaejavabelia. Nexata Jesús napënëyorotsia jumai tsanucae Pedrojavabelia: —¡Dovathi, nevecuanatixire! Nejamatabëcueneëjëbijitsipame. Necopare Dioso taneitorobicuenia taexanaenexa. Xamë apo jitsipaemë pacuenia Dioso jitsipa taexanaenexa. Saya jitsipame pacuenia jivi jitsipa taexanaenexa, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nexata Jesús jumaitsi pijajivijavabelia: —Pajivi jitsipa tanepënaponaejava, bajarapajivi copatsi pejitsipaecuenia penajamatabëxainabiabijavami. Exanaponaponae taitorobicuenia. Najamatabëcueneveretsinua, bejiobiaexanaejitsia atatsi, beyaxuabijitsia atatsinua, Dioso pejumelivaisi yabara piajamatabëcuenesaë tsaponaponaenexa. Nexata jane baja xuacujinae nepënaponaena. ");
INSERT INTO guh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pajivi exanaponapona penatojitsipaecuenia, apo xainae tsane matacabi apo pevereverecaejava. Pajivi xanë tajamatabëcueneta copata penatojitsipaecuenia pexanaejavami, bajarapajivi xainaena matacabi apo pevereverecaejava. ");
INSERT INTO guh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pajivi exanaponapona penatojitsipaecuenia, bajarapajivi Diosovecua naxuabiana. Nexata bajarapajivi daxitacuene xainae ata, mapanacuapijicueneje, itsiata nacuerata. Tsipaji pexainaecuene apo capanepae tsanetsi Diosojavabelia. Tsipaji acuenebi tsane itsajivi ata pematamotsinexa penaxuabiyaniva Diosovecua. ");
INSERT INTO guh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Xanë, Daxitajivi Pematapijinënë, yajavapatsianicajë taxa Dioso pijapenivenivenaecotia. Yajavapatsianicajënua tajaángelevi. Nexata matamotaponaenajë caejivi canacujitsia, tanetonacuenebivi. Naneconitsiaexanaenajë pijinia pijaneconi pexainaevi. ");
INSERT INTO guh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita paxamë patëpaenejevamë, xanë, Daxitajivi Pematapijinënë, tajajivi ayaibitsaëtoxaneto naexanaena. Nexata paxamëyajuvënëvi pepuatae tsane xanë tajajivi ayaibitsaëtoxaneto taevetsijava, tëpaena, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jesús petëpaejavanexa tajëvelia penavajunupaebicujinae, seis pamatacabibejecujinae, Jesús pijajivi, acueyabi ponëbeje, barëjunaya pinijitsutoxanetojumabetsia. Jesús barëjunaya mapamatabëxëyoje: Pedro, Santiago, Juan. Bajarapamatabëxëyo Jesús barëjunaya pinijitsutoxanetojumabetsia. Santiago raja pejuyapijinë Juan. ");
INSERT INTO guh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nexata petsutojumatatsia Jesús perabënivenivenareca bajarapamonae pitabarata. Pacuenia matacabipijijuameto banaitayota, bajarapacuenia Jesús itabaranaitayota. Penaxatatsijavareca, daxita nivenivenaeya niojai. ");
INSERT INTO guh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nexata bajarajota Jesús pijajivi tane bajayata petëpaenëmibeje, Moiséspijinëbeje Elíaspijinëbeje. Jesús barëcuaicuaijaitsi bajaraponëbeje. ");
INSERT INTO guh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nexata Pedro jumaitsi Jesúsjavabelia mapacueniaje: —¡Patajatuxanenë, pijacuaxae panebarëponame! Itsa jitsipame, pacatoexanaenatsi acueyabi pabobërëtobeje. Itsabobërëto xamënexa tsane. Itsabobërëto Moisésnexa tsane. Itsabobërëto Elíasnexa tsane, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Itsa abaxë Pedro cuaicuaijai tsanucae, penaitayotsiitarërëbo mataacataxuabatsi daxita bajarapamonae. Nexata bajarapamonae jumetane bajarapaitarërëbojavavetsica Dioso pejumaitsijava: “Mara ponë taxënato, tasivanëje. Bitso sivajamatabëcuenebarëyanë. Pajumetaema bajaraponë,” pejaijavatsica bajarapamonae jumetane. ");
INSERT INTO guh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jesús pijajivi itsa jumetane bajarapacuenia Dioso pejumaitsijavatsica, irataeya othopa irata. Jesús pijajivi bitso najunaviaca. ");
INSERT INTO guh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nexata Jesús imoxoyolia pijajivi. Jayalia. Jumaitsi pijajivijavabelia: —Panonobapunare. Pëtsa pajunavame, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nexata Jesús pijajivi itsa naëcobarëcëpalia Jesúsjavabelia, ajibi baja Moisésbeje Elíasbeje. Caenë baja Jesús nuca. ");
INSERT INTO guh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nexata Jesús pijajivi itsa barërunanucaponaica petsutojumavetsica, jumeitaveta pijajivi. Jumaitsi pijajivijavabelia: —Pëtsa patsipaebame itsajivi ata pacuene pataneme. Matapania xanë, Daxitajivi Pematapijinënë, icatsia asaënë tsane tatëpaecujinae, nexata jane baja matapania patsipaebianame, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nexata Jesús pijajivi yanijoba Jesúsjavabelia. Jumaitsi: —Patajatuxanenë, ¿detsa xuajitsia judíovi pecujarubivi jumai tsabiabi: “Bajayata ponëmi ponapona, Elíaspijinë, petëpaecujinae icatsia asaë tsane. Bajaraponë copiata patsiana. Bajaraxuacujinae patsiana Cristo, pepo vajanacacapanepaenënexa jane baja,” jai tsabiabi? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nexata Jesús jumaitsi pijajivijavabelia: —“Copiata Elíaspijinë patsiana. Nexata bajaraponë jamatabëcuenexanetsiana daxitajivi,” itsa jai, Juanpijinëmi jivibautisabinëmi yabara jumaitsi. Xaniajai rabaja pacuenia judíovi pecujarubivi jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Xaniajanë pacuenia pacatsipaebijitsiatsi. Elíaspijinë rabaja patajopa. Itsiata jivi apo yapëtaetsi ponëcuene. Nexata pacuenia jivi jitsipa pexanaenexa bajaraponëjavabelia, exana baja. Beyaxuabatsi. Bajara pijinia pacuenia xanë ata, Daxitajivi Pematapijinënë, nebejiobiaexanaena bajarapamonae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nexata Jesús pijajivi jumeyapëtanetsi. Nexata Jesús pijajivi jamatabëjumaitsi: —“Elíaspijinë rabaja patajopa,” itsa jai Jesús, Juanpijinëmi jivibautisabinëmi yabara jumaitsi, jamatabëjai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús pijajivi, acueyabi ponëbeje, barënaviata petsutojumavetsica. Nexata bajarapatsutoxanetotabuta vajënaeevetatsi jivi ayaibitsaëtoxaneto. Nexata pebi Jesús imoxoyorenatsi. Bajaraponë Jesús yaiyataeya pematabacabëta nucajunua Jesús pitabarata. Bajaraponë jumaitsi Jesúsjavabelia: ");
INSERT INTO guh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Jesús, netoitaxutotsoniataema taxënatonëyo. Netodevacaibabiabatsi raja. Bitso bejiobi tsabiabi. Anijatonë isotuabelia natajuitabiaba. Itsajavata menialia jopabiabalia. ");
INSERT INTO guh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nijajivijavaberena picani capatajë tanetojamatejemayaexanaenexa. Itsiata baitsi jane apo caëjëpaetsi tanetojamatejemayaexanaenexa, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nexata Jesús jumaitsi pijajivijavabelia: —¡Paxamë baja rovia apo pajumecovënëtsimë Dioso papecayavenonaejavanexa! Bajaraxuata apo pacajamatabëcuenecaëjëpae pejevaxinë panevecuacapitsapaenexa dovathi. ¡Paneajamatabëcuenetajavi baja rovia! Pexaniajailivaisivecua saicayacuenia panajamatabëxainame. ¿Detsa paepatojebi abaxë paxamëjavata ponaponaenajë? ¿Detsa paepatojebi abaxë paxamëjavabelia ajamatabëcuenesaënë tsaponaponae tsane patanejumecovënëtsinexamë? Panetocarenamëre pejevaxinë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nexata Jesús itaveta dovathi pejevaxinë pevecuapitsapaenexatsi. Nexata baja pejevaxinë dovathi vecuapitsapatsi. Pejevaxinë baja jamatejema. ");
INSERT INTO guh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bajaraxuacujinae Jesús pijajivi barëcuaicuaijaitsi pijaepatojavata. Jesús pijajivi jumaitsi: —Patajatuxanenë, ¿detsa xuajitsia meta paxanë apo panecaëjëpae patavecuacapitsapaenexa dovathi? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nexata Jesús jumaitsi pijajivijavabelia: —Apo pacacaëjëpae pejevaxinë panevecuacapitsapaenexa dovathi. Tsipaji xaniavaetsia apo pajumecovënëtsimë Dioso papecayavenonaejavanexa. Xaniajanë pacuenia pacatsipaebijitsiatsi. Paxamë tsiquirijavayo ata itsa pajumecovënëtsipame Dioso papecayavenonaejavanexa, nexata pacacaëjëpaejitsipa Dioso pesaëta pinijicuene paneexanaenexa. Nexata itsa pajumaitsimë tsipae mapatsutoxanetojavabeliaje: “Vecuanatixire majotaje. Itsajavabelia ecaename,” itsa pajamë, pacajumecovënëtsipa. Nexata natixitsipa. Nexata paxamë paneexanaenexa itsacuenejavayo ata, apo pacatsitaayapëbeje tsipae itsa pepacuene xaniavaetsia pajumecovënëtsipame Dioso papecayavenonaejavanexa. ");
INSERT INTO guh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mara paviriadovathije apo jitsipae pepitsapaejava. Matapania panexaejava apo paxaemë tsipae pamatacabibeje asaëyata Diosojavabelia pavajëtaponame dovathi pepitsapaenexa, pitsapaejitsipa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús abaxë pijajivi itsa barëponapona Galilea nacuata, pijajivijavabelia tajëvelia navajunupaebapona pebeyaxuabijavanexatsi. Jesús pijajivijavabelia jumai tsaponae mapacueniaje: —Xanë, Daxitajivi Pematapijinënë, necanajetsiana itsamonae pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bajarapamonae nebeyaxuabiana. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane,” jai tsaponae Jesús pijajivijavabelia. Nexata Jesús pijajivi itsa jumetanetsi bajarapacuenia Jesús penavajunupaebaponaejava petëpaejavanexa, Jesús pijajivi bitso najamatabëxaina. ");
INSERT INTO guh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús, pijajivi yajava, pata Capernaum tomarata. Nexata Capernaum tomarata impuestomatamo pematamoyanijobabiabivi pona Pedrojavabelia. Nexata bajarapamonae yanijobatsi Pedro. —Pedro, ¿xaniajai tsaja? ¿Panijatuxanenë impuestomatamo apo matamotabiabi, paimpuestomatamo judíovi matamobabiaba templobo pevetsivijavabelia? jaitsi. ");
INSERT INTO guh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro nexata jumaitsi: —Jãjã. Matamotabiaba cajena, jai. Nexata Pedro joneya Jesús peecaeboyalia. Nexata Pedro pejonejavatalia Jesús peecaeboyalia, Jesús jumaitsi Pedrojavabelia: —Pedro, ¿detsa xamë jamatabëcueneitsimë? Nacuaevetsivi palata pepitsinexa, pijajivi itoroba impuestomatamo petoyanijobinexatsi. ¿Detsa nexata pamonaejavabelia nacuaevetsivi pijajivi yanijobabiaba impuestomatamo? ¿Nacuaeevetsivi tsaja pijamonaejavabelia? Itsa jume, ¿saicayavijavabelia tsaja, nacuaevetsivi pevetsinacuata pejinavanapaevijavabelia? jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro nexata jumaitsi Jesúsjavabelia: —Nacuaevetsivi raja pijajivi impuestomatamo yanijobabiaba saicayavijavabelia, nacuaevetsivi pevetsinacuata pejinavanapaevijavabelia. Apo yanijobabiabi nacuaevetsivi pijamonaejavabelia, jai Pedro Jesúsjavabelia. Jesús nexata jumaitsi Pedrojavabelia: —Pacuenia nacuaevetsivi pijamonae apo matamotsitsi impuestomatamo, bajara pijinia pacuenia xanë ata apo jitsipaenë picani tamatamotsinexa impuestomatamo templobo pevetsivijavabelia taxa Dioso pijatemploboxae. ");
INSERT INTO guh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Itsiata baitsi jane xamë matamotsianame itsajivi ata vajanacabaraanaepanaeyanivabeje. Liamëre pucaxanetojavabelia. Ëjëbianame culupabota. Padujuainëyo copiaya catoxaena, jutsianame. Pecuibota caxitajarabianame palatanëyo. Bajarapapalatanëyota caëjëpaena vajamatamotsinexabeje impuestomatamo xanë tamatamotsinexa, xamë ata nematamotsinexa. Nexata bajarapapalatanëyo caponaename impuestomatamo nematamotsinexa templobo pevetsivijavabelia, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jesús baja itsa najumevereta Pedrojavabelia pecuaicuaijaijava impuesto yabara, daxita Jesús pijajivi imoxoyorenatsi. Nexata Jesús pijajivi jumaitsi Jesúsjavabelia: —Patajatuxanenë, ¿detsa ponë paxanëyajuvënënë bitso ayaijamatabëcuenenë tsane daxitavecua Dioso pijanacuatatsia? jai. ");
INSERT INTO guh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nexata Jesús junata pejevaxinëyo. Pijajivi tuatuajëta nuteta pejevaxinëyo. ");
INSERT INTO guh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jesús nexata jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapapejevaxinëyoje beveliajamatabëcuenenëyo nataeya najamatabëcuenecopata Diosojavabelia Dioso pevetsinexatsi. Nexata paxamë itsa apo panajamatabëcuenepënëyorotsimë tsane perujujamatabëcuenevecua beveliajamatabëcuenevi panenataenexa pacuenia mapapejevaxinëyo itsije, nexata apo pajonemë tsane Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nexata ponë jitsipa Dioso pijanacuatatsia ayaijamatabëcuenenë penaexanaenexa daxitavecua, bajaraponë beveliajamatabëcuenenë natae, pacuenia mapapejevaxinëyo jamatabëcueneitsije. ");
INSERT INTO guh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pajivi copiapita tanejumecovënëtsijiviyo, mapitsijamatabëcuenejiviyoje, bajaraxua xanë taniji tanecopiapitsijava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús jumaitsi pijajivijavabelia: —Pajivi pibisiacuene exanaeyaexanaejitsipa mapitsipejevaxijivixi ataje, tanejumecovënëtsiyajuvënëjiviyo, bajarapajivi Diosojavabelia bitso naneconitsipa. Nexata Dioso ayaicuenia bajarapajivi naneconitsiaexanaejitsipatsi. Nexata pajivi najamatabëxaina pibisiacuene pexanaeyaexanaenexa tanejumecovënëtsivijavabelia, abaxë pibisiacuene exanaeyaexanaenejeva, bevësicëtatsi ibotoxanetojavabelia. Nexata bajarapajivi yamaëya, ibotoxaneto yajava, bexuarecatsi pucaxaneto tuatuajëareca. Bajarapajivi bexuarecatsi bitso penaneconitsiyaniva Diosojavabelia pibisiacuene itsa exanaeyaexana tanejumecovënëtsiviyajuvënëvi. ");
INSERT INTO guh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Dioso bitso naneconitsiaexanaenatsi mapanacuapijivi pibisiacuene pexanaevi! Pibisiacuene vajanacaexanaeyaexanae jamatabëcuenenexa, navita mapanacuataje. Bajarapajamatabëcuene tsitecaponaena pevajënaeyabelia. Nexata pajivi pejamatabëcueneta itsamonae pibisiacuene exanaeyaexana, bajarapajivi bitso Dioso naneconitsiaexanaenatsi. ");
INSERT INTO guh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Bajaraxuata panecobeta, panetaxuta ata, pibisiacuene itsa paexaname, panacobecaucure. Panataxucaucure. Tajë panavecuaxuare. Itsiata xanepana panejonenexa cobemataxucaeya, taxumataxucaeya ata, apo pevereverecaenacuajavabelia. Biji rajane apo xanepanae tsipae anijacobebeje, anijataxubeje ata yajava, panejonenexa apo pevereverecaeisotojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Paneitaxutota panetaejava yabara ata pibisiacuene itsa paexaname, panaitaxutocajure. Itsiata xanepana panejonenexa pacaeitaxutojivimë apo pevereverecaenacuajavabelia. Biji rajane apo xanepanae tsipae anijaitaxutobeje yajava panejonenexa infiernojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús jumaitsi pijajivijavabelia: —Itsamonae mapanacuata bijiaya taeyabiaba mapitsipejevaxijivixi ataje, tanejumecovënëtsijivixi. Saya beveliajamatabëcuenevi taeyabiaba. Pëtsa bajarapacuenia paxamë ata bijiaya pataneme tanejumecovënëtsivi. Bijiaya pëtsa pataneme mapitsipejevaxinëyo ataje, tanejumecovënëtsijiviyo. Tsipaji bajarapamonae ángelevi yajavajinavanapa peyavenonabiabinexatsi. Bajarapaángelevi taxa Dioso, athëbëtatsia peecaenë, pitabarata jinavanapa. ");
INSERT INTO guh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xanë, Daxitajivi Pematapijinënë, patajopajë tacapanepaenexa daxita Diosovecua naxuabiaya pejinavanapaevimi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesús icatsia jumaitsi pijajivijavabelia: —Pacanaëjëre mapacueneje. Pebi xainaejitsipa cien ponëbeje oveja. Nexata itsa toyajuvënënaxuabijitsipatsi caenë, oveja pexainaenë puenetsipa noventa y nueve ponëbeje oveja. Bajaraxuacujinae jaitsipa petonaxuabinëtsi. ");
INSERT INTO guh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajaraponë itsa caxitajarabijitsipa pijaoveja, petonaxuabinëmitsi, bitso barëyataejitsipa. Nexata noventa y nueve ponëbeje, apo petonaxuabivitsi, pesivajamatabëcuenebarëyajava, matatoxenetsia bitso sivajamatabëcuenebarëya tsipae petonaxuabinëmitsi. ");
INSERT INTO guh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bajara pijinia pacuenia paneaxa ata, athëbëtatsia peecaenë, apo jitsipae pevecuanaxuabinexatsi caejivi ata mapitsipejevaxijivixi ataje, tanejumecovënëtsivi, jai Jesús pijajivibelia. ");
INSERT INTO guh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsanë Dioso pejumecovënëtsinë pibisiacuene papecatoexanaejava, itsa pavënëlivaisitaename, xaniavaetsia payanijobianame caenëjavata. Nexata xaniavaetsia itsa panabarëcuaicuaijamëbeje, panabarajamatabëcuene xanepanaenamebeje. ");
INSERT INTO guh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Xaniavaetsia itsa apo pacabarëcuaicuaijai tsane, nexata Dioso pejumecovënëtsinë pajunatsianame caenë, anijanëbeje ata, paneyajavaponaenexa pibisiacuene papecatoexanaenëjavabelia pemuxujiobinexatsi. Nexata bajaraponëbeje pacajumetaena xaniavaetsia panebarëcuaicuaijaijava pibisiacuene papecatoexanaenëjavabelia. Bajarapacuenia itsa paexanaename, nexata pacuenia Dioso pejumelivaisibaxutota jumaitsi, paexanaename. ");
INSERT INTO guh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ponë pibisiacuene pacatoexana, itsa apo namuxunaevetsi tsane paneyajavaponaenëbeje ata pemuxujiobijava, nexata daxita Dioso pejumecovënëtsivi penacaetuatsijavata, payanijobianame papibisiacuene pacatoexana. Nexata ponë pibisiacuene pacatoexanaena, daxita Dioso pejumecovënëtsivi muxujiobianatsi. Bajaraponë itsa apo namuxunaevetsi tsane, muxujiobi atatsi Dioso pejumecovënëtsivi, nexata bajaraponë pataename Dioso apo pejumecovënëtsinëcuenia. Panavecuaitavetsianame pepatsiyaniva panenacaetuatsijavata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Icatsia Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Xua jivi paitavetsianame pexanaeyaniva mapanacuataje, bajaraxua Dioso athëbënacuatatsia ata itaveta. Xua jivi patocopatsianame pexanaenexa mapanacuataje, bajaraxua Dioso ata athëbënacuatatsia tocopata pexanaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacatsipaebijitsiatsinua mapacueniaje. Mapanacuata paanijanëmëbeje itsa panajamatabëcuenejëpamebeje xua pavajëtsijitsiamëbeje Diosojavabelia, nexata taxa, athëbëtatsia peecaenë, pacajumecovënëtsianabeje xua pavajëtamebeje. ");
INSERT INTO guh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsipaji itsajota anijajivibeje, acueyabi ata, nacaetuata, tanejumecovënëtsivi, bajarajota xanë bajarapamonae yajavaecaenajë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nexata Pedro imoxoyolia Jesús. Pedro jumaitsi Jesúsjavabelia: —Tajatuxanenë, panetsipaebame rabaja. Panejumaitsimë mapacueniaje: “Itsajivi Dioso pejumecovënëtsijivi pibisiacuene itsa pacaexanaena, pajamatabëcaevianame. Barajamatabëcuenexanepanaeya pataename. Itsa pavënëlivaisitaename pibisiacuene papecatoexanaejava, xaniavaetsia payanijobianame caenëjavata. Nexata xaniavaetsia itsa panabarëcuaicuaijamëbeje, panabarajamatabëcuene xanepanaenamebeje,” panejamë. ¿Detsa xuabeje pibisiacuene nexanae ata, pibisiacuene netoexanae atanua, jamatabëcaevianajë barajamatabëcuenexanepanaeya tataenexa bajarapajivi? ¿Siete tsaja xuabeje ata? jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús nexata jumaitsi Pedrojavabelia: —Siete xuabejenexa yabara apo jumaitsinë. Biji rajane siete pasetentabeje pibisiacuene pacaexanae ata, pibisiacuene pacatoexanae atanua, pajamatabëcaevare barajamatabëcuenexanepanaeya panetaenexa, baitsi cuatrocientos noventa xuabeje ata, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús livaisi tsipaeba comparacióncuenia pijajivijavabelia. Jumaitsi mapacueniaje: —Dioso pijanacuatatsia pijajivijavabelia exanaena pacuenia nacuaevetsinë pijajivijavabelia baexana. Nacuaevetsinë jitsipa piamoneyabivitsi pematamotsinexatsi xua amoneyabatsi. ");
INSERT INTO guh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nexata itoroba pijajivi petotsipaebaponaenexatsi daxita pamonae amoneyabatsi. Nexata pijajivi tobarëparenatsi ponë bitso ayaijava amoneyabatsi, baitsi millones de pesos piamoneyabinëtsi. ");
INSERT INTO guh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nexata bajaraponë apo xainae pematamotsijavanexatsi. Nexata nacuaevetsinë itoroba pijajivi. Jumaitsi: “Mara ponë bitso ayaijava niamoneyabaje. Nexata pacanajetaxuabianame dajubicuenia itsamonaejavabelia amoneya petonacuenebaponaenexa daxitamatacabijavabelianexa. Daxita pexi, pijava ata, pecobecovë ata yajava, pacanajetaxuabianame. Bajarapacuenia pitsianajë tsiquirijavayo ata taneamoneyabijavamatamo,” jai nacuaevetsinë pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nexata ponë amoneyaba, nacuaevetsinë pitabarata pematabacabëta nucajunua. Pinijicuenia vajëta nacuaevetsinëjavabelia. Jumaitsi: “Nejamatabëcueneevere abaxë. Camatamotsianatsi rabaja daxita xua camoneyabatsi,” jai. ");
INSERT INTO guh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nexata nacuaevetsinë itaxutotsoniatane piamoneyabinëtsi. Nexata nacuaevetsinë jumaitsi piamoneyabinëtsijavabelia: “Daxita rabaja taneamoneyabijavamë, iquinajë. Nexata baja apo nematamotsimë tsane,” jai nacuaevetsinë piamoneyabinëtsijavabelia. Bajaraxuacujinae copata baja penaviatsinexa. ");
INSERT INTO guh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nexata bajaraponë penaviatsinexa, ajena pitsapalia nacuaevetsinë pijabovecua, caxitajarabaxuaba itsanë penajuanacuenebabiabinëbeje nacuaevetsinë pijajava. Bajaraponë nexata jamatabëjumaitsi: “Maponë tsiquirijavayovajëto niamoneyabi ataje, yanijobianajë tanematamotsinexa,” jamatabëjai. Nexata cuibocamisavaetaba. Cuibocuetsaca asaëyata. Jumaitsi bajaraponëjavabelia: “Nematamore taneamoneyabijavamë,” jai. ");
INSERT INTO guh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nexata piamoneyabinëtsi bajaraponë pitabarata pematabacabëta nucajunua. Pinijicuenia vajëta. Jumaitsi: “Nejamatabëcueneevere abaxë. Camatamotsianatsi raja itsiata daxita xua camoneyabatsi,” jai. ");
INSERT INTO guh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Itsiata baitsi jane bajaraponë piamoneyabinëtsi apo itaxutotsoniatae. Barëpona baja penaneconitsivi pejebabiabibojavabelia penaneconitsiaexanaenexa. Bajarapacuenia pematamotsinexatsi daxita piamoneyabijavatsi. ");
INSERT INTO guh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nexata nacuaevetsinë pijajivi itsa tane bajarapacuenia pexanaejava penajua nacuenebabiabinëbejejavabelia, bajarapamonae bitso najamatabëxaina. Nexata nacuaevetsinë pijajivi ponalia petsipaebinexa bajaraxua pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nexata nacuaevetsinë pijajivi itsa tsipaebatsi, itoroba icatsia pijajivi petojunatsinexatsi bajaraponë. Nexata itsa tocapatatsi, nacuaevetsinë jumaitsi bajaraponëjavabelia: “Niajamatabëcuenebejenë baja rovia. Catoiquinatsi rabaja picani taneamoneyabijavamë. Tsipaji pinijicuenia nevajëtame. ");
INSERT INTO guh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pacuenia caitaxutotsoniatanetsi, bajara pijinia pacuenia itaxutotsoniataejitsipame pecaamoneyabinë,” jai nacuaevetsinë. ");
INSERT INTO guh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nexata nacuaevetsinë bitso baraanaepana millones de pesos piamoneyabinëtsijavabelia. Nexata nacuaevetsinë jumaitsi pijajivijavabelia: “Bajaraponë pacaponaeremelia penaneconitsivi pejebabiabibojavabelia penaneconitsiaexanaenexatsi. Bajarajota naneconitsiaponaponaena ëpematamoveretsijavabelianexa daxita taneamoneyabijava,” jai nacuaevetsinë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús icatsia jumaitsi pijajivijavabelia: —Bajara pijinia pacuenia paxamë ata taxa, athëbëtatsia peecaenë, pacaexanaena, itsa apo pajamatabëcaevimë tsane panebarajamatabëcuene xanepanaenexa pamonae pacaitsacueniaba, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús pijajivi pemuxujiobicujinae pebarajamatabëcuene xanepanaenexa itsamonae itsacueniabi atatsi, Jesús baja pona Galilea nacuavecua. Jesús nexata pata Judea nacuayabelia, Jordánmene itsapanabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jivi ayaibitsaëtoxaneto pënaponatsi. Bajarajotalia Jesús jamatejemayaexana piavitanevi. ");
INSERT INTO guh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nexata fariseovi Jesús imoxoyorenatsi. Jamatabëcueneëjëbiaya yanijobatsi. Jesús bijiaya itsa jumecanaviata, peneconitsinexatsi picani. Nexata fariseovi jumaitsi Jesúsjavabelia: —¿Xanepana tsaja penacojiobinë pijava pexuabinexa itsacuenejavayo ata yabara? jai fariseovi. ");
INSERT INTO guh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús nexata jumaitsi fariseovijavabelia: —¿Apo palebimë tsipaji paneyapëtaenexa pacuenia Dioso pejumelivaisibaxutota jumaitsi? Pamatacabi Dioso taxuxuaba nacua pexanaejava, bajarapamatacabi Dioso exana pebi, pijava yajava. ");
INSERT INTO guh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nexata Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: “Pebi itsa nacojioba pijavajavabelia, banatsata paxavecua, pena atavecua. Nexata Dioso tane anijajivimibeje becaejivi,” jai Dioso pejumelivaisibaxutota. ");
INSERT INTO guh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nexata Dioso apo tae beanijajivibeje. Becaejivi saya tane Dioso. Bajaraxuata itsanë ata apo bexuabi pijava. Tsipaji Dioso pejamatabëcueneta napitsiaexanatsibeje, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nexata icatsia fariseovi jumaitsi Jesúsjavabelia: —¿Detsa xuajitsia bajayata Moiséspijinë copata penacojiobinë petoyaquinaenexa cuyalatobaxuto pijava pitavetsilivaisi pexuabinexa bajarapacuenia? jai fariseovi. ");
INSERT INTO guh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús nexata jumaitsi fariseovijavabelia: —Paneajamatabëcuenetajaxae, Moiséspijinë pacatocopata bajarapacuenia paneexanaenexa panexuabinexa panijavajivi. Itsiata baitsi jane Dioso pexanaejivibejejavaveliacujinae, apo tocopatsi picani bajarapacuenia pexanaenexa. ");
INSERT INTO guh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nexata mapacuenia pacatsipaebianatsije. Ponë pijava xuaba, itsanëjavabelia bajarapova pevitota pibisiacuene apo vecuaexanae atatsi, bajaraponë naneconita Diosojavabelia pijava pexuabixae. Nexata pijava pexuabinë itsa nacojioba icatsia itsavajavabelia, bajaraponë pibisiacuene exana pevitota. Tsipaji pepo pijavavecua jaita itsava. Dioso cajena abaxë bajaraponë pexuabiva pijavacuenia totanetsi. Ponë ata itsanë pexuabiva pita, bajaraponë ata pibisiacuene exana pevitota. Tsipaji itsanë pijavami pita, pova abaxë Dioso totanetsi itsanë pijavacuenia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nexata Jesús pijajivi jumaitsi Jesúsjavabelia: —Itsa bajarapacuenia pebi apo tocopatsitsi itaxutojema pijava pexuabinexa, nexata meta baja apo benacojiobi, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús nexata jumaitsi pijajivijavabelia: —Daxitajivi apo nejumeyapëtae tsane xua yabara jumaitsinë. Itsiata nejumeyapëtaena pamonae Dioso jamatabëcueneyavenonatsi. ");
INSERT INTO guh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Apo caejamatabëcuene raja xua yabara pebijivi apo nacojiobi. Itsamonae penabejenaenë naexana. Nexata apo caëjëpaetsi penacojiobijava. Itsamonae jivi pejamatabëcueneta bepenabejenaenëcuenia exanatsi. Nexata apo caëjëpaetsi penacojiobijava. Itsamonae ëDioso pijacuene petonacuenebinexa, apo nacojiobi. Nexata ponë jamatabëcuenecaëjëpatsi nacojiobinejeva peponaponaenexa ëDioso pijacuene petonacuenebinexa, bajaraponë nejumecovënëtsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesúsjavaberena itsamonae pejevaxijivixi tocapataponatsi Jesús pecobeta pejayataponaenexa. Petovajëtsinexatsinua Diosojavabelia, tocapataponatsi. Nexata Jesús pijajivi itaveta pexi pecapatsivi. Jesús pijajivi jumaitsi pexi pecapatsivijavabelia: —Pëtsa patocapataponame panexi Jesúsjavaberena, jai. ");
INSERT INTO guh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nexata Jesús jumaitsi pijajivijavabelia: —Pëtsa paitavetame. Pacopare pejevaxijivixi pepatsinexa xanëjavaberena. Mapitsipejevaxijivixije jumeaebinejeva, xaniavaetsia bajumecovënëta palivaisi tsipaebatsi. Nexata pamonae jitsipa pejonejava Dioso pijanacuayabetsia, bajara pijinia pacuenia jumeaebinejeva, xaniavaetsia bejumecovënëta Dioso pejumelivaisi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús nexata pecobeta jayatapona pejevaxijivixi, caejiviyo canacujitsia. Bajaraxuacujinae Jesús baja pona bajarapanacuavecua. ");
INSERT INTO guh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pevëjëato pata Jesúsjavaberena. Nexata pevëjëato jumaitsi Jesúsjavabelia: —Petuxanenë, pexaniajamatabëcuenenëmë. ¿Detsa pitsicuene, pexaniacuene, exanaenajë taxainaenexa matacabi apo pevereverecaejava? jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús nexata jumaitsi pevëjëatojavabelia: —¿Detsa xuajitsia: “Pexaniajamatabëcuenenëmë,” nejamë? Ajibi raja itsapebi ata pexaniajamatabëcuenenë. Caenë rabaja Dioso pexaniajamatabëcuenenë. Itsiata itsa jitsipame nexainaenexa matacabi apo pevereverecaejava, jumecovënëre pacuenia Dioso pejumelivaisita itoroba jivi pejumecovënëtsinexa, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nexata pevëjëato jumaitsi Jesúsjavabelia: —¿Detsa palivaisi nexata jumecovënëtsianajë? jai. Nexata Jesús jumaitsi pevëjëatojavabelia: —Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: “Pëtsa beyaxuabame jivitonë. Pëtsa jaitame itsava nijavavecua. Pëtsa nacobetoxotame. Pëtsa itsamonae pexanaejava yabara najumetsënëtsiaya paebame. ");
INSERT INTO guh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Axa yaiyataema. Ena ata yaiyataema. Asivamëre itsajivi ata pacuenia xamë nijacuata nasivamë,” jai Dioso pejumelivaisibaxutota, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pevëjëato nexata jumaitsi Jesúsjavabelia: —Daxita rabaja bajarapalivaisianë jumecovënëtajë. ¿Detsa xua netosaica abaxë taexanaenexa? jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nexata Jesús jumaitsi pevëjëatojavabelia: —Itsa jitsipame pepacuene nejamatabëcuenexanepanaejava, nejamatabëcuenevitsabijavanua, nexata ponare. Canajetsianame daxita xua xainame. Bajarapamatamomi tsicobetsanaename bepejiobivi. Nexata bajarapacuenia xainaename bitso nexainaejava Dioso pijanacuatatsia. Bajaraxuacujinae nepënaponaename, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nexata pevëjëato itsa jumetane bajarapacuenia Jesús pejumaitsijava, najamatabëxainaeya baja vecuapona Jesús. Tsipaji pevëjëato daxitacuene bitso pexainaenë. Nexata pevëjëato apo jamatabëjumecovënëtsi palivaisi Jesús tsipaeba. ");
INSERT INTO guh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nexata pevëjëato pecovëta Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Ponë bitso daxitacuene pexainaenë, tsiayapëbejetsi bitso penajamatabëcuenecopatsinexa Diosojavabelia pecapanepaenexatsi Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Icatsia matavëjëa pacajumaitsitsi. Pacuenia camello acuenebi pejonejava palutaetoitaxutovojotualia, bajara pijinia pacuenia bitso pexainaenë acuenebi tsane pejonejava Dioso pijatomarabetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesús pijajivi itsa jumetane bajarapacuenia Jesús pejumaitsijava, bitso jamatabëcuenenabenajaca. Jesús pijajivi jumaitsi Jesúsjavabelia: —¿Detsa nexata pitsivi panepaena Diosojavabelia bitso pexainaevi ata itsa apo panepae tsane Diosojavabelia? jai. ");
INSERT INTO guh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús asaëya naëcota pijajivijavabelia. Jumaitsi pijajivijavabelia: —Jivi raja apo caëjëpaetsi pijacuata penacapanepaenexa Diosojavabelia. Caenë Dioso caëjëpatsi. Dioso raja caëjëpatsi daxitacuene pexanaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nexata Pedro jumaitsi Jesúsjavabelia: —Patajatuxanenë, paxanë rabaja pacopatajë daxitacuene pataxainaejavami. Nexata baja pacapënajinavanapatsi. ¿Detsa xua meta panerajutsiana? jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nexata Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi daxitacuene pejanajava icatsia naexanaena, xanë, Daxitajivi Pematapijinënë, ecaenajë tronovënëjavata taevetsinexa daxitajivi. Bajarapamatacabi paxamë ata, doce paponëmëbeje patanepënajinavanapaevimë, paenaename, pacaenëmë canacujitsia, panijatronota vajanajuaevetsinexa xua evetsianajë. Nexata paxamë paenaename jueznëcuenia panenaneconitsiaexanaenexa pijaneconi pexainaevi. Pananeconitsiaexanaename Israelpijinëmi pexi, doce ponëmibeje, pemomoxi. ");
INSERT INTO guh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Daxita pamonae tajamatabëcueneta pueneta pijabomi, pematapijivi ata, pejuyapijivi ata, paxa ata, pena ata, pijava ata, pexi ata, pijairanë ata, Dioso nexata bajarapamonae rajutsianatsi ayaijava bitso pepuenetsijavanëmi matatoxenetsia. Caejavayomijamatabëcuene tsaponae, rajutsianatsi cien xuabeje tsaponae pevajënaeyabelia. Rajutsianatsinua matacabi apo pevereverecaejava. ");
INSERT INTO guh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pamonae aeconoxae mapamatacabitaje ayaijamatabëcuenevi tanetsi, bajarapamonae itsamatacabi Dioso beveliajamatabëcuenevi exanaenatsi. Pamonae pijinia mapamatacabitaje beveliajamatabëcuenevi tanetsi, bajarapamonae itsamatacabi Dioso ayaijamatabëcuenevi exanaenatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Icatsia Jesús jumaitsi pijajivijavabelia: —Aeconoxae Dioso pejumelivaisi comparacióncuenia pacatsipaebianatsi patanejumeyapëtaenexamë. Dioso pijajivi pematamotsijava pijanacuatatsia, jëpa mapalivaisije. Pabixaneto pexainaenë ponapona. Ajena matacabi tsarucaponae, naropota jivi pejaitsinë petonacuenebinexatsi uvavënëjava peubipabita. ");
INSERT INTO guh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Caxitajarabaxuaba baja nexata jivi. Junata petonacuenebinexatsi. Caematacabi matamotsiapaeba caedenario. Jejai nexata bajarapamonae. Nexata itoroba pijapabiabelia petonacuenebinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bajaraxuacujinae juameto baja tajë itsa rucaina, a las nueve, naropota icatsia. Taenuba tomara tuatuajëta pebijivi, saya jema pejinavanapaevi. ");
INSERT INTO guh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nexata jumaitsi bajarapamonaejavabelia: “Paxamë ata paponaremelia tajapabiabelia. Panetonacuenebianame. Pacamatamotsianatsi raja xaniavaetsia,” jai pabixainaenë. ");
INSERT INTO guh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nexata bajarapamonae ata ponalia petonacuenebinexatsi. Bajaraxuacujinae, matonejeepatota, junata icatsia itsamonae. Bajarapamonae ata ponalia petonacuenebinexatsi. Bajaraxuacujinae, bejamatabëcuene a las tres, junata icatsia itsamonae. Bajarapamonae ata ponalia petonacuenebinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bajaraxuacujinae, caniviyo, bejamatabëcuene a las cinco, pabixainaenë icatsia pona tomara tuatuajëareca. Caxitajarabaxuaba icatsia pebijivi, saya jema pejinavanapaevi. Nexata pabixainaenë jumaitsi bajarapamonaejavabelia: “¿Detsa xuajitsia saya daxitamatacabi pajinavanapame panacuenebinejevamë?” jai. ");
INSERT INTO guh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nexata bajarapamonae jumaitsi: “Tsipaji itsajivi ata apo panejunatsi patatonacuenebinexa,” jai. Nexata pabixainaenë jumaitsi: “Paxamë ata paponaremelia tajapabiabelia patanetonacuenebinexamë. Pacamatamotsianatsi raja xaniavaetsia,” jai pabixainaenë. Nexata bajarapamonae jejai. Ponalia petonacuenebinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nexata baja juameto itsa tabujuniya, pabixainaenë jumaitsi pijajivitonëjavabelia: “Junare baja tanetonacuenebivi. Matamobare baja. Copiaya matamobare pamonae pepacotocaevi pejonevi. Pamonae pepacopiaya pejonevi cotocaevi matamobianame,” jai pabixainaenë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nexata pamonae pepacotocaevi junua a las cinco penacuenebinexa, parena pematamobinexatsi. Nexata caenë canacujitsia matamobatsi caedenario. ");
INSERT INTO guh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nexata daxita pamonae bajayacunua pepacopiaya junua penacuenebinexa, pepacotocaevi juya parena pematamobinexatsi. Nexata bajarapamonae jamatabëjumaitsi: “Caedenario meta pematatsënëa vaxaitsi nacamatamobiana. Tsipaji copiaya vaxaitsi junuatsi vajanacuenebinexa,” jamatabëjai bajarapamonae. Itsiata baitsi jane bajarapamonae ata, caenë canacujitsia, matamobatsi caedenario tsaponae. ");
INSERT INTO guh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nexata bajarapamonae penacuenebimatamo baja itsa nota, baraanaepana pabixainaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jumaitsi bajarapamonae: “Mapamonae cotocaevi pepatsivi, nacueneba saya caehora. Paxanë baja rovia ayaicuenia panacuenebajë. Icotia daxitamatacabi panetsajava. Itsiata mapamonae matamobame pacuenia panematamobame,” jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Itsiata baitsi jane pabixainaenë jumaitsi bajara pamonaeyajuvënënëjavabelia: “Itsacuenejavayo ata pibisiacuene apo pacaexanaetsi. Patacajunatsijavata patanetonacuenebinexamë, caedenario pacatsipaebatsi patacamatamotsinexa patanetonacuenebimatamomë. Nexata baja bajarapacuenia pacarajutatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Panijamatamo baja papitame. Paponare baja panijabonëjavabelia. Pamonae cotocaevi junua tanetonacuenebinexa, bajarapamonae ata matamobajë pacuenia pacamatamobatsi. Bajarapacuenia matamobajë pacuenia xanë jitsipajë. ");
INSERT INTO guh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tajapalataxae, netoxanepana pacuenia jitsipajë tarajutsinexa. ¿Pacobecaëbame tsaja bajarapamonae ayaijava tarajutsixae? jai pabixainaenë petonacuenebivitsi yajuvënënëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bajara pijinia pacuenia Dioso ata, pacuenia jitsipa, exanaena pijajivijavabelia. Pamonae mapanacuata ayaijamatabëcuenevi tanetsi, bajarapamonae itsamatacabi Dioso beveliajamatabëcuenevi exanaenatsi. Pamonae pijinia mapanacuata beveliajamatabëcuenevi tanetsi, bajarapamonae itsamatacabi Dioso ayaijamatabëcuenevi exanaenatsi. Bajarapacuenia Dioso exanaena tsipaji picani jivi ayaibitsaëtoxaneto Dioso junata. Itsiata bajarapamonaeyajuvënëvi, caejiviyobeje saya, Dioso jumecovënëta, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús pona Jerusalén tomarabelia. Nexata Jesús, pijajivi ayaibitsaëto yajava, najetaruca namutua, itsamonae yajava. Nexata bajarapamonaevecua ëpijajivi, doce ponëbeje, Jesús junata pimoxoyotsinexatsi. Nexata Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba pijajivijavabelia. Jesús jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Panejumetaema. Mara Jerusalén tomarabelia ponatsije. Bajarajotalia xanë, Daxitajivi Pematapijinënë, tanevaetabinexa necanajetsiana sacerdotevi penamatacaitorobivi pecobeyabelia. Necanajetsiana judíovi pecujarubivi pecobeyabelia ata. Nexata xanë neneconitsiana tanebeyaxuabinexa. ");
INSERT INTO guh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bajaraxuacujinae icatsia necanajetsiana itsanacuaverena pepatsivi pecobeyabelia. Bajarapamonae necanecaponaena. Nejumatitibabena penaneconitsivi pejumaconitabiabimacata. Bajaraxuacujinae cruzajavabelia necobematabiabarutsiana tatëpaenexa. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Santiagobeje Juanbeje paxa pevënë Zebedeo. Nexata bajaraponëbeje pena barëliatsibeje Jesúsjavabelia. Bajarapova pematabacabëta nucajunua Jesús pitabarata. Vajëta pexaniacuene petoexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nexata Jesús jumaitsi bajarapovajavabelia: —¿Detsa pitsicuene jitsipame tacatoexanaenexa? jai Jesús. Nexata bajarapova jumaitsi Jesúsjavabelia: —Pamatacabi daxitacuene evetsianame, tocopatsianame taxënatobeje nemuxuneneta penaecaenexabeje panenajuaevetsinexa. Itsanë tocopatsianame necujanenia peecaenexa. Itsanë tocopatsianame netsavenonenia peecaenexa, jai bajarapova Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nexata Jesús jumaitsi Santiagobeje Juanbejejavabelia: —Paxamëbeje apo payapëtaemëbeje xua pavajëcaeyaexanamebeje ena xanëjavaberena. ¿Pacacaëjëpabeje tsaja panenacaevetsinexabeje papecabejiobiaexanaenexabeje pacuenia xanë nacaevetsianajë tanebejiobiaexanaenexa? ¿Pacacaëjëpabejenua tsaja panenacaevetsinexabeje papecabeyaxuabinexabeje pacuenia xanë nacaevetsianajë tanebeyaxuabinexa? jai Jesús Santiagobeje Juanbejejavabelia. Nexata Santiagobeje Juanbeje jumaitsibeje: —Jãjã, panecaëjëpabeje cajena, jaibeje. ");
INSERT INTO guh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nexata icatsia Jesús jumaitsi Santiagobeje Juanbejejavabelia: —Paxaniajamëbeje rabaja. Paxamëbeje pacabejiobiaexanaenabeje pacuenia xanë nebejiobiaexanaena. Pacabeyaxuabianabejenua pacuenia xanë nebeyaxuabiana. Itsiata baitsi jane xua panevajëtamebeje panenaecaenexabeje, itsanë tacujuanenia, itsanë tatsavenonenia, bajaraxua Dioso apo netocopatsi patacatocopatsinexabeje. Tsipaji raja taxa Dioso ëpitapetsivinexa abaxë bajaraxua toxaniavaeta, jai Jesús Santiagobeje Juanbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nexata diez ponëbeje Jesús pijajivi vënëtane pepëya bajaraxua Santiagobeje Juanbeje Jesúsjavabelia pevajëcaejavabeje. Nexata bajarapamonae jamatabëcuenebaraanaepana Santiagobeje Juanbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nexata Jesús daxita pijajivi junata. Jesús jumaitsi pijajivijavabelia: —Payapëtaneme rabaja pacuenia nacuaevetsivi exana. Eveta caenacua canacujitsia. Nexata nacuaevetsivi pijajivicuenia eveta pamonae jinavanapa pevetsinacuanëjava. Nexata bajarapanacuanë pevetsivi ayaijamatabëcuenevi nataeyabiaba. Xua jamatabëitoroba pevetsinacuanëjava pejinavanapaevi petoexanaenexatsi, ajumesaëya itorobabiaba petoexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pëtsa paxamë bajarapamonae cuenejëpaeya bajarapacuenia paexaname itsamonaejavabelia. Biji rajane ponë paxamëyajuvënënë jitsipa ayaijamatabëcuenenë penaexanaenexa daxita paxamëvecua, bajaraponë daxita paxamë bepanijajivitonëcuenia bepacayavenonabiaba. ");
INSERT INTO guh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ponë paxamëyajuvënënë jitsipa penaexanaenexa papecanamatacaitorobinënexa, bajaraponë daxita paxamë bepanijajivitonëcuenia bepacayavenonabiaba. ");
INSERT INTO guh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsipaji rabaja xanë ata, Daxitajivi Pematapijinë atanë, apo patajopaenë jivi taneyavenonaenexa. Biji rajane xanë patajopajë tayavenonaenexa daxitajivi. Patajopajë tasivatëpaenexa jivi ayaibitsaëtoxaneto pibisiacuene pexanaeneconimi taneconimatamotsinexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús, pijajivi yajava, pitsapa Jericó tomaravecua. Nexata jivi ayaibitsaëto pënaponatsi. ");
INSERT INTO guh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Panamutojava Jesús najetaruca, bajarapanamutojavata ecabeje bitso pitaxutotsëcënaenëbeje, apo petaenëbeje. Nexata bajaraponëbeje itsa jumetanebeje bajarapanamutua imoxoyo Jesús penajetarucaejava, vavajaibeje tsecae. —¡Jesús, Davidpijinë pemomomë, paneitaxutotsoniataemabeje! jaibeje tsecae pitaxutotsëcënaenëbeje. ");
INSERT INTO guh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jivi picani jumeitavetatsibeje pemoyanexabeje tsecae. Itsiata biji bitsoyo orijibia vavajaibeje tsecae. —¡Jesús, Davidpijinë pemomomë, paneitaxutotsoniataemabeje! jaibeje tsecae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nexata Jesús muxunanucojopa. Junata pitaxutotsëcënaenëbeje. Jesús jumaitsi bajaraponëbejejavabelia: —¿Detsa xua pajitsipamebeje patacaexanaenexabeje? jai. ");
INSERT INTO guh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nexata bajaraponëbeje jumaitsibeje Jesúsjavabelia: —Jesús, pajitsipajëbeje pataitaxutoxanepanaejavabeje, jaibeje tsecae. ");
INSERT INTO guh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nexata Jesús itaxutotsoniatane bajaraponëbeje. Jesús itaxutojayata bajaraponëbeje. Bajarajota caecuenia bajaraponëbeje itaxutoxanepanabeje baja. Nexata bajaraponëbeje Jesús pepëta naponabeje. ");
INSERT INTO guh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús baja pijajivi barëimoxoyotanajetaruca Jerusaléntomara. Barëpata baja Betfagé tomarata. Patsutojumata nubena olivonaenë, bajarapatsutoyenepanata eca Betfagétomara. Nexata Betfagé tomarata Jesús jumaitsi pijajivitonëbejejavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Paponarebeje mapatomarayo ecaliajejavabelia. Bajarajotalia, ajena papatsiaremeliabeje, pataenutsianamebeje burro pecëtanutsinëtsi, pexënatonëyo yajava. Paisinaenamebeje bajarapaburrobeje. Payamaëyacarenamëbeje tsane. ");
INSERT INTO guh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“¿Detsa xuajitsia burrobeje paisinamebeje?” itsa pacajaibeje tsane itsajivi, nexata pajumaitsimëbeje tsane: “Vajatuxanenë raja namatavenona. Aeconoxae raja icatsia canaviatsiarena,” pajamëbeje tsane, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bajarapacuenia Jesús itsa jumaitsi, tocopiapatatsi jane baja pacuenia Diosojumepaebinëmi profetanë bajayata tajëvelia yaquina Jesús pepatsijavanexa yabara Jerusalén tomarata. Jerusalén tomarata Jesús pepatsijavanexa yabara, profetanëmi bajayata peyaquinaelivaisita jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pajumaitsimë tsane Jerusalén tomarapijivijavabelia: “Pataename pepo paneevetsinë paxamëjavaberena penajetarucaejava. Beveliajamatabëcuenenëcuenia najetarucaena. Pejanaburroyota yapatanajetarucaena,” pajamë tsane Jerusalén tomarapijivijavabelia, jai bajayata tajëvelia profetanëmi peyaquinaelivaisita Jerusalén tomarata Jesús pepatsijavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nexata Jesús pijajivitonëbeje liabeje. Jumecovënëtabeje pacuenia Jesús itorobatsibeje. ");
INSERT INTO guh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yamaëya carenabeje burro, pexënatonëyo yajava. Nexata bajarapaburrobeje Jesús pijajivi tsijumajeba pijacama,” pajamë tsane Jerusalén tomarapijivijavabelia, jai bajayata tajëvelia profetanëmi peyaisajumavelia penaxatabijavanë. Jesús yanajetaruca burrota. ");
INSERT INTO guh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Panamutuarena Jesús najetaruca, bajarapanamutuarena jivi ayaibitsaëtoxaneto, pijacamisajumavelia penaxatabijavanë, Jesús pevajënaeya namutua yerequejebapona. Itsamonae naemaxërananë, pebaxu yajava, ucubaba. Nexata namutua Jesús tsivajënaeitabëtsiaya jebaponatsi yaiyataeya pecopiapitsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesús penajetarucaejavata jivi ayaibitsaëtoxaneto Jesús pevajënaeya namataxainaeya najetarubena. Itsabitsaëtoxaneto Jesús pecovëya cotocaevanajetarubena. Daxita bajarapamonae vavajai tsanajetarubenae. Jumaitsi tsanajetarubenae: —¡Dioso yavenonaenatsi maponëje, pepo nacuaevetsinëmi Davidpijinë pemomo! ¡Dioso yavenonaenatsi maponë najetarucaje nacua pevetsinënexa Dioso pejamatabëcueneta! Nexata vaxaitsi pexaniajamatabëcuene rajutatsi Diosojavabelia, jai tsanajetarubenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nexata Jesús itsa pata Jerusalén tomarata, daxita Jerusalén tomarapijivi jamatabëcuenenabenajaca. Nexata nayanijoba. —¿Detsa meta maponë najetarucaje? najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nexata jivi jumaitsi: —Jesús ra manajetarucaje, Diosojumepaebinë profetanë. Galilea nacuata peecaetomara, Nazaret tomarapijinë, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús itsa pata Jerusalén tomarata, joneya temploboyalia. Nexata templobota Jesús tane pecanajetabiabivi, pecomuacaevinua. Nexata daxitaitsi: —Jesús ra manajetarucaje, Diosojumepaebinë profetanë. Galilea nacuata peecaetomara, Nazaret tom bajarapamonae Jesús pitsapaeyaexana templobovecua. Palata pecambiababiabivi ata pijamesanëmi Jesús topënëyorobajaraba. Ucucu pecanajetabiabivi ata penabiabijavanëminua topënëyorobajaraba. ");
INSERT INTO guh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús jumaitsi bajarapamonaejavabelia: —Dioso baja cajena pejumelivaisibaxutota mapatemplobo yabara tajëvelia jumaitsi mapacueniaje: “Tajabo raja jivi xanëjavaberena penavajëcaebo tsane,” jai Dioso pejumaitsijava Dioso pejumelivaisibaxutota. Itsiata baitsi jane paxamë yamaxëitojorobiaya panenacobetoxotsinexa panacaetuatabiabame mapabotaje, jai Jesús templobota pecanajetabiabivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bajarajota templobota Jesús imoxoyorenatsi pitaxutotsëcënaevi, pejayujayunaevinua. Nexata Jesús bajarapamonae xanepanaeyaexana. ");
INSERT INTO guh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Templobota nubena sacerdotevi. Nubena judíovi pecujarubivinua. Bajarapamonae taenubena Jesús pitaxutoxanepanaeyaexanaejava pitaxutotsëcënaevi. Taenubenanua Jesús pexanepanaeyaexanaejava pejayujayunaevi. Jumetaenubenanua pejevaxi templobota pevavajaijavata pejumaitsijava Jesús yabara: “¡Dioso yavenonaenatsi maponëje, pepo nacuaevetsinëmi Davidpijinë pemomo!” pejaijava Jesús yabara. Bajaraxuata sacerdotevi baraanaepanatsi Jesús. Judíovi pecujarubivi ata baraanaepanatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nexata bajarapamonae jumaitsi Jesúsjavabelia: —¿Tsipaji apo jumetaemë mapapejevaxi xamë yabara pejumaitsaponaejavaje? ¿Apo necajumeitavetsi? jai. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Jãjã. Jumetaniji picani. Itsiata apo jumeitavetsinë. ¿Paxamë tsipaji Dioso pejumelivaisibaxuto apo palebimë paneyapëtaenexa pacuenia tajëvelia jumaitsi xanë yabara bajarapapejevaxi pevavajaijavanexa? Dioso pejumaitsijava xanëjavaberena, tajëvelia Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: Pejevaxi, mitoapaenacuetoxi ata, naxëanaeyaexanaename penaxëanaejavata xamëjavaberena pecajumaitsinexa: “Ayaijamatabëcuenenëmë bitso,” pecajainexa, jai Dioso pejumelivaisibaxutota xanëjavaberena Dioso pejumaitsijava. Bajaraxuata mapapejevaxije jumaitsi bajarapacuenia, jai Jesús sacerdotevijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nexata baja Jesús bajarapamonaevecua pona. Jerusalén tomaravecua pitsapa. Navialia Betania tomarayojavabelia. Nexata Jesús Betania tomarayota majita. ");
INSERT INTO guh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jesús pijajivi Betania tomarata pebarëmajitsicujinae, meravia pitsijavata, bajayacunua, Jesús pijajivi barëlia icatsia Jerusalén tomarabelia. Jesús nexata namutua penajetarucaejavata, piajani. ");
INSERT INTO guh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jesús nexata taenuta higueranae namuto muxuneneta. Nexata Jesús imoxoyolia higueranae, pecuai itsa xaina, pexaenexa. Pecuai itsiata apo xainae higueranae. Ëpebaxu saya tsanucae. Bajaraxuata nexata Jesús jumaitsi higueranaejavabelia: —¡Xamë baja apo nacuaitsimë tsane! jai Jesús. Bajarapacuenia Jesús pejumaitsijavata, bepijia higueranae tëpanajereca yatabutopaya. ");
INSERT INTO guh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nexata Jesús pijajivi itsa tane bajaraxua, jamatabëcuenenabenajaca. Nexata Jesús pijajivi nayanijoba. —¿Detsa pacuenia maponae bepijia tëpanajerecaje? najai. ");
INSERT INTO guh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nexata Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Itsa pajamatabëjumaitsimë tsipae Dioso yabara: “Dioso nejumecovënëtsiana xua vajëtsianajë Diosojavabelia,” itsa pajamatabëjamë tsipae, nexata paxamë ata pacacaëjëpaejitsipa paneexanaenexa pacuenia exanajë mapahigueranaejavabeliaje. Itsiata ëbajarapacuene paneexanaenexa, apo pacacaëjëpae tsipae. Pematatsënëa itsacuenejavanënua paneexanaenexa, pacacaëjëpaejitsipa. Nexata itsa pajumaitsimë tsipae mapatsutojavabelia ataje: “Natixire majotavecuaje. Pucaxanetojavabelia jopare,” itsa pajamë tsipae, pacajumecovënëtsipa. Nexata mapatsuto ataje paneitorobicuenia pacajumecovënëtsipa. ");
INSERT INTO guh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nexata daxitacuene xua pavajëtsianame Diosojavabelia, pasivajamatabëjumaitsimë tsane mapacueniaje: “Xua vajëtajë Diosojavabelia, pepacuene Dioso nejumecovënëtsiana,” pasivajamatabëjamë tsane. Nexata xua pavajëtsianame Diosojavabelia, Dioso pacajumecovënëtsiana, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús junua temploboyalia. Nexata templobota Jesús jivi livaisi tsipaeba. Nexata templobota Jesús imoxoyorenatsi sacerdotevi, judíovi pijaancianovi yajava. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —¿Jipatsa pejamatabëcueneta pecanajetabiabivi, pecomuacaevinua, capitsapame mapatemplobopanabovecuaje? jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Xanë copiaya caejumeyo pacayanijobianatsi. Itsa paxamë panejumecanaviatsianame, nexata xanë juya pacatsipaebianatsi ponë nitoroba taexanaenexa bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Jipatsa jane pejamatabëcueneta Juanpijinë jivi bautisabaponapona? ¿Dioso tsaja pejamatabëcueneta? Itsa jume, ¿jivi tsaja pejamatabëcueneta? jai Jesús bajarapamonaejavabelia. Nexata ëpamonae nabarëcuaicuaijai. Najumaitsi: —¿De meta pacuenia jumecanaviatsianatsi? Vaxaitsi itsa jumai tsipaetsi: “Dioso raja pejamatabëcueneta,” itsa jai tsipaetsi, nexata Jesús nacajumai tsipae: “¿Detsa nexata xuajitsia apo pajumecovënëtsimë Juanpijinë pepaebilivaisi?” nacajai tsipae. ");
INSERT INTO guh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Jivi raja saya pejamatabëcueneta Juanpijinë jivi bautisabaponapona,” itsa jai tsipaetsi, nexata jivi belia nacabeyejebijitsipa. Bajarapacuenia nacabeyejebijitsipa tsipaji raja Juanpijinë yabara daxitajivi sivajamatabëjumaitsi: “Juanpijinë raja pepacuene Diosojumepaebinëmi,” sivajamatabëjai, najai sacerdotevi, judíovi pijaancianovi yajava. ");
INSERT INTO guh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nexata saya bajarapamonae jumaitsi Jesúsjavabelia: —Apo payapëtaenë ponë Juanpijinë itorobatsi jivi pebautisabaponaenexa, jai. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata xanë ata apo pacatsipaebi tsanetsi ponë nitoroba taexanaenexa bajarapacuene, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús icatsia jumaitsi sacerdotevijavabelia, judíovi pijaancianovijavabelia ata: —Panejumecanaëjëtsianame palivaisi aeconoxae pacatsipaebijitsiatsi. Pebi xaina anijanëbeje pexënatobeje. Nexata pexënatojavabelia jumaitsi: “Taxënato, ajena netonacuenebianame tajauvabacabota,” jai pexënatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nexata bajaraponë paxajavabelia jumaitsi: “¡Jume! ¡Apo jitsipaenë tanacuenebijava! jai. Itsiata xuacujinae bajaraponë icatsia najamatabëxaina. Nexata jamatabëjumaitsi: “Xanë baja rovia pibisiajamatabëcuene najamatabëxainajë. Nexata baja ponajë taxa tatonacuenebinexa,” jamatabëjai. Naropota baja penacuenebinë. ");
INSERT INTO guh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bajaraxuacujinae pexënatobeje pexainaenë pona icatsia itsanë pexënatojavabelia. Bajaraponëjavabelia ata jumaitsi: “Taxënato, ajena netonacuenebianame tajauvabacabota,” jai pexënatojavabelia. Nexata jejai itajara pexënato. Itsiata apo ponae. ");
INSERT INTO guh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Detsa ponë bajaraponëbejeyajuvënënë paxa jumecovënëta? jai Jesús bajarapamonaejavabelia. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Copiata ponë paxa itorobatsi, apo jejai ata, itsiata paxa tonacueneba, bajaraponë paxa jumecovënëta, jai. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajara pijinia itsane pamonae copabiana pibisiacuene pexanabiabijavami, pamonae najamatabëcuenepënëyorotsiana Diosojavabelia. Impuestomatamo gobierno pejamatabëcuene petomatamoyanijobabiabivimi ata jonena Dioso pijanacuayabetsia itsa najamatabëcuenepënëyorota Diosojavabelia. Petiriavi palata pepitsinexa pevitota pibisiacuene pexanabiabivimi ata jonena Dioso pijanacuayabetsia itsa najamatabëcuenepënëyorota Diosojavabelia pibisiacuene pexanabiabijavamivecua. Itsiata baitsi jane paxamë apo pajonemë tsane. ");
INSERT INTO guh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juanpijinë jivibautisabinë patajopa Dioso pejumelivaisi papecatsipaebinexa panenajamatabëcuene pënëyorotsinexa pibisiacuene paneexanabiabijavavecua. Itsiata paxamë apo pajumecovënëtsimë bajarapalivaisi. Itsiata bajarapalivaisi jumecovënëta impuestomatamo gobierno pejamatabëcuene pematamoyanijobabiabivi. Petiriavi palata pepitsinexa pevitota pibisiacuene pexanabiabivimi ata jumecovënëta bajarapalivaisi. Paxamë patae atamë bajarapamonae pejumecovënëtsijava, itsiata apo panajamatabëcuenepënëyorotsimë panejumecovënëtsinexa Dioso, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Icatsia Jesús jumaitsi sacerdotevijavabelia, judíovi pijaancianovijavabelia ata: —Xaniavaetsia panemuxunaevere mapalivaisije. Pijaira pexainaenë pijairata uba ayaibacaboxaneto uvavënëjava. Bajaraxuacujinae pijaira matatoyorotsia, ibopanaxanetonë mataropotsia pefaratsijavata, yacaranata. Bajarapayacaranatsijava athëbëabetsia apia jivitonë matatoxenetsia. Bajaraxuacujinae irata mëthë cueyeta. Nexata pecueyetsimëthëjavata exana uvacuaibarëmene pecayujucabiabijavanexa. Bajaraxuacujinae pijauvabacabo tuatuajëta exananuta piapiabotsia, penacuaitsimatacabi itsa tonaveretatsi, athëbëyo pevetabiabecaenexa pijauvabacabo. ’Nexata bajaraponë itsamonae evetsiaexana pijauvabacabo. Uvabacabo pexainaenë jumaitsi petoevetsivitsijavabelia: “Pamatacabi cuainaveretsiana, natsicobetsatsianatsi. Pamatacabi raja cuainaveretsiana, tajajivitonë itorobiarenajë xua panetotsatsianame tanetopitsinexa,” jai uvabacabo pexainaenë petoevetsivitsijavabelia. Nexata uvabacabo pexainaenë tajë nacuayabelia pona. ");
INSERT INTO guh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Itsa baja uvabacabo pexainaenë yapëtane pecopiapatsijava uvacuai penaveretsimatacabi penotsinexa, nexata uvabacabo pexainaenë itoroba pijajivi. Itoroba petoevetsivitsijavabelia petsicobetsatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nexata uvabacabo pexainaenë pijajivi uvabacabo petoevetsivitsi totaicatsi. Caenë bajarapamonaeyajuvënënë toconibabiatsi. Itsanë pepacuene tobeyaxuabatsi. Itsanë ibotonëta totseconatsi. ");
INSERT INTO guh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nexata uvabacabo pexainaenë icatsia itsabitsaëto pijajivi itorobalia. Bajara icatsia pacuenia exana uvabacabo pevetsivi. ");
INSERT INTO guh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Nexata uvabacabo pexainaenë itoroba icatsia pexënato jane baja. Uvabacabo pexainaenë jamatabëjumaitsi: “Netoyaiyataena meta taxënato,” jamatabëjai. ");
INSERT INTO guh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Itsiata baitsi jane uvabacabo petoevetsivitsi uvabacabo pexainaenë pexënato ata apo toyaiyataetsi. Itsa tane uvabacabo pexainaenë pexënato, bajarapamonae najumaitsi: “Mara ponëje paxa pevënamuto paxa pijauvabacabo pitsipaje. Naxanitsia. Beyaxuabatsi. Nexata raja vaxaitsi vajauvabacabo tsane,” najai uvabacabo petoevetsivitsi. ");
INSERT INTO guh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nexata icatsia uvabacabo pexainaenë pexënato ata tovaetabatsi. Caponaliatsi bajarapauvabacabo pënëyabelia. Nexata uvabacabo pexainaenë pexënato ata bajarapacuenia icatsia tobeyaxuabatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nexata bajarapalivaisi yabara Jesús yanijoba sacerdotevijavabelia, judíovi pijaancianovijavabelia ata. Jesús jumaitsi: —Uvabacabo pexainaenë itsa patsiarena, ¿de tsaeta xua exanaena uvabacabo petoevetsivitsijavabelia? jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Pijauvabacabo raeta pexainaenë apo itaxutotsoniatae tsane. Nexata verebiabiana bajarapamonaemi pibisiacuene pexanaevi. Nexata icatsia itsamonae evetsiaexanaena bajarapauvabacabo. Nexata uvacuai penaveretsimatacabi bajarapamonae itsa nota, tsicobetsatsianatsi pacuenia baja tocaëjëtatsi uvabacabo pexainaenë perajutsinexatsi, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Payapëtaneme rabaja pacuenia Dioso pejumelivaisibaxutota tajëvelia jumaitsi xanë yabara. Iboto pelivaisicuenia Dioso pejumelivaisibaxutota jumaitsi xanë yabara mapacueniaje: Paiboto itsamonae boexanaevi naitaxutojematabuatsiana petsitaabejexaetsi itajara, bajarapaiboto itsanë pitsiana. Nexata bajarapaibotota xaniavaetsia nayaëtsiana botabu daxita itsaibo matatoxenetsia. Vajatuxanenë Dioso raja exanaena bajarapacuene. Nexata bitso nacatsita pexaniacuene tsane bajarapacuene, jai tajëvelia Dioso pejumelivaisibaxutota xanë yabara. ’Bajarapacuenia tajëvelia Dioso pejumelivaisibaxutota itsa jumaitsi, paxamë apo patanejumecovënëtsijavanexamë yabara jumaitsi. Dioso taneitapetsijava daxitajivi tacapanepaenexa yabara ata jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nexata pacuenia uvabacabo pexainaenë icatsia itsamonae evetsiaexanaena, bajara pijinia pacuenia Dioso exanaena paxamëjavabelia. Xua picani Dioso pacaevetsiaexana, copiarucaena. Nexata juya itsamonae Dioso evetsiaexanaena bajaraxua, pamonae xaniavaetsia jumecovënëta Dioso pitorobicueniatsi. ");
INSERT INTO guh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pamonae apo nejumecovënëtsi Dioso pexënatocuenenë, bajarapamonae bitso bejamatabëjiobi tsane apo tanejumecovënëtsixae. Pacuenia ibotojumata pefirapecaejivi, itsa tsapatecatsi, pevixae bitso yanabejiobita, bajara itsane. Pamonae naneconitsiaexanaenajë, bajarapamonae pepacuene naxuabiana daxitamatacabijavabelianexa. Pacuenia iboto pematacënëbinëtsi apo asaë, bajara itsane, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdotevi penamatacaitorobivi, fariseovi yajava, itsa jumetane bajarapacuenia Jesús pejumaitsijava, bajarapamonae jamatabëjumai tsenae: “Vaxaitsi yabara raeta jumaitsi,” jamatabëjai tsenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nexata picani bajarapamonae Jesús jamatabëvaetabatsi. Itsiata bajarapamonae jamatabëjumaitsi: “Bajaraponë jivi tanetsi Diosojumepaebinëcuene. Nexata nacaitsacueniabijitsipa vaxaitsi itsa vaetabijitsipatsi maponëje,” jamatabëjai tsenae bajarapamonae. Bajaraxuata Jesús apo vaetabitsi. ");
INSERT INTO guh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Jesús icatsia livaisi tsipaeba sacerdotevijavabelia, judíovi pijaancianovijavabelia ata. Bajarapacuenia Jesús tsipaeba bajarapamonae peyapëtaenexa pacuenia itsamatacabi itsijitsia, pamatacabi Dioso pijajivi evetsiana. Jesús jumaitsi mapacueniaje: —Pepo nacuaevetsinë fiesta exana pexënato petonacasabifiestanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nexata nacuaevetsinë jumaitsi pijajivijavabelia: “Pamonae baja tajëvelia junatajë, patsipaebare baja tanetopatsinexarena fiestanexa jane baja,” jai nacuaevetsinë pijajivijavabelia. Pijajivi baja nexata pona petsipaebinexa. Itsiata pejunatsivi apo jitsipae peponaejava. Nexata nacuaevetsinë pijajivi naviabarena petsipaebinexa pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nexata nacuaevetsinë itsamonae icatsia pijajivi itorobalia pesivaponaenexalia. Nacuaevetsinë jumaitsi pijajivijavabelia: “Pajumaitsimë tsane tajunatsivijavabelia: ‘Veretejeba rabaja panexaejavanexa. Beyaexana rabaja baca penasitsivi, becerro yajava. Daxita rabaja veretejeba panenabaninexa. Naxanitsia. Daxita pina paponaeremelia,’ pajamë tsane tajunatsivijavabelia,” jai nacuaevetsinë pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Itsiata baitsi jane bajarapamonae icatsia sivaponae atalia, nacuaevetsinë pejunatsivi apo jejai. Pejunatsiviyajuvënënë itsanë pona pijapabianëjavabelia. Itsanë pijinia pona penavijatsinexa. ");
INSERT INTO guh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Itsamonae nacuaevetsinë pijajivi taicatsi. Bejiobiaexanatsi pibisiacuenia. Beyejebatsi baja belia. ");
INSERT INTO guh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bajaraxuata nexata nacuaevetsinë bitso baraanaepana pejunatsivimijavabelia. Nexata nacuaevetsinë itorobalia vajabitsaëvi pebenexa pamonae tobeyejebatsi pijajivi. Itorobanua pijatomaranëmi ata petotajuitsinexa. ");
INSERT INTO guh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bajaraxuacujinae nacuaevetsinë icatsia pijajivijavabelia jumaitsi: “Daxitacuene baja picani veretejebiaexanajë taxënato penacasabifiestanexa. Itsiata baitsi jane tajunatsivimi apo netopatsirena. ");
INSERT INTO guh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Paponaremelia pinijicallexanetonëjavabelia. Nexata daxita pamonae pacaxitajarabaponaename bajarapacallexanetonëjava, pajunataponaename taxënato penacasabifiestajavaberena pepatsinexa,” jai nacuaevetsinë pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nexata nacuaevetsinë pijajivi ponalia. Najetarubena callexanetonëjava. Junatapona daxita pamonae caxitajarabapona. Junatapona piajamatabëcuenebejevi, pejamatabëcuenexanepanaevi ata. Nexata bajarapamonae barëpona fiesta pexanaebojavabelia. Nexata pabota fiesta exana, vënëca jivi. ");
INSERT INTO guh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Nexata nacuaevetsinë jonena bajarapaboyarena petaenexa petopatsivitsi. Daxita pamonae topatatsi, jumapata xua banaxataba itsa pona penacasabifiestajavabelia. Nexata nacuaevetsinë taenuta bajarajota itsanë, saicayaviriajava penaxatatsinë. Apo naxatatsi xua naxataba daxita. ");
INSERT INTO guh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nexata nacuaevetsinë jumaitsi bajaraponëjavabelia: “¿Detsa xuajitsia najunuame apo nenaxatatsinë pacuenia daxita naxataba penacasabifiestajavaberena penajonevi?” jai nacuaevetsinë. Nexata bajaraponë moya nuca. ");
INSERT INTO guh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nexata nacuaevetsinë jumaitsi mesa pevetsivijavabelia: “Maponë pataxucëreje. Pacobecëre yajava. Paxuaremelia bopënëyabelia, pitaquirijavabelia. Bajarajotalia nuena. Navonosiniana bitso penavixaetaexae,” jai nacuaevetsinë. ");
INSERT INTO guh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pacuenia fiesta pexanaenë ayaibitsaëtoxaneto junatsi ata, caejiviyobeje saya topatatsi, bajara pijinia itsi Dioso pejunatsivi ata. Dioso picani ayaibitsaëtoxaneto junata pijajivinexa. Itsiata saya caejiviyobeje jumecovënëtatsi, jai Jesús sacerdotevijavabelia, judíovi pijaancianovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseovi nacaetuata penabarëcuaicuaijainexa. Bajarapamonae najamatabëcuenejëpa Jesúsjavabelia jamatabëcueneëjëbiaya peyanijobinexa. Nexata Jesús bijiaya itsa jumecanaviata, Jesús picani peneconitsinexatsi nacuaevetsinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nexata fariseovi itoroba pijajivi, Herodes pijajivi yajava, Jesúsjavabelia jamatacueneëjëbiaya livaisi peyanijobinexa. Nexata fariseovi pijajivi, Herodes pijajivi yajava, Jesúsjavabelia jamatabëcueneëjëbiaya jumaitsi: —Jesús, payapëtaniji cajena nexaniajaicuene, xua yabara tsipaebabiabame livaisianë. Pexaniajaicuene tsipaebabiabame pacuenia Dioso jitsipa jivi petojinavanapaenexatsi. Petuxanevi ata xamë apo cujunavimë. Apo auramë livaisi netsipaebabiabijava. Nexata daxitajivi najëpaeya livaisi tsipaebabiabame. ");
INSERT INTO guh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Panetsipaebare pacuenia najamatabëxainame mapacuene yabaraje. ¿Xanepana tsaja vajamatamotsinexa impuestomatamo Romanonacua pepo pevetsinëjavabelia? Itsa jume, ¿apo xanepanae tsaja vajamatamotsinexa? jai bajarapamonae jamatabëcueneëjëbiaya Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Itsiata baitsi jane Jesús jamatabëcueneyapëtane bajarapamonae jamatabëcueneëjëbiaya peyanijobijavatsi peneconitsinexatsi picani. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Paneyamaxëitojorobivi, ¿detsa xuajitsia jamatabëcueneëjëbiaya paneyanijobame? ");
INSERT INTO guh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Panetsitajëre pitsipalatanëyota pamatamotabiabame impuestomatamo, jai Jesús bajarapamonaejavabelia. Nexata bajarapamonae Jesús tocaponarenatsi palatanëyo. ");
INSERT INTO guh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús itsa tane bajarapapalatanëyo, nexata jumaitsi bajarapamonaejavabelia: —¿Jipatsa mapitabaraje, pevënënua, ruca mapapalatanëyojumataje? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Romanonacua raja pepo pevetsinë pitabara, pevënënua, jai. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata parajutabiabianame Romanonacua pepo pevetsinë pijajava. Parajutabiabianame pijinia saicaya Diosojavabelia Dioso pijajava, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nexata Jesús xaniavaetsia itsa jumecanaviata, bajarapamonae jamatabëcuenenabenajaca bajarapacuenia Jesús pejumaitsijavata. Nexata baja copatatsi Jesús jamatabëcueneëjëbiaya peyanijobijavatsi. Naviaba baja bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Saduceovi saicaya itsalivaisi xaina. Bajarapamonae jamatabëcuenenavëxaniabiaya jumai tsabiabi: “Petëpaevi rabaja petëpaecujinae, icatsia apo asaë tsane,” jai tsabiabi. Nexata saduceovi imoxoyorenatsi Jesús. Saduceovi Jesúsjavabelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Jesús, Moiséspijinë bajayata vajanacatoyaquinaelivaisi, jumaitsi mapacueniaje: “Ponë pematapijinë pepua penacojiobinë baja, totëpatsi pexi xainaenejeva, nexata juyapijinë bepita pematapijinëmi pijavami. Bajarapacuenia juyapijinë bepita pematapijinëmi pijavami pexi pexainaenexa bajarapovajavabelia. Nexata pexi itsa xainabeje, bematapijinëmi pexi petaenexa daxitajivi,” jai Moiséspijinë bajayata vajanacatoyaquinaelivaisi. ");
INSERT INTO guh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nexata jinavanapa ënacaemonae siete ponëbeje paxanëjavata. Pepo matapijinë copiaya nacojioba. Nexata bajaraponë pijava vecuatëpa pexi xainaenejeva. Nexata pematapijinëmi pepënarucaenë pita pematapijinëmi pijavami. ");
INSERT INTO guh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nexata icatsia bajaraponë ata tëpa pexi xainaenejeva bajarapovajavabelia. Nexata icatsia itsanë tuatuajëmatapijinë pita bajarapova. Bajara icatsia ponë ata tëpa pexi xainaenejeva bajarapovajavabelia. Bajarapacuenia tëpa daxita siete ponëmibeje nacaemonaemi, bajarapova pepitaponaevi. Itsiata itsanë ata pexi apo xainae bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bajaraxuacujinae bajarapova ata tëpa baja. ");
INSERT INTO guh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Jivi raja petëpaecujinae, Dioso icatsia asaëyaexanaenatsi,” jamë. ¿Detsa nexata ponë bajarapamonaeyajuvënënë pijava tsane bajarapova bajarapamatacabi? Daxita pamonae siete ponëmibeje nacaemonae pitapona picani bajarapovami, jai saduceovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nexata Jesús jumaitsi saduceovijavabelia: —Paxamë saya pajamatëbëcuenenavëxaniabame. Paxamë raja apo payapëtaemë pacuenia Dioso pejumelivaisibaxutota jumaitsi. Apo payapëtaemënua pacuenia Dioso caëjëpatsi daxitacuene pexanaenexa. Bajaraxuata jamatabëcuenenavëxaniabiaya paneyanijobame: “¿Detsa ponë pitsiana bajarapova?” panejamë. ");
INSERT INTO guh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pamatacabi raja petëpaevimi Dioso icatsia asaëyaexanaenatsi, apo nacojiobi baja tsane. Bajarapamatacabita itsajivi ata pexënatoyo apo canajetsi tsane pebijavabelia petonacojiobinexatsi. Bajarapamonae nacojiobinejeva, jinavanapaena athëbëtatsia pacuenia ángelevi jinavanapa. ");
INSERT INTO guh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Itsa pepacuene paxamë xaniavaetsia paneyanijobame paneyapëtaenexa Dioso icatsia piasaëyaexanaejavanexatsi petëpaevimi, nexata pacatsipaebianatsi. Paxamë rabaja payapëtaneme pacuenia bajayata Dioso jumaitsi. Abraham baja pepuatëpae, Isaac ata baja pepuatëpae, Santiago ata baja pepuatëpae, bajarapamonae yabara bajayata Dioso jumaitsi Moiséspijinëjavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Xanë rabaja abaxë Abraham pijaDiosonë. Isaac ata pijaDiosonë. Jacob ata pijaDiosonë,” jai baja cajena Dioso bajayata petëpaevimi yabara. Bajarapacuenia Dioso pejumaitsixae, nayapëtane bajarapamonae bajayata tëpae ata, Diosovecua apo penaxuabijava. Aeconoxae ata bajarapamonae Dioso yajavajinavanapa athëbëtatsia, jai Jesús saduceovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jivi ayaibitsaëtoxaneto itsa jumetane bajarapacuenia Jesús pejumaitsijava saduceovijavabelia, jivi bitso jamatabëcuenenabenajaca Jesús petsipaebilivaisi yabara. ");
INSERT INTO guh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceovi Jesús peyanijobijumetsi, xaniavaetsia Jesús jumecanaviata. Nexata baja moya saduceovi. Nexata fariseovi itsa vënëtane saduceovijavabelia Jesús xaniavaetsia pejumecanaviatsijava, nexata fariseovi nacaetuata penabarëcuaicuaijainexa. Nexata fariseovi najumejaita pacuenia yanijobijitsia Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nexata fariseoviyajuvënënë, judíovi pecujarubinë, Jesúsjavabelia jamatabëcueneëjëbiaya yanijoba. Jumaitsi Jesúsjavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Jesús, ¿detsa palivaisi bitso jivi bejumecovënëta daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia? jai. ");
INSERT INTO guh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jesús nexata jumaitsi judíovi pecujarubinëjavabelia: —Palivaisi bitso jivi bejumecovënëta daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia, jumaitsi mapacueniaje: “Pasivamëre panijatuxanenë panijaDioso daxita panejamatabëëthëtojavavetsina, daxita panejamatabëcueneta ata, daxita panenajamatabëxainaesaëta ata,” jai. Bajarapalivaisi bitso jivi bejumecovënëta daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bajaraxuacujinae pecotocaevilivaisi, palivaisi bitso jivi bejumecovënëta, jumaitsi icatsia mapacueniaje: “Pasivamëre itsajivi ata pacuenia paxamë panijacuata panasivamë,” jai. Bajarapalivaisi ata jivi bitso bejumecovënëta. ");
INSERT INTO guh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pajivi jumecovënëta bajarapalivaisibeje, Dioso baja tanetsi pejumecovënëtsijivicuene daxita Dioso pitorobilivaisianë. Nexata palivaisi ata bajayata Dioso Moiséspijinëta najumecopata, bajarapalivaisi ata pejumecovënëtsijivicuene Dioso tanetsi. Diosojumepaebivimi profetavi ata palivaisianë bajayata tsipaeba, bajarapalivaisi ata pejumecovënëtsijivicuene Dioso tanetsi, jai Jesús judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseovi penacaetuatsijavata, fariseovijavabelia Jesús pijacuata nayabarajumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Detsa pacuenia pasivanajamatabëxainaename Cristo itsa patsianica? ¿Jipatsa pexënato tsane? nayabarajai Jesús pijacuata fariseovijavabelia. Nexata fariseovi jumaitsi Jesúsjavabelia: —Davidpijinë pemomo tsane, jai. ");
INSERT INTO guh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nexata Jesús jumaitsi fariseovijavabelia: —Pajamatabëcuenenavëxaniabame raja. Cristo raja Dioso pexënato. Bajayata Dioso pejumaitsijava Cristo yabara, Davidpijinë Espíritu Santo pejamatabëcueneta tajëvelia jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dioso jumaitsi tajatuxanenëjavabelia: “Ecare abaxë tacujuanenia. Vecatsivajënae jumecovënëtsiaexanaenatsi abaxë copiaya nijavajabitsaë nitorobicuenianexa,” jai Dioso tajatuxanenëjavabelia, jai bajayata tajëvelia Davidpijinë mapacueniaje Cristo yabara. ");
INSERT INTO guh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’Nexata Davidpijinë bajayata Cristo yabara: “Tajatuxanenë,” itsa jai, nexata Cristo, Davidpijinë apo pemomo. Tsipaji baja cajena saicaya Cristo Dioso pexënato, nayabarajai Jesús pijacuata fariseovijavabelia fariseovi pecanaëjëtsinexa Cristo Dioso pexënatocuene. ");
INSERT INTO guh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nexata itsanë ata fariseoviyajuvënënë Jesús apo jumepitsitsi caejumeyo ata. Bajaraxuacujinae fariseovi, saduceovi ata, cujunava Jesúsjavabelia baja jamatabëcueneëjëbiaya livaisi peyanijobijava. ");
INSERT INTO guh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús jumaitsi jivi ayaibitsaëtojavabelia, pijajivijavabelia ata: ");
INSERT INTO guh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Judíovi pecujarubivi, fariseovi ata, Dioso tocopatatsi jivi xaniavaetsia peyapëtaeyaexanaponaenexa pajamatabëcuenelivaisi xaina Dioso Moiséspijinëta penajumecopatsilivaisimi. ");
INSERT INTO guh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nexata pajumecovënëtsianame daxita pacuenia bajarapamonae pacatsipaebapona. Itsiata baitsi jane pëtsa paexaname pacuenia bajarapamonae exanavanapa. Tsipaji xua bajarapamonae pacaitaveta paxamë paneexanaeyaniva, bajaraxua itsiata bajarapamonae exanabiaba. ");
INSERT INTO guh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Palivaisianë ayapëbeje itsajivi ata pejumecovënëtsinexa, bajarapalivaisianë pacatsipaebabiaba panejumecovënëtsinexa. Pamonae bajarapacuenia pacatsipaeba, itsanë ata bajarapamonaeyajuvënënë apo jamatabënajinae pexanaenexa bajarapacuenia. ");
INSERT INTO guh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Daxita xua bajarapamonae exana, exanabiaba saya jivi petaenexatsi. Bajarapamonae jamatabëjumai tsabiabi: “Bajaraxua itsa exanaenatsi, jivi nacayaiyataena,” jamatabëjai tsabiabi. Bajarapamonae pitapata, pecofiata ata, becajonixicuenia pexanaejavaxita yacajonia cëbarubejebabiaba Diosojumelivaisi peyaquinaebaxutoxi. Bajarapamonae itsamonae matatoxenetsia piajumanavaitabënexa, piapiafleco pijanavatabuyalia cëbarubabiaba. Bajarapacuenia bitso jitsipabiaba pexanabiabinexa. ");
INSERT INTO guh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bajarapamonae itsa najunatatsi fiestajavabelia penanabaninexa, nexata jitsipabiaba penaenexa pexaniaviriajavanëta. Nexata natsiitapetabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. Bajarapamonae itsa najoneyabiaba judíovi penacaetuatabiabibota, jitsipabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. ");
INSERT INTO guh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bajarapamonae bitso jitsipabiaba jivi pebajacobinexatsi yaiyataeya callejava ata. “Patanecujarubinë,” pejaijavatsi ata, bitso jitsipabiaba, jai Jesús mapacueniaje fariseovi yabara, judíovi pecujarubivi ata yabara. ");
INSERT INTO guh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Icatsia Jesús jumaitsi jivi ayaibitsaëtoxanetojavabelia, pijajivijavabelia ata: —Pëtsa paxamë pajitsipame jivi papecajumaitsinexa paxamëjavabelia: “Patanecujarubinë,” papecajainexa. Tsipaji daxita paxamë bepanacaemonaemë Dioso panejumecovënëtsivixae. Xanë, caenënë Cristonë, athëbëvetsica Dioso taneitorobinëtsica jivi tacapanepaenexa, panexainame patacacujarubinënexa. ");
INSERT INTO guh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Itsanë itsa pacacujaruba, “Axa,” pajamë pëtsa bajaraponëjavabelia. Tsipaji caenë paneaxa paxainame, ponë eca athëbëtatsia. ");
INSERT INTO guh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pëtsa pajitsipame itsamonae papecajumaitsinexa: “Jivi pevetsinë,” papecajainexa. Tsipaji xanë, caenënë Cristonë, patacaevetsinë. ");
INSERT INTO guh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ponë paxamëyajuvënënë pacavecuaayaijamatabëcuenenë, bajaraponë pacayavenonabiaba padaxitamë. ");
INSERT INTO guh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pajivi daxitajivi matatoxenetsia pijacuata ayaijamatabëcuenejivi natane, bajarapajivi itsamatacabi daxitajivivecua beveliajamatabëcuenejivi Dioso exanaenatsi. Pajivi pijinia daxitajivivecua pijacuata beveliajamatabëcuenejivi natane, bajarapajivi itsamatacabi daxitajivi matatoxenetsia ayaijamatabëcuenejivi Dioso exanaenatsi, jai Jesús jivi ayaibitsaëtoxanetojavabelia, pijajivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesús icatsia jumaitsi fariseovijavabelia, judíovi pecujarubivijavabelia ata: —¡Paxamë saya jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! Pacuenia bo babaupaxatata jivi pejoneyaniva, bajara bepacuenia paxamë paexaname. Itsamonae jitsipae ata pejonenexa Dioso pijanacuayabetsia, apo pacopatsimë pejonenexa saicayalivaisi panecujarubixae. Paxamë ata apo pajitsipaemë panejonenexa Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Paxamë saya jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! Yamaxëitojorobiaya pavecuanotabiabame pamonajivi pevecuatëpaevanëtsi pecobecovëjavaximi. Bajaraxuacujinae pinijicuenia itajara Diosojavabelia pavajëcabiabame. Itsiata pepo panexaniajaijamatabëcueneta apo pavajëcabiabimë Diosojavabelia. Bajarapacuenia pavajëcabiabame saya jivi papecataenexa Dioso itajara bitso bepanejumecovënëtsivi. Bajaraxuata bitso ayaicuenia Dioso pacananeconitsiaexanaena pamatacabi Dioso naneconitsiaexanaena daxita pamonae Dioso apo pejumecovënëtsivi. ");
INSERT INTO guh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Paxamë saya jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! Palivaisi pacajinavanapame, caejivi ata panejumecovënëtsiaexanaenexa, papecacuenejëpaenexanua, ayaicuenia daxitajava jivi patsipaebarutame. Nexata pajivi pacajumecovënëta, bajarapajivi pevajënaeyabelia bitso naneconitapona Diosojavabelia. Nexata paxamë panejamatabëcueneta bajarapajivi paxamë matatoxenetsia bitso Dioso naneconitsiaexanaenatsi pexuabinexatsi infiernojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Paxamë apo payapëtae atamë, Dioso pejumelivaisi jamatabëcuenenavëxaniabiaya pacujarubabiabame itsamonae! Nexata paxamë panecujarubijamatabëcueneta bajarapamonae pananeconitsiaexaname Diosojavabelia. ¡Bajaraxuata ayaineconi panatsixainame Diosojavabelia! Paxamë jivijavabelia jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabi: “Pajivi itsanëjavabelia najumecapanepaeya jumaitsi pejumexaniataenexatsi: ‘Catoexanaenatsi pepacuene. Cajumaitsitsi cajena templobo pevënëta,’ jai, apo itsacuene. Bajarapajivi pejumaitsicovëya apo exanae ata, itsiata apo naneconitsi Diosojavabelia,” pajamë tsabiabi. “Pajivi rajane itsanëjavabelia jumaitsi pejumexaniataenexatsi: ‘Catoexanaenatsi pepacuene. Cajumaitsitsi cajena templobopijiorojavanë pevënëta,’ jai, bajara jane xua abeje. Nexata bajarapajivi exanae pejumaitsicovëya penaneconitsiyaniva Diosojavabelia,” pajamë tsabiabi jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pajamatabëcuenenavëxaniabame raja saya bajarapacuenia itsa pajumaitsimë. Biji rajane templobo beyaiyatanetsi bajarapatemplobopijiorojavanë matatoxenetsia. Bajarapaorojavanë ata yaiyatanetsi. Tsipaji bajarapaorojavanë templobopijiorojavanë. ");
INSERT INTO guh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabinua: “Pajivi itsanëjavabelia najumecapanepaeya jumaitsi pejumexaniataenexatsi: ‘Catoexanaenatsi pepacuene. Cajumaitsitsi altarvënëjava pevënëta,’ jai, apo itsacuene. Bajarapajivi pejumaitsicovëya apo exanae ata, itsiata apo naneconitsi Diosojavabelia,” pajamë tsabiabi. “Pajivi rajane pejumexaniataenexatsi itsanëjavabelia jumaitsi: ‘Catoexanaenatsi pepacuene. Cajumaitsitsi altarvënëjavajumata pebuatsiofrenda pevënëta,’ jai, bajara jane xua abeje. Nexata bajarapajivi pepacuene exanae pejumaitsicovëya penaneconitsiyaniva Diosojavabelia,” pajamë tsabiabinua jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Paneamatabocotajavi, bepaneitatsëcënavanapaevinua panejamatabëëthëtota. Biji rajane beyaiyatanetsi altarvënëjava, bajarapaaltarvënëjavajumata pebuatsiofrenda matatoxenetsia. Bajarapaofrenda ata yaiyatanetsi. Tsipaji altarvënëjavajumata boca. ");
INSERT INTO guh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pajivi jumaitsi: “Cajumaitsitsi altarvënëjava pevënëta,” jai, caecuenia yajavavënëjona bajarapaaltarvënëjavajumata pebocaeofrenda. ");
INSERT INTO guh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pajivi pijinia najumecapanepaeya jumaitsi pejumexaniataenexatsi: “Cajumaitsitsi templobo pevënëta,” jai, caecuenia yajavavënëjona bajarapatemplobota peponaponaenë Dioso. ");
INSERT INTO guh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pajivi pijinia najumecapanepaeya jumaitsi pejumexaniataenexatsi: “Cajumaitsitsi athëbëtatsia panacua pevënëta,” jai, caecuenia yajavavënëjona Dioso pijatrono. Caecuenia yajavavënëjonanua Dioso, ponë ecabiaba bajarapatronota pitorobabiabinexa pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Paxamë jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! Panenacanabijava diez xuabejeyajuvënëjava, caejavayo, parajutabiabame ofrendacuenia Diosojavabelia. Daxitaviria paneubijavaxi ata, diez xuabejeyajuvënëjava, caejavayo, parajutabiabame ofrendacuenia Diosojavabelia. Bajarapacuenia parajutabiabi atamë, apo pajumecovënëtsimë itsalivaisianë, Dioso papecatonajumecopatsilivaisianë, palivaisianë picani bitso Dioso pacatojitsipa panejumecovënëtsinexa. Bajarapalivaisianë picani pacaitoroba itsamonaejavabelia pexaniacuene panetoexanabiabinexa. Pacaitorobanua picani paneitaxutotsoniataeyabiabinexa itsamonae ata. Pacaitorobanua picani xaniavaetsia panenajamatabëcuenecopatsinexa Diosojavabelia. Bajarapacuenia picani bepaexanavanapame pacopatsinejevamë bajaraxua, ofrendacuenia panerajutabiabijava Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Paxamë apo payapëtae atamë Dioso pejumelivaisi, jamatabëcuenenavëxaniabiaya pacujarubabiabame itsamonae! Palivaisianë Dioso najumecopata panejumecovënëtsinexa, bajarapalivaisianë yajuvënëlivaisixi, saya beveliajamatabëcuenelivaisixi, pacaasaëmë tsavanapae. Palivaisianë picani Dioso bitso pacatojitsipa panejumecovënëtsinexa, caranata panamuxujematame. Nexata panecujarubivi panecujarubicuenia pexanavanapaexae, panecujarubivi ata naneconita Diosojavabelia pacuenia paxamë pananeconitame Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Paxamë jivi paneyamaxëtojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! “Najamatabëcuenebijianaejitsipajë Diosojavabelia,” panejamatabëjaitsabiabixae, panecaxaevajënae panecaxaenëanë, taza ata, naniavelia paquiatabiabame xaniavaetsia panijasalinaicuenia. Tsipaji jamatabëcuenenavëxaniabiaya pajamatabëjumaitsimë tsabiabi: “Itsa caxaejitsipajë xaniavaetsia quiatsinejevanë, Diosojavabelia naneconitsipajë,” pajamatabëjamë tsabiabi. Itsiata baitsi jane panejamatabëëthëtota bëpënëa panajamatabëxainabiabame pibisiacuene. Panajamatabëxainabiabame itsanë pecobecovë paneyacajërëtsinexa. Panajamatabëxainabiabamenua panexainaenexa ayaijava ëpaxamënexa. ");
INSERT INTO guh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paxamë pafariseovimë, bepaneitaxutotsëcënaevi panejamatabëëthëtota. Pajivi quiata pecaxaenë, taza yajava, piaxuirajibinexa, copiaya xaniavaetsia quiata pënëvelia. Bajaraxuacujinae xaniavaetsia quiata pejumavelia. Bajara pijinia pacuenia paxamë ata copiaya Dioso pacajamatabëcuenequiatsi paneajamatabëcuenexuirajibinexa. Nexata bajaraxuacujinae pacajamatabëcuenecaëjëpaena paneexanaenexa ëpexaniacuene pacuenia Dioso pacaitoroba. ");
INSERT INTO guh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Paxamë saya jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, pafariseovimënua, ayaineconi panatsixainame Diosojavabelia! Itsajota jivimëthëanë bobena, jivimëthëanëjumavereca itsamonae caiquina peniojairata bajarapacuenia pitabëtsinexa. Itsiata baitsi jane bëpënëareca petëpaevimi petsabanaejava, pesi yajava, abeje. Bajaraxua apo jitsipaetsi vajajayatsinexa. Bajara pijinia paxamë ata Dioso patsitajamatabëcueneitsimë. ");
INSERT INTO guh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Itsamonae naniavelia itsa pacatane, pacatane bepapexaniajamatabëcuenevimë itajara. Itsiata baitsi jane panejamatabëëthëtota bëpënëa panajamatabëxainabiabame jivi paneyamaxëitojorobinexa. Itsajava ata pematatsënëa pibisiacuene paneexanaenexa, panajamatabëxainabiabame. ");
INSERT INTO guh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Paxamë saya jivi paneyamaxëitojorobivi! ¡Paxamë judíovi panecujarubivi, paxamë ata pijinia pafariseovimë, ayaineconi panatsixainame Diosojavabelia! Bajayata panijasalinaivi Diosojumepaebivimi profetavi beyejeba. Nexata mëthëca. Nexata mapamatacabitaje bajarapaprofetavimi pemëthëanëjumavereca bo paexanabiabame itabëtsiaya, jivi itsa tane, penajamatabënapitabiabinexa bajarapaprofetavimi. Pamonaemi ata bajayata tëpa, pamonae aneconijibia pejinavanapaevimi Dioso pitabarata, pemëthëanëjumavereca aeconoxae mapamatacabitaje itabëtsiaya parubabiabame itsacuenejavaxi. ");
INSERT INTO guh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bajarapacuenia itabëtsiaya paneexanaecujinae, jivijavabelia pajumaitsimë tsabiabi mapacueniaje: “Vajasalinaivimi bajayata pibisiacuene exana. Beyaxuababiaba profetavimi. Paxanë bajarapamatacabi pajinavanapae atanë tsipae, apo payavenonaenë tsipae bajarapamonaemi pebeyabiabijava profetavimi,” pajamë tsabiabi. ");
INSERT INTO guh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Vajasalinaivimi beyaxuababiaba profetavimi,” panejaixae, panavajunupaebame papemomoxicuenemë bajayata pamonaemi beyaxuababiaba profetavimi. Bajarapamonaemi papemomoxixaemë, pacuenia bajarapamonaemi jamatabëcueneitsi, bajara paxamë ata pajamatabëcueneitsimë. ");
INSERT INTO guh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Paxamë ata papibisiajamatabëcuenevixaemë, xanë ata jamatabëpanebeyaxuabame. ¡Panebeyaxuare paneveretsinexa xua panijasalinaivimi taxuxuaba! ");
INSERT INTO guh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Paxamë bitso pibisiacuene paneexanaevi! Pacuenia jomo rëcëpeca itsa tane petajuenajetarucaejava isoto, bajara paitsimë. Itsiata apo papanepaemë tsane infiernovecua panijaneconi yabara. ");
INSERT INTO guh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Paxamë picani pacatoitorobianatsi Diosojumepaebivi profetavi. Pacatoitorobianatsinua picani bitso Dioso pijacuene peyapëtaeyaexanaevitsi. Pacatoitorobianatsinua picani xanë talivaisi papecatsipaebivinexa. Itsiata baitsi jane bajarapamonaeyajuvënëvi itsamonae pabeyaxuabaponaename. Itsamonae cruzajavabelia pacobematabiaxuababiabianame. Itsamonae pajumatitibabeyabiabianame penaneconitsivi panejumaconitabiabimacata judíovi penacaetuatabiabibonëjava. Itsamonae pabaraponabiabianame itsa tomaranëjavabelia ata panebejiobiaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bajarapacuenia nexata paxamë ayaineconi panatsixainaename Diosojavabelia. Daxita pamonae aneconijibia pejinavanapaevimi Dioso pitabarata, bajayata panijasalinaivimi beyaxuababiaba. Nexata bajarapaneconimi yajava paxamë pacatsijumajopaena. Dioso pitabarata aneconijibia pejinavanapaevimi, panijasalinaivimi pebeyaxuabaponaejava, taxuxuaba Abelpijinëta. Bajaraxuacujinae icatsia pevajënaeyabelia beyaxuabapona itsamonae ata, Dioso pitabarata aneconijibia pejinavanapaevimi. Nexata bexëajavaberena ata Berequíaspijinë pexënatomi, Zacaríaspijinë, panijasalinaivi beyaxuaba. Zacaríaspijinëmi panijasalinaivimi beyaxuaba templobopanabota, templobobeje altarvënëjavabeje tuatuajëta. ");
INSERT INTO guh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita pamonaemi Dioso pitabarata aneconijibia pejinavanapaevimi, panijasalinaivimi beyaxuababiaba. Bajarapaneconimi yajava, paxamë aeconoxae panejinavanapaevi, pacatsijumajopaena Dioso papecananeconitsiaexanaenexa, jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelianua. ");
INSERT INTO guh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús najamatabëxainaeya sivanua Jerusalén tomarapijivi. Jumaitsi pesivanuejavata mapacueniaje: —¡PaJerusalén tomarapijivimë, pabeyabiabame Diosojumepaebivimi profetavi! ¡Ibotonëta ata patseconabiabame bajarapacuenia panebeyaxuababiabinexa Diosojumelivaisi pecaponaevi paxamëjavaberena! ¡Pacuenia vacara banacoxicaetuata pecorofetobëxëpanaberena, bajara pijinia pacuenia xanë ata picani bitso jitsipabiabajë patacaetuatsinexa, patacacapanepaenexa picani panijaneconivecua! ¡Itsiata baitsi jane paxamë apo pajejamë cajena! ");
INSERT INTO guh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Panejumetaema. Dioso rabaja pacacopata papecaevetabiabijavami. Nexata baja panijatemplobota Dioso apo ponaponae. ");
INSERT INTO guh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Xaniajanë pacuenia pacatsipaebijitsiatsi. Paxamë rabaja apo panetaemë tsane matavëjëa. Matapania itsa panejumecovënëtsianame Cristonëcuenenë, Dioso taneitorobinëtsica, icatsia panetaename. Itsa panesivajamatabëjumaitsimënua tsane: “Dioso, bitso yavenonare maponë najetarucaje, nejamatabëcueneta penajetarucaenë,” itsa panesivajamatabëjamë tsane xanë yabara, nexata jane baja icatsia panetaename itsa patsianicajë, jai Jesús mapacueniaje najamatabëxainaeya pesivanuejavata Jerusalén tomarapijivi. ");
INSERT INTO guh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús pitsaparena temploboverena. Itsa baja Jesús vecuaponaejitsia templobo, pijajivi imoxorenatsi. Nexata Jesús pijajivi jumaitsi: —Patajatuxanenë, templobo nataema pemuxuneneta penaeboxanetonë ata, jai. ");
INSERT INTO guh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nexata Jesús tajëvelia vajunupaeba itsamatacabi itsanacuapijivi bajarapaboxanetonëmi pepenetsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita raja paboxanetonë pataneme, bajarapaboxanetonëmi itsamatacabi itsanacuapijivi penetsianica irabetsica. Nexata paibotonë catsanaruba mapaboxanetonëtaje, itsaiboto ata pejumavereca apo bocae tsane, jai Jesús tajëvelia pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús eca petsutojumata, patsutojumata olivonaenë apaaxayo. Jesús itsa eca petsutojumata, nexata pijajivi pijaepatojavata imoxoyorenatsi peyanijobinexatsi. Nexata Jesús pijajivi jumaitsi: —Patajatuxanenë, pajitsipajë patanetsipaebinexamë patayapëtaenexa paepatota copiapatsijitsia xua vajunupaebame. ¿Detsa peneta pitsicuene pataenajë icatsia itsa patsijitsiamëtsica? ¿Detsa peneta pitsicuene pataenajë mapanacua ata itsa vereverecaejitsiaje? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nexata Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xania panayajivitaename. Pëtsa panacopatame itsajivi ata papecayamaxëitojorobinexa. ");
INSERT INTO guh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsipaji raja peyamaxëitojorobivinexa, ayaibitsaëto patsiana bexanë itajara tsane. Bajarapamonae najumetsënëtsiaya jumai tsane: “Xanë raja Cristonë, athëbëvetsica Dioso taneitorobinëtsica jivi tacapanepaenexa,” jai tsane. Bajarapamonae jivi ayaibitsaëto yamaxëitojorobiana. ");
INSERT INTO guh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Vajabitsaë pexanaejava imoxoyonacuanëjava, tajënacuanëjava ata, pavënëlivaisitaename. Itsiata pëtsa pajunavame. Bajara peneta itsane mapanacua pevereverecaevajënaeje. Itsiata baitsi jane bepijia bajarapamatacabi mapanacuaje abaxë apo vereverecajuni tsane. ");
INSERT INTO guh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mapanacuaje pevereverecaevajënaeje peneta copiaya itsaviriavi nabena itsaviriavijavabelia. Itsanacuanëpijivi pijinia nabena itsanacuanëpijivijavabelia. Ayaijaniboxaneto najetarucaena itsanacuanëjava. Vitanecuene ata najetarucaena itsanacuanëjava. Ira najëabiana ayaicuenia itsanacuanëjava. ");
INSERT INTO guh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Daxita bajarapacuene itsa pataename, saya abaxë taxuxuabaponaena piayaicuene, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Icatsia Jesús taxëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Nexata paxamë pacacaponaena nacuaevetsivijavabelia papecabejiobiaexanaenexa. Nexata pacabeyejebiana. Daxitanacuanëpijivi pacaitoya tsabiabi tsane patajajivixaemë. ");
INSERT INTO guh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nexata bajarapamatacabita jivi ayaibitsaëto navecuacopabiana tanejumecovënëtsijava. Namataenetsia naitoya tsane. Namataenetsia nacanajetsiana nacuaevetsivi pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nexata ayaibitsaëto najetarubenaena jivi petsipaebaponaevinexa saicayalivaisi Dioso pejumelivaisivecua. BeDiosojumelivaisipaebivicuenia tsipaebaponaena. Bajarapamonae yamaxëitojorobiana jivi ayaibitsaëtoxaneto. ");
INSERT INTO guh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jivi pibisiacuene pexanavanapaevi, pevajënaeyabelia ayaibitsaëtoxaneto tsaponae tsane. Nexata ayaibitsaëto Dioso pejumecovënëtsivi, namataenetsia penaasivajava vereverecaponaena. ");
INSERT INTO guh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Itsiata pajivi ajamatabëcuenesaë tsane Dioso pejumecovënëtsijava petëpaejavabelianexa, bajarapajivi Dioso capanepaenatsi. ");
INSERT INTO guh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Itsamonae daxita nacuanëjava tsipaebiana jivi peyapëtaenexa imoxoyo baja pevajënae Dioso pijajivi pecapanepaejavanexa. Bajaraxuacujinae jane baja mapanacua vereverecaenaje, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Icatsia Jesús tajëvelia vajunupaeba papiayaicuene itsamatacabi copiapatsijitsia Jerusalén tomarata. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Diosojumepaebinëmi profeta Danielpijinë piayaicuene tajëvelia pevajunupaebilivaisi bajayata yaquina. Xua panijatomaranëmi vereverecaeyaexanaejitsiatsi, bajaraxua pelivaisi yaquina. (Pajivi lebiana mapalivaisije, yapëtaena papiayaicuene vajunupaeba mapalivaisitaje.) Nexata paxamë itsa pataename bajarapapiayaicuene penucaejava templobota, nexata Judea nacuata pejinavanapaevi pëtsa nubena. Naxanitsiayo rëcëpecaena petsutonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pajivi pijabojumata athëbëyo ecaya, itsa vënëlivaisitaena bajarapapiayaicuene penucaejava templobota, bajarapajivi perunaecujinaetsica, bepijia najetabajiraviana. Pëtsa joneya pijaboyalia pejutsinexa pecobecovë. ");
INSERT INTO guh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pajivi pijinia nacuenebaponapona pijapabita, itsa vënëlivaisitaena bajarapapiayaicuene penucaejava templobota, bepijia najetabajiraviana. Pëtsa naviata pijaboyabelia pejutsinexa penaxatabijava. ");
INSERT INTO guh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Papetiriavi penacueto yacotajinavanapa, bitso bejiobi tsane bajarapamatacabi! ¡Bitso nabejiobitsiaya jinavanapaena! ¡Papetiriavi ata mitoapaenacuetoxi isajinavanapa, bitso bejiobi tsane bajarapamatacabi! ");
INSERT INTO guh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bajaraxuata tajëvelia Diosojavabelia pavajëcare piayapëbejematacabita papecatocopiapatsiyaniva bajarapapiayaicuene. Nexata pamatacabi parëcëpecaename, pexaniamatacabi Dioso pacatocopatsiana bitso nabejiobitsiaya paneponaeyaniva. Pavajëcarenua penacueraevetsimatacabita bajarapapiayaicuene papecatocopiapatsiyaniva, nexata papecatoayapëbejeyaniva. ");
INSERT INTO guh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsipaji raja bajarapamatacabi bitso jivi bejiobi tsane. Pabejiobicuene abaxë jivi caeto ata apo tae Dioso nacua pexanaecujinae, bajarapabejiobicuene taena. Bajaraxuacujinae icatsia itsamonae bejiobiaexanae atatsi tsane, itsiata bajarapacuenia bitso apo bejiobiaexanaetsi tsane. ");
INSERT INTO guh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dioso epatua yatuucutsiana jivi bitso nabejiobitsiaya pejinavanapaematacabianëminexa bitso jivi nabejiobitsia pejinavanapaeyaniva. Dioso epatua itsa apo yatuucutsi tsipae bitso jivi nabejiobitsiaya pejinavanapaematacabianëminexa, caejivi ata apo asaë tsipae. Itsiata baitsi jane Dioso piasivaxae pijajivi, pitapetsivi, Dioso epatua yatuucutsiana bitso jivi nabejiobitsiaya pejinavanapaematacabianëminexa, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata papiayaicuene itsamatacabi copiapatsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Icatsia Jesús tajëvelia navajunupaeba icatsia pepatsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Nexata itsajivi yamaxëitojorobiaya itsa pacajumaitsi tsane: “Pataema. Mara Cristo nucaje,” itsa pacajai tsane, pëtsa pajumecovënëtame. Itsa pacajumaitsinua tsane: “Bajarajota nuca Cristo,” itsa pacajai tsane, pëtsa pajumecovënëtame. ");
INSERT INTO guh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Itsamonae jumai tsane: “Xanë raja Cristonë,” jai tsane. Itsiata jemajai tsane. Itsamonae jumai tsane: “Diosojumepaebinënë raja, profetanënë,” jai tsane. Itsiata jemajai tsane. Bajarapamonae itajara exanaena pinijicuene pexanaejavanë peyamaxëitojorobinexa saya jivi. Nexata bajarapacuenia itsamonae yamaxëitojorobaponaenatsi. Itsiata pamonae pepacuene Dioso pijajivi, Dioso pitapetsivitsi, bajarapamonae apo yamaxëitojorobi tsanetsi. ");
INSERT INTO guh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tajëvelia rabaja maje pacatsipaebatsije. ");
INSERT INTO guh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nexata itsamonae itsa pacajumai tsane: “Cristo raja ponapona petusato nacuatalia. Naxanitsia. Panataename,” itsa pacajai tsane, pëtsa paponaremelia. Itsa pacajumaitsinua tsane: “Cristo raja ponapona mapaënëyatuucutsibotaje. Naxanitsia. Panataename,” itsa pacajai tsane, pëtsa pajumecovënëtame. ");
INSERT INTO guh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Payapëtaneme rabaja mapacueneje. Yamaxë itsa nivejai tsajuni athëbëvetsica, caecuenia jivi bacotiatane daxitajava. Bajara pijinia peneta pacuenia daxitanacuanëpijivi caecuenia netaena pamatacabi patsianicajë xanë, Daxitajivi Pematapijinënë. ");
INSERT INTO guh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Payapëtaneme rabaja mapacuene ataje. Quequeremonae bepijia bayapëtane itsajota petuxutsaebinë boca. Nexata bajarajota bepijia banacaetuana. Bajara pijinia pacuenia daxitanacuanëpijivi tajajivi bepijia yapëtaena tapatsijavatsica. Nexata bepijia nacaetuanaena xanëjavaberena, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús tajëvelia navajunupaeba itsamatacabi icatsia pepatsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xanë tapatsivajënaetsica jivi taena pecujunavicuene. Jivi nabejiobitsiaya jinavanapaena. Nexata jivi nabejiobitsiaya pejinavanapaematacabicujinae, matacabipijijuameto aitaquiri tsane. Meravipijijuameto ata aitaquiri tsane. Tulupu ata othopaenica irabetsica. Daxitacuene, xua rubena athëbëtatsia, najëabiana. Xaniavaetsia apo rubenae tsane. ");
INSERT INTO guh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bajaraxuacujinae jane baja xanë athëbëvetsica najetarucaenajë, Daxitajivi Pematapijinënë. Nexata daxitaviriavi mapanacuapijivi natsinuena pecajunavi pijaneconi yabara. Nexata bajarapaepatota, xanë, Daxitajivi Pematapijinënë, jivi netaena athëbëvetsica itarërëbota tanajetarucaejava. Patsianicajë daxitacuene taevetsinexa. Tanivenivenaecotia yajavapatsianicajë. ");
INSERT INTO guh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bajaraxuacujinae trompeta itsa najumetsiana ayaijumeta, itorobianajë tajaángelevi. Angelevi daxitanacuanëjavaverena xanëjavaberena netocaetuatsiana tajajivi, pamonae Dioso pitapetsivitsi, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata itsamatacabi icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesús icatsia tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pacanaëjëre pacuenia itsi higueranae. Itsa maxëranajuva, nexata pejanabaxu pitsapa. Nexata bajarapacuenia payapëtaneme vai baja imoxoyo pevajënae pejonenexa. ");
INSERT INTO guh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bajara pijinia pacuenia peneta itsa pataename pecopiapatsijava xua tajëvelia vajunupaebajë, nexata payapëtaename imoxoyo baja tavajënae tsane tapatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pitsijamatabëcuenevi aeconoxae mapamatacabitaje jinavanapa, bajarapitsijamatabëcuenevi abaxë, bexëajavabelia ata, apo vereverecae tsane. Matapania xua tajëvelia vajunupaebajë itsa baja copiapatsiana, bajarapamonae jane baja vereverecaena. ");
INSERT INTO guh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Itaboxo, ira yajava, tsitecaena daxitamatacabijavabelianexa,” jamatabëjai ata tsane itsamonae, itsiata jamatabëcuenenavëxaniabiana. Tsipaji jemata itaboxo, ira yajava, vereverecaena. Nexata palivaisi pacatsipaebatsi, apo najumetsënëtsinë tsane. Nexata xua tajëvelia vajunupaebajë, pacuenia baja najumecapanepaeya jumaitsinë, daxita bajaraxua copiapatsiana, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsajivi ata apo yapëtae pamatacabita, paepatota ata, copiapatsijitsia daxita xua tajëvelia vajunupaebajë. Athëbëpijivi ata, ángelevi, apo yapëtae. Xanë, Dioso pexënato atanë, apo yapëtaenë. Caenë taxa Dioso yapëtane, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jesús icatsia tajëvelia navajunupaeba itsamatacabi icatsia pepatsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pacuenia bajayata jemata itsi pamatacabi Noépijinë ponapona, bajara icatsia jemata itsane pamatacabi xanë, Daxitajivi Pematapijinënë, patsianicajë. ");
INSERT INTO guh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pamatacabi Noépijinë ponapona ira pebubutsivajënaeya, jivi picani xaniavaetsia jamatejema pexaejava xaevanapa. Apaevanapanua. Nacojiobapona itsamonae. Itsamonae pexënatoyonë pebijavabelia canajetapona petonacojiobinexatsi. Bajarapamonae jamatejema saya jinavanapa. Nexata bajarapamatacabi Noépijinë ëpijamonae pinijibarcoxanetojavabelia barëjunua. ");
INSERT INTO guh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Daxitajivi abaxë itsiata apo yapëtae paepatota tocopiapatsijitsiatsi peyabubutsijavanexatsi. Nexata itsajivi ata yapëtaenejeva jemata ayaiemaxaneto itsa jopa ira pebubutsinexa, yapëtane jane baja. Bajarapamatacabi bubuna daxitajivi. Bajara pijinia pacuenia itsajivi ata yapëtaenejeva xanë, Daxitajivi Pematapijinënë, tapatsijavanexatsica, jemata patsianicajë. ");
INSERT INTO guh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nexata bajarapamatacabita anijanëbeje najuanacuenebanucaenabeje pabita. Itsanë tanejumecovënëtsinë tsane. Itsanë apo tanejumecovënëtsinë tsane. Nexata tanejumecovënëtsinë pitsianatsi ángelnë. Apo tanejumecovënëtsinë copatanutsianatsi. ");
INSERT INTO guh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bajara pijinia itsane petirivabeje ata. Najuacuabanucaenabeje caejavata. Nexata tanejumecovënëtsiva pitsianatsi ángelnë. Apo tanejumecovënëtsiva copatanutsianatsi. ");
INSERT INTO guh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nexata nejamatabëcueneevetsiaya panecopiaevetavanapaename. Tsipaji raja apo panevajënaeyapëtaemë tsane paepatota xanë panijatuxanenënë icatsia patsijitsianëtsica. ");
INSERT INTO guh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pacanaëjëre mapacueneje. Bo pexainaenë itsa yapëtaejitsipa paepatota meravi pijaboyaberena patsijitsia pecobecovë petonacobetoxotsinënexatsi, nexata naëcotsiaya vajënaeevetsipa. Apo copatsi tsipae pijaboyaberena petojoneyanivatsi penacobetoxotsinënexa. ");
INSERT INTO guh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bajara pijinia pacuenia paxamë ata najamatabëcuenexaniavaetsiaya panecopiaevetavanapaename. Tsipaji xanë, Daxitajivi Pematapijinënë, paepatota apo panejamatabënajinaemë tapatsijavanexatsica, jemata icatsia patsianicajë, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata itsamatacabi icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús livaisi tsipaeba pijajivijavabelia petuxanenë pijajivitonëbeje pelivaisicuenia. Bajarapacuenia pijajivijavabelia tsipaeba copiaevetsiaya petonacuenebavanapaenexatsi icatsia pepatsimatacabitsicajavabelianexa. Jesús jumaitsi mapacueniaje: —Petuxanenë pijajivitonë, ponë xaniavaetsia pijatuxanenë pecovëta tonacuenebaponaponaena, majamatabëcueneitsi tsaneje. Bajaraponë itsajamatabëcuene xainaenejeva, copiaevetaponaponaena pijatuxanenë pepatsijavabelianexa. Bajaraponë pijatuxanenë pijajivi pecovëta toevetaponaponaena piabatabiabinexa pexaejava caematacabi canacujitsia pacuenia pijatuxanenë itorobatsi. ");
INSERT INTO guh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bajaraponë bitso barëya tsane pamatacabi pijatuxanenë patsiana, xaniavaetsia pijajivi petoevetaponaponaexae pecovëta. ");
INSERT INTO guh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xaniajanë pacuenia pacatsipaebijitsiatsi. Ponë xaniavaetsia tonacuenebiana pijatuxanenë pecovëta, bajaraponë evetsiaexanaenatsi daxita xua xaina pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Itsa bajaraponë piajamatabëcuenebejenë tsipae, nexata pijatuxanenë pecovëta jamatabëjumaitsi tsipae: “Tajatuxanenë ajibi tsarucae tsane bajayajebi,” jamatabëjai tsipae. ");
INSERT INTO guh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nexata toconibabeyabiabijitsipa pijatuxanenë pijajivi. Ayaijava xaeyabiabijitsipa. Naapaeyabiabijitsipanua piaitajibivita. ");
INSERT INTO guh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nexata itsajota apo jamatabënajinae tsipae pijatuxanenë pepatsijavanexa, patsipa pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nexata bajaraponë ayaicuenia naneconitsiaexanaejitsipatsi pijatuxanenë. Pacuenia jivi peyamaxëitojorobabiabivi, Dioso ayaicuenia naneconitsiaexanaenatsi, bajarapacuenia pijatuxanenë naneconitsiaexanaejitsipatsi. Nexata natsinuejitsipa. Navonosinijitsipanua bitso penavixaetaexae, jai Jesús pijajivijavabelia petuxanenë pijajivitonëbeje pelivaisicuenia petsipaebijavata. Bajarapacuenia Jesús tsipaeba pijajivi xaniavaetsia pecopiaevetavanapaenexatsi Jesús icatsia pepatsimatacabitsicajavabelianexa. ");
INSERT INTO guh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús icatsia jumaitsi pijajivijavabelia: —Pamatacabi icatsia patsianicajë, tajajivi peyapëtaexae tapatsijavanexatsica, jamatabëcueneaitavaya necopiaevetavanapaena. Itsamonae tajajivi yapëtae ata tapatsijavanexatsica, itsiata jamatabëcueneaitavaya apo necopiaevetavanapae tsane. Bajarapacuene yabara pacatsipaebianatsi mapalivaisije. Diez papejanavabeje yapëtane itsava pejanava penacasabijavanexa. Nexata diez papejanavabeje pijalámparabëxi, caeva canacujitsia, xaniavaeta penaponaenexa. Nexata capona pijalámparabëxi pabojavabelia eca penacasabivanexa. Bajarajota vajënaeevetsijitsia pepatsijava penacasabinënexa. Nexata itsa ponabeje penacasabijivibejenexa, bajarapapejanavi penaponaenexa bajarapajivibeje pepëta penacasabifiestajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Bajarapamonaeyajuvënëvi, cinco povabeje, yapëtae ata picani petsicaponaejavanexa aceiteranë pijalámparabëxinexa, itsiata apo tsicaponae itsa tovereverecatsi aceitera peepatsinexa icatsia pijalámparabëxijavabelia. Cinco pijinia povabeje peyapëtaexae petsicaponaejavanexa aceiteranë pijalámparabëxinexa, tsicapona. ");
INSERT INTO guh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nexata bajarapapetiriavi itayotena pijalámparabëxita. Bajayajebi picani vajënaeevetena penacasabinënexa pepatsijava. Nexata pijalámparabëxita paaceiteranë capona, tovereverecaponatsi baja. Tsipaji penacasabinënexa abaxë cuenenajemata pepatsinexa. Nexata baja daxita bajarapapetiriavi belia itamajitsipana. Nexata baja majita. ");
INSERT INTO guh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bajaraxuacujinae ayaimeravi tuatuajëta jumetane pevavajaijava. “¡Najetaruca rajane baja penacasabinënexa! ¡Papitsaparemena jane baja panecopiapitsinexa!” pejaijava jumetane. ");
INSERT INTO guh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nexata daxita bajarapapetiriavi nonobapuna pecopiapitsinexa jane baja. Papetiriavi aceiteranë tsicapona, epaca pijalámparabëxijavabelia. Caeva canacujitsia pijalámparabëxi ayaicotia exana. ");
INSERT INTO guh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nexata papetiriavi apo tsicaponae aceiteranë, jumaitsi aceiteranë petsicaponaevijavabelia mapacueniaje: “Panenarajure tsiquirijavaxi aceiteraxi. Tsipaji patajalámparabëxi panetoitacaëcaënapona,” jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Itsiata aceiteranë petsicaponaevi jumaitsi: “Jume. Apo caëjëpae. Paxanë ata meta apo panetocaëjëpae tsipae. Paponaremelia. Panijacuata pacomuare itsajotalia canajetabiaba aceiteranë,” jai aceiteranë petsicaponaevi pijalámparabëxinexa. ");
INSERT INTO guh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nexata papetiriavi aceiteranë apo tsicaponae pijalámparabëxinexa, ponalia aceiteranë pecomuacaenexa. Nexata pecovëta penacasabinënexa patanajetaruca. Nexata papetiriavi aceiteranë tsicapona pijalámparabëxinexa, napona baja penacasabifiestanexa pexanaebojavabelia. Pejonecujinaelia baupaxatata. ");
INSERT INTO guh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bajaraxuacujinae aceiteranë pijalámparabëxi petsicomuacaevi pata. Nexata bajarapapetiriavi jumaitsi penacasabinënexajavabelia: “¡Panetobaupare! ¡Panetobaupare! jai tsanubenae bojumavelia. ");
INSERT INTO guh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nexata penacasabinënexa jumaitsi: “Xaniajanë pacuenia pacatsipaebijitsiatsi. Apo pacayapëtaetsi cajena paxamë,” jai bajarapapetiriavijavabelia, jai Jesús mapalivaisije pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús icatsia jumaitsi pijajivijavabelia: —Pacuenia cinco povabeje peyapëtaexae, aceiteranë tsicapona pijalámparabëxinexa, bajara pijinia pacuenia paxamë ata paneyapëtaexae, jamatabëcueneaitavaya panecopiaevetavanapaename. Tsipaji apo payapëtaemë tsane pamatacabita, paepatota ata, xanë, Daxitajivi Pematapijinënë, icatsia patsijitsianëtsica, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús icatsia jumaitsi pijajivijavabelia: —Tacovëta patajajivimë, itsamonae ata, pamonae tajajivi, panetonacuenebianame. Nexata pamatacabi icatsia patsianicajë, pacuenia pacasivanajamatabëxainaejitsiatsi, aeconoxae pacatsipaebianatsi. Pacatsipaebianatsi comparacióncuenia mapacueniaje. Petuxanenë itsa ponaejitsia tajënacuayabelia, junata pijajivi. Evetsiaexana pijapalata petoevetsinexatsi pecovëta. ");
INSERT INTO guh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Caenë canacujitsia evetsiaexanapona petocanacuenebinexatsi pecovëta pacuenia bajarapamonae caëjëpatsi. Nexata petuxanenë pijinia evetsiaexana cinco mil ponëbeje pepovi, bitso penamatamotsivi. Itsanë pijinia evetsiaexana dos mil ponëbeje. Itsanë pijinia evetsiaexana mil ponëbeje. Bajaraxuacujinae petuxanenë pona tajënacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nexata jane baja ponë evetsiaexana cinco mil ponëbeje, canacueneba jane baja pecovëta bajarapapalata. Nexata pematatsënëa topitsapatsi icatsia itsacinco mil ponëbeje. Nexata baja daxitata diez mil ponëbeje caejavata. ");
INSERT INTO guh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bajara pijinia pacuenia itsanë canacueneba dos mil ponëbeje. Nexata pematatsënëa topitsapatsi icatsia itsados mil ponëbeje. ");
INSERT INTO guh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Itsiata baitsi jane ponë toeveta mil ponëbeje, pona pematayatsinexa pijatuxanenë pijapalata. Matayatsia mëthëteta irata. ");
INSERT INTO guh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bexëa nexata najetaruca petuxanenë. Junata pijajivi peyapëtaenexa pacuenia toevetatsi pecovëta pijapalata. ");
INSERT INTO guh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Copiaya pata ponë cinco mil ponëbeje evetsiaexanatsi. Nexata bajaraponë tocanaviata pijatuxanenëjavabelia diez mil ponëbeje. Jumaitsi bajaraponë pijatuxanenëjavabelia: “Nevetsiaexaname cinco mil ponëbeje tacatoevetsinexa. Bajara macatocanaviatatsi bajarapapalataje. Catocanaviatatsi yajava icatsia itsacinco mil ponëbeje, xua nacanabajë bajarapapalatata,” jai bajaraponë pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nexata petuxanenë jumaitsi: “Xanepana rabaja. Xaniavaetsia netoevetaponaponame. Itsajamatabëcuene apo najamatabëxainaemë. Tsiquirijavayo ata xaniavaetsia netoevetame. Nexata aeconoxae caevetsiaexanaenatsi pematatsënëa ayaijava. Jonemena xanëjavaberena barëyaya neponaponaenexa xanëjavata,” jai petuxanenë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bajaraxuacujinae pata ponë dos mil ponëbeje evetsiaexanatsi. Nexata bajaraponë jumaitsi pijatuxanenëjavabelia: “Nevetsiaexaname dos mil ponëbeje tacatoevetsinexa. Bajara macatocanaviatatsi bajarapapalataje. Catocanaviatatsi yajava icatsia itsados mil ponëbeje, xua nacanabajë bajarapapalatata,” jai bajaraponë pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nexata petuxanenë jumaitsi: “Xanepana rabaja. Xaniavaetsia netoevetaponaponame. Itsajamatabëcuene apo najamatabëxainaemë. Tsiquirijavayo ata xaniavaetsia netoevetame. Nexata aeconoxae caevetsiaexanaenatsi pematatsënëa ayaijava. Jonemena xanëjavaberena barëyaya neponaponaenexa xanëjavata,” jai petuxanenë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Icatsia pata ponë evetsiaexana mil ponëbeje. Bajaraponë jumaitsi pijatuxanenëjavabelia: “Cacueneyapëtanetsi. Xamë nijajivi apo itaxutobejiobiataeyabiabimë. Xamë nijajivi ubiaexanabiabame neubiaexanabiabijava nexata bajarapamonae pejamatabëcueneta ayaijava palata pecatopitsapaenexa. Bajara pijinia pacuenia xanë ata nevecuapitsipame xua nacanabijitsipajë nijapalatata itsa canacuenebijitsipajë. ");
INSERT INTO guh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bajaraxuata junavajë. Ponajë irata tamatayatsiamëthëtetsinexa nijapalata. Bajara manijapalata catocanaviatatsije,” jai bajaraponë pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nexata petuxanenë jumaitsi: “Tajajivitonë atamë, itsiata ajamatabëcuenebejemë. Afaetabimënua. Xamë baja cajena yapëtaneme tajajivi taubiaexanabiabijava, taubiaexanabiabijava nexata bajarapamonae pejamatabëcueneta ayaijava palata tanetopitsapaenexa. ");
INSERT INTO guh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bajaraxuata xanepanaejitsipa itsa netocanacuenebiaexanaejitsipame tajapalata banco pevetsivijavabelia. Nexata aeconoxae banco pevetsivi tajapalata pecacovaetsijamatabëcuene netocanaviatsipa tajapalata pematatsënëa,” jai petuxanenë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nexata petuxanenë jumaitsi bajarajota penubenaevijavabelia: “Pavecuapire bajarapamil ponëbeje. Nexata juya parajure ponëjavabelia xaina diez mil ponëbeje. Tsipaji bajaraponë caëjëpatsi tanetoevetsinexa pematatsënëa. ");
INSERT INTO guh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsipaji pajivi ayaijava baja xaina, pematatsënëa icatsia itsajava rajutsianatsi. Nexata xainaena ayaijava. Itsiata pajivi tsiquirijavayo xaina, bajarapajivi pijatsiquirijavayomi vecuapitsianatsi. ");
INSERT INTO guh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Maponë tajajivitonëje, itsacuenejavayonexa ata, apo netoxanepanae. Paxuabaremelia pitaquirijavabelia. Bajarajota natsinuena. Navonosiniananua bitso penavixaetaexae,” jai petuxanenë, jai Jesús comparacióncuenia pijajivijavabelia. Bajarapacuenia Jesús jumaitsi pamonae pijaneconi pexainaevi Jesús penaneconitsiaexanaenexa pamatacabi icatsia patsianica. ");
INSERT INTO guh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús tajëvelia navajunupaeba pacuenia itsamatacabi exanaejitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xanë, Daxitajivi Pematapijinënë, icatsia itsa najetarucaenajë daxitanacua taevetsinexa, ángelevi nematatoyoronaeya yajavanajetarucaenajë. Nexata ecaenajë tajapenivenivenaetronovënëjavata. ");
INSERT INTO guh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Nexata daxitanacuanëpijivi caetuatsianatsi taitabarata. Tsataponaenajë bajarapamonae. Oveja pevetsinë ovejavecua chivo saicaya tsatapona. Nexata oveja pevetsinë petsavenonenia chivo nubenaeyaexana. Pecujuanenia pijinia oveja nubenaeyaexana. Bajara pijinia pacuenia xanë tsataponaenajë Dioso apo pejumecovënëtsivi, Dioso pejumecovënëtsivivecua. Dioso apo pejumecovënëtsivi tatsavenonenia nubenaeyaexanaenajë. Dioso pijinia pejumecovënëtsivi tacujuanenia nubenaeyaexanaenajë. ");
INSERT INTO guh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nexata jumaitsinë tsane tacujuanenia penubenaevijavabelia, Dioso pejumecovënëtsivi: “Naxanitsia. Paxamë taxa papecaitaxutotsoniataevi. Payajavajinavanapaename taxa pijanacuatatsia, itsajotatsia pacatoxaniavaeta tajëvelia. Dioso pacatoxaniavaeta nacua pexanaejavaveliacujinae. ");
INSERT INTO guh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Itsa tajani, paxamë taxaejava panerajutame. Itsa mera jitsipajë, panerajutame mera. Itsanacuaverena itsa patajë, panecopiapitame xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Itsa ajibi bitso tanaxatatsijava, panerajutame tanaxatatsijavanexa. Itsa avitanenë, papatame patanevetsinexamë. Itsa neeta penaneconitsivi pejebabiabibota, papatame patanetaenexamë,” janë tsane tacujuanenia penubenaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nexata bajarapamonae nejumai tsane: “Tajatuxanenë, ¿detsa pacujinae niajanijavata patajacarajutsi nexaejava?” nejai tsane. ¿Detsa pacujinae mera nejitsipaejavata patajacarajutsi mera? nejai tsane. ");
INSERT INTO guh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Itsa jume, nejumai tsane: “¿Detsa pacujinae itsanacuaverena nepatsinë patajacacopiapitsi xaniavaetsia?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae piajibijavata bitso nenaxatatsijava patajacarajutsi nenaxatatsijavanexa?” nejai tsane. ");
INSERT INTO guh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Itsa jume, nejumai tsane: “¿Detsa pacujinae niavitanejavata patajaponae patacaevetsinexa?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae pecaetsijavata penaneconitsivi pejebabiabibota patajaponae patacataenexa?” nejai tsane. ");
INSERT INTO guh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nexata xanë jumaitsinë tsane bajarapamonaejavabelia: “Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita xua patoexaname paneyavenonaenexa tajajiviyajuvënëjivi, beveliajamatabëcuenevi petaevitsijavabelia, bajaraxua xanë taniji xanëjavaberena bepatanetoexanaejavamë,” janë tsane. ");
INSERT INTO guh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Nexata tatsavenonenia penubenaevi, Dioso apo pejumecovënëtsivijavabelia, jumaitsinë tsane: “Panevecuanatsare panijaneconi paneyajavajinavanapaevi. Paponaremelia apo pevereverecaeisotojavabelia. Bajarapaisoto Dioso tajëvelia toxaniavaeta dovathinexa, dovathi pijajivinexa ata. ");
INSERT INTO guh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xanë itsa tajani, paxamë apo panerajutsimë taxaejava. Itsa mera jitsipajë, apo panerajutsimë mera. ");
INSERT INTO guh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Itsanacuaverena itsa patajë, apo panecopiapitsimë xaniavaetsia. Itsa ajibi bitso tanaxatatsijava, apo panerajutsimë tanaxatatsijavanexa. Itsa avitanenë, apo papatsimë patanevetsinexamë. Itsa neeta penaneconitsivi pejebabiabibota, apo papatsimë patanetaenexamë,” janë tsane tatsavenonenia penubenaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nexata bajarapamonae pijaneconi peyajavajinavanapaevi nejumai tsane: “Tajatuxanenë, ¿detsa pacujinae niajanijavata apo pacarajutsitsi nexaejava?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae mera nejitsipaejavata mera apo pacarajutsitsi?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae itsanacuaverena nepatsinë, apo pacacopiapitsitsi xaniavaetsia?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae bitso pecatoajibijavata nenaxatatsijava, apo pacarajutsitsi nenaxatatsijavanexa?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae niavitanejavata, apo paponaenë patacaevetsinexa?” nejai tsane. Itsa jume, nejumai tsane: “¿Detsa pacujinae penaneconitsivi pejebabiabibota pecaetsijavata, apo paponaenë patacataenexa?” nejai tsane bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nexata xanë jumaitsinë tsane bajarapamonaejavabelia: “Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajarapacuenia itsa apo patoexanaemë paneyavenonaenexa tajajiviyajuvënëjivijavabelia, nexata bajaraxua xanë taniji xanëjavaberena apo patanetoexanaejavamë,” janë tsane pijaneconi peyajavajinavanapaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bajaraxuacujinae bajarapamonae ponaena penaneconitsiajinavanapaenexa daxitamatacabijavabelianexa. Pamonae Dioso pejumecovënëtsivi, bajarapamonae Dioso rajutsianatsi matacabi apo pevereverecaejava, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata itsamatacabi penaneconitsiaexanaejavanexa pijaneconi pexainaevi, pamatacabi icatsia patsianica. ");
INSERT INTO guh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Itsa baja Jesús najumevereta pijajivijavabelia livaisi petsipaebijava, Jesús icatsia tajëvelia navajunupaeba itsamonae cruzajavabelia pecobematabiabarutsijavanexatsi. Jesús jumaitsi pijajivijavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Payapëtaneme rabaja anijamatacabibeje pesajinaejava pejonenexa baja pascuavënëfiesta. Nexata xanë, Daxitajivi Pematapijinënë, necanajetsiana itsamonae pecobeyabelia tanecobematabiabarutsinexa cruzajavabelia, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata cruzajavabelia pecobematabiabarutsijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nexata bajarapaepatota nacaetuata sacerdotevi penamatacaitorobivi. Nacaetuata judíovi pecujarubivinua. Nacaetuata judíovi pijaancianovinua. Daxita bajarapamonae nacaetuata Caifásvënënë pijaboxanetota. Bajaraponë Caifás, sacerdotevi pepo penamatacaitorobinë. ");
INSERT INTO guh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bajarajota daxita bajarapamonae najumejaita. Penajumetsënëtsilivaisita picani Jesús jamatabëvaetabatsi pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Itsiata bajarapamonae najumaitsi: —Fiestajavata meta abaxë apo vaetabi tsanetsi jivi vajanacaitsacueniabiyaniva, najai daxita bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ponapona Betania tomarata, Simón pijabota. Simón bajayajebi bitso peperabëtsabanaenëmi. ");
INSERT INTO guh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nexata Jesús petiriva cobenaimoxoyorenatsi petuxujuviaceitera, alabastrobotellabëta pejeaceitera. Bajarapora bitso penamatamotsira. Nexata Jesús penabanecaejavata mesata, bajarapova tsimataepanaicatsi bajarapaaceitera. ");
INSERT INTO guh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nexata Jesús pijajivi itsa taeyena Jesús petsimataepanaejavatsitsica bajarapaaceitera, Jesús pijajivi jamatabëcueneanaepanareca. Nexata ëpamonae najumai tsenae: —¿Detsa xuajitsia saya xuaba bajarapacuenia maporaje? ");
INSERT INTO guh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Canajetsipa rajane. Nexata matamopitsipa ayaimatamo. Bajarapapalata rajutsipa bepejiobivi bajarapacuenia peyavenonaenexa, najai tsenae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nexata Jesús jumetane bajarapacuenia pijajivi pejumaitsijava. Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia bajarapacuenia pajumaitsimë bajarapova pexanaejava yabara? Mara povaje pexaniacuene nexanaje. ");
INSERT INTO guh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Daxitamatacabi raja bepejiobivi jinavanapa itsaxuayo pajinavanapame. Itsiata baitsi jane xanë daxitamatacabi apo ponaponaenë tsane paxamëjavata. ");
INSERT INTO guh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Itsamonae petëpaejivi batsiperabëepana petuxujuviaceitera peperabëxaniavaetsinexa pemëthëtsivajënae. Bajara pijinia pacuenia mapovaje netsimataepana petuxujuviaceitera, abaxë apo tëpae atanë. Nexata baja bajarapova neperabëxaniavaeta itsamonae tanemëthëtsivajënae. ");
INSERT INTO guh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxitanacuanëjava tajajivi itsa paebanajetarubenaena pexanialivaisi jivi tacapanepaelivaisinexa, vajunupaebabiabiananua pacuenia exana xanëjavaberena mapapetirivaje, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús pijajivi, doce ponëbejeyajuvënënë, pevënë Judas Iscariote. Nexata Judas pona sacerdotevi penamatacaitorobivijavabelia. Jesús jane baja yajumejailiatsi pecanajetsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nexata Judas jumaitsi sacerdotevi penamatacaitorobivijavabelia: —¿Detsa pacuenia panerajutsipame panecobeyabelia itsa canajetsipajë Jesús? jai Judas. Nexata bajarapamonae Judas matamotatsi treinta ponëbeje pepo palatanëanë, bitso penamatamotsinëanë. ");
INSERT INTO guh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nexata bajaraxuacujinae Judas Jesús naitaxutocaevetsia ponapona. Nexata paepatota Judas toyapëxanepanatsi, perajutsinexa jane baja Jesús bajarapamonae pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Junua jane baja fiesta, pafiestajava judíovi baxane levadurata matajërëabinejeva pexanaepan. Nexata Jesús pijajivi imoxoyorenatsi. Yanijobatsi pijajivi. —¿Detsa belia paponaenajë patacamitsaexanaenexa, xua jivi baxane pascua fiestamatacabi, nexaenexa? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nexata Jesús jumaitsi pijajivijavabelia: —Paponare tomarabelia. Pacatsipaebianatsi ponë pijabota papatsijitsiamë. Pajumaitsimë tsane bo pexainaenëjavabelia mapacueniaje: “Vajanacacujarubinë raja jumaitsi: ‘Imoxoyo rabaja tavajënae tanebeyaxuabinexa. Nexata bajaraponë pijabo netsicopatsiana patacabarëxaenexa xua jivi baxane pascua fiestamatacabi,’ jai raja vajanacacujarubinë,” pajamë tsane bo pexainaenëjavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nexata baja Jesús pijajivi pona pacuenia Jesús jumaitsi. Nexata xua jivi baxane pascua fiestamatacabi daxita Jesús pijajivi pebarëxaenexa, Jesús pijajivi exana jane baja. ");
INSERT INTO guh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nexata baja ajena meraviyotsia, Jesús pijajivi, doce ponëbeje, barëeca mesa muxuneneta. ");
INSERT INTO guh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nexata pexaeyenaejavata Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Caenë paxamëyajuvënënë necanajetsiana tajavajabitsaë pecobeyabelia, jai Jesús pijajivijavabelia Judas yabara. ");
INSERT INTO guh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nexata Jesús pijajivi bejamatabëjiobireca. Nexata Jesús pijajivi, caenë canacujitsia, Jesúsjavabelia yanijobapona. —Tajatuxanenë, ¿xanë tsaja tsane? jai tsaponae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nexata Jesús jumaitsi pijajivijavabelia: —Ponëbeje peneta caecuenia panajuacajabutsianajëbeje panbë platojavabelia, bajaraponë necanajetsiana tajavajabitsaë pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xanë, Daxitajivi Pematapijinënë, tëpaenajë pacuenia baja cajena xanë yabara Dioso pejumelivaisibaxutota tajëvelia jumaitsi. Itsiata ponë tajavajabitsaë pecobeyabelia necanajetsiana, bajaraponë bitso bejiobi tsane pinijicuenia. Itsa meta bajaraponë apo naexanae tsipae, bajarapacuenia apo necanajetsi tsipae. Nexata xanepanaejitsipa bajaraponë itsa apo naexanae tsipae. Tsipaji apo naneconitsi tsipae Diosojavabelia, jai Jesús pijajivijavabelia Judas yabara. ");
INSERT INTO guh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nexata Judas, ponë jane baja canajetsijitsiatsi Jesús pijavajabitsaë pecobeyabelia, jumaitsi: —Petuxanenë, ¿xanë tsaja tsane? jai. Nexata Jesús jumaitsi: —Jãjã, xamë rabaja tsane, jai. ");
INSERT INTO guh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pexaeyenaejavata Jesús pita panbë. Jesús jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pan, jai. Bajaraxuacujinae Jesús epatsënëquejeba bajarapapanbë. Rajuta pijajivi. Jesús jumaitsi pijajivijavabelia: —Paxaema. Mara tavitoje, jai. ");
INSERT INTO guh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bajaraxuacujinae icatsia Jesús copavënëjavata yapita piapaeranexa. Diosojavabelia jumaitsi: —Pexaniacuene panetoexaname. Panerajutame maporaje, jai. Bajaraxuacujinae pijajivi bajarapora rajuta. Jumaitsi pijajivijavabelia: —Papaema padaxitamë maporaje. ");
INSERT INTO guh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tsipaji tajana othopaena jivi ayaibitsaëtoxaneto pibisiacuene pexanaeneconi pevecuaajibiaexanaenexatsi. Nexata tatëpaejava pejamatabëcueneta, jivi yapëtaena pepacuene xaniajai Dioso jivi pecapanepaejavanexa, pacuenia baja cajena tajëvelia Dioso najumecapanepaeya jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Xaniajanë pacuenia pacatsipaebijitsiatsi. Xanë rabaja mapanacuataje matavëjëa apo apaenë tsane uvacuaira, matapania icatsia pejanauvacuaira pacayajavaapaenatsi taxa pijanacuatatsia, jai Jesús pijajivijavabelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jesús pijajivi barënaxëana Diosojumevajianë. Bajaraxuacujinae Jesús pijajivi barëpona petsutojumabelia. Patsutojumata olivonaenë apaaxayo, bajarapatsutojumabelia barëpona. ");
INSERT INTO guh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nexata bajarapatsutojumata Jesús jumaitsi pijajivijavabelia: —Daxita raja paxamë ajena, pameravi, panexuabarëcëpecaename. Tsipaji rabaja patanexuabarëcëpecaejavanexamë yabara, Dioso pejumelivaisibaxutota tajëvelia jumaitsi mapacueniaje: “Beyaxuabianatsi raja oveja pevetsinë. Nexata pijaovejabitsaëto nacayajatsia rëcëpecaena,” jai Dioso pejumelivaisibaxutota paxamë patanexuabarëcëpecaejavanexamë yabara. Nexata ajena, pameravi, tajavajabitsaë itsa nevaetabiana tanebeyaxuabinexa, daxita paxamë panexuabarëcëpecaename. ");
INSERT INTO guh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Itsiata baitsi jane tatëpaecujinae, icatsia asaënë tsane. Nexata paxamë panevajënaeyabelia, copiata ponaenajë Galilea nacuayabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nexata Pedro jumaitsi Jesúsjavabelia: —Daxita mapamonaeje caxuabarëcëpecae ata tsane, xanë cajena apo caxuabatabajiravi tsanetsi, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nexata Jesús jumaitsi Pedrojavabelia: —Xaniajanë pacuenia catsipaebijitsiatsi. Ajena rabaja, pameravi, nanianaevëpata, vacara pefiabivajënaeya, nayavajunuaxainaename tajajivitonëcuenemë. “Apo yapëtaenë cajena bajaraponë,” jamë tsane xanë yabara acueyabi xuabeje, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Itsiata Pedro jumaitsi Jesúsjavabelia: —Nebeyaxuabijitsia ata tsane xamë yajava, itsiata cajena apo nayavajunuaxainaenë tsane nijajivitonëcuenenë, jai Pedro Jesúsjavabelia. Daxita Jesús pijajivi bajarapacuenia jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús pijajivi pecunuameravita yajavapata Getsemanívënëjavata. Bajarajota Jesús jumaitsi pijajivijavabelia: —Paneevetenare abaxë majotaje. Abaxë raja imoxoyo majotaliaje vajëtsijitsianë Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nexata Jesús barëpona acueyabi ponëbeje pijajivi. Jesús pijajivi barëpona pesaicaeyojavabelia mapamatabëxëyoje. Pedro, Santiago, Juan, bajarapamatabëxëyo. Santiagobeje Juanbeje Zebedeo pexënatobeje. Bajaraxuacujinae Jesús bitso najamatabëxaina. Nexata bejamatabëjiobireca. ");
INSERT INTO guh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nexata Jesús jumaitsi pijajivi acueyabi ponëbejejavabelia: —Xanë bitso pinijicuenia najamatabëxainajë. Nexata bitso tanajamatabëxainaejava, jamatabëyatëpajë. Paxamë abaxë majotaje panacopabare. Paitavamë tsane. Pëtsa abaxë pamajitame, jai Jesús pijajivi acueyabi ponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nexata Jesús caenë pevajënaeyabelia icatsia tsiquirijavayo ponataba. Nexata Jesús irataeya bocajunua pevajëtsinexa Diosojavabelia. Jumaitsi Diosojavabelia: —Taxa Diosomë, netocopatame picani tanebeyaxuabinexa betajiobicueneta. Daxitacuene raja cacaëjëpa nexanaenexa. Nexata necapanepare bajarapabejiobicuenevecua. Itsiata xanë apo tajitsipaecuene ata, pacuenia xamë jitsipame, netocopatsianame, jai Jesús Diosojavabelia pevajëtsijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bajaraxuacujinae Jesús naviarena acueyabi ponëbeje pijajivijavaberena. Caxitajaraba Jesús pijajivi pemajitanubenaevi. Nexata Jesús jumaitsi Pedrojavabelia: —¿Apo pacacaëjëpae tsabaja rovia caeepatoyo ata paneaitavatsenaenexa? ");
INSERT INTO guh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pëtsa pamajitame. Paitavamëre. Pavajëre Diosojavabelia papecayavenonaenexa pibisiacuene paneexanaeyaniva. Tsipaji raja dovathi pacajamatabëcueneëjëbiana. Paxamë picani panejamatabëcueneta pexaniacuene jamatabëpaexanabiabame. Itsiata baitsi jane apo pajamatabëcuenesaëmë pexaniacuene paneexanaenexa, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nexata icatsia Jesús pona pecovëyabelia pevajëtsinexa icatsia Diosojavabelia. Vajëta Diosojavabelia mapacueniaje. —Axa, itsa apo jitsipaemë tanevecuatsatsinexamë betajiobicueneta tatëpaejavanexa, nexata pacuenia jitsipame, netocopatsianame, jai Jesús Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bajaraxuacujinae Jesús icatsia naviarena pijajivijavaberena. Caxitajaraba icatsia Jesús pijajivi pemajitanubenaevi. Tsipaji baja Jesús pijajivi bitso itamajitsipana. ");
INSERT INTO guh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nexata abaxë bajarapamonae pemajitanubenaejavata, Jesús icatsia pona pecovëyabelia pevajëtsinexa icatsia Diosojavabelia. Nexata icatsia vajëta Diosojavabelia pacuenia vajëta copiaya xuabeje vajëta. ");
INSERT INTO guh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bajaraxuacujinae icatsia Jesús naviarena pijajivijavaberena. Jumaitsi Jesús pijajivijavabelia: —¿Abaxë tsarovia tsiteca pamajitanubename? Copiapata rabaja paepatota xanë, Daxitajivi Pematapijinënë, necanajetsijitsia pibisiacuene pexanaevi pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Panonobapunare baja. Ponaenatsi baja. Imoxoyo rabaja najetaruca tajavajabitsaë pecobeyabelia tanecanajetsinënexa, jai Jesús pijajivijavabelia Judas yabara. ");
INSERT INTO guh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús pijavajabitsaë pevaetabijavatanexatsi, cuaicuaijai tsanucae pijajivijavabelia. Nexata bajarapaepatota patanajetaruca Judas, Jesús pijajivi doce ponëbejeyajuvënënëmi. Judas pënanajetarubenatsi jivi ayaibitsaëtoxaneto. Bajarapamonaeyajuvënëvi itsamonae canajetarubena espadanë. Itsamonae canajetarubena naebonë yajava. Bajarapamonae itorobatsi sacerdotevi penamatacaitorobivi, judíovi pijaancianovinua. ");
INSERT INTO guh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas pebarërenavajënae bajarapamonae, copiaya baja cajena Judas tsipaeba pacuenia bajarapamonae yapëtaejitsia Jesúscuene. Judas jumaitsi mapacueniaje: —Ponë raja peneta bajacobiaya itabaratsutsunexuabianajë, bajaraponë Jesús tsane. Bajaraponë pavaetabianame. Pacobecëtsiana xaniavaetsia, jai baja cajena Judas pematacanajetarucaevijavabelia pebarërenavajënae. ");
INSERT INTO guh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nexata jane baja Judas itsa patanajetaruca, exana pacuenia jumaitsi pematacanajetarucaevijavabelia. Judas Jesús itabaratsutsuniaya bajacobatsi Judas jane baja pematacanajetarucaevi peyapëtaenexa Jesúscuene. ");
INSERT INTO guh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús nexata jumaitsi Judasjavabelia: —Judas, ¿detsa xua yabara patame? jai. Nexata jane baja Jesús petsimaxëponaevitsi, cujibarëcëpaliatsi. Vaetabatsi. Cobecëtatsi xaniavaetsia pecaponaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bajarajota Jesús pijajiviyajuvënënë pijaespada navemarajonotaxuabina. Muxuyoropaebiaxuaba sacerdotevi pepo penamatacaitorobinë pijajivitonë. ");
INSERT INTO guh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nexata Jesús jumaitsi pijajivitonëjavabelia: —Nijaespada baja xataremeca pevënojojavareca. Tsipaji pamonae namaxëvanita espadata, daxita bajarapamonae juya espadata babiatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Icatsia Jesús jumaitsi: —Itsa vajëtsipajë taxa Diosojavabelia taneyavenonaevinexa tanetoitorobinexatsica, nexata tavajëtsiepatota netoitorobijitsipaica bitso ayaibitsaëtoxanetonë ángelevi. ");
INSERT INTO guh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Itsa vajëtsipajë taxa Diosojavabelia tanetoitorobinexatsica taneyavenonaevinexa, nexata baja apo netocopiapatsi tsipae pacuenia Dioso pejumelivaisibaxutota tajëvelia nevajunupaeba pacuenia nevaetabijitsia tanebeyaxuabinexa, jai Jesús pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nexata Jesús bajarajota jumaitsi petsimaxëponaevitsijavabelia: —Paxamë meta panetaneme betanacobetoxotsinë. Bajaraxuata pacaponame espadanë, naebonë yajava, patanevaetabinexamë pacuenia pavaetababiabame penacobetoxotsinë. Xanë caematacabi canacujitsia Dioso pejumelivaisi paxamëjavabelia pacatsipaebabiabatsi templobota. Itsiata bajarapamatacabi apo panevaetabimë. ");
INSERT INTO guh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mara pacuenia panevaetabameje tanetocopiapatsixae baja pacuenia Dioso pejumelivaisibaxutota bajayata tajëvelia nevajunupaeba, jai Jesús pevaetabivitsijavabelia. Nexata jane baja Jesús pijavajabitsaë pevaetabijavatatsi, daxita Jesús pijajivi xuabarëcëpecatsi pacuenia baja cajena Jesús tajëvelia jumaitsi pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús pevaetabivitsi caponaliatsi Caifás pijaboyabelia. Bajaraponë Caifás sacerdotevi pepo penamatacaitorobinë. Nexata Caifás pijabota nacaetuana judíovi pecujarubivi, judíovi pijaancianovi yajava. ");
INSERT INTO guh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Itsa baja Jesús caponaliatsi, nexata Pedro bajarapamonae pecovëya tajiyo najetaruca. Sacerdotevi pepo penamatacaitorobinë pijabo matatoyorotsia yacaranata ibopanaxanetonë mataropotsia pefaratsijavaxanetota. Nexata bajarapayacaranatsijavaxaneto baupa, Pedro najoneya bopanabojavabelia, itsabelia Jesús cajunuatsi. Nexata sacerdotevi pepo penamatacaitorobinë pijabopanabota, Pedro naeca templobopijipolicíavita. Bajarajota Pedro naeca petaenexa pacuenia Jesús pijavajabitsaë exanatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nexata bajarapabo ënëtuatuajëta sacerdotevi penamatacaitorobivi, judíovi pijaancianovi ata yajava, judíovi pecujarubivi ata yajava, nabarëcuaicuaijai. Bajarapamonae nayanijoba. —¿Jipatsa yapëtane Jesús pibisiacuene pexanaejava, paneconi yabara beyaxuabijitsiatsi? najai tsaponae. Itsiata bajarapamonae apo caxitajarabi itsaneconi ata, Jesús pijaneconi. Najumetsënëtsiaya picani peneconitsilivaisinexa, jaita penajumetsënëtsilivaisita picani Jesús pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ayaibitsaëto pata penajumetsënëtsilivaisi pepaebinexa Jesús yabara. Itsiata caelivaisi ata najumejëpaeya apo paebi bajarapamonae. Nexata bajarapamonae apo caxitajarabi paneconi yabara Jesús naneconitsiaexanaejitsiatsi pebeyaxuabiaexanaenexatsi. Bajaraxuacujinae belia anijanëbeje caelivaisi najumejëpaeya neconitatsibeje. ");
INSERT INTO guh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jumaitsibeje bajaraponëbeje Jesús yabara: —Maponë jumaitsije: “Xanë necaëjëpa taxuabinexatsica Dioso pijatemplobo. Necaëjëpanua acueyabi matacabita icatsia taveretetsinexa itsabo,” jai maponëje, jaibeje bajaraponëbeje Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nexata jane baja sacerdotevi pepo penamatacaitorobinë nonotapuna bajarapamonae pitabarata. Nexata jumaitsi Jesúsjavabelia: —¿Apo yapëtaemë tsaja itsalivaisiyo ata nejumecanaviatsinexa? ¿Xaniajai tsabaja pacuenia maponëbeje caneconitsiajumaitsibeje? jai sacerdotevi pepo penamatacaitorobinë. ");
INSERT INTO guh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús itsiata moya. Nexata bajaraponë icatsia jumaitsi Jesúsjavabelia: —Caitorobatsi caecuenia tanenavajunupaebinexamë nexaniajaijumeta. Itsajume, Diosojavabelia naneconitsianame. Panenavajunupaebare xaniavetsia itsa xamë Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenexa. ¿Xamë tsaja Dioso pexënatomë? jai. ");
INSERT INTO guh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nexata Jesús jumaitsi: —Jãjã, xanë rabaja pacuenia nejumaitsimë. Nexata icatsia pacajumaitsitsi. Paxamë raja panetaename xanë, Daxitajivi Pematapijinënë, taecaejava Dioso pecujuanenia, daxitajamatabëcuene pecaëjëpaenëtsi. Panetaenamenua tanajetarucaejava athëbëvetsica itarërëbota, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bajarapacuenia Jesús pejumaitsijava itsa jumetane, sacerdotevi pepo penamatacaitorobinë penaxatatsijava anaeya titinaxuaba. Bajarapacuenia titinaxuaba pianaepanaexae Jesús pejumaitsijava yabara. Nexata sacerdotevi pepo penamatacaitorobinë jumaitsi daxita penacaetuatsivijavabelia: —Mara ponë Dioso apo pejitsipaecuenia cuaicuaijaije. Dioso bepexënato nataeya cuaicuaijai. Pijacuata rabaja naneconita bajarapacuenia pecuaicuaijaixae. Pematatsënëa baja apo namatavenonaetsi itsamonae vajanacatsipaebinexa paneconi yabara maponëje naneconitsiaexanaejitsiatsi. Paxamë rabaja pajumetaneme maponëje Dioso apo pejitsipaecuenia pecuaicuaijaijava. ");
INSERT INTO guh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Detsa nexata paxamë pajamatabëitsimë? jai sacerdotevi pepo penamatacaitorobinë daxita penacaetuatsivijavabelia. Nexata daxita penacaetuatsivi jumaitsi: —Naneconita rabaja Diosojavabelia. Nexata baja beyaxuabianatsi, jai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nexata bajarapamonae Jesús itabarasuabatsi. Bajaraxuacujinae papaëbërëpanata itaxutocëtatsi. Pitaxutocëtsicujinaetsi itabaratsaquibabeponatsi pecobethaitonëta. Itsamonae itabarapacabiaxuababiabatsi. ");
INSERT INTO guh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nexata bajarapamonae jumai tsaponae Jesúsjavabelia: —¡Xamë raja itsa Cristomë, athëbëvetsica Dioso itsa pecaitorobinëtsica jivi necapanepaenexa, nexata vënëjonare ponë caitabarapacabiaxuaba! jai tsaponae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Itsa abaxë Jesús sacerdotevi pepo penamatacaitorobinë pijabo ënëtuatuajëalia yanijobaponatsi xua yabara naneconitsiaexanaejitsiatsi, Pedro naitaxutocaevetsiaya naeca bopanabota. Nexata bajarapabota penacuenebiva Pedro cujirenatsi. Bajarapova jumaitsi Pedrojavabelia: —Xamë ata rabaja naponaponame Jesústa, Galilea nacuapijinëta, jai. ");
INSERT INTO guh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nexata Pedro itsiata nayavajunuaxaina Jesús pijajivitonëcuene. Daxita bajarajota penubenaevi pitabarata Pedro jumaitsi: —Xanë cajena apo yapëtaenë pacuene yabara nejumaitsimë, jai. ");
INSERT INTO guh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sacerdotevi pepo penamatacaitorobinë pijabo matatoyorotsia yacaranata ibopanaxanetonë mataropotsia pefaratsijavaxanetota. Nexata bajarapayacaranatsijavaxaneto baupajavabelia Pedro natixilia. Nuca bajarapabaupa muxuneneta. Bajarajota icatsia itsava, bajarapabota penacuenebiva, Pedro taenutatsi. Nexata bajarapova ata Pedro yabara icatsia jumaitsi bajarajota penubenaevijavabelia: —Mara ponë ata naponapona Jesústaje, Nazaret tomarapijinëta, jai bajarapova. ");
INSERT INTO guh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nexata icatsia Pedro nayavajunuaxaina Jesús pijajivitonëcuene. Pedro jumaitsi: —Xaniajanë. Dioso pitabarata cajumaitsitsi. Apo yapëtaenë cajena bajaraponë, jai. ");
INSERT INTO guh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bajaraxuacujinae icatsia, caeepatoyocujinae, bajarajota penubenaevi cujibarëcëpaliatsi Pedro. Jumaitsi bajarapamonae: —Xaniajai raeta baja cajena. Xamë Jesús pijajiviyajuvënënëmë. Tsipaji rabaja Galilea nacuapijivi penatsipaebicuenia natsipaebame, jai bajarapamonae Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nexata Pedro jumaitsi: —Itsa apo xaniajanë tsipae paxamëjavabelia, nexata Diosojavabelia naneconitsipajë. Apo yapëtaenë cajena bajaraponë, jai Pedro. Itsa baja Pedro najumevereta bajarapacuenia pejumaitsijava, vacara fiaba. ");
INSERT INTO guh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nexata bajarajota Pedro najamatabënapitajaraba Pedrojavabelia Jesús pejumaitsijava mapacueniaje: “Ajena rabaja, pameravi, vacara pefiabivajënaeya, nayavajunuaxainaename tajajivitonëcuenemë. ‘Xanë cajena apo yapëtaenë bajaraponë,’ jamë tsane xanë yabara acueyabi xuabeje,” pejaijava Jesús Pedrojavabelia, Pedro najamatabënapitajaraba. Nexata baja Pedro pitsapalia bo matatoyorotsia peyacaranatsijava pënëyabelia. Pinijicuenia Pedro nua. ");
INSERT INTO guh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ajena baja matacabi tsarucaponae, sacerdotevi penamatacaitorobivi, judíovi pijaancianovi yajava, najamatabëjëpa pacuenia exanaejitsia Jesús pebeyaxuabiaexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nexata Jesús cobecëtsiaya caponaliatsi nacuaevetsinë Poncio Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas canajetaxuabatsi Jesús pijavajabitsaë pecobeyabelia. Bajaraponë itsa tane Jesús penaneconitsijava pebeyaxuabinexatsi, nexata bitso najamatabëxaina. Nexata pona petocanaviatsinexa perajutsipalatamitsi, treinta ponëbeje pepo palatanëanë, bitso penamatamotsinëanë. Tocanaviatsijitsia sacerdotevi penamatacaitorobivijavabelia, judíovi pijaancianovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas jumaitsi bajarapamonaejavabelia: —Pibisiacuene baja rovia exanajë. Bajaraponë itsacuenejavayo ata apo exanaenejeva, panecobeyabelia baja canajetaxuabajë, jai Judas. Nexata bajarapamonae jumaitsi Judasjavabelia: —¡Paxanë raja patajamatabëcueneta apo naneconitsimë tsane! ¡Xamë raja nijacuata naneconitame! jai bajarapamonae Judasjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nexata Judas templobota othotajarabeta perajutsipalatanëanëmitsi. Bajaraxuacujinae pitsapalia. Pona baja. Nexata pijacuata nabeyaxuaba. Pepuanavësicëtsi athëbëvetsica perucaemaëtoxanetota, athëbëvetsica jirevica irabetsica penacuibosi catarërëtajarabaxuabinexa. Bajarapacuenia pijacuata Judas nabeyaxuaba. ");
INSERT INTO guh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nexata sacerdotevi penamatacaitorobivi caetuata Judas piothotajarabetsipalatanëanë. Najumaitsi bajarapamonae: —Acuenebi mapapalataje vajabuatsinexa ofrenda vajajebabiabicajónita. Tsipaji bajarapapalata pejamatabëcueneta jivitonë beyaxuabijitsiatsi, najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nexata bajarapamonae najamatabëjëpa bajarapapalatanëanëta pecomuatsinexa ira. Nexata bajarapamonae bajarapapalatanëanëta comuata canalitonë pefaratabiabinë pijairami. Bajarapamonae comuata bajarapaira, itsanacuaverena pepatsivi itsa tëpa Jerusalén tomarata, bajarapairata pemëthëtabiabinexa. ");
INSERT INTO guh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bajaraxuata mapamatacabijavaberena ataje vënëruba bajarapaira mapejumaitsivënëje: “Papalata pejamatabëcueneta jivitonë beyaxuabatsi, bajarapapalatata pecomuatsiira,” pejaivënë vënëruba. ");
INSERT INTO guh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bajarapacuenia itsa comuata bajarapaira, copiapata jane baja pacuenia Diosojumepaebinëmi profeta Jeremíaspijinë bajayata tajëvelia vajunupaeba bajarapapalata. Profeta Jeremíaspijinë baja cajena bajarapapalata yabara tajëvelia jumaitsi mapacueniaje: “Israelnacua pevetsivi rajutsiana jivitonë pecanajetsinëjavabelia treinta ponëbeje, pepo platananitota pexanaenëanë. Bajarapapalatanëanë icatsia bajarapamonae pitsiana. ");
INSERT INTO guh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nexata bajarapapalatanëanëta bajarapamonae comuatsiana canalitonë pefaratabiabinë pijairami, pacuenia Dioso tajëvelia nejumaitsi,” jai bajayata profeta Jeremíaspijinë tajëvelia pevajunupaebijavata Jesús pematamopitsipalatanexatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús nutatsi nacuaevetsinë Pilato pitabarata. Nexata Pilato jumaitsi Jesúsjavabelia: —¿Xamë tsaja judíovi pepo nevetsinë? jai Pilato. Nexata Jesús jumaitsi Pilatojavabelia: —Jãjã, xanë rabaja pacuenia nejumaitsimë, jai Jesús Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdotevi penamatacaitorobivi, judíovi pijaancianovi yajava, Jesús neconitaponae atatsi, apo jumepitsi. ");
INSERT INTO guh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nexata Pilato jumaitsi Jesúsjavabelia: —¿Apo jumetaemë tsaja pacuenia mapamonae caneconitaponaje? jai. ");
INSERT INTO guh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús neconitsi atatsi, itsiata apo jumepitsi. Bajaraxuata Pilato jamatabëcuenenabenajaca. Apo yapëtae pacuenia Pilato exanaejitsia Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nacuaevetsinë Pilato xaina pijacujirucuene. Caevai canacujitsia, pascua fiestamatacabi, Pilato copatabiaba caenë penaneconitsinë pepitsapaenexa penaneconitsivi pejebabiabibovecua. Pajivi yabara jivi vajëtabiaba Pilatojavabelia, bajarapajivi Pilato copatabiaba pascua fiestamatacabi. Bajarapacuenia Pilato caenë copatabiaba jivi pesivajamatabëcuene xanepanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pamatacabi Jesús naneconitsiaexanatsi, bajarapamatacabi penaneconitsivi pejebabiabibota naneconitsiaponapona jivibenë, Barrabásvënënë. Bajaraponë bitso piacujirubejenëcuene yapëtanetsi daxitajivi. ");
INSERT INTO guh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nexata daxita Jerusalén tomarapijivi penacaetuatsijavata Pilato jumaitsi: —¿Detsa ponë pajitsipame patacatocapitsapaenexa penaneconitsivi pejebabiabibovecua pepitsapaenexa? ¿Barrabás tsaja? Itsa jume, ¿Jesús tsaja, ponë yabara jivi jumaitsi: “Cristo raja athëbëvetsica Dioso pitorobinëtsitsica jivi pecapanepaenexa,” jaitsi? jai Pilato bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato jamatabëjumaitsi: —Xua Jesús exanaponapona, sacerdotevi penamatacaitorobivi cueneitoyatsi. Bajaraxuata netocaparena, jamatabëjai. ");
INSERT INTO guh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato abaxë eca itsajota ecabiaba penaneconitsivi penaneconitsiaexanaenexa. Nexata Pilato pijava tonajumeitorobarenatsi. Pilato pijava Jesús yabara jumaitsirena mapacueniaje: “Copare bajaraponë, ponë itsacueneneconiyo ata apo penaneconitsinë. Ajena raja, meravi, amajitsinaebejenë bajaraponë yabara,” jaitsirena Pilato pijava. Nexata picani Pilato jamatabëcopata Jesús. ");
INSERT INTO guh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Itsiata baitsi jane bajarapaepatota sacerdotevi penamatacaitorobivi, judíovi pijaancianovi yajava, jivijavabelia muxubijiapenetsia jumai tsaponae: —Pavajëtsianame Barrabás pecapitsapaenexatsi. Pavajëtsianame Jesús pebeyaxuabinexatsi, jai tsaponae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nexata nacuaevetsinë Pilato icatsia yanijoba jivijavabelia: —¿Detsa ponë nexata pajitsipame patacatocapitsapaenexa? jai Pilato. Nexata bajarapamonae jumaitsi: —Panetocapitsapare Barrabás, jai. ");
INSERT INTO guh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato nexata jumaitsi bajarapamonaejavabelia: —¿Detsa nexata xua exanaenajë Jesúsjavabelia, ponë yabara: “Cristo, ponë Dioso athëbëvetsica itorobatsi jivi pecapanepaenexa,” jaitsi? jai Pilato bajarapamonaejavabelia. Nexata daxita bajarapamonae jumaitsi Pilatojavabelia: —¡Cruzajavabelia cobematabiabarutsiaexanare! jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nexata Pilato jumaitsi bajarapamonaejavabelia: —¿Detsa pitsineconi yabara cobematabiabarutsiaexanaejitsipajë cruzajavabelia? jai Pilato Jesús yabara. Itsiata bajarapamonae icatsia pinijijumeta vavajai. —¡Cruzajavabelia cobematabiabarutsiaexanare! jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato tane piajumesaëjava bajarapamonae. Muxujiobi ata, apo jumecovënëtsitsi. Bitsoyo biji caranata bajarapamonae jamatabënanaecajematapona bajarapatomarata. Nexata Pilato penacobequiatsinexa, pijajivi itoroba petocarenanexatsi mera. Pilato nacobequiata daxitajivi pitabarata bajarapamonae peyapëtaenexa Jesús apo penaneconitsiaexanaecuene. Pilato jumaitsi bajarapamonaejavabelia: —Xanë raja tajamatabëcueneta apo beyaxuabiaexanaenë tsane maponëje, pianeconijibinë. Paxamë panejamatabëcueneta pabeyaxuabiaexanaename, jai Pilato. ");
INSERT INTO guh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nexata daxita bajarapamonae jumaitsi: —¡Itsa bajaraponë pianeconijibinë Diosojavabelia, nexata bajaraponë patabeyaxuabineconi jema panetsijumajopaena, pataxi yajava! jai bajarapamonae Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nexata baja Pilato tocopata Barrabás pepitsapaenexa penaneconitsivi pejebabiabibovecua. Itorobanua vajabitsaëvi ayaicuenia Jesús pejumatitibabenexatsi penaneconitsivi pejumaconitabiabimacata. Bajaraxuacujinae Pilato tocopata baja Jesús vajabitsaëvi pecobematabiabarutsinexatsi cruzajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nexata baja Pilato pijajivi, vajabitsaëvi, Jesús caponaliatsi nacuaevetsinë Pilato pijaboxanetojavabelia. Nexata bajarajota Jesús matatoyorotsia nacaetuatatsi daxita vajabitsaëvi. ");
INSERT INTO guh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesús penaxatatsijava vajabitsaëvi vejumajonotatsi saicayajava pexatatsinexatsi. Nexata jane baja vajabitsaëvi Jesús quenetsiataeya xatatatsi petsobiajava benacuaevetsinëcuenia petaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Becoronacuenia pemataxatatsinexatsi, peejuvitoyoroto tsimataexanatsi. Bajarapatoyoroto Jesús mataxatatatsi. Tsicoberutatsinua naebo pecujuanenia benacuaevetsinëcuenia petaenexatsi. Nexata bepeyaiyataecueniatsi bajarapamonae pematabacabëta tonubenatsi Jesús pitabarata. Quenetsiataeya jumai tsaponaetsi: —¡Bajaco, judíovi pepo pevetsinë! jai tsaponaetsi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Suabaponatsi. Vecuapitatsi naebo. Bajarapanaebota mataconitajarababiabatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bajarapacuenia quenetsiataeya pecapocaponaecujinaetsi, vejumajonotatsi baja pexatatsijavatsi. Jesús baja icatsia xatatatsi penaxatatsijava. Caponaliatsi jane baja pecobematabiabarutsinexatsi cruzajavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vajabitsaëvi Jesús itsa caponaliatsi tomaravecua, namutota caxitajaraba Simónvënënë, Cirene tomarapijinë. Nexata vajabitsaëvi Simón itorobatsi, pacruzajavabelia Jesús cobematabiabarutsijitsiatsi, peyavenonaeyacaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jesús caponaliatsi Gólgotavënë tsutojavabelia, bajarapatsutojumata pecobematabiabarutsinexatsi cruzajavabelia. “Gólgota,” itsa jai hebreojumeta, mapajumetaje pejumaitsijume: “Jivimatasipatsuto,” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bajarajota picani Jesús rajutatsi vinora, pematajërëabira piatsaxarata. Jesús picani rajutatsi bitso penavixaetaeyaniva pecobematabiabarutsijavatatsi cruzajavabelia. Jesús pajane bajarapora. Itsiata apo apae. ");
INSERT INTO guh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nexata jane baja Jesús vajabitsaëvi cobematabiabarutatsi cruzajavabelia. Bajaraxuacujinae vajabitsaëvi bajarajota canamuxusita beibotoxi. Bajarapacuenia canamuxusita peyapëtaenexa ponë pitaponaejitsia caejava canacujitsia Jesús penaxatatsijavami, xua jumaponapona. Bajarapacuenia vajabitsaëvi natsicobetsana Jesús penaxatatsijavami. Bajarapacuenia vajabitsaë itsa natsicobetsana Jesús penaxatatsijavami, tocopiapatatsi jane baja pacuenia Diosojumepaebinëmi profetanë bajayata tajëvelia vajunupaeba Jesús penaxatatsijava. Jesús penaxatatsijava yabara, profetanëmi bajayata tajëvelia jumaitsi mapacueniaje: “Natsicobetsanaena penaxatatsijava. Canamuxusitsiana beibotoxi peyapëtaenexa ponë pitaponaejitsia,” jai profetanëmi. ");
INSERT INTO guh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bajaraxuacujinae vajabitsaëvi bajarajota evetena penaitaxutocaevetsinexatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bajarajota Jesús pematabocoto matatsënëyo cruzajavata, yaquinaruta tablapayota itsamonae ata peyapëtaenexa pajamatabëcuene yabara naneconitsiaexanatsi Jesús. Jumai tsarutsi peyaquinaeitane cruzajavata mapacueniaje: “Mara ponë Jesúsje, judíovi pepo pevetsinë,” jai tsarutsi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Anijanëbeje penacobetoxotsinëbeje Jesús yajavacobematabiabarutatsi. Caenë canacujitsia pijacruzata rubatsi. Bajaraponëbeje Jesús pemuxuneneta rutatsibeje. Itsanë Jesús pecujuanenia rutatsi. Itsanë Jesús petsavenonenia rutatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jesús pecobematabiabarutsijavatatsi cruzajavabelia, bajaraxuayo penajetarubenaevi Jesús itaropitsiaya bijataeyabiabatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jumai tsabiabi bajarapamonae: —Xamë raja imata jumaitsimë: “Xuabianicajë templobo. Acueyabi matacabita icatsia veretetsianajë itsabo,” jamë. Nacapanepare jane baja nijacuata. Itsa xaniajai Dioso pexënatomë, nexata cruzajavavetsica runaimica, jai tsabiabi Jesúsjavabelia bajaraxuayo penajetarubenaevi. ");
INSERT INTO guh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bajara pijinia pacuenia sacerdotevi penamatacaitorobivi capocaponatsi Jesús. Judíovi pecujarubivi ata capocaponatsi. Fariseovi ata capocaponatsi. Judíovi pijaancianovi ata capocaponatsi Jesús. Ëpamonae najumaitsi: ");
INSERT INTO guh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Maponëje itsamonae yabara jumai tsabiabi: “Capanepaenajë jivi,” jai tsabiabi. Caranata pijacuata penacapanepaenexa apo caëjëpaetsi. Itsa xaniajai Israel nacuapijivi pepo pevetsinë, nexata aeconoxae cruzajavavetsica runaenica vajataenexa. Nexata jane baja jumecovënëtsianatsi Cristonëcuene. ");
INSERT INTO guh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bajaraponë pina najamatabëcuenecopata Diosojavabelia peyavenonaenexatsi. “Xanë raja Dioso pexënatonë,” jai tsabiabinua. Nexata taenatsi aeconoxae Dioso pecapanepaejavatsi, najai bajarapamonae capocaponaeya Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ponëbeje penacobetoxotsinëbeje Jesús yajavacobematabiabarutatsi, bajaraponëbeje ata Jesús bijataerucatsibeje bajarapacuenia. ");
INSERT INTO guh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesús baja itsa tëpaejitsia, ajena matonejejitsia, daxita nacuanëjava aitaquiri tsajuni. Matapania caniviyojavabelia, bejamatabëcuene a las tres, nacua napebeta icatsia. ");
INSERT INTO guh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nexata paepatota icatsia nacua napebeta, bajarapaepatota pinijicuenia Jesús aëjai. Jumaitsi: —Eli, Eli, ¿lama sabactani? jai Jesús. Bajarapacuenia Jesús itsa jumaitsi pijajumeta, mapajumetaje pejumaitsijume: “TajaDioso, tajaDioso, ¿detsa xuajitsia baja tajaepato necopatame?” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nexata itsamonae bajarajota penubenaevi bijiaya jumetane bajarapacuenia Jesús pejumaitsijava. Nexata saya jamatabëcuenenavëxaniabiaya jumaitsi bajarapamonae: —Mara ponë junata profeta Elíaspijinëmi, Diosojumepaebinëmi, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nexata bajarapamonaeyajuvënënë bepijia cujinaelia pecarenanexa esponjavënëjava. Nexata esponjavënëjava jabutaba piajatuvinorayalia. Bajaraxuacujinae esponjavënëjava naeboupita cëtaruta. Toyotsiatsi Jesús petsutsuninexa picani bajaraxua. ");
INSERT INTO guh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Itsiata itsamonae jumaitsi: —Copare abaxë. Taenatsi Elíaspijinë itsa najetaruca pecapanepaenexatsi, jai bajarapamonae capocaponaeya. ");
INSERT INTO guh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Icatsia Jesús pinijicuenia aëjai. Bajaraxuacujinae jane baja Jesús tëpanajereca. ");
INSERT INTO guh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Paepatota Jesús tëpanajereca, bajarapaepatota templobo ënëtuatuajëalia peyatuucutarutsipana, ayaipapaëbërëpanaxaneto, titititica tuatuajëareca, athëbëvetsicacujinae irabereca. Ira najëaba. Ibotoxanetonë ata sarapajunujunua. ");
INSERT INTO guh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Ayaibitsaëto Dioso pepua pejumecovënëtsivi petëpaevimi pemëthëanë ata napananubena. Nexata Jesús acueyabi matacabita icatsia itsa asaë petëpaecujinae, pamonae pemëthëanë napananubena, bajarapamonae ata cotocaevi asaë. Nexata pitsapa mëthëvetsina. Nexata bajarapamonae pona Jerusalén tomarabelia. Bajarajotalia naitajëbapona jivi ayaibitsaëtojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús cruzata petëpaejavata vajabitsaëvi pijacapitán, pijajivi yajava, nuca. Taenubena Jesús petëpaejava. Jesús petëpaejavata ira najëaba. Nexata bajarapamonae itsa tane ira penajëabijava, itsajavanë ata itsa taepona, bajarapamonae bitso junava. Jumaitsi: —Matsaena ponë tëpaje, pepacuene baja rovia Dioso pexënato, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bajarajota petiriavibitsaëtoxaneto tajiyoverena taenubena Jesús petëpaejava. Bajarapapetiriavi Jesús pepëta napona Galilea nacuaverena, Jesús peyavenonaevimitsi. ");
INSERT INTO guh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bajara papetiriavibitsaëtoxaneto tuatuajëta nanubena mapamatabëxëyoje. Itsava Maríavënëva, Magdala tomarapijiva. Itsava icatsia Maríavënëva. Bajarapova Santiagobeje Josébeje pena. Itsava pijinia Salomévënëva. Bajarapova pijinia Santiagobeje Juanbeje pena. Bajarapova Salomévënëva, Zebedeo pijava. ");
INSERT INTO guh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Itsa baja caniviyotsia, José, Arimatea tomarapijinë, pona nacuaevetsinë Pilatojavabelia. Bajaraponë José bitso pexainaenë pexainaejava. José jumecovënëtaponapona Jesús Cristocuene. ");
INSERT INTO guh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nexata José itsa pata nacuaevetsinë Pilatojavabelia, vajëta petocopatsinexatsi pemëthëtsinexa Jesús petëpaenë. Nexata Pilato itoroba pijajivi petocopatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nexata José cruzajavavetsica pitsica Jesús petëpaenë. Mataquionaeya daxitanëreca matacacëba pexaniaviria piapiasábanapanata, piaxuirajibipanata. ");
INSERT INTO guh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bajaraponë José, pamatacabi tëpa pemëthëtsinexatsi picani, iboitapajanitojavata pinijiibovaju toexanabuatatsi cajena. Nexata bajarapaibovajulia José buata Jesús petëpaenë. Nexata bajaraxuacujinae pinijiibopanaxaneto José tixirena. Yavajuvëpaacatabuata. Nexata baja José naviata pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bajarajota ibovaju itapajavata eecabeje anijavabeje ëMaríavënëvabeje. Itsava María, Magdala tomarapijiva. ");
INSERT INTO guh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pascuafiesta pejonematacabinexa pevajënaeya pamatacabi, judíovi baja banacuenevereta penacuenebijava. Nexata baja pamatacabi judíovi banacuenevereta penacuenebijava, bitso baja itsa caniviyotsia, sacerdotevi penamatacaitorobivi, fariseovi ata, ponalia Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nexata bajarapamonae jumaitsi Pilatojavabelia Jesús yabara: —Pamatacabi abaxë bajaraponë asaë tsaponaponae bitso najumetsënëtabiaba. Jumai tsabiabi: “Tatëpaecujinae, acueyabi matacabita, icatsia asaënë tsane,” jai tsabiabi. Bajarapejumaitsijava paxanë apo panacofënëtsinë. ");
INSERT INTO guh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nexata nijajivi itorobare bajaraponë pemëthë xaniavaetsia pevetsinexa. Nexata nijajivi bajaraponë pemëthë xaniavaetsia evetsiana acueyabi matacabijavabelia, bajaraponë pecapaebimatacabijavabelia. Nexata acuenebi tsane pijajivi meravi pejutsinexatsi mëthëvecua. “Namatacota rabaja Jesús,” pejaijava ata jivijavabelia, acuenebi tsane. Itsa bajarapacuenia pijajivi jumai tsipae, nexata najumetsënëtsipa copiaya Jesús penajumetsënëtsijava matatoxenetsia. Nexata bajarapacuenia yamaxëitorobijitsipa jivi ayaibitsaëtoxaneto, jai bajarapamonae Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato nexata jumaitsi bajarapamonaejavabelia: —Mapamonae tajajivi, vajabitsaëvije, payajavaponare. Nexata paitorobare bajarapamonae Jesús pemëthë pevetsinexa xaniavaetsia, jai. ");
INSERT INTO guh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nexata bajarapamonae vajabitsaevi barëponalia Jesús pemëthëjavabelia. Bajarapamonae pemaëtoupi catsataruta Jesús pebuatsiibovajutsi pevëpaacatsiibopanajumata. Itsaupi pijinia catsata iboitapajanitojavabelia. Bajarapacuenia exana peyapëtaenexa petixitsijava muetsia Jesús peyavajuvëpa acatabuatsiibopanatsi. Bajaraxuacujinae itoroba vajabitsaëvi Jesús pemëthëvëpa pevetavanapaenexa. ");
INSERT INTO guh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judíovi baja penacueraevetsimatacabi itsa verevereca, meravia pitsijavata, bajayacunua, ajena matacabi tsarucaponae, María, Magdala tomarapijiva, itsaMaría yajava, taeyojopaliabeje Jesús pebuatsiibovajutsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jemata ira najëaba. Tsipaji Dioso pijaángel runaica athëbëvetsica. Angel itsa pata Jesús pebuatsiibovajutsijavata, tixita Jesús peyavajuvëpa acatsiibopanaxanetomi. Bajaraxuacujinae ángel eca bajarapaibopanajumata. ");
INSERT INTO guh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bajaraponë ángel naitayota. Pacuenia yamaxëcotia itsi, bajara cotiaitsi ángel. Penaxatatsijava niojai daxita peniojaijava matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vajabitsaë, pamonae evetanubena Jesús pebuatsiibovajutsivëpa, itsa tane ángel, neconecojai pecajunavi. Bobenajunua bepetëpaevi. ");
INSERT INTO guh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nexata ángel jumaitsi petirivabejejavabelia: —Pëtsa pajunavamebeje. Yapëtaniji xua yabara paponamebeje. Jesús pecobematabiabarutsinëmitsi cruzajavabelia, pajaitamebeje. ");
INSERT INTO guh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ajibi raja tsarucae majotaje. Asaë rabaja icatsia pacuenia baja cajena tajëvelia jumaitsi. Parenamërebeje panetaenexabeje itsajota picani buatatsi. ");
INSERT INTO guh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bajaraxuacujinae paliamëbeje tsane bepijia. Pijajivijavabelia patsipaebianamebeje mapacueniaje: “Petëpaenëmi rabaja icatsia asaë. Panevajënaeyabelia pina pona Galilea nacuayabelia. Baja pina jotalia pacaxitajarabianame,” pajamëbeje tsane pijajivijavabelia. Bajarapalivaisiyo xainajë patacatsipaebinexabeje, jai ángel bajarapovabejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nexata bajarapovabeje naviatabajiravabeje Jesús pebuatsiibovajutsivecua. Junavabeje picani. Itsiata barëyabeje bitso. Cujinaetabajiravabeje petsipaebinexabeje Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bajarapovabeje namutualia pecujinaejinaenajetarucaejavatabeje, Jesús jemata tsitanaitajëtatsibeje. Nexata bajarapovabeje cujitabaliabeje Jesúsjavabelia. Bajacobatsibeje. Nexata pematabacabëta nucajunuabeje. Sitaicaliabeje yaiyataeya Jesús pecopiapitsinexabeje bajarapacuenia. ");
INSERT INTO guh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús nexata jumaitsi bajarapovabejejavabelia: —Pëtsa pajunavamebeje. Paliamërebeje tajajivijavabelia. Pajumaitsimëbeje tsane tajajivijavabelia: “Jesús raja jumaitsi. Paponaeremelia pina Galilea nacuayabelia. Baja pina jotalia pacacaxitajarabiana Jesús,” pajamëbeje tsane tajajivijavabelia, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Paepatota ëMaríavënëvabeje naviatabeje Jesús pebuatsiibovajutsijavavelia, vajabitsaëvi, Jesús pemëthë pevetsiviyajuvënëvi, pona tomarabelia. Bajarapamonae tsipaeba sacerdotevi penamatacaitorobivijavabelia pacuenia tane bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nexata sacerdotevi penamatacaitorobivi pona judíovi pijaancianovijavabelia penabarëcuaicuaijainexa penajamatabëjëpaenexa pacuenia exanaejitsia. Nexata jane baja bajarapamonae najamatabëcuenejëpa. Nexata bajarapamonae rajuta ayaijava palata vajabitsaëvijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bajarapamonae jumaitsi vajabitsaëvijavabelia: —Jivijavabelia pajumaitsimë tsane: “Meravi pataitamajitsita, Jesús pijajivi pata. Nexata bajarapamonae juta Jesús petëpaenë,” pajamë tsane. ");
INSERT INTO guh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nexata nacuaevetsinë Pilato itsa jumetaena mapajumeje, paxanë itsiata pacayavenonaenatsi itsacuene papecaexanaeyaniva, jai bajarapamonae vajabitsaëvijavabelia. ");
INSERT INTO guh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nexata vajabitsaëvi jejai. Nota bajarapapalata. Nexata jane baja vajabitsaëvi pona najumetsënëtsiaya jivijavabelia pejumaitsinexa pacuenia itorobatsi. Nexata vajabitsaëvi najumetsënëtsiaya jumai tsaponae jivijavabelia: —Meravi pataitamajitsita, Jesús pijajivi pata. Nexata Jesús pijajivi petëpaenë jutatsi, jai tsaponae jivijavabelia. Bajarapacuenia vajabitsaevi pepaebixae, judíovi juya bajarapacuenia natsipaebapona. Nexata mapamatacabijavaberena ataje judíovi jumai tsabiabi: —Jesús pijajivi petëpaenë jutatsi, jai tsabiabi. ");
INSERT INTO guh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesús pijajivi once ponëbeje pona Galilea nacuayabelia. Jesús pijajivi pona petsutojumabelia, patsutojumatalia Jesús caxitajarabiapaebatsi. ");
INSERT INTO guh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nexata bajarapatsutojumata Jesús pijajivi itsa taenuta Jesús, yaiyataeya pitabarata pematabacabëta tonubena. Itsiata itsamonae Jesús pijajiviyajuvënëvi jamatabëcuenenavëxaniabiaya jamatabëjumaitsi: —Apo Jesús meta, jamatabëjai. ");
INSERT INTO guh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nexata Jesús pijajivi cujirena. Jumaitsi pijajivijavabelia: —Dioso baja cajena nevetsiaexana daxitacuene athëbëtatsia, daxita mapanacuajava ataje, taevetsinexa. ");
INSERT INTO guh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nexata pacaitorobatsi. Paponare daxitanacuanëjava daxitanacuanëpijivi tajumelivaisi patanetotsipaebinexamë tanejumecovënëtsinexa. Bajarapamonae pabautisabaponaename taxa pevënëta, xanë ata pexënatonë tavënëta, Espíritu Santo ata pevënëta. ");
INSERT INTO guh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bajarapamonae patsipaebaponaename pejumecovënëtavanapaenexa daxita pacuenia pacaitorobatsi. Pëtsa panacofënëtame daxitamatacabi patacayajavaponaponaejava. Nacua pevereverecaejavabelianexa ata pacayajavaponaponaenatsi, jai Jesús pijajivijavabelia.");
INSERT INTO guh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mara pacuenia taxuxuaba pexanialivaisi, Jesucristo Dioso pexënato pelivaisije. ");
INSERT INTO guh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bajayata Diosojumepaebinëmi, profeta Isaíaspijinë, tajëvelia yaquina Dioso pejumaitsijava pexënatojavabelia. Dioso jumaitsi pexënatojavabelia mapacueniaje: Itorobianajë nevajënaeyabelia tanejumelivaisipaebinënexa. Catsivajënaexanebijitsia nijanamuto. ");
INSERT INTO guh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nexata tanejumelivaisipaebinë vavajai tsane petusato nacuata. Jumaitsi tsane jivijavabelia: “Jivi baxaneba panamutoverena najetarucaejitsia petuxanenë. Batoroviaexananua namuto. Bajara pijinia pacuenia paxamë ata panajamatabëcuenexaniavaere pepo petuxanenë pepatsivajënaeya paxamëjavaberena,” jai tsane tanejumelivaisipaebinë xamë yabara, jai bajayata tajëvelia Dioso pexënatojavabelia pejumaitsijava Juan jivibautisabinë jivijavabelia Dioso pejumelivaisi petsipaebanajetarucaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bajaraxuata nexata Juan jivibautisabinë Dioso pejumelivaisipaebinë najetaruca petusato nacuajava Jesús pevajënaeya. Juan jivijavabelia jumai tsaponae mapacueniaje: —Pacopabare pibisiacuene paneexanabiabijava. Panajamatabëcuenepënëyorore Diosojavabelia. Bajaraxuacujinae pacabautisabianatsi. Nexata Dioso pacavecuaajibiaexanaena panijaneconimi, jai tsaponae Juan jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nexata ayaibitsaëtoxaneto Judea nacuapijivi, Jerusalén tomarapijivinua, muxunaponabiabatsi Juan petsipaebilivaisi penamuxunaevetabiabinexatsi. Nexata bajarapamonae pibisiacuene pexanaejavami, rovialia Diosojavabelia navecuapaebapona. Bajaraxuacujinae Juan bautisabapona bajarapamonae Jordán meneta. ");
INSERT INTO guh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan naxatata camellonata pexanaejava. Naepacëta cuerobocoto. Pexaejava ëbosese, jabëra yajava. ");
INSERT INTO guh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan Jesús pelivaisi jivi tsipaebapona. Jumai tsaponae tajëvelia Jesús yabara: —Tacovëverena patsiana itsanë. Bajaraponë daxitacuene pexanaenexa pecaëjëpaenëtsi tsane. Xanë raja saya beveliajamatabëcuenenënë bajaraponëvecua. Nexata vecuaauranë bajaraponë bepijajivitonënë tanataenexa. Nexata auranë pijazapato ata tataxujonotsinexa. ");
INSERT INTO guh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Xanë raja saya pacabautisabatsi merata. Ponë rajane xanëcujinae patsiana, bajaraponë pacatsijamatabëjoneyaexanaponaena Espíritu Santo, jai tsaponae Juan jivijavabelia Jesús yabara tajëvelia pevajunupaebijavata Jesús penajetarucaejavanexa. ");
INSERT INTO guh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesús najetaruca Nazaret tomaraverena, Galilea nacuata peecaetomaraverena. Nexata Juan bautisaba Jesús Jordán meneta. ");
INSERT INTO guh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús pebautisabicujinaetsi menevetsina penonotajunaejavata, tane itaboxo penapatsijava. Bajarajota Jesús tane Espíritu Santo ata perunaejavatsica pematatsënëatsica beucucuto. ");
INSERT INTO guh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jesús jumetanenua athëbëvetsica Dioso pejumaitsijavatsi: “Xamë raja taxënatomë, bitso tacaasivanë. Bitso casivajamatabëcuenebarëyatsi,” pejaijavatsi. ");
INSERT INTO guh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesús Juan pebautisabicujinaetsi, bepijiayo Espíritu Santo ponaeyaexanatsi petusato nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Bajarajotalia daxitacueneviria unupijivi jinavanapa. Nexata bajarajota Jesús ponapona, caenë, cuarenta pamatacabibeje. Bajarapamatacabianëta dovathi picani Jesús jamatabëcueneëjëbatsi pibisiacuene pexanaenexa. Bajaraxuacujinae ángelevi runaica Jesús peyavenonaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan penaneconitsiaexanaenexatsi vajabitsaë vaetabatsi. Nexata penaneconitsivi pejebabiabibota Juan naneconitsiaponapona. Nexata abaxë Juan penaneconitsivi pejebabiabibota itsa ponapona, Jesús najetaruca Galilea nacuajavaberena. Jesús jivi tsipaebaponarena pexanialivaisi. Tsipaebaponarena daxita Dioso pijajivi pevetsijavanexa. ");
INSERT INTO guh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús jumai tsaponae jivijavabelia mapacueniaje: —Imoxoyo rabaja pevajënae pecopiapatsinexa Dioso papecaevetsimatacabinexa. Nexata pacopabare pibisiacuene paneexanabiabijava. Panajamatabëcuenepënëyorore Diosojavabelia. Pajumecovënëre mapapexanialivaisije papecacapanepaelivaisinexa, jai tsaponae Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús najetaruca Galilea pucaxaneto itapaya. Nexata Galileapuca itapata Jesús taenuta anijanëbeje nacaebananëbeje, Simónbeje Andrésbeje. Bajaraponëbeje daxitamatacabi canacujitsia dujuai yamatajucabiababeje. ");
INSERT INTO guh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nexata Jesús jumaitsi bajaraponëbejejavabelia: —Naxanitsia. Panepënaponarebeje. Nexata pacacujarubianatsibeje jivi panejucaenexabeje. Pacuenia dujuai payamatajucabiabamebeje, bajarapacuenia jivi pajucaenamebeje Dioso pijajivinexa, jai Jesús bajaraponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nexata bajaraponëbeje dujuai peyamatajucabiabijavamibeje bajarajota puenetabuatabeje. Nexata baja naponabeje Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nexata icatsia bebeliayo pevajënaeyabelia Jesús barëpona. Icatsia Jesús taenuta anijanëbeje Santiagobeje Juanbeje, Zebedeo pexënatobeje. Bajaraponëbeje pijajeraënëta xanebanucabeje dujuai peyamatajucaejavabeje. ");
INSERT INTO guh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nexata icatsia Jesús junata bajaraponëbeje ata. Nexata bajaraponëbeje bajarajota jerata puenetanutabeje paxa Zebedeo jane baja. Nexata Zebedeo, pijajivi yajava, nacopatanuca bajarajota. Nexata baja Santiagobeje Juanbeje naponabeje Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nexata Jesús, pijajivi yajava, pata Capernaum tomarabelia. Judíovi penacueraevetsimatacabita Jesús joneya judíovi penacaetuatabiabiboyalia. Nexata bajarajota Jesús jivi livaisi tsipaeba. ");
INSERT INTO guh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nexata Jesús pejumetaevitsi jamatabëcuenenabenajaca Jesús petsipaebilivaisi yabara. Bajarapamonae jamatabëcuenenabenajaca tsipaji xaniavaetsia Jesús tsipaeba Dioso pitorobinëtsicuenia. Apo tsipaebi pacuenia judíovi pecujarubivi tsipaebabiaba. ");
INSERT INTO guh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bajarajota pebi dovathi peyajavaponaponaenë naeca. Nexata bajaraponë Jesúsjavabelia vavajai tsaxuabi. Jumaitsi: ");
INSERT INTO guh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Jesús, Nazaret tomarapijinëmë, panevecuaponare baja! ¿Detsa xua paneexanaejitsiamë? ¿Najetarucame tsaja pataneveretsinexamë? Xanë cajena cayapëtanetsi. Xamë raja Dioso pexënatomë, pepo pexaniajamatabëcuenenëmë, jai dovathi peyajavaponaponaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús nexata jumeitaveta dovathi. Jumaitsi: —¡Moyamëre! ¡Vecuapitsapare baja maponëje! jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nexata dovathi pebi pinijicuenia devacaibiaexanatsi. Dovathi vavajai pinijicuenia. Nexata baja dovathi pitsatabijirava jivitonëvecua. ");
INSERT INTO guh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nexata daxitajivi bajarapacuene itsa tane, bitso jamatabëcuenenabenajaca. Najumaitsi bajarapamonae: —¿Detsa mapitsicueneje? ¿Detsa mapitsipejanacujarubicueneje? ¡Maponëje Jesús, beDioso pitorobinëtsitsica! ¡Dovathi ata jumecovënëtatsi! ¡Nexata Jesús pitavetsixae dovathi, pebi baja vecuapitsapatsi! najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nexata daxita Galilea nacuapijivi bepijia Jesús vënëlivaisitanetsi Dioso pesaëta pinijicuene pexanaponaejava. ");
INSERT INTO guh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús baja pitsapa judíovi penacaetuatabiabibovecua. Nexata Santiagobeje Juanbeje Jesús yajavapona. Jesúsbana napona Simónbeje Andrésbeje pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nexata Simón pijabota Simón pijava pena Jesúsbana pevajënae romaebanucatsi camata. Nexata itsamonae bepijia Jesús tsipaebarëcëpatsi bajarapova peromaebanucaejavatsi. ");
INSERT INTO guh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nexata Jesús imoxoyotabalia peromaebanucaevatsi. Cobeyotsiaya matacota. Nexata bajarajota peromaebanucaevatsi vecuaajibi tsanajetsitsireca baja domae. Nexata bajarapova Jesúsbana pexaejava toexanatsi. ");
INSERT INTO guh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Itsa baja ajena meravitsia, Jesúsjavaberena tocapatatsi daxita piavitanevi. Tocapatatsinua dovathi peyajavajinavanapaevinua. ");
INSERT INTO guh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Daxita tomarapijivi Jesús pepatsibota baupajavaberena nacaetuata. ");
INSERT INTO guh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nexata Jesús jamatejemayaexana ayaibitsaëto daxitacuenevitane pexainaevimi. Vecuacapitsapanua dovathi peyajavajinavanapaevi. Jesús apo tocopatsi dovathi pecuaicuaijainexa jivijavabelia pevajunupaebiyanivatsi. Tsipaji dovathi xaniavaetsia Jesús yapëtanetsi Dioso pexënatocuene. ");
INSERT INTO guh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pepo bajayacunua, abaxë itsa apo napebetsi matacabi, Jesús naëcota. Nexata pitsapalia bovecua. Pesaicaeyojavabelia pona pevajëtsinexa Diosojavabelia. Jesús nexata pecovëta matacabi baja. ");
INSERT INTO guh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Itsa baja matacabi, Simónbana Jesús pëjaitaponalia. ");
INSERT INTO guh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Itsa baja bajarapamonae Jesús caxitajaraba, jumaitsi bajarapamonae: —Daxita raja cajaitaruta pecataenexa, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nexata Jesús jumaitsi: —Ponatsi baja imoxoyo penaetomaraxijavabelia bajarajotalia tatsipaebinexa Dioso pitorobilivaisi. Bajaraxuanexa bovecua pitsaparenajë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nexata daxita Galilea nacuajava Jesús jivi tsipaebapona Dioso pitorobilivaisi judíovi penacaetuatabiabibonëjava. Jesús jivi dovathi vecuacapitsapaponanua. ");
INSERT INTO guh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesús imoxoyorenatsi bajayajebi bitso peperabëtsabanaenë. Nexata bajaraponë pematabacabëta nucajunua Jesús pitabarata. Bajaraponë pinijicuenia vajëta Jesúsjavabelia. Jumaitsi: —Cacaëjëpa tanejamatejemayaexanaenexamë. Itsa jitsipame, nejamatejemayaexanare mapavitanevecuaje, jai peperabëtsabanaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nexata Jesús bajaraponë itaxutobejiobiatane. Pecobeta perabëjayalia. Jumaitsi: —Jãjã, jitsipajë cajena. Jamatejemamë rabaja, jai Jesús peperabëtsabanaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bajarapacuenia Jesús pejumaitsijavata peperabëtsabanaenëmi baja perabëxanepananajereca. Jamatejema baja. Peperabëtsabanaejavami baja ajibi. ");
INSERT INTO guh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nexata baja Jesús naviatsiaexana bajaraponë. Pinijicuenia Jesús muxujioba bajaraponë penaviatsivajënaeya. Jesús jumaitsi: ");
INSERT INTO guh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nejumetaema. Pëtsa itsajivijavabelia tsipaebame tacajamatejemayaexanaejava. Naitajëremelia jane sacerdotenëjavabelia templobota penacuenebinëjavabelia. Nexata sacerdotenë cataena pecavecuaajibijava baja niavitanejavami. Diosonexa rajuremelia ofrenda sacerdotenëjavabelia pecavecuaajibiaexanaexae niavitanejavami. Bajara tsipaji pacuenia bajayata vajasalinainëmi Moiséspijinë nacaitoroba. Nexata jivi yapëtaena pepacuene baja pecavecuaajibijava niavitanejavami, jai picani Jesús bajayajebi bitso peperabëtsabanaenëmijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nexata bajaraponë lia. Itsiata tsipaebanajetaruca daxitajivijavabelia Jesús pejamatejemayaexanaejavatsi. Bajaraxuata Jesús apo jitsipae naitajëtsiaya pejonejava itsatomarabelia ata, jivi ayaibitsaëtoxaneto pematatoyoronaeyanivatsi. Jesús saya ponapona tomaranë piajibijava. Itsiata cajena daxita nacuanëjavaverena jivi muxunapatabiabatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Itsamatacabi icatsia Jesús naviarena Capernaum tomaraberena. Nexata jivi yapëtane pabota Jesús patajopa. ");
INSERT INTO guh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nexata jivibitsaëtoxaneto nacaetuata Jesús pepatsibota. Bo baupa ata cajena bitso jivi vënëca. Nexata bajarapamonaejavabelia Jesús tsipaeba Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nexata cuatro ponëbeje parena, camayota peyavëtacaranajetarubenaevi petabusipacuenebinëtsi. ");
INSERT INTO guh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nexata petabusipacuenabinëtsi acuenebi bajarapamonae pecapatsijava Jesús pitabarayabelia. Tsipaji bo ënëtuatuajë bitso jivi yavënëca. Nexata petabusipacuenabinëtsi pecapatsivi, bomatatujavavetsica vojoexana Jesús pecanacujitsiatsica. Nexata bajarapavojotuatsica camayota yacopatsica petabusipacuenebinëtsi. ");
INSERT INTO guh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús jamatabëcueneyapëtane pacuenia bajarapamonae sivanajamatabëxainatsi. “Nacatojamatejemayaexanaenatsi cajena,” pesivajamatabëjaijavatsi Jesús jamatabëcueneyapëtane. Bajaraxuata petabusipacuenebinëtsijavabelia Jesús jumaitsi mapacueniaje: —Tajabananë, pibisiacuene rabaja nexanaeneconimi cavecuaajibiaexanatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bajarajota judíovi pecujarubiviyajuvënëvi naena. Bajarapamonae itsa jumetaeyena bajarapacuenia Jesús pejumaitsijava, nexata jamatabëcuenenavëxaniabiaya bëpënëa jamatabëjumai tsenae mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Maponëje Jesús Dioso apo pejitsipaecuenia cuaicuaijai. Itsanë ata cajena apo caëjëpaetsi itsajivi pibisiacuene pexanaeneconi pevecuaajibiaexanaenexa. Caenë Dioso caëjëpatsi pevecuaajibiaexanaenexa bajarapacuene, jamatabëjai tsenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús jamatabëcueneyapëtane bajarapamonae jamatabëcuenenavëxaniabiaya bajarapacuenia pesivanajamatabëxainaejavatsi. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Pëtsa bajarapacuenia panesivanajamatabëxainame. Tsipaji cajena xanë necaëjëpa jivi pibisiacuene pexanaeneconimi tavecuaajibiaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Paxamë apo pacacaëjëpae ata itsajivi pibisiacuene pexanaeneconi panevecuaajibiaexanaenexa, pacacaëjëpa picani saya jema panejumaitsinexa petabusipacuenebinëtsijavabelia mapacueniaje: “Cavecuaajibiaexanatsi rabaja pibisiacuene nexanaeneconimi,” panejainexa. Tsipaji itsajivi ata apo yapëtae tsipae saya jema panejumaitsijava. Itsiata baitsi jane itsa apo pacacaëjëpae panejamatejemayaexanaenexa petabusipacuenebinëtsi, acuenebi panejumaitsinexa bajaraponëjavabelia mapacueniaje: “Nonotapunare. Nijacamayo pire. Ponare baja,” panejainexa. Tsipaji bajarapacuenia pajumaitsimë ata, itsa apo jamatejema tsipae bajaraponë, nexata daxitajivi pacayapëtaejitsipa apo papecacaëjëpaecuene panejamatejemayaexanaenexa, jai nexata Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Xanë, Daxitajivi Pematapijinënë, mapanacuata necaëjëpa tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata pacuenia baja exanajë maponëjavabeliaje. Nexata patanecueneyapëtaenexamë tanecaëjëpaecuene tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata, pataema pacuenia jamatejemayaexanaejitsianë maponëjë, jai Jesús judíovi pecujarubivijavabelia. Nexata icatsia Jesús jumaitsi petabusipacuenebinëtsijavabelia: ");
INSERT INTO guh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Xamë cajumaitsitsi. Nonotapunare. Nijacamayo pire. Nijaboyabelia baja ponare, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nexata bajarapacuenia Jesús pejumaitsijavata petabusipacuenebinëmitsi nonotapuna. Pebocaecamayo baja pita. Pitsapalia baja daxitajivi pitabarata. Nexata daxitajivi itsa tane bajarapacuene, jamatabëcuenenabenajaquena. Bajarapamonae jumai tsenae mapacueniaje: —Dioso cajena bitso ayaijamatabëcuenenë. Caeto ata abaxë mapitsicuene pexanaejava apo taetsije, jai tsenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús pona pucaxaneto itapajavabelia. Nexata jivi ayaibitsaëtoxaneto pënapatatsi bajarabelia. Nexata Dioso pejumelivaisi Jesús tsipaeba bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bajaraxuacujinae penajetarucaejavata Jesús taeyeta Levívënënë, Alfeo pexënato. Leví eca pabota gobierno pejamatabëcuene jivijavabelia matamoyanijobabiaba impuestomatamo. Nexata Jesús jumaitsi Levíjavabelia: —Leví, naxanitsia. Nepënaponare, jai Jesús. Jejai Leví. Nexata nonotapuna. Leví baja napona Jesús pepëta. ");
INSERT INTO guh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nexata Leví junata Jesús pebarënabaninexa pijabota. Nexata Leví pijabota Jesús pexaejava naxane. Leví pijabota ayaibitsaëto naena gobierno pejamatabëcuene jivijavabelia impuestomatamo pematamoyanijobabiabivi. Itsamonae ata nanabane piajamatabëcuenebejevi. Nexata Jesús pijajivi nabarëeca bajarapamonaejavata. ");
INSERT INTO guh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nexata fariseovi, judíovi pecujarubivinua, Jesús taeyetatsi daxita bajarapamonaejavata pijajivi penabarënabanecaejava. Nexata bajarapamonae jamatabëcuenenavëxaniabiaya jumaitsi Jesús pijajivijavabelia: —Papecacujarubinë Jesús naneconita Diosojavabelia. Tsipaji gobierno pejamatabëcueneta impuestomatamo pematamoyanijobabiabivijavata, piajamatabëcuenebejevijavatanua, naxaeyeca pexaejava, jai bajarapamonae Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Itsa Jesús jumetane mapajumeje, nexata jumaitsi bajarapamonaejavabelia: —Pevaëbinë raja apo vaëbi pejamatejemavi. Pevaëbinë raja piavitanevi vaëba. Bajara pijinia xanë ata itsinë. Apo sivapatajopaenë tajunatsinexa pamonae baja aneconijibi tsavanapae. Sivapatajopajë raja tajunatsinexa pijaneconi pexainaevi. Bajarapamonae junataponajë pecopabinexa pibisiacuene pexanaejava penajamatabëcuenepënëyorotsinexa Diosojavabelia, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Itsamatacabi Juan pijajivi, fariseovi pijajivinua, pexaejava apo xaevanapae pamatacabibeje Diosojavabelia vajëcapona. Nexata itsamonae Jesúsjavaberena pata. Yanijobatsi pexaejava piatsobicuene yabara. Jumaitsi mapacueniaje: —Juan pijajivi, fariseovi pijajivinua, pexaejava apo xaeyabiabi pamatacabibeje Diosojavabelia vajëtapona. ¿Detsa xuajitsia itsiata xamë nijajivi pexaejava xaeyabiaba pamatacabibeje Diosojavabelia vajëtapona? jai Jesús peyanijobivitsi. ");
INSERT INTO guh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Pamonae junatatsi penacasabifiestajavabelia penanabaninexa, apo atsobi pexaejava itsa abaxë yajavaecatsi pejananacasabinë. Itsa abaxë pejananacasabinë yajavaponaponatsi, acuenebi pexaejava piatsobinexa bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Itsiata baitsi jane itsa pejananacasabinë tsimaxëpatsipatsi pevecuacaponaenexatsi itsajavabelia, nexata bajarapamonae pexaejava apo xae tsipae. Tsipaji bitso najamatabëxainaejitsipa pevecuacaponaexaetsi. Bajara pijinia itsi tajajivi ata. Tayajavaponaponaeepato abaxë apo atsobabiabi pexaejava pamatacabibeje Diosojavabelia vajëtapona. Itsiata pamatacabi xanë necaponaena bajarapamonaevecua, nexata jane baja bajarapamatacabi pexaejava apo xae tsane bitso tanesivanajamatabëxainaexae, jai Jesús peyanijobivitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nexata bajarapamonae perujujamatabëcuene baja pecopabinexa, Jesús livaisi tsipaeba comparacióncuenia bajarapamonae pejumecovënëtsinexa ëpejanalivaisi, Jesús petsipaebilivaisi. Bajarapamonae anijajamatabëcuenebeje pexainaeyaniva perujujamatabëcuene baja pecopabinexa, Jesús livaisi tsipaeba comparacióncuenia. Perujujamatabëcuene yabara Jesús jumaitsi bajarapamonaejavabelia mapacueniaje: —Itsajivi ata raja apo catsatarutsi pejanapana perujunaxatatsiesetojavabelia. Itsa catsatarutsipa pejanapanata perujunaxatatsiesetojavabelia, nexata pejanapana yanarobotsipa perujuesetojavaverena. Nexata biji bitso pinijivojoto titinaejitsipa. ");
INSERT INTO guh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Itsajivi ata pijinia apo epacae pejanavinoranë perujubocodoruanëjavabelia bajayajebi peyajebinexa. Pejanavinoranë itsa epacaejitsipa perujubocodoruanëjavabelia, nexata pejanavinoranë yatititibia tsipae. Tsipaji perujubocodoruanë apo yanayeretsi tsipae. Tsipaji pejanavinoranë pejumalitsëxë abaxë xaina. Nexata itsa yatititibia tsipae, mene naxuabijitsipa, vinoranëmi. Bajaraxuata bepaca pejanavinoranë pejanabocodoruanëjavabelia, jai Jesús peyanijobivitsijavabelia bajarapamonae pejumecovënëtsinexa ëpejanalivaisi, Jesús petsipaebilivaisi, perujujamatabëcuene baja penacopabinexa. ");
INSERT INTO guh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Judíovi penacueraevetsimatacabita Jesús, pijajivi yajava, najetaruca namutua trigo pabianëjava. Nexata Jesús pijajivi piajanixae, trigoxu siricanajetarubena. Xuxaeyabuatapona. ");
INSERT INTO guh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nexata fariseovi jumaitsi Jesúsjavabelia: —¡Taema mapacueneje! Dioso Moiséspijinëta penajumecopatsilivaisita vajanacaitavetsicuene, nijajivi exana. Apo nacaitavetsi ata trigoxu vajaxaejava, itsiata ajena penacueraevetsimatacabixae, nijajivi apo bexanae mapacueneje, jai fariseovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nexata Jesús jumaitsi fariseovijavabelia: —Ajena, penacueraevetsimatacabita, tajajivi bajarapacuenia exanae ata, itsiata apo pibisiacuene. Tsipaji bitso piajani. ¿Apo palebimë tsipaji Dioso pejumelivaisibaxuto paneyapëtaenexa pacuenia vajasalinainëmi Davidpijinë, pebarëponaponaevi yajava, exana pamatacabi bitso piajani? ");
INSERT INTO guh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Davidpijinë joneya Dioso pijatemploboyalia pamatacabi Abiatarpijinë daxita sacerdotevi penamatacaitorobinë tsaponaponae. Nexata Dioso pijatemploboënëta, mesajumata, bobena Diosonexa ofrendacuenia petojebipanbëanë. Bajarapapanbëanë itsajivi ata apo tocopatsitsi pexaenexa penaneconitsiyaniva Diosojavabelia. Ësacerdotevi picani tocopatatsi pexaenexa. Davidpijinë apo sacerdotenë ata, xae ata bajarapapanbëanë pijajivi barë, itsiata apo vënananeconitsi Diosojavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Icatsia Jesús jumaitsi fariseovijavabelia: —Dioso raja tocopata caematacabi jivi penacueraevetsinexa. Tsipaji Dioso yapëtane pacuenia jivi namatavenona penacueraevetsinexa. Dioso apo exanae jivi saya jema peyaiyataenexa penacueraevetsimatacabianë. ");
INSERT INTO guh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nexata xanë, Daxitajivi Pematapijinënë, netoxanepana cajena tatsipaebinexa pacuene xanepana jivi pexanaenexa penacueraevetsimatacabita ata, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Penacueraevetsimatacabita Jesús joneya judíovi penacaetuatabiabiboyalia. Nexata bajarajota pebi naeca pecobetsaquenaenë. ");
INSERT INTO guh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nexata Jesús naitaxutocaevetatsi fariseovi petaenexatsi pecobetsaquenaenë pejamatejemayaexanaejava penacueraevetsimatacabita. Nexata Jesús pecobetsaquenaenë itsa jamatejemayaexana penacueraevetsimatacabita, “Jesús raja naneconita Diosojavabelia. Tsipaji penacueraevetsimatacabita nacueneba,” pejainexa bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nexata Jesús jumaitsi pecobetsaquenaenëjavabelia: —Nonotapunare. Nucare mapamonae pitabarataje, jai. ");
INSERT INTO guh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nexata Jesús jumaitsi fariseovijavabelia: —Penacueraevetsimatacabita ata xanepana vajaexanaenexa pexaniacuene. Xanepana vajajamatejemayaexanaenexa piavitanevi, jai Jesús fariseovijavabelia. Nexata fariseovi Jesús apo jumepitsitsi. ");
INSERT INTO guh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nexata Jesús anaeya naëcota bajarapamonae. Bajaraxuacujinae Jesús bejamatabëjiobireca. Tsipaji yapëtane piajamatabëcuenetajajava fariseovi. Nexata Jesús jumaitsi pecobetsaquenaenëjavabelia: —Namaxërovire, jai. Nexata pecobetsaquenaenë namaxërovita. Bajarajota cobexanepananajereca baja. Pecobetsaquenaejavami ajibi. ");
INSERT INTO guh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nexata fariseovi itsa tane Jesús pecobexanepanaeyaexanaejava pecobetsaquenaenë, fariseovi anaepana. Nexata bajarapabovecua pitsapa. Pona penabarëcuaicuaijainexa nacuaevetsinë Herodes pijajivijavabelia. Bajarapamonae najumejaita Jesús pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús, pijajivi yajava, pona Galilea pucaxaneto itapayabelia. Nexata Jesús pënaponaliatsi ayaibitsaëtoxaneto Galilea nacuapijivi. ");
INSERT INTO guh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nexata Jesús pënaponaliatsi Judea nacuapijivinua, Jerusalén tomarapijivinua, Idumea nacuapijivinua, Jordánmene itsapanaverenapijivinua, imoxoyo Tiro tomaravecua pejinavanapaevinua, imoxoyo Sidón tomaravecua pejinavanapaevinua. Daxita bajarapamonae Jesús pënaponaliatsi tsipaji Jesús vënëlivaisitanetsi Dioso pesaëta pinijicuene pexanaponaejava. ");
INSERT INTO guh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nexata Jesús pijajivi itoroba jera petoxaniavaetarutsinexatsi menetareca. Itsa bajarapajivibitsaëtoxaneto Jesús bitso matacënënaponatsi, nexata bajarapamo ënëabereca Jesús perunaenexareca. ");
INSERT INTO guh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús baja ayaibitsaëto piavitanevi jamatejemayaexana. Bajaraxuata itsamonae, piavitanevi, Jesúsjavabelia natorotaponabiaba pejayatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dovathi peyajavajinavanapaevi Jesús itsa taeyabiabatsi, bajarapamonae irata othopabiaba Jesús pitabarata. Bajarapamonae aëjai tsabiabi. —Xamë tsaena Dioso pexënatomë, jai tsabiabi dovathi peyajavajinavanapaevi. ");
INSERT INTO guh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nexata Jesús jumeitaveta bajarapamonae. Jumaitsi: —“Dioso raja pexënato,” pajamë pëtsa xanë yabara itsajivijavabelia, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús pijajivi ayaibitsaëtoxanetoyajuvënëvi, doce saya ponëbeje, itapeta apóstolevinexa. Jesús pitapetsivajënae apóstolevinexa, junaya petsutojumabetsia. Bajaravetsica Jesús junatanuca ponëbeje jamatabëitapeta apóstolevinexa. Nexata pamonae Jesús itapeta apóstolevinexa, junaya petsutojumabetsia, Jesúsjavabetsia. ");
INSERT INTO guh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nexata Jesús caetuata caebitsaëtoyo, doce ponëbeje pijajivi, pepënajinavanapaevinexatsi. Jesús itorobijitsianua bajarapamonae daxitanacuanëjava jivi petsipaebanajetarubenaenexa Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesús pijajivi jamatabëcuenecaëjëpaeyaexana Dioso pesaëta pejamatejemayaexanaponaenexa piavitanevi. Jamatabëcuenecaëjëpaeyaexananua Dioso pesaëta dovathi jivi pevecuacapitsapaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesús pijaapóstolevi, doce ponëbeje, mapevënëanëje. Copiaya ponë pevënë Simón. Bajaraponë Jesús vënëruba itsavënë, Pedro. ");
INSERT INTO guh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Itsanë Santiago. Itsanë Juan. Santiagobeje Juanbeje nacaebananëbeje, Zebedeo pexënatobeje. Bajaraponëbeje Jesús vënëruba Boanerges. “Boanerges,” itsa jai, bajarapamonae pijajumeta mapajumetaje pejumaitsijume: “Yamaxë pexënatobeje,” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Itsanë pevënë Andrés. Itsanë Felipe. Itsanë Bartolomé. Itsanë Mateo. Itsanë Tomás. Itsanë Santiago, Alfeo pexënato. Itsanë Tadeo. Itsanë Simón, celotenë. ");
INSERT INTO guh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Itsanë Judas Iscariote. Bajaraponë bexëajavabelia Jesús canajetsijitsiatsi pijavajabitsaë pecobeyabelia pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesús boya joneya pijajivi yajava. Icatsia jivibitsaëtoxaneto nacaetuata. Nexata acuenebi Jesús pijajivi pebarënabanijava. ");
INSERT INTO guh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Itsamonae Jesús yabara jumaitsi: “Jesús raja matajemabatsi,” jai. Nexata bajarapacuenia itsamonae Jesús yabara pejumaitsijava, Jesús pijamonae vënëlivaisitanetsi. Nexata Jesús pijamonae ponarena Jesúsjavaberena pebarëponaenexatsilia picani. ");
INSERT INTO guh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Judíovi pecujarubivi, Jerusalén tomaraverena peponaevi, jamatabëcuenenavëxaniabiaya Jesús yabara jumaitsi: —Mara ponë Jesúsje, Beelzebú yajavaponapona. Beelzebú raja daxita dovathivi pevetsinë. Bajaraxuata Jesús Beelzebú pesaëta dovathi jivivecua capitsapapona, jai judíovi pecujarubivi jamatabëcuenenavëxaniabiaya Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nexata Jesús junata bajarapamonae jamatabëcuenenavëxaniabiaya pejumaitsijava pecanaëjëtsinexa. Nexata bajarapamonaejavabelia Jesús jumaitsi mapacueniaje: —Beelzebú raja dovathivi jivivecua apo capitsapaponae tsipae. Tsipaji Beelzebú dovathi jivivecua itsa capitsapaponaejitsipa, nexata Beelzebú bepijavajabitsaë taejitsipa pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pacanaëjëre mapacueneje. Nacaenacuapijivi ata itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, namataenetsia naverebiabijitsipa nacaenacuapijivi ata. ");
INSERT INTO guh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bajara pijinia nacaemonae ata itsipae. Itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, namataenetsia naverebiabijitsipa nacaemonae ata. ");
INSERT INTO guh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bajara pijinia itsipae dovathi ata. Dovathi jivivecua itsa capitsapaponaejitsipa pijajivi dovathivi, nexata bepijavajabitsaënë taejitsipatsi pijajivi. Nexata apo sivaajamatabëcuenesaë tsipae pexanaponaejavanexa. Nacopiarucaeyaexanaejitsipa dovathi, jai Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Bajarapamonae pecanaëjëtsinexa Jesús bitso piasaënëcuene dovathi matatoxenetsia, Jesús icatsia jumaitsi bajarapamonaejavabelia mapacueniaje: —Itsajivi ata apo caëjëpaetsi pejonenexa bitso piasaënë pijaboyalia peyacajërëtsinexa xua xaina pijabota. Itsiata itsa patsipa bajaraponë matatoxenetsia bitso piasaënë, nexata cobecëtabuatsipatsi. Taxucëtabuatsipatsi yajava. Matapania bajarapacuenia yacajërëtsipatsi daxita xua xaina pijabota. Bajara pijinia pacuenia xanë ata bitso tasaënë dovathi matatoxenetsia. Bajaraxuata necaëjëpa jivivecua tacapitsapaenexa dovathivi. ");
INSERT INTO guh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Xaniajanë pacuenia pacatsipaebatsi. Dioso cajena caëjëpatsi daxitajivi pibisiacuene pexanaeneconi pevecuaajibiaexanaenexa. Pibisiacuenia jivi Dioso baracuaicuaijai ata, bajarapaneconi ata Dioso caëjëpatsi pevecuaajibiaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Itsiata baitsi jane pajivi pibisiacuenia baracuaicuaijai Espíritu Santo, bajarapajivi Dioso apo vecuaajibiaexanae tsane bajarapaneconi. Bajarapajivi naneconitsiana daxita matacabijavabelianexa, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bajarapacuenia Jesús jumaitsi tsipaji Jesús Espíritu Santo yajavaponaponae atatsi, judíovi pecujarubivi jumaitsi Jesús yabara: “Jesús raja Beelzebú yajavaponapona,” jai. Nexata bajaraxuata bajarapamonae naneconita Espíritu Santojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús pejuyapijivi, pena yajava, pata Jesúsjavaberena. Itsiata bajarapamonae boyalia apo jonelia Jesús penucaeboyalia. Nexata bajarapamonae junatsiaexana Jesús pejumetaeyenaevitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nexata pamonae Jesús petsipaebilivaisi matatoyorotsia jumetaeyenatsi, Jesúsjavabelia jumaitsi: —Patajatuxanenë, ena raja, nejuyapijivi yajava, nuca patapënëverena. Cajaita raja xamë, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Detsa pitsijamatabëcuenevi taena, tajuyapijivinua? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bajaraxuacujinae Jesús naëcota pematatoyorotsiaenaevitsi. Jumaitsi bajarapamonaejavabelia: —Mara jota pamonae xanëjavata penaevije, bajarapamonae jane taenajivi, tajuyapijivinua. ");
INSERT INTO guh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tsipaji raja pamonae exana pacuenia Dioso itorobatsi, bajarapamonae jane baja tajuyapijivi, taenajivinua, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Icatsia Jesús taxuxuaba livaisi petsipaebijava Galilea pucaxaneto itapajavata. Nexata jivi ayaibitsaëtoxaneto nacaetuata itsajota Jesús livaisi tsipaebanuca. Nexata Jesús runareca jera ënëabereca. Ecareca jera ënëtareca. Daxita jivibitsaëtoxaneto tajetabovelia nubena. ");
INSERT INTO guh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nexata Jesús daxitacuene livaisianë tsipaeba jivijavabelia. Jesús jumai tsaponae bajarapamonaejavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Panenamuxunaevere mapalivaisije. Peubinë pona pabiabelia peubinexa. Nexata itsa pata pabita, peubixu pexucayajabajarabicuenia ubanajetaruca. ");
INSERT INTO guh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nexata pexucayajabajarabijavata itsaxu othopa pabi tuatuajëjava, penajetarucaenamutojumata. Nexata bajarajota pata baratsui. Xane bajarapaxumi juvinejeva. ");
INSERT INTO guh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Itsaxu pijinia othopa ibopananëjumata, itsajota bitso ira apo aitayaë. ");
INSERT INTO guh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nexata icotia bitso itsa ataju, nexata bajarapaxu juvi ata, tsaquenapona. Tsipaji irabereca bitso apo atabunepepiareca. ");
INSERT INTO guh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Itsaxu pijinia othopa xanëebacabomijavata. Nexata peubixu xanëebotonë caecuenia itsa yajavajuva, bitso xanëebotonë matacënënatsi peubijavami. Nexata peubijava apo xainae pecuai. ");
INSERT INTO guh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Itsaxu pijinia othopa pexaniairata. Nexata juva. Xaniavaetsia vitsabaponanua. Xainanua pecuai. Itsabotonë capitsapa treinta paxutobeje tsaponae. Itsabotonë capitsapa sesenta paxutobeje tsaponae. Itsabotonë capitsapa cien paxutobeje tsaponae, jai Jesús bajarapalivaisi petsipaebivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nexata icatsia Jesús jumaitsi jivibitsaëtoxanetojavabelia: —Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús livaisi petsipaebicujinae, jivibitsaëtoxaneto baja Jesús vecuanaviabatsi. Nexata Jesús pijaepato barënacopata doce ponëbeje pijajivi, itsamonae itsiata yajava. Nexata bajarapamonae Jesús yanijobatsi. Bajarapamonae jumaitsi Jesúsjavabelia: —Palivaisi jivijavabelia tsipaebame peubinë pelivaisicuenia, pajamatabëcuene xaina, patayapëtaenexa panetsipaebare, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Paxamë rabaja xaniavaetsia Dioso pacayapëtaeyaexana Dioso papijajivimë papecaevetsijava. Bajarapacuene abaxë daxitajivi apo yapëtae. Baitsi ra saicaya pamonae apo tajajivi, tsipaebajë livaisianë ëcomparacióncuenia. ");
INSERT INTO guh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Bajaraxuata nexata bajarapamonae tae ata Dioso pesaëta pinijicuene taexanaejava, itsiata apo yapëtae pajamatabëcuene yabara exanajë pinijicuene taexanaejava. Nenamuxunaevetsi ata tatsipaebilivaisi, itsiata apo jumeyapëtae pajamatabëcuene xaina tatsipaebilivaisi. Bajarapacuenia apo jumeyapëtae penajamatabëcuenecopatsiyaniva Diosojavabelia pibisiacuene pexanaeneconimi Dioso pevecuaajibiaexanaeyanivatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús icatsia jumaitsi pijajivijavabelia: —Itsa apo pajumeyapëtaemë pajamatabëcuene xaina palivaisi pacatsipaebatsi peubinë pelivaisicuenia, ¿detsa nexata pacuenia pajumeyapëtaename daxita palivaisianë pacatsipaebijitsiatsi comparacióncuenia? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nexata icatsia Jesús jumaitsi pijajivijavabelia pijajivi peyapëtaenexa pajamatabëcuene xaina palivaisi tsipaeba peubinë pelivaisicuenia: —Pajivi raja peubixu uba, bajarapajivi bepepaebinë Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pacuenia itsi pabita peubixu, paxu othopa pabi tuatuajëjava penajetarucaenamutojumata, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae itsa tsipaebatsi Dioso pitorobilivaisi, jumetane picani. Tsijamatabëubatsi jane baja picani Dioso pitorobilivaisi. Itsiata baitsi jane pejumetaecujinae bajarapalivaisi, bepijia dovathi najetaruca bajarapamonaejavaberena. Nexata bajarapamonae tsijamatabëjuvinejevatsi, dovathi vecuapitatsi bajarapalivaisimi, petsijamatabëubilivaisimitsi. ");
INSERT INTO guh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pacuenia pijinia itsi paxu othopa ibopananëjumata, itsajota bitso ira apo aitayaë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae jumetane Dioso pitorobilivaisi. Nexata picani bajarapalivaisi barëyaya jumecovënëta. ");
INSERT INTO guh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Itsiata baitsi jane pacuenia irabereca apo atabunepepiareca paxu othopa ibopananëjumata, nexata nabijiana, bajara tsijamatabëcueneitsitsi bajarapamonae Dioso pitorobilivaisi. Tsipaji pepacuene pejamatabëëthëtovetsina apo jumecovënëtsi bajarapalivaisi. Nexata apo ajamatabëcuenesaë tsavanapae bajayajebi pejumecovënëtsinexa bajarapalivaisi. Nexata itsa tocopiapatatsi daxita petoayapëbejecuenetsi, itsa yalivaisibatsinua Dioso pitorobilivaisi yabara, nexata pejumecovënëtsijavami bajarapalivaisi bepijia copaba. Pevajënaeyabelia apo jumecovënëtavanapae. ");
INSERT INTO guh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pacuenia pijinia paxu othopa xanëebacabomijavata, itsa juva, bitso matacënënatsi xanëebotonë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Jumetane picani bajarapamonae Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Itsiata baitsi jane bitso jamatabëcueneenatsi mapanacuapijicuene yabaraje. Tsipaji najamatabëxaina ayaijava palata pexainaenexa. Nexata pijacuata najamatabëcueneyamaxëitojoroba. Daxitacuene mapanacuapijicuene bitso jitsipa pexainaenexa. Bajaraxuata Dioso pitorobilivaisi apo tovitsabitsi pejamatabëëthëtota. Nexata pacuenia itsi pabita piacuaijibibotonë, bajara itsi bajarapamonae. Tsipaji Dioso xaniavaetsia apo tojinavanapae. ");
INSERT INTO guh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pacuenia pijinia itsi paxu othopa pexaniairata, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae itsa tsipaebatsi Dioso pitorobilivaisi, tsijamatabëjunuatsi. Nexata tsijamatabëcuenevitsabaponatsi Dioso pitorobilivaisi. Nexata pacuenia peubijava capitsapa itsabotonë treinta paxutobeje tsaponae, itsabotonë sesenta paxutobeje tsaponae, itsabotonë cien paxutobeje tsaponae, bajara tsijamatabëcueneitsitsi bajarapamonae Dioso pitorobilivaisi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús icatsia jumaitsi doce ponëbeje pijajivijavabelia, itsamonaejavabelia ata: —Itsajivi ata lámparabë pitanojotsicujinae apo etsi cajoniënëalia. Apo etsi cama bëxëpanalia ata. Jume baja cajena. Biji rajane athëbëyo etsia daxitaboënë pitayotecaenexa. ");
INSERT INTO guh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bajara pijinia itsi palivaisianë tsipaebaponajë comparacióncuenia daxitajivi picani peyapëtaenexa. Najumematayatsia apo tsipaebaponaenë. Itsamonae nejumetae ata, aeconoxae abaxë apo nejumeyapëtae pajamatabëcuene xaina tatsipaebilivaisianë. Itsiata itsamatacabi, bexëajavabelia, daxitajivi nejumeyapëtaena pajamatabëcuene xaina palivaisianë comparacióncuenia tsipaebaponajë. ");
INSERT INTO guh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, xaniavaetsia nenamuxunaevetsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Panejumecanaëjëre patacatsipaebilivaisi. Itsamonae ata itsa pacatsipaebiana, bajarapamonae ata pajumecanaëjëtsianame papecatsipaebilivaisi. Palivaisivajëto panejumecanaëjëtsianame, nexata bajarapalivaisivajëto pajumeyapëtaename. Itsiata icatsia pematatsënëa bajarapitsilivaisivajëto Dioso pacayapëtaeyaexanaena. ");
INSERT INTO guh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pajivi xaniavaetsia nejumeyapëtane patacatsipaebilivaisi, bajarapajivi icatsia itsalivaisi pematatsënëa Dioso jumeyapëtaeyaexanaenatsi. Itsiata pajivi apo jitsipae pematatsënëa pejumeyapëtaeponaenexa, bajarapajivi palivaisiyovajëto picani jumeyapëtane, nacofënëtsiana, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús icatsia jivi comparacióncuenia livaisi tsipaeba Dioso pijajivi pevetsicuene yabara. Jumaitsi mapacueniaje: —Pacuenia peubixu pejuvicujinae, Dioso pesaëta vitsaba, bajara pijinia pacuenia Dioso pijajivi ata Dioso pesaëta jinavanapa. Peubinë pabita peubixu xucayajabajarabanajetaruca. ");
INSERT INTO guh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Peubinë peubicujinae vemaxëmajitabiaba meravi canacujitsia. Naëcotabiaba matacabita. Bajarapacuenia panepapona matacabianë. Nexata pijinia peubixu pabita juva. Vitsabapona. Itsiata baitsi jane peubinë apo yapëtae pacuenia peubixu pijacuata juva. ");
INSERT INTO guh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ira raja pejamatabëcueneta naxaniaba peubijava. Copiata pepaboto vitsabaya. Xuacujinae namatonota. Xuacujinae cuainavereta. ");
INSERT INTO guh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Itsa baja yaniona peubijava, penotsivi pona penotsinexa. Tsipaji baja penotsimatacabinexa tocopiapatatsi, jai Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","31","Jesús icatsia jumaitsi doce ponëbeje pijajivijavabelia, itsamonaejavabelia ata: —¿De meta xua pelivaisi jëpa Dioso pijajivi bepijia ayaibitsaëtoxaneto penaexanaejavanexa? Jivi meta peyapëtaenexa ayaibitsaëtoxaneto bepijia Dioso pijajivi penaexanaejavanexa, mostazaxutoyo meta pelivaisicuenia tsipaebianajë. Jumaitsinë meta tsane: “Pacuenia mostazaxutoyo pejuvicujinae, bepijia vitsaba mostazanae, bajara pijinia itsane Dioso pijajivi ata. Bepijia Dioso pijajivi ayaibitsaëtoxaneto naexanaena. Mostazaxu raja bitso tsiquirixutoxi daxita peubixuvecua. ");
INSERT INTO guh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Itsiata baitsi jane mostazanae itsa juva, bepijia vitsaba. Caevaita pinijinae naexana itsapeubinaenë matatoxenetsia. Nexata baratsui ata pematapenanë exana mostazanaemaxërananëjavata. Bajara pijinia itsane jivi ata. Bepijia ayaibitsaëto Dioso pijajivi naexanaena,” janë meta tsane mapacueniaje, jai Jesús pijajivijavabelia, itsamonaejavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dioso pitorobilivaisi Jesús tsipaebabiaba jivijavabelia. Dioso pitorobilivaisi Jesús jivi tsipaebabiaba ëcomparacióncuenia. Pacuenia baja jivi caëjëpatsi pejumeyapëtaenexa, bajarapacuenia Jesús tsipaebabiaba. ");
INSERT INTO guh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesús ëcomparacióncuenia livaisi tsipaebabiaba bajarapamonaejavabelia. Itsiata saicaya Jesús ëpijajivijavabelia xaniavaetsia yapëtaeyaexanabiaba pajamatabëcuene xaina daxita bajarapalivaisianë. ");
INSERT INTO guh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dioso pitorobilivaisi Jesús tsipaeba jivijavabelia. Bajarapamatacabi Jesús petsipaebicujinae itsa baja caniviyotsia, Jesús jumaitsi pijajivijavabelia: —Nicabaliatsi mapapucaxaneto itsapanabeliaje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nexata baja Jesús, pijajivi yajava, vecuapona jivi. Pajerata Jesús ecareca, pijajivi yajava pona. Itsiata itsamonae pënaponatsi itsajeranëta. ");
INSERT INTO guh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nexata pinijijoviboxaneto jemata najetaruca. Nexata malataca jera ënëaberena mera epabajarabapona. Nexata baja jera ënëaberena mera vënëcapona. ");
INSERT INTO guh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús itsiata majitanuca jamatejema jeratabufejavavetsina. Namatabëxëyaëtanuca penamatabëxëyaëtabiabijavata. Nexata Jesús pijajivi yaitavabatsi. Jesús pijajivi jumaitsi: —¡Patajatuxanenë, vaxaitsimi rabaja yaothopaenatsi! ¿Apo jamatabëcuenebëjamë tsaja? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nexata Jesús pemajitanucaenëmi naëcotapuna. Pinijijumeta itavetaxuaba jovibo. Jesús jumaitsi pucajavabelia, jovibojavabelia ata: —¡Vainae ecare baja! jai. Bajarapacuenia Jesús pejumaitsijavata jovibo baja ajibi tsaxuabi. Daxitapuca baja nexata vainae ecaxuaba. ");
INSERT INTO guh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia bitso pajunavame? ¿Tsipaji apo payapëtaemë Dioso papecaevetsijava? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nexata Jesús pijajivi najunaviaca bajarapacuene petaexae. Ëpamonae najumaitsi: —¿De meta tsipaji maponëje? ¡Itaveta jovibo, malataca ata! ¡Jumecovënëtatsi baja rovia maponëje! ¡Nexata baja jovibo, malataca yajava, ajibi tsaxuabi! najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús pijajivi barëpata pucaxaneto itsapanabelia, Gerasa nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nexata Jesús jerajavavetsina nonotajuna. Pebi dovathivi peyajavaponaponaenë, cujitabarenatsi jivimëthëanëjavaverena. ");
INSERT INTO guh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bajaraponë ponaponabiaba jivimëthëanëjavata. Itsajivi ata apo caëjëpaetsi pecëtsinexa bajaraponë cadenamaëtota ata. ");
INSERT INTO guh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cadenamaëtonëta picani taxucëtabiabatsi anijatonë. Cobecëtabiabatsi picani yajava. Itsiata cajena pecobecëtsicadenamaëtotsi ucutajarababiaba pesaëta. Bajaraxuacujinae petaxucëtsicadenamaëtotsi pecobeta tsaquibiaxuababiaba. Nexata cadenamaëtomi tsiquirijavaxi exanapenetabiaba. Itsajivi ata cajena apo caëjëpaetsi pecëtsinexa bajaraponë. Tsipaji bitso asaë. ");
INSERT INTO guh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bajaraponë petsutonëjava, jivi petëpaevi pemëthëcaejava, matacabijebi, meravijebi yajava, ponaponabiaba. Vavajai tsabiabaponaponae. Ibotonëjavabelia natsaquibajarababiabaponapona. ");
INSERT INTO guh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bajaraponë itsa taetaba Jesús penajetarucaejava, nexata tajëverena cujinaeponarena Jesúsjavaberena. Jesús pitabarata pematabacabëta nucajunua. ");
INSERT INTO guh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bajaraponë aëjai pinijijumeta Jesús pitabarata. —Jesús, pepo Dioso, athëbëtatsia peecaenë, pexënatomë. ¿Detsa xua jaitame xanëjavaberena? Pexaniacuene bitso cavajëtatsi Dioso pitabarata. Nejamatabëcuenebejiobitsipame, jai dovathivi peyajavaponaponaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bajarapacuenia jumaitsi dovathivi peyajavaponaponaenë tsipaji Jesús jerajavavetsina penonotajunaejavata, dovathivi peyajavaponaponaenë pemataenenaejavatatsi, Jesús itaveta dovathivi. Jesús jumaitsi dovathivijavabelia mapacueniaje: —¡Dovathivi, bajaraponë baja pavecuapitsapare! jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nexata Jesús jumaitsi bajaraponëjavabelia: —¿Detsa pavënëmë? jai. Nexata dovathivi peyajavaponaponaenë navënëpaeba. —Tavënë raja Legión. Tsipaji raja bitso paayaibitsaëtoxanetonë, jai dovathivi peyajavaponaponaenë. ");
INSERT INTO guh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nexata dovathivi pinijicuenia vajëta Jesúsjavabelia itsairabelia pejutsiyanivatsi bajarapairavecua. ");
INSERT INTO guh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nexata bajarajota, imoxoyo petsutojavata, marranobitsaëtoxaneto xaevanapa. ");
INSERT INTO guh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Dovathivi bitso vajëca Jesúsjavabelia. —Paneitorobare marranobitsaëtoxanetojavabelia. Panetocopare patajonenexa bajara pamarranobitsaëtoxanetojavabelia, jai dovathivi. ");
INSERT INTO guh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nexata Jesús tocopata pacuenia dovathivi vajëcatsi. Dovathivi baja pebi vecuapitsapecatsi. Nexata baja marranobitsaëtoxanetojavabelia dovathivi junua. Bajara pamarranobitsaëtoxaneto jinavanapa anijamilbeje ponëbeje. Nexata daxita marranobitsaëtoxanetomi cujinaeyeca. Pucaxaneto itapajanituareca othopareca. Nexata daxita marranobitsaëtoxanetomi meneta bubuna. ");
INSERT INTO guh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bajara pamarranobitsaëtoxanetomi pevetavanapaevi rëcëpeca. Pona, pacuene tane, petsipaebinexa tomarapijivijavabelia, petsipaebinexa vayafotusatojava penaevijavabelia ata. Nexata jivi ponarena petaenexa bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nexata dovathivi peyajavaponaponaenëmi bajarapamonae taeyeta Jesús pemuxuneneta. Bajaraponë penaxatatsijava baja naxatateca. Jamatejema baja. Xaniavaetsia eca. Nexata bajarapamonae cujunavatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pamonae cuenetanetsi Jesús pejamatejemayaexanaejava dovathivi peyajavaponaponaenëmi, bajarapamonae paeba pepatsivijavabelia daxita pacuene tane. Paeba pacuene ata Jesús exana marranobitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nexata Gerasa nacuapijivi jumaitsi Jesúsjavabelia: —Pexaniacuene pacavajëtatsi. Ponare baja patajanacuavecua, jai Gerasa nacuapijivi Jesúsjavabelia tsipaji cujunavatsi. ");
INSERT INTO guh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús baja itsa runareca jera ënëabereca, ponë dovathivi peyajavaponaponaenëmi, bitso picani navajëca Jesús pepëta penaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Itsiata Jesús apo jejai. Jumaitsi bajaraponëjavabelia: —Ponare nijaboyabelia. Nijamonae tsipaebare papinijicuene Dioso caexana. Tsipaebare pacuenia ata caitaxutotsoniatane Dioso, jai Jesús dovathivi peyajavaponaponaenëmijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nexata baja dovathivi peyajavaponaponaenëmi pona. Taxuxuaba penavajunupaebijava papinijicuene Jesús exanatsi. Bajaraponë navajunupaebapona Decápolisvënë nacuajava. Decápolisvënë nacuata eca diez patomarabeje. Daxitajivi jamatabëcuenenabenajaca itsa jumetanetsi bajaraponë penavajunupaebaponaejava. ");
INSERT INTO guh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús icatsia pecovëyaberena jerata naviarena pucaxaneto itsapanaverena. Nexata tajetabojavatarena jivibitsaëtoxaneto Jesús matatoyoronatsi. ");
INSERT INTO guh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nexata bajarajota napatajopa Jairovënënë. Bajaraponë judíovi penacaetuatabiabibo pevetsiviyajuvënënë. Jairo itsa taetaba Jesús, nexata Jairo pematabacabëta yaiyataeya Jesús pitabarata nucajunua. ");
INSERT INTO guh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pinijicuenia Jairo vajëta Jesúsjavabelia. Jumaitsi: —Taxënatoyo raja netobitso. Najumalipeneta rabaja petëpaenexa. Pexaniacuene netoexanare. Naxanitsia. Netoperabëjayatsianame necobeta petëpaeyaniva, jai Jairo. ");
INSERT INTO guh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jejai Jesús. Jesús nexata napona Jairo pepëta. Nexata jivibitsaëtoxaneto Jesús pepënaponaevitsi matatoyorotsia cënënanajetarubenatsi. ");
INSERT INTO guh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bajarapajivibitsaëtoxaneto tuatuajëta itsava, pijanacuene pecapunaevatsi, nanajetaruca. Bajarapova pijanacuene pecapunaecujinaetsi doce baja pavaibeje xaina. ");
INSERT INTO guh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bitso nexata bajarapova bejiobi pexainaecuene yabara pevaëbivitsi pejamatabëcueneta. Tsipaji belia daxita pexainaejavaximi navecuavereta pematamobaponaeta pevaëbivitsi. Itsiata apo caevi piavitanecuene. Biji caranata pevajënaeyabelia capunaponatsi piavitanecuene. ");
INSERT INTO guh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nexata bajarapova jumetane itsamonae pecuaicuaijaijava Jesús piavitanevi pejamatejemayaexanaponaejava yabara. Nexata bajarapova ponataba Jesús pepënëvelia, jivibitsaëtoxaneto tuatuajëalia. Nexata bajarapova tojayataba Jesús penaxatatsijava. ");
INSERT INTO guh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tsipaji cajena bajarapova jamatabëjumaitsi: “Itsa Jesús penaxatatsijava tojayatabianajë, tavitanejavami nevecuaajibi tsane,” jamatabëjai. ");
INSERT INTO guh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nexata bajarapova itsa tojayataba Jesús penaxatatsijava, bajarajota pijanacuenemi vecuaajibitsi baja. Nexata bajarapova pijanacuenemi pecaevijavareca, nayapëtane. ");
INSERT INTO guh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús ata nayapëtane pesaëta pejamatejemayaexanaejava pepënëyabelia. Nexata pejayatabijavatatsi Jesús napënëyorotaxuaba. Naëcobaruta. Yanijoba jivijavabelia. —¿Jipatsa tanaxatatsijava netojayataba? jai. ");
INSERT INTO guh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nexata Jesús pijajivi jumaitsitsi: —Taneme rabaja jivibitsaëtoxaneto pecacënënanajetarubenaejava. ¿Detsa xuajitsia: “¿Jipatsa tanaxatatsijava netojayataba?” jamë? jaitsi Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús naëcobaruta daxitajivijava petaenexa pajivi tojayatabatsi penaxatatsijava. ");
INSERT INTO guh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nexata bajarapova neconecojai tsanucae pecajunavi penayapëtaexae Jesús pejamatejemayaexanaejavatsi. Nexata bajarapova najetabarena Jesús pitabarayaberena. Pematabacabëta nucajunua. Nexata daxita pacuene exana, bajarapova tsipaeba Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nexata Jesús jumaitsi bajarapovajavabelia: —Xamë nesivajamatabëjumaitsimë: “Jesús penaxatatsijava itsa tojayatabianajë, tavitanejavami nevecuaajibi tsane,” nesivajamatabëjamë. Bajaraxuata jamatejemamë baja. Ponare baja jamatejema. Niavitanejavami rabaja ajibi, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bajarapacuenia Jesús pejumaitsanucaejavata namutoepatota, Jairo pijaboverena peponaevi mataenenatsi. Bajarapamonae jumaitsi Jairojavabelia: —Jairo, nexënatoyo rabaja tëpa. Pëtsa baja matavëjëa jamatabëitonotaponame Jesús, jai bajarapamonae Jairojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús jumetae ata bajarapajume, itsiata jumaitsi Jairojavabelia: —Jairo, pëtsa najamatabëxainame. Najamatabëcuenecopare saya ëxanëjavaberena nexënatovayo pecatoasaënexa, jai Jesús Jairojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nexata Jesús, pajivibitsaëtoxaneto pënanajetarubenatsi, pueneta bajarajota. Jesús pona Jairo pijaboyabelia. Jesús saya yajavalia mapamatabëxëyoje: Pedro, Juan, Santiago, Jairo jane baja. Juanbeje Santiagobeje nacaebananëbeje. ");
INSERT INTO guh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Itsa baja Jesús palia Jairo pijaboyabelia, tane jivibitsaëto pinijijumeta pematanueyabijava petëpaevayo. ");
INSERT INTO guh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús itsa joneya boyalia, jumaitsi bajarapamonaejavabelia: —Pëtsa bitso pamatanueyabame. Pejanava raja apo tëpae. Saya raja majitanuca, jai Jesús tsipaji yapëtane Jesús piasaëyaexanaejavanexa bajarapovayo. ");
INSERT INTO guh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bajarapacuenia Jesús pejumaitsijava, bajarapamonae saya jumecapocaponatsi. Nexata daxita Jesús bovecua pitsapaeyaexana. Itsaxuayolia petëpaevayo boca, Jesús barëjoneya caejiviyobeje saya. Jesús saya barëjoneya mapamatabëxëyoje: petëpaevayo paxa, pena, Jesús pijajivi, acueyabi ponëbeje. Bajarapamatabëxëyo saya Jesús barëjoneya. ");
INSERT INTO guh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nexata Jesús petëpaevayo cobepita. Jesús pijajumeta jumaitsi: —Talita cumi, jai, mapajumetaje pejumaitsijume: “Pejanava, nonotapunare,” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bajarapacuenia Jesús pejumaitsijavata, pejanavayo nonotabapuna. Ponapona baja. Bajarapovayo doce pavaibeje xaina. Nexata Jesús peyajavajonevilia pinijicuenia jamatabëcuenenabenajaca bajarapacuene itsa tane. ");
INSERT INTO guh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nexata Jesús pinijicuenia jumaitsi: —Pëtsa itsajivi ata patsipaebame mapacueneje, jai Jesús. Bajaraxuacujinae Jesús jumaitsi pejanavayo penajavabelia: —Nexënatovayo pexaejava rajure, jai. ");
INSERT INTO guh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús baja, pijajivi yajava, pona Capernaum tomaravecua. Naviata pijanacuayabelia, pevitsabitomarabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Judíovi penacueraevetsimatacabita Jesús taxuxuaba jivi livaisi petsipaebijava judíovi penacaetuatabiabibota. Ayaibitsaëtoxaneto pejumetaevitsi sivajamatabëcuenenabenajacatsi. Nexata bajarapamonae Jesús jamatabëcueneaebiatanetsi. Bajarapamonae Jesús yabara najumaitsi mapacueniaje: —¿Detsa meta verena maponë capitsapa mapajamatabëcuenelivaisije? ¿Detsa pacuenia meta yapëtane daxita mapacueneje? ¡Pitsipinijicuene maponë exanaje, vaxaitsi abaxë caeto ata apo taetsi! ¡Matapania matanetsije! ");
INSERT INTO guh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Maponëje vaxaitsiyajuvënënë. Carpinteronë. María pexënato. Bajaraponë pejuyapijivi Santiago, José, Judas, Simón. Papetiriavi ata vajatomarata jinavanapa, bajaraponë pejuyapijivi, najai bajarapamonae Jesús yabara. Nacaetomarapijivixae, bajarapamonae Jesús apo jumexaniataetsi. ");
INSERT INTO guh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Bajara maitsabiabije. Diosojumepaebivi profetavi itsanacuapijivi yaiyataeyabiabatsi. Itsiata pijanacuapijivi, pijaviriavi, pijamonae ata, apo yaiyataeyabiabitsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nexata Jesús bajarajota jivi ayaibitsaëtojavabelia pinijicuene pexanaejava apo tsitaexanae. Tsipaji apo jumecovënëtsitsi. Saya caejiviyobeje piavitanevi pecobeta jayata. Jamatejemaya exana. ");
INSERT INTO guh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nexata Jesús bitso najamatabëxaina. Tsipaji jivi apo jumecovënëtsitsi. Bajaraxuacujinae Jesús tsiquiritomaraxijava Dioso pitorobilivaisi jivi tsipaebanajetaruca. ");
INSERT INTO guh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús junata pijajivi doce ponëbeje penacaetuatsinexa. Nexata Jesús pijajivi itoroba anijanëbeje tsaponae. Jesús pijajivi pecaëjëpaejamatabëcuenetsi jamatabëcuenecaëjëpaeyaexana dovathi peyajavajinavanapaevi pevecuacapitsapaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jesús jane baja pijajivi penaropobivajënae, Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pëtsa itsacuenejava ata pacaponame panijanamutonexa. Pëtsa pacaponame panemarue ata, doro ata, palata ata. Ënaeboyo saya pacaponare. ");
INSERT INTO guh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Itsiata pataxunaponare panenataxuxatabijava. Caejava panenaxatatsijava pajumaponare. Pëtsa anijacamisabeje pacaponame. ");
INSERT INTO guh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Itsajota papatabiabianame, caebota pamajitabiabianame. Pëtsa panatixitaponame itsaboyabelia panemajitsinexa. Matapania icatsia itsajavabelia itsa paponaename, bajarapabovecua papitsapaename. ");
INSERT INTO guh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Patomarata apo pacacopiapitsi tsane, itsa apo jitsipaenua tsane papecanamuxunaevetsinexa panetsipaebilivaisi, nexata paponaename bajarapatomaravecua. Paneponaevajënae bajarapatomarata panataxuatsapërëvarëbianame. Bajarapacuenia itsa panataxuatsapërëvarëbianame, bajarapatomarapijivi yapëtaena Diosojavabelia penaneconitsicuene apo papecacopiapitsixae papecanamuxunaevetsinexa panetsipaebilivaisi. Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi Dioso jivi naneconitsiaexanaena, bajarapamatacabi Dioso bitso naneconitsiaexanaenatsi patomarapijivi apo pacacopiapitsi tsane. Paneconivajëtota bajayata Dioso naneconitsiaexana Sodoma tomarapijivimi, Gomorra tomarapijivimi ata, bajarapaneconivajëto matatoxenetsia Dioso naneconitsiaexanaenatsi patomarapijivi apo pacacopiapitsi tsane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nexata jane baja Jesús pijajivi naropoba Dioso pitorobilivaisi jivi petsipaebanajetarubenaenexa. Jesús pijajivi naropoba anijanëbeje tsaponae. Nexata Jesús pijajivi jumai tsaponae jivijavabelia: —Pacopabare baja pibisiacuene paneexanabiabijava. Panajamatabëcuenepënëyorore Diosojavabelia, jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jesús pijajivi dovathi peyajavajinavanapaevi vecuacapitsapapona. Piavitanevi ata mataexabapona aceiteranëta. Bajarapacuenia Jesús pijajivi jamatejemayaexanapona piavitanevi. ");
INSERT INTO guh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes, Galileanacua pevetsinë. Nexata Herodes jumetane itsamonae jamatabëcuenenavëxaniabiaya pejumaitsijava Jesús yabara: “Juanpijinë raeta jivibautisabinëmi icatsia asaë petëpaecujinae. Bajaraxuata caëjëpatsi Dioso pesaëta pinijicuene pexanaenexa,” pejaijava itsamonae jamatabëcuenenavëxaniabiaya Jesús yabara, Herodes jumetane. ");
INSERT INTO guh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Itsamonae pijinia jumai tsaponae Jesús yabara: —Bajayata raeta ponëmi ponapona, profeta Elíaspijinëmi, baja raeta ponë, jai tsaponae itsamonae. Itsamonae pijinia jumai tsaponae Jesús yabara: —Diosojumepaebinë profeta raja. Tsipaji rabaja pacuenia bajayata profetavi jinavanapa, bajara icatsia maponë itsije, jai tsaponae itsamonae. ");
INSERT INTO guh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bajarapacuenia itsamonae jamatabëcuenenavëxaniabiaya pejumaitsaponaejava Jesús yabara, Herodes itsa jumetane, Herodes ata jamatabëcuenenavëxaniabiaya jumaitsi Jesús yabara: —Maraeta Juanpijinëmije, ponëmi bajayata xanë tajajivi vësiucutaxuabiaexanajë. Icatsia raeta asaë petëpaecujinae, jai Herodes jamatabëcuenenavëxaniabiaya Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bajarapacuenia Herodes jumaitsi tsipaji abaxë Juanpijinë itsa asaë, Herodes pijajivi, vajabitsaëvi, itoroba Juanpijinë pevaetabinexatsi. Nexata vajabitsaëvi Juanpijinë cobecëtsiaya caponatsi penaneconitsivi pejebabiabiboyalia. Bajarapacuenia Herodes pijajivi itoroba Herodes pijava, Herodíasva, pejamatabëcueneta. Herodíasva picani copiata pita Felipe, Herodes pejuyapijinë. Nexata Herodes pejuyapijinë pijava yacajërëta. ");
INSERT INTO guh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nexata Herodes pejuyapijinë pijava peyacajërëtsixae, Juanpijinë abaxë itsa apo vaetabitsi, muxujioba Herodes. Juanpijinë jumaitsi Herodesjavabelia: —Acuenebi raja nejuyapijinë pijava nepitsijava,” jai Juanpijinë Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nexata bajarapacuenia Juanpijinë pejumaitsixae, itoyatsi Herodíasva. Nexata abaxë Juanpijinë itsa ponapona penaneconitsivi pejebabiabibota, bajarapova picani Juanpijinë jamatabëbeyaxuabiaexanatsi. Itsiata apo caëjëpaetsi. ");
INSERT INTO guh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tsipaji Herodes yapëtane Juanpijinë bitso pejamatabëxanepanaenëcuene. Nexata Herodes yaiyatane Juanpijinë. Bajaraxuata Herodes apo tocopatsi pijava pejamatabëcueneta pebeyaxuabinexatsi Juanpijinë. Juanpijinë itsa cuaicuaijai tsabiabi Herodesjavabelia, nexata picani Herodes jamatabëbëjai tsabiabi pijaneconi yabara. Itsiata Herodes xaniavaetsia namuxunaevetabiaba. ");
INSERT INTO guh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nexata pamatacabi Herodes najamatabënapita penaexanaematacabi, najamatabëxaina pexaniafiesta pexanaenexa. Bajarapafiestajava Herodes junata pijaboyaberena jivi ayaibitsaëtoxaneto penabaninexa. Junata Herodes pijajivi, pamonae toevetatsi pijairanë. Junata vajabitsaëvi pevetsivinua. Junata petuxanevinua, Galilea nacuata pejinavanapaevi. Nexata bajarapafiestajavata Herodíasva toyapëxanepanatsi Juanpijinë pebeyaxuabiaexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodíasva toyapëxanepanatsi tsipaji pexënatoyo joneya Herodes pejunatsivi pebarënabanecaejavalia pijacujirucuenia caevayo peyavajibinexa. Nexata Herodes pejunatsivi bitso barëitajitsipa pejionëyo peyavajibijava. Nexata Herodes najumecapanepaeya pexaniajaijumeta jumaitsi pejionëyojavabelia: —Nevajëre xua jitsipame. Carajutsianatsi raja. ");
INSERT INTO guh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pacuenejava nevajëtsianame, carajutsianatsi. Itsa nevajëtsianame taneevetsiaexanaenacua ata, tuatuajëjava carajutsianatsi, jai Herodes najumecapanepaeya pejionëyojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nexata bajarapovayo pitsatabalia. Jumaitsi penajavabelia: —¿Detsamë ra xua vajëtsianajë? jai penajavabelia. Nexata Herodíasva pexënatoyojavabelia jumaitsi: —Juan jivibautisabinë pematabocoto vajëre, jai. ");
INSERT INTO guh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nexata bepijia bajarapovayo jopajoneya Herodes peecaejavabelia. Jumaitsi Herodesjavabelia: —Jitsipajë cajena tanerajutsinexamë platota Juan jivibautisabinë pematabocoto, jai bajarapovayo Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nexata Herodes pinijicuenia bejamatabëjiobi tsanajetsireca. Herodes nexata acuenebi: “Jume,” pejaijava. Tsipaji baja Herodes najumecapanepaeya jumaitsi pejionëyojavabelia pexaniajaijumeta daxita pejunatsivi pitabarata. ");
INSERT INTO guh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nexata Herodes bepijia itoroba vajabitsaënë petocarenanexatsi Juan pematabocoto. ");
INSERT INTO guh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Vajabitsaënë nexata pona penaneconitsivi pejebabiabiboyabelia. Juanpijinëmi vësiucutaxuabatsi. Juanpijinëmi pematabocoto vajabitsaënë carena platota. Nexata pejanava rajutatsi. Nexata bajarapovayo juya pena rajuta. Nexata baja Herodíasva yapëtane capanepaeya baja Juanpijinë pebeyaxuabijavatsi. ");
INSERT INTO guh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nexata Juanpijinë pijajivi itsa vënëtanetsi pebeyaxuabijavatsi, bajarapamonae ponarena Juanpijinë pebocaejavaberena. Pitatsi petëpaenë. Pepitsicujinaetsi Juanpijinë pijajivi mëthëtatsi. ");
INSERT INTO guh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús pitorobivi, apóstolevi, naviabanajetarubena Jesúsjavaberena. Nexata bajarapamonae Jesúsjavabelia navajunupaeba daxita pacuene exanavanapa, pacuenia ata jivi livaisi tsipaebavanapa. ");
INSERT INTO guh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Naxanitsia. Ponatsi pesajinaejavabelia. Nacueraevetsianatsi caeepatoyo, jai Jesús. Bajarapacuenia Jesús jumaitsi pijajivijavabelia tsipaji jivibitsaëtoxanetonë topatabiabatsi. Itsamonae naviabaponabiaba. Itsamonae juya patabiaba. Nexata Jesús pijajivi pebarënabaninexa, apo cuenecaëjëpabiabitsi. ");
INSERT INTO guh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nexata Jesús ëpijajivi jerata yajavapona itsabelia jivi ajibi. ");
INSERT INTO guh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Itsiata jivi ayaibitsaëtoxaneto pëtanetsi Jesús peponaejava. Nexata itsabelia Jesús pona, matatsënëa pënacujinaerubenatsi daxita tomaranëpijivi. Caranata Jesús pevajënaeyabelia pata bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Itsa baja Jesúsbana nonobajunaya jeravecua, Jesús tane jivibitsaëtoxaneto. Nexata Jesús bajarapamonae itaxutobejiobiatane. Nexata Jesús bajarapamonae sivajamatabëjumaitsi mapacueniaje: —Pacuenia baitsi ovejabitsaëtoxaneto itsa toajibitsi pevetsinëtsi, bajara itsi mapamonaeje, sivajamatabëjai Jesús. Nexata Jesús ayaicuenia livaisi tsipaeba bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Itsa baja bitso caniviyotsia, Jesús pijajivi cujibarenatsi. Jumaitsitsi: —Caniviyo rabaja bitso. Majota ajibi pexaejava. Tsipaji itsajivi ata pijabo apo xainae. ");
INSERT INTO guh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Itorobare baja jivi peponaenexa imoxoyo penaetomaranëjavabelia pecomuacaenexa pexaejava, jaitsi Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús nexata jumaitsi pijajivijavabelia: —Paxamë parajure pexaejava, jai. Nexata Jesús pijajivi jumaitsi: —¿Paponaenajë tsaja tomarabelia patacomuatsinexa pan doscientos denariota bajarapamonae pexaenexa? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús icatsia jumaitsi pijajivijavabelia: —¿Detsa papanbëbeje paxainame paxamë? Pataema copiata, jai Jesús. Jesús pijajivi petaecujinae tsipaeba Jesúsjavabelia. Jumaitsi: —Paxainajë saya cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nexata Jesús itoroba daxitajivi penaenexa ponajavata. ");
INSERT INTO guh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nexata bajarapamonae pepobitsaëtonë natsanaeya ena. Caebitsaëtota enapona cien pajivibeje. Itsabitsaëtota enapona cincuenta pajivibeje. Bajarapacuenia caebitsaëto canacujitsia enapona. ");
INSERT INTO guh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nexata Jesús pita cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava. Athëbëa benaëcotsia. Jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pataxaejava, jai Jesús. Bajaraxuacujinae Jesús pan epatsicacapona. Pijajivijavabelia rajutapona pepatsicacaejava. Nexata juya Jesús pijajivi pan tsicobetsana jivijavabelia. Dujuaijavaxi ata tsicobetsana jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Daxita xaniavaetsia nabane. ");
INSERT INTO guh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bajaraxuacujinae Jesús pijajivi caetuata pan, dujuai yajava, jivi peyajuvënëcopabejebijavanë. Nexata vënëba doce xuabeje bemapirecuenia pexanaejavanë. ");
INSERT INTO guh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pamonae pexaejava xane, ayaibitsaëtoxaneto. Itsiata ëpebijivi namataëjëtatsi cinco mil ponëbeje. ");
INSERT INTO guh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús jivi ayaibitsaëtoxaneto pexaejava perajutsicujinae, Jesús pijajivi bepijia runaeyaexanareca jera ënëabereca. Jesús pijajivi copiata itoroba penicabinexa puca itsapanabelia, Betsaida tomarabelia. Jesús baja jivi naviabiaexana. Bajaraxuata abaxë caenë nacopatanuca bajarajota. ");
INSERT INTO guh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Itsa baja jivi napëvereta penaviabijava, Jesús junaya petsutojumabetsia pevajëtsinexa Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Itsa baja bitso meravi, Jesús pijajivi pucaxaneto itapavecua tajë baja yanajetarubenalia. Jesús abaxë bajarapaepatota caenë nacopatanucarena pucaxanetoitapatarena. ");
INSERT INTO guh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nexata Jesús tane pijajivi petoayapëbejejavatsi pevaetsijava. Tsipaji bitso joviboxaneto ayai pevajënaeverena. Bajaraxuacujinae bajayacunua, ajena matacabijitsia, Jesús pijajivi pecovëvelia imoxoyotanajetaruca. Jesús najetaruca mene itaboxoya. Rovia picani xenetsijitsia. ");
INSERT INTO guh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesús pijajivi itsa tanetsi mene itaboxoya penajetarucaejava, Jesús pijajivi jamatabëjumaitsi: —¡Petëpaenëmi raeta pejumape najetaruca! jamatabëjai. Nexata Jesús pijajivi vavajai tsaxuabi ayaijumeta. ");
INSERT INTO guh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tsipaji daxita Jesús pijajivi tane bajarapacuenia penajetarucaejava. Nexata Jesús pijajivi jamatabëcuenenajunaviaca. Nexata Jesús bepijiayo jumaitsi pijajivijavabelia: —Xanë raja. Pëtsa panecujunavame. Pajamatejemamëre saya, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nexata baja Jesús nonolia bajarapajera ënëabelia. Ajibi baja tsaxuabi jovibo. Nexata Jesús pijajivi pinijicuenia jamatabëcuenenajunaviaca. Tsipaji tane jovibo, malataca yajava, Jesús piajibiaexanaejava. ");
INSERT INTO guh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús baja picani pijajivi copiaya tane, pan tsiquirijavayomi ata, jivibitsaëtoxanetojavabelia Jesús perajutsijava. Itsiata Jesús pijajivi apo jamatabëcueneyapëtae Jesús pecaëjëpaenëcuenetsi pinijicuene pexanaenexa. Abaxë bajarapamonae ajamatabëcuenetaja. ");
INSERT INTO guh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús pijajivi jerata yajavapata puca itsapanabelia. Pata Genesaret nacuayabelia. Peyapatsijera bajarajota puca itapata querataruta. ");
INSERT INTO guh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nexata Jesús, pijajivi yajava, nonotajunaya jeravecua. Bajarajota bepijia jivi yapëtanetsi Jesúscuene. ");
INSERT INTO guh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nexata Jesús pepatsijava penatsipaebinexa, navajunucacujinaejinaruta daxita bonëjava. Nexata piavitanevi pijacamaxita yavëtacarapatatsi itsajota jivi jumetane Jesús pepatsijava. ");
INSERT INTO guh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús pata tsiquiritomaraxijava, pinijitomaranëjava ata, tomarapënëya penaebonëjava ata. Daxitajava, itsa patomarata Jesús patabiaba, bajarapatomaranëjava callejavata, jivi tojebabiabatsi piavitanevi. Piavitanevi pecapatsivi pinijicuenia jumai tsabiabi Jesúsjavabelia: —Pexaniacuene bitso netoexanare. Tocopatsianame maponëje pecatojayatsinexa nenaxatatsijavacopia, jai tsabiabi. Nexata daxita pamonae Jesús penaxatatsijavacopia tojayataponatsi, jamatejema baja tsaponae piavitanejavamivecua. ");
INSERT INTO guh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Daxita judíovi catsiteca pijasalinaivimi pijacuene. Judíoviyajuvënëvi, pamonae fariseovi naexana, bajarapamonae bitso catsiteca pijasalinaivimi pijacuene daxita judíovi matatoxenetsia. Jamatabëcuenenavëxaniabiaya jamatabëjumai tsabiabi: —Itsa catsitecajë tajasalinaivimi pijacuene, nexata Dioso aneconijibia netaena, jamatabëjai tsabiabi. Nexata bajarapamonae pijasalinaicuenia anijatonë xaniavaetsia itsa apo napënanacobequiatsi, pexaejava apo xaeyabiabi. Itsajota pexaejavacuene canajetabiaba, bajaraverena itsa naviaba pecomuacaecujinae, bajarapamonae pijasalinaicuenia xaniavaetsia itsa apo napënanacobequiatsi, pexaejava apo xaeyabiabi. Bajarapamonae pematatsënëa navitsia itsacujiruxi ata, pijasalinaivimi pijacujiru, catsiteca. Bajarapamonae tazaxi, mera peyajebinëanë ata, pecasetsinëanë ata, camanë ata, pijasalinaivimi pijacuenia xaniavaetsia quiatabiaba. Nexata judíovi pecujarubivi Jerusalén tomaraverena pata. Nexata judíovi pecujarubivi, fariseovi yajava, cujibarenatsi Jesús. Nexata bajarapamonae tane Jesús pijajivi judíovi pijasalinaicuenia anijatonë napënanacobequiatsinejeva penabanijava. Bajaraxuata bajarapamonae jumaitsi Jesúsjavabelia: —Jesús, nijajivi naneconita Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsipaji nijajivi apo jumecovënëtsiajinavanapae vajasalinaivi pijacuene. Nijajivi itsa xane pexaejava, anijatonë napëna apo nacobequiatabiabi, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús nexata jumaitsi bajarapamonaejavabelia: —¡Paxamë saya jivi paneyamaxëitojorobivi! Diosojumelivaisipaebinëmi profeta Isaíaspijinë baja cajena bajayata tajëvelia xaniavaetsia pacavajunupaeba. Bajayata Dioso tajëvelia pejumaitsijava paxamë yabara profeta Isaíaspijinë peyaquinaelivaisita jumaitsi mapacueniaje: Bajarapamonae nejitsipaena saya pijumeta. Itsiata pepo tanejitsipaejamatabëcuene nevecuatajë tsane. ");
INSERT INTO guh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Saya baitsi bajarapamonae pijajumaitsita tsane: “Pacajitsipatsi,” nejai itajara tsane. Itsiata apo xaniajai tsane. Bajarapamonae saya jivi tsipaebaponaena pejamatabëcuenepijilivaisi. Pepo taitorobilivaisi apo tsipaebi tsane, jai tajëvelia Dioso pejumaitsijava paxamë yabara Isaíaspijinë peyaquinaelivaisita, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesús icatsia jumaitsi fariseovijavabelia, judíovi pecujarubivijavabelia ata: —Paxamë Dioso papecaitorobicuenia apo paexanaemë. Caranata ëvajasalinaivi pijacuene pacatsitecame. Nexata vajasalinaivi pijacuenia xaniavaetsia paquiatabiabame mera peyajebinëanë. Xaniavaetsia paquiatabiabame tazaxi ata. Pematatsënëa navitsia itsacujiru ata pacatsitecame. ");
INSERT INTO guh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Apo pajumecovënëtsimë Dioso pitorobilivaisi vajasalinaivi pijacuene panecatsitecaenexa. Apo pajumecovënëtsi atamë Dioso pitorobilivaisi, jamatabëcuenenavëxaniabiaya pajamatabëjumaitsimë tsabiabi: “Pexaniacuene raja exanajë,” pajamatabëjamë tsabiabi. ");
INSERT INTO guh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bajayata Dioso najumecopata Moiséspijinëta. Bajarapalivaisi jumaitsi: “Axa yaiyataema. Ena ata yaiyataema. Pajivi pibisiacuenia bijatane paxa, pena ata, bajarapajivi pabeyaxuare,” jai Dioso Moiséspijinëta penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Itsiata baitsi jane paxamë jivi pamuxubijiapenetabiabame peyaiyataeyaniva paxajivi, penajivi ata. Paxamë pajumaitsimë tsabiabi mapacueniaje: “Axa, ena ata, itsa cavajëta neyavenonaenexa, nexata itsa apo jitsipaemë neyavenonaejava, jumaitsimë tsane mapacueniaje: ‘Daxita xua pacarajutsipatsibeje picani patacayavenonaenexabeje, daxita bajaraxua tsipaebajë baja tarajutsinexa Diosojavabelia. Nexata baja acuenebi patacarajutsinexabeje,’ jamë tsane neyavenonaeyaniva,” pajamë tsabiabi jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nexata caranata Dioso pejumaitsijume: “Axa yaiyataema. Ena ata yaiyataema,” pejaijume, paxamë jivi pacopabiaexanaponame. Tsipaji paxamë patsipaebaponame saicaya vajasalinaivimi pijalivaisi. Itsalivaisianë ata pematatsënëa saicayacuenia patsipaebaponame Dioso pitorobilivaisivecua, jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nexata icatsia Jesús junata jivi. Jumaitsi jivijavabelia: —Daxita paxamë panenamuxunaevere xaniavaetsia patanejumeyapëtaenexamë. ");
INSERT INTO guh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Xua jivi pecuibota xane, pexaevajënae napëna anijatonë apo nacobequiatsi ata, apo jamatabëcuenebijianaetsi. Apo vënananeconitsi Diosojavabelia. Baitsi rajane xua jivi najamatabëxaina pejamatabëëthëtovetsina, xua ata pibisiacuenia cuaicuaijai, bajara baitsi jane xua jivi bajamatabëcuenebijianatsi. ");
INSERT INTO guh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Itsa baja Jesús jivivecua natixita, boya joneya. Nexata boyalia pijajivi yanijobatsi bajarapalivaisi. ");
INSERT INTO guh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nexata Jesús jumaitsi pijajivijavabelia: —¿Paxamë ata tsarovia abaxë apo panejumeyapëtaemë? Daxitacuene raja pexaejava jivi xae ata, apo jamatabëcuenebijianaetsi. Diosojavabelia apo vënananeconitsi. ");
INSERT INTO guh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tsipaji raja jivi pexaejava apo tsijamatabëëthëjonetsi. Saya pënëareca joneca. Bajaraxuacujinae icatsia vecuapitsapatsi, jai Jesús. Bajarapacuenia Jesús jumaitsi Jesús pijajivi peyapëtaeyaexanaenexa pacuenia daxitacuene jivi pexaejava xae ata, apo pibisiacuene. ");
INSERT INTO guh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Icatsia Jesús jumaitsi: —Baitsi rajane jivi pejamatabëëthëtojavavetsina, papibisiajamatabëcuene pitsapa, bajara baitsi jane xua jivi jamatabëcuenebijianatsi. ");
INSERT INTO guh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsipaji rabaja jivi pejamatabëëthëtojavavetsina pitsapa pibisiacuene penajamatabëxainaenexa. Pitsapa pebi pijava pevecuanamatayajitsi jamatabëcuenenexa. Pitsapa petiriavijavabelia pebi penaperabëquenetsiatae jamatabëcuenenexa. Pitsapa jivitonë pebeyaxuabijamatabëcuenenexa. ");
INSERT INTO guh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pitsapa penacobetoxotsijamatabëcuenenexa. Pitsapa itsamonae pecobecovë penaxainaeyabijamatabëcuenenexa. Pitsapa piacujirubejejamatabëcuenenexa. Pitsapa itsamonaejavabelia peyamaxëitojorobijamatabëcuenenexa. Pitsapa itsamonae pexainaecuene pecobecaëbijamatabëcuenenexa. Pitsapa itsajivi pibisiacuenia pebaracuaicuaijai jamatabëcuenenexa. Pitsapa ayaijamatabëcuenejivi penataejamatabëcuenenexa. Pitsapa saya jema peponaponaejamatabëcuenenexa. ");
INSERT INTO guh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Daxita bajarapajamatabëcuene jivi pejamatabëëthëtojavavetsina pitsapa. Nexata bajarapacuene jivi jamatabëcuenebijianatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús baja Genesaret nacuavecua pona. Naropota itsanacuayabelia, itsabelia eca anijatomarabeje, Tiro tomarabeje Sidón tomarabeje. Nexata Jesús bajarapanacuatalia bota patajopa. Muetsia picani Jesús patsijitsia. Itsiata acuenebi muetsia pepatsijava. ");
INSERT INTO guh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nexata bepijia petiriva vënëlivaisitaetabatsi Jesús pepatsijava. Nexata petiriva pata Jesúsjavaberena. Nexata bajarapova yaiyataeya Jesús pitabarata pematabacabëta nucajunua. Bajarapova pexënatoyo dovathi yajavaponapona. ");
INSERT INTO guh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bajarapova sirofeniciaviriava, apo judíova. Nexata Jesúsjavabelia jumaitsi: —Pexaniacuene bitso netoexanare. Taxënatovayo netovecuacapitsapare dovathi, jai bajarapova. ");
INSERT INTO guh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nexata Jesús jumaitsi bajarapovajavabelia: —Copiaya abaxë veyavenonajë tajanacuapijivi, judíovi. Tsipaji apo xanepanae xamë itsanacuapijivamë copiaya tacayavenonaenexa. Xamë copiaya itsa cayavenonaejitsipatsi, nexata pacuenia pejevaxi pexaejavaminexa yacajërëtsipajë tarajutsinexa avirixijavabelia, bajara itsinë tsipae, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Itsiata baitsi jane bajarapova ajumesaë tsaponae. Icatsia jumaitsi Jesúsjavabelia: —Xaniajamë rabaja picani. Itsiata neyavenonare. Tsipaji avirixi ata mesa bëxëpanata itsa nubena, nexata pejevaxi pexaepanpërë itsa othopareca mesa bëxëpanareca, banaxane avirixi ata. Bajara pijinia pacuenia itsiata itsanacuapijiva atanë, neyavenonare, jai bajarapova Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nexata icatsia Jesús jumaitsi bajarapovajavabelia: —Xaniavaetsia nejumecanaviatame. Naviare baja nijaboyabelia. Dovathi rabaja catovecuapitsapatsi nexënatovayo, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Itsa baja bajarapova pijaboyabelia pata, pexënatovayo taeyabuata jamatejema baja pebocaejava camata. Nexata yapëtane pexënatovayo baja petovecuapitsapaejavatsi dovathi. ");
INSERT INTO guh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús baja naropota Tiro nacuavecua. Najetaruca Sidón nacuajava. Bajaraxuacujinae najetaruca Decápolis nacuajava. Bajaraxuacujinae patajopa Galilea pucaxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bajarajota jivi tocapatatsi siyanë, bitso apo pejumetaenë, piajumecëcënë. Nexata bajarapamonae jumaitsitsi Jesúsjavabelia: —Jesús, pexaniacuene panetoexanare. Panetojayare maponëje pejumetaenexa, pecuaicuaijainexanua, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nexata Jesús jivivecua bajaraponë barëpona pesaicaeyojavabelia. Nexata Jesús pecobesitota namataenetsia muxuvojobëta. Bajaraxuacujinae nacobesioniata. Ebarëtojayata. ");
INSERT INTO guh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nexata Jesús athëbëa benaëcotsia. Jesús athëbë venajumalixuabica. Nexata Jesús pijajumeta jumaitsi bajaraponëjavabelia: —¡Efata! jai. “Efata,” pejaijume Jesús pijajumeta, mapajumetaje pejumaitsijume: “¡Muxuvojorucaremelia!” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bajarapacuenia Jesús pejumaitsijavata, bajaraponë muxuvojorucalia baja. Jumetane jane baja. Peebarëto ata jane baja xanepana. Natsipaeba baja xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nexata Jesús jumaitsi bajaraponë petocapatsivitsijavabelia: —Pëtsa papaebame itsamonaejavabelia pacuene exanajë maponëjavabeliaje, jai picani Jesús asaëyata. Itsiata bajarapamonae jumeitavetsi atatsi, bitso tsipaebapona jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nexata pamonae jumetane bajarapalivaisi, pinijicuenia jamatabëcuenenabenajaca. Bajarapamonae jumaitsi: —Bajaraponë, Jesús, daxitacuenevitane pexainaevi ata xaniavaetapona. Siyavi ata, bitso apo pejumetaevimi ata, jumetaeyaexanapona. Apo pecaëjëpaevitsi ata pecuaicuaijaijava, cuaicuaijaiyaexanapona xaniavaetsia, jai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Itsamatacabi Jesús jivibitsaëtoxaneto muxunanacaetuatatsi. Nexata bajarapamonae penabaninexa, bajarajota pexaejava apo xainae. Nexata Jesús junata pijajivi. Jesús jumaitsi pijajivijavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Netsitabejiobi baja rovia mapamonaeje. Tsipaji baja ajena acueyabi pamatacabibeje xaina xanëjavata pejinavanapaecujinae. Pemarue baja tovereverecatsi. ");
INSERT INTO guh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Itsa meta itorobijitsipajë pijabonëjavabelia peponaenexa pexaejava xaenejeva, apo asaë meta tsipae namutua peponaejava. Tsipaji raja itsamonae pata tajëverena, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nexata Jesús pijajivi jumaitsi: —¿Detsa jane pacuenia pexaejava berajutatsi? Majotaje ajibi pexaejava. Tsipaji itsajivi ata pijabo apo xainae, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nexata Jesús yanijoba pijajivijavabelia. —¿Detsa papanbëbeje paxainame? jai. Nexata Jesús pijajivi jumaitsi: —Siete papanbëbeje paxainajë, jai. ");
INSERT INTO guh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nexata Jesús itoroba daxitajivi penaenexa irata. Nexata Jesús pita siete papanbëbeje. Nexata Diosojavabelia Jesús jumaitsi: —Pexaniacuene panetoexaname. Panerajutame pataxaejava, jai. Bajaraxuacujinae Jesús epatsicacapona pan. Nexata Jesús pepatsicacaepan rajutapona pijajivijavabelia. Nexata juya Jesús pijajivi bajarapapan tsicobetsana daxitajivi pexaenexa. ");
INSERT INTO guh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dujuainëxinua xaina. Icatsia Jesús jumaitsi Diosojavabelia dujuainëxi yabara: —Pexaniacuene panetoexaname. Panerajutame dujuainëxi, jai. Nexata icatsia pijajivi itoroba petsicobetsanaenexa daxitajivi bajarapadujuainëxi. ");
INSERT INTO guh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Daxitajivibitsaëtoxaneto nabane xaniavaetsia. Nexata peyajuvënëcopabijavanë Jesús pijajivi caetuata. Vënëba siete xuabeje bemapirecuenia pexanaejavanë. ");
INSERT INTO guh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pexaejava nabane bejamatabëcuene cuatro mil pajivibeje. Nexata jane baja pexaejava pexaecujinae, Jesús jivi naviabiaexana pijabonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bajaraxuacujinae Jesús, pijajivi yajava, runareca jera ënëabereca. Jesús pijajivi barëpona Dalmanuta nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseovi Jesúsjavaberena pata. Bajarapamonae jamatabëcueneëjëbiaya jumenotaponatsi. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Jesús, Dioso pesaëta pinijicuene exanare. Nexata pacacueneyapëtaenatsi Dioso pepacuene athëbëvetsica pecaitorobinëcuenetsica, jai. ");
INSERT INTO guh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nexata bajarapamonae yabara Jesús bitso jamatabëcuenebëjai. Nexata Jesús athëbë venajumalixuabica. Jumaitsi: —¿Detsa xuajitsia panevajëcame pinijicuene patacatsitaexanaenexa pataneyapëtaenexamë pepacuene Dioso athëbëvetsica taneitorobinëcuenetsica. Xaniajanë pacuenia pacatsipaebijitsiatsi. Itsiata apo pacatsitaexanaetsi tsane pinijicuene taexanaejava, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nexata baja Jesús bajarapamonae vecuapona. Icatsia runareca jera ënëabereca. Pucaxaneto itsapanabelia baja Jesús pona. ");
INSERT INTO guh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús pijajivi nacofënëta pemarue. Nexata saya caepanbëyo capona jerata. ");
INSERT INTO guh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nexata Jesús pijajivi muxujioba pejumecovënëtsiyaniva fariseovi itsa tsipaebatsi saicayacuenia Dioso pejumelivaisivecua. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Panejumetaema. Xania panayajivitaema fariseovi pijalevadura, jai Jesús pijajivijavabelia. Bajarapacuenia Jesús jumaitsi fariseovi petsipaebilivaisi, nacuaevetsinë ata, Herodes, petsipaebilivaisi, Jesús pijajivi pejumecovënëtsiyaniva. ");
INSERT INTO guh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Itsiata Jesús pijajivi apo jumeyapëtaetsi. Bajaraxuata Jesús pijajivi nabarëcuaicuaijai bajarapacuenia Jesús pejumaitsijume yabara. Jesús pijajivi najumaitsi: —Jesús nacajumaitsi: “Xania panayajivitaema fariseovi pijalevadura,” nacajai. Baja raeta pacuenia Jesús nacajumaitsi pan apo vajacaponaexae, najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús pijajivi jamatabëcueneyapëtane bajarapacuenia jamatabëcuenenavëxaniabiaya penajumaitsijava levadura yabara. Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia panajumaitsimë: “Baja raeta pacuenia Jesús nacajumaitsi pan apo vajacaponaexae,” panajamë? Paxamë abaxë apo panejumeyapëtaemë xua yabara pacajumaitsitsi. Pajamatabëcuenetajamë bitso. ");
INSERT INTO guh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pan yabara raja apo pacajumaitsitsi. Pan itsa namatavenonaejitsipatsi, necaëjëpa taexanaenexa. ¿Apo panajamatabënapitsimë tsipaji pacuenia exanajë pamatacabi pan namatavenonatsi? ");
INSERT INTO guh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pacujinae epatsicacajë cinco papanbëmibeje panetsicobetsanaenexa cinco mil ponëbejejavabelia, bajarapacujinae peyajuvënëcopabijavanë, ¿detsa xuabeje pavënëtame bemapirecuenia pexanaejavanë? jai Jesús pijajivijavabelia. Nexata Jesús pijajivi jumaitsi: —Doce xuabeje pavënëtajë, jai. ");
INSERT INTO guh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús icatsia jumaitsi: —Pacujinae epatsicacajë siete papanëmibeje panetsicobetsanaenexa cuatro mil pajivibejejavabelia, bajarapacujinae peyajuvënëcopabijavanë, ¿detsa xuabeje pavënëtame bemapirecuenia pexanaejavanë? jai Jesús. Nexata Jesús pijajivi jumaitsi: —Siete xuabeje pavënëtajë, jai. ");
INSERT INTO guh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nexata Jesús jumaitsi pijajivijavabelia: —¿Panejumeyapëtaneme tsabaja pan yabara apo patacajumaitsijava? Xanë pacajumaitsitsi: “Xania panayajivitaema fariseovi pijalevadura,” pacajaitsi. Bajarapacuenia pacajumaitsitsi panejumecovënëtsiyaniva fariseovi petsipaebilivaisi, panejumecovënëtsiyaniva nacuaevetsinë ata Herodes. Tsipaji bajarapamonae pacatsipaebiana saicayacuenia Dioso pejumelivaisivecua, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús, pijajivi yajava, patajopa Betsaida tomarata. Nexata Jesús tocanajetarubenatsi bitso pitaxutotsëcënaenë, apo petaenë. Pinijicuenia vajëcatsi Jesús pitaxutojayatsinexa bajaraponë pitaxutoxanepanaenexa. ");
INSERT INTO guh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nexata Jesús cobepita. Barëpona pesaicaeyojavabelia, tomarapënëyabelia. Nexata bajarajotalia Jesús peionitota itaxutoexaba. Itaxutojayata. Bajaraxuacujinae Jesús yanijoba. —¿Cacaëjëpa tsabaja netaejava? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nexata bajaraponë naëcota. Jumaitsi: —Taniji pebijivi pejinavanapaejava. Itsiata saya benetsita naejavanë, jai bajaraponë. ");
INSERT INTO guh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nexata icatsia Jesús itaxutojayata. Bajara jane xaniavaetsia naitaxutobabatsiaya naëcota. Itaxutoxanepana jane baja. Xaniavaetsia baja tane. ");
INSERT INTO guh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nexata Jesús jumaitsi bajaraponëjavabelia: —Naviare nijaboyabelia. Pëtsa abaxë poname tomarabelia. Pëtsa paebame itsajivijavabelia ata pacuene caexanatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús, pijajivi yajava, najetaruca. Pona pepatsinexa Cesarea de Filipovënë tomarajumaverena penaetomaraxijavabelia. Namutua abaxë penajetarubenaejavata Jesús jumaitsi pijajivijavabelia: —¿Detsa jivi jumai tsabiabi xanë yabara? ¿De tsaeta xanë ponënë? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nexata Jesús pijajivi jumaitsi: —Itsamonae xamë yabara jumai tsabiabi: “Juanpijinëmi raeta jivibautisabinëmi icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Diosojumepaebinëmi raeta, profeta Elíaspijinë, ponëmi bajayata ponapona, icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Bajayata raeta Diosojumepaebivimi profetavimiyajuvënënë icatsia asaë,” jai tsabiabi xamë yabara, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nexata icatsia Jesús jumaitsi pijajivijavabelia. —¿Detsa nexata paxamë pajamatabëitsimë xanë yabara? ¿Detsa xanë ponënë? jai Jesús pijajivijavabelia. Nexata Pedro jumaitsi Jesúsjavabelia: —Xamë cajena Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenexa, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nexata Jesús pijajivijavabelia jumaitsi: —Pëtsa bajarapacuenia itsajivijavabelia papaebame. “Cristo raja,” pajamë pëtsa xanë yabara, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba pijajivijavabelia. Jumaitsi mapacueniaje: —Xanë, Daxitajivi Pematapijinënë, pinijicuenia bejiobinë tsane. Judíovi pijaancianovi, sacerdotevi penamatacaitorobivinua, judíovi pecujarubivinua, apo nejumecovënëtsi tsane Cristonëcuenenë. Nexata bitso nebejiobiaexanaena. Bajaraxuacujinae nebeyaxuabiana. Itsiata baitsi jane tatëpaecujinae, acueyabi matacabita, icatsia asaënë tsane, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús jumenapebetsiaya pijajivi xaniavaetsia tsipaeba mapajumeje. Nexata Pedro junata Jesús pebarëponatabinexa pesaicaeyojavabelia. Nexata Pedro pesaicaeyojavatalia jumaitsi Jesúsjavabelia: —Pëtsa bajarapacuenia cuaicuaijamë netëpaejavanexa yabara, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nexata Jesús Pedrovecua napënëyorotaxuaba. Taenuca pijajivi penaejavabelia. Nexata Jesús napënëyorotsia jumai tsanucae Pedrojavabelia: —¡Dovathi, nevecuanatixire! Tsipaji xamë apo jitsipaemë pacuenia Dioso jitsipa taexanaenexa. Saya ëjivi pacuenia jitsipa taexanaenexa, jitsipame, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nexata Jesús junata pijajivi, daxita jivibitsaëto yajava. Jumaitsi bajarapamonaejavabelia: —Pajivi jitsipa tanepënaponaejava, bajarapajivi copatsi pejitsipaecuenia pexanaenexa penajamatabëxainabiabijavami. Exanaponaponae taitorobicuenia. Najamatabëcueneveretsinua bejiobiaexanaejitsia atatsi, beyaxuabijitsia atatsinua, Dioso pejumelivaisi yabara piajamatabëcuenesaë tsaponaponaenexa. Nexata jane baja xuacujinae nepënaponaena. ");
INSERT INTO guh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pajivi exanaponapona penatojitsipaecuenia, apo xainae tsane matacabi apo pevereverecaejava. Pajivi xanë tajamatabëcueneta copata penatojitsipaecuenia pexanabiabijavami, jivi tacapanepaelivaisitanexa pejamatabëcuenetanua, bajarapajivi xainaena matacabi apo pevereverecaejava. ");
INSERT INTO guh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pajivi exanaponapona penatojitsipaecuenia, bajarapajivi Diosovecua naxuabiana. Nexata bajarapajivi daxitacuene xainae ata mapanacuapijicueneje, itsiata nacuerata. Tsipaji pexainaecuene apo capanepae tsanetsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tsipaji acuenebi tsane itsajivi ata pematamotsinexa penaxuabiyaniva Diosovecua. ");
INSERT INTO guh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pajivi tajajivitonë ata, Dioso apo pejumecovënëtsivi tuatuajëta, pibisiacuene pexanaevi tuatuajëta ata, navënëlivaisicaura tsane xanë tajajivitonëcuene, tanejumecovënëtsijava ata yabara, nexata juya xanë bajarapajivi, tajajivitonë ata, tajajivitonëcuene vënëlivaisicauranë tsane taxa Diosojavabelia. Bajarapajivi vënëlivaisicauranë tsane pamatacabi icatsia patsianicajë. Baitsi pamatacabi xanë, Daxitajivi Pematapijinënë, ángelevi yajava, patsianicajë, pamatacabi yajavapatsianicajënua taxa Dioso pijapenivenivenaecotia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Icatsia Jesús jumaitsi jivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita paxamë patëpaenejevamë, Dioso taxuxuabiana pijajivi pevetsijava mapanacuataje. Nexata paxamëyajuvënëvi pepuatae tsane Dioso petaxuxuabijava pijajivi pevetsijava mapanacuataje, tëpaena. Dioso raja pijajivi evetsiana pinijijamatabëcuenesaëta, jai Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jesús petëpaejavanexa tajëvelia penavajunupaebicujinae, seis pamatacabibejecujinae, Jesús pijajivi, acueyabi ponëbeje, barëpona pinijitsutoxanetojumabetsia. Jesús barëjunaya mapamatabëxëyoje: Pedro, Santiago, Juan. Bajarapamatabëxëyo Jesús barëjunaya pinijitsutoxanetojumabetsia. Nexata petsutojumatatsia Jesús perabënivenivena bajarapamonae pitabarata. ");
INSERT INTO guh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jesús penaxatatsijava bitso nivenivena. Bitso niojai. Mapanacuataje pexaniaquiatsiva ata apo caëjëpaetsi bajarapacuenia peniojaiyaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jesús pijajivi bajarajota tane jemata penaitajëtsijava bajayata petëpaenëmibeje, Elíaspijinëbeje Moiséspijinëbeje. Jesús barëcuaicuaijaitsi bajaraponëbeje. ");
INSERT INTO guh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nexata Pedro jumaitsi Jesúsjavabelia mapacueniaje: —¡Patajatuxanenë, pijacuaxae panebarëponame! Pacatoexanaenatsi acueyabi pabobërëtobeje. Itsabobërëto xamënexa tsane. Itsabobërëto Moisésnexa tsane. Itsabobërëto Elíasnexa tsane, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bajarapacuenia Pedro jumaitsi Jesúsjavabelia canaëjëtsinejeva. Tsipaji bitso bajarapamonae najunaviaca. Nexata apo yapëtae pacuenia jumaitsijitsia. ");
INSERT INTO guh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nexata daxita bajarapamonae pematatsënëvetsica itarërëbo mataacataxuabatsi. Nexata bajarapamonae jumetane bajarapaitarërëbojavavetsica Dioso pejumaitsijava. —Mara ponë taxënato, tasivanëje. Panamuxunaevere bajaraponë, jaitsica Dioso Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bajarajota bajarapamonae itsa naëcobarëcëpalia Jesúsjavabelia, ajibi baja bajaraponëbeje. Caenë baja Jesús nuca. ");
INSERT INTO guh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nexata Jesús pijajivi itsa barërunanucaponaica petsutojumavetsica, jumeitaveta pijajivi. Jumaitsi pijajivijavabelia: —Pëtsa patsipaebame itsajivi ata pacuene pataneme. Matapania xanë, Daxitajivi Pematapijinënë, icatsia asaënë tsane tatëpaecujinae, nexata jane baja matapania patsipaebianame, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bajarapamonae, acueyabi ponëbeje, jumecovënëta pejumaitsicueniatsi. Itsiata ëpamonae nayanijobabiaba. —Jesús jumai tsabiabi: “Tatëpaecujinae icatsia asaënë tsane,” jai tsabiabi. ¿De tsamëra pajamatabëcuene xaina bajarapalivaisi? najai tsabiabi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nexata Jesús pijajivi yanijoba Jesúsjavabelia. Jesús pijajivi jumaitsi: —Patajatuxanenë, ¿detsa xuajitsia judíovi pecujarubivi jumai tsabiabi: “Bajayata ponëmi ponapona, Elíaspijinë, petëpaecujinae icatsia asaë tsane. Bajaraponë copiata patsiana. Bajaraxuacujinae patsiana Cristo, ponë Dioso athëbëvetsica itorobijitsiatsica pepo vajanacacapanepaenënexa jane baja,” jai tsabiabi? jai Jesús pijajivi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nexata Jesús jumaitsi pijajivijavabelia: —“Copiata Elíaspijinë patsiana. Nexata bajaraponë jamatabëcuenexanetsiana daxitajivi,” itsa jai, Juanpijinëmi jivibautisabinëmi yabara jumaitsi. Nexata baja xaniajai pacuenia judíovi pecujarubivi jumaitsi. Tsipaji baja Juanpijinë tavajënaeya jivi jamatabëcuenexanetanajetaruca. Xanë, Daxitajivi Pematapijinënë, athëbëvetsica Dioso nitoroba jivi tacapanepaenexa. Nexata xanë yabara tajëvelia Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: “Bejiobi tsane pinijicuenia. Apo jitsipaetsi tsane. Naitaxutojematsianatsi,” jai xanë yabara tajëvelia Dioso pejumelivaisibaxutota, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jesús icatsia jumaitsi pijajivijavabelia Juanpijinëmi yabara: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Elíaspijinë rabaja patajopa. Pepatsicujinae baja exanatsi daxita pacuenia jamatabëexanatsi. Nexata exanatsi pacuenia baja cajena Dioso pejumelivaisibaxutota tajëvelia jumaitsi bajaraponëmi yabara, jai Jesús pijajivijavabelia Juanpijinëmi yabara. ");
INSERT INTO guh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús pijajivi, acueyabi ponëbeje, petsutojumabetsia pebarëponaecujinae, icatsia barënaviatsica. Itsamonae Jesús pijajivi pepuenetsivijavabetsica, barënaviatsica. Nexata Jesús tane pijajivi jivibitsaëtoxaneto pevajënae pematatoyoronaejavatsi. Jesús tanenua judíovi pecujarubivi anaeya pejumenotsijavatsi Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nexata bajarapamonae itsa taerëcëpa Jesús, daxita jamatabëcuenebarëyaya cujinaeyeca Jesúsjavabelia pebajacobinexatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Detsa xua yabara panajumeanaenotame pinijicuenia? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Caenë bajarapajivi bitsaëtoxanetoyajuvënënë jumaitsi Jesúsjavabelia: —Jesús, mara picani taxënatonëyo, dovathi peyajavaponaponaenëyo, catocanajetarucatsije. Maponëyoje dovathi apo netonatsipaebiaexanaetsi. ");
INSERT INTO guh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Itsa raja dovathi vaetababiabatsi, irata xuababiabatsi. Nexata bajarajota pecuibothamu tsabiabi. Vonoquiraquirajainua tsabiabi. Daxitanëyo aperabëbaba tsatababiabireca. Picani raja nijajivijavabelia jumaitsinë: “Panetovecuacapitsapare dovathi,” janë. Itsiata bajarapamonae apo caëjëpaetsi tanetovecuacapitsapaenexa, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús nexata jumaitsi pijajivijavabelia: —¡Paxamë baja rovia apo pajumecovënëtsimë Dioso papecayavenonaejavanexa! Bajaraxuata apo pacajamatabëcuenecaëjëpae pejevaxinë panevecuacapitsapaenexa dovathi. ¿Detsa paepatojebi abaxë paxamëjavata ponaponaenajë? ¿Detsa paepatojebi abaxë paxamëjavabelia ajamatabëcuenesaënë tsaponaponae tsane patanejumecovënëtsinexamë? Panetocarenamëre pejevaxinë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nexata tocarenatsi Jesús pejevaxinë. Dovathi itsa tanetsi Jesús, nexata icatsia bajarajota dovathi pejevaxinë tëpajoneyaexanatsi. Irata xuabatsi pejevaxinë. Nexata pejevaxinë natorenaba irata. Pethamu pitsapa pecuibuatsina. ");
INSERT INTO guh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nexata Jesús yanijoba pejevaxinë paxajavabelia. —¿Detsa pamatacabibeje xaina petaxuxuabicujinaetsi mapacueneje? jai Jesús. Nexata pejevaxinë paxa jumaitsi: —Penacuetojavaveliacujinae cajena taxuxuabatsi. ");
INSERT INTO guh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bajayajebi picani isotojavalia dovathi netoxuababiabaliatsi. Menialia ata netoxuababiabaliatsi. Beyaxuabijitsiatsi bajarapacuenia. Xamë itsa cacaëjëpa itsacuenia ata taneyavenonaenexamë, ¡nitaxutotsoniataema! ¡Neyavenonare! jai pejevaxinë paxa Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nexata Jesús jumaitsi pejevaxinë paxajavabelia: —Pajivi jumecovënëta Dioso peyavenonaejavanexatsi, bajarapajivi Dioso yavenonatsi daxita xua namatavenona, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nexata pejevaxinë paxa aëjai. Jumaitsi: —¡Jumecovënëtajë baja cajena! ¡Neyavenonare bitso orijibia tajumecovënëtsinexa! jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nexata Jesús itsa tane jivibitsaëtoxaneto penacaetuataponaejava Jesúsjavaberena, nexata Jesús itaveta dovathi. Jumaitsi: —Dovathi, xamë pejevaxinë apo nenatsipaebiaexanaenë. Apo nejumetaeyaexanaenënua. Xanë caitavetatsi. Pitsapare mapapejevaxinëvecuaje. Pëtsa baja icatsia junuame matavëjëa maponëyojavaberenaje, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nexata dovathi pejevaxinë icatsia aëjaiyaexanatsi. Tëpajoneyaexanatsi. Vecuapitsapatsi jane baja. Puenetabuatatsi bepetëpaenëyo. Nexata itsamonae bajarajota jumaitsi: —Pejevaxinë rabaja tëpa, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nexata Jesús cobepita pejevaxinë. Cobevaetabiaya yotsina. Nexata pejevaxinë nonotabapuna. ");
INSERT INTO guh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nexata xuacujinae Jesús boya itsa joneya, Jesús pijajivi jumaitsi: —¿Detsa xuajitsia meta paxanë apo panecaëjëpae patavecuacapitsapaenexa dovathi? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nexata Jesús jumaitsi pijajivijavabelia: —Mara paviria dovathije apo jitsipae pepitsapaejavaje. Matapania panexaejava apo paxaemë tsipae panevajëtsinexa asaëyata Diosojavabelia panecapitsapaenexa dovathi, pitsapaejitsipa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús pejevaxinë dovathi pevecuacapitsapaecujinae, Jesús baja, pijajivi yajava, pona. Nexata Jesús, pijajivi yajava, najetaruca Galilea nacuajava. Jesús jitsipa pijajivi pebarënajetarucaenexa bajaraxuayo itsajivi ata yapëtaenejevatsi. ");
INSERT INTO guh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tsipaji Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaebapona pijajivijavabelia. Jumai tsaponae Jesús pijajivijavabelia mapacueniaje: —Xanë, Daxitajivi Pematapijinënë, necanajetsiana itsamonae pecobeyabelia. Bajarapamonae nebeyaxuabiana. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane, jai tsaponae Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Itsiata pijajivi apo jumeyapëtaetsi. Bajarapamonae ajumeura Jesúsjavabelia peyanijobinexa bajarapalivaisi yabara. ");
INSERT INTO guh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús pijajivi barëpata Capernaum tomarata. Jesús pijajivi pebarëpatsicujinae, boyalia itsa barëjoneya Jesús, yanijoba pijajivijavabelia. —¿Detsa pitsicuene yabara namutua bitso panajumenotanajetarubename? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nexata Jesús pijajivi moya. Tsipaji Jesús pijajivi namutua najumaitsi tsanajetarubenae: —¿Detsa ponë vaxaitsiyajuvënënë nacavecuaayaijamatabëcuenenë bitso? najai tsanajetarubenae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nexata Jesús eca. Junata pijajivi, doce ponëbeje. Jumaitsi pijajivijavabelia: —Pajivi jitsipa ayaijamatabëcuenejivi penaexanaenexa daxitajivi matatoxenetsia, bajarapajivi beveliajamatabëcuenejivi natae peyavenonaenexa daxitajivi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bajaraxuacujinae Jesús cobepita pejevaxinëyo. Pijajivi pitabarata nuteta. Bajaraxuacujinae Jesús isapita. Jumaitsi pijajivijavabelia: ");
INSERT INTO guh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pajivi copiapita tanejumecovënëtsijiviyo, mapitsipejevaxinëyo ataje, xanë taniji tanecopiapitsijava. Pajivi necopiapita, ëxanë apo necopiapitsi. Ponë nitoroba, neyajavacopiapita, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jesús pijajivitonë, Juan, jumaitsi Jesúsjavabelia: —Tajatuxanenë, pataniji itsanë nevënëta dovathi jivivecua pecapitsapaejava. Itsiata bajaraponë apo paxanëyajuvënënë. Nexata paitavetajë bajaraponë dovathi jivivecua pecapitsapaponaejava, jai Juan. ");
INSERT INTO guh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nexata Jesús jumaitsi Juanjavabelia: —Pëtsa paitavetame bajaraponë. Tsipaji raja pajivi pinijicuene pexanaejava exana tavënëta, bajaraxuacujinae acuenebi bajarapajivi tanebaranatsipaebinexa pibisiacuenia. ");
INSERT INTO guh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsipaji raja pajivi pibisiacuene apo najamatabëxainae vaxaitsijavaberena, bajarapajivi nacajamatabëcueneyavenona. Bajarapajivi bevaxaitsijamatabëcuenejivi. ");
INSERT INTO guh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pajivi tsiquirijavayo ata mera pacarajutsiana paneapaenexa patajajivixaemë, bajarapajivi pepacuene Dioso matamotsianatsi mera papecarajutsimatamo, jai Jesús Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Icatsia Jesús jumaitsi pijajivijavabelia: —Pajivi pibisiacuene exanaeyaexanaejitsipa mapitsipejevaxijivixi ataje, tanejumecovënëtsiyajuvënëjiviyo, bajarapajivi Diosojavabelia bitso naneconitsipa. Nexata Dioso ayaicuenia naneconitsiaexanaejitsipatsi. Nexata pajivi najamatabëxaina pibisiacuene pexanaeyaexanaenexa tanejumecovënëtsivijavabelia, abaxë pibisiacuene exanaeyaexanaenejeva, bajarapajivi bevësicëtatsi ibotoxanetojavabelia. Nexata bajarapajivi yamaëya, ibotoxaneto yajava, bexuarecatsi pucaxaneto tuatuajëareca. Bajarapajivi bexuarecatsi bitso penaneconitsiyaniva Diosojavabelia pibisiacuene itsa exanaeyaexana tanejumecovënëtsiviyajuvënëvi. ");
INSERT INTO guh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bajaraxuata panecobeta pibisiacuene itsa paexaname, panacobecaucure. Itsiata xanepana panejonenexa cobemataxucaeya apo pevereverecaenacuajavabelia. Biji rajane apo xanepanae tsipae panejonenexa infiernojavabelia anijacobebeje yajava, itsajota isotocotia apo itaxupae caeto ata. ");
INSERT INTO guh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Bajarajota apo tëpae oro, jivivixaevi. Isotocotia ata apo itaxupae caeto ata. ");
INSERT INTO guh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Itsa panetaxuta ata pibisiacuene paexaname, panataxucaucure. Itsiata xanepana panejonenexa taxumataxucaeya apo pevereverecaenacuajavabelia. Biji apo xanepanae tsipae panejonenexa infiernojavabelia anijataxubeje yajava. ");
INSERT INTO guh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Bajarajota apo tëpae oro, jivivixaevi. Isotocotia ata apo itaxupae caeto ata. ");
INSERT INTO guh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Paneitaxutota ata panetaejava yabara pibisiacuene itsa paexaname, panaitaxutocajure. Itsiata xanepana panejonenexa pacaeitaxutojivimë apo pevereverecaenacuajavabelia, Dioso pijanacuayabelia. Biji rabiji apo xanepanae tsipae panejonenexa anijaitaxutobeje yajava infiernojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bajarajota apo tëpae oro, jivivixaevi. Isotocotia ata apo itaxupae caeto ata. ");
INSERT INTO guh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dajubinë jivi itsa beyaxuaba Diosojavabelia ofrendacuenia pevi perajutsinexa, viexaba yajota pevixanepanaenexa. Bajara pijinia pacuenia pejamatabëcuenexanepanaenexa, daxita Dioso pijajivi ata jamatabëcueneëjëbianatsi mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yajo raja xanepana. Itsiata yajo pexaicaejavami itsa ajibi tsipae, apo xanepanae tsipae itsacuenejavayonexa ata. Bajara pijinia pacuenia paxamë ata pajamatabëcueneitsimë tsipae Diosojavabelia, itsa apo pavecuapanepaemë tsipae papecajamatabëcuene ëjëtaponaejava. Nexata pajamatabëcuenesaëmëre panejamatabëcuenexanepanaenexa Diosojavabelia. Pajinavanapare xaniavaetsia itsamonaejavabelia ata, jai Jesús pijajivijavabelia itsajivi ata Jesús pijajivi pibisiacuene pexanaeyaexanaeyaniva. ");
INSERT INTO guh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús baja pona Capernaum tomaravecua. Pona Judea nacuayabelia. Bajaraxuacujinae Jordánmene itsapanabelia, paira, Jesús pona. Bajarajotalia icatsia jivibitsaëtoxaneto pata Jesúsjavaberena. Nexata icatsia Jesús livaisi tsipaeba bajarapamonae. Tsipaji baja cajena Jesús livaisi petsipaebanajetarucaenë. ");
INSERT INTO guh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nexata fariseovi Jesús cujibarenatsi petsipaebilivaisi yabara jamatabëcueneëjëbiaya peyanijobinexatsi. Nexata Jesús bijiaya itsa jumecanaviata, neconitsijitsiatsi. Nexata fariseovi jumaitsi Jesúsjavabelia: —¿Xanepana tsaja penacojiobinë pijava pexuabinexa? jai. ");
INSERT INTO guh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús nexata jumaitsi fariseovijavabelia: —¿Detsa pacuenia bajayata Moiséspijinë pacaitoroba panijavajivi panexuabiyaniva? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nexata fariseovi jumaitsi Jesúsjavabelia: —Moiséspijinë tocopata, ponë pijava jamatabëxuaba, pexuabinexa. Itsiata baitsi jane Moiséspijinë tocopata, ponë pijava xuabijitsia, copiaya petoyaquinaenexa cuyalatobaxuto pijavajavabelia. Nexata ponë pijava xuabijitsia, copiaya pijava toyaquinabiaba pitavetsilivaisi pexuabinexa jane baja pijava. Bajarapacuenia pexanaenexa, ponë pijava jamatabëxuaba, Moiséspijinë tocopata, jai fariseovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nexata Jesús jumaitsi fariseovijavabelia: —Moiséspijinë raja bajarapacuenia pacatocopata paneajamatabëcuenelivaisitajaxae. ");
INSERT INTO guh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pamatacabi Dioso taxuxuaba nacua pexanaejava, bajarapamatacabita Dioso exana pebi, pijava yajava. ");
INSERT INTO guh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bajaraxuata pebi itsa nacojioba pijavajavabelia, banatsata paxavecua, pena atavecua. ");
INSERT INTO guh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nexata Dioso tane anijajivimibeje becaejivi. Nexata Dioso apo tae beanijajivibeje. Becaejivi saya tane Dioso. ");
INSERT INTO guh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bajaraxuata itsanë ata apo bexuabi pijava. Tsipaji Dioso pejamatabëcueneta napitsiaexanatsibeje, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bajaraxuacujinae Jesús pijajivi pijaepato itsa barënacopata bota, nexata Jesús pijajivi yanijobatsi bajarapacuene yabara. ");
INSERT INTO guh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nexata Jesús jumaitsi pijajivijavabelia: —Ponë pijava pexuabicujinae, itsava icatsia itsa pita, bajaraponë pibisiacuene exana pevitota. Nexata naneconita Diosojavabelia. Tsipaji itsava jaita pepo pijavavecua. Dioso cajena abaxë bajaraponë pexuabiva pepo pijavacuenia totanetsi. ");
INSERT INTO guh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bajara pijinia itsi petiriva ata pamona pevecuanaviatsicujinae, itsanë icatsia itsa pitatsi. Bajarapova pibisiacuene exana pevitota. Nexata naneconita Diosojavabelia. Tsipaji itsanë jaita pepo pamonavecua, ponë abaxë Dioso totanetsi pamonacuenia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesúsjavaberena itsamonae pejevaxijivixi tocapataponatsi Jesús pejayataponaenexa pecobeta. Nexata Jesús pijajivi itaveta pexi pecapatsivi. Jesús pijajivi jumaitsi pexi pecapatsivijavabelia: —Pëtsa patocapataponame panexi Jesúsjavaberena, jai. ");
INSERT INTO guh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nexata Jesús itsa tane bajarapacuenia pijajivi pejumaitsijava, Jesús jamatabëcueneanaepanaxuareca. Jumaitsi pijajivijavabelia: —Pëtsa paitavetame. Pacopare pejevaxijivixi pepatsinexa xanëjavaberena. Mapitsipejevaxijivixije jumeaebinejeva, xaniavaetsia bajumecovënëta palivaisi tsipaebatsi. Nexata pamonae jitsipa pejonejava Dioso pijanacuayabetsia, bajara pijinia pacuenia jumeaebinejeva xaniavaetsia bejumecovënëta Dioso pejumelivaisi. ");
INSERT INTO guh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapitsipejevaxijivixije itsa jumecovënëta palivaisi tsipaebatsi, bajumecovënëta xaniavaetsia jumeaebinejeva. Bajara pijinia pacuenia jumeaebinejeva, xaniavaetsia bejumecovënëta Dioso pejumelivaisi pamonae jitsipa pejonejava Dioso pijanacuayabetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nexata Jesús isapitapona pejevaxijivixi, caejiviyo canacujitsia. Pecobeta jayatapona. Jesús pejevaxijivixijavabelia jumai tsaponae: —Dioso xaniavaetsia caevetsiana, jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pabota Jesús pejevaxijivixi isapitapona, bajarapabovecua itsajavabelia baja icatsia Jesús ponaejitsia. Nexata baja Jesús itsa naropotsijitsia, pevëjëato cujinaerucarena Jesúsjavaberena. Jesús pitabarata pematabacabëta nucajunua. Jumaitsi pevëjëato Jesúsjavabelia: —Petuxanenë, pexaniajamatabëcuenenëmë. ¿Detsa pitsicuene bexanajë taxainaenexa matacabi apo pevereverecaejava? jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nexata Jesús jumaitsi pevëjëatojavabelia: —¿Detsa xuajitsia: “Pexaniajamatabëcuenenëmë,” nejamë? Ajibi raja itsapebi ata pexaniajamatabëcuenenë. Caenë rabaja Dioso pexaniajamatabëcuenenë. ");
INSERT INTO guh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xamë baja yapëtaneme pacuenia Dioso pejumelivaisita itoroba jivi pejumecovënëtsinexa. Jumaitsi mapacueniaje: “Pëtsa jaitame itsava nijavavecua. Pëtsa beyaxuabame jivitonë. Pëtsa nacobetoxotame. Pëtsa itsamonae pexanaejava yabara najumetsënëtsiaya paebame. Pëtsa yamaxëitojorobiaya vecuapitame itsajivi pexainaejava. Axa yaiyataema. Ena ata yaiyataema,” jai Dioso pejumelivaisita. Xamë baja yapëtaneme bajarapalivaisi, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nexata pevëjëato jumaitsi Jesúsjavabelia: —Petuxanenë, daxita rabaja bajarapalivaisianë jumecovënëtajë pejevaxinëjavaveliacujinaenë, jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nexata Jesús asivaya tane pevëjëato. Jumaitsi: —Caejava raja catosaica nexanaenexa. Ponare necanajetsinexa daxita nexainaecuenemi. Bajarapamatamomi tsicobetsanaename bepejiobivi. Nexata bajarapacuenia xainaename bitso nexainaecuene Dioso pijanacuatatsia. Nexata najamatabëcueneverere, cabejiobiaexanae ata, cabeyaxuabijitsia atanua tajumelivaisi yabara, niajamatabëcuenesaë tsaponaponaenexa. Nexata jane baja xuacujinae nepënaponaename, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nexata pevëjëato itsa jumetane bajarapacuenia Jesús pejumaitsijava, najamatabëxainaeya baja vecuapona Jesús. Tsipaji pevëjëato daxitacuene bitso pexainaenë. Nexata pevëjëato apo jamatabëjumecovënëtsi palivaisi Jesús tsipaeba. ");
INSERT INTO guh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nexata pevëjëato pecovëta Jesús pijajivi matatoyorotsia naëcota. Jumaitsi: —¡Pamonae bitso daxitacuene pexainaevi, tsiayapëbejetsi penajamatabëcuenecopatsinexa Diosojavabelia pecapanepaenexatsi Dioso pijanacuayabetsia! jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nexata Jesús pijajivi jamatabëcuenenabenajaca itsa jumetane bajarapacuenia Jesús pejumaitsijava. Nexata icatsia Jesús jumaitsi pijajivijavabelia: —Tajamonae, pamonae bitso ëpexainaejavanexa najamatabëxaina, bajarapamonae bitso tsiayapëbejetsi tsane pejonenexa taxa Dioso pijanacuayabetsia. ");
INSERT INTO guh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pacuenia camello ayainëxae, acuenebi pejonejava palutaetoitaxutovojotualia, bajara pijinia pacuenia bitso pexainaenë acuenebi tsane pejonejava Dioso pijatomarabetsia. Tsipaji najamatabëxaina bitso ayaijava pexainaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesús pijajivi itsa jumetane bajarapacuenia Jesús pejumaitsijava, bitso jamatabëcuenenabenajaca. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —¿Detsa nexata pitsivi panepaena Diosojavabelia bitso pexainaevi ata itsa apo panepae tsane Diosojavabelia? jai. ");
INSERT INTO guh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nexata Jesús asaëya naëcota pijajivijavabelia. Jumaitsi pijajivijavabelia: —Jivi raja apo caëjëpaetsi pijacuata penacapanepaenexa Diosojavabelia. Caenë Dioso caëjëpatsi jivi pecapanepaenexa. Dioso raja caëjëpatsi daxitacuene pexanaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nexata Pedro jumaitsi Jesúsjavabelia: —Patajatuxanenë, paxanë rabaja pacopatajë daxitacuene pataxainaejavami. Nexata baja pacapënajinavanapatsi, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nexata Jesús jumaitsi: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pajivi xanë tajamatabëcueneta, jivi tacapanepaelivaisitanexa pejamatabëcuenetanua, pueneta pijabomi, pematapijivi ata, pejuyapijivi ata, paxa ata, pena ata, pijava ata, pexi ata, pijapabianë ata, nexata bajarapajivi bitso ayaijava Dioso rajutsianatsi pepuenetsijavanëmi matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Caejavayomijamatabëcuene tsaponae, rajutsianatsi mapanacuataje cien xuabeje tsaponae pevajënaeyabelia. Bajarapajivi icatsia xainaena bonë, pematapijivi ata, pejuyapijivi ata, pena ata, pexi ata, pabianë ata. Itsiata bajarapajivi itoya tsanetsi mapanacuapijivije. Bejiobiaexanabiabianatsinua. Itsiata baitsi jane bexëajavabelia xainaena matacabi apo pevereverecaejava. ");
INSERT INTO guh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pamonae aeconoxae mapamatacabitaje ayaijamatabëcuenevi tanetsi, bajarapamonae Dioso beveliajamatabëcuenevi exanaenatsi. Pamonae pijinia mapamatacabitaje beveliajamatabëcuenevi tanetsi, bajarapamonae Dioso ayaijamatabëcuenevi exanaenatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús, pijajivi yajava, najetaruca namutua. Pona Jerusalén tomarabelia. Jesús pijajivi, pepënaponaevitsi, jamatabëcuenenabenajaca. Tsipaji Jesús apo junavi bajarabelia peponaejava, yapëtae ata, pacuenia exanaejitsiatsi Jerusalén tomarata. Nexata Jesús icatsia junata pijajivi, doce ponëbeje, pesaicaeyojavabelia. Navajunupaeba tajëvelia pacuenia exanaejitsiatsi Jerusalén tomarata. ");
INSERT INTO guh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jumaitsi Jesús tajëvelia pijajivijavabelia: —Panejumetaema. Mara Jerusalén tomarabelia ponatsije. Bajarajotalia xanë, Daxitajivi Pematapijinënë, sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, pecobeyabelia necanajetsiana tanevaetabinexa. Nexata xanë neneconitsiana tanebeyaxuabinexa. Bajaraxuacujinae icatsia necanajetsiana itsanacuaverena pepatsivi pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bajarapamonae necanecaponaena. Nesuabiana. Nejumatitibabena penaneconitsivi pejumaconitabiabimacata. Bajaraxuacujinae nebeyaxuabiana jane baja. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane, jai tajëvelia pijajivijavabelia Jesús penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo pexënatobeje, Santiagobeje Juanbeje, imoxoyoliabeje Jesús. Jumaitsibeje Jesúsjavabelia: —Patajatuxanenë, pacuenia pacavajëtsijitsiatsibeje, bajarapacuenia pajitsipajëbeje patanetoexanaenexamëbeje, jaibeje Santiagobeje Juanbeje Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nexata Jesús jumaitsi: —¿Detsa pitsicuene pajitsipamebeje patacatoexanaenexabeje? jai. ");
INSERT INTO guh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nexata Santiagobeje Juanbeje jumaitsibeje: —Pamatacabi daxitacuene evetsianame, panetocopatsianamebeje patanaecaenexabeje nemuxuneneta vajanajuaevetsinexa. Itsanë naecaena necujuanenia. Itsanë naecaena netsavenonenia, jaibeje. ");
INSERT INTO guh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nexata Jesús jumaitsi: —Paxamëbeje apo payapëtaemëbeje xua panevajëtamebeje. ¿Pacacaëjëpabeje tsaja panenacaevetsinexabeje papecabejiobiaexanaenexabeje pacuenia xanë nacaevetsianajë tanebejiobiaexanaenexa? ¿Pacacaëjëpabeje tsaja panenacaevetsinexabeje papecabeyaxuabinexabeje pacuenia xanë nacaevetsianajë tanebeyaxuabinexa? jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nexata Santiagobeje Juanbeje jumaitsibeje: —Jãjã, panecaëjëpabeje cajena, jaibeje. Nexata icatsia Jesús jumaitsi Santiagobeje Juanbejejavabelia: —Paxamëbeje pacabejiobiaexanaenabeje pacuenia xanë nebejiobiaexanaena. Pacabeyaxuabianabejenua pacuenia xanë nebeyaxuabiana. ");
INSERT INTO guh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Itsiata baitsi jane xua panevajëtamebeje panenaecaenexabeje, itsanë tacujuanenia, itsanë tatsavenonenia, bajaraxua Dioso apo netocopatsi patacatocopatsinexabeje. Tsipaji raja taxa Dioso ëpitapetsivinexa abaxë bajaraxua toxaniavaeta, jai Jesús Santiagobeje Juanbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Diez ponëbeje, Jesús pijajivi, itsa vënëtane pepëya bajaraxua Santiagobeje Juanbeje Jesúsjavabelia pevajëcaejavabeje, nexata bajarapamonae jamatabëcuenebaraanaepana Santiagobeje Juanbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nexata Jesús daxita pijajivi junata. Jesús jumaitsi pijajivijavabelia: —Payapëtaneme rabaja pacuenia nacuaevetsivi exana. Eveta caenacua canacujitsia. Nexata nacuaevetsivi pijajivicuenia eveta pamonae jinavanapa pevetsinacuanëjava. Nexata bajarapanacuanë pevetsivi ayaijamatabëcuenevi nataeyabiaba. Xua jamatabëitoroba pevetsinacuanëjava pejinavanapaevi petoexanaenexatsi, ajumesaëya itorobabiaba petoexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pëtsa paxamë bajarapamonae cuenejëpaeya bajarapacuenia paexaname itsamonaejavabelia. Biji rajane ponë paxamëyajuvënënë jitsipa ayaijamatabëcuenenë penaexanaenexa daxita paxamëvecua, bajaraponë daxita paxamë bepanijajivitonëcuenia bepacayavenonabiaba. ");
INSERT INTO guh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ponë paxamëyajuvënënë jitsipa penaexanaenexa papecanamatacaitorobinënexa, bajaraponë daxita paxamë bepanijajivitonëcuenia bepacayavenonabiaba. ");
INSERT INTO guh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsipaji rabaja xanë ata, Daxitajivi Pematapijinë atanë, apo patajopaenë jivi taneyavenonaenexa. Biji rajane xanë patajopajë tayavenonaenexa daxitajivi. Patajopajë tasivatëpaenexa jivi ayaibitsaëtoxaneto pibisiacuene pexanaeneconimi taneconimatamotsinexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús, pijajivi yajava, pata Jericó tomarabelia. Jesús icatsia, pijajivi yajava, itsamonaenua ayaibitsaëtoxaneto yajava, pitsapa Jericó tomaravecua. Nexata Bartimeovënënë, Timeo pexënato, eca namuto muxuneneta. Bartimeo, bitso pitaxutotsëcënaenë, apo petaenë. Jivijavabelia amoneya palata pevajëcabiabinë. ");
INSERT INTO guh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nexata Bartimeo itsa jumetane Nazaret tomarapijinë Jesús imoxoyo penajetarucaejava, vavajai tsecae. —¡Jesús, Davidpijinë pemomomë, nitaxutotsoniataema! jai tsecae Bartimeo. ");
INSERT INTO guh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nexata picani itsamonae jumeitavetatsi Bartimeo pemoyanexa. Itsiata bitsoyo orijibia vavajai tsecae. —¡Davidpijinë pemomomë, nitaxutotsoniataema! jai tsecae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nexata Jesús muxunanucojopa. Jumaitsi jivijavabelia: —Pajunaremena bajaraponë, jai. Nexata bajarapamonae junarena Bartimeo. Pejunatsivirena jumaitsi Bartimeojavabelia: —Najamatabësaëtaxuare. Nonotapunare. Jesús raja cajunarena, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nexata Bartimeo penajumaxuabipana xuabapuna. Bepijia najetabarena Jesúsjavaberena. ");
INSERT INTO guh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nexata Jesús yanijoba Bartimeojavabelia. —¿Detsa xua jitsipame tacaexanaenexa? jai Jesús. Nexata Bartimeo bitso pitaxutotsëcënaenë, jumaitsi Jesúsjavabelia: —Jesús, jitsipajë taitaxutoxanepanaejava, jai. ");
INSERT INTO guh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nexata Jesús jumaitsi: —Ponare baja. Nesivajamatabëjumaitsimë: “Jesús nitaxutoxanepanaeyaexanaena,” nesivajamatabëjamë. Bajaraxuata itaxutoxanepaname baja, jai Jesús Bartimeojavabelia. Bajarapacuenia Jesús pejumaitsijavata, Bartimeo baja xaniavaetsia tane. Nexata baja bajaraponë Jesús pepëta napona. ");
INSERT INTO guh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús baja pijajivi barëimoxoyotanajetaruca Jerusaléntomara. Barëpata baja Betfagé tomarayobeje Betania tomarayobeje muxuneneta. Itsajota petsutojumata nubena olivonaenë, bajarajota Jesús barëpata. Bajarajota pebarëpatsicujinae Jesús itoroba anijanëbeje pijajivitonëbeje. ");
INSERT INTO guh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesús jumaitsi pijajivitonëbejejavabelia mapacueniaje: —Paponarebeje mapatomarayo ecaliajejavabelia. Ajena papatsiaremeliabeje, pataenutsianamebeje burro, pecëtanutsinëtsi. Bajarapaburro itsajivi ata abaxë apo jumaponae. Paisinaenamebeje. Payamaëcarenamëbeje tsane. ");
INSERT INTO guh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“¿Detsa xuajitsia paisinamebeje burro?” itsa pacajaibeje tsane itsajivi, nexata pajumaitsimëbeje tsane: “Vajatuxanenë raja namatavenona. Aeconoxae raja icatsia canaviatsiarena,” pajamëbeje tsane, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nexata Jesús pijajivitonëbeje liabeje. Caxitajarabanutabeje burro baupa muxuneneta. Cëtanutatsi burro namuto muxuneneta. Nexata bajaraponëbeje burro isinabeje. ");
INSERT INTO guh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nexata bajarajota pejinavanapaevi yanijobatsibeje. —¿Detsa xuajitsia paisinamebeje burro? jaitsibeje. ");
INSERT INTO guh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nexata bajaraponëbeje jumaitsibeje pacuenia baja Jesús itorobatsibeje. Nexata tocopatatsibeje pecaponaenexabeje. ");
INSERT INTO guh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nexata jane baja burro capatabeje Jesúsjavaberena. Nexata Jesús pijajivi pijacamisajumavelia penaxatabijavanë burro tsijumajeba. Bajarapajumata Jesús ecaya. ");
INSERT INTO guh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesús penajetarucaenamutojavarena jivi ayaibitsaëtoxaneto pijacamisajumavelia penaxatabijavanë namutua tsivajënaeyerequejebaponatsi. Itsamonae naemaxërananë, pebaxu yajava, ucubaba. Nexata namutua Jesús tsivajënaeitabëtsiaya jebaponatsi yaiyataeya Jesús pecopiapitsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesús penajetarucaejavata jivi ayaibitsaëtoxaneto Jesús pevajënaeya namataxainaeya najetarubena. Itsabitsaëtoxaneto Jesús pecovëya cotocaevanajetarubena. Daxita bajarapamonae vavajai tsanajetarubenae. Jumai tsanajetarubenae: —¡Dioso yavenonaenatsi maponë najetarucaje! ¡Vajatuxanenë pejamatabëcueneta najetaruca! ");
INSERT INTO guh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dioso yavenonaenatsi maponë najetarucaje nacua pevetsinënexa! ¡Pacuenia bajayata vajasalinainëmi Davidpijinëmi nacua eveta, bajarapacuenia evetsijitsia! ¡Nexata vaxaitsi pexaniajamatabëcuene rajutatsi Diosojavabelia! jai tsanajetarubenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nexata jane baja Jesús patajopa Jerusalén tomarata. Templobojavalia joneya. Nexata Jesús templobota naitaxutocaeveta, pacuene jivi exana templobota, petaenexa. Nexata baja Jesús pepuatae pacuene jivi exana templobota, Jesús baja icatsia pona. Naviata abaxë Betania tomarabelia pijajivi, doce ponëbeje, yajava. Tsipaji baja caniviyotsia. ");
INSERT INTO guh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jesús pijajivi barëmajita Betania tomarata. Nexata bajayacunua Jesús icatsia pijajivi barëlia Jerusalén tomarabelia. Nexata Jesús namutua penajetarucaejavata, piajani. ");
INSERT INTO guh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesús namutovecua tajiyotalia higueranae yabaxua taenuta. Nexata Jesús taeyojopalia bajaraponae pecuai perubenaejava. Itsa Jesús pata bajaraponaejavabelia, ëpebaxu saya tsanucae. Tsipaji cajena abaxë apo penacuaitsimatacabi. ");
INSERT INTO guh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nexata Jesús jumaitsi higueranaejavabelia: —Itsajivi ata apo cacuaixae tsane matavëjëa, jai Jesús. Nexata pijajivi jumetanetsi bajarapacuenia Jesús pejumaitsijava higueranaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesús, pijajivi yajava, pata Jerusalén tomarata. Nexata Jesús joneya temploboyalia. Nexata templobota Jesús tane pecanajetabiabivi, pecomuacaevinua. Nexata daxita bajarapamonae Jesús pitsapaeyaexana templobovecua. Palata pecambiababiabivi ata pijamesanëmi Jesús topënëyorobajaraba. Ucucu pecanajetabiabivi ata penabiabijavanëminua topënëyorobajaraba. ");
INSERT INTO guh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús apo tocopatsi itsajivi ata itsacuenejava pecaponaenexa templobojava. ");
INSERT INTO guh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesús livaisi tsipaeba. Jumaitsi bajarajota pepatsivijavabelia: —Dioso baja cajena pejumelivaisibaxutota mapatemplobo yabara tajëvelia jumaitsi mapacueniaje: “Tajabo raja daxitanacuanëpijivi xanëjavaberena penavajëcaebo tsane,” jai Dioso pejumaitsijava Dioso pejumelivaisibaxutota. Itsiata baitsi jane paxamë yamaxëitojorobiaya panenacobetoxotsinexa panacaetuatabiabame mapabotaje, jai Jesús templobota pecanajetabiabivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, jumetane daxita pacuenia Jesús exana jivijavabelia templobota. Nexata bajarapamonae najumejaita pacuenia Jesús beyaxuabijitsiatsi. Bajarapamonae cujunavatsi Jesús. Tsipaji daxitajivi jamatabëcuenenabenajaca Jesús petsipaebilivaisi yabara. ");
INSERT INTO guh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ajena baja meravitsia, Jesús yajavapona pijajivi Jerusalén tomaravecua. ");
INSERT INTO guh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jesús pijajivi barëmajita Betania tomarata. Nexata bajayacunua Jesús icatsia, pijajivi yajava, najetaruca pecovënamutua. Bajarapamonae taenuta higueranae baja petëpanucaejava daxita yatabutopaya. ");
INSERT INTO guh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nexata Pedro najamatabënapita higueranae Jesús pebijataenutsijava. Nexata Pedro jumaitsi Jesúsjavabelia: —Tajatuxanenë, jica, taema. Ponae higueranae bijataenutame, tëpanuca baja. ¿Detsa meta pacuenia tëpa baja? jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nexata Jesús jumaitsi pijajivijavabelia: —Paxamë bitso pajumecovënëre Dioso papecatoexanaenexa pacuenia pavajëtame. ");
INSERT INTO guh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xaniajanë pacuenia pacatsipaebijitsiatsi. Itsa pajamatabëjumaitsimë tsipae Dioso yabara: “Dioso nejumecovënëtsiana xua vajëtsianajë Diosojavabelia,” itsa pajamatabëjamë tsipae, pacajumecovënëtsipa mapatsuto ataje. Nexata itsa pajumaitsimë tsipae mapatsutojavabeliaje: “Natixire majotavecuaje. Pucaxanetojavabelia jopare,” itsa pajamë tsipae, pacajumecovënëtsipa. Nexata mapatsuto ataje paneitorobicuenia, pacajumecovënëtsipa. Itsa pajumecovënëtsianame Dioso papecatoexanaejavanexa, itsa panajamatabëxainaenamenua Dioso ëpapecajumecovënëtsijavanexa, xua pavajëtsianame Diosojavabelia, Dioso pacajumecovënëtsiana. ");
INSERT INTO guh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bajaraxuata pacajumaitsitsi. Daxita xua pavajëtsianame Diosojavabelia, pasivajamatabëjumaitsimë tsane: “Xua vajëtajë Diosojavabelia, pepacuene Dioso nejumecovënëtsiana,” pasivajamatabëjamëre. Nexata xua pavajëtsianame Diosojavabelia, Dioso pacajumecovënëtsiana. ");
INSERT INTO guh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Itsajivi pibisiacuene papecaexanaejava, pajamatabëcuenecaevare panevajëtsijavata Diosojavabelia. Nexata pabarajamatabëcuenexanepanare bajarapajivi. Nexata pijinia paneaxa, athëbëtatsia peecaenë, jamatabëcuenecaeviana paxamë ata pitabarata pibisiacuene paneexanaejava. ");
INSERT INTO guh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Paxamë itsa apo pajamatabëcuenecaevimë tsane itsanë pibisiacuene papecaexanaejava, itsa apo pabarajamatabëcuenexanepanaemënua tsane, nexata pijinia paneaxa, athëbëtatsia peecaenë, apo jamatabëcuenecaevi tsane paxamë pitabarata pibisiacuene paneexanaejava. Apo pacabarajamatabëcuenexanepanaenua tsane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús, pijajivi yajava, pata Jerusalén tomarata. Jesús itsa ponapona templobota, nexata sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, judíovi pijaancianovinua, parena Jesúsjavaberena. ");
INSERT INTO guh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nexata bajarapamonae jumaitsi Jesúsjavabelia: —¿Jipatsa pejamatabëcueneta pecanajetabiabivi, pecomuacaevinua, capitsapame mapatemplobovecuaje? jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Xanë copiaya caejumeyo pacayanijobianatsi. Itsa paxamë panejumecaviatsianame, nexata xanë juya pacatsipaebianatsi ponë nitoroba taexanaenexa bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Jipatsa jane pejamatabëcueneta Juanpijinë jivi bautisabaponapona? ¿Dioso tsaja pejamatabëcueneta? Itsa jume, ¿jivi tsaja pejamatabëcueneta? Panejumecanaviare baitsi jane, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nexata ëpamonae nabarëcuaicuaijai. Najumaitsi: —¿De meta pacuenia jumecanaviatsianatsi? Vaxaitsi itsa jumai tsipaetsi: “Dioso raja pejamatabëcueneta,” itsa jai tsipaetsi, nexata Jesús nacajumai tsipae: “¿Detsa nexata xuajitsia apo pajumecovënëtsimë Juanpijinë pepaebilivaisi?” nacajai tsipae. ");
INSERT INTO guh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Jivi raja saya pejamatabëcueneta Juanpijinë jivi bautisabaponapona,” acuenebi vajajaijava. Tsipaji mapatomarapijivije ayaibitsaëtoxaneto Juanpijinë yabara sivajamatabëjumaitsi: “Juanpijinë raja pepacuene Diosojumepaebinëmi,” sivajamatabëjai. Nexata bajarapamonae nacabeyejebijitsipa, najai Jesús peyanijobivitsi. ");
INSERT INTO guh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nexata saya bajarapamonae jumaitsi Jesúsjavabelia: —Apo payapëtaenë ponë Juanpijinë itorobatsi jivi pebautisabaponaenexa, jai. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata xanë ata apo pacatsipaebi tsanetsi ponë nitoroba taexanaenexa bajarapacuene, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús livaisi tsipaeba sacerdotevi penamatacaitorobivijavabelia, judíovi pecujarubivijavabelia ata, judíovi pijaancianovijavabelia ata. Jumaitsi mapacueniaje: —Pijaira pexainaenë pijairata uba ayaibacaboxaneto uvavënëjava. Bajaraxuacujinae pijaira matatoyorotsia ibopanaxanetonë mataropotsia pefaratsijavata yacaranata. Bajarapayacaranatsijava athëbëabetsia apia jivitonë matatoxenetsia. Bajaraxuacujinae irata mëthë cueyeta. Nexata pecueyetsimëthëjavata exana uvacuaibarëmene pecayujucabiabijavanexa. Bajaraxuacujinae pijauvabacabo tuatuajëta exananuta piapiabotsia, penacuaitsimatacabi itsa tonaveretatsi, athëbëyo pevetabiabecaenexa pijauvabacabo. Nexata bajaraponë itsamonae evetsiaexana pijauvabacabo. Uvabacabo pexainaenë jumaitsi petoevetsivitsijavabelia: “Pamatacabi cuainaveretsiana, natsicobetsatsianatsi. Pamatacabi raja cuainaveretsiana, tajajivitonë itorobiarenajë xua panetotsatsianame tanetopitsinexa,” jai uvabacabo pexainaenë petoevetsivitsijavabelia. Nexata uvabacabo pexainaenë tajë nacuayabelia pona. ");
INSERT INTO guh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Itsa baja uvabacabo pexainaenë yapëtane pecopiapatsijava uvacuai penaveretsimatacabi penotsinexa, nexata uvabacabo pexainaenë itoroba pijajivitonë. Itoroba petoevetsivitsijavabelia petsicobetsatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nexata uvabacabo pexainaenë pijajivitonë tovaetabatsi. Toconibabiatsi. Petoconibabecujinaetsi cobesa naviatsiaexanaliatsi. ");
INSERT INTO guh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Itsiata uvabacabo pexainaenë icatsia itoroba itsanë pijajivitonë petsicobetsatsinexatsi. Bajaraponë ata icatsia tomatajorobiaxuabatsi. Pibisiacuenia tobijatanetsi. ");
INSERT INTO guh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Itsiata icatsia uvabacabo pexainaenë itoroba itsanë pijajivitonë. Bajaraponë jane baja tobeyaxuabatsi. Bajaraxuacujinae abaxë icatsia uvabacabo pexainaenë itoroba itsamonae. Bajarapamonaeyajuvënëvi itsamonae totsaquibabiatsi. Itsamonae tobeyejebatsi. ");
INSERT INTO guh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Abaxë uvabacabo pexainaenë icatsia pitorobinexa, caenë tonacopatatsi. Pexënato bitso piasivanë. Nexata jane baja uvabacabo pexainaenë pexënato icatsia itoroba. Uvabacabo pexainaenë jamatabëjumaitsi: “Tajauvabacabo tanetoevetsivi tajajivi apo netoyaiyatae ata, itsiata meta taxënato netoyaiyataena,” jamatabëjai uvabacabo pexainaenë. ");
INSERT INTO guh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Itsiata uvabacabo petoevetsivitsi uvabacabo pexainaenë pexënato ata, apo toyaiyataetsi. Itsa tane uvabacabo pexainaenë pexënato, bajarapamonae najumaitsi: “Mara ponëje paxa pevënamuto paxa pijauvabacabo pitsipaje. Naxanitsia. Beyaxuabatsi. Nexata raja vaxaitsi vajauvabacabo tsane,” najai uvabacabo petoevetsivitsi. ");
INSERT INTO guh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nexata icatsia uvabacabo pexainaenë pexënato ata tovaetabatsi. Icatsia pexënato ata tobeyaxuabatsi. Petëpaenë xuabatsi bajarapauvabacabo pënëyabelia, jai Jesús sacerdotevi penamatacaitorobivijavabelia, judíovi pecujarubivijavabelia ata, judíovi pijaancianovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —¿De meta nexata xua exanaena uvabacabo pexainaenë pijauvabacabo petoevetsivitsijavabelia? Uvabacabo raja pexainaenë patsiarena. Verebiabiana daxita bajarapamonaemi. Nexata icatsia itsamonae evetsiaexanaena bajarapauvabacabo, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Icatsia Jesús jumaitsi: —Payapëtaneme rabaja pacuenia Dioso pejumelivaisibaxutota tajëvelia jumaitsi xanë yabara. Iboto pelivaisicuenia Dioso pejumelivaisibaxutota jumaitsi xanë yabara mapacueniaje: Paiboto itsamonae boexanaevi naitaxutojematabuatsiana petsitaabejexaetsi itajara, bajarapaiboto itsanë pitsiana. Nexata bajarapaibotota xaniavaetsia nayaëtsiana botabu daxita itsaibo matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Vajatuxanenë Dioso raja exanaena bajarapacuene. Nexata nacatsita pexaniacuene bitso tsane bajarapacuene, jai tajëvelia Dioso pejumelivaisibaxutota xanë yabara. Bajarapacuenia tajëvelia Dioso pejumelivaisibaxutota itsa jumaitsi, paxamë apo patanejumecovënëtsijavanexamë yabara jumaitsi. Dioso taneitapetsijava daxitajivi tacapanepaenexa yabara ata jumaitsi, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bajarapamonae picani Jesús jamatabëvaetabatsi. Tsipaji bajarapamonae jumeyapëtanetsi Jesús pejumaitsijava bajarapamonae yabara. Itsiata abaxë apo vaetabitsi. Tsipaji cujunava jivi. Nexata baja Jesús bajarapamonae vecuapona. ");
INSERT INTO guh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fariseoviyajuvënëvi, Herodes pijajiviyajuvënëvinua, najetarubena Jesúsjavaberena. Bajarapamonae pevetsivitsi itorobatsi livaisi peyanijobinexatsi Jesús. Nexata Jesús bajarapamonae bijiaya itsa jumecanaviata, peneconitsinexatsi picani nacuaevetsinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nexata bajarapamonae pata Jesúsjavaberena. Bajarapamonae jamatabëcueneëjëbiaya jumaitsi Jesúsjavabelia: —Jesús, payapëtaniji cajena nexaniajaicuene, xua yabara tsipaebabiabame livaisianë. Petuxanevi ata xamë apo cujunavimë. Apo auramë livaisi netsipaebabiabijava. Nexata daxitajivi najëpaeya livaisi tsipaebabiabame. Pexaniajailivaisi tsipaebabiabame pacuenia Dioso jitsipa jivi pejinavanapaenexa. ¿Xanepana tsaja vajamatamotsinexa impuestomatamo Romanonacua pepo pevetsinëjavabelia? Itsa jume, ¿apo xanepanae tsaja vajamatamotsinexa? jai bajarapamonae jamatabëcueneëjëbiaya Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Itsiata baitsi jane Jesús jamatabëcueneyapëtane bajarapamonae jamatabëcueneëjëbiaya peyanijobijavatsi peneconitsinexatsi picani. Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Detsa xuajitsia jamatabëcueneëjëbiaya paneyanijobame? Panetocarenamëre palatanëyo. Taejitsianë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nexata bajarapamonae Jesús tocaponarenatsi palatanëyo. Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Jipatsa mapitabaraje, pevënënua, ruca mapapalatanëyotaje? jai Jesús. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Romanonacua raja pepo pevetsinë pitabara, pevënënua, jai. ");
INSERT INTO guh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata parajutabiabianame Romanonacua pepo pevetsinë pijajava. Parajutabiabianame pijinia saicaya Diosojavabelia Dioso pijajava, jai Jesús. Nexata Jesús itsa jumecanaviata bajarapacuenia, bajarapamonae jamatabëcuenenabenajaca bajarapacuenia Jesús pejumaitsijavata. Nexata bajarapamonae jamatabëjumaitsi: —¡Xaniavaetsia baja rovia Jesús panejumecanaviata! jamatabëjai. ");
INSERT INTO guh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceovi saicaya itsalivaisi xaina. Bajarapamonae jamatabëcuenenavëxaniabiaya jumai tsabiabi: “Petëpaevi rabaja petëpaecujinae, icatsia apo asaë tsane,” jai tsabiabi. Nexata saduceovi imoxoyorenatsi Jesús. Saduceovi jumaitsi Jesúsjavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Jesús, Moiséspijinë bajayata vajanacatoyaquinaelivaisi, jumaitsi mapacueniaje: “Ponë pematapijinë pepua penacojiobinë baja, totëpatsi pexi xainaenejeva, nexata juyapijinë bepita pematapijinëmi pijavami. Bajarapacuenia juyapijinë bepita pematapijinëmi pijavami pexi pexainaenexa bajarapovajavabelia. Nexata pexi itsa xainabeje, bematapijinëmi pexi petaenexa daxitajivi,” jai Moiséspijinë bajayata vajanacatoyaquinaelivaisi. ");
INSERT INTO guh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nexata jinavanapa ënacaemonae siete ponëbeje. Pepo matapijinë copiaya nacojioba. Nexata bajaraponë pijava vecuatëpa pexi xainaenejeva. ");
INSERT INTO guh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nexata pematapijinëmi pepënarucaenë pita pematapijinëmi pijavami. Nexata icatsia bajaraponë ata tëpa pexi xainaenejeva bajarapovajavabelia. Nexata icatsia itsanë tuatuajëmatapijinë pita bajarapova. Bajaraponë ata icatsia tëpa pexi xainaenejeva bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bajarapacuenia tëpa daxita siete ponëmibeje nacaemonae, bajarapova pepitaponaevi. Itsiata itsanë ata pexi apo xainae bajarapovajavabelia. Bajaraxuacujinae belia bajarapova ata tëpa baja. ");
INSERT INTO guh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Jivi raja petëpaecujinae, Dioso icatsia asaëyaexanaenatsi,” jamë. ¿Detsa nexata ponë, bajarapamonaeyajuvënënë, pijava tsane bajarapova bajarapamatacabi? Daxita pamonae siete ponëmibeje, nacaemonae, pitapona picani bajarapovami, jai saduceovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nexata Jesús jumaitsi saduceovijavabelia: —Paxamë saya pajamatabëcuenenavëxaniabame. Paxamë raja apo payapëtaemë pacuenia Dioso pejumelivaisibaxutota jumaitsi. Apo payapëtaemënua pacuenia Dioso caëjëpatsi daxitacuene pexanaenexa. Bajaraxuata jamatabëcuenenavëxaniabiaya paneyanijobame: “¿Detsa ponë pitsiana bajarapova?” panejamë. ");
INSERT INTO guh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pamatacabi raja petëpaevimi Dioso icatsia asaëyaexanaenatsi, apo nacojiobi baja tsane. Bajarapamatacabita itsajivi ata pexënatoyo apo canajetsi tsane pebijavabelia petonacojiobinexatsi. Bajarapamonae nacojiobinejeva, jinavanapaena athëbëtatsia pacuenia ángelevi jinavanapa. ");
INSERT INTO guh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Itsa pepacuene paxamë paneyanijobame Dioso icatsia piasaëyaexanaejavanexatsi petëpaevimi, nexata pacatsipaebianatsi. Paxamë rabaja payapëtaneme pacuenia bajayata Moiséspijinë peyaquinaebaxutota jumaitsi. Bajarapabaxutota jumaitsi pacuenia Moiséspijinë Dioso barëcuaicuaijaitsi tsiquirinaemëyo petajueyecaecotiajavaverena. Abraham baja pepuatëpae, Isaac ata baja pepuatëpae, Jacob ata baja pepuatëpae, bajarapamonae yabara bajayata Dioso jumaitsi Moiséspijinëjavabelia mapacueniaje: “Xanë rabaja abaxë Abraham pijaDiosonë, Isaac ata pijaDiosonë, Jacob ata pijaDiosonë,” jai Dioso Moiséspijinëjavabelia bajayata petëpaevimi yabara. ");
INSERT INTO guh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bajarapacuenia Dioso pejumaitsixae, nayapëtane bajarapamonae bajayata tëpae ata, Diosovecua apo penaxuabijava. Aeconoxae ata bajarapamonae Dioso yajavajinavanapa athëbëtatsia. Nexata paxamë itsa pajumaitsimë: “Petëpaevi rabaja petëpaecujinae, icatsia apo asaë tsane,” itsa pajamë, pinijicuenia pajamatabëcuenenavëxaniabame, jai Jesús saduceovijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Judíovi pecujarubinë pata Jesúsjavaberena. Nexata bajaraponë Jesús jumetanetsi xaniavaetsia pejumecanaviataponaejava saduceovijavabelia. Nexata judíovi pecujarubinë jumaitsi Jesúsjavabelia: —¿Detsa palivaisi bitso jivi bejumecovënëta daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia? jai. ");
INSERT INTO guh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús nexata jumaitsi judíovi pecujarubinëjavabelia: —Palivaisi bitso jivi bejumecovënëta, daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia jumaitsi mapacueniaje: “Paxamë, Israelpijinë papemomoximë, pajumetaema. Vajatuxanenë rabaja caenë Dioso. ");
INSERT INTO guh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bajaraponë panijatuxanenë, panijaDioso, daxita panejamatabëëthëtojavavetsina pasivamëre. Pasivamërë daxita panejamatabëcueneta ata, daxita panenajamatabëxainaesaëta ata, daxita panesaëta ata,” pejailivaisi bitso jivi bejumecovënëta daxita Dioso pitorobilivaisianë pejumecovënëtsijava matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bajaraxuacujinae pecotocaevilivaisi, palivaisi bitso jivi bejumecovënëta, jumaitsi icatsia mapacueniaje: “Pasivamëre itsajivi ata pacuenia paxamë panijacuata panaasivamë,” jai. Bajarapalivaisi ata jivi bitso bejumecovënëta. Ajibi rabaja itsalivaisi pematatsënëa, Dioso pitorobilivaisi, palivaisi bitso jivi bejumecovënëta,” jai Jesús judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nexata icatsia judíovi pecujarubinë jumaitsi Jesúsjavabelia: —Jesús, xaniajamë rabaja pacuenia jumaitsimë. Caenë tsaena Dioso ponapona. Ajibi tsaena pematatsënëa itsanë Dioso. ");
INSERT INTO guh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bejumecovënëtatsi Dioso daxita vajajamatabëëthëtojavavetsina, daxita vajanajamatabëxainaesaëta ata, daxita vajasaëta ata. Biasivatsi itsajivi ata pacuenia vaxaitsi vajacuata nasivatsi. Daxita bajaraxua itsa jumecovënëtatsi, bitso nacatonamatamota Diosojavabelia. Bajaraxua bitso nacatonamatamota ofrenda Diosojavabelia vajarajutabiabijava matatoxenetsia. Baitsi xua Diosonexa ofrendacuenia totajuitabiabatsi, dajubicuene itsa tobeyabiabatsi, bajaraxua matatoxenetsia bitso nacatonamatamota, jai judíovi pecujarubinë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús itsa jumetane judíovi pecujarubinë xaniavaetsia pejumecanaviatsijavatsi, nexata Jesús jumaitsi judíovi pecujarubinëjavabelia: —Tsiquirijavayo catosaica Diosojavabelia nenajamatabëcuenecopatsinexa nijatuxanenë Dioso nexanaenexa, jai Jesús judíovi pecujarubinëjavabelia. Bajaraxuacujinae daxitajivi baja Jesús cujunavatsi. Nexata baja Jesús jivi jamatabëcueneëjëbiaya livaisi apo yanijobitsi. ");
INSERT INTO guh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús livaisi tsipaeba templobota. Jesús pijacuata nayabarajumaitsi: —¿Detsa xuajitsia judíovi pecujarubivi apo jumecovënëtsi Cristo Dioso pexënatocuene, ponë athëbëvetsica Dioso itorobijitsiatsica jivi pecapanepaenexa? Bajarapamonae saya jamatabëcuenenavëxaniabiaya jumai tsabiabi Cristo yabara: “Cristo raja itsa patsiana, Davidpijinë pemomo tsane,” jai tsabiabi. ");
INSERT INTO guh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidpijinë bajayata Espíritu Santo pejamatabëcueneta tajëvelia jumaitsi Cristo yabara mapacueniaje: Dioso jumaitsi tajatuxanenëjavabelia: “Ecare abaxë tacujuanenia. Vecatsivajënae jumecovënëtsiaexanaenatsi abaxë copiaya nijavajabitsaë nitorobicuenianexa,” jai Dioso tajatuxanenëjavabelia, jai bajayata tajëvelia Davidpijinë mapacueniaje Cristo yabara. ");
INSERT INTO guh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","’Nexata Davidpijinë bajayata Cristo yabara: “Tajatuxanenë,” itsa jai, nexata Cristo Davidpijinë apo pemomo. Tsipaji baja cajena Cristo saicaya Dioso pexënato, nayabarajai Jesús judíovi pecujarubivi pecanaëjëtsinexa Cristo Dioso pexënatocuene. Nexata jivibitsaëtoxaneto Jesús pejumetaevitsi jumebarëyatanetsi. ");
INSERT INTO guh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús jivi ayaibitsaëtoxanetojavabelia, pijajivijavabelia ata, livaisi tsipaeba. Nexata Jesús livaisi petsipaebijavata jumaitsi mapacueniaje: —Xania, panayajivitaema, palivaisi judíovi pecujarubivi tsipaebapona, panejumecovënëtsiyaniva. Bajarapamonae jitsipabiaba tomara tuatuajëjava piapiajavanë penaxatababiabavanapaenexa jivi peyaiyataenexatsi. Jitsipabiabanua bitso yaiyataeya pebajacobinexatsi callejava. ");
INSERT INTO guh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bajarapamonae itsa najoneyabiaba judíovi penacaetuatabiabibonëjava, jitsipabiaba penaenexa pexaniaviriajavanëta. Nexata natsiitapetabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. Bajarapamonae itsa napatabiaba fiestajava ata, jitsipabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. ");
INSERT INTO guh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bajarapamonae yamaxëitojorobiaya vecuanotabiabanua pamonajivi pevecuatëpaevanëtsi pecobecovëjavaxi. Bajarapamonae itajara pinijicuenia vajëcabiaba Diosojavabelia. Itsiata pepo pexaniajaijamatabëcueneta apo vajëcabiabi. Bajarapacuenia vajëcabiaba saya jivi petaenexatsi Dioso itajara bitso bepejumecovënëtsivi. Nexata bajarapamonae bitso pinijicuenia Dioso naneconitsiaexanaenatsi pamatacabi Dioso naneconitsiaexanaena daxita pamonae Dioso apo pejumecovënëtsivi, jai Jesús judíovi pecujarubivi yabara. ");
INSERT INTO guh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Itsamatacabi Jesús eca templobota. Pacajonita jivi palata jeyabiaba ofrendacuenia perajutsijava Diosojavabelia, bajarapacajoni pecanacujitsita Jesús eca. Nexata Jesús cobetaeyeca jivi palata pejeponaejava bajarapacajonita. Ayaijava palata pexainaevi, caejivi canacujitsia, ayaijava palata jepona. ");
INSERT INTO guh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bajarajota napata pamona pevecuatëpaevatsi, bepejiobiva. Nexata bajarapova najia anijapalatanëyobeje piamatamobinëyobeje. ");
INSERT INTO guh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nexata Jesús junata pijajivi. Jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapovaje pamona pevecuatëpaevatsi bejiobi bitso. Xuayo jia cajonita ofrendacuenia perajutsinexa Diosojavabelia, bajaraxuayo bitso Dioso sivajamatabëcuenebarëya daxita xua itsamonae jia bajarapacajonita matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tsipaji rabaja xua bajarapamonae apo namatavenonae, jia bajarapacajonita ofrendacuenia perajutsinexa Diosojavabelia. Itsiata mapovaje bepejiobiva daxitajavayomi penaevetsijavayotaminexa, jia bajarapacajonita ofrendacuenia perajutsinexa Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Itsa baja Jesús, pijajivi yajava, pitsaparena templobovecua, Jesús pijajivitonë jumaitsi Jesúsjavabelia: —¡Tajatuxanenë, jica, nataema mapaibotoxanetonëje, mapaboxanetonë ataje! jai Jesús pijajivitonë. ");
INSERT INTO guh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nexata Jesús tajëvelia jumaitsi pijajivitonëjavabelia: —Daxita raja mapaboxanetonë tanemeje, bajarapaboxanetonëmi itsamatacabi itsanacuapijivi penetsianica irabetsica. Nexata mapaibotoxanetonëmije itsaiboto ata pejumavereca apo bocae tsane, jai Jesús tajëvelia pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús eca petsutojumata. Patsutojumata olivonaenë apaaxayo templobo canacujitsijavalia, bajarapatsutojumata Jesús eca. Nexata Pedro, Santiago, Juan, Andrés, bajarapamatabëxëyo pijaepatojavata Jesúsjavabelia jumaitsi: ");
INSERT INTO guh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Patajatuxanenë, pajitsipajë patanetsipaebinexamë patayapëtaenexa paepatota copiapatsijitsia xua vajunupaebame. ¿Detsa peneta pitsicuene pataenajë itsa copiapatsijitsia xua jumaitsimë templobo yabara? jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús nexata tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xania panayajivitaename. Pëtsa panacopatame itsajivi ata papecayamaxëitojorobinexa. ");
INSERT INTO guh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tsipaji raja peyamaxëitojorobivinexa ayaibitsaëto patsiana bexanë itajara tsane. Bajarapamonae najumetsënëtsiaya jumai tsane: “Xanë raja Cristonë, Dioso athëbëvetsica taneitorobinëtsica jivi tacapanepaenexa,” jai tsane. Bajarapamonae jivi, ayaibitsaëto yamaxëitojorobiana. ");
INSERT INTO guh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Vajabitsaë pexanaejava imoxoyonacuanëjava, tajënacuanëjava ata, pavënëlivaisitaename. Itsiata pëtsa pajunavame. Bajara peneta itsane mapanacua pevereverecaevajënaeje. Itsiata baitsi jane bepijia bajarapamatacabi mapanacuaje abaxë apo vereverecajuni tsane. ");
INSERT INTO guh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mapanacuaje pevereverecaevajënae peneta copiaya itsaviriavi nabena itsaviriavijavabelia. Itsanacuanëpijivi pijinia nabena itsanacuanëpijivijavabelia. Ira najëabiana ayaicuenia nacuanëjava. Ayaijaniboxaneto najetarucaena nacuanëjava. Ayaicuenia bitso jivi bejiobi tsane nacuanëjava. Daxita bajarapacuene itsa pataename, saya abaxë taxuxuabaponaena piayaicuene, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuata. ");
INSERT INTO guh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Icatsia Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Nexata paxamë xania panayajivitaename. Tsipaji raja xanë patajajivixaemë, tomara pevetsivijavabelia pacacaponabiabiana. Bajarapamonae pacajumaconibabeyabiabiana judíovi penacaetuatabiabibonëta. Paxamë patajajivixaemë pacanubiana nacuaevetsivi pitabarata, presidentevi ata pitabarata. Nexata bajarajota bajarapamonaejavabelia patsipaebianame xanë talivaisi. ");
INSERT INTO guh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nexata daxitanacuanëpijivijava patsipaebanajetarubenaename pecapanepaelivaisinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Itsa pacataicaena papecaneconitsinexa nacuaevetsivijavabelia, pëtsa pajamatabëcuenebëjamë panenayajivicuaicuaijainexa bajarapamonaejavabelia. Palivaisi panejamatabëcuenevetsina pacatonaitajëtsiana, patsipaebianame bajarapamonaejavabelia. Tsipaji raja bajarapaepatota Espíritu Santo pacacuaicuaijaiyaexanaena. Paxamë baitsi panejamatabëcueneta apo pacuaicuaijamë tsane. ");
INSERT INTO guh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bajarapamatacabi patajajivixaemë, panacaemonae atamë, itsajivi panijamonaejivi ata pacacanajetsiana nacuaevetsivijavabelia papecabeyaxuabinexa. Paneaxa ata, paneena ata, pacacanajetsiana nacuaevetsivijavabelia papecabeyaxuabinexa. Panexi ata pacacanajetsiana nacuaevetsivijavabelia papecabeyaxuabinexa. ");
INSERT INTO guh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Daxitajivi pacaitoya tsane patajajivixaemë. Itsiata pajivi ajamatabëcuenesaë tsane Dioso pejumecovënëtsijava nacua pecopiarucaejavabelianexa, bajarapajivi Dioso capanepaenatsi, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Icatsia Jesús tajëvelia vajunupaeba papiayaicuene itsamatacabi copiapatsijitsia Jerusalén tomarata. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Diosojumepaebinëmi, profeta Danielpijinë, tajëvelia Dioso pitorobicueniatsi piayaicuene pevajunupaebilivaisi bajayata yaquina. Xua panijatomaranëmi vereverecaeyaexanaejitsiatsi, bajaraxua pelivaisi yaquina. (Pajivi lebiana mapalivaisije, yapëtaena papiayaicuene vajunupaeba mapalivaisitaje.) Nexata paxamë pataename bajarapapiayaicuene penucaejava templobota, itsajota picani apo benucae. Nexata Judea nacuata pejinavanapaevi itsa vënëlivaisitaena bajarapapiayaicuene penucaejava templobota, pëtsa nubena. Naxanitsiayo bajarapamonae rëcëpecaena ibotsutonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pajivi pijabojumata athëbëyo ecaya, itsa vënëlivaisitaena bajarapapiayaicuene penucaejava templobota, bajarapajivi perunaecujinaetsica bepijia najetabajiraviana. Pëtsa joneya pijaboyalia pejutsinexa pecobecovë. ");
INSERT INTO guh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pajivi pijinia nacuenebaponapona pijapabita, itsa vënëlivaisitaena bajarapapiayaicuene penucaejava templobota, bepijia najetabajiraviana. Pëtsa naviata pijaboyabelia pejutsinexa penaxatabijava. ");
INSERT INTO guh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Papetiriavi penacueto yacotajinavanapa, bitso bejiobi tsane bajarapamatacabi! ¡Bitso nabejiobitsiaya jinavanapaena! ¡Papetiriavi ata mitoapaenacuetoxi isajinavanapa, bitso bejiobi tsane bajarapamatacabi! ");
INSERT INTO guh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bajaraxuata tajëvelia Diosojavabelia pavajëcare piayapëbejematacabita papecatocopiapatsiyaniva bajarapapiayaicuene. Nexata pamatacabi parëcëpecaename, pexaniamatacabi Dioso pacatocopatsiana bitso nabejiobitsiaya paneponaeyaniva. ");
INSERT INTO guh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsipaji raja bajarapamatacabi bitso jivi bejiobi tsane. Pabejiobicuene abaxë jivi caeto ata apo tae Dioso nacua pexanaecujinae, bajarapabejiobicuene taena. Bajaraxuacujinae icatsia itsamonae bejiobiaexanae atatsi tsane, itsiata bajarapacuenia bitso apo bejiobiaexanaetsi tsane. Tsipaji Dioso epatua yatuucutsiana jivi bitso nabejiobitsiaya pejinavanapaematacabianëminexa, bitso jivi nabejiobitsia pejinavanapaeyaniva. ");
INSERT INTO guh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dioso epatua itsa apo yatuucutsi tsipae bitso jivi nabejiobitsiaya pejinavanapaematacabianëminexa, caejivi ata apo asaë tsipae. Itsiata baitsi jane Dioso piasivaxae pijajivi, pitapetsivi, Dioso epatua yatuucutsiana bitso jivi nabejiobitsiaya pejinavanapaematacabianëminexa, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata papiayaicuene itsamatacabi copiapatsijitsia Jerusalén tomarata. ");
INSERT INTO guh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Icatsia Jesús tajëvelia vajunupaeba pacuenia itsamatacabi mapanacuataje patsijitsia peyamaxëitojorobivi Dioso pejumecovënëtsivi peyamaxëitojorobinexatsi. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Nexata itsajivi yamaxëitojorobiaya itsa pacajumaitsi tsane: “Pataema. Mara Cristo nucaje,” itsa pacajai tsane, pëtsa pajumecovënëtame. Itsa pacajumaitsi tsane: “Bajarajota nuca Cristo,” itsa pacajai tsane, pëtsa pajumecovënëtame. ");
INSERT INTO guh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Itsamonae jumai tsane: “Xanë raja Cristonë,” jai tsane. Itsiata jemajai tsane. Itsamonae jumai tsane: “Diosojumepaebinënë raja, profetanënë,” jai tsane. Itsiata jemajai tsane. Bajarapamonae itajara exanaena pinijicuene pexanaejavanë peyamaxëitojorobinexa saya jivi. Nexata bajarapacuenia itsamonae yamaxëitojorobaponaenatsi. Itsiata pamonae pepacuene Dioso pijajivi, Dioso pitapetsivitsi, bajarapamonae apo yamaxëitojorobi tsanetsi. ");
INSERT INTO guh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Xania baja tsane! Xanë rabaja pacatsipaebatsi tajëvelia daxitacuene panenayajivitaenexa, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi mapanacuataje patsijitsia peyamaxëitojorobivi Dioso pejumecovënëtsivi peyamaxëitojorobinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús tajëvelia navajunupaeba itsamatacabi icatsia pepatsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xanë tapatsivajënaetsica, jivi taena pecujunavicuene. Jivi nabejiobitsiaya jinavanapaena. Nexata jivi nabejiobitsiaya pejinavanapaematacabicujinae matacabipijijuameto aitaquiri tsane. Meravipijijuameto ata aitaquiri tsane. ");
INSERT INTO guh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tulupu ata othopaenica irabetsica. Daxitacuene, xua rubena athëbëtatsia, najëabiana. Xaniavaetsia apo rubenae tsane. ");
INSERT INTO guh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nexata bajarapaepatota xanë, Daxitajivi Pematapijinënë, jivi netaena athëbëvetsica itarërëbota tanajetarucaejava. Patsianicajë daxitacuene taevetsinexa. Tanivenivenaecotia yajavapatsianicajë. ");
INSERT INTO guh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bajaraxuacujinae ángelevi itorobianajë, pamonae tajajivi, Dioso pitapetsivitsi, daxitanacuanëjavaverena tanetocaetuatsinexa xanëjavaberena, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata itsamatacabi icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Icatsia Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pacanaëjëre pacuenia itsi higueranae. Itsa maxëranajuva, nexata pejanabaxu pitsapa. Nexata bajarapacuenia payapëtaneme vai baja imoxoyo pevajënae pejonejavanexa. ");
INSERT INTO guh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bajara pijinia pacuenia peneta itsa pataename pecopiapatsijava, xua yabara pacatsipaebatsi, nexata payapëtaename imoxoyo baja tavajënae tsane tapatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pitsijamatabëcuenevi aeconoxae mapamatacabitaje jinavanapa, bajarapitsijamatabëcuenevi abaxë, bexëajavabelia ata, apo vereverecae tsane. Matapania xua yabara pacatsipaebatsi, itsa baja copiapatsiana, bajarapamonae jane baja vereverecaena. ");
INSERT INTO guh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Itaboxo, ira yajava, tsitecaena daxitamatacabijavabelianexa,” jamatabëjai ata tsane itsamonae, itsiata jamatabëcuenenavëxaniabiana. Tsipaji jemata itaboxo, ira yajava, vereverecaena. Nexata palivaisi pacatsipaebatsi, apo najumetsënëtsinë tsane. Nexata xua yabara pacatsipaebatsi, pacuenia baja najumecapanepaeya jumaitsinë, daxita bajaraxua copiapatsiana, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jesús icatsia jumaitsi pijajivijavabelia: —Itsajivi ata apo yapëtae pamatacabita, paepatota ata, copiapatsijitsia daxita xua yabara tajëvelia pacatsipaebatsi. Athëbëpijivi ata, ángelevi, apo yapëtae. Xanë, Dioso pexënato atanë, apo yapëtaenë. Caenë taxa Dioso yapëtane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Icatsia Jesús jumaitsi pijajivijavabelia: —Xania baja tsane. Daxitamatacabi saya panecopiaevetavanapaename. Tsipaji raja apo payapëtaemë tsane paepatota patsijitsianëtsica. ");
INSERT INTO guh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nexata pacuenia bo pexainaenë, pijabo evetsiaexana pijajivi, bajara xanë itsinë tsane. Bo pexainaenë itsa ponaejitsia tajënacuayabelia, pijajivi evetsiaexana pijabo. Nexata pijajivi, caejivi canacujitsia, rajutapona petonacuenebavanapaejavanexatsi pecovëta. Nexata pijajiviyajuvënënë itoroba baupa pevetsinënexa petoevetabiabinexatsi pijabobaupa. Bo pexainaenë jumaitsi bajaraponëjavabelia: “Xaniavaetsia netoevetabiabianame baupa matapania tapatsimatacabijavabelianexa,” jai bo pexainaenë. ");
INSERT INTO guh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nexata paxamë ata bajarapacuenia panecopiaevetavanapaename matapania tapatsimatacabitsicajavabelianexa. Tsipaji raja apo payapëtaemë tsane pamatacabita patsijitsianëtsica. Ajena meravi, caecanivia, patsipajë. Meravi tuatuajëta ata patsipajë. Matacabivëpata ata patsipajë. Bajayacunua ata patsipajë. ");
INSERT INTO guh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bajaraxuata xania baja tsane. Daxitamatacabi saya panecopiaevetavanapaename. Jemata itsa patsipajë, paepatota apo panecopiaevetsimë, pacacaxitajarabijitsipatsi panemajitsijavata. ");
INSERT INTO guh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Palivaisi pacatsipaebatsi paxamëjavabelia, daxitajivinexa jumaitsinë. ¡Daxitamatacabi saya panecopiaevetavanapaename! jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Anijamatacabibeje abaxë ajibi pejonenexa pascuafiesta, itsafiestanua, pafiestajava judíovi baxane levadurata matajërëbinejeva pexanaepan. Nexata bajarapafiestabejevajënaeya, sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, najumejaita picani bajarapafiestajava pevaetabinexatsi Jesús. Penajumetsënëtsilivaisita picani jamatabëvaetabatsi Jesús pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Itsiata bajarapamonae najumaitsi: —Fiestajava meta abaxë apo vaetabi tsanetsi jivi vajanacaitsacueniabiyaniva, najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús ponapona Betania tomarata, Simón pijabota. Simón bajayajebi bitso peperabëtsabanaenëmi. Nexata Jesús pexaeyecaejavata mesata, petiriva cobenaimoxoyorenatsi petuxujuviaceitera, nardovënëra, alabastrobotellabëta pejeaceitera. Bajarapora bitso penamatamotsira. Nexata bajarapova yavëtoxobiaxuaba bajarapora, petuxujuviaceitera. Bajaraxuacujinae Jesús tsimataepanaicatsi bajarapaaceitera. ");
INSERT INTO guh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bajarajota itsamonae penaenaevi itsa taeyena Jesús petsimataepanaejavatsitsica, bajarapamonae jamatabëanaepanareca. Nexata ëpamonae najumai tsenae: —¿Detsa xuajitsia saya xuaba bajarapacuenia maporaje? ");
INSERT INTO guh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Canajetsipa rajane. Nexata matamopitsipa trescientos padenariobeje matatoxenetsia. Bajarapapalata rajutsipa bepejiobivi bajarapacuenia peyavenonaenexa, najai tsenae ëpamonae. Bajarapamonae anaepana bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Detsa xuajitsia bajarapacuenia pajumaitsimë bajarapova pexanaejava yabara? Mara povaje pexaniacuene nexanaje. ");
INSERT INTO guh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Daxitamatacabi raja bepejiobivi jinavanapa itsaxuayo pajinavanapame. Pamatacabi pajitsipame pexaniacuene panetoexanaenexa bepejiobivijavabelia, nexata patoexanaename. Itsiata baitsi jane xanë daxitamatacabi apo ponaponaenë tsane paxamëjavata. ");
INSERT INTO guh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mara papetirivaje pexaniacuene netoexana pacuenia baja cuenecaëjëpatsi. Itsamonae petëpaejivi batsiperabëepana petuxujuviaceitera peperabëxaniavaetsinexa pemëthëtsivajënae. Bajara pijinia pacuenia mapovaje netsimataepana petuxujuviaceitera, abaxë apo tëpae atanë. Nexata baja bajarapova neperabëxaniavaeta itsamonae tanemëthëtsivajënae. ");
INSERT INTO guh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxitanacuanëjava tajajivi itsa paebanajetarubenaena pexanialivaisi jivi tacapanepaelivaisinexa, vajunupaebabiabiananua pacuenia exana xanëjavaberena mapapetirivaje, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesús pijajivi doce ponëbejeyajuvënënë pevënë Judas. Itsavënë Iscariote. Nexata Judas pona sacerdotevi penamatacaitorobivijavabelia. Jesús jane baja yajumejailiatsi pecanajetsinexatsi. Nexata jane baja Judas Jesús canajetatsi sacerdotevi penamatacaitorobivi pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nexata sacerdotevi penamatacaitorobivi itsa tane bajarapacuene, barëya. Jumaitsi bajarapamonae Judasjavabelia: —Palata pacarajutsianatsi, jai. Nexata jane baja xuacujinae Judas Jesús naitaxutocaevetaponaponatsi. Nexata paepatota Judas toyapëxanepanatsi, perajutsinexa jane baja bajarapamonae pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Junua jane baja fiesta, pafiestajava judíovi baxane levadurata matajërëabinejeva pexanaepan. Bajarapamatacabi ovejaxi babia pexaenexa pascua fiestamatacabi. Nexata Jesús yanijobatsi pijajivi. —¿Detsa belia paponaenajë patacamitsaexanaenexa pascua fiestamatacabi pexaejava nexaenexa? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nexata Jesús itoroba anijanëbeje pijajivitonëbeje. Jumaitsi: —Tomarabelia paponarebeje. Bajarajotalia pacaxitajarabianamebeje mera canalito pecanajetarucaenë. Bajaraponë papënanajetarucaenamebeje. ");
INSERT INTO guh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pabota bajaraponë joneyojopaena, bajarapabo pexainaenëjavabelia pajumaitsimëbeje tsane: “Vajanacacujarubinë raja jumaitsi: ‘¿Detsa jota pënëyatuucutsibo eca, pabota tajajivi barëxaejitsianë xua jivi baxane pascua fiestamatacabi?’ jai raja vajanacacujarubinë,” pajamëbeje tsane bajarapabo pexainaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nexata athëbëabetsia anijairabeje pënëyatuucutsibojavata, pacatsitajëtsianabeje. Bajarapaboënëta athëbëyotsia paira ayaiënëtuatuajë tsane. Daxitacuene bajarajota xainaena. Nexata vajaxaejavanexa bajarajotatsia paexanaenamebeje, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nexata jane baja ponabeje Jesús pijajivitonëbeje. Patabeje baja tomarabelia. Caxitajarababeje daxita pacuenia Jesús jumaitsitsibeje. Nexata xua jivi baxane pascua fiestamatacabi daxita Jesús pijajivi pebarëxaenexa, bajaraponëbeje exanabeje jane baja. ");
INSERT INTO guh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Itsa baja meravitsia, Jesús patajopa bajarajota pijajivi, doce ponëbeje, yajava. ");
INSERT INTO guh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Daxita mesata pexaeyenaejavata, Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Caenë paxamëyajuvënënë, xanëjavata pexaeyecaenë, necanajetsiana tajavajabitsaë pecobeyabelia, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nexata Jesús pijajivi bejamatabëjiobireca. Nexata Jesús pijajivi, caenë canacujitsia, Jesúsjavabelia yanijobapona. —¿Xanë tsaja tsane? jai tsaponae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nexata Jesús jumaitsi pijajivijavabelia: —Doce paponëmëbejeyajuvënënë raja. Ponëbeje peneta caecuenia panajuacajabutsianajëbeje panbë platojavabelia, bajaraponë tsane. ");
INSERT INTO guh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nexata xanë, Daxitajivi Pematapijinënë, tëpaenajë pacuenia baja cajena xanë yabara Dioso pejumelivaisibaxutota tajëvelia jumaitsi. Itsiata ponë tajavajabitsaë pecobeyabelia necanajetsiana, bajaraponë bitso bejiobi tsane pinijicuenia. Itsa meta bajaraponë apo naexanae tsipae, bajarapacuenia apo necanajetsi tsipae. Nexata xanepanaejitsipatsi bajaraponë itsa apo naexanae tsipae. Tsipaji apo naneconitsi tsipae Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nexata pexaeyenaejavata Jesús pita panbë. Jesús jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pan, jai. Bajaraxuacujinae epatsënëquejeba bajarapapanbë. Rajuta pijajivi. Jesús jumaitsi pijajivijavabelia: —Paxaema. Mara tavitoje, jai. ");
INSERT INTO guh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bajaraxuacujinae icatsia Jesús copavënëjavata yapita pijajivi pebarëapaeranexa. Diosojavabelia jumaitsi: —Pexaniacuene panetoexaname. Panerajutame maporaje, jai. Bajaraxuacujinae pijajivi bajarapora rajuta. Daxita Jesús pijajivi bajarapora apa. ");
INSERT INTO guh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús pijajivijavabelia jumaitsi: —Tajana raja othopaena jivi ayaibitsaëtoxaneto pecapanepaenexatsi. Nexata tatëpaejava pejamatabëcueneta, jivi yapëtaena pepacuene xaniajai Dioso jivi pecapanepaejavanexa, pacuenia baja cajena tajëvelia Dioso najumecapanepaeya jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xaniajanë pacuenia pacatsipaebijitsiatsi. Xanë rabaja matavëjëa apo apaenë tsane uvacuaira mapanacuataje, matapania icatsia apaenajë Dioso pijanacuatatsia pejanauvacuaira, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesús pijajivi barënaxëana Diosojumevajianë. Bajaraxuacujinae Jesús pijajivi barëpona petsutojumabelia. Patsutojumata olivonaenë apaaxayo, bajarapatsutojumabelia barëpona. ");
INSERT INTO guh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nexata bajarapatsutojumata Jesús jumaitsi pijajivijavabelia: —Daxita raja paxamë ajena, pameravi, panexuabarëcëpecaename. Tsipaji rabaja patanexuabarëcëpecaejavanexamë yabara, Dioso pejumelivaisibaxutota tajëvelia jumaitsi mapacueniaje: “Beyaxuabianatsi raja oveja pevetsinë. Nexata pijaovejabitsaëto nacayajatsia rëcëpecaena,” jai Dioso pejumelivaisibaxutota paxamë patanexuabarëcëpecaejavanexamë yabara. Nexata ajena, pameravi, tajavajabitsaë itsa nevaetabiana tanebeyaxuabinexa, daxita paxamë panexuabarëcëpecaename. ");
INSERT INTO guh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Itsiata baitsi jane tatëpaecujinae icatsia asaënë tsane. Nexata paxamë panevajënaeyabelia copiata ponaenajë Galilea nacuayabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nexata Pedro jumaitsi Jesúsjavabelia: —Daxita mapamonaeje caxuabarëcëpecae ata tsane, xanë cajena apo caxuabatabajiravi tsanetsi, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nexata Jesús jumaitsi Pedrojavabelia: —Xaniajanë pacuenia catsipaebijitsiatsi. Ajena rabaja, pameravi, nanianaevëpata, anijajumebeje vacara pefiabivajënaeya, nayavajunuaxainaename tajajivitonëcuenemë. “Apo yapëtaenë cajena bajaraponë,” jamë tsane xanë yabara acueyabi xuabeje, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Itsiata Pedro ajumesaëya jumaitsi Jesúsjavabelia: —Nebeyaxuabijitsia ata tsane xamë yajava, itsiata cajena apo nayavajunuaxainaenë tsane nijajivitonëcuenenë, jai Pedro Jesúsjavabelia. Daxita Jesús pijajivi bajarapacuenia jumaitsi. ");
INSERT INTO guh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús, pijajivi yajava, pata Getsemanívënëjavata. Bajarajota Jesús jumaitsi pijajivijavabelia: —Paneevetenare abaxë majotaje tavajëtsiepatoyo Diosojavabelia, jai. ");
INSERT INTO guh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nexata Pedro, Santiago, Juan, bajara saya pamatabëxëyo, Jesús barëpona pesaicaeyojavabelia. Bajaraxuacujinae Jesús bitso najamatabëxaina. Nexata bejamatabëjiobireca. ");
INSERT INTO guh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nexata Jesús jumaitsi pijajivi acueyabi ponëbejejavabelia: —Xanë bitso pinijicuenia najamatabëxainajë. Nexata tanajamatabëxainaejava yatëpaejitsianë. Paxamë abaxë majotaje panacopabare. Paitavamë tsane. Pëtsa pamajitame, jai Jesús pijajivi acueyabi ponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nexata Jesús, caenë, pevajënaeyabelia icatsia tsiquirijavayo ponataba. Tsipaji Jesús tajëvelia yapëtane pacuenia Dioso tocopatatsi bitso ayaicuenia pebejiobiaexanaenexatsi paepatota pijavajabitsaë beyaxuabijitsiatsi. Nexata Jesús irataeya bocajunua pevajëtsinexa Diosojavabelia. Vajëta picani Diosojavabelia bitso bejiobitsiaya pebeyaxuabiyanivatsi. ");
INSERT INTO guh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nexata Jesús pevajëtsijavata Diosojavabelia, jumaitsi: —Taxa Diosomë, netocopatame picani tanebeyaxuabinexa betajiobicueneta. Daxitacuene raja cacaëjëpa nexanaenexa. Nexata necapanepare bajarapabejiobicuenevecua. Itsiata xanë apo tajitsipaecuene ata, pacuenia xamë jitsipame, netocopatsianame, jai Jesús pevajëtsijavata Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bajaraxuacujinae Jesús naviarena acueyabi ponëbeje pijajivijavaberena. Caxitajaraba Jesús pijajivi pemajitanubenaevi. Nexata Jesús jumaitsi Pedrojavabelia: —Simón, ¿pamajitanubename tsaja? ¿Apo pacacaëjëpae tsabaja rovia caeepatoyo ata paneaitavatsenaenexa? ");
INSERT INTO guh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pëtsa pamajitame. Paitavamëre. Pavajëre Diosojavabelia pibisiacuene paneexanaeyaniva. Tsipaji raja dovathi pacajamatabëcueneëjëbiana. Paxamë picani panejamatabëcueneta pexaniacuene jamatabëpaexanabiabame. Itsiata baitsi jane apo pajamatabëcuenesaëmë pexaniacuene paneexanaenexa, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nexata icatsia Jesús pona pecovëyabelia pevajëtsinexa icatsia Diosojavabelia. Bajara icatsia pacuenia Jesús vajëta Diosojavabelia pacuenia vajëta copiata. ");
INSERT INTO guh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Icatsia Jesús naviarena pijajivijavaberena. Caxitajaraba icatsia Jesús pijajivi pemajitanubenaevi. Tsipaji baja Jesús pijajivi bitso itamajitsipana. Nexata Jesús pijajivi apo yapëtae pacuenia jumecanaviatsijitsia Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Icatsia abaxë Jesús naviata pecovëyabelia pevajëtsinexa icatsia Diosojavabelia. Bajaraxuacujinae, acueyabi baja xuabeje pevajëtsicujinae, Jesús icatsia rena pijajivijavaberena. Jumaitsi Jesús pijajivijavabelia: —¿Abaxë tsarovia tsiteca pamajitanubename? Ajibi rabaja. Copiapata rabaja paepatota xanë, Daxitajivi Pematapijinënë, necanajetsijitsia pibisiacuene pexanaevi pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Panonobapunare baja. Ponaenatsi baja. Imoxoyo rabaja najetaruca tajavajabitsaë pecobeyabelia tanecanajetsinënexa, jai Jesús pijajivijavabelia Judas yabara. ");
INSERT INTO guh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús pijavajabitsaë pevaetabijavatanexatsi, cuaicuaijai tsanucae pijajivijavabelia. Nexata bajarapaepatota patanajetaruca Judas, Jesús pijajivi doce ponëbejeyajuvënënëmi. Judas pënanajetarubenatsi jivi ayaibitsaëtoxaneto. Bajarapamonaeyajuvënëvi itsamonae canajetarubena espadanë. Itsamonae canajetarubena naebonë yajava. Bajarapamonae itorobatsi sacerdotevi penamatacaitorobivi, judíovi pecujarubivi ata, judíovi pijaancianovi ata. ");
INSERT INTO guh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas pebarërenavajënae bajarapamonae, copiaya baja cajena Judas tsipaeba pacuenia bajarapamonae yapëtaejitsia Jesúscuene. Judas jumaitsi mapacueniaje: —Ponë raja peneta bajacobiaya itabaratsutsunexuabianajë, bajaraponë Jesús tsane. Bajaraponë pavaetabianame. Pacobecëtsianame xaniavaetsia. Nexata panecobecëtsinë pacaponaeremena, jai baja cajena Judas pematacanajetarucaevijavabelia pebarërenavajënae. ");
INSERT INTO guh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nexata jane baja Judas itsa patanajetaruca, exana pacuenia baja cajena jumaitsi pematacanajetarucaevijavabelia. Judas Jesús itabaratsutsuniaya bajacobatsi, Judas jane baja pematacanajetarucaevi peyapëtaenexa Jesúscuene. ");
INSERT INTO guh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nexata jane baja Jesús pijavajabitsaë vaetabatsi. Cobecëtatsi xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bajarajota Jesús pijajiviyajuvënënë pijaespada navemarajonotaxuabina. Muxuyoropaebiaxuaba sacerdotevi pepo penamatacaitorobinë pijajivitonë. ");
INSERT INTO guh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nexata Jesús jumaitsi pevaetabivitsijavabelia: —Paxamë meta panetaneme betanacobetoxotsinë. Bajaraxuata pacaponame espadanë, naebonë yajava, patanevaetabinexamë pacuenia pavaetababiabame penacobetoxotsinë. ");
INSERT INTO guh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Xanë caematacabi canacujitsia Dioso pejumelivaisi paxamëjavabelia pacatsipaebabiabatsi templobota. Itsiata bajarapamatacabi apo panevaetabimë. Mara pacuenia panevaetabameje tanetocopiapatsixae baja pacuenia Dioso pejumelivaisibaxutota bajayata tajëvelia jumaitsi xanë yabara, jai Jesús pevaetabivitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nexata jane baja Jesús pijavajabitsaë pevaetabijavatatsi, daxita Jesús pijajivi xuabarëcëpecatsi pacuenia baja cajena Jesús jumaitsi tajëvelia pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pevëjëato pënanajetaruca Jesús pecaponaevitsi. Sábanata namataquinanajetaruca. Nexata pevëjëato bajarapamonae yasábanavaetabatsi. ");
INSERT INTO guh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nexata pevëjëato sábana naisinaxuaba. Najetabajirava jumasanë. ");
INSERT INTO guh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús caponaliatsi sacerdotevi pepo penamatacaitorobinë pijaboyabelia. Nacaetuata bajarajota daxita sacerdotevi penamatacaitorobivi, judíovi pijaancianovi ata yajava, judíovi pecujarubivi ata yajava. ");
INSERT INTO guh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Itsa baja Jesús caponaliatsi, nexata Pedro bajarapamonae pecovëya tajiyo najetaruca. Sacerdotevi pepo penamatacaitorobinë pijabo matatoyorotsia yacaranata ibopanaxanetonë, mataropotsia pefaratsijavaxanetota. Nexata bajarapayacaranatsijavaxaneto baupa, Pedro najoneya bopanabojavabelia, itsabelia Jesús cajunuatsi. Nexata sacerdotevi pepo penamatacaitorobinë pijabopanabota, Pedro nanonopeca isoto muxuneneta templobopijipolicíavita. ");
INSERT INTO guh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nexata bajarapabo ënëtuatuajëta sacerdotevi penamatacaitorobivi, judíovi pijaancianovi ata yajava, judíovi pecujarubivi ata yajava, nabarëcuaicuaijai. Bajarapamonae nayanijoba. —¿Jipatsa yapëtane Jesús pibisiacuene pexanaejava, paneconi yabara beyaxuabijitsiatsi? najai tsaponae. Itsiata bajarapamonae apo caxitajarabi itsaneconi ata Jesús pijaneconi. ");
INSERT INTO guh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Itsamonae saya penajumetsënëtsilivaisi paeba Jesús yabara. Itsiata caelivaisi najuapaebi ata, najumejëpaeya apo paebi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Itsamonae nonobapuna. Penajumetsënëtsilivaisi paeba Jesús yabara. Penonobapunaeviyajuvënënë jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Paxanë raja, pamatabëxëyo panubenajë majotaje, pajumetaniji Jesús pejumaitsijava. Bajaraponë jumaitsi: “Xanë raja xuabianicajë mapatemploboje, jivi pexanaebo. Acueyabi matacabita icatsia itsabo veretetsianajë. Jivi apo pexanaebo tsane,” jai maponë Jesúsje, jai penonobapunaeviyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Itsiata daxita bajarapamonae najumejëpaeya apo paebi. ");
INSERT INTO guh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nexata jane baja sacerdotevi pepo penamatacaitorobinë nonotapuna bajarapamonae pitabarata. Nexata jumaitsi Jesúsjavabelia: —¿Apo yapëtaemë tsaja itsalivaisiyo ata nejumecanaviatsinexa? ¿Xaniajai tsabaja pacuenia mapamonae caneconitsiajumaitsije? jai Jesúsjavabelia sacerdotevi pepo penamatacaitorobinë. ");
INSERT INTO guh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús itsiata moya. Apo jumepitsi cajena. Nexata icatsia sacerdotevi pepo penamatacaitorobinë jumaitsi Jesúsjavabelia: —¿Xamë tsabaja pepacuene Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenexa? ¿Xamë tsaja, Dioso pexënatomë? jai. ");
INSERT INTO guh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nexata Jesús jumaitsi bajaraponëjavabelia: —Jãjã, xanë rabaja. Paxamë raja panetaename, Daxitajivi Pematapijinënë, taecaejava Dioso pecujuanenia, daxitajamatabëcuene pecaëjëpaenëtsi. Panetaenamenua tanajetarucaejava athëbëvetsica itarërëbota, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bajarapacuenia Jesús pejumaitsijava itsa jumetane, sacerdotevi pepo penamatacaitorobinë penaxatatsijava anaeya titinaxuaba. Bajarapacuenia titinaxuaba pianaepanaexae Jesús pejumaitsijava yabara. Nexata sacerdotevi pepo penamatacaitorobinë jumaitsi daxita penacaetuatsivijavabelia: —Pijacuata rabaja pejumaitsijumeta naneconita. Pematatsënëa apo namatavenonaetsi itsamonae vajanacatsipaebinexa paneconi yabara maponëje naneconitsiaexanaejitsiatsi. ");
INSERT INTO guh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Paxamë rabaja pajumetaneme maponëje Dioso apo pejitsipaecuenia pecuaicuaijaijava. Tsipaji Dioso bepexënato nataeya cuaicuaijai. ¿Detsa nexata paxamë pajamatabëitsimë? jai sacerdotevi pepo penamatacaitorobinë daxita penacaetuatsivijavabelia. Nexata daxita penacaetuatsivi jumaitsi: —Naneconita rabaja Diosojavabelia. Nexata baja beyaxuabianatsi, jai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nexata bajarapamonaeyajuvënëvi Jesús itabarasuabatsi. Bajaraxuacujinae papaëbërëpanata itaxutocëtatsi. Pitaxutocëtsicujinaetsi itabaratsaquibabeponatsi pecobethaitonëta. Nexata bajarapamonae jumai tsaponae Jesúsjavabelia: —¡Vënëjonare ponë caitabaratsaquibabepona! jai tsaponae bajarapamonae. Bajaraxuacujinae templobopijipolicíavi itabarapacabiaxuabatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Itsa abaxë Jesús sacerdotevi pepo penamatacaitorobinë pijabo ënëtuatuajëalia yanijobaponatsi xua yabara naneconitsiaexanaejitsiatsi, Pedro naitaxutocaevetsiaya naeca bopanabota. Nexata bajarajota taeyetatsi petiriva, sacerdotevi pepo penamatacaitorobinë pijabota penacuenebiva. ");
INSERT INTO guh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bajarapova Pedro taeyetatsi penanonopecaejavata. Nexata bajarapova naitaxutobabatsia asaëya taenucatsi Pedro. Jumaitsitsi: —Xamë ata rabaja naponaponame Jesústa, Nazaret tomarapijinëta, jaitsi. ");
INSERT INTO guh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nexata Pedro itsiata nayavajunuaxaina Jesús pijajivitonëcuene. Nexata Pedro jumaitsi bajarapovajavabelia: —Jume raja. Apo yapëtaenë cajena bajaraponë. Apo yapëtaenë pacuene yabara nejumaitsimë, jai Pedro. Bajaraxuacujinae Pedro pejonebaupajavaverenajavabelia natixilia. Nexata vacara fiaba. ");
INSERT INTO guh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Icatsia bajarapova Pedro tanetsi. Nexata pamonae bajarajota nubena, bajarapamonaejavabelia bajarapova jumaitsi: —Mara ponëje Jesús pijajiviyajuvënënëje, jai bajarapova Pedro yabara. ");
INSERT INTO guh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Icatsia nexata Pedro jumaitsi: —Jume raja. Apo yapëtaenë cajena bajaraponë, jai. Bajaraxuacujinae, icatsia caeepatoyocujinae, bajarajota penubenaevi Pedro jumaitsitsi: —Xaniajai raeta baja cajena. Xamë Jesús pijajiviyajuvënënëmë. Tsipaji rabaja Galilea nacuapijinëmë. Galilea nacuapijivi pecuaicuaijaicuenia cuaicuaijamë, jaitsi. ");
INSERT INTO guh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nexata Pedro pejumexaniataenexatsi, ajumesaëya jumaitsi: —Itsa apo xaniajanë tsipae paxamëjavabelia, nexata Diosojavabelia naneconitsipajë. Apo yapëtaenë cajena ponë yabara panejumaitsimë, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Itsa baja Pedro najumevereta bajarapacuenia pejumaitsijava, vacara icatsia fiaba. Nexata bajarajota Pedro najamatabënapitajaraba pacuenia Jesús jumaitsitsi: “Anijajumebeje vacara pefiabivajënaeya, nayavajunuaxainaename tajajivitonëcuenemë. ‘Xanë cajena apo yapëtaenë bajaraponë,’ jamë tsane xanë yabara acueyabi xuabeje,” pejaijavatsi Jesús, Pedro najaaraba. Nexata bajarajota Pedro bitso najamatabëxaina Jesús pejumaitsijumetsi yabara. Pedro nexata nua. ");
INSERT INTO guh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ajena baja matacabi tsarucaponae, sacerdotevi penamatacaitorobivi, judíovi pijaancianovi ata yajava, judíovi pecujarubivi ata yajava, nacaetuata. Icatsia pematatsënëa itsamonae bajarapitsijamatabëcuenevi yajavanacaetuata penabarëcuaicuaijainexa. Bajaraxuacujinae bajarapamonae Jesús cobecëtsiaya caponaliatsi nacuaevetsinë Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nexata Pilato yanijobatsi Jesús. —¿Xamë tsaja judíovi pepo nevetsinë? jaitsi. Nexata Jesús jumaitsi Pilatojavabelia: —Jãjã, xanë rabaja pacuenia nejumaitsimë, jai Jesús Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdotevi penama itsamonae bajarapitsijamatabëcuenevi yajtacaitorobivi jumaitsi Pilatojavabelia: —Jesús raja bitso pibisiacuene exanabiaba, jai. ");
INSERT INTO guh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nexata icatsia Pilato yanijobatsi Jesús. —¿Itsalivaisiyo ata tsaja apo yapëtaemë nejumecanaviatsinexa? ¿Apo jumetaemë mapacuenia pecaneconitsijavaje? jaitsi. ");
INSERT INTO guh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Itsiata Jesús matavëjëa apo jumepitsi Pilatojavabelia. Bajaraxuata Pilato apo yapëtae pacuenia exanaejitsia Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nacuaevetsinë Pilato xaina pijacujirucuene. Caevai canacujitsia, pascua fiestamatacabi, Pilato copatabiaba caenë penaneconitsinë pepitsapaenexa penaneconitsivi pejebabiabibovecua. Pajivi yabara jivi Pilatojavabelia vajëcabiaba, Pilato nexata copatabiaba bajarapajivi pascua fiestamatacabi. Bajarapacuenia Pilato caenë copatabiaba jivi pesivajamatabëcuene xanepanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pamatacabi Jesús naneconitsiaexanatsi, bajarapamatacabi Barrabásvënënë jivi pebarëbevi barënaneconitsiaponapona penaneconitsivi pejebabiabibota. Barrabás, itsamonae yajava, barënabia picani gobierno pijajivijavabelia. Nexata taicatsi. Naneconitsiaexanejebatsi penaneconitsivi pejebabiabibota. ");
INSERT INTO guh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nexata jivi pona Pilatojavabelia. Jumaitsi bajarapamonae Pilatojavabelia: —Pacuenia pascua fiestamatacabi copatabiabame caenë pepitsapaenexa penaneconitsivi pejebabiabibovecua, bajarapacuenia panetocopare caenë pepitsapaenexa penaneconitsivi pejebabiabibovecua, jai bajarapamonae Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nexata Pilato jumaitsi bajarapamonaejavabelia: —¿Pajitsipame tsaja patacatocopatsijava pepitsapaenexa Jesús, pajudíovimë pepo papecaevetsinë? jai Pilato. ");
INSERT INTO guh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bajarapacuenia Pilato jumaitsi tsipaji yapëtane pajamatabëcuene yabara sacerdotevi penamatacaitorobivi tocaponarenatsi Jesús. Pilato jamatabëcueneyapëtane sacerdotevi penamatacaitorobivi Jesús pecueneitoyaxaetsi petocaponaejavatsirena. ");
INSERT INTO guh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nexata bajarapamonae asaëya vajëca Barrabás pecapitsapaenexatsi. Tsipaji baja cajena sacerdotevi penamatacaitorobivi muxubijiapenetsia jumaitsi jivijavabelia: —Asaëya pavajëcaename Barrabás pecopatsinexatsi. Nexata Barrabás copatsianatsi pepitsapaenexa penaneconitsivi pejebabiabibovecua. Pëtsa pavajëcame Jesús pecopatsinexatsi, jai baja cajena sacerdotevi penamatacaitorobivi jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nexata icatsia Pilato yanijoba jivijavabelia: —¿Detsa nexata xua pajitsipame taexanaenexa maponëjavabeliaje: “Judíovitsi pepo vajanacaevetsinë,” paneyabarajainëjavabelia? jai Pilato judíovijavabelia Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nexata bajarapamonae vavajai pinijijumeta. —¡Cruzajavabelia cobematabiabarutsiaexanare! jai Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nexata Pilato jumaitsi bajarapamonaejavabelia: —¿Detsa pitsineconi yabara nexata cobematabiabarutsiaexanaejitsipajë? jai Pilato Jesús yabara. Itsiata bajarapamonae icatsia pinijijumeta vavajai. —¡Cruzajavabelia cobematabiabarutsiaexanare! jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nexata baja Pilato tocopata Barrabás pepitsapaenexa penaneconitsivi pejebabiabibovecua jivi barajamatabëcuenexanepanaeya petaenexatsi. Nexata Pilato pijajivi, vajabitsaëvi, itoroba copiaya Jesús ayaicuenia pejumatitibabenexatsi penaneconitsivi pejumaconitabiabimacata. Bajaraxuacujinae Pilato tocopata baja Jesús vajabitsaëvi pecobematabiabarutsinexatsi cruzajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nexata baja vajabitsaëvi Jesús caponaliatsi nacuaevetsinë Pilato pijaboxanetojavabelia. Nexata bajarajota nacaetuata daxita vajabitsaëvi. ");
INSERT INTO guh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bajaraxuacujinae Jesús quenetsiataeya xatatatsi peraënaetsautsaucaejava. Xua nacuaevetsinë banaxatata, bajaraxua xatatatsi benacuaevetsinëcuenia petaenexatsi. Coronacuenia pemataxatatsinexatsi, peejuvitoyoroto tsimataexanatsi. Bajarapatoyoroto Jesús mataxatatatsi. ");
INSERT INTO guh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bajaraxuacujinae quenetsiataeya bajacobaponatsi. —¡Bajaco, judíovi pepo pevetsinë! jai tsaponae bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bajarapamonae caenë canacujitsia mataconibiaxuabaponatsi naebota. Suabaponatsinua. Beyaiyataeya itajara pematabacabëta tonubenajoneyabiabatsi Jesús pitabarata. ");
INSERT INTO guh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesús quenetsiataeya pecapocaponaecujinaetsi, vejumajonotatsi baja xua xatatatsi, peraënaetsautsaucaejava. Jesús baja icatsia xatatatsi penaxatatsijava. Caponaliatsi jane baja pecobematabiabarutsinexatsi cruzajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alejandrobeje Rufobeje paxa, Simónvënënë, Cirene tomarapijinë. Nexata Simón najetaruca vayafotusatojavaverena. Nexata vajabitsaëvi Simón junatatsi, pacruzajavabelia Jesús cobematabiabarutsijitsiatsi, peyavenonaeyacaponaenexa. ");
INSERT INTO guh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Caponaliatsi Jesús Gólgotavënë tsutojavabelia. “Gólgota,” itsa jai hebreojumeta, mapajumetaje pejumaitsijume: “Jivimatasipatsuto,” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bajarajota picani Jesús rajutatsi vinora piapaenexa, pematajërëabira mirravënëjavata, bitso penavixaetaeyaniva pecobematabiabijavatatsi cruzajavabelia. Itsiata Jesús apo apae. ");
INSERT INTO guh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nexata jane baja Jesús vajabitsaëvi cobematabiabarutatsi cruzajavabelia. Bajaraxuacujinae vajabitsaëvi bajarajota canamuxusita beibotoxi. Bajarapacuenia canamuxusita peyapëtaenexa ponë pitaponaejitsia caejava canacujitsia Jesús penaxatatsijavami, xua jumaponapona. Bajarapacuenia vajabitsaëvi natsicobetsana Jesús penaxatatsijavami. ");
INSERT INTO guh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bajayacunuaepatota, a las nueve, Jesús cobematabiabarutatsi cruzajavabelia. ");
INSERT INTO guh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bajarajota Jesús pematabocoto matatsënëyo yaquinaruta tablapayota itsamonae ata peyapëtaenexa pajamatabëcuene yabara Jesús cobematabiabarutatsi cruzajavabelia. Jumai tsarutsi peyaquinarutsiitane cruzajavata mapacueniaje: “Mara ponëje judíovi pepo pevetsinëje,” jai tsarutsi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Anijanëbeje penacobetoxotsinëbeje, Jesús yajavacobematabiabarutatsi. Caenë canacujitsia pijacruzata rubatsi. Bajaraponëbeje Jesús pemuxuneneta rutatsibeje. Itsanë Jesús pecujuanenia rutatsi. Itsanë Jesús petsavenonenia rutatsi. ");
INSERT INTO guh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bajarapacuenia Jesús itsa yajavacobematabiabarutatsi penacobetoxotsinëbeje, nexata Jesús tocopiapatatsi pacuenia baja cajena Dioso pejumelivaisibaxutota tajëvelia jumaitsi Jesús yabara. Dioso pejumelivaisibaxutota tajëvelia jumaitsi Jesús yabara mapacueniaje: “Naneconitsiaexanaenatsi bepibisiacuene pexanaenëcuenia,” jai baja cajena tajëvelia Dioso pejumelivaisibaxutota Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jesús pecobematabiabarutsijavatatsi cruzajavabelia, bajaraxuayo penajetarubenaevi Jesús itaropitsiaya bijataeyabiabatsi. Jumai tsabiabi bajarapamonae: —Yiara jane maitsimëje. Xamë raja imata jumaitsimë: “Xuabianicajë templobo. Acueyabi matacabita icatsia veretetsianajë itsabo,” jamë. ");
INSERT INTO guh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nacapanepare jane baja nijacuata. Cruzajavavetsica runaimica, jai tsabiabi Jesúsjavabelia bajaraxuayo penajetarubenaevi. ");
INSERT INTO guh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bajara pijinia pacuenia sacerdotevi penamatacaitorobivi, judíovi pecujarubivi ata, capocaponatsi Jesús. Ëpamonae najumaitsi: —Maponëje itsamonae yabara jumai tsabiabi: “Capanepaenajë jivi,” jai tsabiabi. Caranata pijacuata penacapanepaenexa, apo caëjëpaetsi. ");
INSERT INTO guh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Itsa xaniajai pepacuene Cristo, athëbëvetsica Dioso pitorobinëtsica jivi pecapanepaenexa, Israel nacuapijivi pepo pevetsinënexanua, aeconoxae runaenica cruzajavavetsica vajataenexa. Nexata jane baja jumecovënëtsianatsi Cristonëcuene, najai bajarapamonae capocaponaeya Jesús yabara. Ponëbeje ata Jesús yajavacobematabiabarutatsi, bajaraponëbeje ata, Jesús bijataerucatsibeje. ");
INSERT INTO guh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesús baja itsa tëpaejitsia, ajena matonejejitsia, daxita nacuajava aitaquiri tsajuni. Matapania caniviyojavabelia, bejamatabëcuene a las tres, nacua napebeta icatsia. ");
INSERT INTO guh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nexata icatsia paepatota nacua napebeta, bajarapaepatota pinijicuenia Jesús aëjai. Jumaitsi: —Eloi, Eloi, ¿lama sabactani? jai Jesús. Bajarapacuenia Jesús itsa jumaitsi pijajumeta, mapajumetaje pejumaitsijume: “TajaDioso, tajaDioso, ¿detsa xuajitsia baja tajaepato necopatame?” pejaijume. ");
INSERT INTO guh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nexata itsamonae bajarajota penubenaevi bijiaya jumetane bajarapacuenia Jesús pejumaitsijava. Nexata saya jamatabëcuenenavëxaniabiaya jumaitsi bajarapamonae: —Jica, pajumetaema. Mara ponë junata profeta Elíaspijinëmije, Diosojumepaebinëmi, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nexata bajarapamonaeyajuvënënë piajatuvinorayalia bepijia jabutaxuaba esponjavënëjava. Bajaraxuacujinae esponjavënëjava naeboupita cëtaruta. Toyotsiatsi picani Jesús petsutsuninexa bajaraxua. Ponë picani Jesús toyotsiatsi bajaraxua petsutsuninexa, bajaraponë jumaitsi penajuanubenaevijavabelia: —Bajarapacuenia abaxë copatarutatsi Jesús. Taenatsi Elíaspijinë itsa najetaruca cruzavecua penutsinexatsitsica Jesús, jai bajaraponë capocaponaeya. ");
INSERT INTO guh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús icatsia pinijicuenia aëjai. Bajaraxuacujinae jane baja Jesús tëpanajereca. ");
INSERT INTO guh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Paepatota Jesús tëpanajereca, bajarapaepatota templobo ënëtuatuajëalia peyatuucutarutsipana, ayaipapaëbërëpanaxaneto, titititica tuatuajëareca, athëbëvetsicacujinae irabereca. ");
INSERT INTO guh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nexata paepatota Jesús tëpanajereca, vajabitsaëvi pijacapitán Jesús pitabara canacujitsialia nuca. Nexata bajaraponë taenuca Jesús pinijicuenia peaëjaijava. Taenucanua Jesús petëpanajetsijavareca. Nexata vajabitsaëvi pijacapitán jumaitsi: —Matsaena ponë tëpaje, pepacuene baja rovia Dioso pexënato, jai. ");
INSERT INTO guh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bajarajota petiriavibitsaëtoxaneto tajiyoverena taenubena Jesús petëpaejava. Bajarapapetiriavi tuatuajëta nanubena mapamatabëxëyoje. Itsava Maríavënëva, Magdala tomarapijiva. Itsava Salomévënëva. Itsava icatsia Maríavënëva. Bajarapova Santiagobeje Josébeje pena. Bajaraponë Santiago, pevëjëato abaxë itsanë Santiagovënënëvecua. ");
INSERT INTO guh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pamatacabi abaxë Jesús ponapona Galilea nacuata, bajarapapetiriavi Jesús pënajinavanapatsi peyavenonaenexatsi. Papetiriavibitsaëtojavata Maríabana nanubena, bajarapapetiriavi ata Maríabana Jesús najuapënaponarena Galilea nacuaverena Jerusalén tomaraberena. ");
INSERT INTO guh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","José Arimatea tomarapijinë, judíovi pevetsinë, peyaiyataenëtsi. Bajaraponë José copiaevetaponapona pecopiapatsijava pamatacabi caenë Dioso evetsijitsia daxita pijajivi mapanacuataje. Judíovi baja penacueraevetsimatacabinexa pevajënaeya pamatacabi, caniviyotsia baja. Bajarapamatacabi judíovi banacuenevereta baja penacuenebijava. Nexata bajarapaepatota José acueneura ata, najamatabësaëta. Nexata lia nacuaevetsinë Pilatojavabelia. Nexata José vajëta Pilatojavabelia petocopatsinexatsi Jesús petëpaenë pemëthëtsinexa. ");
INSERT INTO guh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nexata Pilato jamatabëjumaitsi: —Xaniajai tsamë rabaja Jesús tëpa, jamatabëjai tsipaji abaxë bajayajebi Jesús apo rucae cruzajavabelia pecobematabiabarutsicujinaetsi. Nexata Pilato junata vajabitsaëvi pijacapitán. Nexata Pilato yanijoba vajabitsaëvi pijacapitánjavabelia, Jesús petëpaecuene Pilato peyapëtaenexa. ");
INSERT INTO guh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nexata vajabitsaëvi pijacapitán tsipaeba Pilatojavabelia. —Jesús rabaja capanepaeya tëpa, jai. Nexata jane baja Pilato José tocopatatsi cruzajavavetsica pepitsinexa Jesús petëpaenë. ");
INSERT INTO guh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nexata José comuata pexaniaviriasábana. Bajaraxuacujinae José jane baja cruzajavavetsica pitsica Jesús petëpaenë. Daxitanëreca mataquionaeya matacacëba pexaniaviria piapiasábanapanata. Bajaraxuacujinae itsajota cajena José iboitapajanitojavata pinijiibovaju exanaeyaexanabuata petëpaevi pebuataponaenexa, bajarapaibovajualia José buata Jesús petëpaenë. Bajaraxuacujinae pinijiibopanaxaneto José tixirena. Yavajuvëpaacatabuata. ");
INSERT INTO guh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdala tomarapijiva, itsava pijinia María, José pena, bajarapovabeje tanebeje itsajota Jesús buatatsi petëpaenë. ");
INSERT INTO guh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judíovi baja penacueraevetsimatacabi itsa verevereca, acueyabi povamaxëto comuata petuxujuvira. Itsava Maríavënëva, Magdala tomarapijiva. Itsava Salomévënëva. Itsava icatsia Maríavënëva. Bajarapova Santiago pena. Bajarapamonae petuxujuvira comuata peperabëexabinexa picani Jesús petëpaenë. ");
INSERT INTO guh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nexata baja judíovi penacueraevetsimatacabi itsa verevereca, meravia pitsijavata, ajena baja matacabi tsarucaponae, bajarapamonae ponalia Jesús pebuatsiibovajutsijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nexata bajarapamonae namutualia najumaitsi tsanajetarubenae: —¿Jipatsa meta nacatotixitsiana Jesús peyavajuvëpa acatabuatsiibopanaxanetotsi? najai tsanajetarubenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nexata bajarapamonae itsa imoxoyotabuatapona, naëcobarëcëpalia ibovajujavabelia. Nexata taeyabuata ibopanaxanetomi petixitabuatsijavalia ibovajuvëpavecua. Bajarapaibopana bitso pinijiibopanaxaneto. ");
INSERT INTO guh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nexata petiriavi itsa joneya Jesús pebuatsiibovajutsijavalia, taeyeta pecujuanenia pevëjëato. Bajaraponë naxatateca piapiajava penioponaejava. Nexata petiriavi najunaviaca. ");
INSERT INTO guh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nexata pevëjëato jumaitsi petiriavijavabelia: —Pëtsa panajunaviacame. Paxamë picani pajaitame Jesús, Nazaret tomarapijinë, ponë cobematabiabarutatsi cruzajavabelia. Asaë rabaja icatsia bajaraponë petëpaecujinae. Ajibi rabaja tsarucae majotaje. Pataema jane itsajota picani buatatsi. ");
INSERT INTO guh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Paponare baja. Patsipaebianame pijajivijavabelia, Pedrojavabelia ata. Pajumaitsimë tsane bajarapamonaejavabelia: “Jesús pina panevajënaeyabelia pona Galilea nacuayabelia. Baja pina jotalia pacaxitajarabianame Jesús pacuenia baja pacajumaitsitsi,” pajamë tsane pijajivijavabelia, jai pevëjëato petiriavijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nexata saya bajarapapetiriavi rëcëpeca Jesús pebuatsiibovajutsivecua. Neconecojai saya pecajunavi. Nexata namutoepatua apo tsipaebi itsajivijavabelia ata. Tsipaji bitso junava. ");
INSERT INTO guh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Judíovi baja penacueraevetsimatacabi itsa verevereca, meravia pitsijavata, ajena baja matacabi tsarucaponae, Jesús icatsia asaë petëpaecujinae. Bajarapamatacabi copiata Jesús tsitanaitajëta María, Magdala tomarapijivajavabelia. Bajarapova cajena copiaya Jesús vecuacapitsapa siete padovathibeje itsa abaxë Jesús apo beyaxuabitsi. ");
INSERT INTO guh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nexata María, Magdala tomarapijiva, Jesús petsitanaitajëtsicujinaetsi, pona Jesús pijajivijavabelia. Nexata María pevajënae Jesús pijajivi abaxë vënueyena Jesús. Nexata María itsa pata Jesús pijajivijavabelia, tsipaeba pacuenia María tane Jesús. ");
INSERT INTO guh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María jumaitsi Jesús pijajivijavabelia: —Jesús rabaja icatsia asaë petëpaecujinae. Taniji rabaja tajacuata, jai. Itsiata Jesús pijajivi apo jumexaniataetsi María. ");
INSERT INTO guh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesús pijajivitonëbeje najetarucabeje namutua. Nexata Jesús pijajivitonëbeje namutua penajetarucaejavatabeje, Jesús tsitanaitajëta beitsanëcuenia pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nexata Jesús pijajivitonëbeje itsa tanebeje Jesús, naviatecabeje. Nexata pacuenia tanebeje Jesús, tsipaebabeje itsamonae Jesús pijajivijavabelia. Itsiata bajarapamonae apo jumexaniataetsibeje. ");
INSERT INTO guh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bexëajavabelia icatsia Jesús tsitanaitajëta pijajivi once ponëbejejavabelia penabanenaejavata mesata. Nexata Jesús pinijicuenia muxujioba pijajivi piajamatabëcuenetajaxae. Muxujiobanua apo pejumecovënëtsixae petsipaebijavatsi pamonae tane Jesús icatsia piasaëjava petëpaecujinae. ");
INSERT INTO guh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nexata Jesús jumaitsi pijajivijavabelia: —Paponare daxitanacuanëjava daxitajivi panetsipaebanajetarubenaenexa pexanialivaisi pecapanepaelivaisinexatsi. ");
INSERT INTO guh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pajivi jumecovënëtsiana bajarapalivaisi, nexata pabautisabianame. Bajarapajivi Diosojavabelia capanepaenatsi. Pajivi apo jumecovënëtsi tsane bajarapalivaisi, daxitamatacabijavabelianexa naneconitsiana Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pamonae peneta jumecovënëtsiana bajarapalivaisi, mapacuenia exanavanapaenaje. Tavënëta jivivecua capitsapaponaena dovathi. Itsaviriajumetanua, apo penatsipaebijumemi ata, jemata natsipaebiana. ");
INSERT INTO guh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bajarapamonae jomo pecobeta pitsi ata tsane, apae atanua tsane jivi petëpaeyaexanaera, itsiata apo tëpae tsane. Bajarapamonae itsa nacobebuatsiana piavitanejivi pematatsënëvereca, pejayatsijivi jamatejema tsane piavitanejavavecua, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Vajatuxanenë Jesús livaisi petsipaebicujinae pijajivijavabelia, Dioso baja pesaëta catsiatsi athëbëabetsia. Nexata athëbëtatsia Jesús eca Dioso pecujuanenia penajuaevetsinexabeje daxitacuene. ");
INSERT INTO guh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nexata jane baja Jesús pijajivi daxitanacuanëjava jivi tsipaebanajetarubena bajarapapexanialivaisi. Nexata daxita pamonae jumetaeyabiabatsi, jumecovënëtabiabatsi pexaniajailivaisi petsipaebicuene. Tsipaji Jesús pijajivi jamatabëcueneyavenonabiaba Jesús pijajivi pinijicuene pexanaenexa jivijavabelia livaisi petsipaebabiabijavata.");
INSERT INTO guh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Pamatacabi abaxë Jesús ponapona mapanacuataje, jivi ayaibitsaëtoxaneto tanetsi peponaponaejava. Bajarapamonae tanetsi Jesús petaxuxuabijavaveliacujinae jivi livaisi petsipaebaponaejava. Nexata bajarapamonae paebanajetarubena tomaranëjava Jesús pelivaisi, pexanialivaisi. Nexata tomaranëjava Jesús pelivaisi pejumetaevi, ayaibitsaëto, baja cajena yaquina juya mataropotsia petsipaebinexa itsamonaejavabelia. Pacuenia Jesús petaevitsi vajunupaebatsi, bajarapamonae yaquina baja cajena Jesucristo pelivaisi. ");
INSERT INTO guh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nexata xanë ata mapamatacabitaje yanijobaponajë bajarapalivaisi daxita peyapëtaevijavabelia. Yanijobaponajë xaniavaetsia tayapëtaenexa pacuenia Jesús exanaponapona petaxuxuabijavaveliacujinae mapanacuataje. Teófilo, catoyaquinatsi. Catoyaquinatsi mapabaxutotaje xamë ata xaniavaetsia neyapëtaenexa daxita bajarapalivaisi, Jesucristo pelivaisi. Netsitaxanepana tacatoyaquinaenexa daxita bajarapalivaisi neyapëtaenexa pacuenia jumai tsaponae caelivaisi canacujitsia Jesús pexanaponaejavanë yabara, caejava canacujitsia. ");
INSERT INTO guh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Copiaya baja picani itsamonae catsipaeba bajarapalivaisi. Itsiata icatsia xanë catoyaquinatsi neyapëtaenexa jane baja xaniavaetsia bajarapalivaisi pexaniajailivaisicuene. ");
INSERT INTO guh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pamatacabi abaxë Herodes eveta Judeanacua, bajarapamatacabi ponapona sacerdotenë Zacarías. Bajaraponë sacerdotevi Abíasvënëviyajuvënënë. Zacarías pijava pevënë Elisabet. Bajarapova sacerdotenëmi Aarónpijinë pemomoxiyajuvënëva. ");
INSERT INTO guh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bajarapajivibeje xaniavaetsia aneconijibia Dioso pitabarata toponaponabeje. Dioso jumecovënëtsiaya ponaponabeje pacuenia Dioso itorobatsi judíovi xaniavaetsia pejinavanapaenexa. ");
INSERT INTO guh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Itsiata bajarapajivibeje pexi apo xainaebeje. Tsipaji Elisabet mavecova. Nexata bajarapajivibeje bitso baja perujujiviyobeje. ");
INSERT INTO guh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nexata itsamatacabi Zacarías templobota nanacuenebijitsia sacerdotevi penacuenebicuene Dioso pitabarata. Pasemanata daxita sacerdotevi, Abíasvënëvi, nacobenaevetsijitsia templobo, bajarapasemana Zacarías daxitasemana nanacuenebijitsia templobota. ");
INSERT INTO guh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nexata abaxë sacerdotevi petaxuxuabivajënaeya penacuenebijava, pijacujirucuenia exana penayapëtaeponaenexa xua caenë canacujitsia nacuenebijitsia templobota. Nexata sacerdotevi pijacujirucuenia pexanaecujinae, itsa baja yapëtane xua caenë canacujitsia nacuenebijitsia templobota, nexata Zacarías tocopatatsi temploboënëalia petajuitsinexa inciensovënëjava, petuxujuvijava. Bajaraxuata Zacarías joneya temploboyalia petajuitsinexa jane baja inciensovënëjava temploboënëalia. ");
INSERT INTO guh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Paepatota Zacarías tajuitanuca inciensovënëjava temploboënëalia, jivi ayaibitsaëtoxaneto templobojumavelia vajëcanubena Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nexata Zacarías temploboënëalia, altarvënëjava muxuneneta, tsitanaitajëtatsi ángel. Paaltarvënëjavajumata incienso tajuitabiaba Diosonexa, bajarapaaltarvënëjava pecujuanenia pamuxunenejavata, Zacarías taenuta ángel. ");
INSERT INTO guh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nexata Zacarías itsa taenuta ángel, apo yapëtae pacuenia exanaejitsia Zacarías. Bitso jamatabëcuenenajunaviaca. ");
INSERT INTO guh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nexata ángel jumaitsi Zacaríasjavabelia: —Zacarías, pëtsa junavame. Dioso baja cajena cajumetane nevajëtsijava. Nexata nijava Elisabet catonacoxitsiana. Nexënatonëyo baja xainaename. Vënërubianame bajaraponëyo Juan. ");
INSERT INTO guh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pinijicuenia, jivi ayaibitsaëto yajava, barëyamë tsane bajaraponëyo itsa catonaexanaena. ");
INSERT INTO guh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tsipaji bajaraponëyo ayaijamatabëcuenenë tsane Dioso pitabarata. Apo apae tsane piataneranë. Vinora ata apo apae tsane. Penaexanaejavaveliacujinae tsijamatabëvënëcaenatsi Espíritu Santo. Nexata Espíritu Santo pitorobicueniatsi, exanabiabiana. ");
INSERT INTO guh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bajaraponë, Juan, Israel nacuapijivi najamatabëcuenecopatsiaexanaena Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bajayata Diosojumepaebinëmi, profeta Elíaspijinë, ayaijamatabëcuenenëmi, Dioso pesaë yajavaponapona. Espíritu Santo ata pitorobicueniatsi, exanaponapona. Bajara icatsia itsane Juan ata. Bajaraponë pejamatabëcueneta, penacoxiitoyavimi ata, icatsia nacoxiasiva tsane. Bajaraponë pejamatabëcueneta, itsamonae pijinia pibisiajamatabëcuene pexainaevi ata, jamatabëcuene xanepanaeyaexanaena pexaniajamatabëcuene pexainaenexa. Bajarapacuenia bajaraponë jivi jamatabëcuene xanepanaeyaexanaena pepo petuxanenë penajetarucaevajënaeya. Nexata bajarapamonae xaniavaetsia copiapitsiana pepo petuxanenë pamatacabi najetarucaena, jai ángel Zacaríasjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías nexata yanijoba ángeljavabelia. Jumaitsi: —Itsa taxënato xainaejitsianë, ¿detsa peneta pitsicuene taenajë tayapëtaenexa? Tsipaji rabaja xanë perujunënë. Tajava ata baja perujuva, jai Zacarías. ");
INSERT INTO guh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nexata ángel jumaitsi Zacaríasjavabelia: —Xanë raja Gabrielnë, Dioso pijajivitonënë. Dioso baja cajena nitoroba tacatsipaebinexa mapapexanialivaisije. ");
INSERT INTO guh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Xamë saya nejumeaebame, xaniavaetsia catsipaebi atatsi xua pepacuene catocopiajopaejitsia. Nexata baja aeconoxae apo cacaëjëpae tsane necuaicuaijaijava. Matapania jane baja pamatacabi catocopiajopaena xua yabara najumecapanepaeya catsipaebatsi, natsipaebianame icatsia, jai ángel Zacaríasjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bajarapaepatota jivi templobo jumavelia evetanubenatsi Zacarías pepitsapaejavarena. Najumaitsi bajarapamonae: —¿De meta xuajitsia Zacarías bepijia apo pitsapaerena templobovecua? najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Itsa jane baja Zacarías pitsaparena templobovecua, apo caëjëpaetsi pecuaicuaijaijava. Nexata pamonae evetanubenatsi templobo jumavelia, najumaitsi: —Zacarías raeta bemajitsinaebota temploboënëlia itsacuene tane, najai. Nexata Zacarías apo pecaëjëpaexaetsi pecuaicuaijaijava, pecobeta tsipaeba besiyanëcuenia jivi peyapëtaeyaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Itsa baja Zacarías vereta penacuenebijava templobota pamatacabibeje itorobatsi penacuenebinexa, naviata baja pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bajaraxuacujinae Zacarías pijava, Elisabet, nacoxita jane baja. Nexata bajarapova penacoxitsijava itsa yapëtane, cinco pajuametobejecuenia itsajavabelia pijabovecua apo ponaponae. ");
INSERT INTO guh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet jamatabëjumaitsi: —Dioso raja taneitaxutotsoniataexae, neyavenona tanacoxitsinexa mapacueniaje. Nexata baja apo auranë tsane tacoxibijava yabara, jamatabëjai Elisabet. ");
INSERT INTO guh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet baja seis pajuametobeje pepuaxainae penacoxitsicujinae, Dioso icatsia itoroba pijaángel Gabriel. Pijaángel itoroba Nazaret tomarabelia, Galilea nacuata peecaetomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dioso itoroba ángel petsipaebinexa Maríajavabelia. María abaxë pebi apo pequenetsiataevatsi. Angel pepatsivajënaeya Maríajavabelia, Maríabeje baja cajena Josébeje nabarëcuaicuaijaibeje penapitsinexabeje. Nacuaevetsinëmi Davidpijinë pemomoxiyajuvënënë José. ");
INSERT INTO guh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel nexata joneya María peponaponaebota. Angel jumaitsi Maríajavabelia: —María, cabajacobatsi. Pexaniajamatabëcuenia Dioso pecataeva. Dioso cayajavaponaponaena. Bitso cayavenonaena xamë daxita nevëna petiriavi matatoxenetsia, jai ángel. ");
INSERT INTO guh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nexata María itsa jumetane bajarapacuenia ángel pejumaitsijavatsi, María jamatabëjumaitsi: —¿Detsa meta pitsijamatabëcuene yabara nejumaitsi ángel mapacueniaje? jamatabëjai María. ");
INSERT INTO guh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Icatsia ángel tajëvelia jumaitsi Maríajavabelia: —María, pëtsa junavame. Tsipaji raja Dioso pexaniajamatabëcuenia catane. ");
INSERT INTO guh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xamë raja nacoxitsianame. Cavecuanaexanaena raja pebinëyo. Bajaraponëyo vënërubianame Jesús. ");
INSERT INTO guh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bajaraponëyo ayaijamatabëcuenenë tsane. “PinijiDioso, athëbëtatsia peecaenë, mapexënatoje,” jaitsi tsane jivi. Nexata vajatuxanenë Dioso nacuaevetsinë exanaenatsi. Pacuenia pijasalinainëmi Davidpijinë bajayata nacuaevetsinëmi, bajara icatsia itsane. ");
INSERT INTO guh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bajaraponë evetsiana Israel nacuapijivi daxita matacabijavabelianexa, jai ángel tajëvelia Maríajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nexata María jumaitsi ángeljavabelia: —¿Detsa pacuenia nacoxitsipajë? Xanë raja tamona apo xainaenë, jai María ángeljavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel nexata tajëvelia jumaitsi Maríajavabelia: —Espíritu Santo raja patsianica xamëjavabetsica. Nexata Espíritu Santo Dioso pesaëta caevetsiana. Bajaraxuata panacuetonëyo cavecuanaexanaena, tsatsianatsi Diosonexa. “Dioso ra mapexënatoje,” jaitsi tsane jivi. ");
INSERT INTO guh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nijamonaeva ata Elisabet, perujuva ata, exanaena penacuetonëyo. “Mavecova raja,” jai atatsi jivi, itsiata baja penacoxitsicujinae xaina baja seis pajuametobeje. ");
INSERT INTO guh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dioso raja caëjëpatsi daxitacuene pexanaenexa, jai ángel tajëvelia Maríajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nexata María jumaitsi ángeljavabelia: —Xanë raja Dioso pijajivitovanë. Pacuenia nejumaitsimë, bajarapacuenia Dioso xanëjavaberena exanaena, jai María. Nexata baja María vecuaponatsi ángel. ");
INSERT INTO guh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","María penacoxitsijavanexa petsipaebicujinaetsi ángel, caematacabibejecujinae, María pona petsutonënacuata peecaetomarabelia. Bajarapatomara eca Judea nacuata. ");
INSERT INTO guh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nexata María joneya Zacarías pijaboyalia. Bajacobanuta pijamonaeva Elisabet. ");
INSERT INTO guh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María itsa bajacobanuta Elisabet, nexata Elisabet peyacotajinaenacuetoyo tsicotonayucutajarabatsi. Nexata jane baja Elisabet tsijamatabëvënëcatsi Espíritu Santo. ");
INSERT INTO guh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nexata Elisabet Espíritu Santo itorobatsi pinijijumeta Maríajavabelia pejumaitsinexa mapacueniaje: —Dioso cajena bitso cayavenona daxita petiriavi matatoxenetsia. Panacuetonëyo ata exanaename, bajarapanacuetonëyo Dioso bitso peyavenonabiabinëtsi tsane. ");
INSERT INTO guh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Xamë tajatuxanenë penamë tsane. ¿Detsa xuajitsia beveliajamatabëcueneva atanë, nesivaxainamerë? ");
INSERT INTO guh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Itsa nebajacobanutame, tayacotajinaenacuetoyo nayucutajaraba pebarëyaxae. ");
INSERT INTO guh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Barëyamë Dioso pecajumaitsicuenia nejumecovënëtsiva. Tsipaji pepacuene catocopiapatsiana daxita pacuenia vajatuxanenë Dioso pitorobinëtsica ángel tajëvelia catsipaeba, jai Elisabet Maríajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nexata María jumaitsi Elisabetjavabelia: Tajamatabëëthëtojavavetsina jumaitsinë Diosojavabelia: “Ayaijamatabëcuenenëmë bitso,” janë. ");
INSERT INTO guh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sivajamatabëcuenebarëyanë Dioso tanecapanepaenënexa. ");
INSERT INTO guh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sivajamatabëcuenebarëyanë. Tsipaji pijajivitovanë, beveliajamatabëcueneva atanë, Dioso nitapeta. Tatëpaecujinae ata tsane, tavënamuto, pevajënaeyabelia daxitajivi xanë yabara jumai tsabiabi tsane: “Dioso bitso peyavenonaevamitsi,” jai tsabiabi tsane. ");
INSERT INTO guh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bajarapacuenia daxitajivi jumai tsabiabi tsane xanë yabara. Tsipaji ayaijamatabëcuenenë Dioso netoexanabiabiana ayaicuene pexanaejavanë. Dioso raja apo pejitsipaenë jivi pibisiacuene pexanaejava. ");
INSERT INTO guh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Daxita pamonae Dioso yaiyataena, bajarapamonae juya Dioso itaxutotsoniataeyabiabiana. ");
INSERT INTO guh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dioso raja pecaëjëpaenëtsi pinijicuene ata pexanaenexa pecobeta. Pamonae jamatabëjumaitsi tsavanapae: “Vaxaitsi cajena ayaijamatabëcuenevitsi,” jamatabëjai tsavanapae, bajarapamonae Dioso nacayajatsiaexana baja. ");
INSERT INTO guh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pinijinacuanë pevetsivimi ata, bajarapanacuanë pevetsijavami Dioso vecuapitsapaeyaexana. Nexata bajaraxuacujinae Dioso juya evetsiaexana bajarapanacuanë beveliajamatabëcuenevimi ata. ");
INSERT INTO guh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pamonae pijinia bitso piajani, bajarapamonae Dioso rajuta pexanianabanijava. Pamonae pijinia bitso pexainaevi mapanacuapijicuene, bajarapamonae Dioso apo pejumecovënëtsixae, bajarapamonae Dioso apo rajutsi. ");
INSERT INTO guh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dioso yavenona pijajivi, Israel nacuapijivi. Apo nacofënëtsi cajena. Dioso itaxutotsoniataeyabiaba Israel nacuapijivi. ");
INSERT INTO guh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bajarapacuenia Dioso pijajivi itaxutotsoniataeyabiaba daxitamatacabijavabelianexa. Tsipaji baja cajena bajarapacuenia Dioso najumecapanepaeya jumaitsi vajasalinainëmi Abrahampijinëjavabelia, daxita pemomoxijavabelianexa ata pitaxutotsoniataeyabiabijavanexa yabara, jai María Elisabetjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nexata María acueyabi pajuametobeje naponapona Elisabet pijabota. Bajaraxuacujinae María baja naviata pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Juameto baja ecaica, pajuametota Elisabet penacueto vecuanaexanaejitsiatsi. Penacuetonëyo jane baja vecuanaexanatsi. ");
INSERT INTO guh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Itsa Elisabet yapëtane Dioso pitaxutotsoniataecuenetsi, bitso Elisabet jamatabëcuenebarëya. Daxita pamonae ata ena imoxoyo, pijabo muxuneneta, bajarapova pijamonaeyajuvënëvi ata, sivajamatabëcuenebarëyatsi. ");
INSERT INTO guh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Itsa baja penacuetonëyo caesemana xaineca penaexanaecujinae, Elisabetbeje Zacaríasbeje pexënatonëyo perabëcaucutsiaexanabeje judíovicuenia. Baitsi boupiperabëcaucutsiaexanabeje. Nexata daxita bajarapamonae pata Elisabetbeje Zacaríasbejejavaberena. Bajarajota picani penacuetonëyo tovënërubijitsiatsibeje paxa pevënëcuenia paxa picani pevënëxainaenexa. ");
INSERT INTO guh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Itsiata Elisabet jumaitsi pamonaejavabelia picani tovënërubijitsiatsibeje: —Jume. Pevënë raja tsane Juan, jai Elisabet bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nexata bajarapamonae jumaitsi: —¿Detsa xuajitsia jitsipame bajarapavënë? Itsanë ata cajena nijamonaeyajuvënënë apo xainae bajarapavënë, jai bajarapamonae Elisabetjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nexata bajarapamonae penacuetonëyo jane baja paxa junata. Pecobeta yanijoba pavënë Zacarías jitsipa petovënërubinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nexata Zacarías vajëta tablapayo peyaquinaenexa. Nexata yaquinaruta: “Juan rabaja pevënë,” pejaiitane. Nexata daxita bajarapamonae jamatabëcuenenabenajaca. ");
INSERT INTO guh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bajarajota jemata icatsia Zacarías cuaicuaijai baja. Nexata jivi pitabarata Zacarías jumai tsaponae Diosojavabelia: —Diosomë, ayaijamatabëcuenenëmë bitso, jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Daxita pamonae bajarapatomarata imoxoyo penaevi, itsa jumetane pacuenia Zacarías Dioso yavenonaponatsi, pinijicuenia jamatabëcuenenabenajaca. Itsamonae bajarapanacuata petsutonëjava penaevi ata, daxita bajarapamonae ata, vënëlivaisitane bajarapacuene yabara. ");
INSERT INTO guh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Daxita pamonae jumetane bajarapacuene yabara, apo nacofënëtsi. Jamatabënajinavanapabiaba bajarapacuene. Nexata bajarapamonae nayanijobabiaba. —¿De meta jamatabëcueneitsi tsane bajarapanacuetonëyo itsa vitsabiana? najai tsabiabi bajarapamonae. Bajarapacuenia nayanijobabiaba tsipaji bitso Dioso yavenonaponatsi bajarapanacuetonëyo. ");
INSERT INTO guh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, Juan jivibautisabinënexa paxa, tsijamatabëvënëcatsi Espíritu Santo. Nexata Zacarías Espíritu Santo itorobatsi jivijavabelia pejumaitsinexa mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Pexaniajamatabëcuene rajutatsi vaxaitsi pepo vajatuxanenëjavabelia, Israel nacuapijivitsi vajaDiosojavabelia. Tsipaji pijajivitsi nacatoitorobianica vajanacacapanepaenënexa vajaneconivecua. ");
INSERT INTO guh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dioso cajena nacatoitorobianica pinijicuene pexanaejava pecaëjëpaenëtsi vajanacacapanepaenexa. Bajaraponë Dioso pijajivitonëmi Davidpijinë pemomoxiyajuvënënë tsane. ");
INSERT INTO guh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bajayata Diosojumepaebivimi profetavi, Dioso pitorobicueniatsi pejinavanapaevi, tajëvelia najumecapanepaeya jumaitsi bajaraponë vajanacacapanepaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tajëvelia profetavimi najumecapanepaeya jumaitsi bajaraponë vajanacacapanepaejavanexa vajavajabitsaëvivecua, daxita vajanacaitoyavi atavecua. ");
INSERT INTO guh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dioso nacaitaxutotsoniataena pacuenia tajëvelia najumecapanepaeya jumaitsi vajasalinaivimijavabelia. Dioso cajena apo nacofënëtsi pacuenia najumecapanepaeya jumaitsi vajasalinaivimijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bajayata copiaya bajarapacuene yabara Dioso najumecapanepaeya jumaitsi vajasalinainëmi Abrahampijinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dioso baja najumecapanepaeya jumaitsi vajanacacapanepaenexa vajavajabitsaëvecua. Bajarapacuenia Dioso nacacapanepaena ajunavijibia vajatonacuenebavanapaenexa. ");
INSERT INTO guh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nexata bajarapacuenia Dioso itsa tonacuenebavanapaenatsi, jinavanapaenatsi pibisiacuene exanaenejevatsi Dioso pitabarata vajaasaëtsavanapaeepato abaxë mapanacuataje, jai Zacarías jivijavabelia tajëvelia pevajunupaebijavata Jesús Dioso pitorobijavanexatsitsica vajanacacapanepaenexa. ");
INSERT INTO guh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Icatsia Zacarías jumaitsi pexënatonëyojavabelia mapacueniaje: Taxënatonëyo, xamë yabara itsamonae jumai tsabiabi tsane: “Mara ponëje pinijiDioso, athëbëtatsia peecaenë, pijaprofetanëje,” jai tsabiabi tsane. Xamë raja itsaxuayo pepo petuxanenë najetarucaejitsia, pevajënaeya jivi tsipaebanajetarucaename pesivanajamatabëcuenecopatsinexa bajaraponëjavabelia pamatacabi bajaraponë najetarucaena. ");
INSERT INTO guh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tsipaebanajetarucaename jivijavabelia pacuenia Dioso bajarapamonae capanepaejitsiatsi. Tsipaji bajarapamonae pibisiacuene pexanaeneconimi Dioso vecuaajibiaexanaenatsi. ");
INSERT INTO guh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dioso vajanacaitaxutotsoniataexae, nexata nacayapëtaeyaexanaena vajanacacapanepaenënexa athëbëvetsica pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nexata bajaraponë jivijavabelia itsa tsipaebanajetarucaena pexaniajailivaisi, jamatabëcueneitayotsiana daxita piajamatabëcueneitaquirivimi. Baitsi pamonae picani cujunava petëpaejava, bajaraponë petsipaebilivaisi pejamatabëcueneta, bajarapamonae yapëtaena jamatabëcuenexanepanaeya pejinavanapaenexa, jai Zacarías pexënatonëyojavabelia tajëvelia pevajunupaebijavata Jesús jivijavabelia Dioso pejumelivaisi petsipaebanajetarucaejavanexa. ");
INSERT INTO guh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nexata jane baja xuacujinae Juan jivibautisabinënexa vitsabanajetaruca. Yajavaajamatabëcuenesaë baja cajena tsanajetarucae Dioso pejumelivaisi yabara. Nexata baja Juan itsa penaveretsinë, ponapona petusato nacuata. Matapania itsa taxuxuabijitsia jivi petsipaebinexa Jesús pelivaisi, naitajëta jivijavabelia pevënëlivaisitaenexatsi daxita Israel nacuapijivi. ");
INSERT INTO guh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Imoxoyo baja pevajënae Jesús penaexanaejavanexa. Nexata bajarapamatacabijava Romanonacua pepo pevetsinë, Augusto, taxuxuaba pijajivi pitorobijava jivi petonamataëjëtsinexatsi. Jumaitsi pijajivijavabelia: —Daxitajivi, pamonae taevetsinacuanëjava jinavanapa, panetonamataëjëtsianame, jai. ");
INSERT INTO guh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bajarapamatacabi pijinia nacuaevetsinë Cireniovënënë saicaya itsanacua eveta, Siriavënënacua. ");
INSERT INTO guh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nexata nacuaevetsinë Augusto pevetsinacuanëjava penaetomaranëta pejinavanapaevi, apo jinavanapae ëpijatomaranëjava. Itsamonae najinavanapa itsatomaranëjava. Bajaraxuata pamonae najinavanapa itsatomaranëjava, caejivi canacujitsia, pijasalinaivimi pijatomaranëjavabelia pona. Bajarapamonae pona penamataëjëtsinexatsi pijasalinaivimi pijatomaranëjava. ");
INSERT INTO guh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Bajaraxuata José ata barëpona Belén tomarabelia. José barënaropota Nazaret tomarata, Galilea nacuata peecaetomarata. José barëpona Belén tomarabelia, Judea nacuata peecaetomarabelia. Tsipaji baja cajena José pijasalinainëmi, Davidpijinë, bajayata Belén tomarata ponapona. ");
INSERT INTO guh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José barëpona María, pova pita pijavanexa. Bajarapova yacotapona itsa baja imoxoyo pevajënae penacueto pevecuanaexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Nexata baja itsa patabeje Belén tomarata, ponaponabeje dajubi pevetabiabibota. Tsipaji baja pabota jivi patabiaba, pevajënaebeje baja jivi yavënëca. Nexata apo nayacaëjëpaetsibeje bajarapabota penaecaenexabeje. Bajaraxuata patabeje dajubi pevetabiabibota. Nexata dajubi pevetabiabibota María jane baja vecuanaexanatsi penacuetonëyo, copiaya penacoxitsinacueto. Barëeca dajubi pevetabiabibota. Jumaquioneta papaëbërëpanaxita. Buateta dajubi pexaejavanexa pemitsaothocabiabimoënëta. ");
INSERT INTO guh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén tomarajumaverena imoxoyovayafota, oveja pevetsivi evetavanapa. Bajarapamonae meravi nacobenaevetabiaba pijaovejabitsaëtonë. ");
INSERT INTO guh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jemata oveja pevetsivi tsitanaitajëtatsi Dioso pijaángel. Nexata Dioso pijapenivenivenaecotia oveja pevetsivi matatoyorotsia itayotatsi. Najunaviaca bajarapamonae pinijicuenia. ");
INSERT INTO guh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nexata ángel jumaitsi oveja pevetsivijavabelia: —Pëtsa panajunaviacame. Pexanialivaisi raja pacatocanajetarucatsi pesivabarëyanexa daxitajivi. ");
INSERT INTO guh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ajena rabaja, mapameravitaje, naexana baja daxitajivi pecapanepaenënexa. Naexana Belén tomarata, patomarata bajayata nacuaevetsinëmi Davidpijinëmi ponapona. Ponë naexana, bajaraponë pepo petuxanenë Cristo, Dioso athëbëvetsica pitorobinëtsitsica jivi pecapanepaenexa. ");
INSERT INTO guh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Paneyapëtaenexa pacuenia pacatsipaebatsi, penacuetonëyo pataeyabuatetsianame mapacueniaje. Penacuetonëyo pataeyabuatetsianame papaëbërëpanaxita pejumaquionaenacuetonëyotsi. Boquecaena dajubi pexaejava pemitsaothocabiabimoënëta, jai ángel oveja pevetsivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bajara saya jota jemata oveja pevetsivi tsitanaitajëtatsi ayaibitsaëtoxaneto ángelevi, copiaya petsipaebiángelnëtsijavata. Bajarapamonae ángelevi pexaniajamatabëcuene rajuta Diosojavabelia. Penaxëanaejavata ángelevi jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Dioso, athëbëtatsia peecaenë, pinijicuene rabaja exana! Pamonae Dioso jumecovënëta, Dioso sivajamatabëcuenebarëyatsi. Daxita bajarapamonae jamatabëcuenexanepanaeya jinavanapaeyaexanaena Dioso, jai ángelevi penaxëanaejavata. ");
INSERT INTO guh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Itsa baja ángelevi naviaba athëbëabetsia, oveja pevetsivi ángelevi pecovëta najumaitsi: —Ponaliatsi Belén tomarabelia. Taenatsi pecopiapatsijava pacuene yabara vajatuxanenë Dioso pitorobiángelnëtsica nacatsipaeba, najai oveja pevetsivi ángelevi pecovëta. ");
INSERT INTO guh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nexata bajarapamonae bepijiayo ponalia Belén tomarabelia. Pata itsajota Maríabeje Josébeje barëecabeje penacuetonëyo. Penacuetonëyo boqueca dajubi pexaejava pemitsaothocabiabimoënëta. ");
INSERT INTO guh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oveja pevetsivi itsa taeyabuateta penacuetonëyo pacuenia baja cajena ángelnë tsipaebatsi, nexata pona petsipaebaponaenexa daxitajivijava pacuenia bajarapanacuetonëyo taeyabuateta. ");
INSERT INTO guh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nexata daxita pamonae jumetane oveja pevetsivi pepaebilivaisi, jamatabëcuenenabenajaca. ");
INSERT INTO guh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María baja cajena pejamatabëëthëtota yapëtaeponapona daxita bajarapacuene yabara. ");
INSERT INTO guh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oveja baja pevetsivi naviabaponalia. Oveja pevetsivi namutualia jumai tsanajetarubenae Diosojavabelia: —Diosomë, bitso ayaijamatabëcuenenëmë. Pexaniajamatabëcuene pacarajutatsi patanetoexanaexaemë pexaniacuene, jai tsaponaelia oveja pevetsivi. Bajarapacuenia jumaitsi tsipaji baja tane daxita pacuenia ángelnë tsipaebatsi. ");
INSERT INTO guh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesúsnexa penaexanaecujinae, ocho matacabita, perabëcaucutatsi judíovicuenia. Baitsi boupiperabëcaucutatsi. Vënërubatsinua jane baja pevënë pexainaenexa. Vënërubatsi “Jesús,” pejaivënëta. Tsipaji baja cajena abaxë María nacoxitsinejeva Jesúsnexa, tajëvelia ángel jumaitsi Maríajavabelia: “Bajaraponëyo vënërubianame Jesús,” jai. ");
INSERT INTO guh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nexata jane baja tocopiajopatsibeje Josébeje Maríabeje pexanaenexabeje pacuenia bajayata Dioso Moiséspijinëta penajumecopatsilivaisi itorobatsi daxita judíovi pexanaenexa penacuetonëyo itsa tonaexanatsi. Nexata Jerusalén tomarabelia barëponabeje penacuetonëyo. Nexata Jerusalén tomarata, templobota, María ofrenda rajuta Diosojavabelia penajamatabëcuene xaniavaetsinexa Diosojavabelia. Rajutabejenua penacuetonëyo Diosojavabelia pijajivitonënexa petonacuenebinexa itsa penaveretsinë. ");
INSERT INTO guh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bajarapacuenia Josébeje Maríabeje exanabeje tsipaji Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi: “Penacasabijivibeje pexi itsa xainabeje, nexata copiaya panacuetonëyo xainabeje, totsatsibeje Dioso pijajivitonënexa,” jai. ");
INSERT INTO guh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Josébeje Maríabeje rajutabeje ofrenda Diosojavabelia pacuenia Dioso Moiséspijinëta penajumecopatsilivaisi itorobatsibeje. Rajutabeje tsiquiriviria ucucutoyobeje. Itsa jume, rajutabeje meta pinijiyoviria ucucutobeje. ");
INSERT INTO guh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bajarapamatacabi ponapona Jerusalén tomarata Simeónvënënë. Bajaraponë jumecovënëtsiaponapona pacuenia Dioso pejumelivaisibaxutota jumaitsi. Nexata bajarapamatacabi Israelnacua eveta Romano nacuaverena ëpepatsivi. Nexata Romano nacuaverena pepatsivi pevetsixae Israelnacua, bejiobiaexanabiabatsi Israel nacuapijivi. Bajaraxuata Simeón copiaevetaponapona Dioso pejamatabëcueneta petovecuajutsinexatsi Israelnacua pevetsivi. Nexata baja Romano nacuaverena pepatsivi, pevecuapitsapaenexa Israelnacua pevetsicuene. Espíritu Santo yajavaponaponatsi Simeón. ");
INSERT INTO guh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nexata Espíritu Santo pejamatabëcueneta Simeón tajëvelia yapëtaeyaexanatsi pacuenia Simeón petëpaevajënae taejitsia Cristo, ponë Dioso athëbëvetsica itorobiapaebica jivi pecapanepaenexa. ");
INSERT INTO guh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nexata Espíritu Santo pejamatabëcueneta Simeón joneyaexanatsi temploboyabelia. Bajaraxuata Simeón tane Maríabeje Josébeje pebarëjonejavatabeje Jesúsnëyo temploboyarena pexanaenexabeje pacuenia Dioso Moiséspijinëta penajumecopatsilivaisi itorobatsibeje. ");
INSERT INTO guh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nexata Simeón isapita Jesúsnëyo. Pexaniajamatabëcuene rajuta Diosojavabelia. Pexaniajamatabëcuene Simeón perajutsijavata Diosojavabelia, Simeón jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tajatuxanenë, baja rajane netocopatsianame nijajivitonënë jamatabëcuenexanepanaeya tatëpaenexa. Tsipaji baja netaeyaexaname pacuenia baja cajena tajëvelia najumecapanepaeya nejumaitsimë. ");
INSERT INTO guh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Taitaxutota rabaja taniji maponëje, ponë itorobimica jivi pecapanepaenënexa xamëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ponë itorobimica jivi pecapanepaenënexa, daxitajivi taenatsi. ");
INSERT INTO guh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Maponëje petsipaebilivaisita, pamonae apo judíovi ata, jamatabëcueneitayotsiana. Yapëtaeyaexanaena pacuenia jamatabëcueneitsimë. Nexata maponëje pejamatabëcueneta apo judíovi yaiyataena nijajivi judíovi, jai Simeón templobota Diosojavabelia pexaniajamatabëcuene perajutsijavata Jesúsnëyo yabara. ");
INSERT INTO guh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nexata Josébeje Maríabeje itsa jumetanebeje bajarapacuenia Simeón pejumaitsijava Jesúsnëyo yabara, jamatabëcuenenabenajacabeje. ");
INSERT INTO guh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Bajaraxuacujinae Simeón tovajëta Diosojavabelia peyavenonaenexatsibeje Josébeje Maríabeje, Jesúsnëyo yajava. Bajaraxuacujinae Simeón jumaitsi Maríajavabelia: —Mapanacuetonëyoje, Dioso itapetatsi. Maponëje petsipaebilivaisi jivi ayaibitsaëtoxaneto apo jumecovënëtsi tsanetsi. Nexata jivi ayaibitsaëtoxaneto naxuabiana, Israel nacuapijivi. Ayaibitsaëtoxaneto pijinia jumecovënëtsianatsi. Nexata pijinia ayaibitsaëtoxaneto capanepaena. Maponëje Dioso pesaëta pinijicuene pexanaejava, tsitaexanaena jivi peyapëtaenexa Dioso pitorobinëtsitsica. Maponëje itajëtsiana pacuenia jivi ayaibitsaëtoxaneto, caejivi canacujitsia, bëpënëa pibisiajamatabëcuene najamatabëxainabiaba. Jivi ayaibitsaëtoxaneto apo jumecovënëtsi tsanetsi. Pibisiacuenia saya baranatsipaebianatsi. María, xamë nexata pepo nejamatabëëthëtojavavetsina bitso sivajamatabëcuenebëjamë tsane itsa yapëtaename pacuenia exanaejitsiatsi, jai Simeón Maríajavabelia Jesús yabara tajëvelia pevajunupaebijavata pacuenia Jesús exanaejitsiatsi. ");
INSERT INTO guh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Bajara pijinia pamatacabi templobota ponapona Diosojumepaebiva profetava, Anavënëva. Bajarapova Fanuelpijinë pexënatoyo, Aserpijinë pemomoxiyajuvënëva. Bajarapova bitso baja perujuva. Ochenta y cuatro baja pavaibeje xaina. Nacasaba picani abaxë itsa pejanava. Penacasabicujinae siete pavaibeje pepuaxainae pamonajavabelia, vecuatëpatsi pamona. Itsajavabelia apo vecuaponabiabi templobo. Matacabijebi, meravijebi yajava, Dioso tonacuenebabiaba templobota. Itsajavata pexaejava apo xaeyabiabi pamatacabibeje vajëcabiaba Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nexata bajarapova ata pata itsajota Josébeje Maríabeje nucabeje templobota. Simeón pisanucaejavata Jesúsnëyo, isataenuta bajarapova. Nexata bajarapova pexaniajamatabëcuene rajuta Diosojavabelia Jesúsnëyo yabara. Romano nacuaverena pepatsivi Israelnacua pevetsixae, Israel nacuapijivi copiaevetavanapa Dioso pejamatabëcueneta petovecuajutsinexatsi, nexata baja Romano nacuaverena pepatsivi pevecuapitsapaenexa Israelnacua pevetsicuene. Nexata daxita pamonae copiaevetavanapa Dioso pejamatabëcueneta petovecuajutsinexatsi Israelnacua pevetsivi, daxita bajarapamonaejavabelia, bajarapova tsipaebabiaba Jesúsnëyo pelivaisi. ");
INSERT INTO guh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josébeje Maríabeje Jerusalén tomarata templobota exanaeveretabeje baja daxita pacuenia Dioso Moiséspijinëta penajumecopatsilivaisi itorobatsibeje. Nexata baja pijatomarabelia Jesúsnëyo barënaviatabeje, Nazaret tomarabelia, Galilea nacuata peecaetomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nexata jane baja Jesúsnëyo vitsaba Nazaret tomarata. Ajamatabëcuenesaë tsaponae Dioso pijacuene yabara. Jamatabëcuenevitsabaponanua. Dioso yavenonaponatsi ayaicuenia. ");
INSERT INTO guh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Caevai canacujitsia Josébeje Maríabeje ponabiababeje Jerusalén tomarabelia. Ponabiababeje pascuavënëfiesta penataeyabiabinexabeje. ");
INSERT INTO guh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nexata baja Jesúsnëyo doce pavaibeje itsa xaina, barëponabeje icatsia Jerusalén tomarabelia pascuafiesta penataenexa. ");
INSERT INTO guh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Itsa baja copiaruca pascuafiesta, daxita baja penataevi bajarapafiesta, naviaba baja pijabonëjavabelia. Nexata Jesúsnëyo nacopatanucalia Jerusalén tomaratalia. Maríabeje Josébeje abaxë apo yapëtaebeje Jesúsnëyo pevecuanacopatsijavatsiliabeje. ");
INSERT INTO guh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jamatabëjumaitsibeje saya: —Jesúsnëyo raeta nanajetaruca vajanajuaponaevita, jamatabëjaibeje. Bajaraxuata caematacabi baja pepuaponaebeje namutua, itaxanabeje Jesúsnëyo. Nexata yanijobabeje pijamonaejavabelia, peyapëtaevitsibejejavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Itsiata apo caxitajarabibeje. Nexata naviatecabeje Jerusalén tomarabelia pejaitsinexabeje Jesúsnëyo. ");
INSERT INTO guh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Acueyabi matacabita caxitajarababeje templobota. Jesúsnëyo naeca judíovi pecujarubivi tuatuajëta. Jumetaeyeca bajarapamonae penabarëcuaicuaijailivaisi. Nexata Jesúsnëyo yanijobapona bajarapamonae penabarëcuaicuaijailivaisi yabara. ");
INSERT INTO guh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nexata daxita Jesúsnëyo pejumetaeyenaevitsi, taeyena Jesúsnëyo xaniavaetsia pejumeyapëtaejava judíovi pecujarubivi penabarëcuaicuaijailivaisi. Taeyenanua xaniavaetsia pejumecanaviataponaejava, abaxë tsiquirinëyovajëto ata. Bajaraxuata jamatabëcuenenabenajaquena bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Josébeje Maríabeje itsa tanebeje bajarajota Jesúsnëyo penaecaejava, nexata jamatabëcuenenabenajacabeje. María nexata jumaitsi: —Taxënato, ¿detsa xuajitsia panevepënacoparemenabeje? Paxanëbeje patacajaitarutsijavatabeje, bitso pacaitaxanatsibeje, jai María. ");
INSERT INTO guh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nexata Jesúsnëyo jumaitsi penajavabelia: —¿Detsa xuajitsia bajarapacuenia panejaitarutamebeje? Panejaitsipamebeje raja mapabotaje. Tsipaji raja xanë taxa Dioso pijacuene taexanaenexa mapabotaje, nejamatabëcueneenabiaba, jai Jesúsnëyo. ");
INSERT INTO guh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Itsiata bajarapajivibeje apo jumeyapëtaebeje pajamatabëcuene yabara jumaitsi Jesúsnëyo. ");
INSERT INTO guh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","María baja cajena pejamatabëëthëtota yapëtaeponapona daxita bajarapacuene yabara. Nexata baja bajarapajivibeje pepëta Jesúsnëyo napona baja Nazaret tomarabelia. Nazaret tomarata Jesúsnëyo xaniavaetsia jumecovënëtsiaponapona pacuenia Josébeje Maríabeje itorobabiababeje. ");
INSERT INTO guh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús abaxë vitsabanajetaruca. Jamatabëcuene vitsabanajetarucanua. Nexata Dioso pexaniajamatabëcuenia tanetsi. Daxita pamonae Jesúsnëyo yapëtanetsi, pexaniajamatabëcuenia tanetsi. ");
INSERT INTO guh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pamatacabi pepo nacuaevetsinë Tiberiovënënë xaina quince pavaibeje pevetsicujinae Romanonacua, bajara pijinia pamatacabi itsanacuanë eveta itsamonae. Bajarapamatacabi nacuaevetsinë Poncio Pilato eveta Judeanacua. Bajara pijinia pamatacabi nacuaevetsinë Herodes eveta Galileanacua. Bajara pijinia pamatacabi Herodes pejuyapijinë, nacuaevetsinë Felipe, eveta Itureanacua, Traconitenacua yajava. Bajara pijinia pamatacabi nacuaevetsinë Lisanias eveta Abilinianacua. ");
INSERT INTO guh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bajara pijinia pamatacabi Anásbeje Caifásbeje Israel nacuata sacerdotevi pepo penamatacaitorobinëbeje tsaponaponae. Bajara pijinia pamatacabi Juan, Zacarías pexënato, petusato nacuata ponapona. Nexata Dioso itorobatsi jivi petsipaebanajetarucaenexa Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nexata Juan jivi tsipaebanajetaruca Dioso pitorobilivaisi daxita Jordánmene imoxoyo penaenacuanëta pejinavanapaevijava. Juan jumai tsanajetarucae jivijavabelia: —Panajamatabëcuenepënëyorore Diosojavabelia. Pacopabare pibisiacuene paneexanabiabijava. Nexata pacabautisabianatsi Dioso papecavecuaajibiaexanaenexa pibisiacuene paneexanaeneconimi, jai tsanajetarucae Juan jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bajarapacuenia Juan jivi itsa tsipaebanajetaruca, copiajopa jane baja pacuenia Diosojumepaebinëmi profeta Isaíaspijinë bajayata tajëvelia yaquina Juan yabara. Juan jivibautisabinë Dioso pitorobilivaisi jivijavabelia petsipaebanajetarucaejavanexa yabara, yaquina. Profeta Isaíaspijinë peyaquinaelivaisita tajëvelia jumaitsi mapacueniaje: Tanejumelivaisipaebinë vavajai tsane petusato nacuata. Jumai tsane jivijavabelia: “Jivi baxaneba panamutoverena najetarucaejitsia petuxanenë. Batoroviaexananua namuto. ");
INSERT INTO guh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Daxita namutua pafotonë rubena, atsa baothoca penamatajëpaeyaexanaenexa namuto. Daxita petsutonëmi, pinijiibotsutoxanetonëmi ata, banamatajëpaeyaexana. Baroviayaexananua penatoxorotsinamutomi ata. Banamatajëpayaexananua namutua pebobenaemëthëanëmi ata. Bajara pijinia pacuenia paxamë ata panajamatabëcuenexaniavaere pepo petuxanenë pepatsivajënaeya paxamëjavaberena. ");
INSERT INTO guh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nexata daxitanacuanëpijivi yapëtaena Dioso pecapanepaejavanexatsi pijaneconivecua,” jai baja cajena profeta Isaíaspijinë bajayata peyaquinaelivaisita, Dioso pitorobilivaisi, Juan jivi petsipaebanajetarucaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jivi ayaibitsaëtoxaneto pata Juanjavaberena Juan picani pebautisabinexa bajarapamonae. Bajarapamonae apo jumecovënëtsi ata Dioso pitorobilivaisi, jamatabëcuenenavëxaniabiaya jamatabëjumaitsi: —Juan itsa nacabautisabiana, Dioso nacacapanepaena, jamatabëjai. Nexata Juan jumaitsi bajarapamonaejavabelia: —¡Panejamatabëcuenenavëxaniabivi! Pacuenia jomo rëcëpeca itsa tane isoto petajuenajetarucaejava, bajara saya paitsimë. Dioso rabaja papecananeconitsia exanaematacabinexa pacaimoxoyotapona. Itsiata acuenebi tsane panevecuapanepaenexa Dioso papecananeconitsia exanaematacabinexavecua. ");
INSERT INTO guh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Itsa pajitsipame Dioso papecacapanepaejava, pacopabare pibisiacuene paneexanabiabijava. Dioso pajumecovënëtsiajinavanapare. Nexata daxitajivi pacayapëtaena pepacuene baja panecopabijava pibisiacuene paneexanabiabijavami. Pacayapëtaenanua panenajamatabëcuene pënëyorotsijava Diosojavabelia. Jamatabëcuenenavëxaniabiaya pëtsa panajumaitsimë: “Vaxaitsi cajena Abrahampijinë pemomoxitsi. Nexata Dioso nacacapanepaena,” panajamë pëtsa. Abrahampijinë picani papemomoxi atamë, itsiata pibisiacuene itsa paexanavanapame, nexata bajarapacuene apo pacatonamatamotsi tsipae papecacapanepaenexa Diosojavabelia. Dioso baja cajena caëjëpatsi jivi pexanaenexa mapaibotonëmi ataje, Abrahampijinë bepemomoxi Dioso petaenexa. Nexata bajarapamonae ata Dioso itsa apo jumecovënëtsi, Dioso apo capanepae tsipae. Nexata pacopabare pibisiacuene paneexanabiabijavami papecacapanepaenexa Dioso. ");
INSERT INTO guh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Peubinaenë pexainaenë itsa apo tonacuaitsitsi pexaniacuai, nicata sipalita daxita ponaenë apo tonacuaitsitsi pexaniacuai. Nexata baja penicatsicujinae, itsa niona bajaraponaenë, caetuata. Xuaba isotojavabelia. Nexata bajaraponaenëmi tajuatsi. Bajara pijinia pacuenia paxamë ata Dioso pacaxuabiana infiernojavabelia papecatajuenexa, Dioso apo panejumecovënëtsivi, jai Juan bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nexata bajarapamonae jumaitsi Juanjavabelia: —¿Detsa nexata pacuene paexanaenajë daxitajivi pataneyapëtaenexa pepacuene patacopabijava pibisiacuene pataexanabiabijavami? jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nexata Juan jumaitsi bajarapamonaejavabelia: —Pajivi anijacamisabeje xaina, rajutsi pajiviyo apo xainae camisa. Pajivi pexaejava xaina, tsicobetsatsi pajiviyojavabelia apo xainae pexaejava, jai Juan. ");
INSERT INTO guh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi ata, pata Juanjavaberena Juan picani pebautisabinexa bajarapamonae. Nexata bajapamonae ata jumaitsi Juanjavabelia: —Juan, ¿detsa pacuene paexanaenajë daxitajivi pataneyapëtaenexa pepacuene patacopabijava pibisiacuene pataexanabiabijavami? jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nexata Juan jumaitsi bajarapamonaejavabelia: —Itsa pamatamoyanijobabiabame impuestomatamo, pamatamoyanijobabiabare pamatamota papecaitorobivi pacatocopata paneyanijobabiabinexa. Pëtsa matatoxenetsia bajarapamatamovecua yamaxëitojorobiaya payanijobabiabame paxamë saya panepitsinexa bajarapapalata, jai Juan bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nexata icatsia vajabitsaë ata jumaitsi Juanjavabelia: —Juan, ¿jica paxanë tsane? ¿Detsa pacuene paexanaenajë daxitajivi pataneyapëtaenexa pepacuene patacopabijava pibisiacuene pataexanabiabijavami? jai vajabitsaë. Nexata Juan jumaitsi vajabitsaëjavabelia: —Pëtsa panejumesaëta itsajivi ata palata payacajërëtame. Pëtsa najumetsënëtsiaya itsajivi ata pananeconitsiaexaname saya palata papecarajutsinexa pecajunavi. Saya pasivabarëyamëre pacueneta pacamatamotapona papecaitorobivi, jai Juan vajabitsaëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jivi itatsacajinaeya copiaevetavanapa Cristo, ponë Dioso athëbëvetsica itorobijitsia pepatsijavatsica jivi pecapanepaenexa. Nexata bajarapamonae Juan itsa tanetsi, bajarapamonae jamatabëcuenenavëxaniabiaya jamatabëjumaitsi Juan yabara: —Baja raeta jane maCristoje, daxitajivi pecapanepaenënexa, jamatabëjai bajarapamonae Juan yabara. ");
INSERT INTO guh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nexata Juan jumaitsi daxita bajarapamonaejavabelia: —Xanë raja saya pacabautisabatsi merata. Itsiata baitsi jane itsanë tacovëverena najetarucaena. Bajara jane ponë pacatsijamatabëjoneyaexanaena Espíritu Santo, pitarunutsicotia yajava. Xanë raja saya beveliajamatabëcuenenënë bajaraponëvecua. Nexata bajaraponë vecuaauranë pijazapato ata tataxujonotsinexa bepijajivitonëcuenianë. ");
INSERT INTO guh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Arrozxainaenë baja itsa vereta arroz penotsijava, jëaba arroz pejëabijavata ëpexu pepitsinexa. Nexata pijaarroz pejëabijavata, tsatapona saicaya ëpexu pesivecua. Nexata ëpexu xaniavaeteta peetsibojavabelia. Pesi pijinia penetapona vayafuabelia petajuitsinexa. Bajara pijinia pacuenia paxamë ata, Dioso pejumecovënëtsivivecua Dioso pacatsatsiana papecaxuabinexa infiernojavabelia panenaxuabinexa baja daxitamatacabijavabelianexa. Pamonae pijinia Dioso pejumecovënëtsivi, Dioso capanepaenatsi pijanacuayabetsia. Pamonae pijinia Dioso apo jumecovënëtsi, Dioso naneconitsiaexanaenatsi daxitamatacabijavabelianexa apo pevereverecaeisotojavabelia, jai Juan daxita bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bajarapacuenia ayailivaisianëta Juan muxujiobapona jivi. Tsipaebanajetaruca pexanialivaisi pecapanepaelivaisinexatsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bajaraxuacujinae icatsia Juan itaveta nacuaevetsinë Herodes. Tsipaji Herodes pejuyapijinë pijava yacajërëta, Herodíasvënëva. Daxita Herodes pibisiacuene pexanaejavanë ata, itaveta Juan. ");
INSERT INTO guh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Itsiata baitsi jane Juan Herodes apo jumecovënëtsitsi. Caranata biji orijibia icatsia Herodes pibisiacuene exana. Herodes itoroba pijajivi Juan pevaetabinexatsi, penaneconitsivi pejebabiabibota peetsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan pevaetabivajënaetsi penaneconitsivi pejebabiabibota peetsinexatsi, jivi bautisabaponapona. Bajarapamatacabi Juan bautisaba Jesús ata. Jesús pebautisabicujinaetsi itsa vajëta Diosojavabelia, athëbëtatsia itaboxo napatsia. ");
INSERT INTO guh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Athëbëvetsica Espíritu Santo naitajëtsiaya Jesús tsimatarunaicatsi beucucuto. Nexata Jesús jumetane athëbëvetsica Dioso pejumaitsijavatsi: “Xamë raja taxënatomë, bitso tacaasivanë. Bitso casivajamatabëcuenebarëyatsi,” pejaijavatsi. ");
INSERT INTO guh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Itsa baja Jesús xaina bejamatabëcuene treinta pavaibeje, taxuxuaba jane baja jivi Dioso pitorobilivaisi petsipaebijava. Jivi tanetsi Jesús beJosé pexënato. José paxapijinë pevënë Elí. ");
INSERT INTO guh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí paxapijinë pevënë Matat. Matat paxapijinë pevënë Leví. Leví paxapijinë pevënë Melqui. Melqui paxapijinë pevënë Jana. Jana paxapijinë pevënë José. ");
INSERT INTO guh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José paxapijinë pevënë Matatías. Matatías paxapijinë pevënë Amós. Amós paxapijinë pevënë Nahum. Nahum paxapijinë pevënë Esli. Esli paxapijinë pevënë Nagai. ");
INSERT INTO guh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai paxapijinë pevënë Maat. Maat paxapijinë pevënë Matatías. Matatías paxapijinë pevënë Semei. Semei paxapijinë pevënë Josec. Josec paxapijinë pevënë Judá. ");
INSERT INTO guh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá paxapijinë pevënë Joanán. Joanán paxapijinë pevënë Resa. Resa paxapijinë pevënë Zorobabel. Zorobabel paxapijinë pevënë Salatiel. Salatiel paxapijinë pevënë Neri. ");
INSERT INTO guh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri paxapijinë pevënë Melqui. Melqui paxapijinë pevënë Adi. Adi paxapijinë pevënë Cosam. Cosam paxapijinë pevënë Elmadam. Elmadam paxapijinë pevënë Er. ");
INSERT INTO guh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er paxapijinë pevënë Josué. Josué paxapijinë pevënë Eliezer. Eliezer paxapijinë pevënë Jorim. Jorim paxapijinë pevënë Matat. ");
INSERT INTO guh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat paxapijinë pevënë Leví. Leví paxapijinë pevënë Simeón. Simeón paxapijinë pevënë Judá. Judá paxapijinë pevënë José. José paxapijinë pevënë Jonam. Jonam paxapijinë pevënë Eliaquim. ");
INSERT INTO guh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim paxapijinë pevënë Melea. Melea paxapijinë pevënë Mena. Mena paxapijinë pevënë Matata. Matata paxapijinë pevënë Natán. ");
INSERT INTO guh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán paxapijinë pevënë David. David paxapijinë pevënë Isaí. Isaí paxapijinë pevënë Obed. Obed paxapijinë pevënë Booz. Booz paxapijinë pevënë Sala. Sala paxapijinë pevënë Naasón. ");
INSERT INTO guh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón paxapijinë pevënë Aminadab. Aminadab paxapijinë pevënë Admin. Admin paxapijinë pevënë Arni. Arni paxapijinë pevënë Esrom. Esrom paxapijinë pevënë Fares. Fares paxapijinë pevënë Judá. ");
INSERT INTO guh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá paxapijinë pevënë Jacob. Jacob paxapijinë pevënë Isaac. Isaac paxapijinë pevënë Abraham. Abraham paxapijinë pevënë Taré. Taré paxapijinë pevënë Nacor. ");
INSERT INTO guh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor paxapijinë pevënë Serug. Serug paxapijinë pevënë Ragau. Ragau paxapijinë pevënë Peleg. Peleg paxapijinë pevënë Heber. Heber paxapijinë pevënë Sala. ");
INSERT INTO guh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala paxapijinë pevënë Cainán. Cainán paxapijinë pevënë Arfaxad. Arfaxad paxapijinë pevënë Sem. Sem paxapijinë pevënë Noé. Noé paxapijinë pevënë Lamec. ");
INSERT INTO guh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec paxapijinë pevënë Matusalén. Matusalén paxapijinë pevënë Enoc. Enoc paxapijinë pevënë Jared. Jared paxapijinë pevënë Mahalaleel. Mahalaleel paxapijinë pevënë Cainán. ");
INSERT INTO guh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán paxapijinë pevënë Enós. Enós paxapijinë pevënë Set. Set paxapijinë pevënë Adán. Adánpijinë Dioso pexanaenëtsi. ");
INSERT INTO guh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús baja naviarena Jordán meneverena Juan pebautisabicujinaetsi. Tsijamatabëvënëcatsi bitso Espíritu Santo. Nexata Espíritu Santo ponaeyaexanatsi petusato nacuayabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Bajarajotalia Jesús ponapona cuarenta pamatacabibeje. Bajara pijinia pamatacabibeje Jesús pexaejava apo xae. Jesús nexata bitso piajani. Dovathi nexata jamatabëcueneëjëbatsi pibisiacuene picani pexanaenexa. ");
INSERT INTO guh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dovathi jumaitsi Jesúsjavabelia: —Itsa pepacuene Dioso pexënatomë, itorobare mapaibotoyoje penaexanaenexa panbë, jai dovathi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús nexata jumaitsi dovathijavabelia: —Jume raja. Dioso raja pejumelivaisibaxutota jumaitsi mapacueniaje: “Jivi raja apo namatavenonae ëpexaejava pexaenexa. Jivi raja namatavenona daxita Dioso pejumelivaisi ata pejumecovënëtsinexa pexainaenexa matacabi apo pevereverecaejava,” jai raja Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bajaraxuacujinae icatsia Jesús barëliatsi dovathi pinijitsutoxanetojavabelia. Barëjunayatsi bajarapatsutojumabetsia. Nexata bajarapatsutojumavetsica dovathi Jesús tsitajëtatsi bepijia daxitanacuanë. ");
INSERT INTO guh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nexata icatsia dovathi jumaitsi Jesúsjavabelia: —Xanë raja carajutsianatsi daxita mapanacuanëje nevetsinexa. Daxita bajarapanacuanëta paitabëcuene taneme, cayajavarajutsianatsi. Nexata bitso nexainaenë tsane nexainaejava. Daxita tanerajutsijavanëmi, necaëjëpa juya tarajutsinexa pajivijavabelia jamatabërajutajë. ");
INSERT INTO guh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ayaijamatabëcuenenënë netaeya taitabarata nematabacabëta itsa netonucajunuame, nexata daxita mapanacuanëje nijanacuanë tsane, jai dovathi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nexata Jesús jumaitsi dovathijavabelia: —Dovathi, nevecuanatixire. Dioso raja pejumelivaisibaxutota jumaitsi mapacueniaje: “Daxitajivi vajëcae pematabacabëta caenë, pepo petuxanenë Diosojavabelia. Tonacuenebinua bajaraëponënexa,” jai raja Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bajaraxuacujinae abaxë icatsia Jesús barëliatsi dovathi Jerusalén tomarabelia. Jerusalén tomarata barëjunayatsi temploboxaneto matatuyabetsia. Nexata templobo matatutatsia dovathi icatsia jumaitsi Jesúsjavabelia: —Itsa pepacuene Dioso pexënatomë, jirevaremeca irabereca. ");
INSERT INTO guh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bajarapacuenia jirevaremeca irabereca. Tsipaji xamë peitsacueneyaniva pecaevetsinexa, Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: Dioso itorobianica pijaángelevi pecaevetsinexa. ");
INSERT INTO guh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nexata ángelevi pecobeta cayotsiana pecataxutsaquitsiyaniva ibotonëjavabelia, jai Dioso pejumelivaisibaxutota xamë pecaevetsinexa ángelevi, jai dovathi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús nexata icatsia jumaitsi dovathijavabelia: —Jume raja. Dioso raja pijinia pejumelivaisibaxutota jumaitsi mapacueniaje: “Itsajivi ata jamatabëcuenenavëxaniabiaya pijacuata apo bejamatabëjumaitsi: ‘Xanë Dioso jamatabëcueneëjëtsianajë. Nexata natoexanaenajë pacuene bitso netsiayai tatëpaenexa. Itsiata Dioso neyavenonaena tavecuapanepaenexa bajaraxua. Nexata bajarapacuenia yapëtaenajë Dioso taneyavenonaejava,’ apo bejamatabëjai,” jai Dioso pejumelivaisibaxutota, jai Jesús dovathijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bajaraxuacujinae itsa baja dovathi daxitacuene Jesús jamatabëcueneëjëbiveretatsi pibisiacuene picani Jesús pexanaenexa, nexata abaxë yatucopatatsi itsamatacabijavabelia icatsia pejamatabëcueneëjëtsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús baja itsa naviata petusato nacuaverena, Galilea nacuayaberena, Espíritu Santo pesaë yajavaponapona. Nexata daxita Galilea nacuapijivi vënëlivaisitanetsi Jesús. ");
INSERT INTO guh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judíovi penacaetuatabiabibonëjava Jesús jivi livaisi tsipaebanajetaruca. Daxitajivi nexata Jesús yabara jumai tsabiabi: “Maponëje bitso ayaijamatabëcuenenë,” jai tsabiabi. ");
INSERT INTO guh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nexata Jesús naviata pevitsabitomarabelia, Nazaret tomarabelia. Nexata pepatsicujinae Nazaret tomarata, judíovi penacueraevetsimatacabita Jesús najoneya judíovi penacaetuatabiabiboyalia. Tsipaji baja cajena Jesús bajarapacuenia exanabiaba. Nexata judíovi penacaetuatabiabibota Jesús nonotapuna Dioso pejumelivaisibaxuto petsimuxulebinexa daxita bajarajota penaevi pejumetaenexa. ");
INSERT INTO guh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nexata Jesús tsicoberutatsi profeta Isaíaspijinë bajayata peyaquinaebaxuto. Nexata Jesús bajarapabaxuto baxupata. Nexata jane baja daxita bajarajota penaevi pejumetaenexa, Jesús tsimuxuleba itsajota bajarapabaxutota tajëvelia Jesús yabara jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dioso pijaEspíritu Santo netsijamatabëeca. Tsipaji Dioso nitapeta tatsipaebinexa pexanialivaisi pibisiacuene pexanabiabijava bepeyajamatabëcuenejiobivijavabelia. Nitorobanua tajamatabëcuenexaniavaetsinexa bajarapamonae pibisiacuene pexanabiabineconi yabara bepeyajamatabëcuenejiobijavavecua. Nitorobanua tajamatabëcuenexaniavaetsinexa pamonae piajamatabëcueneitaquirivi, pamonae abaxë apo yapëtae pexaniajailivaisi. Nitorobanua tacapanepaenexa pamonae jamatabëcuenebejiobitabiabatsi pijavajabitsaë. ");
INSERT INTO guh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nitorobanua tatsipaebinexa pacuenia baja Dioso najamatabëcuenevereta pecapanepaenexa pijajivi, pejaiitanejavata tajëvelia Jesús yabara Isaíaspijinë peyaquinaebaxutota Jesús tsimuxulebanuca daxita bajarajota penaevi pejumetaenexa. ");
INSERT INTO guh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bajaraxuacujinae Jesús baja bajarapabaxuto baxuacata. Tocanaviata baja judíovi penacaetuatabiabibota penacuenebinëjavabelia. Bajaraxuacujinae Jesús baja icatsia ecareca. Daxita pamonae judíovi penacaetuatabiabibota ena, Jesús asaëyata taeyenatsi. ");
INSERT INTO guh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nexata icatsia Jesús jumaitsi bajarapamonaejavabelia: —Aeconoxae Dioso pejumelivaisibaxuto pacatsimuxulebiveretatsi. Xua yabara bajarapabaxutota jumaitsi, bajaraxua baja aeconoxae mapamatacabitaje copiapata baja, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nexata daxitajivi pexaniajamatabëcuenia Jesús yabara cuaicuaijai. Jamatabëcuenenabenajaca pexanialivaisi Jesús petsipaebixae. Nexata bajarapamonae Jesús jamatabëcueneaebiatanetsi. Nexata bajarapamonae nayanijobena. Najumaitsi: —¿Matsa baja ponë Josépijinë apo pexënatoje? najai tsenae bajarapamonae Jesús yabara. Tsipaji saya bajarapamonae jamatabëjumai tsenae: —Josépijinë raja pexënato, jamatabëjai tsenae. ");
INSERT INTO guh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nexata Jesús jamatabëcueneyapëtane pacuenia sivanajamatabëxainatsi bajarapamonae. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Xaniajanë cajena pacuenia pacatsipaebijitsiatsi. Pacuenia pajumaitsimë tsabiabi pajiviyojavabelia pajamatabëcueneaebiataneme, bajara pijinia pacuenia xanëjavaberena ata panejumaitsimë tsane patanejamatabëcueneaebiataexaemë. Panejumaitsimë tsane mapacueniaje: “Pacuenia pacavënëlivaisitanetsi Dioso pesaëta pinijicuene nexanaejava Capernaum tomarata, bajara icatsia pitsicuene exanare majotaje nevitsabitomarata,” panejamë tsane, jai Jesús judíovi penacaetuatabiabibota penaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Xaniajanë cajena pacuenia pacatsipaebijitsiatsi. Itsanë ata Diosojumepaebinëmi profetanë pijanacuapijivi apo jumecovënëtsitsi petsipaebilivaisi. Jamatabëcuene aebiataeyabiabatsi pijanacuapijivi. ");
INSERT INTO guh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bajayata profetanëmibeje pinijicuene exanae atabeje, pinijicuene apo exanaebeje pijanacuata. Bajara pijinia pacuenia xanë ata pinijicuene apo exanaenë tsane tavitsabitomarata. Bajayata, abaxë pamatacabi profeta Elíaspijinë ponapona Israel nacuata, bajarapamatacabi, emarapae ata, ema apo jopae. Nexata acueyabi pavaibeje epatua ajibi ema. Nexata daxita nacuanëjava bitso janibo. Bajarapamatacabi janibovajënaeya pamonajivi pevecuatëpaevanëtsi ayaibitsaëto jinavanapa Israel nacuata. Bitso bejiobi tsavanapae. ");
INSERT INTO guh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Itsiata Elíaspijinë Dioso apo itorobitsi peyavenonaenexa bajarapamonaeyajuvënëva. Elíaspijinë Dioso itorobatsi peponaenexa Sarepta tomarapijivijavabelia, Sarepta tomarata pamona pevecuatëpaevatsi Elíaspijinë peyavenonaenexa. Sareptatomara eca Sidón nacuata. ");
INSERT INTO guh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bajayata, Elíaspijinë pevënamuto, profeta Eliseopijinë ponapona Israel nacuata. Bajayajebi bitso peperabëtsabanaevi, ayaibitsaëto picani jinavanapa Israel nacuata. Itsiata bajarapamatacabi profeta Eliseopijinë caenë ata pijanacuapijinë, bajayajebi bitso peperabëtsabanaeviyajuvënënë, apo jamatejemayaexanae. Caenë bajayajebi bitso peperabëtsabanaenë Naamán, Siria nacuaverena pepatsinë, jamatejemayaexana, jai Jesús judíovi penacaetuatabiabibota penaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nexata bajarapamonae itsa jumetane bajarapacuenia Jesús pejumaitsijava, bitso Jesús baraanaepanatsi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bajarapamonae nonobapuna. Vaetabatsi Jesús. Caponaliatsi tomarajumabelia. Patsutoyenepanata eca Nazarettomara, bajarapatsutojumabetsia Jesús caponayatsi pexuabinexatsireca picani bajarapatsuto itapajanitojavareca. ");
INSERT INTO guh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Itsiata baitsi jane Jesús bajarapamonae tuatuajëta najetarucae ata, pëtaenejevatsi vecuapona baja Capernaum tomarabelia. Nexata baja Jesús vecuapanepa bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús pata Capernaum tomarata. Capernaum tomara eca Galilea nacuata. Nexata Capernaum tomarata Jesús jivi livaisi tsipaeba judíovi penacueraevetsimatacabita. ");
INSERT INTO guh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Itsa bajarapamonae jumetane palivaisi Jesús tsipaeba, jamatabëcuenenabenajaca. Tsipaji xaniavaetsia tsipaeba Dioso pitorobinëtsicuenia. ");
INSERT INTO guh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bajarajota judíovi penacaetuatabiabibota pebi, dovathi peyajavaponaponaenë, naeca. Nexata bajaraponë Jesúsjavabelia vavajai tsaxuabi. Jumaitsi: ");
INSERT INTO guh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesús, Nazaret tomarapijinëmë, panevecuaponare baja! ¿Detsa xua paneexanaejitsiamë? ¿Najetarucame tsaja pataneveretsinexamë? Xanë cajena cayapëtanetsi. Xamë raja Dioso pexënatomë, pepo pexaniajamatabëcuenenëmë, jai dovathi peyajavaponaponaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús nexata jumeitaveta dovathi. Jumaitsi: —¡Moyamëre! ¡Vecuapitsapare baja maponëje! jai Jesús. Nexata dovathi pebi xuabatsi irata daxita bajarapamonae pitabarata. Dovathi baja pebi vecuapitsapatsi itsiata itsacuene exanaenejevatsi. ");
INSERT INTO guh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nexata daxitajivi bajarapacuene itsa tane, bitso jamatabëcuenenabenajaca. Najumaitsi bajarapamonae: —¿De meta pacuenia maponë caëjëpatsi pijumeta pexanaenexa mapacueniaje? ¡Maponëje Jesús, beDioso pitorobinëtsitsica! ¡Itaveta dovathi pepitsapaenexa jivivecua! ¡Nexata baja dovathi pitsapa jivivecua! najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nexata Jesús vënëlivaisitanetsi daxita bajarapanacuapijivi. ");
INSERT INTO guh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Judíovi penacaetuatabiabibo pevecuapitsapaecujinae, Jesús joneya Simón Pedro pijaboyalia. Nexata bajarajota Jesús pevajënae, Simón pijava pena bitso romaebanucatsi. Nexata bajarajota itsamonae Jesús tsipaebarëcëpatsi bajarapova peromaebanucaejavatsi. ");
INSERT INTO guh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús nexata cujilia peromaebanucaevatsi. Vecuaitaveta peromaebijavatsi. Nexata bajarajota peromaebanucaevatsi domae baja vecuaajibi tsanajetsitsireca. Bajarapova baja jamatejema. Nexata bajarapova Jesúsbana pexaejavanexa toexanatsi. ");
INSERT INTO guh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Itsa baja ajena meravitsia, jivi piavitanevi, daxitaviriavitane pexainaevi, tocapatatsi Jesúsjavaberena. Jesús nexata perabëjayatapona caejivi canacujitsia, piavitanevi. Bajarapacuenia Jesús jamatejemayaexana daxita piavitanevi. ");
INSERT INTO guh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Itsamonae ayaibitsaëto, dovathi peyajavajinavanapaevi, Jesús vecuacapitsapapona. Nexata dovathi itsa pitsapa, vavajai tsabiabi Jesúsjavabelia. —Xamë raja Dioso pexënatomë, jai tsabiabi. Nexata Jesús jumeitavetabiaba dovathi. Apo tocopatabiabi pecuaicuaijainexa petsipaebiyaniva itsamonaejavabelia. Tsipaji dovathi xaniavaetsia yapëtanetsi Cristo athëbëvetsica Dioso pitorobijavatsi jivi pecapanepaenexa. ");
INSERT INTO guh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bajayacunua, ajena baja matacabi tsarucaponae, Jesús pitsapa tomaravecua. Pona pesaicaeyojavabelia. Nexata jivi pëjaitatsi. Yapënapatatsi itsajota Jesús eca. Asivatsi bajarapamonae Jesús pevecuaponaeyaniva itsajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Itsatomaranëjava ata raja tsipaebijitsianë pexanialivaisi pacuenia Dioso evetsijitsia pijajivi mapanacuataje. Bajarapalivaisi tatsipaebinexa jivi, Dioso baja cajena nitoroba, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bajarapacuenia Jesús Judea nacuajava livaisi jivi tsipaebanajetaruca judíovi penacaetuatabiabibonëjava. ");
INSERT INTO guh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Itsamatacabi Jesús nuca Genesaret pucaxaneto itapata. Nexata jivi ayaibitsaëtoxaneto cënënaponatsi imoxoyo pejumetaenexatsi Jesús petsipaebilivaisi, Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nexata Jesús anijajerabeje taeruta bajarajota pucaitapata. Bajarapamobeje dujuai peyamatajucaevi Simónbana vecuanonobajunarëcëpa. Nexata bajarajota imoxoyo Simónbana quiatanubena dujuai peyamatajucaejava. ");
INSERT INTO guh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nexata Jesús runareca jera ënëabereca, Simón pijajera ënëabereca. Jesús itoroba Simón jera peyatorotsinexatsilia tsiquirijavayo puca tuatuajëyojavabelia. Jesús eca jeraënëta. Nexata Jesús jera ënëjavaverena livaisi tsipaebeca bajarapajivi bitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Itsa baja Jesús copata jivi livaisi petsipaebijava, nexata jumaitsi Simónjavabelia: —Pavaeremelia jera piavajubuajavabelia. Pacoparemeca dujuai paneyamatajucaejava. Payamatajutsianame dujuai, jai Jesús Simónjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nexata Simón jumaitsi Jesúsjavabelia: —Jesús, payamatajucajë rabaja picani meravijebi. Itsiata apo payamatajutsinë caenëyo ata. Itsiata pacuenia paneitorobame, pacopatsiarecajë dujuai patayamatajucaejava, jai Simón Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nexata copareca pitorobicueniatsi. Itsa jutsina dujuai peyamatajucaejava, ayaijavaxaneto bitso dujuai yajutsina. Nexata dujuai peyamatajucaejava imoxo peyamaëucuucucae. ");
INSERT INTO guh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nexata itacovaebarena penajuayamatajucaevi peponaenexarena itsamota peyavenonaenexatsi. Bajarapamonae nubenalia puca itapatalia. Nexata bajarapamonae ponarena. Vënëta bajarapamobeje dujuai. Imoxo dujuai peyabubunae bajarapamobeje. ");
INSERT INTO guh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nexata Simón Pedro itsa tane bajarapacuene, pematabacabëta tonuca Jesús pitabarata. Jumaitsi Jesúsjavabelia: —Tajatuxanenë, nevecuanatixire. Tsipaji xanë pibisiacuene taexanaenë, jai Simón Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bajarapasamota peyavenonaenexatsi. Bajarapamonae nubenalia puca itapatalia. Nexata bajarapamonae ponarena. Vëncuenia Simón jumaitsi tsipaji penajuayamatajucaevi yajava bitso jamatabëcuenenabenajaca, bitso ayaijavaxaneto dujuai peyamatajutsixae. ");
INSERT INTO guh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ponëbeje Simón yanatatsi, Santiagobeje Juanbeje. Bajaraponëbeje Zebedeo pexënatobeje. Bajaraponëbeje ata jamatabëcuenenabenajacabeje. Nexata Jesús jumaitsi Simónjavabelia: —Pëtsa najunaviacame. Cacujarubianatsi jivi nejucaenexa. Nexata pacuenia dujuai jucabiabame, bajarapacuenia jivi jucaename Dioso pijajivinexa, jai Jesús Simónjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nexata bajarapamonae robobocalia jerabeje tajetabojavabelia. Bajaraxuacujinae bajarapamonae pecajinavanapaejavaximi rajuta itsamonaejavabelia. Bajaraxuacujinae pënapona baja Jesús. ");
INSERT INTO guh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús itsa ponapona tomarata, nexata bajarajota patajopa pebi, bajayajebi bitso peperabëtsabanaenë. Itsa bajaraponë tane Jesús, pematabacabëta irataeya bocajunua Jesús pitabarata. Vajëta pinijicuenia Jesúsjavabelia. Jumaitsi: —Tajatuxanenë, cacaëjëpa raja tanejamatejemayaexanaenexamë mapavitanevecuaje. Itsa jitsipame, nejamatejemayaexanare mapavitanevecuaje, jai bitso peperabëtsabanaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nexata Jesús pecobeta perabëjayalia bitso peperabëtsabanaenë. Jumaitsi bajaraponëjavabelia: —Jãjã, jitsipajë cajena. Jamatejemamë rabaja, jai Jesús peperabëtsabanaenëjavabelia. Bajarapacuenia Jesús pejumaitsijavata peperabëtsabanaenëmi baja perabëxanepananajereca. ");
INSERT INTO guh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nexata Jesús jumeitaveta bajayajebi bitso peperabëtsabanaenëmi petsipaebiyaniva itsajiviyojavabelia ata pacuenia Jesús jamatejemayaexana bajaraponë. Jesús jumaitsi: —Naitajëremelia jane sacerdotenëjavabelia, templobota penacuenebinëjavabelia. Nexata sacerdotenë cataena pecavecuaajibijava baja niavitanejavami. Diosonexa rajuremelia ofrenda sacerdotenëjavabelia pecavecuaajibixae niavitanejavami. Bajara tsipaji pacuenia bajayata vajasalinainëmi Moiséspijinë nacaitoroba. Nexata jivi yapëtaena pepacuene baja pecavecuaajibijava niavitanejavami, jai picani Jesús bajayajebi bitso peperabëtsabanaenëmijavabelia jivi ayaibitsaëto pevënëlivaisitaeyanivatsi. ");
INSERT INTO guh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Itsiata Jesús vënëlivaisitanetsi daxita bajarapanacuapijivi. Nexata Jesús jivi itsa vënëlivaistanetsi, ayaibitsaëtoxaneto patapona Jesúsjavaberena penamuxunaevetsinexatsi petsipaebilivaisi. Bajarapamonae pata Jesús pejamatejemayaexanaenexanua piavitanejavavecua. ");
INSERT INTO guh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Itsiata Jesús itsajavata jivivecua natixitabiaba pesaicaeyojavabelia. Bajarajota vajëtabiaba Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Itsamatacabi Jesús jivi livaisi tsipaeba. Bajarajota naena fariseovi. Naenanua judíovi pecujarubivi ata. Bajarapamonae pata Galilea nacuata penaetomaranëjavaverena, Judea nacuata penaetomaranëjavaverena ata, Jerusalén tomaraverena ata. Nexata bajarapamatacabi Jesús Dioso pesaëta caëjëpaeyaexanatsi jivi pejamatejemayaexanaenexa piavitanejavavecua. ");
INSERT INTO guh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nexata bajarajota Jesúsjavaberena pebijivi camayota yavëtacaraparena petabusipacuenabinëtsi. Bajarapamonae picani bajaraponë boyalia yavëtacarajonejitsialia peyabuatsinexa Jesús pitabarata. ");
INSERT INTO guh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Itsiata acuenebi boyalia pecajonejava. Tsipaji bitso jivi bajarapabo yavënëca. Nexata bajarapamonae petabusipacuenabinëtsi bojumabetsia cajunaya. Bomatatujavavetsica vojoexana. Nexata bajarapavojotuatsica petabusipacuenabinëtsi camayota yacopatsicatsi jivi tuatuajëatsica Jesús pitabarayatsica. ");
INSERT INTO guh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús jamatabëcueneyapëtane pacuenia bajarapamonae sivanajamatabëxainatsi. “Nacatojamatejemayaexanaenatsi cajena,” pesivajamatabëjaijavatsi Jesús jamatabëcueneyapëtane. Bajaraxuata petabusipacuenabinëtsijavabelia Jesús jumaitsi mapacueniaje: —Pibisiacuene rabaja nexanaeneconimi cavecuaajibiaexanatsi, jai Jesús bajaraponëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nexata judíovi pecujarubivi, fariseovinua, itsa jumetaeyena Jesús pejumaitsijava bajarapacuenia, najamatabëxainena bëpënëa mapacueniaje: —¿De meta maponëje? Maponëje Dioso apo pejitsipaecuenia cuaicuaijai. Itsanë ata cajena apo caëjëpaetsi itsajivi pibisiacuene pexanaeneconimi pevecuaajibiaexanaenexa. Caenë Dioso caëjëpatsi itsajivi pibisiacuene pexanaeneconimi pevecuaajibiaexanaenexa, jamatabëjai tsenae bajarapamonae bëpënëa Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nexata Jesús jamatabëcueneyapëtane bajarapamonae bëpënëa pesivanajamatabëxainenaejava bajarapacuenia. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Pëtsa bajarapacuenia panesivanajamatabëxainame. Tsipaji cajena xanë necaëjëpa jivi pibisiacuene pexanaeneconi tavecuaajibiaexanaenexa. ");
INSERT INTO guh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Paxamë apo pacacaëjëpae ata itsajivi pibisiacuene pexanaeneconi panevecuaajibiaexanaenexa, pacacaëjëpa picani saya jema panejumaitsinexa pejamatejemavijavabelia mapacueniaje: “Cavecuaajibiaexanatsi rabaja pibisiacuene nexanaeneconimi,” panejainexa. Tsipaji itsajivi ata apo yapëtae tsipae saya jema panejumaitsijava. Itsiata baitsi jane itsa pepacuene apo pacacaëjëpae panejamatejemayaexanaenexa petabusipacuenabinëtsi, nexata acuenebi panejumaitsinexa bajaraponëjavabelia mapacueniaje: “Nonotapunare. Ponare baja,” panejainexa. Tsipaji bajarapacuenia pajumaitsimë ata, itsa apo jamatejema tsipae bajaraponë, nexata daxitajivi pacayapëtaejitsipa apo papecacaëjëpaecuene panejamatejemayaexanaenexa bajaraponë, jai nexata Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Xanë, Daxitajivi Pematapijinënë, mapanacuata necaëjëpa tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata pacuenia baja exanajë maponëjavabeliaje. Nexata patanecueneyapëtaenexamë tanecaëjëpaejava tavecuaajibiaexanaenexa itsajivi pibisiacuene pexanaeneconimi ata, pataema pacuenia jamatejemayaexanaejitsianë maponëje, jai Jesús bajarapamonaejavabelia. Nexata icatsia Jesús jumaitsi petabusipacuenebinëtsijavabelia: —Xamë cajumaitsitsi. Nonotapunare. Nijacamayo pire. Nijaboyabelia baja ponare, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nexata bajarapacuenia Jesús pejumaitsijavata, petabusipacuenebinëmitsi nonotabapuna baja daxitajivi pitabarata. Pebocaecamayo pita. Pona baja pijaboyabelia. Penajetarucaejavata namutua, Diosojavabelia jumai tsanajetarucae: “Diosomë, pexaniacuene netoexaname,” jai tsanajetarucae bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nexata daxita pamonae tane petabusipacuenabinëmitsi baja pejamatejemajava, pinijicuenia jamatabëcuenenabenajaca. Nexata bajarapamonae jumaitsi Diosojavabelia: —Diosomë, pexaniacuene bitso nexanaenë, jai Diosojavabelia. Daxitajivi itsa tane bajaraponë pejamatejemajava, pejamatabëcueneta bëpënëa bitso junava. Nexata bajarapamonae najumaitsi: —Ajena, mapamatacabitaje, tanetsi Dioso pinijicuene pexanaejava, najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús baja vecuapona pabota jamatejemayaexana petabusipacuenabinëtsi. Nexata Jesús penajetarucaejavata taeyeta Levívënënë. Bajaraponë pematamoyanijobinë impuestomatamo gobierno pejamatabëcuene. Pabota jivijavabelia matamoyanijobabiaba impuestomatamo, bajarapabota eca Leví. Nexata Jesús jumaitsi Levíjavabelia: —Leví, nepënaponare, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jejai Leví. Nexata nonotapuna. Copata baja daxita pacuene bajarajota nacuenebabiaba. Pënapona Jesús. ");
INSERT INTO guh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bajaraxuacujinae Leví pijabota napata Jesús. Nexata Leví pinijifiesta toexana Jesúsnexa. Tsipaji Leví jamatabëcuenebarëya Jesús pejunatsixaetsi pijajivitonënexa. Nexata Leví pijabota naena ayaibitsaëto jivijavabelia impuestomatamo pematamoyanijobivi gobierno pejamatabëcuene. Itsamonae ata Leví pijabota naena mesa muxuneneta. ");
INSERT INTO guh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nexata fariseovi, judíovi pecujarubavinua, Leví pijabo jumapënëvelia penubenaevi, jamatabëcuenenavëxaniabiaya baracuaicuaijaitsi Jesús pijajivijavabelia. Bajarapamonae Jesús yabara jumaitsi: —Jesús rabaja naneconita Diosojavabelia. Tsipaji gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivijavata, piajamatabëcuenebejevijavatanua, naxaeyeca pexaejava, jai bajarapamonae jamatabëcuenenavëxaniabiaya Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús itsa jumetane fariseovi, judíovi pecujarubivinua, pebaracuaicuaijaijavatsi, nexata Jesús jumaitsi bajarapamonaejavabelia mapacueniaje: —Pevaëbinë raja apo vaëbi pejamatejemavi. Pevaëbinë raja piavitanevi vaëba. ");
INSERT INTO guh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bajara pijinia xanë ata itsinë. Apo sivapatajopaenë tajunatsinexa pamonae baja aneconijibi tsavanapae. Sivapatajopajë raja tajunatsinexa pijaneconi pexainaevi. Bajarapamonae junataponajë pecopabinexa pibisiacuene pexanaejava, penajamatabëcuenepënëyorotsinexa Diosojavabelia, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Fariseovi, judíovi pecujarubivinua, jumaitsi Jesúsjavabelia: —Juan pijajivi, fariseovi pijajivinua, pexaejava apo xaeyabiabi pamatacabibeje Diosojavabelia vajëcapona. ¿Detsa xuajitsia xamë nijajivi pexaejava xaeyabiaba Diosojavabelia pevajëcaematacabianë ata? jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús nexata comparacióncuenia jumaitsi bajarapamonaejavabelia: —Pamonae junatatsi penacasabifiestajavabelia penanabaninexa, apo atsobi pexaejava itsa abaxë yajavaecatsi pejananacasabinë. ");
INSERT INTO guh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Itsiata baitsi jane itsa pejananacasabinë tsimaxëpatsipatsi pijavajabitsaë pevecuacaponaenexatsi itsajavabelia, nexata pecovëta bajarapamonae apo xae tsipae pexaejava. Tsipaji bitso najamatabëxainaejitsipa. Bajara pijinia itsi tajajivi ata. Tayajavaponaponaeepato abaxë apo atsobabiabi pexaejava pamatacabibeje Diosojavabelia vajëtapona. Itsiata pamatacabi xanë necaponaena bajarapamonaevecua, nexata jane baja bajarapamatacabi pexaejava apo xae tsane bitso tanesivanajamatabëxainaexae, jai Jesús peyanijobivitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nexata bajarapamonae perujujamatabëcuene baja penavecuacopatsinexa, Jesús livaisi tsipaeba comparacióncuenia, bajarapamonae pejumecovënëtsinexa ëpejanalivaisi, Jesús petsipaebilivaisi. Bajarapamonae anijajamatabëcuenebeje pexainaeyaniva, perujujamatabëcuene baja penavecuacopabinexa, Jesús livaisi tsipaeba comparacióncuenia. Perujujamatabëcuene yabara Jesús jumaitsi bajarapamonaejavabelia mapacueniaje: —Itsajivi ata apo caucutsi pejananaxatatsijava pejanapana pecatsatarutsinexa perujunaxatatsiesetojavabelia. Itsa caucutsipa pecatsatarutsinexa pejanapana perujunaxatatsiesetojavabelia, nexata bijianaejitsipa pejananaxatatsijava. Apo itajitsipaenua tsipae pejanapana perucaejava perujunaxatatsiesetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Itsajivi ata pijinia apo epacae pejanavinoranë perujubocodoruanëjavabelia bajayajebi peyajebinexa. Pejanavinoranë itsa epacaejitsipa perujubocodoruanëjavabelia, nexata pejanavinoranë yatititibia tsipae. Tsipaji perujubocodoruanë apo yanayeretsi tsipae xaniavaetsia. Tsipaji pejanavinoranë pejumalitsëxë abaxë xaina. Nexata itsa yatititibia tsipae, naxuabijitsipa vinoranëmi. ");
INSERT INTO guh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bajaraxuata bepaca pejanavinoranë pejanabocodoruanëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Itsajivi perujuvinora piapaecujinae, apo jitsipae piapaenexa pejanavinora. Tsipaji jamatabëjumaitsi: “Perujuvinora bitso xanepana pejanavinora matatoxenetsia,” jamatabëjai, jai Jesús bajarapamonaejavabelia comparacióncuenia. Bajarapacuenia Jesús jumaitsi comparacióncuenia tsipaji bajarapamonae catsiteca perujujamatabëcuene. Nexata Jesús jitsipa bajarapamonae pejumecovënëtsinexa ëpejanalivaisi, palivaisi Jesús tsipaeba. ");
INSERT INTO guh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Judíovi penacueraevetsimatacabita Jesús, pijajivi yajava, najetaruca namutua trigo pabianëjava. Nexata Jesús pijajivi piajanixae, trigoruanë siricanajetarubena. Xunacobenacaquiatanajetarubena. Xuxaeyabuatapona. ");
INSERT INTO guh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nexata fariseoviyajuvënëvi jumaitsi Jesús pijajivijavabelia: —Paxamë raja paexaname Dioso Moiséspijinëta penajumecopatsilivaisi vajanacaitavetsicuene. Apo nacaitavetsi ata trigoxu vajaxaeyaniva, itsiata ajena penacueraevetsimatacabixae, apo bepaexanaemë mapacueniaje, jai fariseovi Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús nexata jumaitsi fariseovijavabelia: —Ajena, penacueraevetsimatacabita, tajajivi bajarapacuenia exanae ata, itsiata apo pibisiacuene. Tsipaji bitso piajani. ¿Apo palebimë tsipaji Dioso pejumelivaisibaxuto paneyapëtaenexa pacuenia vajasalinainëmi Davidpijinë, pebarëponaponaevi yajava, exana pamatacabi bitso piajani? ");
INSERT INTO guh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bajaraponë Davidpijinë joneya Dioso pijatemploboyalia. Nexata Dioso pijatemploboënëta, mesajumata bobena Diosonexa ofrendacuenia petojebipanbëanë. Bajarapapanbëanë itsajivi ata apo tocopatsitsi pexaenexa penaneconitsiyaniva Diosojavabelia. Ësacerdotevi picani pexaenexa tocopatatsi. Davidpijinë apo sacerdotenë ata, pijajivi barëxae ata bajarapapanbëanë, itsiata apo vënananeconitsi Diosojavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Icatsia pematatsënëa Jesús jumaitsi fariseovijavabelia: —Xanë, Daxitajivi Pematapijinënë, netoxanepana cajena tatsipaebinexa pacuene xanepana jivi pexanaenexa penacueraevetsimatacabita ata, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Itsamatacabi Jesús joneya judíovi penacaetuatabiabiboyalia judíovi penacueraevetsimatacabita. Nexata bajarajota Jesús jivi livaisi tsipaeba. Bajarajota pebi pecujuanenia pecobetsaquenaenë, naeca. ");
INSERT INTO guh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nexata Jesús naitaxutocaevetenatsi judíovi pecujarubivi, fariseovinua, petaenexatsi Jesús pejamatejemayaexanaejava pecobetsaquenaenë judíovi penacueraevetsimatacabita. Nexata Jesús pecobetsaquenaenë itsa jamatejemayaexana penacueraevetsimatacabita, “Jesús raja pibisiacuene exana,” pejainexa bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nexata Jesús yapëtane pacuenia bajarapamonae sivanajamatabëxainatsi. Nexata Jesús jumaitsi pecobetsaquenaenëjavabelia: —Nonotapunare. Nucare majotaje mapamonae pitabarataje, jai Jesús. Nexata pecobetsaquenaenë nonotapuna. Nuca bajarapamonae pitabarata. ");
INSERT INTO guh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nexata Jesús jumaitsi penaitaxutocaevetenaevitsijavabelia: —Penacueraevetsimatacabita ata xanepana vajaexanaenexa pexaniacuene. Xanepana vajajamatejemayaexanaenexa piavitanevi, jai Jesús penaitaxutocaevetenaevitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús matatoyorotsia naëcoba daxita pamonae ena bajarajota. Jesús jumaitsi pecobetsaquenaenëjavabelia bajarapamonae pitabënejeva: —Namaxërovire, jai Jesús. Nexata baja pecobetsaquenaenë namaxërovita. Bajarajota cobexanepananajereca baja. Pecobetsaquenaejavami ajibi. ");
INSERT INTO guh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nexata judíovi pecujarubivi, fariseovinua, itsa tane Jesús pecobexanepanaeyaexanaejava pecobetsaquenaenë, bitso anaepana. Nexata jane baja najumejaita pacuenia Jesús beyaxuabijitsiatsi. ");
INSERT INTO guh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jesús pijajivi ayaibitsaëtoxanetoyajuvënëvi, doce saya ponëbeje, itapeta apóstolevinexa. Jesús pitapetsivajënaeya apóstolevinexa, junaya petsutojumabetsia pevajëtsinexa Diosojavabelia. Nexata Jesús meravijebi bajarapatsutojumatatsia vajëtapona Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bajayacunua, ajena baja matacabi tsarucaponae, Jesús junata daxita pijajivibitsaëtoxaneto bajaraponëjavabelia. Nexata bajarajota itapeta pijajivibitsaëtoxanetoyajuvënëvi, doce saya ponëbeje. Bajarapamonae Jesús vënëruba apóstolevi. ");
INSERT INTO guh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pamonae Jesús itapeta apóstolevinexa mapevënëanëje. Copiaya ponë, pevënë Simón. Bajaraponë Jesús vënëruba itsavënë, Pedro. Itsanë Andrës, Simón Pedro jane baja pejuyapijinë. Itsanë Santiago. Itsanë Juan. Itsanë Felipe. Itsanë Bartolomé. ");
INSERT INTO guh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Itsanë Mateo. Itsanë Tomás. Itsanë Santiago, Alfeo pexënato. Itsanë Simón, celotenë. ");
INSERT INTO guh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Itsanë Judas, Santiago pejuyapijinë. Itsanë Judas Iscariote. Bajaraponë bexëajavabelia Jesús canajetsijitsiatsi pijavajabitsaë pecobeyabelia pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús baja, pijajivi ayaibitsaëtoxaneto yajava, runaica petsutojumavetsica. Nexata epatua petsutoyenepanajavata, itsajota ira namatajëpa, Jesús yajavanuca pijajivi ayaibitsaëtoxaneto. Bajarajota nexata jivi nacaetuata ayaibitsaëtoxaneto. Bajarapamonae Judea nacuapijivi, itsamonae Jerusalén tomarapijivi, itsamonae Tiro tomarapijivi, itsamonae Sidón tomarapijivi. Tiro tomarabeje Sidón tomarabeje, manuameneitapata ecabeje. Daxita bajarapatomaranëpijivi nacaetuata pejumetaenexa Jesús petsipaebilivaisi. Bajarapamonae patanua Jesús pejamatejemayaexanaenexa piavitanejavavecua. ");
INSERT INTO guh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bajarapamonaeyajuvënëvi itsajamatabëcuene tsabiabi dovathi pejamatabëcueneta. Bajarapamonaenua Jesús jamatejemayaexana. ");
INSERT INTO guh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Daxita pamonae bajarajota nacaetuata, Jesús picani jamatabëjayabatsi. Tsipaji Jesús daxitajivi piavitanejavavecua jamatejemayaexanapona pecaëjëpaejamatabëcuenetatsi. ");
INSERT INTO guh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús pijajivi naëcota asaëya. Jumaitsi bajarapamonaejavabelia: —Panajamatabëcuenecopabame baja Diosojavabelia paneponaenexa Dioso pijatomarabetsia. Bajaraxuata paxamë bepanejamatabëcuenejiobivimi panijaneconi yabara, aeconoxae baja pajamatabëcuenebarëyamë Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Pajitsipame Dioso pijacuene. Pajamatabëcuenebarëyamë baja. Tsipaji Dioso athëbëtatsia pacarajutsiana daxitacuene xua panamatavenoname. ’Paneyanuevimi pibisiacuene paneexanaeneconi yabara, pacavecuaajibiaexana baja bajarapaneconi. Bajaraxuata itsamatacabi pajamatabëcuenebarëyamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Xanë, Daxitajivi Pematapijinënë, patajajivixaemë, itsa pacaitoya tsane jivi, itsiata pasivajamatabëcuenebarëyamë tsane. Bajarapamonae pacanavecuaitavetsi ata tsane, itsiata pasivajamatabëcuenebarëyamë tsane. Pibisiacuenia pacabijatae ata tsane, pibisiacuenia pacabaracuaicuaijai ata tsane, itsiata pasivajamatabëcuenebarëyamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bajarapacuenia pacaexanae ata tsane, itsiata pasivajamatabëcuenebarëyamë tsane. Tsipaji raja Dioso athëbëtatsia pacarajutsiana bitso pexaniacuene jivi papecaitoyajamatabëcuene. Pamonae pacaitoya tsane, bajarapamonae pijasalinaivimi bajayata itoya Diosojumepaebivimi profetavi. Nexata bajarapamonae pijasalinaivimi bajayata bejiobiaexanapona Diosojumepaebivimi profetavi. Bajarapamonae aeconoxae ata pijasalinaivimi cuenejëpavanapa. Bajaraxuata paxamë ata icatsia bajarapamonae pacaitoya tsane pijasalinaivimi pecuenejëpavanapaexae. ");
INSERT INTO guh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Daxitacuene mapanacuata panexainaevi, Dioso bitso ayaicuenia pacabejiobiaexanaena. Tsipaji pacabarëyamë tsavanapae ëpanexainaejava mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Bitso bepajamatabëcuenejiobimë tsane daxitacuene mapanacuata panenatojitsipaecuene panexainaevi. Pasivajamatabëcuenebarëyamë picani tsavanapae panexainaejava. Itsiata baitsi jane itsamatacabi itsa patëpaename, panetëpaecujinae panajamatabëxainaename ayaicuenia. ’Bepajamatabëcuenejiobimë tsane panejëajëajaitsabiabivi sivabarëyaya mapanacuapijicueneje. Paneasaëtsavanapaeepato abaxë mapanacuataje panesivajamatabëcuenebarëya tsabiabixae bajarapacuene, panetëpaecujinae bitso payanuename pibisiacuene paneexanaeneconi. ");
INSERT INTO guh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Mapanacuapijivi pexaniacuenia pacabaracuaicuaijai tsabiabi saicayacuenia Dioso pejumelivaisivecua panetsipaebabiabixae. Itsiata baitsi jane pamatacabi Dioso pacananeconitsiaexanaena, bitso bepajamatabëcuenejiobimë tsane. Tsipaji pacuenejëpame bajayata pamonaemi jinavanapa. Bajarapamonaemi bajayata jivi tsipaebabiaba saicayacuenia Dioso pejumelivaisivecua. Nexata bajarapamonaemi pexaniacuenia baracuaicuaijaitsi tsabiabi mapanacuapijivije, jai Jesús pijajivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Icatsia Jesús jumaitsi petsutoyenepanajavata pijajivi ayaibitsaëtoxanetojavabelia: —Pacatsipaebijitsiatsi icatsia patanenamuxunaevetsivimë. Pasivamëre papecaitoyavi ata. Pexaniacuene patoexanare pamonae pacaitoya. ");
INSERT INTO guh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Payavenonare pamonae pacabijatane pibisiacuenia. Pamonae pacabaracuaicuaijai pibisiacuenia, patovajëre Diosojavabelia peyavenonaenexatsi. ");
INSERT INTO guh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Itsajivi itsa pacaitabarapacabiaxuaba anaeya, nexata icatsia itsanenia ata patonaitabaracaevere papecaitabarapacabiaxuabinexa. Itsajivi itsa pacayacajërëta panijacamisajumavelia panenaxatatsijava, nexata patocopare panijacamisa ata papecayacajërëtsinexa. ");
INSERT INTO guh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pajivi itsacuenejavayo amoneya pacavajëta, parajure. Itsajivi itsa pacayacajërëta itsacuenejavayo, pëtsa payanijobame papecatocanaviatsinexa. ");
INSERT INTO guh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xua pexaniacuene, paxamë pajitsipame itsamonae papecatoexanaenexa, copiaya paxamë bajarapapexaniacuene patoexanare bajarapamonaejavabelia, jai Jesús pijajivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsa pasivamë tsipae ëpapecaasivavi, nexata pexaniacuene apo paxainaemë tsipae Diosojavabelia. Tsipaji piajamatabëcuenebejevi ata, pamonae asivatsi, banamataenetsianasiva. ");
INSERT INTO guh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pexaniacuene itsa patoexanaejitsipame pexaniacuene ëpapecatoexanaevijavabelia, nexata apo paxainaemë tsipae pexaniacuene Diosojavabelia. Tsipaji piajamatabëcuenebejevi ata, pexaniacuene batoexana penajamatabëcuenejëpaevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Itsa patsicopatsipame ëpanejamatabëcuene yapëtaevijavabelia baja, papecatocanaviatsinexa pacuenia patsicopatame, nexata apo paxainaemë tsipae pexaniacuene Diosojavabelia. Tsipaji piajamatabëcuenebejevi ata, batsicopata penajamatabëcuenejëpaevijavabelia, pamonae jamatabëcueneyapëtane baja petocanaviatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nexata pasivamëre panijavajabitsaë ata. Bajarapamonaejavabelia pexaniacuene patoexanare. Bajarapamonae patsicopare panajamatabëxainaenejevamë papecatocanaviatsinexa panetsicopatsicuenia. Bajarapacuenia bitso paxainaename pexaniacuene Diosojavabelia papecarajutsinexa athëbëtatsia. Bajarapacuenia itsa paexanavanapaename, Dioso, athëbëtatsia peecaenë, pexicuenia pacaexanaena. Tsipaji Dioso pitaxutotsoniataenë piajamatabëcuenebejevi ata. Itsamonae Dioso yavenonae atatsi, itsiata apo canaëjëtsi Dioso peyavenonaejavatsi. Bajarapamonae apo canaëjëtsi ata Dioso peyavenonaejavatsi, itsiata tsiteca Dioso itaxutotsoniataeyabiaba. ");
INSERT INTO guh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pacuenia Dioso daxitajivi itaxutotsoniataeyabiaba, bajarapacuenia paxamë ata itsamonae ata paitaxutotsoniataename, jai Jesús pijajivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Icatsia Jesús jumaitsi pijajivi ayaibitsaëtoxanetojavabelia petsutoyenepanajavata: —Pëtsa panataneme pepacuene bepaneaneconijibivi. Nexata itsamonae pibisiacuene pexanaejava xaniavaetsia payapëtaenejevamë, pëtsa pabaracuaicuaijamë mapacueniaje: “Bajarapitsipibisiacuene pexanaevi, Dioso bitso ayaicuenia naneconitsiaexanaenatsi,” pajamë pëtsa. Nexata paxamë ata juya bajarapacuenia itsamonae apo pacabaracuaicuaijai tsane pibisiacuene paneexanaejava yabara. Itsamonae pibisiacuene pacaexanae ata, pajamatabëcuenecaevare. Pabarajamatabëcuenexanepanarenua. Nexata pijinia Dioso pitabarata pibisiacuene paneexanaejava Dioso jamatabëcuenecaeviana. Pacabarajamatabëcuenexanepanaenanua. ");
INSERT INTO guh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Parajutaponare itsamonaejavabelia penamatavenonaejavaxi. Nexata juya paxamë Dioso pacarajutaponaena pacuenia jitsipa papecarajutsinexa. Pacarajutsiana xuavajëto itsamonae parajutame matatoxenetsia, jai Jesús daxitajivijavabelia petsutoyenepanajavata. ");
INSERT INTO guh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús icatsia comparacióncuenia tsipaeba bajarapamonaejavabelia mapalivaisije: —Ponë bitso itaxutotsëcëna, apo caëjëpaetsi pematacaponaenexa itsanë, ponë pijinia bitso itaxutotsëcëna. Itsa matacaponaejitsipa, nexata najuajopaejitsiparecabeje bajaraponëbeje caemëthëxanetojavareca. ");
INSERT INTO guh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Itsajivi pijinia itsa nacujaruba, yapëtae ata baja penacujarubijava, apo jamatabëcuenematatoxenetsi pecujarubinëtsi. Itsa baja penacujarubijivi vereta xaniavaetsia penacujarubijava, nexata saya najamatabëcuenejëpabeje pecujarubinëtsibeje, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jesús pijajiviyajuvënëvi pepacuene bepianeconijibivi natane. Nexata itsa cujirutane itsamonae itsacuenejavayo pexanaejava, jumai tsabiabi: “Mapitsicuene pexanaevi Dioso bitso ayaicuenia naneconitsiaexanaenatsi,” jai tsabiabi. Nexata bajarapacuenia pejumaitsabiabixae, Jesús pijajivi piurabinexa jumaitsi mapacueniaje: —Pëtsa paxamë pepacuene bepaneaneconijibivi nataeya pamuxujiobame itsajivi pijaneconi yabara. Tsipaji raja apo payapëtaemë paxamë ata pijinia paneconivajëto paxainame. ");
INSERT INTO guh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nexata paxamë ata ayaineconixaneto itsa paxainame, nexata itsanëjavabelia apo bepajumaitsimë: “Tajabananë, papibisiacuene exaname, copare,” apo bepajamë. Yamaxëitojorobiaya saya bepexaniajamatabëcuenevi nataeya pacuaicuaijamë tsabiabi. Itsamonae pijaneconi yabara pabaracuaicuaijamë tsabiabi. Itsiata pijinia paxamë ata paneconivajëto paxainame, apo payapëtaemë. Paxamë copiaya pacopabare pibisiacuene paneexanabiabijava. Bajara jane xuacujinae paitavetsianame itsamonae ata pibisiacuene pexanaejava penavecuacopatsinexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Icatsia Jesús jumaitsi pijajivi ayaibitsaëtoxanetojavabelia petsutoyenepanajavata: —Pexaniavirianaenë itsa ubatsi, nacuaita pijinia pexaniacuai. Apo nacuaitsi pibisiacuai. Ponae pijinia pibisianae, apo nacuaitsi pexaniacuai. ");
INSERT INTO guh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Caevirianae canacujitsia yapëtanetsi itsa nacuaita. Higovënecuaito apo paucutsimë cucunanaeta. Uvaru pijinia apo paucutsimë saya pejuviënëbotota. ");
INSERT INTO guh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bajara pijinia itsi jivi ata. Pexaniajamatabëcuenenë pexaniacuene yabara cuaicuaijai. Tsipaji pexaniajamatabëcuene xaina pejamatabëëthëtota. Pibisiajamatabëcuenenë pijinia pibisiacuene yabara cuaicuaijai. Tsipaji pibisiajamatabëcuene najamatabëxaina pejamatabëëthëtota. Nexata pacuene yabara pebi pecuaibovojotota cuaicuaijai, bajarapacuene pitsapa pejamatabëëthëtojavavetsina, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Icatsia Jesús jumaitsi pijajivi ayaibitsaëtoxanetojavabelia petsutoyenepanajavata: —¿Detsa xuajitsia: “Tajatuxanenë,” panejamë tsabiabi ata, itsiata apo panejumecovënëtsimë patacaitorobicuenia? ");
INSERT INTO guh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Pajivi xanëjavaberena pata tanenamuxunaevetsinexa, tanejumecovënëtsinexanua, bajarapajivi apo nacueratsi tsane. Bajarapajivi piatajairata bo bepexanaenë tsane. Bajarapajivi yabara pacatsipaebianatsi. Bo pexanaenënexa, peyapëtaexae itsajota pijabo exanaejitsia pebubutsijavanexa, nexata naesituru atajaya xaniavaetsia mëthëca piatajairata. Nexata pijabo toyabubutsi ata, petojopaeyanivatsi. Bajaraxuacujinae bo baja vereteta. Itsa baja mene avajubuatsica, pijabo toyabubutatsi. Mera asaëtsica bojavabetsica. Itsiata pijabo apo tonanequetsitsi. Tsipaji naesituru xaniavaetsia mëthëca piatajairata. Nexata bajaraponë apo nacueratsi bo pexanaejava. ");
INSERT INTO guh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pajivi nejumetae ata tsane tatsipaebilivaisi, itsiata itsa apo nejumecovënëtsi tsane tatsipaebilivaisi, nacueratsiana. Bajarapajivi tajetabota bo bepexanaenë tsane. Ponë tajetabota pijabo exaneta, yapëtae ata emarapae pecopiapatsijavanexa, bajaraponë nacuerata bo pexanaejava. Tsipaji bo peveretetsicujinae, mene avajubuatsica. Nexata pijabo toyabubutatsi. Bo nexata jopaica. Pepacuene baja nexata abeje, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús baja itsa najumevereta pijajivi ayaibitsaëtoxaneto livaisi petsipaebijava petsutoyenepanajavata, pona baja Jesús Capernaum tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Capernaum tomarata ponapona Romano nacuapijinë, vajabitsaë pijacapitán. Bajaraponë pijajivitonë, bitso piasivanë, toavitanetsi. Totëpaejitsiatsi baja. ");
INSERT INTO guh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bajaraponë capitán vënëlivaisitanetsi Jesús pejamatejemayaexanaponaejava piavitanevi. Nexata capitán jumaitsi judíovi pijaancianovijavabelia: —Panetojunaremelia Jesús. Pabarëpatsiaremena tajaboyaberena tanetojamatejemayaexanaenexa tajajivitonë, jai capitán judíovi pijaancianovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nexata bajarapamonae pona Jesúsjavabelia. Itsa pata Jesúsjavabelia, pinijicuenia junata. Jumaitsi Jesúsjavabelia: —Bajaraponë capitán bitso pexaniajamatabëcuenenë. Nexata tojamatejemayaexanaename pijajivitonë. ");
INSERT INTO guh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tsipaji raja bajaraponë nacaasiva vaxaitsi judíovitsi. Matamota cajena pijapalatata vajanacatoexanetsinexa vajanacaetuatabiabibonexa, jai judíovi pijaancianovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nexata Jesús nalia bajarapamonae pepëta. Itsa baja imoxoyotanajetarubena capitán pijabo, nexata capitán icatsia peyapëtaevitsi itoroba Jesús pemataenenaenexatsi. Capitán peyapëtaevitsi itoroba Jesúsjavabelia pejumaitsinexa mapacueniaje: —Petuxanenë, pëtsa paremena tajaboyaberena. Apo caquenetsiataejitsipaetsi. Beveliajamatabëcuenenënë raja saya xanë xamëvecua. Nexata apo xanepanae tsipae nenajonejava tajaboyaberena. ");
INSERT INTO guh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Apo nejamatabëcuenecaëjëpaenua taponaejava xamëjavabelia ata. Saya bajaraverena itorobare ënijume. Nexata tajajivitonë netojamatejema tsane. ");
INSERT INTO guh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Xanë ata xainajë taneitorobabiabivi taneitorobicuenia tajumecovënëtabiabinexa. Xanë ata juya xainajë vajabitsaë, tajajivi, taitorobicuenia tanetoexanabiabinexa. Nexata itsa itorobajë caenë vajabitsaënë peponaenexa, bajaraponë ponabiaba. Itsa junarenajë itsanë vajabitsaënë pepatsinexa maberenaje, bajaraponë patabiabarena. Itsa itorobajë tajajivitonë tanetoexanaenexa itsacuenejavayo, nexata netoexanabiaba. Bajara pijinia pacuenia xamë ata nexanaenexa, cacaëjëpa. Nexata saya bajaraverena ënijume itorobare saya ënijumeta tajajivitonë tanetojamatejemayaexanaenexamë, jai capitán mapacueniaje petonajumeitorobijume Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús itsa jumetane bajarapacuenia capitán petonajumeitorobijumetsi, jamatabëcuenenabenajaca capitán petonajumeitorobijumetsi yabara. Nexata napënëyorotaxuaba Jesús. Jumaitsi pepënanajetarubenaevitsijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Caeto ata cajena Israel nacuapijinë apo caxitajarabaxuabinë xanëjavaberena bitso tanesivanajamatabëcuenecopatsinë pacuenia mapacapitán nesivajamatabëcuenecopatsiaya jumaitsije, jai Jesús capitán yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nexata baja pamonae capitán itorobalia Jesús petsipaebinexatsi capitán penajumeitorobilivaisi, naviabarena baja capitán pijaboyaberena. Itsa baja pata boyaberena, caxitajaraba baja capitán pijajivitonë pejamatejemanë. ");
INSERT INTO guh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús pona Naín tomarabelia. Nexata yanatatsi pijajivi, itsamonae yajava, ayaibitsaëtoxaneto. ");
INSERT INTO guh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Itsa baja Jesús patanajetaruca Naín tomara imoxoyojavata, nexata camataenenatsi petëpaenë pecanajetarubenaevi. Bajarapamonae petëpaenë tomaravelia capitsapa pemëthëtsinexa tomarapënëyabelia. Ponë tëpa, bajaraponëmi pamona pevecuatëpaevatsi pexënato, pepo cainë. Nexata pamona pevecuatëpaevatsi pexënato, petëpaenë, itsa caponaliatsi pemëthëtsinexatsi, tomaraverena jivi ayaibitsaëtoxaneto pënaponatsi. ");
INSERT INTO guh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nexata Jesús itsa tane bajarapova, tsitabejiobitsi bitso. Nexata Jesús jumaitsi bajarapovajavabelia: —Matanueyabijitsipame, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nexata Jesús cujitabalia petëpaenë peyacajoniacanajetarubenaevi. Pecobeta jayata cajoni. Nexata petëpaenë peyacajoniacanajetarubenaevi, nubenaothopa. Nexata Jesús jumaitsi petëpaenëjavabelia: —Pevëjëato, xanë raja cajumaitsitsi. Namatacore, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nexata baja petëpaenëmi namatacota. Cuaicuaijai. Jesús baja tocanaviata piasaënë penajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nexata daxita petaevitsi jamatabëcuenenabenajaca. Najumaitsi bajarapamonae: —Dioso bitso ayaijamatabëcuenenë. Pinijijamatabëcuene pexainaenë, profeta, nacatsitanajamatabëcueneitajëta. Dioso pinijicuene pexanaejava ata nacatsitajëta vajataenexa, najai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Daxita Judea nacuapijivi, imoxoyo nacuanëjava ata pejinavanapaevi, Jesús vënëlivaisitanetsi xua exana. ");
INSERT INTO guh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan jivibautisabinë naneconitsia ponapona penaneconitsivi pejebabiabibota. Nexata pijajivi tsipaebatsi daxita Jesús pexanaponaejava yabara. Nexata Juan junata anijanëbeje pijajivitonëbeje pitorobinexa Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Juan pitorobivajënae pijajivitonëbeje, jumaitsi bajaraponëbejejavabelia: —Pajumaitsimëbeje tsane Jesúsjavabelia: “ ‘¿Xamë tsabaja Cristomë? ¿Xamë tsabaja tajëvelia cavajunupaebapona nepatsijavanexatsica daxitajivi necapanepaenexa? Itsa apo Cristomë, ¿abaxë tsaja pacopiaevetavanapaenajë itsanë athëbëvetsica Dioso pitorobinexatsicatsi jivi pecapanepaenexa?’ jai raja Juan,” pajamëbeje tsane Jesúsjavabelia, jai Juan pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nexata Juan pijajivitonëbeje itsa patabeje Jesúsjavabelia, Juan pijajivitonëbeje jumaitsibeje Jesúsjavabelia: —Juan raja jivibautisabinë paneitorobabeje patacayanijobinexabeje. “¿Xamë tsabaja Cristomë? ¿Xamë tsabaja tajëvelia cavajunupaebapona nepatsijavanexatsica daxitajivi necapanepaenexa? Itsa apo Cristomë, ¿abaxë tsaja pacopiaevetavanapaenajë itsanë pepatsijavanexatsica?” jai raja Juan, jaibeje jane baja Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nexata bajaraponëbeje pitabëta Jesús jamatejemayaexanapona ayaibitsaëtoxaneto piavitanevi. Dovathi peyajavajinavanapaevi ata vecuacapitsapa dovathi. Itaxutoxanepanaeyaexananua pamonae bitso itaxutotsëcëna. ");
INSERT INTO guh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nexata Jesús jumaitsi Juan pijajivitonëbejejavabelia: —Paponarebeje baja. Patsipaebianamebeje Juanjavabelia pacuenia baja patanemebeje taexanaponaejava. Patsipaebianamebejenua pacuenia baja pajumetanemebeje tatsipaebilivaisi jivijavabelia. Apo petaevimi ata itaxutoxaniavaetaponajë xaniavaetsia petaenexa. Petabusipacuenabivitsinua daxita jinavanapaeyaexanaponajë. Bajayajebi bitso peperabëtsabanaevinua vecuaajibiaexanaponajë baja. Bitso pemuxusipanaevinua jumetaeyaexanaponajë baja xaniavaetsia pejumetaenexa. Petëpaevimi ata icatsia asaëyaexanaponajë. Pexanialivaisinua pecapanepaelivaisinexatsi pibisiacuene pexanaeneconimivecua, tsipaebaponajë bepejiobivijavabelia. Daxita bajaraxua taexanaponaejava patanetaejavamëbeje, patsipaebianamebeje Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pajumaitsimëbejenua tsane Juanjavabelia: “Jesús raja jumaitsi: ‘Jamatabëcuenebarëya pajivi tsiteca nejumecovënëta xanë Dioso pexënatocuenenë,’ jai raja Jesús,” pajamëbeje tsane Juanjavabelia, jai Jesús Juan pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Itsa baja Juan pijajivitonëbeje naviatabeje, nexata bajaraponëbeje pecovëta Jesús taxuxuaba jivijavabelia petsipaebijava Juan pelivaisi. Jesús jumaitsi jivijavabelia: —Itsa paponame petusato nacuayabelia pamatacabi Juan ponapona petusato nacuata, ¿detsa pitsicuene pajamatabënaponaremelia panetaenexa bajarajotalia? ¿Paponaremelia tsaja saya panetaenexa musuli penajëabijava jovibota? ");
INSERT INTO guh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Itsa apo paponaemëlia panetaenexa musuli penajëabijava jovibota, ¿detsa nexata pitsicuene panetaenexa paponaremelia? ¿Paponaremelia tsaja saya panetaenexa naitabëtsiaya pexaniajava penaxatatsinë? Paxamë rabaja payapëtaneme mapacueneje. Pamonae naitabëtsiaya pexaniajava naxatababiaba, pamonae ata nabanebiaba pexanianabanijavanë, bajarapamonae jinavanapa nacuanë pevetsivi pijabonëjava. ");
INSERT INTO guh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Detsa nexata xua pajamatabënaponaremelia panetaenexa petusato nacuayabelia? Paponaremelia raja panetaenexa Diosojumepaebinë profetanë. Xaniajanë pacuenia pacatsipaebijitsiatsi. Juan itsa pataneme, pepacuene jane baja pepo profetanë, Diosojumepaebinë, pataneme. Nexata saya bevelia profetanë apo pataemë. ");
INSERT INTO guh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan pexanaejavanexa, bajayata tajëvelia Dioso pejumelivaisibaxutota vajunupaeba. Dioso tanejumaitsijava ata xanëjavaberena, Dioso pejumelivaisibaxutota jumaitsi mapacueniaje: Itorobianajë nevajënaeyabelia tanejumelivaisipaebinënexa jivi pecatsivajënae najamatabëcuenexaniavaetsinexa, jai bajayata Dioso pejumelivaisibaxutota athëbëvetsica tapatsivajënaeyatsica Juan tanelivaisi paebanajetarucaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juan ayaijamatabëcuenenë mapanacuataje. Nexata bajayata Juan pevajënaeya paprofetavimi jinavanapa, itsanë ata Juan apo jamatabëcuenematatoxenetsitsi. Itsiata baitsi jane pajivi beveliajamatabëcuenejivi ata, itsa najamatabëcopata baja Diosojavabelia pijatuxanenë pexanaenexa, bajarapajivi juya Dioso ayaijamatabëcuenejivi exanaenatsi Juan matatoxenetsia, jai Jesús Juan jivibautisabinë yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan vënëlivaisitanetsi daxitajivi. Impuestomatamo pematamoyanijobivi ata gobierno pejamatabëcuene, vënëlivaisitanetsi. Bajarapamonae jumecovënëta palivaisi Dioso najumecopata Juanjavabelia. Nexata Juan bautisaba bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Itsiata fariseovi, judíovi pecujarubivinua, namuxujemata bajarapalivaisi. Nexata picani pacuenia Dioso tojitsipatsi bajarapamonae pexanaenexa, apo exanae. Nexata Juan apo bautisabi bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús icatsia jumaitsi jivijavabelia: —¿Detsa meta pacuenia yapëtaeyaexanaenajë itsamonaejavabelia bajarapamonae xaniavaetsia papecayapëtaenexa pacuenia paxamë pajamatabëcueneitsimë tsavanapae? Jumaitsinë meta tsane paxamë yabara mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","“Bajarapamonae abaxë saya bepejevaxijivixi, pajivixi tomara tuatuajëjava banamuxusitenavanapa. Pejevaxijivixi itsa namuxusitenavanapa, bavavajai tsenae penajua namuxusitenaevijavabelia. Pevavajaijavata bajumaitsi: ‘Pacatoobecatsi picani flauta. Itsiata apo payavajibimë. Pacatonaxëanecatsi picani panemuxunanuevajinexa ata. Itsiata apo panuemë,’ bajai tsenae pejevaxi penajua namuxusitenaejivixijavabelia. Bajara saya jamatabëcueneitsi pamonae aeconoxae jinavanapa mapanacuataje,” janë meta tsane paxamë yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan jivibautisabinë Dioso pitorobilivaisi jivi tsipaebanajetaruca. Pexaejava itsajavata apo xaeyabiabi pamatacabibeje Diosojavabelia vajëtapona. Vinora ata apo apaeyabiabi. Nexata bajaraponë yabara jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabi: “¡Juan raja dovathi yajavaponapona!” pajamë tsabiabi jamatabëcuenenavëxaniabiaya. ");
INSERT INTO guh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bajaraxuacujinae icatsia xanë, Daxitajivi Pematapijinënë, najetarucajë. Itaxutojema xaniji. Matavëjëa apaeyabiabajënua. Nexata xanë yabara icatsia jamatabëcuenenavëxaniabiaya pajumaitsimë tsabiabi: “¡Pataema maponëje! Ayaijava xaeyabiaba. Ayaira matavëjëa apaeyabiabanua piaitajibinexa. Barënajamatabëcuenejëpanua gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi. Pamonae ata piajamatabëcuenebejevi, barënajamatabëcuenejëpa,” pajamë tsabiabi xanë yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Itsiata baitsi jane itsamonae xaniavaetsia yapëtaena paxanëbeje Juanbeje Dioso pejamatabëcueneta bitso pataneyapëtaeyaexanaejavabeje. Nexata daxita bajarapamonae yapëtaena pacuenia Dioso paneyapëtaeyaexanabeje pepacuene pepo pexaniajaijamatabëcuene, jai Jesús mapacueniaje jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseonë, Simónvënënë, pijabota Jesús penanabaninexa, junatatsi. Nexata Jesús napona Simón pijaboyabelia. Jesús naeca mesa muxuneneta penanabaninexa. ");
INSERT INTO guh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bajarapatomarata ponapona petiriva, pibisiacuene pexanabiabiva pevitota palata pepitsinexa. Bajarapova itsa jumetane penanabanijavanexa Jesús Simón pijabota, nexata bajarapova capata alabastrovënë ibotota pexanaebotellabë. Pevënëcaebë pexaniapetuxujuviaceitera. Bajarapova capata bajarapaaceitera Jesús petsitaxuepacaenexa. ");
INSERT INTO guh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nexata bajarapova Jesús petaxusalibënenia, pematabacabëta nucajunua petsitaxuepacaenexa jane baja bajarapaaceitera. Nexata saya bajarajota itacarajeta bajarapova nua. Tsipaji pibisiacuene pexanabiabineconi bitso yanajamatabëxaina. Nexata bajarapova pitaxutobarëmene othopa Jesús petaxujavabereca. Nexata bajarapova pematanata taxuiquica. Bajaraxuacujinae yaiyataeya taxutsutsune. Tsitaxuepaca jane baja petuxujuviaceitera. ");
INSERT INTO guh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nexata Simón, ponë Jesús junatatsi, itsa tane pacuenia petiriva exana Jesúsjavabelia, nexata Simón jamatabëjumaitsi mapacueniaje: —Itsa peneta pepacuene maponë Jesús, pepo profetanë tsipaeje, nexata yapëtaejitsipa pitsijamatabëcueneva taxujayabatsi. Yapëtaejitsipa bajarapova pibisiacuene pexanabiabivacuene. Nexata apo tocopatsi tsipae petaxujayabinexatsi, jamatabëjai Simón Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nexata Jesús jumaitsi Simónjavabelia: —Simón, xainajë livaisiyo tacatsipaebinexa, jai Jesús. Simón nexata jumaitsi: —Jesús, netsipaebare, jai. ");
INSERT INTO guh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nexata Jesús jumaitsi Simónjavabelia comparacióncuenia: —Palata petsicopababiabinë amoneyabatsi anijanëbeje. Caenë amoneyabatsi quinientos padenariobeje. Itsanë amoneyabatsi saya cincuenta padenariobeje. ");
INSERT INTO guh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nexata bajaraponëbeje apo xainaebeje juya petocanaviatsinexabeje petsicopatsimatamotsibeje. Nexata palata petsicopatsinë jumaitsi bajaraponëbejejavabelia: “Iquinajë baja bajaraxuami pataniamoneyabijavamëbeje. Naxuabi baja jema,” jai. ¿Detsa nexata ponë bitso sivajamatabëcuenebarëya palata petsicopatsinëtsibejejavabelia? jai Jesús Simónjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón nexata jumaitsi Jesúsjavabelia: —Ponë meta picani ayaijava amoneyaba, sivajamatabëcuenebarëya palata petsicopatsinëtsijavabelia, jai Simón. Nexata Jesús jumaitsi: —Xaniajamë rabaja, jai Jesús Simónjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús napënëyorota petirivajavabelia. Nexata jumaitsi Simónjavabelia: —Simón, ¿taneme tsabaja pacuenia exana xanëjavaberena mapovaje? Xanë junuajë nijaboyaberena. Itsiata yaiyataeya xaniavaetsia apo necopiapitsimë. Apo nerajutsimë mera ata tanataxuquiatsinexa. Mapovaje netaxuquiata baja pitaxutobarëmeneta. Netaxuiquicanua pematanata. ");
INSERT INTO guh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Xamë nijabota patsi atanë, apo nitabaratsutsunimë tanecopiapitsinexamë xaniavaetsia. Mapovaje tapatsicujinae apo copatsi cajena yaiyataeya tanetaxutsutsuneponaejava. ");
INSERT INTO guh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Xamë xaniavaetsia tanecopiapitsinexamë, apo netsimataepanaemë aceitera. Mapovaje netsitaxuepaca pexaniapetuxujuviaceitera. ");
INSERT INTO guh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nexata catsipaebatsi neyapëtaenexa mapacueneje. Mapovaje pinijicuenia nesivajamatabëcuenebarëya. Tsipaji ayaineconi ata pibisiacuene pexanaeneconimi, vecuaajibiaexanajë. Pajivi saya tsiquirineconiyo vecuaajibiaexanajë, pibisiacuene pexanaeneconi, nayapëtane. Tsipaji saya bajarapajivi tsiquirijavayo nesivajamatabëcuenebarëya, jai Jesús Simónjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nexata Jesús jumaitsi petirivajavabelia: —Pibisiacuene rabaja nexanaeneconimi cavecuaajibiaexanatsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Itsamonae ata, pamonae Simón junata penanabaninexa Simón pijabota, naena mesa muxuneneta. Nexata bajarapamonae najumai tsenae Jesús yabara: —¿Detsa meta maponëje? Jamatabëcuenenavëxaniabiaya natane bepejamatabëcuenecaëjëpaenëtsi jivi pibisiacuene pexanaeneconi pevecuaajibiaexanaenexa, najai tsenae bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nexata Jesús jumaitsi petirivajavabelia: —Dioso pecacapanepaeva tsane pibisiacuene nexanaeneconimivecua. Tsipaji nesivanajamatabëcuenecopatame xanëjavaberena. Jamatejema baja ponare. Cavecuaajibiaexanatsi rabaja pibisiacuene nexanaeneconimi, jai Jesús petirivajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Simón pijabota Jesús penanabanicujinae, najetaruca pinijitomaranëjava, tsiquiritomaraxijava ata. Tsipaebanajetaruca pacuenia Dioso pijajivi evetsijitsia. Jesús, pijajivi doce ponëbeje, apóstolevi, yajavanajetaruca. ");
INSERT INTO guh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jesús yajavanajetaruca petiriavinua, papetiriavi dovathi vecuacapitsapa yajuvënëvi. Papetiriavi ata piavitanejavavecua Jesús jamatejemaya exana yajuvënëvi, Jesús yajavanajetaruca. Bajarapapetiriaviyajuvënëva, caeva pevënë María, Magdala tomarapijiva. Bajarapova Jesús vecuacapitsapa siete ponëbeje dovathivi. Bajarapadovathivi Jesús pevecuacapitsapaecujinae, María pënaponatsi. ");
INSERT INTO guh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Itsava pevënë Juana, Cuzavënënë pijava. Bajaraponë Cuzavënënë, nacuaevetsinë Herodes pijajivitonë. Itsava pevënë Susana. Bajarapapetiriavi pematatsënëa, itsapetiriavi, ayaibitsaëto, yajavanajetaruca Jesús. Bajarapapetiriavi pexainaepalatayajuvënëjava, rajuta Jesúsjavabelia. Nexata xuaxi Jesús pijajivi barënamatavenona pebarëcomuatsinexa bajarapapalatata. ");
INSERT INTO guh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jivi naropoba tomaranëjavaverena. Pata Jesúsjavaberena petaenexatsi. Itsa baja ayaibitsaëtoxaneto nacaetuata Jesúsjavaberena, nexata Jesús livaisi tsipaeba peubinë pelivaisicuenia. Jesús jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Peubinë pona pabiabelia peubinexa. Nexata itsa pata pabita, peubixu pexucayajabajarabicuenia ubanajetaruca. Nexata itsaxu othopa pabi tuatuajëjava penajetarucaenamutojumata. Bajarapaxu jivi taxunanonoba. Nexata bajarapaxumi juvinejeva baratsui xane. ");
INSERT INTO guh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Itsaxu pijinia othopa ibopananëjumata, itsajota bitso ira apo aitayaë. Nexata bajarapaxu juvi ata, tsaquenapona. Tsipaji ira tseva. ");
INSERT INTO guh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Itsaxu pijinia othopa xanëebacabomijavata. Nexata peubixu xanëebotonë caecuenia itsa yajavajuva, bitso xanëebotonë matacënënatsi peubijavami. ");
INSERT INTO guh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Itsaxu pijinia othopa pexaniairata. Bajarapaxu itsa juva, vitsaba. Nexata xaniavaetsia nacuaita. Itsabotonë capitsapa cien paxutoyobeje ata, jai Jesús jivi ayaibitsaëtoxanetojavabelia. Itsa Jesús tsipaeba bajarapalivaisi, pinijijumeta jumaitsi: —Pajivi jamatabëjumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús bajarapalivaisi petsipaebivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nexata Jesús pijajivi yanijobatsi. Jesús pijajivi jumaitsi Jesúsjavabelia: —Palivaisi jivijavabelia tsipaebame peubinë pelivaisicuenia, pajamatabëcuene xaina, patayapëtaenexa panetsipaebare, jai Jesús pijajivi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús nexata jumaitsi pijajivijavabelia: —Paxamë rabaja xaniavaetsia Dioso pacayapëtaeyaexana Dioso papijajivimë papecaevetsijava. Bajarapacuene abaxë daxitajivi apo yapëtae. Bajaraxuata bajarapamonae itsa tsipaebajë livaisi, ëcomparacióncuenia tsipaebaponajë. Nexata bajarapamonae tae ata Dioso pesaëta pinijicuene taexanaejava, itsiata apo yapëtae pajamatabëcuene yabara exanajë pinijicuene taexanaejava. Namuxunaevetsi ata tatsipaebilivaisi, itsiata apo jumeyapëtae pajamatabëcuene xaina tatsipaebilivaisi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Icatsia Jesús jumaitsi pijajivijavabelia: —Mara pajamatabëcuenelivaisi xainaje, palivaisi pacatsipaebatsi pabita peubinë pelivaisicuenia. Pacuenia itsi pabita peubixu, bajara pijinia itsi Dioso pitorobilivaisi jivi pejamatabëëthëtota. Dioso pitorobilivaisi jivi itsa tsipaebatsi, tsijamatabëubatsi Dioso pitorobilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nexata pacuenia itsi pabita peubixu, paxu othopa pabi tuatuajëjava penajetarucaenamutojumata, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae itsa tsipaebatsi Dioso pitorobilivaisi, jumetane picani. Tsijamatabëubatsi jane baja picani Dioso pitorobilivaisi. Itsiata baitsi jane pejumetaecujinae bajarapalivaisi, bepijia dovathi najetaruca bajarapamonaejavaberena. Nexata bajarapamonae tsijamatabëjuvinejevatsi, petsijamatabëubilivaisitsi dovathi baja vecuapitatsi bajarapalivaisimi. Vecuapitatsi pevajënaeyabelia Dioso pejumecovënëtsiyaniva, Dioso pecapanepaeyanivatsi pibisiacuene pexanaeneconivecua. ");
INSERT INTO guh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pacuenia pijinia itsi paxu othopa ibopananëjumata, itsajota bitso ira apo aitayaë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae Dioso pitorobilivaisi jumetane. Nexata picani bajarapalivaisi barëyaya jumecovënëta. Itsiata baitsi jane pacuenia irabereca apo atabunepepiareca paxu othopa ibopananëjumata, nexata nabijiana, bajara tsijamatabëcueneitsitsi bajarapamonae Dioso pitorobilivaisi. Tsipaji saya caeepatoyo jumecovënëta bajarapalivaisi. Nexata paepatota dovathi jamatabëcueneëjëtatsi, copaba baja bajarapalivaisi pejumecovënëtsijavami. ");
INSERT INTO guh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pacuenia pijinia paxu othopa xanëebacabomijavata, itsa juva, bitso matacënënatsi xanëebotonë, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Jumetane picani bajarapamonae Dioso pitorobilivaisi. Itsiata baitsi jane bitso jamatabëcueneenatsi mapanacuapijicuene yabaraje. Tsipaji najamatabëxaina ayaijava palata pexainaenexa. Najamatabëxainanua pexanaenexa pacuene mapanacuapijivi exana saya jema pebarëyanexa. Bajaraxuata Dioso pitorobilivaisi apo tovitsabitsi pejamatabëëthëtota. Nexata pacuenia itsi pabita piacuaijibibotonë, bajara itsi bajarapamonae. Tsipaji Dioso xaniavaetsia apo tojinavanapae. ");
INSERT INTO guh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pacuenia pijinia itsi paxu othopa pexaniairata, bajara tsijamatabëcueneitsitsi itsamonae Dioso pitorobilivaisi. Bajarapamonae ajamatabëcuenexuirajibi. Ëpexaniajamatabëcuene najamatabëxaina. Casaë tsavanapae pevajënaeyabelia Dioso pejumelivaisi pejumecovënëtsijava. Nexata Dioso pejumelivaisi tsijamatabëcuenevitsabaponatsi pevajënaeyabelia. Tsipaji exanavanapa Dioso pitorobicueniatsi, jai Jesús pijajivijavabelia itsa tsipaeba peyapëtaeyaexanaenexa palivaisi jivijavabelia tsipaeba pabita peubinë pelivaisicuenia. ");
INSERT INTO guh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsajivi ata lámparabë pitanojotsicujinae, apo mataacatetsi itsacuenejavata. Cama bëxëpanalia ata apo etsi. Biji rajane athëbëyo etsia jivi boyaberena pejonevi petsivajënaeitayotecaenexa. ");
INSERT INTO guh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bajara pijinia itsi palivaisianë tsipaebaponajë comparacióncuenia daxitajivi picani peyapëtaenexa. Najumematayatsia apo tsipaebaponaenë. Itsamonae nejumetae ata, aeconoxae abaxë apo nejumeyapëtae pajamatabëcuene xaina tatsipaebilivaisianë. Itsiata itsamatacabi, bexëajavabelia, daxitajivi nejumeyapëtaena pajamatabëcuene xaina palivaisianë comparacióncuenia tsipaebaponajë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Icatsia Jesús jumaitsi pijajivijavabelia: —Panejumecanaëjëre patacatsipaebilivaisi. Itsamonae ata itsa pacatsipaebiana, bajarapamonae ata pajumecanaëjëtsianame papecatsipaebilivaisi. Palivaisivajëto panejumecanaëjëtsianame, nexata bajarapalivaisivajëto panejumeyapëtaename. Itsiata icatsia pematatsënëa bajarapitsilivaisivajëto Dioso pacayapëtaeyaexanaena. Pajivi xaniavaetsia nejumeyapëtane patacatsipaebilivaisi, bajarapajivi icatsia itsalivaisi pematatsënëa Dioso jumeyapëtaeyaexanaenatsi. Itsiata pajivi apo jitsipae pematatsënëa pejumeyapëtaeponaenexa, bajarapajivi palivaisiyovajëto picani jumeyapëtane, nacofënëtsiana, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús pejuyapijivi, pena yajava, pata Jesúsjavaberena. Itsiata acuenebi bajarapamonae pimoxoyotsijava Jesús. Tsipaji bitso jivi ayaibitsaëto Jesús matatoyorotsia vënëcatsi. ");
INSERT INTO guh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nexata pamonae Jesús petsipaebilivaisi matatoyorotsia jumetaeyenatsi, jumaitsi Jesúsjavabelia: —Patajatuxanenë, ena raja, nejuyapijivi yajava, nuca patapënëverena. Bajarapamonae pina jitsipa pecataejava, jai Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nexata Jesús jumaitsi daxita bajarapamonaejavabelia: —Pamonae jumetane Dioso pejumelivaisi, jumecovënëtanua pacuenia Dioso itorobatsi, bajarapamonae jane baja tajuyapijivi, taenajivinua, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Itsamatacabi Galilea nacuata Jesús, pijajivi yajava, runareca jera ënëabereca. Jumaitsi pijajivijavabelia: —Nicabaliatsi mapapucaxaneto itsapanabeliaje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Itsa baja naropobalia, Jesús majitanuca. Nexata pinijijoviboxaneto jemata najetaruca. Malataca nexata bitso ayai. Nexata malataca jera ënëaberena mera epabajarabapona. Mera nexata vënëcapona jera ënëaberena. Bubunaejitsia baja bajarapamo. ");
INSERT INTO guh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nexata Jesús pemajitanucaenë pijajivi yaitavabatsi. Jesús pijajivi jumaitsi: —¡Patajatuxanenë, vaxaitsimi rabaja yaothopaenatsi! jai Jesús pijajivi. Nexata Jesús pemajitanucaenëmi naëcotapuna. Pinijijumeta itavetaxuaba jovibo, malataca yajava. Jovibo baja nexata ajibi tsaxuabi. Mene ata baja nexata vainae ecaxuaba. ");
INSERT INTO guh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia bitso pajunavame? ¿Tsipaji apo payapëtaemë Dioso papecaevetsijava? jai Jesús pijajivijavabelia. Nexata Jesús pijajivi itsa tane Jesús pitavetsijava jovibo, malataca yajava, Jesús pijajivi jamatabëcuenenajunaviaca bëpënëa. Nexata Jesús pijajivi najumaitsi: —¿De meta tsipaji maponëje? ¡Itaveta jovibo, malataca yajava! ¡Nexata jumecovënëtatsi! ¡Nexata baja jovibo, malataca yajava, ajibi tsaxuabi! najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesús pijajivi barëyaëta pucaxaneto itsapanabelia, Gerasa nacuayabelia. Gerasanacua boca puca itsapanaverena, Galileanacua pecanacujitsialia. ");
INSERT INTO guh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Itsa Jesús jeravecua nonotajunaya, mataenenarenatsi bajarapanacuapijinë, dovathivi peyajavaponaponaenë. Bajaraponë bajayajebi baja jumasa ponaponabiaba. Pijabota apo ponaponae. Jivimëthëanëjavata saya ponaponabiaba. ");
INSERT INTO guh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nexata bajaraponë itsa pata Jesúsjavaberena, pematabacabëta nucajunua Jesús pitabarata. Pinijijumeta aëjai. —Jesús, Dioso athëbëtatsia peecaenë pexënatomë. ¿Detsa xua jaitame xanëjavaberena? Pexaniacuene bitso cavajëtatsi. Nejamatabëcuenebejiobitsipame, jai dovathivi peyajavaponaponaenë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bajarapacuenia jumaitsi dovathivi peyajavaponaponaenë tsipaji Jesús jerajavavetsina penonotajunaejavata, dovathivi peyajavaponaponaenë pemataenenaejavatatsi, Jesús itaveta dovathivi. Jesús jumaitsi dovathivijavabelia mapacueniaje: “¡Dovathivi, bajaraponë baja pavecuapitsapare!” jai. Bajaraponë anijatonë dovathivi vaetababiabatsi. Jivi picani bajaraponë cadenamaëtonëta cobecëtabiabatsi. Yajavataxucëtabiabatsi cadenamaëtonëta xaniavaetsia picani peecaenexa. Itsiata baitsi dovathivi peyajavaponaponaenë ucubabiaba cadenamaëtonëmi. Dovathivi pejamatabëcueneta najetabajiravabiaba petusatuabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nexata Jesús jumaitsi bajaraponëjavabelia: —¿Detsa pavënëmë? jai Jesús. Nexata bajaraponë navënëpaeba. —Tavënë raja Legión, jai. Bajarapacuenia navënëpaeba tsipaji dovathivi ayaibitsaëtoxaneto tsijamatabëjinavanapatsi. ");
INSERT INTO guh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bajarapadovathivi vajëta Jesúsjavabelia infiernojavabelia Jesús pitorobiyaniva. ");
INSERT INTO guh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nexata bajarajota, imoxoyo petsutojavata, marranobitsaëtoxaneto xaevanapa. Dovathivi bitso vajëta Jesúsjavabelia. —Panetocopare patajonenexa marranobitsaëtoxanetojavabelia, jai dovathivi. Jesús nexata pevajëtsicueniatsi tocopata. ");
INSERT INTO guh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nexata dovathivi pebi vecuapitsapecatsi. Nexata marranobitsaëtoxanetojavabelia baja junua dovathivi. Nexata daxita bajarapamarranobitsaëtoxanetomi cujinaeyeca. Pucaxaneto itapajanituareca othopareca. Bajarajota daxita marranobitsaëtoxanetomi meneta bubuna. ");
INSERT INTO guh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Marrano pevetsivi itsa tane bajarapacuene, rëcëpeca. Pona, pacuene tane, petsipaebinexa tomarapijivijavabelia, petsipaebinexa vayafotusatojava penaevijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nexata jivi ponarena petaenexa bajarapacuene. Jivi itsa parena Jesúsjavaberena, taeyeta dovathivi peyajavaponaponaenëmi peecaejava Jesús pemuxuneneta. Penaxatatsijava baja bajaraponë naxatateca. Jamatejema baja. Xaniavaetsia eca. Nexata bajarapamonae cujunavatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pamonae cuenetanetsi Jesús pejamatejemayaexanaejava dovathivi peyajavaponaponaenëmi, bajarapamonae paeba pepatsivijavabelia daxita pacuenia tane. ");
INSERT INTO guh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bajarapamonae bitso cujunavatsi Jesús. Nexata daxita Gerasa nacuapijivi jumaitsi Jesúsjavabelia: —Pexaniacuene pacavajëtatsi. Ponare baja patajanacuavecua, jai Gerasa nacuapijivi Jesúsjavabelia tsipaji cujunavatsi. Nexata baja Jesús runareca jera ënëabereca. Ponaejitsia baja. ");
INSERT INTO guh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nexata dovathivi peyajavaponaponaenëmi bitso picani navajëca Jesúsjavabelia penaponaenexa picani Jesús pepëta. —Petuxanenë, netocopare tanaponaenexa nepëta, jai picani Jesúsjavabelia. Itsiata Jesús apo jejai. Jumaitsi bajaraponëjavabelia: ");
INSERT INTO guh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ponare nijamonaejavabelia. Tsipaebianame pacuenia ayaicuene nijatuxanenë Dioso catoexana, jai Jesús. Nexata baja bajaraponë pona. Tsipaebapona daxita pijatomarapijivijavabelia pacuenia Jesús jamatejemayaexanatsi. ");
INSERT INTO guh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús icatsia pecovëyaberena naviarena jerata pucaxaneto itsapanaverena. Nexata jivi ayaibitsaëtoxaneto copiapitatsi barëyaya. Tsipaji baja cajena copiaevetavanapatsi pepatsijavarena. ");
INSERT INTO guh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nexata bajarajota napatajopa Jairovënënë. Bajaraponë judíovi penacaetuatabiabibo pevetsinë. Jairo pematabacabëta yaiyataeya Jesús pitabarata nucajunua. Pinijicuenia junata. Jumaitsi Jesúsjavabelia: —Tapëta ponare tajaboyabelia, jai. ");
INSERT INTO guh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bajarapacuenia Jairo jumaitsi Jesúsjavabelia tsipaji caevayo pexënatovayo totëpaejitsiatsi. Bajarapovayo xaina doce pavaibeje. Itsa Jesús napona Jairo pepëta, jivibitsaëtoxaneto Jesús pepënaponaevitsi matatoyorotsia cënënanajetarubenatsi. ");
INSERT INTO guh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bajarapajivibitsaëtoxaneto tuatuajëta, itsava pijanacuene pecapunaevatsi nanajetaruca. Bajarapova pijanacuene pecapunaecujinaetsi, doce baja pavaibeje xaina. Beyajiobi tsabiabi bajarapajana. Daxita pexainaejavaximi navecuavereta pematamobita pevaëbivitsi. Itsiata baitsi jane itsanë ata pevaëbivitsi apo jamatejemayaexanaetsi bajarapavitanevecua. ");
INSERT INTO guh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nexata bajarapova ponataba Jesús pepënëvelia, jivibitsaëtoxaneto tuatuajëalia. Nexata bajarapova tojayataba Jesús penaxatatsijavacopia. Nexata bajarapaepatota pijanacuenemi vecuaajibitsi baja. ");
INSERT INTO guh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús nexata jumaitsi: —¿Jipatsa tanaxatatsijava netojayataba? jai Jesús. Daxitajivi jumaitsi Jesúsjavabelia: —Xanë cajena apo cajayatabitsi, jai. Nexata Pedrobana jumaitsi: —Patajatuxanenë, jivibitsaëtoxaneto raja camatatoyorotsia cënënanajetarubena. Apo becaajayatsijibi. ¿Detsa xuajitsia: “¿Jipatsa tanaxatatsijava netojayataba?” jamë? Itsajiviyo raeta baja cajayataba, jai Pedrobana. ");
INSERT INTO guh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nexata Jesús jumaitsi: —Itsajiviyo baja cajena tanaxatatsijava netojayataba. Yapëtaniji bajarapajiviyo tajamatejemayaexanaejava tasaëta, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nexata petiriva jamatabëjumaitsi: —Jesús baja yapëtane tanejamatejemayaexanaejava, jamatabëjai. Nexata bajarapova najetabarena Jesús pitabarayaberena. Neconecojai pecajunavi. Pematabacabëta tonucajunua Jesús pitabarata. Bajarapova nexata navajunupaeba daxitajivi tuatuajëta pacuene yabara tojayataba Jesús penaxatatsijava. Navajunupaebanua pacuenia jamatejemayaexanatsi pejayatabijavata. ");
INSERT INTO guh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nexata Jesús jumaitsi bajarapovajavabelia: —Xamë nesivajamatabëjumaitsimë: “Jesús penaxatatsijava itsa tojayatabianajë, tavitanejavami nevecuaajibi tsane,” nesivajamatabëjamë. Bajaraxuata jamatejemamë baja. Ponare baja jamatejema, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bajarapacuenia Jesús pejumaitsanucaejavata namutoepatota, pataba jivitonë Jairo pijaboverena. Bajaraponë jumaitsi Jairojavabelia: —Jairo, nexënatoyo rabaja tëpa. Pëtsa baja matavëjëa jamatabëitonotaponame Jesús, jai bajaraponë Jairojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús jumetae ata bajarapajume, itsiata jumaitsi Jairojavabelia: —Jairo, pëtsa najamatabëxainame. Najamatabëcuenecopare saya ëxanëjavaberena. Nexënatovayo raja jamatejema tsane, jai Jesús Jairojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Itsa Jesús pata Jairo pijabota, apo tocopatsi ayaibitsaëto penajonenexa Jesús pepëta petëpaevayo pebocaejavabelia. Tocopata saya penajonenexa mapamatabëxëyoje. Pedro, Santiago, Juan, petëpaevayo paxa, pena, bajara saya pamatabëxëyo tocopata penajonenexa Jesús pepëta. Pamonae Jesús pevajënae ena Jairo pijabota, bajarapamonae Jesús pitsapaeyaexana. ");
INSERT INTO guh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Daxitajivi pinijicuenia matanueyaba petëpanucaevayo. Nexata Jesús jumaitsi: —Pëtsa pamatanueyabame. Pejanava raja apo tëpae. Saya raja majitanuca, jai Jesús bajarapamonaejavabelia tsipaji yapëtane Jesús piasaëyaexanaejavanexa bajarapovayo. ");
INSERT INTO guh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bajarapacuenia Jesús pejumaitsijava, bajarapamonae saya Jesús jumecapocaponatsi. Tsipaji bajarapamonae yapëtane bajarapovayo baja picani pepacuene petëpaejava. ");
INSERT INTO guh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nexata Jesús petëpaevayo cobepita. Jumaitsi pinijijumeta: —Pejanavayo, nonotabapunare, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nexata bajarapacuenia Jesús pejumaitsijavata, petëpanucaevayomi nonotabapuna. Asaë baja icatsia petëpaevayomi. Nexata Jesús jumaitsi pejanavayo penajavabelia: —Nexënatovayo pexaejava rajure, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nexata pejanavayo paxa, pena ata, bitso jamatabëcuenenabenajacabeje. Nexata Jesús jumaitsi bajarapajivibejejavabelia: —Pëtsa papaebamebeje itsajivijavabelia ata pacuene pacatoexanatsibeje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús junata pijajivi, doce ponëbeje, penacaetuatsinexa. Nexata Jesús jumaitsi bajarapamonaejavabelia mapacueniaje: —Pacajamatabëcuene caëjëpaeyaexanatsi rabaja papecacaëjëpaejamatabëcuene dovathi peyajavajinavanapaevi ata panevecuacapitsapaponaenexa. Pacajamatabëcuene caëjëpaeyaexanatsinua piavitanevi ata panejamatejemayaexanaponaenexa. ");
INSERT INTO guh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Patsipaebanajetarubenaename daxitajivijava pacuenia Dioso pijajivi evetsijitsia. Piavitanevi ata pajamatejemayaexanaponaename, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús jane baja pijajivi penaropobivajënae, Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pëtsa itsacuenejava ata pacaponame panijanamutonexa. Pëtsa pacaponame naebo, doro ata, panemarue ata, palata ata. Caejava saya panenaxatatsijava pajumaponare. Pëtsa anijacamisabeje pacaponame. ");
INSERT INTO guh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Itsa papatabiabianame tomarata, caebota pamajitabiabianame. Pëtsa panatixitaponame itsaboyabelia panemajitsinexa. Matapania icatsia itsajavabelia itsa paponaename, bajarapabovecua papitsapaename. ");
INSERT INTO guh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Patomarata apo pacacopiapitsi tsane pexanialivaisi panetsipaebinexa, nexata pavecuaponaename bajarapatomara. Panevecuaponaevajënae bajarapatomara, bajarapatomarata panataxuatsapërëvarëbianame. Bajarapacuenia itsa panataxuatsapërëvarëbianame, yapëtaena bajarapatomarapijivi Diosojavabelia penaneconitsicuene apo papecacopiapitsixae papecanamuxunaevetsinexa panetsipaebilivaisi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bajaraxuacujinae Jesús pijajivi naropoba jane baja. Najetarubena daxitatomaraxijava. Tsipaebanajetarubena jane baja pexanialivaisi jivi pecapanepaelivaisinexatsi pibisiacuene pexanaeneconimivecua. Jamatejemayaexanaponanua piavitanevi daxitajava. ");
INSERT INTO guh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, Galileanacua pevetsinë, vënëlivaisitanetsi daxita Jesús pinijicuene pexanaponaejava. Nexata Herodes najamatabëcueneepatajërërëcaeya najamatabëxaina Jesús yabara. Tsipaji itsamonae jamatabëcuenenavëxaniabiaya Jesús yabara jumai tsaponae: “Juanpijinë raeta jivibautisabinëmi petëpaecujinae icatsia asaë,” jai tsaponae Jesús yabara. Nexata bajarapacuenia itsamonae pejumaitsaponaejava Herodes pejumetaexae, najamatabëcueneepatajërërëcaeya najamatabëxaina Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Itsamonae pijinia jumai tsaponae Jesús yabara: —Bajayata raeta ponëmi ponapona, profeta Elíaspijinëmi, icatsia asaë, jai tsaponae itsamonae. Itsamonae pijinia jumai tsaponae Jesús yabara: —Bajayata raeta pamonaemi jinavanapa, profetavimiyajuvënënë, icatsia asaë, jai tsaponae itsamonae Jesús yabara. Bajarapacuenia itsamonae jamatabëcuenenavëxaniabiaya pejumaitsaponaejava Jesús yabara, Herodes jumetane. ");
INSERT INTO guh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nexata Herodes jamatabëjumaitsi: —Xanë bajayata tajajivi itorobajë Juanpijinë jivibautisabinëmi pebeyaxuabinexa. Nexata baja tajajivi Juanpijinëmi vësiucutaxuaba. Beyaxuaba baja. ¿De tsaeta nexata ponë pinijicuene pexanaponaejava, vënëlivaisitaeyabiabajë? jamatabëjai Herodes Jesús yabara. Bajaraxuata Herodes bitso jamatabëtane Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús pitorobivi, apóstolevi, jivi pexanialivaisi petsipaebanajetarubenaecujinae, naviabanajetarubena baja Jesúsjavaberena. Nexata bajarapamonae pepatsicujinae Jesúsjavaberena, navajunupaeba Jesúsjavabelia daxita pacuenia exanavanapa. Nexata Jesús barëpona pijajivi pesajinaejavabelia, Betsaidatomara imoxoyojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Itsiata baitsi jane jivi ayaibitsaëtoxaneto pëtanetsi. Nexata bajarapamonae Jesús pecovëvelia pëjaitatsi. Nexata bajarapamonae itsa pata Jesúsjavata, Jesús copiapita xaniavaetsia. Nexata Jesús tsipaeba bajarapamonaejavabelia pacuenia Dioso eveta pijajivi mapanacuataje. Jesús jamatejemayaexananua piavitanevi. ");
INSERT INTO guh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Itsa baja caniviyo tsaponae, Jesús pijajivi doce ponëbeje cujibarenatsi. Jumaitsitsi: —Itorobaremelia baja jivi peponaenexa imoxoyo penaetomaraxijavabelia, imoxoyo penaebonëjavabelia ata. Bajarabelia bajarapamonae namajitsiana. Pexaejavanua namitsavajëtsiana. Majotaje ajibi pexaejava. Tsipaji itsajivi ata pijabo apo xainae majotaje, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nexata Jesús jumaitsi pijajivijavabelia: —Paxamë parajure pexaejava, jai Jesús. Nexata Jesús pijajivi jumaitsi: —Paxainajë saya cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava. ¿Jitsipame tsaja patacomuacaenexa pexaejava daxita mapamonae penaxaenexaje? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bajarapajivibitsaëtoxaneto bejamatabëcuene cinco mil ponëbeje. Nexata Jesús jumaitsi pijajivijavabelia: —Paenaeyaexanare pepobitsaëtonë, bejamatabëcuene cincuenta ponëbeje tsaponae caebitsaëtota, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nexata Jesús pijajivi bajarapacuenia exana. Enaeyaexana jane baja daxita jivibitsaëtoxaneto. ");
INSERT INTO guh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nexata Jesús pita cinco papanbëbeje, anijanëyobeje dujuainëyobeje yajava. Athëbëa benaëcotsia. Jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pataxaejava, jai Jesús. Bajaraxuacujinae Jesús pan epatsicacapona, dujuainëyobeje yajava. Pepatsicacaejava pijajivijavabelia rajutapona petsicobetsanaenexa daxitajivi. ");
INSERT INTO guh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Daxita xaniavaetsia nabane. Bajaraxuacujinae jivi peyajuvënëcopabejebijavanë, Jesús pijajivi vënëba doce xuabeje bemapirecuenia pexanaejavanë. ");
INSERT INTO guh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Itsamatacabi Jesús caenë vajëta Diosojavabelia pijajivi pitabëta. Nexata xuacujinae Jesús jumaitsi pijajivijavabelia: —¿Detsa jivi jumai tsabiabi xanë yabara? ¿De tsaeta xanë ponënë? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nexata Jesús pijajivi jumaitsi: —Itsamonae xamë yabara jumai tsabiabi: “Juanpijinë raeta jivibautisabinëmi icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Diosojumepaebinëmi raeta. Profeta Elíaspijinë, ponëmi bajayata ponapona, icatsia asaë,” jai tsabiabi. Itsamonae pijinia jumai tsabiabi: “Bajayata raeta Diosojumepaebivimi profetavimiyajuvënënë icatsia asaë,” jai tsabiabi xamë yabara, jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nexata icatsia Jesús jumaitsi pijajivijavabelia: —¿Detsa nexata paxamë pajamatabëitsimë xanë yabara? ¿Detsa xanë ponënë? jai Jesús pijajivijavabelia. Nexata Pedro jumaitsi Jesúsjavabelia: —Xamë raja cajena Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanapaenexa. Xamë cajena Dioso pexënatomë, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús jumeitaveta pijajivi. Jumaitsi mapacueniaje: —Pëtsa pajumaitsimë jivijavabelia: “Jesús raja Dioso pexënato,” pajamë pëtsa, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nexata Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba. Jumaitsi pijajivijavabelia mapacueniaje: —Xanë, Daxitajivi Pematapijinënë, pinijicuenia bejiobinë tsane. Judíovi pijaancianovi, sacerdotevi penamatacaitorobivinua, judíovi pecujarubivinua, apo nejumecovënëtsi tsane xanë Cristonëcuenenë. Nexata bitso nebejiobiaexanaena. Bajaraxuacujinae nebeyaxuabiana. Itsiata baitsi jane tatëpaecujinae, acueyabi matacabita, icatsia asaënë tsane, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bajaraxuacujinae Jesús jumaitsi daxitajivijavabelia: —Pajivi jitsipa tanepënaponaejava, bajarapajivi copatsi penatojitsipaecuenia pexanaenexa penajamatabëxainabiabijavami. Exanaponaponae taitorobicuenia. Bajarapajivi caematacabi canacujitsia najamatabëcueneveretsinua, bejiobiaexanaejitsia atatsi, beyaxuabijitsia atatsinua, Dioso pejumelivaisi yabara piajamatabëcuenesaë tsaponaponaenexa. Nexata jane baja xuacujinae nepënaponaena. ");
INSERT INTO guh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pajivi exanaponapona penatojitsipaecuenia, apo xainae tsane matacabi apo pevereverecaejava. Pajivi xanë tajamatabëcueneta copata penatojitsipaecuenia pexanaejavami, bajarapajivi xainaena matacabi apo pevereverecaejava. ");
INSERT INTO guh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pajivi exanaponapona penatojitsipaecuenia, bajarapajivi Diosovecua naxuabiana. Nexata bajarapajivi daxitacuene xainae ata mapanacuapijicueneje, itsiata nacuerata. Tsipaji pexainaecuene apo capanepae tsanetsi Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pajivi tajajivitonë ata, navënëlivaisicaura tsane jivijavabelia xanë tajajivitonëcuene, tanejumecovënëtsijava ata yabara, nexata juya xanë, Daxitajivi Pematapijinënë, bajarapajivi tajajivitonë ata, tajajivitonëcuene vënëlivaisicauranë tsane taxa Diosojavabelia. Bajarapajivi vënëlivaisicauranë tsane pamatacabi icatsia patsianicajë taxa Dioso pijapenivenivenaecotia yajava, tananeconitsiaexanaenexa daxita pijaneconi pexainaevi. Yajavapatsianicajënua Dioso pijaángelevi. ");
INSERT INTO guh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xaniajanë pacuenia pacatsipaebijitsiatsi. Daxita paxamë patëpaenejevamë, Dioso taxuxuabiana daxita pijajivi pevetsicuene mapanacuataje. Nexata paxamëyajuvënëvi pepuatae tsane Dioso petaxuxuabijava daxita pijajivi pevetsicuene mapanacuataje, tëpaena, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesús petëpaejavanexa tajëvelia penayajunupaebicujinae, bejamatabëcuene ocho pamatacabibejecujinae, Jesús pijajivi, acueyabi ponëbeje, barëjunaya petsutojumabetsia. Barëjunaya mapamatabëxëyoje: Pedro, Santiago, Juan. Bajarapamatabëxëyo Jesús barëjunaya petsutojumabetsia pevajëtsinexa Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diosojavabelia pevajëtsijavata, Jesús itabaranivenivena. Penaxatatsijava ata bitso nivenivenaeya niojai. ");
INSERT INTO guh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bajarajota jemata naitajëta anijanëbeje, ponëmibeje bajayata tëpa. Bajaraponëbeje Jesús barëcuaicuaijaitsi. Bajaraponëbeje tsaena Moiséspijinëbeje Elíaspijinëbeje. ");
INSERT INTO guh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bajaraponëbeje matatoyorotsia nivenivenabeje. Jesúsbana nabarëcuaicuaijai Jesús petëpaejavanexa yabara. Pacuenia Jesús bejiobiaexanaejitsiatsi Jerusalén tomarata, bajarapacuene yabara nabarëcuaicuaijai. ");
INSERT INTO guh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrobana penajuajinavanapaevi bitso itamajitsipanae ata, itsiata naëcotavanapa. Nexata bajarapamonae tane Jesús matatoyorotsia penivenivenaejava. Tanenua Moisésbeje Elíasbeje pebarëcuaicuaijavatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Itsa baja Moisésbeje Elíasbeje Jesúsvecua ponaejitsiatsibeje, nexata bajarapaepatota Pedro jumai tsaxuabi Jesúsjavabelia: —¡Patajatuxanenë, pijacuaxae panebarëponame! Pacatoexanaenatsi acueyabi pabobërëtobeje. Itsabobërëto xamënexa tsane. Itsabobërëto Moisésnexa tsane. Itsabobërëto Elíasnexa tsane, jai Pedro. Pedro xaniavaetsia najamatabëxainaenejeva, bajarapacuenia jumaitsi. ");
INSERT INTO guh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro abaxë itsa cuaicuaijai tsanucae, itarërëbo mataacataxuabatsi daxita bajarapamonae. Jesús pijajivi najunaviaca itsa mataacataxuabatsi itarërëbo. ");
INSERT INTO guh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nexata bajarapaitarërëbojavavetsica Dioso jumaitsitsica: —Mara ponë taxënato, tasivanëje. Bajaraponë panamuxunaevere, jaitsica Dioso itarërëbojavavetsica Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Itsa baja Dioso najumevereta bajarapacuenia pejumaitsijavatsica, Jesús pijajivi tane caenë baja Jesús penucaejava bajarajota. Jesús pijajivi tae ata bajarapacuene, moya saya jinavanapa. Bajarapamonae abaxë apo tsipaebi itsamonaejavabelia, tae ata bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jesús pebarëcuaicuaijaicujinae Moisésbeje Elíasbeje, pijajivi acueyabi ponëbeje yajava, naviatsica petsutojumavetsica. Nexata mataenenatsi jivi ayaibitsaëtoxaneto. ");
INSERT INTO guh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nexata caenë bajarapajivi bitsaëtoxanetoyajuvënënë pinijijumeta jumaitsi Jesúsjavabelia: —Jesús, nitaxutotsoniataema. Netotaema taxënatonëyo. Caenëyo rabaja tsipaji xainajë. ");
INSERT INTO guh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dovathi vaetababiabatsi. Nexata jemata aëjai tsabiabi. Tëpajoneyaexanabiabatsi. Daxitanë neconecojaiya aperabëbaba tsatababiabireca. Nexata bajarajota pecuibothamu tsabiabi. Bitso bejiobiaexanabiabatsi. Dovathi abaxë apo jamatabëcopatsitsi. ");
INSERT INTO guh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Picani raja nijajivijavabelia jumaitsinë: “Panetovecuacapitsapare dovathi,” janë. Itsiata apo caëjëpaetsi tanetovecuacapitsapaenexa, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nexata Jesús jumaitsi daxita pijajivijavabelia: —¡Paxamë baja rovia apo pajumecovënëtsimë Dioso papecayavenonaejavanexa! Bajaraxuata apo pacajamatabëcuenecaëjëpae pejevaxinë panevecuacapitsapaenexa dovathi. ¡Paneajamatabëcuenetajavi baja rovia! ¿Detsa paepatojebi abaxë paxamëjavabelia ajamatabëcuenesaënë tsaponaponae tsane patanejumecovënëtsinexamë? jai Jesús daxita pijajivijavabelia. Nexata Jesús jumaitsi pejevaxinë paxajavabelia: —Barërenamëre nexënatonëyo, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ajena pejevaxinë imoxoyotabarena Jesúsjavaberena, dovathi icatsia irata xuabatsi pejevaxinë. Daxitanë aperabëbaba tsatabireca. Nexata Jesús itaveta dovathi pejevaxinë pevecuapitsapaenexatsi. Nexata baja Jesús jamatejemayaexana pejevaxinë. Tocanaviata baja pejamatejemanë paxajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Daxitajivi bitso jamatabëcuenenabenajaca Dioso pesaëta Jesús pevecuacapitsapaexae dovathi bajaraponëyo. Jivibitsaëtoxaneto Jesús jamatabëcuenebarëyaya tanetsi daxita Jesús pexanaejava yabara. Nexata Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba pijajivijavabelia. Jesús jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Xaniavaetsia panenamuxunaevere. Pëtsa panacofënëtame. Xanë, Daxitajivi Pematapijinënë, necanajetsiana itsamonae pecobeyabelia, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Itsiata baitsi jane Jesús pijajivi apo jumeyapëtae xua yabara Jesús jumaitsi. Baitsi bajarapamonae Dioso apo tocopatsitsi pejumeyapëtaeyaniva xua yabara Jesús jumaitsi. Bajarapamonae ajumeura Jesúsjavabelia peyanijobijava xua yabara Jesús jumaitsi. ");
INSERT INTO guh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesús pijajivi anaeya namutua najumenotsiaya nalivaisitanajetarubena. Najumaitsi tsanajetarubenae bajarapamonae: —¿Detsa ponë vaxaitsiyajuvënënë nacavecuaayaijamatabëcuenenë bitso? najai tsanajetarubenae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nexata Jesús pijajivi jamatabëcueneyapëtane pacuenia najamatabëxaina. Nexata Jesús cobepita pejevaxinëyo. Pemuxuneneta nuteta. ");
INSERT INTO guh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jumaitsi pijajivijavabelia: —Pajivi copiapita tanejumecovënëtsijiviyo, mapitsipejevaxinëyo ataje, xanë taniji tanecopiapitsijava. Pajivi necopiapita, ëxanë apo necopiapitsi. Ponë nitoroba, neyajavacopiapita. Nexata pëtsa bepaayaijamatabëcuenevimë panataneme. Tsipaji ponë paxamëyajuvënënë beveliajamatabëcuenenë natane paxamëvecua, bajaraponë bitso ayaijamatabëcuenenë taenatsi Dioso daxita paxamë matatoxenetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesús pijajivitonë, Juan, jumaitsi Jesúsjavabelia: —Tajatuxanenë, pataniji itsanë nevënëta dovathi jivivecua pecapitsapaejava. Itsiata bajaraponë apo paxanëyajuvënënë. Nexata paitavetajë bajaraponë dovathi jivivecua pecapitsapaponaejava, jai Juan. ");
INSERT INTO guh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nexata Jesús jumaitsi Juanjavabelia: —Pajivi pibisiajamatabëcuene apo najamatabëxainae vaxaitsijavaberena, bajarapajivi nacajamatabëcueneyavenona. Bajarapajivi bevaxaitsijamatabëcuenejivi. Bajaraxuata pëtsa baja paitavetame bajaraponë xanë tavënëta jivivecua dovathi itsa capitsapapona, jai Jesús Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Itsa baja imoxoyo pevajënae pamatacabi Jesús athëbëabetsia Dioso caponaejitsiatsi, ajamatabëcuenesaë baja peponaenexa Jerusalén tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús nexata pevajënaeyabelia pijajivitonëbeje natsivajënaeitoroba, Santiagobeje Juanbeje. Bajaraponëbeje ponabeje Samaria nacuata peecaetomarajavabelia petocovaetsinexabeje pabota picani Jesús patsijitsia. ");
INSERT INTO guh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Itsiata baitsi jane Samaria nacuapijivi apo jamatabëcopiapitsitsi Jesús. Tsipaji baja bajarapamonae yapëtane Jesús peponaejavanexa Jerusalén tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nexata Jesús pijajivitonëbeje itsa yapëtanebeje Samaria nacuapijivi Jesús apo pecopiapitsijavanexatsi, nexata jumaitsibeje Jesúsjavabelia: —Patajatuxanenë, bajayata profeta Elíaspijinë vajëta Diosojavabelia Dioso pitorobinexatsica isotocotia peverebiabinexa piajamatabëcuenebejevi. ¿Baja tsaja pitsicuene jitsipame patavajëtsinexa Diosojavabelia peveriapaenexatsi pamonae apo jitsipae pecacopiapitsijava? jaibeje Jesús pijajivitonëbeje. ");
INSERT INTO guh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nexata Jesús naëcota pijajivitonëbejejavabelia. Jumeitaveta pijajivitonëbeje. Jesús jumaitsi: —Paxamëbeje apo pajamatabëcueneyapëtaemëbeje Espíritu Santo, ponë pacayajavaponaponabeje. ");
INSERT INTO guh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Xanë, Daxitajivi Pematapijinënë, apo patsinëtsica taverebiabinexa jivi. Biji rajane patsicajë tacapanepaenexa jivi pibisiacuene pexanaeneconivecua, jai Jesús pijajivitonëbejejavabelia. Nexata baja Jesús, pijajivi yajava, pona itsatomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesús pijajivi namutua peyajavanajetarucaejavata, judíovi pecujarubinë jumaitsi Jesúsjavabelia: —Jesús, itsabelia poname, capënaponaenatsi cajena, jai judíovi pecujarubinë. ");
INSERT INTO guh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nexata Jesús jumaitsi bajaraponëjavabelia: —Itsa nepënaponaejitsipame, apo napatabiabimë tsipae tajabota nenacueraevetabiabinexa. Tsipaji tajabo apo xainaenë. Namo pijamëthëanë xaina pepatabiabinexa pemajitabiabinexanua. Baratsui ata pematapenanë xaina. Itsiata baitsi jane xanë, Daxitajivi Pematapijinënë, itsajavabelia ata apo xainaenë, itsajota nacueraevetabiabijitsianë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bajaraxuacujinae Jesús jumaitsi icatsia itsanëjavabelia: —Nepënaponare, jai Jesús. Nexata bajaraponë jumaitsi: —Tajatuxanenë, caeepatoyo abaxë necopare tamëthëtsinexa taxa petëpaenë, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús nexata jumaitsi bajaraponëjavabelia: —Copare matacabi apo pevereverecaejava apo pexainaevinexa pemëthëcaenexatsi nijamonaemi itsa tëpa. Xamë saicaya nepënaponare jivi netsipaebinexa pacuenia Dioso evetsijitsia daxita pijajivi mapanacuataje, jai Jesús bajaraponëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bajaraxuacujinae icatsia itsanë jumaitsi Jesúsjavabelia: —Tajatuxanenë, jitsipajë tacapënaponaejava. Itsiata abaxë caeepatoyo necopare tanapëjiobinexa tajabota pejinavanapaevijavabelia, jai bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nexata Jesús jumaitsi bajaraponëjavabelia: —Pajivi Dioso tonacuenebi ata, itsiata jamatabënajinabiaba pijaperujujamatabëcuene, xua exanabiaba, bajarapajivi apo caëjëpaetsi xaniavaetsia Dioso petonacuenebinexa pitorobicueniatsi. Tsipaji najamatabëcueneepatajërërëcaeya nacueneba, jai Jesús bajaraponëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jesús icatsia itsamonae itapeta pijajivinexa, setenta ponëbeje. Bajarapamonae Jesús itoroba anijanëbeje tsaponae Jesús pevajënaeya Dioso pejumelivaisi jivi petsipaebanajetarubenaenexa. Itoroba petsipaebanajetarubenaenexa daxita tomaranëjava, tsiquiritomaraxijava ata, itsaxuayo Jesús najetarucaejitsia. ");
INSERT INTO guh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús pijajivi penaropobivajënae, Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Ayaipabi pexainaenë caecuenia uba ayaijava peubijava. Nexata baja itsa tonaveretatsi peubijava, caejiviyobeje tonotatsi. Nexata notsi ata, abaxë bitso ayaijava tosajinatsi penotsinexa. Bajara pijinia itsi jivi ata Diosojavabelia penajamatabëcuenecopabivinexa. Abaxë sajina ayaibitsaëtoxaneto. Itsiata baitsi jane paxamë Dioso panetonacuenebivi pacaejiviyomëbeje saya. Bajaraxuata Diosojavabelia pavajëre icatsia Dioso pijajivi pematatsënëa itsamonae pitorobinexa papecayavenonaenexa. ");
INSERT INTO guh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Paponare baja Dioso pejumelivaisi jivi panetsipaebanajetarubenaenexa. Panayajivitaeyajinavanapaename. Pacaitorobianatsi raja bitso pibisiacuene pexanabiabivijavabelia. Pacuenia ovejaxi tsiayaitsi itsa jinavanapa pianaepanaevi nevëthë tuatuajëata, bajarapaitsimë tsane. ");
INSERT INTO guh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pëtsa pacaponame itsacuenejava ata, doro ata, palata ata, zapato ata. Itsa pabajacobianame itsajivi namutoepatota, pëtsa bajayajebi pabarëcuaicuaijamë tsanunubenae panenajematsiyaniva. ");
INSERT INTO guh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Itsa pajonejitsiamë itsamonae pijaboyalia, panejonevajënaelia copiaya pajumaitsimë tsane Diosojavabelia: “Dioso, yavenonare mapabopijivije jamatabëcuenexanepanaeya pejinavanapaenexa,” pajamë tsane copiaya Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bajarapabo pexainaenë itsa jitsipaena pejamatabëcuene xanepanaeyaexanaenexatsi Dioso, nexata bajaraponë jamatabëcuene xanepanaeyaexanaenatsi Dioso. Itsa apo muxujitsipae tsane bajarapacuenia panejumaitsijava, nexata Dioso apo jamatabëcuene xanepanaeyaexanae tsanetsi bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Itsajota papatabiabianame, caebota pamajitabiabianame. Pëtsa panatixitaponame itsaboxijavabelia. Aurajibia paxaeyabiabianamenua xua pacaabata bajarapabota. Pëtsa pauramë panexaejava papecarajutsijava yabara. Tsipaji panetsipaebixae patacaitorobilivaisi, pacarajutsiana panexaejava. Tsipaji itsajivi itsa tonacueneba itsanëjavabelia, barajutatsi pexaejava. ");
INSERT INTO guh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Itsa papatabiabianame tomarata, itsa pabota bajarapatomarapijivi xaniavaetsia pacacopiapita, nexata panaxaename xua pacaabata. ");
INSERT INTO guh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bajarapatomarata pajamatejemayaexanaename piavitanevi. Pajumaitsimë tsane bajarapatomarapijivijavabelia: “Dioso daxita pijajivi pevetsimatacabinexa, imoxoyo baja pevajënae pecopiapatsinexa,” pajamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Itsiata baitsi jane patomarata panepatsicujinae apo pacacopiapitsi tsane, bajarapatomarapijicallejavata panubenaename. Pajumaitsimë tsane bajarapatomarapijivijavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Panijatomarapijiatsapërë patataxuta rubena. Nexata panavetaxuvarëbajë. Bajarapacuenia panavetaxuvarëbajë panenayapëtaenexa Diosojavabelia panenaneconitsijava. Pananeconitame Diosojavabelia. Tsipaji apo panecopiapitsimë patanenamuxunaevetsinexamë palivaisi picani pacatsipaebijitsiatsi. Itsiata panenamuxunaevere paneyapëtaenexa mapalivaisije. Dioso daxita pijajivi pevetsimatacabinexa, imoxoyo baja pevajënae pecopiapatsinexa,” pajamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi Dioso naneconitsiaexanaena daxita pijaneconi pexainaevi, bajarapamatacabi bitso ayaicuenia Dioso naneconitsiaexanaena patomarapijivi apo pacacopiapitsi tsane. Paneconivajëtota bajayata Dioso naneconitsiaexana Sodoma tomarapijivimi, bajarapaneconivajëto matatoxenetsia Dioso naneconitsiaexanaena patomarapijivi apo pacacopiapitsi tsane, jai Jesús pijajivijavabelia, setenta ponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Icatsia Jesús jumaitsi pijajivijavabelia, setenta ponëbejejavabelia: —¡Bitso bejiobi tsane Corazín tomarapijivi! ¡Bitso bejiobi tsane Betsaida tomarapijivi ata! Pinijicuene Dioso pesaëta taexanaejavanë, xua itsajivi ata apo caëjëpaetsi pexanaenexa, bajarapatomarabejepijivi tae ata, itsiata apo nejumecovënëtsi. Apo copabi pibisiacuene pexanabiabijava. Apo najamatabëcuenepënëyorotsi Diosojavabelia. Bajayata Tiro tomarapijivimi, Sidón tomarapijivimi ata, petuatuajëta bajarapitsipinijicuene itsa tsitaexanaejitsipajë, nexata bajarapamonaemi copabijitsipa pibisiacuene pexanaejava. Najamatabëcuenepënëyorotsipa Diosojavabelia. Bajarapamonaemi nexata pibisiacuene pexanaebiabineconi bitso yajamatabëcuenebëjai tsipae. Nexata Diosojavabelia petsitanajamatabëcueneitajëtsinexa peyajamatabëcuenebëjaijava pibisiacuene pexanabiabineconi, naxatabijitsipa piayopapaëbërëjavanë. Enaejitsipa irata. Ipumana ata natsimataothocaejitsipa bitso peyajamatabëcuenebëjaixae pibisiacuene pexanabiabineconi. ");
INSERT INTO guh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Itsiata baitsi jane Corazín tomarapijivi, Betsaida tomarapijivi ata, tae ata pinijicuene Dioso pesaëta taexanaejavanë, apo nejumecovënëtsi. Nexata pamatacabi Dioso naneconitsiaexanaena daxita pijaneconi pexainaevi, bajarapamatacabi bitso ayaicuenia Dioso naneconitsiaexanaenatsi. Paneconivajëtota bajayata Dioso naneconitsiaexana Tiro tomarapijivimi, Sidón tomarapijivimi ata, bajarapaneconivajëto matatoxenetsia Dioso bitso ayaicuenia naneconitsiaexanaena Corazín tomarapijivi, Betsaida tomarapijivi ata. ");
INSERT INTO guh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum tomarapijivi picani najamatabëxaina Dioso pecaponaejavatsi athëbëabetsia. Itsiata baitsi jane bajarapamonae apo tanejumecovënëtsixae, Dioso xuabianatsi infiernojavabelia, jai Jesús Corazín tomarabeje Betsaida tomarabejepijivi yabara. ");
INSERT INTO guh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Icatsia Jesús jumaitsi pijajivijavabelia, setenta ponëbejejavabelia: —Pajivi pacanamuxunaevetsiana, bajarapajivi taenajë xanë tanenamuxunaevetsijava. Pajivi pacanayajiviitavetsiana, bajarapajivi taenajë xanë tanenayajiviitavetsijava. Bajarapajivi Dioso ata taenatsi Dioso penayajiviitavetsijava. Bajarapacuenia Dioso ata taenatsi penayajiviitavetsijava tsipaji xanë Dioso nitoroba, jai Jesús pijajivijavabelia Jesús pijajivi setenta ponëbeje pitorobivajënaeya. Nexata jane baja Jesús pijajivi naropoba. Dioso pejumelivaisi jivi tsipaebanajetarubena daxita tomaranëjava. Saicaya navecuanajetarubena anijanëbeje tsaponae. ");
INSERT INTO guh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesús pijajivi, setenta ponëbeje, Dioso pejumelivaisi jivi daxitanacuanëjava petsipaebanajetarubenaecujinae, barëyaya naviabanajetarubena Jesúsjavaberena. Nexata pepatsicujinae bajarapamonae jumaitsi Jesúsjavabelia: —Tajatuxanenë, dovathivi baja cajena itsa paitavetaponajë nevënëta, panejumecovënëtabiaba, jai bajarapamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús nexata jumaitsi pijajivijavabelia: —Xanë baja cajena taniji dovathi athëbëvetsica pejopaejavatsica pacuenia yamaxë bajopaica. ");
INSERT INTO guh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xanë baja cajena pacajamatabëcuene caëjëpaeyaexanatsi papecacaëjëpaejamatabëcuene panejamatabëcuene matatoxenetsinexa vajavajabitsaënë dovathi. Nexata jomo pacuetsacuetsanae atamë tsane, aqueto ata pacuetsacuetsanae atamë tsane, apo pacaitsacueniabi tsane. ");
INSERT INTO guh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Itsiata pëtsa bitso pasivajamatabëcuenebarëyamë dovathi itsa paitavetame papecajumecovënëtsijava. Bitso jane pasivajamatabëcuenebarëyamëre tsavanapae Dioso papijajivixaemë Dioso papecavënëyaquinarubijava athëbëtatsia, jai Jesús pijajivijavabelia, setenta ponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesús bitso jamatabëcuenebarëyayaexanatsi Espíritu Santo. Nexata Jesús jumaitsi paxa Diosojavabelia: —Axa, nevetsinë athëbëtatsia. Nevetsinë mapanacuajava ataje. “Ayaijamatabëcuenenëmë bitso,” cajaitsi. Tsipaji pamonae bitso apo penacujarubivi ata, yapëtaeyaexaname pacuenia itsamatacabi daxita nijajivi evetsijitsiamë mapanacuataje. Bajarapamonae yapëtaeyaexanaename pexanialivaisi, xanë talivaisi, palivaisi vecuamatayatame bitso peyapëtaevi mapanacuapijilivaisije. Bajarapalivaisi vecuamatayatame bitso penacujarubivi ata mapanacuapijicuene yabaraje. Bajarapacuenia exaname tsipaji baja exaname nejitsipaecuenia, jai Jesús paxa Diosojavabelia pevajëtsijavata. ");
INSERT INTO guh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Icatsia Jesús jumaitsi pijajivijavabelia, jivijavabelia ata: —Taxa Dioso baja cajena netocopata tayapëtaenexa daxitacuene. Itsajivi ata apo nejamatabëcueneyapëtae pacuenia xanë jamatabëcueneitsinë, Dioso pexënatonë. Caenë, taxa Dioso, nejamatabëcueneyapëtane. Itsajivi ata apo jamatabëcueneyapëtae pacuenia taxa Dioso jamatabëcueneitsi. Caenënë, xanë pexënatonë, jamatabëcueneyapëtaniji pacuenia taxa Dioso jamatabëcueneitsi. Pamonae tojitsipajë tayapëtaeyaexanaenexa pacuenia taxa Dioso jamatabëcueneitsi, bajarapamonae ata yapëtaeyaexanaenajë, jai Jesús pijajivijavabelia, jivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nexata Jesús napënëyorota. Ëpijajivijavabelia jumaitsi: —Paxamë baja pajamatabëcuenebarëyamë panetaexae pacuene baja pataeponame. ");
INSERT INTO guh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajayata ayaibitsaëto profetavimi necopiaevetavanapa picani tanetaenexa tapatsijavatsica. Nacuaevetsivimi ata necopiaevetavanapa picani tanetaenexa tapatsijavatsica. Itsiata netaenejeva tapatsijavatsica, bajarapamonaemi tëpa baja. Jamatabëjumetaeyabiabanua picani palivaisianë baja aeconoxae paxamë pacatsipaebaponatsi. Itsiata apo jumetaenejeva bajarapalivaisinë, bajarapamonaemi tëpa baja, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Itsamatacabi Jesús livaisi tsipaebanuca pijajivijavabelia. Nexata bajarajota judíovi pecujarubinë nonotapuna. Bajaraponë Jesúsjavabelia jamatabëcueneëjëbiaya jumaitsi: —Jesús, ¿detsa xua exanaenajë Dioso tanerajutsinexa matacabi apo pevereverecaejava? jai judíovi pecujarubinë. ");
INSERT INTO guh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nexata Jesús jumaitsi judíovi pecujarubinëjavabelia: —¿Detsa jane jumaitsi bajarapacuene yabara bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jivi pejumecovënëtsinexa? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nexata judíovi pecujarubinë jumaitsi Jesúsjavabelia: —Bajayata Dioso Moiséspijinëta penajumecopatsilivaisi jumaitsi mapacueniaje: “Daxita panejamatabëëthëtojavavetsina, daxita panejamatabëcueneta ata, daxita panesaëta ata, daxita panenajamatabëxainaesaëta ata, pasivamëre panijatuxanenë panijaDioso. Pasivamëre itsajivi ata pacuenia paxamë panijacuata panasivamë,” jai bajayata Dioso Moiséspijinëta penajumecopatsilivaisi, jai judíovi pecujarubinë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nexata icatsia Jesús jumaitsi judíovi pecujarubinëjavabelia: —Xaniavaetsia nejumecanaviatame. Bajarapacuenia exanaponaponare. Nexata pepacuene xainaename matacabi apo pevereverecaejava, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Itsiata baitsi jane judíovi pecujarubinë bijiaya jumecovënëta bajarapalivaisi. Asivaya apo tae itsamonae ata. Bajaraxuata judíovi pecujarubinë matavëjëa jumaitsi Jesúsjavabelia: —¿Detsa nexata pitsijivi asivanë tsane? jai judíovi pecujarubinë. ");
INSERT INTO guh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nexata icatsia Jesús jumaitsi judíovi pecujarubinëjavabelia mapacueniaje: —Pebi namutua najetaruca Jerusalén tomaraverena. Naropota pepatsinexa Jericó tomaraberena. Nexata jivi pecaponaejava peyacajërëbabiabivi, bajaraponë epatua vaetabatsi. Daxita pecobecovë yacajërëtatsi. Penaxatabijavanëmi ata yacajërëtatsi. Nexata pinijicuenia conibabiatsi. Puenetabuatatsi picani petëpanucaenexa bajarajota. ");
INSERT INTO guh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nexata bajarapanamutua sacerdotenë najetaruca, templobota penacuenebabiabinë. Nexata sacerdotenë bajaraponë itsa taeyabuata, matavaquetanucapona. Pona baja rovia. ");
INSERT INTO guh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bajaraxuacujinae icatsia bajarapanamutua itsanë, templobota penacuenebabiabinë, najetaruca. Bajaraponë taenucajopa. Bajaraxuacujinae matavaquetanucapona. Pona baja icatsia rovia bajaraponë ata. ");
INSERT INTO guh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bajaraxuacujinae icatsia bajarapanamutua Samaria nacuapijinë najetaruca. Nexata bajaraponë itsa taeyabuata, tsitabejiobitsi bitso. ");
INSERT INTO guh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nexata bajaraponë cujilia. Vajënëvaëba aceiterata, vinorata yajava. Vajënëcëba papaëbërëpanaxita. Bajaraxuacujinae Samaria nacuapijinë pijaburrojumata buatsia. Nexata bajaraponë capona jivi pepatabiabiboyabelia. Bajarajota Samaria nacuapijinë eveta xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Meravia pitsijavata Samaria nacuapijinë itsa baja ponaejitsia itsabelia najetaruca, juta anijapalatanëbeje, bitso penamatamotsinëbeje. Matamota bajarapabo pexainaenë. Jumaitsi bajaraponëjavabelia: “Netoevetsianame maponëje. Itsa matamovereverecaena, pematatsënëa nevetsimatamo, bajarapapalata icatsia caevëarena camatamotsianatsi,” jai Samaria nacuapijinë bo pexainaenëjavabelia, jai Jesús mapacueniaje judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bajaraxuacujinae judíovi pecujarubinëjavabelia Jesús yanijoba bajarapalivaisi yabara. Jumaitsi mapacueniaje: —Pamonae, acueyabi ponëmaxëto, taeyabuata pecobecovë peyacajërëtsinëtsi. ¿Detsa ponë bajarapamonaeyajuvënënë asivaya tane bajaraponë? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nexata judíovi pecujarubinë jumaitsi Jesúsjavabelia: —Ponë pitaxutotsoniataexae yavenona, bajaraponë asivaya tane, jai judíovi pecujarubinë Jesúsjavabelia. Nexata Jesús jumaitsi judíovi pecujarubinëjavabelia: —Ponare baja. Xamë ata bajarapacuenia asivaya itaxutotsoniataeyabiabianame itsamonae ata, jai Jesús judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús, pijajivi yajava, najetaruca pevajënaeyabelia. Nexata tomarayota pata. Bajarapatomarayota Jesús xaniavaetsia copiapitatsi petiriva, Martavënëva. Nexata Marta pijabota Jesús napata. ");
INSERT INTO guh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta pejuyapijiva xaina, Maríavënëva. Nexata María eca Jesús pitabarata penamuxunaevetecaenexa Jesús petsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nexata Marta bitso jamatabëcueneenatsi penacuenabijava, Jesús pexaejavanexa ata pemitsaexanaenexa. Nexata Marta cujilia Jesús. Jumaitsi: —Tajatuxanenë, tajuyapijiva netocopata caevanë taexanaenexa daxita xua exanaejitsianë. Itorobare taneyavenonaenexa, jai Marta Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nexata Jesús jumaitsi Martajavabelia: —Marta, xamë bitso cajamatabëcueneena nexanaenexa daxita xuanë jamatabëexaname. ");
INSERT INTO guh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Caejava bitso xanepana nexanaenexa, tanenamuxunaevetsinexamë. María baja cajena tanenamuxunaevetecaexae tatsipaebilivaisi, catsuitapeta pexaniacuene daxitacuene matatoxenetsia. Nexata acuenebi itsajivi ata peyacajërëtsijavatsi tatsipaebilivaisi pejumetaejava, jai Jesús Martajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesús vajëtabiaba Diosojavabelia. Nexata itsamatacabi, itsa baja Jesús najumevereta pevajëtsijava Diosojavabelia, Jesús pijajiviyajuvënënë jumaitsi Jesúsjavabelia: —Patajatuxanenë, panejumecujarubare pacuenia pavajëtabiabijitsianë Diosojavabelia. Pacuenia Juanpijinë jivibautisabinëmi jumecujarubabiaba pijajivi pacuenia vajëtabiabijitsia Diosojavabelia, bajara pijinia pacuenia xamë ata panejumecujarubare pavajëtabiabijitsianë Diosojavabelia, jai Jesús pijajiviyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús nexata jumaitsi pijajivijavabelia mapacueniaje: —Itsa pavajëtabiabianame Diosojavabelia, pajumaitsimë tsabiabi tsane: Taxamë, athëbëtatsia neecaenë, jitsipajë pecayaiyataejava daxitajivi. Jitsipajë naxanitsiayo pecopiapatsijava daxita nijajivi nevetsijava mapanacuataje. Jitsipajë daxitajivi mapanacuata nejitsipaecuenia pecatoexanabiabijava, pacuenia baja athëbëtatsia nijajivi nejitsipaecuenia catoexanabiaba, bajarapacuenia pecatoexanavanapaenexa mapanacuapijivi ataje. ");
INSERT INTO guh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caematacabi canacujitsia panerajure pataxaejavanexa pacuenia panamatavenonajë. ");
INSERT INTO guh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Panebarajamatabëcuene xanepanarenua nitabarata pibisiacuene pataexanaejava. Nexata panevecuaajibiaexanare pibisiacuene pataexanaeneconi. Tsipaji paxanë ata itsamonae paxanëjavaberena pibisiacuene patanexanaejava pajamatabëcuenecaevajë. Nexata pabarajamatabëcuenexanepanajë. Panevecuatsare dovathi patanejamatabëcueneëjëbiyaniva. Panecapanepare jane pibisiacuenevecua, pajamë tsane mapacueniaje itsa pavajëtabiabianame Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Icatsia Jesús pijajivijavabelia jumaitsi comparacióncuenia Jesús pijajivi peyapëtaenexa pacuenia vajëcabiabijitsia Diosojavabelia: —Paxamëyajuvënënë meravi tuatuajëta ponaejitsipa bitso peyapëtaenëtsi pijaboyabelia. Nexata jumai tsipae: “Cacovaetatsi acueyabi papanbëyobeje. ");
INSERT INTO guh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Itsanë raja, taneyapëtaenë, tajëverena peponaenë, aeconoxae tajabota netopata. Nexata bitso piajani. Itsiata xanë apo xainaenë itsacuenejavayo ata pexaejava tarajutsinexa,” jai tsipae paxamëyajuvënënë meravi tuatuajëta peyapëtaenëtsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nexata bo ënëverena bajaraponë jumepitsipatsi. Jumaitsi tsipae: “Nejamatabëitonotsipame. Baupa rabaja xaniavaetsia xatatanutajë. Taxi raja barëmajitanucajë caecamata. Nexata acuenebi tanonotapunaejava tacarajutsinexa xua nevajëtame. Itsa nonotapunaejitsipajë, yaitavabijitsipajë taxi,” jai tsipae peyapëtaenëtsi. Itsiata baitsi jane bajaraponë perajutsinexatsi ajumesaëya vajëcaponaejitsipa. ");
INSERT INTO guh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Xaniajanë pacuenia pacatsipaebijitsiatsi. Bajaraponë apo jamatabënonotapunae ata, itsiata nonotapunaejitsipa perajutsinexa pecovaebijavatsi. Itsiata peyapëtaenëxaetsi, bajarapacuenia apo rajutsi tsipae. Biji rajane rajutsipa daxita pacuenia namatavenona ajumesaëya pevajëcaponaexaetsi. ");
INSERT INTO guh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Xaniajanë pacuenia pacatsipaebijitsiatsi. Itsacuenejavayo itsa pacatonaxuabijitsipa, nexata bajayajebi ata pajaitsipame matapania panecaxitajarabijavabelianexa. Bajara pijinia pacuenia bajayajebi ata pavajëtabiabianame Diosojavabelia papecajumecovënëtsinexa. Bo ata itsa baupa xatatanuta, nexata asaëyata pabaupadocodocotsipame matapania papecatobaupatsijavabelianexa. Bajara pijinia pacuenia asaëyata pavajëtabiabianame Diosojavabelia papecajumecovënëtsinexa. ");
INSERT INTO guh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bajarapacuenia asaëyata pavajëtabiabianame Diosojavabelia. Tsipaji pajivi vajëtabiaba, rajutabiabatsi. Pajivi ata jaitabiaba, caxitajarababiaba. Pajivi ata baupa docodocotabiaba, tobaupatabiabatsi, jai Jesús pijajivijavabelia comparacióncuenia. ");
INSERT INTO guh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Icatsia Jesús jumaitsi pijajivijavabelia: —Paxamë papebijivimë, panexi panexainaevi. Panexënatonëyo itsa pacavajëta panbë, apo panacoxirajutsimë tsipae iboto. Itsa pacavajëta dujuainëyo, apo panacoxirajutsimë tsipae jomo. Itsa pacavajëta vacaratobëto, apo panacoxirajutsimë tsipae aqueto. ");
INSERT INTO guh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Paxamë paneajamatabëcuenebejevi ata, payapëtaneme panenacoxirajutsinexa pexaniajava. Paneaxa, athëbëtatsia peecaenë, bitso biji cajena pexaniajamatabëcuenenë paxamë matatoxenetsia. Bajaraponë pacarajutsiana pexaniacuene itsa pavajëtame. Bajaraponë rajutsiana Espíritu Santo daxita pamonae vajëtatsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pebi ponapona, dovathi pejamatabëcueneta apo penatsipaebinë. Nexata bajaraponë Jesús dovathi vecuacapitsapa. Pebi baja dovathi Jesús itsa vecuacapitsapa, natsipaeba baja. Jivibitsaëtoxaneto petaevi bajarapacuene, bitso jamatabëcuenenabenajaca. ");
INSERT INTO guh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Itsiata baitsi jane itsamonae fariseovi Jesús baracuaicuaijaitsi pibisiacuenia. —Maponë Jesúsje, dovathi jivivecua capitsapabiaba Beelzebú pesaëta. Beelzebú raja daxita dovathivi pepo penamatacaitorobinë, jai fariseovi jamatabëcuenenavëxaniabiaya Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Itsamonae icatsia fariseovi Jesús picani jamatabëcueneëjëbiaya itorobatsi pinijicuene Dioso pesaëta pexanaejava Jesús petsitaexanaenexa. Bajarapacuenia picani itorobatsi fariseovi peyapëtaenexa pepacuene Jesús Dioso pitorobinëcuenetsitsica. ");
INSERT INTO guh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Itsiata Jesús jamatabëcueneyapëtane pacuenia fariseovi sivanajamatabëxainatsi. Nexata fariseovijavabelia Jesús jumaitsi mapacueniaje: —Nacaenacuapijivi ata itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, nexata namataenetsia naverebiabijitsipa daxita bajarapamonae. Bajara pijinia pacuenia nacaemonae ata itsipae. Itsa navecuanatsanaejitsipa penasivanavajabitsaëtsinexa, nexata namataenetsia naverebiabijitsipa nacaemonae ata. ");
INSERT INTO guh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bajara pijinia itsipae dovathi ata. Dovathi jivivecua itsa capitsapaponaejitsipa pijajivi, dovathivi, nexata bepijavajabitsaë taejitsipa pijajivi. Itsajamatabëcuene vecuaxainaejitsipa pijajivi. Pesaë ata apo xainaponae tsipae. Mapacuenia pacatsipaebatsije tsipaji paxamë xanë yabara apo pacanaëjëtsinejevamë jamatabëcuenenavëxaniabiaya pajumaitsimë: “Jesús raja dovathi jivivecua capitsapabiaba Beelzebú pesaëta,” pajamë xanë yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Paxamë ata panijajivi dovathi jivivecua capitsapabiaba. Nexata xanë Beelzebú pesaëta dovathi jivivecua itsa capitsapabiabajë, ¿detsa nexata ponë pesaëta panijajivi ata dovathi jivivecua capitsapabiaba? Caenë rabaja Dioso pesaëta. Nexata panijajivi ata pacayapëtane bajarapacuenia jamatabëcuenenavëxaniabiaya panejumaitsijava xanë yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Espíritu Santo pesaëta xanë dovathi jivivecua capitsapabiabajë. Nexata baja picani jivi beyapëtane Dioso baja petaxuxuabijava pijajivi pevetsijava paxamë tuatuajëta, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Fariseovi pecanaëjëtsinexa Jesús bitso piasaënëcuene dovathi matatoxenetsia, Jesús icatsia comparacióncuenia jumaitsi fariseovijavabelia mapacueniaje: —Ponë bitso piasaënë, aitatsacaya pijanae cobenaevetabiabijitsipa pijabo, itsamonae peyacarëjëtsiyanivatsi pecobecovë. Nexata daxita pecobecovë xaniavaetsia tobobenaejitsipatsi, jai Jesús dovathi pijajivi pevetsijava yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Icatsia Jesús pijacuata nayabarajumaitsi mapacueniaje: —Itsiata baitsi jane itsa najetarucaejitsipa itsanë bitso piasaënë boxainaenë matatoxenetsia, nexata cueneamoneyabijitsipatsi. Aitatsacaya pijanae cobenaevetabiabi ata tsipae, itsiata vecuapitsipatsi pijanae, daxita pecobecovëjavaxi yajava, nayabarajai Jesús pijacuata comparacióncuenia dovathi pejamatabëcueneamoneyabijava yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Icatsia Jesús jumaitsi fariseovijavabelia: —Pajivi apo neyavenonaeyacaetuatsi jivi Dioso pijajivinexa, bajarapajivi betajavajabitsaëjivi. Tsipaji apo taneyavenonaeyacaetuatsixae, jivi nevecuanacayajata Dioso picani pejumecovënëtsiviminexa, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Icatsia Jesús jumaitsi fariseovijavabelia: —Dovathi itsa vejamatabëpitsapa jivitonë, nexata dovathi jinaruta petseviiranëjava. Jaitapona itsanëjavabelia petsijamatabëjonenexa dovathi penacueraevetsinexa bajaraponëjavata. Itsa apo caxitajarabi, ponëjavabelia tsijamatabëjonejitsia, nexata dovathi jamatabëjumaitsi: “Naviatsianajë meta icatsia tajabomijavabelia, paboverena pitsapajë,” jamatabëjai dovathi, ponëjavaverena pitsapa icatsia petsijamatabëjonenexatsi. ");
INSERT INTO guh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dovathi baja caevëa itsa naviarena, caxitajaraba peyajavaponaponaenëmitsi. Nexata peyajavaponaponaenëmitsi pejamatabëëthëto, dovathi tane bepënësajinecaebo, bepënëxaniavaetetsibo, bepiracajuetetsibo. ");
INSERT INTO guh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nexata dovathi icatsia sivapona peyajavapatsinexarena itsadovathivi, siete ponëbeje. Bajarapadovathivi bitso piacujirubejevi copiaya padovathi matatoxenetsia. Daxita bajarapadovathivi pebi tsijamatabëjunuatsi peyajavaponaponaenexa. Belia jane baja pebi dovathivi bitso bejiobiaexanatsi. Copiaya abaxë caenë itsa tsijamatabëecatsi pacuenia bejiobiaexanabiabatsi, matatoxenetsia bejiobiaexanatsi, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Itsa abaxë Jesús livaisi tsipaeba fariseovijavabelia, petiriva bajarapajivi bitsaëtoxanetoyajuvënëva pinijijumeta vavajai tsaxuabi. Jumaitsi Jesúsjavabelia: —¡Jamatabëcuenebarëya baja cajena ena, pecanavitaniabiva, pecavitsatsiva! jai petiriva Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nexata Jesús jumaitsi bajarapovajavabelia: —Xaniajamë rabaja. Itsiata baitsi jane pamonae jumetane Dioso pejumelivaisi, nexata itsa jumecovënëta bajarapalivaisi, bajarapamonae jane bitso jamatabëcuenebarëya tsavanapae taena matatoxenetsia, jai Jesús petirivajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jivi ayaibitsaëtoxaneto Jesús itsa matatoyorotsia nacaetuatatsi, nexata Jesús jumaitsi: —Pamonae aeconoxae jinavanapa, bitso pibisiajamatabëcuenevi. Bajarapamonae picani nitoroba Dioso pesaëta pinijicuene taexanaejava tatsitaexanaenexa, taneyapëtaenexa Dioso pepacuene athëbëvetsica taneitorobinëcuenetsica. Itsiata baitsi jane Dioso pesaëta pinijicuene taexanaejava, apo tsitaexanaenë tsane. Bajayata pacuenia Diosojumepaebinëmi profeta Jonáspijinë exanatsi, bajara ëpitsicuene taneexanaejava, tsitajëtsianajë. ");
INSERT INTO guh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bajayata daxita Nínive tomarapijivi yapëtane profeta Jonáspijinë Dioso pitorobinëcuenetsi. Tsipaji ayaicuene exanatsi Dioso. Bajara pijinia pacuenia xanë ata, Daxitajivi Pematapijinënë, pinijicuene Dioso nexanaena. Nexata daxita pamonae aeconoxae jinavanapa, neyapëtaena pepacuene Dioso athëbëvetsica taneitorobinëcuenetsica. ");
INSERT INTO guh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Itsamatacabi copiapatsiana Dioso penaneconitsiaexanaematacabinexa daxita pijaneconi pexainaevi. Bajarapamonae nubianatsi Dioso pitabarata. Nexata bajarapamatacabi bajayata povami ponapona, Saba nacuapijivimi pevetsivami, nonotapunaena. Nexata bajarapova Diosojavabelia neconitsiana pamonae aeconoxae jinavanapa, Dioso apo pejumecovënëtsivi. Bajarapova neconitsiana tsipaji bajayata bajarapovami tajë nacuatabuverena ata muxunanajetaruca pejumetaenexa Salomónpijinë, bitso daxitalivaisi peyapëtaenëmi, petsipaebilivaisi. Xanë raja majotaje ponaponajë, bitso ayaijamatabëcuenenënë Salómonpijinëmi matatoxenetsia. Itsiata baitsi jane pamonae aeconoxae jinavanapa mapanacuataje, apo nenamuxunaevetsi. Bajaraxuata ayaineconi xaina Diosojavabelia, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Icatsia Jesús jumaitsi jivi ayaibitsaëtoxanetojavabelia: —Bajayata Nínive tomarapijivi itsa jumetane Dioso pitorobilivaisi, Jonáspijinë petsipaebilivaisi, copaba pibisiacuene pexanaejava. Najamatabëcuenepënëyorota Diosojavabelia. Pamatacabi copiapatsiana Dioso penaneconitsiaexanaematacabinexa daxita pijaneconi pexainaevi, bajarapamatacabi Nínive tomarapijivimi ata nonobapunaena Diosojavabelia peneconitsinexa pamonae aeconoxae jinavanapa, Dioso apo pejumecovënëtsivi. Tsipaji xanë majota ponaponajë bitso ayaijamatabëcuenenënë Jonáspijinëmi matatoxenetsia. Itsiata baitsi jane pamonae aeconoxae jinavanapa mapanacuataje, tsipaebi atanë Dioso pejumelivaisi, apo najamatabëcuenepënëyorotsi pibisiacuene pexanaejavavecua. Bajaraxuata Dioso naneconitsiaexanaenatsi bajarapamonae, jai Jesús jivi ayaibitsaëtoxanetojavabelia tajëvelia pevajunupaebijavata itsamatacabi Dioso jivi penaneconitsiaexanaejavanexa. ");
INSERT INTO guh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Icatsia Jesús jumaitsi jivibitsaëtoxanetojavabelia: —Itsajivi ata lámparabë pitanojotsicujinae, apo mataacatetsi itsacuenejavata. Cajoniënëalia ata apo etsi lámparabë. Biji rajane athëbëyo etsia. Jivi boyaberena pejonevi tsivajënaeitayotecaejitsia. ");
INSERT INTO guh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lámparabë boënëta itayoteca xaniavaetsia vajataenexa. Bajara pijinia itsi paneitaxuto ata. Paneitaxutoxanepanaexae, xaniavaetsia panatsivajënaetaneme. Itsa paitaxutobejemë tsipae, nexata xaniavaetsia apo panatsivajënaetaemë tsipae. Pacatsitaaitaquiri saya tsipae. Bajara pijinia itsi panejamatabëcuene ata. Dioso itsa pacajamatabëcueneitayota, pajitsipaename paneexanabiabinexa pacuenia Dioso pacaitoroba. Nexata xaniavaetsia pajinavanapaename. Itsa panajamatabëxainaejitsipame bitso panexainaejava ëpaxamënexa, nexata bitso pajamatabëcueneitaquirimë tsipae. ");
INSERT INTO guh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Panayajivitaema xua panajamatabëxainabiabame, papecajamatabëcuene aitaquiriyaexanaeyaniva. ");
INSERT INTO guh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Itsa paexanavanapaename pacuenia Dioso pacaitoroba, nexata pacajamatabëcueneitayotsiana Dioso. Tsiquirijavayo ata apo aitaquiri tsane panejamatabëcuene. Nexata pacuenia lámparabë daxita boënë xaniavaetsia itayoteca pecotiata, bajara pijinia pacuenia paxamë ata pacajamatabëcueneitayotsiana Dioso, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Itsa baja Jesús najumevereta livaisi petsipaebijava, nexata fariseonë junatatsi Jesús penanabaninexa fariseonë pijabota. Jesús nexata najoneya fariseonë pijaboyalia. Naeca mesa muxuneneta penanabaninexa. ");
INSERT INTO guh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseonë itsa tane Jesús penabanijava anijatonë nacobequiatsinejeva, fariseonë jamatabëcuenenabenajaca. Pacuenia daxita judíovi pijacuenia anijatonë nacobequiatabiaba penabanivajënae, apo itsi Jesús. ");
INSERT INTO guh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nexata Jesús jumaitsi fariseovijavabelia: —Paxamë pafariseovimë panecaxaevajënae plato, taza ata, naniavelia bapaquiatame xaniavaetsia panijacuenia. Tsipaji jamatabëcuenenavëxaniabiaya pajamatabëjumaitsimë tsabiabi: “Itsa caxaejitsipajë xaniavaetsia quiatsinejevanë, Diosojavabelia naneconitsipajë,” pajamatabëjamë tsabiabi. Bajarapacuenia paquiatabiabi atamë xaniavaetsia panecaxaejavanënexa papecajamatabëcuene bijianaeyaniva picani, itsiata pananeconitaponame Diosojavabelia. Tsipaji bajarapacuenia paquiatabiabi atamë, caranata panejamatabëëthëtota panajamatabëxainabiabame pibisiacuene. Panajamatabëxainabiabame itsanë pecobecovë paneyacajërëtsinexa. Panajamatabëxainabiabamenua paneexanaenexa pibisiacuene ata. ");
INSERT INTO guh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Apo paneyapëtaevi baja rovia! Dioso cajena pexanaenë daxitacuene. Dioso baja cajena pacaperabëexana. Pacajamatabëëthëexananua. ");
INSERT INTO guh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pejanajamatabëcuene itsa paxainaejitsipame, nexata pexaniacuene patoexanabiabijitsipame itsamonaejavabelia. Daxita xua ata papecajamatabëcuene bijianaeyaniva, pajanijunavame panexaeyaniva, xua ata pacobejunavame panejayatsiyaniva, apo pacatsitapibisiacuene tsipae, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Icatsia Jesús jumaitsi fariseovijavabelia: —¡Paxamë pafariseovimë ayaineconi panatsixainame Diosojavabelia! Panenacanabijava diez xuabejeyajuvënëjava, caejavayo, parajutabiabame ofrendacuenia Diosojavabelia. Daxitaviria paneubijavaxi ata diez xuabejeyajuvënëjava, caejavayo, parajutabiabame ofrendacuenia Diosojavabelia. Xanepana baja picani bajarapacuenia panerajutabiabijava Diosojavabelia. Itsiata bajarapacuenia parajutabiabi atamë, pepacuene apo pajitsipaemë Dioso. Bajaraxuata pananeconitame Diosojavabelia. Pananeconitamenua Diosojavabelia tsipaji pacuene ata picani xanepana panetoexanabiabinexa itsamonaejavabelia, apo pasivanajamatabëxainaemë. Bajaraxua picani paxamë bepanajamatabëxainame panetoexanabiabinexa itsamonaejavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Icatsia Jesús jumaitsi fariseovijavabelia: —¡Paxamë pafariseovimë ayaineconi panatsixainame Diosojavabelia! ¡Tsipaji bepaayaijamatabëcuenevimë panataeyabiabame! Judíovi penacaetuatabiabibonëjava itsa panajoneyabiabame, pajitsipabiabame paneenaenexa peyaiyataevitsi penaenexa petsinubijavanëta. Pajitsipabiabamenua jivi papecabajacobinexa callejava bitso yaiyataeya, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Icatsia Jesús jumaitsi judíovi pecujarubivijavabelia, fariseovijavabelia ata: —¡Paxamë judíovi panecujarubivi, paxamë ata pijinia pafariseovimë, ayaineconi panatsixainame Diosojavabelia! Paxamë itajara jivi bepatsita pexaniajamatabëcuenevimë tsabiabi pibisiajamatabëcuene panexainaevi ata. Pacuenia itsamonae pona jivi pemëthëanë matatsënëa apo peyapëtaexae xua xaina bëpënëareca, bajara pijinia itsi pamonae pacayaiyatane apo peyapëtaexae pacuenia pajamatabëcuenebejemë bëpënëa. Bajarapamonae pacayaiyatane tsipaji apo yapëtae bajarapamonae bëpënëa paneajamatabëcuenebejejava, jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nexata bajarapacuenia Jesús pejumaitsijavata, judíovi pecujarubiviyajuvënënë jumaitsi Jesúsjavabelia: —Jesús, itsa mapacuenia jumaitsimëje, paxanë yabara ata pibisiacuenia jumaitsimë, jai Jesúsjavabelia judíovi pecujarubiviyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús nexata jumaitsi judíovi pecujarubinëjavabelia: —¡Paxamë ata, judíovi panecujarubivi, ayaineconi panatsixainame Diosojavabelia! Palivaisianë ayapëbeje itsajivi ata pejumecovënëtsinexa, bajarapalivaisianë jivi patsipaebabiabame pejumecovënëtsinexa. Bajarapalivaisianë patsipaebabiabi atamë itsamonae pejumecovënëtsinexa, paxamë itsiata apo panajamatabëxainaemë paneexanaenexa bajarapacuenia, jai Jesús judíovi pecujarubinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Icatsia Jesús jumaitsi judíovi pecujarubivijavabelia: —¡Paxamë judíovi panecujarubivi, ayaineconi panatsixainame Diosojavabelia! Bajayata pamatacabi jinavanapa panijasalinaivimi, beyaxuababiaba Diosojumepaebivimi profetavi. Nexata juya paxamë bajarapaprofetavimi pemëthëanëjumavereca bonë paexanajebame, jivi itsa tane bajarapabonë, penajamatabënapitabiabinexa bajarapaprofetavimi. ");
INSERT INTO guh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bajarapacuenia paneexanaexae, pacuenejëpame bajayata panijasalinaivimi pexanaecuene. Panijasalinaivi bajayata beyaxuababiaba profetavimi. Nexata juya paxamë bonë paexanajebame bajarapaprofetavimi pemëthëanëjumavereca, jai Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Icatsia Jesús jumaitsi judíovi pecujarubivijavabelia: —Bajarapacuenia paneexanaejavanexa yabara, daxitacuene Dioso peyapëtaenëxae, bajayata tajëvelia jumaitsi paxamë yabara mapacueniaje: “Bajarapamonaejavabelia toitorobianajë profetavi. Toitorobianajënua apóstolevi ata. Bajarapamonae itsiata beyaxuababiabiana tatoitorobiviyajuvënëvi. Bejiobiaexanabiabiananua tatoitorobiviyajuvënëvi,” jai baja cajena bajayata tajëvelia Dioso bajarapacuenia paxamë paneexanaejavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dioso baja cajena nacua pexanaejavaveliacujinae, panijasalinaivimi beyaxuabapona profetavimi. Nexata bajarapaneconi yajava paxamë pananeconitame Diosojavabelia. Nexata bajarapaneconi yajava Dioso pacananeconitsiaexanaena, paxamë aeconoxae mapamatacabitaje panejinavanapaevi. ");
INSERT INTO guh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Panijasalinaivimi profetavimi pebeyaxuabaponaejava, taxuxuaba Abelpijinëta. Bajaraxuacujinae icatsia pevajënaeyabelia beyaxuabapona itsaprofetavimi ata. Nexata bexëajavaberena ata icatsia panijasalinaivimi beyaxuaba Zacaríaspijinëmi. Zacaríaspijinëmi panijasalinaivimi beyaxuaba templobopanabota, baitsi templobobeje altarvënëjavabeje petuatuajëta. Xaniajanë pacuenia pacatsipaebijitsiatsi. Nexata bajarapaneconi yajava Dioso pacananeconitsiaexanaena paxamë, aeconoxae mapamatacabitaje panejinavanapaevi, jai Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Icatsia Jesús jumaitsi judíovi pecujarubivijavabelia: —¡Paxamë judíovi panecujarubivi, ayaineconi panatsixainame Diosojavabelia! “Vaxaitsi xaniavaetsia Dioso pejumelivaisi yapëtanetsi,” pajamatabëjamë tsabiabi picani. Itsiata baitsi jane apo payapëtaemë. Saicayalivaisi Dioso pejumelivaisivecua jivi patsipaebabiabame. Pacuenia bo baupaxatata jivi pejoneyaniva, bajara saya pacuenia paxamë paexaname jivijavabelia. Nexata itsamonae jitsipae ata pejonejava picani Dioso pijanacuayabetsia, paxamë saicayalivaisi panetsipaebabiabixae, apo pacopatsimë pejonenexa Dioso pijanacuayabetsia. Paxamë ata apo pajitsipaemë panejonenexa Dioso pijanacuayabetsia, jai Jesús judíovi pecujarubivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Bajarapacuenia Jesús pejumaitsicujinae, pitsapa baja bovecua. Bajaraxuacujinae judíovi pecujarubivi, fariseovi yajava, Jesús itoyatsi. Nexata jamatabëitonotabiabatsi. Jamatabëcueneëjëbiaya livaisi yanijobabiabatsi. Nexata Jesús bijiaya itsa jumecanaviata, bajarapalivaisi yabara peneconitsinexatsi picani nacuaevetsinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Penacaetuataponaejavata jivi pepo ayaibitsaëtoxaneto cajena tsaponae, baitsi miles pajivibeje. Nexata jivi nataxucuetsabataxuabapona. Nexata Jesús pijajivijavabelia copiaya tsipaeba livaisi, pejumecovënëtsiyaniva fariseovi itsa tsipaebatsi saicayalivaisi Dioso pejumelivaisivecua. Jesús pijajivijavabelia jumaitsi mapacueniaje: —Xania panayajivitaema fariseovi pijalevadurayaniva. “Levadura,” itsa janë, peyamaxëitojorobilivaisi yabara pacajumaitsitsi. Fariseovi raja bepacatsita pexaniajamatabëcuenevi itajara tsane, pibisiajamatabëcuene pexainaevi ata. ");
INSERT INTO guh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Daxita abaxë palivaisianë jivi aeconoxae apo yapëtae, bajarapalivaisianë itsamatacabi daxitajivi yapëtaeponaena xaniavaetsia. Pibisiacuene muetsia itsajivi pexanaejava ata, itsamatacabi xaniavaetsia yapëtaena daxitajivi. ");
INSERT INTO guh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Xua ata muetsia pavajunupaebame meravi, bajaraxua ata, itsamatacabi itsajivi vajunupaebiana matacabita daxitajivijavata. Xua ata pënëyatuucutsiboënëta baupa xatatsiaya muetsia vëpaxapaxajaiya pavajunupaebame, bajaraxua ata itsamatacabi itsajivi pinijijumeta vajunupaebiana jivi penacaetuatsijavata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Icatsia Jesús jumaitsi pijajivijavabelia: —Tajamonae, pacatsipaebijitsiatsi. Pëtsa pacujunavame jivibevi ata. Bajarapamonae pacabeyaxuabi ata tsipae, acuenebi matavëjëa papecaitsacueniabinexa. ");
INSERT INTO guh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Biji rajane pacatsipaebijitsiatsi panecujunavinexa Dioso. Tsipaji Dioso caëjëpatsi papecaxuabinexa infiernojavabelia papecabeyaxuabicujinae, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Icatsia Jesús jumaitsi pijajivijavabelia: —Cinco ponëbeje baratsui saya namatamota anijapalatanëyobeje. Tsipaji amatamobi. Bajarapacuenia amatamobi ata, itsiata caenëyo ata Dioso apo nacofënëtsi bajarapabaratsuiyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Paxamë rabiji bitso Dioso pacaasiva baratsui matatoxenetsia. Tsipaji panamatamotame baratsui matatoxenetsia. Dioso bitso papecaasivaxae, panematanatoxi ata, caematanatoyo canacujitsia, Dioso baja cajena namataëjëta. Bajaraxuata pëtsa pacujunavame itsacuenejava ata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacatsipaebijitsiatsi raja. Daxita pamonae tajajivi, jivi pitabarata navajunupaebiana tajajivicuene. Bajarapamonae juya xanë, Daxitajivi Pematapijinënë, vajunupaebianajë tajajivicuene Dioso pijaángelevi pitabarata. ");
INSERT INTO guh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pamonae jumai tsane itsamonaejavabelia: “Xanë cajena Jesús apo pijajivitonënë,” jai tsane, bajarapamonae yabara juya xanë, jumaitsinë tsane: “Mara pamonae cajena apo tajajivije,” janë tsane Dioso pijaángelevi pitabarata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Icatsia Jesús jumaitsi pijajivijavabelia: —Pajivi pibisiacuenia nebaracuaicuaijai ata, xanë, Daxitajivi Pematapijinënë, bajarapaneconi yabara itsa navajëta Diosojavabelia, itsiata vecuaajibiaexanaenatsi Dioso. Itsiata baitsi jane pajivi pibisiacuenia baracuaicuaijai Espíritu Santo, bajarapajivi bajarapaneconi Dioso apo vecuaajibiaexanaetsi tsane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsa pacacaponaelia tomaraevetsivijavabelia, judíovi penacaetuatabiabibojavabelia ata, papecayanijobinexa, pëtsa pajamatabëcuenebëjamë panenayajivicuaicuaijaijavanexa yabara. ");
INSERT INTO guh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tsipaji raja bajarapaepatota, Espíritu Santo pacacuaicuaijaiyaexanaena pacuenia panayajivicuaicuaijamëjitsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jivi ayaibitsaëtoxanetoyajuvënënë jumaitsi Jesúsjavabelia: —Jesús, taxapijinë picani petëpaevajënae netocopata pevënamuto tapitsinexa pecobecovëyajuvënëjavanë. Nexata tamatapijinë pita bajaraxuanë. Nexata itorobare tamatapijinë tanerajutsinexa taxapijinë tanerajutsiapaebijavanë, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús nexata jumaitsi bajaraponëjavabelia: —Itsajivi ata cajena apo nitorobi jueznënexanë, tananeconitsiaexanaenexa ponë naneconita. Itsajivi ata cajena apo nitorobi axapijinë pecobecovë patacatsicobetsatsinexabeje, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nexata icatsia Jesús jumaitsi daxitajivijavabelia: —Xania pataema. Pëtsa bitso panajamatabëxainame ëpaxamënexa ayaijava panexainaenexa. Tsipaji jivi pexainaejava ayaijava xainae ata tsipae, bajarapamonae pexainaejava yabara jamatabëcuenexanepanaeya apo jinavanapae tsipae, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nexata Jesús tsipaeba livaisi bajarapamonaejavabelia mapacueniaje: —Ponapona bitso riconë. Pijapabianë tocapitsapabiabatsi ayaijava pexainaecuene. ");
INSERT INTO guh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Riconë nexata jamatabëjumaitsi: “¿De meta pacuenia exanaenajë? Netoajibi baja rovia taetaponaejavabelianexa taubijava,” jamatabëjai riconë. ");
INSERT INTO guh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Riconë nexata icatsia jamatabëjumaitsi: “Yapëtaniji rajane baja pacuenia exanaejitsianë. Paboxita jebabiabajë taubijava, penetsianicajë taexanaenexa icatsia ayaiboxanetonë bajarapacovëta. Bajarapaboxanetonëta jane baja jebianajë daxita taubijava, daxita tacobecovë yajava. ");
INSERT INTO guh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nexata baja xainaenajë bajayajebinexa daxitacuene xua namatavenonajë. Nexata jane baja xuacujinae nacueraevetsianajë. Pexaniacuene nabanebiabianajë. Pexaniaviriaranënua matavëjëa apaeyabiabianajë taitajibinexa. Nexata barëyanë tsabiabi tsane,” jamatabëjai riconë. ");
INSERT INTO guh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nexata bajarapaepatota Dioso jumaitsi riconëjavabelia: “Apo neyapëtaenë baja rovia xamë. Ajena baja, mapameravitaje, tëpaename. ¿Jipatsa nexata nevënamuto pitsiana daxita nexaniavaetejebijavanëmi?” jai Dioso riconëjavabelia, jai Jesús mapalivaisije daxitajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Bajara pijinia pacuenia paxamëyajuvënëvi ata tocopiapatsianatsi pamonae ayaijava natocaetuatapona ëpamonae pexainaenexa. Bajarapamonae itsiata pepacuene bepejiobivi tsane Diosojavabelia, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús nexata jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pëtsa pasivanajamatabëxainame ëpanexaejava panevënajinavanapaenexa. Pëtsa pasivanajamatabëxainamenua ëpanenaxatabijavanexa ata. ");
INSERT INTO guh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Apo jinavanapaetsi cajena ëvajaxaejavanexa. Apo jinavanapaetsinua ëvajanaperabëxatabinexa. ");
INSERT INTO guh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pacanaëjëre pacuenia baratsui apo ubi pexaejavanexa. Apo notsinua penaveretaponaejava. Apo xainaenua penaveretaponaejava peetsibonexa. Itsiata Dioso rajutabiabatsi pexaejavanexa. ¡Paxamë rabiji bitsoyo Dioso pacaasiva baratsuimonae matatoxenetsia papecarajutsinexa daxita xua panamatavenoname! Bajaraxuata pëtsa pasivanajamatabëxainame ëpanexaejavanexa, ëpanenaxatabijavanexa ata. ");
INSERT INTO guh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Detsa jane ponë paxamëyajuvënënë caëjëpatsi pijacujiruta medio metrocuenia matavëjëa penavitsabiaexanaenexa? Ajibi. Bitso jamatabëbëjai ata tsipae pevitsabinexa, itsiata apo navitsabiaexanae tsipae pijacujiruta. Nexata saya najamatabëcuenecueratsipa pejamatabëcuenebëjaijava penavitsabiaexanaejavanexa. Tsipaji apo tonamatamotsitsi bajaraxua. ");
INSERT INTO guh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bajara pijinia pacatoitsi paxamë ata daxita xua pasivajamatabëcuenebëjamë. Apo pacatonamatamotsi. Bajaraxuata apo bepajamatabëcuenebëjamë itsacuenejavayo ata yabara, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacanaëjëre pacuenia bitso pexaniamatono pitsapa, mapamatonoje. Bajarapamatono apo natsijumanacuenebi. Penaxatatsijavanexa ata apo natoexanae. Bajayata nacuaevetsinë Salomónpijinë bitso pexainaenëmi. Naitabëtsiaya naxatababiaba bitso pexaniaviriajavanë. Itsiata baitsi jane Salomónpijinë penaitabëtsijava matatoxenetsia bitso aitabë mapamatonotoxije. ");
INSERT INTO guh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Paxamë, bevelia Dioso panejumecovënëtsivi, asaëya bepajumecovënëtame Dioso papecaevetsijava. Ajena pitsijavata vayafota tanetsi pexaniaponamatanotoxi. Bajaraxuacujinae, caematacabibejecujinae, tajuatsi baja bajarapaponamatonotoximi. Pacuenia Dioso aitabëyaexana ponamatonotoxi, bajara pijinia pacuenia paxamë ata itsamatacabi Dioso pacaxatabiana piaitabëjava. ");
INSERT INTO guh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bajaraxuata pëtsa pasivanajamatabëxainavanapame ëpanexaejavanexa, ëpanematavëjëaapaejavanexa ata. Biji rajane pajumecovënëtavanapare Dioso. ");
INSERT INTO guh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pamonae Dioso apo pejumecovënëtsivi, bitso sivanajamatabëxainabiaba ëpexaejavanexa, ëpenaxatabijavanexa ata. Itsiata baitsi jane paneaxa Dioso paxainame. Bajaraponë yapëtane daxita xua panamatavenoname. ");
INSERT INTO guh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bajaraxuata, daxita xua panamatavenoname, matatoxenetsia Dioso pijacuene bitso pasivanajamatabëxainabiabianame Dioso pijacuene panetoexanavanapaenexa. Nexata Dioso pacarajutsiana daxita xua panamatavenoname, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Icatsia Jesús jumaitsi pijajivijavabelia: —Tajamonae, paxamë patajajivimë pacaejiviyomëbeje ata, pëtsa pajunavame. Tsipaji paneaxa pacaitapeta panecobenaevetsinexa pamatacabi bajaraponë evetsiana daxitacuene. ");
INSERT INTO guh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pacanajere panexainaeyajuvënëjava, bitso paneasivajava ata. Nexata bajarapapalata parajutsianame bitso bepejiobivijavabelia. Nexata juya Dioso athëbëtatsia pacarajutsiana bitso penamatamotsijava, apo pevereverecaejava. Bajarajotatsia acuenebi pejonejava penacobetoxotsivi papecayacajërëtsinexa. Itsanë ata ajibi papecatoucubaxaenënexa. ");
INSERT INTO guh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Panacuatatsia pacatoxaniavaeta panexainaejavanexa, bajarapanacua panejamatabëëthëtovetsina pajamatabënajinavanapaename, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús icatsia pepatsijavanexatsica tajëvelia navajunupaeba. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Icatsia raja jemata patsianicajë. Nexata najamatabëcuenexaniavaetsiaya panecopiaevetavanapaename. ");
INSERT INTO guh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Payapëtaneme rabaja mapacueneje. Petuxanenë itsa pona penacasabifiestajavabelia, pijajivi tonajumecopata meravijebi ata pecopiaevetavanapaenexatsi pepatsijavarena. Nexata petuxanenë pijajivi meravi ata copiaevetavanapatsi. Nexata petuxanenë jemata meravi najetarucae ata, baupa itsa docodocota, nexata bajarapamonae bepijia tobaupata pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bajarapamonae barëya pijatuxanenë naëcotsiaya pecopiaevetavanapaejavata pepatsixae. Xaniajanë pacuenia pacatsipaebijitsiatsi. Nexata petuxanenë pijajivi caecuenia petobaupatsixaetsi, petuxanenë pijajivi sivajamatabëcuenebarëya. Nexata petuxanenë pepatsicujinae xaniavaeta mesa. Enaeyaexanaena pijajivi. Nexata caranata petuxanenë bajarapamonae bepijajivitonë nataeya rajuta pexaejava pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Meravi tuatuajëta petuxanenë patsi ata, itsa jume, matacabivëpata patsi ata, nexata petuxanenë pijajivi naëcotsiaya pecopiaevetavanapaejavata pijatuxanenë pecaxitajarabixaetsi, petuxanenë pijajivi barëya. ");
INSERT INTO guh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pacanaëjëre mapacueneje. Bo pexainaenë itsa yapëtaejitsipa paepatota meravi pijabojavaberena patsijitsia pecobecovë petonacobetoxotsinënexatsi, nexata apo majitsi tsipae. Vajënaeevetecaejitsipa meravijebi. Apo copatsi tsipae pijaboyaberena petojoneyanivatsi penacobetoxotsinënexa. ");
INSERT INTO guh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bajara pijinia pacuenia paxamë ata najamatabëcuenexaniavaetsiaya panecopiaevetavanapaename tapatsijavatsica. Tsipaji xanë, Daxitajivi Pematapijinënë, paepatota apo panejamatabënajinaemë tapatsijavanexatsica, jemata icatsia patsianicajë, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro jumaitsi Jesúsjavabelia: —Tajatuxanenë, ¿palivaisi aeconoxae panetsipaebame, baja tsaja palivaisi ëpaxanë panijajivinexanë? Itsa jume, ¿itsamonaenexa ata tsaja yajava? jai Pedro. ");
INSERT INTO guh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús nexata jumaitsi Pedrojavabelia: —Mara pejamatabëcueneitsivinexa yabara pacatsipaebatsije. Petuxanenë pijajivitonë, ponë xaniavaetsia pijatuxanenë pecovëta tonacuenebaponapona pijacuene, maitsije. Petuxanenë pijajivitonë itsajamatabëcuene xainaenejeva, copiaevetaponapona pijatuxanenë pepatsimatacabijavabelianexa. Bajaraponë pijatuxanenë pijajivi pecovëta toevetaponapona xaniavaetsia. Toabataponapona pexaejava caematacabi canacujitsia pacuenia itorobatsi pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bajaraponë bitso barëya pamatacabi pijatuxanenë pata xaniavaetsia pijajivi pecovëta petoevetaponaponaexae. ");
INSERT INTO guh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xaniajanë pacuenia pacatsipaebijitsiatsi. Ponë bajarapacuenia xaniavaetsia tonacueneba pijatuxanenë pecovëta, bajaraponë icatsia evetsiaexanatsi daxita xua xaina pijatuxanenë. ");
INSERT INTO guh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Petuxanenë pijajivitonë itsa piajamatabëcuenebejenë tsipae, nexata bajaraponë pijatuxanenë pecovëta jamatabëjumai tsipae: “Tajatuxanenë ajibi tsarucae tsane bajayajebi,” jamatabëjai tsipae. Nexata pijatuxanenë pijajivi, pamonae evetsiaexanatsi xaniavaetsia picani petoevetsinexa, toconibabeyabiabijitsipa. Conibabeyabiabijitsipa pebijivi, petiriavi ata. Bajaraponë ayaijava pexaejava xaeyabiabijitsipa. Aitajibinua tsabiabi tsipae. ");
INSERT INTO guh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nexata itsajota apo jamatabënajinae tsipae pijatuxanenë pepatsijavanexa, bajarapaepatota jemata patsipa pijatuxanenë. Nexata bajaraponë pijatuxanenë pinijicuenia naneconitsiaexanaejitsipatsi. Bajara pijinia pacuenia Dioso ata itsamatacabi pinijicuenia naneconitsiaexanaena pamonae Dioso apo pejumecovënëtsivi, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Icatsia Jesús jumaitsi pijajivijavabelia: —Ponë itsanë pijajivitonë, yapëtae ata picani pacuenia itorobatsi pijatuxanenë petoexanaenexa, itsiata itsa apo toexanae pijatuxanenë pitorobicueniatsi, bajaraponë pinijicuenia jumaconibabejitsipatsi ayaicuerobocotota. ");
INSERT INTO guh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ponë ata pijinia itsanë pijajivitonë, itsa apo jumeyapëtae xaniavaetsia petoexanaenexa pacuenia pijatuxanenë itorobatsi, nexata pijatuxanenë pitorobicueniatsi saicayacuenia itsa toexana, bajaraponë ata jumaconibabejitsipatsi. Itsiata pinijicuenia apo jumaconibabe tsipaetsi. Pajivi pijinia ayaijava rajutatsi, bajarapajivi yabara vaxaitsi basivajamatabëjumaitsitsi: “Juya meta mapajivije ayaijava rajutabiabiana itsamonaejavabelia,” basivajamatabëjaitsi. Pajivi pijinia evetsiaexanatsi ayaijava, bajarapajivi pevetsiaexanaenëtsi sivajamatabëjumaitsitsi: “Itsa netocanacuenebiana taevetsiaexanaejava, ayaijava netopitsapaena,” sivajamatabëjaitsi pevetsiaexanaenëtsi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Icatsia Jesús jumaitsi pijajivijavabelia: —Xanë raja patajopajë daxitanacuapijivi pibisiacuene pexanaeneconi yabara tasivatëpaenexa. Nexata bajarapamonaeyajuvënëvi itsamonae nejumecovënëtsiana. Nexata nacaemonae ata apo najamatabëcuenejëpae tsane. Itsa baja capanepaeya cruzata daxitajivi sivatëpaejitsipajë, jamatabëcuenebarëyanë baja tsipae. ");
INSERT INTO guh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Itsiata baitsi jane abaxë netosajina bajaraxua yabara tanejamatabëcueneëjëtsinexa tanebeyaxuabijavata. ¡Bitso baja rovia najamatabëxainajë! ¡Matapania nebeyaxuabiana, jamatabëcuenecaevianajë! ");
INSERT INTO guh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pëtsa panesivajamatabëjumaitsimë mapacueniaje: “Jesús rabaja patsica mapanacuayabetsicaje daxitajivi mapanacuataje najamatabëcuenejëpaeya pejinavanapaeyaexanaenexa,” panesivajamatabëjamë pëtsa. Bajaraxuanexa apo patsinëtsica. Biji rajane xanë tapatsixaetsica mapanacuayabetsicaje, jivi itsa nejumecovënëtsiana, apo najamatabëcuenejëpae tsane pamonaejavabelia apo nejumecovënëtsi, nacaemonae ata. Itsamonae napijavajabitsaë tsane. Nexata apo najamatabëcuenejëpae tsane. ");
INSERT INTO guh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ajena mapamatacabijavaveliacujinaeje jivi apo najamatabëcuenejëpae tsane. Cinco pajivibeje, nacaemonae ata, caebota pejinavanapaevi ata, apo najamatabëcuenejëpae tsane xanë apo tanenajuajumecovënëtsixaebeje. Pamonae cinco pajivibeje nacaemonae, bajarapamonaeyajuvënëvi, acueyabi pajivibeje, nejumecovënëtsiana. Anijajivibeje apo nejumecovënëtsi tsane. Itsa jume, anijajivibeje nejumecovënëtsiana. Acueyabi pajivibeje apo nejumecovënëtsi tsane. ");
INSERT INTO guh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bajarapabopijivi, paxabeje pexënatobeje, apo najamatabëcuenejëpaebeje tsane xanë apo tanenajuajumecovënëtsixaebeje. Petirivabeje pijinia, penabeje pexënatoyobeje ata, apo najamatabëcuenejëpaebeje tsane xanë apo tanenajuajumecovënëtsixaebeje. Pamebeje pecopenabeje ata apo najamatabëcuenejëpaebeje tsane xanë apo tanenajuajumecovënënëtsixaebeje, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús icatsia jumaitsi jivi ayaibitsaëtoxanetojavabelia: —Itsa pataneme vaëvetsica itarërëbo pepitsapaejava, nexata pajumaitsimë tsabiabi: “Ajena raja emajitsia,” pajamë tsabiabi. Nexata bajarapamatacabi ema jopabiaba. ");
INSERT INTO guh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Itsa pataneme jovibo pepitsapaejava epatajërëtsiarena la surverena, pajumaitsimë tsabiabi: “Ajena raja icotia ataju tsane,” pajamë tsabiabi. Nexata bajarapamatacabi icotia ataju tsabiabi. ");
INSERT INTO guh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nexata itsamonae pacatane bepatsita pexaniajamatabëcuenevimë itajara, papibisiajamatabëcuenevi atamë. Payapëtaeyabiabame pacuenia matacabi itsijitsia itarërëbo pepitsapaejava panetaeyabiabixae. Bajarapacuenia picani payapëtaeyabiabame. Itsiata baitsi jane patae atamë daxita xua Juanpijinëmi jivibautisabinëmi exanapona, patae atamënua daxita xua xanë ata exanaponajë, caranata xanë apo paneyapëtaemë Dioso athëbëvetsica taneitorobinëcuenetsica, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús icatsia jumaitsi jivi ayaibitsaëtoxanetojavabelia: —Pacanaëjëre panijacuata paneexanaenexa pacuene xanepana. ");
INSERT INTO guh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Itsa pananeconitame itsajivijavabelia, nexata itsa pacacapona bajarapajivi jueznëjavabelia papecaneconitsinexa, namutua xaniavaetsia panabarëcuaicuaijamërebeje panenasivajamatabë xanepanaenexabeje xua yabara pacaneconitsijitsia. Bajarapacuenia xaniavaetsia panabarëcuaicuaijamërebeje papecanutsiyaniva jueznë pitabarata. Tsipaji raja jueznë itorobijitsipa policíavi panijaneconi yabara papecacaponaenexa penaneconitsivi pejebabiabiboyabelia. Nexata policíavi pacananeconitsiaexanetsipa penaneconitsivi pejebabiabibota. ");
INSERT INTO guh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Xaniajanë pacuenia pacatsipaebijitsiatsi. Nexata penaneconitsivi pejebabiabibota itsa pacananeconitsiaexanetsipa, bajaraverena bepijia apo papitsapaemë tsipae. Matapania pamatamotsipame daxita xua yabara pacananeconitsiaexaneta, papitsapaejitsipame, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Itsamonae jumaitsi Jesúsjavabelia: —Galilea nacuaverena pepatsivi, baca beyaxuaba Jerusalén tomarata templobota. Bajarapamonae baca beyaxuaba ofrendacuenia pevi perajutsinexa Diosojavabelia. Nexata bajarapaepatota nacuaevetsinë Pilato pibisiacuene exana. Itoroba vajabitsaë Galilea nacuapijivimi pebeyejebinexatsi templobota. Itsajota Galilea nacuapijivimi baca beyaxuababuata, bajarapacovëta icatsia beyejebatsi bajarapamonaemi. Nexata bajarapamonaemi pijana namatajërëata bacajana yajava, jai itsamonae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús nexata jumaitsi bajarapamonaejavabelia: —“Pamonaemi bajarapacuenia beyejebatsi, bitso meta pibisiacuene pexanaevimi daxita pijanacuapijivi matatoxenetsia. Bajaraxuata beyejebatsi penaxuabinexa Diosovecua,” ¿pajamatabëjamë tsaja? ");
INSERT INTO guh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jume baja cajena. Bajarapamonaemi ata picani bitso pibisiacuene apo exanae pijanacuapijivi matatoxenetsia. Itsiata Dioso tocopatatsi bajarapamonaemi pebeyejebinexatsi, penacopabivi pecanaëjëtsinexa Diosojavabelia penaneconitsijava. Paxamë ata itsa apo pacopabimë tsane pibisiacuene peneexanabiabijava, itsa apo panajamatabëcuenepënëyorotsimë tsane Diosojavabelia, nexata bajarapacuenia paxamë ata panaxuabianame Diosovecua itsa patëpaename. ");
INSERT INTO guh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pamatacabi ata jemata Jerusalén tomarata jopanucaya athëbëabetsia piapiabotsia, Torre de Siloévënëbo, dieciocho pajivibeje matacënëbatsi. Nexata baja tëpa bajarapamonaemi. “Pamonaemi matacënëbatsi, pibisiacuene meta bitso pexanaevimi daxita Jerusalén tomarapijivi matatoxenetsia. Bajaraxuata matacënëbatsi penaxuabinexa Diosovecua,” ¿pajamatabëjamë tsaja? ");
INSERT INTO guh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jume baja cajena. Bajarapamonaemi ata picani bitso pibisiacuene apo exanae pijatomarapijivi matatoxenetsia. Paxamë ata itsa apo pacopabinë tsane pibisiacuene paneexanaejava, itsa apo panajamatabëcuenepënëyorotsimë tsane Diosojavabelia, nexata daxita paxamë ata bajarapacuenia panaxuabianame Diosovecua itsa patëpaename, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús jivi livaisi tsipaeba piacuaijibihigueranae pelivaisicuenia. Jesús jivi piacuaijibihigueranae pelivaisicuenia petsipaebijavata, pijaperujujamatabëcuene apo penavecuacopatsivi yabara Jesús jumaitsi mapacueniaje: —Pebi pijapabi tuatuajëta caenae peubinae xainanuta, higueravënënae. Nexata picani taeyojopalia bajaraponae penacuaitsijava. Itsiata baitsi jane apo nacuaitsi. ");
INSERT INTO guh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nexata jumaitsi pijapabi petoevetsinëtsijavabelia: “Taema maponaeje. Acueyabi picani pavaibeje taeyopajë tacuainotabiabinexa maponaecuaije. Itsiata acuaijibi tsabiabi. Nexata baja netonicataxuare. Apo becopatanutsitsi bajaraponae. Ira caranatanuca saya,” jai pijapabi pexainaenë. ");
INSERT INTO guh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Itsiata baitsi jane pijapabi petoevetsinëtsi jumaitsi: “Copatanutsianatsibeje abaxë mapavaije. Nexata bacatuirabianajë bacatasitoxita. ");
INSERT INTO guh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Baja raeta xuacujinae xanepanaena. Nexata aeconoxae pavai nacuaitsiana. Nexata aeconoxae pavai ata itsa apo nacuaitsi tsane, nexata jane baja catonicataxuabianatsi,” jai pijapabi petoevetsinëtsi, jai Jesús. Bajarapacuenia Jesús jumaitsi tsipaji Dioso xuabijitsia pamonae pijaperujujamatabëcuene apo pecopatsivi. ");
INSERT INTO guh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Itsamatacabi judíovi penacueraevetsimatacabita, Jesús jivi livaisi tsipaeba judíovi penacaetuatabiabibota. ");
INSERT INTO guh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Bajarajota naeca petiriva. Dovathi pejamatabëcueneta bajarapova dieciocho pavaibeje xaina penajumafurutsicujinae. Nexata apo caëjëpaetsi tsiquirijavayo ata penaepasirovitsijava. ");
INSERT INTO guh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Itsa Jesús taeyeta bajarapova, nexata junarena. Jesús jumaitsi bajarapovajavabelia: —Niatanejavami rabaja cavecuaajibi, jai Jesús bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús tsimatanacobebuata bajarapova. Nexata bajarajota petiriva naepasirovitsixanepana baja. Nexata bajarapova jumai tsaponae Diosojavabelia: —¡Diosomë, bitso pexaniacuene netoexaname ayaijamatabëcuenenëxaemë! jai tsaponae bajarapova Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Itsiata baitsi jane judíovi penacaetuatabiabibo pevetsinë Jesús baraanaepanatsi judíovi penacueraevetsimatacabita Jesús pejamatejemayaexanaexae penajumafurutsiva. Tsipaji judíovi apo jitsipae itsajivi ata itsacuenejavayo pexanaenexa penacueraevetsimatacabita. Nexata judíovi penacaetuatabiabibo pevetsinë jamatabëjumaitsi: —Jesús nacueneba penacueraevetsimatacabita. Jesús apo jumecovënëtsi patajasalinaivi patanitavetsicuene, jamatabëjai. Nexata judíovi penacaetuatabiabibo pevetsinë najumejematsiaya jumaitsi jivijavabelia: —Caesemana canacujitsia xainaponatsi seis pamatacabibeje vajanacuenebinexa. Bajarapamatacabijava bepatatsi vajanacajamatejemayaexanaenexa. Nexata abaxë penacueraevetsimatacabita apo bepatsitsi vajanacajamatejemayaexanaenexa, jai judíovi penacaetuatabiabibo pevetsinë najumejematsiaya jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nexata Jesús jumaitsi judíovi penacaetuatabiabibo pevetsinëjavabelia: —Paxamë saya jivi paneyamaxëitojorobivi. Bepatsita pexaniajamatabëcuenevimë itajara itsamonae, papibisiajamatabëcuenevi atamë. Paxamë ata panacuenebabiabame penacueraevetsimatacabita ata. Paxamë penacueraevetsimatacabita ata panijabaca, burro ata, paisinabiabame panecaponaenexa merajavabelia mera piapaenexa. ");
INSERT INTO guh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mapovaje Abrahampijinë pemomoxiyajuvënëva jamatejemayaexanajë. Tsipaji bajarapova namatamota Dioso pitabarata dajubinë matatoxenetsia. Dovathi pejamatabëcueneta penajumafurutsicujinae, xaina baja dieciocho pavaibeje. Bajaraxuata penacueraevetsimatacabita ata jamatejemayaexanajë piatanecuenevecua, jai Jesús judíovi penacaetuatabiabibo pevetsinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bajarapacuenia Jesús itsa jumaitsi, nexata daxita pecueneitoyavitsi moya ena. Aura tsenae bajarapamonae. Itsamonae pijinia Jesús sivajamatabëcuenebarëyatsi pinijicuene Dioso pesaëta pexanaponaejavanë yabara. ");
INSERT INTO guh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús jumaitsi jivijavabelia: —¿De meta xua pelivaisi jëpa Dioso pijajivi bepijia ayaibitsaëtoxaneto penaexanaejavanexa? Jivi meta peyapëtaenexa ayaibitsaëtoxaneto bepijia Dioso pijajivi penaexanaejavanexa, mostazaxutoyo meta pelivaisicuenia tsipaebianajë. ");
INSERT INTO guh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pebi capona mostazaxutoyo peubinexa pijapabita. Nexata baja mostazaxutoyo pebi itsa uba pijapabita, bajarajota mostazanae bepijia vitsaba. Bepijia baja mostazanae pinijinae naexana. Baratsui ata exana pematapenanë bajaraponaemaxëranaxijava. Bajara pijinia pacuenia Dioso pijajivi ata itsane. Bepijia ayaibitsaëtoxaneto naexanaena Dioso pijajivi, jai Jesús jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Icatsia Jesús jumaitsi jivijavabelia: —¿De meta palivaisi jëpa pecacaëjëpaejava Dioso pijajivi pevetsicuene daxitanacuanëjava? ¿De meta pacuenia jivi livaisi tsipaebianajë peyapëtaenexa Dioso pijajivi pevetsicuene peyacaëjëpaejava daxitanacuanëjava? ");
INSERT INTO guh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levaduravënëjava meta pelivaisicuenia tsipaebianajë. Petiriva pan pexanaenexa, acueyabi patarrobeje trigobenonë matajërëaba levaduravënëjavata. Nexata pan pexanaematabënexa, ayaimatabë. ");
INSERT INTO guh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús jivi livaisi tsipaebanajetaruca pinijitomaranëjava, tsiquiritomaraxijava ata, pepatsinexa Jerusalén tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nexata Jesús jivi livaisi petsipaebijavata, itsanë yanijobatsi Jesús. Bajaraponë jumaitsi Jesúsjavabelia: —Jesús, ¿Dioso tsaja capanepaena caebitsaëtoyo saya? jai. Nexata Jesús jumaitsi daxita jivijavabelia: ");
INSERT INTO guh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Xaniajanë pacuenia pacatsipaebijitsiatsi. Pajamatabëcuenesaëmëre bitso panevajënaeyabelia itsamatacabi athëbëtatsia panejonenexa tsiquiribaupayojavalia. Jivi picani itsamatacabi athëbëtatsia ayaibitsaëtoxaneto jamatabëjonena tsiquiribaupayojavalia. Itsiata apo caëjëpaetsi tsane pejonenexa. ");
INSERT INTO guh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bo pexainaenë itsa nonotapunaena baupa pexatatsinexa, paxamë bo jumapënëvelia panubenaename. Nexata picani panejonenexa pabaupadocodocotsianame. Pajumaitsimë tsane: “Tajatuxanenë, panetobaupare,” pajamë tsane. Itsiata bajaraponë pacajumaitsi tsane: “Apo pacayapëtaetsi cajena paxamë. Itsaverena ata papatame, apo yapëtaenë,” pacajai tsane. ");
INSERT INTO guh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nexata paxamë pajumaitsimë tsane: “Xamë baja cajena panebarënabaneme. Panebarëmatavëjëaapamenua. Patajatomaranëjava ata baja cajena jivi livaisi tsipaebabiabame,” pajamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Itsiata bajaraponë pacajumaitsi tsane: “Apo pacayapëtaetsi cajena paxamë. Itsaverena ata papatame, apo yapëtaenë. Pibisiacuene paneexanabiabivi, panevecuaponare baja,” pacajai tsane. ");
INSERT INTO guh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dioso pijanacuatatsia pataename Abrahampijinë, Isaacpijinë ata, Jacobpijinë ata, daxita Diosojumepaebivimi profetavi ata. Daxita bajarapamonae penajuajinavanapaejava Dioso pijanacuatatsia pataename. Nexata paxamë bajarajota pinijicuenia panatsinuename. Panavonosinianamenua bitso paneanaepanaexae. Tsipaji paxamë Dioso pijanacuavecua panenaxuabinexa pacaxuabiana infiernojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Itsaviriajumevi patsiana daxitanacuanëjavaverena. Nexata daxita bajarapamonae naenaena penabaninexa Dioso pijanacuatatsia. ");
INSERT INTO guh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pamonae aeconoxae mapamatacabitaje ayaijamatabëcuenevi tanetsi, bajarapamonaeyajuvënëvi, ayaibitsaëtoxaneto, itsamatacabi Dioso beveliajamatabëcuenevi exanaenatsi. Pamonae pijinia mapamatacabitaje beveliajamatabëcuenevi tanetsi, bajarapamonaeyajuvënëvi, ayaibitsaëtoxaneto, itsamatacabi Dioso ayaijamatabëcuenevi exanaenatsi, jai Jesús daxitajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Itsa baja Jesús najumevereta jivi livaisi petsipaebijava, fariseovi pata Jesúsjavaberena. Nexata fariseovi jumaitsi Jesúsjavabelia: —Jesús, mapatomara baja vecuaponareje. Nacuaevetsinë raja Herodes cabeyaxuabiapaeba, jai fariseovi. ");
INSERT INTO guh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús nexata jumaitsi fariseovijavabelia: —Paponaremelia. Bajaraponë Herodes, jivi peyamaxëitojorobabiabinëjavabelia, pajumaitsimë tsane mapacueniaje: “Jesús raja jumaitsi: ‘Ajena raja abaxë, meravia ata icatsia, vecuacapitsapaponaenajë dovathi peyajavajinavanapaevi. Piavitanevi ata jamatejemayaexanaponaenajë. Nexata abaxë pameravia bajarapacuenia taexanaejava copatsianajë,’ jai raja Jesús,” pajamë tsane Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Diosojumepaebivimi profetavimi beyejebabiabatsi Jerusalén tomarata. Tsipaji profetavi acuenebi saicayatomarata petëpaejava Jerusalén tomaravecua. Bajaraxuata xanë ata ponaenajë tavajënaeyabelia Jerusalén tomarabelia. Nexata ponaenajë ajena. Itsa jume, meravia, pameravia ata, tanebeyaxuabinexa Jerusalén tomarata, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nexata Jesús najamatabëxainaeya sivanua Jerusalén tomarapijivi. Jerusalén tomarapijivi Jesús najamatabëxainaeya pesivanuejavata, jumaitsi mapacueniaje: —¡PaJerusalén tomarapijivimë, pabeyajebabiabame Diosojumepaebivimi profetavi! ¡Ibotonëta ata patseconabiabame bajarapacuenia panebeyaxuababiabinexa Diosojumelivaisi pecaponaevi paxamëjavaberena! ¡Pacuenia vacara banacoxicaetuata pecorofetobëxëpanaberena, bajara pijinia pacuenia xanë ata picani bitso jitsipabiabajë patacacaetuatsinexa, patacacapanepaenexa picani panijaneconivecua! ¡Itsiata baitsi jane paxamë apo pajejamë cajena! ");
INSERT INTO guh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Panejumetaema. Dioso rabaja pacacopata papecaevetabiabijavami. Nexata baja panijatemplobota Dioso apo ponaponae. Xaniajanë pacuenia pacatsipaebijitsiatsi. Paxamë baja apo panetaemë tsane matavëjëa. Matapania itsa panejumecovënëtame Cristonëcuenenë, Dioso taneitorobinëtsica, icatsia panetaename. Itsa panesivajamatabëjumaitsimënua tsane: “Dioso, bitso yavenonare maponë najetarucaje. Bajaraponë nejamatabëcueneta najetaruca,” itsa panesivajamatabëjamë tsane, nexata jane baja icatsia panetaename itsa patsianicajë, jai Jesús mapacueniaje najamatabëxainaeya pesivanuejavata Jerusalén tomarapijivi. ");
INSERT INTO guh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Itsamatacabi, judíovi penacueraevetsimatacabita, Jesús pona fariseovi penamatacaitorobinë pijaboyabelia penanabaninexa. Nexata bajarapabota itsamonae fariseovi Jesús naitaxutocaevetatsi. ");
INSERT INTO guh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nexata Jesús pitabarata eca pebi, daxitanë peyajinaenë. ");
INSERT INTO guh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús nexata jumaitsi judíovi pecujarubivijavabelia, fariseovijavabelia ata: —¿Penacueraevetsimatacabita ata tsaja piavitanevi vajajamatejemayaexanaenexa, Dioso nacatocopata? Jume. ¿Apo nacatocopatsi tsaja? jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Itsiata bajarapamonae moya ena. Nexata Jesús cobepita peyajinaenë. Jamatejemayaexana baja. Itoroba baja peponaenexa bajarapabovecua. ");
INSERT INTO guh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesús nexata jumaitsi judíovi pecujarubivijavabelia, fariseovijavabelia ata: —Itsa panijaburro, panijabaca ata, pacatojopaejitsipareca meramëthëareca, nexata penacueraevetsimatacabita ata, bepijia pajutarëcëpaejitsipame. ¿Baja tsabaitsi jane? jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nexata bajarapamonae acuenebi pejumecanaviatsijava Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseonë pijabota Jesús tane fariseonë pejunatsivi. Bajarapamonae natsiitapeta peyaiyataevitsi penaenexa petsinubijavanëta penaenexa mesa muxuneneta. Nexata Jesús muxujioba bajarapamonae beveliajamatabëcuenevi penataenexa. Jesús jumaitsi daxitajivijavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Itsa pacajunata panenanabaninexa penacasabifiestajavabelia, pëtsa panatsiitapetame paneenaenexa peyaiyataevitsi penaenexa petsinubijavanëta. Tsipaji itsanë ayaijamatabëcuenenë paxamë matatoxenetsia itsa najunatatsi, napatsipa. ");
INSERT INTO guh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nexata papecajunatsinë pacacujitsiparena. Nexata pacajumai tsipae: “Tocopare bajaraxua maponë peecaenexaje,” pacajai tsipae. Nexata paxamë pauramë tsipae itsa pacanatixitsiaexana paneecaenexa beveliajamatabëcuenevi penaenexa petsinubijavanëta. ");
INSERT INTO guh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Itsa pacajunata, paenaename beveliajamatabëcuenevi penaenexa petsinubijavanëta. Matapania papecajunatsinë itsa pacajumai tsane: “Natixiremena. Peyaiyataevitsi penaenexa tatsinubijavanëta ecare,” itsa pacajai tsane, paenaename bajaraxuanëta. Nexata bajarapacuenia daxita mesa muxuneneta panenajuaenaevi pacataena papecayaiyataejava papecajunatsinë. ");
INSERT INTO guh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pajivi ayaijamatabëcuenejivi natane, bajarapajivi beveliajamatabëcuenejivi taenatsi Dioso. Pajivi pijinia beveliajamatabëcuenejivi natane, bajarapajivi ayaijamatabëcuenejivi taenatsi Dioso, jai Jesús judíovi pecujarubivijavabelia, fariseovijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nexata Jesús icatsia jumaitsi pejunatsifariseonëtsijavabelia: —Itsa junatame itsamonae nebarënabaninexa nijabota matonejepijijava, itsa jume, caniviyopijijava ata, pëtsa junatame ëneyapëtaevi. Pëtsa junatame nebarënabaninexa ënijamonae. Pëtsa junatame ënijamonaeviriavi ata. Pëtsa junatame ëricovi, pamonae nijabo muxuneneta jinavanapa. Tsipaji bajarapamonae juya canamatamojunatsipa pijabota pecabarënabaninexa. Nexata bajarapacuenia canamatamotsipa bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Itsa junatame itsamonae fiesta nebarëexanaenexa, junatsianame bepejiobivi, penabejenaevi ata, pejayujayunaevi ata, bitso pitaxutotsëcënaevi ata. ");
INSERT INTO guh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nexata bajarapacuenia pepacuene jamatabëcuenebarëyamë tsane. Tsipaji bajarapitsivi acuenebi juya pecanamatamojunatsijava tsane. Nexata nijamatamo xainaename pamatacabi icatsia Dioso asaëyaexanaena pamonae tëpa, pexaniajamatabëcuenevimi, jai Jesús pejunatsifariseonëtsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Daxita mesa muxuneneta penaevi jumetane Jesús petsipaebilivaisi. Nexata fariseoviyajuvënënë jumaitsi Jesúsjavabelia: —Jamatabëcuenebarëya tsane pajivi nanabaniana Dioso pijanacuatatsia, jai fariseoviyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nexata fariseovi peyapëtaenexa itsamonae Dioso apo pejumecovënëtsijava, junatsi atatsi, Jesús jumaitsi comparacióncuenia mapacueniaje: —Fiesta pexanaenë pijajivi itoroba ayaijava pexaejava pexanaenexa. Nexata tajëvelia junatsiaexana jivi ayaibitsaëtoxaneto petopatsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bajaraxuacujinae pexaejava baja itsa vereta, fiesta pexanaenë itoroba pijajivitonë peponaenexa pejunatsivijavabelia: “Naxanitsia baja. Pexaejava rabaja vereta,” pejainexa. ");
INSERT INTO guh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Itsiata baitsi jane daxita pejunatsivi apo topatsitsirena. Itsanë saya peponaeyaniva, pijajivitonëta tonajumeitorobarenatsi pejumaitsilivaisi mapacueniaje: “Xanë aeconoxaeta comuatabajë ira. Nexata ponaejitsianë bajarabelia tataenexa bajarapaira. Pexaniacuene netoexanaename. Pëtsa jamatabëcueneanaepaname xanëjavaberena,” pejailivaisi tonajumeitorobarenatsi pijajivitonëta. ");
INSERT INTO guh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Itsanë pijinia saya peponaeyaniva, pijajivitonëta tonajumeitorobarenatsi pejumaitsilivaisi mapacueniaje: “Xanë comuatajë diez ponëbeje bueyu tanetoroborobocaevinexa. Nexata ponaejitsianë taëjëtsinexa bajarapabueyu. Pexaniacuene netoexanaename. Pëtsa jamatabëcueneanaepaname xanëjavaberena,” pejailivaisi tonajumeitorobarenatsi pijajivitonëta. ");
INSERT INTO guh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Itsanë pijinia saya peponaeyaniva, pijajivitonëta tonajumeitorobarenatsi pejumaitsilivaisi mapacueniaje: “Xanë raja aeconoxaeta nacasabajë. Bajaraxuata acuenebi taponaejava,” pejailivaisi tonajumeitorobarenatsi pijajivitonëta. Bajarapacuenia daxita pamonae picani fiesta pexanaenë junata, peponaeyaniva saya tonajumeitorobarenatsi pijajivitonëta. ");
INSERT INTO guh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nexata fiesta pexanaenë pijajivitonë naviarena pijatuxanenëjavaberena. Tsipaeba pijatuxanenëjavabelia daxita pacuenia najumerubatsi. Nexata fiesta pexanaenë anaepana. Jumaitsi pijajivitonëjavabelia: “Naxanitsiayo liamëre tomarabelia. Junatanajetarucaename jivi pinijicallexanetonëjava, tsiquiricallexijava ata. Junatsianame bepejiobivi, penabejenaevi ata, pejayujayunaevi ata, bitso pitaxutotsëcënaevi ata, penanabaninexa tajabota,” jai fiesta pexanaenë pijajivitonëjavabelia. Nexata baja pijajivitonë pona pejunatsinexa jivi. ");
INSERT INTO guh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jivi pebarëpatsicujinaerena, jumaitsi pijatuxanenëjavabelia: “Tajatuxanenë, exanajë rabaja taneitorobicueniamë. Itsiata abaxë sajinanubena itsamesanë itsamonaenexa,” jai bajaraponë pijatuxanenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nexata petuxanenë icatsia jumaitsi pijajivitonëjavabelia: “Liamëre icatsia carreteranëjavabelia, namutonëjavabelia ata. Junatanajetarucaename asaëyata carreterajava peponaevi, namutojava ata peponaevi, penanabaninexa tajabota pevënëcaenexa tajabo. ");
INSERT INTO guh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pamonae picani copiata junatajë penanabaninexa, caenë ata bajarapamonaeyajuvënënë, apo naxae tsane bajarapapexaejava,” jai petuxanenë pijajivitonëjavabelia, jai Jesús fariseoviyajuvënënëjavabelia jivi peyapëtaenexa itsamonae Dioso apo pejumecovënëtsijava, junatsi atatsi. ");
INSERT INTO guh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jivibitsaëtoxaneto Jesús pënajinavanapatsi. Nexata Jesús napënëyorota bajarapamonaejavabelia. Jesús jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ponë xanëjavaberena patsi ata, itsiata itsa apo niasiva tsane daxita pijamonae matatoxenetsia, nexata bajaraponë apo tajajivitonë tsane. Bajaraponë itsa apo niasiva tsane paxa, pena ata, pematapijivi ata, pejuyapijivi ata, piasivajava matatoxenetsia, nexata apo tajajivitonë tsane. Bajaraponë itsa apo niasiva tsane pijava, pexi ata, pijacuata penaasivajava ata, matatoxenetsia, nexata bajaraponë apo tajajivitonë tsane. ");
INSERT INTO guh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ponë xanë yabara itsamonae jamatabëpebeyaxuabixaetsi, jamatabëpebejiobiaexanaexaetsinua, nexata pecajunavi itsa apo nepënaponae tsane, bajaraponë apo tajajivitonë tsane. ");
INSERT INTO guh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Paxamëyajuvënënë itsa jamatabëexana bo, athëbëabetsia piapiaboxanetotsia, nexata copiaya najamatabëcueneveretsipa pacuenia exanaejitsia. “¿Netocaëjëpa tsamëra baja tajapalatata taveretsinexa tajabo?” jamatabëjai tsipae copiaya. ");
INSERT INTO guh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itsa apo najamatabëcueneveretsi tsipae copiaya, nexata bo pexanaejava taxuxuabi ata, apo veretsi tsipae itsa apo tocaëjëpaetsi pijapalata. Nexata pijabo petotaevitsi, capocaponaejitsipatsi. ");
INSERT INTO guh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Baracuaicuaijaitsi tsipae: “Bajaraponë picani taxuxuaba pijabo pexanaejava. Itsiata apo tocaëjëpaetsi pijapalata peveretsinexa pijabo,” jaitsi tsipae capocaponaeya petotaevitsi. ");
INSERT INTO guh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nacuaevetsinë pijinia, itsanacuaverena itsa sivanavajabitsaëtsijitsiatsi, nexata copiaya najamatabëxainaejitsipa. Jamatabëjumaitsi tsipae mapacueniaje: “Tajajivi saya diez mil ponëbeje. Tanebarëtsimaxëponaevinexa, veinte mil ponëbeje. ¿Baja tsamëra tajajivi nebarëcuenecaëjëpaena tabarëbenexa tajavajabitsaënë pijajivi, veinte mil ponëbejejavabelia?” jamatabëjai tsipae copiaya. ");
INSERT INTO guh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nexata bajarapacuenia penajamatabëxainaecujinae, bajaraponë yapëtaejitsipa apo pebarëcuenecaëjëpaejavatsi pebarëbenexa pijavajabitsaënë pijajivijavabelia. Itsa abaxë tajë pevajënae pepatsijavarena pijavajabitsaënë, nexata najumexuabijitsipalia pijajivita penabarajamatabëcuene xanepanaenexabeje vajabitsaëcuene pexanaeyanivabeje. ");
INSERT INTO guh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bajara pijinia pacuenia paxamëyajuvënëvi ata itsa apo najamatabëcueneveretsi copiaya penajamatabëcuenepënëyorotsinexa daxita pexainaejavavecua, nexata acuenebi tajajivi taexanaenexa, jai Jesús jivi ayaibitsaëtoxanetojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesús icatsia comparacióncuenia jumaitsi jivi ayaibitsaëtoxanetojavabelia mapacueniaje: —Yajo abaxë itsa xaica, xanepana. Itsiata yajo pexaicaejavami itsa ajibi tsipae, ¿detsa pacuenia icatsia naxaicaeyaexanaejitsipa? Acuenebi. ");
INSERT INTO guh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Itsacuenejavayonexa ata baja apo xanepanae tsipae. Nexata peubijava petsibacaothocaenexa ata, apo xanepanae tsipae. Tsipaji pacuenia peubijava petsibacaothocaebeno, itsa tsibacaothoca, peubijava naxaniabiaexana, bajara apo itsi tsipae bajarapayajomi. Pacuenia bacatasi ata itsa tsibacaothoca, peubijava naxaniabiaexana, bajara apo itsi tsipae bajarapayajomi. Nexata saya jema xuabijitsipa bajarapayajomi. Pajivi jamatabënejumeyapëtane patacatsipaebilivaisi, nenamuxunaevetsi xaniavaetsia, jai Jesús comparacióncuenia bajarapamonaejavabelia. Bajarapacuenia Jesús jumaitsi comparacióncuenia jivi peyapëtaenexa pacuenia jamatabëcueneitsipae Jesús pijajivitonë itsa copatsipa Jesús pejumecovënëtsijavami. Nexata Diosovecua naxuabijitsipa. ");
INSERT INTO guh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi, pata Jesúsjavaberena. Yajavaparenanua piajamatabëcuenebejevi. Bajarapamonae pata penamuxunaevetsinexa Jesús petsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nexata fariseovibeje judíovi pecujarubivibeje itsa tane gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi pepatsijava Jesúsjavaberena, itsa tanenua piajamatabëcuenebejevi ata pepatsijava Jesúsjavaberena, nexata fariseovibeje judíovi pecujarubivibeje Jesús baracuaicuaijaitsi. Bajarapamonae najumaitsi mapacueniaje: —Mara ponëje naneconita Diosojavabelia. Tsipaji copiapitabiaba piajamatabëcuenebejevi ata. Naxaeyabiabanua pexaejava bajarapamonaeta, najai fariseovibeje judíovi pecujarubivibeje Jesús yabara jamatabëcuenenavëxaniabiaya. ");
INSERT INTO guh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nexata Jesús pebaracuaicuaijaixaetsi, Jesús bajarapamonaejavabelia livaisi tsipaeba mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Paxamëyajuvënënë xainaejitsipa cien ponëbeje oveja. Nexata itsa toyajuvënënaxuabijitsipatsi caenë, oveja pexainaenë petusatota puenetsipa noventa y nueve ponëbeje. Nexata jaitsipa petonaxuabinëtsi matapania pecaxitajarabijavabelianexa. ");
INSERT INTO guh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nexata oveja pexainaenë itsa baja caxitajarabijitsipa petonaxuabinëmitsi, barëyataejitsipa. Boyaberena vëtacarapatsipa petonaxuabinëmitsi. ");
INSERT INTO guh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nexata oveja pexainaenë petonaxuabinëmitsi itsa capatsipa boyaberena, junatsipa peyapëtaevitsi. Junatsipa pijabo muxuneneta imoxoyo penaevi ata. Nexata oveja pexainaenë jumai tsipae bajarapamonaejavabelia: “Panecobenabarëyamëre. Tsipaji tajaovejayo, tanetonaxuabinëyomi picani, caxitajarabajë baja,” jai tsipae oveja pexainaenë bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapanacuataje Dioso pitabarata pijaneconi pexainaejivi ata, itsa copatsiana pibisiacuene pexanabiabijava, itsa najamatabëcuenepënëyorota Diosojavabelia, bajara pijinia pacuenia sivabarëyatsi tsane athëbëtatsia pejinavanapaevi. Bajarapajivi, athëbëtatsia pejinavanapaevi, sivabarëyatsi tsane noventa y nueve pajivibeje Dioso pitabarata pianeconijibitsavanapaevi pesivabarëyatsabiabijava matatoxenetsia, jai Jesús fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Icatsia Jesús jumaitsi fariseovijavabelia, judíovi pecujarubivijavabelia ata: —Petiriva xainaejitsipa diez ponëbeje palatanëanë, bitso penamatamotsinëanë. Nexata itsa toyajuvënënaxuabijitsipatsi caenë, itanojotsipa lámpara. Bo ira cajuetsipa xaniavaetsia pejaitsinexa. Matapania itsa pitabuatsipa petonaxuabipalatanëtsi, copatsipa pejaitsijava. ");
INSERT INTO guh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Itsa baja caxitajarabijitsipa petonaxuabipalatanëmitsi, nexata junatsipa peyapëtaevitsi. Junatsipa pijabo muxuneneta imoxoyo penaevi ata. Bajarapova nexata jumai tsipae bajarapamonaejavabelia: “Panecobenabarëyamëre. Tsipaji tajapalatanëyo, tanetonaxuabinëyomi picani, caxitajarabajë baja,” jai tsipae petiriva bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pajivi copatsiana pibisiacuene pexanabiabijavami, itsa najamatabëcuenepënëyorotsiananua Diosojavabelia, bajara pijinia pacuenia athëbëtatsia ángelevi sivabarëyatsi tsane, jai Jesús fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Icatsia Jesús livaisi tsipaeba fariseovijavabelia, judíovi pecujarubivijavabelia ata. Jesús jumaitsi mapacueniaje: —Pebi xaina anijanëbeje pexënatobeje. ");
INSERT INTO guh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nexata juyapijinë jumaitsi paxajavabelia: “Axa, xuanë picani netocopatame tapitsinexa nevënamuto, bajaraxuanë abaxë apo tëpae atamë, nerajure baja tajajavanexa,” jai juyapijinë. Nexata pexënatobeje pexainaenë pexënatobejejavabelia rajuta daxita pexainaejavanëmi. ");
INSERT INTO guh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nexata paxa perajutsicujinaetsibeje, caematacabibejecujinae, juyapijinë canajeta daxita pexainaejavanëmi pecaetuatsinexa palata. Bajaraxuacujinae jane baja pona tajënacuayabelia. Bajarajotalia pibisiacuene exanaponapona. Nexata vereta daxita paxa perajutsijavanëmitsi. ");
INSERT INTO guh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nexata daxita bajarapanacuapijivi janibocuene tsipatatsi. Bajaraponë peveretsicujinae daxita pijapalatami, bitso namatavenona pexaejava. ");
INSERT INTO guh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nexata jaita penacuenebinexa bajarapanacuata peecaenëjavabelia. Bajaraponë itorobatsi pijairanëjava petoevetaponaponaenexa pijamarrano. ");
INSERT INTO guh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nexata bajaraponë bitso piajanixae, pepenenexa picani ayaijava jamatabëxaeyabiaba bopocuai, marrano pexaeyabiabijava. Bajarajota itsajivi ata apo rajutsitsi pexaejavanexa. ");
INSERT INTO guh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nexata belia bajaraponë xaniavaetsia najamatabëxaina. Jamatabëjumaitsi mapacueniaje: “Taxa pijabota pexaejava ayaijava xaina pijajivi ayaibitsaëto piabatsinexa. Tonacopatabiabatsi ayaijava pexaejava. Itsiata xanë majotaje tëpaejitsianë baja tajani. ");
INSERT INTO guh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nexata taxajavabelia naviatsianajë. Jumaitsinë meta tsane taxajavabelia: ‘Axa, pibisiacuene exanajë Diosojavabelia, xamëjavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Abejenë raja. Auranë baja rovia xamëjavabelia: “Taxënato,” tanejamëjava. Nexata saya nijajivitonënë nexanare,’ janë meta tsane taxajavabelia,” jamatabëjai juyapijinë. ");
INSERT INTO guh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nexata baja naviata paxajavabelia. ’Itsa abaxë tajëverena najetaruca, pexënato pexainaenë copiatane. Nexata bajaraponë pexënato itaxutobejiobiatane. Mataenetsia cujinaejinalia pexënato. Nacoxivaetabarucapona. Copiapitsiaya itabaratsutsunexuaba pexënato. ");
INSERT INTO guh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nexata bajaraponë jumaitsi paxajavabelia: “Axa, pibisiacuene raja exanajë Diosojavabelia, xamëjavabelia ata. Abejenë raja. Nexata baja rovia auranë xamëjavabelia: ‘Taxënato,’ tanejamëjava,” jai paxajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Itsiata baitsi jane pexënato pexainaenë bajarajota jumaitsi pijajivijavabelia: “Naxanitsia. Bepijiayo taxënato patocaponaremena daxita matatoxenetsia pexaniapana, penajumaxuabipana. Pajumaacare bajarapapanata. Anillonua pacobesixatare. Zapatonua pataxuxatare. ");
INSERT INTO guh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Penasitsinë becerro papiremelia. Pabeyaxuabianame vajaxaenexa. ¡Fiesta exanaenatsi vajabarëyanexa! ");
INSERT INTO guh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tsipaji raja maponë taxënatoje: ‘Tëpa meta baja,’ sivajamatabëjanë picani. Itsiata tsaena ponapona. ‘Naxuaba meta baja,’ sivajamatabëjanë picani. Itsiata baja icatsia patajopa,” jai pexënato pexainaenë pijajivijavabelia. Nexata taxuxuaba fiesta pexanaejava. ");
INSERT INTO guh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Bajarapamatacabi matapijinë pabiabelia nacuenebaponapona. Nexata penaviatsinë bo itsa imoxoyotanajetaruca, jumetane música. Jumetanenua peyavajibijava. ");
INSERT INTO guh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nexata bajaraponë junata paxa pijajiviyajuvënënë. Jumaitsi: “¿Detsa pitsicuene yabara fiesta paexaname?” jai matapijinë. ");
INSERT INTO guh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nexata paxa pijajivitonë jumaitsi: “Nejuyapijinë baitsi patajopa. Axa nexata paneitoroba patabeyaxuabinexa becerro, penasitsinë. Jamatejema tsaena ponapona nejuyapijinë,” jai bajaraponë matapijinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nexata matapijinë bitso anaepana. Apo jitsipae boyabelia pejonejava. Nexata paxa sivapitsaparenatsi. Jumaitsi pexënatojavabelia: “Naxanitsia. Najonemeya,” jai pexënatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nexata matapijinë jumaitsi paxajavabelia: “Jume. Bajayajebi baja rovia catonacuenebaponaponatsi xanë. Caeto ata cajena apo cajumeapajejaitsi. Itsiata baitsi jane caeto ata apo nerajutsimë chivoyo ata fiesta tabarëexanaenexa tayapëtaevi. ");
INSERT INTO guh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Itsiata aeconoxae patajopa baja nexënato, ponë vereta nijapalatami petiriavijavabelia. Nexata tobeyaxuabame becerro, penasitsinë,” jai matapijinë paxajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nexata bajaraponë jumaitsi pexënatojavabelia: “Taxënato, xamë cajena xanëjavata ponaponame daxitamatacabi. Nexata daxita xua taxainaejava nijajava baja cajena. ");
INSERT INTO guh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Itsiata aeconoxae namatavenonatsi vajabarëyanexa. Tsipaji nejuyapijinë: ‘Tëpa meta baja,’ tasivajamatabëjainëmi, itsiata tsaena asaë. Penaxuabaponaponaenëmi icatsia baja patajopa,” jai bajaraponë pexënatojavabelia, jai Jesús mapalivaisije fariseovijavabelia, judíovi pecujarubivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús pijajivijavabelia livaisi tsipaeba. Jumaitsi mapacueniaje: —Petuxanenë, bitso pexainaenë, ponapona. Bajaraponë xaina pijajivitonë petoevetsinexatsi pecobecovë. Itsiata pepëya pijajivitonë pecobecovë toveretaponatsi. Nexata itsamonae tsipaebatsi pepëya pijajivitonë pecobecovë petoveretaponaejavatsi. ");
INSERT INTO guh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nexata petuxanenë pijajivitonë junata. Jumaitsi pijajivitonëjavabelia: “Xamë pina tapëya netoveretaponame tacaevetsiaexanaejava. Pabaxutojavabelia matamoyaquinarubame xuanë canajetaponame tacobecovë, xuanënua netocomuataponame, bajarapabaxuto netocanaviatsianame. Nexata baja itsa netocanaviatsianame bajarapabaxuto, matavëjëa apo netoevetsimë tsane tacobecovë,” jai petuxanenë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nexata pijajivitonë sivapona bajarapabaxuto petocanaviatsinexa pijatuxanenë. Nexata bajarapabaxuto petocanaviatsivajënae jamatabëjumaitsi: “¿De tsaeta xua exanaenajë? Tajatuxanenë baja necapitsapaejitsia pecobecovë tatoevetaponaponaejavavecua. Apo necaëjëpae tsane tanacuenebinexa pabi tajacuata tanaevetsinexa. Bitso auranënua tsipae itsamonaejavabelia amoneya tavajëtaponaenexa palata tanamitsacomuatabiabinexa taxaejava. ");
INSERT INTO guh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Taneamoneyabivi meta abaxë, xua niamoneyaba, bevelia tovënëjonaponaenajë. Nexata tajatuxanenë tanecapitsapaecujinae, bajarapamonae pijaboyabelia itsa ponaenajë, xaniavaetsia necopiapitsiana. Nexata bajarapamonaejavata naponaponaenajë,” jamatabëjai bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nexata bajaraponë junata daxita pamonae abaxë amoneyabatsi. Nexata pamonae amoneyabatsi, bajarapamonae, caenë canacujitsia, patapona bajaraponëjavaberena. Nexata bajaraponë copiaya petopatsinëtsijavabelia jumaitsi: “¿Detsa pacuenia niamoneyabame abaxë, xua tajatuxanenë pijajava catsicopatatsi? jai bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nexata ponë amoneyabatsi, jumaitsi: “Camoneyabatsi abaxë tacarajutsinexa aceiteranë ochocientos pagalónbeje,” jai. Nexata bajaraponë jumaitsi piamoneyabinëtsijavabelia: “Bevelia saya catocopatsianatsi. Mara picani pacuenia niamoneyabameje, tanetoitanerubibaxutotamëje. Pire cajena. Icatsia itsabaxutojavabelia saya cuatrocientos pagalónbejenexa bepijia yaquinarure. Nexata saya bajarapacuenia tajatuxanenë rajutsianame,” jai bajaraponë piamoneyabinëtsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bajaraxuacujinae icatsia itsanë topatatsi. Nexata icatsia jumaitsi bajaraponëjavabelia: “¿Jica xamë? ¿Detsa pacuenia niamoneyabame?” jai. Nexata bajaraponë jumaitsi: “Camoneyabatsi abaxë tacarajutsinexa cien pabultobeje trigoxubultonë,” jai. Nexata bajaraponë jumaitsi piamoneyabinëtsijavabelia: “Mara picani pacuenia niamoneyabameje, tanetoitanerubibaxutotamëje. Pire cajena. Icatsia itsabaxutojavabelia saya ochenta pabultobejenexa yaquinarure. Nexata saya bajarapacuenia tajatuxanenë rajutsianame,” jai bajaraponë piamoneyabinëtsijavabelia. Bajarapacuenia exanapona daxita piamoneyabivitsijavabelia pesivajamatabëcuene xanepanaenexatsi, xaniavaetsia pecopiapitsinexatsi pijabota penaponaponaenexa, pijatuxanenë itsa navecuacapitsapatsi. Nexata jane baja daxita piamoneyabivitsi tocanaviabatsi. Bevelia matamota petoyaitanetuarutaponae baxutonëtsi. ");
INSERT INTO guh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bajaraxuacujinae pijatuxanenëjavabelia pona perajutsinexa jane baja bajarapabaxutonë. Nexata pijatuxanenë jumaitsitsi: “Xamë baja rovia pibisiacuene exaname. Itsiata baitsi jane niaitatsacaxae, exaname pacuenia catoxanepanaejitsia nevajënaeyabelia,” jaitsi pijatuxanenë. Nexata pacuenia pijatuxanenë pepëya pecobecovë petocanajetabiabinë ajamatabëcueneitatsaca, bajara pijinia pacuenia Dioso apo pejumecovënëtsivi ajamatabëcueneitatsaca Dioso pejumecovënëtsivi matatoxenetsia mapanacuapijicuene yabaraje, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacamuxujiobatsi xaniavaetsia. Mapanacuapijipalatata payavenonare itsamonae. Nexata pacuenia pijatuxanenë pecobecovë petoevetsinë, pesivajamatabëcuene xanepanaevitsi xaina, xaniavaetsia pecopiapitsinexatsi pijabota penaponaponaenexa pijatuxanenë pecapitsapaecujinaetsi, bajara pijinia pacuenia paxamë ata athëbëtatsia paxainaename papecasivajamatabëcuene xanepaenaevi. Nexata pamatacabi patëpame, itsajota apo panamatavenonaemë palata, Dioso pacacopiapitsiana apo pevereverecaebonëjavatatsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Icatsia Jesús jumaitsi pijajivijavabelia: —Pajivi xaniavaetsia toeveta tsiquirijavayo ata itsanë pecobecovë, bajarapajivi xaniavaetsia toevetsipa ayaijava ata. Pajivi bijiaya toeveta tsiquirijavayo ata itsanë pecobecovë, bajarapajivi bijiaya toevetsipa ayaijava ata. ");
INSERT INTO guh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Itsanë pecobecovë, mapanacuapijicueneje, palata ata, xaniavaetsia itsa apo patoevetsimë tsipae, nexata itsajivi ata apo pacaevetsiaexanae tsipae Dioso pijacuene, xua bitso namatamota mapanacuapijicuene matatoxenetsiaje. ");
INSERT INTO guh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Itsa xaniavaetsia apo patoevetsimë tsipae itsanë pecobecovë, nexata pitsijava picani pacaevetsiaexana, bajarapitsijava itsajivi ata apo pacarajutsi tsipae pepo panijajavanexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Icatsia Jesús jumaitsi pijajivijavabelia: —Itsajivi ata acuenebi caecuenia petonacuenebijava anijanëbeje pijatuxanenëbeje. Caenëjavabelia jitsipaejitsipa petonacuenebijava. Itsanëjavabelia apo jitsipae tsipae petonacuenebijava. Bajara pijinia itsi pajivi bitso jitsipa Dioso. Pajivi bitso jitsipa Dioso, nexata itsa tonacueneba Dioso, acuenebi bitso pejitsipaejava palata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseovi, bitso palata pejitsipaevi, jumetaeyena Jesús petsipaebilivaisi pijajivijavabelia. Nexata fariseovi jumecapocaponatsi Jesús. ");
INSERT INTO guh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús nexata jumaitsi fariseovijavabelia: —Paxamë pajitsipabiabame jivi pejumaitsinexa paxamë yabara: “Fariseovi raja pexaniajamatabëcuenevi,” pejainexa. Itsiata baitsi jane Dioso pacajamatabëcueneyapëtane pexaniajamatabëcuene apo panexainaevicuene. Pacuene bitso jivi tsitapexaniacuenetsi, bajarapacuene Dioso apo tsitapexaniacuenetsi, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Icatsia Jesús jumaitsi fariseovijavabelia: —Juanpijinë jivibautisabinëmi pepatsivajënaeya, jivi xaina Dioso Moiséspijinëta penajumecopatsilivaisi pejumecovënëtsinexa. Bajayata Diosojumepaebivi profetavi ata petsipaebilivaisianë ata, xaina jivi pejumecovënëtsinexa. Itsiata Juanpijinë pepatsicujinae, pexanialivaisi tsipaebaponajë. Tsipaebaponajë Dioso pijajivi pevetsijavanexa. Nexata daxitajivi bitso jitsipa penajonenexa Dioso pijanacuayabetsia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Icatsia Jesús jumaitsi fariseovijavabelia: —Mapanacuaje, itaboxo yajava, jemata vereverecaena. Itsiata baitsi jane palivaisi Dioso Moiséspijinëta najumecopata, bajarapacuenia apo vereverecae tsane. Nexata daxita pacuene yabara tajëvelia vajunupaeba bajarapalivaisita, pepacuene xaniajai tsane, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Icatsia Jesús jumaitsi fariseovijavabelia: —Ponë pijava xuaba, nexata icatsia itsava itsa pita, bajaraponë pibisiacuene exana pevitota. Nexata naneconita Diosojavabelia. Tsipaji pepo pijavavecua jaita itsava. Dioso cajena abaxë bajaraponë pexuabiva pepo pijavacuenia totanetsi. Ponë ata itsanë pexuabiva pita, bajaraponë ata pibisiacuene exana pevitota. Nexata naneconita Diosojavabelia. Tsipaji itsanë pijava yacajërëta, pova abaxë Dioso tanetsi itsanë pepo pijavacuenia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Icatsia Jesús livaisi tsipaeba fariseovijavabelia. Jesús jumaitsi mapacueniaje: —Bitso pexainaenë, riconë, ponapona. Daxitamatacabi naxatababiaba bitso pexaniaviriajavanë. Pexaejava, pexaniaviriajava, xaeyabiaba. ");
INSERT INTO guh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Riconë pijabo matatoyorotsia yacaranata ibopanaxanetonë mataropotsia pefaratsijavaxanetota. Nexata bajarapacaranatsijavaxaneto jumavelia baupa muxuneneta, bepejiobinë, Lázarovënënë, boquecabiaba. Lázaro daxitanë perabëtsabana. ");
INSERT INTO guh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro picani jamatabëxaeyabiaba riconë pexaeyabiabijavata piothopaepërë mesa bëxëpanareca. Avirixi ata patabiaba itsajota Lázaro bocabiaba. Petsabanaejava raebabiabatsi. ");
INSERT INTO guh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nexata baja belia Lázaro tëpa. Petëpaecujinae Lázaro ángelevi caponayatsi Dioso pijanacuayabetsia, itsabetsia Abrahampijinë petëpaecujinae ponapona. Bajaraxuacujinae riconë ata tëpa. Mëthëtatsi. ");
INSERT INTO guh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Riconëmi petëpaecujinae pata petëpaevi pepatabiabinacuayabelia. Nexata bajarapanacuata riconëmi bitso navixaetaeya bejiobi tsaponaponae. Nexata riconëmi athëbëa benaëcotsia. Tajëtatsia taenuta Abraham penucaejava. Lázaro nucaya Abraham pemuxunenetatsia. ");
INSERT INTO guh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nexata riconëmi vavajai. Jumaitsi Abrahamjavabelia: “Amo Abraham, nitaxutotsoniataema. Netoitorobimica Lázaro. Nacobeupijabutsi merata neebarëtocainejebiaexanaejitsia. Bitso jamatabëfaenajë mapatajutaje,” jai riconëmi. ");
INSERT INTO guh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nexata Abraham jumaitsi riconëmijavabelia: “Tamomo, najamatabënapire. Pamatacabi pinaena abaxë asaëmë tsaponaponae nenaexanaeirata, ëpexaniacuene picani xainame. Lázaro pijinia pamatacabi abaxë asaë tsaponaponae, bitso picani bejiobi. Itsiata juya mapamatacabije pexaniacuenia majotaje catsuponapona. Xamë biji navixaetaeya ponaponame. ");
INSERT INTO guh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Itsajivi jamatabëponae ata bajarabereca, acuenebi itsiata pepanepaenexa bajarabereca. Tsipaji bitso ayaiitapajanitoxanetoreca. Bajaraxuata paxamë ata apo pacacaëjëpae panepanepaenexa mabetsinaje,” jai Abraham. ");
INSERT INTO guh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nexata icatsia riconëmi jumaitsi Abrahamjavabelia: “Amo Abraham, pexaniacuene cavajëtatsi. Tonajumeitorobianame Lázarota taxa pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bajarajotalia xainajë cinco ponëbeje tajuyapijivi. Xaniavaetsia Lázaro tsipaebiana. Muxujiobiana bajarapamonae ata peponaeyaniva mapanavixaetaeyabiabinacuaya berenaje,” jai riconëmi Abrahamjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nexata icatsia Abraham jumaitsi riconëmijavabelia: “Bajarapamonae baja xaina Moiséspijinë peyaquinaelivaisianë. Diosojumepaebivimi profetavi ata peyaquinaelivaisianë ata, xaina baja. Nexata nejuyapijivi itsa apo jitsipae tsane peponaenexa bajarapanacuayabelia, nexata nejuyapijivi jumecovënëtsiana bajarapamonaemi peyaquinaelivaisianë,” jai Abraham riconëmijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Riconëmi icatsia jumaitsi Abrahamjavabelia: “Jume raja. Apo jumecovënëtsi tsane cajena bajarapalivaisianë. Itsiata itsajivi itsa asaë tsane petëpaecujinae penaviatsinexa pecovëyabelia, tsipaebiana tajuyapijivijavabelia. Nexata tajuyapijivi copabiana pibisiacuene pexanabiabijava. Najamatabëcuenepënëyorotsiana Diosojavabelia,” jai riconëmi Abrahamjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nexata icatsia Abraham jumaitsi riconëmijavabelia: “Nejuyapijivi itsa apo jumecovënëtsi Moiséspijinë peyaquinaelivaisianë, Diosojumepaebivimi profetavi peyaquinaelivaisi ata, nexata pajivi asaë petëpaecujinae, mavelia ponae ata tsipaeje petsipaebinexa nejuyapijivijavabelia, itsiata nejuyapijivi apo jumecovënëtsi tsipae bajarapajivi ata,” jai Abraham riconëmijavabelia, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús jumaitsi pijajivijavabelia: —Xanë tajajivixae, itsamonae jamatabëcueneëjëbabiabianatsi pibisiacuene pexanaenexa. Nexata itsamonae pejamatabëcueneta tajajivi pibisiacuene exanaena. Nexata pajivi pejamatabëcueneta tajajivi pibisiacuene exanaena, bajarapajivi Diosojavabelia bitso naneconitsiana. Nexata bajarapajivi pinijicuenia Dioso naneconitsiaexanaenatsi. ");
INSERT INTO guh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Itsamonae Dioso pejumecovënëtsivi, abaxë bepejevaxijamatabëcuene xaina Dioso pejumecovënëtsijava yabara. Nexata apo ajamatabëcuenesaë. Nexata pajivi tajajivijavabelia pibisiacuene jamatabëexanaeyaexana, abaxë tajajivijavabelia pibisiacuene exanaeyaexanaenejeva, bajarapajivi bevësicëtatsi ibotoxanetojavabelia. Nexata bajarapajivi yamaëya, ibotoxaneto yajava, bexuarecatsi pucaxaneto tuatuajëareca. Bajarapacuenia bexuarecatsi, tajajivijavabelia pibisiacuene itsa exanaeyaexana bitso penaneconitsiyaniva Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nexata xania. Panayajivitaema pibisiacuene, jai Jesús pijajivijavabelia. Icatsia Jesús jumaitsi pijajivijavabelia: —Itsanë Dioso panenajuajumecovënëtsivi pibisiacuene itsa pacaexanaena paxamëjavaberena, bajaraponë xaniavaetsia paitavetsianame. Nexata baja itsa aura tsane pibisiacuene papecaexanaejava yabara, nexata pexaniajaijumeta itsa pacanavajunupaebiana pecopatsijavanexa bajarapacuene, pajamatabëcuenecaevianame pibisiacuene papecaexanaejava. Pabarajamatabëcuenexanepanaename bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Caematacabita siete xuabeje pibisiacuene pacaexanae ata tsane, itsiata siete xuabeje itsa aura tsane pibisiacuene papecaexanaejava yabara, nexata pexaniajaijumeta itsa pacanavajunupaebiana pecopatsijavanexa bajarapacuene, itsiata pajamatabëcuenecaevianame. Pabarajamatabëcuenexanepanaename bajaraponë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús pijaapóstolevi jumaitsi Jesúsjavabelia: —Patajatuxanenë, paneyavenonare: “Xanë cajena necaëjëpa daxitacuene taexanaenexa,” nejaitsabiabijava orijibia patacajumecovënëtsinexa, jai Jesús pijaapóstolevi. ");
INSERT INTO guh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nexata Jesús jumaitsi pijaapóstolevijavabelia: —Tsiquirijavayo ata xanë yabara itsa pajamatabëjumaitsimë tsipae: “Xaniajai cajena. Jesús caëjëpatsi daxitacuene pexanaenexa,” itsa pajamatabëjamë tsipae, nexata paxamë ata pacacaëjëpaejitsipa ayaicuene paneexanaenexa. Nexata itsa pajumaitsimë tsipae mapanaejavaxanetojavabeliaje: “Yatabutopaya natixire. Nucaename pucaxaneto tuatuajëtalia,” itsa pajamë tsipae, nexata naejava ata pacajumecovënëtsipa cajena, jai Jesús pijaapóstolevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús icatsia jumaitsi pijaapóstolevijavabelia: —Paxamëyajuvënënë xainaejitsipa pijajivitonë. Nexata itorobijitsipa petonacuenebaponaponaenexatsi. Nexata bajaraponë pijatuxanenë ira petocueponaponaecujinae, patsipa pijatuxanenë pijaboyaberena. Itsa jume, baca petoevetaponaponaecujinae patsipa. Nexata paxamëyajuvënënë petuxanenëxae, pijajivitonëjavabelia apo jumai tsipae: “Jonemena baja. Ecare nexaejava tacarajutsinexa,” apo jai tsipae pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jume baja cajena. Biji rajane jumai tsipae pijajivitonëjavabelia: “Netoexanare taxaejavanexa. Nexata abaxë nevetanucaename tanabanijavata. Bajaraxuacujinae xamë nabanianame,” jai tsipae pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Xanepana rabaja. Pexaniacuene bitso netoexaname,” apo jai tsabiabinua pijajivitonëjavabelia petonacuenebabiabijavatsi yabara. Bajarapacuenia apo jumai tsabiabi tsipae tsipaji saya pijajivitonë tsaponaponae. Nexata pacuenia pijatuxanenë itorobatsi, bajaraponë exanabiabijitsipa. ");
INSERT INTO guh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bajarapacuenia paxamë ata patoexanare Dioso papecaitorobicuenia. Itsa patoveretsianame Dioso papecaitorobicuenia panetoexanavanapaejava, nexata saya namataenetsia panajumaitsimë tsane: “Vaxaitsi saya vajatuxanenë pijajivitsi. Nexata vajanacaitorobicuenia toexanavanapatsi,” panajamë tsane. Pëtsa panajumaitsimë: “Itsajivi meta nacajumai tsane: ‘Xanepana rabaja. Xaniavaetsia Dioso patonacuenebame,’ nacajai meta tsane,” panajamë pëtsa, jai Jesús pijaapóstolevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús pona Jerusalén tomarabelia. Itsajota Samaria nacuabeje Galilea nacuabeje namuxunenecaxitajarababeje, bajaraxuayo Jesús najetaruca. ");
INSERT INTO guh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Itsa baja Jesús patsijitsia tsiquiritomarayojavabelia, mataenenatsi diez ponëbeje bajayajebi bitso peperabëtsabanaevi. Itsiata tajiyo bajarapamonae vecuanubenaothopatsi. ");
INSERT INTO guh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bajarapamonae ayaijumeta jumaitsi Jesúsjavabelia: —¡Jesús, paneitaxutotsoniataema! jai. ");
INSERT INTO guh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nexata Jesús itsa tane bajarapamonae, Jesús jumaitsi bajarapamonaejavabelia: —Panaitajëtsianame sacerdotevijavabelia papecaperabëtaenexa, jai Jesús bajarapamonaejavabelia. Nexata bajarapamonae pona sacerdotevijavabelia. Nexata bajarapamonae namutua penajetarubenaejavata pepatsinexa sacerdotevijavabelia, namutua baja perabëxanepananajetarubena. ");
INSERT INTO guh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Daxita bajarapamonae peperabëxanepanaejava itsa tane, nexata caenë saya bajarapamonaeyajuvënënë naviateca Jesúsjavabelia. Bajaraponë namutua ayaijumeta Diosojavabelia jumai tsanajetarucae: “¡Diosomë, bitso ayaijamatabëcuenenëmë! ¡Tavitanejavami baja vecua, nejamatejemayaexaname!” jai tsanajetarucae bajaraponë Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bajaraponë itsa pata Jesúsjavabelia, pematabacabëta irataeya bocajunua Jesús pitabarata. —Pexaniacuene netoexaname. Nejamatejemayaexaname baja tavitanejavamivecua, jai Jesúsjavabelia. Bajaraponë Samaria nacuapijinë. ");
INSERT INTO guh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nexata Jesús jumaitsi bajarajota penubenaevijavabelia: —Diez ponëbeje bitso peperabëtsabanaevi jamatejemayaexanajë. ¿Detsa meta xuajitsia daxita apo najuapatsi? ");
INSERT INTO guh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Maponëje caenë saicaya nacuapijinë, apo judíonë ata, naviateca Diosojavabelia pejumaitsinexa: “¡Diosomë, bitso ayaijamatabëcuenenëmë! ¡Tavitanejavami baja vecua, nejamatejemayaexaname!” pejainexa Diosojavabelia, jai Jesús bajarajota penubenaevijavabelia Samaria nacuapijinë yabara. ");
INSERT INTO guh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nexata Samaria nacuapijinëjavabelia Jesús jumaitsi: —Nonotapunare. Ponare baja. Jamatejemamë rabaja tanejumecovënëtsixaemë tacajamatejemayaexanaejavanexa, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseovi jumaitsi Jesúsjavabelia: —¿Detsa paepatota copiapatsiana Dioso pijajivi pevetsijava pijajivi mapanacuataje? jai fariseovi. Nexata Jesús jumaitsi fariseovijavabelia: —Dioso taxuxuabi ata pijajivi pevetsijava mapanacuataje, apo taetsi vajaitaxutota. ");
INSERT INTO guh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nexata jivi apo jumai tsane: “Copiapata rabaja majotaje Dioso pijajivi pevetsijava mapanacuataje,” apo jai tsane. “Copiapata rabaja majotaliaje Dioso pijajivi pevetsijava mapanacuataje,” apo jainua tsane. Dioso rabaja capanepaeya aeconoxae evetapona pijajivi paxamë tuatuajëta, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nexata Jesús itsamatacabi mapanacuaje pevetsijavanexa, tajëvelia navajunupaeba pijajivijavabelia. Jesús jumaitsi mapacueniaje: —Itsamatacabi xanë, Daxitajivi Pematapijinënë, mapanacuaje taevetsinë tsane. Nexata paxamë picani bitso pajitsipaename patanetaenexamë mapanacuaje taevetsicuene. Itsiata baitsi jane apo pataemë tsane mapanacuaje taevetsicuene. ");
INSERT INTO guh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nexata itsamonae pacajumai tsane: “Bajarajotalia eca mapanacua pepo pevetsinëje,” pacajai tsane xanë yabara. Itsa jume, pacajumai tsane: “Majota ecaje, mapanacua pepo pevetsinëje,” pacajai tsane xanë yabara. Itsiata pëtsa paponame. Pëtsa pamuxunaponamenua bajarapamonae pepëta. ");
INSERT INTO guh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pacuenia yamaxë itsa nivejai tsajuni athëbëvetsica, caecuenia jivi cotiatane daxitajava, bajara pijinia pacuenia daxitanacuanëpijivi caecuenia netaena pamatacabi patsianicajë xanë, Daxitajivi Pematapijinënë. ");
INSERT INTO guh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Itsiata copiaya ayaicuenia navixaetaeya bejiobinë tsane. Mapanacuataje pejinavanapaevi apo nejumecovënëtsinua tsane Dioso athëbëvetsica taneitorobinëcuenetsica. ");
INSERT INTO guh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pacuenia bajayata jemata itsi pamatacabi Noépijinë ponapona, bajara icatsia jemata itsane pamatacabi xanë, Daxitajivi Pematapijinënë, jemata icatsia patsianicajë. ");
INSERT INTO guh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bajayata pamatacabi Noépijinë ponapona, jivi picani xaniavaetsia jamatejema pexaejava xaevanapa. Apaevanapanua. Nacojiobapona itsamonae. Itsamonae pexënatoyonë pebijavabelia canajetapona petonacojiobinexatsi. Bajarapamonae jamatejema saya jinavanapa. Nexata bajarapamatacabi Noépijinë ëpijamonae pinijibarcojavabelia barëjunua. Nexata daxitajivi merata bubuna jemata ira itsa bubuta. ");
INSERT INTO guh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bajara pijinia itsi bajayata pamatacabi Lotpijinë ponapona. Jivi saya jamatejema jinavanapa. Pexaejava xaevanapa. Apaevanapanua. Comuacapona. Canajetapona. Ubapona pijapabianë. Pijabonë ata exanapona. ");
INSERT INTO guh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Itsiata baitsi jane pamatacabi Lotpijinë Sodomatomara vecuapitsapa, jemata athëbëvetsica pinijicuenia isotonë othopaica. Othopaica pitarutsiibotonënua. Nexata daxita Sodoma tomarapijivimi tajuatsi. Nexata baja verebiabatsi. ");
INSERT INTO guh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bajara pijinia pacuenia icatsia jemata itsane pamatacabi xanë, Daxitajivi Pematapijinënë, jemata icatsia patsianicajë, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Icatsia Jesús jumaitsi pijajivijavabelia: —Pamatacabi xanë jemata patsianicajë, itsajivi ata pëtsa sivanajamatabëxaina mapanacuapijicueneje. Nexata pajivi athëbëyo bojumatatsia ecaya, perunaecujinaetsica, pëtsa sivanajamatabëxaina pijaboënëalia pebobenaejavanë pejutsinexa. Pajivi pijinia pijapabita nacuenebaponapona, pëtsa najamatabëxaina penaviatsinexa pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Panajamatabënapire pacuenia bajayata Lotpijinë pijavami exanatsi. Lotpijinë pijavami pesivanajamatabëxainaexae mapanacuapijicuene, napijivitaeyojopa. Nexata baja tëpa. ");
INSERT INTO guh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pajivi exanaponapona penatojitsipaecuenia, apo xainae tsane matacabi apo pevereverecaejava. Itsiata baitsi jane pajivi xanë tajamatabëcueneta copatsiana penatojitsipaecuenia pexanabiabijavami, bajarapajivi xainaena matacabi apo pevereverecaejava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Icatsia Jesús jumaitsi tajëvelia pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pamatacabi patsianicajë, bajarapameravi anijanëbeje majitanucaenabeje caecamata. Itsanë tanejumecovënëtsinë tsane. Itsanë apo tanejumecovënëtsinë tsane. Nexata tanejumecovënëtsinë pitsianatsi ángelnë. Apo tanejumecovënëtsinë copatabuatsianatsi. ");
INSERT INTO guh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Anijavabeje pijinia najuacuabanucaenabeje caejavata. Nexata tanejumecovënëtsiva pitsianatsi. Apo tanejumecovënëtsiva copatanutsianatsi. ");
INSERT INTO guh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anijanëbeje pijinia najuanacuenebanucaenabeje pabita. Nexata tanejumecovënëtsinë pitsianatsi. Apo tanejumecovënëtsinë copatanutsianatsi, jai Jesús tajëvelia pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesús nexata pijajivi itsa jumetane bajarapacuenia Jesús pejumaitsijava, bajarapamonae jumaitsi Jesúsjavabelia: —Patajatuxanenë, ¿detsa jota bajarapacuenia yajuvënëpitsianatsi? jai Jesús pijajivi. Nexata Jesús jumaitsi tajëvelia pijajivijavabelia: —Pacuenia quequeremonae bepijia yapëtane itsajota petuxutsaebinë boca bajarajota penacaetuatsinexa, bajara pijinia pacuenia daxita tajajivi bepijia yapëtaena tapatsijavatsica penacaetuatsinexa xanëjavaberena, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús pijajivi livaisi tsipaeba mapacueniaje Jesús pijajivi jamatabëcuenecueranaenejeva pevajëtabiabinexa Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nexata Jesús jumaitsi pijajivijavabelia: —Tomarata ponapona jueznë. Bajaraponë pevetsinë jivi penaneconitsiaexanaecuene. Bajaraponë Dioso apo cujunavi. Jivi ata apo cujunavi. ");
INSERT INTO guh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bajarapatomarata ponapona pamona pevecuatëpaevatsi. Bajarapova ponabiaba jueznëjavabelia pejumaitsabiabinexa: “Naneconitsiaexanare ponë xanëjavaberena naneconita. Naneconitsiaexanare pacuenia caitoroba nijatuxanenë bajarapitsivi nenaneconitsiaexanaenexa,” pejaitsabiabinexa, bajarapova ponabiaba jueznëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Itsiata abaxë bajayajebi jueznë apo jamatabëcueneyavenonae bajarapova. Belia baja bexëa jueznë jejai. Nexata jueznë jamatabëjumaitsi: “Dioso picani apo cujunavinë. Jivi ata picani apo cujunavinë. ");
INSERT INTO guh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Itsiata mapovaje tanejamatabëitonotabiabixae, yavenonaenajë pacuenia nitorobabiaba. Nexata baja bajarapova matavëjëa apo patabiabirena tsane xanëjavaberena tanecueranaeyaexanaenexa,” jamatabëjai jueznë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús icatsia jumaitsi pijajivijavabelia: —Bajara jamatabëcueneitsi jueznë, pibisiajamatabëcuenenë ata. Yavenona bajarapova asaëya pevajëcabiabixaetsi. ");
INSERT INTO guh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bajara pijinia pacuenia Dioso ata pijajivi yavenonaena itsamonae pibisiacuene itsa exanatsi. Bajarapacuenia Dioso pijajivi yavenonaena bajarapamonae itsa vajëtabiabiana Diosojavabelia matacabijebi, meravi yajava. Dioso cajena apo cuenenajematsi tsane itsa yavenonaena pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Xaniajanë pacuenia pacatsipaebijitsiatsi. Dioso apo cuenenajematsi tsane itsa yavenonaena pijajivi itsamonae pibisiacuene pexanaeyanivatsi. Pamatacabi xanë, Daxitajivi Pematapijinënë, icatsia patsianicajë, ¿caxitajarabianajë tsaja abaxë tanecopiaevetavanapaevi? jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Itsajota Jesús pijajivijavabelia livaisi tsipaeba, bajarajota nubena itsamonae. Bajarapamonae jamatabëjumai tsabiabi: “Vaxaitsi cajena pexaniajamatabëcuenevitsi itsamonaevecua. Itsamonae bitso nacavecuapibisiajamatabëcuenevi,” jamatabëjai tsabiabi. Nexata bajarapamonaejavabelia Jesús livaisi tsipaeba. Jumaitsi mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Anijanëbeje tsiabeje templobojavabetsia pevajëtsinexabeje Diosojavabelia. Caenë fariseonë. Itsanë gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabinë. ");
INSERT INTO guh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nexata fariseonë nuca. Fariseonë pevajëtsijavata Diosojavabelia, bitso bepexaniajamatabëcuenenë nataeya jumaitsi mapacueniaje: “Diosomë, pexaniajamatabëcuene carajutatsi. Tsipaji pacuenia itsamonae jamatabëcueneitsi tsenae, bajara xanë apo jamatabëcueneitsinë. Yamaxëitojorobiaya jivi apo tavecuanacobetoxotsinë. Apo tacujirubejenë cajena. Apo tajaitsinë itsava tajavavecua. Pacuenia maponëje gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabinë jamatabëcueneitsije, bajara xanë apo tajamatabëcueneitsinë. ");
INSERT INTO guh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Caesemana canacujitsia, anijamatacabibeje, najamatabëcuenexaniavaetsiaya ponaponabiabajë xaenejevanë taxaejava tacavajëtsinexa xamëjavabelia. Daxita pacuene nacanabajë, diez xuabejeyajuvënëjava, caejava, xamëjavabelia carajutabiabatsi ofrendacuenia,” jai mapacueniaje fariseonë templobota pevajëtsijavata Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nexata ponë gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabinë, pevajëtsijavata Diosojavabelia tajiyo nucalia piauraxae. Athëbëabetsia ata penavëyotsijava cujunava. Namëpabëbenuca pecobeta pejamatabëbëjaixae pibisiacuene pexanaeneconi yabara. Nexata bajaraponë Diosojavabelia pevajëtsijavata jumaitsi mapacueniaje: “¡Diosomë, nitaxutotsoniataema! ¡Pibisiacuene cajena bitso xanë exanabiabajë!” jai bajaraponë templobota pevajëtsijavata Diosojavabelia, jai Jesús mapacueniaje bepexaniajamatabëcuenevi penataevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Icatsia Jesús jumaitsi bajarapamonaejavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Ponë gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabinë, bajarapacuenia pevajëtsixae Diosojavabelia, Dioso baja vecuaajibiaexanatsi pibisiacuene pexanaeneconimi. Nexata baja bajaraponë naviata pijaboyabelia pianeconijibinë. Ponë fariseonë, navajëtsi ata Diosojavabelia, itsiata pijaneconi yajava naviata pijaboyabelia. Tsipaji beayaijamatabëcuenenë natane pevajëtsijavata Diosojavabelia. Bajaraxuata pajivi beayaijamatabëcuenejivi natane itsamonaevecua, bajarapajivi beveliajamatabëcuenejivi exanaenatsi Dioso. Pajivi saya beveliajamatabëcuenejivi natane itsamonaevecua, bajarapajivi ayaijamatabëcuenejivi exanaenatsi Dioso, jai Jesús bepexaniajamatabëcuenevi penataevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Itsamonae pejevaxijivixi tocapataponatsi Jesús pecobeta pejayataponaenexa. Nexata Jesús pijajivi itsa tane bajarapacuene, Jesús pijajivi itaveta pexi pecapatsivi. Jesús pijajivi jumaitsi pexi pecapatsivijavabelia: —Pëtsa patocapataponame panexi Jesúsjavabelia, jai. ");
INSERT INTO guh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nexata Jesús jumaitsi pijajivijavabelia: —Pëtsa paitavetame. Pacopare pejevaxijivixi pepatsinexa xanëjavaberena. Mapitsipejevaxijivixije jumeaebinejeva xaniavaetsia bajumecovënëta palivaisi tsipaebatsi. Nexata pamonae jitsipa pejonejava Dioso pijanacuayabetsia, bajara pijinia pacuenia jumeaebinejeva xaniavaetsia bejumecovënëta Dioso pejumelivaisi. ");
INSERT INTO guh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapitsipejevaxijivixije itsa jumecovënëta palivaisi tsipaebatsi, bajumecovënëta xaniavaetsia jumeaebinejeva. Nexata pamonae jitsipa pejonejava Dioso pijanacuayabetsia, bajara pijinia pacuenia jumeaebinejeva xaniavaetsia bejumecovënëta Dioso pejumelivaisi. Nexata pamonae jumeaebinejeva xaniavaetsia jumecovënëtsiana Dioso pejumelivaisi, bajarapamonae jonena Dioso pijanacuayabetsia. Itsiata baitsi jane pamonae Dioso pejumelivaisi jumeaebinejeva xaniavaetsia apo jumecovënëtsi tsane, apo jone tsane Dioso pijanacuayabetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pevëjëato, judíovi pevetsinë, yanijoba Jesúsjavabelia. Pevëjëato jumaitsi mapacueniaje: —Petuxanenë, pexaniajamatabëcuenenëmë, ¿detsa pitsicuene exanaenajë taxainaenexa matacabi apo pevereverecaejava? jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nexata Jesús jumaitsi pevëjëatojavabelia: —¿Detsa xuajitsia: “Pexaniajamatabëcuenenëmë,” nejamë? Ajibi raja itsapebi ata pexaniajamatabëcuenenë. Caenë rabaja Dioso pexaniajamatabëcuenenë. ");
INSERT INTO guh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xamë baja yapëtaneme pacuenia Dioso pejumelivaisita itoroba jivi pejumecovënëtsinexa. Jumaitsi mapacueniaje: “Pëtsa jaitame itsapetiriva nijavavecua. Pëtsa beyaxuabame jivitonë. Pëtsa nacobetoxotame. Pëtsa itsamonae pexanaejava yabara najumetsënëtsiaya paebame. Axa yaiyataema. Ena ata yaiyataema,” jai Dioso pejumelivaisita. Xamë baja yapëtaneme bajarapalivaisi, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nexata pevëjëato jumaitsi Jesúsjavabelia: —Daxita rabaja bajarapalivaisianë jumecovënëtajë pejevaxinënëjavaveliacujinae, jai pevëjëato. ");
INSERT INTO guh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Itsa Jesús jumetane bajarapacuenia pejumecanaviatsijavatsi, nexata icatsia jumaitsi pevëjëatojavabelia: —Abaxë raja catosaica caejava nexanaenexa. Canajere daxita nexainaejavami. Bajarapamatamomi tsicobetsanaename bepejiobivi. Bajaraxuacujinae nepënaponaename. Nexata bajarapacuenia xainaename bitso nexainaecuene Dioso pijanacuatatsia, jai Jesús pevëjëatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bajarapacuenia Jesús itsa jumaitsi pevëjëatojavabelia, nexata pevëjëato bitso bejamatabëjiobi tsanajetsireca. Tsipaji pevëjëato daxitacuene bitso pexainaenë. Nexata pevëjëato apo jamatabëjumecovënëtsi palivaisi Jesús tsipaeba. ");
INSERT INTO guh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Itsa Jesús tane pevëjëato bepejamatabëjiobi tsanajetsijavareca, nexata pevëjëato pecovëta jumaitsi pijajivijavabelia: —¡Pamonae bitso daxitacuene pexainaevi, tsiayapëbejetsi bitso penajamatabëcuenecopatsinexa Diosojavabelia pecapanepaenexatsi Dioso pijanacuayabetsia! ");
INSERT INTO guh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pacuenia camello acuenebi pejonejava palutaetoitaxutovojotualia, bajara pijinia pacuenia bitso pexainaenë acuenebi tsane pejonejava Dioso pijatomarabetsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nexata Jesús pijajivi jumaitsi Jesúsjavabelia: —¿Detsa nexata pitsivi panepaena Diosojavabelia, bitso pexainaevi ata, itsa apo panepae tsane Diosojavabelia? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús nexata jumaitsi pijajivijavabelia: —Pacuene jivi apo caëjëpaetsi pexanaenexa, bajarapacuene Dioso caëjëpatsi pexanaenexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nexata Pedro jumaitsi Jesúsjavabelia: —Patajatuxanenë, paxanë rabaja pacopatajë daxitacuene pataxainaejavami. Nexata baja pacapënajinavanapatsi, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesús nexata jumaitsi: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pajivi Dioso pijacuene petonacuenebinexa pueneta pijabomi, paxa ata, pena ata, pematapijivi ata, pejuyapijivi ata, pijava ata, pexi ata, nexata bajarapajivi mapanacuataje pepuenetsijavami matatoxenetsia Dioso rajutsianatsi. Nexata bajarapajivi bexëajavabelia petëpaecujinae ata Dioso rajutsianatsi matacabi apo pevereverecaejava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús itsamonaevecua ëpijajivi, doce ponëbeje, junata pimoxoyotsinexatsi. Nexata Jesús pebeyaxuabijavanexatsi, tajëvelia navajunupaeba pijajivijavabelia. Jesús jumaitsi mapacueniaje: —Panejumetaema. Mara Jerusalén tomarabelia ponatsije. Bajayata Diosojumepaebivimi profetavi, xanë, Daxitajivi Pematapijinënë, talivaisi tajëvelia yaquina. Pacuenia nexanaejitsia, daxita bajarapalivaisi bajayata profetavimi tajëvelia yaquina. Nexata daxita pacuenia xanë talivaisi bajayata tajëvelia profetavimi yaquina, daxita jane baja bajarapacuene Jerusalén tomaratalia netocopiapatsiana. ");
INSERT INTO guh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Itsanacuaverena pepatsivi pecobeyabelia necanajetsiana tanebeyaxuabinexa. Bajarapamonae necanecaponaena. Nebijataena pibisiacuenia. Nesuabiana. ");
INSERT INTO guh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nejumatitibabena penaneconitsivi pejumaconitabiabimacata. Bajaraxuacujinae nebeyaxuabiana. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata pebeyaxuabijavanexatsi. ");
INSERT INTO guh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Itsiata Jesús pijajivi apo jumeyapëtae pajamatabëcuene yabara Jesús jumaitsi. ");
INSERT INTO guh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús imoxoyotanajetaruca Jericótomara. Nexata namuto muxuneneta eca bitso pitaxutotsëcënaenë, apo petaenë. Bajaraponë amoneya palata vajëcabiabeca jivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nexata bitso pitaxutotsëcënaenë itsa jumetane jivibitsaëtoxaneto pecuaicuaijai tsanajetarubenaejava namutua, bajaraponë epajunateca. —¿Detsa xua pajaitame? jai tsecae bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nexata jivi jumaitsi bajaraponëjavabelia: —Jesús raja, Nazaret tomarapijinë, maxuayo najetarucaje, jai jivi. ");
INSERT INTO guh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nexata pitaxutotsëcënaenë vavajai tsecae. —¡Jesús, Davidpijinë pemomomë, nitaxutotsoniataema! jai tsecae bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nexata picani itsamonae, Jesús pevajënaeya penajetarubenaevi, jumeitaveta bajaraponë pemoyanexa. Itsiata biji bitsoyo orijibia vavajai tsecae. —¡Davidpijinë pemomomë, nitaxutotsoniataema! jai tsecae pitaxutotsëcënaenë. ");
INSERT INTO guh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nexata Jesús muxunanucojopa. Jumaitsi pijajivijavabelia: —Panetocomacaponaremena pitaxutotsëcënaenë, jai Jesús. Itsa baja imoxoyo tocanajetarubenatsi, Jesús jumaitsi pitaxutotsëcënaenëjavabelia: ");
INSERT INTO guh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Detsa xua jitsipame tacaexanaenexa? jai Jesús. Nexata bitso pitaxutotsëcënaenë jumaitsi Jesúsjavabelia: —Jesús, jitsipajë taitaxutoxanepanaejava, jai pitaxutotsëcënaenë. ");
INSERT INTO guh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús nexata jumaitsi pitaxutotsëcënaenëjavabelia: —Itaxutoxanepaname rabaja. Tsipaji nesivajamatabëjumaitsimë mapacueniaje: “Jesús nitaxutoxanepanaeyaexanaena,” nesivajamatabëjamë, jai Jesús pitaxutotsëcënaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bajarapacuenia Jesús pejumaitsijavata, bitso pitaxutotsëcënaenëmi xaniavaetsia baja tane. Nexata bajaraponë napona baja Jesús pepëta. Bajaraponë namutua jumai tsanajetarucae Diosojavabelia: —¡Diosomë, bitso pexaniacuene netoexaname! jai tsanajetarucae bajaraponë. Pamonae ata tane bajaraponë pitaxutoxanepanaejava baja, daxita bajarapamonae ata Diosojavabelia jumai tsanajetarubenae: —¡Diosomë, bitso ayaijamatabëcuenenëmë! jai tsanajetarubenae Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús najetaruca Jericó tomarajava. ");
INSERT INTO guh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jericó tomarata ponapona Zaqueovënënë. Bajaraponë gobierno pejamatabëcuene impuestomatamo pematamoyanijobabiabivi penamatacaitorobinë. Zaqueo bitso pexainaenë pexainaejava. ");
INSERT INTO guh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nexata Zaqueo jamatabëtane Jesús. Itsiata apo caëjëpaetsi petaejava. Tsipaji Zaqueo petoyaecaenëyo. Jivibitsaëtoxaneto matatoyorotsia nubenatsi Jesús Zaqueo pevajënae. ");
INSERT INTO guh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nexata Zaqueo cujinaeponalia jivibitsaëtoxaneto pevajënaeyabelia Jesús peponaenamutuabelianexa. Junaya naejavatsia athëbëvetsica petaenucaenexa Jesús penajetarucaejava. ");
INSERT INTO guh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nexata Jesús namutua itsa imoxoyotanajetaruca, itsa ponaeta Zaqueo athëbëyo nucaya, bajaraponaejavatsia Jesús naëcotsia. Nexata Jesús taenutsia Zaqueo. Jesús nexata jumaitsi Zaqueojavabelia: —Zaqueo, naxanitsiayo runaimica. Nijaboyabelia raja patsijitsianë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nexata Zaqueo naxanitsiayo runajopaica. Barëyaya copiapita pijaboyabelia pebarëponaenexa Jesús. ");
INSERT INTO guh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Daxita pamonae Jesús matatoyorotsia najetarubenatsi, itsa tane bajarapacuene, Jesús baracuaicuaijaitsi tsanajetarubenae. Ëpamonae najumaitsi tsanajetarubenae Jesús yabara: —Jesús raja naponaponaejitsia Zaqueo pijabota, caranata pibisiacuene pexanaenë pijabota, najai tsanajetarubenae bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nexata Zaqueo pijabota Jesús eca mesa muxuneneta. Bajarajota Jesús pitabarata Zaqueo nonotapuna. Jumaitsi Jesúsjavabelia: —Tajatuxanenë nejumetaema. Tsatsianejë namatajëpaeya taxainaijava tarajutsinexa bepejiobivijavabelia. Pamonae yamaxëitojorobiaya vecuanotajë tamatamoyanijobijavata impuestomatamo, bajarapamonae tocanaviabianajë. Nexata tayamaxëitojorobijamatabëcuene bajarapamonae rajutsianajë juya cuatro xuabeje tsaponai caijavayomijamatabëcuene, jai Zaqueo Jesúsjavabelia.; ");
INSERT INTO guh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nexata Jesús jumaitsi Zaqueojavabelia: —Zaqueo, ajena rabaja pamatacabi, caxitajarabame, nijamonae yajava, nijaneconivecua pecacapanepaejavanexa Diosojavabelia. Tsipaji baja nijamonae barëjumecovënëtame Dioso. Zaqueo, xamë Abrahampijinë pemomo atamë, abaxë picani Dioso apo catae Abrahampijinë pemomomëcuenia. Itsiata baitsi jane ajena baja Diosojavabelia nenajamatabëcuenecopatsixae, Dioso jane baja catane pepacuene Abrahampijinë pemomomëcuenia. ");
INSERT INTO guh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xanë, Daxitajivi Pematapijinënë, sivapatajopajë tajaitsinexa Diosovecua penaxuabivi tacapanepaenexa pijaneconivecua, jai Jesús Zaqueojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zaqueo pijabota itsamonae namuxunaevetena Jesús petsipaebilivaisi Zaqueojavabelia. Pamonae namuxunaevetena, jamatabëcuenenavëxaniabiaya jamatabëjumai tsenae: “Imoxoyo rabaja ecalia Jerusaléntomara. Nexata Jesús itsa patsialia Jerusalén tomarabelia, copiajopaena jane baja daxita Dioso pijajivi pevetsijava,” jamatabëjai tsenae bajarapamonae. Bajarapacuenia jamatabëjumai tsenae tsipaji baja Jerusaléntomara imoxoyo ecalia Jesús pepatsinexa. ");
INSERT INTO guh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bajaraxuata Jesús livaisi tsipaeba bajarapamonaejavabelia. Jesús jumaimatabëcuenenavëxaniabiaya jamatabëjumai tsenae: “Imoxoyo rabaja ecaliatsi mapacueniaje: —Petuxanenë ponapona pijanacuata. Nexata pepo nacuaevetsinë tonajumeitorobarenatsi tajënacuaverena. Petonajumeitorobijumetsirena jumaitsirena mapacueniaje: “Ponaename maberenaje nacua nevetsinënexa tacaexanaenexa nijanacua nevetsinexa. Bajaraxuacujinae naviatsiaremelia nijanacua jane baja nevetsinexa,” jaitsirena petonajumeitorobijumetsirena. ");
INSERT INTO guh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nexata petuxanenë peponaevajënae, junata pijajivi, diez ponëbeje. Nexata petuxanenë pijajivi evetsiaexana pijapalatanëanë, oronëanë, bitso penamatamotsinëanë. Caenë canacujitsia caepalatanë evetsiaexanapona. Nexata petuxanenë pijajivi jumaitsi pijajivijavabelia: “Bajarapapalatata pacomuataponaename. Xua pacomuataponaename, icatsia pacanajetaponaename. Nexata bajarapacuenia netoayaijava tsaponae tsane tajapalata,” jai petuxanenë pijajivijavabelia. Bajaraxuacujinae pona jane baja. ");
INSERT INTO guh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Itsiata baitsi jane pevetsinacuatanexa pejinavanapaevi, bitso itoyatsi petuxanenë. Nexata bajarapamonae petuxanenë pecovëvelia itsamonae itorobalia, itsajotalia petuxanenë nacua pevetsinënexa exanaejitsiatsi, bajarajotalia pejumaitsinexa: “Apo pajitsipaenë bajaraponë patanevetsinënexa patajanacuata,” pejainexa petuxanenë yabara. ");
INSERT INTO guh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Itsiata baitsi jane petuxanenë pijanacua baja pevetsinënexa exanatsi. Nexata baja naviarena pijanacuayaberena pevetsinexa jane baja pijanacua. Nexata baja parena. Nexata petuxanenë pepatsicujinaerena, junata icatsia pijajivi peyapëtaenexa jane baja pacuenia caenë canacujitsia pijapalatanëanë pijajivi tocanacuenebatsi pecovëta. ");
INSERT INTO guh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Copiaya pepatsinë jumaitsi pijatuxanenëjavabelia: “Tajatuxanenë, nijapalatanë, taneevetsiaexanaenëmë, catopitsapa baja diez ponëbeje. Nexata baja daxitata once ponëbeje,” jai. ");
INSERT INTO guh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nacuaevetsinë nexata jumaitsi pijajivitonëjavabelia: “Xanepana rabaja. Xaniavaetsia netoevetaponaponame. Tsiquirijavayo ata xaniavaetsia netoevetame. Nexata icatsia diez patomarabeje netoevetaponaponaename,” jai nacuaevetsinë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Icatsia itsanë pijatuxanenë pijapalatanë petoevetsinë pata. Nexata bajaraponë jumaitsi: “Tajatuxanenë, nijapalatanë, taneevetsiaexanaenëmë, catopitsapa baja cinco ponëbeje pematatsënëa,” jai. ");
INSERT INTO guh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nacuaevetsinë nexata jumaitsi pijajivitonëjavabelia: “Xamë icatsia cinco patomarabeje netoevetaponaponaename,” jai nacuaevetsinë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nexata icatsia itsanë pijatuxanenë pijapalatanë petoevetsinë pata. Jumaitsi pijatuxanenëjavabelia: “Tajatuxanenë, mara nijapalatanëje, taneevetsiaexanaenëmë. Pañuelopanayota yamatacëtsiaya catoevetatsi. ");
INSERT INTO guh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bajarapacuenia catoevetatsi tsipaji cacujunavatsi. Niajamatabëcuenesaënë. Xamë apo itaxutobejiobiataeyabiabimë nijajivi, pamonae catoeveta nijajava. Itorobabiabame nijajivi pecatopitsinexa apo nijajava ata. Itorobabiabamenua pecatonotsinexa apo neubiaexanaejava ata,” jai pijatuxanenë pijapalatanë petoevetsinë. ");
INSERT INTO guh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nexata nacuaevetsinë jumaitsi pijajivitonëjavabelia: “¡Acujirubejemë xamë! Bijiaya netoevetame. Naneconitame bajarapacuenia tanejumaitsijavamë yabara. Xamë baja cajena yapëtaneme tajamatabëcuenesaënëjava tajajava yabara. Pacuenia itorobabiabajë tajajivi tanetopitsinexa apo tajajava ata, yapëtaneme baja. Pacuenia ata itorobabiabajë tanetonotsinexa apo taubiaexanaejava ata, yapëtaneme baja. ");
INSERT INTO guh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Xanepanaejitsipa xamë banco pevetsivi itsa netocanacuenebiaexanaejitsipame tajapalatanë. Nexata banco pevetsivi aeconoxae tajapalatanë netocanaviatsipa. Nexata pecacovaetsijamatabëcuene itsajava palata netoyajavacanaviatsipa,” jai nacuaevetsinë pijajivitonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nexata nacuaevetsinë jumaitsi pijajivijavabelia: “Tajapalatanë panetovecuapire maponëje. Nexata juya parajure ponë xaniavaetsia netoeveta tajapalatanë. Bajaraponë xaniavaetsia netocanacueneba. Nexata baja pematatsënëa diez papalatanëbeje netopitsapaeyaexana. Nexata taevetsiaexanaenëta once ponëbeje,” jai nacuaevetsinë. ");
INSERT INTO guh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nexata nacuaevetsinë pijajivi jumaitsi pijatuxanenëjavabelia: “Patajatuxanenë, bajaraponë xaina baja ayaijava. ¿Detsa xuajitsia rajutsijitsiamë pematatsënëa?” jai pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nexata nacuaevetsinë jumaitsi pijajivijavabelia: “Pacatsipaebatsi rabaja. Pajivi baja ayaijava xaina, pematatsënëa icatsia itsajava rajutsianatsi. Itsiata pajivi tsiquirijavayo xaina, bajarapajivi pijatsiquirijavayomi vecuapitsianatsi. ");
INSERT INTO guh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tajavajabitsaë, pamonae picani apo jitsipae mapanacua taevetsijavaje, bajarapamonae pacaponaremena maberenaje patanevecuaverebiabinexamë taitabëta,” jai nacuaevetsinë pijajivijavabelia, jai Jesús livaisi petsipaebijavata Zaqueo pijabota. ");
INSERT INTO guh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús baja itsa najumevereta livaisi petsipaebijava Zaqueo pijabota, pona baja Jerusalén tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusalén tomaravecua imoxoyo eca petsuto. Bajarapatsutojumata nubena olivonaenë. Bajarapatsuto canacujitsita anijatomarayobeje ecabeje, Betfagé tomarayobeje Betania tomarayobeje. Jesús itsa imoxoyotanajetaruca bajarapatomarayobeje, nexata itoroba pijajivitonëbeje bajarapatomarayobejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesús jumaitsi pijajivitonëbejejavabelia: —Paponarebeje mapatomarayo ecaliajejavabelia. Itsa rabaja papatsiaremeliabeje, pataenutsianamebeje burro pecëtanutsinëtsi. Bajarapaburro itsajivi ata abaxë apo jumaponae. Paisinaenamebeje. Payamaëcarenamëbeje tsane. ");
INSERT INTO guh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“¿Detsa xuajitsia paisinamebeje burro?” itsa pacajaibeje tsane itsajivi, nexata pajumaitsimëbeje tsane: “Vajatuxanenë raja namatavenona,” pajamëbeje tsane, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nexata Jesús pijajivitonëbeje liabeje. Pacuenia Jesús jumaitsi, bajarapacuenia caxitajarabanucabeje burro. ");
INSERT INTO guh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nexata itsa isinabeje, burro pexainaevi jumaitsitsibeje: —¿Detsa xuajitsia paisinamebeje burro? jaitsibeje. ");
INSERT INTO guh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nexata Jesús pijajivitonëbeje jumaitsibeje burro pexainaevijavabelia: —Vajatuxanenë raja namatavenona. Bajaraxuata paisinajëbeje, jaibeje. ");
INSERT INTO guh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nexata jane baja burro capatabeje Jesúsjavaberena. Nexata Jesús pijajivi burro tsijumajeba pijacamisajumavelia penaxatabijavanë. Jesús baja bajarapaburrojumata ecaya. ");
INSERT INTO guh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús itsa yanajetaruca burrota, panamutovelia Jesús patsijitsia Jerusalén tomarabelia, bajarapanamutua jivi pijacamisajumavelia penaxatabijavanë namutua tsivajënaeyerequejebaponatsi yaiyataeya pecopiapitsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Patsutojumata olivonaenë nubena, bajarapatsutojavatsica namuto namatononocarucaica. Nexata bajarapanamutuatsica Jesús imoxoyotanajetaruca pepatsinexa Jerusalén tomarata. Nexata jivi ayaibitsaëtoxaneto, Jesús pijajivi yajava, vavajai tsanajetarubenae. Sivabarëyaya vavajai Diosojavabelia: —¡Diosomë, bitso ayaijamatabëcuenenëmë! jai tsanajetarubenae bajarapamonae. Bajarapacuenia vavajai tsanajetarubenae tsipaji bajarapamonae cujirutaeyabiaba Jesús Dioso pesaëta ayaicuene pexanaponaejavanë. ");
INSERT INTO guh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bajarapamonae jumai tsanajetarubenae Jesús yabara: —¡Maponë najetarucaje, bitso ayaijamatabëcuenenë Dioso pejamatabëcueneta najetaruca jivi pevetsinënexa! ¡Jamatabëcuenexanepanaeya jinavanapa daxita pamonae athëbëtatsia jinavanapa! ¡Pinijicuene rabaja exana Dioso! jai tsanajetarubenae namutua daxita Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nexata fariseovi najetarubena bajarapajivibitsaëtoxaneto tuatuajëta. Nexata fariseovi jumaitsi Jesúsjavabelia: —Jesús, jumeitavere baja nijajivi bajarapacuenia pejumaitsiyaniva xamë yabara, jai fariseovi. ");
INSERT INTO guh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nexata Jesús jumaitsi fariseovijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapamonaeje moya itsa najetarubenaejitsipa, nexata juya ibotonë vavajai tsenae tsipae, jai Jesús fariseovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Itsa baja Jesús imoxoyo taeyeta Jerusaléntomara, nexata Jesús sivanua Jerusalén tomarapijivi. ");
INSERT INTO guh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jesús pesivanuejavata Jerusalén tomarapijivi, Jesús jumaitsi Jerusalén tomarapijivi yabara mapacueniaje: —¡Bitso picani jitsipajë Jerusalén tomarapijivi mapamatacabitaje peyapëtaenexa pacuenia Dioso pepacuene jamatabëcuene xanepanaeyaexanaejitsipatsi, itsa nejumecovënëtsipa! Abaxë raja aeconoxae Dioso apo tocopatsitsi peyapëtaeyaniva bajarapacuene. ");
INSERT INTO guh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nexata tocopiapatsianatsi pibisiamatacabi. Pijavajabitsaë tsimaxëpatsianatsi. Nexata pijatomara matatoyorotsia foto yacaranatsia cuerutsianatsi petsimaxënubenaenexatsi bajarapafotota. Pijatomara matatoyorotsia peyacaranatsiibopanaxanetopënëya, pijavajabitsaë foto matatoyorotsia cuenatsi. Bajarapacuenia yacaranatsianatsi pijavajabitsaë. ");
INSERT INTO guh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nexata irabetsica topenetsianatsi pijabonëmi. Nexata daxita Jerusalén tomarapijivi benatsi. Pijatomara matatoyorotsia peyacaranatsiibopanaxanetomi ata tosarababenatsi. Nexata itsaibopana ata apo bocae tsane itsaibopana jumavereca. Bajarapacuenia itsane tsipaji xanë apo neyapëtae Dioso athëbëvetsica taneitorobinëtsica, Daxitajivi Pematapijinënë, jai Jesús pesivanuejavata Jerusalén tomarapijivi. ");
INSERT INTO guh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús pepatsicujinae Jerusalén tomarata, joneya temploboyalia. Nexata templobota Jesús tane pecanajetabiabivi, pecomuacabiabivinua. Nexata daxita bajarapamonae Jesús pitsapaeyaexana templobovecua. ");
INSERT INTO guh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús jumaitsi bajarapamonaejavabelia: —Dioso baja cajena pejumelivaisibaxutota mapatemplobo yabara tajëvelia jumaitsi mapacueniaje: “Tajabo raja jivi xanëjavaberena penavajëcaebo tsane,” jai Dioso pejumelivaisibaxutota. Itsiata baitsi jane paxamë yamaxëitojorobiaya panenacobetoxotsinexa, panacaetuatabiabame mapabotaje, jai Jesús templobota pecanajetabiabivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bajaraxuacujinae caematacabi canacujitsia Jesús jivi livaisi tsipaebabiaba bajarapatemplobota. Nexata sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, tomaraevetsivinua, najumejaita picani Jesús pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Itsiata acuenebi Jesús pebeyaxuabijavatsi. Tsipaji Jesús itsacueneneconi ata apo xainae. Daxitajivi yaiyatanetsi. Jesús jivi petsipaebilivaisianë xaniavaetsia namuxunaevetabiabatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Itsamatacabi Jesús templobota jivi livaisi tsipaeba. Tsipaeba pexanialivaisi jivi pecapanepaelivaisinexatsi pibisiacuene pexanaeneconivecua. Nexata bajarajota pata sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, judíovi pijaancianovinua. ");
INSERT INTO guh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Panetsipaebare cajena. ¿Jipatsa pejamatabëcueneta pecanajetabiabivi, pecomuacabiabivinua, capitsapame mapatemplobovecuaje? jai. ");
INSERT INTO guh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús nexata jumaitsi bajarapamonaejavabelia: —Xanë copiaya caejumeyo pacayanijobianatsi patanejumecanaviatsinexamë. ");
INSERT INTO guh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jipatsa jane pejamatabëcueneta Juanpijinë jivi bautisabaponapona? ¿Dioso tsaja pejamatabëcueneta? Itsa jume, ¿jivi tsaja pejamatabëcueneta? jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nexata ëpamonae nabarëcuaicuaijai. Najumaitsi: —¿De meta pacuenia jumecanaviatsianatsi? Vaxaitsi itsa jumai tsipaetsi: “Dioso raja pejamatabëcueneta,” itsa jai tsipaetsi, nexata Jesús nacajumai tsipae: “¿Detsa nexata xuajitsia apo pajumecovënëtsimë Juanpijinë pepaebilivaisianë?” nacajai tsipae. ");
INSERT INTO guh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Jivi raja saya pejamatabëcueneta Juanpijinë jivi bautisabaponapona,” itsa jai tsipaetsi, nexata daxitajivi anaeya ibotonëta nacatseconaejitsipa vajanacabeyejebinexa. Bajarapacuenia nacabeyejebijitsipa tsipaji daxitajivi Juanpijinë yabara sivajamatabëjumaitsi: “Juanpijinë raja pepacuene Diosojumepaebinëmi,” sivajamatabëjai, najai sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, judíovi pijaancianovinua. ");
INSERT INTO guh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nexata saya bajarapamonae jumaitsi Jesúsjavabelia: —Apo payapëtaenë ponë Juanpijinë itorobatsi jivi pebautisabaponaenexa, jai. ");
INSERT INTO guh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata xanë ata apo pacatsipaebi tsanetsi ponë nitoroba tacapitsapaenexa bajarapamonae templobovecua, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús taxuxuaba livaisi petsipaebijava jivijavabelia. Jumaitsi mapacueniaje: —Pijaira pexainaenë pijairata uba ayaibacaboxaneto uvavënëjava. Bajaraxuacujinae itsamonae evetsiaexana pijauvabacabo. Jumaitsi bajarapamonaejavabelia: “Pamatacabi cuainaveretsiana, natsicobetsanaenatsi. Pamatacabi raja cuainaveretsiana, tajajivitonë itorobiarenajë xua panetotsatsianame tanetopitsinexa,” jai uvabacabo pexainaenë petoevetsivitsijavabelia. Nexata uvabacabo pexainaenë tajënacuayabelia pona bajayajebi piajibitsarucaenexa. ");
INSERT INTO guh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Itsa baja uvabacabo pexainaenë yapëtane pecopiapatsijava uvacuai penaveretsimatacabi penotsinexa, nexata uvabacabo pexainaenë itoroba pijajivitonë. Itoroba petoevetsivitsijavabelia petsicobetsatsinexatsi. Nexata uvabacabo pexainaenë pijajivitonë tovaetabatsi. Toconibabiatsi. Petoconibabecujinaetsi cobesa naviatsiaexanaliatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Itsiata uvabacabo pexainaenë icatsia itoroba itsanë pijajivitonë petsicobetsatsinexatsi. Bajaraponë ata icatsia pibisiacuenia tobijatanetsi. Toconibabiatsi. Peconibabecujinaetsi cobesa naviatsiaexanaliatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Itsiata uvabacabo pexainaenë icatsia itoroba itsanë pijajivitonë. Icatsia bajaraponë ata tomatajorobabiatsi. Uvabacabopënëyabelia xuabatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Nexata uvabacabo pexainaenë jamatabëjumaitsi: “¿Detsa nexata xua exanaenajë? Itorobianajë cajena taxënato, tasivanë. Itsa raeta itorobianajë taxënato, bajarapamonae netoyaiyataena,” jamatabëjai uvabacabo pexainaenë. ");
INSERT INTO guh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Itsiata baitsi jane uvabacabo petoevetsivitsi, uvabacabo pexainaenë pexënato ata apo toyaiyataetsi. Itsa tane uvabacabo pexainaenë pexënato, bajarapamonae najumaitsi: “Mara ponëje itsamatacabi paxa pevënamuto paxa pijauvabacabo pitsipaje. Naxanitsia. Beyaxuabatsi. Nexata raja vaxaitsi vajauvabacabo tsane,” najai uvabacabo petoevetsivitsi. ");
INSERT INTO guh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nexata uvabacabo pexainaenë pexënato ata tovaetabatsi. Caponaliatsi bajarapauvabacabo pepënëyabelia. Bajarapacuenia icatsia tobeyaxuabatsi, jai Jesús. Nexata Jesús yanijoba bajarapalivaisi petsipaebivijavabelia. Jumaitsi: —¿De meta nexata xua exanaena uvabacabo pexainaenë pijauvabacabo petoevetsivitsijavabelia? ");
INSERT INTO guh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uvabacabo raja pexainaenë, patsiarena. Verebiabiana daxita bajarapamonaemi. Nexata icatsia itsamonae evetsiaexanaena bajarapauvabacabo, jai Jesús bajarapamonaejavabelia. Jesús penamuxunaevetsivitsi itsa jumetane bajarapacuenia Jesús pejumaitsijava, bajarapamonae jumaitsi: —¡Dioso pëtsa copata bajarapacuenia pexanaenexa paxanëjavaberena! jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nexata Jesús asaëyata naëcota bajarapamonaejavabelia. Jumaitsi bajarapamonaejavabelia: —Payapëtaneme rabaja pacuenia Dioso pejumelivaisibaxutota tajëvelia jumaitsi xanë yabara. Iboto pelivaisicuenia Dioso pejumelivaisibaxutota jumaitsi xanë yabara mapacueniaje: Paiboto itsamonae boexanaevi naitaxutojematabuatsiana petsitaabejexaetsi itajara, bajarapaiboto itsanë pitsiana. Nexata bajarapaibotota xaniavaetsia nayaëtsiana botabu daxita itsaibo matatoxenetsia, jai tajëvelia Dioso pejumelivaisibaxutota xanë yabara. ’Bajarapacuenia tajëvelia Dioso pejumelivaisibaxutota itsa jumaitsi, judíovi penamatacaitorobivi apo tanejumecovënëtsijavanexa yabara jumaitsi. Dioso taneitapetsijava daxitajivi tacapanepaenënexa yabara ata jumaitsi, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Icatsia Jesús jumaitsi mapacueniaje: —Pamonae apo nejumecovënëtsi Dioso pexënatocuenenë, bajarapamonae bitso bejamatabëjiobi tsane apo tanejumecovënëtsixae. Pacuenia ibotojumata pefirapecaejivi, itsa tsapatecatsi, pevixae bitso yanabejiobita, bajara itsane. Pamonae naneconitsiaexanaenajë, bajarapamonae pepacuene naxuabiana daxitamatacabijavabelianexa. Pacuenia iboto pematacënëbinëtsi apo asaë, bajara itsane, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Palivaisi Jesús tsipaeba templobota, bajarapalivaisi sacerdotevi penamatacaitorobivi, judíovi pecujarubivi ata, jumeyapëtane. Nexata bajarapamonae najumaitsi: —Vaxaitsi raja Jesús nacajai, najai. Nexata picani bajarajota bajarapamonae Jesús jamatabëvaetabatsi. Itsiata bajarapamonae abaxë apo vaetabitsi. Tsipaji cujunava jivi. ");
INSERT INTO guh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nexata itsamatacabi bajarapamonae itorobarena pijajivi yaenebiaya petonamuxunaevetsinexatsi Jesús. Nexata bajarapamonae pijajivi bepexaniajamatabëcuenevi itajara jinavanapa Jesúsjavata. Bajarapamonae namuxunaevetena Jesús jivi livaisi petsipaebijavata. Bijiaya Jesús jivi livaisi itsa tsipaeba, bajarapalivaisi yabara picani Jesús pecaponaenexatsi nacuaevetsinëjavabelia peneconitsinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nexata bajarapamonae jamatabëcueneëjëbiaya jumaitsi Jesúsjavabelia mapacueniaje: —Jesús, pacayapëtanetsi jivi pepacuene pexaniajailivaisi netsipaebijava. Daxitajivi, ricovi ata, bepejiobivi ata, najëpaeya yaiyataeya pexaniajailivaisi tsipaebabiabame bajarapamonae pejinavanapaenexa pacuenia Dioso jitsipa. ");
INSERT INTO guh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Panetsipaebare. ¿Xanepana tsaja vajamatamotsinexa impuestomatamo Romanonacua pepo pevetsinëjavabelia? Itsa jume, ¿apo xanepanae tsaja vajamatamotsinexa? jai bajarapamonae jamatabëcueneëjëbiaya Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Itsiata baitsi jane Jesús jamatabëcueneyapëtane bajarapamonae jamatabëcueneëjëbiaya peyanijobijavatsi peneconitsinexatsi picani. Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Detsa xuajitsia panejamatabëcueneëjëbame? ");
INSERT INTO guh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Panetsitajëre palatanëyo, jai Jesús. Nexata bajarapamonae tsitajëtatsi palatanëyo. Nexata Jesús jumaitsi bajarapamonaejavabelia: —¿Jipatsa mapitabaraje, pevënënua, ruca mapapalatanëyojumataje? jai Jesús. Nexata bajarapamonae jumaitsi Jesúsjavabelia: —Romanonacua raja pepo pevetsinë pitabara, pevënënua, jai. ");
INSERT INTO guh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nexata Jesús jumaitsi bajarapamonaejavabelia: —Nexata parajutabiabianame Romanonacua pepo pevetsinë pijajava. Parajutabiabianame pijinia saicaya Diosojavabelia Dioso pijajava, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nexata bajarapamonae ajibi Jesús peyabaravaetabijavatsi jivijavabelia livaisi petsipaebijava yabara. Tsipaji xaniavaetsia Jesús jumecanaviata bajarapamonae jamatabëcueneëjëbiaya peyanijobijavatsi. Caranata bajarapamonae jamatabëcuenenabenajaca xaniavaetsia Jesús pejumecanaviatsixae bajarapamonaejavabelia. Moya baja nexata ena bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceovi saicaya itsalivaisi xaina. Bajarapamonae jamatabëcuenenavëxaniabiaya jumai tsabiabi: “Petëpaevi rabaja petëpaecujinae, apo asaë icatsia tsane,” jai tsabiabi. Nexata saduceovi imoxoyobatsi Jesús. Saduceovi jumaitsi Jesúsjavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Jesús, Moiséspijinë bajayata vajanacatoyaquinaelivaisi, jumaitsi mapacueniaje: “Ponë pematapijinë pepua penacojiobinë baja, itsa tëpa pexi xainaenejeva, nexata juyapijinë bepita pematapijinëmi pijavami. Bajarapacuenia juyapijinë bepita pematapijinëmi pijavami pexi pexainaenexa bajarapovajavabelia. Nexata pexi itsa xainabeje, bematapijinëmi pexi petaenexa daxitajivi,” jai Moiséspijinë bajayata vajanacatoyaquinaelivaisi. ");
INSERT INTO guh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nexata jinavanapa ënacaemonae, siete ponëbeje. Pepo matapijinë copiata nacojioba. Nexata bajaraponë pijava vecuatëpa pexi xainaenejeva. ");
INSERT INTO guh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nexata pematapijinëmi pepënarucaenë pita pematapijinëmi pijavami. Nexata icatsia bajaraponë ata tëpa pexi xainaenejeva bajarapovajavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nexata icatsia itsanë tuatuajëmatapijinë pita bajarapova. Bajara icatsia ponë ata tëpa pexi xainaenejeva bajarapovajavabelia. Bajarapacuenia daxita baja siete ponëbeje, nacaemonaemi, pitaponae ata bajarapova, itsiata itsanë ata pexi apo xainae bajarapovajavabelia. Bajarapacuenia daxita siete ponëmibeje tëpa. Verevereca baja. ");
INSERT INTO guh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Belia baja bajarapova ata tëpa. ");
INSERT INTO guh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Jivi raja petëpaecujinae, Dioso icatsia asaëyaexanaenatsi,” jamë. ¿Detsa nexata ponë, bajarapamonaeyajuvënënë, pijava tsane bajarapova bajarapamatacabi? Daxita pamonae siete ponëmibeje, nacaemonaemi, pitapona picani bajarapovami, jai saduceovi Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nexata Jesús jumaitsi saduceovijavabelia: —Aeconoxae mapanacuataje pebijivi, petiriavi ata, nacojiobapona. Itsamonae pexënatoyonë pexainaevi pebijavabelia canajetapona petonacojiobinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Itsiata baitsi jane pamonae Dioso itapetatsi, apo pevereverecaenacuatatsia jinavanapaena. Bajarapamonae petëpaecujinae, Dioso icatsia asaëyaexanaenatsi. Bajarapamonae bajarapanacuatatsia apo nacojiobi baja tsane. Bajarajotatsia itsajivi ata pexënatoyo apo canajetsi tsane pebijavabelia petonacojiobinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bajarapamonae acuenebi tsane petëpaejava. Tsipaji bajarapamonae jinavanapaena athëbëtatsia pacuenia ángelevi jinavanapa. Bajarapamonae baja Dioso pexi tsane. Tsipaji baja petëpaecujinae Dioso icatsia asaëyaexanaenatsi. ");
INSERT INTO guh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moiséspijinë bajayata yaquina pacuenia Dioso tsipaebatsi tsiquirinaemëyo petajueyecaecotiajavaverena. Nexata Moiséspijinë peyaquinaelivaisita, jumaitsi pacuenia Dioso icatsia asaëyaexanaejitsia petëpaevimi. Nexata Moiséspijinë nacayapëtaeyaexana Dioso icatsia piasaëyaexanaejavanexa petëpaevimi. Tsipaji baja Abraham pepuatëpae, Isaac ata baja pepuatëpae, Jacob ata baja pepuatëpae, bajarapamonae yabara bajayata Moiséspijinë peyaquinaelivaisita jumaitsi mapacueniaje: “Xanë rabaja Abraham pijaDiosonë, Isaac ata pijaDiosonë, Jacob ata pijaDiosonë,” jai baja cajena Dioso bajayata Moiséspijinëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bajarapacuenia Dioso pejumaitsixae, nayapëtane bajarapamonae bajayata tëpae ata, Diosovecua apo penaxuabijava. Aeconoxae ata bajarapamonae Dioso yajavajinavanapa athëbëtatsia. Daxita petëpaevi Dioso cajena apo tsitatëpaetsi, jai Jesús saduceovijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nexata judíovi pecujarubivi jumaitsi Jesúsjavabelia: —Jesús, saduceovi xaniavaetsia jumecanaviatame, jai judíovi pecujarubivi. ");
INSERT INTO guh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bajaraxuacujinae saduceovi cujunava baja icatsia peyanijobijava Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús pijacuata nayabarajumaitsi judíovi pecujarubivijavabelia mapacueniaje: —¿Detsa xuajitsia jivi apo canaëjëtsi Cristo Dioso pexënatocuene? Jivi saya jamatabëcuenenavëxaniabiaya jumai tsabiabi Cristo yabara: “Cristo raja itsa patsiana, saya Davidpijinë pemomo tsane,” jai tsabiabi. ");
INSERT INTO guh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidpijinë bajayata tajëvelia pejumaitsijava Cristo yabara Salmosvënëbaxutota, jumaitsi mapacueniaje: Dioso jumaitsi tajatuxanenëjavabelia: “Ecare abaxë tacujuanenia. ");
INSERT INTO guh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Vecatsivajënae jumecovënëtsiaexanatsi abaxë copiaya nijavajabitsaë nitorobicuenianexa,” jai Dioso tajatuxanenëjavabelia, jai Salmosvënëbaxutota Davidpijinë bajayata pejumaitsijava Cristo yabara. ");
INSERT INTO guh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Nexata Davidpijinë bajayata Cristo yabara: “Tajatuxanenë,” itsa jai, nexata Cristo Davidpijinë apo pemomo. Tsipaji baja cajena Cristo saicaya Dioso pexënato, nayabarajai Jesús judíovi pecujarubivijavabelia, judíovi pecujarubivi pecanaëjëtsinexa Cristo Dioso pexënatocuene. ");
INSERT INTO guh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Itsa abaxë daxitajivi namuxunaevetatsi Jesús petsipaebilivaisi, Jesús jumaitsi pijajivijavabelia: ");
INSERT INTO guh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Xania, panayajivitaema palivaisi judíovi pecujarubivi tsipaebapona panejumecovënëtsiyaniva. Bajarapamonae jitsipabiaba tomara tuatuajëjava piapiajavanë penaxatababiabavanapaenexa jivi peyaiyataenexatsi. Jitsipabiabanua bitso yaiyataeya pebajacobinexatsi callejava. Bajarapamonae itsa najoneyabiaba judíovi penacaetuatabiabibonëjava, jitsipabiaba penaenexa pexaniaviriajavanëta. Nexata natsiitapetabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. Bajarapamonae itsa napatabiaba fiestajava ata, jitsipabiaba penaenexa peyaiyataevitsi penaenexa petsinubijavanëta. ");
INSERT INTO guh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bajarapamonae yamaxëitojorobiaya vecuanotabiabanua pamonajivi pevecuatëpaevanëtsi pecobecovëjavaxi. Bajarapamonae itajara pinijicuenia vajëcabiaba Diosojavabelia. Itsiata pepo pexaniajaijamatabëcueneta apo vajëcabiabi. Bajarapacuenia vajëcabiaba saya jivi petaenexatsi Dioso itajara bitso bepejumecovënëtsivi. Nexata bajarapamonae bitso pinijicuenia Dioso naneconitsiaexanaenatsi pamatacabi Dioso naneconitsiaexanaena daxita pamonae Dioso apo pejumecovënëtsivi, jai Jesús pijajivijavabelia judíovi pecujarubivi yabara. ");
INSERT INTO guh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Templobota Jesús cobetane bitso pexainaevi ayaijava palata pejeponaejava cajonijavabelia. Bajarajota jivi palata jeyabiaba ofrendacuenia perajutsijava Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bajarajota Jesús cobetanenua pamona pevecuatëpaevatsi, bepejiobiva, penajejava anijapalatanëyobeje. Bajarapova najia anijapalatanëyobeje piamatamobinëyobeje. ");
INSERT INTO guh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús nexata jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Mapovaje pamona pevecuatëpaevatsi bejiobi bitso. Xuayo jia cajonita ofrendacuenia perajutsinexa Diosojavabelia, bajaraxuayo bitso Dioso sivajamatabëcuenebarëya daxita xua itsamonae jia bajarapacajonita matatoxenetsia. ");
INSERT INTO guh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsipaji rabaja xua bajarapamonae apo namatavenonae, jia bajarapacajonita ofrendacuenia perajutsinexa Diosojavabelia. Itsiata mapovaje, bepejiobiva, daxitajavayo penaevetsijavayotaminexa jia bajarapacajonita ofrendacuenia perajutsinexa Diosojavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jerusalén tomarata templobo itabëtsiaya exaneta pexaniaviriaibotonëta. Jivi Diosojavabelia ofrendacuenia perajutsijavanë ata, templobota itabëtsiaya ruba templobo pitaitabëtsecaenexa. Nexata Jesús pijajiviyajuvënëvi nabarëcuaicuaijai tsaponae templobo pitabëtetsijava yabara. Nexata Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsanacuapijivi xuabijitsiatsica templobo, daxita bajarapaaitabëcuene yajava. Jesús jumaitsi pijajivijavabelia mapacueniaje: ");
INSERT INTO guh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Itsamatacabi itsanacuapijivi xuabianica mapatemplobomije. Nexata daxita xua pataneme, pitabëcuene yajava, penetsianica. Nexata templobopijiibotonë caeiboto ata pejumavereca apo bocae tsane, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesús pijajivi jumaitsi: —Patajatuxanenë, pajitsipajë patanetsipaebijavamë patayapëtaenexa paepatota copiapatsijitsia xua vajunupaebame. ¿Detsa pitsicuene peneta pataenajë itsa copiapatsijitsia xua jumaitsimë templobo yabara? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús nexata tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús pijajivijavabelia jumaitsi mapacueniaje: —Xania panayajivitaename. Pëtsa panacopatame itsajivi ata papecayamaxëitojorobinexa. Tsipaji raja peyamaxëitojorobinexa, ayaibitsaëto patsiana bexanë itajara tsane. Bajarapamonae najumetsënëtsiaya jumai tsane: “Xanë raja Cristonë, athëbëvetsica Dioso taneitorobinëtsica jivi tacapanepaenexa,” jai tsane. “Imoxoyo rabaja pevajënae nacua pevereverecaenexa,” jai tsane itsamonae. Itsiata pëtsa pajumecovënëtame bajarapamonae. Pëtsa papënaponamenua. ");
INSERT INTO guh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Vajabitsaë pexanaejava imoxoyonacuanëjava, tajënacuanëjava ata, pavënëlivaisitaename. Itsiata pëtsa pajunavame. Peneta bajara itsane mapanacua pevereverecaevajënaeje. Itsiata baitsi jane bepijia bajarapamatacabi mapanacuaje abaxë apo vereverecajuni tsane, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuata. ");
INSERT INTO guh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús icatsia tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Mapanacuaje pevereverecaevajënae, peneta copiaya itsaviriavi nabena itsaviriavijavabelia. Itsanacuanëpijivi pijinia nabena itsanacuanëpijivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ira najëabiana ayaicuenia nacuanëjava. Nacuanëjava ayaijaniboxaneto najetarucaena, piavitanecuene yajava. Itaboxotatsia pitsapaena piayaijunavicuene, pinijicuene pexanaejavanë yajava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Icatsia Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Bajarapacuene pecopiajopaevajënaeya patajajivixaemë, pacataicaena. Pacabejiobiaexanaena. Pacacaponaena judíovi penacaetuatabiabibonëjavabelia papecaneconitsinexa. Penaneconitsivi pejebabiabibota pacajebiana. Patajajivixaemë, pacanubiana presidentevi pitabarata, nacuaevetsivi pitabarata ata. ");
INSERT INTO guh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nexata bajarajota xanë talivaisi, pexanialivaisi, patsipaebianame xaniavaetsia. ");
INSERT INTO guh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nexata pëtsa tajëvelia panatsinajamatabëxainame pacuenia panayajivicuaicuaijamëjitsia bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tsipaji paepatota panayajivicuaicuaijamëjitsia, bitso peyapëtaevicuenia pacacuaicuaijaiyaexanaenatsi. Nexata caenë ata panijavajabitsaënë apo caëjëpaetsi tsane papecajumecanaviatsinexa. ");
INSERT INTO guh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bajarapamatacabi patajajivixaemë, panacaemonae atamë, itsajivi panijamonaejivi ata pacacanajetsiana nacuaevetsivijavabelia papecabeyaxuabinexa. Paneaxa ata, paneena ata, panijabanajivi ata, bitso papecayapëtaejivi ata, bajarapamonae caranata pacacanajetsiana. Nexata pacayajuvënëbeyaxuabiana. ");
INSERT INTO guh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Daxitajivi pacaitoya tsabiabi tsane patajajivixaemë. ");
INSERT INTO guh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Itsiata baitsi jane pepo panejamatabëcuenelivaisi bajarapamonae apo itsacueniabi tsane. ");
INSERT INTO guh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Itsa pajamatabëcuenesaëmë tsavanapae tsane, nexata matacabi apo pevereverecaejava paxainaename, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Icatsia Jesús tajëvelia vajunupaeba papiayaicuene itsamatacabi copiapatsijitsia Jerusalén tomarata, Jesús jumaitsi pijajivijavabelia mapacueniaje: —Itsa pataename vajabitsaë, itsanacuaverena pepatsivi, Jerusaléntomara matatoyorotsia peyacaranatsijavatsi, nexata pajamatabëitsimë tsane: “Imoxoyo rabaja pevajënae Jerusaléntomara pevereverecaenexa,” pajamatabëjamë tsane. ");
INSERT INTO guh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nexata bajarapamatacabi Judea nacuata pejinavanapaevi, itsa tane bajarapacuene, berëcëpeca cajena ibotsutonëjavabelia. Jerusalén tomarapijivi ata berëcëpeca pijatomaravecua. Itsamonae pijinia, Jerusalén tomarapijivi, bajarapamatacabi Jerusalén tomarapënëyabelia itsa jinavanapa, apo benaviabirena pijaboyaberena. ");
INSERT INTO guh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bajarapacuenia Jerusalén tomarapijivi itsa tocopiajopaenatsi, tocopiajopaenatsi jane baja Dioso penaneconitsiaexanaematacabitsi. Nexata jane baja tocopiajopaenatsi daxita pacuenia baja cajena pepo bajayatami tajëvelia vajunupaeba Diosojumelivaisibaxutota. ");
INSERT INTO guh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bajarapavajabitsaëmatacabi bitso ayaicuenia bejiobi tsane mapanacuapijivije. ¡Papetiriavi penacueto yacotajinavanapa, bitso bejiobi tsane bajarapamatacabi bitso nabejiobitsiaya peponaexae tsane! ¡Papetiriavi ata mitoapaenacuetoxi isajinavanapa, bitso bejiobi tsane bajarapamatacabi! Bajarapacuenia daxita mapanacuapijivije pinijicuenia Dioso naneconitsiaexanaenatsi. ");
INSERT INTO guh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bajarapavajabitsaëmatacabi itsanacuaverena Jerusalén tomarapijivi vajabitsaë tsimaxëpatsianatsi. Nexata itsabitsaëtomi, Jerusalén tomarapijivimi, beyejebianatsi. Itsabitsaëtomi pijinia, Jerusalén tomarapijivimi, caponaenatsi itsanacuanëjavabelia. Nexata bajaraxuacujinae itsanacuanëpijivi patsiana Jerusalén tomarata. Nexata juya bajarapamonae jinavanapaena Jerusalén tomarata. Nexata itsanacuaverena pepatsivi evetsiana Jerusaléntomara. Matapania daxita itsanacuaverena pepatsivi vecuapitsapaena Jerusaléntomara, copatsiana baja bajarapamonae pevetsijava Jerusaléntomara, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata papiayaicuene itsamatacabi copiapatsijitsia Jerusalén tomarata. ");
INSERT INTO guh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús tajëvelia navajunupaeba itsamatacabi icatsia pepatsijavanexatsica. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Xanë tapatsivajënaetsica, jivi taena pecujunavicuene. Matacabipijijuametotatsia, xua naitajëtsiana, meravipijijuametotatsia ata, xua naitajëtsiana, tulupujavatatsia ata, xua naitajëtsiana, bajaraxuanë jivi bitso cujunaviana. Daxita nacuanëpijivi bitso najunaviacaena itsa jumetaena manuameneta pinijimalataca bitso penajumetsijava. ");
INSERT INTO guh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Daxitanacuanëjava bitso jivi najamatabëxainaena itsa taena piayaicuene petocopiajopaejavatsi. Nexata daxita nacuanëjava jivi tëpajoneyabiabiana pecajunavi. Daxita xua athëbëtatsia rubena, najëabiana. Xaniavaetsia apo rubenae tsane. ");
INSERT INTO guh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nexata bajarapaepatota jivi netaena, Daxitajivi Pematapijinënë, athëbëvetsica itarërëbota tanajetarucaejava. Patsianicajë daxitacuene taevetsinexa. Tanivenivenaecotia yajavapatsianicajë. ");
INSERT INTO guh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Itsa pataename pecopiajopaejava bajarapacuene, nexata panajamatabëcuenesaëtsianame. Tsipaji rabaja imoxoyo pevajënae tsane papecacapanepaenexa jivi papecabejiobia exanaebiabijavamivecua, jai Jesús pijajivijavabelia tajëvelia penavajunupaebijavata itsamatacabi icatsia pepatsijavanexatsica. ");
INSERT INTO guh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Icatsia Jesús tajëvelia vajunupaeba pacuenia itsamatacabi itsijitsia mapanacuataje. Jesús jumaitsi pijajivijavabelia mapacueniaje: —Pacanaëjëre pacuenia itsi higueranae, itsavirianaenë ata. ");
INSERT INTO guh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Itsa baja imoxoyo pevajënae tsaponae vai pejonejavanexa, bajaraponaenë pejanabaxu juva. Nexata bajarapacuenia payapëtaneme vai baja imoxoyo pevajënae pejonejavanexa. ");
INSERT INTO guh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bajara pijinia pacuenia peneta itsa pataename pecopiapatsijava xua yabara pacatsipaebatsi, nexata payapëtaename imoxoyo baja pevajënae pecopiapatsijavanexa tsane pamatacabi daxita Dioso pijajivi evetsijitsia mapanacuataje, jai Jesús pijajivijavabelia tajëvelia pevajunupaebijavata pacuenia itsamatacabi itsijitsia mapanacuataje. ");
INSERT INTO guh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Icatsia Jesús jumaitsi pijajivijavabelia: —Xaniajanë pacuenia pacatsipaebijitsiatsi. Pitsijamatabëcuenevi aeconoxae mapamatacabitaje jinavanapa, bajarapitsijamatabëcuenevi abaxë, bexëajavabelia ata, apo vereverecae tsane. Matapania xua yabara pacatsipaebatsi itsa baja copiapatsiana, bajarapamonae jane baja vereverecaena. ");
INSERT INTO guh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“Itaboxo, ira yajava, tsitecaena daxitamatacabijavabelianexa,” jamatabëjai ata tsane itsamonae, itsiata jamatabëcuenenavëxaniabiana. Tsipaji jemata itaboxo, ira yajava, vereverecaena. Nexata palivaisi pacatsipaebatsi, apo najumetsënëtsinë tsane. Nexata xua yabara pacatsipaebatsi, pacuenia baja najumecapanepaeya jumaitsinë, daxita bajaraxua copiapatsiana, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Icatsia Jesús jumaitsi pijajivijavabelia: —Nayajivitaeya pajinavanapaename. Pëtsa panajamatabëxainame pibisiacuene paneexanaenexa, paneaitajibinexa ata. Pëtsa pasivanajamatabëxainame maëpanacuapijijamatabëcueneje. Belia bajarapacuenia paneexanavanapaejavata, jemata copiapatsipa tapatsimatacabinexatsica. ");
INSERT INTO guh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pacuenia dujuai peyamatajucaejava, meniareca jemata jivi xuareca dujuai peyamatajutsinexa, bajara pijinia pacuenia xanë tapatsimatacabinexatsica, jemata daxitanacuanëjava copiapatsiana. ");
INSERT INTO guh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bajaraxuata nayajivitaeya pajinavanapaename. Daxitamatacabi canacujitsia panayajivivajëcabiabianame Diosojavabelia paneajamatabëcuenesaë tsaponaenexa, panevecuapanepaponaenexa daxita papibisiacuene pacatocopiapataponaena. Daxita bajarapapibisiacuene panevecuapanepaecujinae ata, pavajëcabiabianame Diosojavabelia. Nexata pamatacabi xanë, Daxitajivi Pematapijinënë, patsianicajë, papecacaëjëpaenexa panenubenaejava taitabarata, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Caematacabi canacujitsia Jesús livaisi tsipaebabiaba templobota. Nexata icatsia caemeravi canacujitsia Jesús tomaravecua pitsapabiaba pemajitabiabinexa petsutojumabelia. Nexata patsutojumata olivonaenë nubena, bajarapatsutojumata Jesús majitabiaba. ");
INSERT INTO guh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Daxita bajayacunua canacujitsia jivi patabiaba templobota penamuxunaevetabiabinexatsi Jesús petsipaebilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Imoxoyo baja pevajënae pejonenexa pascuavënëfiesta. Bajarapafiestamatacabi jivi baxane levadurata matajërëabinejeva pexanaepan. ");
INSERT INTO guh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdotevi penamatacaitorobivi, judíovi pecujarubivinua, najumejaita pacuenia picani bajarapamonae Jesús beyaxuabijitsiatsi. Itsiata abaxë bajarapamonae Jesús apo beyaxuabitsi. Tsipaji bajarapamonae jivi cujunava. ");
INSERT INTO guh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nexata dovathi tsijamatabëjunuatsi Judas. Judas, ponë vënërubatsi itsavënë, Iscariote. Bajaraponë Jesús pijajivi, doce ponëbejeyajuvënënë. ");
INSERT INTO guh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas yapëtane itsajota nacaetuata sacerdotevi penamatacaitorobivi, templobopijipolicíavi penamatacaitorobivi yajava. Nexata bajarabelia Judas pona pebarëcuaicuaijainexa bajarapamonae. Nexata Judas tsipaeba pacuenia rajutsijitsia Jesús bajarapamonae pecobeyabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nexata bajarapamonae barëya. Rajutsiapaebatsi palata. ");
INSERT INTO guh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jejai Judas. Nexata Judas Jesús naitaxutocaevetsia ponapona. Paepatota Judas toyapëxanepanatsi, perajutsinexa jane baja Jesús bajarapamonae pecobeyabelia. Bajarapacuenia Judas najamatabëxaina pexanaenexa itsajota bitso jivi apo navitsi. ");
INSERT INTO guh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Junua jane baja pascuavënëfiesta, pafiestamatacabi jivi baxane levadurata matajërëabinejeva pexanaepan. Bajarapamatacabi ovejaxi babia pexaenexa pascua fiestamatacabi. ");
INSERT INTO guh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nexata Jesús itoroba pijajivitonëbeje, Pedrobeje Juanbeje. Jesús jumaitsi pijajivitonëbejejavabelia: —Paponarebeje paneexanaenexabeje vajaxaejavanexa. Xua jivi baxane pascua fiestamatacabi, bajaraxua vajaxaenexa paexanaenamebeje, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nexata Pedrobeje Juanbeje jumaitsibeje Jesúsjavabelia: —¿Detsa jota jitsipame bajaraxua pataexanaenexabeje? ¿Detsajota bajaraxua xaenatsi? jaibeje. ");
INSERT INTO guh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús nexata jumaitsi pijajivitonëbejejavabelia: —Tomarabelia itsa papatsianamebeje, pacaxitajarabianamebeje mera canalito pecanajetarucaenë. Bajaraponë papënanajetarucaenamebeje. Pabota bajaraponë joneyojopaena, bajarapabota panapatsianamebeje. ");
INSERT INTO guh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nexata pajumaitsimëbeje tsane bajarapabo pexainaenëjavabelia: “Vajanacacujarubinë raja Jesús jumaitsi: ‘¿Detsa jota pënëyatuucutsibo eca, pabota tajajivi barëxaejitsianë xua jivi baxane pascua fiestamatacabi?’ jai raja Jesús,” pajamëbeje tsane bajarapabo pexainaenëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nexata athëbëabetsia anijairabeje pexainaebojavata, pacatsitajëtsianabeje. Bajarapaboënëta, athëbëyotsia paira, ayaiënëtuatuajë tsane. Daxitacuene bajarajota xainaena. Nexata xua jivi baxane pascua fiestamatacabi, bajarajota paexanaenamebeje vajaxaenexa, jai Jesús pijajivitonëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nexata jane baja bajaraponëbeje ponabeje. Caxitajarababeje daxita pacuenia Jesús jumaitsi. Nexata xua jivibaxane pascua fiestamatacabi, daxita Jesús pijajivi pebarëxaenexa, bajaraponëbeje exanabeje jane baja. ");
INSERT INTO guh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Itsa baja copiajopa pexaeepatotanexa, Jesús, pijajivi doce ponëbeje, apóstolevi, yajava, eca mesa muxuneneta. ");
INSERT INTO guh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nexata Jesús jumaitsi pijajivijavabelia: —Tatëpaevajënae bitso jitsipajë patacayajavaxaejava mapapascua fiestamatacabi pexaejavaje. ");
INSERT INTO guh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Xaniajanë pacuenia pacatsipaebijitsiatsi. Matavëjëa rabaja mapanacuataje apo xaenë tsane pascua fiestamatacabi pexaejava. Matapania daxita patajajivimë Dioso itsa pacacapanepaena panijaneconivecua, bajara jane icatsia matapania taxa Dioso pijanacuatatsia xaenajë pascua fiestamatacabi pexaejava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nexata Jesús copavënëjavata yapita pijajivi pebarëapaeranexa. Jesús jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame maporaje, jai Jesús. Bajaraxuacujinae pijajivijavabelia jumaitsi: —Maporaje payapire. Papaema padaxitamë mapacopataje. ");
INSERT INTO guh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Xaniajanë pacuenia pacatsipaebijitsiatsi. Matavëjëa rabaja mapanacuataje apo apaenë tsane uvacuaira. Matapania itsa copiajopaena daxita Dioso pijajivi pevetsimatacabi, apaenajë icatsia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bajaraxuacujinae Jesús pita panbë. Jesús jumaitsi Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pan, jai Jesús. Bajaraxuacujinae epatsënëquejeba bajarapapanbë. Rajuta pijajivi. Jesús jumaitsi pijajivijavabelia: —Paxaema. Mara tavitoje, patacasivatëpaejava paxamënexa. Tatëpaecujinae mapacuenia paexanabiabianameje patanenajamatabënapitabiabinexamë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nexata jane baja daxita Jesús pijajivi barënabane. Penabanicujinae Jesús icatsia yapita pijajivi pebarëapaeranexa. Jesús jumaitsi pijajivijavabelia: —Dioso baja cajena najumecapanepaeya jumaitsi pejanalivaisi papecacapanepaenexa bajaraponëjavabelia. Bajarapacuenia pacacapanepaena tajana pejamatabëcueneta. Tajana raja runaena papecacomuatsinexa pibisiacuene paneexanaeneconimivecua. Mapacapaejavataje padaxitamë papaema panenajamatabënapitabiabinexa pacuenia Dioso bajarapapejanalivaisita najumecapanepaeya jumaitsi papecacapanepaenexa bajaraponëjavabelia, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Icatsia Jesús jumaitsi pijajivijavabelia: Panejumetaema. Ponë necanajetsijitsia tajavajabitsaë pecobeyabelia, bajaraponë naeca mapamesa muxunenetaje. ");
INSERT INTO guh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xanë, Daxitajivi Pematapijinënë, tëpaenajë pacuenia tajëvelia Dioso netocopata. Itsiata baitsi jane ponë necanajetsiana tajavajabitsaë pecobeyabelia, bitso bejiobi tsane, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nexata Jesús pijajivi najumai tsenae: —¿De meta ponë vaxaitsiyajuvënënë, canajetsiana Jesús pijavajabitsaë pecobeyabelia? najai tsenae Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesús pijajivi anaeya najumenotsiaya nalivaisita. Najumaitsi: —¿Detsa ponë vaxaitsiyajuvënënë nacavecuaayaijamatabëcuenenë? najai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nexata Jesús jumaitsi pijajivijavabelia: —Nacuaevetsivi pacuenia jamatabëpacaitoroba panetoexanaenexa, ajumesaëya pacaitorobabiaba papijajivimë, bajarapamonae pevetsinacuanëjava panejinavanapaevi. Itsiata baitsi jane bajarapacuenia pacabejiobiaexanabiabi ata, bajarapamonae jitsipabiaba paxamë bajarapamonae yabara panejumaitsinexa: “Bajaraponë vajanacayanacuaevetsinë, bitso pexaniacuene nacatoexanabiaba,” panejainexa. ");
INSERT INTO guh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pëtsa paxamë bajarapamonae cuenejëpaeya bepaayaijamatabëcuenevimë panataneme. Ponë raja peneta paxamëyajuvënënë daxita paxamë pacavecuaayaijamatabëcuenenë, bajaraponë peneta daxitajivi bepijajivitonëcuenia yavenonaena. ");
INSERT INTO guh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mapanacuata petuxanenë itsa xaeyeca mesata, petuxanenë jamatabëcueneevetatsi pijajivitonë. Tsipaji petuxanenë ayaijamatabëcuenenë pijajivitonë matatoxenetsia. Itsiata xanë bajarapitsijamatabëcuene apo xainaenë. Ponaponajë paxamëjavata daxita paxamë bepanijajivitonënëcuenia patacayavenonaenexa, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Icatsia Jesús jumaitsi pijajivijavabelia: —Pacuenia jivi nitoya, nebejiobiaexananua, bajarapacuenia paxamë ata patajajivixaemë, pacaexana. Bajarapacuenia pacaexanae ata tsane, itsiata apo panenavecuacopabimë tsane. Tsitecaeya paneyajavajinavanapame. ");
INSERT INTO guh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bajaraxuata nexata pacuenia taxa Dioso nitoroba jivi taevetsinexa, bajara pijinia pacuenia juya xanë ata paxamë pacaitorobatsi jivi paneevetsivinexa. ");
INSERT INTO guh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nexata paxamë pacajamatabëcuenecaëjëpaena taevetsinacuatatsia tajamesata panenanabaninexa, panenamatavëjëaapaenexanua. Paenaename jueznëcuenia panenaneconitsiaexanaenexa pijaneconi pexainaevi. Nexata pananeconitsiaexanaename Israelpijinëmi pexi, doce ponëmibeje, pemomoxiyajuvënëvi, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús jumaitsi Pedrojavabelia: —Simón, dovathi baja cajena jamatabëcapita xanëvecua. Bitso cajamatabëcueneëjëbiana tanenavecuacopatsinexamë. Pacuenia arrozxainaenë arrozxu jëaba pesi pevecuaxuabinexa, bajara pijinia pacuenia pecaxuabinexa xanëvecua cajamatabëcueneëjëbiana dovathi. ");
INSERT INTO guh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Itsiata baitsi jane catovajëtatsi Diosojavabelia necopatsiyaniva tanejumecovënëtsijavamë. Itsa navecuapaebianame nenaneconitsijava Diosojavabelia, nexata jane baja bajaraxuacujinae jamatabëcuene babataponaponaename Dioso pejumecovënëtsivi, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro nexata jumaitsi Jesúsjavabelia: —Tajatuxanenë, najamatabëcueneveretajë baja. Penaneconitsivi pejebabiabibota caetsi ata, tanaponaponaenexa xamëta. Najamatabëcueneveretajë baja tacayajavatëpaenexanua, jai Pedro Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nexata icatsia Jesús jumaitsi: —Pedro, xaniajanë pacuenia catsipaebijitsiatsi. Ajena, mapameravitaje, vacara pefiabivajënaeya nayavajunuaxainaename tajajivitonëcuenemë. “Xanë cajena apo yapëtaenë bajaraponë,” jamë tsane acueyabi xuabeje xanë yabara, jai Jesús Pedrojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús yanijoba pijajivijavabelia. Jesús jumaitsi mapacueniaje: —Imata panamuto itsa pacaitorobatsi Dioso pejumelivaisi jivi daxitanacuanëjava panetsipaebanajetarubenaenexa, pacaitavetatsi panecaponaeyaniva doro, palata ata, zapato ata. ¿Bajarapamatacabi panamatavenoname tsaja itsacuenejava? jai Jesús pijajivijavabelia. Nexata Jesús pijajivi jumaitsi: —Jume. Apo panamatavenonaenë cajena itsacuenejava ata bajarapamatacabi, jai. ");
INSERT INTO guh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús nexata jumaitsi: —Baja rajane aeconoxae panamuto, pajivi doro xaina, bajarapajivi caponae pijadoro. Palata ata caponae. Pajivi espada apo xainae, bajarapajivi penajumaxuabipana canajetsi. Comuatsi espada. ");
INSERT INTO guh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Xaniajanë pacuenia pacatsipaebijitsiatsi. Pacuenia xanë yabara Diosojumelivaisibaxutota tajëvelia jumaitsi, bajarapacuenia netocopiapatsiana. Dioso pejumelivaisibaxutota tajëvelia xanë yabara jumaitsi mapacueniaje: “Naneconitsiaexanaenatsi bepibisiacuene pexanaenëcuenia,” jai tajëvelia xanë yabara Diosojumelivaisibaxutota. Nexata bajarapacuene imoxoyo baja pevajënae tanetocopiapatsinexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nexata Jesús pijajivi jumaitsi: —Tajatuxanenë, mara anijaespadabejeje, jai Jesús pijajivi. Nexata Jesús jumaitsi pijajivijavabelia: —Xanepana rabaja, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús pitsapa bovecua. Pacuenia ponabiaba, bajarapacuenia icatsia pona petsutojumabelia. Patsutojumata olivonaenë apaaxayo, bajarapatsutojumabelia pona. Nexata Jesús pijajivi pënaponatsi. ");
INSERT INTO guh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jesús pijajivi itsa barëpata bajarapatsutojumabelia, Jesús jumaitsi pijajivijavabelia: —Pacajamatabëcueneëjëbiana raja dovathi pejamatabëcueneta. Pavajëtaponare aeconoxae Diosojavabelia paneajamatabëcuenesaënexa panecopabiyaniva patanejumecovënëtsijavamë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nexata Jesús pijajivi vecuanatixilia bejamatabëcuene treinta metro. Jesús nucajunua pematabacabëta pevajëtaponaenexa Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesús pevajëtsijavata jumai tsaponae Diosojavabelia: —Taxa Diosomë, netocopatame picani tanebeyaxuabinexa betajiobicueneta. Itsa jitsipame, necapanepare bajarapabejiobicuenevecua. Itsiata xanë apo tajitsipaecuene ata, pacuenia xamë jitsipame, netocopatsianame, jai Jesús pevajëtsijavata Diosojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nexata Jesús athëbëpijiángel tsitanaitajëtatsi pejamatabëcuene asaëyaexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús pebeyaxuabijavanexatsi yabara, bitso natsinajamatabëxaina. Nexata Jesús bitso orijibia asaëyata vajëtapona Diosojavabelia. Jesús bitso janetatsi. Pacuenia itsi pijana, bajara itsi Jesús pejanetsibarëmenetsi. Topitopijai irabereca. ");
INSERT INTO guh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesús pevajëtsicujinae itsa nonotapuna, lia pijajivijavabelia. Nexata Jesús pijajivi caxitajaraba pemajitanubenaevi. Tsipaji Jesús pijajivi bitso penajamatabëxainaejava, cuerana. ");
INSERT INTO guh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia pamajitanubename? Panonobapunare. Pavajëtaponare Diosojavabelia, dovathi pejamatabëcueneta pacajamatabëcueneëjëbi ata paneajamatabëcuenesaënexa, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús pijavajabitsaë pevaetabijavatanexatsi, cuaicuaijai tsanucae pijajivijavabelia. Nexata bajarapaepatota jivi ayaibitsaëtoxaneto, Jesús petsimaxëponaevitsi, najetarubena. Ponë vënërubatsi Judas, Jesús pijajivi doce ponëbejeyajuvënënëmi, matacanajetaruca bajarapamonae. Nexata Judas najetabalia Jesúsjavabelia. Itabaratsutsuniaya bajacobatsi. ");
INSERT INTO guh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nexata Jesús bajarajota jumaitsi Judasjavabelia. —Judas, ¿matsa pacuenia nitabaratsutsuniaya nebajacobame xanë, Daxitajivi Pematapijinënë, tanecanajetsinexamë tajavajabitsaë pecobeyabeliaje? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús pijajivi itsa tane pacuenia Jesús exanaejitsiatsi, nexata bajarapamonae jumaitsi Jesúsjavabelia: —Tajatuxanenë, ¿namaxëvanitsianatsi tsaja espadata? jai Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nexata caenë Jesús pijajiviyajuvënënë namaxëvanita. Sacerdotevi pepo penamatacaitorobinë pijajivitonë muxuyoropaebiaxuaba pecujuanenia pamuxuyoroto. ");
INSERT INTO guh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nexata Jesús jumaitsi pijajivitonëjavabelia: —Copabare baja, jai Jesús. Nexata Jesús bajaraponë muxuyorojayataba. Jesús baja muxuyororuta icatsia bajaraponë. ");
INSERT INTO guh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pamonae Jesús tsimaxëpatatsi, itsamonae sacerdotevi penamatacaitorobivi, itsamonae templobopijipolicíavi penamatacaitorobivi, itsamonae judíovi pijaancianovi. Bajarapamonae caponaejitsiatsilia Jesús. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Paxamë meta panetaneme betanacobetoxotsinë. Bajaraxuata pacaponame espadanë, naebonë yajava, patanevaetabinexamë pacuenia pavaetababiabame penacobetoxotsinë. ");
INSERT INTO guh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Xanë caematacabi canacujitsia Dioso pejumelivaisi paxamëjavabelia pacatsipaebabiabatsi templobota. Itsiata bajarapamatacabi apo panevaetabimë. Nexata mapaepatotaje panetsimaxëpatame dovathi, jivi piajamatabëcuene itaquiriyaexanaenë, papecaitorobixae, jai Jesús petsimaxëpatsivitsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesús pevaetabicujinaetsi, caponaliatsi sacerdotevi pepo penamatacaitorobinë pijaboyabelia. Nexata Pedro bajarapamonae pecovëvelia tajiyo pënanajetaruca. ");
INSERT INTO guh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nexata pabota Jesús capatatsi, bajarajota, panabo tuatuajëta, vajabitsaë isoto itajuruteta. Bajarapamonae isoto matatoyorotsia ena. Pedro nexata naitaxutocaevetsiaya naeca bajarapamonaejavata. ");
INSERT INTO guh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nexata bajarapabota penacuenebiva, Pedro itsa taeyetatsi penanonopecaejavata isoto muxuneneta, naitaxutobabatsia asaëya taenucatsi. Nexata itsamonaejavabelia bajarapova jumaitsi Pedro yabara: —Mara ponë ata Jesús pijajivitonëje, jai bajarapova. ");
INSERT INTO guh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nexata Pedro jumaitsi bajarapovajavabelia: —Jume raja. Xanë cajena apo yapëtaenë bajaraponë, jai Pedro bajarapovajavabelia Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bajaraxuacujinae icatsia itsajivi Pedro taeyetatsi. Bajarapajivi ata icatsia jumaitsi Pedrojavabelia: —Xamë ata rabaja cajena Jesús pijajiviyajuvënënëmë, jai. Nexata Pedro jumaitsi bajarapajivijavabelia: —Jume raja. Xanë raja cajena apo Jesús pijajiviyajuvënënënë, jai Pedro. ");
INSERT INTO guh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bejamatabëcuene caehoracujinae, icatsia itsanë jumaitsi: —Xaniajai rabaja cajena. Maponëje Jesústa naponaponaje. Tsipaji rabaja bajaraponë ata Galilea nacuapijinë, jai bajaraponë Pedro yabara. ");
INSERT INTO guh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nexata Pedro nayajumetane. Pedro nexata jumaitsi bajaraponëjavabelia: —Apo yapëtaenë cajena pacuene yabara jumaitsimë, jai Pedro. Bajarapacuenia Pedro pejumaitsijavata, vacara baja fiaba. ");
INSERT INTO guh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nexata Jesús boverena namuxufeta Pedrojavaberena. Taeyerenatsi Pedro. Nexata bajarapaepatota Pedro najamatabënapitajaraba Jesús pejumaitsijavatsi: “Pedro, ajena, mapameravitaje, vacara pefiabivajënaeya nayavajunuaxainaename tajajivitonëcuenemë. ‘Xanë cajena apo yapëtaenë bajaraponë,’ jamë tsane xanë yabara acueyabi xuabeje,” pejaijavatsi Jesús, najamatabënapitajaraba Pedro. ");
INSERT INTO guh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nexata baja Pedro pitsapalia bopanabovecua. Pinijicuenia nua. ");
INSERT INTO guh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pamonae Jesús vaetabatsi, capocaponatsi. Itabaratsaquibabeponatsi pecobethaitonëta. ");
INSERT INTO guh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Papaëbërëpanata itaxutocëtatsi. Pitaxutocëtsicujinaetsi icatsia itabaratsaquibabeponatsi pecobethaitonëta. Nexata bajarapamonae jumai tsaponae Jesúsjavabelia: —¡Vënëjonare ponë caitabaratsaquibaba! jai tsaponae. ");
INSERT INTO guh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pibisiacuenianua bajarapamonae jumai tsaponae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ajena baja matacabi tsarucaponae, nacaetuata judíovi pijaancianovi, sacerdotevi penamatacaitorobivi yajava, judíovi pecujarubivi yajava. Nexata Jesús caponarenatsi bajarapamonae penacaetuatsijavaberena. Bajarajota bajarapamonae jumaitsi Jesúsjavabelia: ");
INSERT INTO guh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Panetsipaebare. ¿Xamë tsabaja rovia Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenënexa? jai bajarapamonae. Nexata Jesús jumaitsi bajarapamonaejavabelia: —“Xanë rabaja Cristonë, athëbëvetsica Dioso taneitorobinëtsica jivi tacapanepaenexa,” pacajai atatsi tsipae, itsiata apo panejumecovënëtsimë tsipae. ");
INSERT INTO guh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Itsalivaisiyo pacayanijobi atatsi tsipae, itsiata apo panejumecanaviatsimë tsipae. Apo panecopatsimënua tsipae. ");
INSERT INTO guh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Itsiata baitsi jane tavajënaeyabelia xanë, Daxitajivi Pematapijinënë, ecaenajë taxa Dioso pecujuanenia patanajuaevetsinexabeje daxitacuene. Bajaraponë pecaëjëpaenëtsi daxitajamatabëcuene, jai Jesús bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nexata daxita bajarapamonae jumaitsi Jesúsjavabelia: —¿Xamë tsabaja Dioso pexënatomë? jai bajarapamonae. Nexata Jesús jumaitsi bajarapamonaejavabelia: —Jãjã, xanë rabaja pacuenia panejumaitsimë. Bajaraponënë, jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nexata bajarapamonae najumaitsi: —Ajibi rabaja abaxë vajaevetaponaejava jivi neconitsiaya vajanacatsipaebaponaenexa pacuene yabara naneconitsiaexanaejitsiatsi maponëje. Vaxaitsi rabaja vajacuata jumetanetsi pacuenia maponëje cuaicuaijai Dioso apo pejitsipaecuenia. Tsipaji beDioso pexënato natane, najai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Daxita judíovi pijaancianovi nonobapuna. Sacerdotevi penamatacaitorobivi ata nonobapuna. Judíovi pecujarubivi ata nonobapuna. Nexata bajarapamonae Jesús caponaliatsi itsaboyabelia, Judeanacua pevetsinë Pilato pijaboyabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bajarajota Pilato pitabarata bajarapamonae neconitsiaya jumaitsi Jesús yabara: —Mara ponëje naneconita. Tsipaji muxubijiapenetapona jivi pianaepanaenexa nacuaevetsivijavabelia. Paneitavetaponanua patamatamotsiyaniva Romanonacua pepo pevetsinë pejamatabëcueneta impuestomatamo pataneyanijobijava. Jumai tsaponaenua: “Xanë raja Cristonë, nacua taevetsinë,” jai tsaponae maponëje, jai bajarapamonae Jesús yabara neconitsiaya Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nexata Pilato jumaitsi Jesúsjavabelia: —¿Xamë tsaja judíovi pepo nevetsinë? jai. Nexata Jesús jumaitsi Pilatojavabelia: —Jãjã, xanë rabaja pacuenia nejumaitsimë, jai Jesús Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato nexata jumaitsi sacerdotevi penamatacaitorobivijavabelia, jivi ayaibitsaëtoxanetojavabelia ata: —Apo caxitajarabinë cajena itsacujiruneconi ata pexainaejava maponëje, paneconi yabara naneconitsijitsia, jai Pilato. ");
INSERT INTO guh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Itsiata bajarapamonae ajumesaë. Orijibia neconitsia jumaitsi Jesús yabara: —Bajaraponë daxita Judea nacuapijivi muxubijiapenetapona bajarapamonae pianaepanaenexa Judeanacua pevetsivijavabelia. Taxuxuaba cajena bajaraponë bajarapacuene pexanaejava Galilea nacuata. Nexata maberena ataje bajarapacuenia icatsia exanapona, jai bajarapamonae Jesús yabara Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato itsa jumetane bajarapamonae peneconitsijavatsi Jesús, nexata Pilato jumaitsi bajarapamonaejavabelia: —¿Matsa ponëje Jesús, Galilea nacuapijinëje? jai Pilato. ");
INSERT INTO guh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nexata bajarapamonae tsipaeba Pilatojavabelia Jesús Galilea nacuapijinëcuene. Nexata Pilato itoroba pijajivi Jesús pecaponaenexatsilia Herodesjavabelia. Tsipaji Herodes Galileanacua pevetsinë. Bajarapamatacabi Herodes ponapona Jerusalén tomarata. ");
INSERT INTO guh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nexata Herodes itsa tane Jesús, barëya. Tsipaji Herodes vënëlivaisitaeyabiaba Dioso pesaëta Jesús pinijicuene pexanaponaejavanë. Nexata Jesús pinijicuene pexanaejava Dioso pesaëta jamatabëtane Herodes. ");
INSERT INTO guh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nexata Herodes ayaicuenia yanijobapona Jesúsjavabelia. Itsiata Jesús apo jumepitsi caejumeyo ata. ");
INSERT INTO guh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bajarajota nubena sacerdotevi penamatacaitorobivi, judíovi pecujarubivi yajava. Bajarapamonae ayaijumeta neconitaponatsi Jesús Herodesjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nexata Herodes, pijajivi yajava, Jesús capocaponatsi. Bitso pexaniajava, xua nacuaevetsinë banaxatata, bajaraxua Jesús quenetsiataeya xatatatsi. Bajarapacuenia Jesús quenetsiataeya xatatatsi pepo nacuaevetsinëcuenia petaenexatsi. Bajaraxuacujinae icatsia canaviabarenatsi Pilatojavaberena. ");
INSERT INTO guh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilatobeje Herodesbeje naitoyabeje picani. Itsiata bajarapamatacabi nabarajamatabëcuenexanepanabeje. Naxaniababeje baja. ");
INSERT INTO guh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato junata penacaetuatsinexa sacerdotevi penamatacaitorobivi. Junata penacaetuatsinexa judíovi pevetsivi ata. Junata penacaetuatsinexa bajarapatomarata pejinavanapaevi ata. ");
INSERT INTO guh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nexata Pilato jumaitsi bajarapamonaejavabelia Jesús yabara: —Paxamë panetocapatame maponëje. “Mara ponëje naneconita. Tsipaji muxubijiapenetapona jivi pianaepanaenexa nacuaevetsivijavabelia,” panejamë. Itsiata baitsi jane xanë picani tajacuata yanijobajë xaniavaetsia paneitabëta. Nexata xua yabara paneconitame, ajibi picani. Maponëje itsacujiruneconi ata apo xainae, paneconi yabara naneconitsijitsia. ");
INSERT INTO guh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ata apo naneconitsiaexanaetsi. Saya icatsia nacatocanaviarena. Pataneme rabaja. Itsacujiruneconi ata apo xainae maponëje, paneconi yabara beyaxuabijitsiatsi. ");
INSERT INTO guh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nexata tajajivi itorobianajë bajaraponë saya tajajivi pejumaconibabenexa penaneconitsivi pejumaconibabeyabiabimacata. Bajaraxuacujinae copatsianajë, jai Pilato bajarapamonaejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Caevai canacujitsia, pascuavënë fiestamatacabi, Pilato copatabiaba caenë penaneconitsinë pepitsapaenexa penaneconitsivi pejebabiabibovecua. Pilato copatabiaba ponë jivi vajëtatsi pecopatsinexa. Nexata bajarapacuenia copatabiaba jivi pesivajamatabëcuene xanepanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nexata bajarapamonae itsa jumetane Pilato picani Jesús pecopatsiapaebijava, nexata daxita bajarapamonae caecuenia vavajai Jesús yabara. Bajarapamonae pevavajaijavata, Jesús yabara jumaitsi Pilatojavabelia mapacueniaje: —¡Majane ponë beyaxuareje! ¡Barrabás jane panetocapitsapare! jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bajaraponë Barrabás Jesús pevajënaeya bajarapatomarata barënabia gobierno pijajivijavabelia. Nexata Barrabás jivitonë beyaxuaba. Bajaraxuata naneconitsiaponapona penaneconitsivi pejebabiabibota. ");
INSERT INTO guh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato picani jamatabëcopata Jesús. Bajaraxuata picani icatsia Pilato tsipaebijitsia jivijavabelia Jesús baja pecopatsinexa. ");
INSERT INTO guh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Itsiata baitsi jane bajarapamonae orijibia vavajai. —¡Cruzajavabelia cobematabiabarutsiaexanare! ¡Cruzajavabelia cobematabiabarutsiaexanare! jai tsaponae bajarapamonae Pilatojavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Icatsia Pilato jumaitsi bajarapamonaejavabelia: —¿Detsa xuajitsia? ¿Detsa papibisiacuene exana maponëje? Apo caxitajarabinë cajena itsacujiruneconi ata, paneconi yabara beyaxuabijitsiatsi. Nexata tajajivi itorobianajë bajaraponë saya tajajivi pejumaconibabenexa penaneconitsivi pejumaconibabeyabiabimacata. Bajaraxuacujinae copatsianajë peponaenexa baja, jai Pilato. ");
INSERT INTO guh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Itsiata bajarapamonae ajumesaë. Vavajai tsaponae. —¡Cruzajavabelia cobematabiabarutsiaexanare! jai tsaponae bajarapamonae Pilatojavabelia. Nexata bajarapamonae, sacerdotevi penamatacaitorobivi yajava, bitso pevavajaitsaponaexae, belia baja Pilato jejai. ");
INSERT INTO guh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nexata baja Pilato tocopata pacuenia bajarapamonae vajëtatsi. ");
INSERT INTO guh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nexata Pilato itoroba pijajivi Barrabás, ponë jivitonë beyaxuaba, pecapitsapaenexatsi pepitsapaenexa baja penaneconitsivi pejebabiabibovecua. Caranata Jesús, pianeconijibinë, pebeyaxuabinexatsi Pilato itoroba pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Vajabitsaë itsa caponaliatsi Jesús cruzajavabelia pecobematabiabarutsinexatsi, Simón pijinia najetaruca vayafoverena. Nexata vajabitsaë vaetabatsi Simón. Simón Cirene tomarapijinë. Nexata Simón vajabitsaë itorobatsi, pacruzajavabelia Jesús cobematabiabarutsijitsiatsi, petocaponaenexa. Nexata bajarapacruza Simón tovëtacaranajetaruca Jesús pecovëya. ");
INSERT INTO guh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesús pënanajetarubenatsi, jivi ayaibitsaëtoxaneto. Bajarapamonaeyajuvënëvi, petiriavi ayaibitsaëto, Jesús bitso pënueyababuataponatsi ayaijumeta. ");
INSERT INTO guh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nexata Jesús napënëyorota. Jumaitsi bajarapapetiriavijavabelia: —Paxamë petiriavi, paJerusalén tomarapijivimë, pëtsa panepënueyabame xanë. Paxamë jane panatsinuema. Panexi ata patsinuema. ");
INSERT INTO guh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Itsa copiajopaena piayaimatacabi, jivi bitso bejiobi tsane. Nexata jivi jumai tsane: “Mavecovi itsiata bevelia nacatsunabejiobitane pexi apo pexainaexae,” jai tsane jivi bajarapamatacabi mavecovi yabara. ");
INSERT INTO guh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nexata bajarapamatacabi jivi bitso itsa nabejiobitaena, belia jitsipaena petëpaejava. Nexata jivi najumai tsane: “Vajatëpaenexa, nacatoxanepanaejitsipa pinijiibotsutonë itsa nacamatacënëbajarabijitsipa,” najai tsane jivi. ");
INSERT INTO guh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xanë itsacujiruneconi apo xainae atanë, nebejiobiaexanaena itsa necobematabiabarutsiana cruzajavabelia. Nexata pamonae pibisiacuene pexanaevi bitso xanë matatoxenetsia, bejiobiaexanaenaenatsi itsa tocopiapatsianatsi piayaimatacabi, jai Jesús bajarapapetiriavijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Itsabelia vajabitsaë Jesús caponatsi, bajarabelia anijanëbeje penaneconitsinëbeje, Jesús yajava, caponatsi. Bajaraponëbeje piajamatabëcuenebejenëbeje vajabitsaë caponatsibeje Jesús peyajavabeyaxuabinexatsibeje. ");
INSERT INTO guh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Itsa baja capaliatsi Jivimatasipavënë tsutojavabelia, nexata cruzajavabelia Jesús yajavacobematabiabarutatsi bajaraponëbeje. Itsanë rutatsi itsacruzata Jesús pecujuanenia. Itsanë rutatsi itsacruzata Jesús petsavenonenia. ");
INSERT INTO guh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús baja cruzajavabelia pepuacobematabiabarutsi, jumaitsi paxa Diosojavabelia: —Axa, mapamonaeje itaxutotsoniataema. Vecuaxuare paneconi xaina pibisiacuene taneexanaexae mapacueniaje. Tsipaji raja apo yapëtae. Bajaraxuata mapacuenia nexanaje, jai Jesús paxa Diosojavabelia. Nexata vajabitsaë, pamonae Jesús cobematabiabarutatsi cruzajavabelia, bajarajota namuxusita. Penamuxusitsijavaxi irata natsipenepeneta. Bajarapacuenia vajabitsaë penamuxusitsijavaxi canamuxusita peyapëtaenexa ponë pitaponaejitsia caejava canacujitsia Jesús penaxatatsijavami, xua jumaponapona. ");
INSERT INTO guh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bajarajota daxitajivi taenubena. Judíovi pevetsivi Jesús capocaponatsi. Bajarapamonae capocaponaeya jumaitsi Jesús yabara: —Ëitsamonae yabara jumai tsabiabi: “Capanepaenajë jivi,” jai tsabiabi. Baja rajane pijacuata nacapanepae itsa xaniajai pepacuene Cristo, Dioso athëbëvetsica pitorobinëtsitsica jivi pecapanepaenexa, jai judíovi pevetsivi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vajabitsaë ata Jesús capocaponatsi. Nexata capocaponaeya cujibarenatsi. Rajutsijitsiatsi piajatuvinora piapaenexa Jesús. ");
INSERT INTO guh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nexata vajabitsaë jumaitsi Jesúsjavabelia: —Itsa xamë judíovi pepo nevetsinë, nexata nacapanepare nijacuata, jai vajabitsaë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bajarajota Jesús pematabocoto matatsënëyo tablapajumata, Pilato pijajivi yaquinaruta acueyabi paviriavibeje pijajumeta. Itsaitane yaquinaruta griegojumeta. Itsaitane yaquinaruta latínjumeta. Itsaitane yaquinaruta hebreojumeta. Peyaquinarubiitane jumai tsarubi mapacueniaje: “Mara ponëje judíovi pepo pevetsinëje,” jai tsarubi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Itsanë piajamatabëcuenebejenë cruzajavabelia pecobematabiabarutsinëtsi, Jesús anaeya bijataerucatsi. —Itsa xamë Cristomë, athëbëvetsica Dioso pecaitorobinëtsica jivi necapanepaenexa, nijacuata nacapanepare. Paxanëbeje ata panecapaneparebeje, jai tsarucae Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Itsanë pijinia itsacruzajavabelia pecobematabiabarutsinëtsi, jumeitavetaruca. Jumai tsarucae penajuananeconitsinëbejejavabelia: —¿Dioso tsaja apo cujunavimë netëpaenexa, cacobematabiabi ata nijaneconi yabara mapacueniaje? ");
INSERT INTO guh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vaxaibeje rabiji vajaneconi xainatsibeje vajatëpaenexabeje. Nacarutabeje mapacueniaje pibisiacuene vajaexanaexaebeje. Mabiji ponëje caeto ata pibisiacuene apo exanae, jai tsarucae bajaraponë jumeitavetsiaya penajuananeconitsinëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Icatsia xuacujinae bajaraponë jumaitsi Jesúsjavabelia: —Jesús, xanë nenajamatabënapitsianame pamatacabi xamë evetsianame mapanacuaje, jai bajaraponë Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nexata Jesús jumaitsi bajaraponëjavabelia: —Xaniajanë pacuenia catsipaebijitsiatsi. Ajena, pamatacabi, neyajavaponaponaename paraísojavatatsia, jai Jesús bajaraponëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jesús baja itsa tëpaejitsia, matonejeepatota, daxita nacuanëjava aitaquiri tsajuni. Matapania acueyabi pahorabejecujinae, caniviyojavabelia, nacua napebeta icatsia. ");
INSERT INTO guh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Paepatota Jesús tëpanajereca, bajarapaepatota templobo ënëtuatuajëalia pënëyatuucutarutsipana, ayaipapaëbërëpana, tuatuajëatsica titititicaica. ");
INSERT INTO guh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nexata Jesús ayaijumeta jumaitsi Diosojavabelia: —Axa, xamëjavabelia daxita tajamatabëcuene carajutatsi, jai Jesús. Itsa baja Jesús najumevereta bajarapajume, tëpanajereca jane baja. ");
INSERT INTO guh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nexata Romano nacuapijinë, vajabitsaë pijacapitán, itsa tane daxita bajarapacuene, bajaraponë Diosojavabelia jumaitsi: —Diosomë, bitso ayaijamatabëcuenenëmë. Xaniajai tsaena baja. Maponë tëpaje, pianeconijibinë, jai vajabitsaë pijacapitán. ");
INSERT INTO guh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Daxita pajivibitsaëtoxaneto taenubena pacuenia Jesús jumaliverevereca, bajarapamonae bitso najamatabëxainaeya naviaba pijabonëjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Daxita pamonae Jesús peyapëtaevitsi, pebijivi, petiriavi ata, pamonae Galilea nacuaverena pënaponatsi, tajiyojavaverena taenubena, petaenexa Jesús pebeyaxuabijavatsi. ");
INSERT INTO guh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jerusalén tomarata ponapona José, Arimatea tomarapijinë. Bajaraponë pexaniajamatabëcuenenë, xaniavaetsia peponaponaenë Dioso pitabarata. Bajaraponë judíovi pevetsinë. ");
INSERT INTO guh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José copiaevetaponapona pecopiajopaejava pamatacabi caenë Dioso evetsijitsia daxita pijajivi mapanacuataje. Nexata José apo jamatabëcuenejëpae pacuenia judíovi exana Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José nexata lia nacuaevetsinë Pilatojavabelia. Vajëta petocopatsinexatsi pemëthëtsinexa petëpaenë Jesús. ");
INSERT INTO guh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bajaraxuacujinae José cruzajavavetsica pitsica Jesús petëpaenë. Daxitanëreca mataquionaeya matacacëba pexaniaviria piapiasábanapanata. Nexata cajena itsajota José iboitapajanitojavata pinijiibovaju toexanabuatatsi petëpaevi pebuataponaenexa, bajarapaibovajualia buata Jesús petëpaenë. Bajarapavajualia abaxë itsajiviyo ata petëpaejiviyo José apo buatsi. ");
INSERT INTO guh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pamatacabi José bajarapacuenia vajëta Pilatojavabelia Jesús petëpaenë pemëthëtsinexa, bajarapamatacabi judíovi penacuenebijava banacuenevereta baja pecopiajonevajënaeya penacueraevetsimatacabinexa. Nexata paepatota José ibovajualia buata Jesús petëpaenë, bajarapaepatota José baja tocopiapataponatsi penacueraevetsimatacabinexa. ");
INSERT INTO guh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Papetiriavi Jesús pënaponatsi Galilea nacuaverena, bajarapapetiriavi tajiyo José pecovëya najetarubena. Nexata bajarapapetiriavi tane Jesús petëpaenë José pebuatsijava bajarapaibovajualia. ");
INSERT INTO guh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bajaraxuacujinae bajarapapetiriavi naviaba baja pijaboyabelia. Nexata pepatsicujinae pijaboyabelia, bajarapapetiriavi xaniavaeta pexaniapetuxujuvira, pexaniapetuxujuvitsapato yajava, Jesús petëpaenë peperabëexabinexa. Nexata abaxë bajarapapetiriavi nacueraeveta judíovi penacueraevetsimatacabita pacuenia itorobatsi Dioso Moiséspijinëta bajayata penajumecopatsilivaisi. ");
INSERT INTO guh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Judíovi baja penacueraevetsimatacabi verevereca. Nexata meravia pitsijavata, ajena juameto pitsapaina, papetiriavi xaniavaeta pexaniapetuxujuvijava, icatsia ponalia Jesús petëpaenë pebuatsiibovajutsijavabelia. Patuxujuvijava xaniavaeta Jesús petëpaenë peperabëexabinexa, caponalia Jesús petëpaenë peperabëexabinexa jane baja picani. Itsapetiriavi yajava ponalia peyanabinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Itsa baja palia, nexata bajarapapetiriavi tane Jesús petëpaenë pebuatsiibovajutsi peyavëpaacatsiibopanaxanetomi petixitanutsijavalia. ");
INSERT INTO guh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bajarapamonae joneya picani Jesús pebuatsiibovajutsijavalia. Itsiata baitsi jane apo caxitajarababuatsi petëpaenë, pepo petuxanenë Jesús. ");
INSERT INTO guh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nexata bajarapapetiriavi bitso jamatabëcuenenajunaviaca. Apo yapëtae pacuenia exanaejitsia. Bajarajota nexata bajarapapetiriavi taenuta anijanëbeje ángelnëbeje. Bajaraponëbeje penaxatatsijavabeje nivenivena bitso. ");
INSERT INTO guh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bajarapapetiriavi bitso cujunava bajarapaángelnëbeje. Nexata pecajunavi pematabacabëta irataeya bobena. Nexata bajarapaángelnëbeje jumaitsi petiriavijavabelia: —¿Detsa xuajitsia petëpaenë pebuatsijavatatsi, pajaitame? Bajaraponë asaë baja icatsia. ");
INSERT INTO guh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bajaraponë majotaje ajibi baja tsarucae. Dioso rabaja icatsia asaëyaexanatsi. Panajamatabënapire pacuenia pacatsipaeba Galilea nacuata pamatacabi abaxë asaë tsaponaponae. ");
INSERT INTO guh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Bajaraponë baja cajena tajëvelia pacajumaitsi: “Xanë, Daxitajivi Pematapijinënë, necanajetsiana pibisiajamatabëcuenevi pecobeyabelia. Nexata bajarapamonae cruzajavabelia necobematabiabarutsiana tanebeyaxuabinexa. Itsiata baitsi jane tanebeyaxuabicujinae, acueyabi matacabita, icatsia asaënë tsane,” pacajai baja cajena tajëvelia Jesús itsa abaxë pamatacabi pacayajavaponapona, jai ángelnëbeje petiriavijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nexata bajarapapetiriavi najamatabënapita pacuenia Jesús tajëvelia jumaitsi. ");
INSERT INTO guh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nexata baja bajarapapetiriavi naviabarena Jesús petëpaenë pebuatsiibovajutsijavaverena. Nexata bajarapapetiriavi tsipaeba daxita bajarapacuene yabara once ponëbeje, Jesús pijaapóstolevijavabelia. Tsipaebanua daxita itsamonae Jesús pijajivijavabelia ata. ");
INSERT INTO guh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bajarapapetiriaviyajuvënëvi itsava Maríavënëva. Bajarapova Magdala tomarapijiva. Itsava pijinia Juanavënëva. Itsava pijinia icatsia Maríavënëva. Bajarapova Santiago pena. Itsapetiriavi yajava tsipaeba bajarapacuene yabara apóstolevijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bajarapapetiriavi apóstolevijavabelia tsipaebi ata bajarapacuene yabara, itsiata apóstolevi apo jumexaniataetsi. Apóstolevi saya bajarapalivaisi yabara jamatabëjumaitsi: “Saya meta bajarapapetiriavi pijacuata exana bajarapalivaisi,” jamatabëjai apóstolevi. ");
INSERT INTO guh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Itsiata baitsi jane Pedro pitsapalia bovecua. Nexata cujinaejinalia Jesús petëpaenë pebuatsiibovajutsijavabelia. Nexata Pedro bajarapaibovajualia itsa naëcolia, taeyejeba pebobenaejava bajarajota daxitanëreca Jesús mataquionaeya pematacacëbipanamitsireca. Nexata baja Pedro naviata boyaberena. Najamatabëxaina bajarapacuene yabara. ");
INSERT INTO guh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pamatacabi bajarapapetiriavi tane ángelnëbeje, bajarapamatacabi Jesús pijajivitonëbeje Jerusalén tomaravelia naropotabeje. Ponabeje Emaús tomarabelia. Bajarapatomara eca once pakilómetrobeje Jerusalén tomaravecua. ");
INSERT INTO guh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bajaraponëbeje baracuaicuaijaibeje tsanajetarucae daxita pacuene copiapata. ");
INSERT INTO guh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Itsa abaxë bajarapalivaisi cuaicuaijai tsanucaponaebeje, Jesús pëcaxitajarabalia. Nexata Jesús muxunenianajetaruca bajaraponëbeje. ");
INSERT INTO guh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bajaraponëbeje tae atabeje Jesús, itsiata apo yapëtaebeje Jesúscuene. ");
INSERT INTO guh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nexata Jesús yanijoba bajaraponëbejejavabelia. Jesús jumaitsi: —¿Detsa pitsicuene pabaracuaicuaijamëbeje tsanucaponae namutua? ¿Detsa xuajitsia bepajamatabëcuenejiobimëbeje? jai Jesús bajaraponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bajaraponëbeje itsanë pevënë Cleofas. Nexata Cleofas jumaitsi Jesúsjavabelia: —Daxitajivi baja cajena yapëtane pacuene copiapata Jerusalén tomarata mapamatacabitaje. ¿Xamë tsaja caenëmë apo nijanayapëtae bajarapacuene, naponaponae atamë bajarapatomarata? jai Cleofas caranata Jesúsjavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nexata Jesús jumaitsi bajaraponëbejejavabelia: —¿Detsa pitsicuene copiapata? jai. Nexata icatsia bajaraponëbeje jumaitsi Jesúsjavabelia: —Jesúspijinë raja, Nazaret tomarapijinëmi, profetanëmi. Pinijicuene exanapona Dioso pesaëta. Bitso xaniavaetsia jivi pexanialivaisi tsipaebapona. Nexata daxitajivi sivajamatabëcuenebarëya bajaraponëmi. Dioso ata sivajamatabëcuenebarëyatsi. ");
INSERT INTO guh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nexata sacerdotevi penamatacaitorobivi, vajanacaevetsivi yajava, canajetatsi Jesúspijinëmi. Canajetaxuabatsi Jesúspijinë cruzajavabelia pecobematabiabarutsinexatsi pebeyaxuabinexatsi. ");
INSERT INTO guh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Paxanë picani bajaraponëmi yabara pajamatabëjumaitsinë: “Bajaraponë nacavecuacapitsapaena itsanacuaverena pepatsivi, pamonae apo judíovi, vajanacayanacuaevetsijavavecua pepitsapaenexa,” pajamatabëjanë tsavanapae picani Jesúspijinë yabara. Nexata Jesúspijinë pebeyaxuabicujinaetsi, ajena baja xaina acueyabi pamatacabibeje. ");
INSERT INTO guh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Paxanëyajuvënëvi, petiriavi, ajena, bajayacunua, panenabenajacaeyaexana. Bajarapamonae bajayacunua, ajena juameto pitsapaina, ponalia Jesús petëpaenë pebuatsiibovajutsijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Itsiata apo caxitajarababuatsi bajarajota Jesús petëpaenë. Nexata bajarapapetiriavi naviabarena. Bajarapamonae panetsipaeba pacuenia bemajitsinaebota tane ángelnëbeje. Angelnëbeje pina nexata jumaitsibeje petiriavijavabelia: “Jesús rabaja asaë tsaponaponae icatsia,” jai pina. ");
INSERT INTO guh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nexata itsamonae paxanëjuvënëvi pona Jesús petëpaenë pebuatsiibovajutsijavabelia. Nexata tane pacuenia baja petiriavi panetsipaeba. Jesús itsiata petëpaenë apo taeyabuatsi, jaibeje Jesúsjavabelia Emaús tomarabelia peponaenëbeje. ");
INSERT INTO guh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nexata Jesús jumaitsi bajaraponëbejejavabelia: —¡Paxamëbeje saya paneajamatabëcuenetajanëbeje! Apo pajumecovënëtsimëbeje daxita profetavi peyaquinaelivaisianë. ");
INSERT INTO guh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nexata apo payapëtaemëbeje pacuenia Cristo, Dioso athëbëvetsica pitorobinëtsitsica jivi pecapanepaenexa, copiaya bitso bejiobiaexanaejitsiatsi peponaevajënaeya paxa Diosojavabetsia athëbëtatsia paxa pemuxuneneta peecaenexa, nayabarajai Jesús bajaraponëbejejavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nexata Jesús xaniavaetsia navajunupaeba bajaraponëbejejavabelia daxita pacuenia Dioso pejumelivaisibaxutota tajëvelia jumaitsi Jesús yabara. Taxuxuaba jane baja penavajunupaebijava pacuenia Moiséspijinë peyaquinaebaxutota tajëvelia jumaitsi Jesús yabara. Bajaraxuacujinae icatsia navajunupaeba pacuenia daxita itsaprofetavi peyaquinaebaxutonëta ata jumaitsi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Itsa baja imoxoyotanajetarubena patomarata bajaraponëbeje patsijitsiabeje, Jesús itajara rovia bepeponaejitsia bajaraponëbejevecua. ");
INSERT INTO guh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nexata bajaraponëbeje bitso asivabeje Jesús penajuamajitsinexa bajarapatomarata. Jumaitsibeje bajaraponëbeje Jesúsjavabelia: —Namajire abaxë mapatomarataje. Caniviyo rabaja bitso. Meravijitsia rabaja, jaibeje bajaraponëbeje Jesúsjavabelia. Nexata baja Jesús najoneya pabota bajaraponëbeje patabeje. ");
INSERT INTO guh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Itsa bajaraponëbeje yajavaecabeje mesa muxuneneta, Jesús pita panbë. Jumaitsi paxa Diosojavabelia: —Pexaniacuene panetoexaname. Panerajutame pan, jai Jesús. Bajaraxuacujinae epatsënëquejeba panbë. Rajutatsi bajaraponëbeje. ");
INSERT INTO guh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bajarajota matapania bajaraponëbeje yapëtanebeje Jesúscuene. Itsiata baitsi jane bajarajota vecuacaevatsibeje Jesús. Apo taebeje baja matavëjëa. ");
INSERT INTO guh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nexata bajaraponëbeje najumaitsibeje: —Namutua vajanacanavajunu paebanucaponaejavatabeje pacuenia jumaitsi Diosojumelivaisibaxutota, bitso muxunajamatabëcuenebarëyatsibeje, najaibeje bajaraponëbeje. ");
INSERT INTO guh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nexata bajarajota bepijia naropotabeje Emaús tomaravecua. Naviatabeje baja Jerusalén tomarabelia. Nexata Jerusalén tomarabelia itsa patabeje, caxitajarababeje penacaetuatsijavata once ponëbeje apóstolevi, itsamonae yajava Jesús pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nexata penacaetuatsivi jumaitsi bajaraponëbejejavabelia: —Xaniajai baja cajena. Vajatuxanenë icatsia asaë tsaponaponae. Simón baja tsitanaitajëtatsi, jai bajarapamonae. ");
INSERT INTO guh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nexata ponëbeje Emaús tomaraverena patabeje, tsipaebabeje bajarapamonaejavabelia pacuenia namutoepatualia pëcaxinatsibeje Jesús. Tsipaebabejenua pacuenia matapania yapëtanebeje Jesúscuene, pitabëta itsa epatsënëquejeba panbë. ");
INSERT INTO guh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ponëbeje Emaús tomaraverena patabeje, tsipaebabeje Jesús pijajivijavabelia pacuenia tanebeje Jesús Emaús tomaratalia. Nexata bajarapaepatota Jesús tsitanaitajëta pijajivijavabelia. Jesús jemata nuca pijajivi tuatuajëta. Jesús bajacoba pijajivi. ");
INSERT INTO guh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nexata Jesús pijajivi bitso nabenajaca. —Petëpaenëmi raeta pejumape maje, jamatabëjai bajarapamonae Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nexata Jesús jumaitsi pijajivijavabelia: —¿Detsa xuajitsia pajunavame? ¿Detsa xuajitsia panejamatabëëthëtota pajumeaebame icatsia tasaëjava? ");
INSERT INTO guh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Panecobetaema. Tataxubeje ata pataema. Xanë rabaja maje. Panejayabare. Paneyorobarenua xaniavaetsia. Petëpaenëmi raja peneta pejumape avijibi. Asijibinua. Apo perabëitsi cajena pacuenia xanë perabëitsinë, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesús itsa jumaitsi mapacueniaje, nacobeitajëta pijajivijavabelia. Nataxuitajëta yajava. ");
INSERT INTO guh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jesús pijajivi bitso tsitapexaniacuenetsi. Itsiata baitsi jane Jesús pijajivi abaxë apo jumexaniatae xaniavaetsia Jesúscuene. Jesús nexata jumaitsi pijajivijavabelia: —¿Paxainame tsabaja itsacuenejavayo patanerajutsinexamë taxaenexa? jai Jesús. ");
INSERT INTO guh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nexata Jesús pijajivi rajutatsi pesebidujuaijavayo, jabëperiyo yajava. ");
INSERT INTO guh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pita baja Jesús. Nexata Jesús pijajivi pitabarata xane. ");
INSERT INTO guh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nexata Jesús jumaitsi pijajivijavabelia: —Mapacuene taneexanaejavanexa yabaraje, pacatsipaebabiabatsi baja cajena tajëvelia pamatacabi abaxë pacayajavaponaponatsi. “Pacuenia bajayata tajëvelia xanë yabara jumaitsi Moiséspijinë peyaquinaebaxutota, Diosojumepaebivimi profetavi peyaquinaebaxutota ata, Salmosvënëbaxutota ata, bajarapacuenia netocopiapatsiana,” pacajaitsi tsabiabi baja cajena pamatacabi abaxë pacayajavaponaponatsi. Daxita rabaja bajarapacuene netocopiapata jane baja, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nexata Jesús pijajivi jamatabëcuenecaëjëpaeyaexana Jesús pijajivi xaniavaetsia pejumeyapëtaenexa pacuenia Dioso pejumelivaisibaxutota tajëvelia jumaitsi Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús jumaitsi pijajivijavabelia mapacueniaje: —Dioso pejumelivaisibaxutota tajëvelia jumaitsi pacuenia xanë, Cristonë, athëbëvetsica Dioso taneitorobinëtsica jivi tacapanepaenexa, nebejiobitsiaya nebeyaxuabijitsia. Jumaitsinua pacuenia tatëpaecujinae, acueyabi matacabita, icatsia Dioso niasaëyaexanaejitsia tatëpaejavavecua. ");
INSERT INTO guh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jumaitsinua pacuenia patajajivimë tajumelivaisi patsipaebaponaejitsiamë daxitajivijavabelia. Nexata tajumelivaisi patsipaebaponaename daxitajivi penajamatabëcuenepënëyorotsinexa Diosojavabelia, pibisiacuene pexanaeneconimi pevecuaajibiaexanaenexatsi Dioso. Copiaya Jerusalén tomarata pataxuxuabianame panetsipaebijava. Bajaraxuacujinae patsipaebanajetarubenaename daxitanacuanëjava. ");
INSERT INTO guh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Paxamë rabaja pataneme daxita pacuene netocopiapata. Nexata jivi patsipaebaponaename daxita bajarapacuene yabara. ");
INSERT INTO guh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Espíritu Santo, ponë taxa Dioso najumecapanepaeya pacarajutsiapaeba, pacatoitorobianicatsi papecatsijamatabëjonenexa. Abaxë pajinavanapaename majotaje Jerusalén tomarata. Matapania Dioso athëbëvetsica pacajamatabëcuene caëjëpaeyaexanaena pinijicuene paneexanaponaenexa, paponaename jane baja tajumelivaisi jivi panetsipaebanajetarubenaenexa daxitanacuanëjava, jai Jesús pijajivijavabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús pijajivi matacalia Betania tomarabelia. Jesús nacobeyotsiaya pijajivi tovajëcanuca Diosojavabelia Jesús pijajivi peyavenonaenexatsi Dioso. ");
INSERT INTO guh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nexata saya bajarajota Jesús pijajivi athëbëabetsia baja vecuapona. Jesús baja Dioso caponatsi athëbëabetsia. ");
INSERT INTO guh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesús pijajivi jamatabëjumaitsi: —¡Vajatuxanenë bitso ayaijamatabëcuenenë! jamatabëjai. Bajaraxuacujinae Jesús pijajivi barëyaya naviaba Jerusalén tomarabelia. ");
INSERT INTO guh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Templobojavabelia Jesús pijajivi joneyabiaba pevajëcabiabinexa Diosojavabelia. Jesús pijajivi pexaniajamatabëcuene rajutabiaba Diosojavabelia.");
INSERT INTO guh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Itsa abaxë ajibi itsacuenejavayo ata mapanacuataje, Cristo baja cajena ponapona athëbëtatsia. Cristo raja paxa Dioso pejamatabëcuenelivaisiitajëtsinë jivijavabelia. Cristobeje paxa Diosobeje najuaponaponabeje. Cristo ata rabaja Dioso baja cajena. ");
INSERT INTO guh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Daxitacuene baja cajena pexanaejava petaxuxuabivajënaeya ata, Cristobeje paxa Diosobeje najuaponaponabeje. ");
INSERT INTO guh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cristo baja cajena daxitacuene mapanacuapijicueneje exana. Exana athëbëpijicuene ata. Bajarapacuene exanaeyaexanatsi paxa Dioso. Bajaraxuata itsacuenejavayo ata apo vecuaexanaetsi itsanë ata. ");
INSERT INTO guh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo baja cajena rajuta piasaëjumali daxitacueneviria mapanacuataje. Cristo baja cajena bepecotia picani. Nexata jivi jamatabëcueneitayota pexaniajailivaisita. ");
INSERT INTO guh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pacuenia pecotia itayota piaitaquirijavata, bajarapacuenia Cristo petsipaebilivaisita jivi jamatabëcueneitayota. Nexata dovathi, jivi piajamatabëcuene itaquiriyaexanaenë, apo caëjëpaetsi pevereverecaeyaexanaenexa bajarapalivaisi. ");
INSERT INTO guh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nexata Dioso itoroba caenë pebi. Bajaraponë pevënë Juan. ");
INSERT INTO guh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nexata Juan pona petsipaebinexa jivijavabelia Cristo pelivaisi. Nexata Juan tsipaeba daxitajivi pejumetaenexa Cristo pelivaisi, pejumecovënëtsinexanua. ");
INSERT INTO guh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan raja jivi apo pejamatabëcueneitayotsinë. Juan raja pona saya jivi petsipaebanajetarucaenexa xaniavaetsia Cristo pelivaisi. ");
INSERT INTO guh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bajaraponë Cristo jamatabëcueneitayotsiana daxitajivi. Bajaraponë xaniajai jivi pejamatabëcueneitayotsinë. Bajaraponë Cristo patsica baja mapanacuayabetsicaje. ");
INSERT INTO guh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo, ponë paxa Dioso jamatabëcuenelivaisiitajëta jivijavabelia, ponapona baja mapanacuataje. Itsiata baitsi jane mapanacuapijivi apo yapëtae bajaraponë mapanacua pexanaenëcueneje. ");
INSERT INTO guh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cristo patsica pexanaenacuayabetsica. Itsiata baitsi jane mapanacuapijivi apo jumecovënëtsitsi Dioso pexënatocuene. ");
INSERT INTO guh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Itsiata itsamonae jumecovënëtatsi. Nexata Cristo tocopata bajarapamonae paxa Dioso pexi pexanaenexatsi. ");
INSERT INTO guh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bajarapamonae penaexanaematacabi, abaxë Dioso pexicuenia apo taetsi. Pebi petiriva pepitsicujinae, pexi itsa jamatabëxainabeje, pexi xainabeje. Itsiata bajarapamonae itsa naexana, abaxë Dioso apo pexi. Matapania pacuenia Dioso tojitsipatsi, bajarapamonae itsa jumecovënëta Cristo Dioso pexënatocuene, Dioso pexi exanatsi. ");
INSERT INTO guh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristo, paxa Dioso pejamatabëcuenelivaisi itajëtsinënexa jivijavabelia, itsa patsica mapanacuayabetsicaje, naexana pacuenia vaxaitsi baexanatsi mapanacuataje. Nexata bajarapacuenia Cristo ponapona vaxaitsi tuatuajëta. Bajaraponë vënërubatsi Jesús. Paxanë payapëtaniji Cristo ayaijamatabëcuenenëcuene. Tsipaji pataniji pinijicuene pexanaejavanë. Bajaraponë Cristo, pepo caenë Dioso pexënato. Pinijicuenia asiva mapanacuapijivije. Cuaicuaijai ëpexaniajailivaisi. ");
INSERT INTO guh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Bajaraxuata Juan, Jesús itsa vajunupaebanajetaruca jivijavabelia, jumai tsanajetarucae mapacueniaje: —Baja rajane maponë yabara pacajumaitsitsije: “Ponë tacovëverena patsiana, bajaraponë bitso xanë nevecuaayaijamatabëcuenenë. Tsipaji baja cajena tanaexanaevajënaeya ata bajaraponë ponapona,” jai tsanajetarucae Juan jivijavabelia Jesús yabara. ");
INSERT INTO guh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bajaraponë Jesús cajena pepo pexaniajamatabëcuenenë. Pexaniacuene nacatoexanabiaba. Nacayavenonabiaba. ");
INSERT INTO guh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bajayatami baja cajena picani Dioso Moiséspijinëta najumecopata jivi pejumecovënëtsinexa. Itsiata baitsi jane mapamatacabita Jesucristo patajopaica mapanacuayabetsicaje vajanacatsipaebinexa paxa Dioso vajanacaasivajava, vajanacatsipaebinexanua pexaniajailivaisi. ");
INSERT INTO guh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Itsajivi ata vaxaitsiyajuvënëjivi Dioso apo tae. Bajaraxuata apo yapëtaetsi pacuenia Dioso jamatabëcuenelivaisiitsi. Itsiata caenë Dioso pexënato, ponëbeje najuaponaponabeje, bajaraponë nacayapëtaeyaexanaica pacuenia jamatabëcuenelivaisiitsi paxa Dioso. ");
INSERT INTO guh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judíovi, Jerusalén tomarapijivi, Juanjavabelia itoroba sacerdotevi, itsamonae templobo pevetsivi yajava, bajarapamonae peyanijobinexa Juanjavabelia. Nexata bajarapamonae itsa pata Juanjavabelia, yanijoba Juanjavabelia. Jumaitsi: —¿Jipatsamë xamë? ¿Xamë tsaja Dioso pecaitapetsinë? jai bajarapamonae Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan nexata bajarapamonaejavabelia xaniavaetsia rovialia navajunupaeba. Jumaitsi: —Xanë ra apo Cristonë, ponë Dioso athëbëvetsica itorobijitsiatsica jivi pecapanepaenexa, jai Juan. ");
INSERT INTO guh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nexata icatsia matavëjëa yanijobatsi. —¿Detsa nexata ponëmë? ¿Xamë tsaja profeta Elíaspijinëmë, ponëmi bajayata ponapona? jai bajarapamonae Juanjavabelia. Nexata Juan jumaitsi: —Jume raja. Xanë raja bajara apo ponënë, jai Juan. Nexata icatsia yanijobatsi matavëjëa. —¿Xamë tsabaja nexata profetanëmë? ¿Xamë tsabaja pacacopiaevetavanapatsi nepatsijavanexatsica? jai bajarapamonae Juanjavabelia. Nexata icatsia Juan jumaitsi: —Jume raja. Xanë raja apo bajaraponënë, jai. ");
INSERT INTO guh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nexata bajarapamonae jumaitsi: —¿Detsa nexata ponëmë? Pajitsipajë patanenavajunupaebinexamë xaniavaetsia patayapëtaenexa ponëcuenemë patatsipaebinexa patanitorobivijavabelia. ¿Detsa nexata pacuenia navajunupaebianame? jai bajarapamonae Juanjavabelia. ");
INSERT INTO guh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan nexata jumaitsi bajarapamonaejavabelia: —Xanë raja saya petusato nacuata itsa jumelivaisipaebajë, tavavajainë: “Panajamatabëcuenexaniavaere pepo petuxanenë pepatsivajënaeyarena,” tajainë. Bajarapacuenia tajumaitsijavanexa, bajayatami tajëvelia yaquina profeta Isaíaspijinë, jai Juan. ");
INSERT INTO guh_vpl VALUES (