﻿USE sofia;
DROP TABLE IF EXISTS sofia.guc_vpl;
CREATE TABLE guc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES guc_vpl WRITE;
INSERT INTO guc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Anuu nanülia na koo'uliwo'ukana Jesucristo chi nuu'uliwo'ukai David chi nuu'uliwo'ukai Abraham: ");
INSERT INTO guc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, nüshi Isaac. Isaac, nüshi Jacob. Jacob, nashi Judá namaa na nuwalayuukana. ");
INSERT INTO guc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, nashi Fares oo'ulaka Zara. Tamar sünülia tü neikat. Fares, nüshi Esrom. Esrom, nüshi Aram. ");
INSERT INTO guc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, nüshi Aminadab. Aminadab, nüshi Naasón. Naasón, nüshi Salmón. ");
INSERT INTO guc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón, nüshi Booz. Rahab sünülia tü niikat. Booz, nüshi Obed. Rut sünülia tü niikat. Obed, nüshi Isaí. ");
INSERT INTO guc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí, nüshi David chi aluwataashikai. David, nüshi Salomón. Je tü niikat, shia tü nu'wayuusekat paala Urías. ");
INSERT INTO guc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, nüshi Roboam. Roboam, nüshi Abías. Abías, nüshi Asa. ");
INSERT INTO guc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, nüshi Josafat. Josafat, nüshi Joram. Joram, nüshi Uzías. ");
INSERT INTO guc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, nüshi Jotam. Jotam, nüshi Acaz. Acaz, nüshi Ezequías. ");
INSERT INTO guc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías, nüshi Manasés. Manasés, nüshi Amón. Amón, nüshi Josías. ");
INSERT INTO guc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, nashi Jeconías je na nuwalayuukana wanaa sümaa no'uninnüin na wayuu Israelkana sulu'umüin tü mmakat Babilonia. ");
INSERT INTO guc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Anuu nanülia na koo'uliwo'ukana Jesucristo süchikijee no'uninnüin na wayuu Israelkana Babiloniamüin: Jeconías, nüshi Salatiel. Salatiel, nüshi Zorobabel. ");
INSERT INTO guc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, nüshi Abiud. Abiud, nüshi Eliaquim. Eliaquim, nüshi Azor. ");
INSERT INTO guc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, nüshi Sadoc. Sadoc, nüshi Aquim. Aquim, nüshi Eliud. ");
INSERT INTO guc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, nüshi Eleazar. Eleazar, nüshi Matán. Matán, nüshi Jacob. ");
INSERT INTO guc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, nüshi José chi su'wayuusekai María tü niikat Jesús, chi Cristokai anülia. ");
INSERT INTO guc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eesü poloo pienchimüin shi'ipapa'a nutuushiirua Jesucristo nüchikijee Abraham nünainmüin David. Je eesü poloo pienchimüin shi'ipapa'a nutuushiirua nüchikijee David sünainmüin tü o'uninnaakat Babiloniamüin. Je eesü poloo pienchimüin shi'ipapa'a nutuushiirua süchikijee tü o'uninnaakat Babiloniamüin nünainmüin Cristo chi Nüneekajalakai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Otta nüchiki Jesucristo sünain jemelinjachin, müsü mayaa: María, tü niikat, achuntuushiirü shia nütüma wane wayuu José anüliai süpüla nu'wayuusee. Otta nnojoliiwa'aya José sünainpünaain, ipootkalaka shia sütüma nüpülain chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Otta José chi sümüraajüinkai, saa'u lotüin nukuaippa nu'upala Maleiwa, je saa'u nnojolüin nücheküin süpüleerua saapülijünüinjatüin sütüma wayuu süpüshua, anasü nümüin nuu'ulaale shia sujuuna wayuu. ");
INSERT INTO guc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Otta wanaa sümaa jülüjüin naa'in José tü naa'inrüinjatkat süka María, antüshi wane aapiee nüma'anajeejachi Maleiwa nünainmüin nü'lapüinru'u sünain maa nümüin: “Josée, nuu'uliwo'ukai David, nnojo mmolüin pia saa'u María, pu'wayuuse pümata. Ipootsü shia sütüma nüpülain chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jemeyuleerü shia nümaa wane jo'uu toolo je pi'itaajeerü nünülia chi jo'uukai Jesúsüin süka niainjachin o'tte'erüin tü nüpüshikalüirua suulia saainjala”, nümakalaka chi aapieekai nümüin José. ");
INSERT INTO guc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma wane nünüikimaajachi, tü makat: ");
INSERT INTO guc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wane majayülü, nnojotkat nünainpünaain wayuu toolo, ipooleerü shia, jemeyuleerü shia nümaa wane jo'uu toolo je ne'itaajeerü nünülia chi jo'uukai Emanuel”. (“Eeshi Maleiwa wamaa”, malu'ut tia.) ");
INSERT INTO guc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Shiasa nüchijiraapa José, naa'inrüin tü nuluwataakat anain chi aapieekai sünain naapaain María süpüla nu'wayuusein. ");
INSERT INTO guc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Otta nnojoishi nia sünainpünaain wane'ere'eya jemeyutpa shia nümaa chi süchonkai. Je nujuittapa chi süchonkai, ni'itaakalaka nünülia Jesúsüin. ");
INSERT INTO guc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wanaa sümaa jemelin Jesús sulu'u tü pueulokat Belén sulu'u tü mmakat Judea, nia aluwataaka Herodes sulu'u tü mmakat. Shiasa süchikijee jemelin nia, antüsü wane wayuuirua sulu'umüin tü pueulokat Jerusalén. Wattaje'ewalii naya, wüinpuje'ewalii. Atüjaashii naya saa'u sukuaippa tü jolotsükat. ");
INSERT INTO guc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nasakirakalaka: —¿Jalashi chi jo'uu jemeikai aluwataainjachikai saa'u tü wayuu judíokolüirua? We'rüitpa wane jolotsü eweetüsü wanaa sümaa chajanain waya wüinpümüin, watüjaakalaka saa'u sünain jemelichipain nia, wantüinakalaka joolu'u yaamüin süpüla wee'iyatüinjatüin nujut nümüin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Otta müshia Herodes chi aluwataashikai, oo'ulaka wainma tü kepiasükalüirua sulu'u Jerusalén, ashapapajaasü ma'i naa'in naapapa süchiki tü namakat nala wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Neenajitkalaka Herodes napüshua na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana süpüla nüsakirüinjanain naya sünain jalainjachin jemelin Cristo chi Nüneekajalakai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nasouktakalaka nümüin: —Jemeijeechi nia sulu'u tü pueulokat Belén sulu'u tü mmakat Judea, naashin wane nünüikimaajachi Maleiwa sünain nüshajüin paala tü nünüikikat, sünain maa: ");
INSERT INTO guc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Tü pueulokat Belén sulu'u tü mmakat Judea, nnojotsü shiainjatüin ne'e wane pueulo me'nnaajuusat sa'aka tü pueulokalüirua cha'aya. Süka jamüin, eweeteechi yaa sulu'u wane aluwataai süpüla niainjachin süpü'üyain tü tapüshikalüirua, na wayuu Israelkana”. ");
INSERT INTO guc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Neenakakalaka Herodes na wayuu wüinpuje'ewaliikana süpüla naashajaainjachin namaa sujuuna wayuu soo'opünaa joujatüin ma'i shiweetüin tü jolotsü ne'rakat paala. Süküjünakalaka nümüin natüma. ");
INSERT INTO guc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nüjütakalaka naya Belénmüin sünain nümüin namüin: —Ju'una jumaala süpüla jüchajaainjachin nüchiki chi jo'uukai. Je jüntapa nünain, jaapiramaateechi taya nüchiki süpüla to'unüinjachin nünainmüin tayaka'iya süpüla tee'iyatüinjatüin nujut nümüin —nümakalaka Herodes namüin. ");
INSERT INTO guc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","O'una müshi'iya naya süchikijee naapüin nünüiki Herodes. Je tü jolotsü ne'rapü'ükat wanaa sümaa chajanain naya wüinpümüin, o'unüsü joolu'u napüleerua sünain süsha'walaain iipünaa saa'u tü miichikat eere chi jo'uukai. ");
INSERT INTO guc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Talatashaanasü ma'i naa'in süka ne'rüin tü jolotsükat. ");
INSERT INTO guc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Je nantapa eemüin tü miichikat, eeshi napüla chi jo'uukai sümaa tü niikat. No'nnuwaakalaka süka nasapain süpüla nee'iyatüin nujut nümüin. Naakatakalaka shirouse tü juraskeerü kalu'ukot tü nakoloinkat nepialu'ujee nümüin chi jo'uukai. Nasülajakalaka kasa eekai kojutüin ma'i: ooro, wane wunu'u jemeta eejuut, je wane wunu'u kanüliasü “mirra”. ");
INSERT INTO guc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Shiasa no'unapa süpüla nale'ejüinjanain noumainpa'amüin, eitaashii sulu'upünaa wane wopu naatajatü. Nnojoliishii alatapünaain Jerusalénpünaa süka naapinnüin na'lapüinru'u nnojoliinjanain nale'ejüin nünainmüin Herodes. ");
INSERT INTO guc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Shiasa süchikijee no'unapa na wayuu wüinpuje'ewaliikana, eweetüshi wane aapiee nüma'anajeejachi Maleiwa nümüin José nü'lapüinru'u sünain nümüin nümüin: “Püchijiraa maala süpüla pümaainjachin chi jo'uukai sümaa tü niikat chamüin sulu'umüin tü mmakat Egipto süpüla jujuittüinjanain nuulia Herodes. Nüchajaweechi achiki chi jo'uukai süpüla nu'utüinjachin naa'in. Anakaja makatüle jia cha'aya wane'ere'eya jaapinnapa tatüma”, nümakalaka chi aapieekai nümüin José. ");
INSERT INTO guc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nüchijiraakalaka José sünain nujuittüin nümaa chi jo'uukai je tü niikat süse'eru'upünaa ai sünain no'unüin Egiptomüin ");
INSERT INTO guc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","eeinjanale kepiain naya wane'ere'eya ouktapa Herodes. Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma wane nünüikimaajachi, tü makat: “Teenaküin chi Tachonkai sulu'ujee tü mmakat Egipto”. ");
INSERT INTO guc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Je nütüjaapa saa'u Herodes sünain neme'erainpalain nia na wayuu wüinpuje'ewaliikana, jashichishaatashi ma'i nia. Nu'utirakalaka naa'in na tepichi tooloyuuchonniikana eekai motsoyünnuuin suulia piama juya sulu'u tü pueulokat Belén je pejepünaa sünain. Tü sotokot naa'in, shia tü naashajalakat paala namaa na wayuu wüinpüje'ewaliikana soo'opünaa joujatüin ma'i eweetüin tü jolotsü ne'rakat paala. ");
INSERT INTO guc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma Jeremías chi nünüikimaajachikai, tü makat: ");
INSERT INTO guc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aapünüsü shi'ira wane wayuuirua sünain shi'yalajüin ma'i yaa sulu'u tü pueulokat Ramá. A'yalajüsü tü suu'uliwo'ukalüirua Raquel naa'u na süchooinkana. Nayoukta achikit amüliannaa süka ouktüin naya”. ");
INSERT INTO guc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Shiasa süchikijee ouktapa Herodes, eweetüshi cha'aya Egipto wane aapiee nüma'anajeejachi Maleiwa nümüin José nü'lapüinru'u ");
INSERT INTO guc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","sünain nümüin nümüin: “Püchijiraa maala süpüla pümaainjachin chi jintüikai sümaa tü niikat nachikua chamüin sulu'umüin tü mmakat Israel. Na o'uteepü'ükana naa'in chi jintüikai, ouktüinapa”. ");
INSERT INTO guc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nüchijiraakalaka José sünain nujuittüin nümaa chi jintüikai je tü niikat süpüla o'unaa sulu'umüin tü mmakat Israel. ");
INSERT INTO guc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mmotshi José seema ekerolaa sulu'umüin tü mmakat Judea süka naapüin nüchiki chi nüchonkai Herodes kanüliakai Arquelao sünain nuluwataain cha'aya süchikijee ouktüin chi nüshikai. Je José, süka achiajaanüin nü'lapüinru'u suulia ekerolaa chamüin, o'una müshia chamüin sulu'umüin tü mmakat Galilea. ");
INSERT INTO guc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Je nüntapa cha'aya, o'unüshi sulu'umüin wane pueulo kanüliasü Nazaret süpüla kepiainjanain naya cha'aya. Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala natüma na nünüikimaajanakana, tü makat: “Nazaretje'ewai chii”. ");
INSERT INTO guc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Je so'u ka'ikalüirua tia, eweetüshi Juan chi owoutisaajüikai sünain aküjaa nüchiki Maleiwa sümüin wayuu cha'aya isashiipa'a sulu'u tü mmakat Judea. ");
INSERT INTO guc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mapü'üshi nia: “Jiyaawajaa jumaala suulia jaainjala süka sülü'ülüin nükalia chi Maleiwakai süpüla aluwatawaa jaa'u”. ");
INSERT INTO guc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Otta Juan, aküjüna achikichi nia paala sümaiwa nütüma Isaías chi nünüikimaajachikai Maleiwa sünain maa: “Owoottaweechi wane wayuu cha'aya isashiipa'a sünain maa: ‘Yapa jütüma nüpüna chi Senyotkai. Juu'ulaa suulia jaainjala süpülapünaa nüntajachin ja'akamüin’ ”. ");
INSERT INTO guc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Otta Juan, kashe'inshi nia wane süta mürüt kanüliasü “camello”, oo'ulaka nüsi'irain, paa'ata. Eküi kaashapü oo'ulaka mapa. ");
INSERT INTO guc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","O'unüsü wayuu watta saalin nünainmüin sulu'ujee Jerusalén, sulu'ujee Judea, je sulu'ujee tü mma sotpünaakat tü süchikat Jordán. ");
INSERT INTO guc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aküjashii naya süchiki naainjala nümüin Maleiwa, je owoutisaajünüshii nütüma Juan cha'aya shiroku tü süchikat Jordán. ");
INSERT INTO guc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Otta süntapa wainma wayuu fariseo oo'ulaka wayuu saduceo nünainmüin Juan shii'iree nuwoutisaajaa, nümakalaka namüin: “Jiakana wüi ouktasiro'ut, e'rülii wayumüin jia. Nnojoleerü kasalajanain jaainjala jümüin jaajüin sükajee ne'e juwoutisaajünüin, nnojoleena jia e'rüin müliaa jaajüin süsala. ");
INSERT INTO guc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Müleka shiimüinreje sünain jükatalaain suulia jaainjala, atüjaaneerü aa'u tia sünainjee tü kasa anasü jaa'inrakat. ");
INSERT INTO guc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Je nnojotsü che'ojaain ju'waataain sulu'u nuu'uliwo'uin jia Abraham. Müleka nnojoliire jaa'inrüin tü nuluwataakat anain jia Maleiwa, süsaleena jia nütüma. Müleka nücheküle Maleiwa, eesü süpüla jaa'a sümeerüin tü ipakalüirua nütüma süpüla shiainjatüin nuu'uliwo'uin Abraham. ");
INSERT INTO guc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Müleka nnojorule jaa'inrüin tü anasükat nu'upala Maleiwa, aleejüneena jia nütüma, maa aka süshottünüin sümaa sujutünüin so'u siki wane wunu'u eekai nnojolüin anain süchon. ");
INSERT INTO guc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Tayakai, wayuu ne'e. Nnojoishi wanaapünaain nümaa Cristo, süka pülashin ma'i nia toulia. Na eekai nayaawajaain suulia naainjala, tawoutisaajüin ne'e naya süka wüin. Otta müshia Cristo, anteechi jünainmüin süpüla naapüinjachin jümüin chi Naa'inkai Maleiwa süpüla eeinjachin nia waneepia jümaa. Akaajasa chi eekai ayatüin sünain naainjala, süsaleechi nia nütüma. ");
INSERT INTO guc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O'tte'enneechi chi eekai nünoujain nünain Cristo, maa aka sükatannüin süchon wane a'ttiee suulia tü suwasalakat süpüla sünaajaanüin. Otta chi eekai niyouktüin Cristo, amülouleechi waneepia, maa aka tü suwasalakat sünain sa'ajünüin”, nümakalaka Juan namüin. ");
INSERT INTO guc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nüntakalaka Jesús chajee Galileajee eemüin tü süchikat Jordán süpüla nuwoutisaajünüin nütüma Juan. ");
INSERT INTO guc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Otta müshia Juan, ayouktajüshi nümüin sünain maa nümüin: —Taya tayakai che'ojaaka amüin owoutisaajünaa pütüma, piakalaka ne'e antüin tanainmüin süpüla tawoutisaajaa —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nüsouktakalaka Jesús nümüin: —Anasü müleka paa'inrüle joo tü tachuntakat pümüin, süka kee'ireein taa'in tekeraajüin süpüshua tü nüchekakat chi Maleiwakai tapüleerua —nümakalaka Jesús. Je süka tü nümakat Jesús, naa'inrüin Juan tü nüchuntakat nümüin. ");
INSERT INTO guc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kettaapa nuwoutisaajünüin Jesús, asha'walaa müshia nia shirokujee tü wüinkat. Je wanaa ma'i sümaa tia, eerulaasü tü sirumakat chaa iipünaa. Ni'rakalaka Jesús chi Naa'inkai Maleiwa sünain ashakataa nünainmüin sünain müin aka saa'in wane mo'uwa. ");
INSERT INTO guc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Saapünakalaka joo wane pütchi chaa iipünaajee sünain maa: “Anii chi Tachonkai aishikai tapüla. Talatüshi ma'i taya nümaa”. ");
INSERT INTO guc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","O'uninnüshi Jesús nütüma chi Naa'inkai Maleiwa isashiipa'amüin süpüla nuu'ulakünüin aa'in nütüma Satanás chi sülaülakai yolujaa. ");
INSERT INTO guc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Otta Jesús, süchikijee maa aka pienchi shikii ka'i sünain aamüjaa, ouktüshi nia jamü. ");
INSERT INTO guc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nüntakalaka joo chi Yolujaakai nünainmüin sünain nümüin nümüin: —Müleka Nüchonle pia Maleiwa, puluwataa türa ipakat shii'iranajaaiwa pan —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Asouktüshi Jesús ni'ipajee: —Nnojo. Ashajünüsü paala wane pütchi sulu'u tü karaloukta nüchikimaajatkat Maleiwa, müsü yaa: “Nnojotsü shiain sümüiwa tü pankat katüin atüma so'u wayuu, kateerü o'u shiaya sütüma süpüshua tü nünüikikat chi Maleiwakai” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nu'uninnakalaka joo Jesús nütüma chi Yolujaakai chamüin Jerusalénmüin eemüin tü a'waajüleekat Maleiwa, sünain nüsha'wale'erüin nia iipünaa süralo'u tü miichikat, ");
INSERT INTO guc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","sünain nümüin nümüin: —Müleka Nüchonle pia Maleiwa, pumutta pümata yaajee mmolu'umüin. Aneechi pia saashin tü ashajuushikat makat mayaa: “Nuluwataajeena Maleiwa na aapieekana süpüla naa'inmajüin pia. Najapulu'uinjachi pia suulia sheewa'alaain puu'ui sütüma ipa”, mataa sümakai tü ashajuushikat —nümakalaka chi Yolujaakai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Asouktüshi Jesús: —Nnojo. Müsü tü ashajuushikat: “Nnojo juu'ulaküin naa'in chi Jümaleiwasekai” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nu'uninnakalaka joo Jesús nütüma chi Yolujaakai chamüin iipünaamüin saa'upünaa wane uuchi, sünain nii'iyatüin nümüin tü suumainkalüirua wayuu süpüshua'ale sünain anashaatain ma'i shia. ");
INSERT INTO guc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nümakalaka nümüin Jesús: —Müleka püsapainyo'ukale pia yaa tamülatu'u sünain pu'waajüin taya, taapeerü pümüin tü suumainkalüirua süpüshua'ale —nümakalaka chi Yolujaakai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Asouktüshi Jesús ni'ipajee: —Pu'una pümata toulia Satanás süka ashajuushin paala: “Nia ju'waajüinjachika, chi Jümaleiwasekai nümüiwa, nia ji'yataainjachika amüin nümüiwa” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","O'unamaatüshi chi Yolujaakai nuulia Jesús. Anta müsia wane aapieeirua nüma'anajeejatü Maleiwa nünainmüin Jesús süpüla saa'inmajüinjachin nia. ");
INSERT INTO guc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naapapa Jesús nüchiki Juan sünain püreesain nütüma Herodes, ale'ejüshi Galileamüin sulu'umüin tü pueulokat Nazaret. ");
INSERT INTO guc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O'una müshia nia yalajee sulu'umüin tü pueulo kanüliakat Capernaum süpüla kepiainjachin nia cha'aya. Je Capernaum, sotpa'asü tü palaa kanüliakat Galilea. Shia tü mma kepiapü'ükat alu'u sümaiwa paala na wayuu judío nuu'uliwo'ukana Zabulón oo'ulaka Neftalí. ");
INSERT INTO guc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Antüshi Jesús chamüin Capernaum süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma Isaías chi nünüikimaajachikai, tü makat: ");
INSERT INTO guc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na wayuu kepiakana sulu'u tü mmakat Zabulón oo'ulaka tü mmakat Neftalí, na kepiakana yaa sulu'u tü mmakat Galilea pejekat sünain tü palaakat, pejekat sünain tü süchikat Jordán, na wayuu judíokana oo'ulaka na eekana nnojolüin judíoin, ");
INSERT INTO guc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","na eepü'ükana sümaa piyuushi sünain kaainjalain, naapeerü mapeena nüchiki chi Maleiwakai süpüla nu'tte'erüin naya”. ");
INSERT INTO guc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Shiasa süchikijee so'u ka'ikat tia, o'ttüshi Jesús sünain aküjaa sümüin wayuu sainküin mma sünain maa sümüin: “Jiyaawajaa jumaala suulia jaainjala süka sülü'ülüin nükalia chi Maleiwakai süpüla aluwatawaa jaa'u”. ");
INSERT INTO guc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Je wanaa sümaa waraittüin Jesús sotpa'apünaa tü palaa kanüliakat Galilea, ni'rakalaka piamashii wayuu, wane Simón chi kanüliakai Pedro, oo'ulaka Andrés chi nuwalakai. Ajuna'atshii tü nakusüinkat shiroku tü palaakat süka olojüliin naya jime. ");
INSERT INTO guc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Anashii tamaatalai jia. Maa aka olojüliin jia jime, okotchajüinjana jia wayuu tamüin süpüla saapüinjatüin tanüiki —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Napüta namüsüja tü nakusüinkat süpüla o'unaa nümaa. ");
INSERT INTO guc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nu'unaiwa'aya ne'e Jesús mamüin aka türa, ni'rüin joo piamashii wayuu pawalaawashii, na nüchooinkana Zebedeo. Jacobo nünülia wane, otta Juan chi nuwalakai. Areweentaja'atshii naya tü nakusüinkat yaa sulu'u tü anuakat nümaa chi nashikai. Je neenakünapa nütüma Jesús, ");
INSERT INTO guc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","napüta namüsüja tü na'anuainkat oo'ulaka chi nashikai süpüla o'unaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nu'unakalaka Jesús sainküinpünaa tü mmakat Galilea sünain nikirajüin wayuu sulu'upünaa tü ekirajüleekalüirua wayuu judío cha'aya Galilea. Aküjüshi nia tü pütchi anasükat sümüin wayuu süchiki nukuaippa Maleiwa sünain aluwatawaa, je anasü nütüma wainma wayuu eekai ayuulin sütüma ayuulii eekai eein ne'e. ");
INSERT INTO guc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Su'walakajaakalaka nüchiki Jesús sainküinpünaa Galilea je sainküinpünaa tü mmakat Siria. Je sükajee tia, antinnüsü nünainmüin wainma wayuu eekai ayuulin sütüma ayuulii eekai eein. Antinnüshii na eekai müliain sütüma alin ne'iruku, na eekai kale'eru'uin yolujaa, na eekai ko'kchichijaaraliin, je na eekai ouktüin asa'a. Eiyajünüshii napüshua nütüma. ");
INSERT INTO guc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oushikajaasü wayuu watta saalin nüchiirua Jesús. Eejatü wayuu sulu'ujee Galilea, sulu'ujee tü poloosükot pueuloirua kanüliasü Decápolis, sulu'ujee Jerusalén oo'ulaka Judea, je sulu'ujee tü mma waneekat sa'ata tü süchikat Jordán. ");
INSERT INTO guc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ni'rapa Jesús tü wattakat saalin wayuu antakat nünainmüin, o'unüshi nia saa'umüin wane namüna süpüla ekirajaa naya. Je nüikkalaapa, arütkaashii na nikirajüinkana nünainmüin. ");
INSERT INTO guc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nu'ttakalaka sünain ekirajaa tü wattakat saalin wayuu sünain maa namüin: ");
INSERT INTO guc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Anata'aleeshiija'a ma'i jia e'rakana sünain che'ojaain chi Maleiwakai jümüin, süka jikeroteenain chamüin eere nuluwataain. ");
INSERT INTO guc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Anata'aleeshiija'a ma'i jia a'yalajakana nümüin Maleiwa saa'u jaainjala, süka jümülianneenain nütüma. ");
INSERT INTO guc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Anata'aleeshiija'a ma'i jia nnojoliikana pülain aa'in nuulia Maleiwa, süka saapüneerüin jümüin tü kasa anasü nüsülajeekat. ");
INSERT INTO guc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anata'aleeshiija'a ma'i jia kachiiruakana aa'in aa'inraa tü anasükat, süka nükaaliijain jia Maleiwa süpüla juuntüin jaa'inrüin. ");
INSERT INTO guc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Anata'aleeshiija'a ma'i jia amüliajüliikana wayuu, süka jümüliajüneenain. ");
INSERT INTO guc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anata'aleeshiija'a ma'i jia ulekana aa'in, süka ji'reechin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Anata'aleeshiija'a ma'i jia akaaliijakana na juwalayuukana süpüla anajiraainjanain naya, süka ji'nnaajüneenain sünain nüchooin jia Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anata'aleeshiija'a ma'i jia müliakana aa'in sütüma wayuu saaliijee jaa'inrüin tü nüchekakat Maleiwa jüpüleerua, süka jikeroteenain chamüin eere nuluwataain. ");
INSERT INTO guc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Anata'aleeshiija'a ma'i jia müleka shi'rüle wayumüin wayuu jümüin saaliijee jünoujain tanain, müleka shime'erainparale jia je müleka jaashajaanüle sünain mojuin pütchi jüchiki. ");
INSERT INTO guc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Meerü jukuaippa aka nakuaippa na nünüikimaajanakana Maleiwa paala sümaiwa sünain ne'nnüin amüin natüma na jutuushikanairua. Otta jiakana so'u tü ka'i mülieenakat o'u jia sütüma wayuu, talata jia süka süpüshua jaa'in, süka jütüjaain naa'u chi Maleiwakai sünain nüsülajüinjatüin kasa anashaatakat jümüin chaa iipünaa eere nia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Jiakana, müshii aka jia saa'in ichii jalouikat sümüin wayuu süpüshua. Maa aka nnojolüin sümojujaain asalaa sütüma ichii, akaainjana jia sümüin tü wayuukolüirua süpüla nnojolüinjatüin koo'omüin ma'i saainjala. Otta müleka me'ejüle tü ichiikat, nnojoleerü kasain saamüin sümüin wayuu. Ojotünüsü ne'e anouipa'a süka nnojolüin anain süpüla ekünaa je süpüla shiküin mürüt. Akaajaa chi wayuu eekai nnojolüin noonooin sümaa tanüiki, nnojoleerü kasain naamüin tamüin. ");
INSERT INTO guc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Müshii aka jia saa'in wane anakia, süka shiyaawatüinjatüin saa'u tü shiimüinkat wayuu jütüma. Maa aka ja'yain wane pueulo iipünaa saa'u namüna, akaajaa jiakana sünain jii'iyatüin tü shiimüinkat waneepia sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","¿Jalasü e'itaanüin wane luusa shipejaanüle? ¿E'itaanüsü cheje suupünaa wushu? Nnojo. E'itaanüsü eere süpülee luusa süpüla sünaküinjatüin kasa süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Akaajaa jiakana, müleka jaa'inrüin waneepia tü anasükat su'upala wayuu. Je sükajee ne'rüin tü kasa anasü jaa'inrakat, nayaawateerü aa'u nukuaippa Maleiwa je na'waajeechin nia. ");
INSERT INTO guc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“¿Antüshi taya jaajüin süpüla sümalajaainjatüin tatüma tü nuluwataakat anain Moisés oo'ulaka tü nashajakat na nünüikimaajanakana Maleiwa? Nnojo. Shia tantaka apüla takaaliijain jia süpüla joonooinjanain sümaa tü nümakat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Shiimüin tü tamakat jümüin: Tü mmakat je tü kasa chakat iipünaa, aja'lajaweerü so'uweena wane ka'i. Otta tü nünüikikat chi Maleiwakai ashajünakat paala nütüma Moisés, nnojoleerü aja'ttüin waneeshikaiyaaje no'u pütchi sünainjee wane'ere'eya shikeraajapa süpüshua tü süküjakat achiki. ");
INSERT INTO guc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chi wayuu eekai moonooin sümaa tü pütchi aluwataanakat anain nütüma Moisés, ja'itairü waneeshikaije ne'e pütchi shiyouktünüle nütüma, otta nikirajüle wayuu sünain moonooloinjanain naya sümaa, mojuteechi nia cha'aya eere nuluwataain Maleiwa. Akaajaa chi oonookai sümaa tü nuluwataakat anain, sümaa nikirajüin sünain, kojuteechi nia cha'aya. ");
INSERT INTO guc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tamüshii paala jia: Müleka nnojorule jülatüin sünain anain jia noulia na fariseokana oo'ulaka na karalouktamaajanakana sünain jikeraajüin tü nüchekalakat chi Maleiwakai jüpüleerua, shiimüin sünain nnojoleenain ekerolüin jia cha'aya eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Nnojo pu'utüin saa'in wayuu. Je chi o'utakai saa'in wayuu, shiimüin sünain kasalajaneerüin nümüin tü naa'inrakat’. ");
INSERT INTO guc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Chi eekai naashichijaain nümüin wane nuwala, shiimüin sünain kasalajaneerüin nümüin tia nütüma Maleiwa. Otta müshia chi eekai ni'rüin wayumüin süka nünüiki nümüin wane nuwala, shiimüin sünain kasalajaneerüin nümüin tia natüma na laülaayuukana. Otta müshia chi eekai mojuin nünüiki nümüin wane nuwala sünain ‘maa'in aa'inchi pia’ sünain nümüin nümüin, eesü süpüla nujutüneechin so'umüin tü sikikat eere süpülee tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Sükajee tüü, wanaa sümaa püsülajüin kasa nümüin Maleiwa eere süpülee asülajaa, müleka sotüle paa'in sünain mojuin nünüiki pümüin wane puwala, ");
INSERT INTO guc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","anakaja müleka püpütüle tü püsülajüinjatkat yaala sü'ütpa'a tü süpüleekat asülajaa süpüla pu'unüinjachin nünainmüin chi puwalakai süpüla pukumajiraain sukuaippa nümaa. Je süchikijee, ale'eja meechia pia süpüla asülajaa nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","“Müleka kaainjarale pia nuulia wane puwala, acheküshi pütüjamaatüin pünüiki nümüin süpülapünaa nuluwataain wane pütchipü'ü pünainmüin suulia kojutajüin püpüleerua. ");
INSERT INTO guc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Nnojo püma'üjaain sümaa wayuu nnojotkat pu'wayuusein otta nnojoikai pu'wayuusein’. ");
INSERT INTO guc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Chi eekai niirakaain sümüin wane jierü sümaa kee'ireein naa'in ama'üjirawaa sümaa, shiimüin sünain kaainjalain nia wanaa nümaa eekai nüma'üjaain sümaa wayuu nnojotkat nu'wayuusein. ");
INSERT INTO guc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jalia pia suulia kaainjalaa sükajee tü kasa pi'rakat. Anasüje ne'e amüloulire puulia waneesia po'u suulia pikerolüin chamüin Hadesmüin sümaa tü piamasükat po'u, chaa eemüinjachire pujutünüin eere süpülee tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jalia pia suulia kaainjalaa pia sükajee tü kasa paa'inrakat süka pajapü. Anasüje ne'e amüloulire puulia waneesia pajapü suulia pikerolüin chamüin Hadesmüin sümaa tü piamasükat pajapü, chaa eemüinjachire pujutünüin eere süpülee tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Müleka nücheküle wane wayuu süpüleerua nuu'ulaain suulia tü nu'wayuusekat, che'ojaasü nüshajüin wane karaloukta aapiria tü nu'wayuusekat sünain nuu'ulaainjatüin shia’. ");
INSERT INTO guc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Chi eekai nuu'ulaain suulia nu'wayuuse, sümaa nnojolüin süma'üjiraasüin nümaa wane wayuu naata nuulia, ni'rala wayumüin sümüin. Süka jamüin, müleka ka'wayuusere tü jietkat süchikua, kaainjalasü. Je kasalajaneerü sümüin süma'üjaain nümaa chi jekechikai su'wayuusein. Akaajaa chi wayuu ka'wayuusekai tü jierü oo'ulaaushitkat, kaainjalashi nia'aya, je kasalajaneerü nümüin nüma'üjaain sümaa tü jierü oo'ulaaushitkat. ");
INSERT INTO guc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Müleka pümüle nümüin Maleiwa, “Pansaasü tanüiki pümüin”, anasü müleka pikeraajüle shia’. ");
INSERT INTO guc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Anakaja müleka lotüle pünüiki waneepia sümüin wayuu süpüshua sünain nnojolüinjachin püküjain alawaa. Nnojo ne'e shiainjatüin pansaakat o'u pünüiki o'upalaa, maa aka su'upala tü kasa chakat iipünaa eere Maleiwa, süka chain nuluwataain Maleiwa, ");
INSERT INTO guc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","maa aka su'upala tü kasa yaakat mmalu'u, süka shiain akumajuushin nütüma Maleiwa, maa aka su'upala tü kasa chakat sulu'u Jerusalén, süka shiain nepiain na wayuu aluwataaushikana nütüma Maleiwa, ");
INSERT INTO guc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","je maa aka pükajiraa piakai saa'u laülaain pia pümüiwa. ");
INSERT INTO guc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Müleka paa'inrüinjatüle wane kasa, ‘Aa’ meeshi ne'e pia. Je müleka nnojolüinjatüle paa'inrüin shia, ‘Nnojo’ meeshi ne'e pia. Atüjaaneena aa'u jia sünain pansaain jünüiki sükajee tia. Chi eekai nikirajüin naata suulia tüü, nia chi Kama'üraikai. ");
INSERT INTO guc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Müleka saa'innüle wane kasa mojusü pümüin, anakaja müleka paa'inrüle shia sümüin tü aa'inrakat pümüin. Maa aka chi wayuu eekai niyu'lüin so'u wane wayuu, anasü shiyu'nnüle no'u. Je maa aka chi wayuu eekai niyuutüin sai wane wayuu, anasü shiyuutünüle nai’, makat. ");
INSERT INTO guc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Nnojo kee'ireein paa'in pasalawaa. Müleka süshe'etünüle pu'upünaa sütüma wane wayuu e'rülü wayumüin, anasü müleka nnojorule püchekajüin shia. Shia anaka alu'u müleka pujununtaale süpüla süshe'etünüin tü wane'e. ");
INSERT INTO guc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Je müleka süchuntünüle pümüin wane püshe'in saa'u paainjala, anasü müleka paapaleere tü sutujunakat. ");
INSERT INTO guc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Je müleka püta'ünnüle süpüla e'ikaa wane chisoui waneemüin kilómetro, anasü müleka pi'ikale'ere piama kilómetro. ");
INSERT INTO guc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Je nümüin eekai che'ojaain kasa nümüin, püsülaja nümüin. Nnojo je'iyein pia nuulia. ");
INSERT INTO guc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ji'raajüin tü nümapü'ükat Moisés namüin na jutuushinuukana sümaiwa paala, tü makat mayaa: ‘Anashii aire jüpüla na jüpüshi judíokana. Otta na jü'ünüükana, anashii kanainre jaa'in naya’. ");
INSERT INTO guc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Otta tanüiki tayakai joolu'u jümüin, müsü mayaa: Anashii aire jüpüla na jü'ünüükana. Je anashii juchuntüle nümüin Maleiwa naa'u na e'rüliikana wayumüin jümüin ");
INSERT INTO guc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","süpüla ji'nnaajünüinjanain sünain nüchooin jia Maleiwa chakai iipünaa, süka nüntirüin nuwarala chi ka'ikai je nü'itirüin tü juyakat sünainmüin wayuu eekai kaainjaralin je eekai anamiain. ");
INSERT INTO guc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Müleka aire ne'e jüpüla tü wayuu aikat apüla jia, shia ne'e saa'inraka wayuu süpüshua. Mayaashiije kaainjaraliin naya, aisü napüla wayuu aikat apüla naya. ");
INSERT INTO guc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Je müleka jüsaküle ne'e na juwalayuukana namüiwa, shia ne'e saa'inraka wayuu süpüshua. Aa'innüsü tia natüma na manoujainsaliikana. ");
INSERT INTO guc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Otta jiakana, anasü müleka aire wayuu süpüshua jüpüla maa aka naa'in chi Maleiwakai sünain alin shia nüpüla süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Jalia jia suulia kee'ireejüin jaa'in ji'nnüinjanain sütüma wayuu wanaa sümaa jaa'inrüin tü kasa anasü nüchekakat Maleiwa jüpüleerua. Müleka jaa'inrüle ne'e shia su'upala wayuu süpüla ji'nnüinjanain sütüma, mawalaajuujeena jia nütüma chi Jüshikai Maleiwa chakai iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Wanaa sümaa jüsülajüin sümüin wayuu eekai müliain, nnojo müin aka jia naa'in na wayuukana aapitkana süka kaasha sulu'u tü ekirajüleekalüirua je sulu'u tü wopukot süchiki tü kasa anasü naa'inrakat, süka wayuuin piama o'upünaachii naya. Shiimüin tü tamakat jümüin: Mayaashiije na'waajünüin sütüma wayuu, nnojoleena a'waajünüin naya nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Otta jiakana, wanaa sümaa jüsülajüin sümüin wayuu eekai müliain, jaa'inra tia sujuuna wayuu süpüshua süpüla nnojolüin sütüjaain saa'u. Nia Maleiwa chi Jüshikai atüjaaka saa'u tü kasa anasü jaa'inrakat sujuuna wayuu. Nuwalaajeena jia sükajee tia. ");
INSERT INTO guc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wanaa sümaa jüchuntüin nümüin Maleiwa, nnojo müin aka jia naa'in na wayuu alaayaakana. Asha'walaashii naya su'upala wayuu sulu'u tü ekirajüleekalüirua je sulu'u tü wopukot sünain achuntaa nümüin Maleiwa süka kee'ireein naa'in e'nnaa sütüma wayuu. Shiimüin tü tamakat jümüin: Mayaashiije na'waajünüin sütüma wayuu maa'ulu yaa, nnojoleena a'waajünüin naya nütüma Maleiwa mapeena. ");
INSERT INTO guc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Otta jiakana, wanaa sümaa jaashajaain nümaa Maleiwa, jüsürülaa jipialu'umüin süpüla jüchuntüinjanain nümüin sujuuna wayuu süpüshua. Chi Jüshikai Maleiwa, nütüjaajeerü aa'u tü jaa'inrakat sujuuna wayuu je nuwalaajeena jia sünainjee tia. ");
INSERT INTO guc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Je tü jukuaippainjatkat sünain achuntaa nümüin Maleiwa, nnojoleerü müin aka sukuaippa wayuu eekai süchuntüin sümüin tü sümaleiwaseyaasükalüirua. Kaashajaaralii ma'i naya. Aapüneerü, saa'in namüin, tü nachuntakat apüla sükajee kama'ain ma'i naya sünain achuntaa. ");
INSERT INTO guc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Otta jukuaippa jiakana, nnojoleerü müin aka nakuaippa. Süpülapünaa jüchuntüin, nütüjaa aa'ut chi Jüshikai Maleiwa süpüshua tü che'ojaakat jümüin. ");
INSERT INTO guc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Meena jia jüchuntapa nümüin Maleiwa: Taata Maleiwa chakai iipünaa, kojutshaatashi pia watüma. Kasataalejese kojutüin pia sütüma wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kasataalejese püntüin maalü wa'akamüin sünain aluwatawaa. Kee'ireesü waa'in soonooin wayuu süpüshua yaa mmalu'u sümaa pünüiki, maa aka soonooin tü aapieekalüirua chakat iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Anakaja müleka paapawaire wamüin weküin süpüla wane'ewai ka'i. ");
INSERT INTO guc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anakaja motüle paa'in tü waainjalakat, maa aka wayakana sünain motüin waa'in süma'üla eekai süma'ülapalain waya. ");
INSERT INTO guc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Je nnojo piyüülajüin waya süpüla oo'ulakünaa aa'in. Anasüje müleka pu'tte'erüle waya nuulia chi Kama'üraikai. Shia jüchuntiainjatka tia nümüin. ");
INSERT INTO guc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Müleka motüle jaa'in tü saainjalakat wayuu eekai kaainjalain juulia, alatinneerü jaainjala juuliaya nütüma chi Jüshikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Otta müleka nnojorule motüin jaa'in tü saainjalakat, nnojoleeria alatinnüin jaainjala juulia nütüma. ");
INSERT INTO guc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wanaa sümaa jaamajüin, nnojotsü ja'yashinjatüin sünain ju'upünaa tü aamüjaakat süpüla sütüjaainjatüin jaa'u wayuu. Shia nakuaippaka'aya na wayuu piama o'upünaachiikana tia. Shiimüin tü tamakat jümüin: Mayaashiije na'waajünüin sütüma wayuu saa'u naamajüin maa'ulu yaa, nnojoleena a'waajünüin nütüma Maleiwa mapeena. ");
INSERT INTO guc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Otta müshi'iya jiakana, wanaa sümaa jaamajüin, anakaja müleka jüpeinajaale ju'wala sümaa ju'lojooin ju'upünaa, ");
INSERT INTO guc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","süpüla nnojolüinjatüin shiyaawatüin wayuu saa'u sünain jaamajüin. Nia chi Jüshikai Maleiwa nümüiwa atüjaaka jaa'u je nuwalaajeena jia sünainjee tia. ");
INSERT INTO guc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Anakaja müleka nnojorule jünaajaain kasa anasü yaa mmalu'u eere she'e mma aja'ttirüinjatkat shia je eere su'luwajünüin. ");
INSERT INTO guc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Müleka jaa'inrüle tü anasükat sümüin wayuu, naapeerü jümüin Maleiwa tü kasa anasü matüjainkat ke'ewaa, matüjainkat aja'ttaa, matüjainkat a'luwajünaa, süka nüma'anain shia Maleiwa chaa iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Je sükajee tia, acheküsü jülüjain jaa'in tü kasa anasü chakat iipünaa aapünüinjatkat jümüin. Nnojo jülüjain jaa'in waneepia tü kasa jünaajaakat yaa mmalu'u. ");
INSERT INTO guc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Otta tü wo'ukot, müsü aka saa'in suwarala luusa, süka we'rüin tü kasa wapüleeruakat sütüma. Müleka anale tü wo'ukot, we'rüin tü kasakat süpüshua sütüma. ");
INSERT INTO guc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akaajasa mo'upa'ale waya, müsatüsü tü mmapa'akat wo'ulu'u. Akaweeria müleka ulere tü jaa'inkat, jüüjüüjeena jia sünain aa'inraa tü anaakat. Otta müleka yarüttüle jaa'in, shieerü jaa'inraka tü mojusükat, nnojoleerü jaa'inrüin tü anaakat. Otta müleka ayatüle ulein tü jaa'inkat sümaa jiyouktüin tü yarüttüsükat, jaa'inreerü tü anaakat waneepia sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Maa aka kojuta'atüle piamashii laama nütüma chi a'yataaikai sünain alin nüpüla wane je sünain maalin nüpüla chi wane'e, meechi aka Maleiwa jütüma müleka shiale kachiiruain jaa'in tü washirüükat nuuliale'eya. ");
INSERT INTO guc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nnojo jüshapataain aa'in saa'u tü jiküinjatkat je tü jüsüinjatkat, katüinjatkat atüma jo'u, je saa'u tü kuluulu ja'atajatkat anainjatkat atüma jiyolojo. Tü talateetkat atüma jaa'in, nnojotsü shiain ne'e tü eküülü katüinjatkat atüma jo'u, nnojotsü shiain ne'e tü kuluulu anainjatkat atüma jiyolojo. ");
INSERT INTO guc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jülüja jaa'in sukuaippa tü wuchiikalüirua. Mapünajüinsat shia je manaajaalasat shia shiküin, nnojotpaja e'rüin jamü shia, süka shikinnüin nütüma chi Jüshikai Maleiwa chakai iipünaa. Jialeeka jiakana, aa'inmajünüshii waneepia nütüma Maleiwa, süka alana'aleein jia sünain kojutüin nütüma suuliale'eya tü wuchiikalüirua. ");
INSERT INTO guc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Je tü shapawaakat aa'in, nnojoleerü kasain saapüin jümüin süpüla epijawaa. ");
INSERT INTO guc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Jamüsü jüshapajaaka'a saa'u tü jüshe'injatkat? Jülüja jaa'in sukuaippa tü süsiikat tü wüitshiikat sünain anashantain ma'i tü süno'ukot. Mayaainje nnojolüin a'yataain je nnojolüin saainjüin süshe'in, ");
INSERT INTO guc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","alana'aleesia ma'i sünain anachonin shiyolojo suuliale'eya süno'u nüshe'in Salomón chi washitshaanakai sülaülashikai mma paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¿Jamüsü nnojotka'a jünoujain sünain jaa'inmajünüin nütüma Maleiwa? Tü süsiikat, anashaatasü ma'i süno'u nütüma Maleiwa, mayaasüje julumaatüin shia sümaa sa'ajünüin mapa. Müshi'iya jiakana, aa'inmajünüshii nütüma suuliale'eya tü süsiikalüirua wüitshii. ");
INSERT INTO guc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Je sükajee tia, nnojo jüshapajaain aa'in sünain müin jünüiki: ‘¿Kasa weküinjatka? ¿Kasa wasüinjatka? ¿Kasa wa'atüinjatka?’. ");
INSERT INTO guc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ashapataasü ma'i naa'in na manoujainsaliikana waneepia saa'u kasa eekai müin aka tia. Alu'ujasa jiakana, anakaja müleka nnojorule jüshapataain aa'in saa'u tia maa aka naa'in nayakana. Soto jaa'in sünain nütüjaain saa'u chi Jüshikai Maleiwa tü che'ojaakat jümüin je naa'inmajeena jia waneepia. ");
INSERT INTO guc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tamüshii jia wane'ewa'i jukua: Müleka keejiale jümüin niainjachin chi Maleiwakai aluwataain jaa'u sümaa kee'ireein jaa'in tü nüchekakat jüpüleerua, aapüneerü jümüin süpüshua tü che'ojaakat jümüin. ");
INSERT INTO guc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Je sükajee tia, nnojo jüshapajaain aa'in saa'u tü alateetkat mapeena, süka wainmeerüin tü kasa jülüjüinjatkat jaa'in mapeena. Nnojotsü anain jüshapataale aa'in saa'u kasa wainma maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ ‘Kaainjarai nia’ anakaja nnojorule jümüin sümüin wane wayuu. Müleka jaa'inrüle tia, ‘Kaainjarai pia’ meechi chi Maleiwakai jümüin. ");
INSERT INTO guc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Süka jamüin, müleka mamüliajule chi wayuukai jütüma, nnojoleena jia nümüliajüin Maleiwa. Je müleka jiyoujüle nia sünainjee wane wwatua ne'e naainjala, akaweenia jiakana nütüma Maleiwa ja'itasü wwatuain ne'e jaainjala. ");
INSERT INTO guc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","“Jia ayoojaakana waneepia na juwalayuukana, müshii aka jia naa'in wane wayuu eekai ni'rüin yarüttüsü sulu'u no'u chi nuwalakai sünain, ‘Tawalaa, anashi tayu'rule tü yarüttüsükat sulu'ujee po'u’, sünain nümüin nümüin. Otta nnojotsü nütüjaain aa'u sünain eein wane sa'ata wunu'u sulu'u tü no'ukalia ma'i. ");
INSERT INTO guc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jiakana piamakana akuaippa, müleka juu'ulaale suulia kaainjalaa, juunteerü jii'iyatüin namüin na juwalayuukana sünain kaainjalain naya. ");
INSERT INTO guc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tü kasa anasü akatannakat süpüla saapünüinjatüin nümüin Maleiwa, nnojo jujutüin shia sümüin wane erü, süka yarüttüin tü mürütkat no'ulu'u Maleiwa. Müleka jaapüle shia sümüin, awataajeerü jünainmüin sünain sojottüin jia. Otta tü kasa anasükat, nnojo jojotüin shia'aya sümüin püülükü, süka nnojolüin shiyaawatüin saa'u sünain akataluushin nümüin Maleiwa. Sü'tküteerü aa'u ne'e. ");
INSERT INTO guc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Anakaja müleka juchuntüle nümüin Maleiwa waneepia süka süpüshua jaa'in. Maa aka wane wayuu nuchuntüle, aapüna amüinchi. Maa aka wane wayuu mekeerüle, nünta anainrü tü nüchajaakat achiki. Maa aka wane wayuu nütaletüle miicho'u, ajutanna apüleechi. ");
INSERT INTO guc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Jamüsü jukuaippa jiakana namüin jüchonnii? Maa aka nüchuntüle pümüin wane pan chi püchonkai, ¿paapeerü wane ipa nümüin? Nnojo taa. ");
INSERT INTO guc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jama müleka nüchuntüle wane jime, ¿paapeerü wane wüi nümüin? Nnojo taa. ");
INSERT INTO guc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eereje'e ne'e wayuuin kaainjaraliin jia, atüjashii jia aapaa kasa anasü namüin na jüchooinkana. Nialeeka chi Jüshikai Maleiwa chakai iipünaa, alana'aleeshia ma'i sünain anamiain jümüin. Naapeerü kasa anasü jümüin müleka jüchuntüle nümüin. ");
INSERT INTO guc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anasü müleka jaa'inrüle tü anasükat sümüin wayuu, maa aka jücheküin saa'inreein tü anasükat jümüin. Shia aluwataanaka anain wayuu nütüma Moisés oo'ulaka natüma na nünüikimaajanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Chi eekai nnojolüin nünoujain tanain, nnojoleechi ountüin ekeroloo chamüin eere nuluwataain Maleiwa. Wainmeerü wayuu mekerolüinkat süka nnojolüin nanoujain tanain. Müshii aka naya saa'in wayuu eekai süneeküin o'unaa sulu'u wopu eekai jerulüin saa'u mapüleein napüleerua. Otta na anoujashiikana tanain, nnojoleena wainmain. Müshii aka naya saa'in wayuu eekai süneeküin wopu eekai moulin ja'itasü kapüleein napüleerua. Anakaja müle aka jia naa'in na wayuu o'unakana sulu'u wopu mouisü. ");
INSERT INTO guc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Jalia jia suulia jünoujain nanüiki na nünüikimaajanayaakana Maleiwa. Anamiayaashii naya sümaa kee'ireein naa'in namalajirüin tü jünoulakat. ");
INSERT INTO guc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jütüjaajeena aa'u sünain naküjain alawaa sükajee tü kasa naa'inrakat ji'rüin. Jülüja jaa'in sukuaippa wane wunu'u. Müleka shi'nnüle süchon tü wunu'ukot, atüjaaneerü aa'u kasain kachoin. Tü uuwakat, nnojotsü atpajünüin sünainjee wunu'u eekai keimsein, je tü süchonkot ‘higuera’, nnojotsü atpajünüin sünainjee wunu'u eekai eein ne'e. ");
INSERT INTO guc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Wane wunu'u eekai shikaajünüin achoin, anasü tü süchonkot, nnojotsü kachoin eekai mekaajuuin. Otta wane wunu'u eekai mekaajuuin süchon, nnojotsü kachoin eekai shikaajünüin. ");
INSERT INTO guc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Süpüshua tü wunu'ukolüirua eekai nnojolüin anain süchon, ashottüneerü sümaa sujutünüin so'u siki. ");
INSERT INTO guc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Akaajaa na nünüikimaajanayaakana Maleiwa, jütüjaajeena aa'u sünain naküjüin alawaa sükajee tü kasa naa'inrakat ji'rüin. ");
INSERT INTO guc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mayaasüje, ‘Senyotkalee, kojutüshi pia watüma’ jümüin tamüin, müleka nnojorule jaa'inrüin tü nüchekakat jüpüleerua chi Tashikai chakai iipünaa, nnojoleena ekerotüin jia cha'aya eemüinre nuluwataain. ");
INSERT INTO guc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Je so'uweena tü ka'i süsaleetkat o'u wayuu saainjala nütüma Maleiwa, meerü wayuu wainma tamüin: ‘Senyotkalee, ¿nnojotsü shiimüin sünain laülaain waya pütüma sünain waküjapü'üin pünüiki, sünain wayu'lapü'üin yolujaa süle'eru'ujee wayuu, je sünain waa'inrapü'üin tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa?’. ");
INSERT INTO guc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Otta tayakai, meechi taya namüin: ‘Jia kaainjaraliikana, ¿joujanakai jia te'raajüin? Ju'una yaajee toulia’. ");
INSERT INTO guc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Chi wayuu eekai nüntüin tanainmüin, sünain naapajüin tü tekirajakat anain, sünain naa'inrüin waneepia tü taluwataakat anain nia, ¿kasa maka aka nia? Müshi aka nia naa'in wane wayuu eekai yalayalain süpüla aainjaa miichi. Nüpotüin tü mmakat süpüleerua tü nipiakat süpüla nükumajüinjatüin shia saa'u ipa. ");
INSERT INTO guc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Je süntapa wane juya miyo'ushaata sünainmüin tü miichikat sümaa katsüin tü jouktaikat, nnojotsü ojuttüin shia, süka ichein ma'i sükumajia. ");
INSERT INTO guc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Akaajasa chi wayuu eekai naapajüin tü tekirajakat anain sünain nnojolin naa'inrüin tü taluwataakat anain, müshia aka nia naa'in wane wayuu eekai matüjain süpüleerua aainjaa miichi. Nükumajüin tü miichikat saa'u mma ne'e sünain nnojolin nüpotüin tü mmakat süpüleerua tü nipiakat. ");
INSERT INTO guc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Je süntapa wane juya miyo'ushaata sünainmüin tü miichikat sümaa katsüin tü jouktaikat, ojuttüsü shia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Je kettaapa nünüiki Jesús sünain ekirajaa tü wayuukolüirua cha'aya saa'u tü namünakat, ponusü ma'i naa'in na wayuukana tü nünüikikat, ");
INSERT INTO guc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","süka shiyaawatüin saa'inyaka naa'u sünain ni'itaaushin nütüma Maleiwa süpüla ekirajaa nünüiki, süka nnojolüin müin aka naa'in na karalouktamaajanakana. ");
INSERT INTO guc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Je nüshakatapa Jesús saa'ujee tü namünakat, o'unüsü wayuu watta saalin nümaa. ");
INSERT INTO guc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Arütkaashi nünainmüin wane wayuu mayeinshi sütüma aja'ttaa ata. Asapainyo'ukashi nia nümülatu'u Jesús sünain nüchuntüin nümüin: —Senyotkalee, müinka pücheküle, piiyaja taya —nümakalaka chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Niyurulakalaka joo nütüna Jesús nünainmüin chi ayuuishikai sünain naapaain nia. —Tacheküin süpüleerua anainjachin pia —nümakalaka nümüin. Anaichipa joo chi wayuukai. Nnojolüitpa aja'ttüin tü nütakat. ");
INSERT INTO guc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aashajaashi joo Jesús nümüin chi wayuukai nüchikua: —Otta müshia joolu'u, nnojo püküjain sümüin wayuu püchiki sünain teiyajüin pia. Pu'una palajana eemüin chi sacerdotekai süpüla pii'iyatüinjatüin nümüin tü pütakat süpüla naapüinjatüin nümüin Maleiwa tü mürüt ouktajatkat saa'u anaichipain pia, maa aka tü nuluwataakat anain Moisés paala sümaiwa. Je sükajee tia, sütüjaajeechi aa'u pia wayuu sünain anaichipain pia süpüla sa'akainjachin pia püchikua —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Je nikerolapa Jesús sulu'umüin tü pueulokat Capernaum, arütkaashi wane sülaülashi surulaat nnojoikai judíoin nünainmüin. Nüchuntakalaka kaalinyüü nümüin Jesús: ");
INSERT INTO guc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Senyotkalee, ayuuishi chi tachepchiakai tepialu'u. Müliashi ma'i nia sütüma ouktüin nüsa'a —nümakalaka chi sülaülashikai surulaat. ");
INSERT INTO guc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nümakalaka Jesús: —O'uneechi joo taya pümaa teiyajaiwa nia. ");
INSERT INTO guc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Otta chi sülaülashikai surulaat, nüsouktakalaka nümüin Jesús: —Nnojoishi kasajachin taya pümüin, saa'in tamüin. Otta müleka püküjale ne'e wane pütchi, tatüjaa aa'ut sünain aneechin chi tachepchiakai sütüma tü pümakat. ");
INSERT INTO guc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tayakai, laülaashi taya saa'u surulaat. Tatüjaain saa'u aluwataanaa maa aka tatüjaain saa'u aluwatawaa. Müleka tajütüle wane surulaat, o'unüshi. Müleka teenaküle nia, antüshi. Müleka taluwataale chi tachepchiakai, naa'inramaatüin motso'o tü taluwataakat anain nia —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Oponojoosü ma'i naa'in Jesús sütüma tü nümakat chi sülaülashikai surulaat. Ajununtaashi joo sünain nümüin sümüin tü wayuukolüirua wattakat saalin eekat nümaa: —Shiimüin tü tamakat jümüin: Miyo'utaaleeja'a nünoula chi sülaülashikai surulaat tanain. Nnojoishi eein wane makai aka naa'in sünain anoujaa tanain, ja'itakaja ne'e na'aka na wayuukana Israelkana. ");
INSERT INTO guc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tamüshii paala jia: Anteerü wayuu wainma eekai wüinpujeekualüin oo'ulaka eekai wopujeekualüin sünain ekerolaa chamüin eere nuluwataain Maleiwa sünainmüin wane ekawaa miyo'u nümaa Abraham oo'ulaka Isaac oo'ulaka Jacob. ");
INSERT INTO guc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Otta na wayuu aneekünakana paala süpüla nayainjanain na nüpüshikana Maleiwa, süka nayouktüin nia, ayouktüneena naya nütüma süpüleerua nekerolüin cha'aya nünainmüin. A'yalajeena ma'i naya süka makatüinjanain anouipa'a sa'aka piyuushi —nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nümakalaka Jesús joo nümüin chi sülaülashikai surulaat: —Anakaja pu'unüle. Aneechi joo chi püchepchiakai nütüma Maleiwa süka pünoujain sünain anainjachin nia tatüma —nümakalaka Jesús nümüin. Je chi nüchepchiakai, anaichipa nia wanaa ma'i sümaa naashajaain Jesús nümaa chi sülaülashikai surulaat. ");
INSERT INTO guc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Shiasa mapa, antüshi Jesús nipialu'umüin Pedro. Eejatkalaka nüpüla tü nimeshikat Pedro sünain ayuulin sütüma aapuwaa. ");
INSERT INTO guc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nürütkaakalaka joo sünainmüin sünain naapaain sajapü. Naawale'erakalaka tü ayuuliikat suulia. Je süka anaitpain shia, atamaamaatüsü sünain shikirüin nia. ");
INSERT INTO guc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Je motsopa ka'i, antinnüsü wainma wayuu kale'eru'usü yolujaa nünainmüin Jesús. Nujuittirakalaka tü yolujaakalüirua süka nünüiki je niiyajüin tü ayuuisükalüirua süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai nüchiki Cristo aküjünakat paala nütüma Isaías chi nünüikimaajachikai sünain maa: “Taashishii waya nütüma suulia süpüshua tü ayuulii eekat wanain”. ");
INSERT INTO guc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ni'rapa Jesús tü wayuu wattakat saalin nü'ütpa'a, “Anashii wo'unüle waneemüin sa'ata tü palaakat”, nümakalaka namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Je nnojoliiwa'aya no'unüin sulu'u tü anuakat, arütkaashi wane karalouktamaajachi nünainmüin Jesús sünain nümüin nümüin: —Ekirajüikalee, pümaajeechi taya eepünaale pia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nüsouktakalaka Jesús nümüin: —Tü walitkalüirua, eesü ishi süpüla eeinjatüle sütunküin. Je tü wuchiikalüirua, kepiasü iipünaa eere sütunküle. Otta tayakai, chi Shipayakai Wayuu, mepiasai —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Otta nünüiki wane nikirajüinkai Jesús, müsü mayaa: —Senyotkalee, alü'ütsü nükalia chi tashikai süpüla ouktajachin. Anashi tojoitüle nia palajana süpülapünaa to'unüin pümaa —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nüsouktakalaka Jesús nümüin: —Anakaja nayale ojoitüin, na püpüshi makana saa'in wayuu ouktüsü saa'u nnojolüin nanoujüin tanain. Otta piakai, anakaja pu'unüle tamaa —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","No'otookoloko Jesús sulu'umüin tü anuakat namaa na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Je süma'inru'u waraittüin tü anuakat shirokupünaa tü palaakat natüma na nikirajüinkana, anta müsia joo wane wawai nanainmüin sünain shi'yotüin palaa sulu'umüin tü anuakat. Otta müshia Jesús, atunküshi. ");
INSERT INTO guc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Narütkaakalaka na nikirajüinkana nünainmüin. —Senyotkalee, püchijiraa maala süpüla pu'tte'erüinjanain waya. Ouktüshii taa waya —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nüsouktakalaka Jesús namüin: —¿Jamüshii mmotka'a jia? ¿Jamüshii nnojoliika'a jünoujüin paala sünain to'tte'erüinjanain jia suulia tü wawaikat? —nümakalaka namüin. Nüsha'walaakalaka Jesús sünain nüchiajaain tü wawaikat sümaa tü palaa ko'ontakat nanainmüin. Ejimalaa müsia joo tia sütüma nünüiki. ");
INSERT INTO guc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Otta na nikirajüinkana: —¿Jaraikai wayuukai chii, kache'ekai amüin wawai oo'ulaka tü palaakat? —namakalaka sünain ponüin naa'in tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Je süntapa tü anua kalu'ukot Jesús namaa na nikirajüinkana waneemüin sa'ata palaakat eere kepiain wane wayuuirua kanüliajüsü Gadareno, eeshii napüla piamashii wayuu kale'eru'ushii yolujaa. Nantakalaka nünainmüin Jesús sa'akajee tü amuuyuukalüirua. Saa'u jashichipü'üin naya, mmotpü'üsü wayuu seema waraittaa chapünaa cha'aya eere kepiain naya. ");
INSERT INTO guc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Emetutsü joo nanüiki na yolujaa nale'eru'ukana na wayuukana sünain namüin: —Jesúsuu, Nüchonka'iya Maleiwa, ¿jamüinjatü wakuaippa pütüma? ¿Antüshi pia süpüla müliainjanain waya pütüma süpülapünaa tü ka'i süsalainjanakat o'u waya waainjala? —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eejatü wane püülüküirua wainma ekajaain maa aka tüsa. ");
INSERT INTO guc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nachuntüin na yolujaakana wainmatua nümüin Jesús sünain namüin nümüin: —Müleka pujuittirüle waya, anakaja müleka püjütüle waya süle'eru'umüin tia püülükkalüirua —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Ju'una jümaarüleen —nümakalaka Jesús namüin. Ojuitta müsüja tü yolujaakalüirua nale'eru'ujee na wayuu piamashiikana sünain shikerolüin süle'eru'umüin tü püülükkalüirua. Apantajaayaa müsü tü püülükkalüirua saa'ujee tü namünakat shirokumüin tü palaakat. Oo'uwo'utkalaka shia süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na arüleejüliikana tü püülükkalüirua, apantajaashii naya sulu'umüin tü pueulokat sünain aküjaa süchiki tü püülükkalüirua je nachiki na piamashii kale'eru'ushiikana yolujaa. ");
INSERT INTO guc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Otta na wayuu aapakana nanüiki sulu'u tü pueulokat, o'unüshii naya nünainmüin Jesús süpüla nachuntüin nümüin süpüla nu'unüinjachin noulia sulu'ujee tü noumainkat. ");
INSERT INTO guc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","No'otookalaka Jesús nüchikua sünain o'unaa Capernaummüin eejeewa'ire nia. ");
INSERT INTO guc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Je cha'aya, süntakalaka wane wayuuirua nünainmüin sünain nalü'üjiraain wane wayuu ayuuishi süka süi shii'iree niiyajeein nia. Oukta asa'achi, oukta atünachi. Nütüjaapa Jesús saa'u nanoula na wayuukana, aashajaashi nia nümüin chi ayuuishikai: —Tawalachee, anakaja talatüle paa'in. Talatirüitpa paainjala puulia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Otta wane na karalouktamaajana yaakana sa'aka tü wayuukolüirua, müsü naa'in: “¿Jaraikai wayuu chi e'rüiyaaka aa'in wayumüin süpüleerua nünüiki nümüin Maleiwa?”. ");
INSERT INTO guc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Otta müshia Jesús, süka niyaawatüin saa'u tü sulu'ukat naa'in, asouktüshi nia namüin: —¿Jamüshii jia mojuka'a jünüiki tamüin sulu'u jaa'in? ");
INSERT INTO guc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Je wanaa sümaa tamüin nümüin, “Talatirüitpa paainjala puulia”, nnojoishi jütüjaain aa'u tayakai, chi Shipayakai Wayuu, sünain laülaain süpüla alatiraa saainjala wayuu. ");
INSERT INTO guc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Otta müsia joolu'u, jütüjaweechi aa'u taya sünain laülaain süka tameechin nümüin: “Püsha'walaa, waraittaiwa pia”. Aashajaashi joo Jesús nümüin chi oukta asa'achikai: —Püsha'walaa. Pülü'üjaa pu'ula. Pu'una pipialu'umüin —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Asha'walaashi joo chi wayuukai sünain nu'unüin nipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ponokalaka ma'i saa'in tü wayuukolüirua tü shi'rakat je na'waajüin Maleiwa saa'u laülaain Jesús nütüma süpüla eiyajaa wayuu. ");
INSERT INTO guc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Shiasa mapa süchikijee tia, sünain nu'unüin Jesús yalajee, eeshi nüpüla wane wayuu kanüliashi Mateo joyotüin eere ni'yataale. Okotchajüi neerü nümüin chi sülaülashikai mma. —Anashi tamaatalai pia —nümakalaka Jesús nümüin. Nüsha'walaakalaka joo Mateo sünain o'unaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Shiasa süchikijee tia, neenakakalaka Mateo wainma wayuu nipialu'umüin sünainmüin wane ekawaa nüpüla Jesús namaa na nikirajüinkana. Je na'aka na wayuu eküshiikana, eeshii wainma na kaainjaraliikana naashin na fariseokana, maa aka na okotchajüliikana neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Otta na wayuukana fariseokana ne'rapa tia, mojusü nanüiki namüin na nikirajüinkana Jesús sünain namüin namüin: —¿Jamüshi cheje eera nikaaka'a chi ekirajüikai jia namaa na eekana kaainjaraliin maa aka na okotchajüliikana neerü? —namakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Naapapa Jesús tü namakat na fariseokana namüin na nikirajüinkana, nüsouktakalaka ne'ipajee: —Wane wayuu eekai nnojolüin ayuulin, nnojotsü che'ojaain tottoolu sümüin. Shia che'ojaaka amüin eekai ayuulin. ");
INSERT INTO guc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sükajee tüü, antüshi taya sa'akamüin wayuu süpüla achajawaa süchiki eekai kaainjaralüin shii'iree sükatalaain suulia saainjala. Nnojoishi taya antüshin süpüla achajawaa süchiki eekai maainjalain saa'in namüin. Jülüja jaa'in tü nünüiki Maleiwa ashajünakat paala sümaiwa sulu'u tü nüchikimaajatkat Maleiwa sünain maa: “Tacheküin süpüleerua kamaneein jia sümüin wayuu. Nnojotsü tacheküin mürüt o'utünajatkat aa'in tamüin” —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nantakalaka na nikirajüinkana Juan nünainmüin Jesús sünain nasakirüin nia sünain namüin nümüin: —Aamüjapü'üshii waya wanaa sümaa aashajawaa nümaa Maleiwa, maa'aya aka na fariseokana. ¿Jamaka'a joo na pikirajüinkana nnojoliika'a naamajüin? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nüsouktakalaka Jesús ne'ipajee sünain nikirajüin naya süka sukuaippa tü kasa e'nnakat sainküin mma sünain nümüin namüin: —Tü wayuu antakat sünain shikiira wane ka'wayuusee, anasü talatüle saa'in sümaa nnojolüin mojuin saa'in wanaa sümaa eein chi ka'wayuuseshikai namaa. Akaajaa tayakai joolu'u, süka eein taya namaa na tekirajüinkana, anasü talatüle naa'in. Alu'ujasa mapa takatalaapa noulia, eeshii süpüla naamajüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aashajaashi Jesús joolu'u namüin nüchikua: “Nnojotsü anain müleka shi'yotoonüle wane shi'ipa kuluulu eekai jeketüin süpüla ekeittiajünaa süka wane ashe'in eekai laülaain. Amojujaajeerü süpüshua wanaa sümaa süshijaanüin süka süsüküijaweerüin. Akaajaa jiakana, nnojotsü anain masütaajule jia sünain tü jünoujakat paala wanaa sümaa jünoujain tü pütchi jeket tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Maa'aya aka wane wiino. Müleka süla'annüle wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai laülaain, eesü süpüla süchatajaain tü paa'atakat sütüma jashü'üpa. Amülouleerü tü wiinokot oo'ulaka tü paa'atakat. Shi'itaaneekalaka wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai jeketüin suulia amüloulin tü wiinokat oo'ulaka tü paa'atakat”. ");
INSERT INTO guc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wanaa sümaa naashajaain Jesús sümaa tü wayuukolüirua, nüntakalaka wane wayuu laülaashi sulu'u tü ekirajüleekat tü judíokolüirua sünain nüsapainyo'ukain nümülatu'umüin Jesús, sünain nümüin nümüin: —Kaalin taya püpüla, ouktüsü tü tachonkot. Tatüjaa aa'ulu müleka pu'unüle sünainmüin sümaa pi'itaainjatüin pajapü sünain, kateerü so'u süchikua —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nu'unakalaka Jesús je na nikirajüinkana nümaa chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Shiasa nükoyoloiwa'aya Jesús, süntakalaka nünainmüin nüchiiruajee wane jierü ayuuisü sünain shipettüin sot nüshe'in. Polooirü piammüin juya amülain isha sümüin waneepia. ");
INSERT INTO guc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Müleka tepettüle ne'e sot nüshe'in, aneerü taya”, mapü'üsü saa'in. ");
INSERT INTO guc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ajununajaashi Jesús sünain ni'rüin tü wayuukot. —Nii waa'iraa, anakaja talatüle paa'in. Anaitpa pia süka pünoujain tanain —nümakalaka Jesús sümüin. Anasü shia wanaa ma'i sümaa naashajaain Jesús sümaa. ");
INSERT INTO guc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Je süchikijee tia, ayatshia nia o'unüin nipialu'umüin chi laülaashikai. Shiasa nikerolapa, eesü nüpüla wainma wayuu sünain a'yalajaa oo'ulaka wane amaasijaalüirua. ");
INSERT INTO guc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Ju'una jümaala yaajee yaa. Tü jintutkot, nnojotsü ouktüin, atunküsü ne'e —nümakalaka namüin. Otta tü wayuukolüirua, asirajüsü nüka Jesús sütüma tü nümakat. ");
INSERT INTO guc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nujuittirapa anooipa'amüin tü wayuu wattakat saalin, ekerotshi Jesús eemüin tü jintutkot. Naapaakalaka joo sajapü. Süsha'walaakalaka sünain katüin so'u. ");
INSERT INTO guc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Su'walakajaakalaka joo sainküin mma süchiki tü naa'inrakat Jesús. ");
INSERT INTO guc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Shiasa nu'unapa Jesús sulu'ujee shipia tü jintutkot, eeshii piamashii wayuu mo'usalii sünain o'unaa nüchiiruajee sulu'u tü wopukot sünain na'waatüin nümüin: —Jesúsuu, Nülüinkai David, anashi müleka pümüliajüle waya. ");
INSERT INTO guc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Shiasa nikerolapa Jesús sulu'umüin wane miichi, arütkaashii na wayuu mo'usaliikana nünainmüin. Nüsakirakalaka Jesús naya: —¿Anoujashii jia sünain tountüin teiyajüin jia? —nümakalaka. —Aa shiimüin, Ekirajüikalee —nasouktakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ni'itaakalaka Jesús najapü saa'u tü no'ukot wane'ewa'ire nakua sünain nümüin namüin: —Anashii ko'ule jia joolu'u saa'u jünoujain tanain. ");
INSERT INTO guc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ko'u müshiija na wayuukana. Otta Jesús, nüchiajaakalaka naya sünain nümüin namüin: —Nnojo jüküjain jüchiki sümüin wayuu sünain jiiyajünüinapain tatüma —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Otta na wayuu mo'usaliikana paala, o'unüshii naya sünain na'walakajüin sainküin mma süchiki tü naa'inrüitpakat Jesús naka. ");
INSERT INTO guc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Shiasa no'unapa na wayuukana nüma'anajee Jesús, antinnüshi wane wayuu nünainmüin. Manüisai nia süka kale'eru'uin yolujaa. ");
INSERT INTO guc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kanüikalaka nia shiyu'nnapa nuulia nütüma Jesús. Otta tü wayuukolüirua eejatkat jutkatüin, awatüsü ma'i saa'in süka anaichipain nia shi'rüin: —Nnojotsü we'rüirüin kasa eekai müin aka tia yaa sulu'u tü mmakat Israel —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Otta nanüiki na fariseokana: —Chi kapülainkai atüma chira süpüla ayu'laa yolujaa, nia chi sülaülashikai tü yolujaakalüirua süpüshua —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Shiasa süchikijee tia, o'unüshi Jesús sulu'upünaa tü pueulokat süpüshua sünain niiyajüin wainma wayuu eekai ayuulin sütüma ayuulii eekai eein ne'e je sünain ekirajaa sulu'u tü ekirajüleekalüirua tü judíokot. Aküjüshi nia tü pütchi anasükat sümüin wayuu, süchiki nukuaippa Maleiwa sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Je ni'rapa Jesús tü wayuu wattakat saalin, nümüliajüin naya süka müliain saa'in atümaa otta walakatüin shia maa aka saa'in anneerü eekai marüleejuuin. ");
INSERT INTO guc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nümakalaka namüin na nikirajüinkana: —Wainma wayuu eekai saapeein tachiki tayakai chi O'tte'erüikai. Otta palitchon na yapakana süpüla o'unaa sünainmüin tü wayuukolüirua süpüla naküjainjatüin tachiki sümüin. ");
INSERT INTO guc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Je sükajee tia, juchunta jumaala nümüin chi Tashikai Maleiwa süpüla nuluwataainjanain na wayuu aküjüinjanakana tachiki namüin. ");
INSERT INTO guc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Neenakakalaka Jesús na polookana piammüin nikirajüinkana nünainmüin sünain nümüin namüin: “Taapüin laülawaa joolu'u jümüin süpüla ayu'laa yolujaa süle'eru'ujee wayuu je süpüla eiyajaa wayuu eekai ayuulin”, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni'itaakalaka joo nanülia na polooshiikana piammüin “Aluwataaushi” münüin, süka nuluwataainjanain naya sünain aküjaa nünüiki sümüin wayuu. Anuu nanülia na Aluwataaushikana: Simón, chi e'itaanakai anülia Pedroin nütüma Jesús. Andrés, chi nimüliakai Simón. Jacobo nümaa Juan nüchonnii Zebedeo. ");
INSERT INTO guc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, je Tomás. Mateo, chi okotchajüikai neerü nümüin chi sülaülashikai mma. Jacobo, chi nüchonkai Alfeo. Tadeo. ");
INSERT INTO guc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, wane no'utku na wayuukana kanüliakana Zelote. Je Judas Iscariote, chi aapüinjachikai nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nüjütakalaka Jesús na polookana piammüin sünain nuluwataain naya sünain nümüin namüin: “Nnojo ju'unüin sa'akamüin tü wayuukolüirua nnojotkat judíoin, tü ‘gentile’ münakat. Je nnojo ju'unüin sulu'umüin tü pueulokalüirua cha'aya sulu'u tü mmakat Samaria. ");
INSERT INTO guc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Alu'ujasa, ju'una sünainmüin tü wayuu Israelkalüirua sümüiwa, tü makat aka saa'in anneerü eekai amüloulin. ");
INSERT INTO guc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ju'una süpüla jüküjainjatüin namüin sünain maa namüin: ‘Alü'ütsü nükalia chi Maleiwakai süpüla aluwatawaa’, meena jia namüin. ");
INSERT INTO guc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jiiyaja wayuu eekai ayuulin. Jüso'ire'era saa'in wayuu eekai ouktüin. Jiiyaja wayuu eekai ayuulin sütüma aja'ttaa ata. Jiyu'la yolujaa süle'eru'ujee wayuu. Saa'u nnojolüin juwalaajüshin tamüin süpüla juuntüin jaa'inrüinjatüin tü anasükat, anakaja müleka nnojorule jüchuntüin awalaajünaa saa'u tü kasa anasü jaa'inrakat sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Je nnojo jülü'üjüin makat aka ooro, pülaata je ‘cobre’ sulu'u tü juwo'olüinkat. ");
INSERT INTO guc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nnojo jüchisein jükatto'uise je wunu'u jüshepü'üjia. Nnojo jülü'üjüin suwala'ata jüshe'in je suwala'ata jüsapaatse. Maa aka nuwalaajünüin wane a'yataai, akaajaa jiakana. Anakaja saapajünüle tü che'ojaakat jümüin sütüma tü wayuu jikirajakat. ");
INSERT INTO guc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Je jüntapa sulu'umüin wane pueulo, jikerola sulu'umüin sünain jüchajaain nüchiki wane wayuu eekai kamaneeinjachin jümüin süpüla ni'iyouinjanain jia. Je nnojoleerü jii'iratüin tü miichi jüntakat alu'u palajana. Waneeitpaleerü jüpülee süma'inru'u eein jia sulu'u tü pueulokot. ");
INSERT INTO guc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Je jikerolapa sulu'u tü miichikat, ‘Eeshi Maleiwa jümaa’, meena jia namüin na kepiakana sulu'u. ");
INSERT INTO guc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Je müleka kamaneere naya jümüin, anakaja jüchuntüle nümüin Maleiwa süpüla nii'iyatüinjatüin na'anasia namüin. Akaajasa müleka nnojorule kamaneein naya jümüin, nnojoleena jia achuntüin nümüin Maleiwa naa'u nala wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Je müleka nnojoliire kapülain aa'inyüü jia sulu'u wane pueulo je shiyouktünüle tü pütchi jüküjüinjatkat sümüin, ju'unamaata suulia sünain jo'otojooin tü mmakat sünainjee juu'ui jüma'ichiki shiyaawase jümüin: ‘Nnojotsü wasirüitpain eekai manoujüinyeein ale saa'in ne'e’. ");
INSERT INTO guc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Shiimüin tü tamakat jümüin: So'u tü ka'i kasalajaneetkat o'u sümüin saainjala wayuu nütüma Maleiwa, na ayouktakana jünüiki, mülialeweena ma'i naya suuliale'eya tü kaainjaratkalüirua sulujutkat paala tü pueulokat Sodoma oo'ulaka Gomorra. ");
INSERT INTO guc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Jülüja jaa'in tü tamüinjatkat jümüin joolu'u: Tajütüin jia maa aka saa'in anneetchen sa'aka unaalü, süka eein wainma na ta'ünüükana sa'aka tia wayuukolüirua. Ee jaa'in sünain tü wayuukolüirua, otta nnojo jütkaain namaa. ");
INSERT INTO guc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jalia jia noulia, süka nata'ülireenain jia süpüla naapaa ekii namüin na laülaayuukana je süka na'yaatireenain jia sulu'u tü ekirajüleekat naya. ");
INSERT INTO guc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Saaliijee jünoujain tanain, asha'wale'enneena jia namülatu'u na sülaülashiikana mma oo'ulaka namülatu'u na aluwataashiikana saa'u wayuu süpüla jüsouktüinjanain namüin saa'u tü jünoulakat. Je wanaa sümaa jüsha'wale'ennüin namülatu'u, jüküjainjatü tachiki namüin je sümüin tü wayuu gentilekalüirua. ");
INSERT INTO guc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Je so'uweena tü ka'i jüta'ünneenakat o'u natüma, nnojo jüshapataain aa'in saa'u tü jüsouktüinjatkat aka namüin. Aapüneerü jümüin so'u ma'i ka'ikat tia tü pütchi jümüinjatkat namüin. ");
INSERT INTO guc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Otta tü pütchi jüsouktüinjatkat aka, nnojoleerü jüle'eru'ujeejatüin, aapüneerü shia jümüin nütüma chi Naa'inkai chi Jüshikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Je sükuaippainjatkat wayuu so'u ka'ikat tia, aapüneerü ekii süpüla ouktaa natüma na suwalayuukana je nütüma chi süshikai. Eejeena wayuu eekai ne'nnüin amüin sütüma nachooin sümaa no'utinnüin aa'in natüma. ");
INSERT INTO guc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A'ürülaajeerü saa'in wayuu süpüshua jünain saaliijee jünoujain tanain. Otta jia, müleka jüchecherüle jaa'in su'unnaa tü müliaa ji'rakat, ayateena jia o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Müleka jashichire wayuu jümüin sulu'ujee wane pueulo, anakaja jujuittüle yalajee sünainmüin wane'eya. Shiimüin tü tamakat jümüin: Nnojoleerü jikeraajüin tü jaa'inrüinjatkat sulu'u tü pueulokalüirua süpüshua sulu'u tü mmakat Israel süpülapünaa tantüin tayakai chi Shipayakai Wayuu. ");
INSERT INTO guc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Maa aka eein wayuu eekai shi'rüin wayumüin tamüin tayakai chi Jüsenyotsekai, akaweenia jia tekirajüinkana atüma'aya. Maa aka eein wayuu eekai mojuin sünüiki tamüin, sünain Beelzebú tamünüin sütüma, alana'aleejeeria sünain mojuin nanüiki jümüin. Wane ekirajaashi, nnojoishi alanaain nuulia chi ekirajüikai, je wane achepchiee, nnojoishi alanaain nuulia chi kachepchiakai ");
INSERT INTO guc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nnojo mmolüin jia seema wayuu e'rütkat wayumüin jümüin. Müleka sunujunnule wane kasa, eweeteerü süchikua. Müsüya aka tü nüchikikat chi Maleiwakai. Ja'itairü nnojolüin aküjünüin paala sümüin wayuu sainküin mmakat süpüshua, aküjüneerü joolu'u sümüin. ");
INSERT INTO guc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sükajee tia, tü tekirajakat anain jia sujuuna wayuu, anakaja jikirajüle wayuu süpüshua sünain. ");
INSERT INTO guc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Je nnojo mmolüin jia seema wayuu eekai su'uteein jaa'in. Müleka ju'utünüle aa'in, tü aja'tteetkat, shia ne'e tü ji'irukukat. Nnojoleerü kasain saa'inrüin tü wayuukolüirua jüka süchikijee. Taküjeerü joo jümüin jaralin chi mmolüinjachin eema jia. Anakaja niale mmolüin eema jia Maleiwa, nia kapülainka nümüiwa süpüla nu'unirüin jia Hadesmüin eemüin süpülee tü ouktüsükalüirua. Anakaja niale mmoluukain eema. ");
INSERT INTO guc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nnojo motüin jaa'in sünain naa'inmajüin jia Maleiwa waneepia. Eesü süpüla süikkünüin piamasü wuchii saa'u wane neerü kachueerachen ne'e, ¿aashi müin? Otta tü wuchiikalüirua süpüshua, nnojotsü juunasüin nütüma chi Jüshikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Müshii aka jiakana sünain nnojoliin oo'ulaanüin jümüiwa nütüma, süka alana'aleein ma'i jujut nümüin suuliale'eya tü wuchiikalüirua süpüshua. Je sükajee jaa'inmajünüin nütüma Maleiwa, nnojo mmolüin jia seema wayuu e'rütkat wayumüin jümüin. ");
INSERT INTO guc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Müleka ‘Anoujashii waya nünain Jesús’, jümüle su'upala wayuu, ‘Shiimüin sünain nanoujain tanain’, meechi taya jüchiki nümüin chi Tashikai Maleiwa chakai iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Alu'usa müleka juunjulajüle tachiki su'upala wayuu, ‘Nnojoishii te'raajüin naya’, meechi taya jüchiki nümüin. ");
INSERT INTO guc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“¿Aluwataaushi taya, saa'in jümüin, süpüla achiajawaa wayuu atkaasü yaa mmalu'u? Nnojoishi süpülajachin taya tia. Süpülajachi mojujiraainjatüin wayuu tatüma saaliijee tü taa'inrakat je tü tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A'ülüjeechi wane wayuu nümüin chi nüshikai. A'ülüjeerü wane wayuu sümüin tü shiikat. A'ülüjeerü wane wayuu sümüin tü sa'ütkat. ");
INSERT INTO guc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sulu'u wane miichi, a'ülüjiraweena na apüshiikana maa aka natkaain wayuu eekai pa'ünüüwajiraain. ");
INSERT INTO guc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tamüshii paala jia: Nnojoleerü kasain jaamüin tamüin müleka aire jüpüla chi jüshikai je tü jiikat je tü jüchooinkalüirua suuliale'eya alin taya jüpüla. ");
INSERT INTO guc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chi wayuu eekai niyouktalaa nümüin taya ni'rapa müliaa sümaa mmoluu sheema o'utinnaa aa'in tanainjee, nnojoishi wanaain sümaa niainjachin wane tekirajüin. ");
INSERT INTO guc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chi eekai niyouktüin taya süka naa'inmajiraweein nukuaippa suulia ouktaa, amülouijeerü nukuaippa süpüshua. Otta chi wayuu eekai naapajiraain nukuaippa süpüla ni'yataainjachin tamüin, mayaashije o'utüneechin aa'in sünainjee tia, ayateechi o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Chi wayuu kapülakai aa'in jia, kapülashi naa'in tayaka'iya wanaa jümaa. Je saa'u kapülain naa'in taya, kapülashi naa'in chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chi wayuu kapülakai aa'in wane nünüikimaajachi Maleiwa sümaa kojutüin nia nütüma sünainjee tü naa'inrakat, wanaaweerü tü nümüinjatkat maa aka tü awalaajünakat nümüin chi nünüikimaajachikai. Je chi wayuu kapülakai aa'in wane wayuu eekai anain no'ulu'u Maleiwa sünainjee naa'inrüin tü anasükat, wanaaweerü tü nümüinjatkat maa aka tü awalaajünakat nümüin chi wayuu anamiakai. ");
INSERT INTO guc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Shiimüin tü tamakat jümüin: Chi eekai kamaneein nümüin wane wayuu anoujashi sünainjee niain wane tekirajüin maa aka jiakana, maa aka nüsülajüin ne'e wüin nüsüin, shiimüin sünain nuwalaajüneechin sükajee tia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Shiasa süchikijee nikirajüin Jesús na polookana piammüin nikirajüin, o'unüshi yalajee yala namaa süpüla aküjaa nüchiki Maleiwa sümaa ekirajaa wayuu sulu'upünaa tü pueulokalüirua cha'aya Galilea. ");
INSERT INTO guc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Otta müshia Juan chi owoutisaajüikai, wanaa sümaa püreesain nia, aapinnüshi süchiki süpüshua tü naa'inrakat Jesucristo. Nuluwataakalaka Juan na nikirajüinkana ");
INSERT INTO guc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","süpüla nasakirüinjachin Jesús sünain namüin nümüin: —¿Shiimü'inya piain chi aluwataaushikai nütüma Maleiwa süpüla pu'tte'erüinjachin wayuu? ¿Nnojottaapa shiimüin? ");
INSERT INTO guc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nüsouktakalaka Jesús namüin: —Ju'una jümata jüchikua jüküjaiwa nümüin Juan tü jaapakat achiki je tü ji'rakat. ");
INSERT INTO guc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tü wayuu eekai mo'uin, ko'usü. Tü eekai masa'ain, kasa'asü. Tü eekai saja'ttüin süta, ashatüsü tü sütakat. Tü eekai mache'ein, kache'esü. Tü eekai ouktüin, oso'iraasü saa'in. Je tü eekai müliain, aküjüna amüinrü tachiki tayakai chi O'tte'erüikai. ");
INSERT INTO guc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Anata'aleeshija'a ma'i chi wayuu eekai nnojolüin nuu'ulaain suulia anoujaa tanain sütümajee tü alatakat nümüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Shiasa'a no'unapa na nikirajüinkana Juan, o'ttüshi Jesús sünain aküjaa nüchiki Juan sümüin tü wattakat saalin wayuu: “Soto jaa'in wanaa sümaa nuwoutisaajüin Juan chaa isashiipa'a. ¿Kasa ju'unaka ee'iree nünainmüin? ¿Shii'iree ji'rüinjachin wane wayuu eekai nünouja'ayata nümüin eekai eein ne'e maa aka wane türiiya liyantajakat sütüma jouktai? Nnojo. ");
INSERT INTO guc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Süpüla ji'rüinjachin wane wayuu washirü eekai kashe'in kuluulu anasü? Nnojo. Na wayuu washinnuukana, na anakana ashe'in, kepiashii naya sulu'u nipia chi sülaülashikai mma, nnojoishii kepiain chaa eere maa'inyatuulin mma. ");
INSERT INTO guc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Shiimüin sünain ju'unüin chamüin süpüla ji'rüinjachin wane nünüikimaajachi Maleiwa. Je alana'aleeshia ma'i nia sünain kojutüin nütüma Maleiwa noulia na waneeinnua, süka niain chi aapirakai wayuu sünain tantajachin tayakai. ");
INSERT INTO guc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nia chi ashajünakai achiki paala sünain nümüin chi Maleiwakai nümüin chi Nüchonkai sünain maa: ‘Taluwataajeechi chi pünüliamaajachikai püpüleerua süpüla naapirüinjatüin tü wayuukolüirua sünain püntajachin sa'akamüin. Yapainjatü nütüma tü wayuukolüirua süpüla saapajüin pünüiki’, müsü tü ashajuushikat. ");
INSERT INTO guc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Shiimüin tü tamakat jümüin: Yaa sa'aka wayuu maa'ulu yaa, alana'aleeshia ma'i Juan sünain kojutüin nütüma Maleiwa suulia tü wayuukolüirua süpüshua. Otta na wayuu anoujashiikana tanain, mayaasüje nnojoliin kojutüin joolu'u sütüma wayuu, alana'aleejeeria tü nojutkat so'uweena wane ka'i suulia tü nujutkat Juan maa'ulu yaa. Shia süka laülaweenain naya cha'aya eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Sünainje'ere'eya tü ka'i niweetakat o'u Juan chi owoutisaajüikai sünainmüinre'eya maa'ulu, jashichishii na wayuu kama'üraliikana namüin na ekerolüinjanakana chamüin eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Je sümaiwa paala, nnojoliiwa'aya niweetüin Juan sünain aküjaa tachiki sümüin wayuu, ekirajuushi na jutuushikana natüma na nünüikimaajanakana Maleiwa oo'ulaka sütüma tü nüshajalakat Moisés. ");
INSERT INTO guc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Je joolu'u müleka kapürale jaa'in tanüiki, jütüjaajeechi aa'u Juan sünain niain chi Elías antajachikai sa'akamüin wayuu naashin chi nünüikimaajachikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Kasa maka aka naa'in na wayuu ka'akakana jia, na ayouktakana tanüiki? Nnojoishii naya talatüin tamaa, süka nnojolin taa'inrüin tü nachekakat. Müshii aka naya saa'in tepichi eekai namüin namüin na natünajutkana saaliijee nnojoliin nashaitteein namaa: ");
INSERT INTO guc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ja'itaina amaasijaayaain waya, nnojoliishii jia oyonnojoyaain sütüma. Je ja'itaina mojuyaain waa'in sünain ee'irajaa, nnojoliishii jia a'yalajayaain sütüma’, müshii na tepichikana. ");
INSERT INTO guc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Müshii aka naya saa'in tepichi, saa'u ‘Kale'eru'ushi nia yolujaa’, namüin nümüin Juan sünain nayouktüin nünüiki, süka nnojolin ni'rajaain mi'iraa je süka nnojolin nüsüin wanaa namaa. ");
INSERT INTO guc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Otta nanüiki tamüin tayakai, chi Shipayakai Wayuu, süka te'rajaain mi'iraa sümaa wayuu: ‘Wayuu kasa ale'echi nia, sütünajut tü okotchajütkalüirua neerü nümüin chi sülaülashikai mma, sütünajut tü kaainjaratkalüirua’, müshii naya tamüin sünain nayouktüin tanüiki. Shiimüin tü tamakat, müleka nnojorule taa'inrüin süpüshua tü nachekakat, nnojoleena naya talatüin tamaa. Otta chi wayuu eekai shiimüin sünain nünoujain nünain Maleiwa, nütüjaweerü aa'u sünain shiimüin tü taküjakat nümüin”, nümakalaka Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","O'ttüshi joolu'u Jesús sünain aküjaa süchiki tü wayuukolüirua kepiakat sulu'u tü pueulokalüirua eere naa'inrapü'üin wainmatua tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa sünain süsalainjanain naya nütüma nnojolüin nayaawajaain: ");
INSERT INTO guc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Jia kepiakana cha'aya sulu'u tü pueulokat Corazín oo'ulaka Betsaida, alu'uleeka ma'i jia amülouinjanaka saaliijee jiyouktüin tanüiki sünain ji'rüin ma'i taa'inrüin wainma kasa anasü nütüjakat apüleerua Maleiwa nümüiwa. Otta müleka shialeinkaje e'rüin tü wayuu gentilekalüirua sümaiwa paala sulujutkat tü pueulokalüirua Tiro oo'ulaka Sidón tü kasa anasü taa'inrakat joolu'u ju'upala, mojusüinkaje saa'in saalii saainjala sümaa suu'ulaain suulia. ");
INSERT INTO guc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tamüshii paala jia: So'u tü ka'i süsaleetkat o'u wayuu saainjala nütüma Maleiwa, mülialeweenia ma'i jia suuliale'eya tü kaainjaratkalüirua chajatkat Tiro je Sidón. ");
INSERT INTO guc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Jia kepiakana cha'aya sulu'u tü pueulokat Capernaum, ayouktakana tanüiki, süsaleena jiakanaya. Awalaajüneena jia nütüma Maleiwa jaajüin. Otta nnojoleena awalaajünüin jia. Shieerü eeka süsaleenain ma'i jia nütüma. Otta müleka shialeinkaje e'rüin tü wayuu gentilekalüirua sümaiwa paala sulujutkat tü pueulokat Sodoma tü kasa anasü taa'inrakat joolu'u ju'upala, nnojotsüje o'utünüin aa'in nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tamüshii paala jia: So'u tü ka'i kasalajaneetkat o'u sümüin saainjala wayuu nütüma Maleiwa, mülialeweena ma'i jia suuliale'eya tü kaainjaratkalüirua sulujutkat paala tü pueulokat Sodoma”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nümakalaka Jesús so'u ka'ikat tia: “Taataa, ta'waajüin pia, pia Aluwataashikai cha'aya iipünaa oo'ulaka ya'aya mmolu'u. Tü paa'inrüinjatkat, nnojotsü pii'iyatüin sümüin wayuu eekai kekiin saashin, pii'iyatüitpa namüin na wayuu kamaneekana pümüin. ");
INSERT INTO guc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Talatüitpa ma'i paa'in sütüma tia”, nümakalaka nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aashajaashi joo Jesús sümüin tü wayuukolüirua süpüshua: “Chi Tashikai Maleiwa, nüneeküin taya süpüla atüjawaa saa'u kasa süpüshua nütüma. Chi e'raajakai taya, nia ne'e chi Tashikai nümüiwa. Je chi e'raajakai chi Tashikai, taya ne'e oo'ulaka tü wayuukolüirua eekai tee'iyatüin nia sümüin. ");
INSERT INTO guc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maa aka mapüsain wane wayuu süchiki a'yatawaa, aka'aya jiakana sütüma süpümüin ma'i jaa'in tü nüshajakat Moisés. Anakaja müleka jüüjüüle jia tamüin taapaiwa jümüin eemerawaa. ");
INSERT INTO guc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Anakaja joonoole sümaa tanüiki süpüla jüshatüinjatüin tü shiimüin tekirajeekat anain jia. Süka jamüin, mapüleejeerü jümüin aluwataanaa tatüma, mapüleejeerü jümüin tü tachekakat jüpüleerua. Müleka jüüjüüle jia tamüin, taapeerü jümüin tü eemerawaakat süka anamiain ma'i taya”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","So'u tü ka'i neemeraakat o'u na judíokana, awaralijaashi Jesús namaa na nikirajüinkana sulu'u wane wopu pasanainpünaa sünain wane yüüja. Je na nikirajüinkana, süka ouktüin jamü naya, nasürüttapünaain wane a'ttiee kanüliakat “trigo” sünain nashalejüin shia. ");
INSERT INTO guc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Otta na fariseokana ne'rapa tia, süka müin aka saa'in wane a'yatawaa tü naa'inrakat na nikirajüinkana Jesús naashin, namakalaka nümüin Jesús: —Saashin tü nüshajakat Moisés, nnojotsü anain süpüla naa'inrüin na pikirajüinkana tia so'u tü ka'i weemeraakat o'u —namajaakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Asouktüshi Jesús joolu'u namüin na fariseokana saa'u nnojolüin kaainjalaain tü naa'inrakat na nikirajüinkana naajüin: —Soto jaa'in tü naa'inrakat David paala sümaiwa wanaa sümaa alin jamü nümüin je namüin na nütünajutkana. ");
INSERT INTO guc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ekerotshi nia sulu'umüin tü a'waajüleekat Maleiwa wanaa sümaa shi'itaanüin tü pan aapünajatkat nümüin Maleiwa. Tü pankat naashin Moisés, nnojotsü shika'ain sümüinjatüin wayuu eekai eein ne'e. Na sacerdote judíokana, naya eküinjanaka namüiwa. Otta David, naapaain tü pankat sümaa niküin, je naapüin süpüshi namüin na nütünajutumuyuukana. Je nnojoliishii süsalain naya tü naa'inrakat nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Soto jaa'in tü ashajünakat nütüma Moisés nachiki na sacerdote judíokana sünain nnojolüin mojuin nümüin Maleiwa na'yataain sulu'u tü a'waajüleekat Maleiwa so'u tü ka'i neemeraajatkat o'u. ");
INSERT INTO guc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tamüshii joolu'u jia: Chi antüichipakai ja'akamüin, alana'aleeshia ma'i sünain anain nia suulia tü a'waajüleekat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Soto jaa'in tü nünüiki Maleiwa ashajünakat paala sümaiwa sulu'u tü nüchikimaajatkat, makat: ‘Tacheküin süpüleerua kamaneein jia sümüin wayuu. Nnojotsü tacheküin mürüt o'utünajatkat aa'in tamüin’, müsü tü ashajuushikat. Müleka shiimüinre sünain jiyaawatüin saa'u tü nümakat Maleiwa, nnojoishiije jiyoujain na tekirajüinkana saaliijee tü naa'inrakat so'u tü ka'i eemeraanakat o'u. ");
INSERT INTO guc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Je joolu'u, soo'opünaa tü naa'inrakat na tekirajüinkana so'uka'i, nnojoliishii kaainjalain. Tayakai, chi Shipayakai Wayuu, taya laülaashika saa'u tü ka'i sheemeraakat o'u wayuu. Je sükajee tia, nnojoliishii kaainjalain na tekirajüinkana saaliijee tü naa'inrakat”, nümakalaka Jesús namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","O'unüshi Jesús namaa na nikirajüinkana yalajee yala sünain ekerolaa sulu'umüin tü ekirajüleekat na judíokana. ");
INSERT INTO guc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eejachikalaka nüpüla wane wayuu joso ajapüchi. Je na fariseokana, süka naapeein nikii Jesús, eekalaka ma'i naa'in nüpüla müleka niiyajüle so'u tü ka'i eemeraanakat o'u, shii'iree, “Kaainjarai nia süka ni'yataain so'u tü ka'i eemeraanakat o'u sünain niiyajüin wane wayuu”, namüinjanain sümüin wayuu. Nasakirayaakalaka joo Jesús: —¿Shiimüin sünain anain müleka weiyajüle wane wayuu so'u sükalia eemerawaa naashin Moisés? ");
INSERT INTO guc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nümakalaka joo Jesús namüin: —¿Jameerü müleka sujutuule wane ja'anneetse sulu'u wane ishi sükalio'u tü eemerawaakat? ¿Nnojoleerü jiyu'lamaatüin ja'itainje sükalio'uin eemerawaa? ");
INSERT INTO guc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Je wane wayuu, alana'aleesia ma'i sünain kojutüin watüma suuliale'eya wane anneerü, ¿aashi müin? Je sükajee tia, anasü müleka waa'inrüle kasa anasü sümüin wayuu ja'itasü sükalio'uin eemerawaa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Otta nümüin chi wayuu joso ajapüchikai, nümakalaka: —Puwasta tü pajapükat. Je sünain naa'inrüin tü aluwataanakat anain nia, anale'eitpa tü najapükat maa aka saa'in tü suwala'atakat. ");
INSERT INTO guc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Otta na fariseokana, najuinnajaakalaka sünain namajiraain: “¿Kasa waa'inrüinjatka süpüla wo'utirüinjatüin naa'in?”, müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Otta Jesús, süka nütüjaain saa'u tü jülüjakat naa'in na fariseokana, o'unüshi yalajee yala. Eesü wainma wayuu o'unakat nüchiirua je niiyajüin eekai ayuulin sa'aka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Otta nüchiajaain naya suulia na'walakajüin nüchiki. ");
INSERT INTO guc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Müsü nünüiki namüin na wayuukana süpüla keraainjatüin tü nünüikikat chi Maleiwakai nüchiki Cristo aküjünakat paala nütüma Isaías chi nünüikimaajachikai, tü makat: ");
INSERT INTO guc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anii chi aneekuushikai tatüma süpüla ni'yataainjachin tamüin. Nia aishika'a ma'i tapüla je talatüsü ma'i taa'in nümaa. Taapeechi chi Taa'inkai nümüin süpüla eeinjachin nia nümaa. Aküjeechi nia tachiki sümüin wayuu sainküin mmakat süpüshua sünain su'tte'ennüinjatüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nnojoleechi a'ülüjaajiraain, nnojoleechi a'waatüin, nnojoleechi woottüin sulu'upünaa tü pueulokalüirua. ");
INSERT INTO guc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Anamieechi nia waneepia sümüin wayuu eekai makaaliijuuin. Nnojoleechi e'rülin wayumüin sümüin eekai matsüin. Meechia nia waneepia, wane'ere'eya nuu'ulaain su'tte'ennapa wayuu nütüma. ");
INSERT INTO guc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nieechi sa'atapaka anainjee tü wayuukolüirua sainküin mmakat süpüshua o'tte'ennaa”. ");
INSERT INTO guc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","O'uninnüshi nünainmüin Jesús wane wayuu kale'eru'ushi yolujaa. Mo'usai je manüisai chi wayuukai sütüma tü yolujaakat. Otta nüntapa chi wayuukai nünainmüin Jesús, kanüikalaka nia, ko'ukalaka nia nütüma. ");
INSERT INTO guc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Otta tü wayuukolüirua eejatkat jutkatüin, awatüsü ma'i saa'in süka anaichipain nia shi'rüin. “¿Niataapa chi Nülüinkai David wa'atapakai?”, sümakalaka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Otta na fariseokana naapapa nüchiki chi wayuukai sünain niiyajünüin, aashajaajiraashii naya sünain maa: “Chi kapülainkai atüma chira süpüla ayu'laa yolujaa, nia ne'e Beelzebú, chi sülaülashikai tü yolujaakalüirua süpüshua”. ");
INSERT INTO guc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nütüjaapaja Jesús saa'u tü saashajaakat achiki naa'in na fariseokana, nümakalaka namüin: “Müleka sütkaajiraale wane wayuuirua, aja'lajaajiraweena naya. Je müleka sü'ülüjaale wane wayuu sümaa tü süpüshikat, pa'ünüüwaweerü. ");
INSERT INTO guc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Akaajaa Satanás, müleka nujuittirüleje tü yolujaakalüirua sünain nütkaain sümaa, oo'ulaajeechi nia suulia aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Jalaje'ewat saa'in jümüin tü napülainkat na jikirajüinkana süpüla ayu'laa yolujaa? ¿Nütüma Beelzebú? Nnojo, ¿aashi müin? Nayeenaja nayakana ayaawataka saa'u jalaje'ewalüin tü tapülainkat. ");
INSERT INTO guc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Saa'u tayu'lüin yolujaa sütüma nüpülain chi Naa'inkai Maleiwa, jütüjaaitpaja aa'u sünain nu'ttüin chi Maleiwakai sünain aluwatawaa wayuu yaa mmalu'u. ");
INSERT INTO guc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nnojotsü süpüla asaajaanüin nükorolo wane wayuu eekai katsüin. Alu'ujasa müleka nüntüle wane ka'ruwarai nünainmüin eekai katsüinreein ma'i nuulia, ayamülüneechi chi wayuukai nütüma, je alü'üjüneerü tü nükorolokot nüma'anajee. Akaajaa tayaka'iya. Süka niyamülüichipain tatüma chi sülaülashikai yolujaa, tountüin tayu'lüin yolujaa. ");
INSERT INTO guc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Soto jaa'in wane kasa: Chi wayuu ayouktajaakai tamaa, te'ipoloshi. ");
INSERT INTO guc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Shiimain ma'i tü tamakat jümüin: Atüjasü alatinnaa saainjala wayuu suulia nütüma Maleiwa. Ja'itasü mojuin sünüiki nümüin Maleiwa, atüjasü alatinnaa suulia nütüma. Alu'ujasa müleka niale chi Naa'inkai Maleiwa mojuin amüin sünüiki, matüjüinsat alatinnaa shia suulia. ");
INSERT INTO guc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja'itairü mojuin jünüiki tamüin tayakai, chi Shipayakai Wayuu, alatinneerü tia juulia nütüma Maleiwa. Akaajasa, müleka ji'rüliire wayumüin süka jünüiki nümüin chi Naa'inkai Maleiwa, müiria nnojolüin alatinnüin juulia, maa aka maa'ulu otta mapeena. ");
INSERT INTO guc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Müleka anale waneepia tü kasa taa'inrakat, ¿jamüsü ‘Kapülainshi nütüma chi Yolujaakai’ jümaka'a tamüin? Jülüja jaa'in sukuaippa wane wunu'u. Müleka shi'nnüle süchon wane wunu'u, atüjaaneerü aa'u kasain kachoin. Müleka kachonle eekai shikünaajuulin, atüjaaneerü aa'u sünain anain tü wunu'ukot. Otta müleka kachonle eekai mekünaajuuin, atüjaaneerü aa'u sünain mojuin tü wunu'ukot. ");
INSERT INTO guc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Jiakana wüi ouktasiro'ut, e'rülii wayumüin jia. Müshii aka jia saa'in tü wunu'u eekai mojuin. Saa'u kaainjaraliin jia, nnojotsü juuntüin jiweetirüin pütchi eekai analu'ulüin. Soto jaa'in wane kasa: Tü saashajaakat wane wayuu, shia tü ajuittakat sulu'ujee saa'in. ");
INSERT INTO guc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wane wayuu eekai nüküjüin waneepia kasa anasü, watüjaa aa'ut sünain shiain sulu'uin naa'in tü anasükat, süka waapüin shia nüküjüin. Akaajasa wane wayuu eekai nüküjüin waneepia tü kasa mojusükot, watüjaa aa'ut sünain shiain sulu'uin naa'in tü mojusükat. ");
INSERT INTO guc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tamüshii paala jia: So'uweena tü ka'ikat kasalajaneetkat o'u saainjala wayuu nütüma Maleiwa, asouktinneerü wayuu süpüshua saa'u tü pütchi mojulu'ut neweetitpü'ükat. ");
INSERT INTO guc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Müleka jiweetitpü'üle pütchi mojulu'ut, aapüneerü jikii nütüma Maleiwa so'uweena ka'ikat tia. Otta müleka jiweetitpü'üle pütchi anasü, ‘Maainjalasalii jia’ meechi Maleiwa jümüin”. ");
INSERT INTO guc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Otta no'utku na karalouktamaajanakana oo'ulaka no'utku na fariseokana, müshii naya nümüin Jesús: —Anashi paa'inrüle wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa, süpüla watüjaainjatüin paa'u sünain chaje'ewalin pia iipünaajee —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nüsouktakalaka Jesús namüin: —Jia wayuu eekana maa'ulu yaa, jia kaainjaralii e'rüliikana ma'i wayumüin nümüin Maleiwa, jüchuntüin tamüin taa'inrüin wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa süpüla jütüjaainjatüin taa'u sünain cheje'ewalin taya iipünaajee. Nnojoleena toonooin amaa jia. Shieerü taso'iraka anain jaa'in tü nüchikikat Jonás chi nünüikimaajachikai Maleiwa nümaiwa süpüla jütüjaainjatüin saa'u jaralin taya. ");
INSERT INTO guc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Maa aka Jonás sünain süle'eru'uin nia wane jime mülo'u apünüin ka'i je apünüin ai, akaweechia tayakai chi Shipayakai Wayuu sünain shiinalu'ujeechin taya tü mmakat apünüin ka'i je apünüin ai. ");
INSERT INTO guc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Je na wayuukana Níniveje'ewaliikana so'uweena nükalia chi Maleiwakai wanaa sümaa kasalajanainjatüin saainjala wayuu süpüshua nütüma, meena jümüin: ‘Wayakana, oonooshiinka sümaa tü nümakat Jonás wamüin sünain woo'ulaainjanain suulia waainjala. Otta müshia Jesús, alana'aleesia ma'i nujut nuulia Jonás. ¿Jamüshii jia nnojoliika'a joonooin sümaa nünüiki?’, meena naya jümüin. ");
INSERT INTO guc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Je soto jaa'in süchiki tü aluwataasükat paala sümaiwa sulu'u wane mma wattajatü chaa uuchimüin. Antüsü nünainmüin Salomón chi aluwataashikai sulu'u Israel wanaa sümaa tia, süpüla saapajüinjatüin nünüiki süka kekiin ma'i nia. Anuu tü tamakat jümüin: So'uweena nükalia chi Maleiwakai wanaa sümaa kasalajanainjatüin saainjala wayuu süpüshua nütüma, meerü jümüin tü wayuukot aluwataasükat: ‘Alana'aleesia ma'i nujut Jesús nuulia Salomón. ¿Jamüshii jia nnojoliika'a jaapajeein nünüiki?’, meerü shia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aashajaashi Jesús joolu'u namüin nüchikua, sünain nikirajüin naya soo'opünaa nüchiki chi nnojoikai ayouktajaain nümaa Satanás: “Wane yolujaa, süchikijee shiyu'nnüin nuulia wane wayuu, o'unüsü saainküin mmakat süpüla süchajaainjatüin süchiki eere maa'inyatuulin süpüla sheemeraain. Je müleka nnojorule süntüin sünain eeinjatüle sheemeraain, ");
INSERT INTO guc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Anasü tale'ejüle tachikua eejatüle paala taya tamaiwa’, meerü shia. Je süntapa süchikua nünainmüin chi wayuukai ayu'nnakai oulia paala, sünta anainchi nia sünain taashin süpüla süka ayatüin manoujain nünain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sükajee tia, süsaajale'einya joo akaratshisü yolujaairua soo'omüin, alana'aleekalia ma'i sünain mojulaain suulia. Ekerolaa müsia süpüshua nünain chi wayuukai. Müle'oleejeeria ma'i tü nümüliainkat suuliale'eya paala. Meena'a jia kaainjaraliikana mapeena”, nümakalaka Jesús namüin na karalouktamaajanakana oo'ulaka na fariseokana. ");
INSERT INTO guc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wanaa sümaa naashajaain Jesús sümüin tü wattakat saalin wayuu, eesü tü niikat oo'ulaka na nimüliayuukana sünain a'atapajaa yala anooipa'a süka naashajaweein nümaa. ");
INSERT INTO guc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naapinnakalaka Jesús: —Naa tü püikat anooipa'a oo'ulaka na puwalayuukana. Aashajaweeshii pümaa —nümünakalaka. ");
INSERT INTO guc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Asouktüshi Jesús: —Taküjeerü jümüin joolu'u jaralin tü teein oo'ulaka jaralin na tawalayuuin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Je nümakalaka sünain nii'iyatüin na nikirajüinkana: —Tü wayuu “teikat” je na wayuu “tawalayuukana” tamüinjanakana amüin, naya na eekai naa'inrüin waneepia tü nuluwataakat anain chi Tashikai Maleiwa chakai iipünaa maa aka naairua —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Je so'u ka'ikat tia, o'unüshi Jesús sulu'ujee tü miichi eejechire nia sünain ekirajaa. Nu'unakalaka sotpa'amüin tü palaakat eere joyotüin nia. ");
INSERT INTO guc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Shiasa süka wattain saalin tü wayuu okotchajaakalüirua nünainmüin, o'otooshi nia sulu'u wane anua. Nüikkalaakalaka süpüla ekirajaa yala sulu'u shirokujee tü palaakat. Otta tü wayuukolüirua, sha'washawatsü yaa sotpa'a. ");
INSERT INTO guc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ekirajüshi joolu'u nia sünain kasa wainma süka sukuaippa tü kasa e'nnaajünakat sainküin mma sünain nümüin namüin na wayuukana: “Eetaashi wane wayuu apünajüi. O'unüshi sulu'umüin tü niyüüjasekat sünain nijinain tü nuwaüyekat. ");
INSERT INTO guc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Eesü waüyee ejituukat sulu'u wopu eere shiküin shia wuchii. ");
INSERT INTO guc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eesü ejituukat sa'aka ipashira eere arülain mma. Osota müsia shia mayaainje arülain tü mmakat. ");
INSERT INTO guc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Shiasa susotapa, julumaatüsü sütüma tü ka'ikat süka arülain tü mmakat süpüla tü suurulakat. ");
INSERT INTO guc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eesü ejituukat sa'aka mojuui keimsesü. Shiasa süsotapa, ouktüsü tü pünajütkat sütüma tü mojuuikat. ");
INSERT INTO guc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Alu'usa wane waüyeekat, ejituushi saa'u mma anasü. Asotüsü, emiyo'ulaasü sünain wattain saalin süchooin. Eesü eekai sujuittirüin poloo shikii süchon sünainjee waneesia so'u, eesü eekai sujuittirüin aippirua shikii süchon sünainjee wane'eya, je eesü eekai sujuittirüin apünüin shikii süchon sünainjee wane'eya”, müshi joo Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Je kettaapa nünüiki Jesús, “Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Arütkaashii na nikirajüinkana Jesús nünainmüin sünain namüin nümüin: “¿Jamüsü pikirajaka'a tü wayuukolüirua süka sukuaippa tü kasa e'nnaajünakat sainküin mma?”, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nüsouktakalaka Jesús namüin: “Nnojotsü atüjaanüin aa'u paala süchiki nukuaippa Maleiwa sünain aluwatawaa. Otta müshia joolu'u, o'ttüichipa nia sünain nii'iyatüin shia jümüin jiakana tekirajüinkana. Otta na wane wayuukanairua, nnojotsü nii'iyatüin shia namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chi wayuu eekai jülüjain naa'in tü shiimainkat ekirajünakat anain nia, ekirajüneechi nia soo'omüin süpüla niyaawatüin saa'u. Akaajasa chi eekai nnojolüin kasajatüin nümüin tü shiimainkat, asütüneerü nuulia tü ekirajünakat anain nia paala. ");
INSERT INTO guc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tekirajüin tü wayuukolüirua waneepia süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ‘Süka jamüin, neirakaain sümüin tü kasa anasü taa'inrakat, otta nnojoliishii ne'raajüin taya. Je naapüin tü kasa anasü taküjakat achiki, otta nnojotsü nayaawateein aa'u tü tekirajeekat anain naya’. ");
INSERT INTO guc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Manoulakat tü wayuukolüirua, süpülajatü shikeraajüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma Isaías chi nünüikimaajachikai sünain maa: ‘Ja'itatataairü ma'i jaapüin otta ji'rüin, nnojottataaleerü jiyaawatüin aa'u. ");
INSERT INTO guc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tü wayuukalüirua, süsülajaain süche'eirua otta so'uirua toulia. Süchechajaain saa'inrua suulia nayaawatüin saa'u tü shiimainkat. Nnojoishii naya anoujeein tanain. Müleka nanoujüleje, anasüje tatüma nakuaippa tamaa’, müsü nünüiki Maleiwa”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ayatshi Jesús sünain nümüin namüin: “Anata'aleeshiija'a ma'i jia süka ji'rüin je süka jaapüin tü tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tamüsü paala jümüin tü shiimainkat: Wainma na nünüikimaajanakana Maleiwa je na wayuu anakana no'ulu'u Maleiwa paala sümaiwa eekai ne'reein ma'i tü kasa ji'rakat, eekai naapeein ma'i tü kasa jaapakat joolu'u, nnojotsü ne'rüin je nnojotsü naapüin. ");
INSERT INTO guc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Jaapa jumaala tanüiki jütüjaaiwa saa'u tü shikirajakat anain tü nüchikikat chi apünajüikai taküjaitpakat sümüin tü wayuukolüirua sünain ekirajaa süka sukuaippa tü kasa e'nnaajünakat sainküin mma: ");
INSERT INTO guc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tü waüyee ejituukat eepünaale süliikatünüin aa'u sütüma wayuu, shia nakuaippa na wayuu eekai naapüin ne'e süchiki nukuaippa Maleiwa sünain aluwatawaa sümaa nnojolüin nayaawatüin saa'u. Asütünamaatüsü tü pütchikat noulia nütüma Satanás suulia nanouja'alüin sünain. ");
INSERT INTO guc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Je tü ejituukat eere arülain mma saa'u ipa, shia nakuaippa wayuu eekai naapüin sümaa talataa aa'in nünüiki Maleiwa aküjünakat namüin. Müshii aka naya saa'in tü pünajüt ajulujaakat. Anoujashii naya motso'o ne'e. Otta ne'rapa müliaa sünainjee tü nanoulakat, oo'ulaa müshiija suulia anoujaa. ");
INSERT INTO guc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Je tü ejituukat sa'aka mojuui eekai keimsein, shia nakuaippa wayuu eekai naapüin nünüiki Maleiwa. Akatsa malaüle'erüin naa'in naya sünain anoujaa sükajee kachiiruain ma'i naa'in shii'iree washirüü, tü nnojotkat kalu'uin talataa. ");
INSERT INTO guc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Otta tü waüyee ejituukat saa'u mma anasü, shia nakuaippa na wayuu aapakana nünüiki Maleiwa sümaa noonooin sümaa. Koo'omüinsü ma'i namüin na wayuukana aa'inraa kasa anasü, maa aka tü pünajütkat saa'ukat mma anasü, maa aka eekai sujuittirüin poloo shikii süchon sünainjee waneesia so'u, eekai sujuittirüin aippirua shikii süchon sünainjee wane'eya, je eekai sujuittirüin apünüin shikii süchon sünainjee wane'eya”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ekirajüshi joolu'u Jesús nüchikua süka sukuaippa tü kasa e'nnaajünakat sainküin mma sünain nümüin sümüin tü wattakat saalin wayuu: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa wane yüüja eere nüpünajüin wane wayuu waüyee anasü kanüliasü ‘trigo’. ");
INSERT INTO guc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Shiasa aipa'apa wanaa sümaa natunküin na wayuukana, süntakalaka wane na'ünüü sulu'umüin tü yüüjakat sünain shijinain sa'aka tü trigokat wane sü'ü mojuui keimsesü. ");
INSERT INTO guc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mayaainje wanaawain ma'i jo'uuiwa'aya tü mojuuikat sümaa tü trigokat, süsotapa tü trigokat sümaa kachoin, atüjaana aa'ulu sünain eein tü mojuuikat sa'aka. ");
INSERT INTO guc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Nantakalaka na nüchepchiakana chi ka'ttiashikai sünain namüin nümüin: ‘Walaamainkalee, ¿aashi apünajayaain pia “trigo” sulu'u tü pa'apainsekat? ¿Jamakalaka shiweetaka'a joolu'u mojuui keimsesü yaa sulu'u?’, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Saainjala saa'in tamüin tü ta'ünüükalüirua’, nümakalaka namüin. ‘¿Pücheküin süpüleerua wayuunaain shia?’, müshii na nüchepchiakana. ");
INSERT INTO guc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Nnojo. Müleka jiyuunaale shia, eesü süpüla shiyuunaain tü trigokalia. ");
INSERT INTO guc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Shia anaka alu'u müleka juu'ulaale süpüla süntapa sükalia tü trigokat süpüla shi'yonoojünüin. Je so'uweena ka'ikat tia, taluwataweena na a'yataaliikana süpüla nejinnajüin palajana tü mojuui keimsesükat süpüla na'ajaa. Otta süchikijee, nakotchajeerü tü trigokat sümaa ne'itaainjatüin shia sulu'u tü anaajaaleekat ta'ttia’, müshi nia namüin”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ekirajüshi joolu'u Jesús nüchikua süka sukuaippa tü kasa e'nnaajünakat sainküin mma sünain nümüin sümüin tü wattakat saalin wayuu: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa sü'ü tü ‘mostaza’ münakat. ");
INSERT INTO guc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mayaainje jo'uuchechoin ma'i shia wanaa sümaa süpünajünüin, osotüsü sütüma wane suu'ulia miyo'u. Müsia nukuaippa Maleiwa sünain aluwatawaa. Mayaainje palitchoin wayuu anoujasü joolu'u, wainmeerü so'uweena wane ka'i”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ekirajataalashi joo nia süka wane'eya: “¿Jamüsü, saa'in jümüin, nukuaippa Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa tü oolojiakat pan ejitünakat sütüma wane wayuu sa'aka jaliina. Mayaainje wainmain tü jaliinakat, oolojoosü süpüshua sütüma tü ejitünakat sa'aka. Müsia nukuaippa Maleiwa sünain aluwatawaa. Mayaainje palitchoin wayuu anoujasü joolu'u, wainmeerü so'uweena wane ka'i”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ekirajüshi joolu'u Jesús tü wattakat saalin wayuu waneepia süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma wane nünüikimaajachikai sünain maa: “Shiasa süchikijee nükumajüin Maleiwa tü mmakat sümaiwa paala, eesü kasa eekai nnojoliyülüin nüküjüin achiki sümüin wayuu. Shia tekirajeetka achiki maa'ulu yaa süka sukuaippa tü kasa e'nnaajünakat sainküin mma”. ");
INSERT INTO guc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","O'unüshi joolu'u Jesús yalajee yala sa'akajee tü wattakat saalin wayuu sünain nikerolüin nüchikua sulu'umüin tü miichikat eejachire paala nikirajüin. Arütkaashii na nikirajüinkana nünainmüin sünain namüin nümüin: —Pikirajüinapa waya sünain wane kasa süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ¿Jamalu'ut tü püküjakat wamüin süchiki tü mojuui sa'akakat tü trigokat? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nüsouktakalaka Jesús namüin: —Chi apünajakai tü so'ukat trigo, taya tayakai chi Shipayakai Wayuu. ");
INSERT INTO guc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Je tü yüüjakat, shia tü wayuukolüirua süpüshua sainküin mmakat süpüshua. Je tü so'ukot “trigo”, shia tü wayuukolüirua aluwataaushikat nütüma Maleiwa. Je tü sü'ükat mojuui keimsesü, shia tü wayuukolüirua aluwataaushikat nütüma chi nü'ünüükai Maleiwa, chi Yolujaakai. ");
INSERT INTO guc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chi ejinakai sü'ü mojuui sa'aka tü trigokat, nia chi Yolujaakai. Je tü sükaliakat “trigo” süpüla shi'yonoojünüin, shia tü ka'i saja'lajaweetkat o'u kasa süpüshua. Je na wayuu a'yataakana sünain akotchajaa tü trigokat, naya na aapiee nüma'anajeejanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Je maa aka shiyuunnüin tü mojuuikat süpüla a'ajünaa, akaweeria tü wayuukolüirua aluwataaushikat nütüma chi Yolujaakai so'u tü ka'i saja'tteetkat o'u kasa süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tayakai, chi Shipayakai Wayuu, tajüteena na aapiee tama'anajeejanakana süpüla nayu'lüin na kaainjaraliikana oo'ulaka na kaainjalapü'ükana atüma wayuu sa'akajee tü wayuukolüirua aluwataaushikat nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ajutüneena naya natüma na aapieekana sa'akamüin tü sikikat, tü kanüliakat Hades süpüleekat tü ouktüsükalüirua, eere na'yalajeenain ma'i sütüma tü müliaa ne'reetkat. ");
INSERT INTO guc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Otta tü wayuukolüirua aluwataaushikat nütüma Maleiwa, saa'u lotüin ma'i nakuaippa nu'upala, eejeena naya nümaa chi Nashikai Maleiwa sünain kojutüin ma'i naya nütüma chaa eere nuluwataain. Otta joolu'u, chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in wane korolo kojutüsü ojoitünakat paala sulu'u wane jula'a sulu'u wane yüüja. Nüntakalaka wane wayuu sünain tü korolokot. Nojoitakalaka shia süchikua sünain nu'unüin sümaa talatüin ma'i naa'in. Nüikkakalaka süpüshua tü kasa eejatkat nüma'ana nipialu'u süpüla niyalajüin tü yüüjakat eere tü korolo nüntakat anain. ");
INSERT INTO guc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Tü nuluwataayakat Maleiwa, müshi aka naa'in wane wayuu achajaakai süchiki kaa'ürülairua eekai anasüin. ");
INSERT INTO guc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Je nüntakalaka sünain tü kaa'ürüla anasükat ma'i sünain kojutüin ma'i shia, nüikkakalaka süpüshua tü kasa eejatkat nüma'ana nipialu'u süpüla niyalajüin shia. ");
INSERT INTO guc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa wane kusu ajutünakat shiroku tü palaakat, kasitkat jime eekai shikaajünüin oo'ulaka eekai mekaajuuin. ");
INSERT INTO guc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Je wotopa tü kusukot, najaraittüin na olojüshiikana jime sotpa'amüin tü palaakat süpüla nakatajüin tü jime ekaajuushikat suulia tü mekaajuusatkat süpüla ne'itaainjatüin tü ekaajuushikat sulu'u wane katto'ui. Oo'ulaka tü mekaajuusatkat, ojotünüsü ne'e natüma. ");
INSERT INTO guc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Akaweeria tü wayuukolüirua so'u tü ka'i saja'ttajatkat o'u kasakat süpüshua. Anteena na aapiee nüma'anajeejanakana Maleiwa sünain nakatajüin wayuu eekai kaainjaralüin suulia tü wayuu eekai lotüin sukuaippa nu'upala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Je na kaainjaraliikana, ajutüneena natüma na aapieekana sa'akamüin tü sikikat, tü kanüliakat Hades, süpüleekat tü ouktüsükalüirua, eere na'yalajeenain ma'i sütüma tü müliaa ne'reetkat”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nüsakirakalaka Jesús naya: —¿Jiyaawata aa'u süpüshua tü taküjaitpakat jümüin? —Aa —namakalaka na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nümakalaka Jesús: —Saa'u jiyaawatüin shia, tamüshii paala jia: Chi eekai nikirajüin sünain tü ashajünakat sulu'u tü nüchikimaajatkat Maleiwa, müleka niyaawatüle saa'u tü nuluwataayakat Maleiwa, müshi aka naa'in chi wayuu washirü ayu'tkai korolo kojutshaatasü eekai sünaajuushin sulu'u wane juraskeerü, kasa eekai jeketüin je kasa eekai laülaain. ");
INSERT INTO guc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Shiasa Jesús süchikijee ekirajaa süka sukuaippa tü kasa e'nnaajünakat sainküin mma, o'unüshi yalajee yala. ");
INSERT INTO guc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Je nüntapa sulu'umüin tü pueulo eejachire nia tepichiiwa'aya, o'ttüshi nia sünain ekirajaa sulu'u tü ekirajüleekat. —¿Jarai cheje kekiika atüma chii? ¿Jarai cheje pülashika atüma süpüla aa'inraa tü nütüjakat apüleerua Maleiwa nümüiwa? —müsü tü wayuukolüirua süka ponüin ma'i saa'in tü nümakat Jesús. Otta waneeirua, asakiijirawa'ain müshii: ");
INSERT INTO guc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—Watüjaa aa'uchi nia sünain niain wane nüchon chi a'yataaikai sümaa taapüla. Je we'raajüin María tü niikat oo'ulaka Jacobo, José, Simón je Judas na nimüliayuukana. ");
INSERT INTO guc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Otta na nüshunuukana, kepiashii yaaya sulu'u tü pueulokat wanaa wamaa. ¿Jarai cheje eera laülaaka atüma nia süpüla aa'inraa tü naa'inrakat? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Müshi Jesús joolu'u süka nnojolichipain kasajachin nia namüin: —Müinka nüntüle wane nünüikimaajachi Maleiwa nuumainpa'amüin, mojuteechi nia sütüma tü wayuukolüirua je sütüma tü nüpüshikalüirua, maa aka tayakai sünain mojutüichipain jütüma joolu'u —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Je süka nnojolüin nanoujain nünain, nnojoishi aa'inrüin cha'aya wainmatua tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Otta müshia Herodes, chi sülaülashikai mma, naapa achikichi Jesús sümaa süpüshua tü kasa naa'inrakat sainküin mmakat. ");
INSERT INTO guc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nümakalaka Herodes namüin na a'yataaliikana nümüin: “Chi Jesúskai anülia, nia ne'e naa'in tamüin Juan chi owoutisaajüikai, oso'iraasü eera naa'in süchikijee ouktaa. Müshijese pülashin nia süpüla aa'inraa tü nütüjakat apüleerua Maleiwa nümüiwa”, nümakalaka Herodes. ");
INSERT INTO guc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Je nüchiki Juan sünain nu'utinnüin aa'in paala, müsü mayaa: Herodías tü nu'wayuusekat Herodes, nu'wayuusesü paala Felipe chi nimüliakai Herodes. Otta müshia Juan, mapü'üshi nümüin Herodes: “Nnojotsü anain no'ulu'u Maleiwa sünain pu'wayuusein tü jierü nu'wayuusekat paala chi pimüliakai”. Je sükajee tia, ata'ülinnüshi Juan nütüma sümaa nüpüreesajüin nia. ");
INSERT INTO guc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Otta müshia Herodes, o'utünee aa'inchi ma'i Juan nütüma. Akaisa mmolüin nia sheema tü wayuu judíokolüirua, süka nünüikimaajachin Maleiwa Juan saajüin. ");
INSERT INTO guc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Otta so'u wane mi'iraa nütüma Herodes saa'u nikeraajüin juya, oyonnajüsü tü süchonkot Herodías su'upala tü wayuu antakat sünainmüin tü mi'iraakat. Süka talatüin ma'i naa'in Herodes sümaa tü süchonkot Herodías, ");
INSERT INTO guc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","müshi nia sümüin su'upala tü wayuukolüirua: “Tamüsü paala pümüin joolu'u su'upala tü kasa chakat iipünaa: Taapeerü pümüin tü kasa püchunteekat tamüin”, nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Je saa'u shi'ikünüin aa'in sütüma tü shiikat soo'opünaa tü kasa süchuntajatkat, sümakalaka nümüin: —Püntira tamüin yaamüin sulu'u wane pülaata tü nikiikat Juan chi owoutisaajüikai —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Mojukalaka ma'i naa'in Herodes sütüma tü süchuntakat. Shiasa saa'u pansaaitpain nünüiki sümüin su'upala tü wayuukolüirua, nümakalaka namüin na nüsurulaatsekana: —Ju'una nünainmüin Juan chi püreesashikai jüshottoiwa nünutpünaa. ");
INSERT INTO guc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nantitkalaka tü nikiikat chi müliashiikai sulu'u wane pülaata sünain naapüin shia sümüin tü süchonkot Herodías. Shi'ikajaakalaka shia sümüin tü shiikat. ");
INSERT INTO guc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Otta müshi'iya na nikirajüinkana Juan natüjaapa saa'u sünain ouktüin nia, antüshii naya sünain naapaain chi müliashii süpüla ne'iküin amouyuupa'amüin. Süchikijee tia, o'unüshii naya nünainmüin Jesús süpüla aküjaa nüchiki nümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naapapa Jesús nüchiki Juan sünain nu'utinnüin aa'in, o'otooshi nia namaa na nikirajüinkana sulu'u wane anua sünain no'unüin sujuuna tü wayuukolüirua chamüin eemüinre yüütüülin mmakat. Otta tü wattakat saalin wayuu sütüjaapa naa'u Jesús, o'unüsü nüchiirua süka suu'ui sulu'ujee tü pueulokalüirua. ");
INSERT INTO guc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nüntaiwa'aya Jesús, ni'rüin tü wattakat saalin wayuu. Nümüliajakalaka naya sünain niiyajüin eekai ayuulin. ");
INSERT INTO guc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Shiasa motsopa ka'ikat, narütkaakalaka na nikirajüinkana nünainmüin sünain namüin nümüin: —Ekirajüikalee, yüü'üyütüüisü ma'i tü mmakat yaaya, je alü'ütsü süpüla shipiyu'ujaain. Anasü müleka püjütüleirua su'unaiwa sulu'umüin tü pueulokalüirua nayalajaaiwa tü neküinjatkat —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nüsouktakalaka Jesús namüin: —Anashii makatüle naya yaaya. Jaapa jiakana neküin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Namakalaka nümüin: —Ja'raisü pan je piamasü ne'e jime asijuushi eekat wama'ana. ");
INSERT INTO guc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Iche'era tamüin. ");
INSERT INTO guc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anakaja müleka süikkalaale tü wayuukolüirua saa'u tü alamakat —nümakalaka Jesús namüin na nikirajüinkana. Naapaakalaka joo Jesús tü ja'raisükat pan je tü piamasükat jime. Niirakaakalaka iipünaamüin sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshanaajakalaka joo shia süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eküshii napüshuale'eya je emirashii sünainjee. Je süchikijee, okotchajünüsü tü napütaalakat natüma na nikirajüinkana, maa aka poloo piammüin katto'ui. ");
INSERT INTO guc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eejana maa aka 5.000 tooloyuu sa'aka tü wayuukolüirua süpüshua sünain mayaawajuin na jieyuu oo'ulaka na tepichi eejanakana. ");
INSERT INTO guc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Shiasa mapa süchikijee tia, nüjütüin Jesús na nikirajüinkana süpüla no'unüinjanain nüpüleerua. No'otookalaka sulu'u tü anuakat sünain no'unüin namüiwa nüpüleerua waneemüin sa'ata tü palaakat süma'inru'u nüpütaain Jesús süpüla tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Shiasa süchikijee nüpütaain süpüla, o'unüshi Jesús nümüiwa saa'umüin wane namüna süpüla aashajawaa nümaa Maleiwa. Je motsapa ka'i, eeshi nia nümüiwa saa'u tü namünakat. ");
INSERT INTO guc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Otta müsia tü anua kalu'ukot na nikirajüinkana, wattasü shia suulia tü mmakat. Je yala pasanain sünain tü palaakat, napanapajakalaka joo wane jouktai. Katsüinsü ma'i joo tü palaakat sütüma. ");
INSERT INTO guc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Shiasa maa aka eeiwa'aya aikat, o'unüshi Jesús nanainmüin na nikirajüinkana sünain waraittüin nia soo'opünaa tü palaakat. ");
INSERT INTO guc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Shiasa ne'rapa Jesús sünain waraittüin nia soo'opünaa tü palaakat, —Epeinjaasü kasa wapüla ne'e —namakalaka sünain na'waatüin sümaa mmoluu sheema tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nüsouktamaatakalaka Jesús namüin: —Nnojo mmolüin jia, jüchechera jaa'in. Taya tayakalin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nümakalaka Pedro nümüin: —Senyotkalee, müleka shiimainreje piain we'rüin, anakaja peenaküle taya süpüla tantajachin pünainmüin soo'opünaa tü palaakat. ");
INSERT INTO guc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Anakaja, jalaichi pümaala —nümakalaka Jesús nümüin. Nüshakatakalaka joo Pedro sulu'ujee tü anuakat sünain waraittüin soo'opünaa tü palaakat nünainmüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Otta mmotkalaka Pedro sotopa naa'in tü wawaikat. Nu'ttakalaka sünain nimerolo nimerolo nümüin shirokumüin tü palaakat. —Jalia taya Senyotkalee —nümakalaka nümüin Jesús sünain nu'waatüin. ");
INSERT INTO guc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Otta Jesús, niyurulamaatüin nütüna sünain naapaain Pedro. —Pia matsüinkai anoula, ¿jamüsü nnojotka'a püchecherüin paa'in sünain anoujaa tanain? —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Je no'otoopa sulu'umüin tü anuakat, ejimalaa müsia tü jouktaikat. ");
INSERT INTO guc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Otta na nikirajüinkana yaakana sulu'u tü anuakat, na'waajüin Jesús sünain namüin nümüin: —Shiimüinja sünain piain chi Nüchonkai Maleiwa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Je nantapa waneemüin sa'ata tü palaakat, antüshii naya sulu'umüin wane mma kanüliasü Genesaret. ");
INSERT INTO guc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Je niyaawatünapa Jesús sütüma tü wayuuirua kepiakat cha'aya, su'walakajaakalaka nüchiki sainküin süpüshua tü mma pejekat sünain Genesaret. Süntinnakalaka wayuu eekai ayuulin nünainmüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nachuntakalaka na wayuukana nümüin Jesús shii'iree shiain nepettüin ne'e na ayuuishiikana sot nüshe'in. Anakalaka nütüma napüshua'aya na eekai nepettüin nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Antüshii no'uluku na fariseokana oo'ulaka na karalouktamaajanakana chajee Jerusalénjee eemüin Jesús sünain namüin nümüin: ");
INSERT INTO guc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Jamüshii na pikirajüinkana moonooinka'a sümaa tü ekirajünapü'ükat anain waya judíokana natüma na watuushinuukana? Nnojoliikalaka no'lojüin najapü wanaa wamaa süpüla ekaa süpüla wuleinjatüin wakuaippa no'ulu'u Maleiwa —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nüsouktakalaka Jesús namüin: —¿Jamakalaka shiaka'a ne'e jaa'inrüin tü nekirajapü'ükat anain jia na jutuushikana, sümaa moonooin jia sümaa tü nuluwataakat anain Maleiwa? ");
INSERT INTO guc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Soto jaa'in sünain juluwataanüin nütüma Maleiwa sünain kojutüinjachin jütüma jüshi oo'ulaka jii, je chi eekai e'rülin wayumüin nümüin nüshi oo'ulaka sümüin nii, o'utinnajachi aa'in nia. Shia nuluwataakat anain Maleiwa tüü. ");
INSERT INTO guc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Otta saashin tü nekirajapü'ükat anain na jutuushikana, eeshii süpüla namüin na wayuukana namüin na kachooinkana naya: ‘Nnojoleena jia tasülajüin amüin joolu'u süka taapüitpain süpüshua nümüin Maleiwa’. Je sükajee tia, ju'wanajaaitpa tü nuluwataakat anain Maleiwa sütümajee ju'unüin süchiirua tü nekirajapü'ükat anain na jutuushikana. ");
INSERT INTO guc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jia alaayuukana, lotüsü ma'i nünüiki Isaías jüchiki, chi nünüikimaajachikai Maleiwa, sünain nümüin mayaa: ");
INSERT INTO guc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kojutuyaashi taya natüma na wayuukana süka nanüiki ne'e, nnojoittaapa'a kojutüin taya natüma süka süpüshua naa'in. ");
INSERT INTO guc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tü namapü'ükat sünain na'waajüin taya naashin, nnojotsü kasain saamüin tamüin. Je nekirajüin wayuu sünain pütchi nale'eru'ujeejatü ne'e, nnojotsü nekirajüin anain tü taluwataakat anain’, müsü nünüiki Maleiwa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nuuneküin Jesús nachikua na wattakana naalin wayuu nünainmüin sünain nümüin namüin: —Jaapa jumaala tanüiki jüpüshua jiyaawataiwa saa'u tü tekirajeekat anain jia. ");
INSERT INTO guc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nnojotsü shiain yarüttüin atüma saa'in wane wayuu nu'upala Maleiwa tü kasa ekerotkat saanükülu'upünaa. Shia yarüttaka atüma saa'in tü pütchi ajuittakat saanükülu'ujee —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Arütkaashii na nikirajüinkana Jesús nünainmüin sünain namüin nümüin sujuuna tü wayuukolüirua: —¿Pütüjaa aa'ut sünain mojushiin namüin na fariseokana tü püküjüitpakat namüin? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nüsouktakalaka Jesús namüin: —Nala fariseokana, müshii aka saa'in wane a'ttiee naatajatü nnojotkat nüpünajalain chi Tashikai Maleiwa chakai iipünaa sünain nusuje'ereerüin shia mapeena. ");
INSERT INTO guc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Anakaja joolu'u müleka nnojoliire kasajanain naya jümüin. Mayaashiije mo'uin naya, e'itaanüshii naya naashin süpüla nee'iyatüinjatüin tü wopukot sümüin wayuu eekai mo'uin. Soto jaa'in wane kasa: Müleka nu'uninnüle wane wayuu eekai mo'uin nütüma wane eekai mo'uinya, eeshii süpüla nojunuujiraain sulu'u ishi —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nümakalaka Pedro nümüin Jesús: —¿Jamalu'ut tü püküjüitpakat sümüin tü wayuukolüirua süchiki tü yarüttakat atüma saa'in no'ulu'u Maleiwa? —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nüsouktakalaka Jesús namüin: —¿Nnojoliyütta'aya jiyaawatüin aa'u jiakanaya tü tekirajakat anain? ");
INSERT INTO guc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tamüshii paala jia jüchikua: Tü ekerotokot sulu'upünaa jaanükü, jüle'eru'umüinjatü ne'e sünain shiyu'laain süchikua juulia. ");
INSERT INTO guc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Otta tü pütchi ojuittakat sulu'upünaa jaanükü, jüle'eru'ujeejatü. Mojulu'urüle shia, shia yarüttaka atüma jaa'in nu'upala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Je müleka yarüttüle naa'in wane wayuu, kachiiruasü naa'in waneepia kasa mojusü, maa aka o'utaa saa'in wayuu, maa aka ama'üjawaa sümaa wayuu nnojotkat nu'wayuusein otta nnojoikai su'wayuusein, maa aka a'luwajirawaa akuaippaa sümaa wayuu jierü otta wane jierü nümaa wane toolo, maa aka a'luwajaa, maa aka aküjaa alawaa süchiki wane wayuu, je maa aka mojuu anüiki sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Shia yarüttaka'a atüma naa'in wane wayuu nu'upala Maleiwa. Otta nnojotsü yarüttüsüin naa'in sütüma mo'lojooin najapü süpüla ekaa —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Shiasa mapa tia, o'unüshi Jesús namaa na nikirajüinkana yalajee yala Genesaretjee sulu'umüin tü mmakat kalu'ukot tü pueulokalüirua Tiro oo'ulaka Sidón. ");
INSERT INTO guc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Eekalaka wane jierü kepiasü cha'aya, wane jierü Canaánje'ewat, suu'uliwo'u tü wayuukolüirua nnojotkot judíoin, kepiapü'ükat paala sulu'u tü mmakat Canaán. Antüsü tü wayuukot nünainmüin Jesús sünain su'waatüin nümüin: —Ekirajüikalee, mayeinsü ma'i tachon sütüma kale'eru'uwaa yolujaa. Pia Nülüinkai David, anakaja pümüliajüle taya —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Otta Jesús, ko'utakalaka nia suulia. Narütkaakalaka joo na nikirajüinkana sünain nachuntüin ma'i nümüin: —Mojushiisü wamüin tüü. Masütaajusat shia sünain a'waataa wachiirua. Anakaja püjütüle shia woulia —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nüsouktakalaka Jesús: —Nnojoishi ajütüüshin taya nütüma Maleiwa sünainmüin wayuu nnojotkat judíoin, ajütüüshi taya süpüla to'tte'erüinjatüin tü wayuu Israelkalüirua sümüiwa, tü makat aka saa'in anneerü eekai amüloulin —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Je joolu'u tü jietkat, süsapainyo'ukakalaka shia nümülatu'u Jesús. —Ekirajüikalee, pükaaliija taya —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nüsouktakalaka sümüin: —Tamüsü paala pia: Nnojotsü anain müleka saapünüle tü shiküinjatkat süchooin wane wayuu sümüin tü etkalüirua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sümakalaka nümüin: —Aa, shiimüin, Ekirajüikalee, ayatapaja'aya ne'e a'lumujüin chi etkai tü ojutuusükat saa'ujee nemeesain na ekaashiikana —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nümakalaka Jesús sümüin: —Maachee, te'rüin pia sünain shiimüin pünoujain tanain süka süpüshua paa'in. Anakaja müleka naapüle joolu'u Maleiwa tü püchuntakat —nümakalaka sümüin. Anakalaka tü süchonkot wanaa ma'i sümaa tia. ");
INSERT INTO guc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Shiasa mapa tia, ale'ejüshi Jesús nüchikua sotpünaa tü palaakat Galilea. Je yalajee, o'unüshi nia saa'umüin wane namüna. Nüikkalaakalaka cha'aya. ");
INSERT INTO guc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Je antüsü wayuu watta saalin nünainmüin Jesús ayuuisümaajatü. Eesü wayuu eekai masa'ain, eekai mo'uin, eekai matünain, eekai manülin, je wainma eekai ayuulin sütüma ayuulii eekai eein ne'e. Antinnüsü tü ayuuisükalüirua nümülatu'umüin Jesús je niiyajüin shia. ");
INSERT INTO guc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Je tü wattakat saalin wayuu, ponosü ma'i saa'in tü shi'rakat: Chi manüisaikai paala, kanülichipa, chi matünasaikai paala, katünaichipa, chi masa'asaikai paala, kasa'aichipa, je chi mo'usaikai paala, ko'uichipa. Je tü wayuukolüirua süpüshua, su'waajakalaka joo Maleiwa, chi Namaleiwasekai nayakana na Israelkana. ");
INSERT INTO guc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nuunejakalaka joo Jesús na nikirajüinkana nünainmüin sünain nümüin namüin: —Tamüliajee amüinrü tü wattakat saalin wayuu süka apünüinrüin ka'i tü kettatkat naa'u sünain tamaain naya. Je aja'lajaaitpa tü nemiakat. Tacheküin süpüleerua neküinjanain nama'ichiki. Müleka tajütüle naya sünain ouktüin jamü, eeshii süpüla nawalejünüin wopulu'u —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Namakalaka na nikirajüinkana: —Nnojotsü kasain eein yaaya. ¿Jalajeekualüinjatkai wapüla tü eküülü shikajatkat watüma tü wattakat saalin wayuu? ");
INSERT INTO guc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Jera pan eekat jüma'ana? —nümakalaka Jesús. —Akaratshisü ne'e pan eekat yaaya sümaa palitchen ne'e jimechen asijuushi —namakalaka ni'ipajee. ");
INSERT INTO guc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nuluwataakalaka Jesús tü wattakat saalin wayuu sünain süikkalaainjatüin mmalu'u. ");
INSERT INTO guc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naapaakalaka joo Jesús tü akaratshisükat pan je tü jimechenkat sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshanaajakalaka joo shia süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eküshii naya napüshuale'eya je emirashii sünainjee. Je süchikijee, okotchajünüsü tü napütaalakat natüma na nikirajüinkana, maa aka akaratshi katto'ui. ");
INSERT INTO guc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Eejana maa aka 4.000 tooloyuu sa'aka tü wayuukolüirua süpüshua sünain mayaawajuin na jieyuu oo'ulaka na tepichi eejanakana. ");
INSERT INTO guc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Je kettaapa shiküin tü wayuukolüirua, nümakalaka Jesús namüin: “Anashii ju'unüle jipialu'umüin”. Je Jesús, o'otooshi nia namaa na nikirajüinkana sulu'u wane anua sünain o'unaa eemüin tü mmakat kalu'ukot tü pueulokot Magdala. ");
INSERT INTO guc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Je nantapa chamüin cha'aya, eeshii napüla wane wayuuirua fariseo oo'ulaka waneeirua saduceo. Antüshii naya süpüla nasakirayaainjachin Jesús shii'iree niweetirüin wane pütchi kasalajanajatkat natüma nümüin. Nachuntayaain nümüin naa'inrüinjatüin no'upala wane kasa eekai anashaatasü nütüjakat apüleerua Maleiwa nümüiwa, tü ee'iyatüsüjatkat nukuaippa sünain nüjünalain nia Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nüsouktakalaka Jesús namüin: “Müleka ishole tü sirumakat motsapa ka'i, ‘Nnojoleerü a'itüin juya’, müshii jia. ");
INSERT INTO guc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Otta müleka ishole shia watta'a maalü sümaa sirumain, ‘Juyapeerü so'uka'i tüü’, müshii jia. Jia kayaawasekana sümüin tü sirumakat, ¿jamüsü nnojotka'a jiyaawatüin saa'u kasain tü taa'inrakat maa'ulu yaa? ");
INSERT INTO guc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jia wayuu eekana maa'ulu yaa, jia kaainjaralii e'rüliikana ma'i wayumüin nümüin Maleiwa, ¿jamüsü taa'inreeka'a jütüma wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa, tü ee'iyatüsüjatkat takuaippa sünain nüjünalain taya Maleiwa? Shiimüin tü tamakat jümüin: Nnojoleerü taa'inrüin tü juchuntakat tamüin. Shia soto jaa'in tü nüchikikat Jonás chi nünüikimaajachikai Maleiwa nümaiwa süpüla jütüjaainjatüin taa'u mapeena sünainjee sünain nüjünalain taya Maleiwa”, nümakalaka Jesús namüin. Kettaapa nünüiki, o'unüshi nia nama'anajee. ");
INSERT INTO guc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Otta na nikirajüinkana Jesús, sotüitpa naa'in joolu'u sünain malü'üjüin naya tü pan nakotchirakat paala nanainjee na wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nüchiajaataalakalaka naya sünain maa namüin: —Jalia jia suulia tü oolojiakat pan nama'anajeejatkat na fariseokana oo'ulaka tü nama'anajeejatkat na saduceokana —nümakalaka namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Namajiraakalaka sütüma tü nümakat Jesús: —Shiakajasa'a nümüin süka motüin waa'in tü pankat —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Süka nütüjaain saa'u Jesús tü naashajaajiraakat achiki, müshi nia namüin: —Jiirakaa jiakana motsokana anoula, ¿jamüshii jaashajaajiraaka'a süchiki sünain nnojolüin pan jüma'ana? ");
INSERT INTO guc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nnojoliyüttaaja'a jiyaawatüin aa'u tü tekirajeekat anain jia? Soto jaa'in wanaa sümaa tekirüin 5.000 tooloyuu oo'ulaka jieyuu je tepichiya süka tü ja'raisükat pan je sünain süpütaain wainma süchikijee. ");
INSERT INTO guc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Je soto jaa'inya wanaa sümaa tekirüin 4.000 tooloyuu oo'ulaka jieyuu je tepichiya süka tü akaratshisükat pan je sünain süpütaainja'a wainma süchiki. ");
INSERT INTO guc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Otta wanaa sümaa tachiajaain jia, nnojoishi taya aashajaashin süchiki pan. Shia tachiajaaka oulia tü oolojiakat pan nama'anakat na fariseokana oo'ulaka na saduceokana —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nayaawatüitpa aa'u joolu'u na nikirajüinkana sünain shiain nüchiaain oulia tü nekirajakat anain na fariseokana oo'ulaka na saduceokana, tü a'walakajaakat sa'akamüin wayuu, nnojoloja'a shiain tü oolojiakat pan. ");
INSERT INTO guc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","O'unüshi joolu'u Jesús namaa na nikirajüinkana sü'ütpa'amüin tü pueulokat Cesarea de Filipo münakat. Nümakalaka Jesús namüin: —Tayakai, chi Shipayakai Wayuu, ¿jarai taya saashin tü wayuukolüirua? ");
INSERT INTO guc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nasouktakalaka ni'ipajee: —“Niataa Juan chi owoutisaajüikai”, müsü waneeirua. “Niataa Elías”, eesü makat. “Niataa Jeremías, niataa no'uluku na nünüikimaajanakana Maleiwa paala sümaiwa”, eesü makat ne'e —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Jama jiakana, ¿jarai taya jaajüin? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nüsouktakalaka joo Pedro nümüin: —Pia Cristoka'aya, chi Nüneekajalakai Maleiwa süpüla o'tte'eraa wayuu. Pia chi Nüchonkai chi Maleiwa matüjüinkai ouktaa —nümakalaka Pedro. ");
INSERT INTO guc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nümakalaka Jesús nümüin: —Simón, nüchonkai Jonás, anata'aleeshija'a ma'i pia. Nnojotsü piyaawatalain aa'u shiimüinkat tüü sükajee ne'e pikirajünüin sünain sütüma wayuu. Nia chi Tashikai chakai iipünaa ee'iyataka shia pümüin. ");
INSERT INTO guc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tamüshi paala pia: Watüjaa aa'ut sünain “Ipa” malu'ulüin tü anüliee Pedro makat te'itaakat paala pünain. Je joolu'u, maa aka ichein ma'i süsa'a wane miichi müleka shi'itaanüle saa'u ipa, akaweeria sünain ichein ma'i tü pünoulakat. Je meeria nanoula na anoujashiikana tanain sainküin mmakat. Je nnojoleena shiyamülüin naya tü ouktaakat. ");
INSERT INTO guc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Meechi aka pia wane wayuu kajapulu'ukai atümaa shiyaawein wane miichi, süka laülaweechin pia wanaa tamaa chaa eere nuluwataain chi Tashikai Maleiwa. Tü kasa kapükat pütüma yaa saa'u mmakat, kapeerü chaa iipünaa eere Maleiwa. Je tü kasa taashikat pütüma yaa saa'u mmakat, taasheerü chaa iipünaa eere Maleiwa —nümakalaka Jesús nümüin Pedro. ");
INSERT INTO guc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ni'ikakalaka joo Jesús naa'in na nikirajüinkana sünain nümüin namüin: —Nnojo jüküjüin tachiki sümüin wayuu sünain tayain chi Cristo Nüneekajalakai Maleiwa —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Shiasa süchikijee ka'ikat tia, o'ttüshi Jesús sünain aküjaa namüin na nikirajüinkana süchiki süpüshua tü aa'inneetkat nüka mapeena sünain nümüin namüin: “Nücheküin chi Maleiwakai süpüleerua to'unüin Jerusalénmüin süpüla müliainjachin ma'i taya natüma na laülaayuushiikana naa'u na judíokana, oo'ulaka natüma na laülaayuushiikana na'akajee na sacerdote judíokana, oo'ulaka natüma na karalouktamaajanakana. O'utinneechi aa'in taya natüma. Je so'u apünüin ka'i süchikijee tia, oso'ire'enneechi aa'in taya”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Najattünakalaka Jesús nütüma Pedro mamüin aka türa sünain nüchiaainjachin nia: —Senyotkalee, jalia pia suulia sülanüin pümüin tüü —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nujununujaakalaka Jesús nuulia Pedro sünain nümüin nümüin: —Nünüikimaajachi pia Satanás, ko'uta ne'e pia toulia. Nnojo pa'alijirüin taya suulia tekeraajüin tü nüchekakat tapüleerua Maleiwa. Tü jülüjakat paa'in, püle'eru'ujeejatü ne'e shia, nnojotsü shiain tü ni'inaajalakat paala chi Maleiwakai tapüleerua —nümakalaka Jesús nümüin Pedro. ");
INSERT INTO guc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nümakalaka Jesús namüin na nikirajüinkana: “Chi wayuu eekai tamaweein, anakaja müleka nnojorule naa'inrüin tü nüchekakat ne'e nümüiwa. Shia anaka alu'u müleka naa'inrüle waneepia tü nüchekakat Maleiwa nüpüleerua, sümaa nnojolin mmolüin sheema o'utinnaa aa'in saa'u noonooin sümaa tanüiki. ");
INSERT INTO guc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi eekai niyouktüin taya süka naa'inmajiraweein nukuaippa suulia ouktaa, amülouijeerü nukuaippa süpüshua. Otta chi wayuu eekai naapajiraain nukuaippa süpüla ni'yataainjachin tamüin, mayaashije o'utüneechin aa'in sünainjee tia, ayateechi o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Maja'a aka chi eekai niyouktüin taya süka washireein nia, amülouijeerü tü nukuaippakat süpüshua, süka nnojolüin suuntüin tü nuwashirüinkat süpüla nu'tte'ennüin sükajee. ");
INSERT INTO guc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tayakai chi Shipayakai Wayuu, anteechi tachikua eejee chi Tashikai saa'u e'itaaushin taya nütüma süpüla aluwatawaa wanaa nümaa je eejeena na aapieekana nüma'anajeejanakana tamaa. Anteechi taya süpüla tawalaajeerüin wane'ewai sükua tü wayuukolüirua saa'u süpüshua tü kasa saa'inrapü'ükat, maa aka na aa'inrakana kasa anasü, otta na aa'inrakana kasa mojusü. ");
INSERT INTO guc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Shiimüin tü tamakat jümüin: Ana'aya ju'utku jia yaakana maa'ulu yaa nnojoleenakana ouktüin süpülapünaa ne'rüin tayakai chi Shipayakai Wayuu sünain o'ttaa sünain aluwatawaa”. ");
INSERT INTO guc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Je mapa aippirua ka'i süchikijee tia, neenajaakalaka Jesús apünüinshii na nikirajüinkana: Pedro, Jacobo oo'ulaka Juan, chi nimüliakai Jacobo, süpüla no'unajanain nümaa namüiwa eemüin wane uuchi. ");
INSERT INTO guc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Je chamüin cha'aya, ee'iranajaasü nukuaippa Jesús no'upala. Chuwatsü ma'i nu'upünaa maa aka naa'in chi ka'ikai. Otta nüshe'in, jorojorotsü ma'i. ");
INSERT INTO guc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eweenaa müshi'iya no'upala wane piamashii wayuu sünain naashajaain nümaa Jesús: nia Moisés oo'ulaka Elías, na nünüikimaajanakana Maleiwa paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nümakalaka Pedro: —Senyotkalee, anasü ma'i süka we'rüitpain tü kasa alatakat wo'upala. Müleka pücheküle, anasü müleka takumajüle apünüinsü luma: wane püpüla, wane nüpüla Moisés, je wane nüpüla Elías —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wanaa sümaa naashajaain Pedro, eweetalaa müsü wane siruma kasuutalü ma'i nanainmüin. Süsouktakalaka wane pütchi sa'akajee tü sirumakat: “Anii chi Tachonkai aishikai tapüla. Talatüshi ma'i taya nümaa. Jüüjüü jümata sümüin nünüiki”, sümakalaka tü pütchikat namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Je na apünüinshiikana nikirajüin, naapapa tü pütchikat, a'wachiraashii mmalu'u süka mmolüin ma'i naya. ");
INSERT INTO guc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nürütkaakalaka Jesús nanainmüin sünain ni'itaain najapü nanain sünain nümüin namüin: —Jüsha'walaa, nnojo mmolüin jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Otta nayaletpa nekii, ne'rüin Jesús sünain nümüiwain. ");
INSERT INTO guc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Je wanaa sümaa nashakatüin saa'ujee tü uuchikat, ni'ikakalaka joo Jesús naa'in sünain nümüin namüin: —Nnojo jüküjüin süchiki tü kasa ji'rüitpakat wane'ere'eya jüküjüin taso'iraapa aa'in süchikijee ouktaa, taya chi Shipayakai Wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nasakirakalaka nia: —¿Jamüshii naküjaka'a na karalouktamaajanakana nüchiki Elías sünain niainjachin antüin palajana nüpüleerua chi Cristo Nüneekajalakai Maleiwa? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nüsouktakalaka Jesús namüin: —Shiimüin sünain niainjachin Elías antüin palajana süpüla yapainjatüin nütüma süpüshua tü nüpüshikalüirua Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tamüshii paala jia: Antüichipa Elías, akaisa nnojolin shiyaawatüin nia wayuu. E'rüliishii wayumüin nümüin. Akaweechia tayakai chi Shipayakai Wayuu, ne'reechi amüin tayaka'iya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Je na apünüinshiikana nikirajüin, nayaawatüitpa joolu'u saa'u sünain niain Juan chi owoutisaajüikai naashajaain achiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nantapa sa'akamüin tü wattakat saalin wayuu, arütkaashi wane wayuu nünainmüin Jesús sünain nüsapainyo'ukain nümülatu'u sünain nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ekirajüikalee, anii tachon ayuuishi, anakaja pümüliajüle nia. Müliasü ma'i naa'in wanaa sümaa nu'kchichijaain. Ojutu'uwaishi nia sütüma sa'aka tü sikikat je shiroku wüin. ");
INSERT INTO guc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","To'unirüin paala chi tachonkai nanainmüin na pikirajüinkana shii'iree neiyajeein nia. Isasü nachiki —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nümakalaka Jesús sümüin tü wayuukolüirua süpüshua: —Jiakana manoujüinyeekana tanain, jia e'rüliikana wayumüin tamüin, wattairü süma'a ta'atapajüin jia shii'iree jünoujeein tanain —nümakalaka namüin. —Püche'era chira püchonkai —nümakalaka nümüin nüshi chi jintüikai. ");
INSERT INTO guc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Otta müshia Jesús, nuu'ule'erakalaka tü yolujaakat suulia tü saa'inrakat nüka chi jintüikai. Sujuittakalaka nüle'eru'ujee. Anakalaka chi jintüikai wanaa sümaa tia. ");
INSERT INTO guc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Narütkaakalaka na nikirajüinkana nünainmüin sujuuna tü wattakat saalin wayuu sünain nasakirüin nia: —¿Jamüsü nnojotka'a wountüin wayu'lüin tü yolujaakat nuulia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nüsouktakalaka Jesús namüin: —Isasü jüchiki süka nnojolüin jünoujain tanain. Shiimüin tü tamakat jümüin: Müleka jünoujüle tanain, ja'itairü nnojolüin katsüin joolu'u tü jünoulakat, jaa'inreerü tü kasa isakat süchiki wayuu. Maa aka jümataarüle paala sümüin wane uuchi, “Anakaja pu'unüle yaajee ka'yatamüin”, sünoujeerü jünüiki. Nnojoleerü kasain isain jüchiki. ");
INSERT INTO guc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Otta yolujaa eekai müin aka tü ojuittinnakat nuulia chi jintüikai, nnojoleerü ojuittüin müleka nnojorule jüchuntüin nümüin Maleiwa sümaa jaamajüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Shiasa mapa tia, wanaa sümaa jutkatüin Jesús namaa na nikirajüinkana cha'aya Galilea, müshi nia namüin: —Tayakai, chi Shipayakai Wayuu, aapüneematüichi ekii taya sajapulu'umüin wane wayuuirua. ");
INSERT INTO guc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","O'utinneechi aa'in taya natüma. Je so'u apünüin ka'i süchikijee tia, oso'ire'enneechi aa'in taya —nümakalaka namüin. Je na nikirajüinkana, mojukalaka ma'i naa'in sütüma tü nümüitpakat namüin. ");
INSERT INTO guc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nüntakalaka Jesús namaa na nikirajüinkana sulu'umüin tü pueulokat Capernaum. Eeshii wane okotchajülii neerü süpülajatü tü a'waajüleekat Maleiwa. Nantakalaka nünainmüin Pedro sünain nasakirüin nia: —¿Naapüin chi ekirajüikai pia tü neerü süpülajatkat tü a'waajüleekat Maleiwa? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Aa —nümakalaka Pedro namüin. Shiasa nikerolapa Pedro sulu'umüin wane miichi, arütkaa müshia Jesús nünainmüin sünain nümüin nümüin: —Simón, tasakirüin paala pia sünain wane kasa: ¿Jaralii na wayuu awalaajüinjanaka nümüin chi sülaülashikai mma? ¿Naya na nüchooinkana? ¿Nayataapa na wayuu nnojoliikana nüchooin, na wayuu nuluwataakana ne'e aa'u? —nümakalaka Jesús nümüin Pedro. ");
INSERT INTO guc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Naya na wayuu nnojoliikana nüchooin —nümakalaka Pedro ni'ipajee. Nümakalaka Jesús nümüin: —Nnojoluja mata awalaajüinjanain na nüchooinkana. ");
INSERT INTO guc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Otta müsia suulia mojujain naa'in na wayuu aashajaayüliikana pümaa, anakaja müleka pu'unüle joolu'u sotpa'amüin tü palaakat süpüla pujutüin tü kuli'rakat shiroku. Je tü palajateetkat jime piyu'lüin, pujutala saanükü, je eejeerü püpüla wane neerü kachueera. Paapa tia namüin na okotchajüliikana süpüla wawalaajüin wayakana piamale süka, piakai oo'ulaka tayakai —nümakalaka Jesús nümüin Pedro. ");
INSERT INTO guc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Shiasa mapa tia, arütkaashii na nikirajüinkana Jesús nünainmüin sünain namüin nümüin: —¿Jaraleechi miyo'uka so'uweena wane ka'i eere nuluwataain Maleiwa? —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Neenajakalaka Jesús wane jintüi nünainmüin pasanain nanain na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nümakalaka Jesús namüin: —Shiimüin tü tamakat jümüin: Müleka nnojorule shii'iranajaain jukuaippa maa aka nukuaippa chi jintüikai, müinaya jia mekerolüin cha'aya eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Maa aka jintüikai chii sünain nnojolüin yaletayaain naa'in, akaainjachia chi wayuu eekai miyo'uweein cha'aya eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Je chi wayuu eekai kamaneein sümüin wane wayuu, maa aka naa'in jintüikai chii, saa'u nünoujain tanain, kamaneeshi nia tamü'inya wanaa sümaa. ");
INSERT INTO guc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Na anoujashiikana tanain, na makana saa'in tepichi, müleka naka'injaale suulia anoujaa nütüma wane wayuu, anashi müleka nujutinnüle chia wayuukai shirokumüin tü palaakat sünain kanutpünaain nia wane ipa miyo'u süpüla wattainjachin nia shiinalu'umüin. ");
INSERT INTO guc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kapüleesü saa'innüin tü anasükat sütüma wayuu yaa saa'u mmakat, süka wainmain tü kasa kaainjalakat atüma wayuu. Je süka tia, ayateerü wayuu wainma sünain kaainjalaa. Otta chi eekai naainjireein tü wayuukolüirua kasa mojusü, ‘aisha'ajaa’ meechi nia, süka kasalajaneerüin shia nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jalia pia suulia kaainjalaa sükajee tü kasa paa'inrakat süka pajapü je sükajee tü kasa paa'inrakat eepünaale su'unirüin pia tü puu'uikat. Anasüje ne'e shiale amüloulin puulia waneesia pajapü je puu'ui shiale sünain pikerolüin nüma'anamüin Maleiwa suulia pikerolojüin Hadesmüin sümaa tü piamasükat pajapü je puu'ui, chaa eemüinjachire pujutünüin sa'akamüin tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jalia pia suulia kaainjalaa sükajee tü kasa pi'rakat. Anasüje ne'e shiale amüloulin puulia waneesia po'u sünain pikerolüin nüma'anamüin Maleiwa suulia pikerolojüin Hadesmüin sümaa tü piamasükat po'u, chaa eemüinjachire pujutünüin sa'akamüin tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jalia jia suulia pülajüin jaa'in noulia na anoujashiikana tanain, na makana saa'in tepichi. Tamüshii paala jia: Na aapiee e'itaaushikana süpüla aa'inmajaa naya, jutatüsü napüla ekerolaa nünainmüin chi Tashikai Maleiwa chaa iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Antüshi tayakai, chi Shipayakai Wayuu, süpüla to'tte'erüinjatüin wayuu eekai maa'awain nuulia Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wane wayuu ja'aka, müleka kamü'ünüinre nia poloo shikii anneerü je machikitaarüle waneesia sünainjee, nüpüteerü tü süpüshikat, tü mekietsatkat shikii mekietsalümüin, chaa saa'u tü namünakat süpüla o'unaa sünain achajawaa süchiki tü machikisatkat. ");
INSERT INTO guc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Shiimüin tü tamakat jümüin: Nüntapa chi wayuukai sünain, talataleejeeria ma'i naa'in sümaa suulialee sümaa tü mekietsatkat shikii mekietsalümüin nnojotkat machikisalüin. ");
INSERT INTO guc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Müsia nukuaippa chi Jüshikai Maleiwa chakai iipünaa, nnojotsü nücheküin süpüleerua maa'awain nuulia waneesükaije'e tü anoujasükalüirua tanain, na makana saa'in tepichi. ");
INSERT INTO guc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Müleka kaainjarale wane puwala puulia, anakaja pu'unüle nünainmüin süpüla paashajaain nümaa nümüiwa süchiki tü kasa mojusü naa'inrakat pümüin. Je müleka kapürale naa'in tü püküjakat nümüin, puunteerü anajiraain pia nümaa. ");
INSERT INTO guc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Akaajasa müleka niyouktüle pünüiki, anakaja püle'ejüle nünainmüin mapeena sünain pümaain waneesia je piama puwalayuu shiale atüjaakana saa'u sünain pansaain tü pümakat nümüin, maa aka tü suluwataakat anain tü nüchikimaajatkat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Je müleka ayatüle nnojolüin kapülain naa'in tü pümakat nümüin, anakaja püküjale süchiki tü naainjalakat namüin na anoujashiikana wanaa sümaa jutkatüin. Je müleka niyouktüle tü namakat na anoujashiikana napüshua nümüin, piirakaa pümata nümüin maa aka naa'in eekai matüjüin ayaawajawaa suulia aainjalaa. ");
INSERT INTO guc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Shiimüin tü tamakat jümüin: Tü kasa kapükat jütüma yaa saa'u mmakat, kapeerü chaa iipünaa eere Maleiwa. Je tü kasa taashikat jütüma yaa saa'u mmakat, taasheerü chaa iipünaa eere Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Tamüsü paala jümüin wane kasaya: Müleka paa'inwale piamashii wayuu ja'akajee sünain achuntaa soo'opünaa wane kasa nümüin chi Tashikai Maleiwa chakai iipünaa, aapüneerü shia namüin nütüma. ");
INSERT INTO guc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Süka jamüin, eejeechi taya jümaa jiakana anoujashiikana tanain wanaa sümaa jutkatüin jia süpüla achuntaa nümüin Maleiwa, ja'itaina piamashiin je apünüinshiin ne'e jia”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Arütkaashi joolu'u Pedro nünainmüin Jesús sünain nümüin nümüin: —Senyotkalee, müleka masütaajule wane tawala sünain kaainjalain nia toulia, ¿jeratuainjatü motoka amaa taa'in tü kasa mojusü naa'inrakat? ¿Kojuyatua? —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nüsouktakalaka Jesús nümüin: —Tamüshi paala pia: Nnojotsü kojuyatuain ne'e. Motowalinjatü paa'in waneepia kaainjalakat o'u puulia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nüküjakalaka Jesús nüchiki Maleiwa sünain nuluwataain süpüla natüjaainjatüin saa'u sünain jamüinjatüin sukuaippa süpüla motüinjatüin naa'in naainjala wane nawala noulia: “Tü nuluwataayakat Maleiwa, müsü aka saa'in nukuaippa wane wayuu aluwataashi sulu'u wane mma. So'u wane ka'i, neenajirüin na nüchepchiakana nünainmüin süpüla nütüjaain saa'u jerain neerü najuyaajüin nuulia wane'ewai nakua süpüla nawalaajüinjatüin shia nümüin süchikua. ");
INSERT INTO guc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nüntakalaka nünainmüin wane chi nüchepchiakai kajuyaalakai watta saalin neerü nuulia. ");
INSERT INTO guc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Otta nnojotkalaka nuuntüin nuwalaajüin süchikua tü nujuyaalakat. Nüsouktakalaka chi laamakai: ‘Jüikka jümaala chi wayuukai sümaa nu'wayuuse sümaa nüchooin oo'ulaka süpüshua tü kasa eekat nüma'ana süpüla walaainjatüin tü nujuyaalakat toulia süka tü naliakat’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Nüsapainyo'ukakalaka chi nüchepchiakai nümülatu'u chi nülaamainkai sünain nuchuntashaatain nümüin nümülialüin nia sünain nümüin nümüin: ‘Anakaja paawarüle paala taya, tawalaajeerü pümüin süpüshua tü tajuyaalakat’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Je chi laamakai, nümüliajakalaka naa'inyaka chi nüchepchiakai sümaa nuu'ulaaleein tü nünneetsekat nüpüla sümaa taashin nia nütüma. ");
INSERT INTO guc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Otta chi achepchieekai, nu'unakalaka nünainmüin wane achepchiee wanaa nümaa. Nujuyaajirüin paala wane palitchon neerü. Naapaa nümüshia chi nüpüshikai nümülapünaa sünain nümüin nümüin: ‘Puwalaaja pümaala tü pujuyaalakat toulia’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Niasa chi nüpüshikai, nüsapainyo'ukakalaka nia nümülatu'u sünain nüchuntashaatain nümüin nümülialüin nia sünain nümüin nümüin: ‘Anakaja paawarüle taya, tawalaajamaateerü pümüin süpüshua tü tajuyaalakat’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Nüsouktakalaka nümüin: ‘Nnojoruleeja'a süpüla taawalüin pia’, nümakalaka nümüin. Nüpüreesajitkalaka joo chi nüpüshikai wane'ere'eya nujuittüin nuwalaajapa tü nujuyaalakat. ");
INSERT INTO guc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nayasa na waneeirua achepchieekanairua, mojukalaka ma'i naa'in naapapa süchiki tü alatakat. No'unakalaka nünainmüin chi nalaamainkai sünain aküjaa süchiki süpüshua tü alatakat nümüin chi napüshikai. ");
INSERT INTO guc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Je joolu'u chi laamakai, neenajakalaka joo chia nüchepchiakai nünainmüin sünain nümüin nümüin: ‘E'rüikaiche aa'in wayumüin pia. Aashin too'ulaayaainkain tü tanneetsekat püpüla süka püchuntüin tamüin taawalüin pia. ");
INSERT INTO guc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mojushiisü tamüin nnojolüin pümüliajüin chi püpüshikai maa aka tamüliajüin pia’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Je sünain jashichin ma'i chi laamakai, nujutitkalaka joo chi nüchepchiakai sulu'umüin tü kaatsetkat süpüla ni'yaajünüin wane'ere'eya nujuittüin nuwalaajapa süpüshua tü nujuyaalakat. ");
INSERT INTO guc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tamüshii paala jia: Akaweenia jia wane'ewaire jukua nütüma chi Tashikai Maleiwa chakai iipünaa müleka nnojorule motoleeinya jaa'in naainjala na juwalayuukana juulia”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Shiasa nüküjapa Jesús tüü namüin na nikirajüinkana, o'unüshi nia chajee Galileajee sulu'umüin tü mmakat Judea. Je yalajee yala, o'unüshi waneemüin sa'ata tü süchikat Jordán. ");
INSERT INTO guc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Suushikajaakalaka watta saalin wayuu nüchiirua. Je nüntapa chamüin, niiyajüin wayuu eekai ayuulin sa'aka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Narütkaakalaka wane wayuu fariseoirua nünainmüin Jesús süpüla nasakirayaainjachin nia shii'iree niweetirüin wane pütchi kasalajanajatkat nümüin natüma sünain maa: —¿Anasü müleka nuu'ulaale nu'wayuuse wane wayuu saaliijee kasa eekai eein ne'e? —namakalaka na fariseokana nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nüsouktakalaka Jesús namüin: —Jütüjaa aa'ut tü ashajünakat paala süchiki jamüin sukuaippa wayuu wanaa sümaa sükumajünüin paala sümaiwa nütüma Maleiwa. Nükumajüin wayuu toolo oo'ulaka wayuu jierü. ");
INSERT INTO guc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Je nümakalaka chi Maleiwakai: “Sükajee takumajüin wayuu toolo oo'ulaka wayuu jierü, anashi nujuittüle chi wayuukai nuulia chi nüshikai je suulia tü niikat süpüla ka'wayuusein nia je süpüla kepiainjachin nia sümaa tü nu'wayuusekat saa'u sa'aniraaitpain nukuaippa sümaa”, müshi Maleiwakai paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Waneeinapa wayuu naya, nnojoliinapa katata'awain. Tamüshii paala jia: Sa'aniraapa nukuaippa wane wayuu toolo sümaa wane jierü nütüma Maleiwa, nnojotsü anain süpüla sükatajiraanüin sütüma wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Namakalaka na fariseokana ni'ipajee: —¿Jamaka'a sümaka'a tü nüshajakat Moisés tü makat: “Müleka nücheküle wane wayuu süpüleerua nuu'ulaain suulia tü nu'wayuusekat, che'ojaasü nüshajüin ne'e wane karaloukta aapiria tü nu'wayuusekat sünain nuu'ulaainjatüin shia. Süchikijee naapüin tü karalouktakat sümüin, eesü süpüla nüjütüin shia nüma'anajee”, makat? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nüsouktakalaka Jesús namüin: —“Ma jütüma sukuaippa ju'wayuuse müleka juu'ulaweere suulia”, müshija Moisés namüin na jutuushinuukana süka nayouktüin tü nüchekakat chi Maleiwakai napüleerua. Eekaja'a su'ttaiwa'aya, nnojotsü majatüin. ");
INSERT INTO guc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Je tanüiki tayakai joolu'u jümüin, müsü mayaa: Chi eekai nuu'ulaain suulia nu'wayuuse, sümaa nnojotsüin süma'üjiraasüin nümaa wane wayuu naata nuulia, müleka ka'wayuusere nia nüchikua, kaainjalashi. Je kasalajaneerü nümüin nüma'üjaain sümaa tü jeketkat nu'wayuusein. Akaajaa chi wayuu ka'wayuusekai tü jierü oo'ulaaushitkat, kaainjalashi nia'aya, je kasalajaneerü nümüin nüma'üjaain sümaa tü jierü oo'ulaaushitkat —nümakalaka Jesús namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Namakalaka joolu'u na nikirajüinkana nümüin Jesús: —Müleka shialeje nukuaippain wane wayuu sümaa tü nu'wayuusekat tia pümakat, anasüja ayatüle wane wayuu ma'wayuusein —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nümakalaka Jesús namüin: —Nnojotsü kapülain saa'in wayuu süpüshua tü jümüitpakat. Naya kapülaka aa'in ne'e na süpülajanakanaja'aya nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eeshii wayuu eekai ma'wayuusein süka aleinjanain naya. Eeshii wayuu eekai ma'wayuusein süka nakapajünüin. Je eeshii eekai ma'wayuusein süka na'yataweein nümüin Maleiwa chakai iipünaa süka süpüshua naa'in. Je joolu'u, chi eekai nuuntüin ma'wayuusee, anakaja kapürale naa'in —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Je so'u wane ka'i, antinnüshii wane tepichiirua nünainmüin Jesús süpüla ni'itaainjatüin najapü naa'uirua sümaa nüchuntüin nümüin Maleiwa naa'u. Otta na nikirajüinkana ne'rapa tia, nachiajaakalaka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Otta müshia Jesús, müshi namüin na nikirajüinkana: —Kettshi'iya na tepichikana nantaiwa tanainmüin. Maa aka nakuaippa na tepichikana sünain nnojolüin kaa'in toulia, müinjatia nakuaippa tamüin na ekeroteekana chaa eere nuluwataain Maleiwa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Shiasa süchikijee ni'itaain najapü saa'u tü tepichikalüirua, o'unüshi nia yalajee yala. ");
INSERT INTO guc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nürütkaakalaka nünainmüin Jesús wane wayuu jima'ai sünain nüsakirüin nia: —Ekirajüikalee, ¿jarat anasü taa'inrüinjatka süpüla eeinjachin taya nümaa Maleiwa waneepia? ");
INSERT INTO guc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Asouktüshi Jesús: —¿Jamüshi püsakiraka'a taya sünain kasa anasü? Waneeshia Maleiwa niain anashin. Müleka pücheküle süpüleerua eeinjachin pia nümaa waneepia, poonoo pümaala sümaa tü nuluwataakat anain —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Tü jaratkat? —nümakalaka nümüin Jesús. Nüsouktakalaka Jesús nümüin: —Tü nuluwataakat anain, müsü mayaa: “Nnojo pu'utüin saa'in wayuu. Nnojo püma'üjaain sümaa wayuu nnojotkat pu'wayuusein otta nnojoikai pu'wayuusein. Nnojo pu'luwajüin sükorolo wayuu. Nnojo püküjüin alawaa süchiki wane wayuu. ");
INSERT INTO guc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kojutüinjatü pütüma püi je püshi. Oo'ulaka na wayuukana napüshua, anashii aire püpüla maa aka alin pia püpülajiraa”, makat —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Taa'inratüjütsa'aya tia süpüshuale'eya. ¿Kasa che'ojaaka tapüleerua? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nüsouktakalaka Jesús nümüin: —Müleka pikeraajeere süpüshua tü nüchekakat püpüleerua Maleiwa, anashi müleka puikküle tü pukorolokot süpüshua süpüla püsülajüinjatüin tü süliakat sümüin wayuu eekai mojuin. Kee'irakeerü pümüin shia iipünaamüin cha'aya eere Maleiwakai. Je paa'inrapa tia, ale'ejeechi pia püchikua tanainmüin süpüla tamaain pia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Je chi jima'aikai sütümajee tü nümakat Jesús nümüin, o'unüshi nüma'anajee sünain mojuin ma'i naa'in süka washirüin ma'i nia. ");
INSERT INTO guc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nümakalaka joolu'u Jesús namüin na nikirajüinkana: —Shiimüin tü tamakat jümüin: Chi wayuu eekai ataralaain sümaa tü nuwashirüinkat, kapüleejeerü ma'i nümüin ekerotoo cha'aya eemüinre nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Müshi tachikua: Mapüleesat süpüleerua shikerotüin wane “camello” so'ulu'upünaa wane wutia suuliale'eya shikerotüin wane wayuu washirü cha'aya eere nuluwataain Maleiwa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Patatsü ma'i naa'in na nikirajüinkana sütüma tü nümakat Jesús. —Isasüja'a sümata nüchiki nu'ttaainjachin wane wayuu —namajiraakalaka. ");
INSERT INTO guc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eirakaashi joo Jesús namüin sünain maa namüin: —Tü kasa isakat süchiki wayuu, nnojotsü kapüleein nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Müshi joo Pedro nümüin Jesús: —Wapütüin süpüshua tü kasa eejatkat wama'ana süpüla yaainjanain waya pümaa. ¿Kasakalaka nuwalaajeenain aka waya Maleiwa? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nüsouktakalaka Jesús: —Shiimüin tü tamakat jümüin, e'itaaushi tayakai chi Shipayakai Wayuu nütüma Maleiwa süpüla aluwatawaa so'uweena wane ka'i. Otta jia polookana piammüin tekirajüin, saa'u tamaain jia waneepia, aluwataweena jia so'uweena ka'ikat tia naa'u na wayuu Israelkana, na polooshiikana piammüin e'irukuu, sulu'u tü mma jeketkat. ");
INSERT INTO guc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Je chi wayuu eekai nüpütüin nipia, nuwalayuu, nüshi, nii, nüchonnii, je na'apainse shiale süpüleerua aküjaa tachiki, alana'aleejeeria tü aapüneetkat nümüin maa aka polootua shikii suulia tü kasa nüpütakat. Je eejeechi nia nümaa Maleiwa waneepia saa'u shii'iranajaaushin naa'in. ");
INSERT INTO guc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tamüshii paala jia: Ja'itaina mojutüin na anoujashiikana sütüma wayuu maa'ulu yaa, ekeroleenapaja'a naya nüma'anamüin Maleiwa so'u wane ka'i. Akaajasa na manoujainsaliikana, ja'itayaashiije kojutüin sütüma wayuu maa'utpünaa yaa, nnojoleena kasajanain nümüin Maleiwa so'u ka'ikat tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nümakalaka Jesús namüin: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in nukuaippa wane wayuu ka'apainseshi. O'unüshi watta'a maalü pülaasapa'amüin sünain nüchajaain süchiki wayuu süpüla shi'yataainjatüin so'u ka'ikat tia sulu'u tü na'apainsekat. ");
INSERT INTO guc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nüküjain namüin na wayuukana sünain nuwalaajüinjachin namüin wane'ewai nakua waneesia neerü kanüliasü ‘denario’ süpüla wane ka'i saa'u na'yataain nümüin sulu'u tü na'apainsekat. Nüjütakalaka naya sulu'umüin tü na'apainsekat. ");
INSERT INTO guc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Shiasa mapa tia, maa aka ja'ipa ka'i, o'unüshi nia nüchikua pülaasapa'amüin. Eekalaka nüpüla wane wayuuirua sha'washawalüin sünain ma'yataain. ");
INSERT INTO guc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nümakalaka namüin: ‘Anakaja ju'unüle ji'yataaiwa jiakanaya sulu'u tü ta'apainsekat. Tawalaajeerü jümüin ji'yataain’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","No'unakalaka. “Je maa aka kale'o oo'ulaka maa aka aliika, o'unüshi nia pülaasapa'amüin nüchikua süka che'ojaayülüin nümüin wayuu a'yataainjatkat. ");
INSERT INTO guc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Shiasa mapa, maa aka motsapa ka'i, o'unüshi pülaasapa'amüin nüchikua'aya. Eekalaka waneeiruaya sha'washawalüin sünain ma'yataain. Nümakalaka namüin: ‘¿Jamüsü kettatka'a ka'ikat jaa'u sünain ma'yataain jia?’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nasouktakalaka nümüin: ‘Nnojoliishii waya a'yataain süka nnojolin jaralin eenajaain süpüla a'yatawaa’, namakalaka. Nümakalaka namüin: ‘Anakaja müleka ju'unüle sulu'umüin tü ta'apainsekat süpüla ji'yataain chamüin’. ");
INSERT INTO guc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Shiasa mapa aipa'a, nümakalaka chi ka'apainseshikai nümüin chi ni'ipajachikai: ‘Peenaka na a'yataaliikana süpüla puwalaajüin namüin tü na'yataainkat. Puwalaaja palajana na chiiruajanakana o'ttüin sünain a'yatawaa. Je süchikijee, puwalaajeena na palajanakana o'ttüin’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Narütkaakalaka nünainmüin na o'ttüshiikana sünain a'yatawaa motsapa ka'i. Nawalaajünakalaka wane'ewaire nakua süka wane ‘denario’. ");
INSERT INTO guc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Otta narütkaapa na o'ttüshiikana palajana sünain a'yatawaa, alatüinjatüyaa naashin namüin suulia tü waneekat ‘denario’. Otta nawalaajünakalaka wane'ewaire nakuaya süka wane ‘denario’. ");
INSERT INTO guc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Je nawalaajünapa, o'ttüshii naya sünain noyoojooin noo'omüin chi ka'apainseshikai sünain namüin nümüin: ");
INSERT INTO guc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nala o'ttüshiikana motsapa ka'i sünain a'yatawaa, wanaawasü puwalaajüin namüin wanaa wamaa waya o'ttüshiikana watta'ajee maalü, ka'isitshiikana so'uka'ipa’, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nümakalaka joo chi ka'apainseshikai nümüin wane: ‘Waa'iraa, nnojoishi e'rüshin wayumüin taya pümüin. Soto paa'in sünain taashajaalatüjülin tüü pümaa sünain tawalaajüinjatüin pümüin tü waneekat “denario” süpüla wane ka'i. ");
INSERT INTO guc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pu'una pümata pipialu'umüin sümaa tü taapüitpakat pümüin. Tacheküin taa'inyaka wanaaweein taapakat nümüin chi antüshikai chiirua sümaa tü taapakat pümüin. ");
INSERT INTO guc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taashishi taya süpüla taa'inrüin tü tachekakat süka tü tanneetsekat. ¿Mojushiisü pümüin nnojolin ji'iyein taya saa'u suulia wayuu?’, nümakalaka chi ka'apainseshikai nümüin. ");
INSERT INTO guc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Akaweechia chi eekai jekechin sünain anoujaa tanain, maa aka chi eekai kama'aichin sünain anoujaa tanain, ekeroleena naya chamüin eere nuluwataain Maleiwa sünain wanaawain nakuaippa no'ulu'u Maleiwa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","So'u wane ka'i, wanaa sümaa nu'unüin Jesús Jerusalénmüin, neenajakalaka namüiwa na nikirajüinkana polooshiikana piammüin sünain maa namüin: ");
INSERT INTO guc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—O'unajana joolu'u waya Jerusalénmüin, je tayakai chi Shipayakai Wayuu, aapüneematüichi ekii taya najapulu'umüin na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana. “Anashi nu'utinnüle aa'in süka kaainjaralin ma'i nia”, meena naya tachiki ");
INSERT INTO guc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","sünain naapüin taya najapulu'umüin na gentilekana. Je naairua, neme'erainpaleechi taya sümaa na'yaateechin taya. Je süchikijee tia, nakachereechi taya süpüla ouktaa. Otta nu'unnaa chi apünüinkai ka'i süchikijee tia, oso'iraajeerü taa'in —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sürütkaakalaka joolu'u tü niikat Jacobo je Juan, na nüchonniikana Zebedeo, nünainmüin Jesús namaa nayakana. Süsapainyo'ukakalaka shia nümülatu'umüin süpüla süchuntüinjatüin nümüin wane kasa. ");
INSERT INTO guc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nümakalaka Jesús sümüin: —¿Kasa kee'ireeka paa'in taa'inrüin pümüin? Süsouktakalaka nümüin: —Tacheküin süpüleerua püikkale'erüin na tachonniikana pa'ato'u cha'aya eejeechire puluwataain, wane pikialu'ujee oo'ulaka wane pipe'eru'ujee —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nümakalaka joolu'u Jesús namüin Jacobo oo'ulaka Juan: —Nnojotsü jütüjaain aa'u tü juchuntakat. ¿Juunteerüjasa'aya jülatirüin tü müliaa te'reetkat? —müshi nia namüin. —Aa, wounteerü —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nümakalaka Jesús namüin: —Shiimüin sünain ji'rüinjatüin müliaa maa aka tayakai. Otta na aikkalaainjanakana tekialu'ujee oo'ulaka tepe'eru'ujee, nnojoishi laülaain taya süpüla, nieechi e'itaaka chi Tashikai Maleiwa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Shiasa na polooshiikana nikirajüin, natüjaapa saa'u tü nachuntakat, aashichijaashii naya namüin Jacobo je Juan süsala tia. ");
INSERT INTO guc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Neenajakalaka Jesús napüshua na nikirajüinkana nünainmüin sünain nümüin namüin: —Na laülaashiikana naa'u na gentilekana, naluwataain naya pejeewa. ");
INSERT INTO guc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Otta jukuaippa jiakana, nnojotsü müinjatüin. Chi wayuu laülaweekai ja'aka, acheküshi jüüjüüinjachin jümüin jüpüshua. ");
INSERT INTO guc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Akaajaa chi wayuu eekai nücheküin süpüleerua miyo'uweein ja'aka, acheküshi niainjachin jüüjüüin jümüin jüpüshua. ");
INSERT INTO guc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maa aka tayakai chi Shipayakai Wayuu, nnojoishi antüshin taya süpüla shi'yataainjatüin wayuu tamüin, alu'ujasa süpüla ta'yataainjachin sümüin wayuu, je süpüla taashinjatüin wayuu wainma suulia saainjala sünainjee ouktüin taya saa'u —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ajuittüshi Jesús namaa na nikirajüinkana sulu'ujee tü pueulo kanüliakat Jericó sümaa wayuu watta saalin. ");
INSERT INTO guc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eekalaka napüla piamashii wayuu mo'usalii joyojoyolüin sotpa'a tü wopukot. Je natüjaapa saa'u na mo'usaliikana sünain nülatüin Jesús na'ütpünaa, nowoorulaakalaka joo sünain namüin: —Senyotkalee, Nülüinkai David, pümüliaja waya. ");
INSERT INTO guc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Shiasa tü wayuu wattakat saalin, —Kaseesün jikiisa —müsü namüin na mo'usaliikana. Otta nayakana, masütaajusalii sünain a'waataa: —Senyotkalee, Nülüinkai David, pümüliaja waya —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nüsha'walaakalaka Jesús sünain nüsaajirüin na mo'usaliikana nünainmüin. —¿Kasa jüchekaka taa'inrüin jümüin? —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Senyotkalee, anashii müleka ko'ule waya —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nümüliajüin Jesús na mo'usaliikana sümaa ni'itaain najapü sünain no'u. Ko'u müshiija na wayuukana. Je süka anaitpain no'u, no'unakalaka joo nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Je nülü'ülapa Jesús namaa na nikirajüinkana sünainmüin Jerusalén, antüshii naya sü'ütpa'a tü pueulokat Betfagé, peje sünain tü wutai kanüliakat Olivos. Nüjütakalaka piamashii na nikirajüinkana nüpüleerua, ");
INSERT INTO guc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sünain nümüin namüin: —Ju'una samüin eemüin tüsa pueulokat. Jikerolapa sulu'umüin, ji'reerü kapüin wane püliikü oo'ulaka chi süchonkai sü'ütpa'a. Jüsiwateerü tü süpükat süpüla jajattüin naya tamüin yaamüin. ");
INSERT INTO guc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Je müleka “¿Jamüinjatü jüsiwataka'a tü süpükat?”, sümüle wayuu jümüin, “Che'ojaashii nümüin chi Senyotkai je nüjütiramaateechi yaamüin nüchikua”, meena jia sümüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai aküjünakat paala nütüma wane nünüikimaajachi sünain maa: ");
INSERT INTO guc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jüküja namüin na wayuu Jerusalénje'ewaliikana sünain maa namüin: ‘Iseeichi jünainmüin naa'u wane püliikü puutut chi Aluwataainjachikai jaa'u. Shiimüin sünain anamiain ma'i nia’ ”. ");
INSERT INTO guc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","No'unakalaka na nikirajüinkana sünain nekeraajüin tü aluwataanakat anain nütüma Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Najattakalaka tü püliikükot oo'ulaka chi püliiküchonkai eemüin Jesús. Ne'itaakalaka tü nashe'inpalajanakat naa'u na püliikükana. Je no'otookalaka Jesús naa'u chi püliiküchonkai. ");
INSERT INTO guc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Awayalayaa müsü süshe'inpalajana tü wayuukolüirua wattakat saalin nüpüleerua sulu'upünaa tü wopukot. Oo'ulaka waneeirua, ashottüshii alanatüna süpüla ne'itaainjatüin shia nüpüla eepünaainjachire nülatüin. Naa'inrüin tüü süpüla nee'iyatüin nujutu nümüin. ");
INSERT INTO guc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Je tü wayuuirua wattakat saalin nüpüleerua oo'ulaka nüchiiruajee Jesús, namayaa namakalaka emetut sünain nasaküin: “Aleluya, wa'waajüin chi Nülüinkai David”. “Wa'waajüin chi Maleiwakai süka nüjütüin nia wamüin. Anata'aleeshija'a ma'i chi antakai wanainmüin”. “Aleluya, wa'waajüin ma'i Maleiwa”. ");
INSERT INTO guc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Je nikerolapa Jesús sulu'umüin Jerusalén, patatsü saa'in tü wayuukolüirua süpüshua sümaa naashajaajiraain sünain maa: —¿Jaraikai nian? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Namakalaka na wayuukana eekai naküjeein: —Nia Jesús chi nünüikimaajachikai Maleiwa chaje'ewaikai Nazaret cha'aya Galilea —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Shiasa süchikijee nüntüin Jesús Jerusalénmüin, nikerotokalaka sulu'umüin tü a'waajüleekat Maleiwa. Eesü nüpüla wane wayuu oikkaasüirua sünain süikkaain tü mürüt o'utinnajatkat aa'in nümüin Maleiwa, je na ayalajüshiikana. Nujuittirakalaka na wayuukana sümaa tü mürütkalüirua anooipa'amüin. Nujunnajakalaka nemeesain na a'wanajaaliikana neerü oo'ulaka neinase na oikkaaliikana wuchii toomasü. ");
INSERT INTO guc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Müshi Jesús sümüin tü wayuukolüirua: —Tü nünüiki Maleiwa ashajuushikat paala sümaiwa, müsü mayaa: “Tü tepiakat, nachuntiajatü na tapüshikana tamüin”, müshi. Otta jiakana, saa'u nnojolüin lotüin jukuaippa sünain jüikküin tü mürütkat, müsü aka saa'in shipia ka'ruwarannuu jütüma tü nipiakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Je wanaa sümaa eein Jesús sulu'u tü a'waajüleekat Maleiwa, antüsü nünainmüin wayuu eekai mo'uin oo'ulaka eekai masa'ain. Niiyajakalaka naya. ");
INSERT INTO guc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Otta na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana, jashichishii naya nümüin Jesús saaliijee tü kasa anasü naa'inrakat ne'rüin, je saaliijee tü sümakat tü tepichikalüirua sünain su'waajüin nia sulu'u tü a'waajüleekat Maleiwa sünain namüin: “Aleluya, wa'waajüin chi Nülüinkai David”. ");
INSERT INTO guc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nasakirakalaka Jesús: —¿Paapüin tü sümakat tü tepichikalüirua? —müshii nümüin. —Aa —nümakalaka Jesús namüin. —Nnojottaale sotüin jaa'in tü ashajünakat sulu'u tü nüchikimaajatkat Maleiwa makat mayaa: “Pi'itaain na tepichikana oo'ulaka na atujaayüliikana süpüla na'waajüin pia süka süpüshua naa'in”, makat —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Shiasa süchikijee tia, o'unüshi Jesús nama'anajee sünain nu'unüin sulu'ujee Jerusalén sulu'umüin tü pueulokat Betania süpüla nülatirüinjatüin aikat cha'aya. ");
INSERT INTO guc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Shiasa mapa watta'a maalü, sünain nüle'ejüin Jesús nüchikua namaa na nikirajüinkana Jerusalénmüin, ouktakalaka nia jamü wopulu'u. ");
INSERT INTO guc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ni'rapa wane wunu'u kanüliasü “higuera” sotpa'a tü wopukot, nürütkaakalaka sünainmüin. Machonkalaka shia nüpüla, ee'eraaka ne'e süpana. —Maleeirüma'alee pia machoin —nümakalaka sümüin tü wunu'ukot. Ajulujaa müsia tü wunu'ukot sütüma nünüiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Je na nikirajüinkana, patatsü ma'i naa'in ne'rapa tü alatakat. Nasakirakalaka Jesús: —¿Kasa sujulujaamaataka atüma tü wunu'ukat? ");
INSERT INTO guc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nüsouktakalaka Jesús namüin: —Shiimüin tü tamakat jümüin: Müleka kanourale jia sümaa nnojolüin wainmajüin jaa'in sünain anoujaa, juunteerü jaa'inrüin tü taa'inrakat sümüin tü wunu'ukot. Oo'ulaka müleka jümataarüle sümüin wane uuchi, “Anakaja pu'unüle yaajee shirokumüin tü palaakat”, sünoujeerü jünüiki. ");
INSERT INTO guc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamüshii paala jia: Wanaa sümaa juchuntüin nümüin Maleiwa, müleka jünoujüle sünain naa'inrüinjatüin tü jüchuntakat, shiimüin sünain naa'inreerüin —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nikerotakalaka Jesús sulu'umüin tü a'waajüleekat Maleiwa. Je wanaa sümaa nikirajüin tü wayuukolüirua yala, arütkaashii nünainmüin na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na laülaashiikana naa'u na judíokana, sünain namüin nümüin: —¿Jara koonoloka pia süpüla pujuittirüin anooipa'amüin tü wayuu oikkaatkalüirua? ¿Jarai ke'inaajalaka pia süpüla paa'inrüin shia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nüsouktakalaka Jesús ne'ipajee: —Tasakirüin paala jia'aya. Müleka jüsouktüle tamüin, taküjeerü jümüin kasain ootüin taya süpüla tojuittirüinjatüin anooipa'amüin tü wayuu oikkaatkalüirua. ");
INSERT INTO guc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Jara ke'inaajalaka Juan sünain owoutisaajaa? ¿Shi'inaajala wayuu, niataapa Maleiwa? —nümakalaka Jesús namüin. Naashajaajiraakalaka namüiwa: “Müleka ‘Nia Maleiwa’ wamüle, ‘¿Jamakalaka nnojoliika'a jünoujain nünüiki?’, meechi nia wamüin. ");
INSERT INTO guc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Oo'ulaka mojushiisü süpüla ‘Wayuu’ wamüinjanain süka nünüikimaajachin nia Maleiwa saajüin tü wayuukolüirua. Mojushiijeerü namüin”, majiraashii naya nujuuna Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nasouktakalaka joo nümüin Jesús: —Nnojoishi watüjaain aa'u jaralin ke'inaajalain. Nümakalaka joo Jesús namüin: —Nnojoluja'a süpüla taküjüin jümüin jaralin ke'inaajalain taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ayatüshi Jesús sünain naashajaain namaa na laülaayuu judíokana cha'aya sulu'u tü a'waajüleekat. Müshi nia namüin: “Jülüja jaa'in tü taküjainjatkat joolu'u jümüin. Eetaashi wane wayuu, kachonshi piamashii tooloyuu. Arütkaashi nia nünainmüin chi emülieekai sünain nümüin nümüin: ‘Tachee, anakaja müleka pu'unüle pi'yataaiwa so'uka'i sulu'u tü ta'apainsekat’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Nnojo, nnojoleechi taya a'yataain sulu'u tü pa'apainsekat’ nümakalaka chi emülieekai nümüin chi nüshikai. Otta müshia süchikijee, ee'iranajaasü naa'in je nu'unakalaka ni'yataain. ");
INSERT INTO guc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Arütkaashi chi nashikai nünainmüin chi epayaakai sünain nümüin nümüin: ‘Tachee, anakaja müleka pu'unüle pi'yataaiwa so'uka'i sulu'u tü ta'apainsekat’, nümakalaka nümü'inya. ‘Meerüja'a’, nümakalaka chi epayaakai nümüin chi nüshikai. Otta mo'unüinkalaka nia, nnojotsü nikeraajüin tü nümakat paala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nüsakirakalaka joolu'u Jesús na laülaayuu judíokana sünain nümüin namüin: —Nanainjee na piamashiikana achonlu, ¿jarai oonooka sümaa nünüiki chi nashikai? —Chi emülieekai —namakalaka nümüin Jesús. Nümakalaka Jesús namüin: —Shiimüin tü tamakat jümüin: Na okotchajüliikana neerü nümüin chi sülaülashikai mma oo'ulaka tü wayuuirua maa'insatkat, nayeena ekerolaka cha'aya eemüinre nuluwataain Maleiwa. Otta jiakana, iseerü jüchiki ekerotaa. ");
INSERT INTO guc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Süka jamüin, antüshi paala Juan chi owoutisaajüikai jünainmüin sünain nii'iyatüin jümüin jamüinjatüin jukuaippa süpüla jaa'inrüin tü nüchekakat chi Maleiwakai jüpüleerua. Otta jiakana, nnojotsü jünoujain tü nümakat jümüin. Akaajasa na okotchajüliikana neerü oo'ulaka tü wayuuirua maa'insatkat, nanoujüin tü nümakat. Je mayaainje ji'rüin naya sünain anoujaa, nnojotsü jiyaawaje'erüin jaa'in, shia eeka ne'e masütaajuin jia sünain jiyouktüin tü nümakat Juan —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ayatshi Jesús sünain naashajaain namaa na laülaayuu judíokana sünain nümüin namüin: “Jaapa tanüiki süpüla tekirajüinjanain jia süka sukuaippa tü kasa e'nnakat sainküin mma: Eetaalashi wane wayuu kama'anashi wane mma. Nükulaalajakalaka shia süpüla apünajünaa tü wunu'u kachonkat uuwa sulu'u. Je yaa sulu'u tü na'apainsekat, nükumajakalaka wane ishi süpüla ocho'ulajia süchon tü nüpünajüinkat süpüla wiinoinjatüin shia. Otta nükumajüin wane türoojo süpüla e'rajia saa'u tü na'apainsekat. “Saa'u nu'unajachin wattamüin, naa'inmajirakalaka wane wayuuirua tü nüpünajüinkat. ");
INSERT INTO guc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Je kettaapa süka'iya tü a'ttieekat süpüla sütpajünüin, nüjütüin na nüchepchia nanainmüin na aa'inmajüliikana sünain maa namüin: ‘Anakaja juluwataale tamüin süpüshi süchon tü ta'ttia jükotchajalakat, tü tamüinjatkat jütüma saa'u takoroloin shia’. ");
INSERT INTO guc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Otta na nüchepchiakana, ata'ünnüshii natüma na aa'inmajüliikana. Nashe'ejüin wane. No'uta aa'inchi wane. Je chi wane, na'ina'alüin süka ipa. ");
INSERT INTO guc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Shiasa süchikijee tia, nüjütakalaka joo wane nüchepchiairuaya kojuya noulia na palajanakana nanainmüin na aa'inmajüliikana. Mataaja'a naa atüma'aya. ");
INSERT INTO guc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Shiasa mapa ma'i, nüjütüinja'a chi nüchonkai nanainmüin na aa'inmajüliikana sünain nümüin, ‘Nieechi kojutka chi tachonkai natüma’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nayasa na aa'inmajüliikana ne'raiwa'aya chi nüchonkai nüpanapa, aashajaajiraashii naya: ‘Iseeichi chi apaaneechikai amüin tü apainkat. Joo'uya wo'utaiwa naa'in süpüla wayainjanain makatüin apüla shia’, müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nayu'tkalaka joo nia anooipa'amüin je no'utakalaka naa'in. ");
INSERT INTO guc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tasakirüin paala jia: ¿Kaseerü naa'inraka chi ka'apainseshikai naka na aa'inmajüliikana?”, nümakalaka Jesús namüin na laülaayuu judíokana. ");
INSERT INTO guc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nasouktakalaka nümüin: —Nnojoleena nümüliajüin na aa'inmajülii e'rüliikana wayumüin. Nu'uteena aa'in naya. Je naa'inmajireerü tü nüpünajüinkat wayuu naata aapawalinjatkat nümüin waneepia tü süpüshikat süchon tü a'ttieekat sükotchajünajatkat o'u —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nümakalaka Jesús namüin: —Soto jaa'in tü ashajünakat paala sulu'u tü nüchikimaajatkat Maleiwa: “Tü ipa ayouktünakat natüma na akumajüliikana miichi, ekeraajüitpa sünain anain ma'i shia süpüla akumajia miichi. Chi e'itaakai tü ipakat, nia Maleiwa. Je patatsü ma'i waa'in süka we'rüin tü naa'inrakat”, makat. ");
INSERT INTO guc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tamüshii paala jia: Mayaashiije e'itaaushin jia paala sümaiwa süpüla eeinjanain jia nümaa Maleiwa eere nuluwataain, nuu'ule'ereena jia suulia tia. Nayeena e'itaanaka nütüma na eekai naa'inreerüin tü nuluwataakat anain. ");
INSERT INTO guc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Otta tayakai, taya'aya chi ipa jiyouktakai. Je sükajee tia, soto jaa'in wane kasa. Taya'aya chi Nüneekajalakai Maleiwa, je chi eekai niyouktüin taya, amülouijeechi”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Otta müshi'iya na laülaayuushiikana na'akajee na sacerdote judíokana je na fariseokana, naapapa tü nüküjaitpakat Jesús, nayaawata aa'u sünain nayain müin aka naa'in na aa'inmajülii e'rüliikana wayumüin sulu'u tü nüküjaitpakat achiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kee'ireesü ma'i naa'in nata'üleein Jesús, otta nnojoishi nata'ülüin süka mmolüin naya seema tü wayuu kamalainkat amüin nünüiki Jesús süka niain wane nünüikimaajachi Maleiwa saajüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ayatshi Jesús sünain naashajaain namaa na laülaayuu judíokana sünain nikirajüin naya süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia namüin: ");
INSERT INTO guc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in nukuaippa wane aluwataashi ekeraajakai wane ekawaa miyo'u shikiira ka'wayuusee nütüma wane nüchon. ");
INSERT INTO guc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nüjütakalaka na nüchepchiakana süpüla neenajüinjatüin wane wayuuirua sünainmüin tü mi'iraakat. Nayasa'a na eenajiruushikana napüshua, oo'ulaayaa müshii naya suulia antaa sünainmüin tü mi'iraakat. ");
INSERT INTO guc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Niasa chi aluwataashikai, nüjütakalaka nüchikua wane nüchepchiairuaya nanainmüin na eenajiruushikana süpüla namüinjatüin namüin: ‘Joo'uya jümaala, kettaaitpa tü eküütkat jüpüla. Shia o'utinnaka aa'in tü paa'a kaüsüsükat ma'i süpüla tü mi'iraakat. Anakaja müleka ju'unamaatüle chamüin nipialu'umüin chi aluwataashikai sünainmüin tü ekawaakat shikiirakat tü ka'wayuuseekat nütüma chi nüchonkai’. ");
INSERT INTO guc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Otta na eenajiruushikana napüshua, nnojotsü kapülain naa'in shia. No'unayaa namakalaka sünain na'yataain. Eeshii o'unakai sünain apünajaa, sünain ayalajaa je sünain oikkawaa. ");
INSERT INTO guc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Otta na waneeirua eenajiruushikana, ne'ra'ala amüinchii na achepchiee ajütüüshikana nanainmüin. Nata'ülakalaka naya süpüla no'utaa aa'in. ");
INSERT INTO guc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Niasa chi aluwataashikai, naashichijaakalaka ma'i. Nüjütakalaka na nüsurulaatsekana süpüla no'una'alüin naa'in na uwomuyuushiikana je süpüla na'ajüinjatüin tü miichikalüirua sulu'u tü pueulo kepiakat alu'u naya. ");
INSERT INTO guc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Nümakalaka chi aluwataashikai namüin na nüchepchiakana: ‘Kettaaitpa tü ekawaakat. Otta na eenajiruushikana tatüma, nnojoliija'a wayuuin anashii süpüla antaa sünainmüin tü mi'iraakat. ");
INSERT INTO guc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Anakaja müleka ju'unüle joolu'u chaa metkaaralu'upünaa süpüla shiain jeenajüin wayuu eekai eein ne'e sünainmüin tü ekawaakat’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","No'unakalaka na nüchepchiakana chaa metkaaralu'upünaa sünain nantirüin süpüshua wayuu eekat napüla sünainmüin tü mi'iraakat, wayuu eekai anamiain je eekai mojulaain. Wotokalaka nipia chi aluwataashikai süka süntüin wayuu watta saalin sünainmüin tü ekawaakat shikiirakat ka'wayuusee nütüma chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wanaa sümaa nekaain na wayuukana, antüshi chi aluwataashikai na'akamüin. Ni'rakalaka wane wayuu sulu'u ne'e wane nüshe'in nnojotsü süpülajatüin wane mi'iraa shikiira ka'wayuusee. ");
INSERT INTO guc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nümakalaka chi aluwataashikai nümüin: ‘Waa'iraa, ¿jamüshi yaaka'a pia sulu'u wane püshe'in nnojotkat süpülajatüin wane mi'iraa shikiira ka'wayuusee?’, nümakalaka. Otta chi wayuukai, ko'utüshi nia nuulia. ");
INSERT INTO guc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Nümakalaka joo chi aluwataashikai namüin na nüchepchiakana: ‘Jüüttaa jümaala nütüna oo'ulaka nüsa'a chira wayuukai. Jujuittira nia anooipa'amüin sa'akamüin tü piyuushikat eere shi'yalajüin ma'i wayuu waneepia sütüma tü müliaa shi'rakat’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Tamüshii paala jia: Eenakünüsü wayuu wainma nütüma Maleiwa chaa eemüinre nuluwataain. Otta na'aka na eenakünakana, eeshii wainma eekai nayouktüin antaa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Shiasa mapa tia, no'unakalaka na fariseokana nüma'anajee Jesús süpüla naashajaajiraain süchiki tü naa'inrüinjatkat nüka. Kee'ireesü naa'in nanteein sünain wane pütchi sa'aka tü nümakat Jesús süpüla süsalainjachin nia natüma. ");
INSERT INTO guc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Najütakalaka na fariseokana wane na nekirajüinkana nünainmüin Jesús oo'ulaka wane nümaajanakana Herodes chi sülaülashikai mma, sünain namüin nümüin Jesús: —Ekirajüikalee, watüjaa aa'uchi pia sünain shiimüin tü pümakat sünain ekirajaa tü nuluwataakat anain Maleiwa, je sünain matüjüin pia kachekalaa su'utku wayuu. ");
INSERT INTO guc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wasakiree amüinchi pia sünain wane kasa: ¿Anashiisü saa'in pümüin wawalaajüle tü neerü nümüinjatkat César chi joyotokai cha'aya Roma sünain aluwatawaa saa'u mmakat, nnojottaapa anain? ");
INSERT INTO guc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Otta müshia Jesús, süka niyaawatüin saa'u sünain naa'inreein kasa mojusü nümüin, nümakalaka namüin: —Jia piamakana o'upünaa, ¿jamüsü juu'ulakeeka'a taa'in süka pütchi shii'iree süsalainjachin taya jütüma? ");
INSERT INTO guc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Iche'era tamüin wane neerü kachueera awalaajiapü'ükat nümüin chi sülaülashikai mma, te'raiwa shia —nümakalaka Jesús namüin. Nasaajakalaka tü neetkat nümüin. ");
INSERT INTO guc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nüsakirakalaka naya Jesús: —¿Jara kayaakuaka tü sünainkat? ¿Jara kanüliamaajachika shian? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Shia niyaakua oo'ulaka nünülia César tü sünainkat —namakalaka nümüin. Asouktüshi Jesús: —Tamüshii paala jia: Anakaja müleka jaa'inrüle tü nuluwataakat anain César otta jaa'inrüinjatü tü nuluwataakat anain Maleiwaya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ponokalaka ma'i naa'in nayakana tü nüsouktiakat Jesús. No'unakalaka nüma'anajee sükajee tia. ");
INSERT INTO guc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Antüsü so'u ka'ikat tia nünainmüin Jesús süpüla süsakirayaainjachin nia wane wayuuirua judío kanüliasü “saduceo” münüin. Nnojoleerü oso'irawaa aa'inyüü süchikijee ouktaa müsü tü shikirajapü'ükat anain tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Namakalaka joo nümüin Jesús: —Ekirajüikalee, müsü nünüiki Moisés wamüin sulu'u tü ashajünakat paala: “Müleka ouktüle wane wayuu sümaa machoin nia, anashi müleka niisarüle chi nimüliakai nüchukumüin süpüla kachooinjatüin tü jietkat nütüma”, müsü. ");
INSERT INTO guc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eetaashiija'a akaratshishii wayuu pawalaawashii. Ka'wayuuseshi chi epayaakai sümaa ouktüin nia machoinwa'aya sümüin tü nu'wayuusekat. Niisatkalaka chi nimüliakai sümüin tü jietkat. ");
INSERT INTO guc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ouktataashija chii'iya nnojoiwa'aya kachoin sümüin tü jietkat. Eisattaaja'a joo wane'eya nüchukumüin. Mataaja'a aka nakuaippa napüshua na akaratshishiikana awalayuwaa. Ouktüshii naya sünain machoin sümüin tü jietkat natüma. ");
INSERT INTO guc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Je oo'uwo'utpa na su'wayuusekana napüshua, ouktüsü mapa shia nachiiruajee. ");
INSERT INTO guc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Su'wayuuseshii napüshua na akaratshishiikana kataiwa'aya so'u. Wasakiree amüinchi joo pia soo'opünaa tia: So'u tü ka'ikat suso'iraainjateetkat o'u saa'in wayuu paajüin, ¿jaraleechi ka'wayuuseka tü wayuu ouktama'akat? —namakalaka na saduceokana nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nüsouktakalaka Jesús namüin: —Nnojotsü jiyaawatüin saa'u tü ashajuushikat sulu'u tü nüchikimaajatkat Maleiwa. Je nnojotsü jütüjaain naa'u Maleiwa sünain pülashaatain ma'i nia. “Nnojoleerü oso'irawaa aa'inyüü süchikijee ouktaa”, jümakalaka ne'e. Sükajee tia, nnojotsü lotüin tü jünoujakat. ");
INSERT INTO guc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Suso'iraapa saa'in wayuu süchikijee ouktaa, nnojoleerü pa'wayuuseewain, süka meenain aka naya saa'in nakuaippa na aapieekana chakana nüma'ana Maleiwa sümaa ma'wayuusein naya. ");
INSERT INTO guc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jia manoujainsaliikana sünain suso'iraainjatüin saa'in wayuu, soto jaa'in tü nümakat chi Maleiwakai namüin na jutuushinuukana ashajünakat paala sünain maa: ");
INSERT INTO guc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Tayakai, Nümaleiwasekai Abraham, Nümaleiwasekai Isaac, Nümaleiwasekai Jacob”, müshi. Tamüshii paala jia: Chi Maleiwakai, nnojoishi Sümaleiwasein wayuu ouktüsü. Sümaleiwase eekai katüin so'u —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Je kettaapa nünüiki Jesús, ponusü ma'i saa'in tü wayuu wattakat saalin tü nikirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Otta na fariseokana, naapapa süchiki tü saduceokalüirua sünain yüütüin shia nütüma Jesús, nakotchajaakalaka nünainmüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Je na'aka na fariseokana, eeshi wane wayuu karalouktamaajachi. Süka kee'ireein ma'i naa'in nünteein sünain wane pütchi sa'aka tü nümakat Jesús süpüla süsalainjachin nia natüma, nüsakirayaain Jesús sünain wane kasa sünain nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ekirajüikalee, ¿jarat alana'aleeka sünain anain sa'akajee süpüshua tü nuluwataakat anain waya Moisés? —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nüsouktakalaka Jesús nümüin: —Maleiwa, chi Pümaleiwasekai, anashi aire püpüla waneepia süka süpüshua paa'in. Anashi jülüjüle paa'in Maleiwa waneepia. ");
INSERT INTO guc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Alana'aleesia ma'i tüü sa'akajee süpüshua tü nuluwataakat anain jia Moisés. ");
INSERT INTO guc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Je eesü wane'eya alana'aleesia ma'i sünain anain, müsü mayaa: Anasü aire püpüla wayuu süpüshua maa aka alin pia püpülajiraa. ");
INSERT INTO guc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tü piamasükat, shia saa'inka süpüshuale'eya tü nuluwataakat anain Moisés je süpüshuale'eya tü nekirajapü'ükat anain na nünüikimaajanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sünain eein na fariseokana jutkatüin nü'ütpa'a Jesús, nüsakirakalaka naya: ");
INSERT INTO guc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Jarai chi Cristokai anülia saa'in jümüin? ¿Jarai koo'uliwo'uka nia? —nümakalaka namüin. —Nia koo'uliwo'uka David —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","45","Nümakalaka Jesús namüin: —Soto jaa'in nünüiki David, tü nümakat paala nütüma chi Naa'inkai Maleiwa sünain maa: “Müshi chi Maleiwakai nümüin chi Tasenyotsekai: ‘Kojutshaatashi pia tatüma. Püikkalaa puluwataaiwa tekialu'ujee. So'u wane ka'i, tayamüleerü tü pü'ünüükalüirua süpüla malainjatüin shiairua püpüla’ ”. “Tasenyotsekai” nümüleje'e David nümüin Cristo, ¿jamakuaippalinjachi nuu'uliwo'ulaaka'a ne'e nia? —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Otta na fariseokana, isasü nachiki asouktaa ni'ipajee Jesús. Je süchikijeere'eya ka'ikat tia, noo'ulaaichipa suulia nasakirayaain. ");
INSERT INTO guc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Shiasa süchikijee tia, nümakalaka Jesús sümüin tü wayuu wattakat saalin oo'ulaka namüin na nikirajüinkana: ");
INSERT INTO guc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na karalouktamaajanakana oo'ulaka na fariseokana, naya laülaashiika süpüla ekirajaa wayuu sünain tü nüshajakat Moisés. ");
INSERT INTO guc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Je sükajee tia, anakaja müleka joonoole sümaa süpüshua tü naluwataakat anain. Akatsa nnojolüin jüshateein nakuaippa, süka wayuuin ne'e naya piama o'upünaachii saa'u nnojolüin naa'inrüin tü nuluwataakat anain Moisés. ");
INSERT INTO guc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Naluwataain tü wayuukolüirua sünain aa'inraa kasa kapüleesü sümaa nnojoliin eeyaain nakaalinjüin shia. ");
INSERT INTO guc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tü kasa naa'inrakat, naa'inrüin ne'e süpüla ne'nnüin sütüma wayuu je süpüla ne'nnaajünüin sünain keisalain nakuaippa nu'upala Maleiwa. Miyo'u ma'i sot nashe'in je miyo'u ma'i tü kasa e'itaanakat natüma ne'ipolu'u je sünain natüna kalu'ukot wane pütchi nüchikimaajatkat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yaletayaasü naa'in su'upala wayuu. Keejiasü namüin joyotoo sulu'u neinase na jülaülayuukana sünain wane ekawaa je sulu'u tü ekirajüleekat, ");
INSERT INTO guc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","je kojuteeshi naya sütüma wayuu chaa metkaaralu'u sümaa ‘Ekirajüikalee’ namüneein nasakünapa. ");
INSERT INTO guc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Otta jiakana, süka waneeshin ne'e chi Jüsenyotsekai, anakaja müleka nnojorule kee'ireein jaa'in ‘Laülaashikalee’ jümüneein. Pawalaawashii jia jüpüshua, nnojotsü jaralüin alata'atalüin ajut. ");
INSERT INTO guc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Je anakaja müleka nnojorule ‘Taataa’ jümüin sümüin wayuu yaa saa'u mmakat, süka jamüin, waneeshin ne'e chi Jüshikai chakai iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Je anakaja müleka nnojorule jücheküin ‘Ekirajüikalee’ jümünüin, süka jamüin, waneeshin ne'e chi Ekirajüikai jia, tayakai chi Cristo Nüneekajalakai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chi wayuu eekai nücheküin süpüleerua laülaain ja'aka, acheküshi ni'yataain jümaa jüpüshua. ");
INSERT INTO guc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chi eekai yaletayaain nukuaippa su'upala wayuu, nnojoleechi kasajachin nümüin Maleiwa. Alu'usa chi eekai nnojolüin yaletayaain naa'in, kojuteechi nütüma. ");
INSERT INTO guc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Jiakana karalouktamaajanakana oo'ulaka na fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain junujulüin suulia wayuu tü nikirajakat anain Maleiwa süpüla shikerolüin nünainmüin eere nuluwataain. Nnojotsü joonooin amaa nünüiki Maleiwa je jutuunajüin nakuaippa na eekana naa'inreein tü nuluwataakat anain. ");
INSERT INTO guc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain ji'ike'erüin wayuu eekai ouktüin su'wayuuse shii'iree jaapaweein sükorolo. Je süchikijee, kama'ashii jia sünain jüchuntayaain nümüin Maleiwa su'upala wayuu shii'iree kojuteein jia sütüma. Alana'aleejeeria ma'i sünain süsalain jia nütüma Maleiwa saaliijee tia. ");
INSERT INTO guc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat. O'unüshii jia sainküinpünaa mmakat süpüshua süpüla jime'ejüin saa'in wayuu wainma shii'iree süshatüin sukuaippa tü jünoulakat. Je chi eekai nüshatüin jukuaippa, alana'aleeshia sünain süsaleechin nia juulia chamüin Hadesmüin süpüleekat tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Jia e'itaaushikana jaashin süpüla jii'iyatüinjatüin tü wopukot sümüin wayuu eekai mo'uin sünain mo'uinya ne'e jia, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat, makana sünain ekirajaa: ‘Müleka pansaale jünüiki sulu'u sünülia tü a'waajüleekat Maleiwa sünain jaa'inrüinjatüin wane kasa, nnojoleerü anoujünüin jümüin. Otta müleka pansaale jünüiki sulu'u sünülia tü ooro sulu'ukot tü a'waajüleekat Maleiwa, anoujüneerü jümüin’, müshii jia. ");
INSERT INTO guc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jia maa'inkana aa'in, jia mo'usaliikana, ¿jamüshii nnojoliika'a jiyaawatüin saa'u sünain shiain alana'aleein ma'i tü a'waajüleekat Maleiwa suulia tü ooro sulu'ukot? Tü oorokot, kojutsü nümüin Maleiwa süka sulu'uin ne'e shia tü a'waajüleekat. ");
INSERT INTO guc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Otta mataatshii joo jia'aya: ‘Müleka pansaale jünüiki sulu'u sünülia tü a'ajüleekat sulu'ukot tü a'waajüleekat Maleiwa sünain jaa'inrüinjatüin wane kasa, nnojoleerü anoujünüin jümüin. Otta müleka pansaale jünüiki sulu'u sünülia tü kasa aapünakat saa'u, anoujüneerü jümüin’, mapü'üshii jia. ");
INSERT INTO guc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jia mo'usaliikana, ¿jamüshii nnojoliika'a jiyaawatüin saa'u sünain shiain alana'aleein ma'i tü a'ajüleekat suulia tü aapünakat? Tü aapünakat, kojutsü nümüin Maleiwa süka saa'uin ne'e tü a'ajüleekat. ");
INSERT INTO guc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Je sükajee tia, chi eekai pansaain nünüiki sulu'u sünülia tü a'ajüleekat sünain naa'inrüinjatüin wane kasa, sulu'usia ne'e sünülia tü asülajünakat saa'u. ");
INSERT INTO guc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aka'aya chi eekai pansaain nünüiki sulu'u sünülia tü a'waajüleekat Maleiwa, sulu'usia ne'e nünülia chi kepiakai sulu'u. ");
INSERT INTO guc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Je chi eekai pansaain nünüiki sulu'u sünülia tü kasa chakat iipünaa, sulu'usia ne'e sünülia niinase Maleiwa oo'ulaka niakai chi joyotakai saa'u. Niainjachi kojutka jütüma nümüiwa. ");
INSERT INTO guc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sükajee kachekala'atain jia sümüin wayuu sümaa nnojolüin jümüliajüin eekai müliain, je sükajee nnojolüin jaa'inrüin tü jümakat nümüin Maleiwa. Nnojoishii jia ta'ülüjüin amüin saaliijee jüsülajüin süpüshi ji'yataain nümüin Maleiwa, süka shiain tü nuluwataakat anain Moisés. Nnojoishii jia ta'ülüjüin amüin saaliijee jüsülajüin süpüshi süpana wunu'u eekai ekünaajuulin. Shia sünainjee nnojolüin jaa'inrüin süka süpüshua jaa'in tü alana'aleekat sünain anain, maa aka alin Maleiwa jüpüla je jaa'inrüin tü anakat sümüin wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E'itaaushi jia jaashin süpüla jii'iyatüinjatüin tü wopukot sümüin wayuu eekai mo'uin sünain mo'uinya ne'e jia. Shiakalajasa kamaain ma'i jaa'in tü nnojotkat che'ojaain suuliale'eya tü che'ojaakat ma'i süpüla jaa'inrüin. ");
INSERT INTO guc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat. Jiakana keisalakana ma'i ne'e sümüin jiitain je jüpülaatse süpüla uleinjatüin shia, nnojotkalajasa jiisalajüin jaa'in süpüla uleinjatüin shia. Yarüttüsü ma'i, süka jülüjain jaa'in kasa mojulu'ut waneepia, maa aka kachiiruaa aa'in washirüü. ");
INSERT INTO guc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jia fariseo mo'usaliikana, juu'ulaa suulia yarüttüin jaa'in süpüla juuntüinjatüin jaa'inrüin tü nüchekakat Maleiwa jüpüleerua. ");
INSERT INTO guc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat. Maa aka tü amouyuukolüirua sünain anasüin ma'i shiyolojo süka kasuuin ma'i sütüma tü kaatkat, sünain wotüin ma'i shiimse wayuu je süpüshua kasa yarüttüsü, ");
INSERT INTO guc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","aka'aya jiakana piamakana o'upünaa: E'nnüshii jia sütüma wayuu sünain anamiain süka jaa'inrüin su'upala tü nüchekakat Maleiwa jaashin. Otta yaa sulu'u jaa'in, kee'ireesü jaa'in tü mojusükot. ");
INSERT INTO guc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Jiakana karalouktamaajanakana oo'ulaka fariseokana, jia piamakana o'upünaa, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain kojutuyaain jütüma na nünüikimaajanakana Maleiwa paala sümaiwa je na wayuukana eekai lotüin nakuaippa nu'upala Maleiwa. Jaainjirayaa atachii naya shii'iree ‘kojutuleeka ma'i naya natüma’ sümeein wayuu jümüin. ");
INSERT INTO guc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Je jaajüin jiakana, jiyouktüin tü naa'inrakat paala na jutuushinuukana sünain no'utirüin naa'in na nünüikimaajanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jiyaawata aa'ulu sünain noo'uliwo'uin jia na wayuu o'utakana naa'in na nünüikimaajanakana Maleiwa. Shiimüin sünain müinya aka jia naa'in na jutuushikanairua. ");
INSERT INTO guc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Acheküsü jaa'inrüinjatüin joolu'u taka tü kasa mojusü sulu'ukat jaa'in süpüla shikeraajüin jütüma tü kasa mojusü no'ttakat anain na jutuushikanairua. ");
INSERT INTO guc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Jiakana wüi ouktasiro'ut, e'rülii wayumüin jia. Shiimüin sünain süsaleenain jia nütüma Maleiwa. Nüjüteena jia sa'akamüin tü sikikat kanüliakat Hades eere süpülee tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ajüteechi taya jünainmüin wayuu jaapiainjatkat nünüiki Maleiwa, wayuu eekai kekiin, oo'ulaka wayuu ekirajülin. Eejeena eekai jükachereenain süpüla ouktaa. Eejeena eekai ji'yaateenain sulu'u tü ekirajüleekat. Eejeena eekai jülojüin nachiirua sulu'upünaa tü pueulokat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Otta tü kasa jaa'inreetkat naka na wayuukana tajütajanakana jünainmüin, kasalajaneerü jümüin maa'aya aka kasalajaneerüin namüin na jutuushinuukana tü kasa mojusü naa'inrakat namüin napüshuale'eya na wayuu lotokana akuaippa nu'upala Maleiwa o'utinnakana aa'in süchikijee sükumajünüin tü mmakat. O'ttüsü nüka Abel nünainmüinre'eya Zacarías chi nüchonkai Berequías, chi o'utünakai aa'in pasanain sünain tü a'ajüleekat sümaa tü a'waajüleekat. ");
INSERT INTO guc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jia wayuu katakana o'u maa'ulu yaa, shiimüin ma'i tü taküjaitpakat jümüin sünain kasalajaneerüin jümüin jaainjala, tü shikeraajiakat tü kasa mojusü no'ttakat anain na jutuushikanairua”, nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jülüjakalaka naa'in Jesús tü wayuukolüirua eekat sulu'u Jerusalén sünain nümüin mayaa: “Aituala ma'i jia wayuu Jerusalénje'ewaliikana, jia o'utakana naa'in süka ipa na nünüikimaajanakana Maleiwa aluwataaushikana jünainmüin. Kee'ireepü'üsü ma'i taa'in taa'inmajüin jia, maa aka saa'inmajüin süchon wane kaliina. Otta jiakana, jiyouktajaa amaalü tia. ");
INSERT INTO guc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sükajee tia, nnojoliinapa kasajanain jia nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Müshi taya joolu'u jümüin jia manoujainsaliikana tanain: Nnojoleechi taya ji'rüin tachikua wane'ere'eya jümaleepa tamüin, ‘Anata'aleeshija'a ma'i chi Nüjünalakai Maleiwa’ ”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nujuittakalaka Jesús sulu'ujee tü a'waajüleekat Maleiwa. Wanaa sümaa nu'unajachin yalajee, arütkaashii na nikirajüinkana nünainmüin sünain namüin nümüin: —Piirakaa sümüin tü miichikalüirua yaaya sulu'u süpaatiase tü a'waajüleekat Maleiwa. Anasü ma'i shiyolojo —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nümakalaka Jesús namüin: —¿Ponosü ma'i jaa'in tü a'waajüleekat? Shiimain tü tamakat jümüin: Süpüshua türa ipa ji'rakat joo müinma'a yaa, ojuttinneerü shia mmolu'umüin sünain süsolojüneerüin so'uweena wane ka'i —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Shiasa nantapa sünainmüin tü wutai kanüliakat Olivos, wanaa sümaa joyotüin Jesús cha'aya, arütkaashii na nikirajüinkana namüiwa nünainmüin süpüla nasakirüin nia: —¿Joujaleerü sujuttinnaka tü a'waajüleekat Maleiwa? —namakalaka nümüin. Nasakirakalaka nia nachikua: —¿Kasa shiyaawaseetka wamüin süpüla watüjaainjatüin saa'u sünain sülü'ülüin pükalia süpüla piweetüinjachin, tü sükaliajatkat saja'lajaain kasakat süpüshua? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Nümakalaka Jesús namüin na nikirajüinkana sümaa tü wayuukolüirua: “Anteerü wayuu wainma sünain maa: ‘Taya'aya Cristokai’, meena. Pülashii naya nütüma Maleiwa naashin. Jalia jia suulia anouja'alaa na'alain naya wayuukana maa aka sünoujeerüin wayuu wainma nanain. ");
INSERT INTO guc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ja'itaina jia aapüin süchiki kasachiki sainküin mmakat süpüshua, nnojo jainkuuin aa'in sütüma. Ja'itakaje tiairua, nnojotsü shiain shiyaawasein sünain süntüitpain tü ka'i saja'lajaainjatkat o'u kasakat süpüshua. Alatüinjatia ne'e kasa eekai müin aka tüü süpülapünaa süntüin ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Atkaajiraajeerü wayuu sainküin mmakat süpüshua. Mülieerü ma'i saa'in wayuu sütüma jamü je sütüma ayuulii sainküin mma. Je akutkujaweerü tü mmakat sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Je süpüshua tü müliaa shi'reetkat wayuu süpülapünaa teweetüin tayakai, meerü aka su'ttakai saalin jo'uu sümüin jieyuu. ");
INSERT INTO guc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ata'ünneena jia sütüma wayuu süpüla müliainjatüin ma'i jaa'in sütüma sümaa su'utireerüin jaa'in. Je saaliijee jünoujain tanain, maalinjeena jia süpüla wayuu sainküin mmakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Otta wayuu wainma, oo'ulaajeena suulia anoujaa tanain so'uweena ka'ikat tia. Ataüjiraweerü wayuu nanainmüin na laülaayuukana saa'u kanainjiraain saa'in. ");
INSERT INTO guc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Je so'uweena ka'ikat tia, eejeena wainma na nünüikimaajanayaakana Maleiwa ja'aka. Je anoujüneerü na'alain sütüma wayuu wainma. ");
INSERT INTO guc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Koo'omüinjeerü wayuu kaainjarat sainküin mmakat. Je sükajee tia, oo'ulaajeerü wayuu wainma suulia aijirawaa. ");
INSERT INTO guc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Otta chi eekai nüchecherüin naa'in su'unnaa tü müliaa ni'rakat, ayateechi o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Süpülapünaa süntüin tü ka'i saja'lajaainjatkat o'u kasakat süpüshua, aküjüneerü sümüin wayuu tü pütchi anasükat, tü süchikikat nukuaippa Maleiwa sünain aluwatawaa. Aküjüneerü sainküin mmakat süpüshua süpüla saapünüinjatüin sütüma wayuu süpüshua. Je kettaapa shia, anteerü sükalia saja'lajaainjatkat o'u tü kasakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ji'reerü sha'watüin yaa sulu'u tü a'waajüleekat Maleiwa tü kasa kashüülasü nülerajüinjatkat anainjee Maleiwa tü a'waajüleekat, tü ashajünakat achiki paala nütüma Daniel chi nünüikimaajachikai Maleiwa. (Jia aashaje'erakana tü tashajakat, anakaja jiyaawatüle saa'u.) ");
INSERT INTO guc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Je so'uweena ka'ikat tia, na wayuu kepiakana sulu'u tü mmakat Judea, anakaja müleka na'luwataale sa'akamüin tü uuchikat süpüla nanujulaainjanain cha'aya. ");
INSERT INTO guc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chi wayuu joyotokoi sheemioushi tü nipiakat so'u ka'ikat tia, nnojoi nikerolüin paülü'ümüin süpüla nükotchajaain nükorolo. ");
INSERT INTO guc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Otta chi wayuu eekai ni'yataain sulu'u niyüüjase, anakaja nnojoire nüle'ejüin nipialu'umüin süpüla a'wanajawaa nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","‘Aisha'ajaa’ meerü tü wayuu eekai ipoolüin je eekai sütulayülüinya süchon so'u ka'ikat tia, süka kapüleejeerüin ma'i süpüleerua awatawaa. ");
INSERT INTO guc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jüchunta nümüin Maleiwa süpüla nnojolüinjatüin sülatüin jümüin tüü juyapü je so'u sükalia eemerawaa. ");
INSERT INTO guc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","So'uweena ka'ikat tia, alana'aleejeeria ma'i tü müliaa shi'reetkat wayuu suulia tü shi'rakat wayuu paala sümaiwa süchikijee sükumajünüin tü mmakat je suulia tü shi'rakat wayuu maa'ulu yaa. Nnojoleerü wane müliaa eekai müin aka saa'in tia mapeena. ");
INSERT INTO guc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Müleka nnojoruleje saawalaain tü müliaakat, aja'lajaweerü wayuu süpüshua sütüma. Akatsa naawale'ereerüin shia Maleiwa naa'ujee na aneekuushikana nütüma. ");
INSERT INTO guc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Je so'uweena ka'ikat tia, müleka jümünüle ‘Jiirakaa, ichaa Cristo chi Nüneekajalakai Maleiwa cha'aya’ je ‘Jiirakaa, anii nia yaaya’, müleka jümünüle, nnojo joonooin sümaa tia. ");
INSERT INTO guc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Je so'uweena ka'ikalüirua tia, eweeteechi wayuu eekai ‘Taya Cristoka’ nümeechin, je eekai ‘Taya wane nünüikimaajachikai Maleiwa’ nümeechin. Alaayuu ne'e nayairua. Pülashiijeena naya sünain naa'inreerüin tü kasa eekai müin aka saa'in tü nütüjakat apüleerua Maleiwa nümüiwa shii'iree nanoujüneein anain sütüma wayuu süpüshua, ja'itashii nnojoliin anoujünüin anain natüma na nüneekajalakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Taküjüin jümüin süchiki tü alateetkat nnojolüiwa'aya sülatüin süpüla yapainjanain jia süpüla. ");
INSERT INTO guc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Müleka jümünüle ‘Iraa Cristo chi Nüneekajalakai Maleiwa, ichaa cha'aya isashiipa'a’, nnojo ju'unüin shi'ipajee tia sünain jüchajaain tachiki. Je müleka jümünüle ‘Iraa paülü'ü’, nnojo jünoujain tia. ");
INSERT INTO guc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Süka jamüin, maa aka tü shiyaakat juya shi'rakat wayuu süpüshua amachetaain chaa sirumatu'upünaa, akaweechia tayakai, chi Shipayakai Wayuu, tale'ejapa, shi'reechi wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Müleka ji'rüle wane samulüirua, jütüjaa aa'ut sünain eein wane mürüt ouktüsü. ");
INSERT INTO guc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“So'uweena ka'ikat tia, süchikijee sükalia tü müliaakat, ‘Epiyuushijaajeechi chi ka'ikai, je oyokujaweechi chi kashikai, je ojunuwaajeerü tü jolotsükolüirua iipünaajee. Alanaajaweerü süpüshua'aya tü kasa chakat iipünaa’. ");
INSERT INTO guc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Je wanaa ma'i sümaa tia, e'nneerü chaa sirumatu'u wane kasa atüjaaneetkat atüma saa'u sünain tantamaateechin tayakai chi Shipayakai Wayuu. Je tü wayuukolüirua sainküin mmakat süpüshua eekai nnojolüin sa'atapajüin taya, a'waateena naya süka mmolüin naya teema. Je shi'reechi taya wayuu, tayakai, chi Shipayakai Wayuu, sünain antaa sa'aka tü sirumakat. Anashaateerü ma'i tü tantiakat, süka tanteechin sünain pülashin je sünain e'itaaushin nütüma Maleiwa süpüla aluwatawaa wanaa nümaa. ");
INSERT INTO guc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eweeteerü wane shipijana jontoroyoi emetuluinjatü ma'i. Je ajütüneena na aapiee nüma'anajeejanakana Maleiwa süpüla nakotchajüinjatüin tü wayuu aneekuushikalüirua nütüma sainküinjee tü mmakat süpüshua'ale. ");
INSERT INTO guc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Soto jaa'in sukuaippa tü wunu'u ‘higuera’ münakat. Wanaa sümaa iyotüin süpana tü wunu'ukot, jütüjaa aa'ulu sünain sülü'ülüin süpüla sü'itüin iiwa. ");
INSERT INTO guc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aka'aya ji'rapeena tü taküjaitpakat achiki jümüin, jütüjaweerü aa'u sünain sülü'ülüin ma'i takalia süpüla antaa. ");
INSERT INTO guc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Shiimüin ma'i tü tamakat jümüin, alateerü tüü süpülapünaa shi'rüin ouktaa tü wayuu eekat maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Taso'iree aa'inchii jia joolu'u sünain wane kasa: Mayaainje saja'tteerüin tü kasakat cha'aya iipünaa oo'ulaka yaa mmolu'u so'uweena wane ka'i, tü pütchi tekirajapü'ükat anain jia, ayateerü süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nnojotsü sütüjaain aa'u wayuu joujaleerüin sülatüin tü taküjaitpakat achiki jümüin. Ja'itakaje na aapiee chakana iipünaa, nnojotsü natüjaain aa'u. Nia ne'e chi Tashikai Maleiwa atüjaaka saa'u nümüiwa. ");
INSERT INTO guc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Soto jaa'in nüchiki Noé. Tü wayuukolüirua nnojoliiwa'aya no'otooin Noé sulu'umüin tü anuakat, ee'eraashii ne'e naya sünain nnojolüin jülüjain naa'in tü naainjalakat. Nnojotsü natüjaain aa'u tü kasa alatajatkat namüin. Je mapa no'otoopa Noé sulu'umüin tü anuakat, a'itüsü tü juyakat sünain miyo'uin ma'i shia süpüla ouktajatüin tü wayuukolüirua süpüshua'ale eekai nnojolüin nümaain Noé sulu'u tü anuakat. Akaweeria takalio'u tayakai, chi Shipayakai Wayuu, wanaa sümaa tanteechin tachikua. ");
INSERT INTO guc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Eejeena piamashii wayuu sünain a'yatawaa sulu'u nayüüjase. Tamaweechi wane. Oo'ulaka wane, tapüteechi. ");
INSERT INTO guc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Eejeena piamashii jieyuu sünain amoliinajaa. Tamaweerü wane. Oo'ulaka wane, tapüteerü. ");
INSERT INTO guc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Je sükajee tia, anakaja müleka eere jaa'in tapüla tayakai, chi Jüsenyotsekai, süka tale'ejüinjachin tachikua jünainmüin so'uweena wane ka'i matüjaajuukat aa'u jütüma. ");
INSERT INTO guc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Soto jaa'in wane kasa. Wane wayuu nipiajachi, müleka nütüjaaleje saa'u tü ka'i nüntajaikai o'u wane ka'ruwarai, nnojoireeja süpüla nutunküinjachin suulia nikerolüin chi ka'ruwaraikai. ");
INSERT INTO guc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Müinjanaya jiakana, anashii müleka keraajüle jia sümaa eein jaa'in tapüla tayakai, chi Shipayakai Wayuu, süka tale'ejüinjachin tachikua jünainmüin so'uweena wane ka'i matüjaajuukat aa'u jütüma”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nikirajakalaka Jesús joolu'u süka sukuaippa tü kasa e'nnakat sainküin mma sünain jamüinjatüin nukuaippa nüntapeena sünain nümüin: “¿Jameechi wane achepchiee eekai kekiin ma'i sünain tütüin ma'i sünain tü aluwataanakat anain nia? E'itaaneechi nia sünain nekiipü'üin na waneeirua süpüla ekiraa naya. ");
INSERT INTO guc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Je nüle'ejapa chi nülaamainkai, talateerü ma'i naa'in nümaa müleka ayatüle naa'inrüin süpüshua tü ni'itaakat nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Shiimüin tü tamakat jümüin, e'itaaneechi nia nütüma chi nülaamainkai süpüla laülaain saa'u süpüshua'ale tü kasa eekat nüma'ana. ");
INSERT INTO guc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“¿Jama müleka nnojorule jüüjüüin nia sümüin nünüiki chi nülaamainkai, müleka ‘Nnojoleechi antamaatüin chi talaamainkai nüchikua’ nümataarüle ne'e ");
INSERT INTO guc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sünain emi'ijawaa oo'ulaka sünain eperuwawaa je sünain ni'yaajüin na achepchieekana wanaa nümaa? ");
INSERT INTO guc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Antalaa meechia chi nülaamainkai so'u wane ka'i nnojotkat na'atapüin o'u nia. ");
INSERT INTO guc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Süsala meechia nia nütüma. Ni'ikajaajeechi nia na'akamüin na anoujayaashiikana nünüiki Maleiwa eere ne'rüin müliaa napüshua”, nümakalaka namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ayatshi Jesús aashajaain namaa na nikirajüinkana je tü wayuukolüirua sünain nümüin namüin: “¿Jameerü wayuu so'uweena tü ka'i tanteetkat o'u tachikua süpüla taluwataain saa'u? Meerü aka saa'in nakuaippa wane polooshii majayünnüü e'rajaashii wane mi'iraa shikiira ka'wayuusee. No'unakalaka shipialu'umüin tü wayuu jeketüjatkat ka'wayuusein süpüla na'atapajüinjachin chi wayuu su'wayuuseinjachikai. Alü'üjashii naya naramparase wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Kekiishii ma'i ja'raishii nanainjee na majayünnüükana, nnojotsü motüin naa'in nalü'üjüin wane'ewai nakua seite süpüla shii'irakainjatü sulu'u tü naramparasekat müleka saja'lajaale. Otta na wane ja'raishiikana majayünnüü, süka maa'in naa'in, motüsü naa'in nalü'üjüin seite süpüla shii'irakainjatü sulu'u tü naramparasekat. ");
INSERT INTO guc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Niasa chi jekechijachikai ka'wayuusein, koulainkalaka nia sünain antaa. Je süka nnojolüin nüntamaatüin, natunkeekalaka na majayünnüükana napüshua. Atunka müshi'iya naya. ");
INSERT INTO guc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Je süse'eru'upünaa aikat, su'waatakalaka wane wayuu sünain maa: ‘Anii antüin chi ka'wayuuseinjachikai. Jalaina nüpanapa’. ");
INSERT INTO guc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Achijiraa müshi'iya napüshua na majayünnüü polooshiikana sünain yapainjatüin natüma tü naramparasekat süpüla napanapüin nia anooipa'a. ");
INSERT INTO guc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Otta na majayünnüü motokana aa'in seita, namakalaka namüin na eekana ama'ana: ‘Ayokujaweematüirü tü waramparasekalüirua süka yootchoin seita sulu'u. Anasü jüsülajüle wamüin süpüshi tü seita jüma'anakat’. ");
INSERT INTO guc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nasouktakalaka na majayünnüü kama'anakana seita sünain namüin namüin: ‘Nnojo. Müleka wasülajüle seita jümüin, eesü süpüla nnojoleerüin wama'ana süpüla tü waramparasekalüirua müleka saja'lajaamaatüle sulu'u. Shia anaka alu'u müleka ju'unüle süma'anamüin wane wayuu eekai suikküin’. ");
INSERT INTO guc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Shiasa nachikiru'u sünain achajawaa seita, antüshi chi ka'wayuuseinjachikai miichipa'amüin. Na majayünnüü apanapakana nia, ekerotshii joolu'u nümaa sulu'umüin tü miichikat sünainmüin tü ekawaakat. Je nekerolapa, süsürünnakalaka so'u tü miichikat. ");
INSERT INTO guc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Shiasa süchikijee tia, nantakalaka na wane majayünnüükana so'ulu'umüin tü miichikat sünain namüin nümüin chi jekechikai ka'wayuusein: ‘Tepayachee, pujutala wapüleerua’, namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Otta nümakalaka namüin: ‘Shiimüin tü tamakat jümüin sünain nnojoliinapain jamajanain jia tamüin’, nümakalaka chi jekechikai ka'wayuusein yaa paülü'üjee.” ");
INSERT INTO guc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Müshi joo Jesús: “Tamüshii jia jüchikua: Anakaja müleka yapale jia sünain eein jaa'in tapüla tayakai, süka tale'ejüinjachin tachikua jünainmüin so'uweena wane ka'i matüjaajuukat aa'u jütüma”. ");
INSERT INTO guc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nümakalaka joo Jesús nüchikua namüin: “¿Jameerü wayuu so'uweena tü ka'i tanteetkat o'u tachikua süpüla aluwatawaa saa'u? Meerü aka saa'in nakuaippa wane achepchiee a'yataashii nümüin wane wayuu washirü. O'unajachi nia süpüla kakaliaa sulu'umüin wane mma wattasü. Otta nüma'ichiki, neenajakalaka na nüchepchiakana nünainmüin süpüla ni'itaainjatüin najapulu'u tü nuwashirüinkat süma'inru'u nüle'ejüin, sünain nümüin namüin: ‘Süma'inru'u nnojolin taya jümaa, anuu taapüin jümüin tüü süpüla jiyalajüin kasa süka, jüikkaiwa shia, kachoinwa tü neetkat jütüma’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ni'itaain najapulu'u wane, ja'rai wo'ot neerü. Je najapulu'u wane, ni'itaain piama wo'ot. Oo'ulaka chi wane'e, wane wo'ot. O'unüsü nütüma süchiirua tü nountakat na nüchepchiakana. Je süchikijee tia, nu'unakalaka chamüin ee'ewaire nia. ");
INSERT INTO guc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Shiasa nüchikiru'u, chi nüchepchia ni'itaakai ajapulu'u jarai wo'ot neerü, o'ttüshi yaawalaja'a sünain ayalajaa kasa süpüla nuikkaain. Kachonkalaka tü neetkat nütüma, ja'rai wo'ot, maa'aya aka tü aapünakat paala nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Akaajaa chi naapakai amüin piama wo'ot, kachonsü nütüma piama wo'ot. ");
INSERT INTO guc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Otta müshia chi naapakai amüin wane wo'ot paala, nüpotüin wane ishi süpüla nunujulüinjatüin tü neetkat sulu'u. ");
INSERT INTO guc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Shiasa mapa kakalia süchikijee, nüle'ejakalaka chi washitshikai nipialu'umüin süpüla nütüjaainjatüin saa'u sukuaippa tü neerü ni'itaakat paala najapulu'u na nüchepchiakana. ");
INSERT INTO guc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chi nüchepchia kajapulu'ukai ja'rai wo'ot neerü, müshi nümüin: ‘Aluwataashikalee, anu'uya ja'rai wo'ot neerü süchon tü ja'raikat wo'ot neerü paapakat paala tamüin. Anuukalaka tü polookot wo'ot’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nümakalaka joo chi washitshikai nümüin: ‘Tachepchiee, wayuuja'a eera anashi pia, anasü ma'i tü paa'inrakat. Saa'u pikeraajüin sümaa tü te'itaakat püpüleerua, mayaasüje palitchon shia, te'itaainjachi pia joolu'u süpüla laülawaa saa'u kasa wainma. Anakaja müleka talatüle ma'i paa'in wanaa tamaa’, nümakalaka chi washitshikai nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chi nüchepchia kajapulu'ukai piama wo'ot neerü, müshi nümüin: ‘Aluwataashikalee, anu'uya piama wo'ot neerü süchon tü piamakat wo'ot neerü paapakat paala tamüin. Anuukalaka tü pienchikat wo'ot’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nümakalaka chi washitshikai nümüin: ‘Tachepchiee, wayuuja'a eera anashi pia, anasü ma'i tü paa'inrakat. Saa'u pikeraajüin sümaa tü te'itaakat püpüleerua mayaasüje palitchon shia, te'itaainjachi pia joolu'u süpüla laülawaa saa'u kasa wainma. Anakaja müleka talatüle ma'i paa'in wanaa tamaa’, nümakalaka chi washitshikai nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Otta chi nüchepchia kajapulu'ukai wane wo'ot neerü, müshi nümüin: ‘Aluwataashikalee, anuu tü waneekat wo'ot neerü paapakat tamüin paala. Sajatü ne'e shia tanujulüin sulu'u wane ishi süka mmolüin taya peema, süka wayuuin iche ajapüchi pia süpüla awalaajaa shi'yataain wayuu’, nümakalaka ne'e nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nümakalaka chi washitshikai nümüin: ‘Tachepchiee, pia ku'lajaakai aa'in, pi'rala ne'e wayumüin tamüin tü paa'inrakat. Süka pütüjaainje taa'u sünain wayuuin iche ajapüchi taya, ");
INSERT INTO guc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿jamaka'a nnojotka'a paapüin tü neetkat sümüin wane wayuu süpüla shi'yate'erüin shia süpüla kachoinjatüin shia tapüla?’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Nümakalaka joo chi washitshikai namüin wane nüchepchiakana: ‘Jüsüta jümata nuulia türa neerü nüma'anakat saapünaiwa nümüin chi kama'anakai poloo wo'ot. ");
INSERT INTO guc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tamüshii paala jia: Chi wayuu eekai koo'omüin nütüma tü aapünakat nümüin, aapüneerü soo'omüin nümüin. Akaajasa chi eekai nnojolüin koo'omüin nütüma tü aapünakat nümüin, asütüneerü nuulia. ");
INSERT INTO guc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Je joolu'u, jujuittira chira achepchiee e'rüikai wayumüin anooipa'amüin sa'akamüin tü piyuushikat eere shi'yalajüin ma'i wayuu waneepia sütüma tü müliaa shi'rakat’. ");
INSERT INTO guc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Je so'uweena tü ka'i tanteetkat o'u tayakai, chi Shipayakai Wayuu, sümaa eeinjanain napüshua na aapieekana tamaa, je sünain e'itaaushin taya nütüma Maleiwa süpüla aluwatawaa wanaa nümaa, o'tteechi taya sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Je so'uweena ka'ikat tia, okotchojüneerü tamülatu'umüin wayuu süpüshua sainküinjee mmakat süpüshua. Takatajeena na wayuukana maa aka nütüma wane anneetpü'ü sünain nükatajüin tü anneetkalüirua suulia tü kaa'ulakalüirua. ");
INSERT INTO guc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na wayuu eekai naa'inrapü'üin tü nüchekakat chi Maleiwakai napüleerua, takataleena naya yaa tekialu'ujee. Otta müshi'iya na eekai nayouktapü'üin tü nüchekakat chi Maleiwakai napüleerua, takataleena naya yaa tepe'eru'ujee. ");
INSERT INTO guc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Otta tayakai, chi Aluwataashikai, meechi taya namüin na wayuu yaakana tekialu'ujee: ‘Anata'aleeshiija'a ma'i jia nütüma chi Tashikai Maleiwa. Anakaja joolu'u jürütkaale tanainmüin süpüla eeinjanain jia waneepia wamaa chaa eere waluwataain, maa aka tü ni'itaatüjütkalia sümaiwa paala nükumajaiwa'aya tü mmakat je tü kasakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Teenaküin jia süka jiainkain ekirüin taya wanaa sümaa ouktüinkain taya jamü, je süka jiain asirüinkain taya wüin wanaa sümaa münyaasüin taya, je süka jiain ekerotirüinkain taya jipialu'umüin wanaa sümaa waraitta'ain tamüin sainküinpünaa mma, ");
INSERT INTO guc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","je süka jiain kashe'inkain atüma taya wanaa sümaa mashe'inkain taya, je süka jiain aa'inmajüin taya wanaa sümaa ayuulin taya, je süka jiain antüinkain tanainmüin wanaa sümaa püreesainkain taya’, meechi taya namüin na wayuu yaakana tekialu'ujee. ");
INSERT INTO guc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Meenakalaka te'ipajee na yaakana tekialu'ujee, na aa'inrapü'ükana tü nüchekakat chi Maleiwakai napüleerua: ‘Senyotkalee, ¿joujachi pia we'rüin sünain jamüsirüü je wekirataalain pia? ¿Joujachi pia we'rüin sümaa münyaasüü je wasirataalain pia wüin? ");
INSERT INTO guc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Joujachi pia we'rüin sünain waraitta'ain maa je wekerotittaalain pia wepialu'u? ¿Joujachi pia we'rüin sünain mashe'inyüü je kashe'intaalain pia watüma? ");
INSERT INTO guc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Joujachi pia we'rüin sünain ayuulii je sünain püreesaa je wanattaalain pia?’, meena naya tamüin. ");
INSERT INTO guc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Otta tayakai, chi Aluwataashikai, meechi taya namüin: ‘Tamüsü paala tü shiimüinkat jümüin: Saa'u kamaneepü'üin jia sümüin wayuu eekai müliain, na aishiikana tapüla, na nnojoliikana jamajanain sümüin wayuu, kamaneeshii jia tamü'inya sükajee tia’, meechi taya namüin. ");
INSERT INTO guc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Otta namüin na wayuu takatalakana yaa tepe'eru'ujee, na ayouktapü'ükana tü nüchekakat chi Maleiwakai napüleerua, meechi taya namüin: ‘Jiakana ayouktünüinapakana nütüma Maleiwa, ju'una jümata yaajee Hadesmüin eere süpülee tü ouktüsükalüirua, eere tü siki matüjüinsatkat ayokujawaa, tü siki e'itaaushikat nüpüla chi Yolujaakai oo'ulaka na a'yataashiikana nümüin. ");
INSERT INTO guc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tayouktüin jia süka nnojolinkain jikirüin taya wanaa sümaa jamüsirüin taya, je süka nnojolinkain jüsirüin taya wüin wanaa sümaa münyaasüin taya, ");
INSERT INTO guc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","je süka nnojolinkain jikerotirüin taya jipialu'u wanaa sümaa waraitta'ain tamüin sainküinpünaa mma, je süka nnojolinkain kashe'in taya jütüma wanaa sümaa mashe'in taya, je süka nnojoliinkain jünalaain tamüin wanaa sümaa ayuulin je püreesain taya’, meechi taya namüin. ");
INSERT INTO guc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Meenakalaka te'ipajee na yaakana tepe'eru'ujee, na ayouktapü'ükana tü nüchekakat chi Maleiwakai napüleerua: ‘Senyotkalee, ¿joujachi pia we'rüin sünain jamüsirüü je nnojolin wakaaliijain pia? ¿Joujachi pia we'rüin sünain münyaasüü, sünain waraitta'ain maa sainküin mma, sünain mashe'inyüü, sünain ayuulii, je sünain püreesaa, je nnojoishi wakaaliijain pia paajüin?’, meena naya tamüin. ");
INSERT INTO guc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Otta tameechikalaka ne'ipajee: ‘Tamüsü paala tü shiimüinkat jümüin: Saa'u nnojotpü'üin kamaneein jia sümüin wayuu eekai müliain, na nnojoliikana jamajanain sümüin wayuu, nnojoliishii jia kamaneein tamü'inya sükajee tia’, meechi taya namüin. ");
INSERT INTO guc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Najütüneenakalaka süsala naainjala so'umüin tü sikikat süpüla ka'ikat süpüshua. Otta müshi'iya na wayuu aa'inrapü'ükana tü nüchekakat chi Maleiwakai napüleerua, eejeena naya nümaa Maleiwa waneepia”, nümakalaka Jesús namüin na nikirajüinkana sümaa tü wayuukolüirua chaa saa'u tü wutai kanüliakat Olivos. ");
INSERT INTO guc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Niasa Jesús süchikijee tüü, nümakalaka namüin na nikirajüinkana: ");
INSERT INTO guc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Che'ojaasü piama ka'i ne'e süpüla su'ttüin tü ‘Pascuakat’, tü mi'iraa süpülajatkat sotüin waa'in wanaa sümaa nojuittinnüin na watuushinuukana sulu'ujee Egipto. Je so'u tia, ata'ünneechi tayakai, chi Shipayakai Wayuu, maa aka tü tamapü'ükat jümüin, süpüla takachennüinjachin süpüla ouktaa,” nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chakanaja'a akotchajaain Jerusalén na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na laülaayuushiikana naa'u na judíokana. Akotchajaashii naya sulu'u nipia Caifás, chi laülaashikai napüleerua na sacerdotekana, ");
INSERT INTO guc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","süpüla aashajaajirawaa süchiki tü naa'inrüinjatkat nüka Jesús. “Anakaja wata'ürüle nia sujuuna wayuu süpüla wo'utirüinjatüin naa'in. ");
INSERT INTO guc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Otta anasü müleka waa'inrüle tia süchikijee kettaain tü mi'iraakat suulia saashichija'alaain naalin woo'omüin tü wayuukolüirua”, müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Antüshi Jesús sulu'u tü pueulo kanüliakat Betania nipialu'umüin wane wayuu Simón anüliai, chi ayuuishikai paala sütüma aja'ttaa ata. ");
INSERT INTO guc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Je wanaa sümaa nikaain Jesús, sürütkaakalaka nünainmüin wane jierü alü'üjasü wane pachiishichon akumajuushi süka ipa kanüliashi “alabastro” kalu'ushi wane “perfume” kojutüsü ma'i. Shi'yotokalaka tü perfumekat saa'u nikii. ");
INSERT INTO guc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Otta na nikirajüinkana ne'rapa tü saa'inrakat tü jietkat, mojushiisü namüin sünain naashajaajiraain mayaa: —¿Jamüsü sa'amülajaaka'a tü perfumekat? ");
INSERT INTO guc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kojutpaja'a ma'i shia. Anasüje müleka suikkünüle süpüla sükaaliijia wayuu eekai müliain —namajiraakalaka sünain nachiajaain shia. ");
INSERT INTO guc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Je naapapa Jesús tü naashajaajiraakat achiki, nümakalaka namüin: —Juu'ulaa suulia jiyoujüin tü jietkat. Anashaatasü ma'i tü saa'inrakat taka. ");
INSERT INTO guc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na wayuu müliakana, eejeena jümaa waneepia süpüla jüsülajüinjanain namüin. Otta tayakai, süpülajachire joo yaawaa jümaa. ");
INSERT INTO guc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sükajee tüü, shii'iyatüin tamüin tojut süpülapünaa tojoitünüin. ");
INSERT INTO guc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tamüshii paala jia: Sainküin mma eepünaale süküjüneerüin tachiki tayakai chi O'tte'erüikai, ja'yeerü süchiki tü jietkat süpüla sotüinjatüin saa'in wayuu tü saa'inrakat —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Niasa Judas Iscariote, napüshi na polooshiikana piammüin Aluwataaushikana, nu'unakalaka nanainmüin na laülaashiikana na'akajee na sacerdote judíokana sünain nümüin namüin: ");
INSERT INTO guc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Jereerü juwalaajüin tamüin müleka taapüle nikii Jesús jümüin —nümakalaka namüin. Otta nayakana, naküjakalaka süchiki nawalaajüin nia süka apünüin shikii neerü pülaata saa'u naapüinjachin nikii Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Shiasa süchikijee tia, nüchajaain Judas sukuaippa naapüin nikii Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Shiasa süntapa sükalia tü mi'iraa Pascua münakat, tü ekünapü'ükat anain tü pan ma'akasatkat soolojia, narütkaakalaka na nikirajüinkana nünainmüin Jesús sünain namüin nümüin: —¿Jalasü pücheküin süpüleerua weküinjatüin tü Pascuakat, wekeraajaiwa shia püpüla? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nüsouktakalaka Jesús namüin: —Ju'una yalamüin sulu'umüin tü pueulokat nünainmüin wane wayuu. Meenakalaka jia nümüin jüntapa nünainmüin: “Müshi chi Ekirajüikai: ‘Antüitpa tü takalia e'itaaushikat nütüma chi Tashikai. Ekaainjachi taya tü Pascuakat namaa na tekirajüinkana pipialu'u’, meena jia nümüin” —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","No'unakalaka na nikirajüinkana nünainmüin chi wayuukai. Je nekeraajakalaka tü Pascuakat. ");
INSERT INTO guc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Shiasa joo aipa'a, aikkalaashi Jesús sünain ekawaa namaa na nikirajüinkana na polooshiikana piammüin. ");
INSERT INTO guc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Je wanaa sümaa nekaain, nümakalaka Jesús namüin: —Shiimüin tü tamakat jümüin, aapüneechi ekii taya nütüma wane ja'akajee —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mojukalaka ma'i naa'in na nikirajüinkana sütüma tü nümakat Jesús namüin. Namakalaka nümüin wane'ewaire nakua: —Senyotkalee, kasataalejese nnojolin tayain chia. ");
INSERT INTO guc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nüsouktakalaka Jesús namüin: —Chi aapüinjachikai tekii, nieechi chi acholotitkai tü pankat shiroku tü shirakat asalaa wanaa tamaa. ");
INSERT INTO guc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Shiimüin sünain to'utinneechin aa'in maa aka tü ashajünakat paala tachiki tayakai, chi Shipayakai Wayuu. Otta chi aapüinjachikai tekii, alu'uleekaija'a ma'i nia. Anashije nnojolinkale jemelin nia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Otta müshia Judas, chi aapüinjachikai nikii Jesús, nümakalaka nümüin: —Ekirajüikalee, kasataalejese nnojolin tayain paashajaain achiki —nümakalaka. —Pia taashajaaka achiki piakai —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wanaa sümaa nekaain, naapaakalaka Jesús wane pan sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshaletakalaka shi'ipawalin shia namüin na nikirajüinkana, sünain nümüin namüin: —Jaapaa jikaiwa tü pankat. Maa aka taapüin joolu'u jümüin tü pankat, meechia taya sünain aapajiraain tekii jaa'u jiakana —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Naapaakalaka joo Jesús wane iita kalu'usü wiino sünain naapüin analu'ut nümüin Maleiwa saa'u. Naapakalaka shia namüin na nikirajüinkana sünain nümüin namüin: —Anakaja müleka jüsüle jüpüshua wane'ewai jukua süpüshi tü asüüshikat. ");
INSERT INTO guc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Asüüshikat tüü, müsü aka sukuaippa tü tasha amülainjatkat süpüla nikeraajüinjatüin chi Maleiwakai tü pütchi jeket pansaatüjütkalia nütüma je süpüla sülatinnajatüin saainjala wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tamüshii paala jia: Je joolu'u yaajee yaa, nnojoleechi taya asüin tüü jümaa tachikua wane'ere'eya tasüin jümaa so'uweena wane ka'i cha'aya nüma'anamüin chi Tashikai Maleiwa chaa eere nuluwataain —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Shiasa süchikijee nee'irajüin wane jayeechi na'waajakat aka Maleiwa, o'unüshii naya yalajee saa'umüin tü wutai kanüliakat Olivos. ");
INSERT INTO guc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Je nantapa sünainmüin tü wutaikat, nümakalaka Jesús namüin na nikirajüinkana: —O'uneena jia jüpüshua tama'anajee so'u aikat tüü, otta jüpüteechi taya tamüiwa süka mmoleenain jia sheema tü kasa mojusü alateetkat tamüin, maa aka tü sümakat paala, tü ashajünakat sulu'u tü nüchikimaajatkat Maleiwa makat: “To'uteechi aa'in chi anneetpü'ükai je su'walakajaweetkalaka tü na'anneetsekalüirua”. ");
INSERT INTO guc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Otta shiasa süchikijee suso'iraapa taa'in süchikijee ouktaa, o'uneechi taya jüpüleerua Galileamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Otta müshia Pedro, nümakalaka joo nümüin Jesús: —Mayaashiije napüteechin pia na waneeirua sütüma tü kasa mojusü alateetkat pümüin, nnojoireeja'a tapütüinjachin pia pümüiwa. ");
INSERT INTO guc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nümakalaka Jesús nümüin: —Shiimüin tü tamakat pümüin: Süpülapünaa ni'yalajüin wane kaliina so'u aikat tüü, apünüintueechi taya punujulajüin achiki sünain pi'raajüin taya —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nümakalaka joo Pedro ni'ipajee: —Ja'itakaje'e ouktajachin taya pümaa, nnojoireeja'a süpüla taattajaainjachin paa'u —nümakalaka. Je mayaa müsü joo nanüiki na waneeiruaya nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nikerolokalaka Jesús namaa na nikirajüinkana süpümüin wane una'apü kanüliasü Getsemaní. Nümakalaka Jesús namüin: —Anakaja müleka jüikkalaale yaaya süma'inru'u sajeein paala taya sünain aashajawaa nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Neenajaakalaka Pedro oo'ulaka Jacobo je Juan, na nüchooinkana Zebedeo, süpüla nümaain. Nu'ttakalaka Jesús sünain mojuin ma'i naa'in ");
INSERT INTO guc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","sünain nümüin namüin: —Süpüleeruasü ma'i taa'in tü mojuukat aa'in süpülainshi tü müliaa te'reetkat. Anakaja müleka yaale jia sümaa eein jaa'in —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nükatalaakalaka joo Jesús noulia mamüin aka tüsa sünain nu'wachiraain mmalu'u sünain aashajawaa nümaa Maleiwa: —Taata Maleiwa, müleka pücheküle, anasüje puu'ule'erüle toulia tü müliaa te'reetkat joolu'u. Akatsa nnojolüin shiainjatüin paa'inrüin tü tachekakat ne'e tamüiwa, shia paa'inrüinjatka tü püchekakat tapüleerua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Shiasa süchikijee naashajaain nümaa Maleiwa, nüsha'walaakalaka sünain nürütkaain nanainmüin na apünüinshiikana nikirajüin eere natunkaja'attaain nüpüla. Nümakalaka Jesús nümüin Pedro: —¿Jamüshii jia nnojoliika'a juuntüin eein jaa'in wanaa tamaa motso'oyaakaije'e ne'e? ");
INSERT INTO guc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Anakaja müleka eere jaa'in süpüla jüchuntüin nümüin Maleiwa suulia nuu'ulakajüin jaa'in Satanás. Mayaainje kee'ireein jaa'in tü tachekakat jüpüleerua, isasü jüchiki —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nükatalaakalaka joo Jesús nüchikua noulia süpüla naashajaain nüchikua nümaa Maleiwa: —Taata Maleiwa, müleka nnojorule pücheküin suu'ulaain toulia tü müliaa te'reetkat joolu'u, anakaja shiale paa'inrüin tü püchekakat tapüleerua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Je nüle'ejapa nüchikua'aya nanainmüin na nikirajüinkana, atunküshii naya nüpüla, maa aka paala, süka müle'oin ma'i lapü naa'u. ");
INSERT INTO guc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nükatalaakalaka joo Jesús noulia nüchikua süpüla naashajaain nümaa Maleiwa maja'a aka nünüiki paala. Apünüintuaichi joo aashajaain nümaa Maleiwa süka tüü. ");
INSERT INTO guc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Je nüle'ejapa nanainmüin na nikirajüinkana, nümakalaka namüin: —¿Jamüshii jia jutunkajaka'a ma'i? ¿Jamüshii jia nnojoliika'a eein jaa'in wanaa tamaa? Antüitpa takalia tayakai, chi Shipayakai Wayuu, süpüla taapünüinjachin ekii sajapulu'umüin wayuu kaainjarat. ");
INSERT INTO guc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jütamaajaa jumaala, joo'uya wo'unaiwa. Alü'ütshi chi aapüinjachikai tekii —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wanaa sümaa naashajaain Jesús namaa na nikirajüinkana, anta müshia Judas chi napüshikai na polookana piammüin. Je antapaatasü nümaa Judas, wane wayuuirua wainma sümaa wunu'u oo'ulaka chajaruuta sajapulu'u. Ajütüüshi naya natüma na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na laülaayuushiikana naa'u na judíokana. ");
INSERT INTO guc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Je Judas, chi aapüinjachikai nikii Jesús, müshi paala wopulu'u sümüin tü wattakat saalin wayuu: “Chi wayuu tachu'tkai awalapa'a, nia ata'ünnajachika jütüma”, müshi nia namüin paala. ");
INSERT INTO guc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nürütkaakalaka joolu'u Judas nünainmüin Jesús sünain nümüin nümüin: —Ekirajüikalee, anii taya antüin —nümakalaka nümüin sünain nüchu'lüin nuwalapa'a. ");
INSERT INTO guc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nümakalaka Jesús nümüin: —Waa'iraa, anakaja müleka paa'inrüle joolu'u tü püntakat apüla. Arütkaashiijase joo na wayuukana nünainmüin Jesús sünain nata'ülüin nia. ");
INSERT INTO guc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Otta wane nikirajüinkai Jesús, naapaakalaka tü nüchajaruutsekat. Nuwatakalaka noo'omüin wane nüchepchia chi laülaashikai napüleerua na sacerdote judíokana süpüla nüshottajachin nia. Nüchoto'oleekalaka tü nüche'ekat. ");
INSERT INTO guc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nümakalaka Jesús nümüin chi nikirajüinkai: —Pi'itaa püchajaruutse süchikua sulu'u süta. Chi eekai nütkaweein süka chajaruuta, shiimüin sünain oukteechin nia sütüma tü atkawaakat. ");
INSERT INTO guc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nnojo motüin jaa'in sünain tountüin tachuntüin nümüin chi Tashikai süpüla nükaaliijainjachin taya. Je nüjütamaateerü tanainmüin watta saalin aapiee nüma'anajee. ");
INSERT INTO guc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Otta müleka nu'tte'ettaarüle joolu'u taya Maleiwa suulia tü wayuukolüirua, nnojoluja süpüla shikeraajüin tü nünüiki Maleiwa ashajünakat paala sulu'u tü nüchikimaajatkat soo'opünaa tü alateetkat tamüin —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nümakalaka joolu'u Jesús namüin na antakana nünainmüin: —¿Ka'ruwaraiyaa taya jaa'inru'u jüntakalaka tanainmüin sümaa wunu'u oo'ulaka chajaruuta jajapulu'u süpüla jüta'ülüinjachin taya? ¿Jamüshi nnojoika'a jüta'ülüin taya paala cha'aya sulu'u tü a'waajüleekat Maleiwa eere tekirajapü'üin ju'upala? ");
INSERT INTO guc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Otta müsia tüü, alatüsü süpüla shikeraajüinjatüin tü nünüikikat chi Maleiwakai tachiki aküjünakat paala natüma na nünüikimaajanakana —nümakalaka Jesús namüin. Je joolu'u na nikirajüinkana, na'luwataakalaka nüma'anajee sünain napütüin nia nümüiwa napüla na wayuukana. ");
INSERT INTO guc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na ata'ülakana Jesús, no'unirüin nia yalajee nipialu'umüin Caifás chi laülaashikai napüleerua na sacerdotekana, eere jutkatüin na karalouktamaajanakana oo'ulaka na laülaayuushiikana naa'u na judíokana. ");
INSERT INTO guc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Otta müshia Pedro, nünanajakalaka nüchiirua ka'yatalu'ujee. Nüntakalaka so'ulu'umüin nüpaatiase chi laülaashikai. Nikerolakalaka sulu'umüin. Nüikkalaakalaka sa'aka tü suwaariasekat tü a'waajüleekat Maleiwa süpüla nütüjaainjatüin saa'u tü aa'inneetkat nüka Jesús. ");
INSERT INTO guc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Je yaa paülü'ü sulu'u nipia Caifás, eeshii jutkatüin na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka napüshua na waneeirua laülaayuu judío sulu'ukana tü kanüliakat Sanedrín. Süka no'uteein ma'i naa'in Jesús, nachajaa achikit wayuu süpüla süküjüinjatüin sa'alain nüchiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mayaainje süntüin wayuu wainma nanainmüin sünain aküjaa alawaa noo'opünaa Jesús, nnojotsü nantüin anain kasain no'utirajatüin anainjee naa'in. Shiasa mapa yaaulerü, süntakalaka piamasü wayuu nanainmüin ");
INSERT INTO guc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sünain namüin namüin: —Naashin chira, nuuntüin nujuttirüin tü a'waajüleekat Maleiwa sümaa nütame'erüinjatüin shia süchikua so'u apünüin ka'isan —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Otta müshia chi laülaashikai napüleerua na sacerdotekana, nüsha'walaakalaka joolu'u sünain nümüin nümüin Jesús: —¿Jamüinjatü joo pünüiki shi'ipajee türa namakat nala wayuukana püchiki? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Otta müshia Jesús, ko'utüshi ne'e nuulia. Ayatakalaka nia sünain asakiraa: —Tachuntüin joolu'u pümüin sünain püküjainjatüin wamüin tü shiimüinkat nu'upala chi Maleiwa matüjüinkai ouktaa. Tasakirüin paala pia: ¿Shiimüinjasa sünain piain Cristoin Nüneekajalakai Maleiwa? ¿Shiimüinjasa sünain piain chi Nüchonkai Maleiwa? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nüsouktakalaka Jesús nümüin: —Aa, shiimüin sünain tayain maa aka tü pümakat. Tamüshii paala jia jüpüshua: So'uweena wane ka'i, ji'reechi taya, chi Shipayakai Wayuu, sünain joyotüin taya nikialu'ujee Maleiwa chi Pülashikai ma'i saa'u kojutüin taya nütüma. Je ji'reechi taya sünain tantüin mmalu'umüin chajee nüma'anajee Maleiwa sa'aka tü sirumakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Otta müshia chi laülaashikai napüleerua na sacerdotekana, nüsükülijakalaka tü nüshe'inkat sütüma tü jashieekat sünain nümüin namüin na laülaayuu judíokana napüshua: —E'rütkatche ma'i aa'in wayumüin süka sünüiki nümüin Maleiwa. Nnojolüitpa che'ojaain wayuu wamüin aküjüinjatkat nüchiki. Jaapüitpa nünüiki sünain wanaawain nia nümaa Maleiwa naashin. ");
INSERT INTO guc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Kasa anaka süpüla aa'innaa nüka? —nümakalaka namüin. Nasouktakalaka nümüin: —Anakaja su'utinnüle aa'in —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Je joolu'u waneeirua na'aka, nejenaakalaka nu'uutajee Jesús sümaa nashe'etüin nia. Otta waneeirua, na'yaatüin nuwalapünaa ");
INSERT INTO guc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sünain namüin nümüin: —Müleka pialeje chi Cristo Nüneekajalakai Maleiwa, püshantaja saa'u jaralin ashe'etüin pia —namakalaka nümüin sünain neme'erainpalain nia. ");
INSERT INTO guc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wanaa sümaa yaain Jesús sulu'u nipia chi laülaashikai, chashi Pedro joyotüin anooipa'a sulu'u tü paatiakat. Sürütkaakalaka wane majayüt achepchiee nünainmüin sünain sümüin nümüin: —Pia'aya'asa wane nümaapü'ükai Jesús chi Galileaje'ewaikai —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Otta Pedro, naattajaakalaka su'upala süpüshua tü wayuu eejatkat yala sulu'u tü paatiakat sünain nümüin sümüin: —Nnojoishi te'raajüin chi pümakai tamüin. ");
INSERT INTO guc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nüsünülaakalaka Pedro eemüin tü so'ukot paatia. Shi'rakalaka joo nia wane majayülia. Sümakalaka namüin na wayuu eejanakana sulu'u tü paatiakat: —Alu'usa chia, nümaapü'üshi Jesús chi Nazaretje'ewaikai —sümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naattajaakalaka Pedro nüchikua sünain nümüin namüin: —Taküjaleenja jümüin tü shiimüinkat nu'upala Maleiwa sünain nnojolin te'raajüin chira wayuukai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Shiasa mapa yaaulerü, sürütkaakalaka wane wayuuirua eekana sulu'u tü paatiakat nünainmüin Pedro sünain namüin nümüin: —Pia'aya'asa wane nümaapü'ükai chira wayuukai. Wayaawatüin pia sünainjee tü pünüikikat, süka saashajaayain wayuu Galileajeejatü tia —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nümakalaka Pedro namüin: —Taküjüin tachikua jümüin nu'upala Maleiwa sünain nnojolin te'raajüin chira wayuukai —nümakalaka namüin. Akootole'erajaa müshia wane kaliina. ");
INSERT INTO guc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sotokalaka naa'in Pedro tü nümakat Jesús paala nümüin: “Süpülapünaa ni'yalajüin wane kaliina, apünüintueechi taya punujulajüin achiki sünain pi'raajüin taya”, nümakat. Nujuittaakalaka Pedro yalajee yala sünain mojuin ma'i naa'in sünain ni'yalajashaanain. ");
INSERT INTO guc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Shiasa mapa ja'yuupa, outkajaashii nachikua na laülaashiikana na'akajee na sacerdote judíokana namaa na waneeirua laülaayuu judíokana. Naashajaajiraain süchiki tü naa'inrüinjatkat süpüla no'utirüinjatüin naa'in Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","No'unitkalaka Jesús sünain kapüin nia natüma nünainmüin Pilato chi Romaje'ewaikai sülaülashikai tü mmakat Judea so'u ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Niasa Judas, chi aapüichipakai nikii Jesús, nütüjaapa naa'u Jesús sünain nu'uninnüichipain natüma na laülaayuu judíokana süpüla o'utinnüinjatüin naa'in, mojukalaka ma'i naa'in saalin naapüin nikii. Nu'unakalaka nüchikua nanainmüin na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na waneeirua laülaayuu judíokana sünain niite'erüin süchikua namüin tü apünüinkat shikii neerü pülaata ");
INSERT INTO guc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","sünain nümüin namüin: —Shiimüin sünain kaainjalain taya saa'u taapüin jümüin nikii wane wayuu maainjalasai süpüla o'utinnaa aa'in —nümakalaka namüin. —¿Jamajatka'a joo shia wamüin? Naaja pukuaippajiraa sümaa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nijinaakalaka Judas tü neetkat yala sulu'umüin tü a'waajüleekat. Nu'unakalaka yalajee. Nüülaakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Je na laülaashiikana na'akajee na sacerdote judíokana, nakotchajaakalaka tü neetkat sünain maa: —Saa'u süliain ouktaa tü neetkat, nnojotsü anain süpüla we'itaain shia sa'aka tü neerü sümüinjatkat tü a'waajüleekat Maleiwa, maa aka sümakat tü nuluwataakat anain Moisés —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Je süka tü neetkat mapa, nayalajakalaka wane mma süpüla amouyuuinjatüin shia napüla na wayuu nnojoliikana judíoin. Je tü mmakat paala, wane atükülee amüchi. ");
INSERT INTO guc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Otta müsia maa'ulu yaa, sünülia tü amouyuukot, Ishama'ana. ");
INSERT INTO guc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Alatüsü tüü süpüla keraainjatüin tü nünüikikat chi Maleiwakai nüchiki Cristo aküjünakat paala nütüma Jeremías chi nünüikimaajachikai sünain maa: “Tü apünüinkat shikii neerü pülaata aapünakat paala natüma na wayuu Israelkana süpüla saapünüinjatüin nikii, naapaain shia süchikua ");
INSERT INTO guc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","süpüla shiyalajünüinjatüin tü mmakat atüküleekat amüchi, maa aka tü aluwataanakat anain taya nütüma Maleiwa”, makat. ");
INSERT INTO guc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Je süchikijee nüntinnüin Jesús nünainmüin Pilato chi sülaülashikai mma, eeshi nia sha'watüin nümülatu'u sünain nüsakinnüin nütüma: —¿Pia'aya chi Aluwataashikai saa'u wayuu judío? —nümakalaka Pilato nümüin. Nümakalaka Jesús ni'ipajee: —Shia'aya tia pümakat. ");
INSERT INTO guc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Shiasa shi'ipajee tü alawaa naküjakat joo na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na waneeirua laülaayuu judíokana sünain naa'inrüin wainma kasa mojusü naajüin, nnojoishi asouktüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nümakalaka Pilato nümüin: —Paa'inrüin wainma kasa mojusü naajüin nala wayuukana. ¿Jamüshi nnojoika'a püsouktüin shi'ipajee tü namakat? —müshi. ");
INSERT INTO guc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Otta müshia Jesús, ko'utüshi ne'e nuulia. Je süka nnojolüin nüsouktüin Jesús wwatuayaakaije ne'e ne'ipajee, tanataa müsü naa'in chi sülaülashikai mma sükajee tia. ");
INSERT INTO guc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Waneepia su'unna'awai tü Pascuakat, natüjainsü na judíokana taashiwalinjachin wane püreesashi nütüma chi sülaülashikai mma, chi naneekakai na wayuukana süpüla taashii. ");
INSERT INTO guc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Je wanaa sümaa tia, eeshi wane püreesashi kanüliashi Barrabás e'nnaajuushi sükajee mojulaain ma'i nia. ");
INSERT INTO guc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Je suutkajaapa tü wattakat saalin wayuu, nümakalaka Pilato sümüin: —¿Jücheküin süpüleerua niainjachin tajütüin joolu'u Barrabás? ¿Niainjachitaapa Jesús chi Cristokai anülia? —nümakalaka Pilato sümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Anasü nümüin Pilato müleka taashire Jesús, süka nütüjaain naa'u na laülaayuu judíokana sünain naapuushin Jesús sükajee ne'e na'ürülaain nünain. ");
INSERT INTO guc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wanaa sümaa nüikkalaain Pilato süpüla kasalajanainjatüin saainjala wayuu nütüma, ajütünüsü wane pütchi nümüin sütüma tü nu'wayuusekat sünain maa: “Maainjalasai chira wayuukai saa'in tamüin. Mojushaatasü ma'i taa'in sükajee keemain ma'i tü ta'lapüinkat nüchiki sa'waipa. Anakaja müleka puu'ulaale suulia süsalain nia pütüma”, müsü. ");
INSERT INTO guc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Je na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na waneeirua laülaayuu judíokana, najütüin wane wayuuirua sa'akamüin tü wattakat saalin wayuu süpüla nashüküjainjatüin shia süpüla süchuntüin nümüin Pilato niainjachin taashin Barrabás je nu'utirüinjatüin naa'in Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nümakalaka Pilato sümüin tü wattakat saalin wayuu: —¿Jarai na'aka na piamashii püreesashiikana tajuittirüinjachika jümüin? —nüsakirakalaka. —Nia pujuittira wamüin Barrabás —müsü sünüikiirua nümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nüsakirakalaka Pilato naya: —¿Kasa taa'inrüinjatka joo nüka Jesús chi Cristokai anülia? Süsouktakalaka tü wayuukolüirua süpüshua nümüin: —Püchitira saa'u kuruusa. ");
INSERT INTO guc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nümakalaka Pilato sümüin: —¿Jamüshi takacherirüinjachika'a nia? ¿Kasa naainjalaka? Otta müshi'iya na wayuukanairua, masütaajusalii sümaa nekiisa: —Püchitira saa'u kuruusa —namakalaka nümüin nachikua sünain emetuluin ma'i nanüiki. ");
INSERT INTO guc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Otta Pilato, ni'rapa tü wattakat saalin wayuu sünain a'waataa, niyaawata aa'ut sünain nnojolüin soonoonüin amaa tü nümakat. Nu'lojoojookalaka najapü süka wüin su'upala tü wayuukolüirua sünain nümüin sümüin: —Nnojot tasirüin nukuaippa chi wayuukai sünain ouktaa. Shieerü taa'inraka ne'e tü jüchekakat nüpüleerua —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Asonnuwaasü süpüshua tü wayuukolüirua ni'ipajee: —Wayeenaja kasitka nukuaippa sünain ouktaa je na woo'uliwo'ukana —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Otta Pilato, nujuittirakalaka joo Barrabás nanainmüin. Naapakalaka joo Jesús sümüin tü nusurulaatsekalüirua süpüla na'yaajüinjachin nia je süpüla nakacherüinjachin nia sünain kuruusa süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nu'uninnakalaka Jesús sütüma tü nusurulaatsekalüirua Pilato sulu'umüin tü laülaapiakat. Seenajakalaka tü waneeirua surulaatkalüirua süpüla shi'rajüinjatüin nukua Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Saakatakalaka nüshe'in Jesús sümaa sa'atüin wane ashe'inyüü anasü nünain, jepisiiyaa o'ulu, maa aka saa'in nüshe'in wane aluwataai saa'u mma, süpüla shime'erainpalain nia. ");
INSERT INTO guc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Shi'itaakalaka wane kotse keimsesü saa'u nikii oo'ulaka wane waraaratchon sulu'u tü najapü nikialujutkat sümaa süsapainyo'ukain nümülatu'u sünain shime'erainpalain nia sünain sümüin nümüin: —Pia chi aluwataashikai saa'u wayuu judío —müshii naya nümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sejetakalaka suluula naa'u sümaa shi'yaajüin nia kojuyatua nüralo'upünaa süka tü waraaratkat. ");
INSERT INTO guc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Shiasa süchikijee shime'erainpalain nia, saakatüin tü ashe'inyüü anasükat sa'atakat paala nünain. Sa'atüin tü nüshe'inkat nünain süchikua süpüla su'unirüinjachin nia yalajee yala süpüla sükacherüinjachin nia süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wanaa sümaa nu'uninnüin Jesús natüma na surulaatkana eemüinjachire nükachennüinjachin natüma, antüshi Jerusalénmüin wane wayuu Cireneje'ewai kanüliashi Simón. Nüta'ünnakalaka joo natüma na surulaatkana süpüla nülü'üjainjatüin tü wunu'u akachennüinjachikat anain Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","No'unirakalaka Jesús eemüin wane wutai kanüliasü Gólgota. “Ekiyüükat” malu'ut tia. ");
INSERT INTO guc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Je chamüin cha'aya, naapüin na surulaatkana nümüin Jesús wane wiino ka'akasü ishisü süpüla nüsüinjatüin. Otta nuu'ulakapa tü asüüshikat, niyouktüin shia. ");
INSERT INTO guc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nayasa na surulaatkana süchikijee nakacherüin Jesús sünain tü kuruusakat, nashantanajiraakalaka saa'u tü nüshe'inkat süpüla natüjaainjatüin saa'u jaralin makatüinjachin apüla süpüshi tü nüshe'inkat wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Je süchikijee tia, ojoyolooshii naya sü'ütpa'a tü kuruusakat sünain anajaa naa'u Jesús sünain ouktaa. ");
INSERT INTO guc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eesü ashajünüin tü kasalajanakat anainjee nia sünain wane taapüla akachennüsü iipünaa sünain tü kuruusa kanainkat nia. Müsü mayaa: ANII JESÚS CHI ALUWATAASHIKAI SAA'U WAYUU JUDÍO. ");
INSERT INTO guc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Je nümaa Jesús, akachennüshii piamashii wayuu ka'ruwarannuu o'utünüinjanakana aa'in wanaa nümaa. Akachennüshi wane nikialu'ujee oo'ulaka wane nüpe'eru'ujee. ");
INSERT INTO guc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tü wayuu eekai sülatüin nü'ünnaa Jesús, eirakaasü nümüin sümaa mojuin sünüiki nümüin mayaa: ");
INSERT INTO guc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Aisha'ajaa pia. Pujuttirüinjatü tü a'waajüleekat Maleiwa sümaa pütame'erüinjatüin shia süchikua so'u apünüin ka'isan. Müleka shiimüinre Nüchoin pia Maleiwa, ¿jamaka'a nnojoika'a püshakatüin saa'ujee tü kuruusakat süpüla nnojolinjachin ouktüin pia? —sümakalaka tü wayuukolüirua nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Akaata'aya nanüiki na laülaashiikana na'akajee na sacerdote judíokana, je na karalouktamaajanakana, je na waneeirua laülaayuu judíokana sünain neme'erainpalain nia. Namajiraakalaka: ");
INSERT INTO guc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—¿Jamüshisa nnojoika'a nu'tte'erajiraain nümüiwa maa aka nu'tte'erapü'üin wayuu naashin? Nia chi Aluwataashikai saa'u tü wayuu Israelkalüirua naajüin. Müleka nüshakatüle joolu'u saa'ujee tü kuruusakat, anoujeena waya nünain. ");
INSERT INTO guc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Taya Nüchonka Maleiwa” mapü'üshi nia. Je aa'inmajüneechi nia nütüma Maleiwa naajüin. Je joolu'u, müleka nücheküle chi Maleiwakai süpüleerua nu'tte'erüin nia, anakaja müleka nu'tte'eramaatüle nia —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Otta müshi'iya na wayuu ka'ruwarannuu ouktajanakana wanaa nümaa Jesús, müshii aka naya sünain mojuin nanüiki nümüin. ");
INSERT INTO guc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Shiasa maa aka kale'o, epiyuushijaasü mmapa'akat süpüshua, awasaja'aleesia maa aka aliika. ");
INSERT INTO guc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Shiasa aliuukapa ka'ikat, nu'waatakalaka Jesús sünain emetuluin nünüiki sünain nümüin: “Elí, Elí, ¿lama sabactani?”. (Je tüü, malu'ut: “Tamaleiwasee, Tamaleiwasee, ¿jamüshi pia püpütaka'a taya tamüiwa?”, müsü.) ");
INSERT INTO guc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Je saapapa nünüiki Jesús wane wayuuirua sha'washawatsü nü'ütpa'a, müsü shia: —Nuunejüin Elías chi nünüikimaajachikai Maleiwa —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Awataa müshia wane wayuu sünain asaajaa wane maawüi ocholotinnüsü shiroku wane asüüshi jashü'üsü shi'iru'usü wane lumia süpüla shi'itaanüinjatüin sünain niimata Jesús. ");
INSERT INTO guc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Müsü tü waneeirua wayuukolüirua: —Anakaja müleka wa'atapajüle watüjaaiwa saa'u müleka nünteechire Elías süpüla nüshakatirüinjachin nia —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nu'waatakalaka emetut Jesús nüchikua nümüin Maleiwa. Ouktakalaka nia süchikijee. ");
INSERT INTO guc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Je sulu'u tü a'waajüleekat Maleiwa wanaa ma'i sümaa ouktüin Jesús, asüküijaasü pasanainpünaa sünain tü kuluulu so'ulujunakat tü paü shiinalu'usükat. Je akutkujaasü tü mmakat nütüma Maleiwa sümaa suwajaain tü ipakalüirua ");
INSERT INTO guc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","je sümaa sujutajaain tü woowirakalüirua. Nüso'ire'etkalaka naa'in Maleiwa wainma na anoujashii ouktüshiikana paala. ");
INSERT INTO guc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Najuittaakalaka sulu'ujee tü woowirakalüirua. (Je süchikijee nüso'iraain aa'in Jesús, ekerotshii na wayuukana sulu'umüin Jerusalén eere ne'nnüin sütüma wayuu wainma.) ");
INSERT INTO guc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Je chi sülaülashikai surulaat je na surulaatkana eejanakana nümaa sünain nanajüin naa'u Jesús sünain ouktaa, ne'rapa tü mmakat sünain sükutkujaain je tü alatakat nümüin Jesús, sainkuukalaka ma'i naa'in sünain maa: —Shiimüinyala ma'i nia sünain niain chi Nüchonkai Maleiwa —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Je wanaa sümaa yaain Jesús sünain tü kuruusakat, eesü wane jieyuuirua wainma sünain ananajaa maa aka türa. Naya na antüshiikana nümaa Jesús Jerusalénmüin, na aa'inmajapü'ükana nia namaa na nikirajüinkana paala wanaa sümaa waraittapü'üin naya Galileapünaa. ");
INSERT INTO guc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Je na'aka na jieyuukana eesü María Magdalena, oo'ulaka María tü niikat Jacobo je José, oo'ulaka tü neikat na nüchooinkana Zebedeo. ");
INSERT INTO guc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Je motsapa ka'i, antüshi wane wayuu washirü nünainmüin Pilato kanüliasü José chaje'ewai Arimatea, wane nikirajüin Jesús. O'unamaatüshi nia eemüin Pilato süpüla achuntaa müliashii süpüla ni'itaainjachin nia sulu'u woowira. Niasa'a Pilato, naapakalaka nümüin José süpüla nüshakatirüinjachin müliashii saa'ujee kuruusakat. ");
INSERT INTO guc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Niasa José, nüshakatirakalaka müliashii sünain nüko'oloin nia süka wane kuluulu wulesü kanüliasü “lino”. ");
INSERT INTO guc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eejatüja'a wane woowira akumajiruushi paala nütüma José sulu'u wane ipa müle'o süpüla nüpüshi. Akumajuushi tü shirousekat süka wane ipa müle'o. Me'itaajuyülia aamakaa sulu'u. Ni'itaakalaka müliashii sulu'u tü woowirakat sünain nüsürülüin tü woowirakat süka tü ipakat. O'unaa müshia nia süchikijee. ");
INSERT INTO guc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Otta María Magdalena sümaa María tü niikat Jacobo je José, makatüshii naya joyotüin yala peje sünain tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Shiasa mapa waneemüin ka'i, so'u tü ka'i sheemeraakat o'u wayuu judío, o'unüshii na laülaayuushiikana na'akajee na sacerdote judíokana je na fariseokana nünainmüin Pilato ");
INSERT INTO guc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sünain namüin nümüin: —Laülaashikalee, sotüsü waa'in tü nümakat paala chira alaakai kataiwa'aya no'u sünain maa: “So'u apünüin ka'i süchikijee ouktüin taya, oso'iraajeerü taa'in”, müshi nia. ");
INSERT INTO guc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anakaja joolu'u müleka püjütüle wane surulaalüirua süpüla shi'rajüinjatüin so'u tia apünüinkat ka'i saa'u tü woowirakat eere ni'itaanüin müliashii. Anakaja paa'inrüle tia suulia süntajüin tü nikirajüinkalüirua sünain su'luwajüin müliashii süpüla süküjainjatüin sümüin wayuu sünain süso'iraaitpain naa'in süchikijee ouktaa saajüin. Je tü alawaa süküjainjatkat sümüin wayuu, alana'aleejeeria ma'i sünain mojuin suulia tü alawaa nüküjapü'ükat paala Jesús —namakalaka nümüin Pilato. ");
INSERT INTO guc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nümakalaka Pilato namüin: —Te'itaajeerü joolu'u wane surulaalüirua süpüla tia. Anakaja joolu'u müleka jümaale shia süpüla shi'rajüinjatüin saa'u tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","No'unakalaka napüshua eemüin tü woowirakat. Nayasa na laülaayuu judíokana, ne'itaakalaka wane shiyaawase sünain tü shirousekat süpüla natüjaainjatüin saa'u müleka süsünne'ennüle mapeena. No'unakalaka yalajee sünain napütüin tü surulaatkalüirua süpüla shi'rajüinjatüin saa'u tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Je suwasajaapa aikat süchikijee tü ka'i neemeraakat o'u na judíokana, o'unüsü María Magdalena oo'ulaka María tü niikat Jacobo je José eemüin tü woowirakat eejachire ni'itaanüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Akutkujaasü tü mmakat sükajee nüntüin chajee iipünaajee wane aapiee nüma'anajeejachi Maleiwa sünainmüin tü woowira e'itaanakat alu'u paala müliashii. Je nüntapa, nüsünne'erüin tü shirousekat waneemüin sa'ata sümaa nüikkalaain saa'u. ");
INSERT INTO guc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kamacherasü ma'i nu'upünaa. Kasuusü ma'i nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Otta na surulaatkana, ainkuusü ma'i naa'in süka mmolüin neema chi aapieekai. Müinapa aka naya saa'in wane ouktüsü sütüma tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Je nantapa na jieyuukana, nümakalaka chi aapieekai namüin: —Nnojo jainkuuin aa'in. Tatüjaa aa'ut sünain jüchajaain nüchiki Jesús chi akachennakai paala süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nnojoishi nia yaaya. Oso'iraaitpa naa'in nüchikua, maa aka tü nümapü'ükat paala sünain naa'inrüinjatüin. Jürütkaa jümaala ji'rajaaiwa tü nüchikanainkat eejachire nia süpütüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Anakaja joolu'u müleka ju'unamaatüle süpüla jüküjainjatüin nüchiki namüin na nikirajüinkana sünain jümüinjatüin namüin: “Oso'iraasü naa'in süchikijee ouktaa je o'uneechi joolu'u nia jüpüleerua Galileamüin. Ji'reechi nia cha'aya”, meena jia namüin. Soto jaa'in tü tamüitpakat jümüin —nümakalaka chi aapieekai namüin. ");
INSERT INTO guc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Napantajaakalaka na jieyuukana eejee tü woowirakat. Ja'itairü ayo'ujaain naa'in, talataleesia ma'i naa'in sütüma tü ne'rakat. Nawataakalaka eemüin na nikirajüinkana Jesús süpüla naküjainjatüin namüin süchiki tü aküjünakat. ");
INSERT INTO guc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Shiasa sulu'u tü wopukot, napanapajiraakalaka nümaa Jesús. “Eeshi Maleiwa jümaa”, nümakalaka namüin. Narütkaakalaka na jieyuukana nünainmüin sünain nasapainyo'ukain naya nümülatu'umüin sünain na'waajüin nia sümaa najapulu'ujain nuu'ui. ");
INSERT INTO guc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nümakalaka Jesús namüin: —Nnojo mmolüin jia. Shia anaka alu'u müleka ju'unüle nanainmüin na tawalayuukana jaapiraiwa naya süchiki no'unüinjanain Galileamüin. Ne'reechi taya cha'aya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wanaa sümaa no'unüin na jieyuukana eemüin na nikirajüinkana Jesús, o'unüsü pueulopa'amüin waneeirua tü surulaat e'rajüsükalüirua saa'u tü woowirakat. Naküjakalaka namüin na laülaayuushiikana na'akajee na sacerdote judíokana süchiki süpüshua tü alatüitpakat. ");
INSERT INTO guc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naashajaajiraakalaka na laülaayuushiikana na'akajee na sacerdotekana namaa na waneeirua laülaayuu judíokana soo'opünaa tü naa'inrüinjatkat. Naapakalaka wainma neerü namüin na surulaatkana ");
INSERT INTO guc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sünain namüin namüin: —Jüküjainjatü sümüin wayuu sünain süntüin tü nikirajüinkalüirua sa'waipa wanaa sümaa jutunküin sünain su'luwajüin müliashii. ");
INSERT INTO guc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Je müleka naapinnüle Pilato sünain nnojolichipain müliashii, aashajaweena waya nümaa süpüla nnojoliinjanain süsalain jia nütüma saaliijee tia —namakalaka na laülaayuukana namüin na surulaatkana. ");
INSERT INTO guc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naapaakalaka joo na surulaatkana tü neetkat sünain naa'inrüin tü namakat namüin. Je mapa, tü nachikikat na nikirajüinkana Jesús sünain na'luwajüin müliashii, su'walakajaakalaka sa'aka tü wayuu judíokolüirua. Ayatsia joulüin maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","No'unakalaka na polookana waneemüin nikirajüinkana Jesús Galileamüin saa'umüin tü namünakat aküjünakat achiki paala nütüma. ");
INSERT INTO guc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Shiasa nantapa chamüin sünain ne'rüin nia, na'waajüin nia. Otta wane no'utku, naashajaain sulu'u naa'in sünain maa: —¿Niayaa cheje ma'i eera Jesús chii? —müshii. ");
INSERT INTO guc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nürütkaakalaka joo Jesús nanainmüin sünain nümüin namüin: —Laülaashi taya nütüma chi Tashikai Maleiwa saa'u wayuu süpüshua yaa mmalu'u oo'ulaka saa'u tü kasakalüirua süpüshua chakat iipünaa. ");
INSERT INTO guc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Je sükajee tia, ju'una jumaala sainküin mmakat süpüshua süpüla jüküjainjatüin tachiki sümüin wayuu süpüla sünoujainjatüin tanain. Jikirajeena naya süpüla nayainjanain na tekirajüinkana maa aka jiakana. Je juwoutisaajeena naya saa'u nünülia chi Tashikai, saa'u tanülia tayakai chi Nüchonkai, je saa'u nünülia chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jikirajeena naya sünain tü taluwataapü'ükat anain jia süpüla noonooinjatüin sümaa. Shiimüin sünain jümaainjachin taya waneepia wane'ere'eya süntapa tü ka'i saja'lajaweetkat o'u kasa süpüshua. Shiimüin sünain jümaainjachin taya süpüla ka'ikat süpüshua.");
INSERT INTO guc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anuu su'ttia tü anasükat pütchi, tü nüchikikat Jesucristo chi Nüchonkai Maleiwa: ");
INSERT INTO guc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tü sulu'ukot tü karaloukta nüshajalakat Isaías chi nünüikimaajachikai Maleiwa, müsü yaa: “Taluwataajeechi chi pünüliamaajachikai püpüleerua süpüla naapirüinjatüin tü wayuukolüirua sünain püntajachin sa'akamüin. Yapainjatü nütüma tü wayuukolüirua süpüla saapajüin pünüiki. ");
INSERT INTO guc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Owoottaweechi wane wayuu cha'aya isashiipa'a sünain maa: ‘Yapa jütüma nüpüna chi Senyotkai. Juu'ulaa suulia jaainjala süpülapünaa nüntajachin ja'akamüin’ ”. ");
INSERT INTO guc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Süpüla shikeraajüinjatüin tü nüshajakat achiki paala Isaías, niweetakalaka Juan chi owoutisaajüikai sünain aküjaa nüchiki Maleiwa sümüin wayuu cha'aya isashiipa'a. Nu'ttakalaka sünain nime'ejüin naa'in na wayuukana shii'iree nayaawajaain suulia naainjala sümaa nakatalaain suulia süpüla sülatinnüinjatüin noulia. Je nuluwataain na oonookana sümaa nünüiki sünain nawoutisaajünüin. ");
INSERT INTO guc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","O'unüsü wayuu watta saalin nünainmüin sulu'ujee süpüshua tü mmakat Judea je sulu'ujee tü pueulokat Jerusalén. Naküjüin tü naainjalakat nümüin Maleiwa, je owoutisaajünüshii nütüma Juan cha'aya shiroku tü süchikat Jordán. ");
INSERT INTO guc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Otta Juan, kashe'inshi nia wane süta tü mürüt kanüliakat “camello”, otta kasi'irainshi paa'ata. Ekapü'üshi nia kaashapü oo'ulaka mapa. ");
INSERT INTO guc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anuu tü nümapü'ükat Juan sümüin wayuu: “Anteechi tachiirua wane wayuu alana'aleeshia toulia. Tayakai, wayuu ne'e. Nnojoishi wanaapünaain taya nümaa, süka pülashin ma'i nia toulia. ");
INSERT INTO guc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tawoutisaajüin ne'e jia süka wüin. Otta müshia niakai, anteechi jünainmüin süpüla naapüinjachin jümüin chi Naa'inkai Maleiwa süpüla eeinjachin nia waneepia jümaa”, mapü'üshi Juan. ");
INSERT INTO guc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Je wanaa sümaa tia, nüntakalaka Jesús chajee Galileajee sulu'ujee tü pueulokat Nazaret eemüin tü süchikat Jordán süpüla nuwoutisaajünüinjachin nütüma Juan shiroku tü süchikat. ");
INSERT INTO guc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Je wanaa sümaa nüsha'walaain Jesús süchikijee emetaa shirokujee tü wüinkat, eirakaashi nia iipünaamüin. Je wanaa ma'i sümaa tia, eerulaasü tü sirumakat chaa iipünaa. Ni'rakalaka chi Naa'inkai Maleiwa maa aka saa'in wane mo'uwa sünain ashakataa nünainmüin. ");
INSERT INTO guc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Saapünakalaka joo wane pütchi chaa iipünaajee sünain maa: “Pia chi Tachonkai aishikai tapüla. Talatüshi ma'i taya pümaa”. ");
INSERT INTO guc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","O'uninna müshia Jesús nütüma chi Naa'inkai Maleiwa isashiipa'amüin. ");
INSERT INTO guc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chajachi nia maa aka pienchi shikii ka'i sünain nuu'ulakünüin aa'in nütüma Satanás chi sülaülakai yolujaa. Je chaa eejachire Jesús, eesü tü kasa jashichi kepiakat wuna'ainküin. Oo'ulaka aa'inmajünüshi nia natüma wane aapieeirua nüma'anajeejana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Shiasa wanaa sümaa nüpüreesajünüin Juan nütüma Herodes, ale'ejüshi Jesús Galileamüin süpüla aküjaa tü anasükat pütchi, tü nünüikikat chi Maleiwakai, sünain maa: ");
INSERT INTO guc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Antüitpa nükalia chi Maleiwakai süpüla nikeraajüin tü namapü'ükat na nünüikimaajanakana. Jiyaawajaa jumaala suulia jaainjala sümaa jünoujain tü anasükat pütchi, süka sülü'ülüin nükalia chi Maleiwakai süpüla aluwatawaa jaa'u”, mapü'üshi nia. ");
INSERT INTO guc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Je wanaa sümaa waraittüin Jesús sotpa'apünaa tü palaa kanüliakat Galilea, ni'rakalaka Simón oo'ulaka Andrés chi nuwalakai. Ajuna'atshii tü nakusüinkat shiroku tü palaakat süka olojüliin naya jime. ");
INSERT INTO guc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Anashii tamaatalai jia. Maa aka olojüliin jia jime, okotchajüinjana jia wayuu tamüin süpüla saapüinjatüin tanüiki —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Napüta namüsüja'a tü nakusüinkat süpüla o'unaa nümaa. ");
INSERT INTO guc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nu'unaiwa'aya Jesús mamüin aka türa, ni'rüin joo Jacobo, chi nüchonkai Zebedeo, oo'ulaka Juan chi nuwalakai. Areweentaja'atshii tü nakusüinkat yaa sulu'u tü anuakat nümaa chi nashikai. ");
INSERT INTO guc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eenaküna müshi'iya naya nütüma Jesús. Napütakalaka chi nashikai namaa na nüchepchiakana sulu'u tü anuakat süpüla o'unaa nümaa. ");
INSERT INTO guc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nüntakalaka Jesús namaa na nüneekajalakana sulu'umüin tü pueulo kanüliakat Capernaum. Je so'u tü ka'i neemeraakat o'u na judíokana, ekerotshi nia sulu'umüin tü ekirajüleekat sünain nu'ttüin sünain ekirajaa tü wayuukolüirua cha'aya. ");
INSERT INTO guc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Je ponusü ma'i naa'in na wayuukana tü nünüikikat, süka shiyaawatüin saa'inyaka naa'u sünain ni'itaaushin nütüma Maleiwa süpüla ekirajaa nünüiki, nnojoishi müin aka naa'in na karalouktamaajanakana. ");
INSERT INTO guc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Asha'walaa müshia wane wayuu sulu'u tü ekirajüleekat, kale'eru'ushi yolujaa. Su'waatakalaka joo tü yolujaakalüirua nüle'eru'ukat chi wayuukai nümüin Jesús: ");
INSERT INTO guc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Alu'uleekaija'a waya pütüma Jesús, piakai chi Nazaretje'ewaikai. Aashin we'raajüin pia. Je watüjaa aa'uchi pia sünain piain aneekuushin nütüma Maleiwa. ¿Jamüinjatü wakuaippa pütüma? ¿Püjütajanataaka waya yaajee? —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nüchiajaakalaka joolu'u Jesús tü yolujaakat: —Ko'uta pia. Pujuitta yalajee nuulia chi wayuukai —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sujuittakalaka joo tü yolujaakat nuulia chi wayuukai sünain nu'kchichijaain sütüma sümaa nu'waatüin. ");
INSERT INTO guc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Otta na wayuukana napüshua, ponusü ma'i naa'in tü ne'rakat sünain naashajaajiraain: —¿Kasashikai wayuu chi Jesúskai? Jeket sukuaippa tü nikirakat anain, je laülaain nia suulia tü yolujaakalüirua. Kojutkalaka nünüiki sütüma wanaa sümaa nüjütüin shia süle'eru'ujee wayuu —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yootoo müsüja'a nüchiki Jesús sainküin tü mmakat Galilea. ");
INSERT INTO guc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nujuittaakalaka Jesús sulu'ujee tü ekirajüleekat namaa Jacobo oo'ulaka Juan sünain no'unüin nipialu'umüin Simón oo'ulaka Andrés. ");
INSERT INTO guc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eejatkalaka nüpüla tü nimeshikat Simón sünain ayuulin sütüma oushuwaa. Je achuntünüsü nümüin Jesús natüma na wayuukana niiyajüinjatüin shia namüin. ");
INSERT INTO guc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nürütkaakalaka joo sünainmüin sünain naapaain sajapü süpüla nüikkale'erüin. Naawale'erakalaka tü ayuuliikat suulia. Je süka anaitpain shia, o'ttüsü shia sünain shikirüin na shi'iyoukana. ");
INSERT INTO guc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Je motsopa ka'i, antinnüsü wainma wayuu eekai ayuulin je eekai kale'eru'uin yolujaa nünainmüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Okotchajaasü tü wayuu kepiasükalüirua sulu'u tü pueulokat sü'ütpa'a tü so'ukot tü miichikat. ");
INSERT INTO guc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Niiyajakalaka wainma wayuu eekai ayuulin, tü ayuuisükat sütüma ayuulii eekai eein ne'e sünain. Je nujuittirakalaka yolujaa süle'eru'ujee wainma wayuu. Otta nüchiajaain tü yolujaakalüirua suulia saashajaain nüchiki, süka sütüjaain naa'u sünain jaralin nia. ");
INSERT INTO guc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Je eeiwa'aya aikat, achijiraashi Jesús sünain o'unaa chamüin cha'aya eere yüütüülin mmakat süpüla aashajawaa nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Otta müshia Simón je na eekana nümaa, o'unüshii naya sünain achajawaa nüchiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Je nantapa nünainmüin, —Asukaasü wayuu wainma püpüla —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nüsouktakalaka Jesús: —Anakaja wo'unüle yaajee yaa. O'uneeshi taya chamüin cha'aya eemüin tü pueuloirua chakat wapüleerua taküjaiwa nüchiki Maleiwa sümüin tia wayuukolüirua, süka shiain ajütünüin apüla taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nu'unakalaka Jesús sainküinpünaa tü mmakat Galilea sünain nüküjain nüchiki Maleiwa sulu'upünaa tü ekirajüleekalüirua wayuu judío cha'aya je sünain nujuittirüin yolujaa süle'eru'ujee wayuu. ");
INSERT INTO guc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Arütkaashi nünainmüin Jesús wane wayuu mayeinshi sütüma aja'ttaa ata. Nüsapainyo'ukashi nia nümülatu'u Jesús sünain nüchuntüin nümüin: —Müinka pücheküle, piiyaja taya —nümakalaka chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nümüliajakalaka naa'in Jesús chi ayuuishikai sünain niyurulain nütüna nünainmüin sünain naapaain nia: —Tacheküin süpüleerua anainjachin pia —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Anaichipa joo chi wayuukai. Nnojolüitpa aja'ttüin tü nütakat. ");
INSERT INTO guc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nüjüta nümüshia Jesús chi wayuukai sünain nüchiajaain nia sünain maa nümüin: ");
INSERT INTO guc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nnojo püküjain sümüin wayuu püchiki sünain teiyajüin pia. Pu'una palajana eemüin chi sacerdotekai süpüla pii'iyatüinjatüin nümüin tü pütakat süpüla naapüinjatüin nümüin Maleiwa tü pümü'ünüin ouktajatkat saa'u anaichipain pia, maa aka tü nuluwataakat anain Moisés paala sümaiwa. Je sükajee tia, sütüjaajeechi aa'u pia wayuu sünain anaichipain pia süpüla sa'akainjachin pia püchikua —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Otta chi wayuukai, nnojoishi ko'utüin. Nu'unakalaka sümaa aküjaa süchiki tü kasa anasü alatakat nüka. Je süka sütüjaaichipain naa'u Jesús tü wayuukolüirua, nnojoishi ekeroteein sulu'umüin tü pueulokalüirua. Makatüshi nia anooipa'a eere yüütüülin mmakat. Otta tü wayuukolüirua, antüsü nünainmüin sulu'ujee mmakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Je nüle'ejapa Jesús Capernaummüin süchikijee kojuya ka'i, aapüna achikichi nia sünain nüntüichipain nipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Je süka süntüin wayuu watta saalin nünainmüin, wotüsü tü miichikat sütüma. Cho'ujaasü tü miichikat süpüleerua. Otta müshia Jesús, aküjüshi nünüiki chi Maleiwakai sümüin. ");
INSERT INTO guc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nantakalaka wane pienchishii wayuu tooloyuu nünainmüin Jesús sünain nalü'üjiraain wane wayuu ayuuishi shii'iree niiyajeein nia. Oukta asa'achi, oukta atünachi. ");
INSERT INTO guc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Je süka wainmain tü wayuukolüirua so'ulu'u tü miichi, isasü nachiki ekeroloo nünainmüin Jesús. Naliikajaakalaka nümaa chi wayuukai chaa süralo'umüin tü miichikat, süpüla naakatüinjatüin süralo'ujee iipünaa naa'u Jesús. Je jutatapa shia, nashakatirüin tü süi kalu'ukot chi wayuu oukta asa'achikai. ");
INSERT INTO guc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nütüjaapa Jesús saa'u nanoula na wayuukana, aashajaashi nia nümüin chi ayuuishikai: —Tawalachee, talatirüitpa paainjala puulia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Je wane na wayuukana karalouktamaajana eejanakana sa'aka tü wayuukolüirua, müsü naa'in: ");
INSERT INTO guc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jaraikai wayuu chi e'rüiyaaka aa'in wayumüin süpüleerua nünüiki nümüin Maleiwa? Nnojoishi jerain Maleiwa sünain niain ainküin nümüiwa alatiraa saainjala wayuu”. ");
INSERT INTO guc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Otta müshia Jesús, süka niyaawatüin saa'u tü sulu'ukat naa'in na karalouktamaajanakana, asouktüshi nia namüin: —¿Jamüshii jia mojuka'a jünüiki tamüin sulu'u jaa'in? ");
INSERT INTO guc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Je wanaa sümaa tamüin nümüin chi oukta asa'achikai, “Talatirüitpa paainjala puulia”, nnojoishi jütüjaain aa'u tayakai, chi Shipayakai Wayuu, sünain laülaain süpüla alatiraa saainjala wayuu. ");
INSERT INTO guc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Otta müsia joolu'u, jütüjaweechi aa'u taya sünain laülaain süka tameechin nümüin, “Püsha'walaa, pülü'üjaa pu'ula, waraittaiwa pia”. Aashajaashi joo Jesús nümüin chi oukta asa'achikai: ");
INSERT INTO guc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Tamüshi paala pia: Püsha'walaa, pülü'üjaa pu'ula, pu'una pipialu'umüin —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Asha'walaamaatüshi joo chi wayuukai sünain naapaain tü nu'ulakat sünain nu'unüin su'upala tü wayuukolüirua süpüshua. Ponokalaka ma'i saa'in tü wayuukolüirua tü shi'rakat sünain maa: —Anashaataleesia ma'i tü kasa we'rakat so'uka'i tüü, tü nnojotkat we'rapü'üin paalainka —namakalaka sünain na'waajüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","O'unüshi Jesús nüchikua sotpa'amüin tü palaakat. Je süntapa wane wayuuirua watta saalin nünainmüin, o'ttüshi nia sünain nikirajüin naya. ");
INSERT INTO guc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Je sünain nu'unüin yalajee, eeshi nüpüla wane wayuu kanüliashi Leví, chi nüchonkai Alfeo, joyotüin eere ni'yataale. Okotchajüi neerü nümüin chi sülaülashikai mma. —Anashi tamaatalai pia —nümakalaka Jesús nümüin. Nüsha'walaakalaka joo Leví sünain o'unaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Shiasa süchikijee tia, neenakakalaka Leví wainma wayuu nipialu'umüin sünainmüin wane ekawaa nüpüla Jesús namaa na nikirajüinkana, süka wainmain wayuu oushikajaakat nüchiirua. Je na'aka na wayuu eküshiikana, eeshii wainma na kaainjaraliikana naashin na fariseokana, maa aka na okotchajüliikana neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Otta na karalouktamaajanakana na'aka na wayuu fariseokana ne'rapa Jesús sünain nikaain namaa na kaainjaraliikana oo'ulaka na okotchajüliikana neerü, mojusü nanüiki namüin na nikirajüinkana sünain namüin namüin: —Jamüshi cheje eera nikaaka'a chi ekirajüikai jia namaa na eekana kaainjaraliin maa aka na okotchajüliikana neerü —namakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naapapa Jesús tü namakat na fariseokana namüin na nikirajüinkana, nüsouktakalaka ne'ipajee: —Wane wayuu eekai nnojolüin ayuulin, nnojotsü che'ojaain tottoolu sümüin. Shia che'ojaaka amüin eekai ayuulin. Sükajee tüü, antüshi taya sa'akamüin wayuu süpüla achajawaa süchiki eekai kaainjaralüin shii'iree sükatalaain suulia saainjala. Nnojoishi taya antüshin süpüla achajawaa süchiki eekai maainjalain saa'in namüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","So'u wane ka'i, aamüjüshii na nikirajüinkana Juan. Müshii aka na fariseokana sünain aamüjaa. Süntakalaka wane wayuuirua nünainmüin Jesús sünain nasakirüin nia sünain maa nümüin: —Aamüjapü'üshii na nikirajüinkana Juan wanaa sümaa aashajawaa nümaa Maleiwa, maa'aya aka na nekirajüinkana na fariseokana. ¿Jamaka'a joo na pikirajüinkana nnojoliika'a naamüjüin? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nüsouktakalaka Jesús ne'ipajee sünain nikirajüin naya süka sukuaippa tü kasa e'nnakat sainküin mma sünain nümüin namüin: —Tü wayuu antakat sünain shikiira wane ka'wayuusee, anasü talatüle saa'in sümaa nnojolüin mojuin saa'in wanaa sümaa eein chi ka'wayuuseshikai namaa. Nnojoleena aamüjüin wanaa sümaa eein nia namaa. ");
INSERT INTO guc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Akaajaa tayakai joolu'u, süka eein taya namaa na tekirajüinkana, anasü talatüle naa'in. Alu'ujasa mapa takatalaapa noulia, eeshii süpüla naamüjüin. ");
INSERT INTO guc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nnojotsü anain müleka shi'yotoonüle wane shi'ipa kuluulu eekai jeketüin süpüla ekeittiajünaa süka wane ashe'in eekai laülaain. Amojujaajeerü süpüshua wanaa sümaa süshijaanüin süka süsüküijaweerüin. Akaajaa jiakana, nnojotsü anain masütaajule jia sünain tü jünoujakat paala wanaa sümaa jünoujain tü pütchi jeket tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Maa'aya aka wane wiino. Müleka süla'annüle wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai laülaain, eesü süpüla süchatajaain tü paa'atakat sütüma jashü'üpa. Amülouleerü tü wiinokot oo'ulaka tü paa'atakat. Shi'itaaneekalaka wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai jeketüin”. ");
INSERT INTO guc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","So'u tü ka'i neemeraakat o'u na judíokana, awaralijaashi Jesús namaa na nikirajüinkana sulu'u wane wopu pasanainpünaa sünain wane yüüja. Je sünain waraittüin na nikirajüinkana, nasürüttapünaain wane a'ttiee kanüliasü “trigo”. ");
INSERT INTO guc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Otta na fariseokana, süka müin aka saa'in wane a'yatawaa tü naa'inrakat na nikirajüinkana Jesús naashin, namakalaka nümüin Jesús: —Saashin tü nüshajakat Moisés, nnojotsü anain süpüla naa'inrüin na pikirajüinkana tia so'u tü ka'i weemeraakat o'u —namajaakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Asouktüshi Jesús joolu'u namüin na fariseokana saa'u nnojolüin kaainjalaain tü naa'inrakat na nikirajüinkana naajüin: —Soto jaa'in tü naa'inrakat David paala sümaiwa wanaa sümaa müliain süka alin jamü nümüin je namüin na nütünajutkana. ");
INSERT INTO guc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","So'u tü ka'i nuluwataakat o'u Abiatar chi laülaashikai napüleerua na sacerdote judíokana, ekerotshi David sulu'umüin tü a'waajüleekat Maleiwa wanaa sümaa shi'itaanüin tü pan aapünajatkat nümüin Maleiwa. Tü pankat naashin Moisés, nnojotsü shika'ain sümüinjatüin wayuu eekai eein ne'e. Naya eküinjanaka namüiwa, na sacerdote judíokana. Otta David, naapaain tü pankat sümaa niküin, je naapüin süpüshi namüin na nütünajutumuyuukana. Je nnojoliishii süsalain naya tü naa'inrakat nütüma Maleiwa —nümakalaka Jesús namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aashajaashi Jesús nüchikua: —Je wayuu süpüshua, nnojotsü akumajuushin nütüma Maleiwa süpüla apüleeruainjatüin saa'in so'u sükalia eemerawaa. E'itaaushi tü ka'ikat süpüla jaloulinjatüin sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tayakai, chi Shipayakai Wayuu, taya laülaashika saa'u tü ka'i sheemeraakat o'u wayuu. Je sükajee tia, nnojoliishii kaainjalain na tekirajüinkana saaliijee tü naa'inrakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","So'u wane ka'i, ekerotshi Jesús nüchikua sulu'umüin tü ekirajüleekat. Eejachikalaka nüpüla wane wayuu joso ajapüchi. ");
INSERT INTO guc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Je na fariseokana, süka naapeein nikii Jesús, eekalaka ma'i naa'in nüpüla müleka niiyajüle so'u tü ka'i eemeraanakat o'u, shii'iree “Kaainjarai nia süka ni'yataain so'u tü ka'i eemeraanakat o'u sünain niiyajüin wane wayuu”, namüinjanain sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Otta Jesús, —Püsha'walaa yala pasanainmüin sünain tü wayuukolüirua —nümakalaka nümüin chi wayuu joso ajapüchikai. ");
INSERT INTO guc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nümakalaka joo Jesús namüin na fariseokana: —Saajüin tü nüshajakat Moisés, ¿kasa anaka süpüla waa'inrüinjatüin so'u tü ka'i eemeraanakat o'u? ¿Anasü müleka waa'inrüle tü kasa eekai anain? ¿Shiataapa eekai mojuin? ¿Anasü müleka waa'inmajüle wayuu suulia ouktaa? ¿Shiataapa anain wo'utüle saa'in? —nümakalaka namüin. Ko'utüshii ne'e naya nuulia. ");
INSERT INTO guc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Niirakaakalaka Jesús namüin na wayuukanairua napüshua sünain jashichin nia namüin. Mojusü naa'in Jesús süka manoujüinyeein naya nünüiki. Nümakalaka joolu'u nümüin chi joso ajapüchikai: —Puwasta tü pajapükat. Je süka naa'inrüitpain tü nümakat nümüin, anale'eitpa tü najapükat. ");
INSERT INTO guc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Otta na fariseokana, noju'innajaakalaka nanainmüin na nümaajanakana Herodes sünain namajiraain namaa: —¿Kasa waa'inrüinjatka süpüla wo'utirüinjatüin naa'in? —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nu'unakalaka Jesús namaa na nikirajüinkana suulia tü wayuukolüirua sotpa'amüin tü palaakat. Otta wayuu watta saalin sulu'ujee tü mmakat Galilea, oushikajaasü nüchiirua. ");
INSERT INTO guc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Je süka saapüitpain wayuu wainma nüchiki Jesús sünain naa'inrüin kasa anasü, antüsü joolu'u nünainmüin sulu'ujee tü mmakat Judea, sulu'ujee tü pueulokat Jerusalén, oo'ulaka sulu'ujee tü mmakat Idumea. Antüshii na chaje'ewaliikana wüinpümüin saa'ujee tü süchikat Jordán oo'ulaka sulu'ujee tü mmakat pejekat sünain tü pueulokalüirua Tiro oo'ulaka Sidón. ");
INSERT INTO guc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Süka wainmain tü wayuukolüirua, nuluwataain Jesús na nikirajüinkana süpüla yapainjatüin wane anua nüpüla suulia sülainjirain nia. ");
INSERT INTO guc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Süka saapüin nüchiki Jesús sünain niiyajüin wayuu wainma, arütkaasü joolu'u tü wayuukolüirua eekai ayuulin sünain chentaawain süpüla shipettüin nia shii'iree anain shia nütüma. ");
INSERT INTO guc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Otta tü wayuu kale'eru'usükalüirua yolujaa, shi'rapa Jesús, su'wachiraakalaka nümülatu'umüin sünain su'waatinnüin sütüma tü yolujaakalüirua: —Pia Nüchonkai chi Maleiwakai —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Otta nüchiajaain shiairua suulia su'walakajüin nüchiki sainküin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Je süchikijee tia, o'unüshi Jesús saa'upünaa wane namüna sünain neenaküin na wayuu nüchekakana süpüleerua nümaain. Je narütkaapa nünainmüin, ");
INSERT INTO guc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nüneeküin poloo piammüin na'akajee. Ni'itaakalaka joo nanülia “Aluwataaushi” münüin, süka nuluwataainjanain naya sünain aküjaa nünüiki sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","“Taapüin laülawaa joolu'u jümüin süpüla ayu'laa yolujaa süle'eru'ujee wayuu”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Anuu nanülia na polookana piammüin wayuu aneekuushikana nütüma: Simón, chi e'itaanakai anülia Pedroin nütüma Jesús. ");
INSERT INTO guc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo nümaa Juan nüchonnii Zebedeo, na ni'itaakana anülia Boanerges. (Je tü nanüliakat, “Sütürüla Juya”, malu'ut.) ");
INSERT INTO guc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, je Tomás. Jacobo chi nüchonkai Alfeo. Tadeo. Simón, wane no'utku na wayuukana kanüliakana Zelote. ");
INSERT INTO guc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Je Judas Iscariote chi aapüinjachikai nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Shiasa süchikijee tia, ekerotshi Jesús namaa na nikirajüinkana sulu'umüin wane miichi. Sükotchajaakalaka süchikua wane wayuu watta saalin nünainmüin. Kapüleekalaka namüin nekaain saa'ujee tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Shiasa natüjaapa naa'u Jesús na nüpüshikana sünain chenta'ain sümüin tü wayuukolüirua nünain, nasaajaweein nia yalajee. “Maa'inkai cheje aa'in nia”, namajiraakalaka. ");
INSERT INTO guc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Otta na karalouktamaajanakana antakana Jerusalénjee, aashajaajiraashii naya sünain maa: “Süka niain Beelzebú chi sülaülakai yolujaa eein nümaa, pülakalaka nia süpüla ayu'laa yolujaa”, müshii naya. ");
INSERT INTO guc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Neenajakalaka Jesús tü wayuukolüirua nünainmüin süpüla nikirajüinjanain naya süka sukuaippa tü kasa e'nnakat sainküin mma: “¿Jamakuaippat süpüla nüjütajaajiraainjachin ne'e Satanás nümüiwa, chi sülaülakai yolujaa? ");
INSERT INTO guc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Müleka sütkaajiraale wane wayuuirua, aja'lajaajiraweena naya. ");
INSERT INTO guc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Je müleka sü'ülüjaale wane wayuu sümaa tü süpüshikat, pa'ünüüwaweerü. ");
INSERT INTO guc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Akaajaa Satanás, müleka nujuittirüleje tü yolujaakalüirua sünain nütkaain sümaa, oo'ulaajeechi nia suulia aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nnojotsü süpüla asaajaanüin nükorolo wane wayuu eekai katsüin. Alu'ujasa müleka nüntüle wane ka'ruwarai nünainmüin eekai katsüinreein ma'i nuulia, ayamülüneechi chi wayuukai nütüma, je alü'üjüneerü tü nükorolokot nüma'anajee. Akaajaa tayaka'iya. Süka niyamülüichipain tatüma chi sülaülashikai yolujaa, tountüin tayu'lüin yolujaa. ");
INSERT INTO guc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Shiimain ma'i tü tamakat joolu'u jümüin: Eesü süpüla sülatinnüin saainjala wayuu suulia nütüma Maleiwa. Ja'itakaje mojuin sünüiki nümüin Maleiwa, eesü süpüla sülatinnüin suulia tia'aya. ");
INSERT INTO guc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Akaajasa müleka niale chi Naa'inkai Maleiwa mojuin amüin pütchi, müiria nnojolüin alatinnüin suulia tü makat, nnojotsü joolu'u je nnojoleerü mapeena”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Müsü nünüiki Jesús sümüin tü wayuukolüirua süka “Yolujaa ne'e” namüin na karalouktamaajanakana nümüin chi Naa'inkai Maleiwa chi niyu'lakai aka yolujaa. ");
INSERT INTO guc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Süntataalakalaka joolu'u tü niikat Jesús namaa na nimüliayuukana. A'atapajüshii naya yala anooipa'a sünain neenakirüin nia süka naashajaweein nümaa. ");
INSERT INTO guc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Naapinnakalaka Jesús sütüma tü wattakat saalin wayuu joyotokana nü'ütpa'a: —Naa tü püikat anooipa'a oo'ulaka na puwalayuukana. Aashajaweeshii pümaa —nümünakalaka. ");
INSERT INTO guc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Asouktüshi Jesús: —Taküjeerü joolu'u jümüin jaralüin tü teein oo'ulaka jaraliin na tawalayuuin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Je nümakalaka namüin na wayuukana napüshua sünain niirakaain namüin na wayuu joyotokana nü'ütpa'a: —Tü wayuu “teikat” je na wayuu “tawalayuukana” tamüinjanakana amüin, naya na eekai naa'inrüin waneepia tü nuluwataakat anain chi Maleiwakai maa aka naairua —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","O'ttüshi Jesús sünain ekirajaa nüchikua sotpa'a tü palaakat. Shiasa süka wattain saalii tü wayuu okotchajaakalüirua nünainmüin, no'otookalaka sulu'u wane anua sünain nüikkalaain süpüla ekirajaa yalajee shirokujee tü palaakat. ");
INSERT INTO guc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ekirajüshi nia sünain kasa wainma süka sukuaippa tü kasa e'nnaajünakat sainküin mma sünain nümüin namüin na wayuukana: “Jaapa tanüiki. ");
INSERT INTO guc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Eetaashi wane wayuu apünajüi. O'unüshi sulu'umüin tü niyüüjasekat sünain nijinain tü nuwaüyekat. ");
INSERT INTO guc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Eesü waüyee ejituukat sulu'u wopu eere shiküin shia wuchii. ");
INSERT INTO guc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eesü ejituukat sa'aka ipashira eere arülain mma. Osota müsüja'a shia mayaainje arülain tü mmakat. ");
INSERT INTO guc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Shiasa susotapa, julumaatüsü sütüma tü ka'ikat süka arülain tü mmakat süpüla tü suuralakat. ");
INSERT INTO guc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eesü ejituukat sa'aka eejatüle paala mojuui keimsesü. Shiasa süsotapa tü mojuuikat süchikua, eweeniraasü sümaa tü pünajütkat. Je oukta müsia tü pünajütkat sütüma tü mojuuikat sümaa machoin sütüma. ");
INSERT INTO guc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Alu'usa wane waüyeekat, ejituushi saa'u mma anasü. Asotüsü, emiyo'ulaasü sünain wattain saalii süchoin. Eesü eekai sujuittirüin apünüin shikii süchon sünainjee waneesia so'u, eesü eekai sujuittirüin aippirua shikii süchon sünainjee wane'eya, je eesü eekai sujuittirüin poloo shikii süchon sünainjee wane'eya”, müshi joo Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Shiasa kettaapa nünüiki Jesús, nümakalaka namüin: “Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain”. ");
INSERT INTO guc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Je wanaa sümaa nümüiwain Jesús, asakinnüshi natüma na polookana piammüin nikirajüin je wane wayuuirua nümaajana sünain jamalu'ulüin tü nikirajüitpakat anain süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nüsouktakalaka Jesús namüin: “Nnojotsü atüjaanüin aa'u paala süchiki nukuaippa Maleiwa sünain aluwatawaa. Otta müshia joolu'u, o'ttüichipa nia sünain nii'iyatüin shia jümüin jiakana tekirajüinkana. Otta na wane wayuukanairua, e'ikünüshii naya ne'e süka sukuaippa tü kasa e'nnaajünakat sainküin mma, ");
INSERT INTO guc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","süpülajatü shikeraajüin tü nünüikikat chi Maleiwakai aküjünakat paala sünain maa: ‘Ja'itatataairü ma'i naapüin otta ne'rüin, nnojottataaleerü nayaawatüin aa'u. Nnojoishii naya anoujeein tanain süpüla talatirüinjatüin naainjala noulia’, müsü nünüiki Maleiwa”. ");
INSERT INTO guc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nümakalaka Jesús namüin: “Tekirajüinapa jia sünain wane kasa süka sukuaippa tü kasa e'nnaajünakat sainküin mma. Saa'u nnojolüin jiyaawatayaain aa'u tü taküjaitpakat jümüin, ¿jamakuaippaleerü jiyaawatüin aa'u müleka shiale takuaippain tüü sünain ekirajaa jia tachikua'aya? ");
INSERT INTO guc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chi apünajüikai, nia niyaawaseka'aya chi aküjaikai nünüiki Maleiwa sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tü waüyee ejituukat sulu'u wopu, shia nakuaippa na wayuu eekai naapüin ne'e nünüiki Maleiwa. Akatsa asütünamaatüin tü pütchikat noulia nütüma Satanás suulia nanoujajüin sünain. ");
INSERT INTO guc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Je tü ejituukat sa'aka ipashira, shia nakuaippa na wayuu eekai naapüin sümaa talataa aa'in tü nünüikikat Maleiwa aküjünakat namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Müshii aka naya saa'in tü pünajüt julumaatakat, süka nanoujain ne'e motso'o. Shiasa ne'rapa müliaa sünainjee tü nanoulakat, oo'ulaa müshi'iya naya suulia anoujaa. ");
INSERT INTO guc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Je tü ejituukat sa'aka eejatüle paala mojuui keimsesü, shia nakuaippa na wayuu eekai naapüin nünüiki Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Akatsa malaüle'erüin naa'in naya sünain anoujaa sükajee shapaain naa'in saa'u tü katüinjatkat atüma no'u, saa'u tü alateetkat mapeena, je sükajee kachiiruain ma'i naa'in washirüü, tü nnojotkat kalu'uin talataa. ");
INSERT INTO guc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Otta tü waüyee ejituukat saa'u mma anasü, shia nakuaippa na wayuu aapakana nünüiki Maleiwa sümaa noonooin sümaa. Koo'omüinsü ma'i namüin na wayuukana aa'inraa kasa anasü, maa aka tü pünajütkat saa'ukat mma anasü, maa aka eekai sujuittirüin apünüin shikii süchon sünainjee waneesia so'u, eekai sujuittirüin aippirua shikii süchon sünainjee wane'eya, je eekai sujuittirüin poloo shikii süchon sünainjee wane'eya”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nümakalaka Jesús namüin: “¿Jalasü e'itaanüin wane luusa shipejaanüle? ¿E'itaanüsü cheje suupünaa wushu? Nnojo. E'itaanüsü eere süpülee luusa süpüla sünaküinjatüin kasa süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Müleka sunujunnüle wane kasa, eweeteerü süchikua. Müsüya aka tü nüchikikat chi Maleiwakai. Ja'itairü nnojolüin aküjünüin paala sümüin wayuu sainküin mmakat süpüshua, aküjüneerü joolu'u sümüin. ");
INSERT INTO guc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ayatüshi aashajaain Jesús namaa sünain namüin namüin: “Anashii müleka eere jaa'in sünain tü pütchi jaapakat. Müleka jülüjüle jaa'in tü shiimüinkat tekirajakat anain jia, jiyaawateerü aa'u tü tamüinjatkat jümüin mapeena. ");
INSERT INTO guc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi wayuu eekai jülüjain naa'in tü shiimainkat ekirajünakat anain nia, ekirajüneechi nia soo'omüin. Akaajasa chi eekai nnojolüin kasajatüin nümüin tü shiimainkat, asütüneerü nuulia tü ekirajünakat anain nia paala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aashajaashi joolu'u sümüin tü wattakat saalii wayuu: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa wane yüüja eere nüpünajüin wane wayuu sulu'u. ");
INSERT INTO guc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Je chi apünajüikai, wanaa sümaa na'atapajüin, ja'itaichi atunküin, maa'aya aka katüle no'u, osotüsia ne'e nujuuna tü nüpünajüinkat je müle'osü shia'aya sünain nnojolüin nütüjaain saa'u jamakuaippalüin. ");
INSERT INTO guc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Eweetüsü shia sümüiwa süle'eru'ujee mma. Osotüsü palajana tü süpanakat. Eweeta müsia tü süsiikat süchikijee. Je süchiki tü süsiikat, kachon müsia. ");
INSERT INTO guc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oo'ulaka jakütapa tü pünajütkat, ashannüsü süka kettaaitpain sükalia süpüla okotchajünaa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nümakalaka Jesús namüin: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? ¿Jameerü tanüiki jümüin müleka tekirajüle jia sünain süka sukuaippa tü kasa e'nnaajünakat sainküin mma? ");
INSERT INTO guc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa sü'ü tü ‘mostaza’ münakat. Mayaainje jo'uuchechoin ma'i shia wanaa sümaa süpünajünüin, ");
INSERT INTO guc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","osotüsü sütüma wane suu'ulia miyo'u. Müsia nukuaippa Maleiwa sünain aluwatawaa. Mayaainje palitchoin wayuu anoujasü joolu'u, wainmeerü so'uweena wane ka'i”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Müsü nünüiki Jesús sümüin tü wayuukolüirua sünain ekirajaa. Müleka shiyaawatüle saa'u tü nümakat sümüin, ayatshia nia ekirajüin soo'omüin. ");
INSERT INTO guc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tü nikirajakat aka tü wayuukolüirua, shia süka sukuaippa tü kasa e'nnaajünakat sainküin mma. Otta nümüiwa namaa na nikirajüinkana, nüküjain kasain kayaawasein tü naashajaakat achiki. ");
INSERT INTO guc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Je motsapa ka'i so'u ka'ikat tia sünain eein Jesús yaa sulu'u tü anuakat, —Anashii wo'unüle waneemüin sa'ata tü palaakat —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","O'otooshii na nikirajüinkana Jesús sulu'u tü anuakat eere nia joyotüin napüla süpüla o'unaa sulu'u tü anuakat suulia tü wattakat saalin wayuu. O'unüsü wane anuairua nüchiirua. ");
INSERT INTO guc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Je süma'inru'u waraittüin tü anuakat shirokupünaa tü palaakat natüma na nikirajüinkana, anta müsia joo wane wawai nanainmüin sünain shi'yotüin palaa sulu'umüin tü anuakat. ");
INSERT INTO guc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Otta müshia Jesús, atunküshi shiinalu'u tü anuakat saa'u wane ekiipalaa. Narütkaakalaka na nikirajüinkana nünainmüin: —Ekirajüikalee, püchijiraa maala. Ouktüshii taa waya. ¿Jamüshi nnojoika'a pükaaliijayaain waya suulia wüinsirajüin? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nüsha'walaakalaka Jesús sünain nüchiajaain tü wawaikat: —Jimata pia —nümakalaka sümüin. Ejimalaa müsia joo tia sütüma nünüiki. ");
INSERT INTO guc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nümakalaka Jesús namüin na nikirajüinkana: —¿Jamüshii mmotka'a jia? ¿Jamüshii nnojoliika'a jünoujüin paala sünain to'tte'erüinjanain jia suulia tü wawaikat? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ponokalaka ma'i naa'in na nikirajüinkana sünain namüin: —¿Jaraikai wayuukai chii, kache'ekai amüin wawai oo'ulaka tü palaakat? ");
INSERT INTO guc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Antüsü joolu'u tü anua kalu'ukot Jesús namaa na nikirajüinkana waneemüin sa'ata palaakat eere kepiain wane wayuuirua kanüliajüsü Gadareno. ");
INSERT INTO guc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nüshakatapa Jesús sulu'ujee tü anuakat, eejachi nüpüla wane wayuu kale'eru'ushi yolujaa. Antüshi nünainmüin sa'akajee tü amouyuukalüirua. ");
INSERT INTO guc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kepiashi nia sa'aka tü amouyuukat. Ja'itaichi kapüin atümaa nia süka kaleena sünain nütüna oo'ulaka sünain nüsa'a, nüpülajaapü'üin. Isashi nia achikii shii'iree nüta'ünnüin süpüla kapüin nia atümaa. ");
INSERT INTO guc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Warai mapü'üshi nia sa'wai je so'uka'i sa'akapünaa amouyuu je soo'opünaa uuchi sünain nu'waatüin je sünain nükashalüin tü nütakat süka ipa. ");
INSERT INTO guc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Shiasa ni'raiwa'aya Jesús ka'yatajee, awataashi nia nüpanapa sünain nu'wachiraain yaa nümülatu'umüin. ");
INSERT INTO guc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Otta müshia Jesús, —Pujuittaa nuulia —nümaja amüinrü tü yolujaakat. Emetutsü joo sünüiki tü yolujaakat nüle'eru'ukat chi wayuukai: —Jesúsuu, Nüchonka'iya Maleiwa Miyo'ushikai ma'i, ¿jamüinjatü takuaippa pütüma? Anakaja pansaale pünüiki nu'upala Maleiwa süpüla nnojolüinjatüin te'rüin tamüliala pütüma —süchuntakalaka ma'i nümüin. ");
INSERT INTO guc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Kasaichi pünülia? —nümakalaka Jesús sümüin. —Watta saalii, münüshii waya —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Achuntüsü ma'i joo tü yolujaakalüirua: —Nnojo püjütüin waya yaajee wattamüin —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eejatü wane püülüküirua wainma ekajaain maa aka tüsa saa'u wane namüna. ");
INSERT INTO guc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nachuntüin ma'i na yolujaakana nümüin Jesús: —Anakaja müleka püjütüle waya süle'eru'umüin tia püülükkalüirua —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Ju'una jümaarüleen —nümakalaka Jesús namüin. Ojuitta müsüja tü yolujaakalüirua nüle'eru'ujee chi wayuukai süpüla shikerolüin süle'eru'umüin tü püülükkalüirua. Eejatüja'a maa aka 2.000 püülükü. Apantajaayaa müsü saa'ujee tü namünakat shirokumüin tü palaakat. Oo'uwo'utkalaka shia süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na arüleejüliikana tü püülükkalüirua, apantajaashii naya sulu'umüin tü pueulokat je sainküin mma sünain aküjaa süchiki tü alatakat. ");
INSERT INTO guc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Otta na wayuu aapakana nanüiki sulu'u tü pueulokat, o'unüshii naya nünainmüin Jesús. Je nantapa nünainmüin, ne'rüin chi wayuukai ojuittinna ouliachikai yolujaa, sünain kashe'inchipain nia otta nnojolichipain mamainnain, sünain joyotüin nü'ütpa'a Jesús. Eimolojooshii naya ne'rapa nia. ");
INSERT INTO guc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Otta na wayuu eejanakana wanaa sümaa niiyajünüin chi wayuukai, naküja achikichi nia sümüin tü antüsükalüirua je süchiki tü püülükkalüirua. ");
INSERT INTO guc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Je na wayuu Gadarenokana, nachuntüin ma'i nümüin Jesús süpüla nu'unüinjachin sulu'ujee tia mmakat. ");
INSERT INTO guc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Je wanaa sümaa no'otooin Jesús sulu'umüin tü anuakat süpüla ale'ejaa Galileamüin, arütkaashi joo chi ojuittinna ouliachikai yolujaa nünainmüin shii'iree nu'uneein nümaa. ");
INSERT INTO guc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Otta müshia Jesús, niyouktüin süchiki nümaainjachin nia, sünain nümüin nümüin: —Anashi püle'ejüle püchikua pipialu'umüin sünainmüin tü püpüshikalüirua sünain püküjain süchiki tü kasa anasü naa'inrüitpakat chi Maleiwakai pümüin sünain nümüliajüin pia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O'unüshi joo chi wayuukai sulu'upünaa tü mma kanüliakat Decápolis sünain aküjaa sümüin wayuu süpüshua süchiki tü kasa anasü naa'inrüitpakat Jesús nümüin. Je ponosü ma'i saa'in tü wayuukolüirua tü nüküjakat namüin. ");
INSERT INTO guc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Shiasa mapa, ale'ejüshi Jesús nüchikua waneemüin sa'ata tü palaakat. Je chamüin cha'aya, outkajaasü wayuu watta saalin nünainmüin sotpa'a palaa. ");
INSERT INTO guc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nüntakalaka wane wayuu kanüliashi Jairo, wane laülaashi sulu'u tü ekirajüleekat tü judíokolüirua. Je ni'rapa Jesús, nüsapainyo'ukashi nia nümülatu'umüin sünain ");
INSERT INTO guc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nüchuntüin nümüin süka süpüshua naa'in sünain nümüin nümüin: —Kaalin taya püpüla, amotsojünüsü saa'in tü tachonkot sütüma wane ayuulii. Tatüjaa aa'ulu müleka pu'unüle sünainmüin sümaa pi'itaainjatüin pajapü sünain, kateerü o'u süchikua —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nu'unakalaka Jesús nümaa. Wanaa sümaa waraittüin Jesús nipialu'umüin Jairo, chentaawasü wayuu watta saalii nünain. ");
INSERT INTO guc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Je sa'aka tü wayuukolüirua, eejatü wane jierü ayuuisü. Polooirü piammüin juya amülain isha sümüin. ");
INSERT INTO guc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Müliasü ma'i saa'in sütüma tü ayuuliikat. Aja'lajaasü tü sünneetsekat so'uinnain tottoolu. Nnojotsü anayaain natüma. Ja'itairü e'rajaanüin sütüma tottoolu wainma, isasia ne'e nachiki tü ayuuliikat. ");
INSERT INTO guc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sütüma sütüjaain naa'u Jesús sünain nütüjain eiyajaa wayuu, amülü'iraasü shia sa'akajee tü wayuukolüirua nünainmüin süpüla shipettüin nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Müleka tepettüle ne'e sot nüshe'in, aneerü taya”, mapü'üsü saa'in süle'eru'u. ");
INSERT INTO guc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Je shipettapa shia, anaitpa, nnojolüitpa amülain isha sümüin. Je sütüjaaitpa aa'ut sümaa anaitpain shia süka saawalaain saa'in süle'eru'u. ");
INSERT INTO guc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nütüjaamaata aa'ulu Jesús sünain niiyajüitpain wane wayuu. Ajununajaashi nia sünain, —¿Jara epettaka tashe'in? —sünain nümüin sümüin tü wayuukolüirua wattakat saalii. ");
INSERT INTO guc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—¿Jamüshi “¿Jara epettaka tashe'in?”, pümaka'a? Watta'asa saalii wayuu chentaawakat pünain —namakalaka na nikirajüinkana nümüin. ");
INSERT INTO guc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Masütaajusai joo Jesús sünain eirakawaa sümüin tü wayuukolüirua shii'iree ni'reein tü wayuu epettakat nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sütüjaapa saa'u tü jietkat tü kasa anasü alatüitpakat sümüin, sürütkaakalaka nünainmüin Jesús sümaa momoluu sünain süsapainyo'ukain shia nümülatu'umüin. Süküjakalaka nümüin sünain shiain epettüin tü nüshe'inkat je sünain anaitpain shia nütüma. ");
INSERT INTO guc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nümakalaka Jesús sümüin: —Nii waa'iraa, anaitpa pia süka pünoujain tanain. Anasü pu'unüle sünain anain paa'in. Müiria nnojolüin müliain pia sütüma tü ayuuliikat. ");
INSERT INTO guc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wanaa sümaa naashajaain Jesús sümaa tü jietkat, süntakalaka joo wane wayuuirua nipialu'ujeejatü Jairo chi laülaashikai sulu'u tü ekirajüleekat, sünain nümüin nümüin: —Ouktüitpa tü püchonkot. Puu'ulaa suulia peenajaain chi Ekirajüikai. ");
INSERT INTO guc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Otta Jesús, nnojotsü jamajatüin nümüin tü aküjünakat natüma na wayuukana. Nümakalaka nümüin Jairo: —Nnojo piyo'ujaain aa'in. Pünouja ne'e tanain süpüla anainjatüin tü püchonkot. ");
INSERT INTO guc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Niyouktakalaka Jesús süpüleerua su'unüinjatüin tü wayuukolüirua nümaa. Na o'unakana nümaa, naya ne'e na nikirajüinkana: Pedro, Jacobo oo'ulaka Juan chi nuwalakai Jacobo. ");
INSERT INTO guc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Shiasa nüntapa Jesús nipialu'umüin Jairo, eesü wane wayuuirua a'waatüin ma'i shi'iralu'u saalii tü jintutkot. ");
INSERT INTO guc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Je nikerolopa sulu'umüin tü miichikat, —Nnojo ji'yalajüin. Tü jintutkot, nnojotsü ouktüin, atunküsü ne'e —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Otta tü wayuukolüirua, süsirajakalaka nüka Jesús sütüma tü nümakat. Nujuittirakalaka Jesús anooipa'amüin süpüshua tü wayuukolüirua. Naya ne'e ekerotoko nütüma eemüin tü müliashiikat chi süshikai oo'ulaka tü shiikat je na nikirajüinkana eejanakana nümaa. ");
INSERT INTO guc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naapaakalaka tü jintutkot süka sajapü sünain nümüin sümüin: —Talita, kumi. (Je tü pütchikat, “Tachee, püchijiraa maala, müshi taya pümüin”, malu'ut.) ");
INSERT INTO guc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Asha'walaa müsia tü jintutkot sümaa suwara'iraain. (Müitka poloo piammüin juya suuyase.) Ponusü ma'i saa'in tü wayuukolüirua tü shi'rakat. ");
INSERT INTO guc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Otta Jesús, nüchuntale'einya saapünüinjatüin eküülü sümüin tü jintutkot je ni'ita'aleein napüleerua na wayuukana sünain nnojolüinjatüin na'walakajüin süchiki sainküin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nu'unakalaka Jesús yalajee yala namaa na nikirajüinkana eemüin tü pueulo eejachire nia tepichiiwa'aya. ");
INSERT INTO guc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Je so'u tü ka'i neemeraakat o'u na judíokana, o'ttüshi nia sünain ekirajaa sulu'u tü ekirajüleekat. —¿Jarai cheje kekiika atüma chii? ¿Jarai cheje pülashika atüma süpüla aa'inraa tü nütüjakat apüleerua Maleiwa nümüiwa? —müsü wayuu wainma süka ponüin ma'i saa'in tü nümakat Jesús. ");
INSERT INTO guc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Otta waneeirua, nnojoishi kasajachin nia namüin. Asakiijirawa'ain müshii: —Watüjaa aa'uchi nia sünain niain chi a'yataaikai sümaa taapüla. Je we'raajüin María tü niikat oo'ulaka Jacobo, José, Judas je Simón na nimüliayuukana. Otta na nüshunuukana, kepiashii yaaya sulu'u tü pueulokat wanaa wamaa —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nümakalaka Jesús namüin: —Tamüshii paala jia: Müinka nüntüle wane nünüikimaajachi Maleiwa nuumainpa'amüin, mojuteechi nia sütüma tü wayuukolüirua je sütüma tü nüpüshikalüirua —müshi namüin süka mojutüin nia natüma. ");
INSERT INTO guc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Je tü manoulaa eekat nanain na wayuukana cha'aya, süta'ülüin tü kasa anasü naa'inreekat Jesús, tü nütüjakat apüleerua Maleiwa nümüiwa. Waneesia ne'e ni'itaain najapü sünain wayuu palitchon süpüla anainjatüin nütüma. ");
INSERT INTO guc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Je ainkuusü ma'i naa'in Jesús süka manoulain na wayuukana cha'aya. Shiasa süchikijee tia, o'unüshi Jesús sulu'upünaa tü pueulokat süpüshua sünain ekirajaa. ");
INSERT INTO guc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Neenakakalaka na Aluwataaushikana polooshiikana piammüin sünain nüjütüin naya piamawalin süpüla aküjaa tü nüchikikat. Naapüin laülawaa namüin süpüla ajuittiraa yolujaa suulia wayuu. ");
INSERT INTO guc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nümakalaka Jesús namüin: —Nnojo jülü'üjüin jüshe'in, jimia, jükapateetse, je jünneetse. Waneesia ne'e jülü'üjeerüin wunu'u jüshepü'üjia. ");
INSERT INTO guc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nnojo jülü'üjüin suwala'ata jüsapaatse je suwala'ata jüshe'in. ");
INSERT INTO guc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Shiasa wanaa sümaa jüntüin sulu'umüin wane pueulo, nnojolüinjatü jii'iratüin tü miichi jüntakat alu'u palajana. ");
INSERT INTO guc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Je müleka nnojoliire kapülain aa'inyüü jia sulu'u wane pueulo je shiyouktünüle tü pütchi jüküjüinjatkat sümüin, ju'unamaata suulia sünain jo'otojooin tü mmakat sünainjee juu'ui jüma'ichikü shiyaawase jümüin: “Nnojotsü wasirüitpain eekai manoujüinyeein ale saa'in ne'e”. ");
INSERT INTO guc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","No'unakalaka joo na polooshiikana piammüin sulu'upünaa tü pueulokat süpüshua sünain naküjain nüchiki Cristo sümüin wayuu shii'iree shiyaawajaainjatüin suulia saainjala. ");
INSERT INTO guc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nojuittirüin wainma yolujaa suulia wayuu je anasü suulia ayuulii tü wayuu o'yotünakat aa'u seita natüma. ");
INSERT INTO guc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Otta müshia Herodes, chi sülaülashikai mma, naapa achikichi Jesús süka wattaitpain nüchiki sainküin mma. Müsü sünüiki wane wayuu nüchiki: —Chi Jesúskai anülia, nia'aya ne'e naa'in wamüin Juan chi owoutisaajüikai, oso'iraataasü eera naa'in süchikijee ouktaa. Müshijese'e pülashin nia süpüla aa'inraa tü kasa nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shiasa süküjala waneeirua: —Niataa Elías. Otta sünüiki wane'eya: —Niataa wane nünüikimaajachi Maleiwa maa aka na nünüikimaajana namaiwajanakana. ");
INSERT INTO guc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Shiasa naapapa Herodes tia, majataasü naa'in: “¿Nia cheje eera Juan chi tashottirakalinka anulu? ¿Oso'iraasü cheje naa'in eera?” ");
INSERT INTO guc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Je nüchiki Juan wanaa sümaa nu'utinnüin aa'in paala, müsü mayaa: Eejattaa wane jierü kanüliasü Herodías, tü nu'wayuusekat Herodes. Nu'wayuuse paala Felipe chi nimüliakai. Shiasa nümapü'ükalaka Juan nümüin Herodes: “Nnojotsü anain nu'upala Maleiwa pu'wayuusein tü jierü nu'wayuusekat paala chi pimüliakai”. Je saa'ujee tia, ata'ülinnüshi Juan nütüma sümaa nüpüreesajüin. ");
INSERT INTO guc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Shiasa Herodías, su'utiree aa'inchi ma'i Juan, süka üttüin saa'in nünain. Akaisa isain süchiki ");
INSERT INTO guc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","süka niyouktajüin sümüin Herodes. Kojutshi ma'i Juan nütüma süka nütüjaain saa'u sünain naa'inrüin tü nuluwataakat anain Maleiwa je sünain nükatannüin nütüma süpüla ni'yataain nümüin. Keejiapü'üsü nümüin nünüiki mayaainje müin aka kapüleekai shia nümüin. ");
INSERT INTO guc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Süntakalaka joo wane ka'i ananuwasü saa'in sümüin Herodías süpüla su'utirüinjatüin naa'in Juan. Eejattaaja wane mi'iraa nütüma Herodes su'utpünaa nikeraajüin juya. Neenajirakalaka sünain tü mi'iraakat na laülaayuushiikana oo'ulaka na sülaülashiikana surulaat oo'ulaka na sülaülashiikana tü mmakat Galilea. ");
INSERT INTO guc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Je shikerolapa tü süchonkot Herodías sünain oyonnajaa su'upala tü wayuukolüirua, talatüsü ma'i naa'in Herodes je napüshua na wayuukana. Nümakalaka joo Herodes sümüin tü majayütkat: —Tamüsü paala pia no'upala naairua: Püchunta kee'ireekat paa'in. Müleka pücheküle süse'eru'upünaa tü mma taluwataakat alu'u, pümüinjeerü. ");
INSERT INTO guc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sujuittaakalaka tü majayütkat sünainmüin tü shiikat sünain asakiraa: —¿Kasa cheje paala tachuntaka nümüin? —sümakalaka sümüin. Süsouktakalaka tü shiikat sümüin: —Puchunta nümüin tü nikiikat Juan chi owoutisaajüshikai —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ale'ejaa müsia tü majayütkat nünainmüin Herodes sünain sümüin nümüin: —Püntira pümata tamüin sulu'u wane pülaata tü nikiikat Juan chi owoutisaajüikai. ");
INSERT INTO guc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mojukalaka ma'i naa'in Herodes sütüma tü süchuntakat. Shiasa saa'u pansaaitpain nünüiki sümüin su'upala tü wayuukolüirua, naa'inrüinjatü tü süchuntakat nümüin. ");
INSERT INTO guc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nümakalaka nümüin wane surulaat: —Pu'una nünainmüin Juan chi püreesashikai püshottaiwa nunulu. O'una müshia chi surulaatkai eemüin tü kaatsetkat süpüla naa'inrüinjatüin tü aluwataanakat anain nia. ");
INSERT INTO guc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nüntitkalaka tü nikiikat chi müliashiikai sulu'u wane pülaata sünain naapüin shia sümüin tü süchonkot Herodías. Shi'ikajaakalaka shia sümüin tü shiikat. ");
INSERT INTO guc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Otta müshi'iya na nikirajüinkana Juan natüjaapa saa'u nu'utünüin aa'in, antüshii naya sünain asaajaa chi müliashiikai süpüla ne'itaain sulu'umüin wane woowira. ");
INSERT INTO guc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ale'ejüshii joo na Aluwataaushikana polooshiikana piammüin nünainmüin Jesús sünain naküjain nümüin süchiki tü kasa naa'inrakat je süchiki tü nekirajakat anain sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Je süka süntapaayaa sümüin wayuu wainma nünainmüin Jesús namaa na nikirajüinkana, je süka mojunuain namüin eemerawaa otta ekawaa, müshi Jesús namüin: —Joo'uya tamaaiwa jia chamüin eere yüütüülin mmakat süpüla jeemeraainjanain —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","No'otookoloko namüiwa sulu'u wane anua sünain no'unüin chamüin eemüinre yüütüülin mmakat. ");
INSERT INTO guc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Shiasa tü wattakat ma'i saalii wayuu sütüjaapa naa'u Jesús je na nikirajüinkana sünain no'unüin, o'unüsü sulu'ujee tü pueulokalüirua süpüshua. Awanaajüshii sümaa nantüin nüpüleerua Jesús. ");
INSERT INTO guc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wanaa sümaa nüshakatüin Jesús sulu'ujee tü anuakat, ni'rüin tü wayuu wattakat saalii. Nümüliajakalaka shia süka walakatüin maa aka saa'in anneerü eekai memekeetsein. Nu'ttakalaka sünain ekirajaa shia sünain kasa wainma. ");
INSERT INTO guc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Shiasa motsopa ka'ikat, narütkaakalaka na nikirajüinkana nünainmüin sünain namüin nümüin: —Ekirajüikalee, yüü'üyütüüisü ma'i tü mmakat, je alü'ütsü süpüla shipiyu'ujaain. ");
INSERT INTO guc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Anasü müleka püjütüleirua su'unaiwa sulu'umüin tü pueulokalüirua je sainküin shipia wayuu nayalajaiwa tü neküinjatkat —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nüsouktakalaka Jesús namüin: —Jaapa jiakana neküin. Namakalaka nümüin: —¿Pücheküin süpüleerua wayalajüin tü wattakat saalii eküülü napüla? Ja'itayaakaje palirawalin neküin, nnojoleerü asetaain naka sujut shi'yataain wayuu so'u mekiisat kashi —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Jera pan eekat jüma'ana? Ji'rajaapa jütüjaaiwa saa'u —nümakalaka Jesús. —Ja'raisü pan je piamasü ne'e jime asijuushi eekat wama'ana —namakalaka natüjaapa saa'u. ");
INSERT INTO guc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","—Anakaja jüikkale'erüle tü wayuukolüirua saa'u tü alamakat sünain katatawalin naya —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naikkalaakalaka na wayuukana sünain ja'raiwalin je polo'owalin shikii. ");
INSERT INTO guc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naapaakalaka joo Jesús tü ja'raisükat pan je tü piamasükat jime. Niirakaakalaka iipünaamüin sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshanaajakalaka joo tü pankat süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. Akaataaja joo sukuaippa tü piamasükat jime nütümaya. ");
INSERT INTO guc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eküshii napüshuale'eya je emirashii sünainjee. ");
INSERT INTO guc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Je süchikijee, okotchajünüsü tü napütaalakat natüma na nikirajüinkana, maa aka poloo piammüin katto'ui. ");
INSERT INTO guc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eejana maa aka 5.000 tooloyuu sa'aka tü wayuukolüirua süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Shiasa mapa süchikijee tia, nüjütüin Jesús na nikirajüinkana süpüla no'unüinjanain nüpüleerua. No'otookoloko sulu'u tü anuakat sünain no'unüin namüiwa nüpüleerua waneemüin sa'ata tü palaakat, eemüin tü pueulo kanüliakat Betsaida, süma'inru'u nüpütaain Jesús süpüla tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Shiasa süchikijee nüpütaain süpüla, o'unüshi Jesús nümüiwa saa'umüin wane namüna süpüla aashajawaa nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Je motsapa ka'i, eeshi nia nümüiwa saa'u tü namünakat. Otta müsia tü anua kalu'ukot na nikirajüinkana, wattasü shia suulia tü mmakat. ");
INSERT INTO guc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ni'rakalaka na nikirajüinkana cha'aya pasanain sünain tü palaakat sünain müliain naya sünain apalainkajaa süka katsüin tü jouktaikat napanapa. Shiasa maa aka eeiwa'aya aikat, o'unüshi Jesús nanainmüin na nikirajüinkana sünain waraittüin nia soo'opünaa tü palaakat. Alatüshi Jesús sü'ütpünaa tü anuakat. ");
INSERT INTO guc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Shiasa ne'rapa Jesús sünain waraittüin nia soo'opünaa tü palaakat, —Epeinjaasü kasa wapüla ne'e —namakalaka sünain na'waatüin sümaa mmoluu sheema tü ne'rakat. Nüsouktamaatakalaka Jesús namüin: —Nnojo mmolüin jia, jüchechera jaa'in. Taya tayakalin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","No'otookoloko sulu'umüin tü anuakat nanainmüin na nikirajüinkana je ejimalaa müsia tü jouktaikat. Ponokoloko ma'i naa'in na nikirajüinkana tü kasa ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Otta nnojoliyülia nayaawatüin aa'u tü nikirajeekat anain Jesús wanaa sümaa nikirüin tü wayuukalüirua pan, sükajee nnojolüin jülüjüin naa'in jamalu'ulüin tia. ");
INSERT INTO guc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Je nantapa waneemüin sa'ata tü palaakat, antüshii naya sulu'umüin wane mma kanüliasü Genesaret. Nasha'wale'etkalaka tü anuakat sotpa'amüin tü palaakat cha'aya. ");
INSERT INTO guc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Shiasa nashakatapa sulu'ujee tü anuakat, ayaawatünüshi Jesús sütüma tü wayuukolüirua kepiakat cha'aya. ");
INSERT INTO guc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Suwataakalaka sainküinpünaa tü mmakat sünain süntirüin wayuu eekai ayuulin saa'u suju'lejia nünainmüin Jesús eepünaale nia. ");
INSERT INTO guc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Je ne'itaain tü ayuuisükalüirua eepünaale nu'unüin sulu'upünaa tü pueulokalüirua je sainküinpünaa tü mmakat. Je nachuntüin nümüin Jesús shii'iree shiain nepettüin ne'e na ayuuishiikana sot nüshe'in. Anakalaka nütüma napüshua'aya na eekai nepettüin nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Antüshii no'utku na fariseokana oo'ulaka na karalouktamaajanakana chajee Jerusalénjee eemüin Jesús. Akotchajaashii naya süpüla arütkawaa nünainmüin, ");
INSERT INTO guc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","süka ne'nnapü'üin na nikirajüinkana Jesús natüma sünain ekawaa sümaa mo'lojooin najapü, süka shiain wuleinjatüin atüma sukuaippa wayuu nu'upala Maleiwa naashin. ");
INSERT INTO guc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Oo'ulaka nakuaippa na fariseokana je na wayuu judíokana napüshua, müleka nnojorule no'lojooin najapü süpüla wuleinjatüin nakuaippa nu'upala Maleiwa, nnojoliishii naya eküin. Shia'aya nakuaippa na natuushikanairua napüleerua. ");
INSERT INTO guc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tü eküülü nayalajakat metkaaralu'u, müleka nnojorule no'lojooin shia, nnojotsü neküin. Je naa'inrüin wainma nakuaippa na natuushinuukana napüleerua, maa aka no'lojooin iita, amüchi, wushu, oo'ulaka neinasepala.) ");
INSERT INTO guc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Namakalaka joo na fariseokana oo'ulaka na karalouktamaajanakana nümüin Jesús: —¿Jamüshii na pikirajüinkana moonooinka'a naya sümaa tü ekirajünapü'ükat anain waya natüma na watuushinuukana? Nnojoliikalaka no'lojooin najapü süpüla ekaa, maa aka wayakana, süpüla wuleinjatüin nakuaippa nu'upala Maleiwa —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nüsouktakalaka Jesús namüin: —Alaayuukana cheje ma'i jia. Lotüsü ma'i nünüiki Isaías jüchiki, chi nünüikimaajachikai Maleiwa, sünain nümüin mayaa: “Kojutuyaashi taya natüma na wayuukana süka nanüiki ne'e, nnojoittaapa'a kojutüin taya natüma süka süpüshua naa'in. ");
INSERT INTO guc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tü namapü'ükat sünain na'waajüin taya naashin, nnojotsü kasain saamüin tamüin. Je nekirajüin wayuu sünain pütchi nale'eru'ujeejatü ne'e, nnojotsü nekirajüin anain tü taluwataakat anain”, müsü nünüiki Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jiyouktüin tü nuluwataakat anain Maleiwa süpüla joonooinjatüin sümaa tü shikirajapü'ükat anain wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Müshi Jesús namüin: —¿Jamakalaka shiaka'a ne'e jaa'inrüin tü nekirajapü'ükat anain jia na jutuushikana, nnojottaapa'a shiain joonooin amaa tü nuluwataakat anain Maleiwa? ");
INSERT INTO guc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Soto jaa'in sünain juluwataanüin nütüma Moisés sünain kojutüinjachin jütüma jüshi oo'ulaka jii, je chi eekai e'rülin wayumüin nümüin nüshi oo'ulaka sümüin nii, o'utinnajachi aa'in nia. ");
INSERT INTO guc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Otta saashin tü nekirajapü'ükat anain na jutuushikana, eeshii süpüla namüin na wayuukana namüin na kachooinkana naya: “Nnojoleena jia tasülajüin amüin joolu'u süka taapüitpain shia nümüin Maleiwa”. ");
INSERT INTO guc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Je sükajee tia, ju'wanajaaitpa tü nuluwataakat anain Maleiwa sütümajee ju'unüin süchiirua tü nekirajapü'ükat anain na jutuushikana. Je wainma kasa jaa'inrüin eekai müin aka tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nuuneküin Jesús nachikua na wattakana naalii wayuu nünainmüin sünain nümüin namüin: —Jaapaja jumaala tanüiki jüpüshua jiyaawataiwa saa'u tü tekirajeekat anain jia. ");
INSERT INTO guc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nnojotsü shiain yarüttüin atüma sukuaippa wane wayuu nu'upala Maleiwa tü kasa ekerotkat saanükülu'upünaa. Shia yarüttaka atüma sukuaippa nu'upala Maleiwa tü pütchi mojulu'ut ojuittakat saanükülu'ujee je tü kasa mojusü saa'inrakat. ");
INSERT INTO guc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Shiasa nu'unapa Jesús suulia tü wattakat saalin wayuu, ekerotshi nia sulu'umüin wane miichi. Nasakirakalaka nia na nikirajüinkana sünain jamalu'ulüin tü nüküjaitpakat achiki sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Nüsouktakalaka Jesús ne'ipajee: —¿Nnojoliyütta'aya jiyaawatüin aa'u tü tekirajakat anain jiakanaya? Tamüshii paala jia jüchikua: Tü ekerotokot sulu'upünaa saanükü wane wayuu, süle'eru'umüinjatü ne'e sünain shiyu'laain süchikua suulia. Nnojotsü yarüttüin nukuaippa nu'upala Maleiwa sütüma süka nnojolüin shikerolüin sulu'umüin tü naa'inkat —nümakalaka namüin. (Sütüma tü nümakat Jesús, sütüjaaitpa aa'u wayuu sünain anain no'ulu'u Maleiwa tü eküütkat süpüshua süpüla ekünaa.) ");
INSERT INTO guc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ayatshi Jesús aashajaain namüin: —Tü pütchi mojulu'ut ojuittakat sulu'upünaa jaanükü, je tü kasa mojusü jaa'inrakat, shia yarüttaka atüma jükuaippa nu'upala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Je müleka yarüttüle naa'in wane wayuu, kachiiruasü naa'in waneepia kasa mojusü, maa aka a'luwajirawaa akuaippaa sümaa wayuu jierü otta wane jierü nümaa wane toolo, maa aka a'luwajaa, maa aka o'utaa saa'in wayuu, maa aka ama'üjawaa sümaa wayuu nnojotkat nu'wayuusein otta nnojoikai su'wayuusein, ");
INSERT INTO guc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","maa aka kachiiruaa aa'inyüü washirüü, maa aka kanain aa'inyüü wayuu, maa aka aküjaa alawaa, maa aka yarüttaa aa'inyüü sümaa jieyuu, maa aka kachumulaa sükorolo wayuu, maa aka mojaa anüiki sümüin wayuu, maa aka pülaa aa'inyüü suulia wayuu, je maa aka maa'inyuwaa aa'in. ");
INSERT INTO guc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Süpüshua tü aainjalaa eekai müin aka tüü, naa'inrüin na wayuukana süka yarüttüin naa'in. Shia yarüttaka'aya atüma nukuaippa wane wayuu nu'upala Maleiwa —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Shiasa mapa süchikijee tia, o'unüshi Jesús namaa na nikirajüinkana yalajee yala Genesaretjee sulu'umüin tü mmakat kalu'ukot tü pueulokalüirua Tiro oo'ulaka Sidón. Je cha'aya, nikerotakalaka sulu'umüin wane miichi. Niyouktakalaka süchiki sütüjaainjatüin wayuu naa'u. Otta isasü nüchiki nunujulaain suulia wayuu nüntapa cha'aya sa'akamüin. ");
INSERT INTO guc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Eekalaka wane jierü kepiasü cha'aya aashajaasü pütchi griego. Sirofeniciaje'ewat shia. Kale'eru'usü yolujaa süchon tü wayuukot. Je sütüjaapa naa'u Jesús sünain nüntüin, antüsü shia nünainmüin sünain süsapainyo'ukain nümülatu'u sünain süchuntüin süka süpüshua saa'in shii'iree nujuittirüinjatüin tü yolujaakat suulia tü süchonkot. ");
INSERT INTO guc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nümakalaka Jesús sümüin tü jietkat: —Emirainjana palajana süchooin wane wayuu. Nnojotsü anain müleka saapünüle tü shiküinjatkat sümüin tü etkalüirua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sümakalaka nümüin: —Aa, shiimüin Ekirajüikalee, ayatapaja'aya ne'e a'lumujüin chi etkai tü ojutuusükat saa'ujee nemeesain na ekaashiikana —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nümakalaka Jesús sümüin: —Tamüsü paala pia: Anakaja müleka püle'ejüle pipialu'umüin. Anaitpa tü püchonkot saa'ujee tü pümakat tamüin, ojuittüitpa tü yolujaakat suulia. ");
INSERT INTO guc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Su'unakalaka joo tü jietkat shipialu'umüin sünain eein süpüla tü süchonkot sulu'u su'ula sünain anaitpain shia. Nnojolüitpa tü yolujaakat sünain. ");
INSERT INTO guc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Shiasa süchikijee tia, nu'unakalaka Jesús sulu'ujee tü mmakat kalu'ukot tü pueulokat Tiro. Alatüshi nia sulu'upünaa tü pueulokat Sidón süpüla nüntüinjachin eemüin tü palaakat Galilea. Je chajee cha'aya, o'unüshi nia eemüin tü mma kanüliakat Decápolis. ");
INSERT INTO guc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nüntinnakalaka nünainmüin Jesús wane wayuu mache'esai. Kapüleesü nümüin aashajawaa. Nachuntakalaka na wayuu antitshiikana nümüin Jesús shii'iree ni'itaain najapü nünain süpüla anainjachin nia nütüma. ");
INSERT INTO guc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Najattakalaka Jesús chi wayuukai sa'akajee tü wayuukolüirua. Ni'itaakalaka nejepira sulu'u nüche'e chi wayuukai. Nejetakalaka saa'u nejepira sünain nushulerüin sünain niyee chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Niirakaakalaka Jesús iipünaamüin nümüin Maleiwa sünain süsanalüin naa'in. Nümakalaka nümüin chi wayuukai: “Efata”. (“Jutata mata püche'e”, malu'ut tia.) ");
INSERT INTO guc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Je wanaa ma'i sümaa tia, aapatüjü'iya je analeesia naashajaaya. ");
INSERT INTO guc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Otta müshia Jesús, nüchiajaakalaka na wayuukana suulia na'walakajüin süchiki tü ne'rakat. Mayaainje achiajaanüin naya suulia aashajawaa, yooto'oin müshii süchiki ");
INSERT INTO guc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","süka ponoin ma'i naa'in tü ne'rakat. “Anashaatasü ma'i süpüshua tü naa'inrakat Jesús. Chi eekai mache'ein, kache'eshi nütüma. Chi eekai manülin, kanüishi nütüma”, müshii naya sünain yooto'oin namüin sainküin mma. ");
INSERT INTO guc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sürütkaakalaka wane wayuuirua watta saalii nünainmüin Jesús. Je saa'u nnojolüin eküülü nama'ana, nuunejakalaka joo Jesús na nikirajüinkana nünainmüin sünain nümüin namüin: ");
INSERT INTO guc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Tamüliajee amüinrü tü wattakat saalii wayuu süka apünüinrüin ka'i tü kettatkat naa'u sünain tamaain naya. Je aja'lajaaitpa tü nemiakat. ");
INSERT INTO guc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tacheküin süpüleerua neküinjanain nama'ichiki. Müleka tajütüle naya sünain ouktüin jamü, eeshii süpüla nawalejünüin wopulu'u, süka eein na'aka wayuu eekai wattajeejatüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Namakalaka na nikirajüinkana: —Nnojotsü kasain eein yaaya. ¿Jalajeekualüinjatkai wapüla tü eküülü shikajatkat watüma tü wattakat saalii wayuu? ");
INSERT INTO guc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Jera pan eekat jüma'ana? —nümakalaka Jesús. —Akaratshisü ne'e pan eekat yaaya —namakalaka ni'ipajee. ");
INSERT INTO guc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nuluwataakalaka Jesús tü wattakat saalii wayuu sünain süikkalaainjatüin mmalu'u. Naapaakalaka joo Jesús tü akaratshisükat pan sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshanaajakalaka joo shia süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eejatüja'a nama'ana palitchon ne'e jime asijuushiya. Naapüin analu'ut nümüin Maleiwa saa'u tü jimekalia sünain nüshanaajain shia süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eküshii naya napüshuale'eya je emirashii sünainjee. Je süchikijee, okotchajünüsü tü napütaalakat natüma na nikirajüinkana, maa aka akaratshi katto'ui. ");
INSERT INTO guc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eejana maa aka 4.000 tooloyuu sa'aka tü wayuukolüirua süpüshua sünain mayaawajuin na jieyuu oo'ulaka na tepichi eejanakana. Je kettaapa shiküin tü wayuukolüirua, nümakalaka Jesús namüin: —Anashii ju'unüle jipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Je Jesús, o'otooshi nia namaa na nikirajüinkana sulu'u wane anua sünain o'unaa eemüin wane mma kanüliasü Dalmanuta. ");
INSERT INTO guc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nantakalaka na fariseokana nünainmüin Jesús süpüla nasakirayaainjachin nia shii'iree niweetirüin wane pütchi kasalajanajatkat nümüin natüma. Nachuntayaain nümüin naa'inrüinjatüin no'upala wane kasa eekai anashaatain nütüjakat apüleerua Maleiwa nümüiwa, tü ee'iyatüsüjatkat nukuaippa sünain nüjünalain nia Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nümakalaka namüin sünain süsanalüin naa'in: —Aisha'ajaa wayuu naaja'a maa'utpünaa yaa. ¿Jamüsü taa'inreeka'a jütüma wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa, tü ee'iyatüsüjatkat takuaippa sünain nüjünalain taya Maleiwa? Shiimüin tü tamakat jümüin: Nnojoleerü taa'inrüin tü juchuntakat tamüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Shiasa süchikijee tia, nu'unakalaka noulia sünain no'otooin nüchikua sulu'u tü anuakat sünain o'unaa waneemüin sa'ata tü palaakat. ");
INSERT INTO guc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Otta na nikirajüinkana Jesús, sotüitpa naa'in joolu'u sünain malü'üjain naya pan. Waneesia ne'e eejatkat nama'ana yaa sulu'u tü anuakat. ");
INSERT INTO guc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nüchiajaataalakalaka naya sünain maa namüin: —Jalia jia suulia tü oolojiakat pan nama'anajeejatkat na fariseokana oo'ulaka tü nüma'anajeejatkat Herodes —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Namajiraakalaka sütüma tü nümakat Jesús: —Shiakajasa'a nümüin süka motüin waa'in tü pankat —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Je sükajee nütüjaain saa'u Jesús tü naashajaajiraakat achiki, müshi nia namüin: —¿Jamüshii jaashajaajiraaka'a süchiki sünain nnojolüin pan jüma'ana? ¿Nnojoliyüttaaja'a jiyaawatüin aa'u tü tekirajeekat anain jia? ¿Nnojoliyüttaaja'a jülüjüin jaa'in jamalu'ulüin tü taa'inrakat paala sünain tekirüin wayuu süka tü pankat? ");
INSERT INTO guc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ja'itaina ko'uin jia, nnojoliishii jia e'rüin. Ja'itaina kache'ein, nnojoliishii jia aapüin. Soto jaa'in wanaa sümaa ");
INSERT INTO guc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tekirüin 5.000 wayuu süka tü ja'raisükat pan. ¿Jera katto'ui tü süpütaalakat? —nümakalaka namüin. —Poloo piammüin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Je soto jaa'in wanaa sümaa tekirüin 4.000 wayuu süka tü akaratshisükat pan. ¿Jera katto'ui tü süpütaalakat? —nümakalaka namüin. —Akaratshisü —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Nnojoliyüttaaja'a jiyaawatüin aa'u tü tekirajeekat anain jia? —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Antüshi Jesús namaa na nikirajüinkana sulu'umüin tü pueulo kanüliakat Betsaida. Süntirakalaka wane wayuuirua wane wayuu mo'usai nünainmüin sünain süchuntüin nümüin shii'iree ni'itaain najapü nünain süpüla anainjachin nia nütüma. ");
INSERT INTO guc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Najattakalaka Jesús chi mo'usaikai süka najapü anooipa'a suulia tü pueulokot. Shiasa süchikijee ni'itaain nuwaa sünain no'u chi mo'usaikai sümaa ni'itaain najapü nünain, nüsakirakalaka nia: —¿Kasa pi'raka, waa'iraa? ");
INSERT INTO guc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eirakawa'ain müshi chi wayuukai: —E'tshi taya wayuu maa aka saa'in wunu'u eekai waralimuuin —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ni'itaakalaka Jesús najapü nüchikua sünain no'u chi wayuukai. Ko'uichipa joolu'u chi mo'usaipü'ükai. Eirakawa'ain müshi nia sünain ja'yain süpüshua nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nümakalaka Jesús nümüin: —Anashi pu'unüle pipialu'umüin sünain nnojolüin püküjainjatüin joolu'u püchiki yaa sulu'u tü pueulokat Betsaida —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nu'unakalaka joolu'u Jesús namaa na nikirajüinkana eemüin tü pueulokalüirua cha'aya sulu'u tü mmakat sü'ütpa'a Cesarea de Filipo. Je wopulu'u, nümakalaka Jesús namüin: —¿Jarai taya saashin tü wayuukolüirua? ");
INSERT INTO guc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nasouktakalaka ni'ipajee: —“Niataa Juan chi owoutisaajüikai”, müsü waneeirua. “Niataa Elías”, eesü makat. “Niataa no'uluku na nünüikimaajanakana Maleiwa paala sümaiwa”, eesü makat ne'e —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Jama jiakana, ¿jarai taya jaajüin? —nümakalaka namüin. Nüsouktakalaka joo Pedro nümüin: —Pia Cristoka'aya, chi Nüneekajalakai Maleiwa süpüla o'tte'eraa wayuu —nümakalaka Pedro. ");
INSERT INTO guc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ni'ika aa'inchii joo Jesús na nikirajüinkana sünain nümüin namüin: —Nnojo jüküjüin tachiki sümüin wayuu sünain tayain Cristo chi Nüneekajalakai Maleiwa —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nu'ttakalaka Jesús sünain ekirajaa na nikirajüinkana süchiki süpüshua tü aa'inneetkat nüka mapeena sünain nümüin namüin: “Nücheküin chi Maleiwakai süpüleerua müliainjachin ma'i tayakai, chi Shipayakai Wayuu. Ayouktüneechi taya natüma na laülaayuushiikana naa'u na judíokana, oo'ulaka natüma na laülaayuushiikana na'akajee na sacerdote judíokana, oo'ulaka natüma na karalouktamaajanakana. O'utinneechi aa'in taya natüma. Je so'u apünüin ka'i süchikijee tia, oso'ire'enneechi aa'in taya”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ja'yashitpa joo tü nünüikikat namüin, nnojolüitpa nunujulüin achiki noulia. Najattünakalaka Jesús nütüma Pedro mamüin aka türa süpüla nüchiaainjachin nia. ");
INSERT INTO guc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nujununujaakalaka Jesús nuulia Pedro sünain niirakaain namüin na nikirajüinkana. Nüchiajaakalaka Pedro sünain nümüin nümüin: —Nünüikimaajachi pia Satanás, ko'uta ne'e pia toulia. Tü jülüjakat paa'in, püle'eru'ujeejatü ne'e, nnojotsü shiain tü ni'inaajalakat paala chi Maleiwakai tapüleerua —nümakalaka Jesús nümüin Pedro. ");
INSERT INTO guc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Neenakakalaka tü wattakat saalin wayuu oo'ulaka na nikirajüinkana nünainmüin sünain maa namüin: —Chi wayuu eekai tamaweein, anakaja müleka nnojorule naa'inrüin tü nüchekakat ne'e nümüiwa. Shia anaka alu'u müleka naa'inrüle waneepia tü nüchekakat Maleiwa nüpüleerua, sümaa nnojolüin mmolüin sheema o'utinnaa aa'in saa'u noonooin sümaa tanüiki. ");
INSERT INTO guc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chi eekai niyouktüin taya süka naa'inmajiraweein nukuaippa suulia ouktaa, amülouijeerü nukuaippa süpüshua. Otta chi wayuu eekai naapajiraain nukuaippa süpüla ni'yataainjachin tamüin sünain aküjaa tachiki, mayaashije o'utüneechin aa'in sünainjee tia, ayateechi o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Maja'a aka chi eekai niyouktüin taya süka washireein nia, amülouijeerü tü nukuaippakat süpüshua, süka nnojolüin suuntüin tü nuwashirüinkat süpüla su'tte'erüin nia. ");
INSERT INTO guc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Je maa'ulu yaa, shiimüin sünain kaainjalain wayuu süpüshua je sünain shiyouktüin Maleiwa. Alu'ujasa so'u chi ka'i tale'ejeechikai o'u tayakai, chi Shipayakai Wayuu, chajee eejee chi Tashikai Maleiwa, warattuuleerü tü mmakat, süka eeinjanain na aapiee nüma'anajeejanakana Maleiwa tamaa. Je chi eekai nnojolin jamajachin taya nümüin maa'ulu yaa, chi eekai japülin süka tanüiki, nnojoleechi jamajachin tamü'inya so'u ka'ikat tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ayatshia aashajaain Jesús namüin na nikirajüinkana: —Shiimüin tü tamakat jümüin: Ana'aya ju'utku jia yaakana maa'ulu yaa nnojoleenakana ouktüin süpülapünaa ji'rüin nu'ttüin Maleiwa sünain aluwatawaa sünain pülashaatain ma'i nia —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Je mapa aippirua ka'i süchikijee tia, neenajaakalaka Jesús apünüinshii na nikirajüinkana: Pedro, Jacobo oo'ulaka Juan, süpüla no'unajanain nümaa namüiwa eemüin wane uuchi. Je chamüin cha'aya, ee'iranajaasü nukuaippa Jesús no'upala. ");
INSERT INTO guc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jorottokalaka ma'i nüshe'in sünain alana'aleein sünain kasuuin ma'i maa aka saa'in kuluulu eekai anain ma'i süshijaaya. ");
INSERT INTO guc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eweenaa müshi'iya no'upala wane piamashii wayuu sünain naashajaain nümaa Jesús: nia Elías oo'ulaka Moisés, na nünüikimaajanakana Maleiwa paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nümakalaka joo Pedro nümüin Jesús: —Ekirajüikalee, anasü ma'i süka we'rüitpain tü kasa alatakat wo'upala. Anasü müleka wakumajüle apünüinsü luma: wane püpüla, wane nüpüla Moisés, je wane nüpüla Elías —müshi nümüin Jesús ");
INSERT INTO guc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","sünain nnojolüin nütüjaain saa'u tü nümajatkat süka sainkuuin ma'i naa'in sütüma tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wanaa sümaa naashajaain Pedro, eweetalaa müsü wane siruma nanainmüin. Süsouktakalaka wane pütchi sa'akajee tü sirumakat: “Anii chi Tachonkai aishikai tapüla. Jüüjüü jümata sümüin nünüiki”, sümakalaka tü pütchikat namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eirakaa müshi'iya joo naya sünain nnojoliinapain ne'rüin na piamashii nünüikimaajanakana Maleiwa. Nia'ala Jesús nümüiwa ne'raka. ");
INSERT INTO guc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Je wanaa sümaa nashakatüin saa'ujee tü uuchikat, ni'ika aa'inchii Jesús na apünüinshiikana nikirajüin sünain nümüin namüin: —Nnojo jüküjüin süchiki tü kasa ji'rüitpakat wane'ere'eya jüküjüin taso'iraapa aa'in süchikijee ouktüin taya, chi Shipayakai Wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Noonoo amaat joolu'u tü nuluwataaitpakat anain Jesús naya. Otta asakiraajiraashii naya soo'opünaa jamalu'ulüin tü nümakat Jesús sünain “süso'iraainjatüin taa'in” makat. ");
INSERT INTO guc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nasakirakalaka nia: —¿Jamüshii naküjaka'a na karalouktamaajanakana nüchiki Elías sünain niainjachin antüin palajana nüpüleerua chi Cristo Nüneekajalakai Maleiwa? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nüsouktakalaka Jesús namüin: —Shiimüin sünain niain Elías antüin palajana nüpüleerua Cristo sünain anouktaa sukuaippa wayuu süpüla kapülainjachin nia naa'in. Otta joolu'u, tasakirüin paala jia: ¿Jamüsü süshajünaka'a paala tachiki tayakai, chi Shipayakai Wayuu, sünain müliainjachin taya sümaa tayouktünüin sütüma wayuu? ");
INSERT INTO guc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tamüshii paala jia: Antüichipa Elías, je e'rüliishii wayumüin na wayuukana nümüin, maa aka tü sümakat tü ashajuushikat nüchiki paala —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nantapa nanainmüin na waneeirua nikirajüinkana, ne'rüin wane wayuu karalouktamaajanakana sünain na'ülüjaajiraain namaa pasanain sünain watta saalii wayuu. ");
INSERT INTO guc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Talatakalaka ma'i saa'in tü wayuukolüirua süpüshua'aya shi'rapa Jesús je awataashii naya nünainmüin sünain asakaa. ");
INSERT INTO guc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—¿Kasa jü'ülüjaajiraaka achiki namaa? —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nüsouktakalaka wane wayuu sa'akajee tü wayuukolüirua sünain maa: —Ekirajüikalee, anii tachon tasaajüin pümüin. Manüisai nia sütüma wane yolujaa nüle'eru'ukot. ");
INSERT INTO guc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Müliasü ma'i naa'in wanaa sümaa nu'kchichijaain sünain nujutuupü'üin mmolu'u sütüma. Komokoinshi naanükülu'u oo'ulaka kepishanasü nai sümaa ichein ma'i nia sütüma. Tachuntayaainje'e namüin na pikirajüinkana shii'iree nayu'leein tü yolujaakat nuulia. Isasü nachiki —nümakalaka chi wayuukai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nümakalaka Jesús sümüin tü wayuukolüirua süpüshua: —Jiakana manoujüinyeekana tanain, jia e'rüliikana wayumüin tamüin, wattairü süma'a ta'atapajüin jia shii'iree jünoujeein tanain. ¿Joujeena jülaüle'etka aa'in sünain anoujaa? —nümakalaka namüin. —Püche'era chira püchonkai —nümakalaka nümüin nüshi chi jintüikai. ");
INSERT INTO guc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","No'unirakalaka chi jintüikai nünainmüin Jesús. Shiasa shi'raiwa'aya Jesús tü yolujaakat, o'kchichijawa'ain müshi chi jintüikai sütüma. Oo'ulaka yalapa nia mmalu'u, apalasijaashi je komokoinshi nia sütüma. ");
INSERT INTO guc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nümakalaka Jesús nümüin nüshi chi jintüikai: —¿Jerairü sükalia sünain eein nünain tüü? Nümakalaka chi nüshikai: —Jo'uuiwajachia müin nia sütüma. ");
INSERT INTO guc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ojutu'uwaishi nia sütüma so'u siki je shiroku wüin shii'iree su'uteein naa'in. Tachuntüin paala pümüin, müleka painküle pükaaliijain waya, pükaaliija waya —müshi nia nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nümakalaka Jesús nümüin: —¿Jamüsükai pünüiki tamüin “müleka painküle”, pümakalaka? Chi eekai anoujain nünain Maleiwa, nnojotsü kasain isain nüchiki —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nümakalaka nümüin Jesús: —Anoujaichipa taya pünain, anakaja pükaaliijüle taya süpüla katsüin tanoula pünain waneepia —müshi. ");
INSERT INTO guc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Shiasa ni'rapa Jesús tü wattakat saalin wayuu arütkaain nanainmüin, naa'ayajaakalaka saa'in tü yolujaakat suulia tü saa'inrakat nüka chi jintüikai sünain maa: —Yolujawaa, pia manüikat atüma wayuu, pia mache'ekat atüma wayuu, pujuitta nuulia chi jintüikai. Nnojo piitaain piantua püchikua —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sujuittakalaka tü yolujaakat sünain su'waatüin. O'kchichijaashaatashi ma'i chi jintüikai sütüma sujuittapa. —Ouktüichipa nia —sümakalaka wainma tü e'rajüsükalüirua süka müin aka nia nukuaippa wane eekai ouktüin. ");
INSERT INTO guc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naapaakalaka Jesús najapü chi jintüikai süpüla nüsha'wale'erüin nia süka anaichipain joolu'u. ");
INSERT INTO guc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Shiasa süchikijee nikerolüin Jesús sulu'u wane miichi, narütkaakalaka na nikirajüinkana nünainmüin namüiwa sünain nasakirüin nia: —¿Jamüsü nnojotka'a wountüin wayu'lüin tü yolujaakat nuulia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Otta yolujaa eekai müin aka tü tojuittirüitpakat nuulia chi jintüikai, nnojoleerü ojuittüin müleka nnojorule jüchuntüin nümüin Maleiwa sümaa jaamüjüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","O'unüshi Jesús namaa na nikirajüinkana yalajee yala sulu'upünaa tü mmakat Galilea. Nnojotsü nücheküin süpüleerua sütüjaain wayuu naa'u sünain chain nia, ");
INSERT INTO guc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","süka nümüiwa'ajeein sünain ekirajaa na nikirajüinkana. Nümakalaka namüin: —Tayakai, chi Shipayakai Wayuu, aapüneematüichi ekii taya sajapulu'umüin wane wayuuirua. O'utinneechi aa'in taya natüma. Je so'u apünüin ka'i süchikijee tia, oso'ire'enneechi aa'in taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Otta na nikirajüinkana, nnojotsü nayaawatüin aa'u tü nümakat namüin. Je eimolojooshii ne'e naya seema nasakirüin nia sünain. ");
INSERT INTO guc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Antüshi Jesús namaa na nikirajüinkana sulu'umüin tü pueulokot Capernaum. Je nekerolopa sulu'umüin tü miichikat, nümakalaka namüin: —¿Kasa jü'ülüjaaka aalii sulu'u tü wopukot? —müshi. ");
INSERT INTO guc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Otta na nikirajüinkana, ko'utüshii naya süka shiimain na'ülüjaain wopulu'u soo'opünaa jaralin miyo'ujachin na'aka sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nüikkalaakalaka Jesús sünain nuuneküin nünainmüin na polookana piammüin nikirajüin sünain nümüin namüin: —Chi wayuu eekai nücheküin laülaweein sa'aka wayuu, acheküshi müinjachin aka wane achepchiee sünain jüüjüwaa sümüin wayuu —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Neenajakalaka Jesús wane jintüi nünainmüin pasanain nanain na nikirajüinkana. Naapaakalaka nia nütünalu'umüin sünain maa namüin na nikirajüinkana: ");
INSERT INTO guc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Chi wayuu eekai kamaneein sümüin wane wayuu saa'u nünoujain tanain, maa aka kamaneein taya nümüin jintüikai chii, kamaneeshi nia tamü'inya wanaa sümaa. Je saa'u kamaneein nia tamüin, kamaneeshi nia nümüin chi kajünalakai taya'aya —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nümakalaka Juan: —Ekirajüikalee, eeshi we'rüin wane wayuu ayujashi yolujaa süle'eru'ujee wayuu süka pülashin nia naajüin pütüma. Woo'ule'erakalaka nia suulia süka nnojolin wamaajachin nia —müshi nia nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Juu'ulaapa ne'e —nümakalaka Jesús. —Chi eekai naa'inrüin wane kasa anasü, tü nütüjakat apüleerua Maleiwa nümüiwa, süka pülashin nia naajüin tatüma, nnojoleerü mojuin nünüiki tamüin mapeena. ");
INSERT INTO guc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Eekai nnojolin wa'ünüüin, wapüshi. ");
INSERT INTO guc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tamüshii paala jia: Chi eekai kamaneein jümüin sünainjee jiain tapüshin, taya Cristokai anülia, maa aka nüsülajüle ne'e wüin jüsüin, shiimüin sünain nuwalaajüneechin nütüma Maleiwa sükajee tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nümakalaka Jesús namüin na nikirajüinkana: “Müleka kaainjarale sütüma wayuu wane anoujashi, maa aka jiakana, anashi müleka nujutinnüle chia wayuukai shirokumüin tü palaakat sünain kanutpünaainjachin nia wane ipa miyo'u süpüla wattainjachin nia shiinalu'umüin. ");
INSERT INTO guc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jalia pia suulia kaainjalaa sükajee tü kasa paa'inrakat süka pajapü. Anasüje ne'e shiale amüloulin puulia waneesia pajapü sünain pikerolüin nüma'anamüin Maleiwa suulia pikerolojüin Hadesmüin sümaa tü piamasükat pajapü, chaa eemüinjachire pujutünüin sa'akamüin tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Oo'ulaka chamüin cha'aya, mülieerü ma'i wayuu süpüla ka'ikat süpüshua, süka matüjüin ouktaa tü jokomakalüirua sünainkat, je matüjüin ayokujawaa tü sikikat. ");
INSERT INTO guc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Je jalia pia suulia kaainjalaa sükajee tü kasa paa'inrakat eepünaale su'unirüin pia tü puu'uikat. Anasüje ne'e shiale amüloulin puulia waneesia puu'ui sünain pikerolüin nüma'anamüin Maleiwa suulia pikerolojüin Hadesmüin sümaa tü piamasükat puu'ui, chaa eemüinjachire pujutünüin sa'akamüin tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mülieerü ma'i wayuu cha'aya süpüla ka'ikat süpüshua, süka matüjain ouktaa tü jokomakalüirua sünainkat, je matüjüin ayokujawaa tü sikikat. ");
INSERT INTO guc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Je jalia pia suulia kaainjalaa sükajee tü kasa pi'rakat. Anasüje ne'e shiale amüloulin puulia waneesia po'u sünain pikerolüin nüma'anamüin Maleiwa suulia pikerolojüin Hadesmüin sümaa tü piamasükat po'u, chaa eemüinjachire pujutünüin sa'akamüin tü ouktüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mülieerü ma'i wayuu cha'aya süpüla ka'ikat süpüshua, süka matüjain ouktaa tü jokomakalüirua sünainkat, je matüjüin ayokujawaa tü sikikat. ");
INSERT INTO guc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tamüshii paala jia: Maa aka anain asalaa eekai e'ichiijaaushin, aka'aya wayuu süpüshua, aneerü sukuaippa müleka shi'rüle müliaa palajana. ");
INSERT INTO guc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Anasü ma'i tü ichiikat süpüla e'ichiijaayaa. Otta müleka me'ejüle, nnojoleerü kasain saamüin sümüin wayuu. Akaajaa jiakana, müleka kamaneejiraale jia, akaaliijiraajeena suulia mojujirawaa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","O'unüshi Jesús chajee sulu'umüin tü mmakat Judea. Je yalajee yala, o'unüshi waneemüin sa'ata tü süchikat Jordán. Süntakalaka watta saalii wayuu nünainmüin je nikirajüin naya, maa aka nikirajapü'üin paala wayuu. ");
INSERT INTO guc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Narütkaakalaka waneeirua wayuu fariseo nünainmüin Jesús süpüla nasakirayaainjachin nia shii'iree niweetirüin wane pütchi kasalajanajatkat nümüin natüma sünain maa: —¿Anasü müleka nuu'ulaale nu'wayuuse wane wayuu? ");
INSERT INTO guc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nüsouktakalaka Jesús namüin: —¿Kasa nuluwataaka anain jia Moisés? ");
INSERT INTO guc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Namakalaka nümüin: —Naashin Moisés, müleka nücheküle wane wayuu süpüleerua nuu'ulaain suulia tü nu'wayuusekat, kettaasü ne'e süka naapüin wane karaloukta saapiria süpüla nuu'ulaainjatüin shia. Süchikijee naapüin tü karalouktakat sümüin, eesü süpüla nüjütüin shia nüma'anajee —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nüsouktakalaka Jesús namüin: —Müsüja'a tü nümakat Moisés namüin na jutuushinuukana saa'ujee nayouktüin tü nüchekakat chi Maleiwakai napüleerua. ");
INSERT INTO guc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Otta paala sümaiwa nükumajaiwa'aya Maleiwa chi wayuukai, nükumajüin wayuu toolo oo'ulaka wayuu jierü. ");
INSERT INTO guc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Saa'ujee tia, anashi nujuittüle chi wayuukai nuulia chi nüshikai je suulia tü niikat süpüla ka'wayuusein nia je süpüla kepiainjachin nia sümaa tü nu'wayuusekat saa'u sa'aniraaitpain nukuaippa sümaa. ");
INSERT INTO guc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Waneeinapa wayuu naya, nnojoliinapa katata'awain. ");
INSERT INTO guc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tamüshii paala jia: Sa'aniraapa nukuaippa wane wayuu toolo sümaa wane jierü nütüma Maleiwa, nnojotsü anain süpüla sükatajiraanüin sütüma wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Shiasa süchikijee nikerolüin Jesús sulu'u wane miichi, nasakirüin nia na nikirajüinkana soo'opünaa tüü. ");
INSERT INTO guc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nüsouktakalaka namüin: —Chi eekai nuu'ulaain suulia nu'wayuuse, müleka ka'wayuusere nia nüchikua, kaainjalashi suulia tü palajatkat nu'wayuuse. Je kasalajaneerü nümüin nüma'üjaain sümaa tü jeketkat nu'wayuusein. ");
INSERT INTO guc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Akaaja'a wane jierüya eekai suu'ulaain nuulia su'wayuuse, müleka ka'wayuusere shia süchikua, kaainjalasü. Je kasalajaneerü sümüin süma'üjaain nümaa chi jekechikai su'wayuusein. ");
INSERT INTO guc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Je so'u wane ka'i, antinnüsü wane tepichiirua nünainmüin Jesús süpüla ni'itaainjatüin najapü naa'uirua. Otta na nikirajüinkana ne'rapa tia, nachiajaakalaka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Niasa Jesús ni'rapa tia, jashichishi namüin sünain nümüin: —Kettshi'iya na tepichikana nantaiwa tanainmüin. Maa aka nakuaippa na tepichikana sünain nnojolüin kaa'in toulia, müinjatia nakuaippa tamüin na ekeroteekana chaa eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tamüshii paala jia: Chi wayuu eekai nnojolin müin aka naa'in na tepichikana sünain nanoujain tanain, müichia nnojolin ekerotüin eere nuluwataain Maleiwa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naapaakalaka na tepichikana nütünalu'umüin sünain ni'itaain najapü naa'u je sünain nüchuntüin nümüin Maleiwa süpüla nii'iyatüinjatüin na'anasia namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Shiasa nu'unalaaiwa'aya ne'e Jesús mamüin aka türa, nuwataakalaka wane wayuu nünainmüin sünain nüsapainyo'ukain nia nümülatu'u sünain nümüin nümüin: —Ekirajüikalee, pia anamiakai, ¿kasa taa'inrüinjatka süpüla eeinjachin taya nümaa Maleiwa waneepia? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Asouktüshi Jesús, —¿Jamüshi “Pia anamiakai” pümakalaka tamüin? Waneeshia Maleiwa niain anamiain. ");
INSERT INTO guc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aashin pütüjaayaain aa'u tü nuluwataakat anain Maleiwa makat mayaa: “Nnojo pu'utüin saa'in wayuu. Nnojo püma'üjaain sümaa wayuu nnojotkat pu'wayuusein otta nnojoikai pu'wayuusein. Nnojo pu'luwajüin sükorolo wayuu. Nnojo püküjüin alawaa süchiki wane wayuu. Nnojo pi'ike'erüin wayuu. Kojutüinjatü pütüma püi je püshi”, müsü tü pütchikat —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Ekirajüikalee, taa'inratüjütsa'aya tia süpüshuale'eya tepichiiwa'aya taya ja'itakaje maa'utpünaa yaa —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Niirakaakalaka Jesús nümüin. Süka nümülialüin nia naa'inyaka, nümakalaka nümüin: —Che'ojaayülia wane kasa paa'inrajatkat. Anakaja puikküle tü pukorolokot süpüshua süpüla püsülajüinjatüin tü süliakat sümüin wayuu eekai mojuin. Kee'irakeerü pümüin shia iipünaamüin cha'aya eere Maleiwakai. Je paa'inrapa tia, ale'ejeechi pia püchikua tanainmüin süpüla tamaain pia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Je chi wayuukai sütümajee tü nümakat Jesús nümüin, o'unüshi nüma'anajee sünain mojuin ma'i naa'in süka washirüin ma'i nia. ");
INSERT INTO guc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eirakaashi joolu'u Jesús namüin na nikirajüinkana sünain maa namüin: —Kapüleesü ma'i ekerotoo sümüin wayuu washirü cha'aya eemüinre nuluwataain Maleiwa —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Je na nikirajüinkana, patatsü ma'i naa'in sütüma tü nümakat namüin. Otta müshia Jesús, müshi nia nüchikua: —Tawalayuwaa, chi wayuu eekai ataralaain sümaa tü nuwashirüinkat, kapüleejeerü ma'i nümüin ekerotoo cha'aya eemüinre nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mapüleesat süpüleerua shikerotüin wane “camello” so'ulu'upünaa wane wutia suuliale'eya shikerotüin wane wayuu washirü cha'aya eere nuluwataain Maleiwa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Patatsü ma'i naa'in na nikirajüinkana sütüma tü nümakat Jesús. —Isasüja'a sümata nüchiki nu'ttaainjachin wane wayuu —namajiraakalaka. ");
INSERT INTO guc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eirakaashi joo Jesús namüin sünain maa namüin: —Tü kasa isakat süchiki wayuu, nnojotsü kapüleein nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Müshi joo Pedro nümüin Jesús: —Wapütüin süpüshua tü kasa eejatkat wama'ana süpüla yaainjanain waya pümaa. ");
INSERT INTO guc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nüsouktakalaka Jesús: —Shiimüin tü tamakat jümüin, chi wayuu eekai nüpütüin nipia, nuwalayuu, nüshi, nii, nüchonnii, je na'apainse shiale saa'u nünoujain tanain je süpüleerua aküjaa tachiki, ");
INSERT INTO guc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","alana'aleejeeria tü aapüneetkat nümüin, maa aka polootua shikii suulia tü kasa nüpütakat. Akaweeria jümüin jiakana, aapüneerü jümüin miichi, juwalayuu, jii, jüchonnii, je ja'apainseirua, mayaainje'e müliainjanain jia sütüma wayuu saa'ujee tü jünoulakat. Je eejeena jia nümaa Maleiwa waneepia saa'u shii'iranajaaushin jaa'in. ");
INSERT INTO guc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tamüshii paala jia: Ja'itaina mojutüin na anoujashiikana sütüma wayuu maa'ulu yaa, ekeroleenapaja'a naya nüma'anamüin Maleiwa so'u wane ka'i. Akaajasa na manoujainsaliikana, ja'itayaashiije kojutüin sütüma wayuu maa'utpünaa yaa, nnojoleena kasajanain nümüin Maleiwa so'u ka'ikat tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","O'unüshija'a joolu'u Jesús Jerusalénmüin namaa na nikirajüinkana oo'ulaka sümaa wane wayuuirua. Napüleeruashi nia. Ayo'ujaasü naa'in nayakana süka masütaajuin Jesús sünain o'unaa Jerusalénmüin. Nuunejakalaka Jesús na nikirajüinkana nünainmüin, na polookana piammüin namüiwa, süpüla nüküjainjatüin süchikua namüin süchiki tü aa'innajatkat nüka. ");
INSERT INTO guc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Müshi nia namüin: “O'unajana joolu'u waya Jerusalénmüin, je tayakai chi Shipayakai Wayuu, aapüneematüichi ekii taya najapulu'umüin na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana. ‘Anashi nu'utinnüle aa'in süka kaainjaralin ma'i nia’, meena naya tachiki sünain naapüin taya najapulu'umüin na gentilekana. ");
INSERT INTO guc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Je naairua, neme'erainpaleechi taya sünain nejeteenain taa'u sümaa na'yaateechin taya. Je süchikijee tia, no'utireechi aa'in taya. Otta nu'unnaa chi apünüinkai ka'i süchikijee tia, oso'iraajeerü taa'in”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Je Jacobo oo'ulaka Juan, na nüchonniikana Zebedeo, arütkaashii naya joolu'u nünainmüin Jesús sünain maa nümüin: —Ekirajüikalee, anashi paa'inrüle wamüin tü wachunteekat pümüin —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nüsakirakalaka Jesús naya: —¿Kasa kee'ireeka jaa'in taa'inrüin jümüin? ");
INSERT INTO guc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nasouktakalaka nümüin: —Wacheküin süpüleerua püikkale'erüin waya pa'ato'u cha'aya eeinjachire puluwataain, wane pikialu'ujee oo'ulaka wane pipe'eru'ujee —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nümakalaka joolu'u Jesús namüin: —Nnojotsü jütüjaain aa'u tü juchuntakat. ¿Juunteerüjasa'aya jülatirüin tü müliaa te'reetkat? ¿Yapeenajasa'aya jia süpüla ju'utinnüin aa'in maa aka tayakai? —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Aa, wounteerü —namakalaka nümüin Jesús. Nümakalaka Jesús namüin: —Shiimüin sünain ji'rüinjatüin müliaa maa aka tayakai je sünain ju'utinnajanain aa'in maa aka tayakai. ");
INSERT INTO guc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Otta nnojoishi laülaain taya süpüla taikkale'erüinjanain jia tekialu'ujee oo'ulaka tepe'eru'ujee. Napülajatü na kamüinjanakana tia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Shiasa na polooshiikana nikirajüin, natüjaapa saa'u tü nachuntakat, aashichijaashii naya namüin Jacobo je Juan süsalajee tia. ");
INSERT INTO guc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Neenajakalaka Jesús napüshua na nikirajüinkana nünainmüin sünain nümüin namüin: —Na laülaashiikana naa'u na gentilekana, naluwataain naya pejeewa. ");
INSERT INTO guc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Otta jukuaippa jiakana, nnojotsü müinjatüin. Chi wayuu laülaweekai ja'aka, acheküshi jüüjüüinjachin jümüin jüpüshua. ");
INSERT INTO guc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Akaajaa chi wayuu eekai nücheküin süpüleerua miyo'uweein ja'aka, acheküshi niainjachin jüüjüüin jümüin jüpüshua. ");
INSERT INTO guc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maa aka tayakai, chi Shipayakai Wayuu, nnojoishi antüshin taya süpüla shi'yataainjatüin wayuu tamüin, alu'ujasa süpüla ta'yataainjachin sümüin wayuu, je süpüla taashinjatüin wayuu wainma suulia saainjala sünainjee ouktüin taya saa'u —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nüntapünaakalaka Jesús namaa na nikirajüinkana sulu'u tü pueulo kanüliakat Jericó. Je nujuittapa sulu'ujee sümaa wayuu watta saalin, eejachi joyotüin wane wayuu mo'usai sotpa'a tü wopukot sünain ajulija'alaa, Bartimeo nünülia, nüchon Timeo. ");
INSERT INTO guc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Shiasa nütüjaapa saa'u sünain niain Jesús Nazaretje'ewaikai alatüin, o'ttüshi sünain a'waataa: —Jesúsuu, Nülüinkai David, pümüliaja taya. ");
INSERT INTO guc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Shiasa wainma wayuu, —Kaseesü pikiisa —müsü nümüin. Otta niakai, masütaajusai sünain a'waataa: —Nülüinkai David, pümüliaja taya —müshi. ");
INSERT INTO guc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nüsha'walaakalaka Jesús sünain nümüin sümüin tü wayuukolüirua: —Juuneja tamüin nia —müshi. ");
INSERT INTO guc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nounejakalaka chi mo'usaikai sünain maa: —Talata paa'in, püsha'walaa, nuunejüin pia Jesús —namakalaka nümüin. Nüpütapünaain tü nüshe'inpalajanakat sünain nüsha'walaain nünainmüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nümakalaka Jesús nümüin: —¿Kasa püchekaka taa'inrüin pümüin? —Senyotkalee, anashi müleka ko'ule taya —nümakalaka chi mo'usaikai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Asouktüshi Jesús: —Ko'uichipa pia joolu'u saa'u pünoula —nümakalaka nümüin. Ko'u müshija nia. Je süchikijee tia, o'unüshi nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Je nülü'ülapa Jesús namaa na nikirajüinkana sünainmüin Jerusalén, antüshii naya sü'ütpa'a tü pueulokat Betfagé oo'ulaka Betania, peje sünain tü wutai kanüliakat Olivos. Nüjütakalaka piamashii na nikirajüinkana nüpüleerua, ");
INSERT INTO guc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sünain nümüin namüin: —Ju'una samüin eemüin tüsa pueulokat. Jikerolapa sulu'umüin, ji'reechi kapüin wane püliiküchon sareerü. Jüsiwateerü tü nüpükat süpüla jajattüin nia tamüin yaamüin. ");
INSERT INTO guc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Je müleka “¿Jamüinjatü jüsiwataka'a tü nüpükat?”, sümüle wayuu jümüin, “Che'ojaashi nümüin chi Senyotkai je nüjütiramaateechi yaamüin nüchikua”, meena jia sümüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","No'unakalaka na nikirajüinkana sünain eein napüla wane püliiküchon kapüin sulu'u tü wopukot so'ulu'u wane miichi. Je wanaa sümaa nasiwatüin nüpü chi püliiküchonkai, ");
INSERT INTO guc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","namünakalaka natüma wane wayuuirua sha'washawatshii: —¿Jamüinjatü jüsiwataka'a tü nüpükat? ");
INSERT INTO guc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nasouktakalaka namüin süka tü nümakat paala Jesús namüin. —Anakaja —namünakalaka. ");
INSERT INTO guc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Najattakalaka chi püliiküchonkai eemüin Jesús. Ne'itaakalaka tü nashe'inpalajanakat naa'u chi püliiküchonkai. Je no'otookalaka Jesús naa'u. ");
INSERT INTO guc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Awayalayaa müsü süshe'inpalajana tü wayuukolüirua wattakat saalin nüpüleerua sulu'upünaa tü wopukot. Oo'ulaka waneeirua, ashottüshii alanatüna sulu'ujee yüüja süpüla ne'itaainjatüin shia nüpüla eepünaainjachire nülatüin. Naa'inrüin tüü süpüla nee'iyatüin nujutu nümüin. ");
INSERT INTO guc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Je tü wayuukolüirua wattakat saalii nüpüleeruajee oo'ulaka nüchiiruajee Jesús, namayaa namakalaka emetut sünain nasaküin: “Aleluya”. “Wa'waajüin chi Maleiwakai süka nüjütüin wamüin chi antakai wanainmüin”. ");
INSERT INTO guc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Anata'aleeshija'a ma'i chii. Meechi aka nia naa'in chi watuushikai David sünain aluwatawaa”. “Aleluya, wa'waajüin ma'i Maleiwa”. ");
INSERT INTO guc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Je nikerolapa Jesús sulu'umüin Jerusalén, o'unüshi nia sulu'umüin tü a'waajüleekat Maleiwa. Niirakaakalaka sümüin kasa süpüshua yaa sulu'u. Otta süka motsoin ka'i, nu'unakalaka chaa sulu'umüin tü pueulokat Betania namaa na nikirajüinkana, na polooshiikana piammüin. ");
INSERT INTO guc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Shiasa mapa watta'a maalü, sünain nu'unüin Jesús namaa na nikirajüinkana sulu'ujee Betania, ouktakalaka nia jamü wopulu'u. ");
INSERT INTO guc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ni'rapa wane wunu'u kapanasü kanüliasü “higuera”, nürütkaakalaka sünainmüin nütüjaaiwa saa'u müleka kachonle. Je nüntapa sünain tü wunu'ukot, machonkalaka shia nüpüla, ee'eraaka ne'e süpana. Nnojoyülia antüin sükalia süpüla kachonwaa. ");
INSERT INTO guc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nümakalaka sümüin tü wunu'ukot: —Müirüja'a pümata mekujuin tü püchonkot —müshi nia no'upala na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Shiasa süchikijee nüntüin Jesús Jerusalénmüin, nikerotokalaka sulu'umüin tü a'waajüleekat Maleiwa. Eesü nüpüla wane wayuu oikkaasüirua sünain süikkaain tü mürüt o'utinnajatkat aa'in nümüin Maleiwa, je na ayalajüshiikana. Nujuittirakalaka naya anooipa'amüin. Nujunnajakalaka nemeesain na a'wanajaaliikana neerü oo'ulaka neinase na oikkaaliikana wuchii toomasü. ");
INSERT INTO guc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Je nuu'ule'erüin tü wayuukolüirua suulia sülü'üjüin tü sükorolokot sulu'upünaa süpaatiase tü a'waajüleekat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nümakalaka sümüin: —Tü nünüiki Maleiwa ashajuushikat paala sümaiwa, müsü mayaa: “Tü tepiakat, nachuntiajatü na tapüshikana tamüin sainküinjee mmakat süpüshua”, müshi. Otta jiakana, saa'u nnojolüin lotüin jukuaippa sünain jüikküin tü mürütkat, müsü aka saa'in shipia ka'ruwarannuu jütüma tü nipiakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Otta na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana, naapapa süchiki tü naa'inrüitpakat Jesús yala sulu'u tü a'waajüleekat, naashajaajiraakalaka süchiki kasain naa'inrüinjatüin süpüla no'utirüin naa'in. Otta kapüleesü namüin süka mmolüin naya neema süka ponoin saa'in tü wattakat saalii wayuu oushikajaasükat nüchiirua tü nikirajakat anain. ");
INSERT INTO guc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Je aipa'a, o'unüshi Jesús namaa na nikirajüinkana anooipa'a suulia Jerusalén. ");
INSERT INTO guc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Shiasa mapa watta'a, sünain nu'unüin Jesús namaa na nikirajüinkana, ne'rapünaakalaka tü wunu'u higuerakat nü'ülüjakat amüin Jesús paala. Ajulujaasü tü wunu'ukat süpüshua suurulanainje'ere'eya. ");
INSERT INTO guc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Otta müshia Pedro, sotüsü naa'in tü nümakat paala Jesús sümüin tü wunu'ukot. Nümakalaka nümüin Jesús: —Ekirajüikalee, piirakaa, ajulujaaitpa tü wunu'u pü'ülüjakat amüin. ");
INSERT INTO guc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nüsouktakalaka Jesús nümüin: —Anakaja jünoujüle nünain chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Shiimain ma'i tü tamakat jümüin: Müleka jümataarüle sümüin wane uuchi “Pülataa yaajee yaa shirokumüin tü palaakat”, oonoojeerü sümaa jünüiki müleka jünoujüle sümaa nnojolüin wainmajüin jaa'in. ");
INSERT INTO guc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tamüshii paala jia: Wanaa sümaa juchuntüin nümüin Maleiwa, müleka jünoujüle sünain naa'inrüinjatüin tü jüchuntakat, shiimüin sünain naa'inreerüin. ");
INSERT INTO guc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Je wanaa sümaa jaashajaain nümaa chi Maleiwakai, anasü motüle jaa'in tü saainjalakat wayuu eekai kaainjalain juulia. Müleka motüle jaa'in tü saainjalakat, alatinneerü jaainjala juuliaya nütüma chi Jüshikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Otta müleka nnojorule motüin jaa'in tü saainjalakat, nnojoleeria alatinnüin jaainjala juulia nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ale'ejüshi Jesús namaa na nikirajüinkana Jerusalénmüin. Je wanaa sümaa nawaralijaain yaa sulu'u tü a'waajüleekat Maleiwa, arütkaashii nünainmüin na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana oo'ulaka na laülaashiikana naa'u na judíokana sünain namüin nümüin: ");
INSERT INTO guc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Jara koonoloka pia süpüla pujuittirüin anooipa'amüin tü wayuu oikkaatkalüirua? ¿Jara ke'inaajalaka pia süpüla paa'inrüin shia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nüsouktakalaka Jesús ne'ipajee: —Tasakirüin paala jia'aya. Müleka jüsouktüle tamüin, taküjeerü jümüin jaralin e'itaain taya süpüla tojuittirüinjatüin anooipa'amüin tü wayuu oikkaatkalüirua. ");
INSERT INTO guc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Jara ke'inaajalaka Juan sünain owoutisaajaa? ¿Shi'inaajala wayuu, niataapa Maleiwa? Jüküjaa tamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naashajaajiraakalaka namüiwa: “Müleka ‘Nia Maleiwa’ wamüle, ‘¿Jamakalaka nnojoliika'a jünoujain nünüiki?’, meechi nia wamüin. ");
INSERT INTO guc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Oo'ulaka mojushiisü süpüla ‘Wayuu’ wamüinjanain süka nünüikimaajachin nia Maleiwa saajüin tü wayuukolüirua. Mojushiijeerü namüin”, majiraashii naya nujuuna Jesús. ");
INSERT INTO guc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nasouktakalaka joo nümüin Jesús: —Nnojoishi watüjaain aa'u jaralin ke'inaajalain. Nümakalaka joo Jesús namüin: —Nnojoluja'a süpüla taküjüin jümüin jaralin ke'inaajalain taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","O'ttüshi Jesús sünain ekirajaa tü wayuukolüirua süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia: “Eetaalashi wane wayuu kama'anashi wane mma. Nükulaalajakalaka shia süpüla apünajünaa tü wunu'u kachonkot uuwa sulu'u. Je yaa sulu'u tü na'apainsekat, nükumajakalaka wane ishi süpüla ocho'ulajia süchon tü nüpünajüinkat süpüla wiinoinjatüin shia. Otta nükumajüin wane türooja süpüla e'rajia saa'u tü na'apainsekat. “Saa'u nu'unajachin wattamüin, naa'inmajirakalaka wane wayuuirua tü nüpünajüinkat. ");
INSERT INTO guc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Je kettaapa süka'iya tü a'ttieekat süpüla sütpajünüin, nüjütüin wane nüchepchia nanainmüin na aa'inmajüliikana sünain maa namüin: ‘Anakaja juluwataale tamüin süpüshi süchon tü ta'ttia jükotchajalakat, tü tamüinjatkat jütüma saa'u takoroloin shia’. ");
INSERT INTO guc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Otta chi nüchepchiakai, ata'ünnüshi natüma na aa'inmajüliikana sümaa nashe'ejüin ma'i nia. Ajütajaanüshi nia sümaa nnojolüin kasain najapüipain natüma. ");
INSERT INTO guc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Otta chi ka'apainseshikai süchikijee tia, nüjütakalaka joo wane nüchepchiaya nii'iraka chi wane. A'yaajünataa joo chii natümaya sünain sheewaain nikii natüma. E'rülii ma'i wayumüin naya nümüin. ");
INSERT INTO guc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Je joolu'u chi ka'apainseshikai, nüjütüin wane'eya. O'utünataala aa'in chii natümaya na aa'inmajüliikana. Maleesia süpüshua tü aluwataaushikalüirua. Eesü eekai sheewaain natüma. Eesü eekai no'utüin saa'in. ");
INSERT INTO guc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Iraayü'iya wane wayuukai apütaain nüma'ana chi ka'apainseshikai. Nia chi nüchonkai, chi aishikai nüpüla. Nüjütüinja'a nia nachiirua na nüjütakana paala nanainmüin na aa'inmajüliikana sünain nümüin, ‘Nieechi kojutka chi tachonkai natüma’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nayasa'a na aa'inmajüliikana ne'raiwa'aya chi nüchonkai nüpanapa, aashajaajiraashii naya: ‘Iseeichi chi aapüneechikai amüin tü apainkat. Joo'uya wo'utaiwa naa'in süpüla wayainjanain makatüin apüla shia’, müshii naya. ");
INSERT INTO guc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nayu'lakalaka joo nia anooipa'amüin je no'utakalaka naa'in. ");
INSERT INTO guc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tasakirüin paala jia: ¿Kaseerü naa'inraka chi ka'apainseshikai naka na aa'inmajüliikana? Shiimüin sünain nüle'ejeechin süpüla nu'utüinjatüin saa'in. Je naa'inmajireerü tü na'apainsekat wayuu naatajatü. ");
INSERT INTO guc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Soto jaa'in tü ashajünakat paala sulu'u tü nüchikimaajatkat Maleiwa: ‘Tü ipa ayouktünakat natüma na akumajüliikana miichi, ekeraajüitpa sünain anain ma'i shia süpüla akumajia miichi. ");
INSERT INTO guc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chi e'itaakai tü ipakat, nia Maleiwa. Je patatsü ma'i waa'in süka we'rüin tü naa'inrakat’, makat”. ");
INSERT INTO guc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Otta müshi'iya na laülaayuushii judíokana, naapapa tü nüküjüitpakat Jesús, nayaawata aa'ulu sünain nayain müin aka naa'in na aa'inmajülii e'rüliikana wayumüin sulu'u tü nüküjaitpakat achiki Jesús. Je sükajee tia, kee'ireesü ma'i naa'in nata'üleein Jesús, otta nnojoishi nata'ülüin süka mmolüin naya seema tü wayuu kamalainkat amüin nünüiki Jesús. No'unakalaka ne'e nuulia. ");
INSERT INTO guc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Shiasa mapa tia, najütünakalaka nünainmüin Jesús wane fariseokana oo'ulaka wane nümaajanakana Herodes chi sülaülashikai mma, süpüla nasakirayaainjachin nia shii'iree niweetirüin wane pütchi kasalajanainjatkat anainjee nia natüma. ");
INSERT INTO guc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Je nantapa nünainmüin Jesús, namakalaka nümüin: —Ekirajüikalee, watüjaa aa'uchi pia sünain shiimüin tü pümakat sünain ekirajaa tü nuluwataakat anain Maleiwa, je sünain matüjüin pia kachekalaa su'utku wayuu. Wasakiree amüinchi pia sünain wane kasa: ¿Anashiisü saa'in pümüin wawalaajüle tü neerü nümüinjatkat César chi joyotokai cha'aya Roma sünain aluwatawaa saa'u mmakat, ");
INSERT INTO guc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","nnojottaapa anain? —namakalaka nümüin. Otta müshia Jesús, süka niyaawatüin saa'u sünain naa'inreein kasa mojusü nümüin, nümakalaka namüin: —Jia piamakana o'upünaa, ¿jamüsü juu'ulakeeka'a taa'in süka pütchi shii'iree süsalainjachin taya jütüma? Iche'era tamüin wane neerü kachueera awalaajiapü'ükat nümüin chi sülaülashikai mma, te'raiwa shia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nasaajakalaka tü neetkat nümüin. Nüsakirakalaka naya Jesús: —¿Jara kayaakuaka tü sünainkat? ¿Jara kanüliamaajachika shian? —nümakalaka namüin. —Shia niyaakua oo'ulaka nünülia César tü sünainkat —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nüsouktakalaka Jesús: —Tamüshii paala jia: Anakaja müleka jaa'inrüle tü nuluwataakat anain César otta jaa'inrüinjatü tü nuluwataakat anain Maleiwaya —nümakalaka namüin. Ponokalaka ma'i naa'in nayakana tü nüsouktiakat Jesús. ");
INSERT INTO guc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Süntakalaka wane wayuuirua judío kanüliasü saduceo nünainmüin Jesús süpüla süsakirayaainjachin nia. Nnojoleerü oso'irawaa aa'inyüü süchikijee ouktaa müsü tü shikirajapü'ükat anain tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Namakalaka joo nümüin Jesús: —Ekirajüikalee, müsü nünüiki Moisés wamüin sulu'u tü ashajünakat paala: “Müleka ouktüle wane wayuu sümaa machoin nia, anashi müleka niisarüle chi nimüliakai nüchukumüin süpüla kachooinjatüin tü jietkat nütüma”, müsü. ");
INSERT INTO guc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eetaashiija'a akaratshishii wayuu pawalaawashii. Ka'wayuuseshi chi epayaakai sümaa ouktüin nia machoinwa'aya sümüin tü nu'wayuusekat. Niisatkalaka chi nimüliakai sümüin tü jietkat. ");
INSERT INTO guc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ouktataashija chii'iya nnojoiwa'aya kachoin sümüin tü jietkat. Eisattaaja'a joo wane'eya nüchukumüin. ");
INSERT INTO guc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mataaja'a aka nakuaippa napüshua na akaratshishiikana awalayuwaa. Ouktüshii naya sünain machoin sümüin tü jietkat natüma. Je oo'uwo'utpa na su'wayuusekana napüshua, ouktüsü mapa shia nachiiruajee. ");
INSERT INTO guc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Su'wayuuseshii napüshua na akaratshishiikana kataiwa'aya so'u. Wasakiree amüinchi joo pia soo'opünaa tia: So'u tü ka'ikat suso'iraainjateetkat o'u saa'in wayuu paajüin, ¿jaraleechi ka'wayuuseka tü wayuu ouktama'akat? —namakalaka na saduceokana nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nüsouktakalaka Jesús namüin: —Nnojotsü jiyaawatüin saa'u tü ashajuushikat sulu'u tü nüchikimaajatkat Maleiwa. Je nnojotsü jütüjaain naa'u Maleiwa sünain pülashaatain ma'i nia. “Nnojoleerü oso'irawaa aa'inyüü süchikijee ouktaa”, jümakalaka ne'e. Sükajee tia, nnojotsü lotüin tü jünoujakat. ");
INSERT INTO guc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Suso'iraapa saa'in wayuu süchikijee ouktaa, nnojoleerü pa'wayuuseewain, süka meenain aka naya saa'in nakuaippa na aapieekana chakana nüma'ana Maleiwa sümaa ma'wayuusein naya. ");
INSERT INTO guc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jia manoujainsaliikana sünain suso'iraainjatüin saa'in wayuu, soto jaa'in tü nüshajakat achiki paala Moisés soo'opünaa tü nümakat chi Maleiwakai nümüin pasanainjee sünain suwarala tü wunu'u jotüsükat: “Tayakai, Nümaleiwasekai Abraham, Nümaleiwasekai Isaac, Nümaleiwasekai Jacob”, müshi. ");
INSERT INTO guc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tamüshii paala jia: Chi Maleiwakai, nnojoishi Sümaleiwasein wayuu ouktüsü. Sümaleiwase eekai katüin so'u. Shiimüin sünain nnojolüin lotüin tü jünoujakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Antüshi wane wayuu karalouktamaajachi sünain aapajaa nanüiki na wayuu a'ülüjashiikana nümaa Jesús. Saa'u niyaawatüin saa'u sünain anain ma'i tü nüsouktiakat Jesús, nüsakirayaakalaka nia: —¿Jarat alana'aleeka sünain anain sa'akajee süpüshua tü nuluwataakat anain waya Moisés? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nüsouktakalaka Jesús nümüin: —Tü alana'aleekat sünain anain, müsü mayaa: “Jaapa jiakana Israelkana tüü: Chi Wamaleiwase Aluwataakai, nia nümüiwa sünain Maleiwain. ");
INSERT INTO guc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Anashi aire nia püpüla waneepia süka süpüshua paa'in. Anashi jülüjüle paa'in Maleiwa waneepia”. ");
INSERT INTO guc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Je eesü wane'eya alana'aleesia ma'i sünain anain, müsü mayaa: “Anasü aire püpüla wayuu süpüshua maa aka alin pia püpülajiraa”. Nnojotsü eein eekai alana'aleein ma'i sünain anain suulia tüü sa'akajee süpüshua tü nuluwataakat anain waya Moisés —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nümakalaka chi wayuukai nümüin Jesús: —Ekirajüikalee, shiimüin tü pümüitpakat sünain “Chi Wamaleiwase, nia nümüiwa sünain Maleiwain”, sünain pümüin. ");
INSERT INTO guc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Je shiimüin tü pünüikikat sünain niainjachin alin wapüla chi Maleiwakai süka süpüshua waa'in, je sünain jülüjüin waa'in Maleiwa waneepia. Je shiimüin tü pümakat sünain alinjatüin wapüla wayuu süpüshua maa aka alin waya wapülajiraa. Alana'aleesia ma'i tüüirua suuliale'eya waapüin mürüt nümüin Maleiwa, tü o'utünakat aa'in watüma —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nütüjaaichipa aa'u Jesús chi wayuukai sünain lotüin nünüiki, nümakalaka nümüin: —Yapashi pia süpüla pu'ttüin sünain anoujaa tanain süpüla pikerolüinjachin eemüinre nuluwataain Maleiwa —nümakalaka nümüin. Je süchikijee tia, mmotsü wayuu sheema asakiraa Jesús sünain wane kasa. ");
INSERT INTO guc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wanaa sümaa nikirajüin Jesús sulu'u paatia tü a'waajüleekat Maleiwa, nüsakirakalaka na wayuu akotchajaakana nünainmüin: —Naashin na karalouktamaajanakana, chi Cristokai anülia, nuu'uliwo'ulaa ne'e David. ¿Jamüsü namaka'a tia? ");
INSERT INTO guc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Soto jaa'in nünüiki David, tü nümakat paala nütüma chi Naa'inkai Maleiwa sünain maa: “Müshi chi Maleiwakai nümüin chi Tasenyotsekai: ‘Kojutshaatashi pia tatüma. Püikkalaa puluwataaiwa tekialu'ujee. So'u wane ka'i, tayamüleerü tü pü'ünüükalüirua süpüla malainjatüin shiairua püpüla’ ”. ");
INSERT INTO guc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Tasenyotsekai” nümüleje'e David nümüin Cristo, ¿jamakuaippalinjachi nuu'uliwo'ulaaka'a ne'e nia? —nümakalaka Jesús namüin. Shiasa tü wattakat saalii wayuu, talatüsü ma'i saa'in sütüma nünüiki. ");
INSERT INTO guc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mapü'üshi Jesús sünain ekirajaa: “Jalia jia suulia ashataa nakuaippa na karalouktamaajanakana waraitteekana ma'i aa'in cha'aya metkaaralu'upünaa sünain kashe'iin naya kuluulu anasü shii'iree nasaküneein sütüma wayuu. ");
INSERT INTO guc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Je sulu'u tü ekirajüleekat je sünain wane mi'iraa, ojoyolooshii naya na'aka na laülaayuukana süpüla kojutüinjanain naya sütüma wayuu. ");
INSERT INTO guc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Otta e'ike'etshii wayuu eekai ouktüin su'wayuuse shii'iree naapaweein sükorolo. Je süchikijee, kama'ashii naya sünain nachuntayaain nümüin Maleiwa su'upala wayuu shii'iree kojuteein naya sütüma. Alana'aleejeeria ma'i sünain süsalain naya nütüma Maleiwa saaliijee tia”. ");
INSERT INTO guc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nüikkalaakalaka Jesús yala peje sünain tü kojon ejitünakat alu'u tü neerü asülajünüinjatkat nümüin Maleiwa. Ni'rakalaka tü wayuukolüirua sünain ejitaa sünneetse sulu'u. Ni'rüin wayuu wainma eekai nejitüin wainma neerü yaa sulu'u süka washinnuuin naya. ");
INSERT INTO guc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Süntakalaka wane wayuu müliasü oukta a'wayuuset. Shijitakalaka piamasü neerü kachueerachen ne'e. ");
INSERT INTO guc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Neenajaakalaka Jesús na nikirajüinkana nünainmüin sünain maa namüin: —Tamüshii paala jia: Alana'aleesia ma'i nümüin Maleiwa tü shijitakat tü wayuukot oukta a'wayuusetkat suuliale'eya tü shijitakat tü wayuukolüirua süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na washinnuukana, nejitüin tü süpütaalakat nanneetse. Alu'usa shiakat, mayaainje müliain ma'i, shijitüin süpüshua tü sünneetse süma'anajatkat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Shiasa nujuittaapa Jesús sulu'ujee tü a'waajüleekat Maleiwa, wanaa sümaa eein naya anooipa'a, nümakalaka wane chi nikirajüinkai nümüin: —Ekirajüikalee, piirakaa sümüin tü a'waajüleekat Maleiwa, anashaatasü ma'i shia, je miyo'u ma'i tü ipakalüirua akumajuushikat aka shia. ");
INSERT INTO guc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nümakalaka Jesús nümüin, —¿Ponosü ma'i jaa'in tü a'waajüleekat? Süpüshua türa ipa ji'rakat joo müinma'a yaa, ajuttinneerü shia mmolu'umüin sünain süsolojüneerüin so'uweena wane ka'i —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Shiasa nantapa sünainmüin tü wutai kanüliakat Olivos ka'yatajeekat suulia tü a'waajüleekat, wanaa sümaa joyotüin Jesús cha'aya, arütkaashi Pedro, Jacobo, Juan oo'ulaka Andrés namüiwa nünainmüin süpüla nasakirüin nia: ");
INSERT INTO guc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“¿Joujaleerü sujuttinnaka tü a'waajüleekat Maleiwa? ¿Je kasa shiyaawaseetka wamüin süpüla watüjaainjatüin saa'u sünain sülü'ülüin sükalia süpüla shikeraajüinjatüin süpüshua tü püküjakat wamüin?”, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Nümakalaka Jesús namüin: “Anteerü wayuu wainma sünain maa: ‘Taya'aya Cristokai’, meena. Pülashii naya nütüma Maleiwa naashin. Jalia jia suulia anouja'alaa na'alain na wayuukana maa aka sünoujeerüin wayuu wainma nanain. ");
INSERT INTO guc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ja'itaina jia aapüin süchiki kasachiki sainküin mmakat süpüshua, nnojo jainkuuin aa'in sütüma. Ja'itakaje tiairua, nnojotsü shiain shiyaawasein sünain süntüitpain tü ka'i saja'lajaainjatkat o'u kasakat süpüshua. Alatüinjatia ne'e kasa eekai müin aka tüü süpülapünaa süntüin ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Atkaajiraajeerü wayuu sainküin mmakat süpüshua. Mülieerü ma'i saa'in wayuu sütüma jamü je sütüma ayuulii sainküin mma. Je akutkujaweerü tü mmakat sainküin mma. Je süpüshua tü müliaa shi'reetkat wayuu süpülapünaa teweetüin tayakai, meerü aka su'ttakai saalin jo'uu sümüin jieyuu. ");
INSERT INTO guc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Jalia jia, süka jüta'ülinneenain süpüla aapünaa ekii namüin na laülaayuukana je süka ji'yaatinneenain sulu'u tü ekirajüleekat tü judíokolüirua. Saaliijee jünoujain tanain, asha'wale'enneena jia namülatu'u na sülaülashiikana mma oo'ulaka namülatu'u na aluwataashiikana saa'u wayuu süpüla jüsouktüinjanain namüin saa'u tü jünoulakat. Je wanaa sümaa jüsha'wale'ennüin namülatu'u, jüküjainjatü tachiki namüin. ");
INSERT INTO guc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Süpülapünaa süntüin tü ka'i saja'lajaainjatkat o'u kasakat süpüshua, aküjüneerü tachiki tayakai, chi O'tte'erüikai, sümüin wayuu sainküin mmakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Je so'uweena tü ka'i jüta'ünneenakat o'u süpüla jüsha'wale'ennüin namülatu'u na laülaashiikana, nnojo jüshapataain aa'in saa'u tü jüsouktüinjatkat aka namüin. Aapüneerü jümüin so'u ma'i ka'ikat tia tü pütchi jümüinjatkat namüin. Otta tü pütchi jüsouktüinjatkat aka, nnojoleerü jüle'eru'ujeejatüin, aapüneerü shia jümüin nütüma chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Je sukuaippainjatkat wayuu so'u ka'ikat tia, aapüneerü ekii süpüla ouktaa natüma na suwalayuukana je nütüma chi süshikai. Eejeena wayuu eekai ne'nnüin amüin sütüma nachooin sümaa no'utinnüin aa'in natüma. ");
INSERT INTO guc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A'ürülaajeerü saa'in wayuu süpüshua jünain saaliijee jünoujain tanain. Otta jia, müleka jüchecherüle jaa'in su'unnaa tü müliaa ji'rakat, ayateena jia o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ji'reerü sha'watüin yaa sulu'u tü a'waajüleekat Maleiwa tü kasa kashüülasü nülerajüinjatkat anainjee Maleiwa tü a'waajüleekat, tü ashajünakat achiki paala nütüma Daniel chi nünüikimaajachikai Maleiwa. (Jia aashaje'erakana tü tashajakat, anakaja jiyaawatüle saa'u.) Je so'uweena ka'ikat tia, na wayuu kepiakana sulu'u tü mmakat Judea, anakaja müleka na'luwataale sa'akamüin tü uuchikat süpüla nanujulaainjanain cha'aya. ");
INSERT INTO guc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chi wayuu joyotokoi sheemioushi tü nipiakat so'u ka'ikat tia, nnojoi nikerolüin paülü'ümüin süpüla nükotchajaain nükorolo. ");
INSERT INTO guc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Otta chi wayuu eekai ni'yataain sulu'u niyüüjase, anakaja nnojoire nüle'ejüin nipialu'umüin süpüla a'wanajawaa nüshe'in. ");
INSERT INTO guc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","‘Aisha'ajaa’ meerü tü wayuu eekai ipoolüin je eekai sütulayülüinya süchon so'u ka'ikat tia, süka kapüleejeerüin ma'i süpüleerua awatawaa. ");
INSERT INTO guc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jüchunta nümüin Maleiwa süpüla nnojolüinjatüin sülatüin tüü juyapü. ");
INSERT INTO guc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“So'uweena ka'ikat tia, alana'aleejeeria ma'i tü müliaa shi'reetkat wayuu suulia tü shi'rakat wayuu paala sümaiwa süchikijee sükumajünüin tü mmakat je suulia tü shi'rakat wayuu maa'ulu yaa. Nnojoleerü wane müliaa eekai müin aka saa'in tia mapeena. ");
INSERT INTO guc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Müleka nnojoruleje saawalaain tü müliaakat, aja'lajaweerü wayuu süpüshua sütüma. Akatsa naawale'ereerüin shia Maleiwa naa'ujee na aneekuushikana nütüma. ");
INSERT INTO guc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Je so'uweena ka'ikat tia, müleka jümünüle ‘Jiirakaa, ichaa Cristo chi Nüneekajalakai Maleiwa cha'aya’ je ‘Jiirakaa, anii nia yaaya’, müleka jümünüle, nnojo joonooin sümaa tia. ");
INSERT INTO guc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Je so'uweena ka'ikalüirua tia, eweeteechi wayuu eekai ‘Taya Cristoka’ nümeechin, je eekai ‘Taya wane nünüikimaajachikai Maleiwa’ nümeechin. Alaayuu ne'e nayairua. Pülashiijeena naya sünain naa'inreerüin tü kasa eekai müin aka saa'in tü nütüjakat apüleerua Maleiwa nümüiwa shii'iree nanoujüneein anain sütüma wayuu süpüshua, ja'itashii nnojolüin anoujünüin anain natüma na nüneekajalakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Taküjüin jümüin süchiki tü alateetkat nnojolüiwa'aya sülatüin süpüla yapainjanain jia süpüla. ");
INSERT INTO guc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“So'uweena ka'ikat tia, süchikijee tü müliaakat, ‘Epiyuushijaajeechi chi ka'ikai, je oyokujaweechi chi kashikai, ");
INSERT INTO guc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","je ojunuwaajeerü tü jolotsükolüirua iipünaajee. Alanaajaweerü süpüshua'aya tü kasa chakat iipünaa’. ");
INSERT INTO guc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Je shi'reechi taya wayuu, tayakai, chi Shipayakai Wayuu, sünain antaa sa'aka tü sirumakat. Anashaateerü ma'i tü tantiakat, süka tanteechin sünain pülashin je sünain e'itaaushin nütüma Maleiwa süpüla aluwatawaa wanaa nümaa. ");
INSERT INTO guc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Je ajütüneena na aapiee nüma'anajeejanakana Maleiwa süpüla nakotchajüinjatüin tü wayuu aneekuushikalüirua nütüma sainküinjee tü mmakat süpüshua'ale. ");
INSERT INTO guc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Soto jaa'in sukuaippa tü wunu'u ‘higuera’ münakat. Wanaa sümaa iyotüin süpana tü wunu'ukot, jütüjaa aa'ulu sünain sülü'ülüin süpüla sü'itüin iiwa. ");
INSERT INTO guc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aka'aya ji'rapeena tü taküjaitpakat achiki jümüin, jütüjaweerü aa'u sünain sülü'ülüin ma'i takalia süpüla antaa. ");
INSERT INTO guc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Shiimüin ma'i tü tamakat jümüin, alateerü tüü süpülapünaa shi'rüin ouktaa tü wayuu eekat maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Taso'iree aa'inchii jia joolu'u sünain wane kasa: Mayaainje saja'tteerüin tü kasakat cha'aya iipünaa oo'ulaka yaa mmolu'u so'uweena wane ka'i, tü pütchi tekirajapü'ükat anain jia, ayateerü süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nnojotsü sütüjaain aa'u wayuu joujaleerüin sülatüin tü taküjaitpakat achiki jümüin. Ja'itakaje na aapiee chakana iipünaa, nnojotsü natüjaain aa'u. Nia ne'e chi Tashikai Maleiwa atüjaaka saa'u nümüiwa. ");
INSERT INTO guc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Je sükajee tia, anakaja müleka eere jaa'in tapüla tayakai, chi Jüsenyotsekai, süka tale'ejüinjachin tachikua jünainmüin so'uweena wane ka'i matüjaajuukat aa'u jütüma. ");
INSERT INTO guc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Meena aka jia saa'in nüchepchiairua wane wayuu naa'inmajirüin tü nükorolokot nüchikiru'u. E'itaanüshii naya süpüla tü a'yatawaakat wane'ewai nakua. Eeshi wane e'itaanüin süpüla eeinjatüin naa'in so'ulu'u tü miichikat süma'inru'u nüle'ejüin chi kepiashikai. ");
INSERT INTO guc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Je sükajee tia, anakaja müleka eere jaa'in tapüla tayakai chi kepiashikai, süka nnojolüin jütüjaain aa'u müleka tale'ejeechire ka'apü aikat, süse'eru'upünaa ai, maalia, je watta'achon maalü shiale. ");
INSERT INTO guc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Antalaa meechi taya. Anasü eere jaa'in waneepia süma'inru'u ja'atapajüin taya suulia tantajüin jaa'u sünain atunkaa. ");
INSERT INTO guc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tü tamüitpakat jümüin, süpülajatü wayuu süpüshua'aya: ‘Ee jumata jaa'in tapüla’ ”. ");
INSERT INTO guc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Che'ojaasü piama ka'i ne'e süpüla su'ttüin tü “Pascuakat”, tü mi'iraa süpülajatkat sotüin saa'in wayuu judío wanaa sümaa nojuittinnüin na natuushinuukana sulu'ujee Egipto. (Mi'iraakat tüü, shia tü ekaanapü'ükat anain tü pan ma'akasatkat soolojia.) Je na laülaashiikana na'akajee na sacerdote judíokana, oo'ulaka na karalouktamaajanakana, aashajaajiraashii naya süchiki tü naa'inrüinjatkat nüka Jesús: —Anakaja wata'ürüle nia sujuuna wayuu süpüla wo'utirüinjatüin naa'in. ");
INSERT INTO guc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Otta anasü müleka waa'inrüle tia süchikijee kettaain tü mi'iraakat suulia saashichija'alaain naalin woo'omüin tü wayuukolüirua —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Antüshi Jesús sulu'u tü pueulo kanüliakat Betania nipialu'umüin wane wayuu Simón anüliai, chi ayuuishikai paala sütüma aja'ttaa ata. Je wanaa sümaa nikaain Jesús, sürütkaakalaka nünainmüin wane jierü alü'üjasü wane pachiishichon akumajuushi süka ipa kanüliashi “alabastro” kalu'ushi wane “perfume” kojutsü ma'i. Susottakalaka tü shirousekat süpüla shi'yotoinjatüin shia saa'u nikii. ");
INSERT INTO guc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Otta waneeirua ekaashiikana nümaa, ne'rapa tü saa'inrakat tü jietkat, mojushiisü namüin sünain naashajaajiraain mayaa: —¿Jamüsü sa'amülajaaka'a tü “perfumekat”? ");
INSERT INTO guc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kojutpaja'a ma'i shia. Tü sujutkot, müsü aka shi'yataainjut wane wayuu so'u wane juya. Anasüje müleka suikkünüle süpüla sükaaliijia wayuu eekai müliain —namajiraakalaka sünain nachiajaain shia. ");
INSERT INTO guc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nümakalaka Jesús namüin: —Juu'ulaa suulia jiyoujüin tü jietkat. Anashaatasü ma'i tü saa'inrakat taka. ");
INSERT INTO guc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na wayuu müliakana, eejeena jümaa waneepia süpüla jüsülajüinjanain namüin. Otta tayakai, süpülajachire joo taya yaawaa jümaa. ");
INSERT INTO guc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sükajee tüü, shii'iyatüin tamüin tojut süpülapünaa tojoitünüin. ");
INSERT INTO guc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tamüshii paala jia: Sainküin mma eepünaale süküjüneerüin tachiki tayakai chi O'tte'erüikai, ja'yeerü süchiki tü jietkat süpüla sotüinjatüin saa'in wayuu tü saa'inrakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Otta müshia Judas Iscariote, napüshi na polooshiikana piammüin Aluwataaushikana, nu'unakalaka nanainmüin na laülaashiikana na'akajee na sacerdote judíokana süpüla aapaa nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Je na laülaashiikana, talatakalaka ma'i naa'in sütüma tü nümakat Judas namüin. —Wawalaajeechi pia müleka pükaaliijüle waya sünain ata'ülaa Jesús —müshii nümüin. Nu'ttakalaka Judas sünain achajawaa sukuaippa aapaa nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Je sünain tü mi'iraakat Pascuakat anülia, tü ekünapü'ükat anain tü pan ma'akasatkat soolojia, antüsü joolu'u tü ka'ikat o'utünakat o'u naa'in wane anneetchon süpüla ekaanaa. Nasakirakalaka na nikirajüinkana: —¿Jalasü pücheküin süpüleerua wekaainjatüin tü Pascuakat, wekeraajaiwa shia püpüla? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nüjütakalaka Jesús piamashii nikirajüinkana sünain maa namüin: —Ju'una yalamüin sulu'umüin tü pueulokat. Eejeechi jüpüla wane wayuu alü'üjüshi amüchi sümaa wüin. Ju'una nüchiirua chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Je eemüinre nikerolüin, meena jia nümüin chi nipiajachikai: “Aluwataashi nünüiki chi Ekirajüikai süpüla wasakirüin sünain jaralüin tü paü nikaainjatkat alu'u tü Pascuakat namaa na nikirajüinkana”. ");
INSERT INTO guc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nii'iyateerü jümüin wane paü miyo'u saa'ujeesü tia miichikat kalu'usü korolo. Anakaja jikettaajüle tü paükat wapüla —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","O'una müshiija joo naya sulu'umüin tü pueulokat. Ayatsia tü nüküjakat achiki Jesús namüin. Nekeraajakalaka tü paükat süpüla neküinjatüin tü Pascuakat yala sulu'u. ");
INSERT INTO guc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Shiasa joo aipa'a, nüntakalaka Jesús namaa na nikirajüinkana na polooshiikana piammüin eemüin tü miichikat. ");
INSERT INTO guc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Je wanaa sümaa naikkalaain sünain ekawaa, nümakalaka Jesús namüin: —Shiimüin tü tamakat jümüin jia ekaashiikana tamaa joolu'u, aapüneechi ekii taya nütüma wane ja'akajee —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mojukalaka ma'i naa'in na nikirajüinkana sütüma tü nümakat Jesús namüin. —Kasataalejese nnojolin tayain chia —namakalaka nümüin wane'ewaire nakua. ");
INSERT INTO guc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nüsouktakalaka Jesús namüin: —Chi aapüinjachikai tekii, nieechi waneeshia ja'aka jiakana polooshiikana piammüin, chi acholotitkai tü pankat shiroku tü shirakat asalaa wanaa tamaa. ");
INSERT INTO guc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Shiimüin sünain to'utinneechin aa'in maa aka tü ashajünakat paala tachiki tayakai, chi Shipayakai Wayuu. Otta chi aapüinjachikai tekii, alu'uleekaija'a ma'i nia. Anashije nnojolinkale jemelin nia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wanaa sümaa nekaain, naapaakalaka Jesús wane pan sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshaletakalaka shi'ipawalin shia namüin na nikirajüinkana, sünain nümüin namüin: —Jaapaa jikaiwa tü pankat. Maa aka taapüin joolu'u jümüin tü pankat, meechia taya sünain aapajiraain tekii jaa'u jiakana —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Naapaakalaka joo Jesús wane iita kalu'usü wiino sünain naapüin analu'ut nümüin Maleiwa saa'u. Naapakalaka shia namüin na nikirajüinkana süpüla nasüin shia napüshua wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nümakalaka namüin: —Asüüshikat tüü, müsü aka sukuaippa tü tasha amülainjatkat süpüla nikeraajüinjatüin chi Maleiwakai tü pütchi jeket pansaatüjütkalia nütüma. ");
INSERT INTO guc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tamüshii paala jia: Je joolu'u yaajee yaa, nnojoleechi taya asüin tüü tachikua wane'ere'eya tasüin so'uweena wane ka'i cha'aya nüma'anamüin chi Maleiwakai chaa eere nuluwataain —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Shiasa süchikijee nee'irajüin wane jayeechi na'waajakat aka Maleiwa, o'unüshii naya yalajee saa'umüin tü wutai kanüliakat Olivos. ");
INSERT INTO guc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Je nantapa sünainmüin tü wutaikat, nümakalaka Jesús namüin na nikirajüinkana: —O'uneena jia jüpüshua tama'anajee sünain jüpütüin taya tamüiwa maa aka tü sümakat paala, tü ashajünakat sulu'u tü nüchikimaajatkat Maleiwa makat: “To'uteechi aa'in chi anneetpü'ükai je su'walakajaweetkalaka tü na'anneetsekalüirua”. ");
INSERT INTO guc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Otta shiasa süchikijee suso'iraapa taa'in süchikijee ouktaa, o'uneechi taya jüpüleerua Galileamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Otta müshia Pedro, nümakalaka joo nümüin Jesús: —Mayaashiije napüteechin pia na waneeirua, nnojoireeja'a tapütüinjachin pia pümüiwa. ");
INSERT INTO guc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nümakalaka Jesús nümüin: —Shiimüin tü tamakat pümüin: Süpülapünaa ni'yalajüin wane kaliina piantua so'u aikat tüü, apünüintueechi taya punujulajüin achiki sünain pi'raajüin taya —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nümakalaka joo Pedro ni'ipajee: —Ja'itakaje'e ouktajachin taya pümaa, nnojoireeja'a süpüla taattajaainjachin paa'u —nümakalaka. Je mayaa müsü joo nanüiki na waneeiruaya nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nikerolokalaka Jesús namaa na nikirajüinkana süpümüin wane una'apü kanüliasü Getsemaní. Nümakalaka Jesús namüin: —Anakaja müleka jüikkalaale yaaya süma'inru'u taashajaain nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Neenajaakalaka Pedro oo'ulaka Jacobo je Juan süpüla nümaain. Nu'ttakalaka Jesús sünain mojuin ma'i naa'in ");
INSERT INTO guc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","sünain nümüin namüin: —Süpüleeruasü ma'i taa'in tü mojuukat aa'in süpülainshi tü müliaa te'reetkat. Anakaja müleka yaale jia sümaa eein jaa'in —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nükatalaakalaka joo Jesús noulia mamüin aka tüsa sünain nu'wachiraain mmalu'u sünain nüchuntüin nümüin chi Maleiwakai shii'iree naakateein tü müliaakat nuulia: ");
INSERT INTO guc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Taata Maleiwa, müleka pücheküle, anasüje puu'ule'erüle toulia tü müliaa te'reetkat joolu'u. Akatsa nnojolüin shiainjatüin paa'inrüin tü tachekakat ne'e tamüiwa, shia paa'inrüinjatka tü püchekakat tapüleerua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Shiasa süchikijee naashajaain nümaa Maleiwa, nüsha'walaakalaka sünain nürütkaain nanainmüin na apünüinshiikana nikirajüin eere natunkaja'attaain nüpüla. Nümakalaka Jesús nümüin Pedro: —¿Tunkatataashi pia, Simón? ¿Jamüshii jia nnojoliika'a juuntüin eein jaa'in wanaa tamaa motso'oyaakaije'e ne'e? ");
INSERT INTO guc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Anakaja müleka eere jaa'in süpüla jüchuntüin nümüin Maleiwa suulia nuu'ulakajüin jaa'in Satanás. Mayaainje kee'ireein jaa'in tü tachekakat jüpüleerua, isasü jüchiki —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nükatalaakalaka joo Jesús nüchikua noulia süpüla naashajaain nüchikua nümaa Maleiwa. Nüchuntüin tü nümakat paala nümüin. ");
INSERT INTO guc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Je nüle'ejapa nüchikua'aya nanainmüin na nikirajüinkana, atunküshii naya nüpüla maa aka paala, süka sütunkeein ma'i naa'in. Je nüchijirapa naya, isakalaka nachiki asouktaa nümüin. ");
INSERT INTO guc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nükatalaakalaka joo Jesús noulia nüchikua süpüla naashajaain nümaa Maleiwa maja'a aka nünüiki paala. Apünüintuaichi joo aashajaain nümaa Maleiwa süka tüü. Je nüle'ejapa nanainmüin na nikirajüinkana, nümakalaka namüin: —¿Jamüshii jia jutunkajaka'a ma'i? ¿Jamüshii jia nnojoliika'a eein jaa'in wanaa tamaa? Antüitpa takalia tayakai, chi Shipayakai Wayuu, süpüla taapünüinjachin ekii sajapulu'umüin wayuu kaainjarat. ");
INSERT INTO guc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jütamaajaa jumaala, joo'uya wo'unaiwa. Alü'ütshi chi aapüinjachikai tekii —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wanaa sümaa naashajaain Jesús namaa na nikirajüinkana, anta müshia Judas chi napüshikai na polookana piammüin. Je antapaatasü nümaa Judas wane wayuuirua wainma sümaa wunu'u oo'ulaka chajaruuta sajapulu'u. Ajütüüshi naya natüma na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana oo'ulaka na laülaayuushiikana naa'u na judíokana. ");
INSERT INTO guc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Je Judas, chi aapüinjachikai nikii Jesús, müshi paala wopulu'u sümüin tü wattakat saalin wayuu: “Chi wayuu tachu'tkai awalapa'a, nia ata'ünnajachika jütüma”, müshi nia namüin paala. ");
INSERT INTO guc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nürütkaakalaka joolu'u Judas nünainmüin Jesús sünain nümüin nümüin: —Ekirajüikalee, anii taya antüin —nümakalaka nümüin sünain nüchu'lüin nuwalapa'a. ");
INSERT INTO guc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Arütkaashiijase joo na wayuukana nünainmüin Jesús sünain nata'ülüin nia. ");
INSERT INTO guc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Otta wane nikirajüinkai Jesús, naapaakalaka tü nüchajaruutsekat. Nuwatakalaka noo'omüin wane nüchepchia chi laülaashikai napüleerua na sacerdote judíokana süpüla nüshottajachin nia. Nüchoto'oleekalaka tü nüche'ekat. ");
INSERT INTO guc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nümakalaka Jesús namüin na antakana nünainmüin: —¿Ka'ruwaraiyaa taya jaa'inru'u jüntakalaka tanainmüin sümaa wunu'u oo'ulaka chajaruuta jajapulu'u süpüla jüta'ülüinjachin taya? ");
INSERT INTO guc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Jamüshi nnojoika'a jüta'ülüin taya paala cha'aya sulu'u tü a'waajüleekat Maleiwa eere tekirajapü'üin ju'upala? Otta müsia tüü, alatüsü süpüla shikeraajüinjatüin tü nünüikikat chi Maleiwakai tachiki aküjünakat paala natüma na nünüikimaajanakana —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Je joolu'u na nikirajüinkana, na'luwataakalaka nüma'anajee sünain napütüin nia nümüiwa napüla na wayuukana. ");
INSERT INTO guc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Nata'ülakalaka wane jima'ai o'unapü'ükai nüchiirua Jesús. Otta isashi nia najapulu'ujee sünain nüpütüin tü naanalakat sünain o'unaa mashe'inyüin nama'anajee. ");
INSERT INTO guc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na ata'ülakana Jesús, no'unirüin nia yalajee nipialu'umüin Caifás, chi laülaashikai napüleerua na sacerdote judíokana, eere jutkatüin na laülaayuushiikana na'akajee na sacerdote judíokana, na laülaayuushiikana naa'u na judíokana, oo'ulaka na karalouktamaajanakana. ");
INSERT INTO guc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Otta müshia Pedro, nünanajakalaka nüchiirua ka'yatalu'ujee. Nüntakalaka so'ulu'umüin nüpaatiase chi laülaashikai. Nikerolakalaka sulu'umüin. Nüikkalaakalaka sa'aka tü suwaariasekat tü a'waajüleekat Maleiwa sünain aatulajaa. ");
INSERT INTO guc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Je yaa paülü'ü sulu'u nipia Caifás, eeshii jutkatüin na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka napüshua na waneeirua laülaayuu judío sulu'ukana tü kanüliakat Sanedrín. Süka no'uteein ma'i naa'in Jesús, nachajaa achikit wayuu süpüla süküjüinjatüin sa'alain nüchiki Jesús. Mayaainje süntüin wayuu wainma nanainmüin sünain aküjaa alawaa noo'opünaa Jesús, nnojotsü nantüin anain kasain no'utirajatüin anainjee naa'in süka nnojolüin wanaawain tü namakat nüchiki Jesús. ");
INSERT INTO guc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Müsü nanüiki waneeirua sünain nüküjayaain nüchiki: ");
INSERT INTO guc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Naashin chira, nuuntüin nujuttirüin tü a'waajüleekat Maleiwa, tü akumajünakat paala sütüma wayuu, sümaa nütame'erüinjatüin wane suwala'ata so'u apünüin ka'isan, tü wane nnojoleetkat sükumajeerüin wayuusan —namakalaka. ");
INSERT INTO guc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Otta nnojotsü wanaawajiraain tü namakat. ");
INSERT INTO guc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Otta müshia chi laülaashikai napüleerua na sacerdotekana, nüsha'walaakalaka joolu'u pasanain nanain na laülaayuukana napüshua sünain nüsakirüin Jesús: —¿Jamüinjatü joo pünüiki shi'ipajee türa namakat nala wayuukana püchiki? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Otta müshia Jesús, ko'utüshi ne'e nuulia. Ayatakalaka nia sünain asakiraa: —Tasakirüin paala pia: ¿Shiimüinjasa sünain piain Cristoin Nüneekajalakai Maleiwa? ¿Shiimüinjasa sünain piain chi Nüchonkai Maleiwa? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nüsouktakalaka Jesús: —Aa, shiimüin sünain tayain maa aka tü pümakat. Tamüshii paala jia jüpüshua: So'uweena wane ka'i, ji'reechi taya, chi Shipayakai Wayuu, sünain joyotüin taya nikialu'ujee Maleiwa chi Pülashikai ma'i saa'u kojutüin taya nütüma. Je ji'reechi taya sünain tantüin mmolu'umüin chajee nüma'anajee Maleiwa sa'aka tü sirumakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Otta müshia chi laülaashikai napüleerua na sacerdotekana, nüsükülijakalaka tü nüshe'inkat sütüma tü jashieekat sünain nümüin namüin na laülaayuu judíokana napüshua: —E'rütkatche ma'i aa'in wayumüin süka sünüiki nümüin Maleiwa. Nnojolüitpa che'ojaain wayuu wamüin aküjüinjatkat nüchiki. ");
INSERT INTO guc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jaapüitpa nünüiki sünain wanaawain nia nümaa Maleiwa naashin. ¿Kasa anaka süpüla aa'innaa nüka? —nümakalaka namüin. Nasouktakalaka nümüin: —Anakaja su'utinnüle aa'in —müshii naya. ");
INSERT INTO guc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Je joolu'u waneeirua na'aka, nejenaakalaka nu'uutajee Jesús. Nako'oyojooin tü no'ukot süka kuluulu sümaa nashe'etüin nia sünain namüin nümüin: —Müleka pialeje chi Cristo Nüneekajalakai Maleiwa, püshantaja saa'u jaralin ashe'etüin pia —namakalaka nümüin sünain neme'erainpalain nia. Nayasa'a na susurulaatsekana tü a'waajüleekat, na'yaatayaa namüshi nia. ");
INSERT INTO guc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wanaa sümaa yaain Jesús sulu'u nipia chi laülaashikai, chashi Pedro joyotüin anooipa'a sulu'u tü paatiakat. Sürütkaakalaka wane majayüt nünainmüin, tü nüchepchiakat chi laülaashikai napüleerua na sacerdotekana. ");
INSERT INTO guc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Shiirakaakalaka nümüin wanaa sümaa naatuluja'alüin. Sümakalaka nümüin: —Pia'aya'asa wane nümaapü'ükai Jesús chi Nazaretje'ewaikai —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Otta Pedro, nunujulajakalaka sünain nümüin sümüin: —Nnojoishi te'raajüin chi pümakai tamüin, nnojotsü tatüjaain aa'u tü paashajaakat achiki —nümakalaka sümüin sünain nüsünülaain eemüin tü so'ukot paatia. Akootole'erajaa müshia wane kaliina. ");
INSERT INTO guc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Shi'rapa nia süchikua tü achepchieekat, sümakalaka namüin na wayuu eejanakana sulu'u tü paatiakat: —Alu'usa chia, nümaapü'üshi Jesús —sümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naattajaakalaka Pedro nüchikua. Shiasa mapa yaaulerü, sürütkaakalaka wane wayuuirua eekana sulu'u tü paatiakat nünainmüin Pedro sünain namüin nümüin: —Pia'aya'asa wane nümaapü'ükai chira wayuukai, süka Galileaje'ewalin pia wanaa nümaa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nümakalaka Pedro namüin: —Taküjüin tachikua jümüin nu'upala Maleiwa sünain nnojolin te'raajüin chira wayuukai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Akootole'erajaa müshia wane kaliina nüchikua. Sotokalaka naa'in Pedro tü nümakat Jesús paala nümüin: “Süpülapünaa ni'yalajüin wane kaliina piantua so'u aikat tüü, apünüintueechi taya punujulajüin achiki sünain pi'raajüin taya”, nümakat. Nujuittaakalaka Pedro yalajee yala sünain mojuin ma'i naa'in sünain ni'yalajashaanain. ");
INSERT INTO guc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Shiasa mapa ja'yuupa, outkajaashii nachikua na laülaashiikana na'akajee na sacerdote judíokana, na laülaayuushiikana naa'u na judíokana, na karalouktamaajanakana, oo'ulaka napüshua na waneeirua laülaayuu judío sulu'ukana tü kanüliakat Sanedrín. Naashajaajiraain süchiki tü naa'inrüinjatkat süpüla no'utirüinjatüin naa'in Jesús. No'unitkalaka Jesús sünain kapüin nia natüma nünainmüin Pilato chi Romaje'ewaikai sülaülashikai tü mmakat Judea so'u ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—¿Pia'aya chi Aluwataashikai saa'u wayuu judío? —nümakalaka Pilato nümüin. Nümakalaka Jesús ni'ipajee: —Shia'aya tia pümakat. ");
INSERT INTO guc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Naküjakalaka na laülaashiikana na'akajee na sacerdote judíokana nümüin Pilato sünain naa'inrüin Jesús wainma kasa mojusü naajüin. ");
INSERT INTO guc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nümakalaka Pilato nümüin Jesús: —Paa'inrüin wainma kasa mojusü naashin nala wayuukana. ¿Jamüshi nnojoika'a püsouktüin shi'ipajee tü namakat? ");
INSERT INTO guc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Otta müshia Jesús, ko'utüshi ne'e nuulia. Tanataakalaka naa'in chi sülaülashikai mma sükajee tia. ");
INSERT INTO guc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Waneepia su'unna'awai tü Pascuakat, natüjainsü na judíokana taashiwalinjachin wane püreesashi nütüma chi sülaülashikai mma, chi naneekakai na wayuukana süpüla taashii. ");
INSERT INTO guc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Je wanaa sümaa tia, eeshi wane wayuu kanüliashi Barrabás, püreesashi nia namaa na nüpüshikana, na o'utüshiikana saa'in wayuu sünain ashutaa saa'u tü sülaülakat mma. ");
INSERT INTO guc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Süntakalaka joo tü wattakat saalii wayuu nünainmüin Pilato süpüla achuntaa süpüleerua naa'inrüinjatüin tü naa'inrapü'ükat namüin. ");
INSERT INTO guc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Jücheküin süpüleerua niainjachin tajütüin joolu'u chi Aluwataashikai saa'u wayuu judío? —nümakalaka Pilato sümüin. ");
INSERT INTO guc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Anasü nümüin Pilato müleka taashire Jesús, süka nütüjaain naa'u na laülaashiikana na'akajee na sacerdote judíokana sünain naapuushin Jesús sükajee ne'e na'ürülaain nünain. ");
INSERT INTO guc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Otta na laülaashiikana na'akajee na sacerdote judíokana, najütüin wane wayuuirua sa'akamüin tü wattakat saalin wayuu süpüla nashüküjainjatüin shia süpüla süchuntüin nümüin Pilato niainjachin taashin Barrabás. ");
INSERT INTO guc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nüsakirakalaka Pilato naya: —¿Kasa taa'inrüinjatka joo nüka chi “Aluwataashikai saa'u wayuu judío” jümakai? ");
INSERT INTO guc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Süsouktakalaka tü wayuukolüirua süpüshua nümüin: —Püchitira saa'u kuruusa. ");
INSERT INTO guc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nümakalaka Pilato sümüin: —¿Jamüshi takacherirüinjachika'a nia? ¿Kasa naainjalaka? Otta müshi'iya na wayuukanairua, masütaajusalii sümaa nekiisa: —Püchitira saa'u kuruusa —namakalaka nümüin nachikua sünain emetuluin ma'i nanüiki. ");
INSERT INTO guc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Otta Pilato, süka nücheküin süpüleerua talatüinjatüin saa'in tü wayuukolüirua nüka, nüjütirakalaka joo Barrabás nanainmüin. Naapakalaka joo Jesús sümüin tü nusurulaatsekalüirua süpüla na'yaajüinjachin nia je süpüla nakacherüinjachin nia sünain kuruusa süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nu'uninnakalaka Jesús sütüma tü nusurulaatsekalüirua Pilato sulu'umüin tü laülaapiakat. Seenajakalaka tü waneeirua surulaatkalüirua süpüla shi'rajüinjatüin nukua Jesús. ");
INSERT INTO guc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sa'atakalaka wane ashe'inyüü anasü nünain, jepisiiyaa, maa aka saa'in nüshe'in wane aluwataai saa'u mma, süpüla shime'erainpalain nia. Shi'itaakalaka wane kotse keimsesü saa'u nikii. ");
INSERT INTO guc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","O'ttüsü tü surulaatkalüirua sünain maa: —Pia chi Aluwataashikai saa'u wayuu judío —sünain maa nümüin sünain shime'erainpalain nia. ");
INSERT INTO guc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Shi'yaajakalaka nia kojuyatua nüralo'upünaa süka wane waraaratchon. Süsapainyo'ukayaakalaka nümülatu'u sünain na'waajayaain nia. ");
INSERT INTO guc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Shiasa süchikijee shime'erainpalain nia, saakatüin tü ashe'inyüü anasükat sa'atakat paala nünain. Sa'atüin tü nüshe'inkat nünain süchikua süpüla su'unirüinjachin nia yalajee yala süpüla sükacherüinjachin nia süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wanaa sümaa nu'uninnüin Jesús natüma na surulaatkana eemüinjachire nükachennüinjachin natüma, antüshi Jerusalénmüin wane wayuu Cireneje'ewai kanüliashi Simón, chi nüshikai Alejandro oo'ulaka Rufo. Nüta'ünnakalaka joo natüma na surulaatkana süpüla nülü'üjainjatüin tü wunu'u akachennüinjachikat anain Jesús. ");
INSERT INTO guc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","No'unirakalaka Jesús eemüin wane wutai kanüliasü Gólgota, “Ekiyüükat” malu'ut tia. ");
INSERT INTO guc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Je chamüin cha'aya, naapüin na surulaatkana nümüin Jesús wane wiino ka'akasü “mirra” süpüla nüsüinjatüin. Otta niyouktüin shia. ");
INSERT INTO guc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nayasa'a na surulaatkana süchikijee nakacherüin Jesús sünain tü kuruusakat, nashantanajiraakalaka saa'u tü nüshe'inkat süpüla natüjaainjatüin saa'u jaralin makatüinjachin apüla süpüshi tü nüshe'inkat wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Akachennüshi Jesús maa aka yaamüin ka'ikat. ");
INSERT INTO guc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eesü ashajünüin tü kasalajanakat anainjee nia sünain wane taapüla akachennüsü iipünaa sünain tü kuruusa kanainkat nia. Müsü mayaa: ANII CHI ALUWATAASHIKAI SAA'U WAYUU JUDÍO. ");
INSERT INTO guc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Je nümaa Jesús, akachennüshii piamashii wayuu ka'ruwarannuu o'utünüinjanakana aa'in wanaa nümaa. Akachennüshi wane nikialu'ujee oo'ulaka wane nüpe'eru'ujee. ");
INSERT INTO guc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Je sükajee tia, shikeraajüin tü ashajünakat paala nüchiki Jesús sünain maa: “Nia'aya wane kaainjaraiya saashin wayuu”, makat. ");
INSERT INTO guc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tü wayuu eekai sülatüin nü'ünnaa Jesús, eirakaasü nümüin sümaa mojuin sünüiki nümüin mayaa: —Aisha'ajaa pia. Pujuttirüinjatü tü a'waajüleekat Maleiwa sümaa pütame'erüinjatüin shia süchikua so'u apünüin ka'isan. ");
INSERT INTO guc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Jamaka'a nnojoika'a püshakatüin saa'ujee tü kuruusakat süpüla nnojolinjachin ouktüin pia? —sümakalaka tü wayuukolüirua nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Akaata'aya nanüiki na laülaashiikana na'akajee na sacerdote judíokana je na karalouktamaajanakana sünain neme'erainpalain nia. Namajiraakalaka: —¿Jamüshisa nnojoika'a nu'tte'erajiraain nümüiwa maa aka nu'tte'erapü'üin wayuu naashin? ");
INSERT INTO guc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nia Cristo chi Aluwataashikai saa'u tü wayuu Israelkalüirua naajüin. Müleka nüshakatüle joolu'u saa'ujee tü kuruusakat, anoujeena waya nünain —namakalaka. Otta müshi'iya na ouktajanakana wanaa nümaa Jesús, müshii aka naya sünain mojuin nanüiki nümüin. ");
INSERT INTO guc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Shiasa maa aka kale'o, epiyuushijaasü mmapa'akat süpüshua, awasaja'aleesia maa aka aliika. ");
INSERT INTO guc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Shiasa aliuukapa ka'ikat, nu'waatakalaka Jesús sünain emetuluin nünüiki sünain nümüin: “Eloi, Eloi, ¿lama sabactani?”. (Je tüü, malu'ut: “Tamaleiwasee, Tamaleiwasee, ¿jamüshi pia püpütaka'a taya tamüiwa?”, müsü.) ");
INSERT INTO guc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Je saapapa nünüiki Jesús wane wayuuirua sha'washawatsü nü'ütpa'a, müsü shia: —Nuunejüin Elías chi nünüikimaajachikai Maleiwa —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Awataa müshia wane wayuu sünain asaajaa wane maawüi ocholotinnüsü shiroku wane asüüshi jashü'üsü shi'iru'usü wane lumia süpüla shi'itaanüinjatüin sünain niimata Jesús. Nümakalaka chi wayuukai: —Anakaja müleka wa'atapajüle watüjaaiwa saa'u müleka nünteechire Elías süpüla nüshakatirüinjachin nia —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nu'waatakalaka emetut Jesús nüchikua nümüin Maleiwa. Ouktakalaka nia süchikijee. ");
INSERT INTO guc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Je sulu'u tü a'waajüleekat Maleiwa wanaa ma'i sümaa ouktüin Jesús, asüküijaasü pasanainpünaa sünain tü kuluulu so'ulujunakat tü paü shiinalu'usükat. ");
INSERT INTO guc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Je chi sülaülashikai surulaat sha'watakai nümülatu'u Jesús, naapapa nikiise Jesús je ni'rapa nia sünain ouktaa, nümakalaka: —Shiimüinyala ma'i sünain niain chi Nüchonkai Maleiwa —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Je wanaa sümaa yaain Jesús sünain tü kuruusakat, eesü wane jieyuuirua wainma sünain ananajaa maa aka türa. Naya na antüshiikana nümaa Jesús Jerusalénmüin, na aa'inmajapü'ükana nia namaa na nikirajüinkana paala wanaa sümaa waraittapü'üin naya Galileapünaa. Je na'aka na jieyuukana, eesü María Magdalena, oo'ulaka María tü niikat Jacobo chi emülieekai je José, oo'ulaka Salomé, oo'ulaka waneeirua wainma antüsükalüirua nümaa Jesús Jerusalénmüin. ");
INSERT INTO guc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Je tü ka'i ouktakat o'u Jesús, shia tü ka'i sü'lakajaakat o'u shiküin tü wayuukolüirua süpüla tü ka'i sheemeraainjatkat o'u. Eejachi wane wayuu kanüliashi José, chaje'ewai Arimatea, no'uluku na laülaashii sulujunakana tü kanüliakat Sanedrín, eekai kojutüin natüma. A'atapajüshi nia nükalia Maleiwa süpüla aluwatawaa. Je motsapa ka'i, o'unamaatüshi nia eemüin Pilato sünain nnojolin mmolüin süpüla achuntaa müliashii süpüla ni'itaainjachin nia sulu'u woowira. ");
INSERT INTO guc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Niasa'a Pilato, süka nnojolüin niyaawatüin naa'u Jesús sünain ouktüichipain, nüsakirüin wane sülaülashi surulaat soo'opünaa tia. ");
INSERT INTO guc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Shiasa nütüjaapa saa'u sünain ouktüichipain Jesús, naapüin nümüin José süpüla nüshakatirüinjachin müliashii saa'ujee kuruusakat. ");
INSERT INTO guc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Je José, nikeraajatüjülia wane kuluulu kanüliasü “linoin”. Nüshakatirakalaka müliashii sünain nüko'oloin nia süka tü kuluutkot. Eejatüja'a wane woowira akumajiruushi paala nütüma José sulu'u wane ipa müle'o süpüla nüpüshi. Akumajuushi tü shirousekat süka wane ipa müle'o. Ni'itaakalaka müliashii sulu'u tü woowirakat sünain nüsürülüin tü woowirakat süka tü ipakat. ");
INSERT INTO guc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E'nnüsü sütüma María Magdalena oo'ulaka María tü niikat José eejachire ni'itaanüin müliashii. ");
INSERT INTO guc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Je suwasajaapa aikat süchikijee tü ka'i neemeraakat o'u na judíokana, o'unüsü María Magdalena oo'ulaka María tü niikat Jacobo oo'ulaka Salomé eemüin tü woowirakat eejachire ni'itaanüin Jesús. Nalü'üjüin wane wunu'u jemeta eejuut ayalajuushi paala natüma süpüla ne'itaainjatüin shia naa'u müliashii. ");
INSERT INTO guc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aashajaajiraashii naya wopulu'u sünain maa: —¿Jarai cheje aakatüinjachika wamüin tü shirousekat so'ulu'ujee tü woowirakat? ");
INSERT INTO guc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Shiasa nantapa chamüin, nanta anainrü süsünne'eruushin tü ipa müle'o shirousesükat tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Je nekerolapa sulu'umüin tü woowirakat, ne'rakalaka wane jima'ai joyotüin nekialu'ujee sünain kasuuin ma'i nüshe'in. Sainkuukalaka ma'i naa'in na jieyuukana sütüma tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nümakalaka chi jima'aikai namüin: —Nnojo jainkuuin aa'in. Tatüjaa aa'ut sünain jüchajaain nüchiki Jesús chi Nazaretje'ewaikai, chi akachennakai paala süpüla ouktaa. Nnojoishi nia yaaya. Oso'iraaitpa naa'in nüchikua. Jürütkaa jümaala ji'rajaaiwa tü nüchikanainkat eejachire nia süpütüin wayuu. ");
INSERT INTO guc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Anakaja joolu'u müleka ju'unüle süpüla jüküjainjatüin nüchiki nümüin Pedro je namüin na waneeirua nikirajüinkana. Meena jia namüin: “O'uneechi joolu'u nia jüpüleerua Galileamüin. Ji'reechi nia cha'aya maa aka tü nümakat paala jümüin”, meena jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nakutkujaakalaka na jieyuukana je ponosü ma'i naa'in tü ne'rakat. Napantajaakalaka yalajee sulu'ujee tü woowirakat. Nnojoliishii aküjayaain süchiki tü ne'rakat sümüin wayuu süka mmolüin ma'i naya. ");
INSERT INTO guc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Oso'iraasü naa'in Jesús so'u tü palajatkat ka'i su'ttiakat semaana. Ee'iyataashi nia sümüin María Magdalena watta'a maalü nnojoliiwa'aya shi'rüin nia wayuu. Tü Maríakat anülia, shia tü ayu'nnakat oulia akaratshisü yolujaa paala nütüma Jesús. ");
INSERT INTO guc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Süchikijee shi'rüin Jesús, o'unüsü María sünain aküjaa nüchiki namüin na wayuu nümaajanakana paala. Eejana naya süpüla sünain a'yalaja'alüin süka mojuin ma'i naa'in. ");
INSERT INTO guc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Shiasa'a süküjapa namüin sünain shi'rüichipain Jesús sünain kataa o'u, nnojotsü noonooin amaa tü sünüikikat. ");
INSERT INTO guc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Je süchikijee tia, ee'iyataashi Jesús namüin wane piamashii no'uluku sünain waraittüin naya sulu'u wopu. Mayaainje waraittüin nia namaa, nnojoishi nayaawatüin. ");
INSERT INTO guc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","O'unüshii naya süchikijee nayaawatapa Jesús sünain aküjaa nüchiki namüin na napüshikana. Otta müshi'iya naairua, nnojoliishii oonooin sümaa tü nanüikikat. ");
INSERT INTO guc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Je süchikijee mapa, ee'iyataashi Jesús namüin na nikirajüin polookana waneemüin. Ekaashii naya nüpüla. Nüchiajaain naya süka matsüin nanoula je süka manoujüinyeein naya, süka nnojoliin noonooin sümaa nanüiki na wayuu e'rüshiikana nia süchikijee suso'iraain naa'in. ");
INSERT INTO guc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Je shiasa mapa, nümakalaka Jesús namüin na nikirajüinkana: “Ju'una jumata sainküin mmakat süpüshua süpüla aküjaa tachiki tayakai, chi O'tte'erüikai, sümüin wayuu süpüshua'ale'eya. ");
INSERT INTO guc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chi wayuu eekai nünoujain tanain sünain nuwoutisaajünüin, o'ttaajeechi tatüma. Alu'usa chi eekai nnojolin nünoujain tanain, kasalajaneerü nümüin naainjala. ");
INSERT INTO guc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Chi wayuu eekai nünoujain tanain, naa'inreerü tatüma kasa eekai isain süchiki wayuu, tü nütüjakat apüleerua Maleiwa nümüiwa. Ounteechi ayu'laa yolujaa je aashajawaa süka pütchi waneejatü. ");
INSERT INTO guc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Müleka naapaale wane wüi ouktasiro'ut, je müleka nüsüle wane emeneenajia, nnojoleechi ouktüin sütüma. Je ni'itaapa najapü saa'u wayuu eekai ayuulin, aneerü”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Shiasa süchikijee naashajaain chi Senyotkai Jesús namüin, nu'uninnakalaka chaa iipünaamüin eemüin chi Maleiwakai sümaa nüikkalaain nikialu'ujee. ");
INSERT INTO guc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nayasa'a na nikirajüinkana, no'unakalaka sainküin mmakat süpüshua sünain aküjaa nüchiki sümüin wayuu. Je sütüjaanakalaka aa'ut sütüma wayuu sünain pansaain nanüiki, süka nakaaliijünüin nütüma chi Senyotkai süpüla aa'inraa tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa.");
INSERT INTO guc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teófilo, pia kojutkai sütüma wayuu, tashajeerü joolu'u pümüin nüchiki Jesucristo, tü aküjünakat wamüin natüma na e'rapü'ükana tü naa'inrakat kataiwa'aya no'u, na aneekajuushikana süpüla ekirajaa tü shiimainkat. Je wainma wayuu, maa aka wayakana, eekai naapajüin tü nüchikikat Cristo, nashajüin nüchiki sümüin wayuu, süka nayaawatüin saa'u sünain shikeraajüitpain wainma tü pütchi nüküjakat chi Maleiwakai paala. Otta tayakai, süchikijee taapüin nüchiki Cristo, tasakirapü'üin anainrü. Je joolu'u süka tatüjaain saa'u sünain shiimüin tü taapakat achiki, talo'irüin sukuaippa süpüla tashajüinjatüin pümüin, süpüla lotüin pikiiru'u sünain shiimüin süpüshua tü ekirajünakat anain pia. ");
INSERT INTO guc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Je paala sümaiwa, wanaa sümaa nuluwataain Herodes sulu'u tü mmakat Judea, eeshi wane wayuu sacerdote judío kanüliashi Zacarías, oo'ulaka tü nu'wayuusekat kanüliasü Elisabet. Nuu'uliwo'u naya Aarón, chi palajachikai sacerdote na'akajee na judíokana. A'yataashi Zacarías nümüin Maleiwa namaa na waneeirua sacerdote aluwataaushikana nütüma Abías. ");
INSERT INTO guc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Otta Zacarías sümaa tü nu'wayuusekat, anashii naya no'ulu'u Maleiwa sümaa lotüin nakuaippa nu'upala süka naa'inrüin waneepia süpüshua tü nuluwataakat anain. ");
INSERT INTO guc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Otta machooinsalii naya sünain laülaain süka maralüin Elisabet. ");
INSERT INTO guc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Alü'ütsü nakalia na sacerdote aluwataaushikana nütüma Abías süpüla na'yataainjanain nümüin Maleiwa. Wanaa sümaa na'yataain sünain sacerdotein, aneekünüshi Zacarías na'akajee süpüla nikerolüin sulu'umüin tü a'waajüleekat chi Maleiwakai süpüla na'ajüin wane wunu'u jemeta eejuut sünain a'waajaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Je wanaa sümaa na'ajüin tü wunu'ukot, eesü jutkatüin süpüshua tü a'waajüsükalüirua yaa anooipa'a sünain aashajawaa nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Antalaa müshi wane aapiee chajee eejee Maleiwa nünainmüin Zacarías. Sha'watüshi chi aapieekai yaa nikialu'ujee sü'ütpa'a tü a'ajüleekat tü wunu'ukot. ");
INSERT INTO guc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Otta ni'rapa chi aapieekai, ayo'ujaasü naa'in sümaa mmolüin ma'i nia neema. ");
INSERT INTO guc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nümakalaka joo chi aapieekai nümüin: —Zacarías, nnojo mmolüin pia teema. Naapüinjatü chi Maleiwakai joolu'u pümüin tü kasa püchuntakat nümüin. Kachonweerü pümüin tü pu'wayuusekat wane jo'uu toolo. Anakaja pi'itaale nünülia Juain. ");
INSERT INTO guc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Talateerü ma'i saa'in wayuu wainma saapapa nüchiki sünain niweetüin, je talateerü ma'i paa'in nümaa weinshi. ");
INSERT INTO guc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kojuteechi nia nütüma Maleiwa sümaa eeinjachin chi Naa'inkai sulu'u naa'in waneepia, süpülapünaa jemelin nia je süpüla ka'ikat süpüshua. Je süpüla sütüjaain naa'u wayuu sünain aneekuushin nütüma Maleiwa, anashi müleka nnojoire nüsüin wane asüüshi eekai jashü'üin. ");
INSERT INTO guc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nükaaliijeerü chi püchonkai wainma tü wayuu Israelkalüirua süpüla sünoujainjatüin nünain chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O'uneechi nia nüpüleerua Maleiwa sünain katsüin naa'in nütüma chi Naa'inkai, maa aka naa'in Elías chi nünüikimaajachikai Maleiwa paala sümaiwa. Je sütüma nünüiki chi püchonkai, aijiraweerü wayuu wainma sümaa süchooin süchikua. Je na wayuukana ayouktapü'ükana nünüiki Maleiwa, nayaawateerü aa'u sünain kekiin na nüchooinkana Maleiwa je o'tteena naya sünain naapüin nanüiki. Shiimü'inya sünain yapajeerüin saa'in wayuu wainma nüpüla Maleiwa sütüma nünüiki chi püchonkai, je kamaneejeena naya nümüin nüntapa nanainmüin —nümakalaka chi aapieekai nümüin Zacarías. ");
INSERT INTO guc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nüsakirakalaka Zacarías chi aapieekai: —Laülaaichi ma'i taya, je ta'wayuuse, laülaairü. ¿Kaseerü tatüjaaka atüma saa'u sünain shiimüin tü püküjaitpakat tamüin süchiki sünain kachonweerüin tü ta'wayuusekat? ");
INSERT INTO guc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nüsouktakalaka chi aapieekai: —Taya Gabrielkai anülia, nüma'anajeejachikai Maleiwa. Aluwataaushi taya nütüma pünainmüin süpüla taküjainjatüin pümüin süchiki tü kasa anasü alateetkat jümüin. ");
INSERT INTO guc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Je süka nnojolin pünoujüin joo tanüiki, manüleechi pia. Je wane'ere'eya paashajaain shikettaajapa süka'iya tü taküjakat achiki pümüin —nümakalaka nümüin Zacarías. ");
INSERT INTO guc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wanaa sümaa naashajaain, asukaasü tü wayuukolüirua yala anooipa'a nüpüla süka kama'ain ma'i nia yala sulu'u tü a'waajüleekat. ");
INSERT INTO guc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Je nujuittaapa, isasü nüchiki naashajaain namaa na wayuukana süka manülin nia. Otta saa'u naashajaain namüin süka najapü, nayaawata aa'u sünain shii'iyataain nümüin wane kasa yala sulu'u tü a'waajüleekat. ");
INSERT INTO guc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Shiasa kettaapa sükalia ni'yataain Zacarías sünain sacerdotein nia, o'unüshi nipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Shiasa süchikijee tia, ipootsü joo Elisabet tü nu'wayuusekat. Süsürülaakalaka maa aka ja'rai kashi. ");
INSERT INTO guc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","A'waajüsü Maleiwa sünain: “Nümüliajüin taya chi Maleiwakai saa'u anamiain ma'i nia tamüin. Nnojoleerü joo taya shime'erainpalain wayuu saa'u maralüin taya”, sünain sümüin nümüin. ");
INSERT INTO guc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Shiasa maa aka aippirua kashi sünain ipoolüin Elisabet, aluwataanüshi chi aapieekai Gabriel nütüma Maleiwa sünainmüin wane majayülü kepiasü sulu'u wane pueulo kanüliasü Nazaret sulu'u tü mmakat Galilea. Otta sünülia tü majayütkat, María. Nnojoyülia shia nünainpünaain wayuu toolo. Achuntuushiirü shia nütüma wane wayuu José anüliai süpüla nu'wayuuse. Otta José, nuu'uliwo'u David chi sülaülakai mma paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nüntakalaka joo chi aapieekai sünainmüin María sünain nümüin sümüin: —¿Jamayaa pia? Eeshi chi Maleiwakai pümaa süka kojutüin ma'i pia nütüma. ");
INSERT INTO guc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","“¿Jamalu'ut cheje nünüiki tamüin makalaka joolu'u nüsaküin taya?”, majataasü saa'in María süka sainkuuin saa'in sütüma tü nümakat chi aapieekai sümüin. ");
INSERT INTO guc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ayatshi chi aapieekai aashajaain sümüin: —María, Nnojo mmolüin pia neema Maleiwa, süka nüneeküin pia süpüla wane kasa anasü. ");
INSERT INTO guc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ipooleerü joo pia. Jemeyuleerü pia nümaa wane jo'uu toolo je pi'itaajeerü nünülia chi jo'uukai Jesúsüin. ");
INSERT INTO guc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Kojutshaateechi chi jo'uukai nütüma chi Maleiwa Miyo'ushikai ma'i sümaa: “Pia Tachonka”, nümeechin nümüin. Aneekuushi chi jo'uukai nütüma Maleiwa süpüla nuluwataainjatüin tü wayuu judíokalüirua, tü nuu'uliwo'ukalüirua Jacob, maa aka nuluwataapü'üin paala sümaiwa chi putuushikai David. Müichia nnojolin oo'ulaain suulia aluwatawaa —nümakalaka chi aapieekai sümüin María. ");
INSERT INTO guc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Otta sünüiki María nümüin: —¿Jamakuaippatkai taya kachoinjatüin sünain nnojolüin nünainpünaain taya wayuu toolo? —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Asouktüshi joo chi aapieekai: —Chi Maleiwa Miyo'ushikai ma'i, nuluwataainjachi chi Naa'inkai pünainmüin. Ni'itaweetkalaka pümüin kachonwaa, süpüla “Pia Tachon Maainjalasaikai”, süpüla nümünüinjachin chi jo'uukai nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Soto paa'in sünain nnojolüin kasain isain nüchiki Maleiwa. Je wane kasaya: tü püü'itkat Elisabet, tü maratkat paala, aippiruairü kashi sünain ipoolüin shia. Mayaasüje laülaain, kachonsü. Shiimüin sünain nnojolüin kasain isain nüchiki Maleiwa —nümakalaka chi aapieekai sümüin María. ");
INSERT INTO guc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sümakalaka joo María ni'ipajee: —Anuuitpaja joo taya nümüin Maleiwa. Anashi müleka naa'inrüle taka tü püküjakat achiki tamüin. Shiasa süchikijee tia, o'unüshi chi aapieekai süma'anajee. ");
INSERT INTO guc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Je süchikijee maa aka palitchon ka'i, o'unüsü María sünain suwa'ülaain chaa eemüin Elisabet eere kepiain shia nümaa Zacarías chi su'wayuusekai sulu'u wane pueulo pasanain sünain uuchi sulu'u tü mmakat Judea. Je süntaiwa'aya María nepialu'umüin, süsaküin Elizabet. ");
INSERT INTO guc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Je saapaiwa'aya Elisabet sünüiki María, akutulaashi chi süchonkai yaa süle'eru'u. Je Elisabet, wanaa sümaa tia, antüshi chi Naa'inkai Maleiwa saa'u süpüla sümüin ");
INSERT INTO guc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","sümüin María, sünain emetuluin sünüiki: —Anata'aleesüja'a ma'i pia nütüma Maleiwa suulia jieyuu maleekalia. Je anata'aleeshija'a ma'i chi jo'uu jemeyuleetkai amaa pia. ");
INSERT INTO guc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Atak, anasüja müin te'iyouin pia, pia niikat chi Tasenyotsekai. ");
INSERT INTO guc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Taapaiwa'aya pünüiki sünain püsaküin taya, akutulaashi chi tachonkai tale'eru'u süka talatüin naa'in. ");
INSERT INTO guc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Anata'aleesüja'a ma'i pia, süka pünoujain sünain shikettaajünüinjatüin süpüshua tü nüküjakat achiki Maleiwa pümüin —sümakalaka Elisabet sümüin María. ");
INSERT INTO guc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ee'irajüsü joo María sünain su'waajüin chi Maleiwakai: “Kojutüshi ma'i chi Tamaleiwasekai tatüma süka süpüshua taa'in. Talatashaatasü ma'i taa'in nümaa, süka niain o'tte'erüinjachin taya ");
INSERT INTO guc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","je süka nükaaliijain taya nüchepchiakat sa'akajee tamüliala. ‘Anata'aleesüja'a ma'i shia nütüma Maleiwa’, meerü tamüin wayuu joolu'u je watta ka'i, ");
INSERT INTO guc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","süka naa'inrüin kasa anashaatasü ma'i tamüin. Ta'waajüin chi Maleiwakai süka pülashin nia je süka maainjalain. ");
INSERT INTO guc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nümüliajüin paala chi eekai kojutüin nia nütüma, je ayateechi nia amüliajüin na eekana kojutüin nia natüma. ");
INSERT INTO guc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","52","Je süka pülashin ma'i nia, naa'inrüin tü kasa ponokot saa'in wayuu. Na eekana pülain naa'in nuulia, maa aka na sülaülashiikana mma, mapülainsalii nütüma. Otta tü wayuu mapülainsatkalüirua, kojutshii naya nütüma. ");
INSERT INTO guc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chi eekai alin jamü nümüin, emirashi kasa anasü nütüma, otta chi washitshikai, ajütünüshi nüma'anajee nütüma sünain majapulu'ujanain. ");
INSERT INTO guc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Je waya nüchepchiakana Maleiwa, na nuu'uliwo'ukana Israel, aa'inmajünüshii waya nütüma, ");
INSERT INTO guc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","süka pansaain nünüiki namüin na watuushikana sünain nümüin namüin, ‘Tamüliajeena waneepia Abraham oo'ulaka na nuu'uliwo'ukana’ ”. Shia tü sümakat María sünain su'waajüin chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Je süchikijee maa aka apünüin kashi sünain chain María süma'ana Elisabet, ale'ejüsü shipialu'umüin süchikua. ");
INSERT INTO guc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Shiasa kettaapa joo tü sükaliakat Elisabet jemeyulajatkat o'u shia, jemeyuttaalakalaka shia nümaa wane jo'uu toolo. ");
INSERT INTO guc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Je na süpüshikana oo'ulaka na wayuu kepiakana pejepünaa sünain, naapaiwa'aya süchiki, wanaawajiraasü naa'in sümaa Elisabet sünain talatüin ma'i naa'in. Nayaawata aa'uchi chi Maleiwakai sünain nümüliajüin Elisabet, tü maratkat paala, sünain naapüin kachonwaa sümüin. ");
INSERT INTO guc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Je nakuaippa na judíokana nümüin wane jo'uu toolo, o'yotoona atachi, süka shiain niyaawasein wane nüpüshikai Maleiwa. Je süntapa mekiisat ka'i nükalia chi süchonkai Elisabet, antüshii na süpüshikana oo'ulaka na kepiakana pejepünaa sünain süpüla e'rajaa sukua tü o'yotoonookat ata. —Anasü Zacaríasüi nünülia wanaawaiwa nünülia nümaa chi nüshikai —müsü naashajiraala na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Otta sünüiki tü niikat: —Nnojo. E'itaaneerü Juain nünülia —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nasouktakalaka joo na wayuukana: —Nnojoishi wayuu eekai Juain nünülia sa'aka tü jüpüshikalüirua. ");
INSERT INTO guc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aashajaashii joo na wayuukana süka najapü nümüin nüshi chi jo'uukai sünain nasakirüin nia sünain tü nünüliainjatkat chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nüsaajitkalaka joo Zacarías wane taapüla süpüla nüshajüinjatüin sünain. Otta tü wayuukolüirua, ainkuusü ma'i saa'in sütüma tü nüshajakat: “E'itaanüitpa Juainjatüin nünülia”, müsü tü nüshajakat. ");
INSERT INTO guc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Je wanaa sümaa yaain nüshajüin, kanü'iraa müshi. Nu'waajakalaka joo chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ponusü ma'i saa'in tü wayuu e'rajaasükalüirua nukua chi jo'uukai tü ne'rakat. Otta tü wayuu kepiasükalüirua sa'akapünaa tü uuchikat yala sulu'upünaa tü mmakat Judea, yootüshii ma'i naya süchiki süpüshua tü alatakat. ");
INSERT INTO guc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","“¿Wanewee cheje wayuu anashi chi jo'uukai miyo'upa nia?”, müshii naya, süka nayaawatüin naa'u sünain naa'inmajünüin nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Otta Zacarías, chi nüshikai chi jo'uukai, antüshi chi Naa'inkai Maleiwa naa'u süpüla nuuntüinjatüin nüküjain süchiki tü naa'inrüinjatkat chi jo'uukai. Müshi nia namüin na wayuukana: ");
INSERT INTO guc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Waya nuu'uliwo'ukana Israel, anashii wa'waajüle chi Wamaleiwasekai. Sotüshii waya naa'in süpüla taashinjanain waya suulia waainjala ");
INSERT INTO guc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","nütüma chi O'tte'erüikai Pülashikai ma'i, chi nuu'uliwo'ukai David nüchepchiakai Maleiwa. Nia chi aküjünapü'ükai achiki natüma na nünüikimaajanakana Maleiwa paala sümaiwa, na akatannakana suulia kaainjalaa. ");
INSERT INTO guc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","72","Nikeraajüin chi Maleiwakai tü nümakat namüin na watuushikana sünain nümüliajüinjanain naya, tü pütchi e'itaanakat nütüma. Je joolu'u, watüjaa aa'ulu sünain nu'tte'ereenain waya noulia na wa'ünüükana je noulia na eekai kanain waya naa'in. ");
INSERT INTO guc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Pansaasü nünüiki chi Maleiwakai paala nümüin chi watuushikai Abraham sünain nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Piakai, namaa na püchooinkana, anajiraajeena jia tamaa je akatalaajeena jia suulia jaainjala. Takaaliijeena jia süpüla ji'yataainjanain tamüin waneepia sümaa nnojolüin mmolüin jaa'in neema na jü'ünüükana, süka tajuittireenain jia nama'anajee’, müshi chi Maleiwakai nümüin”. ");
INSERT INTO guc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aashajaashi joo Zacarías nümüin chi jo'uukai: “Tachee, pieechi nünüikimaajachika chi Maleiwa Miyo'ushikai ma'i, süka pu'unajachin nüpüleerua chi Senyotkai süpüla pikeraajüin tü nüpünakat nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Paapireena na nüpüshikana Maleiwa sünain nümüliajüinapain naya. Je joolu'u, nülatireein naainjala noulia süpüla nu'tte'erüinjanain naya. Shiimüin sünain nüjütüinjachin chi O'tte'erüikai wanainmüin chajee iipünaajee ");
INSERT INTO guc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","süpüla nükaaliijainjanain waya mmotkana seema ouktaa saaliijee waainjala, je süpüla naapüinjatüin wane anaa wamüin”, müshi Zacarías nümüin chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Otta müshia chi jo'uukai, ataralaashi joo nia sünain yalayalain ma'i. Kepiashi nümüiwa cha'aya isashiipa'a kojuya juya süpülapünaa niweetüin sümüin tü wayuu Israelkalüirua. ");
INSERT INTO guc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Je tü wayuukolüirua sainküin mmakat süpüshua, aluwataanüshii naya nütüma chi sülaülashikai mma, Augusto Césarkai anülia, kepiakai Roma. Je chi sülaülashikai tü mmakat Siria eere kepiain María, nia Cirenio. Je so'u tü juya ipootkat o'u María, aapinnüsü wayuu süpüshua süpüla ayaawajünaa. Nnojotsü ayaawajünaajüin tü wayuukolüirua paalainka maa aka shiyaawajünüin joolu'u. ");
INSERT INTO guc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ajütünüsü tü wayuukolüirua süpüshua sulu'umüin suumain süpüla yaawaa cha'aya. ");
INSERT INTO guc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Otta müshia José, o'unüshi nuumainpa'amüin süpüla ayaawajünaa. O'unüshi sulu'ujee tü pueulokat Nazaret eejachire kepiain sulu'u tü mmakat Galilea chamüin sulu'umüin tü mmakat Judea eemüin wane pueulo kanüliasü Belén, tü nuumainkat David sümaiwa chi nutuushikai. Shia nuumainka José maa'ulu yaa süka niain nülüin David. Otta María, tü nüchuntalakat paala, o'unüsü nümaa sümaa jakütüin ma'i shia. ");
INSERT INTO guc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Otta nantapa chamüin Belénmüin, wotüsü tü atunküleekat noulia. Kettaataalakalaka sükalia María süpüla jemeyulüinjatüin shia. Jemeyuttaalakalaka María nümaa chi shi'irumakai sulu'u shipia mürüt. Süko'oyotkalaka chi jo'uukai süka wane kuluulu. Je sutunkirakalaka nia sulu'u wane shiitain mürüt. ");
INSERT INTO guc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Je so'u aikat tia, eeshii wane wayuuirua arüleejülii sünain aa'inmajaa na'anneetse süpa'a wane anooishi cha'aya sü'ütpa'a Belén. ");
INSERT INTO guc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nii'iyalaakalaka wane aapiee chajee iipünaajee namüin sümaa warattuuin tü mmakat nütüma süka nüma'anajeejachin nia Maleiwa. Mmotshaatashii ma'i na arüleejüliikana sütüma tia. ");
INSERT INTO guc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Nnojo mmolüin jia teema”, nümakalaka chi aapieekai namüin. “Taküjainjatü joolu'u jümüin süchiki wane kasa anasü talatüinjatkat amaa saa'in wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","So'u ka'ikat tüü, jemelichipa jümüin wane jo'uu toolo yaa sulu'u Belén, tü nuumainkat David. Nia chi Senyotkai, Cristokai anülia, chi Nüneekajalakai Maleiwa süpüla nu'tte'erüinjatüin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jünteechi anain chi jo'uukai ko'oyooin süka kuluulu sünain ju'letachoin sulu'u wane shiitain mürüt. Je sükajee tia, jütüjaweerü aa'u sünain shiimüin tü tamakat jümüin”, nümakalaka chi aapieekai namüin. ");
INSERT INTO guc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Je nümaa chi aapieekai, eweenuwaasü yaawala wane aapieeirua watta saalin iipünaajee sünain na'waajüin Maleiwa nee'irainru'u sünain maa: ");
INSERT INTO guc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wa'waajüin chi Maleiwakai chaa iipünaa saa'u nii'iyatüin na'anasia sümüin wayuu yaa mmolu'u shii'iree anajiraainjanain naya nümaa”. ");
INSERT INTO guc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Shiasa no'unapa na aapieekana nachikua iipünaamüin eemüin Maleiwa, aashajaajiraashii na arüleejüliikana nachikiru'u: —Joo'uya wo'unaiwa Belénmüin we'rajaaiwa tü kasa alatakat, tü nüküjirakat achiki wamüin chi Maleiwakai —müshii naya. ");
INSERT INTO guc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","No'unakalaka joo na arüleejüliikana sünain nawa'ülaain pueulopa'amüin eere nantüin sünain María je José oo'ulaka chi jo'uukai ju'letachoin sulu'u tü shiitainkat mürüt. ");
INSERT INTO guc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Je na arüleejüliikana süchikijee ne'rüin chi jo'uukai, naküja achikit sümüin wayuu süpüshua sünain kaapiain paala naya nüchiki chi jo'uukai nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Je na aapakana nanüiki, ponusü ma'i naa'in tü naküjalakat. ");
INSERT INTO guc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Otta María, jülüjasü saa'in waneepia tü shi'rakat paala oo'ulaka tü saapakat achiki joolu'u, sümaa talatüin ma'i saa'in sütüma. ");
INSERT INTO guc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","No'unakalaka joo na arüleejüliikana nepialu'umüin sünain na'waajüin Maleiwa saa'u süpüshua tü ne'rakat je süpüshua tü naapakat achiki, sünain wanaawain ma'i shia sümaa tü aküjünakat achiki paala namüin. ");
INSERT INTO guc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Shiasa so'u tü mekiisatkat ka'i nükalia chi süchonkai María, keraasü joo nükalia süpüla shi'yotoonüin nüta, süka shiain niyaawasein wane nüpüshikai Maleiwa. Je so'u ka'ikat tia, e'itaanüsü nünülia Jesúsüin, süka shiain e'itaanatüjülüin tia anülieekat nünain nütüma chi aapieekai paala süpülapünaa ipoolüin María. ");
INSERT INTO guc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Je saashin tü nüshajakat Moisés, wane wayuu judío süchikijee jemeyulaa, nnojotsü anain shikerolüin sulu'umüin tü a'waajüleekat Maleiwa so'u maa aka wane kashi, süka nnojolüin wulein shia nu'upala Maleiwa. Otta müshi'iya José sümaa María, keraapa nakalia sünain wuleinjanain naya, nalü'üjakalaka chi nachonkai Jerusalénmüin süpüla ne'itaainjachin nia najapulu'u Maleiwa chaa sulu'u tü a'waajüleekat, süka ");
INSERT INTO guc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","shiain sotüin naa'in tü nuluwataakat anain Maleiwa sümaiwa paala: “Chi jo'uu e'irumaakai, e'itaanajachi tajapulu'u”. ");
INSERT INTO guc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eesü nama'ana wuchii o'utünajatkat aa'in nümüin Maleiwa maa aka sümakat tü nüshajakat Moisés: “Piama wawaachi, piama toomas shiale eekai motsoyünnuuchen”. ");
INSERT INTO guc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Je nantapa eemüin tü a'waajüleekat, eekalaka napüla wane wayuu kanüliashi Simeón, kepiashi Jerusalén. Nia wayuuka anashi no'ulu'u Maleiwa süka jüüjüüin waneepia nümüin. Na'atapüin Simeón tü ka'i akaaliijünüinjatkat o'u tü wayuu Israelkalüirua nütüma Maleiwa. Eeshi chi Naa'inkai Maleiwa nümaa, ");
INSERT INTO guc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","je nii'iyatatüjülia nümüin Simeón sünain nnojolinjachin ouktüin nia süpülapünaa ni'rüin Cristo chi Nüneekajalakai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eejachi Simeón napüla, süka neenakünüin chamüin nütüma chi Naa'inkai Maleiwa. Shiasa nantapa José oo'ulaka María je Jesús chi nachonkai süpüla ne'itaainjachin nia najapulu'u Maleiwa maa aka tü nümakat Moisés, ");
INSERT INTO guc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","naapaakalaka Simeón chi jo'uukai sümaa nu'waajüin Maleiwa sünain maa: ");
INSERT INTO guc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Maleiwakalee, Aluwataakai waa'u, keraataainja joo taya chi püchepchiakai süpüla ouktaa sünain anain taa'in, süka paa'inrüitpain tü püküjakat tamüin paala. ");
INSERT INTO guc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Te'rüichipa joo chi aneekünakai pütüma su'upala wayuu süpüshua süpüla nu'tte'erüinjachin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nütüma chi jo'uukai, na gentilekana, na nnojoliikana püpüshin, nountüin ne'raajüin pia. Je na püpüshikana Israelkana, na'waajeechi pia naa'u chi jo'uukai, süka pansaain pünüiki namüin”, nümakalaka Simeón. ");
INSERT INTO guc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Otta nüshi chi jo'uukai sümaa tü niikat, ponüsü ma'i naa'in tü aküjünakat nüchiki chi nachonkai. ");
INSERT INTO guc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nümakalaka joo Simeón namüin: —Anata'aleeshiija'a ma'i jia. Otta sümüin tü niikat: —María, aneekuushi chi jo'uukai nütüma Maleiwa süpüla sütüjaainjatüin saa'u tü wayuu Israelkalüirua sünain su'ttaainjatüin nünainjee müleka sünoujale nünain. Akaajasa eekai nayouktüin, amülouijeena naya. Ja'yeetkalaka sünain niyouktünüin chi Maleiwakai süka niyouktünüin chi jo'uukai. Je mojeerü ma'i paa'in pi'rapa tü e'ralaakat wayumüin nümüin chi püchonkai —nümakalaka Simeón. ");
INSERT INTO guc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Je cha'aya sulu'u tü a'waajüleekat, eesü wane wayuu laülaa, oukta a'wayuuset, nünüikimaajatü Maleiwa kanüliasü Ana, nüchon Fanuel, nuu'uliwo'u Aser. Akaratshi ne'e juya eejatüin shia nümaa chi su'wayuusekai süpülapünaa ouktüin nia. ");
INSERT INTO guc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mekiisalüirü shikii juya pienchimüin sünain sümüiwain. Nnojotsü ojuittüin shia sulu'ujee tü a'waajüleekat. Ayatsü so'uka'i, sa'wai sünain su'waajüin Maleiwa, sünain saashajaain nümaa je sünain saamajüin. ");
INSERT INTO guc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wanaa sümaa najapulu'uin chi jo'uukai Simeón, sürütkaakalaka joo Ana nanainmüin, sünain saapüin analu'ut nümüin Maleiwa. Shiasa süchikijee tia, aküjasü waneepia nüchiki chi jo'uukai namüin na wayuu a'atapajakana süpüla taashinjanain na wayuukana Israelkana suulia müliaa. ");
INSERT INTO guc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Otta müshia José sümaa María, süchiki naa'inrapa süpüshua tü aluwataanakat anain nütüma Moisés, ale'ejüshii naya nümaa chi nachonkai noumainpa'amüin sulu'umüin tü pueulokat Nazaret cha'aya Galilea. ");
INSERT INTO guc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Otta müshia chi jo'uukai, jintüishi joo nia. Yalayalashi sümaa kekiin ma'i nia, je nii'iyatüin Maleiwa waneepia na'anasia nümüin. ");
INSERT INTO guc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Je nakuaippa chi nüshikai Jesús sümaa tü niikat, o'unapü'üshii naya wwatua süpüla juyakat chamüin Jerusalénmüin sünainmüin tü mi'iraakat kanüliasü “Pascua” münüin. ");
INSERT INTO guc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Je so'u tü polookot piammüin juya nuuyase chi nachonkai, o'unüshi nia namaa sünainmüin tü mi'iraakat maa aka no'unapü'üin paala. ");
INSERT INTO guc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Shiasa keraapa tü mi'iraakat, o'unüshii naya nachikua nepialu'umüin. Otta müshia chi nachonkai, nnojoishi o'unüin namaa. Saa'u wainmain wayuu sünain o'unaa namaa, nnojoliishii nayaawatüin saa'u sünain makatüin nia noulia. ");
INSERT INTO guc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nnojoishi nia nasukajüin so'u tü waneekat ka'i waraittüin naya, süka yaayaain nia naashin sa'aka tü wayuukolüirua. Otta natüjaapa naa'u sünain nnojolin nia namaa, nachajaakalaka nüchiki sa'akapünaa tü napüshikalüirua je sa'akapünaa tü ne'raajüinkalüirua. ");
INSERT INTO guc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Je süka nnojolüin nantüin nünain, nale'ejaakalaka nachikua yaawala Jerusalénmüin sünain nachajaain nüchiki cha'aya. ");
INSERT INTO guc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Je so'u tü apünüinkat ka'i, nantakalaka nünain sulu'u tü a'waajüleekat Maleiwa. Eekalaka nia joyotüin napüla na'aka na ekirajüliikana sünain aapajaa nanüiki je sünain asakiijaa naya. ");
INSERT INTO guc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Otta tü wayuu aapajüsükalüirua, ponüsü ma'i saa'in tü nümakat chi jintüikai namüin na laülaayuukana, süka nütüjüin ma'i asouktaa ne'ipajee. ");
INSERT INTO guc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Otta tü niikat nümaa chi nüshikai, ponüshi ma'i naa'in chi nachonkai ne'rapa tü naa'inrakat. Je mapa, sümakalaka tü niikat nümüin: —Tachonchee, ¿jamüshii nnojoliika'a paapirüin waya sünain makatajachin pia? Achajaashii waya püchiki sünain shapaain ma'i waya paa'u —sümakalaka tü niikat nümüin. ");
INSERT INTO guc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nüsouktakalaka joo chi jintüikai namüin: —¿Jamüshii jia jüchajaaka'a tachiki? Yaaweeyülia paala taya yaa sulu'u nipia chi Tashikai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Otta tü niikat oo'ulaka chi nüshikai, nnojotsü nayaawatüin aa'u tü nümakat chi nachonkai namüin. ");
INSERT INTO guc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Je shiasa süchikijee tia, o'unüshi Jesús namaa nepialu'umüin, chaa palaamüin Nazaretmüin, sünain jüüjüüin waneepia namüin cha'aya. Je tü niikat süchikijee, jülüjasü saa'in waneepia tü shi'rakat je tü saapakat joolu'u nüchiki chi süchonkai. ");
INSERT INTO guc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Je mapa, ataralaashi joo Jesús sümaa kekiin ma'i je sümaa yalayalain. Kojutshi nia sütüma wayuu süpüshua, je talatüsü ma'i naa'in Maleiwa nümaa. ");
INSERT INTO guc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Je so'u tü polookot ja'ralimüin juya nuuyase chi Tiberio Césarkai anülia sünain aluwatawaa sulu'u tü mmakat süpüshua, eeshii na pienchishii sülaülashiikana noumain na wayuu judíokana. Eeshi Poncio Pilato chi Romaje'ewaikai sülaülashikai tü mmakat Judea. Eeshi Herodes chi sülaülashikai Galilea. Eeshi Felipe, nimülia Herodes, sülaülashi Iturea je Traconite. Otta eeshi Lisanias sülaülashi Abilinia. ");
INSERT INTO guc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Je so'u juyakat tia, eeshii piamashii laülaashiikana napüleerua na sacerdote judíokana, kanüliashi Anás, je nünülia wane, Caifás. Je so'u juyakat tia, naashajaakalaka chi Maleiwakai nümaa Juan chi nüchonkai Zacarías wanaa sümaa chajachin nia kepiain cha'aya isashiipa'a. ");
INSERT INTO guc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nu'unakalaka Juan sütüma tü nümakat Maleiwa nümüin sa'akamüin wayuu sainküin mmakat eepünaa tü süchikat Jordán. Nu'ttakalaka sünain nime'ejüin naa'in na wayuukana shii'iree nayaawajaain suulia naainjala sümaa nakatalaain suulia süpüla sülatinnüinjatüin noulia. Je nuluwataain na oonookana sümaa nünüiki sünain nawoutisaajünüin. ");
INSERT INTO guc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tü naa'inrakat Juan, shia tü ashajünakat achiki paala sümaiwa nütüma Isaías chi nünüikimaajachikai Maleiwa sünain maa: “Owoottaweechi wane wayuu cha'aya isashiipa'a sünain maa: ‘Yapa jütüma nüpüna chi Senyotkai. Juu'ulaa suulia jaainjala süpüla nüntajachin ja'akamüin. ");
INSERT INTO guc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wanaaweesü tü wopukat jütüma. Aakatüneesü tü namünakalüirua. Ase'ejüneesü eekai japatshin. Alo'inneesü eekai shokotüin. ");
INSERT INTO guc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yapa jütüma nüpüna chi Senyotkai süpüla sütüjaainjatüin wayuu süpüshua naa'u sünain niain chi O'tte'erüikai’ ”. ");
INSERT INTO guc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nümakalaka Juan namüin na wayuu outkajaakana nünainmüin shii'iree nuwoutisaajaa: “Jiakana wüi ouktasiro'ut, e'rülii wayumüin jia. Nnojoleerü kasalajanain jaainjala jümüin jaajüin sükajee ne'e juwoutisaajünüin, nnojoleena jia e'rüin müliaa jaajüin süsala. ");
INSERT INTO guc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Müleka shiimüinreje sünain jükatalaain suulia jaainjala, atüjaaneerü aa'u tia sünainjee tü kasa anasü jaa'inrakat. Je nnojotsü che'ojaain ju'waataain sulu'u nuu'uliwo'uin jia Abraham. Müleka nnojoliire jaa'inrüin tü nuluwataakat anain jia Maleiwa, süsaleena jia nütüma. Müleka nücheküle Maleiwa, eesü süpüla jaa'a sümeerüin tü ipakalüirua nütüma süpüla shiainjatüin nuu'uliwo'uin Abraham. ");
INSERT INTO guc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Müleka nnojorule jaa'inrüin tü anasükat nu'upala Maleiwa, aleejüneena jia nütüma, maa aka süshottünüin sümaa sujutünüin so'u siki wane wunu'u eekai nnojolüin anain süchon”. ");
INSERT INTO guc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nasakirakalaka joo na wayuukana sütümajee tü nümakat namüin: —¿Kasa anaka süpüla waa'inrüin süpüla wee'iyatüin pümüin sünain wakatalaaitpain suulia waainjala? ");
INSERT INTO guc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Asouktüshi Juan namüin: —Chi wayuu eekai piamain nüshe'in, anasü müleka nüsülajüle waneesia nümüin wayuu eekai mashe'in. Je chi eekai keküin, anashi müleka nüsülajüle süpüshi tü niküinkat nümüin eekai meküin —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Je na'aka na wayuu antakana nünainmüin Juan shii'iree nuwoutisaajaa, eeshii wane okotchajülii neerü nümüin chi sülaülashikai mma. —Ekirajüikalee, saa'u pümüichipain wamüin, ¿kasa anaka süpüla waa'inrüin süpüla wee'iyatüin pümüin sünain wakatalaaitpain suulia waainjala? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Nnojo sülatüin jütüma süpüleerua wayuu tü suwalaajüinjatkat nümüin chi sülaülashikai mma —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nasakirakalaka joo wane surulaalüirua: —Jama wayakana, ¿kasa anaka süpüla waa'inrüin süpüla wee'iyatüin pümüin sünain wakatalaaitpain suulia waainjala? Asouktüshi nia namüin: —Nnojo ji'ike'erüin wayuu süka ja'alain saa'u sükorolo. Nnojo jüta'ülüin wayuu müleka nnojorule mojulaain. Je talata ne'e jia sümaa tü ji'yataainjutkat —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Je na wayuukana napüshua sütüma tü nüküjakat Juan namüin, “Niataakaja Cristo, chi wa'atapakai süka süpüshua waa'in”, müsü naa'in. ");
INSERT INTO guc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nüküjakalaka joo Juan namüin na wayuukana napüshua: “Tayakai, wayuu ne'e. Nnojoishi wanaapünaain nümaa Cristo, süka pülashin ma'i nia toulia. Tawoutisaajüin ne'e jia süka wüin. Otta müshia Cristo, anteechi jünainmüin süpüla naapüinjachin jümüin chi Naa'inkai Maleiwa süpüla eeinjachin nia waneepia jümaa. Akaajasa chi eekai ayatüin sünain naainjala, süsaleechi nia nütüma. ");
INSERT INTO guc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O'tte'enneechi chi eekai nünoujain nünain Cristo, maa aka sükatannüin süchon wane a'ttiee suulia tü suwasalakat süpüla sünaajaanüin. Otta chi eekai niyouktüin Cristo, amülouleechi waneepia, maa aka tü suwasalakat sünain sa'ajünüin”, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ayatshi Juan aküjain nüchiki chi O'tte'erüikai namüin, sümaa nime'ejüin naa'in süka pütchi wainma. ");
INSERT INTO guc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Je süchikijee tia, naashichijaakalaka Herodes chi sülaülashikai mma nümüin Juan sünainjee nüchiaain nia saalin naapaain tü nu'wayuusekat chi nimüliakai süpüla nu'wayuusein, tü Herodíaskat anülia, otta saaliijee wainma kasa mojusü naa'inrakat. Nüpüreesajitkalaka Juan. ");
INSERT INTO guc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Je chaa eejatüle suwoutisaajünüin tü wayuukolüirua nütüma Juan, owoutisaajünüshi Jesús nütümaya. Je wanaa sümaa naashajaain Jesús nümaa Maleiwa, ajutalaasü chaa iipünaa eere Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nüshakatakalaka joo chi Naa'inkai Maleiwa nünainmüin Jesús, sünain müin aka saa'in wane mo'uwa. Saapünakalaka joo wane pütchi chaa iipünaajee sünain maa: —Anii chi Tachonkai aishikai tapüla. Talatüshi ma'i taya nümaa. ");
INSERT INTO guc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Je kettaapa maa aka apünüin shikii juya nuuyase Jesús, o'ttüshi nia sünain ekirajaa wayuu. Otta Jesús, saashin wayuu süpüshua, nüchon José. Anuu nanülia na koo'uliwo'ukana José nüchon Elí: ");
INSERT INTO guc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí, nüchon Matat. Matat, nüchon Leví. Leví, nüchon Melqui. Melqui, nüchon Jana. Jana, nüchon José. ");
INSERT INTO guc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, nüchon Matatías. Matatías, nüchon Amós. Amós, nüchon Nahum. Nahum, nüchon Esli. Esli, nüchon Nagai. ");
INSERT INTO guc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, nüchon Maat. Maat, nüchon Matatías. Matatías, nüchon Semei. Semei, nüchon José. José, nüchon Judá. ");
INSERT INTO guc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá, nüchon Joana. Joana, nüchon Resa. Resa, nüchon Zorobabel. Zorobabel, nüchon Salatiel. Salatiel, nüchon Neri. ");
INSERT INTO guc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, nüchon Melqui. Melqui, nüchon Adi. Adi, nüchon Cosam. Cosam, nüchon Elmodam. Elmodam, nüchon Er. ");
INSERT INTO guc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, nüchon Josué. Josué, nüchon Eliezer. Eliezer, nüchon Jorim. Jorim, nüchon Matat. Matat, nüchon Leví. ");
INSERT INTO guc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví, nüchon Simeón. Simeón, nüchon Judá. Judá, nüchon José. José, nüchon Jonán. Jonán, nüchon Eliaquim. ");
INSERT INTO guc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim, nüchon Melea. Melea, nüchon Mainán. Mainán, nüchon Matata. Matata, nüchon Natán. Natán, nüchon David. ");
INSERT INTO guc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David, nüchon Isaí. Isaí, nüchon Obed. Obed, nüchon Booz. Booz, nüchon Salmón. Salmón, nüchon Naasón. ");
INSERT INTO guc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón, nüchon Aminadab. Aminadab, nüchon Aram. Aram, nüchon Esrom. Esrom, nüchon Fares. Fares, nüchon Judá. ");
INSERT INTO guc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, nüchon Jacob. Jacob, nüchon Isaac. Isaac, nüchon Abraham. Abraham, nüchon Taré. Taré, nüchon Nacor. ");
INSERT INTO guc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor, nüchon Serug. Serug, nüchon Ragau. Ragau, nüchon Peleg. Peleg, nüchon Heber. Heber, nüchon Sala. ");
INSERT INTO guc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala, nüchon Cainán. Cainán, nüchon Arfaxad. Arfaxad, nüchon Sem. Sem, nüchon Noé. Noé, nüchon Lamec. ");
INSERT INTO guc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec, nüchon Matusalén. Matusalén, nüchon Enoc. Enoc, nüchon Jared. Jared, nüchon Mahalaleel. Mahalaleel, nüchon Cainán. ");
INSERT INTO guc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán, nüchon Enós. Enós, nüchon Set. Set, nüchon Adán. Otta Adán, nükumala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ale'ejüshi Jesús chejee eejee tü süchikat Jordán, sünain eein chi Naa'inkai Maleiwa nümaa. O'uninnüshi nia nütüma isashiipa'amüin ");
INSERT INTO guc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","süpüla chainjachin nia cha'aya maa aka pienchi shikii ka'i sünain meküin. Je keraapa tü ka'ikat nütüma cha'aya sünain ouktüin nia jamü, antüshi Satanás chi sülaülakai yolujaa nünainmüin süpüla nuu'ulaküin naa'in. ");
INSERT INTO guc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—Müleka Nüchonle pia Maleiwa, puluwataa türa ipakat shii'iranajaaiwa pan —nümakalaka chi Yolujaakai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Asouktüshi Jesús ni'ipajee: —Nnojo. Ashajünüsü paala wane pütchi sulu'u tü karaloukta nüchikimaajatkat Maleiwa, müsü yaa: “Nnojotsü shiain sümüiwa tü pankat katüin atüma so'u wayuu, kateerü o'u shiaya sütüma süpüshua tü nümakat chi Maleiwakai” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nu'uninnakalaka joo Jesús nütüma chi Yolujaakai chamüin iipünaamüin saa'upünaa wane uuchi, sünain nii'iyatüin nümüin tü suumainkalüirua wayuu süpüshua'ale wwatuo'ushi, sünain nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","—Tü mmakat süpüshua, aapünüsü tamüin süpüla tasülajüinjatüin shia nümüin chi wayuu eekai tacheküin süpüleerua. Je joolu'u, müleka püsapainyo'ukale pia yaa tamülatu'u sünain pu'waajüin taya, taapeerü pümüin süpüla puluwataainjatüin tü wayuukolüirua sulu'ukat je süpüla kojutüinjachin pia sütüma —nümakalaka chi Yolujaakai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Asouktüshi Jesús ni'ipajee: —Nnojo. Ashajünüsü paala: “Nia ju'waajüinjachika, chi Jümaleiwasekai nümüiwa, nia ji'yataainjachika amüin nümüiwa” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nu'uninnakalaka joo Jesús nütüma chi Yolujaakai chamüin Jerusalénmüin eemüin tü a'waajüleekat Maleiwa, sünain nüsha'wale'erüin nia iipünaa süralo'u tü miichikat, sünain nümüin nümüin: —Müleka Nüchonle pia Maleiwa, pumutta pümata yaajee mmolu'umüin. ");
INSERT INTO guc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Aneechi pia saashin tü ashajuushikat, makat mayaa: “Nuluwataajeena Maleiwa na aapieekana süpüla naa'inmajüin pia. Najapulu'uinjachi pia suulia sheewa'alaain puu'ui sütüma ipa”, mataa sümakai tü ashajuushikat —nümakalaka chi Yolujaakai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Asouktüshi Jesús: —Nnojo. Müsü tü ashajuushikat: “Nnojo juu'ulaküin naa'in chi Jümaleiwasekai” —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shiasa kettaapa chi Yolujaakai sünain nuu'ulaküin naa'in Jesús, o'unüshi nia nüma'anajee süpüla nüle'ejüinjachin nüchikua so'uweena wane ka'i nüchekakat o'u. ");
INSERT INTO guc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ale'ejüshi joo Jesús Galileamüin, sünain pülashin ma'i nia nütüma chi Naa'inkai Maleiwa. Je aküjünüsü nüchiki sütüma tü wayuukolüirua sainküin mma sünain nüle'ejüichipain nüchikua. ");
INSERT INTO guc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O'ttüshi Jesús sünain ekirajaa wayuu sulu'upünaa tü ekirajüleekalüirua na judíokana. Otta na aapakana nünüiki, na'waajüin nia. ");
INSERT INTO guc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nüntakalaka joo Jesús sulu'umüin tü pueulokat Nazaret eejachire kepiain paala nia jima'aliiwa'aya. Je so'u tü ka'i neemeraakat o'u na judíokana, ekerotshi nia sulu'umüin tü ekirajüleekat, maa akaapü'ü nütüma sainküin mma. Nüsha'walaakalaka süpüla naashaje'erüinjatüin tü karaloukta nüchikimaajatkat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Saapünakalaka joo tü karalouktakat nümüin, tü nüshajalakat Isaías chi nünüikimaajachikai Maleiwa paala sümaiwa. Nuwastakalaka joo shia saa'u tü pütchi makat mayaa: ");
INSERT INTO guc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Antüshi chi Naa'inkai Maleiwa taa'u, süka taneekünüin nütüma süpüla taküjainjatüin süchiki anaa sümüin wayuu eekai müliain. Nuluwataain taya süpüla taküjainjatüin sümüin wayuu süpüshua süchiki tü juya o'tte'ennüinjanakat o'u naya nütüma Maleiwa. Nücheküin süpüleerua taapirüin na püreesashiikana sünain taashiinapain naya, na mo'usaliikana sünain ko'uinapain naya, je na se'ejenashiikana naainjala sünain suu'ule'ennüitpain noulia”. ");
INSERT INTO guc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Shiasa kettaapa tü naashaje'erakat Jesús, nüko'olaa nümüsia tü karalouktakat süchikua sünain naapüin nümüin chi aa'inmajüikai. Je wanaa sümaa nüikkalaain Jesús süpüla ekirajaa, eesü naa'in na wayuukana napüshua süpüla tü nüküjainjatkat namüin, ");
INSERT INTO guc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","22","süka natüjaain saa'u sünain kamalain ma'i nünüiki Jesús sümüin wayuu sainküin mma je keme'eriain shia namüin. Otta ne'raajüin nia sümaa niain kachoin José. Nümakalaka joo Jesús namüin: —Je so'u ka'ikat tüü, ekeraajüsü ju'upala tü ashajuushikat taashaje'erüitpakat jümüin, süka tayain saashajaain achiki. ");
INSERT INTO guc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aashajaashi joolu'u Jesús namüin nüchikua sünain nüchiajaain naya: —Meena jia tamüin sünain jiyouktüin tanüiki: “Müleka ayuuire wane tottoolu, eiyajaashi nümüiwa süpüla nütüjaanajachin aa'u sünain tottoolüin nia. Akaweechia pia, müleka paa'inrüle wo'upala ya'ayaa puumainpa'a tü kasa anasü paa'inrakat cha'aya Capernaum, wanoujeerü tü pümakat wamüin”, meenain jia tamüin. ");
INSERT INTO guc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Shiimüin ma'i tü tamakat jümüin: Müinka nüntüle wane nünüikimaajachi Maleiwa sa'akamüin nüpüshi, mojuteechi nia sütüma, maa aka tayakai sünain mojutüitpain jütüma joolu'u —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Nüso'irüin naa'in na wayuukana sünain nüchiki Maleiwa sünain nuu'ulaain suulia nükaaliijain na wayuu judíokana saaliijee noo'ulaain suulia oonowaa sümaa nünüiki. Müshi nia namüin: —Soto jaa'in nüchiki Elías, chi nünüikimaajachikai Maleiwa sümaiwa, wanaa sümaa alin jamü sümüin wayuu süpüshua sütümajee nnojolüin sü'itüin juya apünüin juya shiatapünaamüin. Ajütünüshi Elías nütüma Maleiwa sulu'umüin tü mmakat Sidón eemüin wane wayuu oukta a'wayuuset cha'aya sulu'u tü pueulokat Sarepta süpüla nükaaliijainjatüin shia. Nnojoishi aluwataanüin nia namüin na eekai ouktüin na'wayuuse sulu'u tü mmakat Israel. ");
INSERT INTO guc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Je soto jaa'in nüchiki Eliseo chi nünüikimaajachikai Maleiwa sümaiwa, wanaa sümaa ayuulin wainma na wayuukana sulu'u tü mmakat Israel sütüma aja'ttaa ata. Ajütünüshi Eliseo nütüma Maleiwa nünainmüin wane wayuu Siriaje'ewai kanüliashi Naamán. Nnojoishi aluwataanüin namüin na ayuuishiikana sulu'u Israel. ");
INSERT INTO guc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Otta na wayuukana yaa sulu'u tü ekirajüleekat, üttajaasü ma'i naa'in sütüma tü nümakat Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Natamaajaakalaka sünain najütüin Jesús sulu'ujee tü pueulokot solumüin wane namüna, süpüla na'ttüinjachin nüchiki mmolu'umüin. ");
INSERT INTO guc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Otta müshia Jesús, nülatakalaka pasanainpünaa nanain na wayuukana sünain nu'unüin nama'anajee. ");
INSERT INTO guc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","O'unüshi joo Jesús Nazaretjee chamüin sulu'umüin tü pueulokat Capernaum cha'aya sulu'u tü mmakat Galilea. Je so'u tü ka'i neemeraakat o'u na judíokana, o'ttüshi nia sünain ekirajaa tü wayuukolüirua cha'aya. ");
INSERT INTO guc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Süka aluwataaushin nia nütüma Maleiwa süpüla ekirajaa, ponusü ma'i naa'in na wayuukana tü nüküjakat namüin. ");
INSERT INTO guc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eetaalakalaka wane wayuu sulu'u tü ekirajüleekat, kale'eru'ushi yolujaa. Su'waatakalaka joo tü yolujaakalüirua nüle'eru'ukat chi wayuukai sünain emetuluin sünüiki nümüin Jesús: ");
INSERT INTO guc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Alu'uleekaija'a taya pütüma Jesús, piakai chi Nazaretje'ewaikai. Tatüjaa aa'uchi pia sünain piain aneekuushin nütüma Maleiwa. ¿Jamüinjatü wakuaippa pütüma? ¿Püjütajanataaka waya yaajee? —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nüchiajaakalaka joolu'u Jesús tü yolujaakat: —Ko'uta pia. Pujuitta yalajee nuulia chi wayuukai —nümakalaka sümüin. Sujuittakalaka joo tü yolujaakat nuulia chi wayuukai sünain sujutüin nia mmolu'u pasanainmüin sünain tü wayuukolüirua, sümaa nnojolin neewaain nia sütüma. ");
INSERT INTO guc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Otta na wayuukana napüshua, ponusü ma'i naa'in tü ne'rakat sünain naashajaajiraain: —¿Kasashikai wayuu chi Jesúskai? Laülaashi nia suulia tü yolujaakalüirua je kojutüsü nünüiki sütüma wanaa sümaa nujuittirüin shia süle'eru'ujee wayuu —namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Shiasa süchikijee tia, yootüsü nüchiki Jesús sainküin tü pueulokalüirua sü'ütpünaa Capernaum. ");
INSERT INTO guc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","O'unüshi joo Jesús sulu'ujee tü ekirajüleekat eemüin nipia Simón, eejatkalaka tü nimeshikat Simón sünain ayuulin sütüma aapuwaa. Mayeinsü ma'i. Je achuntünüsü nümüin Jesús natüma na wayuukana niiyajüinjatüin shia namüin. ");
INSERT INTO guc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nürütkaakalaka joo sünainmüin tü ayuuisükat. Naawale'erakalaka tü ayuuliikat suulia süka nünüiki. Saamatüitpa joo tü sütakat. Je süka anaitpain shia, atamaamaatüsü sünain shikirüin na shi'iyoukana. ");
INSERT INTO guc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Je motsopa ka'i, alü'üjünüsü wainma wayuu eekai ayuulin nünainmüin Jesús, sümaa ayuulii eekai eein ne'e. Otta Jesús, ni'itaain najapü naa'u wane'ewaire nakua. Anakalaka napüshua. ");
INSERT INTO guc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Je ojuittinnüsü yolujaa süle'eru'ujee wayuu wainma nütüma sünain su'waatüin ma'i: —Pia chi Nüchonkai Maleiwa. Otta Jesús, nüchiajaain tü yolujaakalüirua suulia saashajaain nüchiki, süka sütüjaain naa'u sünain niain Cristo chi Nüneekajalakai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Je mapa ja'yuumüin, o'unüshi Jesús sulu'ujee tü pueulokat chaa eere yüütüülin. Otta tü wayuukolüirua, nachajaa achikichi nia. Je shiasa nantapa nünain, neme'ejüin naa'in shii'iree makateein nia namaa. ");
INSERT INTO guc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Asouktüshi Jesús: —Acheküshi taküjüinjachin tü pütchi anasükat sulu'upünaa tü pueulokat süpüshua, süchiki nukuaippa Maleiwa sünain aluwatawaa, süka shiain ajütünüin apüla taya —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Shiasa süchikijee tia, ayatshi Jesús sünain aküjaa nüchiki Maleiwa sulu'upünaa tü ekirajüleekalüirua cha'aya Galilea. ");
INSERT INTO guc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Je so'u wane ka'i, eeshi Jesús sha'watüin sotpa'a tü palaakat Genesaret sümaa wayuu wainma yentaawain shii'iree saapeein nünüiki Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ni'rüin piamasü anua malu'usot sotpa'a tü wüinkat, tü apütünakat yala natüma na olojüshiikana jime sünain ashijawaa nakusüin. ");
INSERT INTO guc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O'otooshi joo Jesús sulu'u waneesia tü anuakat, tü na'anuainkat Simón Pedro. “Anashi pujutule süchiki tü pe'ejenakat tamaa yala pejechon shirokumüin tü palaakat”, müshi nia nümüin. Ojoyolooshi joo Jesús sünain nikirajüin tü wayuukalüirua yaakat sotpa'a tü palaakat sünain yaain nia sulu'u tü anuakat. ");
INSERT INTO guc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Shiasa keraapa Jesús süchikijee nikirajüin na wayuukana, naashajaakalaka nümaa Simón: —Anashii müleka wo'unule cha'aya eere o'ttüin tü palaakat süpüla jujutüinjatüin tü jukusüinkat chamüin süpüla olojoo jime —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nüsouktakalaka Simón: —Ekirajüikalee, olojüshii waya waneepia sa'waipa. Masitsalii waya sünain jime. Otta saa'u piaichipain müin tamüin, wajuteerü tü wakusüinkat süchikua —nümakalaka Simón. ");
INSERT INTO guc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Shiasa najutakalaka tü nakusüinkat shirokumüin tü palaakat, kasitkalaka naya jime watta saalin. Je süka pejechoin süpüla süchatajaain tü nakusüinkat süpüleerua tü jimekat, ");
INSERT INTO guc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","neenakajaakalaka na wane natünajutkana sulu'ukana tü wane anuakat süpüla nakaaliijainjanain naya. Je süntapa tü anuakat sümaa nepirajüin shia jime, emeroteematüsü joo tü anua piamasükalüirua shirokumüin tü palaakat sütüma saawain tü jimekat. ");
INSERT INTO guc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Otta müshia Simón Pedro, ni'rapa tü jimekat, nu'wachiraakalaka nümülatu'umüin Jesús sünain nümüin nümüin: —Senyotkalee, wayuu kaainjarai taya. Anashi püpütüle taya tamüiwa —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Müshi tüü, süka ponüin ma'i naa'in tü nasitkat sünain wattain saalii, aka'aya naa'in na eejanakana nümaa sulu'u tü ne'ejenakat, ");
INSERT INTO guc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","aka'aya naa'in Jacobo oo'ulaka Juan, na nüchooinkana Zebedeo, na nütünajutkana Simón sulujunakana tü wane anuakat. Nümakalaka joolu'u Jesús nümüin Simón: —Nnojo mmolüin pia teema saa'u kaainjaralin pia. Maa aka olojülin pia jime, okotchajeechi joo pia wayuu tamüin süpüla saapajüinjatüin tanüiki. ");
INSERT INTO guc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Shiasa süchikijee nantirüin tü piamasükat ne'ejena sotpa'amüin tü palaakat, napütüin süpüshua tü nakorolokot süpüla o'unaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Je so'u wane ka'i, antüshi Jesús sulu'umüin wane pueulo eere wane wayuu mayeinshi sütüma aja'ttaa ata. Je ni'rapa Jesús, arütkaashi nia nünainmüin sünain palastaleein nia yaa nümülatu'u sünain nüchuntüin nümüin: —Senyotkalee, müinka pücheküle, piiyaja taya —nümakalaka chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Niyurulakalaka joo nütüna Jesús nünainmüin chi ayuuishikai sünain naapaain nia: —Tacheküin süpüleerua anainjachin pia —nümakalaka nümüin. Anaichipa joo chi wayuukai. Nnojolüitpa aja'ttüin tü nütakat. ");
INSERT INTO guc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aashajaashi joo Jesús nümüin chi wayuukai nüchikua: —Otta müshia joolu'u, nnojo püküjain sümüin wayuu püchiki sünain teiyajüin pia. Pu'una palajana eemüin chi sacerdotekai süpüla pii'iyatüinjatüin nümüin tü pütakat süpüla naapüinjatüin nümüin Maleiwa tü mürüt ouktajatkat saa'u anaichipain pia, maa aka tü nuluwataakat anain Moisés paala sümaiwa. Je sükajee tia, sütüjaajeechi aa'u pia wayuu sünain anaichipain pia süpüla sa'akainjachin pia püchikua —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A'walakajaasü ma'i nüchiki Jesús sainküin mmakat, mayaasüje ko'utüin chi wayuukai. Ayatsü antapaatüin wayuu wainma nünainmüin shii'iree aapajaa tü nikirajakat anain je shii'iree shiiyajünüin nütüma. ");
INSERT INTO guc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Otta Jesús, o'unawaishi nümüiwa sa'akajee tü wayuukolüirua chaa eere yüütüüin süpüla aashajawaa nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Je so'u wane ka'i, wanaa sümaa nikirajüin Jesús tü wayuukolüirua, eeshii wane wayuuirua fariseo oo'ulaka na karalouktamaajanakana joyojoyolüin sa'aka tü wayuukolüirua. Antüshii naya sünain e'rajaa naa'u Jesús sulu'ujee tü pueulokalüirua sulu'u tü mmakat Galilea je Judea oo'ulaka chajee Jerusalénjee. Otta müshia Jesús, pülaichipa nia nütüma Maleiwa süpüla eiyajaa wayuu. ");
INSERT INTO guc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nantakalaka wane wayuuirua sünain nalü'üjiraain wane wayuu ayuuishi süka süi shii'iree ne'itaain nia nümülatu'umüin Jesús shii'iree niiyajeein nia. Oukta asa'achi, oukta atünachi. Otta sünain nekerotirüin nia so'ulu'upünaa tü miichikat, ");
INSERT INTO guc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","isasü nachiki süka wainmain tü wayuukolüirua so'ulu'u. Naliikajaakalaka nümaa chi wayuukai chaa süralo'umüin tü miichikat, süpüla naakatüinjatüin süralo'ujee süpüla nashakatirüinjachin nia pasanainpünaa sünain tü wayuukolüirua nümülatu'umüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nütüjaapa Jesús saa'u nanoula na wayuukana, aashajaashi nia nümüin chi ayuuishikai: —Tawalachee, talatirüitpa paainjala puulia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Otta na fariseokana oo'ulaka na karalouktamaajanakana, müsü naa'in: “¿Jaraikai wayuu chi e'rüiyaaka aa'in wayumüin süpüleerua nünüiki nümüin Maleiwa? Nnojoishi jerain Maleiwa sünain niain ainküin nümüiwa alatiraa saainjala wayuu”. ");
INSERT INTO guc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Otta müshia Jesús, süka niyaawatüin saa'u tü sulu'ukat naa'in, asouktüshi nia namüin: —¿Jamüshii jia mojuka'a jünüiki tamüin sulu'u jaa'in? ");
INSERT INTO guc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Je wanaa sümaa tamüin nümüin, “Talatirüitpa paainjala puulia”, nnojoishi jütüjaain aa'u tayakai, chi Shipayakai Wayuu, sünain laülaain süpüla alatiraa saainjala wayuu. Otta müsia joolu'u, jütüjaweechi aa'u taya sünain laülaain süka tameechin nümüin, “Püsha'walaa waraittaiwa pia”. Aashajaashi joo Jesús nümüin chi oukta asa'achikai: —Püsha'walaa, pülü'üjaa pu'ula, pu'una pipialu'umüin —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Asha'walaamaatüshi joo chi wayuukai su'upala tü wayuukolüirua süpüshua. Naapaain tü nu'ulakat palastakat aa'u paala nia sünain nu'unüin nipialu'umüin sünain nu'waajüin chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ponokalaka ma'i saa'in tü wayuukolüirua tü shi'rakat sünain maa: —Anashaataleesia ma'i tü kasa we'rakat so'uka'i tüü, tü nnojotkat we'rapü'üin paalainka —namakalaka sünain na'waajüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Shiasa mapa süchikijee tia, sünain nu'unüin Jesús yalajee, eeshi nüpüla wane wayuu joyotüin eere ni'yataale kanüliashi Leví. Okotchajüi neerü nümüin chi sülaülashikai mma. —Anashi tamaatalai pia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nüsha'walaakalaka joo Leví sünain nüpütüin ni'yataain süpüshua süpüla o'unaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Shiasa süchikijee tia, neenakakalaka Leví wainma wayuu nipialu'umüin sünainmüin wane ekawaa nütüma nüpüla Jesús. Je na'aka na wainma wayuu eküshiikana, eeshii wainma na okotchajüliikana neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Otta na wayuukana fariseokana je na karalouktamaajanakana eekai fariseoin, ejejeraashii naya nojuuna na nikirajüinkana Jesús sünain mojuin nanüiki namüin: —¿Jamüshii cheje eera nekaaka'a namaa na eekana kaainjaraliin, maa aka na okotchajüliikana neerü nümüin chi sülaülashikai mma? —namakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nüsouktakalaka joo Jesús ne'ipajee: —Wane wayuu eekai nnojolüin ayuulin, nnojotsü che'ojaain tottoolu sümüin. Shia che'ojaaka amüin eekai ayuulin. ");
INSERT INTO guc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Otta müshia tayakai, antüshi taya sa'akamüin wayuu süpüla achajawaa süchiki eekai kaainjaralüin shii'iree sükatalaain suulia saainjala. Nnojoishi taya antüshin süpüla achajawaa süchiki eekai maainjalain saa'in namüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naashajaakalaka joo na fariseokana oo'ulaka na karalouktamaajanakana nachikua nümüin Jesús: —Na nikirajüinkana Juan, aamüjapü'üshii naya wanaa sümaa nachuntüin nümüin Maleiwa, maa'aya aka na wekirajüinkana wayakana fariseokana. ¿Jamaka'a joo na pikirajüinkana nnojoliika'a naamüjüin? Ayatshii naya sünain ekaa —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Nüsouktakalaka Jesús ne'ipajee sünain nikirajüin naya süka sukuaippa tü kasa e'nnakat sainküin mma sünain nümüin namüin: —Tü wayuu antakat sünain shikiira wane ka'wayuusee, anasü talatüle saa'in sümaa nnojolüin mojuin saa'in wanaa sümaa eein chi ka'wayuuseshikai namaa. Je joolu'u, süka eein taya namaa na tekirajüinkana, anasü talatüle naa'in. Alu'ujasa mapa takatalaapa noulia, eeshii süpüla naamüjüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nümakalaka namüin: —Nnojotsü anain müleka shi'yotoonüle wane shi'ipa kuluulu eekai jeketüin süpüla ekeittiajünaa süka wane ashe'in eekai laülaain. Amojujaajeerü süpüshua wanaa sümaa süshijaanüin süka süsüküijaweerüin. Akaajaa jiakana, nnojotsü anain masütaajule jia sünain tü jünoujakat paala wanaa sümaa jünoujain tü pütchi jeket tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Maa'aya aka wane wiino. Müleka süla'annüle wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai laülaain, eesü süpüla süchatajaain tü paa'atakat sütüma jashü'üpa. Amülouleerü tü wiinokot oo'ulaka tü paa'atakat. ");
INSERT INTO guc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Shi'itaaneekalaka wane wiino eekai saashü'üjünajatüin sulu'u wane paa'ata eekai jeketüin. ");
INSERT INTO guc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chi eekai nüsülüin wane asüüshi eekai jashü'üin, nnojotsü naa'in sünain eekai nnojolüin jashü'üin, süka ki'rain nümüin asaa tü jashü'üsükat. Akaajaa jiakana fariseokana, ki'rairü jaa'in sünain tü ekirajünakat anain jia natüma na jutuushikana otta jiyouktüin tü tekirajakat anain —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","So'u tü ka'i neemeraakat o'u na judíokana, awaralijaashi Jesús namaa na nikirajüinkana sulu'u wane wopu pasanainpünaa sünain wane yüüja. Je na nikirajüinkana, nasürüttapünaain wane a'ttiee kanüliakat “trigo” sünain nashalejüin shia. ");
INSERT INTO guc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Otta na fariseokana, süka müin aka saa'in wane a'yatawaa tü naa'inrakat na nikirajüinkana Jesús naashin, namakalaka namüin: —Saashin tü nüshajakat Moisés, nnojotsü anain süpüla jaa'inrüin tia so'u tü ka'i weemeraakat o'u —namajaakalaka namüin na nikirajüinkana Jesús. ");
INSERT INTO guc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Asouktüshi Jesús joolu'u namüin saa'u nnojolüin kaainjalaain tü naa'inrakat na nikirajüinkana naajüin: —Soto jaa'in tü naa'inrakat David paala sümaiwa wanaa sümaa alin jamü nümüin je namüin na nütünajutkana. ");
INSERT INTO guc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ekerotshi nia sulu'umüin tü a'waajüleekat Maleiwa wanaa sümaa shi'itaanüin tü pan aapünajatkat nümüin Maleiwa. Tü pankat naashin Moisés, nnojotsü shika'ain sümüinjatüin wayuu eekai eein ne'e. Naya eküinjanaka namüiwa, na sacerdote judíokana. Otta David, naapaain tü pankat sümaa niküin, je naapüin süpüshi namüin na nütünajutumuyuukana. Je nnojoliishii süsalain naya tü naa'inrakat nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tayakai, chi Shipayakai Wayuu, taya laülaashika saa'u tü ka'i sheemeraakat o'u wayuu. Je sükajee tia, nnojoliishii kaainjalain na tekirajüinkana saaliijee tü naa'inrakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Je so'u wane'eya sükalia eemerawaa, ekerotshi Jesús süpüla ekirajaa sulu'umüin tü ekirajüleekat tü judíokalüirua. Eejachikalaka nüpüla wane wayuu joso ajapüchi, tü najapü nikiakat. ");
INSERT INTO guc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Je na fariseokana namaa na karalouktamaajanakana, süka naapeein nikii Jesús, eekalaka ma'i naa'in nüpüla müleka niiyajüle so'u tü ka'i eemeraanakat o'u, shii'iree “Kaainjarai nia süka ni'yataain so'u tü ka'i eemeraanakat o'u sünain niiyajüin wane wayuu” namüinjanain sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Otta Jesús, süka nütüjaain saa'u tü jülüjakat naa'in, —Püsha'walaa yala pasanainmüin sünain tü wayuukolüirua —nümakalaka nümüin chi wayuu joso ajapüchikai. Nüsha'walaakalaka joo chi wayuukai yala yalaala. ");
INSERT INTO guc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nümakalaka joo Jesús namüin na wayuukana sünain nüchiajaain naya: —Saajüin tü nüshajakat Moisés, ¿kasa anaka süpüla waa'inrüinjatüin so'u tü ka'i eemeraanakat o'u? ¿Anasü müleka waa'inrüle tü kasa eekai anain? ¿Shiataapa eekai mojuin? ¿Anasü müleka waa'inmajüle wayuu suulia ouktaa? ¿Shiataapa anain wo'utüle saa'in? ");
INSERT INTO guc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Niirakaakalaka Jesús namüin na wayuukanairua napüshua sünain nümüin nümüin chi ayuuishikai: —Puwasta tü pajapükat. Je sünain naa'inrüin tü aluwataanakat anain nia, anale'eitpa tü najapükat. ");
INSERT INTO guc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Otta na fariseokana je na karalouktamaajanakana, aashichijaashii ma'i naya nümüin Jesús sütüma tia. “¿Kasa waa'inrüinjatka nüka?”, müshii naya sünain aashajaajirawaa. ");
INSERT INTO guc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","O'unüshi Jesús so'u wane ka'i saa'umüin wane namüna süpüla aashajawaa nümaa Maleiwa. Eeshi nia sünain nüsira'irüin aikat tia sünain achuntaa nümüin. ");
INSERT INTO guc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Shiasa ja'yuupa, neenaküin na nikirajüinkana nünainmüin süpüla nüneeküinjanain poloo piammüin na'akajee. Ni'itaakalaka joo nanülia “Aluwataaushi” münüin, süka nuluwataainjanain naya sünain aküjaa nünüiki sümüin wayuu. Anuu nanülia na Aluwataaushikana: ");
INSERT INTO guc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón, chi e'itaanakai anülia Pedroin nütüma Jesús. Andrés, chi nimüliakai Simón. Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO guc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, je Tomás. Jacobo chi nüchonkai Alfeo. Simón, wane no'utku na wayuukana kanüliakana Zelote. ");
INSERT INTO guc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas nüchonkai Jacobo. Je Judas Iscariote chi aapüinjachikai nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Süchikijee tia, ashakatüshi Jesús saa'ujee tü namünakat namaa na polooshiikana piammüin eemüin wane anoui eere wainmain na nikirajüinkana otta wayuu watta saalin sulu'ujee süpüshua tü mmakat Judea, oo'ulaka Jerusalén, oo'ulaka sotpa'ajee palaa sulu'ujee tü pueulokat Tiro oo'ulaka Sidón. ");
INSERT INTO guc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Antüsü tü wayuukolüirua nünainmüin Jesús shii'iree saapajeein nünüiki je shii'iree shiiyajünüin tü ayuuliikat suulia nütüma. Na wayuu eekana müliain sütüma kale'eru'uwaa yolujaa, eiyajünüshii naya nütüma. ");
INSERT INTO guc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Arütkaashii na wayuukana napüshua nünainmüin Jesús shii'iree nepetteein nia süpüla anainjanain naya nütüma, süka natüjaain naa'u sünain pülashin nia je sünain niiyajüin wayuu wainma. ");
INSERT INTO guc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eirakaashi joo Jesús namüin na nikirajüinkana sünain nikirajüin naya no'upala na wayuukana napüshua: “Anata'aleeshiija'a ma'i jia müliakana joolu'u, süka jikeroteenain chamüin eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anata'aleeshiija'a ma'i jia aikana amüin joolu'u jamü, süka emireenain jia so'u ka'ikat tia, je jiakana a'yalajakana joolu'u, süka jüsirajeenain so'u tia. ");
INSERT INTO guc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anata'aleeshiija'a ma'i jia shi'rakana amüin wayuu joolu'u saaliijee anoujaa tanain tayakai, chi Shipayakai Wayuu, mayaasüje kanain jia saa'in wayuu, mayaasüje süjünajaain jia wayuu sünain mojuin sünüiki jümüin, otta müleka shiyouktüle jia saa'u mojulaain jia saajüin. ");
INSERT INTO guc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Meerü jukuaippa aka nakuaippa na nünüikimaajanakana Maleiwa paala sümaiwa sünain ne'nnüin amüin natüma na jutuushikanairua. Otta jiakana so'u tü ka'i mülieenakat o'u jia sütüma wayuu, talata jia süka süpüshua jaa'in, süka jütüjaain naa'u chi Maleiwakai sünain nüsülajüinjatüin kasa anashaatakat jümüin chaa iipünaa eere nia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aashajaashi joo Jesús namüin na wayuukana napüshua: “Na wayuu eekana washirüin ja'aka, ‘Aisha'ajaa’, meena naya, süka kasalajaneerüin namüin tü mojusü naa'inrakat. Mayaasüje talatüin naa'in joolu'u sümaa washirüü ne'e, mojeerü naa'in so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Je na wayuukana eekana emirain ja'aka maa'ulu yaa, mojeerü ma'i naa'in, süka aijeerüin jamü namüin. Otta na asirajakana, ‘Aisha'ajaa’, meena naya, süka na'yalajeenain saalii mojuu aa'in. ");
INSERT INTO guc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Je jia kojutkana sütüma wayuu süpüshua, jalia jia talataja aa'in sütüma tia. Anakaja sotüle jaa'in nachiki na nünüikimaajanayaakana Maleiwa sümaiwa paala kojutkana sütüma tü jutuushikalüirua soo'opünaa naküjain alawaa. Otta no'ulu'u Maleiwa, mojutsalii naya”. ");
INSERT INTO guc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aashajaashi Jesús nüchikua namüin na nikirajüinkana no'upala na wayuukana napüshua: “Jia aapaakana tü tamakat, anashii aire jüpüla na jü'ünüükana, sümaa jükaaliijain naya, mayaashiije kanain jia naa'in. ");
INSERT INTO guc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Je anashii jücheküle tü anasükat napüleerua na mojukana anüiki jümüin, sümaa jüchuntüin nümüin Maleiwa naa'u, mayaashiije e'rüliin wayumüin jümüin. ");
INSERT INTO guc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Müleka süshe'etünüle ju'upünaa sütüma wayuu, anasü müleka nnojorule jüchekajüin shia. Shia anaka alu'u müleka jujununtaale süpüla süshe'etünüin tü wane. Je müleka süsütünüle tü jüshe'inkat, anasü müleka juu'ulaale tü wane'eya süpülaya. ");
INSERT INTO guc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Je nümüin chi eekai che'ojaain kasa nümüin, jüsülaja nümüin. Je nümüin chi asütakai jükorolo juulia, nnojo jüsütüin süchikua nuulia. ");
INSERT INTO guc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Anasü müleka jaa'inrüle tü anasükat sümüin wayuu, maa aka jücheküin saa'inreein tü anasükat jümüin. ");
INSERT INTO guc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Müleka aire ne'e jüpüla tü wayuu aikat apüla jia, ¿kasa anaka alu'u tia nu'upala Maleiwa? Na wayuukana napüshua, mayaashiije kaainjaraliin naya, aisü napüla wayuu aikat apüla naya. ");
INSERT INTO guc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Je müleka jükaaliijale ne'e tü wayuu akaaliijakat jia, ¿kasa anaka alu'u nu'upala Maleiwa tia? Na wayuukana napüshua, mayaashiije kaainjaraliin naya, naa'inrüin tia. ");
INSERT INTO guc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Je müleka jujuyaajirüle ne'e wayuu eekai sütüjain awalaajaa, ¿kasa anaka alu'u nu'upala Maleiwa tia? Shia saa'inraka ne'e wayuu süpüshua, mayaasüje kaainjaralüin. Najuyaajirüin süpüla suwalaajünüinjatüin süchikua. ");
INSERT INTO guc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Alu'usa jiakana, anashii aire jüpüla na jü'ünüükana, maa aka naa'in chi Maleiwa Miyo'ushikai ma'i chakai iipünaa sünain kamaneein sümüin wayuu eekai kaainjalain, eekai nnojolüin saapüin analu'ut nümüin. Je müleka jükaaliijüle na jü'ünüükana sümaa jujuyaajirüin naya sünain nnojoliin jüchekajüin namüin süpüla nawalaajüinjatüin süchikua, nayaawateena aa'u jia sünain nüchooin jia Maleiwa. Je asülajüneena amüin jia wainma kasa anasü nütüma so'u wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Anashii müleka jümüliajüle wayuu süpüshua, maa aka naa'in chi Jüshikai Maleiwakai sünain nümüliajüin shia”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Aashajaashi Jesús nüchikua namüin na nikirajüinkana no'upala na wayuukana: “Anakaja müleka nnojorule jiyoujüin wane wayuu. Müleka jaa'inrüle tia, meeria jukuaippa nütüma Maleiwa. Anakaja müleka nnojorule jaapüin shikii wane wayuu. Müleka jaa'inrüle tia, meeria jukuaippa nütüma Maleiwa. Shia anaka alu'u müleka motüle jaa'in saainjala wayuu eekai kaainjalain juulia, süpüla motüinjatüin naa'in Maleiwa tü jaainjalakat nuulia. ");
INSERT INTO guc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Anashii müleka jüsülajüle sümüin wayuu eekai che'ojaain kasa sümüin. Je tü che'ojaakat jümüin, asülajüneerü nütüma chi Maleiwakai sünain wainmashaateerüin shia. Akaajaa müleka matüjüinre asülajaa jia sümüin wayuu, meeria jukuaippa nütüma Maleiwa. Masülajuujeena amüin jia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ekirajüshi joo Jesús süka sukuaippa tü kasa e'nnakat sainküin mma: “Müleka nu'uninnüle wane wayuu eekai mo'uin nütüma wane eekai mo'uinya, eeshii süpüla nojunuujiraain sulu'u ishi. ");
INSERT INTO guc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wane wayuu, nüshatapa tü ekirajünakat anain nütüma chi ekirajüikai, shieerü nikirajaka anain tü ekirajünakat anain nia paala”, nümakalaka namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","“Jia ayoojaakana waneepia na juwalayuukana, müshii aka jia naa'in wane wayuu eekai ni'rüin yarüttüsü sulu'u no'u chi nuwalakai sünain ‘Tawalaa, anashi tayu'rule tü yarüttüsükat sulu'ujee po'u’ sünain nümüin nümüin. Otta nnojotsü nütüjaain aa'u sünain eein wane sa'ata wunu'u sulu'u tü no'ukalia ma'i. Jiakana piamakana akuaippa, müleka juu'ulaale suulia kaainjalaa, juunteerü jii'iyatüin namüin na juwalayuukana sünain kaainjalain naya”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Aashajaashi Jesús joolu'u nüchikua namüin na nikirajüinkana no'upala na wayuukana: “Wane wunu'u eekai shikaajünüin achoin, nnojotsü kachoin eekai mekaajuuin. Otta wane wunu'u eekai mekaajuuin süchon, nnojotsü kachoin eekai shikaajünüin. ");
INSERT INTO guc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Müleka shi'nnüle süchon wane wunu'u, atüjaaneerü aa'u kasain kachoin. Tü süchonkot tü higuerakat, nnojotsü atpajünüin sünainjee wunu'u eekai keimsein, je tü uuwakat, nnojotsü atpajünüin sünainjee wunu'u eekai eein ne'e. ");
INSERT INTO guc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Akaajaa naa'in wane wayuu eekai nüküjüin waneepia kasa anasü, watüjaa aa'ut sünain shiain sulu'uin naa'in tü anasükat, süka waapüin shia nüküjüin. Akaajasa wane wayuu eekai nüküjüin waneepia tü kasa mojusükot, watüjaa aa'ut sünain shiain sulu'uin naa'in tü mojusükat. Tü saashajaakat wane wayuu, shia tü ojuittakat sulu'ujee saa'in”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aashajaashi Jesús nüchikua namüin sünain nüchiajaain naya: “ ‘Senyotkalee, kojutshi pia watüma’, ¿jamüshii jümaka'aka tamüin sünain nnojolüin jaa'inrüin tü taluwataakat anain jia? ");
INSERT INTO guc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chi wayuu eekai nüntüin tanainmüin, sünain naapajüin tü tekirajakat anain, sünain naa'inrüin waneepia tü taluwataakat anain nia, ¿kasa maka aka nia? ");
INSERT INTO guc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Müshi aka nia naa'in wane wayuu eekai yalayalain süpüla aainjaa miichi. Nüpotüin tü mmakat süpüleerua tü nipiakat süpüla nükumajüinjatüin shia saa'u ipa. Je süntapa wane juya miyo'ushaata sünainmüin tü miichikat, nnojotsü ojuttüin shia, süka ichein ma'i sükumajia. ");
INSERT INTO guc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akaajasa chi wayuu eekai nnojolin naa'inrüin tü taluwataakat anain, müshia aka nia naa'in wane wayuu eekai matüjain süpüleerua aainjaa miichi. Nükumajüin tü miichikat saa'u mma ne'e sünain nnojolin nüpotüin tü mmakat süpüleerua tü nipiakat. Je süntapa wane juya miyo'ushaata sünainmüin tü miichikat, ojuttüsü shia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Je keraapa nünüiki Jesús namüin na nikirajüinkana no'upala na wayuukana napüshua, o'unüshi sulu'umüin tü pueulokat Capernaum. ");
INSERT INTO guc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eeshi wane sülaülashi surulaat nnojoishi judíoin. Je chi nüchepchia kojutkai nütüma, ayuuishi, mayeinshi ma'i. ");
INSERT INTO guc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Niasa'a chi sülaülashikai surulaat, naapüin nüchiki Jesús sünain niain atüjain eiyajaa wayuu. Nuluwataakalaka wane laülaayuushiikana naa'u na judíokana süpüla naashajaainjanain nümaa shii'iree niiyajeein chi nüchepchiakai. ");
INSERT INTO guc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Shiasa nantapa na laülaayuushiikana nünainmüin Jesús, nachuntüin nümüin süka süpüshua naa'in sünain namüin nümüin: —Kojutshi ma'i chi sülaülashikai surulaat watüma. Anakaja müleka piiyajüle chi nüchepchiakai ");
INSERT INTO guc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","süka alin ma'i waya judíokana nüpüla je süka naainjirüin wamüin tü ekirajüleekat —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","O'una müshija Jesús namaa. Otta yaa pejemüin sünain nipia chi sülaülashikai surulaat, nüpanapajakalaka Jesús wane nütünajutüirua chi laülaashikai ajütünakat nünainmüin süpüla naküjainjatüin nünüiki nümüin: “Ekirajüikalee, nnojoishi taya o'unüin pünainmüin, süka nnojolin kasajachin taya pümüin, saa'in tamüin. ¿Jamakuaippalinjachika joo süpüla tantajachin pünainmüin? Süka jamüin, laülaain pia saa'u ayuulii. Müleka püküjale ne'e wane pütchi, tatüjaa aa'ut sünain aneechin chi tachepchiakai sütüma tia ");
INSERT INTO guc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","süka tatüjaain saa'u aluwataanaa maa aka tatüjaain saa'u aluwatawaa. Müleka tajütüle wane surulaat, o'unüshi. Müleka teenaküle nia, antüshi. Müleka taluwataale chi tachepchiakai, naa'inramaatüin motso'o tü taluwataakat anain nia”, müshii naya nümüin Jesús sünain naküjain nünüiki chi sülaülashikai surulaat. ");
INSERT INTO guc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Oponojoosü ma'i naa'in Jesús sütüma tü nümakat chi sülaülashikai surulaat. Ajununtaashi joo sünain nümüin sümüin tü wayuukolüirua wattakat saalin eekat nümaa: —Miyo'utaaleeja'a nünoula chi sülaülashikai surulaat tanain. Nnojoishi eein wane makai aka naa'in sünain anoujaa tanain, ja'itakaja ne'e na'aka na wayuukana Israelkana —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nale'ejaakalaka joo na ajütünakana nipialu'umüin chi sülaülashikai surulaat sünain eein chi nüchepchiakai napüla. Anaichipa joo nia. ");
INSERT INTO guc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Süchikijee tia, o'unüshi Jesús chamüin cha'aya eemüin wane pueulo kanüliasü Naín namaa na nikirajüinkana oo'ulaka watta saalin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Je nüntapa so'ulu'umüin tü pueulokat, eesü nüpüla wane wayuu oukta a'wayuuset sümaa wainma wayuu shipiajannuu. Ouktüichipa joo chi süchonkai waneeshika'iya sümüin. Alü'üjünüshi nia amuuyuupa'amüin. ");
INSERT INTO guc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Shiasa ni'rapa chi Senyotkai tü wayuukot, nümüliajakalaka shia. —Nnojo pi'yalajüin, maachee —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nürütkaakalaka joo Jesús nünainmüin chi ouktüshikai. Je ni'itaapa najapü sünain tü alü'üjiasükat, asha'walaashii joo na wayuukana alü'üjashiikana. —“Püsha'walaa, waa'iraa”, müshi taya müin —nümakalaka nümüin chi ouktüshikai. ");
INSERT INTO guc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Otta müshia chi wayuukai, nojoyolookalaka sünain naashajaain. Otta Jesús, nümakalaka sümüin tü niikat: —Anii chi püchonkai. ");
INSERT INTO guc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ponusü ma'i naa'in na wayuukana tü ne'rakat. Je na'waajüin Maleiwa: —Anashikaiche ma'i chi nünüikimaajachikai Maleiwa antakai wa'akamüin —müshii waneeirua. Otta wane: —Antüichipa Maleiwa süpüla nükaaliijainjanain waya nüpüshikana —müshii. ");
INSERT INTO guc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Je tü naa'inrakat Jesús nüka chi ouktüshikai, a'walakajaasü süchiki sütüma wayuu cha'aya sulu'u tü mmakat Judea je cha'aya sü'ütpünaa. ");
INSERT INTO guc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","So'u wane ka'i, wanaa sümaa püreesain Juan chi owoutisaajüikai, aküjünüsü nümüin natüma na nikirajüinkana süchiki süpüshua tü naa'inrakat Jesús. Neenakakalaka Juan piamashii na nikirajüinkana ");
INSERT INTO guc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sünain nuluwataain naya chamüin nünainmüin chi Senyotkai süpüla namüinjanain nümüin: “¿Shiimü'inya piain chi aluwataaushikai nütüma Maleiwa süpüla pu'tte'erüinjachin wayuu? ¿Nnojottaapa shiimüin?”. ");
INSERT INTO guc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Shiasa nantapa na nikirajüinkana Juan nünainmüin Jesús, müshii naya nümüin: —Aluwataaushi waya pünainmüin nütüma Juan chi owoutisaajüikai süpüla wasakirüinjachin pia: “¿Shiimü'inya piain chi aluwataaushikai nütüma Maleiwa süpüla pu'tte'erüinjachin wayuu? ¿Nnojottaapa shiimüin?” —namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Je so'u ka'ikalüirua tia, eiyajünüsü wayuu watta saalin nütüma, wayuu eekai müliain sütüma ayuulii je eekai kale'eru'uin yolujaa. Je wayuu wainma eekai mo'uin, ko'usü nütüma. ");
INSERT INTO guc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Je sükajee tia, asouktüshi joo Jesús namüin na nüjünalakana Juan: —Aa, shiimüin tayain chi aluwataaushikai nütüma Maleiwa süpüla to'tte'erüinjachin wayuu. Ju'una jümata jüchikua jüküjaiwa nümüin Juan tü ji'rakat je tü jaapakat achiki. Tü wayuu eekai mo'uin, ko'usü. Tü eekai masa'ain, kasa'asü. Tü eekai saja'ttüin süta, ashatüsü tü sütakat. Tü eekai mache'ein, kache'esü. Tü eekai ouktüin, oso'iraasü saa'in. Je tü eekai müliain, aküjüna amüinrü tachiki tayakai chi O'tte'erüikai. ");
INSERT INTO guc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Anata'aleeshija'a ma'i chi wayuu eekai nnojolüin nuu'ulaain suulia anoujaa tanain sütümajee tü alatakat nümüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Shiasa'a no'unapa na nüjünalakana Juan, o'ttüshi Jesús sünain aküjaa nüchiki Juan sümüin tü wattakat saalin wayuu: “Soto jaa'in wanaa sümaa nuwoutisaajüin Juan chaa isashiipa'a. ¿Kasa ju'unaka ee'iree eemüin nia? ¿Süpüla ji'rüinjachin wane wayuu eekai nnojolin lotüin sünain anoujaa? Nnojo. ");
INSERT INTO guc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Süpüla ji'rüinjachin wane wayuu washirü eekai kashe'in kuluulu anasü? Nnojo. Na wayuu washinnuukana, na anakana ashe'in, kepiashii naya sulu'u nipia chi sülaülashikai mma, nnojoishii kepiain chaa eere maa'inyatuulin mma. ");
INSERT INTO guc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Shiimüin sünain ju'unüin chamüin süpüla ji'rüinjachin wane nünüikimaajachi Maleiwa. Je alana'aleeshia ma'i nia sünain kojutüin nütüma Maleiwa noulia na waneeinnua süka niain chi aapirakai wayuu sünain tantajachin tayakai. ");
INSERT INTO guc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nia chi ashajünakai achiki paala sünain nümüin chi Maleiwakai nümüin chi Nüchonkai sünain maa: ‘Taluwataajeechi chi pünüliamaajachikai püpüleerua süpüla naapirüinjatüin tü wayuukolüirua sünain püntajachin sa'akamüin. Yapainjatü nütüma tü wayuukolüirua süpüla saapajüin pünüiki’, müsü tü ashajuushikat. ");
INSERT INTO guc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Shiimüin tü tamakat jümüin, yaa sa'aka wayuu maa'ulu yaa, alana'aleeshia ma'i Juan sünain kojutüin nütüma Maleiwa suulia tü wayuukolüirua süpüshua. Otta na wayuu anoujashiikana tanain, mayaasüje nnojoliin kojutüin joolu'u sütüma wayuu, alana'aleejeeria tü nojutkat so'uweena wane ka'i suulia tü nujutkat Juan maa'ulu yaa. Shia süka laülaweenain naya cha'aya eere nuluwataain Maleiwa”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Napüshua na wayuu aapakana tü nümakat Jesús, je na okotchajüliikana neerü nümüin chi sülaülashikai mma, süka owoutisaajuushin naya nütüma Juan, müshii naya: “Anasü ma'i tü nuluwataakat anain waya Maleiwa”. ");
INSERT INTO guc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Akaajasa na fariseokana namaa na karalouktamaajanakana, na nnojoliikana owoutisaajünüin nütüma Juan, nayouktüin tü nüchekakat chi Maleiwakai napüleerua. ");
INSERT INTO guc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nümakalaka Jesús namüin na ayouktakana nünüiki: “¿Kasa maka aka naa'in na wayuu ka'akakana jia, na ayouktakana tanüiki? ");
INSERT INTO guc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nnojoishii jia talatüin tamaa, süka nnojolin taa'inrüin tü jüchekakat tapüleerua. Müshii aka jia saa'in tepichi eekai namüin namüin na natünajutkana saaliijee nnojoliin nashaitteein namaa: ‘Ja'itaina amaasijaayaain waya, nnojoliishii jia oyonnojoyaain sütüma. Je ja'itaina mojuyaain waa'in sünain ee'irajaa, nnojoliishii jia a'yalajayaain sütüma’, müshii na tepichikana. ");
INSERT INTO guc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Müshii aka jia saa'in tepichi, saa'u ‘Kale'eru'ushi nia yolujaa’ jümüin nümüin Juan chi owoutisaajüikai sünain jiyouktüin nünüiki, süka nnojolin ni'rajaain mi'iraa je süka nnojolin nüsüin wanaa jümaa. ");
INSERT INTO guc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Otta jünüiki tamüin tayakai, chi Shipayakai Wayuu, süka te'rajaain mi'iraa sümaa wayuu: ‘Wayuu kasa ale'echi nia, sütünajut tü okotchajütkalüirua neerü nümüin chi sülaülashikai mma, sütünajut tü kaainjaratkalüirua’, müshii jia tamüin sünain jiyouktüin tanüiki. Shiimüin tü tamakat, müleka nnojorule taa'inrüin süpüshua tü jüchekakat, nnojoleena jia talatüin tamaa. ");
INSERT INTO guc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Otta chi wayuu eekai shiimüin sünain nünoujain nünain Maleiwa, nütüjaweerü aa'u sünain shiimüin tü taküjakat nümüin”, nümakalaka Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Eenajinnüshi Jesús sünain wane ekawaa nipialu'u wane wayuu fariseo kanüliashi Simón. Nu'unakalaka. Shiasa nüntapa chamüin cha'aya, nüikkalaakalaka sünain tü ekawaakat. ");
INSERT INTO guc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Je wane jierü kaainjarat shipiajatü cha'aya, sütüjaapa naa'u Jesús sünain nikaain nipialu'u chi fariseokai, süntakalaka nünainmüin süpüla shi'rüinjachin nia. Alü'üjasü wane maraaja akumajuushi süka ipa kanüliasü “alabastro”, kalu'usü “perfume”. ");
INSERT INTO guc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Asha'walaasü shia nüchiiruajee Jesús sü'ütpa'a nuu'ui sünain shi'yalajüin sünain süshorottirüin tü su'wüirakat saa'u. Süla'ajaakalaka shia süka su'wala. Shipesutkalaka shia sünain shi'yotüin tü perfumekat saa'u. ");
INSERT INTO guc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Otta chi fariseokai eenajitkai Jesús, müsü naa'in nüle'eru'u: “Je chira, müleka niale wane chi nünüikimaajachikai Maleiwa, niyaawatüinje tü jierü epettakat nia, nütüjaa aa'uluje sukuaippa sünain kaainjaralüin shia, je niyouktüinje sümüin tü saa'inrakat nüka”. ");
INSERT INTO guc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Otta Jesús, süka nütüjaain saa'u tü jülüjakat naa'in, müshi nia nümüin: —Simón, anashi taküjale pümüin süchiki wane kasa. —Anakaja, Ekirajüikalee. Püküja maala tamüin —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nümakalaka Jesús: —Eeshi wane wayuu a'anapitshi nünneetse. Nujuyaajirüin piamashii wayuu. Wainma neerü tü najuyaalakat: 500 “denario” tü nujuyaalakat wane. Oo'ulaka chi wane, ajuyaajüshi ja'rai shikii “denario”. ");
INSERT INTO guc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Otta na nujuyaajitkana, naja'ttirüin tü neerü najuyaalakat. Isasü nachiki nawalaajüin süchikua nümüin chi a'anapitshikai naya. Otta niakai, nuu'ulaain tü nünneetsekat napüla —nümakalaka Jesús. Nüsakinnakalaka joo Simón nütüma: —¿Jaraleechi, saa'in pümüin, aika ma'i apüla chi a'anapitshikai neerü? ");
INSERT INTO guc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Asouktüshi Simón: —Niataa chi wayuu oo'ulaanakai wainma ojuyaala —müshi. —Pütchi lotüsü tü püsouktakat aka —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niirakaakalaka Jesús sünainmüin tü jietkat sünain ayatüin naashajaain nümüin Simón: —Piakai, nnojoishi kamaneein tamüin sümaa aapüin wüin su'lojia too'ui tantaiwa'aya pipialu'umüin. Alu'usa shiakat, süshorottirüin su'wüira saa'u too'ui sünain süla'ajaain shia süka su'wala. ");
INSERT INTO guc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Piakai, nnojoishi püpesujüin taya wanaa sümaa püsaküin taya tantaiwa'aya. Alu'usa shiakat, moo'ulaainyülia suulia epesujaa too'ui. ");
INSERT INTO guc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Piakai, nnojoishi kamaneein tamüin sümaa o'yotoo seita saa'u tekii. Alu'usa shiakat, shi'yotüin “perfume” saa'u too'ui süpüla shii'iyatüin sünain kojutüin taya sütüma. ");
INSERT INTO guc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ja'itairü wainmain paala tü saainjalakat, saa'u aliichipain taya süpüla süka süpüshua saa'in, atüjaana aa'ulu sünain motüitpain taa'in saainjala. Akaajasa piakai, nnojoishi alin taya püpüla süka süpüshua paa'in, maa aka alin taya süpüla tü jietkat, süka nnojolin che'ojaain motüin taa'in paainjala paajüin —nümakalaka Jesús nümüin Simón. ");
INSERT INTO guc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nümakalaka joo Jesús sümüin tü jietkat: —Motüitpa taa'in paainjala. ");
INSERT INTO guc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Otta na wayuukana ekaashiikana wanaajiraa nümaa, aashajaajiraashii naya: —Atak. Motüsü naa'in saainjala wayuu naajüin. ¿Jarai wayuu atüjaka süpüleerua tia? —müshii naya sünain nayoujüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Otta nünüiki Jesús sümüin tü jietkat: —O'tte'ennüitpa pia süka pünoujain tanain. Anasü müleka pu'unüle sünain anain paa'in —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Shiasa süchikijee tia, o'unüshi Jesús sulu'upünaa tü pueulokat süpüshua. Aküjüshi nia tü pütchi anasükat sümüin wayuu, süchiki nukuaippa Maleiwa sünain aluwatawaa. Je na Aluwataaushikana, na polooshiikana piammüin, o'unüshii naya nümaa. ");
INSERT INTO guc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Otta namaa nayakana, o'unüshii wane jieyuu eiyajünakana nütüma Jesús oo'ulaka na ayu'nnakana oulia yolujaa. Eesü María Magdalena, tü ayu'nnakat ale'eru'ujee akaratshisü yolujaa. ");
INSERT INTO guc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Eesü Juana, nu'wayuuse Chuza chi laamakai sulu'u nipia Herodes chi sülaülashikai mma. Je eesü Susana oo'ulaka wane jieyuu wainma. Nakaaliijain na jieyuukana Jesús je na nikirajüinkana süka tü nawashirüinkat. ");
INSERT INTO guc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","So'u wane ka'i, antapaatasü wayuu watta saalin nünainmüin Jesús sulu'ujee tü pueulokat süpüshua. Ekirajüshi joolu'u nia sünain wane kasa süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ");
INSERT INTO guc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Müshi nia namüin: “Eetaashi wane wayuu apünajüi. O'unüshi sulu'umüin tü niyüüjasekat sünain nijinain tü nuwaüyekat. Eesü waüyee ejituukat sulu'u wopu eepünaale süliikatünüin aa'u sütüma wayuu, eere shiküin shia wuchii. ");
INSERT INTO guc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eesü ejituukat eere arülain mma saa'u ipa. Shiasa susotapa, ajulujaasü süka josoin tü mmakat. ");
INSERT INTO guc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eesü ejituukat sa'aka mojuui eekai keimsein. Shiasa süsotapa, ouktüsü tü pünajütkat sütüma tü mojuuikat. ");
INSERT INTO guc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alu'usa wane waüyeekat, ejituushi saa'u mma anasü. Asotüsü, emiyo'ulaasü sünain wattain saalii süchon, maa aka poloo shikii süchon sünainjee waneesia so'u”, müshi joo Jesús sümüin tü wayuukolüirua. Je kettaapa nünüiki Jesús, “Chi eekai nüshateein tanüiki, anasü jülüjüle naa'in süpüla niyaawatüinjatüin saa'u tü tekirajakat anain”, nümakalaka sünain emetuluin nünüiki namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Otta na nikirajüinkana Jesús: “Pikirajüinapa waya sünain wane kasa süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ¿Jamalu'ut tü püküjakat wamüin?”, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Asouktüshi Jesús: “Nnojotsü atüjaanüin aa'u paala süchiki nukuaippa Maleiwa sünain aluwatawaa. Otta müshia joolu'u, o'ttüichipa taya sünain tee'iyatüin shia jümüin jiakana tekirajüinkana. Otta na wane wayuukanairua, tekirajüin naya waneepia süka sukuaippa tü kasa e'nnaajünakat sainküin mma, süpüla keraainjatüin tü ashajünakat paala, tü münakat wamüin: ‘Ja'itaka'a neirakaain sümüin tü kasa anasü taa'inrakat, je ja'itaka'a naapüin tü kasa anasü taküjakat achiki, nnojoleerü nayaawatüin aa'u tü tekirajeekat anain naya’ ”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nii'iyatakalaka joo Jesús namüin sünain jamalu'ulüin tü nüküjaitpakat sümüin tü wayuukolüirua süka sukuaippa tü kasa e'nnaajünakat sainküin mma. Müshi nia namüin: “Tü waüyeekat, shia nünüiki Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Je tü waüyee ejituukat eepünaale süliikatünüin aa'u sütüma wayuu, shia nakuaippa na wayuu eekai naapüin ne'e nünüiki Maleiwa sünain süsütünamaatüin tü pütchikat noulia nütüma Satanás suulia nanouja'alüin sünain süpüla no'tte'ennüinjanain nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Je tü ejituukat eere arülain mma saa'u ipa, shia nakuaippa wayuu eekai naapüin sümaa talataa aa'in nünüiki Maleiwa aküjünakat namüin. Müshii aka naya saa'in tü pünajüt ajulujaakat. Anoujashii naya motso'o ne'e. Otta ne'rapa müliaa sünainjee tü nanoulakat, oo'ulaa müshiija suulia anoujaa. ");
INSERT INTO guc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Je tü ejituukat sa'aka mojuui eekai keimsein, shia nakuaippa wayuu eekai naapüin nünüiki Maleiwa sünain malaüle'erüin naa'in sünain anoujaa, sükajee ayatüin naya shapaain naa'in naa'ujiraa shii'iree washirüü je shii'iree emi'ijaa. ");
INSERT INTO guc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Otta tü waüyee ejituukat saa'u mma anasü, shia nakuaippa na wayuu eekai naapüin nünüiki Maleiwa sümaa naapaain shia süka süpüshua naa'in. Lotüshii ma'i naya sünain anoujaa waneepia sütüma. Je maa aka tü pünajütkat saa'u mma anasü sünain wainmain süchon, koo'omüinsü namüin na wayuukana aa'inraa kasa anasü, süka nachecherüin naa'in sünain anoujaa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aashajaashi joolu'u Jesús namüin nüchikua: “¿Jalasü e'itaanüin wane rampara chuwatüle? ¿E'itaanüsü suupünaa wayeeta? ¿E'itaanüsü suupünaa türoojo? Nnojotsü anain tia. Anasü shi'itaanüle iipünaa eere süpülee luusa, süpüla shi'nnüinjatüin tü suwaralakat sütüma wayuu eekai shikerolüin. Müsüya aka tü nüchikikat chi Maleiwakai. Nnojotsü anain müleka sunujunnule suulia wayuu. Shia anaka alu'u müleka süküjünüle sümüin wayuu süpüshua sünain shikirajünüinjatüin sünain. ");
INSERT INTO guc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Müleka sunujunnule wane kasa, eweeteerü süchikua. Müsüya aka tü nüchikikat chi Maleiwakai. Ja'itairü nnojolüin aküjünüin paala sümüin wayuu sainküin mmakat süpüshua, aküjüneerü joolu'u sümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Je sükajee tia, anashii müleka eere jaa'in sünain tü pütchi jaapakat. Chi wayuu eekai jülüjain naa'in tü shiimainkat ekirajünakat anain nia, ekirajüneechi nia soo'omüin. Akaajasa chi eekai nnojolüin kasajatüin nümüin tü shiimainkat, asütüneerü nuulia tü ekirajünakat anain nia paala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Je joolu'u, antüsü tü niikat Jesús oo'ulaka na nimüliayuukana süpüla naashajaainjanain nümaa. Otta isasü nachiki arütkawaa nünainmüin, süka wainmain wayuu yaa nü'ütpa'a. ");
INSERT INTO guc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Naapinnakalaka Jesús: —Naa tü püikat anooipa'a oo'ulaka na puwalayuukana. Aashajaweeshii pümaa —nümünakalaka. ");
INSERT INTO guc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Asouktüshi Jesús: —Tü wayuu “teikat” je na wayuu “tawalayuukana” tamüinjanakana amüin, naya na eekai naapüin tü nünüikikat Maleiwa sünain naa'inrüin waneepia tü nuluwataakat anain —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","So'u wane ka'i, müshi Jesús namüin na nikirajüinkana: —Anashii wo'unüle waneemüin sa'ata tü palaakat. O'otoo müshiija'a joo naya sulu'u tü anuakat sünain no'unüin. ");
INSERT INTO guc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Je süma'inru'u waraittüin tü anuakat shirokupünaa tü palaakat natüma na nikirajüinkana, atunküshi Jesús. Anta müsia joo wane wawai nanainmüin sünain shi'yotüin palaa sulu'umüin tü anuakat. Pejeirü süpüla shimerojooin tü anuakat shiinalu'umüin tü palaakat. ");
INSERT INTO guc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Narütkaakalaka na nikirajüinkana nünainmüin, —Ekirajüikalee, püchijiraa maala. Ouktüshii taa waya —namakalaka nümüin. Nüsha'walaakalaka Jesús sünain nüchiajaain tü wawaikat sümaa tü palaa ko'ontakat nanainmüin. Ejimalaa müsia joo tia sütüma nünüiki. ");
INSERT INTO guc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nümakalaka Jesús namüin na nikirajüinkana: —¿Nnojotsü jünoujüin paala sünain to'tte'erüinjanain jia suulia tü wawaikat? —müshi nia namüin. Eimolojooshii ma'i naya sümaa naashajaajiraain sünain namüin: —¿Jaraikai wayuukai chii, kache'ekai amüin wawai oo'ulaka tü palaakat? —müshii naya, süka ponüin ma'i naa'in tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Antüsü joolu'u tü anua kalu'ukot Jesús namaa na nikirajüinkana waneemüin sa'ata palaakat chejee Galileajee. Je cha'aya, kepiasü wane wayuuirua kanüliajüsü Gadareno. ");
INSERT INTO guc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nüshakatapa Jesús sulu'ujee tü anuakat, eejachi nüpüla wane wayuu kale'eru'ushi yolujaa. Kepiashi chi wayuukai paala sulu'u tü pueulokat. Akaajasa joolu'u nia, kepiashi amuuyuupa'a sünain mashe'inkuu nümüin. Kakaliaichi sünain nnojolin kepiain nia sulu'u miichi. ");
INSERT INTO guc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Je süntaiwa'aya tü yolujaakalüirua nünain, ako'ojinnüshi nia sütüma wayuu. Otta ja'itaichi ako'ojünüin nia süka kaleena, nü'tsouktüin tia sünain nu'uninnüin sütüma tü yolujaakat eemüinre isashiipa'a. Arütkaashi joolu'u chi wayuukai nünainmüin Jesús sünain nüsapainyo'ukain nümülatu'umüin. Otta müshia Jesús, nümaja amüinrü tü yolujaakat süpüla sujuittüinjatüin nüle'eru'ujee chi wayuukai. Emetutsü joo sünüiki tü yolujaakat nüle'eru'ukat chi wayuukai sünain sümüin: —Jesúsuu, Nüchonka'iya Maleiwa Miyo'ushikai ma'i, ¿jamüinjatü takuaippa pütüma? Nnojo e'rülin wayumüin pia tamüin —sümakalaka wainmatua nümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Kasaichi pünülia? —nümakalaka Jesús sümüin. —Watta saalii, münüshii waya —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Namakalaka joolu'u na yolujaakana yaakana nüle'eru'u chi wayuukai: —Nnojo püjütüin waya wattamüin shiinalu'umüin mmakat eere müliain weinshi tü wapüshikalüirua —müshii naya wainmatua nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eejatü wane püülüküirua ekajaain cha'aya saa'u wane namüna. Nachuntüin na yolujaakana wainmatua nümüin Jesús shii'iree najütünüin süle'eru'umüin tü püülükkalüirua. —Ju'una jümaarüleen —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ojuitta müsüja tü yolujaakalüirua nüle'eru'ujee chi wayuukai sünain shikerolüin süle'eru'umüin tü püülükkalüirua. Apantajaayaa müsü tü püülükkalüirua saa'ujee tü namünakat shirokumüin tü palaakat. Oo'uwo'utkalaka shia süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na arüleejüliikana tü püülükkalüirua ne'rapa tü alatakat sümüin, apantajaashii naya sulu'umüin tü pueulokat je sainküin mma sünain aküjaa süchiki. ");
INSERT INTO guc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Otta na wayuu aapakana nanüiki, o'unüshii naya sünain e'rajawaa tü aküjünakat achiki namüin. Je nantapa nünainmüin Jesús, ne'rüin chi wayuukai ojuittinna ouliachikai yolujaa, sünain kashe'inchipain nia, otta nnojolichipain mamainnain, sünain joyotüin nü'ütpa'a Jesús. Eimolojooshii naya ne'rapa nia. ");
INSERT INTO guc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Otta na wayuu eejanakana wanaa sümaa niiyajünüin chi wayuukai, naküja achikichi nia sümüin tü antüsükalüirua. ");
INSERT INTO guc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Je napüshua na wayuu Gadarenokana, süka mmolüin ma'i naya, nachuntüin ma'i nümüin Jesús süpüla nu'unüinjachin noulia. Je wanaa sümaa no'otooin Jesús sulu'umüin tü anuakat süpüla ale'ejaa Galileamüin, ");
INSERT INTO guc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","arütkaashi joo chi ojuittinna ouliachikai yolujaa nünainmüin shii'iree nu'uneein nümaa. Otta müshia Jesús, niyouktüin süchiki nümaainjachin nia, sünain nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Anashi püle'ejüle püchikua pipialu'umüin sünain püküjain süchiki tü kasa anasü naa'inrüitpakat chi Maleiwakai pümüin. Ale'ejaashi joo chi wayuukai pueulopa'amüin sünain aküjaa sümüin wayuu süpüshua süchiki tü kasa anasü naa'inrüitpakat Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Shiasa nüle'ejapa Jesús Galileamüin, eesü wayuu wainma a'atapajüsü nia. Je talatüsü saa'in nüntapa. ");
INSERT INTO guc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Je na'aka na wayuukana, eeshi wane wayuu kanüliashi Jairo, wane laülaashikai sulu'u tü ekirajüleekat tü judíokolüirua. Ayuuisü nüchon, waneesüchon shia nümüin, polooirü piammüin juya suuyase. Amotsojünüsü saa'in sütüma tü ayuulii sünainkat. Anta müshija'a nia sünain nüsapainyo'ukain nümülatu'umüin Jesús, sünain nüchuntüin wainmatua nümüin süpüla nu'unajachin nipialu'umüin süpüla niiyajüinjatüin tü nüchonkot. Je sünain nu'unüin Jesús nipialu'umüin Jairo, eesü wayuu watta saalin sünain yentaawain shia nümaa. ");
INSERT INTO guc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Je sa'aka tü wayuukolüirua, eesü wane wayuu ayuuisü. Polooirü piammüin juya amülain isha sümüin waneepia. Mepiirü shia, ja'itairü saapüin sünneetse süpüshua sümüin tottoolu. ");
INSERT INTO guc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sülü'ülaakalaka tü wayuukot nüchiirua Jesús shii'iree shipetteein sot nüshe'in. Je shipettapa shia, anaitpa, nnojolüitpa amülain isha sümüin. ");
INSERT INTO guc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—¿Jarat epettaka tashe'in? —nümakalaka joo Jesús. Otta tü wayuukolüirua süpüshua, ko'utüsü ne'e nuulia. Nümakalaka joo Pedro: —Senyotkalee, ¿jamüshikai pia? Wainma wayuu chentaawain pümaa. ");
INSERT INTO guc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nümakalaka Jesús: —Nnojo. Eesü wane epettakat tashe'in, süka tayaawatüin saa'u anaitpain tatüma wane wayuu —müshi nia. ");
INSERT INTO guc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Je sütüjaapa saa'u tü jietkat sünain nüliratüin naa'in shia, arütkaasü shia nünainmüin sünain süsapainyo'ukain nümülatu'umüin sünain shapashapatüin saa'in. Je su'upala tü wayuukolüirua süpüshua, aküjüsü shia nümüin Jesús sünain shiain epettüin tü nüshe'inkat je sünain anaitpain shia nütüma. ");
INSERT INTO guc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nümakalaka Jesús sümüin: —Nii waa'iraa, anaitpa pia süka pünoujain tanain. Anasü pu'unüle sünain anain paa'in. ");
INSERT INTO guc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wanaa sümaa naashajaain Jesús sümaa tü jietkat, nüntakalaka joo wane wayuu nipialu'ujeejachi Jairo chi laülaashikai sulu'u tü ekirajüleekat, sünain nümüin nümüin: —Ouktüitpa tü püchonkot. Puu'ulaa suulia peenajaain chi Ekirajüikai. ");
INSERT INTO guc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Naapapa Jesús nünüiki chi wayuukai, nümakalaka nümüin Jairo: —Nnojo piyo'ujaain aa'in. Pünouja ne'e tanain süpüla anainjatüin tü püchonkot. ");
INSERT INTO guc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Shiasa nüntapa Jesús nipialu'umüin Jairo, eesü wane wayuuirua a'waatüin ma'i shi'iralu'u saalii tü jintutkot. —Nnojo ji'yalajüin. Tü jintutkot, nnojotsü ouktüin, atunküsü ne'e —nümakalaka Jesús sümüin. Süsirajakalaka tü wayuukolüirua nüka Jesús, süka natüjaain saa'u sünain ouktüin shia. Nikerotitkalaka joo Jesús palitchon wayuu ne'e sulu'umüin tü miichikat: Pedro, Jacobo, Juan, oo'ulaka chi süshikai tü jintutkot je tü shiikat. ");
INSERT INTO guc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naapaakalaka joo Jesús sajapü tü jintutkot sünain nümüin sümüin: —Püchijiraa maala, Tachee. ");
INSERT INTO guc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Suso'iraakalaka aa'in tü jintutkot sünain süsha'walaamaatüin. Shiasa süchikijee tia, —Anasü müleka shikinnüle —müshi Jesús. ");
INSERT INTO guc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ponusü ma'i joo naa'in chi süshikai je tü shiikat. Otta Jesús, —Nnojo jüküjüin sümüin wayuu süchiki tü taa'inrakat süka tü jüchonkot —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Shiasa süchikijee tia, nükotchajaakalaka Jesús na Aluwataaushikana polooshiikana piammüin sünain nümüin namüin: —Taapüin laülawaa joolu'u jümüin süpüla ayu'laa yolujaa süle'eru'ujee wayuu je süpüla eiyajaa wayuu eekai ayuulin. ");
INSERT INTO guc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ju'una jümata jiiyajaiwa wayuu eekai ayuulin, je ju'una jüküjaiwa sümüin wayuu süchiki nukuaippa Maleiwa sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nnojo jülü'üjüin jüchise: wunu'u jüshepü'üjia, jükatto'uise, jimia, jünneetse, je suwala'ata jüshe'in. ");
INSERT INTO guc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Je jüntapa sulu'umüin wane pueulo, nnojoleerü jii'iratüin tü miichi jüntakat alu'u palajana. Waneeitpaleerü jüpülee süma'inru'u eein jia sulu'u tü pueulokot. ");
INSERT INTO guc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Je müleka nnojoliire kapülain aa'inyüü jia sulu'u wane pueulo, ju'unamaata suulia sünain jo'otojooin tü mmakat sünainjee juu'ui jüma'ichikü shiyaawase jümüin: “Nnojotsü wasirüitpain eekai manoujüinyeein ale saa'in ne'e” —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","No'unakalaka joo na polooshiikana piammüin sulu'upünaa tü pueulokat süpüshua, sünain naküjain tü nüchikikat chi O'tte'erüikai sümüin wayuu je sünain neiyajüin wainma wayuu. ");
INSERT INTO guc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Otta müshia Herodes, chi sülaülashikai mma, naapa achikichi Jesús sümaa süpüshua tü kasa naa'inrakat sainküin mmakat. “¿Jarai cheje eera nia?”, müsü naa'in nüle'eru'u süka nnojolüin wanaawain süküjala tü wayuukolüirua nüchiki. “Niataa Juan owoutisaajüikai oso'iraain aa'in”, müsü waneeirua. ");
INSERT INTO guc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","“Niataa Elías chi nünüikimaajachikai Maleiwa paala sümaiwa, eweetüin maa'ulu yaa”, müsü süküjala waneeirua. “Oso'iraataasü naa'in wane eekai nünüikimaajachin Maleiwa paala sümaiwa”, eesü makat. ");
INSERT INTO guc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Otta Herodes sütüma tü naapakat achiki, ni'reekalaka ma'i Jesús. “¿Jarai cheje eera chi taapakai achiki? Nnojoijasa niain Juan nia. Tashottira anutpünaachinkasa chia”, majataasü naa'in. ");
INSERT INTO guc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ale'ejüshii joo na Aluwataaushikana polooshiikana piammüin nünainmüin Jesús sünain naküjain nümüin süchiki tü kasa naa'inrakat sainküin mma. Nümaakalaka joo naya sa'akajee tü wayuukolüirua eemüinre yüütüülin, peje sünain wane pueulo kanüliasü Betsaida. ");
INSERT INTO guc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Otta tü wattakat saalin wayuu, su'unakalaka nüchiirua Jesús sütüjaapa naa'u sünain nu'unüin. Nürütkaakalaka joo shia süntapa nünainmüin, sünain niiyajüin eekai ayuulin. Je nüküjain namüin süchiki nukuaippa Maleiwa sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Shiasa motsopa ka'ikat, na polooshiikana piammüin, süka mo'unüinyülia ne'rüin tü wattakat saalii wayuu, narütkaakalaka nünainmüin Jesús sünain maa: —Ekirajüikalee, yüü'üyütüüisü ma'i tü mmakat yaa. Anasü müleka püjütüleirua su'unaiwa sulu'umüin tü pueulokalüirua je sainküin shipia wayuu nachajaaiwa tü neküinjatkat je süpüla eeinjatüle sutunküin —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Jaapa jiakana neküin —nümakalaka Jesús namüin. Nasouktakalaka nümüin: —Ja'raisü pan je piamasü ne'e jime asijuushi eekat wama'ana. Ja'itakaje ne'e wo'unüin wayalajaain shiküin, isasia ne'e wachiki. Watta ma'i saalii tü wayuukolüirua —müshii naya. ");
INSERT INTO guc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Eejana maa aka 5.000 tooloyuu sa'aka tü wayuukolüirua süpüshua sünain mayaawajuin na jieyuu oo'ulaka na tepichi eejanakana. —Anakaja müleka süikkalaale tü wayuukolüirua sünain ja'raiwalin shikii —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naa'inrüin joo tü nuluwataakat anain naya. Aikkalaashii joo napüshua na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naapaakalaka joo Jesús tü ja'raisükat pan je tü piamasükat jime. Niirakaakalaka iipünaamüin sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshanaajakalaka joo shia süpüla nottonojüinjatüin na nikirajüinkana süka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eküshii napüshuale'eya je emirashii sünainjee. Je süchikijee, okotchajünüsü tü napütaalakat, maa aka poloo piammüin katto'ui. ");
INSERT INTO guc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Shiasa so'u wane ka'i, aashajaashi Jesús nümaa Maleiwa najuuna na nikirajüinkana. Je süchikijee, nüsakitkalaka joo naya: —¿Jarai taya saashin tü wattakat saalin wayuu? ");
INSERT INTO guc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nasouktakalaka: —“Niataa Juan chi owoutisaajüikai”, müsü waneeirua. “Niataa Elías”, eesü makat. “Oso'iraataasü naa'in wane eekai nünüikimaajachin Maleiwa paala sümaiwa”, eesü makat ne'e —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Jama jiakana, ¿jarai taya jaajüin? —nümakalaka namüin. Nüsouktakalaka joo Pedro nümüin: —Pia Cristo, chi Nüneekajalakai Maleiwa süpüla o'tte'eraa wayuu. ");
INSERT INTO guc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nüchiajaakalaka joo Jesús naya suulia naküja'alüin nüchiki sümüin wayuu sünain niain Cristoin. ");
INSERT INTO guc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nüküjakalaka joo namüin süchiki tü alateetkat nümüin: —Tayakai, chi Shipayakai Wayuu, ja'ijaasü müliainjachin taya sünain tayouktünüinjachin natüma na laülaayuushiikana naa'u na judíokana, oo'ulaka natüma na laülaayuushiikana na'akajee na sacerdote judíokana, oo'ulaka natüma na karalouktamaajanakana. O'utinneechi aa'in taya natüma. Je so'u apünüin ka'i süchikijee tia, oso'ire'enneechi aa'in taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aashajaashi joo Jesús namüin na nikirajüinkana je sümüin tü wayuukolüirua süpüshua: —Chi wayuu eekai tamaweein, anakaja müleka nnojorule naa'inrüin tü nüchekakat ne'e nümüiwa. Shia anaka alu'u müleka naa'inrüle waneepia tü nüchekakat Maleiwa nüpüleerua, sümaa nnojolüin mmolüin sheema o'utinnaa aa'in saa'u noonooin sümaa tanüiki. ");
INSERT INTO guc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi eekai niyouktüin taya süka naa'inmajiraweein nukuaippa suulia ouktaa, amülouijeerü nukuaippa süpüshua. Otta chi wayuu eekai naapajiraain nukuaippa süpüla ni'yataainjachin tamüin, mayaashije o'utüneechin aa'in sünainjee tia, ayateechi o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Maja'a aka chi eekai niyouktüin taya süka washireein nia, nnojoleerü shiain amülouleerüin ne'e tü nuwashirüinkat sümüiwa, amülouijeerü tü nukuaippakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi wayuu eekai nnojolin kasajachin tayakai chi Shipayakai Wayuu nümüin sünain nnojolin nüküjüin tachiki sümüin wayuu süka japülin nia taka, nnojoleechi kasajachin nia tamü'inya tale'ejapa chajee eejee chi Tashikai Maleiwa. Je tantapa, shiimain sünain warattuuleerüin tü mmakat süka eeinjanain na aapiee nüma'anajeejanakana tamaa. ");
INSERT INTO guc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Shiimüin tü tamakat jümüin: Ana'aya ju'utku jia yaakana maa'ulu nnojoleenakana ouktüin süpülapünaa ne'rüin sünain su'ttüin tü aluwatawaakat nütüma Maleiwa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Je mapa süchikijee tia maa aka wane semaana, neenajaakalaka Jesús apünüinshii na nikirajüinkana: Pedro, Juan oo'ulaka Jacobo, süpüla no'unajanain nümaa namüiwa eemüin wane uuchi, süpüla naashajaainjachin nümaa Maleiwa cha'aya. ");
INSERT INTO guc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Je chamüin cha'aya, wanaa sümaa nüchuntüin Jesús nümüin Maleiwa, ee'iranajaasü nu'upünaa. Otta nüshe'in, jorojorotsü ma'i maa aka shiyaa juya. ");
INSERT INTO guc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eweenaa müshi'iya wane piamashii wayuu nünainmüin Jesús, nia Moisés oo'ulaka Elías, na nünüikimaajanakana Maleiwa paala sümaiwa. Kamacherajüsü ma'i nashe'in sümaa anashaatain ma'i shia süka nantüshiin nüma'anajee Maleiwa. Yootüshii naya nümaa Jesús süchiki tü ouktajachin nia cha'aya Jerusalén süpüla keraainjatüin nütüma tü nüchekakat chi Maleiwakai nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Otta müshia Pedro namaa na nütünajutkana, yaashii naya sümaa natunkeein ma'i. Shiasa'a neerutpa no'u, ne'rüin Jesús sünain kamacherain ma'i nüshe'in sümaa kasuuin je sünain warattuuin tü mmakat nü'ütpa'a. Je ne'rüin na piamashiikana wayuu sha'watiraain nümaa. ");
INSERT INTO guc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Je wanaa sümaa nu'unüin Moisés nümaa Elías nüma'anajee Jesús, nümakalaka Pedro: —Ekirajüikalee, anasü ma'i süka we'rüitpain tü kasa alatakat wo'upala. Anasü müleka wakumajüle apünüinsü luma: wane püpüla, wane nüpüla Moisés, je wane nüpüla Elías —müshi nümüin Jesús sünain nnojolüin jülüjain naa'in tü nümakat. ");
INSERT INTO guc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wanaa sümaa naashajaain Pedro, eweetalaa müsü wane siruma nanainmüin. Neimolojookalaka sütüma süka süntüin na'akamüin. ");
INSERT INTO guc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Süsouktakalaka wane pütchi sa'akajee tü sirumakat: “Anii chi Tachonkai, chi Taneekajalakai. Jüüjüü mata jia sümüin nünüiki”, sümakalaka tü pütchikat namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Je kettaapa tü pütchikat, eeshi Jesús nümüiwa namaa na apünüinshiikana nikirajüin. Je nnojoliishii naküjain süchiki tü kasa ne'rakat sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Shiasa mapa waneemüin ka'ikat, ashakatüshi Jesús saa'ujee tü uuchikat namaa na apünüinshiikana nikirajüin. Napanapajakalaka wayuu watta saalin. Otta na nikirajüinkana, nnojotsü naküjain sümüin tü wayuukolüirua tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Je sa'akajee tü wayuukolüirua, nu'waatakalaka wane wayuu nümüin Jesús: —Ekirajüikalee, anii tachon ayuuishi. Kale'eru'ushi yolujaa. Je wanaa sümaa saapaain nia, a'waatüshi sütüma. O'kchichijaashi sümaa komokoin sütüma, süka nüle'eru'uin shia waneepia. Pükaaliijapan, süka waneeshichan chi tachonkai tamüin. ");
INSERT INTO guc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tachuntayaainje'e namüin na pikirajüinkana shii'iree nayu'leein tü yolujaakat nuulia. Isasü nachiki —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nümakalaka Jesús sümüin tü wayuukolüirua süpüshua: —Jiakana manoujüinyeekana tanain, jia e'rüliikana wayumüin tamüin, wattairü süma'a ta'atapajüin jia shii'iree jünoujeein tanain —nümakalaka namüin. —Püche'era chira püchonkai —nümakalaka nümüin nüshi chi jintüikai. ");
INSERT INTO guc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Je sünain nürütkaain chi jintüikai nünainmüin Jesús, apalasüjawa'ain müshi, o'kchichijawa'ain müshi sütüma tü yolujaakat. Otta müshia Jesús, nuu'ule'erakalaka tü yolujaakat suulia tü saa'inrakat nüka chi jintüikai. Niiyajakalaka joo nia je naapüin nia nümüin chi nüshikai. ");
INSERT INTO guc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Otta tü wayuukolüirua, oponojoosü ma'i saa'in süka shi'rüin tü naa'inrüitpakat Jesús. “Anashaataleeshia ma'i chi Maleiwa Pülashikai ma'i”, müshii naya. Naashajaakalaka joo Jesús namaa na nikirajüinkana: ");
INSERT INTO guc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Jülüja jümata jaa'in tü tamüinjatkat jümüin joolu'u. Tayakai, chi Shipayakai Wayuu, aapüneematüichi ekii taya sajapulu'umüin wane wayuuirua —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Otta na nikirajüinkana, nnojotsü nayaawatüin aa'u tü nümakat namüin. Nnojotsü ja'yain sulu'u, süka nnojolüin shii'iyatünüin namüin nütüma. Je eimolojooshii ne'e naya seema nasakirüin nia sünain. ");
INSERT INTO guc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A'ülüjaajiraashii joo na nikirajüinkana Jesús nujuuna sünain jaraleechin miyo'uin na'akajee so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Shiasa Jesús, süka nütüjaain saa'u tü sulu'ukat naa'in nayakana, neenakakalaka wane jintüi no'upala nü'ütpa'amüin. ");
INSERT INTO guc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naashajaakalaka Jesús namüin na nikirajüinkana: —Chi wayuu eekai kamaneein sümüin wane wayuu saa'u nünoujain tanain, maa aka kamaneein taya nümüin jintüikai chii, kamaneeshi nia tamü'inya wanaa sümaa. Je saa'u kamaneein nia tamüin, kamaneeshi nia nümüin chi kajünalakai taya'aya. Chi wayuu eekai kamaneein sümüin wayuu süpüshua, nieechi laülaashika'aya ja'akajee —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nümakalaka Juan: —Ekirajüikalee, eeshi we'rüin wane wayuu ayujashi yolujaa süle'eru'ujee wayuu. Naa'inrüin tia süka shiain kojutüin pünülia nütüma naajüin. Woo'ule'erakalaka nia suulia süka nnojolin wamaajachin nia —müshi nia nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Kettiichian. Chi wayuu eekai nnojolin jü'ünüüin, jüpüshi —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Shiasa joolu'u, süka pejein tü nükaliakat Jesús süpüla ouktajachin otta süpüla niyaleraainjachin iipünaamüin eemüin Maleiwa, o'ttüshi sünain o'unaa Jerusalénmüin, süka shiain tü nüchekakat chi Maleiwakai nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aluwataanüshii wane anülieeirua palajana nütüma süpüla nachajaain atunkülee nüpüla Jesús namaa na nikirajüinkana. Nantakalaka joo na anülieekana eemüin wane pueulo sulu'u tü mmakat Samaria. ");
INSERT INTO guc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Je na wayuukana cha'aya natüjaapa naa'u Jesús sünain cha'walin Jerusalénmüin, mamaneesalii naya nuulia. ");
INSERT INTO guc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Otta Jacobo nümaa Juan natüjaapa saa'u sünain mamaneein tü wayuukolüirua noulia, müshii naya: —Senyotkalee, ¿pücheküin wachuntüin wane siki nümüin Maleiwa süpüla a'ajia tü wayuukolüirua, maa aka nütüma Elías paala sümaiwa? ");
INSERT INTO guc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Nujununtaakalaka joo Jesús nanainmüin sünain nüchiajaain naya: —Nnojo jütüjaain saa'u tü jümakat. Taya, chi Shipayakai Wayuu, nnojoishi tantüin süpüla to'utirüin saa'in wayuu, alu'ujasa süpüla to'tte'erüinjatüin shia —nümakalaka namüin. O'unüshii joo naya eemüin wane pueulo naata. ");
INSERT INTO guc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Shiasa sünain wopulu'uin Jesús namaa na nikirajüinkana, nümakalaka wane wayuu nümüin: —Pümaajeechi taya eepünaale pia. ");
INSERT INTO guc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Asouktüshi Jesús nümüin: —Tü walitkalüirua, eesü ishi süpüla eeinjatüle sütunküin. Je tü wuchiikalüirua, kepiasü iipünaa eere sütunküle. Otta tayakai, chi Shipayakai Wayuu, mepiasai —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aashajaashi joo Jesús nümüin wane'eya: —Joo'uya tamaaiwa pia —nümakalaka nümüin. Je nünüiki chi wayuukai ni'ipajee: —Senyotkalee, alü'ütsü nükalia chi tashikai süpüla ouktajachin. Anashi tojoitüle nia palajana süpülapünaa to'unüin pümaa. ");
INSERT INTO guc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Asouktüshi Jesús nümüin: —Anakaja nayale ojoitüin na püpüshi makana saa'in wayuu ouktüsü saa'u nnojolüin nanoujüin tanain. Otta piakai, anashi müleka pu'unüle tamaa püküjaiwa sümüin wayuu süchiki nukuaippa Maleiwa sünain aluwatawaa —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Otta wane'eya, müshi nümüin Jesús: —Senyotkalee, pümaajeechi taya. Otta palajana, anashi tapütaale süpüla tü tapüshikalüirua cha'aya tepialu'u —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Asouktüshi Jesús: —Müinka naapaale wane wayuu tü aküjaakat süchiki nukuaippa Maleiwakai sünain aluwatawaa, nnojoleerü nuuntüin naa'inrüin müleka shiale jülüjain naa'in tü naa'inrapü'ükat paala süpülapünaa naapaain —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Shiasa süchikijee tia, nüneekajakalaka chi Senyotkai noo'omüin na nikirajüinkana maa aka akaratshishii nekii noo'omüin na polookana piammüin. Nüjütüin naya nüpüleerua sünain piamawalin naya nütüma sulu'upünaa tü pueulokot süpüshua je sainküin mmakat süpüshua chaa eemüinjachire nia. ");
INSERT INTO guc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aashajaashi Jesús namaa nama'ichiki: “Wainma wayuu eekai saapeein tachiki tayakai chi O'tte'erüikai. Otta palitchon na yapakana süpüla o'unaa sünainmüin tü wayuukolüirua süpüla naküjainjatüin tachiki sümüin. Je sükajee tia, jüchunta jumaala nümüin chi Tashikai Maleiwa süpüla nuluwataainjanain na wayuu aküjüinjanakana tachiki namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ju'una jumata. Meena aka jia saa'in anneetchen sa'aka unaalü, süka taluwataain jia sa'akamüin tü ta'ünüükalüirua. ");
INSERT INTO guc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nnojo jülü'üjüin jünneetse oo'ulaka jükapateetse oo'ulaka shii'iratia jüsapaatse. Je nnojo jüsha'walaain sulu'u wopu sünain yootoo sümaa wayuu. ");
INSERT INTO guc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Je jüntapa nama'anamüin wane wayuu: ‘Kasataalejese saapünüin wane anaa jümüin nütüma Maleiwa’, meena jia namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Je na kepiashiikana sulu'u tü miichikat, müleka nacheküle süpüleerua anainjanain naya nütüma Maleiwa, aapüneerü wane anaa namüin. Akaajasa nnojorule nacheküin, nnojoleerü aapünüin shia namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Anakaja müleka jutunküle süma'ana tü wayuu jüntakat anainmüin palajana. Nnojoleerü jii'iratüin shia süma'inru'u chain jia sulu'u tü pueulokot. Maa aka nuwalaajünüin wane a'yataai, akaajaa jiakana. Anakaja saapajünüle tü che'ojaakat jümüin sütüma tü wayuu jikirajakat. ");
INSERT INTO guc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Je jikerolapa sulu'u wane pueulo, müleka kamaneere tü wayuukolüirua jümüin, anashii makatüle jia sümaa jiküin tü aapünakat jümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jiiyaja tü wayuu eekai ayuulin cha'aya. Je jüma namüin na wayuukana napüshua: ‘Nücheküin Maleiwa süpüleerua juu'ulaain suulia jaainjala süpüla nuluwataainjanain jia’. ");
INSERT INTO guc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Je müleka mamaneere tü wayuukolüirua juulia, ju'una nama'anajee sünain jümüin namüin emetut süpa'apünaa tü pueulokat: ");
INSERT INTO guc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Saa'u nnojoliin kasajanain waya jümüin, nia nnojoika kasajachin jümüin Maleiwa. Anashii joolu'u wo'unüle juulia. Otta soto jaa'in sünain sülü'ülüin nükalia chi Maleiwakai süpüla aluwatawaa’, meena jia namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","So'u tü ka'i kasalajaneetkat o'u sümüin saainjala wayuu nütüma Maleiwa, na ayouktakana jünüiki, mülialeweena ma'i naya suuliale'eya tü kaainjaratkalüirua sulujutkat paala tü pueulokat Sodoma”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ayatshi Jesús aashajaain namaa na nikirajüinkana: “Tü tamüinjatkat sümüin tü wayuu judíokalüirua cha'aya sulu'u tü pueulokat Corazín oo'ulaka Betsaida, müsü mayaa: ‘Alu'uleeka ma'i jia amülouinjanaka'a saaliijee jiyouktüin tanüiki sünain ji'rüin ma'i taa'inrüin wainma kasa anasü nütüjakat apüleerua Maleiwa nümüiwa. Otta müleka shialeinkaje e'rüin tü wayuu gentilekalüirua sümaiwa paala sulujutkat tü pueulokalüirua Tiro oo'ulaka Sidón tü kasa anasü taa'inrakat joolu'u ju'upala, mojusüinkaje saa'in saalii saainjala sümaa suu'ulaain suulia. ");
INSERT INTO guc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Je so'u tü ka'i süsaleetkat o'u wayuu saainjala nütüma Maleiwa, mülialeweenia ma'i jia suuliale'eya tü kaainjaratkalüirua chajatkat Tiro je Sidón’. ");
INSERT INTO guc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Je tü tamüinjatkat sümüin tü wayuu judíokalüirua cha'aya sulu'u tü pueulokat Capernaum, müsü mayaa: ‘Süsaleena jiakanaya ayouktakana tanüiki. Awalaajüneena jia nütüma Maleiwa jaajüin. Otta nnojoleena awalaajünüin jia. Shieerü eeka süsaleenain ma'i jia nütüma’. ");
INSERT INTO guc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Otta jiakana tekirajüinkana, chi wayuu eekai naapaain jünüiki, naapaain tanüikiya. Je chi eekai niyouktüin jia, niyouktüin tayakai wanaa jümaa. Je sünain nnojolin kasajachin taya nümüin, nia nnojoika kasajachin nümüin Maleiwa chi kajünalakai taya”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Shiasa mapa süchikijee no'unüin na nikirajüinkana Jesús nüma'anajee, na akaratshishiikana nekii, süchikijee naa'inrüin süpüshua tü aluwataanakat anain, ale'ejüshii naya nünainmüin sümaa talatüin ma'i naa'in. —Senyotkalee, saa'u puluwataalain waya, jüüjüüsü wamüin yolujaayaakaije'e ne'e —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nümakalaka joo Jesús namüin: —Jüüjüüsü shia jümüin süka tayamülüichipain Satanás chi sülaülashikai. Te'rüin nia nujutuuiwa'aya paala, maa aka saa'in shiyaa juya chajee iipünaajee eejachire nuluwataain paala. ");
INSERT INTO guc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Laülaainapa jia tatüma naa'u chi we'ipolokai. Jüyamüleechi nia. Ja'itaichi pülashin ma'i nia juulia, nnojoleena jia atuunajünüin nütüma. Meena aka jia naa'in wane wayuu eekai meimolüin sünain waraittaa sa'akapünaa maa'ala je ja'yulu. ");
INSERT INTO guc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nnojo talatüin ne'e jaa'in saa'u jüüjüüin tü yolujaakalüirua jümüin. Talata jia saa'u ayateenain jia nümaa Maleiwa süpüla ka'ikat süpüshua süchikijee ouktaa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Talataleesia ma'i naa'in joolu'u Jesús süka eein chi Naa'inkai Maleiwa nümaa. “Taataa, ta'waajüin pia, pia Aluwataashikai cha'aya iipünaa oo'ulaka ya'aya mmolu'u. Tü paa'inrüinjatkat, nnojotsü pii'iyatüin sümüin wayuu eekai kekiin saashin, pii'iyatüitpa namüin na wayuu kamaneekana pümüin. Talatüitpa ma'i paa'in sütüma tia”, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aashajaashi joo Jesús sümüin tü wayuukolüirua süpüshua: “Chi Tashikai Maleiwa, nüneeküin taya süpüla atüjawaa saa'u kasa süpüshua nütüma. Chi e'raajakai taya, nia ne'e chi Tashikai nümüiwa. Je chi e'raajakai chi Tashikai, taya ne'e oo'ulaka tü wayuukolüirua eekai tee'iyatüin nia sümüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nujununtaakalaka joo Jesús sünain naashajaain ne'e namüin na nikirajüinkana: “Anata'aleesüja'a ma'i tü wayuu eekai shi'rüin tü ji'rakat joo maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Soto jaa'in wane kasa. Wainma na nünüikimaajanakana Maleiwa je na sülaülashiikana mma paala sümaiwa eekai ne'reein ma'i tü kasa ji'rakat, eekai naapeein ma'i tü kasa jaapakat joolu'u, nnojotsü ne'rüin je nnojotsü naapüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Je so'u wane ka'i, antüshi wane wayuu no'utku na karalouktamaajanakana nünainmüin Jesús süpüla asakirayawaa nia shii'iree naapülijüinjachin nia nüsouktapa: —Ekirajüikalee, ¿kasa taa'inrüinjatka süpüla eeinjachin taya nümaa Maleiwa waneepia süchikijee ouktaa? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Asouktüshi Jesús: —Pi'raajüin ma'i tü nüshajalakat Moisés. ¿Kasa paa'inrüinjatka saashin? —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nüsouktakalaka chi wayuukai: —Tü taashaje'erakat, müsü mayaa: “Maleiwa, chi Pümaleiwasekai, anashi aire püpüla waneepia süka süpüshua paa'in. Anashi jülüjüle paa'in Maleiwa waneepia”. Je eesü wane'eya: “Anasü aire püpüla wayuu süpüshua maa aka alin pia püpülajiraa”, müsü sünüiki tü karalouktakat —nümakalaka chi wayuukai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Shia'aya ma'i tia. Lotüsü pünüiki. Anasü müleka paa'inrüle tia süpüshua süpüla eeinjachin pia nümaa Maleiwa waneepia süchikijee ouktaa —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Otta müshia chi wayuukai, sütüma isain nüchiki asouktaa ni'ipajee Jesús, nüsakirakalaka nüchikua: —Je sa'akajee tü wayuukolüirua süpüshua, ¿jaralii na aijanakana tapüla paajüin? ");
INSERT INTO guc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nüküjain joolu'u Jesús nüchiki wane wayuu nümüin süpüla nikirajüinjachin nia sünain alinjatüin wayuu süpüshua nüpüla: “Eeshi wane wayuu o'unüshi chajee Jerusalénjee chamüin cha'aya Jericómüin. Wanaakalaka nümaa wane wayuuirua ka'ruwarannuu sulu'u wopukot. Saakajüin nükorolo süpüshua sünain süshe'ejüin ma'i nia sünain su'una'alüin naa'in. Süpütüin nia ouktapünaain. ");
INSERT INTO guc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Shiasa süchikijee tia, nülatakalaka wane sacerdote judío sulu'upünaa tü wopukot eejachire chi wayuukai palastüin. Je ni'raiwa'aya nia, ayakalaashi waneepünaa sa'ata wopukot. ");
INSERT INTO guc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nülatakalaka joo wane wayu'uya nuu'uliwo'u Leví. Akaataaja chiija'a, ni'raiwa'aya wayuukai palastüin, ayakalaashi waneepünaa sa'ata wopukot. ");
INSERT INTO guc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Niweetaakalaka joo wane wayuu Samariaje'ewai, nnojoishi judíoin. Alu'ujasa chii, ni'raiwa'aya wayuukai palastüin sulu'u wopukot, nümüliajüin nia naa'inyaka. ");
INSERT INTO guc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nürütkaakalaka nünainmüin sümaa nüshorotirüin seita oo'ulaka wiino saa'u tü nülio'ukot, sünain nüko'oyolüin shia süka kuluulu. No'otokalaka chi mayeinshikai saa'u ne'ejena sünain nüntirüin nia sulu'umüin wane atunkülee süpüla naa'inmajüinjachin nia cha'aya. ");
INSERT INTO guc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Je mapa watta'amüin süpülapünaa nu'unüin, naapakalaka wane neerü piamasü kanüliasü ‘denario’ nümüin chi aa'inmajüikai tü atunküleekat, sünain nümüin nümüin: ‘Anuu tüü, taapüin pümüin. Jalia tapüla chi wayuukai. Jamale'ein müleka che'ojaale pümüin soo'omüin, pi'itaajeerü ne'e. Tawalaajeerü pümüin tale'ejapa’, nümakalaka nümüin”. ");
INSERT INTO guc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Asakinnüshi joo chi karalouktamaajachikai nütüma Jesús: —Na'akajee na apünüinshiikana wayuu, ¿jarai saa'in pümüin aika apüla chi wayuukai a'yaajünüshikai? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Nia chi amüliajakai chi wayuukai —nümakalaka nümüin Jesús. —Pu'una paa'inraiwa eekai müin aka tia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Shiasa mapa nu'unapa Jesús namaa na nikirajüinkana, nojuntapünaakalaka sulu'u wane pueulo eere kepiain wane wayuu kanüliasü Marta je wane shimiirua kanüliasü María süpüla ne'iyouin nia nepialu'u. Nikerotpa Jesús nepialu'umüin, ojoyolaasü María nümülatu'u sünain saapajüin tü nümakat sümüin. ");
INSERT INTO guc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Oo'ulaka Marta, yalasü sünain shapaain saa'in sünain aa'inraa wane kasa nüpüla chi ne'iyoukai. Sürütkaakalaka joo Marta nünainmüin Jesús sünain sümüin nümüin: —Senyotkalee, ¿nnojot cheje pi'rüin taya sünain a'yatawaa tamüiwa, nnojotkalaka püjütayaain tü temiiruakat sünain akaaliijaa taya? ");
INSERT INTO guc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Asouktüshi joo Jesús: —Tawala Marta, nnojo püshapataain aa'in saa'u tü pi'yataainkat. ");
INSERT INTO guc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tü kasa anakat süpüla paa'inraa, shia tü saa'inrakat María sünain jülüjain saa'in tü kasa anasü tekirajakat anain. Nnojotsü wanaain sümaa too'ule'eraa shia suulia saa'inrüin tüü —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Shiasa so'u wane ka'i, aashajaashi Jesús nümaa Maleiwa. Shiasa kettaapa tü nünüikikat, nümakalaka wane chi nikirajüinkai nümüin: —Senyotkalee, anashii pikirajüle waya sünain aashajawaa nümaa Maleiwa maa aka nikirajüin Juan na nikirajüinkana —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nümakalaka Jesús namüin: —Meena jia jüchuntapa nümüin Maleiwa: “Taata Maleiwa, kojutshaatashi pia watüma. Kasataalejese kojutüin pia sütüma wayuu süpüshua. Kasataalejese püntüin maalü wa'akamüin sünain aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Anakaja müleka paapawaire wamüin weküin süpüla wane'ewai ka'i. ");
INSERT INTO guc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anakaja motüle paa'in tü waainjalakat, maa aka wayakana sünain motüin waa'in süma'üla eekai süma'ülapalain waya. Je nnojo piyüülajüin waya süpüla oo'ulakünaa aa'in”. Shia jüchuntiainjatka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aashajaashi Jesús joolu'u namüin nüchikua'a: “¿Kaseerü alataka müleka pu'unüle eemüin wane wayuu pa'aleewain sünain achuntaa naa'u süse'eru'upünaa ai pümataalai nümüin yaa: ‘Tawa'irüin, anashi müleka pujuyaajirüle taya wane apünüinsü pan niküinjatü ");
INSERT INTO guc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wane tapüshi nii'iwa'aya antaa wattajee, akatsa nnojolüin eein wane kasa tasalijaain niyaalu'u’? ");
INSERT INTO guc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Eeshi süpüla nüsouktüin yala paülü'üjee sümaa nümüin: ‘Nnojo pike'ejüin taa'in. Eisalaaichipa taya je atunküshii na tachooinkana. Akulajaasü taa'in atamawaa süpüla taapüin pümüin wane kasa’, meechi nia pümüin. ");
INSERT INTO guc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ja'itaichi pütünajutüin nia, nnojoleerü naapüin saa'ujee pa'aleewain nia. Naapeerü tü che'ojaakat pümüin saa'ujee pike'ejüin ma'i naa'in süchiirua. ");
INSERT INTO guc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Anuu tü tamakat joolu'u jümüin: Anakaja müleka jüchuntüle nümüin Maleiwa waneepia süka süpüshua jaa'in. Maa aka wane wayuu nüchuntüle, aapüna amüinchi. Maa aka wane wayuu mekeerüle, nünta anainrü tü nüchajaakat achiki. Maa aka wane wayuu nütaletüle miicho'u, ajutanna apüleechi. ");
INSERT INTO guc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Jamüsü jukuaippa jiakana namüin jüchonnii? Maa aka nüchuntüle pümüin wane jime chi püchonkai, ¿paapeerü wane wüi nümüin? Nnojottaa. ");
INSERT INTO guc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jama müleka nüchuntüle wane kaliinashuku, ¿paapeerü wane je'yulu nümüin? Nnojottaa. ");
INSERT INTO guc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eereje'e ne'e wayuuin kaainjaraliin jia, atüjashii jia asülajaa kasa anasü namüin na jüchooinkana. Nialeeka chi Jüshikai Maleiwakai chakai iipünaa, alana'aleeshia ma'i sünain anamiain jümüin. Naapeechi chi Naa'inkai jümüin müleka jüchuntüle nümüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Shiasa so'u wane ka'i niyu'lüin Jesús wane yolujaa nuulia wane wayuu. Manüisai chi wayuukai paala sütüma tü yolujaakat. Kanüikalaka nia shiyu'nnapa nuulia. Otta tü wayuukolüirua eejatkat jutkatüin, awatüsü ma'i saa'in süka anaichipain nia shi'rüin. ");
INSERT INTO guc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eekalaka wane wayuuirua na'aka, müshii naya: “Chi kapülainkai atüma chira süpüla ayu'laa yolujaa, nia ne'e Beelzebú, chi sülaülashikai tü yolujaakalüirua süpüshua”, namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Otta sünüiki waneeirua süpüla noo'ulaküin naa'in Jesús: “Anashi paa'inrüle wane kasa anasü nütüjakat apüleerua Maleiwa nümüiwa, süpüla watüjaainjatüin paa'u sünain chaje'ewalin pia iipünaajee”, namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nütüjaapaja Jesús saa'u tü saashajaakat achiki naa'in na wayuukana, nümakalaka namüin: “Müleka sütkaajiraale wane wayuuirua, aja'lajaajiraweena naya. Je müleka sü'ülüjaale wane wayuu sümaa tü süpüshikat, pa'ünüüwaweerü. ");
INSERT INTO guc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pülashi taya nütüma Beelzebú chi sülaülashikai yolujaa jaashin. Akaajaa Satanás, müleka nujuittirüleje tü yolujaakalüirua sünain nütkaain sümaa, oo'ulaajeechi nia suulia aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Jalaje'ewat saa'in jümüin tü napülainkat na jikirajüinkana süpüla ayu'laa yolujaa? ¿Nütüma Beelzebú? Nnojo, ¿aashi müin? Nayeenaja nayakana ayaawataka saa'u jalaje'ewalüin tü tapülainkat. ");
INSERT INTO guc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saa'u tayu'lüin yolujaa sütüma nüpülain Maleiwa, jütüjaaitpaja aa'u sünain nu'ttüin chi Maleiwakai sünain aluwatawaa wayuu yaa mmalu'u. ");
INSERT INTO guc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nnojotsü süpüla su'luwajünüin nükorolo wane wayuu eekai katsüin, kachajaruutsere, oo'ulaka eein naa'in saa'u tü nükorolokot. ");
INSERT INTO guc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Alu'ujasa müleka nüntüle wane ka'ruwarai nünainmüin katsüinreein ma'i nuulia, ayamülüneechi chi wayuukai nütüma. Asünaaneerü tü nüchajaruutsekat najapulu'ujee. Je tü nükorolokot, alü'üjüneerü nüma'anajee sünain amüloulin nuulia. Akaajaa tayaka'iya. Süka tayamülüin chi Yolujaakai, tountüin tayu'lüin yolujaa. ");
INSERT INTO guc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Je chi wayuu ayouktajaakai tamaa, te'ipoloshi”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aashajaashi Jesús joolu'u namüin nüchikua, sünain nikirajüin naya soo'opünaa nüchiki chi nnojoikai ayouktajaain nümaa Satanás: “Wane yolujaa, süchikijee shiyu'nnüin nuulia wane wayuu, o'unüsü saainküin mmakat süpüla süchajaainjatüin süchiki eere maa'inyatuulin süpüla sheemeraain. Je müleka nnojorule süntüin sünain eeinjatüle sheemeraain, ‘Anasü tale'ejüle tachikua eejatüle paala taya’, meerü shia. ");
INSERT INTO guc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Je süntapa süchikua nünainmüin chi wayuukai ayu'nnakai oulia paala, sünta anainchi nia sünain nnojolüin eein Maleiwa sulu'u naa'in. ");
INSERT INTO guc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sükajee tia, süsaajale'einya joo akaratshisü yolujaairua soo'omüin, alana'aleekalia ma'i sünain mojulaain suulia. Ekerolaa müsia süpüshua nünain chi wayuukai. Müle'oleejeeria ma'i tü nümüliainkat suuliale'eya paala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Otta wanaa sümaa naashajaain Jesús namüin na wayuukana, a'waatüsü wane jierü yaa sa'akajee tü wayuukolüirua: —Anata'aleesüja'a ma'i tü wayuu kachonkat pia, tü epijakat pia —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Asouktüshi Jesús: —Naya müle'oka anaa amüin na aapakana nünüiki Maleiwa sünain noonooin sümaa —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sünain wattain ma'i saalin wayuu nünainmüin Jesús, müshi nia namüin: “Jia wayuu eekana maa'ulu yaa, jia kaainjaralii e'rüliikana ma'i wayumüin nümüin Maleiwa, achuntüshii jia taa'inrüin wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa süpüla jütüjaainjatüin taa'u sünain cheje'ewalin taya iipünaajee. Nnojoleena toonooin amaa jia. Shia soto jaa'in tü nüchikikat Jonás chi nünüikimaajachikai Maleiwa nümaiwa süpüla jütüjaainjatüin taa'u mapeena sünainjee sünain nüjünalain taya Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tü wayuukolüirua Níniveje'ewatkalüirua, sütüma tü alatakat nümüin Jonás, nayaawata aa'ulu sünain aluwataaushin nia nütüma Maleiwa. Müshi aka tayakai, chi Shipayakai Wayuu, sütüma tü alateetkat tamüin, jiyaawateerü aa'ulu sünain aluwataaushin taya nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Je soto jaa'in süchiki tü aluwataasükat paala sümaiwa sulu'u wane mma wattajatü chaa uuchimüin. Antüsü nünainmüin Salomón chi aluwataashikai sulu'u Israel wanaa sümaa tia, süpüla saapajüinjatüin nünüiki süka kekiin ma'i nia. Anuu tü tamakat jümüin: So'uweena nükalia chi Maleiwakai wanaa sümaa kasalajanainjatüin saainjala wayuu süpüshua nütüma, meerü jümüin tü wayuukot aluwataasükat: ‘Alana'aleesia ma'i nujut Jesús nuulia Salomón. ¿Jamüshii jia nnojoliika'a jaapajeein nünüiki?’. ");
INSERT INTO guc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Akaweenia na wayuukana Níniveje'ewaliikana so'uweena nükalia chi Maleiwakai wanaa sümaa kasalajanainjatüin saainjala wayuu süpüshua nütüma, meena jümüin: ‘Wayakana oonooshiinka sümaa tü nümakat Jonás wamüin sünain woo'ulaainjanain suulia waainjala. Otta müshia Jesús, alana'aleesia ma'i nujut nuulia Jonás. ¿Jamüshii jia nnojoliika'a joonooin sümaa nünüiki?’, meena naya jümüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aashajaashi joo Jesús nüchikua namüin na wayuukana: “¿Jalasü e'itaanüin wane luusa shipejaanüle? ¿E'itaanüsü cheje suupünaa wushu? Nnojo. E'itaanüsü eere süpülee luusa süpüla sünaküinjatüin kasa süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Otta tü wo'ukot, müsü aka saa'in suwarala luusa, süka we'rüin tü kasa wapüleeruakat sütüma. Müleka anale tü wo'ukot, we'rüin tü kasakat süpüshua sütüma. Akaajasa mo'upa'ale waya, müsatüsü tü mmapa'akat wo'ulu'u. Akaweeria müleka wulere tü jaa'inkat, jüüjüüjeena jia sünain aa'inraa tü anaakat. Otta müleka yarüttüle jaa'in, shieerü jaa'inraka tü mojusükat. ");
INSERT INTO guc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jalia jia suulia yarüttaa aa'in, suulia nnojolujayaa jaa'inrüin tü anaakat waneepia. ");
INSERT INTO guc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Müleka ayatüle wulein tü jaa'inkat sümaa jiyouktüin tü yarüttüsükat, jaa'inreerü tü anaakat waneepia sümüin wayuu”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Shiasa süchikijee naashajaain Jesús, eenajaanüshi nia nütüma wane fariseo süpüla ekaa nipialu'u. Nu'unakalaka Jesús sünainmüin tü ekawaakat. ");
INSERT INTO guc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nüponojoo amaat chi fariseokai, süka nnojolin nu'lojooin najapü Jesús süpülapünaa ekawaa, süka nakuaippain na judíokana tü o'lojowaakat ajapüü süpüleerua ekaa süpüla anainjanain naya nu'upala Maleiwa naashin. ");
INSERT INTO guc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aashajaashi joolu'u chi Senyotkai nümüin: “Jiakana keisalakana ma'i ne'e sümüin jiitain je jüpülaatse süpüla wuleinjatüin shia, nnojotkalajasa jiisalajüin jaa'in süpüla wuleinjatüin shia. Yarüttüsü ma'i, süka jülüjain jaa'in kasa mojulu'ut waneepia, maa aka kachiiruaa aa'in washirüü. ");
INSERT INTO guc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Maa'insalii jia, motokoloko jaa'in chi Maleiwakai sünain nükumalain kasakat süpüshua. Müleka ju'lojoole jajapü, anasü tia. Otta tü nüchekakat Maleiwa süpüleerua wulein waneepia, shia tü jaa'inkat. ");
INSERT INTO guc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Müleka kamaneere jia sünain jüsülajüin sümüin wayuu eekai müliain, atüjaaneena aa'u jia sünain wulein jaa'in. ");
INSERT INTO guc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sükajee kachekala'atain jia sümüin wayuu sümaa maalin Maleiwa jüpüla. Nnojoishii jia ta'ülüjüin amüin saaliijee jüsülajüin süpüshi ji'yataain nümüin Maleiwa, süka shiain tü nuluwataakat anain Moisés. Nnojoishii jia ta'ülüjüin amüin saaliijee jüsülajüin süpüshi süpana wunu'u eekai ekünaajuulin. Shia sünainjee nnojolüin jaa'inrüin süka süpüshua jaa'in tü alana'aleekat sünain anain, maa aka alin Maleiwa jüpüla je jaa'inrüin tü anakat sümüin wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain yaletayaain jaa'in su'upala wayuu. Keejiasü jümüin joyotoo na'ato'u na jülaülayuukana sulu'u tü ekirajüleekat, je kojuteeshii jia sütüma wayuu eepünaale jia. ");
INSERT INTO guc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“ ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain ja'alainpalain tü jikirajakat anain na wayuukana. Na aapakana jünüiki, naa'inrüin tü juu'ulakakat napüleerua, amüloui müshi'iya naya jütüma”, nümakalaka Jesús namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nümakalaka joo wane karalouktamaajachi: —Ekirajüikalee, tü pümakat namüin na fariseokana, aisü wamüin wayakanaya. ");
INSERT INTO guc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Asouktüshi Jesús namüin: —Jiakana karalouktamaajanakana, “Aisha'ajaa” meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain juluwataain tü wayuukolüirua sünain aa'inraa kasa kapüleesü sümaa nnojoliin eeyaain jükaaliijeein naya. ");
INSERT INTO guc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“ ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain kojutuyaain jütüma na nünüikimaajanakana Maleiwa paala sümaiwa. Jaainjirayaa atachii naya shii'iree ‘kojutuleeka ma'i naya natüma’ sümeein wayuu jümüin. Mayaainje jütüjaain naa'u na jutuushinuukana sünain nayain na o'utirakana naa'in na nünüikimaajanakana Maleiwa, nnojoyülia jiyouktajaain amaa tü naa'inrakat naka. ");
INSERT INTO guc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Müshi paala chi Maleiwakai kekiishikai ma'i: ‘Tajüteena wane tanüikimaajana oo'ulaka na Aluwataaushikana sa'akamüin tü tapüshikalüirua. O'utüneena aa'in waneeirua natüma, je wane, e'nneena amüin natüma saaliijee naküjain tanüiki’, müshi nia. ");
INSERT INTO guc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Otta tü kasa jaa'inreetkat naka na wayuukana tajütajanakana jünainmüin, kasalajaneerü jümüin maa'aya aka kasalajaneerüin namüin na jutuushinuukana tü kasa mojusü naa'inrakat namüin napüshuale'eya na wayuu lotokana akuaippa nu'upala Maleiwa o'utinnakana aa'in süchikijee sükumajünüin tü mmakat. ");
INSERT INTO guc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","O'ttüshii nüka Abel nünainmüinre'eya Zacarías, chi o'utünakai aa'in pasanain sünain tü a'ajüleekat sümaa tü a'waajüleekat. Jia wayuu katakana o'u maa'ulu yaa, shiimüin ma'i tü taküjaitpakat jümüin sünain kasalajaneerüin jümüin jaainjala, tü shikeraajiakat tü kasa mojusü no'ttakat anain na jutuushikanairua. ");
INSERT INTO guc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Jiakana karalouktamaajanakana, ‘Aisha'ajaa’ meena jia, süka kasalajaneerüin jümüin tü mojusü jaa'inrakat sünain junujulüin suulia wayuu süpüshuale'eya tü nikirajakat anain jia Maleiwa. Nnojotsü joonooin amaa nünüiki Maleiwa je jütuunajüin nakuaippa na eekana aa'inreein tü nuluwataakat anain”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Je nu'unapa Jesús süma'anajee tü wattakat saalii wayuu, a'ürülaashii ma'i na fariseokana oo'ulaka na karalouktamaajanakana nümüin. Nasakirayaain nia shii'iree nantüin sünain wane kasa aapünüinjatkat anainjee nikii. ");
INSERT INTO guc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Shiasa mapa, outkajaasü wayuu watta ma'i saalin sünain yentaajiraain. Süpülapünaa naashajaain Jesús namaa na wayuukana, aashajaashi nia palajana namaa na nikirajüinkana süpüla nachecherüinjatüin naa'in sünain tü nanoulakat: “Jalia jia majayaa aka naa'in na fariseokana piamakana akuaippa saa'u nnojoliin ayatüin natüma tü nekirajakat anain. Na wayuu ashatakana tü nakuaippakat, amülouishii naya sütüma. ");
INSERT INTO guc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Je maa'ulu yaa, saa'in namüin na wayuukana oonookana sümaa nanüiki na fariseokana, lotüsü saa'in namüin. Otta so'uweena wane ka'i, shiyaawateerü aa'u wayuu wainma sünain nnojolüin pansaain nanüiki. ");
INSERT INTO guc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tamüshii joo jia: Anakaja lotüle jünüiki waneepia. Ja'itairü jüküjüin sümüin wayuu palitchon, kanülieerü sütüma wayuu wainma müleka pansaale tü jünüikikat. Je müleka nnojorule pansaain jünüiki, ayaawatüneena jia sütüma wayuu sünain piamain jukuaippa, maa aka naa'in na fariseokana. ");
INSERT INTO guc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Tatünajutumuyuwaa: Nnojo mmolüin jia seema wayuu eekai su'uteein jaa'in. Müleka ju'utünüle aa'in, tü aja'tteetkat, shia ne'e tü ji'irukukat. Nnojoleerü kasain saa'inrüin tü wayuukolüirua jüka süchikijee. ");
INSERT INTO guc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Taküjeerü joo jümüin jaralin chi mmolüinjachin eema jia. Anakaja niale mmolüin eema jia Maleiwa, nia kapülainka nümüiwa süpüla nu'unirüin jia Hadesmüin eemüin süpülee tü ouktüsükalüirua. Anakaja niale mmoluukain eema. ");
INSERT INTO guc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nnojo motüin jaa'in sünain naa'inmajüin jia Maleiwa waneepia. Eesü süpüla süikkünüin ja'raisü wuchii saa'u piama neerü kachueerachen ne'e, ¿aashi müin? Otta tü wuchiikalüirua süpüshua, nnojotsü juunasüin nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Müshii aka jiakana sünain nnojoliin oo'ulaanüin jümüiwa nütüma, süka alana'aleein ma'i jujut nümüin suuliale'eya tü wuchiikalüirua süpüshua. Je sükajee jaa'inmajünüin nütüma Maleiwa, nnojo mmolüin jia seema wayuu eekai su'uteein jaa'in. ");
INSERT INTO guc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Müshi taya, chi Shipayakai Wayuu, jümüin: Müleka ‘Anoujashii waya nünain Jesús’ jümüle su'upala wayuu, ‘Shiimüin sünain nanoujain tanain’, meechi taya jüchiki nümüin chi Tashikai Maleiwa chakai iipünaa. ‘Naya tapüshika'aya’, meechi taya jüchiki no'upala na aapieekana nümaajanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Alu'usa müleka juunjulajüle tachiki su'upala wayuu, ‘Nnojoishii te'raajüin naya’, meechi taya jüchiki no'upala na aapieekana. ");
INSERT INTO guc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja'itairü mojuin jünüiki tamüin tayakai, chi Shipayakai Wayuu, alatinneerü tia juulia nütüma Maleiwa. Akaajasa, müleka ji'rüliire wayumüin süka jünüiki nümüin chi Naa'inkai Maleiwa, nnojoleerü alatinnüin tia juulia. ");
INSERT INTO guc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Müleka ju'uninnüle eemüin na sülaülakana judío je chi sülaülashikai mma saalinjee jünoujain tanain, nnojo jüshapataain aa'in saa'u tü jüsouktüinjatkat aka namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Naapeerü jümüin chi Naa'inkai Maleiwa tü pütchi jüsouktüinjatkat aka wanaa sümaa tia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Je wane wayuu sa'akajee tü wayuukolüirua, müshi nümüin Jesús: —Ekirajüikalee, anashi müleka puluwataale nümüin chi tepayakai süpüla naapüinjatüin tamüin süpüshi tü ni'ipünaakat chi washikai wapüla ouktaiwa'aya nia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nüsouktakalaka Jesús: —Nnojoishi e'itaanüin taya sünain pütchipü'üin süpüla pümüinjachin taya süchiirua tia —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nümakalaka joolu'u Jesús namüin na wayuukana napüshua: —Jalia jia suulia kachiiruaa aa'in tü washirüükat. Tü talateetkat atüma jaa'in, nnojolüinjatü shiain sükajee koo'omüin jümüin tü jükorolokot —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","O'ttüshi joo Jesús sünain ekirajaa naya süka sukuaippa tü kasa e'nnakat sainküin mma: “Eetaashi wane wayuu washirü. Wainma ma'i süchon tü nüpünajüinkat sulu'u niyüüjase. ");
INSERT INTO guc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","‘¿Jalayaai paala tanaajaain tü tapünajüinkat che'ojaapaja wane süpülajana eeinjatüle shia tanaajaain?’, ma müsü naa'in. ");
INSERT INTO guc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Nümakalaka joo chi wayuukai: ‘Aa, tatüjaaitpa aa'u tü taa'inrüinjatkat. Tawasaje'ereerü miichikat tüü süpüla takumajirüin wane miichiirua eekai miyo'uin suulia, süpüla tanaajaainjatüin süpüshua takorolo je tü tapünajüinkat yaa sulu'u. ");
INSERT INTO guc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Je kettaapa tü miichikat, talateerü taa'in sünain maa: “Watta saalin korolo tama'ana joolu'u, tü tepijaajeetkat atüma süpüla wainma juya. Anakaja joolu'u teemeraale, sümaa tekaain, sümaa tasaain sümaa talataa aa'in”, meechi taya’, müshi chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Otta chi Maleiwakai, meechi nümüin: ‘Maa'inkaiche aa'in pia. So'u aikat tüü, anteerü ouktaa pümüin. ¿Jaraleerü saa'in pümüin makataka apüla tü pünaajaakat ma'i püpüla?’. ");
INSERT INTO guc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Anuu tü tamakat joo jümüin: Chi eekai kachiiruain aa'in tü washirüükat sümaa nnojolin nüchajaain nüchiki Maleiwa, nnojoleerü kasain anain apüla nümüin tü nuwashirüinkat ouktapa nia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Naashajaakalaka Jesús namüin na nikirajüinkana: “Nnojo jüshapataain aa'in saa'u tü jiküinjatkat katüinjatkat atüma jo'u, je saa'u tü kuluulu ja'atajatkat anainjatkat atüma jiyolojo. ");
INSERT INTO guc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tü talateetkat atüma jaa'in, nnojotsü shiain ne'e tü eküülü katüinjatkat atüma jo'u, nnojotsü shiain ne'e tü kuluulu anainjatkat atüma jiyolojo. ");
INSERT INTO guc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jülüja jaa'in sukuaippa tü wawaachikalüirua. Mapünajüinsat shia je manaajaalasat shia shiküin, nnojotpaja e'rüin jamü shia süka shikinnüin nütüma Maleiwa. Jialeeka jiakana, aa'inmajünüshii waneepia nütüma Maleiwa, süka alana'aleein jia sünain kojutüin nütüma suuliale'eya tü wuchiikalüirua. ");
INSERT INTO guc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Je tü shapawaakat aa'in, nnojoleerü kasain saapüin jümüin süpüla epijawaa. ");
INSERT INTO guc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nnojoleerü aapünüin jümüin tü jiküinjatkat oo'ulaka tü jüshe'injatkat sükajee. ");
INSERT INTO guc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Jülüja jaa'in sukuaippa tü süsiikat wüitüshii sünain anashantain ma'i tü süno'ukot. Mayaainje nnojolüin a'yataain je nnojolüin saainjüin süshe'in, alana'aleesia ma'i sünain anachonin shiyolojo suuliale'eya süno'u nüshe'in Salomón chi washitshaanakai sülaülashikai mma paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¿Jamüsü nnojotka'a jünoujain sünain jaa'inmajünüin nütüma Maleiwa? Tü süsiikat, anashaatasü ma'i süno'u nütüma Maleiwa, mayaasüje julumaatüin shia sümaa sa'ajünüin mapa. Müshi'iya jiakana, aa'inmajünüshii nütüma suuliale'eya tü süsiikalüirua wüitüshii. ");
INSERT INTO guc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Ashapataasü ma'i naa'in na manoujainsaliikana waneepia saa'u tü neküinjatkat oo'ulaka tü nasüinjatkat. Alu'ujasa jiakana, nnojo jüshapataain aa'in saa'u tia maa aka naa'in nayakana. Soto jaa'in sünain nütüjaain saa'u chi Jüshikai Maleiwa tü che'ojaakat jümüin je naa'inmajeena jia waneepia. ");
INSERT INTO guc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Müleka keejiale jümüin niainjachin chi Maleiwakai aluwataain jaa'u, aapüneerü jümüin süpüshua tü che'ojaakat jümüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Jiakana aa'inmajuushikana tatüma, mmolujayaa jia sheema ayüülajünaa tatüma. Soto jaa'in sünain nücheküin chi Jüshikai Maleiwa süpüleerua juluwataainjanain wanaa nümaa so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Anakaja müleka jüikküle süpüshi tü jükorolokot je tü jümü'ünüinkat süpüla jüsülajüinjatüin tü süliakat sümüin wayuu eekai che'ojaain sümüin. Müleka jükaaliijüle wayuu, naapeerü jümüin Maleiwa tü kasa anasü matüjainkat aja'ttaa, matüjainkat a'luwajünaa, matüjainkat ke'ewaa, süka nüma'anain shia Maleiwa chaa iipünaa. ");
INSERT INTO guc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Je sükajee tia, acheküsü jülüjain jaa'in tü kasa anasü chakat iipünaa aapünüinjatkat jümüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ekirajüshi joo Jesús süka sukuaippa tü kasa e'nnakat sainküin mma: “Eeshi wane wayuu o'unüshi sünain wane mi'iraa, shikiira ka'wayuusee. Nüpütüin na nüchepchiakana nipialu'u süpüla eeinjatüin naa'in nüpüla nüle'ejapa. Pejesü nashe'in na'ütpa'a süpüla na'anaamaatüinjatüin. Chuwatüsü natüma naramparase waneepia. Eesü ma'i naa'inrua nüpüla chi nalaamainkai süpüla neerulamaatüinjatüin tü so'ukot miichi nüpüleerua nüntapa. Anakaja müle aka jia naa'in na achepchiaakana sünain ja'atapüin taya so'u tü ka'i tale'ejüinjatkat o'u jünainmüin. ");
INSERT INTO guc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Eeshi süpüla tale'ejeechin süse'eru'upünaa ai je watta'achon maalü. Anakaja müleka keraajüle jia tapüla. Chi laamakai taküjakai achiki jümüin, süka eein naa'in na nüchepchiakana nüpüla, talataleesia ma'i naa'in namaa. Na'atakalaka süshe'in achepchiee nünain. Nüikkaajire'etkalaka na nüchepchiakana süpüla ekaa je niitajakalaka neküin. ");
INSERT INTO guc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Soto jaa'in wane kasa. Wane wayuu nipiajachi, müleka nütüjaaleje saa'u tü ka'i nüntajachikat o'u wane ka'ruwarai, nnojoireeja süpüla nutunküinjachin suulia nikerolüin chi ka'ruwaraikai. ");
INSERT INTO guc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Müinjanaya jiakana, anashii müleka keraajüle jia sümaa eein jaa'in tapüla tayakai, chi Shipayakai Wayuu, süka tale'ejüinjachin tachikua jünainmüin so'uweena wane ka'i matüjaajuukat aa'u jütüma”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nüsakirakalaka Pedro: —Senyotkalee, tü püküjaitpakat achiki wamüin, ¿püküjüin joo wamüin wamüiwa je sümüinjattaapa wayuu süpüshua? ");
INSERT INTO guc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Asouktüshi chi Senyotkai: “Na'akajee na achepchieekana taküjakana achiki, aneekünüshi wane aa'inmajüi, chi eekai kekiin ma'i, chi tütükai sünain tü aluwataanakat anain nia. Nia nekiipü'üinjachikai na waneeinnua süpüla ekiraa naya. ");
INSERT INTO guc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Je nüle'ejapa chi nülaamainkai, talateerü ma'i naa'in nümaa müleka ayatüle naa'inrüin süpüshua tü ni'itaakat nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Shiimüin tü tamakat jümüin, e'itaaneechi nia nütüma chi nülaamainkai süpüla laülaain saa'u süpüshua'ale tü kasa eekat nüma'ana. ");
INSERT INTO guc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“¿Jama müleka nnojorule jüüjüüin nia sümüin nünüiki chi nülaamainkai, müleka ‘Nnojoleechi antamaatüin chi talaamaainkai nüchikua’ nümataarüle ne'e sünain emi'ijawaa oo'ulaka sünain eperuwawaa je sünain ni'yaajüin na achepchieekana wanaa nümaa, na tooloyuukana otta na jieyuukana? ");
INSERT INTO guc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Antalaa meechia chi nülaamainkai so'u wane ka'i nnojotkat na'atapüin o'u nia. Süsala meechia nia nütüma. Ni'ikajaajeechi nia na'akamüin na eekai ne'rüliin wayumüin namüin nalaamain eere ne'rüin müliaa napüshua. ");
INSERT INTO guc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“Chi wayuu eekai nütüjaain saa'u tü nüchekakat chi Maleiwakai nüpüleerua, anakaja müleka naa'inrüle waneepia tia. Je chi aapünakai amüin kasa wainma süpüla ni'yataainjachin nümüin Maleiwa, acheküshi naa'inrüin süpüshua tü e'itaanakat nüpüla. Jiakana judíokana nüchepchiakana Maleiwa, atüjaakana saa'u tü nuluwataakat anain, müleka nnojorule jaa'inrüin tü nüchekakat jüpüleerua je nnojorule eein jaa'in sünain tü ka'i tale'ejüinjatkat o'u, mülieena ma'i jia nütüma Maleiwa süsalajee tia. Akaajasa wane wayuu eekai nnojolin nütüjaain saa'u tü nuluwataakat anain Maleiwa, müleka kaainjarale nia, jiyatteerü tü nümüliainkat süsalajee tia”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Nüküjakalaka Jesús namüin na nikirajüinkana süchiki tü alatüinjatkat namüin na eekai nanoujain nünain: “Yapashi taya süpüla ouktaa sünainjee tayouktünüin sütüma wayuu wainma. Te'rüin tamüliala wanaa sümaa ta'atapüin tü takaliakat süpüla ouktaa wane'ere'eya suu'ulaain toulia kettaapa takalia. Kasataalejese su'ttüin maalü tü takaliakat. Je jiakana anoujashiikana tanain, ayouktüneena jiakanaya wanaa tamaa. ");
INSERT INTO guc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Aluwataaushi taya, saa'in jümüin, süpüla achiajawaa wayuu atkaasü yaa mmalu'u? Nnojoishi süpülajachin taya tia. Süpülajachi mojujiraainjatüin wayuu tatüma saaliijee tü taa'inrakat je tü tekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Süchikijee ka'ikat tüü, ne'ipoleena na anoujashiikana tanain na manoujainsaliikana. Sulu'u wane miichi eere eein wayuu maa aka ja'rai, a'ülüjeena na apünüinshiikana namüin na piamashiikana, je na piamashiikana namüin na apünüinshiikana. ");
INSERT INTO guc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A'ülüjeechi wane wayuu nümüin chi nüchonkai je chi nüchonkai nümüin chi nüshikai. A'ülüjeerü wane wayuu sümüin tü süchonkot je tü süchonkot sümüin tü shiikat. A'ülüjeerü wane wayuu sümüin tü sa'ütkat je tü sa'ütkat sümüin tü niikat chi su'wayuusekai”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nümakalaka joo Jesús sümüin tü wayuukolüirua wattakat saalin sünain nüchiajaain naya: “Jiakana, müleka ji'rüle sükojojooin tü sirumakat wopujeekana, ‘Jalia, a'iteesü juya’, mamaatüshii jia. Shiimüin sünain sü'iteerüin. ");
INSERT INTO guc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Otta müleka ji'rüle tü jouktaikat sünain suwataain, ‘Jouktale'olujana waya’, müshii jia. Shiimüin sünain saja'lajaain juya sütümajee tia. ");
INSERT INTO guc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jiakana piamakana o'upünaa, kayaawaseshii jia sümüin tü jouktaikat oo'ulaka tü sirumakat, ¿jamüsü nnojotka'a jiyaawatüin saa'u kasain tü taa'inrakat maa'ulu yaa? ");
INSERT INTO guc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","59","“Jaapa tü tamüinjatkat joolu'u: Müleka kaainjarale pia nuulia wane puwala, acheküshi pütüjamaatüin pünüiki nümüin süpülapünaa nuluwataain wane pütchipü'ü pünainmüin suulia kojutajüin püpüleerua. Akaajaa jiakana, jiyaawata jumaala saa'u sünain che'ojaain jümüin anajiraain jia joolu'u nümaa Maleiwa”, nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Arütkaasü joolu'u wane wayuuirua nünainmüin Jesús süpüla naküjain nümüin süchiki wane wayuuirua judío Galileaje'ewalii na o'utünakana aa'in. Wanaa sümaa naapüin tü namü'ünüinkat nümüin Maleiwa süpüla ouktaa saa'u naainjala, o'utüna aa'inchii naya nütüma Pilato, chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nümakalaka Jesús: “Saa'in jümüin, ¿ouktüshii naya süka alana'aleein naainjala noulia na waneeirua? ");
INSERT INTO guc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nnojotsü sükajeein tia. Kaainjalasü wayuu süpüshua. Tamüshii paala jia: Müleka nnojorule jiyaawajaain suulia jaainjala, amülouleenia ne'e jia waneepia maa aka amüloulin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Je soto jaa'in na wayuu polookana mekiisalümüin sujuttakana aa'u tü ‘torre’ kanüliakat Siloé. Saa'in jümüin, ¿ouktüshii naya süka alana'aleein naainjala noulia na waneeirua chakana Jerusalén? ");
INSERT INTO guc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nnojotsü sükajeein tia. Kaainjalasü wayuu süpüshua. Tamüshii paala jia tachikua: Müleka nnojorule jükatalaain suulia jaainjala, amülouleenia ne'e jia waneepia maa aka amüloulin na wayuukana”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ekirajüshi joo Jesús süka sukuaippa tü kasa e'nnakat sainküin mma. Nümüsü pütchikat tüü sümüin tü wayuu nnojoyütkalia akatalaain suulia saainjala: “Eesü wane wunu'u kanüliasü ‘higuera’ apünajuushi sulu'u niyüüjase wane wayuu. Je so'u wane ka'i, antüshi chi wayuu kayüüjaseshikai süpüla asü'ütaa süchon tü wunu'ukot. Machonkalaka shia nüpüla. ");
INSERT INTO guc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nümakalaka joo nümüin chi aa'inmajüikai tü niyüüjasekat: ‘Apünüinchi taya juya sünain tantawalin yaamüin shii'iree asü'ütaa süchon tü wunu'ukot. Machonsot shia waneepia. Anakaja müleka püshottüle shia süpüla püpünajüin wane wunu'u jeket shii'iraka’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nüsouktakalaka joolu'u chi aa'inmajüikai saa'u: ‘Waa'iraa, anasü müleka woo'ulaale paala shia süpüla wane juya. Tapoteerü ekiiru'upünaa süpüla tejitüin kaa'ulacha'a kama'a aneerüle sütüma. ");
INSERT INTO guc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Müleka kachonle shia, woo'ulaajeerü. Akaajasa nnojorule, washotteerü’, nümakalaka chi aa'inmajüikai”. ");
INSERT INTO guc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ekirajüshi Jesús sulu'u wane ekirajülee so'u tü ka'i neemeraakat o'u na judíokana. ");
INSERT INTO guc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Shiasa'a sulu'u tü ekirajüleekat, eejatü wane wayuu ayuuisü poloo mekiisalümüin juya. Jokotüsü shia sünain waraittaa süka yolujaasirüin shia. ");
INSERT INTO guc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Shiasa ni'rapa Jesús tü wayuukot, neenajakalaka shia nünainmüin sünain nümüin sümüin: —Maachee, anaitpa joo pia suulia tü ayuuliikat. Ni'itaakalaka najapü saa'u. Lotoloo müsüja tü wayuukot sünain waraittaa sümaa su'waajüin ma'i Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Otta chi laülaashikai sulu'u tü ekirajüleekat, jashichishi ma'i nia nümüin Jesús süka anain nütüma wane wayuu so'u tü nakaliakat sünain eemerawaa. Nümakalaka chi laülaashikai sümüin tü wayuu eejatkalüirua: —Eesü aippirua ka'i wa'yataainjatkat o'u. Acheküsü antaa wayuu süpüla eiyajünaa so'u ka'ikalüirua tia. Nnojotsü anain jüntüle so'u tü ka'i weemeraakat o'u, süka shiain a'yatawaa tü eiyajünaakat. ");
INSERT INTO guc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nüsouktakalaka chi Senyotkai nümüin: —Piakai, piamakai o'upünaa, ¿kasa paa'inraka so'u tü ka'i weemeraakat o'u? ¿Nnojotsüjasa ji'yataain sünain taashin pütüma püpüliise sümaa püsachirat süpüla asaa wüin so'u sükalia tü eemerawaakat? ");
INSERT INTO guc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Shialeeka tü nuu'uliwo'ukot Abraham polooitkat mekiisalümüin juya sünain kapüü nütüma Satanás süka wane ayuulii, ¿anasüche waapüle taashii sümüin suulia tü ayuuliikat mayaainje sükaliain tü eemerawaakat? —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Japüisü tü nü'ünüükalüirua Jesús sütüma tü nümakat nümüin chi laülaashikai. Otta tü wayuu eejatkalüirua, talatüsü ma'i saa'in sütüma tü kasa naa'inrakat, süka anashaatain ma'i shia. ");
INSERT INTO guc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nüsakirakalaka Jesús na wayuukana: “¿Jamüsü, saa'in jümüin, tü nukuaippakat Maleiwa sünain aluwatawaa? ");
INSERT INTO guc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa sü'ü tü ‘mostaza’ münakat. Mayaainje jo'uuchoin ma'i shia wanaa sümaa süpünajünüin, miyo'u tü suu'uliakat süsotapa. Müsia nukuaippa Maleiwa sünain aluwatawaa. Mayaainje palitchoin wayuu anoujasü joolu'u, wainmeerü so'uweena wane ka'i”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nüsakirakalaka joo naya nachikua: “¿Jamüsü, saa'in jümüin, nukuaippa Maleiwa sünain aluwatawaa? ");
INSERT INTO guc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tü nuluwataayakat Maleiwa, müsü aka saa'in sukuaippa tü oolojiakat pan ejitünakat sütüma wane wayuu sa'aka jaliina. Mayaainje wainmain tü jaliinakat, oolojoosü süpüshua sütüma tü ejitünakat sa'aka. Müsia nukuaippa Maleiwa sünain aluwatawaa. Mayaainje palitchoin wayuu anoujasü joolu'u, wainmeerü so'uweena wane ka'i”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sünain nu'unüin Jesús Jerusalénmüin, ajuntawaishi sulu'upünaa tü pueulokalüirua wopulu'ukot süpüla nikirajüinjatüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nüsakinnakalaka nütüma wane wayuu: —Senyotkalee, ¿palitchon ne'e tü o'ttaasüjatkalüirua? Asouktüshi Jesús nümüin: ");
INSERT INTO guc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","—Chi eekai nnojolüin nünoujain tanain, nnojoleechi ountüin ekeroloo chamüin eere nuluwataain Maleiwa. Wainmeerü wayuu mekerolüinkat, mayaainje nekeroleein, süka nnojolüin shiimüin tü nanoulakat. Chi shiimüinkai sünain anoujaa, müshi aka saa'in wane wayuu eekai shikerolüin sulu'upünaa wane so'u miichi eekai moulin. Je jiakana, jalia jia suulia mekerotüinja. Nala wayuu eekai nnojolüin shiimüin sünain nanoujain, müshii aka naa'in wane wayuuirua antakana sa'wai süchukumüin süsürünnüin wane miichi, ja'itaina neenaküin chi nipiajachikai anooipa'ajee süka süpüshua naa'in: “Waa'iraa, peerula wapüleerua miicho'ukot”. Asoukta meechia nia namüin: “Nnojoliishii jia te'raajüin. Nnojoishii tatüjaain aa'u jalaje'ewaliin jia”. ");
INSERT INTO guc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Soto paa'in. Ekaapü'üshii waya pümaa, asaapü'üshii waya pümaa, je waapapü'üin tü pikirajakat anain waya sainküin mma”, meena naya nümüin. ");
INSERT INTO guc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Jiakana kaainjaraliikana, ju'una yaajee toulia. Nnojoliishii jia te'raajüin. Nnojoishii tatüjaain aa'u jaleje'ewaliin jia”, meechi nia namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Meena na manoujainsaliikana so'uweena wane ka'i sünain na'yalajüin ma'i saaliijee mekerotirujuin chamüin eere nuluwataain Maleiwa. Ne'reena ne'e wattajee Abraham nümaa Maleiwa chaa eere nuluwataain, oo'ulaka Isaac, je Jacobo, oo'ulaka na nünüikimaajanakana Maleiwa napüshua. Mojeerü ma'i naa'in, süka nnojoliin nountüin nekerotüin süpüla eeinjanain naya cha'aya namaa. ");
INSERT INTO guc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","¿Jaralii na ekeroleenakana nünainmüin Maleiwa eere nuluwataain? Nayeena na shiimüinkana sünain anoujaa, na chaje'ewaliikana wiinnaajee, waapünaajee, palaapünaajee, oo'ulaka uuchijee. Ekeroleena napüshua chamüin süpüla eeinjanain naya nümaa Maleiwa sünainmüin wane ekawaa miyo'u eenakünakat apüla naya. ");
INSERT INTO guc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ja'itaina joolu'u maa'ulu yaa mojutüin na anoujashiikana sütüma wayuu, ekeroleena naya nüma'anamüin Maleiwa so'u ka'ikat tia. Akaajasa na manoujainsaliikana, mayaashiije kojutüin naya sütüma wayuu maa'ulu yaa, nnojoleena kasajanain nümüin Maleiwa so'u ka'ikat tia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wanaa sümaa tia, antüshii joo wane na fariseokana nünainmüin Jesús süpüla maa nümüin: —Nu'utee aa'inchi pia Herodes, chi sülaülakai mma. Acheküshi pu'unamaatüin yaajee yaa nuulia —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Nüsouktakalaka Jesús namüin: —Ju'una jümaiwa nümüin chi e'rüliyaakai aa'in wayumüin sünain isayüliain apünüin ka'i ne'e süpüla taa'inrüin süpüshua tü aneekünakat apüla taya. Ayateechi taya joolu'u sünain tojuittirüin yolujaa je sünain teiyajüin wayuu. Nnojoishi taya oo'ulaainjachin suulia wane'ere'eya keraain süpüshua tü aluwataanakat anain taya. Tatüjaa aa'ut sünain tanteechin Jerusalénmüin, süka nnojolin süpüla ouktajachin wane nünüikimaajachi Maleiwa, maa aka taya, sa'atalu'u Jerusalén —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jülüjakalaka naa'in Jesús tü wayuukolüirua eekat sulu'u Jerusalén sünain nümüin mayaa: “Aituala ma'i jia wayuu Jerusalénje'ewaliikana, jia o'utakana naa'in süka ipa na nünüikimaajanakana Maleiwa aluwataaushikana jünainmüin. Kee'ireepü'üsü ma'i taa'in taa'inmajüin jia, maa aka saa'inmajüin süchon wane kaliina. Otta jiakana, jiyouktajaa amaalü tia. ");
INSERT INTO guc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sükajee tia, nnojoliinapa kasajanain jia nümüin Maleiwa. Müshi taya joolu'u jümüin jia manoujainsaliikana tanain: Nnojoleechi taya ji'rüin tachikua wane'ere'eya jümaleepa tamüin: ‘Anata'aleeshija'a ma'i chi Nüjünalakai Maleiwa’ ”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","So'u tü ka'i neemeraakat o'u na judíokana, eenajinnüshi Jesús sünain wane ekawaa nipialu'umüin wane wayuu fariseo kojutkai sütüma wayuu. Je cha'aya, eeshii na nü'ünüükana Jesús nüpüla süpüla natüjaain naa'u müleka niiyajüle so'u tü ka'i eemeraanakat o'u. ");
INSERT INTO guc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Shiasa eekalaka wane wayuu ayuuishi nüpüla Jesús. Shütüsü ma'i nütüna otta nüsa'a. ");
INSERT INTO guc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nüsakirakalaka joo Jesús na fariseokana je na karalouktamaajanakana ekaakana nümaa: —Naashin Moisés, ¿anasü eiyajaa wayuu so'u süka'iya tü eemerawaakat, nnojottaapa anain shia? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nayasa na wayuukana, ko'utakalaka naya. Neenakakalaka joolu'u Jesús chi ayuuishikai nünainmüin süpüla niiyajüinjachin nia. Nüjütakalaka nia süchikijee. ");
INSERT INTO guc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nüsakirakalaka joo Jesús na wayuukana: —¿Jameerü müleka sujutuule wane jüpüliise sulu'u wane ishi sükalio'u tü eemerawaakat? ¿Je müleka shiale ojutuuin jüsachiratse? ¿Nnojoleerü jiyu'lamaatüin ja'itainje sükalio'uin eemerawaa? —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Otta na wayuukana, ko'uko'utshii naya, süka isain nachiki nasouktiajatkat. ");
INSERT INTO guc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ni'rapa Jesús na wayuukana antakana sünain tü ekawaakat sünain naikkaajaain peje nünain chi eenajitkai naya shii'iree kojuteein naya sütüma wayuu, nikirajakalaka naya süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia namüin: ");
INSERT INTO guc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Müleka peenajinnüle sünain shikiira wane ka'wayuusee, nnojo püikkalaain yaa peje nünain chi ka'wayuuseshikai shii'iree kojuteein pia sütüma wayuu. ¿Jameechi müleka nüntüle wane wayuu püchiiruajee eekai kojutüin ma'i sütüma wayuu puulia? ");
INSERT INTO guc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","‘Anakaja müleka püsünnaale nüpüleerua’, müneechi pia nütüma chi eenajitkai pia. Japüi meechia pia süka asha'wale'ennaa sa'aka wayuu eekai yaain shi'rajüsüin ne'e tü ekawaakat. ");
INSERT INTO guc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Shia anaka alu'u, püikkalaale palajana sa'aka tü e'rajaasükalüirua ne'e. Arütkaa meechia pünainmüin chi eenajitkai pia sünain nümüin pümüin: ‘Wa'lee, jalaichi püikkalaaiwa yaa nü'ütpa'a chi ka'wayuuseshikai’. Kojuteechikalaka pia sütüma süpüshua tü ekaasükalüirua sükajee tia. ");
INSERT INTO guc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Soto jaa'in wane kasa. Chi eekai kee'ireein naa'in kojuteein sütüma wayuu, nnojoleechi kojutüin. Japüleechi ne'e. Alu'usa chi eekai nnojolin müliain naa'in shii'iree kojutaa, nieechi kojutka'aya”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Naashajaakalaka joolu'u Jesús nümüin chi wayuukai eenajitshikai: “Müleka peenajirüle wayuu süpüla ekawaa pipialu'u, nnojo peenajirüin na püpüshikana ne'e namüiwa, na pütünajutumuyuukana ne'e oo'ulaka na wayuu washinnuukana kepiakana pü'ütpa'a ne'e, süka ke'icheerüin pümüin natüma tü ekawaakat paala pipialu'u. ");
INSERT INTO guc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naya peenajira na mojushiikana, na matünasaliikana, na eekai masa'ain, je na eekai mo'uin. ");
INSERT INTO guc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Anata'aleejeechija'a ma'i pia sükajee tia, ja'itaina nnojolüin ke'ichin pümüin natüma. Nia Maleiwa awalaajüneechika atüma pia so'uweena tü ka'i naso'iraweetkat o'u aa'in na wayuu anashiikana no'ulu'u”, nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Je shiasa sütüma tü nümakat Jesús, nüsouktakalaka waneeshia chi ekaashikai nümaa: —Anata'aleejeechija'a ma'i chi wayuu eekai neenajinneechin sünain tü ekawaakat chamüin eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nikirajakalaka joolu'u Jesús na wayuukana süka sukuaippa tü kasa e'nnakat sainküin mma, süpüla nii'iyatüinjatüin namüin jaralüinjatüin nümaain Maleiwa chamüin eere nuluwataain. Müshi nia namüin: “Eetaashi wane wayuu. Neenajitkalaka wainma wayuu nipialu'umüin süpüla wane ekawaa miyo'u so'u wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Je kettaapa tü eküütkat, nüjütakalaka waneeshia chi nipiuunasekai nanainmüin na eenajiruushikana paala: ‘Jalaina jümaala, kettaaitpa tü eküütkat jüpüla’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nayasa'a na eenajiruushikana napüshua, oo'ulaayaa müshii naya suulia o'unaa. ‘Ayalajüichipa taya wane yüüja. Chawaika'a taya analaain sümüin, makatajachikalaka taya suulia o'unaa sünainmüin tia ekawaakat’, müshi wane. ");
INSERT INTO guc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Je nünüiki wane: ‘Ayalajüichipa taya wane paa'a poloosü. Chawaika'a taya eki'rajüin shia. Mo'unüinyeechi taya sünainmüin tia ekawaakat’, müshi nia. ");
INSERT INTO guc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Je nünüiki chi wane: ‘Isaitpa tachiki o'unaa süka ka'wayuuseichipain ne'e taya’. ");
INSERT INTO guc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nüle'ejakalaka chi nipiuunasekai süpüla nüküjain nümüin chi nülaamainkai süchiki tü wayuukolüirua sünain mantüinjanain naya. Naashichijaakalaka ma'i joo chi nipiajachikai sütüma tia. ‘Pu'una pümata sainküin miichi je chaa metkaaralu'upünaa süpüla shiain peenajüin tü mojusükalüirua. Peenaja wayuu eekai matünain, eekai mo'uin je eekai masa'ain’, nümakalaka nümüin chi nipiuunasekai. ");
INSERT INTO guc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Je nüle'ejapa chi nipiuunasekai, ‘Aluwataashikalee, taa'inrüitpa tü puluwataakat anain taya. Otta tü pipiakat, nnojolüyülia shia wotüin’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Asouktüshi joolu'u chi nülaamainkai: ‘Pu'una pümata joolu'u sulu'upünaa tü wopukot süpüshua, sainküin mmakat süpüshua, süpüla pükotchajüin wayuu eekai eein ne'e süpüla wotüinjatüin tü tepiakat sütüma. ");
INSERT INTO guc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Akaajaa tü wayuu eenajinnakalüirua paala tatüma, nnojoleerü pikerotirüin shia sünain tü ekawaakat yaa tepialu'u saa'u mantüinyeein paala naya’, müshi nümüin chi nipiuunasekai”. Kettaasü nünüiki Jesús sünain nikirajüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nu'unakalaka joo Jesús sünain eein wayuu watta saalin nümaa. Nujununtaakalaka joo süpüla aashajawaa sümaa tü wayuukolüirua sünain maa namüin: ");
INSERT INTO guc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wane wayuu eekai ni'itaain naa'in sünain anoujaa tanain, müleka niyouktüle müliaa je ouktaa taa'ujee, mojushiisü süpüla tekirajüüin nia. Süka jamüin, wane tekirajüin, alinjachi taya nüpüla süka süpüshua naa'in nouliale'eya nüshi, nii, nu'wayuuse, nüchooin oo'ulaka na nuwalayuukana. Meena aka maalinkai naya nüpüla saa'u tayain alin ma'i nüpüla. ");
INSERT INTO guc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chi wayuu eekai niyouktalaa nümüin taya ni'rapa müliaa sümaa mmoluu sheema o'utinnaa aa'in tanainjee, nnojoishi wanaain sümaa niainjachin wane tekirajüin. ");
INSERT INTO guc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“¿Jameechi pia müleka pükumajeere wane miichi eekai anashaatain ma'i? Acheküsü jülüjain paa'in palajana sünain jerainjatüin sujuittakat aa'u tü miichikat, suulia saja'laja'alaain pünneetse süpülapünaa kettaain shia, ");
INSERT INTO guc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","suulia shiajüin eein ne'e tü süpülajanakat miichi sümüiwa. ‘Isasü nüchiki keraainjatüin nütüma tü miichikat o'ttakat paala’, ma meeria tü wayuukolüirua pümüin sünain shime'erainpalain pia. ");
INSERT INTO guc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Saa'in pümüin, wane sülaülashikai mma kama'anakai ne'e 10.000 surulaat, ¿eeshi süpüla nujuittüin sünain atkawaa nümaa chi nü'ünüü kama'anakai 20.000 surulaat? Acheküsü jülüjain naa'in palajana müleka nükanajeechire chi nü'ünüükai. ");
INSERT INTO guc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Müleka niyaawatüle saa'u sünain nnojoleechin nükanajüin, acheküshi nuluwataainjachin wane wayuu anülieein süpüla achuntaa anaawaa nnojoliiwa'aya nüntüin chi nü'ünüükai nünainmüin süpüla atkawaa. ");
INSERT INTO guc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aka'aya jukuaippa jiakana wane'ewaire jukua: Acheküsü jülüjain jaa'in palajana tü nüchekakat jüpüleerua Maleiwa. Müleka nnojoliire yapain jia süpüla jaawalüin süpüshua tü juwashirüinkat süpüleerua a'yatawaa tamüin, je müleka nnojoliire yapain jia süpüla müliaa je süpüla ouktaa taa'ujee, mojushiisü süpüla tekirajüüin jia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nikirajakalaka joo Jesús nüchikua süka sukuaippa tü kasa e'nnakat sainküin mma: “Anasü ma'i tü ichiikat süpüla e'ichiijaayaa. Otta müleka me'ejüle, nnojoleerü kasain saamüin sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ojotünüsü ne'e anouipa'a süka nnojolüin anain süpüla ekünaa je süpüla shiküin mürüt. Akaajaa chi wayuu eekai nnojolüin noonooin sümaa tanüiki, nnojoleerü kasain naamüin tamüin. Chi eekai nüshateein tanüiki, anasü müleka jülüjüle naa'in”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Je so'u wane ka'i, arütkaashii wane wayuuirua nünainmüin Jesús süpüla aapajaa nünüiki, na kaainjaraliikana naashin na fariseokana, maa aka na okotchajüliikana neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Otta na fariseokana oo'ulaka na karalouktamaajanakana, ejejeraashii naya sünain namüin: —Atak, mojusü naa'inrakat chira wayuukai. Kamaneeshi namüin na kaainjaraliikana otta ekaashi joo nia nama'aya —müshii naya. ");
INSERT INTO guc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Otta Jesús, süka nütüjaain saa'u tü jülüjakat naa'in, nikirajakalaka na wayuukana süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia namüin: ");
INSERT INTO guc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Jarai wayuu yaa ja'akajee, müleka kamü'ünüinre nia poloo shikii anneerü je machikitaarüle waneesia sünainjee, nüpüteerü tü süpüshikat, tü mekietsatkat shikii mekietsalümüin, chaa süpa'a tü anooikat süpüla o'unaa sünain achajawaa süchiki tü machikisatkat, je wane'ereein nuu'ulaain suulia achajawaa nüntapa sünain? ");
INSERT INTO guc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Je nüntapa sünain, ni'itaain shia nünulo'upünaa sünain talatüin ma'i naa'in. ");
INSERT INTO guc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Je nüntapa nipialu'umüin, neenakeerü tü nütünajutumuyuukalüirua oo'ulaka tü wayuukolüirua kepiasükat nü'ütpünaa, sünain maa namüin: ‘Talata jaa'in wanaa tamaa, süka ja'yaitpain wane ta'anneetse machikisat paala’. ");
INSERT INTO guc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tamüshii paala jia: Aka'aya na aapieekana chaa iipünaa, talatüshii ma'i naya nümaa wane wayuu kaainjarai, maa aka na yaakana tamaa, müleka nükatalaale suulia naainjala. Talatüshii ma'i naya nümaa suuliale'eya sümaa mekietsatkat shikii mekietsalümüin wayuu eekai müin aka jiakana fariseokana, jia nnojoliikana mojuin aa'in saalin jaainjala saa'u anashiin jia no'ulu'u Maleiwa jaajüin”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ayatshi Jesús sünain ekirajaa sünain maa namüin: “Müinka eere wane jierü yaa ja'aka, müleka kanneetsere shia poloo ‘dracma’, machikitaarüle suulia wane ‘dracma’, nnojotsü süpüla suu'ulaainjatüin shia. Acheküsü süpüla süchuwajaainjatüin süramparase süpüla süchajaamaatüin süchiki süka wane awareejia süpa'apünaa tü shipiakat süpürale'e suu'ulaain süntapa sünain. ");
INSERT INTO guc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Je süntapa sünain, seenakeerü tü sütünajutumuyuukalüirua oo'ulaka tü wayuukolüirua kepiasükat sü'ütpünaa sünain maa namüin: ‘Talata jaa'in wanaa tamaa süka ja'yaitpain wane tanneetse machikisat paala’. ");
INSERT INTO guc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tamüshii paala jia: Aka'aya na aapieekana chaa iipünaa, talatüshii ma'i naya nümaa wane wayuu kaainjarai müleka nuu'ulaale suulia naainjala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ayatshi Jesús sünain ekirajaa sünain maa namüin: “Eetaashi wane wayuu oo'ulaka piamashii nüchooin tooloyuu nümaa. ");
INSERT INTO guc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","So'u wane ka'i, naashajaataalakalaka chi emülieekai nümaa chi nüshikai: ‘Taataa, paapa pümata tamüin joolu'u tü tapatseinjatkat pütüma’, nümakalaka nümüin. Otta chi nüshikai, naapa nümüsüja tü nükorolokot namüin na nüchooinkana wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Shiasa mapa tia, nu'unakalaka chi emülieekai sulu'umüin wane mma wattamüin sümaa süliapala tü kasa nüsülajakat chi nüshikai nümüin. Je nüntapa chamüin cha'aya, naja'ttirüin tü nünneetsekat süpüshua sünain tü kasa eekai nücheküin naa'inreein. Müshi aka maa'inkai naa'in sümaa. ");
INSERT INTO guc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Shiasa mapa wanaa sümaa saja'lajaain tü nünneetsekat nuulia, aisü ma'i jamü sümüin tü wayuukolüirua chakat kepiain cha'aya süka nnojolüin sü'itüin juya. Je chi jima'aikai, o'ttüshi nia sünain müliaa sütüma jamü. ");
INSERT INTO guc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nuchuntakalaka a'yatawaa nümüin wane wayuu chaje'ewai cha'aya sulu'u tia mmakat. Nuluwataanakalaka nütüma sünain ekajiraa tü nüpüülüksekalüirua. ");
INSERT INTO guc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aisü ma'i jamü nümüin süka nnojolüin saapünüin eküülü nümüin. Nikeetaa amüinrü joo tü su'lojooyakat, tü shikakat tü püülükkalüirua nütüma. ");
INSERT INTO guc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Niyaawajaakalaka joo aa'in chi jima'aikai mapa saalin ouktüin ma'i nia jamü. Müsü joolu'u naa'in: ‘Ouktajai cheje ne'e taya sütüma jamü, otta nipiuunaseirua tashi, emirashii ma'i naya waneepia. ");
INSERT INTO guc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Anainja tojuittüle yaajee tale'ejaiwa nünainmüin tashi tamaiwa nümüin: “Taataa, kaainjalashi taya nuulia chi Maleiwakai je puuliaya. ");
INSERT INTO guc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nnojoi mata müin aka taya wane püchon. Anakaja müleka pipiuunasere ne'e taya”, meechi’. ");
INSERT INTO guc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nu'unakalaka joo chaje'eya nünainmüin chi nüshikai. “Ni'rakalaka joo chi nüshikai nia nüpanapa seeiwa'aya ka'yatajee. Nuwataakalaka nüpanapa. Nuko'ojooin nünain je nüpesujüin nia süka nümüliajüin nia naa'inyaka. ");
INSERT INTO guc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nümakalaka chi jima'aikai: ‘Taataa, kaainjalashi taya nuulia chi Maleiwakai je puuliaya. Nnojoi mata müin aka taya wane püchon’. ");
INSERT INTO guc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Nümakalaka joo chi nüshikai namüin na nüchepchiakanairua: ‘Jüsaaja jümata tü tashe'in anashaatasükat ma'i süpüla ja'atüinjatüin nünain. Oo'ulaka wane tasüttiijase, ji'itaa sünain najapü. Oo'ulaka wane asapaatsee, ja'ata sünain nuu'ui. ");
INSERT INTO guc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Je jüsaaja jümata wane paa'achon eekai kaüsüin ju'utaiwa naa'in, wekaaiwa, wemi'ijaiwa naa'u chi tachonkai. ");
INSERT INTO guc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Paala nia, maa'awashi toulia, je joolu'u, ja'yaichipa’, nümakalaka. No'ttakalaka joo sünain emi'ijaa. ");
INSERT INTO guc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Otta chi nipayakai wanaa sümaa tü mi'iraakat, chashi nia a'yataain sulu'u tü niyüüjasekat. Je nüntapa miichipa'amüin, naapüin kaasha'ira saa'u tü yonnakat. ");
INSERT INTO guc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","‘¿Kasaajutü tü mi'iraakat?’, nümakalaka nümüin wane nüchepchia chi nüshikai. ");
INSERT INTO guc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Asouktüshi chi achepchiaakai nümüin: ‘Niaichi yalaka ale'ejüin chi pimüliakai chajee wattajee sünain katüin no'u. Otta chi püshikai, nu'utirüin naa'in wane paa'achon kaüsüshi süpüla nimi'ijirüinjachin naa'u’. ");
INSERT INTO guc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Naashichijaakalaka joo chi epayaakai sütüma tia. Niyoukta achikit ekeroloo sünainmüin tü mi'iraakat. Otta chi nüshikai, nujuittaakalaka joo nünainmüin süpüla nüchuntüin nümüin shii'iree nimi'ijiraweein namaa. ");
INSERT INTO guc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nüsouktakalaka joolu'u chi nüchonkai: ‘Pipiuunase aa'inchi ma'i taya sünain taa'inrüin waneepia süpüshua tü puluwataakat anain taya. Je nnojoishi aapüichin pia tamüin wane kaa'ulachonyaakaije'e ne'e süpüla temi'ijia namaa tatünajunnuu. ");
INSERT INTO guc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Shiasa joo naa'u chi püchonkai, aja'laje'etkai tü puwashirüinkat puulia sünain jieyuu maa'insat, pu'utirüin naa'in wane paa'achon kaüsüshi saa'u nüle'ejüin pünainmüin’. ");
INSERT INTO guc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Asouktüshi joo chi nüshikai: ‘Tachee, tamaashi pia waneepia. Je süpüshua'ale tü kasa tama'anakat, pükorolo piakai. ");
INSERT INTO guc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Otta joolu'u, emi'ijireeshii waya süka talatüin waa'in saa'u nüle'ejüichipain chi pimüliakai. Paala nia, maa'awashi toulia, je joolu'u, ja'yaichipa’, nümakalaka chi nüshikai nümüin”. Kettaasü nünüiki Jesús sünain nikirajüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ekirajüshi joo Jesús na nikirajüinkana süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia namüin: “Eejachi paala wane wayuu washirü oo'ulaka wane aa'inmajüi tü nuwashirüinkat. Je so'u wane ka'i, niyoojünakalaka achiki chi aa'inmajüikai sütüma wayuu nümüin chi nülaamainkai: ‘A'luwajünüsü tü puwashirüinkat nütüma’, müshii naya. ");
INSERT INTO guc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Neenakakalaka chi nülaamainkai chi aa'inmajüikai sümaa maa nümüin: ‘¿Jamüsü tü taapakat püchiki? Püküja pümata tamüin süchiki tü paa'inrakat süka tü tawashirüinkat. Too'ule'ereechi pia joolu'u suulia a'yatawaa tamüin’. ");
INSERT INTO guc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Shiasa mapa tia, naashaje'etkalaka naa'in chi aa'inmajüikai: ‘¿Kaseerü ta'yataaka anain süchikijee nuu'ule'erüin taya chi talaamainkai suulia a'yatawaa nümüin? Müleka ta'yataale sulu'u wane yüüja, aja'tteerü taa'in. Je müleka tojulijale, wane japülii tia. ");
INSERT INTO guc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ajüüsa'a paajüin, tatüjaaitpa aa'u tü taa'inrajatkat joolu'u süpüla takaaliijünüinjachin sütüma wayuu süchikijee too'ule'ennüin suulia tü ta'yataainkat’. ");
INSERT INTO guc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Neenakakalaka joo nünainmüin na wayuu kojuyaalakana nuulia chi nülaamainkai wane'ewai nakua. Nüsakirakalaka chi palajachikai: ‘¿Jera pujuyaala nuulia chi talaamainkai?’. ");
INSERT INTO guc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Asouktüshi nia: ‘Kojuyaalashi taya seita, maa aka poloo shikii laata nuulia’. Nümakalaka joo chi aa'inmajüikai nümüin: ‘Anuu tü karaloukta pujuyaalamaajatkat. Pii'irata pümata shia süpüla puwalaajüin ne'e ja'rai shikii laata nümüin’. ");
INSERT INTO guc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nüsakirakalaka chi wane'eya: ‘¿Jera pujuyaala piakai nuulia chi talaamainkai?’. Asouktüshi nia: ‘Kojuyaalashi taya maikki, maa aka poloo shikii toleeka nuulia’. Nümakalaka joo chi aa'inmajüikai nümüin: ‘Anuu tü karaloukta pujuyaalamaajatkat. Pii'irata pümata shia süpüla puwalaajüin ne'e mekiisat shikii toleeka nümüin’. ");
INSERT INTO guc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Je niasa'a chi nülaamainkai sütüma ni'rüin nia sünain tütüin ma'i sünain tü nukuaippakat, kaa'ushi naa'in mayaasüje'e nu'luwajüin tü nuwashirüinkat”, nümakalaka Jesús namüin. Nikirajakalaka joo Jesús na nikirajüinkana sulu'uje'ere'eya tü naashajaaitpakat achiki namüin. Müshi nia namüin: “Tü manoujainsatkalüirua maa'ulu yaa, alana'aleeshiija'a sünain tütüin suuliale'eya tü anoujasükalüirua. ");
INSERT INTO guc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tamüshii paala joo jia: Anakaja müleka tütüle jiakanaya sünain jaa'inrüin tü anasükat sümüin wayuu süka jünneetse, süpüla alinjanain jia süpüla wayuu wainma. Je ja'itaka'a saja'lajaajeerüin tü jünneetsekat so'uweena wane ka'i, na akaaliijuushikana jütüma, nayeena eeka jümaa chaa iipünaa nümaa Maleiwa süpüla ka'ikat süpüshua”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ayatüshi Jesús sünain nikirajüin na nikirajüinkana: “Müleka jaa'inrüle tü aluwataanakat anain jia, mayaainje malaachein shia, aneeküneena jia süpüla jaa'inrüinjatüin kasa anashaatasü. Maa'aya aka müleka nnojorule mojuin jaa'in saaliijee jaainjala müleka ju'luwajüle wane kasa eekai jayain, nnojoleerü mojuin jaa'in saaliijee ju'luwajüin wane kasa eekai kojutüin. ");
INSERT INTO guc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Je jiakana tekirajüinkana, müleka nnojoliire jaa'inrüin tü aluwataanakat anain jia nütüma chi wayuu ji'yataakai amüin, nnojoleena aneekünüin jia nütüma Maleiwa süpüla ji'yataainjanain nümüin. ");
INSERT INTO guc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Je müleka matüjüinre jia süpüleerua jaa'inmajüin tü nuwashirüinkat chi jülaamainkai maa'ulu yaa, nnojoleerü aapünüin kasa anasü jümüin nütüma Maleiwa so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maa aka kojuta'atüle piamashii laama nütüma chi a'yataaikai sünain alin nüpüla wane je sünain maalin nüpüla chi wane'e, meechi aka Maleiwa jütüma müleka shiale kachiiruain jaa'in tü washirüükat nuuliale'eya”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Otta na fariseokana naapapa tü nüküjakat Jesús namüin na nikirajüinkana, neme'erainpalashi nia, süka nayain kee'ireein aa'in washirüü waneepia. ");
INSERT INTO guc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Naashajaakalaka joo Jesús namüin: “Nnojotsü mojuin jaa'in saaliijee jaainjala, süka shiain ne'e anain o'ulu'u jia wayuu. Otta chi Maleiwakai, nütüjaa aa'ut tü jukuaippakat süpüshua. Mayaashiije kojutüin jia sütüma wayuu, nüleejeena jia Maleiwa”, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ayatüshi Jesús asouktüin namüin na fariseokana süka nayouktüin tü nikirajakat anain. Müshi nia namüin: “Je sümaiwa paala, nnojoliiwa'aya niweetüin Juan sünain aküjaa tachiki sümüin wayuu, ekirajuushi na jutuushikana sütüma tü nüshajakat Moisés oo'ulaka natüma na nünüikimaajanakana Maleiwa. Otta joolu'u süchikijee niweetüin Juan, aküjünüsü sümüin wayuu sainküin mmakat süpüshua süchiki nukuaippa Maleiwa sünain aluwatawaa. Ja'itaina manoujain jia tanain, eesü wayuu wainma eekai kee'ireein saa'in ekeroloo chamüin eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Juu'ulaa suulia jiyouktüin tü tekirajakat anain. Soto jaa'in wane kasa. Tü mmakat je tü kasa chakat iipünaa, aja'lajaweerü so'u wane ka'i. Otta tü nünüikikat chi Maleiwakai ashajünakat paala nütüma Moisés, nnojoleerü aja'ttüin. Nnojoleerü aja'ttüin waneeshikaiyaaje no'u pütchi sünainjee, ");
INSERT INTO guc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","maa aka tü nuluwataakat anain chi Maleiwakai sünain müin mayaa: ‘Chi eekai nuu'ulaain suulia nu'wayuuse, müleka ka'wayuusere nia nüchikua, kaainjalashi suulia tü palajatkat nu'wayuuse. Je kasalajaneerü nümüin nüma'üjaain sümaa tü jeketkat nu'wayuusein. Akaajaa chi wayuu ka'wayuusekai tü jierü oo'ulaaushitkat, kaainjalashi nia'aya, je kasalajaneerü nümüin nüma'üjaain sümaa tü jierü oo'ulaaushitkat’ ”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Süka na'waataain na fariseokana sulu'u anashiin no'ulu'u na wayuukana, aküjüshi joo Jesús süchiki wane wayuuirua piamasü. Müshi nia: “Eetaashi wane wayuu washirü. Kashe'inshi nia wane kuluulu anashaatasü kanüliasü ‘lino’. Anashaatasü ma'i niyolojo sulu'u. Je süka washirüin ma'i nia, emi'ijashi waneepia. ");
INSERT INTO guc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Je so'ulu'u tü nipiakat, e'ikünapü'üshi wane wayuu mojushi kanüliashi Lázaro süpüla nujulijainjachin nüpütaain chi washitkai süka müliain nia jamü. Yaaka atachi nia. Je antüsü erüirua nünainmüin süpüla she'erujaain tü nütoutakat yaakasükat. ");
INSERT INTO guc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Shiasa mapa, ouktüshi chi ajulijapü'ükai. Sükajee nüchoin Maleiwa, nüsaajünakalaka nü'ütpa'amüin Abraham sütüma wane aapieeirua nüma'anajeejatü Maleiwa. Otta müshia chi washitkai, ouktüshi nüchiiruajee. Nojoitünakalaka. Sükajee nnojolin nüchoin Maleiwa, nüsaajünakalaka sulu'umüin süpülee tü ouktüsükalüirua kanüliakat Hades. ");
INSERT INTO guc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Müliakalaka ma'i joo chi washitkai cha'aya. Niirakaakalaka chaa watta sünain ni'rüin Abraham otta müshia Lázaro nü'ütpa'a. ");
INSERT INTO guc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Taata Abraham’, müshi joo chi washitkai nümüin, ‘anashi müleka pümüliajüle taya. Müliashi ma'i taya sütüma tü sikikat. Püjüta tamüin Lázaro yalajee nücholotiraiwa najapü shiroku wüin nüchüttaiwa süpa'a tayee’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Asouktüshi Abraham: ‘Tachee, soto paa'in anapü'üin ma'i pia sulu'u puwashirüin kataiwa'aya po'u. Otta müshia Lázaro, müliapü'üshi, nnojotpü'üsü kasain eein nüma'ana. Otta joolu'u, talatüitpa naa'in ya'aya. Otta müshia piakai, pi'rüin joolu'u müliaa. ");
INSERT INTO guc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Je mojushiisü süpüla sülatüin wayuu chajee yaamüin yaa, maa aka mojushiin alataa yaajee chamüin cha'aya, süka eein wane ishi jerutshaatain ma'i yaa pasanain wanain’. ");
INSERT INTO guc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Nümakalaka joo chi washitkai nümüin Abraham: ‘Taataa, tachuntüin pümüin süka süpüshua taa'in, puluwataa pümata Lázaro chaa nipialu'umüin chi tashikai, eere eein ja'raisüirua tawalayuu, süpüla nüchiaain naya suulia nantajüin yaamüin sa'akamüin watta saalin müliaa’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Asouktüshi Abraham: ‘Eesü nama'ana tü ashajuushikat nütüma Moisés je natüma na nünüikimaajanakana Maleiwa paala sümaiwa. Anasü jülüjale naa'in tü naashajaakat achiki’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Taata Abraham, nnojotsü nanoujain tü naküjakat achiki. Akaajasa müleka su'unüle nanainmüin wane wayuu eekai süso'iraain aa'in süchikijee ouktaa, ayaawajaweena naya süpüla noo'ulaainjatüin suulia naainjala’. ");
INSERT INTO guc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nüsouktakalaka Abraham: ‘Müleka moonooinre naya sümaa nünüiki Moisés je nanüiki na nünüikimaajanakana Maleiwa, meenaja'a ne'e moonooin sümaa sünüiki wane wayuu eekai suso'iraasüin saa'in süchikijee ouktaa’, nümakalaka nümüin chi washitkai”. Kettaasü joolu'u nünüiki Jesús namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aashajaashi joo Jesús namaa na nikirajüinkana sünain nikirajüin naya. Müshi nia: “Eejeerü waneepia wayuu eekai naainjireein jia kasa mojusü. Otta naya, kasalajaneerü namüin tü naa'inrakat. ");
INSERT INTO guc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Anashii müleka nojutinnüle shirokumüin tü palaakat sünain kanutpünaain wane ipa miyo'u, suulia naainjirüin jia kasa mojusü. ");
INSERT INTO guc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anakaja eere jaa'in sünain aa'inmajirawaa wane'ewai jukua. Müleka naa'inrüle chi puwalakai kasa mojusü pümüin, anashi müleka püchiajaale nia. Je müleka nuu'ulaale suulia, anasü müleka motüle paa'in shia. ");
INSERT INTO guc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ja'itaichi kaainjalain nia puulia wainmatua, maa aka akaratshitua süpüla wane ka'i, müleka nüntüle akaratshitua pünainmüin sünain mojuin ma'i naa'in saaliijee tü naa'inrakat pümüin, anasü müleka motüle paa'in shia”, nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Namakalaka joo na Aluwataaushikana nümüin chi Senyotkai: —Anakaja müleka pükaaliijüle waya süpüla koo'omüinjatüin sütsüin tü wanoulakat. ");
INSERT INTO guc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Asouktüshi Jesús: —Müleka jünoujüle tanain, ja'itairü nnojolüin katsüin joolu'u tü jünoulakat, jaa'inreerü tü kasa isakat süchiki wayuu. Maa aka jümataarüle paala sümüin wane wunu'u eekai laktain: “Anakaja piyu'laale yaajee shirokumüin palaakat”, ayu'laajeerü shia sütüma jünüiki —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ayatshi Jesús sünain ekirajaa na nikirajüinkana sünain nümüin namüin: “Müleka kachepchiale jia, ¿eeshii süpüla jümüin nümüin chi jüchepchiakai nüle'ejapa sulu'ujee tü jiyüüjasekat oo'ulaka süchikijee arüleejaa shiale: ‘Pikeroloo, püikkalaa pikaaiwa’? Nnojo. ");
INSERT INTO guc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Shieerü eeka ne'e jümüin nümüin: ‘Pii'iranaja pümata püshe'in pü'lakajaaiwa teküin tekaamaataiwa. Otta ekeechi pia tachukumüin kettaapa süchiki teküin’. ");
INSERT INTO guc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Je süchikijee tia, nnojotsü süpüla jaapüinjatüin analu'ut nümüin saa'u naa'inrüin tü juluwataakat anain nia. ");
INSERT INTO guc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aka'aya jiakana jüpüshua, süchikijee jaa'inrüin tü aluwataanakat anain jia nütüma Maleiwa, anakaja jümüle: ‘Waya nüchepchiakana Maleiwa. Nnojotsü jaralüinjatüin aapüin analu'ut wamüin, süka shiain waa'inrüin ne'e tü nuluwataakat anain waya’ ”. Kettaasü joo tü nümakat Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sünain nu'unüin Jesús Jerusalénmüin, ojuittüshi nia sulu'ujee tü mmakat Galilea, ekerotshi sulu'umüin Samaria. ");
INSERT INTO guc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Je nüntapa so'ulu'umüin wane pueulo, eejana nüpüla wane wayuuirua polooshii aja'tta atachii. Sha'washawatshii ka'yata nuulia. Nowoorulaakalaka emetut: —Jesúsuu, Ekirajüikalee, anashi müleka pümüliajüle waya, piiyaja waya —namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Shiasa ni'rapa Jesús naya, —Ju'una jii'iyataiwa nümüin chi sacerdotekai sünain suu'ulaaitpain tü ayuuliikat juulia —nümakalaka namüin. Je sünain no'unüin, ashatüsü tü natakat. ");
INSERT INTO guc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Otta müshia waneeshia, wane wayuu Samariaje'ewai, nnojoishi judíoin, saa'u ni'rüitpain sünain anain tü nütakat, ale'ejüshi nia nünainmüin Jesús. Nu'waajüin chi Maleiwakai sünain emetuluin nünüiki je nüsapainyo'ukashi nia nümülatu'umüin Jesús sünain naapüin wane miyo'ushaata analu'ut nümüin. ");
INSERT INTO guc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nümakalaka joo Jesús namüin na wayuukana nümaajanakana: —Mataashii polooshiikai naya sünain neiyajünüin. ¿Jalasü tü mekietsatsükalüirua nüpüshi? ");
INSERT INTO guc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Je chi ale'ejaakai tanainmüin sünain nu'waajüin chi Maleiwakai, nnojoishi judíoin. Wayuu naatajai. ");
INSERT INTO guc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Otta nümüin chi wayuukai, müshi Jesús: —Püsha'walaa pu'unaiwa. Anaichipa pia saa'u pünoujain tanain. ");
INSERT INTO guc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","So'u wane ka'i, nasakirüin Jesús na fariseokana sünain joujaleechin o'ttüin Maleiwa sünain aluwatawaa. Asouktüshi Jesús: —Tü naa'inrakat chi Maleiwakai, naa'inrüin süka naa'in, nnojotsü sükajatüin jüsakirüin sünain. Je “Anii nia sünain aluwatawaa” oo'ulaka “Ichaa nia sünain aluwatawaa”, nnojoleechi münüin. Jütüjaa jümata naa'u chi Maleiwakai sünain nu'ttüichipain sünain aluwatawaa maa'ulu yaa, süka tantüichipain ja'akamüin —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","O'ttüshi joo Jesús nüchikua sünain ekirajaa na nikirajüinkana sünain nümüin namüin: “Meena jia so'uweena wane ka'i: ‘Kasataalejese we'rüin chi Shipayakai Wayuu sünain nüle'ejüin’. Otta tamüshii paala jia: Nnojoleechi ji'rüin taya sünain ale'ejaa so'u tia. ");
INSERT INTO guc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Je tü wayuukolüirua, meerü shia jümüin: ‘Jiirakaa, ichaa chi Shipayakai Wayuu cha'aya’ oo'ulaka ‘Jiirakaa, anii nia yaaya’. Nnojo ju'unüin shi'ipajee tia sünain jüchajaain tachiki. ");
INSERT INTO guc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Süka jamüin, maa aka tü shiyaakat juya shi'rakat wayuu süpüshua amachetaain chaa sirumatu'upünaa, akaweechia tayakai, chi Shipayakai Wayuu, tale'ejapa, shi'reechi wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Otta palajana, e'itaanüshi taya süpüla müliainjachin ma'i sütüma tü wayuu judíokalüirua eekai sülerajüin taya maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","“Soto jaa'in nüchiki Noé. Tü wayuukolüirua nnojoliiwa'aya no'otooin Noé sulu'umüin tü anuakat, ee'eraashii ne'e naya sünain nnojolüin jülüjain naa'in tü naainjalakat. Je mapa no'otoopa Noé sulu'umüin tü anuakat, a'itüsü tü juyakat sünain miyo'uin ma'i shia süpüla ouktajatüin tü wayuukolüirua süpüshua'ale eekai nnojolüin nümaain Noé sulu'u tü anuakat. Akaweeria takalio'u tayakai, chi Shipayakai Wayuu, wanaa sümaa tanteechin tachikua. ");
INSERT INTO guc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Maa'aya aka nükalio'u chi wayuu kanüliakai Lot paala sümaiwa, chi kepiapü'ükai sulu'u tü pueulokot kanüliakat Sodoma. Eeshii na wayuukana sünain emi'ijaa, sünain ayalajawaa kasa, sünain oikkawaa, sünain apünajaa, oo'ulaka sünain aainjaa miichi. Nnojotsü jülüjain naa'in tü naainjalakat. ");
INSERT INTO guc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Je süchikijee nujuittüin Lot sulu'ujee tü pueulokot, ajunuujaasü iipünaajee wane siki maa aka saa'in ipalira chuwachuwatsü süpüla su'utajatüin saa'in süpüshua tü wayuu kepiasükalüirua sulu'u tia pueulokat. ");
INSERT INTO guc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Maa aka tü wayuukolüirua sümaiwa paala sünain nnojolüin jülüjüin naa'in tü naainjalakat, meeria tü wayuukolüirua so'uweena tü ka'i teweeteechikat o'u tayakai, chi Shipayakai Wayuu. ");
INSERT INTO guc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chi wayuu eekai joyotüin sheemioushi tü nipiakat so'u ka'ikat tia, anakaja nnojoire nikerolüin paülü'ümüin süpüla nükotchajaain nükorolo. Otta chi wayuu eekai ni'yataain sulu'u niyüüjase, anakaja nnojoire nüle'ejüin nipialu'umüin süpüla asaajaa nükorolo. ");
INSERT INTO guc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Soto jaa'in süchiki tü nu'wayuusekat Lot. Najuittapa sulu'ujee Sodoma, o'utinna aa'inrü shia nütüma Maleiwa saaliijee shiirakaain süchikua sümüin tü sükorolo süpütakat sulu'u tü pueulokot. ");
INSERT INTO guc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Chi wayuu eekai jülüjüin naa'in waneepia tü nükorolokot süpüla naa'inmajüin je süpüla najapulu'uin shia, amülouleerü süpüshua. Alu'usa chi eekai naapüin nukuaippa süpüla ni'yataainjachin tamüin, ja'itasü amüloulin süpüshua tü nükorolokot sünainjee tia, aapüneerü nümüin kasa anasü tatüma nnojotkat amülouleerüin. ");
INSERT INTO guc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Je so'uweena tü ka'i teweeteechikat o'u, eejeena piamashii wayuu atunküin sulu'u wane miichi. Tamaweechi wane. Oo'ulaka wane, tapüteechi. ");
INSERT INTO guc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Eejeena piamashii jieyuu sünain amoliinajaa. Tamaweerü wane. Oo'ulaka wane, tapüteerü. ");
INSERT INTO guc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eejeena piamashii wayuu sünain a'yatawaa sulu'u nayüüjase. Tamaweechi wane. Oo'ulaka wane, tapüteechi”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—Senyotkalee, ¿jameenaka na makatakana? —müshii naya nümüin. Asouktüshi Jesús: —Müleka sükotchajaale wane samulüirua, atüjaana aa'ut sünain ouktüin wane kasa. ");
INSERT INTO guc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ekirajüshi joolu'u Jesús na nikirajüinkana süka sukuaippa tü kasa e'nnakat sainküin mma shii'iree nachecherüinjatüin naa'in sünain achuntaa nümüin Maleiwa waneepia. ");
INSERT INTO guc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Müshi nia namüin: “Eetaashi wane wayuu pütchipü'ü kepiashi sulu'u wane pueulo. Manoujainsai nia nünain Maleiwa, je püla aa'inchi ma'i nia suulia wayuu. ");
INSERT INTO guc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oo'ulaka sulu'u tü pueulokat, eesü wane wayuu oukta a'wayuuset. Antawaisü nünainmüin chi pütchipü'ükai sünain, ‘Anasü pükaaliijüle taya sünain amaünajaa nümüin chi ta'ünüükai’, sümüin nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Niyouktajakalaka joo shia. Masütaajukalaka joo shia sünain achuntaa nümüin. Shiasa so'u wane ka'i, saa'u wainmatuairüin sükua tü jietkat nüma'anajee, müsü naa'in: ‘Aisha'ajaa, shike'ejakatche ma'i taa'in meinshi tü wayuukot, müirüinja'a shia sümaa shike'era. Anainja taa'inrüle sümüin tü süchuntakat tamüin, mayaashije'e manoujain taya nünain Maleiwa je mamaneein taya suulia wayuu’, müsü naa'in chi pütchipü'ükai. ");
INSERT INTO guc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Soto jaa'in nüchiki chi pütchipü'ü pülakai aa'in suulia wayuu. Mayaasüje niyouktajüin paala tü wayuukot, nükaaliijain shia mapa süka shike'ejüin ma'i naa'in waneepia. ");
INSERT INTO guc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Otta müshia chi Maleiwakai, ¿nnojoleena nükaaliijüin waya aneekuushikana achuntakana nümüin waneepia so'uka'i, sa'wai? Shiimüin sünain nükaaliijeenain waya noulia na wa'ünüükana. ");
INSERT INTO guc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jiakana müliakana natüma na jü'ünüükana, shiimüin tanüiki jümüin: Yapashi chi Maleiwakai süpüla nükaaliijain jia waneepia. Otta müshi'iya jiakana, müleka ayatüle jia sünain jaa'inrüin tü nuluwataakat anain, katsüinjeerü jaa'in sünain anoujaa so'uweena tü ka'i tale'ejeechikat o'u, taya chi Shipayakai Wayuu”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aashajaashi joo Jesús sümüin tü wayuu eekai pülain saa'in suulia wayuu, na wayuu anakana saa'in namüin no'ulu'u Maleiwa. Nikirajüin joo naya süka sukuaippa tü kasa e'nnakat sainküin mma: ");
INSERT INTO guc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ekerotshii piamashii wayuu sulu'umüin tü a'waajüleekat Maleiwa süpüla achuntaa nümüin: wane fariseo oo'ulaka wane okotchajüi neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Asha'walaashi chi fariseokai sünain naashajaain nümaa Maleiwa sünain nu'waataain sulu'u nukuaippa. Müshi nia: ‘Maleiwakalee, taapüin pümüin analu'ut saa'u nnojolin müin aka taya saa'in wayuu wainma sünain ka'ruwaralüin, sünain mojulaain, je sünain ama'üjawaa sümaa wayuu nnojotkat nu'wayuusein otta nnojoikai su'wayuusein. Je anayaawatshija taa'u sünain nnojolin müin aka taya naa'in chi okotchajüikai neerü. ");
INSERT INTO guc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aamajüshi taya pümüin waneepia piantua süpüla semaanakat shii'iree talateein pia tamaa. Je tasülajüin pümüin polo'owai sünainjee tü polookot shikii süpüshi tü ta'yataainkat’. ");
INSERT INTO guc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Otta chi okotchajüikai neerü, yalashi nia sha'watüin ka'yatalu'u nuulia chi fariseokai. Jepitüshi nia sünain nüshe'ejüin naa'into'u süka mojuin ma'i naa'in saaliijee naainjala. ‘Maleiwakalee, wayuu kaainjarai taya. Anakaja müleka pümüliajüle taya’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Saa'u nümüin joo chi wayuukai, anajiraaichipa nümaa Maleiwa. Akaajasa chi fariseokai, ale'ejüshi nipialu'umüin sünain nnojolin anajiraain. Chi eekai yaletayaain nukuaippa su'upala wayuu, nnojoleechi kasajachin nümüin Maleiwa. Alu'usa chi eekai nnojolüin yaletayaain naa'in, kojuteechi nütüma”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Je so'u wane ka'i, antinnüsü wane tepichiirua nünainmüin Jesús süpüla ni'itaainjatüin najapü naa'uirua sümaa nuchuntüin nümüin Maleiwa naa'u. Otta na nikirajüinkana ne'rapa tia, nachiajaakalaka tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Otta müshia Jesús, nuchuntakalaka namüin na wayuukana nantirüin na tepichikana nünainmüin nachikua. Nümakalaka joo namüin na nikirajüinkana: —Kettshi'iya na tepichikana nantaiwa tanainmüin. Maa aka nakuaippa na tepichikana sünain nnojolüin kaa'in toulia, müinjatia nakuaippa tamüin na ekeroteekana chaa eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tamüshii paala jia: Chi wayuu eekai nnojolin müin aka naa'in na tepichikana sünain nanoujain tanain, müichia nnojolin ekerotüin eere nuluwataain Maleiwa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nürütkaakalaka nünainmüin Jesús wane wayuu aluwataashi sünain nüsakirüin nia: —Ekirajüikalee, pia anamiakai, ¿kasa taa'inrüinjatka süpüla eeinjachin taya nümaa Maleiwa waneepia? ");
INSERT INTO guc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Asouktüshi Jesús: —¿Jamüshi “pia anamiakai” pümakalaka tamüin? Waneeshia Maleiwa niain anamiain. ");
INSERT INTO guc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aashin pütüjaayaain aa'u tü nuluwataakat anain Maleiwa, makat mayaa: “Nnojo püma'üjaain sümaa wayuu nnojotkat pu'wayuusein otta nnojoikai pu'wayuusein. Nnojo pu'utüin saa'in wayuu. Nnojo pu'luwajüin sükorolo wayuu. Nnojo püküjüin alawaa süchiki wane wayuu. Kojutüinjatü pütüma püi je püshi”, müsü tü pütchikat —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Taa'inratüjütsa'aya tia süpüshuale'eya tepichiiwa'aya taya ja'itakaje maa'utpünaa yaa —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sütüma tü nümakat chi wayuukai, asouktüshi Jesús: —Che'ojaayülia wane kasa paa'inrajatkat. Anakaja puikküle tü pukorolokot süpüshua süpüla püsülajüinjatüin tü süliakat sümüin wayuu eekai mojuin. Kee'irakeerü pümüin shia iipünaamüin cha'aya eere Maleiwakai. Je paa'inrapa tia, ale'ejeechi pia püchikua tanainmüin süpüla tamaain pia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Je chi wayuukai sütümajee tü nümakat Jesús nümüin, mojusü ma'i naa'in, süka washirüin ma'i nia. ");
INSERT INTO guc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eirakaashi Jesús nümüin chi wayuukai sünain maa nümüin: —Chi wayuu eekai ataralaain sümaa tü nuwashirüinkat, kapüleejeerü ma'i nümüin ekerotoo cha'aya eemüinre nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mapüleesat süpüleerua shikerotüin wane “camello” so'ulu'upünaa wane wutia suuliale'eya shikerotüin wane wayuu washirü cha'aya eere nuluwataain Maleiwa —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Je na wayuukana eekai naapajüin nünüiki Jesús, namakalaka nümüin: —Isasüja'a sümata nüchiki nu'ttaainjachin wane wayuu. ");
INSERT INTO guc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Asouktüshi Jesús: —Tü kasa isakat süchiki wayuu, nnojotsü kapüleein nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Müshi joo Pedro nümüin Jesús: —Wapütüin süpüshua tü kasa eejatkat wama'ana süpüla yaainjanain waya pümaa. ");
INSERT INTO guc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Asouktüshi Jesús: —Jiakana apütakana kasa süpüshua eejatkat jüma'ana süpüleerua aküjaa süchiki nukuaippa Maleiwa sünain aluwatawaa, shiimüin tü tamakat jümüin sünain saapüneerüin jümüin kasa anasü. Mayaasüje jüpütüin jipia, ju'wayuuse, juwalayuu, mayaasüje jüpütüin jii, jüshi oo'ulaka jüchonnii shiale, alana'aleejeeria tü aapüneetkat jümüin suulia tü kasa jüpütakat. Je eejeena jia nümaa Maleiwa waneepia saa'u shii'iranajaaushin jaa'in —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Otta müshi'iya na Aluwataaushikana polooshiikana piammüin, neenajakalaka naya Jesús nünainmüin sujuuna tü wayuukolüirua süpüla naashajaain namaa. Müshi nia namüin: “O'unajana joolu'u waya Jerusalénmüin. Je tü ashajünakat tachiki paala natüma na nünüikimaajanakana Maleiwa, tachiki tayakai, chi Shipayakai Wayuu, ekeraajeerü süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aapüneematüichi ekii taya najapulu'umüin na gentilekana. Neme'erainpaleechi taya. Naa'ayataajeechi aa'in taya sünain nejeteenain taa'u je sünain na'yaateechin taya. Je süchikijee tia, no'utireechi aa'in taya. ");
INSERT INTO guc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Otta nu'unnaa chi apünüinkai ka'i süchikijee tia, oso'iraajeerü taa'in”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Otta na nikirajüinkana, nnojotsü nayaawatüin saa'u tü nüküjaitpakat namüin. Isasü nachiki nayaawatüin saa'u sünain ouktajachin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Je nüntapa Jesús so'ulu'umüin tü pueulokat kanüliakat Jericó, eejachi joyotüin wane wayuu mo'usai sotpa'a tü wopukot sünain ajulija'alaa. ");
INSERT INTO guc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Je naapapa chi wayuukai tü suu'uipsana'irakat wayuu sünain sülatüin nü'ütpünaa, —¿Jamüsü sülataka'a wayuu wainma yaapünaa? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Nia alataka Jesús chi Nazaretje'ewaikai —sümakalaka tü wayuukolüirua nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nuwoorulaakalaka joo sünain nümüin: —Jesúsuu, Nülüinkai David, pümüliaja taya. ");
INSERT INTO guc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Shiasa tü wayuu nüpüleeruasükat Jesús sulu'u tü wopukot, —Kaseesü pikiisa —müsü nümüin chi mo'usaikai. Otta chi mo'usaikai, masütaajusai nia sünain a'waataa: —Nülüinkai David, pümüliaja taya —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nüsha'walaakalaka Jesús sünain nüsaajirüin chi mo'usaikai nünainmüin. Je nüntapa nünainmüin, nümakalaka Jesús nümüin: ");
INSERT INTO guc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Kasa püchekaka taa'inrüin pümüin? —Senyotkalee, anashi müleka ko'ule taya —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Asouktüshi Jesús: —Ko'uichipa pia joolu'u saa'u pünoula —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ko'u müshija nia. Je süka anaichipain nia, nu'unakalaka joo nümaa Jesús sünain nu'waajüin Maleiwa. Je na wayuukanaya, na'waajüin chi Maleiwakai süka ne'rüichipain chi wayuukai sünain ko'uin. ");
INSERT INTO guc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Je nikerolopa Jesús sulu'umüin Jericó, waraittakalaka nia süpa'apünaa. ");
INSERT INTO guc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Otta müsia cha'aya eeshi wane wayuu washirü kanüliashi Zaqueo, nia laülaaka naa'u na okotchajüliikana neerü nümüin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ni'reein ma'i Jesús. Otta süka wainmain wayuu je süka motsachoin nia, isashi nüchiki ni'rüin. ");
INSERT INTO guc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nuwataakalaka nüpülamüin Jesús eepünaainjachire nülatüin. Nüliikajaakalaka naa'u wane wunu'u miyo'u shii'iree ni'reein nia. ");
INSERT INTO guc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Shiasa nüntapa Jesús eere nüliikajaain Zaqueo, niirakaakalaka iipünaamüin sünain nümüin nümüin: —Püshakata pümata yalajee, waa'iraa. Acheküshi pi'iyouin taya so'uka'i chaa pipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ashakata müshija Zaqueo naa'ujee chi wunu'ukai. Nüntirakalaka Jesús nipialu'umüin sümaa talatüin ma'i naa'in nümaa. ");
INSERT INTO guc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mojukalaka sünüiki tü wayuu waraittakalüirua nümaa Jesús sünain sümüin nujuuna: “¿Jamakuaippaikai makalaka nia ni'iyouin chi kaainjaraikai?”. ");
INSERT INTO guc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nüsha'walaakalaka Zaqueo no'upala na wayuukana sümaa naashajaain nümaa Jesús: —Senyotkalee, tasülajeerü joolu'u shiatapünaa tü tawashirüinkat sümüin wayuu eekai müliain. Je müleka te'ike'erüle paala wane wayuu süka ta'alain saa'u sükorolo, tawalaajeerü sümüin süchikua pienchitua —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Asouktüshi Jesús: —Antüshi tayakai, chi Shipayakai Wayuu, süpüla achajawaa süchiki wayuu eekai maa'awain nuulia Maleiwa, shii'iree su'tte'enneein tatüma, maa aka piakai. Je süka pünoujain tanain, maa aka chi watuushikai Abraham sünain nünoujain nünain Maleiwa, shiimüin sünain pu'tte'ennüin tatüma sümaa tü wayuukalüirua kepiakat yaa sulu'u tü pipiakat —nümakalaka Jesús nümüin Zaqueo. ");
INSERT INTO guc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Saa'in namüin na wayuukana waraittakana nümaa Jesús, alü'ülüyaasü nükalia Maleiwa süpüla aluwatawaa, süka pejein Jesús sünain Jerusalén. Nu'ttakalaka joo Jesús sünain ekirajaa naya süka sukuaippa tü kasa e'nnakat sainküin mma süpüla sütüjaainjatüin saa'u tü alateetkat ");
INSERT INTO guc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","sünain nümüin namüin: “Eetaashi wane wayuu nülüin chi sülaülapü'ükai mma. O'unajachi nia sulu'umüin wane mma wattasü süpüla ni'itaanajachin sünain aluwatawaa. Ale'ejüinjachi nia süchikijee tia süpüla nuluwataainjachin naa'u na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Je nüma'ichiki, neenajakalaka wane nüchepchiairua nünainmüin, maa aka polooshii, süpüla naapüinjatüin wane neerü kanüliasü ‘mina’ namüin wane'ewai nakua. ‘Süma'inru'u nnojolin taya jümaa, anakaja müleka jiyalajüle kasa süka tü taapakat jümüin jüikkaiwa shia kachoinwa tü neetkat jütüma’, müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Otta wainma na wayuu nuluwataainjaneenakana aa'u, süka na'ürülaain nia, najütüin wane aapieeirua nüchiirua süpüla maa: ‘Nnojotsü wacheküin süpüleerua nuluwataainjachin chi wayuukai waa'u’. ");
INSERT INTO guc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mayaainje niyouktünüin chi wayuukai sütüma wainma wayuu, ayatshia e'itaanüin nia sünain aluwatawaa. “Je shiasa mapa nüle'ejapa nuumainpa'amüin, neenajakalaka na nüchepchiakana nünainmüin, na naapakana amüin neerü paala. ‘¿Jera süchon tü neerü taapakat jümüin?’, nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Asouktüshi wane palajana: ‘Aluwataashikalee, anu'uya poloosü neerü sükanain tü waneesia paapakat paala tamüin’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Tachepchiee, tütüshi pia. Analeesia ma'i tü paa'inrakat. Süka paa'inrüin tü aluwataanakat anain pia, mayaainje malaachein shia, te'itaain pia joolu'u süpüla laülaainjachin saa'u wayuu sulu'u pueulo poloosü’, nümakalaka chi aluwataashikai nümüin. ");
INSERT INTO guc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Asouktüshi wane'eya: ‘Aluwataashikalee, anu'uya ja'raisü neerü sükanain tü waneesia paapakat paala tamüin’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Tachepchiee, te'itaain pia joolu'u süpüla laülaainjachin saa'u wayuu sulu'u pueulo ja'raisü’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Asouktüshi wane'eya: ‘Aluwataashikalee, anuu tü waneesiakat neerü paapakat tamüin paala. Sajatü ne'e shia tanaajaain sulu'u susukot süka mmolüin taya peema, süka wayuuin iche ajapüchi pia süpüla awalaajaa shi'yataain wayuu’, nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Tachepchiee, pia ku'lajaakai aa'in, pi'rala ne'e wayumüin tamüin tü paa'inrakat. Süka pütüjaainje taa'u sünain wayuuin iche ajapüchi taya, ");
INSERT INTO guc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿jamaka'a nnojotka'a paapüin tü neetkat sümüin wane wayuu süpüla shi'yate'erüin shia süpüla kachoinjatüin shia tapüla?’, nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nümakalaka joo chi aluwataaikai sümüin tü wayuu eejatkat nümaa: ‘Jüsüta jümata nuulia türa neerü nüma'anakat saapünaiwa nümüin chi akanajakai poloosü’. ");
INSERT INTO guc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Aluwataashikalee, naa'aya poloosü neerü nüma'ana’, namakalaka nümüin süka nnojolüin nayaawatüin saa'u tü nümakat namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“ ‘Shiimüin ma'i tü tamakat jümüin: Chi wayuu eekai koo'omüin nütüma tü aapünakat nümüin, aapüneerü soo'omüin nümüin. Akaajasa chi eekai nnojolüin koo'omüin nütüma tü aapünakat nümüin, asütüneerü nuulia. ");
INSERT INTO guc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Otta müshi'iya na ta'ünüükana ayouktakana taya süpüleerua taluwataainjachin yaa toumainpa'a, anakaja su'utinnüle saa'in joolu'u yaa to'upala’, nümakalaka chi aluwataaikai namüin”. ");
INSERT INTO guc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Shiasa kettaapa nünüiki Jesús sünain nikirajüin na wayuukana, o'unüshi nia napüleerua sulu'u tü wopukot Jerusalénmüinjatkat. ");
INSERT INTO guc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Je nülü'ülapa sünainmüin tü pueulokat Betfagé oo'ulaka Betania, tü pejekalüirua sünain tü wutai kanüliakat Olivos, nüjütakalaka piamashii na nikirajüinkana nüpüleerua sünain nümüin namüin: ");
INSERT INTO guc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Ju'una samüin eemüin tüsa pueulokat jüpüleeruakat. Je jikerolapa sulu'umüin, ji'reechi kapüin wane püliikchon sareerü. Jüsiwateerü tü nüpükat süpüla jajattüin nia tamüin yaamüin. ");
INSERT INTO guc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Je müleka “¿Jamüinjatü jüsiwataka'a tü nüpükat?” sümüle wayuu jümüin, “Che'ojaashi nümüin chi Senyotkai”, meena jia sümüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na ajütüüshikana, ayatsia napüla maa aka tü nümakat Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Je wanaa sümaa nasiwatüin nüpü chi püliikchonkai, —¿Jamüinjatü jüsiwataka'a tü nüpükat? —nasakirakalaka na kapüliisekana namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nasouktakalaka namüin: —Che'ojaashi nümüin chi Senyotkai. ");
INSERT INTO guc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Najattakalaka chi püliikchonkai eemüin Jesús. Ne'itaakalaka tü nashe'inpalajanakat naa'u chi püliikchonkai. Je no'otokalaka Jesús naa'u. ");
INSERT INTO guc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Je sünain nu'unüin Jesús naa'u chi püliikchonkai, awayalayaa müsü süshe'inpalajana tü wayuukolüirua nüpüleerua sulu'upünaa tü wopukot süpüla shii'iyatüin nujutu nümüin. ");
INSERT INTO guc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Je nülü'ülapa Jesús sünainmüin eere süshakatüin tü wopukot saa'ujee tü wutai kanüliakat Olivos, talatüsü ma'i naa'in na wainmakana nikirajüin napüshua, süka ne'rapü'üin tü kasa anasü naa'inrakat Jesús, tü nütüjakat apüleerua Maleiwa nümüiwa. Na'waajakalaka joo Maleiwa sünain emetuluin nanüiki mayaa: ");
INSERT INTO guc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Anata'aleeshija'a ma'i chi Nüjünalakai Maleiwa, chi aluwataashikai waya”. “A'waajünüshi nia maa'ulu yaa chaa iipünaa, süka anajiraainapain na nüpüshikana nümaa Maleiwa”, müsü nanüiki nüchiki Jesús. ");
INSERT INTO guc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Otta nanüiki wane na fariseokana sa'akajee tü wattakat saalin wayuu: —Ekirajüikalee, anakaja püchiajaale na pikirajüinkana —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Müshi taya jümüin: Müleka ko'utüle na tekirajüinkana, shieerü a'waataka tü ipakalüirua sünain su'waajüin taya —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Alü'ütshi joolu'u Jesús sünainmüin Jerusalén. Shiasa ni'rapa tü pueulokot, müshi nia sünain a'yalajaa saalin tü wayuu kepiasükalüirua sulu'u: ");
INSERT INTO guc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Alu'uleeka ma'i jia süka nnojoliiyüliain jiyaawatüin saa'u tü ekirajünakat anain jia. Je saa'ujee nnojoipü'üin jamajachin jümüin taya, müina nnojoliin anajiraain jia nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Je süka nnojoliipü'üin jünoujain tanain, sünain aluwataaushin taya nütüma Maleiwa, anteena na jü'ünüükana jünainmüin so'uweena wane ka'i süpüla atkawaa jümaa. Noukaajeena achiki jia suulia ojuittaa sulu'ujee tü pueulokat. Je nekerolapa jünainmüin, o'utüneena aa'in jia sümaa jüchonnii je ojunnajinneerü tü jipiakat”. ");
INSERT INTO guc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Shiasa süchikijee nüntüin Jesús Jerusalénmüin, nikerotokalaka sulu'umüin tü a'waajüleekat Maleiwa. Eesü nüpüla wane wayuu oikkaasüirua sünain süikkaain tü mürüt o'utinnajatkat aa'in nümüin Maleiwa. Nujuittirakalaka naya anooipa'amüin. ");
INSERT INTO guc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nümakalaka sümüin: —Tü nünüiki Maleiwa ashajuushikat paala sümaiwa, müsü mayaa: “Tü tepiakat, nachuntiajatü na tapüshikana tamüin sainküinjee mmakat süpüshua”, müshi. Otta jiakana, saa'u nnojolüin lotüin jukuaippa sünain jüikküin tü mürütkat, müsü aka saa'in shipia ka'ruwarannuu jütüma tü nipiakat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nu'ttakalaka Jesús sünain ekirajaa sulu'u tü a'waajüleekat Maleiwa. Otta na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana, no'utee aa'inchi Jesús. Müshi'iya aka naa'in na kojutkana sa'akajee tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Akatsa süka eein wayuu wainma nümaa waneepia sünain aapajaa nünüiki, mojushiikalaka shia namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","So'u wane ka'i sünain yaain nikirajüin Jesús tü wayuukolüirua yala sulu'u tü a'waajüleekat Maleiwa je sünain nüküjain nüchiki niakai, chi O'tte'erüikai, namüin, narütkaakalaka nünainmüin na laülaayuushiikana na'akajee na sacerdote judíokana, oo'ulaka na karalouktamaajanakana, oo'ulaka na laülaashiikana naa'u na judíokana sünain namüin nümüin: ");
INSERT INTO guc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Jara koonoloka pia süpüla pujuittirüin anooipa'amüin tü wayuu oikkaatkalüirua? ¿Jara ke'inaajalaka pia süpüla paa'inrüin shia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Nüsouktakalaka Jesús ne'ipajee: —Tasakirüin paala jia'aya: ¿Jara ke'inaajalaka Juan sünain owoutisaajaa? ¿Shi'inaajala wayuu, niataapa Maleiwa? Jüküjaa tamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naashajaajiraakalaka namüiwa: “Müleka ‘Nia Maleiwa’ wamüle, ‘¿Jamakalaka nnojoliika'a jünoujain nünüiki?’, meechi nia wamüin. ");
INSERT INTO guc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Oo'ulaka mojushiisü süpüla ‘Wayuu’ wamüinjanain, süka nünüikimaajachin nia Maleiwa saajüin tü wayuukolüirua. Eesü süpüla shi'ina'aleenain waya”, majiraashii naya nujuuna Jesús. ");
INSERT INTO guc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nasouktakalaka joo nümüin Jesús: —Nnojoishi watüjaain aa'u jaralin ke'inaajalain. ");
INSERT INTO guc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nümakalaka joo Jesús namüin: —Nnojoluja'a süpüla taküjüin jümüin jaralin ke'inaajalain taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ayatshi Jesús sünain ekirajaa tü wayuukolüirua süka sukuaippa tü kasa e'nnakat sainküin mma. Müshi nia: “Eetaalashi wane wayuu ka'apainseshi. Nüpünajüin tü wunu'u kachonkot uuwa sulu'u. Naa'inmajirüin wane wayuuirua tü nüpünajüinkat süka nu'unüin süpüla kakaliaa sulu'umüin wane mma wattasü. ");
INSERT INTO guc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Je kettaapa süka'iya tü a'ttieekat süpüla sütpajünüin, nüjütüin wane nüchepchia nanainmüin na aa'inmajüliikana sünain maa namüin: ‘Anakaja juluwataale tamüin süpüshi süchon tü ta'ttia jükotchajalakat, tü tamüinjatkat jütüma saa'u takoroloin shia’. Otta chi nüchepchiakai, ashe'ejünüshi natüma na aa'inmajüliikana. Ajütajaanüshi sümaa nnojolüin kasain najapüipain natüma. ");
INSERT INTO guc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Otta chi ka'apainseshikai süchikijee tia, nüjütakalaka joo wane nüchepchiaya nii'iraka chi wane. Ashe'ejünataaja joo chii natümaya. Ajütajaanüshi nia sümaa nnojolüin kasain nülü'üjaain natüma, süka e'rüliin ma'i wayumüin naya. ");
INSERT INTO guc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nüjütataaja'a joo wane'eya, apünüinsüirü joo wayuu nüjütüin nüka chii. Eewaataaja'a joo chii natümaya sümaa nojunaain nia anooipa'amüin. ");
INSERT INTO guc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Je chi ka'apainseshikai süchikijee tia, ‘¿Kaseerü cheje taa'inraka?’, ma müsü naa'in. ‘Anashi tajütüle chi tachonkai aishikai ma'i tapüla. Kojuttaajeechipa eera nia natüma’, müshi. ");
INSERT INTO guc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nayasa'a na aa'inmajüliikana ne'raiwa'aya chi nüchonkai chi ka'apainseshikai nüpanapa seeiwa'aya nia, aashajaajiraashii naya: ‘Anii chi ka'apainseinjachikai ouktapa chi nüshikai. Joo'uya wo'utaiwa naa'in süpüla wayainjanain makatüin apüla shia’, müshii naya. ");
INSERT INTO guc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nayu'lakalaka joo nia anooipa'amüin je no'utakalaka naa'in. “Tasakirüin paala jia: ¿Kaseerü naa'inraka chi ka'apainseshikai naka na aa'inmajülii e'rüliikana ma'i wayumüin? ");
INSERT INTO guc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Shiimüin sünain nüle'ejüin süpüla nu'utüinjatüin saa'in. Je naa'inmajireerü tü na'apainsekat wayuu naatajatü”, nümakalaka Jesús namüin. Otta tü wayuukolüirua saapapa nünüiki Jesús, müshii naya: —Kasataalejese nnojolüin alatüin wamüin tü alatakat namüin na aa'inmajülii e'rüliikana wayumüin. ");
INSERT INTO guc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Niirakaakalaka joo Jesús namüin na laülaayuushiikana sünain nümüin namüin: —Müshi'iya aka jia saa'in na aa'inmajüliikana. Soto jaa'in tü ashajuushikat paala jüchiki: “Tü ipa ayouktünakat natüma na akumajüliikana miichi, ekeraajüitpa sünain anain ma'i shia süpüla akumajia miichi”. Otta tayakai, taya'aya chi ipa jiyouktakai. ");
INSERT INTO guc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Je sükajee tia, soto jaa'in wane kasa. Taya'aya chi Nüneekajalakai Maleiwa, je chi eekai niyouktüin taya, amülouijeechi —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Otta na karalouktamaajanakana oo'ulaka na laülaashiikana na'akajee na sacerdote judíokana, kee'ireesü ma'i naa'in nata'üleein Jesús so'u ka'ikat tia, süka nayaawatüitpain saa'u sünain nayain müin aka naa'in na aa'inmajülii e'rüliikana wayumüin sulu'u tü nüküjaitpakat achiki Jesús. Otta nnojoishi nata'ülüin süka mmolüin naya seema tü wayuu kamalainkat amüin nünüiki Jesús. ");
INSERT INTO guc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Najütakalaka wane wayuu ajayajüsüirua eekai anamiayaain nünainmüin Jesús süpüla nasakirayaainjachin nia shii'iree niweetirüin wane pütchi kasalajanainjatkat anainjee nia natüma nu'upala chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Namayaakalaka nümüin: —Ekirajüikalee, watüjaa aa'uchi pia sünain shiimüin tü pümakat sünain ekirajaa tü nuluwataakat anain Maleiwa, je sünain matüjüin pia kachekalaa su'utku wayuu. ");
INSERT INTO guc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wasakiree amüinchi pia sünain wane kasa: ¿Anashiisü saa'in pümüin wawalaajüle tü neerü nümüinjatkat César chi joyotokai cha'aya Roma sünain aluwatawaa saa'u mmakat, nnojottaapa anain? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Otta müshia Jesús, süka niyaawatüin saa'u sünain naa'inreein kasa mojusü nümüin, nümakalaka namüin: ");
INSERT INTO guc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Iche'era tamüin wane neerü kachueera awalaajiapü'ükat nümüin chi sülaülashikai mma, te'raiwa shia. ¿Jara kayaakuaka tü sünainkat? ¿Jara kanüliamaajachika shian? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Shia niyaakua oo'ulaka nünülia César tü sünainkat —namakalaka nümüin. Nüsouktakalaka Jesús: —Tamüshii paala jia: Anakaja müleka jaa'inrüle tü nuluwataakat anain César otta jaa'inrüinjatü tü nuluwataakat anain Maleiwaya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na ajayajüshiikana, nnojotsü nountüin nantüin sünain wane pütchi kasalajanainjatkat anainjee Jesús natüma. Ko'uko'utshii naya, süka ponoin ma'i naa'in tü nüsouktiakat Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Süntakalaka wane wayuuirua judío kanüliasü saduceo nünainmüin Jesús süpüla süsakirayaainjachin nia. “Nnojoleerü oso'irawaa aa'inyüü süchikijee ouktaa”, müsü tü shikirajapü'ükat anain tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Namakalaka joo nümüin Jesús: —Ekirajüikalee, müsü nünüiki Moisés wamüin sulu'u tü ashajünakat paala: “Müleka ouktüle wane wayuu sümaa machoin nia, anashi müleka niisarüle chi nimüliakai nüchukumüin süpüla kachooinjatüin tü jietkat nütüma”, müsü. ");
INSERT INTO guc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Eetaashiija'a akaratshishii wayuu pawalaawashii. Ka'wayuuseshi chi epayaakai sümaa ouktüin nia machoinwa'aya sümüin tü nu'wayuusekat. ");
INSERT INTO guc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Niisatkalaka chi nimüliakai sümüin tü jietkat. Ouktataashija chii'iya nnojoiwa'aya kachooin sümüin tü jietkat. ");
INSERT INTO guc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eisattaaja'a joo wane'eya nüchukumüin. Mataaja'a aka nakuaippa napüshua na akaratshishiikana awalayuwaa. Ouktüshii naya sünain machoin sümüin tü jietkat natüma. ");
INSERT INTO guc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Je oo'uwo'utpa na su'wayuusekana napüshua, ouktüsü mapa shia nachiiruajee. ");
INSERT INTO guc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Su'wayuuseshii napüshua na akaratshishiikana kataiwa'aya so'u. Wasakiree amüinchi joo pia soo'opünaa tia: So'u tü ka'ikat suso'iraainjateetkat o'u saa'in wayuu paajüin, ¿jaraleechi ka'wayuuseka tü wayuu ouktama'akat? —namakalaka na saduceokana nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nüsouktakalaka Jesús: —Sukuaippa tü wayuukolüirua maa'ulu yaa, ka'wayuusejiraasü. ");
INSERT INTO guc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Alu'ujasa tü wayuukolüirua eekai aneekünüin nütüma Maleiwa süpüla eeinjatüin nümaa süpüla ka'ikat süpüshua, oso'iraweerü aa'in süchikijee ouktaa. Je cha'aya nüma'ana Maleiwa, nnojoleerü pa'wayuuseewain. ");
INSERT INTO guc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Saa'u meenain aka naya saa'in nakuaippa na aapieekanairua chakana nüma'ana Maleiwa sümaa nnojoliin ouktüin naya, nnojoleena ka'wayuusein, nnojoleena kachooin. Nüchooin Maleiwa naya saa'u naso'iraainapain aa'in süchikijee ouktaa. ");
INSERT INTO guc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Jia manoujainsaliikana sünain suso'iraainjatüin saa'in wayuu, soto jaa'in tü nüshajakat achiki paala Moisés soo'opünaa tü nümakat chi Maleiwakai nümüin pasanainjee sünain suwarala tü wunu'u jotüsükat: ‘Tayakai, Nümaleiwasekai Abraham, Nümaleiwasekai Isaac, Nümaleiwasekai Jacob’, müshi. ");
INSERT INTO guc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tamüshii paala jia: Chi Maleiwakai, nnojoishi Sümaleiwasein wayuu ouktüsü. Sümaleiwase eekai katüin so'u, süka katüin no'u naya wayuukana nümüin Maleiwa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Müshii joolu'u wane na karalouktamaajanakana: —Ekirajüikalee, lotüsü ma'i tü püküjaitpakat namüin na saduceokana —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mmolüinapa joo na saduceokana je na wayuukana napüshua seema asakiraa Jesús nachikua sünain wane kasa. ");
INSERT INTO guc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aashajaashi joo Jesús sümüin tü wayuukolüirua: —Naashin wane wayuuirua: Chi Cristokai anülia, nuu'uliwo'ulaa ne'e David. ¿Jamüsü sümaka'a tia? ");
INSERT INTO guc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Soto jaa'in nünüiki David, tü nümakat paala sulu'u tü karaloukta kanüliakat Salmos: “Müshi chi Maleiwakai nümüin chi Tasenyotsekai: ‘Kojutshaatashi pia tatüma. Püikkalaa puluwataaiwa tekialu'ujee. So'u wane ka'i, tayamüleerü tü pü'ünüükalüirua süpüla malainjatüin shiairua püpüla’ ”. ");
INSERT INTO guc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Tasenyotsekai” nümüleje'e David nümüin Cristo, ¿jamakuaippalinjachi nuu'uliwo'ulaaka'a ne'e nia? —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aashajaashi joolu'u Jesús namaa na nikirajüinkana sünain saapajüin nünüiki tü wayuukolüirua süpüshua: ");
INSERT INTO guc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Jalia jia suulia ashataa nakuaippa na karalouktamaajanakana waraitteekana ma'i aa'in cha'aya metkaaralu'upünaa sünain kashe'iin naya kuluulu anasü shii'iree nasaküneein sütüma wayuu. Je sulu'u tü ekirajüleekat je sünain wane mi'iraa, ojoyolooshii naya na'aka na laülaayuukana süpüla kojutüinjanain naya sütüma wayuu. ");
INSERT INTO guc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Otta e'ike'etshii wayuu eekai ouktüin su'wayuuse shii'iree naapaweein sükorolo. Je süchikijee, kama'ashii naya sünain nachuntayaain nümüin Maleiwa su'upala wayuu shii'iree kojuteein naya sütüma. Alana'aleejeeria ma'i sünain süsalain naya nütüma Maleiwa saaliijee tia”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nüikkalaakalaka Jesús yala peje sünain tü kojon ejitünakat alu'u tü neerü asülajünüinjatkat nümüin Maleiwa. Ni'rakalaka tü wayuukolüirua washinnuukana sünain ejitaa sünneetse sulu'u. ");
INSERT INTO guc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Süntakalaka wane wayuu müliasü oukta a'wayuuset. Shijitakalaka piamasü neerü kachueerachen ne'e. ");
INSERT INTO guc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nümakalaka Jesús namüin na nikirajüinkana: —Tamüshii paala jia: Alana'aleesia ma'i nümüin Maleiwa tü shijitakat tü wayuukot oukta a'wayuusetkat suuliale'eya tü shijitakat tü wayuukolüirua süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na washinnuukana, nejitüin tü süpütaalakat nanneetse. Alu'usa shiakat, mayaainje müliain ma'i, shijitüin süpüshua tü sünneetse süma'anajatkat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yootüshii waneeirua na nikirajüinkana Jesús sünain namüin: —Anashaatasü ma'i tü a'waajüleekat Maleiwa. Anasü ma'i shipitüin tü ipakat je tü kasa aapuushikat nümüin Maleiwa süpüla anainjatüin shiyolojo yaa sulu'upünaa —müshii naya. Nümakalaka Jesús namüin: ");
INSERT INTO guc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Süpüshua türa ipa ji'rakat joo müinma'a yaa, ojuttinneerü shia mmolu'umüin sünain süsolojüneerüin so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nasakirakalaka na nikirajüinkana: —Ekirajüikalee, ¿joujaleerü sujuttinnaka tü a'waajüleekat Maleiwa? ¿Je kasa shiyaawaseetka wamüin süpüla watüjaainjatüin saa'u sünain sülü'ülüin ka'ikat tia? ");
INSERT INTO guc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nüsouktakalaka Jesús: “Anteerü wayuu wainma sünain maa: ‘Taya'aya Cristokai’, meena. Pülashii naya nütüma Maleiwa naashin. ‘Alü'ütsü sükalia süpüla saja'lajaainjatüin tü kasakat süpüshua’, meena naya. Jalia jia suulia anouja'alaa na'alain na wayuukana, suulia jüüjü'ülaajüin jia sümüin tü nekirajakat anain. ");
INSERT INTO guc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ja'itaina jia aapüin süchiki kasachiki sainküin mmakat süpüshua, nnojo jainkuuin aa'in sütüma. Ja'itakaje tiairua, nnojotsü shiain shiyaawasein sünain süntüitpain tü ka'i saja'lajaainjatkat o'u kasakat süpüshua. Alatüinjatia ne'e kasa eekai müin aka tüü süpülapünaa süntüin ka'ikat tia”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ayatshi Jesús ekirajüin na nikirajüinkana: “Atkaajiraajeerü wayuu sainküin mmakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mülieerü ma'i saa'in wayuu sütüma jamü je sütüma ayuulii sainküin mma. Je akutkujaweerü tü mmakat sainküin mma. Je ainkuujeerü ma'i saa'in tü wayuukolüirua sütüma tü kasa ee'iyataajeetkat chaa iipünaa sirumatu'u. ");
INSERT INTO guc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Otta süpülapünaa sülatüin tü taküjaitpakat achiki jümüin, ata'ünneena jia sütüma wayuu sünain müliain ma'i jaa'in sütüma saaliijee kojutüin tanülia jütüma. Asha'wale'enneena jia sulu'u tü ekirajüleekat namülatu'u na laülaayuukana judíokana süpüla jüsouktüinjanain namüin saa'u tü jünoulakat. Je o'uninneena jia natüma nanainmüin na sülaülashiikana mma süpüla jikerotinneenain natüma sulu'umüin tü kaatsetkat. ");
INSERT INTO guc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Je sükajee jüsoukteenain saa'u tü jünoulakat, atüjaaneechi aa'u taya natüma na sülaülashiikana mma. ");
INSERT INTO guc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Je so'u ka'ikat tia, nnojo jüshapataain aa'in saa'u tü jüsouktüinjatkat aka namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kekiijeena jia tatüma je taapeerü jümüin tü pütchi jüsouktüinjatkat aka namüin na ji'ipolokana. Je iseerü nachiki na'ülüjaain jümaa, süka pansaajeerüin ma'i tü jüsouktiakat ne'ipajee. ");
INSERT INTO guc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aapüneerü jikii nütüma jüshi otta jii je juwalayuu je nütüma chi eekai ja'aleewain. Nnojolii ne'e nayain namüiwa katümasireenain na ji'ipolokana. Je eeshii ja'aka eekai nnojoleenain o'ttooin suulia o'utinnaa aa'in natüma na sülaülashiikana mma. ");
INSERT INTO guc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Je saaliijee jünoujain tanain, maalinjeena jia süpüla wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Akaajasa jiakana, nnojo mmolüin jia seema tü na'ürülakat, süka shiimüin sünain taa'inmajeenain jia noulia. Jünouja jümaala tü tamakat joolu'u jümüin: Nnojoleena jia ayüülajünüin tatüma. ");
INSERT INTO guc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Je müleka jüchecherüle jaa'in su'unnaa tü müliaa ji'rakat, ayateena jia o'tte'ennüin tatüma. ");
INSERT INTO guc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Je wanaa sümaa nashutüin Jerusalénmüin na jü'ünüü gentilekana sümaa suukaajüneerüin tü pueulokot natüma suulia sujuinnajüin wayuu, jütüjaajeerü aa'u sünain sülü'ülüin tia ka'i sujuttinnüinjatkat o'u tü a'waajüleekat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Je so'uweena ka'ikat tia, na wayuu kepiakana sulu'u tü mmakat Judea, anakaja müleka na'luwataale sa'akamüin tü uuchikat süpüla nanujulaainjanain cha'aya. Je tü wayuuirua yaasükat sulu'u Jerusalén, anasü müleka sujuittüle sulu'ujee. Je tü waraittüsükalüirua anooipa'a, anasü müleka nnojorule shikerolüin yala sulu'umüin süpüla asaajaa sükorolo. ");
INSERT INTO guc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","23","‘Aisha'ajaa’ meerü tü wayuu eekai ipoolüin je eekai sütulayülüinya süchon so'u ka'ikat tia, süka kapüleejeerüin ma'i süpüleerua awatawaa. Tüü, shieerü sükaliaka süsalainjatüin saainjala wayuu süpüla shikeraajüinjatüin süpüshua tü ashajünakat achiki paala. Miyo'u ma'i tü müliaa shi'reetkat tü wayuukolüirua sainküin mmakat tüü sütüma nü'ürüla Maleiwa saaliijee saainjala. ");
INSERT INTO guc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","O'utüneerü aa'in wainma wayuu natüma na gentilekana sünain tia atkawaakat. Je eekai apütaain sünain katüin so'u, ata'ünneerü süpüla e'ikajünaa chaa watta sulu'umüin wainma mma naatawai. Je na gentilekana, o'tteena naya sünain laülaain saa'u Jerusalén. Nnojoleena oo'ulaain naya suulia aluwatawaa süma'inru'u ayatüin tü ka'i aapünakat namüin nütüma Maleiwa süpüla aluwatawaa”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","Ayatshi Jesús sünain aküjaa namüin na nikirajüinkana süchiki tü alateetkat so'uweena wane ka'i. Müshi nia namüin: “Akaweeria takalia tayakai, chi Shipayakai Wayuu. Ee'iyataajeerü tü shiyaawasekalüirua eejee chi ka'ikai, chi kashikai, je tü jolotsükalüirua süpüshua, süpüla sütüjaainjatüin saa'u wayuu sünain teitaain. Ojunuwaajeerü tü jolotsükolüirua iipünaajee. Otta yaa mmolu'u, ko'lotüinjeerü ma'i tü palaakat sümaa ko'ontüin shia. Ayo'ujaajeerü saa'in wayuu süpüshua sütüma, süka nnojolüin sütüjaain saa'u tü o'otaainjatkat yaa saa'u mmakat. ");
INSERT INTO guc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Otta so'uweena ka'ikat tia, shi'reechi taya wayuu, tayakai, chi Shipayakai Wayuu, sünain antaa sa'aka wane siruma. Anashaateerü ma'i tü tantiakat, süka tanteechin sünain pülashin je sünain e'itaaushin nütüma Maleiwa süpüla aluwatawaa wanaa nümaa. Je sütüjaajeechi aa'u taya sünain ajütüüshin nütüma Maleiwa süpüla aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Je su'ttapa sünain sükutkujaain tü kasakat chaa iipünaa, anakaja eejeerüle jaa'in sünain tale'ejüinjachin. Nnojolumaateerü mojuin jaa'in, süka taashimaateenain jia suulia kaainjalaa”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nikirajakalaka joo naya süka sukuaippa tü kasa e'nnaajünakat sainküin mma. Müshi Jesús namüin: “Soto jaa'in sukuaippa tü wunu'u ‘higuera’ münakat. ");
INSERT INTO guc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wanaa sümaa iyotüin süpana tü wunu'ukot, jütüjaa aa'ulu sünain sülü'ülüin süpüla sü'itüin iiwa. ");
INSERT INTO guc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aka'aya ji'rapeena tü taküjaitpakat achiki jümüin, jütüjaweerü aa'u sünain sülü'ülüin nükalia Maleiwa süpüla aluwatawaa. ");
INSERT INTO guc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Shiimüin ma'i tü tamakat jümüin, tü wayuu eejeetkat wanaa sümaa ka'ikat tia, nnojoleerü ouktüin süpülapünaa sülatüin süpüshua tü kasa taküjaitpakat achiki jümüin. ");
INSERT INTO guc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Taso'iree aa'inchi jia joolu'u sünain wane kasa: Mayaainje saja'tteerüin tü kasakat cha'aya iipünaa oo'ulaka yaa mmolu'u so'uweena wane ka'i, tü pütchi tekirajapü'ükat anain jia, ayateerü süpüla ka'ikat süpüshua”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Nüso'irakalaka Jesús naa'in na nikirajüinkana süpüla eeinjatüin naa'in sünain nükalia chi Shipayakai Wayuu. Müshi nia namüin: “Shiimüin sünain taluwataajeechin tayakai, chi Shipayakai Wayuu, saa'u tü wayuukolüirua ütamüinre'eya so'uweena wane ka'i. Müleka jülüjüle jaa'in ne'e emi'ijaa, eperuwaa oo'ulaka ekawaa, je müleka jüshapataale aa'in saa'u tü jiküinjatkat, nnojoliishiija'a yapain jia sünain a'atapaa taya sükajee tia. ");
INSERT INTO guc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anakaja müleka jülüjüle jaa'in tü takaliakat waneepia, sümaa jüchuntüin nümüin Maleiwa süpüla süchechennajatüin jaa'in sünain tü jünoulakat su'unnaa tü kasa mojusü alateetkat, suulia japüijain jia tamülatu'u tayakai, chi Shipayakai Wayuu”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Eepü'üshi Jesús so'uka'i sünain ekirajaa wayuu yaa sulu'u tü a'waajüleekat Maleiwa. Shiasa sa'wai, eepü'üshi nia saa'u tü wutaikat kanüliasü Olivos. ");
INSERT INTO guc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Je wainma wayuu antapü'ükat watta'a maalü sulu'umüin tü a'waajüleekat süpüla saapajüin nünüiki. ");
INSERT INTO guc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Alü'ülaasü joo sükalia tü mi'iraakat “Pascua” münakat, ekaanapü'ükat anain tü pan ma'akasatkat soolojia. ");
INSERT INTO guc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Je na laülaashiikana na'akajee na sacerdote judíokana, oo'ulaka na karalouktamaajanakana, nachajaain sukuaippa nu'utia naa'in Jesús. Saa'ujee mmolüin naya neema na wayuu nümaajanakana Jesús, mojusheekalaka shia namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Otta müshia Judas Iscariote, napüshi na polooshiikana piammüin Aluwataaushikana, jüüjüüsü naa'in sümüin nünüiki Satanás chi sülaülashikai yolujaa. Nu'unakalaka Judas nanainmüin na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na sülaülashiikana suwaariase tü a'waajüleekat Maleiwa süpüla naashajaain namaa süchiki aapaa nikii Jesús. ");
INSERT INTO guc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","6","Talatakalaka ma'i naa'in nayakana. “Wawalaajeechi pia müleka pükaaliijüle waya sünain ata'ülaa Jesús sujuuna tü wayuukolüirua nümaakat”, namakalaka nümüin Judas. “Meerüja”, müshi nia sünain nüchajaain sukuaippa aapaa nikii Jesús sujuuna tü nümaajatkat. ");
INSERT INTO guc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Je sünain tü mi'iraakat Pascuakat anülia, antüsü joolu'u tü ka'ikat o'utünakat o'u naa'in wane anneetchon süpüla ekünaa. ");
INSERT INTO guc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nüjütakalaka Jesús Pedro je Juan sünain maa namüin: —Ju'una jumata pueulopa'amüin yapaiwa jütüma tü weküinjatkat sünain tü mi'iraakat —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Jalasü pücheküin süpüleerua wekeraajüin shia? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nüsouktakalaka joo Jesús namüin: —Cha'aya sulu'u tü pueulokot, eejeechi jüpüla wane wayuu alü'üjüshi amüchi sümaa wüin. Ju'una nüchiirua eemüinre nikerolüin sulu'umüin wane miichi. ");
INSERT INTO guc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Meenakalaka jia nümüin chi nipiajachikai: “Aluwataashi nünüiki chi Ekirajüikai süpüla wasakirüin sünain jaralüin tü paü nikaainjatkat alu'u tü Pascuakat namaa na nikirajüinkana”. ");
INSERT INTO guc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nii'iyateerü jümüin wane paü miyo'u saa'ujeesü tia miichikat kalu'usü korolo. Anakaja jikettaajüle tü paükat wapüla —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","O'una müshiija joo naya sulu'umüin tü pueulokat. Ayatsia tü nüküjakat achiki Jesús namüin. Nekeraajakalaka tü paükat süpüla neküinjatüin tü Pascuakat yala sulu'u. ");
INSERT INTO guc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Shiasa joo aipa'a keraapa tü paükat natüma, nüntakalaka Jesús namaa na Aluwataaushikana sünainmüin tü ekawaakat. ");
INSERT INTO guc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O'ttüshi joolu'u Jesús sünain aashajawaa namaa: —Süchuntatüjülia taa'in shii'iree tekeein jümaa tü Pascuakat süpülapünaa te'rüin tamüliala. ");
INSERT INTO guc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Shiimüin sünain nnojoleechin eküin taya tachikua tüü wane'ere'eya süntapa nükalia Maleiwa süpüla aluwatawaa shikeraajapa tü ashajünakat tachiki —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naapaakalaka joo Jesús wane iita kalu'usü wiino sünain naapüin analu'ut nümüin Maleiwa saa'u. Nümakalaka namüin na nikirajüinkana: —Na. Jüsa jümaala wane'ewa'ire jukua. ");
INSERT INTO guc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tamüshii paala jia: Je joolu'u yaajee yaa, nnojoleechi taya asüin tüü tachikua wane'ere'eya tasüin so'uweena wane ka'i cha'aya nüma'anamüin chi Maleiwakai chaa eere nuluwataain. ");
INSERT INTO guc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naapaakalaka wane pan sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshaletakalaka shi'ipawalin shia namüin na nikirajüinkana sünain nümüin namüin: —Maa aka taapüin joolu'u jümüin tü pankat, meechia taya sünain aapajiraain tekii jaa'u jiakana. Tü waa'inrakat joolu'u, süpülajatü jaa'inrüin waneepia süpüla sotüinjachin jaa'in taya —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akaajaa tü naa'inrakat süka tü iitakat kalu'ukot wiino. Süchikijee nekaain, naapaakalaka shia sünain nümüin namüin: —Asüüshikat tüü, anuu jüsüitpain joolu'u, müsü aka sukuaippa tü tasha amülainjatkat süpüla nikeraajüinjatüin chi Maleiwakai tü pütchi jeket pansaatüjütkalia nütüma je süpüla sülatinnajatüin saainjala wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","Ayatüshi Jesús sünain aashajawaa namaa: —Shiimüin sünain to'utinneechin aa'in maa aka tü ashajünakat paala tachiki tayakai, chi Shipayakai Wayuu. Otta chi wayuu aapüinjachikai tekii, alu'uleekaija'a ma'i nia, süsaleechika'a —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Otta na nikirajüinkana, nasakirajiraakalaka sünain jaralin na'akajee chi aapüinjachikai nikii. ");
INSERT INTO guc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Je süchikijee, o'ttüshii naya sünain a'ülüjaajirawaa saa'u jaralin chii miyo'uin na'akajee. ");
INSERT INTO guc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Anuu tü nümakat Jesús soo'opünaa tia: “Na laülaashiikana naa'u na gentilekana, naluwataain naya pejeewa. ");
INSERT INTO guc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Otta jukuaippa jiakana, nnojotsü müinjatüin. Chi wayuu laülaweekai ja'aka, acheküshi jüüjüüinjachin jümüin jüpüshua. ");
INSERT INTO guc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sa'aka wayuu maa'ulu yaa, ¿jarai chi kojutkai atümaa? Aashin niain chi aikkalaakai süpüla ekawaa, nnojoishi niain chi e'ikajüikai eküülü amüinyüü. Alu'ujasa tayakai ja'aka, müshi aka taya saa'in wane e'ikajüi eküülü, süka jüüjüüin jümüin waneepia. ");
INSERT INTO guc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Süka nnojolin jüyüülajüin taya su'unnaa tü müliaa te'rapü'ükat, ");
INSERT INTO guc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","taneeküin jia süpüla tamaainjanain jia cha'aya nümaa Maleiwa. Je süka te'itaanüin nütüma chi Tashikai süpüla aluwatawaa, te'itaweena jia so'uweena ka'ikat tia süpüla aluwatawaa naa'u na wayuu Israelkana, na polooshiikana piammüin e'irukuu, je ekeena jia tamaa cha'aya saa'u sa'aniraaitpain jukuaippa tamaa”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aashajaashi joo Jesús nümaa Pedro: —Tawala Simón, paapa tü taküjainjatkat pümüin. Achuntünüshii jia nütüma Satanás süpüla nuu'ulaküinjatüin jaa'in. ");
INSERT INTO guc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Otta paa'u piakai, achuntüshi taya nümüin Maleiwa süpüla püchecherüinjatüin paa'in sünain tü pünoulakat. Mayaainje püyüülajüinjachin taya, ayaawajaweechi pia paa'in püchikua. Shiasa piyaawajaapa paa'in, anashi müleka pükaaliijüle na puwalayuukana süpüla nanoujainjanain waneepia —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nüsouktakalaka Pedro: —Senyotkalee, nnojoireeja ma'i tayüülajüinjachin pia, ja'itaichi ata'ünnüin taya sulu'umüin tü kaatsetkat, ja'itaichi to'utüneein aa'in saaliijee tanoujain pünain —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro, tamüshi paala pia: So'ule'eya aikat tüü, süpülapünaa ni'yalajüin wane kaliina, aattajiraweechi pia paa'u apünüintua sünain pi'raajüin taya —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Müshi joo Jesús namüin napüshua na nikirajüinkana: —Soto jaa'in tü ka'i taluwataaka'inka o'u paala jia, wanaa sümaa nnojoliin jülü'üjüin jünneetse oo'ulaka jükapateetse oo'ulaka shii'iratia tü jüsapaatsekat. ¿Eesüsa'aya kasa che'ojaaka jümüin jukualu'u? —nümakalaka namüin. —Nnojotsü kasain che'ojaain wamüin —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Asouktüshi Jesús: —Alu'ujasa müinma'a yaa, müleka kanneetsere jia, acheküsü jülü'üjüin. Je müleka kama'anale jia kapateerü, anasü müleka jülü'üjüle. Müleka che'ojaale jümüin chajaruuta süpüla eejirawaa, anashii müleka juikküle tü jüshe'inpalajanakat süpüleerua. Soto jaa'in tü ashajünakat paala tachiki: “Kaainjarai nia saa'in namüin na wayuukana”, müsü. Anashii jütüjaale saa'u tü pütchikat sünain sülü'ülaain shikeraajüin ju'upala —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Senyotkalee, anuu piamasü chajaruuta wama'ana —müshii naya nümüin. Nümakalaka Jesús namüin: —Anasü woo'ulaale joolu'u suulia waashajaain süchiki eejirawaa. ");
INSERT INTO guc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nu'unakalaka joo Jesús namaa na nikirajüinkana eemüin tü wutaikat “Olivos” münakat eepü'üle noutkajaapü'üin. ");
INSERT INTO guc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Je nantapa chamüin, nümakalaka Jesús namüin: —Anashii müleka jüchuntüle joolu'u nümüin Maleiwa suulia nuu'ulakajüin jaa'in Satanás —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nükatalaakalaka joo Jesús noulia na nikirajüinkana mamüin aka tüsa sünain nüsapainkain nia süpüla aashajawaa nümaa Maleiwa: ");
INSERT INTO guc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taata Maleiwa, müleka pücheküle, anasüje puu'ule'erüle toulia tü müliaa te'reetkat joolu'u. Akatsa nnojolüin shiainjatüin paa'inrüin tü tachekakat ne'e tamüiwa, shia paa'inrüinjatka tü püchekakat tapüleerua”, nümakalaka Jesús nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Nüntakalaka joo wane aapiee nüma'anajee Maleiwa süpüla nüchecherüinjatüin naa'in Jesús, süka mojuin ma'i naa'in sünain achuntaa nümüin Maleiwa. Keraawataashi Jesús, mataasü aka saa'in isha tü nirakat sünain shipittüin mmolu'umüin. ");
INSERT INTO guc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Shiasa süchikijee naashajaain nümaa Maleiwa, nüsha'walaakalaka sünain nürütkaain nanainmüin na nikirajüinkana eere natunkaja'attaain nüpüla saa'ujee mojuin ma'i naa'in nayakana. ");
INSERT INTO guc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Jamüshii jia jutunkajaka'a ma'i? Jütamaajaa jumaala. Anashii müleka jüchuntüle joolu'u nümüin Maleiwa suulia nuu'ulakajüin jaa'in Satanás —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wanaa sümaa naashajaain Jesús namaa na nikirajüinkanairua, nantapaatakalaka wane wayuuirua wainma nüchiiruajee Judas chi napüshikai na polookana piammüin. Nürütkaakalaka nünainmüin Jesús sünain nuusajüin nia. ");
INSERT INTO guc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nümakalaka Jesús nümüin: —Judas, ¿paapüinra ma'i tekii süka wane achu'nnaa, tayakai, chi Shipayakai Wayuu? ");
INSERT INTO guc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na nümaajanakana Jesús, nayaawatapa aa'u tü alatajatkat nümüin, müshii joolu'u: —Senyotkalee, ¿acheküsü wayuutüin wachajaruutse noo'omüin? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nuwatakalaka wane chi nikirajüinkai Jesús noo'omüin wane nüchepchia chi laülaashikai napüleerua na sacerdote judíokana. Nüchoto'oleekalaka tü nüche'e nikialu'ujeejatkat. ");
INSERT INTO guc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—Juu'ulaa jümata suulia tü jashieekat —nümakalaka Jesús namüin sünain ni'itaain najapü saa'u nüche'e chi wayuukai süpüla anain süchikua. ");
INSERT INTO guc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Je nünüiki Jesús namüin na antakana nünainmüin, na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na sülaülashiikana suwaariase tü a'waajüleekat oo'ulaka na laülaashiikana naa'u na judíokana: —¿Ka'ruwaraiyaa taya jaa'inru'u jüntakalaka tanainmüin sümaa wunu'u oo'ulaka chajaruuta jajapulu'u süpüla jüta'ülüinjachin taya? ");
INSERT INTO guc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿Jamüshi nnojoika'a jüta'ülüin taya paala cha'aya sulu'u tü a'waajüleekat Maleiwa eere tekirajapü'üin ju'upala? Antüshii jia tanainmüin joolu'u süse'eru'upünaa ai, süka jüüjüüin jia sümüin nünüiki Satanás chi sülaülashikai piyuushi —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nata'ülakalaka Jesús sünain no'unirüin nia yalajee nipialu'umüin chi laülaashikai napüleerua na sacerdote judíokana. Otta müshia Pedro, nünanajakalaka nüchiirua ka'yatalu'ujee. ");
INSERT INTO guc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Shiasa nantapa chamüin cha'aya sulu'umüin nüpaatiase chi laülaashikai, achuwajaashii siki pasanain sünain tü paatiakat eere joyojoyolüin naya sü'ütpa'a. Otta müshia Pedro, ojoyolooshi na'aka. ");
INSERT INTO guc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Je wane nüchepchia chi laülaashikai, shi'rüin Pedro so'u suwarala tü sikikat. Shiirakaakalaka ma'i nia. —Nia'asa chi nümaapü'ükai chi ata'ünnakai chii —sümakalaka namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Otta müshia Pedro, naattajaakalaka suulia tü wayuukot: —Nii waa'iraa, nnojoishi te'raajüin chi pümakai tamüin —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Shiasa mapa, niirakaakalaka joo wane wayuu nümüin Pedro sünain nümüin nümüin: —Aashin piayaain wane nütünajut chi wayuukai ata'ünnakai. Nüsouktakalaka Pedro nümüin: —Nnojo, nnojoishi tayain —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Shiasa mapa, maa aka wane oora süchikijee, nümakalaka emetut wane wayuu: —Shiimüin sünain nümaapü'üin chira wayuukai, süka Galileaje'ewalin nia wanaa nümaa. ");
INSERT INTO guc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nüsouktakalaka Pedro: —¿Kasakai wayuu tia? Nnojoruleeja tatüjaain aa'u tü paashajaakat achiki —nümakalaka. Shiasa wanaa ma'i sümaa naashajaain Pedro, akootole'erajaashi chi kaliinakai. ");
INSERT INTO guc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Otta müshia chi Senyotkai yaa ka'yatalu'u nünain Pedro, nujununtaakalaka sünain niirakaain ma'i nümüin Pedro. Sotokalaka naa'in Pedro tü nümakat Jesús paala nümüin: “So'ule'eya aikat tüü, süpülapünaa ni'yalajüin wane kaliina, apünüintueechi taya punujulajüin achiki sünain pi'raajüin taya”. ");
INSERT INTO guc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nujuittaakalaka Pedro yalajee yala sünain mojuin ma'i naa'in. Miyo'u ma'i ni'ira sünain a'yalajaa. ");
INSERT INTO guc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Je na wayuukana ata'ütkana Jesús, o'ttüshii sünain neme'erainpalain nia je sünain nashe'ejüin nia. ");
INSERT INTO guc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne'itaain wane kuluulu nu'upa'apünaa sümaa namüin: —Müleka chajeejachire pia eejee Maleiwa, püshantaja saa'u jaralin ashe'etüin pia —namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E'rüshii ma'i wayumüin sulu'u nanüiki nümüin. ");
INSERT INTO guc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Shiasa mapa ja'yuupa, outkajaashii napüshua na laülaayuukana. Eeshii na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana. O'uninnüshi Jesús nanainmüin süpüla nüsakiijünüinjachin natüma. ");
INSERT INTO guc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Shiimüinjasa sünain piain Cristoin Nüneekajalakai Maleiwa? Pükaja wamüin —namakalaka na laülaayuukana nümüin. Nüsouktakalaka Jesús ne'ipajee: —Müleka “taya'aya” tamüle jümüin, nnojoleerü jünoujain tanüiki. ");
INSERT INTO guc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Je müleka jiale asakinnüin tatüma sünain wane kasa, nnojoleena asouktüin jia te'ipajee. ");
INSERT INTO guc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Je joolu'u mapeena, eejeechi taya, chi Shipayakai Wayuu, nümaa Maleiwa Pülashikai sünain joyotüin nikialu'ujee, saa'u kojutüin taya nütüma —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nasakirayaakalaka nia nüchikua: —¿Pia chi Nüchonkai Maleiwa paajüin? —namakalaka nümüin. —Aa, shiimüin sünain tayain chi jümüichipakai achiki —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—Waapüitpa'asa nünüiki sünain niain chi Nüneekajalakai Maleiwa naajüin, chi Nüchonkai Maleiwa naajüin. Nnojolüitpa che'ojaain wayuu wamüin aküjüinjatkat nüchiki süpüla kasalajanainjatüin tü nümakat watüma —namakalaka joo na laülaayuukana. ");
INSERT INTO guc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nasha'walaakalaka joo na laülaayuukana napüshua süpüla namaainjachin Jesús eemüin Pilato chi Romaje'ewaikai sülaülashikai tü mmakat Judea so'u ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","O'ttüshii joo naya sünain aküjaa na'alain nümüin Pilato sünain kaainjaralin Jesús naajüin. Anuu tü namakat: —Nikirajüin tü wayuukolüirua süpüla kanainjachin saa'in chi Césarkai je süpüla nnojolüinjatüin saapüin tü neerü nüchuntakat wamüin. Müle'o ma'i tü e'raakat wayumüin nüma'ana. Nia Cristokai naashin, wane aluwataai, süka chajeejachin nia eejee Maleiwa naashin. ");
INSERT INTO guc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nüsakinnakalaka Jesús nütüma Pilato: —¿Pia'aya chi Aluwataashikai saa'u wayuu judío? Nüsouktakalaka Jesús: —Shia'aya tia pümakat. ");
INSERT INTO guc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nüküjakalaka joo Pilato namüin na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka sümüin tü wayuukolüirua eejatkalüirua: —Nnojotsü tantüin anain wane aainjalaa nünain süpüla süsalainjachin nia tatüma saa'ujee —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Masütaajusalii joo naya sünain mojuin nanüiki nümüin Jesús: —O'ttüshi nia sünain ekirajaa wayuu cha'aya Galilea, je antüichipa yaamüin yaa Jerusalénmüin süpüla sütkaajiraainjatüin tü wayuukolüirua süpüshua yaa sulu'u tü mmakat Judea sütüma tü nikirajakat anain sümüin —namakalaka nümüin Pilato. ");
INSERT INTO guc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Je Pilato, sütüma tü namakat nümüin, nüsakirüin naya sünain müleka cheje'ewaire Jesús Galileajee. ");
INSERT INTO guc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mayaashi nütüjaain saa'u sünain Galileaje'ewalin nia, nüjütakalaka nia nünainmüin Herodes chi sülaülashikai Galilea, süka yalajachin nia Jerusalén wanaa sümaa tia. ");
INSERT INTO guc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Talatüsü ma'i naa'in Herodes nüntinnapa Jesús nünainmüin. Saa'u naapapü'üin nüchiki, ni'reepü'üin ma'i nia. Ni'reein süpüla naa'inrüinjatüin Jesús nu'upala wane kasa nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kama'a ma'i Herodes sünain nüsakirayaain Jesús. Otta müshia Jesús, nnojoishi asouktüin. Ko'uu müshi nuulia. ");
INSERT INTO guc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Otta na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na karalouktamaajanakana, sha'washawatshii nü'ütpa'a Herodes sünain emetuluin nanüiki, “Wayuu kaainjarai nia”, sünain namüin nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Püla aa'inchii Herodes oo'ulaka tü nüsurulaatsekalüirua nuulia Jesús. Na'atakalaka wane ashe'inyüü anasü nünain, maa aka saa'in nüshe'in wane aluwataai saa'u mma, süpüla neme'erainpalain nia. Nüjütakalaka nia nüchikua nünainmüin Pilato. ");
INSERT INTO guc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Je paala, mojaawapü'üshi Herodes nümaa Pilato. Anaawaleeshii naya so'u ka'ikat tia. ");
INSERT INTO guc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nükotchajaakalaka joolu'u Pilato na laülaashiikana na'akajee na sacerdote judíokana je na laülaayuukana je tü wayuukolüirua ");
INSERT INTO guc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sünain nümüin namüin: —Aashin jüntirüin chi wayuukai tamüin, sünain nikirajüin tü wayuukolüirua süpüla kanainjachin saa'in César jaajüin. Saa'in tamüin, süchikijee tasakirüin nia ju'upala, nnojotsü tantüin anain tü naainjala jüküjakat achiki tamüin. ");
INSERT INTO guc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Akaajaa Herodes, nüle'ejirüin chi wayuukai wanainmüin nüchikua, süka nnojolin nüntüin sünain wane kaainjalaa nünain. Akaajaa jiakanaya, jütüjaa aa'uchi sünain nnojolüin wane aainjalaa süpüla waapüinjatüin nikii sünain ouktaa. ");
INSERT INTO guc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anashi tajütirüle nia süchikijee ta'yaajirüin —nümakalaka Pilato namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Eesü wane kasa naa'inrapü'üin Pilato su'unna'awai tia mi'iraakat. Nujuittirapü'üin wane püreesashi namüin na judíokana. ");
INSERT INTO guc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Eejachikalaka wane püreesashi kanüliashi Barrabás. Ata'ünnüshi nia saaliijee nütke'erüin wayuu nümaa chi sülaülashikai mma cha'aya Jerusalén je saaliijee o'utaa saa'in wayuu.) Namakalaka joo na wayuukana süka nekiisa nümüin Pilato: —Pu'uta naa'in Jesús. Püjüta nüchiki Barrabás. ");
INSERT INTO guc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Naashajaakalaka joo Pilato namaa na wayuukana nüchikua shii'iree nüjütireein Jesús. ");
INSERT INTO guc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Otta na wayuukanairua, nayouktüin nüjütünüinjachin. —Püchitira saa'u kuruusa —namakalaka sünain a'waataa. ");
INSERT INTO guc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naashajaakalaka Pilato namaa nüchikua, apünüintuairü süka tüü. Nümakalaka namüin: —¿Jamüshi takacherirüinjachika'a nia? ¿Kasa naainjalaka? Nnojotsü tantüin anain wane naainjala süpüla taapüinjatüin nikii süpüla ouktaa. Anashi tajütirüle nia süchikijee ta'yaajirüin. ");
INSERT INTO guc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Otta müshi'iya na wayuukanairua, masütaajusalii sümaa nekiisa: —Püchitira saa'u kuruusa. Nountakalaka noonooin Pilato sümaa tü nachuntakat. ");
INSERT INTO guc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","—Taa'inreerü tü jüchuntakat tamüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naapünakalaka Jesús süpüla aa'innüinjatüin nüka tü kee'ireekat naa'in nayakana. Otta chi wayuukai püreesashikai saa'u nütke'erüin paala wayuu je saa'u nu'utüin saa'in wayuu, chi “anashi nüjütünüle” namakai paala na wayuukana, nujuittinnakalaka chi wayuukai nütüma Pilato. ");
INSERT INTO guc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wanaa sümaa nu'uninnüin Jesús sütüma wane surulaalüirua eemüinjachire nükachennüinjachin natüma, antüshi Jerusalénmüin wane wayuu Cireneje'ewai kanüliashi Simón. Nüta'ünnakalaka joo natüma na surulaatkana süpüla nülü'üjainjatüin tü wunu'ukot nüchiirua Jesús, tü akachennüinjachikat anain nia. ");
INSERT INTO guc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Je sa'aka tü wayuu wattakat saalii o'unakat nüchiirua Jesús, eesü wane jieyuuirua sünain shi'yalajüin emetut ma'i naalii. ");
INSERT INTO guc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nujununtaakalaka Jesús nanainmüin na jieyuukana süpüla nümüinjatüin namüin: —Jia jieyuukana Jerusalénje'ewaliikana, nnojo ji'yalajüin taalin. Ji'yalajaa jaa'u jiakana je saa'u jüchonnii. ");
INSERT INTO guc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","E'reena jia müliaa so'uweena wane ka'i. Je so'u ka'ikat tia, “Alana'aleekatche anaa sümüin tü machonsatkalüirua”, meena jia süka nnojoleerüin shi'rüin o'utinnüin aa'in süchon. ");
INSERT INTO guc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Je sünüiki wayuu süpüshua so'uweena tia: “Anasüje sujuttüle tü uuchikalüirua waa'u”, meerü süka mülo'ujeerüin ma'i tü müliaakat namüin. ");
INSERT INTO guc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Shiimüin sünain eein tü müliaakat jüma'ana maa'ulu yaa, mayaainje eein taya ja'aka. Otta süchikijee to'unapa juulia, alana'aleejeena ma'i jia sünain müliaa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Je nümaa Jesús, o'uninnüshii piamashii wayuu kaainjaralii o'utünüinjanakana aa'in wanaa nümaa. ");
INSERT INTO guc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Je nantapa chaa eemüin wane wutai kanüliasü “Ekiyüükat”, nükachennakalaka Jesús oo'ulaka na piamashii kaainjaralii. E'itaanüshi wane nikialu'ujee oo'ulaka wane nüpe'eru'ujee. ");
INSERT INTO guc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nümakalaka Jesús nümüin Maleiwa: —Taataa, anashi müleka pülatirüle naainjala noulia na aa'inrakana tamüin tüü, süka nnojoliin natüjaain saa'u tü naa'inrakat taka —nümakalaka. Je na surulaatkana, nashantanajiraakalaka saa'u tü nüshe'inkat süpüla natüjaainjatüin saa'u jaralin makatüinjachin apüla süpüshi tü nüshe'inkat wane'ewai nakua. ");
INSERT INTO guc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ananajüsü tü wayuukolüirua naa'u Jesús wanaa sümaa nükachennüin sünain kuruusa. Otta na sülaülakana judío, neme'erainpalashi nia sünain namüin nümüin: —Müleka piale chi Cristokai anülia, chi Nüneekajalakai Maleiwa, ¿jamüshisa nnojoika'a pu'tte'erajiraain pümüiwa maa aka pu'tte'erapü'üin wayuu paashin? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Akaajaa tü surulaatkalüirua, naapüin wane asüüshi jashü'üsü nümüin sünain neme'erainpalain nia. ");
INSERT INTO guc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Müleka piale chi Aluwataashikai saa'u tü judíokolüirua, ¿jamüshisa nnojoika'a pu'tte'erajiraain pümüiwa? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Eesü wane ashajuushi kachetüsü iipünaa sünain tü kuruusa kanainkat Jesús. Müsü mayaa: ANII CHI ALUWATAASHIKAI SAA'U WAYUU JUDÍO. ");
INSERT INTO guc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Niasa wane chi kaainjaraikai kachetüshikai wanaa nümaa Jesús, mojukalaka nünüiki nümüin: —Pu'tte'erajiraa pümüiwa, süka piain Cristoin anülia paashin, chi Nüneekajalakai Maleiwa. Oo'ulaka pu'tte'erale'eya waya wanaa pümaa —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Otta müshia chi nuwala'atakai chi kaainjaraikai, nüchiajaakalaka nia sünain nümüin nümüin: —¿Jamüshikai pia nnojoikalaka kojutüin pütüma Maleiwa sümaa ouktajanain waya wanaa nümaa chii? ");
INSERT INTO guc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wayakana, maa aka müliain waya yaaya, süsalashii waainjala. Otta niakai, nnojotsü kasain naainjalain —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Je nünüiki nümüin Jesús: —Jesúsuu, motojoyoo taya paa'in pu'ttapa sünain aluwatawaa chamüin. ");
INSERT INTO guc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nümakalaka Jesús: —Shiimüin tü tamakat pümüin: Joolu'u, cheechi pia tamaa cha'aya “paraíso” —nümakalaka Jesús nümüin chi kaainjaraikai. ");
INSERT INTO guc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Shiasa maa aka kale'o, epiyuushijaasü mmapa'akat süpüshua awasaja'aleesia maa aka aliika. Je sulu'u tü a'waajüleekat Maleiwa, asüküijaasü pasanainpünaa sünain tü kuluulu so'ulujunakat tü paü shiinalu'usükat. ");
INSERT INTO guc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nu'waatakalaka emetut Jesús nümüin Maleiwa: —Taataa, taapüin pümüin chi taa'inkai süpüla paa'inmajüinjachin —nümakalaka. Je keraapa tü nünüikikat, ouktalaa müshi. ");
INSERT INTO guc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Je chi sülaülashikai surulaat, saa'u ni'rüin tü alatakat nümüin Jesús, nu'waajüin Maleiwa: —Shiimüinyala ma'i nia sünain maainjalaa —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Je tü antüsükalüirua sünain e'rajaa naa'u Jesús, o'unüshii naya yalajee sünain mojuin ma'i naa'in saa'ujee tü ne'rakat. ");
INSERT INTO guc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Otta na wayuukana e'raajakana Jesús oo'ulaka na jieyuukana nümaajanakana Galileajee, makatüshii naya sha'washawalüin ka'yata sünain ananajaa naa'u. ");
INSERT INTO guc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Je na'aka na laülaashii sulujunakana tü kanüliakat Sanedrín, eeshi wane wayuu kanüliashi José, cheje'ewai Arimatea yaa sulu'u tü mmakat Judea. Wayuu anamia nu'upala Maleiwa sümaa na'atapajüin nükalia Maleiwa süpüla aluwatawaa. Nnojotsü wanaawain naa'in José sümaa tü aa'innakat nüka Jesús sütümairua tü sülaülakat judío wanaa nümaa. ");
INSERT INTO guc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O'unamaatüshi José eemüin Pilato süpüla achuntaa e'ikaa müliashii. ");
INSERT INTO guc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nüshakatirakalaka müliashii sünainjee tü kuruusakat. Nüko'olokalaka nia süka wane kuluulu kojutsü kanüliasü “lino”. Eejatüja'a wane woowira akumajiruushi paala nütüma José sulu'u wane ipa miyo'u. Me'itaajuyülia aamakaa sulu'u. Ni'itaakalaka müliashii sulu'u tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Je tü ka'i ouktakat o'u Jesús, shia tü ka'i sü'lakajaakat o'u shiküin tü wayuukolüirua süpüla tü ka'i sheemeraainjatkat o'u. E'itaanüshi Jesús motsapa ka'ikat. Alü'ütchonsü süpüla su'ttüin tü eemerawaakat. ");
INSERT INTO guc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Je na jieyuukana nümaajanakana Jesús chajee Galileajee, o'unüshii nüchiirua José, sünain ne'rüin tü woowirakat oo'ulaka chi müliashiikai wanaa sümaa e'itaanüin sulu'u. ");
INSERT INTO guc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nale'ejakalaka Jerusalénmüin sünain nekeraajüin wane wunu'u jemeta eejuut nüpüla chi müliashiikai. Je so'u tü ka'i eemeraanakat o'u, eemeraashii naya, süka shiain tü nuluwataakat anain Maleiwa paala sümaiwa. ");
INSERT INTO guc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Shiasa ja'yuumüin süchikijee tü ka'i neemeraakat o'u na judíokana, no'unakalaka na jieyuukana eemüin tü woowirakat eejachire ni'itaanüin Jesús. Nalü'üjüin tü wunu'u jemetakat eejuut nekeraajakat paala. ");
INSERT INTO guc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Shiasa nantapa chamüin, nanta anainrü süsünne'eruushin tü ipa shirousekat. ");
INSERT INTO guc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Shiasa nekerolapa sulu'umüin tü woowirakat, nnojoikalaka nantüin nünain chi müliashiikai, chi Senyotkai Jesucristo. ");
INSERT INTO guc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nnojotsü natüjaain aa'u nekii sütüma tü ne'rakat. Eeraa namakalaka wane piamashii tooloyuu na'ütpa'amüin. Jorojorotsü ma'i tü nashe'inkat. ");
INSERT INTO guc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sainkuukalaka ma'i naa'in na jieyuukana sünain nomorolooin napüleerua na wayuukana. Nasouktakalaka na wayuukana namüin: —¿Kasa jaainjaka jüchajaaka'a wane wayuu kato'uchi sa'aka ouktüsü? ");
INSERT INTO guc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nnojoishi nia yaaya. Oso'iraaitpa naa'in nüchikua. Soto jaa'in tü nümakat paala jümüin chaiwa'aya nia jümaa cha'aya Galilea: ");
INSERT INTO guc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Tayakai, chi Shipayakai Wayuu, aapüneechi ekii taya sümüin wayuu kaainjarat süpüla nakacherüinjachin taya süpüla ouktaa. Je nulu'u chi apünüinkai ka'i süchikijee tia, oso'iraajeerü taa'in”, tü nümakat paala jümüin. Shiairia nanüiki na wayuukana tüü namüin na jieyuukana. ");
INSERT INTO guc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Shiasa na jieyuukana, sotoloo müsü naa'in tü nümakat Jesús paala namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Je nale'ejapa na jieyuukana chajee eejee tü woowirakat, naküjakalaka süchiki tü ne'rakat namüin na Aluwataaushikana polooshiikana waneemüin je namüin na nikirajüinkana Jesús napüshua. Eejatü María Magdalena, eejatü Juana, eejatü María tü niikat Jacobo oo'ulaka natünajutüirua namaa. ");
INSERT INTO guc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Otta naapapa nanüiki na jieyuukana, nnojotsü nanoujain tü naküjakat namüin süka nnojolüin shiimüin saa'in namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Otta müshia Pedro, nüsha'walaakalaka sünain nuwataain sünainmüin tü woowirakat. Je nüntapa chamüin cha'aya, nejepülaakalaka süpüla niirakaain sulu'upünaa. Ni'rakalaka tü kuluulu oko'ojünakat aka müliashii yaa jachitüin sümüiwa. Nüle'ejakalaka nüchikua nipialu'umüin sünain müin jalapa'akai naa'in sütüma tü ni'rakat. ");
INSERT INTO guc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Shiasa süchikijee naküjain na jieyuukana süchiki tü ne'rakat, ojuittüshii piamashii na nikirajüinkana Jesús chaa eemüin wane pueulo kanüliasü Emaús, maa aka poloo “kilómetro” su'unia yalajee Jerusalénjee. ");
INSERT INTO guc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Je nakuo'u sümaa waraittüin sulu'u wopu, aashajaajiraashii süchiki tü kasa alatakat nüka Jesús. ");
INSERT INTO guc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Je wanaa sümaa yoonatüin naya, nürütkaakalaka Jesús nanainmüin süpüla waraittüin namaa. ");
INSERT INTO guc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mayaainje waraittüin nia namaa, nnojoishi nayaawatüin. ");
INSERT INTO guc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nüsakirakalaka naya Jesús: —¿Kasa jaashajiraaka achiki sulu'u wopu? —nümakalaka namüin. Otta nayakana, nasha'walaakalaka sünain mojuin ma'i naa'in. ");
INSERT INTO guc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nüsouktakalaka chi wane kanüliashikai Cleofas: —¿Piaja neje chi waneeshikai wayuu sulu'u Jerusalén sünain matüjaain saa'u tü kasachikikat? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Kasa kasachiki alataka? —nümakalaka Jesús namüin. —Shia tü alatakat nümüin Jesús chi Nazaretje'ewaikai, nünüikimaajachikai Maleiwa. Pülashi ma'i nia nütüma Maleiwa süpüla naa'inrüinjatüin kasa anasü su'upala wayuu wainma je süpüla nüküjainjatüin tü anasükat namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Otta na laülaashiikana na'akajee na sacerdote judíokana oo'ulaka na walaülayuukana, naapa ekiichi süpüla nu'utinnüinjachin aa'in. Shiimüin sünain we'rüin nia nükachennüin süpüla ouktaa. ");
INSERT INTO guc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Otta wayakana Israelkana anülia, wa'atapajüin sünain niain taashinjanain atüma waya noulia na wayuu Romaje'ewaliikana. Je apünüinrü joo ka'i süchikijee ouktüin nia. ");
INSERT INTO guc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Eesüyaaje wane jieyuuirua wa'akajee, o'unüshii naya watta'a maalü eemüin tü woowirakat, nnojoliikalaka nantüin nünain chi müliashiikai. Ainkuusü ma'i waa'in sütüma nanüiki nale'ejapa wanainmüin. Ne'rüin naashin wane aapieeirua nüma'anajeejatü Maleiwa, na aküjakana namüin nüchiki Jesús sünain katüin no'u. ");
INSERT INTO guc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Je süchikijee tia, o'unüshii wane watünajutüirua eemüin tü woowirakat. Ayatsia ne'rüin maa aka naküjain na jieyuukana wamüin. Ja'itakaja nayakana, nnojoishi nantüin anain —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Nüsouktakalaka Jesús: —Maa'inkanache aa'in jia, nnojoliikalaka jünoujain tü naküjapü'ükat paala na nünüikimaajanakana Maleiwa sünain mülieechin Cristo, chi Nüneekajalakai Maleiwa, süpülapünaa nu'unüin nüma'anamüin Maleiwa sümaa kojutüinjachin nia nütüma —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nüküjakalaka namüin tü ashajünakat nüchiki sulu'u tü karaloukta nüchikimaajatkat Maleiwa, o'ttüin sünainjee tü ashajuushikat nütüma Moisés je sulu'upünaa tü ashajuushikat natüma na nünüikimaajanakana Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Je nalü'ütpa sünainmüin tü pueulokat ee'ewaliire naya, nnojoishiyaaje ajuntaweein Jesús namaa. ");
INSERT INTO guc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Neme'ejakalaka naa'in süpüla makatüinjachin nia namaa: —Anakaja müleka we'iyoule pia süka motsoirüin ka'ikat —namakalaka nümüin. Je süka nounejaain nia nepialu'umüin, nujuntaakalaka Jesús sulu'umüin tü pueulokat namaa. ");
INSERT INTO guc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Je sünain joyotüin nia namaa sünain ekawaa, naapaakalaka wane pan sünain naapüin analu'ut nümüin Maleiwa saa'u. Nüshaletakalaka shia shi'ipawai namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nayaawatalaa namakalaka nia. Shiasa wanaa sümaa niyaawatünüin Jesús natüma, motu'ulaa müshi noulia. ");
INSERT INTO guc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naashajaajiraakalaka na nikirajüin piamashiikana: —Keenairüje talatashaanain ma'i waa'in wanaa sümaa naashajaain wamaa sulu'u tü wopukot sünain nikirajüin waya sünain tü pütchi nüchikimaajatkat Maleiwa —namakalaka. ");
INSERT INTO guc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","O'una müshi'iya naya nachikua Jerusalénmüin. Eekalaka napüla na polooshiikana waneemüin Aluwataaushikana sünain jutkataa namaa waneeirua na nikirajüinkana Jesús. ");
INSERT INTO guc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sümünakalaka namüin natüma na polooshiikana waneemüin: —Shiima'inya sünain nüso'iraain aa'in chi Senyotkai, je ee'iyataaichipa nümüin Simón —müshii namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Otta na nikirajüinkana piamashiikana, naküjakalaka joolu'u nüchiki Jesús sünain wanaain namaa sulu'u wopu: “Müshi aka wane eekai mochoojüin wo'u. Shiasa wanaa sümaa wekaain nümaa, wayaawatalaa müshi”, namakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Shiasa nnojolüiwa'aya kettaain nanüiki, ee'iyata'alaa müshi Jesús yaa pasanain nanain. —Kasataalejese anain jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Shiyo'ujaakalaka ma'i naa'in nayakana. Epeinjaayaashi naashin. ");
INSERT INTO guc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nümakalaka Jesús namüin: —¿Jamüshii jia jiyo'ujaaka'a aa'in? ¿Jamüshii jia wainmaka'a saashajaala jaa'in? ");
INSERT INTO guc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jiirakaa tamüin, müsia sümüin tajapü je too'ui. Ke'irukushi taya. Keimseshi taya. Jipetta taya jütüjaaiwa taa'u sünain shiimüin sünain tayain. Nnojoishi epeinjaashin taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Je süchikijee naashajaain Jesús, nii'iyatüin najapü, nii'iyatüin nuu'ui namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Patatshii ma'i naya sümaa talatüin naa'in sütüma tü ne'rakat. Isasü nachiki nanoujain sünain nüso'iraain aa'in. Müshi joo Jesús namüin: —¿Eesü eküülü jüma'ana? ");
INSERT INTO guc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Saapünakalaka wane jime asijuushi nümüin. ");
INSERT INTO guc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naapaakalaka shia sünain niküin no'upala. ");
INSERT INTO guc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ayatshi Jesús sünain aashajawaa namaa: —Ekettaajüitpa joo tü ashajünakat tachiki paala nütüma Moisés je natüma na nünüikimaajanakana Maleiwa je sulu'u tü jayeechikalüirua ashajünakat nütüma David. Tü ji'rakat, shia tü taküjapü'ükat achiki jümüin jümaaiwa'aya taya —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Süpüla nükaaliijüinjatüin na nikirajüinkana sünain ayaawataa saa'u tü ashajünakat paala sulu'u tü karaloukta nüchikimaajatkat Maleiwa, ");
INSERT INTO guc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","nümakalaka Jesús namüin: —Taya'aya chi ashajünakai achiki paala sünain müin yaa: “Müliainjachi Cristo, chi Nüneekajalakai Maleiwa. O'utinneechi aa'in. Oso'iraajeerü naa'in so'u apünüin ka'i süchikijee ouktaa. ");
INSERT INTO guc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Je aküjüneerü nüchiki sümüin wayuu süpüshua shii'iree shiyaawajaainjatüin suulia saainjala süpüla sülatinnüinjatüin tü saainjalakat suulia nütüma Maleiwa. Je o'tteerü tü aküjaakat nüchiki sulu'ujee Jerusalén”. Shia'aya ashajuushikat tüü. ");
INSERT INTO guc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Je joolu'u jiakana tekirajüinkana, jüküjeerü sümüin wayuu süpüshuale'eya tü ji'rapü'ükat. ");
INSERT INTO guc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Süpüla takaaliijüinjanain jia sünain tüü, taluwataajeechi maalü chi Naa'inkai Maleiwa jümüin. Nia chi nümakai achiki chi Tashikai sünain pansaain nünüiki sünain naapüinjachin nia jümüin. Anashi müleka ja'atapajüle nia ya'aya Jerusalén. Mülo'ujeerü pülaa jaa'u nütüma nüntapa jünainmüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eenajaanüshii joo naya nütüma Jesús yalajee Jerusalénjee chamüin sü'ütpa'amüin Betania. Je nantapaapa chamüin, achuntüshi nia na'anasia Maleiwa naa'u na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wanaa sümaa nüchuntüin nümüin Maleiwa, ayalennüshi na'akajee nüma'anamüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Otta na wayuukana, na'waajashaatain nia kama'alu'u. Yalejee yala, nale'ejakalaka nachikua Jerusalénmüin sünain mülo'uin ma'i talataa sulu'u naa'in. ");
INSERT INTO guc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Je süchikijee tia, ayatshi'iya naya outkajaain waneepia sulu'u tü a'waajüleekat Maleiwa sünain na'waajüin nia.");
INSERT INTO guc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jesucristo, kanüliashi “Pütchi” münüin. Eetüjü'iya nia paala sümaiwa nnojolüiwa'aya kasain eein soo'opünaa tü mmakat. Nümaatüjü'iya Maleiwa sünain wanaawain nia nümaa. ");
INSERT INTO guc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nümaashi Maleiwa waneepia paala sümaiwa je mayülinja'a nia sünain nümawaa. ");
INSERT INTO guc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E'itaanüshi nia nütüma Maleiwa sümaiwa paala sünain nükumajüinjatüin tü kasakalüirua süpüshua. Nnojotsü kasain eein eekai nnojolüin akumajuushin nütüma. ");
INSERT INTO guc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nia ee'iranajaaka atüma saa'in wayuu. Je müshi aka nia saa'in wane anakia. Maa aka ja'yain süpüna wayuu sütüma nuwarala chi ka'ikai, akaajaa chi wayuu ee'iranajaaichipakai aa'in nütüma, niyaawateerü aa'u tü shiimüinkat. ");
INSERT INTO guc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Maa aka ja'yain süpüna wayuu watta'a maalü ja'itairü kojoin paala tü piyuushikat, akaweeria tü shiimüinkat ayaawatüneerü aa'u ja'itasü joulüin tü aainjalaakat. ");
INSERT INTO guc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Shiasa so'u wane ka'i, nüntakalaka joo wane wayuu kanüliashi Juain sa'akamüin wayuu. Ajütünüshi nia nütüma Maleiwa ");
INSERT INTO guc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","süpüla niainjachin aapirüin wayuu süpüshua sünain niweetajachin Cristo, chi anaküinjachikai süpüna wayuu. Otta Juan, nime'ejakalaka saa'in wayuu süpüla sünoujainjatüin nünain Cristo, chi nüküjakai achiki namüin. ");
INSERT INTO guc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nnojoishi niain Juan anaküinjachin süpüna wayuu. Nüchikimaajachi ne'e ");
INSERT INTO guc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","süpüla naapirüinjatüin wayuu nüpüla Cristo sünain niainjachin anaküin süpüna wayuu je sünain nüntajachin maalü sa'akamüin wayuu süpüla nii'iyatüinjatüin tü shiimüinkat sümüin wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo, chi kanüliakai “Pütchi” münüin, antüshi yaa mmolu'umüin süpüla kepiainjachin sa'aka wayuu. Mayaainje akumajuushin nütüma tü wayuukolüirua je tü kasakalüirua süpüshua yaa saa'u mmakat, wainma wayuu mochoojokot o'u nia sünain niain ee'iyatüinjachin tü shiimüinkat sümüin. ");
INSERT INTO guc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Antüshi nia noumainpa'amüin na nüpüshikana süpüla kepiainjachin nia namaa. Otta mamaneesalii naya nuulia. ");
INSERT INTO guc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Eesü wayuu eekai kamaneein nümüin sümaa ne'itaain naa'in sünain anoujaa nünain. Je sükajee nanoujain nünain, e'itaanüshii naya nütüma süpüla nayainjanain nüchooin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nnojoishii nüchooinshiin naya maa aka jemelin sütüma nei oo'ulaka nashi, sükajeejana jeketüin nakuaippa nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristo, chi kanüliakai “Pütchi” münüin, wayuulaa müshi süpüla kepiainjachin wa'aka je süpüla nii'iyatüinjatüin nukuaippa Maleiwa wamüin. Je süka we'rapü'üin Jesucristo, chi waneeshikai Nüchon Maleiwa, sünain anashaatain ma'i nia, watüjaa aa'uchi chi Maleiwakai sünain anashaatain ma'i nia'aya, sünain anamiashaatain ma'i nia, je sünain pansaain tü nümakat sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Otta müshia Juan, so'u wane ka'i, naapirüin na wayuukana eekana nümaa süchiki sünain nüntüichipain na'akamüin chi kanüliakai “Pütchi” münüin. Owootooshi sünain nüküjain nüchiki Cristo namüin. Müsü nünüiki: “Nia taküjaka achiki jümüin joolu'u chi tamapü'üka jümüin sünain maa: ‘Anteechi tachiiruajee sümaa kojuteechin nia toulia sükajee eetüjülin nia tapüleerua’ ”. ");
INSERT INTO guc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Saa'u anamiashaatain ma'i Cristo wamüin waya anoujashiikana nünain, ayatshi nia sünain aa'inraa kasa anasü wamüin. ");
INSERT INTO guc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tü nuluwataakat anain chi Maleiwakai na wayuu judíokana, atüjaana aa'ulu sütüma tü nüshajakat Moisés paala sümaiwa. Akaajasa maa'ulu yaa, tü nukuaippakat chi Maleiwakai sünain anamiashaatain ma'i nia, atüjaana aa'ulu nünainjee Cristo, süka anamiashaatain ma'i nia. Maja'a aka tü nukuaippakat sünain pansaain nünüiki, atüjaana aa'ulu nünainjee Cristo, süka pansaain nünüiki. ");
INSERT INTO guc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nnojotsü wayuu eekai shi'rüichin Maleiwa. Otta chi Nüchonkai Maleiwa, chi waneeshikai nüchoin, chi wanaawajiraakai aa'in nümaa, nia ee'iyataka nukuaippa Maleiwa wamüin, süka shiimüin sünain niain Maleiwain maa aka naa'in chi Nüshikai. ");
INSERT INTO guc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","So'u wane ka'i, nantakalaka wane sacerdote judíoirua oo'ulaka wane nuu'uliwo'uirua Leví nünainmüin Juan süpüla nasakirüinjachin nia sünain jaralin nia. Ajütüüshi naya natüma na laülaayuu judíokana chakana Jerusalén. ");
INSERT INTO guc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nnojoija'a ayouktüin Juan asouktaa ne'ipajee. —Nnojoishi tayain Cristoin chi Nüneekajalakai Maleiwa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nasakirakalaka sünain müleka niale Elías. —Nnojo, nnojoishi tayain Elías —nümakalaka Juan namüin. Nasakirakalaka joo nia sünain müleka niale chi Nünüikimaajachikai Maleiwa ajütünajachikai so'uweena wane ka'i sa'akamüin wayuu. —Nnojo, nnojoishi tayain chi wayuukai —müshija'a joo nia namüin. ");
INSERT INTO guc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Püküja pümaala wamüin sünain jaralin pia, watüjaaiwa paa'u, waküjaiwa namüin na kaluwanaajalakana waya pünainmüin —namakalaka nümüin Juan. ");
INSERT INTO guc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Taya chi owoorolooshikai yaaya isashiipa'a süpüla yapainjatüin tü wayuukolüirua süpüla anoujaa nünain chi Senyotkai —nümakalaka Juan namüin. Je tü pütchi nüsouktakat aka Juan, shia tü münakat sümaiwa paala nütüma Isaías wane nünüikimaajachikai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Eesü wane wayuuirua fariseo na'aka na ajütünakana nünainmüin Juan. Naya na judío a'waataakana sulu'u nekeraajüin süpüshua saa'in namüin tü nuluwataakat anain Moisés. ");
INSERT INTO guc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nasakirakalaka nia: —¿Jamaka'a puwoutisaajaka'a wayuu sünain nnojolin piain Cristoin, sünain nnojolin piain Elías, je sünain nnojolin piain chi Nünüikimaajachikai Maleiwa? —namakalaka nümüin Juan. ");
INSERT INTO guc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Tawoutisaajüin ne'e jia süka wüin. Otta eeshi yaa ja'aka wane wayuu mochoojokai so'u wayuu sünain niainjachin ee'iyatüin tü shiimüinkat sümüin. ");
INSERT INTO guc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nia taküjaka achiki jümüin, chi anteechikai tachiiruajee. Nnojoishi wanaapünaain taya nümaa, süka pülashin ma'i nia toulia —nümakalaka Juan namüin. ");
INSERT INTO guc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eejechire nüsakinnüin Juan chajachi sulu'u tü pueulo kanüliakat Betania cha'aya wane sa'ata tü süchikat Jordán chaa wüinpümüin saa'ujee eere nuwoutisaajüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Shiasa mapa watta'amüin, ni'rakalaka Juan Jesús sünain nürütkaain nünainmüin. Nümakalaka Juan namüin na wayuu eejanakana nümaa: “Jiirakaa, iseeichi chi wayuu aneekünakai nütüma Maleiwa süpüla nu'utünajachin aa'in süpüla nüla'ajaainjatüin saainjala wayuu süpüshua sainküin mmakat, maa akaapü'ü tü anneerü o'utünapü'ükat aa'in watüma wayakana judíokana shii'iree süla'ajaanüin waainjala. ");
INSERT INTO guc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nia taküjaka achiki jümüin chi tamapü'ükai jümüin: ‘Anteechi tachiiruajee sümaa kojuteechin nia toulia sükajee eetüjülin nia tapüleerua’. ");
INSERT INTO guc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Otta mayaainje nnojolin tatüjaain aa'u paala sümaa jaralin chi taküjakai achiki, antüshija'a ne'e taya süpüla owoutisaajaa jia süpüla ni'nnaajünüinjachin sütüma tü wayuu Israelkalüirua”, nümakalaka Juan namüin. ");
INSERT INTO guc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ayatshi joolu'u Juan sünain aküjaa süchiki süpüshua tü kasa ni'rakat, sümaa nümüin namüin: “Te'rüin chi Naa'inkai Maleiwa sünain ashakataa iipünaajee eejee Maleiwa maa aka saa'in wane mo'uwa. Antüshi nia nünainmüin Jesús sünain makatale'einya nia nümaa. ");
INSERT INTO guc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mayaainje nnojolüin tatüjaain aa'u paala sümaa jaralin chi taküjakai achiki, tatüjaaichipa aa'u nia so'u tü ka'i nüshakatakat o'u chi Naa'inkai Maleiwa naa'u süka tamünüin paala nütüma chi kajünalakai taya süpüla owoutisaajaa. Müshi nia tamüin: ‘Chi wayuu pi'reechikai sünain nüshakatüin chi Naa'inkai Maleiwa nünain sümaa makatüin nia nümaa, nia aapajachika chi Naa'inkai Maleiwa namüin na eekai nanoujain nünain’, müshi. ");
INSERT INTO guc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Otta tayakai, sünainjee tü kasa te'rakat, tountüin joolu'u taküjain jümüin nüchiki Jesús sünain shiimüin sünain niain chi Nüchonkai Maleiwa”, nümakalaka Juan namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Shiasa mapa watta'amüin, ale'ejüshi Juan namaa piamashii na nikirajüinkana eejachire paala naashajaain namaa na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Shiasa ni'rapa Jesús nülatüin na'ütpünaa, nümakalaka namüin na nikirajüinkana: —Jiirakaa, ichaaichi chi wayuu aneekünakai nütüma Maleiwa süpüla nu'utünajachin aa'in maa akaapü'ü tü anneerü o'utünapü'ükat aa'in watüma wayakana judíokana shii'iree süla'ajaanüin waainjala —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Otta na piamashiikana nikirajüin, sünainjee tü nümakat namüin, no'unakalaka nüchiirua Jesús. ");
INSERT INTO guc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nujununtaakalaka Jesús nanainmüin. Je ni'rapa na piamashiikana wayuu nüchiirua, —¿Kasa kee'ireeka jaa'in? —nümakalaka namüin. —Rabí, ¿jalashi pia katunkülein? —namakalaka nayakana nümüin. (Otta tü pütchikat “Rabí” makat, “Ekirajüi” malu'ut.) ");
INSERT INTO guc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Joo'uya ji'raajaiwa eere tatunkule —nümakalaka Jesús namüin. No'unakalaka nümaa süpüla ne'raajüinjatüin eere nia kepiain. Je saa'u nantüin aliuukapa ka'ikat chamüin, natunkaakalaka nüma'ana. ");
INSERT INTO guc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Waneeshia chi aapüshikai paala nünüiki Juan sümaa no'unüin nümaa Jesús, kanüliashi Andrés, nimülia wane wayuu kanüliashi Simón Pedro. ");
INSERT INTO guc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Je mapa nu'unapa Andrés nipialu'ujee Jesús, o'unüshi yaawalaja'a nünainmüin chi nipayakai sünain maa nümüin: —Wantüichipa anain chi Mesíaskai. (Otta tü pütchi “Mesías” makat, “Cristo Nüneekajalakai Maleiwa” malu'ut.) ");
INSERT INTO guc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naanejaakalaka joo Andrés chi nipayakai nünainmüin Jesús. Niirakaataalakalaka Jesús nümüin Simón sünain nümüin nümüin: —Simón, pia nüchonkai Jonás, te'itaainjatü joolu'u wane anüliee pünain, Cefas müsü. (Tü anüliee “Cefas” süka pütchi griego, “Pedro” malu'ut.) ");
INSERT INTO guc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Shiasa mapa watta'amüin: “Anashi to'unüle sulu'umüin tü mmakat Galilea”, müsü naa'in Jesús. Je süpülapünaa nu'unüin chamüin, nüntakalaka nünainmüin wane wayuu kanüliashi Felipe. Nümakalaka nümüin: —Joo'uya tamaaiwa pia. ");
INSERT INTO guc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Chi Felipekai anülia, chaje'ewai nia sulu'u tü pueulokat Betsaida wanaa namaa Andrés oo'ulaka Pedro. ");
INSERT INTO guc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Je mapa, nüntakalaka Felipe nünainmüin wane nütünajut kanüliashi Natanael. Nümakalaka nümüin: —Wantüichipa anain chi nüshajapü'ükai achiki Moisés, chi nashajapü'ükai achiki na nünüikimaajanakana Maleiwa. Nia chi Jesúskai anülia, chaje'ewaikai sulu'ujee tü pueulokat Nazaret, chi nüchonkai José —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Jeratuairü ajuittüin kasa anasü sünainjee wayuu eekai müin aka saa'in tü wayuuirua kepiakat Nazaret eekai nnojolüin kasain anain apüla? —nümakalaka Natanael. —Joo'uya pi'raajaiwa Jesús —nümakalaka Felipe nümüin. ");
INSERT INTO guc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Otta müshia Jesús, wanaa sümaa ni'rüin Natanael nüpanapa, nümakalaka namüin na eekana nümaa: —Iseeichi wane wayuu loto akuaippachi, napüshi na wayuu Israelkana, nuu'uliwo'u chi Israelkai anülia —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Jamüshi pütüjaaka'a taa'u? —nümakalaka Natanael nümüin Jesús. Asouktüshi Jesús: —Te'rüin pia joyotüin sheemioushi tü wunu'u “higuera” münakat, nnojoliiwa'aya peenakünüin nütüma Felipe —nümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Ekirajüikalee, tatüjaaichipa aa'ut pia joolu'u sünain pia'inya chi Nüchonkai Maleiwa, je sünain pia'inya chi Aluwataashijaikai waa'u wayakana na wayuu Israelkana —nümakalaka Natanael nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nüsouktakalaka Jesús: —Anoujaichipa ne'e pia tanain sükajee taküjüin püchiki sünain te'rüin pia joyotüin sheemioushi tü wunu'u “higuera” münakat. Je joolu'u, e'reechi pia kasa eekai sülana'aleein sünain anain suulia tüü —nümakalaka nümüin Natanael. ");
INSERT INTO guc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aashajaashi joolu'u Jesús namüin na wayuukana napüshua: —Shiimüin tü tamakat jümüin: Ji'reena na aapieekana sünain nashakatüin chajee iipünaajee eejee Maleiwa yaa tanainmüin tayakai chi Shipayakai Wayuu je sünain naliikajaain nachikua chamüin —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Piama ka'i süchikijee naashajaain Jesús nümaa Natanael, antüshi nia namaa na nikirajüinkana Galileamüin. Neenajinnakalaka namaa na nikirajüinkana oo'ulaka tü niikat sünainmüin wane mi'iraa shikiira ka'wayuusee sulu'u tü pueulo kanüliakat Caná. ");
INSERT INTO guc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Shiasa shi'rapa tü niikat Jesús sünain saja'ttalaa sümüin tü wiinokat, sümakalaka nümüin: —Aja'ttüsü tü asüüshikat. ");
INSERT INTO guc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Asouktüshijese'e Jesús sümüin: —Maachee, nnojo pikerotirüin taya sünainpünaa tüü. Nnojoyülia antüin takalia —nümataalakalaka sümüin tü niikat. ");
INSERT INTO guc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sümakalaka joo tü niikat namüin na nüchepchiakana chi emi'ijitshikai: —Anakaja jaa'inrüle tü nümeetkat jümüin chi tachonkai. ");
INSERT INTO guc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Je yala eejatü aippiruasü tünaasha malu'usat, sütapü'ükat tü wüin süpülajatkat naa'inrüin tü kasa wuleinjatkat akajee nakuaippa nu'upala Maleiwa. Je tü tünaashakat, kettatsü maa aka aippirua pasaana wüin sulu'u waneesia. ");
INSERT INTO guc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nümataalakalaka joo Jesús namüin na achepchieekana: —Jipiraja wüin tüü. Nepirajakalaja'aka shia sünain piratashaatain ma'i natüma. ");
INSERT INTO guc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nümakalaka Jesús namüin: —Je joolu'u, jaja'ita süpüshi türa asüüshikat ji'ikajaaiwa nümüin chi emi'ijitshikai. Ne'ikajaakalaja'aka shia nümüin. ");
INSERT INTO guc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nuu'ulakakalaka se'ejü tü asüüshikat. Süka wiinoitpain shia, nnojotsü nütüjaain aa'u sünain wüiin ne'e paala shia, je nnojotsü nütüjaain aa'u jalajeejatüin shia. Naya atüjaaka ne'e saa'u na achepchiee epirajakana paala tü tünaashakat süka wüin. Chi emi'ijitshikai, neenakakalaka nünainmüin chi ka'wayuuseshikai, ");
INSERT INTO guc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","sünain nümüin nümüin: —Sukuaippa sütüma wayuu süpüshua sünain wane mi'iraa, shia asülajünaka palajana tü wiino jemetüsükat. Je mapa süchikijee payutpa tü antüsükalüirua, asülajünüsü tü wiino meje'ejütsükat namüin. Otta pütüma piakai, pünaajüin tü jemetüsükat süpüla asülajünaa chiirua —müshi. ");
INSERT INTO guc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tü naa'inrakat Jesús sulu'u tü pueulokat Caná sulu'u tü mmakat Galilea, shiimüin sünain shiain tü nütüjakat apüleerua Maleiwa nümüiwa. Nnojotsü naa'inrüin paala su'upala wayuu wane kasa eekai müin aka tia. Naa'inrüin shia süpüla nii'iyatüinjatüin nukuaippa namüin na nikirajüinkana süpüla natüjaainjachin naa'u sünain wanaawain nia nümaa Maleiwa sünain anashaatain ma'i. Je na nikirajüinkana, ne'itaain naa'in sünain nanoujain nünain süka ne'rüin tü naa'inrakat. ");
INSERT INTO guc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Shiasa mapa süchikijee tü mi'iraakat sulu'u tü pueulokat Caná, o'unüshi Jesús sümaa tü niikat je namaa na nuwalayuukana je na nikirajüinkana chamüin sulu'umüin tü pueulo kanüliakat Capernaum süpüla chainjanain naya cha'aya kojuya ka'i. ");
INSERT INTO guc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Je sülü'ülapa sükalia tü mi'iraa kanüliakat “Pascua” münüin, tü nemi'irakat na judíokana, o'unüshi Jesús chamüin cha'aya Jerusalénmüin süpüla e'rajaa sukua tü mi'iraakat. (Otta tia mi'iraakat, shia süpülajatü sotüinjatüin naa'in na judíokana wanaa sümaa nojuittinnüin paala sümaiwa na natuushinuukana nütüma Maleiwa sulu'ujee tü mmakat Egipto.) ");
INSERT INTO guc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Je nüntapa Jesús Jerusalénmüin, nikerolokoloko sulu'umüin süpaatiase tü a'waajüleekat Maleiwa eere nüntüin sünain wane wayuuirua oikkaannuu paa'a, anneerü, oo'ulaka wuchii toomasü süpüla su'utinnajatüin aa'in sütüma tü wayuukolüirua nümüin Maleiwa. Je eesü nüpülaya wane a'wanajaalüirua neerü yaa joyotüin sü'ütpa'a tü nemeesainkat. ");
INSERT INTO guc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nükumajataalakalaka Jesús wane jiiku lakta süpüla niipiijüinjatüin na wayuukana napüshua oo'ulaka tü mürütkalüirua, paa'a je anneerü, sulu'ujee süpaatiase tü a'waajüleekat. Nu'walakajakalaka nanneetse na a'wanajüliikana neerü sümaa nujunaain tü nemeesainkat. ");
INSERT INTO guc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nümakalaka Jesús namüin na oikkaashiikana wuchii toomasü: “Jujuittira tü wuchiikalüirua yaajee yaa. Nnojotsü oikkaaleein nipia chi Tashikai jüpüla”. ");
INSERT INTO guc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Je ne'rapa na nikirajüinkana tü naa'inrakat Jesús, sotüsü naa'in tü ashajünakat paala nüchiki sulu'u tü karaloukta nüchikimaajatkat Maleiwa, sünain müin mayaa: “Kee'ireesü ma'i taa'in shii'iree kojuteein tü pipiakat sütüma tü wayuukalüirua”, müsü. ");
INSERT INTO guc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Otta na laülaayuu judíokana, sütümajee tü naa'inrakat Jesús sulu'u süpaatiase tü a'waajüleekat Maleiwa, nasouktakalaka nümüin: —Süpüla watüjaainjachin paa'u sünain shiimüin e'itaaushin pia nütüma Maleiwa süpüla tü paa'inrüitpakat yaaya, anakaja müleka paa'inrüle joolu'u wo'upala wane kasa nütüjakat apüleerua Maleiwa nümüiwa —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Asouktüshi Jesús namüin: —Müinka jujuttirüle joolu'u a'waajüleekat tüü, tatame'ereerü shia süchikua so'u apünüin ka'i —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Namakalaka nümüin Jesús: —Atak, pienchi ma'i shikii juya aippiruamüin na'yataain na watuushinuukana sünain akumajaa tü a'waajüleekat Maleiwa. Je piakaiche ma'i, kaalapeechin pütamate'erüinjatka'a shia so'u apünüin ka'i paajüin —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","22","(Je mapa süchikijee süso'iraain naa'in Jesús, sotüsü naa'in na nikirajüinkana tü pütchi nümakat paala namüin na judíokana sünain nayaawatüin saa'u sünain shiain tü ni'irukukat naashajaain achiki Jesús wanaa sümaa naashajaain süchiki tü a'waajüleekat Maleiwa. Je sükajee tia, nanoujain süpüshua tü ashajuushikat nüchiki sulu'u tü karaloukta nüchikimaajatkat Maleiwa je süpüshua tü nümapü'ükat Jesús namüin.) ");
INSERT INTO guc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Otta müshia Jesús, wanaa sümaa ni'rajüin sükua tü mi'iraakat kanüliakat Pascuain cha'aya Jerusalén, naa'inrüin su'upala tü wayuukolüirua kasairua nütüjakat apüleerua Maleiwa nümüiwa süpüla nii'iyatüinjatüin sümüin sünain nüjünalain nia Maleiwa. Je wainma tü wayuukolüirua, sünainjee ne'e tü shi'rakat, anoujaitpa nünain. ");
INSERT INTO guc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Otta müshia Jesús, nnojoishi ma'i ataralaain namaa na wayuukana, süka nütüjaain saa'u nanoujain ne'e sünainjee naa'inrüitpain kasa anasü no'upala. ");
INSERT INTO guc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nnojotsü che'ojaain süküjünüin nümüin jamüin sukuaippa wayuu, süka nütüjaatüjülüinya saa'u. ");
INSERT INTO guc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Eeshi wane wayuu fariseo kanüliashi Nicodemo no'uluku na laülaashiikana na'aka na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nüntakalaka nünainmüin Jesús aipa'a, sünain nümüin nümüin: —Ekirajüikalee, saa'u paa'inrüin we'rüin tü kasa nütüjakat apüleerua Maleiwa nümüiwa, watüjaa aa'uchi pia sünain laülaain nütüma süpüla ekirajaa wayuu sünain nüchiki Maleiwa. Müleka nnojoireje nüjünalain pia Maleiwa, nnojotsüje puuntüin paa'inrüin kasa eekai müin aka tia —nümakalaka Nicodemo nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Asouktüshi joolu'u Jesús nümüin: —Shiimüin tü tamakat pümüin: Müleka nnojorule jemein pia püchikua, müichia pia nnojolin ekerolüin cha'aya eere nuluwataain Maleiwa —nümakalaka nümüin Nicodemo. ");
INSERT INTO guc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Jeratuaichi wane wayuu jemein nüchikua nütaralaapa? ¿Jeratuaichi ale'ejüin wane wayuu nüchikua süle'eru'umüin nii süpüla jemelii nüchikua? —nümakalaka Nicodemo nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Asouktüshi Jesús: —Shiimüin tü tamakat pümüin: Tü paa'inrajatkat süpüla müinjachin aka jemeikai pia püchikua, shia puu'ulaainjatka oulia paainjala süpüla shii'iranajaainjatüin paa'in nütüma chi Naa'inkai Maleiwa. Müleka nnojorule paa'inrüin tia, nnojoleechi pia ekerolüin cha'aya eere nuluwataain Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jülüja paa'in tüü: Sünain jemelin pia sütüma püi, jemeishi pia sünain wayuuin. Otta chi jemeikai nüchikua, nia chi eekai jeketüin nukuaippa süka shii'iranajaaitpain naa'in nütüma chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nnojo puponojooin sütüma tü tamakat joolu'u pümüin: Che'ojaasü jemelii süchikua sümüin wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Maa aka tü jouktaikat saapünüin ne'e shipijana sümaa nnojolüin sütüjaanüin aa'u eejeere su'unüin otta jalamüinjatüin süntüin, müshia chi wayuu jemeikai nüchikua nütüma chi Naa'inkai Maleiwa süka ja'yain sünain shii'iranajaain naa'in —nümakalaka Jesús nümüin Nicodemo. ");
INSERT INTO guc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Nnojotsü tayaawatüin aa'u tü naa'inrakat chi Naa'inkai Maleiwa süpüla jemeinjatüin süchikua wane wayuu —nümakalaka Nicodemo nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Asouktüshi Jesús: —Sünain pi'nnaajünüin ma'i sünain piain ekirajülin tü wayuu Israelkalüirua, ¿jamüsü nnojotka'a piyaawatüin saa'u tü taküjaitpakat achiki pümüin? ");
INSERT INTO guc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Shiimüin tü tamakat pümüin: Wayakana, shia waashajaaka achiki, otta waküjaka achiki, tü kasa eekai we'rüin sümaa watüjaain saa'u. Otta müshi'iya jiakana, ja'itasü shiain tü shiimüinkat tü wekirajakat anain, nnojotsü kapülain jaa'in shia. ");
INSERT INTO guc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nnojolüiwapaje'e jünoujain tamüin tü taküjakat jümüin süchiki tü kasa yaakat saa'u mmakat, nnojoluja'a jünoujainjatüin tamüin müleka shiale taküjain achiki jümüin tü kasa chakat iipünaa eere Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Tountüin taküjüin jümüin süchiki tü kasa chakat iipünaa eere Maleiwa süka tashakatüshin chajee, tayakai chi Shipayakai Wayuu. Nnojoishi eeichin wane wayuu eekai nu'unüin chamüin iipünaamüin nüma'anamüin Maleiwa süpüla aküjaa süchiki nüle'ejapa. ");
INSERT INTO guc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Maa aka nükacherüin paala sümaiwa Moisés wane shiyaakua wüi iipünaa sünain wane wunu'u cha'aya isashiipa'a süpüla neiyajünüinjanain na wayuu eekai neirakaain sümüin, akaweechia tayakai, chi Shipayakai Wayuu, akachenneechi taya iipünaa sünain wane wunu'u ");
INSERT INTO guc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","süpüla shii'iranajaainjatüin naa'in na eekana ne'itaain naa'in sünain anoujaa tanain süpüla eeinjanain naya nümaa Maleiwa süpüla ka'ikat süpüshua”, nümakalaka Jesús nümüin Nicodemo. ");
INSERT INTO guc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anuu sukuaippa saalii wayuu sainküin mmakat süpüshua nüpüla chi Maleiwakai: Naapüin chi Nüchonkai waa'u, chi waneeshikai Nüchoin. Niasa'a chi eekai nünoujain nünain, ee'iranajaweerü naa'in nütüma Maleiwa. Nnojoleechi amüloulin süchikijee ouktaa, eejeechi nümaa Maleiwa süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nnojoishi nüjütüinshin chi Nüchonkai sa'akamüin wayuu süpüla süsalainjatüin saainjala nütüma sümaa nükatalüin shia nuulia, süpülajachi nu'tte'erüinjatüin shia suulia süsalaa saainjala. ");
INSERT INTO guc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Chi wayuu eekai ni'itaain naa'in sünain anoujaa nünain chi Nüchonkai, müichia nnojolin süsalain naainjala nütüma Maleiwa. Akaajasa chi eekai nnojolüin nünoujain nünain, e'itaanatüjü'iya nia nütüma Maleiwa süpüla süsalaa naainjala sümaa katatüin nia nuulia saa'u manoujüinyeein nia nünain chi Nüchonkai Maleiwa, chi waneeshikai Nüchoin. ");
INSERT INTO guc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","¿Kasa kasalajanainjatka anainjee saainjala wayuu sümüin? Shia sünainjee nayouktüin Cristo, chi anakakai süpüna wayuu, ajütünakai sa'akamüin wayuu süpüla nii'iyatüinjatüin namüin tü shiimüin nüchikikat Maleiwa. Shia sünainjee masütaajuin sünain aa'inraa tü mojusükat maa aka saa'in tü wayuu makateekat sümaa piyuushi. ");
INSERT INTO guc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chi wayuu eekai naa'inrüin tü mojusükat, nnojotsü kasajatüin nümüin tü shiimüin ee'iyatünakat nümüin. Nnojoishi jamajachin Cristo nümüin, chi anakakai süpüna wayuu, süka nnojolin nücheküin süpüleerua sütüjaanüin aa'u tü naainjalakat. ");
INSERT INTO guc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Akaajasa chi wayuu eekai noonooin waneepia sümaa nünüiki Maleiwa, tü shiimüin ekirajünakat anain nia, nnojoishi mmolüin neema Cristo chi anakakai süpüna wayuu. Anasü nümüin sütüjaanüin aa'u tü naa'inrakat süka naa'inrüin waneepia tü nüchekakat chi Maleiwakai nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Süchikijee tia, o'unüshi Jesús namaa na nikirajüinkana Jerusalénjee wuna'ainküinmüin cha'aya ne'e sulu'u tü mmakat Judea. Chajanakalaka naya nümaa kojuya semaana sünain nawoutisaajüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Otta müshia Juan, nnojoliiwa'aya püreesain nia, chajachi owoutisaajüin wayuu sulu'u wane pueulo kanüliasü Enón, peje sünain tü pueulo kanüliakat Salim, süka miyo'uin tü wüinkat cha'aya. Antüsü waneepia wayuu nünainmüin süpüla owoutisaajünaa nütüma. ");
INSERT INTO guc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Je waneeirua na nikirajüinkana Juan, a'ülüjiraashii nümaa wane wayuu judío soo'opünaa jamüinjatüin sukuaippa judío süpüla saa'inrüinjatüin tü kasa wuleinjatkat akajee sukuaippa nu'upala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","No'unakalaka na nikirajüinkana Juan nünainmüin sünain maa nümüin: —Ekirajüikalee, chi wayuu pümaapü'ükai cha'aya wane sa'ata tü süchikat Jordán, chi püküjakai achiki waneepia wamüin, owoutisaajüshi nia joolu'u wayuu, je o'unüsü wayuu watta saalin püma'anajee süpüla o'unaa nünainmüin —namakalaka nümüin Juan. ");
INSERT INTO guc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Asouktüshi Juan ne'ipajee: —Shia anasükaja'a ma'i sulu'u suushikajaain tü wayuukolüirua nüchiirua Cristo süka shiain nücheküin chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Soto jaa'in tü taküjapü'ükat paala jümüin sünain nnojolin tayain Cristoin, chi Nüneekajalakai Maleiwa. Ajütüüshi ne'e taya nütüma Maleiwa süpülapünaa niweetüin Cristo. ");
INSERT INTO guc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Soto jaa'in sukuaippa wane mi'iraa shikiira ka'wayuusee. Nütünajut chi ka'wayuuseshikai, talatüsü ne'e naa'in wanaa sümaa ni'rüin chi ka'wayuuseshikai sünain saapünüin najapulu'u tü jietkat. Akaajaa tayakai, talatüsü taa'in joolu'u wanaa sümaa te'rüin Jesús sünain antaa wayuu wainma nünainmüin. ");
INSERT INTO guc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kasataalejese'e niain alanaain sünain kojutüin Jesús sütüma wayuu toulia, ja'itashije tayain mojutüin sütüma —nümakalaka Juan namüin. ");
INSERT INTO guc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wayuu süpüshua, sütüjaa aa'ulu kasa eekai shi'nnüin sainküin mma ne'e. Otta müshia Jesús, shiimüin sünain kojutüin suulia wayuu süpüshua süka chaje'ewalin nia iipünaajee. ");
INSERT INTO guc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aküjüna amüinrü wayuu nütüma süchiki tü kasa ni'rakat oo'ulaka tü pütchi naapajakat chaa iipünaa. Otta wainma tü wayuu aapakalüirua nünüiki, nnojotsü kapülain saa'in tü nüküjakat achiki sümüin. ");
INSERT INTO guc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Otta chi wayuu eekai kapülain naa'in tü nümakat, ja'yasü nünainjee sünain pansaain nünüiki Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Cristo, chi nüjünalakai Maleiwa, shiimain sümaa nüküjaain nünüiki chi Maleiwakai waneepia sümüin wayuu, süka eein chi Naa'inkai Maleiwa nümaa waneepia. ");
INSERT INTO guc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Saa'u niain Cristo chi Nüchonkai Maleiwa, aishi ma'i nia nüpüla chi Nüshikai. Je laülaashi nia nütüma saa'u kasakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chi wayuu eekai ni'itaain naa'in sünain anoujaa nünain chi Nüchonkai Maleiwakai, ee'iranajaweerü naa'in süpüla eeinjachin nia nümaa Maleiwa süpüla ka'ikat süpüshua. Akaajasa chi wayuu eekai nnojolüin noonooin sümaa nünüiki chi Nüchonkai Maleiwa, nnojoleerü ee'iranajaain naa'in, shieerü eeka süsalain nia naainjala nütüma Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Je na fariseokana, naapüin nüchiki Jesús sünain koo'omüin ma'i na nümaajanakana je sünain nawoutisaajünüin natüma na nikirajüinkana. Wainma noulia na nümaajanakana Juan. ");
INSERT INTO guc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Shiasa nütüjaapa Jesús naa'u na fariseokana sümaa naashajaain nüchiki, nujuittaakalaka noulia sulu'ujee tü mmakat Judea süpüla ale'ejaa nüchikua Galileamüin. ");
INSERT INTO guc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Anakalaka saa'in nümüin Jesús nülatüinjachin sulu'upünaa tü mmakat Samaria. ");
INSERT INTO guc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Je nülatakalaka sü'ütpünaa wane pueulo kanüliasü Sicar cha'aya eepünaa wane mma e'ipünaalaa sümaleiwa'aya nütüma Jacob, chi natuushikai na judíokana, nüpüla José, chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Je saa'u nüntüin Jesús maa aka kale'o ka'ikat, neemeraapünaakalaka sotpa'a wane ishi nüsüle Jacob sümaiwa paala. ");
INSERT INTO guc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","No'unataalakalaka na nikirajüinkana Jesús sünain apalaalajaa pueulopa'amüin. Shiasa nachikiru'u, süntakalaka joo wane wayuu aja'itüsü sünainmüin tü ishikat. Wayuu yalajatia ne'e Samaria. —Nii waa'iraa, tasa maa wüin —nümakalaka Jesús sümüin tü wayuukot. ");
INSERT INTO guc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Saa'u nnojolüin anaawain tü Samariajatkalüirua namaa na judíokana, sümakalaka tü jietkat: —Atak, sünain wayuuin judío pia, ¿jamüshi püchuntaka'a asa'iree wüin tamüin tayakat Samariajatkat? —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Asouktüshi Jesús: —Müleka piyaawatüle saa'u tü kasa anasü nüsülajeekat chi Maleiwakai sümüin wayuu süpüshua, je müleka pütüjaale naa'u jaralin chi achuntakai wüin pümüin, achuntüsüje pia nümüin wane wüin katajatkat atüma so'u wayuu je naapeerüje shia pümüin —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sümakalaka joo nümüin: —O'ttüsü tü ishikat. ¿Jalasü sho'olo paja'itajatkat aka tü wüinkat tamüin, tü katajatkat atüma so'u wayuu? ");
INSERT INTO guc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Piataale alanaain ma'i nuulia chi watuushikai Jacob chi ke'ipünaajalakai tü ishikat wapüla? Shia nüsapü'üka niakai otta na nüchooinkana oo'ulaka nümü'ünüin —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Asouktüshi Jesús: —Chi eekai nüsüin tü wüin sulu'ukat ishikat tüü, miyaaseechi nüchikua. ");
INSERT INTO guc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Otta chi eekai nüseechin tü wüin taapakat, müichia nnojolin miyaasüin nüchikua. Meerü aka saa'in wane wüin aparatkat mmaapüjee, süka shii'iranajaweerüin naa'in sütüma —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Müsü joolu'u tü jietkat: —Püsülaja tamüin türa wüin paashajaakat achiki suulia miyaasajain taya tachikua je suulia taja'inajüin waneepia —sümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Pu'una püsaajaiwa chi pu'wayuusekai yaamüin yaa —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Süsouktakalaka nümüin: —Ma'wayuusesat taya. Nümakalaka Jesús sümüin: —Lotüsü tü pümakat tamüin sünain ma'wayuusein pia paajüin. ");
INSERT INTO guc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ja'raituairü ma'i pia oo'ulaain pu'wayuuse. Je chi pümaakai maa'ulu yaa, nnojoishi pu'wayuusein. Shiimüinkalaka tü pümakat tamüin —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Eekaja'a eera pia saa'in tamüin nünüikimaajachi Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na watuushinuu Samariajanakana, na'waajüin Maleiwa yaa saa'u tü uuchikat. Akaajasa jaajüin jiakana judíokana, chainjachi a'waajünüin Jerusalén —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nu'ttakalaka joolu'u Jesús sünain nikirajüin tü wayuukot sünain maa sümüin: —Nii waa'iraa, anakaja kapürale paa'in tü tamüinjatkat joolu'u pümüin: So'uweena wane ka'i, tü a'waajüleekat Maleiwa, nnojoleerü yaain saa'u tü uuchikat, nnojoleerü shia chain Jerusalénya. ");
INSERT INTO guc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jia Samariajanakana, me'raajüinsalii jia chi Maleiwa ju'waajakai. Waya e'raajaka waya judíokana sükajee we'itaanüin nütüma süpüla aküjaa sümüin wayuu jamüinjatüin sukuaippa süpüla su'ttaainjatüin suulia saainjala. ");
INSERT INTO guc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Otta jiakana joolu'u wanaa sümaa ju'waajüin Maleiwa, anakaja müleka jüchuntüle nümüin chi Naa'inkai süpüla nii'iyatüin jümüin tü shiimüinkat. Shiainjatü jukuaippaka joolu'u sünain a'waajaa chi Washikai Maleiwa. Shia nüchekaka Maleiwa süpüla saa'inraa wayuu süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chi Maleiwakai, me'rujusai sütüma wayuu. E'nnaajünüshi ne'e nia sünainjee tü shiimüin ee'iyatünakat wamüin nütüma chi Naa'inkai. Sükajee tia, chi eekai nu'waajeein Maleiwa, anashi müleka nüchuntüle akaaliijünaa nümüin chi Naa'inkai —nümakalaka Jesús sümüin tü wayuukot. ");
INSERT INTO guc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Tatüjaa aa'uchi chi Cristokai anülia Nüneekajalakai Maleiwa sünain nünteechin. Je nikirajeena waya sünain kasa süpüshua nüntapa —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Chi paashajaakai achiki, taya'aya ne'e, chi yootokai pümaa —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wanaa sümaa naashajaain Jesús sümaa tü wayuukot, ale'ejüshii na nikirajüinkana pueulopa'ajee. Mayaainje sainkuuin naa'in sütüma yootüin Jesús sümaa wane wayuu Samariajatü, nnojoishi nasakirüin sünain kasain nüchuntüin sümüin je sünain kasain naashajaain achiki sümaa. ");
INSERT INTO guc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Otta joo tü aja'itüsükat, süpütakalaka tü sümüchikat sünain süle'ejaain pueulopa'amüin sümaa sümüin sümüin tü wayuukolüirua cha'aya: ");
INSERT INTO guc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Tanta anainchi wane wayuu je nüküjain tamüin süpüshua tü kasa taa'inrapü'ükat. Joo'uya ji'raiwa müleka niale chi Cristokai anülia Nüneekajalakai Maleiwa —müsü namüin. ");
INSERT INTO guc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ojuittüshii na wayuukana yaawalaja sulu'ujee tü pueulokat süpüla o'unaa eemüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Otta na nikirajüinkana Jesús süchikiru'u tü jietkat, namüshi Jesús kojuyatua: —Ekirajüikalee, anashi müleka piküle süpüshi tü eküütkat —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Asouktüshi nia namüin: —Eesü wane eküülü tama'ana nnojotsü ji'raajüin —müshi. ");
INSERT INTO guc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—Ekinnüshi eera sütüma wayuu —namajirawa'ain namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nümakalaka Jesús namüin: —Maa aka wane wayuu eekai talatüin naa'in emirapa, akaajaa tayakai talateerü ma'i taa'in müleka taa'inrüle tü ajütünakat apüla taya nütüma Maleiwa, süka kee'ireein ma'i taa'in tekeraajeein tü nüchekakat tapüleerua. ");
INSERT INTO guc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Je ni'rapa Jesús na wayuu antakana nünainmüin pueulopa'ajee sümaa tü aja'itüsükat, müshi nia namüin na nikirajüinkana: “Nnojotsü anain müleka jümüle tamüin: ‘Isayülia pienchi kashi süpüla jakütüin tü a'ttieekat süpüla asü'üjünaa’, müleka jümüle. Jiirakaa namüin na wayuu antakana joolu'u. Müshii aka naya saa'in wane a'ttiee eekai yapain süpüla asü'üjünaa. Kettaashii naya joolu'u süpüla akotchajünaa süpüla anoujaa tanain ");
INSERT INTO guc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","süpüla eeinjanain naya nümaa Maleiwa süpüla ka'ikat süpüshua. Chi eekai nüpünajüin oo'ulaka chi eekai nükotchajüin, talateena naya wanaawa. ");
INSERT INTO guc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Shiimüin sümakat tü ashajünakat soo'opünaa tü a'yatawaakat nümüin Maleiwa, müsü mayaa: ‘Apünajüshi wane, oo'ulaka wane, asü'üjashi’. ");
INSERT INTO guc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tajütüinjana jia joolu'u eepünaale nnojolüin ji'yatawaajüin paala süpüla jükotchajüinjanain na eekai kettaain süpüla anoujaa tanain. Talateena jia sünainjee naata ka'yataainshi”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Otta wainma na wayuu Samariajanakana antakana nünainmüin Jesús sulu'ujee tü pueulokat, anoujashii naya nünain sütümajee tü sümakat tü aja'itüsükat namüin wanaa sümaa sümüin namüin: “Nüküjain tamüin süpüshua tü kasa taa'inrapü'ükat”. ");
INSERT INTO guc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Je nantapa nünainmüin Jesús, na'alijirüin nia shii'iree makatüin namaa. Je makatakalaka nia oo'ulaka na nikirajüinkana nümaa cha'aya nama'ana so'u piama ka'i. ");
INSERT INTO guc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","So'u tü piamakat ka'i, wainma na anoujakana nünain Jesús sütüma tü nümakat namüin noulia na anoujakana paala sütüma tü sümakat tü jietkat namüin. ");
INSERT INTO guc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Müshii joo na wayuukana sümüin tü jietkat: —Anoujashii paala waya nünain sütüma tü pümakat ne'e. Alu'ujasa joolu'u, anoujaleeinapa waya nünain süka waapaleeitpa'inya nünüiki. Wayaawatüichipa aa'u nia sünain shiimüin niain chi o'ttaainjachikai atüma wayuu sainküin mmakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Süchikijee tü piamakat ka'i, nu'unakalaka Jesús chamüin nuumainpa'amüin Galileamüin eejeewa'ire nia antüin. ");
INSERT INTO guc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Shiasa nüntapa Galileamüin, kamaneeshii na wayuukana nümüin, süka ne'rüin paala tü kasa anasü naa'inrakat cha'aya Jerusalén su'utpünaa tü mi'iraakat kanüliakat “Pascua”. Otta müshia Jesús, nnojoishi ma'i ataralaain namaa na wayuukana saa'u nikirajüin paala sünain mojutüin wane nünüikimaajachi Maleiwa sulu'u nuumain. ");
INSERT INTO guc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Nüntakalaka Jesús nüchikua sulu'umüin tü pueulo kanüliakat Caná eejechire paala nii'iratüin tü wüinkat sünain wiinoin. Otta yala, nüntakalaka nünainmüin Jesús wane wayuu sülaüla mma kepiashi sulu'u tü pueulo kanüliakat Capernaum chaa ka'yata sünain Caná. Chi wayuukai, ayuuishi nüchon cha'aya nipialu'u. Mayeinshi ma'i. Naapapa nüchiki Jesús sünain nüntüin chajee Judeajee yaamüin Galileamüin, o'unüshijese'e nia nünainmüin Jesús süpüla nüchuntüinjachin ma'i nümüin süpüla nu'unajachin nümaa Capernaummüin süpüla niiyajüinjachin chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nümataalakalaka Jesús nümüin: —Jiakana wayuukana, müleka nnojorule ji'rüin taa'inrüin ju'upala wane kasa anashaatasü nütüjakat apüleerua Maleiwa nümüiwa, nnojoleena jia anoujain tanain. ");
INSERT INTO guc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Ekirajüikalee, anashi müleka pu'unamaatüle tamaa. Ouktaawashi taa chi tachonkai —nümakalaka nüshi chi ayuuishikai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Pu'una maala püchikua pipialu'umüin. Anaichipa chi püchonkai, nnojoleechi ouktüin —nümakalaka Jesús nümüin. Sünain nünoujain chi wayuukai tü nümakat Jesús, o'unüshi nipialu'umüin. ");
INSERT INTO guc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nüpanapajakalaka chi wayuukai wane nüchepchiairua wopulu'u. Naküjakalaka nümüin sünain anaichipain chi nüchonkai. ");
INSERT INTO guc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Jalapshijachi aawalaain nia? —nümakalaka namüin. —Aawalaasü tü tuttaakat nuulia kale'oinka maa aka süpu'uleematüin ka'ikat —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Niyaawanajaakalaka saa'u joolu'u chi nüshikai sünain niiyajünüin chi nüchonkai wanaa ma'i sümaa “Anaichipa chi püchonkai, nnojoleechi ouktüin” nümüin paala Jesús. Ni'itaakalaka naa'in niakai je napüshua na kepiakana nümaa sünain anoujaa nünain Jesús sükajee tia. ");
INSERT INTO guc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Piantuairü joo naa'inrüin Jesús cha'aya Galilea tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa. Naa'inrüin shia süchikijee nüle'ejüin Judeajee süpüla nii'iyatüinjatüin nukuaippa sümüin wayuu sünain nüjünalain nia Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Je mapa süchikijee, o'unüshi Jesús chamüin Jerusalénmüin nüchikua süpüla e'rajaa sükua wane mi'iraa natüma na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Je peje sünain so'u tü pueulokat eepünaale shikerojinnüin anneerü, eesü wane anua jerutsü so'oojia wayuu. Eesü ja'raisü luma sotpünaa. Je sünülia tü anuakat süka pütchi hebreo, “Betesda”. ");
INSERT INTO guc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Süka eein nüchiki wane aapieekai nüma'anajeejachi Maleiwa sünain nüntawalin shirokumüin tü wüinkat süpüla nujurulajaainjatüin shia, niasa'a chi ayuuishi palajachikai ekerolüin shirokumüin tü wüinkat süchikiyaawain sujurulajaanüin, anashi suulia ayuulii eejatkat nünain. Je wainmakalaka ma'i wayuu eekai ayuulin suupünaa tü lumakalüirua sünain a'atapaa sujurulajaanüinjatüin süchikua tü wüinkat. Eejatü wayuu eekai mo'uin, eekai masa'ain, je eekai ouktüin süsa'a. ");
INSERT INTO guc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nüntakalaka Jesús sünainmüin tü anuakat. Eejachikalaka nüpüla wane oukta asa'achikai, apünüinrü shikii juya mekiisalümüin sünain ayuulin nia. ");
INSERT INTO guc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Je ni'rapa Jesús chi wayuukai je niyaawatapa naa'u sünain wainmainrüin juya nnojolüin waraittüin nia, —¿Aneeshi pia? —nümataalakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nümakalaka chi oukta asa'achikai nümüin Jesús: —Waa'iraa, nnojotsülee jaralin alü'üjüinjachin taya shirokumüin tü wüinkat wanaa sümaa sujurulajaanüin. Isasü tachiki atamawaa. Antüsülee ne'e wayuu palajana tapüleerua shirokumüin. ");
INSERT INTO guc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nümakalaka Jesús nümüin: —Pütamaa maala puwaraijaiwa. Pülü'üja türa puju'lejiakat yaajee —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Anashi yaawalaja'a joo chi wayuukai. Nu'unakalaka sünain waraittaa yalajee sünain nülü'üjüin tü nuju'lejiakat. Otta tü ka'i niiyajakat o'u Jesús chi wayuukai, sükalia eemerawaa natüma na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Je sükajee tia, namakalaka na laülaashii judíokana nümüin chi wayuu eiyajuushikai: —¿Motüsü paa'in sünain sükaliain eemerawaa ka'ikat tüü? Achiajaanüshii waya nütüma Moisés suulia a'yatawaa so'uka'i. Tü paa'inrakat sünain pülü'üjain puju'lejia, wane a'yatawaa saa'in wamüin. ");
INSERT INTO guc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nüsouktakalaka chi eiyajuushikai namüin: —Aluwataaushi ne'e taya nütüma chi wayuu keiyajalakai taya sünain waraittaa je sünain alü'üjaa toju'lejia. ");
INSERT INTO guc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nasakirakalaka nia: —¿Jarat wayuuyaa tü aluwataaka pia sünain waraittaa je alü'üjaa puju'lejia? ");
INSERT INTO guc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Otta chi eiyajuushikai, nnojoishi nütüjaain aa'u jaralin chi eiyajakai nia, süka nu'unatüjüli'inya Jesús sa'akajee tü wayuukolüirua cha'aya. ");
INSERT INTO guc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Shiasa mapa, nünta anainchi Jesús chi wayuu eiyajuushikai cha'aya sulu'u tü a'waajüleekat Maleiwa. Nümataalakalaka Jesús nümüin: —Piirakaa. Anaichipa pia. Otta müleka nnojorule puu'ulaain joolu'u suulia paainjala, eesü süpüla sülatüin pümüin kasa mojusü eekai sülana'aleejeerüin sünain mojuin shia suulia tü ayuulii pünainjatkat paala. ");
INSERT INTO guc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nu'unakalaka joolu'u chi wayuukai nanainmüin na laülaashii judíokana süpüla nüküjainjatüin namüin sünain niain Jesús keiyajalaka nia. ");
INSERT INTO guc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jashichikalaka ma'i na laülaashii judíokana joolu'u nümüin Jesús sünainjee naa'inrüin kasa eekai müin aka tia so'u sükalia eemerawaa. ");
INSERT INTO guc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nümataalakalaka Jesús namüin: —Maa aka masütaajuin chi Tashikai sünain aa'inraa kasa anasü sümüin wayuu, akaainjachia tayakai nnojolinjachi oo'ulaain suulia aa'inraa tü anasükat —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Koo'omüinkalaka ma'i naashichin joolu'u na laülaashiikana saaliijee tü nümakat Jesús namüin. No'uteekalaka naa'in, nnojotsü sünainjeejatüin ne'e niiyajüin sükalio'u eemerawaa. No'utee aa'inchi nia sünainjee niain Maleiwa nüshin naashin je wanaawain nia nümaa naashin. ");
INSERT INTO guc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","O'ttüshi joolu'u Jesús sünain nii'iyatüin namüin na laülaashii judíokana sünain shiimüin niain chi Nüchonkai Maleiwa. Müshi nia namüin: “Shiimüin tü tamüinjatkat joolu'u jümüin: Nnojotsü kasain tountüin taa'inrüin tamüiwa. Tü tountakat taa'inrüin, shia tü te'rakat naa'inrüin chi Tashikai. Tü naa'inrakat chi Tashikai, taa'inrüin tayaka'iya süka Nüchoin taya. ");
INSERT INTO guc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Süka alin ma'i taya nüpüla chi Tashikai, nii'iyatüin tamüin süpüshua tü naa'inrakat. Je nii'iyateerü tamüin mapeena tü poneetkat ma'i jaa'in, süka sülana'aleejeerüin ma'i sünain anain suulia tü nii'iyatüitpakat tamüin. ");
INSERT INTO guc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maa aka chi Tashikai sünain nüso'irüin saa'in wayuu, akaweechia tayakai chi Nüchonkai Maleiwa, taapeerü kataa o'u nümüin chi wayuu eekai tacheküin süpüleerua. ");
INSERT INTO guc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Je mayaainje laülaain chi Tashikai süpüla kasalajanainjatüin sümüin saainjala wayuu nütüma, ni'itaaichipa taya joolu'u süpüla kasalajanainjatüin sümüin saainjala wayuu süpüshua tatümaya, ");
INSERT INTO guc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","süka nücheküin chi Tashikai süpüleerua kojutüinjachin taya Nüchonkai sütüma wayuu süpüshua wanaa nümaa. Chi eekai mojutüin atüma taya Nüchonkai Maleiwa, mojutsai chi Tashikai nütümaya, chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shiimüin tü tamakat jümüin: Chi eekai noonooin sümaa tanüiki sümaa nünoujain nünain chi Maleiwa kajünalakai taya, ee'iranajaweerü naa'in süpüla eeinjachin nia nümaa süpüla ka'ikat süpüshua. Je müichia nnojolin süsalain naainjala nütüma Maleiwa je nnojoleechi katatüin nia nuulia. Nnojoliiwa'aya nünoujain, ouktajachi saaliijee naainjala. Otta müshia joolu'u saa'u nünoujaichipain, kateechi o'u. ");
INSERT INTO guc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Shiimüin tü tamakat jümüin joolu'u: Napüshua na wayuu eekai manoujain, müshii aka ouktakai süka nnojolin jamajachin Maleiwa namüin. Je wainma na wayuukana so'uweena wane ka'i, naapeerü tanüiki tayakai chi Nüchonkai Maleiwa, tü anuu o'ttüitpain maa'utpünaa yaa sünain aapajünaa. Chi eekai noonooin sümaa, ee'iranajaweerü naa'in. ");
INSERT INTO guc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maa aka chi Tashikai naapüin kataa o'u sümüin wayuu, akaajaa tayaka'iya chi Nüchonkai, ni'itaain taya süpüla aapaa kataa o'u sümüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Je saa'u tayain chi Shipayakai Wayuu, laülaashi taya nütüma chi Tashikai süpüla kasalajanainjatüin saainjala wayuu sümüin tatüma. ");
INSERT INTO guc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nnojo jainkuuin aa'in sütüma tü taküjainjatkat joolu'u jümüin: So'uweena wane ka'i, saapeerü tanüiki süpüshua tü wayuu ouktüsükalüirua ");
INSERT INTO guc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","sümaa sujuitteerüin mmaapüjee. Chi wayuu eekai naa'inrapü'üin tü anasükat kataiwa'aya no'u, oso'iraweechi aa'in süpüla eeinjachin nümaa Maleiwa süpüla ka'ikat süpüshua. Otta chi eekai naa'inrapü'üin tü mojusükat kataiwa'aya no'u, oso'iraweechi aa'in süpüla süsaleechin nia naainjala”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ayatüshi Jesús sünain aashajawaa namüin na laülaayuu judíokana: “Nnojotsü kasain tountüin taa'inrüin tamüiwa. Shia kee'ireeka taa'in tü talatakat atüma naa'in Maleiwa chi kajünalakai taya, nnojotsü shiain tü talatakat atüma ne'e taa'in tayakai tamüiwa. Süka shiain taa'inrüin tü nümakat chi Maleiwakai tamüin, lotüsü waneepia sukuaippa tatüma sünain kasalajanain saainjala wayuu. ");
INSERT INTO guc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Müleka tayale ne'e aküjiraain tachiki, nnojoleerü kapülain jaa'in tü taküjakat jümüin, nnojoleerü jünoujain sünain shiimüin shia. ");
INSERT INTO guc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Otta müshia chi Tashikai, nia pansaaka atüma tachiki. Je tatüjaa aa'ulu sünain shiimüin tü nükajakat tachiki. ");
INSERT INTO guc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Otta müshia chi Juankai nünülia, pansaasü tachiki nütümaya wanaa sümaa jüjütüin paala wane wayuuirua nünainmüin süpüla nasakirüinjachin nia too'opünaa. Aküjashi nia tü shiimüinkat tachiki namüin. ");
INSERT INTO guc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nnojotsü tamüin jümüin tüü sükajee che'ojaain tamüin wayuu, makai aka Juan, süpüla apansaajaa tachiki. Toso'ireein ne'e jaa'in sünain nüchiki Juan shii'iree jünoujeein tü nümakat tachiki süpüla ju'tte'ennüinjanain sütüma. ");
INSERT INTO guc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Soto jaa'in wanaa sümaa talatapünaainkain jaa'in sütüma nünüiki. Saa'u pansaainkain tü nümakat, müshinka aka nia saa'in wane anakia süka jütüjaainkain taa'u nütüma. ");
INSERT INTO guc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Sünainjee tü nümapü'ükat Juan tachiki, eesü wayuu eekai sünoujain sünain tayain ajünalaain nütüma chi Tashikai Maleiwa. Otta eesü wane apansaajakat ma'i tachikiya alana'aleesia sünain anain suulia tü shiimüin nüküjapü'ükat Juan. Shia tü kasa anasü taa'inrakat. Shiasa'a sütüma tekeraajüin tü nüchekakat chi Tashikai süpüleerua taa'inrüin, koo'omüinsü ma'i tü anoujasükalüirua tanain. ");
INSERT INTO guc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Otta müshia chi Tashika'iya, chi kajünalakai taya, pansaasü tachiki nütüma. Otta saa'u nnojolin jünoujain tanain taya ajütüüshikai nütüma, nnojotsü jaapüin nünüiki, nnojotsü ji'rüin nukuaippa, je nnojoliishii jüüjüüin ekii jia süpüla tü nümakat jümüin. ");
INSERT INTO guc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Jiyouktüin taya. Nnojoliishii jia jüüjüüin tamüin süpüla shii'iranajaainjatüin jaa'in tatüma. Saa'in jümüin, eeinjana jia nümaa Maleiwa süpüla ka'ikat süpüshua sünainjee ne'e jaashaje'erüin waneepia tü karaloukta nüchikimaajatkat. Taya tayakai chi saashajaakai achiki, chi anii joo ayouktünüin jütüma. ");
INSERT INTO guc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nnojoishi taya achajaashin su'waajaa wayuu maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Otta tatüjaa aa'una jia sünain nnojolin alin chi Maleiwakai jüpüla. ");
INSERT INTO guc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sünain tayain nüjünalain chi Tashikai süpüla laülawaa, nnojoishi kasajachin taya jümüin. Alu'ujasa müleka nüntüle joo ja'akamüin wane wayuu eekai nüküjiraain ne'e nüchiki, kamaneejeena jia nümüin. ");
INSERT INTO guc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nnojoishii jia anoujeein tanain, süka shiain kee'ireein ne'e jaa'in ju'waajüneein sütüma wayuu, je nnojotsü kee'ireein jaa'in aa'inraa tü talatajaikat amaa Maleiwa, chi waneeshikai Maleiwain. ");
INSERT INTO guc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nnojoleechi tayain aküjüin nümüin chi Tashikai jüchiki sünain kaainjaraliin jia. Shieerü tü nikirajapü'ükat anain Moisés aküjaka jüchiki sünain kaainjaraliin jia, tü o'tte'enneetkat atüma jia saa'in jümüin. ");
INSERT INTO guc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Müleka shiimüinreje sünain jünoujain nünüiki Moisés, jünoujainje tanüiki süka taya'inya ne'e nüshajüin achiki. ");
INSERT INTO guc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Saa'u nnojolüin jünoujain tü nüshajakat achiki, nnojoleerü jünoujain tü taküjakat joolu'u jümü'inya”, nümakalaka Jesús namüin na laülaashii judíokana. ");
INSERT INTO guc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nu'unakalaka Jesús Jerusalénjee nüchikua Galileamüin. Shiasa mapa süchikijee nüntüin, o'unüshi nia namaa na nikirajüinkana sulu'u wane anua waneemüin sa'ata tü palaa kanüliakat Galilea. (Otta suwala'ata sünülia tü palaakat, Tiberias.) ");
INSERT INTO guc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Okoutsü wayuu watta saalin nüchiirua Jesús süka suu'ui, süka shi'rüin nia sünain aa'inraa tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa, maa aka eiyajaa wayuu eekai ayuulin. ");
INSERT INTO guc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Je Jesús namaa na nikirajüinkana, o'unüshii saa'umüin wane namünashii. Naikkaajaakalaka süpüla nekirajünüinjanain nütüma. ");
INSERT INTO guc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Alü'ütsü joo sükalia tü Pascuakat, tü nemi'irakat na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ni'rapa Jesús süntapaatüin watta saalin wayuuirua nünainmüin, nümakalaka nümüin Felipe: —¿Jaleena waya ayalajüin eküülü shikajatkat watüma tü wattakat saalin wayuu? ");
INSERT INTO guc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Asakitshi Jesús sünain tüü süpüla nütüjaainjatüin ne'e saa'u sünain jameerüin nünüiki ni'ipajee. Nütüjaatüjülia aa'u Jesús tü naa'inrüinjatkat. ");
INSERT INTO guc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nüsouktakalaka Felipe ni'ipajee: —Atak, wainma neerü sücheküin shiküinria türa wayuukolüirua. Ja'itakaja'a paliruwalin ne'e neküin, nnojoleerü ekeraajüin naka shi'yataainjut wane wayuu so'u mekiisat kashi. ");
INSERT INTO guc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nümakalaka joolu'u wane, chi kanüliakai Andrés, chi nimüliakai Simón Pedro: ");
INSERT INTO guc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ani'isa wane jintüi kama'anashi ja'raisü panchen aainjuushi süka “cebada”, otta piamasü ne'e jimechen asijuushi. Nnojoluja'a keraainjatüin namaa napüshua —nümakalaka Andrés nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nümakalaka Jesús namüin na nikirajüinkana: —Anakaja müleka jüikkale'erüle tü wayuukolüirua mmalu'u. Eesü wainma alama yala je süikkaajaakalaka tü wayuukolüirua saa'u tü alamakat. Eejana maa aka 5.000 tooloyuu sa'aka tü wayuukolüirua süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Niasa Jesús, naapaakalaka tü pankat sünain naapüin analu'ut nümüin Maleiwa saa'u. Niitajakalaka joo tü pankat namüin na nikirajüinkana süpüla neitajüin sümüin tü wayuukolüirua süpüshua yaasükalüirua joyojoyolüin. Akaajaa sukuaippa tü jimekat nütümaya. Eküshii naya napüshuale'eya, emirashii sünainjee. ");
INSERT INTO guc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Shiasa emirapa tü wayuukolüirua, —Jükotchajapa tü süpütaalakat suulia mojujain —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sükotchajünakalaka tü süpütaalakat, maa aka poloo piammüin katto'ui süpütaala tü ja'raisükat pan süchikijee shikaain tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Shiasa ne'rapa na wayuukana tü naa'inrüitpakat Jesús sünain shiain tü nütüjakat apüleerua Maleiwa nümüiwa, o'ttüshii naya sünain aashajaajirawaa nüchiki sünain maa: —Shiimüintaaja'aya Jesús sünain niain chi Nünüikimaajachikai Maleiwa, chi antajachikai anülia sa'akamüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Otta müshia Jesús, süka niyaawatüin naa'u na wayuukana sünain ne'itaweein nia süpüla aluwatawaa, o'unajaashi nia noulia nüchikua saa'umüin wane namüna naata. ");
INSERT INTO guc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Shiasa motsopa ka'i, ashakanuwaashii na nikirajüinkana Jesús yalajee saa'ujee tü namünakat solumüin tü palaakat. ");
INSERT INTO guc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Shiasa mapa aipa'a, süka nnojolüin nüntüin Jesús napülamüin, o'otooshii naya sulu'u tü na'anuainkat süpüla ale'ejaa waneemüin sa'ata tü palaakat eemüin tü pueulo kanüliakat Capernaum. ");
INSERT INTO guc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Shiasa süchikijee no'unüin sulu'u tü anuakat maa aka aippirua kilómetro, napanapajakalaka joo wane wawai. Katsüinsü ma'i joo tü palaakat sütüma. Ne'rakalaka joolu'u Jesús alü'ülaain nachiirua sünain waraittüin nia soo'opünaa tü palaakat. Süka nnojolüin natüjaain naa'u sünain niain Jesús, mmotshii naya. ");
INSERT INTO guc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","—Nnojo mmolüin jia. Taya tayakai ji'raka —nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Talatakalaka ma'i naa'in nikerolapa Jesús sulu'u tü anuakat, je nantalaa namaka'a sotpa'amüin tü palaakat eemüinjanale nantüin. ");
INSERT INTO guc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Shiasa mapa waneemüin ka'ikat, mo'unüinsat tü wattakat saalii wayuu chajee waneejee sa'ata tü palaakat eejanale nekaain paala tü pan naapakat Jesús namüin. Süka natüjaain naa'u sünain no'unüin na nikirajüinkana sulu'u tü waneesükat anua eejatkat paala sotpa'a tü palaakat sümaa nnojolin namaain Jesús, nnojotsü nayaawatüin aa'u jamüin nukuaippa Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Süntakalaka joolu'u wane anuairua chajee sulu'ujee tü pueulokat Tiberias sotpa'amüin tü palaakat eejatüle paala naapüin chi Senyotkai analu'ut nümüin Maleiwa saa'u tü pankat sümaa nikirüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Otta müsia tü wayuukolüirua, sünain nayaawatüin saa'u sümaa nnojoliin Jesús oo'ulaka na nikirajüinkana, no'unakalaka chajee sulu'u tia anuakalüirua Capernaummüin süpüla nachajaainjachin nüchiki Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nantapa na wayuukana nünain Jesús cha'aya Capernaum, namakalaka nümüin: —Ekirajüikalee, ¿joujachi pia antüin yaamüin yaa? ");
INSERT INTO guc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nüsouktakalaka Jesús namüin: —Tamüsü paala jümüin tü shiimüinkat: Jüchajaa achikichi ne'e taya süka emirain jia tatüma süka tü pankat, nnojotsü sükajeejatüin jiyaawatüin saa'u tü taa'inrakat ju'upala, tü nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nnojo kachiiruain jaa'in tü eküülü atüjakat aja'lajawaa, shia kachiirua jaa'in tü eküülü katüinjatkat atüma jo'u waneepia nümaa Maleiwa. Shia tü eküülü taapeekat jümüin tayakai chi Shipayakai Wayuu, süka laülaain taya süpüla tia nütüma chi Tashikai Maleiwa —nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nasakirakalaka Jesús: —¿Kasa waa'inrüinjatka süpüla wekeraajüinjatüin tü nüchekakat Maleiwa wapüleerua? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Asouktüshi Jesús ne'ipajee: —Tü nüchekakat Maleiwa jüpüleerua, shia jünoujainjanain tanain tayakai chi nüjünalakai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Namakalaka na wayuukana nümüin Jesús: —Sotüsü waa'in tü ashajünakat nachiki na watuushikana sümaiwa paala, makat mayaa: “Eküshii naya nütüma tü pan chajeejatkat iipünaajee”, müsü. Otta müsia joolu'u, anakaja müleka paa'inrüle wo'upala wane kasa anasü, tü nütüjakat apüleerua Maleiwa nümüiwa, maa aka tü aa'innakat paala namüin na watuushikana cha'aya isashiipa'a sünain saapünüin waneepia namüin nütüma Maleiwa tü pan kanüliakat “maná” münüin. Müleka pii'iyatüle wamüin sünain shiimüin piain chi nüjünalakai Maleiwa, kapüleerü waa'in tü pümakat wamüin —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nümakalaka Jesús namüin: —Tamüsü paala jümüin tü shiimüinkat: Tü eküülü naapakat paala Moisés namüin na jutuushikana, nnojotsü shiain tü pan chajeejatkat iipünaajee. Nia chi Tashikai nümüiwa aapaka jümüin tü pan shiimüinsü iipünaajeejatkat. ");
INSERT INTO guc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tü pan naapakat chi Maleiwakai, nia chi ashakatakai chajee iipünaajee nüma'anajee, nia chi aapünakai atüma kataa o'u sümüin wayuu süpüshua —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Ekirajüikalee, paapa tia pankat wamüin waneepia —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Asouktüshi Jesús: —Müshi tachikua: Taya chi pan iipünaajeejachikai. Maa aka katsüin naa'in na jutuushikana sütüma tü eküülü naapakat Moisés paala namüin, sümaa nnojolüin jamüsirüin je nnojolüin miyaasüin, akaweenia jiakana talateerü jaa'in müleka jünoujüle tanain süka shii'iranajaweerüin jaa'in. ");
INSERT INTO guc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Akanasa'a manoujüinyeein jia tanain, maa aka tü tamayütkat, mayaashije ji'rüin taya. ");
INSERT INTO guc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Otta chi wayuu eekai ni'itaain chi Tashikai süpüla niainjachin tapüshin, anoujeechija'a tanain. Je sükajee tia, nnojoleechi taleejüin nia. ");
INSERT INTO guc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Ashakatüshi taya yaamüin chajee iipünaajee süpüla taa'inrüinjatüin tü talatakat atüma naa'in Maleiwa chi kajünalakai taya, nnojotsü shiain süpüla tü talatakat atüma ne'e taa'in tayakai tamüiwa. ");
INSERT INTO guc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nnojotsü nücheküin Maleiwa süpüleerua amüloulinjatüin toulia süchikijee ouktaa waneesükaije'e na'akajee napüshua na ni'itaakana süpüla nayain tapüshin. Shia nüchekaka napüleerua taso'ire'erüinjateerüin naa'in napüshua so'uweena tü ka'i süsaleetkat o'u saainjala tü manoujainsatkalüirua. ");
INSERT INTO guc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nücheküin chi Tashikai süpüleerua shii'iranajaainjatüin naa'in napüshua na eekai nanoujain tanain sümaa nayaawatüin taa'u sünain tayain chi Nüchonkai Maleiwa. Eejeena naya nümaa süpüla ka'ikat süpüshua, süka shiimüin sünain taso'ire'erüinjateerüin naa'in napüshua so'uweena tü ka'i süsaleetkat o'u saainjala tü manoujainsatkalüirua”, nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Otta müshi'iya na laülaashii judíokana sütüma tüü, no'ttakalaka sünain mojuin nanüiki nümüin Jesús, süka “Taya tayakai chi pan ashakatakai chajee iipünaajee”, nümüichipain namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aashajaajiraashii naya sünain maa: —Shiimüin sünain we'raajüin chi nüshikai je tü niikat. ¿Nnojoishi niain ne'e chi nüchonkai José? ¿Jamakuaippatka'a joo tü nümakat wamüin sünain nüshakatshin chajee iipünaajee nüma'anajee Maleiwa? —namakalaka na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nümakalaka Jesús namüin: —Juu'ulaa suulia mojuin jünüiki tamüin. ");
INSERT INTO guc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Napüshua na antakana tanainmüin, taso'ire'ereena aa'in so'uweena tü ka'i süsaleetkat o'u saainjala tü manoujainsatkalüirua. Otta chi eekai nnojolin eenakuushin nütüma chi Tashikai kajünalakai taya, nnojoleechi antüin tanainmüin. ");
INSERT INTO guc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Soto jaa'in tü ashajünakat paala nütüma wane nünüikimaajachikai Maleiwa noo'opünaa na anteenakana tanainmüin, müsü mayaa: “Ekirajüneerü wayuu süpüshua nütüma Maleiwa”, müsü. Je joolu'u, tamüshii paala jia: Napüshua na wayuu kapülakana aa'in nünüiki chi Tashikai shii'iree nashatüin tü nikirajakat anain, anteena naya tanainmüin. ");
INSERT INTO guc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Nnojoishi taya aküjashin jümüin süchiki sünain ni'nnüin chi Tashikai sütüma wayuu. Chi e'rakai chi Tashikai, taya tayakai tamüiwa süka chaje'ewalin taya nüma'anajee. ");
INSERT INTO guc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Tamüsü paala jümüin tü shiimüinkat: Chi wayuu eekai ni'itaain naa'in sünain anoujaa tanain, ee'iranajaweerü naa'in süpüla eeinjachin nia nümaa Maleiwa süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Müshi taya tachikua: Taya'a chi pan katakai atüma so'u wayuu. ");
INSERT INTO guc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mayaasüje nekapü'üin na jutuushikana paala sümaiwa tü eküülü kanüliakat ‘maná’ münüin cha'aya isashiipa'a, ayatshii ouktüin sümaa nnojolüin shii'iranajaain naa'in. ");
INSERT INTO guc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Otta müsia tü pan chajeejatkat nüma'anajee Maleiwa iipünaajee, ashakatüitpa. Chi eekai niküin shia, nnojoleechi amüloulin. ");
INSERT INTO guc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Taya tayakai chi pan ashakatakai nüma'anajee Maleiwa, taya chi katakai atüma so'u wayuu. Chi eekai niküin tü pankat, eejeechi nümaa Maleiwa süpüla ka'ikat süpüshua. Tü pan taashajaakat achiki jümaa, shia tü te'iruku taapüinjatkat süpüla katüinjatüin so'u wayuu wainma”, nümataalakalaka Jesús namüin na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naashichijaakalaka na judíokana nümüin Jesús saaliijee tü nümakat namüin. Na'ülüjiraakalaka sünain maa: —¿Jamüshikai chira wayuukai naapüinjatka'a ni'iruku wamüin süpüla weküinjatüin shia? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nümakalaka Jesús namüin: —Tamüsü paala tü shiimüinkat jümüin: Müleka nnojorule jiküin tü te'irukukat tayakai, chi Shipayakai Wayuu, je müleka nnojorule jüsüin tü tashakat, shiimüin sünain nnojoleerüin katüin jo'u. ");
INSERT INTO guc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Otta chi eekai niküin tü te'irukukat sümaa nüsüin tü tashakat, ee'iranajaweerü naa'in süpüla eeinjachin nia nümaa Maleiwa süpüla ka'ikat süpüshua, je taso'ire'ereerü naa'in so'uweena tü ka'i süsaleetkat o'u saainjala tü manoujainsatkalüirua. ");
INSERT INTO guc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Süka jamüin, tü te'irukukat, shiimüin sünain eküülüin, je tü tashakat, shiimüin sünain asüüshin. ");
INSERT INTO guc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chi eekai niküin tü te'irukukat sümaa nüsüin tü tashakat, wanaawajiraweerü naa'in tamaa je eeweechi taya waneepia nümaa. ");
INSERT INTO guc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Ajütünüshi taya nütüma chi Tashikai, chi katakai atüma so'u wayuu, sümaa naapüin tamüin kataa o'u. Akaweechia chi wayuu eekai niküin tü te'irukukat, taapeechi amüin nia kataa o'u. ");
INSERT INTO guc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tayakai, taya chi pan ashakatakai chajee nüma'anajee Maleiwa. Nnojoishi taya müin aka saa'in tü eküülü kanüliakat ‘maná’ nekapü'ükat na jutuushikana. Mayaasüje neküin shia, ayatshi'iya ouktüin naya. Otta chi eekai niküin tü pan iipünaajeejatkat, eejeechi nümaa Maleiwa süpüla ka'ikat süpüshua”, nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Shiairaja'a ne'e nünüiki Jesús namüin na wayuukana cha'aya Capernaum sulu'u tü ekirajüleekat na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sütüma tü nümakat Jesús, sümakalaka wainma tü wayuukolüirua waraittiraapü'ükat nümaa: —Nnojotsüsa'a kapüleein waa'in tü nümakat wamüin. Nnojoleerü wountüin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nütüjaapa saa'u Jesús nojuunajee sünain mojuin nanüiki nümüin, nümakalaka namüin: —¿Mojushiisü jümüin tü tamakat? ");
INSERT INTO guc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Shia cheje jameematüin jünüiki müleka ji'rüle taya, chi Shipayakai Wayuu, sünain o'unaa tachikua chaa iipünaamüin eejachire paala taya? ");
INSERT INTO guc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Anakaja jütüjaale saa'u wane kasa: Nnojoleerü ee'iranajaain saa'in wane wayuu sütüma tü kasa saa'inrakat ne'e sümüiwa, nieechi ee'irataka chi Naa'inkai Maleiwa. Otta müshi'iya jiakana, müleka kapürale jaa'in tü pütchi tamakat jümüin, aapüneechi jümüin chi Naa'inkai Maleiwa katüinjachikai atüma jo'u. ");
INSERT INTO guc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eeshii ja'aka eekai nnojolüin nanoujain tanain mayaasüje jaapajüin tanüiki”, nümakalaka Jesús namüin. Nümüsü tüü süka nütüjaatüjülü'inya saa'u paala sünain eein wayuu nnojolüinjatkat anoujain nünain je jaralinjachin chi wayuu aapüinjachikai nikii. ");
INSERT INTO guc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nümakalaka Jesús nüchikua: —Shiaja'a tü tamakat paala: Chi wayuu eekai nnojolin e'itaaushin nütüma chi Tashikai süpüla anoujaa tanain, müichia nnojolin antüin tanainmüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Süchikijee tia, oo'ulaayaa müsü wainma tü wayuukolüirua waraittiraapü'ükana nümaa. ");
INSERT INTO guc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nüsakirakalaka Jesús na polookana piammüin nikirajüin: —Jama jiakana, ¿jamüinjatü jukuaippa? ¿O'uneeshii jia tama'anaje'eya? ");
INSERT INTO guc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nüsouktakalaka Simón Pedro nümüin Jesús: —Senyotkalee, nnojotsü wayuu eekai müin aka pia wo'unüinjachikai anainmüin, süka shiimüin sünain shii'iranajaaitpain waa'in sütüma pünüiki süpüla eeinjanain waya waneepia nümaa Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ayatüinjana waya sünain anoujaa pünain, süka watüjaain paa'u sünain piain chi Maainjalasaikai ajütünakai wanainmüin nütüma Maleiwa —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nümakalaka Jesús: —Shiimüin sünain jüneekuushin tatüma jüpüshua, jiakana polookana piammüin. Otta waneeshia ja'akajee, oonooshi sümaa nünüiki chi Yolujaakai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Chi naashajaakai achiki Jesús, nia Judas chi nüchonkai Simón Iscariote. Mayaainje niain napüshi na polookana piammüin aneekuushikana nütüma Jesús, nia'a ne'e aapajachika nikii Jesús mapeena.) ");
INSERT INTO guc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Shiasa süchikijee tia, makatüshi Jesús sulu'u tü mmakat Galilea sünain waraittaa sulu'upünaa tü pueulokalüirua. Nnojoishi ale'ejeein chamüin Judeamüin, süka nu'utüneein aa'in natüma na laülaayuu judío chakana cha'aya. ");
INSERT INTO guc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Otta sülü'ülapa tü mi'iraa kanüliakat “Tü Lumakalüirua” cha'aya Jerusalén natüma na judíokana, ");
INSERT INTO guc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","namakalaka na nimüliayuukana Jesús nümüin sünain neme'erainpalain nia: —Anakaja pu'unüle yaajee yaa chamüin cha'aya Judeamüin sünainmüin tü mi'iraakat süpüla ne'rüinjanain na pikirajüinkana tü kasa paa'inrakat. ");
INSERT INTO guc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Müleka shiimüinre sünain paa'inrüin tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa, pii'iyata shia sümüin wayuu süpüshua. Nnojoleechi e'nnaajünüin pia sütüma wayuu wainma müleka punujulajüi tü paa'inrakat suulia —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mayaainje nuwalayuuin naya, nnojoishii anoujain nünain. ");
INSERT INTO guc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nüsouktakalaka Jesús namüin: —Nnojoyülia antüin tü takaliakat süpüla o'unaa chamüin. Otta jiakana, eeshii süpüla ju'unüin so'u ka'i eekai eein ne'e. ");
INSERT INTO guc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nnojotsü kasain maalinjatüin anainjee jia süpüla tü wayuukolüirua sainküin mma. Otta tayakai, kanainshi naa'in saaliijee taküjüin namüin sünain kaainjalain tü naa'inrakat. ");
INSERT INTO guc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ju'una jumata sünainmüin tü mi'iraakat cha'aya Judeamüin. Nnojoishi taya o'unajachin joolu'u, süka nnojoliyülüin kettaain takalia süpüla o'unaa —nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Makatakalaka joo Jesús kojuya ka'i soo'omüin yaa sulu'u tü mmakat Galilea. ");
INSERT INTO guc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Süchikijee no'unüin na nimüliayuukana Jerusalénmüin sünainmüin tü mi'iraakat, o'unüshi Jesúsya. Nüntakalaka chamüin sujuunajee wayuu süpüla nnojolinjachin ni'nnüin sütüma. ");
INSERT INTO guc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Je na laülaayuu judíokana cha'aya Judea, nasukajaa achikichi Jesús sünain tü mi'iraakat sünain: —¿Jalashi cheje eera nia? —sünain namüin. ");
INSERT INTO guc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ejejeraasü nüchiki Jesús wainma tü e'rajüsükalüirua sukua tü mi'iraakat. “Analeeshi chi wayuukai”, müshii waneeirua. Je tü waneeirua, “Nnojoishi nia anamiain. Aküjüshi na'alain sümüin wayuu”, müshii. ");
INSERT INTO guc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nnojoishi naashajaain achiki Jesús no'upala na laülaayuu judíokana süka mmolüin naya neema. ");
INSERT INTO guc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Maa aka shiatapünaa tü mi'iraakat, nikerolokoloko Jesús sulu'umüin süpaatiase tü a'waajüleekat Maleiwa süpüla ekirajaa tü wayuu e'rajüsükalüirua sukua tü mi'iraakat. ");
INSERT INTO guc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Otta na laülaayuu judíokana, ponusü ma'i naa'in tü nümakat Jesús namüin na wayuukana. —¿Jamüshi cheje eera nütüjaaka saa'u kasa wainma sümaa nnojolin ekirajuushin nia maa aka waya? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nümakalaka Jesús namüin: —Tü tekirajakat anain, nnojotsü pütchin tale'eru'ujeejatü ne'e, naapajala tamüin chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chi wayuu eekai naa'inreein tü nüchekakat Maleiwa nüpüleerua, nütüjaweerü aa'u tü tekirajakat anain müleka nüma'anajeejatüle Maleiwa oo'ulaka pütchire ne'e tale'eru'ujeejatü. ");
INSERT INTO guc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Chi wayuu eekai nikirajüin shii'iree kojuteein nia sütüma wayuu, ekirajüshi süka pütchi nüle'eru'ujeejatü ne'e. Otta tayakai, ekirajüshi süpüla niainjachin kojutüin chi kajünalakai taya. Je sükajee tia, jütüjaweechi aa'u taya sünain shiimüin tanüiki waneepia. Müichia taya nnojolüin aküjain alawaa. ");
INSERT INTO guc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ju'utee aa'inchi taya süka nnojolin toonooin sümaa nünüiki Moisés saa'in jümüin. Otta jiakana, mayaainje jiain aapünüin amüin tü nuluwataakat anain Moisés, nnojotsü waneesüyaakaije ja'aka eekai soonooin sümaa tü nümakat jümüin —nümakalaka Jesús namüin na laülaayuu judíokana. ");
INSERT INTO guc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nasouktakalaka na wayuukana napüshua sümaa patatüin naya sütüma tü nümakat namüin: —Mamainnataashi pia sütüma kale'eru'uin yolujaa. ¿Jarai chi o'uteeka paa'in? ");
INSERT INTO guc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nümakalaka Jesús namüin na wayuukana: —Süka taa'inrüin wane kasa anasü ju'upala, tü nütüjakat apüleerua Maleiwa nümüiwa, mojushiisü jümüin süka taa'inrüin shia so'u sükalia eemerawaa süka a'yatawaain shia saa'in jümüin. ");
INSERT INTO guc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Otta jiakana, a'yataapü'üshii jia so'u sükalia eemerawaa sünain ji'yotooin nüta chi jüchonkai süpüla joonooin sümaa tü nuluwataakat anain Moisés. (Otta na aluwataakana sünain, naya na jikiishiikana nüpülapünaa Moisés.) ");
INSERT INTO guc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Saa'u ji'yotooin nata na jüchooinkana so'u sükalia eemerawaa süpüla keraainjatüin jütüma tü nuluwataakat anain Moisés, ¿jamaka'a jia jashichika'a tamüin saa'u teiyajüin wane ayuuishi so'u sükalia eemerawaa süpüla anainjachin nia? ");
INSERT INTO guc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Müleka jülüjüle jaa'in tü taa'inrakat so'u ka'ikat tia, jiyaawateechi aa'u taya sünain lotüin takuaippa je nnojoleena jia ayatüin sünain ayoujoo taya —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Naashajaajiraakalaka noo'opünaa Jesús waneeirua wayuu kepiashii Jerusalén sünain namüin mayaa: —Atak, shiimüin sünain niain chi no'uteekai aa'in na laülaayuukana. ");
INSERT INTO guc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Jamüshii ko'utaka'a naya joolu'u wanaa sümaa naashajaain su'upala tü wayuukolüirua? ¿Nayaawatataaichipale aa'u sünain niain chi Cristokai anülia, chi Nüneekajalakai Maleiwa? ");
INSERT INTO guc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Otta saa'in wamüin, nüntapa Cristo, nnojoleerü atüjaanüin aa'u sünain jalaje'ewalin nia. Otta chii, watüjaa aa'ut sünain jalaje'ewalin —müsü tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Otta müshia Jesús, wanaa sümaa nikirajüin tü wayuukolüirua yaa sulu'u tü süpaatiasekat tü a'waajüleekat Maleiwa, nuwoottaakalaka sünain maa: —Ji'raajayaain taya jaa'inru'u, jütüjaayaa aa'uchi taya jaa'inru'u sümaa jalaje'ewalin taya. Otta antüshiwalain taya süka taa'in ne'e tamüiwa. Ajütüüshi taya nütüma Maleiwa chi nnojoikai ji'raajüin. Je pansaasü nünüiki waneepia. ");
INSERT INTO guc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Te'raajüin nia süka chajeejachin taya nüma'anajee je süka nuluwanaajalain taya —nümakalaka Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Narütkaakalaka joolu'u wane laülaayuu judíokana nünainmüin Jesús süpüla nata'ülüinjachin nia saaliijee tü nümakat sünain chajeejachin nüma'anajee Maleiwa. Mayaashiije nata'üleein nia, nnojoishi nountüin ne'itaain najapü nünain. Süka jamüin, nnojoliyülia kettaain nükalia Jesús süpüla ata'ünnaa. ");
INSERT INTO guc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Otta sa'aka tü wayuukolüirua, eesü wayuu wainma eekai sünoujain nünain Jesús sünain niain Cristoin, chi Nüneekajalakai Maleiwa. Aashajaajiraashii naya sünain müin mayaa: —Je saashin tü ekirajünapü'ükat anain waya nüchiki chi Nüneekajalakai Maleiwa, naa'inreerü wainma kasa anasü nüntapa, tü nütüjakat apüleerua Maleiwa nümüiwa. Je joolu'u, süka we'rüin Jesús sünain naa'inrüin tia, wanoujaitpa sünain niain Cristoin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Naapakalaka na fariseokana sünüiki tü wayuukolüirua sünain nejejeraain nüchiki Jesús. Na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na fariseokana, najütakalaka nünainmüin Jesús waneeirua susurulaatseirua tü a'waajüleekat Maleiwa süpüla nata'ülüinjachin nia. ");
INSERT INTO guc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Je nantapa nünainmüin Jesús, naapüin nünüiki sünain nikirajüin tü wayuukolüirua sünain maa sümüin: —Yaajeechi taya jümaa so'u palit ka'i ne'e. Je süchikijee, o'uneechi taya eemüin chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jüchajaweechi achiki taya, otta nnojoleechi jüntüin anain taya. Nnojoleerü juuntüin o'unaa chamüin eemüinjachire taya. ");
INSERT INTO guc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aashajaajiraashii joolu'u na laülaayuu judíokana sünain maa: —¿Jalawai cheje o'unüin joolu'u chii, nnojolinjachika'a wantüin nünain naashin? ¿Chainjaittaale eera na'akamüin na wapüshi kepiakana sa'aka tü wayuukolüirua griegokat anülia, süpüla nikirajüinjanain na griegokana? ");
INSERT INTO guc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jamalu'ut cheje eera nünüiki nümakalaka wamüin: “Jüchajaweechi achiki taya, otta nnojoleechi jüntüin anain taya”? ¿Je jamalu'ut nütüma tü “Nnojoliiyülia juuntüin o'unaa chamüin eejeechire taya” nümakat? ");
INSERT INTO guc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Je so'u tü ka'i saja'lajaakat o'u tü mi'iraakat, tü ka'i alana'aleekat sünain anain, nüsha'walaakalaka Jesús sünain maa sümüin tü wayuukolüirua emetut: —Chi eekai münyaasüin, anashi nüntüle tanainmüin nüsaiwa, ");
INSERT INTO guc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","maa aka tü ashajünakat sulu'u tü nüchikimaajatkat Maleiwa makat: “Chi eekai nünoujain tanain, meerü aka süparalakai wüin sulu'u naa'in, tü katakat atüma so'u wayuu” —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tü wüin nümakat Jesús, nia chi Naa'inkai Maleiwa aapüneechikai namüin na eekai nanoujain nünain. Maapujuyülia nia süka nnojoliyülin ayalennüin Jesús iipünaamüin nünainmüin chi Maleiwakai. ");
INSERT INTO guc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Shiasa su'uluku tü e'rajüsükat sükua tü mi'iraakat saapapa nünüiki Jesús, müshii yaa: “Shiimain sümaa niain chi Nünüikimaajachikai Maleiwa ajütünajachikai so'uweena wane ka'i sa'akamüin wayuu”. ");
INSERT INTO guc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Otta sünüiki waneeirua: —Nia chi Cristokai anülia, chi Nüneekajalakai Maleiwa —müshii. Otta waneeirua: —¿Chaje'ewalinjachika joo chi Cristokai Galileajee? Nnojottaa. ");
INSERT INTO guc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Saashin tü nüchikimaajatkat Maleiwa, niainjachi wane nuu'uliwo'u David, je chaje'ewalinjachi Belénjee eejechinkale kepiain David —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nnojotkalaka wanaawain saa'in tü wayuukolüirua noo'opünaa Jesús. ");
INSERT INTO guc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mayaainje nata'üleein nia waneeirua, nnojotsü nountüin ne'itaain najapü nünain. ");
INSERT INTO guc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nale'ejakalaka joo na susurulaatsekana tü a'waajüleekat Maleiwa eemüin na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na fariseokana. Nasakinnakalaka natüma: —¿Jamüshi nnojoika'a jüntirüin nia yaamüin? ");
INSERT INTO guc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nasouktakalaka na surulaatkana namüin: —Saa'in wamüin, nnojotsü wayuu eekai keme'eriain ma'i sünüiki maa aka niakai. ");
INSERT INTO guc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Namakalaka joo na laülaashii judíokana namüin sünain neme'erainpalain naya: —¿Kapülaitpa jaa'in jiakanaya joo tü alawaa aküjünakat nütüma? ");
INSERT INTO guc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Otta wa'aka wayakana na laülaayuushii judíokana oo'ulaka na fariseokana, nnojotsü eein eekai sünoujain nünain. Je müleka sünoujüle nünain tü wattakat saalii wayuu, nnojotsü jamajatüin wamüin. Matüjaainsalii naya saa'u tü nuluwataakat anain Moisés —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wanaa sümaa naashajaajiraain na laülaashiikana, nüsouktakalaka joo waneeshia fariseo chi kanüliakai Nicodemo, chi antakai paala nünainmüin Jesús: ");
INSERT INTO guc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Saashin tü nuluwataakat anain waya Moisés, nnojotsü anain müleka we'itaale wane wayuu süpüla süsalainjachin naainjala süpülapünaa saapünüin nünüiki naa'ujiraa —nümakalaka Nicodemo namüin na nüpüshikana. ");
INSERT INTO guc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nasouktakalaka nümüin: —¿Galileaje'ewaija'a joolu'u pia? Müleka paashaje'erüle tü nüchikimaajatkat Maleiwa, piyaawateerü aa'u sünain nnojolin Galileaje'ewalinjachin wane nünüikimaajachi Maleiwa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Süchikijee tia, no'unakalaka napüshua nepialu'umüin. ");
INSERT INTO guc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","O'unüshi Jesús saa'umüin wane wutai kanüliasü Olivos sü'ütpa'asü Jerusalén. ");
INSERT INTO guc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Je shiasa mapa watta'a maalü waneemüin ka'ikat, ale'ejaashi nia Jerusalénmüin sulu'umüin süpaatiase tü a'waajüleekat Maleiwa. Nüikkalaakalaka süpüla nikirajüinjatüin tü wayuukolüirua eekai süntüin nünainmüin. ");
INSERT INTO guc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Otta na karalouktamaajanakana je na fariseokana, nantitkalaka joo wane jierü nünainmüin Jesús. Nata'ülüin shia süka süma'üjaain nümaa wane wayuu nnojoikai su'wayuusein. Nantirüin shia su'upala wayuu süpüshua ");
INSERT INTO guc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","sümaa namüin nümüin Jesús: —Ekirajüikalee, antüna aa'ulu jietkat tüü sünain ama'üjawaa nümaa wane wayuu nnojoikai su'wayuusein. ");
INSERT INTO guc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Je saashin tü nüshajakat Moisés, ouktüinjatü süka a'ina'aluushin süka ipa wayuu eekai saa'inrüin makat aka tüü. ¿Jamüinja'a eera pünüiki soo'opünaa tüü? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Müsü nanüiki nümüin shii'iree niweetirüin wane pütchi kasalajanainjatkat nümüin natüma. Otta Jesús, ejepülaashi sünain ashajaa süka najapü sünain tü mmakat. ");
INSERT INTO guc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Je saa'u masütaajuin naya sünain asakiraa nia, nüsha'walaakalaka sünain nümüin wane pütchi namüin: —Chi eekai maainjalain yaa ja'aka, anashi niale palajachin sünain a'itaa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nejepülaakalaka Jesús nüchikua sünain ashajaa süka najapü sünain tü mmakat. ");
INSERT INTO guc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sütüma tü nümakat Jesús, o'unayaa müshii naya wane'ewai nakua sünain nayain o'unüin palajanale'eya na alatüinakana ouyase. Je no'unapa napüshua, nia'ala ne'e apütüüka Jesús sümaa tü jietkat yaa sha'watüin nü'ütpa'a. ");
INSERT INTO guc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Asha'walaa müshia Jesús sünain nümüin sümüin: —¿Jalakuaishii joolu'u na wayuu aapüinjanaka pikii? —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Ekirajüikalee, nnojotsü jaralüin —sümakalaka. —Akaajaa tayakai, nnojolüinjatü pia taapüin ekii. Anakaja pu'unüle. Otta joolu'u, puu'ulaa pümata suulia kaainjalaa —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Süchikijee tia, naashajaakalaka Jesús nüchikua sümüin tü wayuukolüirua sünain maa sümüin: —Müshiree aka taya saa'in wane anakia, süka shiyaawatüinjatüin saa'u tü shiimüinkat wayuu tatüma. Chi eekai tamaweein, ee'iranajaweerü naa'in tatüma müleka ni'itaale naa'in sünain anoujaa tü shiimüin tekirajakat anain nia. Je müichia nia nnojolin waraittüin sümaa piyuushi otta maa'awaa suulia tü shiimüinkat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Narütkaataalakalaka joo na fariseokana nachikua nünainmüin Jesús süpüla namajaainjanain nümüin: —Saa'u piain ne'e aküjiraain püchiki, maawainsat tü pümakat wamüin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nüsouktakalaka Jesús namüin na fariseokana: —Mayaainje taküjiraain tachiki, pansaasü tü tamakat, süka tatüjaain saa'u sümaa jalaje'ewalin taya otta jalamüinjachin taya. Alu'ujasa jiakana, nnojotsü jütüjaain aa'u sümaa jalaje'ewalin taya je sümaa jalamüinjachin taya. ");
INSERT INTO guc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jiyoujüin taya süka ne'e tü jülüjakat saa'in wayuu. Otta tayakai, nnojoishi antüshin süpüla kasalajanain tatüma sümüin saainjala wayuu. ");
INSERT INTO guc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Otta müleka süsarale shia saainjala tatüma, lotüsü ma'i tü tamakat, süka nnojolin tamüiwain taya. Eeshi chi Tashikai tamaa, chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Saashin tü nüshajakat Moisés jüpüla, müleka wanaawale naküjala piamashii wayuu soo'opünaa nukuaippa wane wayuu, pansaasü tia. ");
INSERT INTO guc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akaajaa müleka taküjiraale tachiki, pansaasü shia süka wanaawain sümaa tü nüküjakat tachiki chi Tashikai, chi kajünalakai taya. Je sükajee tia, anakaja müleka kapürale jaa'in shia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nasakirataalakalaka Jesús na fariseokana: —¿Jalaka'a joo chi püshikai paashin? Nüsouktakalaka namüin: —Nnojoishi ji'raajüin taya, je nnojoishi ji'raajüin chi Tashika'iya. Müleka shiimüinreje ji'raajüin taya, ji'raajüinje wanaa tamaa chi Tashikai —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nümüsü tüü wanaa sümaa nikirajüin yaa sulu'u tü a'waajüleekat sü'ütpa'a eere shi'itaanüin tü neerü asülajünakat. Mayaainje eejanain sa'aka tü aapajüsükalüirua nünüiki wane ka'ürülakana nia, nnojoishi ata'ünnüin natüma süka nnojoyülüin keraain nükalia. ");
INSERT INTO guc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Süchikijee tia, aashajaashi Jesús nüchikua sümüin tü wayuukolüirua yaa sulu'u tü a'waajüleekat Maleiwa sünain nümüin mayaa: —O'uneechi taya juulia mapeena. Ja'itakaje jüchajaawalainje tachiki, nnojoleerü juuntüin o'unaa chaa eemüinjachire taya. Oukteena jia sümaa jaainjala —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Otta na laülaayuu judíokana, naashajaajiraakalaka sünain maa: —¿Jamalu'ut tü nümakat: “Nnojoleerü juuntüin o'unaa chaa eemüinjachire taya”? O'uniraashijaittaale eera naa'in —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ayatshi Jesús sünain yootüin namaa na wayuukana sünain nümüin mayaa: —Jiakana, yaaje'ewalii mmolu'u sa'aka wayuu. Otta tayakai, chaje'ewai iipünaajee. Nnojoishi taya yaaje'ewalin sa'aka wayuu. ");
INSERT INTO guc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Taküjaitpa jümüin sünain oukteenain jia sümaa jaainjala. Müleka nnojorüle kapülain jaa'in tü tamakat sünain tayain tayakai chi taküjakai achiki, shiimain sünain oukteenain jia sümaa jaainjala —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Jaraikai piawai? —namakalaka nümüin. Nüsouktakalaka Jesús: —Taküjatüjülia tantaiwa'aya ja'akamüin sünain jaralin taya. Je tamüshii jia jüchikua: Taya tayakai chi taküjakai achiki. ");
INSERT INTO guc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Isasü wainma tü kasa tamüinjatkat jümüin sünain tayoujüin jia saaliijee jiyouktüin tanüiki. Otta tü taküjakat jümüin jiakana sainküin mmakat, shia ne'e tü nüküjalakat tamüin chi kajünalakai taya, süka pansaain waneepia tü nümakat tamüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sükajee nnojolüin nayaawatüin saa'u sünain niain nüküjüin achiki chi Nüshikai namüin, ");
INSERT INTO guc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","nümakalaka Jesús namüin: —Je so'uweena tü ka'i jükachereechikat o'u taya iipünaa, tayakai chi Shipayakai Wayuu, jütüjaweechi aa'u taya sünain tayain tayakai chi taküjapü'ükai achiki je sümaa nnojolüin talaülaajain tamüiwa sünain aa'inraa tü kasa anasü taa'inrakat. Tü tamakat jümüin, shia tü pütchi naapajalakat tamüin chi Tashikai. ");
INSERT INTO guc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Otta chi Tashikai, chi kajünalakai taya, tamaashi waneepia. Nnojoishi nuu'ulaain taya tamüiwa, süka taa'inrüin weinshi tü kasa talatakat atüma naa'in —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Je wainma tü wayuu aapajüsükalüirua nünüiki Jesús, kapülasü naa'in tü nüküjakat namüin sümaa nanoujain nünain. ");
INSERT INTO guc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nümakalaka Jesús namüin: —Müleka joonoole sümaa tanüiki waneepia, shiimüinshaana jiain tekirajüin. ");
INSERT INTO guc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Je jiyaawateerü aa'u tü shiimainkat süpüla jujuittüinjanain sütüma suulia achepchiaa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Otta na laülaayuu judíokana, nasouktakalaka nümüin Jesús sünain maa: —Wayakana, nuu'uliwo'u Abraham. Nnojoliishii waya süchepchiaajüin wayuu. ¿Jamalu'uja'a joo türa “jiyu'laaiwa suulia achepchiee” pümakat wamüin? ");
INSERT INTO guc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nümakalaka Jesús namüin: —Shiimüin tü tamakat jümüin: Chi wayuu eekai kaainjalain, süchepchiashi kaainjalaa. ");
INSERT INTO guc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Soto jaa'in tüü: Wane wayuu achepchiee, nnojoishi kasain nünain chi kachepchiakai. Alu'ujasa wane nüchon, nia kasaka nünain waneepia. ");
INSERT INTO guc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Müleka nujuittirüle jia chi Nüchonkai Maleiwa, shiimüin sünain taashiinapain jia. Nnojoliinapa jia müinya aka wane achepchiee. Müinapa aka wane achonlu. ");
INSERT INTO guc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tatüjaa aa'una jia sümaa nuu'uliwo'uin Abraham. Otta saa'u nnojolüin kapülain jaa'in tanüiki, ju'utee aa'inchi taya. ");
INSERT INTO guc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taküja achikit jümüin tü nii'iyatakat chi Tashikai tamüin. Otta tü jaa'inrakat, shia tü nüküjakat achiki jümüin chi jüshikai —nümakalaka Jesús namüin na laülaayuu judíokana. ");
INSERT INTO guc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Chi washikai, nia Abraham, chi koo'uliwo'ukai waya —namakalaka nümüin. Nüsouktakalaka Jesús namüin: —Müleka shiimüinreje nüchooin jia Abraham, jaa'inrüinje tü kasa anasü naa'inrapü'ükat. ");
INSERT INTO guc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Akaajasa jia, ju'utee aa'inchi taya mayaainje taküjüin jümüin tü shiimain aküjünakat tamüin nütüma Maleiwa. Nnojotsü naa'inrüin Abraham kasa eekai müin aka tia, tü jaa'inrakat jiakana maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Shia jüshataka ne'e tü kasa naa'inrakat chi jüshikai jüpüleerua —nümakalaka namüin. —Nnojoishii waya müin aka saa'in tepichi ajunalaa. We'raajüin chi Washikai, nia chi Maleiwakai nümüiwa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nümakalaka Jesús namüin na laülaayuu judíokana: —Müleka shiimüinreje niain jüshin Maleiwa, aishije taya jüpüla süka chaje'ewalin taya nüma'anajee Maleiwa. Nia'aya kajünalaka taya, nnojoishi antüshin ne'e taya ja'akamüin süka taa'in tamüiwa. ");
INSERT INTO guc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nnojotsü jiyaawatüin aa'u tü taküjakat achiki jümüin, süka nnojolüin kapülain jaa'in tanüiki. ");
INSERT INTO guc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Shia jaa'inreeka ma'i tü kasa mojusü nüchekakat jüpüleerua chi sülaülakai yolujaa, süka niain shiimüin jüshin. Nia o'ttatüjüikaja'a sünain uwomuyuwaa sümaiwa paala je ayatayüija'a nia maa'ulu yaa sünain. Nia kanainjeejachika'aya tü alawaakat. Niyouktüin tü shiimüinkat, shia jülüjaka naa'in tü alawaakat waneepia. ");
INSERT INTO guc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Akaajaa jiakana, nnojotsü joonooin amaa tü tamakat jümüin süka shiain tü shiimüinkat. ");
INSERT INTO guc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nnojotsü süpüla “wayuu kaainjarai pia” jümüinjatüin tamüin. Taküjain waneepia tü shiimüinkat jümüin, ¿jamüsü nnojotka'a kapülain jaa'in shia? ");
INSERT INTO guc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Na eekai nüpüshin Maleiwa, kapülasü naa'in nünüiki. Otta jiakana, nnojotka'a kapülain jaa'in nünüiki sükajeejatü nnojoliin nüpüshin jia —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nasouktakalaka na laülaayuu judíokana sünain mojulu'ulüin nanüiki nümüin Jesús: —Lotüsü tü wamakat püchiki sünain “Samariaje'ewai pia je kale'eru'ushi pia yolujaa” wamüin pümüin. ");
INSERT INTO guc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nümakalaka Jesús namüin: —Nnojoishi taya kale'eru'ushin yolujaa. Nia kojutka ne'e tatüma Tashi. Otta tayakai jütüma, mojutsai. ");
INSERT INTO guc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nnojoishi tayain kee'ireein aa'in kojutuu sütüma wayuu. Nia chi Tashikai Maleiwa kee'ireeka aa'in kojutüinjachin taya atümaa, süka niain kaneekajalain taya süpüla. ");
INSERT INTO guc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Shiimainkalaka ma'i tü tamakat jümüin joolu'u: Chi wayuu eekai noonooin sümaa tanüiki, nnojoleechi e'rüin ouktaa —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nasouktakalaka na laülaayuu judíokana nümüin: —Pi'ra müsüje'e, shia wamakaja'a pümüin sünain shiimüin kale'eru'uin pia yolujaa. Abraham, ouktüshi oo'ulaka napüshua na nünüikimaajanakana Maleiwa. ¿Jamakuaippalaja'a joo pünüiki “Chi wayuu eekai noonooin sümaa tanüiki, nnojoleechi e'rüin ouktaa” pümakalaka wamüin? ");
INSERT INTO guc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham, ouktüshi oo'ulaka napüshua na nünüikimaajanakana Maleiwa. ¿Piataale ma'i alana'aleein sünain miyo'uwaa noulia? ¿Jaraikai pia saa'in pümüin? —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nüsouktakalaka Jesús namüin: —Müleka “wayuu anamia taya” tamüle ne'e, matüjaaja'a aa'ulu müleka shiimüinre je müleka alawaalein. Nia a'waajaka taya chi Tashikai, chi Jümaleiwasekai jaajüin, ");
INSERT INTO guc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","chi ju'waataakai alu'u sümaa nnojolin ji'raajüin nia. Alu'usa tayakai, te'raajüin. Müleka “nnojoishi te'raajüin” tamüle, meechi aka taya jiakana aküjakana alawaa. Shiimüin sünain te'raajüin nia je toonooin waneepia sümaa nünüiki. ");
INSERT INTO guc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Otta müshia chi jutuushikai Abraham, talatüshinka ma'i süka nütüjaain saa'u sünain tantajachin so'uweena wane ka'i. Talatüsü ma'i naa'in süka nütüjaain saa'u tü kasa anasü taa'inrajatkat tantapa sa'akamüin wayuu —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Namakalaka na laülaayuu judíokana nümüin Jesús: —¿Jamakuaippai süpüla pi'rüinjachin Abraham mataashikai kakaliaichikai nia ouktüin? Otta piakai, eeyaa ne'e püsa'wajüirüin ja'ralin shikii juya puuyase. ");
INSERT INTO guc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nüsouktakalaka Jesús namüin: —Shiimüin tü tamakat jümüin: Eetüjü'iya taya nnojoliwa'aya jemelin Abraham —nümakalaka namüin süka nütüjaain saa'u sünain niain Maleiwain. ");
INSERT INTO guc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nayasa nayakana, naapaakalaka ipa süpüla na'ina'alüinjachin nia saalii tü nümakat namüin sünain niain Maleiwain naajüin. Otta Jesús, nujuittaakalaka najuuna sulu'ujee tü a'waajüleekat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Süchikijee nujuittüin Jesús sulu'ujee tü a'waajüleekat Maleiwa, awaralijaashi nia namaa na nikirajüinkana. Ni'rakalaka wane wayuu mo'usai, jemeishitüjü'iya sümaa mo'uin. ");
INSERT INTO guc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nasakirakalaka na nikirajüinkana: —Ekirajüikalee, ¿jamüshi jemeika'a nia sümaa mo'uin? ¿Saaliijeejachi naainjala, nayataapa kaainjalo'uin na kachoinkana? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nüsouktakalaka Jesús namüin: —Nnojoishi saaliijeejachin naainjala je saaliijeejachin naainjala na kachoinkana. Shia ne'e süpüla shi'rüinjatüin wayuu wainma tü kasa anasü naa'inreekat Maleiwa nüka. ");
INSERT INTO guc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Je süma'inru'u katüin wo'u, anakaja müleka wa'yataale nümüin chi Maleiwakai kajünalakai taya. Ouktapa waya, ¿jamataaleena süpüla wa'yataainjanain nümüin? ");
INSERT INTO guc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sükajee tüü, süma'inru'u yaain taya sa'aka wayuu, müshi aka taya saa'in wane anakia, süka shiyaawatüinjatüin tatüma wayuu saa'u tü shiimüinkat —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kettaapa nünüiki Jesús namüin na nikirajüinkana, nejetakalaka mmolu'u süpüla naainjain wane pootshi. Nushulerakalaka shia saa'u no'u chi mo'usaikai sümaa nümüin nümüin: ");
INSERT INTO guc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Pu'una eemüin tü anua o'oojüleekat Siloékat sünülia pu'lojooiwa tü po'ukot chamüin —müshi nümüin. Je chi mo'usaikai, nu'unakalaka chamüin cha'aya süpüla nu'lojooinjatüin tü no'ukot. Nüle'ejakalaka nipialu'umüin sümaa ko'uin nia. (Otta tü pütchi “Siloé” makat, “Ajütüüshi” malu'ut.) ");
INSERT INTO guc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Je shiasa sümakalaka tü wayuukolüirua eekai kepiain nü'ütpünaa je eekai shi'rapü'üin nia sünain ajulijaa: —Atak, ¿nnojoishi niain chi mo'usai joyotopü'ükai sünain ajulijaa sulu'u wopu chira? ");
INSERT INTO guc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Aanee, nia'aya chira —mataalasü waneeirua. Otta waneeirua: —Nnojoittaashi niain, mataashi aka naa'in ne'e —müshii. Otta chi mo'upü'ükai: —Tayaichija'aya chi ajulijapü'ükai, chi ji'rapü'ükai paalainka —müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nasakirakalaka nia na wayuukana: —¿Jamüsü pukuaippa süpüla ko'uinjachin pia? ");
INSERT INTO guc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nüsouktakalaka namüin: —Chi wayuu Jesúskai anülia, naainjüin wane pootshi je nushuletkalaka shia saa'u tü to'ukot. Nüjütakalaka taya eemüin tü anua kanüliakat Siloé süpüla to'lojüinjatüin tü to'ukot cha'aya. O'una müshia taya sütüma nünüiki. Je süchikijee to'lojüin to'u, e'ralaa müshi taya —nümakalaka namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nasakirakalaka nia: —¿Jalaka'a joo chi wayuukai? —¿Müinja? Nnojoishi tatüjaain aa'u —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nümaanakalaka chi mo'upü'ükai natüma na wayuukana nanainmüin na fariseokana eejanale naya jutkatüin sulu'u tü ekirajüleekat na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Süka sükalio'ujatüin eemerawaa naainjüin Jesús tü pootshi anainjachikat atüma chi mo'usaikai, ");
INSERT INTO guc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","nüsakiijünakalaka chi wayuukai natüma na fariseokana sünain jamakuaippalin nia ko'uka'a. Nüsouktakalaka chi wayuukai namüin: —Nushulejaain wane pootshi saa'u tü to'ukot je nüjütüin taya süpüla to'lojooinjachin tü to'ukot. Ko'u müshia taya süchikijee tia —nümataalakalaka namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Namakalaka joo waneeirua fariseo: —Watüjaaichipa aa'u chia wayuukai sünain nnojolin nüma'anajeejachin Maleiwa, süka nnojolüin noonooin sümaa tü nuluwataakat anain Moisés süpüla nnojoliin wa'yataain sükalio'u eemerawaa. A'yataashi nia su'unnaa tia sünain niiyajüin chi wayuukai —müshii naya. Je nanüiki waneeirua na fariseokana: —Nnojotsü nuuntüin naa'inrüin wane kaainjarai tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa —müshii naya. Süka nnojolüin paa'inwajiraain naya, ");
INSERT INTO guc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","nasakirakalaka chi mo'upü'ükai nüchikua'aya: —Piakai ko'ushikai nütüma, ¿jarai naa'in pümüin? —namakalaka nümüin. Nüsouktakalaka chi wayuukai namüin: —Wane nünüikimaajachi Maleiwa naa'in tamüin —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nnojotkalaka nanoujain na laülaayuu judíokana sünain mo'upü'üin chi wayuukai. Neenajitkalaka na kachoinshiikana nia süpüla nasakinnüinjanain nünain. ");
INSERT INTO guc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Jüchon chii? ¿Jemeishijasa'aya sümaa mo'uin? ¿Jamataalaka'a joo nia ko'uka'a joolu'u? —müshii namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Aa, wacho'onya, shiimüin sünain jemeishin nia sümaa mo'uin. ");
INSERT INTO guc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Shia nnojotka watüjaain aa'u jamakuaippalin ko'uka'a nia joolu'u otta jaralin anain atüma. Naaja nünüiki, niale jüsakirüin. Nüküjeerü süchiki jümüin, jo'uule joo nia —namakalaka namüin na fariseokana. ");
INSERT INTO guc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Müsü nanüiki sütüma mmolüin naya seema tü namakat paala na laülaayuu judíokana, tü makat: “Chi eekai kapülain naa'in nünüiki Jesús sünain niain Cristoin chi Nüneekajalakai Maleiwa, müichia mekerolüin nüchikua sulu'umüin tü ekirajüleekat”. ");
INSERT INTO guc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Je “nüküjeerü süchiki jümüin, jo'uule joo nia”, namaka'a na kachoinshiikana chi mo'upü'ükai, sükajana mmolüin neema na laülaayuukana. ");
INSERT INTO guc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Je na fariseokana, neenajakalaka nüchikua chi mo'upü'ükai sünain namüin nümüin: —Watüjaa aa'uchi chi eiyajakai pia sünain wayuuin kaainjarai nia. Anakaja püküjüle wamüin joolu'u tü shiimüinkat noo'opünaa nu'upala Maleiwa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nümakalaka namüin: —Nnojoishi tatüjaain aa'u müleka kaainjaraire nia. Shia'ala ne'e tatüjaaka aa'u, mo'upü'üin taya tamaiwa, otta müsia joolu'u, ko'uichipa taya —nümataalakalaka. ");
INSERT INTO guc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nasakirakalaka nia nüchikua: —¿Jamüsü pukuaippa nütüma? ¿Kasa niiyajaka aka tü po'ukot? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Taküjüitpa'asa jümüin, otta nnojotsü kachipünaain jaa'in tanüiki. ¿Jamataalaka'a joo jaapajeeka'a shia süchikua? ¿Ekirajüneeshii jia nütüma? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na'ülüjakalaka na fariseokana nümüin chi wayuukai sünain mojulu'ulüin nanüiki nümüin: —Piayaainje ne'e shikirajüin wayuwa'atakat tia. Eitüshi'ireein joo waya nikirajanain Moisés. ");
INSERT INTO guc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Watüjaa aa'ut sünain niain Moisés naashajaapü'üin amaa Maleiwa. Akaajasa chia, ¿jara atüjaaka saa'u jalaje'ewalin? —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nümakalaka chi mo'upü'ükai namüin na laülaayuu judíokana: —Atak, nia anaka atüma taya su'upala wayuu süpüshua. ¿Jamüsü nnojotka'a jütüjaain aa'u jalaje'ewalin wayuu eekai müin aka chia? ");
INSERT INTO guc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jütüjaa aa'uchi chi Maleiwakai sünain nnojolüin kapülain naa'in sünüiki wayuu eekai kaainjaralüin, alu'ujasa chi eekai keisalain sümüin nukuaippa nu'upala sünain noonooin sümaa nünüiki. ");
INSERT INTO guc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nnojotsü waapüirüin achiki wane wayuu eekai sütüjüin süpüleerua ko'uin wayuu sütüma, eekai jemein sümaa mo'uin maa aka takuaippa. ");
INSERT INTO guc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Müleka nnojoireje aluwataaushin nütüma Maleiwa, nnojotsüje nuuntüin naa'inrüin kasa eekai müin aka tüü —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Namakalaka nayakana nümüin: —Pia jemeikai sümaa kaainjalain, e'rüiyaakai aa'in wayumüin, ekirajeekai waya, pu'una yaajee —namakalaka nümüin sünain najünajaain sulu'ujee tü ekirajüleekat. ");
INSERT INTO guc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Otta müshia Jesús naapapa nüchiki chi mo'upü'ükai sümaa nüjünajaanüin sulu'ujee tü ekirajüleekat na judíokana, nüchajaakalaka nüchiki. Shiasa nüntapa nünain, nüsakirakalaka nia: —¿Anoujashi pia nünain chi Shipayakai Wayuu? —müshi nümüin. ");
INSERT INTO guc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Ekirajüikalee, ¿jarai nian? Püküja tamüin nüchiki tanoujaiwa nünain —nümakalaka chi mo'upü'ükai nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Nia chi pi'rakai joolu'u, chi yootokai pümaa —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Senyotkalee, anoujashi taya pünain joolu'u —nümakalaka sünain nu'waajüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nümakalaka Jesús nümüin: —Antüshi taya yaa mmolu'umüin sa'akamüin wayuu süpüla tee'iyatüinjatüin sümüin sünain kaainjaralüin süpüshua. Chi eekai kapülain naa'in tanüiki, niyaawateerü aa'u tü shiimüinkat, maa aka joo piakai ko'uichipain. Otta chi eekai niyouktüin tanüiki, maa aka naa'in nala fariseokana, müichia mayaawatüin saa'u tü shiimüinkat. Meena aka mo'ukai —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eejanakalaka waneeirua fariseo yaa peje sünain eejachire yootüin. Naapajakalaka tü nümakat. Namataalakalaka nümüin Jesús: —¿Mo'usaliijasa'a joo waya paa'inru'u? ");
INSERT INTO guc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nüsouktakalaka Jesús namüin: —Sükajee jiyouktüin tanüiki sünain ju'waataain sulu'u jütüjaain saa'u jaashin tü shiimüinkat, kasalajaneerü jümüin jaainjala. Otta chi wayuu eekai kapülain naa'in tü tekirajakat anain, maa aka chi mo'upü'ükai, nnojoleerü kasalajanain nümüin naainjala —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ayatshia aashajaain Jesús namüin na laülaayuu judíokana sünain nümüin namüin: “Shiimüin tü tamakat jümüin: Chi wayuu oototkai shiinalu'upünaa sükulaatse anneerü, nnojoikai ekerolüin so'ulu'upünaa, ka'ruwarai. ");
INSERT INTO guc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Alu'ujasa'aya chi eekai nikerolüin so'ulu'upünaa, nia'aya chi shiimainkai anneetpü'üin. ");
INSERT INTO guc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ajutannüsü so'u tü kulaatkat nüpüleerua. Je tü na'anneetsekat, shi'raajüin nünüiki neenajapa süka sünülia süpüla nike'erüin nüpüleerua. ");
INSERT INTO guc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Je nike'etpa shia, o'unüsü süpüshua nümaa eepünaale shia nütüma süka shi'raajüin nünüiki. ");
INSERT INTO guc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Alu'ujasa sümüin wayuu eekai naatajatüin, nnojoleerü o'unüin sümaa süka nnojolüin shi'raajüin sünüiki, a'walakajaweerü süpüleerua”, nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aashajaashi joo Jesús süka sukuaippa tü kasa e'nnaajünakat sainküin mma süpüla nii'iyatüinjatüin namüin na laülaayuu judíokana sünain nnojoliin naya müin aka naa'in niakai sünain ekirajaa tü shiimüinkat sümüin wayuu. Otta nnojotkalaka nayaawatüin saa'u jamalu'ulüin tü nüchikikat chi anneetpü'ükai nüküjaitpakat namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nümakalaka Jesús namüin nüchikua süka nnojolüin nayaawatüin saa'u na laülaayuu judíokana tü nikirajeekat anain: “Shiimain tü tamakat jümüin: Tayakai, müshi aka saa'in wane so'u sükulaatse anneerü. ");
INSERT INTO guc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tü wayuu antakalüirua tapülapünaa, na aküjakana alawaa, müshii aka saa'in ka'ruwaralii napüshua. Je tü anneetkalüirua, nnojotsü shiyaawatüin aa'u nanüiki. ");
INSERT INTO guc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Tayakai, müshi aka saa'in so'u sükulaatse anneerü süka shikerolüin wayuu tanainjee nüma'anamüin Maleiwa. Je chi eekai nünoujain tanain, aapüneerü nümüin nütüma Maleiwa süpüshua tü che'ojaakat nümüin. ");
INSERT INTO guc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Chi ka'ruwaraikai, antüshi ne'e süpüla a'luwajaa anneerü je o'una'alaa saa'in tü mürütkalüirua. Akaajasa tayakai, antüshi taya süpüla shii'iranajaainjatüin saa'in wayuu tatüma süpüla eeinjatüin waneepia nümaa Maleiwa”, nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aashajaashi Jesús nüchikua namüin: “Tayakai, müshi aka naa'in wane anneetpü'ü eekai anamiain ma'i, chi nnojoikai mmolüin seema ouktaa saa'ujee aa'inmajaa na'anneetse. ");
INSERT INTO guc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Akaajasa chi aa'inmajiruushikai ne'e saa'u neerü, nnojoishi müin aka naa'in chi ka'anneetseshikai. Müleka süntüle wane unaalü sünainmüin, nüpünaajeerü tü anneetkalüirua. A'walakajaa meeria sainküin mmakat, shika sümeeria tü unaatkat. ");
INSERT INTO guc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nüpütapünaain tü anneetkalüirua süka maalin shia nüpüla saa'u nnojolüin nümü'ünüin, a'yataashin ne'e nia saa'u neerü. ");
INSERT INTO guc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Saa'u müin aka taya naa'in wane anneetpü'ü eekai anamiain ma'i, te'raajüin tü ta'anneetsekalüirua je ne'raajüin taya, ");
INSERT INTO guc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","maa aka ni'raajüin taya chi Tashikai je te'raajüin nia'aya. Je yapashi taya süpüla aapajirawaa tekii süpüla ouktaa saa'u tü ta'anneetsekalüirua. ");
INSERT INTO guc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eeshi'iya wane anneerüiruaya'a waneejannuu. Tantireena naya'aya tanainmüin süpüla noonooinjanain sümaa tanüiki. Kotteeshii tatüma na ta'anneetsekana napüshua süpüla naa'inmajünüinjanain tatüma tamüiwa, tayakai chi napü'üyakai. ");
INSERT INTO guc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Aishi ma'i taya nüpüla chi Tashikai saa'u taapajiraainjachin tekii süpüla ouktaa saa'u tü ta'anneetsekalüirua. Je oso'iraweerü taa'in süchikijee ouktaa. ");
INSERT INTO guc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taapajiraain tekii süka taa'in tamüiwa süpüla ouktaa, nnojotsü sükajeejachin o'utünaa aa'in sütüma wayuu. Laülaa taya tamüiwa süpüla aapajirawaa tekii oo'ulaka süpüla oso'irawaa aa'in, süka shiain aluwataana anain taya nütüma chi Tashikai”, nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Otta müshi'iya na laülaayuu judíokana sütüma tü nümakat Jesús, a'ülüjaajiraashii naya nachikua. ");
INSERT INTO guc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Mamainnashi nia sütüma kale'eru'uwaa yolujaa. Nnojotsü anain süpüla waapajüin nünüiki —müshii wainma na laülaayuukana. ");
INSERT INTO guc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Otta sünüiki waneeirua: —Wane wayuu eekai kale'eru'uin yolujaa, nnojotsü aashajaain pütchi eekai müin aka tüü. Je wane yoluja'aya, nnojotsü anain wane wayuu eekai mo'uin sütüma —müshii naya. ");
INSERT INTO guc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wanaa sümaa alin jemiai chaa Jerusalén, o'ttüsü wane mi'iraa natüma na judíokana cha'aya süpüla sotüinjatüin naa'in wanaa sümaa süikkale'ennüin süchikua paala tü a'waajüleekat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Warai müshi Jesús sulu'u tü a'waajüleekat Maleiwa suupünaapünaa tü luma e'itaanakat anain nünülia Salomón. ");
INSERT INTO guc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Narütkaakalaka wane laülaayuu judíoirua nünainmüin süpüla noo'ulaküin naa'in. Nasakirataalakalaka nia: —¿Jamüshi pia kama'aka'a ma'i süpüla aküjaa wamüin sünain jaralin pia? Müleka shiimüinre sünain piain Cristoin chi Nüneekajalakai Maleiwa, püküjaa wamüin süka pütchi eekai ja'yashin —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nüsouktakalaka Jesús namüin: —Taküjüitpa'asa jümüin sünain tayain Cristoin, otta jiakana, nnojotsü kapülain jaa'in tanüiki. Tü kasa anasü taa'inrakat, tü aluwataanakat anain taya nütüma chi Tashikai, tü nütüjakat apüleerua nümüiwa, shii'iyatüin jümüin takuaippa. ");
INSERT INTO guc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Masütaajuka'a jia sünain manoujain tanain, shia süka nnojoliin ta'anneetsein jia. ");
INSERT INTO guc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Otta na ta'anneetsekana, te'raajüin naya je o'unüshii tamaa süka ne'raajüin tanüiki. ");
INSERT INTO guc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ee'iranajaaitpa naa'in tatüma süpüla eeinjanain naya nümaa Maleiwa waneepia. Müina nnojoliin amüloulin naya. Je nnojotsü jaralüinjatüin asütüin naya tajapulu'ujee. ");
INSERT INTO guc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Saa'u naapajalain naya tamüin chi Tashikai, chi alana'aleekai sünain pülashin suulia kasakat süpüshua, nnojoruleeja'a nasütünajanain najapulu'ujee. ");
INSERT INTO guc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tü takuaippakat, a'aniraasü nümaa chi Tashikai, akaajaa tü nukuaippakat tamaa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na laülaayuu judíokana, naapaakalaka ipa nachikua süpüla na'ina'alüinjachin nia. ");
INSERT INTO guc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nümakalaka joo Jesús namüin: —Tountüin taa'inrüin nütüma chi Tashikai kasa wainma eekai anashaatain ma'i ju'upala, tü nütüjakat apüleerua niakai nümüiwa. ¿Jaratka'a ju'uteein anainjee taa'in süka ipa? —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nasouktakalaka nümüin: —Nnojoishi wa'iteein pia süka ipa saaliijee paa'inrüin kasa eekai anain, saaliijeejatü e'rülin wayumüin pia sümaa pünüiki “Taya'aya Maleiwa” pümüin sümaa wayuuin ne'e pia —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Nüsouktakalaka Jesús namüin: —Pansaasü tü karaloukta nüchikimaajatkat Maleiwa. Soto jaa'in tü nümakat chi Maleiwakai ashajünakat sulu'u nütüma Moisés sünain “maleiwa jia” nümüin. Saa'u “maleiwa” namünüin na wayuu kamüinjanakana tü pütchikat, ");
INSERT INTO guc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿jamaka'a joo mojushiika'a jümüin “Nüchon taya Maleiwa” tamüin jümüin? Nnojotsü te'ralain wayumüin tia nümüin Maleiwa. Tayakai, akatannüshi nütüma Maleiwa süpüla nüjütüinjachin taya sa'akamüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Müleka nnojorule taa'inrüin tü naa'inrakat chi Tashikai, anasüja'a sulu'u nnojorule kapülain jaa'in tanüiki. ");
INSERT INTO guc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Akaajasa taa'inrüle shia, ja'itaichi jiyouktüin taya, anakaja müleka kapürale jaa'in tü taa'inrakat ju'upala süpüla jiyaawatüinjatüin saa'u sünain sa'aniraain nukuaippa chi Tashikai tamaa je sa'aniraain takuaippa nüma'aya —nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nata'üleekalaka nachikua Jesús, akaisa isain nia noulia. ");
INSERT INTO guc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ale'ejaa müshia Jesús chamüin waneemüin sa'ata tü süchikat Jordán eejechire paala Juan sünain owoutisaajaa wayuu. Je saa'u makatüin Jesús cha'aya, ");
INSERT INTO guc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","antapaayaa müsü wayuu wainma nünainmüin sünain sümajiraain nüchiki mayaa: —Mayaainje nnojolüin naa'inrüin Juan wane kasa anasü nütüjakat apüleerua Maleiwa nümüiwa, shiimainshaana tü nümapü'ükat noo'opünaa Jesús —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Je cha'aya, anoujasü wainma wayuu nünain Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Eejachi wane wayuu kanüliashi Lázaro, kepiashi cha'aya Betania sulu'u tü mmakat Judea sümaa nushunuumuyuu kanüliasü María oo'ulaka Marta. Ayuuikalaka nia. ");
INSERT INTO guc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Shia tü María o'yotokat “perfume” saa'u nuu'ui chi Senyotkai je süla'ajain shia süka su'wala.) ");
INSERT INTO guc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na nüshunuukana Lázaro, najütakalaka wane wayuu nünainmüin Jesús eejachire nia wane sa'ata tü süchikat Jordán süpüla naapirüinjachin nia nüchiki Lázaro: —Senyotkalee, ayuuishi chi aishikai püpüla —nümünakalaka. ");
INSERT INTO guc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Je naapapa Jesús nüchiki Lázaro, nümakalaka: —Ayuuliikat tia, nnojotsüyaaje'e ouktajachin sütüma. Süpülajatü ne'e sütüjaainjachin wayuu naa'u chi Maleiwakai sünain pülashin ma'i je süpüla sütüjaainjachin naa'u chi Nüchonkai Maleiwa sünain pülashin ma'i nia'aya —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Wanaa sümaa naapinnüin nüchiki Lázaro sünain ayuulin nia, makatüshi Jesús maa aka piama ka'i cha'aya wane sa'ata tü süchikat Jordán, mayaainje alin ma'i nüpüla Marta je tü shimiiruakat je müshija'a Lázaro. ");
INSERT INTO guc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Shiasa süchikijee piama ka'i, nümakalaka Jesús namüin na nikirajüinkana: —Anakaja wale'ejüle wachikua'aya joolu'u Judeamüin. ");
INSERT INTO guc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Namakalaka na nikirajüinkana nümüin: —Ekirajüikalee, mataashi pu'utüneekai aa'in süka ipa natüma na laülaayuu judíokana cha'aya Jerusalén. ¿Jamüinjachi püle'ejeeka'a joolu'u chamüin? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Süpüla nii'iyatüinjatüin Jesús namüin sünain nnojolüin keraain nükalia süpüla ouktaa, nümakalaka namüin: —Müleka waraittüle wane wayuu so'uka'i, nnojoleechi ashanaain, süka ja'yain tü wopukot sütüma nuwarala chi ka'ikai. ");
INSERT INTO guc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Otta müleka waraittüle nia sa'wai, eeshi süpüla nüshanaain süka nnojolüin ja'yain tü wopukot sütüma tü piyuushikat —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ayatshi Jesús sünain naashajaain namaa: —Chi watünajutkai Lázaro, atunküshi nia. Chainjachika'a joo taya sünain achijiraa nia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Namakalaka na nikirajüinkana nümüin: —Senyotkalee, müleka nutunküle, analeerü naa'in. ");
INSERT INTO guc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tü nümakat Jesús, shia nüchiki Lázaro sünain ouktüin nia. Otta saa'in namüin na nikirajüinkana, atunkayaaja'a ne'e naa'inru'u. ");
INSERT INTO guc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lotokalaka joo nünüiki Jesús namüin: —Ouktüichipa Lázaro, ");
INSERT INTO guc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","je anasü saa'in tamüin sünain nnojolin chajachin taya wanaa sümaa ouktüin nia, süka katsüinjeerüin joolu'u tü jünoulakat sütüma tü kasa anasü ji'reetkat cha'aya. Joo'uya jümaala chamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nüsouktakalaka wane chi nikirajüinkai kanüliakai Tomás, chi Senkeyuu münakai: —Joo'uya wapüshua ouktaiwa waya wanaa nümaa chi ekirajüikai waya —nümakalaka namüin na nüpüshikana. ");
INSERT INTO guc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nu'unakalaka Jesús namaa na nikirajüinkana chamüin Judeamüin. Je nüntapa Betaniamüin, naapa achikit sünain sülatüirüin pienchi ka'i süchikijee ni'itaanüin chi ouktüshikai. ");
INSERT INTO guc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Saa'u pejein Betania sünain Jerusalén, maa aka apünüin “kilómetro” eera, ");
INSERT INTO guc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","antapaatasü wainma wayuu chajee shipialu'umüin Marta je María sünain alapalawaa naya. ");
INSERT INTO guc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Saapaiwa'aya Marta nüchiki Jesús sünain antaa, süpanapajakalaka nia. Shiaka María, makatüin miichipa'a. ");
INSERT INTO guc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sümakalaka Marta nümüin Jesús: —Senyotkalee, müleka yaajachireje pia, nnojoishije ouktüin chi tawalakai. ");
INSERT INTO guc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Otta müsia joolu'u, mayaainje ouktüichipain nia, tatüjaa aa'ulu sümaa naa'inreerüin Maleiwa süpüshua tü puchuntakat nümüin —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Oso'iraweechi aa'in chi puwalakai —nümakalaka Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Aa, tatüjaa aa'uchi sümaa nüso'iraweechin aa'in sümaa wayuu süpüshua so'uweena tü ka'i saja'lajaainjatkat o'u kasa süpüshua —sümakalaka Marta nümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nümakalaka Jesús sümüin: —Tayakai, taya atüjaka oso'ire'eraa saa'in wayuu süpüla eeinjatüin nümaa Maleiwa waneepia. Chi eekai nünoujain tanain, ja'itaichi ouktüin maa aka wayuu süpüshua, cheechi nia nümaa Maleiwa süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ee'iranajaweerü naa'in sütüma nünoujain tanain, je nnojoleechi amüloulin. ¿Kapülasü paa'in tü tamakat pümüin? —nümakalaka Jesús sümüin Marta. ");
INSERT INTO guc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Aa, tanoujain sünain piain Cristoin chi Nüneekajalakai Maleiwa, chi Nüchonkai Maleiwa antajachikai yaa mmolu'u sa'akamüin wayuu —sümakalaka Marta nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kettaapa sünüiki Marta, ale'ejüsü shia süchikua eemüin María tü shimiiruakat sünain sümüin sümüin sujuuna wayuu: “Isaa antüin chi Ekirajüikai, nüsaajirüin pia”, sümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Saapapa María tü pütchikat, asha'walaasü yaawalaja'a sünain o'unaa eemüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Otta Jesús wanaa sümaa tia, sajachi eejechire paala nia yootüin sümaa Marta. Mekerolüinsai sulu'umüin tü pueulokat. ");
INSERT INTO guc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Je nayasa na wayuu alapalaashiikana shipialu'umüin María, ne'rapa shia sünain o'unaa yaawalaja'a, noushikajaakalaka süchiirua. Chainjatia naa'inru'u sünain a'yalajaa amouyuupa'amüin eere ni'itaanüin chi ouktüshikai. ");
INSERT INTO guc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayaasü antüin María nünainmüin Jesús, o'ttüsü süka süsapain nümülatu'umüin süka kojutüin nia sütüma. —Senyotkalee, müinka yaajachireje pia, nnojoishije ouktüin chi tawalakai —sümakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Je ni'rapa Jesús María sünain a'yalajaa oo'ulaka na wayuukana sümaajanakana, mojukalaka ma'i naa'in sütüma. ");
INSERT INTO guc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Jalashi nia e'itaanüin? —nümakalaka namüin. —Joo'uya Senyotkalee, pi'raiwa —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ni'yalajakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Shiasa'a nanüiki wane wayuukana: —Aireekaija'a ma'i nia nüpüla —müshii. ");
INSERT INTO guc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Otta sünüiki waneeirua: —¿Jamüshi nnojoika'a niiyajüin paala chi wayuukai suulia ouktaa, maa aka niiyajüin paala chi mo'usaikai? —sümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Je nüntapa Jesús amouyuupa'amüin, mojukalaka ma'i naa'in nüchikua. Je tü eejachire ni'itaanüin chi ouktüshikai, wane ipa müsü aka saa'in sulu'upünaa paü ke'ipolosü wane ipa miyo'u. ");
INSERT INTO guc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Jüsünne'era türa shirousekat —nümakalaka Jesús namüin. —Senyotkalee, keejuuichin, pienchit ka'i süchiiruajee ni'itaanüin —sümakalaka Marta tü nüshunuukat chi ouktüshikai. ");
INSERT INTO guc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nümakalaka Jesús sümüin: —Soto paa'in tü tamakat pümüin. Müinka pünoujüle tanain, pütüjaweechi aa'u chi Maleiwakai sünain pülashaatain ma'i nia. ");
INSERT INTO guc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Süsünne'ennakalaka joolu'u tü shi'ipolokat. Eirakaa müshia Jesús iipünaamüin sümaa maa: —Taataa, taapüin pümüin analu'ut maa'ulu yaa süka paapüin tanüiki. ");
INSERT INTO guc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tatüjaa aa'uchi pia sünain paapüin tanüiki meinshi. Tamüsü ne'e tü pütchikat pümüin nayaalu'u na wayuu yaakana süpüla nanoujainjanain sünain püjünalain taya —nümakalaka Jesús nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Shiasa kettaapa nünüiki Jesús, neenajaka'a chi ouktüshikai: —Lázaro, pujuittaa yalajee yaa anooipa'amüin —nümakalaka sünain emetuluin nünüiki. ");
INSERT INTO guc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nujuittaakalaka chi ouktüshikai paala sünain ko'oin süka kuluulu najapü, nuu'ui oo'ulaka nu'upünaa. —Juwasta nuulia türa ko'oyookat akan. Juu'ulaapa nu'unaiwa nümüiwa —nümakalaka Jesús namüin na wayuukana. ");
INSERT INTO guc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wainma na wayuu antakana shipialu'umüin María, anoujashii nünain Jesús sütüma tü naa'inrakat. ");
INSERT INTO guc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Otta waneeirua, o'unüsü nanainmüin na fariseokana sünain aküjaa namüin süchiki tü naa'inrakat Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Je na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na fariseokana, nakotchajiraakalaka napüshua na laülaayuu judíokana. Namakalaka namüin: —¿Kasa waa'inrüinjatka nüka chia wayuukai? Naa'inrüin wainma kasa anasü nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Müleka woo'ulaale nia, anoujeerü wayuu wainma nünain. Anta meenia na sülaülakana mma Romaje'ewaliikana, süpüla najuttirüin tü a'waajüleekat Maleiwa sümaa no'una'alüinjatüin waa'in —namakalaka namüin na laülaayuukana napüshua. ");
INSERT INTO guc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nüsouktakalaka joo wane na'akajee, Caifás nünülia, chi laülaashikai napüleerua na sacerdote judíokana so'u juyakat tia. Nümakalaka namüin: —Matüjüinsalii jia jüpüshua. ");
INSERT INTO guc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nnojotsü anain müleka wo'una'annüle aa'in wapüshua natüma na wayuu Romaje'ewaliikana. Shia anaka alu'u, saa'in tamüin, ouktüle waneeshia ne'e wayuu waa'u wayakana judíokana wapüshua —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tü nümakat Caifás, shia noo'opünaa Jesús sünain ouktüinjachin saa'ujee tü judíokolüirua süpüshua. (Tü nümakat, nnojotsü niyaawatüin aa'u jamalu'ulüin. Nnojotsü nüle'eru'ujeejatüin ne'e tü pütchikat. Nuuntüin nüküjüin shia nütüma Maleiwa süka laülaashin nia napüleerua na sacerdote judíokana so'u juyakat tia.) ");
INSERT INTO guc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nnojoishi ouktajachin ne'e Jesús naa'ujee na judíokana namüiwa, ouktajachi saa'ujee süpüshua tü nüpüshikalüirua Maleiwa eekat sainküin mmakat, süpüla kottüinjanain naya sünain wanaawain naa'in. ");
INSERT INTO guc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Otta na laülaayuu judíokana so'ule'eya ka'ikat tia, o'ttüshii sünain naashajaajiraain süchiki kasainjatüin naa'inrüin süpüla no'utirüinjachin naa'in Jesús. ");
INSERT INTO guc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Je sükajee tia, nnojolichipa waraittüin ma'i Jesús na'aka na wayuukana sulu'u tü mmakat Judea. Nu'unakalaka namaa na nikirajüinkana yalajee Judeajee sulu'umüin wane pueulo kanüliakat Efraín chaa sü'ütpa'a wane isashii süpüla chainjanain naya cha'aya. ");
INSERT INTO guc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Je sülü'ülapa sükalia tü mi'iraakat natüma na judíokana, tü kanüliakat Pascua, o'unüsü wayuu wainma sulu'ujee tü mmakat süpüshua chamüin cha'aya Jerusalénmüin. O'unüshii naya süpülapünaa su'ttüin tü mi'iraakat süpüla naa'inrüinjatüin tü kasa wuleinjatkat akajee nakuaippa nu'upala Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Je tü wayuu antakalüirua sünainmüin tü mi'iraakat, süchajaa achikichi Jesús. Wanaa sümaa sükotchijaain sulu'u tü a'waajüleekat Maleiwa, naashajaajiraakalaka sünain maa: —¿Anteechi cheje nia sünain tü mi'iraakat naa'in jümüin? ¿Nnojoittaajeechi antüin? ");
INSERT INTO guc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Müsü sünüiki tü wayuukolüirua süka saapinnüin paala natüma na laülaayuushiikana na'akajee na sacerdote judíokana oo'ulaka na fariseokana süka tü pütchi makat: “Müleka sütüjaale wane wayuu naa'u Jesús sünain jalain nia, anasü müleka saapirüle waya süpüla wata'ülüin nia”. ");
INSERT INTO guc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Je aippirua ka'i süpülapünaa tü mi'iraa kanüliakat Pascua, nüle'ejakalaka Jesús Betaniamüin eere kepiain Lázaro chi nüso'ire'erakai aa'in paala. ");
INSERT INTO guc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eesü wane ekawaa nüpüla nütüma Lázaro oo'ulaka na nuwalayuukana süpüla nee'iyatüin sümüin wayuu sünain kojutüin ma'i nia natüma. Shiitajakalaka Marta tü eküütkat. Otta müshia Lázaro, yaashi nia eküin sa'aka tü eejatkalüirua sünain tü ekawaakat nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Shiasa María, shi'yotokalaka wane shiatapünaa maraaja “perfume” kojutüsü ma'i kanüliasü “nardo” saa'u nuu'ui Jesús süpüla shii'iyatüin nujut nümüin sümaa süla'ajaain shia süka su'wala. Jemetuuikalaka ma'i tü paükat sütüma eejanale naya. ");
INSERT INTO guc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sa'aka tü ekaasükalüirua, eejachi chi nikirajüinkai, chi Judas Iscariotekai anülia, chi aapüinjachikai nikii Jesús sümüin wayuu. Saa'u nnojolüin anain nümüin Judas tü saa'inrakat María, ");
INSERT INTO guc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","nümakalaka nümüin Jesús: —Kojutpaja'a ma'i tü “perfumekat”. ¿Jamüsü nnojotka'a suikkünüin süpüla sükaaliijiain wayuu eekai müliain tü süliakat? Tü süliakat, müsü aka shi'yataainjut wane wayuu so'u wane juya —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Je tüü, nümaka'a Judas, nnojotsü sükajeejatüin alin wayuu nüpüla eekai müliain, nümüsü süka ka'ruwaralin nia. Nu'luwatapü'ü apüshirü tü neerü nalü'üjapü'ükat na nikirajüinkana Jesús, saa'u niain anaajaalin shia. ");
INSERT INTO guc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nüsouktakalaka Jesús nümüin Judas: —Kettsian, ko'uta ne'e pia. Je nümakalaka Jesús namüin na wayuukana napüshua: —Anasü tü saa'inrakat María tamüin, süka sünaajaalatüjülü'inya tü “perfumekat” süpüla sushulerüinjatüin tanain so'u tü ka'i tojoitünajachikat o'u. ");
INSERT INTO guc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Je na wayuu müliakana, eejeena jümaa waneepia süpüla jüsülajüinjanain namüin. Otta tayakai, süpülajachire joo yaawaa jümaa —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Je naapünapa achiki Jesús sünain nüle'ejüin Betaniamüin, antapaayaa müsü wayuu watta saalii nünainmüin süpüla shi'rüinjachin nia oo'ulaka süpüla shi'rüinjachin Lázaro chi nüso'irakai aa'in paala. ");
INSERT INTO guc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Anoujasü nünain Jesús wainma wayuu judío süka nüso'ire'erüin naa'in Lázaro. Je na laülaayuushiikana na'akajee na sacerdote judíokana, süka suu'ulaayaa sümüin tü wayuukolüirua suulia oonowaa sümaa nanüiki, no'utee aa'inchi Lázaro wanaa nümaa Jesús. ");
INSERT INTO guc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Shiasa mapa waneemüin ka'ikat, aapüna achikichi Jesús sütüma tü wayuu wattakat saalii antüsükalüirua sünainmüin tü mi'iraakat sünain nüntajachin Jerusalénmüin. ");
INSERT INTO guc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Su'unakalaka tü wayuukolüirua nüpülamüin Jesús sulu'ujee tü pueulokat sünain kajapulu'uyaa namüin alanatüna süpüla shi'itaainjatüin nüpüla eepünaainjachire nülatüin süpüla shii'iyatüin nujutu nümüin. Namayaa namakalaka emetuluin sünain asakaa nia: “Aleluya”. “Wa'waajüin chi Maleiwakai süka nüjütüin wamüin chi Aluwataashikai waa'u wayakana Israelkana”. “Anata'aleeshija'a ma'i chi antakai wanainmüin”. ");
INSERT INTO guc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nüntakalaka Jesús saa'u wane püliikü puutut, maa aka tü ashajünakat paala nüchiki sümaiwa sulu'u tü karaloukta nüchikimaajatkat Maleiwa makat: ");
INSERT INTO guc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jia wayuu Jerusalénje'ewaliikana, nnojo mmolüin jia neema chi aluwataakai jaa'u. Anii nia antüin jünainmüin saa'u wane püliikü puutut”. ");
INSERT INTO guc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Je na nikirajüinkana Jesús, nnojotsü nayaawatüin aa'u tü kasa aa'innakat so'u ka'ikat tia. Nayaawatale aa'ulu wanaa sümaa niyalennüin Jesús iipünaamüin nünainmüin Maleiwa. Sotüsü naa'in tü ashajünakat nüchiki je tü ka'i a'waatünakat o'u naa'u sütüma tü wattakat saalii wayuu.) ");
INSERT INTO guc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Je tü wattakat saalii wayuu o'unakat nüpülamüin Jesús, sükajeejatü naapüin süchiki tü kasa anasü alatakat nümüin Lázaro, tü nütüjakat apüleerua Maleiwa nümüiwa. Naapüin nanainjee na wayuu e'rajüshiikana nukua Lázaro wanaa sümaa süso'iraain naa'in sütüma nünüiki Jesús je wanaa sümaa nujuittaain sulu'ujee tü woowirakat eejechire ni'itaanüin. ");
INSERT INTO guc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nayasa na fariseokana, naashajaajiraakalaka: —Atak, anoujasü wayuu watta saalii nünain. Nnojotsü kasakainjatüin watüma tü wayuukolüirua süpüla woo'ule'erüin shia suulia o'unaa nünainmüin —müshii naya sümaa shapaain naa'in. ");
INSERT INTO guc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sa'aka tü antüsükalüirua sünainmüin tü mi'iraakat süpüla a'waajaa Maleiwa, eeshii eekai nnojolüin judíoin. ");
INSERT INTO guc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Narütkaakalaka no'uluku nünainmüin Felipe, chi chaje'ewaikai sulu'ujee tü pueulokat Betsaida cha'aya Galilea, süpüla namüinjanain nümüin: —Ekirajüikalee, aashajaweeshii waya nümaa Jesús —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Otta müshia Felipe, nüküjakalaka shia nümüin Andrés. Je namakalaka shia nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Shiasa nantapa nünainmüin Jesús na wayuukana, nümakalaka Jesús namüin oo'ulaka namüin na nikirajüinkana: —Tayakai, chi Shipayakai Wayuu, kettaasü takalia joolu'u süpüla nii'iyatüinjatüin Maleiwa sümüin wayuu tü kasa anashaatasü naa'inrüinjatkat taka. ");
INSERT INTO guc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tamüsü paala jümüin tü shiimüinkat: Wane waüyee, mayaainje süpünajünüin sulu'u palitchoin, shiasa'a süshannapa, watta saalii. Je müleka nnojorule süpünajünüin, amülouijeerü. Akaainjachia taya, ouktajachi süpüla su'tte'ennüinjatüin tatüma wayuu wainma. ");
INSERT INTO guc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chi eekai naa'inmajiraweein nukuaippa suulia ouktaa, ouktajachia ne'e. Alu'ujasa chi eekai nnojolüin kachipünaain naa'in nukuaippa sükajee ni'yataweein nümüin Maleiwa, ayateechi nümaa Maleiwa waneepia. ");
INSERT INTO guc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chi wayuu eekai ni'yataweein tamüin, anashi müleka ni'itaale naa'in süpüla nünoujain tanain. Je anteechi nia cha'aya ee'ewaire taya sümaa kojuteechin nia nütüma chi Tashikai saa'u ni'yataain tamüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Naashajaakalaka joo Jesús nümüin Maleiwa sünain maa nümüin: “Taataa, shapatüsü ma'i taa'in. ¿Jamüinjatü tanüiki pümüin joolu'u? ‘Jaliachon taya, pülatira toulia tü alatajatkat tamüin joolu'u’, ¿müinjachi taya? Nnojoleechi müin taya pümüin, süka shiainja tantüin apüla tü ouktaakat sa'akamüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taataa, anakaja pii'iyatüle pukuaippa joolu'u sümüin wayuu sünain pülashaatain ma'i pia”, nümakalaka Jesús. Süsouktakalaka joo wane pütchi iipünaajee, müsü mayaa: “Tee'iyatüitpa takuaippa sümüin wayuu sünain pülashaatain ma'i taya, je too'ulakeerü shia süchikua”, müsü. ");
INSERT INTO guc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Shiasa'a tü wayuukolüirua wattakat saalii eejatkat nü'ütpa'a Jesús, saapaiwa'aya tü pütchikat, müsü aka sütürüla juya saa'in sümüin waneeirua. Oo'ulaka saa'in sümüin waneeirua, nünüiki wane aapiee. ");
INSERT INTO guc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nümakalaka joo Jesús sümüin tü wayuukolüirua: —Nnojotsü tayaalujutüin tü pütchikat, jiyaalujutü jiakana. ");
INSERT INTO guc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Keraaitpa sükalia tü wayuukolüirua sainküin mmakat süpüla kasalajanainjatüin sümüin saainjala nütüma Maleiwa. Otta müshia Satanás, chi aluwataashikai naa'u, alejüneerü joolu'u nuulia tü aluwatawaakat. ");
INSERT INTO guc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Otta müshia tayakai chi Shipayakai Wayuu, so'u tü ka'i akachennajachikat o'u taya süpüla ouktaa, teenakeerü wayuu sainküinjee mmakat süpüshua tanainmüin —nümataalakalaka. ");
INSERT INTO guc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nümüsü Jesús tüü namüin süpüla nii'iyatüinjatüin sünain jamüinjatüin nukuaippa sünain ouktaa. ");
INSERT INTO guc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sümakalaka tü wayuukolüirua nümüin Jesús: —¿Jamalu'ut tü pümakat wamüin sünain nükachennajachin chi Shipayakai Wayuu? Saashin tü nüshajakat Moisés nüchiki Cristo chi Nüneekajalakai Maleiwa, katajachi o'u waneepia. ¿Jaraija'a joo chi Shipayakai Wayuu paashajaakai achiki? —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nüsouktakalaka Jesús namüin: —Tayakai, shiimüin sünain tayain anaküin süpüna wayuu je yaajeechi taya jümaa motso'o ne'e. Anakaja joonoole sümaa tanüiki süma'inru'u yaain taya ja'aka süpüla jütüjaainjatüin saa'u tü shiimüinkat, süka sülü'ülüin süpüla süntüin tü piyuushikat jünainmüin. Chi eekai waraittüin sa'aka piyuushi, maa'awakuu meechi. ");
INSERT INTO guc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Anasü müleka jaapawaatüle joolu'u tü shiimüinkat eeiwa'aya shia süpüla nüpüshinjanain jia Maleiwa chi aapakai shia jümüin —nümakalaka Jesús namüin. Kettaapa nünüiki namüin, o'unüshi anujulaain noulia. ");
INSERT INTO guc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mayaainje naa'inrapü'üin Jesús wainma kasa anasü nütüjakat apüleerua Maleiwa nümüiwa su'upala tü wattakat saalii wayuu, ayatsüja'a manoujain nünain. ");
INSERT INTO guc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tüü, shia shikeraajaka tü nümakat Isaías paala, chi nünüikimaajachikai Maleiwa, tü makat: “Maleiwakalee, ja'itairü pii'iyatüin namüin pukuaippa sünain pülashin pia, ayatsia ne'e manoujuuin tü püchikikat waküjakat namüin”. ");
INSERT INTO guc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nnojoliikalaka nountüin nanoujain nünain. Müshii aka saa'in wayuu eekai mo'uin, maa aka tü nümakat Isaías: ");
INSERT INTO guc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Müleka nanoujüle nünain Maleiwa, nüla'ajaajeerü naainjala noulia. Otta nnojoliishii anoujain nünain. Süka jamüin, mo'usalii naya nütüma, matüjainsalii naya nütüma, süpüla nnojolüinjatüin nayaawatüin saa'u tü shiimüinkat”. ");
INSERT INTO guc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tü nüküjakat Isaías, nüküjain süka shii'iyatünüin nümüin nütüma Maleiwa sünain anashaateechin ma'i Jesús so'uweena wane ka'i je sünain shiyoukteechin nia wayuu. ");
INSERT INTO guc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mayaainje manoujain wainma wayuu nünain Jesús, eesü wainma na'akajee na laülaayuu judíokana anoujain nünain. Shiasa süka mmolüin naya neema na fariseokana suulia ajuittinnaa sulu'ujee tü ekirajüleekat, nounjulajakalaka nachiki sünain nanoujain nünain Jesús, ");
INSERT INTO guc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","süka shiain kee'ireein ma'i naa'in a'waajünaa sütüma wayuu nuuliale'eya Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naashajaakalaka Jesús nüchikua sümaa emetuluin nünüiki: “Chi wayuu eekai nünoujain tanain, nnojoishi tayain ne'e nünouja anain tamüiwa, nünouja anainchiya chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maa'aya aka ni'raajüle taya'aya, ni'raajüin chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Antüshi taya sa'akamüin wayuu yaa mmalu'u sünain müinya aka taya saa'in wane anakia, süka shiyaawatüinjatüin wayuu saa'u tü shiimüinkat tatüma. Chi eekai nünoujain tanain, nnojolichipa waraittüin sümaa piyuushi maa'awakuu müin suulia tü shiimüinkat. ");
INSERT INTO guc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Otta müshia chi eekai naapajüin tanüiki sümaa nnojolin noonooin sümaa, kasalajaneerü naainjala nümüin. Nnojoleechi tayain kasalajanain atüma nümüin. Süka jamüin, antüshi taya sa'akamüin wayuu süpüla to'tte'erüinjatüin shia suulia saainjala. ");
INSERT INTO guc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Na wayuu eekai nayouktüin taya oo'ulaka tü tamakat namüin maa'ulu yaa, süsaleena naya tüü so'uweena tü ka'i kasalajaneetkat o'u sümüin saainjala tü manoujainsatkalüirua. ");
INSERT INTO guc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Süka jamüin, tü taküjakat, nnojotsü tale'eru'ujeejatüin ne'e, naapajala tamüin chi Tashikai, chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Shia ne'e taküjaka waneepia tü naapakat tamüin chi Tashikai, süka tatüjaain saa'u sünain shiain ee'iranajaweerüin atüma naa'in chi eekai noonooin sümaa”, nümataalakalaka Jesús sümüin tü wayuukolüirua. ");
INSERT INTO guc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Je so'u tü ka'i nekaainjatkat o'u na judíokana tü ekawaa kanüliakat Pascua, nütüjaa aa'ut Jesús sünain keraain nükalia süpüla o'unaa sa'akajee tü wayuukolüirua eemüin chi Nüshikai. Je saa'u alin ma'i nüpüla waneepia na anoujashiikana nünain, ayatshiija'a alin ma'i naya nüpüla pejepa nükalia süpüla ouktaa naa'ujee. ");
INSERT INTO guc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Shiasa motsapa tü ka'ikat, nükotchirüin Jesús na nikirajüinkana sünainmüin tü ekawaakat. Otta chi nikirajüinkai Judaskai anülia, chi nüchonkai Simón Iscariote, e'itaanatüjülia nikiiru'u nütüma Satanás, chi sülaülakai yolujaa, süpüla naapüinjachin nikii Jesús süpüla o'utünaa aa'in. ");
INSERT INTO guc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nütüjaa aa'ut Jesús sümaa sülaülain nia kasa süpüshua nütüma chi Nüshikai, je sünain chaje'ewalin nia eejee Maleiwa je sünain nüle'ejüinjachin nüchikua nünainmüin. ");
INSERT INTO guc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Otta süpüla nii'iyatüin namüin na nikirajüinkana sünain nnojolüin yaletayaain naa'in noulia, nüsha'walaakalaka joo sünainjee tü ekawaakat je naakatüin tü nüshe'inpalajanakat sünain nijittaain wane tuwaaya nüse'eru'upünaa. ");
INSERT INTO guc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nipirajakalaka wane irala süka wüin. Nu'ttakalaka sünain o'lojoo noo'ui na nikirajüinkana sümaa noosojüin shia süka tü tuwaayakat. ");
INSERT INTO guc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Je wanaa sümaa nürütkaain nünainmüin Simón Pedro, —Senyotkalee, ¿pu'lojooinjatü too'ui? —nümakalaka Pedro nümüin. ");
INSERT INTO guc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nüsouktakalaka Jesús nümüin: —Ja'itairü nnojolüin piyaawatüin maa'ulu yaa saa'u tü taa'inrakat püka, piyaawateerü aa'u mapeena —nümataalakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Nnojottaa —nümakalaka Pedro nümüin —Nnojotsü tacheküin süpüleerua pu'lojooinjatüin too'ui. Nüsouktakalaka Jesús nümüin: —Müleka nnojoire wulein pia tatüma, nnojoleechi kasajachin pia tamüin —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Senyotkalee, müleje shia, pu'lojole'e too'ui, tajapü je tekii süma'alee —nümakalaka Pedro nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nüsouktakalaka Jesús nümüin: —Wane wayuu süchikijee o'oojoo, wulesü nüta süpüshua. Shia ne'e che'ojaaka nümüin nu'lojooin nuu'ui süchikijee waraittaa. Otta müshi'iya jiakana, wuleinapa. Waneesha'alaja'a ne'e chi nnojoikai wulein ja'aka —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nümüsü Jesús tüü süka nütüjaatüjülüin aa'u jaralinjachin aapüin nikii. ");
INSERT INTO guc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Shiasa süchikijee nu'lojoin Jesús noo'ui na nikirajüinkana, na'atüin tü nüshe'inpalajanakat sümaa nüikkalaain nüchikua eejechire paala nikaain. Nümakalaka namüin na nikirajüinkana: —¿Jamalu'ut saa'in jümüin tü taa'inrakat jüka? ");
INSERT INTO guc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ekirajüikalee” je “Senyotkalee” müshii jia tamüin. Je lotüsü jünüiki süka tia, süka tayainja'a chi jümakai. ");
INSERT INTO guc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Maa aka tayakai, chi ekirajüikai jia, chi Jüsenyotsekai, to'lojooitpa juu'ui, müinjana jia'aya ju'lojoojiraainjatü juu'ui. ");
INSERT INTO guc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tüü, tee'iyatia jümüin sünain nnojolüin yaletayaain taa'in juulia. Akaainjana jia namüin na juwalayuukana, nnojotsü yaletayaainjatüin jaa'in noulia. Akaalinjiraainjana jia waneepia. ");
INSERT INTO guc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tamüsü paala jümüin tü shiimüinkat: Wane wayuu eekai achepchieein, nnojoishi alanaain nuulia chi kachepchiakai. Je wane aluwataaushi, nnojoishi alanaain nuulia chi kajünalakai. ");
INSERT INTO guc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Otta müshi'iya jiakana, süka jütüjaaitpain saa'u joolu'u tüü, talatashaateena ma'i jia müleka ji'yataale namüin na juwalayuukana sümaa nnojolüin yaletayaain jaa'in noulia. ");
INSERT INTO guc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tü tamakat jümüin: ‘Wuleinapa jia’, nnojotsü jümüinjatüin jüpüshua. Tatüjaa aa'ulu jukuaippa jüpüshua süka taneekalain jia. Otta tü kasa alateetkat joolu'u tamüin, süpülajatü shikeraajüinjatüin tü ashajünakat paala sümaiwa sulu'u tü karalouktakat nüchikimaajatkat Maleiwa makat: ‘Nü'ünüüichipa joolu'u taya chi ekiraashikai tamaa’. ");
INSERT INTO guc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Taküjüin joolu'u jümüin tachiki süpülapünaa saapünüin tekii süpüla jünoujüinjatüin sülatapeena sünain tayain tayakai chi aküjapü'ükai tachiki. ");
INSERT INTO guc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Shiimüin tü tamakat jümüin: Chi eekai kamaneein namüin na eekai tajünalain, kamaneeshi tamü'inya. Je saa'u kamaneein tamüin, kamaneeshi nia nümüin chi kajünalakai taya'aya”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Süchikijee nümüin Jesús tüü, antajaasü wane shapashapataa aa'in nümüin. Nümakalaka namüin na nikirajüinkana: —Shiimüin tü tamakat jümüin: Naapeechi ekii taya wane ja'akajee. ");
INSERT INTO guc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Neirakaajiraakalaka joo na nikirajüinkana sünain “¿Jarai cheje eera nia?” sümüin naa'in nale'eru'u. ");
INSERT INTO guc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Otta müshia wane nikirajüinkai Jesús, chi aishikai ma'i nüpüla, yaashi joyotüin nü'ütpa'a. ");
INSERT INTO guc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nujutachonkalaka najapü Simón Pedro nümüin süpüla nüsakirüinjachin Jesús sünain jaralin chi aapüinjachin nikii. ");
INSERT INTO guc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nejejeraakalaka joo chi nikirajüinkai sünain nüsakirüin nia: —Senyotkalee, ¿jarai chi aapüinjachika pikii? —nümakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nüsouktakalaka Jesús nümüin: —Nieechi chi tacholotitkai amüin pan shiroku tü shirakat asalaa —nümakalaka. Nücholotirakalaka joo tü pankat sünain naapüin shia nümüin Judas, chi nüchonkai Simón Iscariote. ");
INSERT INTO guc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Je naapaapa Judas tü pankat, nikerolokalaka Satanás, chi sülaülakai yolujaa, nüle'eru'umüin. Nümakalaka Jesús nümüin: —Pu'una pümaala paa'inramaataiwa tü paa'inrajatkat. ");
INSERT INTO guc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Otta müshi'iya na nikirajüinkana yaakana sünain tü ekawaakat, nnojotsü nayaawatüin aa'u jamalu'ulüin tü nümakat nümüin Judas. ");
INSERT INTO guc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Saa'u niain Judas anaajaalin tü neerü nalü'üjapü'ükat na nikirajüinkana Jesús, aluwataanayaashi ne'e saa'in namüin waneeirua sünain ayalajaa tü kasa che'ojaakat namüin süpüla tü mi'iraakat. Oo'ulaka saa'in namüin waneeirua, aluwataanayaashi sünain asülajaa sümüin wayuu eekai müliain. ");
INSERT INTO guc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nujuittaataalakalaka Judas yaawalaja'aya anooipa'amüin süchikijee naapaain tü pankat süpüla o'unaa nama'anajee. Piyuupa tü mmapa'akat. ");
INSERT INTO guc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Shiasa nüchikiru'u Judas, nümakalaka joo Jesús namüin na nikirajüinkana: “Müshi paala taya jümüin tachikua: Tayakai, chi Shipayakai Wayuu, kettaasü takalia joolu'u süpüla nii'iyatüinjatüin Maleiwa sümüin wayuu tü kasa anashaatasü naa'inrüinjatkat taka. Je sünainjee tü naa'inrüinjatkat taka, sütüjaajeerü aa'u wayuu süpüshua sünain pülashaatain ma'i nia. ");
INSERT INTO guc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Je sütüjaapa wayuu naa'u sünain pülashaatain ma'i nia, nii'iyatamaateerü sümüin sünain anashaatain ma'i taya maa aka niakai. ");
INSERT INTO guc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Tachonniwaa, jia aishiikana tapüla, yaashi ne'e taya jümaa motso'o. Jüchajaweechi achiki taya sümaa nnojoleechin jüntüin tanain, süka nnojoliyülin juuntüin o'unaa chamüin eemüinjachire to'unüin, maa aka tü tamakat paala namüin na laülaayuu judíokana. ");
INSERT INTO guc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Otta müsia joolu'u, tü taluwataainjatkat anain jia, kasa jeket. Taluwataain jia joolu'u sünain aijiraainjanain jia jüpüla wane'ewaire jukua maa aka alin jia tapüla. ");
INSERT INTO guc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Müleka shiimüinre sünain aijiraain jia jüpüla, ayaawatüneena jia sütüma wayuu süpüshua sünain tekirajanain jia”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","—Senyotkalee, ¿jalainjachi pia o'unüin? —nümakalaka Simón Pedro nümüin. Nüsouktakalaka Jesús: —Nnojoyülia puuntüin o'unaa tamaa joolu'u chaa eemüinjachire taya. Alu'ujasa mapeena, tamaajeechi pia chamüin —nümataalakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Senyotkalee, ¿jamüshikai nnojoika'a tountajachin o'unaa pümaa joolu'u? O'uneeshi taya pümaa, ja'itashi taya o'utünüin aa'in pünainjee —nümakalaka Pedro nümüin. ");
INSERT INTO guc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nüsouktakalaka Jesús nümüin: —¿Shiimüin ma'i tü pümakat tamüin sünain yapain pia süpüla ouktaa tanainjee? Taküjüin paala pümüin tü shiimüinkat: Süpülapünaa nükootale'erajüin wane kaliina so'u aikat tüü, aattajaweechi pia paa'u apünüintua sünain pi'raajüin taya —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ayatüshi Jesús aashajaain namaa na nikirajüinkana sünain nümüin namüin: “Nnojo mojuin jaa'in. Anakaja ayatüle jia sünain jünoujain nünain Maleiwa maa'aya aka tana'inya. ");
INSERT INTO guc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chaa eere kepiain chi Tashikai, wainma ma'i paü. O'uneechi taya joolu'u chamüin jüpüleerua süpüla yapainjatüin tatüma tü paükalüirua jüpüla. Müleka nnojoruleje eein shia, nnojotsüje taküjain achiki jümüin. ");
INSERT INTO guc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aniin taya o'unüinjachin joolu'u süpüla yapainjatüin tatüma tü paükalüirua jüpüla, ale'ejeechi taya joo'omüin süpüla tasaajüin jia süpüla chainjanain jia eere taya. ");
INSERT INTO guc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jütüjaa aa'ulu eemüinjachire to'unüin otta jalapünaainjanain jia süpüla jüntüin chamüin”, nümataalakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aashajaashi joo Tomás, wane chi nikirajüinkai Jesús: —Senyotkalee, nnojotsü watüjaain aa'u eemüinjachire pu'unüin, shialeeka watüjaweematüin aa'u jalapünaainjanain waya süpüla wantüin chamüin. ");
INSERT INTO guc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nüsouktakalaka Jesús nümüin: —Tayakai, taya chi süntajachikai akajee wayuu nünainmüin Maleiwa, süka tayain ee'iyatüin sümüin tü shiimüinkat nüchikikat Maleiwa süpüla shii'iranajaainjatüin saa'in tatüma süpüla eeinjatüin nümaa waneepia. Chi e'raajirakai Maleiwa, taya tayakai tamüiwa. ");
INSERT INTO guc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Müleka shiimüinreje sünain ji'raajüin ma'i taya, ji'raajüinje chi Tashikai wanaa tamaa. Je shiasa joolu'u, ji'raajeechi chi Tashikai sünainjee tü naa'inrüinjatkat taka —nümataalakalaka Jesús nümüin Tomás. ");
INSERT INTO guc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nüsouktakalaka wane'eya, chi Felipekai anülia: —Senyotkalee, müleka pii'iyatüle wamüin chi Püshikai, aneerü waa'in sümaa. ");
INSERT INTO guc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nüsouktakalaka Jesús nümüin: —Atak, ja'itaichiyala'a kakaliaichin taya jümaa, nnojoliyüitta'aya pi'raajüin taya. Chi eekai ni'rüin taya, ni'rüin chi Tashika'iya. ¿Jamalu'utka'a pütüma “Pii'iyata wamüin chi Püshikai” pümakalaka tamüin? ");
INSERT INTO guc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Jamüsü nnojotka'a pünoujain tanain sünain sa'aniraain takuaippa nümaa chi Tashikai je sünain sa'aniraain nukuaippa tamaa? —nümakalaka Jesús nümüin Felipe. Aashajaashi joo Jesús namüin napüshua: “Tü pütchi taküjapü'ükat jümüin, nnojotsü pütchi ne'e tale'eru'ujeejatü. Je tü kasa anasü taa'inrapü'ükat, tountüin taa'inrüin süka sa'aniraain nukuaippa chi Tashikai tamaa. ");
INSERT INTO guc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Anakaja jünoujüle tü tamakat jümüin sünain sa'aniraain takuaippa nümaa chi Tashikai je sünain sa'aniraain nukuaippa tamaa. Müleka isale shia jüchiki jünoujain, jünouja shia tamüin sünainjee ji'rüin tü kasa anasü taa'inrapü'ükat, tü nütüjakat apüleerua Maleiwa nümüiwa. ");
INSERT INTO guc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Shiimüin tü tamakat jümüin: Chi eekai ni'itaain naa'in sünain anoujaa tanain, nuunteerü naa'inrüin kasa anasü makat aka saa'in tü taa'inrapü'ükat ju'upala. Je tü naa'inreetkat, alana'aleejeeria sünain anain ma'i suuliale'eya tü taa'inrapü'ükat, süka to'unüinjachin eemüin chi Tashikai. ");
INSERT INTO guc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Je süpüshua tü kasa jüchunteetkat nümüin chi Tashikai saa'u tapüshin jia, taa'inreerü shia süpüla nütüjaanüinjachin aa'u sünain anashaatain ma'i nia sütüma tü taa'inreetkat jümüin, tayakai chi Nüchonkai. ");
INSERT INTO guc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Otta süpüshua tü jüchuntakat tamüin tayakai saa'u tapüshin jia, taa'inreerü jümüin”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ayatshi aashajaain joo Jesús namaa na nikirajüinkana sünain müin mayaa: “Müleka aire ma'i taya jüpüla, jaa'a meena jia sümüin tü taluwataapü'ükat anain jia. ");
INSERT INTO guc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Otta müshia tayakai, tachunteerü nümüin chi Tashikai süpüla nüjütüin jünainmüin wane Akaaliijü'iya maa aka tayakai süpüla eeinjachin jümaa waneepia. ");
INSERT INTO guc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nieechi chi Naa'inkai Maleiwa, chi ekirajeechikai jia sünain tü shiimüinkat noo'opünaa Maleiwa. Otta tü wayuukolüirua eekai manoujain tanain, nnojoleechi kapülain saa'in nia, süka nnojolüin shiyaawatüin saa'u nukuaippa je süka mochoojüin nia so'u. Alu'ujasa jiakana, ji'raajüin süka eein nia jümaa. Je mapeena, sulu'ujeechi jaa'in. ");
INSERT INTO guc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nnojoleena makatüin jia jümüiwa sünain makaaliijuwaa tatüma. Ale'ejeechi taya jünainmüin. ");
INSERT INTO guc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Che'ojaasü motso'o ne'e süpüla nnojoireeinjachin shi'rüin taya wayuu eekai manoujain tanain. Alu'ujasa jiakana, ji'reechi taya. Saa'u katüinjatüin to'u süchikua, akaweenia jiakana kateena o'u nümaa Maleiwa süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Je so'u tü ka'i nüjütüneechikat o'u jünainmüin chi Naa'inkai Maleiwa, jütüjaweechi aa'u taya sünain sa'aniraain takuaippa nümaa chi Tashikai je sünain sa'aniraain jukuaippa tamaa maa'aya aka takuaippa jüma'aya. ");
INSERT INTO guc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chi eekai noonooin sümaa tü taluwataakat anain nia, nia'aya aika apüla taya. Je saa'u alin taya nüpüla, aijeechi nia nüpüla chi Tashikai. Je aijeechi nia tapülaya sümaa tee'iyatüin takuaippa nümüin”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nüsouktakalaka wane nikirajüin, chi kanüliakai Judas (nnojoishi niain chi Judas Iscariotekai): —Senyotkalee, maa aka pii'iyatüinjatüin pukuaippa wamüin, ¿jamaka'a nnojolüinjatka'a pii'iyatüin pukuaippa namüin na manoujainsaliikana? —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nüsouktakalaka Jesús nümüin: —Tamüsü paala pümüin süchikua: Chi eekai alin apüla taya, oonoweechi sümaa tü tekirajakat anain. Aijeechi nia'aya nüpüla chi Tashikai je anteena waya nünainmüin süpüla nümaain waya waneepia. ");
INSERT INTO guc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Otta chi eekai nnojolüin noonooin sümaa tü tekirajakat anain, maalinsai taya nüpüla. Je tü pütchi tamakat ayouktünakat sütüma tü wayuukolüirua, nnojotsü pütchin tale'eru'ujeejatü ne'e. Naapajala chi Tashikai tamüin, chi kajünalakai taya —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nümakalaka joo namüin napüshua na nikirajüinkana: “Tamüsü jümüin tüü süma'inru'u yaayülin taya jümaa. ");
INSERT INTO guc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Je chi Naa'inkai Maleiwa, chi Akaaliijüikai, ajütüneechi jünainmüin nütüma chi Tashikai sünainjee tapüshin jia. Nikirajeena jia sünain kasa süpüshua noo'opünaa Maleiwa je nüso'ireerü jaa'in sünain süpüshua tü tamapü'ükat jümüin. ");
INSERT INTO guc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aapüneerü joolu'u wane anaa jümüin. Je chi aapüinjachikai shia jümüin, taya tayakai chi Jüsenyotsekai. Otta tü anaa taapajatkat jümüin, nnojotsü müin aka saa'in tü anaa saapakat wayuu. Je sükajee tia, anakaja nnojorule mojuin jaa'in sümaa mmolüin jia seema tü kasa alateetkat. ");
INSERT INTO guc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Soto jaa'in tü tamakat jümüin: Mayaainje to'unajachin juulia, ale'ejeechi taya tachikua jünainmüin. Müleka aireje'eya ma'i taya jüpüla, talateerüje jaa'in sümaa to'unajachin eemüin chi Tashikai, süka laülaain nia toulia. ");
INSERT INTO guc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tamüsü jümüin tüü süpülapünaa to'unüin, süpüla jünoujainjatüin sünain pansaain tanüiki sülatapeena tü tamakat. ");
INSERT INTO guc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Alü'ütsü joo süpüla kettaain taashajala jümaa, süka nüntamaateechin Satanás. Mayaainje nuluwataain saa'u wayuu sainküin mma, nnojoishi laülaain nia taa'u. ");
INSERT INTO guc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chi toonookai amaa waneepia, nia chi Tashikai. Je joolu'u saa'u taa'inrüinjatüin tü nuluwataakat anain taya, atüjaaneerü aa'u sütüma wayuu sainküin mma sünain alin ma'i nia tapüla”, nümakalaka Jesús namüin na nikirajüinkana. Je kettaapa nünüiki namüin, “Joo'uya wo'unaiwa yaajee”, müshi nia namüin. ");
INSERT INTO guc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Je sünain waraittain Jesús, yootüshi nia namaa na nikirajüinkana sünain nümüin namüin: “Wane sütüna wunu'u, kachonsü shia süka sünaain shia tü wunu'ukot, akaweenia jiakana juunteerü jaa'inrüin kasa anasü sünainjee sa'aniraain jukuaippa tamaa. Taya'aya tayakai chi wunu'u shiimüinshikai süka tayain tamüiwa suuntaka akajee wayuu saa'inrüin kasa anasü. Otta chi Tashikai, müshi aka naa'in wane a'yataai sulu'u yüüja, süka nükaaliijain jia süpüla juuntüinjatüin jaa'inrüin kasa anasü. ");
INSERT INTO guc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akaajasa müleka nnojorule jaa'inrüin kasa anasü, meena aka jia saa'in tü sütünakalüirua wunu'u ashottünakat nütüma chi aa'inmajüikai saaliijee machonwaa. Alu'ujasa chi aa'inrakai kasa anasü, wuleerü naa'in nütüma Maleiwa süpüla nuuntüinjatüin naa'inrüin waneepia kasa anasü, maa aka tü wunu'u anaatünakat ma'i atüna süpüla ayatüinjatüin kachoin. ");
INSERT INTO guc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Je jiakana, wuleitpa jaa'in sütüma tü pütchi tamapü'ükat jümüin. ");
INSERT INTO guc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Müleka ayatüle sa'aniraain jukuaippa tamaa, ayateerü juuntüin tatüma aa'inraa kasa anasü. Nnojorule kachetüin sütüna wane wunu'u sünain, machonjeerü tü sütünakat. Akaweenia jiakana, nnojoleerü juuntüin jaa'inrüin kasa anasü müleka nnojorule ayatüin jia tanain. ");
INSERT INTO guc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Tayakai, müshi aka saa'in tü wunu'ukot. Otta jiakana, müshii aka saa'in tü sütünakat. Süka jamüin, chi wayuu eekai ayatüin sünain sa'aniraain nukuaippa tamaa je takuaippa nümaa, naa'inreerü wainma kasa anasü. Müleka nnojorule ayatüin jia tanain, nnojoleerü juuntüin jaa'inrüin kasa anasü. ");
INSERT INTO guc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chi wayuu eekai nnojolüin sa'aniraain nukuaippa tamaa, müshi aka saa'in wane sütüna wunu'u eekai süshottünüin sümaa sükotchijünüin süpüla a'ajünaa jutpa. ");
INSERT INTO guc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Otta müleka sa'aniraale jukuaippa tamaa sümaa joonooin sümaa tanüiki, jüchunta nümüin chi Tashikai tü kasa kee'ireekat jaa'in, je aapüneerü shia jümüin. ");
INSERT INTO guc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Müleka jaa'inrüle ma'i wainma kasa anasü, a'waajüneechi chi Tashikai sünainjee tia je atüjaaneena aa'u sümaa tekirajüin jia. ");
INSERT INTO guc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Maa aka alin taya nüpüla chi Tashikai, aishii jia tapülaya. Joonoo jumaala sümaa tanüiki süpüla ayatüinjanain jia alin tapüla. ");
INSERT INTO guc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Müleka joonoole sümaa tü taluwataakat anain jia, ayateena jia alin tapüla, maa aka ayatüin alin taya nüpüla chi Tashikai saa'u toonooin sümaa tü nuluwataakat anain taya. ");
INSERT INTO guc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Taküjain jümüin tüü süpüla talatashaatainjatüin ma'i waneepia jaa'in tanainjee. ");
INSERT INTO guc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Tü taluwataakat anain jia, shia tüü: Aijiraa jia jüpüla maa aka alin jia tapüla. ");
INSERT INTO guc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wane wayuu, aapajiraakai nukuaippa süpüla ouktaa saa'ujee nütünajutüirua, miyo'ushaata ma'i naalii nüpüla. ");
INSERT INTO guc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","‘Tatünajut’ meechi taya jümüin müleka joonoole waneepia sümaa tü taluwataakat anain jia. ");
INSERT INTO guc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nnojoleena ‘tachepchia’ tamüin jia. Süka jamüin, wane achepchiee, nnojotsü aküjünüin nümüin tü naa'inrakat chi nülaamainkai. Alu'ujasa jiakana, ‘tatünajut’ tamüshii jia süka taküjüin jümüin süpüshua tü aküjünakat tamüin nütüma chi Tashikai. ");
INSERT INTO guc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nnojoishi jüneekajalain taya, jia taneekajalaka. Te'itaain jia süpüla jaa'inrüinjatüin wainma kasa anasü matüjainkat amalajawaa. Müleka jaa'inrüle tia, naa'inreerü chi Tashikai jümüin süpüshua tü juchuntakat nümüin saa'u tapüshin jia. ");
INSERT INTO guc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nnojo motüin jaa'in tü taluwataakat anain jia makat: Aijiraa jia jüpüla”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Aashajaashi Jesús nüchikua namüin: “Müleka kanainre jia saa'in tü manoujainsatkalüirua, soto jaa'in sünain tayain kanain saa'in palajana. ");
INSERT INTO guc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Müleka wanaawaleje jaa'in namaa, aishiije jia napüla maa aka alin napüla na wanaawakana namaa. Otta süka taneekajalain jia na'akajee, nnojoishii wanaawain jia namaa. Je sükajee tüü, maalinsalii jia napüla. ");
INSERT INTO guc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Soto jaa'in tü pütchi tamayütkat jümüin makat: ‘Wane wayuu eekai achepchieein, nnojoishi alanaain nuulia chi kachepchiakai’. Maa aka eein wayuu kapülakat aa'in tü tekirajakat anain, meenia jiakana atüma'aya. Je maa aka eein wayuu eekai ni'rüin wayumüin tamüin, akaweenia jiakana atüma'aya. ");
INSERT INTO guc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Meena jia atümaa saa'u tapüshin jia je saa'u nnojolin ne'raajüin chi kajünalakai taya. ");
INSERT INTO guc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Müleka nnojoireje tantüin na'akamüin na manoujainsaliikana sünain ekirajaa naya, nnojotsüje kasain kasalajanainjatüin namüin. Otta müsia saa'u tantüichipain na'akamüin, nnojotsü jamüinjatüin nanüiki. ");
INSERT INTO guc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Je chi eekai kanain naa'in taya, kanainshi naa'in chi Tashikai wanaa tama'aya. ");
INSERT INTO guc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Müleka nnojoireje taa'inrüin no'upala tü kasa anasü nütüjakat apüleerua Maleiwa nümüiwa, nnojotsüje kasain kasalajanainjatüin namüin. Otta mayaainje ne'rüin tü kasa anasü taa'inrapü'ükat, ayatshiija'a kanain naa'in taya oo'ulaka chi Tashika'iya. ");
INSERT INTO guc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Müsü nakuaippa süpüla shikeraajüinjatüin tü pütchi ashajünakat paala sulu'u tü karaloukta nüchikimaajatkat Maleiwa makat: ‘Nnojotsü kasain kanainjeein na'ürüla tanain’. ");
INSERT INTO guc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nüntapeena jünainmüin chi Akaaliijüikai, chi Naa'inkai Maleiwa, chi tajüteechikai chajee iipünaajee nüma'anajee chi Tashikai, nii'iyateerü jümüin süpüshua tü shiimüinkat noo'opünaa Maleiwa. Je aashajaweechi nia tachiki jümaa. ");
INSERT INTO guc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Otta müshi'iya jiakanaya, anashii müleka jüküjüle tachiki sümüin wayuu, süka jiainja'a tamaatüjüli'inya to'ttoiwa'aya sünain ekirajaa wayuu. ");
INSERT INTO guc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Taküjain jümüin süpüshua tüü süpüla sotüinjatüin jaa'in tanüiki ji'rapa müliaa suulia sümalaja'alaain jünoula tanain. ");
INSERT INTO guc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","So'uweena wane ka'i, ajünajaaneena jia sulu'ujee tü ekirajüleekat. Je chi eekai nu'uteein jaa'in, talateechi Maleiwa nümaa naashin müleka nu'utüle jaa'in. ");
INSERT INTO guc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Naa'inreerü kasa mojusü eekai müin aka tia, süka nnojolin ne'raajüin chi Maleiwakai je süka nnojolin ne'raajüin tayaka'iya. ");
INSERT INTO guc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Taküjüin jümüin joolu'u tüü tama'ichiki süpüla sotüinjatüin jaa'in shia mapeena ji'rapa tü müliaakat. Nnojotsü taküjapü'üin shia jümüin paalainka süka aniiyüli'inya taya jümaa”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Aashajaashi Jesús nüchikua namüin: “Je joolu'u, o'unajachi taya jüma'anajee eemüin chi Tashikai chi kajünalakai taya. Tatüjaa aa'ulu jamüin nnojoika'a jüsakirüin taya sünain jalamüinjachin taya. Shia süka mojushaatain ma'i jaa'in sütüma tü kasa tamayütkat jümüin. ");
INSERT INTO guc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Shiimüin tü tamüinjatkat joolu'u jümüin: Müleka to'unüle jüma'anajee, jiainjana anaka sükajee, süka tajüteechin jünainmüin chi Akaaliijüikai. Müleka yaale taya jümaa, nnojoleechi antüin. ");
INSERT INTO guc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Je nüntapa yaamüin, nii'iyateerü sümüin wayuu eekai manoujain tanain sünain nnojolüin lotüin tü sünoujakat anain. Süka jamüin, nnojotsü nanoujain tü shiimüinkat sünain kaainjaraliin naya, sünain maainjalasalin tayakai, je sünain kasalajaneerüin namüin naainjala so'uweena wane ka'i. ");
INSERT INTO guc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nnojotsü lotüin nekiiru'u sünain kasain wayuu tü aainjalaakat, süka nayouktüin anoujaa tanain. ");
INSERT INTO guc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nnojotsü lotüin nekiiru'u sünain wayuuin maainjalasai taya, süka to'unüinjachin nünainmüin chi Tashikai sümaa nnojoleechin taya shi'rüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nnojotsü lotüin nekiiru'u sünain kasalajaneerüin namüin naainjala, süka kasalajanaitpain nümüin naainjala Satanás, chi aluwataashikai naa'u na manoujainsaliikana sainküin mma. ");
INSERT INTO guc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Wainma tü pütchi isakat süpüla taküjüin jümüin. Otta nnojoleerü taküjüin jümüin süpüshua, süka kapüleejeerüin jümüin jiyaawatüin saa'u maa'ulu yaa. ");
INSERT INTO guc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Otta müshia chi Naa'inkai Maleiwa nüntapa, chi ekirajeechikai jia sünain tü shiimüinkat, nükaaliijeena jia süpüla jiyaawatüinjatüin saa'u süpüshua tü shiimüinkat noo'opünaa Maleiwa. Tü nümüinjatkat jümüin, nnojoleerü pütchi ne'e nüle'eru'ujeejatü. Shieerü nüküjaka tü aküjünakat nümüin. Je naapireena jia süchiki tü kasa alateetkat mapeena. ");
INSERT INTO guc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","15","Chi Tashikai, nüküjüin tamüin süchiki kasa süpüshua. Otta tü nüküjakat tamüin, shia taküjapü'ükat jümüin. Je chi Naa'inkai Maleiwa, nüso'ireerü jaa'in sünain tü taküjapü'ükat jümüin. Je sünainjee nikirajeenain jia sünain tü taküjakat, kojuteechi taya jütüma. ");
INSERT INTO guc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Je joolu'u, motsomüin yaain taya jümaa. Shiasa palitchon ka'i, ji'reechi taya tachikua”, nümakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Naashajaajiraakalaka joo wane ne'ipa na nikirajüinkana sünain maa: —¿Jamalu'ut cheje nünüiki wamüin sünain: “Je joolu'u, motsomüin yaain taya jümaa. Shiasa palitchon ka'i, ji'reechi taya tachikua”, makat? ¿Je jamalu'ut tü nümakat wamüin sünain: “Süka to'unüinjachin nünainmüin chi Tashikai”, makat? —namajiraakalaka. ");
INSERT INTO guc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ayatshii naya sünain nasakiijiraain sünain: —¿Jamalu'ut cheje nünüiki wamüin sünain: “Je joolu'u motsomüin”, oo'ulaka “Shiasa palitchon ka'i”, makat? Nnojotsü wayaawatüin aa'u tü nümakat wamüin. ");
INSERT INTO guc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Otta müshia Jesús, süka nütüjaain saa'u sünain nasakireein nia süchiki tü nümakat paala namüin, nümakalaka namüin: —¿Aashajaajiraashii jia sünain tü tamakat sünain: “Je joolu'u, motsomüin yaain taya jümaa. Shiasa palitchon ka'i, ji'reechi taya tachikua”, makat? ");
INSERT INTO guc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Shiimüin tü tamüinjatkat joolu'u jümüin: Mojeerü ma'i jaa'in sümaa ji'yalajüin mapeena. Otta tü manoujainsatkalüirua sainküin mma, talateerü saa'in. Mayaainje mojeerüin jaa'in, talateerü jaa'in süchikijee. ");
INSERT INTO guc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Wane jierü eekai jemeyulüin, aisü sümüin saalii tü süchonkot. Otta süchikijee jemeyulüin, anasü. Motüsü saa'in tü müliaakat süka talatüin ma'i saa'in sujuittapa süchon. ");
INSERT INTO guc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Müshii aka jiakana sünain mojuin jaa'in joolu'u. Otta süchikijee mapa ji'rapa taya, talateerü ma'i jaa'in. Je nnojoleerü oo'ulaain juulia tü talataakat aa'in. ");
INSERT INTO guc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Je so'uweena ka'ikat tia, nnojoleechi taya jüsakirüin sünain wane kasa. Shiimüin tü tamakat jümüin: Kasa süpüshua eekai juchunteerüin nümüin chi Tashikai sünainjee jiain tapüshin, naapeerü shia jümüin. ");
INSERT INTO guc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Je jüchuntaiwa'aya nümüin chi Tashikai paala, nnojotsü juchuntüin sünainjee jiain tapüshin. Otta müsia joolu'u, anakaja jüchuntüle sünainjee jiain tapüshin, je aapüneerü tü kasa jüchuntakat jümüin nütüma. Je talatashaateerü ma'i jaa'in süka tia”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ayatüshi Jesús aashajaain namaa: “Aküjüshi taya nüchiki chi Tashikai jümüin süka sukuaippa tü kasa e'nnaajünakat sainküin mma. Otta so'uweena wane ka'i, nnojoleechi müin aka taya joolu'u sünain ekirajaa jia, alu'ujasa lotüinjatü tanüiki nüchiki. ");
INSERT INTO guc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Je so'u ka'ikat tia, nnojoleechi tayain chi achuntakai nümüin chi Tashikai jaa'ujee. Alu'ujasa juunteerü jüchuntüin nümüin jiakana sünainjee jiain tapüshin, ");
INSERT INTO guc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","süka alin jia nüpüla niaka'iya. Aishii jia nüpüla chi Tashikai süka alin taya jüpüla je süka jünoujain sünain nüma'anajeejachin taya. ");
INSERT INTO guc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Shiimüin sünain tantüshin chajee iipünaajee nüma'anajee chi Tashikai yaamüin yaa sa'akamüin wayuu. Je joolu'u, o'uneechi taya tachikua sa'akajee wayuu eemüin chi Tashikai”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Namakalaka na nikirajüinkana nümüin: —Atak, lotüitpa joo pünüiki wamüin je nnojolüitpa paashajaain süka sukuaippa tü kasa e'nnaajünakat sainküin mma. ");
INSERT INTO guc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Watüjaaichipa aa'u pia sünain piyaawatüin saa'u kasa süpüshua. Müleka wasakireere pia sünain wane kasa, pütüjaatüjülia aa'ut tü jülüjakat waa'in. Sükajee tüü, anoujainapa waya süka süpüshua waa'in sünain püntüshin nüma'anajee Maleiwa —namakalaka nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nüsouktakalaka Jesús namüin: —¿Shiimüin cheje eera sünain jünoujainapain süka süpüshua jaa'in? ");
INSERT INTO guc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Alü'ütsü jükalia süpüla ju'walakajaain wane'ewa'ire jukua. Shiimüin sünain süntüitpain tü jükaliakat süpüla jüpütüinjachin taya sümaa jüle'ejüin jipialu'umüin. Otta müshia tayakai, nnojoleechi tamüiwain süka eein chi Tashikai waneepia tamaa. ");
INSERT INTO guc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Taküjain jümüin tüü süpüla anainjanain jia sünainjee sa'aniraain jukuaippa tamaa. Mayaashiije mülieenain jia mapeena sütüma tü kasa mojusü saa'inreetkat tü manoujainsatkalüirua jüka, anakaja joolu'u talatüle jaa'in süka tayamülüichipain chi aluwataashikai naa'u na manoujainsaliikana”, nümataalakalaka Jesús namüin na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Shiasa süchikijee naashajaain Jesús namaa na nikirajüinkana, eirakaashi nia iipünaamüin süpüla aashajawaa nümaa Maleiwa: “Taataa, kettaasü joo takalia süpüla ouktaa. Anakaja joolu'u müleka pii'iyatüle sümüin wayuu tü kasa anashaatasü paa'inrüinjatkat taka tayakai chi Püchonkai süpüla sütüjaainjatüin aa'u wayuu süpüshua sünain pülashaatain ma'i pia. ");
INSERT INTO guc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","E'itaanüshi taya pütüma süpüla laülaainjachin saa'u wayuu süpüshua. Otta müsia tü wayuukolüirua e'itaanakat pütüma tajapulu'u, pücheküin süpüleerua shii'iranajaainjatüin saa'in tatüma süpüla eeinjanain naya pümaa waneepia. ");
INSERT INTO guc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Chi wayuu ee'iranajaaitpakai aa'in, nuuntüin niyaawatüin joolu'u saa'u tü shiimüin ekirajünakat püchiki sünain waneeshin pia sünain Maleiwain, je tachiki tayakai Jesucristo sünain püjünalain taya sa'akamüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Saa'u tekeraajüin süpüshua tü puluwataakat anain taya, tee'iyatüitpa pukuaippa sümüin wayuu süpüshua sainküin mma sünain anashaatain ma'i pia. ");
INSERT INTO guc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taataa, anakaja müleka kojutüle taya pütüma joolu'u chaa iipünaa eere pia, maa aka kojutpü'üin taya pütüma sümaiwa paala nnojolüiwa'aya sükumajünüin tü kasakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Taataa, na tekirajüinkana, na aneekuushikana pütüma sa'akajee wayuu, tee'iyatüin pukuaippa namüin sünain anashaatain ma'i pia. Saa'u püpüshin naya, pi'itaain naya süpüla nayainjanain na tekirajüinkana. Je noonooitpain sümaa pünüiki. ");
INSERT INTO guc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Otta müsia joolu'u, natüjaaitpa aa'u sünain shiimüin pünainjeejatüin süpüshua tü püküjakat tamüin. ");
INSERT INTO guc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tü pütchikat püküjapü'ükat tamüin, taküjain shia namüin je kapülasü naa'in tanüiki. Natüjaa aa'ut sünain shiimüin tantüshin püma'anajee je nanoujain sünain püjünalain taya sa'akamüin wayuu. ");
INSERT INTO guc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Taataa, achuntüshi joolu'u taya pümüin naa'u na tekirajüinkana. Nnojoishi taya achuntüin pümüin saa'u wayuu eekai nnojolüin sünoujain tanain, alu'ujasa naa'u nayakana süka nayain na aneekuushikana pütüma je süka nayain püpüshin. ");
INSERT INTO guc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Je saa'u püpüshin naya, tapüshi tayaka'iya. Je süka nanoujain tanain, na'waajüin ma'i taya. ");
INSERT INTO guc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nnojoleechi makatüin taya yaaya sa'aka wayuu, süka to'unajachin pünainmüin. Otta müshi'iya na tekirajüinkana, makateena naya yaaya sa'aka tü wayuu manoujainsatkalüirua. Taataa, pia A'waajünakai, tachuntüin pümüin sünain paa'inmajüinjanain na tekirajüinkana süpüla wanaawajiraain naa'in maa aka wayakana sünain wanaawajiraain waa'in. Paa'inmaja naya süka tü püpülainkat. Saa'u paapüin tü püpülainkat tamüin paala, ");
INSERT INTO guc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","tountüin taa'inmajüin naya wanaa sümaa eepü'üin taya namaa. Je süka taa'inmajüin naya suulia kasa eekai mojuin, nnojoliishii naya ojutuuin. Waneeshia ne'e niain Judas ojutuuin süpüla amüloulin, chi e'itaanatüjüika'iya süpüla tia, süpüla shikeraajüinjatüin tü ashajünakat nüchiki sulu'u tü nüchikimaajatkat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“O'uneechi taya joolu'u pünainmüin. Otta süka yaayülin taya sa'aka wayuu, aashajaashi taya pümaa joolu'u süpüla talatashaatain ma'i naa'in na tekirajüinkana sütümajee tanüiki maa aka tayakai sünain talatüin taa'in. ");
INSERT INTO guc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taküjüitpa namüin süpüshua tü püküjakat tamüin. Akatsa'a maalin naya süpüla tü manoujainsatkalüirua, süka nnojoliin süpüshin naya maa aka tayakai sünain nnojolin süpüshinya. ");
INSERT INTO guc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Nnojoishi taya achuntüin pümüin süpüla püsaajüinjanain naya sa'akajee tü wayuukolüirua eekai manoujain, alu'ujasa süpüla paa'inmajüinjanain naya nuulia chi Kama'üraikai. ");
INSERT INTO guc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nnojoliishii süpüshin naya tü manoujainsatkalüirua, maa aka tayakai sünain nnojolin süpüshinya. ");
INSERT INTO guc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anakaja müleka pükatarüle naya pünainmüin sütümajee tü pünüiki shiimüinkat pi'itaakat napüleerua süpüla noonooin sümaa. ");
INSERT INTO guc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Je maa aka püjütüin taya sa'akamüin wayuu, tajütüin na tekirajüinkanaya sa'akamüin. ");
INSERT INTO guc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Je takatalaain pünainmüin süpüla jüüjüüin taya pümüin süpüla nakatannüinjanain pünainmüin na tekirajüinkanaya”, nümakalaka Jesús nümüin Maleiwa sünain nüchuntüin naa'u na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ayatshi Jesús achuntüin nümüin Maleiwa: “Nnojoishi taya achuntüin joolu'u pümüin naa'u na tekirajüinkana ne'e namüiwa. Achuntüshi taya'aya naa'u na wayuu anoujainjanakana tanain sütüma tü nekirajüinjatkat anain na tekirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Taataa, achuntüshi taya pümüin naa'u na anoujashiikana napüshua süpüla wanaawajiraainjatüin naa'in. Maa aka sa'aniraain pukuaippa tamaa je sa'aniraain takuaippa püma'aya, tacheküin müleka sa'aniraale nakuaippa wamaa süpüla shiyaawatüinjatüin aa'u wayuu süpüshua sainküin mma sünain tajütüüshin pütüma. ");
INSERT INTO guc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Tee'iyatüitpa sünain kojutüin naya tatüma, maa aka kojutüin taya pütüma paala sümaiwa, süpüla wanaawajiraainjatüin naa'in, maa aka wayakana sünain wanaawajiraain waa'in. ");
INSERT INTO guc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Saa'u sa'aniraain takuaippa namaa, maa aka sa'aniraain pukuaippa tamaa, tachuntüin süpüla wanaawajiraainjatüin ma'i naa'in waneepia. Je müleka wanaawajiraale naa'in, sütüjaajeerü aa'u wayuu süpüshua sünain ajütüüshin taya pütüma je sünain alin naya püpüla maa aka alin püpüla tayaka'iya. ");
INSERT INTO guc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taataa, na wayuu e'itaanakana pütüma tajapulu'u, tacheküin napüleerua tamaainjanain naya chaa eere taya, süpüla ne'rüinjachin taya sünain anashaatain ma'i. Shiimüin sünain kojutüin ma'i taya pütüma süka alin taya püpüla sümaiwa paala nnojolüiwa'aya sükumajünüin tü kasakat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Taataa, pia lotokai akuaippa sünain kasalajanain pütüma sümüin wayuu saainjala, mayaainje nnojolin shi'raajüin pia wayuu eekai manoujain, te'raajüin pia tayakai. Je na anoujashiikana, natüjaa aa'ulu sümaa püjünalain taya, ");
INSERT INTO guc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","sükajee tee'iyatüitpain pukuaippa namüin. Je ayateechi taya sünain tee'iyatüin shia namüin süpüla aijiraainjanain naya napüla maa aka alin taya püpüla, je süpüla sa'aniraainjatüin takuaippa namaa”, nümakalaka Jesús nümüin Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Shiasa süchikijee nüchuntüin Jesús nümüin chi Nüshikai, nu'unakalaka namaa na nikirajüinkana waneemüin sa'ata wane luwopu kanüliakat Cedrón, suupünaamüin wane wunu'ulia kanüliasü Olivos. ");
INSERT INTO guc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Otta müshia Judas, chi aapüinjachikai nikii Jesús, ni'raajüin tü wunu'uliakat süka noutkajaapü'üin cha'aya Jesús namaa na nikirajüinkana. ");
INSERT INTO guc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nüntakalaka joo Judas eemüin Jesús sümaa wane surulaalüirua je wane suwaariase tü a'waajüleekat Maleiwa ajütünakana natüma na fariseokana je natüma na laülaashiikana na'akajee na sacerdote judíokana. Kajapulu'uyaa müshii chajaruuta oo'ulaka kasimo'uyaa müshii süpüla nanaküin tü wopukot. ");
INSERT INTO guc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Otta Jesús, sünain nütüjaain saa'u süpüshua tü aa'innüinjatkat joolu'u nüka, nürütkaakalaka sünainmüin tü surulaatkalüirua sünain nüsakirüin naya: —¿Jarai jüchajaaka achiki? ");
INSERT INTO guc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús chi Nazaretje'ewaikai —namakalaka. —Taya'aya tayakai —nümakalaka Jesús namüin. Otta müshia Judas chi aapakai nikii, eejachi sha'watüin namaa na surulaatkana. ");
INSERT INTO guc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Je wanaa sümaa nümüin Jesús namüin: “Taya'aya tayakai”, ansünajaashii sünain no'nnajaain mmalu'u. ");
INSERT INTO guc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nüsakirakalaka joo Jesús nüchikua: —¿Jarai jüchajaaka achiki? —Nia Jesús chi Nazaretje'ewaikai —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Tamüinapa'asa jia sünain taya'ayain tayakai. Müleka tayale jüchajaain, juu'ulaa no'unaiwa na wayuu yaakana tamaa —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Müsü nünüiki Jesús süpüla shikeraajüinjatüin tü nümakat paala sünain maa: “Nnojotsü amüloulin toulia waneesükaije'e na'akajee napüshua na ni'itaakana Maleiwa süpüla nayain tapüshin”. ");
INSERT INTO guc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Je Simón Pedro, nuwatakalaka noo'omüin wane nüchepchia chi laülaashikai napüleerua na sacerdote judíokana sümaa wane chajaruuta. Nüchoto'oleekalaka tü nüche'e nikialu'ujeejatkat. Otta müshia chi achepchieekai, Malco nünülia. ");
INSERT INTO guc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nümakalaka Jesús nümüin Pedro: —Pi'itaa püchajaruutse süchikua sulu'u süta. Acheküsü talatirüin tü müliaa nüchekakat chi Tashikai tapüleerua. ");
INSERT INTO guc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chi sülaülashikai surulaat namaa na surulaatkana je na suwaariasekana tü a'waajüleekat Maleiwa, amaanüshi Jesús natüma ");
INSERT INTO guc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sünain kapüin nia süpüla no'unirüin nia palajana nünainmüin Anás. Nia nüshimiaka Caifás chi laülaashikai so'u juyakat tia napüleerua na sacerdote judíokana. ");
INSERT INTO guc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Chi Caifáskai anülia, nia maka paala namüin na laülaayuu judíokana sünain maa: “Shia anaka alu'u, saa'in tamüin, ouktüle waneeshia ne'e wayuu waa'u wayakana judíokana wapüshua”. ");
INSERT INTO guc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Otta müshia Simón Pedro, oushikajaashi nüchiirua Jesús nümaa wane'eya. Chi wanee, e'nnaajünüshi nütüma chi laülaashikai napüleerua na sacerdotekana. Je sükajee tia, nikerotinnakalaka nümaa Jesús sulu'umüin nüpaatiase chi sacerdotekai. ");
INSERT INTO guc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Otta müshia Pedro, makatakalaka nia anooipa'a so'ulu'u tü paatiakat. Otta chi nuwala'atakai, nujuittaakalaka nüchikua süpüla naashajaain sümaa tü majayüt aa'inmajüsükat tü so'ukot süpüla shikerotirüinjachin Pedro. Je wanaa sümaa nikerolüin, ");
INSERT INTO guc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","süsakitkalaka nia tü majayütkat: —Aashin piayaain wane chi nikirajüinkai —sümakalaka nümüin Pedro. —Nnojoishi tayain —nümakalaka sümüin. ");
INSERT INTO guc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Je yaa sulu'u tü paatiakat, eejana wane nüchepchiairua chi sacerdotekai namaa wane suwaariase tü a'waajüleekat Maleiwa sha'washawalüin sü'ütpa'a wane siki chuwatsü natüma süpüla aatulajaa. Eejachi Pedro sha'watüin namaa sünain aatulajaa. ");
INSERT INTO guc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Asakinnüshi joolu'u Jesús yaa paülü'ü nütüma Anás chi laülaashikai napüleerua na sacerdotekana nachiki na nikirajüinkana je süchiki tü nikirajapü'ükat anain. ");
INSERT INTO guc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nüsouktakalaka Jesús nümüin: —Ekirajapü'üshi taya eepünaapü'üle nakotchajaain na judíokana napüshua sulu'u tü ekirajüleekalüirua je sulu'u tü a'waajüleekat Maleiwa. Aashajaapü'üshi taya su'upala wayuu wainma, nnojoishi aashajaain taya sujuuna wayuu. ");
INSERT INTO guc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jamakalaka püsakiraka'a taya joolu'u? Shia anaka püsakirüle na wayuu aapajapü'ükana tanüiki. Shiimüin sünain nayain atüjaain saa'u tü tamapü'ükat —nümataalakalaka Jesús nümüin Anás. ");
INSERT INTO guc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Je nümapa Jesús tüü, nüshe'ejaanakalaka nuwalapa'anain nütüma wane nuwaariase chi sacerdotekai sha'watüshikai nü'ütpa'a sünain nümüin emetut nümüin Jesús: —E'rüikaiche pia wayumüin sümaa pünüiki nümüin chi laülaashikai napüleerua na sacerdotekana. ");
INSERT INTO guc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nüsouktakalaka Jesús: —Müleka mojulu'uruleje tanüiki nümüin, anasüje pii'iyatüle shia tamüin. Akaajasa taküjüle nümüin tü shiimüinkat, ¿jamaka'a püshe'etaka'a taya saalii? —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nu'uninnakalaka joo Jesús nütüma Anás nünainmüin Caifás chi wane laülaashikai napüleerua na sacerdotekana. Maakatüjüyülia tü jiikukat nuulia. ");
INSERT INTO guc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wanaa sümaa sha'watüin Simón Pedro yaa anooipa'a sünain aatulajaa, nüsakinnakalaka sütüma wane wayuu: —¿Nnojoishijasa piain wane chi nikirajüinkai? Naattajaakalaka Pedro sünain maa: —Nnojoishi tayain. ");
INSERT INTO guc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Niasa wane nüchepchia chi laülaashikai napüleerua na sacerdotekana, nüpüshi chi wayuu ochotoonokoi ache'e paala nütüma Pedro, nümakalaka nümüin: —Te'rüinsa pia nümaa suupünaa tü wunu'uliakat. ");
INSERT INTO guc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Naattajaakalaka Pedro nüchikua. Shiasa wanaa ma'i sümaa nüsouktüin Pedro, akootole'erajaashi wane kaliina. ");
INSERT INTO guc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nu'uninnakalaka Jesús watta'a maalü natüma na laülaayuu judíokana nipialu'ujee Caifás eemüin tü laülaapiakat eere ni'yataain Pilato chi Romaje'ewaikai sülaülashikai tü mmakat Judea so'u ka'ikat tia. Nayasa na judíokana, nnojoliishii ekerotüin sulu'umüin tü laülaapiakat. Müleka nekerorule, saa'in namüin, na'akamüin na gentilekana, yarütteerü nakuaippa nu'upala Maleiwa je nnojoleena eküin shikiira tü Pascuakat. ");
INSERT INTO guc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nujuittaakalaka Pilato anooipa'amüin süpüla nüsakirüinjanain naya noo'opünaa Jesús: —¿Kasa naainjalaka wayuukai chii jaajüin süpüla süsalainjachin nia tatüma? —nümakalaka Pilato namüin na laülaayuu judíokana. ");
INSERT INTO guc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nasouktakalaka nümüin: —Müleka nnojoireje kaainjaralin nia, nnojoishije waapüin ekii pümüin —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nümakalaka Pilato: —Ju'una jüchikua süpüla jiainjanain kasalajanain atüma naainjala nümüin süka tü jukuaippapü'ükat. Nasouktakalaka na judíokana: —Nnojoliishii e'itaaushin waya judíokana süpüla o'utaa saa'in wayuu —namakalaka nümüin. ");
INSERT INTO guc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Münüsü tüü süpüla keraainjatüin tü nümapü'ükat Jesús soo'opünaa tü nukuaippainjatkat sünain ouktaa.) ");
INSERT INTO guc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nikerotokoloko joo Pilato nüchikua paülü'ümüin sümaa neenaküin Jesús nünainmüin süpüla nüsakirüinjachin nia: —¿Piajasa'aya chi Aluwataashikai saa'u tü wayuu judíokolüirua? —nümakalaka Pilato nümüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nüsouktakalaka Jesús: —¿Püle'eru'ujeejatü tü pümakat tamüin? ¿Shiataapasa ne'e tachiki pümüin sütüma wayuu? ");
INSERT INTO guc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nümakalaka Pilato: —¿Judíojasa joo taya? Aashin nayain aapüin pikii na püpüshikana je na laülaashiikana na'akajee na sacerdotekana. ¿Kasasalajeeshisa pia namüin süpüla naapüin pikii tamüin? ");
INSERT INTO guc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nüsouktakalaka Jesús: —Wane'eya sümüin sukuaippa tü taluwataayakat, nnojotsü müin aka nakuaippa na sülaülashiikana mma. Müleka müleje aka shia, atkaashiije na tamaajanakana taa'ujee suulia tata'ünnüin natüma na laülaayuu judíokana —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Shiimüinjasa'a piain wane aluwataashikai? —nümakalaka Pilato nümüin. Nüsouktakalaka Jesús nümüin: —Shiimüin tü pümakat tachiki sünain tayain aluwataashin. Shia'aya jemeika apüla taya tia. Je antüshi taya sa'akamüin wayuu süpüla tee'iyatüinjatüin tü shiimüinkat sümüin. Chi eekai kachiiruain aa'in tü shiimüinkat, nia aapaka tanüiki —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Eesüjasa'aya süpüla ountünüin tü shiimüinkat? —nümakalaka Pilato nümüin. Je süchikijee naashajaain nümaa Jesús, ojuittüshi Pilato anooipa'amüin nüchikua süpüla naashajaain namaa na judíokana sünain maa namüin: —Nnojotsü tantüin anain wane aainjalaa nünain süpüla süsalainjachin nia tatüma. ");
INSERT INTO guc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Otta saashin jukuaippa jia judíokana so'u tü mi'iraa Pascuakat, ajütünapü'üshi wane püreesashi tatüma. ¿Jücheküin süpüleerua niain tajuittirüin joolu'u jümüin Jesús chi Aluwataashikai jaa'u jia judíokana? —nümakalaka Pilato namüin. ");
INSERT INTO guc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Nnojo, nnojoishi niainjachin. Anashi niale püjütüin wamüin Barrabás —namakalaka emetut. Chi Barrabáskai, ata'ülüüshi saaliijee ni'ipolopü'üin chi sülaülashikai mma. ");
INSERT INTO guc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nüjütünakalaka Jesús nütüma Pilato süpüla ni'yaajünüin sütüma tü surulaatkalüirua nünainru'upünaa wainmatua süka wane jiiku maniirase. ");
INSERT INTO guc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Shi'itaakalaka tü surulaatkalüirua wane kotse keimsesü saa'u nikii Jesús. Na'atakalaka wane ashe'inyüü anasü nünain, jepisiiyaa, maa aka saa'in nüshe'in wane aluwataai saa'u mma. ");
INSERT INTO guc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Narütkajaakalaka naya sümaa neme'erainpalain nia wainmatua sünain maa nümüin: —Pia Aluwataashikai saa'u tü wayuu judíokolüirua —müshii naya nümüin. Je nashe'ejakalaka nia sünain nu'upünaa. ");
INSERT INTO guc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nujuittaakalaka Pilato anooipa'amüin nüchikua sünain nümüin namüin na judíokana: —Anii tojuittirüin joo nia jünainmüin süpüla taapirüin jia sünain nnojolüin tantüin anain wane aainjalaa nünain süpüla süsalainjachin nia tatüma —nümakalaka Pilato namüin. ");
INSERT INTO guc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Je nujuittapa Jesús anooipa'amüin sünain eein tü kotse keimsesükat sünain nikii oo'ulaka tü ashe'inyüü jepisiiyaa nünainjatkat, nümakalaka Pilato namüin na judíokana: —Anii chi wayuukai. ");
INSERT INTO guc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Otta na laülaashiikana na'akajee na sacerdotekana je na nawaariasekana, na'waatakalaka ne'rapa Jesús: —Anashi nüchitinnüle sünain kuruusa süpüla ouktaa. Püchitira pümaala nia —namakalaka. Niasa Pilato, nüsouktakalaka namüin: —Anakaja jiale jiakana achitüin nia. Alu'ujasa tayakai, nnojotsü tantüin anain wane aainjalaa nünain süpüla süsalainjachin nia tatüma —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Masütaajusalii na laülaashii judíokana sünain na'waatüin sünain maa: —Saashin tü pütchi e'itaaushikat namüin na watuushiyuukana, acheküshi o'utinnaa aa'in nia saaliijee “Nüchon Maleiwa taya” nümüin —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Naapapa Pilato tüü, eimolojooleesia ma'i naa'in. ");
INSERT INTO guc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nikerotkoloko joo sulu'umüin tü laülaapiakat süpüla naashajaain nüchikua nümaa Jesús: —¿Jaleje'ewai ma'i pia? —nümakalaka nümüin. Niasa Jesús, ko'uu müshi nuulia. ");
INSERT INTO guc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—¿Jamüshi ko'utaka'a pia toulia? ¿Nnojotsü pütüjaain aa'u sünain laülaain taya süpüla tajütüinjachin pia je süpüla tachitirüinjachin pia sünain kuruusa süpüla ouktaa? —nümakalaka Pilato nümüin. ");
INSERT INTO guc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nüsouktakalaka Jesús ni'ipajee: —Müleka nnojorule kaawain pünüiki nütüma Maleiwa, nnojoishije pia laülaain toulia. Je sükajee tia, chi alana'aleekai sünain kaainjalain, nia chi aapakai tekii pümüin —nümakalaka Jesús. ");
INSERT INTO guc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Je süchikijee tia, o'unüshi Pilato anooipa'amüin nüchikua süpüla naashajaain namaa na judíokana shii'iree nüjütüin Jesús. Otta nayakana, masütaajusalii sünain na'waatüin sünain namüin nümüin: —Müleka püjütüle chi wayuukai, nnojoishija na'aleewain pia César. Süka jamüin, chi wayuu “Aluwataashi taya saa'u wayuu” makai, nia nü'ünüüka César —namakalaka nümüin Pilato. ");
INSERT INTO guc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Shiasa naapapa Pilato tü namakat nümüin, nojoyolookoloko eere naikkalaapü'üin na sülaülashiikana mma süpüla kasalajanainjatüin sümüin wayuu saainjala natüma. Je sünülia tü aikkajüleekat, “Ipakat” münüsü. (Je sünülia süka pütchi hebreo, “Gabata”.) Nüntirakalaka joo Jesús anooipa'amüin. ");
INSERT INTO guc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Je wanaa sümaa tia, kale'ojatü. Che'ojaasü wane ka'i süpülapünaa süka'iya tü eemerawaakat sünain tü mi'iraa Pascua münakat. Nümakalaka joo Pilato namüin na judíokana: —Anii chi Aluwataashikai jaa'u. ");
INSERT INTO guc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Otta müshi'iya na wayuukana, masütaajusalii sümaa nekiisa sünain maa nümüin: —Pi'ikaje'era maala nia yaajee pükacheriraiwan nia sünain kuruusa süpüla ouktaa —namakalaka. —¿Shiimüin sünain jücheküin sünain takacherirüin jümüin chi Aluwataashikai jaa'u? —nümakalaka Pilato namüin. Otta na laülaashiikana na'akajee na sacerdotekana, nasouktakalaka nümüin: —Nnojoishi niain aluwataain waa'u. Nia nümüiwa aluwataaka waa'u César. ");
INSERT INTO guc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Naapünakalaka joo Jesús nütüma Pilato sümüin tü surulaatkalüirua süpüla nükachennüinjachin natüma sünain kuruusa süpüla ouktaa. Süchikijee naapünüin Jesús namüin na surulaatkana, ");
INSERT INTO guc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","o'uninnüshi nia natüma sünain nülü'üjüin tü wunu'u akachennüinjachikat anain nia eemüin wane wutai kanüliasü “Ekiyüükat”. (Je sünülia tü wutaikat süka pütchi hebreo, “Gólgota”.) ");
INSERT INTO guc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Je yala, nükachennakalaka Jesús. Eeshii piamashii wayuu akachennüin wanaa nümaa. Naatawaishii naya sünain wane wunu'u. Je Jesús, akachennüshi pasanain nanain. ");
INSERT INTO guc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Eesü wane pütchi ashajinnüsü nütüma Pilato e'itaanakat shi'ichiru'u tü kuruusa kanainkat Jesús. Müsü mayaa: ANII JESÚS CHI NAZARETJE'EWAIKAI, CHI ALUWATAASHIKAI SAA'U TÜ WAYUU JUDÍOKOLÜIRUA. ");
INSERT INTO guc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aashaje'ennüsü tia sütüma wainma wayuu judío süka pejein sünain Jerusalén tü wutai akachennakat aa'u Jesús, je süka süshajuushin süka apünüinsü anüikii: hebreo, griego, je latín. ");
INSERT INTO guc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Otta na laülaashiikana na'akajee na sacerdotekana, nayoukta amaalü tü nüshajirakat Pilato. Namakalaka nümüin: —Nnojotsü anain tü püshajirakat: “Chi Aluwataashikai saa'u wayuu judío”, pümüin. Anasüje müleka pii'iratüle tü pütchikat: “Chi Aluwataashikai saa'u wayuu judío naashin”, müsüje. ");
INSERT INTO guc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Tü tashajirüitpakat, tashajirüitpa. Nnojoleerü tee'iratüin —nümakalaka Pilato namüin. ");
INSERT INTO guc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Je na surulaatkana süchikijee nakacherüin Jesús sünain tü kuruusakat, naapaain tü nüshe'inkat sümaa nakatajiraain naka na pienchishiikana. Shiaka apütaain tü nüshe'inpalajanakat süka me'itiain shia, akumajuushi süka wane kuluulu waneesia. ");
INSERT INTO guc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aashajiraashii na surulaatkana: —Nnojo wasüküijiraain tü nüshe'inpalajanakat. Shia anaka alu'u müleka washantanajiraale saa'u süpüla watüjaain naa'u jaralin chi makatüinjachin apüla shia —namakalaka. Noo'ulakakalaka shia. Naa'inrüin tüü süpüla shikeraajüinjatüin tü ashajuushikat paala sulu'u tü nüchikimaajatkat Maleiwa sünain maa: “Nakatajiraain tashe'in je nashantanajiraa aa'ulu”. ");
INSERT INTO guc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Je peje sünain tü kuruusakat kachetakat anain Jesús, eejatü tü niikat sha'watüin, oo'ulaka wane nüü'irü, oo'ulaka María nu'wayuuse Cleofas, oo'ulaka María Magdalena. ");
INSERT INTO guc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Niasa Jesús wanaa sümaa ni'rüin tü niikat nümaa chi nikirajüin aishikai ma'i nüpüla sünain sha'watüin nia sü'ütpa'a, nümakalaka sümüin: —Maachee, iraa chi püchonkai. ");
INSERT INTO guc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Otta nümüin chi nikirajüinkai: —Naa tü püikat —nümakalaka. Je süchikijee ka'ikat tia, o'ttüshi sünain jülüjain waneepia naa'in tü niikat Jesús chi nikirajüinkai. ");
INSERT INTO guc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Je Jesús süchikijee tia, sünain nütüjaain aa'u sümaa kettaain süpüshua nütüma tü nuluwataakat anain nia Maleiwa, —Münyaasüshi taya —nümakalaka. Müsü nünüiki süpüla keraainjatüin tü ashajünakat paala sulu'u tü nüchikimaajatkat Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eesü wane iita yaa mmolu'u kalu'ukot wane asüüshi jashü'üsü. Sücholetinnakalaka wane maawüi shi'ichiru'u wane lumia süpüla shi'itaanüinjatüin sünain niimata Jesús. ");
INSERT INTO guc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Shiasa süchikijee nuu'ulaküin shia, —Kettaaitpa tatüma —müshi Jesús sünain nejepülüin nikii je aja'ttüsü naa'in yala'aya. ");
INSERT INTO guc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Je tü ka'i ouktakat o'u Jesús, shia süpülapünaa süka'iya tü eemerawaakat sünain tü Pascuakat. Je na laülaayuu judíokana, süka nnojolüin nacheküin sünain makatajanain na kachetüshiikana saa'u tü kuruusakalüirua so'u sükaliain eemerawaa, nachuntakalaka nümüin Pilato süpüla süshate'ennüinjatüin nasa'a süpüla ouktamaatüinjanain süpüla nashakatinnüin. ");
INSERT INTO guc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nashate'erakalaka na surulaatkana nasa'a na wayuukana piamashii kachetüshiikana na'atalu'u Jesús. ");
INSERT INTO guc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Otta nantapa nünainmüin Jesús, süka ouktatüjülinya nia napüla, nnojotsü nashate'erüin nüsa'a. ");
INSERT INTO guc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Otta müshia wane surulaat, nüsotüin naa'inpünaa Jesús süka wane kachueera kasa e'ichirü. Süparalakalaka yaawala nüsha sümaa sujuittüin wüin sümaa tü nüshakat. ");
INSERT INTO guc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Tatüjaa aa'ulu sünain shiimüin tü alatakat nüka Jesús, süka te'rüin nia sünain ouktaa. Je tashajüin joolu'u tü nüchikikat jümüin süpüla jünoujainjatüin jiakanaya. ");
INSERT INTO guc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tü naa'inrakat na surulaatkana nüka Jesús, alatüsü süpüla keraainjatüin tü ashajuushikat sünain maa: “Nnojoleerü ashate'ennüin niipüse” ");
INSERT INTO guc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","oo'ulaka wane müsü'üya: “Neirakaajeechi amüin chi nasotüinkai”.) ");
INSERT INTO guc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Eeshi wane laülaashi judío kanüliashi José cheje'ewaikai Arimatea yaa sulu'u tü mmakat Judea. Nuunjulajapü'üin sünain niain wane nikirajüin Jesús süka mmolüin nia neema na nuwala'atakana. Nüchuntakalaka joolu'u José nümüin Pilato ni'itaainjachin müliashii sulu'u woowira. Saa'u anain nümüin Pilato tü nüchuntakat apüla, nüntakalaka José sünain alü'üjaa müliashii. ");
INSERT INTO guc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Je nümaa, eejachi Nicodemo chi antakainka paala so'u wane ai nünainmüin Jesús. Nülü'üjain wane wunu'u jemeta eejuulu, wane “mirra” sümaa “áloes”, maa aka pienchi shikii “kilo”, süpüla shi'itaanüin na'aka müliashii. ");
INSERT INTO guc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nashakatirakalaka joo müliashii sünainjee tü kuruusakat. Noko'olokoloko nia süka wane kuluulu kojutsü kanüliasü “lino”. Je tü wunu'ukot jemetakat eejuut, e'itaanüsü sümaa tü kuluutkot. Shia sukuaippaka'aya wayuu judío tia süpüla e'itawaa saamaka. ");
INSERT INTO guc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Je sü'ütpa'a tü wutaikat eejachire nu'utünüin aa'in Jesús, eesü wane apain. Je sulu'u tü apainkat, eesü wane woowira akumajuushi sulu'u wane ipa miyo'u. Jeket akumajuushin. Me'itaajuyülia aamakaa sulu'u. ");
INSERT INTO guc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Saa'u pejein tü woowirakat sünain tü wutaikat, ne'itaamaatakalaka müliashii yaa sulu'u, süka sülü'ülüin ma'i su'ttüin süka'iya tü eemerawaakat natüma na judíokana. ");
INSERT INTO guc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Je süchikijee tü ka'i neemeraakat o'u na judíokana, su'unakalaka María Magdalena eeiwa'aya aikat eemüin tü woowirakat eejachire ni'itaanüin Jesús. Shiasa süntapa chamüin, sünta anainrü süsünne'eruushin tü ipa shirousekat. ");
INSERT INTO guc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Suwataakalaka María eemüin Simón Pedro oo'ulaka wane'eya nikirajüin Jesús aipü'ükai ma'i nüpüla sünain sümüin namüin: —Ayu'nnüshi chi Senyotkai sulu'ujee tü woowirakat je nnojotsü watüjaain aa'u jalakualin nia atümaa —sümakalaka María namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nuwataakalaka Pedro nümaa chi nuwala'atakai sünainmüin tü woowirakat. ");
INSERT INTO guc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nüntakalaka chi wane nüpüleerua sünainmüin tü woowirakat süka kawatiraain nia nuulia. ");
INSERT INTO guc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Je nüntaiwa'aya, nünalaakalaka sulu'u tü woowirakat. Ni'rakalaka tü kuluutkot jachii müin. Otta nnojoishi ekerotüin nia. ");
INSERT INTO guc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nüntakalaka joo Pedro nüchiiruajee sünain nikerotomaatüin sünain ni'rüin tü kuluutkat jachitüin, tü oko'ojünakat aka müliashii, ");
INSERT INTO guc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","je tü saalajakat nikii sümüiwa'asü sünain apaa'awajaaushin shia. ");
INSERT INTO guc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nikerotokoloko chi nuwala'atakai nüchiiruajee, chi antüshikai palajana sünainmüin tü woowirakat. Ni'rakalaka joo nüchikanain Jesús. Nünoujakalaka sünain süso'iraain naa'in. ");
INSERT INTO guc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Otta nnojoliiyülia nayaawatüin saa'u tü ashajünakat paala sulu'u tü nüchikimaajatkat Maleiwa sünain süso'iraainjatüin naa'in. ");
INSERT INTO guc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","O'unüshii joo na nikirajüinkana chamüin nepialu'umüin nachikua, ");
INSERT INTO guc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","otta María Magdalena, makatüsü anooipa'a sü'ütpa'a tü woowirakat. Sha'watüsü shia yala sünain shi'yalajüin. Sünalaakalaka joo sulu'u tü woowirakat ");
INSERT INTO guc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","sümaa shi'rüin piamashii aapiee nüma'anaje'ewalii Maleiwa. Kasuutannuu nashe'in. Joyotüshi wane eejatüle nikii je wane eejatüle nuu'ui müliashii. ");
INSERT INTO guc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nasakirakalaka shia: —Nii waa'iraa, ¿jamüsü pia pi'yalajaka'a? —namakalaka sümüin. —Ayu'nnüshi chi Tasenyotsekai, je nnojotsü tatüjaain aa'u jalamüinre nia alü'üjünüin —sümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Shiirakaakalaka joo María süchiiruajee sümaa shi'rüin Jesús yaa sha'watüin. Akaisa nnojolin shiyaawatüin nia. ");
INSERT INTO guc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nümakalaka Jesús sümüin: —Nii waa'iraa, ¿jamüsü pia pi'yalajaka'a? ¿Jarai chi pusukujaaka achiki? —nümakalaka Jesús sümüin. Wayuuyaa a'yataai ne'e sulu'u tü apainkat saa'inru'u María chi saashajaakai amaa. Sümakalaka nümüin: —Müleka piale chi alü'üjakai chi Tasenyotsekai yaajee yaa, anasüje püküjale tamüin jalamüinre nia pütüma tasaajaiwa nia nüchikua —sümakalaka María nümüin. ");
INSERT INTO guc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—María —nümakalaka Jesús sümüin. Sujununajaakalaka nünainmüin Jesús sümaa sümüin nümüin: —Raboni. (Je tü pütchikat süka pütchi hebreo, “Ekirajüikalee” malu'ut.) ");
INSERT INTO guc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nümakalaka Jesús sümüin: —Nnojo pajapulu'ujain taya süka nnojoliyüliain tale'ejüin nüma'anamüin chi Tashikai. Shia anaka alu'u müleka pu'unüle eemüin na tawalayuukana süpüla püküjainjatüin tanüiki namüin sünain maa: “Ale'ejeechi taya nüma'anamüin chi Tashikai, chi Jüshikai wanaa tamaa, nüma'anamüin chi Tamaleiwasekai, chi Jümaleiwasekai wanaa tamaa”. ");
INSERT INTO guc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Su'unakalaka María Magdalena eemüin na nikirajüinkana Jesús sünain süküjaain tü shi'rakat: —Te'rüichipa chi Senyotkai —sümakalaka namüin. Je süküjain namüin tü nümüitpakat Jesús sümüin. ");
INSERT INTO guc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Je mapa aipa'a so'u tü ka'i naashajaakat o'u Jesús sümaa María Magdalena, eeshii na nikirajüinkana Jesús jutkatüin sulu'u wane miichi. Türankalu'usü so'u tü miichikat süka mmolüin naya neema na laülaayuu judíokana. Ee'iyata'alaa müshi Jesús yaa pasanain nanain. —Kasataalejese anain jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Süchikijee nümüin tüü, nii'iyatakalaka namüin tü nülio'u najappünaajatkat je tü nüchiro'upünaajatkat. Talatashaanasü ma'i naa'in na nikirajüinkana süka ne'rüin joo chi Senyotkai. ");
INSERT INTO guc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","—Kasataalejese anain jia —nümakalaka namüin nüchikua. —Maa aka tayakai ajütünüin sa'akamüin wayuu nütüma chi Tashikai, akaajaa jiakana, tajütüin joolu'u jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nuju'ulakalaka naya sünain nümüin namüin: —Anasü müleka jümaale joolu'u chi Naa'inkai Maleiwa. ");
INSERT INTO guc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Müleka jülatirüle saainjala wane wayuu, alatinneerü shia nütüma chi Tashikai. Akaajasa müleka nnojorule jülatirüin shia, nnojoleerü alatinnüin —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Otta müshia Tomás, wane na nikirajüin polookana piammüin, chi Senkeyuukai anülia, nnojoishi eejachin na'aka na nüpüshikana wanaa sümaa nii'iyataain Jesús na'akamüin. ");
INSERT INTO guc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aküjünüsü nümüin natüma: —We'rüichipa chi Senyotkai —müshii naya nümüin. Otta nünüiki Tomás ne'ipajee, müsü mayaa: —Müleka nnojorule te'rüin süchikanain tü külaawakat sünain najapü sümaa te'itaain tajapü sünain tü nülio'ukot je sünain tü nülio'u yaakat sümülatu'u nüchira, nnojoleerü tanoujain sümaa katüin no'u —nümakalaka Tomás namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Je süchikijee maa aka wane semaana, eeshii na nikirajüinkana Jesús nachikua sulu'u tü miichikat sümaa eein Tomás namaa. Mayaainje türankalu'uin so'u tü miichikat, ee'iyata'alaa müshi Jesús yaa pasanain nanain. —Kasataalejese anain jia —nümakalaka namüin. ");
INSERT INTO guc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nümakalaka nümüin Tomás: —Piirakaa sümüin süchikanain tü külaawakat yaa sünain tajapü, pi'itaa pajapü sünain talio'u. Je piyurula pütüna yaa sünain tü talio'u sümülatu'ukat tachira pütüjaaiwa saa'u. Puu'ulaa suulia manoujüinyee, pünouja pümata tanain —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nüsouktakalaka Tomás nümüin: —Shiima'inya sünain piain piakai chi Tasenyotsekai, chi Tamaleiwasekai. ");
INSERT INTO guc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nümakalaka Jesús nümüin: —Anoujashi pia joolu'u süka pi'rüichipain taya. Otta na wayuu anoujeenakana tanain ja'itashi nnojolin ne'rüin taya, talatashaateena ma'i naya. ");
INSERT INTO guc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Wainma kasa anasü naa'inrapü'ükat Jesús no'upala na nikirajüinkana, tü kasa nütüjakat apüleerua Maleiwa nümüiwa. Otta nnojotsü tashajüin süpüshua sulu'u tü karalouktakat. ");
INSERT INTO guc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Otta müsia tü tashajakat jümüin, tashajüin süpüla jünoujainjanain nünain Jesús sünain niain chi Cristo Nüneekajalakai Maleiwa, sünain niain chi Nüchonkai Maleiwa. Je müleka jünoujüle nünain, ee'iranajaweerü jaa'in nütüma süpüla ayatüinjanain jia nümaa Maleiwa waneepia süpüla ka'ikat süpüshua. ");
INSERT INTO guc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Je sülatapa kojuya ka'i süchikijee naashajaain Jesús nümaa Tomás, ee'iyataashi nüchikua na'akamüin no'utku na nikirajüinkana sotpa'a tü palaa kanüliakat Galilea, tü Tiberiaskat anüliaya. ");
INSERT INTO guc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Eejana Simón Pedro, Tomás chi Senkeyuukai, Natanael cheje'ewaikai Caná sulu'u Galilea, na nüchooinkana Zebedeo, oo'ulaka piamashii noo'omüin. ");
INSERT INTO guc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Anakaja tolojüle jime —nümakalaka Simón Pedro namüin na nüpüshikana. —Anashii pümaale waya —namakalaka nümüin. No'otookoloko sulu'u wane anua süpüla olojoo jime. Otta nalatirüin aikat süpüshua sünain masirüin naya. ");
INSERT INTO guc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Shiasa nale'ejapa watta'a maalü, eeshi Jesús sha'watüin sotpa'a tü palaakat. Otta na nikirajüinkana, nnojoishi natüjaain aa'u sünain niain Jesús. ");
INSERT INTO guc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nu'waatakalaka Jesús namüin: —Tatünajutumuyuwaa, ¿kasirüyaashiije jia? —nümakalaka namüin. —Nnojo —namakalaka. ");
INSERT INTO guc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Müleka jujutüle tü jukusüinkat wopujeeru'u sünain tü anuakat, anteena jia sünain jime —nümakalaka Jesús namüin. Shiasa najutakalaka tü nakusüinkat shirokumüin tü palaakat, kasitkalaka naya jime watta ma'i saalin. Isasü nachiki ayu'laa süka jawatüin shia noulia. ");
INSERT INTO guc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Je chi nikirajüin aishikai ma'i nüpüla Jesús, nümakalaka nümüin Pedro: —Nia'ayaasa chi Senyotkai. Je Pedro, naapapa nünüiki sünain nümüin: “Nia'ayaasa chi Senyotkai”, na'atakalaka nüshe'in süchikua nünain. Numuttakalaka shirokumüin tü palaakat süpüla o'unaa eemüin Jesús. ");
INSERT INTO guc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","No'unakalaka na nüpüshikana sulu'u tü anuakat sotpa'amüin tü palaakat. Najaralijiraain tü nakusüin wotokot jime, süka pejein tü anuakat sünain tü mmakat, maa aka poloo shikii “metro”. ");
INSERT INTO guc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nashakatapa sulu'ujee tü anuakat, eesü napüla wane siki asijüna aa'ulu jime otta pan sü'ütpa'a. ");
INSERT INTO guc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Iche'era jumaala süpüshi tü jüsitkat —nümakalaka Jesús namüin. ");
INSERT INTO guc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","No'otookalaka Simón Pedro nüchikua sulu'u tü anuakat süpüla najaralijaain tü nakusüinkat sotpa'amüin tü palaakat. Mayaainje wainmain jime mülo'uyuu sulu'u tü nakusüinkat, nnojotsü asüküijaain sütüma. Eejatü 153 jime sulu'u. ");
INSERT INTO guc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Jalaina jikaaiwa —nümakalaka Jesús namüin. Je na nikirajüinkana, mayaainje nasakireein sümaa jaralin nia, nnojoishii nasakirüin süka japülin naya sheema asakiraa. “Nia cheje Jesús eera”, müsü naa'in nale'eru'u. ");
INSERT INTO guc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nürütkaakalaka Jesús sünainmüin tü sikikat. Naapaakalaka wane pan sümaa naapüin shia namüin na nikirajüinkana. Akaata'aya tü jimekat nütümaya. ");
INSERT INTO guc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Je süka tüü, apünüintuaichi ee'iyataain joo Jesús namüin na nikirajüinkana süchikijee süso'iraain naa'in. ");
INSERT INTO guc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Süchikijee nekaain, aashajaashi Jesús nümaa Simón Pedro: —Simón, nüchonkai Jonás, ¿alatüsü taalin püpüla suulia taalin napüla na puwala'atakana? —nümakalaka Jesús nümüin. —Senyotkalee, pütüjaa aa'ut sümaa alin pia tapüla —nümakalaka Pedro. —Anakaja müleka pikirajüle tü anoujasükalüirua tanain —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nümakalaka Jesús nüchikua: —Simón, nüchonkai Jonás, ¿shiimüin sünain alin taya püpüla? Nümakalaka Pedro: —Senyotkalee, shiima'inya pütüjaa aa'ulu sümaa alin pia tapüla. Nümakalaka Jesús nümüin: —Anakaja müleka paa'inmajüle tü anoujasükalüirua tanain. ");
INSERT INTO guc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Apünüintuaichi joolu'u nüsakirüin Jesús: —Simónwaa, nüchonkai Jonás, ¿aishi taya püpüla? —nümakalaka nümüin. Mojukalaka ma'i naa'in Pedro süka “¿Aishi taya püpüla?” nümüin apünüintua nümüin. Nüsouktakalaka Pedro: —Senyotkalee, pütüjaa aa'ulu kasakat süpüshua. Pütüjaa aa'uchi alin pia tapüla —nümakalaka Pedro nümüin Jesús. —Anakaja müleka pikirajüle tü anoujasükalüirua tanain —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Naashajaakalaka Jesús nümaa Pedro nüchikua: —Shiimüin tü tamakat pümüin: Jintüliiwa'aya pia, a'anaapü'üshi pia süpüla o'unaa eemüinre pu'uneein. Otta laülaapa pia, piyuruleerü pütüna süpüla sa'atünajatüin pünain püshe'in. Je e'ikajaaneechi pia atümaa eemüinre nnojolüin pücheküin —nümakalaka Jesús nümüin. ");
INSERT INTO guc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Müsü nünüiki Jesús nümüin süpüla naapirüinjachin nia süchiki jamüinjatüin nukuaippa sünain ouktaa so'uweena wane ka'i je süchiki nu'waajünüinjachin chi Maleiwakai sütüma tü e'rajüsükalüirua nükua Pedro wanaa sümaa ouktüin. Nümakalaka joolu'u Jesús nümüin: —Ja'itairü tü alateetkat püka, anakaja ichere pia tanain waneepia. ");
INSERT INTO guc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Niirakaakalaka Pedro yaa nachiiruajee nümüin chi nikirajüinkai Jesús, chi aishikai ma'i nüpüla. (Nia chi joyotokai paala nü'ütpa'a Jesús sünain tü ekawaakat, chi “Senyotkalee, ¿jarai chi aapüinjachika pikii?” makai nümüin Jesús.) ");
INSERT INTO guc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nümakalaka Pedro nümüin Jesús: —Senyotkalee, ¿jamataaleerü nukuaippa chi wachiiruajeekai? ");
INSERT INTO guc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nüsouktakalaka Jesús nümüin Pedro: —Müleka tacheküleje katüin no'u süpürale'eya tale'ejapa, nnojotsü kasajatüinjatüin pümüin. Shia anaka alu'u müleka ichere pia tanain waneepia —nümakalaka. ");
INSERT INTO guc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sükajee tia pütchikat, aashajaajiraashii na anoujashiikana nüchiki chi nikirajüinkai sünain nnojoleechin ni'rüin ouktaa naashin. Otta nnojotsü malu'ulüin tü nümakat Jesús sünain nnojolin ouktajachin nia. Tü nümakat, müsü ne'e: “Müleka tacheküleje katüin no'u süpürale'eya tale'ejapa, nnojotsü kasajatüinjatüin pümüin”. ");
INSERT INTO guc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tayakai, Juankai anülia, taya'aya chi nikirajüinkai Jesús. Taküjain nüchiki jümüin sünain shiimüin ma'i tü alatakat. Süka eepü'üin taya nümaa, jütüjaa aa'ut sünain shiimüin. Je joolu'u tashajüitpa joo shia jümüin. ");
INSERT INTO guc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Je eesü wane'eya kasairua naa'inrapü'üin Jesús. Müleka tashajüleje shia süpüshua'ale, wotüsüje tü mmakat sütüma tü karalouktakat.");
INSERT INTO guc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sulu'u tü palajatkat karaloukta tashajüin pümüin, Teófilo, taküja achiküt pümüin süpüshua'a tü kasa nu'ttakat anain Jesús sünain naa'inrüin otta nikirajaa anain chejeechikü su'ttianainjee, ");
INSERT INTO guc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sünainmüinre'eya tü ka'i niyalere'ennakat o'u sirumalu'umüin. Nümaichiki, süpüla nu'unüin sirumalu'umüin, aashajaashi nükajee chi Naa'inkai Maleiwa soo'opünaa tü kasa anakat süpüla naa'inrüinjat