﻿USE sofia;
DROP TABLE IF EXISTS sofia.gubBl_vpl;
CREATE TABLE gubBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gubBl_vpl WRITE;
INSERT INTO gubBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Izypy mehe Tupàn uzapo ywak a'e, uzapo ywy a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nuzapo kwaw Tupàn ywy ikatuahy ma'e romo a'e 'ar rehe a'e rihi. Naheta kwaw wikuwe ma'e a'e 'ar mehe ywy rehe a'e rihi. Xo yryhu ohoete ma'e zo heta. Ipytunahy haw upyk yryhu a'e. Tupàn Hekwe wiko 'y 'aromo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na'e uze'eg Tupàn. — Tuwe heta tatainy, i'i. A'e 'ar mehe we tatainy uzypyrog weta pà. ");
INSERT INTO gubBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Wexak Tupàn tatainy ikatuahy haw. Umunyryk kar ipytunahy haw imono izuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tupàn omono her tatainy pe. — 'Ar, i'i izupe. Omono her pytunaw pe no. — Pyhaw, i'i izupe. Upaw pytun oho a'e. Iku'em kury. — 'Ar ipy, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Na'e Tupàn i'i uzeupe. — Amuza'ak putar 'y ihe nehe kury, mokoz pehegwer romo iapo pà ihe nehe kury, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Uzeapo ma'e ize'eg rupi katete. Tupàn uzapo 'y imuza'akaw a'e. Amo ipehegwer upyta iwy pe a'e. Amo ipehegwer inugwer upyta i'aromo a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Na'e Tupàn omono her a'e 'y imuza'akaw pe a'e. — Ywak, i'i izupe. Upaw pytun oho no. Iku'em kury. — Mokoz haw 'ar, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Uze'eg wi Tupàn a'e kury. — Tuwe 'y ywak iwy pe har uzemono'og pitài 'y romo uzeapo pà a'e nehe. Nezewe mehe ywy uxinig ma'e uzekwa kar putar a'e nehe no, i'i. Uzeapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tupàn omono her ywy uxinig ma'e pe kury. — Ywy, i'i izupe. Omono her 'y uzemono'ono'og ma'e kwer pe no. — Yryhu, i'i izupe. Tupàn wexak wemiapo kwer ikatuahy haw paw rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Na'e Tupàn uze'eg uzeupe. — Tuwe ywy umuezuz kar ma'e tetea'u nehe. Tuwe hezuz ma'eà'yz hereko har paw rupi a'e wà nehe. Tuwe hezuz i'a ma'e paw rupi a'e wà nehe no, i'i. Uzeapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ywy umuezuz kar ma'e tetea'u a'e: ma'eà'yz hereko har paw rupi katete, ma'e'a hereko har tetea'u no. Na'e Tupàn wexak uzeapo ma'e kwer ikatu haw. ");
INSERT INTO gubBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Upaw pytun oho. Iku'em kury. — Na'iruz haw 'ar, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Na'e Tupàn uze'eg wi kury. — Tuwe heta tatainy ywak rehe a'e wà nehe. Nezewe mehe 'ar uzawy putar ipytunaw nehe. Nezewe mehe teko ukwaw putar agwer ma'e ihemaw wà nehe: 'ar, kwarahy, àmàkyhaw, huwixàgaw, haku haw, mynykawhu, mai'u hawhu. ");
INSERT INTO gubBl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","A'e tatainy uhyape katu putar ywak rehe ywy hexak kar pà a'e wà nehe, i'i uzeupe. Uzeapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tupàn uzapo mokoz tatainy uhua'u ma'e a'e wà. Kwarahy uhua'u wera'u zahy wi a'e. Tupàn umuigo kar kwarahy 'ar heruze'egar romo a'e. Tupàn umuigo kar zahy pytun heruze'egar romo a'e no. Uzapo zahytata a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tupàn omono a'e tatainy ywak rehe ywy rehe wamuhyape katu kar pà a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Umuigo kar a'e tatainy 'ar izar romo wà, ipytunaw izar romo wà no. Nezewe umunyryk kar tatainy ipytunuhu wi a'e. Na'e Tupàn wexak wemiapo kwer ikatuahy haw a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Upaw pytun oho. Iku'em kury. — 4 haw 'ar, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Na'e uze'eg wi Tupàn. — Tuwe 'y tynehem wikuwe ma'e 'y pe har pupe a'e nehe. Tuwe heta wiràmiri ywak rehe uwewe ma'e ywy rehe a'e wà nehe no, i'i. ");
INSERT INTO gubBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nezewe Tupàn uzapo wikuwe ma'e yryhu pe har uhua'u ma'e a'e wà. Uzapo wikuwe ma'e hexakaw paw hereko har a'e wà: 'y pupe wiko ma'e tetea'u wà, wiràmiri wà no. Tupàn wexak wemiapo kwer wakatuahy haw. ");
INSERT INTO gubBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Na'e omono uze'egatu wikuwe ma'e yryhu pupe har wanehe a'e kury. Uze'eg nezewe wanupe. — Tuwe peneta tetea'u nehe. Pemynehem yryhu nehe, i'i wanupe. Uze'eg wiràmiri wanupe no. — Tuwe peneta tetea'u ywy rehe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Upaw pytun oho. Iku'em kury. — 5 haw 'ar, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Na'e Tupàn uze'eg wi a'e kury. — Tuwe ywy umuigo kar wikuwe ma'e hexakaw paw hereko har a'e wà nehe: ma'ea'yr tàpuznaw pe wiko ma'e wà, miar ka'a pe har wà, ma'e wie rehe wata ma'e wà. Tuwe wana'yr nuzawy kwaw u a'e wà nehe. Tuwe nuzawy kwaw uhy wà nehe. Uzeapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tupàn uzapo ma'ea'yr pitàitàigatu a'e wà. Pitàitàigatu nuzawy kwaw u wà. Nuzawy kwaw uhy wà: ma'ea'yr tàpuznaw pe wiko ma'e wà, miar ka'a pe har wà, ma'e wie rehe wata ma'e wà. Tupàn wexak wemiapo kwer ikatu haw. ");
INSERT INTO gubBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Na'e uze'eg wi kury. — Xiapo putar teko zane wà nehe kury. Wiko putar zanezàwe wà nehe, i'i Tupàn uzeupe. — Wanexakaw nuzawy kwaw zanerexakaw wà nehe, i'i uzeupe. — Wiko putar wikuwe ma'e paw wazar romo a'e wà nehe: ipira wazar romo wà, wiràmiri wazar romo wà, ma'ea'yr tàpuznaw pe wiko ma'e wazar romo wà, miar ka'a pe har wazar romo wà, ma'e wie rehe wata ma'e wazar romo wà, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tupàn uzapo teko wikuwe ma'e nezewe a'e wà. Umuigo kar uzezàwe nugar romo wà: Uzapo awa. Uzapo kuzà no. ");
INSERT INTO gubBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Omono uze'egatu wanehe wanupe uze'eg pà. — Tuwe heta tetea'u pena'yr wà nehe. Tuwe pena'yr uhàuhàz ywy nànàgatu wà nehe. Tuwe wiko ywy izar romo wà nehe. Tuwe wiko wikuwe ma'e paw wazar romo wà nehe: ipira yryhu pupe har wazar romo wà, wiràmiri ywy 'aromo uwewe ma'e wazar romo wà, ma'e wie rehe wata ma'e wazar romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Amono putar ma'e hezuz ma'e ma'eà'yz hereko har peme upaw rupi katete ihe nehe, penemi'u ràm romo ihe nehe. Heta tetea'u putar ma'ywa 'yw peme nehe no. Amono putar i'a kwer peme penemi'u ràm romo upaw rupi katete nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Amono putar ka'api'i ma'ea'yr wanupe wanemi'u ràm romo ihe nehe. Amono putar ka'a wanupe wanemi'u ràm romo ihe nehe no: miar hehaite ma'e upaw rupi katete wà, wiràmiri wà, ma'e wie rehe wata ma'e upaw rupi wà, i'i wanupe. Uzeapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tupàn wexak wemiapo kwer ikatuahy haw upaw rupi a'e. Upaw ipytunaw. Iku'em kury. — 6 haw 'ar, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nezewe Tupàn umumaw iapo haw a'e kury: ywak, ywy, ywak rehe har wà, ywy rehe har wà. ");
INSERT INTO gubBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","7 haw 'ar mehe Tupàn umumaw ma'e iapo haw upaw rupi katete. Upytu'u uma'ereko re a'e ma'e iapo re. ");
INSERT INTO gubBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Na'e omono uze'egatu 7 haw 'ar rehe kury. Omonokatu a'e 'ar uzeupe ikatu ma'e romo, ta'e upytu'u a'e 'ar mehe ma'e paw iapo re xe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nezewe Tupàn uzapo ywak. Nezewe uzapo ywy. ");
INSERT INTO gubBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Tupàn ywak iapo mehe, ywy iapo mehe, naheta pixik kwaw ni ka'api'i ni ma'e hezuz ma'e a'e 'ar rehe rihi, ta'e Tupàn Tuweharupi Wiko Ma'e a'e xe, numugyr kar kwaw àmàn a'e 'ar mehe a'e rihi xe. Naheta kwaw teko ko pe uma'ereko ma'e ywy rehe a'e wà rihi. ");
INSERT INTO gubBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ywy wi uhem typyàkwenahy ma'e oho uwyryk pà ywy imuàkym pà. ");
INSERT INTO gubBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Na'e Tupàn umuapu'a ywy ku'i kwer awa romo iapo pà a'e kury. Nuikuwe kwaw awa a'e rihi. Upy Tupàn awa iapygwar rupi ywytu purumuigo kar ma'e imono pà izupe kury. Nezewe mehe wiko wikuwe ma'e romo a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na'e Tupàn Tuweharupi Wiko Ma'e uzapo ma'etymaw a'e pe kury, En ywy her ma'e rehe kury, ywy kwarahy ihemaw kutyr har rehe kury. Omono wemiapo kwer awa a'e ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Na'e Tupàn Tuweharupi Wiko Ma'e umutua'u kar ma'e'yw puràg eteahy ma'e tetea'u paw rupi katu a'e pe kury. I'a katu a'e pe. I'a kwer ikatuahy i'u mehe. Heta amo ma'e'yw purumuigo kar ma'e a'e pe. Amo ae ma'ywa 'yw heta a'e pe no. Aze amo u'u i'a kwer nehe, ukwaw putar ma'e nehe: ikatu ma'e, ikatu 'ym ma'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","En ywy wi uwyryk amo 'y a'e, a'e ma'etymaw imuàkym pà a'e. A'e wi uhem mehe a'e yrykaw uzemuza'aza'ak 4 yrykawhu romo. ");
INSERT INTO gubBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","'Y ipy Pizom her romo a'e. Uwyryk Awira ywy izywyr. Heta ita hekuzar katu ma'e or her ma'e a'e ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Or a'e ywy rehe har ikatuahy a'e. Naheta kwaw ywy a'e or inuromo. Heta kàpuhàg zàwenugar a'e pe no. Naheta tetea'u kwaw a'e kàpuhàg. Zawaiw katu agwer kàpuhàg hexakaw. Heta amo ae ita hekuzar katu ma'e a'e pe no. ");
INSERT INTO gubBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Yrykaw mokoz haw a'e, Ziom her romo a'e. Uwyryk oho Kuxi ywy nànàn. ");
INSERT INTO gubBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yrykaw na'iruz haw a'e, Xikire her romo a'e. Uwyryk Axir ywy izywyr kwarahy heixe haw kutyr. Yrykaw zeirugatu haw a'e, Ewparat her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Na'e Tupàn umuigo kar awa ma'etymaw En her ma'e rehe a'e kury. — Ezekaiw katu hehe nehe, i'i izupe. — Ezapo ma'etymaw xe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Uze'eg Tupàn Tuweharupi Wiko Ma'e awa pe, wemiapo kar imume'u pà izupe. — Erepuner ma'e'yw i'a kwer paw i'u haw rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","— Xo pitài ma'e'yw i'a kwer zo nere'u kwaw nehe. E'u zo a'e ma'e'a kwer nehe, i'i izupe. A'e ma'e'a ukwaw kar ikatu ma'e purupe a'e, ukwaw kar ikatu 'ym ma'e purupe a'e no, i'i izupe. — Aze ere'u nehe, nereruzar kwaw heze'eg nehe. Aze nereruzar kwaw heze'eg nehe, a'e 'ar mehe we eremàno putar azeharomoete nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg kury. — Na'ikatu kwaw awa a'e zutyka'i heko haw, i'i. — Azapo putar ipytywàgatu har izupe nehe. Wiko putar ipehegwer zàwenugar romo izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tupàn ywy iapo pawire kury, uzapo miar hehaite ma'e upaw rupi wà, wiràmiri paw wà no. Weraha wemiapo kwer a'e pe awa pe upaw rupi wà. — Emono waner wanupe upaw rupi nehe, i'i izupe. Omono awa waner wanupe upaw rupi. A'e waner imono pyrer wà, wiko waner azeharomoete har romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Omono her wiràmiri wanupe upaw rupi. Omono her ma'ea'yr tàpuznaw pe har wanupe, miar hehaite ma'e ka'a pe har wanupe no. Naheta kwaw hemireko awa pe a'e rihi. Naheta kwaw ipehegwer zàwenugar izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Na'e Tupàn umugerete kar a'e awa. Iker mehe o'ok iàrukàgwer izuwi. Umuzeruwyk i'ok awer no. ");
INSERT INTO gubBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na'e Tupàn uma'ema'e a'e awa iàrukàgwer a'e, kuzà romo iapo pà a'e. Weraha awa pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na'e awa i'i uzeupe, Ikatuahy tuwe Tupàn hemiapo kwer ihewe kury. Ko kuzà a'e, to'o hero'o wi i'ok pyrer romo hekon a'e, i'i uzeupe. Kuzà, a'e putar izupe nehe, ta'e Tupàn o'ok awa wi a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","A'e rupi ko 'ar rehe awa wezar u a'e wà, wezar uhy a'e wà no, uzemono'og pà wemireko rehe we a'e wà. Pitài teko zàwenugar romo wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Awa a'e, hemireko a'e no, na'ima'e kwaw wà. Ni kamir ni topoz numunehew kwaw wà. Nezewe rehe we na'imaranugar kwaw uzewi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Uzapo Tupàn moz a'e, ma'ekwaw katu har romo a'e. Ukwaw wera'u ma'e, amogwer miar wanuwi. Upuranu wà kuzà rehe. — Azeharomoete ru'u Tupàn i'i peme a'e, — Pe'u zo ma'e'yw i'a kwer ma'etymaw pe har nehe, ni pitài zo zepe nape'u kwaw nehe, i'i ru'u peme a'e, i'i mua'u moz kuzà pe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","— Nan, i'i kuzà izupe. — Urupuner wyzài ma'e'yw i'a kwer i'u haw rehe ure 'y, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","— Xo pe ma'e'yw tymaw myter pe har i'a kwer zo nape'u kwaw nehe, i'i Tupàn urewe a'e ma, i'i kuzà moz pe. — Aze pe'u nehe, aze pepokok hehe nehe, pemàno putar nehe, i'i urewe, i'i moz pe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","— Kwa, napemàno pixik kwaw nehe, i'i mua'u moz izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","— Tupàn uze'eg nezewe a'e, ta'e ukwaw ko ma'e a'e xe. Aze pe'u 'àg ma'e'yw i'a kwer nehe, penehazawok putar nehe, peiko putar Tupàn zàwegatu nehe. Aze amo ma'e ikatu nehe, pekwaw putar ikatu haw nehe. Aze amo ma'e na'ikatu kwaw nehe, pekwaw putar ikatu 'ymaw nehe no, i'i mua'u izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kuzà ume'e a'e ma'e'yw rehe kury. Ipuràg eteahy izupe. — I'a kwer ikatuahy i'u mehe aipo ma, i'i uzeupe. — Aze mo akwaw katu ma'e, ikatu mo, i'i. Na'e opo'o i'a kwer imuwà i'u pà kury. Weraha amo umen pe no. U'u imen a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","A'e 'ar mehe we hehazawokaw zàwenugar uzeapo wanupe kury. A'e rupi — Zaiko ima'e 'ym ma'e romo zane, i'i uzeupe wà. Na'e upyhyk amo ma'e'yw pi her ma'e huwer a'e wà. Umuwywyk wopoz romo iapo pà uzeupe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","A'e 'ar mehe we karuk mehe ywytu purumurywete kar ma'e ihem mehe awa a'e, hemireko a'e no, wenu Tupàn Tuweharupi Wiko Ma'e ize'eg mehe a'e wà kury. Ta'e ukwaw oho iko ma'etymaw myteromo a'e xe. Na'e uzeàmim ma'e'yw myter pe izuwi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Na'e Tupàn Tuweharupi Wiko Ma'e wenoz awa imuwà kury, hehe upuranu pà kury. — Ma'e pe ereiko ty, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Awa uwazar ize'eg izupe. — Aenu neze'eg kwez ihe, ma'etymaw myteromo nekwaw mehe ihe. Akyze kwez newi, ta'e nahema'e kwaw xe. A'e rupi azeàmim kwez newi, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A'e rupi Tupàn upuranu hehe. — Mo ukwaw kar nema'e heta 'ymaw newe a'e, i'i izupe, hehe upuranu pà. — E'u zo a'e ma'ywa nehe, a'e peme ihe. — Aipo ere'u ra'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","— Kuzà herehe we har ihewe neremimurer a'e, umur a'e ma'ywa ihewe i'u kar pà a'e. A'e rupi a'u ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Na'e Tupàn upuranu kuzà rehe kury, — Màràzàwe tuwe erezapo nezewe haw, i'i izupe. — Moz hemu'em ihewe, a'e rupi a'u ma'ywa, i'i Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Na'e Tupàn uze'eg moz pe kury. — Azepyk putar nerehe ihe nehe, ta'e erezapo kar heremiapo putar haw 'ym kuzà pe ne xe, i'i izupe. — Nazepyk kwaw amogwer miar wanehe nezewe nehe, xo nerehe zo amono putar heze'egaiw nehe, i'i moz pe. — Ko 'ar henataromo ereata putar ywy rehe nehe, nerie rehe nehe. Ere'u putar ywy ku'i kwer nehe no. Tuweharupi ereata iko nezewe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","— Urumuigo kar putar a'e kuzà iàmàtyry'ymar romo ihe nehe, amuigo kar putar a'e kuzà neàmàtyry'ymar romo ihe nehe no. Nezuapyapyr a'e wà nehe, wiko putar izuapyapyr waàmàtyry'ymar romo a'e wà nehe. Izuapyapyr wiko putar nezuapyapyr waàmàtyry'ymar romo a'e wà nehe no. Pitài izuapyr ukamik putar neàkàg newi nehe. Ne erexi'u putar izuapyr ipyakaza rehe ne nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Na'e Tupàn uze'eg kuzà pe. — Nememyr wazexak kar 'ym mehe hahy wera'u putar newe nehe, i'i izupe. Uhua'u putar hahy haw newe izexak kar mehe nehe no. Nezewe rehe we neho wer putar nemen ipuhe nehe. Nemen wiko putar nereruze'egar romo a'e nehe. Wiko putar nezar romo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Na'e Tupàn uze'eg awa pe kury. — Neremireko u'u kar a'e ma'e 'a kwer newe a'e. — E'u zo a'e ma'ywa 'yw i'a kwer nehe, a'e newe. Nezewe rehe we ere'u. Nereruzar kwaw heze'eg, a'e rupi amono putar heze'egaiw ywy rehe ihe nehe. Ywy rehe nereko mehe erema'ereko tetea'u putar tuweharupi nehe. Xo nezewe mehe zo ywy umuezuz kar putar neremi'u ràm newe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ka'a tetea'u hezuz putar ywy rehe newe nehe. Xu tetea'u hezuz putar ywy rehe newe nehe no. A'e rupi ere'u putar ma'e ka'a pe hezuz ma'e nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Erema'ereko tetea'u putar nehe. Nepirakor putar nehe no. Xo nezewe mehe zo ywy umuezuz putar neremi'u ràm newe nehe. Tuweharupi erema'ereko putar nezewe nehe. Amuapu'a ywy ihe, awa romo neapo pà ihe. Amo 'ar mehe erezewyr putar ywy rehe nehe, ywy romo nereko wi pà nehe. Xo a'e 'ar mehe eremumaw putar ywy rehe nema'ereko haw nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Na'e Ànàw omono her wemireko pe kury. — Ewà, i'i izupe. — Teko paw wahy, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Na'e Tupàn Tuweharupi Wiko Ma'e uzuka ma'ea'yr wà. Upyhyk wapirer wanuwi. Uzapo wama'e Ànàw pe, hemireko pe no. Umunehew a'e uma'e uzehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg a'e kury. — Awa wiko zanezàwegatete a'e kury. Aze wexak ikatu ma'e, — Ikatu ma'e, i'i izupe. Aze wexak ikatu 'ym ma'e, — Ikatu 'ym ma'e, i'i izupe. A'e rupi nupuner kwaw ma'ywa 'yw i'a kwer purumuigo kar ma'e i'u haw rehe a'e nehe kury. Nuiko kwaw tuweharupi nehe. Umàno putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","A'e rupi Tupàn Tuweharupi Wiko Ma'e umuhem kar awa imono ma'etymaw En her ma'e wi a'e kury. Utym kar ma'e izupe ywy rehe, ta'e izypy mehe umuapu'a ywy a'e awa romo iapo pà a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tupàn umuhem kar awa imono a'e ma'etymaw wi a'e. Omono kar amo weko haw pe har kerumin her ma'e a'e pe wà, ma'etymaw tupaw pe wà, kwarahy ihemaw kutyr wà. Umupu'àm takihepuku tata zàwenugar a'e pe no. A'e takihe tata zàwenugar oho ko rupi, uzewyr kwe rupi no, oho ko rupi no, uzewyr kwe rupi no. Tupàn uzapo nezewe haw a'e. Nezewe mehe zo teko noho kwaw a'e ma'e'yw purumuigo kar ma'e huwake a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ànàw upurumuzàg iko wemireko Ewà rehe we a'e kury. Ipuru'a kury. Imemyr uzexak kar. Na'e uze'eg Ewà uzeupe kury. — Tupàn Tuweharupi Wiko Ma'e hepytywàgatu a'e. A'e rupi uzexak kar hememyr kwez kury. Awa a'e, i'i uzeupe. Omono Kain umemyr her romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Uzexak kar amo imemyr Kain tywyr no. Apew her romo a'e. Tua'u mehe wiko àràpuhàràn hawitu ma'e mono'ogar romo. Kain wiko ma'etymar romo. ");
INSERT INTO gubBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kwehe wanekon nezewe wà. Amo 'ar mehe Kain upyhyk wemitygwer i'a kwer heruwà Tupàn pe imono pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Na'e Apew upyhyk àràpuhàràna'yr weimaw wainuromo uzexak kar romo ma'e kwer ipy heruwà a'e kury. Uzuka kury. Omono ipegegwer ikatu wera'u ma'e Tupàn pe. Ikatu Apew hemimono kwer Tupàn pe. Ikatu Apew izupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kain hemirur kwer na'ikatu kwaw izupe. Kain na'ikatu kwaw izupe no. A'e rupi Kain wikwahy uwywyr pe huwamànoahy pà. ");
INSERT INTO gubBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na'e Tupàn uze'eg izupe, — Màràzàwe tuwe erekwahy ne, màràzàwe tuwe neruwamànoahy ihewe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","— Aze mo erezapo ikatu ma'e, nerurywete mo, i'i izupe. — Erezapo ikatu 'ym ma'e. A'e rupi ikatu 'ymaw upyta neràro pà neràpuz hukenaw huwake a'e kury. Heko wer nezar romo a'e kury. Aze erepuner nehe, eityk nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Na'e Kain uze'eg uwywyr Apew pe kury. — Zaha ka'api'i heta haw pe zane nehe kury, i'i izupe. Oho a'e pe wà. Na'arewahy uzàmàtyry'ym Kain uwywyr Apew kury. Uzuka kury. ");
INSERT INTO gubBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nan kwehe tete Tupàn upuranu Kain rehe kury. — Ma'e pe nerywyr Apew hekon a'e, i'i izupe. — Nakwaw kwaw heko haw ihe. Aipo aiko herywyr rehe uzekaiw ma'e romo ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","— Màràzàwe tuwe erezapo nezewe haw, i'i Tupàn izupe. — Nerywyr huwy kwer ywy rehe uwyryk ma'e a'e, uhapukaz iko ihewe a'e. Wenoz nerehe hezepyk àwàm ihewe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","A'e rupi amono putar heze'egaiw nerehe ihe nehe kury. Nerepuner kwaw nema'ereko haw rehe ywy rehe kury, ta'e nerywyr izuka mehe ywy u'u huwykwer a'e xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","— Aze eremuhyk ywy neremitym ràm rehe nehe, nahezuz pixik kwaw ma'e newe nehe. Ereata e putar eho iko ywy nànàn nehe, puruwi nezàn pà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Uze'eg Kain Tupàn Tuweharupi Wiko Ma'e pe. — Napuner kwaw hereko haw rehe ihe nehe, ta'e herehe nezepykaw ipuhuz katu wera'u ihewe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","— Kutàri hemuhem kar pe iko ko ywy wi ne kury, hemuata e kar pà ne kury. Tuweharupi ata putar aha iteko ywy nànàn nehe kury. Tuweharupi àzàn putar hezeàmim pà newi ihe nehe kury. Wyzài teko heremiàwàxi ràm a'e wà nehe, ipuruzuka wer putar herehe a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Na'e Tupàn uze'eg izupe. — Nuzeapo kwaw nezewe haw nehe. Aze amo nezuka nehe, azuka kar putar 7 iànàm ihe wà nehe, ta'e azepyk putar wanehe nezewe ihe nehe xe, i'i izupe. Na'e Tupàn Tuweharupi Wiko Ma'e ukair Kain hetekwer rehe kury. — Aze amo neruwàxi nehe, nanezuka kwaw nehe, ta'e wexak putar nerehe heremimuapyk kwer nehe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Na'e Kain uhem oho Tupàn Tuweharupi Wiko Ma'e henatar wi kury, Noz ywy rehe weko haw iapo pà kury. Upyta En ywy izywyr kwarahy ihemaw kutyr. ");
INSERT INTO gubBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Na'e Kain hemireko imemyrzexak kar kury. Awa a'e. Omono Enok izupe her romo wà. Amo 'ar pawire Kain uzapo amo tawhu kury. — Enok, i'i a'e tawhu pe, wa'yr her imono pà izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Heta amo Enok ta'yr Iraz her ma'e izupe a'e. Heta amo Iraz ta'yr Mewzaew her ma'e izupe a'e. Heta amo Mewzaew ta'yr Metuzaew her ma'e izupe a'e. Heta amo Metuzaew ta'yr Aramek her ma'e izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Heta mokoz hemireko Aramek pe a'e wà. Hemireko ipy Ata her romo a'e. Inugwer Zira her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Heta amo imemyr Ata pe a'e. Zamaw her romo a'e. Zamaw wiko tapi'ak imuzehu kar har ywy rehe har waipy romo a'e. Tàpuzràn pupe wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Heta tywyr Zamaw pe. Zumaw her romo a'e. Zumaw wiko xi'àm ipy har ywy rehe har paw waipy romo a'e. Wiko wioràwiràn imupu har ywy rehe har paw waipy romo a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Heta imemyr Zira pe a'e no. Omono Tumàwkàin izupe her romo wà. Tumàwkàin a'e, tuweharupi umupyràn itatàtà ima'ema'e pà a'e, ma'e iapo pà amogwer wanupe a'e: takihe, zapepo. Uma'ema'e mokoz itatàtà: itazu morog her ma'e, itaun per her ma'e. Heta heinyr Nààm her ma'e Tumàwkàin pe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Amo 'ar mehe Aramek uze'eg wemireko wanupe. Ne Ata Aramek hemireko ne, ne Zira Aramek hemireko ne no, peinu katu heze'eg àwàm nehe. Azuka awa ihe, ta'e hekutuk takihepuku pupe a'e xe. Azuka kwàkwàmo ihe, ta'e hemugaz a'e xe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tupàn umume'u 7 teko wamàno àwàm a'e, Kain imàno awer hekuzaromo a'e. Aze amo hezuka nehe, heànàm uzuka putar 77 teko hezuka har iànàm a'e wà nehe no, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Heta amo ta'yr Ànàw pe hemireko rehe we a'e no. Uze'eg hemireko izexak kar ire. — Tupàn umur wi amo hememyr ihewe Apew hekuzaromo a'e, Kain hemizuka kwer hekuzaromo a'e, i'i uzeupe. Omono Xet her romo izupe. — Imur pyrer, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Heta ta'yr Xet pe a'e no. Omono Enoz izupe her romo. A'e 'ar mehe, teko Tupàn imuwete katu mehe, uzypyrog amo her imume'u pà izupe. — Tupàn Tuweharupi Wiko Ma'e, i'i izupe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Amuapyk putar Ànàw izuapyapyr waner xe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Awa iapo mehe kuzà iapo mehe Tupàn umuigo kar uzezàwe a'e wà. Uzapo awa a'e, uzapo kuzà a'e no. Omono uze'egatu wanehe. — Teko wà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","130 kwarahy hereko mehe heta amo ta'yr Ànàw pe. Ta'yr nuzawy kwaw u a'e. Omono Xet her romo izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A'e re Ànàw umumaw we amo 800 kwarahy wiko pà. Heta we amo ta'yr izupe wà, tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","930 kwarahy hereko mehe Ànàw umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","15 kwarahy hereko mehe uzexak kar ta'yr Enoz her ma'e Xet pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ta'yr izexak kar ire Xet umumaw amo 87 kwarahy no. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","912 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoz a'e, 90 kwarahy hereko mehe uzexak kar ta'yr izupe a'e. Kàinà her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","A'e re Enoz umumaw 815 kwarahy wiko pà no. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","95 kwarahy hereko mehe Enoz umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kàinà a'e, 70 kwarahy hereko mehe uzexak kar ta'yr Maararew her ma'e izupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","A'e re Kàinà umumaw we amo 840 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","910 kwarahy hereko mehe umàno Kàinà a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maararew a'e, 65 kwarahy hereko mehe uzexak kar ta'yr Zare her ma'e izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","A'e re Maararew umumaw amo 830 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","895 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Zare a'e, 162 kwarahy hereko mehe uzexak kar ta'yr Enok her ma'e izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","A'e re Zare umumaw we amo 800 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","962 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok a'e, 65 kwarahy hereko mehe ta'yr uzexak kar izupe a'e. Matuzarez ta'yr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","A'e re Enok weruzar Tupàn ze'eg, izupe uze'eg pà tuweharupi. Umumaw 300 kwarahy nezewe wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok umumaw 365 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tuweharupi weruzar Tupàn, izupe uze'eg pà. Tupàn uze'eg izupe tuweharupi no. Amo 'ar rehe ukàzym ywy wi, ta'e Tupàn weraha a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuzarez a'e, 187 kwarahy hereko mehe ta'yr uzexak kar izupe a'e. Aramek ta'yr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","A'e re Matuzarez umumaw amo 782 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","969 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Aramek a'e, 182 kwarahy hereko mehe uzexak kar ta'yr izupe a'e. Amo 'ar mehe uze'eg Aramek amogwer wanupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","— Tupàn Tuweharupi Wiko Ma'e omono uze'egaiw ywy rehe a'e. A'e rupi zanema'ereko haw ipuhuz katu zanewe a'e, i'i wanupe. — Ko kwarer werur putar zanepytu'u haw zanewe a'e nehe, i'i wanupe. Na'e omono Noe wa'yr pe her romo kury. — Zanepytu'u haw, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","A'e re Aramek umumaw 595 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","777 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noe a'e, 500 kwarahy hereko mehe heta na'iruz ta'yr izupe a'e wà kury. Xem, Kàm, Zape ta'yr waner romo a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Teko uzypyrog uhàuhàz pà ywy rehe a'e 'ar mehe a'e wà. Heta tazyr wanupe wana'yr wanehe we wà. ");
INSERT INTO gubBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","A'e 'ar mehe amo tekwe wana'yr wexak kuzà ywy rehe har a'e wà kury. — Ipuràg eteahy a'e wà, i'i uzeupeupe wà. A'e rupi wexaexak amo uzeupe wemireko romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg uzeupe a'e kury. — Namuigo kar kwaw teko tuweharupi ihe wà nehe. Ta'e umàno ma'e ràm romo wanekon a'e wà xe, i'i uzeupe. — Ko 'ar henataromo ni amo numumaw kwaw kwarahy tetea'u wiko pà a'e wà nehe. Xo 120 kwarahy zo upuner imumaw paw rehe a'e wà nehe kury, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","A'e 'ar rehe tekwe wana'yr wereko awa wanazyr wemireko romo wà. Heta wana'yr wanupe wà. Heta wanazyr wanupe wà no. A'e teko iaiha katu a'e wà. Wiko ywy rehe wà. A'e teko iaiha katu ma'e kwehe arer ikàg tuwe a'e wà. Teko tetea'u umume'u wanemiapo kwer purumupytuhegatu kar haw uzeupeupe kwehe mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tupàn Tuweharupi Wiko Ma'e wexak teko wanemiapo kwer a'e 'ar rehe a'e kury. Iaiw wanemiapo kwer izupe. — Xo ikatu 'ym ma'e iapo haw rehe ima'enukwaw waiko a'e wà, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Uzemumikahy a'e. — Màràzàwe tuwe azapo teko ihe wà, i'i uzeupe. Tupàn Tuweharupi Wiko Ma'e uzemumikahy tuwe a'e, ipuhuz katu ipy'a izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A'e rupi nezewe uze'eg kury. — Amukàzym putar ko teko heremiapo kwer ywy wi ihe wà nehe. Amukàzym putar ma'ea'yr heremiapo kwer paw ywy wi ihe wà nehe: miar, wie rehe wata ma'e wà, wiràmiri wà. Ta'e azemumikahy tuwe ihe xe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Xo Noe wanemiapo kwer zo ikatu Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Na'aw Noe hemiapo kwer imume'u haw xe a'e kury. Heta na'iruz ta'yr izupe a'e wà: Xem, Kàm, Zape. Noe wiko awa ikatuahy ma'e romo a'e. Weruzar Tupàn ze'eg oho iko tuweharupi. Amogwer teko a'e 'ar rehe har a'e wà, nuputar kwaw Tupàn a'e wà. Xo Noe zo wiko Tupàn rehe we har romo a'e, izupe uze'eg pà a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Amogwer teko paw iaiw Tupàn pe wà, heta zeàmàtyry'ymaw ywy nànàn. ");
INSERT INTO gubBl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ume'e Tupàn ywy rehe. Tynehem ikatu 'ygwer pupe a'e, i'i uzeupe. Teko paw uzapo xo ikatu 'ym ma'e oho waiko wà. ");
INSERT INTO gubBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Na'e Tupàn uze'eg Noe pe a'e kury. — Azuka putar teko paw rupi ihe wà nehe kury. Azuka putar tuwe ihe wà nehe. Amumaw putar ywy ihe nehe no, ta'e teko tetea'u umugaz amo teko wà xe, uzuka amo wà no xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","— A'e rupi ne nehe ty, emonohok ywyra ikatu ma'e eho ne nehe ty. Ezapo kanuhu uhua'u ma'e nezeupe nehe. Ezapo ipupyaikaw paw tetea'u kanuhu pupe nehe. Ewàpytym ikwaikwar iraity zàwenugar pupe nehe no, imukatu pà ipupe nehe, ikupe pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Amume'u putar uhua'u àwàm newe nehe kury. Heta putar 133 met ipukua'u haw nehe. Heta putar 22 met iànàmaw nehe. Heta putar 13 met iaiha haw nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ezapo tàpuz kanuhu i'aromo nehe. Tuwe tàpuz utyryk kanuhu heme'yw wi nehe. Emono pitài met iku'aw har rehe we tàpuz heme'yw kanuhu heme'y wamytepe nehe. Ezapo na'iruz ata haw tàpuz pupe pitàitàigatu amo ata haw i'aromo nehe no. Ezapo uken ipehegwer rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Amo 'ar mehe amugyr kar putar àmànuhu ihe nehe, ywy ipyk kar pà izupe ihe nehe. Nezewe mehe azuka putar wikuwe ma'e ywy rehe har upaw rupi katete ihe wà nehe. Wikuwe ma'e ywy rehe har umàno putar upaw rupi katete wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Azapokatu putar heze'egaw nerehe we ihe nehe kury. Eixe kanuhu pupe nehe. Eraha neremireko nezeupi nehe. Eraha nera'yr nezeupi ne wà nehe no. Eraha nera'ytaty nezeupi ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Exaexak miar pitàitàigatu ne wà nehe: pitài awa nehe, pitài kuzà nehe no: wiràmiri hexakaw paw hereko har wà, miar hexakaw paw hereko har wà, wie rehe wata ma'e hexakaw paw hereko har wà, amogwemogwer hexakaw hereko har upaw rupi katete wà. Eraha kanuhu pupe upaw rupi katete ne wà nehe, wapyro pà wamàno haw wi wamuigo kar pà ne wà nehe, i'i Tupàn Noe pe. ");
INSERT INTO gubBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","— Emono'ono'og penemi'u ràm wyzài hexakaw hereko har tetea'u ne nehe no. Nezewe mehe heta putar penemi'u ràm peme nehe, ma'ea'yr nànàn nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noe uzapo ma'e paw Tupàn ze'eg rupi a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","A'e re Tupàn Tuweharupi Wiko Ma'e uze'eg Noe pe a'e kury. — Eixe kanuhu pupe nehe, eraha neànàm paw nezeupi ne wà nehe no. Ta'e aexak neremiapo kwer ihe xe. Xo ne zo erezapo ikatu ma'e tuweharupi, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","— Amo ma'ea'yr ikatu ihewe herenataromo izuka pyràm romo a'e wà. Eraha a'e ma'ea'yr ikatu ma'e nezeupi kanuhu pupe ne wà nehe. Pitàitàigatu eraha 7 awa ne wà nehe, eraha 7 kuzà ne wà nehe no. Amo ae ma'ea'yr na'ikatu kwaw ihewe herenataromo izuka pyràm romo wà. Eraha agwer ma'ea'yr nezeupi kanuhu pupe ne wà nehe no. Pitàitàigatu eraha pitài awa ne wà nehe, eraha pitài kuzà ne wà nehe no, i'i Noe pe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","— Eraha wiràmiri nezeupi ne wà nehe no. Pitàitàigatu eraha 7 awa ne wà nehe, eraha 7 kuzà ne wà nehe no. Nezewe mehe heta putar wiràmiri hexakaw paw hereko har ywy rehe tuweharupi a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ta'e ko 7 haw 'ar mehe amugyr kar putar àmànuhu ihe nehe. Umumaw putar 40 'ar ukyr pà a'e nehe. Ukyr putar 'aromo nehe. Ukyr putar pyhaw nehe no. Nezewe mehe azuka putar ma'e wikuwe ma'e ko ywy rehe har heremiapo kwer upaw rupi katete ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na'e Noe uzapo a'e ma'e Tupàn hemiapo karer upaw rupi katete a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noe wereko 600 kwarahy a'e 'ar mehe àmànuhu ywy ipyk mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Izepyro wer àmànuhu wi, a'e rupi wixe kanuhu pupe, wa'yr waneraha pà uzeupi no, wemireko heraha pà no, wa'ytaty waneraha pà no. ");
INSERT INTO gubBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","A'e miar Tupàn pe wenataromo izuka pyràm romo ikatu ma'e a'e wà, amogwer ma'ea'yr a'e wà no, wie rehe wata ma'e a'e wà no, wiràmiri a'e wà no, ");
INSERT INTO gubBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wixe kanuhu pupe Noe henataromo a'e wà. Mokoz wixe a'e pe wà. A'e re amo mokoz wixe a'e pe wà. Nezewe wixe kanuhu pupe upaw rupi wà. Wixe ma'ea'yr awa, wixe a'e ma'ea'yr kuzà awa rupi no. Ta'e nezewe haw Tupàn uzapo kar Noe pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","7 'ar pawire àmànuhu ukyr tetea'u. 'Y àmànuhu imono'og pyrer uzypyrog ywy ipyk pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","A'e 'ar mehe, Noe wereko 600 kwarahy. Umumaw pitài zahy a'e pe wiko pà wà. Umumaw amo 17 'ar kanuhu pupe wata pà wà no. A'e 'ar mehe 'yzygwar yryhu iwy pe har uzewàpytymawok upaw rupi wà. Ywak uzewàpytymawok ukenaw ài no. ");
INSERT INTO gubBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ukyr àmànuhu tetea'u. A'e àmànuhu umumaw 40 'ar ukyr pà ywy rehe upik 'ym pà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","A'e 'ar mehe Noe wixe kanuhu pupe wànàm wanupi: hemireko, a'e na'iruz ta'yr (Xem, Kàm, Zape waner romo wà), wanemireko wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Miar tetea'u hexakaw paw hereko har wixe kanuhu pupe wanupi wà no: ma'ea'yr tàpuznaw pe har wà, miar ka'a pe har wà, wie rehe wata ma'e wà, wiràmiri wà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Paw rupi wixe oho kanuhu pupe wà, Noe rupi wà, mokomokoz wixe ipupe wà, awa wà, kuzà rehe we wà. Ta'e Tupàn umuixe kar a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Awa xiroxirogatu wexakaw hereko har wixe ipupe wà, kuzà wexakaw hereko har xiroxirogatu wixe ipupe wà no. Ta'e nezewe haw Tupàn uzapo kar Noe pe a'e xe. Na'e Tupàn Tuweharupi Wiko Ma'e uwàpytym uken kanuhu rehe har a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Na'e àmànuhu umumaw 40 'ar ukyr pà. 'Y uzeupir ywy 'aromo kanuhu heraha pà kury. Uzypyrog uwyar pà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Uzeupir wiwi 'y iko kury. Kanuhu wata i'aromo. ");
INSERT INTO gubBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Uzeupir tuwe 'y. Te upyk ywytyr ywy rehe har iaiha wera'u ma'e upaw rupi katete kury. ");
INSERT INTO gubBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Na'e uzeupir we amo 7 met oho kury. ");
INSERT INTO gubBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","A'e rupi ma'e wikuwe ma'e ywy rehe har umàno upaw rupi katete a'e wà kury: wiràmiri wà, ma'ea'yr tàpuznaw pe har wà, miar wà, ma'e wie rehe wata ma'e wà, teko wà. Ywy rehe har umàno upaw rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Upaw rupi katete izuapyapyr umàno wà kury. Wikuwe ma'e paw ipytuhem ma'e paw umàno wà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Xo Noe zo a'e, hehe we har kanuhu pupe har zo a'e wà, xo a'e zo wikuwe a'e re a'e wà. Tupàn uzuka amogwer upaw rupi katete a'e wà: teko wà, ma'e tàpuznaw pe har wà, miar wà, wie rehe wata ma'e wà, wiràmiri wà. ");
INSERT INTO gubBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Umumaw 150 'ar a'e ma'e uzeapo pà. Xo a'e re zo 'y uzypyrog typaw pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Na'e Tupàn ima'enukwaw Noe rehe a'e kury, ma'ea'yr kanuhu pupe har wanehe upaw rupi a'e no. Umur kar ywytu ywy rehe kury. 'Y uzypyrog typaw pà a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","'Yzygwar yryhu wy pe har, uzewàpytym a'e kury. Ywak uzewàpytym uken ài no. Àmànuhu upik oho kury, ukyr ire upytu'u pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Umumaw 150 'ar typaw romo. Mewe katu typaw. ");
INSERT INTO gubBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kanuhu umumaw 6 zahy wata pà 'y rehe, amo 17 'ar imumaw pà wata pà no. Na'e upytu'u ywy Ararat her ma'e ywytyr heta haw rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","'Y typaw oho iko. Zahy 10 haw mehe pitài 'ar mehe uzekwa ywytyruhu àkwà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Amo 40 'ar pawire Noe uwàpytymawok uken kanuhu rehe har wemiapo kwer a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Umuwewe kar amo wiràmiri pihun ma'e a'e kury. Wiràmiri uwewe ko rupi, uwewe kwerupi no. Wekar ywy ikàgaw. Nuexak kwaw. ");
INSERT INTO gubBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Na'e Noe umuwewe kar pykahu kury. Ipurukwaw wer ywy ixinigaw rehe, a'e rupi wekar kar pykahu pe. ");
INSERT INTO gubBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pykahu nuexak kwaw wapykaw. Ta'e 'y upyk ywy upaw rupi a'e rihi xe. Na'e Noe omono opo pykahu pe iapykaw romo kury. Upyhyk imuzewyr pà kanuhu pupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Umumaw amo 7 'ar ma'e hàro pà. Na'e umuwewe kar wi pykahu kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Karuketea'i mehe uzewyr ka'akyr herur pà uxi rehe. Ma'e'yw uriwar her ma'e huwer werur. Nezewe Noe ukwaw 'y typapaw kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Umumaw amo 7 'ar ma'e hàro pà kury. Umuwewe kar wi pykahu kury. Nuzewyr kwaw. ");
INSERT INTO gubBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noe 61 kwarahy hereko mehe wexak 'y ywy rehe har typapaw azeharomoete har a'e kury. Zahy ipy mehe 'ar ipy mehe Noe upiowok kanuhu kury, ipykaw henuhem pà izuwi kury. Wexak amo ywy kury, ta'e typaw 'y oho iko a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mokoz haw zahy rehe 27 haw 'ar mehe ywy ikàg tuwe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Na'e Tupàn uze'eg Noe pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","— Ehem eho kanuhu wi nehe, neremireko rupi nehe, nera'yr wanupi nehe no, wanemireko wanupi nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","— Emuhem kar ma'ea'yr nepyr har upaw rupi ne wà nehe no: wiràmiri wà, ma'ea'yr tàpuznaw pe har wà no, miar ka'a pe har wà no, wie rehe wata ma'e wà no, i'i izupe. — Tuwe uhàuhàz ywy nànàn wà nehe, tuwe upurumuzàmuzàg wà nehe, ywy imynehem pà wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","A'e rupi Noe a'e, hemireko a'e no, ta'yr a'e wà no, wanemireko a'e wà no, uhem oho kanuhu wi a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma'ea'yr paw a'e wà no, wiràmiri a'e wà no, pitàitàigatu uhem oho kanuhu wi a'e wà no, uzezàwe har rupi a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na'e Noe uzapo ma'ea'yr hapy haw a'e pe kury, ma'ea'yr wazuka pà Tupàn Tuweharupi Wiko Ma'e henataromo kury. Upyhyk wiràmiri wà, upyhyk ma'ea'yr Tupàn pe ikatu ma'e wà no. Wapy ma'ea'yr xiroxirogatu hexakaw hereko har Tupàn henataromo pitàitàigatu a'e pe wà, ma'ea'yr hapy haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Hyàkwegatu a'e ma'ea'yr hapy pyrer Tupàn pe kury. A'e rupi uze'eg nezewe uzeupe kury. — Nazapo wi pixik kwaw agwer iaiw ma'e ywy rehe har wanupe ihe nehe, teko wanemiapo kwer ikatu 'ygwer rehe hezepyk pà nehe, i'i uzeupe kury. — Akwaw ko ma'e ihe. Teko a'e wà, kwàkwàmo mehe arer we, kuzàwaza mehe arer we, xo ikatu 'ym ma'e iapo haw rehe ima'enukwaw a'e wà, i'i uzeupe. Nezewe rehe we namono wi kwaw heze'egaiw ywy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nazuka wi pixik kwaw ma'e wikuwe ma'e paw nezewe ihe wà nehe, ko 'ar rehe har zàwe ihe wà nehe, i'i uzeupe. — Ywy heta mehe we heta putar ma'eà'yz itymaw àmàn nànàn nehe, heta putar temi'u ipo'o haw kwarahy nànàn nehe no. Heta putar huwixàg mehe nehe, heta putar haku mehe nehe no. Heta putar kwarahy nehe, heta putar àmàkyhaw nehe no. Heta putar 'ar nehe, heta putar pytunaw nehe no, i'i tuwe uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na'e Tupàn omono uze'egatu Noe pe a'e kury, ta'yr wanupe a'e no. — Tuwe heta tetea'u pena'yr peme wà nehe. Tuwe pezuapyapyr uhàuhàz ywy nànàn a'e wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","— Ma'ea'yr paw a'e wà, wiràmiri paw a'e wà no, ma'e wie rehe wata ma'e paw a'e wà no, ipira paw a'e wà no, ukyze putar pewi a'e wà nehe. Ukyze putar azeharomoete wà nehe. Peiko putar wazar romo nehe, pezapo kar putar penemimutar wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Pepuner wano'o kwer i'u haw rehe nehe, pepuner hezuz ma'e i'u haw rehe nehe no. Amono agwer ma'e peme penemi'u ràm romo ihe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Amo ma'e na'u kar kwaw peme. Ma'ero'o kwer huwykwer inuromo har pe'u zo nehe, ta'e tuwykwer umuigo kar tetekwer a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aze amo teko uzuka amo nehe, azepyk putar izuka arer rehe ihe nehe. Aze amo miar uzuka amo teko a'e nehe, azepyk putar izuka arer rehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Azapo teko hezàwenugar romo ihe wà. A'e rupi aze amo teko uzuka amo teko a'e nehe, amo ae uzuka putar izuka arer a'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tuwe heta tetea'u pena'yr peme wà nehe, penazyr peme wà nehe no. Tuwe pezuapyapyr uhàuhàz ywy nànàn a'e wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Na'e Tupàn uze'eg wi Noe pe kury, ta'yr wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","— Azapokatu putar heze'egaw penehe we ihe nehe kury, peme heremiapo ràm imume'u pà ihe nehe kury, pezuapyapyr wanupe heremiapo ràm imume'u pà ihe nehe no, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","— Amume'u putar heremiapo ràm ma'ea'yr wanupe no, pepyr arer kanuhu wi uhem ma'e kwer wanupe: wiràmiri wanupe, ma'ea'yr tàpuznaw pe har wanupe, miar hehaite ma'e wanupe, ma'ea'yr ywy rehe har paw wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na'aw heze'egaw heremiapo katu ràm xe kury. — Nazuka pixik kwaw ma'e wikuwe ma'e àmànuhu pupe ihe wà nehe. Namugyr wi kar pixik kwaw agwer àmànuhu ihe nehe, ywy imumaw pà ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aexak kar putar ma'e peme ihe nehe kury. Hexak mehe pekwaw putar heremimume'u kwer azeharomo har kury. Pekwaw putar àmànuhu pupe pezuka pixik 'ym àwàm nehe kury, hexak mehe nehe kury. Pekwaw putar àmànuhu pupe ma'ea'yr wazuka pixik 'ym àwàm nehe no, hexak mehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Amono putar zanurape ywak rehe ihe nehe kury. A'e zanurape a'e nehe, ukwaw kar putar ywy rehe har wanupe heremimume'u kwer peme a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aze azupyk ywak ywàkun pupe nehe, aze aexak kar zanurape teko wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","a'e 'ar mehe pekwaw putar peme miar paw wanupe heremimume'u kwer nehe. Naheta pixik kwaw amo àmànuhu ikyr àwàm nehe. Naheta pixik kwaw amo ma'e wikuwe ma'e paw izuka àràm nehe. A'e mehe hema'enukwaw putar heze'egaw heremiapo katu kwer rehe ihe nehe. Ta'e amume'u wazuka pixik 'ymaw ma'e wikuwe ma'e ywy rehe har paw wanupe ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zanurape ywàkun inuromo izexak kar mehe aexak putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Zanurape umuma'enukwaw kar putar heremimume'u kwer rehe a'e nehe, wikuwe ma'e ywy rehe har paw wanupe a'e nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noe ta'yr uhem kanuhu wi u rupi a'e wà. Xem, Kàm, Zape waner romo wà. Kàm wiko Kànàà tu romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","A'e na'iruz awa a'e wà, Noe ta'yr romo wanekon a'e wà. Wazuapyapyr uhàuhàz ywy nànàn a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noe wiko ma'etymar romo a'e. A'e ràgypy uzapo uwà 'yw itymaw a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Amo 'ar mehe ui'u tetea'u Noe uwà tykwer win pupe a'e kury. Uka'u kury. U'aw oho wemyhar 'ym pà ukamir 'ym pà wàpuzràn pupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ta'yr Kàm a'e, Kànàà tu a'e, wexak u ima'e 'ym mehe a'e. Nupyk kwaw u. Uhem a'e wi wyky'yr wanupe imume'u pà. ");
INSERT INTO gubBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Na'e Xem a'e, Zape a'e no, upyhyk amo pàn axi'i pykaw a'e wà kury. Upyk waxi'i pàn pupe wà. Wata oho u kutyr hehe ume'e 'ym pà wà. Upyk u a'e pàn pupe wà, ta'e wanu numunehew kwaw wemyhar a'e xe. Nume'e kwaw hehe, a'e rupi nuexak kwaw u hemyhar 'ym mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Uka'u re Noe ume'e kury. Ukwaw wa'yr Kàm hemiapo kwer a'e kury. (Kàm a'e, Noe ta'yr ipyahu wera'u ma'e romo hekon a'e.) ");
INSERT INTO gubBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Na'e Noe uze'eg wanupe kury. Amono putar ze'egaiw Kànàà rehe ihe nehe kury. Uma'ereko e ma'e romo hekon putar wyky'yr wanupe nehe. Uma'ereko e ma'e uzemumikahy ma'e romo hekon putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Umume'u wi amo ma'e a'e no. Tupàn Tuweharupi Wiko Ma'e a'e, ikatuahy a'e, ta'e Xem izar romo hekon a'e xe. Tuwe Kànàà wiko Xem pe uma'ereko e ma'e romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tuwe Tupàn umuigo kar Zape ywy tetea'u izar romo a'e nehe. Tuwe Zape izuapyapyr wiko Xem heko haw pe wà nehe. Tuwe Kànàà wiko Zape pe uma'ereko e ma'e romo a'e nehe, i'i Noe a'e 'ar mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Àmànuhu ikyr ire Noe umumaw amo 350 kwarahy. ");
INSERT INTO gubBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","950 kwarahy hereko mehe umàno. ");
INSERT INTO gubBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Amume'u putar Noe ta'yr wazuapyapyr waner xe ihe wà nehe kury, Xem, Kàm, Zape wazuapyapyr waner imuapyk pà xe ihe wà nehe kury. Àmànuhu ikyr ire heta wana'yr Noe ta'yr wanupe wà, heta wanazyr wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Amume'u putar Zape ta'yr waner xe ihe wà nehe kury: Komer, Makok, Manaz, Zàwà, Tumaw, Mezek, Xiraz. ");
INSERT INTO gubBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na'aw Komer ta'yr waner xe wà kury: Akenaz, Hipat, Togarimà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Zàwà ipurumuzàmuzàg a'e wà, uhàuhàz oho waiko amo ywy rehe a'e wà. Eriza ywy rehe, Epàn ywy rehe, Xip ywy rehe, Hoz ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Zape izuapyapyr a'e wà, uzapo weko haw oho yryhu iwyr a'e wà, yrypypo'o rehe a'e wà no. Teko pitàitàigatu a'e wà, uzeànàànàm ma'e kwer a'e wà no, upyhyk uiwy oho a'e wà, a'e pe weko haw iapo pà a'e wà, uze'eg rupi uze'eg pà a'e pe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Na'aw Kàm ta'yr waner xe wà kury: Kuxi, Ezit, Irim, Kànàà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na'aw Kuxi ta'yr waner xe wà kury: Xewa, Awira, Xawita, Hama, Xateka. Na'aw Hama ta'yr waner wà: Xama, Nenà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuxi wiko Nihoz tu romo a'e. Nihoz wiko puruàmàtyry'ymar ikàg ma'e ipy romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tupàn upytywàgatu Nihoz a'e. A'e rupi wiko uzemi'i kar ma'e ikàg ma'e romo. A'e rupi teko ko 'ar rehe har uze'eg nezewe uzeupeupe hehe a'e wà kury. — Eiko Nihoz zàwegatu nehe ty. Ta'e Tupàn upytywà a'e xe. A'e rupi wiko uzemi'i kar ma'e ikàg ma'e romo a'e, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Izypy mehe Nihoz wiko amo tawhu pe har wanuwihawete romo a'e kury: Mawiron tawhu, Erek tawhu, Akaz tawhu. A'e na'iruz tawhu Xinar ywy rehe wanuz a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Na'e Nihoz uhem oho a'e ywy wi kury, Axir ywy rehe oho pà kury. Uzapo kar 4 tawhu a'e ywy rehe: Nin, Heomot-Ir, Kara tawhu uhua'u ma'e, Hezem. ");
INSERT INTO gubBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Hezem tawhu a'e, mokoz tawhu wamyter pe tuz. Nin tawhu xe kutyr Kara tawhu uhua'u ma'e pemutyr tuz a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Heta Ezit izuapyapyr a'e wà. Na'aw a'e teko waner xe wà kury: Iri, Anam, Ereaw, Napitu, ");
INSERT INTO gubBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Paturu, Kaziru, Kereta. Teko Piri ywy rehe har her ma'e a'e wà, Kereta izuapyapyr romo wanekon a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Heta mokoz Kànàà ta'yr izupe wà: Xitom tyky'yr her romo a'e. Ete tywyr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Heta amo Kànàà izuapyapyr a'e wà no. Na'aw waner xe kury. Zepu, Amohe, Zirikaze, ");
INSERT INTO gubBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ewe, Araki, Xine, ");
INSERT INTO gubBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ariwaxi, Zemare, Amat. ");
INSERT INTO gubBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kànàà izuapyapyr waiwy uzypyrog Xitom tawhu pe Zerar tawhu rehe uhyk pà a'e. Zerar tawhu Kaz ywy huwake tuz a'e. Oho kwarahy ihemaw kutyr te Xotom tawhu pe, Komor tawhu pe no, Anima tawhu pe no, Zemoim tawhu pe no. Zemoim tawhu Araz ywy huwake tuz. ");
INSERT INTO gubBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amume'u putar Kàm izuapyapyr waner xe ihe wà kury. A'e teko paw wereko uiwy pitàitàigatu a'e wà. Uzeànàànàm ma'e kwer wereko uiwy pitàitàigatu wà no. Uze'eg uze'eg rupi pitàitàigatu wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Xem a'e, Zape tyky'yr a'e, teko Emerew her ma'e paw wanu romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Na'aw Xem ta'yr waner xe a'e wà kury: Eràw, Axur, Arapaxaz, Iruz, Àrà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Na'aw Àrà ta'yr waner xe wà kury: Uz, Ur, Zeter, Maaza. ");
INSERT INTO gubBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arapaxaz wiko Xera tu romo a'e. Xera wiko Emer tu romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heta mokoz ta'yr Emer pe a'e wà. Tyky'yr a'e, Pereg her romo a'e. — Uzemuza'aza'ak ma'e kwer wà, i'i her zaneze'eg rupi. Ta'e a'e 'ar mehe teko ywy rehe har uzemuza'aza'ak a'e wà xe. Tywyr a'e, Zokità her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Heta ta'yr tetea'u Zokità pe wà. Na'aw waner xe wà: Awmona, Xerew, Azar-Mawe, Zer, ");
INSERT INTO gubBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Anoniràw, Uzaw, Nikira, ");
INSERT INTO gubBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Omaw, Amimaew, Xama, ");
INSERT INTO gubBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Awira, Zoaw. A'e awa paw wiko Zokità ta'yr romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wiko oho amo ywy rehe wà. A'e ywy uzypyrog Mez tawhu pe. Oho Xepar tawhu pe. Heta ywytyr tetea'u a'e ywy rehe. Kwarahy ihemaw kutyr a'e taw tuz. ");
INSERT INTO gubBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amume'u putar Xem izuapyapyr waner xe ihe wà kury. A'e teko paw wereko uiwy pitàitàigatu a'e wà. Uzeànàànàm ma'e paw wereko uiwy a'e wà no. Uze'eg uze'eg rupi pitàitàigatu a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Amumaw Noe ta'yr wazuapyapyr waner imume'u haw kwez ihe kury, waneko awer imume'u haw ihe no. Wazuapyapyr wanemiapo kwer pitàitàigatu imume'u haw amumaw kwez kury. Àmànuhu ikyr pawire teko ywy rehe har paw wiko Noe izuapyapyr romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","A'e 'ar mehe teko paw uze'eg pitài ze'eg rupi a'e wà. Ze'eg wyzài ywy rehe har nuzawy kwaw ze'eg amogwer ywy rehe har wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Amo teko uhem ywy kwarahy ihemaw kutyr har wi a'e wà, amo ae ywy ywate wera'i har Xinar rehe har pe oho pà wà, ywy apypepaw pe wà. Uzapo weko haw a'e pe wà. Upyta a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Amo 'ar mehe amo uze'eg amogwer wanupe a'e wà kury. — Zaha ty wà, i'i uzeupeupe wà. — Xiapo ywytàtà tetea'u nehe, tata pupe imuàtà pà nehe, i'i uzeupeupe wà. Uzapo ywytàtà tetea'u wà. A'e rupi heta tetea'u ywytàtà wanupe kury, tàpuz iapo haw romo kury. — Nezewe mehe naxiapo kwaw tàpuz ita pupe zane nehe, i'i uzeupeupe wà. Nomono kwaw a'e ywy xig ma'e ywytàtà wamyter pe wà. Omono iraity zàwenugar ywytàtà wamyter pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na'e uze'eg wi uzeupeupe wà kury. — Ko 'ar rehe xiapo tawhu zane nehe kury. Tawhu myter pe xiapo tàpuzuhu aiha katu ma'e nehe no. A'e tàpuzuhu aiha katu ma'e uhem putar ywak rehe a'e nehe, i'i uzeupeupe wà. — Nezewe mehe teko ywy nànànar wenu putar zaneremiapo kwer imume'u haw a'e wà nehe. Nezewe mehe ni amo nazanemuhàmuhàz kwaw ywy nànàn a'e wà nehe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Na'e Tupàn Tuweharupi Wiko Ma'e wezyw wà ywy rehe a'e kury, a'e tawhu hexak pà a'e kury, a'e tàpuzuhu iaiha ma'e iapo pyr hexak pà a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","— 'Aw teko a'e wà, pitài teko romo wanekon a'e wà. Uze'eg pitài ze'eg rupi wà. Uzypyrog ma'e iapo pà wà kury. Tàrityka'i upuner putar wyzài wemimutar iapo haw rehe wà nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","— Zawezyw putar wapyr nehe, waze'eg imuaiw pà nehe. Nezewe mehe amo nuenu katu kwaw amogwer waze'eg a'e wà nehe kury. Ni amo nukwaw kwaw amogwer waze'eg wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nezewe Tupàn umuhàmuhàz a'e teko paw ywy nànàn a'e wà kury. Upytu'u a'e tawhu iapo re wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mamew a'e tawhu her romo a'e. — Ma'e imuaiw pyrer, i'i her zaneze'eg rupi. Ta'e Tupàn umuaiw ywy rehe har waze'eg upaw rupi a'e xe, ywy nànàn teko wamuhàmuhàz pà a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Xem izuapyapyr waner amume'u putar xe ihe wà nehe kury. Umumaw mokoz kwarahy àmànuhu ikyr pawire. A'e kwarahy rehe Xem wereko 100 kwarahy. Uzexak kar ta'yr Arapaxaz izupe a'e 'ar mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A'e re Xem umumaw amo 500 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arapaxaz a'e, 35 kwarahy hereko mehe amo ta'yr uzexak kar izupe a'e kury. Xera ta'yr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A'e re Arapaxaz umumaw amo 43 kwarahy wiko pà a'e. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Xera a'e, 30 kwarahy hereko mehe uzexak kar ta'yr Emer her ma'e izupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A'e re Xera umumaw amo 43 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Emer a'e, 34 kwarahy hereko mehe uzexak kar ta'yr Pereg her ma'e izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A'e re Emer umumaw amo 430 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pereg a'e, 30 kwarahy hereko mehe ta'yr Heu her ma'e uzexak kar izupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A'e re Pereg umumaw amo 29 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Heu a'e, 32 kwarahy hereko mehe uzexak kar ta'yr Xerug her ma'e izupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A'e re Heu umumaw amo 27 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Xerug a'e, 30 kwarahy hereko mehe uzexak kar ta'yr Naor her ma'e izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A'e re Xerug umumaw amo 200 kwarahy. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naor a'e, 29 kwarahy hereko mehe uzexak kar ta'yr Ter her ma'e a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A'e re Naor umumaw 119 kwarahy wiko pà. Heta amo ta'yr izupe wà, amo tazyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","70 kwarahy imumaw ire heta na'iruz ta'yr Ter pe wà. Na'aw waner xe wà: Àmàràw, Naor, Àrà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Na'aw Ter izuapyapyr waner xe wà kury: Àmàràw, Naor, Àrà ta'yr waner romo wà. Heta Àrà ta'yr Iro her ma'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ta'yr Àrà Mawiron ywy rehe imàno mehe Ter wikuwe a'e rihi. Àrà umàno Ur tawhu pe uzexak kar awer pe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Àmàràw wereko Xaraz wemireko romo a'e. Naor wereko Miwka wemireko romo a'e. Miwka a'e, Izika a'e no, Àrà tazyr romo wanekon a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Xaraz na'imemyr kwaw a'e, ta'e nupuner kwaw umemyr haw rehe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ter uhem oho Ur tawhu Mawiron ywy rehe har wi a'e. Oho Kànàà ywy rehe kury. Weraha wa'yr Àmàràw uzeupi no. Weraha wemimino Iro Àrà ta'yr uzeupi no. Weraha wa'yr hemireko Xaraz uzeupi no. Uhem wà Àrà pe wà kury. Upyta a'e pe wiko pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ter, umàno Àrà ywy rehe. Wereko 25 kwarahy umàno mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","A'e 'ym mehe Tupàn Tuweharupi Wiko Ma'e uze'eg Àmàràw pe a'e. — Ehem eho xe wi neiwy wi nehe, neànàm wanuwi nehe, neru heko haw wi nehe. Aexak kar putar amo ywy newe ihe nehe. Eho a'e ywy rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","— Nezuapyapyr heta tetea'u putar a'e ywy rehe upuner ma'e romo wiko pà a'e wà nehe. Amono putar heze'egatu wanehe nehe. Teko ywy nànànar ukwaw putar waner a'e wà nehe, ukwaw putar waneta haw a'e wà nehe. Ne nehe, nezuapyapyr a'e wà nehe no, peiko putar ikatuahy ma'e amogwer teko wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","— Aze eremono neze'egatu amo teko wanehe nehe, amume'u putar heze'egatu a'e teko wanupe ihe nehe no. Aze eremono neze'egaiw amo teko wanehe nehe, amono putar heze'egaiw a'e teko wanehe ihe nehe no. Teko paw waneko haw ikatu wera'u putar nehe, ta'e amono heze'egatu nerehe ihe nehe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","75 kwarahy hereko mehe Àmàràw uhem oho a'e ywy wi, Àrà wi a'e kury, Tupàn hemimume'u kwer rupi katete a'e kury. Iro oho hupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Àmàràw weraha amo teko uzeupi a'e wà no, amo ma'e uzeupi a'e wà no: hemireko Xaraz, i'ir Iro her ma'e, uma'e paw, wemetarer paw, uzeupe uma'ereko e ma'e paw wà, ma'e Àrà pe wemipyhyk kwer paw. A'e ma'e paw weraha uzeupi Àrà wi oho mehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kànàà ywy rehe uhem mehe Àmàràw wahaw ywy, Xikez tawhu pe uhem pà. Xikez a'e, tawhu Tupàn pe imonokatu pyrer a'e. Heta amo ywyra Tupàn pe imonokatu pyrer a'e pe no. More, i'i teko ywy pehegwer a'e ywyra hereko har pe wà. A'e 'ar rehe teko Kànàà izuapyapyr wiko a'e ywy rehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","A'e pe ihem mehe Tupàn uzexak kar wi Àmàràw pe kury. — Amono putar 'aw ywy nezuapyapyr wanupe ihe nehe, waneko àwàm romo ihe nehe, i'i izupe. A'e ywy rehe Àmàràw uzapo amo ma'ea'yr hapy haw Tupàn Tuweharupi Wiko Ma'e henataromo a'e kury. Ta'e Tupàn Tuweharupi Wiko Ma'e uzexak kar izupe a'e pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A'e re Àmàràw oho ywy ywytyr heta haw pe kury. A'e ywy Metew tawhu huwake a'e tawhu wi kwarahy ihemaw kutyr tuz a'e. Umuapyk wàpuzràn a'e pe wiko pà kury. Iker haw wi kwarahy heixe haw kutyr Az tawhu tuz a'e. Àmàràw uzapo ma'ea'yr hapy haw Tupàn henataromo a'e pe no. Umuwete katu Tupàn Tuweharupi Wiko Ma'e a'e pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","A'e wi wata ko rupi amo 'ar rehe, kwe rupi amo ae 'ar rehe. Wata mehe oho iko Kànàà ywy rehe kwarahy ihemaw awyze har kutyr tuweharupi. ");
INSERT INTO gubBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Amo 'ar rehe Kànàà ywy rehe upaw etea'i temi'u teko wanuwi kury. Ta'e àmàn nuhyk kwaw xe. Ima'uhez tuwe teko wà. A'e rupi Àmàràw wata oho Ezit ywy kutyr kury. — Amumaw putar amo zahy a'e pe hereko pà nehe, ta'e heta temi'u a'e pe teko wanupe xe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ezit ywy rehe uhem etea'i mehe Àmàràw uze'eg wemireko Xaraz pe kury. — Ezeapyaka katu heze'eg rehe nehe, i'i izupe. — Ereiko kuzà ipuràg eteahy ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nerexak mehe Ezit ywy rehe har uze'eg putar nezewe uzeupeupe a'e wà nehe. — Kwez kuzà a'e, Àmàràw hemireko romo hekon a'e, i'i putar uzeupeupe a'e wà nehe. A'e rupi hezuka putar wà nehe, ta'e neputar putar a'e wà nehe xe. Nanezuka kwaw wà nehe, i'i Àmàràw wemireko pe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","A'e rupi, — Aiko heinyr romo ihe, ere wanupe nehe. A'e rupi nahezuka kwaw wà nehe, ta'e nepuràg eteahy ne xe. Herereko katu putar wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ezit ywy rehe uhem mehe a'e ywy rehe har wexak hemireko Xaraz a'e wà. — Ipuràg eteahy, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Amo tuwihaw ikàg wera'u ma'e ipytywà har wexak hemireko a'e wà no. Umume'u ipuràg eteahy haw oho uwihawete pe wà. A'e rupi amo weraha hemireko tuwihawete hàpuzuhu pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Xaraz ipuràg eteahy tuwihawete pe, a'e rupi tuwihawete uzapo kar ikatu ma'e Àmàràw pe. Omono ma'ea'yr izupe wà: àràpuhàràn wà, tapi'ak wà, zumen wà, kawaru kupewa'a kamer her ma'e wà. Omono uma'ereko e ma'e izupe wà no: awa wà, kuzà wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tupàn wexak Xaraz pe uzeapo ma'e kwer. A'e rupi uzepyk a'e tuwihawete rehe kury. Uzepyk iànàm wanehe wà no. Umuma'eahy kar ma'eahy haw iaiwahy ma'e pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","A'e rupi tuwihawete wenoz kar Àmàràw imuwà kury. Upuranu hehe. — Màràzàwe tuwe herereko pe nezewe ne, i'i izupe, hehe upuranu pà. — Màràzàwe tuwe neremume'u kwaw Xaraz neremireko romo heko haw ihewe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","— Hereinyr romo hekon a'e, ere ihewe. A'e rupi areko heremireko romo ihe. Nako neremireko xe. Eho xe wi heraha pà nehe, i'i tuwihawete Àmàràw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na'e tuwihawete uze'eg zauxiapekwer wanupe kury. — Eraha Àmàràw Ezit ywy wi pe wà nehe kury, i'i wanupe. Weruzar ize'eg wà. Weraha hemireko wà no, ima'e paw heraha pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Uhem Àmàràw oho Ezit ywy wi wemireko rupi kury, uma'e paw heraha pà no. Oho Kànàà ywy pehegwer kwarahy ihemaw awyze har kutyr har pe kury. I'ir Iro her ma'e oho hupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Hemetarer katu Àmàràw. Heta tetea'u ima'e: tapi'ak wà, ita parat her ma'e, ita or her ma'e. ");
INSERT INTO gubBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Wata ko rupi amo 'ar rehe. Wata kwe rupi amo 'ar rehe. Amo 'ar mehe uhem Metew tawhu pe. A'e wi oho amo ywy rehe. A'e ywy Metew huwake Az huwake tuz a'e. Wamyter pe tuz. A'e 'ym mehe amo 'ar mehe uzapo weko haw a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Uhem a'e Tupàn henataromo ma'ea'yr zuka awer pe kury, wemiapo kwer amo 'ar rehe arer pe kury. Umuwete katu wi Tupàn Tuweharupi Wiko Ma'e a'e pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Iro wata oho iko Àmàràw rupi a'e no. Weraha weimaw tetea'u uzeupi wà no: àràpuhàràn, àràpuhàrànete, tapi'ak. Weraha uma'ereko ma'e uzeupi wà no. Weraha wànàm uzeupi wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Heta tetea'u waneimaw wanupe wà, a'e rupi ka'api'i nuhyk kwaw wanupe. A'e rupi nupuner kwaw uzemono'ogaw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Àmàràw heimaw wanehe uzekaiw ma'e uzàmàtyry'ym Iro heimaw wanehe uzekaiw ma'e oho a'e wà kury. A'e 'ar rehe Kànàà izuapyapyr a'e wà, Perize izuapyapyr a'e wà no, wikuwe a'e ywy rehe a'e wà rihi. ");
INSERT INTO gubBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Amo 'ar mehe Àmàràw uze'eg oho Iro pe a'e kury. — Aiko neànàmete romo ihe. Ereiko heànàmete romo ne. Na'ikatu kwaw zanezeàmàtyry'ymaw. Na'ikatu kwaw ihewe uma'ereko ma'e newe uma'ereko ma'e wazeàmàtyry'ymaw. ");
INSERT INTO gubBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Zazemuza'ak kury ty. Eho amo ywy kutyr ne nehe. Aha putar amo ae ywy kutyr ihe nehe. Ai'aw ywy paw rupi. Exak amo ipehegwer nezeupe nehe. Aze ereho ko rupi nehe, aha putar kwe rupi nehe. Aze ereho kwe rupi nehe, aha putar ko rupi nehe, i'i Àmàràw Iro pe. ");
INSERT INTO gubBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Iro ume'e ywy uzeake har rehe kury. Wexak ywyàpyznaw Zotàw yrykaw izywyr har Zoar tawhu huwake har. Ikatu izupe, ta'e heta tetea'u 'y a'e pe xe. Nuzawy kwaw Tupàn Tuweharupi Wiko Ma'e hemitygwer a'e. Nuzawy kwaw Ezit ywy. Ikatuahy a'e ywyàpyznaw a'e rihi, ta'e Tupàn numumaw kwaw Xotom tawhu a'e rihi xe, numumaw kwaw Komor tawhu a'e rihi xe. ");
INSERT INTO gubBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","A'e rupi Iro wexaexak ywyàpyznaw Zotàw yrykaw izywyr har kury. Wata oho kwarahy ihemaw kutyr kury. Nezewe utyryk uzewi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Àmàràw upyta Kànàà ywy rehe. Iro wiko oho tawhu ywyàpyznaw Zotàw izywyr har rehe har rehe. Uzapo Iro uker haw oho iko, te uhem Xotom tawhu huwake kury. ");
INSERT INTO gubBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Teko iaiw ma'e wiko Xotom tawhu pupe wà. Uzapo iaiwahy ma'e Tupàn Tuweharupi Wiko Ma'e henataromo wà, imuikwahy kar pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Iro oho Àmàràw wi. Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg wà Àmàràw pe kury. — Xe nereko haw pe nereko mehe eme'egatu kwarahy ihemaw awyze har kutyr kury, kwarahy heixe haw awyze har kutyr no, kwarahy ihemaw kutyr no, kwarahy heixe haw kutyr no. ");
INSERT INTO gubBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ko ywy neremixak kwer paw amono putar newe nehe, nezuapyapyr wanupe nehe no. Peiko putar izar romo tuweharupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Amueta tetea'u kar putar nezuapyapyr ihe wà nehe. Waneta haw nuzawy kwaw ywy ku'i kwer heta haw wà nehe. Ni amo nupuner kwaw ywy ku'i kwer wapapar haw rehe wà. Nezewegatete ni amo nupuner kwaw nezuapyapyr wapapar haw rehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","A'e rupi eata eho ko ywy rehe nehe, heixe haw awyze har kutyr har wi nehe, ihemaw awyze har kutyr har pe nehe, kwarahy ihemaw kutyr har wi nehe, kwarahy heixe haw kutyr har pe nehe no, ta'e amono putar newe ihe nehe xe, i'i Tupàn Àmàràw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","A'e rupi Àmàràw umuàgà'ym wàpuzràn wata àwàm rehe kury. Uzapo weko haw oho ywyra Manire ywy rehe har Tupàn pe imonokatu pyrer huwake a'e kury. Emerom tawhu huwake upyta. A'e pe Àmàràw uzapo amo ma'ea'yr hapy haw Tupàn henataromo a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","A'e 'ar rehe heta 4 tawhu a'e ywy rehe. Pitàitàigatu heta tawhu pe har wanuwihawete a'e wà no. Arapew wiko Xinar tawhu pe har wanuwihawete romo. Ariok wiko Erazar tawhu pe har wanuwihawete romo. Kenoraomer wiko Eràw tawhu pe har wanuwihawete romo. Xinaw wiko Koim tawhu pe har wanuwihawete romo. ");
INSERT INTO gubBl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Amo 'ar mehe a'e 4 tuwihawete uzàmàtyry'ym amo ae 5 tuwihawete oho a'e wà kury. Amume'u putar amogwer tawhu waner xe ihe wà, wanuwihawete waner xe ihe wà no. Mer wiko Xotom tawhu pe har wanuwihawete romo. Mirixa wiko Komor tawhu pe har wanuwihawete romo. Xinawe wiko Anima tawhu pe har wanuwihawete romo. Xemewer wiko Zemoim tawhu pe har wanuwihawete romo. Heta amo tuwihawete no. Mera tawhu pe har wanuwihawete romo hekon a'e. Heta amo her a'e tawhu pe no. Zoar her inugwer romo. ");
INSERT INTO gubBl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Na'e a'e 5 tuwihawete omono'og wemiruze'eg zauxiapekwer a'e wà kury, ywyàpyznaw Yryhu Umàno Ma'e Kwer her ma'e huwake har rehe a'e wà kury. Xinim a'e ywy her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tuwihawete Kenoraomer her ma'e a'e, umumaw 12 kwarahy a'e 5 tawhu pe har waneruze'eg pà a'e. 13 haw kwarahy rehe a'e 5 tawhu pe har wikwahy tuwihawete Kenoraomer pe wà kury. — Naxiputar kwaw a'e tuwihawete zanezar romo zane. A'e rupi xiàmàtyry'ym zaha zane nehe kury, i'i uzeupeupe wà. Omono kar zauxiapekwer ikutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","14 haw kwarahy rehe Kenoraomer hemiruze'eg zauxiapekwer paw a'e wà kury, weityk a'e zauxiapekwer a'e 5 tawhu pe har a'e wà kury. Weityk zauxiapekwer Hepai her ma'e Aterot-Karanai tawhu pe wà. Weityk zauxiapekwer Zuz her ma'e Hà tawhu pe wà. Weityk zauxiapekwer Emi her ma'e Xawe-Kiriatai tawhu pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Weityk zauxiapekwer Ore her ma'e ywytyr Xeir Enom ywy rehe har rehe wà no. Uzuka zauxiapekwer tetea'u wà. Umuzàn kar amogwer wà. A'e zauxiapekwer uzàn ma'e kwer uzàn oho Ewpàrà ywy kutyr wà. Ywyxiguhu uzypyrog a'e pe, Ewpàrà ywy izywyr. ");
INSERT INTO gubBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","A'e re Kenoraomer hemiruze'eg zauxiapekwer a'e wà, inugwer zauxiapekwer wazuka arer a'e wà no, uzewyr Kanez tawhu pe a'e wà kury. A'e 'ar rehe heta amo ae her a'e tawhu pe. En-Mipat her inugwer romo. A'e zauxiapekwer uzàmàtyry'ym Amarek ywy rehe har oho wà kury, teko wazuka pà wà, wama'e ipyhyk pà uzeupe wà. Weityk Amohe ywy rehe har Azàzàw-Tamar tawhu pe har wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na'e a'e 5 tuwihawete omono'og wemiruze'eg zauxiapekwer oho wà kury: Xotom tawhu, Komor tawhu, Anima tawhu, Zemoim tawhu, Mera tawhu. ");
INSERT INTO gubBl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Oho ywy Xinim her ma'e pe wà kury, a'e 4 tuwihawete wanemiruze'eg zauxiapekwer waàmàtyry'ym pà wà kury. Eràw tawhu, Koim tawhu, Xinaw, Erazar. Nezewe mehe 4 tuwihawete uzàmàtyry'ym inugwer 5 tuwihawete a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Heta tetea'u ywykwar ywyàpyznaw Xinim her ma'e rehe, heta tetea'u iraityràn a'e pe no. A'e rupi Xotom pe har wanuwihaw a'e, Komor pe har wanuwihawete a'e no, uzeagaw zeàmàtyry'ymawhu wi uzàn pà a'e wà. Nupuner kwaw a'e wi uhemaw rehe wà, ta'e u'ar a'e ywykwar pupe a'e wà xe. Amogwer tuwihawete uzàn oho ywytyr kutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A'e rupi a'e 4 tuwihawete a'e wà, upyhyk temi'u Xotom pe har Komor pe har upaw rupi a'e wà. Upyhyk ma'e hekuzar katu ma'e a'e tawhu pe har paw wà no. Oho a'e wi wà, a'e ma'e paw heraha pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Iro a'e, Àmàràw i'ir a'e, wikuwe Xotom tawhu pe a'e 'ar rehe a'e. A'e rupi a'e tuwihawete weraha Iro uzeupi wemipyhyk kwer romo a'e wà no. Weraha ima'e paw uzeupi wà no. Ipurumuigo kar wer hehe uma'ereko e ma'e romo uzeupe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Amo awa uzàn zauxiapekwer wanuwi wame'e 'ym mehe a'e. Umume'u uzeapo ma'e kwer paw oho Àmàràw pe. A'e 'ar rehe Àmàràw Emerew wikuwe ywyra Tupàn pe imonokatu pyrer huwake a'e. Manire Amohe ywy rehe har wiko a'e ywyra izar romo a'e. Manire a'e, tywyr Eko a'e no, tywyr Aner a'e no, wiko Àmàràw imyrypar romo a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","I'ir ipyhyk awer ikwaw mehe Àmàràw omono'og wemiruze'eg zauxiapekwer a'e wà kury. Paw rupi wiko heko haw pe uzexak kar ma'e kwer romo wà. Heta 318 wà. Àmàràw oho wanupi. Uzàn oho a'e 4 tuwihawete wanaikweromo wà. A'e 4 tuwihawete umupytu'u kar wemiruze'eg Nà tawhu pe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Àmàràw uhem a'e tawhu huwake a'e wà kury. Umuza'aza'ak wemiruze'eg zauxiapekwer mokoz imono'og pyrer romo wà kury. Pyhaw uzàmàtyry'ym a'e 4 tuwihawete wanemiruze'eg oho wà. Weityk amo wà. Uzuka zauxiapekwer tetea'u wà, amogwer wamuzàn kar pà Oma tawhu kutyr wà. A'e pe uzuka amo wà no. Oma tawhu a'e, Namaz tawhu huwake kwarahy heixe haw awyze har kutyr tuz a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A'e pe Àmàràw upyhyk a'e ma'e wanemiraha kwer paw heruzewyr pà heruwà weko haw pe. Werur uwi'ir Iro uzeupi no, ima'e paw no, hemireko wà no, hemiaihu wà no. Upaw rupi werur weko haw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","A'e re, Kenoraomer heityk ire, amogwer tuwihawete waneityk ire, uzewyr Àmàràw oho iko weko haw kutyr kury. Xotom tawhu pe har wanuwihawete uwàxi Àmàràw oho ywy Xawe yrykaw izywyr har rehe a'e kury. Tuwihawete iziwy amo a'e ywy her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mekizetek a'e, Xarez tawhu pe har wanuwihawete a'e, xaxeto Tupàn Ywate Wera'u Har henataromo har a'e, werur typy'ak a'e pe a'e kury. Werur uwà tykwer win her ma'e a'e pe no. ");
INSERT INTO gubBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mekizetek omono uze'egatu Àmàràw rehe kury. Nezewe i'i a'e. Tupàn Ywate Wera'u Har a'e, ywak iapo arer ywy iapo arer a'e, Tuwe omono uze'egatu nerehe a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ximume'u Tupàn Ywate Wera'u Har ikatu haw izupe nehe, teko wanupe nehe no. Ta'e umur peàmàtyry'ymar kwez pepo pe a'e wà kury xe, i'i izupe. Na'e Àmàràw omono ma'e wemirur kwer ikurer Mekizetek pe kury. Aze heta 10 ma'e, omono pitài izupe. Ma'e imono pyr omono izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A'e re Xotom pe har wanuwihawete uze'eg Àmàràw pe kury. — Epyhyk ma'e neremipyhyk kwer nezeupe nehe. Xo teko heànàm zo emuzewyr ihewe ne wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Àmàràw uwazar ize'eg izupe kury. — Aupir hepo Tupàn Tuweharupi Wiko Ma'e henataromo ihe kury. Tupàn Ywate Wera'u Ma'e romo ywak ywy iapo arer romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Amume'uahy putar heremiapo ràm ihe kury. Napyhyk pixik kwaw ni pitài nema'e ihe nehe, ni inemu'i nehe, ni xapat ihàm nehe. Nezewe mehe — Kwa, amuigo kar Àmàràw hemetarer katu ma'e romo ihe, nerepuner pixik kwaw ne'e haw rehe nehe, i'i Àmàràw a'e tuwihawete pe. ");
INSERT INTO gubBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","— Naputar kwaw nema'e. Xo heremiruze'eg wanemi'u apyhyk kwez newi. Naputar kwaw amo. Heta na'iruz hemyrypar wà: Aner, Eko, Manire. A'e ae upuner ma'e ipyhykaw rehe pitàitàigatu uzeupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Amo 'ar rehe Àmàràw wexak amo ma'e upuahu pe har zàwenugar a'e kury. Hexak mehe Tupàn Tuweharupi Wiko Ma'e uze'eg wà izupe. — Ekyze zo nehe, Àmàràw. Urupyro putar ikatu 'ymaw paw wi ihe nehe. Amono putar ma'e tetea'u newe nehe, neremiapo kwer hekuzaromo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Uwazar Àmàràw ize'eg izupe kury. — O hezar. O Tupàn Tuweharupi Wiko Ma'e. Ma'e neremimur ràm ikatu wewer putar ihewe nehe. Naputar kwaw nehe, ta'e naheta pixik kwaw hera'yr ihewe xe. Ni pitài naheta kwaw ihewe. Eriezer Namaz tawhu pe har a'e nehe, upyhyk putar hema'e kwer hemàno re upaw rupi a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Neremur kwaw hera'yr ihewe ne wà, a'e rupi amo ihewe uma'ereko ma'e a'e nehe, hereko haw pe uzexak kar ma'e a'e nehe, upyhyk putar hema'e kwer hemàno re a'e nehe, i'i Àmàràw Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e izupe. — Nera'yrete wiko putar nema'e kwer ipyhyk àràm romo nemàno re a'e nehe. Newe uma'ereko ma'e Eriezer nupyhyk kwaw nema'e kwer nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Na'e Tupàn Tuweharupi Wiko Ma'e weraha Àmàràw hàpuz wi katu pe kury, izupe uze'eg pà kury. — Eme'e ywate. Epapar zahytata, aze erepuner. Azeharomoete nezuapyapyr waneta àwàm nuzawy kwaw zahytata waneta haw nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Àmàràw uzeruzar tuwe Tupàn Tuweharupi Wiko Ma'e rehe kury. A'e rupi, — Nekatu ihewe, i'i Tupàn izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e izupe, — Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Kwehe mehe urupyro Mawiron ywy wi Ur tawhu wi ihe, ta'e heporomono wer ko ywy rehe newe nereko haw romo ihe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","— O hezar, O Tupàn Tuweharupi Wiko Ma'e ne, i'i Àmàràw izupe. — Màràzàwe akwaw putar ko ywy heywy romo heko àwàm ihe nehe, i'i izupe, hehe upuranu pà. ");
INSERT INTO gubBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Uwazar Tupàn Tuweharupi Wiko Ma'e ize'eg izupe. — Erur amo tapi'ak kuzà xe ihewe nehe kury. Erur amo àràpuhàrànete amo àràpuhàràn hawitu ma'e rehe we nehe no, paw rupi na'iruz kwarahy hereko har wà nehe. Erur amo pyku'i nehe no, amo pykahu nehe no, i'i Tupàn izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Àmàràw upyhyk a'e ma'ea'yr ize'eg rupi katete wà kury, waneraha pà Tupàn Tuweharupi Wiko Ma'e pe wà kury. Upei'ài'àg pitàitàigatu mokoz pehegwer romo wà. Amo tapi'ak ipehegwer omono xe, inugwer ipehegwer huwake. Nezewegatete omono amo ma'ea'yr ipehegwer inugwer pehegwer huwake. Nupei'ài'àg kwaw wiràmiri wà. ");
INSERT INTO gubBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na'e apitaw uzypyrog wezyw pà a'e ma'ea'yr wa'aromo wà kury. Àmàràw umuwewe kar a'e wi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ikaruk etea'i mehe Àmàràw uker tuwe kury. A'e 'ar mehe we uker mehe we ukyze tuwe kury. Ikyzeahy haw wiko izar romo. ");
INSERT INTO gubBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Na'e uze'eg Tupàn Tuweharupi Wiko Ma'e kury. — Ekwaw katu ko ma'e nehe. Nezuapyapyr wikuwe putar oho amo ae ywy rehe a'e wà nehe. A'e pe uma'ereko e putar amo wanupe wà nehe. A'e pe har upuraraw kar putar ma'erahy nezuapyapyr wanupe wà nehe. Umumaw putar 400 kwarahy a'e ywy rehe ma'erahy ipuraraw pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ihe azepyk putar teko a'e ywy rehe har wanehe ihe nehe, nezuapyapyr wanupe ma'erahy ipuraraw kar har wanehe ihe nehe. Amo 'ar mehe nezuapyapyr uhem putar oho a'e ywy wi wà nehe, temetarer tetea'u heraha pà uzeupi wà nehe, ma'e hekuzar katu ma'e tetea'u heraha pà wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Na'e amo 'ar mehe netua'uete mehe nereko haw ikatuahy putar nehe, eremàno putar nerurywete haw inuromo nehe. Utym putar neretekwer wà nehe. A'e re ereho putar neipy wapyr nehe, umàno ma'e kwer wapyta haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nera'yr upurumuzàg putar wà nehe. Wana'yr upurumuzàg putar wà nehe no. Wana'yr upurumuzàg putar wà nehe no. Wana'yr upurumuzàg putar wà nehe no. 4 haw wapurumuzàmuzàg ire nezuapyapyr uzewyr putar xe wà nehe. Namuhem kar kwaw xe har Amohe her ma'e ihe wà rihi. Amo 'ar mehe, iaiw tuwe ma'e romo waneko mehe amuhem kar putar xe wi ihe wà nehe, ta'e a'e 'ar mehe ikatu putar wanehe hezepyk àwàm ihewe nehe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pyhaw kury. Ipytunahy. Tàrityka'i uzexak kar tàtàpyzgwer hyru a'e pe kury. Tàtàxiner uhem wà izuwi. Uzexak kar amo tatainy a'e pe no. A'e tàtàpyzgwer a'e, tatainy a'e no, ukwaw oho a'e ma'ea'yr pehegwer wamyter romo a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","A'e 'ar mehe we Tupàn Tuweharupi Wiko Ma'e uzapokatu uze'egaw Àmàràw rehe we kury. — Amono putar ko ywy nezuapyapyr wanupe ihe nehe. Ko ywy uzypyrog Ezit ywy izywyr. Oho yrykaw Ewparat pe. ");
INSERT INTO gubBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nezuapyapyr upyhyk putar ywy amo teko waneko haw wà nehe: Kene izuapyapyr wà, Keneze izuapyapyr wà, Kazimone izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Etew izuapyapyr wà, Perize izuapyapyr izuapyapyr wà, Hepai izuapyapyr wà, ");
INSERT INTO gubBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amohe ywy rehe har wà, Kànàà izuapyapyr wà, Zirikaze izuapyapyr wà, Zepuze izuapyapyr wà. Upaw rupi katete waiwy amono putar newe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Xaraz Àmàràw hemireko na'imemyr kwaw a'e rihi. Àmàràw nata'yr kwaw a'e. Heta amo kuzà uma'ereko e ma'e Ezit ywy rehe har Xaraz pe. Agar her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Amo 'ar rehe Xaraz uze'eg Àmàràw pe kury. — Tupàn Tuweharupi Wiko Ma'e nehemumemyr kar kwaw a'e. A'e rupi eker eho ko kuzà ihewe uma'ereko ma'e puhe nehe 'y. Nezewe mehe zo ru'u apuner hememyr haw rehe aipo ihe no 'y, i'i umen pe. — He'e, i'i imen izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","A'e rupi omono Agar umen pe kury, hemirekoagaw romo kury. A'e 'ym mehe Àmàràw umumaw 10 kwarahy Kànàà ywy rehe wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Uker Àmàràw oho Agar puhe. Ipuru'a kury. Upuru'a haw ikwaw mehe Agar uzypyrog uze'eg pà upy'a pe. — Kwa, aiko wera'u Xaraz wi ihe, ta'e na'ipuru'a kwaw a'e 'y. Ihe hepuru'a ihe kury, i'i uzeupe. Ima'enukwaw zemueteahy uzar rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Na'e Xaraz uze'eg Àmàràw pe kury. — Agar uze'eg zemueteahy iko herehe a'e, ta'e eremumuru'a ne 'y, i'i izupe. — Ihe ae amono newe ihe. Ukwaw upuru'a haw kury, a'e rupi herereko uzemueteahy haw romo a'e kury. Aze ru'u ne erezapo ikatu 'ym ma'e Tupàn henataromo, aze ru'u ihe azapo ikatu 'ym ma'e henataromo. Tuwe Tupàn Tuweharupi Wikuwe Ma'e umume'u ikatu 'ym ma'e iapo arer nehe. Aze ru'u ne, aze ru'u ihe, i'i umen pe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Uwazar Àmàràw ize'eg izupe. — Ne kutu erekwaw. Agar wiko newe uma'ereko e ma'e romo a'e. Ne ae erezapo kar ma'e izupe. A'e rupi ezapo neremimutar izupe nehe, i'i izupe. A'e rupi Xaraz uzypyrog ma'erahy ipuraraw kar pà Agar pe kury. Tuweharupi uzapo ikatu 'ym ma'e izupe. A'e rupi amo 'ar rehe Agar uzàn oho a'e wi izuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tupàn Tuweharupi Wiko Ma'e weko haw pe har zàwenugar romo uzeapo ma'e kwer wexak Agar oho ywyxig heta haw pe heko mehe. Wiko amo 'yzygwar huwake a'e 'ar rehe. Xur tawhu piar izywyr hin a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Upuranu Tupàn heko haw pe har Agar rehe kury. — Agar, Xaraz pe uma'ereko e ma'e ne, ma'e wi erezur iko ne, ma'e pe ereho putar nehe, i'i izupe. — Àzàn tuwà iteko hezar wi ihe 'y, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","A'e rupi a'e Tupàn heko haw pe har umume'u hemiapo ràm izupe kury. — Ezewyr eho nezar pe nehe, ezapo hemiapo kar upaw rupi nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nezuapyapyr amuigo kar putar teko tetea'u romo ihe wà nehe. Azeharomoete heta tetea'u putar wà nehe. Ni amo nupuner kwaw wapapar haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nepuru'a kury. Awa uzexak kar putar newe nehe. Emono Izimaew her romo izupe nehe. Ta'e Tupàn wenu nerehapukaz tawer ma'erahy ipuraraw mehe a'e xe. (Izimaew a'e, — Tupàn zanerenu katu, i'i zaneze'eg rupi a'e). ");
INSERT INTO gubBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nememyr awa a'e nehe, zumen hehaite ma'e zàwe hekon putar a'e nehe. Uzàmàtyry'ym putar amogwer teko upaw rupi katete a'e wà nehe. Amogwer teko uzàmàtyry'ym putar nememyr awa upaw rupi katete a'e wà nehe no. Uzapo putar weko àwàm muite a'u amogwer wànàm wanuwi nehe, i'i Tupàn heko haw pe har kuzà pe. ");
INSERT INTO gubBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Na'e Agar omono amo ae her Tupàn Tuweharupi Wiko Ma'e pe kury. — Tupàn ma'e hexakar, i'i a'e her pyahu. Omono a'e her izupe ta'e Tupàn uze'eg wà izupe a'e xe. Ta'e upuranu uzehe nezewe a'e xe. — Aze ru'u aexak herexakar ihe. Aipo aexak tuwe ihe, i'i uzeupe, uzehe upuranu pà. ");
INSERT INTO gubBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","A'e rupi teko a'e wà, — 'Yzygwar herexakar wikuwe ma'e, i'i izupe a'e pe a'e wà kury. Kanez tawhu huwake Mere tawhu huwake hin a'e. Wamyter pe hin. ");
INSERT INTO gubBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Uzexak kar Agar imemyr a'e kury. Agar omono umemyr Àmàràw pe ta'yr romo kury. Omono Izimaew her romo. ");
INSERT INTO gubBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Àmàràw wereko 86 kwarahy Izimaew izexak kar mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Umumaw amo kwarahy. Àmàràw wereko 99 kwarahy kury. Na'e Tupàn Tuweharupi Wiko Ma'e uzexak kar wà izupe a'e kury. Uze'eg izupe, — Tupàn upuner wera'u ma'e romo aiko ihe. Eze'eg eho iko ihewe tuweharupi nehe. Ezapo heremimutar eho iko tuweharupi nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Azapokatu putar heze'egaw nerehe we nehe. Amono putar nezuapyapyr tetea'u newe ihe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Na'e Àmàràw wapyk upenàràg rehe kury. Uhyk uwa ywy rehe. Uze'eg Tupàn izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","— Ko heze'egaw azapokatu putar nerehe we kutàri ihe kury. Ereiko putar teko tetea'u wanu romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tàrityka'i amono putar amo ae nerer newe nehe kury. Àmàràw, a'e iteko newe kury. Kutàrigwepe kury, Àmàrààw, a'e putar newe ihe nehe. Ko 'ar rehe nehe, amo 'ar rehe nehe no. Ta'e urumuigo kar putar teko tetea'u wanu romo ihe nehe xe. — Teko tetea'u wanu, i'i Àmàrààw her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Amueta tetea'u putar nezuapyapyr ihe wà nehe. Amo nezuapyapyr wiko putar tuwihawete romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Azapokatu tuwe ko heze'egaw nerehe we. Nazewyr pixik kwaw izuwi nehe. Nahereharaz pixik kwaw izuwi nehe. Amume'u kwez newe. Amume'u putar nezuapyapyr wanupe nehe no. Ihe Tupàn ihe, tuweharupi aiko putar nezar romo ihe nehe, aiko putar nezuapyapyr wazar romo ihe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ereiko ko ywy rehe amo ae ywy rehe har zàwegatete. Amono putar ko ywy newe nehe, nezuapyapyr wanupe nehe no. Nezuapyapyr wiko putar Kànàà izuapyapyr waiwy nànàn wà nehe, tuweharupi wà nehe. Aiko putar wazar romo ihe nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Uze'eg wi Tupàn izupe kury. — Ne Àmàrààw ne, ereruzar putar heze'eg tuweharupi nehe. Nezuapyapyr weruzar putar heze'eg tuweharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Azapokatu tuwe heze'egaw kwez nerehe we kury, nezuapyapyr wanehe we no. A'e rupi, ezapo ma'e nezar romo hereko haw hexak kar pà nehe kury. Emonohok kar nepirera'i nezewi nehe. Awa nereko haw pe har paw omonohok kar putar upirera'i a'e wà nehe no, uzar romo hereko haw hexak kar pà purupe a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Pirera'i imonohok kar haw ukwaw kar putar heze'egaw heremiapo katu kwer purupe nehe, pezar romo hereko haw hexak kar pà purupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ko 'ar henataromo nehe, tuweharupi nehe, pemonohok kar putar pena'yr wapirera'i upaw rupi pe wà nehe. Wazexak kar ire nehe, tuwe pemumaw 8 'ar nehe. A'e mehe pemonohok kar wapirera'i nehe. Pezapo nezewegatete uma'ereko e ma'e wana'yr peneko haw pe uzexak kar ma'e ràm wanupe nehe no, uma'ereko e ma'e amo ae ywy rehe penemime'eg karer wanupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Pemonohok kwarer peneko haw pe har wapirera'i paw rupi pe wà nehe. Ni pitài nupyta kwaw imonohok 'ym pà nehe. Pirera'i monohokaw nuzawy kwaw herer wanetekwer rehe imuapyk pyrer nehe. A'e rupi teko ukwaw putar heze'egaw heremiapo katu kwer ipaw pixik 'ym àwàm a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aze amo nomonohok kar kwaw upirera'i nehe, nupuner kwaw pepyr weko haw rehe nehe, ta'e numuawate kwaw heze'egaw heremiapo katu kwer a'e xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","A'e re Tupàn uze'eg wi Àmàrààw pe kury. — Ko 'ar rehe, — Xaraz, ere neremireko pe. Epytu'u nezewe ne'e re nehe. — Xar, ere izupe nehe kury. — Tuwihawete tazyr, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Amono putar heze'egatu neremireko rehe nehe. Amono putar kwarera'i izupe nera'yr romo nehe. Azeharomoete amono putar heze'egatu hehe nehe. Wiko putar teko tetea'u wahy romo nehe. Amo izuapyapyr wiko putar tuwihawete romo a'e wà nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Wapyk Àmàrààw upenàràg rehe kury. Umuhyk uwa ywy rehe. Uzypyrog upuka pà. Uze'eg nezewe uzeupe. — Aipo heta putar ta'yr amo awa 100 kwarahy hereko har pe. Heta 90 kwarahy Xar a'e no. Aipo upuner umemyr haw rehe azeharomoete nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Na'e uze'eg Tupàn pe kury. — Aze mo Izimaew wiko neze'egatu hereko pà, ikatu mo ihewe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Uze'eg wi Tupàn izupe. — Amume'u Xar neremireko imemyr àwàm kwez newe ihe. Umur putar kwarer newe nera'yr romo nehe. — Izak, eremono putar izupe her romo nehe. — Upuka, i'i her zaneze'eg rupi. Azapo putar ma'e heze'eg heremimume'u kwer rupi katete Izak pe nehe, izuapyapyr wanupe nehe no, tuweharupi nehe, awyze har rupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Emono neze'egatu Izimaew rehe nehe, ere ihewe. Amono putar heze'egatu hehe ihe nehe no. Heta tetea'u putar ta'yr izupe wà nehe no. Heta tetea'u putar izuapyapyr izupe wà nehe no. Umuzàg putar 12 tuwihawete a'e wà nehe. Amuigo kar putar izuapyapyr teko ikàg ma'e tetea'u romo ihe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Heze'eg heremimume'u kwer azeharomoete har rupi azapo putar ma'e Izak nera'yr pe ihe nehe. Uzexak kar putar nera'yr Izak neremireko pe ko 'ar rehe amo kwarahy rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Àmàrààw pe uze'eg pawire uzeupir Tupàn a'e kury, a'e pe hezar pà a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","A'e 'ar mehe we Àmàrààw uzapo ma'e Tupàn ze'eg rupi katete. Omonohok wa'yr Izimaew ipirera'i oho izuwi kury. Uzapo nezewegatete amogwer awa weko haw pe har nànàn no, uma'ereko e ma'e weko haw pe uzexak kar ma'e kwer wanupe, amo ae ywy rehe wemime'eg karer wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Àmàrààw wereko 99 kwarahy upirera'i imonohok kar mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ta'yr Izimaew wereko 13 kwarahy a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Àmàrààw omonohok kar upirera'i. A'e 'ar mehe we omonohok wa'yr ipirera'i izuwi no. ");
INSERT INTO gubBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Uzapo nezewegatete haw uma'ereko e ma'e nànàn no, weko haw pe uzexak kar ma'e wanupe, amo ae ywy rehe ime'eg kar pyrer wanupe no. Upaw rupi katete awa omonohok kar upirera'i a'e 'ar mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Tupàn Tuweharupi Wiko Ma'e uzexak kar Àmàrààw pe a'e kury, ywyra tyw Manire her ma'e pe a'e kury. (Teko omonokatu a'e ywyra Tupàn pe wà.) Kwarahy ywy imuaku wera'u kar mehe uzexak kar izupe. Àmàrààw wapyk in wàpuz huken huwake. ");
INSERT INTO gubBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ume'e pe pe kury. Wexak na'iruz awa wà. U'àm pepa'i wà. Hexak mehe uzàn oho wanuwàxi mà. Wapyk upenàràg rehe. Umuhyk uwa ywy rehe wanupe uze'eg pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","— Hezar wà, aze hekatu penenataromo nehe, pekwaw zo hereko haw huwake pepytu'u 'ym pà nehe. Pepytu'u xe hereko haw pe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","— Arur kar putar 'y heremiruze'eg wanupe nehe, peme nehe. A'e mehe pepuner pezepyez taw rehe nehe. A'e re pepytu'u putar xe ywyra iwype nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","— Arur putar temi'u pixik peme nehe no. Nezewe mehe pekàgaw uzewyr putar peme nehe. A'e mehe pepuner peata wi haw rehe nehe, i'i wanupe. — Hemuwete pe xe hepyr pezur mehe. A'e rupi, tuwe azapo ikatu ma'e peme nehe, i'i wanupe. Uze'eg wi izupe wà. — Ikatu. Ezapo a'e ma'e neremimume'u kwer rupi nehe kury, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Uzàn Àmàrààw oho wàpuzràn pupe kury, wemireko Xar pe uze'eg pà kury. — Tàrityka'i epyhyk 10 kir arozràn imuku'i pyrer nehe, ezapo typy'ak nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","A'e re uzàn tapi'ak wamono'ogaw pe kury. Wexak amo tapi'aka'yr ipyahu ma'e kury. Omono wemiruze'eg pe. Hemiruze'eg uzuka tapi'ak imuàgà'ym pà a'e awa wanemi'u ràm romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Àmàrààw upyhyk tapi'ak kamykwer imuazahy kar pyrer. Upyhyk tapi'ak kamykwer no. Upyhyk ma'ero'o kwer imuàgà'ym pyrer no. Weraha a'e weko haw pe uhem ma'e kwer wanupe kury. A'e pe ywyra iwype u'u kar a'e temi'u a'e na'iruz awa wanupe. Ume'e wanehe wamai'u mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na'e upuranu hehe wà. — Ma'e pe wiko neremireko Xar a'e, i'i izupe wà. — Heràpuzràn pupe hekon, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Amo i'i Àmàrààw pe. — Kwezomo kwarahy mehe azewyr wi putar xe nerexak pà ihe nehe. A'e kwarahy mehe ko zahy rehe heta putar imemyr Xar pe nehe, i'i izupe. Xar u'àm Àmàrààw hakykwepe a'e 'ar mehe we a'e, tàpuzràn hukenaw huwake a'e. Wenu waze'eg mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Àmàrààw tua'uhez tuwe a'e, Xar ihya'uhez a'e no. A'e rupi Xar nupuner kwaw umemyr haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","A'e rupi Xar upuka upy'a pe kury. — Hehya'uhez ihe. Hezar itua'uhez a'e no. Aipo apuner agwer ikatuahy haw ikwaw paw rehe hemen puhe ihe nehe, i'i uzeupe upy'a pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Na'e Tupàn Tuweharupi Wiko Ma'e upuranu wi Àmàrààw rehe kury. — Màràzàwe tuwe upuka Xar a'e, i'i izupe. — Hehya'uhez wera'u ihe, a'e rupi napuner kwaw hememyr haw rehe ihe, i'i kwez uzeupe kury. Màràzàwe tuwe uze'eg nezewe, i'i Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","— Aipo Tupàn nupuner kwaw wyzài ma'e iapo haw rehe, i'i izupe, hehe upuranu pà. Ko ma'e amume'u kwez newe. — Kwezomo kwarahy mehe azewyr putar xe nerexak pà ihe nehe. A'e kwarahy rehe ko zahy rehe heta putar imemyr Xar pe nehe, a'e kwez newe, i'i wi izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ize'eg henu mehe Xar ukyze izuwi kury. — Naze'eg kwaw nezewe ihe, i'i mua'u wer izupe. — Napuka kwaw kwez ihe, i'i izupe. Tupàn Tuweharupi Wiko Ma'e uze'eg wi izupe. — Neremu'em kwez ne. Erepuka tuwe kwez ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na'e a'e awa Àmàrààw heko haw pe upytu'u ma'e kwer oho amo me a'e wà kury. Àmàrààw wata oho wanupi, wanape ràm hexak kar pà wanupe. Ipurexak wer Xotom tawhu rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg uzeupe kury. — Nazumim kwaw heremiapo ràm Àmàrààw wi ihe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","— Izuapyapyr a'e wà nehe, heta tetea'u putar a'e wà nehe, ikàg putar a'e wà nehe no. Wanexak mehe amogwer teko ywy rehe har paw ukwaw putar hekatu haw a'e wà nehe. — Emur neze'egatu urerehe nehe, i'i putar ihewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Aexak Àmàrààw hezeupe ihe. A'e rupi uzapo kar heremimume'u ràm wa'yr wanupe nehe, uzuapyapyr wanupe nehe no. A'e rupi izuapyapyr uzapo putar ikatuahy ma'e wà nehe, heze'eg iawy 'ym pà wà nehe. Aze weruzar tuwe heze'eg wà nehe, azapo putar heremimume'u kwer upaw rupi katete ihe nehe, ikatuahy ma'e purupe iapo pà Àmàrààw rehe ihe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","A'e rupi Tupàn Tuweharupi Wiko Ma'e uze'eg Àmàrààw pe kury. — Amo umume'u Xotom tawhu pe har wanemiapo kwer ikatu 'ym ma'e ihewe wà. Umume'u Komor tawhu pe har wanemiapo kwer ihewe wà no. — Iaiw tuwe wanemiapo kwer, i'i ihewe wà. Iaiw tuwe wanemiapo ihewe. Iro ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Awezyw putar aha a'e pe wapyr ihe nehe kury, waneko haw hexak pà wanemiapo hexak pà ihe nehe kury. Nezewe akwaw putar a'e imume'u pyrer nehe. Aze ru'u azeharomoete, aze ru'u temu'em, i'i Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Na'e mokoz awa Àmàrààw ipyr har uhem oho Xotom tawhu kutyr wà kury. Àmàrààw upyta a'e pe Tupàn Tuweharupi Wiko Ma'e rehe we. ");
INSERT INTO gubBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Uhem Àmàrààw huwakea'i hehe upuranu pà. — Aipo erezuka putar teko ikatu ma'e amogwer teko iaiw ma'e wainuromo ne wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","— Aze ru'u heta 50 teko ikatu ma'e a'e tawhu pe wà. Aze heta 50 wà nehe, aipo eremumaw putar tawhu ne nehe, i'i izupe. — Aipo nanereharaz kwaw wanemiapo kwer wi nehe, a'e 50 ikatu ma'e neremiamutar wapyro pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nerezuka kwaw ikatu ma'e ikatu 'ym ma'e wainuromo ne wà nehe. Ta'e ikatu ma'e nuzapo kwaw iaiw ma'e amogwer wazàwe wà xe. Ezuka zo a'e paw rupi ne wà nehe. Ereiko teko wanemiapo kwer ikwaw par romo ne, ikatu 'ym ma'e wanehe uzepyk ma'e romo ne. A'e rupi nerezepyk kwaw ikatu ma'e wanehe nehe, i'i Àmàrààw Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tupàn uze'eg wi izupe. — Aze aexak 50 teko ikatu ma'e Xotom tawhu pe ihe wà nehe, hereharaz putar a'e pe har wanemiapo kwer wi upaw rupi ihe nehe, a'e 50 teko wakatu haw hekuzaromo ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Uze'eg wi Àmàrààw izupe kury. — Aze'eg wi putar nehe kury. Aze heze'eg àwàm na'ikatu kwaw nehe, ezepyk zo herehe nehe, ta'e ereiko teko paw wazar romo ne xe. Ihe aiko umàno ma'e ràm ikàg 'ym ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Aze ru'u heta xo 45 teko ikatu ma'e zo wà nehe. Nezewe azo'ok 5 teko a'e 50 teko wanuwi ihe wà. Aipo eremumaw putar tawhu a'e 5 teko wanehe nehe, i'i izupe. Uze'eg wi Tupàn izupe. — Aze heta xo 45 teko ikatu ma'e zo wà nehe, naityk kwaw tawhu ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","— Aze heta xo 40 teko ikatu ma'e zo wà nehe, i'i izupe. Uze'eg wi Tupàn izupe. — Azamutar katu a'e 40 teko ihe wà, a'e rupi nazuka kwaw tawhu pe har ihe wà nehe, naityk kwaw tawhu ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Uze'eg wi Àmàrààw izupe. — Eikwahy zo ihewe nehe, hezar, heze'eg wi haw rehe nehe. Aze heta 30 wà nehe, i'i izupe. — Aze heta 30 wà nehe, hereharaz putar tawhu pe har wanemiapo kwer wi ihe nehe, i'i Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Uze'eg wi Àmàrààw. — Azeharomoete uruputupyk iteko ihe, hezar. Aze heta 20 wà nehe, i'i izupe. — Azamutar katu a'e 20 ihe wà nehe, a'e rupi naityk kwaw a'e tawhu ihe nehe, i'i Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Na'e iahykaw rehe uze'eg wi Àmàrààw izupe. — Eikwahy zo ihewe nehe, hezar. Xo pitài haw zo apuranu putar ihe kury. A'e re naze'eg kwaw nehe. Aze heta 10 wà nehe, i'i izupe. — Aze heta 10 wà nehe, naityk kwaw tawhu ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tupàn Àmàrààw pe uze'eg pawire oho a'e wi izuwi kury. Uzewyr Àmàrààw weko haw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Karuketea'i mehe uhem a'e mokoz Tupàn heko haw pe har Xotom tawhu pe a'e wà kury. Iro wapyk in pàrirogaw huwake uken huwake a'e. A'e Tupàn heko haw pe har wanexak mehe upu'àm kury, wakutyr wata pà kury, wamuixe kar pà tawhu pupe kury. Wapyk upenàràg rehe, umuhyk uwa ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Uze'eg wanupe. — Hezar wà. Aiko xe penehe hezekaiw katu ma'e romo ihe. A'e rupi peinu heze'eg nehe. Peixe heràpuz pupe nehe. Pepuner pezepyez taw rehe nehe, peker putar heràpuz me nehe. Pyhewe peme'e nehe, peata wi pà nehe, i'i wanupe. — Nan, uruker putar katu pe nahu rupi nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Uze'eg wiwi tuwe Iro wanupe. A'e rupi weruzar ize'eg wà, hàpuz pupe oho pà hupi wà. Iro uzapo kar wanemi'u ràm pyhaw har wanupe. Umihir kar typy'ak imuapiruru kar pyr 'ym no. Umai'u katu hàpuz me uhem ma'e kwer wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Waker 'ym mehe we awa kwer Xotom tawhu pe har upaw rupi wà, kwàkwàmo wà, te tua'u kwer wà no, upu'àm Iro hàpuz izywyr wà: xe wà, pe pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wenoz Iro imuwà uzeupe wà. Upuranu hehe wà. — Ma'e pe oho a'e awa karuketea'i mehe neràpuz me uhem ma'e kwer wà, i'i izupe wà. — Erur xe urewe ne wà kury, ta'e ureker wer wapuhe ure no xe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Iro uhem weko haw wi wanupe uze'eg pà katu pe. Uwàpytym uken. Uze'eg wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","— Hemyrypar wà. Pezapo zo iaiwahy ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Pezeapyaka katu ko heze'eg rehe nehe. Heta we mokoz herazyr ihewe wà rihi. Awa puhe oho 'ym ma'e romo wanekon wà rihi. Arur putar xe katu pe peme ihe wà nehe. Pezapo penemimutar wanupe nehe. Pezapo zo ma'e ko awa wanupe nehe, ta'e heràpuz pupe heremimuixe karer romo wanekon a'e wà xe. A'e rupi napuner kwaw iaiw ma'e iapo kar haw rehe wanupe ihe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nezewe rehe we uze'eg nezewe izupe wà. — Ehem eho urerenatar wi nehe, i'i izupe wà. — Ko awa a'e, amo ae ywy rehe arer romo hekon a'e. Nezewe rehe we ipuruapo kar wer ma'e rehe zanewe a'e, i'i uzeupeupe wà. Uze'eg wi Iro pe wà. — Iaiw ma'e rehe urepurapo wer neràpuz me uhem ma'e kwer wanupe ure. Tàrityka'i uruzapo putar iaiw wera'u ma'e newe ure nehe kury, i'i izupe wà. Uzemomor awa Xotom pe har Iro kutyr wà kury. Uhem uken huwakea'i wà. Ipuruityk wer ukenaw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","A'e awa Iro hàpuz me har upyhyk Iro oho wà, imutyk pà tàpuz pupe wà. Uwàpytym ukenaw wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A'e re umuigo kar awa katu pe har hehàpyhà 'ym ma'e romo tàrityka'i wà kury, kwàkwàmo wà, tua'u kwer wà no. A'e rupi nuexak kwaw uken wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Na'e a'e hàpuz me uhem ma'e kwer uze'eg Iro pe wà kury. — Aipo heta amo neànàm xe wà. Epyhyk nera'yr ne wà nehe, nerazyr ne wà nehe no, nera'ytaty ne wà nehe no, amogwer neànàm tawhu pe har ne wà nehe no. Eraha paw rupi xe wi ne wà nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ta'e uruityk putar 'aw tawhu imumaw pà ure nehe xe. Tupàn Tuweharupi Wiko Ma'e wenu iaiw ma'e xe har wanemiapo kwer imume'u awer a'e. A'e rupi weityk kar 'aw tawhu Xotom her ma'e urewe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Na'e Iro oho a'e wi a'e kury, wazyr wamen ràm wanupe uze'eg pà a'e kury. — Pezemuàgà'ym tàrityka'i nehe kury, peho xe wi nehe kury, ta'e Tupàn Tuweharupi Wiko Ma'e weityk putar tawhu a'e nehe xe, imumaw pà nehe xe, i'i wanupe. — Uzemaraz iko zanerehe a'e, i'i uzeupeupe wà. Nuzeruzar kwaw ize'eg rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Izi'itahy iku'egwer pe a'e Tupàn heko haw pe har uze'egahy wiwi Iro pe wà kury. — Ezemuàgà'ym tàrityka'i kury ty, epyhyk neremireko nehe, epyhyk nerazyr ne wà nehe no. Pehem peho xe wi nehe kury. Nezewe mehe napemàno kwaw tawhu imumaw mehe nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mewe katu Iro uzemuàgà'ym iko. A'e rupi a'e Tupàn heko haw pe har upyhyk ipo rehe wà. Upyhyk hemireko ipo rehe wà no, upyhyk tazyr wapo rehe wà no, tawhu wi waneraha pà wà. Ta'e Tupàn Tuweharupi Wiko Ma'e upuhareko Iro a'e xe. Na'ipuruzuka wer kwaw hehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na'e amo Tupàn heko haw pe har uze'eg Iro pe kury. — Ezàn kury ty, ezepyro nemàno haw wi kury ty. Eme'e zo neraikwer kutyr nehe. Eme'e zo 'aw ywyàpyznaw rehe nehe. Ezàn eho ywytyr pe nehe. Aze nerezàn kwaw nehe, eremàno putar tuwe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Uze'eg Iro izupe. — Hezar, ezapo kar zo a'e ma'e ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nekatuahy ihewe ne, hepuhareko pe kwez ne, màno haw wi hepyro pà ne. Ywytyr muite xe wi a'e. Iàrew putar a'e pe hehem àwàm nehe. A'e rupi ma'e imumaw paw uhem putar ihewe nehe, hezuka pà ywytyr pe hehem 'ym mehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Heta amo tawhu pe pe. Aipo erexak. Namuite kwaw xe wi a'e. Hemono kar pe a'e pe nehe, hepyro pà màno haw wi nezewe nehe. Pixika'i a'e taw. Erexak ipixika'i haw, i'i Iro Tupàn heko haw pe har pe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Uze'eg wi Tupàn heko haw pe har izupe. — Ikatu. Eho pe pe a'e taw pe nehe ty. Namumaw kwaw a'e tawhu nereko àwàm ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Eho tàrityka'i kury. Ta'e napuner kwaw ma'e iapo haw rehe a'e pe nehem 'ym mehe we ihe rihi xe. — Pixika'i a'e, i'i Iro a'e tawhu pe. A'e rupi — Zoar, i'i teko izupe. — Pixika'i, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kwarahy uhem kury, iku'em kury. Iro nuhem kwaw Zoar tawhu pe iku'em 'ym mehe we a'e. Kwarahy ihem ire uhem a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Na'e, tàrityka'i, ywak rehe Tupàn Tuweharupi Wiko Ma'e umugyr kar tata Xotom tawhu rehe a'e kury, Komor tawhu rehe a'e no. (Umugyr kar ita izu ma'e ukaz ma'e enixo her ma'e hehe a'e no.) ");
INSERT INTO gubBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Umumaw a'e mokoz tawhu kury, hapy pà kury. Wapy tata a'e ywyàpyznaw nànàn no, a'e ywy rehe har wazuka pà upaw rupi no. Umumaw ka'a upaw rupi, umumaw ywyra a'e ywy rehe har upaw rupi no. ");
INSERT INTO gubBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Iro hemireko ume'e uwaikwer kutyr. Tàrityka'i uzeapo xa romo kury, kuzà hagapaw romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Iku'egwer pe Àmàrààw ume'e izi'itahy a'e. Oho Tupàn Tuweharupi Wiko Ma'e pe uze'eg awer pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ume'e Xotom kutyr, Komor kutyr, ywyàpyznaw kutyr. Tàtàxiner uzeupir ywy wi, tàtàxiner tatahu wi uhem ma'e ài. ");
INSERT INTO gubBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nezewe Tupàn umumaw a'e tawhu ywyàpyznaw rehe har. Ima'enukwaw Àmàrààw rehe. A'e rupi upyro Iro a'e ma'e ikaz tawer wi, heko awer tawhu imumaw pawer wi. ");
INSERT INTO gubBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Iro ukyze kury. Naheko wer kwaw Zoar taw pe. A'e rupi oho ywytyr rehe wazyr waneraha pà kury. A'e pe wiko amo ywykwar ywytyr rehe har pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Amo 'ar rehe tazyr ihya'u wera'u ma'e uze'eg ukypy'yr pe. — Zaneru itua'uhez etea'i a'e. Naheta kwaw amo awa ko ywy rehe wà. A'e rupi naheta kwaw zanemen ràm zanewe wà nehe. Nazapuner kwaw zanememyr haw rehe amo ae ywy rehe har wazàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ezur xe herupi nehe, xi'u kar kàwiahy zaneru pe nehe, imuka'u kar pà nehe. A'e mehe zaha ipuhe nehe. Nezewe mehe heta putar zanememyr zanewe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A'e 'ar mehe we, pyhaw, u'u kar kàwiahy u pe wà. Tyker uker oho ipuhe. Uka'u tuwe, a'e rupi nukwaw kwaw wemiapo. ");
INSERT INTO gubBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Iku'egwer pe i'i ukypy'yr pe kury. — Pyhaw aker zaneru puhe ihe. Ximuka'u kar wi kutàri pyhaw nehe no. Eho ipuhe nehe. Nezewe heta putar zanememyr zanewe wà nehe. Nezewe heta putar izuapyapyr izupe wà nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pyhaw u'u kar wi kàwiahy u pe wà. Ikypy'yr oho ipuhe. Uka'u tuwe a'e, a'e rupi nukwaw kwaw wemiapo. ");
INSERT INTO gubBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nezewe a'e mokoz Iro tazyr ipuru'a wà. Wanu umumuru'a wà. ");
INSERT INTO gubBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tyker imemyrzexak kar kury. Awa a'e. Omono Moaw izupe her romo. — Moaw izuapyapyr, za'e izuapyapyr wanupe ko 'ar rehe. — Heru izuapyr, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ikypy'yr imemyrzexak kar a'e no. Awa a'e no. Omono Menami izupe her romo. — Amonit, za'e izuapyapyr wanupe ko 'ar rehe. — Heànàm ta'yr, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Àmàrààw uhem Manire ywy wi a'e. Oho Kànàà ywy rehe, kwarahy ihemaw awyze har kutyr har pe. Wiko Kanez tawhu Xur tawhu wamyter pe. Amo 'ar rehe oho Zerar ywy rehe wiko pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Uze'eg iko a'e pe har wanupe. — Hereinyr a'e, i'i mua'u a'e pe har wanupe wemireko Xar rehe uze'eg pà. Na'e Amimerek Zerar pe har wanuwihawete a'e, werur kar Xar uzenataromo kury. Ipurereko wer hehe wemireko romo. ");
INSERT INTO gubBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pyhaw ipuahu mehe Tupàn uzexak kar Amimerek pe uze'eg pà kury. — Azepyk putar nerehe nezuka pà nehe, ta'e a'e kuzà neremirur karer a'e xe, imen ma'e romo hekon a'e xe, i'i izupe ipuahu pe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Amimerek nopokok kwaw Xar rehe a'e 'ar rehe a'e rihi. A'e rupi Amimerek uze'eg Tupàn pe. — Hezar, nazapo kwaw ikatu 'ym ma'e ihe. Aipo hezuka putar pe ne nehe, aipo erezuka putar teko heremiruze'eg ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","— Hereinyr, i'i Àmàrààw ihewe a'e. — Heinyr romo aiko ihe, i'i Xar ihewe a'e no. Nakwaw kwaw Àmàrààw hemireko romo heko haw herur kar mehe ihe. A'e rupi nazapo kwaw ikatu 'ym ma'e ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Uze'eg wi Tupàn izupe ipuahu pe. — Akwaw Àmàrààw hemireko romo heko haw neremigwaw 'ygwer ihe. Noromopokok kar kwaw hehe ihe, nezewe mehe nazapo kar kwaw iaiw ma'e newe herenataromo ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Emuzewyr kar a'e kuzà imen Àmàrààw pe nehe kury. Ta'e Tupàn ze'eg imume'u har romo hekon a'e xe. Uze'eg putar ihewe nehe, nezuka 'ym àwàm henoz pà ihewe nehe. Aze neremuzewyr kar kwaw kuzà izupe nehe, amume'u putar nezuka àwàm ihe nehe. Azuka putar neremiaihu paw ihe wà nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Iku'egwer pe Amimerek upu'àm izi'itahy kury. Wenoz wemiruze'eg paw wamuwà uzeupe wà. Umume'u uzeapo ma'e kwer upuahu parer a'e. Ukyze tuwe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","A'e re wenoz Àmàrààw uzeupe izupe uze'eg pà kury. — Iaiw ma'e erezapo. Aipo azapo amo ikatu 'ym ma'e newe. Màràzàwe tuwe eremuzepyk kar Tupàn herehe heywy rehe har wanehe ne. Ni amo nuzapo pixik kwaw agwer ikatu 'ym ma'e neremiapo kwer zàwenugar wà. ");
INSERT INTO gubBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ma'e rehe nema'enukwaw a'e ma'e iapo mehe ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Uze'eg Àmàrààw izupe kury. — Aze ru'u ko ywy rehe har numuwete kwaw Tupàn a'e wà, a'e hezeupe ihe. — Aze ru'u hezuka putar wà nehe, heremireko ipyhyk pà wà nehe, a'e hezeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","— Azeharomoete Xar hereinyr romo hekon a'e, ta'e heru tazyr romo hekon a'e xe. Nuiko kwaw hehy imemyr romo. A'e rupi apuner imen romo hereko haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kwehe mehe Tupàn hemuhem kar heru heko haw wi a'e, ywy heremigwaw 'ym rehe hemuata kar pà a'e. A'e 'ar mehe aze'eg Xar pe ihe. — Wyzài tawhu pe wyzài ywy rehe zaneata mehe hepytywà pe nezewe nehe. — Aiko heinyr romo ihe, ere a'e pe har wanupe nehe, a'e izupe, i'i Àmàrààw Amimerek pe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Na'e umuzewyr kar Amimerek Xar imen Àmàrààw pe kury. Omono ma'ea'yr izupe wà no. Àràpuhàràn, tapi'ak. Omono uma'ereko e ma'e izupe wà no: kuzà wà, awa wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","I'i izupe. — Eme'e heywy rehe kury, Àmàrààw. Eiko wyzài ywy pehegwer neremimutar rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Uze'eg Amimerek Xar pe kury. — Amono e putar 11, 5 kir ita parat nemen pe nehe. Nezewe mehe nerupi wata ma'e ukwaw putar iaiw ma'e iapo 'ymar romo nereko haw wà nehe. Nuzapo kwaw ikatu 'ym ma'e a'e, i'i putar newe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","A'e 'ym mehe we Tupàn Tuweharupi Wiko Ma'e ukwaw Xar Àmàrààw hemireko herur awer a'e, Amimerek hàpuz me herur arer a'e. A'e rupi uze'eg nezewe uzeupe a'e. — Kuzà Amimerek heko haw pe har a'e wà nehe, nupuner kwaw umemyr haw rehe a'e wà nehe, i'i uzeupe. A'e rupi umupytu'u kar upaw rupi a'e wà. Na'e Àmàrààw uze'eg tuwe Tupàn pe kury, Amimerek pe ikatu ma'e hemiapo ràm henoz tà izupe kury. A'e rupi Tupàn umukatu Amimerek. Umukatu hemireko no. Umukatu kuzà izupe uma'ereko e ma'e wà no. Nezewe mehe upuner umemyr haw rehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tupàn Tuweharupi Wiko Ma'e umume'u wemiapo ràm ikatu ma'e Xar pe a'e 'ar 'ym mehe we a'e. A'e rupi uzapo ma'e wemimume'u kwer rupi kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ipuru'a a'e kury. Tua'uhez tuwe Àmàrààw a'e. Omono hemireko amo ta'yr izupe. Uzexak kar 'ar Tupàn hemimume'u kwer mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Àmàrààw omono Izak wa'yr her romo. ");
INSERT INTO gubBl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Izak umumaw 8 'ar wiko pà kury. Na'e Àmàrààw omonohok ipirera'i izuwi Tupàn hemiapo kar rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Izak izexak kar mehe Àmàrààw wereko 100 kwarahy. ");
INSERT INTO gubBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na'e Xar i'i kury. — Tupàn uzapo ikatu ma'e kwez ihewe 'y, hemupuka kar pà kwez 'y. Teko ko ma'e henu àràm paw upuka putar heinuromo a'e wà nehe no, i'i. — Upuka a'e, i'i Izak her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","— Xar umukamu kar putar umemyr a'e nehe, ni'i pixik kwaw amo Àmàrààw pe wà. Nezewe rehe we hehya'uhez mehe amono ta'yr izupe, i'i. ");
INSERT INTO gubBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Itua'ua'i kury. Upytu'u ukamu re. A'e 'ar mehe, ipytu'u haw 'ar mehe Àmàrààw uzapo mynykaw uhua'u ma'e izupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Amo 'ar mehe Izimaew a'e, Àmàrààw ta'yr Agar Ezit ywy rehe har imemyr a'e, uzemaraz Izak rehe we a'e, Xar imemyr rehe we a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Wazemaraz taw hexak mehe Xar uze'eg Àmàrààw pe kury. — Emono kar a'e kuzà uma'ereko e ma'e xe wi nehe 'y, imemyr imono kar pà xe wi nehe no 'y. Ta'e ko uma'ereko e ma'e imemyr nuiko kwaw nera'yrete romo a'e 'y, Izak hememyr zàwe a'e 'y. Nupyhyk kwaw nema'e nemàno re nehe, i'i umen pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Àmàrààw uzemumikahy ize'eg awer henu mehe. Ta'e Izimaew wiko ta'yr romo a'e no xe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tupàn uze'eg izupe. — Àmàrààw, i'i izupe. — Ezemupy'apy'a katu zo kwarer rehe nehe, ni newe uma'ereko e ma'e rehe nehe no. Eruzar Xar ze'eg paw rupi nehe, ta'e heta putar nezuapyapyr newe wà nehe. Izak izuapyapyr wiko putar nezuapyapyr romo a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","— A'e kuzà uma'ereko e ma'e imemyr a'e, nera'yr romo hekon a'e. A'e rupi izuapyapyr a'e wà nehe no, teko tetea'u ikàg ma'e romo wanekon putar a'e wà nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iku'egwer pe Àmàrààw upu'àm izi'itahy kury. Omono temi'u Agar pe. Umynehem amo 'yryru imono pà izupe no. Omono kwarer iaxi'i rehe kury. — Eho xe hereko haw wi nehe, i'i izupe. Oho tuwe Agar a'e wi kury. Wata e oho iko ywyxiguhu Merexewa her ma'e rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","'Y i'u pawire umuapyk kar kwarer ywyra pixika'i ma'e i'àgaw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Wapyk ihy oho xeràna'i kury. Uze'eg in uzeupe. — Napuner kwaw hememyr imàno haw hexakaw rehe ihe, i'i uzeupe. Upyta a'e pe wapyk pà. Kwarer uzypyrog uzai'o pà. ");
INSERT INTO gubBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Wenu Tupàn izai'o mehe. Tupàn heko haw pe har ywate har uhapukaz Agar pe kury. — Ma'e rehe nanepy'apy'a katu kwaw, Agar, i'i izupe. — Ekyze zo nehe, ta'e Tupàn wenu nememyr izai'o mehe a'e pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Eho kury. Epyhyk kwarer ipo rehe. Amueta tetea'u kar putar izuapyapyr ihe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Na'e Tupàn umume'egatu kar Agar kury. Wexak amo 'yzygwar a'e pe. Oho 'yzygwar pe 'yryru imynehem pà. Umui'u kar umemyr Izimaew kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tupàn uzekaiw katu kwarer rehe. Itua'u kury. Wiko ywyxiguhu Pàrà her ma'e rehe. Wiko u'yw pupe ma'e izywà katu har romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ihy wexak amo kuzà Ezit ywy rehe har hemireko romo a'e. Uzereko wà. ");
INSERT INTO gubBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Amo 'ar mehe Amimerek uze'eg oho Àmàrààw pe kury. Hemiruze'eg zauxiapekwer wanuwihawete Piko her ma'e a'e no, oho uzar rupi a'e pe a'e no. Uze'eg Amimerek Àmàrààw pe. — Tupàn nepytywàgatu tuwe a'e, wyzài ma'e iapo mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","A'e rupi, xe, emume'uahy neremiapo ràm ihewe nehe, Tupàn henataromo nehe. — Naheremu'em pixik kwaw newe nehe, ni nera'yr wanupe nehe, ni nezuapyapyr wanupe nehe, ereahy ihewe Tupàn henataromo nehe kury, i'i Amimerek Àmàrààw pe. — Ihe naheremu'em pixik kwaw newe ihe, a'e rupi emume'u ihewe neremu'em pixik 'ym àwàm tàrityka'i nehe kury. Emume'u ko ywy rehe har wanupe neremu'em pixik 'ym àwàm nehe no, i'i Amimerek Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","— Amume'uahy tuwe a'e ma'e newe kury, i'i Àmàrààw izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Na'e Àmàrààw umume'u ma'e Amimerek pe kury. — Heta amo 'yzygwar pe pe. Heremiruze'eg umui'u kar weimaw a'e pe wà. Neremiruze'eg uzàmàtyry'ym heremiruze'eg a'e pe a'e wà, a'e wi wamuhem kar pà a'e wà. A'e rupi naheta kwaw 'yzygwar hereimaw wanupe kury, i'i Àmàrààw Amimerek pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Uze'eg Amimerek izupe. — Nakwaw kwaw a'e ma'e iapo arer ihe wà. Neremume'u pixik kwaw a'e ma'e ihewe. Xo kutàri zo ainu imume'u haw kwez ihe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Na'e Àmàrààw wexaexak amo àràpuhàràn a'e wà kury, wexaexak amo tapi'ak a'e wà no. Omono Amimerek pe wà kury. Uzapokatu uze'egaw uzehezehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Àmàrààw umunyryk amo 7 àràpuhàràna'yr amogwer weimaw wanuwi wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Amimerek upuranu hehe kury. — Màràzàwe tuwe eremono'og a'e 7 àràpuhàràna'yr amogwer nereimaw wanuwi ne wà kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Uze'eg Àmàrààw izupe. — Ma'e newe heremimono e ràm romo wanekon a'e wà. Aze erepyhyk a'e 7 àràpuhàràna'yr ne wà nehe, — Ereiko 'aw 'yzygwar iapo arer romo ne, ere iko ihewe. Ko àràpuhàràna'yr wexak kar 'àg 'yzygwar izar romo hereko haw purupe a'e wà kury, i'i izupe. — He'e ty, i'i Amimerek Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","A'e rupi — Merexewa, za'e a'e ywy pehegwer pe zane, a'e ma'e izeapo awer pe zane. — 'Yzygwar ze'egaw iapo katu awer, i'i her zaneze'eg rupi. Ta'e a'e mokoz awa umume'uahy tuwe wemiapo ràm uzeupeupe a'e pe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Merexewa pe uze'egaw iapo katu re Amimerek a'e, Piko a'e no, uzewyr oho weko haw Piri ywy her ma'e pe a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Àmàrààw uzutym amo ywyra a'e pe Merexewa pe. Umuwete katu Tupàn Tuweharupi Wiko Ma'e tuweharupi heko haw izar a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Umumaw Àmàrààw kwarahy tetea'u Piri ywy rehe wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Amo 'ar pawire Tupàn wagaw Àmàrààw a'e. — Àmàrààw, i'i izupe. Uwazar Àmàrààw ize'eg izupe. — Aiko xe ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Uze'eg wi Tupàn izupe. — Epyhyk Izak nera'yr tàrityka'i kury. Xo a'e zo nera'yrete romo hekon a'e, neremiamutar romo hekon a'e. Eraha Moria ywy rehe nehe kury. A'e ywy rehe aexak kar putar amo ywytyr newe nehe. Ezeupir a'e ywytyr rehe nehe. Ezuka nera'yr herenataromo a'e pe nehe. Emunyk tata hetekwer iwy pe nehe, hapy pà nehe, i'i Àmàrààw pe ha'agaw pà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Iku'egwer pe upu'àm Àmàrààw izi'itahy. Omono ikupe pe har weimaw zumen ikupe pe. Omonohok zepe'aw tata ma'ea'yr hapy haw pàràm no. Oho ywytyr Tupàn hemixak karer pe. Izak a'e, mokoz uma'ereko ma'e a'e wà no, oho hupi a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","'Ar na'iruz haw mehe wexak Àmàrààw wa'yr izuka àwàm kury. Muite wi wexak. ");
INSERT INTO gubBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na'e uze'eg uma'ereko ma'e wanupe. — Pepyta xe zumen huwake nehe. Ihe ihe, kwarer a'e no, oroho putar pepa'i ure nehe, Tupàn imuwete katu pà ure nehe. Nan kwehe tete uruzewyr putar xe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Upyhyk zepe'aw Tupàn henataromo ukaz ma'e ràm kury. Weraha kar Izak pe iaxi'i rehe imono pà. Upyhyk takihe. Upyhyk tata. Wata oho wa'yr rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nan kwehe tete kwarer uze'eg izupe. — Papaz, i'i izupe. — Ma'e, hera'yr, i'i izupe. — Heta zepe'aw zanewe. Heta tata zanewe. Ma'e pe àràpuhàràna'yr zaneremizuka ràm hekon a'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Uze'eg wi Àmàrààw izupe. — Aze nuhyk kwaw ma'e zanewe nehe, Tupàn umur putar a'e ma'e zanewe nehe. Umur putar amo àràpuhàràna'yr izuka pyràm zanewe nehe, hera'yr, i'i izupe. Wata wi oho waiko uzeupi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tupàn hemixak kwer pe wahem mehe Àmàrààw uzapo ma'ea'yr hapy haw Tupàn henataromo har kury. Omonokatu zepe'aw i'aromo. Na'e uzàpixi wa'yr kyhàhàm pupe kury. Omono ma'ea'yr hapy haw rehe zepe'aw i'aromo. ");
INSERT INTO gubBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","A'e re upyhyk takihe wa'yr izuka àwàm kury. ");
INSERT INTO gubBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","A'e 'ar mehe we tàrityka'i Tupàn heko haw pe har uhapukaz izupe kury. — Àmàrààw, Àmàrààw, i'i izupe. — Aiko xe, i'i Àmàrààw izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","— Emuahy kar zo kwarer nehe, ezapo zo ikatu 'ym ma'e izupe nehe, i'i izupe. — Akwaw Tupàn imuwete katu har romo nereko haw ihe kury, ta'e nanerekyty'ym kwaw nera'yr rehe kwez ihewe ne xe. Xo pitài nera'yr zo heta newe. Nezewe rehe we nanerekyty'ym kwaw ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Uzareko Àmàrààw kury. Wexak àràpuhàràn a'e pe kury, i'ak izepokok mehe ywyra rehe kury. Upyhyk Àmàrààw oho kury. Uzuka Tupàn pe imono pyr romo wa'yr hekuzaromo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Omono her a'e ma'ea'yr hapy haw pe. — Tupàn umur putar zanepo pe zaneremipyhyk 'ym zanewe nehe, i'i her imono pyrer. A'e rupi te ko 'ar rehe teko i'i nezewe izupe wà. — Weko haw rehe ywytyr rehe Tupàn Tuweharupi Wiko Ma'e umur heta 'ym ma'e zanewe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Uze'eg wi Tupàn heko haw pe har ywate har Àmàrààw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","— Nanerekyty'ym kwaw nera'yr rehe ihewe. Xo pitài nera'yr zo heta newe. A'e rupi herer rehe amume'uahy ko heze'eg newe kury, i'i Tupàn Tuweharupi Wiko Ma'e. — Azeharomoete amono putar heze'egatu nerehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Amueta tetea'u kar putar nezuapyapyr ihe wà nehe. Waneta àwàm nuzawy kwaw zahytata ywak rehe har waneta haw nehe. Nuzawy kwaw ywyxig yryhu izywyr har waneta haw nehe. Weityk putar waàmàtyry'ymar wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Erezapo heremiapo kar, a'e rupi amono putar heze'egatu teko ywy nànànar wanehe ihe nehe, nezuapyapyr wanupi ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Uzewyr Àmàrààw izupe uma'ereko ma'e waneko awer pe kury. Paw rupi oho Merexewa pe wà. Umumaw Àmàrààw amo kwarahy a'e pe wiko pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Amo 'ar pawire amo umume'u ma'e oho Àmàrààw pe wà. — Nerywyr Naor a'e, heta 8 ta'yr izupe wà, wemireko Miwka rehe we wà. ");
INSERT INTO gubBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ta'yr ipy Uz her ma'e uzexak kar a'e. A'e re uzexak kar tywyr wà. Muz, Kemuew waner romo wà. (Kemuew wiko Àrà tu romo.) ");
INSERT INTO gubBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","A'e re uzexak kar amo wà: Kezez, Hazo, Piwnaz, Ziriraw, Metuwew. ");
INSERT INTO gubBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Metuwew wiko kuzà Hemek her ma'e tu romo a'e. Amume'u a'e 8 Miwka imemyr waner kwez xe ihe kury, Naor ipurumuzàmuzàg waner kwez xe ihe kury. Naor Àmàrààw tywyr romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Heum a'e, Naor hemirekoagaw a'e, omono 4 ta'yr izupe a'e wà. Na'aw waner xe wà: Tema, Gàà, Taaz, Maaka. ");
INSERT INTO gubBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Xar umumaw 127 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Umàno Emerom tawhu pe wiko mehe. Kiriat-Arama tawhu her inugwer romo a'e. Kànàà ywy rehe tuz. Uzai'o Àmàrààw imàno awer rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","A'e re uhem hetekwer ipyta haw wi kury, Etew izuapyapyr wanupe uze'eg pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","— Aiko amo ae ywy rehe arer romo peinuinuromo ihe. A'e rupi peme'eg amo peywy pehegwer ihewe nehe. A'e mehe apuner putar heremireko hetekwer itymaw rehe ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Etew izuapyapyr uwazar ize'eg izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","— Einu katu ureze'eg nehe. Ereiko tuwihawete ikàg ma'e romo urerenataromo ne. Ezutym neremireko hetekwer itakwar xe har ikatu wera'u ma'e pupe nehe. Ni amo xe har nahekyty'ym kwaw hetekwer itymaw rehe newe wà nehe. Wyzài teko uzutym kar putar hetekwer newe wà nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Na'e Àmàrààw upu'àm kury, uzemumew a'e Etew izuapyapyr wanenataromo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","— Aze pezutym kar hetekwer xe ihewe nehe, peze'eg Eperom Zoar ta'yr pe herekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","A'e mehe ume'eg putar itakwar Makepera her ma'e ihewe nehe. A'e itakwar upyta iziwyzaw rehe. Ame'eg kar putar tuwe ihe nehe, hekuzar paw imono pà izupe nehe. Nezewe mehe aiko putar itakwar purutymaw ko ywy rehe har izar romo ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eperom wapyk in a'e pe wamyter pe a'e, wazemono'ogaw pe tawhu huken ruwake a'e. Uze'eg wahy haw rupi a'e pe har nànàn kury. Upaw rupi upuner ize'eg henu haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","— Nan kwaw ty, hezar. Einu katu heze'eg nehe. Amono e a'e ywy pehegwer newe. Amono e itakwar a'e ywy rehe har newe no. Heremiruze'eg wenu heze'eg wà kury. A'e rupi ukwaw ywy imono e awer neremireko hetekwer itym àwàm romo wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Àmàrààw uzemumew wi Etew izuapyapyr wanenataromo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Uze'eg wi Eperom pe. Upaw rupi wenu ize'eg mehe wà. — Einu katu heze'eg, ty. Hepurume'eg kar wer a'e ywy pehegwer rehe ihe. Emume'u hekuzar ihewe. Amono putar newe nehe. A'e re azutym putar heremireko hetekwer ipupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eperom uze'eg izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","— Einu katu heze'eg, hezar. A'e ywy pehegwer hekuzar a'e, 4 kir parat ku'aw har a'e. Aze eremur ihewe nehe, aze neremur kwaw ihewe nehe, zuawygatu ihewe nehe. Ereiko hemyrypar romo. A'e rupi nazekaiw kwaw hekuzar rehe. Eho neremireko hetekwer itym pà ipupe nehe ty, i'i Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","— He'e, i'i Àmàrààw izupe. Upapar ita parat a'e hekuzar Eperom hemimume'u kwer amogwer wanenataromo kury. 4 kir ku'aw har ipuhuz taw a'e. Ma'eme'egar a'e wà, ma'eme'eg kar har a'e wà no, heta amo puhuz taw ha'agaw paw wanupe. Àmàrààw upyhyk a'e puhuz taw ha'agaw paw kury, hekuzar ipapar pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Nezewe Àmàrààw wiko ywy pehegwer Makepera pe har izar romo kury, Eperom iziwy izar romo kury. Manire tawhu ruwake kwarahy ihemaw kutyr tuz a'e. Àmàrààw wiko ywy izar romo, ywyra paw izar romo no, ate ywyzaw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Etew izuapyapyr a'e zemono'ogaw pe wiko ma'e kwer upaw rupi a'e wà, wexak a'e ywy pehegwer ime'eg kar awer a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","A'e re Àmàrààw uzutym wemireko Xar hetekwer a'e kury, itakwar Makepera iziwy rehe har pupe a'e kury, kwarahy ihemaw kutyr Manire tawhu ruwake a'e kury. Emerom tawhu her inugwer a'e. Kànàà ywy rehe tuz. ");
INSERT INTO gubBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nezewe a'e ywy pehegwer Etew izuapyapyr wama'e kwer a'e, itakwar a'e pe har a'e no, Àmàrààw upyhyk uma'e romo kury, purutymaw romo uzeupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Itua'uhez tuwe Àmàrààw kury. Tuweharupi Tupàn Tuweharupi Wiko Ma'e uzapo ikatu ma'e iko izupe uze'egatu kwehe arer rupi a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Amo 'ar mehe Àmàrààw wenoz uma'ereko ma'e itua'u wera'u ma'e imuwà uzeupe kury. A'e awa uzekaiw katu ima'e rehe upaw rupi a'e. Aze a'e teko umume'uahy kar iapo pyràm amo pe wà, omono imume'u har ipo wenugupy iwype wà. Na'e Àmàrààw uze'eg uma'ereko ma'e pe. — Emur nepo xe herenugupy wy pe kury. Emume'uahy neremiapo ràm ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Tupàn Tuweharupi Wiko Ma'e wiko ywak izar romo a'e, wiko ywy izar romo a'e no. Emume'uahy neremiapo ràm henataromo kury. Eze'egahy nezewe ihewe. — Nera'yr Izak nuwereko pixik kwaw kuzà xe hereko haw pe har Kànàà ywy rehe har a'e nehe, ereahy ihewe Tupàn henataromo nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","— Eho ywy hereko awer kwehe arer pe nehe, exaexak amo kuzà heànàm wainuromo har nehe, hera'yr Izak hemireko ràm romo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Na'e a'e uma'ereko ma'e upuranu Àmàrààw rehe kury. — Aze aexak amo kuzàwaza nehe, aze natur wer kwaw xe herupi nehe, ma'e azapo putar nehe, i'i izupe. — Aipo araha wi putar nera'yr neiwy pe nereko awer pe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Uze'eg wi Àmàrààw izupe. — Nan. Emuzewyr kar zo hera'yr a'e pe nehe. Eraha zo a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tupàn Tuweharupi Wiko Ma'e a'e, ywak izar a'e, heru hàpuz wi heànàm waiwy wi hepyro a'e. Umume'uahy ko ywy hezuapyapyr wanupe imono e àwàm a'e. Neata mehe Tupàn umur putar weko haw pe har newe nehe, nerupi wata ma'e romo nehe. Wexak kar putar nerape ràm newe nehe. Wexak kar putar neremiapo ràm newe nehe no. Nezewe mehe erepuner amo kuzàwaza herur haw rehe hera'yr pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Aze kuzàwaza natur wer kwaw xe nerupi nehe, urupyro putar ko ma'e neremimume'uahy kwer wi ihe nehe. Nazapo kar kwaw ma'e newe nehe. Emuzewyr kar zo hera'yr a'e pe nehe. Eraha zo a'e pe nehe, i'i Àmàrààw wemiruze'eg pe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Na'e hemiruze'eg omono opo Àmàrààw henugupy wy pe kury, hemiapo putar haw iapo àwàm imume'uahy pà kury. — Azapo putar tuwe neremimutar ihe nehe, i'iahy izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A'e re upyhyk 10 kawaru kupewa'a kamer her ma'e a'e wà kury, Àmàrààw heimaw a'e wà kury. Upyhyk ma'e Àmàrààw iànàm wanupe imono pyràm a'e no. Wata oho tawhu Naor heko awer pe kury, Mezopotàm ywy rehe har pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","A'e pe uhem mehe umuapyk kar weimaw kamer wapenàràg rehe wà, 'yzygwar ruwake tawhu ruwake wà. Karuketea'i kury. Kuzàgwer a'e pe har ur 'y ipiaromo a'e mehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na'e Àmàrààw hemiruze'eg uze'eg Tupàn pe nezewe kury. — O Tupàn, hezar Àmàrààw izar romo ereiko ne. Emuzeapo kar ikatuahy ma'e hezar pe nehe, nekatu izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kuzàwaza tawhu pe har ur xe 'àg 'yzygwar pupe 'y henuhem pà a'e wà. Aiko xe ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Aze'eg putar amo kuzàwaza pe nehe. — Aze ikatu newe nehe, emuezyw kar 'yryru izupe nehe, ihewe nehe. Nezewe apuner hei'u haw rehe ihe nehe, a'e putar izupe nehe. — Ei'u 'y, amono putar 'y nereimaw kamer wanupe ihe nehe no 'y, aze i'i ihewe nehe, tuwe a'e kuzàwaza wiko Izak hemireko ràm romo a'e nehe. Aze uzeapo ma'e nezewe nehe, akwaw putar ikatu ma'e hezar Àmàrààw pe neremiapo kwer ihe nehe, i'i Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tupàn pe ize'eg mehe we uhem amo kuzà Hemek her ma'e a'e pe y'a herur pà waxi'i rehe kury. Metuwew tazyr romo a'e. Metuwew a'e, Naor ta'yr romo Miwka imemyr romo hekon a'e. Naor a'e, Àmàrààw tywyr romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Hemek wiko kuzàwaza ipuràg eteahy ma'e romo. Awa puhe oho pixik 'ym ma'e romo hekon. Ni amo awa nopokok pixik kwaw hehe wà. Wezyw 'yzygwar pe kury. Umynehem y'a. Uzeupir wi a'e wi. ");
INSERT INTO gubBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Na'e Àmàrààw hemiruze'eg uzàn oho huwàxi pà kury. Uze'eg izupe. — Aze ikatu newe, tuwe a'u 'y pixik ney'a pupe har ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","— Ei'u 'y, i'i kuzà izupe. Tàrityka'i umuezyw y'a izupe. Upyhyk y'a izi'u mehe izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Imui'u kar pawire uze'eg izupe. — Anuhem putar 'y nereimaw kamer wanupe nehe no. Amui'u kar putar wà nehe. Wai'u pawire wanupe ihyk pawire apytu'u putar imono re nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tàrityka'i uzakook 'y wai'u haw pupe. Uzàn màràn haw katu 'yzygwar pe 'y henuhem pà kamer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Izàn mehe a'e awa ume'e hehe uze'eg 'ym pà. — Aze ru'u Tupàn uzapo putar ikatu ma'e hezar Àmàrààw pe kury, heata haw rupi kury, i'i in uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamer wai'u pawire a'e awa upyhyk amo poapyw har ita or iapo pyrer a'e kury. 6 kàràm ipuhuz taw. Omono a'e kuzà iapygwar rehe kury. Omono amo mokoz zywaku'aw har or iapo pyrer izupe no. 100 kàràm ipuhuz haw. Hekuzar katu a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A'e re upuranu kuzà rehe. — Aze ikatu newe, emume'u neru her ihewe nehe. — Aipo heta ker haw hàpuz me ihewe nehe, heremiruze'eg wanupe nehe. Uruekar pyhaw ureker àwàm ure, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","— Metuwew tazyr romo aiko ihe. Heru a'e, Naor ta'yr romo Miwka imemyr romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Heta ker haw ureràpuz me. Heta temi'u nereimaw kamer wanupe. Heta ka'api'i wanupe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Na'e a'e awa wapyk upenàràg rehe Tupàn imuwete katu pà a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","— Ikatuahy Tupàn Tuweharupi Wiko Ma'e a'e, hezar Àmàrààw izar a'e, ta'e naheharaz kwaw izuwi a'e xe, ta'e ikatuahy ihewe a'e xe. Ta'e hererur kwez iànàm wanàpuz me kutàri a'e xe, i'i Tupàn pe imuwete katu pà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Uzàn kuzàwaza uhy hàpuz me. Umume'u ma'e uzeapo romo ma'e kwer izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Heta amo ikywyr Àràmàw her ma'e a'e pe no. Wexak a'e iapygwar rehe har a'e. Wexak ipoapyw har weinyr pe imono e pyrer no. Wenu ma'e uzeapo ma'e kwer imume'u mehe a'e no. Uzàn oho Àmàrààw hemiruze'eg ipiaromo kury. Àmàrààw hemiruze'eg upy rehe u'àm katu pe weimaw kamer wanuwake, 'yzygwar huwake. ");
INSERT INTO gubBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Àràmàw uze'eg izupe kury. — Tupàn Tuweharupi Wiko Ma'e omono uze'egatu nerehe a'e. Ezur herupi kury. Màràzàwe tuwe ereiko xe katu pe. Amuàgà'ym heràpuz newe. Amuàgà'ym kamer waker àwàm kwez ihe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Na'e wixe tàpuz me kury. Àràmàw wiko katu pe. Wenuhem ma'e kamer wakupe wi. Omono ka'api'i waker àwàm romo, wanemi'u ràm romo no. A'e re werur 'y Àmàrààw hemiruze'eg pe no, hupi wata ma'e wanupe no. A'e rupi upuner uzepyez taw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Temi'u herur mehe a'e Àmàrààw hemimono kar uze'eg a'e pe har wanupe kury. — Heta amo ma'e peme heremimume'u ràm ihe. Namai'u kwaw imume'u 'ym mehe we ihe, i'i wanupe. — Emume'u ty, i'i Àràmàw izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","A'e rupi uze'eg nezewe kury. — Àmàrààw pe uma'ereko ma'e romo aiko ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tupàn Tuweharupi Wiko Ma'e omono uze'egatu iko hezar pe azeharomoete a'e. A'e rupi hemetarer katu ma'e romo hekon a'e kury. Umur ma'ea'yr tetea'u izupe wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà. Umur ita hekuzar katu ma'e izupe no: parat, or no. Umur uma'ereko e ma'e tetea'u izupe wà no: kuzà wà, awa wà. Umur kamer izupe wà no. Umur zumen izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hemireko Xar a'e no, ihya'uhez mehe tuwe umur amo ta'yr hezar pe no. Ta'yr a'e nehe, tu imàno re wiko putar ima'e kwer paw wazar romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hezar umume'uahy kar heremiapo ràm ihewe a'e. Uzapo kar wemimutar ihewe. — Nera'yr Izak nuwereko pixik kwaw kuzà xe hereko haw pe har Kànàà ywy rehe har a'e nehe, ereahy ihewe Tupàn henataromo nehe kury, i'i ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","— Eho heru iànàm waneko haw pe nehe. Exaexak amo kuzà heànàm wainuromo har nehe, hera'yr hemireko ràm romo nehe, i'i ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A'e rupi apuranu hehe ihe. — Aze kuzàwaza heremixak ràm natur wer kwaw xe herupi nehe, ma'e azapo putar nehe, a'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Uwazar heze'eg ihewe. — Tuweharupi aruzar Tupàn Tuweharupi Wiko Ma'e ze'eg aha iteko ihe. Omono kar putar weko haw pe har nerupi nehe, a'e rupi xo ikatuahy ma'e zo uzeapo putar newe nehe, i'i ihewe. — Heànàm wainuromo, heru iànàm wainuromo erexak putar amo kuzà hera'yr pe nehe, hemireko ràm romo nehe, i'i ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","— Aze ereze'eg heànàm wanupe nehe, aze na'ipurumur wer kwaw kuzàwaza rehe hera'yr pe wà nehe, a'e mehe urupyro putar neremimume'uahy kwer wi ihe nehe, i'i ihewe, i'i Àmàrààw hemiruze'eg a'e pe har wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","— Nezewe mehe kutàri ahem tuwà 'yzygwar pe kury. A'e pe hehem mehe aze'eg nezewe Tupàn pe ihe. — O Tupàn Tuweharupi Wiko Ma'e ne, Àmàrààw hezar izar ne, tuwe heremiapo ràm kutàri àràm ikatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aiko xe 'yzygwar huwake. Amo kuzàwaza xe tur mehe nehe, 'y henuhem mehe nehe, ainoz putar 'y izupe nehe, izy'a wi hei'u àwàm romo izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","— He'e, aze i'i ihewe nehe, — Arur putar 'y nereimaw kamer wanupe ihe nehe no, aze i'i ihewe nehe, tuwe wiko hezar ta'yr hemireko ràm neremixak ràm romo nehe, a'e Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Izupe heze'eg paw etea'i mehe ur Hemek a'e pe y'a herur pà waxi'i rehe. Wezyw 'yzygwar pupe. Na'e aze'eg izupe. — Aze ikatu newe emur 'y pixik ihewe nehe, a'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tàrityka'i umuezyw y'a ihewe uze'eg pà kury. — Ei'u 'y, amono putar 'y nereimaw kamer wanupe ihe nehe no 'y, i'i ihewe. A'e rupi ai'u ihe. Omono 'y kamer wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","A'e re apuranu hehe. — Mo wiko neru romo a'e, a'e izupe. — Metuwew tazyr romo aiko ihe. Heru a'e, Miwka imemyr Naor ta'yr romo hekon a'e, i'i ihewe. A'e rupi amono iapu'a ma'e iapygwar rehe. Amono mokoz poapyw har ipoapyw no. ");
INSERT INTO gubBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Apyk hepenàràg rehe Tupàn imuwete katu pà. Amume'u Tupàn Tuweharupi Wiko Ma'e ikatu haw izupe. Hezar Àmàrààw izar romo hekon a'e. Hererur tuwe herereko iànàm wanupe. Nezewe apuner hezar tywyr tazyr heraha haw rehe ta'yr pe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Aipo peiko putar ikatu ma'e romo hezar pe nehe kury. Aipo napenemu'em pixik kwaw hezar pe nehe. Aze napepurupytywà wer kwaw hehe nehe, pemume'u penemiapo ràm tàrityka'i ihewe nehe. Nezewe mehe apuner heremiapo ràm rehe hema'enukwaw paw rehe ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Àràmàw a'e, Metuwew a'e no, uwazar ize'eg izupe a'e wà kury. — A'e uzeapo ma'e kwer paw a'e, Tupàn Tuweharupi Wiko Ma'e uzapo a'e. A'e rupi nurupuner kwaw ma'e imume'u haw rehe ure kury. — He'e, nurupuner kwaw ure'e haw rehe ure. — Nan, nurupuner kwaw ure'e haw rehe ure no. ");
INSERT INTO gubBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Aiko Hemek. Eraha nerupi nehe. Tuwe wiko nezar ta'yr hemireko romo nehe, Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer rupi nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","A'e ze'eg henu mehe Àmàrààw hemiruze'eg wapyk upenàràg rehe kury. Umuhyk uwa ywy rehe. Umuwete katu Tupàn Tuweharupi Wiko Ma'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A'e re wenuhem ma'e tetea'u parat iapo pyrer uma'eryru wi kury. Wenuhem ma'e tetea'u or iapo pyrer no. Wenuhem topoz izuwi no. Omono e Hemek pe kury. Omono ma'e hekuzar katu ma'e ikywyr pe, ihy pe no. ");
INSERT INTO gubBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","A'e hupi wata ma'e a'e wà no, umai'u a'e wà, ui'u pà a'e wà. Uker a'e pe wà. Iku'egwer pe, wapu'àm mehe Àmàrààw hemiruze'eg uze'eg a'e pe har wanupe kury. — Tuwe aha hezar heko haw pe nehe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hemek ikywyr a'e, ihy a'e no, uze'eg Àmàrààw hemiruze'eg pe a'e wà. — Aze mo umumaw amo 'ar urepyr, ikatu wera'u mo. Aze ru'u 10 'ar nehe. A'e re upuner oho haw rehe nerupi nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Àmàrààw hemiruze'eg uwazar waze'eg wanupe. — Hemupytu'u kar zo pe xe nehe. Tupàn Tuweharupi Wiko Ma'e uzapokatu xe hezur awer a'e. Tuwe azewyr hezar heko haw pe tàrityka'i nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Uwazar ize'eg izupe wà. — Xinoz Hemek xe nehe. Xinu ize'eg àwàm nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wenoz kuzàwaza oho imuwà wà. — Aipo neho wer ko awa rupi nehe, i'i izupe wà. — He'e, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","A'e rupi omono kar Hemek a'e wà kury, hehe uzekaiw katu ma'e ikuzàtài mehe arer imono kar pà hupi a'e wà no. — Tuwe oho Àmàrààw hemiruze'eg rupi a'e wà nehe, i'i wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Omono uze'egatu Hemek rehe wà no. Ne urereinyr ne, tuwe teko tetea'u wahy romo ereiko nehe. Nezuapyapyr wà nehe, tuwe weityk waàmàtyry'ymar waneko haw tawhu wà nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na'e Hemek a'e, izupe uma'ereko ma'e a'e wà no, uzemuàgà'ym a'e wà kury. Uzeupir kamer wakupepe wà, Àmàrààw hemiruze'eg rupi wata pà wà. Nezewe mehe oho a'e wi wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","A'e 'ar rehe Izak uhem oho ywyxiguhu pe a'e kury. Uhem 'yzygwar pe kury. Wikuwe ma'e herexakar a'e 'yzygwar her romo a'e. Wiko Izak Kànàà ywy rehe kwarahy ihemaw awyze har kutyr har rehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Karuketea'i mehe uzekytyar oho iko kaiwer pe. Wexak kamer wanur mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Hemek ume'e hehe a'e no. Hexak mehe wezyw kamer wi kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Upuranu uma'ereko ma'e rehe. — A'e awa kaiwer rehe har zanekutyr ur ma'e a'e, mo romo wiko aipo a'e, i'i izupe. — Hezar a'e, i'i Hemek pe. Na'e upyk uwa pàn pupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Uma'ereko ma'e umume'u wemiapo kwer paw Izak pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na'e Izak weraha Hemek kury, tàpuzràn uhy Xar heko awer pe kury. Wiko hemireko romo a'e pe kury. Izak uzamutar katu tuwe Hemek. A'e rupi upytu'u uhy imàno awer rehe uzai'o re kury. ");
INSERT INTO gubBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Àmàrààw wereko amo kuzà wemireko romo a'e kury. Ketur her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Omono amo ta'yr izupe wà. Na'aw waner xe wà: Zinihà, Zokizà, Menà, Mimà, Izimak, Xu. ");
INSERT INTO gubBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Zokizà wiko Xewa tu romo a'e, Nenà tu romo a'e no. Nenà izuapyapyr a'e wà, Axurew, Eretuzew, Ereumew waner romo a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Na'aw Minià ta'yr waner xe wà: Epa, Eper, Enok, Amina, Ewna. Ketur izuapyapyr romo wanekon upaw rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Àmàrààw omono uma'e paw Izak pe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Omono amo imono pyr wemirekoagaw wamemyr wanupe no. Umàno 'ym mehe we umunyryk amogwer wa'yr Izak wi a'e wà, wamono kar pà ywy kwarahy ihemaw kutyr har pe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Àmàrààw umumaw 175 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Itua'uhez mehe tuwe umàno a'e. Oho uwipy wainuromo uzemono'og pà, umàno ma'e kwer wapyta haw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ta'yr Izak a'e, ta'yr Izimaew a'e no, uzutym hetekwer itakwar Makepera her ma'e pupe wà. Manire huwake kwarahy heixe haw kutyr tuz. Eperom Zoar Etew izuapyapyr ta'yr a'e, a'e ywy izarer romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","A'e 'ym mehe we Àmàrààw ume'eg kar a'e ywy Etew izuapyapyr wanuwi a'e. Uzutym Àmàrààw hetekwer a'e pe hemireko ipy Xar itym awer huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Àmàrààw imàno re Tupàn omono uze'egatu ta'yr Izak rehe. Wiko 'yzygwar wikuwe ma'e herexakar her ma'e huwake a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Amume'u putar Izimaew izuapyapyr waner xe ihe wà nehe kury. Àmàrààw wereko wemirekoete Xar pe uma'ereko ma'e a'e, wemirekoagaw romo a'e. Agar her romo a'e. Wiko Ezit ywy rehe arer romo. Agar umur ta'yr Izimaew her ma'e Àmàrààw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Na'aw izuapyapyr waner xe wà: Nemaiot ta'yr ipy her romo a'e. A'e re umuzàg Kenar, Amineew, Miwizàw, ");
INSERT INTO gubBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mizima, Numa, Maxa, ");
INSERT INTO gubBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Anaz, Tema, Zetur, Napi, Kenema. ");
INSERT INTO gubBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Amume'u a'e 12 Izimaew ta'yr waner xe wà kury. Pitàitàigatu uzapo weko haw amo ywy rehe wà. Omono uwer uiwy pe pitàitàigatu wà no. Pitàitàigatu wiko uzuapyapyr wanuwihawete romo wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Izimaew wereko 137 kwarahy umàno mehe. Hekwe oho uwipy wainuromo uzemono'og pà umàno ma'e kwer wapyta haw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Izuapyapyr wiko Hawira ywy Xur ywy wamytepe wà, Ezit ywy izywyr kwarahy ihemaw kutyr wà. Heta amo pe Axir piar her ma'e a'e pe. Uzypyrog Ezit ywy wi oho pà. Izuapyapyr uzapo weko haw a'e pe iwyr pitàitàigatu wà. Utyryk oho amogwer Àmàrààw izuapyapyr wanuwi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Amume'u putar inugwer Àmàrààw ta'yr Izak her ma'e heko awer xe ihe nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izak wereko 40 kwarahy Hemek hereko mehe. (Metuwew tazyr romo Àràmàw heinyr romo hekon a'e.) Hemek iànàm wiko Àràm izuapyapyr romo wà. Wiko Mezopotàm ywy rehe wà. — Yrykaw wamyter pe har, i'i a'e ywy her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Hemek nupuner kwaw umemyr haw rehe. A'e rupi Izak uze'eg Tupàn pe wemireko ipytywà àwàm henoz tà. Tupàn wenu ize'eg mehe. Ipuru'a Hemek kury. ");
INSERT INTO gubBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mokoz imemyr a'e wà. Uzeàmàtyry'ym hie pe wiko mehe we wà. Uze'eg wahy uzeupe. — Màràzàwe tuwe uzeapo nezewe haw ihewe, i'i uzeupe. A'e rupi upuranu Tupàn rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Uwazar Tupàn ize'eg izupe. Heta mokoz teko heta tetea'u ma'e wanu nerie pe wà. Uzexak kar putar mokoz teko uzeàmàtyry'ym ma'e ràm nerie wi a'e wà nehe. Amo ikàg wera'u putar inugwer wi wà nehe. Tywyr wiko putar wyky'yr izar romo a'e nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Uhem Hemek imemyrzexak kar haw kury. Uzexak kar mokoz awa wà. ");
INSERT INTO gubBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Uzexak kar ma'e kwer ipy a'e, ipiràg a'e. Hawku a'e, miar ipirer kamir romo iapo pyrer ài a'e. A'e rupi omono Ezau her romo wà. — Hawku ma'e, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tywyr a'e, uzexak kar mehe upyhyk wyky'yr ipyakaza rehe opo pupe a'e. A'e rupi omono Zako izupe her romo wà. — Ipyakaza, i'i her zaneze'eg rupi. Izak wereko 60 kwarahy Hemek imemyr wazexak kar mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Itua'u kwarera'i wà. Ezau a'e, ikatu ka'a pe heko haw izupe a'e. Wiko uzemi'i kar ma'e ikatu ma'e romo a'e. Zako nuiko kwaw wyky'yr zàwe. Nahehaite kwaw. Nuata tetea'u kwaw. Wàpuz me upyta haw ikatu izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izak a'e, uzamutar katu wera'u Ezau a'e, ta'e hemizuka kwer ho'o kwer i'u haw ikatu izupe a'e xe. Hemek uzamutar katu wera'u Zako. ");
INSERT INTO gubBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Amo 'ar mehe Zako umupupur amo temi'u 'y inuromo har iko a'e. Uhem Ezau ka'a wi kury. Ikene'o. ");
INSERT INTO gubBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","— Emur amo temi'u neremimupupur ipiràg ma'e tàrityka'i ihewe ty, ta'e hema'uhez katu aipo xe, i'i uwywyr pe. A'e rupi omono amo her Ezau pe wà. — Enom, i'i izupe wà. — Ipiràg, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Uze'eg Zako izupe. — He'e ty. A'u kar putar newe ty. Amo 'ar mehe ereiko putar zaneru Izak heimaw wazar romo nehe, ta'e ta'yr ipy romo ereiko ne xe. Aze eremur wazar romo nereko haw ihewe nehe, aze hemuigo kar pe wazar ràm romo ne nehe, xo a'e mehe zo amono putar ko temi'u neremi'u ràm romo newe ihe nehe, i'i wyky'yr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","— Ikatu ty, i'i Ezau uwywyr pe. — Amàno etea'i kury. Aze amàno nehe, naiko pixik kwaw heru heimaw wazar romo ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","— Emume'uahy neze'eg ihewe kury, i'i tywyr izupe. Umume'uahy uze'eg izupe. A'e rupi Zako wiko Izak heimaw wazar ràm romo a'e kury. Wiko Zako ta'yr ipy zàwenugar romo, ta'yr ipy hekuzaromo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Na'e omono Zako typy'ak wyky'yr pe kury. Omono a'e temi'u 'y pupe imupupur pyrer izupe no. Umai'u pawire ui'u pawire upu'àm kury, a'e wi oho pà kury. Nezewe umuaiw ta'yr ipy romo weko haw. ");
INSERT INTO gubBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Amo kwarahy rehe heta ma'uhez taw uhua'u ma'e a'e ywy rehe kury. Nuhyk kwaw temi'u teko wanupe. Pema'enukwaw ma'uhez taw Àmàrààw heko mehe arer rehe. Nezewegatete Izak 'ar mehe no. A'e rupi Izak oho Zerar tawhu pe kury, Amimerek heko haw pe kury. Piri ywy rehe har wanuwihawete romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","A'e pe Tupàn Tuweharupi Wiko Ma'e uzexak kar wà Izak pe a'e kury. Uze'eg izupe. — Eho zo Ezit ywy rehe nehe. Aexak kar putar amo ywy newe nehe. Epyta a'e ywy newe heremixak kàràm rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ko 'ar rehe we epyta xe ko ywy rehe kury. Aiko putar nepyr ihe nehe, amono putar heze'egatu nerehe nehe. Amono putar ko ywy paw nezuapyapyr wanupe nehe. Nezewe amuhyk putar heremimume'uahy kwer neru Àmàrààw pe arer ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Amueta tetea'u kar putar nezuapyapyr ihe wà nehe. Waneta àwàm nuzawy kwaw zahytata waneta haw wà nehe. Ko ywy paw amono putar wanupe nehe. Nezuapyapyr wanupe azapo putar ikatuahy ma'e ywy rehe har nànàn ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ta'e Àmàrààw weruzar heze'eg a'e xe. Uzapo ma'e heze'eg rupi katete. Uzapo heremimutar. Wata oho iko heze'eg rupi. Wiko heremimu'e romo, i'i Tupàn Izak pe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Na'e Izak upyta Zerar ywy rehe wiko pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Awa a'e ywy rehe har upuranu oho hehe wà kury, hemireko rehe uze'eg pà wà kury. — Hereinyr romo hekon a'e, i'i mua'u wanupe. Ipuràg eteahy Hemek a'e. Ukyze Izak awa wanuwi. A'e rupi, — Heremireko a'e, ni'i kwaw wanupe. — Aze ru'u awa xe har hezuka putar wà nehe, heremireko ipyhyk pà uzeupe wà nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Umumaw Izak 'ar tetea'u a'e pe wiko pà. Amo 'ar mehe Amimerek Piri ywy rehe har wanuwihawete a'e, ume'e uken wi a'e. Wexak Izak hemireko rehe we heko haw a'e. Izak umumuràg wemireko Hemek hereko. ");
INSERT INTO gubBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Na'e Amimerek wenoz Izak heruwà wenataromo kury. Upuranu hehe. — Neremireko romo hekon tuwe a'e. Emume'u ze'eg azeharomoete har ihewe kury. Màràzàwe tuwe — Hereinyr romo hekon, ere urewe ne, i'i izupe. — Aze'eg hezeupe ihe. — Aze — Heremireko, a'e wanupe nehe, hezuka putar wà nehe, a'e hezeupe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","— Màràzàwe tuwe erezapo agwer ma'e urewe. Aze mo amo xe har oho ipuhe, a'e mehe eremur kar mo zepykaw urewe ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Na'e Amimerek umume'u kar uze'eg oho wemiruze'eg paw wanupe kury. — Aze amo teko uzapo ikatu 'ym ma'e ko awa pe wà nehe, hemireko pe wà nehe, azuka kar putar a'e teko ihe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","A'e kwarahy mehe, Izak uzutym ma'eà'yz tetea'u a'e ywy rehe. Pitài ma'eà'yz itym pyrer rehe opo'o 100 a'e kury. Umueta tetea'u kar Tupàn Tuweharupi Wiko Ma'e ima'e izupe a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tuweharupi upyhyk amo temetarer oho iko. Hemetarer katu ma'e azeharomoete har romo hekon kury. Ikàg ma'e romo hekon no. ");
INSERT INTO gubBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Heta tetea'u ma'ea'yr izupe wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà. Heta tetea'u uma'ereko ma'e izupe wà no. A'e rupi Piri ywy rehe har hewyrowyroahy hehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A'e 'ym mehe tu Àmàrààw a'e, wiko mehe we a'e, uhàwykàz kar 'yzygwar tetea'u wemiruze'eg wanupe a'e. Izak heimaw waneta tetea'u haw hexak mehe a'e ywy rehe har umynehem a'e 'yzygwar oho ywy pupe a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Amo 'ar mehe Amimerek uze'eg Izak pe kury. — Eho ureiwy wi nehe ty, ta'e ereiko ikàg wera'u ma'e romo urewi ne xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Uhem Izak a'e wi kury. Umuapyk wàpuzràn oho ywy Zerar ywyàpyznaw rehe kury. Umumaw amo kwarahy a'e pe wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Uwàpytymawok wi a'e 'yzygwar Àmàrààw 'ar rehe iapo pyrer Piri ywy rehe har wanemimuaiw kwer. Omono wi her kwehe arer a'e 'yzygwar wanupe. Tu Àmàrààw omono her a'e 'yzygwar wanupe a'e 'ym mehe. Izak ima'enukwaw waner wanehe. Omono wiwi wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Amo 'ar mehe Izak pe uma'ereko ma'e wiko ywyàpyznaw rehe wà kury, amo 'yzygwar ihàwykàz pà wà kury. Wexak 'yzygwar ipyahu ma'e ikatuahy ma'e a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Àràpuhàràn wamono'ogar Zerar ywy rehe har wà, uzàmàtyry'ym Izak hemiruze'eg oho wà. — Uruiko 'aw 'yzygwar izar romo ure, i'i Zerar rehe har Izak hemiruze'eg wanupe wà. A'e rupi Izak omono her a'e 'yzygwar pe. — Zeàmàtyry'ymaw, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A'e re Izak pe uma'ereko ma'e uzapo amo 'yzygwar a'e wà kury. Uzàmàtyry'ym wi a'e ywy rehe har wà a'e wà no. A'e rupi — Zaneàmàtyry'ymar, i'i Zako izupe, her romo imono pà izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Uhem Izak a'e wi. Uzapo amo 'yzygwar. A'e ywy rehe har nur kwaw waàmàtyry'ym pà wà kury. A'e rupi Izak omono amo her a'e 'yzygwar pe kury. — Zanewe ywy heta tete haw, i'i izupe. — Tupàn Tuweharupi Wiko Ma'e umur ywy tetea'u zanewe kury, zanereko àwàm romo kury. A'e rupi zaiko katu putar xe zane nehe, i'i wemiaihu wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","A'e wi oho Izak Merexewa tawhu pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pyhaw Tupàn Tuweharupi Wiko Ma'e uzexak kar wà izupe uze'eg pà kury. — Aiko neru Àmàrààw izar romo ihe. Ekyze zo ihewi nehe, ta'e aiko nerehe we ihe xe. Amume'u izuapyapyr tetea'u heremiruze'eg Àmàrààw pe ihe wà. A'e rupi amono putar heze'egatu nerehe ihe nehe kury. Amueta tetea'u kar putar nezuapyapyr ihe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Izak uzapo ma'ea'yr hapy haw a'e pe Tupàn henataromo. Umuwete katu Tupàn Tuweharupi Wiko Ma'e a'e pe. Umuapyk wàpuzràn a'e pe. Hemiruze'eg uhàwykàz amo 'yzygwar a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Amo 'ar mehe Amimerek uhem Zerar tawhu wi a'e kury, Izak pe uze'eg pà a'e kury. Imyrypar Awzat a'e, imyrypar Piko zauxiapekwer wanuwihaw a'e no, oho hupi a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Upuranu Izak wanehe a'e pe wahem mehe. — Màràzàwe tuwe pezur xe ihewe peze'eg pà. Napeakatuwawahy kwaw herehe pe. Hemuhem kar pe peywy wi. ");
INSERT INTO gubBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Uze'eg izupe wà. — Ko 'ar rehe urukwaw katu Tupàn Tuweharupi Wiko Ma'e nerehe we heko haw ure. A'e rupi uruzapokatu putar ureze'egaw nerehe we nehe. Urepurumume'uahy wer ureremiapo ràm ikatu ma'e rehe newe ure kury. Urepurenu wer neremiapo ràm ikatu ma'e neremimume'uahy rehe ure no. ");
INSERT INTO gubBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","— Nazapo pixik kwaw ikatu 'ym ma'e peme nehe, ere urewe nehe. — Nuruzapo pixik kwaw ikatu 'ym ma'e newe ure nehe, uru'e putar newe nehe no. Uruereko katu ure. Urumuhem kar urereko haw wi nezuka 'ym pà ure. A'e re Tupàn Tuweharupi Wiko Ma'e uzapo xo ikatuahy ma'e zo newe a'e. Uruexak hemiapo kwer ikatu haw ure, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Na'e Izak uzapo kar mynykaw kury, mai'u haw uhua'u ma'e iapo kar pà kury. Paw rupi umai'u katu wà, ui'u pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Iku'egwer pe upu'àm izi'itahy wà. Uzapokatu uze'egaw uzehezehe wà. Pitàitàigatu umume'uahy wemiapo ràm ikatu ma'e uzeupeupe wà. — Zazur rihi, i'i Izak wanupe a'e re. Oho a'e wi wà, umyrypar rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","A'e 'ar mehe we Izak pe uma'ereko ma'e uhem wà uzar pe uze'eg pà wà. — Uruexak 'y ywykwar ipyahu ma'e pupe ure kury, ureremiapo romo kwer pe ure kury, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izak omono her 'yzygwar pe. — Xewa, i'i izupe. — Ma'e zaneremimume'uahy kwer, i'i her zaneze'eg rupi. Te ko 'ar rehe teko ukwaw a'e tawhu her kwehe arer wà. — Merexewa, i'i izupe ko 'ar rehe wà. — 'Yzygwar ma'emume'uahy awer, i'i tawhu her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","40 kwarahy hereko mehe Ezau wereko Zuzit Meeri tazyr wemireko romo. Wereko Mazemat Erom tazyr wemireko romo no. Etew izuapyapyr romo wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","A'e mokoz kuzà umuiro kar Izak heko awer a'e wà, umuaiw kar Hemek heko awer a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Itua'uhez Izak kury. Nahehàpyhà kwaw kury. Amo 'ar mehe wenoz wa'yr ipy Ezau uzeupe kury. — Hera'yr, i'i izupe. — Aiko xe, heru, i'i ta'yr u pe. Uze'eg wi tu izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","— Erexak hetua'uhez taw ne. Nan kwehe tete amàno putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","A'e rupi epyhyk newyrapar nehe, neru'yw nehe. Eho ka'a pe amo miar izuka pà ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Emuhyk amo temi'u hete katu ma'e nehe, heremimutar rupi nehe. I'u pawire amono putar heze'egatu nerehe nehe, hemàno 'ym mehe we nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hemek wenu a'e ma'e imume'u mehe a'e, Ezau pe Izak ize'eg mehe a'e. A'e rupi izemi'ikar mehe ");
INSERT INTO gubBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","uze'eg oho Zako pe kury. — Aenu neru kwez neryky'yr Ezau pe ize'eg mehe ihe. Nezewe i'i kwez izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","— Eho ka'a pe amo miar izuka pà ihewe nehe, i'i kwez izupe. — Emuhyk amo temi'u hete katu ma'e ihewe nehe, i'i kwez izupe. — I'u pawire amono putar heze'egatu nerehe Tupàn Tuweharupi Wiko Ma'e henataromo ihe nehe, hemàno 'ym mehe we ihe nehe, i'i kwez izupe, i'i umemyr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","— A'e rupi, hememyr, ezeapyaka katu heze'eg rehe nehe. Ezapo ma'e heze'eg rupi katete nehe, i'i Hemek. ");
INSERT INTO gubBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Eho zanereimaw wamono'ogaw pe nehe. Erur mokoz àràpuhàràna'yr ikatu wera'u ma'e ne wà nehe. Amuhyk putar amo temi'u hete katu ma'e ihe nehe, neru hemimutar rupi ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E'u kar heraha izupe nehe. I'u re neru omono putar uze'egatu nerehe nehe, umàno 'ym mehe we nehe, i'i umemyr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","— Heryky'yr haw katu a'e. Ihe naheraw katu kwaw ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Aze heru opokok herehe nehe, aze hekwaw nehe, ukwaw putar heremu'emaw nehe. — A, erezeagaw neremu'em pà ihewe, i'i putar ihewe nehe. A'e mehe omono putar uze'egaiw herehe nehe, nomono kwaw uze'egatu herehe nehe, i'i uhy pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Uze'eg wi ihy izupe. — Aze nezewe haw uzeapo nehe, tuwe ize'egaiw u'ar herehe nehe, hememyr. Ezapo ma'e heze'eg rupi katete nehe. Erur àràpuhàràna'yr eho ihewe wà nehe, i'i Hemek umemyr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Oho Zako àràpuhàràna'yr wapyhyk pà. Werur uhy pe wà. Umuhyk temi'u hete katu ma'e Izak hemimutar zàwenugar. ");
INSERT INTO gubBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","A'e re Hemek upyhyk Ezau ikamir ikatu wera'u ma'e tàpuz me imonokatu pyrer oho. Umunehew kar Zako pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Uzàpixipixi àràpuhàràna'yr ipirer Zako ipo rehe iazu'yw rehe, ta'e Zako nahaw katu kwaw a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A'e re omono a'e wemiapo kwer temi'u hete katu ma'e Zako pe. Omono typy'ak wemiapo kwer izupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Na'e Zako oho u henaw pe izupe uze'eg pà kury. — Papaz, i'i izupe. — Aiko xe ihe, i'i tu izupe. — Mo romo ereiko ne, hera'yr, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","— Ezau nera'yr ipy romo aiko ihe, i'i mua'u Zako. — Azapo ma'e kwez neze'eg rupi katete ihe. Epu'àm kury. Eapyk pe pe kury. E'u miar heremizuka kwer ho'o kwer nehe. A'e re emono neze'egatu herehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Upuranu Izak hehe. — Màràzàwe erexak miar izuka pyr na'arewahy aipo ne. Ma'e pe erexak ra'e, i'i izupe. — Tupàn Tuweharupi Wiko Ma'e nezar a'e, hepytywà hexak mehe a'e, i'i mua'u u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Na'e uze'eg wi Izak Zako pe. — Ezur xe heruwakea'i ty. Hepokok wer nerehe. Nezewe mehe akwaw putar tuwe Ezau romo nereko haw, u akwaw putar Ezau romo nereko 'ymaw, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Uhem Zako Izak huwakea'i. Opokok Izak wa'yr rehe. — Neze'eg nuzawy kwaw Zako ze'eg. Nepo nuzawy kwaw Ezau ipo. ");
INSERT INTO gubBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nukwaw kwaw Zako romo heko haw, ta'e ipo haw katu a'e xe, Ezau ipo zàwegatete a'e xe. A'e rupi omono uze'egatu hehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Imume'u 'ym mehe we upuranu wi hehe. — Aipo hera'yr Ezau romo ereiko azeharomoete ne, i'i izupe. — He'e ty, aiko ihe ty, i'i mua'u Zako izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Na'e i'i tu izupe. — Erur a'e miar ho'o kwer ihewe kury, i'u kar pà ihewe kury. A'e re amono putar heze'egatu nerehe nehe, i'i izupe. U'u kar Zako temi'u u pe. U'u kar ma'e'a tykwer win her ma'e izupe no. Umai'u Izak. Ui'u win pupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","A'e re i'i wa'yr pe. — Ezur xe, hera'yr. Hezurupyter pe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Uhem Zako u huwakea'i kury. Uzurupyter kury. Wetun ikamir kury, Ezau ikamir Zako hemimunehew kwer kury. A'e rupi omono uze'egatu hehe. Na'aw ize'eg awer xe: A, aitun hera'yr. Nuzawy kwaw ka'a pe har hyàkwenaw a'e, Ka'a Tupàn Tuweharupi Wiko Ma'e hemimukatu kwer ài a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hera'yr, tuwe Tupàn umur zuwiri ywate har nerehe nehe, tuwe neremitygwer hezuz katu nehe, tuwe heta tetea'u arozràn newe nehe, tuwe heta tetea'u win newe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tuwe ereiko teko tetea'u wazar romo nehe, waneruze'egar romo nehe, tuwe teko tetea'u nemuwete katu wà nehe. Tuwe erezapo kar ma'e neànàm wanupe nehe. Tuwe amogwer nehy izuapyapyr nemuwete katu wà nehe. Aze amo omono uze'egaiw nerehe wà nehe, tuwe iaiw ma'e uzeapo wanupe nehe. Aze amo omono uze'egatu nerehe wà nehe, tuwe ikatu ma'e uzeapo wanupe nehe, i'i Izak wa'yr Zako pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Umumaw Izak uze'egatu imono haw a'e kury. Ta'yr Zako uhem oho a'e wi. A'e 'ar mehe we uhem Ezau wà a'e pe kury, uzemi'i kar ire kury. ");
INSERT INTO gubBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A'e a'e no, uzapo temi'u hete katu ma'e u pe heraha pà a'e no. Uze'eg izupe. — Epu'àm ty, e'u miar ho'o kwer heremizuka kwer nehe ty. A'e re emono neze'egatu herehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Na'e Izak upuranu hehe kury. — Mo romo ereiko ne, i'i izupe. — Ezau ihe, nera'yr ipy romo aiko ihe, i'i ta'yr izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Uzemumikahy Izak uryryryryz tà kury. Upuranu hehe. — Amo uzuka miar kwez a'e. Mo romo a'e. Werur temi'u kwez ihewe. Nehem 'ym mehe we a'u kwez ihe. Amono heze'egatu kwez hehe kury. A'e ae wiko putar heze'egatu hereko har romo a'e nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ize'eg henu mehe Ezau uhapukaz kury, ta'e iro tuwe ize'eg awer izupe a'e xe. — Heru, emono neze'egatu herehe nehe no, i'i u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Uze'eg Izak izupe. — Nerywyr ur kwez xe a'e, hemu'em kwez ihewe a'e. A'e rupi amono heze'egatu kwez hehe. A'e rupi napuner kwaw nerehe imono haw rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","I'i Ezau izupe. — Mokoz haw hemu'em a'e. A'e rupi azeharomoete her a'e. Zako her romo a'e. (— Hemu'em ma'e, i'i her zaneze'eg rupi.) Izypy mehe weraha nera'yr ipy romo hereko haw ihewi. Kutàri weraha ze'egatu herehe imur pyrer kwez ihewi no. Papaz, aipo naheta we kwaw amo neze'egatu herehe neremimur ràm, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Uwazar ize'eg izupe. — Amuigo kar Zako kwez nezar romo ihe. Amuigo kar iànàm paw hemiruze'eg romo ihe wà no. Amume'u temi'u tetea'u ipyhyk àwàm kwez izupe ihe no. Amume'u win tetea'u ipyhyk àwàm kwez izupe ihe no. A'e rupi, hera'yr, napuner kwaw ni pitài ma'e iapo haw rehe newe ihe kury, i'i Ezau pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nezewe rehe we uze'eg wi Ezau izupe. — Aipo xo pitài neze'egatu zo heta newe. Emono a'e neze'egatupixik ihewe nehe no, i'i izupe. Uzypyrog uzai'oahy pà. ");
INSERT INTO gubBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","I'i Izak izupe. Ereiko putar muite ywy ikatu ma'e wi nehe. Ereiko putar muite zuwiri ywak wi u'ar ma'e wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Takihepuku pupe puruzuka ma'e romo ereiko putar nehe. Nerywyr pe uma'ereko ma'e romo ereiko putar nehe. Amo 'ar mehe nereko haw iro putar newe nehe. A'e mehe erehem putar izuwi nehe, izupe uma'ereko ma'e romo nereko re nepytu'u pà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Na'iakatuwawahy kwaw Ezau Zako rehe, ta'e tu omono uze'egatu Zako pe a'e xe. A'e rupi uze'eg uzeupe kury. — Heru umàno putar tàrityka'i nehe. Imàno haw rehe zanezai'o pawire azuka putar herywyr ihe nehe, i'i uzeupe upy'a pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Amo umume'u Ezau hemiapo ràm Hemek pe. A'e rupi wenoz kar Zako imuwà. A'e pe ihem mehe uze'eg izupe. — Ezeapyaka katu heze'eg rehe nehe. Neryky'yr Ezau umume'u nerehe uzepyk àwàm a'e. Ipuruzuka wer nerehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","A'e rupi, hememyr, einu katu heze'eg kury. Kutàri eho hekywyr Àràmàw heko haw Àrà ywy rehe har pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Emumaw amo 'ar a'e pe nereko pà nehe. Amo 'ar mehe upaw putar neryky'yr nerehe iakatuwawahy 'ymaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Heharaz putar neremiapo kwer wi nehe. A'e mehe erepuner nezewyr haw rehe xe nehe. Amono kar putar amo teko newe ihe nehe, nereruzewyr pà a'e wi a'e 'ar mehe ihe nehe. Naputar kwaw mokoz hememyr wazuka haw pitài 'ar mehe àràm ihe, i'i Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A'e re oho Hemek Izak pe uze'eg pà. — A'e mokoz kuzà nera'ytaty Etew izuapyapyr a'e wà, Ezau hemireko a'e wà, iro ihewe a'e wà, i'i izupe. — Aze Zako wereko amo xe har Etew izuapyapyr wemireko romo nehe, àmàno putar ihe nehe. Ikatu wera'u mo nezewe haw, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Na'e Izak wenoz Zako imuwà kury. Omono uze'egatu hehe. Uzapo kar ma'e izupe no. — Ereko zo amo kuzàwaza ko ywy rehe har Kànàà ywy rehe har neremireko romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ezemuàgà'ym nehe, eho ywy Mezopotàm her ma'e pe nehe. Epyta neràmuz Metuwew hàpuz me nehe. Ereko amo kuzà netutyr Àràmàw tazyr neremireko romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Tuwe Tupàn ikàg wera'u ma'e omono uze'egatu nerehe nehe, tuwe umueta tetea'u kar nezuapyapyr wà nehe. Tuwe nezuapyapyr uzemono'og ma'e ràm wiko teko ikàg ma'e romo wà nehe. Nezewe mehe ereiko putar teko tetea'u wanu romo ne nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tuwe omono uze'egatu nerehe nehe, nezuapyapyr wanehe nehe no, neràmuz Àmàrààw rehe uze'egatu imono awer zàwegatete nehe no. Nezewe mehe nezuapyapyr wiko putar ko ywy izar romo wà nehe. Izypy mehe Tupàn umur ko ywy Àmàrààw pe. A'e ae a'e, zane ae zane no, zaiko ko ywy rehe amo ae ywy rehe har ài zane. A'e 'ar mehe nezuapyapyr wiko putar ko ywy izarete romo a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Nezewe Izak omono kar wa'yr Zako Mezopotàm ywy rehe a'e. Wiko oho Àràmàw heko haw pe. Àràmàw a'e, Metuwew Àràm ywy rehe har ta'yr romo Hemek ikywyr romo hekon a'e. Hemek wiko Ezau ihy romo, Zako ihy romo. ");
INSERT INTO gubBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezau ukwaw Izak Zako rehe uze'egatu hemimono kwer a'e. Ukwaw Mezopotàm pe imono kar awer no. — Exaexak amo kuzàwaza neremireko ràm romo a'e pe nehe, i'i Izak Zako pe. Ize'egatu imono mehe uzapo kar amo ma'e izupe. — Ereko zo amo kuzà xe har Kànàà ywy rehe har neremireko romo nehe, i'i izupe. Ezau ukwaw a'e ma'e paw rupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Zako weruzar u ze'eg uhy ze'eg a'e. A'e rupi oho Mezopotàm ywy rehe. Ezau ukwaw uwywyr hemiapo kwer a'e, ukwaw waze'eg heruzar awer. Ukwaw a'e ywy rehe iho awer no. ");
INSERT INTO gubBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ukwaw Ezau u ima'enukwaw paw a'e. — Kuzà xe har Kànàà ywy rehe har iro heru pe a'e wà, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","A'e rupi oho Ezau Àmàrààw ta'yr Izimaew her ma'e heko haw pe kury. Wereko Izimaew tazyr Marat her ma'e uzeupe wemireko romo kury. Nemaiot ikypy'yr romo hekon. ");
INSERT INTO gubBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Uhem Zako oho Merexewa tawhu wi. Àrà pe iho wer. ");
INSERT INTO gubBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Karuketea'i mehe uhem amo ywy pehegwer Tupàn pe imonokatu pyrer pe. Uker a'e pe. Upyhyk amo ita a'e pe har wàkàg iwy pe har uker mehe har romo. Uzepàriràg a'e pe uker pà. ");
INSERT INTO gubBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Upuahu kury. Wexak amo myràmyràgaw a'e pe upuahu mehe. Myràmyràgaw uzypyrog ywy rehe ywak rehe oho pà. Tupàn heko haw pe har uzeupir oho hehe wà. Wezyw wà hehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tupàn Tuweharupi Wiko Ma'e wiko huwake. Uze'eg Zako pe. — Aiko tuweharupi wiko ma'e romo ihe. Neràmuz Àmàrààw izar romo aiko. Neru Izak izar romo aiko. Ko ywy neker haw amono putar newe nereko haw romo ihe nehe. Nezuapyapyr wanupe amono putar waneko haw romo ihe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nezuapyapyr waneta àwàm nuzawy kwaw ywy imuku'i pyrer heta haw wà nehe. Uhàuhàz putar ywy rehe wà nehe: kwarahy ihemaw awyze har kutyr, kwarahy heixe haw awyze har kutyr, kwarahy ihemaw kutyr, kwarahy heixe haw kutyr. Amono putar heze'egatu teko ywy rehe har uzeànàànàm ma'e nànàn ihe nehe. Ta'e ereiko heremiruze'eg romo ne xe. Ta'e nezuapyapyr wiko heremiruze'eg romo a'e wà no xe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aiko putar nerehe we ihe nehe. Wyzài ywy rehe neho mehe urupyro putar ikatu 'ymaw wi ihe nehe. Urumuzewyr kar putar ko ywy rehe ihe nehe no. Azapo putar ma'e ko heze'eg rupi tuweharupi ihe nehe. Azapo putar ko heremimume'u kwer upaw rupi nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ume'e upuahu re kury. Uze'eg uzeupe. — Azeharomoete Tupàn Tuweharupi Wiko Ma'e xe hekon a'e. Karumehe nakwaw kwaw xe heko haw ihe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A'e rupi ukyze kury. — 'Aw ywy hemukyze kar a'e. Tupàn hàpuz xe hin a'e. Ywak pupe teixe haw xe hin a'e, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Izi'itahy upu'àm. Upyhyk a'e ita wàkàg iwype har. Umupu'àm a'e ita a'e pe kury, Tupàn imuwete katu haw romo kury. A'e re uzakook uri kawer ita rehe, imonokatu pà Tupàn pe imuwete katu haw romo. ");
INSERT INTO gubBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Amo tawhu a'e ywy rehe tuz. Iruz her romo a'e. Zako omono amo ae her izupe kury. — Metew, i'i her ipyahu ma'e kury. — Tupàn hàpuz, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","A'e pe Zako umume'uahy wemiapo ràm Tupàn pe kury. — Aze ereata eho herupi nehe, aze hepyro pe ikatu 'ym ma'e wi heata mehe ko 'ar rehe nehe, aze eremur hema'e ràm ihewe nehe, aze eremur heremi'u ràm ihewe nehe, ");
INSERT INTO gubBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","aze azewyr heru heko haw pe hemàno 'ym pà nehe, a'e mehe ne Tupàn Tuweharupi Wiko Ma'e ereiko putar hezar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","'Àg ita nemuwete katu haw a'e nehe, neràpuz romo upyta putar a'e nehe, Tupàn. Aze eremur 10 ma'e ihewe nehe, amuzewyr putar pitài ma'e newe nehe. Nezewegatete hema'e nànàn nehe: àràpuhàràn, tapi'ak, heremetarer. Amono putar hema'e ikurer newe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Wata Zako oho iko. Uhem ywy kwarahy ihemaw kutyr har pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A'e ywy rehe ume'e mehe wexak amo a'e pe kury. Heta na'iruz awa àràpuhàràn imono'ogar 'yzygwar huwake a'e wà. Pitàitàigatu uzekaiw waiko weimaw àràpuhàràn hawitu ma'e wanehe wà, àràpuhàrànete wanehe wà no. Waneimaw waiwez mehe wenuhem 'y a'e 'yzygwar wi wanupe wà. Uwàpytym 'yzygwar itahu pupe tuweharupi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Aze àràpuhàràn mono'ogar paw uzemono'og a'e pe wà, weimaw wanehe we wà, umunyryk kar itahu 'yzygwar wi wà, 'y imono pà weimaw wanupe wà. A'e re omono wi itahu 'yzygwar ikwar rehe wà, iwàpytym wi pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Upuranu Zako ma'ea'yr wamono'ogar wanehe kury. — Ma'e wi pezur, hemyrypar wà, i'i wanupe. — Àrà ywy rehe har romo uruiko ure, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Upuranu wi wanehe. — Aipo pekwaw Àràmàw Naor ta'yr, i'i wanupe. — Urukwaw ure, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","— Aipo ikatu a'e, i'i wanupe. — He'e, ikatu a'e. Eme'e pe pe ty. Tazyr Hakew ur iko weimaw àràpuhàràn wanerur pà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","— Nuixe kwaw kwarahy a'e rihi. Aze mo pemono 'y peneimaw wanupe, pepuner mo waneraha wi haw rehe ka'api'i heta haw pe nehe. Nuhem kwaw penàpuz huwake wamono'ogaw 'ar a'e rihi, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","— Nurupuner kwaw ure. Àràpuhàràn paw xe waneko mehe urupuner itahu imunyryk kar haw rehe 'yzygwar ikwar wi. A'e mehe oromono 'y wanupe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Uze'eg Zako iko wanupe. Ize'eg mehe we uhem Hakew a'e pe. Àràpuhàràn mono'ogar romo hekon a'e. Uhem a'e pe u heimaw wanerur pà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Wexak Zako ututyr Àràmàw heimaw wanehe we tur mehe. Umunyryk kar itahu oho 'yzygwar ikwar wi kury. Omono 'y ma'ea'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","A'e re uzurupyter Zako Hakew kury. Hurywete a'e. A'e rupi uzypyrog uzai'oahy pà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","— Neru iànàm romo aiko ihe. Hemek imemyr ihe. Uzàn Hakew oho a'e ma'e paw imume'u pà u pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Wenu weinyr imemyr heko haw imume'u haw. Uzàn oho a'e wi. Zako huwàxi mehe uzàzuwàzuwàn izurupyter pà kury. Weraha wàpuz me. Zako umume'u ma'e uzeapo ma'e kwer paw izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","A'e ma'e henu re — Azeharomoete ereiko hero'o romo ne, ereiko heruwy romo ne. Ereiko heànàmete romo, i'i izupe. Umumaw Zako pitài zahy a'e pe ututyr heko haw pe wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Amo 'ar mehe Àràmàw uze'eg Zako pe kury. — Erema'ereko iko ihewe hekuzar 'ym pà ne, ta'e ereiko heànàm romo ne xe. Na'ikatu kwaw nezewe haw ihewe. Màràn amono putar newe nema'ereko haw hekuzaromo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Heta mokoz tazyr Àràmàw pe wà. — Erez, tyker her romo a'e. — Hakew, ikypy'yr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ipuràg eteahy Erez heha. Hakew ipuràg eteahy tuwe a'e. Huwa ipuràg eteahy, hetekwer ipuràg eteahy no. ");
INSERT INTO gubBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Uzamutar katu Zako Hakew. A'e rupi uze'eg nezewe tu pe. — Amumaw putar 7 kwarahy newe hema'ereko pà nehe, aze eremur nerazyr Hakew heremireko ràm romo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","— Àràmàw uze'eg izupe. Ikatu wera'u newe imono haw heremigwaw 'ym pe imono haw wi a'e. Epyta xe hepyr nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","A'e rupi Zako umumaw 7 kwarahy izupe uma'ereko pà Hakew hereko àwàm hekuzaromo. Uzamutar katu a'e, a'e rupi a'e 7 kwarahy nuzawy kwaw 7 'ar izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","A'e 7 kwarahy imumaw ire uze'eg Zako Àràmàw pe. — Emur Hakew ihewe heremireko romo kury ty. A'e 7 kwarahy zaneremimume'u kwer upaw kwez kury. Hepurereko wer tuwe hehe heremireko romo ihe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Uzapo Àràmàw mynykawhu izupe izereko haw rehe. Wenoz teko a'e ywy rehe har paw wamuwà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pyhaw Àràmàw upyhyk wazyr ipy Erez kury, imono pà Zako pe kury. Uker Zako ipuhe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","A'e 'ym mehe we Àràmàw omono amo kuzà uma'ereko e ma'e Ziwpa her ma'e a'e, wazyr Erez pe a'e, izupe uma'ereko e ma'e romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Xo iku'egwer pe zo Zako ukwaw Erez puhe uker awer. Uze'egahy oho Àràmàw pe. — Màràzàwe tuwe erezapo agwer iaiw ma'e ihewe. Ama'ereko tetea'u Hakew hereko àwàm hekuzaromo. Màràzàwe tuwe eremur nerazyr inugwer ihewe. Neremu'em ihewe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Uze'eg Àràmàw izupe. — Xe ko ywy rehe uruzapo nezewe haw ure. Tazyr ipy imen a'e. Xo a'e re zo ikypy'yr upuner umenaw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ximumaw 7 'ar nezereko haw rehe zanepynyk pà. A'e re aze eremume'u amo 7 kwarahy imumaw pàwàm ihewe nema'ereko àwàm nehe, a'e mehe amono putar Hakew newe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","— He'e, i'i Zako izupe. A'e rupi umumaw 7 'ar Erez rehe we uzereko haw rehe upynyk pà. A'e 'ar pawire Àràmàw omono wazyr Hakew Zako pe hemireko romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(A'e 'ym mehe we Àràmàw omono uma'ereko e ma'e Mira her ma'e Hakew pe a'e, izupe uma'ereko e ma'e romo a'e.) ");
INSERT INTO gubBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Uker Zako oho Hakew puhe kury. Uzamutar katu Erez. Uzamutar katu wera'u Hakew. Umumaw amo 7 kwarahy Àràmàw pe uma'ereko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Zako nuwereko katu kwaw Erez. Tupàn Tuweharupi Wiko Ma'e wexak Zako ima'enukwaw paw ipy'a pe har. A'e rupi umumemyr kar Erez kury. Hakew nupuner kwaw umemyr haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ipuru'a Erez kury. Imemyrzexak kar kury. Awa a'e. Humen, her romo a'e. — Exak hememyr, i'i her zaneze'eg rupi. — Tupàn Tuweharupi Wiko Ma'e wexak hezemumikahy awer a'e. A'e rupi hemumemyr kar kwez kury. A'e rupi hemen heamutar katu putar a'e nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ipuru'a wi kury. Imemyrzexak kar wi. Awa a'e. — Ximeàw, her romo a'e. — Herenu, i'i her zaneze'eg rupi. — Azemumikahy ihe. Tupàn Tuweharupi Wiko Ma'e wenu heze'eg. A'e rupi umur amo kwarer ihewe hememyr romo. ");
INSERT INTO gubBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ipuru'a wi Erez kury. Imemyrzexak kar wi. Awa a'e. — Erewi, her romo. — Zanemono'ogaw, i'i zaneze'eg rupi. — Hemen uzemono'og wera'u putar herehe we a'e nehe kury, ta'e amono na'iruz ta'yr izupe ihe wà, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ipuru'a wi kury. Imemyrzexak kar wi. Awa a'e. — Zuta, her romo. (—Muwete katu haw, i'i her zaneze'eg rupi.) — Amuwete katu putar Tupàn Tuweharupi Wiko Ma'e ihe nehe, i'i Erez uzeupe. A'e re na'imemyr wi kwaw a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hakew ukwaw umemyr haw rehe upuner 'ymaw. A'e rupi hewyrowyroahy wyker rehe kury. Uze'eg umen pe. — Aze neremur kwaw hememyr ihewe amàno putar nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Wikwahy Zako Hakew pe. — Aipo Tupàn romo aiko ihe. A'e ae nanemumemyr kar kwaw a'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","— Nako ihewe uma'ereko ma'e Mira her ma'e a'e 'y. Eho ipuhe nehe. Imemyr mehe imemyr wiko putar hememyragaw romo nehe. Nezewe mehe aiko putar ihy uma'ereko e ma'e inuromo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","A'e rupi Hakew omono uma'ereko e ma'e Mira her ma'e Zako pe hemirekoagaw romo a'e. Uker oho ipuhe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ipuru'a Mira kury. Omono amo ta'yr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Uze'eg Hakew kury. — Ko kwarer a'e, — Nà, her romo a'e, ta'e Tupàn ikatu ihewe a'e, i'i. (-Ikatu haw iapo haw, i'i her zaneze'eg rupi.) — Wenu heze'eg a'e, umur amo kwarer ihewe hememyr romo a'e, i'i. ");
INSERT INTO gubBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ipuru'a wi Mira. Omono amo ta'yr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Uze'eg Hakew nezewe kury. — Ko kwarer a'e, — Napitari, her romo a'e. (-Zeàmàtyry'ymaw, i'i her zaneze'eg rupi.) — Ta'e azàmàtyry'ym heryker ihe. Aityk ihe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Erez ukwaw weko haw. — Nahememyr wi kwaw ihe nehe, i'i uzeupe. A'e rupi omono uma'ereko ma'e Ziwpa her ma'e Zako pe kury, hemirekoagaw romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ziwpa omono amo ta'yr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Na'e Erez uze'eg nezewe kury. — Ikatuahy ma'e uzeapo ihewe, i'i. A'e rupi — Kaz, amono putar izupe her romo. (-Ikatuahy ma'e uzeapo haw, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","A'e re Ziwpa omono amo ta'yr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","— Herurywete tuwe ihe. Amogwer kuzà umume'u putar herurywete haw a'e wà nehe. A'e rupi — Azer, kwarer her romo a'e nehe, i'i Erez uzeupe. (-Hurywete ma'e, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Amo 'ar mehe arozràn po'o haw 'ar mehe Humen oho ko pe a'e kury. A'e pe wiko mehe wexak amo ka'a manarak her ma'e a'e. (Kuzà imupuru'a kar har a'e, i'i teko izupe wà.) Weraha Humen a'e ka'a uhy Erez pe. Hakew wexak herur mehe. Uze'eg Erez pe. — Emur amo manarak nememyr hemirur kwer ihewe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Uze'eg Erez izupe. — Erepyro hemen ihewi ne. Aipo nuhyk kwaw newe, i'iahy izupe. — Aipo nepurupyro wer manarak hememyr hemimur kwer rehe ihewi no, i'iahy izupe. Na'e uze'eg Hakew izupe. — Aze eremur amo manarak ihewe nehe, amuger kar putar Zako nepuhe kutàri pyhaw ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Karuketea'i mehe ko wi Zako ihem mehe Erez oho huwàxi mà. Uze'eg izupe. — Kutàri pyhaw ereker putar hepuhe nehe. Hepuhe neker haw amekuzar kwez ihe, manarak hememyr hemimur kwer pupe ihe, i'i izupe. A'e 'ar mehe pyhaw uker Zako oho ipuhe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Wenu Tupàn Erez ize'eg awer a'e. Ipuru'a wi kury. Omono amo ta'yr Zako pe. 5 haw imemyr haw kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Uze'eg Erez kury. — Ko kwarer a'e, Ixakar her romo a'e, ta'e Tupàn umekuzar uma'ereko ma'e hemen pe heremimono kwer ihewe a'e, i'i uzeupe. (-Hekuzar, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","A'e re ipuru'a wi Erez no. 6 haw ipuru'a haw kury. Omono amo ta'yr Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","— Tupàn umur ma'e ipuràg eteahy ma'e kwez ihewe a'e. Hemen upyta putar hepyr a'e nehe kury, ta'e amono 6 ta'yr izupe ihe wà 'y, i'i Erez uzeupe. A'e rupi omono Zemurom her romo. (— Ipuràg eteahy ma'e imur awer, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Iahykaw rehe ipuru'a wi no. Uzexak kar imemyr kury. Kuzà a'e. Omono Zina her romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Na'e Tupàn ima'enukwaw Hakew rehe kury. Wenu ize'eg mehe. Umupuru'a kar kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ipuru'a a'e. Uzexak kar imemyr kury. Awa a'e. Uze'eg nezewe kury. — Tupàn a'e, nahemumaranugar wi kar kwaw hememyr 'ymaw rehe a'e, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","— Tuwe Tupàn umur amo hememyr awa ihewe nehe. A'e rupi izexak kar mehe omono Zuze her romo kury. (— Amo ae imur awer, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Zuze izexak kar ire Zako uze'eg Àràmàw pe. — Tuwe azewyr heywy rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","— Emur hera'yr ihewe wà nehe. Emur heremireko ihewe ne wà nehe, ta'e ama'ereko newe wamekuzar pà ihe xe. Heho wer xe wi ihe. Erekwaw katu newe hema'ereko katu awer ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","— Epyta hepyr nehe ty. Hezar tupàn a'ua'u a'e wà, uze'eg kwez ihewe a'e wà. — Tupàn Tuweharupi Wiko Ma'e omono uze'egatu iko nerehe a'e, ta'e Zako wiko xe nepyr a'e xe, i'i ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Màràn ereputar xe nepyta àwàm hekuzaromo. Wyzài ma'e amono putar newe nehe, i'i Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Na'e Zako uze'eg izupe. — Erekwaw hema'ereko katu awer. Azekaiw katu nereimaw wanehe ihe no. Erekwaw wanehe hezekaiw awer ne no. ");
INSERT INTO gubBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Xe hezur 'ym mehe we naheta tetea'u kwaw ma'e newe. Hezur ire eremono'og ma'e tetea'u ne. Heta tetea'u nereimaw newe wà. Tupàn Tuweharupi Wiko Ma'e omono tuwe uze'egatu nerehe, ta'e aiko xe nepyr ihe xe. Uhyk kury. Azekaiw katu putar heànàm wanehe ihe nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","— Màràn temetarer ereputar, i'i wi Àràmàw izupe. Uze'eg wi Zako izupe. — Naputar kwaw temetarer. Aze erezapo ma'e heremimume'u ràm rupi nehe, azekaiw wiwi putar nereimaw àràpuhàràn wanehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kutàri ame'e putar nereimaw wanehe upaw rupi ihe nehe. Aze amo àràpuhàràn ipihun wà nehe, apyhyk putar hezeupe ihe wà nehe. Aze amo àràpuhàrànete ipinipinim wà nehe, apyhyk putar ihewe ihe wà nehe. Xo a'e ma'e zo aputar heremiapo kwer hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A'e rupi erekwaw putar nerereko katu awer nehe. Aze ereme'e hereimaw wanehe nehe, aze heta ipihun 'ym ma'e wainuromo wà nehe, aze heta ipinipinim 'ym ma'e wainuromo wà nehe, erekwaw putar wanehe hemunar awer nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ikatu ize'eg Àràmàw pe. Uze'eg Zako pe kury. — He'e ty. Neremimume'u kwer ikatu ihewe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na'e Àràmàw uhaw wemimume'u kwer kury. A'e 'ar mehe we omono'og àràpuhàràn ipihun ma'e oho a'e wà kury, ipinipinim ma'e oho a'e wà no. Omono wa'yr wanupe wà, wamono'og kar pà wanupe wà. Umuzekaiw kar wanehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Umumaw na'iruz 'ar wata pà Zako wi utyryk pà kury. Upyta Zako amogwer Àràmàw heimaw wanehe uzekaiw pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na'e Zako wekar na'iruz ma'e'yw oho kury. Wexak xopu 'yw. Wexak amen 'yw no. Wexak pàràtà 'yw no. Omonohok hàkàgwer a'e na'iruz ma'e'yw wanuwi. Nezewe umupu'ypu'yw a'e na'iruz ywyra wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Omono a'e hàkàgwer imupu'yw pyrer àràpuhàràn wanenataromo kury, wai'u haw pe no. Uzapo nezewe haw a'e, ta'e àràpuhàràn awa uzeupir àràpuhàràn kuzà wanehe wà, ui'u haw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Uzeupir nezewe a'e hàkàgwer huwake waneko mehe wà, a'e rupi wamemyr uzexak kar ipinipinim ma'e romo wà, iparaparaw ma'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Omono'og Zako àràpuhàràn hawitu ma'e xe wà, omono'og àràpuhàrànete pe pe wà. Umume'e kar Àràmàw heimaw weimaw ipinim ma'e wanehe wà, ipihun ma'e wanehe wà. Omono'og ipinim ma'e ipihun ma'e wanehe wà, wapyro pà amogwer Àràmàw heimaw wanuwi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ume'e àràpuhàràn wanehe. Aze ikàg wà, omono a'e ma'e'yw hàkàgwer wai'u haw huwake wanenataromo awa kuzà wanehe we waho mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aze na'ikàg kwaw wà, nomono kwaw a'e ma'e'yw hàkàgwer wanenataromo wai'u haw huwake. Ma'ea'yr awa kuzà wanehe we waho mehe wamemyr na'ikàg kwaw wà. Àràpuhàràna'yr ikàg 'ym ma'e upyta Àràmàw pe wà. Ikàg wera'u ma'e upyta Zako pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","A'e rupi Zako hemetarer katu kury. Heta tetea'u ma'e izupe wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, uma'ereko ma'e kuzà wà, awa wà no, kamer wà, zumen wà no. Heta tetea'u izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Amo 'ar rehe Àràmàw ta'yr uzypyrog uze'eg pà Zako rehe wà. — Zako upyro zaneru ima'e paw iko uzeupe a'e. Hemetarer katu ma'e romo wiko a'e, zaneru ima'e imono'og pà a'e, i'i uzeupeupe wà. Ukwaw Zako waze'eg awer a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Izypy mehe Zako ikatuahy Àràmàw pe. Ko 'ar rehe, — Hemyrypar, ni'i kwaw Zako pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","A'e rupi Tupàn Tuweharupi Wiko Ma'e uze'eg Zako pe. — Ezewyr eho neru iziwy pe nehe, nehy iziwy pe nehe, neànàm waneko haw pe nehe. Ata putar nerupi nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Zako omono kar amo uma'ereko ma'e wemireko waneko haw pe kury. — Peho ko pe Zako heko haw pe nehe. Wiko ko pe àràpuhàràn wapyr a'e, i'i uma'ereko ma'e hemireko wanupe. Oho ipyr wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A'e pe wahem mehe uze'eg Zako wanupe. — Penu nuiko kwaw hemyrypar romo ko 'ar rehe izypy mehe arer zàwe a'e. Tupàn heru izar wiko herehe we tuweharupi a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Amumaw kwarahy tetea'u penu pe hema'ereko tetea'u pà ihe. Pekwaw hema'ereko awer. ");
INSERT INTO gubBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Imunar hema'e rehe a'e. 10 haw uzapo hema'ereko haw hekuzar amo ae ma'e romo a'e. Nezewe rehe we Tupàn nuzapo kar kwaw ikatu 'ym ma'e izupe a'e. A'e rupi nuzapo kwaw ikatu 'ym ma'e ihewe. Àràmàw nahemuigo kar kwaw hemetarer 'ym ma'e romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","— Àràpuhàràn ipinim ma'e wiko putar nema'ereko awer hekuzaromo nehe, i'i ihewe. A'e re heta imemyr ipinim ma'e àràpuhàràn wanupe a'e wà. Na'e, — Àràpuhàràn ipu'ypu'yw ma'e wiko putar nema'ereko awer hekuzaromo nehe, i'i ihewe. A'e re heta imemyr ipu'ypu'yw ma'e àràpuhàràn wanupe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nezewe Tupàn upyro neru heimaw wamono'ogaw wi a'e wà, ihewe wamur kar pà a'e wà, i'i wemireko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Amo 'ar mehe ma'ea'yr uzehezehe uzeupir mehe apuahu heker mehe ihe. Àràpuhàràn awa kuzà rehe uzeupir ma'e a'e wà, ipu'ypu'yw ma'e romo wanekon a'e wà, ipinipinim ma'e romo wà no, iparaparaw ma'e romo wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tupàn heko haw pe har herenoz herer imume'u pà a'e. — Aiko xe, a'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na'e uze'eg wi ihewe. — Eme'egatu wanehe ty, i'i ihewe. — Àràpuhàràn uzehezehe uzeupir ma'e a'e wà, ipu'ypu'yw ma'e romo iparaparaw ma'e romo ipinipinim ma'e romo wanekon a'e wà. Azapo kar nezewe haw wanupe ihe, ta'e aexak Àràmàw newe hemiapo kwer ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aiko Tupàn Metew pe newe uzexak kar ma'e kwer romo ihe. Eremonokatu ita ihewe. Erezakook uri kawer hehe herenataromo. Ezemuàgà'ym nehe kury. Ehem eho ko ywy wi nehe kury. Ezewyr eho ywy nezexak kar awer pe nehe kury, i'i Tupàn ihewe, i'i Zako wemireko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Na'e Hakew a'e, Erez a'e no, uze'eg umen pe a'e wà kury. — Naheta kwaw ureru ima'e kwer urewe. Aze umàno nehe, nurupyhyk kwaw ima'e kwer ure nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Urerereko amo ae ywy rehe har zàwe a'e. Kwehe mehe ureme'eg a'e. Upyhyk temetarer tetea'u urerekuzar romo. Umumaw a'e wemetarer paw rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tupàn upyro ureru hemetarer izuwi a'e. Hemetarer kwer upyta putar urewe nehe kury, urememyr wanupe nehe no. A'e rupi, — Ezapo Tupàn hemiapo kar paw rupi nehe, uru'e newe kury, i'i umen pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Uzemuàgà'ym Zako Kànàà ywy kutyr wata àwàm rehe kury. Tu Izak wikuwe a'e ywy rehe a'e rihi. Umuzeupir kar wa'yr wemireko kamer wakupepe wà. Omono'og uma'e paw. Uhem oho a'e wi. Weraha weimaw ma'ea'yr Mezopotàm ywy rehe uma'ereko haw pupe imono'og pyrer uzeupi wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","A'e 'ar mehe Àràmàw Hakew tu a'e, nuiko kwaw a'e pe a'e, ta'e oho amo me àràpuhàràn hawitu ma'e hawer imonohok pà a'e xe. Muite heko mehe Hakew wixe hàpuz me ima'e tupàn a'ua'u wanehe imunar pà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nezewe Zako hemu'em Àràmàw Àràm ywy rehe har pe. Numume'u kwaw oho àwàm izupe. Oho zàmim izuwi. Heko 'ym mehe uhem zàmim heko haw wi. ");
INSERT INTO gubBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Uzàn a'e wi uma'e paw heraha pà. Wahaw yrykaw Ewparat her ma'e oho wà. Wata oho waiko Zireaz ywy ywytyr heta haw kutyr wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Na'iruz 'ar pawire Àràmàw ukwaw Zako waho awer a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Omono'og wànàm Zako haikweromo oho pà wà. Umumaw 7 'ar haikweromo wata pà wà. Uhem huwake wà, ywytyr Zireaz ywy rehe har pe wà. Uker huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","A'e 'ar mehe pyhaw uzexak kar Tupàn oho Àràmàw Àràm ywy rehe har pe a'e, ipuahu mehe a'e. Uze'eg izupe. — Nema'enukwaw katu neremiapo ràm rehe nehe. Ezapo zo ikatu 'ym ma'e Zako pe nehe, i'i izupe ipuahu pe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","A'e 'ar mehe Zako upytu'u Zireaz ywy ywytyr heta haw rehe a'e. Uhem Àràmàw huwake kury. A'e ae a'e, iànàm a'e wà, upytu'u uker haw iapo pà a'e pe a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Uze'eg Àràmàw oho Zako pe kury. — Màràzàwe tuwe neremu'em ihewe. Ereraha herazyr nerupi ne wà, newe uma'ereko e ma'e wazàwe ne wà, zeàmàtyry'ymawhu pe neremipyhyk kwer wazàwe ne wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Màràzàwe tuwe neremu'em nezàn pà ihewi, ihewe neze'eg 'ym pà nezewe. Aze mo ereze'eg ihewe, a'e mehe mo azapo mo amo mynykaw purumurywete kar ma'e neho haw rehe ihe. Zazegar mo maraka pupe zane, wioràwiràn pupe zane. ");
INSERT INTO gubBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nerezurupyter kar kwaw heremimino ihewe wà. Nerezurupyter kar kwaw herazyr ihewe wà. Xo teko he'o ma'e zo uzapo agwer ma'e a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Hepurapo wer zepe ikatu 'ym ma'e rehe peme. Nazapo kwaw. Ta'e pyhaw Tupàn neru izar uze'eg wà ihewe a'e xe. — Nema'enukwaw neremiapo ràm rehe nehe. Ezapo zo ikatu 'ym ma'e Zako pe nehe, i'i Tupàn ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Erehem eho hereko haw wi, ta'e eremonokatu nereha nereko awer pe ne xe. Akwaw neho wer haw ihe. Nereiko kwaw imunar ma'e romo. A'e rupi, màràzàwe tuwe nemunar tupàn a'ua'u heràpuz me har wanehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Uwazar Zako ize'eg izupe. — Akyze newi ihe. — Upyhyk putar ru'u wazyr ihewi wapyro pà a'e wà nehe, a'e hezeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Herupi wata ma'e nuwereko kwaw tupàn a'ua'u neràpuz marer a'e wà. Aze amo wereko nehe, azuka putar a'e teko ihe nehe. Heànàm a'e wà, neànàm a'e wà no, tuwe wenu ko heze'eg heremimume'uahy ràm a'e wà nehe. Aze erexak wyzài nema'e xe urepyr nehe, erepuner heraha haw rehe nehe, i'i izupe. Nukwaw kwaw Hakew a'e tupàn a'ua'u waneraha awer a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Àràmàw wixe Zako hàpuzràn pupe. A'e re wixe Erez hàpuzràn pupe. A'e re wixe uma'ereko e ma'e wanàpuz pupe. Nezewe rehe we nuexak kwaw uma'e tupàn a'ua'u wà. Na'e oho Hakew hàpuzràn pupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A'e pe wekar ko rupi, wekar kwe rupi no. Nuexak kwaw. Ta'e Hakew omonokatu a'e tupàn a'ua'u amo kamer kupepaw wype a'e wà xe. Wapyk Hakew in hehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Uze'eg u pe kury. — Eikwahy zo ihewe nehe. Napu'àm kwaw ta'e aiko he'ar heruwy haw rehe har rehe ihe 'y, i'i u pe. Nezewe Àràmàw wekar zepe uma'e tupàn a'ua'u wà. Nuexak kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Na'e Zako wikwahy kury. Uze'eg Àràmàw pe. — Ma'e azapo newe. Aipo azapo ikatu 'ym ma'e. Màràzàwe tuwe erezur heraikweromo neikwahy pà nezewe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tàrityka'i erema'ema'e hema'e kwez ne. Aipo erexak amo nema'e hema'e inuromo. Emur ma'e neremixak kwer xe neànàm wanenataromo heànàm wanenataromo nehe. A'e ae umume'u putar ze'eg azeharomoete har. ");
INSERT INTO gubBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Amumaw 20 kwarahy hema'ereko pà newe. Nereimaw àràpuhàràn hawitu ma'e a'e wà, àràpuhàrànete a'e wà no, naheta pixik kwaw wamemyr uzexak kar mehe umàno ma'e kwer a'e wà. Ni pitài nereimaw àràpuhàràn ho'o kwer na'u pixik kwaw ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Aze zàwàruhu uzuka amo nereimaw, narur pixik kwaw newe. Ihe amono amo àràpuhàràn hereimaw a'e nereimaw hekuzaromo ihe. Aze amo imunar amo nereimaw rehe wà, tuweharupi erezur ihewe hekuzar henoz tà ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nezewe hereko awer. 'Aromo hakuahy kwarahy ihewe. Pyhaw tuwixàgaw hezuka taria'i. Amumaw pytun tetea'u heker 'ym pà ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Amumaw 20 kwarahy nereko haw pe hepyta pà. Amumaw 14 kwarahy nerazyr wamekuzar pà. Amo 6 kwarahy amumaw nereimaw ma'ea'yr wamono'og pà. 10 haw erezapo amo ae hema'ereko haw hekuzar ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tupàn heipy wazar a'e, Àmàrààw izar Izak izar a'e, aze mo nuiko iwer herehe we, hemuhem kar pe mo xe wi ma'e hereko 'ym pà ne. Tupàn wexak ma'erahy heremipuraraw kwer. Wexak hema'ereko awer. A'e rupi karumehe uze'egahy newe, i'i Zako Àràmàw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Uwazar Àràmàw Zako ize'eg izupe kury. — Ko kuzà a'e wà, herazyr romo wanekon a'e wà. Imemyr heremimino romo wanekon a'e wà no. Ko ma'ea'yr paw ko ma'e neremixak paw hema'e romo wanekon a'e wà no. Tupàn nupyhyk kar kwaw herazyr heremimino ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","A'e rupi hepurapo katu wer heze'egaw rehe nerehe we ihe kury. Xiapo ywytyra'i ita pupe xe nehe. Nezewe zanema'enukwaw putar ko zaneremimume'u ràm rehe zane nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Na'e Zako upyhyk amo ita kury, imupu'àm kar pà ywyra ài a'e pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A'e re omono'og kar ita tetea'u wànàm wanupe. — Pezapo ywytyra'i ita pupe nehe, i'i wanupe. Uzapo ma'e ize'eg rupi katete wà. A'e re umai'u a'e ywytyra'i huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","— Àràmàw omono her izupe uze'eg rupi. — Zegar-Xanuta, i'i izupe. (Ywytyr zanemuma'enukwaw kar har, i'i her zaneze'eg rupi.) Zako omono amo her izupe uze'eg rupi a'e no. — Kareez, i'i izupe. (Ywytyr zanemuma'enukwaw kar har, i'i her zaneze'eg rupi a'e no.) ");
INSERT INTO gubBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","A'e re Àràmàw uze'eg Zako pe kury. — 'Àg ita ywytyra'i iapo pyrer a'e nehe, zanemuma'enukwaw kar putar zaneremimume'u kwer rehe a'e nehe, i'i izupe. (A'e rupi, — Kareez, i'i Zako a'e ywytyra'i pe.) ");
INSERT INTO gubBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Àràmàw omono Mipa izupe amo her romo a'e. (— Purehe ime'egatu haw, i'i zaneze'eg rupi.) — Tuwe Tupàn Tuweharupi Wiko Ma'e ume'egatu zanerehe a'e nehe, muite zanezewizewi zanereko mehe a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Aze erezapo ikatu 'ym ma'e herazyr wanupe nehe, aze erereko amo ae kuzà ne wà nehe, aze nakwaw kwaw a'e ma'e neremiapo kwer nehe, Tupàn ume'egatu putar zanerehe a'e nehe. Nema'enukwaw katu zanerehe ime'egatu àwàm rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ai'àg itapuku imupu'àm pyrer a'e, ai'àg ita ywytyra'i romo iapo pyrer a'e no. Upyta putar xe zanemyter pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ita ywytyra'i iapo pyrer a'e, ita puku imupu'àm pyrer a'e no, zanemuma'enukwaw kar putar ko zaneremimume'u kwer rehe a'e wà nehe. Naha pixik kwaw 'àg ita imupu'àm pyrer pemutyr ihe nehe, neàmàtyry'ym pà ihe nehe. Nerezur pixik kwaw 'àg ita ywytyra'i iapo pyrer xe kutyr nehe, 'àg ita imupu'àm pyrer xe kutyr nehe, heàmàtyry'ym pà ne nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Tupàn neru Àmàrààw izar a'e, heru Naor izar a'e, wiko putar zaneremiapo hexakar romo nehe. Aze ikatu nehe, umume'u putar ikatu haw nehe, aze na'ikatu kwaw nehe, umume'u putar ikatu 'ymaw nehe, i'i Àràmàw. Na'e Zako umume'uahy wemiapo ràm Tupàn her rehe a'e kury, u Izak hemimuwete kwer her rehe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Uzuka amo ma'ea'yr Tupàn henataromo a'e pe, a'e ywytyr rehe. Wenoz wànàm wamuwà mai'u haw pe wà. A'e 'ar mehe pyhaw umai'u a'e ywytyr rehe wà. Uker a'e pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Iku'egwer pe Àràmàw upu'àm izi'itahy. Uzurupyter wazyr wà. Uzurupyter wemimino wà no. Omono uze'egatu wanehe no. A'e re uzewyr oho a'e wi uiwy kutyr. ");
INSERT INTO gubBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wata Zako oho iko kury. Amo Tupàn heko haw pe har uwàxi oho wà. ");
INSERT INTO gubBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wanexak mehe Zako uze'eg wanupe. — Kwa, zauxiapekwer Tupàn hemiruze'eg wà, i'i wanupe. A'e rupi omono Mànài a'e ywy rehe her romo a'e. — Zauxiapekwer tetea'u, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Omono Zako awa uze'eg heraha har ywy Xeir her ma'e pe wà. Enom amo ae a'e ywy her romo a'e no. — Pekar heryky'yr Ezau peho nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Umume'u kar uze'eg heraha Ezau pe. — Ihe Zako ihe. Aiko xe newe uma'ereko ma'e ài ihe. Amumaw kwarahy tetea'u Àràmàw ipyr hereko pà ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Heta tetea'u ma'ea'yr ihewe wà: tapi'ak, zumen, àràpuhàràn hawitu ma'e, àràpuhàrànete. Heta uma'ereko ma'e ihewe wà no: awa wà, kuzà wà no. Amono kar ko heze'eg newe ihe, ta'e aputar nepyr hemuixe katu kar àwàm ihe xe, peze Ezau pe nehe, i'i wemiruze'eg wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Weraha a'e awa ize'eg Ezau pe wà. Uzewyr Zako pe wà kury. — Uruiko neryky'yr Ezau ipyr ure. Ur iko xe kutyr neruwàxi pà a'e kury. Werur 400 awa wà, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Wanenu mehe Zako ukyze katu. Na'ipy'apy'a katu kwaw no. — Ma'e uzeapo putar ihewe nehe, i'i uzeupe. A'e rupi umuza'aza'ak wemiaihu mokoz imono'og pyr romo wà. Umuza'aza'ak weimaw wà no: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà, kamer wà. ");
INSERT INTO gubBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nezewe uze'eg uzeupe. — Aze Ezau uzàmàtyry'ym amo imono'og pyrer wà wà nehe, imono'og pyrer inugwer upuner uzànaw rehe izuwi wà nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Na'e uze'eg Zako Tupàn pe kury. — Einu katu heze'eg nehe, Tupàn Tuweharupi Wiko Ma'e. Heràmuz izar romo ereiko ne. Heru izar romo ereiko ne. Hemono kar pe heànàm wapyr ne, heywy rehe ne. — Nuzeapo kwaw ikatu 'ym ma'e newe nehe, ere ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ihe neremiruze'eg ihe, naiko kwaw ikatu ma'e romo. Nezewe rehe we erezapo kar xo ikatuahy ma'e zo ihewe. Izypy mehe yrykaw Zotàw her ma'e hahaw mehe xo ywyra àràpuhàràn mono'ogar pokokaw zo heta ihewe. Ko 'ar rehe azewyr tuwà iteko teko tetea'u waneraha pà ihe kury, ma'ea'yr tetea'u waneraha pà ihe no. Heta tetea'u wà, a'e rupi amuza'aza'ak mokoz imono'og pyrer romo ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Tupàn Tuweharupi Wiko Ma'e ne, hepyro pe heryky'yr Ezau wi ne nehe. Akyze izuwi. Aze ru'u ur putar hezuka pà nehe, aze ru'u uzuka putar heremireko wà nehe, hera'yr herazyr wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Izypy mehe eremume'uahy neremiapo ràm ihewe ne. — Xo ikatuahy ma'e zo uzeapo putar newe nehe, ere ihewe. — Nezuapyapyr waneta àwàm nuzawy kwaw ywyxig yryhu huwake har waneta haw wà nehe. Teko nupuner kwaw wapapar haw rehe wà nehe, ere ihewe kwehe mehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","A'e 'ar mehe pyhaw Zako uker a'e pe. Iku'egwer pe wexaexak amo weimaw Ezau pe imono e pyràm romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Omono'og 200 àràpuhàrànete kuzà wà, 20 àràpuhàrànete awa wanehe we wà. Omono'og 200 àràpuhàràn hawitu ma'e kuzà wà, 20 àràpuhàràn hawitu ma'e awa wanehe we wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Omono'og 30 kamer wà, wamemyr ukamu ma'e wanehe we wà no. Omono'og 40 tapi'ak kuzà wà, 10 tapi'ak awa wanehe we wà no. Omono'og 20 zumen kuzà wà, 10 zumen awa wanehe we wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Umuza'aza'ak a'e ma'ea'yr wà kury. Amo imono'og pyrer upyta xe, amo upyta pe pe, amo upyta 'a pe. Umuata kar uma'ereko ma'e wanupi wà, wanehe uzekaiw ma'e romo pitàitàigatu wà. — Peho urerenataromo nehe. Amo imono'og pyrer oho. A'e re amogwer upytu'u wà. A'e re amo oho no. Nezewe pitàitàigatu uzemuza'aza'ak putar amogwer wanuwi wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Uze'eg Zako uma'ereko ma'e ipy pe. — Heryky'yr Ezau neruwàxi mehe upuranu putar nerehe nehe. — Mo wiko nezar romo a'e, i'i putar newe nehe. — Ma'e pe ereho putar nehe, i'i putar newe nehe. — Mo wiko ko ma'ea'yr wazar romo, i'i putar newe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A'e mehe eze'eg izupe nezewe nehe. — Ko ma'ea'yr wiko neremiruze'eg Zako waneimaw romo a'e wà, ere izupe nehe. — Umur kar e iko uzar Ezau pe a'e wà. A'e ur iko xe kutyr a'e no, ere izupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Uze'eg nezewegatete imono'og pyrer mokoz haw rehe uzekaiw ma'e pe no. Uze'eg nezewegatete imono'og pyrer na'iruz haw rehe uzekaiw ma'e pe no. Uze'eg nezewegatete amogwer uzekaiw ma'e wanupe no. — Ezau huwàxi mehe peze'eg nezewegatete izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Peneharaz zo ko ze'eg penemimume'u ràm wi nehe. — Neremiruze'eg Zako ur iko xe kutyr a'e no, peze izupe nehe, i'i wanupe. Ima'enukwaw Zako upy'a pe nezewe. — Heremimono wapyhyk mehe nuikwahy kwaw ihewe nehe. Herexak mehe ru'u, heharaz putar heremiapo kwer wi ru'u nehe, i'i uzeupe, upy'a pe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nezewe Zako omono kar a'e ma'e paw uzenataromo wà. Uker upytu'u haw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","A'e 'ar mehe pyhaw Zako upu'àm kury. Wahaw yrykaw Zamok her ma'e oho. Weraha a'e mokoz wemireko wà. Weraha a'e mokoz wemirekoagaw wà no. Weraha a'e 11 wa'yr wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ukwaw a'e teko huwake wà. A'e re umugwaw kar weimaw paw uzeake wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A'e ae upyta wanaikweromo. Nupyta kwaw amo hehe we wà. Na'e ur amo awa iku'apyhyk pà kury. Uzypyrog iku'apyhyk pà pyhaw a'e. Xo kwarahy ihem etea'i mehe zo upytu'u uku'apyhyk ire. ");
INSERT INTO gubBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","A'e awa nupuner kwaw Zako heitykaw rehe. A'e rupi ukwar Zako henugupy iàpytàro haw rehe kury. Henugupy uhem iàpytàro haw wi. Hahy tuwe izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na'e a'e awa uze'eg izupe kury. — Epuir ihewi kury ty, kwarahy uhem etea'i ty, i'i izupe. — Napuir kwaw newi ihe rihi ty. Aze eremur neze'egatu herehe nehe, xo a'e mehe zo urumuhem kar putar ihe nehe, i'i Zako izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Upuranu awa hehe. — Ma'e nerer, i'i izupe. — Zako, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","— Amo ae nerer amono putar newe ihe nehe kury. Nereiko kwaw Zako romo ko 'ar henataromo nehe kury. Ereku'apyhyk Tupàn ne. Ereku'apyhyk awa ne wà no, waneityk pà ne wà no. A'e rupi Izaew nerer pyahu romo kury, i'i izupe. (-Uku'apyhyk Tupàn a'e, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","— Emume'u nerer ihewe ty, i'i Zako izupe. — Màràzàwe tuwe nepurukwaw wer herer rehe, i'i izupe. A'e rupi omono uze'egatu Zako rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Na'e Zako uze'eg uzeupe. — Aexak Tupàn huwa kwez ihe. Aikuwe ihe rihi. Namàno kwaw ihe, i'i uzeupe. A'e rupi omono Peniew a'e ywy rehe her romo a'e. (-Tupàn huwa, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Peniew ywy wi iho mehe kwarahy uhem. Iku'em kury. Iàte'ete'e oho iko, ta'e a'e awa ukwar henugupy rehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Te ko 'ar rehe Izaew izuapyapyr a'e wà, nu'u kwaw ma'ea'yr ho'o kwer henugupy huwake har a'e wà. Ta'e a'e awa ukwar Zako rehe a'e pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Zako wexak Ezau 400 awa wanupi tur haw a'e kury. Umuza'aza'ak kar wa'yr na'iruz imono'og pyrer romo wà. Imono'og pyrer ipy upyta hemireko Erez huwake. Imono'og pyrer mokoz haw upyta hemireko Hakew huwake. Imono'og pyrer na'iruz haw upyta a'e mokoz hemirekoagaw wanuwake. ");
INSERT INTO gubBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hemirekoagaw weraha umemyr amogwer wanenataromo wà. Erez wata umemyr wanupi wanaikweromo. Hakew wata umemyr Zuze rupi wanaikweromo. ");
INSERT INTO gubBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Zako ukwaw wanuwake. Wata wanenataromo kury. 7 haw wapyk upenàràg rehe, uwa imuhyk pà ywy rehe. Te uhem Ezau huwake kury. ");
INSERT INTO gubBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezau uzàn oho Zako huwàxi pà kury. Uzàzuwàn oho. Upyhyk uzywa pupe iazu'yw rehe. Uzurupyter. Uzai'o wà. ");
INSERT INTO gubBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kuzà wanexak mehe kwarearer wanexak mehe upuranu Zako rehe. — Ko teko nerupi wata ma'e a'e wà, mo romo wanekon a'e wà, i'i izupe. — Tupàn ikatuahy ihewe a'e, a'e rupi umur ko hera'yr ihewe neremiruze'eg pe a'e wà, i'i Zako izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Na'e a'e kuzà hemirekoagaw a'e wà, wamemyr a'e wà no, uhem Ezau huwake a'e wà kury. Uzemumew henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","A'e re ur Erez umemyr wanupi. Uzemumew henataromo a'e wà no. Iahykaw rehe ur Hakew umemyr Zuze rupi. Uzemumew henataromo wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Na'e upuranu Ezau hehe kury. — Àwàxi amo teko kwez pe rupi heata mehe ihe wà. Mo romo wiko a'e wà, i'i izupe. — Amuata kar kwez herenataromo ihe wà, ta'e azemukatu kar newe nezewe ihe xe, i'i izupe. — Aze amono ma'e tetea'u izupe nehe, a'e mehe ru'u nahezuka kwaw a'e nehe, a'e kwez hezeupe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Uze'eg Ezau Zako pe kury. — Heta tetea'u ma'e ihewe, herywyr. Naputar kwaw nema'e ihe. Epyhyk wi nezeupe nehe, i'i Ezau izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","— Heporomono wer a'e ma'e paw rehe newe. Epyhyk nehe. Aze ru'u hekatu newe. Aexak neruwa kwez kury. Neruwa hexakaw nuzawy kwaw Tupàn huwa hexakaw ihewe. Ta'e hemuawyze pe katu haw rupi kwez ne xe, i'i Zako izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","— Arur ma'ea'yr newe wà, arur ma'e newe no. Epyhyk ne wà nehe ty. Tupàn uzapo ikatu ma'e tetea'u ihewe tuweharupi a'e. Aze nuhyk kwaw ma'e ihewe, Tupàn umur a'e ma'e ihewe. Epyhyk tuwe ne wà nehe, i'i wyky'yr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","— Ikatu ty. Zaha ty. Ata putar aha nerenataromo ihe nehe kury, i'i uwywyr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Uze'eg wi Zako izupe. — Hezar, kwarearer kuzàtàigwer na'ikàg kwaw a'e wà. Heta àràpuhàràn imemyr ma'e a'e wà no. Heta tapi'ak imemyr ma'e a'e wà no. Aze ximuatahy kar zane wà nehe, aze ximumaw te pitài 'ar wamuatahy kar pà zane nehe, umàno putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Neremiruze'eg romo aiko. Hezar romo ereiko. Ikatu wera'u putar herenataromo neata àwàm nehe. Ata putar aha mewe katu neraikwerupi ihe nehe. Ma'ea'yr a'e wà, kwarearer kuzàtàigwer a'e wà no, mewe katu wata a'e wà. Ata putar wazàwe ihe nehe. Amo 'ar mehe uruhem putar oroho nereko haw Enom her ma'e pe ure nehe. Urupytu'u putar a'e pe nehe, i'i wyky'yr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","— Tuwe amo ihewe uma'ereko ma'e upyta nerehe we a'e wà nehe, nerupi wata pà a'e wà nehe, i'i uwywyr pe. — Màràzàwe tuwe eremuata kar amo herupi wà nehe. Naputar kwaw ihe wà. Aze hekatu newe nehe, herurywete nehe. Xo heamutar haw aputar ihe, i'i wyky'yr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","A'e 'ar mehe uzewyr Ezau oho waikwerupi Enom ywy kutyr kury. ");
INSERT INTO gubBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Zako oho Xukot ywy rehe. Uzapo wàpuz a'e pe. Uzapo àmàn wi wamonokatu haw weimaw wanupe no. A'e rupi, — Xukot, i'i a'e ywy rehe wà. (— Àmàn wi zanemimaw, i'i zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Uzewyr Zako oho Mezopotàm ywy wi Kànàà ywy rehe. Numàno kwaw wata mehe. Na'ima'eahy kwaw a'e pe uhem mehe. Ikàg a'e. Uhem Xikez tawhu pe. Uzapo weko haw a'e tawhu huwake kury. ");
INSERT INTO gubBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hamor a'e, Xikez tu a'e, heta amo ta'yr izupe a'e wà. A'e ywy izar romo wanekon wà. Zako ume'eg kar amo ywy pehegwer wanuwi 100 temetarer tàtà parat iapo pyrer pupe. Uzapo weko haw a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Uzapo amo ma'ea'yr hapy haw Tupàn henataromo a'e pe. — Ewà, i'i izupe. (— Izaew izar, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Heta amo Zako tazyr Zina her ma'e izupe a'e. Erez wiko ihy romo. Amo 'ar mehe uzepyriko oho amo kuzàwaza a'e ywy rehe har waneko haw pe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamor Ewe izuapyr a'e ywy rehe har wanuwihaw romo hekon a'e. Xikez ta'yr her romo a'e. Xikez wexak Zina tur mehe. Upyhyk kury. Umuger kar uzepuhe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ipuràg eteahy Zina izupe. Uzamutar katu. Ipuruamutar kar wer uzehe Zina pe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A'e rupi uze'eg oho tu pe kury. — Emur kuzàwaza nerazyr ihewe heremireko ràm romo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A'e 'ym mehe, — Xikez uzapo iaiw ma'e nerazyr Zina pe a'e, i'i amo Zako pe wà. A'e rupi ukwaw hemiapo kwer. Zako ta'yr wiko ka'api'i rupaw pe tapi'ak wanehe uzekaiw pà wà. A'e rupi Zako nuze'eg kwaw Xikez pe. — Tuwe hera'yr uzewyr ka'api'i rupaw wi wà rihi. A'e mehe amume'u putar ma'e uzeapo ma'e kwer paw wanupe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","A'e 'ar mehe we Hamor Xikez tu uze'eg oho Zako pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Uhem Zako ta'yr wà ka'api'i rupaw wi wà. Wenu uzeapo ma'e kwer imume'u haw wà. Wikwahy tuwe wà. — Uzapo Izaew izuapyapyr wamuwete 'ymaw iaiw ma'e kwez a'e, i'i uzeupeupe wà. — Uzapo Zako tazyr imuwete 'ymaw iaiw ma'e kwez a'e, i'i uzeupeupe wà. — Na'ikatu kwaw agwer ma'e iapo haw wà, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor uze'eg wanupe. — Hera'yr Xikez uzamutar katu nerazyr a'e. Tuwe upyhyk wemirekoete romo nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","— Nezewe mehe zazeànàànàm putar zane nehe. Urera'yr wereko putar penazyr wà nehe. Pena'yr wereko putar urerazyr wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Peiko xe ko ywy rehe nehe, urereko haw pe nehe. Peme'eg kar wyzài ywy pehegwer pezeupe penemimutar rupi nehe. Peme'eg ma'e xe nehe, peme'eg kar ma'e xe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","A'e re Xikez uze'eg Zina tu pe kury, ikywyr wanupe no. — Aze pemur Zina heremireko ràm romo nehe, amono putar wyzài ma'e penemimutar peme ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","— Penoz wyzài ma'e ihewe nehe, pemume'u wyzài ma'e nehe, kuzàwaza hekuzaromo nehe. Tuwe hekon heremireko romo nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Zako ta'yr ukwaw iaiw ma'e iapo awer weinyr pe wà. A'e rupi hemu'em Xikez pe wà kury, tu pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Uze'eg mua'u nezewe wanupe wà. — Neremonohok kar pixik kwaw nepirera'i ne. A'e rupi nurupuner kwaw urereinyr imono haw rehe newe neremireko romo. Nezewe mehe a'e nezewe haw uremumaranugar kar a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aze awakwer pepyr har paw omonohok kar upirera'i wà nehe, xo a'e mehe zo erepuner urereinyr ipyhykaw rehe neremireko romo nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","A'e mehe pepuner urerazyr wanereko haw rehe penemireko romo nehe. Ure urereko putar penazyr ureremireko romo ure wà nehe no. Uruiko putar peinuromo ure nehe. Zaiko putar pitài teko romo zane nehe, i'i mua'u wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","— Aze napezapo kwaw ko ureremimume'u kwer nehe, oroho putar xe wi ure nehe, urereinyr heraha pà ure nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","— He'e, uruzapo putar penemimume'u kwer ure nehe, i'i Hamor wanupe wa'yr Xikez rehe we. ");
INSERT INTO gubBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Na'arewahy omonohok kar kwàkwàmo upirera'i, ta'e uputar tuwe Zako tazyr a'e xe. Teko a'e ywy rehe har umuwete katu wera'u Xikez a'e wà, tu iànàm nànàn a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","A'e re Hamor a'e, ta'yr Xikez a'e no, oho tawhu huken huwake wà. Teko uma'eme'eme'eg a'e pe tuweharupi wà. A'e pe uhem mehe uze'eg tawhu pe har wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","— 'Aw teko wiko zanemyrypar romo a'e wà. Tuwe wiko xe zaneinuromo wà nehe. Tuwe uma'eme'eme'eg xe wà nehe no. Ta'e heta tetea'u ywy xe zanewe upaw rupi xe. Zapuner wanazyr wanereko haw rehe zaneremireko romo nehe, upuner zanerazyr wanereko haw rehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Xo pitài ma'e zo uzapo kar zanewe wà. Aze xiapo a'e ma'e nehe, upyta putar xe zaneinuromo wà nehe. Awakwer paw omonohok kar putar upirera'i wà nehe. Xo a'e ma'e zo uzapo kar zanewe. Nezewe zaiko putar wazàwe nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","— Xipyhyk putar waneimaw tapi'ak paw zane wà nehe. Xipyhyk putar wama'e paw zane nehe no. Aze xiapo a'e ma'e wanemimume'u kwer nehe, wiko putar xe zaneinuromo wà nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","A'e rupi awakwer tua'u ma'e paw uze'eg Hamor pe ta'yr Xikez pe wà kury. — He'e, i'i wanupe wà. Omonohok kar upirera'i oho wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Na'iruz 'ar pawire hahy we awakwer wanupe rihi. Mokoz Zako ta'yr Ximeàw her ma'e Erewi her ma'e a'e wà, Zina ikywyr a'e wà, upyhyk utakihepuku a'e wà. Wixe tawhu pe wà, uzexak kar 'ym pà teko wanupe wà. Uzuka awakwer paw wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Uzuka Hamor wà, uzuka ta'yr Xikez wà no. A'e re Ximeàw a'e, Erewi a'e no, weraha Zina Xikez hàpuz wi a'e wà kury. Uhem oho a'e wi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wazuka re amogwer Zako ta'yr imunar ma'e hekuzar katu ma'e tawhu pe har nànàn a'e wà, a'e pe har wanehe uzepyk pà a'e wà. Nezewe umekuzar weinyr imuwete 'ymaw iaiw ma'e a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Weraha waneimaw wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà, zumen wà. Weraha wama'e tawhu pe har paw wà. Weraha wama'e ko pe har paw wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Upyro ma'e hekuzar ma'e paw wanàpuz wi wà. Weraha kuzà paw wà, weraha kwarearer kuzàtàigwer paw wà no. Umuigo kar uma'ereko e ma'e romo uzeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Na'e uze'eg Zako Ximeàw pe Erewi pe kury. — Zawaiw katu putar hereko àwàm ihewe nehe kury, ta'e pezuka a'e teko paw pe wà xe, wama'e paw heraha pà pe wà xe. Kànàà pe har a'e wà nehe, Perize izuapyapyr ywy rehe har a'e wà nehe no, ko ywy rehe har paw a'e wà nehe no, na'iakatuwawahy kwaw herehe a'e wà nehe. Naheta tete kwaw awa zauxiapekwer romo ihewe wà. Aze ko ywy rehe har uzemono'og wà heàmàtyry'ym pà wà nehe, uzuka putar heànàm paw wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Uwazar ize'eg izupe wà. — A'e teko wereko urereinyr kuzàwyzài ài a'e wà. Nazapuner kwaw nezewe haw iapo kar haw rehe wanupe, i'i ta'yr u pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Uze'eg Tupàn Zako pe kury. — Ezemuàgà'ym nehe, eho Metew pe nehe. Eiko a'e pe nehe. A'e pe nehem mehe ezapo amo ma'ea'yr hapy haw herenataromo nehe. Ta'e neryky'yr Ezau wi nezàn mehe azexak kar newe ihe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Na'e uze'eg Zako wànàm wanupe kury, wemiaihu wanupe no. — Pereko tupàn a'ua'u amo ae ywy rehe arer pepo pe pe wà. Peityk upaw rupi pe wà nehe kury. Pezemukatu a'e iaiw paw wi nehe. Pemunehew kamir izipiw 'ym ma'e nehe, topoz izipiw 'ym ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pezemuàgà'ym nehe, ta'e zaha putar Metew pe zane kury xe. A'e pe zanehem mehe azapo putar amo Tupàn henataromo ma'ea'yr hapy haw ihe nehe. Ta'e a'e ae hepytywà ma'erahy ipuraraw mehe a'e xe. Ta'e tuweharupi heata mehe wiko herehe we a'e xe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","A'e rupi Zako iànàm umur utupàn a'ua'u paw izupe a'e wà kury. Umur unamipor izupe a'e wà no. Uzutym tupàn a'ua'u paw ywyra kawar her ma'e iwy pe kury. Xikez tawhu huwake i'àz a'e ywyra. ");
INSERT INTO gubBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","A'e mehe oho a'e wi wà. Heta amo tawhu a'e ywy rehe. A'e wi wahem ire Tupàn umukyze kar tuwe a'e tawhu nànànar a'e wà kury. A'e rupi noho kwaw Zako haikweromo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nezewe mehe Zako a'e, hupi wata ma'e paw a'e wà no, uhem Iruz tawhu pe a'e wà kury. Metew, her inugwer a'e. Kànàà ywy rehe tuz. ");
INSERT INTO gubBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","A'e pe uzapo Tupàn henataromo ma'ea'yr hapy haw. Omono her izupe. — Tupàn Metew izar, her ipyahu romo a'e kury. Ta'e Tupàn uzexak kar izupe a'e pe a'e 'ym mehe a'e xe, wyky'yr wi uzàn mehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Amo kuzà Nemora her ma'e umàno a'e pe. A'e 'ym mehe Hemek ikuzàtài mehe Nemora uzekaiw Hemek rehe. Heta amo ywyra kawar her ma'e Metew huwake kwarahy ihemaw awyze har kutyr a'e. Uzutym Zako Nemora hetekwer a'e ywyra iwy pe. Omono amo her a'e ywyra pe. — Kawar zanerehaykwer heta haw, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Zako Mezopotàm ywy wi izewyr mehe amo 'ar mehe uzexak kar wi Tupàn wà izupe kury. Omono uze'egatu hehe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Zako nerer ne, Amo ae nerer amono putar newe ihe nehe kury. Kutàri, — Izaew, nerer romo kury, i'i izupe. Nezewe Tupàn omono Izaew her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Umume'u amo ae ma'e izupe no. Aiko Tupàn ikàg wera'u ma'e romo ihe. Heta tetea'u putar nera'yr newe wà nehe. Tuwe heta tetea'u nezuapyapyr newe wà nehe. Amo teko pitài teko romo wamono'og pyràm uhua'u ma'e uhem putar newi wà nehe. Teko tetea'u uhem putar newi wà nehe no. Amo nepurumuzàmuzàg wiko putar tuwihawete romo a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kwehe mehe amono amo ywy Àmàrààw pe ihe. Amono wi a'e ywy Izak pe ihe no. Amono wi putar a'e ywy newe ihe nehe no. Amono wi putar a'e ywy nezuapyapyr wanupe ihe nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Upytu'u Tupàn Zako pe uze'eg ire kury. Oho a'e wi. ");
INSERT INTO gubBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","A'e mehe Zako upyhyk amo itapuku kury. Umupu'àm a'e pe Tupàn ize'eg awer pe. Omonokatu a'e ita Tupàn pe. Uzakook win hehe, uzakook uri kawer hehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","— Metew, i'i izupe. (—Tupàn hàpuz, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Zako a'e, iànàm a'e wà no, uhem oho Metew wi a'e wà kury. Eparat tawhu huwake wahem mehe Hakew imemyrahy a'e kury. Zawaiw katu imemyr izexak kar awer. Hahy tuwe izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hahy wera'u mehe kuzà ipytywà har uze'eg izupe. — Ekyze zo nehe kyn. Nememyr wi putar kury. Awa a'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Zawaiw katu ihy pe. Umàno putar. Imàno etea'i mehe ipytuhemaw iahykaw rehe har rehe omono her umemyr pe. — Menoni, i'i izupe. Tu omono amo her izupe. — Mezàmi, i'i tu izupe. — Hera'yr ikàg ma'e ràm, i'i her tu hemimono kwer zaneze'eg rupi. — Hezemumikahy haw imemyr, i'i her ihy hemimono kwer zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nezewe umàno Hakew kury. Uzutym hetekwer pe Eparat kutyr har her ma'e izywyr wà. Ko 'ar rehe, — Merez, i'i teko a'e tawhu pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zako umupu'àm amo itapuku wemireko kwer itym awer i'aromo. A'e ita wexak kar itym awer purupe te ko 'ar rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","A'e re uhem Zako a'e wi. Uzapo weko haw oho tàpuzaiha Ener her ma'e ikupe kutyr. ");
INSERT INTO gubBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Amo 'ar mehe a'e pe heko mehe Zako ta'yr Humen her ma'e a'e kury, uker oho Zako hemirekoagaw Mira her ma'e puhe a'e kury. A'e ma'e ikwaw mehe wikwahy tuwe Zako. Heta 12 ta'yr Zako pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Heta amo ta'yr Zako pe Erez rehe we a'e wà. Na'aw waner xe wà: Humen (ta'yr ipy), Ximeàw, Erewi, Zuta, Ixakar, Zemurom. ");
INSERT INTO gubBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Heta amo ta'yr izupe Hakew rehe we a'e wà. Na'aw waner xe wà: Zuze, Mezàmi. ");
INSERT INTO gubBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Heta amo ta'yr izupe Mira Hakew pe uma'ereko ma'e rehe we a'e wà. Na'aw waner xe wà: Nà, Napitari. ");
INSERT INTO gubBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Heta amo ta'yr izupe Ziwpa Erez pe uma'ereko ma'e rehe we a'e wà. Na'aw waner xe wà: Kaz, Azer. Zako ta'yr paw uzexak kar Mezopotàm ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Oho Zako u pe Manire tawhu pe kury. Uzapo weko haw a'e pe. Arama tawhu her inugwer a'e. Namuite kwaw Emerom tawhu wi. A'e 'ym mehe Àmàrààw wiko Emerom tawhu pe wa'yr Izak rehe we. ");
INSERT INTO gubBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","180 kwarahy hereko mehe ");
INSERT INTO gubBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","tua'uhez mehe umàno Izak, uwipy umàno ma'e kwer wapyr oho pà umàno ma'e kwer wapyta haw pe. Ta'yr Ezau a'e, ta'yr Zako a'e no, uzutym hetekwer a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Amume'u putar Ezau izuapyapyr waner xe ihe wà nehe kury. (Enom Ezau her inugwer a'e.) ");
INSERT INTO gubBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezau wereko mokoz kuzà Kànàà ywy rehe har a'e wà. Ana wiko hemireko ipy romo a'e. Erom Etew ywy rehe har tazyr romo hekon a'e. Wereko Oorimam inugwer wemireko romo. Ana imemyr romo, Zimeàw Ewe ywy rehe har hemimino romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ezau wereko amo ae kuzà Mazemat her ma'e wemireko romo no. Izimaew tazyr romo Nemaiot heinyr romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Heta pitài imemyr Ana pe. Awa a'e. Eripaz her romo a'e. Heta pitài imemyr awa Mazemat pe. Hewew imemyr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Heta na'iruz imemyr awa Oorimam pe wà. Zeuz, Zàrà, Kora, waner romo wà. A'e ta'yr uzexak kar Ezau Kànàà ywy rehe heko mehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","A'e re Ezau oho amo ywy rehe wànàm waneraha pà: wemireko wà, wa'yr wà, wazyr wà. Weraha wàpuz me har paw uzeupi wà. Nezewe uzemuza'ak uwywyr Zako wi. Weraha weimaw paw uzeupi wà no: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà, uma'e Kànàà ywy rehe hemipyhyk kwer paw wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Uhem Ezau oho a'e wi, ta'e heta tetea'u heimaw izupe a'e xe, ta'e Zako heimaw heta tetea'u a'e wà no xe. Ywy pixika'i wera'i wanupe. Heta tetea'u tapi'ak wanupe wà, a'e rupi nupuner kwaw uzeakea'i weko haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","A'e rupi oho Ezau ywy ywytyr hereko har Enom her ma'e pe, weko haw iapo pà a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Na'aw Ezau izuapyapyr waner xe wà: (Enom ywy rehe har wanàmuz romo ywytyr huwake wiko ma'e wanàmuz romo hekon a'e.) Xeir (Enom ywy her inugwer romo a'e.) ");
INSERT INTO gubBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Heta pitài imemyr awa Ana Ezau hemireko pe a'e. Eripaz her romo a'e. Heta 5 ta'yr Eripaz pe wà. Na'aw waner xe wà: Temà, Omar, Zepo, Kàetà, Kenaz. Heta pitài ta'yr Eripaz pe hemirekoagaw Ximina her ma'e rehe we a'e. Amarek her romo a'e. Mazemat Ezau hemireko inugwer a'e, omono umemyr awa Hewew her ma'e Ezau pe a'e. Heta 4 ta'yr Hewew pe wà. Na'aw waner xe wà: Naat, Zera, Xama, Miza. ");
INSERT INTO gubBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ezau wereko amo kuzà Oorimam her ma'e wemireko romo. Ana imemyr romo Zimeàw hemimino romo hekon a'e. Heta na'iruz ta'yr izupe wemireko Oorimam rehe we a'e wà. Zeuz, Zàrà, Kora waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Na'aw teko Ezau izuapyapyr waner xe wà: Ta'yr ipy Eripaz wiko 7 teko wanu romo, 7 wa'yr wanupe. Na'aw ta'yr waner xe wà: Temà, Omar, Zepo, Kenaz, ");
INSERT INTO gubBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Kàetà, Amarek. Pitàitàigatu wiko teko tetea'u wanu romo wà. Ana Ezau hemireko izuapyapyr romo wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Na'aw teko Hewew izuapyapyr waner xe wà: Naat, Zera, Xama, Miza. A'e awa wiko Mazemat amo Ezau hemireko izuapyapyr romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ezau wiko amo teko wanu romo wemireko Ana imemyr Oorimam her ma'e rehe we a'e wà. Na'aw waner xe wà: Zeuz, Zàrà, Kora. ");
INSERT INTO gubBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","A'e teko paw Ezau izuapyapyr romo wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Teko Enom ywy rehe har ipy a'e wà, wiko 'aw awa izuapyapyr romo a'e wà: Irotà, Xomaw, Zimeàw, Ana, Nizom, Ezer, Zizà. A'e paw wiko Xeir Ore ywy rehe har ta'yr romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Irotà wiko mokoz teko wanu romo. Na'aw waner wà: Ori, Omà. Heta amo heinyr Irotà pe no. Ximina heinyr her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Xomaw wiko 5 teko wanu romo. Na'aw waner wà: Aruwà, Manat, Emaw, Xepo, Onà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Heta mokoz ta'yr Zimeàw pe wà. Aiaz, Ana waner romo wà. A'e Ana a'e, amo 'ar mehe wata oho ywyxiguhu rehe u heimaw zumen wamono'ono'og pà. A'e pe wata mehe wexak 'yzygwar ywyxiguhu mytepe. Haku 'y 'yzygwar pupe har. ");
INSERT INTO gubBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana a'e, Nizom tu romo hekon a'e. Heta 4 ta'yr Nizom pe wà. Ta'yr wiko teko tetea'u wanu romo wà. Na'aw waner xe wà: Enà, Ezimà, Ixirà, Kerà. Heta pitài tazyr Oorimam her ma'e Ana pe no. ");
INSERT INTO gubBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer wiko na'iruz teko wanu romo: Mirà, Zààwà, Àkà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Zizà wiko mokoz teko wanu romo. Na'aw waner xe wà: Uz, Àrà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Na'aw teko Ore izuapyapyr Enom ywy rehe har waner xe a'e wà: Irotà, Xomaw, Zimeàw, Ana, Nizom, Ezer, Zizà. ");
INSERT INTO gubBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Heta tuwihawete Enom ywy rehe har wanupe wà. Amo wiko wanuwihawete romo. A'e re umàno. A'e re amo wiko wanuwihawete romo. Nezewegatete pitàitàigatu wiko tuwihawete romo a'e pe wà. Na'aw a'e tuwihawete waner xe wà: Mera, Meor ta'yr, Zinaw tawhu pe har wanuwihawete. Zoaw, Zera ta'yr, Mozira tawhu pe har wanuwihawete. Uzà, Temà ywy rehe har wanuwihawete. Hanaz, Menaz ta'yr, Awite tawhu pe har wanuwihawete. Anaz uzàmàtyry'ym Minià ywy rehe har oho Moaw ywy rehe a'e wà. (Weityk wà.) Xamira, Mazerek tawhu pe har wanuwihawete. Xau, Heomot Ewparat yrykaw izywyr har tawhu pe har wanuwihawete. Ma'aw-Hànà, Akamor ta'yr. Anaz, Pau tawhu pe har wanuwihawete. (Hemireko Meetamew her romo a'e. Meetamew wiko Materez imemyr romo. Wiko Me-Zaw hemimino romo no.) ");
INSERT INTO gubBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ezau wiko teko wamono'ogaw tetea'u wanu romo a'e. Na'aw waner xe wà: Ximina, Awiwa, Zetet, Oorimam, Era, Pinom, Kenaz, Temà, Mimzar, Maniew, Iràw. Pitàitàigatu omono uwer uiwy pe weko haw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Zako upyta Kànàà ywy rehe weko haw iapo pà a'e pe u heko awer pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Amume'u putar Zako iànàm waneko awer xe ihe nehe kury. 16 kwarahy hereko mehe Zuze uzekaiw àràpuhàràn hawitu ma'e wanehe àràpuhàrànete wanehe a'e. Tyky'yr Mira imemyr Ziwpa imemyr uma'ereko hehe we a'e wà no. (Mira a'e, Ziwpa a'e no, tu hemirekoagaw romo wanekon a'e wà.) Zuze umume'u wyky'yr wanemiapo kwer ikatu 'ym ma'e oho u pe tuweharupi a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zako tua'uhez tuwe Zuze izexak kar mehe. A'e rupi uzamutar katu wera'u wa'yr Zuze amogwer wanuwi. A'e rupi amo 'ar mehe uzapo kar kamir puku izywapuku ma'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tyky'yr wexak a'e wà, a'e rupi uze'eg nezewe uzeupeupe wà. — Kwa, zaneru uzamutar katu wera'u Zuze zanewi a'e, i'i uzeupeupe wà. A'e rupi na'iakatuwawahy kwaw hehe wà. Numume'u kwaw ni pitài ze'egatu izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Amo 'ar mehe Zuze upuahu uker mehe. A'e re umume'u upuahu awer oho wyky'yr wanupe. A'e rupi wikwahy wera'u tyky'yr izupe wà, ");
INSERT INTO gubBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ta'e uze'eg nezewe wanupe a'e xe. — Peinu katu heze'eg nehe ty wà. Amume'u putar hepuahu awer peme ihe nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Hepuahu pe zaiko ko pe zane, arozràn ipo'o pyrer imono'og pà iàpixipixi pà zane. Na'arewahy hema'e arozràn imono'og pyrer iàpixi pyrer upu'àm a'e kury. Amogwer iàpixi pyrer a'e wà, pema'e a'e wà, uzemumew hema'e henataromo a'e wà, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na'e tyky'yr upuranu hehe wà. — A'e mehe, aipo ereiko putar ureruwihawete romo ne nehe, aipo erezapo kar putar ma'e urewe ne nehe, i'i izupe wà. A'e rupi na'iakatuwawahy kwaw hehe azeharomoete wà, ta'e wiko wanuwihawete romo upuahu pe a'e xe, ta'e umume'u upuahu awer wanupe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A'e re amo 'ar mehe upuahu wi Zuze. Umume'u wi upuahu awer wyky'yr wanupe. Uze'eg nezewe wanupe. — Apuahu wi kwez ihe. Hepuahu pe kwarahy a'e, zahy a'e no, 11 zahytata a'e wà no, uzemumew herenataromo upaw rupi a'e wà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","U pe wyky'yr wanupe umume'u oho. Henu mehe tu uze'egahy izupe. — Ma'in nepuahu awer. Nehy a'e, neryky'yr a'e wà no, ihe ihe no, aipo ure paw uruzemumew putar nerenataromo ure nehe, ureruwa wamuhyk pà ywy rehe nerenataromo ure nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Hewyrowyroahy tyky'yr hehe wà. Tu uzemupy'a iko ipuahu awer rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Amo 'ar mehe tyky'yr weraha u heimaw wamai'u haw ka'api'i heta haw pe a'e wà kury: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà no. Xikez tawhu huwake tuz. ");
INSERT INTO gubBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na'e uze'eg Zako Zuze pe. — Ezur xe ty. Oromono kar putar Xikez pe ihe nehe kury. Neryky'yr uzekaiw waiko hereimaw àràpuhàràn hawitu ma'e wanehe a'e pe wà, àràpuhàrànete wanehe wà no, i'i izupe. — Ikatu. Heho wer tàrityka'i kury, i'i Zuze u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I'i Zako wa'yr pe. — Eho a'e pe nehe. Ekar neryky'yr ne wà nehe. Aze ru'u ikatu paw rupi wà, aze ru'u ikatu hereimaw wà no. A'e re ezewyr xe waneko haw imume'u pà ihewe nehe, i'i izupe. Nezewe ywyàpyznaw Emerom yrykaw izywyr har wi Zako omono kar wa'yr Zuze Xikez tawhu pe kury. Oho Zuze a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","A'e pe uhem mehe wata oho iko amo kaiwer rupi. Amo awa a'e pe har wexak iata mehe a'e. Upuranu hehe. — Ma'e erekar iko ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","— Heryky'yr aekar wanereko ihe wà. Amo me wanekon wà, amo ka'api'i heta haw pe wà, heru heimaw àràpuhàràn hawitu wanehe uzekaiw pà wà, àràpuhàrànete wanehe uzekaiw pà wà. Aipo erekwaw waneko haw, aipo erekwaw waho awer, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Uze'eg a'e awa Zuze pe kury. — Oho xe wi a'e wà. — Zaha Notà tawhu pe nehe, i'i uzeupeupe amo 'ar mehe a'e wà, i'i Zuze pe. Na'e oho Zuze wyky'yr wanekar pà. Wexak Notà pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Muite iata mehe we tyky'yr wexak Zuze a'e wà. Ihem 'ym mehe we uze'eg uzeupeupe wà, Zuze pe wemiapo ràm imume'ume'u pà wà. — Xiuka nehe ty wà, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","— Aikwez upuahu ma'e ur iko a'e, i'i zemueteahy hehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","— Zaha ty wà, xiuka tàrityka'i nehe ty wà, i'i uzeupeupe wà. Izuka re xityk hetekwer amo ywykwar pupe nehe. — Amo miar hehaite ma'e u'u kwez a'e, za'e putar amogwer wanupe nehe. Nezewe mehe xixak putar ipuahu awer ikatu haw nehe, i'i uzeupeupe wà, hehe uze'eg zemueteahy pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Waze'eg henu mehe Humen ipurupyro wer Zuze rehe tyky'yr wanuwi a'e kury. — Naxiuka kwaw nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","— Naxiakook kwaw huwy kwer izuwi nehe. Peityk ywykwar pupe nehe, xe ywyxiguhu pe har pupe nehe. Pezuka zo nehe, pemugaz zo nehe, i'i wanupe. Uze'eg Humen nezewe a'e, ta'e ipurupyro wer hehe tyky'yr wanuwi a'e xe, ta'e iporomono wi wer hehe u pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Uhem Zuze wyky'yr wanuwake a'e kury. Upyhyk ikamir puku izywapuku ma'e izuwi henuhem pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","A'e re upyhyk Zuze wà, heityk pà ywykwar pupe, 'yzygwar 'y heta 'ym ma'e pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","A'e re wapyk tyky'yr umai'u pà wà. A'e 'ar mehe we wexak amo teko wata ma'e a'e pe wakwaw mehe wà. Izimaew izuapyapyr romo wanekon wà. Zireaz ywy wi wanur wà, Ezit ywy rehe oho pà wà. Weraha kàpuhàg tetea'u oho weimaw kamer wakupe pe wà. Weraha amo ma'e taz zàwenugar tetea'u uzeupi wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Na'e Zuta uze'eg wyky'yr wanupe uwywyr wanupe. — Aze xiuka zanerywyr zane nehe, aze a'e re xiumim izuka awer teko wanuwi nehe, naxipyhyk kwaw temetarer nezewe zane nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","A'e rupi naxiuka kwaw nehe. Xime'eg ko Izimaew izuapyapyr wanupe nehe. Zanerywyr a'e. Zaneruwy romo hekon a'e. A'e rupi na'ikatu kwaw izuka haw, i'i wanupe. — Ikatu, i'i tyky'yr izupe wà, i'i tywyr izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Amo ma'eme'egar Minià ywy rehe har wata oho waiko a'e ywy rehe a'e wà. Ukwaw a'e ma'eme'egar waiko Zuze tyky'yr waneko haw huwake wà kury. Tyky'yr wenuhem Zuze ywykwar wi wà, a'e Izimaew izuapyapyr wanupe ime'eg pà wà. Upyhyk 230 kàràm ita parat hekuzaromo wà. A'e Izimaew izuapyapyr weraha Zuze Ezit ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Na'e Humen uzewyr a'e pe kury. Ume'e oho ywykwar rehe. Wexak Zuze a'e pe heko 'ymaw kury. Uzemumikahy tuwe kury, a'e rupi umu'i ukamir kury. ");
INSERT INTO gubBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Uzewyr oho wyky'yr waneko haw pe. Uze'eg wanupe. — Kwàkwàmo nuiko kwaw ywykwar pupe a'e, ma'e azapo putar ihe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Na'e tyky'yr uzuka àràpuhàràna'yr wà. Omono huwykwer Zuze kamirpuku rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","A'e re weraha ikamirpuku u pe wà. Uze'eg izupe wà. — Uruexak ko kamirpuku kaiwer pe ure. Aze ru'u nera'yr ikamirpuku a'e, i'i mua'u izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zako ukwaw hexak mehe. Uze'eg wanupe. — Azeharomoete. Hera'yr ikamirpuku a'e. Azeharomoete amo miar hehaite ma'e upei'ài'àg i'u pà a'e, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","A'e rupi umu'i Zako ukamirpuku kury, uzemumikahy haw hexak kar pà kury. Umunehew amo ma'eryru pàn iànàm ma'e iapo pyrer ukamir romo. Umumaw 'ar tetea'u wa'yr rehe uzai'o pà uzemumikahy pà. ");
INSERT INTO gubBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ta'yr paw a'e wà, tazyr paw a'e wà no, uzeagaw imurywete kar pà a'e wà. Nuzemurywete kar kwaw wanupe. Uze'eg wanupe. — Napytu'u kwaw hera'yr rehe hezai'o re nehe, hereko mehe ihe. Xo umàno ma'e kwer wapyta haw pe heho mehe, hera'yr huwàxi mehe apytu'u putar hezai'o re nehe, i'i wanupe. Uzai'o wiwi wa'yr rehe tuweharupi. ");
INSERT INTO gubBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A'e 'ar mehe we a'e Minià ywy rehe har ume'eg Zuze oho amo awa Poxiwar her ma'e pe wà kury. Tuwihaw romo hekon a'e. Zauxiapekwer Ezit ywy rehe har wanuwihawete rehe uzekaiw katu ma'e wanuwihawete romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Amo 'ar mehe a'e kwarahy mehe Zuta wata oho wyky'yr uwywyr wanuwi a'e kury. Wiko oho amo awa Ira her ma'e Ànurà tawhu pe har hàpuz me. ");
INSERT INTO gubBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","A'e pe wiko mehe Zuta ukwaw amo Kànàà ywy rehe har Xuwa her ma'e tazyr a'e. Wereko wemireko romo. ");
INSERT INTO gubBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Omono amo ta'yr izupe. Omono Er her romo. ");
INSERT INTO gubBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ipuru'a wi. Uzexak kar amo imemyr awa izupe. Omono Onà her romo. ");
INSERT INTO gubBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A'e re imemyr wi no. Awa a'e. Omono Xera her romo. Zuta a'e, Keziwe tawhu pe hekon Xera izexak kar mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Itua'u mehe Zuta omono amo kuzà Tamar her ma'e wa'yr ipy pe hemireko romo. ");
INSERT INTO gubBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er uzapo iaiw ma'e oho iko a'e. Hemiapo kwer na'ikatu kwaw Tupàn Tuweharupi Wiko Ma'e pe. A'e rupi Tupàn uzuka kury. ");
INSERT INTO gubBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na'e Zuta uze'eg Onà pe. — Eker eho neryky'yr hemireko kwer ipuhe nehe. Nezewe eremono putar izuapyapyr neryky'yr umàno ma'e kwer pe ne wà nehe. (Nezewe waneko haw a'e 'ar rehe wà.) ");
INSERT INTO gubBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Uzemupy'a Onà iko. — Aze ipuru'a hemireko herehe we nehe, imemyr nuiko kwaw hera'yr romo nehe. — Neryky'yr ta'yr a'e, i'i putar ihewe wà nehe, i'i uzeupe. A'e rupi wyky'yr hemireko kwer puhe oho mehe uzakook uma'e kwer ywy rehe. Ta'e na'iporomono wer kwaw ta'yr rehe wyky'yr pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nezewe iapo haw na'ikatu kwaw Tupàn pe. A'e rupi uzuka Onàn a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","A'e rupi Zuta uze'eg wa'ytaty Tamar her ma'e pe kury. — Ezewyr eho neru heko haw pe kury. Eiko wiwi imen umàno ma'e kwer romo nehe. Hera'yr Xera tua'u mehe eiko hemireko romo nehe, i'i izupe. Uze'eg nezewe ta'e ukyze Tupàn wi a'e xe. — Aze ru'u Tupàn uzuka putar hera'yr Xera a'e nehe no, amogwer hera'yr wazàwe a'e nehe no, i'i uzeupe. A'e rupi oho Tamar u hàpuz me wiko pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Umumaw amo kwarahy wà. Amo 'ar mehe Zuta hemireko umàno a'e kury. Hehe wazai'o pawire oho Zuta Ximinat tawhu pe. A'e pe har omonohok àràpuhàràn wanawer waiko imono'og pà wà. Zuta imyrypar Ira Ànurà pe har oho hupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Amo uze'eg Tamar pe amo 'ar mehe. — Neru tywyr oho putar Ximinat pe weimaw àràpuhàràn hawer imonohok pà a'e nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A'e rupi Tamar umunehew amo wopoz oho kury, wopoz umen umàno ma'e kwer rehe uzai'o haw rehe har hezar pà imonokatu pà kury. Upyk uwa amo pàn pupe. Nezewe teko nukwaw kwaw a'e wà. A'e re wapyk oho Enaim tawhu pe heixe haw huwake kury. Ximinat piar rupi tuz. — Xera wiko awa tua'u ma'e romo a'e kury. — Ereko Tamar neremireko romo nehe, ni'i kwaw Zuta izupe rihi. Nuzapo kwaw ma'e uze'eg awer rupi a'e, i'i in uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Na'e Zuta wexak Tamar a'e pe tawhu pe heixe haw huwake iapyk mehe a'e kury. — Kuzàwyzài, i'i uzeupe, ta'e umim uwa teko wanuwi a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Uze'eg oho izupe pe iwyr heko mehe. Nukwaw kwaw uwa'ytaty kwer romo heko haw. — Aipo neho wer heker haw pe hepuhe ne'aw pà, i'i izupe, hehe upuranu pà. Upuranu kuzà Zuta rehe. — Màràn temetarer eremur putar ihewe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","— Heremiruze'eg weraha putar amo àràpuhàrànetea'yr hereimaw wamono'ogaw pe har newe wà nehe, i'i izupe. — Ikatu, i'i kuzà izupe. — Emur amo ma'e ihewe kury, neremimur ràm neremimume'u kwer hekuzaromo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","— Ma'e ereputar, ma'e aezar putar nepo pe hekuzaromo, i'i izupe. — Emur nepu'yr ihewe ihàm rehe we nehe. Ereiko àràpuhàràn mono'ogar romo. Emur neiwyra nepokokaw ihewe nehe no, i'i izupe. A'e rupi Zuta omono a'e ma'e paw izupe. Uker oho ipuhe. Ipuru'a kury. ");
INSERT INTO gubBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Uzewyr Tamar weko haw pe. Umunyryk uwa ipykaw uzewi. Umunehew wi wopoz umen umàno ma'e kwer rehe uzai'o haw no. ");
INSERT INTO gubBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Amo ae 'ar mehe uze'eg Zuta umyrypar Ira pe kury. — Eraha àràpuhàràna'yr a'e kuzàwyzài pe nehe. Erur wi hema'e izupe heremizarer ihewe nehe, i'i izupe. Oho Ira a'e pe. Nuexak kwaw kuzà. ");
INSERT INTO gubBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Upuranu awakwer Enaim tawhu pe har wanehe. — A'e kuzàwyzài xe har pe iwyr har a'e, ma'e pe hekon a'e, i'i wanupe. — Naheta kwaw kuzàwyzài xe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Uzewyr Ira Zuta pe a'e ma'e imume'u pà. — Naexak kwaw kuzà ihe. — Ni amo kuzàwyzài nuiko kwaw xe a'e wà, i'i awakwer a'e pe har, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Na'e i'i Zuta izupe. — A'e mehe, tuwe wereko hema'e nehe. Nezewe mehe teko nupuka kwaw zanerehe wà nehe. Araha kar àràpuhàràna'yr newe ihe. Nerexak kwaw kuzà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Na'iruz zahy pawire amo uze'eg oho Zuta pe wà kury. — Nera'ytaty wiko kuzàwyzài romo a'e. Ipuru'a kury, i'i izupe wà. Uze'egahy Zuta wanupe. — Perur kuzà xe katu pe. Ximunyk tata hehe nehe, hapy pà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wenuhem oho hàpuz wi. Wahem mehe kuzà umume'u amo ma'e wanupe. — Peze'eg peho hemenu pe nehe. — Hemumuru'a arer romo hekon a'e, ko ma'e izar romo hekon a'e. Peme'egatu ko mu'yr rehe nehe, ihàm rehe nehe, ko ywyra pokokaw rehe nehe. Mo wiko izar romo a'e, i'i wanupe, wanehe upuranu pà. Weraha a'e ma'e Zuta pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ukwaw Zuta uma'e hexak mehe. — Azeharomoete ize'eg a'e. Amume'u hera'yr Xera pe hemireko ràm romo ihe. Nazapo kwaw ma'e heze'eg awer rupi. A'e rupi uzepyk kwez herehe nezewe a'e kury, i'i a'e pe har wanupe. Nuker wi kwaw ipuhe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar imemyrahy mehe a'e pe har wexak imemyr mokoz wà. ");
INSERT INTO gubBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Imemyr wazexak kar mehe we amo hie pe har omono opo katu pe. Ipytywà har kuzà a'e, uzàpixi amo pàn pehegwer ipiràg ma'e ipo rehe. — Ko imemyr ràgypy uhem inugwer henataromo a'e. Nememyr ipy a'e, i'i wahy pe. ");
INSERT INTO gubBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tàrityka'i umuzewyr wi opo uhy ipupe no. Imemyr inugwer uzexak kar kury. Ipytywà har kuzà uze'eg izupe. — Azeharomoete erezapo tuwe nerape nezeupe ne, i'i kwarera'i pe. A'e rupi omono Perez her romo izupe. (— Pe iapo haw, i'i her zaneze'eg rupi.) Awa a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A'e re uzexak kar imemyr inugwer pàn pehegwer ipiràg ma'e opo pe hereko har a'e kury. Omono Zera her romo. (-Ipiràg, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Weraha Izimaew izuapyapyr Zuze Ezit ywy rehe wà. Ume'eg amo a'e ywy rehe har pe wà. Poxiwar izar her romo a'e. Poxiwar wiko Zauxiapekwer wanuwihawete ikàg wera'u ma'e wanehe uzekaiw ma'e wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tupàn Tuweharupi Wiko Ma'e wiko Zuze rehe we, hehe uzekaiw pà. Wiko Zuze uzar hàpuz me. Ikatuahy heko haw a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Izar wexak heko haw ikatu haw. — Tupàn Tuweharupi Wiko Ma'e wiko nerehe we a'e, umukatu neremiapo kwer upaw rupi a'e, omono uze'egatu nerehe a'e, i'i izar izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nezewe ikatu Zuze uzar pe. A'e rupi umuigo kar uzekaiw ma'e romo a'e kury. — Heràpuz rehe heràpuz pupe har nànàn erezekaiw putar nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","A'e 'ar henataromo Tupàn Tuweharupi Wiko Ma'e omono uze'egatu a'e Ezit ywy rehe har heko haw rehe a'e no, ta'e Zuze ikatu izupe a'e xe. Hàpuz pupe har nànàn, ma'etymaw pe har a'e pe har nànàn Tupàn omono uze'egatu no. ");
INSERT INTO gubBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Poxiwar omono uma'e paw Zuze ipo pe. Na'ima'enukwaw kwaw uma'e rehe a'e re. Xo wemi'u rehe ima'enukwaw. Ta'e Zuze uzekaiw katu ima'e rehe upaw rupi a'e xe. Zuze a'e, awa ipuràg eteahy ma'e romo hekon a'e. Ikatu teko nànàn. ");
INSERT INTO gubBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Umumaw amo zahy nezewe wà. Amo 'ar mehe izar hemireko uzypyrog Zuze rehe ume'e pà a'e kury. — Ipuràg eteahy aipo ma, i'i uzeupe. Uze'eg izupe. — Zaha ker haw pe 'y, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","— Nan, i'i Zuze izupe. — Hezar a'e, na'ima'enukwaw kwaw ni pitài ma'e wàpuz pupe har rehe a'e, ta'e aiko xe ihe xe. Hemuigo kar uma'e nànàn uzekaiw ma'e romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hezar uzapo kar ma'e 'àg tàpuz me a'e. Azapo kar ma'e 'àg tàpuz me izàwegatete ihe no. Aze aputar ma'e, umur ihewe. Xo ne zo nurupyhyk kwaw. Napuner kwaw nepyhykaw rehe ihe, ta'e hemireko romo ereiko ne xe. Napuner pixik kwaw agwer iaiw ma'e iapo haw rehe ihe. Napuner pixik kwaw ikatu 'ym ma'e iapo haw rehe Tupàn henataromo, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tuweharupi uze'eg wi kuzà izupe. — Zaha ker haw pe 'y, i'i wiwi iko. — Nan, i'i Zuze izupe. Aze kuzà uhem huwake, utyryk Zuze izuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Amo 'ar mehe wixe tàpuz me uma'ereko haw iapo pà ta'e uzapo nezewe haw tuweharupi a'e xe. Ni amo uma'ereko ma'e nuiko kwaw a'e pe a'e 'ar mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","A'e rupi Poxiwar hemireko upyhyk ikamir rehe. — Zaha 'y, zaha ker haw pe 'y, i'i izupe. Uhem izuwi uzàn pà katu pe. Ikamir upyta ipo pe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","— Wezar ukamir hepo pe uzàn mehe a'e, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","A'e rupi wenoz wàpuz me uma'ereko ma'e uzeupe wà kury. — Pexak 'y wà. Hemen werur ko Emerew xe zaneràpuz me. Màràzàwe tuwe uzapo agwer purumumaranugar kar haw xe a'e. Wixe kwez heker haw pupe, ma'e iapo putar pà hepuhe a'e. Ahapukazahy kwez peme ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Herehapukaz mehe uzàn oho a'e. Wezar ukamirpuku xe, i'i mua'u wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Omonokatu ikamir wàpuz me. ");
INSERT INTO gubBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Umen izewyr mehe umume'u izupe. — Akwez Emerew a'e, newe uma'ereko e ma'e a'e, wixe heker haw pupe ikatu 'ym ma'e iapo pà ihewe a'e, i'i mua'u umen pe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","— Ihe ahapukazahy tuwe ihe. Uzàn oho katu pe a'e. Wezar ukamir puku xe heker haw pupe. ");
INSERT INTO gubBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nezewe newe uma'ereko ma'e herereko a'e, i'i mua'u izupe. A'e ma'e henu mehe Zuze izar wikwahy a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Upyhyk Zuze, zemunehew paw pe imono kar pà. Upyta Zuze a'e pe tuwihawete hemipyhyk kwer wainuromo. ");
INSERT INTO gubBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tupàn Tuweharupi Wiko Ma'e wiko hehe we a'e. Omono uze'egatu hehe. A'e rupi ikatu zemunehew paw rehe uzekaiw ma'e pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","A'e rupi uze'eg nezewe Zuze pe. — Nekatuahy ihewe. A'e rupi amogwer xe har wanuwihawete romo urumuigo kar putar ihe kury, i'i izupe. A'e rupi Zuze uzapo kar ma'e amogwer zemunehew paw pe har wanupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A'e rupi zemunehew paw rehe uzekaiw ma'e na'ima'enukwaw kwaw ma'e rehe kury, ta'e Zuze uzekaiw a'e ma'e rehe hekuzaromo a'e xe. Ta'e Tupàn Tuweharupi Wiko Ma'e wiko hehe we a'e xe, omono uze'egatu hehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Umumaw amo zahy nezewe wà. Amo 'ar mehe mokoz uma'ereko ma'e uze'eg zemueteahy Ezit ywy rehe har wanuwihawete rehe a'e wà. Win rehe uzekaiw ma'e romo hekon amo. Inugwer wiko typy'ak iapo har wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Wikwahy tuwihawete a'e mokoz awa wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Omono kar zemunehew paw pe wà. Zemunehew paw a'e, zauxiapekwer wanuwihaw heko haw pe tuz a'e. Zuze wiko a'e zemunehew paw pe a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Umumaw zahy tetea'u a'e pe wiko pà wà. Tuwihaw umuzekaiw kar Zuze wanehe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Amo 'ar mehe a'e pe zemunehew paw pe pyhaw a'e win rehe uzekaiw ma'e a'e, typy'ak iapo har a'e no, pitàitàigatu upuahu a'e wà kury. — Ma'in zanepuahu awer zanewe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Iku'em mehe Zuze wexak a'e mokoz awa a'e wà. Wexak wazemumikahy haw wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A'e rupi upuranu wanehe. — Màràzàwe tuwe pezemumikahy kutàri, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","— Ure pitàitàigatu urupuahu kwez ure kury. Naheta kwaw urepuahu awer imume'u har urewe, i'i izupe wà. — Tupàn a'e, a'e ae ukwaw kar agwer ma'e teko wanupe a'e. Pemume'u pepuahu awer ihewe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Na'e win rehe uzekaiw ma'e umume'u upuahu awer izupe. — Nezewe hepuahu awer ihe. Heta amo uwà 'yw herenataromo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Heta na'iruz hàkà hehe. Hezuz huwer. Tàrityka'i hezuz iputyr. A'e re i'a kury. Na'e i'a kwer ityàro kury. ");
INSERT INTO gubBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","A'e 'ar mehe we apyhyk tuwihawete ikanek iwin hyru iteko ihe. Azàmi uwà heruwà ikanek pupe tuwihawete pe imono pà ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","I'i Zuze izupe. — Amume'u putar nepuahu awer hemimume'u newe nehe kury. A'e na'iruz hàkà a'e wà, na'iruz 'ar romo wanekon a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Na'iruz 'ar pawire tuwihawete nepyro kar putar xe wi zemunehew paw wi a'e nehe. Erezewyr putar nema'ereko haw pe nehe, win imono pà tuwihawete pe nehe, izypy mehe arer zàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ikatuahy putar nereko àwàm a'e pe nehe. A'e 'ar mehe nehe, nema'enukwaw herehe nehe. Eze'eg tuwihawete pe herehe nehe. Nezewe mehe hepytywà putar pe nehe, xe wi zemunehew paw wi hepyro pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ko heze'eg azeharomo a'e. Hepyhyk Emerew ywy rehe hereko mehe a'e wà, xe Ezit ywy rehe hererur pà a'e wà. Nahezur wer kwaw xe ihe. Xe Ezit ywy rehe hereko mehe nazapo kwaw ikatu 'ym ma'e. Hemur kar e xe zemunehew paw pe wà, i'i Zuze izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Typy'ak iapo har wanuwihaw wenu hemimume'u kwer a'e. — Kwa, ikatuahy ize'eg a'e pa, i'i uzeupe. A'e rupi uze'eg Zuze pe a'e no. — Apuahu kwez ihe no. Hepuahu mehe araha na'iruz kok typy'ak hyru heàkàg rehe ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kok iapyrete har heta typy'ak tetea'u ipupe a'e, iapo har hemiapo kwer tetea'u tuwihawete pàràm a'e. Na'arewahy uhem wiràmiri a'e pe wà, a'e kok ipor i'u pà wà, i'i Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Umume'u Zuze ipuahu awer izupe. — Nezewe nepuahu awer ne. A'e na'iruz kok a'e wà, na'iruz 'ar a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Na'iruz 'ar pawire tuwihawete nemuhem kar putar xe wi a'e nehe. Na'e omonohok kar putar neàkàg newi nehe. A'e re umuzaiko kar putar neretekwer amo ywyra rehe nehe. Wiràmiri u'u putar nero'o kwer a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Na'iruz 'ar pawire tuwihawete uzapo kar mynykawhu uzexak kar awer 'ar rehe a'e kury, wàpuz me uma'ereko ma'e nànàn a'e kury. Werur kar win rehe uzekaiw ma'e wanuwihawete zemunehew paw wi kury. Werur kar typy'ak iapo har wanuwihaw no. — Perur xe mynykaw pe nehe, i'i wemiruze'eg wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","22","Uzeapo ma'e Zuze ize'eg awer rupi katete a'e. Umuzewyr kar win rehe uzekaiw ma'e ima'ereko awer kwehe arer pe. Uzuka kar typy'ak iapo har. ");
INSERT INTO gubBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Win rehe uzekaiw ma'e na'ima'enukwaw kwaw Zuze rehe. Heharaz tuwe izuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Umumaw mokoz kwarahy nezewe wà. Amo 'ar mehe Ezit ywy rehe har wanuwihawete upuahu a'e kury. Upuahu haw pe upu'àm Niru yrykawhu iwyr. ");
INSERT INTO gubBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Na'arewahy uhem 7 tapi'ak wà yrykawhu wi a'e wà kury. Ipuràgete wà. Ikyra katu wà. Uzypyrog ka'api'i yrykaw iwyr har i'u pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na'arewahy uhem amo 7 tapi'ak wà yrykawhu wi wà no. Iroahy iagaiwahy pà wà. Oho amogwer 7 tapi'ak wanuwake wà, yrykawhu iwyr wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tapi'ak iaiw ma'e ikyra 'ym ma'e u'u tapi'ak ipuràg eteahy ma'e ikyra katu ma'e a'e wà. A'e re ume'e tuwihawete kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Na'e uker wi upuahu pà kury. Wexak 7 arozràn haryw pitài romo hezuz ma'e kwer wà. Ikatu wà, tynehem arozràn pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A'e re uhem amo 7 arozràn haryw a'e wà no. Uxinig wà, ta'e ywytu haku ma'e ywyxiguhu wi ur ma'e kwer umuxinig kar a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Omokon a'e 7 arozràn haryw tynehem ma'e ikatu ma'e wà. Ume'e wi tuwihawete. — Apuahu kwez ihe kury, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Iku'em mehe uzemupy'a a'e. A'e rupi wenoz kar ma'e ikwaw pyr 'ym kwaw par paw wamuwà wàpuz me a'e wà kury. Werur kar ma'e kwaw par Ezit ywy rehe har paw a'e wà no. Umume'u upuahu awer wanupe. Ni amo ma'e kwaw par nukwaw kwaw imume'u haw izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na'e win rehe uzekaiw ma'e wanuwihaw uze'eg oho tuwihawete pe a'e kury, (ta'e ima'enukwaw Zuze rehe a'e kury xe). — Ikatu 'ym ma'e azapo ihe, i'i izupe. — Amume'u putar a'e ma'e newe ihe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Amo 'ar mehe erekwahy ihewe ne, typy'ak iapo har wanuwihaw pe ne no. Uremono kar pe zemunehew paw pe ne, zauxiapekwer wanuwihaw hàpuz pupe har pe ne. ");
INSERT INTO gubBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Amo 'ar mehe pyhaw urupuahu pitàitàigatu ure. A'e urepuahu awer ipurumume'u wer amo ma'e rehe urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Zemunehew paw pe uruiko amo kwàkwàmo Emerew rehe we ure. Zauxiapekwer wanuwihaw pe uma'ereko e ma'e romo hekon a'e. Urumume'u urepuahu awer a'e kwàkwàmo pe. A'e ae umume'u hemimume'u urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Uzeapo ma'e ize'eg rupi katete. Azewyr xe hema'ereko haw pe ihe. Typy'ak iapo arer erezuka kar ne, i'i tuwihawete pe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","A'e rupi tuwihawete werur kar Zuze zauxiapekwer wanupe kury. Tàrityka'i oho zemunehew paw wi ipyro pà wà. Upin wamutaw. Umunehew amo kamir katu ma'e. A'e re oho uzexak kar pà tuwihawete pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Na'e tuwihawete uze'eg izupe. — Heta amo hepuahu haw ihe. Ni amo nukwaw kwaw hemimume'u imume'u haw rehe ihewe wà. Amo uze'eg kwez nerehe. — Zuze ukwaw puahu haw imume'u haw a'e, i'i kwez ihewe wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","— Nakwaw kwaw ihe, i'i Zuze izupe. — Tupàn ae umume'u putar nepuahu awer newe nehe. Ikatu putar newe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","— Nezewe hepuahu awer ihe, i'i Zuze pe. — Apu'àm Niru yrykawhu iwyr. ");
INSERT INTO gubBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Na'arewahy 7 tapi'ak ipuràg eteahy ma'e ikyra katu ma'e uhem 'y wi wà. Uzypyrog ka'api'i yrykawhu iwyr har i'u pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","A'e re amo 7 tapi'ak uhem wà 'y wi wà no. Iaiw wà, iagaiwahy wà no. Naexak pixik kwaw tapi'ak iaiw ma'e a'e tapi'ak zàwenugar Ezit ywy rehe ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tapi'ak iaiw ma'e iagaiw ma'e omokon tapi'ak ipuràg ma'e ikyra katu ma'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Wa'u pawire na'ikatu wera'u kwaw tapi'ak iagaiw ma'e wà. Iaiw wiwi izypy mehe arer ài wà. A'e mehe ame'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","A'e re apuahu wi. Aexak 7 arozràn iapo kwer haryw ihe wà. Ikatu wà, tynehem arozràn pupe wà. A'e 7 iapo kwer haryw heta pitài i'yw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A'e re uhem amo 7 arozràn iapo kwer uxinig ma'e wà. Ywytu ywyxiguhu wi ur ma'e kwer umuxinig kar a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","A'e 7 arozràn iapo kwer uxinig ma'e omokon inugwer 7 iapo kwer ikatu ma'e tynehem ma'e wà. Amume'u hepuahu awer ma'e temigwaw 'ym ikwaw par wanupe ihe. Ni amo nukwaw kwaw hemimume'u imume'u haw ihewe wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Na'e uze'eg Zuze tuwihawete pe. — A'e mokoz nepuahu awer a'e wà, zuawygatu wanemimume'u wà. Tupàn uze'eg iko newe nepuahu pe a'e, wemiapo ràm imume'u pà newe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","A'e 7 tapi'ak ikatu ma'e a'e wà, 7 kwarahy romo wanekon a'e wà. A'e 7 arozràn iapo kwer a'e wà no, nezewegatete a'e wà no. Mokoz nepuahu awer pitài ma'e umume'u newe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A'e 7 tapi'ak iagaiw ma'e iaiw ma'e a'e wà, 'y wi tapi'ak ikatu ma'e wanaikweromo uhem ma'e kwer a'e wà, a'e 7 arozràn iapo kwer uxinig ma'e a'e wà no, 7 kwarahy romo wanekon a'e wà. A'e 7 kwarahy rehe nuhyk kwaw temi'u teko wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tupàn wexak kar wemiapo ràm newe a'e, heze'eg awer rupi katete a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ximumaw putar 7 kwarahy nehe. Heta tetea'u putar temi'u Ezit ywy rehe har wanupe a'e kwarahy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A'e re ximumaw putar amo 7 kwarahy nehe. A'e kwarahy rehe nuhyk kwaw temi'u teko wanupe nehe. Ima'uhez putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Wama'uhez tàwàm iaiw tuwe putar nehe. Ezit ywy rehe har na'ima'enukwaw kwaw kwarahy ikatu ma'e wanehe temi'u tetea'u heta awer rehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tupàn nemupuahu kar wi a'e, ta'e uzapo putar tuwe a'e ma'e a'e nehe xe. Uzapo putar tàrityka'i nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Uze'eg wi Zuze tuwihawete pe. — A'e rupi, tuwihawete, exaexak amo awa ma'ekwaw katu har nehe, neiwy rehe har waneruze'egar romo imuigo kar pà nehe. Ikatuahy putar nezewe neremiapo ràm nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Exaexak amo awa ne wà nehe no. A'e awa wata putar oho tawhu nàn ko nàn wà nehe. Aze heta 5 temi'u hyrupor amo wanupe nehe, upyhyk putar pitài hyrupor wanuwi wà nehe, herur pà xe wà nehe, a'e 7 kwarahy ikatu ma'e imumaw 'ym mehe we wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","A'e 7 kwarahy ikatu ma'e rehe a'e awa omono'og putar arozràn tetea'u wà nehe, tàpuzuhu uhua'u ma'e tawhu pe har nànàn imonokatu pà wà nehe. Ne ereiko putar waneruze'egar romo nehe, agwer ma'e paw iapo kar pà wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nezewe mehe a'e temi'u imono'og pyràm imonokatu pyràm uhyk putar Ezit ywy rehe har wanupe a'e 7 kwarahy iaiw ma'e rehe nehe. Nezewe mehe teko numàno kwaw ma'e i'u 'ym pà wà nehe, i'i Zuze tuwihawete pe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Zuze ize'eg awer ikatuahy tuwihawete pe. Ikatuahy hemiruze'eg nànàn no. ");
INSERT INTO gubBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Na'e tuwihawete uze'eg a'e pe har wanupe a'e kury. — Tupàn Hekwe wiko ko awa rehe we a'e. A'e rupi a'e weruze'eg putar heywy rehe har upaw rupi a'e wà nehe. Ni amo awa na'ikatu wera'u kwaw Zuze wi a'e. Ni amo awa nukwaw wera'u kwaw ma'e izuwi, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A'e re ume'e Zuze rehe izupe uze'eg pà kury. — A'e ma'e paw Tupàn wexak kar newe a'e. Ni amo nupuner wera'u kwaw newi wà, ni amo nukwaw wera'u kwaw ma'e newi wà. Ure paw uruexak nepuner haw ure. ");
INSERT INTO gubBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","A'e rupi erepureruze'eg putar heràpuzuhu pupe nehe. Heremiaihu paw weruzar putar neze'eg wà nehe. Xo ihe zo apuner wera'u putar newi ihe nehe, ta'e tuwihawete romo aiko ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ko 'ar rehe urumuigo kar Ezit ywy rehe har paw wanuwihaw romo ihe kury, i'i tuwihawete Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","A'e 'ar mehe we wenuhem ukwàku'aw har uwer hereko har ukwà wi kury, Zuze ikwà rehe imono pà kury. A'e re uze'eg uma'ereko ma'e wanupe. — Pemunehew kar kamirpuku hekuzar katu ma'e irin iapo pyrer hehe nehe, ty wà, i'i wanupe. Omono mu'yr or iapo pyrer iazuromo wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A'e re umuzeupir kar ywyramawa rehe wà kury. Tuwihawete hekuzaromo har pe imonokatu pyr a'e ywyramawa a'e. A'e re uze'eg wi awakwer wanupe. — Peho izywyramawa henataromo nehe, teko wanupe penehapukaz pà nehe. — Tuwihaw ur iko ty wà, pehem hape ràm wi ty wà, peze peho peiko wanupe nehe, izywyramawa henataromo peata mehe nehe ty wà, i'i wanupe. Nezewe Zuze wiko Ezit ywy rehe har paw wanuwihaw romo a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tuwihawete uze'eg Zuze pe kury. — Aiko tuwihawete romo ihe. Ereiko tuwihaw upuner ma'e romo ne no. Aze nerezapo kar kwaw ma'e nehe, ni amo Ezit ywy rehe har nupuner kwaw ma'e iapo haw rehe a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Omono tuwihawete amo her Zuze pe. — Zapenat Panez her pyahu romo. Omono Poxiper tazyr Azenat her ma'e hemireko romo. Poxiper a'e, xaxeto Eriopori tawhu pe har romo hekon a'e. Zuze wereko 30 kwarahy tuwihawete pe uma'ereko pà uzypyrog mehe a'e. Uhem oho tuwihawete henatar wi a'e kury, Ezit ywy pehegwer nànàn wata pà a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Umumaw 7 kwarahy arozràn tetea'u ipo'o pà a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Omono'og Zuze a'e arozràn upaw rupi a'e, tàpuzuhu arozràn hyru pupe a'e. Tawhu nànàn heta agwer tàpuzuhu. Omonokatu arozràn tawhu huwake har a'e tàpuzuhu pupe pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Omono'ono'og tuwe temi'u tetea'u a'e. Ni nuexak kwaw ipuhuz taw kury, ta'e heta tetea'u a'e xe. Nuzawy kwaw ywyxig yryhu iwyr har a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","A'e kwarahy rehe, kwarahy ma'uhez taw hereko har ihem 'ym mehe we uzexak kar mokoz ta'yr Zuze pe hemireko Azenat rehe we a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Omono Manaxe her romo wa'yr ipy pe. — Ma'e wi purumueharaz kar haw, i'i her zaneze'eg rupi. Nezewe i'i Zuze. — Tupàn hemueharaz kar ma'erahy heremipuraraw kwer wi a'e, heru iànàm wanemipuraraw kwer wi a'e no, i'i amogwer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Omono Eparai wa'yr inugwer pe her romo. — Ta'yr izexak kar haw, i'i her zaneze'eg rupi. — Tupàn umur hera'yr ihewe a'e wà, ywy ma'erahy ipuraraw pawer rehe a'e wà, i'i amogwer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na'e upaw a'e 7 kwarahy temi'u tetea'u heta haw Ezit ywy rehe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Uzypyrog 7 kwarahy ma'uhez taw heta haw imumaw pà wà kury, Zuze ize'eg awer rupi katete wà kury. Amogwer ywy rehe teko ima'uhez wà. Ezit ywy rehe heta temi'u teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Aze amo Ezit ywy rehe har uzypyrog ima'uhez tà wà, oho tuwihawete pe temi'u henoz tà izupe wà. — Peze'eg peho Zuze pe nehe. Peruzar tuwe ize'eg nehe, i'i tuwihawete teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma'uhez taw uhua'u mehe Zuze uwàpytymawok a'e tàpuzuhu arozràn hyruhu paw rupi a'e kury. Uzypyrog arozràn ime'eg pà Ezit ywy rehe har wanupe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ywy nànànar ur Ezit pe temi'u ime'eg kar pà Zuze wi wà. Ta'e azeharomoete nuhyk kwaw temi'u ywy nànàn a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Amo 'ar mehe amo uze'eg wà Zako pe. — Heta temi'u Ezit ywy rehe, i'i izupe wà. A'e rupi uze'eg Zako wa'yr pe kury. — Màràzàwe tuwe peiko xe ma'e iapo 'ym pà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","— Heta temi'u Ezit ywy rehe, i'i kwez ihewe wà. Peho a'e pe arozràn ime'eg kar pà nehe. Nezewe mehe nazamàno kwaw nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","A'e rupi a'e 10 Zuze tyky'yr Zako ta'yr oho Ezit ywy rehe temi'u ime'eg kar pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Zako nomono kar kwaw wa'yr Mezàmi Zuze tywyr amogwer wa'yr wanupi a'e. — Aze ru'u iaiw ma'e uzeapo putar Mezàmi pe iho mehe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Zako ta'yr a'e wà, oho amo teko wanupi temi'u ime'eg kar pà Ezit ywy rehe a'e wà. Ta'e teko Kànàà ywy rehe har paw ima'uhez waiko a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zuze a'e, Ezit ywy rehe har wanuwihaw romo hekon a'e. A'e rupi a'e ae ume'eg arozràn teko amo ae ywy rehe har wanupe. Amo 'ar mehe tyky'yr uhem a'e pe wà. Wapyk upenàràg rehe henataromo wà. Umuhyk uwa ywy rehe imuawate pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wyky'yr wanexak mehe a'e 'ar mehe we Zuze ukwaw a'e wà. Numume'u kwaw wakwaw pawer wanupe. Uze'egahy wanupe, wanehe upuranu pà. — Ma'e wi pezur, i'i wanupe. — Kànàà ywy wi uruzur ure, i'i izupe wà. — Urepurume'eg kar wer temi'u rehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ukwaw Zuze wyky'yr wà. Tyky'yr nukwaw kwaw uwywyr Zuze wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Na'e Zuze ima'enukwaw upuahu awer wyky'yr rehe arer rehe kury. Uze'eg wi wanupe. — Peiko ureàmàtyry'ymar romo. Pezur xe urekàg 'ymaw hexak pà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","— Nan kwaw nezewe, urezar. Nuruzapo pixik kwaw agwer ma'e, urezar. Ure neremiruze'eg ure, uruzur xe temi'u ime'eg kar pà ure. ");
INSERT INTO gubBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ure paw pitài awa ta'yr romo uruiko ure. Nuruiko kwaw peàmàtyry'ymar romo, nuruzur kwaw xe pekàg 'ymaw hexak pà. Uruiko teko ikatu ma'e romo, ma'e rehe imunar pixik 'ym ma'e romo ure, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","— Nazeruzar kwaw peze'eg rehe ihe. Pezur xe ureiwy ikàg 'ymaw hexak pà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","— Uruiko Kànàà ywy rehe. Uruiko 12 awa romo ure pitài awa ta'yr romo ure. Pitài urerywyr ukàzym. Tywyr wiko ureru ipyr ko 'ar rehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","— Peiko heremimume'u kwer romo azeharomoete. Peiko ureàmàtyry'ymar romo urekàg 'ymaw rehe ume'e ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Aze pepuruexak kar wer ureàmàtyry'ymar romo peneko 'ymaw rehe ihewe nehe, pezapo ko heremimutar nehe. Aze penywyr nur kwaw xe nehe, napeho kwaw xe wi nehe. Amume'uahy peho 'ym àwàm heruwihawete heko haw rehe ihe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pexak pitài awa nehe. Pemono kar a'e awa penywyr ipiaromo nehe. Amogwer wiko putar xe zemunehew paw pe wà nehe, iho mehe wà nehe. Aze peze'eg azeharomo nehe, xo a'e mehe zo pehem putar zemunehew paw wi nehe. Aze naperur kwaw penywyr nehe, akwaw putar ureàmàtyry'ymar romo peneko haw ihe nehe. Amume'uahy ko heze'eg tuwihawete heko haw rehe ihe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A'e rupi umunehew kar zemunehew paw pe a'e wà kury. Umumaw na'iruz 'ar a'e pe wiko pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na'iruz haw 'ar mehe Zuze uze'eg wanupe. — Ihe aiko Tupàn wi ukyze ma'e romo ihe, imuwete katu har romo ihe. Napuzuka kar kwaw ihe nehe, aze pezapo amo ma'e heremimume'u ràm nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Aze peiko teko imunar 'ym ma'e romo, a'e mehe pitài upyta xe zemunehew paw pe nehe. Amogwer upuner oho haw rehe peneko haw pe wà nehe, temi'u heraha pà peànàm wanupe wà nehe, wama'uhez taw imumaw pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","A'e re perur penywyr ipyahu wera'u ma'e xe nehe. Nezewe mehe akwaw putar penemu'em 'ymaw ihe nehe. Aze peze'egaw azeharomoete nehe, a'e mehe napuzuka kar kwaw ihe nehe, i'i wanupe. — He'e pa, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Na'e uze'eze'eg uzeupeupe wà. — Azeharomoete xipuraraw ma'erahy zane kury, ta'e xiapo iaiw ma'e zanerywyr Zuze pe zane xe. — Hepuhareko pe nehe, i'i zanewe kwehe mehe, a'e ma'e iaiw ma'e iapo mehe. Nazazekaiw kwaw ize'eg rehe. A'e rupi ko 'ar rehe xipuraraw ma'erahy zane kury, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Uze'eg Humen amogwer wanupe kury. — Xiapo zo iaiw ma'e izupe nehe, a'e peme a'e 'ar mehe. Napepureruzar wer kwaw heze'eg rehe. A'e rupi ko 'ar rehe xipuraraw ma'erahy imàno awer hekuzaromo zane kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zuze wenu katu waze'eg mehe wà. Tyky'yr nukwaw kwaw wà. Ta'e a'e 'ym mehe Zuze uze'eg wanupe amo ae ywy rehe har waze'eg rupi a'e xe. Hemiruze'eg umume'u ize'eg wanupe waze'eg rupi. A'e rupi ukwaw hemimume'u kwer wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Uhem Zuze oho wyky'yr wanuwi kury. Uzai'o kury. Izai'o pawire uzewyr wanupe. Upyhyk kar Ximeàw zauxiapekwer wanupe, iàpixipixi kar pà, amogwer wanenataromo. ");
INSERT INTO gubBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tyky'yr werur ma'eryru uzeupi wà. A'e rupi Zuze uze'eg wemiruze'eg wanupe kury. — Pemynehem wama'eryru temi'u pupe nehe. — Pemuzewyr zàmim wanemetarer wanupe nehe, temi'u i'aromo imono pà nehe. Pemono temi'u wanupe nehe no, pe rupi wata mehe har romo wanemi'u ràm romo wanupe nehe no, i'i wanupe. Uzapo ma'e ize'eg awer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na'e Zuze tyky'yr upir temi'u wemime'eg karer imono zumen wakupepe wà kury. Oho a'e wi wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Umumaw pitài 'ar wata pà wà. Uhem uker àwàm me wà. Amo uwàpytymawok temi'u hyru ta'e iporopoz wer weimaw wanehe xe. Wexak wemetarer temi'u i'aromo imono pyrer a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Uze'eg uwywyr wanupe. — Peme'e ko ma'e rehe ty wà. Heremetarer xe tuz ty wà, heremi'u ràm hyru pupe ty wà. Umuzewyr heremetarer ihewe wà, i'i wanupe. Ipytuhegatu tywyr upaw rupi wà. Uryryryryz ukyze pà wà. Upuranu uzehezehe wà. — Ma'e Tupàn uzapo iko zanewe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kànàà pe uhem mehe uze'eg oho u Zako pe wà, ma'e uzeapo ma'e kwer paw imume'u pà izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","— A'e awa a'e, Ezit ywy rehe har wanuwihaw upuner ma'e a'e, uzapo iaiw ma'e urewe a'e. — Peiko xe heywy rehe heàmàtyry'ymar romo urekàg 'ymaw hexak pà pe, i'i urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","— Awa ikatu ma'e romo uruiko ure. Nuruiko kwaw peàmàtyry'ymar romo pekàg 'ymaw hexakar romo ure, uru'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","— 12 tywyr romo uruiko, pitài awa ta'yr romo uruiko. Pitài urerywyr ukàzym a'e. Inugwer wiko ureru ipyr Kànàà ywy rehe a'e kury, uru'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tuwihaw uze'eg nezewe urewe. — Azapo putar amo ma'e ihe nehe kury. Nezewe mehe akwaw putar awa ikatu ma'e romo peneko haw ihe nehe. U akwaw putar ikatu 'ym ma'e romo peneko haw nehe. Pitài upyta putar xe hepyr nehe. Pezewyr putar peneko haw pe nehe, temi'u pixik heraha pà peànàm wanupe nehe, ta'e ima'uhez waiko a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Perur penywyr ipyahu wera'u ma'e xe ihewe nehe. Aze napezapo kwaw heremiapo kar nehe, akwaw putar heàmàtyry'ymar romo peneko haw ihe nehe. Aze pezapo nehe, akwaw putar heàmàtyry'ymar romo peneko 'ymaw nehe. Nezewe mehe pepuner xe pezur haw rehe ma'e me'eg kar pà ihewi nehe, i'i urewe a'e, i'i u pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na'e wenuhem temi'u hyru wi wà kury. Pitàitàigatu wexak wemetarer wemi'u hyru pupe temi'u i'aromo wà, ma'eryru pixika'i ma'e pupe wà. Wanu a'e, ta'yr a'e wà no, a'e temetarer hexak mehe ukyze katu tuwe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Uze'eg Zako wa'yr wanupe kury. — Aipo peraha putar hera'yr paw ihewi wà nehe. Zuze nuiko kwaw xe zanepyr a'e. Ximeàw nuiko kwaw xe a'e no. Pepurueraha wer Mezàmi rehe ihewi no. Pepuraraw kar ma'erahy tetea'u peiko ihewe, i'i wa'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Na'e Humen uze'eg u pe kury. — Tuwe oroho nehe. Azekaiw katu Mezàmi rehe ihe nehe. Aruzewyr wi putar newe nehe. Heta mokoz hera'yr ihewe wà. Aze narur kwaw nehe, erepuner hera'yr wazuka haw rehe nehe, i'i u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","— Hera'yr noho kwaw penupi nehe. Tyky'yr Zuze a'e, umàno a'e. Xo Mezàmi zo upyta ihewe kury. Aze amo iaiw ma'e uzeapo izupe peata mehe nehe, a'e mehe hezuka kar putar pe hezemumikahy haw pupe nehe, i'i Zako wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kànàà ywy rehe har ima'uhez wiwi waiko wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Zako a'e, iànàm a'e wà, ta'yr iànàm a'e wà no, umumaw a'e temi'u Ezit ywy wi herur pyrer a'e wà kury. Na'e Zako uze'eg wa'yr wanupe kury. — Pezewyr Ezit pe nehe ty wà, amo temi'u ime'eg kar pà zanewe nehe ty wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Zuta umuma'enukwaw kar u ma'e uzeapo ma'e kwer rehe kury. — A'e awa umume'uahy tuwe uze'eg urewe a'e. Aze urerywyr noho kwaw urerupi nehe, tuwihaw nuze'eg kwaw urewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aze eremono kar urerupi nehe, urume'eg kar putar temi'u oroho newe ure nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aze neremono kar kwaw nehe, noroho kwaw nehe. Nezewe uze'eg a'e awa. — Aze perur penywyr ipyahu wera'u ma'e nehe, xo a'e mehe zo aze'eg putar peme ihe nehe, i'i urewe, i'i u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Zako uze'eg wanupe. — Màràzàwe tuwe pemu'ar kar agwer iaiw paw herehe. Màràzàwe tuwe pemume'u penywyr heko haw a'e tuwihaw pe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Uze'eg u pe wà. — A'e awa upuranu tetea'u urerehe a'e, urereko haw ureànàm waneko haw imume'u kar pà urewe a'e. Upuranu nezewe urerehe. — Aipo penu wikuwe a'e rihi. Aipo heta amo penywyr, i'i urewe. Umume'u kar urereko haw urewe. Nurukwaw kwaw urerywyr rehe ipuruexak wer àwàm ure. Nurukwaw kwaw urerywyr heraha àwàm imume'u àwàm ure, i'i u pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Uze'eg Zuta u pe kury. — Tuwe azekaiw katu kwàkwàmo rehe nehe. Uruhem putar oroho tàrityka'i ure nehe kury. Ni amo numàno kwaw wà nehe. Ni ure, ni ne, ni urepurumuzàmuzàg wà, ni amo numàno kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Azekaiw katu putar Mezàmi rehe nehe. Aze narur wi kwaw nehe, aze kwàkwàmo na'ikatu kwaw urezewyr mehe nehe, erepuner herehe nezepykaw rehe nehe. Izuka kar arer romo aiko putar neruwa rupi herekuwe mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Aze mo naximumaw iwer mo zahy tetea'u ureho 'ym pà, a'e mehe mo mokoz haw oroho mo Ezit pe ure, a'e wi uruzewyr pà mo mokoz haw ure, i'i u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Na'e tu uze'eg kury. — Naheta kwaw amo ae zaneremiapo ràm zanewe. A'e rupi peho mehe pemono ma'e imono e pyràm a'e tuwihaw pàràm nehe. Pepyhyk ikatu wera'u ma'e ko ywy rehe har nehe, heraha pà izupe pema'eryru pupe nehe: kàpuhàg mawxàm her ma'e, hàir, temi'u inuromo imono pyr imuwe katu har. Peraha ma'e'yw hà'àzgwer i'u pyràm izupe nehe no. Peraha ma'e'yw hà'yzgwer amen her ma'e izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Peraha a'e hemetarer peme imur pyrer izupe nehe no, imuzewyr kar pà izupe nehe no. Ta'e pexak pema'eryru pupe pe xe, arozràn i'aromo imono pyrer pe xe. Perur a'e temetarer xe. Aze ru'u amo hemiruze'eg uzawy a'e. Peraha amo temetarer izupe nehe no, amo temi'u ime'eg kar pà izuwi nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Peraha penywyr pezeupi nehe no. Na'arewahy peàwàxi wi a'e awa peho nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Tuwe Tupàn ikàg wera'u ma'e pepuhareko kar izupe nehe. Nezewe mehe umuzewyr kar putar penywyr inugwer xe peneko haw pe Mezàmi rehe we nehe. Ihe ihe nehe, aze hera'yr ukàzym ihewi wà nehe, ma'e apuner iapo haw rehe nehe, i'i Zako wa'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","A'e rupi Zako ta'yr upyhyk a'e ma'e tuwihaw pe imono pyràm wà kury. Upyhyk wemetarer imuzewyr pyrer wà. Upyhyk amo wemetarer wà no. Weraha Mezàmi wà no. Ezit ywy rehe uhem mehe uze'eg na'arewahy Zuze pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Uhem henataromo wà. Mezàmi wiko wainuromo henataromo. Hexak mehe uze'eg Zuze wàpuz rehe uzekaiw ma'e wanuwihaw pe kury. — Eraha ko awa heràpuz me ne wà nehe. Ezuka amo ma'ea'yr nehe, emuhyk temi'uhu nehe. Umai'u putar hepyr a'e wà nehe, kwarahy wapytepe hin mehe a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","A'e tuwihaw weruzar ize'eg. Weraha tyky'yr hàpuz kutyr wà, tywyr heraha pà no. ");
INSERT INTO gubBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","A'e pe wahem mehe ukyze a'e wà. Uze'eg uzeupeupe wà. — Zanererur xe a'e wà, a'e temetarer zanema'eryru pupe imono pyrer rehe a'e wà. Azeharomoete zanepyhyk putar wà nehe, zanepetepetek pà wà nehe. Upyro putar zanereimaw zumen zanewi wà nehe. Zanemuma'ereko kar putar uma'ereko e ma'e romo wà nehe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tàpuz hukenaw pe uhem mehe uze'eg a'e tuwihaw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","— Ezeapyaka katu ureze'eg rehe, tuwihaw. Amo 'ar mehe uruzur xe temi'u ime'eg kar pà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Xe wi ureata mehe urupytu'u amo me ureker pà. Uruwàpytymawok ureremi'u hyru. Pitàitàigatu uruexak ureremetarer ma'eryru pupe arozràn i'aromo. Ureremetarer paw uruexak. Kutàri urerur wi a'e temetarer paw imuzewyr pà peme ure. ");
INSERT INTO gubBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Urerur amo ae ureremetarer xe amo ae ureremi'u ràm ime'eg kar pà ure no. Nurukwaw kwaw a'e temetarer urema'eryru pupe imono arer ure, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Na'e a'e tuwihaw uze'eg wanupe. — Pezemumikahy zo nehe, pekyze zo nehe. Tupàn pezar a'e, penu izar a'e no, a'e ru'u omono a'e temetarer pema'eryru pupe peme a'e. Ta'e ihe apyhyk penemetarer penemi'u hekuzarer ihe xe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A'e re weraha tàpuz pupe wà. Omono 'y wanupe wazepuez taw romo. Omono temi'u waneimaw zumen wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Zuze tyky'yr umuhyk a'e ma'e herur pyrer wà kury, Zuze pe imono pyràm wà kury. — Ximono izupe kwarahy wapyter pe hin mehe tur mehe nehe, i'i uzeupeupe wà. Ta'e ukwaw a'e pe tur àwàm imai'u àwàm a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Na'e uhem Zuze wàpuz me kury. Tyky'yr omono a'e ma'e herur pyrer izupe wà. Wapyk upenàràg rehe henataromo wà. Umuhyk uwa ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","— Pekatu aipo. Aipo oho katu ma'e paw rupi, i'i Zuze wanupe. — Penu a'e, ihewe penemimume'u kwer a'e, aipo ikatu a'e. Aipo wikuwe a'e rihi, i'i wanupe, wanehe upuranu pà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","— Ureru a'e, newe uma'ereko e ma'e ikàg 'ym ma'e a'e, wikuwe a'e rihi. Ikatu a'e, ikàg a'e, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Uzareko Zuze, a'e pe har wanehe ume'e pà. Wexak uwywyr Mezàmi a'e kury. (Tu ta'yr a'e, ihy imemyr a'e no.) Uze'eg amogwer wanupe. — Aipo kwez awa penywyr kurer romo hekon a'e, penemimume'u kwer romo a'e, i'i wanupe wanehe upuranu pà. (-He'e, i'i izupe wà.) — Tuwe Tupàn umur uze'egatu nerehe, hera'yr, i'i Mezàmi pe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Uwywyr hexak mehe iamutar katu haw uhua'u ipy'a pe. A'e rupi izai'o wer. A'e rupi uhem oho uker haw pe kury, a'e pe uzai'o pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nan kwehe tete upytu'u uzai'o re kury. Uhez uwa no. Uhem wi uker haw wi amogwer wanupe oho pà. Uze'eg uma'ereko ma'e wanupe kury. — Pemuapyk ureremi'u ràm ywyrapewhu rehe kury ty wà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Omono temi'u Zuze pe amo ywyrapewhu rehe wà. Omono temi'u tyky'yr wanupe amo ae ywyrapewhu rehe wà. Omono temi'u Ezit ywy rehe har a'e pe har wanupe amo ae ywyrapewhu rehe wà. Ta'e Emerew numuwete kwaw tupàn Ezit rehe har wazar a'e wà xe. A'e rupi Ezit ywy rehe har numai'u kwaw Emerew wanuwake wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tyky'yr wapyk Zuze henataromo wà. — Eapyk xe, i'i amo pe. — Eapyk pe pe, i'i amo pe. Pitàitàigatu Zuze umuapyk kar wyky'yr ywyrapewhu huwake wà. Wanyky'yr wapyk xe, tywyr ipy wapyk huwake. Nezewegatete watua'u haw rupi umuapyk kar Zuze wyky'yr wà. Utua'u haw kwaw paw hexak mehe tyky'yr ume'e uzehezehe wà. — Màràzàwe tuwe ukwaw zanezexak kar awer 'ar a'e, i'i uzeupeupe wà, uzehezehe upuranu pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Omono uma'ereko ma'e temi'u ikatu ma'e Zuze pe wà. Nezewegatete omono temi'u ikatu ma'e tyky'yr wanupe wà no. Omono pitài temi'u hyru ipor wanupe pitàitàigatu wà. Omono 5 temi'u hyru ipor Mezàmi pe wà. Ui'u win tetea'u pupe Zuze ipyr wà. Te hurywete paw wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na'e Zuze uze'eg wàpuz rehe uzekaiw ma'e pe a'e kury. — Emynehem wama'eryru wanemirurer temi'u pupe nehe. Emynehegatu nehe. Emono wanemetarer wama'eryru pupe pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Wanywyr ima'eryru pupe emono hekanek parat iapo pyrer nehe, hemetarer temi'u hekuzarer rehe we nehe, i'i izupe. A'e uma'ereko ma'e weruzar ize'eg paw a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Izi'itahy Zuze tyky'yr uhem oho a'e wi wata pà weimaw zumen rupi wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tawhu wi wahem ire muite waho 'ym mehe we uze'eg wi Zuze wàpuz rehe uzekaiw ma'e pe kury. — Ezàn eho a'e awa wanaikweromo nehe. Wanuwake nehem mehe eze'eg nezewe wanupe. — Màràzàwe tuwe pezapo ikatu 'ym ma'e ikatu ma'e hekuzaromo, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","— Màràzàwe tuwe pemunar hezar ikanek parat iapo pyrer rehe. Izi'u haw a'e kanek a'e. Uzeapo ma'e kwer imume'u haw romo a'e kanek wereko a'e. Iaiw ma'e pezapo kwez a'e kanek rehe pemunar mehe, ere mua'u wanupe nehe, i'i Zuze wemiruze'eg pe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Oho hemiruze'eg wanaikweromo. Uhem wanuwake. Uze'eg wanupe Zuze hemimume'u kwer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","— Màràzàwe tuwe ereze'eg nezewe urewe. Nurupuner pixik kwaw agwer ma'e iapo haw rehe ure. ");
INSERT INTO gubBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Urerur a'e temetarer urema'eryru pupe ureremixak kwer pitàitàigatu ure. A'e rupi, màràzàwe tuwe mo uremunar ma'e nezar hàpuz me har rehe ure. ");
INSERT INTO gubBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Aze erexak ikanek urema'e inuromo nehe, uruzuka putar hereko har ure nehe. Uruiko putar newe uma'ereko e ma'e romo tuweharupi ure nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Zuze hemiruze'eg uze'eg wi tyky'yr wanupe. — Peze'eg ikatu ihewe. Xo kanek hereko har zo wiko putar ihewe uma'ereko e ma'e romo tuweharupi nehe. Amogwer upuner oho haw rehe xe wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Na'e tàrityka'i umuezyw temi'u hyru ywy rehe wà. Uwàpytymawok uma'eryru pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Zuze hemiruze'eg wekar kanek wama'eryru pupe pitàitàigatu a'e. Wekar wanyky'yr wama'eryru pupe. Nuexak kwaw. Pitàitàigatu wama'eryru pupe wekar. Iahykaw rehe wekar Mezàmi ma'eryru pupe. Wexak kanek a'e pe temi'u i'aromo. ");
INSERT INTO gubBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tyky'yr umu'i ukamir puku wà, uzemumikahy haw hexak kar pà wà. Upir wi uma'e weimaw zumen wakupepe wà, tawhu pe uzewyr pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zuta a'e, tyky'yr paw tywyr paw a'e wà no, uhem Zuze hàpuz me a'e wà. Zuze wikuwe a'e pe wahem mehe. Wapyk upenàràg rehe henataromo wà. Umuhyk uwa ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Na'e upuranu Zuze wanehe. — Màràzàwe tuwe pezapo agwer ma'e. Aiko ma'e ikwaw pyr 'ym kwaw par romo ihe. Aipo napekwaw kwaw hekàgaw, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Uze'eg Zuta izupe kury. — Ma'e urumume'u putar newe, tuwihaw, i'i izupe. — Ma'e urumume'u putar newe urekatu haw hexak kar pà newe nehe. Tupàn wexak ureremiapo kwer iaiw ma'e a'e. Uruiko xe kury. Newe uma'ereko e ma'e romo uruiko ure kury. Nekanek hereko har a'e no, newe uma'ereko e ma'e romo hekon a'e no, i'i Zuta Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","— Nan kwaw pa, i'i Zuze izupe. — Nazapo pixik kwaw agwer ma'e ihe. Xo hekanek heraha arer wiko putar ihewe uma'ereko e ma'e romo a'e nehe. Amogwer upuner u heko haw pe uzewyr haw rehe a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Na'e Zuta uhem Zuze huwake kury, uze'eg pà izupe kury. — Tuwihaw, i'i izupe. — Eikwahy zo ihewe, ta'e tuwihawete ài ereiko ne xe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Erepuranu urerehe. — Aipo heta penu peme, ere urewe. — Aipo heta amo penywyr peme, ere urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","— He'e pa, heta ureru urewe, itua'uhez tuwe a'e. Heta urerywyr kurer urewe no. Uzexak kar ureru itua'uhez mehe a'e, uru'e newe. — Tyky'yr a'e, umàno a'e. Xo a'e zo heta we uhy pe. Tu uzamutar katu a'e, uru'e ure. ");
INSERT INTO gubBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","A'e re ereze'eg urewe. — Perur penywyr xe nehe, ta'e hepuruexak wer hehe ihe xe, ere urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","— Nupuner kwaw uhemaw rehe u wi a'e, uru'e newe. — Ta'e aze wezar u nehe, tu umàno putar nehe, uru'e newe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","— Aze nur kwaw xe nehe, napumuixe kar kwaw xe herenataromo nehe, ere urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Urereko haw pe urehem mehe urumume'u neze'eg awer paw ureru pe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","A'e re uremur kar wi xe. — Peme'eg kar wi temi'u nehe, i'i urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","— Nurupuner kwaw ureho haw rehe, uru'e ureru pe. — A'e awa na'uremuixe kar kwaw wenataromo a'e nehe, aze urerywyr ipyahu wera'u ma'e noho kwaw urerupi a'e nehe. Aze urerywyr ipyahu wera'u ma'e oho urerupi nehe, xo a'e mehe zo oroho putar ure nehe, uru'e ureru pe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na'e ureru uze'eg wi urewe. — Pekwaw ma'e uzeapo ma'e kwer pe. Heremireko Hakew umur mokoz hera'yr ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Pitài uhem oho ihewi. Naexak pixik kwaw a'e re ihe. Aze ru'u miar uzuka wà, hetekwer ipei'ài'àg pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aze peraha tywyr ihewi nehe, aze amo iaiw ma'e uzeapo izupe nehe, hezuka kar putar pe hezemumikahy haw pupe nehe, i'i urewe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","— A'e rupi, aze azewyr hereko haw pe herywyr heraha 'ym pà nehe, aze heru nuexak kwaw wa'yr nehe, a'e 'ar mehe we umàno putar nehe. Ta'e wikuwe wa'yr heko haw rehe a'e xe. Aze nureraha kwaw urerywyr urerupi nehe, ureru itua'uhez ma'e izuka àràm romo uruiko putar nehe. Ta'e izemumikahy haw uzuka putar a'e nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","— Azekaiw katu putar tuwe hehe nehe, a'e heru pe, heremiapo ràm imume'uahy pà izupe. — Aze narur wi kwaw kwàkwàmo xe nehe, herekuwe mehe aiko putar izuka arer ài neruwa rupi nehe, a'e heru pe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","A'e rupi ainoz ko ma'e newe ihe kury, tuwihaw. Tuwe aiko xe kwàkwàmo hekuzaromo newe uma'ereko e ma'e romo ihe nehe. Tuwe uzewyr oho wyky'yr rupi weko haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ta'e napuner kwaw hezewyr haw rehe hereko haw pe xe, aze kwàkwàmo noho kwaw herupi nehe. Nahepurexak wer kwaw heru rehe ihe nehe, ko ma'e iaiw ma'e rehe uzemumikahy haw rehe imàno mehe ihe nehe, i'i tyky'yr Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Izai'o wer tuwe Zuze a'e kury. Nupuner kwaw uzai'o 'ymaw rehe uma'ereko ma'e wanenataromo. A'e rupi uhapukaz wanupe. — Pehem peho xe wi upaw rupi ty wà, i'iahy wanupe. A'e rupi, wyky'yr wanupe weko haw imume'u mehe ni amo uma'ereko ma'e nuiko kwaw huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Uzai'oahy a'e. Ate Ezit ywy rehe har wenu izai'o mehe wà. Umume'u oho tuwihawete pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","I'i Zuze wyky'yr wanupe. — Aiko Zuze romo ihe. Aipo heru wikuwe a'e rihi, i'i wanupe. Henu mehe tyky'yr ipytuhegatu tuwe wà. Nupuner kwaw ma'e imume'u haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Na'e i'i Zuze wanupe. — Pezur xe heruwake nehe ty wà, i'i wanupe. Uhem huwake wà. Uze'eg wi wanupe. — Aiko penywyr Zuze romo ihe. Kwehe mehe heme'eg pe amo wata ma'e wanupe. Hererur xe Ezit ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kwehe mehe heme'eg pe amo xe kutyr wata ma'e wanupe. Pezemumikahy zo nehe. Peikwahy zo pezeupeupe heme'eg awer rehe nehe, xe hemur kar awer rehe nehe. Tupàn hemur kar xe a'e, teko tetea'u wapyro pà ma'uhez taw wi a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ximumaw mokoz kwarahy temi'u ihyk 'ym mehe zane kury. Amo 5 kwarahy ximumaw putar nehe no. A'e kwarahy rehe teko numa'ereko kwaw ywy rehe wà nehe, nopo'o kwaw arozràn wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tupàn hemur kar penenataromo a'e. Nezewe mehe pepyro ma'uhez taw wi xe a'e, pemumàno kar 'ym pà a'e. Nezewe mehe heta putar pezuapyapyr a'e wà nehe kury, ta'e heta temi'u peme a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Napeiko kwaw xe hemur kar arer romo. Tupàn ae hemur kar xe a'e. Hemuigo kar tuwihawete hemiruze'eg ikàg wera'u ma'e romo a'e. Azekaiw katu hàpuzuhu rehe ihe. Aiko Ezit ywy rehe har paw wanuwihaw romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Peho tàrityka'i penu heko haw pe nehe. Peze'eg nezewe izupe hexak mehe nehe. — Nera'yr Zuze uze'eg nezewe urewe a'e. — Emume'u ko ma'e penu pe nehe, i'i urewe. — Tupàn hemuigo kar Ezit ywy rehe har paw wanuwihaw romo a'e. Ezur tàrityka'i herexak pà nehe. Epyta zo a'e pe nereko haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ereiko putar Kozem ywy pehegwer rehe nehe. Nezewe mehe ereiko putar xe heruwake nehe. Ne nehe, nera'yr a'e wà nehe no, neremimino wà nehe no, nereimaw àràpuhàràn hawitu ma'e a'e wà nehe no, nereimaw àràpuhàrànete a'e wà nehe no, nereimaw tapi'ak a'e wà nehe no, nema'e paw a'e wà nehe no, upaw rupi katete wiko putar xe heruwake a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ma'uhez taw umumaw putar amo 5 kwarahy nehe. Aze peiko Kozem ywy pehegwer rehe nehe, heruwake nehe, amono putar temi'u newe nehe, neànàm wanupe nehe no, nereimaw wanupe nehe no. Nezewe mehe uhyk putar ma'e peme nehe, i'i u pe, a'e ma'e imume'u kar pà wyky'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Uze'eg wi wanupe. — Pe paw rupi, herywyr Mezàmi a'e no, herexak pe kury. Aiko ihe romo azeharomoete ihe. Zuze romo tuwe aiko ihe, peme uze'eg ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pekwaw hekàgaw xe Ezit ywy rehe har. Pemume'u peho penu pe nehe. Pemume'u penemixak kwer paw izupe nehe. Peho tàrityka'i heru herur pà xe nehe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Zuze uzàzuwàn uwywyr. Uzai'o kury. Wyky'yr Zuze iàzuwàn mehe uzai'o Mezàmi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Na'e uzai'o wiwi mehe Zuze uzàzuwàn wyky'yr pitàitàigatu a'e wà no. A'e re tyky'yr uze'eg izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Amo umume'u uzeapo ma'e kwer tuwihawete hàpuzuhu pe wà. — Zuze tyky'yr uhem xe a'e wà, i'i teko oho Ezit ywy rehe har wanuwihawete hàpuz me har wanupe wà. Hurywete tuwihawete a'e ma'e henu mehe. Hurywete hemiruze'eg wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Uze'eg tuwihawete oho Zuze pe kury. — Eze'eg nezewe neryky'yr wanupe nehe, i'i izupe. — Peupir temi'u hyru peneimaw waku'az nehe, Kànàà ywy rehe pezewyr pà nehe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","— Perur penu xe nehe, perur peànàm xe wà nehe no. Amono putar ywy pehegwer Ezit rehe har ikatu wera'u ma'e peme nehe. Pe'u putar temi'u ko ywy rehe har ikatu wera'u ma'e nehe no, ere wanupe nehe, i'i tuwihawete Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","— Emono ywyramawa wanupe nehe. Nezewe mehe upuner wemireko wanerur haw rehe wà nehe. Upuner wa'yr wazyr wanerur haw rehe wà nehe no. Upuner u herur haw rehe ywyramawa pupe wà nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Upuner uma'e paw hezar haw rehe a'e pe wà nehe, ta'e amono putar ma'e Ezit ywy rehe har ko ywy rehe har ikatu wera'u ma'e wanupe xe wahem mehe ihe nehe xe, i'i tuwihawete Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","A'e rupi Zako ta'yr weruzar ize'eg wà. Zuze omono ywyramawa wanupe tuwihawete ze'eg rupi katete. Omono temi'u pe rupi i'u pyràm wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Omono kamir ipyahu ma'e wanupe no. Omono 3,5 kir parat Mezàmi pe. Omono 5 kamir katu izupe no. ");
INSERT INTO gubBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Umynehem kar 5 ma'eryru zumen ikupe pe har ma'e Ezit ywy rehe har ikatuahy wera'u ma'e pupe a'e no, u pe imono kar pà a'e no. Umynehem kar 10 ma'eryru zumen kupe pe har arozràn pupe no. Omono typy'ak no, omono amo ae temi'u pe rupi i'u pyràm romo no. ");
INSERT INTO gubBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","— Zazur rihi, i'i tyky'yr izupe wà. A'e wi wahem etea'i mehe uze'eg wi Zuze wanupe. — Pezeàmàtyry'ym zo pe rupi peata mehe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Uhem oho Ezit ywy wi wà, wata pà wà. Uhem oho Kànàà ywy rehe wà, u Zako hàpuz me wà. ");
INSERT INTO gubBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Uze'eg izupe wà. — Zuze wikuwe a'e. Ezit ywy rehe har paw wanuwihaw romo hekon a'e, i'i izupe wà. Iàkàzym tària'i Zako kury. Nupuner kwaw waze'eg rehe uzeruzar haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Umume'u Zuze ze'eg awer paw izupe wà. Wexak ywyramawa paw no. Ta'e tuwihawete werur kar iànàm Ezit pe a'e ywyramawa pupe a'e wà xe. A'e ma'e paw henu mehe a'e ma'e paw hexak mehe hurywete Zako a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Uze'eg wa'yr wanupe. — Azeharomoete peze'eg. Hera'yr Zuze wikuwe a'e rihi. Hepurexak wer tuwe hehe hemàno 'ym mehe we ihe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Na'e Zako a'e kury, oho weko haw wi a'e kury. Weraha uma'e paw wànàm paw weimaw paw uzeupi wà. Uhem Merexewa tawhu pe wà. Uzuka Zako ma'ea'yr Tupàn pe a'e pe a'e wà, u Àmàrààw izar pe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pyhaw Tupàn uze'eg izupe, ipuahu zàwenugar pupe. Uze'eg nezewe izupe. — Zako, Zako, i'i izupe. — Aiko xe ihe, i'i Zako izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","— Aiko Tupàn romo ihe, neru izar romo ihe. Ekyze zo Ezit ywy rehe neho àwàm wi nehe. Ta'e a'e pe nereko mehe amuigo kar putar nezuapyapyr teko tetea'u ikàg ma'e romo ihe wà nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aha putar Ezit pe nerupi nehe. Amo 'ar mehe arur wi putar nezuapyapyr xe ko ywy rehe ihe wà nehe. Nemàno mehe Zuze wiko putar nepyr a'e nehe, i'i Tupàn Zako pe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na'e uhem Zako oho Merexewa tawhu wi kury. Ta'yr omono u ywyramawa Ezit ywy rehe har wanuwihawete hemimur karer pupe a'e wà. Weraha wemireko a'e ywyramawa wapupe wà no. Weraha wa'yr pixika'i ma'e wapupe wà no, wazyr pixika'i ma'e waneraha pà wapupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nezewe Zako a'e, iànàm paw a'e wà no, oho Ezit ywy rehe a'e wà kury. Weraha weimaw tapi'ak paw uzeupi wà no, uma'e paw heraha pà uzeupi wà no, Kànàà ywy rehe imono'og pyrer paw heraha pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Weraha Zako uzuapyapyr paw wà: wa'yr wà, wazyr wà, wemimino wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Amume'u putar Izaew izuapyapyr waner paw xe ihe wà kury, Ezit ywy rehe oho ma'e kwer waner paw xe ihe wà kury. Humen, Zako ta'yr ipy her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Humen ta'yr wà no: Enok, Paru, Ezerom, Karimi. ");
INSERT INTO gubBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ximeàw. Ta'yr wà no: Zemuew, Zamim, Owaz, Zakim, Zoar, Xau. Xau a'e, amo kuzà Kànàà ywy rehe har imemyr romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Erewi. Ta'yr wà no. Zeroxon, Koat, Merari. ");
INSERT INTO gubBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zuta. Ta'yr wà no: Xera, Perez, Zera. (Ta'yr inugwer umàno Kànàà ywy rehe a'e 'ym mehe wà. Er, Onà umàno ma'e kwer waner romo wà.) Na'aw Perez ta'yr waner xe wà: Ezerom, Amu. ");
INSERT INTO gubBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ixakar. Ta'yr wà no: Tora, Puwa, Zazuwe, Xinirom. ");
INSERT INTO gubBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zemurom. Ta'yr wà no: Xerez, Erom, Zareew. ");
INSERT INTO gubBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","A'e Zako ta'yr a'e wà, hemireko Erez umur Zako pe Mezopotàm ywy rehe wiko mehe a'e wà. Umur pitài umemyr kuzà Zina her ma'e izupe a'e pe no. Zako izuapyapyr Erez rehe we har a'e wà, heta 33 a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kaz. Ta'yr wà no: Zipiàw, Agui, Xuni, Ezewom, Eri, Arozi, Areri. ");
INSERT INTO gubBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Azer. Ta'yr wà no: Imina, Iziwa, Iziwi, Meri. Tazyr no: Xera. Heta mokoz ta'yr Meri pe wà no: Emer, Mawkiew waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zako izuapyapyr hemireko Ziwpa rehe we har a'e wà, heta 16 a'e wà. Izypy mehe Àràmàw umur Ziwpa wazyr Erez pe a'e, izupe uma'ereko e ma'e romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Zako hemireko Hakew a'e, umur mokoz ta'yr izupe a'e wà: Zuze, Mezàmi waner wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Zuze ta'yr hemireko Azenat rehe we har wà, mokoz wà: Manaxe, Eparai waner wà. Uzexak kar Ezit ywy rehe wà. Azenat a'e, Poxiper tazyr romo hekon a'e. Poxiper a'e, Heriopori tawhu pe har waxaxeto romo hekon a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Na'aw Mezàmi ta'yr waner xe wà: Mera, Meker, Azimew, Zer, Mààmà, Ei, Oroz, Mupim, Upim, Areze. ");
INSERT INTO gubBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Zako izuapyapyr Hakew rehe we har a'e wà, heta 14 a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nà. Ta'yr a'e: Huzim. ");
INSERT INTO gubBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napitari. Ta'yr a'e wà: Zazeew, Kuni, Zezer, Xirem. ");
INSERT INTO gubBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Zako izuapyapyr Mira rehe we har a'e wà, heta 7 a'e wà. Izypy mehe Àràmàw umur Mira wazyr Hakew pe uma'ereko e ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Zako izuapyapyrete Ezit ywy rehe oho ma'e kwer a'e wà, 76 waneta haw a'e wà. Napapar kwaw ta'yr wanemireko xe ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Zuze ta'yr a'e wà, mokoz a'e wà, uzexak kar Ezit ywy rehe a'e wà. Nezewe Zako izuapyapyr Ezit ywy rehe oho ma'e kwer a'e wà, 70 waneta haw a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Uze'eg Zako Zuta pe kury. — Eho urerenataromo nehe. Erur Zuze urekutyr nehe, ureruwàxi kar pà Kozem ywy pehegwer rehe nehe. Uhem Zako Kozem ywy rehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Umuàgà'ym kar Zuze ywyramawa wemiruze'eg wanupe kury. Na'e oho Kozem pe kury, u huwàxi pà kury. Uzeàwàxi a'e pe wà. Wa'yr Zuze hexak mehe Zako uzàzuwàn kury. Uzai'o kury. Uzàzuwàn kwehea'u kury. ");
INSERT INTO gubBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Na'e uze'eg Zako izupe. — Apuner hemàno haw rehe ihe nehe kury, ta'e uruexak kwez ihe xe, ta'e akwaw nerekuwe haw ihe xe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","A'e re uze'eg Zuze wyky'yr wanupe kury, u iànàm wanupe no. — Aze'eg putar Ezit ywy rehe har wanuwihawete pe ihe nehe. — Heryky'yr a'e wà, heru iànàm a'e wà no, Kànàà ywy rehe wiko ma'e kwer a'e wà, ur kwez xe hepyr wiko pà a'e wà kury, a'e putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","— Àràpuhàràn hawitu ma'e wanehe àràpuhàrànete wanehe uzekaiw ma'e romo wanekon a'e wà. Tapi'ak mono'ogar romo wanekon a'e wà, a'e putar izupe nehe. — Werur weimaw àràpuhàràn kwez uzeupi wà. Werur weimaw tapi'ak kwez uzeupi wà no, a'e putar izupe nehe, i'i u pe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Aze ru'u tuwihawete upuranu putar penehe a'e nehe. — Ma'e iapo har romo peiko, aze ru'u i'i putar peme nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","— Uruiko àràpuhàràn wanehe uzekaiw ma'e romo ure, peze izupe nehe. — Nuruzapo pixik kwaw amo ae ma'e ure. Tuweharupi uruiko àràpuhàràn wanehe uzekaiw ma'e romo. Ureràmuz a'e wà no, tuweharupi wiko àràpuhàràn wanehe uzekaiw ma'e romo a'e mehe a'e wà no, peze tuwihawete pe nehe, aze upuranu penehe nehe, i'i wanupe. — Nezewe mehe pepuner ywy pehegwer Kozem her ma'e rehe peneko haw rehe nehe, ta'e Ezit ywy rehe har na'iakatuwawahy kwaw àràpuhàràn wanehe uzekaiw ma'e wanehe a'e wà xe, i'i wyky'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Na'e Zuze oho tuwihawete pe a'e ma'e imume'u pà kury. — Heru a'e, heryky'yr a'e wà no, ywy pehegwer Kozem her ma'e rehe wanekon a'e wà kury. Uzekaiw waiko weimaw àràpuhàràn wanehe tapi'ak wanehe a'e pe wà. Weraha uma'e paw kwez a'e pe wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A'e re weraha 5 wyky'yr tuwihawete pe wanexak kar pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Upuranu tuwihawete wanehe. — Ma'e rehe pema'ereko, i'i wanupe. — Tuwihawete, i'i izupe wà. — Àràpuhàràn wanehe uzekaiw ma'e romo uruiko ure, ureipy wazàwegatete ure. ");
INSERT INTO gubBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Uruzur xe ko ywy rehe uruiko pà ta'e Kànàà ywy rehe naheta kwaw ka'api'i urereimaw wanupe xe. Ma'uhez haw a'e pe har uhua'u a'e, iaiw tuwe a'e. Tuwe uruiko xe ywy pehegwer Kozem her ma'e rehe nehe, uremuigo kar pe xe ne, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tuwihawete uze'eg Zuze pe kury. — Neru ur nepyr wiko pà kury. Neryky'yr nezewegatete wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Exak wyzài ywy pehegwer waneko àwàm romo nehe. Upuner Ezit ywy rehe wiko pà wà nehe. Emono ywy pehegwer Kozem her ma'e wanupe nehe. Ywy Ezit ywy rehe har ikatu wera'u ma'e a'e. Tuwe wiko a'e pe wà nehe. Aze upuner wà nehe, tuwe omono'og hereimaw tapi'ak wà nehe no, i'i tuwihawete Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","A'e re Zuze weraha u Zako a'e pe no, tuwihawete pe hexak kar pà no. Zako omono uze'egatu tuwihawete rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tuwihawete upuranu Zako rehe. — Màràn kwarahy erereko, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","— Areko 130 kwarahy ihe kury. Amumaw kwarahy tetea'u heata pà ko rupi, kwe rupi no. Na'arewahy a'e hekwarahy upaw oho iko. Amumaw kwarahy tetea'u zawaiw katu haw rehe hereko pà. Heipy umumaw kwarahy tetea'u wera'u ihewi a'e wà. Waneko awer zawaiw katu hereko haw zàwe a'e wà, i'i Zako tuwihawete pe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Omono uze'egatu tuwihawete rehe. A'e re oho a'e wi izuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Omono Zuze ywy pehegwer ikatu ma'e u pe, wyky'yr wanupe no, uwywyr pe no. A'e ywy ikatuahy a'e. Tawhu Hamexe her ma'e huwake tuz. Ta'e tuwihawete uzapo kar nezewe haw izupe a'e xe. Wiko a'e ywy izar romo wà. Wikuwe a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Omono Zuze temi'u u pe, wyky'yr wanupe no, wànàm wanupe no. Uhyk wanupe pitàitàigatu no. ");
INSERT INTO gubBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Naheta kwaw temi'u amo ae ywy rehe. Uhua'u wera'u ma'uhez taw tuweharupi. Ezit ywy rehe har a'e wà, Kànàà ywy rehe har a'e wà no, iagaiwahy oho waiko wà. Ta'e naheta kwaw temi'u wanupe xe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Teko ume'eg kar temi'u waiko wà. Zuze omono'og hekuzarer temetarer paw tuwihawete hàpuzuhu pe heraha pà a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na'e upaw temetarer Ezit rehe har. Upaw temetarer Kànàà rehe har no. Oho teko Ezit rehe har Zuze pe uze'eg pà wà kury. — Emur temi'u urewe ty. Uremumàno kar zo pe ty. Ta'e upaw ureremetarer urewi kury xe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Uwazar Zuze waze'eg wanupe. — Aze naheta kwaw temetarer peme nehe, perur peneimaw tapi'ak ihewe nehe. Amono putar temi'u peme peneimaw wanekuzaromo ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","A'e rupi Ezit ywy rehe har werur weimaw Zuze pe wà: kawaru wà, àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà, zumen wà. Upaw rupi wanerur izupe wà. Omono Zuze temi'u wanupe waneimaw wanekuzaromo, a'e kwarahy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Upaw a'e kwarahy. Inugwer kwarahy mehe uze'eg wi oho izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","— Upaw ureremetarer. Nurupuner kwaw ipaw pawer imimaw rehe newi. Urereimaw paw oromono newe. Upyta nepo pe upaw rupi wà. Naheta kwaw amo ma'e newe imono pyràm kury. Xo ureretekwer zo, xo ureiwy zo heta we urewe kury. Uremumàno kar zo pe nehe ty. Epyhyk ureiwy tuwihawete pe nehe, uremuigo kar pe tuwihawete pe uma'ereko e ma'e romo nehe. Wiko putar ureiwy izar romo nehe. Emur temi'u urewe ureiwy hekuzaromo ureretekwer wanekuzaromo nehe. Emur temi'u urewe nehe. Nezewe mehe nurumàno kwaw nehe. Emur ma'eà'yz urewe nehe no. Uruzutym putar nehe. Nezewe mehe ywy nuzeapo kwaw ywyxiguhu romo nehe, i'i teko Zuze pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Na'e Zuze ume'eg kar ywy Ezit rehe har upaw rupi a'e kury, tuwihawete pe imono pà a'e kury. Ezit ywy rehe har paw ume'eg uiwy izupe wà, ta'e ima'uhez tuwe a'e wà xe. Nezewe tuwihawete wiko ywy paw izar romo kury. ");
INSERT INTO gubBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Zuze umuigo kar Ezit ywy rehe har paw tuwihawete pe uma'ereko e ma'e romo a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Xo xaxeto waiwy zo nume'eg kar kwaw. Nume'eg kwaw uiwy izupe wà, ta'e tuwihawete omono e amo temi'u wanupe a'e xe. A'e rupi heta temi'u wanupe. A'e rupi numekuzar kar kwaw temi'u uiwy pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Na'e uze'eg Zuze teko wanupe. — Tuwihawete wiko peiwy izar romo kury. Wiko pezar romo no. Ta'e apume'eg kar izupe ihe xe. Pepyhyk ma'eà'yz xe nehe, ko pe izutym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pepo'o putar i'a kwer nehe. Aze pepo'o 5 ma'e, pemono pitài tuwihawete pe nehe. Inugwer 4 ma'e'a upyta putar pepo pe nehe. Pezutym wi amo nehe, pe'u ikurer nehe. Nezewe heta putar temi'u peme nehe, pena'yr wanupe nehe no, pepyr wiko ma'e wanupe nehe no, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Uwazar ize'eg izupe wà. — Ereiko ikatu ma'e romo urewe ne. Urepyro pe uremàno haw wi. Uruiko putar tuwihawete pe uma'ereko e ma'e romo ure nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nezewe Zuze weruzar kar tuwihawete ze'eg teko wanupe. Ate ko 'ar rehe teko weruzar a'e ze'eg wà. Nezewe i'i a'e ze'eg. — Ezit ywy nàn nehe, aze amo opo'o 5 arozràn wà nehe, omono putar pitài tuwihawete pe wà nehe. Xo xaxeto waiwy zo tuwihawete nupyhyk kwaw. ");
INSERT INTO gubBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izaew izuapyapyr a'e wà, upyta Ezit ywy rehe a'e wà, ywy pehegwer Kozem her ma'e rehe wiko pà a'e wà. Ume'eg kar ywy a'e pe wà. Heta tetea'u ta'yr wanupe a'e pe wà. Heta tetea'u tazyr wanupe a'e pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Zako umumaw 17 kwarahy Ezit ywy rehe wiko pà. Umumaw 147 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na'e ukwaw umàno àwàm 'ar ihem etea'i haw kury. Wenoz wa'yr Zuze imuwà uzeupe. — Azapo kar putar ma'e newe. Emono nepo herenugupy iwype kury. Emume'uahy neremiapo ràm ihewe nehe. — Azapo putar heremimume'u azeharomoete ihe nehe, ere ihewe nehe. — Naheremu'em kwaw newe nehe, ere ihewe nehe. Heutym zo pe xe Ezit ywy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Hemàno mehe nehe, eraha heretekwer Ezit ywy wi nehe. Heutym heipy watym awer pe nehe. Tuwe apytu'u wanuwake nehe, i'i Zako wa'yr Zuze pe. — Azapo putar tuwe a'e ma'e nereminozgwer ihe nehe, i'i tuwe Zuze u pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","— Emume'uahy, i'i Zako izupe. Umume'uahy Zuze a'e ma'e iapo pyràm u pe. Na'e Zako uzeàpàrirog uker haw i'aromo. Uze'eg Tupàn pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Amo zahy pawire teko uze'eg oho Zuze pe wà. — Neru ima'eahy, i'i izupe wà. Wexak Zuze u oho. Weraha wa'yr uzeupi wà. Mokoz wà. Eparai, Manaxe waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Amo uze'eg oho Zako pe. — Nera'yr Zuze ur kwez nerexak pà kury, i'i izupe wà. Zako uzeagaw wapyk pà uker haw rehe. Upuner wapykaw rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Uze'eg Zuze pe. — Tupàn upuner wera'u ma'e uzexak kar ihewe Iruz tawhu pe Kànàà ywy rehe a'e. Umur uze'egatu herehe a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Uze'eg nezewe ihewe. — Amueta tetea'u kar putar nera'yr ihe wà nehe. Heta tetea'u putar nezuapyapyr a'e wà nehe no. Wiko putar teko ikàg ma'e romo wà nehe. Amono putar ko ywy nezuapyapyr wanupe nehe. Wiko putar izar romo tuweharupi wà nehe, i'i ihewe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nera'yr Eparai a'e, nera'yr Manaxe a'e no, uzexak kar xe Ezit ywy rehe xe hezur 'ym mehe we a'e wà. Hepurumuzàg romo wanekon a'e wà. Humen a'e, Ximeàw a'e no, hepurumuzàg romo wanekon a'e wà no. Nezewegatete Eparai Manaxe rehe wà no. Heremiminoete romo hera'yr zàwenugar romo wanekon a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Aze heta amo nera'yr newe wà nehe, wiko putar nezuapyr romo wà nehe. Wiko putar Eparai tywyr romo Manaxe tywyr romo wà nehe. A'e rupi upyhyk putar ywy pehegwer uwyky'yr wazàwe a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ta'e nehy Hakew umàno mokoz umemyr wazexak kar ire a'e xe. Na'imemyr wi kwaw. Mezopotàm ywy wi urezewyr mehe umàno a'e, Kànàà ywy rehe a'e, Eparat tawhu pe urehem etea'i mehe a'e. Azutym hetekwer a'e pe ihe, pe iwyr ihe, i'i izupe. (Ko 'ar rehe, — Merez, i'i teko Ewparat tawhu pe wà kury.) ");
INSERT INTO gubBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Wexak Zako Zuze ta'yr a'e wà kury. Upuranu hehe. — Mo romo wiko kwez kwàkwàmo a'e wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","— Hera'yr Ezit ywy rehe ihewe Tupàn hemimur karer romo wanekon a'e wà, i'i Zuze u pe. — Emunyryk xe heruwake ne wà kury, ta'e heporomono wer heze'egatu rehe wanehe ihe xe, i'i Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Itua'uhez tuwe Zako, a'e rupi nahehàpyhàgatu kwaw. Heha na'ikatu kwaw. Weraha Zuze a'e mokoz kwàkwàmo u huwakea'i wà kury. Zako uzàzuwàn wà, wazurupyter pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I'i Zako Zuze pe. — Naexak wi kwaw hera'yr Zuze ihe nehe, a'e hezeupe. Nezewe rehe we uruexak kwez ihe. Te nera'yr aexak kutàri ihe wà no, i'i Zako wa'yr pe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Na'e Zuze umunyryk kar wa'yr u henugupy wi wà. Wapyk upenàràg rehe, uwa imuhyk pà ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","A'e re upyhyk Zuze Eparai opo awyze har pupe. Upyhyk Manaxe opo ahurehe har pupe. Umupu'àm Zako huwakea'i wà. Nezewe Eparai upyta Zako iahur rehe. Manaxe upyta iawyze har rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Upir Zako uzywa imuzepynykwaw pà kury. Omono opo awyze har Eparai iàkàg rehe. Omono opo ahurehe har Manaxe iàkàg rehe. Eparai Manaxe tywyr romo hekon a'e. Nezewe rehe we wiko tyky'yr zàwe Zako ipo iwype kury. Manaxe wiko tyky'yr romo a'e. Wiko tywyr zàwe Zako ipo ahurehe har iwype kury. ");
INSERT INTO gubBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A'e re omono Zako uze'egatu Zuze rehe kury, Tupàn pe uze'eg pà kury. O Tupàn, heipy Àmàrààw a'e, Izak a'e no, weruzar neze'eg oho waiko a'e wà. Ezapo ikatuahy ma'e ko kwàkwàmo wanupe nehe. Emono neze'egatu wanehe nehe, ta'e erezekaiw katu herehe àràpuhàràn ài ne xe, herekuwe mehe tuweharupi te ko 'ar rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Amo nereko haw pe har hepyro ikatu 'ymaw paw wi a'e. A'e ae nehe, tuwe uzapo ikatu ma'e wanupe nehe no. Tuwe hezuapyapyr umume'u herer uzeupeupe wà nehe. Tuwe ima'enukwaw heràmuz Àmàrààw her rehe wà nehe. Tuwe ima'enukwaw heru Izak her rehe wà nehe no. Tuwe heta tetea'u wana'yr wanupe wà nehe. Tuwe heta tetea'u wazuapyapyr wanupe wà nehe no, i'i Zako Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Zuze wexak u ipo awyze har Eparai àkàg rehe imono awer. Na'ikatu kwaw izupe. A'e rupi upyhyk ipo kury, Eparai àkàg wi imunyryk kar pà kury, Manaxe iàkàg rehe imono pà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Uze'eg u pe. — Nan kwaw nezewe, Papaz. Ko hera'yr a'e, tyky'yr romo hekon a'e. Emono nepo awyze har iàkàg rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Zako na'iporomono wer kwaw hehe. — Akwaw heremiapo ty, hera'yr. Manaxe izuapyapyr wiko putar teko tetea'u ikàg ma'e romo a'e wà nehe. Nezewe rehe we tywyr wiko wera'u putar izuwi nehe. Izuapyapyr uzemuza'aza'ak putar teko tetea'u romo wiko pà a'e wà nehe, i'i Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nezewe Zako omono uze'egatu wanehe a'e 'ar mehe. — Ihe Izaew ihe, hezuapyapyr a'e wà nehe no, uze'egatu imume'u mehe umume'u putar nera'yr waner a'e wà nehe. — Tupàn uzapo ikatuahy ma'e Eparai pe a'e, Manaxe pe a'e. Tuwe uzapo ikatuahy ma'e newe nezewegatete a'e nehe no, i'i putar amo wanupe uze'egatu imono pà wà nehe, i'i Zako. ");
INSERT INTO gubBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","— Erexak hekàg 'ymaw. Amàno etea'i kury. Tupàn wiko putar penehe we a'e nehe, peneraha pà peipy waiwy pe a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Amono Xikez ywy newe kury. Namono kwaw neryky'yr wanupe, ni nerywyr pe. Kwehe mehe apyro Xikez ywy Amohe ywy rehe har wanuwi ihe. Azàmàtyry'ym hetakihe puku pupe ihe wà, heywyrapar pupe ihe wà, a'e ywy pehegwer ipyro pà wanuwi ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Wenoz Zako wa'yr uzeupe wà, wanupe uze'eg pà wà. — Peiko xe heiwyra'i nehe ty wà. Amume'u putar peneko àwàm peme ihe nehe, ma'e peme uzeapo ma'e ràm imume'u pà ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ihe Zako ihe, pe hera'yr romo peiko pe. Pezemono'og heruwake heze'eg henu pà nehe. Pezeapyaka katu penu Izaew ze'eg rehe nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ne Humen ne. Hera'yr itua'u wera'u ma'e romo ereiko ne. Hekàgaw romo ereiko. Hekàgaw ta'yr ipy romo ereiko. Ereiko wera'u amogwer hera'yr wanuwi, nekàg wera'u amogwer hera'yr wanuwi. ");
INSERT INTO gubBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nerehaite ykotok ài. Nezewe rehe we nereiko kwaw amogwer wanuwihawete romo nehe. Ta'e ereker heremirekoagaw puhe ne xe. Maranugar haw ererur neru ker haw pe nezewe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ximeàw wiko Erewi tyky'yr romo a'e. Erewi wiko Ximeàw tywyr romo a'e. Uzàmàtyry'ym teko upuruzuka haw pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Naiko kwaw wapyr iaiw ma'e iapo àwàm rehe waze'eg mehe ihe nehe. Naiko kwaw wanehe we wazemono'og mehe nehe. Ta'e wehaite haw rupi uzuka awa a'e wà xe. Ta'e uzemaraz tapi'ak wanehe wamupàri kar pà a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Amono heze'egaiw wanehaite haw rehe. Ta'e ipuruzukaiwahy a'e wà xe. Amono heze'egaiw wakwahy haw rehe. Ta'e upuraraw kar ma'erahy tetea'u purupe a'e wà xe, ma'ea'yr wanupe a'e wà no xe. Amuza'aza'ak putar wazuapyapyr Izaew ywy rehe ihe wà nehe. Amuhàmuhàz putar wazuapyapyr waànàm wainuromo wamono kar pà ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ne Zuta ne ty. Neryky'yr a'e wà nehe, nerywyr a'e wà nehe no, nemuawate katu putar a'e wà nehe. Uzemumew putar nerenataromo wà nehe. Erepyhyk putar neàmàtyry'ymar wazu'yw rehe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Hera'yr Zuta a'e, nuzawy kwaw zàwàruhua'yr miar izuka mehe har a'e. Uzeamumew u'aw pà zàwàruhu awa ài, zàwàruhu kuzà ài. Aipo amo nukyze kwaw izuwi wà nehe, aipo amo uputupyk putar oho wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Zuta upyhyk putar ywyra'i tuwihawete romo weko haw hexak kar haw a'e nehe. Izuapyapyr wiko putar tuwihawete romo tuweharupi wà nehe. Teko amo ae ywy rehe har werur putar imur pyràm izupe wà nehe. Weruzar putar ize'eg a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Uzàpixi putar weimaw zumena'yr uwà 'yw rehe a'e nehe, uwà 'yw ikatu wera'u ma'e rehe a'e nehe. Uhez ukamir win pupe. Uhez ukamirpuku win ma'eruwy kwer hexakaw hereko har pupe. q1 ");
INSERT INTO gubBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Heha ipiràg a'e, ta'e u'u win tetea'u a'e xe. Hàz ixigatu a'e, ta'e u'u tapi'ak kamykwer tetea'u a'e no xe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zemurom wiko putar yryhu iwyr a'e nehe. Heta putar kanuhu pytu'u haw a'e pe nehe. Iziwy oho putar te Xitom tawhu pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ixakar nuzawy kwaw zumen ikàg ma'e ukupe pe àràm inuromo wemiraha ràm inuromo uzeàpàrirog ma'e. ");
INSERT INTO gubBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ywy ikatu haw wexak a'e. — Ko ywy ikatuahy hepytu'u àwàm romo, i'i uzeupe. A'e rupi uzemumew, wemiraha ràm imur kar pà ukupe pe. Numume'u kwaw wemipuraraw. Uma'ereko uma'ereko e ma'e ài. ");
INSERT INTO gubBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Nà wiko putar uzuapyapyr wanuwihaw romo a'e nehe. Wiko putar amogwer Izaew ta'yr wazuapyapyr wazàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Wiko putar moz ài nehe, moz pe iwyr uzeàmim ma'e ài nehe, mozaiw puruzuka ma'e pe rupi wiko ma'e ài nehe. Uxi'u kawaru ipy rehe, ikupe pe har haikwerupi ywy rehe imu'ar kar pà. ");
INSERT INTO gubBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Tupàn Tuweharupi Wiko Ma'e, hepyro pe nehe. Àro hepyro àwàm iteko. ");
INSERT INTO gubBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kaz a'e nehe kury. Amo ma'e rehe imunar ma'e uzàmàtyry'ym putar Kaz a'e wà nehe. A'e re oho putar wanaikweromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Azer ywy umuezuz katu putar temi'u tetea'u a'e nehe. Xo temi'u ikatuahy ma'e zo tuwihawete u'u a'e wà. Azer ywy umuezuz putar agwer temi'u a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napitari a'e, arapuha kazer her ma'e iàpixi pyr 'ym ài hekon a'e. Memyr ipuràg eteahy ma'e hereko har ài a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Zuze wiko ma'e'yw ytyzuzàmaw huwake izutym pyrer ài a'e. I'a katu. Hàkàgwer uzeupir pari rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Iàmàtyry'ymar uzàmàtyry'ym tuwe oho a'e wà. Uzàn haikweromo u'yw heraha pà uwyrapar heraha pà wà. ");
INSERT INTO gubBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nezewe rehe we ywyrapar ikàg a'e. Izywa ikàg wiwi no. Ta'e Tupàn ikàg ma'e Zako izar umukàg kar a'e xe. Tupàn àràpuhàràn mono'ogar zàwenugar a'e, itahu Izaew wapyro har zàwenugar a'e, umukàg kar putar a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tupàn Zuze tu izar a'e nehe, upytywà putar Zuze a'e nehe. Ma'e paw iapo har ikàg wera'u ma'e a'e nehe, omono putar uze'egatu hehe a'e nehe. Umur putar uze'egatu ywak rehe har nehe. Umur putar uze'egatu 'y ywy wy pe har nehe no. Umur putar ma'ea'yr tetea'u izupe heimaw romo wà nehe. Umur putar ta'yr tetea'u izupe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Umuezuz putar temi'u tetea'u izupe nehe, umuezuz putar ma'eputyr tetea'u izupe nehe no. Umur putar uze'egatu ywytyr kwehe arer rehe nehe, umur putar temi'u hete katu ma'e ywytyr tuweharupi har wi nehe no. Tuwe a'e ze'egatu paw tuz Zuze iàkàg rehe nehe, ta'e Tupàn wexaexak wera'u Zuze a'e xe, tyky'yr wanuwi a'e xe. Omono uze'egatu hehàpykàg rehe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Mezàmi nuzawy kwaw awarahu hehaite ma'e a'e. Ku'em mehe u'u wemizuka kwer. Karuk mehe umuza'aza'ak wemipyhyk kwer, i'i Zako wa'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nezewe Zako umume'u Izaew izuapyapyr waneko haw wà. Heta 12 ta'yr wà. Heta wazuapyapyr wanupe pitàitàigatu wà no. Umume'u a'e ze'eg wa'yr wanupe, uze'egatu imono mehe wanehe. Umume'u uze'egatu ikatuahy ma'e wanupe pitàitàigatu. ");
INSERT INTO gubBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Na'e Zako uzapo kar wemimutar wa'yr wanupe kury. — Amàno etea'i ihe kury. Aha putar teko heànàm wapyr umàno ma'e kwer wapyta haw pe ihe nehe. Heutym pe heipy watym awer pupe itakwaruhu pupe nehe ty wà. Kwehe mehe teko uzutym heipy Eperom Etew izuapyapyr ywy rehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kànàà ywy rehe tuz, Manire tawhu huwake. Itakwaruhu pupe uzutym wà. Kwehe mehe Àmàrààw ume'eg kar a'e itakwaruhu a'e. Ume'eg kar a'e ywy pehegwer a'e no, wànàm wazutym àwàm romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Utym Àmàrààw hetekwer a'e pe wà. Utym hemireko Xar hetekwer a'e pe wà no. Utym Izak a'e pe wà, hemireko rehe we wà. Azutym heremireko Erez a'e pe ihe no. ");
INSERT INTO gubBl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Etew izuapyapyr ume'eg a'e itakwaruhu Àmàrààw pe wà. Ume'eg a'e ywy pehegwer izupe wà no, i'i Zako wa'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wemiapo putar haw wa'yr wanupe imume'u re uzeàpàrirog wi Zako uker haw rehe umàno pà kury. Hekwe oho wànàm wapyr teko umàno ma'e kwer wapyta haw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Uzemomor Zuze u hetekwer rehe kury. Uzai'o. Uzurupyter huwa. ");
INSERT INTO gubBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Na'e uze'eg wemiruze'eg muhàg kwaw par wanupe. — Pemuàgà'ym hetekwer muhàg tetea'u pupe nehe, imunem kar 'ym pà nezewe nehe, iwàiwàn pà pàn tetea'u pupe nehe, i'i wanupe. Weruzar ize'eg wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Umumaw 40 'ar hetekwer umàno ma'e kwer imuàgà'ym pà wà, ta'e tuweharupi teko umumaw 40 'ar a'e ma'e iapo mehe a'e wà xe. Ezit ywy rehe umumaw 70 'ar uzai'o pà hehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hehe wazai'o haw 'ar imumaw ire uze'eg Zuze oho tuwihaw tuwihawete hàpuzuhu pe uzemono'og ma'e wanupe a'e kury. — Peho tuwihawete henataromo nehe, ko ma'e imume'u pà izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Heru imàno etea'i mehe umume'uahy kar ma'e heremiapo ràm ihewe a'e. — Kwehe mehe azapo heutym àwàm hezeupe ihe, Kànàà ywy rehe ihe, i'i ihewe. — Ezutym heretekwer a'e pe nehe, a'e newe kury, i'i ihewe. — A'e rupi ainoz ma'e newe kury, tuwihawete. Tuwe azutym heru hetekwer heraha a'e pe nehe. Izutym pawire azewyr putar xe ihe nehe, peze tuwihawete pe nehe, i'i Zuze a'e tuwihaw wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","(Werur kar tuwihawete Zuze uwa rupi kury.) — Eho izutym pà nehe ty, ta'e umume'uahy kar utym àwàm newe a'e xe, i'i tuwihawete Zuze pe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","A'e rupi Zuze weraha u hetekwer izutym pà Kànàà ywy rehe a'e kury. Tuwihaw tuwihawete hàpuz rehe uzemono'og ma'e oho hupi a'e wà no. Ezit ywy rehe har wanuwihaw paw oho hupi a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Zuze iànàm oho hupi a'e wà no. Tyky'yr iànàm oho hupi a'e wà no. Zako ta'yr waànàm oho hupi a'e wà no. Wezar kwarearer kuzàtàigwer Kozem ywy rehe wà. Wezar ma'ea'yr wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Awa kawaru ku'az har oho Zuze rupi wà no. Awa ywyramawa rehe wata ma'e oho Zuze rupi wà no. A'e rupi hupi oho ma'e heta tetea'u wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Uhem Ataz tawhu pe wà kury. Zotàw yrykaw huwake kwarahy ihemaw kutyr tuz. Uzemono'og upaw rupi amo ywy pehegwer arozràn izykyz taw rehe wà, purutymaw rehe zegar haw iapo pà a'e pe wà. Umumaw 7 'ar a'e pe wazai'oahy tetea'u pà hehe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na'e Kànàà ywy rehe har wexak a'e teko tetea'u wà wazai'o mehe a'e wà kury. Wanexak mehe i'i uzeupeupe wà. — Azeharomoete uzemumikahy a'e wà, ta'e uzai'oahy tetea'u waiko a'e wà xe, i'i uzeupeupe wà. A'e rupi omono Apew-Mixiraim her romo a'e ywy pehegwer rehe wà. (-Ezit ywy rehe har wazai'o haw, i'i her zaneze'eg rupi.) ");
INSERT INTO gubBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nezewe Zako ta'yr weruzar u ze'eg awer paw a'e wà, hemimutar iapo pà a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Weraha hetekwer Kànàà pe wà. Uzutym itakwaruhu Makepera her ma'e pupe wà. Manire tawhu huwake kwarahy ihemaw kutyr tuz. Kwehe mehe Àmàrààw ume'eg kar a'e ywy pehegwer a'e, Eperom Etew izuapyr wi a'e, wànàm wazutym àwàm romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Itym pawire uzewyr Zuze Ezit ywy rehe wyky'yr uwywyr wanupi kury, hupi wata ma'e paw wanupi kury. ");
INSERT INTO gubBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","U imàno re Zuze tyky'yr a'e wà, uze'eg uzeupeupe wà. — Aze ru'u Zuze na'iakatuwawahy kwaw zanerehe. Aze ru'u uzepyk putar zanerehe zaneremiapo kwer kwehe arer nànàn a'e nehe kury, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","A'e rupi omono kar amo Zuze pe ma'e imume'u kar pà izupe wà. — Neru imàno 'ym mehe we uze'eg nezewe urewe a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","— Nereharaz tuwe neryky'yr wanemiapo kwer wi nehe, nereharaz tuwe wazaiw paw wi nehe, nereharaz tuwe ma'erahy kwer newe wanemipuraraw karer wi nehe, i'i newe a'e. A'e rupi uruenoz ko ma'e newe ure kury. — Nereharaz tuwe ureaiw paw wi nehe, ta'e uruiko Tupàn neru izar hemiruze'eg romo ure xe, i'i izupe wà, uze'eg imume'u kar pà amo pe wà. Waze'eg awer henu mehe uzai'o Zuze kury. ");
INSERT INTO gubBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Na'e tyky'yr a'e ae ur izupe wà kury. Uzemumew henataromo wà, izupe uze'eg pà wà. — Uruiko xe ure. Newe uma'ereko ma'e romo, neremiruze'eg romo uruiko ure. ");
INSERT INTO gubBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Uze'eg Zuze wanupe. — Pekyze zo ihewi nehe ty wà. Napuner pixik kwaw Tupàn hekuzaromo hereko haw rehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Azeharomoete pemume'u iaiw ma'e ihewe penemiapo ràm kwehe mehe. Tupàn uzapo iaiw ma'e ikatu ma'e romo a'e. A'e rupi ko 'ar rehe upyro teko tetea'u iko wamàno haw wi a'e wà kury, a'e iaiw ma'e kwehe arer rupi a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pekyze zo nehe. Azekaiw katu putar penehe nehe, pena'yr wanehe nehe no, i'i Zuze wyky'yr wanupe. Nezewe umupytu'u kar ma'e wi wakyze re a'e wà. — Azeharomoete zaneamutar katu iko a'e, i'i uzeupe upy'a pe wà. ");
INSERT INTO gubBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Upyta Zuze Ezit ywy rehe wiko pà a'e, u iànàm wanehe we a'e. Umumaw 110 kwarahy umàno 'ym mehe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ate Eparai hemimino uzexak kar izupe imàno 'ym mehe we a'e wà. Upyhyk wemimino Makir ta'yr u'uwaromo wamuapyk pà wà, umàno 'ym mehe we wà. Makir wiko Manaxe ta'yr romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Amo 'ar mehe uze'eg Zuze wyky'yr wanupe. — Amàno putar tàrityka'i ihe nehe kury. Akwaw ko ma'e uzeapo ma'e ràm ihe. Tupàn ur putar ko ywy rehe pepytywà pà a'e nehe. Kwehe mehe umume'u amo ywy Àmàrààw pe, Izak pe no, Zako pe no. Peneraha putar a'e ywy rehe a'e nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","— Pemume'uahy ko ma'e penemiapo ràm ihewe nehe ty wà, i'i wanupe. — Azeharomoete Tupàn ur putar pepytywà pà nehe. A'e 'ar mehe nehe, peraha heretekwer penupi nehe, a'e ywy rehe peho mehe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Wereko Zuze 110 kwarahy umàno mehe. Uwàuwàn hetekwer pàn tetea'u pupe muhàg tetea'u inuromo wà, hyru pupe imonokatu pà wà, Ezit ywy rehe imupyta kar pà wà. Upaw. ");
INSERT INTO gubBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Kwehe mehe Zako oho Ezit ywy rehe a'e. Ta'yr oho hupi a'e wà no, wànàm waneraha pà pitàitàigatu a'e wà no. Na'aw ta'yr waner xe wà: ");
INSERT INTO gubBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Humen, Ximeàw, Erewi, Zuta, ");
INSERT INTO gubBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ixakar, Zemurom, Mezàmi, ");
INSERT INTO gubBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Nà, Napitari, Kaz, Azer. ");
INSERT INTO gubBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Zako ta'yr a'e wà, wapurumuzàmuzàg a'e wà no, 70 romo waneta haw a'e 'ar mehe a'e wà. Ta'yr inugwer Zuze her ma'e a'e, wiko tuwe Ezit ywy rehe wahem mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kwarahy tetea'u imumaw ire Zuze umàno a'e. Tyky'yr tywyr paw umàno a'e wà no. Hekuwe mehe wikuwe ma'e paw umàno a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Zako izuapyapyr a'e wà, Izaew izuapyapyr her inugwer ma'e a'e wà, upurumuzàmuzàg tetea'u a'e wà. Heta tetea'u wà kury. Ikàg a'e wà kury. Uhàuhàz Ezit ywy nànàn wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Amo kwarahy mehe amo ae awa wiko Ezit ywy rehe har wanuwihawete romo a'e kury. A'e tuwihawete nukwaw pixik kwaw Zuze heko awer a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","A'e rupi uze'eg nezewe wemiruze'eg wanupe teko wanupe kury. — Peinu katu heze'eg nehe ty wà, i'i wanupe. — Izaew izuapyapyr ikàg tuwe a'e wà, heta tetea'u a'e wà no. Heta wera'u waiko zanewi wà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","— Aze amo ae ywy rehe har zaneàmàtyry'ym wà a'e wà nehe, Izaew izuapyapyr upuner uzemono'ogaw rehe zaneàmàtyry'ymar wanehe a'e wà nehe. Upuner zaneàmàtyry'ymaw rehe wà nehe, zaneiwy wi uhemaw rehe wà nehe. A'e rupi xikar amo ma'e iapo pyràm zane nehe kury. Ximupytu'u kar heta tetea'u wera'u ma'e romo waneko re zane nehe kury, i'i wanuwihawete Ezit ywy rehe har wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","A'e rupi Ezit ywy rehe har omono kar tuwihaw Izaew izuapyapyr wapyr a'e wà kury. Uzapo kar ma'ereko haw ipuhuz katu ma'e wanupe wà. Upuraraw kar ma'erahy wanupe nezewe wà. Izaew izuapyapyr uzapo mokoz tawhu Ezit ywy rehe har wanupe wà. Pitom, Hamexe tawhu waner romo wà. Tuwihawete uzapo kar arozràn imono'ogaw a'e tawhu pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nuzeapo kwaw ma'e Ezit ywy rehe har wanemimutar rupi. Ma'erahy ipuraraw mehe Izaew izuapyapyr heta tetea'u wera'u wà. Aze upuraraw kar ma'erahy wanupe wà, upurumuzàmuzàg wi wi tuwe wà. A'e rupi Ezit rehe har ukyze wanuwi wà. — Ikàg wera'u putar zanewi a'e wà nehe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Umuigo kar uma'ereko e ma'e romo wà kury. Upetepetek wà, wamuahy kar pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","A'e rupi umuaiw kar waneko haw wanupe wà. Uzapo kar ywytàtà tetea'u wanupe wà. Uzapo kar tàpuz tetea'u wanupe wà. Uzapo kar ko ma'etymaw tetea'u wanupe wà no. Wyzài ma'ereko haw iapo kar mehe umuahy kar wà, ma'erahy ipuraraw kar pà wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Heta mokoz kuzà a'e pe wà. Izaew izuapyapyr kuzà wapytywà har romo wanekon wamemyr izexak kar mehe wà. Xipira, Pua a'e kuzà waner romo wà. Amo 'ar mehe Ezit ywy rehe har wanuwihawete uze'eg wanupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","— Kuzà Izaew izuapyapyr wapytywà mehe nehe, wamemyr wazexak kar mehe nehe, aze uzexak kar awa nehe, pezuka a'e imemyr nehe. Aze uzexak kar kuzà nehe, tuwe wikuwe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kuzà wapytywà har umuwete katu Tupàn izuwi ukyze pà wà. A'e rupi nuweruzar kwaw uwihawete ze'eg wà. Nuzuka kwaw kwarer wà. Umuikuwe kar wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","A'e rupi amo 'ar mehe tuwihawete wenoz a'e kuzà uzeupe wà kury. Upuranu wanehe. — Màràzàwe tuwe naperuzar kwaw heze'eg peiko. Màràzàwe tuwe pemuikuwe kar kwarer pe wà, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","— Kuzà Izaew izuapyapyr a'e wà, nuiko kwaw kuzà Ezit ywy rehe har wazàwe a'e wà. Nazawaiw kwaw wamemyr wazexak kar haw wahy wanupe. A'e rupi wamemyr uzexak kar urehem 'ym mehe we wà, i'i mua'u izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","A'e kuzà ukyze Tupàn wi wà, a'e rupi Tupàn ikatuahy wanupe a'e no. Umumemyr kar a'e wà no. Izaew heta tetea'u wera'u wi wi a'e wà. Heta tetea'u a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Waneta haw na'ikatu kwaw tuwihawete pe. A'e rupi umume'uahy ko wemimutar teko wanupe a'e kury. — Izaew izuapyapyr wamemyr awa ko 'ar rehe uzexak kar ma'e paw wà nehe, pemomor yrykawhu Niru her ma'e pupe pe wà nehe. Wamemyr kuzà pemuikuwe kar pe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Amo awa Erewi izuapyapyr wereko amo kuzà Erewi izuapyapyr wemireko romo amo 'ar mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Na'e ipuru'a a'e kuzà. Uzexak kar imemyr awa. — Ipuràg eteahy hememyr, i'i uzeupe. A'e rupi umim umemyr zauxiapekwer wanuwi. Umumaw na'iruz zahy imim pà. ");
INSERT INTO gubBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Zawaiw katu imimaw izupe. A'e rupi upupepupe ka'api'ipopok kok romo iapo pà. Uwàpytym kok ikwaikwar iraity zàwenugar pupe 'y wi. Omono kwarer kok pupe kury. Wezar kok yrykawhu iwyr ka'api'ipopok wamyter pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kwarera'i heinyr upyta pe pe hehe ume'e pà. Namuite kwaw. — Ma'e uzeapo putar izupe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Amo 'ar mehe Ezit ywy rehe har wanuwihawete tazyr oho yrykawhu pe uzahak pà a'e kury. Izupe uma'ereko ma'e uzekytyar waiko yrykawhu iwyr izahak mehe wà. Na'arewahy tuwihawete tazyr wexak a'e kok ka'api'ipopok wamyter pe hin mehe kury. — Eho ipiaromo kyn wà, i'i amo uma'ereko e ma'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Uwàpytymawok tuwihawete tazyr kok kury. Wexak kwarera'i izai'o mehe kok pupe. Upuhareko katu. — Kwarer Izaew izuapyapyr romo a'e, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na'e kwarera'i heinyr upuranu tuwihawete tazyr rehe kury. — Aze ereputar amo kuzà Izaew izuapyr nehe, aha putar ipiaromo newe ihe nehe. A'e rupi upuner kwarera'i imukamu haw rehe imugakwaw paw rehe newe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","— Eho kyn, i'i izupe. A'e rupi kuzàtài oho kwarer ihyete herur pà izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Na'e tuwihawete tazyr uze'eg a'e kuzà pe. — Eraha ko kwarera'i nereko haw pe nehe, emugakwaw ihewe nehe. Amekuzar putar nema'ereko àwàm newe nehe, i'i izupe. Weraha a'e kuzà umemyr kwarer a'e. Umugakwaw izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Itua'u kury. Amo 'ar mehe weraha kuzà kwàkwàmo tuwihawete tazyr pe. Tuwihawete tazyr umuigo kar kwàkwàmo umemyragaw romo. — Apyro 'y wi ihe, i'i izupe. A'e rupi omono Moizez her romo. — Apyro, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kwarahy tetea'u pawire Moizez awa romo heko mehe uhem oho tuwihawete hàpuzuhu wi wànàmete wanexak pà amo 'ar mehe a'e kury. Ezit ywy rehe har uzapo kar ma'ereko haw ipuhuz katu ma'e hereko Izaew wanupe wà. Wexak Moizez wama'erekoahy haw. Amo awa Ezit ywy rehe har upetek amo Izaew izuapyr hereko a'e, amo Moizez iànàm a'e. Wexak Moizez ipetek mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ume'e Moizez ko rupi, ume'e kwe rupi. Naheta kwaw amo teko a'e pe wà. Na'e uzuka Moizez a'e Ezit ywy rehe har kury, hetekwer iàmim pà itym pà ywyxig pupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Iku'egwer pe uzewyr wi a'e pe. Wexak mokoz awa wà, Izaew izuapyapyr wà, wazeàmàtyry'ym mehe wà. Amo ukwaukwar iko inugwer rehe. A'e rupi Moizez upuranu hehe. — Màràzàwe tuwe erekwarekwar iko neànàm rehe ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A'e awa uze'eg Moizez pe kury. — Mo nemuigo kar ureruwihaw romo a'e, mo nemuigo kar urereruze'egar romo a'e, i'i izupe. — Aipo nepuruzuka wer herehe a'e Ezit ywy rehe har neremizuka kwer ài ne, i'i izupe. Na'e Moizez ukyze katu kury. — Ukwaw heremiapo kwer a'e wà, ukwaw awa izuka awer a'e wà, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Teko umume'u Moizez hemiapo kwer oho tuwihawete pe wà. A'e rupi ipuruzuka wer Moizez rehe. Uzàn Moizez oho Minià ywy rehe. Wiko oho a'e ywy rehe. Heta amo awa Zetoro her ma'e Minià ywy rehe a'e. Xaxeto romo hekon a'e. Heta 7 tazyr izupe wà. Amo 'ar mehe Moizez wapyk in amo 'yzygwar huwake kury. A'e 7 kuzà ur a'e pe 'y henuhem pà yzygwar wi wà. Heta àràpuhàràn hawitu ma'e wanu pe wà, heta àràpuhàrànete izupe wà no. Tazyr umynehem wai'u haw u heimaw wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Na'e uhem amo ae àràpuhàràn mono'ogar a'e pe wà no. Awa a'e wà. Umuzàn kar àràpuhàràn mono'ogar a'e kuzà a'e wi a'e wà. Wexak Moizez a'e ma'e izeapo mehe. A'e rupi upu'àm Moizez oho kuzà wapytywà pà a'e, a'e awa wanuwi wapyro pà a'e. Umuzàn kar Moizez a'e àràpuhàràn mono'ogar wà kury. A'e re omono 'y kuzà waneimaw wanupe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","A'e re uzewyr kuzà u heko haw pe wà. Uhem kwarahy heixe 'ym mehe we wà. A'e rupi wanu upuranu wanehe. — Màràzàwe tuwe pezewyr kwarahy heixe 'ym mehe we kutàri, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","— Amo Ezit ywy rehe har urepyro àràpuhàràn mono'ogar wanuwi a'e. A'e re wenuhem 'y 'yzygwar wi urewe imur pà. Umur 'y zanereimaw wanupe a'e no, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","— Ma'e pe hekon, i'i wanu wazyr wanupe. — Màràzàwe tuwe pezar a'e awa a'e pe 'yzygwar pe. Peho henoz tà nehe kury. Umai'u putar zanepyr nehe, i'i wanupe. Weruzar ize'eg oho wà. ");
INSERT INTO gubBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Umumaw Moizez amo 'ar a'e pe wiko pà. Amo 'ar mehe Zetoro uze'eg wà izupe. — Epyta xe nehe ty, nereko àwàm iapo pà xe urepyr nehe ty, i'i Moizez pe. — Ikatu, apyta putar xe nehe, i'i Moizez izupe. A'e rupi Zetoro omono wazyr izupe hemireko romo. Zipora her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Imemyr mehe Moizez omono Zeroxon her romo. — Aiko amo ae ywy rehe har wapyr wiko ma'e romo ihe, i'i Moizez. — Amo ae ywy rehe har wapyr wiko ma'e, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Amo kwarahy pawire Ezit ywy rehe har wanuwihawete umàno. Izaew izuapyapyr uzai'o wi wi waiko uma'erekoahy e haw rehe wà. — Urepytywà pe nehe, i'i uhapukaz pà wà. Wenu Tupàn wanehapukaz tawer. ");
INSERT INTO gubBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Wenu wazai'o mehe wà. Ima'enukwaw uze'eg kwehe arer Àmàrààw pe Izak pe Zako pe wemimume'u kwer rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Wexak Izaew izuapyapyr wama'ereko e haw. — Azeharomoete upuraraw ma'erahy waiko wà. Azapo putar ma'e wapyro pà ihe nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","A'e 'ar rehe Moizez uzekaiw iko watyw Zetoro heimaw wanehe, ta'e heta àràpuhàràn hawitu ma'e izupe wà xe, heta àràpuhàrànete izupe wà no. Xaxeto Minià ywy rehe har romo hekon a'e. Amo 'ar mehe weraha Moizez heimaw paw ywyxiguhu ikupe kutyr a'e wà kury. Uhem oho ywytyr Xinaz her ma'e pe. Ywytyr Tupàn pe imono e katu pyrer a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","A'e pe amo Tupàn heko haw pe har uzexak kar Moizez pe tata romo ka'akyr myteromo a'e. Heta tata ka'a rehe. Nezewe rehe we nukaz paw kwaw. Wexak Moizez ikaz 'ymaw. ");
INSERT INTO gubBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","— Màràzàwe tuwe. Naexak pixik kwaw agwer ma'e ihe, i'i uzeupe. — Màràzàwe tuwe nukaz paw kwaw ka'a. Ahem putar huwakea'i hexak pà nehe, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tupàn Tuweharupi Wiko Ma'e wexak Moizez tata huwake ihem mehe a'e. Ta'e Moizez ime'egatu wer ka'akyr rehe a'e xe. A'e rupi uze'eg izupe ka'a myter wi kury. — Moizez, Moizez, i'i izupe. — Aiko xe ihe, i'i Moizez izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","— Ehem zo ezuwà heruwake kury, i'i Tupàn izupe. — Enuhem nexapat nehe, ta'e 'aw ywy nepu'àmaw a'e xe, ihewe imonokatu pyrer romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Aiko neipy wazar romo ihe, Àmàrààw izar romo ihe, Izak izar romo ihe no, Zako izar romo ihe no, i'i izupe. A'e re Moizez upyk uwa a'e kury, ta'e ukyze Tupàn wi a'e xe. Ukyze hehe ume'e haw wi a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Uze'eg Tupàn Tuweharupi Wiko Ma'e izupe. — Aexak teko heremiaihu Ezit ywy rehe wiko ma'e ihe wà. Upuraraw ma'erahy waiko a'e wà. Tuweharupi uhapukaz uzai'o pà, ta'e wamuma'ereko kar har upetepetek a'e wà xe. Aenu wanehapukaz mehe ihe wà. Azeharomoete azemumikahy ta'e upuraraw ma'erahy waiko a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","A'e rupi aizyw ihe kury, Ezit ywy rehe har wi wapyro pà ihe kury, a'e ywy wi amo ae ywy ikatu ma'e pe waneraha pà ihe kury. Heta putar ywy tetea'u a'e pe wanupe nehe. Heta tetea'u putar temi'u a'e pe wanupe nehe. Amo ae teko wiko a'e ywy rehe ko 'ar rehe wà: Kànàà izuapyapyr wà, Ete izuapyapyr wà, Amohe ywy rehe har wà, Perize izuapyapyr wà, Ewe izuapyapyr wà, Zepu izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ko 'ar rehe ainu Izaew izuapyapyr wazai'o mehe ihe wà kury. Aenu wanereko ihe wà. Ezit ywy rehe har umuma'erekoahy kar wanereko wà, ma'erahy ipuraraw kar pà wanupe wà. Aexak wanemipuraraw. ");
INSERT INTO gubBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","A'e rupi — Eho kury, a'e newe ihe kury. Ezur nehe, oromono kar putar wanuwihawete pe ihe nehe. — Tuwe araha Izaew Ezit ywy wi ihe wà nehe, ere tuwihawete pe nehe. — Tuwe Izaew izuapyapyr oho ko ywy wi wà nehe, ere tuwihawete pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Uze'eg Moizez Tupàn pe kury. — Mo romo aiko ihe. Naiko kwaw ikàg ma'e romo ihe. Màràzàwe tuwe hemono kar pe tuwihawete pe ne, Izaew wapyro pà Ezit ywy wi ne, i'i izupe, hehe upuranu pà. ");
INSERT INTO gubBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","— Aiko putar nerehe we ihe nehe, i'i Tupàn izupe. — Amo 'ar mehe hemuwete katu putar pe xe ko ywytyr rehe nehe, Izaew wanehe we nehe, Ezit ywy wi wapyro re nehe. Nezewe mehe erekwaw putar heze'eg azeharomoete har nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","— Aha putar Izaew wapyr ihe nehe. Aze'eg putar wanupe nehe. — Tupàn penu wazar hemur kar xe pepyr a'e, a'e putar wanupe nehe. Aze ru'u upuranu putar herehe wà nehe. — Ma'e her, i'i putar ru'u ihewe wà nehe. Ma'e a'e putar wanupe ihe nehe, herehe wapuranu mehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Uze'eg wi Tupàn Moizez pe kury. — Aiko ihe romo wiko ma'e romo ihe, her romo a'e, ere wanupe nehe. — Aiko ihe romo wiko ma'e romo ihe her ma'e hemur kar xe a'e, ere wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Eze'eg wi Izaew wanupe nehe. — Tupàn a'e, penu wazar a'e, Àmàrààw izar a'e, Izak izar a'e, Zako izar a'e, hemur kar xe pepyr a'e, ere wanupe nehe. Tuweharupi awyzeharupi teko ima'enukwaw putar herehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Eho nehe kury. Emono'og Izaew wanuwihaw tua'uhez kwer ne wà nehe kury. Eze'eg nezewe wanupe nehe. — Tupàn Tuweharupi Wiko Ma'e a'e, penu wazar a'e, Àmàrààw izar Izak izar Zako izar a'e, uzexak kar ihewe a'e, nezewe uze'eg pà ihewe a'e. — Ame'egatu penehe tuweharupi ihe, ere wanupe nehe. — Ezit ywy rehe har uzapo iaiw ma'e waiko peme wà. Aexak wanemiapo kwer ihe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","— Amume'u Ezit ywy wi penemipuraraw wi pepyro àwàm ihe, amo ywy rehe peneraha àwàm imume'uahy pà ihe, ere wanupe. — Ko 'ar rehe amo teko wiko a'e ywy rehe wà. Ai'aw waner xe wà: Kànàà izuapyapyr wà, Ete izuapyapyr wà, Amohe ywy rehe har wà, Perize izuapyapyr wà, Ewe izuapyapyr wà, Zepu izuapyapyr wà. Heta tetea'u ikatuahy ma'e a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Izaew wanuwihaw tua'uhez kwer a'e wà nehe, uzeapyaka katu putar neze'eg rehe a'e wà nehe. Wanupe neze'eg ire eho wanupi Ezit ywy rehe har wanuwihawete pe nehe. Eze'eg izupe nehe. — Tupàn Tuweharupi Wiko Ma'e a'e, teko Emerew her ma'e wazar a'e, uzexak kar urewe uze'eg pà a'e. Tuwe oroho ywyxiguhu pe nehe, ma'ea'yr wazuka pà Tupàn Tuweharupi Wiko Ma'e henataromo nehe, imuwete katu pà nezewe nehe, ere tuwihawete pe nehe. — Urumumaw putar na'iruz 'ar a'e ureata àwàm iapo mehe nehe, ere tuwihawete pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Akwaw Ezit ywy rehe har wanuwihawete hemiapo ràm ihe. Aze amo ikàg ma'e nuzapo kar kwaw a'e ma'e izupe nehe, nuzapo kwaw nehe, napemono kar kwaw ywyxiguhu pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","A'e rupi hekàgaw rupi azapo putar purumupytuhegatu kar haw ihe nehe, iaiw ma'e tetea'u iapo pà Ezit ywy rehe har wanupe ihe nehe. A'e re pemono kar putar a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ama'ereko putar Ezit ywy rehe har wapy'a pe ihe nehe. A'e rupi Izaew ikatu putar wanupe wà nehe. A'e rupi omono putar ma'e tetea'u Izaew wanupe waho mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kuzàgwer paw rupi a'e wà, tuwe uze'eg nezewe kuzà Ezit ywy rehe har wàpuz huwake wiko ma'e wanupe wà nehe, wàpuz me wiko ma'e wanupe wà nehe no. Emur ma'e parat iapo pyrer ipuràg eteahy ma'e ihewe nehe kyn. Emur ma'e or iapo pyrer ipuràg eteahy ma'e ihewe nehe no kyn. Emur topoz ihewe nehe, emur kamir ihewe nehe, tuwe i'i wanupe wà nehe. Pepyhyk a'e ma'e hekuzar katu ma'e nehe, ta'e pemunehew putar a'e ma'e pena'yr wanehe penazyr wanehe nehe xe. Nezewe mehe peraha putar Ezit ywy rehe har wama'e nehe, wanuwi ipyro pà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Na'e Moizez uze'eg wi Tupàn Tuweharupi Wiko Ma'e pe kury. — Teko nuzeruzar kwaw heze'eg rehe wà nehe, nuzeapyaka kwaw heze'eg rehe wà nehe, — Tupàn Tuweharupi Wiko Ma'e nuzexak kar kwaw newe a'e, aze i'i ihewe wà nehe, ma'e azapo putar wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","— Ma'e erepyhyk nepo pe, i'i Tupàn Tuweharupi Wiko Ma'e izupe. — Ywyra hepokokaw ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","— Eityk ywy rehe kury, i'i izupe. Weityk Moizez opokokaw ywy rehe. Moz romo uzeapo. Uzàn Moizez izuwi. ");
INSERT INTO gubBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","— Epyhyk huwaz rehe nepo pupe kury, i'i Tupàn Tuweharupi Wiko Ma'e izupe. A'e rupi Moizez upyho opo oho moz ipyhyk pà. Tàrityka'i uzeapo wi ywyra pokokaw romo ipo pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","— Azapo ko ma'e ihe. Ezapo nehe kury. Nezewe mehe teko uzeruzar putar newe hezexak kar awer rehe a'e wà nehe. Aiko wanu wazar romo ihe. Àmàrààw izar romo Izak izar romo Zako izar romo aiko, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Emono nepo nepuxi'a rehe nehe kury, i'i izupe. A'e rupi Moizez weruzar ize'eg. Upuxi'a wi henuhem wi mehe xigatu ipo iperewàtà ma'e ipo zàwe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","— Emono wi nepuxi'a rehe kury, i'i Tupàn Tuweharupi Wiko Ma'e izupe. Omono wi opo upuxi'a rehe. Henuhem wi mehe ikatu wi hetekwer zàwe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e izupe kury. — Aze nuzeruzar kwaw neze'eg rehe wà nehe, aze nuzekaiw kwaw a'e neremiapo ràm ipy rehe wà nehe, purumupytuhegatu kar haw rehe wà nehe, uzeruzar putar ru'u neremiapo ràm mokoz haw rehe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","— Aze nuzeruzar kwaw a'e mokoz neremiapo ràm rehe wà nehe, aze na'ipuruenu wer kwaw neze'eg rehe wà nehe, enuhem 'y yrykawhu Niru her ma'e wi nehe, ezakook a'e 'y ywyxinig rehe nehe. A'e 'y yrykawhu wi henuhem pyràm uzeapo putar ma'eruwy kwer romo ywy rehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Uze'eg wi Moizez Tupàn pe. — O Tupàn Tuweharupi Wiko Ma'e, naiko pixik kwaw uze'egatu ma'e romo ihe. Ni kwehe mehe, ni ko 'ar rehe ihewe neze'eg ire nakwaw kwaw heze'egatu haw. Mewe katu aze'eg. Nakwaw kwaw heze'egatu haw ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Mo omono ze'egaw rehe wapuner haw purupe a'e. Mo upurumuigo kar iapyha 'ym ma'e romo uze'eg 'ym ma'e romo a'e. Mo upurumuigo kar hehàpyhàgatu ma'e romo. Mo upurumuigo kar hehàpyhà 'ym ma'e romo. Tupàn Tuweharupi Wiko Ma'e nezar romo aiko ihe. Aipo napuner kwaw agwer ma'e iapo haw rehe ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","— Eho kury ty. Urupytywà putar neze'eg mehe ihe nehe. Urumu'e putar neremimume'u ràm rehe ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","— Emono kar amo ae awa herekuzaromo nehe, a'e ma'e iapo kar pà izupe nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Na'e Moizez uputupyk Tupàn Tuweharupi Wiko Ma'e kury. — Neryky'yr Àràw Erewi izuapyr a'e, ukwaw uze'egatu haw a'e. Aze ru'u uze'eg putar nerekuzaromo a'e nehe. Ur iko neruwàxi mà kury. Hurywete putar nerexak mehe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","— Eze'eg izupe nehe. Emume'u kar neze'egaw izupe nehe. Apupytywà putar peze'eg mehe ihe nehe. Apumu'e putar penemiapo ràm rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Uze'eg putar Àràw teko wanupe nerekuzaromo nehe. Upyta putar nerekuzaromo teko wanenataromo nehe. Uze'eg putar wanupe nerekuzaromo nehe. Ereiko putar Tupàn zàwe izupe nehe, hemimume'u ràm imume'u pà izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Epyhyk ko ywyra pokokaw nepo pe nehe. Nezewe mehe erepuner ma'e purumupytuhegatu kar haw iapo haw rehe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Na'e uzewyr Moizez oho watyw Zetoro her ma'e heko haw pe a'e kury. Uze'eg izupe. — Tuwe azewyr aha heànàm Ezit ywy rehe har wanupe ihe nehe kury. Hepuruexak wer wanehe ihe. Aze ru'u amo wikuwe a'e wà rihi, i'i izupe. — Eho ty, tuwe ikatu neho àwàm nehe, i'i tatyw izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg wà Moizez pe a'e kury, Minià ywy rehe heko mehe we a'e kury. — Ezewyr eho Ezit ywy rehe nehe ty, ta'e teko nerehe ipuruzuka wer ma'e paw umàno a'e wà xe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","A'e rupi Moizez umuzeupir kar wemireko zumen ikupe pe kury. Umuzeupir kar wa'yr wakupe pe wà no. Uzypyrog uzewyr pà Ezit ywy kutyr wà. Weraha ywyra opokokaw Tupàn ima'e uzeupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Ezit ywy rehe nezewyr mehe nehe, ezapo purumupytuhegatu kar haw paw rupi tuwihawete henataromo nehe, ta'e amono hekàgaw newe ihe xe. Nezewe rehe we amuigo kar wi putar heze'eg heruzar har 'ym romo ihe nehe. A'e rupi nomono kar kwaw Izaew izuapyapyr Ezit ywy wi a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","— Eze'eg eho tuwihawete pe nehe. — Tupàn Tuweharupi Wiko Ma'e hemur kar xe newe a'e, ko ze'eg imume'u kar pà ihewe a'e, ere izupe nehe. — Izaew nuzawy kwaw hera'yr ipy a'e, i'i Tupàn Tuweharupi Wiko Ma'e newe, ere izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","— Emuhem kar izuapyapyr xe wi ne wà nehe. Nezewe mehe upuner hemuwete katu haw rehe a'e wà nehe, i'i newe. — Ne neremuhem kar kwaw ne wà nehe, a'e rupi azuka putar nera'yr ipy ihe nehe, i'i Tupàn iko newe, ere tuwihawete pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Wata wi Moizez oho iko. Moizez uker amo me wànàm wanehe we. Uwàxi wi Tupàn Moizez wà a'e pe kury. Tupàn oho Moizez izuka pà. (Ta'e Moizez nomonohok kwaw wa'yr ipirera'i ize'eg rupi a'e rihi xe.) ");
INSERT INTO gubBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Hemireko Zipora upyhyk takihe ita iapo pyrer a'e kury. Omonohok umemyr ipirera'i ipupe. Opokok Zipora umen ipy rehe umemyr ipirera'i kwer pupe. — Azeharomoete ereiko hemen tuwykwer izakookar romo ihewe ne, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","— Hemen tuwykwer izakookar romo hekon a'e, i'i Zipora, ta'e Moizez omonohok kar wa'yr ipirera'i izupe a'e xe. Omonohok kar uwa'yr ipirera'i. A'e rupi Tupàn Tuweharupi Wiko Ma'e umuikuwe kar Moizez. ");
INSERT INTO gubBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","A'e 'ar mehe we Tupàn Tuweharupi Wiko Ma'e uze'eg Àràw pe kury. — Eho ywyxiguhu pe Moizez huwàxi mà nehe kury, i'i izupe. A'e rupi uwàxi Àràw Moizez oho ywytyr Tupàn pe imonokatu pyrer pe kury. Uzurupyter Àràw Moizez a'e pe. (Nezewe wanemiapo a'e 'ar mehe arer a'e wà.) ");
INSERT INTO gubBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Na'e Moizez umume'u Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer paw Àràw pe kury. — A'e ma'e paw Tupàn umume'u kar ihewe a'e. — Emume'u ko heze'eg eho tuwihawete pe nehe, i'i ihewe, i'i Àràw pe. — Uzapo kar ma'e purumupytuhegatu kar haw ihewe a'e no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","A'e rupi Moizez oho Àràw rupi Ezit ywy rehe Izaew waneruze'egar paw wamono'og kar pà a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Na'e Àràw umume'u Tupàn Tuweharupi Wiko Ma'e Moizez pe hemimume'u kwer a'e kury, a'e pureruze'eg ma'e nànàn a'e kury. Uzapo purumupytuhegatu kar haw teko wanenataromo a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Teko uzeruzar hehe a'e wà kury. — Tupàn pepuhareko iko a'e. Wexak ma'erahy penemipuraraw iko a'e no, i'i Moizez teko wanupe. A'e ma'e henu mehe teko uzemumew Tupàn Tuweharupi Wiko Ma'e henataromo wà kury, imuwete katu pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na'e Moizez a'e, Àràw a'e no, oho Ezit ywy rehe har wanuwihawete pe uze'eg pà a'e wà kury. — Tupàn Tuweharupi Wiko Ma'e Izaew izuapyapyr wazar uze'eg iko newe a'e kury, i'i izupe wà. — Ure urumume'u putar ize'eg newe kury. — Tuwe teko heremiaihu uhem oho xe wi a'e wà nehe. Nezewe mehe upuner ywyxiguhu pe oho haw rehe wà nehe kury, mynykawhu iapo pà herenataromo a'e wà nehe kury, i'i Tupàn iko newe, i'i tuwihawete pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Uze'eg tuwihawete nezewe Moizez pe Àràw pe a'e kury. — Mo romo aipo Tupàn Tuweharupi Wiko Ma'e hekon a'e, màràzàwe tuwe aruzar putar ize'eg ihe nehe, màràzàwe tuwe amono kar putar Izaew ywyxiguhu rehe ihe wà nehe. Nakwaw kwaw Tupàn Tuweharupi Wiko Ma'e ihe, a'e rupi namono kar kwaw Izaew izuapyapyr xe wi ihe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Na'e uze'eg wi Moizez izupe Àràw rehe we kury. — Tupàn Emerew wazar uze'eg wà urewe a'e. Tuwe urumumaw na'iruz 'ar ywyxiguhu rehe ureata pà ure nehe. Nezewe mehe urupuner ma'ea'yr izuka haw rehe Tupàn Tuweharupi Wiko Ma'e urezar henataromo ure nehe. Aze naxiapo kwaw nezewe haw nehe, aze ru'u Tupàn uzapo putar iaiw ma'e urewe a'e nehe, ma'eahy haw imur kar pà urewe a'e nehe. Aze ru'u zauxiapekwer urezuka putar wà nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ezit ywy rehe har wanuwihawete uze'eg nezewe wanupe a'e kury. — Moizez, i'i izupe. — Àràw, i'i izupe. — Màràzàwe tuwe pemupytu'u kar teko wama'ereko re. Pemuzewyr kar a'e uma'ereko e ma'e tàrityka'i wama'ereko haw pe pe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Na'e uze'eg wi tuwihawete Moizez wanupe. — Peme'egatu teko wanehe. Heta tetea'u teko Izaew izuapyapyr ko ywy rehe har a'e wà kury. Pemupytu'u kar peiko wama'ereko re pe wà. Na'ikatu pixik kwaw nezewe haw ihewe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","A'e 'ar mehe we tuwihawete uze'eg uma'ereko ma'e wanuwihaw wanupe kury, waneruze'egar wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","— Ko 'ar 'ym mehe we pemono ka'api'i teko wanupe, ywytàtà iapo kar pà wanupe. Ko 'ar henataromo nehe, tuwe a'e ae oho ka'api'i imono'og pà uzeupe a'e wà nehe, i'i. ");
INSERT INTO gubBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","— Tuweharupi pezapo kar ywytàtà tetea'u teko wanupe izypy mehe arer zàwegatete nehe. Tuwe ywytàtà tuweharupi iapo pyràm nuzawy kwaw ywytàtà tuweharupi iapo pyrer nehe. Aze nan kwaw nezewe nehe, pezepyk wanehe nehe. Iranahy a'e wà, a'e rupi uze'eg nezewe a'e wà. — Tuwe oroho ma'ea'yr izuka pà Tupàn henataromo ure nehe, i'i zanewe wà. Ta'e na'ima'ereko wer kwaw a'e wà xe, i'i tuwihawete amo tuwihaw wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","— Pemuma'ereko kar wera'u teko pe wà nehe. Nezewe mehe uma'ereko tetea'u putar a'e wà nehe. Nezewe mehe nuzekaiw kwaw temu'emaw rehe a'e wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Na'e uma'ereko e ma'e wanuwihaw a'e wà kury, waneruze'egar a'e wà no, uhem oho tuwihawete wi teko wanupe uze'eg pà a'e wà kury. — Tuwihawete uze'eg nezewe a'e kury. — Namono kwaw ka'api'i ywytàtà inuromo àràm peme ihe nehe kury, i'i peme. ");
INSERT INTO gubBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","— Pekar ka'api'i peho pezeupe nehe. Aze heta amo me nehe, pepyhyk a'e pe nehe. Aze naheta kwaw nehe, pekar peho amo ae ywy pehegwer rehe nehe. Pepytu'u zo ywytàtà iapo re nehe. Pezapo ywytàtà tetea'u izypy mehe arer zàwe nehe, i'i tuwihawete peme, i'i tuwihaw Izaew izuapyapyr wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Na'e a'e teko uhàuhàz Ezit ywy rehe paw rupi wà, ka'api'i imono'ono'og pà wà. Te ka'api'i pykwer imonohok pyrer omono'og wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Wamuma'ereko kar har umuma'erekoahy kar wi wi a'e wà. — Pezapo pema'ereko haw tuweharupi har paw nehe, izypy mehe arer zàwe nehe, ka'api'i hereko mehe arer zàwe nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","(Nupuner kwaw ywytàtà iapo haw rehe izypy mehe arer zàwe.) A'e rupi tuwihaw upetek Izaew izuapyapyr wama'ereko haw rehe uzekaiw ma'e a'e wà. Upuranu wanehe wà. — Màràzàwe tuwe napezapo kwaw ywytàtà kutàri izypy mehe arer zàwe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Na'e a'e Izaew izuapyapyr ma'ereko haw rehe uzekaiw ma'e uze'eg oho tuwihawete pe a'e wà kury. — Màràzàwe tuwe erereko newe uma'ereko e ma'e nezewe ne wà, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","— Numur kwaw ka'api'i urewe wà. — Nezewe rehe we pezapo ywytàtà tetea'u nehe, i'i urewe wà. Urepetepetek waiko wà. Neremiruze'eg na'ikatu kwaw wà, i'i tuwihawete pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Uze'eg wi tuwihawete wanupe. — Peranahy tuwe pe. Uma'ereko katu 'ym ma'e romo peiko, i'i wanupe. — Tuwe oroho ma'ea'yr izuka pà Tupàn Tuweharupi Wiko Ma'e imuwete katu pà nehe, peze peiko, ta'e napema'ereko wer kwaw pe xe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","— Pezewyr pema'ereko haw pe tàrityka'i nehe. Namono kwaw ka'api'i peme nehe. Ywytàtà tetea'u pezapo izypy mehe arer ài nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Na'e Izaew izuapyapyr wanuwihaw ukwaw tuwihawete iaiw paw a'e wà kury. Ta'e — Pezapo zo ywytàtà pixik nehe. Pezapo ywytàtà tetea'u tuweharupi nehe, izypy mehe arer zàwegatete nehe, i'i wanupe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Uhem a'e awa tuwihawete wi wà kury. Wahem ire wexak Moizez a'e pe wà. Wexak Àràw a'e pe wà no. Wàro wahemaw waiko a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Uze'eg wanupe wà kury. — Tuwe Tupàn Tuweharupi Wiko Ma'e ume'e penehe nehe. Tuwe uzepyk penehe penemiapo kwer rehe nehe. Tuwihawete a'e, izupe uma'ereko ma'e a'e wà no, na'iakatuwawahy kwaw urerehe a'e wà kury, ipuruzuka wer urerehe wà kury, ta'e penoz wi wi xe wi urehem àwàm izupe pe xe, i'i a'e tuwihaw Moizez wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Uzewyr Moizez Tupàn Tuweharupi Wiko Ma'e pe uze'eg pà a'e kury. — Tupàn Tuweharupi Wiko Ma'e hezar. Màràzàwe tuwe erepuraraw kar agwer ma'erahy a'e teko wanupe. Aipo hemur kar xe ma'erahy ipuraraw kar pà wanupe ne. ");
INSERT INTO gubBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tuwihawete pe heze'eg ire upuraraw kar ma'erahy a'e teko wanupe. Nerepyro kwaw a'e teko neremiaihu ne wà, ma'erahy wi ne wà, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe a'e kury. — Erexak putar tuwihawete pe heremiapo ràm ne nehe kury. Hekàgaw hexak mehe omono kar putar Izaew xe wi a'e wà nehe, ko ywy wi wamuhem kar pà a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Uze'eg wi Tupàn Moizez pe. — Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Azexak kar Àmàrààw pe ihe. Azexak kar Izak pe no. Azexak kar Zako pe no. Tupàn ikàg wera'u ma'e romo azexak kar wanupe. Ma'e paw wazar herer inugwer romo ihe. Namume'u kwaw ko herer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Azapokatu heze'egaw wanehe we ihe. Amume'uahy Kànàà ywy waneko àwàm romo. Wiko a'e ywy rehe amo ae ywy rehe har zàwe a'e 'ar rehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ko 'ar rehe ainu wazai'o haw iteko ihe kury. Ta'e Ezit ywy rehe har umuma'erekoahy kar wanereko a'e wà xe. Naheharaz kwaw heze'eg awer wi ihe, kwehe mehe heremimume'u kwer wi ihe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","— A'e rupi emume'u ko heze'eg eho Izaew izuapyapyr wanupe nehe kury. — Tupàn Tuweharupi Wiko Ma'e romo aiko ihe. Apumuhem kar putar Ezit ywy rehe har wanuwi ihe nehe, pemuma'erekoahy kar har wanuwi ihe nehe. Peiko uma'ereko e ma'e romo wanupe ko 'ar rehe. Apumupytu'u kar putar a'e ma'e romo peneko re ihe nehe. Apyho putar hezywa ikàg ma'e ihe nehe, pepyro pà Ezit wanuwi nehe. Azepyk putar wanehe zepykaw iaiw ma'e pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Apumuigo kar putar heremiaihu romo nehe. Aiko putar Tupàn pezar romo nehe no. Nezewe mehe pekwaw putar Tupàn pezar romo hereko haw nehe. Ta'e apupyro putar Ezit ywy rehe har wanuwi ihe nehe xe, uma'ereko e ma'e romo peneko re pemupytu'u kar pà ihe nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Apueraha putar ywy heremimume'u kwer pe nehe. Ta'e kwehe mehe amume'uahy tuwe a'e ywy Àmàrààw pe Izak pe Zako pe ihe xe. Amono e putar tuwe peme ihe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo aiko ihe, ere teko wanupe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Umume'u Moizez a'e ma'e paw Izaew izuapyapyr wanupe. Nuzekaiw kwaw ize'eg rehe wà. Ta'e uzemumikahy uma'erekoahy haw rehe a'e wà xe, ta'e Ezit ywy rehe har upuraraw kar ma'erahy wanupe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","— Eze'eg eho Ezit ywy rehe har wanuwihawete Parao her ma'e pe nehe kury. — Tuwe Izaew izuapyapyr oho neiwy wi a'e wà nehe kury, ere izupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Uze'eg Moizez Tupàn pe. — Izaew izuapyapyr nuzekaiw kwaw heze'eg rehe wà. Parao nuzekaiw kwaw heze'eg rehe a'e nehe, ta'e naze'eg katu kwaw ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nezewe rehe we uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe Àràw pe a'e kury, Izaew wanehe a'e kury, Ezit ywy rehe har wanuwihawete Parao her ma'e rehe a'e no. — Peraha Izaew izuapyapyr Ezit ywy wi pe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Amume'u putar wanu waner xe wamuapyk pà ko pape rehe ihe wà nehe kury. Humen a'e, Izaew ta'yr ipy romo hekon a'e. Enok, Paru, Ezerom, Karomi a'e wà, Humen ta'yr waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Na'aw 6 Ximeàw ta'yr waner xe wà: Zemuew, Zamim, Owaz, Zakim, Zoar. Xau wiko kuzà Kànàà ywy rehe har imemyr romo. Heta tetea'u ta'yr wanupe pitàitàigatu wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Na'aw na'iruz Erewi ta'yr waner xe wà: Umuapyk uwer paw pape rehe wà. Amugeta a'e pape a'e waner imuapyk pà ko pape rehe ihe. Zeroxon, Koat, Merari. Erewi umumaw 137 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Na'aw Zeroxon ta'yr waner xe wà: Irimini, Ximez. Heta tetea'u wapurumuzàmuzàg wanupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Na'aw Koat ta'yr waner xe wà: Ànàràw, Izar, Emerom, Uziew. Koat umumaw 133 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Na'aw mokoz Merari ta'yr waner xe wà: Mari, Muzi. Amumaw Erewi ta'yr waner wamume'u haw kury, wazuapyapyr waner wamume'u haw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ànàràw wereko u heinyr wemireko romo. Zokemez her romo a'e. Wiko Moizez ihy romo Àràw ihy romo a'e. Ànàràw umumaw 137 kwarahy wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Na'aw na'iruz Izar her ma'e ta'yr waner xe wà: Kora, Nepek, Zikiri. ");
INSERT INTO gubBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Na'aw na'iruz Uziew ta'yr waner xe wà: Mizaew, Ewzàpà, Xixiri. ");
INSERT INTO gubBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Àràw wereko Erixepa wemireko romo. Wiko Aminanaw tazyr romo Nazom heinyr romo. Omono 4 ta'yr Àràw pe wà. Nanaw, Amiu, Ereazar, Itamar ta'yr waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na'aw na'iruz Kora ta'yr waner xe wà: Axir, Ewkàn, Apiaxaw. Heta tetea'u ta'yr wanupe wà. Heta tetea'u wanemimino wanupe wà no. Omono uwer uzuapyapyr wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ereazar Àràw ta'yr wereko Puxiew tazyr wemireko romo. Omono ta'yr Pinez her ma'e izupe. Amumaw Erewi ta'yr waner wamume'u haw kury. Amumaw wazuapyapyr waner wamume'u haw kury. ");
INSERT INTO gubBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Moizez a'e, Àràw a'e no, Tupàn Tuweharupi Wiko Ma'e uze'eg tuwe wanupe a'e kury. — Peraha Izaew izuapyapyr Ezit ywy wi pe wà nehe. Pitàitàigatu Izaew ta'yr wazuapyapyr uzemono'og putar xe wi wata pà wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moizez a'e, Àràw a'e no, a'e ae oho Ezit ywy rehe har wanuwihawete Parao her ma'e pe uze'eg pà a'e wà kury. — Emono kar Izaew izuapyapyr Ezit ywy wi ne wà nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe Ezit ywy rehe heko mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","— Aiko Tupàn Tuweharupi Wiko Ma'e romo teko wazar romo ihe. Emume'u heremimume'u kwer paw Ezit ywy rehe har wanuwihawete Parao her ma'e pe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","— Naze'eg katu kwaw ihe. Màràzàwe tuwe Parao uzekaiw katu putar heze'eg rehe a'e nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Na'e uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Urumuigo kar putar Tupàn zàwenugar romo Parao pe ihe nehe. Neryky'yr Àràw wiko putar neze'eg imume'u har romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Heremimume'u kàràm paw emume'u Àràw pe nehe. — Emuhem kar Izaew izuapyapyr neiwy wi ne wà nehe, ere Parao pe nehe, ere neryky'yr Àràw pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","— Amuigo kar putar Parao hereruzar har 'ym romo ihe nehe. Azapo putar hexak pixik pyr 'ym tetea'u Ezit ywy rehe nehe, azapo putar purumupytuhegatu kar haw tetea'u nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Nezewe rehe we nuzeapyaka kwaw neze'eg rehe nehe. A'e rupi apuraraw kar putar ma'erahy tetea'u Ezit ywy rehe har wanupe ihe nehe. A'e re arur putar heremiaihu paw ihe wà nehe, Izaew ta'yr wazuapyapyr paw ihe wà nehe, Ezit ywy wi ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Azepyk putar Ezit ywy rehe har wanehe ihe nehe, heremiaihu wamuhem kar pà a'e wi ihe nehe. Nezewe mehe ukwaw putar Tupàn Tuweharupi Wiko Ma'e romo hereko haw a'e wà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moizez a'e, Àràw a'e no, weruzar katu Tupàn ze'eg a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moizez wereko 80 kwarahy Parao pe waze'eg mehe. Àràw wereko 83 kwarahy a'e 'ar mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Uze'eg wi Tupàn Moizez pe Àràw pe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","— Ezapo amo purumupytuhegatu kar haw ihewe nehe, i'i putar ru'u Parao newe a'e nehe. Nezewe ize'eg mehe eze'eg Àràw pe nehe. — Epyhyk nepokokaw. Eityk ywy rehe Parao henataromo kury. Uzeapo putar moz romo tàrityka'i nehe kury, ere izupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","A'e rupi oho Moizez Parao pe Àràw rupi kury. Uzapo Tupàn Tuweharupi Wiko Ma'e hemiapo kar kury. Weityk Àràw opokokaw ywy rehe Parao henataromo amogwer tuwihaw wanenataromo kury. Moz romo uzeapo kury. ");
INSERT INTO gubBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Na'e tuwihawete Parao wenoz awa ma'e kwaw katu har uzeupe a'e wà kury. Wenoz awa paze ma'e uzeupe wà no. Paze ma'e Ezit ywy rehe har uzapo purumupytuhegatu kar haw Àràw zàwegatete a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Pitàitàigatu weityk ywyra opokokaw ywy rehe wà. Pitàitàigatu ywyra uzeapo moz romo wà. Nezewe rehe we Àràw ipokokaw u'u amogwer wapokokaw a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Nezewe rehe we Parao na'ipureruzar wer kwaw Tupàn ze'eg rehe ize'eg awer rupi katete. Nuzeapyaka kwaw waze'eg rehe. — Numuhem kar kwaw heremiaihu a'e wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e a'e 'ym mehe. Azeharomoete Parao numuhem kar kwaw wiwy wi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Parao nuweruzar kwaw heze'eg. Numuhem kar kwaw teko uiwy wi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pyhewe izi'itahy uhem putar Parao oho 'y pe nehe. Eze'eg eho izupe a'e pe ihem mehe nehe. Eàro Niru yrykawhu iwyr nehe. Epyhyk a'e ywyra moz romo wiko ma'e kwer nepo pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Eze'eg nezewe izupe nehe. — Tupàn Tuweharupi Wiko Ma'e Emerew wazar hemur kar xe newe hemuze'eg kar pà a'e kury. — Emuhem kar teko heremiaihu Ezit ywy wi ne wà nehe. Hemuwete katu putar oho ywyxiguhu pe a'e wà nehe. Nezewe rehe we nereruzar kwaw heze'eg ne rihi. ");
INSERT INTO gubBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Nezewe i'i Tupàn Tuweharupi Wiko Ma'e newe kury. Ywyra pokokaw hepo pe har pupe anupà putar yrykawhu Niru her ma'e ihe nehe. 'Y uzeapo putar ma'eruwy kwer romo nehe. Hemiapo kwer hexak ire erekwaw putar nezar romo hereko haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ipira yrykawhu pe har umàno putar wà nehe. Inem putar yrykawhu pe nehe. Ezit ywy rehe har nupuner kwaw a'e 'y pupe uwi'u haw rehe wà nehe, ere izupe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Eze'eg nezewe Àràw pe kury. — Epyhyk nepokokaw nepo pe kury. Epyho nepo 'y Ezit ywy rehe har kutyr kury: Yrykawete, yrykaw teko wanemiapo kwer, ypawete, ypaw teko wanemiapo kwer. A'e 'y paw uzeapo putar ma'eruwy kwer romo nehe. Heta putar ma'eruwy kwer yrykaw nànàn, yryhu nànàn no, y'a ywyra iapo pyrer nànàn, y'a ita iapo pyrer nànàn no, ere izupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moizez a'e, Àràw a'e no, uzapo tuwe Tupàn hemiapo karer a'e wà kury. Upir Àràw ywyra opokokaw Parao henataromo, tuwihawete rehe we har wanenataromo no. Unupà Niru yrykaw kury. 'Y paw uzeapo ma'eruwy kwer romo. ");
INSERT INTO gubBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ipira Niru pe har umàno wà. Yrykawhu inemahy kury. A'e rupi Ezit ywy rehe har nupuner kwaw i'y pupe uwi'u haw rehe wà. Heta tetea'u ma'eruwy kwer Ezit ywy nànàn kury. ");
INSERT INTO gubBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Paze ma'e Ezit ywy rehe har uzapo purumupytuhegatu kar haw nezewegatete a'e wà no, ta'e ukwaw agwer ma'e iapo haw a'e wà xe. Amogwer teko nukwaw kwaw iapo haw wà. Parao na'ipureruzar wer kwaw Tupàn Tuweharupi Wiko Ma'e ze'eg rehe a'e rihi, ize'eg rupi katete a'e rihi. Nuzeapyaka kwaw Moizez ze'eg rehe Àràw ze'eg rehe Tupàn hemimume'u kwer rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Uzewyr oho wàpuzuhu pe kury. Nuzekaiw kwaw ma'eruwy kwer yrykawhu pe har rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ezit ywy rehe har paw u'ywykàz Niru huwake wà, 'y ikatu ma'e hekar pà wà, ta'e nupuner kwaw 'y yrykawhu pe har pupe uwi'u haw rehe wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nezewe Tupàn umuaiw yrykawhu Niru her ma'e. A'e re umumaw 7 'ar uze'eg 'ym pà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na'e uze'eg wi Moizez pe kury. — Eho wi Parao pe neze'eg pà nehe kury. — Tupàn Tuweharupi Wiko Ma'e uze'eg iko nezewe newe kury, ere izupe nehe. — Emuhem kar heremiaihu neiwy wi ne wà nehe. Nezewe mehe upuner hemuwete katu haw rehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aze neremuhem kar kwaw wà nehe, azepyk putar neywy rehe ihe nehe. Amueta tetea'u kar putar zu'i neiwy rehe ihe wà nehe. Upyk putar neywy a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Yrykawhu Niru tynehem putar zu'i pupe nehe. Uhem putar yrykawhu wi neràpuzuhu pupe wixe pà wà nehe, neker haw pupe wà nehe. Uzeupir putar nerupaw rehe wà nehe no. Tuwihaw nerehe we har wanàpuz pupe wixe putar wà nehe no, neiwy rehe har wanàpuz me wà nehe no. Wixe putar zàpehe pupe wà nehe no, typy'ak iapo haw pupe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Uzeupir putar penehe wà nehe, penemiaihu wanehe wà nehe no, wanuwihaw wanehe wà nehe no, ere Parao pe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Eze'eg Àràw pe nezewe nehe. — Epyhyk nepokokaw nehe, epyho nepokokaw yrykawhu kutyr nehe, yrykaw teko wanemiapo kwer kutyr nehe no, ypaw kutyr nehe no, zu'i wamuzeupir kar pà 'y wi Ezit ywy rehe wamono kar pà nehe, ere izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A'e mehe upyho Àràw opo 'y Ezit ywy rehe har kutyr kury. Uzeupir zu'i tetea'u ywy ipyk pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nezewe rehe we paze ma'e uzapo agwer ma'e ukàgaw rupi a'e wà no. Umuzeupir kar zu'i Ezit ywy rehe a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","— Perur Moizez Àràw rehe we xe ihewe pe wà nehe, i'i Parao wemiruze'eg wanupe kury. Henataromo wahem mehe uze'eg wanupe. — Peze'eg Tupàn Tuweharupi Wiko Ma'e pe nehe ty wà. — Emono kar zu'i ihewi ne wà nehe, heremiaihu wanuwi ne wà nehe, ere izupe nehe. — A'e re amono kar putar neremiaihu ko ywy wi ihe wà nehe. Nezewe mehe upuner ma'ea'yr izuka haw rehe newe a'e wà nehe, ere Tupàn pe herekuzaromo nehe, i'i Parao Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Uze'eg Moizez Parao pe kury. — He'e. Ikatu putar neremimutar henoz tàwàm ihewe nehe. Aze'eg putar Tupàn pe nerehe nehe, tuwihaw nerehe we har wanehe nehe no, teko neremiaihu wanehe nehe no. Nezewe mehe Tupàn umuhem kar putar zu'i pewi a'e wà nehe, penàpuz wi a'e wà nehe no. Xo yrykawhu Niru her ma'e pupe har nomono kar kwaw wà nehe. Ma'e 'ar mehe aze'eg putar izupe nerehe nehe. Ne ae exak 'ar nehe, izupe heze'egaw 'ar nehe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","— Pyhewe nehe, i'i Parao Moizez pe. — He'e, neze'eg rupi katete aze'eg putar izupe nehe. Nezewe mehe erekwaw putar Tupàn Tuweharupi Wiko Ma'e Zanezar ikàgaw nehe. Naheta kwaw amo ikàg ma'e izàwe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Zu'i nerezar putar wà nehe, wezar putar penàpuz wà nehe. Wezar putar penuwihaw wà nehe, penemiaihu wà nehe. Upyta putar Niru yrykawhu pupe wà nehe, i'i Moizez Àràw rehe we Parao pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moizez uhem oho tuwihawete hàpuzuhu wi Àràw rupi kury. A'e re uze'eg Moizez Tupàn pe a'e kury, zu'i wamumaw pàwàm rehe a'e kury, ta'e a'e ae umur kar a'e zu'i Parao pe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Uzapo Tupàn Tuweharupi Wiko Ma'e Moizez heminozgwer a'e kury. Umàno zu'i tàpuz pupe har wà. Umàno zu'i katu pe har wà. Umàno zu'i ko pe har wà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Omono'ono'og teko zu'i wà, ywytyra'i romo iapo pà wà. Inem a'e pe wà. Ipihe haw uhàuhàz a'e ywy nànàn. ");
INSERT INTO gubBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Parao wexak wamàno awer. Zu'i nuputupyk kwaw teko wà kury. A'e rupi uhaw Parao uze'eg awer. Na'ipureruzar wer kwaw Tupàn ze'eg rehe kury. Nuzeapyaka katu kwaw Moizez ze'eg rehe Àràw ze'eg rehe. Wiko Parao Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer ài. ");
INSERT INTO gubBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe a'e kury. — Eze'eg nezewe Àràw pe nehe. — Epyho nepokokaw nehe. Enupà ywyku'i ipupe nehe. A'e mehe ywyku'i Ezit ywy rehe har uzeapo putar kyw romo nehe, ere izupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Weruzar ize'eg wà. Àràw upyho opokokaw kury. Unupà ywyku'i. A'e mehe ywyku'i Ezit ywy rehe har paw uzeapo kyw tetea'u romo. Upyk teko wà, upyk ma'ea'yr wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Paze ma'e uzeagaw zepe kyw iapo pà a'e wà. Nupuner kwaw wà. Kyw upyk teko wà, upyk ma'ea'yr wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Na'e paze ma'e uze'eg tuwihawete pe wà. — Tupàn a'e, ko ma'e iapo arer romo hekon a'e, i'i izupe wà. — Naruzar kwaw Tupàn Tuweharupi Wiko Ma'e ze'eg ihe nehe. Namono kar kwaw hemiaihu xe wi ihe wà nehe, i'i Parao uzeupe. Nuzeapyaka kwaw Moizez ze'eg rehe Àràw ze'eg rehe. Wiko wiwi Parao Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer zàwe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg wi Moizez pe kury. — Eme'e nepu'àm pà izi'itahy nehe. Tuwihawete 'y pe iho mehe eho huwàxi mà nehe. Eze'eg nezewe izupe nehe. — Emuhem kar heremiaihu xe wi ne wà nehe ty, ta'e hemuwete katu putar amo me a'e wà nehe xe, i'i Tupàn iko newe, ere izupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","— Aze neremono kar kwaw wà nehe, amur kar putar meru tetea'u newe nerehe hezepyk pà ihe wà nehe, tuwihaw nerehe we har wanupe ihe wà nehe no, teko neremiruze'eg wanupe ihe wà nehe no. Ezit ywy rehe har wanàpuz tynehem putar meru pupe nehe. Meru upyk putar waneko haw ywy wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","A'e 'ar mehe amo ae ma'e azapo putar heremiaihu Kozem ywy rehe wiko ma'e wanupe ihe nehe. Naheta pixik kwaw meru a'e pe wà nehe. Nezewe mehe erekwaw putar nezar romo hereko haw nehe, erekwaw putar ko ywy rehe hereko haw nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Neremiaihu wanereko haw uzawy putar heremiaihu wanereko haw nehe. A'e ma'e purumupytuhegatu kar àwàm azapo putar pyhewe ihe nehe, ere Parao pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Uzapo Tupàn Tuweharupi Wiko Ma'e a'e ma'e uze'eg rupi katete. Meru tetea'u wixe oho Parao hàpuzuhu pupe wà, tuwihawete pe uma'ereko ma'e wanàpuz pupe wà no. Ezit ywy nànàn meru umuaiw ma'e paw rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Na'e Parao omono amo wemiruze'eg Moizez Àràw wanenoz tà kury. — Hepuruzuka kar wer ma'ea'yr rehe Tupàn pezar henataromo ihe wà nehe. Pezuka xe ko ywy rehe pe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Uze'eg Moizez izupe. — Na'ikatu kwaw nezewe àwàm. Ta'e Ezit ywy rehe har umuwete amo ma'ea'yr a'e wà xe. A'e ma'ea'yr uruzuka Tupàn Tuweharupi Wiko Ma'e henataromo ure wà. Wazuka haw iro putar Ezit wanupe nehe. Aze uruzuka a'e ma'ea'yr ure wà nehe, Ezit ywy rehe har omomor putar ita urerehe urezuka pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Urumumaw putar na'iruz 'ar ureata pà ywyxiguhu rehe ure nehe. Te uruhem putar Tupàn Tuweharupi Wiko Ma'e urezar henataromo ma'ea'yr hapy haw pe ure nehe. Ta'e a'e ae uzapo kar nezewe haw urewe a'e xe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Uze'eg wi Parao Moizez pe. — Apomono kar putar ywyxiguhu pe ihe nehe. Pezuka ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pezar henataromo nehe. Peho zo muite xe wi. Eze'eg Tupàn Tuweharupi Wiko Ma'e pe herehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Uze'eg wi Moizez Parao pe. — Newi hehem ire nehe, tàrityka'i aze'eg putar Tupàn Tuweharupi Wiko Ma'e pe nerehe nehe. Meru oho putar newi wà nehe, newe uma'ereko ma'e wanuwi wà nehe no, neremiaihu wanuwi wà nehe no. Neremu'em wi zo nehe. — Namono kar kwaw Izaew xe wi ihe wà nehe, ere wi zo nehe, i'i Moizez izupe. — Nupuner kwaw oho haw rehe Tupàn Tuweharupi Wiko Ma'e pe ma'ea'yr zuka pà wà nehe, ere zo nehe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Na'e oho Moizez Parao hàpuzuhu wi kury. Uze'eg Tupàn Tuweharupi Wiko Ma'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Uzapo Tupàn Tuweharupi Wiko Ma'e ma'e Moizez ze'eg rupi. Meru uhem oho Parao wi wà, hehe we har tuwihaw wanuwi wà no, hemiaihu wanuwi wà no. Ni pitài meru nupyta kwaw a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","— Naruzar kwaw Tupàn ze'eg ihe nehe. Namono kar kwaw hemiaihu xe wi ihe wà nehe, i'i Parao uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Eze'eg eho Parao pe nehe ty. — Tupàn Tuweharupi Wiko Ma'e Emerew wazar umume'u kar ko ze'eg newe a'e, ere izupe nehe. — Emuhem kar heremiaihu xe wi ne wà nehe, ta'e ipurumuwete wer herehe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Aze neremuhem kar kwaw xe wi ne wà nehe, aze eremupyta kar wi xe ne wà nehe, ");
INSERT INTO gubBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Tupàn umuma'eahy kar putar tuwe peneimaw ko pe har a'e wà nehe. Kawaru wà, zumen wà, kamer wà, tapi'ak wà, àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà. Paw rupi katete ima'eahy putar tuwe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tupàn Tuweharupi Wiko Ma'e wereko katu putar Izaew waneimaw wà nehe. Werekoaiw putar Ezit ywy rehe har waneimaw wà nehe. Ni pitài Izaew waneimaw numàno kwaw wà nehe, i'i Tupàn iko peme, ere Parao pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Umume'u Tupàn Tuweharupi Wiko Ma'e u'ar kury. — Pyhewe azapo putar a'e iaiw ma'e ko ywy rehe ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Uzapo a'e ma'e wemimume'u kwer rupi katete. Ezit ywy rehe waneimaw paw umàno wà. Nezewe rehe we ni pitài Izaew waneimaw numàno kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Omono kar Parao amo awa a'e ma'e hexak pà wà. Ume'egatu Izaew waneimaw wanehe wà. Ni pitài numàno kwaw wà. — Naruzar kwaw Tupàn ze'eg ihe nehe. Namono kar kwaw hemiaihu xe wi ihe wà nehe, i'i Parao uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe Àràw pe kury. — Penuhem tàtàpyzgwer zàpehe wi nehe. Tuwe Moizez omomor a'e tàtàpyzgwer ywate Parao henataromo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A'e tàtàpyzgwer uzeapo putar ywyku'i zàwenugar romo Ezit ywy nànàn nehe. A'e mehe teko paw a'e wà nehe, waneimaw a'e wà nehe no, ipereperew putar a'e wà nehe, Ezit ywy nànàn a'e wà nehe. Waperew uzepupeka putar wanupe hahy pà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","A'e mehe upyhyk tàtàpyzgwer zàpehe pupe har wà kury. Upu'àm oho Parao henataromo. Moizez omomor a'e tàtàpyzgwer ywate kury. Teko a'e wà, waneimaw a'e wà no, ipereperew a'e wà kury. Waperew uzepupeka wanupe hahy pà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Paze ma'e nupuner kwaw uzexak kar haw rehe Moizez henataromo wà, ta'e hahy tuwe waperew wanupe a'e wà xe. Ezit ywy rehe har paw ipereperew wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nezewe rehe we Tupàn uma'ereko wi Parao ipy'a pupe. A'e rupi na'ipureruzar wer kwaw ize'eg rehe. Nuzeapyaka kwaw Moizez ze'eg rehe Àràw ze'eg rehe. Uzeapo iaiw ma'e Tupàn hemimume'u kwer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Epu'àm izi'itahy nehe. Eze'eg eho Parao pe nehe, heze'eg imume'u pà izupe nehe. — Tupàn Tuwihawete Wiko Ma'e Emerew wazar uze'eg iko nezewe newe kury, ere izupe nehe. — Emuhem kar heremiaihu xe wi ne wà nehe, ta'e ipurumuwete katu wer herehe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Aze neremuhem kar kwaw ne wà nehe, amu'ar kar putar iaiw ma'e nerehe nehe, tuwihaw nerehe we har wanehe nehe no, teko neremiaihu wanehe nehe no. Nezewe mehe erekwaw putar hekàgaw nehe. Naheta kwaw ikàg ma'e hezàwenugar ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Aze mo aputar, apuner mo amo iaiw wera'u ma'e peme uzeapo ma'e imu'ar kar haw rehe ihe. Apuner mo pezuka haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Napuzuka kwaw ihe. Nuruzuka kwaw ihe. Urumuigo kar wiwi ihe, ta'e aexak kar putar hekàgaw purupe ihe nehe xe. Nezewe mehe teko ywy nànànar umume'u putar hekàgaw ywy nànàn a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nerepytu'u kwaw ikàg ma'e ài nereko wer ire. Neremuhem kar kwaw ne wà rihi. ");
INSERT INTO gubBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","A'e rupi pyhewe ko 'or zàwenugar mehe amugyr kar putar àmàntàtà uhua'u ma'e iaiw wera'u ma'e ihe nehe. Izypy mehe arer we te ko 'ar rehe Ezit ywy rehe har nuexak pixik kwaw àmàntàtà iaiw ma'e ko àmàntàtà zàwenugar wà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","A'e rupi emono kar teko ko pe ne wà nehe kury. Tuwe werur peneimaw paw pema'e paw wà nehe. — Pemonokatu peneimaw pema'e tàpuz pupe àmàntàtà wi wapyro pà nehe, ere wanupe nehe. Ta'e àmàntàtà ukyrahy putar teko nànàn ma'ea'yr nànàn ko pe upyta ma'e kwer nànàn nehe. Umàno putar a'e pe wà nehe, ere Parao pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Amo tuwihaw Parao rehe we har uzeruzar Tupàn ze'eg rehe a'e wà. Uzàn oho uma'ereko ma'e wàpuz pupe wanerur pà wà, waneimaw wanerur pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Amogwer nuzeruzar kwaw wà. Wezar uma'ereko ma'e ko pe wà. Wezar weimaw ko pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Na'e uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Epyho nepo ywak kutyr kury. Nezewe mehe àmàntàtà ukyr putar Ezit ywy nànàn nehe, teko wanehe nehe, waneimaw wanehe nehe no, ko pe hezuz ma'e nànàn Ezit ywy nànàn nehe no, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Upyho Moizez opokokaw ywak kutyr kury. Umuànoànog kar Tupàn Tuweharupi Wiko Ma'e. Umugyr kar àmàntàtà no. Uweraweraw ywy rehe. Nezewe Tupàn umugyr kar àmàntàtà Ezit ywy rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ukyr àmàntàtà. Uweraweraw ko rupi. Uweraweraw kwe rupi no. Izypy mehe arer we te a'e 'ar mehe Ezit ywy rehe har nuexak pixik kwaw àmàntàtà izàwenugar wà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ezit ywy nàn àmàntàtà uzapi ko pe har paw rupi wà: teko wà, ma'ea'yr wà. Uhaw hezuz ma'e ko pe har paw no. Uhaw ywyra paw no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Xo Kozem ywy rehe zo, xo Izaew izuapyapyr waneko haw pe zo nukyr kwaw àmàntàtà. ");
INSERT INTO gubBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Na'e Parao wenoz Moizez uzeupe kury. Wenoz Àràw uzeupe no. — Azeharomoete kutàri azapo ikatu 'ym ma'e kwez Tupàn Tuweharupi Wiko Ma'e henataromo ihe, i'i wanupe. — Ikatu Tupàn Tuweharupi Wiko Ma'e. Nahekatu kwaw ihe. Heremiaihu na'ikatu kwaw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Eze'eg Tupàn pe urerehe ty. Ta'e àmàn iànoànogaw ureputupyk a'e xe. Àmàntàtà ikyr haw iaiw urewe a'e no. Apumuhem kar putar ihe nehe. Pepytu'u hàro re kury, i'i Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Uze'eg Moizez izupe. — Tawhu wi heho mehe apyho putar hepo Tupàn Tuweharupi Wiko Ma'e pe heze'eg pà ihe nehe. Upytu'u putar wànoànog ire nehe. Àmàntàtà upytu'u putar ukyr ire nehe no. Nezewe mehe erekwaw putar Tupàn Tuweharupi Wiko Ma'e ywy izar romo heko haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Akwaw pepy'a ihe. Nerekyze kwaw Tupàn Tuweharupi Wiko Ma'e wi. Tuwihaw nerehe we har nukyze kwaw izuwi a'e wà, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ka'akyr irin her ma'e a'e, arozràn xewar her ma'e a'e no, upaw a'e. Xewar haryw a'e. Irin iputyr a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nezewe rehe we arozràn xirik her ma'e a'e, arozràn xenetez her ma'e a'e no, nupaw kwaw a'e, ta'e nahezuz kwaw a'e 'ar rehe a'e rihi xe. ");
INSERT INTO gubBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Na'e Moizez wezar Parao a'e pe kury, tawhu wi oho pà kury. Upyho opo Tupàn kutyr izupe uze'eg pà. Upytu'u wànoànog ire. Upytu'u àmàntàtà ukyr ire. Nukyr kwaw àmàn a'e ywy rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Wexak Parao àmàn ipik awer. Wexak àmàntàtà ipik awer. Wexak àmàn iànoànog ire ipytu'u awer. Umume'u wi ikatu 'ym ma'e upy'a pe Tupàn henataromo. — Namuhem kar kwaw Tupàn hemiaihu xe wi ihe wà nehe, i'i tuwihawete. Hehe we har wama'enukwaw paw nuzawy kwaw ima'enukwaw paw. ");
INSERT INTO gubBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Wikuwe Tupàn Tuweharupi Wiko Ma'e heruzar 'ym pà a'e wà. Numuhem kar kwaw Izaew izuapyapyr a'e wi wà, Tupàn Tuweharupi Wiko Ma'e Moizez pe hemimume'u kwer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Na'e Tupàn Tuwihawete Wiko Ma'e uze'eg Moizez pe kury. — Eho Parao pe kury. Ta'e ama'ereko ipy'a pupe ihe xe. Ama'ereko tuwihaw hehe we har wapy'a pupe no. A'e rupi nuweruzar kwaw heze'eg wà nehe. A'e rupi apuner putar agwer purumupytuhegatu kar haw iapo haw rehe wanenataromo ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nezewe mehe pepuner heremiapo kwer imume'u haw rehe pena'yr wanupe nehe, penemimino wanupe nehe no. — Tupàn upuka Ezit ywy rehe har wanehe a'e. Uzapo purumupytuhegatu kar haw wanenataromo no, peze pena'yr wanupe nehe, penemimino wanupe nehe no. Nezewe mehe pekwaw putar pezar romo hereko haw nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","A'e rupi Moizez a'e, Àràw a'e no, uze'eg oho Parao pe a'e wà kury. — Tupàn Tuweharupi Wiko Ma'e Emerew wazar uze'eg nezewe newe kury. — Màràn 'ar eremumaw putar pezar 'ym romo hereko haw imume'u pà nehe. Emuhem kar heremiaihu xe wi ne wà nehe, ta'e ipurumuwete katu wer herehe muite xe wi a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Aze neremuhem kar kwaw ne wà nehe, arur putar tukur tetea'u xe peywy rehe pyhewe ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Upyk putar ywy wà nehe. Teko nuexak kwaw ywy wà nehe, ta'e heta tetea'u putar tukur hehe wà nehe xe. Aze àmàntàtà numuaiw kwaw amo temi'u nehe, tukur u'u putar a'e temi'u wà nehe. U'u putar ywyra peko pe har paw rupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Umynehem putar penàpuz wà nehe, umynehem putar penuwihaw wanàpuz wà nehe no, umynehem putar Ezit ywy rehe har wanàpuz paw rupi wà nehe no. Penu a'e wà, penàmuz a'e wà no, nuexak pixik kwaw agwer ma'e ko 'ar 'ym mehe we a'e wà. Ko ywy rehe wanur mehe we te ko 'ar rehe nuexak pixik kwaw agwer ma'e a'e wà, ere Parao pe nehe, i'i Tupàn Moizez pe. Umume'u oho izupe wà. A'e re uzewyr Moizez oho Parao wi kury. ");
INSERT INTO gubBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tuwihaw Parao rehe we har upuranu hehe a'e wà kury. — Màràn 'ar a'e awa umumaw putar ikatu 'ym ma'e zanewe iapo haw rehe upuner ma'e romo wiko pà a'e nehe. Emuhem kar a'e teko xe wi ne wà nehe ty. Tuwe umuwete katu uzar Tupàn Tuweharupi Wiko Ma'e a'e wà nehe. Umuaiw Ezit a'e. Aipo nerekwaw kwaw hemiapo kwer. Aipo nerexak kwaw imuaiw pawer, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Na'e amo werur wi Moizez Àràw rehe we Parao pe a'e wà kury. Uze'eg wanupe. — Peho Tupàn Tuwihawete Wiko Ma'e pezar imuwete katu pà nehe, i'i wanupe. — Mo oho putar wà nehe, i'i wanupe wanehe upuranu pà. ");
INSERT INTO gubBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Uze'eg Moizez Parao pe. — Ure oroho putar ure nehe. Urepurumuzàmuzàg oho putar wà nehe no. Ureràmuzgwer oho putar wà nehe no. Urera'yr oho putar wà nehe no. Urerazyr oho putar wà nehe no. Urereimaw àràpuhàràn hawitu ma'e oho putar wà nehe no. Urereimaw àràpuhàrànete oho putar wà nehe no. Urereimaw tapi'ak oho putar wà nehe no. Ta'e Tupàn Tuweharupi Wiko Ma'e uzapo kar mynykawhu urewe a'e xe. Urumuwete katu putar Tupàn mynykawhu iapo pà ure nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Uze'eg Parao kury. — Tuwe Tupàn Tuweharupi Wiko Ma'e wiko penehe we nehe. Aze mo amono kar penemireko penupi ihe wà nehe, aze mo amono kar pena'yr penazyr penupi ihe wà nehe, pezapo mo iaiw ma'e ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","A'e rupi xo awakwer zo oho putar wà nehe. Pemuwete katu Tupàn Tuweharupi Wiko Ma'e nehe, ta'e a'e ma'e penemiapo ràm penoz ihewe pe xe, i'i wanupe. Na'e zauxiapekwer weityk Moizez Àràw wamuzàn kar pà Parao henatar wi a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Epyho nepo Ezit ywy kutyr kury. Nezewe mehe tukur tetea'u uwewe putar wà ywy nànàn a'e wà nehe. Àmàntàtà umuaiw hezuz ma'e ko pe har tetea'u a'e. Tukur u'u putar ikurer a'e wà nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","A'e rupi Moizez upyho ywyra opokokaw Ezit ywy kutyr kury. Umur kar Tupàn Tuweharupi Wiko Ma'e ywytu kwarahy ihemaw wi kury. Ywytu nupytu'u kwaw a'e 'ar rehe. Nupytu'u kwaw pyhaw. Iku'egwer pe ywy tynehem tukur pupe, ta'e ywytu werur a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Uhàuhàz oho Ezit ywy nànàn wà. Heta tetea'u Ezit ywy nànàn wà. A'e 'ym mehe naheta pixik kwaw tukur waneta haw a'e 'ar mehe har zàwenugar. Naheta pixik kwaw amo 'ar mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Upyk ywy paw rupi wà. Te ywy ipihun. U'u temi'u àmàntàtà hemimumaw 'ygwer paw rupi wà. U'u ko pe har paw rupi wà. U'u ma'ywa 'yw i'a kwer paw rupi wà no. Ni amo huwyahy ma'e nupyta kwaw, ni ywyra rehe ni ka'a rehe, ni Ezit ywy nànàn. ");
INSERT INTO gubBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na'arewahy Parao wenoz Moizez Àràw rehe we uzeupe kury. — Ikatu 'ym ma'e azapo Tupàn Tuweharupi Wiko Ma'e pezar henataromo ihe, peme ihe no. ");
INSERT INTO gubBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Peneharaz wi heremiapo kwer wi nehe. Peze'eg Tupàn Tuweharupi Wiko Ma'e pezar pe nehe. — Emunàn ko ma'erahy iaiw ma'e Parao wi nehe, peze izupe nehe, i'i Parao wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Na'e uhem Moizez Parao hàpuzuhu wi kury, Tupàn Tuweharupi Wiko Ma'e pe uze'eg pà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Umupytu'u kar Tupàn ywytu kwarahy ihemaw wi ur ma'e kury. Umuhem kar ywytu kwarahy heixe haw wi kury. Ywytu weraha tukur paw Yryhupiràg pe wazuka pà 'y pupe wà. Nupyta kwaw ni pitài tukur Ezit ywy rehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nezewe rehe we Tupàn nuweruzar kar kwaw uze'eg Parao pe. A'e rupi Parao numuhem kar kwaw Izaew izuapyapyr a'e ywy wi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Epyho nepo Ezit ywy kutyr kury. Nezewe mehe ipytunahy putar nehe kury. Ipytunahy putar azeharomoete nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","A'e rupi upyho Moizez opo ywak kutyr. Ipytunahy tuwe kury. Umumaw na'iruz 'ar ipytunahy pà Ezit ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Teko nupuner kwaw amo teko hexakaw rehe wà. Nuhem kwaw wàpuz wi wà. Umumaw na'iruz 'ar kwarahy hexak 'ym pà wà. Nezewe rehe we Izaew izuapyapyr wà, weko haw nànàn upuner ma'e hexakaw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Parao wenoz wi Moizez Àràw rehe we kury. — Peho Tupàn Tuweharupi Wiko Ma'e imuwete katu pà nehe. Te penemireko wà, te pepurumuzàmuzàg wà no, upuner oho haw rehe penupi wà nehe. Xo peneimaw pezar xe penaikwer pe wà: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà, i'i Parao Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","— Uruzuka putar ma'ea'yr Tupàn Tuweharupi Wiko Ma'e urezar henataromo ure wà nehe. Uruapy putar ureremizuka kwer Tupàn Tuweharupi Wiko Ma'e imuwete haw romo ure wà nehe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","— A'e rupi urueraha putar urereimaw ure wà nehe no. Ni pitài upyta ureraikwer pe wà. Ta'e uruexaexak putar amogwemogwer Tupàn Tuweharupi Wiko Ma'e imuwete katu àwàm romo ure wà nehe xe. Xo a'e pe urehem mehe urukwaw putar ureremizuka ràm ure wà nehe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nezewe rehe we Tupàn Tuweharupi Wiko Ma'e uzapo wi uma'ereko haw Parao ipy'a pupe. A'e rupi na'ipureruzar wer kwaw ize'eg rehe. Na'ipurumuhem kar wer kwaw wanehe a'e wi. ");
INSERT INTO gubBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Uze'eg Parao Moizez pe. — Ehem eho herenatar wi kury ty. Ezewyr wi zo ezuwà nehe kury. Aze herexak pe amo 'ar mehe nehe, eremàno putar a'e 'ar mehe nehe kury, i'i Parao Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","— Tuwe uzeapo ma'e neze'eg rupi katete nehe. Nuruexak wi pixik kwaw ihe nehe, i'i Moizez Parao pe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Uze'eg Tupàn Tuwihawete Wiko Ma'e Moizez pe. — Heta we pitài ma'erahy haw heremirur ràm Parao pe nehe, Ezit ywy rehe har wanupe nehe. A'e re pemuhem kar putar xe wi a'e nehe. Pemuhem kar mehe nehe, pemono kar putar xe wi paw rupi a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A'e rupi eze'eg eho nezewe Izaew izuapyapyr wanupe nehe kury. — Peze'eg peho Ezit ywy rehe har wanupe penàpuz huwake wiko ma'e wanupe nehe, ere wanupe nehe. — Emur ma'e parat iapo pyrer ipuràg eteahy ma'e ihewe nehe kyn. Emur ma'e or iapo pyrer ipuràg eteahy ma'e ihewe nehe no kyn, peze wanupe nehe, a'e ma'e hekuzar katu ma'e henoz tà wanupe nehe, ere teko wanupe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Uma'ereko Tupàn Tuweharupi Wiko Ma'e Ezit ywy rehe har wapy'a pupe. A'e rupi Ezit ywy rehe har umuwete Izaew izuapyapyr wà. Azeharomoete Moizez ikatu tuwihawete pe uma'ereko ma'e wanupe, teko paw wanupe no. — Awa ikatu ma'e romo ikàg ma'e romo hekon a'e, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","A'e rupi Moizez uze'eg nezewe Parao pe kury. — Tupàn Tuweharupi Wiko Ma'e uze'eg iko nezewe newe kury. — Pyaze mehe akwaw putar aha Ezit ywy rehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Pitàitàigatu Ezit ywy rehe har wana'yr ipy umàno putar paw rupi wà nehe. Tuwihawete Parao ta'yr ipy a'e nehe, u imàno re tuwihawete romo wiko ma'e ràm a'e nehe, umàno putar a'e nehe. Te kuzà uma'ereko e ma'e arozràn imuku'i har imemyr awa ipy umàno putar a'e wà nehe no. Ma'ea'yr imemyr awa ipy paw umàno putar a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Teko paw uzai'oahy putar tuwe Ezit ywy nànàn wà nehe. Ko 'ar 'ym mehe we nuzai'o pixik kwaw nezewe wà. Ko 'ar henataromo nuzai'o pixik kwaw nezewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Izaew waneko haw pe nehe, ni zawar nahehem kwaw amo awa rehe amo ma'ea'yr rehe wà nehe. Nezewe mehe erekwaw putar Tupàn heko haw nehe. Werekoahy putar Ezit ywy rehe har wà nehe. Wereko katu putar Izaew izuapyapyr wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ko tuwihaw nerehe we har paw ur putar ihewe wà nehe. Uzemumew putar upenàràg rehe wapyk pà wà nehe. — Eho xe wi nehe, eraha teko neremiruze'eg paw nerupi ne wà nehe no, i'i putar ihewe wà nehe. A'e re ahem putar xe wi nehe, i'i Moizez Parao pe. Na'e Moizez wikwahy mehe uhem oho Parao wi a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Parao nuzeapyaka kwaw neze'eg rehe nehe. Nuzeruzar kwaw hehe nehe. Nezewe mehe aexak kar wera'u putar heremiapo ràm purumupytuhegatu kar àwàm Ezit ywy rehe àràm teko wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","A'e ma'e purumupytuhegatu kar haw Moizez uzapo Parao henataromo Àràw rehe we. Tupàn uzapo wi uma'ereko haw Parao ipy'a pupe. A'e rupi na'ipureruzar wer kwaw ize'eg rehe. A'e rupi numuhem kar kwaw Izaew izuapyapyr uiwy wi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe Àràw pe Ezit ywy rehe waneko mehe we kury. ");
INSERT INTO gubBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","— Ko zahy uzeapo putar zahy ipy romo peme nehe, zahy ipy pekwarahy zaikaikaw paw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Emume'u ko heze'eg Izaew izuapyapyr wanupe kury. — Ko zahy mehe nehe, 10 haw 'ar mehe nehe, awakwer pitàitàigatu upyhyk putar àràpuhàrànetea'yr wànàm wanupe a'e wà nehe, u, upyhyk putar àràpuhàràna'yr hawitu ma'e wànàm wanupe a'e wà nehe. Tàpuz me wiko ma'e paw upyhyk putar a'e àràpuhàrànetea'yr wà nehe, u, upyhyk putar a'e àràpuhàràna'yr hawitu ma'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Aze amo tàpuz me har naheta tete kwaw wà nehe, aze nupuner kwaw àràpuhàràna'yr paw i'u haw rehe wà nehe, tuwe uzemono'og oho amo ae tàpuz me har wàpuz huwake har wainuromo wà nehe. Wazemono'og mehe upuner i'u haw rehe paw rupi wà nehe. Tuwe pepapar penàpuz me har paw wà nehe. Nezewe pekwaw putar àràpuhàràna'yr ho'o kwer i'u pyràm nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Amume'u putar a'e àràpuhàràna'yr penemixak ràm wanexakaw xe ihe nehe. Tuwe wiko awa pitài kwarahy hereko har romo wà nehe, ikatu 'ymaw hereko 'ymar romo wà nehe. Pepuner àràpuhàràn hawitu ma'e wanexakaw rehe nehe. Pepuner àràpuhàrànete wanexakaw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Pezekaiw katu wanehe nehe. 14 haw 'ar mehe, kwarahy heixe etea'i mehe, pe Izaew izuapyapyr uzemono'og ma'e kwer pezuka putar a'e àràpuhàrànetea'yr paw pe wà nehe, u, pezuka putar a'e àràpuhàràna'yr hawitu ma'e paw pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Peraha wanuwykwer pixik imupiripirik pà ukenaw i'aromo nehe, izywyr rehe nehe no, tàpuz àràpuhàràna'yr ho'o kwer i'u àwàm me nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A'e 'ar mehe we pyhaw nehe, tuwe pe'u a'e àràpuhàràna'yr ho'o kwer tata pupe imihir pyrer nehe. Tuwe pe'u ka'akyr iro ma'e inuromo typy'ak imuapiruru kar 'ym pyrer inuromo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Pe'u zo ho'o kwer imihir pyr 'ym nehe. Pe'u zo ho'o kwer 'y pupe imupupur pyrer nehe. Pemihir tata 'aromo nehe: iàkàgwer, hetymàgwer, ipy'a kwer, hie kwer. ");
INSERT INTO gubBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pemonokatu zo ho'o kwer iku'egwer pe i'u pyràm romo nehe. Aze napepuner kwaw i'u haw rehe paw rupi nehe, peapy tata pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Pe'u putar nezewe nehe. Pemunehew pema'e nehe. Pemunehew pexapat pepy rehe nehe no. Pepyhyk pepokokaw pepo pe nehe no. A'e ma'e paw iapo mehe we pe'u na'arewahy nehe. Tupàn Tuweharupi Wiko Ma'e Pakuwa a'e mynykaw her romo. (-Tupàn zane'aromo ikwaw paw, i'i her zaneze'eg rupi.) Ta'e akwaw putar pe'aromo pezuka 'ym pà ihe nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","A'e 'ar mehe we pyhaw akwaw putar Ezit ywy rehe ihe nehe. Azuka putar wana'yr ipy paw rupi ihe wà nehe: awa wana'yr wà nehe, waneimaw wamemyr awa wà nehe no. Azepyk putar tupàn a'ua'u Ezit ywy rehe har nànàn ihe nehe, ta'e Tupàn Tuweharupi Wiko Ma'e romo aiko ihe xe, ma'e paw wazar romo aiko ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Àràpuhàràna'yr huwykwer ukenaw rehe har wexak kar putar heremiaihu romo peneko haw ihewe nehe. Aze huwykwer aexak nehe, akwaw putar pe'aromo hepytu'u 'ym pà nehe. Napepuraraw kwaw nehe, ma'erahy Ezit ywy rehe har wanupe ipuraraw kar mehe nehe. Nazuka kwaw pena'yr ipy wana'yr ipy wazuka mehe ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kwarahy nànàn nehe, pezapo mynykawhu ko 'ar rehe nehe. Pezuapyapyr uzapo putar mynykawhu ko 'ar rehe kwarahy nànàn wà nehe no. Pepytu'u zo iapo re nehe. Awyzeharupi pezapo nehe. Nezewe mehe pe nehe, pezuapyapyr a'e wà nehe no, pema'enukwaw putar ko heremiapo kwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pemumaw 7 'ar typy'ak imuapiruru kar pyr 'ym i'u pà nehe. 'Ar ipy mehe penuhem imuapiruru kar haw paw penàpuz wi nehe. 'Ar ipy mehe te 7 haw 'ar mehe nehe, aze amo u'u typy'ak imuapiruru kar pyrer nehe, nuiko kwaw Izaew izuapyr romo herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","'Ar ipy mehe pezemono'og hemuwete katu pà nehe. 7 haw 'ar mehe pezemono'og wi hemuwete katu pà nehe no. Pema'ereko zo a'e 7 'ar rehe nehe. Pepuner temi'u iapo haw rehe teko wanupe nehe. Xo a'e zo pepuner iapo haw rehe a'e 'ar mehe nehe. Napepuner kwaw amo ae ma'ereko haw iapo haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Pezapo mynykawhu nehe. — Typy'ak imuapiruru kar pyr 'ym, pemono a'e mynykaw pe her romo nehe. Ta'e a'e 'ar mehe apueraha putar Ezit ywy wi ihe nehe xe. Apueraha putar paw rupi ihe nehe. Pezapo mynykawhu ko 'ar rehe kwarahy nànàn nehe, awyzeharupi nehe. Pezapo kar pena'yr wanupe nehe. Pena'yr uzapo kar putar wa'yr wanupe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Zahy ipy rehe nehe, pezypyrog 14 haw 'ar mehe typy'ak imuapiruru kar pyr 'ym i'u pà nehe. Pe'u wiwi typy'ak imuapiruru kar pyr 'ym peho peiko te 21 haw 'ar mehe nehe. Pe'u zo typy'ak imuapiruru kar pyrer a'e 'ar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pemumaw 7 'ar typy'ak imuapiruru kar haw penàpuz me heta 'ym pà nehe. Aze amo u'u typy'ak imuapiruru kar haw amo temi'u inuromo wà nehe, Izaew izuapyapyr umuhem kar putar a'e teko uzemono'ogaw wi wà nehe. Aze wiko Izaew izuapyr romo nehe, aze nan kwaw nehe, zuawygatu nehe. Pemuhem kar wamono pezewi pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","A'e rupi, a'e 'ar mehe nehe, pe'u zo ma'e typy'ak imuapiruru kar haw inuromo nehe. Tàpuz nànàn u'u putar xo typy'ak imuapiruru pyr 'ym zo wà nehe, i'i Tupàn teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Na'e Moizez wenoz Izaew izuapyapyr waneruze'egar wamuwà uzeupe a'e wà kury. — Peho àràpuhàrànetea'yr, aze ru'u, àràpuhàràna'yr hawitu ma'e wanexanexak pà pe wà nehe, peànàm wanupe wamono pà pe wà nehe. Pezuka pe wà nehe. Nezewe mehe teko Izaew paw upuner pakuwa iapo haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pepyhyk ka'akyr ixop her ma'e nehe. Pemono'og àràpuhàrànetea'yr huwykwer, u, àràpuhàràna'yr hawitu ma'e huwykwer amo kawaw pupe nehe. Pemono a'e ka'akyr a'e huwykwer pupe nehe. A'e re pemupiripirik a'e huwykwer imono ukenaw i'aromo nehe, izywyr rehe nehe no, a'e ka'akyr pupe nehe. A'e re ni amo nuhem kwaw wàpuz wi pyhaw ipytun mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tupàn Tuweharupi Wiko Ma'e wata putar oho Ezit ywy nànàn nehe, wemizuka ràm wanekar pà nehe. Wata mehe wexak putar àràpuhàràn huwykwer ukenaw penàpuz me har rehe har nehe. Hexak mehe ukwaw putar pe'aromo nehe. Numuixe kar kwaw weko haw pe har zauxiapekwer zàwenugar puruzuka ma'e nehe, penàpuz pupe nehe. Nuzuka kwaw pena'yr wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Peruzar ko ze'eg nehe. Pema'enukwaw ko 'ar rehe awyzeharupi nehe. Pezuapyapyr ima'enukwaw putar ko 'ar rehe awyzeharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kwehe mehe Tupàn Tuweharupi Wiko Ma'e umume'u amo ywy peipy wanupe peneko àwàm romo. Amo 'ar mehe peixe putar a'e ywy rehe nehe. A'e pe pehem mehe pezapo mynykawhu ko àràpuhàrànetea'yr ho'o kwer i'u haw zàwenugar nehe, u, àràpuhàràna'yr hawitu ma'e ho'o kwer i'u haw zàwenugar nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","— Màràzàwe tuwe xiapo ko mynykawhu zane. Màràzàwe tuwe xi'u àràpuhàrànetea'yr ho'o kwer nezewe zane. Màràzàwe tuwe xi'u àràpuhàràna'yr hawitu ma'e ho'o kwer nezewe zane, i'i putar pena'yr peme wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nezewe penehe pepuranu mehe peze'eg nezewe wanupe nehe. — Xiuka àràpuhàrànetea'yr, u, xiuka àràpuhàràna'yr hawitu ma'e — Ezit ywy rehe urereko mehe, Ezit ywy rehe har wazuka mehe ukwaw Tupàn ureràpuz 'aromo a'e, urezuka 'ym pà a'e, peze wanupe nehe, i'i Moizez teko wanupe. Na'e teko uzemumew upenàràg rehe wapyk pà Tupàn hemiruze'eg romo weko haw hexak kar pà wà kury, Tupàn imuwete katu pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Izaew izuapyapyr weruzar a'e Tupàn ze'eg Moizez pe Àràw pe imume'u pyrer wà kury, iawy 'ym pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pyaze mehe Tupàn Tuweharupi Wiko Ma'e uzuka kar Ezit ywy rehe har wana'yr ipy pitàitàigatu a'e wà kury: tuwihawete Parao ta'yr ipy tuwihawete romo wiko ma'e ràm, zemunehew paw pe wiko ma'e wana'yr ipy wà no, ma'ea'yr wamemyr awa ipy wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Parao a'e, tuwihawete rehe we har a'e wà no, Ezit ywy rehe har paw a'e wà no, upu'àm pyhaw a'e wà kury. Uzai'o paw rupi uhapukaz tà wà. Naheta kwaw tàpuz ta'yr umàno ma'e kwer hereko 'ymar. ");
INSERT INTO gubBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","A'e 'ar mehe we pyhaw Parao wenoz kar Moizez Àràw uzeupe wà. — Pe ty wà, Izaew izuapyapyr paw wà no. Pehem peho xe wi heremiaihu wanuwi nehe ty wà. Peho Tupàn Tuweharupi Wiko Ma'e imuwete katu pà nehe ty wà, peneminozgwer rupi katete nehe ty wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Peraha peneimaw paw pe wà nehe: àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà, tapi'ak wà. Peho xe wi nehe, i'i Parao wanupe. — Emono neze'egatu Parao rehe nehe, peze pezar Tupàn pe nehe, i'i Parao Moizez wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ezit ywy rehe har uze'eg ahyahy Izaew izuapyapyr wanupe wà no. — Pezàn na'arewahy xe wi kury, ko ywy wi kury. Aze napeho kwaw nehe, ure paw urumàno putar ure nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","A'e rupi Izaew izuapyapyr uzeànàànàm ma'e paw upyhyk typy'ak imuapiruru kar pyrer 'ym imihir pyrer 'ym a'e wà kury. Omono kawawhu pupe wà. Uwàuwàn a'e kawawhu pàn pupe wà. Upir uwaxi'i rehe heraha pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Uzapo ma'e Moizez ze'eg rupi katete wà. — Emur ma'e parat iapo pyrer ipuràg eteahy ma'e ihewe nehe kyn. Emur ma'e or iapo pyrer ipuràg eteahy ma'e ihewe nehe no kyn, i'i wanupe. Wenoz kamir wanupe wà, wenoz topoz wanupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tupàn Tuweharupi Wiko Ma'e uma'ereko Ezit ywy rehe har wapy'a pupe a'e 'ym mehe a'e. A'e rupi Izaew izuapyapyr ikatu wanupe wà. A'e rupi omono waneminozgwer wanupe wà kury. A'e rupi weraha Ezit ywy rehe har wama'e hekuzar katu ma'e wanuwi wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Uzypyrog wata pà upy rehe Hamexe taw wi wà. Wata oho Xukot tawhu pe wà. Heta 600.000 awa a'e 'ar mehe wà. Heta kuzà wà no. Heta kwarearer wà, heta kuzàtàigwer wà no. Heta tua'uhez ma'e wà, heta ihya'uhez ma'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Amo ae teko tetea'u oho wanupi a'e wà no. Weraha ma'ea'yr tetea'u wanupi wà no: tapi'ak wà, àràpuhàràn hawitu ma'e wà, àràpuhàrànete wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Weraha ma'e typy'ak iapo pyràm uzeupi wà no. Upytu'u mehe uzapo typy'ak iapiruru 'ym ma'e wà kury. Naheta kwaw imuapiruru kar haw ipupe, ta'e Ezit ywy rehe har omono kar uiwy wi na'arewahy a'e wà xe. A'e rupi nupuner kwaw typy'ak imuhykaw rehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Izaew izuapyapyr a'e wà, a'e 'ym mehe umumaw 430 kwarahy Ezit ywy rehe wiko pà a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A'e 430 kwarahy pawire a'e 'ar mehe we Tupàn Tuweharupi Wiko Ma'e hemiaihu paw a'e wà, Izaew ta'yr wazuapyapyr paw a'e wà, uhem oho Ezit ywy wi a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tupàn ume'egatu ma'e nànàn a'e 'ar mehe pyhaw. Ume'egatu wemiaihu wamuhem kar katu pà Ezit ywy wi. A'e rupi kwarahy nànàn a'e 'ar mehe pyhaw nehe, tuwe Izaew izuapyapyr paw ima'enukwaw a'e uzeapo ma'e kwer rehe wà nehe. Nezewe mehe wazuapyapyr paw umuwete katu putar Tupàn a'e wà nehe no, awyzeharupi a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe Àràw pe kury. — Pe'aromo hekwaw pawer rehe pema'enukwaw mehe nehe, Pakuwa mynykawhu iapo mehe nehe, peruzar ko ze'eg nehe, ko ma'e heremiapo kar nehe. Ni amo Izaew 'ym nu'u kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Aze peme'eg kar amo awa uma'ereko e ma'e romo nehe, upuner i'u haw rehe nehe, aze pemonohok ipirera'i izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Izaew 'ym peinuromo amo 'ar imumaw par nupuner kwaw i'u haw rehe wà. Peme temetarer rehe uma'ereko ma'e nupuner kwaw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Tuwe pe'u penàpuz pupe imuhyk awer pe nehe. Peraha zo ho'o kwer penàpuz wi katu pe nehe. Pezuhaw zo ikagwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tuwe Izaew izuapyapyr paw u'u ho'o kwer wà nehe, a'e 'ar rehe uma'enukwaw pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Amo Izaew 'ym pepyr wiko ma'e nehe, aze ipuru'u wer hehe Tupàn Tuweharupi Wiko Ma'e imuwete pà wà nehe, pemonohok ipirera'i izuwi nehe. Pemonohok awa kwer hàpuz me har wapirera'i paw pe wà nehe no. Pemonohok kwarearer hàpuz me har wapirera'i paw pe wà nehe no. A'e re upuner i'u haw rehe Izaew ywy rehe uzexak kar ma'e kwer zàwe nehe. Upirera'i imonohok kar 'ymar nupuner kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nezewegatete pezapo peinuromo wiko ma'e nànàn nehe, pepyr uzexak kar ma'e kwer nànàn nehe, amo ae ywy rehe har peinuromo wiko ma'e nànàn nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Izaew izuapyapyr paw weruzar a'e ze'eg wà. Uzapo Tupàn Tuweharupi Wiko Ma'e Moizez pe Àràw pe hemiapo karer wà. ");
INSERT INTO gubBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A'e 'ar mehe Tupàn Tuweharupi Wiko Ma'e wenuhem Izaew izuapyapyr uzeànàànàm ma'e a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","— Pemonokatu Izaew wana'yr ipy paw ihewe pe wà nehe. Kuzà hie wi uhem ma'e kwer ipy paw wiko hema'e romo a'e wà: awa a'e wà, ma'ea'yr a'e wà no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Na'e uze'eg Moizez teko wanupe kury. — Pema'enukwaw katu ko 'ar rehe kwarahy nànàn nehe. Ta'e ko 'ar rehe pemuhem kar Tupàn Tuweharupi Wiko Ma'e Ezit ywy wi a'e xe, pema'erekoahy e awer wi a'e xe. Ta'e ikàg tuwe a'e xe. Nezewe rehe we pe'u zo temi'u ma'e imuapiruru kar haw inuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kutàri zahy Amim her ma'e rehe zahy pitài haw rehe pehem pezuwà Ezit ywy wi. ");
INSERT INTO gubBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Amo 'ar mehe Tupàn peneraha putar Kànàà izuapyapyr waiwy pe nehe, Etew izuapyapyr waiwy pe nehe no, Amohe ywy rehe har waiwy pe nehe no, Ewe izuapyapyr waiwy pe nehe no, Zepu izuapyapyr waiwy pe nehe no. Umume'u a'e ywy peipy wanupe peneko àwàm romo. Ikatuahy a'e ywy ma'etymaw romo. Heta tetea'u temi'u a'e pe. A'e pe peneraha mehe nehe, pema'enukwaw katu putar ko 'ar rehe nehe. Pezapo mynykawhu ko 'ar rehe ko zahy rehe kwarahy nànàn nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pemumaw 7 'ar typy'ak imuapiruru kar pyr 'ym i'u pà nehe. 7 haw 'ar mehe pezapo mynykawhu Tupàn imuwete katu pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pe'u typy'ak imuapiruru kar 'ym pyrer a'e 7 'ar rehe nehe. Tuwe teko nuexak kwaw ma'e typy'ak imuapiruru kar haw inuromo har peneko haw pe wà nehe. Tuwe teko nuexak kwaw ma'e typy'ak imuapiruru kar haw peiwy rehe a'e 'ar mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","A'e 'ar mehe peze'eg nezewe pena'yr wanupe nehe. — Azapo ko mynykaw nezewe ihe, ta'e Tupàn uzapo ikatu ma'e ihewe a'e xe, Ezit ywy wi hererur katu pà a'e xe, peze wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ko mynykaw nuzuawy kwaw ma'e pepo pe iàpixi pyrer nehe, penehàpykàg rehe iàpixi pyrer nehe. Nezewe mehe pemuma'enukwaw putar Tupàn ze'eg rehe pezemu'e àwàm rehe nehe. Pemume'u putar ize'eg nehe no. Tuwe pemume'u wiwi Tupàn ze'eg nehe. Ta'e Tupàn penerur Ezit ywy wi a'e xe, ukàgaw rupi a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","A'e rupi peruzar ko ze'eg ko 'ar rehe kwarahy nànàgatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Tupàn peneraha putar Kànàà ywy rehe nehe. Umur putar a'e ywy peme nehe. Kwehe mehe umume'uahy a'e ywy peipy wanupe peneko àwàm romo. ");
INSERT INTO gubBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","A'e 'ar mehe a'e ywy rehe peneko mehe nehe, pemono kwarer kuzà hie wi uzexak kar ma'e kwer ipy paw Tupàn pe pe wà nehe. Peneimaw awa uzexak ma'e kwer ipy paw wiko Tupàn ma'e romo a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Pemekuzar zumen awa uzexak kar ma'e kwer ipy amo àràpuhàràna'yr hawitu ma'e pupe nehe. Aze napemekuzar kwaw nehe, pezuhaw zumen iazu'yw nehe, izuka pà nehe. Pemur pena'yr ipy hekuzar heremimume'u kwer ihewe paw rupi nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Amo 'ar mehe pena'yr upuranu putar penehe wà nehe. — Màràzàwe tuwe pezapo ko mynykaw, i'i putar peme wà nehe. — Ukàgaw rupi Tupàn Tuweharupi Wiko Ma'e werur peipy Ezit ywy wi a'e wà, wama'erekoahy e awer wi a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Parao na'ipurumuhem kar wer kwaw wanehe. A'e rupi Tupàn Tuweharupi Wiko Ma'e uzuka Ezit ywy rehe har wana'yr ipy paw rupi wà: awa wà, ma'ea'yr wà no. A'e rupi azuka ma'ea'yr ihy hie wi uzexak kar ma'e kwer ipy Tupàn Tuweharupi Wiko Ma'e henataromo ihe wà. Amekuzar hera'yr ipy nezewe izupe ihe no, peze pena'yr wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A'e mynykawhu nuzawy kwaw ma'e nepo pe har ma'e nerenataromo har nehe, ma'e rehe nemuma'enukwaw kar pà nehe. Tupàn Tuweharupi Wiko Ma'e zanererur Ezit ywy wi a'e, ukàgaw rupi a'e. Zanema'enukwaw putar zanererur awer rehe nehe, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Umuhem kar Parao teko a'e wà. Wamuhem kar ire Tupàn nueraha kwaw Piri waiwy rupi. Waneraha awer ipukua'u wera'u, ta'e Tupàn uze'eg nezewe uzeupe a'e xe. — Amo 'ar mehe Piri ywy rehe har ur putar Izaew waàmàtyry'ym pà a'e wà nehe. A'e rupi Izaew izewyr wer mo Ezit ywy rehe wà. Naputar kwaw nezewe haw, i'i uzeupe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","A'e rupi Tupàn weraha wemiaihu amo ae pe rupi wà. Wahaw ywyxiguhu oho Yryhupiràg kutyr wà, ta'e heta pe ywyxiguhu myteromo har a'e xe. Ezit ywy wi oho mehe weraha takihepuku uzeupi wà. Aze mo amo uzàmàtyry'ym wà wà, upuner mo waàmàtyry'ymaw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moizez weraha Zuze ikagwer uzeupi. Ta'e kwehe mehe Zuze umume'u kar ukagwer heraha àwàm a'e xe, Izaew ta'yr wanupe a'e xe. Nezewe i'i a'e. — Tupàn pepytywàgatu putar a'e nehe. A'e 'ar mehe nehe, peraha hekagwer xe wi nehe, i'i Zuze wyky'yr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Na'e uhem oho Xukot wi wà kury. A'e wi uhem ire uzapo uker haw ywyxiguhu huwake Età ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","'Ar romo Tupàn Tuweharupi Wiko Ma'e wata wanenataromo ywàkun upu'àm ma'e romo waho àwàm hexak kar pà wanupe. Pyhaw wata wanenataromo tata upu'àm ma'e romo. Nezewe uhyape katu pyhaw. A'e rupi upuner wape ràm hexakaw rehe wà. Nezewe mehe upuner wata haw rehe pyhaw wà. Upuner wata haw rehe 'aromo wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","A'e ywàkun u'àm ma'e 'ar romo har noho pixik kwaw teko wanenatar wi. A'e tata u'àm ma'e pyhaw har noho pixik kwaw wanenatar wi. ");
INSERT INTO gubBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","— Eze'eg nezewe Izaew izuapyapyr wanupe nehe ty, i'i izupe. — Pezewyr xe wi Pi-Airot tawhu kutyr peho pà nehe ty wà. Pezapo pepytu'u àwàm henataromo nehe. A'e tawhu Miginow tawhu Yryhupiràg wamyter pe tuz a'e. Pezapo pepytu'u àwàm yryhu huwake nehe, Ma'aw Zepon tawhu huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Nezewe mehe Parao uze'eg putar uzeupe nezewe nehe. — Izaew izuapyapyr wata e waiko kwe rupi wà. Nukwaw kwaw oho àwàm wà, ta'e ukyze ywyxiguhu rehe wata àwàm wi a'e wà xe, i'i putar uzeupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","— Azapo putar hema'ereko haw Parao ipy'a pupe ihe nehe. A'e rupi oho putar Izaew wanaikweromo nehe, wapyhyk wi pà nehe. Nupyhyk kwaw wà nehe, ta'e azepyk putar hehe ihe nehe xe. Azepyk putar hemiruze'eg zauxiapekwer wanehe ihe nehe no. Nezewe mehe teko Ezit ywy rehe har ukwaw putar hekàgaw a'e wà nehe. Ukwaw putar teko wazar romo hereko haw a'e wà nehe no, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. A'e rupi Izaew izuapyapyr uzapo ma'e Tupàn ze'eg rupi katete a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Amo teko uze'eg oho Ezit ywy rehe har wanuwihawete pe wà. — Izaew izuapyapyr uzàn oho xe wi a'e wà, i'i izupe wà. A'e rupi Parao a'e, hehe we har tuwihawete a'e wà no, uze'egahy uzeupeupe wà kury. — Ma'e xiapo zane. Màràzàwe tuwe ximuhem kar xe wi zane wà, i'i uzeupeupe wà. — Ximuhem kar xe wi zane wà. A'e rupi nazapuner kwaw wamuma'ereko kar e haw rehe zanewe zane nehe kury, i'i ahyahy uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","A'e rupi umuhyk kar ywyramawa zauxiapekwer wanupe kury. Weraha wemiruze'eg zauxiapekwer paw uzeupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Weraha 600 ywyramawa ikatu wera'u ma'e uzeupi wà. Weraha inugwer ywyramawa Ezit rehe har paw uzeupi wà no, zauxiapekwer tetea'u waneraha pà wà no, wanuwihaw waneraha pà uzeupi wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Uzapo wi Tupàn Tuweharupi Wiko Ma'e uma'ereko haw Parao Ezit ywy rehe har wanuwihawete ipy'a pupe a'e kury. A'e rupi uzàn oho Izaew izuapyapyr wanaikweromo kury, zauxiapekwer paw waneraha pà uzeupi kury. Izaew izuapyapyr wata waiko ukyze 'ym pà a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ezit ywy rehe har weraha ma'e tetea'u oho mehe wà: kawaru Parao heimaw paw wà, zauxiapekwer kawaru kupe pe har paw wà no, zauxiapekwer ywyramawa pupe wata ma'e paw wà no. Paw rupi katete uzàn oho Izaew wanaikweromo wà. Uhem wanuwake wà. Yryhu iwyr Pi-Airot tawhu huwake, Ma'aw Zepo tawhu huwake wanekon Izaew a'e 'ar rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Uhem Parao Izaew wanuwake wemiruze'eg wanehe we wà kury. Izaew izuapyapyr ume'e zauxiapekwer wanehe wà. Wexak a'e Ezit ywy rehe har wà. — Ur waiko zanepyhyk pà a'e wà, i'i uzeupeupe wà. A'e rupi ukyze katu wanuwi wà. Uhapukaz Tupàn Tuweharupi Wiko Ma'e pe uze'eg pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Na'e uze'eg Moizez pe wà kury. — Màràzàwe tuwe urererur pe xe ywyxiguhu pe ne. Aipo naheta kwaw tywypaw zanetymaw uhyk ma'e Ezit ywy rehe zanewe, i'i urywahyahy izupe wà. — Iaiw ma'e erezapo urewe Ezit ywy wi urererur mehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","— Urerezar pe xe nehe. Tuwe uruma'ereko e Ezit ywy rehe har wanupe nehe, uru'e newe ure. Aze mo urupyta a'e pe wanupe uruma'ereko e pà, ikatu wera'u mo urewe. Urumàno putar xe ywyxiguhu rehe ure nehe kury, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nezewe rehe we uze'eg Moizez wemiaihu wanupe. — Pekyze zo nehe. Peiko ikàg ma'e romo nehe. Nezewe mehe pexak putar Tupàn Tuweharupi Wiko Ma'e ikàgaw nehe, ta'e pepyro putar a'e nehe xe. Ezit ywy rehe har kutàri har penemixak a'e wà nehe, uzeàmim putar a'e wà nehe. Napexak wi pixik kwaw pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tupàn uzàmàtyry'ym putar a'e zauxiapekwer penekuzaromo a'e wà nehe. Pepyta ma'e iapo 'ym pà nehe, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. — Màràzàwe tuwe erehapukaz iko ihewe. Emuata wi kar Izaew izuapyapyr wamono ne wà nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Eupir nepokokaw. Epyho nepo yryhu 'aromo. Nezewe mehe 'y uzemuza'ak putar mokoz pehegwer romo nehe. Nezewe mehe Izaew upuner putar yryhu hahaw paw rehe ywy ikàg ma'e rehe wata pà a'e wà nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ama'ereko putar Ezit ywy rehe har wapy'a pupe ihe nehe. A'e rupi oho putar Izaew wanaikweromo yryhu pupe wà nehe. Aexak kar putar hekàgaw nehe, iaiw ma'e iapo pà Parao pe nehe, hemiruze'eg zauxiapekwer wanupe nehe no, ywyramawa wanupe nehe, hemiruze'eg kawaru kupe pe har wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ezit ywy rehe har waneityk mehe ukwaw putar Tupàn Tuweharupi Wiko Ma'e romo hereko haw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Na'e amo Tupàn heko haw pe har ikàg ma'e a'e, zauxiapekwer Izaew izuapyapyr wanenataromo wata ma'e a'e, uzewyr wanaikweromo a'e kury. Ywàkun upu'àm ma'e a'e, Izaew wanenataromo har a'e, uzewyr wà wanaikwerupi a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Nezewe mehe ywàkun upyta Ezit ywy rehe har Izaew izuapyapyr wamyter pe kury. Pyhaw kury. A'e ywàkun upu'àm ma'e umupihun kar ywak Ezit ywy rehe har wanupe. Uhyape katu Izaew izuapyapyr wanupe. A'e rupi pyhaw Ezit ywy rehe har noho kwaw Izaew wakutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Na'e Moizez upyho opo yryhu 'aromo kury. Pyhaw Tupàn Tuweharupi Wiko Ma'e umuhem kar ywytuhu heruwà kwarahy ihemaw wi kury. Ywytuhu umumaw pytun gatu 'y 'yryhu pe har imunyryk pà. Umuzekwa ywy yryhu iwype har kury. Ikàg kury. Uzemuza'ak 'y mokoz pehegwer romo. ");
INSERT INTO gubBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","A'e rupi Izaew izuapyapyr u'yahaw ywy ikàg ma'e rehe wata pà wà. Aiha katu 'y wahurehe. Aiha katu 'y wawyze har rehe no. Wata 'y myter rupi ywy ikàg ma'e rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ezit ywy rehe har oho wanaikweromo wà. Kawaru Parao heimaw paw wà, zauxiapekwer kawaru ku'az har paw uma'e ywyramawa rehe we wà no, zauxiapekwer kawaru ku'az har paw wà no, wata oho ywy yryhu iwy pe har rehe wanaikweromo wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Izi'itahy Tupàn Tuweharupi Wiko Ma'e wapyk in a'e ywàkun rehe a'e tata upu'àm ma'e rehe. Ume'e zauxiapekwer Ezit ywy rehe har wanehe kury. Umukyzeahy kar tetea'u wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Zawaiw katu ywyramawa iata haw ta'e Tupàn Tuweharupi Wiko Ma'e umupyta kar iapu'a ma'e xe. Na'e Ezit ywy rehe har uze'eg uzeupeupe wà kury. — Zàzàn zaha Izaew wanuwi nehe kury ty wà, ta'e Tupàn Tuweharupi Wiko Ma'e zaneàmàtyry'ym iko a'e xe, wapytywà pà a'e xe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Na'e uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Epyho nepo yryhu 'aromo kury. Nezewe mehe 'y uzewyr putar Ezit ywy rehe har wamim pà nehe, ywyramawa wa'aromo nehe no, zauxiapekwer kawaru kupe pe har wa'aromo nehe no, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Upyho Moizez opo yryhu 'aromo kury. Kwarahy ihem etea'i mehe yryhu uzewyr wà kury. Ezit ywy rehe har uzeagaw 'y wi uhemaw rehe a'e 'ar mehe wà. Nezewe rehe we Tupàn Tuweharupi Wiko Ma'e omomor zauxiapekwer paw 'y pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Uzewyr 'y wà ywyramawa paw wapyk pà, zauxiapekwer kawaru ku'az har wapyk pà no. Zauxiapekwer Parao hemiruze'eg Izaew wanaikweromo oho ma'e kwer paw umàno yryhu pupe wà kury. Ni amo nuhem kwaw umàno haw wi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Izaew a'e wà, wahaw yryhu ywy ikàg ma'e rehe wata pà wà. 'Y aiha katu ma'e wahurehe hin a'e. 'Y aiha katu ma'e wawyze har rehe hin no. ");
INSERT INTO gubBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A'e 'ar mehe Tupàn Tuweharupi Wiko Ma'e upyro Izaew Ezit ywy rehe har wanuwi a'e wà. Izaew wexak Ezit ywy rehe har umàno ma'e kwer paw yryhu iwyr ywyxig rehe wanuz mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Wexak Izaew Tupàn ikàgaw a'e wà, ta'e uzuka Ezit ywy rehe har paw a'e wà xe. A'e rupi ukyze Tupàn Tuweharupi Wiko Ma'e wi wà kury. Uzeruzar hehe wà. Uzeruzar hemiruze'eg Moizez rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na'e Moizez a'e, Izaew izuapyapyr a'e wà no, uzegar Tupàn Tuweharupi Wiko Ma'e pe ko zegar haw imuzàg pà a'e wà kury. Azegar putar Tupàn Tuweharupi Wiko Ma'e pe nehe, ta'e weityk tuwe wàmàtyry'ymar a'e wà xe. Kawaru a'e wà, zauxiapekwer iku'az har a'e wà no, Tupàn weityk yryhu pupe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Tupàn Tuweharupi Wiko Ma'e wiko hepytywà har ikàg ma'e romo. Wiko hepyro har romo. Hezar romo hekon. Amume'u putar ikatu haw nehe. Heru izar romo hekon. Amume'u putar ikàgaw hezegar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Puruityk ma'e romo hekon. Tupàn Tuweharupi Wiko Ma'e her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ywyramawa Parao ima'e a'e wà, zauxiapekwer Parao hemiruze'eg a'e wà no, Tupàn weityk yryhu pupe a'e wà. Tuwihaw Parao rehe we har ikatu wera'u ma'e a'e wà, uzeapypyk Yryhupiràg pupe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","'Y ohoete ma'e upyk a'e wà. Wezyw 'y pupe ita zàwe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Nepo awyze har ikàg a'e, Tupàn Tuweharupi Wiko Ma'e. Teko wexak nekàgaw wà. Nepo awyze har, Tupàn, uhauhaw neàmàtyry'ymar wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nekàgahy haw rupi ereityk neàmàtyry'ymar ne wà. Nereikwahy haw nuzuawy kwaw tata, Wapy neàmàtyry'ymar ka'akyr ài. ");
INSERT INTO gubBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nepytuhemaw neapygwar wi uhem ma'e kwer umupu'àm 'y yryhu pe har. 'Y upu'àm ma'e nuzuawy kwaw pàrirogaw tàtà ma'e. 'Y yryhu iwype har tàtàahy neàmàtyry'ymar wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Neàmàtyry'ymar uze'eg nezewe a'e wà. Zaha putar wanaikweromo nehe. Xipyhyk putar zane wà nehe. Xipyhyk putar wama'e paw nehe. Xipyhyk putar wyzài wama'e heremimutar nehe. Apyhyk putar hetakihepuku nehe. Ximumaw putar zane wà nehe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nezewe rehe we erezupy ne. A'e rupi yryhu upyk neàmàtyry'ymar a'e wà. Wezyw ita ipuhuz katu ma'e xum her ma'e ài wà, yryhu uhua'u ma'e pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ma'enugar tupàn a'ua'u wiko ne ài a'e wà. Ma'enugar ikatu ne ài wà. Ma'enugar ikàg ne ài wà. Ma'enugar uzapo hexak pyr 'ym ne ài wà. Ma'enugar uzapo purumupytuhegatu kar haw ne ài wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Erepyho nepo awyze har ne. A'e rupi ywy omokon ureraikweromo ur ma'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Erezamutar katu neremiaihu ne wà. A'e rupi ereruze'eg putar neremipyro kwer ne wà nehe. Nekàgaw rupi ereraha putar a'e teko nereko haw ikatuahy ma'e pe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Teko amogwer ywy rehe har uryryryryz waiko ukyze pà wà. Piri ywy rehe har ukyze katu wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Enom ywy rehe har wanuwihaw a'e wà nehe, ukyze putar tuwe newi a'e wà nehe. Moaw ywy rehe har upuner ma'e a'e wà nehe, uryryryryz putar newi ukyze pà a'e wà nehe. Kànàà ywy rehe har paw uryryryryz waiko wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ma'e wi wakyze haw u'ar wanehe. Wexak nepuner haw uhua'u ma'e wà. Upytu'u uzemumyz 'ym pà ita ài wà. Te neremiaihu ukwaw waneko haw rupi wà. Neremipyro kwer wahaw waiwy wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ereraha putar neremiaihu a'e pe ne wà nehe. Eremuigo kar putar neremiruze'eg ywytyr nema'e rehe ne wà nehe, Ta'e erexak a'e ywytyr nereko haw romo ne xe. Ne ae erezapo a'e neràpuzuhu. ");
INSERT INTO gubBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Tupàn Tuweharupi Wiko Ma'e wiko putar tuwihawete romo tuweharupi nehe, awyzeharupi nehe, i'i a'e zegar haw Tupàn Tuweharupi Wiko Ma'e pe iapo pyrer. ");
INSERT INTO gubBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Izaew izuapyapyr wahaw yryhu ywy ikàg ma'e rehe wata pà wà. Kawaru Parao ima'e a'e wà, ywyramawa Parao ima'e a'e wà no, zauxiapekwer kawaru kupe pe har a'e wà no, iho wer zepe wanaikweromo yryhu rupi a'e wà. Tupàn Tuweharupi Wiko Ma'e weruzewyr 'y wa'aromo a'e. 'Y upyk a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Na'e amo kuzà Tupàn ze'eg imume'u har Mirià her ma'e a'e, Àràw heinyr a'e, upyhyk amo maraka opo pe a'e kury. Amogwer kuzà upyhyk maraka'i a'e wà no, upynyk pà izàwegatete a'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Nezewe uzegar Mirià. Zazegar Tupàn Tuweharupi Wiko Ma'e pe nehe. Ta'e wiko ywate a'e 'y. Weityk kawaru a'e wà. Weityk ikupe pe har a'e wà no. Yryhu pupe waneityk pà a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Na'e Moizez weraha Izaew izuapyapyr Yryhupiràg wi a'e wà kury. Wata oho ywyxiguhu Xur her ma'e rehe wà. Umumaw na'iruz 'ar ywyxiguhu rehe wata pà wà. Nuexak kwaw 'y wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mara pe uhem mehe nupuner kwaw 'y a'e pe har i'u haw rehe wà, ta'e iroahy a'e xe. A'e rupi Mara i'i teko izupe wà. — Iro, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","A'e rupi teko uze'egahy Moizez pe wà. — Ma'enugar 'y pupe urui'u putar nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Uze'eg Moizez Tupàn Tuweharupi Wiko Ma'e pe uwahy haw rupi kury. Tupàn Tuweharupi Wiko Ma'e wexak kar amo ywyra hàkàgwer Moizez pe. Weityk Moizez ywyra hàkàgwer 'y pupe. Hete katu 'y kury. A'e pe Tupàn Tuweharupi Wiko Ma'e omono amo uze'eg wanupe. Umume'u wemimutar wanupe. Wagaw Tupàn Izaew izuapyapyr a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Uze'eg nezewe wanupe. — Ihe Tupàn Tuweharupi Wiko Ma'e pezar romo aiko ihe. Apuraraw kar ma'eahy haw iaiw ma'e Ezit ywy rehe har wanupe ihe. Aze pezeapyaka katu heze'eg rehe nehe, aze pezapo heremimutar nehe, aze penu heremimume'u ràm nehe, napuraraw kar kwaw agwer ma'eahy haw peme ihe nehe. Ta'e pezar romo aiko ihe xe. Ta'e pemukatu har romo aiko ihe xe, i'i Tupàn teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Na'e uhem Erim pe a'e wà kury. Heta 12 ytyzuzàmaw a'e pe wà. Heta 70 ma'e'yw inaza 'yw zàwenugar a'e pe wà no. Uzapo upytu'u haw uker haw a'e pe 'y huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Izaew izuapyapyr paw uhem oho Erim wi a'e wà kury. Ezit ywy wi uhem ire umumaw pitài zahy wata pà wà. Umumaw amo 15 'ar wata pà wà. Amo ywyxiguhu Xin her ma'e a'e, Erim tawhu Xinaz ywytyr wamyter pe tuz a'e. Uhem a'e ywyxiguhu pe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Teko paw uze'eg zemueteahy Moizez pe Àràw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","— Aze mo Tupàn urezuka Ezit ywy rehe urereko mehe we ikatu wera'u mo urewe. A'e pe urereko mehe uruwapyk kawawhu huwake ure. Tynehem kawawhu ma'ero'okwer pupe. Heta tetea'u temi'u urewe. Uhyk urewe. Pe. Urererur pe xe ywyxiguhu rehe peà. Ure paw urumàno putar uremai'u 'ym pà urema'uhez tà ure nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. — Amu'ar kar putar typy'ak ywak wi peme ihe nehe kury. Tuweharupi teko uhem putar wàpuzràn wi a'e typy'ak a'e 'ar rehe i'u pyràm imono'og pà wà nehe. Nezewe agaw putar teko ihe wà nehe. Aze ru'u weruzar putar heze'eg wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","6 haw 'ar mehe omono'og putar mokoz 'ar rehe i'u pyràm imuhyk pà wà nehe, ta'e 7 haw 'ar mehe nomono'og kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","A'e rupi Moizez uze'eg Izaew wanupe Àràw rehe we kury. — Kutàri karuk mehe pekwaw putar Tupàn Ezit ywy wi penerur arer romo heko haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ku'em mehe pexak putar Tupàn Tuweharupi Wiko Ma'e hereko haw heny katu haw nehe, ta'e wenu peze'eg zemueteahy haw a'e xe. Nuruiko kwaw ikàg ma'e romo. Tupàn Tuweharupi Wiko Ma'e wiko pezar romo. Napeze'eg zemueteahy kwaw urerehe. Tupàn Tuweharupi Wiko Ma'e rehe peze'eg zemueteahy, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","— Pekwaw putar Tupàn Tuweharupi Wiko Ma'e romo heko haw nehe, ma'ero'okwer imur mehe peme karuk etea'i mehe nehe. Pekwaw putar pezar romo heko haw nehe, typy'ak imur mehe peme ku'em mehe nehe. Ta'e wenu uzehe peze'eg zemueteahy awer a'e xe. Ure nuruiko kwaw ikàg ma'e romo. Urerehe peze'eg zemueteahy mehe azeharomoete peze'eg zemueteahy Tupàn Tuweharupi Wiko Ma'e pezar rehe, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Na'e Moizez uze'eg Àràw pe kury. — Eze'eg eho Izaew izuapyapyr wanànàn nehe kury. — Pezur Tupàn Tuweharupi Wiko Ma'e henataromo nehe kury, ta'e wenu peze'eg zemueteahy awer a'e xe, ere wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Uze'eg Àràw oho Izaew wanànàn kury. Ize'eg mehe we teko ume'e ywyxiguhu kutyr wà. Tupàn heny katu haw uzexak kar a'e pe a'e ywàkun inuromo. ");
INSERT INTO gubBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Uze'eg Tupàn Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","— Aenu Izaew herehe waze'eg zemueteahy awer ihe. A'e rupi eze'eg nezewe wanupe nehe. — Karuk etea'i mehe pe'u putar ma'ero'okwer nehe. Ku'em mehe pe'u putar typy'ak nehe. Penewykàtà putar nehe. Nezewe mehe pekwaw putar Tupàn pezar romo hereko haw nehe, ere wanupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","A'e 'ar mehe we karuk etea'i mehe ur pykahu zàwenugar tetea'u waneko haw pe wà. Upyk waneko haw wà. Ku'em mehe zuwiri upyk waneko haw. ");
INSERT INTO gubBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Zuwiri ikàg ire amo ma'e pira pekwer zàwenugar uzexak kar ywyxiguhu rehe. Nuzawy kwaw 'ytàtà ywy rehe har. ");
INSERT INTO gubBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Izaew izuapyapyr wexak a'e ma'e wà. — Ma'e a'e, i'i uzeupeupe wà, ta'e nukwaw pixik kwaw wà xe. — Typy'ak penemi'u ràm Tupàn hemimur kwer a'e, i'i Moizez wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Nezewe i'i Tupàn Tuweharupi Wiko Ma'e iko peme. — Teko pitàitàigatu omono'og putar wemi'u ràm a'e 'ar mehe àràm wà nehe. Peraha mokoz zutahyky'a por teko penàpuz me har wanupe pitàitàigatu nehe, i'i Tupàn Tuweharupi Wiko Ma'e peme, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Izaew izuapyapyr weruzar a'e ze'eg a'e wà. Amo omono'og temi'u tetea'u wà. Amo omono'og temi'u pixik wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","A'e re upapar temi'u imono'og pyrer wà, kawaw pupe wà. Temi'u imono'og pyrer uhyk temi'u tetea'u imono'og arer wanupe. Temi'u imono'og pyrer uhyk temi'u pixika'i imono'og arer wanupe no. Uhyk katu teko wanupe pitàitàigatu. Naheta kwaw ikurer. Ni amo na'ima'uhez kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Na'e uze'eg wi Moizez teko wanupe. — Pe'u paw kutàri nehe. Pemonokatu zo temi'u pyhewe i'u pyràm romo nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Amo teko nuweruzar kwaw ize'eg wà. Omonokatu temi'u ikurer pyhaw wà, izi'itahy àràm romo wà. Iku'em mehe heta tetea'u merua'yr a'e temi'u rehe wà. Inem. Ipihe. Wikwahy Moizez ikwaw mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ku'em nànàn teko omono'og wemi'u ràm wà. Te uhyk wanupe. Ikurer upyta ywy rehe. Kwarahy haku mehe typyràn ukàzym pà ywy rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","6 haw 'ar mehe omono'og mokoz 'ar rehe àràm wà, 4 zutahyky'a por teko wanupe pitàitàigatu wà. Wanuwihaw ur Moizez pe a'e ma'e imume'u pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","— Tupàn Tuweharupi Wiko Ma'e uzapo kar nezewe haw a'e, i'i wanupe. — Pyhewe pepytu'u nehe. 'Ar pepytu'u haw pemonokatu ihewe nehe. A'e 'ar uzawy amogwer 6 'ar a'e. A'e rupi pema'ereko zo a'e 'ar rehe nehe. 6 haw 'ar rehe pemihir penemi'u ràm nehe, pemupupur penemi'u ràm nehe. Pemonokatu penemi'u ràm mytu'u 'ar rehe àràm pezeupe nehe, i'i Tupàn iko peme, i'i Moizez wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Weruzar ize'eg wà. Omonokatu temi'u ikurer a'e 'ar rehe wà. Iku'em mehe na'inem kwaw. Naheta kwaw merua'yr hehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","— Pe'u kutàri kury, i'i Moizez teko wanupe. — Ta'e kutàri mytu'u haw Tupàn Tuweharupi Wiko Ma'e pe a'e xe. A'e rupi naheta kwaw temi'u ywy rehe kutàri. ");
INSERT INTO gubBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","6 'ar rehe pemono'og temi'u nehe. 7 haw 'ar mehe mytu'u haw 'ar mehe naheta kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Amo teko uhem oho 7 haw 'ar mehe temi'u imono'og pà a'e wà. Nuexak kwaw wà. Naheta kwaw. ");
INSERT INTO gubBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Emume'u ko heze'eg teko wanupe nehe. — Màràn 'ar pemumaw putar heze'eg heremimume'u kwer heruzar 'ym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Pema'enukwaw katu ko ma'e rehe nehe. Apumupytu'u kar ihe. Amur mytu'u haw 'ar peme ihe. A'e rupi 6 haw 'ar mehe amono temi'u mokoz 'ar rehe àràm peme. Tuwe teko paw upyta wàpuz me 7 haw 'ar mehe wà nehe. Ni amo nuhem kwaw wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe, teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","A'e rupi teko upytu'u 7 haw 'ar mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Izaew izuapyapyr a'e wà,-Mana, i'i a'e typy'ak pe a'e wà. — Ma'e romo a'e, i'i her zaneze'eg rupi. Nuzuawy kwaw ma'eà'yzgwer xig ma'e pixika'i ma'e. Nuzuawy kwaw typy'ak hàir inuromo iapo pyrer. ");
INSERT INTO gubBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","— Tupàn Tuweharupi Wiko Ma'e uze'eg nezewe a'e, i'i Moizez teko wanupe. — Pemono'og mokoz zutahyky'a por nehe. Pemonokatu nehe. Nezewe mehe pezuapyapyr amo ae kwarahy rehe àràm upuner hexakaw rehe wà nehe. Nezewe mehe wexak putar typy'ak heremimono kwer wà nehe. — Tupàn Tuweharupi Wiko Ma'e omono 'àg temi'u ureipy wanupe a'e, Ezit ywy wi wanerur mehe a'e, ywyxiguhu rehe wata mehe a'e, i'i putar uzeupeupe wà nehe, i'i Tupàn wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","A'e rupi Moizez uze'eg Àràw pe. — Epyhyk amo kawaw nehe. Emynehem mokoz mana zutahyky'a por pupe nehe. Emuapyk a'e kawaw Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Teko omonokatu putar a'e kawaw por uzuapyapyr wanupe nehe. Hexak mehe wazuapyapyr ima'enukwaw putar uzar rehe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Weruzar Àràw Tupàn ze'eg Moizez pe imur pyrer. Omono a'e mana Tupàn Ze'eg Hyru henataromo kury, nezewe imonokatu pà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izaew izuapyapyr umumaw 40 kwarahy mana i'u pà wà. Ywy teko heta haw pe uhem mehe upytu'u i'u re wà. Kànàà ywy iwyr uhem mehe upytu'u i'u re wà. ");
INSERT INTO gubBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Tuweharupi teko omono'og pitài kawaw por uzeupe pitàitàigatu wà. Heta mokoz zutahyky'a por a'e kawaw pupe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Izaew izuapyapyr paw uhem oho ywyxiguhu Xin her ma'e wi a'e wà kury. Amo 'ar mehe upytu'u xe wà. Amo ae 'ar mehe upytu'u pe pe wà. Aze Tupàn Tuweharupi Wiko Ma'e umupytu'u kar amo me wà, upytu'u a'e pe wà. Amo 'ar mehe uzapo uker haw Hepinim pe wà. Naheta kwaw 'y a'e pe wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","A'e rupi teko uze'egahy Moizez pe wà. — Emur 'y urewe nehe, ta'e ureiwez ure no xe, i'i izupe wà. — Màràzàwe tuwe ereze'egahy ihewe. Màràzàwe tuwe peagaw Tupàn Tuweharupi Wiko Ma'e hereko, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Iziwez tuwe teko a'e pe wà. A'e rupi uze'egahy wiwi Moizez rehe uhapukaz tà wà. — Màràzàwe tuwe urererur pe Ezit ywy wi ne. Aipo urezuka putar pe ureiwez kar pà xe. Urera'yr ne wà nehe no, urereimaw àràpuhàrànete ne wà nehe, àràpuhàràn hawitu ma'e ne wà nehe no, aipo erezuka putar paw rupi katete xe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Uze'eg Moizez Tupàn Tuweharupi Wiko Ma'e pe wahy haw rupi upytywà àwàm henoz tà izupe kury. — Ma'e azapo putar ko teko wamurywete kar pà nehe. Nan kwehe tete ipuruzuka wer putar herehe ita imomor pyr pupe wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Eata teko wanenataromo nehe. Eraha amo tuwihaw nerupi ne wà nehe. Kwehe mehe erenupà Niru yrykawhu ywyra nepokokaw pupe ne. Eraha a'e ywyra nepokokaw nepo pe kutàri nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Erehem putar ezuwà amo itahu Orew her ma'e huwake nehe. A'e pe nehem mehe apu'àm putar nerenataromo itahu i'aromo Xinaz ywytyr rehe ihe nehe. Enupà a'e itahu nehe. 'Y uhem putar izuwi nehe. Teko upuner putar ipupe ui'u haw rehe wà nehe, i'i Tupàn izupe. A'e rupi Moizez weruzar a'e ize'eg oho kury, Izaew wanàmuzgwer wanenataromo kury. ");
INSERT INTO gubBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Omono Moizez mokoz her izupe. — Maxa, i'i izupe. — Merima, i'i izupe no. — Puragaw, i'i Maxa zaneze'eg rupi. — Ze'eg ahyahy haw, i'i Meripa zaneze'eg rupi. Ta'e Izaew izuapyapyr uze'eze'egahy Moizez pe a'e pe wà xe. Ta'e wagaw Tupàn Tuweharupi Wiko Ma'e a'e pe wà no xe. — Aipo Tupàn Tuweharupi Wiko Ma'e wiko zaneinuromo azeharomoete a'e, i'i uzeupeupe wà, uzehezehe upuranu pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Na'e teko Amarek izuapyapyr her ma'e uzàmàtyry'ym Izaew wà a'e wà kury, Hepinim pe waneko mehe a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Uze'eg Moizez Zuzue pe kury. — Exaexak amo awa ne wà nehe kury. Pyhewe izi'itahy eraha a'e awa Amarek izuapyapyr waàmàtyry'ym pà ne wà nehe. Pyhewe apu'àm putar ywytyr apyr ihe nehe, ywyra hepokokaw Tupàn pe imonokatu pyrer ipyhyk pà hepo pe ihe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","A'e rupi Zuzue uzàmàtyry'ym Amarek izuapyapyr oho a'e wà kury, Moizez ze'eg rupi katete a'e wà kury. Moizez a'e, Àràw a'e no, Ur a'e no, uzeupir oho ywytyr apyr a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Upir Moizez opo wàkàg 'aromo kury. Hupir mehe Izaew uzuka katu Amarek izuapyapyr wanereko wà. Opo imuezyw mehe Amarek izuapyapyr uzuka katu Izaew wanereko wà. ");
INSERT INTO gubBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ikene'o mehe Moizez nupuner kwaw opo imupyta kar haw rehe wàkàg 'aromo. A'e rupi hehe we har upyhyk amo ita wà kury. Umuapyk kar Moizez hehe wà. Àràw upyhyk ipo. Ur upyhyk ipo inugwer. Umupyta kar ipo iàkàg 'aromo wà. Te kwarahy wixe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nezewe mehe Zuzue a'e, zauxiapekwer Izaew izuapyapyr a'e wà no, weityk zauxiapekwer Amarek izuapyapyr a'e wà. (Uzuka zauxiapekwer tetea'u wà. Umuzàn kar wakurer wà.) ");
INSERT INTO gubBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. — Emuapyk ko ma'e uzeapo ma'e kwer imume'u haw pape rehe nehe. Nezewe mehe teko ima'enukwaw putar hehe wà nehe. — Tupàn umumaw putar tuwe Amarek izuapyapyr a'e wà nehe, ere Zuzue pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Uzapo Moizez amo ma'ea'yr hapy haw Tupàn Tuweharupi Wiko Ma'e henataromo a'e pe kury. — Amo zauxiapekwer waàmàtyry'ym mehe zauxiapekwer weraha pàn pehegwer uwihawete her hereko har uzeupi wà. Tupàn Tuweharupi Wiko Ma'e wiko a'e pàn pehegwer zàwenugar ihewe a'e, i'i. ");
INSERT INTO gubBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A'e re uze'eg nezewe. — Peupir katu pàn pehegwer Tupàn her hereko har ywate nehe. Tupàn Tuweharupi Wiko Ma'e uzàmàtyry'ym putar Amarek izuapyapyr tuweharupi wà nehe, i'i Moizez. ");
INSERT INTO gubBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Zetoro a'e, xaxeto Minià ywy rehe har a'e, wenu Moizez pe Izaew pe Tupàn hemiapo kwer paw imume'u awer a'e. Wenu Tupàn hemiapo kwer Ezit wi Izaew wapyro awer imume'u awer no. Moizez tatyw romo hekon. ");
INSERT INTO gubBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","A'e 'ym mehe we Moizez omono kar wemireko Zipora tu heko haw pe. Zetoro umuhem kar katu wazyr imuwà wàpuz me. Weraha Zipora mokoz Moizez ta'yr uzeupi u heko haw pe uzewyr mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Amo ta'yr a'e, Zeroxon her romo a'e. Ta'e — Amo ae ywy rehe har ài aiko ko ywy rehe ihe, i'i Moizez izexak kar mehe. — Amo ae ywy rehe har a'e ywy rehe wiko ma'e, i'i Zeroxon zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","— Eriezer inugwer ta'yr her romo. — Tupàn heru izar wiko hepytywà har romo a'e. Hepyro Parao wi a'e, nahezuka kar kwaw izupe a'e, i'i Moizez. A'e rupi omono Eriezer wa'yr her romo. — Tupàn hepytywà har, i'i Eriezer zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moizez tatyw Zetoro a'e, Moizez hemireko a'e no, ta'yr a'e wà no, ur hexak pà ywyxiguhu rehe heko mehe a'e wà kury. Ta'e upytu'u Moizez ywytyr Tupàn pe imonokatu pyrer huwake a'e xe. (Zetoro heko haw namuite kwaw a'e wi.) ");
INSERT INTO gubBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Omono kar Zetoro uze'eg Moizez pe kury. — Ihe ihe, neratyw Zetoro ihe, azur tuwà newe neremireko rupi mokoz imemyr wanupi ihe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","A'e rupi uwàxi Moizez watyw oho kury. Uzemumew upenàràg rehe wapyk pà henataromo imuwete pà. Uzurupyter. — Nekatu ty, nekatu ty, i'i uzeupeupe wà. Wixe tàpuzràn pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Umume'u Moizez Tupàn Tuweharupi Wiko Ma'e hemiapo kwer Parao pe arer Ezit ywy rehe arer parer paw watyw pe kury. — Tupàn uzapo a'e ma'e ta'e uzamutar katu teko Izaew izuapyapyr a'e wà xe, i'i izupe. Umume'u ma'erahy ipuraraw pawer pe rupi wata mehe arer paw izupe no. — Tupàn urepyro a'e ma'e nànàn a'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Hurywete tuwe Zetoro Tupàn hemiapo kwer ikatu ma'e paw henu mehe, ta'e Tupàn upyro Izaew Ezit ywy rehe har wanuwi a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","— Ikatuahy Tupàn Tuweharupi Wiko Ma'e, ta'e pepyro Ezit ywy rehe har wanuwi Parao wi a'e xe, i'i Zetoro izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","— Tupàn Tuweharupi Wiko Ma'e ikàg wera'u tupàn a'ua'u wanuwi a'e. Akwaw ikàg wera'u haw ihe kury. Ta'e upyro Izaew Ezit ywy rehe har wanuwi a'e wà xe. Ta'e Ezit ywy rehe har werekoahy Izaew a'e mehe a'e wà xe, i'i Zetoro. ");
INSERT INTO gubBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Na'e Zetoro Moizez tatyw werur amo ma'e hapy paw pyràm Tupàn henataromo kury. Uzuka amo ma'ea'yr henataromo wà no. Àràw a'e, Izaew izuapyapyr wanàmuzgwer paw a'e wà no, ur typy'ak i'u pà Moizez tatyw ipyr Tupàn henataromo a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Iku'egwer pe wapyk Moizez tuwihawete henaw rehe kury, pureruze'eg ma'e romo wiko pà teko wanupe kury. Teko tetea'u upu'àm huwake wà. Izi'itahy wiko a'e pe wà. Kwarahy heixe mehe wiko a'e pe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tatyw wexak ma'e teko wanupe Moizez hemiapo kwer paw a'e. Hexak mehe uze'eg nezewe izupe. — Màràzàwe tuwe erezapo agwer ma'e neremiaihu wanupe. Xo ne zo ereiko pureruze'eg ma'e romo wanupe. Teko tetea'u upyta xe neruwake wà, izi'itahy wà, te kwarahy heixe mehe wà, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Uze'eg Moizez izupe. — Azapo agwer ma'e ihe, wanemiapo kwer ikatu haw imume'u pà ikatu 'ymaw imume'u pà ihe, ta'e teko ur ihewe Tupàn hemimutar ikwaw pà a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Aze amo ipurumume'u wer amo ikatu 'ym ma'e rehe amo ae rehe, ur xe ihewe. Aenu wanemimume'u. Amupytu'u kar waàmàtyry'ym ire. Amume'u Tupàn ze'eg wanupe. Amume'u Tupàn hemimutar wanupe no, i'i Moizez watyw pe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Uze'eg wi Zetoro wàzywen pe. — Na'ikatu kwaw nezewe haw iapo haw. ");
INSERT INTO gubBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nekene'o wera'u putar nehe. Newe ma'e imume'u har ikene'o putar a'e wà nehe no. A'e ma'e iapo haw a'e nema'ereko haw ipuhuz katu wera'u putar newe nehe. Ne zutyka'i nerepuner kwaw a'e ma'e paw iapo haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ezeapyaka katu heze'eg rehe nehe kury. Amume'u katu putar neremiapo ràm newe ihe nehe kury. Nezewe mehe Tupàn wiko putar nerehe we a'e nehe. Ne ereiko teko wanekuzar har romo Tupàn henataromo. Eremume'u wanupe ikatu 'ym ma'e uzeapo ma'e kwer ne, Tupàn pe ne. ");
INSERT INTO gubBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Emume'u Tupàn ze'eg wanupe nehe. Emume'u Tupàn hemimutar wanupe nehe no. Emu'e waneko katu àwàm rehe ne wà nehe. Emu'e Tupàn pe wanemiapo ràm rehe ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Exaexak amo awa ma'e kwaw par ne wà nehe, teko wanehe we har ne wà nehe. Tuwe wiko Tupàn wi ukyze ma'e romo ikatu ma'e romo wà nehe. Tuwe wiko ma'e rehe imunar 'ym ma'e romo hemu'em 'ym ma'e romo wà nehe. Emuigo kar a'e awa teko waneruze'egar romo ne wà nehe. Aze heta 10 teko wà nehe, emuigo kar pitài awa waneruze'egar romo nehe. Aze heta 50 teko wà nehe, emuigo kar amo ae awa a'e 50 teko waneruze'egar romo nehe no. Aze heta 100 teko wà nehe, emuigo kar amo ae awa a'e 100 teko waneruze'egar romo nehe no. Aze heta 1.000 teko wà nehe, emuigo kar amo ae awa a'e 1.000 teko waneruze'egar romo nehe no. Imono'og pyr nànàn heta putar tuwihaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Emuigo kar a'e awa teko waneruze'egar romo ne wà nehe. Weruze'eg putar wemiruze'eg wanereko tuweharupi wà nehe. Aze amo zeàmàtyry'ymaw zawaiw katu wera'u wanupe nehe, tuwe werur newe wà nehe. Aze nazawaiw kwaw waneruze'egaw nehe, a'e ae umuàgà'ym putar wà nehe. Nezewe mehe upyhyk putar nema'ereko haw ikurer a'e wà nehe. Nezewe mehe erema'ereko wera'i nehe, nekene'o 'ym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Aze Tupàn uzapo kar nezewe haw iko newe, aze erezapo nehe, erepuner nema'ereko haw iapo haw rehe nehe. Nanekene'o kwaw nehe. A'e rupi teko hurywete putar wà nehe. Ta'e amo weruze'egatu a'e wà xe. Ta'e amo umuàgà'ym wama'e a'e xe, i'i tatyw Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Wenu Moizez watyw ze'eg. Uzapo ma'e ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Wexaexak amo awa ikatu ma'e Izaew izuapyapyr paw wanehe we har wà, pureruze'egar romo wamuigo kar pà wà: amo 1.000 teko waneruze'egar romo wà, amo 100 teko waneruze'egar romo wà no, amo 50 teko waneruze'egar romo wà no, amo 10 teko waneruze'egar romo wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","A'e awa weruze'eg wemiruze'eg waiko tuweharupi wà. Aze zawaiw katu amo wazeàmàtyry'ymaw imukatu haw, werur Moizez pe wà. Zawaiw 'ym ma'e a'e zutyka'i umuàgà'ym wà. ");
INSERT INTO gubBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na'e — Zazur rihi, i'i Moizez watyw pe hape rupi iho mehe. A'e rupi Zetoro uzewyr oho uiwy pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Izaew izuapyapyr oho Hepinim wi wà. Na'iruz haw zahy rehe 'ar ipy mehe Ezit ywy wi uhem ire uhem ywyxiguhu Xinaz her ma'e pe wà kury. Upytu'u a'e pe wà, uker haw iapo pà a'e pe wà, ywytyr Xinaz her ma'e izypy pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Na'e Moizez uzeupir oho ywytyr rehe Tupàn huwàxi pà kury. Tupàn Tuweharupi Wiko Ma'e uze'eg izupe ywytyr rehe uhapukaz tà. — Eze'eg nezewe Zako izuapyapyr wanupe nehe, Izaew izuapyapyr wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","— Pe ae pexak heremiapo kwer Ezit ywy rehe arer. Wyràhu weraha umemyr upepo wamytepe uwewe pà. Nezewegatete apuerur xe Ezit ywy wi ihe, xe heruwake ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Aze peruzar tuwe heze'eg nehe, aze pezapo tuwe heremimutar nehe, peiko putar tuwe heremiaihu ikatu ma'e romo nehe, amogwer teko wazàwe 'ym nehe. Aiko ywy paw izar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Nezewe rehe we peiko putar herenataromo har romo nehe. Apomonokatu putar teko ikatuahy ma'e romo ihe nehe, ere wanupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Emume'u ko heze'eg Izaew wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","A'e rupi wezyw Moizez ywytyr wi teko wanupe oho pà kury. Omono'og teko waneruze'egar paw uzeake wà. Umume'u Tupàn Tuweharupi Wiko Ma'e hemiapo putar paw a'e pureruze'eg ma'e wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Teko paw uze'eg izupe pitài 'ar mehe wà. — Uruzapo putar tuwe Tupàn Tuweharupi Wiko Ma'e hemimutar paw ure nehe, i'i izupe wà. A'e rupi umume'u Moizez waze'eg awer oho Tupàn Tuweharupi Wiko Ma'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","I'i Tupàn Moizez pe. — Ahem putar neruwake ywàkun ipihun ma'e pupe ihe nehe. Nezewe mehe teko wenu putar newe heze'eg mehe wà nehe. A'e rupi tuweharupi uzeruzar putar nerehe wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. Na'e Moizez umume'u teko wanemimume'u kwer Tupàn Tuweharupi Wiko Ma'e pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Uze'eg wi Tupàn Moizez pe kury. — Eze'eg eho teko wanupe kutàri nehe kury. — Kutàri, pyhewe nehe no, tuwe pezemukatu Tupàn imuwete haw rehe nehe. Pepyhez pema'e nehe no, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Tuwe wazemuàgà'ymaw uhyk putar wanupe pyhegwepe paw rupi nehe. Ta'e a'e 'ar mehe awezyw putar aha ywytyr Xinaz rehe ihe nehe, teko nànàn hezexak kar pà wanupe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Exak kar waho àwàm wanupe nehe. Exak kar waho 'ym àwàm wanupe nehe no. — Petyryk zo ywytyr huwake nehe, ere wanupe nehe. — Pezeupir zo ywytyr rehe nehe. Pepokok zo ywytyr izypy rehe nehe, ere wanupe nehe. — Aze amo teko opokok ywytyr rehe nehe, tuwe pezuka a'e teko nehe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Teko uzuka putar a'e teko ita tetea'u pupe iapiapi pà wà nehe. U, uzywà putar u'yw pupe wà nehe. Tuwe teko nopokok kwaw a'e teko rehe wà nehe. Aze awa opokok a'e ywytyr rehe wà nehe, aze ma'ea'yr uhyk a'e ywytyr rehe wà nehe, nupuner kwaw wikuwe haw rehe wà nehe. Àràpuhàràn awa i'ak kwer uxi'àm romo iapo pyrer ipy mehe nehe, xo a'e mehe zo teko upuner a'e ywytyr rehe uzeupir haw rehe wà nehe, i'i Tupàn. ");
INSERT INTO gubBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Uwezyw wi Moizez ywytyr wi kury, teko wapyr oho pà kury. Pezemuàgà'ym Tupàn imuwete katu àwàm rehe nehe, i'i teko wanupe. Upuez ukamir wà, upuez wopoz wà. ");
INSERT INTO gubBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Na'e uze'eg wi Moizez teko wanupe kury. — Pezemuàgà'ym pekatu àwàm iku'egwer pe àràm rehe nehe. Peker zo penemireko wapuhe nehe. Peker zo pemen wapuhe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na'iruz haw 'ar mehe iku'em mehe amo ywàkun uzexak kar ywytyr rehe kury. Wànoànog. Uwerawerawahy a'e no. Teko wenu amo ma'e'ak kwer xi'àm romo iapo pyrer ipyahy mehe wà. Teko a'e pe har paw uryryryryz wà. ");
INSERT INTO gubBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Na'e Moizez weraha teko wapytu'u haw wi wà kury, Tupàn huwàxi mà wà kury. Upyta ywytyr izypy huwake upytu'u pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Xinaz ywytyr paw umuhem kar tàtàxiner a'e, ta'e Tupàn Tuweharupi Wiko Ma'e uwezyw hehe tata inuromo a'e xe. Tàtàxiner uzeupir izuwi tatahu wi uhem ma'e kwer ài. Ywytyr paw uryryryryz. ");
INSERT INTO gubBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Na'e upyahy wera'u ma'e i'ak kwer xi'àm romo iapo pyrer. Na'e uze'eg Moizez a'e kury. A'e re Tupàn uwazar ize'eg izupe ànoànogaw inuinuromo. ");
INSERT INTO gubBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Uwezyw Tupàn Tuweharupi Wiko Ma'e wà ywytyr Xinaz iapyr kury. Wenoz Moizez uzeupe, — Ezur ywytyr apyr kury, u'e pà izupe. A'e rupi uzeupir Moizez. ");
INSERT INTO gubBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Ewezyw teko wapyr nehe, wanupe neze'eg pà nehe. — Peho zo ywytyr huwake Tupàn hexak pà nehe ty wà. Aze amo oho wà nehe, a'e mehe umàno putar wà nehe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","— Te xaxeto a'e wà nehe no, tuwe uzemukatu ihewe uzemonokatu pà a'e wà nehe no. Aze nuzemukatu kwaw wà nehe, azuka putar ihe wà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Uze'eg Moizez Tupàn Tuweharupi Wiko Ma'e pe. — Teko nupuner kwaw Xinaz rehe uzeupir haw rehe wà nehe. — Amonokatu 'àg ywytyr ikatuahy ma'e romo ihe. Pemuwete nehe, ere urewe. — Exak kar waho àwàm teko wanupe nehe, ere ihewe. — Tuwe teko noho kwaw neremixak karer ikupe pe wà nehe, ere ihewe, i'i Moizez Tupàn Tuweharupi Wiko Ma'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","I'i Tupàn Tuweharupi Wiko Ma'e izupe. — Ewezyw nehe. Ezewyr Àràw herur pà nehe. Xaxeto a'e wà, teko a'e wà no, nupuner kwaw ywytyr huwake ur haw rehe heruwake uhem pà wà nehe. Aze ur wà nehe, azuka putar ihe wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","A'e rupi Moizez uwezyw wi teko wanupe kury. Umume'u a'e Tupàn ze'eg awer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tupàn uze'eg nezewe a'e, uze'eg imume'u pà Moizez pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","— Aiko Tupàn Tuweharupi Wiko Ma'e pezar romo ihe. Apuerur Ezit ywy wi ihe. Peiko uma'ereko e ma'e romo a'e ywy rehe har wanupe. Apupyro wanuwi. ");
INSERT INTO gubBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Hemuwete katu pe nehe. Pemuwete zo amo tupàn a'ua'u herekuzaromo pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Pezapo zo ma'e hagaw paw nehe: ni ywak rehe har hagapaw, ni ywy rehe har hagapaw, ni 'y pe har hagapaw. ");
INSERT INTO gubBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Peapyk zo penàràg rehe ma'e hagaw paw henataromo nehe, imuwete katu pà nehe. Ta'e ihe Tupàn Tuweharupi Wiko Ma'e pezar romo aiko ihe xe. Naputar kwaw amo tupàn pezar romo ihe wà. Aze amo na'iakatuwawahy kwaw herehe wà nehe, azepyk putar wanehe nehe. Azepyk putar wana'yr wanehe nehe. Azepyk putar wanemimino wanehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Aze amo heamutar katu wà nehe, aze weruzar heze'eg wà nehe, azamutar katu ta'yr ihe wà nehe, azamutar katu hemimino ihe wà nehe no. Azamutar katu putar izuapyapyr te 1.000 haw ihe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Peze'eg zemueteahy zo herer imume'u mehe nehe, ta'e aiko Tupàn Tuweharupi Wiko Ma'e pezar romo ihe xe. Aze amo numuwete kwaw herer wà nehe, azepyk putar wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Pema'enukwaw katu mytu'u haw 'ar rehe nehe. Pemonokatu ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Pemumaw 6 'ar pema'ereko pà nehe, pema'ereko haw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","7 haw 'ar pemonokatu ihewe mytu'u haw 'ar romo nehe, ta'e aiko Tupàn pezar romo ihe xe. A'e 'ar mehe pema'ereko zo nehe. Ni pe, ni pena'yr wà, ni penazyr wà, ni peme uma'ereko e ma'e awa wà, ni peme uma'ereko e ma'e kuzà wà, ni peneimaw wà, ni amo ae ywy rehe har peinuromo wiko ma'e wà. Pemuma'ereko kar zo a'e 'ar mehe pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ta'e amumaw 6 'ar ma'e paw iapo pà ihe xe: ywak, ywy, yryhu, ywak rehe har paw wà, ywy rehe har paw wà, yryhu rehe har paw wà. 7 haw 'ar mehe apytu'u waapo re. A'e rupi amonokatu mytu'u haw 'ar. Amonokatu hezeupe no. Amupytu'u kar teko a'e 'ar mehe ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Pemuwete penu pehy wanehe we pe wà nehe. Nezewe mehe ipukua'u putar peneko àwàm ywy peme heremimur e ràm rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Pepuruzuka zo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Peker zo penemireko 'ym wapuhe nehe, peker zo pemen 'ym wapuhe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Pemunar zo ma'e rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Penemu'em zo amo pe penapi har hemiapo kwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Penewyrowyroahy zo penapi har hàpuz rehe nehe. Peputar zo penapi har hemireko nehe. Peputar zo hemiruze'eg uma'ereko e ma'e awa nehe. Peputar zo hemiruze'eg uma'ereko ma'e kuzà nehe. Peputar zo heimaw tapi'ak nehe. Peputar zo heimaw zumen nehe. Peputar zo wyzài ima'e nehe. Upaw Tupàn ze'eg teko wanupe imume'u pyrer xe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Teko wenu ywytyruhu iànoànog mehe. Wexak iweraweraw mehe wà. Wenu ma'e'ak kwer xi'àm romo iapo pyrer ipy mehe wà. Wexak tàtàxiner ywytyr ipyk mehe wà. A'e rupi uryryryryz ukyzeahy pà wà. A'e rupi upyta pepa'i muitea'i izuwi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Uze'eg Moizez pe wà. — Aze eze'eg urewe nehe, uruzeapyaka katu putar neze'eg rehe nehe. Aze Tupàn uze'eg urewe nehe, urumàno putar nehe, i'i izupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Uze'eg Moizez teko wanupe. — Pekyze zo nehe. Tupàn ur penagaw pà a'e. Nezewe mehe hehe pekyze haw upyta putar pepy'a pe nehe. Nezewe mehe napezapo kwaw ikatu 'ym ma'e nehe. Napezapo kwaw hemimutar 'ym nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Upyta teko muite ywytyr wi wà. Xo Moizez zo utyryk oho wanuwi ywytyr kutyr, ywàkun ipihunahy ma'e Tupàn heko haw huwake uhem pà. ");
INSERT INTO gubBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Na'e uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Emume'u ko heze'eg Izaew wanupe nehe. — Aze'eg peme ywak wi ihe. Pexak heze'eg mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Pezapo zo tupàn a'ua'u pe wà nehe. Pemuwete zo herekuzaromo pe wà nehe. Pemuapu'a zo parat tupàn a'ua'u iapo pà nehe. Pemuapu'a zo or tupàn a'ua'u iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Pema'ema'e ywy ma'ea'yr hapy haw iapo pà herenataromo nehe. Pezuka ma'ea'yr hehe wanapy pà pe wà nehe: àràpuhàràn hawitu ma'e wà, tapi'ak wà. Pezuka a'e ma'ea'yr herenataromo pe wà nehe. Nezewe mehe nazepyk kwaw penehe nehe. Amuawate katu kar putar herer peme ywy nànàn ihe nehe. Aze pemuawate katu herer nehe, wyzài taw pe wyzài ywy rehe nehe, azur putar pepyr nehe. Amume'u putar heze'egatu peme nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Aze pema'ema'e ita ma'ea'yr hapy haw romo iapo pà herenataromo nehe, pemugamugaz zo ita imoxorokaw pupe nehe. Ta'e aze pemugamugaz a'e ita nehe, pemuaiw putar nehe. Na'ikatu kwaw a'e ita ihewe nezewe mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Pezapo zo myromyrogaw ma'ea'yr hapy haw ipehegwer rehe. Nezewe mehe teko nuexak kwaw temyhar 'ym ma'e romo peneko haw a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","— Emume'u ko heze'eg teko wanupe nehe kury, i'i Tupàn Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Aze ereme'eg kar amo uma'ereko e ma'e nehe, aze Emerew romo hekon a'e nehe, umumaw putar 6 kwarahy newe uma'ereko pà a'e nehe. 7 haw kwarahy mehe emuhem kar newe ima'ereko e haw wi nehe. Erepytu'u putar izar romo nereko re nehe. Uzar romo wiko putar a'e nehe. Enoz zo temetarer izupe hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Aze wiko hemireko 'ym ma'e romo newe ur mehe nehe, a'e zutyka'i oho putar newi imuhem kar mehe nehe. Aze wiko hemireko ma'e romo ur mehe nehe, weraha putar wemireko newi oho mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Aze izar omono amo kuzà izupe hemireko romo nehe, aze hemireko omono ta'yr izupe nehe, aze omono tazyr izupe nehe, a'e kuzà a'e nehe, imemyr a'e wà nehe no, wiko putar izar pe uma'ereko e ma'e romo a'e wà nehe. Xo imen zo uhem putar uzar wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","— Azamutar hezar ihe, azamutar katu heremireko ihe no, azamutar katu hera'yr herazyr wanehe we ihe wà no. Nahehem wer kwaw hezar wi nehe, aze i'i a'e awa nehe, ");
INSERT INTO gubBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","a'e mehe izar weraha putar tàmuzgwer wanenataromo nehe. A'e pe izar weraha a'e awa Tupàn imuwete haw pe nehe. Umunyryk putar inami uken rehe nehe, u, izypy ikokaw rehe nehe. Ukutuk putar inami takihe pixik pupe nehe. A'e re a'e awa wiko putar uzar pe uma'ereko e ma'e romo awyzeharupi nehe. Xo umàno re zo upytu'u putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Aze amo awa ume'eg wazyr amo pe uma'ereko e ma'e romo a'e nehe, tazyr nuhem kwaw uzar wi awa ài a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Aze na'ikatu kwaw uzar pe nehe, izar ume'eg wi putar tu pe nehe. Izar nupuner kwaw ime'egaw rehe amo ae ywy rehe har pe nehe, ta'e nuwereko katu kwaw a'e kuzà a'e xe. Ikatu 'ym ma'e romo wiko a'e kuzà pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Aze ume'eg kar a'e kuzà wa'yr pe hemireko romo nehe, tuwe wereko katu wazyr zàwegatete nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Aze upyhyk amo ae kuzà wemireko romo nehe, tuwe omono wiwi temi'u wemireko ipy pe izypy mehe arer zàwe nehe. Tuwe omono wiwi ima'e izupe izypy mehe arer zàwe nehe no. Nupytu'u kwaw hemireko romo wiko re. ");
INSERT INTO gubBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Aze nomono kwaw a'e na'iruz ma'e wemireko ipy pe nehe, tuwe umuhem kar uzewi nehe. Tuwe nuenoz kwaw temetarer izupe nehe, ima'ereko e haw wi ihemaw hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Aze amo umugaz amo nehe, aze a'e re imugaz pyrer umàno nehe, tuwe pezuka izuka arer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nezewe rehe we aze amo uzuka amo nehe, aze na'ipuruzuka wer kwaw hehe nehe, izuka arer upuner ma'ea'yr hapy haw pe uzànaw rehe nehe. Ihe Tupàn ihe, amume'u putar iho àwàm ihe nehe. Wiko putar izuka 'ym pyràm romo a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Aze amo wikwahy amo pe nehe, aze ipuruzuka wer amo rehe nehe, aze a'e re uzuka tuwe nehe, aze uzàn ma'ea'yr hapy haw pe uzepyro pà nehe, nezewe rehe we peraha izuka arer ma'ea'yr hapy haw wi nehe, pezuka nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Aze amo upetek u nehe, aze upetek uhy nehe, pezuka a'e teko nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Aze amo upyhyk amo ae teko nehe, aze a'e re ume'eg a'e teko amo pe uma'ereko e ma'e romo nehe, pepyhyk ipyhyk arer nehe, pezuka nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Aze amo uze'egaiw u rehe uhy rehe nehe, pezuka uze'egaiw ma'e kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Aze teko uzàmàtyry'ym wà nehe, aze amo uzapi amo ita pupe nehe, aze ukwar opo pupe nehe, aze a'e re iapi pyrer numàno kwaw nehe, aze umumaw màràn 'ar uker haw wi uhem 'ym pà nehe, ");
INSERT INTO gubBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","aze a'e re uhem uker haw wi nehe, wata pà ywyra opokokaw heraha pà nehe, pezuka zo iapi arer hehe ukwar ma'e kwer nehe. Iapi pyrer umumaw màràn 'ar uma'ereko 'ym pà. A'e rupi iapi arer omono putar temetarer izupe nehe, ipytu'u haw imekuzar pà nehe. Upytywà putar wemiapi kwer nehe, te ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","21","Aze amo awa unupànupà uzeupe uma'ereko e ma'e a'e nehe, aze a'e uma'ereko e ma'e umàno a'e re nehe, pezepyk izar rehe nehe. Aze numàno kwaw a'e 'ar mehe nehe, aze xo amo 'ar pawire zo umàno nehe, pezepyk zo izar rehe nehe, ta'e uma'ereko e ma'e imàno haw nuzawy kwaw zepykaw izar pe xe. Pezapo nezewegatete haw uma'ereko e ma'e kuzà wanupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Aze awa uzeàmàtyry'ym waiko wà nehe, aze a'e mehe ukwar amo kuzà ipuru'a ma'e rehe wà nehe, aze imemyr uzexak kar u'ar 'ym mehe we umàno pà a'e nehe, aze kuzà na'ima'eahy kwaw nehe, imen wenoz putar temetarer hehe ukwar ma'e kwer pe nehe. Tàmuzgwer umume'u putar hekuzar wanupe nehe. Hehe ukwar ma'e kwer omono putar temetarer izupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Aze a'e kuzà ima'eahy tuwe a'e zeàmàtyry'ymaw wi nehe, — Umàno putar ru'u aipo, aze amo hehe uzekaiw ma'e i'i izupe nehe, pezepyk hehe ikwar ma'e kwer wanehe nezewe nehe: aze umàno nehe, pezuka izuka arer pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Aze umuaiw heha nehe, pemuaiw ukwar ma'e kwer heha nehe. Aze umuaiw hàz nehe, pemuaiw ukwar ma'e kwer hàz nehe. Aze umuaiw ipo nehe, pemuaiw ukwar ma'e kwer ipo nehe. Aze umuaiw ipy nehe, pemuaiw ukwar ma'e kwer ipy nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Aze wapy nehe, peapy hapy arer pe nehe. Aze ukixi nehe, pekixi ikixi arer nehe. Aze umugaz nehe, pemugaz imugaz tarer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","Aze amo izar umuaiw uma'ereko e ma'e heha nehe, u awa nehe, u kuzà nehe, tuwe izar umuhem kar a'e uma'ereko e ma'e nehe, heha hekuzaromo nehe. Aze amo uhaw uzeupe uma'ereko e ma'e awa hàz izuwi nehe, aze uhaw kar kuzà hàz izuwi nehe, tuwe umuhem kar a'e uzeupe uma'ereko e ma'e nehe, hàz hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Aze amo tapi'ak ukutuk amo awa u'ak pupe nehe, aze ukutuk amo kuzà u'ak pupe nehe, aze a'e ikutuk pyrer umàno nehe, pezuka a'e tapi'ak iapiapi pà ita tetea'u pupe nehe. Ni amo nu'u kwaw ho'o kwer wà nehe. Pezepyk zo tapi'ak izar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nezewe rehe we aze tapi'ak wiko purukutuk ma'e romo nehe, aze izar ukwaw heko haw nehe, aze a'e re numunehew kwaw nehe, aze a'e tapi'ak uzuka amo awa nehe, u uzuka amo kuzà nehe, pezuka tapi'ak iapiapi pà ita tetea'u pupe nehe. Pezuka izar nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Aze peputar nehe, izar upuner weko haw imekuzar haw rehe nehe. Pemume'u hekuzar izupe nehe. Umur putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Aze tapi'ak uzuka kwarer nehe, aze uzuka kuzàtài nehe, pezapo ma'e izar pe ko ze'eg rupi katete nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Aze tapi'ak ukutuk awa uma'ereko e ma'e u'ak pupe nehe, aze ukutuk kuzà uma'ereko e ma'e u'ak pupe nehe, a'e uma'ereko e ma'e izar upyhyk putar amo parat nehe. Heta putar 340 kàràm a'e parat ipuhuz taw nehe. Pezuka tapi'ak iapiapi pà ita tetea'u pupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Aze amo wenuhem ytyzuzàmaw iwàpytymaw izuwi nehe, aze ru'u uzapo amo ytyzuzàmaw nehe, aze a'e re nomono kwaw iwàpytymaw i'aromo nehe, aze a'e re amo tapi'ak aze ru'u amo zumen u'ar ipupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","a'e mehe ytyzuzàmaw izar omono putar a'e ma'ea'yr hekuzar a'e ma'ea'yr izar pe nehe. A'e re wiko a'e ma'ea'yr umàno ma'e kwer izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Aze amo awa heimaw tapi'ak ukutuk amo ae awa heimaw tapi'ak u'ak pupe nehe, aze ikutuk pyrer umàno nehe, peme'eg tapi'ak wikuwe ma'e nehe. Pemuza'aza'ak hekuzarer mokoz pehegwer romo nehe. Pemono pitài pehegwer a'e mokoz awa wanupe pitàitàigatu nehe. Pemuza'aza'ak tapi'ak umàno ma'e kwer ho'o kwer mokoz pehegwer romo nehe no, pitài pehegwer a'e mokoz awa wanupe imono pà pitàitàigatu nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","— Tapi'ak purukutuk ma'e a'e, ma'e kutuk ma'e a'e, aze teko i'i a'e tapi'ak wikuwe ma'e pe wà nehe, aze izar numunehew kwaw pàrirogaw pupe nehe, a'e mehe omono putar amo tapi'ak wikuwe ma'e inugwer awa pe nehe. A'e mehe tapi'ak ma'e kutuk ma'e izar wiko putar a'e tapi'ak umàno ma'e kwer izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Aze amo awa imunar amo heimaw tapi'ak rehe nehe, aze a'e re uzuka nehe, u, aze ume'eg amo pe nehe, a'e mehe umekuzar putar a'e tapi'ak amo 5 tapi'ak imono pà izarer pe nehe. Aze amo awa imunar amo heimaw àràpuhàràn rehe nehe, aze a'e re uzuka nehe, u, aze ume'eg amo pe nehe, a'e mehe umekuzar putar a'e àràpuhàràn hawitu ma'e amo 4 àràpuhàràn hawitu ma'e wamono pà izarer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Imunar ma'e umekuzar putar wemipyhyk kwer wà nehe. Aze naheta kwaw ma'e izupe nehe, aze nahemetarer kwaw nehe, peme'eg a'e teko amo ae teko wanupe uma'ereko e ma'e romo nehe. Aze amo imunar amo ma'ea'yr rehe nehe, aze pepyhyk a'e imunar ma'e a'e ma'ea'yr hereko mehe nehe, imunar ma'e umekuzar putar wemipyhyk kwer mokoz haw nehe. Aze upyhyk pitài tapi'ak nehe, omono putar mokoz tapi'ak hekuzaromo wà nehe. Aze upyhyk pitài zumen nehe, omono putar mokoz zumen hekuzaromo wà nehe. Aze upyhyk pitài àràpuhàràn nehe, omono putar mokoz àràpuhàràn hekuzaromo wà nehe. Aze amo teko wixe amo hàpuz me pyhaw amo ma'e rehe imunar pà nehe, aze amogwer teko upyhyk a'e pe wà nehe, pezepyk zo izuka arer wanehe nehe. Nuiko kwaw puruzuka ma'e romo herenataromo nehe. Aze uzuka 'aromo wà nehe, pezepyk wanehe nehe, ta'e wiko puruzuka ma'e romo herenataromo a'e nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Aze amo awa weraha weimaw amo ko pe wà nehe, u, amo uwà tyw pe wà nehe, wamumai'u kar pà a'e pe wà nehe, aze omono kar weimaw amo ae awa iko rehe hemipo'o kwer i'u kar pà izupe wà nehe, a'e awa umekuzar putar weimaw wanemi'u kwer nehe, ko izar pe nehe. Upyhyk putar hezuz ma'e ikatu wera'u ma'e oko pe har nehe, u, upyhyk putar uwà ikatu wera'u ma'e wemitygwer parer imono pà inugwer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Aze amo umunyk tata amo me nehe, aze tata uhàuhàz xu rehe nehe, aze a'e re uhàuhàz arozràn imono'og pyrer rehe nehe, u, aze arozràn ko pe hezuz ma'e ukaz nehe, a'e mehe tata imunyk arer umekuzar putar wemimuaiw kwer ko izar pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Aze amo awa omono amo ma'e wapi har pe imonokatu kar pà izupe nehe, u, aze omono wemetarer izupe imonokatu kar pà izupe nehe, Aze a'e re amo ae imunar a'e ma'e rehe hapi har hàpuz wi nehe, a'e mehe imunar ma'e umekuzar putar mokoz haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Aze napepyhyk kwaw imunar ma'e nehe, a'e mehe peraha a'e tàpuz izar Tupàn imuwete haw pe nehe. — Aipo ne a'e ma'e rehe imunar ma'e romo ereiko ne, i'i putar tàmuzgwer izupe wà nehe. — Hemuzekaiw kar hehe. Nezewe rehe we nahemunar kwaw hehe, i'i putar tàmuzgwer wanupe uze'eg imume'uahy pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Wyzài tapi'ak rehe, wyzài zumen rehe, wyzài àràpuhàràn hawitu ma'e rehe, wyzài kamir rehe, wyzài ma'e uzeàmim ma'e kwer rehe nehe, aze amo uze'eg nezewe nehe, — Hema'e a'e, aze i'i izupe nehe, aze hereko har a'e nehe no, — Hema'e, aze i'i a'e ma'e pe a'e nehe no, a'e mokoz oho putar tàmuzgwer wanenataromo a'e wà nehe. — Ereiko imunar ma'e romo ne, aze i'i Tupàn amo pe nehe, a'e teko umekuzar putar wemipyhyk kwer mokoz haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Aze amo awa omono weimaw wapi har pe nehe: zumen, tapi'ak, àràpuhàràn hawitu ma'e, wyzài ma'ea'yr, imonokatu kar pà izupe nehe, aze a'e re a'e ma'ea'yr umàno nehe, u, aze ipàri nehe, u, aze amo imunar hehe ka'api'i pe heko mehe hexak 'ym pà nehe, ");
INSERT INTO gubBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","a'e mehe uzekaiw ma'e umume'u putar katu 'ym ma'e romo weko 'ymaw izar pe nehe. — Napokok kwaw nereimaw rehe ihe, i'iahy putar tuwe izar pe Tupàn henataromo nehe. — He'e, i'i putar izar nehe. Nuenoz kwaw hekuzar hehe uzekaiw ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Aze amo imunar tuwe a'e ma'ea'yr rehe tàpuz huwake nehe, a'e uzekaiw ma'e wi nehe, a'e mehe uzekaiw ma'e omono putar hekuzar heimaw izar pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Aze amo miar hehaite ma'e uzuka heimaw nehe, ipei'ài'àg pà nehe, hehe uzekaiw ma'e werur putar ipegegwer izar pe hexak kar pà nehe. A'e mehe numekuzar kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Aze amo awa i'i nezewe wapi har pe nehe, — Tuwe nereimaw umumaw amo 'ar hereko haw pe wiko pà nehe, aze i'i izupe nehe, aze a'e re uzeapo amo hahy haw heimaw pe nehe, u, aze umàno nehe, aze izar nuiko kwaw a'e pe a'e ma'e izeapo mehe nehe, a'e mehe hehe uzekaiw ma'e umekuzar putar izar pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Aze izar wiko a'e ma'ea'yr huwake a'e ma'e izeapo mehe nehe, a'e mehe uzekaiw ma'e numekuzar kwaw nehe. Aze a'e ma'ea'yr uma'ereko amo pe temetarer rupi nehe, a'e temetarer umekuzar putar a'e iaiw ma'e uzeapo ma'e kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Aze amo awa uze'eg amo kuzà imen 'ym ma'e pe nehe, aze a'e kuzà wiko awa pe imume'u pyr 'ym romo nehe, aze wiko kuzà awa puhe oho pixik 'ym ma'e romo nehe, — Eker ezuwà hepuhe nehe, aze i'i izupe nehe, aze a'e re uker uzepuhepuhe wà nehe, a'e mehe a'e awa omono putar temireko hekuzar tu pe nehe. A'e kuzà wiko putar hemireko romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Aze tu na'iporomono wer kwaw wazyr rehe izupe hemireko romo nehe, nezewe rehe we a'e awa omono putar hekuzar tu pe nehe. Kuzà awa puhe oho pixik 'ym ma'e kwer hekuzar omono putar tu pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Pezuka wyzài kuzà paze ma'e ikatu 'ym ma'e nehe. — Tuwe wikuwe nehe, peze zo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Aze amo awa uzeupir amo ma'ea'yr rehe wemireko ài nehe, pezuka a'e awa nehe. Aze amo kuzà umuzeupir kar amo ma'ea'yr uzehe nehe, umen ài nehe, pezuka a'e kuzà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Aze amo teko uzuka amo ma'ea'yr amo tupàn a'ua'u imuwete katu pà nehe, pezuka a'e teko nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Aze heta amo ae ywy rehe har pepyr nehe, pezapo zo ikatu 'ym ma'e izupe nehe. Pepuraraw kar zo ma'erahy izupe nehe. Ta'e pe no xe, peiko amo ae ywy rehe har romo Ezit ywy rehe peneko mehe pe no xe. Zawaiw katu a'e ywy rehe peneko awer. ");
INSERT INTO gubBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Pezapo zo ikatu 'ym ma'e kuzà imen umàno ma'e kwer pe nehe. Pezapo zo ikatu 'ym ma'e kwarer tu 'ym ma'e ihy 'ym ma'e pe nehe, kuzàtài tu 'ym ma'e ihy 'ym ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Aze pepuraraw kar ma'erahy agwer teko wanupe nehe, aze a'e teko uze'eg ihewe wà nehe, ihe Tupàn Tuweharupi Wiko Ma'e ihe nehe, ainu putar waze'eg mehe ihe nehe. Apytywà putar ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Aikwahy putar ihe nehe. Apuzuka putar takihepuku pupe nehe. Penemireko wiko putar kuzà imen umàno ma'e kwer romo wà nehe. Pena'yr penazyr wiko putar tu 'ym ma'e romo wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Aze pemono temetarer amo heremiaihu penehe we har hemetarer 'ym ma'e pe nehe, — Amo 'ar mehe emuzewyr ihewe nehe, aze peze izupe nehe, peiko zo hemetarer mono'ogar ài nehe. Penoz zo penemetarer imemyr izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Aze nerapi har wenoz temetarer newe nehe, aze umur ukamirpuku hekuzaromo nehe, aze nupuner kwaw a'e hekuzar imuzewyr kar haw rehe newe a'e 'ar mehe nehe, emuzewyr ikamirpuku izupe kwarahy heixe mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ta'e xo a'e ikamirpuku zo heta izupe a'e xe. Ma'e uzapo putar pyhaw uker mehe nehe, uwixàgahy mehe nehe, aze nuwereko kwaw ukamirpuku nehe. Ihapukaz mehe ainu putar ize'eg nehe, ta'e purupuhareko katu ma'e romo aiko ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Pemono zo iaiw paw tuwihaw wanehe nehe. Pemono zo ze'egaiw penemiaihu wanuwihaw wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Perur penemi'u ipehegwer imonokatu pyrer nehe, i'ar mehe nehe: arozràn, win, uri kawer. Pemur pena'yr ipy ihewe imonokatu pyràm pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Nezewegatete pemur peneimaw tapi'ak imemyr awa ipy ihewe wà nehe, pemur peneimaw àràpuhàràn imemyr awa ipy ihewe wà nehe no. Tuwe umumaw 7 'ar uhy rehe we upyta pà wà. 8 haw 'ar mehe pemur ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Peiko teko ikatu 'ymaw wi uzemonokatu ma'e romo herenataromo nehe. A'e rupi aze miar hehaite ma'e upei'ài'àg amo ma'ea'yr wà nehe, pe'u zo ho'o kwer nehe. Peityk imono zawar wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Neremu'em zo nerapihar heko haw rehe nehe. Neremu'em zo ma'e rehe tàmuzgwer wanenataromo awa iaiw ma'e ipytywà pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Aze teko tetea'u uzapo ikatu 'ym ma'e waiko wà nehe, ezapo zo a'e ma'e nehe, wazàwe nehe. Aze tàmuzgwer nerenoz uzenataromo wà nehe, ma'e uzeapo ma'e kwer imume'u kar pà newe wà nehe, neremu'em zo teko iaiw ma'e wazàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Aze tàmuzgwer upuranu nerehe wà nehe, neremu'em zo ni hemetarer 'ym ma'e ipytywà pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Aze erexak neàmàtyry'ymar heimaw tapi'ak nehe, u, zumen nehe, aze wata e uzar wi nehe, emuzewyr kar izar pe nehe. Aze ru'u amo 'ar mehe erexak putar heimaw zumen nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Aze ru'u heimaw zumen u'ar putar nehe, ta'e ma'e ikupe pe har ipuhuz katu wera'u izupe a'e nehe xe. Eho zo a'e wi ipytywà 'ym pà nehe. Epytywà izar weimaw imupu'àm kar mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Aze hemetarer 'ym ma'e oho tàmuzgwer wanenataromo nehe, tuwe nuwerekoahy kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Aze amo hemu'em tàmuzgwer wanenataromo nehe, — Azeharomoete, ere zo hehe nehe. — Hemu'em iko a'e, ere tàmuzgwer wanupe nehe. Pezuka zo teko ikatu 'ym ma'e iapo 'ymar nehe. Pezuka zo teko ma'e rehe imunar 'ym ma'e nehe. Aze amo uzuka amo ikatu 'ym ma'e iapo 'ymar nehe, azepyk putar izuka arer rehe ihe nehe. — Ikatu ma'e romo ereiko, na'e pixik kwaw izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ne pureruze'eg ma'e ne, aze amo uze'eg nezewe newe nehe, — Amono putar temetarer newe nehe, aze neremu'em hepytywà pà tàmuzgwer wanenataromo nehe, aze i'i newe nehe, epyhyk zo hemetarer nehe. Ta'e agwer temetarer umuigo kar teko hehàpyhà 'ym ma'e zàwenugar romo wà xe. Hehàpyhà 'ym ma'e nuexak kwaw ma'e wà. Nezewegatete a'e teko nukwaw kwaw ikatu ma'e iapo haw. Nezewe mehe ni amo nukwaw kwaw ze'eg azeharomoete har wà nehe. Nezewe mehe erezapo mo ikatu 'ym ma'e teko ikatu ma'e wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Pezapo zo ikatu 'ym ma'e amo ae ywy rehe har pepyr wiko ma'e pe wà nehe. Ta'e pekwaw waneko haw pe no xe. Ta'e peiko amo ae ywy rehe har romo Ezit ywy rehe peneko mehe kwehe mehe pe no xe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pemumaw 6 kwarahy ma'e itym pà peko pe nehe, ma'e ipo'o pà peko pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","7 haw kwarahy mehe pezutym zo ma'e a'e ywy rehe nehe. Tuwe a'e ywy tuz a'e ae nehe. Tuwe upytu'u nehe. Nezewe mehe hemetarer 'ym ma'e pepyr har upuner wemi'u ràm ipo'o haw rehe a'e ko pe wà nehe. Aze heta we ikurer nehe, miar upuner i'u haw rehe wà nehe no. Pezapo nezewe haw penemitygwer uwà tyw pe nehe, uri tyw pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Pemumaw 6 'ar pema'ereko pà nehe. 7 haw 'ar mehe pema'ereko zo nehe. Nezewe mehe peneimaw tapi'ak a'e nehe, peneimaw zumen a'e nehe no, upuner upytu'u haw rehe a'e wà nehe no. Uma'ereko e ma'e neràpuz me uzexak kar ma'e kwer a'e nehe, amo ae ywy rehe har nepyr wiko ma'e a'e nehe no, upuner ukàgaw imuzewyr kar pà a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Pezapo ma'e heremimume'u kwer paw rupi katete nehe. Pemuwete zo tupàn a'ua'u pe wà nehe. Penoz zo ma'e wanupe nehe. Pemume'u zo tupàn a'ua'u waner amo wanupe peze'eg mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kwarahy nànàn pezapo mynykawhu herenataromo na'iruz haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Pezapo Mynykawhu Typy'ak Imuapiruru Kar Pyr 'Ym her ma'e nehe. Pemumaw 7 'ar typy'ak imuapiruru kar pyr 'ym i'u pà nehe, heze'eg awer rupi katete nehe. Zahy Amim her ma'e rehe nehe, i'ar mehe nehe, pezapo a'e mai'u haw nehe. Ta'e a'e zahy rehe pehem Ezit ywy wi pe no xe. Tuwe ni amo uzexak kar herenataromo ma'e ihewe imur pyràm herur 'ym pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Pezapo Mynykawhu Temi'u Ipo'o Haw her ma'e nehe no. Penemi'u ràm ipo'o mehe, penemipo'o ràm ipy pemur ihewe nehe. Pezapo Mynykawhu Temi'u Paw Imono'ogaw her ma'e kwarahy iahykaw rehe har rehe nehe no. Ta'e a'e 'ar rehe pemono'og uwà paw herur pà penàpuz me xe. Pemono'og amo ma'e'a kwer ityw pe har paw herur pà penàpuz me no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kwarahy nànàn na'iruz haw awakwer paw ur putar hemuwete katu pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ma'ea'yr herenataromo izuka mehe nehe, pemur zo ma'e typy'ak imuapiruru kar haw inuromo har ihewe nehe. Ma'ea'yr herenataromo izuka mehe nehe, ikawer hapy mehe nehe, tuwe ikawer paw ukaz a'e 'ar mehe nehe. — Xiapy ko ikawer pyhewe nehe, peze zo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ma'e peko pe hezuz ma'e kwer ikatu wera'u ma'e ipy perur heràpuz me nehe, ta'e aiko pezar romo ihe xe. Aze pezuka àràpuhàrànetea'yr penemi'u ràm romo nehe, pemupupur zo ho'o kwer ihy ikamykwer inuromo nehe. Nezewegatete àràpuhàràna'yr hawitu ma'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Amono kar amo hereko haw pe har iteko penenataromo nehe. Pepyro putar ikatu 'ymaw wi peata mehe nehe. Peneraha putar peneko àwàm heremimuàgy'ygwer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pezeapyaka katu ize'eg rehe nehe. Peinu katu nehe. Peruzar ize'eg nehe. Aze pepytu'u heruzar ire nehe, naheharaz kwaw penemiapo kwer wi nehe, ta'e herer hekuzaromo uzapo ma'e a'e xe. Uzepyk putar penehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Aze pezeapyaka katu heze'eg rehe nehe, aze pezapo heremimume'u kwer paw nehe, aiko putar peàmàtyry'ymar waàmàtyry'ymar romo ihe nehe. Àzàmàtyry'ym putar peàmàtyry'ymar ihe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Hereko haw pe har oho putar penenataromo nehe. Peneraha putar teko tetea'u waneko haw pe nehe: Amohe ywy rehe har waneko haw pe, Ewe izuapyapyr waneko haw pe, Perize izuapyapyr waneko haw pe, Kànàà izuapyapyr waneko haw pe, Iw izuapyapyr waneko haw pe, Zepu izuapyapyr waneko haw pe. Amumaw putar a'e ywy rehe har paw ihe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Pezemumew zo wazar tupàn a'ua'u wanenataromo nehe. Pemuwete zo wazar tupàn a'ua'u pe wà nehe. A'e ywy rehe har uzapo iaiw ma'e tupàn a'ua'u wamuwete pà wà. Pezapo zo agwer ma'e nehe. Pemumaw a'e tupàn a'ua'u pe wà nehe. Pezukazuka ita tupàn a'ua'u pe imonokatu pyrer nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Aiko Tupàn Tuweharupi Wiko Ma'e pezar romo ihe. Hemuwete katu pe nehe. Nezewe mehe amono putar heze'egatu penehe nehe, penemi'u ràm imono pà 'y imono pà peme nehe no. Amunyryk kar putar ma'eahy haw pewi nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Kuzà na'imemyrxak kar kwaw i'ar 'ym mehe nehe. Imemyr numàno kwaw nehe. Ni amo kuzà peywy rehe har nuiko kwaw imemyr 'ym ma'e romo wà nehe. Apumumaw kar putar pekwarahy paw peneko mehe ihe nehe no. Pereko putar kwarahy tetea'u pitàitàigatu nehe. Napemàno kwaw pe'ar 'ym mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Amukyze kar putar peàmàtyry'ymar ihewi ihe wà nehe. Teko penemiàwàxi ràm nukwaw kwaw ma'e iapo haw a'e wà nehe. Uzàn putar pewi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Amono putar kaw penenataromo nehe. Nezewe mehe Ewe ywy rehe har a'e wà nehe, Kànàà ywy rehe har a'e wà nehe no, Ete ywy rehe har a'e wà nehe no, uzàn putar oho penenatar wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Namuzàn kar kwaw a'e teko paw a'e wi pitài kwarahy rehe ihe wà nehe. Aze mo azapo nezewe haw, a'e mehe mo naheta iwer mo teko a'e pe wà, a'e mehe mo miar hehaite ma'e heta tetea'u wera'u mo pewi wà. Napepuner iwer mo wazuka haw rehe paw rupi. ");
INSERT INTO gubBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Amuzàn kar putar amo amo 'ar rehe ihe wà nehe. Amuzàn kar putar amo amo ae 'ar rehe ihe wà nehe no. Peneta wewera'i putar amo 'ar rehe nehe. Peneta wera'u putar amo ae 'ar rehe nehe. Nezewe mehe pepuner a'e ywy paw ipyhykaw rehe nehe, imynehem pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Amuapyk putar peneko àwàm ywyzaw xe ihe nehe. Oho putar Ak yrypo wi nehe. Oho putar Ewparat yrykawhu pe nehe. Oho putar Mezitehàn yryhu wi nehe. Oho putar ywyxiguhu pe nehe. Amono putar hekàgaw peme nehe. A'e mehe peiko teko a'e ywy rehe har wazar romo nehe. Pepyhyk putar a'e ywy nehe. Pemuhem kar a'e teko a'e ywy wi pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Pezapokatu zo peze'egaw a'e ywy rehe har wanehe we nehe. Pemuwete zo wazar tupàn a'ua'u pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Pemuigo kar zo a'e teko peywy rehe pe wà nehe. Aze upyta peywy rehe wà nehe, uzapo kar putar iaiw ma'e peme herenataromo a'e wà nehe. Aze pemuwete wazar tupàn a'ua'u pe wà nehe, wamuwete haw nuzawy kwaw puruzuka haw peme nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg wi Moizez pe kury. — Aze'eg putar peme ihe nehe kury: Àràw, Nanaw, Amiu, pe 70 Izaew waneruze'egar pe no. Pezeupir ywytyr herenataromo pezur pà kury. Hemuwete katu pe pepa'i nehe. Pehem zo heruwakea'i nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ne Moizez, xo ne zo erehem putar heruwakea'i nehe. Amogwer nuhem kwaw heruwakea'i wà nehe. Teko nupuner kwaw uhemaw rehe nerupi wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Umume'u Moizez Tupàn Tuweharupi Wiko Ma'e ze'eg paw oho teko wanupe kury. Umume'u hemiapo putar haw paw wanupe no. Teko paw uze'eg nezewe pitài teko ài wà. — Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer paw uruzapo putar ure nehe, i'i Moizez pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Na'e Moizez umuapyk Tupàn Tuweharupi Wiko Ma'e hemimume'u kwer paw pape rehe. Iku'egwer pe ku'em mehe uzapo ma'ea'yr hapy haw ywytyruhu izypy pe. Umupu'àm 12 itahupuku a'e pe no. Pitàitàigatu itahu upyta Izaew ta'yr wazuapyapyr wanehe purumuma'enukwaw kar haw romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Na'e Moizez omono kar kwàkwàmo Izaew wanehe we har a'e pe wà kury. Umunyk tata ma'ea'yr hapy pà Tupàn Tuweharupi Wiko Ma'e henataromo a'e pe wà. Uzuka tapi'aka'yr awa a'e pe wà no, Tupàn rehe we uzeàmàtyry'ymaw imumaw paw romo no. ");
INSERT INTO gubBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Upyhyk Moizez huwykwer ikurer a'e kury. Omono amo huwykwer kawawhu pupe. Ikurer umupiripirik ma'e zuka haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Na'e upyhyk pape Tupàn Tuweharupi Wiko Ma'e ze'eg hereko har kury, teko wanupe imugeta pà kury. — Uruzapo putar Tupàn Tuweharupi Wiko Ma'e hemimutar paw rupi ure nehe. Ureruzar putar ize'eg nehe, i'i wà. ");
INSERT INTO gubBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Na'e Moizez upyhyk ma'ea'yr huwykwer kury. Umupiripirik teko wanehe. — Ko ma'eruwy kwer penehe imupiripirik pyrer umuaze Tupàn Tuweharupi Wiko Ma'e ze'egaw penehe we iapo katu pyrer. Tupàn uzapo putar wemimume'u kwer nehe, ta'e wexak ko ma'eruwy kwer penehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moizez, Àràw, Nanaw, Amiu. A'e 70 tuwihawete wà no, uzeupir ywytyr rehe oho wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wexak Tupàn Izaew wazar wà. Itapew xapir her ma'e zàwenugar Tupàn ipy iwy pe tuz. A'e itapew huwy ywak ài. ");
INSERT INTO gubBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tupàn nuzuka kwaw a'e Izaew wanuwihaw wà. Wexak Tupàn a'e wà. A'e re umai'u uzehe we wà, ui'u uzehe we wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Ezur xe heruwake ywytyr rehe nehe kury. Epyta xe. Amono putar itapew heze'eg imuapyk pyrer hereko har newe nehe. Amuapyk heze'eg hehe, heremimutar imume'u pà teko wanupe. Nezewe mehe upuner heze'eg rehe uzemu'e haw rehe a'e wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Na'e Moizez uzypyrog wata pà uzehe we har Zuzue rupi kury. Uzypyrog ywytyr Tupàn pe imonokatu pyrer rehe uzeupir pà. ");
INSERT INTO gubBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Uze'eg Moizez tàmuzgwer wanupe. — Pepyta xe ureràro pà nehe. Uruzewyr putar xe pepyr nehe. Àràw a'e, Ur a'e no, xe pepyr wanekon a'e wà kury. Aze heta amo ma'e penemigwaw 'ym nehe, peho wanupe peze'eg pà nehe, wanehe pepuranu pà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ywytyr apyr kutyr izeupir wiwi mehe ywàkun upyk ywytyr kury. ");
INSERT INTO gubBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Tupàn Tuweharupi Wiko Ma'e heny katu haw wezyw Xinaz ywytyr rehe kury, i'aromo wapyk pà kury. Nuzawy kwaw tata ywate ukaz ma'e Izaew wanupe. Ywàkun umumaw 6 'ar ywytyr ipyk pà. 7 haw 'ar mehe Tupàn Tuweharupi Wiko Ma'e uhapukaz Moizez pe kury, ywàkun wi uze'eg pà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Na'e Moizez wixe ywàkun pupe ywytyr apyr kutyr uzeupir wiwi mehe kury. Umumaw 40 'ar ywytyr rehe upyta pà. Upyta a'e pe pyhaw no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","— Eze'eg nezewe Izaew wanupe nehe. — Pemur e ma'e heruwà ihewe nehe, ere teko wanupe nehe. Epyhyk a'e ma'e imur pyràm herekuzaromo nehe, awa wanuwi pitàitàigatu nehe, aze ipurumur wer ma'e rehe ihewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Agwer ma'e epyhyk wanuwi nehe: itazu or, itaxig parat, itazu morog, ");
INSERT INTO gubBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e, pàn ikatuahy ma'e irin her ma'e, pàn àràpuhàrànete hawer iapo pyrer, ");
INSERT INTO gubBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","àràpuhàràn hawitu ma'e awa wapirer imumiràg pyrer, ma'epirer ikatuahy ma'e, ywyra akaz her ma'e, ");
INSERT INTO gubBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","uri kawer tatainy pupe àràm romo, kàpuhàg ma'e kawer inuromo har, yhyk zàwenugar, ");
INSERT INTO gubBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ita ipuràg eteahy ma'e unik her ma'e, amo ae ita ipuràg eteahy ma'e xaxeto wanuwihawete kamirpuku rehe àràm, ipuxi'a rehe har rehe àràm. A'e ma'e paw emono'og wanuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Na'e ezapo kar amo tàpuzràn imonokatu pyràm wanupe nehe, hereko àwàm romo nehe. Ta'e aiko putar teko wainuromo ihe nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ezapo a'e tàpuzràn nehe, ipupe har nehe no. Amono putar hexak àwàm hagapaw newe ihe nehe kury. Ezapo ma'e hexak àwàm hagapaw zàwegatete nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Upyhyk putar ywyra akaz her ma'e wà nehe. Ukixikixi putar a'e ywyra amo ma'e hyru iapo pà wà nehe. Pitài met 10 xenxim rehe we ipuku haw nehe. 66 xenxim ipuku haw iaikwer nehe. 66 xenxim ipupykanapaw puku haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ezapeao ma'eryru iape itazu or pupe nehe. Ezapeao ipupe har ipupe nehe no. Emono or hehe heme'ywyr imupuràgaw romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Emuapu'a or 4 iapu'a ma'e iapo pà nehe. Ezomog a'e 4 iapu'a ma'e hehe wà nehe, mokoz amo ipehegwer rehe nehe, mokoz inugwer pehegwer rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","A'e re ekixi akaz ywyra mokoz a'e ma'e hyru i'yw iapo pà nehe. Epyao a'e ywyra or pupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Emono i'yw iapu'a ma'e ikwar rupi nehe, hupir haw romo heraha haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tuwe i'yw upyta iapu'a ma'e ikwar rupi tuweharupi nehe. Penuhem zo izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","A'e re emonokatu a'e itapew heze'eg hereko har a'e ma'eryru pupe nehe. Amono putar a'e itapew heze'eg hereko har newe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Emupyràn or ikatu ma'e a'e ma'eryru ipyk àwàm iapo pà nehe. 110 xenxim ipuku haw nehe. 66 xenxim ipuku haw iaikwer ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ezapo mokoz hereko haw pe har kerumin her ma'e wanagaw paw ne wà nehe, or imuapu'apu'a pà nehe. Emupu'àm a'e kerumin wanagapaw a'e ma'eryru ipykaw rehe ne wà nehe, ipuku haw iapyr ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Emupu'àm kar pitài kerumin pitài ipykaw ipuku haw iapyr nehe. Emupu'àm kar inugwer kerumin inugwer ipuku haw iapyr nehe no. Ezomogatu wanagapaw a'e ywyrapew rehe ne wà nehe. Tuwe pitài ma'e romo wanuz wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tuwe kerumin wanagapaw ipepozaz wà nehe. Nezewe mehe wapepo upyta putar ipykaw i'ar romo wà nehe. Tuwe kerumin uzenataromo u'àm wà nehe, ipykaw rehe ume'e pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Emono a'e mokoz itapew heze'eg hereko har newe heremimono ràm a'e ma'eryru pupe nehe. A'e re emono a'e ipykaw i'aromo hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Aiko putar a'e pe ipykaw 'aromo nehe, kerumin wanagapaw wamyter pe nehe, heze'eg itapew rehe har hyru 'aromo nehe. Uruàwàxi putar a'e pe ihe nehe. Amume'u putar heremimutar paw newe a'e pe nehe, Izaew wanupe heremimume'u kar ràm paw newe a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ekixikixi ywyra akaz her ma'e amo ywyrapew iapo pà nehe. Tuwe ipuku haw heta 88 xenxim nehe. Tuwe ipuku haw iapyr heta 44 xenxim nehe. Tuwe iaiha haw heta 66 xenxim nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Epyao a'e ywyrapew or pupe nehe. Ezapo imupuràgaw hemat her ma'e heme'ywyr nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ezapo heme'ywyr har ywyrapew izywyr nehe. Tuwe heta 4 nekwà ipupir haw nehe. Ezapo hemat or iapo pyrer heme'ywyr har rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Emuapu'a or 4 iapu'a ma'e iapo pà nehe no. Emono a'e iapu'a ma'e ywyrapew hetymà wanuwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Emono a'e iapu'a ma'e heme'ywyr har huwake. Emono mokoz ywyra i'yw romo a'e iapu'a ma'e wanupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ekixikixi kar ywyra akaz her ma'e a'e ywyrapew i'yw iapo pà nehe. Ezuwàzuwàn a'e ywyrapew 'yw or pape zàwenugar iapo pyrer pupe nehe. Teko upyhyk putar i'yw heraha mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ezapo a'e ywyrapew rehe hin ma'e paw nehe: kawaw, kanek, kanek puku, y'a win hyru ràm. Emuapu'a or a'e ma'e paw iapo pà nehe. Emono zo amo ae ita a'e or inuromo iapo mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Emuapyk a'e ywyrapew heze'eg hyru henataromo nehe. Tuweharupi emono typy'ak ihewe imur katu pyrer a'e ywyrapew rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Emuapu'a or tatainy henaw iapo pà nehe. Enupànupà or ipy iapo pà nehe. Enupànupà or i'yw iapo pà nehe no. Ezapo ma'eputyr hagapaw nehe: iputyr hagapaw nehe, iputyr rupi'a hagapaw nehe no. Ezomogatu a'e ma'eputyr hagapaw tatainy henaw rehe pitài ma'e romo iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Heta putar 6 tatainy wà nehe no. Na'iruz tatainy upyta putar ipehegwer rehe wà nehe. Na'iruz tatainy upyta putar inugwer ipehegwer rehe wà nehe. A'e tatainy upyta putar a'e 6 izywa zàwenugar apyr wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Heta putar na'iruz ma'eputyr hagapaw izywa wanehe pitàitàigatu wà nehe. Ma'e'yw amen her ma'e iputyr zàwe ezapo a'e ma'eputyr hagapaw ne wà nehe. Ezapo waputyr rupi'a hagapaw ne wà nehe no. Ezapo waputyr hagapaw ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ezapo 4 amen iputyr hagapaw ne wà nehe, waputyr rupi'a wanehe we waputyr wanehe we ne wà nehe no. Ezomog a'e amen iputyr hagapaw tatainy i'yw rehe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ezomog pitài amen iputyr hupi'a a'e tatainy henaw izywa iwype pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Enupànupà or a'e ma'eputyr hagapaw iapo pà nehe, iputyr rupi'a iapo pà nehe no, izywa iapo pà nehe no. Ezomogatu a'e ma'e paw i'yw rehe nehe, pitài zo ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ezapo 7 tatainy a'e tatainy henaw izywa iapyr wamono pà nehe. Tuwe uhyape katu wenataromo har wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Emuapu'a or zepinaw inemo tatainy pupe har imonohok àwàm iapo pà nehe, ikaiwer imono'og àwàm iapo pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Emono'og or a'e tatainy henaw iapo pà nehe, a'e ma'e hehe imog pyràm iapo pà nehe no. Tuwe heta 34 kir a'e or nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Aexak kar a'e ma'e neremiapo ràm hagapaw paw rupi newe ihe, ywytyr rehe nereko mehe ihe. Ezapo ma'e paw a'e hagapaw zàwegatete nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Epyhyk pàn ikatu ma'e irin her ma'e nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e nehe no. Ema'ema'e a'e ma'e paw 10 pànuhu imuzaiko pyrer heràpuzràn pupe har iapo pà nehe. Emuwywyk kerumin wanagapaw iapo pà a'e pàn rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","A'e pànuhu paw a'e wà nehe, tuwe heta 12 met 50 xenxim rehe we ipuku haw pitàitàigatu nehe. Tuwe 1,80 met heta ipuku haw iaikwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Emuwywyk 6 pàn wanehe we nehe, pitài pànuhu iapo pà nehe. Emuwywyk inugwer 5 pàn pitài pànuhu iapo pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Epyhyk pàn huwy ma'e a'e pànuhu iàpixipixi haw iapo pà nehe. Ezomog a'e iàpixipixi haw hehe nehe, katu pe har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ezapo 50 iàpixipixi haw pànuhu ipy heme'ywyr har pe nehe. Ezapo 50 iàpixipixi haw pànuhu iahykaw rehe har heme'ywyr har pe nehe no. Tuwe pitài iàpixipixi haw upyta amo henataromo nehe pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Emuapu'a or 50 ma'e kokaw iapo pà nehe no. Emono'og a'e mokoz pànuhu iapo pyrer a'e 50 ma'e kokaw pupe nehe no, pitài ma'e romo iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ezapo amo heràpuzràn ipyk àwàm nehe. Emono'og 11 pàn pehegwer àràpuhàrànete hawer ipupepupe pyrer nehe, a'e heràpuzràn ipyk àwàm iapo pà nehe. Emuwywyk a'e 11 pehegwer pitài pànuhu iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","A'e 11 pàn pehegwer wà nehe, tuwe uzeawyawygatu uhua'u haw wà nehe. Heta putar 13,30 met wapuku haw pitàitàigatu nehe. Heta putar pitài met 80 xenxim ipupir pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Emono'og 5 pàn wamuwywyk pà nehe, pitài pànuhu iapo pà nehe. Emono'og inugwer 6 pàn amo pànuhu iapo pà nehe no. Ekanakanaw a'e 6 haw pehegwer heràpuzràn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ezapo 50 ihàm imuzekumàkumànaw pànuhu ipy ipehegwer iahykaw rehe har izywyr nehe. Ezapo amo 50 ihàm imuzekumàkumànaw inugwer pànuhu izywyr nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Emuapu'a ita morog 50 ma'e kokaw iapo pà nehe. Ezàpixipixi a'e imuzekumàkumànaw a'e ma'ekokaw rehe we nehe. Nezewe mehe emono'og a'e mokoz pànuhu pitài tàpuzràn ipykaw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Pànuhu upyta ma'e kwer uzaiko putar tàpuzràn ikupe kutyr nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Heta we putar 45 xenxim ipehegwer rehe nehe. Heta putar 45 xenxim inugwer ipehegwer rehe nehe no. Upyta putar tàpuzràn ipehegwer rehe nehe, amo ipehegwer rehe nehe no, ipykaw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Epyhyk àràpuhàràn pirer imupiràg pyrer nehe. Ezapo amo tàpuzràn ipykaw ipupe nehe. Ezapo amo tàpuzràn ipykaw nehe no, ma'epirer ikatuahy ma'e iapo pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ekixikixi ywyra akaz her ma'e nehe, heràpuzràn izyta iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Heta putar 4,45 met izyta ipuku haw pitàitàigatu nehe. Heta putar 67 xenxim ipupir nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Heta putar mokoz ikwar a'e izyta wanehe pitàitàigatu nehe. Nezewe mehe erepuner wamomogaw rehe nehe. Ezapo ikwar a'e izyta nànàn nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","20 izyta neremiapo kwer u'àm putar heràpuzràn pupe kwarahy hemaw awyze har kutyr har rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Emuapu'a parat 40 kawawpew iapo pà izypy ikokaw romo nehe. Emono mokoz kawaw izyta izypy ikokaw romo pitàitàigatu nehe. Nezewe mehe i'yw izyta romo iapo pyrer nuixe kwaw ywy pupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","20 izyta neremiapo kwer u'àm putar heràpuzràn pupe kwarahy hemaw ahurehe har kutyr har rehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Emono 40 kawaw parat iapo pyrer izyta izypy ikokaw romo nehe, mokoz kawaw pitài izyta pe pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ezapo 6 izyta kwarahy heixe haw kutyr har rehe wamu'àm kar pà ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ezapo amo 2 izyta tàpuzràn izekanaw haw rehe wamupu'àm kar pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Emomog a'e mokoz izyta waipy wanehe nehe, pitài izyta romo iapo pà nehe. Pitài ma'e romo iapo pyrer uzeupir putar iapu'a ma'e pe nehe. Ezapo nezewe haw mokoz haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Nezewe mehe heta putar 8 izyta wà nehe. Heta putar 16 kawaw parat iapo pyrer izyta izypy ikokaw romo pitàitàigatu wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ezapo 15 iapyteraromo har ywyra akaz her ma'e iapo pyrer nehe. Emono 5 iapyteraromo har ipehegwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Emono amo 5 inugwer amo ipehegwer rehe nehe no. Emono amo 5 haikwer pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Iapyteraromo har wamyter pe har oho amo izyta myter wi amo ae izyta myter pe nehe, pitàitàigatu tàpuzràn pehegwer wi inugwer pehegwer pe nehe. Iapyteraromo har myter pe har oho iaiha haw ku'aw a'e, amo ipehegwer rehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Epyao a'e izyta or pupe ne wà nehe. Emono iapu'a ma'e or iapo pyrer wanehe nehe no. I'yw wixe putar a'e iapu'a ma'e rupi a'e nehe. Epyao a'e iapu'a ma'e or pupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Emupu'àm heràpuzràn nehe, hagapaw newe ywytyr rehe heremixak karer zàwegatete nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Epyhyk pàn hekuzar katu ma'e irin her ma'e nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e nehe no. Emuwywyk kerumin wanagaw paw a'e pàn rehe nehe. A'e ma'e paw nepo pe hereko mehe ezapo pànuhu imuzaiko pyrer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Emuzaiko a'e pàn 4 ywyra izyta wanehe nehe. Ekixi ywyra akaz her ma'e a'e izyta iapo pà nehe. Epyao a'e izyta or pupe nehe. Heta putar ma'e pyhykaw or iapo pyrer hehe nehe. Ezomog a'e izyta 4 ma'ekokaw parat iapo pyrer 4 kawaw wazypy ikokaw romo iapo pyrer wanehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Emuzaiko a'e pànuhu a'e ma'ekokaw iwy pe nehe. A'e pànuhu haikwer pe emuapyk heze'eg hyru nehe. A'e mokoz itapew heze'eg hereko har a'e ma'eryru pupe wanuz wà. A'e pànuhu uzaiko a'e pe mokoz ipupy romo. Amo ipupyaikawhu ipy a'e, Tupàn Henaw Ikatuahy Ma'e her romo a'e. Ipupyaikawhu inugwer a'e, Tupàn Henaw Ikatuahy Wera'u Ma'e her romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Emono ipykaw heze'eg hyru rehe i'aromo nehe, herenaw ikatuahy wera'u ma'e pe i'àm ma'e ipyk pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Herenaw ikatuahy wera'u ma'e pupe 'ym herenaw ikatuahy ma'e pupe tàpuzràn pupe emuapyk a'e ywyrapew nehe, kwarahy hemaw ahurehe har kutyr nehe. Emupu'àm a'e tatainy henaw tàpuzràn pupe kwarahy hemaw awyze har kutyr nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Epyhyk pàn hekuzar katu ma'e irin her ma'e nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e nehe no. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e nehe no. Emuwywyk ma'eragapaw ipuràg eteahy ma'e pàn rehe nehe. A'e ma'e paw nepo pe hereko mehe ezapo pànuhu imuzaiko pyràm tàpuzràn pe heixe haw pe àràm nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ezapo 5 imuzaiko pyràm izyta ywyra akaz iapo pyrer nehe. Ezomog 5 ma'epyhykaw or iapo pyrer a'e izyta wanehe wà nehe. Emuapu'a itazu morog 5 kawaw iapo pà a'e izyta izypy ikokaw romo ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Ekixikixi ywyra akaz her ma'e amo ma'ea'yr herenataromo hapy haw iapo pà nehe. Tuwe ipuku haw nuzawy kwaw ipuku haw iaikwer ma'e nehe. Heta putar 2,20 met ipuku haw nehe. Heta putar 2,20 met ipuku haw iaikwer ma'e nehe no. Heta putar 1,30 met ipupykanapaw pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ipuku haw iapyr wanupe emono 4 i'ak nehe. A'e 4 i'ak uzemog putar ma'ea'yr hapy haw rehe wà nehe, pitài ma'e iapo pà nehe. Ezuwàzuwàn a'e 4 i'ak itazu morog pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ezapo zapepo ma'e kawer hyru ràm romo nehe. Ezapo amo zapepo tàtàpyzgwer hyru ràm romo nehe no. Ezapo ywy imomor haw, zapepo pew, kuzeràxi, zapepo tata hyru ràm nehe no. Emuapu'a itazu morog a'e ma'e paw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ema'ema'e itazu morog nehe, zapepopew ràn ipei'ài'àg pyrer imuparipari pyrer nehe, kyhaw zàwenugar nehe. Iapyr wanehe emono 4 iapu'a ma'e itazu morog iapo pyrer ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ezomog a'e iapu'a ma'e ma'ea'yr hapy haw heme'ywyr iwy pe nehe. Nezewe mehe a'e itazu imuparipari pyrer uhem putar ma'ea'yr hapy haw kupe pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ekixikixi ywyra akaz her ma'e nehe, ma'ea'yr hapy haw i'yw iapo pà nehe. Ezuwàzuwàn i'yw itazu morog pupe nehe, iapeao haw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Emono i'yw iapu'a ma'e wanupi wà nehe, mokoz ma'ea'yr hapy haw pehegwer wanehe ne wà nehe, teko hehe ipurueraha wer mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","A'e ma'ea'yr hapy haw ywyra iapo pyrer a'e nehe, tuwe izywyz a'e nehe, hagapaw newe ywytyr rehe heremixak karer zàwegatete a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Katu pe heràpuzràn huwake ezapo amo tàpuz izywyr ikatu haw nehe. Epyhyk irin ikatuahy ma'e a'e tàpuz izywyr ikatu haw imuzaiko pà nehe. Kwarahy hemaw awyze har kutyr heta putar 44 met a'e pànuhu ipuku haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Emupu'àm 20 izyta a'e pànuhu imuzaiko har romo nehe. Ezapo 20 kawaw zàwenugar itazu morog iapo pyrer a'e izyta izypy ikokaw romo nehe no. Emupyràn itaxig parat hàty'àz izyta rehe har iapo pà nehe, pànuhu imuzaiko haw iapo pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ezapo ma'e a'e ma'e zàwenugar kwarahy hemaw ahurehe har kutyr nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","13","Heta putar 22 met tàpuz izywyr ikatu haw ipuku haw ikupe kutyr har nehe. Heta putar 22 met pànuhu kwarahy heixe haw kutyr har nehe. Heta putar 22 met pànuhu kwarahy hemaw kutyr har nehe no. Ezapo 10 ywyra a'e pànuhu izyta romo ne wà nehe. Ezapo 10 a'e ywyra wapy ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Tàpuzràn heixe haw huwake heta putar mokoz pànuhu imuzaiko pyrer wà nehe no. Heta putar 6,60 met wapuku haw wà nehe. Heta putar 3 izyta wà nehe, 3 izyta wapy wà nehe no. Pitài pànuhu uzaiko putar pitài pehegwer rehe nehe. Inugwer uzaiko putar inugwer pehegwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ezapo amo pànuhu tàpuz izywyr ikatu haw ukenaw pe imuzaiko pà nehe. Heta putar 8,80 met ipuku haw nehe. Epyhyk pàn hekuzar katu ma'e irin nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e nehe. Epyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e nehe. A'e ma'e paw ipyhyk mehe emuwywyk ma'eragaw paw pàn rehe nehe. Epupepupe a'e inemo a'e pànuhu iapo pà nehe. 4 ywyra upyta putar a'e pànuhu izyta romo wà nehe. Heta putar 4 izyta wapy wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Izyta tàpuz izywyr ikatu haw izywyr har paw emono'og wapy parat iapo pyrer wanehe wà nehe. Emuapu'a parat hàty'àz wapo pà wà nehe. Emuapu'a itazu morog izypy ikokaw iapo pà wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Heta putar 44 met tàpuz izywyr ikatu haw ipuku haw nehe. Heta putar 22 met tàpuz izywyr ikatu haw ipuku haw iaikwer ma'e nehe no. Heta putar 2,20 met pànuhu iaiha haw nehe. Emuwywyk pàn ikatuahy ma'e irin her ma'e a'e pàn uzaiko ma'e ràm iapo pà nehe. Emuapu'a itazu morog izypy ikokaw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Emuapu'a ita morog nehe, ma'e tàpuzràn pupe àràm iapo pà nehe: kawaw, zapepo, izyta tàpuz izywyr ikatu haw pe har, tàpuzràn izyta. Emuapu'a morog a'e ma'e paw tàpuzràn pe àràm iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Moizez, eze'eg Izaew wanupe nehe. — Perur uri kawer ikatu wera'u ma'e ihewe nehe, tatainy pupe àràm romo nehe. Ta'e amunyk putar a'e tatainy tuweharupi karuk mehe ihe nehe xe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Àràw a'e, ta'yr a'e wà nehe no, umuapyk putar a'e tatainy Tàpuzràn Herenaw pupe a'e wà nehe. Heze'eg hyru a'e pe hin putar nehe. Heta amo pànuhu huwake. Umuapyk putar tatainy henaw pànuhu ikupe kutyr wà nehe. A'e uri kawer ukaz putar iko herenataromo a'e nehe. Uzypyrog putar ukaz pà kwarahy heixe mehe. Xo kwarahy ihem wi mehe zo umuwew putar wà nehe. Izaew izuapyapyr a'e wà, wazuapyapyr paw a'e wà no, tuwe weruzar ko heze'eg tuweharupi wà nehe, awyzeharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Enoz kar neryky'yr Àràw kury, enoz kar ta'yr ne wà nehe no. Nanaw, Amiu, Ereazar, Itamar waner romo wà. Emunyryk amogwer Izaew izuapyapyr wanuwi ne wà nehe, xaxeto romo wamuigo kar pà herenataromo ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ezapo xaxeto ikamirpuku ikatu ma'e neryky'yr pe nehe. Nezewe mehe ipuràg eteahy putar teko wanupe nehe. Teko umuwete putar wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Enoz teko ma'e iapo katu haw kwaw par nezeupe ne wà nehe. Akwaw kar a'e ma'e iapo haw a'e teko wanupe ihe. Ezapo kar Àràw ikamir ima'e rehe we wanupe nehe. A'e re emonokatu xaxeto romo herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ezapo kar amo puxi'a iwànaw wanupe nehe. Ezapo kar xaxeto kamirpuku wanupe nehe no. Ezapo kar xaxeto iaxi'i ipykaw wanupe nehe no. Ezapo kar amo ae kamirpuku wanupe nehe no. Emuwywyk kar ma'e hagapaw ipuràg eteahy ma'e a'e kamirpuku rehe wanupe nehe no. Ezapo kar xaxeto àkàg rehe har wanupe nehe no. Ezapo kar iku'aw har wanupe nehe no. A'e teko uzapo putar kamir ikatu ma'e Àràw pe wà nehe, ta'yr wanupe wà nehe no. Ta'e Àràw a'e nehe xe, ta'yr a'e wà nehe no xe, wiko putar xaxeto romo herenataromo a'e wà nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Tuwe a'e kamirpuku iapo àràm omono'og agwer ma'e wà nehe: inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e, inemo or iapo pyrer, pàn hekuzar katu ma'e irin her ma'e. Tuwe uma'ema'e a'e ma'e paw wakamirpuku iapo pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","A'e ma'e iapo haw kwaw par wà nehe, omono'og putar a'e ma'e wà nehe: inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e, pàn hekuzar katu ma'e irin her ma'e, inemo or iapo pyrer. Umuwywyk putar ma'eragapaw heme'yw rehe imono pà wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","A'e kamir iaxi'i rehe heta putar mokoz iputàwmunehew haw nehe, kamir iaxi'i rehe imomog pyrer nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Uzapo putar amo iku'aw har a'e ma'e paw iàpixi haw romo wà nehe no. Uzàpixi putar iku'aw har kamirpuku rehe wà nehe, pitài ma'e romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Epyhyk mokoz ita agata her ma'e nehe. Ekair Zako ta'yr waner a'e ita wanehe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Emuapyk 6 waner pitài ita rehe wà nehe. Emuapyk inugwer 6 waner inugwer ita rehe wà nehe no. Emuapyk waner nezewe nehe. Emuapyk wanyky'yr her nehe. A'e re emuapyk tywyr her nehe. Nezewe emuapyk waner wazexak kar awer wa'ar rupi paw rupi pitàitàigatu wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ekar amo or imuapu'a haw kwaw par nehe. A'e ae ukair putar Zako ta'yr waner a'e ita wanehe wà nehe. A'e ae umupyràn putar or mokoz kawaw zàwenugar iapo pà nehe. Na'e omomog putar a'e mokoz ita Zako ta'yr waner wanereko har a'e mokoz kawaw zàwenugar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ezomog a'e ita'i xaxeto kamirpuku iputàwmunehew paw wanehe nehe. Nezewe mehe a'e ita upyta putar 12 Izaew ta'yr wazuapyapyr wanekuzar romo wà nehe. Nezewe mehe xaxeto weraha putar a'e waner waxi'i rehe wà nehe. A'e mehe ihe Tupàn Tuweharupi Wiko Ma'e hema'enukwaw katu putar teko heremiaihu wanehe tuweharupi ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Emuapu'a or mokoz ita henaw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Emuapu'a or mokoz kyhàhàmtàtà iapo pà nehe no. Epupepupe a'e kyhàhàmtàtà amo kyhàhàmtàtà iapo pà nehe. Erezàpixipixi putar a'e ita henaw a'e kyhàhàmtàtà pupe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ezapo kar xaxeto ipuxi'a iwànaw xaxeto wanuwihaw pe nehe. Umunehew putar heremimutar hekar mehe a'e nehe. Iapo àwàm nuzuawy kwaw ikamirpuku ikatuahy ma'e iapo haw nehe. Emono'og inemo àràpuhàràn hawitu ma'e hawer iapo pyrer nehe: huwy ma'e, ipuwy ma'e, ipiràg ma'e, pàn hekuzar katu ma'e irin her ma'e. Emuwywyk ma'eragaw paw heme'yw rehe imupuràg eteahy kar pà nehe. Ema'ema'e a'e ma'e a'e xaxeto ipuxi'a rehe ku'aw har iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tuwe iaikaw paw zuawyawygatu wà nehe. Ekanaw mokoz ipehegwer romo nehe. Heta putar 20 xenxim ipuku haw nehe. Heta putar 20 xenxim ipuku haw iaikwer ma'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ezomog ita hekuzar katu ma'e hehe 4 imuzehyiroirogatu haw iapo pà hehe nehe. Imuzehyiroirogatu haw ipy rehe ezomog na'iruz ita nehe: humi her ma'e, topaz her ma'e, karanaz her ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Imuzehyiroirogatu haw mokoz haw rehe ezomog na'iruz ita nehe: emeraw her ma'e, xapir her ma'e, niàmàn her ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Imuzehyiroirogatu haw na'iruz haw rehe ezomog na'iruz ita nehe: turukez her ma'e, agata her ma'e, amexi her ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Imuzehyiroirogatu haw 4 haw rehe ezomog na'iruz ita nehe: merew her ma'e, onik her ma'e, zaxipe her ma'e. Emuapu'apu'a or nehe, kawaw zàwenugar iapo pà a'e ita henaw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ekaikair Zako ta'yr waner a'e ita rehe pitàitàigatu ne wà nehe. Waner upyta putar 12 Izaew ta'yr wazuapyapyr waner wanehe purumuma'enukwaw kar ma'e romo pitàitàigatu wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Emuapu'apu'a or nehe, inemo zàwenugar romo iapo pà nehe. A'e re epupepupe a'e inemo or iapo pyrer kyhàhàm iapo pà nehe, ipuxi'a iwànaw iàpixipixi àwàm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Emuapu'a or mokoz iapu'a ma'e iapo pà nehe. Ezomog a'e iapu'a ma'e ipuxi'a ku'aw har rehe i'aromo har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Emono a'e mokoz kyhàhàm or iapo pyrer a'e iapu'a ma'e wanehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ezàpixi a'e mokoz ihàm mokoz iapu'a ma'e rehe nehe. Ezomog a'e mokoz iapu'a ma'e a'e kamirpuku iaxi'i wiwe ipuxi'a rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ezapo amo mokoz iapu'a ma'e or iapo pyrer nehe. Ezàpixi a'e iapu'a ma'e ikanapaw ywy kutyr har rehe nehe, izywyr har ipupe har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ezapo amo mokoz iapu'a ma'e or imupyràn pyrer nehe. Ezomog a'e iapu'a ma'e kamirpuku iaxi'i rehe nehe, ywy kutyr nehe, henataromo nehe, iku'aw har i'aromo imuwywyk awer huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Epyhyk amo kyhàhàm huwy ma'e nehe. Ezàpixipixi iapu'a ma'e ipuxi'a rehe har nehe, iapu'a ma'e kamirpuku rehe har rehe nehe. Nezewe mehe ipuxi'a rehe har nuhem kwaw xaxeto ipuxi'a wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Àràw Tupàn Tuweharupi Wiko Ma'e Henaw Ikatuahy Ma'e pupe wixe mehe umunehew putar a'e upuxi'a iwànaw a'e nehe. Ihe Tupàn Tuweharupi Wiko Ma'e ihe, aexak putar Izaew ta'yr wazuapyapyr waner a'e ita wanehe ikaikair pyrer ihe wà nehe. A'e mehe tuweharupi hema'enukwaw katu putar heremiaihu wanehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Xaxeto upyhyk putar mokoz ma'e pixika'i ma'e herehe upuranu mehe a'e wà nehe. Uri a'e ma'e ipy her romo a'e. Tumi inugwer ma'e her romo a'e. Ezomog Uri ipuxi'a iku'aw har rehe nehe. Ezomog Tumi hehe nehe no. Uri a'e, Tumi a'e no, tuwe upyta Àràw izà'à huwakea'i herenataromo heko mehe wà nehe. Herenataromo wixe mehe Àràw umunehew putar a'e upuxi'a iwànaw a'e nehe. Nezewe mehe ukwaw putar heremimutar Izaew wanupe iapo kar pyràm a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Xo inemo huwy ma'e epyhyk nehe, xaxeto iaxi'i ipykaw iapo mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ezapo amo ikwar imyter pe nehe. Nezewe mehe xaxeto upuner putar wàkàg imuixe haw rehe hupi nehe. Epyao a'e ikamir izurukwar romo har pàn ipuku ma'e pupe nehe. Nezewe mehe nu'i kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Emono'og inemo àràpuhàràn hawitu ma'e hawer iapo pyrer nehe: huwy ma'e, ipuwy ma'e, ipiràg ma'e. Ezapo ma'e'a homà her ma'e hagapaw a'e inemo pupe nehe. Emuwywyk a'e hagapaw xaxeto iaxi'i ipykaw iahykaw rehe nehe. Emomog maraka'i or iapo pyrer mokoz homà wamytepe pitàitàigatu ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aze Àràw wixe heràpuz me xaxeto romo nehe, tuwe umunehew a'e kamirpuku i'aromo har nehe. Tuwe umunehew a'e ma'e heràpuz wi uhem mehe nehe no, ipupe herenataromo Herenaw Ikatuahy Ma'e pupe wiko mehe nehe no. Nezewe mehe ainu putar itamaraka'i ukamir rehe har nehe. A'e rupi nazuka kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Emuapu'a or ikatuahy ma'e amo kawawpew zàwenugar iapo pà nehe. Ekaikair ko ze'eg hehe nehe. — Tupàn Tuweharupi Wiko Ma'e pe imonokatu pyr. ");
INSERT INTO gubBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ezàpixi a'e kawawpew zàwenugar ze'eg hereko har iàkàg iàpixi haw rehe henataromo nehe, kyhàhàm àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Tuwe Àràw umunehew wehàpykà rehe nehe. Nezewe mehe ma'e ihewe Izaew wanemirur ikatu putar ihewe nehe. Amuaze putar hezeupe ihe wà nehe. Nezewe mehe, aze uzawy a'e ma'e ihewe imur mehe wà nehe, nazepyk kwaw wanehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Epyhyk pàn irin her ma'e ikatu ma'e nehe. Emuwywyk kar a'e pàn a'e kamirpuhuz iapo pà xaxeto pe nehe. Ezapo a'e àkàg àpixi haw a'e irin ima'ema'e pà nehe no. Ezapo amo iku'aw har ma'e hagapaw hereko har izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ezapo kamirpuku Àràw ta'yr wanupe nehe. Ezapo ku'aw har wanupe nehe no. Ezapo àkàg àpixi haw wanupe nehe no. Nezewe mehe ipuràg eteahy putar teko wanenataromo wà nehe. Teko umuwete putar wà nehe no. Nuzawy kwaw tuwihaw teko wanenataromo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Emunehew kar a'e ma'e Àràw pe nehe, ta'yr wanupe nehe no. A'e re emonokatu hema'ereko haw pe ne wà nehe. Ezakook uri kawer waàkàg wanehe nehe, xaxeto herenataromo har romo wamuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Epyhyk pàn irin wanemyhar ràm iapoapo pà wanupe nehe, wamaranugar haw ipyk pà nehe. A'e temyhar oho waku'aw har wi wanenugupy pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Àràw a'e, ta'yr a'e wà nehe no, tuwe umunehew a'e temyhar heràpuzràn pupe wixe mehe a'e wà nehe. Aze uhem ma'ea'yr hapy haw huwake wà nehe, herenataromo xaxeto romo wiko mehe wà nehe, tuwe umunehew a'e temyhar wà nehe. Nezewe mehe nuexak kar kwaw umaranugar haw herenataromo wà nehe. Nezewe mehe nazuka kwaw ihe wà nehe. Àràw a'e, izuapyapyr paw rupi a'e wà nehe no, weruzar putar ko heze'eg tuweharupi a'e wà nehe, awyzeharupi a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe a'e kury. — Amume'u putar ma'e neremiapo ràm newe ihe kury. Ezapo a'e ma'e Àràw imonokatu pà ta'yr wamonokatu pà ihewe nehe, hema'ereko haw pe nehe. Ekar amo tapi'aka'yr awa nehe. Ekar mokoz àràpuhàràn hawitu ma'e awa ikatu 'ymaw hereko 'ymar ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Epyhyk arozràn iku'i kwer eho nehe no. Ezapo amo typy'ak a'e arozràn ku'i kwer pupe uri kawer inuromo har nehe. Ezapo amo typy'ak uri kawer inuromo har 'ym nehe no. Ezapo typy'ak paw imuapiruru kar haw inuromo har 'ym romo nehe. Ezapo amo typy'ak ipew katu ma'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Emono a'e typy'ak paw amo kok pupe nehe. Erur a'e kok ihewe nehe, a'e tapi'aka'yr awa izuka mehe nehe, a'e mokoz àràpuhàràn hawitu ma'e awa wazuka mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Erur Àràw heràpuzràn hereko haw henaw huken huwake ne nehe. Erur ta'yr a'e pe ne wà nehe no. Emuzahazahak kar ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","A'e re emunehew kar xaxeto ima'e Àràw pe nehe: ikamirpuku, ikamirpuku ipuhuz ma'e, iaxi'i ipykaw, ipuxi'a iwànaw, iku'aw har kamirpuku iàpixipixi haw. ");
INSERT INTO gubBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","A'e re emono iàkàg iàpixi haw hehe nehe no. Ezàpixipixi a'e kawawpew heze'eg hereko har hehe nehe no. — Tupàn Tuweharupi Wiko Ma'e pe imonokatu pyr, i'i putar ze'eg a'e kawawpew ikaikair pyrer a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","A'e re ezakook a'e uri kawer iàkàg rehe xaxeto romo imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Erur Àràw ta'yr herenataromo ne wà nehe no. Emunehew kar wakamirpuku wanehe ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Emunehew kar waku'aw har wanehe nehe no. Emunehew kar waàkàg iàpixi haw waàkàg wanehe nehe no. Nezewe emonokatu Àràw ihewe ne nehe, emonokatu ta'yr ihewe ne wà nehe no. A'e ae wà, wazuapyapyr a'e wà nehe no, wiko putar xaxeto romo herenataromo tuweharupi a'e wà nehe, awyzeharupi a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","A'e mehe erur a'e tapi'aka'yr awa heràpuzràn herenaw henataromo nehe. Àràw a'e nehe, ta'yr a'e wà nehe no, omono putar opo iàkàg rehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ezuka a'e tapi'ak a'e pe herenataromo heràpuzràn huken huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","A'e re emuàkym nekwà huwy kwer pupe nehe. Emono a'e huwy kwer nekwà rehe har ma'ea'yr hapy haw apyr wanehe nehe. Ezakook huwykwer ikurer ma'ea'yr hapy haw izypy ikokaw wanehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","A'e re emunyk tata amo ho'o kwer pehegwer ma'ea'yr hapy haw rehe hapy pà paw rupi nehe, ihewe imur pyr romo herenataromo nehe: ikawer hie kwer rehe har paw, ipy'a ipehegwer ikatu wera'u ma'e, mokoz iku'azarer, ikawer wanehe har no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Eraha ho'o kwer muitea'i teko waneko haw wi nehe. Eapy ho'o kwer a'e pe nehe. Eapy ipirer a'e pe nehe. Eapy hie kwer a'e pe nehe no. A'e ma'e izuka pyr a'e, umunyryk kar putar xaxeto wanemiapo kwer ikatu 'ym ma'e a'e xaxeto wanuwi a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","A'e re epyhyk pitài àràpuhàràn hawitu ma'e awa nehe. Àràw a'e nehe, ta'yr a'e wà nehe no, omono putar opo iàkàg rehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","A'e re ezuka a'e àràpuhàràn hawitu ma'e awa nehe. Emono'og huwy kwer nehe. Emupiripirik a'e huwy kwer a'e 4 ma'ea'yr hapy haw ipehegwer wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Epei'ài'àg a'e àràpuhàràn 4 pehegwer romo nehe. Ezuhez hie kwer nehe. Ezuhez hetymà gwer nehe no. Emuapyk a'e ma'e iàkàgwer rehe amogwer ipehegwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Eapy àràpuhàràn paw ma'ea'yr hapy haw rehe nehe, ihewe imur pyr romo nehe. Hyàkwegatu ihewe a'e. Ikatu ihewe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","A'e re epyhyk inugwer àràpuhàràn nehe. Àràw omono putar opo iàkàg rehe wa'yr wanehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","A'e re ezuka a'e àràpuhàràn hawitu ma'e awa nehe. Emuàkym nekwà huwy kwer pupe nehe. Emono huwy kwer pixik Àràw inami awyze har iapyr nehe, ta'yr wanami awyze har iapyr wanehe nehe no. Emono huwy kwer pixik wakwàhu wapo awyze har pe har wanehe nehe, wapyhàhu awyze har wanehe nehe no. Emupiripirik huwy kwer ikurer 4 ma'ea'yr hapy haw pehegwer rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Epyhyk huwy kwer ma'ea'yr hapy haw rehe har nehe. Epyhyk uri kawer xaxeto rehe àràm nehe no. Emupiripirik Àràw rehe nehe, ikamir rehe nehe no, ta'yr wanehe nehe no, wakamir wanehe nehe no. Nezewe mehe eremonokatu putar Àràw ihewe ne nehe, eremonokatu putar ta'yr ne wà nehe no, eremonokatu putar wama'e paw ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ezuka a'e àràpuhàràn hawitu ma'e awa herenataromo nehe, a'e awa xaxeto romo wamuigo kar pà ihewe nehe. Emono'og ikawer nehe. Epyhyk huwaz kwer nehe no. Emono'og ikawer hie kwer rehe har nehe no. Epyhyk ipy'a pehegwer ikatu wera'u ma'e nehe no. Epyhyk iku'azarer nehe, epyhyk ikawer iku'azarer rehe har nehe no. Epyhyk henugupy awyze har nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Epyhyk typy'ak imuapiruru kar haw inuromo 'ymar ihewe imur pyrer a'e kok wi nehe. Hexakaw hereko har nànàn epyhyk nehe. Pitài typy'ak uri kawer inuromo iapo pyrer, pitài typy'ak uri kawer inuromo iapo 'ym pyrer no, pitài typy'ak ipew ma'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Emono a'e typy'ak Àràw ipo pe ta'yr wapo pe nehe. — Pezapo typy'ak ikatu ma'e romo ihewe nehe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","A'e re epyhyk wi a'e typy'ak wapo wi nehe, hapy pà ma'ea'yr hapy haw i'aromo nehe. Hyàkwegatu putar ihewe imur pyràm romo ihewe nehe. Ikatuahy ihewe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Na'e epyhyk àràpuhàràn ipuxi'a kwer nehe, imukatu pà ihewe nehe. Ihewe imur pyr ikatu wera'u ma'e amono putar newe neremi'u ràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Xaxeto ihewe imonokatu mehe, emunyryk kar àràpuhàràn ipuxi'a kwer nehe, emunyryk kar henugupy kwer nehe no, ihewe imur pyr ikatu wera'u ma'e romo nehe. A'e re xaxeto upuner ipyhykaw rehe wemi'u ràm romo a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Tuweharupi Izaew umur putar ma'e ihewe uzemuaze kar haw romo nezewe a'e wà nehe. A'e ma'e imur mehe Àràw izuapyapyr upyhyk putar a'e ma'ea'yr ipuxi'a kwer uzeupe wemi'u ràm romo wà nehe. Upyhyk putar henugupy kwer uzeupe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Xaxeto Àràw imàno nehe, ta'yr upyhyk putar ikamirpuku paw a'e wà nehe. Ta'yr umunehew putar a'e kamirpuku ihewe uzemonokatu mehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Amo Àràw ta'yr wiko putar xaxeto romo u hekuzaromo imàno mehe nehe. Wixe putar heràpuzràn herenaw pupe nehe. Uma'ereko putar herenataromo Tupàn Henaw Ikatuahy Ma'e pe nehe. A'e pe wixe mehe nehe, tuwe umumaw 7 'ar a'e kamirpuku imunehew pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Erezuka putar àràpuhàràn hawitu ma'e awa Àràw imur katu mehe ihewe nehe, ta'yr wamur katu mehe nehe no. Tuwe umupupur ho'o kwer amo ywy pehegwer ihewe imur katu pyrer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Tuwe u'u a'e ho'o kwer a'e typy'ak kok pupe arer heràpuzràn huken huwake wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ihewe wamur katu mehe u'u putar a'e ma'e ihewe imur pyrer katu 'ygwer wanemiapo kwer imunànaw wà nehe. Xo xaxeto zo upuner a'e ma'e i'u haw rehe wà, ta'e a'e ma'e wiko ihewe imur katu pyr romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","A'e rupi, aze numumaw kwaw a'e ma'e i'u haw a'e 'ar mehe wà nehe, wapy putar ikurer tata pupe wà nehe. Nu'u kwaw amo 'ar mehe wà nehe, ta'e umur katu a'e temi'u ihewe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Azapo kar wamur katu àwàm newe. A'e mehe emumaw 7 'ar Àràw imur katu pà ta'yr wamur katu pà ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","'Ar nànàn ezuka amo tapi'aka'yr awa teko wanemiapo kwer ikatu 'ym ma'e rehe hema'enukwaw ire hemupytu'u kar pà nehe. Erezuka putar a'e ma'ea'yr teko wanemiapo kwer rehe nehe. A'e ma'e izuka haw umukatu putar ma'ea'yr hapy haw nehe, imur katu pà ihewe ikatu 'ygwer wi imunyryk kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Emumaw 7 'ar agwer ma'e iapo pà nehe. A'e mehe ma'ea'yr hapy haw ikatu putar tuwe nehe. A'e re aze amo opokok hehe wà nehe, aze wyzài ma'e uzekok hehe nehe, upuraraw putar ma'erahy wà nehe. Ta'e ikatuahy haw ikàg putar a'e nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Tuweharupi nehe, awyzeharupi nehe, 'ar nànàgatu xaxeto uzuka putar mokoz àràpuhàràna'yr hawitu ma'e awa pitài kwarahy hereko har a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Pezuka pitài àràpuhàràn ku'em mehe nehe. Pezuka inugwer àràpuhàràn karuk mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Àràpuhàràn ipy rehe we pemur arozràn iku'i kwer nehe. Tuwe heta pitài kir ipuhuz taw nehe. Pemur uri kawer nehe no. Tuwe heta pitài zutahyky'a por nehe. Pemono a'e uri kawer inuinuromo nehe. Emynehem pitài kawaw win pupe nehe. Ezakook ihewe herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Karuk mehe ezuka inugwer àràpuhàràn hawitu ma'e nehe, arozràn iku'i kwer rehe we uri kawer rehe we win rehe we ku'em mehe arer zàwegatete nehe no, temi'u ihewe imur pyr romo nehe. Hyàkwegatu putar ihewe nehe. Ikatuahy ihewe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Tuweharupi nehe, awyzeharupi nehe, peapy agwer ma'e ihewe imur pyr herenataromo nehe, heràpuzràn huken huwake nehe. Àwàxi putar teko heremiaihu ihe wà nehe. Aze'eg putar newe a'e pe ihe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Àwàxi putar teko Izaew izuapyapyr ihe wà nehe. A'e pe hereko haw uhyape katu putar nehe. A'e rupi a'e pe ikatuahy putar nehe. Hereko haw uhyape katu ma'e umumaw putar iaiw paw a'e wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Amukatu putar heràpuzràn nehe. Amukatu putar ma'ea'yr hapy haw nehe no. Amukatu putar Àràw ihe nehe, ta'yr ihe wà nehe no, xaxeto romo wamuigo kar pà herenataromo ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Aiko putar teko Izaew izuapyapyr wainuromo ihe nehe. Aiko putar wazar romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Arur Ezit ywy wi ihe wà. Ta'e hereko wer wainuromo ihe xe. Ukwaw putar Ezit wi wapyro arer romo hereko haw wà nehe. Ukwaw putar wainuromo hereko wer haw wà nehe no. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Aiko wazar romo ihe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Ekixikixi ywyra akaz her ma'e nehe. Amo ywyrapew iapo pà nehe. Ereapy putar yhyk zàwenugar hehe herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A'e ywyrapew yhyk zàwenugar hapy haw nehe, tuwe ipuku haw nuzawy kwaw ipuku haw iaikwer ma'e nehe. Heta putar 45 xenxim ipuku haw nehe. Heta putar 45 xenxim ipuku haw iaikwer ma'e nehe no. Heta putar 90 xenxim iaiha haw nehe no. 4 Iahykaw wanehe heta putar iapyr izupe wà nehe. Ezomog a'e iapyr hehe nehe, pitài ma'e romo iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ipykaw nehe, a'e 4 iapyr wà nehe no, a'e 4 ipehegwer wà nehe no, ezuwàzuwàn imupuràg eteahy kar pà or pupe nehe. Tuwe naheta kwaw ikatu 'ymaw a'e or inuromo nehe. Emuapu'a or amo iapeao haw iapo pà ywyrapew heme'y nànàgatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ezomog mokoz iapu'a ma'e a'e iapeao haw iwy pe nehe, pitài ko pehegwer rehe nehe, inugwer pehegwer rehe nehe no. Teko umuixe kar putar i'yw a'e iapu'a ma'e wanupi wà nehe, aze ipurueraha wer hehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ekixikixi ywyra akaz her ma'e i'yw iapo pà nehe. Emuapu'a or ipykaw iwànaw iapo pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Emuapyk a'e ywyrapew pànuhu uzeaiko ma'e henataromo nehe. A'e pànuhu upyta heze'eg hyru henataromo. Uruàwàxi a'e pe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ku'em mehe Àràw uzekaiw putar tatainy wanehe nehe. A'e ma'e iapo re wapy putar yhyk hyàkwegatu ma'e herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kwarahy heixe re, tatainy wanapy mehe wapy wi putar yhyk nehe no. Tuweharupi awyzeharupi xaxeto wapy putar yhyk herenataromo nehe. Ta'yr uzapo putar nezewe haw wà nehe. Ta'yr wana'yr uzapo putar nezewe haw wà nehe no. Izuapyapyr paw uzapo putar nezewe haw awyzeharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Peapy zo yhyk hekuzar 'ym ma'e tuweharupi har herenataromo nehe. Ezuka zo ma'ea'yr a'e ywyrapew rehe wà nehe. Emono zo arozràn hehe nehe. Ezakook zo win hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kwarahy nànàn pitài haw Àràw uzapo putar ma'e a'e ywyrapew imukatu pà herenataromo nehe. Umuàkym putar 4 iapyr ma'ea'yr huwy kwer pupe nehe, teko wanemiapo kwer ikatu 'ym ma'e wamunàn pà nehe. Tuwe xaxeto uzapo nezewe haw awyzeharupi wà nehe, pitài haw kwarahy nànàn wà nehe. Tuwe a'e ywyrapew ikatuahy herenataromo nehe. Tuwe pemunyryk kar katu 'ymaw wi ihewe nehe. Ta'e Tupàn Tuweharupi Wiko Ma'e romo aiko ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","— Erepapar putar teko Izaew izuapyapyr ne wà nehe. Wapapar mehe, pitàitàigatu teko umur putar amo wemetarer ihewe wà nehe, wekuwe haw hekuzaromo wà nehe. Nezewe mehe nuzeapo kwaw iaiw ma'e wanupe wapapar haw iapo mehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Amume'u putar wanekuzar ràm wanupe ihe nehe. Tuwihaw umuapyk putar wanekuzar ràm parat pape rehe wà nehe. Pitàitàigatu umur putar wekuzar ihewe wà nehe. Tupàn Tuweharupi Wiko Ma'e romo aiko ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Aze amo awa wereko 20 kwarahy wà nehe, aze itua'u wera'u 20 kwarahy hereko har wanuwi wà nehe, a'e awa umur putar wekuzar ihewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Wekuzar imur mehe hemetarer katu ma'e umur putar wemetarer a'e pape rehe imume'u pyrer wà nehe. Hemetarer 'ym ma'e nezewegatete wà nehe no. Zuawygatu putar wanekuzar ràm wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Teko Izaew izuapyapyr umur putar a'e temetarer newe wà nehe. Aze nuhyk kwaw ma'e heràpuzràn pe hema'ereko haw pe nehe, eme'eg kar a'e ma'e a'e temetarer rupi nehe. Teko Izaew umekuzar putar wekuwe haw a'e temetarer pupe wà nehe. A'e rupi hema'enukwaw putar wanehe ihe nehe. Apyro putar ma'erahy wi ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Emuapu'a itazu morog nehe, amo kawawhu zepuez taw iapo pà nehe, izypy ikokaw iapo pà nehe no. Emuapyk a'e kawawhu tàpuzràn ma'ea'yr hapy haw wamyter pe nehe. Emono 'y ipupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Àràw a'e nehe, ta'yr a'e wà nehe no, uhez putar opo upy rehe we ipupe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tàpuzràn pupe wixe 'ym mehe we ywyrapew huwake utyryk 'ym mehe we temi'u ihewe imur 'ym mehe we uhez putar opo upy rehe we wà nehe. Nezewe mehe nazuka kwaw ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Tuwe uhez opo upy rehe we wà nehe, uzezuka haw wi uzepyro pà wà nehe. A'e ae a'e wà nehe, wazuapyapyr a'e wà nehe no, tuwe weruzar katu ko heze'eg tuweharupi a'e wà nehe, awyzeharupi a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","25","— Exaexak temi'u inuromo har taz zàwenugar hyàkwegatu wera'u ma'e nehe, kàpuhàg hyàkwegatu wera'u ma'e nehe no. Emono uri kawer inuromo nehe. Kàpuhàg iapo har ukwaw katu inuinuromo ima'ema'e haw wà. Ukwaw kar putar newe wà nehe. Erezakook putar a'e uri kawer hyàkwegatu ma'e awa waàkàg wanehe nehe, xaxeto romo wamuigo kar mehe nehe. Epyhyk uri kawer 3,5 zutahyky'a por nehe. Emono 6 kir miha tykwer inuromo nehe. Emono 3 kir kaner inuromo nehe no. Emono 3 kir itakwar hyàkwegatu ma'e tykwer inuromo nehe no. Emono 6 kir kaxia her ma'e inuromo nehe no. Tuwihaw wereko ma'e puhuz taw hexakaw ikatu ma'e wà. Exaexak a'e ma'e ipuhuz taw nehe, a'e hexakaw pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ezakook a'e uri kawer ma'e inuinuromo har heràpuzràn rehe nehe. Ezakook a'e heze'eg hyru rehe nehe no. Nezewe eremurkatu putar a'e ma'e ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Ezakook ywyrapewhu rehe nehe, hehe har rehe nehe no, tatainy henaw rehe nehe no, hehe har rehe nehe no, yhyk hapy haw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ezakook a'e uri kawer ma'ea'yr hapy haw rehe nehe no, hehe har nànàn nehe no, kawawhu puhez taw rehe nehe no, i'yw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nezewe mehe eremurkatu putar a'e ma'e ihewe paw rupi katete ne wà nehe. Ikatuahy putar ihewe wà nehe. Naheta kwaw iaiw paw wanehe nehe. Wyzài teko wà nehe, wyzài ma'ea'yr wà nehe, aze opokok a'e ma'e wanehe wà nehe, aze uzekok wanehe wà nehe, upuraraw putar ma'erahy wà nehe, ta'e hekatuahy haw inuromo har ikàg tuwe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Erezakook putar a'e uri kawer hyàkwegatu ma'e Àràw rehe nehe, ta'yr wanehe nehe no. Nezewe mehe eremurkatu ihewe ne wà nehe, xaxeto romo wamuigo kar pà herenataromo ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe. — Pe nehe no, pezuapyapyr wà nehe no, tuwe uzuhen agwer uri kawer ihewe imur pyr wanehe wà nehe, awyzeharupi wà nehe, hemuwete katu pà nezewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Pezakook zo xaxeto 'ym wanetekwer wanehe nehe. Pemono zo a'e inuromo àràm inuromo nehe, amo ae ma'e iapo pà a'e uri kawer pupe nehe. Ihewe imur katu pyrer a'e. Pereko a'e ma'e hema'e ài nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","— Aze amo uzapo uri kawer ko uri kawer zàwenugar wà nehe, a'e ma'e paw imono pà inuromo wà nehe, amono kar putar a'e teko heremiaihu wanuwi ihe wà nehe. Aze amo uzakook agwer uri kawer amo xaxeto 'ym rehe wà nehe, nezewegatete ihe wà nehe, ere teko wanupe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","35","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Ezapo a'e yhyk kàpuhàg inuromo har nehe. Kàpuhàg iapo har ukwaw kar putar iapo haw newe wà nehe. Emono'ono'og ko kàpuhàg hyàkwegatu ma'e pitàitàigatu imono pyr zuawyawygatu ma'e nehe: yhyk zàwenugar mezui her ma'e, onika, yhyk zàwenugar muhàg romo iapo pyr, yhykete. Emono xa inuromo nehe. A'e mehe na'inem kwaw nehe. Upyta putar ikatuahy ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Emuku'iku'i a'e yhyk nehe, te nuzawy kwaw ywyku'i nehe. A'e re eraha heràpuzràn pupe nehe. Uruàwàxi putar a'e pe ihe nehe. Emono a'e yhyk imuku'i pyrer heze'eg hyru henataromo nehe. Ikatuahy ma'e romo Tupàn pe imono pyrer romo a'e, peze izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Aze pezapo yhyk hapy pyràm pezeupe nehe, pemono zo a'e ma'e inuromo nehe. Xo ihewe imur pyr pezapo nezewe nehe. Ikatuahy ma'e romo ihewe imurahy pyrer romo peme a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Aze amo uzapo kàpuhàg nezewe uzeupe wà nehe, pemono kar muite heremiaihu wanuwi pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","— Aexaexak Mezarew Uri ta'yr Ur hemimino Zuta izuapyapyr ihe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Amynehem Herekwe pupe ihe. Amono ma'e kwaw paw izupe. Amono ma'e iapo haw kwaw paw izupe no. Amono ma'e iapo haw kwaw katu haw izupe no. A'e rupi upuner wyzài ma'e ipuràg eteahy ma'e iapo haw rehe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ukwaw ma'eragaw paw pape rehe pàn rehe ywyra rehe imuapykaw. Ukwaw or imuapu'a haw. Ukwaw parat imuapu'a haw no. Ukwaw itazu morog imuapu'a haw no. ");
INSERT INTO gubBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ukwaw ita hekuzar katu ma'e imonohokaw a'e, ukwaw ita imomogaw amo ma'e rehe no. Ukwaw ywyra ikixikixi katu haw amo ma'e iapo pà no. Wyzài ma'e iapo haw ukwaw kury. ");
INSERT INTO gubBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Amo ae awa aexak ihe no. Aoriaw her romo a'e. Aizamak ta'yr romo Nà izuapyr romo hekon a'e. Amuma'ereko kar putar Mezarew hehe we ihe nehe. Apytywà putar ipuràg eteahy ma'e iapo har paw ihe wà nehe, ko ma'e heremiapo karer paw iapo kar pà wanupe ihe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Na'aw heremiapo karer waner xe wà: heràpuzràn, heze'eg hyru, iwàpytymaw, heràpuzràn pupe har paw, ");
INSERT INTO gubBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ywyrapew, kawaw ywyrapew pe har paw, tatainy henaw or ikatu ma'e iapo pyrer, hehe har paw, huwake har paw, ywyrapew yhyk hapy haw, ");
INSERT INTO gubBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ma'ea'yr hapy haw, hehe har paw, huwake har paw, kawawhu, i'yw, ");
INSERT INTO gubBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","kamir pàn ikatuahy ma'e iapo pyrer, kamir Àràw hemimunehew ràm ta'yr wanemimunehew ràm xaxeto romo ma'e iapo mehe àràm, ");
INSERT INTO gubBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","uri kawer xaxeto àkàg rehe àràm, yhyk hyàkwegatu ma'e herenaw ikatuahy ma'e pàràm. Tuwe uzapo a'e ma'e paw heze'eg awer rupi katete wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Amume'u putar amo ae ma'e newe nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Emume'u a'e ma'e teko Izaew izuapyapyr wanupe nehe. — Pemurkatu 7 haw 'ar 'ar hepytu'u haw ihewe nehe, pepytu'u pà nehe. Nezewe pexak kar putar herehe we pezemono'ogaw awyzeharupi nehe. Ihe Tupàn Tuweharupi Wiko Ma'e ihe, apomono'og heremiaihu romo ihe. Aze pepytu'u 7 haw 'ar mehe nehe, pexak kar putar pemono'ono'og awer amogwer wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","A'e rupi pepytu'u mytu'u haw 'ar rehe ihewe nehe, ta'e nezewe mehe pemur katu a'e 'ar ihewe nehe xe. Aze amo uma'ereko a'e 'ar mehe wà nehe, aze numur katu kwaw a'e 'ar ihewe wà nehe, pezuka kar a'e teko pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Pepuner inugwer 6 'ar rehe pema'ereko haw rehe nehe. 7 haw har mehe pepytu'u pema'ereko re ihewe imur katu pà nehe. Aze amo uzapo wyzài uma'ereko haw a'e 'ar mehe nehe, pezuka kar nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Tuwe teko Izaew izuapyapyr umurkatu a'e 'ar ihewe zanezeupeupe ze'eg awer iapo katu awer hexak kar pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tuweharupi awyzeharupi ihe Tupàn Tuweharupi Wiko Ma'e azemono'og Izaew wanehe we ihe. Pepytu'u àwàm wexak kar putar zanezemono'og awer teko wanupe nehe. Amumaw 6 'ar ywak ywy iapo pà ihe. 7 haw 'ar mehe apytu'u hema'ereko re ihe, a'e ma'e iapo re ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Umumaw Tupàn Tuweharupi Wiko Ma'e Moizez pe uze'egaw ywytyr Xinaz rehe har kury. A'e re omono mokoz itapew izupe kury. A'e 'ym mehe we Tupàn umuapyk uze'eg hehe. Umuapyk ma'e wemimutar hehe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Iàrew tuwe Moizez ywytyr rehe. — Nuwezyw kwaw ru'u nehe, i'i teko Izaew izuapyapyr uzeupeupe wà. A'e rupi uzemono'og oho Àràw huwake wà kury. — Ne nehe ty, ezapo amo tupàn hagapaw urewe ne wà nehe ty. A'e ae oho putar urerenataromo wà nehe, ureata mehe wà nehe, i'i izupe wà. — Nurukwaw kwaw Moizez Ezit wi uremuhem kar arer pe uzeapo ma'e kwer ure, i'i teko Àràw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Uze'eg Àràw teko wanupe. — Peze'eg penemireko wanupe pena'yr wanupe penazyr wanupe nehe. — Pemur penamipor or iapo pyrer urewe nehe, peze wanupe nehe. Wama'e ipyhyk mehe perur ihewe nehe, i'i Àràw wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","A'e rupi teko paw wenuhem unamipor uzewi wà kury, Àràw pe herur pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Upyhyk Àràw wama'e wanuwi. Umupyràn a'e or ma'eragapaw iapo haw pupe paw rupi, tapi'aka'yr hagapaw iapo pà. Na'e tuwihaw uze'eg teko wanupe wà kury. — Nà'àg tupàn pezar, Izaew wà. A'e ae perur Ezit ywy wi a'e, i'i mua'u wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Na'e Àràw uzapo ma'ea'yr hapy haw a'e tapi'aka'yr hagapaw henataromo. — Pyhewe xiapo putar mynykawhu Tupàn Tuweharupi Wiko Ma'e pe nehe, i'i teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","A'e rupi iku'egwer pe teko paw ume'e izi'itahy upu'àm pà wà kury. Uzuka ma'ea'yr wanapy pà wà. Omono ma'e a'e tapi'aka'yr pe wà. A'e re wapyk mai'u hawhu iapo pà wà. U'u kàwiahy tetea'u wà. A'e re uzeupir ikatu 'ym ma'e iapo pà wà kury, uzepuhepuhe ohooho pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. — Ewezyw na'arewahy ywytyr wi nehe kury, ta'e teko neremiaihu a'e wà xe, Ezit ywy wi penemirur kwer a'e wà xe, iaiw ma'e romo wanekon a'e wà kury xe. Uzapo ikatu 'ym ma'e hereityk pà wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Amuata kar herape rupi ihe wà. Na'arewahy uhem herape wi wà. Uma'ema'e or tapi'aka'yr hagapaw uzar tupàn romo iapo pà wà. Uzemumew henataromo wà. Uzuka ma'ea'yr izupe wà. — Nà'àg Tupàn Ezit wi penerur arer xe, Izaew ty wà, i'i tuwihaw teko wanupe wà, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","— Aexak a'e teko ihe wà, nahereuzarahy kwaw a'e wà, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","— Ehem xe wi ihewi kury ty. Hereko wer ihe zutyka'i xe ihe. Nezewe mehe hekwahy haw upuner putar wanapy haw rehe nehe. Nezewe mehe azuka putar wamumaw pà ihe wà nehe. A'e re amueta tetea'u putar nezuapyapyr ihe wà nehe, wanekuzar romo ihe wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nezewe rehe we Moizez wenoz wi ma'e Tupàn pe kury. — O Tupàn Tuweharupi Wiko Ma'e, màràzàwe tuwe erekwahy teko neremiaihu wanupe. Ne ae ererur a'e teko Ezit ywy wi nekàgaw rupi ne wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Aze erezuka kutàri ne wà nehe, a'e mehe Ezit ywy rehe har uze'eg zemueteahy putar nerehe a'e wà nehe. — Tupàn weraha Izaew izuapyapyr Ezit ywy wi a'e wà, ta'e ipuruzuka wer wanehe ywytyruhu rehe a'e xe, i'i putar nerehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nema'enukwaw katu newe uma'ereko ma'e kwehe arer wanehe nehe: Àmàrààw, Izak, Izaew. — Amueta tetea'u putar pezuapyapyr ihe wà nehe. Waneta haw nuzawy kwaw zahytata ywak rehe har waneta haw wà nehe, ere wanupe nerer rupi imume'uahy pà. — Amono putar ko ywy paw wanupe heremimume'u kwer rupi ihe nehe. Wiko putar hehe awyzeharupi wà nehe, ere tuwe wanupe. A'e rupi nerepuner kwaw wazuka haw rehe kury, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","A'e rupi Tupàn upytu'u wikwahy re kury. Nuzuka kwaw uze'eg awer rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Uzewyr wi Moizez oho ywytyr wi kury, a'e mokoz itapew Tupàn ze'eg hereko har heraha pà kury. Heta ze'eg imuapyk pyrer hehe a'e, ikupe pe a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tupàn a'e ae uzapo a'e itapew a'e, a'e ae ukair uze'eg hehe a'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Zuzue uzewyr Moizez rupi ywytyr wi. Wenu Zuzue wanehapukaz mehe a'e wà. — Aze ru'u teko tetea'u uzeàmàtyry'ym waiko wà, i'i Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Uze'eg Moizez Zuzue pe. — Nan kwaw teko ze'egaw wàmàtyry'ymar wamumaw mehe har. Nan kwaw teko waànoànogaw waneityk mehe har. Teko wazegar haw ainu iteko ihe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Uhem Moizez teko wanàpuz huwake waneko haw huwake kury. Wexak tapi'aka'yr or iapo pyrer. Wexak teko wapynyk mehe wà. Wikwahy tuwe kury. Omomor a'e itapew heityk pà ywytyr izypy pe. Uzeka itapew a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Upyhyk tapi'aka'yr teko wanemiapo kwer kury. Wapy tata pupe. Umuku'i tapi'aka'yr ywyku'i kwer zàwenugar romo. Uhàuhàz iku'i kwer 'y rehe. A'e re u'u kar Moizez a'e 'y Izaew izuapyapyr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Uze'eg Àràw pe. — Aipo teko uzapo iaiw ma'e newe wà. Màràzàwe tuwe erezapo kar agwer iaiw ma'e wanupe, i'i. ");
INSERT INTO gubBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","— Eikwahy zo ihewe ty, i'i Àràw izupe. — Ipurapo wer ikatu 'ym ma'e rehe tuweharupi wà. Erekwaw waneko haw. ");
INSERT INTO gubBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","— Ezapo amo tupàn hagapaw urewe, i'i ihewe wà. — Moizez urererur Ezit ywy wi a'e, nuruexak kwaw ure kury. Ma'e uzeapo izupe. Aze erezapo tupàn hagapaw urewe ne wà nehe, wata putar urerenataromo wà nehe, i'i ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","A'e rupi aze'eg nezewe wanupe ihe. — Aze heta kuzà wamupuràgete haw or iapo pyrer peme nehe, pemur ihewe nehe, a'e wanupe. A'e rupi umur wama'e or ihewe wà. Amupyràn or tata pupe. Tàrityka'i tapi'aka'yr hagapaw opor wà tata wi urewe, i'i mua'u Àràw Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","(Àràw nueruze'eg kwaw teko wà.) Teko hehaite wà, wyzài iaiw ma'e iapo pà wà. Moizez wexak wanemiapo kwer. Àràw nueruze'eg kwaw teko wà. A'e rupi waàmàtyry'ymar upuka wanehe wà, wanehe uze'eg zemueteahy pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","A'e rupi upu'àm Moizez waneko haw pe heixe haw huwake kury, teko wanupe uze'eg pà kury. — Aze ereiko Tupàn heruzar har romo, ezur xe heruwake nehe, i'i wanupe pitàitàigatu. Erewi izuapyapyr paw oho huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Na'e uze'eg wanupe kury. — Tupàn Tuweharupi Wiko Ma'e, Izaew wazar uze'eg iko nezewe a'e. — Awakwer pitàitàigatu upyhyk putar utakihe puku teko waker haw nànàn oho pà wà nehe. Peata Izaew waneko haw nànàn nehe. Pezuka penyky'yr pe wà nehe. Pezuka penywyr pe wà nehe. Pezuka pemyrypar pe wà nehe. Pezuka penapihar pe wà nehe, i'i Moizez wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Awakwer Erewi izuapyapyr weruzar ize'eg oho wà kury. Uzuka 3.000 awa ru'u a'e 'ar mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Na'e uze'eg wi Moizez Erewi izuapyapyr wanupe. — Tupàn pemurkatu uzeupe kutàri a'e, ta'e peiko pena'yr waàmàtyry'ymar romo pe xe, ta'e peiko penyky'yr penywyr waàmàtyry'ymar romo pe xe. A'e rupi omono uze'egatu penehe we kury, i'i Moizez. ");
INSERT INTO gubBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Iku'egwer pe Moizez uze'eg teko wanupe. — Iaiw ma'e uhua'u ma'e pezapo kury. Nezewe rehe we ihe aha wi putar Tupàn Tuweharupi Wiko Ma'e huwake ihe nehe. Aze ru'u apuner imupytu'u kar haw rehe ikwahy re ihe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","A'e rupi Moizez uzeupir wi ywytyr rehe Tupàn Tuweharupi Wiko Ma'e pe uze'eg pà. — Ko teko uzapo iaiw ma'e uhua'u ma'e azeharomoete a'e wà. Umuapu'a or tupàn amo hagapaw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nereharaz wanemiapo kwer wi nehe. Emunàn a'e iaiw ma'e wanuwi nehe. Nezewe rehe we aze nerepuner kwaw nereharaz taw rehe wanemiapo kwer wi nehe, a'e mehe emunàn herer nepape wi nehe. Eremuapyk neremiruze'eg waner a'e pape rehe ne wà. Ezepyk herehe wanekuzaromo nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Namunàn kwaw nerer hepape wi nehe. Wyzài teko nehe, aze uzapo ikatu 'ym ma'e heze'eg ihaw pà nehe, amunàn putar her hepape wi ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Eho nehe kury, eraha teko a'e ywy heremimume'u kwer pe nehe kury. Hereko haw pe har wata putar oho penenataromo nehe. Nezewe rehe we amo 'ar mehe uhem putar wanehe hezepyk àwàm 'ar nehe. A'e 'ar mehe azepyk putar wanehe ihe nehe, i'i Tupàn izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","A'e re Tupàn Tuweharupi Wiko Ma'e omono kar amo ma'eahy haw iaiw ma'e Izaew wanehe kury. Ta'e uzapo kar a'e tapi'aka'yr hagapaw Àràw pe a'e 'ym mehe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Na'e uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe a'e kury. — Ne nehe ty, teko Ezit ywy wi neremirur kwer paw a'e wà nehe no ty, pehem peho xe wi ko ywy wi nehe no ty. Kwehe mehe amume'uahy amo ywy peipy wanupe waneko àwàm romo ihe. Amume'u a'e ywy wanupe ihe: Àmàrààw, Izak, Zako. — Amono putar a'e ywy pezuapyapyr wanupe waneko àwàm romo ihe nehe, a'e peipy wanupe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","— Amono kar putar amo hereko haw pe har penenataromo ihe nehe. A'e ae umuhem kar putar teko a'e ywy wi wamono kar pà a'e wà nehe. Ai'aw a'e awa waner xe wà: Amuhem kar putar wazuapyapyr penenatar wi ihe wà nehe. Kànàà, Amohe, Ete, Perize, Ewe, Zepu. ");
INSERT INTO gubBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Peho putar a'e ywy kutyr nehe. Ikatuahy a'e ywy. Heta tetea'u temi'u a'e pe no. Nezewe rehe we ihe naha kwaw penupi ihe nehe. Ta'e peiko heze'eg heruzar 'ymar romo xe. Aze mo aha penupi, apuzuka mo pe rupi peata mehe, i'i Tupàn teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","A'e ze'eg henu mehe uzemumikahy teko wà. Uzypyrog uzai'o pà wà. Kuzà numunehew kwaw or wà, ni itapuràg wà, ta'e nahurywete kwaw wà xe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg nezewe Moizez pe a'e. — Eze'eg nezewe Izaew wanupe nehe, i'i Tupàn izupe. — Peiko heze'eg heruzar 'ymar romo. Aze mo ata penupi, aze mo amumaw xo pitài 'ar zo penupi heata pà, a'e mehe mo apuzuka ru'u mo ihe. Pezo'ok pemupuràgetea'i haw penetekwer wanuwi nehe ty wà. Amume'u putar peme heremiapo ràm ihe nehe kury, ere Izaew wanupe nehe, i'i Tupàn Moizez pe. A'e rupi Moizez umume'u a'e ma'e oho Izaew izuapyapyr wanupe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","A'e rupi Izaew izuapyapyr Xinaz ywytyr wi uhem ire, numunehew kwaw or wà. Numunehew kwaw itapuràg wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Tuweharupi, Izaew uker haw imuàgà'ym mehe Moizez umuapyk Tupàn hàpuzràn katu pe muitea'i waker haw wi a'e. — Tàpuzràn Tupàn Henaw, i'i teko izupe wà. Aze amo ipuranu wer Tupàn rehe wà, oho a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moizez a'e pe iho mehe, teko paw upu'àm wàpuzràn huwake wà, Moizez rehe ume'e pà wà, te wixe ipupe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moizez tàpuzràn pupe heixe mehe a'e ywàkun upu'àm ma'e wezyw a'e pe uken huwake upyta pà. Upyta a'e pe Tupàn Tuweharupi Wiko Ma'e Moizez pe ize'eg mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Aze teko wexak a'e ywàkun tàpuzràn huken huwake ipu'àm mehe wà, upaw rupi wapyk upenàràg rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tuweharupi Tupàn Tuweharupi Wiko Ma'e uhem Moizez huwakea'i izupe uze'eg pà awa umyrypar pe uze'eg ma'e ài a'e. A'e re Moizez uzewyr teko waker haw pe. Ipytywà har kwàkwàmo Zuzue Nun ta'yr her ma'e a'e, upyta a'e tàpuzràn pupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Uze'eg Moizez Tupàn Tuweharupi Wiko Ma'e pe. — Tuweharupi eremume'u ko ma'e ihewe. Eraha ko teko nehe, eiko waneruze'egar romo nehe, ere iko ihewe tuweharupi. Neremume'u kwaw herupi oho ma'e ràm hepytywà àràm ihewe ne, i'i izupe. — Urukwaw katu ihe, akwaw katu nerer ihe, nekatuahy ihewe, ere iko ihewe tuweharupi, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","— Aze hekatuahy tuwe newe azeharomoete nehe, hemu'e pe nerape rehe nehe. A'e rupi urukwaw putar ihe nehe no. Nezewe mehe urumurywete kar wiwi putar ihe nehe no. Ko teko a'e wà, neremiaihu romo wanekon a'e wà. Nema'enukwaw waneko haw rehe nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","— Ihe ae aha putar nerupi ihe nehe. A'e rupi ereityk putar neàmàtyry'ymar ne wà nehe, ta'e urupytywà putar ihe nehe xe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Na'e Moizez uze'eg wi Tupàn pe kury. — Aze nereho kwaw urerupi nehe, uremono kar zo pe xe wi nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","— Ureamutar katu pe ne. Aze nereho kwaw urerupi nehe, teko nukwaw kwaw heamutar katu haw a'e wà nehe, nukwaw kwaw ureamutar katu haw a'e wà nehe. Aze nereho kwaw urerupi nehe, uruiko putar wyzài teko ywy rehe har wazàwe ure nehe. — Wiko urezàwegatete, i'i putar teko urewe wà nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","— He'e, ty. Azapo putar nereminozgwer nehe, ta'e nekatuahy ihewe ne xe, ta'e urukwaw katu ihe xe, ta'e akwaw nerer ihe xe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na'e i'i Moizez Tupàn pe kury. — Exak kar nekàgaw nepuràg eteahy haw ihewe nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Uze'eg Tupàn Moizez pe kury. — Amugwaw kar putar hekatu haw nerenataromo paw rupi nehe kury. Amume'u putar herer Tupàn Tuweharupi Wiko Ma'e newe nerenataromo nehe no. Aze hepurupuhareko wer amo rehe nehe, apuhareko putar nehe. Aze hepuraihu wer amo rehe nehe, aihu katu putar ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Heruwa nerepuner kwaw hexakaw rehe nehe, ta'e aze amo wexak heruwa nehe, umàno putar nehe. Ni amo nupuner kwaw heruwa hexakaw rehe a'e wà. Aze amo wexak nehe, umàno putar nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","— Heta nepyta haw xe heruwake. Erepuner nepyta haw rehe pepa'i a'e itahu rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Hekàgahy haw hepuràg eteahy haw ukwaw putar neruwake nehe. Ikwaw mehe nehe, oromonokatu putar itawokaw pupe nehe. Urupyk putar hepo pupe nehe, hekwaw mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","A'e re amunyryk putar hepo newi nehe. A'e mehe erexak putar hekupe nehe. Nerexak kwaw heruwa nehe, i'i izupe. Na'e uzapo wemimume'u kwer kury. ");
INSERT INTO gubBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. — Emonohok wi ita mokoz itapew iapo pà a'e itapew izypy mehe arer zàwenugar nehe. Amuapyk wi putar heze'eg a'e itapew rehe nehe, itapew izypy mehe arer rehe arer zàwenugar nehe. Erezuka a'e itapew ipy, ywy rehe heityk pà. ");
INSERT INTO gubBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pyhewe izi'itahy ezemuàgà'ym nehe. Ezeupir Xinaz ywytyr rehe nehe. Ezexak kar ihewe a'e pe ywytyr apyr nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ni amo teko nupuner kwaw nerupi ur haw rehe wà nehe. Ni amo teko nupuner kwaw ywytyr rehe weko haw rehe a'e 'ar mehe wà nehe. Ni waneimaw àràpuhàràn hawitu ma'e ni àràpuhàrànete ni waneimaw tapi'ak nupuner kwaw ywytyr huwake weko haw rehe umai'u pà wà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","A'e rupi Moizez omonohok ita mokoz itapew iapo pà kury, izypy mehe arer zàwenugar kury. Iku'egwer pe izi'itahy ume'e upu'àm pà. Uzeupir oho ywytyr rehe Tupàn ze'eg rupi katete. Weraha a'e mokoz itapew opo pe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Na'e Tupàn Tuweharupi Wiko Ma'e wezyw wà ywàkun pupe kury. Upu'àm a'e pe Moizez huwake kury. Umume'u uwer ikatuahy ma'e izupe. — Tupàn Tuweharupi Wiko Ma'e romo aiko ihe, i'i Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ukwaw Tupàn oho Moizez henataromo. Ukwaw mehe uze'eg nezewe uzehe kury. — Tuweharupi wiko ma'e romo aiko ihe, Tupàn Tuweharupi Wiko Ma'e romo aiko ihe. Apurupuhareko ihe, apuraihu ihe: Heàrew hekwahy pà. Napytu'u kwaw heremiaihu wamutar katu re. Uhua'u hepuruamutar katu haw. Teko nupuner kwaw hepuruamutar katu haw paw ikwaw paw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","— Hereharaz putar pekatu 'ymaw wi penemiapo kwer ikatu 'ym ma'e wi ihe nehe, a'e teko wanupe kwarahy nànàn ihe. Nezewe rehe we napytu'u kwaw wana'yr wanehe wamimino wanehe hezepyk ire ihe, wanu wanemiapo kwer ikatu 'ym ma'e rehe ihe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Uzemumew Moizez ywy rehe kury. Umuwete katu uzar Tupàn a'e pe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","— O Tupàn hezar, aze hekatu newe, eho urerupi nehe. Ko teko neremiaihu a'e wà, nuweruzar katu kwaw neze'eg a'e wà. Nereharaz ureremiapo kwer ikatu 'ygwer wi nehe. Nereharaz ureaiw paw wi nehe. Urereraha pe ywy ureremipyhyk ràm me nehe, i'i Moizez Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Uze'eg Tupàn Tuweharupi Wiko Ma'e izupe. — Amume'uahy putar heremiapo ràm peme nehe kury, heze'egaw iapokatu pà penehe we nehe kury. Neremiruze'eg wanenataromo azapo putar ma'e temixak 'ym ihe nehe. Ni amo ywy rehe har nuexak kwaw agwer ma'e heremiapo ràm zàwenugar wà. Peiko amo teko wainuromo. A'e teko wexak putar peme heremiapo ràm wà nehe. Ipytuhegatu putar hexak mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Peruzar heze'eg kutàri har nehe. A'e mehe amuzàn kar a'e ywy rehe har penenatar wi ihe wà nehe. Ai'aw a'e teko waner wà: Amohe ywy rehe har wà, Kànàà izuapyapyr wà, Ete izuapyapyr wà, Perize izuapyapyr wà, Ewe izuapyapyr wà, Zepu izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pezapokatu zo peze'egaw a'e ywy rehe har wanehe we nehe, ywy peneko àwàm rehe har wanehe we nehe. Aze pezapokatu peze'egaw wanehe we nehe, na'ikatu kwaw peme nehe. Uzapo kar putar iaiw ma'e peme wà nehe. Aikwahy putar peme a'e ma'e hexak mehe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","A'e teko uzapo ma'ea'yr hapy haw tupàn a'ua'u wanupe wà. Peityk wama'ea'yr hapy haw nehe. Pemumaw waita tupàn a'ua'u pe imonokatu pyr nehe no. Pemonohok ywyra tupàn ua'u ha'agapaw imupu'àm pyrer nehe no, heityk pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","— Pemuwete zo amo ae tupàn pe wà nehe. Ta'e ihe Tupàn pezar azeharomoete har ihe xe, hewyrowyroahy ma'e romo aiko ihe xe. Hewyrowyroahy ma'e herer inugwer romo ihe. Hemuwete katu pe nehe. Pemuwete katu zo amo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Pezapokatu zo peze'egaw a'e ywy rehe har wanehe we nehe. Kuzà wyzài a'e wà, uker oho wyzài awa puhe a'e wà. Nezewegatete a'e ywy rehe har umuwete katu wyzài tupàn a'ua'u a'e wà no. Uzuka ma'ea'yr wanenataromo wamuwete katu pà wà. A'e ma'e iapo mehe wà nehe, penenoz putar wà nehe. Pe'u putar a'e ma'ea'yr ho'o kwer wainuromo nehe no. (Iro putar penemiapo ràm ihewe nehe.) ");
INSERT INTO gubBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Pexaexak putar amo wanazyr pe wà nehe no, pena'yr wanupe wanemireko ràm romo pe wà nehe no. A'e kuzà a'e wà nehe, pena'yr wanemireko a'e wà nehe, umuwete tupàn a'ua'u wà. Pemuwete katu kar putar tupàn a'ua'u pemupytu'u kar pà hemuwete re a'e wà nehe. Umuwete katu kar putar tupàn a'ua'u pena'yr wanupe wà nehe no, umen wanupe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Pemupyràn zo ita per nehe, tupàn a'ua'u wanagapaw iapo pà nehe. Pemuwete zo hagapaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Kwarahy nànàn pezapo mynykawhu typy'ak imuapiruru kar pyrer 'ym her ma'e herenataromo nehe. Pemumaw 7 'ar typy'ak imuapiruru kar pyrer i'u pà nehe, heze'eg awer rupi katete nehe. Pezapo a'e mynykaw zahy Amim her ma'e rehe nehe, heze'eg awer rupi katete nehe. Ta'e a'e zahy rehe pehem pezuwà Ezit ywy wi pe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Uhy wi uzexak kar ma'e kwer ipy wà nehe, wiko hema'e romo paw rupi wà nehe. Kuzà wi uzexak kar ma'e kwer ipy wà nehe, ma'ea'yr wi uzexak kar ma'e kwer ipy wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pemekuzar zumen uzexak kar ma'e kwer ipy amo àràpuhàràn hawitu ma'e awa pupe nehe. Aze napepurumekuzar wer kwaw hehe nehe, pezuhaw iazu'yw nehe. Aze peputar pena'yr ipy pe wà nehe, pemur wanekuzar heremimume'u kwer ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Pemumaw putar 6 'ar pema'ereko pà nehe. 7 haw 'ar mehe pepytu'u putar nehe. Ko iapo mehe nehe, temi'u ipo'o mehe nehe no, pepytu'u putar 7 haw 'ar mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Pezapo Ipo'o Haw Mynykawhu nehe, arozràn ipo'o haw 'ar ipy mehe nehe. Pezapo Mynykawhu Tàpuzràn Pixika'i Ma'e her ma'e nehe, ma'e'a ipo'o haw 'ar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Awakwer penehe we har paw uzexak kar putar wà herenataromo wà nehe. Ta'e aiko pezar ikàg ma'e romo ihe xe. Kwarahy nànàn ur putar na'iruz haw herenataromo wà nehe, ta'e aiko Izaew wazar romo ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Amuhem kar putar teko paw penenatar wi a'e ywy wi ihe wà nehe. Amuhua'u kar putar peiwy penenataromo nehe. Aze pezexak kar pezuwà herenataromo nehe, na'iruz haw kwarahy nànàn a'e mynykaw iapo pà nehe, ni amo nuzeagaw kwaw peiwy ipyhyk pà pewi mynykaw iapo mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Aze pemur ma'ea'yr ho'o kwer ihewe nehe, perur zo typy'ak imuapiruru kar haw a'e ho'o kwer inuromo nehe. Aze pezapo mynykawhu Tupàn zane'aromo ikwaw pawer her ma'e nehe, pe'u ma'ero'okwer paw pyhaw nehe. Pezar zo ma'ero'okwer i'u pyr 'ym a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Perur temi'u ipo'o pyrer ipy ikatu wera'u ma'e heràpuz me nehe. Pemupupur zo àràpuhàràn imemyr uhy kamykwer pupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Na'e Tupàn Tuweharupi Wiko Ma'e i'i Moizez pe kury. — Emuapyk ko heze'eg paw nehe. Ta'e amume'uahy heremiapo ràm ko heze'eg inuromo newe ihe xe, Izaew izuapyapyr wanupe ihe no xe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moizez a'e, umumaw 40 'ar a'e pe typy'ak i'u 'ym pà a'e, 'y i'u 'ym pà a'e no. Umuapyk Tupàn ze'eg itapew rehe. Heta 10 ze'eg pehegwer. 10 Tupàn hemiapo putar haw, za'e izupe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Wezyw Moizez Xinaz ywytyr wi a'e kury, a'e mokoz itapew Tupàn ze'eg hereko har herur pà opo pupe a'e kury. Huwa uhyape katu, heny katu. Ta'e uze'eg Tupàn pe a'e 'ar rehe a'e xe. Nukwaw kwaw uwa heny katu haw. ");
INSERT INTO gubBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Wexak Àràw Moizez a'e kury. Izaew izuapyapyr paw wexak a'e wà no. Heny katu huwa. Ukyze izuwi wà. Na'ihem wer kwaw huwake wà. ");
INSERT INTO gubBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nezewe rehe we Moizez uhapukaz wanupe. A'e rupi Àràw oho huwake teko waneruze'egar wanehe we kury. Uze'eg wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","A'e re Izaew paw uhem huwake wà. Omono Tupàn Tuweharupi Wiko Ma'e ze'eg paw wanupe, ze'eg Xinaz ywytyr rehe imur pyrer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moizez a'e kury, wanupe uze'eg pawire upyk uwa pàn pupe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tàpuzràn pupe Tupàn Tuweharupi Wiko Ma'e pe uze'eg pà wixe mehe wenuhem pàn uwa iwànaw. Upyta a'e pe uwa ipyk 'ym pà. A'e wi uhem mehe umume'u Tupàn ze'eg paw Izaew wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Teko wexak huwa heny katu wiwi haw wà. A'e rupi Moizez upyk wi uwa pàn pupe. Xo Tupàn pe uze'eg wi mehe tàpuzràn pupe oho wi mehe wenuhem wi pàn uwa wi. ");
INSERT INTO gubBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Na'e omono'og Moizez Izaew izuapyapyr paw wanupe uze'eg pà a'e wà kury. — Ko ma'e Tupàn uzapo kar iko peme kury. ");
INSERT INTO gubBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Pemumaw 6 'ar pema'ereko pà. 7 haw 'ar mehe pepytu'u pema'ereko re nehe. Pemonokatu mytu'u haw 'ar ihewe nehe. Pepytu'u pema'ereko re a'e 'ar mehe nehe. Pemuwete katu Tupàn nezewe nehe. Aze amo uma'ereko a'e 'ar rehe nehe, pezuka nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Pema'ereko tata iapo mehe. A'e rupi pemunyk zo tata penàpuz me mytu'u haw 'ar mehe nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Uze'eg wi Moizez Izaew izuapyapyr nànàn. — Ko ma'e Tupàn Tuweharupi Wiko Ma'e uzapo kar iko peme kury. ");
INSERT INTO gubBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Pepyhyk pema'e kurer Tupàn Tuweharupi Wiko Ma'e pe imono pyràm romo nehe, izupe heraha pà nehe. Aze amo iporomono wer ma'e hekuzar katu ma'e rehe izupe wà nehe, tuwe weraha izupe wà nehe: or, parat, itazu morog, ");
INSERT INTO gubBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e, pàn hekuzar katu ma'e irin her ma'e, ");
INSERT INTO gubBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","àràpuhàrànete hawer, àràpuhàràn hawitu ma'e awa ipirer imupiràg pyrer, ma'epirer ikatuahy ma'e, ywyra akaz her ma'e, ");
INSERT INTO gubBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","uri kawer tatainy pupe àràm, taz zàwenugar uri kawer inuromo imono pyràm, yhyk zàwenugar, ");
INSERT INTO gubBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ita hekuzar katu ma'e unik her ma'e, amo ae ita hekuzar katu ma'e. Xaxeto Tupàn imuwete katu haw rehe ma'ea'yr zuka har omono putar a'e ita ukamirpuku inugwer kamir i'aromo har rehe wà nehe, xaxeto wanuwihaw ipuxi'a rehe har rehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Aze amo pepyr har ukwaw ma'e iapo katu haw wà nehe, tuwe ur wà nehe, ma'e iapo pà Zanezar ze'eg rupi katete wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Uzapo putar agwer ma'e paw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tupàn hapuzràn, ipyk àwàm ipupe har, ipyk àwàm katu pe har no, ma'e tàpuzràn rehe har paw: ma'ekokaw, izyta, iapyteraromo har, i'yw, iwy pe har, Tupàn ze'eg itapew rehe imuapyk pyrer hyru ràm, i'yw no, ipykaw no, pàn Tupàn Henaw Ikatuahy Ma'e Henaw Ikatu Wera'u Ma'e wamytepe har, ");
INSERT INTO gubBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ywyrapew, ihàm, hehe we har paw no, typy'ak Tupàn pe imono pyrer, ");
INSERT INTO gubBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","tatainy henaw, henaw rehe har no, tatainy, uri kawer tatainy pupe har no, ");
INSERT INTO gubBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","yhyk zàwenugar ikaz taw, ikaz taw ihàm no, uri kawer purehe izakook pyràm, yhyk zàwenugar hyàkwegatu ma'e, pànuhu tàpuzràn ukenaw pe har, ");
INSERT INTO gubBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ma'ea'yr hapy haw, hehe har imuparipari pyrer morog iapo pyrer, ma'ea'yr hapy haw ihàm, hehe we har paw no, 'yryru, 'yryru henaw, ");
INSERT INTO gubBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","pànuhu katu pe imuzeaiko pyrer, pànuhu izyta no, iwy pe har no, pànuhu ipupyaikaw pyrer hukenaw rehe har, ");
INSERT INTO gubBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tàpuzràn izyta, ihàm no, izywyr katu haw izyta no, ihàm no, ");
INSERT INTO gubBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","xaxeto wama'e Tupàn henaw ikatu wera'u ma'e pupe imunehew pyràm. Àràw a'e, ta'yr a'e wà no, umunehew putar a'e ma'e a'e wà nehe. (Àràw a'e, ta'yr a'e wà no, umunehew a'e ma'e Tupàn henataromo a'e wà.) ");
INSERT INTO gubBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Na'e Izaew izuapyapyr paw uhem oho a'e wi Moizez wi a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Amo iporomono wer tuwe ma'e rehe wemetarer ikurer rehe Tupàn Tuweharupi Wiko Ma'e pe a'e wà. A'e rupi omono izupe wà. Moizez umekuzar Tupàn huwàxi haw iapo haw a'e temetarer pupe, Tupàn hàpuzràn iapo haw imekuzar pà. Omono temetarer iapo har wanupe, umekuzar kamirpuku ipupe no, Tupàn henataromo ma'ea'yr zuka har wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Awa wà, kuzà wà no, aze ipurumur wer kuzà imupuràg etea'i haw rehe izupe wà, werur wà: iputàw imunehew paw, inamipor, kwàku'aw har, poapyw har, wyzài ma'e or iapo pyrer. Umur uma'e Tupàn pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Aze amo wereko pàn irin her ma'e wà, werur wà: inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, huwy ipiràg wewer ma'e, ipiràg ma'e, pàn hekuzar katu ma'e àràpuhàrànete hawer iapo pyrer, àràpuhàràn hawitu ma'e awa ipirer imupiràg pyrer, ma'epirer hekuzar katu ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Parat herur arer wà, itazu morog herur arer wà no, werur a'e ma'e Tupàn Tuweharupi Wiko Ma'e pe imur pà wà. Ywyra akaz her ma'e hereko har wà no, wyzài ma'e iapo pyràm romo wà, werur wà no, Tupàn pe imur pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kuzà inemo ipuwànaw kwaw par wà, upuwàpuwàn inemo wà, herur pà imur pà Tupàn pe wà: inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, ipuwy ma'e no, ipiràg ma'e no. Uzapo pàn irin her ma'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kuzà àràpuhàrànete hawer ipuwànaw kwaw par paw wà no, aze ipurupuwàn wer hehe wà, upuwàpuwàn wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Izaew waneruze'egar a'e wà, werur ita onik her ma'e a'e wà, amo ita hekuzar katu ma'e ipuràg eteahy ma'e inuromo wà. Moizez omomog kar a'e itapuràgete Tupàn henataromo ma'ea'yr zuka har wakamirpuku rehe, wapuxi'a rehe har rehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Werur amo ma'e taz zàwenugar wà. Werur uri kawer tatainy pupe àràm wà no. Uzuhen teko wanehe ma'ea'yr wanehe Tupàn henataromo wà, imuwete katu mehe wà. Ikaz mehe hyàkwegatu yhyk zàwenugar ài Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Awa Izaew izuapyapyr ma'e rehe ipurumur wer ma'e wà, kuzà ma'e rehe ipurumur wer ma'e wà no, paw rupi werur ma'e Tupàn Tuweharupi Wiko Ma'e pe wà. Moizez umekuzar Tupàn pe uma'ereko haw paw a'e temetarer pupe a'e, ta'e Tupàn Tuweharupi Wiko Ma'e uzapo kar nezewe haw izupe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Na'e uze'eg Moizez Izaew wanupe kury. — Peme'egatu Tupàn Tuweharupi Wiko Ma'e hemiapo kwer rehe nehe. Wexak amo awa kury. Mezarew Uri ta'yr her romo a'e. Wiko Ur hemimino romo a'e. Zuta izuapyapyr romo wanekon wà. ");
INSERT INTO gubBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Tupàn umynehem Wekwe Puràg pupe. Ukwaw kar ma'e tetea'u iapo haw izupe. Ukwaw iapo haw. Ukwaw iapo katu haw. ");
INSERT INTO gubBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","A'e rupi ukwaw ma'eragapaw iapo haw. Ukwaw or imuapu'a haw. Ukwaw parat imuapu'a haw no. Ukwaw itazu imuapu'a haw no, ma'e ipuràg eteahy ma'e iapo pà. ");
INSERT INTO gubBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ukwaw itapuràg hekuzar katu ma'e imonohokaw ima'ema'e haw amo ma'e rehe imomogaw. Ukwaw ywyra ikixikixi katu haw ma'e iapo pà no. Ukwaw ipuràg eteahy ma'e tetea'u iapo haw no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Omono a'e ma'e iapo haw kwaw paw amo awa wanupe no. Aoriaw awa inugwer her romo. Aizamak ta'yr romo hekon a'e, Nà izuapyapyr romo a'e. A'e rupi ukwaw amogwer wamu'e haw agwer ma'e iapo haw rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Umynehem tuwe Tupàn a'e awa ma'e iapo haw kwaw paw pupe wà. Ukwaw iapo haw wà. Ukwaw ma'e iapo pyràm rehe uma'enukwaw katu haw wà no. Ukwaw pàn ipuwàpuwànaw wà no: huwy ma'e, huwy ipiràg wewer ma'e, ipiràg ma'e, pàn irin ikatuahy ma'e. Ukwaw wyzài pàn iapo haw wà. Ukwaw wyzài ma'e iapo haw rehe teko wamu'e haw wà no. Ukwaw ma'eragapaw iapo haw rehe teko wamu'e haw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Tupàn Tuweharupi Wiko Ma'e ukwaw kar ma'e iapo haw awa wanupe. Omono ma'e kwaw paw wanupe no. A'e rupi Mezarew a'e, Aoriaw a'e no, ma'e iapo haw kwaw par paw a'e wà no, Tupàn hàpuz iapo haw kwaw par paw a'e wà no, tuwe uzapo uma'ereko haw Tupàn ze'eg rupi katete a'e wà nehe, i'i Moizez teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Na'e Moizez wenoz Mezarew uzeupe kury, wenoz Aoriaw no, wenoz amogwer teko ma'e kwaw paw Tupàn wi ipyhyk arer wà no, a'e ma'ereko haw iapo haw rehe ur ma'e kwer wà no. Ipurupytywà wer hehe wà. — Pezypyrog pema'ereko pà kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Upyhyk Moizez a'e ma'e teko wanemimur kwer paw kury. A'e mehe omono a'e ma'e paw a'e iapo haw kwaw katu har wanupe. Uzapo kar tàpuzràn Tupàn imuwete katu haw a'e teko wanupe. Tuweharupi ku'em mehe teko werur e amo ae ma'e a'e pe wà. Werur ma'e tetea'u wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","A'e rupi uma'ereko katu ma'e Tupàn hàpuz iapo har a'e wà kury, upytu'u uma'ereko re wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Uze'eg wà Moizez pe wà. — Teko werur ma'e tetea'u wà. Uhyk ma'ereko haw Tupàn hemiapo karer pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","A'e rupi Moizez umume'u uze'eg wanupe kury. Umume'u teko ize'eg oho amogwer wanànàn wà. — Awa wà nehe, kuzà wà nehe no, pepytu'u ma'e Tupàn hàpuz me imur pyràm iapo re nehe kury, i'i wanupe. A'e rupi teko nuerur kwaw amo ma'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ta'e wanemiapo kwer uhyk a'e xe, ta'e upyta ikurer a'e xe. Ta'e heta tetea'u wera'u ma'e kury xe. ");
INSERT INTO gubBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","A'e rupi awa ma'e iapo haw ikwaw wera'u har uzapo Tupàn Tuweharupi Wiko Ma'e hàpuzràn a'e wà kury. Upyhyk pàn hekuzar katu ma'e irin her ma'e wà. Upyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e wà no. Upyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e wà no. Upyhyk inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e wà no. Uma'ema'e a'e ma'e paw 10 pànuhu iapo pà wà. A'e re omono'og a'e 10 pànuhu tàpuzràn iapo pà wà. Umuwywyk kerumin hagapaw iapo pà wà, a'e 10 pànuhu rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","A'e 10 pànuhu wà, zuawygatu wahua'u haw wà. Heta 12,5 met wapuku haw. Heta 1,80 met wapuku haw iaikwer ma'e no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Umuwywyk 5 pàn pitài pànuhu iapo pà wà. Umuwywyk inugwer 5 pàn pitài pànuhu iapo pà wà no, pàn ipy zàwegatete wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Upyhyk pàn huwy ma'e wà, ma'e àpixipixi haw iapo pà imuwywyk pà wà. Omomog a'e ma'e àpixipixi haw pàn iahykaw rehe har heme'y rehe ipehegwer katu pe har rehe wà. Uzapo nezewe haw inugwer ipehegwer rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Omomog 50 ma'e àpixi haw pàn ipy tàpuzràn pehegwer ipy heme'y rehe wà. Omomog 50 ma'e àpixi haw pàn iahykaw rehe har tàpuzràn pehegwer mokoz haw heme'y rehe wà. Nezewe ma'e àpixi haw amo pehegwer rehe har upyta ma'e àpixi haw inugwer pehegwer rehe har wanuwake wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Uzàpixipixi pànuhu inugwer pànuhu rehe 50 pyhykaw or iapo pyrer pupe wà. Nezewe mehe a'e mokoz pànuhu uzeapo pitài pànuhu romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Upyhyk 11 pàn àràpuhàrànete hawer iapo pyrer wà, tàpuzràn ipykaw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","A'e pàn uhua'u haw nuzuawy kwaw amogwer pàn uhua'u haw pitàitàigatu wà. Heta 13,30 met wapuku haw pitàitàigatu wà. Heta 1,80 met wapuku haw iaikwer pe pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Umuwywyk 5 pàn pitài pehegwer iapo pà wà. Umuwywyk inugwer 6 pàn inugwer pehegwer iapo pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Omomog 50 ma'e àpixi haw pàn ipy ipehegwer iahykaw rehe har heme'y rehe wà. Omomog 50 ma'e àpixi haw inugwer ipehegwer heme'y rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","A'e re umuapu'a itazu morog 50 àpixi haw iapo pà wà. Omomog a'e 50 ma'e àpixi haw a'e mokoz pehegwer rehe wà, pitài tàpuzràn ipykaw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Uzapo amo ipykaw wà no. Umupiràg àràpuhàràn hawitu ma'e wapirer tetea'u wà, wamuwywyk pà a'e tàpuzràn ipykaw iapo pà wà. Uzapo amo ae ipykaw wà no. Umuwywyk ma'epirer ikatuahy ma'e a'e tàpuzràn ipykaw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ukixikixi ywyra akaz her ma'e tàpuzràn izyta iapo pà wà. Nezewe mehe upuner ipàrirogaw iapo haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Heta 4,45 met izyta ipuku haw pitàitàigatu. Heta 67 xenxim izyta iànàmaw pitàitàigatu. ");
INSERT INTO gubBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Heta mokoz ikwar a'e izyta rehe pitàitàigatu wà no. Heta ikwar izyta heixe haw romo nànàn wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Uzapo 20 izyta kwarahy hemaw awyze har kutyr har pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Omono 40 kawaw pew parat iapo pyrer a'e 20 izyta iwy pe har wawy pe wà. Omono mokoz py izyta iwy pe pitàitàigatu wà. Nezewe mehe izyta i'yw nuixe kwaw ywy pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Uzapo amo 20 izyta tàpuzràn pehegwer kwarahy hemaw iahur rehe har kutyr har rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Uzapo 40 kawaw pew parat iapo pyrer izyta iwy pe har wapy romo wà. Izyta upyta mokoz upy rehe pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Tàpuzràn hekwar rehe kwarahy heixe haw kutyr uzapo 6 izyta wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Uzapo amo mokoz izyta iahykaw rehe upu'àm ma'e ràm wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Omomog a'e mokoz izyta wapy rehe wà, pitài ma'e iapo pà wà. Uhem iapu'a ma'e i'aromo har ipy pe. Nezewe umupu'àm a'e mokoz izyta iahykaw rehe har wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nezewe heta 8 izyta izupe wà. Heta 16 wapy parat iapo pyrer wà. Izyta u'àm mokoz upy parat iapo pyrer wanehe pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","A'e re ukixikixi ywyra akaz her ma'e 15 iapyteraromo har iapo pà wà. Omono 5 iapyteraromo har pitài tàpuzràn pehegwer rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Omono amo 5 inugwer ipehegwer rehe wà. Omono amo 5 ipehegwer kwarahy heixe haw kutyr har rehe wà, hekwar rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Iapyteraromo har wamyter pe har ukwaw iku'aw iaiha haw pitài pehegwer wi inugwer pehegwer pe. ");
INSERT INTO gubBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Uwàuwàn a'e izyta or pupe wà, or pàn zàwenugar iapo pyrer pupe wà. Omono iapu'a ma'e or iapo pyrer a'e izyta wanehe wà, kyhàhàm iho haw rupi wà. Uwàuwàn a'e kyhàhàm or pàn zàwenugar pupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Omono'og ikatuahy ma'e wà: pàn irin her ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e. Umuwywyk a'e pàn kerumin hagapaw wamono pà hehe wà. Uzapo pànuhu uzeaiko ma'e a'e ma'e paw imunyryk pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ukixikixi ywyra akaz her ma'e wà, 4 izyta iapo pà a'e pànuhu pe wà. Uwàuwàn a'e ywyra or pape zàwenugar romo iapo pyrer pupe wà. Umuapu'a or pànuhu àpixipixi haw iapo pà wà. Umuapu'a or a'e 4 izyta wapy iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Omono'og ma'e wà: irin ikatu ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e. Umuwywyk ma'e hagapaw a'e pàn rehe wà. A'e ma'e paw pupe uzapo pànuhu tàpuzràn huken rehe har wà. ");
INSERT INTO gubBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Uzapo 5 i'yw a'e pànuhu izyta romo imupu'àmaw romo wà. Omono ma'e àpixipixi haw i'yw wanehe wà. Uwàuwàn i'yw i'aromo har or pape zàwenugar pupe wà. Uwàuwàn izyta nezewe wà no. Umuapu'a itazu morog 5 i'yw waipy iapo pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","A'e awa Mezarew her ma'e a'e, uzapo a'e Tupàn Ze'eg Hyru a'e. Heta 1,10 met Tupàn Ze'eg Hyru ipuku haw. Heta 66 xenxim iànàmaw. Heta 66 xenxim iaiha haw. ");
INSERT INTO gubBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Omomog or pape zàwenugar romo iapo pyrer a'e Tupàn Ze'eg Hyru pupe, ikupe pe no. Omono iapeao haw or iapo pyrer izywyr no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Umuapu'a or 4 iapu'a ma'e iapo pà. Omono a'e 4 iapu'a ma'e Tupàn Ze'eg Hyru ipy wawype. Mokoz iapu'a ma'e upyta pitài pehegwer iwy pe wà. Mokoz iapu'a ma'e upyta inugwer pehegwer iwy pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ukixikixi ywyra akaz her ma'e mokoz i'yw iapo pà. Uwàuwàn i'yw or pape zàwenugar romo iapo pyrer pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A'e re umuixe kar i'yw a'e iapu'a ma'e Tupàn Ze'eg Hyru pehegwer rehe har wanupi wà. Nezewe mehe amo upuner heraha haw rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Umuapu'a Mezarew or Tupàn Ze'eg Hyru ipykaw iapo pà. Heta 1,10 met a'e ipykaw ipuku haw. Heta 66 xenxim ipuku haw iaikwer ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Unupànupà or mokoz kerumin hagapaw iapo pà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Omomog pitài hagapaw pitài Tupàn Ze'eg Hyru iahykaw pe. Omomog inugwer inugwer iahykaw pe. Omomogatu a'e kerumin hagapaw a'e ze'eg hyru ipykaw rehe wà. Nuzawy kwaw pitài ma'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","A'e kerumin hagapaw a'e wà, uzuwazar romo a'e wà. Ume'e 'àm ipykaw rehe wà. Ipepozaz wà. Wapepo upyk ipykaw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ukixikixi Mezarew ywyra akaz her ma'e ywyrapew iapo pà. Heta 88 xenxim a'e ywyrapew ipuku haw. Heta 44 xenxim ipuku haw iaikwer ma'e. Heta 66 xenxim iaiha haw. ");
INSERT INTO gubBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Uwàuwàn a'e ywyrapew or ikatuahy ma'e pape zàwenugar romo iapo pyrer pupe. Omomog iapeao haw izywyr no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Uzapo heme'ywyr har ywyrapew izywyr no. Heta 8 xenxim iànàmaw. Omomog iapeao haw or iapo pyrer a'e heme'ywyr har izywyr no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Umuapu'a or 4 iapu'a ma'e iapo pà. Omono a'e 4 iapu'a ma'e 4 iahykaw pe wà, 4 ipy wanuwake wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Omomog a'e 4 iapu'a ma'e heme'ywyr har huwake wà. Umuixe kar teko i'yw wanupi wà, aze ipurueraha wer a'e ywyrapew rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ukixikixi ywyra akaz her ma'e a'e mokoz i'yw iapo pà. Uwàuwàn i'yw or pape zàwenugar romo iapo pyrer pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Umuapu'a or ma'e ywyrapew rehe àràm iapo pà wà no: kawaw, kanek, kanekpuku, y'a win Tupàn pe imono pyr hyru ràm. ");
INSERT INTO gubBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Unupànupà Mezarew or ikatuahy ma'e tatainy henaw iapo pà. Uzapo ipy no. Uzapo i'yw no. Uzapo ma'eputyr hagapaw tatainy henaw rehe har no, iputyr hagapaw no, iputyr rupi'a hagapaw no. Omogatu henaw rehe pitài ma'e romo iapo pà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Heta 6 izywa a'e tatainy henaw rehe wà. Na'iruz upyta amo ipehegwer rehe wà. Na'iruz upyta inugwer ipehegwer rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Heta na'iruz ma'eputyr hagapaw a'e izywa wanehe pitàitàigatu wà. Nuzawy kwaw ma'e'a amen her ma'e iputyr, iputyr rupi'a no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Heta 4 ma'eputyr hagapaw tatainy henaw i'yw rehe wà. Nuzuawy kwaw ma'e'a amen her ma'e iputyr. Heta iputyr rupi'a. Heta iputyr hameamekwer no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Heta mokoz izywa na'iruz haw. Aze heta mokoz izywa, heta pitài ma'e'a amen her ma'e iputyr hupi'a a'e izywa iwy pe no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Iputyr hupi'a a'e wà, izywa a'e wà no, tatainy henaw a'e no, uzemono'og pitài ma'e or iapo pyrer romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Uzapo Mezarew 7 tatainy wanenaw pe wà. Umuapu'a or ikatuahy ma'e zepinaw inemo tatainy pupe har imonohokaw iapo pà. Uzapo tàtàpyzgwer imono'ogaw or ikatuahy ma'e pupe no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Umumaw or tetea'u a'e tatainy henaw iapo mehe, hehe we har iapo mehe. Heta 34 kir a'e or ipuhuz taw. ");
INSERT INTO gubBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ukixikixi Mezarew ywyra akaz her ma'e ywyrapew yhyk hapy haw iapo pà. Ipuku haw nuzawy kwaw ipupy uhu haw a'e. Heta 45 xenxim ipuku haw. Heta 45 xenxim ipupy no. Heta 90 xenxim iaiha haw. Iapyr iahykaw rehe har uzemogatu ywyrapew rehe wà, pitài ma'e iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Uwàuwàn ipykaw or ikatuahy ma'e pape zàwenugar pupe. Uwàuwàn 4 ipehegwer wà no. Uwàuwàn 4 iapyr wà no. Uzapo iapeao haw or iapo pyrer yhyk hapy haw izywyr no. ");
INSERT INTO gubBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Uzapo mokoz iapu'a ma'e or pupe wà no. Omomog a'e iapu'a ma'e iapeao haw iwy pe wà. Pitài upyta pitài pehegwer rehe. Inugwer upyta inugwer pehegwer rehe. Teko umuixe kar i'yw a'e iapu'a ma'e wanupi wà, aze ipurueraha wer hehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ukixikixi ywyra akaz her ma'e i'yw iapo pà. Uwàuwàn i'yw or pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A'e re uzapo Mezarew a'e uri kawer Tupàn pe imonokatu pyr xaxeto wanehe izuhen pyràm. Uzapo yhyk kàpuhàg hyàkwegatu ma'e inuromo har Tupàn henataromo hapy pyràm no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ukixikixi Mezarew ywyra akaz her ma'e ma'e Tupàn henataromo imono pyr hapy tuwe haw iapo pà. Ipykaw ipuku haw nuzawy kwaw ipupy a'e. Heta 2,20 met ipuku haw. Heta 2,20 met ipupy no. Heta 1,30 met iaiha haw. ");
INSERT INTO gubBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Uzapo Mezarew 4 iapyr 4 iahykaw rehe har pàràm wà. Omono'og iapyr ywyrapew rehe pitài ma'e iapo pà wà. Uwàuwàn a'e itazu morog pape zàwenugar romo iapo pyrer pupe paw rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Uzapo ma'e a'e ywyrapew rehe har paw wà no: kawaw, ywy imomor haw, zapepopew, kuzeràxi, tàtàpuzgwer ima'ema'e haw. Umuapu'a itazu morog a'e ma'e paw iapo pà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Upei'ài'àg itazupew imuparipari pà kyhaw zàwenugar iapo pà. Omono a'e ma'e ywyrapew heme'ywyr har iwy pe. Uhem heme'yw iaiha haw pe. ");
INSERT INTO gubBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Uzapo 4 iapu'a ma'e to'o kwer imihir haw iapyr rehe àràm romo wà. Omomog hehe wà. Teko upuner i'yw wamuixe kar haw rehe wanupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ukixikixi ywyra akaz her ma'e i'yw iapo pà. Uwàuwàn i'yw itazu morog pape zàwenugar iapo pyrer pupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A'e re umuixe kar Mezarew i'yw a'e 4 iapu'a ma'e wanupi wà, mokoz ywyrapew pehegwer wanehe har wanupi wà. Ukixikixi ywyra a'e ma'ea'yr hapy haw iapo pà. Izywyz a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A'e 'ar rehe kuzà Tupàn hàpuzràn ukenaw pe uma'ereko ma'e a'e wà, wereko itazupew waruwa romo iapo pyr a'e wà. Upyhyk Mezarew waruwa wanuwi a'e, zapepopew zepuez taw iapo pà ipupe a'e. Uzapo henaw no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Mezarew uzapo amo tàpuzràn izywyr katu haw. Uzapo irin ikatu ma'e pàn imuzaiko pyr romo a'e tàpuzràn izywyr katu haw izywyr har romo. Pànuhu kwarahy ihemaw awyze har heta 44 met ipuku haw. Heta 20 izyta itazu morog iapo pyrer. ");
INSERT INTO gubBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Heta izypy ikokaw itazu morog iapo pyrer no. Umuzaiko a'e pànuhu a'e 20 izyta rehe. Heta ma'e parat iapo pyrer izyta rehe: hàty'àz, ikokaw. ");
INSERT INTO gubBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Uzapo Mezarew nezewegatete haw kwarahy heixe haw awyze har kutyr har rehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","13","Heta 22 met tàpuz izywyr ikatu haw ipuku haw. Heta 22 met tàpuz izywyr ikatu haw pehegwer kwarahy heixe haw kutyr har. Heta 22 met tàpuz izywyr ikatu haw pehegwer kwarahy ihemaw kutyr har. Heta 10 pànuhu i'yw wà. Heta 10 i'yw izypy ikokaw no. Umuapu'a parat hàty'àz iapo pà imuzaiko haw romo iapo pà. Uzapo ikokaw parat iapo pyrer no. Teko wixe tàpuz izywyr ikatu haw pupe ipehegwer kwarahy ihemaw kutyr har rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Heta pànuhu mokoz tàpuz izywyr ikatu haw hukenaw iwyr rehe. Heta 6,60 met pànuhu ipuku haw. Heta na'iruz pànuhu izyta. Heta na'iruz izypykokaw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Umuwywyk pàn irin ikatuahy ma'e a'e pànuhu tàpuz izywyr ikatu haw iwyr har paw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Umuapu'a itazu morog a'e izyta izypy iapo pà. Umuapu'a parat amogwer ma'e iapo pà: hàty'àz, ikokaw, izyta apyr har. Izyta tàpuzràn izywyr katu haw izywyr har paw uzemomog uwipy ikokaw parat iapo pyrer rehe pitài ma'e romo uzeapo pà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Omono'og ma'e: pàn irin ikatuahy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e. Umuwywyk ma'e hagapaw a'e pàn rehe. Omono'og a'e ma'e paw pànuhu tàpuzràn izywyr katu haw ukenaw iwyr har iapo pà. Heta 8,80 met a'e pànuhu ipuku haw. Heta 2,20 met iaiha haw. Ipuku haw iaiha haw nuzawy kwaw pànuhu tàpuzràn izywyr ikatu haw pe har ipuku haw iaiha haw. ");
INSERT INTO gubBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Heta 4 ywyra izyta romo. Heta 4 ipy itazu morog iapo pyrer izyta pe. Umuapu'a parat tetea'u a'e ma'e paw iapo pà: hàty'àz wà, izyta iapyr hete wazypykokaw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Umuapu'a itazu morog tetea'u tàpuzràn izyta paw iapo pà wà, izyta katu pe har iapo pà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Xe amume'u putar ita tàtà hekuzar katu ma'e wapuhuz taw Tupàn hàpuzràn rehe har ihe nehe kury. Moizez omonokatu a'e 10 Tupàn ze'eg mokoz itapew rehe ikaikair pyrer a'e hàpuzràn pupe. Moizez omono'og Erewi izuapyapyr xaxeto Àràw ta'yr wà kury, wanupe uze'eg pà wà kury. Itamar xaxeto Àràw ta'yr a'e, wanuwihaw her romo a'e. — Pemuapyk ita tàtà hekuzar katu ma'e wapuhuz taw pape rehe nehe, i'i Moizez wanupe. ");
INSERT INTO gubBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Mezarew Uri ta'yr Ur hemimino Zuta izuapyr a'e, uzapo ma'e paw Tupàn hemiapo karer Moizez pe imume'u pyrer a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Aoriaw Aizamak ta'yr Nà zuapyr a'e, ipytywà har romo hekon a'e. Aoriaw ukwaw ma'e hagapaw pape rehe imuapykaw. Ukwaw ma'eragaw paw itatàtà rehe ikair haw no. Ukwaw pàn ikatuahy ma'e irin ipyahaw paw no. Ukwaw inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipyahaw paw no: huwy ma'e, ipuwy ma'e, ipiràg ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Teko omono or tetea'u Tupàn Tuweharupi Wiko Ma'e pe hàpuzuhu iapo pyràm wà. Omono ma'e puhuz taw hexakaw rehe tuwihawete wanehe we har rehe wà. Wexak ipuhuz taw wà. Heta miw kir a'e or puhuz taw. ");
INSERT INTO gubBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Wexak kar parat ipuhuz taw tuwihaw wanupe wà. Heta 3.430 kir a'e parat puhuz taw a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","A'e 'ym mehe awa kwer omono amo parat Tupàn pe weko haw hekuzaromo wà. Tuwihaw umume'u awa hemimono ràm awa wanupe pitàitàigatu wà. Pitàitàigatu omono wemetarer tuwihaw wanupe Tupàn pe imono pyr romo wà. Parat Tupàn hàpuzràn rehe har ipuhuz taw nuzawy kwaw parat awa kwer wanemimono kwer paw a'e. Tuwihawete upapar awa kwer a'e 'ar mehe wà. Heta 63.550 awa 20 kwarahy hereko wera'u har wà. ");
INSERT INTO gubBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Umumaw parat 3.400 kir ipuhuz taw a'e 100 tàpuzràn ipy pànuhu ipy iapo mehe wà. Heta 34 kir ipy wanupe pitàitàigatu. ");
INSERT INTO gubBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Uhyk katu parat. Heta we parat. Heta 30 kir ikurer ipuhuz taw a'e. Upyhyk Mezarew a'e parat kyhàhàm zàwenugar iapo pà, hàty'àz i'yw rehe har iapo pà no, i'yw izypy ikokaw iapo pà no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Teko omono itazu morog tetea'u Tupàn pe wà no. Heta 2.425 kir ipuhuz taw a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Upyhyk Mezarew Tupàn tàpuzràn ukenaw ipy iapo pà. Uzapo ma'ea'yr hapy haw a'e. Uzapo kuzeràxihu a'e no. Umuapu'a itazu morog a'e ma'ea'yr hapy haw rehe har paw iapo pà no. ");
INSERT INTO gubBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Uzapo tàpuz izywyr ikatu haw ipy ukenaw ipy morog imuapu'a pà wà no. Tàpuzràn i'yw paw pànuhu tàpuzràn izywyr har i'yw paw uzapo morog imuapu'a pà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Upyahaw inemo àràpuhàràn hawitu ma'e hawer iapo pyrer kamirpuku iapo pà: huwy ma'e, ipuwy ma'e, ipiràg ma'e. A'e kamir uzemonokatu Tupàn pe wà. Xaxeto umunehew a'e kamirpuku Tupàn Henaw Ikatuahy Ma'e pupe oho mehe uma'ereko mehe wà. Iapo har uzapo kamirpuku xaxeto pe Àràw pe iapo pyrer Tupàn Tuweharupi Wiko Ma'e ze'eg awer rupi katete a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Upyahaw inemo àràpuhàràn hawitu ma'e hawer iapo pyrer xaxeto ikamirpuku amo ma'e i'aromo har iapo pà: huwy ma'e, ipuwy ma'e, ipiràg ma'e, pàn irin her ma'e ikatuahy ma'e, inemo or iapo pyrer. ");
INSERT INTO gubBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Umuapu'a or kawawpew iapo pà. Ukixikixi inemo zàwenugar iapo pà. Upyahaw a'e or irin ikatu ma'e inuromo, amogwer inemo àràpuhàràn hawitu ma'e hawer iapo pyrer inuromo: huwy ma'e, ipuwy ma'e, ipiràg ma'e. ");
INSERT INTO gubBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Uzapo mokoz iputàwmunehew paw kamirpuku rehe imomog pyràm. Omomog pitài pitài pehegwer rehe. Omomog inugwer inugwer pehegwer rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Iku'aw har a'e, kamirpuku iku'aw rehe upyta a'e. Pitài ma'e romo uzeapo hehe we a'e. Zuawygatu pàn iapo pyrer. Ta'e Tupàn Tuweharupi Wiko Ma'e uzapo kar nezewe haw Moizez pe a'e 'ym mehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Umuàgà'ym ita puràg eteahy ma'e agata her ma'e wà kury. Omomog a'e agata ma'e or iapo pyrer wanehe wà. Umuapyk katu Zako ta'yr waner a'e ita wanehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Omomog a'e ita xaxeto kamirpuku iputàwmunehew paw wanehe wà. Upurumuma'enukwaw kar 12 Izaew ta'yr wazuapyapyr wanehe wà. Uzapo a'e ma'e paw Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imume'u pyrer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Uzapo xaxeto ipuxi'a iwànaw nezewegatete no. Omono'og agwer ma'e wà: inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipuwy ma'e, inemo àràpuhàràn hawitu ma'e hawer iapo pyrer ipiràg ma'e, irin ikatu ma'e. Umuwywyk a'e irin puràg eteahy ma'e, ma'e hagapaw imuapyk pà hehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ipuxi'a iwànaw ipuku haw nuzawy kwaw ipuku haw iaikwer ma'e a'e. Ukanakanaw mokoz pehegwer romo wà. Heta 20 xenxim ipuku haw. Heta 20 xenxim ipupy no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Omomog 4 ita hekuzar katu ma'e imuzehyrogatu pyrer hehe wà. Imuzehyrogatu haw ipy rehe omomog na'iruz ita wà: humi, topaz, karanar. ");
INSERT INTO gubBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Imuzehyrogatu haw mokoz haw rehe omomog amo na'iruz ita wà: emeraw, xapir, niàmà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Imuzehyrogatu haw na'iruz haw rehe omomog amo na'iruz ita wà: turukez, agata, amexi. ");
INSERT INTO gubBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Imuzehyrogatu haw 4 haw rehe omomog amo na'iruz ita wà: meriw, onik, zaz. Omomog a'e ita a'e kawawpew zàwenugar wanehe paw rupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Umuapyk Zako ta'yr waner a'e ita wanehe wà. Heta pitài ta'yr her ita nànàn. Upurumuma'enukwaw kar Izaew ta'yr wazuapyapyr wanehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Upyhyk or ikatuahy ma'e inemo romo iapo pyrer wà. Upupepupe a'e inemo kyhàhàm zàwenugar iapo pà wà, xaxeto ipuxi'a iwànaw rehe har romo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Umupyràn or mokoz iapu'a ma'e romo iapo pà wà. Uzàpixipixi a'e iapu'a ma'e xaxeto ipuxi'a rehe har rehe ywate wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Umuixe kar a'e mokoz kyhàhàm zàwenugar or iapo pyrer a'e mokoz iapu'a ma'e wanupi wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Uzàpixipixi kyhàhàm apyr kawaw zàwenugar or iapo pyrer ipuxi'a rehe har rehe wà. Omomog a'e kawaw zàwenugar kamirpuku iputàwmunehew paw wanehe wà, xaxeto henataromo har rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Uzapo amo mokoz iapu'a ma'e or iapo pyrer wà no. Uzàpixipixi a'e iapu'a ma'e xaxeto ipuxi'a rehe har rehe ywy kutyr wà, ipupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Umuapu'a or mokoz iapu'a ma'e iapo pà wà. Omomog a'e iapu'a ma'e mokoz kamirpuku iputàwmunehew paw iapyr wanehe wà, iwy pe wà, xaxeto henataromo har rehe wà, imuwywyk awer huwake wà, iku'aw har i'aromo wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Weruze'eg Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imur pyrer wà. Uzàpixipixi a'e mokoz iapu'a ma'e ipuxi'a rehe har amo mokoz iapu'a ma'e ikamirpuku rehe har wanehe inemo huwy ma'e pupe wà. Nezewe mehe ipuxi'a iwànaw nuwezyw kwaw iku'aw har pe. Nuzekwaraw kwaw. ");
INSERT INTO gubBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Upyahaw xo inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e zo xaxeto iaxi'i ipyk àwàm iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ikwar ipyter pe. Xaxeto umuixe kar uwàkàg ikwar rupi imunehew mehe. Uzapeao izurukwaromo har pàn ipuhuz ma'e pupe wà. Nezewe mehe numu'i kar kwaw xaxeto imunehew mehe. ");
INSERT INTO gubBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Omono'og inemo àràpuhàràn hawitu ma'e hawer iapo pyrer wà: huwy ma'e, ipuwy ma'e, ipiràg ma'e. Uzapo ma'e'a homà her ma'e hagapaw a'e inemo pupe wà. Umuwywyk a'e hagapaw xaxeto iaxi'i ipykaw iahykaw nànàn wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Uzapo itamaraka pixika'i ma'e wà no. Uzàpixi a'e itamaraka pixika'i ma'e iaxi'i ipykaw heme'y rehe wà. Uzàpixi pitài itamaraka wà. Uzàpixi pitài ma'e'a hagapaw huwake wà. A'e re uzàpixi amo itamaraka wà. A'e re uzàpixi amo ma'e'a hagapaw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Umupuràg eteahy kar a'e iaxi'i ipykaw heme'ywyr wà. Nezewe haw uzapo wà. Uzàpixi pitài itamaraka'i wà. Umuwywyk pitài ma'e'a hagapaw wà. Uzàpixi pitài itamaraka wà. Umuwywyk pitài ma'e'a hagapaw wà. Uzapo nezewe paw rupi wà, ta'e Tupàn Tuweharupi Wiko Ma'e uzapo kar nezewe haw Moizez pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Uzapo kamirpuku tunik her ma'e Àràw pe ta'yr wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Amo ma'e uzapo wanupe wà no: àkàg àpixi haw, xapew, temyhar irin iapo pyrer ");
INSERT INTO gubBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Upyahaw inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e inemo ipuwy ma'e rehe we inemo ipiràg rehe we irin ikatu ma'e rehe we wà, waku'aw har iapo pà wà. Umuwywyk a'e pàn ma'e ipuràg eteahy ma'e hagapaw imuapyk pà hehe wà. Weruzar Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imur pyrer iapo mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Umuapu'a or ikatuahy ma'e kawawpew iapo pà wà. Uzàpixi kawawpew xaxeto àkàg rehe har rehe wà. Umuapyk ko ze'eg hehe wà. — Tupàn Tuweharupi Wiko Ma'e pe imonokatu pyr, i'i. ");
INSERT INTO gubBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Uzàpixi kawawpew inemo àràpuhàràn hawitu ma'e hawer iapo pyrer huwy ma'e pupe wà. Uzàpixi kawawpew àkàg àpixi haw ipehegwer 'ywate har rehe wà. Ta'e nezewe uzapo kar Tupàn Tuweharupi Wiko Ma'e Moizez pe a'e 'ym mehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Umumaw a'e uma'ereko haw Tupàn hàpuzràn rehe har a'e kury. Teko Izaew izuapyapyr uzapo ma'e paw Tupàn Tuweharupi Wiko Ma'e ze'eg awer Moizez pe imur pyrer rupi katete a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Weraha hàpuzràn Moizez pe wà. Weraha hehe we har paw izupe wà no: iàpixipixi haw, izyta, iapyteraromo har, i'yw, izypy ràm no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Weraha ipykaw àràpuhàràn hawitu ma'e wapirer iapo pyrer imupiràg pyrer wà no. Weraha ipykaw ma'epirer ikatuahy ma'e iapo pyrer wà no. Weraha pànuhu izupe wà no. A'e pànuhu uzaikaikaw tàpuzràn pupe har mokoz romo. — Tupàn Tuweharupi Wiko Ma'e Henaw Ikatuahy Ma'e, i'i amo ipupyaikaw pyrer pe wà. — Tupàn Tuweharupi Wiko Ma'e Henaw Ikatuahy Wera'u Ma'e, i'i inugwer ipupyaikaw pyrer pe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Weraha Tupàn Ze'eg Hyru Moizez pe wà, Tupàn ze'eg mokoz itapew rehe ikaikair pyrer wà no. Weraha i'yw wà no, ipykaw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Weraha ywyrapew izupe wà no. Weraha hehe har paw izupe wà no, weraha typy'ak Tupàn pe imono pyr wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Weraha tatainy henaw or ikatuahy ma'e iapo pyrer izupe wà. Weraha tatainy rehe har izupe wà no, ma'e hehe har paw wà no, uri kawer tatainy pupe har wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Weraha inugwer ywyrapew or iapo pyrer Tupàn pe imur pyrer hereko àràm izupe wà no. Weraha uri kawer kàpuhàg inuromo har xaxeto romo purumuigo kar ma'e izupe wà no. Weraha yhyk zàwenugar hyàkwegatu ma'e izupe wà no. Weraha pànuhu tàpuzràn uken rehe har izupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Weraha itazu morog ipei'ài'àg pyrer iparipari ma'e iapo pyrer izupe wà no. Weraha ihàm izupe wà no, hehe har paw wà no. Weraha zapepopewhu izupe wà, hetymà wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Weraha pànuhu tàpuz izywyr ikatu haw pe har izupe wà no, wa'yw wà no, wapy wà no. Weraha pànuhu tàpuz izywyr ikatu haw ukenaw rehe har izupe wà, ihàm wanehe we wà no. Weraha tàpuzràn i'yw wà, ma'e ipupe àràm paw wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Weraha kamirpuku ipuràg eteahy ma'e xaxeto wanemimunehew Tupàn Henaw Ikatuahy Ma'e pupe àràm wà, kamirpuku Àràw hemimunehew ràm ta'yr wanemimunehew ràm wà no. ");
INSERT INTO gubBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Teko Izaew izuapyapyr uzapo ma'e Moizez pe Tupàn Tuweharupi Wiko Ma'e hemiapo karer paw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ume'egatu Moizez a'e ma'e wanehe paw rupi katete a'e. — Azeharomoete pezapo ko ma'e paw Tupàn Tuweharupi Wiko Ma'e ze'eg awer rupi katete pe wà, i'i wanupe. A'e rupi omono Moizez uze'egatu a'e ma'e nànàn a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Uze'eg wi Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","— Zahy ipy mehe 'ar ipy mehe emuapyk heràpuzràn nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Emuapyk heze'eg hyru heràpuzràn pupe nehe, emono heze'eg itapew rehe ikaikair pyrer a'e 10 heremiapo kar hyru ipupe nehe. Emupu'àm a'e pànuhu heze'eg hyru henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Emuapyk ywyrapew heràpuzràn pupe nehe. Emono ywyrapew rehe àràm hehe nehe, hen àwàm me pitàitàigatu nehe. Emupu'àm tatainy henaw tàpuzràn pupe nehe. Emono tatainy hehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Emuapyk yhyk zàwenugar hapy haw or iapo pyrer ipupe nehe, heze'eg hyru henataromo nehe. Emuzaiko pànuhu heràpuzràn huken rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Emuapyk ma'ea'yr hapy haw heràpuzràn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Emuapyk zapepopew tàpuzràn ma'e hapy haw wamyter pe nehe. Emynehem zapepopew 'y pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","A'e re emupu'àm tàpuz izywyr katu haw heràpuzràn izywyr nehe. Emuzaiko pànuhu tàpuz izywyr katu haw hukenaw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Na'e epyhyk uri kawer xaxeto romo purumuigo kar ma'e nehe. Ezakook a'e uri kawer heràpuzràn rehe nehe, ipupe har wanehe paw rupi nehe no. Nezewe mehe emurkatu a'e ma'e paw ihewe nehe, imukatuahy pà ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","A'e re ezakook uri kawer ma'e hapy haw rehe nehe, hehe har wanànàn nehe no. Nezewe mehe ma'e hapy haw eremurkatu ihewe nehe, imukatuahy pà ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nezewegatete erezakook putar uri kawer zapepopew rehe nehe, hetymà rehe nehe no. Nezewe mehe eremurkatu putar ihewe nehe, imukatuahy pà ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Eraha Àràw heràpuzràn hukenaw pe nehe. Eraha ta'yr a'e pe ne wà nehe no. Emuzepuez kar ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Emunehew kar xaxeto kamir Àràw pe nehe. Ezakook uri kawer iàkàg rehe nehe, imurkatu pà ihewe nehe, xaxeto herenataromo har romo imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Erur ta'yr ne wà nehe no. Emunehew kar kamirpuku tunik her ma'e wanupe pitàitàigatu no. ");
INSERT INTO gubBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","A'e re ezakook uri kawer wanehe nehe, wanu rehe hakook awer zàwegatete nehe. Nezewe mehe wiko putar xaxeto romo herenataromo wà nehe. Wiko putar xaxeto romo awyzeharomo wà nehe, a'e re wà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moizez uzapo a'e ma'e paw Tupàn Tuweharupi Wiko Ma'e ze'eg rupi katete a'e. ");
INSERT INTO gubBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Zahy ipy mehe, 'ar ipy mehe, umuapyk Tupàn hàpuzràn a'e pe wà. Ezit ywy wi waho awer wi te Tupàn hàpuzràn imuapykaw 'ar pe Izaew umumaw etea'i pitài kwarahy a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Omono Moizez ipy ywy rehe wà. Umupu'àm izyta wà. Umupu'àm i'yw wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Upyk tàpuzràn ipykaw pupe. Omono inugwer ipykaw ipykaw ipy i'aromo, Tupàn Tuweharupi Wiko Ma'e ze'eg awer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A'e re upyhyk a'e mokoz itapew Tupàn ze'eg hereko har wà. Omono hyru pupe wà. Umuixe kar i'yw iapu'a ma'e rupi wà. Uwàpytym ipykaw pupe no. ");
INSERT INTO gubBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A'e re omono ze'eg hyru tàpuzràn pupe, Tupàn Tuweharupi Wiko Ma'e ze'eg awer rupi katete. Umuzaiko pànuhu Tupàn Henaw Ikatuahy Ma'e Tupàn Henaw Ikatuahy Wera'u Ma'e wamyter pe. Nezewe mehe ni amo nupuner kwaw ze'eg hyru hexakaw rehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Umuapyk Moizez ywyrapew tàpuzràn pupe kwarahy ihemaw iahurehe har kutyr har rehe, pànuhu huwake ikupe kutyr. ");
INSERT INTO gubBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Omono typy'ak Tupàn Tuweharupi Wiko Ma'e pe imono pyrer hehe, ize'eg awer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Umupu'àm tatainy henaw kwarahy ihemaw awyze har kutyr har rehe, ywyrapew henataromo. ");
INSERT INTO gubBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo umunyk Moizez tata tatainy rehe, Tupàn ze'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Umuapyk ywyrapew or iapo pyrer tàpuzràn pupe pànuhu henataromo. ");
INSERT INTO gubBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Wapy yhyk zàwenugar hyàkwegatu ma'e hehe Tupàn Tuweharupi Wiko Ma'e ze'eg awer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Umuzaiko pànuhu tàpuzràn huken rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Umuapyk ma'e hapy haw a'e pe pànuhu henataromo. Omono ma'e hapy paw pyràm hehe. Omono arozràn Tupàn Tuweharupi Wiko Ma'e pe imono pyrer hehe ize'eg rupi katete no. ");
INSERT INTO gubBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Umupu'àm zapepopew no, tàpuzràn ma'e hapy haw wamyter pe no. Umynehem 'y pupe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moizez a'e, Àràw a'e no, ta'yr a'e no, uzepuez ipupe wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Wyzài 'ar mehe, aze wixe tàpuzràn pupe wà, aze oho ma'e hapy haw huwake wà, uzepuez ipupe wà, Tupàn ze'eg rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Umupu'àm Moizez tàpuz izywyr ikatu haw tàpuzràn ma'e hapy haw waiwyr har. Umuzaiko pànuhu tàpuzràn izywyr ikatu haw hukenaw rehe har romo no. A'e ma'e iapo pawire umumaw uma'ereko haw kury. ");
INSERT INTO gubBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Na'e amo ywàkun upyk tàpuzràn kury. Uhyape katu kury. Tynehem Tupàn Tuweharupi Wiko Ma'e heko haw heny katu haw pupe kury. ");
INSERT INTO gubBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","A'e rupi Moizez nupuner kwaw ipupe wixe haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Aze a'e ywàkun uzeupir tàpuzràn wi, xo a'e mehe zo Izaew oho amo me wà, amo ae ywy rehe uker haw iapo pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Aze nuzeupir kwaw, upyta teko a'e pe amo me oho 'ym pà wà. ");
INSERT INTO gubBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Wata haw nànàn wà, 'aromo wà, wexak ywàkun Tupàn Tuweharupi Wiko Ma'e hereko haw wà, tàpuzràn i'aromo wà. Pyhaw wexak tata i'aromo ukaz ma'e wà no. ");
INSERT INTO gubBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Tupàn Tuweharupi Wiko Ma'e wenoz Moizez uzeupe kury. Na'e uze'eg izupe tàpuzràn imonokatu pyrer pupe wiko mehe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","— Emume'u ko ze'eg ma'e ihewe imur pyràm rehe har Izaew wanupe nehe. — Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. — Aze awa ipuruzuka wer ma'ea'yr rehe herenataromo nehe, upuner putar amo weimaw tapi'ak amogwer tapi'ak wainuromo har hexakaw rehe nehe. U, upuner putar amo àràpuhàràn hawitu ma'e hexakaw rehe nehe. U, upuner putar amo àràpuhàrànete hexakaw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Aze ipurumur wer amo weimaw tapi'ak rehe ihewe hapy pyràm romo ukaz paw ma'e ràm romo nehe, tuwe wexak amo tapi'ak awa ikatu 'ymaw hereko 'ymar nehe. Ihe amuawyze putar ihe nehe, aze a'e awa weraha a'e tapi'ak awa tàpuzràn iapo katu pyrer pupe teixe haw huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A'e pe opokok putar iàkàg rehe nehe. Na'e a'e ma'ea'yr ikatu putar ihewe nehe. Nezewe mehe umunàn kar putar wemiapo kwer ikatu 'ym ma'e uzewi ihewe a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Na'e awa uzuka putar a'e tapi'ak awa tàpuzràn henataromo nehe. Xaxeto Àràw izuapyapyr a'e wà nehe, umur putar huwykwer ihewe wà nehe. Na'e umupiripirik huwykwer 4 ma'ea'yr hapy haw tàpuzràn henataromo har iahykaw wanehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Na'e awa upirok putar ma'ea'yr nehe. A'e re upei'ài'àg putar hetekwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Xaxeto umunyk putar tata ma'ea'yr hapy haw i'aromo wà nehe. Umuàgà'ym putar zepe'aw tata rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Umuapyk putar tapi'ak awa tata rehe wà nehe: ho'o kwer ipei'ài'àg pyrer, iàkàgwer, ikawer hie kwer ipyk arer. ");
INSERT INTO gubBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Awa uzuhez putar hie parer nehe, hetymàgwer nehe no. Ukaz putar ma'ea'yr hapy haw rehe nehe no. Xaxeto wapy putar tapi'ak awa nehe, Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Aze awa omono àràpuhàràna'yr hawitu ma'e Tupàn pe nehe, u, aze omono àràpuhàrànetea'yr izupe nehe, tuwe xo awa zo omono izupe wà nehe. Tuwe na'iperew kwaw nehe. Tuwe naheta kwaw ikatu 'ymaw hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Awa uzuka putar ma'ea'yr Tupàn Tuweharupi Wiko Ma'e henataromo nehe, ma'ea'yr hapy haw izywyr kwarahy heixe haw awyze har kutyr nehe. Xaxeto umupiripirik putar 4 ma'ea'yr hapy haw iahykaw huwykwer pupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","A'e re izar upei'ài'àg putar ma'ea'yr nehe. Na'e xaxeto omono putar hetekwer tata ma'ea'yr hapy haw rehe har rehe nehe: ipegegwer, iàkàgwer, ikawer hie kwer ipykaw. ");
INSERT INTO gubBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ma'ea'yr izar uzuhez putar hie kwer nehe, hetymà gwer nehe no. Omono putar a'e ma'e Tupàn pe nehe no. Wapy putar ipegegwer paw rupi nehe, Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Aze awa iporomono wer wiràmiri rehe Tupàn Tuweharupi Wiko Ma'e pe nehe, tuwe werur pyku'i nehe, u, werur pykahu nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Xaxeto weraha putar wiràmiri ma'ea'yr hapy haw pe nehe. Omonohok putar iàkàg nehe. Na'e wapy putar ma'ea'yr hapy haw rehe nehe. A'e re uwyryk putar huwykwer ma'ea'yr hapy haw ipehegwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A'e re ozo'ok putar hemi'uryru nehe, ipor nehe no. Weityk putar tanimuk imuapyteràkwà ma'ea'yr hapy haw izywyr har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Na'e upyhyk putar wiràmiri ipepo rehe. Upupirar putar ipepo hetekwer ipei'àg 'ym pà nehe. Wapy putar ma'ea'yr hapy haw rehe nehe. Ukaz paw putar Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Aze awa omono arozràn Tupàn Tuweharupi Wiko Ma'e pe nehe, tuwe umuku'iku'i nehe. Na'e wenuhem putar iku'i kwer ikatu wera'u ma'e amo wanuwi nehe. Na'e upyhyk putar uri kawer nehe, yhyk zàwenugar nehe no. Umupyràn putar a'e ma'e paw arozràn imuku'i pyrer inuinuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Na'e omono putar a'e ma'e xaxeto Àràw izuapyapyr wanupe nehe. Amo xaxeto upyhyk putar opo ipor arozràn imuku'i pyrer uri kawer inuromo yhyk zàwenugar inuromo imupyràn pyrer nehe. Wapy putar ma'ea'yr hapy haw rehe nehe. Nezewe mehe teko ima'enukwaw putar ko ma'e rehe wà: a'e ma'e paw teko omono Tupàn pe wà. Temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Xaxeto Àràw izuapyapyr upyhyk putar arozràn imono pyrer ikurer wà nehe. A'e ikurer ikatu wera'u Tupàn henataromo, ta'e wenuhem Tupàn Tuweharupi Wiko Ma'e pe imono pyrer wi a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Aze amo iporomono wer typy'ak zepehe pupe imihir pyrer rehe Tupàn pe nehe, tuwe uma'ema'e arozràn imuku'i pyrer ikatuahy ma'e iapo pà nehe. Nomono kwaw imuapiruru kar haw inuromo nehe. Upuner typy'ak uhu ma'e iapo haw rehe arozràn imuku'i pyrer uri kawer inuromo imupyràn pyrer pupe wà nehe. Upuner pixika'i ma'e ipew ma'e iapo haw rehe wà nehe, uri kawer pixika'i imono pà hehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Aze iporomono wer typy'ak zàpehe pupe imihir pyrer rehe nehe, tuwe umupyràn uri kawer arozràn imuku'iku'i pyrer inuromo nehe. Nomono kwaw imuapiruru kar haw inuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Tupàn pe imono mehe nehe, upei'ài'àg putar typy'ak nehe. Uzakook putar uri kawer hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Aze iporomono wer typy'ak zapepopew rehe imihir pyrer rehe nehe, tuwe umupyràn uri kawer arozràn imuku'iku'i pyrer inuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Emono a'e arozràn Tupàn Tuweharupi Wiko Ma'e pe nehe. Emono xaxeto pe nehe. A'e weraha putar ma'ea'yr hapy haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Upyhyk putar imono pyr ikurer pixika'i ma'e nehe, hapy pà ma'ea'yr hapy haw rehe nehe. Nezewe mehe teko ima'enukwaw putar ko ma'e rehe wà nehe: Omono a'e ma'e paw Tupàn pe a'e. Temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Xaxeto Àràw izuapyapyr upyhyk putar arozràn imono pyrer ikurer wà nehe. A'e ikurer ikatu wera'u Tupàn henataromo, ta'e wenuhem Tupàn Tuweharupi Wiko Ma'e pe imono pyrer wi a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Pemupyràn zo imuapiruru kar haw wyzài arozràn Tupàn pe imono pyr inuromo nehe. Pemono zo imuapiruru kar haw wyzài Tupàn Tuweharupi Wiko Ma'e pe imono pyr inuromo nehe. Pemono zo hàir inuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pemono arozràn izypy mehe ipo'o pyrer Tupàn Tuweharupi Wiko Ma'e pe nehe. Xaxeto nuwapy kwaw a'e arozràn ma'ea'yr hapy haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Pemue katu arozràn imono pyrer xa pupe nehe. Ta'e xa upurumuma'enukwaw kar Tupàn ze'egaw rehe teko wanehe we iapo katu pyrer rehe a'e xe. Pemue katu arozràn Tupàn pe imono pyr paw rupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Arozràn izypy mehe ipo'o pyrer Tupàn Tuweharupi Wiko Ma'e pe imono mehe nehe, epyhyk arozràn haryw ikyr katu ma'e rehe har izupe nehe. Emuku'i nehe. Emihir nehe. A'e re eraha izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Emono uri kawer hehe nehe. Emono yhyk zàwenugar hehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Na'e xaxeto wapy putar a'e arozràn ikurer ma'ea'yr hapy haw rehe nehe, uri kawer rehe we nehe, yhyk zàwenugar rehe we nehe no. Nezewe mehe teko ima'enukwaw putar ko ma'e rehe wà nehe: Omono a'e ma'e paw Tupàn pe a'e, i'i putar hehe uma'enukwaw pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Aze awa omono ma'e Tupàn Tuweharupi Wiko Ma'e pe uzemuawyze kar haw romo nehe, aze wenuhem tapi'ak amo tapi'ak wanuwi nehe, upuner tapi'ak awa henuhemaw rehe nehe. Aze ru'u upuner tapi'ak kuzà henuhemaw rehe nehe no. Tuwe naheta kwaw ikatu 'ymaw hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Tàpuzràn Tupàn pe imonokatu pyrer henataromo awa opokok putar a'e ma'ea'yr iàkàg rehe nehe, izuka pà nehe. Xaxeto Àràw izuapyapyr umupiripirik putar huwykwer 4 ma'ea'yr hapy haw ipehegwer rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Amo xaxeto omono putar Tupàn Tuweharupi Wiko Ma'e pe hemi'u izupe imono pyr romo a'e: ikawer hie kwer ipykaw, ");
INSERT INTO gubBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","mokoz iku'azarer, ikawer iku'azarer ipyk awer, ipy'a ipehegwer ikatu wera'u ma'e. Xaxeto wenuhem putar a'e ipy'a kwer ipehegwer iku'azarer henuhem mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Xaxeto wapy putar a'e ma'e paw ma'ea'yr hapy haw rehe wà nehe, ma'e Tupàn pe imono pyrer zepe'aw rehe imono pyrer rehe we wà nehe. Temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr hyàkwegatu ma'e romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Aze awa iporomono wer àràpuhàràn rehe Tupàn pe nehe, uzemuawyze kar haw romo nehe, heimaw awa a'e nehe, u, kuzà nehe, tuwe naheta kwaw ikatu 'ym ma'e hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Aze iporomono wer àràpuhàràna'yr hawitu ma'e rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","awa opokok putar iàkàg rehe nehe. Uzuka putar tàpuzràn Tupàn pe imonokatu pyrer henataromo nehe. Xaxeto Àràw izuapyapyr umupiripirik putar huwykwer 4 ma'ea'yr hapy haw ipehegwer rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Amo xaxeto omono putar ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pe hemi'u imono pyr romo nehe: ikawer, huwaz paw, ikawer hie kwer ipyk arer, ");
INSERT INTO gubBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","mokoz iku'azarer, ikawer iku'azarer ipyk arer, ipy'a kwer ipehegwer ikatu wera'u ma'e. Xaxeto wenuhem putar a'e ipy'a pehegwer iku'azarer henuhem mehe wà nehe. Omonohok putar huwaz ikupekagwer huwakea'i nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Xaxeto wapy putar a'e ma'e paw ma'ea'yr hapy haw rehe temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Aze iporomono wer àràpuhàrànetea'yr Tupàn pe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","omono putar opo ma'ea'yr iàkàg rehe izuka pà tàpuzràn Tupàn pe imonokatu pyrer henataromo nehe. Xaxeto Àràw izuapyapyr umupiripirik putar huwykwer 4 ma'ea'yr hapy haw ipehegwer rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Amo xaxeto omono putar ma'ea'yr ipehegwer Tupàn Tuweharupi Wiko Ma'e pe, temi'u izupe imono pyr romo nehe: ");
INSERT INTO gubBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ikawer hie kwer ipyk awer, mokoz iku'azarer, ikawer iku'azarer ipyk awer, ipy'a ipehegwer ikatu wera'u ma'e. Xaxeto wenuhem putar a'e ipy'a pehegwer iku'azarer henuhem mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Xaxeto wapy putar a'e ma'e paw ma'ea'yr hapy haw rehe nehe, temi'u imono pyr hyàkwegatu ma'e romo a'e nehe. Tupàn Tuweharupi Wiko Ma'e wiko kawer paw izar romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","A'e rupi Izaew wà nehe, wyzài ywy rehe wiko mehe wà nehe, nu'u kwaw ikawer wà nehe. Nu'u kwaw huwykwer wà nehe no. Peruzar ko ze'eg tuweharupi nehe. Tuwe pezuapyapyr weruzar tuweharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","— Emume'u ko heze'eg teko wanupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Aze amo Izaew uzuhaw heze'eg nehe, hehe ipuruzuhaw wer 'ym pà nehe, aze nuweruzar kwaw amo ize'eg nehe, a'e teko uzapo putar ma'e wemiapo kwer hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Aze xaxeto wanuwihawete uzapo ikatu 'ym ma'e nehe, aze a'e rupi umuigo kar teko paw ikatu 'ym ma'e iapo har romo Tupàn henataromo wà nehe, uzuka putar tapi'aka'yr awa Tupàn Tuweharupi Wiko Ma'e henataromo a'e ikatu 'ym ma'e imunàn kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Weraha putar a'e ma'ea'yr tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. Omono putar opo ma'ea'yr iàkàg rehe nehe. Uzuka putar a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Na'e omono'og putar huwykwer ikurer nehe. Weraha putar tàpuzràn pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","A'e pe umuàkym putar ukwà huwykwer pupe nehe. Na'e umupiripirik putar huwykwer Tupàn Tuweharupi Wiko Ma'e henataromo pànuhu imuzaiko pyrer henaw ikatu ma'e pe teixe haw rehe har henataromo nehe, 7 haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","A'e re, Tupàn Tuweharupi Wiko Ma'e henataromo, omono putar huwykwer pixika'i yhyk zàwenugar Tupàn pe imonokatu pyrer hapy haw tàpuzràn pupe har iahykaw rehe nehe. Uzakook putar huwykwer ikurer ma'ea'yr hapy haw iwype har rehe nehe, tàpuzràn henataromo har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Xaxeto wenuhem putar ma'ea'yr ikawer paw izuwi nehe. Aze'eg ikawer hie ipykaw rehe xe ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Wenuhem putar mokoz iku'azarer, ikawer iku'azarer ipyk awer, ipy'a kwer ipehegwer ikatu wera'u ma'e. Xaxeto wenuhem putar a'e ipy'a kwer ipehegwer iku'azarer henuhem mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Xaxeto wenuhem a'e ma'e paw tapi'ak wi a'e awa Tupàn pe uzemuawyze kar haw romo a'e. Uzapo putar nezewegatete 'aw tapi'ak pe nehe no. Xaxeto wapy putar paw rupi ma'e hapy haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Upyhyk putar ma'ea'yr ipehegwer nehe: ipirer, ho'o kwer paw, iàkàgwer, hetymàgwer, hie kwer, hie kwer rehe har. ");
INSERT INTO gubBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Weraha putar a'e ma'e paw katu pe teko waneko haw wi nehe, amo ywy pehegwer Tupàn pe imukatu pyrer pe nehe, tanimuk heityk pyrer pe nehe. Wapy putar ma'ea'yr a'e pe zepe'aw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Aze ru'u teko paw uzuhaw amo Tupàn Tuweharupi Wiko Ma'e ize'eg a'e wà nehe, hehe ipuruzuhaw wer 'ym pà a'e wà. Aze ru'u uzapo putar ikatu 'ym ma'e henataromo wà nehe. Aze uzapo ikwaw 'ym pà wà nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","aze amo 'ar mehe ukwaw wemiapo kwer ikatu 'ymaw wà nehe, weraha putar tapi'aka'yr awa izuka pyràm romo tàpuzràn Tupàn pe imonokatu pyrer henataromo wà nehe, wemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo tuwihaw omono putar opo ma'ea'yr iàkàg rehe izuka pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","A'e re xaxeto wanuwihawete weraha putar huwykwer ikurer tàpuzràn pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Umuàkym putar ukwà huwykwer pupe nehe. Tupàn Tuweharupi Wiko Ma'e henataromo umupiripirik putar huwykwer pànuhu imuzaiko pyrer henataromo 7 haw nehe, Tupàn henaw ikatu ma'e pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","A'e re, Tupàn Tuweharupi Wiko Ma'e henataromo omono putar huwykwer pixika'i ywyrapew tàpuzràn pupe har iahykaw rehe nehe. Uzakook putar huwykwer ikurer ma'ea'yr hapy haw ma'e hapy haw tàpuzràn henataromo har iwype har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A'e re wenuhem putar ma'ea'yr ikawer paw nehe. Wapy putar ikawer paw ma'ea'yr hapy haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Uzapo ma'e ma'ea'yr pe ukatu 'ymaw imunàn kar pà Tupàn pe. Uzapo putar nezewegatete 'aw ma'ea'yr pe nehe no. Xaxeto omono putar a'e ma'e Tupàn pe teko wanemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe. Tupàn umunàn putar wanemiapo kwer ikatu 'ymaw nezewe mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Xaxeto weraha inugwer tapi'ak katu pe waneko haw wi hapy pà. Uzapo putar nezewegatete 'aw ma'ea'yr pe nehe no. Amume'u Tupàn pe imur pyr teko wanemiapo kwer ikatu 'ym ma'e imunàn kar haw kwez xe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Aze amo tuwihaw uzuhaw amo Tupàn ze'eg nehe, hehe ipuruzuhaw wer 'ym pà nehe, aze uzapo amo ma'e Tupàn Tuweharupi Wiko Ma'e Zanezar hemiapo kar 'ym nehe, amo umume'u putar hemiapo kwer izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Henu mehe na'arewahy werur putar àràpuhàrànete awa ikatu 'ymaw hereko 'ymar Tupàn pe nehe, izupe imono pyr romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Awa omono putar opo iàkàg rehe nehe. Na'e uzuka putar a'e ma'ea'yr Tupàn Tuweharupi Wiko Ma'e henataromo nehe, ma'ea'yr hapy haw huwake kwarahy heixe haw awyze har kutyr nehe. A'e pe xaxeto uzuka ma'ea'yr hapy pyràm wà. A'e tuwihaw uzuka putar a'e ma'ea'yr wemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Na'e xaxeto umuàkym putar ukwà huwykwer pupe nehe, imono pà ma'ea'yr hapy haw iahykaw rehe nehe. Na'e uzakook putar huwykwer ikurer ma'ea'yr hapy haw iwype har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Tupàn pe uzemuawyze kar haw iapo mehe wapy ikawer paw. Nezewegatete xe no. Wapy putar ikawer paw ma'ea'yr hapy haw rehe nehe. Nezewe mehe xaxeto omono putar a'e imono pyr Tupàn pe wemiapo kwer imunàn kar pà Tupàn pe nehe. Tupàn umunàn putar hemiapo kwer izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Aze amo teko uzuhaw amo Tupàn ze'eg a'e nehe, hehe ipuruzuhaw wer 'ym pà nehe, aze ru'u uzapo putar ikatu 'ym ma'e henataromo nehe. Aze uzapo ikwaw 'ym pà nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","aze amo 'ar mehe amo umume'u hemiapo kwer ikatu 'ymaw izupe nehe, weraha putar àràpuhàrànete kuzà izuka pyràm romo Tupàn pe nehe, wemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Omono putar opo iàkàg rehe nehe. Uzuka putar a'e ma'ea'yr hapy haw huwake kwarahy heixe haw awyze har kutyr nehe. A'e pe xaxeto uzuka ma'ea'yr hapy pyràm wà. ");
INSERT INTO gubBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Xaxeto umuàkym putar ukwà huwykwer pupe nehe, imono pà ma'ea'yr hapy haw iahykaw rehe nehe. Uzakook putar huwykwer ikurer ma'ea'yr hapy haw iwype har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Wenuhem ma'ea'yr ikawer paw hapy pà hapy haw rehe Tupàn pe uzemuawyze kar haw iapo mehe. Nezewegatete wenuhem putar àràpuhàràn kuzà ikawer paw hapy pà hapy haw rehe nehe no. A'e imono pyr hyàkwegatu putar Tupàn Tuweharupi Wiko Ma'e pe nehe. Ikatu putar izupe nehe. Nezewe mehe xaxeto omono putar a'e ma'e Tupàn pe teko wanemiapo kwer ikatu 'ym ma'e imunàn kar pà izupe nehe. Tupàn umunàn putar a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Aze amo teko werur amo àràpuhàrànete kuzà wemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe nehe, tuwe naheta kwaw ikatu 'ymaw a'e ma'ea'yr rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A'e teko omono putar opo àràpuhàrànete iàkàg rehe nehe. Na'e uzuka putar ma'ea'yr hapy haw huwake kwarahy heixe haw awyze har kutyr nehe. Xaxeto uzuka ma'ea'yr hapy paw pyràm a'e hapy haw huwake nehe. Uzuka putar wemiapo kwer ikatu 'ym ma'e imunàn kar pà Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Xaxeto umuàkym putar ukwà àràpuhàrànete kuzà huwykwer pupe nehe, imono pà ma'ea'yr hapy haw iahykaw rehe nehe. Na'e uzakook putar huwykwer ikurer ma'ea'yr hapy haw iwype har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Tupàn pe uzemuawyze kar haw iapo mehe wapy ikawer paw. Nezewegatete xe no. Wenuhem putar àràpuhàrànete kuzà ikawer paw nehe. Wapy putar ikawer ma'ea'yr hapy haw rehe nehe, Tupàn Tuweharupi Wiko Ma'e pe imono pyrer romo hapy pyrer wa'aromo nehe. Nezewe mehe xaxeto omono putar a'e imono pyr Tupàn pe hemiapo kwer imunàn kar pà Tupàn pe nehe. Tupàn umunàn putar hemiapo kwer izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Amume'u putar penemiapo kwer hekuzaromo ma'e imur pyràm xe ihe nehe kury: Aze tuwihaw wenoz amo wenataromo wà nehe, — Emume'u nerapi har hemiapo kwer urewe nehe, aze i'i izupe wà nehe, aze numume'u kwaw wemixak kwer nehe, aze numume'u kwaw weminu kwer nehe, a'e mehe ikatu 'ym ma'e iapo har romo wiko putar tuwihaw wanenataromo a'e nehe. Ikatu putar hehe wazepyk àwàm nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Aze amo nuzekaiw katu kwaw wemiapo rehe nehe, aze a'e rupi opokok amo Tupàn henataromo iaiw ma'e rehe nehe, amo ma'ea'yr umàno ma'e kwer rehe nehe, aze ru'u, amo miar umàno ma'e kwer rehe nehe, aze ru'u, amo ma'ea'yr ywy rehe uzeikyz ma'e rehe nehe, a'e mehe a'e teko wiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe. Wiko putar ikatu 'ym ma'e iapo har romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Aze amo nuzekaiw katu kwaw wemiapo rehe nehe, aze a'e rupi opokok wyzài Tupàn henataromo iaiw ma'e rehe amo teko ima'e rehe nehe, wemiapo kwer ikatu 'ymaw ikwaw mehe a'e teko wiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe. Wiko putar ikatu 'ym ma'e iapo har romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Aze amo nuzekaiw kwaw wemimume'u rehe nehe, aze a'e rupi umume'uahy amo wemiapo ràm nehe, ikatu ma'e nehe, aze ru'u ikatu 'ym ma'e nehe, aze umume'uahy uma'enukwaw 'ym pà nehe, a'e mehe wemimume'u ikatu 'ymaw ikwaw mehe na'arewahy wiko putar ikatu 'ym ma'e iapo har romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Aze amo uzapo wyzài agwer ma'e nehe, tuwe umume'u wemiapo kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Tuwe werur amo ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pe ukatu 'ymaw imunàn kar pà Tupàn pe nehe no. Werur putar àràpuhàràn hawitu ma'e kuzà nehe. U, werur putar àràpuhàrànete kuzà nehe. Na'e xaxeto omono putar ma'ea'yr Tupàn pe nehe, hemiapo kwer imunàn kar pà izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Aze amo nuwereko kwaw hekuzar ràm nehe, aze nupuner kwaw ni àràpuhàràn hawitu ma'e kuzà ni àràpuhàrànete kuzà imekuzar haw rehe nehe, a'e mehe omono putar mokoz pyku'i Tupàn pe wà nehe, u, mokoz pykahu izupe wà nehe, wemiapo kwer imunàn kar pà izupe nehe. Pitài wiràmiri wiko putar hemiapo kwer imunànaw romo nehe. Inugwer wiko putar Tupàn pe imono pyr ukaz ma'e ràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A'e teko omono putar a'e mokoz wiràmiri xaxeto pe wà nehe. Xaxeto uzuka wiràmiri ikatu 'ygwer imunàn àwàm izypy mehe nehe. Uzuhaw putar iazu'yw iàkàg izo'ok 'ym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Umupiripirik putar ma'ea'yr hapy haw ipehegwer huwykwer ikurer pupe nehe. A'e re umuyryk kar putar huwykwer ma'ea'yr hapy haw iwype har rehe nehe. A'e izuka pyr wiko hemiapo kwer ikatu 'ym ma'e imunàn kar haw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Na'e xaxeto omono putar inugwer wiràmiri Tupàn pe hapy pyr romo ukaz paw ma'e romo Tupàn ze'eg rupi katete nehe. Nezewe xaxeto omono putar a'e ma'e Tupàn pe a'e teko hemiapo kwer ikatu 'ym ma'e imunàn kar haw romo nehe. Tupàn umunàn putar hemiapo kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Aze amo nuwereko kwaw temetarer nehe, aze nupuner kwaw ni mokoz pyku'i ni mokoz pykahu wame'eg kar haw rehe nehe, a'e mehe werur putar pitài kir arozràn imuku'i pyrer ikatu wera'u ma'e Tupàn pe wemiapo kwer imunàn kar haw romo nehe. Tuwe numupyràn kwaw uri kawer inuromo nehe. Tuwe numupyràn kwaw yhyk zàwenugar inuromo nehe no. Ta'e omono putar Tupàn pe wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Xaxeto upyhyk putar arozràn a'e teko wi nehe. Upyhyk putar opo ipor hapy pà ma'ea'yr hapy haw rehe nehe, temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr i'aromo nehe. Nezewe mehe ima'enukwaw putar a'e arozràn paw Tupàn pe imono awer rehe nehe. Omono izupe wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo. ");
INSERT INTO gubBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nezewe xaxeto omono putar a'e ma'e Tupàn pe hemiapo kwer ikatu 'ym ma'e imunàn kar haw romo nehe. Tupàn umunàn putar hemiapo kwer nehe. Nuzawy kwaw amogwer arozràn Tupàn pe imono pyr nehe. Xaxeto upyhyk putar ikurer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Tupàn Tuweharupi Wiko Ma'e uzapo kar ko ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Aze amo nomono kwaw ma'e imonokatu pyrer Tupàn Tuweharupi Wiko Ma'e pe nehe, ikwaw 'ym pà nehe, a'e mehe omono putar hekuzar nehe. Werur putar amo àràpuhàràn ikatu 'ymaw hereko 'ymar Tupàn Tuweharupi Wiko Ma'e pe henataromo izuka pà nehe. Xaxeto umume'u putar hekuzar izupe nehe, ta'e ukwaw tàpuzuhu pupe har wanekuzar a'e wà xe. A'e ma'ea'yr wiko a'e teko ikatu 'ym ma'e iapo har romo heko haw imunànaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","A'e teko omono putar Tupàn pe imono pyr wemimono kwer 'ym xaxeto pe nehe no. Omono putar amo hekuzar ipehegwer izupe nehe no. Umuza'aza'ak putar hekuzar 5 pehegwer romo nehe. Omono putar hekuzar izupe nehe. Omono putar amo ipehegwer izupe nehe no. Xaxeto upyhyk putar àràpuhàràn hawitu ma'e awa a'e teko ikatu 'ym ma'e iapo har romo heko haw imunànaw nehe. Omono putar Tupàn pe henataromo izuka pà nehe, hemiapo kwer imunàn kar haw romo nehe. Tupàn umunàn putar hemiapo kwer izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Aze amo uzapo ikatu 'ym ma'e Tupàn henataromo hehe ipurapo wer 'ym pà nehe, aze nuweruzar kwaw wyzài Tupàn Tuweharupi Wiko Ma'e ze'eg nehe, aze uzapo hemiapo kar 'ym nehe, wiko putar ikatu 'ym ma'e iapo arer romo Tupàn henataromo nehe. Tuwe tuwihaw uzepyk hehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Weraha putar àràpuhàràn hawitu ma'e awa ikatu 'ymaw hereko 'ymar xaxeto pe nehe, ukatu 'ymaw imunàn àwàm romo nehe. Xaxeto umume'u putar ma'ea'yr hekuzar nehe, ta'e ukwaw tàpuzuhu pupe har wanekuzar a'e wà xe. Xaxeto omono putar ma'ea'yr Tupàn pe hemiapo kwer ikatu 'ym ma'e imunàn kar haw romo nehe. Na'ipurapo wer kwaw a'e ma'e rehe iapo mehe. Uzapo e. ");
INSERT INTO gubBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Wiko Tupàn Tuweharupi Wiko Ma'e henataromo ikatu 'ym ma'e iapo arer romo a'e. Uzuka putar a'e ma'ea'yr iapo arer romo weko haw imunàn kar haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Tupàn Tuweharupi Wiko Ma'e uzapo kar ko ma'e teko Izaew izuapyapyr wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Aze amo uzapo ikatu 'ym ma'e Tupàn Tuweharupi Wiko Ma'e henataromo nehe, nezewe imuwete 'ym pà nehe, omono putar ma'e Tupàn Tuweharupi Wiko Ma'e pe hekuzaromo nehe. Amume'u putar wanemiapo ikatu 'ym ma'e xe kury: Aze amo omono ma'e amo pe nehe, — Emonokatu ihewe nehe, aze i'i izupe nehe, aze a'e re numuzewyr kar kwaw izar pe nehe, omono putar ma'e Tupàn pe nehe. — Amono putar ko temetarer newe kury. Amo 'ar mehe emuzewyr kar ihewe nehe, i'i putar amo amo pe nehe. Temetarer heraha har wezar putar amo ma'e izar ipo pe hekuzaromo nehe. Amo 'ar mehe umuzewyr kar putar hemetarer nehe. Aze temetarer izar numuzewyr kwaw ima'e izupe nehe, omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. Aze amo imunar amo ima'e rehe nehe, omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. Aze amo upetek amo nehe, aze ukwar hehe nehe, aze unupà nehe, aze ukutuk nehe, aze ukixi nehe, omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Aze amo weityk amo ma'e ikwaw 'ym pà nehe, aze amo ae teko wexak a'e ma'e nehe, — Naexak kwaw ihe, aze i'i mua'u nehe, a'e mehe omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. Aze uzapo wyzài ikatu 'ym ma'e agwer ma'e zàwenugar nehe, omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Aze ihem wer ukatu 'ymaw wi nehe, umuzewyr putar ma'e izar pe nehe. Aze ru'u umuzewyr putar wemetarer hekuzaromo imur pyrer izar pe nehe. Aze ru'u, umuzewyr putar ma'e wahyharupi ipyro pyrer hekuzar nehe. Aze ru'u, umuzewyr putar ma'e heityk pyrer izar pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Aze ru'u, umukatu putar wyzài wemimume'u mua'u kwer nehe. Omono putar ma'e Tupàn pe wemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. Imono haw 'ar mehe omono putar a'e ma'e hekuzar izar pe nehe. Umuza'ak putar hekuzar 5 pehegwer romo nehe. Omono we putar amo pitài ipehegwer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Omono putar àràpuhàràn hawitu ma'e awa ikatu 'ymaw hereko 'ymar Tupàn pe henataromo izuka pà nehe, ikatu 'ym ma'e iapo har romo weko haw imunàn pà nehe. Xaxeto umume'u putar ma'ea'yr hekuzar nehe, ta'e ukwaw ma'e tàpuzuhu pupe har wanekuzar a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Xaxeto omono putar a'e ma'e Tupàn Tuweharupi Wiko Ma'e pe hemiapo kwer imunàn kar haw romo nehe. Tupàn umunàn putar wyzài hemiapo kwer izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Nezewe uze'eg Tupàn Moizez pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","— Emume'u ko heze'eg ma'e hapy pyràm rehe har Àràw pe nehe, ta'yr wanupe nehe no. Ma'e hapy pyràm umumaw putar pytun gatu ma'ea'yr hapy haw rehe upyta pà nehe. Tuwe tata nuwew kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Xaxeto umunehew putar wemyhar irin iapo pyrer nehe. Umunehew putar ukamir puku irin iapo pyrer nehe no. A'e ma'e ikaz pawire xaxeto wenuhem putar tanimuk a'e wi nehe. Omono putar ma'ea'yr hapy haw izywyr nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","A'e re wenuhem putar uma'e nehe. Umunehew putar uma'e uzehe harete nehe. Weraha putar tanimuk amo ywypehegwer Tupàn henataromo ikatu ma'e pe katu pe teko waneko haw wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Tuwe tata ma'ea'yr hapy haw rehe har nuwew pixik kwaw nehe. Tuwe ukaz tuweharupi nehe. Tuweharupi ku'em mehe xaxeto omono putar zepe'aw tata rehe nehe. Omono putar Tupàn pe imono pyr ukaz paw ma'e ràm hehe nehe. Wapy putar ma'e Tupàn imuawyze kar haw ikawer a'e pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Tata ma'ea'yr hapy haw pe har nuwew pixik kwaw nehe. Tuwe ukaz tuweharupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Na'aw Tupàn ze'eg arozràn imur pyr rehe har xe kury. Xaxeto omono putar arozràn imono pyr Tupàn Tuweharupi Wiko Ma'e pe ma'ea'yr hapy haw henataromo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Umupyràn putar uri kawer arozràn inuromo wà. Umupyràn yhyk zàwenugar inuromo wà nehe no. Amo xaxeto upyhyk putar arozràn opo ipor nehe. Wapy putar ma'ea'yr hapy haw rehe nehe. Nezewe mehe ukwaw a'e ma'e paw Tupàn pe imono awer wà nehe. Hyàkwegatu putar Tupàn Tuweharupi Wiko Ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Xaxeto Àràw izuapyapyr upyhyk putar arozràn ikurer wà nehe. Uma'ema'e putar arozràn typy'ak iapo pà wà nehe. U'u putar ywypehegwer Tupàn henataromo ikatu ma'e rehe wà nehe, tàpuzràn Tupàn pe imonokatu pyrer huwake wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Numupyràn kwaw imuapiruru kar haw inuromo wà nehe. Tupàn wiko a'e arozràn xaxeto wanemi'u ràm izar romo a'e. A'e rupi ikatuahy henataromo. Katu 'ygwer imunànaw a'e no, ikatu 'ym ma'e iapo har romo teko haw imunànaw a'e no, ikatuahy henataromo a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Awa Àràw izuapyapyr upuner a'e typy'ak i'u haw rehe tuweharupi wà nehe. Teko omono temi'u Tupàn Tuweharupi Wiko Ma'e pe wà. Àràw izuapyapyr u'u a'e ikurer wà. Aze amo teko opokok a'e imono pyr rehe wà nehe, uzeapo putar iaiw haw nehe. Ta'e a'e ma'e ikatuahy Tupàn henataromo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Nezewe Àràw izuapyapyr uzemukatu kar putar Tupàn henataromo xaxeto romo wiko mehe wà nehe. Amo xaxeto Tupàn henataromo uzemukatu mehe nehe, omono putar pitài kir arozràn imuku'i pyrer izupe nehe, temi'u imur haw tuweharupi har zàwe nehe. Omono putar iku'aw har ku'em mehe nehe. Omono putar inugwer iku'aw har karuk mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tuwe umupyràgatu arozràn imuku'i pyrer uri kawer inuromo nehe. Tuwe umihir ma'e mihir haw rehe nehe. A'e re upei'ài'àg putar typy'ak nehe. Xaxeto omono putar Tupàn pe arozràn imono pyr romo nehe. A'e ma'e hyàkwegatu Tupàn Tuweharupi Wiko Ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ko ze'eg teko weruzar putar tuweharupi wà nehe: wyzài Àràw izuapyapyr nehe, aze wiko xaxeto wanuwihawete romo nehe, uzapo putar nezewegatete haw nehe no. Wapy putar a'e ma'e Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Ukaz paw putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Aze amo xaxeto omono amo arozràn Tupàn pe wà nehe, ni amo nupuner kwaw a'e arozràn i'u haw rehe wà nehe. Wapy putar wà nehe. Ukaz paw putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Uze'eg Tupàn Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Emume'u ko heze'eg Àràw pe nehe, ta'yr wanupe nehe no. Na'aw Tupàn pe imono pyr ikatu 'ym ma'e iapo awer imunànaw rehe har xe. Xaxeto upyhyk putar ma'ea'yr ikatu 'ygwer imunànar wà nehe. Uzuka putar Tupàn Tuweharupi Wiko Ma'e henataromo wà nehe, ma'ea'yr hapy haw izywyr kwarahy heixe haw awyze har kutyr wà nehe. Xaxeto uzuka ma'ea'yr Tupàn henataromo hapy pyr a'e pe wà. A'e Tupàn pe imono pyr ikatuahy henataromo. ");
INSERT INTO gubBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Xaxeto a'e ma'ea'yr imono har u'u putar ho'o kwer amo ywypehegwer Tupàn henataromo ikatuahy ma'e rehe nehe, tàpuzràn Tupàn pe imonokatu pyrer huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Aze amo opokok a'e ma'ea'yr ho'o kwer rehe nehe, uzeapo putar iaiw haw izupe nehe. Ta'e a'e Tupàn pe imono pyr ikatuahy henataromo xe. Aze ma'ea'yr huwykwer upirik amo teko ikamir rehe nehe, tuwe uhez a'e kamir amo ywypehegwer Tupàn henataromo ikatu ma'e rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Aze umupupur ho'o kwer amo zapepo ywyzuwa iapo pyrer pupe nehe, tuwe uzukazuka a'e zapepo nehe. Aze umupupur zapepo itatàtà iapo pyrer pupe nehe, tuwe ukytyk katu nehe, ihez katu pà 'y pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Wyzài awa xaxeto iànàm upuner a'e ma'ea'yr Tupàn pe imono pyr ho'o kwer i'u haw rehe wà nehe. Ikatuahy a'e ma'e Tupàn henataromo. ");
INSERT INTO gubBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Aze xaxeto weraha huwykwer tàpuzràn Tupàn pe imonokatu pyrer pupe nehe, ikatu 'ygwer imunàn kar pà Tupàn pe nehe, ni amo nupuner kwaw ho'o kwer i'u haw rehe wà nehe. Tuwe wapy nehe. Tuwe ukaz paw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Na'aw Tupàn ze'eg ikatu 'ym ma'e iapo har romo teko haw imunànaw rehe har xe kury. Agwer imono pyr ikatuahy Tupàn henataromo. ");
INSERT INTO gubBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Uzuka putar ma'ea'yr ma'ea'yr hapy haw huwake kwarahy heixe haw awyze har kutyr wà nehe. Xaxeto uzuka ma'ea'yr hapy pyràm ukaz paw ma'e ràm a'e pe wà. Umupiripirik putar huwykwer 4 ma'ea'yr hapy haw ipehegwer wanehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Wapy putar ikawer paw Tupàn henataromo wà nehe. Wapy putar amo ma'e wà nehe no: huwaz gwer, ikawer hie ipyk awer, ");
INSERT INTO gubBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mokoz iku'azarer, ikawer iku'azarer ipyk awer, ipy'a kwer ipehegwer ikatu wera'u ma'e. ");
INSERT INTO gubBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Xaxeto wapy putar a'e ma'e paw ma'ea'yr hapy haw rehe temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr romo nehe. A'e ma'e imono haw umunàn ikatu 'ym ma'e iapo har romo teko haw puruwi. ");
INSERT INTO gubBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Wyzài awa xaxeto iànàm upuner ipehegwer i'u haw rehe wà nehe. Tuwe u'u amo ywypehegwer Tupàn pe imonokatu pyrer rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ze'eg ma'ea'yr hapy haw katu 'ygwer imunànaw rehe har nuzawy kwaw ze'eg ma'ea'yr hapy haw ikatu 'ym ma'e iapo har romo teko haw imunànaw a'e. Amo zauxiapekwer omono putar a'e ma'ea'yr Tupàn pe henataromo izuka pà katu 'ygwer imunànaw romo nehe. A'e xaxeto wiko putar ho'o kwer izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Amo xaxeto omono putar amo ma'ea'yr Tupàn pe henataromo izuka pà hapy pà nehe. A'e 'ym mehe upirok putar nehe. Wiko putar ipirer izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Amo xaxeto omono putar arozràn Tupàn pe nehe: zepehe pupe imihir pyrer, aze ru'u zapepo pupe imihir pyrer, aze ru'u imihir haw rehe imihir pyrer. A'e xaxeto wiko a'e arozràn izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Xaxeto paw wiko putar arozràn Tupàn pe imono pyr imupupur 'ym pyr izar romo wà nehe, uri kawer inuromo har wà nehe, inuromo har 'ym wà nehe no. Pitàitàigatu upyhyk putar ikurera'i wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Na'aw ze'eg ma'e Tupàn Tuweharupi Wiko Ma'e pe imono pyr rehe har purupe imuawyze kar haw rehe har xe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Aze amo omono ma'e Tupàn pe nehe, ikatu haw imume'u pà izupe nehe, uzuka putar amo ma'ea'yr nehe. Omono putar typy'ak arozràn imuku'i pyrer uri kawer inuromo imupyràn pyrer izupe nehe no. Nomono kwaw imuapiruru kar haw inuromo nehe. Aze ru'u omono putar typy'ak ipew ma'e imuapiruru kar pyrer 'ym izupe nehe. Omono putar uri kawer hehe nehe. Umupyràn uri kawer inuromo iapo mehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nezewe omono ma'e Tupàn pe imurywete kar pà nehe. A'e teko omono putar typy'ak iamuapiruru kar pyrer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Wenuhem putar pitài typy'ak a'e typy'ak hexakaw nànàn nehe, Tupàn Tuweharupi Wiko Ma'e pe imono pyr ikatuahy ma'e romo nehe. Xaxeto ma'ea'yr hapy haw rehe ma'ea'yr huwykwer imupiripirikar wiko a'e temi'u izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","U'u putar ma'ea'yr ho'o kwer paw izuka haw 'ar mehe nehe. Nupuner kwaw ikurer imonokatu haw rehe iku'egwepe har romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Aze amo werur ma'e Tupàn pe uzemuawyze kar haw romo nehe, wemimume'u kwer iapo pà nehe, aze ru'u werur e izupe nehe, xaxeto upuner ho'o kwer i'u haw rehe amo 'ar mehe nehe. Upuner ikurer i'u haw rehe iku'egwer pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Aze na'iruz haw 'ar mehe heta we ma'ero'o kwer nehe, tuwe wapy nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Aze amo u'u ma'ero'o kwer na'iruz haw 'ar mehe har nehe, nuzemuawyze kar kwaw Tupàn pe nehe. Hemimono na'ikatu kwaw izupe nehe. Ho'o kwer na'ikatu kwaw Tupàn henataromo. Tupàn uzepyk putar i'u arer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Aze amo umuhyk kar a'e ma'ero'o kwer Tupàn henataromo ikatu 'ym ma'e rehe nehe, tuwe wapy nehe. Pe'u zo nehe. Wyzài teko Tupàn henataromo ikatu ma'e upuner ma'e imono pyr imuawyze kar haw i'u haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Aze amo Tupàn henataromo ikatu 'ym ma'e u'u nehe, tuwe teko omono kar umyter wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Aze amo opokok Tupàn henataromo ikatu 'ym ma'e rehe nehe, teko ima'e ikatu 'ym ma'e rehe nehe, aze ru'u ma'ea'yr ima'e ikatu 'ym ma'e rehe nehe, aze a'e re u'u ma'ero'o kwer Tupàn pe uzemuawyze kar haw nehe, tuwe teko omono kar umyter wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Uze'eg Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Emume'u heze'eg teko wanupe nehe. — Pe'u zo tapi'ak ikawer nehe. Pe'u zo àràpuhàràn hawitu ma'e ikawer nehe. Pe'u zo àràpuhàrànete ikawer nehe ");
INSERT INTO gubBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Aze amo ma'ea'yr umàno e nehe, pe'u zo ikawer nehe. Aze miar uzuka amo ma'ea'yr nehe, pe'u zo ikawer nehe. Pepuner amo ma'e iapo haw rehe ikawer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Aze xaxeto uzuka ma'ea'yr Tupàn Tuweharupi Wiko Ma'e henataromo temi'u imono pyr romo nehe, aze amo teko u'u ikawer nehe, tuwe teko omono kar a'e teko umyter wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Wyzài taw pe wyzài ywy rehe wiko mehe wà nehe, Izaew izuapyapyr nu'u kwaw ma'ea'yr huwykwer wà nehe. Nu'u kwaw wiràmiri huwykwer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Tuwe teko omono kar tuwykwer i'u har umyter wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","— Emume'u ko heze'eg teko wanupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Aze amo omono Tupàn pe uzemuawyze kar haw izupe nehe, omono putar ikurer izupe imono pyr ikatuahy ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Omono putar a'e temi'u izupe opo pupe ikatuahy ma'e romo nehe: ma'ea'yr ipuxi'a, ikawer ipuxi'a ipykaw. ");
INSERT INTO gubBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Xaxeto wapy putar ikawer ma'ea'yr hapy haw rehe nehe. Xaxeto wiko putar ipuxi'a izar romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Amo xaxeto omono putar huwykwer Tupàn pe nehe. Omono putar ikawer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","A'e xaxeto wiko putar ma'ea'yr Tupàn pe uzemuawyze kar haw romo izuka pyrer henugupy awyze har izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Tupàn Tuweharupi Wiko Ma'e upyro ipuxi'a a'e. Upyro henugupy a'e no, imur pyr ikatuahy ma'e romo a'e, Izaew wanuwi a'e. Omono xaxeto Àràw izuapyapyr wanupe. Tuweharupi xaxeto upyhyk putar a'e Tupàn uzemuawyze kar haw ipehegwer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Amumaw ma'ea'yr pehegwer Tupàn Tuweharupi Wiko Ma'e henataromo izuka pyr Àràw pe izuapyapyr wanupe wamono pyr wamume'u haw kwez kury. Xaxeto wanuwihaw wexaexak putar awa xaxeto romo wamuigo kar pà amo 'ar mehe wà nehe. A'e 'ar henataromo upyhyk putar a'e ma'ea'yr pehegwer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Tupàn Tuweharupi Wiko Ma'e umuigo kar xaxeto romo wà. A'e 'ar mehe arer we, — Pemono kar a'e ma'ea'yr pehegwer xaxeto wanupe nehe, i'i Izaew wanupe. Peruzar a'e ze'eg tuweharupi nehe. Tuwe pezuapyapyr weruzar a'e ze'eg tuweharupi wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Amumaw Tupàn ze'eg ma'e izupe imur pyr rehe har imume'u haw kwez xe kury: henataromo ukaz paw ma'e, arozràn, katu 'ygwer imunànaw, ikatu 'ym ma'e iapo har romo teko haw imunànaw, awa xaxeto romo imuigo kar haw rehe har, Tupàn pe uzemuawyze kar haw no. ");
INSERT INTO gubBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Tupàn Tuweharupi Wiko Ma'e omono a'e uze'eg Moizez pe Xinaz ywytyr rehe a'e, ywyxiguhu rehe a'e. — Pemono ma'e Tupàn Tuweharupi Wiko Ma'e pe nehe, i'i Moizez Izaew wanupe a'e 'ar mehe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Eraha Àràw tàpuzràn ihewe imonokatu pyrer pe teixe haw pe nehe. Eraha ta'yr a'e pe ne wà nehe no. Epyhyk ko ma'e nehe: kamirpuku xaxeto ima'e, uri kawer ma'e rehe izakook pyr, tapi'aka'yr awa teko wanemiapo kwer ikatu 'ym ma'e imunànaw, mokoz àràpuhàràn hawitu ma'e awa wà, typy'ak imuapiruru kar haw hereko 'ymar kok ipor. ");
INSERT INTO gubBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Emono'og teko paw tàpuzràn ihewe imonokatu pyrer herenataromo ne wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Uzapo Moizez Tupàn Tuweharupi Wiko Ma'e hemiapo kar kwer. Teko paw uzemono'og Tàpuzràn Tupàn pe imonokatu pyrer henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Na'e Moizez umume'u ko ma'e wanupe kury. — Azapo putar Tupàn Tuweharupi Wiko Ma'e hemiapo kar kwer xe ihe nehe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Na'e Moizez umunyryk kar Àràw uzeupe kury. Umunyryk kar ta'yr wà no. — Pezezuhez katu nehe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Na'e umunehew kar kamirpuku tunik her ma'e Àràw pe kury. Umuzeku'amumyk kar no. Omono kar iaxi'i pykaw kamirpuku i'aromo. Na'e omono amo kamirpuku hehe no. Uzeku'amumyk kar wi no. ");
INSERT INTO gubBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Omono ipuxi'a imimaw hehe no. Omomog mokoz ma'e imimaw rehe no: Uri Tumi rehe we. ");
INSERT INTO gubBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Omono àkàg rehe har Àràw iàkàg rehe. Àkàg rehe har henataromo har rehe omono itazu or ipew ma'e romo iapo pyrer, Àràw xaxeto romo imuigo kar haw hexak kar haw romo. Tupàn Tuweharupi Wiko Ma'e uzapo kar a'e ma'e. Moizez uzapo a'e ma'e paw ize'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Na'e Moizez upyhyk uri kawer Tupàn pe iapo katu pyrer kury. Uzakook tàpuzràn Tupàn pe imonokatu pyrer rehe. Uzakook ipupe har nànàn no. Nezewe mehe omonokatu a'e ma'e paw Tupàn imuwete haw pe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Umupiripirik uri kawer ma'ea'yr hapy haw rehe 7 haw. Nezewe umuàkym ma'ea'yr hapy haw. Umuàkym ma'ea'yr hapy haw rehe har paw no. Uzakook uri kawer kawawhu rehe, iwype har rehe no, Tupàn pe imonokatu pà. ");
INSERT INTO gubBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Na'e Moizez uzakook uri kawer Tupàn pe imukatu pyrer Àràw iàkàg rehe kury. Nezewe mehe umuigo kar xaxeto romo kury. ");
INSERT INTO gubBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Na'e umunyryk kar ta'yr huwake wà kury. Umunehew kar tunik wanupe. Uzàpixipixi waku'aw har pupe. Umunehew kar àkàg rehe har waàkàg wanehe, Tupàn Tuweharupi Wiko Ma'e ze'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Na'e Moizez upyhyk tapi'aka'yr awa teko wanemiapo kwer katu 'ym ma'e imunànaw kury. Na'e Àràw a'e, ta'yr a'e wà no, opokok ma'ea'yr iàkàg rehe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Uzuka Moizez tapi'aka'yr. Upyhyk huwykwer ikurer. Omono huwykwer 4 ma'ea'yr hapy haw iahykaw wanehe ukwà pupe. Nezewe umukatu ma'ea'yr hapy haw Tupàn henataromo a'e re. Uzakook ikurer ma'ea'yr hapy haw iwype har rehe. Nezewe mehe Moizez umukatu ma'ea'yr hapy haw Tupàn henataromo, izupe imonokatu pà. ");
INSERT INTO gubBl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Na'e upyhyk amo ipehegwer wà kury: ikawer hie rehe har, ipy'a kwer ipehegwer ikatu wera'u ma'e, iku'azarer wà, ikawer iku'azarer ipykaw. Wapy a'e ma'e paw ma'ea'yr hapy haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A'e re weraha ma'ea'yr ikurer teko waneko haw wi katu pe hapy paw pà Tupàn Tuweharupi Wiko Ma'e ize'eg rupi katete: ho'o kwer, ipirer, hie kawer. ");
INSERT INTO gubBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Na'e upyhyk àràpuhàràn hawitu ma'e awa ukaz ma'e ràm romo izuka pyràm kury. Àràw a'e, ta'yr a'e wà no, omono opo iàkàg rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Uzuka Moizez ma'ea'yr a'e. Umupiripirik huwykwer 4 ma'ea'yr hapy haw iahykaw wanehe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Upei'ài'àg kury. Uhez hie kwer. Uhez hetymàgwer wà no. Wapy iàkàg. Wapy ikawer. Wapy ikurer ma'ea'yr hapy haw rehe, Tupàn Tuweharupi Wiko Ma'e ize'eg rupi katete. 'Aw ma'e hapy pyrer a'e, temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyrer a'e, hyàkwegatu Tupàn Tuweharupi Wiko Ma'e pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Na'e Moizez upyhyk àràpuhàràn hawitu ma'e awa inugwer kury, awa xaxeto romo wamuigo kar haw kury. Àràw a'e, ta'yr a'e wà no, opokok a'e ma'ea'yr iàkàg rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moizez uzuka ma'ea'yr. Na'e omono huwykwer pixika'i Àràw rehe ukwà pupe: inami iawyze har iapyr, ikwàhu ipo awyze har rehe no, ipyhàhu ipy awyze har rehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Na'e umunyryk kar Àràw ta'yr uzeake wà kury. Omono huwykwer wanami apyr, wakwàhu awyze har rehe no, wapyhàhu awyze har rehe no. Na'e umupiripirik huwykwer ikurer 4 ma'ea'yr hapy haw ipehegwer rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Na'e upyhyk àràpuhàràn awa ipehegwer kury: ikawer, huwaz wer, ikawer hie kwer ipyk awer, ipy'a pehegwer ikatu wera'u ma'e, mokoz iku'azarer, ikawer iku'azarer ipyk awer, henugupy iawyze har. ");
INSERT INTO gubBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Upyhyk amo typy'ak kok typy'ak imuapiruru kar pyrer 'ym pupe tynehem ma'e wi. A'e 'ym mehe omono a'e typy'ak Tupàn Tuweharupi Wiko Ma'e pe. Upyhyk typy'ak uri kawer pupe imuàkym pyrer no. Upyhyk pitài typy'ak pixika'i ma'e no. Omono a'e na'iruz typy'ak ikawer rehe, henugupy awyze har rehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Moizez omono a'e ma'e paw Àràw ipo pe, ta'yr wapo pe no. Na'e omono Tupàn Tuweharupi Wiko Ma'e pe imono pyr ikatuahy ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Na'e upyhyk a'e ma'e paw wapo wi ma'ea'yr hapy haw rehe ma'e hapy pyr i'aromo hapy pà kury, xaxeto romo wamuigo kar haw romo kury. Omono Tupàn Tuweharupi Wiko Ma'e pe temi'u imono pyr romo. Hyàkwegatu izupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","A'e re Moizez upyhyk ma'ea'yr ipuxi'a kury. Omono Tupàn Tuweharupi Wiko Ma'e ma'e imono pyr ikatuahy ma'e romo kury. Moizez wiko a'e ipehegwer izar romo Tupàn Tuweharupi Wiko Ma'e ize'eg awer rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moizez upyhyk uri kawer ikurer kury, huwykwer ma'ea'yr hapy haw rehe har ikurer no. Umupiripirik Àràw rehe, ima'e rehe no, ta'yr wanehe, wama'e rehe no. Nezewe uzapokatu Tupàn ima'ereko haw rehe wà: Àràw, ima'e no, ta'yr wà, wama'e no. ");
INSERT INTO gubBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Uze'eg Moizez Àràw pe ta'yr wanupe kury. — Peraha ho'o kwer tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw huwake nehe. Heta typy'ak kok xaxeto romo pemuigo kar haw rehe har hereko har pupe. Pemupupur ho'o kwer a'e pe i'u pà typy'ak a'e kok pupe har inuromo nehe. — Ezapo kar ko ma'e wanupe nehe, i'i Tupàn ihewe. A'e rupi — Pezapo nehe, a'e wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Peapy ho'o kwer ikurer nehe. Peapy typy'ak ikurer nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pemumaw 7 'ar tàpuzràn henataromo nehe. Nezewe mehe pemumaw putar xaxeto romo pemuigo kar haw 'ar nehe. Pemumaw 7 'ar a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Xiapo Tupàn Tuweharupi Wiko Ma'e hemiapo kar kwer kutàri, penemiapo kwer ikatu 'ym ma'e imunàn kar pà izupe. ");
INSERT INTO gubBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Pemumaw 7 'ar tàpuzràn Tupàn pe imonokatu pyrer henataromo pepyta pà nehe. Pepyta a'e pe pyhaw nehe no. Peruzar Tupàn Tuweharupi Wiko Ma'e ze'eg paw nehe. Nezewe mehe napemàno kwaw nehe. Tupàn umume'u kar ko ze'eg ihewe a'e. Amume'u kwez peme kury. ");
INSERT INTO gubBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Àràw a'e, ta'yr a'e wà no, weruzar Tupàn Tuweharupi Wiko Ma'e ize'eg Moizez pe imume'u pyrer paw wà. ");
INSERT INTO gubBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Upaw a'e 7 xaxeto romo wamuigo kar haw 'ar kwez kury. Iku'egwer pe Moizez wenoz Àràw imuwà kury. Wenoz ta'yr wà no, teko Izaew wanuwihaw wamuwà wà no. ");
INSERT INTO gubBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Na'e uze'eg Àràw pe. — Epyhyk mokoz ma'ea'yr ikatu 'ymaw hereko 'ymar ne wà nehe kury: pitài tapi'aka'yr awa Tupàn henataromo izuka pyràm katu 'ygwer imunàn àwàm romo, pitài àràpuhàràn hawitu ma'e awa Tupàn henataromo hapy paw pyràm romo. A'e re exak kar Tupàn Tuweharupi Wiko Ma'e pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","A'e re erur kar agwer ma'ea'yr teko wanupe nehe: pitài àràpuhàrànete awa katu 'ygwer hekuzaromo izuka pyràm romo, pitài tapi'aka'yr awa pitài kwarahy hereko har ikatu 'ymaw hereko 'ymar, pitài àràpuhàràna'yr awa pitài kwarahy hereko har ikatu 'ymaw hereko 'ymar. Wiko putar izuka pyr romo ukaz paw ma'e romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Epyhyk kar amo ma'ea'yr wanupe ne wà nehe no: tapi'ak awa, àràpuhàràn hawitu ma'e awa no. Wiko putar Tupàn pe zemuawyze kar haw romo izuka pyràm romo wà nehe. — Pezuka 'aw ma'ea'yr Tupàn Tuweharupi Wiko Ma'e henataromo pe wà nehe, ere wanupe nehe. — Pemono arozràn uri kawer inuromo har izupe nehe no, ere wanupe nehe. Tuwe uzapo a'e ma'e nehe, ta'e Tupàn Tuweharupi Wiko Ma'e uzexak kar putar wanenataromo kutàri a'e nehe xe, i'i Moizez Àràw pe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Teko werur ma'e Moizez hemimume'u kwer paw tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe wà kury. Teko paw uzemono'og a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Uze'eg Moizez kury. — Tupàn Tuweharupi Wiko Ma'e uzapo kar ko ma'e peme a'e. Nezewe mehe heko haw heny katu haw uzexak kar putar peme a'e nehe kury, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Na'e Moizez uze'eg Àràw pe. — Eho ma'ea'yr hapy haw pe ma'ea'yr katu 'ygwer imunàn kar haw imono pà Tupàn pe kury. Emono ma'e hapy pyr ukaz paw ma'e izupe nehe no. Nezewe mehe Tupàn umunàn putar neremiapo kwer ikatu 'ym ma'e newi nehe. Umunàn putar neànàm wanemiapo kwer ikatu 'ym ma'e wanuwi nehe no. Ta'e Tupàn Tuweharupi Wiko Ma'e uzapo kar nezewe haw zanewe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Àràw uhem ma'ea'yr hapy haw huwake tapi'aka'yr izuka pà wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo. ");
INSERT INTO gubBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ta'yr weraha ma'ea'yr huwykwer izupe wà. Umuàkym ukwà huwykwer pupe. Omono 4 ma'ea'yr hapy haw iahykaw rehe. Uzakook ikurer ma'ea'yr hapy haw iwype har rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Na'e wapy ma'ea'yr hapy haw rehe Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imume'u pyrer rupi katete: ikawer, iku'azarer, ipy'a kwer ipehegwer ikatu wera'u ma'e. ");
INSERT INTO gubBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Àràw weraha ho'o kwer ipirer rehe we katu pe teko waneko haw wi pepa'i hapy pà. ");
INSERT INTO gubBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Na'e Àràw uzuka àràpuhàràn hawitu ma'e awa Tupàn pe imono pà hapy pyr romo ukaz paw ma'e romo kury. Ta'yr weraha ma'ea'yr huwykwer izupe wà. Umupiripirik 4 ma'ea'yr hapy haw pehegwer wanehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","A'e re omono iàkàg izupe amogwer ma'ea'yr ipehegwer rehe we wà. Wapy ma'ea'yr hapy haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Uzuhez hie kwer. Uzuhez hetymà kwer no. Na'e wapy a'e ma'e, inugwer Tupàn henataromo hapy pyr i'aromo. ");
INSERT INTO gubBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","A'e re Àràw omono ma'e Tupàn pe teko wanekuzaromo kury. Upyhyk àràpuhàrànete awa teko wanemiapo kwer ikatu 'ym ma'e imunàn kar haw. Uzuka Tupàn pe imono pà. A'e 'ym mehe uzapo nezewegatete wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo no. ");
INSERT INTO gubBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Na'e upyhyk ma'ea'yr izuka pyràm hapy pyràm ukaz paw ma'e ràm kury. Omono Tupàn pe ize'eg rupi no. ");
INSERT INTO gubBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Omono arozràn Tupàn pe imono pyr kury, henataromo kury. (Tuweharupi ku'em mehe omono ma'e hapy pyr Tupàn pe.) Na'e ko 'ar rehe upyhyk amo ae arozràn imuku'i pyrer opo ipor. Wapy ma'ea'yr hapy haw rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Àràw uzuka tapi'ak awa teko Tupàn pe wamuawyze kar haw romo. Uzuka àràpuhàrànete awa nezewegatete no. Ta'yr weraha wanuwykwer izupe wà. Umupiripirik 4 ma'ea'yr hapy haw iahykaw wanehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Weraha amo ma'e izupe wà no: wakawer, wanuwaz wer, wakawer wanie kwer ipyk awer, waku'azarer, wapy'a kwer ipehegwer ikatu wera'u ma'e. ");
INSERT INTO gubBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Àràw omono a'e ma'e paw wapuxi'a kwer 'aromo, ma'ea'yr hapy haw pe heraha pà. Wapy wakawer hehe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Nuwapy kwaw wapuxi'a. Ni wanenugupy kwer. Àràw omono Tupàn Tuweharupi Wiko Ma'e pe xaxeto wanupe imonokatu pyr romo Moizez ze'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","A'e ma'e paw Tupàn pe imono re Àràw upyho opo teko wakutyr ze'egatu imono pà wanehe kury. Na'e wezyw ma'ea'yr hapy haw wi myromyrogaw rupi. ");
INSERT INTO gubBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Wixe tàpuzràn Tupàn pe imonokatu pyrer pupe Moizez rupi. A'e wi uhem mehe teko wanupe ze'egatu imono mehe Tupàn Tuweharupi Wiko Ma'e heko haw heny katu haw uzexak kar teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Na'arewahy uhem tata Tupàn Tuweharupi Wiko Ma'e henaw wi kury. A'e tata wapy henataromo imono pyrer ma'ea'yr hapy haw rehe imono pyrer kury. A'e ma'e hexak mehe teko Izaew uhapukaz urywete pà wà. Wapyk upenàràg rehe uwa imuhyk pà ywy rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nanaw Àràw ta'yr a'e, tywyr Amiu a'e no, upyhyk yhyk zàwenugar hapy haw pitàitàigatu wà. Omono yhyk zàwenugar ipupe wà no. Umunyk tata hehe wà. Na'e omono Tupàn Tuweharupi Wiko Ma'e henataromo izupe imono pyr romo wà. Nuzapo kwaw a'e ma'e Tupàn ze'eg rupi wà. A'e rupi wanemimur kwer na'ikatu kwaw Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Na'arewahy uhem tata Tupàn Tuweharupi Wiko Ma'e henaw wi wazuka pà kury. Umàno a'e pe Tupàn henaw henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Uze'eg Moizez Àràw pe. — Tupàn Tuweharupi Wiko Ma'e uze'eg mehe a'e ma'e rehe ipurumume'u wer a'e. — Heruwake uhem ma'e umuawate putar hekatuahy haw wà nehe. Heremiaihu hemuwete katu putar wà nehe, i'i Tupàn iko. Nuze'eg kwaw Àràw. ");
INSERT INTO gubBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Na'e Moizez wenoz mokoz awa wamuwà uzeupe wà kury. Mizaew Ewzàpà waner romo wà. Wiko Uziew Àràw itutyr ta'yr romo wà. — Penuhem peànàm wanetekwer tàpuzràn Tupàn pe imonokatu pyrer henatar wi pe wà nehe, katu pe zanereko haw wi waneraha pà pe wà nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Oho a'e pe wà. Upyhyk wanetekwer wakamirpuku rehe wà. Weraha katu pe weko haw wi pepa'i wà, Moizez ze'eg rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","A'e re Moizez uze'eg Àràw pe kury, ta'yr Ereazar her ma'e pe no, ta'yr Itamar her ma'e pe no. — Izaew paw upuner uzemumikahy haw rehe wiko haw rehe wà nehe kury, Tupàn Tuweharupi Wiko Ma'e hemizuka kwer wanehe uzai'o haw rehe wà nehe kury. Pepytu'u zo pe'aw imuguz re nehe. Pemu'i zo pekamir pezemumikahy haw hexak kar pà nehe. Aze naperuzar kwaw ko heze'eg nehe, pemàno putar nehe. A'e mehe Tupàn Tuweharupi Wiko Ma'e wikwahy putar teko paw wanupe a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Petyryk zo tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw wi nehe. Ta'e azakook uri kawer Tupàn Tuweharupi Wiko Ma'e henataromo pemukatu haw romo ihe xe, xaxeto romo pemuigo kar pà ihe xe, i'i wanupe. A'e na'iruz awa weruzar katu ize'eg wà. ");
INSERT INTO gubBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Tupàn Tuweharupi Wiko Ma'e uze'eg Àràw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","— Amume'u ko heze'eg newe kury. Ni ne nehe, ni nera'yr wà nehe, napepuner kwaw tàpuzràn ihewe imurkatu pyrer pupe peneixe haw rehe win i'u re nehe, kàwiràn xeruwez her ma'e i'u re nehe. Aze pezapo nezewe haw nehe, pemàno putar nehe. Pezuapyapyr paw weruzar putar ko heze'eg a'e wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Pekwaw herenataromo imukatu pyrer nehe. Pekwaw herenataromo imukatu pyrer 'ym nehe no. Pekwaw herenataromo ikatu ma'e nehe. Pekwaw herenataromo ikatu 'ym ma'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ihe Tupàn Tuweharupi Wiko Ma'e ihe. Amume'u heze'eg paw Moizez pe. Pemu'e Izaew a'e ze'eg rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Na'e Moizez uze'eg Àràw pe kury, ta'yr Ereazar pe no, ta'yr Itamar pe no. A'e mokoz Àràw ta'yr wikuwe a'e wà. — Pepyhyk arozràn imuku'i pyrer ikurer nehe, temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyrer ikurer nehe. Pema'ema'e typy'ak imuapiruru kar pyr 'ym romo iapo pà nehe. Pe'u a'e typy'ak ma'ea'yr hapy haw huwake nehe, ta'e Tupàn henataromo imukatu pyrer romo hekon a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Pe'u a'e typy'ak amo ywy pehegwer Tupàn henataromo imukatu pyrer rehe nehe. Ta'e peiko a'e temi'u Tupàn pe imono pyr ikurer izar romo pe xe. Pena'yr wiko izar romo wà no. Tupàn Tuweharupi Wiko Ma'e uzapo kar ko ma'e ihewe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pe nehe, peànàm wà nehe no, pepuner ma'ea'yr pehegwer Tupàn Tuweharupi Wiko Ma'e pe imono pyr ikatuahy ma'e pehegwer i'u haw rehe nehe: ipuxi'a kwer, henugupy kwer no. Peiko a'e Tupàn imuawyze kar haw ikurer izar romo pe xe. Pena'yr wiko izar romo wà no. Pe'u a'e ma'e ywy pehegwer Tupàn henataromo imukatu pyrer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Izaew werur putar ma'ea'yr ipehegwer Tupàn pe ikatuahy ma'e romo wà nehe: henugupy, ipuxi'a. Xaxeto wapy putar ikawer Tupàn Tuweharupi Wiko Ma'e pe imono pyr ikatuahy ma'e romo wà nehe. A'e 'ar mehe Izaew werur putar a'e ipehegwer wà nehe. Peiko a'e ma'ea'yr ipehegwer izar romo. Pezuapyapyr paw wiko putar izar romo, tuweharupi wà nehe no. Tupàn Tuweharupi Wiko Ma'e umume'u kar izar romo peneko haw a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Na'e Moizez upuranu wanehe kury. — Ma'e pe àràpuhàrànete awa izuka pyràm katu 'ygwer imunàn kar haw romo har hekon a'e, i'i wanupe. — Ukaz paw kwez kury, i'i izupe wà. A'e rupi wikwahy Ereazar pe Itamar pe kury, wanehe upuranu pà kury. ");
INSERT INTO gubBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","— Màràzàwe tuwe nape'u kwaw katu 'ygwer imunàn kar haw ywy pehegwer Tupàn henataromo imukatu pyrer rehe. Izupe imono pyr ikatuahy ma'e romo a'e. Tupàn Tuweharupi Wiko Ma'e umur peme a'e. — Pezuka herenataromo teko wanemiapo kwer ikatu 'ym ma'e imunàn kar pà ihewe, i'i Tupàn peme. ");
INSERT INTO gubBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Naperaha kwaw ma'ea'yr huwykwer tàpuzràn Tupàn pe imonokatu pyrer pupe. Aze mo pe'u ho'o kwer a'e pe, ikatu mo. Ta'e azapo kar nezewe haw peme ihe xe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Uwazar Àràw ize'eg izupe. — Teko omono ma'e imono pyr Tupàn Tuweharupi Wiko Ma'e pe kutàri a'e wà, izupe katu 'ygwer imunàn kar haw romo a'e wà. Omono imono pyr hapy pyràm izupe wà no. Nezewe rehe we uzeapo agwer iaiw ma'e ihewe. Aze mo a'u katu 'ygwer imunànaw kutàri, aipo ikatu mo Tupàn Tuweharupi Wiko Ma'e pe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Àràw hemiwazar kwer ikatu Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg Moizez pe Àràw pe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","— Tuwe Izaew weruzar ko heze'eg wà nehe, i'i wanupe. Pepuner wyzài ma'ea'yr ho'o kwer i'u haw rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","aze ipyàpe uza'ak mokoz ma'e romo nehe, aze u'u ka'api'i nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Napepuner kwaw 'aw ma'ea'yr i'u haw rehe nehe: kawaru kupewa'a, tapixi hehaite ma'e, tapixihu. Agwer ma'ea'yr u'u ka'api'i wà. Wapyàpe nuza'ak kwaw mokoz romo wà. Agwer ma'ea'yr na'ikatu kwaw peme wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Pe'u zo tàzàhuràn ho'o kwer nehe. Ho'o kwer na'ikatu kwaw peme. Ipyàpe uza'ak zepe mokoz romo. Nu'u kwaw ka'api'i wà no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Pe'u zo agwer ma'ea'yr pe wà nehe. Pepokok zo wanehe wamàno re nehe. Paw rupi na'ikatu kwaw Tupàn henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Pepuner wyzài pira i'u haw rehe nehe, aze heta ipeporàna'i izupe nehe, aze heta ipekwer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Aze amo ma'e wiko 'y pupe nehe, aze naheta kwaw ipeporàna'i izupe nehe, aze naheta kwaw ipekwer izupe nehe, pe'u zo nehe. Agwer ma'ea'yr na'ikatu kwaw peme wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Pe'u zo pe wà nehe. Aze umàno nehe, pepokok zo hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Wyzài ma'ea'yr 'y pe har na'ikatu kwaw a'e nehe, aze naheta kwaw ipeporàna'i izupe nehe, aze naheta kwaw ipekwer izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Agwer wiràmiri na'ikatu kwaw Tupàn pe penemi'u romo wà no: wiràhu, apitaw, wiràhu yryhu pe har, ");
INSERT INTO gubBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","wiràmiri axor her ma'e, ");
INSERT INTO gubBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","zàpuun, ");
INSERT INTO gubBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","wiranu, pypy, wiràmiri yryhu pe har kaiwot her ma'e, kàkà, ");
INSERT INTO gubBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kawyre, zàpuun yryhu pe har, hokohu, ");
INSERT INTO gubBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ake'e, wapehok zàwenugar ixihu ma'e, uruhu, ");
INSERT INTO gubBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","hoko kàwànà her ma'e, hokoxig, zàpuun ikupewyahy ma'e. Pe'u zo anyra nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","6 hetymà hereko har wata ma'e wà, 6 hetymà hereko har uwewe ma'e wà no, paw rupi na'ikatu kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pepuner 6 hetymà hereko har opoopor ma'e i'u haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pepuner wyzài tukur i'u haw rehe. Pepuner wyzài ykyzu i'u haw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Amogwer 6 hetymà hereko har wata ma'e uwewe ma'e na'ikatu kwaw Tupàn henataromo penemi'u romo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Aze agwer ma'ea'yr umàno nehe, aze amo opokok hehe nehe, wiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe. Xo kwarahy heixe re zo ikatu wi putar nehe. Na'aw a'e ma'ea'yr waner xe wà: ma'ea'yr ipyàpe ma'e aze ipyàpe nuza'ak kwaw mokoz haw nehe, aze nu'u kwaw ka'api'i no, wyzài ma'ea'yr 4 py hereko har upy pyte rehe wata ma'e no. Aze amo opokok wyzài agwer ma'ea'yr hetekwer rehe nehe, uhez putar uma'e wetekwer rehe har nehe. Wiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe, te kwarahy heixe mehe nehe. A'e mehe ikatu wi putar nehe. Agwer ma'ea'yr na'ikatu kwaw peme wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Agwer ma'ea'yr ywy rehe upuze ma'e na'ikatu kwaw peme penemi'u romo wà: tezuhu hexakaw nànànar wà, tezua'i hexakaw nànànar wà, aguza, tezu ywygaw pe har, kàmàriàw. ");
INSERT INTO gubBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Aze amo opokok agwer ma'ea'yr rehe wamàno re nehe, wiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe. Xo kwarahy heixe re zo ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Aze agwer ma'ea'yr hetekwer u'ar amo ma'e i'aromo nehe, a'e ma'e uzeapo putar ikatu 'ym ma'e romo a'e 'ar mehe nehe. Wyzài ma'e nehe: ywyra iapo pyrer, pàn iapo pyrer, ma'epirer iapo pyrer, ma'eryru iapo pyrer, wyzài ma'e. Tuwe amo omono 'y pupe imukatu pà nehe. Nezewe rehe we upyta putar ikatu 'ym ma'e romo a'e 'ar rehe nehe. Xo kwarahy heixe re zo ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Aze amo agwer hetekwer u'ar ywy'a pupe nehe, ipupe har uzeapo putar ikatu 'ym ma'e romo a'e 'ar mehe we nehe. Tuwe uka a'e ywy'a wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Aze 'y a'e ywy'a pupe har u'ar wyzài temi'u rehe nehe, a'e temi'u uzeapo putar ikatu 'ym ma'e romo nehe. Wyzài 'y zàwenugar a'e ywy'a pupe har uzeapo putar ikatu 'ym ma'e romo a'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Aze agwer ma'ea'yr hetekwer u'ar amo ma'e rehe nehe, a'e ma'e uzeapo putar ikatu 'ym ma'e romo a'e nehe. Aze u'ar amo zepehe rehe nehe, amo tata henaw rehe nehe, a'e ma'e uzeapo putar ikatu 'ym ma'e romo a'e nehe. Tuwe ukauka wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Aze agwer ma'e u'ar amo 'yzygwar pupe nehe, amo 'yryru pupe nehe, 'y a'e pe har ikatu wiwi nehe. Nezewe rehe we hetekwer rehe opokok ma'e kwer wiko putar ikatu 'ym ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Aze agwer ma'ea'yr hetekwer u'ar ma'eà'yz itym pyràm rehe nehe, ikatu wiwi putar ma'eà'yz nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Aze ma'eà'yz 'y pupe upyta nehe, aze hetekwer u'ar 'y pupe nehe, ma'eà'yz uzeapo putar ikatu 'ym ma'e romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Aze amo ma'ea'yr temi'u romo ikatu ma'e umàno e nehe, hetekwer rehe opokok ma'e wiko putar ikatu 'ym ma'e romo a'e nehe. Kwarahy heixe re zo ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Aze amo u'u ho'o kwer nehe, tuwe uhez uma'e wetekwer rehe imunehew pyrer nehe. Wiko putar ikatu 'ym ma'e romo a'e 'ar mehe nehe. Kwarahy heixe re zo ikatu wi putar nehe. Aze amo upir hetekwer heraha pà nehe, tuwe uhez uma'e nehe. Wiko putar ikatu 'ym ma'e romo a'e nehe. Kwarahy heixe re zo ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Pe'u zo ma'ea'yr ywy rehe upuze ma'e nehe. Agwer ma'ea'yr na'ikatu kwaw Tupàn henataromo penemi'u romo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Pe'u zo ma'ea'yr ywy rehe upuze ma'e nehe. Aze 4 upy rehe wata wà nehe, nezewe rehe we nape'u kwaw nehe. Aze heta wera'u wapy 4 py wi nehe, pe'u zo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Peiko zo ikatu 'ym ma'e Tupàn henataromo nehe, agwer ma'ea'yr i'u pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Pezemonokatu ihewe no. Aiko pezar romo ihe. Hereruzar katu pe nehe. Ta'e aiko ikatuahy ma'e romo ihe xe. Peiko zo ikatu 'ym ma'e romo wyzài ma'ea'yr ywy rehe upuze ma'e i'u pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Aiko Tupàn Tuweharupi Wiko Ma'e romo Ezit ywy wi penerur arer romo ihe. Ta'e hereko wer pezar romo ihe xe. A'e rupi peiko ikatu ma'e romo nehe, ta'e aiko ikatuahy ma'e romo ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Amume'u Tupàn ze'eg kwez xe peme ihe: ma'ea'yr wanehe har, wiràmiri wanehe har, ma'ea'yr 'y pe har wanehe har, ma'ea'yr ywy rehe upuze ma'e wanehe har. ");
INSERT INTO gubBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","A'e ze'eg wexak kar ikatu ma'e ikatu haw. Wexak kar ikatu 'ym ma'e ikatu 'ymaw no. Umume'u ma'ea'yr i'u pyràm peme wà. Umume'u ma'ea'yr i'u pyr 'ym peme wà no. ");
INSERT INTO gubBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Tupàn Tuweharupi Wiko Ma'e omono ko ze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","— Emume'u ko heze'eg Izaew wanupe nehe, i'i izupe. — Aze kuzà imemyr awa uzexak kar nehe, umumaw putar 7 'ar ikatu 'ym ma'e romo Tupàn henataromo wiko pà nehe. Nezewegatete uwy haw 'ar rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","8 haw 'ar rehe xaxeto omonohok putar kwarera'i ipirera'i izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","A'e re, huwykwer heityk awer rehe nehe, umumaw putar amo 33 'ar ikatu 'ym ma'e romo wiko pà nehe no. A'e 'ar rehe nupuner kwaw Tupàn pe imonokatu pyrer rehe opokokaw rehe nehe. Nupuner kwaw tàpuzràn Tupàn pe imonokatu pyrer pe oho haw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Aze uzexak kar imemyr kuzà nehe, kuzà umumaw putar 14 'ar ikatu 'ym ma'e romo wiko pà Tupàn henataromo nehe. Nezewegatete uwy haw 'ar rehe nehe no. A'e re, huwykwer heityk awer rehe nehe, umumaw putar amo 66 'ar ikatu 'ym ma'e romo wiko pà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","A'e zemukatu haw 'ar pawire, awa izexak kar ire nehe, aze ru'u kuzà izexak kar ire nehe, kuzà oho putar tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. Omono putar àràpuhàràna'yr hawitu ma'e pitài kwarahy hereko har xaxeto pe nehe. Xaxeto wapy putar Tupàn henataromo nehe. Ukaz paw putar nehe. Omono putar pykahu izupe nehe, aze ru'u omono putar pyku'i izupe nehe, katu 'ygwer imunàn kar haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Xaxeto omono putar a'e ma'e Tupàn Tuweharupi Wiko Ma'e pe nehe, kuzà hemiapo kwer ikatu 'ymaw imunàn kar pà izupe nehe. Nezewe mehe kuzà ikatu wi putar henataromo nehe. Amumaw Tupàn ze'eg kuzà imemyrzexak kar ma'e kwer rehe har imume'u haw kwez xe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Aze naheta kwaw temetarer izupe nehe, aze nupuner kwaw àràpuhàràna'yr imono haw nehe, kuzà weraha putar amo ma'e xaxeto pe nehe: mokoz pykahu wà, aze ru'u, mokoz pyku'i wà. Pitài wiràmiri wiko putar ma'e Tupàn pe imono pyr ukaz paw ma'e romo nehe. Inugwer wiko putar katu 'ygwer imunàn kar haw romo nehe. A'e ma'e izuka mehe xaxeto umunàn kar putar kuzà hemiapo kwer ikatu 'ym ma'e Tupàn pe nehe. Ikatu wi putar nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Tupàn Tuweharupi Wiko Ma'e omono 'aw uze'eg Moizez pe kury, Àràw pe no. ");
INSERT INTO gubBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Aze amo teko heta ima'eahy haw ipir rehe nehe: hezunaw, aze ru'u tezunaw, aze ru'u pinimaw amo wanupe imono pyràm, tuwe amo weraha a'e ima'eahy ma'e xaxeto Àràw pe nehe, aze ru'u amo xaxeto Àràw ta'yr pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Xaxeto ume'e putar ipir rehe nehe. Aze haw ipinimaw rehe har ixig nehe, aze iperew oho ete ipir rehe nehe, a'e mehe ma'eahy haw amo wanupe imono pyràm romo a'e. — Nepir na'ikatu kwaw Tupàn henataromo, i'i putar xaxeto a'e teko pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Aze ipinimaw xig nehe, aze haw iperew rehe har noho ete kwaw ipir rehe nehe, a'e mehe xaxeto umumaw kar putar 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","7 haw 'ar mehe xaxeto ume'e wi putar hehe nehe. Aze iperew nuhàz kwaw nehe, aze uzezuwàgatu nehe, a'e mehe umumaw kar putar amo 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","7 haw 'ar mehe xaxeto ume'e wi putar hehe nehe. Aze iperew ipixika'i wera'i nehe, aze nuhàz kwaw ipir rehe nehe, a'e mehe tezunaw iaiw 'ym ma'e a'e. Iperew ma'e uhez putar uma'e wemimunehew nehe. — Nekatu kury, i'i putar xaxeto izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Aze a'e re iperew uhàz wi hehe nehe, a'e mehe iperew ma'e oho wi putar xaxeto pe uze'eg pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ume'e putar hehe nehe. Aze iperew uhàz nehe, — Ikatu 'ym ma'e romo ereiko Tupàn henataromo, i'i putar xaxeto izupe nehe. — Erereko ma'eahy haw purupe imono pyràm ne, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Aze amo wereko ma'eahy haw purupe imuhàz pyràm nehe, tuwe teko weraha xaxeto pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Xaxeto ume'e putar hehe nehe. Aze heta tezunaw xig ma'e ipir rehe nehe, aze haw hehe har xig a'e nehe no, aze iperew uzepupeka a'e pe nehe no, ");
INSERT INTO gubBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","a'e mehe — Ma'eahy haw purupe uhàz ma'e ràm tàtà ma'e, i'i putar xaxeto izupe nehe. — Ikatu 'ym ma'e romo ereiko Tupàn henataromo, i'i putar xaxeto izupe nehe. Numupyta kar kwaw a'e zutyka'i nehe. Ta'e wyzài teko ukwaw putar ikatu 'ymaw a'e wà nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","— Nema'eahy haw uhàuhàz neretekwer nànàn a'e, neàkàg wi nepy pe a'e, aze i'i izupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","a'e mehe ume'e putar ima'eahy ma'e rehe nehe. Aze uhàuhàz hetekwer nànàn azeharomoete nehe, aze ipir xig nehe a'e mehe a'e teko wiko ikatu ma'e romo a'e nehe. — Nekatu, i'i putar xaxeto izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Aze uzekwa iperew izepupeka nehe, na'ikatu kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Xaxeto ume'e wi putar hehe nehe. Aze wexak iperew izepupeka haw nehe, — Ikatu 'ym ma'e, i'i putar izupe nehe. Perew uzepupeka ma'e wexak kar ma'eahy haw purupe uhàz ma'e ràm zanewe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Iperew ikatu mehe xig mehe nehe, ima'eahy ma'e uzexak kar wi putar xaxeto pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Xaxeto ume'e wi putar hehe nehe. Aze iperew xig nehe, — Ikatu kury, i'i putar xaxeto izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Aze heta amo tezunaw ipewer ma'e ike'e ma'e kwer nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","aze hezun a'e pe nehe, aze ixig nehe, aze ru'u pinimaw ipiràg ma'e uzekwa a'e pe nehe, ima'eahy ma'e uzexak kar putar xaxeto pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ume'e putar hehe nehe. Aze iperew oho ete wera'u ipir wi nehe, aze haw a'e pe har xigaw nehe, a'e mehe — Ikatu 'ym ma'e, i'i putar xaxeto izupe nehe. — Ma'eahy haw purupe uhàz ma'e ràm tezunaw ipewer ma'e pe uzypyrog ma'e kwer a'e, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Aze haw xigaw nehe, aze iperew noho ete wera'u kwaw ipir wi nehe, aze xig nehe, a'e mehe umumaw kar putar 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Aze uhàz ipinimaw hehe nehe, ma'eahy haw purupe uhàz ma'e ràm romo a'e nehe. — Ikatu 'ym ma'e, i'i putar xaxeto izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Aze ipinimaw nuhàz kwaw nehe, aze upyta uzezàwe nehe, a'e mehe tezunaw ipewer ma'e wezar wenawer nepir rehe a'e, i'i putar xaxeto izupe nehe. — Nekatu kury, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Aze tata wapy amo nehe, aze ikaz tawer pe iperew ipiràg nehe, aze ru'u xig nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","xaxeto ume'e putar ipinimaw rehe nehe. Aze haw a'e pe har xigaw nehe, aze iperew oho ete wera'u ipir wi nehe, a'e mehe — Ma'eahy haw purupe uhàz ma'e ràm, i'i putar xaxeto izupe nehe. — Ikatu 'ym ma'e romo ereiko ne, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Hehe ime'e mehe nehe, aze nuexak kwaw haw xig ma'e nehe, aze iperew noho ete wera'u kwaw ipir wi nehe, aze ixig wewer nehe, a'e mehe xaxeto umumaw kar putar 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","7 haw 'ar mehe xaxeto ume'e wi putar hehe nehe. Aze ipinimaw uhàz nehe, a'e mehe — Ma'eahy purupe uhàz ma'e ràm, i'i putar izupe nehe. — Ikatu 'ym ma'e romo ereiko ne, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Aze ipinimaw nuhàz kwaw nehe, aze upyta uzezàwegatu nehe, aze uzekwa katu nehe, a'e mehe ikaz tawer hemimuezun kwer romo a'e nehe. — Nekatu kury, i'i putar xaxeto izupe nehe. Ta'e ikaz tawer tup awer kwer romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Awa nehe, kuzà nehe no, aze iperew iàkàg rehe nehe, aze ru'u hazyw rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","xaxeto ume'e putar ipir rehe nehe. Aze iperew oho ete wera'u ipir wi nehe, aze i'aw a'e pe har naheta tetea'u kwaw nehe, aze ru'u izu nehe, a'e mehe — Ma'eahy haw purupe uhàz ma'e ràm, i'i putar xaxeto izupe nehe. — Ikatu 'ym ma'e romo ereiko ne, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Aze iperew noho ete wera'u kwaw ipir wi nehe, aze naheta kwaw i'aw ipihun ma'e hehe nehe, a'e mehe umumaw kar putar 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","7 haw 'ar mehe xaxeto ume'e wi putar hehe nehe. Aze ima'eahy haw nuhàz kwaw hehe nehe, aze naheta kwaw i'aw izu ma'e hehe nehe, aze iperew noho ete wera'u kwaw ipir wi nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","a'e mehe a'e teko upin putar wàkàg nehe, aze ru'u upin putar wazyw nehe, u'aw iperew rehe har imonohok 'ym pà nehe. Xaxeto umumaw kar putar 7 'ar izupe a'e zutyka'i imuigo kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","7 haw 'ar mehe ume'e wi putar ipir rehe nehe. Aze ima'eahy haw nuhàz kwaw nehe, aze noho ete wera'u kwaw ipir wi nehe, a'e mehe — Ikatu ma'e, i'i putar xaxeto izupe nehe. Uhez putar uma'e wemimunehew nehe. Ikatu ma'e romo wiko putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nezewe rehe we nehe, aze a'e re ima'eahy haw uhàz nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Xaxeto ume'e putar ima'eahy ma'e rehe nehe. Aze uhàz azeharomoete nehe, nuekar kwaw i'aw izu ma'e nehe. — Ikatu 'ym ma'e, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","— Nuhàz kwaw, aze i'i xaxeto nehe, aze i'aw ipihun a'e pe nehe, a'e mehe uke'e iperew a'e. — Ikatu kury, i'i putar xaxeto izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Awa nehe, kuzà nehe, aze heta pinimaw xig ma'e ipir rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","xaxeto ume'e putar hehe nehe. Aze ipinimaw xig wewer nehe, nan kwaw ma'eahy haw tàtà ma'e romo nehe. A'e teko ikatu. ");
INSERT INTO gubBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Aze awa i'aw uhem iàkàgape wi nehe, aze ru'u henataromo har wà nehe, àkàg ipin pyrer ma'e romo wiko putar nehe. Nezewe rehe we nuiko kwaw ikatu 'ym ma'e romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Aze ipir iàkàg rehe har i'aw 'ym ma'e rehe umuzekwa kar amo pinimaw ipiràg wewer ma'e nehe, ima'eahy haw purupe uhàz ma'e ràm wereko a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Xaxeto ume'e putar awa rehe nehe. Aze pinimaw ipiràg wewer ma'e wexak nehe, teko wapir rehe uzekwa kar ma'e zàwenugar nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ima'eahy haw purupe uhàz ma'e ràm wereko a'e. — Tupàn henataromo ikatu 'ym ma'e, i'i putar xaxeto izupe nehe. Ta'e heta ma'eahy haw iàkàg rehe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Aze teko wereko ma'eahy haw purupe uhàz ma'e ràm upir rehe nehe, tuwe umunehew ma'e imu'i pyrer nehe. Tuwe numuguz kwaw u'aw nehe. Tuwe upyk uwa uzuru iwy pe nehe, uhapukaz pà nehe. — Ikatu 'ym ma'e romo aiko ihe, tuwe i'i oho iko nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ma'eahy purupe uhàz ma'e ràm hereko mehe we a'e teko wiko wiwi putar ikatu 'ym ma'e romo nehe. Tuwe wiko a'e zutyka'i wàpuz me nehe, amogwer waneko awer wi muite nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Aze uzekwa kar hàwe ma'e ma'ea'yr hawer iapo pyrer rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","aze ru'u irin iapo pyrer rehe nehe, aze ru'u pàn irin iapo pyrer rehe nehe, aze ru'u pàn ma'ea'yr hawer iapo pyrer rehe nehe, aze ru'u ma'e pirer pehegwer rehe nehe, aze ru'u ma'e amo ma'e pirer iapo pyrer rehe nehe, aze ipinimaw ka'a zàwe wewer nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","aze ru'u ipiràg wewer nehe, a'e mehe hàwe a'e. Pexak kar xaxeto pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Xaxeto ume'e putar a'e ma'e rehe nehe. Omono putar a'e zutyka'i nehe. Umumaw 7 'ar nezewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","7 haw 'ar mehe ume'e putar ipinimaw rehe nehe. Aze uhàz nehe, a'e mehe hàwe haw upuner purupe uhàz haw rehe nehe. A'e rupi — Ikatu 'ym ma'e, i'i putar xaxeto a'e ma'e pe nehe: ma'e ma'ea'yr hawer iapo pyrer, irin iapo pyrer, pàn irin iapo pyrer, pàn ma'ea'yr hawer iapo pyrer, ma'e pirer pehegwer, ma'e amo pirer iapo pyrer. ");
INSERT INTO gubBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Xaxeto wapy putar a'e ma'e nehe, ta'e heta hàwe haw purupe uhàz ma'e ràm hehe xe. A'e rupi, tuwe umumaw tata pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Xaxeto ume'e putar a'e ma'e rehe nehe: ma'e, pàn, ma'e amo pirer iapo pyrer. Aze ipinimaw nuhàz kwaw nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","a'e mehe uhez kar putar a'e ma'e amo pe nehe. Na'e omono putar a'e zutyka'i nehe. Umumaw putar 7 'ar nezewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Na'e ume'e wi putar hehe nehe. Aze ipinimaw naheta kwaw amo ae hexakaw nehe, aze nuhàz kwaw nehe, nezewe rehe we na'ikatu kwaw nehe. Wapy putar tata pupe nehe. Ta'e heta hàwe haw purupe uhàz ma'e ràm hehe xe, ipehegwer henataromo har rehe nehe, aze ru'u ikupe pe har rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Hehe ime'e mehe nehe, aze heta amo ae hexakaw ipinimaw rehe uhez re nehe, a'e mehe xaxeto umu'i putar a'e ipehegwer nehe: ma'e, ma'epirer, pàn. ");
INSERT INTO gubBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Nezewe rehe we aze a'e re hàwe haw uzekwa wi nehe, a'e mehe — Purupe uhàz ma'e ràm, i'i putar xaxeto izupe nehe. Wapy putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Aze uhez nehe, aze a'e re ipinimaw ukàzym nehe, a'e mehe uhez wi putar nehe. A'e mehe ikatu putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Amumaw Tupàn ze'eg hàwe haw rehe har imume'u haw kwez xe ihe: ma'e ma'ea'yr hawer iapo pyrer rehe har, irin iapo pyrer rehe har, pàn rehe har, ma'e amo ipirer iapo pyrer rehe har. Nezewe mehe — Ikatu ma'e, upuner putar izupe u'e haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg ");
INSERT INTO gubBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","teko ima'eahy haw ipir rehe har purupe uhàz ma'e ràm wi uzemukatu haw rehe har a'e, Moizez pe a'e. Tuwe amo weraha ima'eahy ma'e xaxeto pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Na'e xaxeto weraha putar ima'eahy ma'e teko waneko awer wi nehe, hehe ume'e pà nehe. Aze wexak ikatu haw nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","xaxeto werur kar putar ma'e izupe nehe: mokoz wiràmiri ikatuahy ma'e wà, ywyràkàxigyw ipehegwer, àràpuhàràn hawer imupiràg pyrer, pitài ka'akyr ixop her ma'e hàkàgwer. ");
INSERT INTO gubBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Xaxeto uzuka kar putar pitài wiràmiri izupe nehe, ywy'a 'y 'yzygwar wi henuhem pyrer pupe tynehem ma'e i'aromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Na'e upyhyk putar amogwer ma'e nehe: inugwer wiràmiri, ywyràkàxigyw ipehegwer, àràpuhàràn hawer imupiràg pyrer, ixop. Umuàkym putar wiràmiri izuka pyrer huwykwer pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Na'e umupiripirik putar huwykwer awa imukatu pyr rehe 7 haw nehe. — Nekatu kury, i'i putar izupe nehe. A'e re xaxeto umuhem kar wiràmiri wikuwe ma'e kaiwer pe nehe, imuwewe kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Na'e awa uhez putar uma'e wemimunehew nehe. Upin putar u'aw paw nehe. Upin putar wawer haw paw nehe no. Na'e uzahak putar nehe. A'e mehe ikatu putar Tupàn henataromo nehe. A'e re wixe putar teko waneko haw pe nehe. Tuwe umumaw 7 'ar katu pe wàpuz wi upyta pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","7 haw 'ar mehe uzepin wi putar nehe: wàkàg, wamutaw, wehàpykàraw, amo uwaw wetekwer rehe har paw. Uhez wi putar uma'e wemimunehew nehe. Uzahak wi putar nehe no. A'e mehe ikatu putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Iku'egwer pe upyhyk putar mokoz àràpuhàràna'yr hawitu ma'e awa ikatu 'ymaw hereko 'ymar wà nehe. Upyhyk putar pitài àràpuhàràna'yr kuzà ikatu 'ymaw hereko 'ymar nehe no. Werur putar 3 kir arozràn imuku'i pyrer uri kawer inuromo imupyràn pyrer nehe. Werur putar uri kawer zutahyky'a por ikurer nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Xaxeto weraha putar awa a'e nehe, Tupàn pe hemirur kwer nehe no, tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo ");
INSERT INTO gubBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","upyhyk putar a'e ma'e wà nehe: pitài àràpuhàràna'yr hawitu ma'e awa, uri kawer. Omono putar Tupàn Tuweharupi Wiko Ma'e pe ikatu 'ym ma'e iapo har romo teko haw imunàn kar pà izupe nehe, izupe imono pyr ikatuahy ma'e romo nehe. Xaxeto wiko putar a'e ma'e izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Xaxeto uzuka putar ma'ea'yr amo ywypehegwer Tupàn pe imukatu pyrer rehe nehe, ikatu 'ym ma'e iapo har romo teko haw imunàn kar haw romo nehe. Wapy putar ma'e henataromo a'e pe nehe no. Na'e xaxeto uzuka putar àràpuhàràna'yr awa a'e ywypehegwer rehe nehe kury. Uzapo putar nezewe haw nehe, ta'e imono pyr ikatu 'ym ma'e iapo har romo teko haw imunàn kar haw nuzawy kwaw imono pyr katu 'ygwer imunàn kar haw a'e xe. Ikatuahy Tupàn henataromo. Xaxeto wiko izar romo. ");
INSERT INTO gubBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Xaxeto upyhyk putar ma'ea'yr huwykwer ikurera'i nehe. Omono putar huwykwer awa imukatu pyr rehe nehe: inami awyze har iapyr, ikwàhu ipo awyze har rehe har rehe, ipyhàhu ipy awyze har rehe har rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Na'e uzakook putar uri kawer ikurer opo ahurehe har mytepe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Umuàkym putar ukwà opo awyze har rehe har uri kawer pupe nehe. Umupiripirik putar 7 haw a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A'e re omono putar uri kawer ikurera'i awa imukatu pyr rehe ukwà pupe nehe. Omono ma'ea'yr huwykwer hehe a'e 'ym mehe. Omono putar uri kawer hehe nezewegatete nehe no: inami awyze har iapyr, ukwàhu ipo awyze har rehe har rehe, upyhàhu awyze har rehe har rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Uzakook putar uri kawer ikurer awa iàkàg rehe nehe. Nezewe mehe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto umunàn kar putar hemiapo kwer ikatu 'ym ma'e Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","A'e re xaxeto omono putar Tupàn pe imono pyr katu 'ygwer imunàn kar haw izupe nehe, awa imukatu pyr hemiapo kwer ikatu 'ym ma'e imunàn kar pà izupe nehe. A'e re uzuka putar ma'ea'yr Tupàn henataromo ukaz paw ma'e ràm nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Omono putar ma'ea'yr hapy haw rehe arozràn imono pyr rehe we nehe. Nezewe mehe xaxeto umunàn kar putar 'aw awa hemiapo kwer ikatu 'ym ma'e Tupàn pe nehe. Ikatu putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Aze a'e awa nahemetarer katu kwaw nehe, aze nupuner kwaw a'e ma'e paw imekuzar haw rehe nehe, weraha putar àràpuhàràna'yr hawitu ma'e awa xaxeto pe nehe, katu 'ygwer imunàn kar haw romo nehe. Agwer imono pyr ikatuahy Tupàn Tuweharupi Wiko Ma'e pe. Xaxeto wiko izar romo. Xo pitài kir arozràn imuku'i pyrer uri kawer inuromo har zo weraha putar xaxeto pe nehe. Weraha putar uri kawer ikurer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Weraha putar mokoz pykahu wà nehe, aze ru'u mokoz pyku'i wà nehe, aze upuner nehe. Pitài wiràmiri wiko putar katu 'ygwer imunàn kar haw romo nehe. Inugwer wiko putar ma'e imono pyr ukaz paw ma'e ràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Imukatu haw rehe 8 haw 'ar mehe nehe, awa weraha putar a'e ma'e paw tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe, xaxeto pe imono pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Na'e a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto upyhyk putar àràpuhàràna'yr awa nehe. Upyhyk putar uri kawer nehe no. Omono putar Tupàn Tuweharupi Wiko Ma'e pe nehe. Ikatuahy a'e imono pyr Tupàn pe. Xaxeto wiko izar romo. ");
INSERT INTO gubBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Na'e uzuka putar àràpuhàràna'yr awa nehe. Upyhyk putar huwykwer ikurera'i nehe, awa imukatu pyr rehe imono pà nezewe nehe: inami awyze har iapyr, ikwàhu ipo awyze har rehe har rehe, ipyhàhu ipy awyze har rehe har rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Na'e uzakook putar uri kawer ikurer opo ahurehe har pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ukwà opo awyze har rehe har umupiripirik putar uri kawer 7 haw a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Na'e omono putar uri kawer ikurera'i awa imukatu pyr rehe ma'ea'yr huwykwer imono awer rehe katete nehe: inami awyze har iapyr, ikwàhu ipo awyze har rehe har rehe, ipyhàhu ipy awyze har rehe har rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Uzakook putar uri kawer ikurer awa iàkàg rehe nehe. Nezewe mehe Tupàn Tuweharupi Wiko Ma'e henataromo umunàn kar putar hemiapo kwer ikatu 'ym ma'e izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","A'e re aze awa upuner nehe, xaxeto omono putar mokoz pyku'i wà nehe, aze ru'u mokoz pykahu wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Pitài wiràmiri wiko putar katu 'ygwer imunàn kar haw romo nehe. Inugwer wiko putar ma'e imono pyr ukaz paw ma'e ràm romo nehe. Nezewe mehe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto umunàn kar putar awa imukatu pyr hemiapo kwer ikatu 'ym ma'e izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Amumaw Tupàn ze'eg teko hemetarer 'ym ma'e ima'eahy haw ipir rehe har wi imukatu pyrer rehe har imume'u haw kwez xe ihe kury. Nupuner kwaw ma'e paw ime'eg kar haw rehe ize'eg rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg hàwe haw tàpuz me har rehe har Moizez pe Àràw pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","— Amono putar amo ywy Kànàà her ma'e teko Izaew wanupe ihe nehe. Hehe wixe re weruzar putar ko heze'eg a'e wà nehe, i'i Tupàn. Aze Tupàn umuhem kar hàwe haw amo hàpuz me nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","izar uze'eg putar oho xaxeto pe nehe. — Aexak hàwe haw heràpuz me ihe, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Hexak 'ym mehe we xaxeto wenuhem kar putar ma'e paw izupe hàpuz wi nehe. Aze nuwenuhem kwaw nehe, — Ikatu 'ym ma'e, i'i putar tàpuz me har nànàn pe wà nehe. Na'e xaxeto oho putar hàpuz me nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","38","Ume'e putar hàwe haw rehe nehe. Aze ipinimaw ywyok rehe har ka'a zàwe wewer nehe, aze ru'u ipiràg wewer nehe, aze nuzawy kwaw ywyok pupe wixe ma'e nehe, a'e mehe xaxeto uhem putar hàpuz wi nehe. Uwàpytym putar hàpuz nehe. Umumaw putar 7 'ar nezewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","7 haw 'ar mehe uzewyr putar hàpuz me hehe ume'e wi pà nehe. Aze ipinimaw uhàuhàz ywyok rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","wenuhem kar putar ita hàwe hereko har nehe. — Peraha tawhu wi heityk pà nehe, ywypehegwer ikatu 'ym ma'e rehe nehe, i'i putar wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ukytykytyk kar putar ywyok hàpuz pupe har nehe. Izar weraha putar ipykaw imuhem kar pyrer tawhu wi ywypehegwer ikatu 'ym ma'e pe heityk pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na'e omono putar ita pyahu ita hàwe ma'e hekuzaromo nehe. Upyk wi putar ywyzuwa pupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","A'e ma'e paw iapo re nehe, aze uzekwa wi hàwe haw a'e pe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Xaxeto ume'e wi putar hehe nehe. Aze ipinimaw uhàuhàz ywyok rehe nehe, — Purupe uhàz ma'e ràm, i'i putar xaxeto izupe nehe. A'e rupi tàpuz na'ikatu kwaw. ");
INSERT INTO gubBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Weityk putar nehe. Weraha putar hehe arer paw tawhu wi ywypehegwer ikatu 'ym ma'e pe wà nehe: ita, ywyra, ywyok ipykaw. ");
INSERT INTO gubBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Aze uwàpytym tàpuz ikatu 'ymaw wi wà nehe, aze amo wixe ipupe a'e 7 'ar rehe nehe, wiko putar ikatu 'ym ma'e Tupàn henataromo nehe. Xo kwarahy heixe mehe zo ikatu wi putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Aze a'e 'ar rehe amo uzeàpàrirog ipupe nehe, aze ru'u umai'u ipupe nehe, tuwe uhez uma'e wemimunehew nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Aze xaxeto uzewyr tàpuz rehe ume'e pà ywyok ipyk wi re nehe, aze naheta kwaw hàwe haw ywyok rehe nehe, — Ikatu, i'i putar izupe nehe. Ta'e hàwe haw ukàzym izuwi azeharomoete xe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Xaxeto umukatu putar hàpuz Tupàn henataromo nezewe nehe. Upyhyk putar amo ma'e nehe: mokoz wiràmiri wà, ywyràkàxigyw hàkàgwer, àràpuhàràn hawitu ma'e hawer imupiràg pyrer, ka'akyr ixop her ma'e hàkàgwer. ");
INSERT INTO gubBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Uzuka putar pitài wiràmiri ywy'a 'y 'yzygwar wi henuhem pyrer pupe tynehem ma'e i'aromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Na'e upyhyk wi putar a'e ma'e nehe: inugwer wiràmiri, ywyràkàxigyw hàkàgwer, àràpuhàràn hawer imupiràg pyrer, ka'akyr ixop her ma'e hàkàgwer. Na'e omono putar a'e ma'e paw wiràmiri izuka pyrer huwykwer pupe nehe. A'e re omono putar 'y henuhem romo pyrer pupe nehe no. Na'e umupiripirik tàpuz rehe 7 haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Nezewe mehe umukatu putar tàpuz a'e ma'e pupe nehe: wiràmiri huwykwer, 'y henuhem romo pyrer, wiràmiri wikuwe ma'e, ywyràkàxigyw hàkàgwer, ka'akyr ixop her ma'e hàkàgwer, àràpuhàràn hawer imupiràg pyrer. ");
INSERT INTO gubBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Na'e weraha putar wiràmiri wikuwe ma'e tawhu wi nehe, kaiwer pe imuhem kar pà nehe. Nezewe xaxeto uzapo putar tàpuz imukatu haw nehe. Ikatu putar nezewe mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","Na'aw Tupàn ze'eg teko ma'eahy haw rehe har xe kury: ipir rehe har, iàkàg rehe har, tezunaw, pir rehe pinimaw, hàwe haw kamir rehe har, hàwe haw tàpuz rehe har. ");
INSERT INTO gubBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Aze teko weruzar ko ze'eg wà nehe, ukwaw putar ikatu ma'e ikatu haw wà nehe. Ukwaw putar ikatu 'ym ma'e ikatu 'ymaw wà nehe no. Tupàn umume'u uze'eg a'e ma'e paw rehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg Moizez pe, Àràw pe no. — Emume'u ko heze'eg ");
INSERT INTO gubBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","teko Izaew izuapyapyr wanupe nehe, i'i wanupe. Aze uhem ipewer amo awa ima'e wi nehe, ikatu 'ym ma'e romo hekon putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Aze uhem izuwi nehe, aze ru'u upyta hehe nehe, nezewe rehe we awa wiko putar ikatu 'ym ma'e romo henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Aze u'aw wyzài u'apaw rehe nehe, tupaw uzeapo putar ikatu 'ym ma'e romo nehe. Aze wapyk wyzài tenaw rehe nehe, tenaw uzeapo putar ikatu 'ym ma'e romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Aze amo opokok hupaw rehe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","aze ru'u wapyk hen awer rehe nehe, a'e teko uhez putar uma'e wemimunehew nehe. Uzahak putar nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe mehe zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Aze amo opokok a'e awa rehe nehe, tuwe uhem uma'e wemimunehew nehe. Uzahak putar nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe mehe zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Aze awa upewer uzewi uhem ma'e hereko har uzenymon amo teko Tupàn henataromo ikatu ma'e rehe nehe, tuwe a'e teko uhez uma'e wemimunehew nehe. Tuwe uzahak nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe mehe zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Aze a'e awa wapyk amo kawaru ikupe pe har rehe nehe no, a'e kawaru ipupe pe har uzeapo putar Tupàn henataromo ikatu 'ym ma'e romo a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Aze wapyk amo ma'e rehe nehe, aze amo opokok iapyk awer rehe nehe, wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo ikatu wi putar nehe. Aze amo upyhyk iapyk awer nehe, tuwe uhez uma'e wemimunehew nehe. Tuwe uzahak nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe mehe zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Aze opokok amo teko rehe uzepuez 'ym mehe we nehe, a'e mehe a'e teko uhez putar uma'e wemimunehew nehe. Uzahak putar nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe mehe zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Aze upyhyk amo ywy'a nehe, pezuka a'e ywy'a nehe. Aze y'a ywyra iapo pyrer romo nehe, pezuhez katu nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ukatu re tuwe umumaw 7 'ar uzemukatu àwàm hàro pà nehe. A'e 'ar ipawire, a'e teko uhez putar uma'e wemimunehew nehe. Uzahak putar 'y 'yzygwar wi henuhem pyrer pupe nehe no. A'e mehe ikatu putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","8 haw 'ar mehe upyhyk putar mokoz pykahu wà nehe, aze ru'u mokoz pyku'i wà nehe. Oho putar tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo omono putar a'e mokoz wiràmiri xaxeto pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Xaxeto omono putar Tupàn pe imono pyr romo wà nehe. Pitài wiko putar katu 'ygwer imunàn kar haw romo nehe. Inugwer ukaz paw putar henataromo nehe. Nezewe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto uzapo putar awa imukatu haw no. Ikatu putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Aze uhem e ta'yrer awa wi nehe, tuwe uzahak nehe. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Aze u'ar ta'yrer wyzài kamir rehe wyzài ma'e rehe nehe, aze ru'u ma'epirer rehe nehe, tuwe uhez a'e ma'e nehe. Ikatu 'ym ma'e romo wiko putar Tupàn henataromo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Aze awa oho kuzà puhe nehe, tuwe uzahak wà nehe. Ikatu 'ym ma'e romo wiko putar Tupàn henataromo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Aze kuzà huwy haw uhem nehe, umumaw putar 7 'ar ikatu 'ym ma'e romo wiko pà Tupàn henataromo nehe. Aze amo opokok hehe a'e 'ar rehe nehe, wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Aze uzeàpàrirog amo tupaw rehe nehe, aze ru'u wapyk amo ma'e rehe nehe, a'e ma'e uzeapo putar ikatu 'ym ma'e romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Aze amo opokok hupawer rehe nehe, aze ru'u iapyk awer rehe nehe, uhez putar uma'e wemimunehew nehe, Uzahak putar nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Aze awa oho kuzà puhe huwy haw 'ar rehe nehe, umumaw putar 7 'ar Tupàn henataromo ikatu 'ym ma'e romo wiko pà nehe. Aze uzeàpàrirog wyzài tupaw rehe nehe, a'e tupaw uzeapo putar Tupàn henataromo ikatu 'ym ma'e romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Aze kuzà huwy e nehe, aze ru'u umumaw 'ar tetea'u uwy pà nehe, wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe, uwy haw 'ar rehe har zàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Aze uzeàpàrirog amo tupaw rehe nehe, aze ru'u wapyk amo ma'e rehe nehe, a'e ma'e uzeapo putar ikatu 'ym ma'e romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Aze amo opokok hupawer rehe nehe, aze ru'u iapyk awer rehe nehe, uhez putar uma'e wemimunehew nehe. Uzahak putar nehe no. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Huwy e paw ire umumaw putar 7 'ar nehe. A'e re Tupàn henataromo ikatu ma'e romo wiko putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","8 haw 'ar mehe upyhyk putar mokoz pykahu wà nehe, aze ru'u mokoz pyku'i wà nehe. Oho putar tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. A'e pe omono putar a'e mokoz wiràmiri xaxeto pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Xaxeto omono putar Tupàn pe imono pyr romo wà nehe. Pitài wiko putar katu 'ygwer imunàn kar haw romo nehe. Inugwer ukaz paw putar henataromo nehe. Nezewe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto uzapo putar kuzà imukatu haw nehe. Ikatu putar Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ko ze'eg umuhem kar ikatu 'ymaw Izaew izuapyapyr wanuwi Tupàn henataromo a'e. Nezewe mehe numàno kwaw tàpuzràn Tupàn pe imonokatu pyrer imuaiw haw wi wà nehe. Tàpuzràn Tupàn pe imonokatu pyrer upyta waneko haw myter pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Amumaw ze'eg awa wi uhem ma'e hereko har rehe har imume'u haw kwez xe ihe. Amumaw awa wi ta'yrer uhem ma'e kwer rehe har imume'u haw no. ");
INSERT INTO gubBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Amumaw ze'eg kuzà huwy haw 'ar rehe har imume'u haw kwez xe ihe. Amumaw ze'eg awa kuzà huwy ma'e puhe oho ma'e kwer rehe har imume'u haw no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Tupàn Tuweharupi Wiko Ma'e uzuka mokoz Àràw ta'yr a'e wà, ta'e omono yhyk zàwenugar Tupàn pe ize'eg rupi 'ym a'e wà xe. A'e ma'e iapo re Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","— Emume'u ko ma'e neryky'yr Àràw pe nehe. — Nerepuner kwaw nereixe haw rehe ipupyaikaw pyrer ikatuahy wera'u ma'e pupe wyzài 'ar mehe nehe. Pànuhu ikupe kutyr hin a'e ipupyaikaw pyrer a'e, tàpuzràn Tupàn pe imonokatu pyrer pupe a'e, ere izupe nehe. — Aze ereixe ipupe wyzài 'ar mehe nehe, eremàno putar nehe. Ta'e Tupàn uzexak kar a'e pe ywàkun pupe a'e xe, ize'eg hyru imimaw i'aromo a'e xe. Tupàn umunàn teko wanemiapo kwer ikatu 'ygwer xe wanuwi a'e pe a'e, ere Àràw pe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","— Ezuka tapi'aka'yr awa teko wanemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. Ezuka àràpuhàràn hawitu ma'e awa ukaz paw ma'e ràm romo nehe no. Xo a'e re zo erepuner neixe haw rehe ipupyaikaw pyrer ikatuahy wera'u ma'e pupe nehe, ere izupe nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Heixe 'ym mehe we Àràw uzahak putar nehe. Na'e umunehew putar xaxeto wanemimunehew irin iapo pyrer nehe: temyhar, kamirpuku, ku'aw har. Umunehew putar àkàg iwànaw irin iapo pyrer wàkàg rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Na'e Tupàn omono ko uze'eg teko wanemiapo kwer ikatu 'ygwer imunàn kar haw 'ar rehe har Moizez pe kury. — Teko Izaew izuapyapyr omono putar mokoz àràpuhàrànete awa Àràw pe wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo a'e wà nehe. Omono putar pitài àràpuhàràn hawitu ma'e awa izupe hapy pyr ukaz paw ma'e ràm romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Àràw upyhyk putar tapi'aka'yr wemimono ràm katu 'ygwer imunàn kar haw romo nehe, wànàm wanemiapo kwer hekuzaromo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","A'e re weraha putar a'e mokoz àràpuhàrànete awa tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe wà nehe. A'e re, Tupàn Tuweharupi Wiko Ma'e henataromo ");
INSERT INTO gubBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Àràw omomor putar ita'i her hereko har nehe. Pitài ita'i heta putar Tupàn Tuweharupi Wiko Ma'e her hehe imuapyk pyrer nehe. Inugwer ita'i heta putar Azazew her hehe imuapyk pyrer nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Àràw uzuka putar àràpuhàrànete awa Tupàn Tuweharupi Wiko Ma'e ima'e nehe, teko wanemiapo kwer ikatu 'ygwer imunàn kar pà izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Omono putar àràpuhàrànete awa Azazew ima'e Tupàn Tuweharupi Wiko Ma'e pe wikuwe ma'e romo nehe. Na'e Àràw omono kar putar a'e àràpuhàrànete awa ywyxiguhu pe nehe, teko wanemiapo kwer ikatu 'ygwer imunàn kar haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Àràw upyhyk putar tapi'aka'yr wemimono ràm katu 'ygwer imunàn kar haw romo nehe, wànàm wanemiapo kwer hekuzaromo nehe no. Uzuka putar tapi'ak nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Na'e Àràw upyhyk putar amo yhyk zàwenugar hapy haw nehe. Umynehem putar tanimuk ma'ea'yr hapy haw pe har pupe nehe. A'e ma'ea'yr hapy haw Tupàn Tuweharupi Wiko Ma'e henataromo hin a'e. Upyhyk putar mokoz opo ipor yhyk zàwenugar hyàkwegatu ma'e imuku'iku'i pyrer nehe. Na'e wixe putar Tupàn henaw ikatuahy wera'u ma'e pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo omono putar yhyk zàwenugar tata rehe nehe. Nezewe mehe hàtàxiner upyk putar Tupàn Ze'eg Hyru ipykaw nehe. Nezewe mehe Àràw numàno kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Upyhyk putar tapi'aka'yr huwykwer ikurera'i nehe. Umupiripirik putar ukwà pupe Tupàn Ze'eg Hyru ipykaw rehe kwarahy ihemaw kutyr har rehe nehe. A'e re umupiripirik putar huwykwer 7 haw Tupàn Ze'eg Hyru henataromo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Na'e Àràw uzuka putar àràpuhàrànete teko wanemiapo kwer ikatu 'ym ma'e imunàn kar haw romo no. Weraha putar huwykwer Tupàn henaw ikatuahy wera'u ma'e pupe nehe. Umupiripirik putar Tupàn Ze'eg Hyru ipykaw rehe nehe. Umupiripirik putar ze'eg hyru henataromo nehe no, tapi'aka'yr awa huwykwer rehe wemiapo kwer zàwe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Nezewe Àràw umukatu putar Tupàn henaw ikatuahy wera'u ma'e nehe, katu 'ygwer paw imunàn pà a'e wi nehe, wanemiawy kwer paw imunàn pà a'e wi nehe no, wakatu 'ymaw paw imunàn pà a'e wi nehe no. Uzapo putar nezewegatete haw tàpuzràn Tupàn pe imonokatu pyrer imukatu pà nehe no. A'e tàpuzràn upyta teko ikatu 'ym ma'e wamyter pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Àràw Tupàn henaw ikatuahy wera'u ma'e pupe heko mehe imukatu haw iapo mehe ni amo nuixe kwaw tàpuzràn pupe nehe. Àràw umunàn kar putar ikatu 'ym ma'e Tupàn pe nehe: wemiapo kwer, wànàm wanemiapo kwer, teko wanemiapo kwer. ");
INSERT INTO gubBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","A'e re uhem putar tàpuzràn wi ma'ea'yr hapy haw tàpuzràn henataromo har pe oho pà nehe. Uzapo putar ma'ea'yr hapy haw imukatu haw kury. Upyhyk putar tuwykwer ikurera'i nehe: tapi'ak huwykwer, àràpuhàrànete awa huwykwer. Omono putar wanuwykwer 4 ma'ea'yr hapy haw iahykaw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Umupiripirik putar wanuwykwer 7 haw ukwà pupe ma'ea'yr hapy haw rehe nehe. Nezewe haw iapo mehe umukatu putar ma'ea'yr hapy haw Izaew wakatu 'ymaw imuhem kar pà nehe. Omonokatu putar Tupàn pe ma'ereko haw pe nezewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Àràw umumaw putar imukatu haw nehe: Tupàn henaw ikatuahy wera'u ma'e imukatu haw, tàpuzràn Tupàn pe imonokatu pyrer imukatu haw, ma'ea'yr hapy haw imukatu haw. Na'e upyhyk putar àràpuhàrànete Azazew ima'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Opokok putar iàkàg rehe nehe. Na'e umume'u putar Izaew wakatu 'ymaw paw nehe, wanemiawy kwer paw nehe, wanemiapo kwer ikatu 'ym ma'e paw nehe. Nezewe Àràw omono putar teko wanemiapo kwer ikatu 'ym ma'e paw àràpuhàrànete awa iàkàg rehe nehe. Na'e omono kar putar àràpuhàrànete ywyxiguhu pe nehe. Wexak putar amo awa heraha àràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","A'e awa umuhem kar putar àràpuhàrànete ywyxiguhu rehe nehe. Nezewe mehe àràpuhàrànete oho putar amo ywy teko heta haw 'ym pe nehe, teko wanemiapo kwer ikatu 'ygwer heraha pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Na'e Àràw wixe putar tàpuzràn pupe nehe. Wenuhem putar xaxeto ma'e uzewi nehe. Tupàn henaw ikatuahy wera'u ma'e pupe wixe 'ym mehe umunehew a'e ma'e. A'e re wenuhem kury. Wezar a'e ma'e a'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A'e ipupyaikaw pyrer ikatu ma'e pupe uzahak putar nehe. Na'e umunehew uma'e nehe. A'e re uhem putar wemimono ràm Tupàn pe imono pà nehe. Ukaz paw putar nehe. Omono putar teko wanemimono ràm izupe nehe no. Ukaz paw putar a'e nehe no. Nezewe mehe umunàn kar putar wemiapo kwer ikatu 'ym ma'e nehe. Umunàn kar putar teko wanemiapo kwer ikatu 'ym ma'e nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Wapy putar ma'ea'yr imono pyr katu 'ygwer imunàn kar haw ikawer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Awa àràpuhàrànete awa ywyxiguhu pe heraha arer uhez putar uma'e wemimunehew nehe. Uzahak putar nehe no, teko waneko haw pupe wixe 'ym mehe we nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Teko wanemiapo kwer imunàn kar haw iapo re nehe, Tupàn henaw ikatuahy wera'u ma'e imukatu re nehe, tapi'aka'yr awa huwykwer hakook ire nehe, àràpuhàrànete awa huwykwer hakook ire nehe, amo weraha putar a'e ma'ea'yr katu pe wà nehe, teko waneko haw wi wà nehe: wanetekwer, wapirer, wano'o kwer, wanie kwer. Wapy putar tata pupe a'e pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Teko waneko haw pupe wixe wi 'ym mehe awa ma'ea'yr wanapy arer uhez putar uma'e wemimunehew nehe. Uzahak putar nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Peruzar ko ze'eg tuweharupi nehe. — 7 haw zahy rehe 10 haw 'ar mehe Izaew izuapyapyr paw wà nehe, amo ywy rehe arer Izaew wainuinuromo wiko ma'e wà no, umumaw putar a'e 'ar umai'u 'ym pà wà nehe. Numa'ereko kwaw a'e 'ar mehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ta'e a'e 'ar mehe xaxeto uzapo putar ma'ea'yr zuka haw teko wanemiapo kwer ikatu 'ym ma'e imunàn kar haw wà nehe. Nezewe mehe teko ikatu putar Tupàn Tuweharupi Wiko Ma'e henataromo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A'e 'ar ikatuahy putar nehe. Kwarahy nànàn teko numai'u kwaw a'e 'ar mehe wà nehe. Numa'ereko kwaw a'e 'ar mehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Amo 'ar mehe xaxeto wanuwihaw ta'yr wiko putar xaxeto wanuwihaw romo a'e nehe. Tu uzakook putar uri kawer wa'yr rehe tuwihaw romo imuigo kar pà nehe. Na'e ta'yr umunehew putar xaxeto hemimunehew irin iapo pyrer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Uzapo putar ma'e paw imukatu haw nehe: Tupàn henaw ikatuahy wera'u ma'e, tàpuzràn Tupàn pe imonokatu pyrer, ma'ea'yr hapy haw, xaxeto wà, teko paw wà. ");
INSERT INTO gubBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Teko weruzar putar ko ze'eg tuweharupi wà nehe. Kwarahy nànàn uzapo putar teko paw wanemiapo kwer imunàn kar haw wà nehe. Teko uzapo a'e ma'e paw Tupàn ze'eg Moizez pe imono pyrer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg wi Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","— Emono ko heze'eg Àràw pe nehe, teko Izaew izuapyapyr wanupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Aze amo Izaew izuapyr uzuka amo tapi'ak nehe, aze uzuka amo àràpuhàràn hawitu ma'e nehe, teko waneko haw pupe nehe, aze ru'u katu pe muite teko waneko haw wi nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","aze nueraha kwaw a'e ma'ea'yr tàpuzràn Tupàn pe imonokatu pyrer pupe teixe haw pe nehe, aze nomono kwaw Tupàn Tuweharupi Wiko Ma'e pe nehe, pemono kar a'e awa Izaew wamyter wi nehe. Ta'e ikatu 'ym ma'e iapo arer romo hekon a'e nehe xe. Nuzawy kwaw awa izuka arer. ");
INSERT INTO gubBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Tuwe Izaew uzapo nezewe haw wà nehe. Nuzuka kwaw ma'ea'yr teko waneko haw pupe wà nehe. Weraha putar a'e ma'ea'yr xaxeto tàpuzràn Tupàn pe imonokatu pyrer henataromo har pe wà nehe. A'e pe uzuka putar a'e ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pe wamono pà izupe uzemuawyze kar haw romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Xaxeto umupiripirik putar huwykwer ma'ea'yr hapy haw tàpuzràn Tupàn pe imonokatu pyrer henataromo har rehe nehe. Wapy putar ikawer a'e pe nehe. A'e ma'e imono pyr hyàkwegatu Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ko 'ar henataromo nehe, tuweharupi nehe, Izaew nomono pixik kwaw ma'e tekwe ikatu 'ym ma'e ywyxiguhu rehe har wanupe nehe. Aze mo uzapo nezewe haw wà, wiko mo Tupàn heruzar 'ymar romo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Izaew izuapyapyr paw wà nehe, amo ywy rehe arer Izaew wainuinuromo wiko ma'e wà no, omono putar ma'e Tupàn Tuweharupi Wiko Ma'e pe imono pyr romo wà nehe. Wapy putar a'e ma'e wà nehe. Ukaz paw putar wà nehe. Aze ru'u omono putar amo ma'e izupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Xo tàpuzràn Tupàn pe imonokatu pyrer pupe teixe haw pe omono putar a'e ma'e izupe wà nehe. Nomono kwaw ma'e izupe amo ywypehegwer rehe wà nehe. Aze amo nuweruzar kwaw ko ze'eg nehe, pemuhem kar pemyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Amo Izaew izuapyr nehe, aze ru'u amo ywy rehe arer Izaew wainuinuromo wiko ma'e nehe, aze u'u ma'ea'yr huwykwer nehe, wiko putar Tupàn iàmàtyry'ymar romo nehe. Tupàn omono kar putar teko wamyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ta'e wikuwe ma'e paw hekuwe haw upyta huwykwer pupe a'e xe. A'e rupi Tupàn uzakook kar ma'ea'yr izuka pyrer wanuwykwer paw ma'ea'yr hapy haw rehe a'e, xaxeto wanupe a'e. Nezewe mehe teko umunàn kar wemiapo kwer ikatu 'ygwer Tupàn pe wà. Ta'e tuwykwer tekuwe haw romo a'e xe. Upurupyro ikatu 'ygwer imunànaw romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","A'e rupi Tupàn umume'u a'e uze'eg a'e: ni amo Izaew izuapyapyr wà nehe, ni amo amo ywy rehe arer Izaew wainuinuromo wiko ma'e wà nehe, nupuner kwaw ma'ea'yr huwykwer i'u haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Amo Izaew izuapyr nehe, aze ru'u amo ywy rehe arer Izaew wainuinuromo wiko ma'e nehe, aze uzuka miar i'u pyràm nehe, aze uzuka wiràmiri i'u pyràm nehe, tuwe uzakook huwykwer ywy rehe nehe. A'e re upyk putar ywy pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ta'e wikuwe ma'e paw hekuwe haw upyta huwykwer pupe a'e xe. A'e rupi — Pe'u zo ma'e huwykwer nehe, i'i Tupàn Izaew wanupe. Ta'e tuwykwer a'e xe, tekuwe haw romo a'e xe. Aze amo u'u tuwykwer nehe, teko omono kar putar Izaew wamyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Wyzài Izaew izuapyr nehe, wyzài amo ywy rehe har nehe, aze u'u ma'ea'yr umàno e ma'e kwer ho'o kwer nehe, aze ru'u amo miar uzuka a'e ma'ea'yr nehe, tuwe uhez uma'e wemimunehew nehe. Tuwe uzahak nehe. Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Aze nuhez kwaw wemimunehew nehe, aze nuzahak kwaw nehe, tuwihaw uzepyk putar a'e teko rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Emume'u ko heze'eg Izaew wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Pezapo zo ma'e teko Ezit ywy rehe har wazàwe nehe. Pemumaw kwarahy tetea'u waiwy rehe peneko pà. Pezapo zo ma'e teko Kànàà ywy rehe har wazàwe nehe. Apueraha penereko waiwy pe ihe. Peiko zo a'e teko wanàmuz waze'eg rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nan. Peruzar heze'eg nehe. Pezapo heremiapo kar nehe. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Aze peruzar heze'eg nehe, aze pezapo heremiapo kar nehe, peikuwe putar nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg awa Izaew izuapyapyr wanupe. Eker zo kuzà neànàmete ipuhe nehe, a'e ma'e iapo pà hehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ezapo zo a'e ma'e nehy puhe nehe, neru imumaranugar kar pà nehe, nehy imumaranugar kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ezapo zo a'e ma'e wyzài neru hemireko puhe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ezapo zo a'e ma'e nereinyr puhe nehe: ni neru tazyr nehy imemyr puhe nehe. Aze wiko neràpuz me imugakwaw pyrer romo nehe, eho zo ipuhe nehe. Aze uzemugakwaw amo tàpuz me nehe, nezewe rehe we eho zo ipuhe nehe. Ta'e nereinyr romo hekon a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ezapo zo a'e ma'e neremimino puhe nehe, nezemumaranugar kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ezapo zo a'e ma'e nereinyr neru tazyr nehy imemyr 'ym puhe nehe. Ta'e nereinyrete romo hekon a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Ezapo zo a'e ma'e neru heinyr puhe nehe. Ezapo zo a'e ma'e nehy tyker puhe nehe, ni nehy ikypy'yr puhe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ezapo zo a'e ma'e netutyr hemireko puhe nehe. Ta'e nezaihe romo hekon a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ezapo zo a'e ma'e nera'ytaty puhe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ezapo zo a'e ma'e neryky'yr hemireko puhe nehe, ni nerywyr hemireko puhe nehe. Neryky'yr imaranugar putar nehe. Nerywyr imaranugar putar nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Aze ereker amo kuzà ipuhe nehe, eker zo imemyr ipuhe nehe no. Eker zo hemiàriro ipuhe nehe. Aze ru'u wiko neànàmete romo. Agwer iapo haw na'ikatu kwaw Tupàn pe, iro izupe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ereko zo neremireko tyker neremireko romo nehe. Ereko zo neremireko ikypy'yr neremireko romo nehe, aze neremireko wikuwe nehe. Uzeàmàtyry'ym mo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Eker zo neremireko puhe huwy haw 'ar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Eker zo amo awa hemireko puhe nehe. Ereiko mo ikatu 'ym ma'e romo Tupàn henataromo. ");
INSERT INTO gubBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ni amo awa nomono kwaw wa'yr tupàn ua'u Morok pe uma'ereko ma'e romo nehe. Nomono kwaw wazyr tupàn ua'u Morok pe uma'ereko ma'e romo nehe. Nezewe haw iapo haw uzeapo mo maranugar haw Tupàn Tuweharupi Wiko Ma'e her ikatu ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tuwe awa nuzapo kwaw a'e ma'e amo awa puhe nehe. Agwer iapo haw iroahy Tupàn pe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tuwe ni awa ni kuzà nuzapo kwaw a'e ma'e ma'ea'yr pe nehe. Iro Tupàn pe. Iapo har wiko ikatu 'ym ma'e romo Tupàn henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Uze'eg wi Tupàn teko Izaew izuapyapyr wanupe. — Pezapo zo agwer ma'e nehe. Aze pezapo nehe, peiko putar ikatu 'ym ma'e romo Tupàn henataromo nehe. Amono putar amo ywy peme nehe. A'e ywy rehe har uzapo agwer ma'e waiko wà. Amuhem kar putar waiwy wi ihe wà nehe. A'e re amono putar a'e ywy peme nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","A'e teko wanemiapo kwer ikatu 'ygwer umuaiw waneko haw ywy a'e. Na'ikatu kwaw herenataromo. A'e rupi azepyk a'e ywy rehe. A'e rupi a'e ywy umuhem kar a'e teko a'e wi wà, uhuhuk ma'e ài wà. ");
INSERT INTO gubBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Pe paw rupi pe, pe Izaew izuapyapyr wà, amo ywy rehe arer peinuromo har wà no, peruzar heze'eg nehe. Pezapo heremiapo kar nehe no. Pezapo zo agwer iro ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Awa a'e ywy rehe wiko ma'e uzapo agwer ma'e wà. A'e rupi a'e ywy uzeapo ikatu 'ym ma'e romo herenataromo. ");
INSERT INTO gubBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Pemuaiw zo a'e ywy nehe. Umuhem kar a'e pe har uzewi wà. Tuwe napemuhem kar kwaw uzewi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Aze amo uzapo agwer ma'e nehe, amuhem kar putar a'e teko Izaew wamyter wi ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Peruzar heremiapo kar paw nehe. Pezapo zo ma'e teko a'e ywy rehe har wanemiapo nehe, a'e pe peneko 'ym mehe har wanemiapo nehe. Peiko zo ikatu 'ym ma'e romo herenataromo nehe. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","— Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Peiko ikatu ma'e romo nehe, ta'e ihe Tuweharupi Wiko Ma'e pezar aiko ikatu ma'e romo ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Pitàitàigatu pezeruze'eg pehy wanehe nehe, pezeruze'eg penu wanehe nehe no. Pe paw rupi pepytu'u mytu'u haw 'ar rehe nehe. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Pemuwete zo tupàn a'ua'u pe wà nehe. Pema'e zo ita tàtà ma'e tupàn a'ua'u wanagapaw romo nehe. Ihe aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Aze pezuka ma'ea'yr herenataromo nehe, pezemuawyze kar haw romo nehe, pezapo ma'e heze'eg awer rupi katete nehe. Nezewe mehe penemimur ikatu putar ihewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Tuwe pe'u ma'ea'yr izuka pyrer ho'o kwer izuka haw 'ar mehe nehe, aze ru'u iku'egwer pe nehe. Aze heta we ikurer na'iruz haw 'ar mehe nehe, peapy nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ta'e uzeapo ikatu 'ym ma'e romo herenataromo a'e xe. Aze amo u'u ho'o kwer a'e 'ar mehe nehe, namuawyze kwaw hemimur kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Pezepyk i'u arer rehe nehe. Ta'e umuaiw ihewe ikatu ma'e a'e xe. Pemuhem kar a'e teko Izaew wamyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Arozràn imono'og mehe pepo'o zo haryw ko ywy rehe har nehe. Aze napepo'o kwaw amo haryw nehe, pezewyr zo ipo'o pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Pezapo zo uwà po'o haw mokoz haw ityw rehe nehe. Pepo'o zo haryw upyta ma'e kwer nehe. Napezewyr kwaw ywy rehe u'ar ma'e kwer imono'og pà nehe. Pezar a'e uwà ywy rehe hemetarer 'ym ma'e wanupe nehe, amo ywy rehe arer peinuromo wiko ma'e wanupe nehe no. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Nemunar zo ma'e rehe nehe. Neremu'em zo nehe. Neremu'em zo amo wanupe wama'e rehe nemunar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Emume'uahy zo neremiapo ràm herer rehe nehe, aze nerezapo kwaw a'e ma'e nehe. Ta'e nezewe haw iapo haw umuaiw herer a'e xe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Nemunar zo amo ma'e rehe nehe. Epuraraw kar zo ma'erahy amo wanupe wama'e rehe nemunar pà nehe. Aze amo umumaw pitài 'ar newe uma'ereko pà nehe, emono hekuzar izupe a'e 'ar mehe nehe. Emono zo izupe iku'egwer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Eze'eg zemueteahy zo ma'e henu 'ymar rehe nehe. Emono zo ma'e hehàpyhà 'ym ma'e henataromo imuzepyapi kar pà nehe. Ezeruze'eg herehe nehe, ta'e aiko nezar romo ihe xe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Aze uzeàmàtyry'ym ma'e ur nerenataromo wà nehe, — Ma'enugar uzawy a'e, aze i'i newe wà nehe, erereko katu ne wà nehe. Neremu'em zo hemetarer 'ym ma'e wamukàg e kar pà nehe. Neremu'em zo upuner ma'e nemyrypar romo wamuigo kar pà nehe. Emuàgà'ym wama'e ikatu haw pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Neremu'em zo eho iko teko wamyter pe nehe. Neremu'em zo amo imàno haw pe imono pà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Emonokatu zo Izaew rehe neakatuwawahy 'ymaw nehe. Emume'u katu hemiawy kwer izupe nehe. Nezewe mehe nuzapo kar kwaw ikatu 'ym ma'e newe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ezepyk zo neànàm wanehe nehe. Neakatuwawahy 'ym zo amo neànàm rehe nehe. Ezamutar katu amogwer nezeamutar katu haw zàwe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Peruzar heze'eg nehe. Pemuzàg kar zo amo ma'ea'yr amo ae ma'ea'yr peneimaw pe nehe. Pezutym zo amo ma'eà'yz amo ae ma'eà'yz ko pe nehe. Pemunehew zo ma'e amo pàn iapo pyrer amo ae pàn iapo pyrer rehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Aze awa umume'u amo uzeupe uma'ereko e ma'e amo awa pe hemireko ràm romo nehe, aze nomono kwaw izupe a'e rihi, aze ru'u izar ràm numekuzar kwaw a'e rihi, aze izar uker oho a'e kuzà puhe nehe, pezepyk a'e awa rehe nehe. Pezepyk a'e kuzà rehe nehe no. Pezuka zo pe wà nehe, ta'e awa numuhem kar kwaw a'e rihi xe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","A'e awa omono putar àràpuhàràn hawitu ma'e awa Tupàn Tuweharupi Wiko Ma'e pe nehe, wemiapo kwer hekuzaromo nehe. Weraha putar tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","A'e pe Tupàn Tuweharupi Wiko Ma'e henataromo xaxeto uzuka putar àràpuhàràn awa Tupàn pe nehe. Nezewe mehe umunàn kar putar a'e awa hemiapo kwer Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kànàà ywy rehe peneko mehe nehe, ma'ywa 'yw izutym mehe nehe, pemumaw na'iruz kwarahy i'a kwer i'u 'ym pà nehe. A'e i'a kwer na'ikatu kwaw herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","4 haw kwarahy rehe pemur i'a kwer ihewe imur pyr romo hekatu haw imume'u haw romo nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","5 haw kwarahy rehe pepuner i'a kwer i'u haw rehe nehe. Nezewe mehe i'yw i'a tetea'u wera'u putar kwarahy nànàn nehe. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Pe'u zo ma'ero'okwer huwykwer hereko har nehe. Pezeagaw zo uzeapo ma'e ràm ikwaw paw rehe nehe. Pezapo zo paze ma'e wanemiapo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Pemonohok zo pe'aw peàkàg ipehegwer rehe har nehe. Pemonohok zo peamutaw ipehegwer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Aze pezai'o amo imàno mehe nehe, pezekixi zo nehe. Pekair zo penetekwer rehe takihe pupe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Pemono zo penazyr kuzà wyzài romo wamuigo kar pà tupàn a'ua'u wanàpuzuhu pe har romo nehe. Ta'e nezewe pemumaranugar kar pe wà xe. Nezewe haw iapo haw umynehem mo ywy tupàn a'ua'u wamuwete haw pupe, iro haw pupe no. ");
INSERT INTO gubBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Pepytu'u mytu'u haw 'ar mehe nehe. Ta'e 'ar ihewe imonokatu pyr romo a'e xe. Pezeruze'eg hemuwete haw rehe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Aze amo uze'eg umàno ma'e kwer wanekwe pe wà nehe, pezepytywà kar zo wanupe nehe. Agwer iapo haw na'ikatu kwaw ihewe. Iapo har wiko putar ikatu 'ym ma'e romo herenataromo wà nehe. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Pepu'àm teko tua'uhez ma'e wanenataromo nehe. Pezeruze'eg wanehe nehe. Hemuwete pe nehe. Aiko pezar romo. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Perekoahy zo amo ywy rehe arer peywy rehe wiko ma'e pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Pereko Izaew wazàwe pe wà nehe. Pezamutar amo ywy rehe har peinuromo har pe wà nehe. Ta'e peiko amo ywy rehe arer Ezit ywy rehe peneko mehe xe. Tuwe wamutar haw nuzawy kwaw pezeamutar haw nehe. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Pemunar zo amo wama'e rehe puku haw hagapaw iawy haw pupe nehe, aze ru'u puhuz haw hagapaw azeharomoete har 'ym pupe nehe, aze ru'u uhu haw hagapaw iawy haw pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Pema'ereko puku haw hagapaw azeharomoete har pupe nehe, puhuz haw hagapaw azeharomoete pupe nehe no, uhu haw hagapaw azeharomoete pupe nehe no. Aiko Tuweharupi Wiko Ma'e pezar romo. Apupyro Ezit ywy wi ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Peruzar heze'eg nehe. Peruzar heremiapo kar nehe no. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","— Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Amo Izaew izuapyr nehe, u, amo ywy rehe arer Izaew wainuinuromo wiko ma'e nehe, aze omonokatu wa'yr tupàn ua'u Morok pe uma'ereko ma'e romo nehe, pezuka a'e awa ita tetea'u pupe iapiapi pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Aiko putar a'e awa iàmàtyry'ymar romo nehe. Amono kar putar teko wamyter wi nehe no. Omono wa'yr tupàn ua'u Morok her ma'e pe uma'ereko ma'e romo a'e. A'e rupi umuaiw tàpuzràn ihewe imonokatu pyrer a'e. Aikuwe a'e pe. Umuaiw herer ikatuahy ma'e a'e no. ");
INSERT INTO gubBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Aze teko numume'u kwaw hemiapo kwer ikatu 'ymaw wà nehe, aze nuzuka kwaw wà nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ihe ae aiko putar iàmàtyry'ymar romo nehe. Aiko putar iànàm waàmàtyry'ymar romo nehe no. Amono kar putar heremiaihu wamyter wi nehe. Aze amo weruzar ize'eg wà nehe, aze umuwete Morok wà nehe, amono kar putar a'e teko heremiaihu wamyter wi ihe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","— Hepytywà pe nehe, aze amo i'i umàno ma'e kwer wanekwe pe uze'eg ma'e wanupe nehe, aze ru'u uzeapo ma'e ràm imume'u har pe nehe, aiko putar a'e teko iàmàtyry'ymar romo hemiapo kwer rehe nehe. Amono kar putar teko wamyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Peiko heremiruze'egete romo nehe. Peiko zo amo hemiruze'eg romo nehe. Peiko ikatu ma'e romo nehe. Ta'e aiko Tuweharupi Wiko Ma'e romo pezar romo ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Peruzar heze'eg nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Apuenuhem amogwer teko wanuwi, heremiruze'eg romo pemuigo kar pà. ");
INSERT INTO gubBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Aze amo omono uze'egaiw u rehe nehe, uhy rehe nehe, pezuka a'e teko nehe. Wiko putar uzezuka kar ma'e kwer romo nehe. Ta'e omono uze'egaiw u rehe uhy rehe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Aze awa uker amo hemireko puhe nehe, pezuka a'e awa nehe. Pezuka a'e kuzà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Aze awa uker u hemireko puhe nehe, umuaiw putar u her nehe. Pezuka a'e awa nehe. Pezuka a'e kuzà nehe no. Wiko putar uzezuka kar ma'e kwer romo a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Aze awa uker wa'yraty puhe nehe, pezuka pe wà nehe. Ta'e iaiw ma'e iapo arer romo wanekon a'e wà xe. Wiko putar uzezuka kar ma'e kwer romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Aze awa uker amo awa puhe nehe, pezuka pe wà nehe. Wanemiapo kwer iro ihewe. Wiko putar uzezuka kar ma'e kwer romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Aze awa wereko amo kuzà wemireko romo nehe, aze wereko ihy nehe no, ikatu 'ym ma'e iaiw ma'e iapo har romo wanekon putar wà nehe. Peapy a'e na'iruz teko wanekuwe mehe we pe wà nehe. Pemunàn a'e iro haw iaiw ma'e teko wanuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Aze awa uker ma'ea'yr puhe nehe, pezuka pe wà nehe. Pezuka awa nehe. Pezuka ma'ea'yr nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Aze kuzà uker ma'ea'yr puhe nehe, pezuka kuzà nehe, pezuka ma'ea'yr nehe no. Wiko putar uzezuka kar ma'e kwer romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Aze awa wereko weinyr wemireko romo nehe, aze a'e kuzà wiko tu tazyr romo nehe, aze ru'u, tu tazyr uhy rehe we har romo nehe, pemono kar awa heinyr rehe we nehe, teko wamyter wi nehe. Aze awa wereko weinyr, uzapo maranugar haw. Pezepyk hehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Aze awa uker kuzà puhe huwy haw 'ar rehe nehe, pemono kar awa teko wamyter wi nehe. Pemono kar kuzà teko wamyter wi nehe no. Mokoz wiko ikatu 'ym ma'e romo herenataromo wà. Ta'e uzuhaw heze'eg kuzà huwy ma'e imukatu haw rehe har wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Aze awa uker uhy ikypy'yr puhe nehe, aze ru'u tyker puhe nehe, aze ru'u u heinyr puhe nehe, pezepyk wanehe nehe, ta'e wiko wànàm romo wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Awa u heinyr puhe uker ma'e umumaranugar kar u tyky'yr a'e, u tywyr a'e. Pezepyk a'e awa rehe nehe. Pezepyk a'e kuzà rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Aze awa uker wyky'yr hemireko puhe nehe, wywyr hemireko puhe nehe, umumaranugar kar putar wyky'yr a'e nehe, wywyr a'e nehe no. Agwer iapo haw iro ihewe. Umàno putar wa'yr 'ym pà wà nehe, umemyr 'ym pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Peruzar heze'eg nehe. Peruzar heremiapo kar nehe no. Nezewe mehe ywy peneko àwàm napemuhem kar kwaw nehe. Apueraha penereko a'e ywy kutyr ihe. Peiko putar izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Amono kar putar teko a'e ywy rehe har waiwy wi ihe wà nehe. Peiko zo wazàwe nehe. Pezapo zo wanemiapo nehe. Pepyhyk putar a'e ywy peho peiko nehe. Ipyhypyhyk mehe amonomono kar putar hehe har izuwi nehe. Aikwahy wanupe, ta'e uzapo iro ma'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","— Amono putar a'e ywy peme nehe, a'e peme kwehe mehe. Peiko putar izar romo nehe. Ikatuahy a'e. Hezuz katu ma'e hehe. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. Apuenuhem kar amogwer teko wanuwi ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","A'e rupi, petyryk wiràmiri ihewe ikatu 'ym ma'e wanuwi nehe, ma'ea'yr ihewe ikatu 'ym ma'e wanuwi nehe. Xo ikatu ma'e zo pe'u nehe. Xo wanehe zo pepokok nehe. Ihe ame'e ma'ea'yr wanehe ihe: wiràmiri, miar, ywy rehe upuze ma'e. Amume'u wakatu haw. Amume'u wakatu 'ymaw. — Pe'u zo wyzài ihewe ikatu 'ym ma'e nehe, a'e peme. Nezewe mehe napeiko kwaw ikatu 'ym ma'e romo herenataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Peiko ikatu ma'e romo nehe, ta'e ihe Tupàn Tuweharupi Wiko Ma'e aiko ikatuahy ma'e romo ihe xe. Apuenuhem amogwer teko wanuwi ihe, pemuigo kar pà heremiruze'eg romo ihe, amo hemiruze'eg romo pemuigo kar 'ym pà ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Wyzài awa nehe, wyzài kuzà nehe, aze wenoz ma'e umàno ma'e kwer wanekwe pe nehe, aze uzapo paze ma'e hemiapo nehe, pezuka ita tetea'u pupe iapiapi pà nehe. A'e teko wiko putar uzezuka kar ma'e kwer romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","— Emume'u ko heze'eg xaxeto Àràw izuapyapyr wanupe nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Tuwe ni amo xaxeto nopokok kwaw wànàm umàno ma'e kwer hetekwer rehe wà nehe. Ta'e ikatu 'ym ma'e romo uzeapo putar nezewe mehe wà nehe xe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Xo wànàmete rehe zo upuner opokokaw rehe: uhy, aze ru'u wa'yr, ");
INSERT INTO gubBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","wazyr, wyky'yr, wywyr, weinyr wàpuz me wiko ma'e. ");
INSERT INTO gubBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Tuwe nuzeapo kwaw ikatu 'ym ma'e romo weinyr imen ma'e kwer umàno ma'e kwer rehe opokok awer rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Tuwe xaxeto nupin kwaw wàkàg wà nehe. Tuwe nomonohok kwaw wamutaw wà nehe. Nuzekixi kwaw umàno ma'e kwer rehe uzemumikahy haw hexak kar pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Uzeruzar putar Tupàn uzar rehe wà nehe. Nuzeruzar kwaw amo rehe wà nehe. Nuze'eg zemueteahy kwaw Tupàn her rehe wà nehe. Omono putar temi'u Tupàn Tuweharupi Wiko Ma'e pe imono pyr izupe wà nehe. A'e rupi, tuwe uzeruzar katu hehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Uzemonokatu Tupàn ima'ereko haw rehe wà nehe. A'e rupi nupuner kwaw kuzà wyzài hereko haw rehe wemireko romo wà nehe. Nuwereko kwaw kuzà amo awa puhe oho ma'e kwer wà nehe. Aze kuzà wiko amo awa hemireko romo nehe, aze imen upuir izuwi nehe, xaxeto nuwereko kwaw a'e kuzà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Xaxeto omono temi'u Tupàn pe imono pyr izupe. A'e rupi teko katuahy, i'i a'e xaxeto pe wà. Ihe Tupàn Tuweharupi Wiko Ma'e ihe, hekatuahy ihe. Aexaexak Izaew izuapyapyr ihe wà, ikatuahy ma'e romo wamuigo kar pà ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Aze amo xaxeto tazyr umuaiw uwer kuzà wyzài romo wiko pà nehe, umumaranugar kar putar u nezewe mehe a'e nehe. Peapy hekuwe mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Xaxeto wanuwihaw wiko xaxeto romo a'e, amo xaxeto uri kawer Tupàn henataromo imukatu pyrer izakook mehe iàkàg rehe a'e, xaxeto wama'e imunehew pà uzehe a'e. A'e rupi, tuwe nupytu'u kwaw u'aw imuguz re a'e nehe. Tuwe numu'i kwaw uma'e uzemumikahy haw hexak kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Tuwe nopokok kwaw umàno ma'e kwer hetekwer rehe nehe. Ni u hetekwer rehe ni uhy hetekwer rehe nopokok kwaw nehe. Wiko mo ikatu 'ym ma'e romo aze mo opokok hehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Tàpuzràn Tupàn pe imonokatu pyrer pupe heixe mehe umuaiw mo tàpuzràn. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Xo kuzà awa puhe oho pixik 'ym ma'e hereko haw rehe zo xaxeto wanuwihaw upuner putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Nuwereko kwaw kuzà imen umàno ma'e nehe. Aze kuzà wiko amo awa hemireko romo nehe, aze imen upuir izuwi nehe, nuwereko kwaw a'e kuzà nehe. Nupuner kwaw kuzà wyzài romo wiko ma'e hereko haw rehe nehe. Upuner xo kuzà Izaew izuapyr awa puhe oho pixik 'ym ma'e hereko haw rehe zo wemireko romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Nezewe mehe izuapyapyr wiko putar ikatu ma'e romo Tupàn henataromo wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Ihe amuigo kar a'e awa xaxeto romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Tupàn Tuweharupi Wiko Ma'e umume'u ko ma'e Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","— Emume'u ko ma'e Àràw pe nehe. — Wyzài izuapyr a'e, aze heta amo ixiro haw hehe nehe, nupuner kwaw temi'u ihewe imur pyr imur haw rehe ihewe nehe. Ko heze'eg peruzar tuweharupi nehe. Pepytu'u zo heruzar ire nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ni amo awa uxiro ma'e nupuner kwaw ma'e imur pyr imur haw rehe herenataromo wà nehe: hehàpyhà 'ym ma'e, wata 'ym ma'e, huwaxiro ma'e, hetekwer iapar ma'e, ");
INSERT INTO gubBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","hetymà upen ma'e, izywa upen ma'e, ");
INSERT INTO gubBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ikupeapar ma'e, iaikwer ma'e, heha rehe ima'eahy ma'e, ipir rehe izuhazuhar ma'e, wyzài perew hereko har, hapi'a hereko 'ymar. ");
INSERT INTO gubBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ni amo Àràw izuapyr agwer ixiro ma'e nupuner kwaw temi'u imur pyr ihewe imur haw rehe wà nehe. Aze heta ixiro haw hehe nehe, nupuner kwaw temi'u herenataromo imur haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A'e awa upuner a'e temi'u ikurer i'u haw rehe nehe, imonokatu pyrer nehe, imonokatu pyrer 'ym nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nupuner kwaw pànuhu herenaw ikatuahy ma'e izywyr har huwake uhemaw rehe nehe. Nupuner kwaw ma'ea'yr hapy haw huwake uhemaw rehe nehe. Ta'e heta ixiro haw hehe xe. A'e rupi umuaiw mo a'e ma'e. Aiko Tupàn Tuweharupi Wiko Ma'e romo. Amonokatu a'e ma'e paw hezeupe. ");
INSERT INTO gubBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moizez umume'u a'e ma'e Àràw pe, ta'yr wanupe no, teko Izaew izuapyapyr nànàn no. ");
INSERT INTO gubBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","— Emume'u ko ma'e Àràw pe nehe, ta'yr wanupe nehe no, ");
INSERT INTO gubBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Pezeruze'eg teko Izaew ihewe wanemimur nànàn nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Pemuaiw zo herer ikatu ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Aze wyzài pezuapyr wiko ikatu 'ym ma'e romo herenataromo nehe, teko Izaew ihewe wanemimur herenataromo imur mehe nehe, a'e awa nupuner pixik kwaw xaxeto romo weko haw rehe nehe. Peruzar ko heze'eg tuweharupi nehe. Pepytu'u zo heruzar ire nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Wyzài Àràw izuapyr a'e nehe, aze ipir rehe heta ma'eahy haw purupe uhàz ma'e ràm nehe, aze ru'u heta ima'e wi uhem e ma'e nehe, nupuner kwaw ihewe imur pyr ikatu ma'e ikurer i'u haw rehe nehe. Xo ukatu wi mehe zo upuner putar nehe. Xaxeto uzeapo putar ikatu 'ym ma'e romo aze opokok ikatu 'ym ma'e rehe nehe, aze a'e ma'e uzeapo ikatu 'ym ma'e romo umàno ma'e kwer rehe opokok pà a'e nehe. Wiko putar ikatu 'ym ma'e romo aze uhem e ta'yrer izuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Wiko putar ikatu 'ym ma'e romo aze opokok ma'ea'yr Tupàn henataromo ikatu 'ym ma'e rehe nehe, aze ru'u amo teko ikatu 'ym ma'e rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Wiko putar Tupàn henataromo ikatu 'ym ma'e romo nehe. Xo kwarahy heixe re zo uhem putar ikatu 'ymaw izuwi nehe. Xo uzahak ire zo upuner putar ma'e imur pyr ikatu ma'e i'u haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Xo kwarahy heixe re zo ikatu wi putar nehe. A'e mehe upuner ma'e imur pyr ikatu ma'e i'u haw rehe nehe. Ta'e hemi'u romo a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Nupuner kwaw ma'ea'yr umàno e ma'e kwer i'u haw rehe nehe. Nupuner kwaw ma'ea'yr miar wanemizuka kwer i'u haw rehe nehe no. Aze u'u nehe, ikatu 'ym ma'e romo hekon putar Tupàn henataromo nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Xaxeto paw weruzar putar heze'eg heremimono kwer wà nehe. Aze nuweruzar kwaw wà nehe, ikatu 'ym ma'e iapo har romo wiko putar wà nehe. Umàno putar wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. Amonokatu a'e xaxeto hezeupe ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Xaxeto a'e nehe, iànàm a'e wà nehe no, xo a'e zo upuner ma'e imur pyr ikatu ma'e i'u haw rehe wà nehe. Xaxeto hàpuz me wiko ma'e wà, izupe uma'ereko ma'e a'e wà no, nupuner kwaw i'u haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Xaxeto pe uma'ereko e ma'e wà, upuner a'e ma'e imur pyr i'u haw rehe wà nehe: hemime'eg kar kwer wà, hàpuz me uzexak kar ma'e kwer wà no. ");
INSERT INTO gubBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Aze xaxeto tazyr imen nuiko kwaw xaxeto romo nehe, a'e kuzà nupuner kwaw ma'e imur pyr ikatu ma'e i'u haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Aze wiko imen umàno ma'e kwer romo nehe, aze ru'u imen upuir izuwi nehe, aze na'imemyr kwaw nehe, aze uzewyr u hàpuz me wiko pà kuzàtài ài nehe, a'e mehe upuner ma'e imur pyr ikatu ma'e i'u haw rehe nehe. Xaxeto a'e wà, iànàm a'e wà no, xo a'e zo upuner a'e imur pyr i'u haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Aze amo nupuner kwaw i'u haw rehe nehe, aze nezewe rehe we u'u ikwaw 'ym pà nehe, omono putar a'e ma'e hekuzar xaxeto pe nehe. Upei'àg putar hekuzar 5 pehegwer romo nehe. Omono putar amo pitài ipehegwer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Xaxeto numuaiw kar kwaw ma'e Tupàn Tuweharupi Wiko Ma'e pe imur pyr amo wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Nu'u kar kwaw a'e ma'e amo teko wanupe nehe, aze a'e teko nupuner kwaw i'u haw rehe wà nehe. Aze a'e teko u'u wà nehe, wiko putar ikatu 'ym ma'e iapo har romo wà nehe. Pezepyk wanehe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. Amukatu ma'e ihewe imur pyr ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Emume'u ko heze'eg Àràw pe nehe, ta'yr wanupe nehe no, teko Izaew izuapyapyr nànàn nehe no, ");
INSERT INTO gubBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Amo Izaew izuapyr nehe, aze ru'u amo ywy rehe arer Izaew wainuinuromo wiko ma'e nehe, aze umur ma'ea'yr hapy pyràm ukaz paw ma'e ràm Tupàn Tuweharupi Wiko Ma'e pe nehe, aze wiko hemimume'u kwer romo nehe, aze ru'u wiko imur e pyr romo nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","tuwe ma'ea'yr awa wiko ikatu 'ymaw hereko 'ymar romo nehe. Nezewe mehe Tupàn umuawyze putar a'e ma'ea'yr nehe. Upuner tapi'ak awa herur haw rehe nehe, àràpuhàràn hawitu ma'e awa herur haw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Tuwe naheta kwaw ikatu 'ymaw hehe nehe. Aze werur ma'ea'yr ikatu 'ymaw hereko har nehe, Tupàn numuawyze kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Aze amo umur ma'e Tupàn pe uzemuawyze kar haw romo nehe, aze wemimume'u rehe ipurapo wer nehe, aze ru'u ipurumur e wer izupe nehe, tuwe naheta kwaw ikatu 'ymaw ma'ea'yr rehe nehe. Nezewe mehe Tupàn umuawyze putar nehe. Upuner tapi'aka'yr awa herur haw rehe nehe. Aze ru'u upuner àràpuhàràn hawitu ma'e kuzà herur haw rehe, aze ru'u àràpuhàrànete kuzà herur haw rehe nehe no. Nupuner kwaw ikatu 'ymaw hereko haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Pemono zo ma'ea'yr hehàpyhà 'ym ma'e nehe, ni wata 'ym ma'e nehe, ni ixiro ma'e nehe, ni iperew ohoete ma'e hereko har nehe, ni ipereperew ma'e nehe, ni amo ma'eahy haw ipir rehe hereko har nehe. Tuwe nuerur kwaw ma'ea'yr agwer ikatu 'ymaw hereko har Tuweharupi Wiko Ma'e pe temi'u romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pepuner ma'ea'yr ixiro ma'e imur e haw rehe Tupàn pe nehe: tapi'ak awa, àràpuhàràn hawitu ma'e awa. Napepuner kwaw ma'ea'yr ixiro ma'e imur haw rehe penemimume'u kwer iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Pemono zo ma'ea'yr Tupàn pe nehe, aze heta hapi'a ikatu 'ym ma'e izupe nehe: inupà pyrer, iakamik pyrer, izo'ok pyrer, imonohok pyrer. Nerepuner kwaw agwer ma'ea'yr imur haw rehe Tupàn pe Izaew ywy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Pemur kar zo ma'ea'yr agwer ikatu 'ymaw hereko har amo ywy rehe har pe nehe, temi'u Tupàn pe imur pyr romo nehe. Agwer ma'ea'yr heta ixiro haw wanupe wà. Tupàn numuawyze kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Tupàn Tuweharupi Wiko Ma'e umume'u amo ma'e Moizez pe no. ");
INSERT INTO gubBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Aze amo ma'ea'yr uzexak kar nehe: tapi'aka'yr awa, àràpuhàràna'yr hawitu ma'e awa, àràpuhàrànetea'yr awa, umumaw putar 7 'ar uhy rehe we upyta pà nehe. 8 haw 'ar henataromo pepuner imono haw rehe Tupàn Tuweharupi Wiko Ma'e pe temi'u imono pyr romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Aze pezuka tapi'ak kuzà nehe, pezuka zo imemyr tapi'aka'yr a'e 'ar mehe we nehe. Aze pezuka àràpuhàràn hawitu ma'e kuzà nehe, pezuka zo imemyr a'e 'ar mehe we nehe. Aze pezuka àràpuhàrànete kuzà nehe, pezuka zo imemyr a'e 'ar mehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ma'e hekatu haw imume'u har ihewe imur mehe nehe, peruzar heze'eg ma'e ihewe imur pyr rehe har nehe. Nezewe mehe amuawyze putar ihe wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Pe'u ihewe imur pyr izuka haw 'ar mehe nehe. Tuwe naheta kwaw ikurer iku'egwer pe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Peruzar heze'eg nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Pezapo zo ma'e herer ikatu ma'e imuaiw pà nehe. Tuwe teko Izaew izuapyapyr paw umume'u hekatuahy haw wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. Apomonokatu hezeupe ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Apupyro Ezit ywy wi ta'e hereko wer pezar romo ihe xe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","— Emume'u ko heze'eg Izaew wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Aze'eg putar wanupe mynykaw uhua'u wera'u ma'e wanehe ihe nehe. Teko uzemono'og a'e mynykaw iapo pà hemuwete katu pà wà. Aiko Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Heta 6 'ar pema'ereko haw romo peme. 7 haw 'ar mehe amonokatu peme pepytu'u haw romo ihe. Pezemono'og hemuwete katu pà a'e 'ar mehe paw rupi nehe. Pema'ereko zo a'e 'ar mehe nehe. Izaew waneko haw nànàn omonokatu mytu'u haw 'ar Tupàn Tuweharupi Wiko Ma'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Amume'u putar mynykawhu waner xe ihe wà nehe kury. Teko uzemono'og putar a'e 'ar rehe Tupàn Tuweharupi Wiko Ma'e imuwete katu pà wà nehe. Teko uzapo putar a'e mynykawhu i'ar katu mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Mynykawhu zaneipy izuka 'ym awer her ma'e uzypyrog kwarahy heixe mehe pitài haw zahy rehe 14 haw 'ar mehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","15 haw 'ar a'e zahy rehe har rehe uzypyrog mynykawhu typy'ak imuapiruru kar pyrer 'ym her ma'e. Teko ima'enukwaw katu Tupàn Tuweharupi Wiko Ma'e ikatu haw rehe a'e 'ar rehe wà. Pemumaw 7 'ar typy'ak iapo pà imuapiruru kar haw imono 'ym pà inuinuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","A'e mynykaw rehe pitài haw 'ar mehe ni amo numa'ereko kwaw wà. Paw rupi uzemono'og Tupàn imuwete katu pà wà. ");
INSERT INTO gubBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","A'e 7 'ar rehe pemono temi'u Tupàn Tuweharupi Wiko Ma'e pe nehe. 7 haw 'ar mehe pezemono'og Tupàn imuwete katu pà nehe. A'e 'ar mehe ni amo numa'ereko kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","— Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Ywy peme heremimono ràm rehe peixe mehe nehe, arozràn ipo'o haw ipy iapo mehe nehe, peraha pitài penemipo'o haryw xaxeto pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Pemumaw mytu'u haw 'ar nehe. Iku'egwer pe xaxeto omono putar a'e arozràn haryw Tupàn Tuweharupi Wiko Ma'e pe nehe, pemuawyze kar pà izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","A'e 'ar mehe we pemono àràpuhàràn hawitu ma'e awa pitài kwarahy hereko har ikatu 'ymaw hereko 'ymar Tuweharupi Wiko Ma'e pe nehe, imono pyr ukaz paw ma'e ràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Pemono mokoz kir arozràn uri kawer inuromo imupyràn pyrer izupe nehe no. A'e imono pyr hyàkwegatu putar Tuweharupi Wiko Ma'e pe nehe. Pemono pitài zutahyky'a por win izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pe'u zo arozràn ikyr ma'e haryw a'e ma'e Tupàn pe imono 'ym mehe we nehe, ni haryw imihir pyrer nehe, ni typy'ak nehe. Wyzài ywy rehe peneko mehe peruzar putar ko ze'eg tuweharupi nehe. Pezuapyapyr weruzar putar ko ze'eg tuweharupi wyzài ywy rehe wiko mehe wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Pemono arozràn haryw ipy Tupàn pe nehe. Pezypyrog 'ar ipapar pà a'e 'ar mehe nehe. Pepapar 49 'ar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Na'e, iku'egwer pe, arozràn haryw imono re 50 'ar ipaw ire pemono amo arozràn Tupàn Tuweharupi Wiko Ma'e pe temi'u romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Uzeànàànàm ma'e omono putar mokoz typy'ak arozràn imuku'i pyrer ikatu wera'u ma'e iapo pyrer izupe pitàitàigatu wà nehe. Omono putar imuapiruru kar haw arozràn inuromo a'e typy'ak iapo mehe wà nehe. Heta putar mokoz kir typy'ak wanupe pitàitàigatu nehe. Omono putar Tupàn Tuweharupi Wiko Ma'e pe ma'e imono pyr romo wà nehe. Omono'og putar arozràn ikatu wera'u ma'e a'e typy'ak iapo pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pemono 7 àràpuhàràna'yr hawitu ma'e awa izupe pe wà nehe no. Tuwe naheta kwaw ikatu 'ymaw wanehe nehe. Pemono pitài tapi'aka'yr awa nehe. Pemono mokoz àràpuhàràn hawitu ma'e awa pe wà nehe no. Pemono Tupàn Tuweharupi Wiko Ma'e pe ukaz paw ma'e ràm romo nehe, arozràn rehe wà nehe, win rehe we nehe no. Hyàkwegatu agwer ma'e Tuweharupi Wiko Ma'e pe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Pemono pitài àràpuhàrànete awa katu 'ygwer imunàn kar haw romo nehe. Pemono mokoz àràpuhàràna'yr hawitu ma'e pitài kwarahy hereko har izupe pe wà nehe, pezemuawyze kar haw romo pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Xaxeto omono putar a'e mokoz àràpuhàràna'yr hawitu ma'e awa Tupàn Tuweharupi Wiko Ma'e pe wà nehe. Omono putar typy'ak izupe nehe no. Imono pyr ikatuahy ma'e romo a'e wà. Xaxeto wiko a'e ma'e imono pyr ikatuahy ma'e izar romo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","A'e 'ar mehe ni amo numa'ereko kwaw wà nehe. Paw rupi uzemono'og putar Tupàn imuwete katu pà wà nehe. Wyzài ywy rehe peneko mehe peruzar ko ze'eg tuweharupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Arozràn ipo'o haw iapo mehe pepo'o zo haryw ko iwyr har nehe. Pezewyr zo haryw ipo'o pyrer 'ym ipo'o pà nehe. Pezar a'e haryw hemetarer 'ym ma'e wanupe nehe, amo ywy rehe arer peywy rehe wiko ma'e wanupe nehe no. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","— Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. — Pepytu'u 7 haw zahy rehe pitài haw 'ar mehe nehe. Tupàn omonokatu a'e 'ar uzeupe. Penurywete xi'àm ma'e'ak iapo pyrer ipy pà nehe. Paw rupi pezemono'og Tupàn imuwete katu pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Pema'ereko zo a'e 'ar mehe nehe. Pemono temi'u Tupàn Tuweharupi Wiko Ma'e pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Uze'eg Tupàn Tuweharupi Wiko Ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","7 haw zahy rehe 10 haw 'ar mehe amunàn teko wanemiapo kwer ihe. A'e 'ar mehe ni amo nu'u kwaw ma'e wà nehe. Paw rupi omono putar temi'u ihewe wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ni amo numa'ereko kwaw a'e 'ar mehe wà nehe. Ta'e a'e 'ar mehe teko umur ma'e ihewe wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo a'e wà xe. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Aze amo u'u amo ma'e katu 'ygwer imunàn kar haw 'ar mehe nehe, pemono kar a'e teko teko wamyter wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Aze amo uma'ereko a'e 'ar mehe nehe, ihe ae azuka putar a'e teko ihe nehe, imumaw pà ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Pezapo zo ma'ereko haw a'e 'ar mehe nehe. Wyzài ywy rehe peneko mehe peruzar ko ze'eg tuweharupi nehe. Pezuapyapyr weruzar putar ko ze'eg tuweharupi a'e wà nehe no, upytu'u 'ym pà wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Pezypyrog kwarahy heixe haw 9 haw 'ar mehe har pe nehe. Peho kwarahy heixe haw 10 haw 'ar mehe har pe nehe. Pepytu'u a'e mehe nehe. Amonokatu a'e 'ar pepytu'u haw pe ihe. Ni amo nu'u kwaw ma'e a'e 'ar mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Tupàn Tuweharupi Wiko Ma'e umume'u ko uze'eg Moizez pe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","— Emume'u ko heze'eg teko Izaew izuapyapyr wanupe nehe. — 7 haw zahy rehe 15 haw 'ar mehe uzypyrog mynykawhu tàpuzràn her ma'e. Umumaw putar 7 'ar a'e mynykaw iapo pà Tupàn Tuweharupi Wiko Ma'e imuwete katu pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","'Ar ipy mehe heta putar teko wamono'ogaw ikatu ma'e nehe. Ni amo numa'ereko kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mynykawhu rehe 'ar nànàn pemono temi'u Tupàn Tuweharupi Wiko Ma'e pe nehe. 8 haw 'ar mehe teko paw uzemono'og putar Tupàn imuwete katu pà wà nehe. Omono putar temi'u izupe wà nehe. Zemono'ogaw 'ar ikatu ma'e romo a'e. Ni amo numa'ereko kwaw a'e 'ar mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Amumaw mynykawhu waner kwez xe ihe kury. Teko uzemono'og putar Tupàn Tuweharupi Wiko Ma'e imuwete katu pà a'e mynykaw nànàn wà nehe. Omono putar ma'e izupe a'e 'ar rehe wà nehe: temi'u, ma'e ukaz paw ma'e ràm, arozràn, ma'ea'yr izuka pyràm, win. Uzapo putar mynykawhu i'ar katu mehe pitàitàigatu wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Pemonokatu mytu'u haw 'ar Tupàn Tuweharupi Wiko Ma'e pe nehe. Pezapo agwer mynykawhu nehe no. Pemono ko ma'e imono pyr izupe nehe no, amogwer izupe imono pyr rehe we nehe no, ma'e imono pyr penemimume'u iapo haw rehe we nehe no, ma'e penemimono e rehe we nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Arozràn ipo'o re pezapo putar amo mynykawhu Tupàn Tuweharupi Wiko Ma'e ikatu haw imume'u pà nehe. Uzypyrog 7 haw zahy rehe 15 haw 'ar mehe nehe. Oho putar 22 haw 'ar pe nehe. 'Ar ipy mehe nehe, 8 haw 'ar mehe nehe no, ni amo numa'ereko kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","'Ar ipy mehe teko opo'o putar ma'e'a ma'ywa'yw ikatu wera'u ma'e wi wà nehe. Omonohok putar inàzàràn 'yw huwer wà nehe no. Omonohok putar ywyra huwer tetea'u hereko har hàkà wà nehe no. Na'e paw rupi uzapo putar mynykawhu Tuweharupi Wiko Ma'e romo pezar imuwete pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Tuweharupi nehe, kwarahy nànàn 7 haw zahy rehe nehe, teko uzapo putar a'e mynykawhu 7 'ar imumaw har wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","A'e 7 'ar rehe Izaew paw wiko putar tàpuzràn ywyra hàkàgwer iapo pyrer pupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nezewe mehe a'e wà nehe, wazuapyapyr a'e wà nehe no, tuweharupi ima'enukwaw putar Tupàn hemiapo kwer rehe wà nehe. Ezit ywy wi wapyro mehe umuigo kar tàpuzràn pupe a'e wà. Wiko Tuweharupi Wiko Ma'e romo pezar romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nezewe Moizez omono Tupàn ze'eg mynykawhu rehe har teko Izaew izuapyapyr wanupe. Uzapo a'e mynykawhu Tupàn Tuweharupi Wiko Ma'e imuwete katu pà wà. ");
INSERT INTO gubBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Tupàn Tuweharupi Wiko Ma'e umume'u ko uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","— Emume'u ko ma'e Izaew wanupe nehe. — Perur uri kawer ikatu wera'u ma'e nehe. Pemunyk tatainy henaw rehe har tàpuzràn Tupàn pe imonokatu pyrer pupe har nehe. Pemuwew kar pixik zo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Tuweharupi karuk mehe Àràw umunyk putar tatainy henaw rehe har nehe. Tatainy umumaw putar pytun gatu uhyape pà nehe, a'e pe Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Henaw upyta katu pe pànuhu huwake Tupàn Ze'eg Hyru henataromo a'e. Pe nehe, pezuapyapyr wà nehe no, peruzar putar ko heze'eg tuweharupi nehe, pepytu'u 'ym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Àràw uzekaiw putar tatainy ihàm rehe nehe. Henaw or ikatuahy ma'e iapo pyrer romo a'e. Nezewe mehe nuwew kwaw Tupàn Tuweharupi Wiko Ma'e henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Pemuzar 12 typy'ak nehe. Heta putar mokoz kir arozràn imuku'i pyrer pe pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Heta ywyrapew zàwenugar Tupàn Tuweharupi Wiko Ma'e henataromo. Or ikatuahy ma'e iapo pyrer romo a'e. Pemono a'e typy'ak a'e ywyrapew zàwenugar rehe nehe. Pemono typy'ak amo typy'ak i'aromo mokoz ywytyra'i iapo pà nehe. 6 typy'ak upyta putar xe wà nehe. Inugwer upyta putar pe pe wanuwake wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pemono putar yhyk zàwenugar ikatuahy ma'e a'e typy'ak mokoz ywytyra'i romo iapo pyrer i'aromo nehe. Nezewe mehe — Ximono 'àg typy'ak paw Tupàn Tuweharupi Wiko Ma'e pe temi'u romo zane, peze putar pezeupeupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mytu'u haw 'ar nànàn nehe, tuweharupi nehe, xaxeto wanuwihaw omonokatu putar typy'ak ywyrapew zàwenugar rehe Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Tuweharupi Wiko Ma'e uzapokatu uze'egaw teko Izaew izuapyapyr wanehe we. A'e typy'ak zanemuma'enukwaw kar a'e ze'eg rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Xaxeto Àràw izuapyapyr wiko putar izar romo tuweharupi wà nehe. A'e typy'ak ikatuahy Tupàn henataromo. Ta'e temi'u Tuweharupi Wiko Ma'e pe imono pyr romo a'e xe. A'e rupi xaxeto u'u putar ywypehegwer Tupàn pe imonokatu pyrer rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Amo awa amo Ezit ywy rehe har ta'yr wiko Izaew wainuromo a'e. Wereko kuzà Izaew tazyr wemireko romo. Xerumit kuzà her romo a'e. Nimiri tazyr romo Nà izuapyr romo hekon. Amo 'ar mehe Izaew waneko haw pupe imen uzàmàtyry'ym amo Izaew izuapyr. Omono uze'egaiw hehe. Uze'eg zemueteahy Tupàn Tuweharupi Wiko Ma'e her rehe no. Weraha a'e awa Moizez pe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Umunehew a'e pe wà. — Tuweharupi Wiko Ma'e umume'u putar izupe zaneremiapo ràm a'e nehe, i'i uzeupeupe wà. ");
INSERT INTO gubBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","— Peraha a'e awa katu pe muite teko waneko haw wi nehe. Ihewe ize'eg zemueteahy mehe amo wenu wà. Henu arer omono putar opo iàkàg rehe wà. A'e re teko paw uzapizapi putar ita tetea'u pupe wà nehe, izuka pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Emume'u wi ko heze'eg teko wanupe nehe. — Aze amo omono uze'egaiw Tupàn rehe nehe, Tupàn uzepyk putar hehe ize'eg awer hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Teko uzapizapi putar ita tetea'u pupe wà nehe, izuka pà wà nehe. Aze wiko Izaew izuapyr romo nehe, aze ru'u amo ywy rehe arer romo nehe, pezuka nehe. Pezuka Tupàn Tuweharupi Wiko Ma'e her rehe uze'egaiw imono arer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Aze amo uzuka amo nehe, pezuka izuka arer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Aze amo uzuka ma'ea'yr weimaw 'ym nehe, omono putar amo ma'ea'yr izarer pe hekuzaromo nehe. Tuwe ma'ea'yr izuka pyrer hekuzar nuzawy kwaw ma'ea'yr imono pyràm hekuzar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Aze amo ukutuk amo nehe, pekutuk ikutuk arer nezewegatete nehe. Aze ukixi nehe, pekixi ikixi arer nezewegatete nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Aze uzuhaw izywa nehe, pezuhaw izuhaw arer izywa nezewegatete nehe. Aze ozo'ok hàz nehe, pezo'ok izo'ok arer hàz nezewegatete nehe. Aze umugaz nehe, pemugaz imugaz arer nezewegatete nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Aze amo uzuka amo heimaw nehe, izuka arer omono putar amo ma'ea'yr izarer pe hekuzaromo nehe. Aze amo uzuka amo teko nehe, pezuka izuka arer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Peruzar ko heze'eg nehe. Amo ywy rehe arer peinuromo har weruzar putar ko heze'eg nezewegatete a'e wà nehe no. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Na'e Moizez umume'u a'e ma'e paw Izaew wanupe. Na'e upyhyk awa Tupàn her rehe uze'egaiw imono arer wà kury. Weraha katu pe weko haw wi wà. Uzapizapi ita tetea'u pupe izuka pà a'e pe wà kury. Nezewe uzapo Tupàn Tuweharupi Wiko Ma'e Moizez pe hemiapo kar wà. ");
INSERT INTO gubBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe Xinaz ywytyr rehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","— Emono ko heze'eg teko Izaew izuapyapyr wanupe nehe. — Tupàn Tuweharupi Wiko Ma'e umur putar amo ywy peme a'e nehe. A'e ywy rehe peneixe mehe pezapo nezewe haw nehe: pemumaw 6 kwarahy ywy rehe pema'ereko pà nehe. 7 haw kwarahy rehe pemupytu'u kar ywy nehe, Tupàn Tuweharupi Wiko Ma'e imuwete katu pà nehe. Pezapo nezewe haw kwarahy nànàn nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pemumaw 6 kwarahy ko penemitym rehe ma'e itym pà nehe. Pemonohok hàkà ikatu 'ym ma'e ma'e'yw wi nehe. Pepo'o uwà imono'og pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","7 haw kwarahy rehe pemupytu'u kar ywy nehe. Pemonokatu a'e mytu'u haw 'ar Tupàn Tuweharupi Wiko Ma'e pe nehe. A'e kwarahy rehe ni amo nuzutym kwaw ma'e oko pe wà nehe. Nomonohok kwaw hàkà uwà 'yw wi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ni amo nopo'o kwaw arozràn hezuz e ma'e wà nehe. Nomonohok kwaw hàkà uwà 'yw wi wà nehe. Nopo'o kwaw uwà wà nehe. Ywy upytu'u tuwe a'e kwarahy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Napezutym kwaw ma'eà'yz ko pe nehe. Nezewe rehe we hezuz putar ma'e nehe. Uhyk putar teko nànàn nehe: Izaew wanupe, wanupe uma'ereko e ma'e wanupe, wanupe uma'ereko ma'e wanupe, amo ywy rehe arer Izaew wainuromo wiko ma'e wanupe, ");
INSERT INTO gubBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ma'ea'yr peneimaw wanupe, miar wanupe. Ywy rehe hezuz ma'e ràm paw uzeapo putar wanemi'u romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Pepapar 7 kwarahy pitài imono'og pyr romo iapo pà nehe. A'e mehe pepapar 7 imono'og pyr nehe. 49 kwarahy heta. ");
INSERT INTO gubBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","A'e kwarahy rehe 7 haw zahy rehe 10 haw 'ar mehe katu 'ygwer imunàn kar haw 'ar mehe, peze'eg amo awa pe nehe. — Ezupy nexi'àm ma'e'ak kwer iapo pyrer Izaew ywy nànàn nehe, peze izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","A'e kwarahy uhem 49 kwarahy pawire a'e. — Kwarahy Izaew ywy rehe har imunehew pyrer wamuhem kar haw a'e, za'e putar izupe nehe. Aze a'e 'ym mehe amo ume'eg amo teko amo pe uma'ereko e ma'e romo nehe, a'e ime'eg pyrer uhem putar uzar wi nehe, wànàm wanupe uzewyr pà nehe. Aze a'e 'ym mehe amo ume'eg oko amo pe nehe, a'e kwarahy rehe a'e ko ime'eg kar arer umuzewyr putar izar izypy mehe arer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","A'e kwarahy rehe ni amo nuzutym kwaw ma'eà'yz oko pe wà nehe. Nopo'o kwaw arozràn hezuz e ma'e wà nehe. Nomonohok kwaw hàkà uwà 'yw wi wà nehe. Nopo'o kwaw uwà wà nehe. Ywy upytu'u putar tuwe a'e kwarahy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ta'e kwarahy purumuhem kar haw uzeapo putar kwarahy ikatuahy ma'e romo teko wanupe nehe xe. A'e ywy rehe xo ywy rehe hezuz e ma'e zo u'u putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Aze a'e 'ym mehe amo ume'eg oko amo pe nehe, a'e kwarahy purumuhem kar haw rehe a'e ko ime'eg kar arer umuzewyr kar putar izar izypy mehe arer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Aze peme'eg ko amo pe nehe, penoz zo hekuzar uhua'u wera'u ma'e izupe nehe. Aze peme'eg kar ko amo wi nehe, pemono zo hekuzar pixika'i wera'i ma'e izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","16","— Màràn kwarahy upaw kwarahy purumuhem kar awer ipaw ire, peze pezeupe nehe, ime'eg mehe nehe, ime'eg kar mehe nehe. Azeharomoete napeme'eg kwaw ywy. Napeme'eg kar kwaw ywy. Peme'eg temi'u ipo'o àwàm. Peme'eg kar temi'u ipo'o àràm. A'e mehe ime'eg kar har upapar putar ipo'o awer a'e kwarahy paw ire har nehe. Ime'egar upapar putar ipo'o àwàm kwarahy purumuhem kar àwàm ihem 'ym mehe we àwàm nehe. Aze heta tetea'u we amo kwarahy nehe, hekuzar ikatu putar nehe. Aze naheta tete kwaw nehe, hekuzar pixika'i wera'i putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Tuwe ni amo na'imunar kwaw amo hemetarer rehe nehe. Tuwe teko paw ukyze Tupàn wi wà nehe, ta'e Tuweharupi Wiko Ma'e romo Zanezar romo hekon a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Peruzar Tupàn ze'eg paw nehe, hemiapo kar paw nehe no. Nezewe mehe peiko katu putar a'e ywy rehe nehe. Peiko putar izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Hezuz putar penemipo'o ràm hehe nehe. Temi'u uhyk putar teko nànàn nehe. Paw rupi wiko putar hehe ma'e ukyze 'ym pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","— Màràzàwe tuwe heta putar temi'u kwarahy ma'e tym 'ymaw rehe nehe, amo i'i putar nehe, uzehe upuranu pà nehe. Teko nuzutym kwaw ma'eà'yz a'e kwarahy rehe wà nehe. Naheta kwaw arozràn ipo'o pyràm a'e kwarahy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Na'aw a'e puranu haw iwazar haw xe. Tupàn omono putar uze'egatu a'e ywy rehe nehe. 6 haw kwarahy rehe ipo'o pyr uhua'u putar nehe. Uhyk putar teko wanupe na'iruz kwarahy rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","8 haw kwarahy rehe peko rehe ma'eà'yz izutym mehe pe'u putar 6 haw kwarahy rehe penemipo'o kwer nehe. Uhyk putar peme nehe. Pe'u a'e temi'u peho peiko nehe. 9 haw kwarahy rehe pe'u putar 9 haw kwarahy rehe ipo'o pyrer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Tupàn wiko a'e ywy izar romo. A'e rupi ime'eg kar har nuiko kwaw izar romo tuweharupi nehe. Tupàn wiko izar romo. Zaiko amo ywy rehe arer romo a'e ywy rehe wiko ma'e romo izupe. Xo màràn 'ar zo ximumaw putar izywyr rehe zanereko pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","A'e rupi, aze amo ume'eg amo ywypehegwer nehe, izar izypy mehe arer ràgypy wiko putar ime'eg kar wi àràm romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Amo Izaew izuapyr nehe, aze hemetarer upaw nehe, aze ume'eg uiwy pehegwer nehe, tuwe iànàm huwake wera'u har ur hemime'eg kwer ime'eg kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Aze naheta kwaw iànàm a'e ywy ime'eg kar àràm nehe, aze ru'u amo 'ar mehe hemetarer katu wi putar nehe. Nezewe mehe uzewyr putar ywy wemime'eg kwer ime'eg kar wi pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Upapar putar arozràn a'e ywy rehe ipo'o pyrer nehe, kwarahy purumuhem kar awer pawire arer nehe. Upapar putar ipo'o pyràm nehe no, kwarahy purumuhem kar àwàm 'ym mehe we àràm nehe no. Nezewe mehe uzapo putar hekuzar nehe. Ime'eg kar wi re nehe, wiko wi putar a'e ywy izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Aze hemetarer nuhyk kwaw nehe, aze nupuner kwaw ime'eg kar wi haw rehe nehe, a'e mehe ime'eg kar arer wiko wiwi izar romo nehe. Xo kwarahy purumuhem kar haw rehe zo a'e ywypehegwer uzewyr putar uzar kwer izypy mehe arer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Aze amo awa ume'eg wàpuz tawhu pàrirogawtàtà hereko har pupe har nehe, upuner ime'eg kar wi haw rehe nehe, aze numumaw kwaw pitài kwarahy nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Aze nume'eg kar wi kwaw a'e kwarahy rehe nehe, ime'eg kar arer wiko putar izar romo azeharomoete tuweharupi nehe. Imàno re izuapyapyr wiko putar izar romo wà nehe. Ni kwarahy purumuhem kar haw rehe nuzewyr kwaw izar izypy mehe arer pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Tàpuz tawhu pàrirogawtàtà hereko 'ymar nuzawy kwaw ywypehegwer. Izar ipy upuner ime'eg kar wi haw rehe. Kwarahy purumuhem kar haw rehe uzewyr izar romo wiko pà. ");
INSERT INTO gubBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Erewi izuapyapyr a'e wà nehe, tuweharupi upuner uzewyr haw rehe wàpuz tawhu weko haw pe har ime'eg kar wi haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Aze ume'eg wàpuz amo agwer tawhu pupe har nehe, aze nume'eg kar wi kwaw nehe, a'e mehe kwarahy purumuhem kar haw rehe hàpuz uzewyr putar izupe nehe. Wiko wi putar izar romo nehe. Ta'e Erewi izuapyapyr wiko putar wàpuz Erewi izuapyapyr waneko haw tawhu pe har izar romo tuweharupi wà nehe. Tuweharupi wiko Izaew izuapyapyr wainuinuromo wà. ");
INSERT INTO gubBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Heta ywy tawhu Erewi waneko haw izywyr har. Nupuner pixik kwaw a'e ywy ime'egaw rehe wà nehe. Erewi izuapyapyr wiko putar izar romo tuweharupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Aze amo Izaew izuapyr neruwake wiko ma'e uzeapo hemetarer 'ym ma'e romo nehe, aze nupuner kwaw wemi'u ràm ime'eg kar haw rehe nehe, epytywà amo ywy rehe har peinuromo wiko ma'e ài nehe. Nezewe mehe wiko wiwi putar neruwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Aze eremono neremetarer amo pe nehe, — Amo 'ar mehe eremur wi ihewe nehe, aze ere izupe nehe, — Emur heremetarer imemyr ihewe nehe, ere zo izupe nehe. Ezeruze'eg Tupàn hemiapo kar rehe nehe. Nezewe mehe a'e awa wikuwe wiwi neruwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Aze eremono neremetarer amo pe nehe, — Amo 'ar mehe eremur wi ihewe nehe, aze ere izupe nehe, — Emur heremetarer imemyr ihewe nehe, ere zo izupe nehe. Aze ereme'eg kar temi'u amo pe nehe, emur kar zo temetarer tetea'u hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Tuweharupi Wiko Ma'e Zanezar uzapo kar ko ma'e zanewe a'e. A'e zanepyro Ezit ywy wi. Umur putar Kànàà ywy zanewe nehe. Wiko putar Zanezar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Amo Izaew izuapyr neruwake wiko ma'e a'e, aze hemetarer upaw nehe, aze uzeme'eg newe uma'ereko e ma'e romo nehe, emuma'ereko e kar zo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ereko newe temetarer rehe uma'ereko ma'e ài nehe. Uma'ereko putar newe nehe. Kwarahy purumuhem kar haw rehe upytu'u putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","A'e kwarahy rehe a'e awa a'e nehe, ta'yr a'e wà nehe no, oho putar nereko haw wi wànàm wanupe uzewyr pà wà nehe, uipy waiwy pe uzewyr pà wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Izaew nuzawy kwaw Tupàn Tuweharupi Wiko Ma'e pe uma'ereko e ma'e wà. Upyro Ezit ywy wi wà. Na'ikatu kwaw uma'ereko e ma'e ài wame'egaw. ");
INSERT INTO gubBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","A'e rupi, erekoahy zo ne wà nehe. Ezeruze'eg Tupàn hemiapo kar rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Aze peputar uma'ereko ma'e awa pe wà nehe, u kuzà wà nehe, pepuner wame'eg kar haw rehe amo ywy rehe har peywy huwake har wapyr nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Pepuner amo ywy rehe arer peinuromo har wana'yr wame'eg kar haw rehe pe wà nehe no. Pepuner wana'yr Izaew ywy rehe uzexak kar ma'e kwer wame'eg kar haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wazar upuner wamono haw rehe uma'e ipyhyk àràm wanupe wà nehe no. A'e uma'ereko e ma'e umumaw putar ukwarahy paw uzar pe uma'ereko pà wà nehe. Amo Izaew izuapyapyr nupuner kwaw amo ae Izaew izuapyapyr hereko haw rehe uma'ereko e ma'e romo nehe. Nupuner kwaw herekoahy haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Aze ru'u amo amo ywy rehe arer teko wainuromo har wiko putar hemetarer katu ma'e romo nehe. Aze ru'u amo Izaew izuapyr a'e awa huwake wiko ma'e wiko hemetarer 'ym ma'e romo nehe. Aze ru'u uzeme'eg a'e amo ywy rehe arer pe uma'ereko e ma'e romo nehe, u iànàm pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Aze uzeapo nezewe haw nehe, amo iànàm upuner a'e Izaew ime'eg kar wi haw rehe nehe: ");
INSERT INTO gubBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","tyky'yr, itutyr, tywyra'yr, amo iànàmete. Aze a'e ae omono'og temetarer tetea'u nehe, upuner uzeme'eg kar wi haw rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Uze'eg putar ime'eg arer pe nehe. — Màràn herekuzar, i'i putar izupe nehe. Upapar putar kwarahy wà nehe. — Màràn kwarahy heta we purumuhem kar haw ihem 'ym mehe, i'i putar izupe nehe. Ukwaw putar uma'ereko ma'e pe imono pyr wà. A'e rupi umume'u putar hekuzar uzeupeupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Aze heta we kwarahy tetea'u purumuhem kar haw ihem 'ym mehe we nehe, omono putar wemetarer wera'u wekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Aze xo amogwemogwer kwarahy heta we nehe, hekuzar pixika'i wewer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Izar wereko putar uzeupe uma'ereko ma'e pitài kwarahy rehe har ài nehe. Tuwe izar nupuraraw kar kwaw ma'erahy izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nezewe rehe we nehe, aze a'e awa nuzemuhem kar kwaw a'e nehe, a'e mehe izar umuhem kar putar kwarahy purumuhem kar haw rehe nehe. Umuhem kar putar ta'yr wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ta'e Izaew wiko Tupàn pe uma'ereko e ma'e zàwenugar romo a'e wà xe. Tupàn wiko Tuweharupi Wiko Ma'e romo a'e, wazar romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg teko Izaew wanupe kury. — Pezapo zo ma'e penemimuwete ràm romo nehe: tupàn a'ua'u, ma'e hagapaw, izyta tekwe ikatu 'ym ma'e hagapaw, ita ma'e hagapaw uzehe hereko har. Pemuwete zo ni pitài agwer ma'e nehe. Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Pezeruze'eg mytu'u haw 'ar rehe he'ar rehe nehe. Pezeruze'eg hemuwete haw rehe nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Aze peruzar heze'eg nehe, aze peruzar heremiapo kar nehe, aze pezapo heremiapo kar paw nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","amugyr kar putar àmàn i'ar katu mehe nehe. Ywy umuezuz putar arozràn tetea'u nehe. Ma'ywa'yw i'a katu putar nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Heta tetea'u putar arozràn ipo'o pyr nehe. Uwà ipo'o haw 'ar mehe pemono'og wiwi putar arozràn peiko nehe. Arozràn à'yz ko pe itymaw 'ar mehe pepo'o wiwi putar uwà peiko nehe. Heta putar temi'u peme paw rupi nehe. Peiko katu ko ywy rehe pekyze 'ym pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Amono putar zeàmàtyry'ym 'ymaw peywy rehe nehe. Teko paw uker katu putar wà nehe. Ni amo nukyze kwaw wà nehe. Ni amo na'ipytuhegatu kwaw wà nehe. Na'e amukàzym kar putar miar hehaite ma'e a'e ywy wi wà nehe. Amumaw putar zeàmàtyry'ymawhu nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Peityk putar peàmàtyry'ymar pe wà nehe, wazuka pà pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Aze heta 5 zauxiapekwer peinuromo har wà nehe, a'e zauxiapekwer uzuka putar 100 wainuromo har zauxiapekwer a'e wà nehe. Aze heta 100 zauxiapekwer peinuromo har wà nehe, a'e zauxiapekwer uzuka putar 10.000 wainuromo har zauxiapekwer a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Amono putar heze'egatu penehe ihe nehe. Amono putar pena'yr tetea'u peme ihe wà nehe no. Azapokatu heze'egaw penehe we ihe. Azapo putar ma'e heze'eg rupi katete ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Arozràn imono'og pyrer uhua'u putar nehe. Peityk putar arozràn kwehe arer nehe, arozràn pyahu imonokatu haw iapo pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Aiko putar peinuinuromo nehe, tàpuzràn ihewe imonokatu pyrer pupe nehe. Napuir pixik kwaw pewi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Aiko putar peinuinuromo tuweharupi nehe. Aiko putar pezar romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Aiko Tuweharupi Wiko Ma'e romo pezar romo ihe. Apupyro Ezit ywy wi. Nezewe mehe napeiko kwaw a'e ywy rehe har wanupe uma'ereko e ma'e romo. Apupyro pemunehew pawer wi. Apumuata kar uzurupu'àm ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Aze naperuzar kwaw heremiapo kar paw nehe, aze peityk heze'eg nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","aze pepuir heremiapo kar wi nehe, aze pezuhaw heze'egaw penehe we heremiapo katu kwer nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","a'e mehe azepyk putar penehe nehe. Amono kar putar ikatu 'ym ma'e penehe nehe: iaiw haw, ma'eahy haw, taku haw purumuagaiw ma'e teko wakàgaw henuhemaw. Pezutym e putar ma'eà'yz peko pe nehe. Peàmàtyry'ymar u'u putar hezuz ma'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Aiko putar peàmàtyry'ymar romo nehe. Apuityk kar putar peàmàtyry'ymar wanupe nehe. Wiko putar pezar romo wà nehe. Aze naheta kwaw peme ma'erahy ipuraraw kar har wà nehe, nezewe rehe we pezàn putar wanuwi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","A'e re, aze nahereruzar kwaw pe nehe, aze pezapo wiwi ikatu 'ym ma'e nehe, amono kar putar penehe hezepykaw 7 haw iaiw wera'u ma'e penehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","— Zaiko upuner katu ma'e romo zane, peze putar peiko nehe. Amumaw putar pepuner haw nehe. Namugyr kar kwaw àmàn nehe. Ywy tàtàahy putar itaper ài nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Pema'ereko e putar nehe. Pekene'o e putar nehe. Naheta kwaw arozràn ipo'o pyràm peko pe nehe. Ma'ywa'yw na'i'a kwaw nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Aze pezapo wiwi ikatu 'ym ma'e nehe, aze hereityk nehe, aze naperuzar kwaw heze'eg nehe, amono kar putar penehe hezepykaw 7 haw iaiw wera'u ma'e penehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Amono kar putar miar hehaite ma'e pemyter pe ihe wà nehe. Uzuka putar pena'yr wà nehe, Umumaw putar peneimaw tapi'ak wà nehe. Uzuka putar teko tetea'u wà nehe. Naheta kwaw teko pe rupi wata ma'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Nezewe rehe we nehe, aze napezewyr kwaw ihewe nehe, aze peiko wiwi heàmàtyry'ymar romo nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","aiko putar peàmàtyry'ymar romo nehe. Amono kar putar penehe hezepykaw 7 haw iaiw wera'u ma'e penehe nehe. Ta'e pezapo wiwi ikatu 'ym ma'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","— Pezàmàtyry'ym heremiaihu peho pe wà nehe, a'e putar teko peàmàtyry'ymar wanupe nehe. Nezewe azepyk putar penehe nehe, ta'e pezuhaw peze'egaw herehe we penemiapo katu kwer xe. Aze pezemono'og tawhu pupe peàmàtyry'ymar wanuwi pehem pà nehe, amono putar ma'eahy haw iaiw ma'e penehe nehe. A'e mehe peàmàtyry'ymar pepyhyk putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Azepyk putar penehe nehe. A'e rupi penemi'u ràm upaw etea'i putar nehe. 10 kuzà upuner putar wemi'u ràm typy'ak iapo haw rehe pitài zepehe pupe wà nehe. Pitàitàigatu teko upyhyk putar temi'u pixika'i ma'e wà nehe. Nuhyk pixik kwaw wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Nezewe rehe we aze nahereruzar kwaw pe nehe, aze pezapo wiwi heremimutar 'ym nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","aikwahy putar peme nehe, a'e mehe amono putar penehe hezepykaw 7 haw iaiw wera'u ma'e penehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Upaw etea'i putar temi'u nehe. Pe'u putar pena'yr pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Aikwahy putar tuwe peme nehe. Amumaw putar tupàn a'ua'u wamuwete haw pe peho haw nehe. Azukazuka putar ywyrapew zàwenugar yhyk zàwenugar hapy haw nehe. Aityk putar penetekwer tupàn a'ua'u heremityk kwer wanehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Amumaw putar tawhu ihe wà nehe. Upyta putar xo heityk pyrer zo nehe. Aityk putar tàpuzuhu tupàn a'ua'u wamuwete haw nehe. Ma'ea'yr izuka mehe herenataromo nehe, namuawyze kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Amuaiw putar ywy peneko haw nehe. Peàmàtyry'ymar peywy rehe wiko ma'e ràm ipytuhegatu putar hexak mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Azapo kar putar zeàmàtyry'ymawhu purupe nehe. Pehàpehàz putar ywy nànàn nehe. Naheta kwaw teko peywy rehe wiko ma'e wà nehe. Tawhu upyta putar heityk pyrer romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nezewe mehe ywy umumaw putar ukwarahy upytu'u pà nehe. Teko heta 'ym mehe we amo ywy nànàn pehàpehàz mehe ywy umumaw putar ukwarahy upytu'u pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ta'e nupytu'u kwaw a'e pe peneko mehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Amukyze kar putar amo ywy rehe wikuwe ma'e ihe wà nehe. A'e mehe, te ywyra huwer i'ar mehe har ipu haw umuzàn kar putar a'e wà nehe. — Zaneàmàtyry'ymar ur waiko zaneraikweromo wà, i'i putar uzàn mehe wà nehe, ikwaw 'ym pà wà nehe. Ni amo noho kwaw wanaikweromo wà nehe. Nezewe rehe we u'ar putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Amo u'ar putar amo wanehe wà nehe. Nuzawy kwaw uzeàmàtyry'ym ma'e wà nehe. Naheta kwaw waàmàtyry'ymar wanuwake wà nehe. Nezewe rehe we uzeàmàtyry'ym putar wà nehe. Peàmàtyry'ymar wahem mehe naheta kwaw pekàgaw nehe. Napepuner kwaw waàmàtyry'ymaw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Pemàno putar amo ywy rehe nehe. Uzutym putar penetekwer a'e pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","A'e ywy rehe wikuwe ma'e a'e wà nehe, uzezuka kar putar wemiapo kwer ikatu 'ym ma'e pe wà nehe. Waipy wanemiapo kwer ikatu 'ym ma'e uzuka putar wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Amo pezuapyapyr umume'u putar wemiapo kwer ikatu 'ym ma'e ihewe wà nehe. Waipy nuzeruzar kwaw herehe wà. Nuweruzar kwaw heze'eg wà. ");
INSERT INTO gubBl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Wiko heàmàtyry'ymar romo wà. A'e rupi amuhàmuhàz waàmàtyry'ymar waiwy nànàn ihe wà. Pezuapyapyr umume'u putar a'e wipy wanemiapo kwer wà nehe no. Aze weityk uma'enukwaw haw ikatu 'ym ma'e wà nehe, aze upytu'u tupàn a'ua'u wamuwete re wà nehe, aze uzemono hezepykaw pe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","a'e mehe hema'enukwaw putar heze'egaw waipy wanehe we heremiapo katu kwer rehe nehe: Zako, Izak, Àmàrààw. Hema'enukwaw putar ywy wanupe heremimume'u kwer rehe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pezuapyapyr amo ywy rehe wahàwahàz mehe ni amo nuiko kwaw ywy heremimume'u kwer rehe wà nehe. Umumaw putar ukwarahy upytu'u pà nehe. Pezuapyapyr nuweruzar kwaw heze'eg wà nehe. Weityk heremiapo kar wà. A'e rupi umekuzar putar wemiapo kwer ikatu 'ym ma'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Wiko putar amo ywy rehe wà nehe. Nezewe rehe we naityk kwaw ihe wà nehe. Namumaw kwaw ihe wà nehe. Ta'e nazuhaw kwaw heze'egaw wanehe we heremiapo katu kwer ihe nehe xe. Aiko Tuweharupi Wiko Ma'e romo wazar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nan kwaw. Hema'enukwaw putar heze'egaw waipy wanehe we heremiapo katu kwer rehe nehe. Azapokatu a'e ze'egaw wanehe we Ezit ywy wi wapyro mehe ihe. Nezewe mehe aexak kar hepuner haw amo ywy rehe har nànàn ihe. Aiko Tupàn Tuweharupi Wiko Ma'e romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Amumaw a'e ze'eg imume'u haw kwez xe ihe: Tupàn hemiapo kar, ize'eg, iapo kar pyrer. Tupàn Tuweharupi Wiko Ma'e omono a'e ze'eg Izaew izuapyapyr wanupe a'e, Moizez pe imono pà Xinaz ywytyr rehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Tupàn Tuweharupi Wiko Ma'e omono ko uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","— Emono ko heze'eg Izaew wanupe nehe, i'i izupe. Amo teko uzemume'u Tupàn Tuweharupi Wiko Ma'e pe ima'ereko haw iapo har romo wà. Aze amo ihem wer wemimume'u kwer wi nehe, umekuzar katu putar uhem àwàm nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Tuwihaw wereko amo pape wà. A'e pape umume'u hekuzar a'e. Aze awa wereko 20 kwarahy te 60 kwarahy nehe, omono putar 50 temetarer tàtà parat iapo pyrer nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kuzà agwer kwarahy hereko har omono putar 30 temetarer tàtà ma'e parat iapo pyrer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Aze kwàkwàmo wereko 5 kwarahy te 20 kwarahy nehe, omono putar 20 temetarer tàtà ma'e parat iapo pyrer wà nehe. Kuzàtài agwer kwarahy hereko har omono putar 10 temetarer tàtà ma'e parat iapo pyrer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kwarer pitài zahy hereko har te 5 kwarahy hereko har omono putar 5 temetarer tàtà ma'e parat iapo pyrer wà nehe. Kuzàtài a'e kwarer ikwarahy hereko har omono putar na'iruz temetarer tàtà ma'e parat iapo pyrer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Aze awa wereko wera'u 60 kwarahy nehe, omono putar 15 temetarer tàtà ma'e parat iapo pyrer nehe. Kuzà izàwenugar omono putar 10 temetarer tàtà ma'e parat iapo pyrer wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Aze a'e teko wiko hemetarer 'ym ma'e romo nehe, aze nupuner kwaw imekuzar haw rehe nehe, uze'eg putar oho xaxeto pe nehe. — Màràn erepuner imur haw rehe, i'i putar izupe nehe. A'e mehe wenoz putar a'e temetarer izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Aze amo umume'u amo ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pe henataromo izuka pyràm romo nehe, a'e ma'ea'yr wiko putar Tupàn pe imonokatu pyr romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ni amo nupuner kwaw amo ma'ea'yr imono haw rehe hekuzaromo a'e re nehe. Aze amo omono amo ma'ea'yr hekuzaromo nehe, a'e mokoz ma'ea'yr wiko putar Tupàn pe imonokatu pyr romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Aze ma'ea'yr na'ikatu kwaw Tupàn henataromo nehe, aze wiko Tupàn Tuweharupi Wiko Ma'e hemimuawyze 'ym romo nehe, a'e mehe teko weraha putar a'e ma'ea'yr xaxeto pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ume'e putar ma'ea'yr rehe nehe. Na'e umume'u putar hekuzar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Aze izar ipurume'eg kar wi wer hehe nehe, omono putar hekuzar xaxeto pe nehe. Umuza'ak putar hekuzar 5 ipehegwer romo nehe. Omono putar amo ipehegwer xaxeto pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Aze amo omonokatu wàpuz Tupàn Tuweharupi Wiko Ma'e pe nehe, xaxeto ume'e putar hàpuz rehe nehe. Na'e umume'u putar hekuzar nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Aze izar ipurume'eg wi wer hehe nehe, omono putar hekuzar xaxeto pe nehe. Umuza'ak putar hekuzar 5 ipehegwer romo nehe. Omono putar amo ipehegwer xaxeto pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Aze amo omono uiwypehegwer wa'yr pe nehe, aze ta'yr iporomono wer ipehegwer rehe Tupàn Tuweharupi Wiko Ma'e pe nehe, xaxeto ume'e putar hehe nehe. — Màràn ma'eà'yz amo uzutym putar hehe wà nehe, i'i putar hehe upuranu pà nehe. Na'e umume'u putar hekuzar nehe. Aze amo uzutym putar 100 kir xewar hehe nehe, izarer omono putar 570 kàràm parat hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Aze omono a'e ywy pehegwer Tupàn pe kwarahy purumuhem kar haw rehe nehe, umume'u putar hekuzar uhua'u wera'u ma'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Aze upaw kwarahy purumuhem kar haw nehe, xaxeto wexak putar hekuzar nehe. — Màràn kwarahy heta we a'e kwarahy 'ym mehe we, i'i putar nehe. Nezewe mehe hekuzar nuhua'u kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Aze ywypehegwer izarer ipurume'eg kar wi wer hehe nehe, omono putar hekuzar imume'u pyrer nehe. Umuza'ak putar hekuzar 5 ipehegwer romo nehe. Omono putar amo ipehegwer xaxeto pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Aze na'ipurume'eg kar wer kwaw hehe nehe, aze ru'u amo ume'eg kar nehe, izarer nupuner kwaw ime'eg kar haw rehe amo 'ar mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kwarahy purumuhem kar haw rehe a'e ywy izar 'ym ma'e romo uzeapo mehe xaxeto omono putar Tupàn Tuweharupi Wiko Ma'e pe nehe. Ywypehegwer Tupàn pe imonokatu pyrer romo a'e nehe. Xaxeto wiko putar izar romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Aze amo ume'eg kar amo ywypehegwer nehe, aze a'e re omono Tupàn Tuweharupi Wiko Ma'e pe nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Xaxeto upapar putar ywypehegwer hekuzar nehe. — Màràn kwarahy heta we a'e kwarahy 'ym mehe we, i'i putar nehe. Nezewe mehe umume'u putar hekuzar nehe. A'e 'ar mehe we awa omono putar hekuzar paw nehe. Omono putar hekuzar Tuweharupi Wiko Ma'e pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Inugwer kwarahy purumuhem kar haw rehe a'e ywy izarer uzewyr putar izar romo wiko pà nehe. Izypy mehe tu umur izupe a'e. ");
INSERT INTO gubBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Xaxeto ume'e putar pape rehe ma'e hekuzar paw imume'u mehe nehe. Heta putar pitài temetarer tàtà ma'e ikatu ma'e nehe. Xikuru her romo a'e. Pitài xikuru nuzawy kwaw 20 zera. ");
INSERT INTO gubBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Aze amo umugakwaw ma'ea'yr nehe, imemyr ipy wiko putar Tupàn Tuweharupi Wiko Ma'e ima'e romo wà nehe: tapi'ak kuzà imemyr, àràpuhàràn hawitu ma'e kuzà imemyr, àràpuhàrànete kuzà imemyr. Ni amo nupuner kwaw imono haw rehe Tuweharupi Wiko Ma'e pe wà nehe, ta'e a'e ae wiko izar romo a'e 'ar mehe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Aze a'e ma'ea'yr ihy wiko ikatu 'ym ma'e romo Tupàn henataromo nehe, amo upuner imemyr ime'eg kar haw rehe nehe. Omono putar hekuzar pape rehe imuapyk pyrer rupi nehe. Umuza'ak putar hekuzar 5 ipehegwer romo nehe. Omono putar pitài ipehegwer xaxeto pe nehe no. Aze nume'eg kar kwaw nehe, xaxeto upuner ime'egaw rehe hekuzar rupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Wyzài ma'e nehe, wyzài ma'ea'yr nehe, wyzài teko nehe, aze amo omono Tupàn Tuweharupi Wiko Ma'e pe nehe, ni amo nupuner kwaw ime'egaw rehe wà nehe. Uzeapo ikatuahy ma'e romo a'e. Tuweharupi Wiko Ma'e wiko izar romo. ");
INSERT INTO gubBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aze tuwihaw umume'u amo teko Tupàn pe imono pyrer izuka àwàm nehe, ni amo nupuner kwaw ime'egaw rehe wà nehe. Pezuka nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Aze teko omono'og 10 arozràn hyru por wà nehe, omono putar pitài Tupàn Tuweharupi Wiko Ma'e pe wà nehe. Aze opo'o 10 ma'e'a kwer wà nehe, omono putar pitài izupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Aze izarer ipurume'eg kar wer a'e imono pyrer ikurer rehe nehe, omono putar hekuzar ma'eme'egaw pe har hekuzaromo nehe. Umuza'ak putar hekuzar 5 ipehegwer romo nehe. Omono putar pitài ipehegwer xaxeto pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Aze heta 10 ma'ea'yr teko wanehe we wiko ma'e wà nehe, Tupàn Tuweharupi Wiko Ma'e wiko putar pitài a'e ma'ea'yr izar romo a'e nehe, ");
INSERT INTO gubBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","aze ikatu nehe, aze na'ikatu kwaw nehe. Izar nupuner kwaw amo ma'ea'yr imono haw rehe hekuzaromo nehe. Aze omono amo hekuzaromo nehe, Tupàn wiko putar a'e mokoz ma'ea'yr wazar romo a'e nehe. Ni amo nupuner kwaw ime'eg kar haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Amumaw a'e ze'eg imume'u haw kwez xe kury. Tupàn Tuweharupi Wiko Ma'e omono a'e uze'eg Moizez pe Xinaz ywytyr rehe a'e. — Emono ko heze'eg teko Izaew izuapyapyr wanupe nehe, i'i izupe. Upaw. ");
INSERT INTO gubBl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Izaew izuapyapyr oho Ezit ywy wi wà. Umumaw mokoz kwarahy wata pà wà. Mokoz haw zahy rehe pitài haw 'ar mehe Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe ywyxiguhu Xinaz her ma'e rehe tàpuzràn Tupàn pe imonokatu pyrer pupe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","— Ne nehe, neryky'yr Àràw a'e nehe no, pepapar teko Izaew izuapyapyr paw pe wà nehe. Pemono'og uzeànàànàm ma'e pe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Pemuapyk awa waner pape rehe nehe, aze wereko 20 kwarahy nehe, aze wereko wera'u nehe. A'e mehe upuner zauxiapekwer romo weko haw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Penoz putar amo uzeànàm ma'e wanuwihaw pitàitàigatu pe wà nehe. Pepytywà putar wemiaihu wapapar pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Na'aw awa penemipytywà àràm waner xe wà. Izypy mehe amume'u putar Izaew ta'yr her nehe. A'e re amume'u putar izuapyr her nehe no. Humen: Erizur, Xeneur ta'yr. Ximeàw: Xerumiew, Zurixanaz ta'yr. Zuta: Nazom, Aminanaw ta'yr. Ixakar: Netanew, Zuar ta'yr. Zemurom: Eriaw, Erom ta'yr. Eparai: Erizàm, Amiu ta'yr. Manaxe: Kamariew, Penazur ta'yr. Mezàmi: Aminà, Zineoni ta'yr. Nà: Aiezer, Amizanaz ta'yr. Azer: Paziew, Okirà ta'yr. Kaz: Eriazap, Newew ta'yr. Napitari: Aira, Enà ta'yr. Amumaw waner wamume'u haw kwez kury. Moizez wexaexak Izaew izuapyapyr wanuwihaw pitàitàigatu wà, uzeànàànàm ma'e wanekuzaromo har romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Na'e mokoz haw zahy rehe pitài haw 'ar mehe Moizez a'e, Àràw a'e no, a'e 12 awa a'e wà nehe no, omono'og teko paw rupi wà kury. Upapar uzeànàànàmaw waneta haw wà. Umuapyk awa zauxiapekwer romo weko haw rehe upuner ma'e waner pape rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Nezewe Moizez upapar waneta haw ywyxiguhu Xinaz her ma'e rehe waneko mehe, Tupàn Tuweharupi Wiko Ma'e ize'eg awer rupi katete a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Awa 20 henataromo kwarahy hereko har zauxiapekwer romo weko haw rehe upuner ma'e umuapyk kar uwer paw rupi pape rehe wà, wànàm wanehe we wà, wamono'ogaw rehe we wà. Uzypyrog Humen Zako ta'yr ipy izuapyapyr wanehe we wà. Na'aw Zako ta'yr izuapyapyr waneta haw xe. Humen izuapyapyr wà: 46.500 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Ximeàw izuapyapyr wà: 59.300 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Kaz izuapyapyr wà: 45.650 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Zuta izuapyapyr wà: 74.600 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Ixakar izuapyapyr wà; 54.400 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zemurom izuapyapyr wà: 57.400 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Eparai izuapyapyr wà: 40.500 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Manaxe izuapyapyr wà: 32.200 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Mezàmi izuapyapyr wà: 35.400 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Nà izuapyapyr wà: 62.700 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Azer izuapyapyr wà: 41.500 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Napitari izuapyapyr wà: 53.400 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","46","Nezewe mehe upapar awa 20 henataromo kwarahy hereko har zauxiapekwer romo weko haw rehe upuner ma'e wà. Heta 603.550 wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Nupapar kwaw Erewi izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ta'e Tupàn Tuweharupi Wiko Ma'e uze'eg nezewe Moizez pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","— Aw zauxiapekwer romo weko haw rehe upuner ma'e wapapar mehe epapar zo Erewi izuapyapyr ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Emuzekaiw kar Erewi izuapyapyr tàpuzràn ihewe imonokatu pyrer rehe ne wà nehe. Uzekaiw putar tenaw ipupe har nànàn wà nehe, amo ma'e ipupe har nànàn no. Weraha putar tàpuzràn wà nehe, hehe we har paw wà nehe no. Uzapo putar hemuwete haw ipupe wà nehe. Umuapyk putar wàpuzràn izywyr wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Aze weraha tàpuzràn ihewe imonokatu pyrer amo me wà nehe, umuàgà'ym putar wà nehe. Aze umuapyk wi amo me nehe, umuàgà'ym wi putar wà nehe no. Aze amo nuiko kwaw Erewi izuapyr romo nehe, aze uhem tàpuzràn ihewe imonokatu pyrer huwake nehe, pezuka nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Amogwer Izaew izuapyapyr upyta putar weko haw pe pitàitàigatu wà nehe, pànuhu ter heta haw huwake wà nehe, wànàm wanuwake wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Erewi izuapyapyr wiko putar tàpuzràn ihewe imonokatu pyrer izywyr wà nehe, hehe uzekaiw pà wà nehe. Nezewe mehe ni amo nuhem kwaw huwake wà nehe. Nezewe mehe naikwahy kwaw Izaew wanupe ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Na'e teko uzapo ma'e paw Tupàn Tuweharupi Wiko Ma'e ize'eg Moizez pe imono pyrer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe, Àràw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Izaew uker haw imuàgà'ym mehe pitàitàigatu upyta putar pànuhu ter heta haw huwake wà nehe, wànàm waner hereko har huwake wà nehe. Uzapo putar weko haw tàpuzràn Tupàn pe imonokatu pyrer izywyr wà nehe. Wanàpuzràn paw ume'e putar tàpuzràn Tupàn pe imonokatu pyrer kutyr wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","Kwarahy ihemaw kutyr zauxiapekwer pànuhu Zuta her hereko har izywyr wata ma'e uzapo putar weko haw wà nehe. Heta 74.600 awa wà. Nazom Aminanaw ta'yr wiko wanuwihaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Wanuwake pànuhu Ixakar her hereko har izywyr wata ma'e uzapo putar weko haw wà nehe. Heta 54.400 awa wà. Netanew Zuar ta'yr wiko wanuwihaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Zauxiapekwer pànuhu Zemurom her hereko har izywyr wata ma'e uzapo putar weko haw wanuwake wà nehe. Heta 57.400 awa wà. Eriaw Erom ta'yr wiko wanuwihaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Zuta izuapyapyr wata putar amogwer wanenataromo wà nehe. Heta 186.400 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","Pànuhu Humen izuapyapyr waner hereko har haikweromo wata ma'e uzapo putar uker haw kwarahy ihemaw awyze har kutyr wà nehe. Heta 46.500 awa zauxiapekwer Humen izuapyapyr wainuinuromo wà. Erizur Xeneur ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","Ximeàw izuapyapyr zauxiapekwer uzapo putar uker haw Humen wanuwake a'e wà nehe. Heta 59.300 awa zauxiapekwer Ximeàw izuapyapyr wainuinuromo wà. Xerumiew, Zurixanaz ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Kaz izuapyapyr zauxiapekwer uzapo putar uker haw Ximeàw wanuwake a'e wà nehe. Heta 45.650 awa zauxiapekwer Kaz izuapyapyr wainuinuromo wà. Eriazap, Neuew ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Humen rehe we har zauxiapekwer wata putar wanaikweromo wà nehe. Heta 151.450 awa zauxiapekwer wamono'og pyrer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Erewi izuapyapyr wata putar mokoz zauxiapekwer wamono'ogaw amogwer wanenataromo wata ma'e wanehe we wà nehe no. Weraha putar tàpuzràn Tupàn pe imonokatu pyrer wà nehe. Imono'og pyrer uzapo putar uker haw uzeakeake wà nehe. Wata putar uzeakeake nezewegatete wà nehe no. Pitàitàigatu upyta putar wenaw rehe upyta haw rehe wà nehe, pànuhu ter hereko har huwake wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","Pànuhu Eparai izuapyapyr waner hereko har haikweromo wata ma'e uzapo putar uker haw kwarahy heixe haw kutyr wà nehe. Heta 40.500 awa zauxiapekwer Eparai izuapyapyr wainuinuromo wà. Erizàm, Amiu ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Manaxe izuapyapyr zauxiapekwer uzapo putar uker haw Eparai wanuwake a'e wà nehe. Heta 32.200 awa zauxiapekwer Manaxe izuapyapyr wainuinuromo wà. Kamariew, Penazur ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Mezàmi izuapyapyr zauxiapekwer uzapo putar uker haw Manaxe wanuwake a'e wà nehe. Heta 35.400 awa zauxiapekwer Mezàmi izuapyapyr wainuinuromo wà. Aminà, Zineoni ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Eparai rehe we har zauxiapekwer wata putar Mezàmi wanaikweromo wà nehe. Heta 18.100 awa zauxiapekwer wamono'og pyrer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","Pànuhu Nà izuapyapyr waner hereko har haikweromo wata ma'e uzapo putar uker haw kwarahy heixe haw awyze har kutyr wà nehe. Heta 62.700 awa zauxiapekwer Nà izuapyapyr wainuinuromo wà. Aiezer, Amizanaz ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Azer izuapyapyr zauxiapekwer uzapo putar uker haw Nà wanuwake a'e wà nehe. Heta 41.500 awa zauxiapekwer Azer izuapyapyr wainuinuromo wà. Paziew, Okirà ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Napitari izuapyapyr zauxiapekwer uzapo putar uker haw Azer wanuwake a'e wà nehe. Heta 53.400 awa zauxiapekwer Napitari izuapyapyr wainuinuromo wà. Aira, Enà ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Nà rehe we har zauxiapekwer wata putar iahykaw rehe wà nehe. Heta 157.600 awa zauxiapekwer wamono'og pyrer wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Umuapyk awa Izaew izuapyapyr zauxiapekwer waner wà, uzehe we uzemono'og ma'e waner waiwyr paw rupi wà. Heta 63.550 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Moizez nupapar kwaw Erewi izuapyapyr amogwer Izaew izuapyapyr wainuinuromo wà, ta'e Tupàn Tuweharupi Wiko Ma'e nupapar kar kwaw izupe wà xe. ");
INSERT INTO gubBl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Nezewe teko Izaew izuapyapyr uzapo ma'e paw Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imono pyrer rupi katete wà. Uzapo uker haw wà. Pitàitàigatu imono'og pyrer upyta pànuhu ter hereko har iwy pe wà. Izaew izuapyapyr uzypyrog wànàm imono'og pyrer rupi wata pà pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe Xinaz ywytyr rehe a'e. A'e 'ar mehe heta amo Àràw izuapyapyr wà. Heta amo Moizez izuapyapyr wà no. Amume'u putar waner xe ihe wà nehe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Na'aw Àràw ta'yr waner xe wà: Nanaw ta'yr ipy. Amiu, Ereazar, Itamar. ");
INSERT INTO gubBl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Moizez uzakook uri kawer wanehe xaxeto romo wamuigo kar pà a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nanaw a'e, Amiu a'e no, umunyk tata Tupàn henataromo ize'eg heruzar 'ym pà wà. A'e rupi Tupàn uzuka a'e pe wà. Nata'yr kwaw wikuwe mehe wà. A'e rupi xo Ereazar Itamar rehe we zo wiko xaxeto romo Àràw hekuwe mehe a'e wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Enoz Erewi izuapyapyr wamuwà ne wà nehe. Epytywà kar Àràw wanupe Tupàn imuwete haw iapo mehe ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Uzapo putar ma'ereko haw paw tàpuzràn Tupàn pe imonokatu pyrer pupe wà nehe. Upytywà putar xaxeto wà nehe. Upytywà putar teko paw wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Uzekaiw putar ywyrapew tàpuzràn Tupàn pe imonokatu pyrer pupe har nànàn wà nehe, amogwer ma'e ipupe har nànàn wà nehe no. Uzapo putar Tupàn imuwete haw Izaew wanehe we har paw rupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Erewi izuapyapyr uzapo putar xo pitài ma'e zo wà nehe. Upytywà putar Àràw wà nehe, upytywà putar izuapyapyr wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","— Xo xaxeto wama'ereko haw rehe zo pezekaiw nehe, ere Àràw pe nehe, izuapyapyr wanupe nehe no. Aze wyzài awa uzeagaw a'e ma'ereko haw iapo pà nehe, pezuka a'e awa nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Tupàn Tuweharupi Wiko Ma'e uze'eg wi Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","Erewi izuapyapyr wiko heremiruze'eg romo wà kury. Ezit wana'yr ipy wazuka mehe amonokatu Izaew wana'yr ipy hezeupe ihe wà. Amonokatu waneimaw wana'yr ipy hezeupe ihe wà no. Ko 'ar rehe napyhyk kwaw Izaew izuapyapyr wana'yr ipy ihe wà. Apyhyk Erewi izuapyapyr wana'yr ihe wà kury. Wiko heremiruze'eg romo wà. Aiko wazar romo ihe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Xinaz ywyxiguhu rehe Tupàn Tuweharupi Wiko Ma'e uzapo kar ma'e Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","— Emuapyk Erewi izuapyapyr waner pape rehe ne wà nehe, waànàm waner wanehe we wà nehe, waànàm imono'og pyrer waner wanehe we wà nehe, aze awa romo wiko wà nehe, aze wereko pitài zahy henataromo wà nehe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Na'e Moizez uzapo Tupàn Tuweharupi Wiko Ma'e hemiapo kar teko wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Heta na'iruz Erewi ta'yr wà. Zeroxon, Koat, Merari waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","20","Upurumuzàmuzàg tetea'u wà. Wazuapyapyr wereko uipy waner wà. Zeroxon wereko mokoz wa'yr wà: Irimini. Ximez. Koat wereko 4 wa'yr wà: Ànàràw, Izar, Emerom, Uziew. Merari wereko mokoz wa'yr wà: Mari, Muzi. Upurumuzàmuzàg wà. Wazuapyapyr wereko waner wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Zeroxon izuapyapyr uzemuza'ak mokoz romo wà: Irimini, Ximez waner romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Pitàitàigatu upapar awa pitài zahy henataromo hereko har wà. Heta 7.500 wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","A'e imono'og pyrer uzapo uker haw tàpuzràn Tupàn pe imonokatu pyrer ikupe kutyr kwarahy heixe haw kutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Eriazap Araew ta'yr wiko a'e uzeànàànàm ma'e imono'og pyrer wanuwihaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Zeroxon izuapyapyr uzekaiw tàpuzràn Tupàn pe imonokatu pyrer rehe wà: ipykaw rehe, ipykaw iwype har rehe, ");
INSERT INTO gubBl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","pànuhu katu pe har rehe, pànuhu teixe haw pe har rehe, pànuhu tàpuzràn Tupàn pe imonokatu pyrer izywyr har katu pe har rehe, pànuhu ma'ea'yr hapy haw izywyr har rehe, pànuhu katu pe har ukenaw rehe har rehe, ihàm rehe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Heta 4 uzeànàànàm ma'e Koat rehe we imono'og pyrer pe wà: Ànàràw izuapyapyr wà, Izar izuapyapyr wà, Emerom izuapyapyr wà, Uziew izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Upapar awa pitài zahy henataromo hereko har wà. Heta 8.600 wà. A'e awa uzekaiw tàpuzràn Tupàn pe imonokatu pyrer rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","A'e imono'og pyrer Koat her hereko har uzapo uker haw tàpuzràn Tupàn pe imonokatu pyrer huwake kwarahy ihemaw awyze har kutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Erizàpà Uziew ta'yr wiko a'e uzeànàànàm ma'e imono'og pyrer wanuwihaw romo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Uzekaiw ko ma'e rehe wà: Tupàn Ze'eg Hyru rehe, ywyrapew zàwenugar rehe, tatainy henaw rehe, ma'ea'yr hapy haw rehe, inugwer ma'e hapy haw rehe, ma'e Tupàn henaw ikatu ma'e pupe har rehe, pànuhu Tupàn henaw ikatuahy ma'e pe teixe haw rehe har rehe. Uzekaiw a'e ma'ereko haw nànàn wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ereazar xaxeto Àràw ta'yr wiko Erewi izuapyapyr wanuwihaw wanuwihaw romo a'e. Wiko Tupàn henaw ikatu ma'e pupe uma'ereko ma'e wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Heta mokoz uzeànàànàm ma'e Merari rehe we imono'og pyrer pe wà: Mari izuapyapyr wà, Muzi izuapyapyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Upapar awa pitài zahy henataromo hereko har wà. Heta 6.200 wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Zuriew Amiaiw ta'yr wiko a'e uzeànàànàm ma'e imono'og pyrer Merari rehe we har wanuwihaw romo a'e. Merari her hereko har uzapo uker haw tàpuzràn Tupàn pe imonokatu pyrer izywyr kwarahy heixe haw awyze har kutyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Uzekaiw ko ma'e rehe wà: ywyrapew tàpuzràn Tupàn pe imonokatu pyrer rehe har rehe, ywyra tàpuz iapyteraromo har rehe, izyta rehe, iwype har rehe, ipupe har nànàn. ");
INSERT INTO gubBl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Uzekaiw izyta katu pe har tàpuzràn Tupàn pe imonokatu pyrer izywyr har rehe wà, iwype har rehe wà no, izyta rehe wà no, ihàm rehe wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moizez a'e, Àràw a'e no, wana'yr a'e wà no, uzapo uker haw tàpuzràn Tupàn pe imonokatu pyrer henataromo a'e wà, kwarahy ihemaw kutyr a'e wà. Uzekaiw Tupàn imuwete haw henaw ikatu ma'e pupe har rehe wà, teko Izaew izuapyapyr wanekuzaromo wà. Aze mo amo awa uzeagaw a'e ma'ereko haw iapo pà, teko uzuka mo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","— Emuapyk Erewi izuapyapyr waner pape rehe ne wà nehe, waànàm waner wanehe we wà nehe, waànàm imono'og pyrer waner wanehe we wà nehe, aze awa romo wiko wà nehe, aze wereko pitài zahy henataromo wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe, Àràw pe. Weruzar katu ize'eg wà. Heta 22.000 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. — Emuapyk Izaew wana'yr ipy waner pape rehe ne wà nehe, aze heta pitài zahy henataromo wà nehe. Ta'e paw rupi wiko hema'e romo wà xe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nezewe rehe we amono putar Erewi izuapyapyr paw wanekuzaromo ihe wà nehe, hema'e romo ihe wà nehe. Aiko Tupàn Tuweharupi Wiko Ma'e romo. Emono Erewi waneimaw amogwer Izaew waneimaw wana'yr ipy wanekuzaromo wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","A'e rupi Moizez umuapyk Izaew wana'yr ipy waner pape rehe wà, Tupàn Tuweharupi Wiko Ma'e ze'eg rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Upapar awa pitài zahy henataromo hereko har paw rupi wà. Heta 22.273 wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Emono Erewi izuapyapyr Izaew wana'yr ipy wanekuzaromo ne wà nehe. Emono waneimaw amogwer Izaew waneimaw wanekuzaromo ne wà nehe no. Erewi izuapyapyr wiko hema'e romo wà. Aiko Tupàn Tuweharupi Wiko Ma'e romo. ");
INSERT INTO gubBl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Heta tetea'u wera'u Izaew wana'yr ipy wà, Erewi wana'yr wanuwi wà. Heta we 273 wà. Emekuzar upyta we ma'e kwer ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","48","Emur putar 5 temetarer tàtà parat iapo pyrer wanekuzaromo pitàitàigatu nehe. Eremono putar a'e temetarer Àràw pe nehe, ta'yr wanupe nehe. A'e 'ym mehe tuwihaw umuapyk temetarer tàtà hekuzar pape rehe wà. Teko paw ukwaw hekuzar wà. Pitài temetarer tàtà xikuru her ma'e nuzawy kwaw 20 temetarer zera her ma'e wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Na'e Moizez upyhyk a'e temetarer parat kury. ");
INSERT INTO gubBl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","15 kir pitài iku'aw har rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Omono Àràw pe ta'yr wanupe Tupàn Tuweharupi Wiko Ma'e ze'eg rupi katete. ");
INSERT INTO gubBl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Epapar Erewi izuapyr Koat her ma'e izuapyapyr ne wà nehe. Emono'og uzeànàànàm ma'e ne wà nehe, imono'og pyr nànàn ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Emuapyk awa 30 kwarahy hereko har te 50 kwarahy hereko har tàpuzràn ihewe imonokatu pyrer pupe uma'ereko haw rehe upuner ma'e ràm waner ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Koat izuapyapyr uzekaiw putar ma'e herenataromo ikatuahy ma'e tàpuzràn ihewe imonokatu pyrer rehe a'e wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Waker haw imuhàz mehe Àràw a'e nehe, ta'yr a'e wà nehe no, wixe putar a'e tàpuzràn pupe wà nehe. Wenuhem putar pànuhu heze'eg hyru henataromo har wà nehe. Upyk putar heze'eg hyru ipupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Na'e upyk putar a'e ma'e paw ipykaw ma'ea'yr pirer ikatuahy ma'e iapo pyrer pupe wà nehe. Na'e upyk putar a'e ma'e paw pàn huwyahy ma'e pupe wà nehe. Na'e umuixe kar ihàm iapu'a ma'e wanupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Omono putar pàn huwyahy ma'e ywyrapew typy'ak ihewe imur pyr hereko har rehe wà nehe. Na'e omono putar tàpuzràn rehe har hehe wà nehe: kawaw, kanekuhu yhyk zàwenugar hyru, kanekuhu ma'e imur pyr hyru, zutahyky'a win imur pyr hyru. Heta putar typy'ak a'e ywyrapew rehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Na'e upyk putar a'e ma'e paw pàn ipiràg ma'e pupe wà nehe. I'aromo omono putar ipykaw ma'ea'yr ipirer pupe iapo pyrer wà nehe. Na'e umuixe kar putar ihàm iapu'a ma'e wanupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Upyhyk putar pàn huwyahy ma'e wà nehe. Upyk putar amo ma'e ipupe wà nehe: tatainy henaw, tatainy, zepinaw tatainy ihàm imonohokaw, imuwew haw, zapepo uri kawer hyru. ");
INSERT INTO gubBl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Na'e uwàuwàn putar a'e ma'e paw ma'ea'yr ipirer ikatuahy ma'e pupe wà nehe. Na'e omono putar i'yw a'e ma'e paw wanehe wà nehe. Upyhyk putar i'yw heraha mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Omono putar amo pàn huwyahy ma'e ma'ea'yr hapy haw or iapo pyrer rehe wà nehe. Omono putar ipykaw ma'ea'yr ipirer ikatuahy ma'e iapo pyrer hehe wà nehe. Na'e umuixe kar putar ma'ea'yr hapy haw i'yw iapu'a ma'e rupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Na'e upyhyk putar ma'e herenaw ikatuahy ma'e pupe har paw wà nehe. Uwàuwàn putar pàn huwyahy ma'e pupe wà nehe. Upyk putar ipykaw ma'ea'yr ipirer ikatuahy ma'e iapo pyrer pupe wà nehe. Omono putar i'yw rehe heraha àwàm rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Wenuhem putar tanimuk ma'ea'yr hapy haw wi wà nehe. A'e re upyk putar ma'ea'yr hapy haw pàn ipiràg ma'e pupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Omono putar ma'e ma'ea'yr hapy haw rehe har paw hehe wà nehe: tàtàpyzgwer ipyhykaw, kuzeràxi aze ru'u kuzehu ywy momor haw, kawawhu. Upyk putar ipykaw ma'ea'yr ipirer ikatuahy ma'e iapo pyrer pupe wà nehe. Na'e omono putar i'yw ma'ea'yr hapy haw rehe iapu'a rupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Uker haw imuhàz mehe Koat izuapyapyr ur putar ma'e Tupàn pe imonokatu pyr ipyhyk pà wà nehe. Àràw a'e, ta'yr a'e wà, upyk putar tàpuzràn Tupàn pe imonokatu pyrer wà. Upyk putar ma'e ipupe har paw wà nehe no. Xo a'e re Koat izuapyapyr upyhyk putar wà nehe. Koat izuapyapyr nopokok kwaw ma'e Tupàn pe imonokatu pyrer rehe wà nehe. Aze opokok amo rehe wà nehe, umàno putar wà nehe. Koat izuapyapyr weraha putar a'e ma'e tàpuzràn Tupàn pe imonokatu pyrer pupe har wà nehe, teko wata mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ereazar xaxeto Àràw ta'yr a'e nehe, wiko putar ko ma'e rehe uzekaiw ma'e romo a'e nehe: tàpuzràn Tupàn pe imonokatu pyrer, uri kawer tatainy ipor, yhyk zàwenugar, arozràn imur pyrer, uri kawer purehe izakook pyràm. A'e ae wiko putar tàpuzràn rehe uzekaiw ma'e romo nehe, ipupe har rehe uzekaiw ma'e romo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe Àràw pe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Emumàno kar zo Koat iànàm ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Aze uhem a'e ma'e ihewe imur pyrer huwake wà nehe, umàno putar wà nehe. Àràw a'e nehe, ta'yr a'e wà nehe no, wixe putar tàpuzràn Tupàn pe imonokatu pyrer pupe wà nehe. Uze'eg putar awa wanupe pitàitàigatu wà nehe. Nezewe mehe pitàitàigatu ukwaw putar wemiapo ràm wà nehe. Ukwaw putar wemiraha ràm wà nehe. Nezewe mehe numàno kwaw wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Koat izuapyapyr nuixe pixik kwaw ma'e ihewe imur katu pyrer hexak pà wà nehe. Aze wexak wà nehe, umàno putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Epapar Zeroxon izuapyapyr ne wà nehe. Emono'og uzeànàànàm ma'e ne wà nehe, imono'og pyr nànàn ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Aze awa wereko 30 te 50 kwarahy nehe, emuapyk her pape rehe nehe, aze upuner tàpuzràn Tupàn pe imonokatu pyrer pupe uma'ereko haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Zeroxon izuapyapyr uma'ereko putar tàpuzràn Tupàn pe imonokatu pyrer pupe wà nehe, ipuhuz ma'e heraha pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Weraha putar ko ma'e wà nehe: tàpuzràn, ipykaw ipupe har, ipykaw ikupe pe har, ipykaw ma'ea'yr ipirer iapo pyrer, pànuhu teixe haw pe har. ");
INSERT INTO gubBl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Weraha putar amo ma'e wà nehe no: pànuhu katu pe har, pànuhu ukenaw katu pe har rehe har tàpuzràn izywyr har ma'ea'yr hapy haw izywyr har, ihàm, ma'e uma'ereko haw rehe har paw. ");
INSERT INTO gubBl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Uma'ereko haw paw iapo mehe Zeroxon izuapyapyr weruzar putar Àràw wà nehe, ta'yr wà nehe, ma'e heraha mehe wà nehe, ma'e iapo mehe wà nehe. Àràw umume'u putar wanemiraha ràm paw wanupe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Zeroxon izuapyapyr imono'og pyrer uzapo putar a'e ma'ereko haw tàpuzràn pupe wà nehe. Itamar Àràw ta'yr wiko putar wanuwihaw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","— Epapar Erewi ta'yr Merari izuapyapyr ne wà nehe, i'i Tupàn Tuweharupi Wiko Ma'e Moizez pe. Emono'og uzeànàànàm ma'e ne wà nehe, imono'og pyr nànàn ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Aze awa wereko 35 kwarahy nehe, emuapyk her pape rehe nehe, aze upuner tàpuzràn Tupàn pe imonokatu pyrer pupe uma'ereko haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Uze'eg Tupàn. — Uma'ereko putar tàpuzràn ihewe imonokatu pyrer pupe wà nehe. Na'aw wanemiraha tàpuzràn rehe har xe: ywyrapew, kyhàhàm, izyta, iwype har, ");
INSERT INTO gubBl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","izyta katu pe har tàpuzràn izywyr har, ipupe har, izyta'i, kyhàhàm, ma'e uma'ereko haw rehe har paw. Emuapyk wanemiraha ràm paw pape rehe wanupe imono pà pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari izuapyapyr uzemono'og ma'e uzapo putar a'e ma'e tàpuzràn ihewe imonokatu pyrer rehe har wà nehe, uma'ereko haw wà nehe. Itamar Àràw ta'yr wiko putar wanuwihaw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Moizez a'e, Àràw a'e no, teko wanuwihaw a'e wà no, weruzar Tupàn Tuweharupi Wiko Ma'e ze'eg a'e wà kury. Upapar Erewi ta'yr wazuapyapyr a'e wà. Koat, Zeroxon, Merari. Omono'og uzeànàànàm ma'e wà, imono'og pyr nànàn wà. Aze awa wereko 35 kwarahy, aze upuner tàpuzràn Tupàn pe imonokatu pyrer pupe uma'ereko haw rehe, umuapyk her pape rehe wà. Heta 2.750 awa Koat izuapyapyr wà. Heta 2.630 awa Zeroxon izuapyapyr wà. Heta 3.200 awa Merari izuapyapyr wà. Aze uzemono'og paw rupi wà, heta 8.580 awa wà. ");
INSERT INTO gubBl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Umuapyk a'e awa waner pape rehe Tupàn Tuweharupi Wiko Ma'e ze'eg rupi katete wà. Moizez umume'u wanemiapo ràm wanupe pitàitàigatu a'e. Umume'u hemiraha ràm wanupe pitàitàigatu no. Upapar a'e awa Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imono pyrer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","— Pemuhem kar agwer ima'eahy ma'e peneko haw wi pe wà nehe, ere teko wanupe nehe: iperewahy ma'e, ipewer awa ima'e wi uhem ma'e hereko har, umàno ma'e kwer rehe opokok ma'e kwer herenataromo ikatu 'ym ma'e romo uzemuigo kar ma'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Pemono kar ikatu 'ym ma'e peneko haw wi pe wà nehe, awa wà nehe, kuzà wà nehe. Nezewe mehe napemuaiw kwaw hereko haw nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izaew izuapyapyr weruzar Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imono pyrer wà. Omono kar a'e teko paw weko haw wi wà. ");
INSERT INTO gubBl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Emume'u ko heze'eg Izaew wanupe nehe. — Awa a'e nehe, kuzà a'e nehe no, aze uzapo ikatu 'ym ma'e amo pe nehe, ikatu 'ym ma'e uzapo putar iko Tupàn Tuweharupi Wiko Ma'e pe nehe. Wiko putar ikatu 'ym ma'e iapo har romo Tupàn henataromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Tuwe umume'u wemiapo kwer nehe. Umuzewyr kar putar hemipyro kwer izar kwer pe nehe. Umuza'ak putar wemipyhyk kwer 5 pehegwer romo. Umuzewyr we putar amo pitài ipehegwer ipuraraw har pe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Aze a'e teko umàno nehe, aze naheta kwaw iànàmete a'e temetarer ipyhyk àràm romo nehe, a'e mehe ikatu 'ym ma'e iapo arer omono putar a'e temetarer Tupàn Tuweharupi Wiko Ma'e pe nehe. Xaxeto wiko putar temetarer izar romo nehe. Omono putar hekuzar izupe nehe. Omono putar àràpuhàràn hawitu ma'e xaxeto pe nehe no. Xaxeto omono putar àràpuhàràn Tupàn pe henataromo izuka pà nehe, a'e ma'e iapo arer hemiapo kwer imunàn kar pà Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Aze amo Izaew iporomono wer amo ma'e rehe Tupàn pe nehe, omono putar a'e ma'e xaxeto pe nehe. A'e xaxeto wiko putar a'e ma'e izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Aze amo werur ma'e xaxeto pe nehe, a'e xaxeto wiko putar a'e ma'e izar romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Eze'eg Izaew izuapyapyr wanupe nehe, ko heze'eg imume'u pà wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Aze ru'u amo kuzà uzawy wape umen 'ym puhe oho pà nehe. Nezewe mehe wiko ikatu 'ym ma'e herenataromo nehe. Imen nukwaw kwaw hemiapo kwer a'e. Ni amo nuexak kwaw wà. Ni amo nuhem kwaw a'e pe iapo mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Nezewe rehe we imen uzemupy'a. Aze ru'u kuzà noho kwaw umen 'ym puhe. Aze ru'u nezewe rehe we imen uzemupy'a. — Uker ru'u aipo amo ipuhe, i'i putar uzeupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Wyzài 'ar mehe a'e awa weraha putar wemireko xaxeto pe nehe. Weraha putar pitài kir arozràn xewar her ma'e imuku'i pyrer Tupàn pe imono pyràm romo nehe no. Xaxeto nomono kwaw uri kawer inuinuromo nehe. Nomono kwaw yhyk zàwenugar hehe nehe. Ta'e a'e ma'e a'e xe, kuzà imen uzemupy'a ma'e hemimono romo a'e xe. Azeharomoete har uzeupe ikwaw kar haw romo werur a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Xaxeto weraha a'e kuzà pepa'i imen wi ma'ea'yr Tupàn Tuweharupi Wiko Ma'e pe izuka haw henataromo imupu'àm kar pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Uzakook putar 'y Tupàn henataromo imukatu pyrer ywy'a pupe nehe. Upyhyk putar ywy opo ipor tàpuzràn Tupàn pe imonokatu pyrer pupe har nehe no. Omono putar a'e 'y pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kuzà upyta we ma'ea'yr hapy haw henataromo. Xaxeto umu'ar putar i'aw nehe. Omono putar xewar imuku'i pyrer imono pyrer ipo pupe nehe. Ma'e Tupàn pe imono pyr tewyrowyroahy haw rehe har romo a'e. Xaxeto wereko putar ywy'a 'y iro ma'e hereko har opo pupe nehe. A'e 'y werur ze'egaiw purehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","— Emume'uahy ko ze'eg nehe, i'i putar xaxeto kuzà pe nehe. — Hemen wiko hezar romo a'e. Naker kwaw amo awa puhe. Nazapo kwaw ma'e amo awa puhe hezemuaiw kar pà Tupàn henataromo. A'e rupi nuzeapo kwaw ikatu 'ym ma'e ihewe ko 'y iro ma'e i'u mehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Aze neremu'em, aze azeharomoete ereker amo puhe, ereiko ikatu 'ym ma'e romo Tupàn henataromo. ");
INSERT INTO gubBl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","A'e mehe Tupàn Tuweharupi Wiko Ma'e umuaiw putar nerer a'e nehe. Neànàm umume'u putar nerer ze'egaiw amo rehe imono mehe wà nehe. Nerie nememyr iapo haw uxinig putar newi nehe. Nerie hezun putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Tuwe ko 'y wixe nerie pupe imuezun kar pà nehe. Tuwe nerie nememyr iapo haw uxinig newi nehe, i'i putar xaxeto kuzà pe nehe. Na'e kuzà uwazar putar ize'eg izupe nehe. — Tuwe neremimume'u kwer uzeapo ihewe nehe, i'i putar izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Na'e xaxeto umuapyk putar a'e ze'egaiw ma'epirer rehe nehe. A'e re uhez putar a'e ze'eg imuapyk pyrer 'yro pupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","A'e re u'u kar putar a'e 'yro ze'egaiw herur har kuzà pe nehe. Hahy putar tuwe kuzà hie pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","A'e 'ym mehe xaxeto upyro putar arozràn Tupàn pe imono pyr tewyrowyroahy haw rehe har kuzà ipo wi nehe. Upir putar imono pyr Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Weraha putar ma'ea'yr hapy haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Na'e upyhyk putar opo ipor arozràn imono pyrer nehe. Wapy putar ma'ea'yr hapy haw rehe nehe. Nezewe mehe ima'enukwaw a'e ma'e Tupàn pe imono awer rehe a'e nehe. Na'e u'u kar putar a'e 'y kuzà pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Aze kuzà wiko amo awa puhe uker ma'e kwer romo nehe, aze na'ikatu kwaw Tupàn henataromo nehe, a'e 'y wixe putar ipupe nehe. Hahy putar izupe nehe. Hie hezun putar nehe. Hie umemyr iapo haw uxinig putar nehe. Wiko putar ze'egaiw hereko har wànàm wainuinuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Aze kuzà nuiko kwaw amo puhe uker ma'e kwer romo nehe, a'e mehe a'e zepykaw nu'ar kwaw hehe nehe. Upuner umemyr wi haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Amume'u Tupàn ze'eg kuzà imen ma'e amo awa puhe oho ma'e kwer rehe har imen uzemupy'a ma'e rehe har kwez xe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Aze ru'u awa wiko wemireko rehe uzemupy'a e ma'e romo. Weraha putar wemireko ma'ea'yr Tupàn Tuweharupi Wiko Ma'e henataromo izuka haw pe nehe. Xaxeto weruzar putar ko ze'eg nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Imen nuiko kwaw ikatu 'ym ma'e iapo har romo Tupàn henataromo nehe. Aze hemireko wiko tuwe a'e ma'e iapo arer romo nehe, zepykaw u'ar putar imen rehe zutyk a'e nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","— Eze'eg Izaew izuapyapyr wanupe nehe, ko heze'eg imume'u pà wanupe nehe. — Awa a'e nehe, kuzà a'e nehe no, aze uzemume'u nazirew romo nehe, Tupàn Tuweharupi Wiko Ma'e pe uma'ereko ma'e romo nehe, ");
INSERT INTO gubBl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","nu'u kwaw win nehe. Nu'u kwaw kàwiràn xeruwez her ma'e nehe no. Nu'u kwaw wyzài ma'e'a uwà her ma'e itykwer nehe. Nu'u kwaw uwà i'yw wi ipo'o romo pyrer nehe. Nu'u kwaw uwà kwarahy rehe uxinig ma'e kwer nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nazirew romo wiko mehe we nu'u kwaw ma'e uwà 'yw wi ur ma'e kwer nehe: ni hà'yzgwer, ni iapirer. ");
INSERT INTO gubBl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Nazirew romo wiko mehe we nomonohok kwaw u'aw nehe. Nupin kwaw wamutaw nehe no. Uzemonokatu Tupàn pe ma'ereko haw rehe. Xo a'e ma'e zo uzapo putar nehe. Nuzapo kwaw amo ma'e nehe. I'aw ipuku putar tuwe nehe. Nomonohok kwaw nazirew romo wiko mehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","I'awpuku wexak kar putar Tupàn pe imonokatu haw purupe nehe. Tuwe nuzeapo kwaw Tupàn henataromo ikatu 'ym ma'e romo nehe. A'e rupi tuwe nuhem kwaw umàno ma'e kwer huwake nehe. Ni u hetekwer huwake ni uhy hetekwer huwake ni wyky'yr, ni wywyr hetekwer huwake ni weinyr hetekwer huwake nuhem kwaw nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Nazirew romo wiko mehe uzemonokatu putar Tupàn Tuweharupi Wiko Ma'e pe ma'ereko haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Aze amo umàno e na'arewahy huwake nehe, aze nezewe mehe umuaiw i'aw nehe, a'e mehe 7 'ar pawire upin putar u'aw nehe. Upin putar wamutaw nehe no. Nezewe mehe ikatu wi putar Tupàn henataromo nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","8 haw 'ar mehe werur putar mokoz wiràmiri xaxeto pe tàpuzràn Tupàn pe imonokatu pyrer pe teixe pe wà nehe: pykahu wà, aze ru'u pyku'i wà. ");
INSERT INTO gubBl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Xaxeto omono putar pitài Tupàn pe nehe, ikatu 'ymaw imunàn kar haw romo nehe. Omono putar inugwer hapy paw pyràm romo nehe. Nezewe mehe Tupàn umunàn putar umàno ma'e kwer huwake ihem awer nehe. A'e 'ar mehe we a'e nazirew omonokatu wi putar u'aw Tupàn pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Na'e uzemonokatu wi putar Tupàn Tuweharupi Wiko Ma'e pe ima'ereko haw rehe nehe. I'aw umumaw amo 'ar iaiw ma'e romo. U'ar ipapar mehe nupapar kwaw a'e 'ar nehe. Werur putar àràpuhàràn hawitu ma'e pitài kwarahy hereko har wemiapo kwer ikatu 'ym ma'e imunàn kar haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nazirew umumaw putar Tupàn pe uma'ereko haw 'ar a'e nehe. A'e 'ar mehe Tupàn uzapo kar ma'e izupe. Oho putar tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Omono putar na'iruz ma'ea'yr ikatu 'ymaw hereko 'ymar Tupàn Tuweharupi Wiko Ma'e pe wà nehe: pitài àràpuhàràn hawitu ma'e awa pitài kwarahy hereko har hapy paw pyràm romo, àràpuhàràn hawitu kuzà pitài kwarahy hereko har katu 'ygwer imunàn kar haw romo, àràpuhàràn hawitu ma'e awa Tupàn pe uzemuawyze wi kar haw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Omono putar kok ipor typy'ak imuapiruru kar 'ym pyrer izupe nehe: typy'ak uhu ma'e arozràn imuku'i pyrer iapo pyrer uri kawer inuromo har, typy'ak pixik ma'e ipew ma'e. Xaxeto omono putar uri kawer pixik hehe nehe. Omono putar arozràn Tupàn pe nehe. Omono putar win izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Xaxeto omono putar a'e ma'e paw Tupàn Tuweharupi Wiko Ma'e henataromo nehe. Omono putar ma'e katu 'ygwer imunàn kar haw nehe. Omono putar ma'e hapy paw pyràm nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Omono putar àràpuhàràn awa Tupàn Tuweharupi Wiko Ma'e pe uzemuawyze kar haw romo nehe. Omono putar typy'ak imuapiruru kar 'ym pyrer kok por izupe nehe no. Omono putar arozràn izupe nehe. Omono putar win izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tàpuzràn Tupàn pe imonokatu pyrer hukenaw pe nazirew upin putar wàkàg nehe. Upyhyk putar u'aw wer tata pe imono pà nehe, Tupàn imuawyze kar haw hapy haw pupe imono pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Umihir putar izywa kwer nehe. Na'e xaxeto upyhyk putar a'e ho'o kwer nazirew ipo pe imono pà nehe. Omono putar mokoz typy'ak kok pupe arer ipo pe nehe no: uhu ma'e, pixik ma'e no. (Uzapo putar a'e ma'e iàkàg ipin ire nehe). ");
INSERT INTO gubBl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Na'e xaxeto omono putar a'e ma'e Tupàn Tuweharupi Wiko Ma'e pe nehe, imono pyr ikatuahy ma'e romo nehe. Xaxeto wiko putar a'e imono pyrer ikatuahy ma'e izar romo nehe. Upyhyk putar àràpuhàràn ipuxi'a nehe. Upyhyk putar henugupy nehe no. Wiko putar a'e ma'e izar romo Tupàn ze'eg rupi katete nehe. A'e re nazirew upuner win i'u haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Amumaw a'e ze'eg Nazirew Tupàn Tuweharupi Wiko Ma'e pe uzemonokatu ma'e rehe har imume'u haw kwez. Aze nazirew umume'u amo ma'e Tupàn pe nehe no, tuwe omono a'e ma'e wemimume'u kwer izupe nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Eze'eg Àràw pe nehe, ta'yr wanupe nehe no. — Pemono ze'egatu teko Izaew izuapyapyr wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Tuwe Tupàn Tuweharupi Wiko Ma'e omono uze'egatu penehe nehe, pemonokatu pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tuwe Tupàn Tuweharupi Wiko Ma'e penereko katu nehe. Tuwe pepuhareko katu nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tuwe Tupàn Tuweharupi Wiko Ma'e ume'e penehe peamutar katu pà nehe. Tuwe umur zeàmàtyry'ym 'ymaw peme nehe, peze wanupe nehe, ere wanupe, i'i Tupàn Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Uze'eg wi Tupàn. — Nezewe mehe Àràw a'e, ta'yr a'e wà no, wenoz putar heze'egatu Izaew wanehe imono pyràm wà nehe. Amono putar heze'egatu wanehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moizez umumaw tàpuzràn Tupàn pe imonokatu pyrer imuàgà'ymaw. A'e 'ar mehe we uzakook uri kawer hehe Tupàn ima'ereko haw pe imonokatu pà. Omonokatu tàpuzràn pupe har izupe paw rupi. Omonokatu ma'ea'yr hapy haw rehe har paw izupe no. ");
INSERT INTO gubBl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Na'e uzeànàànàm ma'e wanuwihaw a'e wà, Izaew izuapyapyr wanuwihaw a'e wà, teko wapapar har a'e wà, ");
INSERT INTO gubBl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","werur ma'e imono pyr Tupàn Tuweharupi Wiko Ma'e pe wà: 6 ywyramawa ipyk pyrer, 12 tapi'ak wà. Mokoz tuwihaw omono pitài ywyramawa pitàitàigatu wà. Pitàitàigatu omono pitài tapi'ak. Omono a'e ma'e paw tàpuzràn Tupàn pe imonokatu pyrer henataromo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","— Epyhyk ywyramawa ne nehe. Epyhyk tapi'ak paw ne wà nehe no. Upyta putar tàpuzràn ihewe imonokatu pyrer rehe ma'ereko haw rehe wà nehe. Emono a'e ma'e Erewi izuapyapyr wanupe nehe, wama'ereko haw romo pitàitàigatu nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Na'e Moizez omono ywyramawa Erewi izuapyapyr wanupe. Omono tapi'ak wanupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Omono mokoz ywyramawa 4 tapi'ak wanehe we Zeroxon izuapyapyr wanupe wama'ereko awer hekuzaromo pitàitàigatu wà. ");
INSERT INTO gubBl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Omono 4 ywyramawa 8 tapi'ak wanehe we Merari izuapyapyr wanupe wama'ereko awer hekuzaromo pitàitàigatu wà no. Itamar Àràw ta'yr uzapo a'e ma'e imono haw. ");
INSERT INTO gubBl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Moizez nomono kwaw ywyramawa Koat izuapyapyr wanupe. Ni tapi'ak nomono kwaw wanupe wà. Ta'e Tupàn weraha kar uma'e wanupe waxi'i rehe a'e wà xe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Tuwihaw werur ma'e ma'ea'yr hapy haw Tupàn pe imono haw rehe ima'enukwaw pà wà no. — Oromono putar ma'e Tupàn pe nehe kury, i'i wà. ");
INSERT INTO gubBl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","A'e 'ar mehe we Tupàn uze'eg Moizez pe. — Tuwihaw paw pitàitàigatu wà nehe, tuwe umur ma'e ihewe wà nehe, ma'ea'yr hapy haw ihewe imur katu pà wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","A'e 12 tuwihaw omono uma'e nezewe wà: 'Ar ipy mehe Nazom Aminanaw ta'yr Zuta izuapyapyr wanuwihaw werur ma'e Tupàn pe. Mokoz haw 'ar mehe Netanew Zuar ta'yr Ixakar izuapyapyr wanuwihaw werur ma'e Tupàn pe. Na'iruz haw 'ar mehe Eriaw Erom ta'yr Zemurom izuapyapyr wanuwihaw werur ma'e Tupàn pe. 4 haw 'ar mehe Erizur Xeneur ta'yr Humen izuapyapyr wanuwihaw werur ma'e Tupàn pe. 5 haw 'ar mehe Xerumiew Zurizanaz ta'yr Ximeàw izuapyapyr wanuwihaw werur ma'e Tupàn pe. 6 haw 'ar mehe Eriazap Newew ta'yr Kaz izuapyapyr wanuwihaw werur ma'e Tupàn pe. 7 haw 'ar mehe Erizàm Amiu ta'yr Eparai izuapyapyr wanuwihaw werur ma'e Tupàn pe. 8 haw 'ar mehe Kamariew Penazur ta'yr Manaxe izuapyapyr wanuwihaw werur ma'e Tupàn pe. 9 haw 'ar mehe Aminà Zineoni ta'yr Mezàmi izuapyapyr wanuwihaw werur ma'e Tupàn pe. 10 haw 'ar mehe Aiezer Amizanaz ta'yr Nà izuapyapyr wanuwihaw werur ma'e Tupàn pe. 11 haw 'ar mehe Paziew Okirà ta'yr Azer izuapyapyr wanuwihaw werur ma'e Tupàn pe. 12 haw 'ar mehe Aira Enà ta'yr Napitari izuapyapyr wanuwihaw werur ma'e Tupàn pe. Wanemirur paw uzuawygatu wà: Kawawpew pitài kir amo iku'aw har parat iapo pyrer. Kawawhu 800 kàràm parat iapo pyrer. Wexak ipuhuz haw tuwihaw wama'e huwake wà. Kawawpew a'e, kawawhu a'e no, tynehem arozràn imuku'i pyrer uri kawer inuromo har pupe pitàitàigatu. Arozràn Tupàn pe imono pyr, i'i izupe wà. Amo ma'e werur wà no: pitài kawaw 115 kàràm or iapo pyrer. Pitàitàigatu kawaw tynehem yhyk zàwenugar pupe. Pitài tapi'aka'yr awa ipyahu ma'e hapy paw pyràm, pitài àràpuhàràn hawitu ma'e awa hapy paw pyràm, pitài àràpuhàràn hawitu ma'e awa pitài kwarahy hereko har hapy paw pyràm, pitài àràpuhàrànete awa katu 'ygwer imunàn kar haw romo. Werur amo ma'ea'yr Tupàn imuawyze kar haw romo wà no. Mokoz tapi'ak awa wà: 5 àràpuhàràn hawitu ma'e awa wà. 5 àràpuhàràn hawitu ma'e awa pitài kwarahy hereko har wà. ");
INSERT INTO gubBl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","85","Izaew ta'yr wazuapyapyr wanuwihaw werur ma'e tetea'u Tupàn pe wà, ma'ea'yr hapy haw izupe imonokatu pà wà: 12 kawawhu parat iapo pyrer, 12 kawawpew parat iapo pyrer. Heta 27,5 kir a'e parat ipuhuz haw a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","12 kawaw or iapo pyrer. Heta 1,38 kir a'e or ipuhuz haw a'e. Tynehem a'e kawaw yhyk zàwenugar pupe. ");
INSERT INTO gubBl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Werur ma'ea'yr tetea'u hapy paw pyràm romo wà no: 12 tapi'aka'yr awa wà. 12 àràpuhàràn hawitu ma'e awa wà. 12 àràpuhàràna'yr hawitu ma'e awa wà. Arozràn a'e ma'ea'yr wanehe we har. 12 àràpuhàrànete awa katu 'ygwer imunàn kar àwàm romo. ");
INSERT INTO gubBl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Werur ma'ea'yr tetea'u Tupàn pe uzemuawyze kar haw romo wà no: 24 tapi'ak awa wà, 60 àràpuhàràn hawitu ma'e awa wà, 60 àràpuhàrànete awa wà, 60 àràpuhàràn hawitu ma'e pitài kwarahy hereko har wà. ");
INSERT INTO gubBl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Moizez wixe tàpuzràn Tupàn pe imonokatu pyrer pupe izupe uze'eg pà kury. Wixe mehe wenu Tupàn ize'eg mehe hyru ipykaw i'aromo har. Upyta mokoz kerumin wamyter pe ize'eg mehe. Nezewe Tupàn uze'eg Moizez pe tuweharupi. ");
INSERT INTO gubBl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Eze'eg Àràw pe ko heze'eg imume'u pà izupe nehe. — 7 tatainy wanenaw rehe wamono mehe nehe, tuwe uhyape katu wenaw henataromo har rehe nehe, ere izupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Weruzar Àràw a'e ze'eg. Omonokatu tatainy a'e pe. Uhyape katu ywy wenaw henataromo har rehe. Ta'e Tupàn umume'u nezewe haw iapo àwàm Moizez pe xe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Teko unupànupà or a'e tatainy henaw iapo pà wà. Iwy pe har, ma'eputyr hagapaw hehe har a'e no, paw rupi or inupà pyrer romo a'e. Ta'e Tupàn Tuweharupi Wiko Ma'e wexak kar iapo àwàm Moizez pe a'e xe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","— Emunyryk kar Erewi izuapyapyr amogwer Izaew izuapyapyr wanuwi ne wà nehe. Emukatu herenataromo ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ezapo nezewe haw wamukatu pà nehe. Emupiripirik kar 'y herenataromo imukatu pyrer nehe, wanehe nehe. Tuwe upin wetekwer paw wà nehe. Tuwe uhez uma'e paw wà nehe no. Nezewe mehe wiko putar imukatu pyrer romo herenataromo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Na'e epyhyk amo tapi'aka'yr awa nehe. Epyhyk arozràn ikatu wera'u ma'e imuku'i pyrer nehe. Emono uri kawer inuinuromo nehe. Emono a'e arozràn imur pyr tapi'aka'yr rehe we nehe. Epyhyk amo tapi'aka'yr awa katu 'ygwer imunàn kar haw romo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","A'e re emono'og teko Izaew izuapyapyr paw ne wà nehe. Emupu'àm kar Erewi izuapyapyr tàpuzràn Tupàn pe imonokatu pyrer henataromo ne wà nehe no. ");
INSERT INTO gubBl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Na'e teko Izaew izuapyapyr omono putar opo Erewi izuapyapyr waàkàg wanehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A'e pe Àràw umunyryk kar putar Erewi izuapyapyr ihewe wà nehe. Wiko putar Izaew wanemimur ikatuahy ma'e romo wà nehe, ihewe wà nehe. Nezewe mehe Erewi izuapyapyr upuner putar uma'ereko haw rehe ihewe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Erewi izuapyapyr omono putar opo mokoz tapi'ak awa waàkàg wanehe wà nehe. Uzuka putar pitài katu 'ygwer imunàn kar haw romo wà nehe. Wapy putar inugwer uzemukatu kar pà herenataromo wà nehe. Ukaz paw putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Emunyryk kar Erewi izuapyapyr ihewe imur pyr ikatuahy ma'e romo ne wà nehe. Àràw a'e, ta'yr a'e wà no, wiko putar wanuwihaw romo wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Emunyryk kar Erewi izuapyapyr amogwer Izaew wanuwi ne wà nehe, hema'e romo wamuigo kar pà ne wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","A'e re eremukatu putar Erewi izuapyapyr ne wà nehe, wamunyryk kar pà ne wà nehe. Eremuhyk putar tàpuzràn ihewe imonokatu pyrer pupe ma'ereko haw pe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Amunyryk Izaew wanuwi hema'e romo ihe wà, Izaew wana'yr ipy wanekuzaromo ihe wà. Wiko hema'e romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ezit ywy rehe har wana'yr ipy wazuka mehe amunyryk kar Izaew wana'yr ipy paw hezeupe ihe wà. Amunyryk kar ma'ea'yr wamemyr ipy paw hezeupe ihe wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ko 'ar rehe areko Erewi izuapyapyr paw ihe wà kury, Izaew wana'yr ipy wanekuzaromo ihe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Kutàri amono Erewi izuapyapyr Àràw pe ihe wà kury, ta'yr wanupe ihe wà no, Izaew wanemimur romo ihe wà. Uma'ereko putar tàpuzràn ihewe imonokatu pyrer pupe teko Izaew izuapyapyr wanekuzaromo wà nehe. Umunàn kar putar wanemiapo kwer ikatu 'ygwer ihewe wà nehe. Upyro putar Izaew iaiw haw wi wà nehe. Ta'e aze amo uhem herenaw ikatu ma'e huwake nehe, iaiw haw uzeapo putar izupe nehe, i'i Tupàn. ");
INSERT INTO gubBl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Nezewe Moizez a'e, Àràw a'e no, teko Izaew izuapyapyr paw a'e wà no, weruzar Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe har Erewi izuapyapyr wanehe har a'e wà kury. ");
INSERT INTO gubBl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Erewi uzemukatu wà. Uhez uma'e wà no. Na'e Àràw umunyryk kar Tuweharupi Wiko Ma'e pe imono pyr ikatu ma'e romo wà no. Uzapo wamukatu haw wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Teko uzapo Tuweharupi Wiko Ma'e Moizez pe Erewi wanehe hemiapo kar kwer paw wà. Nezewe wexaexak tàpuzràn Tupàn pe imonokatu pyrer pupe uma'ereko ma'e ràm romo wà. Àràw a'e, ta'yr a'e wà no, wiko wanuwihaw romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Na'aw Tupàn ze'eg Erewi wanehe har xe. — Wyzài Erewi izuapyr nehe, aze wereko 25 kwarahy nehe, uzypyrog putar tàpuzràn Tupàn pe imonokatu pyrer pupe uma'ereko haw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","50 kwarahy hereko mehe upytu'u putar ipupe uma'ereko re nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","50 kwarahy hereko re upuner uzehe we har wapytywà haw rehe wama'ereko haw tàpuzràn Tupàn pe imonokatu pyrer pupe har iapo mehe wà nehe. Nezewe rehe we nuiko kwaw a'e ma'e rehe uzekaiw ma'e romo wà nehe. Emuàgà'ym Erewi izuapyapyr wama'ereko haw nezewe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Teko Izaew izuapyapyr Ezit ywy wi wahem ire pitài haw zahy rehe mokoz haw kwarahy rehe Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe ywyxiguhu Xinaz her ma'e rehe a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","14 haw 'ar mehe kwarahy heixe mehe teko Izaew uzapo putar mynykawhu wa'yr wazuka 'ym awer her ma'e wà nehe. Weruzar putar heze'eg a'e ma'e rehe har paw wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Na'e Moizez uzapo kar a'e mynykaw Izaew wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Uzapo 14 haw 'ar mehe pitài haw zahy rehe kwarahy heixe mehe we Xinaz ywyxiguhu rehe wà. Izaew uzapo Tupàn Tuweharupi Wiko Ma'e Moizez pe hemiapo kar kwer paw wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nezewe rehe we amo awa wiko ikatu 'ym ma'e Tupàn henataromo wà. Ta'e opokok umàno ma'e kwer rehe wà xe. A'e rupi nupuner kwaw mynykaw zanera'yr wazuka 'ym awer her ma'e iapo haw rehe a'e 'ar mehe wà. A'e rupi uze'eg oho Moizez pe Àràw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","— Na'urekatu kwaw Tupàn henataromo ure, ta'e oropokok umàno ma'e kwer rehe ure xe, i'i wanupe wà. — Aipo nurupuner kwaw ureremimono ràm Tuweharupi Wiko Ma'e pe imono haw rehe amogwer Izaew wanehe we ure nehe, 'ar imume'u pyrer rehe ure nehe, i'i wanupe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Na'e Moizez uwazar waze'eg wanupe. — Heràro pe nehe. Aze'eg putar aha Tuweharupi Wiko Ma'e pe nehe. Akwaw putar peme hemiapo kar nehe, i'i wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Na'e Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Emume'u ko heze'eg Izaew wanupe nehe. — Amo peinuromo har, amo pezuapyr, aze wiko ikatu 'ym ma'e romo herenataromo umàno ma'e kwer rehe opokok ire nehe, aze ru'u amo wiko muite wata haw iapo pà nehe, nezewe rehe we upuner Izaew wana'yr wazuka 'ym awer iapo haw rehe nehe, Tupàn Tuweharupi Wiko Ma'e imuwete pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Pemumaw putar pitài zahy nehe. A'e mehe pezapo putar 14 haw 'ar mehe mokoz haw zahy rehe kwarahy heixe mehe we nehe. A'e 'ar mehe pe'u putar àràpuhàràn hawitu ma'e awa ho'o kwer typy'ak imuapiruru kar pyrer 'ym inuromo nehe, ka'a iro ma'e inuromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tuwe naheta kwaw ikurer nehe. Tuwe naheta kwaw ikurer iku'egwer pe nehe. Tuwe napemonohok kwaw ni pitài ikagwer nehe. Pezapo a'e mynykaw Tupàn ze'eg a'e ma'e rehe har rupi katete nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Aze ru'u amo wiko putar ikatu ma'e romo Tupàn henataromo a'e 'ar mehe nehe. Aze ru'u amo ywy rehe nuwata kwaw a'e 'ar rehe nehe. Aze a'e teko nuzapo kwaw a'e mynykaw nehe, pemuhem kar teko wamyter wi nehe. Ta'e numur kwaw ihewe imur pyr i'ar katu mehe xe. Azepyk putar hehe hemiapo kwer ikatu 'ym ma'e hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Aze amo ae ywy rehe arer peinuromo wiko ma'e ipurapo wer a'e mynykaw rehe nehe, tuwe weruzar heze'eg rehe har nehe. Amume'u heze'eg teko nànàn ihe, peywy rehe uzexak kar ma'e kwer wanupe, amo ywy rehe uzexak kar ma'e kwer wanupe no. ");
INSERT INTO gubBl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Tàpuzràn Tupàn pe imonokatu pyrer imuapykaw 'ar mehe amo ywàkun ur ipyk pà a'e. Pyhaw nuzawy kwaw tata. ");
INSERT INTO gubBl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Tuweharupi uzexak kar nezewe: 'aromo amo ywàkun upyk tàpuzràn. Pyhaw nuzawy kwaw tata. ");
INSERT INTO gubBl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ywàkun tàpuzràn wi izeupir mehe Izaew izuapyapyr uzypyrog wata pà wà. Aze ywàkun upytu'u wata re, Izaew uzapo uker haw a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Uzypyrog wata pà wà. Aze ru'u uzapo uker haw wà. Wyzài ma'e iapo mehe weruzar Tupàn Tuweharupi Wiko Ma'e wà. Upyta a'e pe aze ywàkun upyta tàpuzràn Tupàn pe imonokatu pyrer i'aromo. ");
INSERT INTO gubBl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Aze umumaw 'ar tetea'u tàpuzràn i'aromo Izaew weruzar Tupàn Tuweharupi Wiko Ma'e a'e wi uhem 'ym pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Amo upytu'u awer rehe ywàkun umumaw màràmàràn 'ar tàpuzràn i'aromo. Izaew weruzar Tuweharupi Wiko Ma'e ize'eg wà. Upyta a'e pe wà, uzypyrog wata pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Amo upytu'u awer rehe Uzypyrog upytu'u pà karuk mehe. Iku'egwer pe uzeupir wi. Izeupir mehe uzypyrog wata pà wà. Tuweharupi aze ywàkun uzeupir, 'aromo, aze ru'u pyhaw, Izaew uzypyrog wata pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Aze umumaw mokoz 'ar tàpuzràn i'aromo upyta pà, aze ru'u umumaw pitài zahy, aze ru'u umumaw pitài kwarahy, aze upytu'u, a'e mehe Izaew upyta a'e pe wà. Nuzypyrog kwaw wata pà wà. Aze uzeupir, oho a'e wi wà. ");
INSERT INTO gubBl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Weruzar Tupàn Tuweharupi Wiko Ma'e ize'eg wà. Uzapo uker haw wà, aze ru'u uzypyrog wata pà wà. Izaew weruzar Tuweharupi Wiko Ma'e ze'eg Moizez pe imono pyrer wà. ");
INSERT INTO gubBl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Tupàn Tuweharupi Wiko Ma'e umume'u ko uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","— Enupànupà parat mokoz xi'àm ma'ea'yr i'a kwer iapo pyrer zàwenugar iapo pà nehe. Aze neporomono'og wer teko wanehe nehe, ezupy kar a'e xi'àm nehe. Aze nepureraha wer teko waker haw wi ne wà nehe, ezupy kar a'e xi'àm nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Aze erezupy kar a'e mokoz xi'àm nehe, teko paw uzemono'og putar neruwake tàpuzràn Tupàn pe imonokatu pyrer pe teixe haw huwake nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Aze erezupy kar xo pitài zo nehe, xo teko uzeànàànàm ma'e wanuwihaw uzemono'og putar nerehe we wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Aze upyahy na'arewahy har romo nehe, Izaew ta'yr wazuapyapyr kwarahy ihemaw kutyr har uzypyrog putar uhemaw rehe wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Aze upy nezewegatete mokoz haw wà nehe, Izaew ta'yr wazuapyapyr kwarahy ihemaw awyze har kutyr har uzypyrog putar uhemaw rehe wà nehe. Ipyahy haw na'arewahy har henu mehe uhem putar oho wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Aze neporomono'og wer teko wanehe nehe, ezupy kar àrewa'u nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Xaxeto Àràw izuapyapyr upy putar a'e xi'àm wà nehe. Izaew weruzar putar ko ze'eg tuweharupi wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Aze peàmàtyry'ym amo teko peywy rehe pe wà nehe, aze pezepyro peiko peàmàtyry'ymar penehe ipuruzuka wer ma'e wanuwi nehe, pezupy kar a'e xi'àm peànàm zauxiapekwer wamono'og kar pà nehe. Ihe Tupàn Tuweharupi Wiko Ma'e pezar apupytywà putar peàmàtyry'ymar wanuwi pepyro pà ihe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Aze penurywete nehe, aze pezapo mynykaw zahy pyahu rehe nehe, aze ru'u pezapo amo mynykaw nehe, pezupy a'e xi'àm ma'e hapy paw pyr imur mehe nehe, ma'e hemuawyze kar haw imur mehe nehe no. Aiko Tuweharupi Wiko Ma'e pezar romo ihe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Teko Ezit ywy wi wahem ire mokoz haw kwarahy rehe mokoz haw zahy rehe 20 haw 'ar mehe ywàkun uzeupir tàpuzràn Tupàn pe imonokatu pyrer wi a'e kury. ");
INSERT INTO gubBl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","A'e 'ar mehe we Izaew uzypyrog wata pà wà, Xinaz ywyxiguhu wi uhem pà wà. Ywàkun upytu'u Pàrà ywyxiguhu rehe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nezewe uzypyrog wata pà Tupàn Tuweharupi Wiko Ma'e ze'eg Moizez pe imono pyrer rupi katete wà. ");
INSERT INTO gubBl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Izypy mehe pànuhu Zuta her hereko har iwype har uhem a'e wi wà. Uhem amo uzemono'og ma'e wà. Na'e uhem amo uzemono'og ma'e wà no. Nezewe uhem paw rupi wà. Nazom Aminanaw ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanew Zuar ta'yr wiko Ixakar izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eriaw Erom ta'yr wiko Zemurom izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Umuàgà'ym tàpuzràn Tupàn pe imonokatu pyrer wà. Na'e Erewi izuapyapyr Zeroxon iànàm wà, Merari iànàm wà no, uhem a'e wi tàpuzràn Tupàn pe imonokatu pyrer heraha pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Na'e pànuhu Humen her hereko har iwype har uhem a'e wi wà. Uhem amo uzemono'og ma'e wà. Na'e uhem amo uzemono'og ma'e wà no. Nezewe uhem paw rupi wà. Erizur Xeneur ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Xerumiew Zurizanaz ta'yr wiko Ximeàw izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eriazap Newew ta'yr wiko Kaz izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Na'e uhem Erewi izuapyapyr Koat iànàm wà kury, ma'e Tupàn pe imonokatu pyrer heraha pà wà kury. Uker àwàm pe uhem mehe umupu'àm tàpuzràn Tupàn pe imonokatu pyrer a'e pe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Na'e pànuhu Eparai her hereko har iwype har uhem a'e wi wà. Uhem amo uzemono'og ma'e wà. Na'e Uhem amo uzemono'og ma'e wà no. Nezewe uhem paw rupi wà. Erizàm Amiu ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Kamariew Penazur ta'yr wiko Manaxe izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Aminà Zineoni ta'yr wiko Mezàmi izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","A'e re amogwer Izaew izuapyapyr paw wanaikweromo uhem pànuhu Nà her hereko har iwype har a'e wi wà. Uhem amo uzemono'og ma'e wà. Na'e uhem amo uzemono'og ma'e wà no. Nezewe uhem paw rupi wà. Aiezer Amizanaz ta'yr wiko wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Paziew Okirà ta'yr wiko Azer izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Aira Enà ta'yr wiko Napitari izuapyapyr wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Izaew uzypyrog wata pà nezewe wà. Pitàitàigatu uzypyrog wànàm wanehe we wata mehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Uze'eg Moizez wemireko ikywyr pe kury. Omaw Zetero ta'yr her romo a'e. Minià ywy rehe arer romo hekon. — Tupàn Tuweharupi Wiko Ma'e uze'eg nezewe urewe a'e. — Amono putar amo ywy peme nehe, i'i urewe. Zahem putar zaha a'e ywy kutyr kury. — Amuigo kar putar Izaew teko hemetarer katu ma'e romo ihe wà nehe, i'i urewe. A'e rupi ko ze'eg amume'u newe kury. — Ezur urerupi nehe. Ximuza'aza'ak putar ikatu ma'e zaneremipyhyk ràm nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Uwazar Omaw Moizez ize'eg izupe. — Nan. Azewyr putar heywy pe nehe, heànàm wanupe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","— Eho zo nehe, i'i Moizez izupe. — Erekwaw ywyxiguhu. Erekwaw ker haw ikatu ma'e. Erepuner urerape ràm hexak kar har romo nereko haw urewe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Aze erezur urerupi nehe, ximuza'aza'ak putar ma'e Tupàn Tuweharupi Wiko Ma'e hemimur ràm paw rupi nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nezewe Izaew uhem oho Xinaz ywytyr Tupàn Tuweharupi Wiko Ma'e henaw wi wà. Umumaw na'iruz 'ar wata pà wà. Tupàn Tuweharupi Wiko Ma'e ze'eg hyru oho wanenataromo tuweharupi waker haw hexak kar pà wanupe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wahem mehe ywàkun Tupàn Tuweharupi Wiko Ma'e heko haw hexak kar har upyta wa'aromo 'aromo a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tuweharupi Tupàn Ze'eg Hyru iho mehe Moizez umume'u ko ze'eg a'e. — O Tupàn Tuweharupi Wiko Ma'e, epu'àm neàmàtyry'ymar wamuhàmuhàz pà nehe. Tuwe nerehe iakatuwawahy 'ym ma'e uzàn nerenatar wi wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Tupàn Ze'eg Hyru ipytu'u mehe tuweharupi Moizez umume'u ko ze'eg. — O Tupàn Tuweharupi Wiko Ma'e, ezewyr Izaew izuapyapyr waànàànàm wainuinuromo epyta pà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Na'e zawaiw katu Izaew waneko haw kury. A'e rupi uzypyrog Tupàn Tuweharupi Wiko Ma'e rehe uze'eg zemueteahy haw rehe wà kury. Waze'eg henu mehe Tuweharupi Wiko Ma'e wikwahy wanupe. Umu'ar kar tata wanehe. Tata ukaz wamyter pe waker haw ipehegwer hapy pà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Na'e teko uhapukaz upytywà àwàm henoz pà Moizez pe wà. Moizez uze'eg Tupàn Tuweharupi Wiko Ma'e pe. Na'e tata uwew. ");
INSERT INTO gubBl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","A'e rupi omono Tamera a'e ywy pehegwer her romo wà, ta'e Tupàn Tuweharupi Wiko Ma'e hata ukaz wamyter pe a'e pe xe. — Tata, i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Heta amo ywy rehe arer Izaew wanupi wata ma'e wà. Uhez tuwe ma'ero'okwer wà. Te Izaew uzypyrog uma'uhez haw imume'u pà wà no. — A, aze mo heta ma'ero'o kwer pixik zaneremi'u ràm romo, i'i wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","— Ezit ywy rehe xi'u ipira. Te zanerewykàtà. Nahekuzar kwaw. Azeharomoete xiuhez temi'u a'e pe har: pipin, meràw, ka'a i'u pyr, ma'ywanem xemor her ma'e, ma'ywanem az her ma'e. ");
INSERT INTO gubBl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Upaw zanekàgaw kwez kury. Naheta kwaw i'u pyr. Xo mana zo xixak. ");
INSERT INTO gubBl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana nuzawy kwaw ma'eà'yz pixika'i ma'e xig izu wewer ma'e. ");
INSERT INTO gubBl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","U'ar pyhaw zuwiri inuinuromo. Iku'egwer pe teko uhem oho imono'og pà uker haw izywyr wà. Umuku'iku'i wà. Aze ru'u oxooxok ygu'a pupe wà. Umupupur zapepo pupe wà. Uma'ema'e a'e mana typy'ak ipew ma'e iapo pà wà. Hete haw nuzawy kwaw typy'ak uri kawer inuromo imihir pyrer hete haw. ");
INSERT INTO gubBl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Na'e Moizez wenu teko wazai'o mehe a'e wà. Teko uzai'o wàpuzràn pupe teixe haw pe pitàitàigatu wà. Tuweharupi Wiko Ma'e wikwahy. Moizez wikwahy a'e no. ");
INSERT INTO gubBl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","A'e rupi Moizez uze'eg Tupàn pe. — Màràzàwe tuwe hererekoahy pe nezewe. Màràzàwe tuwe erekwahy ihewe. Màràzàwe tuwe erezapo kar ma'ereko haw zawaiw katu wera'u ma'e ihewe. Màràzàwe tuwe hemuigo kar pe 'aw teko paw wanuwihaw romo. ");
INSERT INTO gubBl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nazapo kwaw 'aw teko ihe wà. Namuzexak kar kwaw ihe wà. Màràzàwe tuwe hemuigo kar pe wanehe uzekaiw ma'e zàwenugar romo. Araha he'uwaromo kwarera'i ài ihe wà, ywy waipy pe neremimono kwer kutyr ihe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ma'e pe apyhyk putar ma'ero'o kwer 'aw teko wanupe nehe. Heta tetea'u wà. Ur heruwake uzai'o pà wà. — Uruhez ma'ero'o kwer, i'i ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ihe zutyka'i napuner kwaw 'aw teko wanehe hezekaiw haw rehe ihe. Heta tetea'u ihewe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Aze herereko pe nezewe nehe, hepuhareko pe hezuka pà nehe. Aze hekatu newe, epuraraw kar zo ma'erahy nezewe ihewe nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Tupàn Tuweharupi Wiko Ma'e uwazar Moizez ize'eg izupe kury. — Emono'og 70 awa teko Izaew wanuwihaw ihewe ne wà nehe. Eraha tàpuzràn ihewe imonokatu pyrer pe ne wà nehe. Epyta a'e pe wanehe we nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","A'e mehe awezyw putar wanupe heze'eg pà nehe. Amunyryk putar herekwe ikurer newe imono pyrer newi nehe, wanupe imono pà nehe. Nezewe mehe nepytywà putar teko wanehe nezekaiw mehe a'e wà nehe. Ipuhuz katu a'e ma'ereko haw. Ne zutyka'i nerepuner kwaw iapo haw rehe nehe. A'e 70 awa nepytywà putar wà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Emume'u ko heze'eg teko wanupe nehe kury. — Pezemukatu nehe. Nezewe mehe pyhewe pekatu putar herenataromo nehe. Pe'u putar ma'ero'o kwer nehe. Tupàn Tuweharupi Wiko Ma'e penenu pezai'o mehe a'e, ma'ero'o kwer izuhez haw imume'u mehe a'e, Ezit ywy rehe peneko katu haw imume'u mehe a'e. A'e rupi Tupàn Tuweharupi Wiko Ma'e umur putar ma'ero'o kwer peme nehe. Pe'u putar nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Napemumaw kwaw xo pitài 'ar zo i'u pà nehe. Napemumaw kwaw xo mokoz 'ar zo i'u pà nehe. Napemumaw kwaw xo 5 'ar zo i'u pà nehe. Napemumaw kwaw xo 10 'ar zo i'u pà nehe. Napemumaw kwaw xo 20 'ar zo i'u pà nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Pemumaw putar pitài zahy i'u pà nehe. Te uhem putar peapygwar rupi nehe. Pezewaru putar izuwi nehe. Pehuhuk putar hexak mehe nehe. Ta'e peityk Tupàn Tuweharupi Wiko Ma'e pemyter pe har pe xe. Ta'e peze'eg zemueteahy hehe xe. — Aze mo nazahem iwer Ezit ywy wi, peze izupe, ere wanupe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Uze'eg Moizez. — Araha 600.000 awa wanereko ihe wà. — Amono putar ma'ero'o kwer tetea'u wanupe nehe. Umumaw putar pitài zahy i'u pà wà nehe, ere kwez ihewe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ma'e pe heta àràpuhàràn hawitu ma'e tetea'u izuka pyràm wà. Ma'e pe heta tapi'ak 'aw teko wamuewykàtà kar àràm wà. Aze mo omono'og pira yryhu pe har paw, aipo uhyk mo, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Na'e Tupàn Tuweharupi Wiko Ma'e uwazar Moizez ze'eg izupe. — Aipo aiko ikàg 'ym ma'e romo nezewe ihe. Tàrityka'i erexak putar hepuner haw nehe kury. Na'arewahy erexak putar uzeapo ma'e ràm nehe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Na'e Moizez umume'u Tupàn Tuweharupi Wiko Ma'e ize'eg awer teko wanupe kury. Omono'og 70 teko wanuwihaw wà. Umupu'àm kar a'e awa tàpuzràn Tupàn pe imonokatu pyrer izywyr wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Na'e Tuweharupi Wiko Ma'e wezyw ywàkun pupe Moizez pe uze'eg pà kury. Ozo'ok wekwe kurer Moizez pe wemimono kwer izuwi, a'e 70 wanupe imono pà. Tekwe wanehe tur mehe uzypyrog uze'eg pà wahy haw rupi Tupàn ze'eg imume'u har zàwe wà. Nan kwehe tete upytu'u wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Amo mokoz a'e 70 wanehe we har tuwihaw upyta teko waker haw pe wà. Noho kwaw tàpuzràn Tupàn pe imonokatu pyrer pe wà. Ewnaz awa ipy her romo. Menaz inugwer her romo. Tupàn Hekwe ur wanehe. Uzypyrog uze'eg pà Tupàn ze'eg imume'u har zàwe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Na'e amo kwàkwàmo uzàn oho Moizez pe. — Ewnaz a'e, Menaz a'e no, uze'eg waiko Tupàn ze'eg imume'u har zàwe teko waker haw myter pe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Na'e Zuzue Nun ta'yr a'e, kwàkwàmo romo heko mehe arer Moizez ipytywà har a'e, uze'eg nezewe a'e. — Moizez heruwihaw, emupytu'u kar nezewe waze'eg ire ne wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Na'e uwazar ize'eg izupe. — Nema'enukwaw zo hereko haw rehe nehe. Ihe hema'enukwaw hereko haw rehe ihe. Aze mo Tupàn Tuweharupi Wiko Ma'e umur wekwe 'aw teko nànàn, ikatu mo ihewe. Aze mo umuigo kar uze'eg imume'u har romo paw rupi wà, ikatu mo ihewe, i'i. ");
INSERT INTO gubBl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Na'e Moizez a'e, a'e 70 tuwihaw a'e wà no, uzewyr teko waker haw pe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","A'e 'ar mehe we Tupàn Tuweharupi Wiko Ma'e umur kar ywytu yryhu wi a'e pe kury. Ywytu werur wiràmiri konor her ma'e tetea'u uzemono'og pyrer a'e pe wà. U'ar teko waker haw nànàn wà. U'ar izywyr katu wà no. Aze amo umumaw 30 kirom wata pà, nupaw kwaw wà. Upyk ywy ywytyr tetea'u iapo pà wà. Heta ru'u pitài met aiha haw pe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nezewe umumaw a'e 'ar wà. Umumaw pytun gatu wà no. Umumaw amo 'ar wà no, uma'ereko pà konor wamono'og pà wà. Pitàitàigatu omono'og 1.000 kir wà. Umuhàmuhàz uker haw izywyr wamuxinig kar pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Wano'o kwer heta tetea'u mehe we Tupàn Tuweharupi Wiko Ma'e wikwahy teko wanupe kury. Uzepyk wanehe ma'eahy haw iaiw ma'e imono pà wanupe. Umàno teko tetea'u wà. ");
INSERT INTO gubBl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","A'e rupi Kimorot-Atawa i'i a'e ywy pehegwer pe wà. — Ma'e putar haw izutym awer, i'i zaneze'eg rupi. Ta'e uzutym teko ma'ero'o kwer hemimue'o kar kwer a'e pe wà xe. ");
INSERT INTO gubBl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","A'e re Izaew oho Azerot pe uker haw iapo pà a'e pe wà kury. ");
INSERT INTO gubBl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moizez wereko amo kuzà Exio ywy rehe arer wemireko romo. Mirià a'e, Àràw uze'egahy izupe hereko awer rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","— Aipo xo Moizez pe zo Tupàn Tuweharupi Wiko Ma'e umume'u kar uze'eg a'e. Aipo numume'u kar kwaw zanewe a'e no, i'i wà. Tupàn Tuweharupi Wiko Ma'e wenu waze'eg mehe a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(-Aiko upuner wera'u ma'e romo, ni'i kwaw Moizez. — Aiko ikàg 'ym ma'e romo ihe, i'i uzeupe.) ");
INSERT INTO gubBl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nan kwehe tete Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe, Àràw pe no, Mirià pe no. — Pehem tàpuzràn ihewe imonokatu pyrer pe nehe, i'i wanupe. Oho wà. ");
INSERT INTO gubBl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tuweharupi Wiko Ma'e wezyw ywàkun upu'àm ma'e pupe kury. Upyta tàpuzràn pe teixe haw huwake. Na'e wenoz Àràw imuwà. Wenoz Mirià imuwà no. Wahem mehe ");
INSERT INTO gubBl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Tupàn uze'eg wanupe. — Peinu peme heze'eg àwàm nehe. Heze'eg imume'u har peinuromo waneta mehe azexak kar wanupe wapuahu mehe ihe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nazapo kwaw nezewe haw heremiruze'eg Moizez pe. Ta'e amuigo kar teko heremiaihu paw wanuwihaw romo ihe xe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Aze'eg izupe henataromo ihe. Aze'eg tuwe izupe. Nazumim kwaw hema'enukwaw paw izuwi. Amume'u tuwe. Te herexakaw wexak a'e no. Màràzàwe tuwe napekyze kwaw ihewi. Màràzàwe tuwe peze'eg heremiruze'eg Moizez kutyr. ");
INSERT INTO gubBl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Na'e Tupàn Tuweharupi Wiko Ma'e oho a'e wi wanupe wikwahy pà kury. ");
INSERT INTO gubBl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ihem ire ywàkun tàpuzràn i'aromo har ukàzym. A'e 'ar mehe we amo iperewaiw haw uhem Mirià pe. Xigatu ipir amanezu ài. Àràw ume'e Mirià rehe. — Azeharomoete iperewahy a'e, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Na'e Àràw uze'eg Moizez pe. — Urere'o mehe uruzapo ikatu 'ym ma'e. Emuzepyk kar zo Tupàn urerehe hekuzaromo nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Amo kuzà imemyr uzexak kar umàno ma'e kwer romo a'e wà. Hetekwer nuhyk kwaw izexak kar mehe wà. Emuigo kar zo Mirià agwer ma'e romo nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Na'e Moizez uze'eg Tupàn Tuweharupi Wiko Ma'e pe kury. — O Tupàn, ainoz imukatu àwàm newe kury, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Tuweharupi Wiko Ma'e uwazar Moizez ze'eg izupe. — Aze mo Mirià tu uzenymon huwa rehe, aipo numumaw iwer mo 7 'ar umaranugar pà. A'e rupi, pemuhem kar peneko haw wi nehe. Tuwe umumaw 7 'ar a'e pe nehe. A'e re perur wi nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nezewe mehe Mirià umumaw 7 'ar katu pe teko waker haw wi nehe. Teko nuhem kwaw a'e wi wà. Uker haw pe herur wi ire zo uhem oho a'e wi wà. ");
INSERT INTO gubBl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","A'e re teko uhem Azerot wi wà. Uzapo uker haw Pàrà ywyxiguhu rehe wà. ");
INSERT INTO gubBl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Tupàn Tuweharupi Wiko Ma'e uze'eg Moizez pe. ");
INSERT INTO gubBl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","— Emono kar amo awa Kànàà ywy rehe wamume'e kar pà ne wà nehe. Amono putar a'e ywy Izaew wanupe ihe nehe. Exaexak pitài awa Zako ta'yr wazuapyapyr wainuromo har wanuwi pitàitàigatu ne wà nehe. Tuwe a'e awa pitàitàigatu wiko wànàm wanuwihaw romo wà nehe, i'i izupe. ");
INSERT INTO gubBl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ywyxiguhu Pàrà her ma'e wi Moizez omono kar a'e awa a'e ywy rehe ume'e ma'e ràm romo a'e wà kury, Tupàn Tuweharupi Wiko Ma'e ize'eg rupi katete a'e wà kury. Pitàitàigatu wiko wànàm wanuwihaw romo wà. ");
INSERT INTO gubBl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Na'aw waner xe ko pape rehe wà. (Amume'u putar Izaew ta'yr izuapyapyr waner nehe. A'e re amume'u putar wanuwihaw her nehe.) Humen: Xamua Zakur ta'yr, Ximeàw: Xapa Ori ta'yr, Zuta: Karew Zepone ta'yr, Ixakar: Igaw Zuze ta'yr, Eparai: Ozez Nun ta'yr, Mezàmi: Pawxi Hapu ta'yr, Zemurom: Kaniew Xoni ta'yr, Manaxe: Kani Xuzi ta'yr, Nà: Amiew Kemari ta'yr, Azer: Xetur Mikaew ta'yr, Napitari: Nawi Wopixi ta'yr, Kaz: Kewew Maki ta'yr. ");
INSERT INTO gubBl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Moizez omono kar a'e awa a'e ywy rehe wamume'e kar pà. Omono amo her Ozez Nun ta'yr pe. Zuzue, i'i izupe kury. ");
INSERT INTO gubBl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moizez omono kar a'e awa Kànàà ywy hexak katu kar pà wanupe a'e wà. Wamono kar mehe uze'eg nezewe wanupe. — Peho ywy pehegwer kwarahy hemaw awyze har kutyr har rehe nehe. Pezeupir ywytyruhu rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Peme'egatu ywy rehe. Pexak hehe har nehe no. Pexak teko hehe har ikàgaw nehe. Aipo ikàg wà. U na'ikàg kwaw wà. Pexak waneta haw nehe no. Aze ru'u heta tetea'u wà. Aze ru'u naheta tete kwaw wà. ");
INSERT INTO gubBl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Peme'e waneko haw ywy ikatu haw rehe nehe no. Aipo ikatuahy. U iaiw aipo. Peme'e tawhu wanehe nehe no. Aipo heta pàrirogaw aiha ma'e waiwyr. ");
INSERT INTO gubBl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Peme'e ywy rehe nehe. Aipo hezuz katu ma'e hehe. U nàn. Aipo heta ka'a. Aipo heta ka'akyr. Pekàg pekyze 'ym pà nehe, amo ma'ywa a'e pe har herur pà ihewe nehe, i'i wanupe. (A'e 'ar mehe a'e ywy rehe har uzypyrog uwà ipo'o pà a'e wà.) ");
INSERT INTO gubBl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Na'e a'e awa oho a'e ywy rehe ume'e pà a'e wà kury. Uzypyrog ywyxiguhu Zim her ma'e pe wà. Oho te Heow pe wà. Amat pe zeupir haw huwake tuz Heow a'e. ");
INSERT INTO gubBl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Uzeupir ywy kwarahy ihemaw awyze har kutyr har rupi wà. Na'iruz awa wiko a'e pe wà. Aimà, Xezaz, Tawmaz waner wà. Wiko aiha katu ma'e Anak her ma'e izuapyapyr romo wà. (Teko a'e ywy rehe har uzapo Emerom tawhu wà. Na'e upaw 7 kwarahy. A'e re Ezit ywy rehe har uzapo Zuwà tawhu wà.) ");
INSERT INTO gubBl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Na'e a'e 12 awa uhem Exekow ywyàpyznaw pe wà kury. Omonohok amo uwà 'yw hàkà wà. Heta uwà haryw hehe. Mokoz awa weraha a'e haryw ywyra rehe imuzaiko pyrer wà. Upyhyk homà 'a kwer wà. Upyhyk pi 'a kwer wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Exekow ywyàpyznaw, i'i a'e ywy pehegwer pe wà. Ta'e omonohok uwà haryw a'e pe wà xe. — Uwà haryw i'i her zaneze'eg rupi. ");
INSERT INTO gubBl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Umumaw 40 'ar ywy hexak pà wà. ");
INSERT INTO gubBl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Na'e uzewyr Kanez Pàrà ywyxiguhu pe har pe wà, Moizez ipyta haw pe wà. Àràw wiko a'e pe Izaew paw wapyr a'e no. Umume'u wemixak kwer wanupe wà, teko paw wanupe wà no. Wexak kar temi'u a'e ywy rehe arer herur pyrer wanupe wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Uze'eg Moizez pe wà. — Uremono kar pe amo ywy rehe ne. Oroho a'e ywy rehe ure. Azeharomoete ikatuahy ywy. Hezuz katu ma'e a'e pe. Aze ereme'e ko hezuz ma'e kwer rehe nehe, erepuner putar ywy ikatu haw hexakaw rehe nehe. ");
INSERT INTO gubBl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Teko a'e pe wiko ma'e ikàg a'e wà. Uhua'u tawhu wà. Heta pàrirogaw aiha ma'e waiwyr. Uruexak teko aiha katu ma'e wazuapyapyr ure wà no. ");
INSERT INTO gubBl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amarek ywy rehe har wiko ywy kwarahy hemaw awyze har kutyr har rehe wà. Ete izuapyapyr wà