﻿USE sofia;
DROP TABLE IF EXISTS sofia.gri_vpl;
CREATE TABLE gri_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gri_vpl WRITE;
INSERT INTO gri_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tana idana kalina God e vusagira na omea sui i baragata mi barangengo, ");
INSERT INTO gri_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ma na barangengo e lalo sui moa na kao ma na tasi, me tagara sa omea i laona. Ma na rodo e tsavu poponoa pipi sui na omea ma nina Tarunga God e tsotsobo i kelana na kô. ");
INSERT INTO gri_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mi muri ma God e tsaria, “Ke laba na marara.” Ma na marara e laba. ");
INSERT INTO gri_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma God e reingaoa na marara. Maia e votâ na marara tania na rodo, ");
INSERT INTO gri_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","me soaginia na marara na “Dani” ma na rodo na “Bongi”. Me bongi me matsaraka. Aia na kesanina dani. ");
INSERT INTO gri_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Mi muri, ma God e tsaria, “Ke totu na masaoka ke gini votâ na kô me ke totu ruka tabana.” Me laba vaga aia e tsaria. Me vaga ia, ma God e aqosia na masaoka me gini totu tavota na kô e totu i vavana na masaoka ma na kô e totu i kelana na masaoka. ");
INSERT INTO gri_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Me soaginia na “Masaoka.” Me bongi me matsaraka. Aia na rukanina dani. ");
INSERT INTO gri_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mi muri, ma God e tsaria, “Kara saikolu na kô i vavana na masaoka ma kara totu kesa moa tana nauna, rongona ke gini laba na momoru.” Me laba vaga aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Maia e soaginia na momoru na “Barangengo,” ma na kô e maisai kesa moa tana nauna aia e soaginia na “Tasi.” Ma God e morosia me reingaoa. ");
INSERT INTO gri_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mi muri, maia e tsaria, “Ke labadato tana barangengo pipi sui na vatana na omea tsukatsuka, igira ara tamani piuqira migira ara molo vuaqira,” me laba vaga aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Me vaga ia, mi tana barangengo e dato pipi vatana na omea tsukatsuka, ma God e morosigira me reingaogira. ");
INSERT INTO gri_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Me bongi me matsaraka. Aia na tolunina dani. ");
INSERT INTO gri_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mi muri, ma God e tsaria, “Kara laba na marara tana masaoka ma kara votâ na dani ma na bongi, ma kara gini sauvulagia na tagu na papara ma na tagu na bisi, na dani ma na ngalitupa; ");
INSERT INTO gri_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","migira kara maka tana masaoka ma kara mararasia na barangengo.” Mara laba sui igira na omea aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Me vaga ia, ma God e aqosikaira ruka na marara loki bâ, na aso ke tagaovi kaputia na dani ma na vula ke tagaovi kaputia na bongi; me aqosigira goto na veitugu. ");
INSERT INTO gri_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Maia e mologira na marara girani tana masaoka kara mararasiginia na barangengo, ");
INSERT INTO gri_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma kara tagaovi kaputia na dani ma na bongi, ma kara votâ na marara ma na rodo. Ma God e morosigira me reingaogira. ");
INSERT INTO gri_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Me bongi me matsaraka. Aia na vatinina dani. ");
INSERT INTO gri_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mi muri, ma God e tsaria, “Kara totu i kô mi tasi pipi vatana na tsetse ma na omea mamauri, mi tana masaoka kara danga na manu.” ");
INSERT INTO gri_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Me vaga ia, ma God e volagira na tuqana vigo na omea mamauri i tasi, me pipi vatana na tsetse ma na omea ara mauri i kô mi tasi, me pipi vatana na manu. Ma God e morosigira me reingaogira. ");
INSERT INTO gri_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Maia e tabugira sui, me tsarivanigira na omea sui ara mauri i kô mi tasi kara vasusu ma kara danga, me tsarivanigira goto na manu kara pabo na dangaqira. ");
INSERT INTO gri_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Me bongi me matsaraka. Aia na tsegenina dani. ");
INSERT INTO gri_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mi muri, ma God e tsaria, “Kara laba i laona na barangengo pipi vatana na omea tuavati sui: na ladogana ma na atsina, na lokina ma na tetelona, migira goto na omea ara tere tana kao.” Mara laba vaga aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ma God e aqosigira sui, me morosigira me reingaogira. ");
INSERT INTO gri_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mi muri, ma God e tsaria, “Ida tugita ma ka tu aqosigira na tinoni; ma kara usulia tu nunuda tugita. Ma ka tu tamivanigira kara tagaovi kaputigira na tsetse, ma na manu, me pipi sui na omea tuavati, na ladogana mana atsina,na lokina ma na tetelona, migira sui goto na omea ara tere tana kao.” ");
INSERT INTO gri_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mi tana, maia God e aqosigira na tinoni tana nununa segeni nogo aia. E aqosigira na manena ma na dakina, ");
INSERT INTO gri_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","me tabugira me tsarivaganana vanigira, “Igamu kamu vasusu babâ, ma na kukuamui kara dangalia na barangengo, ma kara tagaovi poponoa na omea sui i laona. Inau au molovanigamu kamu reitutugu kaputigira na tsetse, ma na manu, me pipi sui na omea mamauri ara totu tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mau manogatinogoa vanigamu pipi sui na piuna na omea tsukatsuka, me pipi sui goto na vatana na vuana gai kara lia gamui mutsa; ");
INSERT INTO gri_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","me vanigira na omea tuavati sui, migira sui goto na manu ma na omea ara tere tana kao, au manogatinogoa pipi vatana na rau ma na buruburu kara lia gaqira mutsa igira.” Mara laba sui vaga aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma God e morosigira na omea sui aia e aqosigira, me reingao sosongoligira. Me bongi me matsaraka. Aia na ononina dani. ");
INSERT INTO gri_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mi tana e sui na aqosiana na baragata ma na barangengo migira na omea sui i ka laoqira. ");
INSERT INTO gri_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mi tana vitunina dani ma God e suilavaginia nina aqo, me mango. ");
INSERT INTO gri_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Maia e tabua na vitunina dani me baloa ke lia na dani tabu, rongona tana dani ia God e suilavaginia na volaana pipi sui na omea, me mango na aqo. ");
INSERT INTO gri_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Maia nogo e vaga na vusana na baragata ma na barangengo. Mi kalina na Taovia God e aqosia na baragata ma na barangengo, ");
INSERT INTO gri_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","e tagara goto sa gai ke totu tana barangengo me tagara goto sa vatuna na omea tsukatsuka ke vovodato, rongona aia e tau vati moloa sa usa, me tagara goto ke kesa ke aqo tana kao; ");
INSERT INTO gri_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ma na kô moa e talu i vavana na kao e mao dato me malobusia na kao. ");
INSERT INTO gri_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mi muri, ma na Taovia God e karoa na kao me buloa me aqosiginia na konina na mane; me magoviginia na isuna na mamagona na mauri ma na mane ia e tuturiga na mauri. ");
INSERT INTO gri_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mi muri, ma na Taovia God e tsukâ kesa na uta tana nauna ara soaginia i Eden, tabana tana e dato na aso, mi tana e livua na mane aia e aqosinogoa. ");
INSERT INTO gri_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Me aqosigira goto pipi sui na vatana na gai rerei dou sosongo kara dato tana ma kara molo vuaqira dou. Mi levugana patupatu na uta ia e tû na gai na tusu mauri, ma na gai na tusu sasaga gana na donaginiana na omea e dou ma na omea e seko. ");
INSERT INTO gri_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Me kesa na kô e tave i Eden me malobusia na uta; me ba tavota vati i tabana bâ i Eden me lia vati na kô. ");
INSERT INTO gri_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Na kesanina kô aia na Kô Pison; maia e tatave polia na kao popono i Havila. ");
INSERT INTO gri_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mi tana e totu na qolumila laka, kolugotoa na kô sisigini dou ma na vatu loki matena. ");
INSERT INTO gri_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ma na rukanina kô aia nogo na Kô Gihon; aia e tatave polia na kao popono i Kus. ");
INSERT INTO gri_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ma na tolunina kô aia nogo na Kô Tigris, aia e tave tabana i longa na Asiria, ma na vatinina kô aia nogo na Kô Euprates. ");
INSERT INTO gri_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mi muri, ma na Taovia God e moloa na mane tana Uta ni Eden ke aqo i laona me ke reitutugua. ");
INSERT INTO gri_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Me tsarivania, “Inau au tamivanigo na ganiana na vuaqira pipi sui na gai i laona na uta, ");
INSERT INTO gri_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","maia moa na gai e tusu sasaga gana na donaginia na omea e dou ma na omea e seko e vali vanigo na ganiana na vuana. Me ti vaga ko gania, migoe sauba ko mate tana dani nogo ia.” ");
INSERT INTO gri_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mi muri, ma na Taovia God e tsaria, “E tau dou vania na mane ke totu segeni. Sauba kau aqosia ke kesa ke ulagana ke lia gana totukolu me ke sangâ.” ");
INSERT INTO gri_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Vaga ia maia e karoa na kao me aqosiginigira na omea tuavati sui, ma na manu sui. Mi muri, maia e adigiramai vania na mane ke molo soaqira; maia nogoria e vaga ti igira sui ara gini tamanina tatasa tango kesa na soaqira. ");
INSERT INTO gri_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mi tana, ma na mane ia e molo soaqira babâ pipi sui na manu ma na omea tuavati; me tagara moa sa vidaqira igira ke ulagana ke lia gana totukolu me ke sangâ. ");
INSERT INTO gri_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Te e tû na Taovia God me maturusaginia na mane maia e maturu mate, mi kalina aia e mamaturu, ma God e loqoligia kesa na sulina qaqarona, me ponotivisua na sasana. ");
INSERT INTO gri_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Me aqosiginia na daki na qaqarona na mane ia me adimai vania. ");
INSERT INTO gri_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma na mane e tsaria, “Eo, ia kalinâ e totu kesa e atsa koluau inau, na sulina na suliqu, ma na lakana na lakaqu. Ma kau soaginia ‘daki’ rongona e talu tana mane.” ");
INSERT INTO gri_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aia nogo na rongona ti na mane e mololekaira na tamana ma na tinana me totusai kolua na tauna, mi kaira ruka ara ka lia kesa moa. ");
INSERT INTO gri_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mi kaira sui na mane ma na daki ara ka malaiole sui, mara ka tau moa vangamâ. ");
INSERT INTO gri_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mi laoqira pipi sui na omea mamauri God e aqosigira, aia na muata e kesa na omea e dona sosongo bâ na valovalo. Ma na muata e veisuâ na daki, “?Goena, egua, laka God e tongo vanikagamu manana na ganiana na vuana sa gai e totu i laona na uta iani?” ");
INSERT INTO gri_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ma na daki e gokovisu me tsarivania, “Eo, kami ka ganiragoa na vuaqira pipi sui na gai ara totu i laona na uta iani, ");
INSERT INTO gri_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","me kesa moa na gai aia e tû i levugana patupatu na uta, aia lelê moa na gai God e tongovanikagami na ganiana na vuana, se na peleana goto na gaina; me ti vaga kami ka nauvaganana ia, me sauba kami ka mate.” ");
INSERT INTO gri_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma na muata e tsaria, “E tau saikesa mana ia; sauba e utu kamu ka gini mate. ");
INSERT INTO gri_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Eo, God e tsarivaganana vanikagamu rongona aia e dona laka ti vaga kamu ka gania na vuana gai ia me sauba kamu ka lia vaga nogo God, ma kamu ka donaginia na omea e dou ma na omea e seko.” ");
INSERT INTO gri_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ma na daki e morosi bâ na gai laka e rereidou sosongo me laka ke dou sosongo nomoa ti vaga na ganiana na vuana, me padâ laka ke dou sosongo goto ti vaga aia ke sasaga loki bâ. Te aia e tû me pitsugira visana na vuana me gania. Mi muri, maia e tusugira bâ visana na vuana vania na savana, maia goto e gania. ");
INSERT INTO gri_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mi tana tagu tsotsodo ara ka ganisuia na vuana gai, mara ka reigadovia laka ara ka malaiole; mi tana mara ka tsukisaigira na rauna gai mara ka tsavuginia ka koniqira. ");
INSERT INTO gri_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mi tana ngulavi ia, mi kaira ara ka rongomia na Taovia God e liu i laona na uta, mi kaira ara ka ba taopoi tania i laoqira na gai. ");
INSERT INTO gri_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma na Taovia God e soâ na mane, “?Iava igoe?” ");
INSERT INTO gri_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Maia e gokovisu me tsaria, “Au rongomigo nogo igoe kalina o maimai i laona na uta; mau matagu mau taopoi tanigo rongona au malaiole.” ");
INSERT INTO gri_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ma God e veisuâ, “?Masei e tsarivanigo laka o malaiole? ?Laka igoe o gania na vuana gai inau au valivanigo na ganiana?” ");
INSERT INTO gri_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Me gokovisu na mane me tsaria, “Aia na daki igoe o molokoluau ieni aia nogo e sauvaniau na vuana gai te au gania inau.” ");
INSERT INTO gri_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ma na Taovia God e veisuâ na daki, “?Egua igoe ti o nauvaganana ia?” Ma na daki e gokovisu me tsaria, “Na muata aia nogo e perobulesiau inau te au gania.” ");
INSERT INTO gri_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mi muri, maia na Taovia God e tsarivania na muata, “Rongona nogo igoe o naua na omea iani ti sauba ke gadovigo na kede; mi laoqira na omea mamauri sui igoe segenimu moa sauba kau vealaginigo. Ke tû i dani eni me ke bâ, igoe sauba ko gini tere na tobamu, me sauba ko gania na kao pipi dani i laona na maurimu. ");
INSERT INTO gri_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Me sauba kau naua ma kamu ka vaireisavigi kagamu igoe ma na daki; ma na dalena aia ma na dalemu igoe sauba kara ka vaigalagi sailagi. Ma na dalena aia sauba ke tsogori rutua na lovamu, migoe sauba ko gatia na bobouna na tuana.” ");
INSERT INTO gri_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maia e tsarivania na daki, “Migoe, inau sauba kau paboa nimu rota tana tiana ma nimu vatsangisavi tana vasusu. Me atsa moa ti e vaga ia, me sauba ko kili sailaginia moa na savamu, maia sauba ke tagaovigo.” ");
INSERT INTO gri_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Maia e tsarivanigotoa na mane, “Migoe o rongomangana na taumu mo gania na vuana gai inau au valiginigo na ganiana. Me rongona igoe o nauvaganana ia, ti inau sauba kau ketsoa na kao. Migoe sauba ko aqo rota tana maurimu popono na tsuka mutsa gana ke tugugo. ");
INSERT INTO gri_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Me sauba ke dato na buruburu seko ma na itai kokonaga i laona, migoe sauba ko gania na omea e dato atsi. ");
INSERT INTO gri_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mi tana maono na raemu sauba ko tsodoa gamu mutsa, poi tsau kalina ko visutugua tana kao i tana o talumai. Igoe, inau au aqosiginigo na kao, me sauba ko lia tugua na kao.” ");
INSERT INTO gri_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ma Adam e soaginia na tauna ko Eva rongona aia na tinaqira na tinoni sui. ");
INSERT INTO gri_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma na Taovia God e aqosipolo ginia na kokorana na omea tuavati vanikaira a Adam ma ko Eva, me pipisiginikaira. ");
INSERT INTO gri_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mi muri, ma na Taovia God e tsaria, “Kalina ia na mane iani e lia vaga nogo kesa tu vidada tugita, me dona na padagadoviana na omea e dou ma na omea e seko. E tau dou ka tu tamivania ke ganigotoa na vuana na gai na tusumauri, me ke gini mauri saviliu.” ");
INSERT INTO gri_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Me tû na Taovia God me tsialigia tania na Uta ni Eden, me ketsalia ke ba aqo tana kao i tana aia e talumai. ");
INSERT INTO gri_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mi muri, maia e mologira na angelo kara totu i tano tabana tana e dato na aso, ma kara matalia na uta, me mologotoa kesa na isi iruiru e aro kalea moa pipi nauna. Iani ke gini utusigotoa ke kesa na mai varangisiana na gai na tusumauri. ");
INSERT INTO gri_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ma Adam e maturu kolua na tauna, maia e tiana. Me vasua kesa na dalena mane me tsaria, “Tana nina sasanga nogo na Taovia te au gini tamanina kesa na dalequ mane.” Maia e soaginia a Kain. ");
INSERT INTO gri_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mi murimai, maia e vasugotoa kesa na dalena mane, me soaginia a Abel. Ma Abel e lia na mane reitutugu sipi, ma Kain aia na mane aqo kao. ");
INSERT INTO gri_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Me kesa tana tagu i muri, ma Kain e adimaigira visana na vuana nina omea tsukatsuka me gini savorigira vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Abel e adimaigotoa na kesanina dalena sipi e botsa tana nina sipi, me matesia, me savoria na turina dou bâ vaga nina sausau. Ma na Taovia e reingaoa a Abel ma nina sausau, ");
INSERT INTO gri_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","me sove tania a Kain ma nina sausau. Mi tana ma Kain e kore loki sosongo me iru matana. ");
INSERT INTO gri_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ma na Taovia e tsarivania a Kain, “Rongona gua ti o kore igoe? ?Ma na rongona gua goto te e iru matamu? ");
INSERT INTO gri_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ti vaga igoe o naua na omea e goto, me sauba ke moro magemage na matamu; mi tana rongona igoe o naua na omea e seko, ma na sasi e pipitu nogo tana matsapamu. Aia e ngaoa ke tagaovigo, migoe nimu aqo ko tovokakaia na tuliusiana.” ");
INSERT INTO gri_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Me kesa dani, ma Kain e tsarivania a Abel na kulana, “Ida kaita ma ka vano tana uta.” Mi kalina ara ka ba tsau tana uta, ma Kain e pilo me labumatesia na kulana. ");
INSERT INTO gri_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ma na Taovia e veisuâ a Kain, “?A Kain, iava a Abel na kulamu?” Ma Kain e tuguvisua me tsaria, “Inau au tau dona. ?Egua, laka niqu aqo goto inau na reitutuguana na kulaqu?” ");
INSERT INTO gri_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mi muri, ma na Taovia e tsarivania, “?Rongona gua ti igoe o naua na omea seko loki vaga ia? Na gabuna na kulamu e ngangaidato vaniau talu tana kao. ");
INSERT INTO gri_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mi kalina ia, inau au vealaginigo igoe, me utu goto ko tsuka omea tana kao. Rongona na kao e inuvinogoa na gabuna na kulamu, vaga moa ti e sangavia na mangana gana ke inuvia kalina igoe o labumatesia na kulamu. ");
INSERT INTO gri_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Me ti vaga igoe ko tovotugua na tsuka mutsa, ma na kao e utu ke molovanigo sa vuana; me sauba ke tagara goto sa veramu, migoe ko tonavia moa na barangengo.” ");
INSERT INTO gri_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Kain e tsarivania na Taovia, “!Lao Taovia, na kede ia e kakai sosongo vaniau! ");
INSERT INTO gri_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Igoe o tsialigiau inau tania na kao me tanigotoa na matamu igoe. Mo tsarivaniau goto laka sauba kau tau tamani sa veraqu ma kau tanotia na barangengo, masei moa ke tsodoau sauba ke matesiau.” ");
INSERT INTO gri_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma na Taovia e tsarivania, “Tagara. Ti vaga kesa ke matesigo, mi tana tangotugumu igoe sauba kara vitu na tinoni kara mate.” Me vaga ia, ma na Taovia e moloa kesa na padapada i konina a Kain gana na parovataviaqira na tinoni kara tsodoa kara laka na labumatesiana. ");
INSERT INTO gri_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ma Kain e vanoligi tania na matana na Taovia, me ba totu tana vera ara soaginia “Tonatia,” aia e totu tabana na Eden i tana e dato na aso. ");
INSERT INTO gri_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaira a Kain ma na tauna ara ka tamani kesa ka daleqira mane, mara ka soaginia a Enok. Mi muri, ma Kain e logoa kesa na verabau me tamavuginia na dalena. ");
INSERT INTO gri_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ma Enok e tamani kesa na dalena mane me soaginia a Irad, maia na tamana a Mehujael, ma Mehujael e tamani kesa na dalena mane me soaginia a Metusael, maia na tamana a Lamek. ");
INSERT INTO gri_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","A Lamek e tamanikaira ruka na tauna, kaira ko Adah ma ko Sila. ");
INSERT INTO gri_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ma ko Adah e vasua a Jabal, aia na mumuaqira igira ara reitutugu buluka mara mauri tana valepolo. ");
INSERT INTO gri_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Maia Jubal na kulana, aia na mumuaqira igira sui ara dona na gini sinagi na itai tatangi ma na uete. ");
INSERT INTO gri_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma ko Sila e vasua a Tubal Kain, aia e dona na aqosiginiaqira na tapalamila ma na tapala laka na omea levolevo gana na aqo. Maia ko Naama na tasina daki a Tubal Kain. ");
INSERT INTO gri_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma Lamek e tsarivanikaira na tauna, “Kagamu ko Ada ma ko Sila, kamu ka rongomiau inau: Inau au labumatesia kesa na mane vaolu rongona aia e labuau inau. ");
INSERT INTO gri_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Me ti vaga kara tu vitu na tinoni kara tu mate tana rongona na tangotuguna a Kain, ma kara vitu sangavulu vitu kara mate ti vaga ke kesa ke labumatesiau inau.” ");
INSERT INTO gri_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mi kaira a Adam ma ko Eva ara ka tamanigotoa kesa ka daleqira mane. Ma ko Eva e tsaria, “God e sauvaniau kesa goto na dalequ mane na tuguna a Abel, aia Kain e labumatesia.” Maia e soaginia a Set. ");
INSERT INTO gri_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ma Set e tamanina kesa na dalena mane maia e soaginia a Enos. Mi tana tagu nogo ia, ti igira na tinoni ara tuturiga na gini aqo na asana tabu na Taovia tana samasama. ");
INSERT INTO gri_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iani e vaga na mamareqira igira na kukuana a Adam. Kalina God e aqosigira na tinoni, maia e aqosigira tana nununa segeni. ");
INSERT INTO gri_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Aia e aqosigira na manena ma na dakina, me tabugira me soaginigira “Tinoni.” ");
INSERT INTO gri_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mi kalina a Adam e tsaulia 130 ngalitupana aia e tamanina goto kesa na dalena mane maia e usuli saikesalia na tamana, me soaginia a Set. ");
INSERT INTO gri_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Mi murina ia, ma Adam e mauri goto 800 na ngalitupa. Maia e tamanina goto visana na dalena i muri, ");
INSERT INTO gri_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","me mate kalina e 930 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mi kalina a Set e 105 ngalitupana, maia e tamanina kesa na dalena mane, me soaginia a Enos, ");
INSERT INTO gri_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","mi muri maia e mauri goto 807 ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","me mate kalina e 912 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mi kalina a Enos e 90 ngalitupana, maia e tamanina kesa na dalena mane, a Kenan na soana, ");
INSERT INTO gri_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","mi muri, maia e mauri goto 815 ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","me mate kalina e 905 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mi kalina a Kenan e 70 ngalitupana, maia e tamanina kesa na dalena mane, a Mahalalel na soana, ");
INSERT INTO gri_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","mi muri, maia e mauri goto 840 ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","me mate kalina e 910 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mi kalina a Mahalalel e 65 ngalitupana, maia e tamanina kesa na dalena mane, a Jared na soana, ");
INSERT INTO gri_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","mi muri, maia e mauri goto 830 ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","me mate kalina e 895 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mi kalina a Jared e 162 ngalitupana, maia e tamanina kesa na dalena mane, a Enok na soana, ");
INSERT INTO gri_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","mi muri, maia e mauri goto 800 na ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","me mate kalina e 962 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mi kalina a Enok e 65 ngalitupana, maia e tamanina kesa na dalena mane, a Metusela na soana. ");
INSERT INTO gri_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mi murina ia, ma Enok e mauripata dou kolua God i laona 300 na ngalitupa me tamanigotoa visana na dalena. ");
INSERT INTO gri_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Maia e mauri tsaulia 365 na ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Mi tana maurina popono, aia e mauripata dou kolua God, mi muri maia e tavongani nanga lê, rongona God nogo e adiligia tania na barangengo. ");
INSERT INTO gri_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mi kalina a Metusela e 187 ngalitupana, maia e tamanina kesa na dalena mane, a Lamek na soana, ");
INSERT INTO gri_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","mi muri, me mauri goto 782 na ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","me mate kalina e 969 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mi kalina a Lamek e 182 ngalitupana, maia e tamanina kesa na dalena mane, ");
INSERT INTO gri_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","me tsaria, “Na baka iani sauba ke tabegita me ke gini malamala vanigita pipi nida aqo kakai tana kao aia na Taovia e ketsonogoa”; me vaga ia, maia e soaginia a Noa. ");
INSERT INTO gri_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ma Lamek e mauri goto 595 na ngalitupa. Maia e tamanigotoa visana na dalena, ");
INSERT INTO gri_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","me mate kalina e 777 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mi muri, kalina e 500 nogo na ngalitupana a Noa, maia e tamanitugira tolu na dalena mane, a Sem, ma Ham ma Japet. ");
INSERT INTO gri_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mi kalina ara dangadato na tinoni tana barangengo, mara danga na baka daki ara botsa, ");
INSERT INTO gri_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","mara visana na tarunga ni gotu ara reia laka na baka daki girani ara rerei dou sosongo, te igira ara tsunamai mara laugira na baka daki igira ara reingaogira bâ. ");
INSERT INTO gri_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mi tana ma na Taovia e tsaria, “E utu inau kau tamivanigira na tinoni kara mauri saviliu rongona igira na tinoni lê moa. Me tû i dani eni me ke bâ, migira sauba kara tau goto mauri oka liusia kesa sangatu rukapatu na ngalitupa.” ");
INSERT INTO gri_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mi tana tagu ia, mi murimai goto, ara totu na mumû tana barangengo, igira nogo na kukuaqira na daki ma na tarunga ni gotu. Igira nogo na tinoni malagai susuliga bâ me tangiloki gaqira rongo tana tagu ni sau. ");
INSERT INTO gri_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mi kalina na Taovia e reia e tabaru sosongo niqira sasaga na tinoni sui tana barangengo, me laka niqira papada e sasi moa pipi kalina, ");
INSERT INTO gri_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ma na Taovia e padasavi sosongo rongona aia e aqosigira me mologira tana barangengo. Me gini melu loki sosongo tobana, ");
INSERT INTO gri_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","me tsaria, “Inau sauba kau matesiligigira sui saikesa na tinoni girani inau au aqosigira, migira goto na omea tuavati sui, ma na omea ara tere tana kao, ma na manu, rongona inau au gini padasavi sosongo matena au aqosigira.” ");
INSERT INTO gri_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maia lelê moa a Noa na Taovia e reingaoa nina sasaga. ");
INSERT INTO gri_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Iani nogo e vaga na turupatu tana rongona a Noa. Aia e tamanitugira tolu na dalena mane, i tugira nogo a Sem, ma Ham ma Japet. A Noa e tau tsukia sa sasi, maia lelê moa kesa na mane e gotolaka nina sasaga tana tagu ia. Aia e mauripata dou kolua God, ");
INSERT INTO gri_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","migira sui lakalaka na tinoni tavosi sui ara sasi saviliu i matana God, ma na tangopeke seko loki moa e saranga bamai pipi tana nauna. ");
INSERT INTO gri_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ma God e morosia na barangengo, me reia laka e seko sosongo, rongona igira na tinoni sui ara mauri moa tana sasi. ");
INSERT INTO gri_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ma God e tsarivania a Noa, “Inau au padâ kau suilavaginigira saikesa na tinoni sui. Sauba kau matesigira sui lakalaka rongona na barangengo e gini dangadato moa niqira sasaga tabaru. ");
INSERT INTO gri_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Igoe ko kavia kesa nimu vaka ginia na gai kakai dou; mo ko aqosigira ke visana na voki i laona mo ko bulu poponoginia na tita i laona mi taba. ");
INSERT INTO gri_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ko aqosia ke sangava ono sangavulu ono tabailima na katsina, me ke sangava sangavulu kesa na damana, me ke sangava ono tabailima na datona. ");
INSERT INTO gri_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ko aqosia na valena mo ko moloa ke tinaqe ruka na damana ke mangamanga i ka levugaqira na valena ma na ponoponona gana ke gini sage na marara. Mo ko aqosia ke tolu na vatabela mo ko moloa kesa na matsapa tana liligina. ");
INSERT INTO gri_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Inau sauba kau alomaia kesa na obo loki tana barangengo me ke matesiligigira pipi sui na omea mamauri. Pipi sui lakalaka na omea tana barangengo sauba kara mate, ");
INSERT INTO gri_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","migoe moa inau sauba kau naua kesa na vaitasogi kolugo. Igoe ko sage i laona na vaka kolua na taumu, mi tugira na dalemu ma tu tauqira. ");
INSERT INTO gri_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ko adisagegira kolugo i laona na vaka kesa na dakina ma kesa na manena pipi sui na vatana na omea tuavati, me pipi sui na vatana na manu, me pipi sui na vatana na omea ara tere tana kao, kara sogoga gana kara gini mauri. ");
INSERT INTO gri_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mo ko adisagegotoa pipi sui na vatana na mutsa, na gamui igamu ma gaqira goto igira.” ");
INSERT INTO gri_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma Noa e naua pipi sui na omea aia God e ketsalia ke naua. ");
INSERT INTO gri_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Na Taovia e tsarivania a Noa, “Ko sage i laona na vaka kolugira nimu tamadale popono; inau au tsodoa laka igoe segeni lelê moa i laona barangengo o naua na omea e goto. ");
INSERT INTO gri_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ko adisage kolugo kara sogoga vitu pipi vatana na omea tuavati igira e ulagana na gini savori-kodoputsa, me ke sogoga kesa moa igira na omea tuavati tavosi sui. ");
INSERT INTO gri_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ko adisagegira goto kara sogoga vitu pipi vatana na manu sui. Ko naua vaganana ia rongona kara gini mauri pipi sui na vatana na omea tuavati ma na manu, ma kara gini vasusu dato tugua tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Me kau moa ke vitu na dani minau sauba kau moloa na usa ke tumu ke vati sangavulu na dani me ke vati sangavulu na bongi, gana kau gini matesiligigira pipi sui na omea mamauri inau au aqosigira.” ");
INSERT INTO gri_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma Noa e naua pipi sui na omea aia na Taovia e ketsalia ke naua. ");
INSERT INTO gri_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","E ono sangatu na ngalitupana a Noa kalina e tave na obo loki tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Aia ma na tauna, mi tugira na dalena mane ma tu tauqira ara tu sage tana vaka gana kara tu gini mauri tania na obo loki ia. ");
INSERT INTO gri_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Me pipi sui na vatana na omea tuavati ma na manu ma na omea ara tere tana kao, na dakina ma na manena, atsa moa igira e ulagana na gini savori-kodoputsa migira e tagara, ");
INSERT INTO gri_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ara sage kolua a Noa tana vaka, vaga nogo na omea God e ketsalia. ");
INSERT INTO gri_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Me vitu na dani i muri me tave na obo loki tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mi kalina e ono sangatu na ngalitupana a Noa, tana sangavulu vitunina dani na rukanina vula, me pipi sui na mangamanga na kô loki i vavana na barangengo ara viri botsadato, me pipi sui na matsapakapuna na obo tana masaoka ara viri sangavi sui, ");
INSERT INTO gri_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ma na usa e tumu tana barangengo e vati sangavulu na dani me vati sangavulu na bongi. ");
INSERT INTO gri_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mi tana dani tsotsodo nogo ia, a Noa ma na tauna ara ka sage tana vaka kolutugira tolu ka daleqira mane, tugira nogo a Sem, ma Ham ma Japet, kolutugira goto tu tauqira. ");
INSERT INTO gri_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Mara sage kolugira goto tana vaka pipi sui na vatana na omea tuavati, ma na omea ara tere tana kao, ma na manu, na ladogana ma na atsina, na lokina ma na tetelona. ");
INSERT INTO gri_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","E kesa na manena me kesa na dakina tana pipi vatana na omea mamauri ara sage kolua a Noa tana vaka, ");
INSERT INTO gri_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","vaga nogo na omea e ketsalia God. Mi muri, ma na Taovia e vongo kapusia na banina na vaka. ");
INSERT INTO gri_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Na obo loki e babâ moa i laona vati sangavulu na dani, ma na kô e mao me gini tugua na vaka ke tsobo. ");
INSERT INTO gri_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma na kô e mao babâ moa, ma na vaka e tsotsobo bamai i kelana kô. ");
INSERT INTO gri_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ma na kô e mao sosongo goto bâ me gini tsavugira na vungavunga dato ao liuliu bâ; ");
INSERT INTO gri_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","me babâ moa na maona na kô poi tsau e sangava tolu tabailima na datona liusigira na vungavunga sui. ");
INSERT INTO gri_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mara gini mate pipi sui na omea mamauri tana barangengo, pipi sui na manu ma na omea ara tere tana kao, me pipi sui na omea tuavati, me pipi sui goto na tinoni. ");
INSERT INTO gri_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Pipi sui moa na omea ara magomago tana barangengo ara mate. ");
INSERT INTO gri_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Na Taovia e matesigira pipi sui lakalaka na omea mamauri tana barangengo, na tinoni, na omea tuavati, na omea ara tere tana kao, ma na manu. Maia Noa segeni moa migira ara sage kolua tana vaka ara tau mate. ");
INSERT INTO gri_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma na kô e tau goto tsuna i laona kesa sangatu me tsege sangavulu na dani. ");
INSERT INTO gri_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma God e tau padalea a Noa migira na omea mamauri sui ara totu kolua tana vaka; maia e tû me molomaia na guguri, ma na kô e gini tuturiga na tsuna. ");
INSERT INTO gri_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Migira na manga manga na kô loki i vavana na bara ngengo ma na matsapakapuna na obo tana masaoka ara vongotugua. Ma na usa e sui, ");
INSERT INTO gri_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","mi laona kesa sangatu tsege sangavulu na dani na kô e kiki rago e tavalala. ");
INSERT INTO gri_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tana sangavulu vitunina dani tana vitunina vula na vaka e mai toga i kelana kesa na vungavunga i Ararat. ");
INSERT INTO gri_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ma na kô e tavalala babâ moa, mi tana kesanina dani tana sangavulunina vula ma na kelaqira na vungavunga ara laba. ");
INSERT INTO gri_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Me putsi vati sangavulu na dani, ma Noa e sangavia kesa na ovaovana bisi ");
INSERT INTO gri_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","me molo rutsumia kesa na kaokao. Ma na kaokao ia e tau visu mai, aia e lolovo polipoli moa poi e tsau kalina e tavalala saikesa na kô. ");
INSERT INTO gri_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Mi muri, ma Noa e molo rutsumigotoa kesa na kulukulu ke reia ti vaga ke tsuna nogo na kô, ");
INSERT INTO gri_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ma na rongona na kô e tau vati tsuna saikesa moa me tsavu poponoa moa na kao, ma na kulukulu ia e tau tangomana ke tao. Maia e lovo visutugua tana vaka, ma Noa e molo rutsumia na limana me adisagetugua i laona na vaka. ");
INSERT INTO gri_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ma Noa e pipitu goto vitu na dani ti e molo rutsumitugua na kulukulu. ");
INSERT INTO gri_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mi tana ngulavi ma na kulukulu e visumaitugua kolua kesa na arana vaolu na gai na olive tana mangana. Mi tana ma Noa e donaginia laka e tsuna nogo na kô. ");
INSERT INTO gri_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mi muri, maia e pipitu vitu goto na dani te e molo rutsumitugua na kulukulu kesa goto kalina; ma na kulukulu ia e tau goto visumai. ");
INSERT INTO gri_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mi kalina e 601 ngalitupana a Noa, tana kesanina dani tana kesanina vula, ma na kô e tsuna saikesa. Ma Noa e adiligia na tsatsavuna na vaka, me tû me moro bamai, me reia laka na kao e tuturiga nogo na mamatsa. ");
INSERT INTO gri_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mi tana rukapatu vitunina dani tana rukanina vula, ma na barangengo e mamatsa saikesa. ");
INSERT INTO gri_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ma God e tsarivania a Noa, ");
INSERT INTO gri_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ko rutsu tania na vaka kolua na taumu me kolutugira goto na dalemu mane ma tu tauqira. ");
INSERT INTO gri_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mo ko molo rutsumigira sui goto na manu ma na omea tuavati ma na omea ara tere tana kao, rongona igira kara vasusu dato ma kara dangalia na barangengo popono.” ");
INSERT INTO gri_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Mi tana, ma Noa ma na tauna kolutugira goto na dalena ma tu tauqira ara tu rutsu tania na vaka. ");
INSERT INTO gri_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Me pipi sui lakalaka na omea tuavati ma na omea ara tere tana kao ma na manu ara alarutsu tania na vaka kolugira gaqira kamaga. ");
INSERT INTO gri_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ma Noa e tû me logoa kesa na belatabu vania na Taovia; maia e adia kesa i laoqira pipi vatana ma omea tuavati ma na manu igira e ulagana na gini savori-kodoputsa, me kodo poponogira vaga na savori-kodokodo i kelana na belatabu. ");
INSERT INTO gri_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma na Taovia e siginingaoa na vuruna na kodoputsa ia, maia e tsarisegenina, “E utu saikesa goto inau kau ketsotugua na barangengo tana rongona na omea ara naua igira na tinoni. Inau au donagininogoa laka tû kalina igira ara tinoni vaolu me sasi niqira papada. Me utu saikesa goto kau matesigira pipi na omea mamauri sui vaga inau au naunogoa tana tagu eni. ");
INSERT INTO gri_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mi tana tagu popono ke totu na barangengo, sauba ke totu saviliu na tagu na tsutsuka ma na tagu na pipitsu, na tagu na bisi ma na tagu na papara, na aso ma na usa, na dani ma na bongi.” ");
INSERT INTO gri_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ma God e tabua a Noa mi tugira na dalena mane me tsarivanitugira, “Kamu tu tamanina ke danga tu dalemui, rongona tu kukuamui tugamu kara dangaliginia na barangengo popono. ");
INSERT INTO gri_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Me pipi sui na omea tuavati, ma na manu, ma na omea ara tere tana kao, ma na tsetse sauba kara matagunigamu igamu. Inau au mologira sui i vavana nimui tagao nogo igamu. ");
INSERT INTO gri_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mi kalina ia, igamu tangomana kamu ganigira, kolugira goto na omea tsukatsuka; inau au saugira sui vanigamu kara lia gamui mutsa. ");
INSERT INTO gri_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Me kesa moa na omea e vali vanigamu kamu gania, aia nogo na velesina sabo e totu moa na gabu i konina. Inau au tongoa na omea iani rongona tana gabu nogo e totu na mauri. ");
INSERT INTO gri_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Me ti vaga ke kesa ke matesia kesa tinoni maia sauba ke gadovikede. Minau sauba kau kede matesia na omea tuavati aia e matesia kesa tinoni. ");
INSERT INTO gri_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Inau nogo au aqosigira na tinoni tana nunuqu segeni, me vaga ia, masei ke tû me ke labumatesia kesa tinoni, me sauba na tinoni tavosi kara labumatesigotoa aia. ");
INSERT INTO gri_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Igamu nimui aqo kamu tamani ke danga na dalemui, rongona na kukuamui kara dangaliginia na barangengo popono.” ");
INSERT INTO gri_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mi muri, ma God e tsarigotoa vanitugira a Noa ma na dalena, ");
INSERT INTO gri_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kalina ia, inau au vaturia niqu taso kolutugamu me kolugira goto tu kukuamui kara botsamai tu murimui, ");
INSERT INTO gri_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","me kolugira goto pipi na omea mamauri sui: na manu, na buluka, ma na omea tuavati sui, ara rutsumai kolutugamu talu i laona na vaka. ");
INSERT INTO gri_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Migirani nogo na gokona na taso inau au naukolugamu: inau au vekevanigamu laka e utu goto ke tavetugua na obo loki vaga ia ke obotia na barangengo popono me ke matesigira na tinoni sui. ");
INSERT INTO gri_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Iani nogoria na papadana na taso inau segeniqu au vaturia kolugamu me kolugira pipi sui na omea mamauri, ");
INSERT INTO gri_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","au moloa na vulagaro i gotu tana parako, na papadana niqu vaitasogi koluana na barangengo. ");
INSERT INTO gri_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Me pipi kalina kau sarosaigira na parako kara tsavua na barangengo ma na vulagaro ke laba tana parako, ");
INSERT INTO gri_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","minau sauba kau padatugua niqu taso au naukolugamu me kolugira sui goto na omea mamauri, laka e utu saikesa ke tavetugua kesa na obo seko me ke matesigira na omea mamauri sui. ");
INSERT INTO gri_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mi kalina ke laba na vulagaro tana parako, minau sauba kau morosia ma kau padavisua na taso saliu inau au naukolugira na omea mamauri sui tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Na vulagaro aia nogoria na papadana na veke au naua kalina eni vanigira na omea mamauri sui.” ");
INSERT INTO gri_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Tugira na dalena mane a Noa ara tu rutsu tania na vaka, tugira nogo a Sem ma Ham ma Japet. Ma Ham aia na tamana a Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tugirani tolu na dalena a Noa na mumuaqira na tinoni sui tana barangengo. ");
INSERT INTO gri_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","A Noa, aia na maneaqo kao, maia nogo na kesanina mane e tsukâ na itai na uaeni, me aqosi uaeni. ");
INSERT INTO gri_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mi muri, maia e inuvia me ulavia, me tsorâ na polona me tsaro malaiole i laona nina valepolo. ");
INSERT INTO gri_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mi kalina a Ham, aia na tamana a Kanaan, e mai me reia laka e tsaro malaiole na tamana, maia e rutsu i tano me ba tsarivanikaira na kulana. ");
INSERT INTO gri_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mi kaira a Sem ma Japet ara ka adia kesa na polo, mara ka tangoli tavamurisia tana kokoveqira. Mara ka vanovano tavamuri sage tana valepolo gana kara ka tau reia na malaiolena ka tamaqira, mara ka ba tsavuginia. ");
INSERT INTO gri_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mi kalina e sasaga visutugua a Noa me rongomia na omea na dalena tumuri e nauvania ");
INSERT INTO gri_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","maia e tsaria, “!Inau au vealaginia a Kanaan! Maia sauba ke tseka vanigira na tasina. ");
INSERT INTO gri_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","!Tsonikaea na Taovia nina God a Sem! A Kanaan sauba ke tseka vania a Sem. ");
INSERT INTO gri_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","!Aia God ke vangalaka vania a Japet ma kara danga na dalena! !Migira na kukuana kara maurisai kolugira nina tinoni a Sem! Maia Kanaan sauba ke tseka goto vania a Japet.” ");
INSERT INTO gri_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mi murina na obo loki ma Noa e mauri goto 350 na ngalitupa, ");
INSERT INTO gri_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","maia e 950 ngalitupana kalina e mate. ");
INSERT INTO gri_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Igirani nogo na kukuaqira tugira na dalena mane a Noa, tugira a Sem, ma Ham ma Japet. Tugira tolu ara tu tamani tu daleqira mane murina na obo loki. ");
INSERT INTO gri_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Migirani na dalena a Japet: a Gomer, ma Magog, ma Madai, ma Javan, ma Tubal, ma Mesek ma Tiras, tugira nogo na mumuaqira na tinoni ara totu tana vera ara tangomalavuginia tu soaqira. ");
INSERT INTO gri_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Migira na kukuana a Gomer igira nogo na tinoni ni Askenas, mi Ripat mi Togarma. ");
INSERT INTO gri_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Migira na kukuana a Javan igira nogo na tinoni ni Elisa, mi Spain, mi Siprus mi Rodes; ");
INSERT INTO gri_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","migira nogo na mumuaqira igira na tinoni ara totu liligina tasi mi tana momoru tetelo. Igira nogo na kukuana a Japet, ara mauri i laona niqira puku ma na veraqira tatavosi, me pipi kesa na alaala ara gini goko niqira goko segeni. ");
INSERT INTO gri_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Migirani nogo na dalena a Ham: a Kus, ma Ejipt, ma Libia, ma Kanaan, tugira nogo na mumuaqira na tinoni ara totu tana vera ara tangomalavuginia tu soaqira. ");
INSERT INTO gri_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Migira na kukuana a Kus igira nogo na tinoni ni Seba, mi Havila, mi Sabta, mi Raama, mi Sabteka. Migira na kukuana a Raama, igira nogo na tinoni ni Seba mi Dedan. ");
INSERT INTO gri_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","A Kus e tamanina kesa na dalena mane a Nimrod na soana, maia nogo na kesanina malagai susuliga tana barangengo e tangiloki na soana. ");
INSERT INTO gri_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tana nina sasanga nogo na Taovia te a Nimrod e dona dou na rugu, maia nogoria na rongona te ara gini tsaria na tinoni na goko vaga iani, “!Na Taovia ke naua migoe ko lia na mane na rugu malagai vaga nogo a Nimrod!” ");
INSERT INTO gri_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Tana idana ma nina tagao a Nimrod e adisaitugira na vera ni Babilon mi Erek mi Akad, tugira sui tolu na vera tugirani ara tu totu i laona na Babilonia. ");
INSERT INTO gri_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Me tû tana, maia e vano i Asiria me logogira na verabau ni Nineve, mi Rehobot Ir, mi Kala, ");
INSERT INTO gri_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mi Resen, aia e totu ka levugaqira Nineve ma na verabau loki ni Kala. ");
INSERT INTO gri_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Igira na kukuana a Ejipt igira nogo na tinoni ni Lidia, mi Anam, mi Lehab, mi Naptu, ");
INSERT INTO gri_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","mi Patrus, mi Kaslu, mi Krete, igira nogo na mumuaqira igira na Pilistia. ");
INSERT INTO gri_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Mi kaira na dalena a Kanaan, kaira nogo a Sidon aia na idana dalena, ma Het, kaira nogo na mumuaqira na tinoni ara totu tana vera ara tangomalavuginia ka soaqira. ");
INSERT INTO gri_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Maia goto a Kanaan na mumuaqira igira na Jebus, ma na Amor, ma na Gergas, ");
INSERT INTO gri_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Hivi, na Arka, na Sini, ");
INSERT INTO gri_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Arvad, na Semar ma na Hamat. Igira na puku tavosi babâ i laoqira na Kanaan ara tavota, ");
INSERT INTO gri_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","poi niqira votavota igira na Kanaan e tsau bâ tû i Sidon me tada bâ i Gerar varangisia i Gasa, me longa bâ i Sodom, mi Gomora, mi Adma mi Seboim varangisia i Lasa. ");
INSERT INTO gri_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Igirani nogo na kukuana a Ham ara mauri i laona niqira puku ma na veraqira tatavosi, me pipi kesa alaala ara gini goko niqira goko segeni. ");
INSERT INTO gri_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ma Sem, aia na kulana loki a Japet, maia nogo na mumuaqira igira sui na Hibru. ");
INSERT INTO gri_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Migirani nogo na dalena a Sem: a Elam, ma Asur, ma Arpaksad, ma Lud, ma Aram, tugirani nogo tu mumuaqira na tinoni tana vera ara tangomalavuginia tu soaqira. ");
INSERT INTO gri_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Migira na kukuana a Aram igira nogo na tinoni ni Us, mi Hul, mi Geter, mi Mesek. ");
INSERT INTO gri_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ma Arpaksad na tamana a Sela, ma Sela na tamana a Eber. ");
INSERT INTO gri_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ma Eber e tamanikaira ruka na dalena mane: kesa ara soaginia a Peleg rongona tana tagu e mamauri moa aia migira na tinoni tana barangengo ara tavota; ma na rukanina dalena ara soaginia a Joktan. ");
INSERT INTO gri_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Migira na kukuana a Joktan igira nogo na tinoni ni Almodad, mi Selep, mi Hasarmavet, mi Jera, ");
INSERT INTO gri_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","mi Hadoram, mi Usal, mi Dikla, ");
INSERT INTO gri_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","mi Obal, mi Abimael, mi Seba, ");
INSERT INTO gri_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","mi Opir, mi Havila, mi Jobab. Igirani sui na kukuana a Joktan. ");
INSERT INTO gri_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ma na kao ara totuvia igira e tû i Mesa me tsau bâ i Separ tana kao vungavungaga i longa. ");
INSERT INTO gri_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Igirani nogo na kukuana a Sem ara mauri i laona niqira puku ma na veraqira tatavosi, me pipi kesa alaala ara gini goko niqira goko segeni. ");
INSERT INTO gri_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ma na tinoni sui girani na kukuana sui moa a Noa, taonia niqira vasusu, mara totu babâ tana niqira duli ma na veraqira tatavosi. Mi murina na obo loki migira na puku sui tana barangengo ara talu sui moa tu koniqira tugira na dalena a Noa. ");
INSERT INTO gri_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tana idana igira sui na tinoni tana barangengo popono ara tamanina kesa moa na goko ara gini gogoko. ");
INSERT INTO gri_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mi kalina igira ara tavetada bamai na lalaveana tana nauna i tana kara totu, mara ba tsodoa kesa na poi atsa i longa tana Babilonia mara totu i tana. ");
INSERT INTO gri_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mara vaitsarigi, “!Mai! Ida igita ma ka aqosi briki, ma kara kakai dou.” Me vaga ia mara tamanina na briki gana na logovera ma na tita gana kara tangolisaiginigira. ");
INSERT INTO gri_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Mara tsaria, “Kalina ia, ida ma ka logoa kesa na verabau kolua kesa na kusudato ke tsau bâ tana masaoka, rongona ke gini tangiloki na soada ma ka gini tau saranga bamai tana barangengo popono.” ");
INSERT INTO gri_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mi tana, ma na Taovia e tsunamai na morosiana na verabau ma na kusudato igira ara logoa, ");
INSERT INTO gri_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","maia e tsaria, “Kalina ia igirani sui ara kesa moa tinoni, mara kesa moa goko; ma na omea ara naua iani aia nogo na tuturigana moa na omea sauba kara naua. !Me ke tau oka me sauba goto kara tangomana na nauana pipi sui moa na omea ara padangaoa! ");
INSERT INTO gri_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ida gita ma ka tsuna bâ ma ka laloa niqira goko, rongona kara gini tau vairongomigadovigi.” ");
INSERT INTO gri_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Me vaga ia, ma na Taovia e sarangasigira tana barangengo popono, mara mololea na logoana na verabau ia. ");
INSERT INTO gri_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ma na verabau ia ara soaginia Babilon rongona i tana nogo na Taovia e laloa niqira goko na tinoni sui, me tû i tana aia e sarangasigira bâ tana barangengo popono. ");
INSERT INTO gri_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Igirani nogo na kukuana a Sem. E ruka moa na ngalitupa murina na obo loki kalina a Sem e 100 ngalitupana, maia e tamanina kesa na dalena mane, a Arpaksad na soana. ");
INSERT INTO gri_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mi murina ia, maia e mauri goto 500 na ngalitupa me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mi kalina a Arpaksad e 35 ngalitupana, maia e tamanina kesa na dalena mane a Sela na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","mi murina ia, maia e mauri goto 403 na ngalitupa me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mi kalina a Sela e 30 ngalitupana, maia e tamanina kesa na dalena mane a Eber na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","mi murina ia, maia e mauri goto 403 na ngalitupa me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mi kalina a Eber e 34 ngalitupana, maia e tamanina kesa na dalena mane a Peleg na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","mi murina ia, maia e mauri goto 430 na ngalitupa ma tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mi kalina a Peleg e 30 ngalitupana, maia e tamanina kesa na dalena mane, a Reu na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","mi murina ia, maia e mauri goto 209 na ngalitupa me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mi kalina a Reu e 32 ngalitupana, maia e tamanina kesa na dalena mane, a Serug na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","mi murina ia, maia e mauri goto 207 na ngalitupa, me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mi kalina a Serug e 30 ngalitupana, maia e tamanina kesa na dalena mane, a Nahor na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","mi murina ia, maia e mauri goto 200 na ngalitupa, me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mi kalina a Nahor e 29 ngalitupana, aia e tamanina kesa na dalena mane, a Tera na soana; ");
INSERT INTO gri_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","mi murina ia, maia e mauri goto 119 na ngalitupa, me tamanigotoa visana na dalena i muri. ");
INSERT INTO gri_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mi kalina a Tera e 70 ngalitupana, maia e lia tu tamaqira a Abram, ma Nahor ma Haran. ");
INSERT INTO gri_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Igirani nogo na kukuana a Tera, aia tu tamaqira tugira a Abram, ma Nahor ma Haran. A Haran na tamana a Lot, ");
INSERT INTO gri_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ma Haran e mate tana verana segeni nogo i Ur tana Babilonia kalina e mamauri moa a Tera na tamana. ");
INSERT INTO gri_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma Abram e taugâ ko Sarai, ma Nahor e taugâ ko Milka aia na dalena daki a Haran, aia na tamana goto a Iska. ");
INSERT INTO gri_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Maia ko Sarai e tau tangomana ke tamani sa dalena. ");
INSERT INTO gri_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ma Tera e aditugira a Abram na dalena, maia Lot na tutuana aia na dalena a Haran, maia ko Sarai na tauna a Abram, mi tugira ara tu mololea na verabau ni Ur tana Babilonia na vano tana kao ni Kanaan. Mara tu vano mara tu ba tsau moa i Haran mara tu ba totu i tana. ");
INSERT INTO gri_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ma Tera e mate i tana kalina e 205 ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma na Taovia e tsarivania a Abram, “Ko mololea na veramu, migira na kamamu, ma na valena tamamu, mo ko bâ tana kao i tana inau sauba kau sauvulagia vanigo. ");
INSERT INTO gri_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Inau sauba kau tusuvanigo ke danga na kukuamu, migira sauba kara pabo ma kara lia na puku loki. Me sauba inau kau vangalaka bâ vanigo, ma kau naua me ke gini tangiloki sosongo na soamu, mi tana soamu nogo igoe ti sauba kara gini tsotsovata na tinoni sui tana barangengo popono. ");
INSERT INTO gri_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Inau sauba kau soadougira sui igira ara soadougo igoe, ma kau vealaginigira igira sui ara vealaginigo. Mi tana rongomu nogo igoe ti inau kau vangalaka vanigira na puku sui tana barangengo.” ");
INSERT INTO gri_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mi kalina e 75 ngalitupana a Abram, maia e mololea i Haran vaga nogo na omea na Taovia e tsarivania ke naua; maia Lot goto e vano kolua. ");
INSERT INTO gri_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ma Abram e adia ko Sarai na tauna, ma Lot na dalena kulana, me pipi sui ka niqira omea levolevo ma niqira tseka sui ara ka tamanina i Haran, mara aligiri na vano tana kao ni Kanaan. Mi kalina ara ba laba i Kanaan, ");
INSERT INTO gri_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ma Abram e vano saviliu poi e ba tsau tana gai tabu i More, aia na nauna tabu i Sekem. Mi tana tagu ia igira na Kanaan ara totuvia moa na kao ia. ");
INSERT INTO gri_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ma na Taovia e laba vania a Abram me tsarivania, “Iani nogo na kao inau sauba kau sauvanigira igira na kukuamu.” Ma Abram e tû me logoa kesa na belatabu i tana vania na Taovia aia e laba vania. ");
INSERT INTO gri_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mi murina ia, maia e tada goto me ba tsau tana kao vungavungaga i tabana i longa na verabau ni Betel, mi tana e ba vaturikaea nina valepolo i ka gaqira levuga Betel tabana i tasi mi Ai tabana i longa. Mi tana aia e logogotoa kesa na belatabu me samasama vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mi muri, maia e vano babâ moa kalea i Negeb tana vovotana kao ni Kanaan tabana i ata. ");
INSERT INTO gri_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Me liu kesa na uvirau loki sosongo tana Kanaan, maia Abram e tû me ba tada tsau bâ i Ejipt, gana ke totu tetelo i tana. ");
INSERT INTO gri_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mi kalina aia e vangaraua na savu taligu tana votavota na vano i Ejipt, maia e tsarivania ko Sarai na tauna, “Igoe kesa na daki rerei dou sosongo. ");
INSERT INTO gri_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mi kalina igira na tinoni ni Ejipt kara reigo igoe me sauba kara padâ laka igoe na tauqu, ma kara matesiau inau ma kara mologo igoe ko mauri. ");
INSERT INTO gri_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ma nimu aqo nomoa ko tsarivanigira laka igoe na tasiqu; mi tana rongomu nogo igoe ti igira kara moloau kau mauri ma kara aragodouau.” ");
INSERT INTO gri_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mi kalina ara savu taligu tana votavota ni Ejipt, migira na tinoni ni Ejipt ara reia laka na tauna a Abram e rereidou sosongo. ");
INSERT INTO gri_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mara visana nina mane sasanga na taovia tsapakae ara reia ko Sarai mara ba tsarivania na taovia tsapakae laka e rerei dou sosongo aia; mara adivanoa tana valena na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mi tana rongona nogo ko Sarai, ti na taovia tsapakae e dou sosongo vania a Abram, me tusule vania na alaala na sipi ma na naniqoti, na buluka ma na asi, na tseka ma na kamelo. ");
INSERT INTO gri_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Me rongona na taovia tsapakae e taugâ ko Sarai, te e tû na Taovia me molomaia na lobogu seko ke gadovia na taovia tsapakae migira sui na tinoni i laona na valena. ");
INSERT INTO gri_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ma na taovia tsapakae e mologoko vania a Abram ke mai i konina, maia e veisuâ, “?Laka nagua o nauvaniau igoe? ?Egua ti o tau tsarivaniau inau laka aia ko Sarai na taumu? ");
INSERT INTO gri_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","?Ma na rongona gua ti o tsaria laka aia na tasimu, mo tamivaniau inau kau adia me ke lia na tauqu? !Na taumu ri iani; ko adia mo ko baligi!” ");
INSERT INTO gri_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ma na taovia tsapakae e moloketsa vanigira nina mane, migira ara tû mara railigia a Abram tania na veraqira, kolua na tauna migira sui na omea e tamanina. ");
INSERT INTO gri_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Me vaga ia, ma Abram e mololea i Ejipt kolua na tauna migira sui na omea aia e tamanina, ma Lot goto e dulikolua, mara visutugua tana vovotana kao ni Kanaan tabana i ata. ");
INSERT INTO gri_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ma Abram e tamani danga sosongo nina omea, na sipi, na naniqoti, ma na buluka, kolugira goto na siliva ma na qolumila. ");
INSERT INTO gri_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Maia e mololea i tana me vano kalea i Betel. Me ba tsau tana nauna i tana e vaturikaea nina valepolo tana idana i kagaqira levuga Betel mi Ai, ");
INSERT INTO gri_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tana nauna nogo aia e logoa na belatabu tana idana. Mi tana ma Abram e samasama vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma Lot e tamanigira goto danga nina sipi ma na naniqoti ma na buluka, kolu nina tamadale segeni ma nina maneaqo. ");
INSERT INTO gri_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Me vaga ia, ma na kao i tana e dato dou na buruburu e tau tugu kaira sui kara ka totu sai, rongona ka niqira omea tuavati ara danga sosongo. ");
INSERT INTO gri_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Me kesa dani e labadato kesa na vaikoregi i levugaqira igira ara reitutugugira nina omea tuavati a Abram, migira ara reitutugugira nina omea tuavati a Lot. Mi tana tagu ia igira na Kanaan ma na Peres ara totuvia moa na kao ia. ");
INSERT INTO gri_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ma Abram e tsarivania a Lot, “I kaita na tamakamaga, me tau dou kara vaikoregi nimu tinoni igoe ma niqu tinoni inau. ");
INSERT INTO gri_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Me dou bâ ti kaita ka totu tavota. Igoe ko vilia na butona kao koegua igoe o ngaoa. Migoe ko vano kesa tabana, minau kau vano kesa tabana.” ");
INSERT INTO gri_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ma Lot e tû, me moro polipoli me reia laka na poi popono ni Jordan me tsau bâ i Soar, e totu danga na kô i laona, vaga tana Nina Uta na Taovia se vaga tana kao ni Ejipt. Ma na tagu ia kalina na Taovia e tau vati moa toroutsanikaira na verabau ni Sodom mi Gomora. ");
INSERT INTO gri_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mi tana, ma Lot e vilia na poi popono ni Jordan vanisegenina, maia e longa kalea na poi ia. Aia nogo e vaga kalina kaira ara ka tavota kaira. ");
INSERT INTO gri_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ma Abram e totu i laona na kao ni Kanaan, ma Lot e ba totu i laoqira na verabau ara totu tana poi varangisia i Sodom, ");
INSERT INTO gri_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","migira na tinonina ni Sodom na tinoni vanga tsutsukibo mara sasi sosongo i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mi murina kalina e vano nogo a Lot, ma na Taovia e tsarivania a Abram, “Ko tû tana o totu kalina ia, mo ko moro tave, mo ko moro tada, mo ko moro votu mo ko moro longa; ");
INSERT INTO gri_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","rongona na kao sui igoe o morosigira, inau sauba kau sauvanigo igoe migira na kukuamu, me sauba igamu kamu tamanigira sailagi. ");
INSERT INTO gri_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Inau sauba kau sauvanigo ke danga sosongo na kukuamu, me sauba ke tau tangomana ke kesa na tsokoraeaqira; me ti vaga ke kesa ke dona na tsokoana na papasa tana barangengo, maia sauba goto ke tangomana na tsokoaqira na kukuamu igoe. ");
INSERT INTO gri_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bâ, mi kalina ia, igoe ko tû mo ko ba liuvi poponoa na kao ia, rongona inau sauba kau sauvanigo popono.” ");
INSERT INTO gri_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ma Abram e tû me mololea i tana me ba vaturikaea nina valepolo varangisigira na gaitabu e tamanina a Mamre tana Hebron, mi tana maia e logogotoa kesa na belatabu vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ara tu vati na taovia tsapakae, tugira a Amrapel ni Babilonia, ma Ariok ni Elasar, ma Kedorlaomer ni Elam, ma Tidal ni Goim, ");
INSERT INTO gri_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ara tu vano na vailabu koluaqira tsege na taovia tsapakae tavosi: tugira nogo a Bera ni Sodom, ma Birsa ni Gomora, ma Sinab ni Adma, ma Semeber ni Seboim, ma na taovia tsapakae ni Bela (se i Soar). ");
INSERT INTO gri_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tugira tsege na taovia tsapakae tugirani ara tu vorogokona mara tu saia niqira alaala tana Poi ni Sidim, i tana e totu na Tasi Mate kalina ia. ");
INSERT INTO gri_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tugira sui ara tu totu moa i vavana nina tagao a Kedorlaomer i laona e sangavulu ruka na ngalitupa, mi tana sangavulu tolunina ngalitupa mi tugira ara tu sovetugua tania nina tagao aia. ");
INSERT INTO gri_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mi tana sangavulu vatinina ngalitupa, ma Kedorlaomer kolugira igira ara sanga tabana kolua ara mai kolua niqira alaala na mane vaumate mara tuliusigira na Repaim i Asterot Karnaim, migira na Susim i Ham, migira na Emim tana poiatsa ni Kiriataim, ");
INSERT INTO gri_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","migira goto na Hor tana vungavunga ni Edom, mara takuvigira tsau bâ i Elparan tana vovotana na kaomate. ");
INSERT INTO gri_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Mi muri, migira ara pilo visutugua mara visu bâ i Kades mi tana tagu ia ara soaginia i Enmispat. Mara ba laugira sui niqira kao igira na Amalek mara tuliusigira na Amor ara totu i Hasason Tamar. ");
INSERT INTO gri_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mi muri, mi tugira na taovia tsapakae ni Sodom, mi Gomora, mi Adma, mi Seboim, mi Bela ara raqagira niqira alaala na mane vaumate mara bâ tana Poi ni Sidim mara vailabugi ");
INSERT INTO gri_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kolutugira na taovia tsapakae ni Elam, mi Goim, mi Babilonia, mi Elasar, ara tsege na taovia tsapakae tabana, mara vati tabana. ");
INSERT INTO gri_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mi laona na poi ia ara totu danga na qilu na kolta i laona, mi kalina kaira na taovia tsapakae ni Sodom mi Gomora ara ka tovoa na tsogoligi tania na vailabu, mara ka ba pukasage i laona na qilu gira; me tugira tolu na taovia tsapakae tavosi ara tu tsogovano tana vungavunga. ");
INSERT INTO gri_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mi tugira vati na taovia tsapakae ni Babilonia, mi Elasar, mi Elam mi Goim, ara tu laugira pipi sui na omea ara totu i laona na Sodom ma na Gomora, kolugotoa na mutsa mara vano. ");
INSERT INTO gri_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma Lot, aia na dalena na kulana a Abram, e totu goto i Sodom, migira ara tangoligotoa mara laugira nina omea sui lakalaka. ");
INSERT INTO gri_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Me kesa na mane e tsogo me mai turupatuna pipi sui na omea girani vania a Abram na Hibru, aia e tototu varangisigira na gaitabu e tamanina a Mamre na Amor. Ma Mamre mi kaira a Eskol ma Aner na kulana ara tu sanga tabana konina a Abram. ");
INSERT INTO gri_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mi kalina a Abram e rongomia laka ara tangolia a Lot na dalena kulana, maia e tû me soasaigira igira sui na tinoni na vailabu ara totu i konina i tana, mara saisai mara 318 mane, mara takuvitugira vati na taovia tsapakae poi ara ba tsau i Dan. ");
INSERT INTO gri_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mi tana maia e votagira nina alaala, migira ara baginigira gaqira gala tana bongi mara tuliusigira. Maia e takuvigira tsau bâ i Hoba aia e totu pala tave vania i Damaskus, ");
INSERT INTO gri_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","me adivisugira sui pipi na omea ara laua. Me adivisugotoa a Lot aia na dalena kulana, me pipi sui nina omea levolevo kolugira goto na daki sui migira na tinoni tavosi sui ara tangoligira. ");
INSERT INTO gri_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mi kalina a Abram e tuliusigira sui nogo a Kedorlaomer migira na taovia tsapakae tavosi me vivisumai, maia na taovia tsapakae ni Sodom e ba tsodoa tana Qou ni Save aia ara soaginigotoa Nina Qou na Taovia Tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma Melkisedek, aia na taovia tsapakae ni Salem, maia nina manetabu goto God Loki Tsapakae, e adi bâ vania a Abram na bredi ma na uaeni, ");
INSERT INTO gri_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","me tabua a Abram me tsarivaganana, “!Aia na God Loki Tsapakae aia nogo e volâ na baragata ma na barangengo, ke tabugo igoe Abram! ");
INSERT INTO gri_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","!Tsonikaea na God Loki Tsapakae, rongona aia nogo e sangago igoe te o gini tangomana na tuliusiaqira gamu gala!” Mi tana, ma Abram e tû, me tusuvania a Melkisedek na sangavulunina turina na omea sui aia e laua tana vailabu. ");
INSERT INTO gri_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Maia na taovia tsapakae ni Sodom e tsarivania a Abram, “Igoe ko aditamanimu pipi na omea sui, mo ko sauvisu vaniau moa igira sui niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abram e tuguvisua me tsaria, “Inau au vatsa i matana na Taovia na God Loki Tsapakae, aia e aqosia na baragata ma na barangengo, ");
INSERT INTO gri_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","laka inau sauba e utu saikesa kau tangolivisua ke kesa goto nimu omea tatamani igoe, atsa moa ti na itaina tula polo, se kesa na itai gana na sori porotua, rongona ko tau tsaria igoe i muri, ‘A Abram e gini tamani omea danga rongona inau nogoria au sau omea vania.’ ");
INSERT INTO gri_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Me sauba e utu goto kau aditamaniqu segeni ke kesa na omea. Kau adia moa gaqira tuva igira niqu tinoni ara duli koluau. Mo ko tami moa vanitugira a Aner, ma Eskol ma Mamre, tugira ara tu sanga tabana koluau, kara tu adia tu gaqira tuva.” ");
INSERT INTO gri_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kesa tana tagu i muri, ma na Taovia e goko vania a Abram tana moro me tsarivania, “A Abram ko laka na matagu. Inau sauba kau dilago tanigira sui na omea seko, ma na pelumu sauba ke loki sosongo.” ");
INSERT INTO gri_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Abram e veisuâ na Taovia, “?Taovia God, na peluna dou koegua sauba igoe ko sauvaniau inau kalina au tau vati tamanina moa sa dalequ vaga ia? Maia lelê moa a Elieser ni Damaskus sauba ke tangolidatogira sui niqu omea inau. ");
INSERT INTO gri_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Igoe o tau sauvaniau sa dalequ, me sauba moa ke kesa vidaqira niqu tseka ke tangolidatogira niqu omea tatamani.” ");
INSERT INTO gri_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mi muri, maia e rongomia na Taovia e gokovanitugua me tsaria: “Iani a Elieser na tseka sauba e utu ke tangolidatoa nimu omea tatamani; na dalemu segeni nogo igoe sauba ke tugugo.” ");
INSERT INTO gri_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ma na Taovia e soa rutsumia a Abram i tano me tsarivania, “Ko morodato i gotu tana masaoka mo ko tovoa na tsokoaqira na veitugu sui o reigira i tana; migoe na kukuamu sauba kara danga vaga nogo na veitugu o reigira i gotu.” ");
INSERT INTO gri_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ma Abram e tutunina na Taovia, mi tana rongona nogo nina tutuni aia ti na Taovia e reingaoa a Abram me tabedoua. ");
INSERT INTO gri_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mi muri, ma na Taovia e tsarivania, “Inau nogo na Taovia au adiligigo tania na veramu i Ur tana Babilonia, rongona kau tusuvanigo na kao iani me ke lia na tamanimu.” ");
INSERT INTO gri_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Abram e veisuâ, “?Taovia God, ke koegua ti kau donaginia laka sauba ke lia na tamaniqu na kao iani?” ");
INSERT INTO gri_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ma na Taovia e gokovisu me tsaria, “Ko adimai vaniau ieni ke kesa na buluka, me ke kesa na naniqoti, me ke kesa na sipi mane, me ke tolu sui moa tu ngalitupaqira, me ke kesa na kulukulu me ke kesa na kurau.” ");
INSERT INTO gri_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ma Abram e adisaigira na omea sui e nongia na Taovia, me putsikutigira ruka takutina, me molo palatetegira pipi na omea kesa turina kesa tabana, me kesa turina kesa tabana; me tau moa putsikutigira na manu. ");
INSERT INTO gri_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Migira na manusata ara tsunamai laka kara gania na lakaqira, ma Abram e tsialigigira. ");
INSERT INTO gri_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mi kalina e raratasi na aso, ma Abram e tsaro me maturu mate, me tavongani ngolia na matagu loki. ");
INSERT INTO gri_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ma na Taovia e tsarivania, “Igira na kukuamu sauba kara tinoni labavô kesa tana vera tavosi, me sauba kara lia niqira tseka na tinoni ni tana, me sauba kara rotasi sekoligira i laona ke vati sangatu na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Minau sauba kau kedegira igira ara malatsekagira, mi kalina igira na kukuamu kara mololea na vera tavosi ia, migira sauba kara adia ke danga sosongo na omea levolevo kolugira. ");
INSERT INTO gri_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Migoe segenimu sauba ko mauri babâ moa poi tsau kalina ko tuqatuqa sosongo, me sauba ko mate tana rago, ma kara qiludougo. ");
INSERT INTO gri_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Me sauba ke tsaulia ke vati na vatavata i muri ti igira na kukuamu igoe kara visumaitugua ieni, rongona e utu inau kau tsialigigira na Amor poi kalina ke tabaru saikesa niqira sasaga igira me ke kilia kau kedegira.” ");
INSERT INTO gri_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mi kalina e su pitsu nogo na aso me rodo, me tavongani pungudato na lake vaga tana umu, me kesa na omea vaga na sulu iruiru e liu i levugaqira na paparina na omea tuavati gira. ");
INSERT INTO gri_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mi tana tagu tsotsodo nogo ia ma na Taovia e naua kesa na vaitasogi kolua a Abram. Me tsarivania, “Inau au vekevanigo kau tusuvanigira na kukuamu na kao popono iani, ke tû tana vovosana na kao ni Ejipt me ke vosa bâ tana Kô Euprates, ");
INSERT INTO gri_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","me adisaikolugotoa niqira kao igira na Ken, na Kenas, na Kadmon, ");
INSERT INTO gri_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Het, na Peres, na Repaim, ");
INSERT INTO gri_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Amor, na Kanaan, na Gergas ma na Jebus.” ");
INSERT INTO gri_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Aia ko Sarai na tauna a Abram e tau goto vasuvania a Abram sa baka. Maia ko Sarai e tamanina kesa nina baka daki tseka ni Ejipt, ko Hagar na soana. ");
INSERT INTO gri_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Me kesa dani ko Sarai e tsarivania a Abram, “Na Taovia e tongovaniau nogo inau kau tamani dalequ. Me ti ke dou vanigo igoe, mo ko maturu kolua niqu tseka. E tau utu aia ke tangomana ke vasuvaniau sa baka.” Ma Abram e tabea na omea ko Sarai e tsarivania. ");
INSERT INTO gri_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Maia ko Sarai e tusuvania a Abram ko Hagar ke lia na tauna lê. Na omea vaga iani e laba i murina e sangavulu nogo na ngalitupa a Abram e totu i Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ma Abram e maturu kolua ko Hagar, maia e tiana. Mi kalina ko Hagar e dona laka e tiana, maia e gini kaekae me reipeâ ko Sarai. ");
INSERT INTO gri_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ma ko Sarai e tsarivania a Abram, “Aia nimu sasi nogo igoe ti ko Hagar e gini reipeaau. Inau segeniqu nogo au sauvanigo igoe ko Hagar, me tuturiga kalina aia e dona laka e tiana, maia e reipea sosongoliau inau. !Ma na Taovia ke pedea asei ka vidada kaita e sasi, igoe se inau!” ");
INSERT INTO gri_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma Abram e tsarivania, “E dou moa, maia ko Hagar nimu tseka nogo igoe me totu i vavana nimu tagao; ko nauvania moa na omea igoe o ngaoa na nauvaniana.” Mi tana ma ko Sarai e rotasi sosongolia ko Hagar te e gini tsogo. ");
INSERT INTO gri_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma nina angelo na Taovia e tsodoa ko Hagar kesa tana vuravura i laona na kaomate, tana sautu e vavano i Sur, ");
INSERT INTO gri_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","me tsarivania, “?Ko Hagar nina tseka ko Sarai, iava o talumai igoe miava o vavano?” Maia e tsarivania, “Inau au tsogo tania gaqu taovia.” ");
INSERT INTO gri_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma na angelo e tsarivania, “Ko visutugua i konina mo ko aqo vania moa.” ");
INSERT INTO gri_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Maia e tsarivanigotoa, “Inau sauba kau vanigo ke danga sosongo na kukuamu, me sauba ke tau tangomana ke kesa na tsokoraeaqira. ");
INSERT INTO gri_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Igoe sauba ko vasua kesa na dalemu mane, me sauba ko soaginia a Ismael, rongona na Taovia e rongominogoa nimu ngangai i laona nimu rota. ");
INSERT INTO gri_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ma na dalemu igoe sauba ke mauri vaga kesa na asi atsi; maia sauba ke reisavigira pipi tinoni, me pipi tinoni sauba kara reisavia aia. Maia sauba ke totu tabaligi tanigira sui na kamana.” ");
INSERT INTO gri_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Maia ko Hagar e veisua segenina vaga iani, “?Laka au rei mananâ na Taovia mau totu mamauri moa?” Me vaga ia, maia e soaginia na Taovia aia e goko vania “Na God Aia e Momoro.” ");
INSERT INTO gri_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Maia nogoria na rongona ti na tinoni ara soaginia na tuvu e totu ka gaqira levuga i Kades mi Bered, “Nina Tuvu Aia e Mamauri Me Morosiau Inau.” ");
INSERT INTO gri_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ma ko Hagar e vasuvania a Abram kesa na dalena mane, maia e soaginia a Ismael. ");
INSERT INTO gri_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Mi tana tagu ia e alu sangavulu ono nogo na ngalitupana a Abram. ");
INSERT INTO gri_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mi kalina e 99 ngalitupana a Abram, ma na Taovia e laba vania me tsaria, “Inau na God Susuliga Sosongo. Ko rongomangaqu, mo ko nau sailaginia moa na omea e goto me dou. ");
INSERT INTO gri_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Minau sauba kau aqosia kesa niqu taso kolugo igoe ma kau sauvanigo ke danga na kukuamu.” ");
INSERT INTO gri_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ma Abram e tsuporu tsuna ma na lovana e pelea na kao, ma God e tsarivania, “Inau au aqosia na vaitasogi iani kolugo: ");
INSERT INTO gri_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Inau au vekevanigo laka igoe sauba ko lia na mumuaqira na puku danga. ");
INSERT INTO gri_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mi kalina ia e utu nogo kara soaginigo a Abram, sauba kara soaginigo a Abraham, rongona inau au mologo igoe ko lia na mumuaqira na puku danga. ");
INSERT INTO gri_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Inau sauba kau sauvanigo ke danga na kukuamu ma kara lia na puku loki, me visana vidaqira sauba kara lia na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Inau sauba kau manalia niqu veke au nauvanigo igoe, me vanigira goto na kukuamu kara botsamai i muri vaga na taso saliu. Inau sauba kau lia nimu God igoe, ma niqira God goto igira na kukuamu. ");
INSERT INTO gri_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Inau sauba kau tusuvanigo igoe me vanigira na kukuamu na kao iani i tana igoe o totu mala tinonina na vera tavosi kalina ia. Na kao popono tana Kanaan sauba igira na kukuamu kara tamanina sailagi, minau sauba kau lia niqira God.” ");
INSERT INTO gri_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma God e tsarigotoa vania a Abraham, “Ma nimu aqo goto igoe ko tami na manaliana nimu tabana na vaitasogi iani o naua koluau, igoe migira sui goto na kukuamu kara botsa mai i muri. ");
INSERT INTO gri_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Igoe migira goto na kukuamu, nimui aqo kamu tami sui na paripapadaqira pipi sui na mane ara totu i laomui. ");
INSERT INTO gri_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Me tuturiga kalina ia me ke bâ, ma nimui aqo igamu kamu paripapadaqira pipi sui na baka mane kalina e alu moa na bongiqira, kolugira goto igira na tseka ara botsa tana valemui, migira goto na tseka amu voligira tana vera tavosi. Iani nogo sauba ke sauvulagia laka e kesa na vaitasogi i levugada igita. ");
INSERT INTO gri_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Pipi mane nina aqo ke paripapadana, miani nogo na padapada tana konina tinoni sauba ke sauvulagia laka niqu vaitasogi kolugamu e totu saviliu. ");
INSERT INTO gri_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ti vaga kesa na maneluma e tau paripapadana, maia e utu nogo kau tsokosaia kolugira niqu tinoni, rongona aia e kutsia niqu taso.” ");
INSERT INTO gri_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma God e tsarivania a Abraham, “Mi kalina ia igoe nimu aqo ko tau nogo soaginia na taumu ko Sarai; me tû i dani eni me ke bâ, ko soagininogoa ko Sara. ");
INSERT INTO gri_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Inau sauba kau vangalaka vania, maia ke vasuvanigo kesa na dalemu mane. Minau sauba kau vangalaka vania ko Sara, maia sauba ke lia na tinaqira na puku danga, me sauba goto visana i laoqira na kukuana kara lia na taovia tsapakae.” ");
INSERT INTO gri_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ma Abraham e tsuporu tsuna ma na lovana e pelea na kao, maia e tuturiga na kia kalina e padâ, “?Laka tangomana kesa mane ke tamani dalena kalina aia e kesa sangatu nogo na ngalitupana? ?Se laka ko Sara tangomana ke tamani baka kalina aia e siu sangavulu nogo na ngalitupana?” ");
INSERT INTO gri_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Maia e veisuâ God, “?Egua ti ko tau molovania moa a Ismael ke lia na tuguqu?” ");
INSERT INTO gri_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma God e tsaria, “Tagara. Aia nogo ko Sara na taumu sauba ke vasuvanigo kesa na dalemu mane, migoe sauba ko soaginia a Isaak. Inau sauba kau vaturi kakaia niqu taso kolua aia me kolugira goto na kukuana na dani ma na dani. Ma na taso iani sauba ke totu saviliu. ");
INSERT INTO gri_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Inau au rongominogoa nimu nono tana rongona a Ismael, me sauba kau vangalaka vanigotoa aia, ma kau sauvania ke danga na dalena me ke danga na kukuana. Maia sauba ke lia na tamaqira sangavulu ruka na tinoni tataovia, ma kau naua migira na kukuana kara lia na puku loki. ");
INSERT INTO gri_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Minau sauba kau manalia niqu taso kolua a Isaak na dalemu, aia sauba ke botsa konina ko Sara tana tagu vaga nogo iani tana ngalitupa vaolu.” ");
INSERT INTO gri_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mi kalina God e goko sui vania a Abraham, maia e vano. ");
INSERT INTO gri_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mi tana dani nogo ia, ma Abraham e taonia na omea God e ketsalia, maia e paripapadana a Ismael na dalena, migira sui goto na maneluma i laona valena, kolugira goto na tseka ara botsa tana valena migira goto aia e voligira. ");
INSERT INTO gri_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","A Abraham e siu sangavulu siu nogo na ngalitupana kalina aia e paripapadana, ");
INSERT INTO gri_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","maia Ismael na dalena e sangavulu tolu na ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Mi tana dani nogo ia, mi kaira sui ara ka paripapada, ");
INSERT INTO gri_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kolugira sui goto nina tseka a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Me kesa tana tagu i muri, ma na Taovia e labavania a Abraham tana nina gaitabu a Mamre. Mi tana dani ia e papara sosongo na aso tana niaso, ma Abraham e totu bisibisi i matsapana nina valepolo. ");
INSERT INTO gri_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Me morodato me reitugira ara tu tolu na mane ara tu tû i tana. Mi kalina a Abraham e reibatugira, maia e tû tsaku me ba tsodotugira. E tsuporu tsuna ma na lovana e pelea na kao me tsaria, ");
INSERT INTO gri_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Taovia tugamu, au nongitugamu kamu tu laka mavi na liu saviliu tania na veraqu; inau tu nimui maneaqo. ");
INSERT INTO gri_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Minau sauba kau adivanitugamu na kô ma kamu tu vuliginia tu tuamui, ma kamu tu mango rago talu tana auauna na gai iani. ");
INSERT INTO gri_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Sauba kau adivanitugamu goto na mutsa tetelo; me ke gini kakaisitugamu na vano babâ moa i sautu. Tugamu amu tu padaloki sosongoliau te amu tu gini mailaba i valequ, me vaga ia me dou ti kamu tu tamivaniau moa kau palatugamu.” Mi tugira ara tu tsaria, “E dou. Ami tu tamivanigo.” ");
INSERT INTO gri_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Me tû a Abraham, me visu tsaku i valena me tsarivania ko Sara, “Tsaku, ko adia na pulaoa dou bâ mo ko bititsakua ke visana na bredi.” ");
INSERT INTO gri_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mi muri, ma Abraham e ulovano tana ara totu nina buluka, me tangolia kesa na dalena buluka paquru dou me tusuvania kesa nina maneaqo, maia e vangarautsakua gana na mutsa. ");
INSERT INTO gri_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Me adigotoa na miliki me visana na krim kolua na velesina na buluka, me ba sauvanitugira. Mi tana i vavana na gai, aia segenina nogo e palatugira, mi tugira ara tu mutsa. ");
INSERT INTO gri_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Mi muri, mara tu veisuâ a Abraham, “?Ma ko Sara na taumu iava?” Maia e tsarivanitugira, “Ko Sara ri i tana i vale.” ");
INSERT INTO gri_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Me kesa tu vidaqira na mane e tsaria, “Ke tovu ke siu na vula tû i dani eni, minau sauba kau labavisumai tugua ieni, maia ko Sara ke vasuvanigo nogo kesa na dalemu mane.” Maia ko Sara e tototu tana matsapana na valepolo i murina a Abraham me rorongo. ");
INSERT INTO gri_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ma Abraham e tuqatuqa sosongo nogo, ma ko Sara goto e kavekave sosongo me tau nogo reivula. ");
INSERT INTO gri_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mi kalina ko Sara e rorongo vaga ia, maia e kia segenina me tsaria, “?Mi kalina ia inau au kavekave seko nogo, me laka sauba kau gini magemage moa inau na maturu kolu mane? Ma na savaqu goto inau e tuqatuqa sosongo nogo.” ");
INSERT INTO gri_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ma na Taovia e veisuâ a Abraham, “?Rongona gua te e gini kia ko Sara me tsaria ‘?Laka tangomana nomoa kau tamani baka kalina au kavekave sosongo vaga ia?’ ");
INSERT INTO gri_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","?Me laka ke kakai vanigotoa sa omea na Taovia? Me vaga nogo au tsaria, ke tovu siu na vula tû i dani eni, minau sauba kau labavisumai tugua ieni, maia ko Sara ke vasunogoa kesa na dalena mane.” ");
INSERT INTO gri_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ma na rongona ko Sara e matagu maia e tiapoia me tsaria, “Au tau kia inau.” Ma na Taovia e tsaria, “Eo, igoe o kia manana.” ");
INSERT INTO gri_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mi muri, mi tugira na mane ara tu vano kalea kesa tana nauna i tana tangomana kara tu morotsuna bâ i Sodom, ma Abraham e vano kolutugira gana ke vailivutugira. ");
INSERT INTO gri_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma na Taovia e tsarisegenina, “E utu goto kau molopoia vania a Abraham na omea inau sauba kau naua. ");
INSERT INTO gri_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Migira na kukuana sauba ke tangiloki gaqira rongo ma kara puku susuliga, me pipi na puku tana barangengo sauba kara nongiau inau kau tabugira igira vaga nogo au tabua aia. ");
INSERT INTO gri_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Inau au vilinogoa aia rongona ke gini raigira na dalena ma na kukuana kara rongomangaqu inau ma kara taonia na omea e dou me goto. Ma ti kara naudoua, me sauba kau manalivania aia pipi sui na omea inau au vekenogoa.” ");
INSERT INTO gri_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mi muri, me goko na Taovia me tsarivania a Abraham, “Inau au rongominogoa na vaitsari loki sosongo tana rongoqira na tinoni ni Sodom mi Gomora, me laka ara tsukia na sasi loki sosongo. ");
INSERT INTO gri_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Te inau niqu aqo nomoa kau tsuna bâ ma kau lavevulagi segeniqu ti vaga ke mana se tagara na omea ara katea tana rongoqira igira.” ");
INSERT INTO gri_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mi tana mi kaira ruka tu vidaqira ara ka aligiri na vano, mara ka ba kalea na vera ni Sodom, ma na Taovia aia segenina moa e totuvisu kolua a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ma Abraham e tû i matana na Taovia me veisuâ, “?Egua, laka igoe o ngao mamanâ na matesiaqira igira na tinoni e dou niqira sasaga saikolugira igira na vanga tsutsukibo? ");
INSERT INTO gri_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","?Me ti vaga kara totu ke tsege sangavulu na tinoni dou i laona na vera ia, megua sauba igoe ko ketsoa moa na vera popono ia? ?Se laka ko tau gaea rongona kara tau mate lê igira ara tsege sangavulu na tinoni dou? ");
INSERT INTO gri_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","E manana nomoa e utu igoe ko tamia na matesiaqira lê na tinoni dou kolugira na vanga tsutsukibo. !Taovia, e utu! !E utu saikesa ko nauvaganana ia! Me ti vaga ko naua moa, migira na douna sauba kara gadovikede lê saikolugira igira na vanga tsutsukibo. Ma na omea vaga ia e utugana saikesa vanigo na tamiana. ?Me laka e tau nina aqo aia e pedea na barangengo popono ke gini pede moa na pedegoto?” ");
INSERT INTO gri_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Me gokovisu na Taovia me tsarivania a Abraham, “Eo, me ti vaga kau tsodoa kara tsege sangavulu na tinoni ke dou niqira sasaga i laona na vera ni Sodom, me sauba manana kau gaea na vera popono ia na mateqira nogo igira.” ");
INSERT INTO gri_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma Abraham e goko vanitugua na Taovia me tsaria, “Kiki igoe Taovia, au nongigo ko padalea niqu bulesiamu ma na veisuamu babâ moa. Inau na tinoni lê me tau lelê tuguau na tsariana sa omea vanigo. ");
INSERT INTO gri_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","?Me ti vaga kara totu ke vati sangavulu tsege lelê moa na tinoni e dou niqira sasaga tana vera ia, megua, laka igoe sauba ko ketsoa moa na vera popono ia tana rongona ara tu tsege moa ara tu nanga i laona na tsege sangavulu?” Ma na Taovia e tsarivania, “Sauba kau tau ketsoa na verabau ia ti vaga kau tsodoa i tana kara vati sangavulu tsege na tinoni e dou niqira sasaga.” ");
INSERT INTO gri_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ma Abraham e goko tugua me tsaria, “Me ngatsu kara vati sangavulu lelê moa kara totu.” Ma na Taovia e tsaria, “Sauba inau kau tau goto ketsoa na verabau ia ti vaga kara totu i tana kara vati sangavulu na tinoni dou.” ");
INSERT INTO gri_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma Abraham e nongigotoa na Taovia me tsaria, “Taovia, ko laka moa kiki na kore vaniaqu, minau kau goko vanigo tugua. ?Me ti vaga kara tolu sangavulu lelê moa kara totu me kegua?” Ma na Taovia e tsaria, “Sauba kau tau goto nauvaganana ia ti vaga kau tsodogira kara tolu sangavulu moa.” ");
INSERT INTO gri_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ma Abraham e tsaria, “Kiki, Taovia, ko padalea niqu bulesiamu babâ moa. ?Me kegua ti vaga ko tsodoa i tana kara rukapatu lelê moa?” Ma na Taovia e tsaria, “Sauba e utu goto kau ketsoa na verabau ia ti vaga kau tsodoa kara rukapatu lelê moa.” ");
INSERT INTO gri_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ma Abraham e tsaria, “Taovia, ko laka moa kiki na kore vaniaqu, minau kau goko vanigo ke kesa lelê goto moa kalina. ?Me kegua ti vaga ko tsodogira kara tu sangavulu lelê moa na douna kara tu totu i tana?” Ma na Taovia e tsaria, “Sauba e utu goto kau ketsoa na vera ia ti vaga kau tsodogira kara tu sangavulu moa na tinoni dou kara tu totu i laona.” ");
INSERT INTO gri_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mi kalina na Taovia e sui na goko koluana a Abraham, maia e vano, ma Abraham e visutugua i valena. ");
INSERT INTO gri_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mi tana ngulavi ia, kalina kaira na angelo ara ka mailaba i Sodom, maia Lot e tototu tana matsapakapuna na verabau ia. Mi kalina tsotsodo aia e reikaira, maia e tû me ba tsodokaira. Me tsuporu i ka mataqira ");
INSERT INTO gri_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","me tsaria, “Taovia kagamu, inau ieni gana kau sangakagamu. Au nongikagamu kamu mai i valequ. Ma kamu ka vulia ka tuamui ma kamu ka maturu ieni ke bongi. Me ke matsaraka ti kamu ka mamata bongibongi ma kamu ka vano tana amu ka sulungana.” Mi kaira ara ka tsarivania a Lot, “Tagara, i kagami sauba kami ka maturu moa ieni tana pakokana na verabau ieni.” ");
INSERT INTO gri_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Maia e raikaira sosongo, mi muri mi kaira ara ka tami mara ka vano kolua i valena. Maia Lot e ba ketsaligira nina maneaqo kara buloa visana na bredi, ma kara vangaraua na mutsa dou vanikaira i kaira ara ka mai i valena. Mi kalina e magovo na mutsa, migira ara adimai vanikaira, mara ka mutsa kagaqira. ");
INSERT INTO gri_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mara ka tau vati vano maturu na mane kaira, migira na mane ni Sodom ara mai mara tupolia na vale. Igira sui lakalaka na manena na verabau ia, igira na tinoni vaolu ma na tuqatuqa ara maisai sui i tana. ");
INSERT INTO gri_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Migira ara gû vania a Lot mara veisuâ, “?Iava kaira na mane ara ka mai maturu ri i konimu igoe? !Ko aditsunamaikaira ieni i konimami igami rongona ami ngaoa na tangopeke kaqira.” ");
INSERT INTO gri_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ma Lot e rutsu bâ i koniqira me vongovisua na bani. ");
INSERT INTO gri_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Me tsarivanigira, “!Kulaqu igamu, au nongigamu kamu laka na nauana sa omea seko loki vaga ia! ");
INSERT INTO gri_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kamu reia, inau au tamani kaira ruka na dalequ daki mi kaira ara ka siama moa. Kamu tamivaniau kau adirutsumikaira vanigamu, migamu kamu nauvanikaira moa na omea amu padangaoa na nauana. Ma kamu laka moa na nauana ke kesa na omea seko vanikaira na mane kaira; i kaira ara ka mai i valequ inau, ma niqu aqo nomoa kau reitutugukaira.” ");
INSERT INTO gri_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma na mane gira ara tsarivania, “!Ko tuligi igoe na maina! ?Laka asei vaga nomoa igoe ti ko pedevanigami igami na omea kami naua? Ko tuligi, ti tagara, me sauba ke seko liuliu bâ na omea kami nauvanigo igoe tanikaira kaira.” Migira ara surukeliligia a Lot, mara tudato bâ laka kara resea na bani. ");
INSERT INTO gri_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mi kaira na mane ara totu moa i laona na vale, mara ka sangavia na bani, mara ka tangolia a Lot mara ka raqasagea i vale, mara ka vongotugua na bani. ");
INSERT INTO gri_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mi muri mi kaira ara ka naua mara gini koko sui lakalaka igira na mane ara tutû i tano, rongona ke gini utugana vanigira na reiana na matsapa. ");
INSERT INTO gri_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mi kaira na mane ara ka tsarivania a Lot, “?Laka ara totu goto visana nimu tinoni tana verabau iani? Na dalemu mane, se na dalemu daki, se na savana na dalemu, se ke kesa na kamamu goto, ko adirutsumiligigira tsaku tania na verabau iani, ");
INSERT INTO gri_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","rongona i kagami sauba kami ka toroutsani saikesalia. Na Taovia e rongominogoa na vaitsari loki sosongo tana rongoqira na tinoni girani, maia e molomaikagami kami ka toroutsania na Sodom.” ");
INSERT INTO gri_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mi tana, ma Lot e vano ka koniqira kaira na mane sauba kara ka taugâ na dalena me tsarivanikaira, “Tsaku ma kamu ka vanoligi tania ieni; rongona na Taovia sauba ke toroutsania na verabau iani.” Mi kaira ara ka padâ laka aia e goko sinagi moa. ");
INSERT INTO gri_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mi tana matsaraka rovorovo mi kaira na angelo ara ka raia a Lot ke tsaku, mara ka tsaria, “!Tsaku! Ko adia na taumu mi kaira na dalemu daki kaira ma kamu tu vanoligi, rongona kamu tu tau mate kalina ke toroutsa na verabau iani.” ");
INSERT INTO gri_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ma Lot e padaruka na vano. Maia na Taovia e galuvea moa; te kaira na mane ara ka tangolia tu limaqira tugira a Lot, ma na tauna mi kaira ruka na dalena daki, mara ka tudumiligigira tania na verabau. ");
INSERT INTO gri_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Me kesa ka vidaqira na angelo kaira e tsaria, “!Kalina ia, ma kamu tu ulo tsaku! Kamu tu laka goto na morovisu ma na mango i laona na qou. Kamu tu ulo bâ tana tetena garia, rongona ke tau ganitugamu na lake ma kamu tu mate.” ");
INSERT INTO gri_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot e tsarivania, “Taovia, ko laka kiki na raiaotugami sosongo vaga ia. ");
INSERT INTO gri_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Igoe o galuve sosongoliau te o maurisiau nogo. Ma na tetena gira ara totu ao sosongo; minau sauba kau mate nogo ti kau ba tsau i tana. ");
INSERT INTO gri_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","?Laka o reia na vera tetelo tagaria? I tana e varangi dodo. Ko tamivaniau moa ma kau ba totu i tana, igoe o reia laka aia e kesa na vera tetelo lê moa, mi tana sauba nomoa kau toturavi.” ");
INSERT INTO gri_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ma na angelo e gokovisu me tsaria, “E dou, inau au tabea. Sauba e utu kau toroutsania na vera ia. ");
INSERT INTO gri_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","!Tsaku! !Kamu tu ulo! E utu mavi kau naua sa omea poi kalina kamu tu ba tsau i tana.” Me rongona a Lot e tsaria laka e tetelo moa na vera ia, te na vera ia ara soaginia i Soar. ");
INSERT INTO gri_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ma na aso e tuturiga moa na datomai kalina a Lot e ba laba i Soar. ");
INSERT INTO gri_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mi tana tagu tsotsodo nogo ia, na Taovia e molotsunamaia na lake iruiru ke iruvikaira na verabau ni Sodom mi Gomora, ");
INSERT INTO gri_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","me gani poponokaira kolugotoa na poi popono, migira na tinoni sui i tana, me pipi sui lakalaka goto na omea ara dato tana kao ia. ");
INSERT INTO gri_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma na tauna a Lot e morovisu, maia e lia na tuturina na qavu. ");
INSERT INTO gri_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mi tana matsaraka rovorovo tana dani ngana, ma Abraham e ba tsaku tana nauna i tana aia e totu i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Me morotsuna bâ i Sodom mi Gomora mi tana poi popono, me morosia e pungudato na lake tana kao popono, vaga moa na pungu e talu kesa tana biti loki. ");
INSERT INTO gri_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mi kalina God e toroutsanikaira na verabau i tana e totu a Lot, maia e padâ moa a Abraham te e tamivania a Lot ke vanoligi tania na vera ia me ke mauri. ");
INSERT INTO gri_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Me rongona a Lot e matagu na totu i Soar, te aia mi kaira na dalena daki ara tu dato tana tetena mara tu ba totu i laona kesa na vatuluma. ");
INSERT INTO gri_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Me kesa dani aia na dalena daki ida e tsarivania na tasina, “Kalina ia ka tamada e tuturiga nogo na tuqatuqa, me tagara goto sa mane tana barangengo popono ke taugakaita ma ka gini tamani ka daleda. ");
INSERT INTO gri_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ida ma ka palâ ka tamada na uaeni me ke ulavia, rongona kaita ka gini tangomana na maturu koluana ma ka gini tamani ka daleda.” ");
INSERT INTO gri_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mi tana bongi ia mi kaira ara ka vania ka tamaqira na uaeni ke inu, maia na dalena daki ida e maturusai kolua. Maia Lot e ulavi sosongolia na inu susuliga ia, me tau goto donaginia na omea e laba. ");
INSERT INTO gri_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mi tana dani i muri maia na dalena daki ida e tsarivania na tasina, “Inau au maturu kolua ka tamada i bongi; bâ me ke bongi ma ka sauvanitugua na inu me ke ulavigotoa, migoe ko ba maturu kolua. Mi tana nauvaganana ia, ti kaita sui sauba ka gini tamani sa daleda.” ");
INSERT INTO gri_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Me vaga ia, mi tana bongi ia i kaira ara ka palatugua ka tamaqira na uaeni me ulavigotoa, maia na dalena daki tumuri e maturusai kolua ka tamaqira. Maia Lot e ulavi sosongolia na inu susuliga ia, me tau donaginia na omea e laba. ");
INSERT INTO gri_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mi tana nauvaganana ia, ti kaira sui na dalena a Lot ara ka tianaginia ka tamaqira segeni. ");
INSERT INTO gri_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Maia na dalena daki botsa ida e tamani kesa na dalena mane, me soaginia a Moab. Maia nogo na mumuaqira igira na Moab i dani eni. ");
INSERT INTO gri_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Maia na dalena daki botsa tumuri e tamanigotoa kesa na dalena mane, me soaginia a Benami. Maia nogo na mumuaqira igira na Amon i dani eni. ");
INSERT INTO gri_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ma Abraham e mololea i Mamre, me vano tabana i ata na kao ni Kanaan, me ba totu i ka gaqira levuga i Kades mi Sur. Mi muri, kalina aia e ba totu i Gerar, ");
INSERT INTO gri_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","maia e tsaria laka aia ko Sara na tauna na tasina. Ma Abimelek na taovia tsapakae ni Gerar e raigira nina maneaqo kara ba adimaia ko Sara i konina. ");
INSERT INTO gri_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Me kesa tana bongi ma God e laba vania a Abimelek tana bolebole me tsarivania: “Igoe sauba ko mate, rongona o adia na daki iani; maia e tauga nogo.” ");
INSERT INTO gri_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma Abimelek e dona laka aia e tau vati maturu kolua ko Sara, te e tsarivania na Taovia, “!Taovia inau au maka laka au tau naua sa sasi! ?Me laka sauba ko matesiau inau migira goto niqu tinoni? ");
INSERT INTO gri_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ma Abraham segenina nogo e tsaria laka aia na tasina, maia goto ko Sara e tsarivaganana goto ia. Inau au maka saikesa i laona na tobaqu kalina au naua na omea iani, mau tau aqosia sa sasi.” ");
INSERT INTO gri_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ma God e gokovisu vania tana bolebole me tsaria, “Eo, inau au donagininogoa laka igoe o naua na omea iani tana tobamale; aia nogo na rongona ti inau au gini tau tamivanigo ko maturu kolua rongona igoe ko tau sasi i mataqu. ");
INSERT INTO gri_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mi kalina ia, igoe ko molovisua na daki ia vania na savana. Aia e kesa na propete, me sauba ke nonginongi vanigo rongona ko gini tau mate. Me ti ko tau molovisua na daki ia, minau au parovatavigo laka sauba ko mate, igoe migira sui goto nimu tinoni.” ");
INSERT INTO gri_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mi tana matsaraka rovorovo na dani ngana, ma Abimelek e soasaigira sui igira nina mane sasanga me turupatu vanigira na omea e laba, migira ara gini matagu sosongo. ");
INSERT INTO gri_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mi muri, ma Abimelek e soâ a Abraham me veisuâ, “?Nagua o nauvanigami igoe? ?Ma na sasi gua au nauvanigo inau ti o ngaoa ko alomai vaniau inau migira niqu tinoni na rota seko loki iani? E tau saikesa ulagana ke kesa ke naua na omea vaga o nauvaniau igoe. ");
INSERT INTO gri_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","?Ma na rongona gua ti o naua na omea vaga ia?” ");
INSERT INTO gri_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ma Abraham e tuguvisu me tsaria, “Au padâ inau laka ke tau totu sa tinoni ieni ke kukuni tania God, ma kara labumatesiau inau ma kara adia na tauqu. ");
INSERT INTO gri_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Maia na tasiqu manana inau. Aia na dalena tamaqu, me tau na dalena tinaqu, minau au taugâ. ");
INSERT INTO gri_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mi kalina God e mololigiau tania na valena tamaqu na vano tana vera tavosi, minau au tsarivania na tauqu, ‘Igoe ko sauvulagia laka o padalokiau manana ti vaga ko tsarivania pipi sei laka inau na tasimu.’ ");
INSERT INTO gri_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Mi tana, ma Abimelek e molovisua ko Sara vania a Abraham, me tusuvanigotoa na sipi ma na buluka ma na tseka. ");
INSERT INTO gri_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Me tsarivania a Abraham, “Ieni niqu butona kao popono inau; ko totu iava moa tana igoe o ngaoa ko totu.” ");
INSERT INTO gri_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Maia e tsarivanigotoa ko Sara, “Inau au sauvania na tasimu kesa toga na tavina siliva, gana ke saumakalia vanigira na tinoni ara totu kolugo igoe laka o totu male; migira na tinoni sui kara donaginia laka igoe o tau naua sa omea ke sasi.” ");
INSERT INTO gri_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Me rongona na omea vaga ia e laba vania ko Sara na tauna a Abraham, te na Taovia e naua mara gini tau tangomana kara tamani baka igira na daki ara totu i laona na valena a Abimelek. Me tû a Abraham me nonginongi vania a Abimelek, ma God e talivisua. Me talivisu gotoa na tauna migira nina daki tseka, rongona kara gini tangomana na tamani daleqira tugua. ");
INSERT INTO gri_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Na Taovia e vangalaka vania ko Sara vaga aia e vekenogoa laka ke naua, ");
INSERT INTO gri_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ma ko Sara e tiana me vasua kesa na dalena mane vania a Abraham kalina aia e tuqatuqa nogo. Ma na baka mane ia e botsa tana tagu vaga nogo aia God e katenogoa ke botsa. ");
INSERT INTO gri_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ma Abraham e soaginia na baka ia a Isaak, ");
INSERT INTO gri_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","mi kalina a Isaak e alu nogo na bongina, ma Abraham e paripapadana vaga nogo na omea God e ketsalia. ");
INSERT INTO gri_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ma Abraham e kesa sangatu ngalitupana kalina e botsa a Isaak. ");
INSERT INTO gri_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ma ko Sara e tsaria, “God e sauvaniau na magemage ma na kiakia. Me pipi tinoni kara rongomia na omea e laba vaniau sauba kara kia koluau.” ");
INSERT INTO gri_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Me goko babâ goto moa me tsaria, “?Asei nomoa ke tsarivania a Abraham laka ko Sara sauba ke tsutsu baka? Me atsa moa e vaga ia, minau au vasuvania kesa na dalena mane kalina aia e tuqatuqa nogo.” ");
INSERT INTO gri_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma na baka ia e lokiloki, mi tana dani aia e mololea na tsutsu maia Abraham e aqosia kesa na kavomutsa loki. ");
INSERT INTO gri_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Me kesa dani, a Ismael aia na baka ko Hagar na daki ni Ejipt e vasuvania a Abraham, e sisinagi kolua a Isaak na dalena ko Sara. ");
INSERT INTO gri_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Maia ko Sara e reikaira me tû me ba tsarivania a Abraham, “Ko mololigikaira na daki tseka ia ma na dalena. Na dalena na daki iani e tau dou ke tangolidatoa sa turina goto nimu omea tatamani igoe, nina aqo nogo a Isaak na dalequ inau ke tangolidatogira.” ");
INSERT INTO gri_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ma Abraham e rongomisavi sosongolia na goko vaga ia rongona a Ismael goto na dalena aia. ");
INSERT INTO gri_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma God e tsarivania a Abraham, “Laka na gini boe tana ka rongoqira kaira na baka ia ma ko Hagar nimu daki tseka. Ko naua moa na omea e tsarivanigo ko Sara, rongona i konina nogo a Isaak sauba igoe ko tamanina na kukuamu vaga inau au vekenogoa vanigo. ");
INSERT INTO gri_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Me sauba kau vanigotoa a Ismael na dalena nimu daki tseka ke danga goto na dalena ma kara gini lia kesa na puku loki, rongona aia goto nogo na dalemu igoe.” ");
INSERT INTO gri_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mi tana matsaraka bongibongi na dani ngana, ma Abraham e sauvania ko Hagar visana na mutsa me kesa na todo na kô. Maia Abraham e sulukaea na baka tana kokovena tinana me molovanoa. Maia ko Hagar e vano me liu bamai moa i laona na kaomate ni Beerseba. ");
INSERT INTO gri_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mi kalina e kora saikesa ka gaqira kô, maia e moloa na baka i vavana kesa na gai tetelo ");
INSERT INTO gri_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","maia e vano me ba totu puka gana ngongo tsege sangavulu na sangava tania na nauna i tana e moloa na dalena. Maia e tsarisegenina, “E utu kau berengiti na reiana kalina ke mate na dalequ.” Mi kalina aia e tototu moa i tana, ma na baka e tuturiga na ngangai. ");
INSERT INTO gri_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ma God e rongomia nina ngangai na baka, me tû i baragata kesa nina angelo God e gokotsunamai vania ko Hagar me tsaria, “?Ko Hagar, matena gua ti o melu sosongo vaga ia? Ko laka na matagu. God e rongominogoa nina ngangai na baka. ");
INSERT INTO gri_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ko tû, mo ko ba tulangikaea na dalemu mo ko verea. Minau sauba kau naua ma na kukuana aia kara lia kesa na puku loki.” ");
INSERT INTO gri_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mi muri, ma God e sangavia na matana ko Hagar, maia e morosia kesa na tuvu i tana. Me bâ toretugua ka gaqira kô me vania na baka ke inu. ");
INSERT INTO gri_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ma God e totu kolua na baka ia, maia e lokiloki me ba totu tana kaomate ni Paran me lia na tinoni e dona sosongo na rugu. ");
INSERT INTO gri_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ma na tinana e adivania kesa na tauna na daki ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mi tana tagu ia, maia Abimelek e tû me vano kolua a Pikol gaqira taovia tagao igira nina mane vaumate, me ba tsarivania a Abraham, “God nogo e totu kolugo igoe me pipi sui na omea igoe o naua. ");
INSERT INTO gri_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Me vaga ia, migoe ko gini vatsa ieni i matana God laka igoe sauba e utu goto ko peroau inau, migira na dalequ migira goto na kukuaqu. Inau au dou sosongo vanigo igoe, me vaga ia migoe ko vekea laka igoe goto sauba ko naudou vaniau inau ma na vera iani i tana o totu kalina ia.” ");
INSERT INTO gri_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ma Abraham e tsarivania, “Eo, sauba kau vatsa.” ");
INSERT INTO gri_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mi kalina a Abraham e gini goko vania a Abimelek rongona kesa nina tuvu igira nina maneaqo a Abimelek ara laua, ");
INSERT INTO gri_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","maia Abimelek e tsaria, “!Inau au tau saikesa dona asei e naua na omea vaga ia. Migoe o tau goto tsarivaniau inau, miani nogo na kesanina tagu inau au rongomia laka e laba na omea vaga ia.” ");
INSERT INTO gri_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mi muri, maia Abraham e sauvania a Abimelek visana na sipi ma na buluka, mi tana mi kaira ara ka naua ka niqira tabesai. ");
INSERT INTO gri_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ma Abraham e tû me vililigitugira vitu na dalena sipi i laona nina alaala na sipi, ");
INSERT INTO gri_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","maia Abimelek e veisuâ, “?Rongona gua ti igoe o naua na omea vaga ia?” ");
INSERT INTO gri_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ma Abraham e gokovisu me tsaria, “Ko tamia moa na adiaqira na dalena sipi tugirani. Mi tana nauvaganana ia, ti igoe ko sanga na tsariana laka inau nogo au tsaia na tuvu iani.” ");
INSERT INTO gri_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Me tû tana tagu ia mara soaginia tana nauna ia i Beerseba, rongona i tana nogo i kaira ara ka naua ka niqira vekesai. ");
INSERT INTO gri_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mi murina kalina ara ka nausuia ka niqira tabesai i Beerseba, mi kaira a Abimelek ma Pikol ara ka visutugua i Pilistia. ");
INSERT INTO gri_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Mi muri, ma Abraham e tsuka i Beerseba kesa na gaitabu, mi tana aia e samasama vania na Taovia aia na God Saliu. ");
INSERT INTO gri_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma Abraham e mauri oka sosongo i laona na Pilistia. ");
INSERT INTO gri_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Me kesa tana tagu i muri, ma God e tovolea a Abraham me soâ, “!Abraham!” Ma Abraham e tsaria, “Inau ieni Taovia!” ");
INSERT INTO gri_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma God e tsarivania, “Ko adia na dalemu a Isaak, aia moa ngiti dalemu aia igoe o galuve sosongolia, mo ko bâ tana butona kao ni Moria. Mi tana i kelana na vungavunga sauba inau kau tusuvanigo, ko savorivaniau na dalemu vaga na savori-kodokodo.” ");
INSERT INTO gri_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mi tana matsaraka rovorovo na dani ngana, ma Abraham e tû me visâ visana na lake gana na kodoputsa, maia e molokaea i gotuna nina asi, me soâ a Isaak me ruka nina maneaqo kara tu dulikolua. Mi tugira ara tu tuturiga na vano kaleana tana nauna aia God e tsarivaninogoa a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mi tana tolunina dani, ma Abraham e morosi-aoa na nauna ia. ");
INSERT INTO gri_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Maia e tsarivanikaira nina maneaqo, “Kamu ka totupitu ieni kolua na asi. Na baka iani minau sauba kami ka vano i garia na samasama, mi muri ti kami ka visumaitugua ka konimui.” ");
INSERT INTO gri_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Maia Abraham e adia na lake me molo bâ tana kokovena a Isaak ke kalagaia, maia segenina nogo e tangolia na gau ma na ketsuma gagâ gana na mani soqoi lake. Mi kalina kaira ara ka vavano moa i sautu, ");
INSERT INTO gri_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ma Isaak e tsaria, “!Mama!” Ma Abraham e tuguvisua me tsaria, “?Eo, egua dalequ?” Ma Isaak e veisuâ, “?Au morosia igoe o adia na ketsuma gagâ ma na lake, miava na dalena sipi gana na mani kodoputsa?” ");
INSERT INTO gri_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ma Abraham e tsarivania, “God segenina nogo sauba ke saua.” Mi kaira ara ka vano babâ moa i sautu. ");
INSERT INTO gri_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mi kalina ara ka ba tsau tana nauna i tana God e tsarinogoa vania a Abraham, ma Abraham e aqosia kesa na belatabu me vangaraua na lake i kelana. Me soria a Isaak na dalena me molokaea i kelana na lake tana belatabu. ");
INSERT INTO gri_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Me langâ nina gau laka ke labumatesia na dalena. ");
INSERT INTO gri_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mi tana tsotsodo kesa nina angelo na Taovia e goko tsunamai vania tû i gotu i baragata me tsaria, “!Abraham, Abraham!” Maia e tsaria, “Inau ieni Taovia.” ");
INSERT INTO gri_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ma na angelo e tsarivania, “Ko laka na labuana na baka ia mo ko laka na sekoliana. Kalina ia inau au donaginia laka igoe o kukuni tania God, rongona igoe o tau sove na tusuvaniana na dalemu aia segeni moa ngiti dalemu.” ");
INSERT INTO gri_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ma Abraham e moro polipoli me reia kesa na sipi mane e kara na kakatsana tana gai. Maia e bâ me tangolia na sipi mane ia, me gini savori-kodokodo tuguna na dalena. ");
INSERT INTO gri_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ma Abraham e soaginia na nauna ia “Na Taovia e saumaia.” Me tsaumai i dani eni, migira na tinoni ara tsaria, “Tana nina vungavunga na Taovia aia e saumaia.” ");
INSERT INTO gri_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Me tû i gotu, ma nina angelo na Taovia e soatugua a Abraham na rukanina kalina me tsarivania, ");
INSERT INTO gri_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Na Taovia segenina nogo e tsarivanigo na goko iani: ‘Inau au gini vatsa tana asaqu segeni nogo, laka tana rongona nogo igoe o nauvaganana ia mo tau tongovaniau na dalemu aia moa ngiti dalemu, minau sauba kau vangalaka sosongo vanigo, ");
INSERT INTO gri_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ma kau naua migira na kukuamu kara danga vaga na veitugu tana masaoka ma na vatuna one i tasi. Migira na kukuamu sauba kara tuliusigira gaqira gala. ");
INSERT INTO gri_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Me pipi sui na puku tana barangengo sauba kara nongiau kau vangalaka vanigira vaga au vangalaka vanigira na kukuamu igoe, rongona igoe o rongomangaqu dou.’ ” ");
INSERT INTO gri_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mi muri, ma Abraham e tû me visubatugua ka koniqira nina maneaqo, mi tugira ara tu visu sui i Beerseba, ma Abraham e ba totutugua i tana. ");
INSERT INTO gri_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Me kesa tana tagu i muri, ma Abraham e rongomia laka ko Milka e vasuvania a Nahor na kulana ara tu alu na dalena: ");
INSERT INTO gri_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","a Us aia na idana botsa, ma Bus na kulana, ma Kemuel na tamana a Aram, ");
INSERT INTO gri_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ma Kesed, ma Haso, ma Pildas, ma Jidlap, ma Betuel ");
INSERT INTO gri_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","aia na tamana ko Rebeka. Ko Milka e vasuvania a Nahor na kulana a Abraham tugira alu na baka mane tugirani. ");
INSERT INTO gri_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma ko Reuma, aia na tauna lê a Nahor, e vasuvania ara tu vati na dalena mane: tugira nogo a Teba, ma Gaham, ma Tahas ma Maaka. ");
INSERT INTO gri_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ko Sara e mauri tsaulia kesa sangatu rukapatu vitu na ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Maia e mate i Hebron i laona na kao ni Kanaan, ma Abraham e tangisia na mateana. ");
INSERT INTO gri_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Maia e mololea tana nauna e tsatsaro na kubuna na tauna, me vano i koniqira na Het me ba tsarivanigira, ");
INSERT INTO gri_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Inau au kesa na tinoni na vera tavosi mau totu ieni i laomui nogo igamu; au nongigamu kamu tsabiri vaniau sa butona kao, rongona kau qiluginia na tauqu.” ");
INSERT INTO gri_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Migira ara tsarivania, ");
INSERT INTO gri_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ko roro ngo taovia. Igami ami morosigo igoe vaga kesa na taovia loki; me dou ti ko qilua na taumu i laona sa vatuluma dou liuliu bâ igami ami tamanina. E utu kesa vidamami igami ke tongovanigo igoe nina vatuluma ko qiluginia na taumu.” ");
INSERT INTO gri_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Maia Abraham e tsuporu i mata qira ");
INSERT INTO gri_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","me tsaria, “Me ti vaga igamu kamu tamivaniau kau qilua na tauqu ieni, me dou kamu nongia a Epron na dalena a Sohar ");
INSERT INTO gri_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ke tsabirivaniau na Vatuluma Makpela, aia e totu varangisia na vovotana nina kao. Kamu veisuâ ke tsabirivaniau tana matena popono ieni nogo i matamui igamu, rongona kau gini tamanina inau gana na qiluqilu.” ");
INSERT INTO gri_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ma Epron segenina goto e tototu i tana kolugira na Het tavosi tana nauna gana na sai tana matsapakapuna na verabau, maia e gokovisu vania a Abraham i mataqira na tinoni sui ara totu tana me tsaria, ");
INSERT INTO gri_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ko rorongo taovia. Inau sauba kau sauvanigo na kao popono kolugotoa na vatuluma i laona. Ieni nogo i mataqira na tinoni ni veraqu segeni nogo, inau sauba kau saua vanigo, rongona ko qiluginia na taumu.” ");
INSERT INTO gri_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ma Abraham e tsuporu i mata qira na Het, ");
INSERT INTO gri_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","me tsarivania a Epron i mataqira na tinoni sui rongona igira sui kara gini rorongo, “Au nongigo ko rongomiau kiki. Inau sauba kau volia na kao popono ia. Ko tamia moa na adiana na matena kau sauvanigo me sauba kau ba qilua na tauqu i tana.” ");
INSERT INTO gri_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ma Epron e gokovisu vania me tsaria, ");
INSERT INTO gri_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Taovia, na kao ia e vati moa sangatu na tavina siliva na matena. ?Ma nagua goto ka levugada kaita? Ko bâ mo ko qilua na taumu i tana.” ");
INSERT INTO gri_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ma Abraham e tabedoua me tsokoa na dangana na tavina siliva vaga e tsaria a Epron i mataqira na Het ara totu i tana, ara vati sangatu tavina siliva, taonia na tovo mamava ara gini aqo igira na tinoni tsabiri tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Aia nogo e vaga te na butona kao e tamanina a Epron i Makpela i Mamre tabana i longa e lia nina tamani a Abraham. E adisaigotoa na uta ma na vatuluma e totu i laona, me pipi sui goto na gai ara tutû i laona na uta ia me tsau bâ tana vovotana na kao ia. ");
INSERT INTO gri_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Migira sui na Het ara totu tana sai tana dani ia ara reigadovisuia laka na nauna i tana e lia nogo nina tamani a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mi murina ia, ma Abraham e ba qilua ko Sara na tauna i laona na vatuluma ia tana kao ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Me vaga ia, ma na kao ara tamanina igira na Het tana idana ma na vatuluma e totu i laona ara lia nogo nina nauna na mani qiluqilu a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Mi kalina ia ma Abraham e tuqatuqa sosongo nogo, ma na Taovia e vangalaka sosongo vania pipi tana omea aia e naua. ");
INSERT INTO gri_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Maia Abraham e tû me tsarivania nina maneaqo kakatu bâ aia e reitutugugira pipi sui na omea levolevo e tamanina a Abraham, “Ko moloa na limamu i levugana na kakabaqu mo ko aqosia kesa na veke. ");
INSERT INTO gri_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Inau au ngaoa igoe ko vatsa tana asana na Taovia aia na God ni baragata mi barangengo, laka sauba ko tau lave tauna na dalequ inau i laoqira na tinoni ni ieni i Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nimu aqo nomoa igoe ko visutugua tana vera i tana inau au botsa mo ko lavea sa tauna a Isaak i koniqira na kamaqu.” ");
INSERT INTO gri_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma na maneaqo ia e veisuâ, “?Me ke koegua vaga ti na baka daki ia ke tau ngaoa na mololeana verana ma na mai koluaqu inau tana kao iani? ?Egua, laka e dou moa ti kau molovisua a Isaak tana kao i tana o talumai igoe?” ");
INSERT INTO gri_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ma Abraham e gokovisu me tsaria, “!Ko parovata dou sosongo rongona ko tau molovisua na dalequ inau i tana! ");
INSERT INTO gri_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Na Taovia na God ni baragata, aia e adirutsumiau tania na valena tamaqu me tanigotoa niqira kao na kamaqu, aia nogo e vatsa vaniau laka aia sauba ke saua na kao iani vanigira na kukuaqu. Maia sauba ke moloa kesa nina angelo ke idagana sautu vanigo igoe, rongona ko gini adi tauna na dalequ inau i tana. ");
INSERT INTO gri_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Bâ, me ti vaga na baka daki ia ke tau ngaoa na dulikoluamu mai, migoe sauba ko tapiu tania na veke ia. Mo ko laka saikesa moa na molovisuana na dalequ i tana.” ");
INSERT INTO gri_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Mi tana, ma na maneaqo e moloa na limana i levugana na kakabana a Abraham gana taovia, me vatsa laka aia ke nau mananâ na omea e ketsaliginia a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ma na maneaqo, aia e reitutugugira nina omea levolevo a Abraham, e adigira e sangavulu nina kamelo gana taovia, me vano i Mesopotamia tabana i vava tana nina verabau a Nahor. ");
INSERT INTO gri_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mi kalina aia e ba laba i tana, me mologira nina kamelo kara tsaro i ligisana na tuvu i tabana i tano na verabau ia. Mi tana tagu ia e niaso ngulavi nogo, ma na tagu goto i tana igira na daki ara lavu na mai na tore kô tana tuvu ia. ");
INSERT INTO gri_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Maia e nonginongi me tsaria, “Taovia, igoe nina God a Abraham gaqu taovia, au nongigo ko manalia nimu veke o nauvania gaqu taovia, mo ko sangaau ma kau tangomana tana omea au sulungana mai na nauana. ");
INSERT INTO gri_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Inau au totu ieni tana tuvu i tana igira na daki vaolu tana verabau iani sauba kara mai na tore kô. ");
INSERT INTO gri_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Me sauba kau tsarivania ke kesa vidaqira, ‘Kiki, ko molotsuna bâ nimu popovatu ma kau inu inau.’ Me ti vaga aia ke tami me ke tsaria, ‘Eo dou, inu, minau kau saogaqira kô goto nimu kamelo,’ maia saikesa nogo na baka daki igoe o vilivania nimu maneaqo a Isaak. Me ti vaga ke laba vaganana ia, minau sauba kau donaginia laka igoe o manalia nimu veke o nauvania gaqu taovia.” ");
INSERT INTO gri_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Maia e tau vati sui moa nina nonginongi, me labamai ko Rebeka kolua kesa na popovatu tana kokovena. Aia na dalena daki a Betuel, ka daleqira a Nahor na kulana a Abraham ma ko Milka na tauna. ");
INSERT INTO gri_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ma ko Rebeka e rerei dou sosongo me baka daki vaolu moa me tau goto vati maturu kolua sa mane. Aia e bâ tana tuvu me torea nina popovatu me vivisutugua. ");
INSERT INTO gri_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Maia nina maneaqo a Abraham e ulo bâ i konina me tsarivania, “Kiki, ko sauvaniau ma kau inu tana nimu popovatu.” ");
INSERT INTO gri_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ma ko Rebeka e tsarivania, “E dou, ko inu taovia,” maia e molotsuna tsakua nina popovatu tania na kokovena me tangolivania kalina aia e inuinu. ");
INSERT INTO gri_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mi kalina aia e inu sui, maia ko Rebeka e tsarivania, “Inau sauba kau adigaqira kô goto nimu kamelo, poi kalina kara vatsa na inu.” ");
INSERT INTO gri_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Maia e qetu bâ tsakua na kô tana niqira popo na inu me ulovisutugua tana tuvu na sao kô, poi kara inu sui igira nina kamelo nina maneaqo a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ma na mane ia e tû mui moa me morosia ko Rebeka, gana ke tsodovulagia ti vaga na Taovia ke sauvania na tangomana tana omea aia e sulungana. ");
INSERT INTO gri_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mi muri, kalina ko Rebeka e sui nogo na saogaqira kô na kamelo, ma na mane ia e adia kesa na ringi qolumila loki matena me molo bâ tana isuna, me molo ba gotoa ruka na qato loki qolumila tana limana. ");
INSERT INTO gri_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Me tsarivania, “Kiki, ko tsarivaniau laka asei na tamamu. ?Me laka e totu goto sa voki tana valena tamamu ke tugua kami ba maturu inau migira niqu mane?” ");
INSERT INTO gri_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Maia e tuguvisua me tsaria, “Na tamaqu inau aia nogo a Betuel ka daleqira a Nahor ma ko Mikal. ");
INSERT INTO gri_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Eo, me danga dou goto na buruburu makede tana valemami, me totu goto kesa na nauna i tana kamu ba totu.” ");
INSERT INTO gri_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ma na mane ia e tsunatuturu me samasama vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Me tsaria, “Tsonikaea na Taovia, nina God a Abraham gaqu taovia, aia e manali saikesalia nina veke e nauvania gaqu taovia. Na Taovia e adisaviliuau bâ i koniqira na kamana gaqu taovia.” ");
INSERT INTO gri_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ma na baka daki ia e ulo bâ tana valena tinana me turupatuna vania na omea popono. ");
INSERT INTO gri_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ko Rebeka e tamanina kesa na tasina mane, a Laban na soana, maia e tû me ulorutsu i tano na vano tana tuvu i tana e totu nina maneaqo a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","A Laban e reinogoa na ringi qolumila tana isuna tasina ma na qato tana limana me rongomia kalina na tasina e turupatuna na omea na mane ia e tsarivania. Maia e vano i konina nina maneaqo a Abraham aia e totu moa i ligisaqira nina kamelo tana tuvu ");
INSERT INTO gri_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","me tsarivania, “Ko mai koluau ma ka vano i vera. Igoe kesa na mane aia na Taovia e vangalaka sosongo vanigo. ?Na rongona gua ti o tutû moa ieni i tano? E totu manoga vanigo nogo kesa na voki tana valequ, me totu goto kesa nauna vanigira nimu kamelo.” ");
INSERT INTO gri_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Me vaga ia, maia na mane aqo e ba sage i valena a Laban, ma Laban e aditsunagira gaqira lutsa na kamelo me sauvanigira na buruburu makede. Mi muri, maia e adi kô vania nina maneaqo a Abraham migira gana duli kara vuliginia na tuaqira. ");
INSERT INTO gri_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Mi kalina ara adimaia na mutsa, ma na mane ia e tsaria, “E utu mavi kau mutsa inau poi kau tsarivulagitalua na omea au gini mai matena.” Ma Laban e tsaria, “Bâ igoe, ko goko.” ");
INSERT INTO gri_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Maia e tuturiga na goko me tsaria, “Inau nina maneaqo a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Na Taovia e vangalaka sosongo vania gaqu taovia, me naua maia e tamanina na omea danga sosongo. Maia e sauvania danga na sipi ma na naniqoti, na buluka, na siliva ma na qolumila, na tseka daki ma na tseka mane, na kamelo ma na asi. ");
INSERT INTO gri_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Maia ko Sara na tauna gaqu taovia e vasuvania kesa na dalena mane kalina aia e kavekave nogo, ma gaqu taovia e vaninogoa na dalena ke tangolidatoa pipi sui na omea aia e tamanina. ");
INSERT INTO gri_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ma gaqu taovia e raiau inau kau vatsa laka kau taonia nina ketsa. Maia e tsarivaniau, ‘Ko laka na vili tauna na dalequ i laoqira na baka daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ko bâ i koniqira igira tana valena tamaqu mi koniqira na kamaqu, mi tana igoe ko vili tauna na dalequ.’ ");
INSERT INTO gri_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Minau au veisuâ gaqu taovia, ‘?Ke koegua vaga ti na baka daki ia ke tau ngaoa na tsarimuriqu mai inau?’ ");
INSERT INTO gri_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Maia e tuguvisua me tsaria, ‘Na Taovia, aia au rongomangana sailagi, sauba ke moloa kesa nina angelo ke idagana sautu vanigo me ke sauvanigo gamu tangomana. Igoe sauba ko adi tauna na dalequ i laoqira niqu tinoni segeni, mi tana vungu i konina nogo na tamaqu. ");
INSERT INTO gri_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Me kesa lelê moa na omea ti o tangomana ko gini tanusi tania nimu vatsa: ti vaga igoe ko vano i koniqira na kamaqu migira kara sove na sauana na baka daki ia vanigo, mi tana moa ti tangomana igoe ko gini tanusi.’ ");
INSERT INTO gri_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mi kalina au mai tana tuvu i dani eni, inau au nonginongi vaga iani, ‘Taovia, igoe nina God a Abraham gaqu taovia, kiki igoe ko sauvaniau na tangomana tana omea au sulungana mai na nauana. ");
INSERT INTO gri_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Au totu inau tana tuvu iani. Mi kalina ti ke kesa na daki vaolu ke mai na sao kô, inau sauba kau nongia ke sauvaniau ma kau inu tana nina popovatu. ");
INSERT INTO gri_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Me ti vaga aia ke tamivaniau me ke tamigotoa na saogaqira kô niqu kamelo, maia saikesa nogo na baka daki igoe o vilia ke lia na tauna na dalena gaqu taovia.’ ");
INSERT INTO gri_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Me tau vati sui moa niqu nonginongi segeni, maia ko Rebeka e mai kolua kesa na popovatu tana kokovena, me tsuna bâ tana tuvu na sao kô. Minau au tsarivania, ‘Kiki, ko sauvaniau kau inu.’ ");
INSERT INTO gri_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Maia e molotsuna tsakua nina popovatu tania na kokovena me tsaria, ‘E dou, ko inu, me sauba goto kau saogaqira kô nimu kamelo.’ Mi tana minau au inu, maia e saogaqira kô niqu kamelo. ");
INSERT INTO gri_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mau veisuâ, ‘?Asei na tamamu?’ Maia e gokovisu me tsarivaniau, ‘A Betuel na tamaqu inau, aia ka daleqira kaira a Nahor ma ko Milka.’ Mi muri minau au moloa kesa na ringi tana isuna ma na qato tana limana. ");
INSERT INTO gri_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mi tana minau au tsunatuturu mau samasama vania na Taovia. Au tsonikaea na Taovia nina God a Abraham gaqu taovia, aia e adisaviliuau bâ i konina na kamana gaqu taovia, i tana au tsodoa na dalena daki na kamana vania na dalena mane gaqu taovia. ");
INSERT INTO gri_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mi kalina ia, ti vaga igamu amu padâ na tabedouana nina goko ma na manaliana gamui tabana vania gaqu taovia, ma kamu tsarimakalia vaniau; me ti tagara, ma kamu tsarigotoa, ti kau gini pedea na omea gua sauba kau naua.” ");
INSERT INTO gri_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Mi kaira a Laban ma Betuel ara ka tsarivania, “Rongona na omea iani e pukugamai konina na Taovia, me tau ka nimami aqo kagami kami ka tsaria sa rongona. ");
INSERT INTO gri_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Iani ko Rebeka; ko adia mo ko vano. Maia ke lia na tauna na dalena gamu taovia, vaga nogo e tsaria na Taovia.” ");
INSERT INTO gri_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mi kalina nina maneaqo a Abraham e rongomi vaganana ia, maia e tsuporu tsuna me samasama vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mi muri, maia e tû me aditsuna na polo ma na inilau siliva ma na qolumila, me saugira vania ko Rebeka. Maia e saugotoa visana na vangalaka loki matena vanikaira na tasina ma na tinana. ");
INSERT INTO gri_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Mi muri, maia nina maneaqo a Abraham migira gana duli ara mutsa mara inu mara maturu i tana. Mi kalina ara mamata tana matsaraka maia e tsaria, “Kamu tu tamivaniau ma kau visu bâ i konina gaqu taovia.” ");
INSERT INTO gri_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mi kaira na tasina ma na tinana ko Rebeka ara ka tsaria, “Ko molotalua na baka daki ke totuvisu kolugami talu ke kesa uiki se ke sangavulu dani, mi muri ti aia ke tsari bâ.” ");
INSERT INTO gri_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Maia e tsaria, “Kamu ka laka na tongovisuaqu. Na Taovia e naunogoa mau gini tangomana tana omea au sulungana mai na nauana; kamu ka tami moa vaniau ma kau visutugua i konina gaqu taovia.” ");
INSERT INTO gri_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Mi kaira ara ka tuguvisua mara ka tsaria, “Ida ma ka soamaia na baka daki ma ka veisuâ nagua aia ke tsaria.” ");
INSERT INTO gri_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Mi tana mara ka soamaia ko Rebeka mara ka veisuâ, “?Laka o ngaoa na muriana na mane iani igoe?” Maia e tsaria, “Eo.” ");
INSERT INTO gri_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mi tana, mara ka tamivania ko Rebeka ma na daki aia e reitutugua tû tana bakana kara ka vanokolua nina maneaqo a Abraham migira gana duli. ");
INSERT INTO gri_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Mara veilivua ko Rebeka mara tsarivania, “!Igoe na tasimami, sauba ko lia na tinaqira na mamau! !Migira na kukuamu kara tangoligira niqira verabau gaqira gala!” ");
INSERT INTO gri_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mi tana maia ko Rebeka migira nina daki aqo ara binaboli mara sagekae tana kamelo mara vano kolua nina maneaqo a Abraham. Me vaga ia ma nina maneaqo a Abraham e adia ko Rebeka me vano. ");
INSERT INTO gri_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mi tana tagu ia, maia Isaak e mai nogo tana kaomate tana nauna ara soaginia “Nina Tuvu Aia e Mamauri me Morosiau Inau” me ba totu tana butona na kao ni Kanaan tabana i ata. ");
INSERT INTO gri_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Me kesa tana ngulavi ma Isaak e vano na lela bamai i laona na uta me morosibagira visana na kamelo ara maimai. ");
INSERT INTO gri_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Mi kalina ko Rebeka e morosia a Isaak, maia e tsiputsuna tania nina kamelo, ");
INSERT INTO gri_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","me veisuâ nina maneaqo a Abraham, “?Laka sei mane ia e maimai kalegita igita i laona na uta ia?” Ma nina maneaqo a Abraham e tsaria, “Aia nogo gaqu taovia inau.” Mi tana ma ko Rebeka e adia na polo me tsavupoiginia na matana. ");
INSERT INTO gri_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ma na maneaqo ia e turupatuna vania a Isaak pipi sui na omea aia e naua. ");
INSERT INTO gri_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Mi muri, ma Isaak e adi bâ ko Rebeka tana valepolo aia ko Sara na tinana e totu i laona tana idana, maia e taugâ ko Rebeka. Ma Isaak e galuvedou sosongolia ko Rebeka, me vaga ia te e gini dou tugua tobana a Isaak murina na mateana tinana. ");
INSERT INTO gri_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ma Abraham e tauga gotoa kesa na daki aia ko Ketura na soana. ");
INSERT INTO gri_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Maia e vasuvania a Abraham tugira ono na dalena mane: tugira nogo a Simran, ma Joksan, ma Medan, ma Midian, ma Isbak ma Sua. ");
INSERT INTO gri_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ma Joksan aia ka tamaqira a Seba ma Dedan, migira na kukuana a Dedan igira nogo na Asurim, ma na Letusim ma na Leumim. ");
INSERT INTO gri_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mi tugira na dalena a Midian tugira nogo a Epa, ma Eper, ma Hanok, ma Abida ma Eldaa. Igirani sui na kukuana ko Ketura. ");
INSERT INTO gri_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","A Abraham e molovania a Isaak ke tangolidatoa pipi sui na omea aia e tamanina; ");
INSERT INTO gri_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","mi kalina a Abraham e mamauri moa, maia e vangalaka moa vanigira igira na dalena mane tavosi ara vasuvania igira na tauna tavosi. Mi muri, maia e molovanogira na dalena mane gira kara ba totu tana butona kao tabana i Longa, kara gini totu tabaligi tania a Isaak na dalena. ");
INSERT INTO gri_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ma Abraham e mate kalina e tuqatuqa sosongo nogo, ma na ngalitupana e tsaulia kesa sangatu vitu sangavulu tsege na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Mi kaira a Isaak ma Ismael na dalena ara ka ba qilua tana Vatuluma ara soaginia Makpela, i laona na kao e totu tabana i longa Mamre aia e tamanina a Epron na dalena a Sohar na Het tana idana. ");
INSERT INTO gri_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aia nogo na kao a Abraham e volia i koniqira na Het; mi kaira sui a Abraham, ma ko Sara na tauna ara qilukaira sui moa tana. ");
INSERT INTO gri_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mi murina na mateana a Abraham, ma God e vangalaka dou sosongo vania a Isaak na dalena, aia e totu i ligisana na tuvu ara soaginia “Nina Tuvu Aia e Mamauri Me Morosiau Inau.” ");
INSERT INTO gri_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A Ismael aia ko Hagar na daki ni Ejipt ma nina tseka ko Sara e vasuvania a Abraham, ");
INSERT INTO gri_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","e tamani sangavulu ruka na dalena mane ara tu botsa vaitsarimurigi: igira nogo a Nebaiot, ma Kedar, ma Adbeel, ma Mibsam, ");
INSERT INTO gri_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ma Misma, ma Duma, ma Masa, ");
INSERT INTO gri_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ma Hadad, ma Tema, ma Jetur, ma Napis, ma Kedema. ");
INSERT INTO gri_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Igira nogo na mumuaqira ara sangavulu ruka na puku, ma na soaqira ara tangomalavuginia na veraqira ma na nauna i tana ara vaturikaegira niqira valepolo. ");
INSERT INTO gri_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ma Ismael e tsaulia kesa sangatu tolu sangavulu vitu ngalitupana kalina e mate. ");
INSERT INTO gri_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Migira na kukuana a Ismael ara totuvia na butona kao ka levugaqira i Havila mi Sur, i tabana i longa na Ejipt tana sautu e vano kalea i Asiria. Migira ara totu tabaligi segeni tanigira na kukuana tavosi a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iani na turupatuna tana rongona a Isaak na dalena a Abraham. ");
INSERT INTO gri_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","E vati sangavulu nogo na ngalitupana a Isaak kalina aia e taugâ ko Rebeka aia na dalena a Betuel na Aramea ni Mesopotamia ma na tasina a Laban. ");
INSERT INTO gri_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ma Isaak e nonginongi vania na Taovia rongona e totu mamane ko Rebeka na tauna. Ma na Taovia e rongomia nina nonginongi me gini tiana ko Rebeka. ");
INSERT INTO gri_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Maia sauba ke batso na dalena, me idavia ka botsaqira kaira mara ka vaisugutigi sosongo i laona na tobana ka tinaqira. Ma ko Rebeka e tsaria, “?Rongona gua ti e laba vaniau na omea vaga iani?” Maia e tû me vano na veisuana na Taovia ke votarongona vania. ");
INSERT INTO gri_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ma na Taovia e tsarivania, “Ara ka ruka na puku na tinoni i laona tobamu igoe. Mi kaira na puku sauba ko vasukaira igoe sauba kara ka vaigalagi. Me kesa ka vidaqira sauba ke susuliga bâ liusia kesa, ma na idana sauba ke aqo vania na tumurina.” ");
INSERT INTO gri_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mi kalina e laba na tagu ke vasua na dalena, maia e tamanina na batso. ");
INSERT INTO gri_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Na idana botsa e tsitsi na kokorana me vuvuluga vaga na itai vuvuluga, mara soaginia a Esau. ");
INSERT INTO gri_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mi kalina e botsa na rukanina maia e tatango kakai tana bobouna tuana a Esau, mara soaginia a Jakob. E ono sangavulu na ngalitupana a Isaak kalina ara ka botsa kaira. ");
INSERT INTO gri_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mara ka lokiloki na baka mane kaira, ma Esau e lia na mane na rugu dou sosongo me reingaoa na totu i legai, maia Jakob e mane muimui moa me totu moa i vera. ");
INSERT INTO gri_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ma Isaak e reingaoa bâ a Esau rongona e gini mage na ganiana na sabo e matesia a Esau, maia ko Rebeka e reingaoa bâ a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Me kesa dani kalina a Jakob e kuki supu na pini, maia Esau e visumai talu na rugu. Maia e vitoa mate ");
INSERT INTO gri_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","me tsarivania a Jakob, “Inau au vitoa mate; ko tusuvaniau inau na turina na omea tsitsi ia.” Maia nogo na rongona ti ara soaginigotoa aia Esau a Edom. ");
INSERT INTO gri_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Jakob e gokovisu me tsaria, “Eo, sauba kau sauvanigo ti vaga igoe ko sauvaniau talu gamu susuliga gana na adidatoana nina omea levolevo ka tamada vaga na baka botsaida.” ");
INSERT INTO gri_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ma Esau e tsaria, “!E dou! Inau au varangi nogo kau mate; ma nagua na peluna vaniau inau na adidatoana nina omea levolevo ka tamada kalina au vaga ia?” ");
INSERT INTO gri_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma Jakob e gokovisu me tsaria, “Ko ida talu nomoa ko vatsa vaniau laka sauba ko sauvaniau inau gamu susuliga.” Ma Esau e vatsa me sauvania a Jakob gana susuliga. ");
INSERT INTO gri_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Mi muri, maia Jakob e sauvania a Esau visana na bredi ma na supu. Maia e mutsa me inu, mi muri me tû me vano. Mi tana nauvaganana ia, ma Esau e sauvulagia laka e tau lelê padalokia gana susuliga vaga na baka botsaida. ");
INSERT INTO gri_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Me liu goto kesa na tagu na uvirau tana kao ni Kanaan e vaga nogo aia e laba ida tana taguna a Abraham. Ma Isaak e tû me vano i Gerar, i konina a Abimelek aia niqira taovia tsapakae igira na Pilistia. ");
INSERT INTO gri_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ma na Taovia e labavania a Isaak me tsarivania, “Ko laka na vano i Ejipt; ko totu moa tana butona kao ieni i tana inau kau tsarivanigo ko totu. ");
INSERT INTO gri_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ko totu ieni, minau sauba kau totu kolugo ma kau vangalaka vanigo. Inau sauba kau sauvanigo igoe me vanigira na kukuamu na butona kao popono iani, ma kau manalia na veke au naunogoa vania a Abraham na tamamu. ");
INSERT INTO gri_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Me sauba kau sauvanigo na kukuamu ma kara danga vaga na veitugu tana masaoka, ma kau sauvanigira na butona kao popono iani. Me pipi sui na puku sauba kara nongiau kau vangalaka vanigira vaga inau au vangalaka vanigira na kukuamu igoe. ");
INSERT INTO gri_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Eo, sauba kau vangalaka vanigo igoe, tana rongona nogo a Abraham e rongomangaqu inau me murigira pipi sui niqu vali ma niqu ketsa.” ");
INSERT INTO gri_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Me vaga ia, ma Isaak e totu moa i Gerar. ");
INSERT INTO gri_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mi kalina igira na mane ni tana ara veisuâ a Isaak tana rongona ko Rebeka na tauna, maia e tsaria laka aia na tasina. E tau ngaoa na tsarivulagiana laka ko Rebeka na tauna rongona e matagu kara tau labumatesia igira na mane ni tana ma kara adia ko Rebeka rongona aia e rerei dou sosongo. ");
INSERT INTO gri_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mi kalina e totu oka tetelo nogo a Isaak i tana, ma Abimelek na taovia tsapakae e mororutsu tana nina ovaovana bisi, me reikaira a Isaak ma ko Rebeka ara ka vaivilogi. ");
INSERT INTO gri_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ma Abimelek e mologoko bâ vania a Isaak ke mai reia me tsarivania, “!Ko Rebeka na taumu nogo igoe! ?Me rongona gua ti o tiapoia mo tsaria laka aia na tasimu?” Ma Isaak e tuguvisua me tsaria; “Au padâ laka sauba kamu matesiau ti vaga kau tsaria laka aia na tauqu.” ");
INSERT INTO gri_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ma Abimelek e tsaria, “?Nagua vaga ia o nauvanigami igoe? Me tau utu ti kesa niqu mane inau ke bâ me ke maturu kolua na taumu igoe kalina e vaga ia, migoe nogo o alomaia ti ke gini gadovigami na kede.” ");
INSERT INTO gri_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Mi tana, ma Abimelek e tû, me parovatavigira na tinoni sui me tsaria: “Asei moa aia ti ke pelea na mane iani se na tauna sauba nomoa ke mate.” ");
INSERT INTO gri_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma Isaak e tsuka mutsa tana kao ia, mi tana ngalitupa nogo ia maia e tsurivia nina uta me adia kesa sangatu liusia na dangana na omea aia e tsukâ, rongona na Taovia e vangalaka vania. ");
INSERT INTO gri_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ma nina omea levolevo ara pabo babâ poi aia e tamanigira danga sosongo na omea. ");
INSERT INTO gri_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Mi tana rongona nogo aia e tamanigira danga sosongo nina sipi ma na buluka, mara danga goto nina maneaqo, ti igira na Pilistia ara gini masugu vania. ");
INSERT INTO gri_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Me vaga ia, migira ara tû mara munugira sui pipi na tuvu igira nina maneaqo a Abraham na tamana ara tsaigira tana tagu a Abraham e mamauri moa. ");
INSERT INTO gri_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Mi muri ma Abimelek e tsarivania a Isaak, “Ko baligi tania na veramami. Igoe o susuliga liusigami nogo igami.” ");
INSERT INTO gri_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Me vaga ia ma Isaak e mololea i tana me ba vaturikaea nina valepolo tana Qou ni Gerar, me totu tetelo moa i tana. ");
INSERT INTO gri_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Maia e tsaivisugira tugua na tuvu ara tsaigira nogo tana taguna a Abraham migira na Pilistia ara munu kapusigira i murina na mateana a Abraham. Maia Isaak e molovanigira tugua na tuvu igira na soaqira vaga nogo na tamana e molovanigira tana idana. ");
INSERT INTO gri_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Migira nina maneaqo a Isaak ara tsaigotoa kesa na tuvu tana qou ia mara tsodoa na kô. ");
INSERT INTO gri_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Migira na mane reitutugu sipi ni Gerar ara vaiganigi kolugira nina mane reitutugu sipi a Isaak mara tsaria, “Nimami kô gami iani.” Maia Isaak e soaginia na tuvu ia “Vaiganigi.” ");
INSERT INTO gri_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Migira nina maneaqo a Isaak ara tsaigotoa kesa na tuvu segeni goto, me laba goto kesa na vaiganigi tana rongona na tuvu ia, ma Isaak e soaginia “Vaigalagi.” ");
INSERT INTO gri_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Maia e mololea i tana me ba tsaia kesa na tuvu tavosi. Ma na tuvu ia e tau laba sa vaiganigi tana rongona, te aia e soaginia “Mangamanga.” Me tsaria, “Kalina ia na Taovia e sauvanigita na nauna mangasâ gana i tana ka totu, migita sauba ka tamani omea danga ieni.” ");
INSERT INTO gri_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ma Isaak e mololea i tana me vano i Beerseba. ");
INSERT INTO gri_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mi tana bongi ia, ma na Taovia e labavania me tsaria, “Inau nina God a Abraham na tamamu. Ko laka na matagu; inau nogo au totu kolugo. Me sauba kau vangalaka vanigo ma kau sauvanigo kara danga na kukuamu rongona niqu veke au naunogoa vania a Abraham niqu maneaqo.” ");
INSERT INTO gri_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ma Isaak e logoa kesa na belatabu i tana me samasama vania na Taovia. Me vaturia nina valepolo me totu i tana, migira nina maneaqo ara tsaigotoa kesa na tuvu i tana. ");
INSERT INTO gri_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Me kesa dani ma Abimelek e tû i Gerar kolukaira a Ahusat nina mane na sauparovata ma Pikol niqira taovia tagao nina mane vaumate, mara tu mai na reiana a Isaak. ");
INSERT INTO gri_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ma Isaak e veisuatugira, “?Rongona gua ti amu tu mai i koniqu inau kalina ia, mi tugamu amu tu tau nogo dou vaniau inau tana idana, mamu tu tsialigiau tania tu veramui?” ");
INSERT INTO gri_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mi tugira ara tu gokovisu mara tu tsaria, “I tugami ami tu donaginia kalina ia laka God e totu kolugo igoe, mami tu padâ laka ke dou ti vaga i tugita ka tu naua kesa na tabesai. I tugami ami tu ngaoa igoe ko vekea ");
INSERT INTO gri_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","laka sauba e utu ko sekoligami, vaga nogo igami ami tau sekoligo igoe. Igami ami dou vanigo igoe i votangana, mami tamivanigo ko mololea na veramami tana rago. Mi kalina ia e maka vanigami laka na Taovia e vangalaka sosongo vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Mi tana, ma Isaak e vangaraua tu gaqira, mi tugira ara tu mutsa mara tu inu. ");
INSERT INTO gri_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mi tana matsaraka bongibongi na dani ngana mi tugira sui tatasa ara tu aqosia tu niqira vekesai mara tu kakaisiginia na vatsa. Mi muri ma Isaak e vailivutugira, mara tu vano tana rago. ");
INSERT INTO gri_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mi tana dani nogo ia, migira nina maneaqo a Isaak ara mai i konina mara tsarivania tana rongona na tuvu igira ara vasini moa tsaia, “Igami ami tsodonogoa na kô.” ");
INSERT INTO gri_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Maia e soaginia na tuvu ia “Veke.” Aia nogo e vaga te na verabau ni Beerseba e tamanina na soana. ");
INSERT INTO gri_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mi kalina a Esau e vati sangavulu na ngalitupana, maia e taugakaira ruka na baka daki na Het, aia ko Judit na dalena a Beeri, ma ko Basemat na dalena a Elon. ");
INSERT INTO gri_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Mi kaira ara ka seko sosongo vanikaira a Isaak ma ko Rebeka. ");
INSERT INTO gri_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Mi kalina a Isaak e tuqatuqa nogo me koko na matana, maia e soamaia a Esau na dalena botsa ida me tsarivania, “!Dalequ!” Ma Esau e tsaria, “Eo, inau ieni!” ");
INSERT INTO gri_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma Isaak e tsarivania, “Igoe o reinogoa laka inau au tuqatuqa sosongo nogo, me varangi nogo kau mate. ");
INSERT INTO gri_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Bâ, igoe ko adia nimu parige ma nimu pipili, mo ko ba vanasimai vaniau sa omea tuavati. ");
INSERT INTO gri_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mo ko magovosi vaniau visana mutsa igoe o dona inau au ganingao sosongolia, mo ko adimai vaniau ieni. Mi murina kalina kau mutsa sui, minau kau tabugo talu ti kau mate.” ");
INSERT INTO gri_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mi kalina a Isaak e gogoko moa vania a Esau, maia ko Rebeka e totu me rorongovata. Mi kalina a Esau e vano na rugu, ");
INSERT INTO gri_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ma ko Rebeka e bâ me tsarivania a Jakob, “Au vasini rongomia moa na tamamu e tsarivaganana iani vania a Esau, ");
INSERT INTO gri_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ko vano mo ko adimai vaniau inau kesa na omea tuavati mo ko magovosi vaniau. Mi murina kalina kau mutsa sui, minau sauba kau tabugo i matana na Taovia ti kau mate.’ ” ");
INSERT INTO gri_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Me goko babâ moa ko Rebeka me tsaria, “Mi kalina ia dalequ, ko rongomiau inau mo ko naua moa na omea kau tsaria. ");
INSERT INTO gri_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ko vano tana bara mo ko vilikaira ruka na naniqoti vaolu papaquru, rongona kau gini kukikaira ma kau aqosivania na tamamu visana mutsa vaga aia e ganingao sosongolia. ");
INSERT INTO gri_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Migoe ko adiba vania me ke gania, maia ke gini tabugo talu ti ke mate.” ");
INSERT INTO gri_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Jakob e tsarivania tinana, “Igoe o dona nogo laka a Esau aia na mane vuvuluga sosongo, minau e madao lê na kokoraqu. ");
INSERT INTO gri_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tau utu ti ke peleau na tamaqu me ke tapogadovia laka inau au peroa; mi tana nauvaganana ia inau sauba kau alomai vaniau segeni nina vealagi na tamaqu me tau nina tabu.” ");
INSERT INTO gri_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma na tinana e tsarivania, “Dalequ, ti vaga na vealagi, moloa moa ke gadoviau inau; migoe ko naua moa na omea inau au tsarivanigo, mo ko vano mo ko adimai vaniau kara ka ruka na naniqoti.” ");
INSERT INTO gri_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Mi tana ma Jakob e vano me adimaikaira ruka na naniqoti me saukaira vania na tinana, ma na tinana e vangaraua na vatana mutsa vaga e ganingao sosongolia a Isaak. ");
INSERT INTO gri_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Mi muri, maia ko Rebeka e adia nina polo dou sosongo a Esau, aia e mololakanogoa i vale, me sagelivania a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Me mologotoa na kokorana na naniqoti tana limana mi tana liona i tana e madao lê. ");
INSERT INTO gri_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Maia e sauvania a Jakob na mutsa ganidou kolugotoa na bredi aia e bulonogoa. ");
INSERT INTO gri_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ma Jakob e bâ i konina tamana me tsarivania, “!Mama!” Ma Isaak e tsaria, “Eo. ?Asei ka vidaqira na dalequ igoe?” ");
INSERT INTO gri_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ma Jakob e tuguvisua me tsaria, “Inau a Esau na dalemu botsa ida; mau naunogoa na omea igoe o ketsaliginiau. Ko totu tsau kiki mo ko gania visana na velesina sabo inau au adimaia vanigo, rongona ko gini tabuau.” ");
INSERT INTO gri_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma Isaak e tsaria, “?O naukoeguani sagatâ ti o tsaku sosongo vaga ia dalequ?” Ma Jakob e tuguvisua me tsaria, “Na Taovia nimu God aia nogo e sangaau na ruguviana.” ");
INSERT INTO gri_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ma Isaak e tsarivania a Jakob, “Ko mai varangi kiki rongona inau kau gini pelego. ?Laka e Esau manana nomoa igoe?” ");
INSERT INTO gri_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ma Jakob e ratsumai konina na tamana, maia e tapoa me tsarivania, “Nimu goko igoe e tatangi vaga moa nina goko a Jakob, ma na limamu e vaga moa na tatapona na limana a Esau.” ");
INSERT INTO gri_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ma Isaak e tau tapogadovia a Jakob, rongona na limana aia e vuvuluga vaga moa na limana a Esau. Maia e vangarau nogo laka ke tabua, ");
INSERT INTO gri_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","me veisuâ tugua, “?Laka a Esau manana nomoa igoe?” Ma Jakob e tsarivania, “Eo, inau nogoria.” ");
INSERT INTO gri_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ma Isaak e tsaria, “Ko adimai vaniau visana na velesina sabo. Mi murina kalina kau mutsa sui minau sauba kau tabugo.” Ma Jakob e adimai vania gana velesi, me adimaigotoa na uaeni gana ke inu. ");
INSERT INTO gri_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mi muri, ma na tamana e tsarivania, “Dalequ, ko mai varangi mo ko domiau inau.” ");
INSERT INTO gri_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Mi kalina aia e mai varangi me domia, ma Isaak e siginia na polona, me tabua me tsaria, “Na douna na siginina na dalequ e vaga moa na siginina na uta aia na Taovia e tabua. ");
INSERT INTO gri_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","!Maia God ke molotsuna mai na kolobu talumai i gotu me ke malobusia nimu uta, ma kara dato magobu dou sui nimu omea tsukatsuka! !Aia ke sauvanigo ke danga na mutsa ma na uaeni! ");
INSERT INTO gri_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Migira na puku tavosi kara lia nimu maneaqo, ma kara tsuporu tsuna i matamu igoe. Migoe ko tagaovi kaputigira sui na kamamu, migira na kukuana na tinamu kara tsuporu tsuna i matamu. Migira kara vealaginigo igoe sauba ke gadovigira na vealagi, migira kara soadougo igoe sauba kara soadougira.” ");
INSERT INTO gri_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mi kalina tsotsodo a Isaak e tabu suinogoa a Jakob, ma Jakob e vasini moa e mololea a Isaak, maia Esau na kulana e visumai na rugu. ");
INSERT INTO gri_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ma Esau e magovosigotoa visana na mutsa ganidou me adi bâ vania na tamana. Me tsarivania, “Kiki mama, ko totu tsau mo ko gania visana na velesina sabo inau au adimaia vanigo, rongona igoe ko gini tabuau inau.” ");
INSERT INTO gri_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ma Isaak e veisuâ, “?Masei goto igoe?” Ma Esau e tuguvisua me tsaria, “Inau nogoria a Esau na dalemu botsaida.” ");
INSERT INTO gri_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mi tana ma Isaak e tuturiga na gagariri na kokorana popono me veisuâ, “?Laka asei aia e matesinogoa gaqu omea tuavati inau me adimaia vaniau? Au ganinogoa inau ti o sagemai igoe. Minau au tabusuinogoa, me vaga ia ma na tabu ia nina saviliu nogo aia.” ");
INSERT INTO gri_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mi kalina a Esau e rongomi vaganana ia, maia e padasavi loki sosongo me ngangai dato me tsaria, “!Mama, ko tabuau goto inau!” ");
INSERT INTO gri_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma Isaak e tsarivania, “Na kulamu nogo igoe e mai me perobulesiau inau. Maia e adiligitanigo nogo nimu tabu.” ");
INSERT INTO gri_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ma Esau e tsaria, “Iani nogo na rukanina kalina aia e peqoau inau. Aia nogoria na rongona ti ara soaginia a Jakob. Aia e adiligi taniau nogo gaqu susuliga vaga na baka botsaida, mi kalina ia maia e adiligitaniau gotoa niqu tabu. ?Egua, laka o tau goto molovisua sa tabu vaniau inau?” ");
INSERT INTO gri_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ma Isaak e gokovisu vania me tsaria, “Inau au molonogoa aia ke taovia vanigo igoe, mau mologira sui na kamana kara tseka vania. Au sauvaninogoa aia na mutsa ma na uaeni. !Mi kalina ia dalequ, e tagara goto sa omea tangomana kau sauvanigo igoe!” ");
INSERT INTO gri_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma Esau e totu matengana moa na amitsai vaniana na tamana me tsaria: “?Laka e kesa moa na tabu o tamani igoe? !Mama, ko tabuau goto inau!” Maia e tuturiga na ngangai. ");
INSERT INTO gri_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mi tana ma Isaak e tsarivania, “E tagara sa kolobu ke talu i baragata vanigo igoe, me tagara goto sa nimu uta ke dato magobu dou. ");
INSERT INTO gri_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Migoe sauba ko gini mauri nimu isi, me sauba ko lia moa nina tseka na kulamu. Me atsa moa e vaga, migoe kalina ko piloligi tania, me sauba igoe ko tangomana na tsidavaginiana nina tagao.” ");
INSERT INTO gri_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Me tû tana dani ia, ma Esau e reisavi sosongolia a Jakob, rongona na tamana e sauvaninogoa a Jakob na tabu. Maia e pada segenina, “Na taguna na tangitangi matena na mateana na tamaqu e mai varangi nogo; mi muri ti kau labumatesia a Jakob.” ");
INSERT INTO gri_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mi kalina ko Rebeka e rongomia na omea e vangaraua a Esau na nauana, maia e soâ a Jakob me tsarivania, “Ko rorongo igoe, aia Esau na kulamu e ngaoa na tangotugu ma na labumatesiamu igoe. ");
INSERT INTO gri_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Bâ, dalequ, kalina ia ko naua moa na omea kau tsarivanigo. Igoe ko vano tsaku i konina a Laban na tasiqu inau i Haran, ");
INSERT INTO gri_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","mo ko totu kolua i tana poi tsau ke bisi na tobana kulamu, ");
INSERT INTO gri_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","me ke padalenogoa na omea igoe o nauvania. Mi tana ti inau kau moloa ke kesa ke bâ me ke dulikolu visumaigo. ?Na rongona gua goto kara ka nanga sui taniau kaira sui na dalequ i laona kesa moa na dani?” ");
INSERT INTO gri_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ma ko Rebeka e tsarivania a Isaak, “Inau au qisi sosongo nogo na reiana ka niqira omeomea kaira na daki ni Het karani aia Esau e taugakaira. Me ti vaga a Jakob ke taugâ ke kesa na daki ni Het vaga karani, me dou bâ kau mate nogo inau ti ke laba na omea vaga ia.” ");
INSERT INTO gri_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ma Isaak e soâ a Jakob, me soadoua me tsarivania, “Ko laka na taugaana sa daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ko vano i Mesopotamia tana verana a Betuel na tutuamu mo ko taugâ sa baka daki ni tana, ke kesa na dalena a Laban nimu pupu. ");
INSERT INTO gri_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","!Maia God Susuliga Sosongo ke tabua nimu tauga me ke sauvanigo ke danga na dalemu, rongona igoe ko gini lia na tamaqira na puku danga! ");
INSERT INTO gri_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","!Maia ke vangalaka vanigo igoe migira na kukuamu vaga nogo aia e vangalaka vania a Abraham, migoe ko aditamanimu na kao iani i tana nogo igoe o tototu, aia nogo na kao God e sauvaninogoa a Abraham!” ");
INSERT INTO gri_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ma Isaak e molovanoa a Jakob i Mesopotamia i konina a Laban, aia na dalena a Betuel ni Aram ma na tasina ko Rebeka ka tinaqira a Jakob ma Esau. ");
INSERT INTO gri_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ma Esau e rongomia laka a Isaak e tabua a Jakob me molovanoa i Mesopotamia ke lave tauna. Maia e rongomigotoa laka kalina a Isaak e tabua me tongovania ke laka na taugaana sa daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Maia e tsodovulagia laka a Jakob e rongo ka mangaqira kaira na tamana ma na tinana me vano nogo i Mesopotamia. ");
INSERT INTO gri_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Mi tana ma Esau e padagadovia laka a Isaak na tamana e tau reingaogira na daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Maia e tû me vano i konina a Ismael na dalena a Abraham me ba taugâ ko Mahalat aia na dalena a Ismael ma na tasina a Nebaiot. ");
INSERT INTO gri_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","A Jakob e mololea i Beerseba me vano kalea i Haran. ");
INSERT INTO gri_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Mi kalina e sû nogo na aso, maia e mailaba kesa tana nauna tabu, me mango tana. Maia e tsaro me lulunga kesa tana vatu me maturu. ");
INSERT INTO gri_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Maia e bolea laka e reia kesa na lata e tû i barangengo me tsau bâ i baragata, migira na angelo ara tsutsuna dato i konina. ");
INSERT INTO gri_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma na Taovia e mai tû i ligisana me tsarivania, “Inau na Taovia, ka niqira God a Abraham ma Isaak. Minau sauba kau sauvanigo igoe migira na kukuamu na kao iani i tana igoe o tsatsaro kalina ia. ");
INSERT INTO gri_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Migira sauba kara danga vaga nogo na papasa tana barangengo. Migira sauba kara ratsua niqira butona kao ke tû i longa me ke tsau i tasi, me ke tû i vava me ke tsau bâ i ata, mi tana soamu igoe migira goto na kukuamu ti inau sauba kau vangalaka vanigira na puku sui tana barangengo popono. ");
INSERT INTO gri_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ko pada kalavatavia laka inau sauba kau totu kolugo ma kau reitutugugo iava moa tana ko vano, minau sauba kau adivisugo mai tugua tana kao iani. Me sauba e utu kau mololego poi kau naugira sui na omea au vekenogoa vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ma Jakob e mamata me tsaria, “!Na Taovia e totu ieni! !Aia e totu tana nauna iani minau moa au tau donaginia!” ");
INSERT INTO gri_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Maia e matagu me tsaria, “!Na nauna mataguniga sosongo tana nauna ieni! E tau utu na valena manana nomoa God ieni; ma na matsapa e sangavi bâ i baragata.” ");
INSERT INTO gri_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ma Jakob e mamata bongibongi na matsaraka na dani ngana, me adia na vatu aia e gini lulunga, me turuvaginikaea i tana vaga na padapada, me qetu bâ na oela na olive i konina. ");
INSERT INTO gri_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Me soaginia na nauna ia i Betel. Na vera ia tana idana ara soaginia i Lus. ");
INSERT INTO gri_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Mi muri, ma Jakob e naua kesa na veke vania na Taovia me tsaria: “Ti vaga igoe ko totu koluau manana mo ko reitutuguau tana sautu i tana au liu bâ, mo ko sauvaniau gaqu mutsa ma na poloqu, ");
INSERT INTO gri_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","me ti vaga kau visumai dou tugua tana valena tamaqu, mi tana ti igoe sauba ko lia niqu God. ");
INSERT INTO gri_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Miani na vatu au turuvaginikaea inau vaga na padapada sauba ke lia na nauna gana na samasama vanigo, minau sauba kau sauvanigo na sangavulunina turina pipi sui na omea igoe o sauvaniau.” ");
INSERT INTO gri_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Mi muri, ma Jakob e tû me liu babâ moa i sautu, me vano kalea tana niqira butona kao igira na tinoni ni Longa. ");
INSERT INTO gri_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Me tavongani morosia kesa na tuvu i laona na poiatsa, mara tolu na alaala na sipi ara tsaro polipolia. Mi tana tuvu ia i tana nogo ara tore gaqira kô igira na sipi, me totu kesa na vatu loki tana mangana. ");
INSERT INTO gri_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mi kalina kara maisai igira sui na alaala na sipi, mi tana ti igira na mane pitusipi kara keliligia na vatu ia ma kara sao gaqira kô. Mi muri, ma kara molovisutugua na vatu ia tana mangana na tuvu. ");
INSERT INTO gri_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ma Jakob e veisuagira na mane reitutugu sipi, “?Kulaqu igamu, iava vaga amu talumai igamu?” Migira ara tsaria, “I Haran.” ");
INSERT INTO gri_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Maia e veisuagira goto, “?Egua, laka amu donaginia a Laban na dalena a Nahor igamu?” Migira ara tsaria, “Eo, igami ami donaginia.” ");
INSERT INTO gri_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Maia e veisuagira, “?Laka aia e mamauri dou?” Migira ara tsarivania, “Eo, e mauri dou moa. Ko morosi bâ e maimai nogo ko Ratsel aia na dalena nogo a Laban kolugira nina sipi.” ");
INSERT INTO gri_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ma Jakob e tsaria, “?Me dadani dou moa me tau moa vati tsau na taguna na adivisuaqira na sipi tana bara, me rongona gua ti amu tau saogaqira kô kalina ia, ma kamu adivisugira tugua tana nauna tana kara mutsamutsa?” ");
INSERT INTO gri_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Migira ara tuguvisua mara tsaria, “E utu kami nauvaganana ia poi kara labamai ieni pipi sui na alaala na sipi ma kara keliligia na vatu ia; mi tana moa ti igami kami saogaqira kô na sipi.” ");
INSERT INTO gri_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mi kalina a Jakob e gogoko moa kolugira moa igira, maia ko Ratsel e mailaba kolugira nina sipi. ");
INSERT INTO gri_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mi kalina a Jakob e morosia ko Ratsel kolugira nina sipi a Laban na niana, aia e bâ tana tuvu me keliligia na vatu me saogaqira kô nina sipi. ");
INSERT INTO gri_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Mi muri maia e domia ko Ratsel me tuturiga na ngangai tana magemage. ");
INSERT INTO gri_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Maia e tsarivania ko Ratsel, “Inau na kamana na tamamu, na dalena ko Rebeka.” Maia ko Ratsel e ulovisu me ba tsarivulagia vania na tamana; ");
INSERT INTO gri_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","mi kalina a Laban e rongomia na turupatuna tana rongona a Jakob na niana, maia e ulo me ba tsodoa, me kasoa me domia me adivanoa i valena. Mi kalina a Jakob e turupatu vania a Laban pipi na omea ara laba, ");
INSERT INTO gri_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","maia Laban e tsaria, “Eo, manana, igoe na gabuqu segeni nogo inau.” Ma Jakob e totu kolugira i tana kesa na vula popono. ");
INSERT INTO gri_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ma Laban e tsarivania a Jakob, “Me atsa moa igoe na kamaqu inau, me tau dou ko aqo lê vaniau moa. ?Ke visa na vovolimu o ngaoa?” ");
INSERT INTO gri_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ma Laban e tamanikaira ruka na dalena daki: na idana aia ko Lea, ma na tumurina aia ko Ratsel. ");
INSERT INTO gri_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ma na matana ko Lea e rerei dou rago, maia ko Ratsel e magobu dou na kokorana me rereidou bâ. ");
INSERT INTO gri_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ma Jakob e ngao sosongolia ko Ratsel me tsarivania a Laban, “Eo, inau sauba kau aqo vanigo ke vitu na ngalitupa, ti vaga igoe ko tamivaniau inau kau taugâ ko Ratsel.” ");
INSERT INTO gri_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ma Laban e tsarivania, “E dou bâ ti vaga kau saua ko Ratsel vanigo igoe liusia bâ kau sauvania ke kesa na mane segeni; migoe e dou ko totu koluau inau ieni.” ");
INSERT INTO gri_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ma Jakob e aqosage matena ko Ratsel i laona e vitu na ngalitupa, ma na vitu ngalitupa ia e vaga moa ti e ruka se tolu moa na dani vania a Jakob rongona aia e ngao sosongolia ko Ratsel. ");
INSERT INTO gri_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mi kalina e tovunogoa e vitu na ngalitupa ma Jakob e tsarivania a Laban, “E tsau nogo na tagu. Ko tamivaniau ma kau taugâ na dalemu.” ");
INSERT INTO gri_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Mi tana ma Laban e aqosia kesa na kavomutsa na tauga, me soamaigira na tinoni sui tana vera ia. ");
INSERT INTO gri_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mi tana bongi ia, ma Laban e tau adi bâ ko Ratsel vania a Jakob, maia e adi bâ ko Lea, maia Jakob e maturu kolua. ");
INSERT INTO gri_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Maia Laban e saua ko Silpa nina daki tseka ke aqo vania ko Lea na dalena. ");
INSERT INTO gri_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mi tana matsaraka moa ti a Jakob e vasini reigadovia laka e maturu kolua ko Lea. Maia e vano i konina a Laban me tsarivania, “?Rongona gua ti o nauvaganana vaniau inau? Inau au aqo vanigo gana kau adiginia ko Ratsel. ?Me rongona gua ti o perobulesiau inau?” ");
INSERT INTO gri_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ma Laban e tuguvisua me tsaria, “E tau na lavu tana vera iani na sau taluana na baka botsa tumuri ke ida ke taugâ, mi muri ti ke tauga na baka botsa ida. ");
INSERT INTO gri_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ko pipitu poi ke sui talu na taguna na kavomutsa na tauga iani me sauba kau sauvanigo goto ko Ratsel, ti vaga igoe ko aqo vaniau ke vitu goto na ngalitupa.” ");
INSERT INTO gri_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ma Jakob e tabea, mi kalina e sui na taguna na kavomutsa na tauga ia, ma Laban e saugotoa ko Ratsel vania a Jakob ke lia na tauna. ");
INSERT INTO gri_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma Laban e saua ko Bilha nina daki tseka ke aqo vania ko Ratsel na dalena. ");
INSERT INTO gri_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Maia Jakob e maturu kolugotoa ko Ratsel. Me galuve sosongolia bâ ko Ratsel liusia ko Lea. Mi muri maia e aqo vania a Laban vitu goto na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mi kalina na Taovia e morosia laka a Jakob e galuve sosongolia bâ ko Ratsel liusia ko Lea, maia e sangavia na tobana ko Lea ke gini tamani baka me molovania ko Ratsel ke totu mamane. ");
INSERT INTO gri_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ma ko Lea e tiana me vasua kesa na baka mane. Maia e tsaria, “Na Taovia e reia niqu rota, mi kalina ia ti na savaqu sauba ke galuveau inau”; aia nogoria na rongona te e soaginia na baka ia a Ruben. ");
INSERT INTO gri_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Maia e tiana tugua me vasua kesa goto na dalena mane. Me tsaria, “Na Taovia e sauvaniau goto na dalequ mane iani, rongona aia e rongomia laka e reisaviau na savaqu”; maia e soaginia na baka ia a Simeon. ");
INSERT INTO gri_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Maia e tiana tugua me vasugotoa kesa na dalena mane. Me tsaria, “Mi kalina ia, sauba na savaqu ke totukakai dou bâ i koniqu, rongona au vasuvania tolu nogo na dalena mane”; maia e soaginia na baka ia a Levi. ");
INSERT INTO gri_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mi muri, maia e tiana tugua me vasugotoa kesa na dalena mane. Me tsaria, “Mi kalina ia inau sauba kau tsonikaea na Taovia”; maia e soaginia na baka ia a Juda. Mi tana, maia ko Lea e mango na tamani dalena. ");
INSERT INTO gri_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Maia ko Ratsel e tau goto vasua sa baka vania a Jakob, me vaga ia maia e masugu vania na tasina me tsarivania a Jakob, “Ko molovaniau sa dalequ, me ti vaga ke tagara minau sauba kau mate.” ");
INSERT INTO gri_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ma Jakob e kore vania ko Ratsel me tsarivania, “Inau e utu kau adia na sasana God. Aia nogo e naua te o gini tau vasua sa dalemu.” ");
INSERT INTO gri_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ma ko Ratsel e tsaria, “Ko adia moa ko Bilha niqu daki tseka; mo ko maturu kolua, rongona ke gini tamani dalena vaniau inau. Mi tana nauvaganana ia ti inau kau gini lia na tinana na baka ke talu i konina aia.” ");
INSERT INTO gri_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Me vaga ia, maia e saua ko Bilha vania a Jakob na savana, maia e maturu kolua. ");
INSERT INTO gri_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma ko Bilha e tiana me vasuvania a Jakob kesa na dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ma Ratsel e tsaria, “God e pede tabana i koniqu inau, me rongomigotoa niqu nonginongi, me sauvaniau kesa na dalequ mane”; maia e soaginia a Dan. ");
INSERT INTO gri_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ma ko Bilha e tiana tugua me vasugotoa vania a Jakob na rukanina dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma ko Ratsel e tsaria, “Inau au tovokakaia na tuliusiana na kulaqu, minau au tangomana”; maia e soaginia na baka ia a Naptali. ");
INSERT INTO gri_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mi kalina ko Lea e reia laka e mango nogo na tamani dalena, maia e saugotoa ko Silpa nina daki tseka vania a Jakob ke lia goto na tauna. ");
INSERT INTO gri_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mi muri ma ko Silpa e vasuvania a Jakob kesa na dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Me tsaria ko Lea, “Au tangomana manana”; maia e soaginia na baka ia a Gad. ");
INSERT INTO gri_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ma ko Silpa e vasutugua kesa na dalena mane vania a Jakob, ");
INSERT INTO gri_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","me tsaria ko Lea, “!Inau au mage sosongo! Mi kalina ia igira na daki kara soaginiau mage”; maia e soaginia na baka ia a Aser. ");
INSERT INTO gri_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mi tana tagu kalina e raranga na uiti maia Ruben e vano tana uta me ba reigira visana na vuana na “mandrake”, maia e adimaigira vania ko Lea na tinana. Ma ko Ratsel e tsarivania ko Lea, “Kiki ko tusuvaniau inau ke visana nina vuana ‘mandrake’ na dalemu.” ");
INSERT INTO gri_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma ko Lea e tsarivania, “?Laka e tau vati tugugo moa igoe o adiligi taniau nogo na savaqu? Mi kalina ia, mo ngaogotoa ko adiligigira nina vuana ‘mandrake’ na dalequ inau.” Ma ko Ratsel e tsaria, “Ti vaga igoe ko vaniau visana nina vuana ‘mandrake’ na dalemu, inau kau tamivanigo ko maturu kolua a Jakob ke bongi.” ");
INSERT INTO gri_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mi tana ngulavi ia kalina a Jakob e visumai tana uta, maia ko Lea e ba tsodoa me tsarivania, “Igoe sauba ko maturu koluau inau ke bongi, rongona inau au voliginigo nogo nina vuana ‘mandrake’ na dalequ.” Vaga ia, mi tana bongi ia ma Jakob e maturu kolua ko Lea. ");
INSERT INTO gri_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ma God e rongomia nina nonginongi ko Lea, maia e tiana tugua me vasuvania a Jakob na tsegenina dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Me tsaria ko Lea, “God e saupeluna vaniau rongona au saua niqu daki tseka vania na savaqu”; maia e soaginia a Isakar. ");
INSERT INTO gri_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ma ko Lea e tiana tugua me vasuvania a Jakob na ononina dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Maia e tsaria, “God e sauvaniau inau kesa na vangalaka dou sosongo. Mi kalina ia, sauba na savaqu ke tabedouau rongona inau au vasuvaninogoa ara ono na dalena mane”; maia e soaginia na baka ia a Sebulun. ");
INSERT INTO gri_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mi muri, maia e vasua kesa na baka daki me soaginia ko Dina. ");
INSERT INTO gri_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mi muri ma God e padatugua ko Ratsel; maia e rongomia nina nonginongi me naua me gini tangomana ke tamani dalena. ");
INSERT INTO gri_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Maia e tiana me vasua kesa na baka mane me tsaria, “God e adiligi taniau gaqu vangamâ me sauvaniau kesa na dalequ mane.” ");
INSERT INTO gri_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Maia e soaginia na baka ia a Josep me tsaria, “Ma na Taovia ke sauvaniau ke kesa goto na dalequ mane.” ");
INSERT INTO gri_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Murina na botsaana a Josep, ma Jakob e tsarivania a Laban, “Ko tamivaniau ma kau vano, rongona kau gini visutugua i veraqu. ");
INSERT INTO gri_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ko vaniau tugira na tauqu migira goto na dalequ igira inau au aqo mateqira i konimu ma kau vano. Igoe o donagininogoa laka inau au aqo dou sosongo vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ma Laban e tsarivania, “Iani kau tsaritalua inau: Inau au donagininogoa tana basutidao laka aia na Taovia e vangalaka vaniau inau tana rongomu nogo igoe. ");
INSERT INTO gri_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ko tsarimaia moa na vovolina igoe o ngaoa, minau sauba kau tusua vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma Jakob e tsarivania, “Igoe o donadou nogo laka inau au aqo kakai vanigo igoe, me laka ara pabo sosongo nimu omea tuavati kalina inau au reitutugugira. ");
INSERT INTO gri_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kalina au tau vati mai moa inau, mara tau danga nimu omea tatamani igoe, mi kalina ia ara danga manana, rongona na Taovia e vangalaka vanigo iava moa tana au vano inau. Mi kalina ia e tsau nogo na taguna i tana inau kau reitutugua na valequ segeni.” ");
INSERT INTO gri_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ma Laban e veisua tugua, “?Nagua sauba kau voliginigo?” Ma Jakob e tuguvisua me tsaria, “Inau au tau ngaoa sa vovolina. Me ti vaga igoe ko tabea niqu papada, minau sauba kau reitutugugira babâ moa nimu sipi. ");
INSERT INTO gri_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ko tamivaniau ma kau liu popono i laoqira nimu sipi ma nimu naniqoti i dani eni, ma kau vililigigira pipi na dalena sipi bau, migira na dalena naniqoti ara tuputupuga mara mamarega. Aia moa ngiti vovoliqu au ngaoa inau. ");
INSERT INTO gri_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mi tana tagu ke mai, migoe tangomana ko tsodovulagi tsakua ti vaga inau au peqogo. Mi kalina ti ko mai na morosiaqira na vovoliqu, me ti vaga ko reia ke kesa na naniqoti ke tau mamarega se ke tau tuputupuga, se ti vaga sa sipi ke tau bau, mi tana migoe sauba ko donaginia laka aia au komia.” ");
INSERT INTO gri_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ma Laban e tsaria, “Dou, inau au tabea. I kaita sauba ka ka naua na omea vaga igoe o tsaria.” ");
INSERT INTO gri_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mi tana dani nogo ia, ma Laban e vilivotagira na naniqoti mane ara putsibubutoga mara tuputupuga, migira sui goto na dakina ara mamarega mara tuputupuga se na tupu sere i koniqira; maia e vilivotagira pipi sui na sipi bau, me mologira na dalena mane kara reitutugugira. ");
INSERT INTO gri_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mi muri, maia e vanoligi tania a Jakob kolugira na turina nina omea tuavati aia e vililigigira me ba totu tana nauna e tugua na vanovano tolu na dani ti na ba tsau i tana. Maia Jakob e reitutugugira na turina nina omea tuavati a Laban. ");
INSERT INTO gri_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mi muri, ma Jakob e adigira visana na arana mamauri tolu tavosi na vatana na gai vaga na mataqa, me koratiligia na turina na kokoraqira gana ke gini mamarega sere na rereiqira. ");
INSERT INTO gri_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Maia e turuvaginigira na arana gai girani i mataqira na naniqoti ligisana niqira popo na inu. Maia e mologira i tana, rongona igira na tuavati ara vaitsauvigi kalina ara mai na inu. ");
INSERT INTO gri_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Me vaga ia, mi kalina igira na naniqoti ara mai mara vaitsauvigi i mataqira na arana gai gira, mi muri kalina ara vasusu, ma na daleqira ara putsibubutoga, mara mamarega mara tuputupuga. ");
INSERT INTO gri_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ma Jakob e molovotagira na sipi tanigira na naniqoti, me mologira kara aro bâ i koniqira nina sipi a Laban igira ara putsibubutoga mara bau. Mi tana nauvaganana ia, ma nina alaala na omea tuavati a Jakob ara pabo babâ maia e mologira kara totu tavota tanigira nina omea tuavati a Laban. ");
INSERT INTO gri_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mi kalina igira na omea tuavati mamauri dou ara vaitsauvigi, ma Jakob e mologira na arana gai i mataqira ligisana niqira popo na inu, rongona igira kara gini vaitsauvigi i laoqira na arana gai gira. ");
INSERT INTO gri_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maia e tau mologira na arana gai i mataqira na omea tuavati ara tau mauri dou. Me tau oka ma Laban e tamanigira moa na omea tuavati maluku lê, ma Jakob e tamanigira sui na omea tuavati mamauri dou. ");
INSERT INTO gri_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mi tana nauvaganana ia, ma Jakob e gini tamani omea danga sosongo. Ara danga nina naniqoti, ma nina sipi, nina tseka, nina kamelo ma nina asi. ");
INSERT INTO gri_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ma Jakob e rongomigira ara gini gogoko igira na dalena a Laban mara tsaria, “A Jakob e adigira sui nogo nina omea na tamada. Pipi nina omea sui a Jakob ara talu sui moa tana nina omea tatamani na tamada igita.” ");
INSERT INTO gri_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Maia e reigotoa laka a Laban e tau nogo dou sosongo vania vaga tana idana. ");
INSERT INTO gri_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mi muri ma na Taovia e tsarivania a Jakob, “Ko visutugua tana niqira kao na tamamu ma na kamamu. Minau sauba kau totu kolugo.” ");
INSERT INTO gri_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Me vaga ia, ma Jakob e mologoko bâ vanikaira ko Ratsel ma ko Lea kara ka mai tsodoa tana poiatsa i tana ara tototu nina omea tuavati. ");
INSERT INTO gri_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ma Jakob e tsarivanikaira, “Inau au reia ka tamamui kagamu e tau nogo dou sosongo vaniau inau vaga tana idana; maia nina God na tamaqu inau e tototu koluau moa. ");
INSERT INTO gri_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mi kagamu amu ka dona laka inau au aqo vania ka tamamui kagamu tana susuligaqu popono. ");
INSERT INTO gri_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Me atsa moa e vaga, maia e peqoau nomoa inau, me olia na vovoliqu sangavulu kalina. Ma God e tau moa tamivania ke sekoliau. ");
INSERT INTO gri_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mi kalina a Laban ke tsaria, ‘Igira na naniqoti mamarega sauba kara lia na vovolimu,’ migira sui lakalaka na naniqoti ara vasugira na daleqira mara viri mamarega sui. Mi kalina aia ke tsaria, ‘Igira na naniqoti putsibubutoga sauba kara lia na vovolimu igoe,’ mi tana, migira sui lakalaka na naniqoti ara vasugira na daleqira mara viri putsibubutoga sui. ");
INSERT INTO gri_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Me vaga ia ma God segenina nogo e adiligigira na sipi ma na naniqoti tania ka tamamui kagamu me saugira vaniau inau. ");
INSERT INTO gri_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mi tana niqira tagu na tsatsau igira, minau au bolebole mau reia laka igira sui na naniqoti mane ara tsatsau ara putsibubutoga, mara tuputupuga, mara mamarega. ");
INSERT INTO gri_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nina angelo God e goko vaniau tana bolebole ia me soaau, ‘!A Jakob igoe!’ Minau au tsaria, ‘Eo.’ ");
INSERT INTO gri_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Maia e tsaria, ‘Ko morosi bâ, pipi sui na naniqoti mane ara tsatsau igira sui ara putsibubutoga, mara tuputupuga, mara mamarega. Inau au aqosivaganana ia rongona au reigira sui nogo na omea a Laban e nauvanigo igoe. ");
INSERT INTO gri_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Inau nogo na God au laba vanigo i Betel, i tana igoe o turuvaginikaea kesa na vatu ngiti padapada mo qetu bâ na oela na olive i kelana, mo aqosia kesa na veke vaniau inau. Mi kalina ia igoe ko vangaraua na visutugua tana kao i tana igoe o botsa.’ ” ");
INSERT INTO gri_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mi kaira ko Ratsel ma ko Lea ara ka tsarivania a Jakob, “E tagara goto sa omea ke totuvisu konina ka tamamami kagami kami ka tangolidatoa. ");
INSERT INTO gri_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Maia e nauvanikagami vaga moa ti i kagami na tinonina na veratavosi. Me tsabirikagami, mi kalina ia, aia e tsonisuigira nogo ka qolomami popono kagami. ");
INSERT INTO gri_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Migira sui lakalaka na omea dou aia God e adiligia tania ka tamamami kagami igira sui ka tamanimami kagami nogo kolugira ka dalemami. Migoe ko naua moa na omea God e tsarivanigo ko naua.” ");
INSERT INTO gri_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Me vaga ia, ma Jakob e vangaraua na visutugua i konina na tamana tana kao ni Kanaan. E molokaegira na dalena ma na tauna i kelaqira na kamelo, me mologira nina omea tuavati sui kara ida, kolugira pipi sui na omea aia e adigira i Mesopotamia. ");
INSERT INTO gri_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mi tana tagu ia, ma Laban e vano na putsiligiana na ivuqira nina sipi, mi kalina a Laban e totu moa i tana, maia ko Ratsel e komigira nina titinonina na god na vale e tamanigira na tamana. ");
INSERT INTO gri_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","A Jakob e perobulesia a Laban rongona e tau tsarivania laka aia e vavano. ");
INSERT INTO gri_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aia e adigira sui pipi na omea e tamanina, me mololetsakua i tana. Me ba savu taligu tana Kô Euprates me vano kalea na kao vungavungaga tana Gilead. ");
INSERT INTO gri_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Me tolu na dani i muri, mara ba tsarivania a Laban laka a Jakob e tsogo. ");
INSERT INTO gri_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Maia e soasaigira nina mane, me ba takuvia a Jakob vitu na dani poi e ba tsaulia tana kao vungavungaga ni Gilead. ");
INSERT INTO gri_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mi tana bongi ia, ma God e labavania a Laban tana bolebole me tsarivania, “Ko parovata dou ko laka goto na nauvaniana sa omea seko a Jakob.” ");
INSERT INTO gri_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ma Jakob ma nina alaala ara vaturikaenogoa niqira valepolo i kelana kesa na vungavunga, ma Laban migira nina mane ara ba vaturikaea niqira valepolo tana kao vungavungaga ni Gilead. ");
INSERT INTO gri_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma Laban e tsarivania a Jakob, “?Rongona gua ti o perobulesiau inau mo adiligikaira na dalequ daki vaga moa ti na daki o laua tana vailabu? ");
INSERT INTO gri_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","?Rongona gua ti o perobulesiau mo tsogo mo tau tsarivulagi vaniau talu inau? Me ti vaga ko ida mo ko tsarivulagi talua vaniau, me tau utu inau kau molovanogo igoe tana magemage ma na lingelinge kolua na rekesi tsetsê ma na itai tatangi. ");
INSERT INTO gri_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Mo tau goto tamivaniau kau domigira ma kau vailivugira talu na tutuaqu ma na dalequ. !Na omea bubulega sosongo nomoa igoe o naua! ");
INSERT INTO gri_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Inau au tamani na susuliga kau nauvanigo moa na omea au padâ, me rongona moa i bongi e mailaba vaniau nina God na tamamu maia e parovataviau kau tau goto nauvanigo sa omea seko. ");
INSERT INTO gri_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Inau au dona nogo laka igoe o vano rongona o ngao sosongolia na visu i veramu. ?Eo, me rongona gua ti igoe o komigira niqu titinonina na god na valequ inau?” ");
INSERT INTO gri_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ma Jakob e tuguvisua me tsaria, “Inau au matagu, rongona au padâ laka sauba igoe ko adiligikaira na dalemu daki taniau. ");
INSERT INTO gri_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mi kalina ia, ti vaga igoe ko tsodoa ke kesa ieni ke tamanigira nimu titinoni, maia sauba ke mate. Mieni nogo i mataqira ka nida tinoni kaita, ko lavea ti ko reia ke kesa na omea o tamanina igoe mo ko adivisua.” Ma Jakob e tau dona laka ko Ratsel nogo e komigira na titinonina nina god a Laban. ");
INSERT INTO gri_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ma Laban e lalave i laona nina valepolo a Jakob; mi muri me vano i laona nina valepolo ko Lea, mi laona ka niqira valepolo goto kaira ruka na daki tseka, me tau goto reigira na titinonina nina god. Mi muri, maia e ba goto i laona nina valepolo ko Ratsel. ");
INSERT INTO gri_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maia ko Ratsel e adigira na titinoni god igira me mologira i laona na lapa gana na totu tana kamelo me totuvatavigira. Ma Laban e lalave popono i laona nina valepolo ia, me tau goto reigira. ");
INSERT INTO gri_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma ko Ratsel e tsarivania tamana, “Ko laka kiki na kore vaniaqu taovia, inau au tau tangomana na totu tû i matamu, rongona au reivula.” Maia Laban e lalave bamai me tau goto reigira na titinonina na god ni valena. ");
INSERT INTO gri_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Mi tana ma Jakob e kore me veisuâ a Laban, “?Laka nagua seko au nauvanigo inau? ?Na ketsa gua au kutsia inau ti o gini takuviau vaga igoe? ");
INSERT INTO gri_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","?Kalina ia igoe o lalavenogoa i laoqira niqu omea popono inau, ma sa vangana gua na valemu o reia igoe? Me ti vaga ko reia sa omea mo ko molotsunamaia ieni i mataqira nimu mane igoe ma niqu mane inau, mo ko molovanigira igira kara pedea asei ka vidada kaita e goto. ");
INSERT INTO gri_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Inau au totu kolugo igoe e rukapatu nogo na ngalitupa; mi tana tagu popono ia migira nimu sipi ma nimu naniqoti ara vasusu danga bâ, minau au tau lelê gania ke kesa goto sa vidaqira na sipi mane tana nimu alaala na sipi igoe. ");
INSERT INTO gri_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Me pipi kalina ti na omea tuavati atsi ara gati matesia kesa nimu sipi, minau e gadoviau na rotana. Mau tau goto adi bâ vanigo igoe gana kau sauvulagia vanigo laka e tau niqu sasi inau. Migoe o raiau moa kau tuguvisu vanigo na omea gua moa ara komia tana dani se tana bongi. ");
INSERT INTO gri_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Me danga sosongo na tagu inau au gini rota na papara tana dani ma na bisi tana bongi, mau tau goto tangomana kau maturu. ");
INSERT INTO gri_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Aia e vaga saviliu i laona rukapatu na ngalitupa inau au totu kolugo igoe. E sangavulu vati ngalitupa inau au aqosage ka mateqira na dalemu daki karani, me ono ngalitupa inau au aqo matena nimu sipi. Me atsa moa e vaga ia, migoe o olia na vovoliqu inau sangavulu kalina. ");
INSERT INTO gri_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Me ti vaga ke tau totu koluau niqira God na tamaqu, ka niqira God a Abraham ma Isaak, me tau utu igoe ko tsialigiau lê oka nogo, me ke tagara goto sa omea kau tamanina. Ma God e morosia niqu rota ma na aqo kakai inau au naugira, mi bongi maia e goko kakai sosongo vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ma Laban e tuguvisua nina goko a Jakob me tsaria, “Na daki karani na dalequ inau; ma ka daleqira na tamaniqu inau, ma na omea tuavati sui girani na tamaniqu goto inau, migira sui na omea o reigira ieni igira sui lakalaka niqu omea nogo inau. Me rongona moa e tagara goto sa omea kau naua gana kau tangolivisukaira na dalequ daki karani ma ka daleqira, ");
INSERT INTO gri_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","minau au vangaraua moa kau aqosia kesa na tabesai kolugo igoe. Ida kaita ma ka aqosia kesa na tsupu na vatu gana ke gini molopapada vanikaita tana rongona ka nida tabesai.” ");
INSERT INTO gri_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Me vaga ia, ma Jakob e adia kesa na vatu me turuvaginikaea ngiti padapada. ");
INSERT INTO gri_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Me tsarivanigira nina mane kara adigira ke visana na vatu loki ma kara molo tsupulaginigira. Mi muri, migira ara mutsa gaqira ligisana na tsupu na vatu gira. ");
INSERT INTO gri_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ma Laban e soaginia i tana Jegar Sahaduta, maia Jakob e soaginia Galeed. ");
INSERT INTO gri_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Maia Laban e tsarivania a Jakob, “Na tsupu na vatu iani sauba ke ngiti papada vanikaita.” Aia nogo na rongona ti na nauna ia ara soaginia i Galeed. ");
INSERT INTO gri_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ma Laban e tsarigotoa, “Na Taovia ke matanikaita kalina kaita ka tavota.” Me vaga ia, ma na nauna i tana ara soaginigotoa i Mispa. ");
INSERT INTO gri_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ma Laban e goko babâ me tsaria, “Ti vaga igoe ko tau galuvedoukaira na dalequ daki karani, se ko taugâ ke visana segeni daki, atsa moa kau tau morosigo inau, mo ko padatugua moa laka God e matanikaita. ");
INSERT INTO gri_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Igirani nogo na vatu inau au molo tsupulaginigira ka levugada kaita, miani goto na vatu igoe o turuvaginikaea ngiti papadana. ");
INSERT INTO gri_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","I karani sui na tsupu na vatu ma na vatu papadana kara totu ngiti padapada vanikaita. Inau sauba e utu saikesa vaniau kau liusia na tsupu na vatu iani ma kau baginigo igoe, me vaga goto igoe, ko laka goto na liusiana na vatu papadana iani mo ko maiginiau inau. ");
INSERT INTO gri_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nina God a Abraham ma nina God a Nahor sauba ke votagoko ka levugada kaita.” Mi tana, ma Jakob e vatsa tana asana na God aia Isaak na tamana e samasama vania, laka aia sauba ke manalia na veke ia. ");
INSERT INTO gri_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Me tû me matesia kesa na omea tuavati, me savoria ngiti kodoputsa tana vungavunga ia, me soamaigira nina mane kara mai sanga tana mutsa. Mi murina kalina ara mutsa sui, migira ara maturu i kelana na vungavunga tana bongi ia. ");
INSERT INTO gri_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mi tana matsaraka bongibongi na dani ngana, ma Laban e domigira me vailivugira na tutuana mi kaira na dalena daki, maia e tû me visu i verana. ");
INSERT INTO gri_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mi kalina a Jakob e vavano moa i sautu, mara visana na angelo ara mai na tsodoana. ");
INSERT INTO gri_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mi kalina a Jakob e reigira maia e tsaria, “Tana nauna nogo ieni e tototu na Taovia”; maia e soaginia tana nauna ia i Mahanaim. ");
INSERT INTO gri_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ma Jakob e molovanogira visana na mane adigoko kara ida vania na ba tsodoana a Esau na kulana tana butona kao ni Edom. ");
INSERT INTO gri_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Maia e tsarivanigira kara tsari vaganana iani vania a Esau, “Inau a Jakob nimu maneaqo, au mai na tsarivulagiana vanigo a Esau gaqu taovia laka inau au tototu kolua a Laban, maia nogoria na rongona ti au gini oka sosongo na visumai poi e tsau kalina ia. ");
INSERT INTO gri_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Inau au tamanigira na buluka, na asi, na sipi, na naniqoti, ma na tseka. Minau au mologoko ba vanigo taovia gana ke gini visu papadamu mo ko soalakaau tugua.” ");
INSERT INTO gri_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mi kalina ara visumai igira na mane adigoko, mara ba tsarivania a Jakob, “Igami ami bâ i konina a Esau na kulamu, maia e maimai nogo i sautu na valaleamu igoe. Mara dulikolumaia ara vati sangatu na mane.” ");
INSERT INTO gri_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mi tana, ma Jakob e boe sosongo me matagu. Maia e tû me votaruka igira na tinoni ara dulikolua, me nauvaganana vanigira goto nina sipi, ma nina naniqoti, nina buluka ma nina kamelo. ");
INSERT INTO gri_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Maia e padasegenina, “Ti vaga a Esau ke mai me ke baginia na kesanina alaala, me kesa alaala tangomana kara tsogo.” ");
INSERT INTO gri_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mi muri ma Jakob e nonginongi, “!Igoe nina God a Abraham na tutuaqu, ma nina God a Isaak na tamaqu, ko rongomiau inau! Taovia igoe nogo o tsarivaniau kau visutugua tana niqu kao mi tana niqira kao na kamaqu, me laka igoe sauba ko naua me pipi sui na omea kara vano dou vaniau. ");
INSERT INTO gri_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Inau nimu maneaqo moa, me tau ulagaqu nimu galuve ma nimu doulaka o sauvulagi vaniau. Tana idana kalina au savu taligu tana Kô Jordan, me kesa lelê moa na itoro au tangolia me tagara goto sa omea tavosi. Mi kalina eni, minau au visumai kolukaira ruka na alaala loki karani. ");
INSERT INTO gri_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Inau au nongigo ko maurisiau tania na limana a Esau na kulaqu. Inau au matagu, au matagu ke tau mai rongona ke maiginigami me ke labumatesigami sui, tsau goto i koniqira na daki ma na baka. ");
INSERT INTO gri_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ko padatugua laka igoe o vekenogoa vaniau laka sauba ko naua me pipi na omea ke vano dou vaniau, mo ko sauvaniau kara danga na kukuaqu me ke utugana vania sa tinoni na tsokoraeaqira, ma kara danga vaga na vatu na one i tasi.” ");
INSERT INTO gri_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Ara maturu i tana tana bongi ia, mi tana dani ngana, ma Jakob e vilivotagira i laoqira nina omea tuavati popono na vangalaka gana na sauvaniana a Esau na kulana: e ruka sangatu na naniqoti daki me rukapatu na manena, ruka sangatu na sipi daki me rukapatu na manena, me tolu sangavulu na kamelo e dangadanga dou na tsutsuqira kolu daleqira, me vati sangavulu na buluka daki me sangavulu na manena, rukapatu na asi daki me sangavulu na manena. ");
INSERT INTO gri_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E votagira pipi na vatana kara totu babâ tana niqira alaala, me mologira nina maneaqo kara reitutugu babâ tango kesa alaala. Me tsarivanigira, “Kamu ida igamu, ma kamu moloa ke mangamanga tetelo i levugana pipi alaala.” ");
INSERT INTO gri_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Maia e ketsalia na kesanina maneaqo, “Mi kalina ti vaga ke mai tsodogo a Esau na kulaqu me ke veisuago, ‘?Asei gamu taovia? ?Miava o vavano? ?Masei e tamanigira na omea tuavati ara idaida vanigo?’ ");
INSERT INTO gri_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","migoe nimu aqo ko tuguvisua mo ko tsaria, ‘Nimu maneaqo a Jakob aia nogo e tamanigira. Aia e molo idamaigira vaga kesa na vangalaka vanigo a Esau gana taovia. Maia Jakob segenina goto nogo e maimai i murimami igami.’ ” ");
INSERT INTO gri_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Aia e ketsali vaganana goto na rukanina ma na tolunina, migira sui goto ara reitutugua tango kesa na alaala babâ, me tsarivanigira, “Iani nogo na omea kamu tsarivania a Esau kalina kamu tsodoa. ");
INSERT INTO gri_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nimui aqo kamu tsarivaganana iani, ‘Eo, a Jakob nimu maneaqo e maimai i murimami igami.’ ” Ma Jakob e pada i tobana, “Inau sauba kau ragosia na tobana tana sauana na vangalaka girani, mi muri kalina kau ba tsodoa e tau utu aia sauba ke tabedouau.” ");
INSERT INTO gri_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Me molo idavanogira nina vangalaka, maia e totuvisu moa me maturu tugua i tana tana bongi ia. ");
INSERT INTO gri_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mi tana bongi ia, ma Jakob e mamata me adikaira ruka na tauna kaira, mi kaira goto ruka na tauna lê kolugira sangavulu kesa na dalena, mara savu taligu tana Kô Jabok. ");
INSERT INTO gri_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mi murina kalina e molosavugira sui, maia e molosavugira goto pipi sui na omea e tamanina, ");
INSERT INTO gri_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","maia moa e totuvisu segeni i tana. Me mailaba kesa na mane, mara ka vailabugi poi e tsau tana varangi dani. ");
INSERT INTO gri_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mi kalina na mane ia e reia laka e varangi ke tau tangomana tana vailabu ia, maia e tû me labuvania na bunguna a Jakob me gini tapiu na sasaina na sulina. ");
INSERT INTO gri_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ma na mane e tsaria, “Ko mololeau inau ma kau vano; e vovomai nogo na dani.” Ma Jakob e tsaria, “E utu kau mololego poi ko tabuau talu.” ");
INSERT INTO gri_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ma na mane ia e veisuâ, “?Asei na asamu igoe?” Ma Jakob e tuguvisu vania me tsaria, “A Jakob na asaqu.” ");
INSERT INTO gri_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ma na mane e tsaria, “Sauba na asamu igoe kara tau nogo soaginigo a Jakob. O vailabugi nogo kolua God me kolugira na tinoni, migoe o tangomana; me sauba na asamu kalina ia kara soaginigo a Israel.” ");
INSERT INTO gri_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ma Jakob e tsaria, “Mi kalina ia ko tsarivaniau inau na asamu.” Ma na mane ia e veisuâ, “?Rongona gua ti o ngaoa igoe ko donaginia na asaqu inau?” Mi muri maia e tabua a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ma Jakob e tsaria, “!Alao! !Inau au morosilakana nogo God ginia na mataqu segeni, mau mamauri moa!” Me vaga ia maia e soaginia tana nauna ia i Peniel. ");
INSERT INTO gri_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Mi kalina a Jakob e mololea i Peniel e dato nogo na aso, maia e vavano tsoetsoe rongona e tapiu na bunguna. ");
INSERT INTO gri_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Me tsau mai i dani eni, migira na kukuana a Israel ara tau gania na lasina aia e totu tana sasaina na bungu, rongona tana lasina nogo ia na mane ia e labuvania a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Mi kalina a Jakob e reia a Esau e maimai kolugira vati sangatu nina mane, maia e tû me votagira na baka vania ko Lea, ma ko Ratsel, me vanikaira goto na savana lê. ");
INSERT INTO gri_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Me molokaira ruka na daki tseka kara ka ida kolua ka daleqira, me tsarimai ko Lea kolugira na dalena, mi muri mi kaira ko Ratsel ma Josep. ");
INSERT INTO gri_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma Jakob e ida vanigira, mi kalina e ba laba i konina a Esau na kulana, me vitu kalina e tsuporu tsuna i matana. ");
INSERT INTO gri_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Esau e ulomai na tsodoana me kasoa me domia, mi kaira sui ara ka ngangai. ");
INSERT INTO gri_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mi kalina a Esau e pidikae me morosigira na daki ma na baka, maia e veisuâ, “?Asei vaga na tinoni girani?” Ma Jakob e tuguvisua me tsaria, “Taovia, igirani nogo na baka aia God e gini vangalaka vaniau.” ");
INSERT INTO gri_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mi muri, mi kaira na savana lê ara ka mai kolu ka daleqira mara tsuporu i matana; ");
INSERT INTO gri_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","me tsarimai ko Lea migira na dalena, mi muri tsotsodo mara ka mai kaira a Josep ma ko Ratsel mara ka tsuporu vanigotoa. ");
INSERT INTO gri_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma Esau e veisuâ, “?Megua igira na alaala inau au tsodogira idaida? ?Nagua na rongona gira?” Ma Jakob e tuguvisua me tsaria, “Igira nogo niqu vangalaka vanigo igoe rongona igoe ko tabedouau.” ");
INSERT INTO gri_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Esau e tsaria, “Kulaqu, inau e tuguau nogo niqu tamani. Ko mologira moa migoe nogo ko tamanigira.” ");
INSERT INTO gri_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Jakob e tsaria, “Tagara kulaqu, ti vaga igoe o tabedouau manana mo ko tami moa kiki na adiana niqu vangalaka. Tana niqu papada inau, na morosiana na matamu igoe e vaga moa ti na morosiana na matana God, matena igoe o tabedouau sosongo vaga ia. ");
INSERT INTO gri_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kiki, ko tamia moa na adiana na vangalaka girani inau au adimaigira vanigo. God e dou sosongo vaniau inau me sauvaniau na omea sui au kilia vania na mauriqu.” Ma Jakob e rai sosongolia a Esau poi tsau kalina aia e tami na adiana nina vangalaka. ");
INSERT INTO gri_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ma Esau e tsaria, “Ida ma ka vano, inau sauba kau idagana sautu vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Jakob e tsaria, “Igoe o dona nogo laka igira na baka ara tau susuliga na vanovano tsaku, minau niqu aqo kau padagira goto na sipi, ma na buluka kolu daleqira. Me ti vaga ka turugira kara vano tsaku sosongo me atsa moa ti ke kesa moa na dani, ma na alaala popono sauba kara mate sui. ");
INSERT INTO gri_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kiki, ko ida vano moa igoe. Minau sauba kau kisâ moa kau tsatsari kolugira niqu omea tuavati migira na baka poi kau ba tsauligo i Edom.” ");
INSERT INTO gri_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ma Esau e tsaria, “Me ti e vaga ia, mo ko tamivaniau moa ma kau molovisugira visana niqu mane kara totu kolugo.” Ma Jakob e tsarivania, “E tau goto tamani rongona ke vaga ia, ti vaga ke dou vanigo moa igoe.” ");
INSERT INTO gri_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Me vaga ia, mi tana dani nogo ia ma Esau e aligiri na visutugua i Edom. ");
INSERT INTO gri_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Jakob e vano i Sukot, i tana aia e logovalena me visana na babale vanigira nina omea tuavati. Maia nogoria na rongona ti ara soaginia tana nauna ia i Sukot. ");
INSERT INTO gri_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kalina a Jakob e visumai talu i Mesopotamia, maia e maitsau dou tana verabau ni Sekem tana kao ni Kanaan, me ba vaturikaea nina valepolo kesa tana nauna mangasâ varangisia na verabau ia. ");
INSERT INTO gri_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Maia e voliginia kesa sangatu na tavina siliva na turina na kao ia i koniqira na kukuana a Hamor aia na tamana a Sekem. ");
INSERT INTO gri_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Maia e logoa kesa na belatabu i tana me tangomalavuginia El niqira God na Israel. ");
INSERT INTO gri_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Me kesa dani aia ko Dina ka daleqira daki a Jakob ma ko Lea, e vano na tsigoviaqira visana na daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mi kalina a Sekem na dalena a Hamor na Hivi, aia na taovia na vera tana butona kao ia, e reia ko Dina, maia e tangolia me tangopekea. ");
INSERT INTO gri_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Maia e reia na baka daki ia e rerei dou sosongo te aia e ngao sosongolia me tovoa ke goko ragorago vania. ");
INSERT INTO gri_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Me ba tsarivania na tamana, “Inau au ngaoa igoe ko adivaniau na baka daki iani me ke lia na tauqu.” ");
INSERT INTO gri_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mi kalina a Jakob e rongomia laka ara paluvangamana ko Dina, ma na rongona igira na dalena mane ara totu moa tana poi kolugira nina buluka, ti aia e gini tau mavi ke naua sa omea poi tsau kara visumai igira. ");
INSERT INTO gri_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Maia Hamor na tamana a Sekem e vano na goko koluana a Jakob ");
INSERT INTO gri_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","kalina tsotsodo igira na dalena mane a Jakob ara vivisumai talu i poi. Mi kalina ara rongomia na omea e laba vania na tasiqira, mara gini novo sosongo mara kore loki rongona a Sekem e naua na omea vaga ia, me peaginigira na tinoni sui tana Israel tana tangopekeana na dalena daki a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma Hamor e bâ me tsarivania a Jakob, “A Sekem na dalequ e ngao sosongolia na dalemu daki igoe; kiki, ko tamivania moa me ke taugâ. ");
INSERT INTO gri_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ida kaita ma ka aqosia kesa na vekesai laka sauba kara vaitaugagi nimami tinoni igami ma nimu tinoni igoe. ");
INSERT INTO gri_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mi muri, migamu tangomana kamu totu kolugami ieni i laona nimami butona kao; ma kamu totu iava moa tana amu ngaoa na totu, ma kamu liu bamai iava moa tana amu padangaoa na vano, ma kamu tamani kao goto.” ");
INSERT INTO gri_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mi muri, maia Sekem e tû me tsarivania na tamana ko Dina migira na tasina, “Kamu galuveau moa ma kamu sauvaniau ko Dina, minau sauba kau sauvanigamu na omea gua moa amu ngaoa. ");
INSERT INTO gri_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kamu tsarivaniau moa inau na vangalaka koegua amu ngaoa, ma kamu moloa na qolona vuvuti ke dato koegua moa amu kilia; minau sauba kau sauvanigamu na omea gua moa igamu amu nongia, ti vaga kamu tamivaniau moa inau kau taugâ ko Dina.” ");
INSERT INTO gri_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mi tana rongona a Sekem e paluvangamana nogo ko Dina na tasiqira, te igira na dalena a Jakob ara perobulesikaira a Sekem ma Hamor na tamana. ");
INSERT INTO gri_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Mara tsarivanikaira, “Igami e utu kami tamia na tasimami ke taugâ na mane e tau paripapada; aia sauba ke paluvangamamami igami. ");
INSERT INTO gri_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Migami tangomana kami tami vanikagamu na tasimami ti vaga i kagamu kamu ka lia vaga nogo igami, ma kamu ka tami na paripapadaqira pipi sui na mane i laomui. ");
INSERT INTO gri_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mi tana moa ti igami sauba kami ka tabea na vaitaugagi koluamui igamu, ma kami mai totu kolugamu ma kami lia vaga kesa tinoni kolugamu. ");
INSERT INTO gri_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Me ti vaga kamu ka tau tabea nimami goko ma kamu ka sove na nauana na paripapadana, migami sauba kami adia na tasimami ma kami vano.” ");
INSERT INTO gri_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ma na omea vaga ara tsaria igira e dou moa vanikaira a Hamor ma Sekem na dalena, ");
INSERT INTO gri_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ma na mane vaolu ia e tau goto kisâ na nauana na omea ara tsarivania, rongona aia e ngao sosongolia na dalena daki a Jakob. Ma Sekem aia nogo ara padaloki sosongolia bâ i laona nina tamadale na tamana. ");
INSERT INTO gri_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Mi kaira a Hamor ma Sekem na dalena ara ka vano tana nauna gana na sai tana matsapakapuna na verabau, mara ka goko vanigira ka gaqira verakolu mara ka tsaria: ");
INSERT INTO gri_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Na mane girani ara tobadou vanigita; e dou ka tamivanigira ma kara totu kolugita moa i laona nida kao ma kara liu iava moa tana ara ngaoa. Na kao e loki tugugira goto igira. Ka vaitaugagi kolugira na daleqira daki, migita ka sauvanigira goto na daleda daki kara taugagira. ");
INSERT INTO gri_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Migira na mane girani sauba kara tami na totu koluada ma kara lia vaga kesa tinoni kolugita, ti vaga igita ka tamia laka pipi sui na mane ara totu i laoda kara paripapadana, vaga nogo igira ara paripapada. ");
INSERT INTO gri_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","?Laka pipi niqira omea tuavati me pipi sui na omea tavosi goto igira ara tamanina kara tau lia nida omea igita? Me vaga ia, ida ma ka tami vanigira moa kara mauri i laoda igita.” ");
INSERT INTO gri_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Migira sui na tinoni tana vera ia ara tabea na omea ara ka tsaria kaira a Hamor ma Sekem, me pipi sui lakalaka na mane ara paripapada. ");
INSERT INTO gri_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Me tolu moa na dani i muri, kalina e tau vati mavu moa tana ara paripapada, ara ka ruka vidaqira na dalena a Jakob, kaira nogo a Simeon ma Levi, i kaira na tasina ko Dina, ara ka adia ka niqira isi mara ka liu i laona na verabau ia, me tau goto gunurukaira ke kesa laka kara ka naua sa omea, mi kaira ara ka matesigira pipi sui lakalaka na mane, ");
INSERT INTO gri_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","kolu kaira goto a Hamor ma Sekem na dalena. Mi muri, mara ka adiligia ko Dina tania na valena a Sekem mara tu vano. ");
INSERT INTO gri_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mi murina na labumate ia, migira na dalena mane tavosi a Jakob ara lausuia na omea tana vera ia, na tangotugu rongona ara paluvangamana na tasiqira. ");
INSERT INTO gri_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ara adigira na sipi, ma na buluka, ma na asi, me pipi sui lakalaka na omea i laona na verabau mi laona na uta. ");
INSERT INTO gri_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ara adigira pipi sui na omea loki matena, mara tangoligira sui na daki ma na baka, mara kalagaivanogira pipi sui na omea ara totu i laona na valeqira. ");
INSERT INTO gri_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mi tana ma Jakob e tsarivanikaira a Simeon ma Levi, “I kagamu amu ka alomaia vaniau inau na padasavi loki. Kalina ia igira na Kanaan ma na Peres, migira sui goto ara totu tana kao iani sauba kara reisaviau inau. Mara tau danga niqu mane inau; me ti vaga igira kara sai alaala ma kara maiginiau, me sauba nomoa inau migamu niqu tamadale popono ka viri mate sui.” ");
INSERT INTO gri_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mi kaira ara ka tsaria, “Ami ka tau ngaoa ka tasimami kara nauvaganana na rebi.” ");
INSERT INTO gri_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ma God e tsarivania a Jakob, “Ko tû tsaku mo ko vano i Betel mi tana ko totu. Ko logovaniau kesa na belatabu i tana, inau na God au laba vanigo igoe kalina o tsotsogo tania a Esau na kulamu.” ");
INSERT INTO gri_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Me vaga ia, ma Jakob e tsarivanigira nina tamadale migira sui goto ara totu kolua, “Kamu tsoniligigira sui na titinonina na god peropero igamu amu tamanina; kamu malesi segenimui ma kamu sagelia na polo male. ");
INSERT INTO gri_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Igita sauba ka mololea ieni ma ka vano i Betel, i tana inau sauba kau logoa kesa na belatabu vania na God aia e sangaau inau tana taguna niqu rota, maia e totu koluau pipi tana nauna sui i tana au liu.” ");
INSERT INTO gri_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Me vaga ia, migira ara sauvania a Jakob pipi sui na titinonina na god igira na veratavosi ara tamanina, me pipi sui goto na tsaukuli ara tsautsau i kuliqira. Maia e qilugira sui i vavana na gai tabu aia e tû i ligisana i Sekem. ");
INSERT INTO gri_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mi kalina a Jakob migira na dalena ara aligiri na vano, ma na matagu loki e gadovigira na tinoni ara totu tana vera varangi, mara tau lelê goto tovoa na takuviaqira. ");
INSERT INTO gri_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ma Jakob e mai kolugira nina tinoni sui tsau i Lus, i tana ara soaginigotoa i Betel tana kao ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Maia e logoa i tana kesa na belatabu me tangomalavuginia tana nauna ia na God ni Betel, rongona i tana nogo God e sauvulagi segenina vania kalina aia e tsogo tania a Esau na kulana. ");
INSERT INTO gri_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Maia ko Debora gana reitutugu ko Rebeka e mate mara qilua i vavana na gai tabu e totu pala tada vania i Betel. Mara soaginia na gai tabu ia “Na Gai na Ngangai.” ");
INSERT INTO gri_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mi kalina a Jakob e visumai talu i Mesopotamia, ma God e labavanitugua me tabua. ");
INSERT INTO gri_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mi muri ma God e tsarivania, “Na soamu igoe aia nogo a Jakob, me tû kalina ia me bâ sauba kara soaginigo a Israel.” Me vaga ia ma God e soaginia a Israel. ");
INSERT INTO gri_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma God e tsarigotoa vania, “Inau na God Susuliga Sosongo. Igoe sauba ko tamanigira kara danga na dalemu. Ma na puku danga sauba kara talumai i konimu igoe, migoe sauba ko lia na mumuaqira na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Me sauba kau sauvanigo me vanigira goto igira na kukuamu kara mai i murimu igoe, na kao aia inau au saunogoa vanikaira a Abraham ma Isaak.” ");
INSERT INTO gri_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mi muri ma God e mololea a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Mi tana nauna nogo i tana God e goko vania, ma Jakob e vaturikaea kesa na vatu padapada, me qetu bâ i konina na uaeni ma na oela na olive me baloa. ");
INSERT INTO gri_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Maia e soaginia tana nauna ia i Betel. ");
INSERT INTO gri_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ma Jakob ma nina tamadale ara mololea i Betel, mi kalina ara tau vati varangisia moa i Eprat, e tsau nina tagu tana ko Ratsel ke vasua na dalena, maia e gini vatsangisavi loki sosongo. ");
INSERT INTO gri_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mi kalina e vatsangi lokilokia na dalena, maia na daki e adivasusuna e tsarivania, “Ko Ratsel ko laka na matagu; e kesa goto na dalemu mane.” ");
INSERT INTO gri_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Maia e varangi nogo ke mate, me datovia na magomago loki, maia e soaginia na dalena a Benoni, maia na tamana e soaginia a Benjamin. ");
INSERT INTO gri_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mi kalina e mate ko Ratsel, mara qilua liligina na sautu e vano kalea i Eprat, mi dani eni ara soaginia tana nauna ia i Betlehem. ");
INSERT INTO gri_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma Jakob e vaturikaea kesa na vatu na papadana i tana, ma na vatu papadana na qiluna ko Ratsel e totu moa i tana tsau mai i dani eni. ");
INSERT INTO gri_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Me tû i tana, ma Jakob e ratsu bâ goto, me ba totu i tabana bâ na kusudato loki ni Eder. ");
INSERT INTO gri_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mi kalina a Jakob e totu moa tana butona kao ia, ma Ruben e maturu kolua ko Bilha, aia kesa ka vidaqira na tauna lê a Jakob; mi kalina a Jakob e rongomia me gini kore loki sosongo. Ara tu sangavulu ruka na dalena mane a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Tugira na dalena mane ko Lea: tugira nogo a Ruben aia na dalena botsaida a Jakob, ma Simeon, ma Levi, ma Juda, ma Isakar, ma Sebulun. ");
INSERT INTO gri_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Mi kaira na dalena mane ko Ratsel: kaira nogo a Josep ma Benjamin. ");
INSERT INTO gri_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Mi kaira na dalena mane ko Bilha aia nina daki tseka ko Ratsel: kaira nogo a Dan ma Naptali. ");
INSERT INTO gri_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Mi kaira na dalena ko Silpa aia nina daki tseka ko Lea: kaira nogo a Gad ma Aser. Tugirani nogo na dalena mane ara tu botsa vania a Jakob i Mesopotamia. ");
INSERT INTO gri_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ma Jakob e vano me ba totu kolua a Isaak na tamana i Mamre varangisia i Hebron, i tana ara ka totu ida a Abraham ma Isaak. ");
INSERT INTO gri_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ma Isaak e mauri tsaulina kesa sangatu alu sangavulu na ngalitupana, ");
INSERT INTO gri_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","me mate kalina e tuqatuqa sosongo nogo; mi kaira a Esau ma Jakob na dalena ara ka qilua. ");
INSERT INTO gri_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Igirani nogo na kukuana a Esau, aia ara soaginigotoa a Edom. ");
INSERT INTO gri_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","A Esau e taugagira visana na daki ni Kanaan: aia ko Ada na dalena a Elon na Het; ma ko Oholibama na dalena a Ana aia na dalena a Sibeon na Hivi; ");
INSERT INTO gri_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ma ko Basemat na dalena a Ismael ma na tasina daki a Nebaiot. ");
INSERT INTO gri_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ko Ada e vasua a Elipas; ma ko Basemat e vasua a Reuel; ");
INSERT INTO gri_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ma ko Oholibama e vasutugira a Jeus, ma Jalam ma Kora. Mi tugirani sui na baka mane girani ara botsa vania a Esau tana kao ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Mi muri, maia Esau e adigira na tauna ma na dalena mane ma na dalena daki, migira sui goto na tinoni i laona na valena, kolugira sui nina omea tuavati, me pipi sui lakalaka na omea aia e tamanina tana kao ni Kanaan, me vanoligi tania a Jakob na kulana kesa tana butona kao tavosi. ");
INSERT INTO gri_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Aia e gini vanoligi rongona na kao i tana ara ka tototu kaira e tau nogo tugu kaira; kaira sui ara ka tamani danga sosongo ka niqira omea tuavati, me tau nogo tangomana kara ka totusai. ");
INSERT INTO gri_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Me vaga ia, ma Esau e ba totu tana kao vungavungaga ni Edom. ");
INSERT INTO gri_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Igirani nogo na kukuana a Esau na mumuaqira na Edom. ");
INSERT INTO gri_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Aia ko Ada na tauna a Esau e vasuvania kesa lelê moa na dalena mane aia a Elipas, ma Elipas e tamanitugira tsege na dalena mane: tugira nogo a Teman, ma Omar, ma Sepo, ma Gatam, ma Kenas. Mi konina ko Timna kesa goto na tauna aia e tamanina goto kesa na dalena mane, a Amalek na soana. Maia ko Basemat kesa goto na tauna a Esau e vasuvania kesa lelê moa na dalena mane aia a Reuel na soana, ma Reuel e tamanitugira vati na dalena mane: tugira nogo a Nahat, ma Sera, ma Sama, ma Misa. ");
INSERT INTO gri_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aia ko Oholibama kesa goto na tauna a Esau ma na dalena daki a Ana na dalena a Sibeon, e vasuvania a Esau tolu na dalena mane: tugira a Jeus, ma Jalam, ma Kora. ");
INSERT INTO gri_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Igirani nogo na puku ara talu i konina a Esau. Aia Elipas na dalena botsa ida a Esau e lia tu mumuaqira na puku tugirani: na Teman, na Omar, na Sepo, na Kenas, ");
INSERT INTO gri_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Kora, na Gatam, ma na Amalek. Igirani sui na kukuana ko Ada aia na tauna a Esau. ");
INSERT INTO gri_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aia Reuel na dalena a Esau e lia tu mumuaqira na puku tugirani: na Nahat, na Sera, na Sama ma na Misa. Tugirani sui na kukuana ko Basemat kesa goto na tauna a Esau. ");
INSERT INTO gri_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tugirani na puku ara tu talumai konina a Esau tana nina vasusu ko Oholibama na tauna aia na dalena daki a Ana: na Jeus, ma na Jalam, ma na Kora. ");
INSERT INTO gri_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Igira sui na puku girani ara talumai i konina a Esau. ");
INSERT INTO gri_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Tugirani na dalena mane a Seir ni Hor ara tu totuvi idâ na kao ni Edom: aia nogo a Lotan, ma Sobal, ma Sibeon, ma Ana, ");
INSERT INTO gri_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ma Dison, ma Eser ma Disan. Tugirani nogo na dalena a Seir ara taovia tagao vanigira na Hor. ");
INSERT INTO gri_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","A Lotan aia ka mumuaqira kaira na duli ka koniqira a Hori ma Heman. Ma Lotan e tamanina kesa na tasina daki aia ko Timna. ");
INSERT INTO gri_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ma Sobal aia tu mumuaqira tugira na duli tu koniqira a Alvan, ma Manahat, ma Ebal, ma Sepo, ma Onam. ");
INSERT INTO gri_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","A Sibeon e tamanikaira ruka na dalena mane, kaira nogo a Aia ma Ana. Iani nogo na Ana e tsodovulagigira na vuravura papara tana kaomate kalina aia e reitutugugira nina asi na tamana. ");
INSERT INTO gri_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","A Ana aia na tamana a Dison, maia tu mumuaqira na duli tu koniqira a Hemdan, ma Esban, ma Itran, ma Keran. A Ana e tamanigotoa kesa na dalena daki aia ko Oholibama na soana. ");
INSERT INTO gri_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","A Eser aia tu mumuaqira tugira na duli tu koniqira a Bilhan, ma Saavan ma Akan. ");
INSERT INTO gri_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","A Disan ka mumuaqira kaira na duli ka koniqira a Us ma Aran. ");
INSERT INTO gri_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","I tugirani nogo na puku na Hor tana kao ni Edom: na Lotan, na Sobal, na Sibeon, na Ana, na Dison, na Eser ma na Disan. ");
INSERT INTO gri_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Igirani nogo na taovia tsapakae ara vaitugugi na tagaoviana na vera ni Edom, tana tagu kalina igira na Israel ara tau vati tamanina moa niqira taovia tsapakae segeni: a Bela na dalena a Beor ni Dinhaba a Jobab na dalena a Sera ni Bosra a Husam tana butona kao ni Teman a Hadad na dalena a Bedad ni Avit, aia e tuliusigira na Midian tana vailabu tana kao ni Moab a Samla ni Masreka a Saul ni Rehobot-i-Kô a Baal Hanan na dalena a Akbor a Hadad ni Pau, ma na tauna aia ko Mehetabel na dalena daki a Matred ma na kukuana a Mesahab. ");
INSERT INTO gri_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ma Esau na mumuaqira na puku ni Edom girani: na Timna, na Alva, na Jetet, na Oholibama, na Ela, na Pinon, na Kenas, na Teman, na Mibsar, na Magdiel ma na Iram. Mi tana butona kao i tana ara totu pipi na puku girani ara tamavugininogoa na soana niqira puku. ");
INSERT INTO gri_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","A Jakob e mauri babâ moa tana kao ni Kanaan, i tana e totu ida nogo na tamana. ");
INSERT INTO gri_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Miani nogo e vaga na turupatuna nina tamadale a Jakob. Aia Josep e sangavulu vitu moa na ngalitupana kalina e sangâ na reitutugu sipi ma na naniqoti kolugira na kulana igira ka daleqira ko Bilha ma ko Silpa, i kaira na savana lê a Jakob na tamana. Ma Josep e tatamanga vania na tamana tana rongoqira na omea igira na kulana ara naua. ");
INSERT INTO gri_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma Jakob e galuve sosongolia a Josep liusigira bâ igira sui na kulana tavosi, rongona e botsa kalina aia e tuqatuqa nogo. Ma Jakob e vosivania a Josep kesa na polo tsavugotu katsi mamarega rerei dou sosongo. ");
INSERT INTO gri_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mi kalina igira na kulana ara reia laka na tamaqira e galuve sosongolia bâ a Josep liusigira igira, migira ara reisavi sosongolia mara tau goto ngaoa na goko dou koluana. ");
INSERT INTO gri_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Me kesa tana bongi, ma Josep e bolebole, mi kalina aia e turupatuna vanigira na kulana nina bolebole migira ara reisavi sosongolia goto bâ. ");
INSERT INTO gri_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Maia e tsaria, “Tugamuna kamu tu rongomia na bolebole inau au bolea. ");
INSERT INTO gri_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","E vaga ieni, tugita sui a tu totu i laona kesa na uta ma tu sorisaigira tu nida ivogo na uiti, ma niqu ivogo inau e tavongani tugoto saikesa. Mara mai nimui ivogo igamu mara tû polipolia mara tsuporu vania niqu ivogo inau.” ");
INSERT INTO gri_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Migira na kulana ara veisuâ, “?Laka o padâ igoe sauba ko lia na taovia tsapakae mo ko tagaovi kaputigami igami?” Mi tana, migira ara reisavi loki gotoa bâ rongona nina bolebole ma na rongona goto na omea aia e tsaria tana rongoqira igira. ");
INSERT INTO gri_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mi muri, maia Josep e bolebole tugua me ba tsarivanigira goto na kulana, “Inau au bolegotoa kesa na bolebole, mi laona ia inau au reia na aso, ma na vula, mara sangavulu kesa na veitugu ara tsuporu tsuna vaniau inau.” ");
INSERT INTO gri_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Maia e turupatuna vanigotoa na tamana nina bolebole, ma na tamana e kore me tsarivania, “?Na bolebole koegua vaga ia? ?Laka o padâ igoe laka na tinamu, migira na kulamu, minau goto sauba kami tu mai ma kami tu tsuporu vanigo igoe?” ");
INSERT INTO gri_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Migira na kulana a Josep ara masugu vania, ma na tamana moa e padatugutugua i tobana na omea sui e tsaria a Josep. ");
INSERT INTO gri_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Me kesa dani kalina igira na kulana a Josep ara vano i Sekem na reitutuguaqira nina sipi na tamaqira, ");
INSERT INTO gri_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ma Jakob e tsarivania a Josep, “Au ngaoa ko vano i Sekem tana igira na kulamu ara reitutugugira na sipi.” Ma Josep e tsaria, “E dou.” ");
INSERT INTO gri_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma na tamana e tsarivania, “Ko bâ mo ko reia ti vaga igira na kulamu ara mauri dou, me ti vaga igira na sipi ara totu dou, mi muri ti ko visumai mo ko turupatuna vaniau.” Me vaga ia ma na tamana e molovanoa tû tana Poi ni Hebron. Mi kalina a Josep e ba tsau i Sekem, ");
INSERT INTO gri_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","maia e liliu bamai i tana na laveaqira na tasina, me kesa na mane e tsodoa me veisuâ, “?Laka nagua o lalavea igoe?” ");
INSERT INTO gri_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Maia e tuguvisua me tsaria, “Inau au lalavegira na kulaqu igira ara reitutugugira niqira sipi. ?Egua, tangomana ko tsarivaniau inau iava ara totu igira?” ");
INSERT INTO gri_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ma na mane ia e tsaria, “Ara mololenogoa ieni. Inau au rongomigira ara tsaria laka ara vavano i Dotan.” Me vaga ia, ma Josep e muribagira na kulana me ba reigira i Dotan. ");
INSERT INTO gri_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Migira ara morosi aoa moa, mi kalina e tau vati ba tsau i koniqira, migira ara vorogokona na matesiana. ");
INSERT INTO gri_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Mara vaitsarigi, “Aia, e mai na vanga bolebole ria. ");
INSERT INTO gri_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ida gita kalina ia ma ka matesia, ma ka tsonia na konina i laona sa vidaqira na tuvu kora girani. Igita a tangomana ka tsaria laka e kesa na omea tuavati atsi e matesia. Mi tana ti ka reia nagua sauba ke lia nina bolebole.” ");
INSERT INTO gri_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mi kalina a Ruben e rongomigira, maia e tovoa laka ke maurisia a Josep me tsaria, “Ka laka na matesiana. ");
INSERT INTO gri_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ka tsonitsunâ moa i laona na tuvu iani tana kaomate, ma ka laka moa na sekoliana.” Maia e goko vaganana ia rongona e padâ laka ke maurisia a Josep tanigira me ke molovisua i vera i konina tamana. ");
INSERT INTO gri_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mi kalina a Josep e mailaba i koniqira na kulana, migira ara tsoraligi vania nina polo tsavugotu katsi mamarega. ");
INSERT INTO gri_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mi muri mara tangolia mara tsonisagea i laona na tuvu mamatsa ia. ");
INSERT INTO gri_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mi kalina igira ara mutsa gaqira, mara tavongani morosia kesa na alaala na Ismael ara maimai talu i Gilead mara vano kalea i Ejipt. Niqira kamelo ara lutsangiginigira na papasa sisigini ma na buluna gai. ");
INSERT INTO gri_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ma Juda e tû me tsarivanigira na kulana, “?Nagua sauba ke pelugita igita ti ka matesia na kulada ma ka tovoa moa na poiana na mateana? ");
INSERT INTO gri_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ida ma ka tsabiria moa vanigira na Ismael girani. Mi tana nauvaganana ia me tau kilia ka bokalia; aia na kulada, ma na gabuda segeni nogo igita.” Migira na kulana ara tabea na omea e tsaria a Juda. ");
INSERT INTO gri_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mi kalina visana na mane tsabiri ni Midian ara liu mai i tana, migira na kulana ara raqadatoa a Josep tania na tuvu mara tsabiriginia e rukapatu na tavina siliva vanigira na Ismael, migira ara adivanoa i Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ma Ruben e tau totu kolugira na kulana kalina igira ara tsabiria a Josep, mi kalina e visumai me lavetagarâ a Josep tana tuvu, maia e ratsia na polona tana melu. ");
INSERT INTO gri_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Me visubatugua i koniqira na kulana me tsaria, “!Na baka ri e tagara i tana! ?Ma nagua sauba kau naua inau?” ");
INSERT INTO gri_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mi muri migira ara tû mara matesia kesa na naniqoti mara lumia na polona tsavugotu a Josep tana gabuna. ");
INSERT INTO gri_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Mara adi bâ na polo tsavugotu ia i vera, mara sauvania na tamaqira mara tsaria, “Igami ami rugia na polo iani. ?Me laka e tau nina na dalemu igoe?” ");
INSERT INTO gri_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ma na tamaqira e reigadovia na polo ia me tsaria, “!Eo, na polona nogo aia! Kesa na omea tuavati atsi e matesinogoa. !Na konina kiki a Josep e tangotsingotsi nogo!” ");
INSERT INTO gri_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ma Jakob e ratsia na polona me sagelia na polo baubau papadana nina melu. Maia e tangisi okâ na dalena. ");
INSERT INTO gri_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Migira sui na dalena mane ma na dalena daki ara mai mara tovoa na vereana, maia e sove na rongomiaqira me tsaria, “Tagara, inau sauba kau tangisia na dalequ poi tsau kalina kau tsuna bâ tana barangengo na mate.” Me vaga ia, maia e tangisi babâ moa a Josep na dalena. ");
INSERT INTO gri_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mi Ejipt igira na Midian ara tsabiria a Josep vania a Potipar aia kesa nina mane sasanga na taovia tsapakae, maia e taovia vanigira na mane matali valena na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Gana ngongo tana tagu ia, ma Juda e mololegira na kulana me bâ totu kolua kesa na mane ni Adulam, a Hira na soana. ");
INSERT INTO gri_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mi tana ma Juda e tsodoa kesa na baka daki ni Kanaan aia na dalena a Sua. Maia e taugâ, ");
INSERT INTO gri_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ma na daki ia e vasuvania kesa na baka mane me soaginia a Er. ");
INSERT INTO gri_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Maia e tiana tugua me vasugotoa kesa na baka mane, me soaginia a Onan. ");
INSERT INTO gri_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Mi murimai, maia e tamanina tugua kesa na dalena mane, me soaginia a Sela. Mi kalina e botsa na baka mane ia, ma Juda e totu i Aksib. ");
INSERT INTO gri_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ma Juda e adivania a Er na dalena botsa ida e kesa na tauna, aia ko Tamar na soana. ");
INSERT INTO gri_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma nina omeomea a Er e seko sosongo, ma na Taovia e tau reingaoa, me vaga ia ma na Taovia e matesiligia. ");
INSERT INTO gri_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mi muri ma Juda e tsarivania a Onan na kulana a Er, “Nimu aqo nomoa igoe ko bâ mo ko taugâ na togamu, vaga nogo tana vovorona nida ketsa igita e kilia ka nauvania na tinamatena na kulada, rongona ko Tamar ke gini tamani dalena ma kara gini lia vaga nogo na dalena a Er na kulamu aia e mate nogo.” ");
INSERT INTO gri_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ma Onan e donagininogoa laka igira na baka e utu ke tamanigira aia, me vaga ia, me pipi kalina aia e maturu kolua na tinamatena na kulana, maia ke molotsuna lea na koonagana tana kao rongona ke gini tagara sa baka vania na kulana. ");
INSERT INTO gri_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma na Taovia e tau reingaoa na omea vaga e naua a Onan, me matesigotoa aia. ");
INSERT INTO gri_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Mi muri, maia Juda e tsarivania ko Tamar na tauna na dalena, “Ko visubatugua tana valena tamamu mo ko totu tinamate tana poi ke loki a Sela na dalequ.” Aia e tsarivaganana rongona e matagu ke tau mate goto a Sela, vaga kaira a Er ma Onan na kulana. Me vaga ia, ma ko Tamar e visutugua tana valena tamana. ");
INSERT INTO gri_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Me kesa tana tagu i murimai, maia na tauna goto a Juda e mate. Mi kalina a Juda e suilavaginia na tagu na tangitangi, mi kaira a Hira gana sai dou sosongo ni Adulam ara ka vano i Timna, i tana igira nina maneaqo a Juda ara putsiligia na ivuqira nina sipi. ");
INSERT INTO gri_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mi kalina ko Tamar e rongomia laka na tamana na savana e vavano i Timna na putsiligiana na ivuqira nina sipi, ");
INSERT INTO gri_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","maia e adiligia na polona tinamate aia e sagelia, me tsavupoia na matana ginia na polo, me ba totu puka i matana na vera ni Enaim, aia e kesa na vera e totu i ligisana na sautu e vano kalea i Timna. Aia e donanogoa laka a Sela na muritina dalena a Juda e loki dou nogo kalina ia, ma Juda e tau moa vati sauvania ke taugâ. ");
INSERT INTO gri_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mi kalina a Juda e liu tana me morosia, me padâ laka aia e kesa na daki rebi, rongona e tsavupoia na matana. ");
INSERT INTO gri_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Maia e taligu bâ i konina i tabana sautu me tsarivania,“?E dou, me visa na matemu igoe?” Ma Juda e tau dona laka aia na tauna na dalena. Ma ko Tamar e tsarivania, “?Ma nagua sauba ko voliginiau inau?” ");
INSERT INTO gri_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma Juda e tuguvisua me tsaria, “Inau sauba kau tusumai vanigo ke kesa na dalena naniqoti i laona niqu alaala na naniqoti.” Ma ko Tamar e tsaria, “E dou moa, me ti vaga ko sauvaniau talu ke kesa na omea na papadana poi ke tsau kalina igoe ko saumaivaniau na naniqoti ia.” ");
INSERT INTO gri_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma Juda e veisuâ, “?Ma nagua sauba kau sauvanigo inau ngiti papadana?” Ma ko Tamar e tsaria, “Nimu marepapada ma na itaina, ma nimu itoro igoe o tatango.” Maia e saugira vania. Mi muri mara ka maturusai, maia ko Tamar e tiana. ");
INSERT INTO gri_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ma ko Tamar e visutugua i vera, me adiligia na polo e tsavuginia na lovana me sagelitugua nina polona tinamate. ");
INSERT INTO gri_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mi kalina a Juda e molovanoa a Hira ke adi bâ na naniqoti, me ke adivisumaitugua nina omea aia e sauvania na daki ia ngiti papadana, maia Hira e tau goto tangomana ke tsodoa na daki ia. ");
INSERT INTO gri_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Maia e tû me veisuagira visana na mane ni Enaim, “?Iava ia na daki rebi e totu ieni tana liligina sautu?” Migira ara tuguvisua mara tsaria, “E tau saikesa totu sa daki rebi ieni.” ");
INSERT INTO gri_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Maia e visu bâ konina a Juda me tsarivania, “Au tau tangomana kau tsodoa inau. Migira na mane tana vera ia ara tsarivaniau laka e tau saikesa totu sa daki rebi i tana.” ");
INSERT INTO gri_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ma Juda e tsaria, “E dou moa. Molovaninogoa aia ke tamanina na omea gira. A tau ngaoa kara kiataginikaita na tinoni. Inau au tovoa na voliana, migoe o tau tangomana ko tsodoa.” ");
INSERT INTO gri_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Me gana ngongo tolu na vula i muri, mara tsarivania a Juda, “Aia ko Tamar na tauna na dalemu e vaga na rebi, mi kalina ia aia e tiana.” Ma Juda e ketsaligira me tsaria, “Kamu adirutsumia i tano, ma kamu kodoa me ke mate.” ");
INSERT INTO gri_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mi kalina ara aditsunâ i tano laka kara matesia, maia e mologoko bâ vania na tamana savana me tsaria, “Aia e tianasiau inau aia nogo na mane e tamanina na omea girani. Ko morosigira dou mo ko reia asei nina omea girani, na gana marepapada kolu itaina, ma nina itoro.” ");
INSERT INTO gri_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ma Juda e reigadovigira na omea gira me tsaria, “Eo, e mana na omea aia e tsaria, rongona inau au tau manalia na sauvaniana a Sela ke taugâ.” Ma Juda e tau maturu kolugotoa sa dani. ");
INSERT INTO gri_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mi kalina e laba nina tagu ke vasusu, mara reigadovia laka sauba ke batso na dalena. ");
INSERT INTO gri_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mi kalina aia e vavatsangia na dalena, me kesa ka vidaqira na baka e ida e sau rutsumia kesa tabana limana; maia na daki e adivasusuna e tangolia na limana ia, me sori bâ kesa na koteni tsitsi konina me tsaria, “Iani nogo e botsa ida.” ");
INSERT INTO gri_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Maia na baka e raqa visutugua na limana, ma na kulana e ida botsa. Mi tana ma na daki e adivasusuna e tsaria, “!Laka aia nogoria e vaga nimu botsa igoe!” Maia na rongona ti ara soaginia a Peres. ");
INSERT INTO gri_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mi muri me botsa na kulana ma na koteni tsitsi tana limana, mara soaginia a Sera. ");
INSERT INTO gri_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Migira na Ismael ara adivanonogoa a Josep i Ejipt mara tsabirivania a Potipar aia e kesa nina mane sasanga na taovia tsapakae, me taovia vanigira goto na mane matali valena na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ma na Taovia God e totu kolua a Josep me naua me gini tangomana pipi sui tana aqo aia e naua. Aia e mauri i laona na valena gana taovia ni Ejipt, ");
INSERT INTO gri_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","maia e reigadovia laka na Taovia God e totu kolua a Josep, me naua me gini tangomana pipi sui tana aqo aia e naua. ");
INSERT INTO gri_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ma Potipar e reingao sosongolia a Josep me norua ke lia nina maneaqo segeni; me vaga ia maia e moloa ke reitutugua na valena me pipi sui na omea aia e tamanina. ");
INSERT INTO gri_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Me tû tana tagu ia me bâ, tana rongona nogo a Josep te na Taovia e tabua nina tamadale na mane ni Ejipt ia, me pipi sui goto na omea aia e tamanina i laona na valena mi laona nina uta. ");
INSERT INTO gri_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ma Potipar e moloa i limana a Josep ke reitutugugira pipi sui nina omea e tamanina, maia segeni e tau goto kilia ke gini boe sa omea, me gini boe lelê moa na mutsa aia e gania. Ma Josep e dato magobu dou me rereidou sosongo, ");
INSERT INTO gri_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","me kesa tana tagu i muri ma na tauna a Potipar e tuturiga na reingaoana a Josep me nongia ke maturu kolua. ");
INSERT INTO gri_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maia e sove me tsarivania, “Ko reia, e tau goto kilia gaqu taovia ke gini boe sa omea i laona na valena rongona inau nogo au totu ieni. Aia e mologiniau inau kau reitutugugira pipi sui na omea aia e tamanina. ");
INSERT INTO gri_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Inau au susuliga i laona na vale iani vaga goto moa aia, maia e tau goto tangolivisua sa omea taniau, migoe moa aia e tangolivisugo. ?Kau naukoeguani sagatâ inau na omea seko loki vaga ia, ma kau sasi i matana God?” ");
INSERT INTO gri_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Me atsa moa na daki ia e totu matengana na ngasuana a Josep pipi dani, maia e sove saikesa na maturu koluana. ");
INSERT INTO gri_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Me kesa dani, ma Josep e sage i vale na nauana nina aqo, me tagara goto sa maneaqo tavosi ke totu i tana. ");
INSERT INTO gri_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Maia na tauna a Potipar e tangolivania nina polo na tsavugotu a Josep me tsarivania, “Ko mai koluau inau i nige.” Maia Josep e tsogotsuna i tano, me mololea nina polo na tsavugotu i limana na daki ia. ");
INSERT INTO gri_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mi kalina aia e reia laka a Josep e mololea nina polo na tsavugotu i vale me tsogotsuna i tano, ");
INSERT INTO gri_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","maia e soamaigira igira ara aqo i valena me tsarivanigira, “!Reia bâ! Na mane ni Hibru iani aia na savaqu e adimaia ieni gana moa ke peagita. Aia e sagemai i laona niqu voki inau me tovoa ke tangopekeau, minau au kanga gû loki sosongo. ");
INSERT INTO gri_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mi kalina aia e rongomiau au kanga gû maia e tsogotsuna i tano, me mololea nina polo na tsavugotu ligisaqu inau.” ");
INSERT INTO gri_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Maia e tangolia nina polo tsavugotu a Josep poi e visumai i vera gana taovia. ");
INSERT INTO gri_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Maia e tsarivania kesa moa atsa na turupatu: “Aia na tseka ni Hibru, aia igoe o adimaia ieni, e sagemai i laona niqu voki me goko peaau inau. ");
INSERT INTO gri_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mi kalina inau au kanga gû, maia e tsogotsuna i tano, me mololea nina polo na tsavugotu i ligisaqu inau.” ");
INSERT INTO gri_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Me kore loki sosongo gana taovia a Josep, ");
INSERT INTO gri_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","me ketsaligira kara tangolia ma kara tsonia tana vale sosori i tana ara mologira igira nina mane peresini na taovia tsapakae, mi tana aia e totu peresini. ");
INSERT INTO gri_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma na Taovia e totu moa kolua a Josep me tabua, te aia na mane e reitutugua na vale sosori e padaloki sosongolia. ");
INSERT INTO gri_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Maia e moloa a Josep ke reitutugugira na mane tavosi sui ara totu tana vale sosori, me molovania aia ke manakaputia pipi na omea ara naua i laona. ");
INSERT INTO gri_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ma na mane reitutugu vale sosori e tau ngoli sosongolia na reitutuguana sa omea aia e molonogoa i limana a Josep, rongona na Taovia e totu kolua a Josep me naua me gini tangomana pipi sui tana aqo aia e naua. ");
INSERT INTO gri_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Me kesa tana tagu i muri, mi kaira na mane gana aqo na adiuaeni vania na taovia tsapakae ni Ejipt, ma na mane e taovia tana bulobredi, ara ka sasi sui vania na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Maia e kore vanikaira nina mane sasanga kaira, ");
INSERT INTO gri_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","me tsonikaira tana vale sosori i laona na valena niqira taovia na mane matali, tana nauna goto moa i tana ara moloa a Josep. ");
INSERT INTO gri_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mi kaira ara ka totu oka sosongo i laona na vale sosori, ma gaqira taovia na mane matali e moloa a Josep ke lia vaga ka niqira maneaqo. ");
INSERT INTO gri_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Me kesa tana bongi i laona nogo na vale sosori ia mi kaira na mane gana aqo na adiuaeni ma na mane e taovia tana bulobredi ara ka bolea tango kesa na bolebole, ma ka niqira bolebole ara ka tavosi rongona sui. ");
INSERT INTO gri_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mi kalina a Josep e mai ka koniqira tana matsaraka, maia e reikaira ara ka totu padasavi. ");
INSERT INTO gri_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Me veisuakaira, “?Rongona gua ti amu ka moro melumeluga vaga sagata ia i dani eni?” ");
INSERT INTO gri_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Mi kaira ara ka tuguvisua mara ka tsaria, “I kagami ami ka tango kesa na bolebole ami ka bolea, me tagara ke kesa ieni tangomana ke nusirongona vanikagami.” Ma Josep e tsaria, “Aia God segeni moa e saua na sasaga gana na nusirongona na bolebole. Bâ, kamu ka turupatuna vaniau inau na omea amu ka bolea.” ");
INSERT INTO gri_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mi tana ma na mane gana aqo na adiuaeni e tsaria, “I laona niqu bolebole inau au reia kesa na itai na uaeni e tutû i mataqu inau, ");
INSERT INTO gri_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mara tu tolu na arana i konina. Mi kalina tsotsodo e molo rauna vaolu, me tamani latsena saviliu me mada nogo na vuana. ");
INSERT INTO gri_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Inau au tatangolia nina bilo na inu na taovia tsapakae; mi tana mau adigira na vuana uaeni mau lusisagegira i laona na bilo ia mau sauvania ke inu.” ");
INSERT INTO gri_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ma Josep e tsaria, “Iani nogo e vaga na rongona nimu bolebole igoe: tugira tolu na arana na papadana ara tolu na dani. ");
INSERT INTO gri_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Me kau ke tolu moa na dani, ma na taovia tsapakae ke nusigo tania na vale sosori, me ke padale vanigo nimu sasi, me ke molovisugo tugua tana nimu aqo o naua vania i votanagana kalina igoe nina mane gana na adiuaeni. ");
INSERT INTO gri_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Minau au nongigo kiki, ko laka na padaleaqu inau kalina ke laba dou vanigo pipi na omea, mau nongigo goto kiki, ko galuveau mo ko soâ na soaqu vania na taovia tsapakae, mo ko sangaau gana kau gini rutsu tania na vale sosori. ");
INSERT INTO gri_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Inau ara komiau tania niqira kao igira na Hibru; me atsa vaga goto ieni i Ejipt inau au tau naua sa omea seko e tugua kara mologiniau tana vale sosori.” ");
INSERT INTO gri_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mi kalina na mane e taovia tana bulobredi e reia laka na nusirongona nina bolebole na mane gana aqo na adiuaeni e dou vania, maia e tû me tsarivania a Josep, “Inau goto au bolea kesa na bolebole; inau au bolea laka au sungitugira tolu na kei na bredi. ");
INSERT INTO gri_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mi laona na kei i gotu tsotsodo ara totu pipi vatana gana bredi puipui na taovia tsapakae, mara mai na manu mara gaganigira.” ");
INSERT INTO gri_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ma Josep e tsarivania, “Iani nogo e vaga na rongona nimu bolebole igoe: tugira tolu na kei igira na papadana tolu dani. ");
INSERT INTO gri_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","!Me kau moa tolu na dani ma na taovia tsapakae sauba ke nusigo goto igoe tania na vale sosori me sauba kara kavikutia na lovamu! Mi muri maia ke tsauraginikaea na konimu kesa tana gai, migira na manu sauba kara gania na lakamu.” ");
INSERT INTO gri_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Me tolu na dani i muri, aia na dani ara padatugua na dani tana e botsa na taovia tsapakae, maia e aqosia kesa na mutsa loki vanigira sui nina mane sasanga; maia e nusikaira aia na mane gana aqo na adi gana uaeni ma na mane e taovia tana bulobredi, me adimaikaira i mataqira nina mane sasanga. ");
INSERT INTO gri_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Maia e molovisutugua na mane gana aqo na adiuaeni tana nina aqo, ");
INSERT INTO gri_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","me kuria na lovana na mane e taovia tana bulobredi me sori tsauraginia na konina. E laba vaga popono pipi na omea e tsaria a Josep. ");
INSERT INTO gri_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Maia na mane gana aqo na adiuaeni e tau saikesa padavisua a Josep, me padale saikesalia moa. ");
INSERT INTO gri_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Me putsi e ruka na ngalitupa, ma na taovia tsapakae ni Ejipt e bolea laka e tutû liligina na Kô Nile, ");
INSERT INTO gri_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","me reigira ara vitu na buluka papaquru dou me angaanga na kokoraqira, ara datomai talu i laona na kô mara tuturiga na gani buruburu. ");
INSERT INTO gri_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mi muri maia e reigira ara vitu goto na buluka tavosi ara datomai; migira ara qaroqarosaga mara suli lê. Migira goto ara datomai mara mai tû varangisigira na buluka tavosi i liligina kô, ");
INSERT INTO gri_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","migira na buluka qarosaga ara konomi poponogira na buluka papaquru igira. Mi tana me mamata na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mi muri, maia e maturu visutugua me bolegotoa kesa na bolebole tavosi. E reigira ara vitu na vunguna sila patudou mara ganoga laka, mara dato konina kesa moa na gaina. ");
INSERT INTO gri_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mi muri, mara vitu goto na vunguna sila ara labadato mai, igira ara ruase lê ma na gugurina na kaomate e mai me paragira, ");
INSERT INTO gri_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","migira na vunguna sila ruase lê ara mai mara konomi poponogira na sila patudou gira. Mi tana me mamata na taovia tsapakae me padagadovia laka e bolebole. ");
INSERT INTO gri_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mi tana matsaraka ia aia e gini boe sosongo, me mologoko vanigira pipi na tinoni ara basutidao migira sui goto na tinoni sasaga i laona na Ejipt popono kara mai laba i konina. Maia e tsarivulagia vanigira kaira nina bolebole, me tau goto tangomana sa vidaqira ke votarongoqira vania. ");
INSERT INTO gri_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mi muri, maia na mane gana aqo na adiuaeni e tsarivania na taovia tsapakae, “I dani eni moa ti au vasini moa padâ laka au sasi inau. ");
INSERT INTO gri_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Igoe o kore vanikagami sui aia na taovia na bulobredi minau, migoe o tsonikami tana na vale sosori tana valena gaqira taovia na mane matali. ");
INSERT INTO gri_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Me kesa tana bongi mi kagami sui ami ka bolebole, ma ka nimami bolebole kagami ara ka tamani ruka tavosi rongona. ");
INSERT INTO gri_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Me kesa na borau ni Hibru e totu kolukagami i tana, aia nina tseka gaqira taovia na mane matali. I kagami ami ka turupatuna vania ka nimami bolebole, maia e nusivanikagami na rongona. ");
INSERT INTO gri_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma na omea aia e tsarivanikagami e laba vaga saikesa aia e tsaria: igoe o molovisuau tugua inau tana niqu aqo, mo kavikutia na lovana na mane e taovia tana bulobredi.” ");
INSERT INTO gri_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mi tana e tû na taovia tsapakae, me mologira visana kara ba adimaia a Josep, migira ara adimaitsakua talu tana vale sosori. Mi murina, kalina e tsatsara me oli polona sui, maia e mai i matana na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma na taovia tsapakae e tsarivania, “Inau au bolea kesa na bolebole, me tau goto tangomana ke kesa ke votarongona vaniau. Mara tsarivaniau inau laka igoe o tangomana ko nusirongona na bolebole.” ");
INSERT INTO gri_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ma Josep e tsarivania, “Taovia, inau segeniqu goto au tau tangomana, maia God sauba ti ke sauvanigo na rongona laka.” ");
INSERT INTO gri_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ma na taovia tsapakae e tsaria, “Inau au bolea laka au tutû i liligina na Kô Nile, ");
INSERT INTO gri_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","mau reigira ara vitu na buluka papaquru me angaanga na kokoraqira, ara datomai talu tana kô mara mumutsa gaqira. ");
INSERT INTO gri_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mi muri, mara vitu goto na buluka tavosi ara datomai, migira ara qaroqarosaga mara suli lê moa. Igira na buluka seko putsikae bâ inau au tau vati morosia sa dani i laona na Ejipt popono. ");
INSERT INTO gri_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Migira na buluka qaroqarosaga ara mai mara konomi poponogira na buluka papaquru gira, ");
INSERT INTO gri_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","mara tau goto rerei vaga laka ara gania sa omea rongona igira ara rerei seko sosongo vaga moa nogo tana idana. Mi muri minau au mamata. ");
INSERT INTO gri_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Mi kalina inau au maturu visutugua mau bolegotoa laka au reigira vitu na vunguna sila igira ara patudou mara ganoga laka, mara dadato i konina kesa moa na gaina. ");
INSERT INTO gri_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mi muri, mara botsa datomai ara vitu na vunguna sila tavosi goto, mara vua ruase lê ma na gugurina na kaomate e paragira, ");
INSERT INTO gri_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","mara tû igira na vunguna sila ruase lê mara konomi poponogira na vunguna sila patudou gira. Minau au tsaritugua niqu bolebole kaira vanigira na tinoni ara dona na basutidao, me tau goto tangomana sa vidaqira ke votavaniau ka rongoqira.” ");
INSERT INTO gri_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ma Josep e tsarivania na taovia tsapakae, “I kaira sui na bolebole kaira, e kesa moa atsa ka rongoqira; maia God e gini tsarivulagi vanigo igoe na omea aia sauba ke naua. ");
INSERT INTO gri_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tugira vitu na buluka papaquru tugira na papadana vitu na ngalitupa, mi tugira goto vitu na vunguna sila patudou tugira na papadana goto vitu na ngalitupa, mi kaira sui na bolebole kaira e kesa moa atsa ka rongoqira. ");
INSERT INTO gri_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Mi tugira vitu na buluka qaroqarosaga ara tu laba datomai i muri, mi tugira vitu na vunguna sila ruase lê e paratugira na gugurina na kaomate, na papadana vitu na ngalitupa na uvirau. ");
INSERT INTO gri_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Aia saikesa nogo na omea au tsarivanigo nogo inau, God e sauvulagi vanigo igoe na omea aia sauba ke naua. ");
INSERT INTO gri_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sauba kara vitu na ngalitupa na tamani omea danga sosongo i laona na kao popono ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mi murina ia, me sauba kara laba kara vitu na ngalitupa na uvirau, migira na tinoni sauba kara padalegira pipi sui na ngalitupa dou tana ara tamani danga sosongo, rongona na uvirau ia sauba ke sekolia na butona kao popono. ");
INSERT INTO gri_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ma na tagu na tamani omea danga sauba kara padale saikesalia, rongona na taguna na uvirau ke mai i muri, sauba ke seko sosongo bâ. ");
INSERT INTO gri_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ma ka rongoqira na bolebole igoe o bolekaira e vaga ieni: aia God e titinogoa na taguna, me utu ke oka me ke laba. ");
INSERT INTO gri_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Mi kalina ia igoe nimu aqo ko vilia kesa na mane e sasaga loki me dona na padagadovi omea, mo ko molovania ke tagaovia na veramu popono. ");
INSERT INTO gri_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mo ko viligira goto kara visana na mane sasanga tavosi niqira aqo kara adia na tsegenina turina pipi na omea tsukatsuka i laoqira vitu na ngalitupa na tamani omea danga sosongo. ");
INSERT INTO gri_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ko ketsaligira kara adisaigira pipi na mutsa i laoqira na ngalitupa na tamani danga ara maimai, mo ko saua vanigira na susuliga gana kara mololakadougira na sila i laoqira pipi na verabau ma kara mataligira. ");
INSERT INTO gri_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ma na mutsa gira sauba kara totu vangarau vania na vera popono kalina ke laba na uvirau tana vera ni Ejipt i laona e vitu na ngalitupa. Mi tana nauvaganana ia ti igira na tinoni e utu kara gini mate na vitoa.” ");
INSERT INTO gri_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na taovia tsapakae migira gana sasanga ara rongomingaoa na goko e tsaria a Josep. ");
INSERT INTO gri_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Me tû na taovia tsapakae me tsarivanigira, “Igita e utu goto ka tangomana na tsodoana sa mane ke dou liusia bâ a Josep, aia na mane nina tarunga God e totuvinogoa.” ");
INSERT INTO gri_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ma na taovia tsapakae e tsarivania a Josep, “God e sauvulagi vanigo nogo igoe pipi na omea sui girani, me lakagana sosongo vaniau na reigadoviana laka igoe o sasaga loki mo dona na padagadovi omea liusigira na tinoni sui. ");
INSERT INTO gri_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Inau sauba kau mologo igoe ko reitutugu kaputia na veraqu popono, migira sui niqu tinoni sauba kara muria na omea igoe ko ketsaligira. Ma gamu susuliga igoe sauba ko rukanina i koniqu inau. ");
INSERT INTO gri_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mi kalina ia, inau au viligo igoe ko tagaovi kaputia na Ejipt popono.” ");
INSERT INTO gri_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ma na taovia tsapakae e adiligia na ringi ara bulutiginia nina marepapada na taovia tsapakae e totu tana kakauna, me molo bâ tana kakauna a Josep. Maia e sageli vanigotoa kesa na polo sagesage vovosilaka, me molovania kesa na tseni qolumila i liona. ");
INSERT INTO gri_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Maia e saugotoa vania na rukanina nina terê ke sage i konina, ma nina mane matali kara ida vania i sautu ma ma kara gudato ma kara tsaria, “!Kamu mangâ na sautu! !Kamu mangâ na sautu!” Me vaga ia maia e moloa a Josep ke tagaovi kaputia na Ejipt popono. ");
INSERT INTO gri_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma na taovia tsapakae e tsarivania, “Inau nogoria na taovia tsapakae, mau vatsa laka e tagara goto sa tinoni i laona na Ejipt popono tangomana ke saukaea na limana se na tuana ti ke tau nongitami talu i konimu nogo igoe.” ");
INSERT INTO gri_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Maia e molovania a Josep kesa na soana ni Ejipt, aia e soaginia a Sapenat Panea, me sauvania kesa na tauna ko Asenat na soana, aia na dalena daki a Potipera aia kesa na manetabu tana verabau ni Heliopolis. E tolu sangavulu moa na ngalitupana a Josep tana tagu e tuturiga na aqo vaniana na taovia tsapakae ni Ejipt. Maia Josep e mololea na valena na taovia tsapakae, me liuvi poponoa na kao ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","I laoqira na vitu ngalitupa na tamani omea danga sosongo, ara datodou pipi sui na omea tsukatsuka tana kao popono ia, ");
INSERT INTO gri_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ma Josep e adisaigira sui me mololakagira i laoqira na verabau gira. Mi laona pipi na verabau aia e mololakagira na mutsa ara dato tana uta ara totu polipolia na verabau ia. ");
INSERT INTO gri_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mara danga sosongo na sila te a Josep e mololea na gini aqo na tovo mamava, rongona ara danga vaga saikesa nogo na one i tasi. ");
INSERT INTO gri_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Idavia na ngalitupa na uvirau maia ko Asenat e vasuvania a Josep ruka na dalena mane. ");
INSERT INTO gri_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Maia e tsaria, “God e naua minau au padalegira nogo pipi niqu rota, migira sui goto ara totu tana valena tamaqu”; maia e soaginia na dalena mane botsa ida a Manase. ");
INSERT INTO gri_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Maia e tsarigotoa, “God e sauvaniau na dalequ tana kaona niqu rota”; te aia e soaginia na rukanina dalena mane a Epraim. ");
INSERT INTO gri_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Na vitu ngalitupa na tamani danga sosongo tana kao ni Ejipt ara vano putsi nogo, ");
INSERT INTO gri_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ma na vitu ngalitupa na uvirau ara tuturiga, vaga saikesa nogo na omea e tsaria a Josep. Ma na uvirau ia e liuvigotoa pipi sui na vera tavosi, mi laona segeni moa na Ejipt popono ara tamanina na mutsa. ");
INSERT INTO gri_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mi kalina igira na tinoni ni Ejipt ara tuturiga na vatsangiana na vitoa, ara ba ngangai vania na taovia tsapakae ke vanigira na mutsa. Maia e raigira kara bâ i konina a Josep ma kara naua moa na omea aia ke tsarivanigira. ");
INSERT INTO gri_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Na uvirau ia e seko liuliu bâ me liuvia na butona kao popono, ma Josep e sangavigira pipi na vale na molomutsa me tsabirigira na sila vanigira na tinoni ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Migira na tinoni tana barangengo popono ara mai goto i Ejipt na voli sila i konina a Josep, rongona na uvirau e liuvi poponoa pipi na nauna sui. ");
INSERT INTO gri_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kalina a Jakob e rongomia laka e totu na sila i Ejipt maia e tû me tsarivanigira na dalena, “?Rongona gua ti amu tototu lê moa? ");
INSERT INTO gri_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Inau au rongomia laka e totu na sila i Ejipt; kamu vano i tana ma kamu volia ke visana ka gini tau mate na vitoa.” ");
INSERT INTO gri_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Me vaga ia, mi tugira sangavulu na kulana savusavu a Josep ara tu vano i Ejipt na voli sila, ");
INSERT INTO gri_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ma Jakob e tangolivisua a Benjamin na kulana manana a Josep, rongona e matagu ke tau laba vania sa omea. ");
INSERT INTO gri_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Igira na dalena a Jakob ara dulikolugira goto visana ara vano na voli sila, rongona na uvirau e gado goto tana kao ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ma Josep aia e taovia tagao tana butona kao ni Ejipt e tsabiri sila vanigira na tinoni ara talu pipi nauna sui tana barangengo popono. Me vaga ia, migira na kulana a Josep ara mai mara tsuporu i matana a Josep ma na lovaqira e pelea na kao. ");
INSERT INTO gri_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mi kalina a Josep e morosigira na kulana, maia e reigadovigira, me nauvaganana moa laka e tau donaginigira. Maia e goraragira me tsaria, “?Iava vaga amu talumai igamu?” Migira ara tsaria, “Igami ami talu i Kanaan mami mai na voli mutsa.” ");
INSERT INTO gri_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Me atsa moa a Josep e reigadovigira na kulana, migira ara tau saikesa reigadovia aia. ");
INSERT INTO gri_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Maia e padavisua na bolebole e bolea tana rongoqira me tsarivanigira, “Igamu amu mane togatoga; amu mai na tuviana na veramami ma na laveana iava i tana igami ami maluku.” ");
INSERT INTO gri_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Migira ara tsaria, “Tagara, taovia. Igami ami mai ieni vaga moa nimu tseka gana kami voli mutsa. ");
INSERT INTO gri_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Igami sui ami tamakula. Mami tau na mane togatoga, igami ami tsaria na manana vanigo taovia.” ");
INSERT INTO gri_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma Josep e tsarivanigira, “!Tagara! Igamu amu mai na tuviana na veramami ma na laveana i tana igami ami maluku.” ");
INSERT INTO gri_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Migira ara tsaria, “Taovia, igami ami saisai mami sangavulu ruka na tamakula, na dalena kesa moa na mane tana kao ni Kanaan. Me kesa vidamami e mate, ma na muritibaka e totuvisu kolua na tamamami.” ");
INSERT INTO gri_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ma Josep e tsaria, “E vaga nogo au tsaria inau. Igamu na mane togatoga. ");
INSERT INTO gri_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Inau sauba kau tovolegamu vaga iani: Tana asana na taovia tsapakae inau au vatsa laka sauba e utu kamu mololea ieni poi ke labamai ieni na kulamui tetelo. ");
INSERT INTO gri_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nina aqo ke kesa vidamui igamu ke ba adimaia. Migamu visana sauba kamu totu moa tana vale sosori poi tsau kalina kau reia na manana nimui goko. Ti tagara, me mana vaga na taovia tsapakae aia e mauri, migamu amu mane togatoga manana.” ");
INSERT INTO gri_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Maia e tû me mologira kara totu i laona na vale sosori ke tolu na dani. ");
INSERT INTO gri_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mi tana tolunina dani ma Josep e tsarivanigira, “Inau au matagunia God, me vaga ia me sauba kau gaea moa na maurimui ti vaga igamu kamu naua kesa na omea. ");
INSERT INTO gri_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Gana kau gini reimakalia laka amu goko mana, sauba ke kesa vidamui ke totuvisu i laona na vale sosori i tana amu totu nogo igamu; migamu sui tavosi kamu visu moa i veramui ma kamu adivisuvanigira nimui tamadale vivitoa na sila igamu amu voligira. ");
INSERT INTO gri_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mi muri ma nimui aqo kamu dulikolumaia ieni na kulamui tetelo i koniqu inau. Iani nogo sauba ke saumakalia laka e mana na omea amu tsaria, mi tana ti inau e utu kau matesigamu.” Migira ara tabea na omea iani, ");
INSERT INTO gri_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","mara vaigokovigi segeniqira mara tsaria, “Eo, i kalina ia igita a gini rota tana rongona na omea igita a nauvania na kulada; igita a reinogoa na rota loki e totu i laona kalina aia e nongigita ka sangâ, migita a tau ngaoa na rongomiana. Aia nogo na rongona ti igita a tsodoa na rota loki iani kalina ia.” ");
INSERT INTO gri_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Ruben e tsaria, “Inau au tsarivanigamu nogo kamu laka na nauvaniana sa omea na baka ia, migamu amu tau ngaoa na rorongo. Mi kalina ia igita a adipeluna tana rongona na mateana aia.” ");
INSERT INTO gri_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ma Josep e rongomigadovia moa na omea sui ara tsaria igira, migira ara tau donaginia rongona a Josep e goko vanigira tana goko ni Ejipt, me gini aqo kesa tinoni tavosi gana ke oligoko vanigira. ");
INSERT INTO gri_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mi tana ma Josep e mololegira me tuturiga na ngangai, mi kalina e tangomana tugua ke goko, maia e visumaitugua i koniqira, me vilia a Simeon, me soria i mataqira igira na kulana. ");
INSERT INTO gri_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ma Josep e ketsaligira nina maneaqo kara dangaliginigira na sila niqira todo na kulana, ma kara sauvanigira goto na mutsa gana i sautu. Migira ara naua vaga aia e tsaria. ");
INSERT INTO gri_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Migira na tamakula ara lutsangia i gotuna niqira asi na sila ara volia, mi muri mara tû mara vano. ");
INSERT INTO gri_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mi kalina ara laba tana nauna i tana ara pada kara maturu, me kesa na vidaqira e sangavia nina todo gana ke palâ nina asi, te e ba reia nina qolo e totu i mangana nina todo. ");
INSERT INTO gri_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Maia e soagira na kulana me tsaria, “!Tugamuna, niqu qolo inau e visumaitugua i koniqu! !Reia, e totu ieni i laona niqu todo!” Migira sui ara matagu mara vaiveisuagi, “?Nagua vaga God e nauvanigita igita?” ");
INSERT INTO gri_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mi kalina ara labavisumai i Kanaan i konina a Jakob na tamaqira, mara turupatuna vania pipi sui na omea e laba vanigira mara tsaria: ");
INSERT INTO gri_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Na taovia tagao ni Ejipt e goko kakai sosongo vanigami, me kelivanigami laka ami vano na togaviana na verana. ");
INSERT INTO gri_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Migami ami tsarivania, ‘Igami ami tau na mane togatoga, ami tinoni dou moa. ");
INSERT INTO gri_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Igami ami sangavulu ruka na tamakula, na dalena kesa moa na mane. E kesa na kulamami e mate nogo, ma na muritibaka e totuvisu i Kanaan kolua na tamamami.’ ");
INSERT INTO gri_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ma na mane ia e tsarivanigami, ‘Iani sauba kau nauvaganana ti kau gini tsodovulagia ti vaga igamu amu tinoni dou manana: Ke kesa na vidamui igamu sauba ke totuvisu koluau ieni; migamu sui tavosi kamu adi sila vanigira nimui tamadale vivitoa ma kamu vano. ");
INSERT INTO gri_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ma kamu visumai ma kamu dulikolumaia na kulamui botsa tumuri. Mi tana ti inau sauba kau donaginia laka igamu na tinoni dou, mamu tau na mane togatoga; minau sauba kau sauvisu vanigamu a Simeon na kulamui, me tangomana kamu totu ieni ma kamu liu bamai iava moa amu padangaoa na vano.’ ” ");
INSERT INTO gri_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mi kalina ara busia niqira todo, me pipi sui vidaqira e reia nina lapa na qolo; mi kalina ara reia na qolo migira sui kolugotoa a Jakob na tamaqira ara viri matagu loki. ");
INSERT INTO gri_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma na tamaqira e tsarivanigira, “Igamu amu ngaoa kara nanga sui taniau na dalequ. A Josep e nanga nogo, ma Simeon e nanga goto; mi kalina ia migamu amu ngaogotoa kamu adiligi taniau a Benjamin. !Inau moa e ngoli sosongoliau na rotana na omea sui girani!” ");
INSERT INTO gri_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ma Ruben e tsarivania na tamana, “Ti vaga inau kau tau adivisumai vanigo a Benjamin, migoe ko labumatesikaira ruka na dalequ. Ko moloa a Benjamin tana limaqu inau, minau sauba kau adivisumaia vanigo.” ");
INSERT INTO gri_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Jakob e tsaria, “Na dalequ e utu saikesa ke vano kolugo; na kulana e mate nogo, maia lelê moa e totuvisu. Tau utu sauba ke laba vania sa omea i sautu. Minau au tuqatuqa nogo, me ti vaga ke laba vania sa omea na baka ia, minau sauba kau gini mate na melu.” ");
INSERT INTO gri_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ma na uvirau e seko liuliu bâ i laona na Kanaan popono, ");
INSERT INTO gri_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","mi kalina igira nina tamadale a Jakob ara ganisuigira na sila ara volia i Ejipt, ma Jakob e tsarivanigira na dalena, “Kamu visutugua i Ejipt ma kamu voligotoa visana mutsa vanigita.” ");
INSERT INTO gri_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Juda e tsarivania, “Ma na mane ia e parovatavigami kakai me tsaria, ‘E utu goto kamu reia na mataqu inau, ti vaga kamu tau dulikolumaia na kulamui.’ ");
INSERT INTO gri_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ti vaga o padangaoa igoe ke vano kolugami na kulamami, me sauba igami kami vano ma kami voli mutsa vanigo. ");
INSERT INTO gri_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Me ti vaga o tau tami igoe, me utu kami vano igami, rongona na mane ia e tsaria laka e utu kami reia na matana ia, ti vaga kami tau dulikolu bâ na kulamami tetelo.” ");
INSERT INTO gri_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ma Jakob e tsaria, “?Rongona gua ti amu alotimai vaniau inau e danga na rota mamu ba tsarivania na mane ia laka amu tamanina kesa goto na kulamui?” ");
INSERT INTO gri_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mara tuguvisua igira mara tsaria, “Ma na mane ia e veisuaqasi sosongolia tana rongoda igita ma nida tamadale, me tsaria, ‘?Egua, laka e mamauri moa na tamamui? ?Me laka e tagara goto sa kulamui?’ Migami nimami aqo nomoa kami tuguvisu vania nina veisua aia. ?Ma kami dona koegua igami laka sauba aia ke tsarivanigami kami dulikolu bâ na kulamami?” ");
INSERT INTO gri_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ma Juda e tsarivania na tamana, “Ko moloa na baka ke dulikoluau inau, ma kami vano nogo kalina ia, me ke gini tau mate na vitoa sa vidada. ");
INSERT INTO gri_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Inau sauba kau vekevanigo na mauriqu segeni, migoe ko moloa i limaqu inau kau reitutugua aia. Me ti vaga kau tau adivisumai mamauria, minau nogo kau gadovikedena tana mauriqu popono. ");
INSERT INTO gri_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Me ti vaga kami tau pipitu oka sosongo vaga ia, me tugunogoa kami vanovisu ke ruka nogo kalina.” ");
INSERT INTO gri_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma na tamaqira e tsarivanigira, “Ti vaga e kilia ke laba vaga ia, ma kamu adigira na vuana dou bâ na omea tsukatsuka ara dato tana kao iani, ma kamu molosagegira tana nimui todo vaga na vangalaka vania na taovia tagao ia: kamu adigira ke visana na bulunagai, me ke visana na bulumitsua, na papasa sisigini dou ma na tsela ma na gatsoga. ");
INSERT INTO gri_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kamu adigotoa na qolo ke ruka kalina na dangana vaga i votangana, rongona nimui aqo kamu adivisugira na qolo ara visumai i laona nimui todo. Tau utu ngatsu ara molo sasilia i tana. ");
INSERT INTO gri_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bâ, kamu adia na kulamui ma kamu visumai tsaku. ");
INSERT INTO gri_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Maia God Susuliga Sosongo ke molovania na mane ia ke galuvegamu, rongona ke gini molovisumai vanigamu kaira a Benjamin ma na kulamui tavosi goto. Minau ti vaga e kilia kara nanga taniau na dalequ, me sauba kara nanga.” ");
INSERT INTO gri_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Me vaga ia, migira na tamakula ara adigira na vangalaka ma na qolo e ruka kalina na dangana vaga ara adia tana idana, mara aligiri na vano i Ejipt kolua a Benjamin. Mi kalina ara ba tsau i tana mara ba laba i matana a Josep. ");
INSERT INTO gri_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mi kalina a Josep e morosia a Benjamin kolugira, maia e tsarivania nina maneaqo aia e reitugugu valena, “Ko adibagira na mane girani tana valequ inau. Mi muri mo ko bâ mo ko matesia kesa na omea tuavati mo ko vangaraua, rongona au ngaoa na mane girani kara mutsa koluau ke niaso.” ");
INSERT INTO gri_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ma na maneaqo aia e naua na omea a Josep e raiginia, me adivanogira na tamakula tana valena a Josep. ");
INSERT INTO gri_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Migira na tamakula ara gini matagu rongona ara adivanogira tana valena a Josep mara tsaria, “Eo, ara adimaigita ieni rongona na qolo e visu i laona nida todo tana idana. Me tau utu sauba kara labu novotigita ma kara adigira nida asi, migita ka lia sui nina tseka aia.” ");
INSERT INTO gri_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mi matsapana na vale, migira ara tsarivania na maneaqo reitutugu vale, ");
INSERT INTO gri_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Taovia, sauba kami tsoni vô i matamu, migami ami mai nogo ieni i votangana na voli mutsa. ");
INSERT INTO gri_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mi kalina igami ami vivisu i veramami, mami ba laka kami maturu i sautu, mi tana mami sangavigira nimami todo, me pipi kesa vidamami e reia nina qolo e gini volimutsa e totu i mangana nina todo, nimami qolo popono. Migami ami adivisumai vanigo kalina ia. ");
INSERT INTO gri_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Mami adimaigotoa visana na qolo kolugami gana na voliana ke visana goto na mutsa. Igami ami tau dona asei aia e molosagevisua nimami qolo i laona nimami todo.” ");
INSERT INTO gri_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ma na maneaqo e tsaria, “Kamu laka na gini boe. Laka goto na matagu. Ngatsu nimui God, aia nina God na tamamui, aia nogo ke molovisu vanigamu nimui qolo i laona nimui todo. Inau au adinogoa na matena popono na omea igamu amu volia.” Mi muri, maia e bâ me adimaia a Simeon i koniqira. ");
INSERT INTO gri_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ma na maneaqo ia e adisagegira na tamakula gira i laona na valena a Josep. Me sao kô vanigira gana kara gini vulia na tuaqira, mi muri maia e ba palagira niqira asi. ");
INSERT INTO gri_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Migira ara vangarau manogatia niqira vangalaka kara sauvania a Josep kalina aia ke mailaba tana niaso, rongona ara tsarinogoa vanigira laka sauba kara mutsa kolua aia. ");
INSERT INTO gri_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mi kalina e mailaba a Josep, migira ara adisage bâ vania i laona na vale niqira vangalaka mara tsuporu tsuna i matana. ");
INSERT INTO gri_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Maia e veisuagira ti vaga ara mauri dou, mi muri maia e tsarivanigira, “Igamu amu turupatuna nogo vaniau inau i votangana tana rongona na tamamui tuqatuqa. ?Egua aia? ?Laka aia e mamauri moa me totu dou?” ");
INSERT INTO gri_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Migira ara tuguvisua mara tsaria, “Aia na tamamami nimu maneaqo dou e mamauri moa me totu dou.” Migira ara tsunatuturu mara tsuporu tsuna i matana. ");
INSERT INTO gri_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mi kalina a Josep e reia a Benjamin na kulana maia e tsaria “?Laka iani nogoria na kulamui na muritibaka igamu amu gini turupatuna vaniau inau tana rongona? !God ke tabugo dalequ!” ");
INSERT INTO gri_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mi tana, ma Josep e tavongani mololegira tsaku rongona aia e reia na kulana tetelo me galuve sosongolia, me varangi ke ngangai laba. Maia e ba sage tana nina voki me ngangai. ");
INSERT INTO gri_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mi murina kalina e daovi suia na matana, maia e berengiti sosongo me rutsumaitugua, me ketsaligira nina maneaqo kara tuvaria na mutsa. ");
INSERT INTO gri_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ma Josep e mutsa kesa tana bela, migira na kulana ara mutsa konina kesa na bela. Migira na tinoni ni Ejipt ara sanga mutsa goto i tana, mara totu segeni goto kesa tana bela tavosi, rongona igira na Ejipt ara reipeagira na Hibru, me utu kara mutsa sai kolugira konina kesa moa na bela. ");
INSERT INTO gri_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma na tamakula igira ara mologira tana sasaqira taoni botsa, mara totu aro bâ i konina a Josep tana bela. Mi kalina igira ara reia niqira tototu e muritaoni botsa vaga ia mara beke sosongo mara vaimorosigi. ");
INSERT INTO gri_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma na mutsa ara tuvarivanigira ara adia tana nina bela nogo a Josep, ma Benjamin moa ara tuvarigana e tsege kalina na dangana liusigira sui na tavosina. Me vaga ia, migira ara mutsa mara inu kolua a Josep poi tsau kalina e ulavigira. ");
INSERT INTO gri_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ma Josep e raia na maneaqo e reitutugu valena me tsaria, “Ko dangaligira niqira todo na mane girani me ke danga tsiriri na mutsa vaga e tugugira na adiana, mo ko molovisua nina qolo pipi mane i mangana nina todo. ");
INSERT INTO gri_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mo ko moloa niqu tseu siliva i mangana nina todo na muritibaka, kolugotoa nina qolona na voli sila.” Ma na mane ia e naua na omea a Josep e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mi tana matsaraka bongibongi na dani ngana maia e molovanogira na tamakula gira kara vano kolugira niqira asi. ");
INSERT INTO gri_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mi kalina ara vano ao tetelo moa tania na verabau, ma Josep e tsarivania nina maneaqo e reitutugu valena, “Ko ulo tsarimuriqira tsaku na mane gira. Mi kalina ko tsauligira ko veisuagira vaga iani, ‘?Rongona gua ti amu tuguginia na omea seko na omea dou? ");
INSERT INTO gri_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","?Rongona gua ti amu komia nina tseu siliva gaqu taovia inau? Aia nogoria na tseu e gini inuinu aia, maia goto na tseu e gini aqo tana basutidao. !Amu sasi loki sosongo igamu!’ ” ");
INSERT INTO gri_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mi kalina na maneaqo ia e tsauligira, maia e tsaritugua vanigira moa nina goko a Josep. ");
INSERT INTO gri_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Migira ara tsarivania, “?Nagua rongona ti igoe o goko vaga ia igoe taovia? Igami ami vatsa laka ami tau saikesa naua na omea vaga ia. ");
INSERT INTO gri_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Igoe o donagininogoa laka igami ami adivisumainogoa vanigo talu i Kanaan na qolo igami ami reia i mangana nimami todo. ?Me vaga ia, ma na rongona gua ti kami komigotoa na siliva se na qolumila tana valena gamu taovia igoe? ");
INSERT INTO gri_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Taovia, ti vaga ke kesa vidamami igami ko tsodoa i konina nina tseu gamu taovia, maia ke mate, migami sui tavosi kami lia nimu tseka.” ");
INSERT INTO gri_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Maia e tsaria, “Eo, inau au tabea; maia moa e adia na tseu sauba ke lia niqu tseka, migamu sui tavosi kamu visu i vera.” ");
INSERT INTO gri_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Me vaga ia, migira ara tsaku ara molotsunagira niqira todo, me pipi vidaqira e sangavia nina todo. ");
INSERT INTO gri_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Maia nina maneaqo a Josep e segidoua niqira todo tuturiga konina na baka botsaida, me ba sui konina na muritibaka, ma na tseu ia e ba tsodoa i laona nina todo a Benjamin. ");
INSERT INTO gri_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Migira na tamakula ara ratsia na poloqira tana melu, mara lutsangitugua niqira todo i kelaqira niqira asi mara visutugua tana verabau. ");
INSERT INTO gri_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mi kalina a Juda migira na kulana ara maitsau tana valena a Josep, maia e tototu moa i tana. Migira ara tsuporu i matana, ");
INSERT INTO gri_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ma Josep e tsarivanigira, “?Nagua amu naua igamu? ?Amu tau ngatsu donaginia laka na mane vaga inau tangomana ke tsodovulagi omea tana basutidao?” ");
INSERT INTO gri_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ma Juda e tuguvisua me tsaria, “?Taovia, nagua goto kami tsaria? ?Nagua goto kami gini livusuguradi? ?Ma kami naukoeguani gotoa ti kami saulabatia laka ami tau sasi? God nogo e mololabatia nimami sasi igami. Mi kalina ia migami sui ieni nimu tseka nogo igoe, me tau aia moa o tsodoa nimu tseu i konina.” ");
INSERT INTO gri_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Josep e tsaria, “!Tagara! !E utu saikesa kau nauvaganana ia! Maia moa au tsodoa niqu tseu i konina sauba ke lia niqu tseka. Migamu sui tavosi tangomana kamu visudou moa i konina na tamamui.” ");
INSERT INTO gri_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ma Juda e tudato bâ i konina a Josep me tsaria, “Kiki taovia, ko tamivaniau moa ma kau goko dou kolugo. Ko laka na kore vaniaqu; igoe o atsakolunogoa na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Taovia, i votangana igoe o veisuagami, ‘?Egua laka e mamauri moa na tamamui, mamu tamanigotoa sa kulamui?’ ");
INSERT INTO gri_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Migami ami tsarivanigo, ‘Eo, e mamauri moa na tamamami maia e tuqatuqa sosongo nogo, me kesa goto na kulamami na muritibaka, aia e botsa kalina e tuqatuqa sosongo nogo na tamamami. Ma na kulana na baka mane ia e mate nogo, maia segeni lelê moa e kesa e mamauri tana dalena tinana; ma na tamana e galuve sosongolia.’ ");
INSERT INTO gri_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Migoe taovia, o tsarivanigami kami adimaia ieni rongona ko morosiginia, ");
INSERT INTO gri_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","migami ami tsarivanigo laka na baka ia e tau tangomana ke mololea na tamana; me ti vaga ke mololea na tamana me sauba na tamana ke mate. ");
INSERT INTO gri_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mi muri migoe o tsaria, ‘E utu saikesa kamu reia na mataqu inau, ti vaga na kulamui tetelo ke tau dulikolumaigamu.’ ");
INSERT INTO gri_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Mi kalina ami visu bâ i konina na tamamami migami ami tsarivania na omea sui vaga igoe o tsaria. ");
INSERT INTO gri_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mi muri, ma na tamamami e tsarivanigami tugua kami visumai ma kami voligotoa visana mutsa. ");
INSERT INTO gri_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Migami ami tsarivania, ‘Igami e utu kami vano; sauba e utu kara tamivanigami kami reia na matana ia ti vaga na kulamami tetelo ke tau dulikolubagami. Vaga ia, migami tangomana moa kami bâ ti vaga na kulamami tetelo ke vano kolugami goto.’ ");
INSERT INTO gri_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ma na tamamami e tsarivanigami, ‘Igamu amu donagininogoa laka ko Ratsel na tauqu inau e vasuvaniau ruka lelê moa na baka mane. ");
INSERT INTO gri_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Me kesa ka vidaqira e vanoligi taniau kiki nogo inau. E tau utu kara ngotsigaqira nogo na omea tuavati atsi, rongona au tau saikesa reilakana tû kalina aia e mololea iani. ");
INSERT INTO gri_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Me ti vaga igamu kamu adiligigotoa a Benjamin iani taniau kalina ia, me ke ba laba vania sa omea seko, minau sauba kau gini mate moa na melu rongona au tuqatuqa sosongo nogo.’ ” ");
INSERT INTO gri_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ma Juda e goko babâ moa me tsaria, “Mi kalina ia taovia, ti vaga kau visu bâ inau i konina tamaqu me ke tagara na baka ia koluau, mi kalina tsotsodo aia ke morosia laka na baka mane e tau totu koluau, maia sauba ke mate. Na maurina aia e totu kakai sosongo kolua na maurina na baka mane ia, maia e tuqatuqa sosongo nogo ma na melu ke gadovia sauba ke matesiginia. ");
INSERT INTO gri_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Me kesa goto na omea, inau au vekea na mauriqu vania na tamaqu tana rongona na baka ia. Mau tsarivanigotoa laka ti vaga kau tau adivisu bâ na baka i konina minau nogo sauba ke gadoviau na kedena tana mauriqu popono. ");
INSERT INTO gri_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Mi kalina ia taovia, inau nogo sauba kau totuvisu ieni vaga nimu tseka na tuguna na baka ia; ko tamivania moa aia ke visu i vera kolugira na kulana. ");
INSERT INTO gri_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","?Kau visu koegua inau i konina na tamaqu ti vaga na baka ia ke tau vano koluau? E utu saikesa kau berengiti na reiana na omea seko loki iani ke laba vania na tamaqu.” ");
INSERT INTO gri_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ma Josep e tau goto nogo tangomana ke tangolivisua nina vavatsangi i mataqira nina maneaqo, te e tû me railigigira sui kara mololea na voki ia. Me tagara goto ke kesa ke totu kolua i tana kalina a Josep e tsarivulagi vanigira na kulana laka asei aia. ");
INSERT INTO gri_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma Josep e ngangai loki sosongo, migira nina maneaqo ni Ejipt ara rongomia, ma na turupatuna e ba laba tsau tana valena na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Mi muri ma Josep e tsarivanigira na kulana, “Inau nogoria a Josep na kulamui. ?Megua laka e mamauri moa na tamaqu?” Mi kalina igira na kulana ara rongomia aia e tsarivaganana ia, mara gini matagu loki sosongo mara tau tangomana kara tuguvisua nina goko. ");
INSERT INTO gri_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mi muri, ma Josep e tsarivanigira, “Kiki kamu mai varangi.” Migira ara mai varangi, maia e tsarivanigira, “Inau nogo a Josep na kulamui, aia igamu amu tsabirivanoa i Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mi kalina ia ma kamu laka na gini padasavi ma na vaikeligi tana rongona igamu amu tsabirimaiau ieni. Aia God manana nogo e moloau kau idamai ieni inau gana kau gini maurisigira na tinoni. ");
INSERT INTO gri_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Iani na rukanina moa na ngalitupa na uvirau tana kao ieni; me kau goto ke tsege na ngalitupa i tana sauba ke tagara na tsutsuka se na pipitsu. ");
INSERT INTO gri_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God nogo e moloau kau idamai vanigamu ieni gana kau laumaurisiginigamu tana omea ganataga vaga iani, ma kamu gini mauri igamu migira goto na kukuamui. ");
INSERT INTO gri_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Me vaga ia, me tau nomoa igamu manana amu molomaiau inau ieni, aia nogo God e naua mau gini lia nina mane sasanga putsikae bâ na taovia tsapakae. Minau au reitutugugira pipi na omea sui tana valena, mau tagaovi kaputigotoa na Ejipt popono. ");
INSERT INTO gri_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Mi kalina ia, kamu visu bâ tsaku i konina tamaqu ma kamu ba tsarivania laka iani nogo e vaga na omea a Josep na dalemu e tsarivanigo: ‘God e naua mau gini lia na taovia tagao kaputia na Ejipt popono; mau nongigo ko mai i koniqu mo ko laka goto na kisâ. ");
INSERT INTO gri_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ko mai totu tana butona kao ni Gosen, mi tana nogo ko gini totu varangisiau inau, igoe migira na dalemu, migira goto na kukuamu, ma nimu sipi ma nimu naniqoti, ma nimu buluka, me pipi sui goto na omea tavosi igoe o tamanigira. ");
INSERT INTO gri_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Me ti vaga igoe ko totu i Gosen, minau tangomana kau reitutugugo. E kau ke tsege goto na ngalitupa na uvirau; minau au tau ngaoa laka igoe migira nimu tamadale, migira goto nimu omea tuavati kamu vitoa.’ ” ");
INSERT INTO gri_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Me goko babâ moa a Josep vanigira na kulana me tsaria, “Mi kalina ia igamu sui, migoe goto a Benjamin, amu reia laka inau a Josep manana nogo. ");
INSERT INTO gri_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kamu tsarivania na tamaqu laka au susuliga koegua inau ieni i Ejipt, ma kamu turupatuna vanigotoa tana rongoqira pipi na omea sui igamu amu reigira. Mi muri, ma kamu adimai tsakua ieni.” ");
INSERT INTO gri_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Maia e kulakula kolua a Benjamin me tuturiga na ngangai; ma Benjamin e ngangai goto kalina aia e kulakula kolua. ");
INSERT INTO gri_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma Josep e ngangai babâ moa me kaso kesakesa gira na kulana me domigira. Mi murina moa ia ti igira na kulana ara tuturiga na goko koluana. ");
INSERT INTO gri_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mi kalina e ba laba tana valena na taovia tsapakae na turupatuna laka ara mailaba igira na kulana a Josep, maia na taovia tsapakae, migira goto gana sasanga ara gini mage sosongo. ");
INSERT INTO gri_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Maia e tsarivania a Josep, “Ko tsarivanigira na kulamu kara molokaea gaqira lutsa i kelaqira niqira asi ma kara visutugua tana kao ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ko molovanogira kara ba adimaia na tamaqira ma niqira tamadale ma kara visumaitugua ieni. Inau sauba kau sauvanigira na butona kao dou bâ tana Ejipt, me sauba kara tamani danga bâ gana kara gini mauri. ");
INSERT INTO gri_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ko tsarigotoa vanigira kara adigira ke visana na terê ni ieni i Ejipt gana kara gini sage na tauqira ma na daleqira tetelo, ma kara gini adimaigotoa na tamaqira. ");
INSERT INTO gri_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kara laka na gini boe ti kara mololevisua i Kanaan visana niqira omea tatamani; rongona sauba kara tamanina na omea dou bâ ieni tana kao ni Ejipt.” ");
INSERT INTO gri_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Migira na dalena a Jakob ara naua na omea vaga ara tsarivanigira. Ma Josep e sauvanigira visana na terê vaga e ketsalia na taovia tsapakae, me tusu mutsa vanigira goto gana i sautu. ");
INSERT INTO gri_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Maia e sauvanigira goto ara tango kesa na polo na oli, maia moa a Benjamin e tusuvania tolu sangatu na tavina siliva me tsege na polo na oli. ");
INSERT INTO gri_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Maia e mologira bâ vania na tamana sangavulu na asi ara lutsangigira na omea levolevo dou bâ ni Ejipt, mara sangavulu na asi ara lutsangi sila ma na bredi, ma na mutsa tavosi gaqira i sautu. ");
INSERT INTO gri_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Maia e molovanogira na kulana, mi kalina e vailivugira maia e tsarivanigira, “Ma kamu laka na vaikoregi i sautu.” ");
INSERT INTO gri_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Migira ara mololea i Ejipt mara visu bâ i konina a Jakob na tamaqira i Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Mi kalina ara ba laba mara tsarivania, “!A Josep e mamauri moa! !Maia nogo e taovia tagao kaputia na Ejipt popono!” Ma Jakob e gini novo mate me tau saikesa tutunina. ");
INSERT INTO gri_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mi kalina moa ara turupatuna vania pipi sui na omea a Josep e tsarivanigira, maia e reigira goto na terê aia Josep e molomaigira gana na adivanoginiana i Ejipt, maia e magomago laba tugua. ");
INSERT INTO gri_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Maia e tsaria, “!E tugu nogoa! !A Josep na dalequ e mamauri moa! Niqu aqo nomoa kau vano ma kau reitalua a Josep ti kau mate.” ");
INSERT INTO gri_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ma Jakob e binabolia pipi sui nina omea e tamanina me vano i Beerseba, i tana aia e kodoputsa vania nina God a Isaak na tamana. ");
INSERT INTO gri_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma God e laba vania a Jakob tana bongi me soâ, “!Jakob, Jakob!” Ma Jakob e tsaria, “Eo, ieni inau.” ");
INSERT INTO gri_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma God e tsarivania, “Inau nogo God, nina God na tamamu. Ko laka na matagu na vano i Ejipt; inau sauba kau naua migira na kukuamu kara lia na puku loki i tana. ");
INSERT INTO gri_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Inau sauba kau vano kolugo i Ejipt, me sauba kau adivisumaigira tugua na kukuamu tana kao iani. Ma Josep sauba ke totu kolugo kalina igoe ko mate.” ");
INSERT INTO gri_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Mi muri ma Jakob e mololea i Beerseba. Migira na dalena ara molosagea a Jakob, migira sui goto na daleqira tetelo ma na tauqira tana terê aia na taovia tsapakae ni Ejipt e molomai vanigira. ");
INSERT INTO gri_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Migira ara adivanogira goto niqira omea tuavati me pipi sui na omea ara tamanina i Kanaan, ");
INSERT INTO gri_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ma Jakob migira sui na dalena ma na kukuana na mane mana daki ara vano sui i Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Igirani nogo igira i laona nina tamadale a Jakob ara vanokolua i Ejipt: aia a Ruben na dalena botsaida ");
INSERT INTO gri_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","mi tugira na dalena a Ruben: aia Hanok, ma Palu, ma Hesron, ma Karmi. ");
INSERT INTO gri_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","A Simeon mi tugira na dalena: aia Jemuel, ma Jamin, ma Ohad, ma Jakin, ma Sohar ma Saul aia na dalena kesa na daki ni Kanaan. ");
INSERT INTO gri_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ma Levi mi tugira na dalena: aia Gerson, ma Kohat ma Merari. ");
INSERT INTO gri_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ma Juda mi tugira na dalena: aia Sela, ma Peres ma Sera. Mara ka ruka goto na dalena a Juda ara ka mate nogo i Kanaan, kaira nogo a Er ma Onan. Mi kaira na dalena a Peres, kaira a Hesron ma Hamul. ");
INSERT INTO gri_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","A Isakar mi tugira na dalena: aia Tola, ma Pua, ma Jasub, ma Simron. ");
INSERT INTO gri_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","A Sebulun mi tugira na dalena: aia Sered, ma Elon ma Jaleel. ");
INSERT INTO gri_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Igirani nogo na dalena mane a Jakob e vasuvania ko Lea i Mesopotamia, me tau tsokosaikolua ko Dina na dalena daki. Ara saisai igira sui na kukuana ko Lea mara tsaulina tolu sangavulu tolu. ");
INSERT INTO gri_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","A Gad mi tugira na dalena: aia Sepon, ma Hagi, ma Suni, ma Esbon, ma Eri, ma Arod ma Areli. ");
INSERT INTO gri_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","A Aser mi tugira na dalena mane: aia Imna, ma Isva, ma Isvi, ma Beria, ma na tasiqira daki ko Sera. Kaira na dalena mane a Beria kaira nogo a Heber ma Malkiel. ");
INSERT INTO gri_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Igirani ara sangavulu ono na kukuana a Jakob tana nina vasusu ko Silpa, na daki tseka aia Laban e sauvania ko Lea na dalena. ");
INSERT INTO gri_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Maia ko Ratsel na tauna a Jakob e vasuvania kaira ruka na baka mane, kaira nogo a Josep ma Benjamin. ");
INSERT INTO gri_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Mi Ejipt a Josep e tamanikaira ruka na dalena mane, aia Manase ma Epraim, e vasukaira vania aia ko Asenat na dalena daki a Potipera na manetabu ni Heliopolis. ");
INSERT INTO gri_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Migira na dalena a Benjamin: aia Bela, ma Beker, ma Asbel, ma Gera, ma Naaman, ma Ehi, ma Ros, ma Mupim, ma Hupim ma Ard. ");
INSERT INTO gri_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Igirani ara sangavulu vati na kukuana a Jakob tana nina vasusu ko Ratsel. ");
INSERT INTO gri_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","A Dan ma Husim na dalena. ");
INSERT INTO gri_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","A Naptali mi tugira na dalena: aia Jaseel, ma Guni, ma Jeser ma Silem. ");
INSERT INTO gri_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tugirani vitu na kukuana a Jakob tana nina vasusu ko Bilha, na daki tseka aia Laban e sauvania ko Ratsel na dalena. ");
INSERT INTO gri_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ara saisai na dangaqira igira na kukuana manana a Jakob ara vano kolua i Ejipt mara tsaulia ono sangavulu ono, mara tau tsokosai kolugira na tauqira na dalena. ");
INSERT INTO gri_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Me kolukaira ruka na baka mane e vasukaira ko Asenat vania a Josep i Ejipt mara gini tsaulia e vitu sangavulu na tinoni tana nina tamadale a Jakob ara vano i Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ma Jakob e moloa a Juda ke ida me ke ba nongia a Josep ke mai tsodogira i Gosen. Mi kalina ara ba tsau i tana, ");
INSERT INTO gri_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ma Josep e sage tana nina terê me vano i Gosen ke tsodoa na tamana. Mi kalina ara ka vaitsodogi ma Josep e kasoa na tamana me ngangai oka sosongo. ");
INSERT INTO gri_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma Jakob e tsarivania a Josep, “Mi kalina ia e dou vaniau moa ti kau mate, rongona au reigo igoe mau dona laka igoe o mamauri moa.” ");
INSERT INTO gri_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mi muri, ma Josep e tsarivanigira na kulana migira sui tavosi tana valena tamana, “Niqu aqo inau kau vano i konina na taovia tsapakae ma kau tsarivulagi vania laka igira na kulaqu migira sui i laona na valena tamaqu, igira ara totu i Kanaan, ara mailaba sui nogo i koniqu. ");
INSERT INTO gri_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Me sauba kau tsarigotoa vania laka igamu amu mane reitutugusipi, mamu reitutugugira goto nimui omea tuavati tavosi, mamu adimaigira goto nimui sipi ma nimui buluka me pipi sui lakalaka na omea tavosi amu tamanina. ");
INSERT INTO gri_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mi kalina ti na taovia tsapakae ke soagamu me ke veisuagamu na aqo gua amu naua, ");
INSERT INTO gri_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","migamu kamu tsaridoua vania laka igamu amu reitutugugira na omea tuavati tana maurimui popono, vaga nogo ara naua igira na mumuamui. Mi tana nauvaganana ia ti sauba aia ke gini tamivanigamu na totu ieni tana butona kao ni Gosen.” A Josep e tsari vaganana ia rongona igira na tinoni ni Ejipt ara reipeagira igira ara aqo tana reitutugu sipi. ");
INSERT INTO gri_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Vaga ia, ma Josep e aditugira tsege na kulana, mara tu vano kolua i konina na taovia tsapakae. Ma Josep e tsarivania, “Na tamaqu migira na kulaqu ara labamai nogo talu i Kanaan kolugira niqira sipi ma niqira buluka, me pipi sui goto na omea ara tamanina. Mi kalina ia, migira ara tototu moa tana butona kao ni Gosen.” ");
INSERT INTO gri_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Mi muri maia e sauvulagitugira na kulana vania na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ma na taovia tsapakae e veisuatugira, “?Laka nagua tu nimui aqo tugamu?” Mi tugira ara tu tuguvisua mara tsaria, “Taovia, igami na mane reitutugusipi vaga nogo igira tu mumuamami. ");
INSERT INTO gri_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Igami ami mai na totu tana butona momoru ieni, rongona na uvirau e seko sosongo bâ tana kao ni Kanaan me tagara goto sa buruburu dou vanigira nimami sipi. Ami nongigo kiki, ko tamivanigami kami totu tana butona kao ni Gosen.” ");
INSERT INTO gri_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma na taovia tsapakae e tsarivania a Josep, “Ara mailaba nogo na tamamu migira goto na kulamu, ");
INSERT INTO gri_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","me vaga ia ma na kao popono tana Ejipt niqira nogo igira. Ko mologira kara totu tana butona kao ni Gosen, aia na turina dou bâ tana kao popono. Me ti vaga kara visana i laoqira kara dona dou na reitutugu buluka, mo ko mologira kara reitutugugira goto niqu buluka segeni inau.” ");
INSERT INTO gri_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mi muri ma Josep e adimaigotoa a Jakob na tamana me sauvulagi vania na taovia tsapakae. Ma Jakob e tabua na taovia tsapakae, ");
INSERT INTO gri_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ma na taovia tsapakae e veisuâ, “?E visa vaga na ngalitupamu igoe?” ");
INSERT INTO gri_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma Jakob e tsarivania, “Na mauriqu inau tana tavetada e tsaulinogoa kesa sangatu tolu sangavulu na ngalitupa. Migira na ngalitupaqu inau ara kurikuri lê mara kakai, mara tau moa katsi vaga na ngalitupaqira igira na mumuaqu tana niqira tavetada igira.” ");
INSERT INTO gri_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma Jakob e tabutugua na taovia tsapakae, me vailivua me vano. ");
INSERT INTO gri_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Mi muri, ma Josep e mololaka dougira na tamana migira na kulana, me sauvanigira kara tamanina na kao dou bâ i ligisana na verabau ni Rameses, vaga nogo e ketsalia na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma Josep e saumutsa vania na tamana migira na kulana, migira sui tavosi goto tana valena tamana, kolugira goto na baka tetelo bâ. ");
INSERT INTO gri_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ma na uvirau e seko sosongo bâ me tagara goto sa mutsa ke totu sa nauna, migira na tinoni sui tana Ejipt ma na Kanaan ara gini maluku na vitoa. ");
INSERT INTO gri_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mi kalina igira ara mai na voli sila, ma Josep e adisaigira na qolo me adivanogira sui tana valena na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mi kalina ara gini vovoli sui nogo na qolo ni Ejipt mi Kanaan, migira na tinoni ni Ejipt ara mai i konina a Josep mara tsarivania, “!Ko vanigami na mutsa! Ko laka kiki tamivanigami kami mate. !Ko naua sa omea! Nimami qolo igami ara vano sui nogo.” ");
INSERT INTO gri_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ma Josep e tsarivanigira, “Ti vaga ke sui nogo nimui qolo ma kamu adimaigira nimui omea tuavati, minau sauba kau sauvanigamu na mutsa na oliolina.” ");
INSERT INTO gri_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Me vaga ia, migira ara adimai vania a Josep niqira omea tuavati, maia e sauvanigira na mutsa e oliginia niqira ose, ma niqira sipi, ma niqira naniqoti, ma niqira buluka ma niqira asi. Mi tana ngalitupa popono ia, ma Josep e sauvanigira na mutsa na oliolina niqira omea tuavati. ");
INSERT INTO gri_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mi tana ngalitupa i muri, migira ara mai tugua i konina a Josep mara tsarivania, “Taovia, igami e utu goto kami tiapoia vanigo laka e sui saikesa nogo nimami qolo, mo tamanigira sui nogo igoe nimami omea tuavati. Me tagara goto sa omea ke totuvisu tangomana kami sauvanigo igoe, na konimami moa ma nimami kao. ");
INSERT INTO gri_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ko laka na moloana kami gini mate na vitoa. !Ko naukikia sa omea! Ko laka goto na tamivaniana nimami uta kara totu mangu lê. Ko voligami igami ma nimami kao mo ko oliginia na mutsa. Migami sauba kami lia nina tseka na taovia tsapakae, maia sauba ke tamanina nimami kao. Ko vanigami na sila gana kami gini mauri ma na piuna gana na tsukaana tana nimami uta.” ");
INSERT INTO gri_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ma Josep e volia pipi na butona kao sui tana Ejipt vania na taovia tsapakae. Me pipi sui na tinoni ni Ejipt ara tsabiria niqira kao, rongona na uvirau e sekoligira sosongo; me vaga ia, me pipi sui na butona kao ara lia nogo nina tamani na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ma Josep e naua mara lia sui na tseka igira na tinoni ni Ejipt tu kesa tabana me tsau bâ kesa tabana. ");
INSERT INTO gri_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Migira lelê moa na butona kao ara tamanina igira na manetabu aia e tau voligira. Mara tau goto kilia kara tsabiria niqira kao rongona na taovia tsapakae e tusuqolo vanigira nogo gana na mauri. ");
INSERT INTO gri_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma Josep e tsarivanigira na tinoni, “I kalina ia, inau au voligamu sui nogo ma nimui kao vania na taovia tsapakae. Migirani nogo na piuna sila vanigamu gana kamu tsukagira tana nimui uta. ");
INSERT INTO gri_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mi kalina ke laba na tagu na pipitsu, me sauba nimui aqo kamu sauvania na taovia tsapakae na tsegenina turina pipi na omea amu tsurivia. Migamu kamu adia na turina gana na tsutsuka ma gana na mutsa vanigamu ma nimui tamadale.” ");
INSERT INTO gri_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Migira ara tsaria, “Taovia, igoe o maurisigami mo dou sosongo vanigami, migami sauba kami lia moa nina tseka na taovia tsapakae.” ");
INSERT INTO gri_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ma Josep e moloa ke lia na ketsa tana kao popono ni Ejipt laka pipi tsegenina turina na omea ara tsurivia kara sauvania na taovia tsapakae ke tamanina. Ma na ketsa ia e tototu moa tsau mai i dani eni. Ma niqira butona kao lelê moa igira na manetabu ara tau lia nina tamani na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Igira na tinoni ni Israel ara totu i Ejipt tana butona kao ni Gosen, mi tana igira ara tamani omea levo danga mara danga bâ goto na daleqira. ");
INSERT INTO gri_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","A Jakob e mauri i Ejipt e sangavulu vitu na ngalitupa, poi e tsaulina kesa sangatu vati sangavulu vitu na ngalitupana. ");
INSERT INTO gri_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mi kalina e varangi nogo na mateana, maia e soâ a Josep me tsarivania, “Ko moloa na limamu i levugana na kakabaqu mo ko vekevaniau laka sauba ko tau qiluau inau ieni tana Ejipt. ");
INSERT INTO gri_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Au ngaoa ko qiluau inau tana ara qilugira na tamaqu; ko kalagailigiau tania i Ejipt mo ko ba qiluau i tana ara qilugira igira.” Ma Josep e tsaria, “Sauba kau naua na omea vaga igoe o tsaria.” ");
INSERT INTO gri_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma Jakob e tsaria, “Ko vekevaniau laka sauba ko nau mananâ.” Ma Josep e vekevania, me tû i nigena ma Jakob e soadoua na Taovia. ");
INSERT INTO gri_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kesa tana tagu i muri, mara tsarivania a Josep laka e lobogu na tamana. Maia e adikaira a Manase ma Epraim na dalena mara tu vano na reiana a Jakob. ");
INSERT INTO gri_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mi kalina ara turupatu vania a Jakob laka e mai a Josep na dalena na reiana, maia e berengiti na matemate me totu tû i nigena. ");
INSERT INTO gri_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma Jakob e tsarivania a Josep, “God Susuliga Sosongo e laba vaniau inau i Lus tana kao ni Kanaan me tabuau. ");
INSERT INTO gri_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Maia e tsarivaniau, ‘Inau sauba kau sauvanigo ke danga na dalemu, rongona igira na kukuamu kara lia na puku danga; me sauba kau sauvanigira na kukuamu na kao ieni ke lia na tamaniqira sailagi.’ ” ");
INSERT INTO gri_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Me goko babâ moa a Jakob me tsaria, “Igoe a Josep, kaira ruka na dalemu mane e vasuvanigo ko Asenat ieni tana Ejipt kalina inau au tau vati mai moa, i kaira ara ka niqu tamani nogo inau; kaira sui a Epraim ma Manase ara ka niqu nogo inau vaga saikesa nogo kaira a Ruben ma Simeon au vasukaira. ");
INSERT INTO gri_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Me ti vaga ko tamanigotoa ke visana na dalemu mane i muri, migoe nogo ko tamanigira; mi tana tangolidato omea igira, sauba ke talumai tana ka soaqira a Epraim ma Manase. ");
INSERT INTO gri_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Minau au gini naua na omea iani tana rongona nogo ko Ratsel na tinamu aia e mate taniau, minau au gini melu sosongo kalina aia e mate tana kao ni Kanaan e tau ao tania i Eprat kalina au vivisu mai talu i Mesopotamia, minau au qilua i tana liligina na sautu e vano kalea i Eprat.” Mi Eprat kalina ia i tana nogo ara soaginia i Betlehem. ");
INSERT INTO gri_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mi kalina a Jakob e morosikaira na dalena a Josep maia e veisuâ, “?Asei baka karani?” ");
INSERT INTO gri_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ma Josep e tuguvisua me tsaria, “I karani nogoria na dalequ inau aia God e saukaira vaniau ieni i Ejipt.” Ma Jakob e tsaria, “Ko adimaikaira i koniqu ma kau tabukaira.” ");
INSERT INTO gri_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ma Jakob e tau nogo moro maka rongona e tuqatuqa nogo, me tau tangomana ke moro dou sosongo. Ma Josep e adimaikaira na baka mane vania, maia e kasokaira me domikaira. ");
INSERT INTO gri_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ma Jakob e tsarivania a Josep, “Au tau saikesa padâ laka kau reigo tugua igoe, mi kalina ia ma God e tamivaniau kau reikaira goto na dalemu.” ");
INSERT INTO gri_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mi tana, ma Josep e sulutsunakaira na baka tania na kakabana a Jakob, me tsuporu tsuna i matana aia. ");
INSERT INTO gri_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Mi muri ma Josep e moloa a Epraim tana maulina a Jakob ma Manase tana madoana. ");
INSERT INTO gri_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma Jakob e molo ulutaligusia na limana, na madoana e moloa tana lovana a Epraim atsa moa ti aia na muritibaka, ma na maulina tana lovana a Manase, aia na baka botsaida. ");
INSERT INTO gri_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Maia e tabua a Josep me tsaria: “!Aia na God i kaira na tamaqu a Abraham ma Isaak ara ka aqo vania, ke tabukaira na baka karani! !God aia e tagaovia na mauriqu popono tsaumai i dani eni ke tabukaira! ");
INSERT INTO gri_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","!Ma na angelo aia e laumaurisiau inau tania na omea seko sui ke tabukaira! !Ma na soaqu inau ma ka soaqira kaira na tamaqu a Abraham ma Isaak ke totu mamauri ka koniqira na baka karani! !Ma kara ka tamani danga ka daleqira ma ka kukuaqira!” ");
INSERT INTO gri_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Me gini tau dou tobana a Josep kalina e morosia na tamana e moloa na limana madoa tana lovana a Epraim; maia e ba adiligia na limana madoa tamana tania na lovana a Epraim me laka ke molo bâ tana lovana a Manase. ");
INSERT INTO gri_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Me tsarivania na tamana, “E tau vaga ia mama. Iani nogo na baka botsaida; ko moloa na limamu madoa tana lovana aia.” ");
INSERT INTO gri_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maia na tamana e sove me tsaria, “Inau au dona dalequ, au dona. Igira na kukuana a Manase sauba kara lia goto na tinoni tangirongo. Maia bâ na kulana tetelo sauba ke tangirongo liuliu bâ vania aia, migira na kukuana aia sauba kara lia na puku loki.” ");
INSERT INTO gri_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Me vaga ia maia e tabukaira tana dani ia me tsaria, “Igira na Israel sauba kara gini aqo ka soamui kagamu kalina kara tû na aqosiana kesa na tabu. Sauba kara goko vaga iani, ‘God ke naua migoe ko vaga kaira a Epraim ma Manase.’ ” Mi tana nauvaganana ia, ma Jakob e moloa a Epraim ke ida vania a Manase. ");
INSERT INTO gri_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mi muri ma Jakob e tsarivania a Josep, “Vaga nogo igoe o morosia, inau e varangi nogo kau mate, ma God aia sauba ke totu kolugo me ke adivisugo tana niqira kao na mumuamu. ");
INSERT INTO gri_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Vanigo segeni nogo igoe, me tau vanigira na kulamu tavosi, inau au sauvanigo na Sekem, aia na butona kao lakatana dou bâ au laua i koniqira na Amor ginia niqu isi ma niqu parige.” ");
INSERT INTO gri_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ma Jakob e soasaigira na dalena mane sui me tsarivanigira, “Kamu mai tupolipoliau, minau kau katevulagi vanigamu na omea sauba ke laba vanigamu tana tagu ke mai i muri. ");
INSERT INTO gri_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Kamu saimai ma kamu rorongo igamu na dalena mane a Jakob. Kamu rongomia a Israel na tamamui. ");
INSERT INTO gri_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“A Ruben, igoe na dalequ botsaida, migoe nogo na susuligaqu Ma na kesanina dalequ kalina au mane vaolu moa, Migoe o kaekae mo susuliga liuliu bâ i laoqira na dalequ sui. ");
INSERT INTO gri_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Igoe o vaga na tatarina na obo loki, Me sauba ke utu vanigo nomoa ko tangirongo liuliu bâ, Rongona igoe o maturu kolua na tauqu lê Mo tau kukuni tania na nigena tamamu. ");
INSERT INTO gri_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Kaira a Simeon ma Levi e kesa atsa ka niqira sasaga. Kaira sui ara ka gini aqo ka niqira isi tana matesi tinoni. ");
INSERT INTO gri_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Minau e utu kau sangasage tana ka niqira togigoko segeni, Me utu goto kau sangakaira tana niqira gokosai, Rongona ara ka matesi tinoni tana kore Mara ka logusigira na buluka mane tana sinagi. ");
INSERT INTO gri_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Na vealagi ke gadovia ka niqira kore rongona e seko loki sosongo, Ma ka niqira momosatoba goto rongona ara ka vô saikesa na gaeana sa omea. Inau sauba kau sarangasigira tana kao popono ni Israel. Me sauba kau mologira kara totu piriutsa bamai i laoqira na tinoni. ");
INSERT INTO gri_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Migoe a Juda, igira na kulamu sauba kara tsonikaego. Igoe o birua na lioqira gamu gala. Migira na kulamu sauba kara tsuporu tsuna i matamu. ");
INSERT INTO gri_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","A Juda e vaga moa kesa na laeone, E matesia gana lamuta me visutugua tana babana, Mi tana e ba tsaro me mango. ?Masei sauba ke malagai na ba peleana? ");
INSERT INTO gri_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","A Juda sauba ke tangolikakaia nina itoro na taovia tsapakae, Migira na kukuana sauba kara tagao saviliu, poi tsau kalina ke laba mai na tamanina. Migira na puku tavosi sauba kara adimai vania niqira vangalaka, Ma kara rongomangana. ");
INSERT INTO gri_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Aia e soria nina dalena asi tana itai na uaeni, Tana itaina dou liuliu bâ. Maia e tsagia na polona tana kôna na uaeni e tsitsi vaga na gabu. ");
INSERT INTO gri_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","E tatave na gabu mauri tana matana rongona e inu uaeni, Mara viri sere na livona rongona e inu miliki. ");
INSERT INTO gri_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“A Sebulun sauba ke totu i liligina tasi. Nina tabana tasi sauba ke lia niqira mani tsoboravi na vaka. Ma nina butona kao sauba ke vosa bâ i Sidon. ");
INSERT INTO gri_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“A Isakar aia e kesa na asi susuliga, E tsaro katsikatsi i ka levugaqira ruka na todo gana na lutsa. ");
INSERT INTO gri_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mi kalina aia e reia laka e dou sosongo na nauna tana ke mango, Me laka e dou sosongo goto nina kao, Maia sauba ke ngolia na kalagai mamava, Ma kara turua ke aqo mala tseka. ");
INSERT INTO gri_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“A Dan sauba ke lia na manepede vanigira nina tinoni. Migira kara vaga goto igira na puku tavosi sui tana Israel. ");
INSERT INTO gri_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ma Dan sauba ke lia vaga na muata tana liligina sautu, Na muata vogata ligisana na sautu, Aia e laua na bobouna tuana na ose, Me gini pukavisu aia e sagekae i konina. ");
INSERT INTO gri_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Minau au pipitua moa kalina igoe Taovia ko maurisiau. ");
INSERT INTO gri_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“A Gad sauba kesa na alaala na tinoni vanga komi kara maiginia, Maia sauba ke pilovisu me ke takuvigira. ");
INSERT INTO gri_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ma nina kao a Aser sauba ke lakaga dou na mutsa i laona. Maia sauba ke aqosia na mutsa ke tugua na sauvaniana na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“A Naptali e vaga na dia, aia e ulo bamai Me tamani dalena rerei dou sosongo. ");
INSERT INTO gri_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“A Josep e vaga kesa na asi atsi liligina na vuravura, Me vaga na dalena asi atsi tana tetena. ");
INSERT INTO gri_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Igira gana gala ara baginikakaia Mara takuviginia niqira parige ma na pipili. ");
INSERT INTO gri_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ma nina parige aia e nari kalavatavia moa, Ma na kimana ara susuliga Ginia na susuligana nogo nina God Susuliga a Jakob, Ginia na Reitutugu Sipi Laka, aia niqira Reitutugu na Israel. ");
INSERT INTO gri_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Aia nogo nina God na tamamu e sangago igoe. Maia God Susuliga Sosongo e vangalaka vanigo Ginia nina vangalaka na usa talu i gotu Ma na kô mao e talu i vavana na kao, Gana kara gini danga nimu omea tuavati ma na dalemu, ");
INSERT INTO gri_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Na vangalaka na sila ma na latsena gai, Na vangalaka ara tsau bâ tana vungavunga saliu. Migira na omea dou sui ara totu tana tetena saliu. Migira sui na vangalaka girani kara totu vanigo igoe a Josep, Igoe o paladato i laoqira sui na kulamu. ");
INSERT INTO gri_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“A Benjamin e vaga kesa na pai atsi veveigâ. Tana matsaraka mi tana ngulavi aia e labumate me gania.” ");
INSERT INTO gri_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Igirani nogo na sangavulu ruka puku tana Israel, migirani goto nogo na omea e tsarivanigira na tamaqira kalina aia e goko me vailivugira pipi na dalena. ");
INSERT INTO gri_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mi muri, ma Jakob e ketsaligira na dalena vaga iani, “Kalina ia, e varangi nogo kau vano ma kau totu kolugira niqu tinoni tana mate. Au ngaoa kamu ba qiluau inau kolugira na tamaqu tana vatuluma e totu tana nina kao a Epron na Het ");
INSERT INTO gri_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","i Makpela, aia e totu pala longa vania i Mamre tana butona kao ni Kanaan. A Abraham nogo e volia na vatuluma ma na kao ia i konina a Epron gana na kao na qiluqilu. ");
INSERT INTO gri_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","I tana nogo ara qilukaira a Abraham ma ko Sara na tauna; i tana goto ara qilukaira a Isaak ma ko Rebeka na tauna; mi tana goto inau au qilua ko Lea. ");
INSERT INTO gri_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Na kao ia ma na vatuluma e totu i laona ara volia i koniqira na Het. Kamu qiluau inau i tana.” ");
INSERT INTO gri_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mi kalina a Jakob e goko sui vanigira na dalena, maia e tsaro visutugua i nigena me mate. ");
INSERT INTO gri_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ma Josep e puka kovoragi konina na tamana, me ngangai me domidomia na ngorana. ");
INSERT INTO gri_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mi muri ma Josep e ketsaligira kara aragoa na konina tamana me ke gini tau mabulu tsaku. ");
INSERT INTO gri_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","E adia e vati sangavulu na dani na taguna na aragoana na konina. Migira na Ejipt ara tangisia vitu sangavulu na dani. ");
INSERT INTO gri_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mi kalina e sui na tagu na tangitangi, ma Josep e tsarivanigira nina mane sasanga na taovia tsapakae, “Kiki, kamu adia na turupatu iani vania na taovia tsapakae: ");
INSERT INTO gri_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Kalina na tamaqu e vatsangia na mateana, aia e nongiau kau vekevania laka kau ba qilua tana vatuluma aia e vangaraua tana kao ni Kanaan. Me vaga ia, mo ko tamivaniau kiki kau vano ma kau qilua na tamaqu, mi muri ma kau visumaitugua.’ ” ");
INSERT INTO gri_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ma na taovia tsapakae e tuguvisua me tsaria, “E dou, ko vano mo ko qilua na tamamu vaga igoe o vekevaninogoa ko naua.” ");
INSERT INTO gri_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Me vaga ia, ma Josep e vano na qiluana na tamana. Migira sui lakalaka gana sasanga na taovia tsapakae, migira nina mane loki tana valena, migira sui goto na ida tana Ejipt ara dulikolua a Josep. ");
INSERT INTO gri_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nina tamadale popono, migira sui na kulana, migira sui tavosi goto tana valena tamana ara vano kolua. Igira moa na daleqira tetelo, ma niqira sipi, niqira naniqoti, ma niqira buluka ara totuvisu tana butona kao ni Gosen. ");
INSERT INTO gri_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mara dulikolugotoa visana mane ara sage tana terê, mara visana ara sagekae tana ose; igira kesa na tuqana na alaala loki. ");
INSERT INTO gri_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mi kalina ara mai tsau i Atad tana nauna gana na labududusi uiti i tabana i longa na Kô Jordan, migira ara tangitangi loki goto bâ me oka, maia Josep e aqosia kesa na mutsa kokolu i tana e vitu na dani. ");
INSERT INTO gri_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mi kalina igira na tinoni ni Kanaan ara reigira na tinoni girani ara tangitangi i Atad mara tsaria, “!Na mutsa kokolu gua vaga sagata ara naua na tinoni ni Ejipt girani!” Aia nogo na rongona te ara soaginia na nauana i tana Abel Misraim. ");
INSERT INTO gri_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Me vaga ia migira na dalena a Jakob ara naua na omea aia e ketsaliginigira; ");
INSERT INTO gri_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ara kalagaivanoa i Kanaan na konina mara ba qilua tana vatuluma i Makpela tabana i longa i Mamre, i laona na kao aia Ahraham e volinogoa konina a Epron na Het gana na kao na qiluqilu. ");
INSERT INTO gri_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mi murina kalina a Josep e qilu suia na tamana, maia e visutugua i Ejipt kolugira na kulana migira sui ara vano kolua na qiluqilu. ");
INSERT INTO gri_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mi murina na mateana na tamaqira, igira na kulana a Josep ara vaigokovigi segeni mara tsaria, “?Ke koegua vaga ti a Josep ke reisavigita moa me ke vorogokona na tangotuguna na omea seko sui igita a nauvania?” ");
INSERT INTO gri_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Me vaga ia, migira ara mologoko bâ vania a Josep mara tsaria, “Idavia na mateana na tamada, ");
INSERT INTO gri_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","aia e tsarivanigami kami nongigo igoe ti ko padalea na sasi igami na kulamu ami naua vanigo. Mi kalina ia, ami nongigo kiki ko padale vanigami na sasi igami nina maneaqo nina God na tamamu ami naunogoa vanigo.” Ma Josep e ngangai kalina e rongomia na goko vaga ia. ");
INSERT INTO gri_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Mi muri, migira segeniqira nogo na kulana ara mai mara tsuporu tsuna i matana mara tsaria, “Igami ami totu ieni i matamu igoe vaga nimu tseka.” ");
INSERT INTO gri_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Josep e tsarivanigira, “Kamu laka na matagu; e utu inau kau molo segeniqu tana sasana God. ");
INSERT INTO gri_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Igamu amu vorogokona na omea seko vaniau i sau, maia God e piloa me gini lia na omea dou, gana kara gini mauri danga na tinoni, igira ara mamauri i dani eni tana rongona nogo na omea e laba. ");
INSERT INTO gri_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Me tagara goto sa omea tugua kamu matagunia. Minau sauba kau reitutugugamu dou igamu migira goto na dalemui.” Me vaga ia, maia e vereginigira na goko dou me gini ragosia na tobaqira. ");
INSERT INTO gri_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","A Josep e mauri babâ moa i Ejipt kolugira nina tamadale na tamana; me tsaulina kesa sangatu sangavulu na ngalitupana kalina e mate. ");
INSERT INTO gri_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Maia e mamauri moa me reigira na dalena a Epraim migira goto na kukuana; me reigira goto na dalena a Makir aia na dalena mane a Manase kalina ara botsa i laona na valena. ");
INSERT INTO gri_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Maia e tsarivanigira na kulana, “Inau e varangi nogo kau mate, ma God sauba nomoa ke reitutugugamu me ke adirutsumigamu tania na kao iani ma kamu vano tana kao aia e vekevanitugira a Abraham ma Isaak ma Jakob.” ");
INSERT INTO gri_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mi muri, ma Josep e nongigira nina tinoni kara aqosia kesa na veke me tsaria, “Kamu vekevaniau inau laka kalina God ke adivanogamu tana kao ia, migamu sauba kamu adia na koniqu inau kolugamu.” ");
INSERT INTO gri_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Me vaga ia ma Josep e mate i Ejipt kalina e tsaulia kesa sangatu sangavulu na ngalitupana. Migira ara aragoa na konina rongona ke gini tau mabulu, mara molotsavua i laona kesa na kesi.");
INSERT INTO gri_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Tugira sui na dalena a Jakob ara tu vano kolua tu tamaqira i Ejipt, pipi kesa kolua nina tamadale segeni, tugira nogo: ");
INSERT INTO gri_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","a Reuben, ma Simeon, ma Levi, ma Juda, ");
INSERT INTO gri_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ma Isakar, ma Sebulun, ma Benjamin, ");
INSERT INTO gri_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ma Dan, ma Naptali, ma Gad, ma Aser. ");
INSERT INTO gri_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","E saisai na dangaqira na kukuana segeni nogo a Jakob mara tsaulia e vitu sangavulu. Maia Josep na dalena e totu nogo i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Me visana tana tagu i muri, ma Josep, migira na kulana, migira sui goto na kukuana a Jakob, igira ara dulikolumaia i Ejipt, ara mate sui. ");
INSERT INTO gri_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ma na kukuaqira, igira nogo na Israel, ara vasusu babâ moa mara gini danga sosongo, mara dato susuliga, mara dangali poponoa na Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mi muri, me tû kesa na taovia tsapakae vaolu tana Ejipt, maia e tau donaginia a Josep. ");
INSERT INTO gri_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Maia e tsarivanigira nina tinoni, “Igira na tinoni ni Israel girani ara danga sosongo mara dato susuliga, me tau utu kara tû ma kara alomaia na omea seko vanigita igita. ");
INSERT INTO gri_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Me ti vaga tana vailabu me tau utu kara ba sai kolugira gada gala, ma kara labugita ma kara tsogo tania na verada. Nida aqo igita ka lavea ke visana sautu gana ka naua ma kara gini tau danga sosongo vaga ia.” ");
INSERT INTO gri_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Bâ, mi tana migira na Ejipt ara mologira visana na mane kara turugira na Israel tana aqo mala tseka, gana kara gini bingi sekoligira. Mi tana tagu nogo ia migira nogo na Israel ara logokaira na verabau ni Pitom mi Rameses vania na taovia tsapakae gana nina vera na mololakâ omea levolevo. ");
INSERT INTO gri_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Me atsa moa igira na Ejipt ara rotasi sosongoligira na Israel, migira ara pabo sosongo goto bâ tana dangaqira, mara totuvibamaia na kao popono. Migira na Ejipt ara tuturiga na mataguniaqira na Israel, ");
INSERT INTO gri_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","te ara tû, mara turu sosongoligira kara aqo kakai bâ tana logovale, mi tana aqo uta, mara tau goto gaegira. ");
INSERT INTO gri_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mi muri, ma na taovia tsapakae ni Ejipt e goko vanikaira ko Sipra ma ko Pua, i kaira ruka na daki gana na adivasusuqira na daki ni Hibru, ");
INSERT INTO gri_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","me tsarivanikaira, “Ti vaga kalina amu ka ba adivasusuna sa daki ni Hibru ma kamu ka reia ke baka mane, ka nimui aqo kamu ka matesi saviliua; me ti vaga ke baka daki ma kamu ka moloa ke mauri.” ");
INSERT INTO gri_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mi kaira na daki gana na adivasusu ara ka matagunia God, mara ka tau goto rongomangana na taovia tsapakae, mara ka mologira kara mauri goto igira na baka mane. ");
INSERT INTO gri_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Me vaga ia, ma na taovia tsapakae e soamaikaira na daki adivasusu me veisuakaira, “?Rongona gua ti amu ka nauvaganana ia? ?Rongona gua ti amu ka mologira kara mauri moa igira na baka mane?” ");
INSERT INTO gri_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mi kaira ara ka gokovisu vania mara ka tsaria, “Igira na daki ni Hibru ara tau vaga na daki ni Ejipt; igira ara susuliga mara dona na vasusu tsaku sosongo, mara botsa nogo na daleqira ti ke ba laba sa ka vidamami kagami i tana.” ");
INSERT INTO gri_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Mi tana rongona kaira na daki na adivasusu ara ka matagunia God, ma God e dou vanikaira mara ka tamani ka valeqira segeni. Migira na tinoni ni Israel ara dadanga babâ moa mara dato susuliga. ");
INSERT INTO gri_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mi tana susuina, maia na taovia tsapakae e moloketsa kakai vanigira nina tinoni sui lakalaka me tsarivanigira: “Kamu adigira pipi na baka mane botsa vaolu i laoqira na Hibru, ma kamu tsoni luvusigira tana Kô Nile, migira sui moa na baka daki kamu mologira kara mauri.” ");
INSERT INTO gri_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mi tana tagu ia, me kesa na mane tana puku konina a Levi e taugâ kesa na baka daki tana nina puku segeni, ");
INSERT INTO gri_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","maia e vasuvania kesa na dalena mane. Mi kalina aia e reia laka na baka mane ia e rerei dou sosongo, maia e molopoia i laona e tolu na vula. ");
INSERT INTO gri_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mi kalina e tau goto tangomana na molopoiana, maia e tû me adia kesa na kei e vosiginia na asa me titâ gana ke gini tau sage na kô i laona. Me molosagea na baka i laona, me ba moloa i laona na gaugau tana liligina kô. ");
INSERT INTO gri_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ma na tasina daki na baka mane ia e tutû ao tetelo moa gana ke morosia na omea gua ke laba vania na baka ia. ");
INSERT INTO gri_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ma na dalena daki na taovia tsapakae e mai na leso i kô, migira nina daki aqo ara tataonia na liligina kô. Maia e moro bâ me reia kesa na kei i laoqira na gaugau, me molovanoa kesa nina daki tseka ke ba adimaia vania. ");
INSERT INTO gri_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ma na dalena na taovia tsapakae e sangavia na kei, me reia kesa na baka mane e totu i laona. Ma na baka ia e ngangai, maia e galuve sosongolia me tsaria, “Na baka iani e kesa na baka mane ni Hibru.” ");
INSERT INTO gri_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mi tana, me mai laba na tasina daki na baka ia me veisuâ, “?Egua, laka o ngaoa kau ba soamaia sa daki ni Hibru ke tsutsuvanigo na baka iani?” ");
INSERT INTO gri_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Maia e tuguvisua me tsaria, “Eo kiki, ko bâ.” Me tû na baka daki ia me vano, me soamaia na tinana segeni nogo na baka mane ia. ");
INSERT INTO gri_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Maia na dalena daki na taovia tsapakae e tsarivania, “Ko adia na baka iani mo ko tsutsuvaniau inau, minau sauba kau voligo.” Me vaga ia, maia e adia na baka me tsutsua. ");
INSERT INTO gri_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mi muri, kalina e pasa nogo na baka ia, ma na tinana e adi bâ vania na dalena na taovia tsapakae, maia e tabevaganana moa laka na dalena segeni. Maia e tsarisegenina, “Inau au tsebadatoa tania na kô, me vaga ia minau au soaginia a Moses.” ");
INSERT INTO gri_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mi kalina e loki nogo a Moses, maia e vano na tsigoviaqira na tinoni ni verana igira na Hibru, me reia niqira rota ma na aqo kakai ara turuginigira kara naua. Me reigotoa kalina kesa na mane ni Ejipt e labumatesia kesa na Hibru, aia e kesa gana verakolu segeni nogo a Moses. ");
INSERT INTO gri_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ma Moses e moro bamai, mi kalina e reia laka e tau goto momoromai ke kesa, maia e tû me labumatesia na mane ni Ejipt, me qilupoia na konina i laona na one. ");
INSERT INTO gri_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mi tana dani ngana, maia e visutugua i tana, me reikaira ruka na mane ni Hibru ara ka vailabugi. Me tsarivania na mane aia e sasi, “?Rongona gua ti o labua na kulamu?” ");
INSERT INTO gri_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ma na mane ia e tsarivania a Moses, “?Asei e tsarivanigo igoe ko tagaovigami mo ko pede vanigami igami? ?Laka sauba ko labumatesiau goto inau vaga o labumatesinogoa na mane ni Ejipt ia?” Mi tana, ma Moses e gini matagu me tsarisegenina, “Na tinoni ara tsodovulaginogoa na omea au naua inau.” ");
INSERT INTO gri_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Mi kalina na taovia tsapakae e rongomia na omea vaga ia e laba, maia e lave sautuna na matesiana a Moses, ma Moses e tsogo me ba totu tana kao ni Midian. Me kesa dani, kalina a Moses e tototu i ligisana kesa na tuvu, mara tu labamai tu vitu na dalena daki a Jetro na manetabu ni Midian, ara tu mai na sao kô, ma na dangaliana niqira omea agana na mani inu igira nina sipi ma nina naniqoti tu tamaqira. ");
INSERT INTO gri_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mara mai goto visana na mane reitutugu sipi mara tsialigigira na dalena a Jetro. Mi tana, ma Moses e tû me ba sangatugira na baka daki, me sau gaqira kô tu niqira omea tuavati. ");
INSERT INTO gri_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mi kalina tugira na baka daki ara tu visu bâ i vera ma Jetro tu tamaqira e veisuatugira, “?Rongona gua ti amu tu visumai tsaku sosongo i dani eni?” ");
INSERT INTO gri_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Mara tu tsaria, “E kesa na mane ni Ejipt e isutugutugami kalina igira na mane pitusipi ara tsialigitugami, me ba sao kô vanitugami, me saogotoa gagira kô tu nimami omea tuavati.” ");
INSERT INTO gri_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Maia e veisuatugira na dalena, “?Miava ia? ?Rongona gua ti amu tu molovania moa na mane ia ke totu i tana? Kamu tu bâ ma kamu tu tsarivania ke mai me ke sanga mutsa kolugita.” ");
INSERT INTO gri_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Me vaga ia, ma Moses e mai me sanga mutsa kolugira, me tamigotoa na totu i tana kolugira, maia Jetro e sauvania a Moses ko Sipora ke taugâ, ");
INSERT INTO gri_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","maia e vasuvania a Moses kesa na dalena mane. Ma Moses e tsarisegenina, “Inau na tinoni labavô tana vera iani, me vaga ia minau kau soaginia a Gersom.” ");
INSERT INTO gri_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Me visana na ngalitupa i muri, ma na taovia tsapakae ni Ejipt e mate, migira na Israel ara rota babâ moa tana aqotseka mara ngangai dato vania God ke sangagira. ");
INSERT INTO gri_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ma God e rongomia niqira kukungu me padavisua nina vaitasogi e naua i sau kolutugira a Abraham, ma Isaak ma Jakob. ");
INSERT INTO gri_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Maia e reia niqira rota na Israel tana totutseka me galuvegira. ");
INSERT INTO gri_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Me kesa dani kalina a Moses e reitutugugira nina sipi ma nina naniqoti a Jetro, aia na tamana na tauna ma na manetabu ni Midian, ma Moses e tudumivanogira tana kaomate, me bâ tsau tabana bâ i tuana Sinai aia na vungavunga tabu. ");
INSERT INTO gri_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mi tana e kesa nina angelo na Taovia e labavania tana rereina na lapina lake e irudato i levugana kesa na gai tetelo. Ma Moses e rei bâ na gai e iruiru rago, ma na lake ia e tau moa gania na gai. ");
INSERT INTO gri_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Me papada dodo moa i tobana, “?Ae, nagua vaga ia? ?Matena gua na gai ia e iruiru me tau moa gania na lake? Sauba kau garu bâ varangisia ma kau morosidoua.” ");
INSERT INTO gri_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mi kalina na Taovia e morosia laka a Moses e garumai varangi, maia e gokomai vania i laona na gai me tsaria, “!A Moses igoe! !A Moses igoe!” Ma Moses e gokovisu me tsaria, “Eo, inau ieni.” ");
INSERT INTO gri_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ma God e tsarivania, “Ko laka goto na mai varangi. Ko nusiligia gamu porotua, rongona na kao tana o tû kalina ia na kao tabu. ");
INSERT INTO gri_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Inau niqira God na mumuamu, tu niqira God a Abraham, ma Isaak ma Jakob.” Mi tana ma Moses e tsavupoia na matana rongona e matagunia na moro bâ i konina God. ");
INSERT INTO gri_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mi muri ma na Taovia e tsarigotoa, “Inau au reinogoa na rota loki e gadovigira niqu tinoni tana Ejipt; mau rongomia niqira ngangaidato vaniau kau laumaurisigira tania na limaqira igira ara turugira tana aqo mala tseka. Au donagininogoa pipi sui lakalaka na rota loki e gadovigira, ");
INSERT INTO gri_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","maia nogoria na rongona ti au gini tsunamai kau laumaurisigira tania na limaqira igira na Ejipt, ma kau adirutsumigira tania na kao ia, ma kau adibagira kesa tana kao lakatana me vuaga dou, i tana ara totu kalina eni igira na tinoni ni Kanaan, mi Het, mi Amor, mi Peres, mi Hivi, mi Jebus. ");
INSERT INTO gri_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Au rongomi mananâ niqira ngangaidato igira niqu tinoni, mau reinogoa laka igira na Ejipt ara bingi sekoligira sosongo. ");
INSERT INTO gri_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mi kalina ia inau au molovanogo igoe i konina na taovia tsapakae ni Ejipt rongona ko gini adirutsumigira niqu tinoni tania na verana.” ");
INSERT INTO gri_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ma Moses e tsarivania God, “?Masei gana lakana inau ti kau bâ i konina na taovia tsapakae ma kau adirutsumigira na tinoni ni Israel tania na Ejipt?” ");
INSERT INTO gri_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ma God e tuguvisua vania me tsaria, “Inau nogo sauba kau totu kolugo igoe, mi kalina ko adirutsumigira na tinoni tania na Ejipt, me sauba ko mai samasama vaniau inau tana vungavunga iani. Maia nogo ke saumakali vanigo laka inau nogo au molovanogo.” ");
INSERT INTO gri_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ma Moses e tsarivania, “Me ti vaga kalina inau kau ba laba i koniqira na tinoni ni Israel ma kau tsarivanigira, ‘Aia nogo niqira God na mumuamui e molomaiau i konimui,’ migira kara tû ma kara veisuaau, ‘?Masei na asana aia?’ ?Mi tana ma nagua sauba inau kau tsarivanigira?” ");
INSERT INTO gri_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ma God e tsarivania a Moses, “Inau nogo aia inau. Miani nogo e vaga na goko nimu aqo ko tsarivanigira: ‘Aia ara soaginia INAU NOGO aia nogo e molomaiau vanigamu.’ ");
INSERT INTO gri_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ko tsarivanigira na tinoni ni Israel laka inau, na Taovia niqira God igira na mumuaqira, ma tu niqira God a Abraham, ma Isaak ma Jakob, au mologo bâ vanigira. Iani nogo na asaqu na dani ma na dani; maia nogoria kara soaginiau vaga igira na vatavata sui kara botsamai i muri. ");
INSERT INTO gri_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ko bâ, mo ko soasaigira igira sui na ida tana Israel, mo ko tsarivanigira laka inau na Taovia niqira God na mumuaqira, tu niqira God a Abraham, ma Isaak ma Jakob au laba vanigo. Mo ko tsarivanigira laka au mai laba nogo i koniqira, mau reinogoa na omea seko igira na tinoni ni Ejipt ara nauvanigira. ");
INSERT INTO gri_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Minau au padâ kau adiligigira tania na Ejipt i tana ara rotasi sekoligira sosongo, ma kau adivanogira kesa tana kao lakatana me vuaga dou, niqira kao igira na tinoni ni Kanaan, mi Het, mi Amor, mi Peres, mi Hivi, mi Jebus. ");
INSERT INTO gri_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Migira niqu tinoni sauba kara rongomivatavia na omea ko tsarivanigira. Mi muri, ma nimu aqo igoe ti ko vano kolugira na ida tana Israel, ma kamu ba laba i konina na taovia tsapakae ni Ejipt mo ko tsarivania, ‘Na Taovia, aia niqira God na Hibru, e labavulagi vanigami nogo. Mi kalina ia, me dou ti ko tamivanigami kami vavano tugua ke tolu na dani tana kaomate ma kami savori-kodoputsa vania na Taovia nimami God.’ ");
INSERT INTO gri_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Minau au donanogoa laka na taovia tsapakae ni Ejipt sauba e utu ke tamivanigamu kamu vano ti ke tagara ke kesa ke susuliga liusia aia ke turua. ");
INSERT INTO gri_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Minau sauba kau gini aqo na susuligaqu loki ma kau kedeginigira na tinoni ni Ejipt tana nauana na omea mataguniga sosongo i tana. Mi murina ia, maia sauba ke tamivanigamu na vano. ");
INSERT INTO gri_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Me sauba kau naua ma kara kukuni tanigo igoe igira na Ejipt, rongona kalina niqu tinoni kara vangaraua na mololeana i tana me sauba e utu kara vano kolua na tuaqira ma na limaqira lê moa. ");
INSERT INTO gri_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Sauba pipi na daki ni Israel ke bâ i koniqira na kulana na daki ni Ejipt, se sa daki ni Ejipt moa e totu i laona na valena, me ke nongia i konina na polona ma na inilau qolumila ma na siliva. Migira na Israel sauba kara sagelivanigira na daleqira mane ma na daleqira daki na omea girani, ma kara kalagaivanogira niqira omea levolevo loki matena igira na tinoni ni Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mi muri, ma Moses e tsarivania na Taovia, “?Me ti vaga igira na tinoni ni Israel kara tau tutuniqu inau ma kara sove na rongomiana na omea kau tsaria, ma nagua kau naua inau ti vaga igira kara tsaria laka o tau laba vaniau igoe?” ");
INSERT INTO gri_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ma na Taovia e veisuâ, “?Nagua o tatangolia tana limamu?” Ma Moses e tsaria, “E kesa na itoro.” ");
INSERT INTO gri_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ma na Taovia e tsarivania, “Ko tsonitsunâ tana kao.” Mi kalina a Moses e tsonitsunâ, ma na itoro ia e oli me lia na muata, maia Moses e tsogo tania. ");
INSERT INTO gri_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mi muri, ma na Taovia e tsarivania a Moses, “Ko gogoro tsuna mo ko tangolia na kalina.” Ma Moses e gogoro tsuna me laua na kalina, ma na muata e oli me lia tugua na itoro. ");
INSERT INTO gri_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ma na Taovia e tsaria, “Ko nauvaganana iani gana ko gini sauvulagi vanigira na tinoni ni Israel laka na Taovia niqira God na mumuaqira, tu niqira God a Abraham, ma Isaak ma Jakob, aia nogo e laba vanigo.” ");
INSERT INTO gri_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ma na Taovia e goko vanitugua a Moses me tsaria, “Ko molosagea na limamu tana polomu.” Ma Moses e naua vaga aia e tsaria; mi kalina e adirutsumia na limana, me totu kesa na lobogu tana kimana, e tovuli poponoa na tuputupu sere vaga moa ti na “snou”. ");
INSERT INTO gri_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mi muri ma na Taovia e tsarivania, “Ko molosagetugua na limamu tana polomu.” Maia e naua, mi kalina e adirutsumia na limana me dou visutugua vaga moa na konina popono. ");
INSERT INTO gri_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ma na Taovia e tsaria, “Me ti vaga igira kara tau tutunimu, se kara tau padarongona na kesanina valatsatsa, ma na rukanina valatsatsa iani sauba kara gini tutunimu. ");
INSERT INTO gri_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Me ti vaga igoe ko naukaira ruka na valatsatsa karani, migira kara tau vati tutunimu moa, se kara sove na rongomiana na omea o tsaria, ko tû mo ko ba saoa na kô tana Nile, mo ko qetua tana kao mamatsa, ma na kô ia sauba ke lia na gabu.” ");
INSERT INTO gri_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Maia Moses e tsaria, “Tagara, Taovia, ko laka na molovanoaqu inau. Au tau saikesa dona na goko dou tû mai nogo i sau me tsau mai i dani eni, atsa moa igoe o goko vaniau. Inau au kisa sosongo mau kamatatu moa tana goko.” ");
INSERT INTO gri_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ma na Taovia e tsarivania, “?Asei e sauvania na tinoni na mangana? ?Masei e naua me gini mui kulina me bulu lapina? ?Masei goto e naua me gini momoro se e gini koko? Inau nogo na Taovia au naua. ");
INSERT INTO gri_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","!Mi kalina ia, igoe ko vano moa! Minau sauba kau sangago tana goko, ma kau tsarivanigo na omea ko tsaria.” ");
INSERT INTO gri_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ma Moses e tuguvisua me tsaria, “Tagara, Taovia, kiki ko molovanoa ke kesa segeni.” ");
INSERT INTO gri_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mi tana, ma na Taovia e kore vania a Moses me tsaria, “?Megua a Aaron na kulamu igoe, aia na Levi? Inau au donaginia laka a Aaron e dona dou na goko. Maia nogoria e maimai nogo i sautu na valaleamu igoe, me sauba ke gini mage na reiamu. ");
INSERT INTO gri_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Me dou moa ti ko goko vania mo ko tsarivania na omea aia ke tsaria. Minau sauba kau sangakagamu sui tana goko, ma kau tsarivanikagamu na omea au ngaoa kamu ka naua. ");
INSERT INTO gri_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A Aaron sauba ke lia nimu mane adigoko, maia ke goko vanigira na tinoni tugumu igoe. Mi tana migoe sauba ko lia vaga God vania, rongona sauba ko tsarivulagi vania na omea sui aia ke tsaria. ");
INSERT INTO gri_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ko adia na itoro iani; rongona aia nogo sauba ko gini aqosi valatsatsa.” ");
INSERT INTO gri_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mi muri, maia Moses e visu bâ i konina a Jetro na tamana na tauna me tsarivania, “Kiki ko tamivaniau moa inau ma kau visu bâ tana Ejipt i koniqira na kamaqu, ma kau ba reigira ti vaga ara mamauri moa.” Ma Jetro e tamivania maia e vailivua. ");
INSERT INTO gri_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mi kalina a Moses e tototu moa i Midian ma na Taovia e tsarivania, “Ko visutugua tana Ejipt rongona igira sui ara ngaoa na labumatesiamu igoe ara viri mate sui nogo.” ");
INSERT INTO gri_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Me vaga ia, ma Moses e tû me adia na tauna mi kaira na dalena, me molokaetugira tana gotuna na asi, me vano kolutugira i Ejipt, maia e tangolia na itoro aia God e tsarivaninogoa ke adia. ");
INSERT INTO gri_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ma na Taovia e goko vanitugua a Moses me tsaria, “Kalina ia igoe o vivisutugua tana Ejipt, mi kalina ko ba laba i tana ma nimu aqo igoe ko naugira i matana na taovia tsapakae na valatsatsa sui inau au saunogoa vanigo na susuliga gana na nauana. Minau sauba kau naua me ke tsatsarae sosongo na taovia tsapakae, me ke tau tamivanigira na tinoni kara vano. ");
INSERT INTO gri_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mi tana migoe nimu aqo ko tsarivania laka inau na Taovia au tsaria, ‘Israel aia na dalequ mane botsaida. ");
INSERT INTO gri_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Inau au tsarivanigo nogo ko tamivania na dalequ ke vano rongona aia ke gini samasama vaniau, migoe o tau tamivania. Mi kalina ia inau sauba kau labumatesia na dalemu mane botsaida segeni nogo igoe.’ ” ");
INSERT INTO gri_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mi tana nauna ara ba mango kalina ara vavano i Ejipt, na Taovia e ba tsodoa a Moses me tovoa ke labumatesia. ");
INSERT INTO gri_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Maia ko Sipora na tauna e adia kesa na vatu vavanga me pariligia na kokorana na mutsuna na dalena mane, me peleginia na tuana a Moses. Maia e padâ moa na rongona na paripapadana me tsarivania a Moses, “Igoe na savana na gabu vaniau inau.” Me vaga ia, ma na Taovia e gaetugua na maurina a Moses. ");
INSERT INTO gri_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mi tana tagu goto ia, ma na Taovia e tsarivania a Aaron “Ko vano tana legai mate mo ko ba tsodoa a Moses.” Maia e tû me ba tsodoa a Moses tana vungavunga tabu; mi kalina e tsodoa maia e domia. ");
INSERT INTO gri_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mi muri, ma Moses e turupatu vania a Aaron pipi sui na omea aia na Taovia e tsarivaninogoa kalina aia e raia ke visutugua i Ejipt; me turupatu vanigotoa tana rongoqira na valatsatsa aia na Taovia e ketsalia ke naua. ");
INSERT INTO gri_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Me vaga ia mi kaira a Moses ma Aaron ara ka vano i Ejipt, mara ka ba soasaigira pipi sui gaqira ida na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Maia Aaron e turupatuna vanigira pipi sui na omea na Taovia e tsarivania a Moses, mi muri, ma Moses e naugira pipi sui na valatsatsa i mataqira na tinoni. ");
INSERT INTO gri_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Migira ara tutunina, mi kalina ara rongomia laka na Taovia e mai nogo i koniqira me reisuinogoa niqira rota loki, migira ara tsuporu tsuna mara samasama. ");
INSERT INTO gri_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mi muri, mi kaira a Moses ma Aaron ara ka vano i konina na taovia tsapakae, mara ka tsarivania, “Na Taovia na God ni Israel e tsaria, ‘Ko tamivanigira niqu tinoni kara vano, rongona kara gini lokisia niqu bongi tabu tana kaomate gana kara padalokiginiau.’ ” ");
INSERT INTO gri_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ma na taovia tsapakae e veisuakaira, “?Asei vaga na Taovia? ?Rongona gua ti kau rongomangana aia ma kau tamivanigira na Israel kara vano? Inau au tau donaginia na Taovia; me sauba e utu goto kau tamivanigira na Israel kara vano.” ");
INSERT INTO gri_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mi kaira a Moses ma Aaron ara ka gokovisu mara ka tsaria, “Niqira God na Hibru e labavanigami nogo. Ko tamivanigami ma kami vavano ke tolu na dani tana kaomate ma kami savori-kodoputsa vania na Taovia nimami God. Me ti vaga kami tau naua, maia sauba ke matesiginigami na lobogu se tana vailabu.” ");
INSERT INTO gri_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ma na taovia tsapakae e tsarivanikaira a Moses ma Aaron, “?Rongona gua ti amu ka ngaoa na adiligiaqira na tinoni tania niqira aqo? !Kamu ka raigira kara visutugua tana niqira aqo! ");
INSERT INTO gri_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Igamu na Israel amu danga bâ liusigami igami na Ejipt. !Mi kalina ia, mamu ngaogotoa kamu mango tana aqo!” ");
INSERT INTO gri_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mi tana dani nogo ia, ma na taovia tsapakae e tû, me ketsaligira igira ara turugira na tseka tana aqo, migira goto na mane ni Israel ara reitutugua na vavanona na aqo me tsarivanigira, ");
INSERT INTO gri_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kamu laka goto na sauvaniaqira na tinoni na buruburu makede gana na aqosi briki. Kamu raigira kara vano segeniqira na laveana. ");
INSERT INTO gri_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ma kamu turugira kara aqosigira na dangana na briki ke atsa vaga moa tana idana, me ke laka goto nanga sa tsotsoko. !E tau ngatsu tugugira niqira aqo, aia nogo na rongona ti ara maimai moa na veisuaqu inau kau tamivanigira ma kara vano na savori-kodoputsa vaniana niqira God! ");
INSERT INTO gri_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kamu raigira na mane girani kara aqo kakai goto bâ rongona kara gini boe moa na aqo, ma kara gini tau tamani tagu na rongomiaqira na goko peropero danga sosongo vaga ia.” ");
INSERT INTO gri_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Migira na mane ara turugira na tseka tana aqo, migira goto na mane ni Israel ara reitutugu aqo, ara ba tsarivanigira na tinoni ni Israel, “Na taovia tsapakae e tsaria laka sauba e utu goto ke manogati vanigamu sa buruburu makede. ");
INSERT INTO gri_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Maia e tsaria laka nimui aqo nogo igamu kamu vano ma kamu lave segenia na buruburu iava moa amu tangomana na tsodoana, ma nimui aqo kamu aqosigira na briki ke danga atsa vaga goto moa tana idana.” ");
INSERT INTO gri_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Me vaga ia, migira na tinoni ara liuvi poponoa na Ejipt na lave buruburu makede. ");
INSERT INTO gri_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Migira na mane ara turugira na tseka tana aqo ara turugira babâ moa kara aqosia pipi dani na briki ke atsa kolua moa na dangana ara aqosia kalina ara adimanogati vanigira na buruburu makede. ");
INSERT INTO gri_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Migira na mane ni Ejipt igira ara turugira na tseka tana aqo ara rarusigira na mane ni Israel ara reitutugu aqo. Mara goraragira mara tsaria, “?Rongona gua ti igamu amu tau aqosigira na briki ke danga vaga tana idana?” ");
INSERT INTO gri_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mi tana, migira na Israel ara reitutugu aqo ara tû, mara ba laba i konina na taovia tsapakae mara veisuâ, “?Taovia, rongona gua ti o nauvaganana vanigami ia? ");
INSERT INTO gri_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","!Igira nimu tinoni igoe ara tau sauvanigami sa buruburu makede, mara raigami moa kami aqosigira na briki kara danga atsa vaga moa tana idana! Mi kalina ia ara rarusigami goto, ma niqira sasi nogo igira nimu tinoni igoe.” ");
INSERT INTO gri_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ma na taovia tsapakae e tuguvisua me tsaria, “Igamu amu gato moa mamu tau moa ngaoa na aqo, maia nogoria na rongona ti amu nongiau inau kau tamivanigamu ma kamu vano na savori-kodoputsa vaniana na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","!Bâ, mi kalina ia kamu visutugua tana aqo! Me utu saikesa kara tusuvanigamu sa buruburu makede, ma nimui aqo nomoa kamu aqosigira na briki kara danga atsa vaga moa tana idana.” ");
INSERT INTO gri_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Migira na mane ni Israel ara reitutugu aqo ara vasini padagadovia laka ara totu vania na rota loki, kalina ara tsarivanigira laka niqira aqo kara aqosigira pipi dani na briki ke atsa kolua na dangana vaga nogo ara aqosia tana idana. ");
INSERT INTO gri_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mi kalina ara mololea na taovia tsapakae, mara ba tsodokaira a Moses ma Aaron ara ka pipitugira i sautu. ");
INSERT INTO gri_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Mara tsarivanikaira a Moses ma Aaron, “Na Taovia e morosinogoa na omea amu ka tsukia kagamu me sauba aia ke kedekagamu, rongona kagamu nogo amu ka naua maia na taovia tsapakae migira nina mane sasanga ara gini reisavi sosongoligami igami. Mi kagamu goto nogo amu ka nausautuna vanigira gana kara matesigami.” ");
INSERT INTO gri_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mi tana, ma Moses e pilo bâ tugua konina na Taovia me tsaria, “?Taovia, rongona gua ti o rotasi sosongoligira nimu tinoni? ?Me rongona gua goto te o molomaiau inau ieni? ");
INSERT INTO gri_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tuturiga kalina au ba laba inau i konina na taovia tsapakae mau goko tugumu igoe, aia e rotasi sosongoligira goto bâ nimu tinoni. !Migoe o tau lelê naua sa omea ko sangaginigira!” ");
INSERT INTO gri_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ma na Taovia e tsarivania a Moses, “I kalina ia sauba igoe ko morosia na omea inau sauba kau nauvania na taovia tsapakae. Inau sauba kau turua me ke tamivanigira niqu tinoni kara vano. Eo, sauba inau kau turuginia nomoa ke tsialigigira tania nina kao.” ");
INSERT INTO gri_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ma God e gokovanigotoa a Moses me tsaria, “Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Inau nogo au labavanitugira a Abraham, ma Isaak, ma Jakob vaga na God Susuliga Sosongo, mau tau moa tsarivulagi vanitugira na asaqu tabu, aia nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Au aqosigotoa kesa na vaitasogi kolutugira, mau vekevanitugira laka sauba kau sauvanitugira na kao ni Kanaan, na kao aia i tana igira ara tototu vaga moa na tinoni labana. ");
INSERT INTO gri_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Mi kalina ia, inau au rongominogoa niqira kukungu igira na Israel, igira na Ejipt ara mala tsekagira, mau padavisutugua niqu vaitasogi au naunogoa kolugira. ");
INSERT INTO gri_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Me vaga ia, migoe ko bâ mo ko tsarivanigira na tinoni ni Israel laka inau au tsarivanigira na goko iani, ‘Inau na Taovia; inau nogo sauba kau laumaurisigamu ma kau nusigamu tania nimui totu tseka vanigira na Ejipt. Inau sauba kau saukaea na limaqu susuliga ma kau kede kakaigira igira, ma kau maurisigamu igamu. ");
INSERT INTO gri_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Inau sauba kau naua migamu kamu lia niqu tinoni segeni, minau kau lia nimui God. Igamu sauba kamu donaginia laka inau na Taovia nimui God kalina kau nusigamu tania na totu tseka i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Sauba kau adibagamu tana kao au vatsanogoa laka kau sauvanitugira a Abraham, ma Isaak ma Jakob; minau sauba kau saua vanigamu ke lia na tamanimui segeni, inau nogo na Taovia.’ ” ");
INSERT INTO gri_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ma Moses e ba tsarivulagi vanigira na tinoni ni Israel na omea iani, migira ara tau ngaoa na rongomiana, matena e gini ponopala sosongo nogo na tobaqira tana rota loki na aqo tseka. ");
INSERT INTO gri_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Mi muri, ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ko bâ mo ko tsarivania na taovia tsapakae ni Ejipt laka nina aqo nomoa ke tamivanigira na tinoni ni Israel kara mololea na verana.” ");
INSERT INTO gri_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ma Moses e tsaria, “?Atsa moa igira na Israel, migira ara tau ngaoa na rongomangaqu inau, me kegua vaga ti ke rongomangaqu inau na taovia tsapakae ni Ejipt? Inau au tau tangomana na goko dou.” ");
INSERT INTO gri_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ma na Taovia e ketsalikaira a Moses ma Aaron me tsaria: “Kamu ka bâ tsarivanigira na tinoni ni Israel me vanigotoa na taovia tsapakae laka inau nogo au raikagamu kamu ka adirutsumigira na tinoni ni Israel tania na Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","A Reuben, aia na dalena mane botsaida a Jakob, e tamanitugira vati na dalena mane: tugira a Hanok, ma Palu, ma Hesron, ma Karmi; tugira nogo na mumuaqira na duli ara tangomalavuginia tu soaqira. ");
INSERT INTO gri_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","A Simeon e tamanitugira ara tu ono na dalena mane: tugira nogo a Jemuel, ma Jamin, ma Ohad, ma Jakin, ma Sohar, ma Saul, aia na dalena kesa na daki ni Kanaan; tugira nogo na mumuaqira na duli ara tangomalavuginia tu soaqira. ");
INSERT INTO gri_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","A Levi e tamanitugira tolu na dalena mane: tugira nogo a Gerson, ma Kohat, ma Merari; tugira nogo na mumuaqira na duli ara tangomalavuginia tu soaqira. Ma Levi e mauri tsaulina 137 na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","A Gerson e tamanikaira ruka moa na dalena mane: kaira nogo a Libni ma Simei, mi kaira ara ka tamani danga sosongo ka kukuaqira. ");
INSERT INTO gri_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","A Kohat e tamanitugira vati na dalena mane: tugira nogo a Amram, ma Isar, ma Hebron, ma Usiel. Ma Kohat e mauri tsaulina 133 na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","A Merari e tamanikaira ruka moa na dalena mane: kaira nogo a Mali ma Musi. Igirani nogo na duli konina a Levi kolu kukuaqira. ");
INSERT INTO gri_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","A Amram e taugâ ko Jokebed aia na tasina tamana, ma ko Jokebed e vasuvania a Amram kaira a Moses ma Aaron. Ma Amram e mauri tsaulina 137 na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","A Isar e tamanitugira tolu na dalena mane: tugira nogo a Kora, ma Nepeg ma Sikri. ");
INSERT INTO gri_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","A Usiel goto e tamanitugira tolu na dalena mane: tugira nogo a Misael, ma Elsapan ma Sitri. ");
INSERT INTO gri_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","A Aaron e taugâ ko Eliseba, aia na dalena daki a Aminadab ma na tasina a Nason; maia ko Eliseba e vasuvania a Aaron vati na dalena mane: tugira nogo a Nadab, ma Abihu, ma Eleasar, ma Itamar. ");
INSERT INTO gri_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ma Kora e tamanitugira tolu na dalena mane: tugira a Asir, me Elkana, ma Abiasap; tugira nogo na mumuaqira igira na duli konina a Kora. ");
INSERT INTO gri_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","A Eleasar aia na dalena a Aaron e taugâ na dalena daki a Putiel, maia e vasuvania a Eleasar a Pinehas. Igirani nogo na ida tana vungu ma na duli tana puku konina a Levi. ");
INSERT INTO gri_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Kaira a Aaron ma Moses i kaira nogo aia na Taovia e tsarivanikaira, “Ka nimui aqo kagamu kamu ka adirutsumigira sui na puku ni Israel tania na Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mi kaira nogo ara ka ba tsarivania na taovia tsapakae ni Ejipt ke nusiligigira na toga ni Israel tania na totu tseka. ");
INSERT INTO gri_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mi kalina na Taovia e gokovania a Moses tana kao ni Ejipt, ");
INSERT INTO gri_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","maia e tsaria, “Inau nogo na Taovia. Igoe ko bâ mo ko tsarivania na taovia tsapakae pipi sui na omea inau au tsaivanigo.” ");
INSERT INTO gri_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ma Moses e tsaria, “Igoe o dona segenimu nogo laka inau au tau tangomana na goko dou; ?ma na rongona gua ti ke rongomi mangaqu inau na taovia tsapakae?” ");
INSERT INTO gri_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ma na Taovia e tsarivania, “Inau sauba kau naua migoe ko lia vaga God vania na taovia tsapakae, ma Aaron na kulamu sauba ke goko vania vaga nimu propete igoe. ");
INSERT INTO gri_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mo ko tsarivania a Aaron pipi sui na omea inau au ketsaligignigo, maia sauba ke ba tsarivania na taovia tsapakae ke tamivanigira na tinoni ni Israel kara mololea na verana. ");
INSERT INTO gri_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Minau sauba kau naua ma na taovia tsapakae ke tsatsarae sosongo me ke tau ngaoa na rongomangaqu, atsa moa ke danga na omea mataguniga kau naugira i laona na Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Mi muri ti inau sauba kau kede sekoligira sosongo na Ejipt, ma kau adirutsumigira na toga niqu tinoni ni Israel tania na vera ia. ");
INSERT INTO gri_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mi tana, ti sauba igira na Ejipt kara donaginia laka inau nogo na Taovia, kalina kau kede sekoligira igira, ma kau adirutsumigira na tinoni ni Israel tania na veraqira.” ");
INSERT INTO gri_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mi kaira a Moses ma Aaron ara ka naua na omea vaga e ketsaliginigira na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mi tana tagu ara ka ba goko vania na taovia tsapakae ia, ma Moses e alu sangavulu na ngalitupana ma Aaron e alu sangavulu tolu na ngalitupana. ");
INSERT INTO gri_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Na Taovia e tsarivanikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Me ti vaga na taovia tsapakae ke tsarivanikagamu kamu ka sauvulagikamu segeni tana aqosi valatsatsa, mo ko tsarivania a Aaron ke adia nina itoro me ke tsoni tsunâ i matana na taovia tsapakae, ma na itoro ia sauba ke lia na muata.” ");
INSERT INTO gri_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mi tana, mi kaira a Moses ma Aaron ara ka vano i konina na taovia tsapakae mara ka nauvaganana na omea e ketsalikaira na Taovia. Ma Aaron e tsonitsunâ nina itoro i matana na taovia tsapakae migira nina mane sasanga, ma na itoro ia e oli me lia na muata. ");
INSERT INTO gri_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mi muri ma na taovia tsapakae e soamaigira nina mane sasaga migira goto na mane basutidao, mi tana niqira sinagore igira ara nauvaganana goto. ");
INSERT INTO gri_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Igira ara tsonitsunagotoa niqira itoro, ma niqira itoro ara oli mara lia goto na muata. Ma nina itoro a Aaron e tû, me konomi poponogira niqira itoro igira. ");
INSERT INTO gri_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Me atsa moa e vaga, ma na taovia tsapakae e tau goto oli nina papada, me tau goto ngaoa na rongomi ka mangaqira a Moses ma Aaron, vaga e tsari idanogoa na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Mi muri, ma na Taovia e tsarivania a Moses, “Na taovia tsapakae e tsatsarae sosongo me tau moa vati tamivanigira na tinoni kara vano. ");
INSERT INTO gri_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Me vaga ia, migoe ko vano ke matsaraka mo ko ba tsodoa kalina aia ke vano tana Kô Nile. Ko adia na itoro aia nogo na itoro e oli me lia na muata, mo ko ba pitua i liligina na kô. ");
INSERT INTO gri_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mo ko tsarivania na taovia tsapakae, ‘Na Taovia aia niqira God na Hibru, e molomaiau kau tsarivanigo ko tamivanigira nina tinoni kara vano, rongona kara gini samasama vania tana kaomate. Me tsaumai i dani eni igoe o tau ngaoa na rorongo. ");
INSERT INTO gri_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mi kalina ia taovia, aia na Taovia God e tsaria laka igoe sauba ko reivulagia laka asei aia tana na omea sauba aia ke naua. Ko moromai, inau sauba kau labuginia na itoro iani na rarauna na kô, ma na kô sauba ke oli me ke lia na gabu. ");
INSERT INTO gri_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ma na tsetse sauba kara viri mate sui, ma na kô sauba ke sigini mabulu sosongo, ma kara tau tangomana igira na tinoni ni Ejipt na inu i konina.’ ” ");
INSERT INTO gri_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ma na Taovia e tsarivanigotoa a Moses, “Ko tsarivania a Aaron ke adia nina itoro me ke saua bâ i kelaqira na kô sui, ma na okookona kô ma na maoutu sui tana Ejipt. Ma na kô sui i laona na vera popono sauba kara lia sui na gabu, atsa moa na kô i laona na popo gai ma na popo vatu.” ");
INSERT INTO gri_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mi kaira a Moses ma Aaron ara ka naua na omea e ketsalikaira na Taovia. Mi matana na taovia tsapakae ma nina mane sasanga, aia Aaron e adikaea nina itoro me labuginia na rarauna na kô, ma na kô sui ara oli mara lia na gabu. ");
INSERT INTO gri_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ma na tsetse sui i laona na kô ara viri mate, ma na siginina e sigini seko sosongo migira na tinoni ni Ejipt ara gini tau tangomana na inu i konina. Me liasi gabu moa tana Ejipt popono. ");
INSERT INTO gri_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mi muri, migira goto nina mane basutidao na taovia tsapakae ara tangomana na nauvaganana goto ia tana niqira sinagore, ma na taovia tsapakae e tsatsarae manana nomoa. Me vaga nogo na omea e tsaria idanogoa na Taovia, aia na taovia tsapakae e tau ngaoa na rongomiana ka mangaqira a Moses ma Aaron. ");
INSERT INTO gri_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Maia e pilo me visutugua i valena, me atsa moa e laba na omea iani maia e tau goto gini boe. ");
INSERT INTO gri_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Migira sui na tinoni ni Ejipt ara ba tsaia tana liligina na kô gana kara tsodoa na kô na inu, rongona ara tau tangomana na inu i kô loki. ");
INSERT INTO gri_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Me putsi nogo vitu na dani murina kalina na Taovia e ketsoa na kô. ");
INSERT INTO gri_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mi muri, ma na Taovia e tsarivania a Moses, “Ko bâ i konina na taovia tsapakae, mo ko tsarivania laka na Taovia e tsarivaganana iani, ‘Ko tamivanigira niqu tinoni kara vano, rongona kara gini samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Me ti vaga igoe ko sove na rorongo, minau sauba kau kedea na veramu ma kau dangaliginia na qori. ");
INSERT INTO gri_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sauba kara danga tsara na qori tana Kô Nile me sauba kara viri tsipudato tania na kô, ma kara ba sage i laona na valemu igoe, mi laona goto nimu voki na maturu, mi kelana nigemu, mi tana valeqira nimu mane sasanga ma nimu toga, mi laoqira goto nimui umu ma nimui popo na bulobredi. ");
INSERT INTO gri_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Me sauba kara tsipudato i konimu goto igoe, mi koniqira nimu toga, mi koniqira sui goto nimu mane sasanga.’ ” ");
INSERT INTO gri_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ma na Taovia e tsarivanigotoa a Moses, “!Ko tsarivania a Aaron ke tangolikaea nina itoro me ke tusu bâ i kelaqira na kô, ma na okookona kô ma na maoutu, me ke naua ma na qori kara rutsu labamai ma kara tsavu poponoa na kao ni Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Me vaga ia, ma Aaron e tusu bâ nina itoro i kelaqira na kô sui, ma na qori ara rutsu labamai mara tsavupoponoa na kao. ");
INSERT INTO gri_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Migira goto na mane basutidao ara gini aqo niqira sinagore, mara naua mara datomai goto na qori tana kao popono ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ma na taovia tsapakae e soamai kaira a Moses ma Aaron me tsarivanikaira, “Kamu ka nonginongi vania na Taovia me ke adiligigira na qori girani, me sauba inau kau tamivanigira ka nimui tinoni kara vano, rongona kara gini ba na savori-kodoputsa vaniana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ma Moses e tsarivania, “Sauba kau gini mage moa inau na nonginongi vaniamu igoe. Mo ko titia moa na taguna i tana igoe o ngaoa kau nonginongi vanigo me vanigira nimu mane sasanga, migira goto nimu toga, rongona na qori kara gini nangaligi tanigamu, me ke tagara goto ke kesa ke totuvisu, migira lelê moa ara totu tana Kô Nile kara totu.” ");
INSERT INTO gri_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ma na taovia tsapakae e tsaria, “Ko nonginongi vaniau ke dani.” Ma Moses e tsaria, “Eo, inau sauba kau naua na omea o nongia i koniqu, mi tana ti igoe ko gini dona laka e tagara goto sa god ke atsa kolua na Taovia nimami God igami. ");
INSERT INTO gri_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Migira na qori sauba kara nangaligi tanigamu sui, igoe migira nimu mane sasanga, migira goto nimu toga, me ke tagara goto sa qori ke totuvisu, igira lelê moa ara totu tana Kô Nile kara totu.” ");
INSERT INTO gri_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mi tana mi kaira a Moses ma Aaron ara ka mololea na valena na taovia tsapakae, maia Moses e nongia na Taovia ke adiligigira na qori aia nogo e molomaigira vania na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ma na Taovia e manalia na omea a Moses e nongia i konina, mara viri mate sui lakalaka na qori i laoqira na vale, mi tana pakokana na vera, mi laoqira na uta. ");
INSERT INTO gri_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Migira na tinoni ni Ejipt ara tsako tsupulaginigira tana tsupu loki, me sigini seko na mabuluqira tana kao popono ia. ");
INSERT INTO gri_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mi kalina na taovia tsapakae e reia laka ara mate sui nogo na qori, maia e totu kalavata tugua tana nina papada, me tau tugua ngaoa na rongomiana ka mangaqira a Moses ma Aaron, vaga nogo na Taovia e kate idanogoa. ");
INSERT INTO gri_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na Taovia e tsarivania a Moses, “Ko tsarivania a Aaron ke labuginia na kao nina itoro, mi tana Ejipt popono na papasa sauba kara oli ma kara lia na ngitsu.” ");
INSERT INTO gri_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Me vaga ia ma Aaron e tû me labuginia na kao nina itoro, ma na papasa sui tana Ejipt ara oli mara lia na ngitsu, mara tsavu poponogira na tinoni me pipi sui na omea tuavati. ");
INSERT INTO gri_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Migira na mane basutidao ara tovogotoa kara gini aqo niqira sinagore ma kara laba na ngitsu, migira ara tau tangomana. Ma na ngitsu moa ara tovusi poponoa pipi tana nauna sui. ");
INSERT INTO gri_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Migira na mane basutidao ara tsarivania na taovia tsapakae, “!God nogo e naua na omea iani!” Ma na taovia tsapakae e tau goto olia nina papada, me tau goto ngaoa na rongomiana ka mangaqira a Moses ma Aaron, vaga nogo na Taovia e kate idanogoa. ");
INSERT INTO gri_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Na Taovia e tsarivania a Moses, “Ke matsaraka bongibongi ke dani ko vano mo ko ba tsodoa na taovia tsapakae kalina aia ke ba tsuna i kô, mo ko tsarivania laka inau na Taovia au tsarivaganana iani. ‘Ko tamivanigira niqu tinoni kara vano, rongona kara gini samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Au paravatavigo laka ti vaga igoe ko sove na rorongo, minau sauba kau molomaigira na alaala popono na lango ma kara vururu i konimu igoe mi koniqira nimu mane sasanga, migira goto nimu toga. Ma kara danga dato na lango i laona na valeqira sui na tinoni ni Ejipt, ma kara tsavugotoa na kao popono. ");
INSERT INTO gri_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mi Gosen segeni moa i tana ara totu niqu tinoni, sauba kau moloa ke mangamanga, me ke tagara sa lango i tana. Inau sauba kau nauvaganana ia rongona igoe ko donaginia laka inau na Taovia au totu tana kao iani. ");
INSERT INTO gri_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Minau sauba kau vota vaganana iani vanigira niqu tinoni inau ma nimu tinoni igoe. Ma na valatsatsa iani sauba ke laba ke dani.’ ” ");
INSERT INTO gri_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Na Taovia e molomaia na alaala popono na lango i laona na valena na taovia tsapakae, mi valeqira goto nina mane sasanga. Ma na lango ara sekolia na kao popono tana Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mi muri, ma na taovia tsapakae e soakaira a Moses ma Aaron me tsarivanikaira, “Bâ kagamu ma kamu ka savori-kodoputsa vania ka nimui God i laona na vera moa iani.” ");
INSERT INTO gri_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ma Moses e gokovisu me tsaria, “E tau goto kami ka naua na omea vaga ia ieni, rongona sauba ke tau dou vanigira na tinoni ni Ejipt na reiana nimami savori-kodoputsa igami vania na Taovia nimami God. Me ti vaga igami kami savorigira nimami omea tuavati i mataqira na tinoni ni Ejipt, me sauba ke seko sosongo na tobaqira na morosiamami ma kara taimatesigami. ");
INSERT INTO gri_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nimami aqo nomoa igami kami vano ke tolu na dani tana kaomate gana na savori-kodoputsa vaniana na Taovia nimami God vaga nogo aia e ketsaliginigami.” ");
INSERT INTO gri_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ma na taovia tsapakae e tsaria, “Inau sauba kau tami moa vanigamu na vano na savori-kodoputsa vania na Taovia nimui God tana kaomate, ti vaga igamu kamu tau moa vano ao sosongo. Mo ko nonginongi vaniau goto inau.” ");
INSERT INTO gri_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ma Moses e tsarivania, “Kalina tsotsodo kau mololea ieni, minau sauba kau nongia na Taovia laka ke dani manana nogo na lango kara vanoligi tanigo igoe, me tanigira nimu mane sasanga, migira sui goto nimu toga. Ma nimu aqo igoe ko laka goto na perobulesiamami igami, ma na utusiaqira na tinoni tana vano na savori-kodoputsa vaniana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mi tana ma Moses e mololea na taovia tsapakae me ba nonginongi vania na Taovia, ");
INSERT INTO gri_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ma na Taovia e manalia na omea a Moses e nongia i konina. Migira na lango ara vanoligi tania na taovia tsapakae, migira nina mane sasanga, migira sui goto nina toga; me tagara goto sa lango ke kauvisu. ");
INSERT INTO gri_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Me atsa moa na taovia tsapakae e reia e laba na omea vaga ia, maia e tau moa olia nina papada, me tau tugua tamivanigira na tinoni kara vano. ");
INSERT INTO gri_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ma na Taovia e tsarivania a Moses, “Ko vano i konina na taovia tsapakae mo ko tsarivania laka na Taovia aia niqira God na Hibru e tsaria, ‘Ko tamivanigira niqu tinoni kara vano, rongona kara gini samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Me ti vaga igoe ko tau tugua tamivanigira na vano, ");
INSERT INTO gri_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","minau sauba kau kedego ma kau molomaia kesa na lobogu seko sosongo ke gadovigira nimui omea tuavati sui: igira nimui ose, ma nimui asi, nimui kamelo, nimui buluka, nimui sipi, ma nimui naniqoti. ");
INSERT INTO gri_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Me sauba kau vota vaganana iani vanigira niqira omea tuavati ara tamanina igira na Israel, ma niqira omea tuavati ara tamanina igira na Ejipt, me tagara lelê goto sa vidaqira niqira omea tuavati igira na Israel ke mate. ");
INSERT INTO gri_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Inau na Taovia au titinogoa laka ke dani nogo sauba kau naua na omea iani.’ ” ");
INSERT INTO gri_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mi tana dani ngana, ma na Taovia e manalia na omea e tsaria, migira sui lakalaka niqira omea tuavati igira na Ejipt ara viri mate sui, me tagara sa vidaqira niqira omea tuavati igira na Israel ke mate. ");
INSERT INTO gri_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Na taovia tsapakae e veisuâ nagua e laba, mara turupatu vania laka e tagara goto sa vidaqira niqira omea tuavati na Israel ke mate. Me atsa moa ti aia e rongomi vaganana ia maia e tau moa olia nina papada, me tau goto tamivanigira na tinoni ni Israel kara vano. ");
INSERT INTO gri_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mi muri, ma na Taovia e tsarivanikaira a Moses ma Aaron, “Kamu ka ba karoa kara visana na kakarona tora i laona na umu; maia Moses sauba ke rasavaginidatoa i matana na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ma na punguna na tora ia sauba ke tsavua na kao popono ni Ejipt, me pipi moa tana nauna sui igira na tinoni ma na omea tuavati kara tsope, me ke botsa me ke viri vora na koniqira.” ");
INSERT INTO gri_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mi tana mi kaira ara ka ba karoa visana na kakarona tora mara ka mai tû i matana na taovia tsapakae; ma Moses e rasavaginidatoa na tora, ma na punguna na tora ia e naua mara gini tsope me viri vora loki na koniqira na tinoni ma na omea tuavati sui. ");
INSERT INTO gri_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Migira na mane basutidao ara tau goto tangomana kara mailaba i matana a Moses rongona e boboto popono na kokoraqira vaga goto igira na tinoni sui tavosi tana Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ma na Taovia e naua me tsatsarae babâ moa na taovia tsapakae, me tau goto ngaoa na rongomiana ka mangaqira a Moses ma Aaron, vaga nogo na Taovia e kate idanogoa. ");
INSERT INTO gri_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Mi muri ma na Taovia e tsarivania a Moses, “Ke matsaraka bongibongi ke dani ko vano mo ko ba goko kolugotoa na taovia tsapakae mo ko tsarivania laka na Taovia niqira God na Hibru e tsarivaganana, ‘Ko tamivanigira niqu tinoni kara vano, rongona kara samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mi kalina ia inau sauba kau tau kedegira moa nimu mane sasanga ma nimu toga, me sauba kau kedego goto igoe, rongona ko gini donaginia laka e tagara goto sa god ke atsa koluau inau tana barangengo popono. ");
INSERT INTO gri_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Me ti vaga kau sulukaenogoa na limaqu ma kau labuginigo igoe migira nimu toga ginia na lobogu seko, migamu kamu nangaligi saikesa nogo. ");
INSERT INTO gri_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mau tamivanigo moa ko mauri rongona kau gini sauvulagia na susuligaqu inau, ma gaqu tangirongo ke kuvia na barangengo popono. ");
INSERT INTO gri_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Migoe o kaekae sosongo moa mo tau tamivanigira niqu tinoni kara vano. ");
INSERT INTO gri_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mi tana tagu vaga nogo ia ke dani, ti inau sauba kau naua me ke gini tumutsuna mai na kolina na usa kakai vaga na vatu, vaga ara tau vati reia moa ke laba tana Ejipt tû tana tuturigana na barangengo me tsau mai i dani eni. ");
INSERT INTO gri_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mi kalina ia, ko moloketsa vanigira kara molo raviravigira nimu omea tuavati me pipi sui goto nimu omea levolevo ara totu i tano. Sauba na kolina na usa kakai vaga na vatu ke tumutsuna mai i koniqira na tinoni migira nimui omea tuavati sui ara tau totu raviravi mara totuvisu moa i tano, migira sui sauba kara mate.’ ” ");
INSERT INTO gri_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mara visana nina mane sasanga na taovia tsapakae ara matagunia na omea e tsaria na Taovia, mara adisagemaigira sui i vale niqira tseka ma niqira omea tuavati kara gini totu raviravi. ");
INSERT INTO gri_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Migira visana tavosi ara tau gini boe nina goko parovata na Taovia mara mologira niqira tseka ma niqira omea tuavati kara totu moa i tano. ");
INSERT INTO gri_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mi muri, ma na Taovia e tsarivania a Moses, “Ko saukaea na limamu tana masaoka, ma na kolina na usa kakai vaga na vatu sauba ke tumu tsuna me ke tsavua na kao popono ni Ejipt: i koniqira na tinoni, ma na omea tuavati, me pipi sui goto na omea tsukatsuka tana uta.” ");
INSERT INTO gri_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Me vaga ia, ma Moses e saudatoa gana itoro tana masaoka, ma na Taovia e moloa ke poda na quluqulu, ma na angaanga ke gado tana kao, me ke tumutsuna na kolina na usa kakai vaga na vatu. Na Taovia nogo e naua ");
INSERT INTO gri_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","me gini tumutsunamai na kolina na usa kakai, kolua na kirapina na angaanga e vavano me vivisu. Aia e kesa na legai loki seko sosongo bâ vaga ara tau goto vati reia ke gado tana Ejipt tû tana tuturigana na barangengo me tsau mai i dani eni. ");
INSERT INTO gri_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mi laona na Ejipt popono na kolina na usa kakai vaga na vatu e toroutsanigira pipi sui na omea ara totu i tano, kolugira goto na tinoni ma na omea tuavati sui. E tsarovaginigira sui na omea tsukatsuka i laona na uta me arabakegira pipi sui na gai. ");
INSERT INTO gri_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mi laona moa na butona kao ni Gosen i tana ara totu igira na tinoni ni Israel, i tana lelê moa e tau tumuligira na kolina na usa kakai. ");
INSERT INTO gri_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Na taovia tsapakae e vailivukaira tugua a Moses ma Aaron me tsarivanikaira, “Mi kalina ia inau au sasi loki; ma na Taovia aia moa e goto, minau migira niqu tinoni ami sasi sui. ");
INSERT INTO gri_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","!Kamu ka nonginongi vania na Taovia rongona e tugugami nogo na vivisa ma na kolina usa kakai vaga gira! Inau au vekea kau tamivanigamu kamu vano; me tau kiligotoa kamu totu goto ieni.” ");
INSERT INTO gri_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ma Moses e tsarivania, “I kalina tsotsodo inau kau rutsu tania na verabau iani, me sauba kau saudatoa na limaqu tana nonginongi vaniana na Taovia. Maia ke naua ma na vivisa sauba ke sui, me utu goto ke tumutsuna mai sa kolina na usa kakai vaga na vatu, rongona igoe ko donaginia laka na Taovia aia nogo e tamanina na barangengo. ");
INSERT INTO gri_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Minau au donagininogoa laka igoe migira nimu mane sasanga amu tau moa vati matagunia na Taovia God.” ");
INSERT INTO gri_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Na flaks ma na barli ara seko pitsu saikesa, rongona na barli nina tagu nogo na ganoga, ma na flaks e tuturiga moa na latse. ");
INSERT INTO gri_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Me tagara sa uiti ke seko, rongona i muri moa ti ke tsau nina tagu na ganoga. ");
INSERT INTO gri_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ma Moses e mololea na taovia tsapakae me rutsu tania na verabau, maia e saukaea na limana tana ngonginongi vaniana na Taovia. Ma na vivisa, ma na kolina na usa kakai vaga na vatu ma na usa ara tavongani sui saikesa. ");
INSERT INTO gri_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mi kalina na taovia tsapakae e reia e laba na omea vaga ia, maia e tû me sasi tugua. Aia migira goto nina mane sasanga ara tsatsarae sosongo moa, ");
INSERT INTO gri_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","mara tau moa tamivanigira na tinoni ni Israel kara vano vaga nogo na Taovia e kate idanogoa tana mangana a Moses. ");
INSERT INTO gri_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mi muri, ma na Taovia e tsarivania a Moses, “Ko vano mo ko ba reia na taovia tsapakae. Inau au naua, maia migira nina mane sasanga ara tsatsarae babâ moa, rongona au ngaoa kau aqosigira na valatsatsa girani i laoqira, ");
INSERT INTO gri_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","me rongona goto igamu kamu gini tangomana na tsarivaniaqira na dalemui ma na kukuamui laka au bulesi koeguanigira inau na tinoni ni Ejipt kalina au aqosigira na valatsatsa girani. Mi tana ti igamu sui sauba kamu donaginia laka inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Me vaga ia, mi kaira a Moses ma Aaron ara ka vano i konina na taovia tsapakae mara ka tsarivania, “Na Taovia niqira God na Hibru e tsarivanigo, ‘?Ke oka koegua sagata goto ko sove na rongomangaqu inau? Ko tamivanigira niqu tinoni kara vano, rongona kara gini samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Me ti vaga igoe ko tongogira babâ moa, me ke dani sauba inau kau molomaigira na kipo kara dangalia na veramu. ");
INSERT INTO gri_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Sauba kara danga sosongo bâ ma kara seseovia na kao popono. Sauba kara gania pipi sui na omea e tau sekolia na kolina na usa kakai, tsau i koniqira na gai sui ara kauvisu. ");
INSERT INTO gri_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Sauba kara dangadato i laona na valemu igoe mi laona na valeqira nimu mane sasanga, migira sui goto nimu toga. Me sauba kara seko liuliu bâ liusia pipi sui na omea ara reinogoa igira na mumuamui.’ ” Mi tana me pilo a Moses me vano. ");
INSERT INTO gri_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Mara tû igira nina mane sasanga na taovia tsapakae mara tsarivania, “?Laka ke oka koegua sagata sauba ke saurota vanigita na mane iani? Ko tamivanigira moa na mane ni Israel kara vano rongona kara gini samasama vania na Taovia niqira God. ?Tagara mo tau vati reigadovi ngatsua moa igoe laka e toroutsa sui nogo na Ejipt?” ");
INSERT INTO gri_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Me vaga ia, mara soavisumai kaira tugua a Moses ma Aaron konina na taovia tsapakae, maia e tsarivanikaira, “E dou moa kamu vano ma kamu samasama vania na Taovia nimui God. Ma kamu ka tsarivulagi vaniau moa laka asei masei igamu kamu vano.” ");
INSERT INTO gri_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ma Moses e tsarivania, “Igami sui lakalaka sauba kami vano, kolugira goto na dalemami ma nimami tuqatuqa ma na kavekave. Sauba kami adigira sui na dalemami mane ma na dalemami daki, nimami sipi, nimami naniqoti, ma nimami buluka, rongona nimami aqo kami naua na aqona na dani tabu gana na padalokiana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ma na taovia tsapakae e tsaria, “!Inau au vatsa tana asana na Taovia laka e utu saikesa kau tamivanigamu kamu adigira na menivale ma na baka! E maka saikesa laka igamu amu vorogokona kesa na omea seko. ");
INSERT INTO gri_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","!Tagara! Igira moa na mane tangomana kara vano na samasama vaniana na Taovia, ti vaga aia nogo na omea amu ngaoa.” Mi tana, mara tsialigikaira a Moses ma Aaron tania na matana na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mi muri ma na Taovia e tsarivania a Moses, “Ko saukaea na limamu i kelana na kao popono tana Ejipt ma kara gini mai na kipo ma kara gani sui lakalaka gira na omea ara dato i tana, pipi sui na omea e tau sekolia na kolina na usa kakai.” ");
INSERT INTO gri_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Me vaga ia, ma Moses e saukaea nina itoro, ma na Taovia e naua me laba na guguri votu tana vera ia na dani popono ma na bongi popono. Mi tana matsaraka ma na guguri ia e adimaigira na alaala popono na kipo. ");
INSERT INTO gri_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mara seseovia na Ejipt popono. Ma na alaala na kipo ia e loki liusigira pipi sui na alaala na kipo ara reinogoa i sau, se kara reia ke laba i muri. ");
INSERT INTO gri_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ara marabau mara tsavu poponoa na kao; mara ganisuigira pipi na omea e tau sekoligira na kolina na usa kakai, kolugira sui goto na vuana gai ara totuvisu tana gaiqira. Me tau goto kauvisu sa omea marao tana gai se tana omea tsukatsuka i laona na kao popono tana Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Mi tana, ma na taovia tsapakae e soatsakukaira a Moses ma Aaron me tsarivanikaira, “Inau au sasi manana i matana na Taovia ka nimui God, mi ka matamui goto kagamu. ");
INSERT INTO gri_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mi kalina ia, au nongikagamu kamu ka padalea niqu sasi ma kamu ka nongia na Taovia ka nimui God ke adiligi taniau na kede loki seko sosongo iani.” ");
INSERT INTO gri_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ma Moses e mololea na taovia tsapakae me ba nonginongi vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ma na Taovia e piloa na guguri votu me lia na tulonga, maia e tavaligi vanogira na kipo sui tana Tasi Tsitsi. Me tagara goto sa kipo ke totuvisu i laona na Ejipt popono. ");
INSERT INTO gri_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ma na Taovia e naua ma na taovia tsapakae e tsatsarae babâ moa, me tau goto tamivanigira na tinoni ni Israel kara vano. ");
INSERT INTO gri_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mi muri, ma na Taovia e tsarivania a Moses, “Ko saukaea na limamu tana masaoka, ma na rodo matolu e tugua na tapoana sauba ke tsavu poponoa na Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ma Moses e saukaea na limana tana masaoka, me tavongani rodo pulipuli tana Ejipt popono i laona e tolu na dani. ");
INSERT INTO gri_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Migira na Ejipt ara tau tangomana kara vaimorosigi, me tagara goto sa vidaqira ke mololea na valena tana tagu popono ia. Migira moa na tinoni ni Israel e marara rago tana nauna ara totu. ");
INSERT INTO gri_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ma na taovia tsapakae e soavisutugua a Moses me tsarivania, “E dou moa kamu vano ma kamu samasama vania na Taovia; migira goto na daki ma na baka kara vano kolugamu. Migira moa nimui sipi, ma nimui naniqoti, ma nimui buluka kamu mologira kara totuvisu ieni.” ");
INSERT INTO gri_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ma Moses e tsarivania, “Me ti vaga ia, migoe nogo nimu aqo ko tusuvanigami na omea tuavati gana na kodoputsa ma na savori-kodokodo vaniana na Taovia nimami God. ");
INSERT INTO gri_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Me tagara, igami sauba kami adigira nimami omea tuavati; me tagara goto ke kesa ke totuvisu. Igami segenimami nogo nimami aqo kami vililigigira na omea tuavati gana na samasama vaniana na Taovia nimami God. Migami ami tau donaginia na omea tuavati koegua kami savori vania poi kami ba tsau i tana.” ");
INSERT INTO gri_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ma na Taovia e naua, me gini tsatsarae babâ moa na taovia tsapakae, maia e tau goto tamivanigira kara vano. ");
INSERT INTO gri_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Maia e tsarivania a Moses, “!Ko baligi taniau inau! !Mo ko parovata dou ko laka goto na mai labatugua i mataqu! !Mi tana dani ti kau reilakamu, migoe sauba ko mate!” ");
INSERT INTO gri_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ma Moses e tsarivania, “Eo, igoe o goko mana. Igoe sauba e utu saikesa goto ko reilakaqu tugua.” ");
INSERT INTO gri_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mi muri, ma na Taovia e tsarivania a Moses, “Sauba inau kau molo bâ ke kesa goto moa na kede vania na taovia tsapakae kolugira nina tinoni. Mi murina moa ia ti aia ke tamivanigamu na vano. Me ke tau tamivanigamu lê moa na vano, maia sauba ke tû me ke tsialigigamu sui tania ieni. ");
INSERT INTO gri_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Mi kalina ia, migoe ko goko vanigira na tinoni ni Israel mo ko tsarivanigira sui kara nongia i koniqira na kulaqira na Ejipt gaqira inilau qolumila ma na siliva.” ");
INSERT INTO gri_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ma na Taovia e naua, migira na tinoni ni Ejipt ara kukuni tanigira sosongo na tinoni ni Israel. Migira nina mane sasanga na taovia tsapakae ma na tinoni sui goto ara reigadovia laka a Moses e kesa na mane loki sosongo manana. ");
INSERT INTO gri_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ma Moses e ba tû i matana na taovia tsapakae me tsarivania, “Na Taovia e tsaria, ‘Tana gana ngongo na levugata inau sauba kau liuvia na Ejipt popono, ");
INSERT INTO gri_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","me pipi sui na baka mane botsaida i laona na Ejipt sauba kara mate, e tû konina na dalena mane botsaida na taovia tsapakae ni Ejipt, aia sauba ke tugua tamana tana nina sasana na totukae, me ke tsau bâ i konina na dalena mane botsaida na daki tseka aia e rapasi sila. Ma na daleqira mane botsaida pipi na buluka sauba kara mate sui goto. ");
INSERT INTO gri_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Sauba kara ngangai loki ma kara tangitangi tana Ejipt popono, ma na vatana na rota loki vaga ia e tau saikesa laba i sau, me utu goto ke laba sa tagu i muri. ");
INSERT INTO gri_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Me tagara goto sa pai sauba ke kongovigira na tinoni ni Israel se niqira omea tuavati. Mi tana ti igoe sauba ko donaginia laka inau na Taovia au molovotagira na tinoni ni Ejipt ma na tinoni ni Israel.’ ” ");
INSERT INTO gri_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ma Moses e goko babâ moa me tsaria, “Pipi gira sui nimu mane sasanga igoe sauba kara mai i koniqu inau, ma kara tsuporu tsuna i mataqu, ma kara rai sosongoliau kau adiligigira niqu toga sui tania na veraqira. Mi murina ia minau goto sauba kau vanoligi.” Mi tana me momosa loki na tobana a Moses me tû me mololea na taovia tsapakae. ");
INSERT INTO gri_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Na Taovia e tsari ida nogoa vania a Moses, “Na taovia tsapakae sauba ke sove babâ moa na rongomiamu, rongona inau kau gini naua ke visana goto na valatsatsa i laona na Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mi kaira a Moses ma Aaron ara ka naugira nogo pipi sui na valatsatsa girani i matana na taovia tsapakae, ma na Taovia e naua, me gini tsatsarae babâ moa na taovia tsapakae ni Ejipt, me tau goto tamivanigira na tinoni ni Israel kara mololea na verana. ");
INSERT INTO gri_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Na Taovia e goko vanikaira tugua a Moses ma Aaron tana Ejipt me tsaria: ");
INSERT INTO gri_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Na vula nogo iani aia sauba ke lia vanigamu na kesanina vula tana ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kamu moloketsa vanigira sui lakalaka na toga ni Israel, laka tana sangavulunina dani tana vula iani pipi tinoni e tamani vale nina aqo ke adia kesa na dalena sipi se kesa na naniqoti vaolu vanigira i laona na valena. ");
INSERT INTO gri_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Me ti vaga igira i laona kesa na vale ara tau danga me tau tugugira na ganisuiana kesa na dalena sipi, me dou bâ ti kara patakolugira na kulaqira kesa tana vale i ligisaqira, taonia na dangana na tinoni ma na dangana na mutsa tangomana kesa tinoni ke gania. ");
INSERT INTO gri_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kamu vilia kesa na sipi mane se kesa na naniqoti mane me ke kesa moa na ngalitupana me ke tau goto seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mi tana ngulavi na sangavulu vatinina dani tana vula iani, migira sui lakalaka na toga popono ni Israel niqira aqo kara matesigira. ");
INSERT INTO gri_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kara adia na turina na gabuna ma kara mareginigira na tuguruna mi gotuna na matsapana pipi vale i tana sauba kara gania gaqira dalena sipi. ");
INSERT INTO gri_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mi tana bongi ia kara kodogira na velesina ma kara kamatsiginia na kusa vavai ma na bredi tagara isti konina. ");
INSERT INTO gri_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kamu laka na ganiana na qoqoana se na kukukina, kamu gania moa na kokodona, kolugotoa na lovana, na tuana, ma na vanga levona. ");
INSERT INTO gri_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kamu laka goto na moloana sa turina ke tsau tana matsaraka; me ti vaga sa turina ke totuvisu, ma nimui aqo kamu kodoligia. ");
INSERT INTO gri_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kalina ti kamu tû na mutsa, ma kamu nauvaganana ara naua na tinoni kalina ara vangaraua na tsogo: kamu sagelia na polomui gana na liu tana sautu, ma na porotua tana tuamui, ma na itoro tana limamui. Kamu tutû moa ma kamu mutsa tsakutsaku, rongona aia nogo nina Dani na Liusaviliu na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mi tana bongi nogo ia sauba inau kau liusaviliu i laona na kao popono tana Ejipt, ma kau labumatesigira sui pipi na daleqira mane botsaida na tinoni ma na omea tuavati, ma kau kedegira goto pipi sui na god peropero tana Ejipt. Inau nogoria na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ma na gabu amu moloa tana matsapana na valemui, aia nogo ke ngiti papadana vaniau laka igamu amu totu i tana. Mi kalina inau kau reia na vale tana e totu na gabu, me sauba kau liusaviliu tania, me utu kau sekoligamu igamu kalina kau kedegira na tinoni ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Migamu nimui aqo kamu lokisia pipi ngalitupa na papadana na dani iani vaga nogo kesa na dani tabu laka, maia nogoria ke molo papadana vanigamu na omea inau na Taovia au nauvanigamu. Ma kamu lokisia na dani tabu iani pipi tana tagu ke mai.” ");
INSERT INTO gri_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ma na Taovia e tsarigotoa, “I laona ke vitu na dani nimui aqo kamu tau gania sa bredi ara aqosiginia na isti, kamu gania moa na bredi e tagara isti i konina. Mi tana kesanina dani nimui aqo kamu tsoniligia pipi sui na isti e totu i laona na valemui, rongona i laona tugira vitu na dani gira ti vaga ke kesa ke gania na bredi ara aqosiginia na isti, maia sauba kau tsidavaginia tanigira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tana kesanina mi tana vitunina dani nimui aqo kamu maisai gana na samasama. Me tabu vanigamu goto na nauana ke kesa na aqo tana dani tugira, ma na aqosi mutsa moa e tau tabu vanigamu kamu naua. ");
INSERT INTO gri_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kamu lokisia na Dani Tabu na Bredi Tagara Isti i Konina, rongona tana dani nogo iani inau au adirutsumigamu na toga ni Israel tania na Ejipt. Mi tana tagu sui ke mai i muri, nimui aqo kamu lokisia na dani iani vaga kesa na dani tabu loki putsikae. ");
INSERT INTO gri_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Me ke tuturiga tana ngulavi na sangavulu vatinina dani tana kesanina vula, me ke tsau bâ tana ngulavi na rukapatu kesanina dani, nimui aqo kamu gania moa na bredi e tagara isti i konina. ");
INSERT INTO gri_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","I laona e vitu na dani popono ke tau goto totu sa isti i laona na valemui, rongona ti vaga ke kesa na bobotsana Tsiu se na tinoni ni veratavosi ke totu i laomui ke gania na bredi ara aqosiginia na isti, aia sauba kau tsidavaginia tanigira niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ma Moses e soasaigira pipi sui na ida tana Israel me tsarivanigira, “Pipi kesa vidamui igamu ke bâ kalina ia me ke vilia kesa na dalena sipi se na naniqoti vaolu me ke matesia vanigira ara totu i laona na valena, rongona kamu gini lokisia na Dani na Paseka. ");
INSERT INTO gri_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kamu adia na kokopuna na qoraqora tetelo, ma kamu lumi bâ i laona na popo na gabu, ma kamu ninaginia na gai tudato tabana mi tabana na matsapa, mi kelana na matsapana valemui. Me ke laka goto na rutsu taniana na valena sa vidamui poi ke tsau tana matsaraka. ");
INSERT INTO gri_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mi kalina na Taovia ke liu i laona na Ejipt popono na matesiaqira na tinoni ni Ejipt, maia sauba ke morosia na gabu tana gotuna mi tana gai tudato tabana mi tabana na matsapana na valemui, me sauba e utu ke tamivania na Angelo na Mate ke sage i laona na valemui me ke labumatesigamu. ");
INSERT INTO gri_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Igamu migira goto na dalemui nimui aqo kamu muri sailaginia na vali iani. ");
INSERT INTO gri_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mi kalina kamu sage bâ tana kao aia na Taovia e vekenogoa ke sauvanigamu, ma nimui aqo kamu naugotoa na vovorona na lotu iani. ");
INSERT INTO gri_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mi kalina ti gira na dalemui kara veisuagamu, ‘?Laka nagua na rongona na vovorona na lotu iani?’ ");
INSERT INTO gri_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","migamu sauba kamu tuguvisua ma kamu tsaria, ‘Iani na savori-kodoputsa na Paseka gana na padalokiana na Taovia, rongona aia e liuputsi tania na valeqira na tinoni ni Israel i sau tana Ejipt kalina aia e liu na labumatesiaqira na tinoni ni Ejipt me gaegita igita.’ ” Mi tana, migira na toga ara tsunatuturu mara samasama. ");
INSERT INTO gri_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Mi muri mara tû, mara vano na nauana na omea aia na Taovia e ketsaliginikaira a Moses ma Aaron. ");
INSERT INTO gri_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mi tana levugata ma na Taovia e labumatesigira sui lakalaka na baka mane botsaida tana Ejipt, e tû tana dalena mane na taovia tsapakae aia sauba ke tugua tamana tana nina sasana na totukae, me tsau bâ tana dalena na mane e totu tana vale sosori; migira sui goto na daleqira botsaida na omea tuavati ara viri mate sui. ");
INSERT INTO gri_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mi tana bongi nogo ia, na taovia tsapakae migira nina mane sasanga, migira sui goto na tinoni popono tana Ejipt ara mamata. Mara tangitangi tana Ejipt popono, rongona e tagara goto sa vale ke mamanga i tana e tau mate sa baka mane. ");
INSERT INTO gri_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mi tana bongi nogo ia, ma na taovia tsapakae e soakaira a Moses ma Aaron me tsarivanikaira, “!Kamu ka vanoligi i kagamu sui migira goto ka nimui tinoni ni Israel! Kamu baligi tania na veraqu; ma kamu ba samasama vania na Taovia vaga amu nonginogoa i koniqu. ");
INSERT INTO gri_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kamu adigira goto nimui sipi, ma nimui naniqoti, ma nimui buluka, ma kamu vanoligi. Ma kamu ka nonginongi vaniau goto inau.” ");
INSERT INTO gri_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Migira goto na tinoni ni Ejipt ara goraragira kara mololetsakua na veraqira mara tsaria, “Ti vaga kamu tau vano igamu, me sauba igami kami mate sui.” ");
INSERT INTO gri_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Me vaga ia, migira na tinoni ara adia niqira popo na bulo bredi mara dangaliginigira na bredi qoaqoa, mara veqoginigira na polo, mara kalagaigira. ");
INSERT INTO gri_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Migira na tinoni ni Israel ara naunogoa na omea e ketsaligira a Moses, mara nonginogoa i koniqira na tinoni ni Ejipt na inilau qolumila ma na siliva ma na polo. ");
INSERT INTO gri_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Na Taovia e naua migira na tinoni ni Ejipt ara kukuni tanisosongoligira na tinoni ni Israel, mara sauvanigira na omea sui ara nongia i koniqira. Mi tana nauvaganana ia, migira na tinoni ni Israel ara kalagaivanogira pipi sui niqira omea loki matena igira na tinoni ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Igira na tinoni ni Israel ara aligiri na vanovano tû i Rameses me tsau i Sukot. Ara gana ngongo ono sangatu toga na mane, me tau goto tsokogira na daki ma na baka. ");
INSERT INTO gri_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ma na alaala loki goto na tinoni tavosi ma na sipi, ma na naniqoti, ma na buluka ara vano kolugira. ");
INSERT INTO gri_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ara bitia niqira bredi tagara isti i konina, igira nogo na bredi qoaqoa ara adia talu i Ejipt, rongona ara tsialigigira tsaku tania Ejipt mara gini tau tamani tagu na vangarau gaqira. ");
INSERT INTO gri_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Igira na tinoni ni Israel ara totu i Ejipt i laona e 430 na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Mi tana susuina 430 na ngalitupa, migira sui na puku nina tinoni na Taovia ara mololea i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mi tana bongi popono ia na Taovia e mataligira, rongona ke adirutsumigira tania na Ejipt; me vaga ia, me pipi ngalitupa tana tagu sui ke mai, tana bongi vaga nogo ia niqira aqo na Israel kara baloa vania God vaga na bongi na vaimatali. ");
INSERT INTO gri_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Na Taovia e tsarivanikaira a Moses ma Aaron, “Igirani nogo na ketsa e kalea na lokisiana na Paseka: Ke laka goto sanga sa tinoni ni veratavosi na ganiana na mutsa tabu na Paseka, ");
INSERT INTO gri_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","me ti vaga sa tseka amu volinogoa maia e tangomana ke sanga na ganiana ti vaga kamu paripapadana talu. ");
INSERT INTO gri_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ke laka goto na sanga na ganiana sa tinoni maina, se sa tinoni amu volia moa ke aqo vanigamu. ");
INSERT INTO gri_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Na mutsa popono nimui aqo kamu gania i laona na vale i tana amu vangaraua; kamu laka goto na adirutsumiana i tano. Ma kamu laka goto na kutsiana na suliqira na omea tuavati. ");
INSERT INTO gri_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Niqira aqo igira na tinoni sui tana Israel kara lokisia na bongi tabu iani, ");
INSERT INTO gri_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","me ke laka moa na sanga na ganiana sa tinoni e tau vati paripapada. Me ti vaga sa tinoni ni veratavosi ke tototu moa i laomui igamu, me ke ngaoa na sanga na lokisiana na Paseka gana na padalokiana na Taovia, nimui aqo kamu ida talu kamu paripapadaqira na mane sui tana valena aia. Mi muri ti aia ke gini ulagana na sanga na lokisiana na bongi tabu ia vaga nogo igira na bobotsana ni Israel. ");
INSERT INTO gri_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Me kesa moa atsa na ketsa e kalegira sui igira na bobotsa ni Israel, migira goto na tinoni ni veratavosi igira ara tototu i laomui.” ");
INSERT INTO gri_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Migira sui na tinoni ni Israel ara rongomangana, mara naua na omea na Taovia e ketsaliginikaira a Moses ma Aaron. ");
INSERT INTO gri_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mi tana dani nogo ia, ma na Taovia e adirutsumigira na tinoni ni Israel tania na Ejipt taoninogoa niqira puku. ");
INSERT INTO gri_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ko saugira vaniau inau igira sui na baka mane botsaida, rongona pipi sui na baka mane botsaida i laoqira na tinoni ni Israel, me pipi sui goto na omea tuavati mane botsaida ara tamaniqu sui inau.” ");
INSERT INTO gri_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ma Moses e tsarivanigira na tinoni, “Kamu padatugutugua na dani iani na dani i tana igamu amu mololea i Ejipt, aia na vera i tana igamu amu totu tseka. Iani nogo na dani i tana na Taovia e adirutsumigamu tana susuligana loki. Kamu laka goto na ganiana sa bredi ara aqosiginia na isti. ");
INSERT INTO gri_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mi dani eni, tana kesanina vula, na vulana Abib igamu sauba kamu mololea i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mi kalina na Taovia ke adibagamu tana niqira kao lakatana me vuaga dou igira na Kanaan, ma na Het, ma na Amor, ma na Hivi, ma na Jebus, aia nogo na kao e gini vatsa vanigira na mumuamui i sau laka ke saua vanigamu, ma nimui aqo kamu lokisia na bongi tabu iani tana kesanina vula pipi tana ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","I laona ke vitu na dani nimui aqo kamu gania moa na bredi e tagara isti konina, mi tana vitunina dani kamu aqosia na mutsa gana na padalokiana na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mi laona ke vitu na dani nimui aqo kamu tau gania na bredi ara aqosiginia na isti; me pipi nauna i laona na veramui ke laka goto na totu sa isti se sa bredi ara molo isti konina. ");
INSERT INTO gri_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mi kalina ke tuturiga na bongi tabu, migamu kamu votarongona vanigira na dalemui laka amu naua na omea sui girani tana rongona na omea e nauvanigamu na Taovia kalina amu mololea i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Na lokisiana pipi ngalitupa na dani tabu iani sauba ke molopapada vanigamu, vaga moa ti kesa na itai amu sori bâ tana limamui se tana lovamui; aia sauba ke molopapada vanigamu gana kamu padaginia ma kamu gini gogoko sailagi nina Ketsa na Taovia, rongona na Taovia nogo e adirutsumigamu tania na Ejipt tana susuligana loki. ");
INSERT INTO gri_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kamu lokisia na bongi tabu iani tana taguna segeni nogo i laona pipi na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Na Taovia sauba ke adivanogamu tana niqira kao igira na tinoni ni Kanaan, na kao aia e vekenogoa ke sauvanigamu igamu migira goto na mumuamui. Mi kalina aia ke saunogoa na kao ia vanigamu, ");
INSERT INTO gri_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","migamu nimui aqo kamu sauvania na Taovia pipi sui na dalemui mane botsaida. Pipi sui goto na daleqira mane botsaida nimui omea tuavati e tamanina goto na Taovia, ");
INSERT INTO gri_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ma nimui aqo kamu volivisua kesa na dalena asi mane botsaida tana savoriana kesa na dalena sipi na tuguna; me ti vaga kamu tau ngaoa na volivisuana na asi, ma nimui aqo kamu birukutsia na liona. Ma nimui aqo kamu volivisugotoa pipi na dalemui mane botsaida. ");
INSERT INTO gri_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mi tana tagu ke mai i muri, kalina igira na dalemui kara veisuagamu tana rongona na dani tabu iani, migamu kamu tsarivanigira vaga iani, ‘Na Taovia nogo e gini aqo na susuligana loki me adirutsumigita i sau tania na Ejipt, na vera i tana igita a totutseka. ");
INSERT INTO gri_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mi kalina na taovia tsapakae ni Ejipt e tsatsarae sosongo me tau tamivanigita ka vano, ma na Taovia e labumatesigira pipi sui na daleqira mane botsaida na tinoni ma na omea tuavati tana kao ni Ejipt. Aia nogoria na rongona ti igita a gini savori-kodoputsa vania na Taovia pipi sui na dalena mane botsa ida i laoqira nida omea tuavati, ma gini volivisugira na daleda mane botsaida. ");
INSERT INTO gri_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Na nau tugutuguana na aqona na dani tabu ia sauba ke ngiti papadana vanigita, vaga kesa na itai a soria tana limada se tana lovada; aia sauba ke molopapada vanigita laka na Taovia e adirutsumigita tania na Ejipt tana susuligana loki.’ ” ");
INSERT INTO gri_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mi kalina na taovia tsapakae ni Ejipt e tamivanigira na tinoni kara vano, maia God e tau adigira tana sautu e liu bâ liligina na tasi tana veraqira na Pilistia, atsa moa ti aia na sautu e varangi bâ. Ma God e padâ vaganana i tobana, “Au tau ngaoa na tinoni girani kara padasavi ma kara ngaoa na visutugua i Ejipt kalina kara morosia laka e kilia kara vailabu.” ");
INSERT INTO gri_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ti aia e adigira tana sautu e ao me liu bâ tana kaomate kalea na Tasi Tsitsi. Migira na Israel ara tangoli manogatinogoa niqira sagore na vailabu. ");
INSERT INTO gri_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ma Moses e adigira na sulina a Josep, vaga nogo na a Josep e raiginigira na Israel kara vekevania laka kara naua kalina aia e tsaria vanigira, “Sauba God ke laumaurisigamu manana, mi tana dani ia ma nimui aqo kamu adigira goto na suliqu inau tania na vera iani.” ");
INSERT INTO gri_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Migira na Israel ara mololea i Sukot mara ba vaturikaegira niqira valepolo i Etam tana vovotana na kaomate. ");
INSERT INTO gri_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mi laona na dani, maia na Taovia e idavanigira tana parako gana ke sausautu vanigira, mi tana bongi aia e idavanigira tana ketsuma na lake iruiru gana ke mararasigira, rongona kara gini tangomana na vano na bongi ma na dani. ");
INSERT INTO gri_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Na parako e ida sailagi vanigira na tinoni tana dani, ma na ketsuma na lake iruiru tana bongi. ");
INSERT INTO gri_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mi muri, ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ko tsarivanigira na tinoni ni Israel kara pilovisutugua ma kara ba vaturikaegira niqira valepolo i matana Pi Hahirot, ka gaqira levuga i Migdol ma na Tasi Tsitsi, varangisia i Baal Sepon. ");
INSERT INTO gri_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Me sauba ti na taovia tsapakae ke padâ laka igira na tinoni ni Israel ara sarevo bamai moa tana butona kao ia me utukapusigira na kaomate. ");
INSERT INTO gri_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Minau sauba kau naua maia ke momosa loki tugua me sauba ke takuvi tsarigamu. Mi tana nogo ti igira niqu tinoni kara tsonikaeginiau inau kalina kara reia laka au tangomana na tuliusiana gaqira taovia tsapakae ma nina alaala na mane vaumate. Mi tana goto ti igira na Ejipt kara donaginia laka inau nogo na Taovia.” Migira na Israel ara naua na omea vaga e tsarivanigira a Moses, mara ba tototu liligina na Tasi Tsitsi. ");
INSERT INTO gri_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mi kalina na taovia tsapakae ni Ejipt e rongomia laka ara tsogo sui nogo igira na tinoni ni Israel, maia migira nina mane sasanga e pilotugua na tobaqira mara tsaria, “?Nagua vaga a naua igita? !A tamivanigira na tinoni ni Israel mara vano sui tania na aqotseka vaniada!” ");
INSERT INTO gri_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mi tana, ma na taovia tsapakae e tû, me vangaraugira nina terê na vailabu, me vano kolugira nina mane vaumate. ");
INSERT INTO gri_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Maia e adigira ono sangatu nina terê dou bâ migira sui goto na terê tavosi tana Ejipt, me mologira nina mane sasanga kara tagaovigira. ");
INSERT INTO gri_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Na Taovia e naua me gini momosa loki tugua na taovia tsapakae, me takuvi tsarigira na tinoni ni Israel, igira ara liu magemage tana nina reitutugu na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Migira na mane vaumate ni Ejipt kolugira sui niqira ose, niqira terê ma na tinoni ara tagaovigira, ara takuvi tsarigira na Israel mara ba tsauligira i tana ara tototu i liligina na Tasi Tsitsi varangisia i Pi Hahirot mi Baal Sepon. ");
INSERT INTO gri_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mi kalina igira na Israel ara reia na taovia tsapakae migira nina mane vaumate ara alamaiginigira migira ara viri matagu loki sosongo, mara ngangaidato vania na Taovia ke sangagira. ");
INSERT INTO gri_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mara tsarivania a Moses, “?Laka e tagara sa qiluqilu tana kao ni Ejipt te o gini adiligigami mai ieni gana moa kami mate i laona na kaomate? !Ko reia na omea igoe o naua kalina o adirutsumigami tania Ejipt! ");
INSERT INTO gri_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","?Laka ami tau nogo tsarivanigo idavia kalina igita a mololea i Ejipt, laka sauba ke laba na omea vaga iani? Igami ami tsarivanigo nogo ko mololegami, ma kami totu tseka babâ moa vanigira na Ejipt. E dou bâ ti kami aqo tseka babâ moa liusia na mai mate tana kaomate iani.” ");
INSERT INTO gri_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Maia Moses e tuguvisua me tsaria, “!Kamu laka na matagu! Kamu tu kakai moa, me sauba kamu reia na omea ke naua na Taovia gana ke maurisiginigamu i dani eni; igamu sauba e utu kamu reigira tugua na Ejipt girani sa dani. ");
INSERT INTO gri_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Na Taovia sauba ke vailabu tugumui, me tau goto kilia igamu kamu naua sa omea.” ");
INSERT INTO gri_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Na Taovia e tsarivania a Moses, “?Egua te o ngangaidato vaniau sagata vaga ia? Ko tû mo ko ketsaligira na tinoni kara aligiri ma kara vano. ");
INSERT INTO gri_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Migoe ko saukaea gamu itoro mo ko tangolia i kelana na tasi. Me sauba ke tavongani tavota lê na tasi, migira na toga ni Israel sauba kara tangomana na liusavu tana kao mamatsa i levugana na mao. ");
INSERT INTO gri_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Minau sauba kau momosalia na tobaqira na tinoni ni Ejipt, ma kara gini ngaoa na ulotsari ma na takuviamui, mi tana nogo ti sauba igira na tinoni kara tsonikaeginiau kalina kara reia laka au tangomana na tuliusiana gaqira taovia tsapakae na Ejipt, kolua nina alaala na malagai, nina terê, migira sui goto na mane ara sage tana ose. ");
INSERT INTO gri_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Mi kalina inau kau tuliusigira, mi tana ti igira na tinoni ni Ejipt kara donaginia laka inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ma nina angelo God, aia e idagana sautu vanigira na tinoni ni Israel, e tû me oli na sasana me ba totu i muri tsotsodo. Ma na parako goto e pilo me ba ");
INSERT INTO gri_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","totukapu ka levugaqira igira na Ejipt ma na Israel. Ma na parako e rodosigira na Ejipt, me mararasigira na Israel, mara gini tau tangomana na vaivarangisigi tana bongi popono igira na alaala ruka tabana. ");
INSERT INTO gri_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mi kalina igira na Israel ara mai tsau tana liligina na tasi, ma Moses e tû me sauvotu bâ na limana, ma na Taovia e moloa na guguri votu mai tana bongi popono, me uvivotâ na tasi me gini laba na kao mamatsa. Ma na tasi e tavota ruka, ");
INSERT INTO gri_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","me totu kakai lê ruka tabana vaga moa ti na ponoponona na vale, migira na toga ni Israel ara liusavu mamatsa i levugana na tasi. ");
INSERT INTO gri_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Migira na Ejipt ara takuvi tsarigira i laona na tasi kolugira pipi sui niqira ose, ma niqira terê, migira goto na mane ara sage tana ose. ");
INSERT INTO gri_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mi tana matsaraka rovorovo, ma na Taovia aia e totu tana parako mi laona na ketsuma na lake iruiru, e morotsuna bâ i koniqira na alaala na malagai ni Ejipt, me gini kaso na tobaqira mara viri tsogo saranga bamai. ");
INSERT INTO gri_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Me naua me gini lupi tana boko na uilina niqira terê, me gini utu na tagaovidouaqira. Mi tana, migira na mane vaumate ni Ejipt ara tsaria, “!Are gamuna! !Ida ma ka tsogovisu! !Na Taovia nogo aia e vailabu tuguqira na Israel me tukapusigita igita!” ");
INSERT INTO gri_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ma na Taovia e goko me tsarivanitugua a Moses, “Ko sauvotutugua na limamu i kelana na tasi, ma na tasi sauba ke saivisutugua me ke gini tsavugira na mane vaumate ni Ejipt, kolugira niqira terê ma niqira mane sage tana ose.” ");
INSERT INTO gri_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mi tana, ma Moses e sauvotutugua na limana i kelana na tasi, mi tana dani male ma na tasi e saivisu me mao tugua. Migira na malagai ni Ejipt ara tovoa laka kara tsogovisu, me utugana vanigira rongona na Taovia e surukeligira bâ i laona na tasi. ");
INSERT INTO gri_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Na tasi e saivisutugua me koko ponotigira na terê, ma na mane sage tana ose, migira sui lakalaka na malagai ni Ejipt igira ara takuvi tsarigira na Israel i laona na tasi, mara viri lulumi sui; me tagara lelê goto sa vidaqira ke pipidi. ");
INSERT INTO gri_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Migira segeni moa na toga ni Israel ara liusavu tana kao mamatsa i levugana na mao, tana nauna i tana na tasi e totu kakai lê ruka tabana vaga moa ti na ponoponona na vale. ");
INSERT INTO gri_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Maia nogo tana dani ia ma na Taovia e laumaurisigira na tinoni ni Israel tania na limaqira na mane vaumate ni Ejipt, migira ara reia na kubuqira na mane ni Ejipt ara viri tsaro na mateqira i liligina na tasi. ");
INSERT INTO gri_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mi kalina igira na Israel ara reivulagia na susuligana loki na Taovia e gini tangomana na tuliusiaqira na mane vaumate ni Ejipt, mi tana nogo ti igira ara gini kukuni loki tania na Taovia; mara gini tutunina kakai na Taovia mara norua a Moses nina maneaqo. ");
INSERT INTO gri_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mi tana ma Moses migira sui na toga ni Israel ara teâ kesa na linge vania na Taovia mara tsaria: “Inau sauba kau linge vania na Taovia, rongona aia e mana sosongo gana; me tsoni luvusigira i laona na tasi igira sui na ose migira ara sage i koniqira. ");
INSERT INTO gri_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Na Taovia aia nogo e isutuguqu; aia segenina nogo e laumaurisiau. Aia nogo niqu God, minau sauba kau tsonikaea, aia nina God na tamaqu, ma kau linge tana rongona gana loki tsapakae. ");
INSERT INTO gri_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Na Taovia aia e malagai sosongo; ma na Taovia nogo na asana. ");
INSERT INTO gri_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Aia e tsonitsunagira i laona na tasi na alaala popono na malagai ni Ejipt kolua niqira terê; ma gaqira taovia susuliga bâ ara viri lulumi sui i laona na Tasi Tsitsi. ");
INSERT INTO gri_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ma na tatarina na obo e poropoigira sui; mara viri pukaluvu i laona na maorodo vaga moa na vatukulu. ");
INSERT INTO gri_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Taovia, na limamu madoa e susuliga tsapakae; maia nogo o tairutuginigira gamu gala. ");
INSERT INTO gri_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tana susuligamu loki tsapakae igoe o tsoni pukaliginigira gamu gala; ma na koremu e botsadato me iruvigira vaga moa na buruburu makede. ");
INSERT INTO gri_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Igoe o uvia moa na tasi, ma na tasi e tsupudato ruka tabana; me tudato vaga moa ti na ponoponona na vale; mi tana e mao liuliu bâ na tasi, i tana nogo e mamatsa me kakai vaga na vatu. ");
INSERT INTO gri_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ma na gala e tsaria, ‘Inau sauba kau takuvigira ma kau tangoligira; ma kau langâ niqu isi ma kau labumatesiginigira; me sauba kau tuvarigira niqira omea tatamani, ma kau aditamaniqu igira na omea sui au ngaoa.’ ");
INSERT INTO gri_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Migoe Taovia o uvigira moa, migira na malagai ni Ejipt ara viri lulumi sui; mara pukaluvu vaga moa na vatukulu tana tasi loki. ");
INSERT INTO gri_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“!Taovia, asei i laoqira na god ke atsakolugo igoe? ?Asei ke vaga igoe, o susuliga tsapakae mo tabu loki? ?Asei tangomana ke aqosigira na valatsatsa ma na omea ganataga loki sosongo vaga o naua igoe? ");
INSERT INTO gri_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Igoe o tatakatsinia na limamu madoa, ma na barangengo e konomi poponogira gamami gala. ");
INSERT INTO gri_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Igoe o manalia nimu veke, mo idagana sautu vanigira na tinoni igoe o laumaurisigira; mi tana susuligamu loki o tudumigira bâ tana nimu kao tabu. ");
INSERT INTO gri_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Migira sui na puku na tinoni tavosi ara rorongo, mara gini gagariri tana matagu; migira sui goto na Pilistia e gadovigira na matagu loki. ");
INSERT INTO gri_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Igira na ida tana Edom ara viri matagu mate; migira na mane malagai susuliga bâ tana Moab ara gagariri; me puka lê gaqira malagai igira na tinoni sui tana Kanaan. ");
INSERT INTO gri_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ma na matagu loki sosongo e tsavu poponogira. Ara reilakana na susuligamu igoe Taovia, mara totu babangataga tana matagu poi tsau igira nimu toga ara liu putsi, igira nogo na tinoni igoe o maurisigira tania na totu tseka. ");
INSERT INTO gri_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Migoe o livugira tana nimu vungavunga tabu, i tana igoe Taovia o vilinogoa ke lia na valemu, tana Vale Tabu igoe segenimu nogo o logoa. ");
INSERT INTO gri_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Migoe nogo Taovia, sauba ko taovia tsapakae na dani ma na dani.” ");
INSERT INTO gri_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Migira na toga ni Israel ara liusavu tana kao mamatsa i levugana na tasi. Mi kalina niqira terê ma niqira ose migira na mane ni Ejipt ara sage i koniqira ara tsuna i laona na tasi, maia na Taovia e adivisutugua na tasi, me koko ponotigira. ");
INSERT INTO gri_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Maia ko Miriam na propete, na tasina daki a Aaron, e adia nina tsetsê, migira sui na daki ara tsarimurina ara rerekesigotoa niqira tsetsê mara gagavai. ");
INSERT INTO gri_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ma ko Miriam e lilinge vanigira me tsaria: “Linge vania na Taovia, rongona aia e mana sosongo gana; aia e tsoni luvusigira i laona na tasi igira sui na ose migira ara sage i koniqira.” ");
INSERT INTO gri_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mi muri, ma Moses e adigira na tinoni ni Israel tania na Tasi Tsitsi mara liu vano tana kaomate ni Sur. Mi laona e tolu na dani popono ara savu tana kaomate ia, mara tau goto tsodoa sa kô. ");
INSERT INTO gri_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mi muri, mara mailaba kesa tana nauna ara soaginia i Mara, ma na kô i tana e vavai sosongo me tau tangomana na inuviana. Aia nogo na rongona te ara soaginia tana nauna ia Mara. ");
INSERT INTO gri_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Migira na tinoni ara goko korekore vania a Moses mara veisuâ, “?Ma nagua sauba ka inuvia?” ");
INSERT INTO gri_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ma Moses e nonginongi kakai vania na Taovia, ma na Taovia e tusuvania kesa na takutina na gai, maia e adia me tsonitsunâ i laona na kô, ma na kô ia e mami, me dou vania na inuviana. Mi tana nauna nogo ia na Taovia e tusuvanigira visana na vali gana kara maurimuria, mi tana goto na Taovia e tovolegira. ");
INSERT INTO gri_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Maia e tsaria, “Ti vaga igamu kamu rongomangaqu saikesa inau ma kamu naua na omea inau au pada e goto, ma kamu muridougira sui niqu ketsa, me sauba e utu kau kedeginigamu goto sa vatana lobogu vaga au rotasiginigira nogo na Ejipt. Rongona inau nogo na Taovia au tali maurisigamu.” ");
INSERT INTO gri_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mi muri mara balaba i Elim, i tana ara totu sangavulu ruka na vuravura, mara vitu sangavulu na gai na koirou, mi tana ara vaturikaegira niqira valepolo i ligisana na kô. ");
INSERT INTO gri_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Igira na toga popono ni Israel ara mololea i Elim tana sangavulu tsegenina dani i laona na rukanina vula murina kalina ara mololea i Ejipt, mara mai tsau tana kaomate ni Sin, aia ka gaqira levuga na Elim ma na Sinai. ");
INSERT INTO gri_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mi laona na kaomate ia, igira ara goko korekore vanikaira tugua a Moses ma Aaron ");
INSERT INTO gri_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","mara tsarivanikaira, “Ke dou bâ ti vaga na Taovia ke matesigami nogo tana kao ni Ejipt, rongona i tana igami ami tamanina gamami velesina sabo ma gamami mutsa dangadanga vaga e tugugami na ganiana. Mi kagamu amu ka adimaigami ieni i laona na kaomate gana igami sui kami gini mate moa na vitoa.” ");
INSERT INTO gri_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ma na Taovia e tsarivania a Moses, “Kalina ia inau sauba kau moloa na bredi ke tumutsuna mai vanigamu sui talu i gotu. Ma niqira aqo na tinoni kara ba tsakoa pipi dani na dangana vaga e tugugira na ganiana tana dani ia. Sauba kau nauvaganana ia rongona kau gini tovolegira ma kau tsodovulagia laka ti igira kara dona na muriana niqu goko se tagara. ");
INSERT INTO gri_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mi tana ononina dani niqira aqo kara tsakoa ke ruka kalina na dangana vaga ara tsakoa pipi dani ma kara molomanogatia.” ");
INSERT INTO gri_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mi kaira a Moses ma Aaron ara ka tû mara ka tsarivanigira na toga popono ni Israel, “Tana ngulavi ieni nogo sauba igamu kamu donaginia laka aia nogo na Taovia e adirutsumigamu tania na Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Me ke matsaraka sauba kamu morosia na mararana angaanga na Taovia. Aia e rongominogoa nimui goko korekore amu nauvania. Eo, aia nogo amu goko korekore vania me tau i kagami, rongona i kagami ami ka naua moa na omea aia e ketsaliginikagami.” ");
INSERT INTO gri_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mi muri ma Moses e tsaria, “Aia nogo na Taovia sauba ke sauvanigamu na velesina sabo gana na mutsa tana ngulavi, mi tana matsaraka sauba ke sauvanigamu goto na dangana na bredi vaga amu kilia, rongona aia e rongominogoa nimui goko korekore amu nauvania. Eo, kalina igamu amu goko korekore vanikagami, migamu amu goko korekore vanimananâ na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mi muri, ma Moses e tsarivania a Aaron, “Ko tsarivanigira na toga popono kara labamai ieni ma kara tû i matana na Taovia, rongona aia e rongominogoa niqira goko korekore.” ");
INSERT INTO gri_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mi kalina a Aaron e gogoko vanigira moa na toga popono, migira ara pilo bâ tana kaomate, mara reia bâ na mararana angaanga na Taovia e tavongani laba tana parako i gotu. ");
INSERT INTO gri_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Inau au rongominogoa niqira goko korekore ara naua igira na toga ni Israel. Migoe ko bâ mo ko tsarivanigira laka tana ngulavi rovo sauba kara gania gaqira velesina sabo, mi tana matsaraka sauba kara tamanina gaqira bredi, ke danga vaga e tugugira na ganiana. Mi tana nogo ti igira sauba kara donaginiau laka inau nogo na Taovia niqira God.” ");
INSERT INTO gri_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mi tana ngulavi nogo ia, mara danga na manubau ara viri lovo mai, mara lovo tsuna tana nauna popono tana ara tototu, mi tana matsaraka dani ngana ma na kolobu e tsavu poponoa na kao polia na nauna tana ara tototu. ");
INSERT INTO gri_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mi kalina e nanga lê na kolobu me totu moa na omea madeve tatape me sere ara dangali poponoa na kao. ");
INSERT INTO gri_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Mi kalina igira na tinoni ni Israel ara reivaganana ia, mara vaiveisuagi mara tsaria, “?Nagua vaga ia?” Ma Moses e tsarivanigira, “Iani nogoria gamui bredi e tusuvanigamu na Taovia kamu gania. ");
INSERT INTO gri_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ma na Taovia e ketsaligamu laka pipi vidamui ke tsakoa ke danga vaga e tugua ke gania. Ke tsakoa ke ruka lita vania pipi tinoni i laona na valena.” ");
INSERT INTO gri_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Migira na tinoni ni Israel ara nauvaganana ia, mara visana vidaqira ara tsakoa danga bâ, mara visana ara tsakoa e tsaurae lê moa. ");
INSERT INTO gri_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mi kalina ara tovoa na dangaqira migira ara ba reia laka igira ara tsakogira danga, ara tau tamanina ke danga bâ, migira ara tsakoa e tsaurae lê moa ara tau goto noga sa omea. Pipi tinoni e tsakoa moa na dangana vaga e tugua ke gania. ");
INSERT INTO gri_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ma Moses e tsarivanigira, “Ke laka goto ke kesa na mololakaana sa turina gana ke matsaraka.” ");
INSERT INTO gri_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mara visana vidaqira ara petsakoe mangana a Moses, mara mololakâ na turina. Mi tana matsaraka dani ngana, me danga dato moa na meri i laona mara sigini mabulu, ma Moses e gini kore vanigira. ");
INSERT INTO gri_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Me pipi tana matsaraka pipi vidaqira e tsakoa na dangana vaga e tugua ke gania; mi kalina e tuturiga na papara na aso, migira ara tsidavisu tana kao ara viri rono sui. ");
INSERT INTO gri_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mi tana ononina dani migira ara tsakogira ruka kalina na dangana vaga ara tsakoa pipi dani, e vati lita vania pipi tinoni. Mi kalina igira sui na ida tana saikolu ara mai mara gini goko vania a Moses tana rongona ia, ");
INSERT INTO gri_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","maia Moses e tsarivanigira, “Na Taovia e moloketsana laka ke dani na dani na mango, me ngaoa igita ka balovania. Kamu bitinogoa i dani eni na omea amu ngaoa na bitiana, ma kamu kukia na omea amu ngaoa na kukiana. Ma na tsarana kamu mololakâ gana ke dani.” ");
INSERT INTO gri_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mara nauvaganana e ketsaligira a Moses, mara mololakâ na tsarana gana na dani vaolu; me tau goto mabulu se ke meriga. ");
INSERT INTO gri_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ma Moses e tsaria, “Kamu ganinogoa girani i dani eni, rongona i dani eni na dani na Sabat, na dani na mango igita a balovania na Taovia, me utu goto kamu ba tsodoa sa mutsa i tano i dani eni. ");
INSERT INTO gri_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nimui aqo kamu tsakoa gamui mutsa i laona e ono na dani, mi tana vitunina dani, aia na dani na mango, sauba kamu tau goto tsodoa sa mutsa.” ");
INSERT INTO gri_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mi tana vitunina dani mara visana vidaqira ara vano laka kara tsako mutsa, mara tau reia sa mutsa. ");
INSERT INTO gri_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mi tana ma na Taovia e tsarivania a Moses, “?Ke oka koegua sagata igamu kamu sove na muriaqira niqu ketsa ma niqu vali? ");
INSERT INTO gri_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kamu padatugua laka inau nogo na Taovia au molovanigamu na dani na mango, maia nogoria na rongona ti pipi tana ononina dani, sauba inau kau tusuvanigamu na mutsa ke tugugamu gana ke ruka dani. Me pipi tinoni nina aqo ke totu moa i valena tana vitunina dani, me ke tau goto rutsuligi tania na valena.” ");
INSERT INTO gri_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Me vaga ia, migira na tinoni ara tau goto pelea sa aqo tana vitunina dani. ");
INSERT INTO gri_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Igira na tinoni ni Israel ara soaginia na mutsa ia na mana. Aia e vaga na vatuna gai sere tetelo, me gani vaga na biskete ara aqosikoluginia na bulumitsua. ");
INSERT INTO gri_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ma Moses e tsaria, “Na Taovia e ketsaligita ka mololakagira kara visana na mana kara totu vanigira na kukuada, rongona igira kara morosiginia na mutsa aia e sauvanigita ka gania i laona na kaomate kalina aia e adirutsumigita tania na Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ma Moses e tsarivania a Aaron, “Ko adia kesa na popovatu, mo ko molosagea i laona ke ruka na lita na mana, mo ko ba mololakâ i matana na Taovia ke totu vanigira na kukuada.” ");
INSERT INTO gri_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Me vaga nogo na omea na Taovia e ketsaliginia a Moses, aia a Aaron e ba moloa na popovatu ia i matana na Bokisi na Taso rongona ke gini totu dou. ");
INSERT INTO gri_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Migira na tinoni ni Israel ara gania na mana ia i laona e vati sangavulu na ngalitupa, poi ara ba tsau tana kao ni Kanaan i tana ara ba totu kalavata. ");
INSERT INTO gri_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ma na popovatu ara gini totovo tana tagu ia, e tugua ke rukapatu na lita ke sage i laona. ");
INSERT INTO gri_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Migira na toga popono ni Israel ara mololea na kaomate i Sin, mara tû kesa tana nauna mara bâ kesa tana nauna segeni vaga nogo e ketsaliginigira na Taovia. Mara ba vaturikaegira niqira valepolo i Repidim, me tagara sa kô na inu ke totu i tana. ");
INSERT INTO gri_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Migira na toga ara goko korekore vanitugua a Moses mara tsaria, “Ko sauvanigami na kô na inu.” Ma Moses e tuguvisua me tsaria, “?Rongona gua ti amu goko korekore vaga ia? ?Me rongona gua ti amu tovole sailaginia moa na Taovia?” ");
INSERT INTO gri_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Migira na tinoni ara marou mate te ara gini tau kuti na goko korekore vaniana a Moses. Mara tsari vaganana, “?Rongona gua ti igoe o adirutsumigami tania na kao ni Ejipt? ?Rongona ngatsu o ngaoa igami, migira goto na dalemami, ma nimami omea tuavati, kami gini mate sui na marou?” ");
INSERT INTO gri_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Maia Moses e nonginongi kakai sosongo vania na Taovia me tsaria, “?Taovia, nagua sagata sauba kau nauvanigira na toga girani? Reia, e varangi nogo kara taimatesiau.” ");
INSERT INTO gri_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ma na Taovia e tsarivania a Moses, “Ko soagira kara visana na ida tana Israel ma kara dulikolugo, migamu kamu ida vano vanigira na toga. Migoe ko adiadi nimu itoro aia igoe o labugininogoa na Kô Nile me gini lia na gabu. ");
INSERT INTO gri_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Minau sauba kau tutû i matamui tana maragova tana Vungavunga Sinai. Migoe ko touginia nimu itoro na maragova ia, me sauba ko reia ke bubusu tsuna mai na kô vanigira na tinoni gana kara inu.” Ma Moses e nauvaganana ia i mataqira sui igira na ida tana Israel. ");
INSERT INTO gri_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mara soaginia tana nauna ia i Masa mi Meriba, rongona i tana nogo igira na Israel ara goko korekore mara tovolea na Taovia kalina ara veisuâ, “?Laka e totu kolugita manana na Taovia se tagara?” ");
INSERT INTO gri_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Migira na Amalek ara maiginigira na tinoni ni Israel i Repidim. ");
INSERT INTO gri_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ma Moses e tsarivania a Josua, “Ko viligira visana na mane kara dulikolugo ma kamu vano na vailabu koluaqira na Amalek ke dani. Minau sauba kau totu i kelana na tetena ma kau tangolia i limaqu na itoro aia God e tsarivaniau kau adia.” ");
INSERT INTO gri_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ma Josua e nauvaganana na omea e ketsaliginia a Moses, me bâ na vailabu koluaqira na Amalek, tana tagu tugira a Moses ma Aaron ma Hur ara tu dato i kelana na tetena. ");
INSERT INTO gri_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mi kalina a Moses e saukaea na limana, me gini managaqira igira na Israel, me ti vaga a Moses ke molotsunâ na limana, me tuturiga na managaqira igira na Amalek. ");
INSERT INTO gri_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mi kalina e pulo na limana a Moses, mi kaira a Aaron ma Hur ara ka tsebamai vania kesa na vatu gana ke totukae i konina, mi kaira ara ka tutû ligisana ruka tabana, mara ka tabekae vania na limana, mara ka tangoli vaganana ia poi e sû na aso. ");
INSERT INTO gri_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mi tana nauvaganana nogo ia, te e gini tangomana a Josua na labumatesiaqira sui lakalaka na Amalek. ");
INSERT INTO gri_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mi muri ma na Taovia e tsarivania a Moses, “Ko maretsunâ na turupatuna na tangomana tana vailabu ia, rongona igira na tinoni kara tau padalea. Mo ko tsarivanigotoa a Josua laka inau sauba kau toroutsani saikesaligira na Amalek.” ");
INSERT INTO gri_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ma Moses e logoa kesa na belatabu i tana me soaginia “Na Taovia aia nogo niqu pulaqe!” ");
INSERT INTO gri_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Maia e tsaria, “!Tangolikaea nina pulaqe na Taovia! Na Taovia sauba ke vailabu sailagi babâ moa kolugira na Amalek na dani ma na dani!” ");
INSERT INTO gri_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Aia a Jetro na manetabu ni Midian ma na tamana na tauna a Moses, e rongomia pipi na omea sui aia God e nauvania a Moses migira na tinoni ni Israel kalina aia e adirutsumigira tania na Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mi tana, maia Jetro e tû me mai na tsigoviana a Moses, me dulikolugotoa ko Sipora na tauna a Moses, aia e molovisunogoa i votangana konina tamana, ");
INSERT INTO gri_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","kolukaira goto na dalena mane kaira a Gersom ma Elieser. Kalina e botsa na kesanina dalena aia Moses e soaginia a Gersom rongona e tsaria “Inau na tinoni labavô tana vera tavosi.” ");
INSERT INTO gri_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ma na rukanina dalena mane e soaginia a Elieser rongona e tsaria, “Nina God na tamaqu e sangaau inau me laumaurisiau tania nina isi na taovia tsapakae ni Ejipt.” ");
INSERT INTO gri_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ma Jetro e mai kolua na tauna a Moses mi kaira na dalena mane tana kaomate i tana a Moses e vaturikaea nina valepolo tana vungavunga tabu. ");
INSERT INTO gri_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Maia e mologoko ida bâ vania a Moses laka tugira ara tu maimai nogo na tsigoviana, ");
INSERT INTO gri_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","me tû a Moses me ba valaletugira i sautu, me tsuporu tsuna i matana a Jetro me domia. Mara tu vaiveisuagi ti vaga kara tu mauri dou sui, mi muri mara tu ba sage tana nina valepolo a Moses. ");
INSERT INTO gri_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ma Moses e turupatuna vania a Jetro pipi sui na omea aia na Taovia e nauvania na taovia tsapakae migira na tinoni ni Ejipt gana ke laumaurisiginigira na tinoni ni Israel. Maia e katevanigotoa na rota sui e gadovigira na tinoni kalina ara maimai i sautu, me koegua kalina na Taovia e maurisigira. ");
INSERT INTO gri_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Mi kalina a Jetro e rongomia na omea sui girani maia e gini mage ");
INSERT INTO gri_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","me tsaria, “!Tsonikaea na Taovia, aia e laumaurisigamu tania na limana na taovia tsapakae ni Ejipt migira nina tinoni! !Tsonikaea na Taovia, aia e maurisigira nina tinoni segeni tania na totu tseka! ");
INSERT INTO gri_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Mi kalina ia, inau au donaginia laka na Taovia God e loki tsapakae liusigira na god sui, rongona aia e nauvanigira na omea iani kalina igira na Ejipt ara tsogori tsunaligira sosongo na tinoni ni Israel.” ");
INSERT INTO gri_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mi muri, ma Jetro e adimaia kesa na sausau gana na savori-kodokodo, me visana goto na sausau gana na savori vaniana God; ma Aaron migira sui na ida tana Israel ara vanokolua a Jetro na ganiana na mutsa tabu vaga kesa na aqona na samasama vaniana God. ");
INSERT INTO gri_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mi tana dani ngana, ma Moses e totu matengana moa na tineteana niqira vaiganigi na tinoni, me tau goto mango tû tana matsaraka me poi i bongi. ");
INSERT INTO gri_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mi kalina a Jetro e reigira na omea sui vaga gira e naua a Moses vanigira na tinoni, maia e tû me veisuâ a Moses, “?Na gua sagata o nanau vanigira na tinoni igoe? ?Rongona gua ti o nau seginimu moa igoe na aqo popono na pedeaqira na tinoni, migira sui ara tupolipoligo tû tana matsaraka me poi i bongi?” ");
INSERT INTO gri_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ma Moses e tuguvisua me tsaria, “Ma niqu aqo nogo inau kau naua na omea iani, rongona igira na toga girani ara mai i koniqu inau na laveana na omea e kilia God. ");
INSERT INTO gri_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Mi kalina ti vaga ara ka ruka ara ka vaiganigi, mi kaira ara ka mai i koniqu, minau au votagoko vanikaira, mau vuresi vanikaira nina ketsa ma nina vali God.” ");
INSERT INTO gri_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mi tana ma Jetro e tsarivania, “Na omea ia o naua igoe e tau goto sosongo. ");
INSERT INTO gri_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Na aqo iani e loki sosongo me tau tugugo igoe ko nau segenia, me sauba ko gini kolae sosongo migira goto na tinoni girani. ");
INSERT INTO gri_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Mi kalina ia e dou ti ko tamivaniau inau kau tsarivanigo ke visana niqu papada, ma God aia sauba ke totu kolugo. Eo e mana, e goto sosongo vanigo ko tugugira na tinoni i matana God, mo ko adi bâ vania aia niqira vaiganigi. ");
INSERT INTO gri_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ma nimu aqo loki goto igoe ko sasaniginigira na toga nina ketsa ma nina vali God, mo ko tsaritugutugu vanigira ke koegua na vavanona niqira mauri, ma nagua niqira aqo kara naua. ");
INSERT INTO gri_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ma na kamagana ia, e dou ti ko viligira kara visana na mane dou, igira ara kukuni tania God mara tinoni nonoru, mara tau dona na adiqolona na sanga pede kesa tabana, mo ko mologira kara ida vanigira na tinoni: visana kara ida vanigira na toga, visana vanigira na sangatu, ma na tsege sangavulu ma na sangavulu. ");
INSERT INTO gri_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ko molo vanigira kara aqo kalavata tana tinete omea vanigira na tinoni. E dou moa ti kara adimai vanigo moa igoe pipi na omea loki, migira segeni nogo kara tinetea na vaiganigi tetelo. Mi tana nauvaganana ia, ti igira kara sangago tana gamu kalagai, me ke gini malamala vanigo igoe. ");
INSERT INTO gri_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Me ti vaga igoe ko nauvaganana ia tana omea God e ketsaliginigo, me sauba e utu ko gini kolae sosongo, ma na tinoni sui girani sauba ke dou na tobaqira ma kara visu i valeqira tana rago.” ");
INSERT INTO gri_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ma Moses e tabea nina goko a Jetro, ");
INSERT INTO gri_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","me bâ me viligira visana na mane dou igira e goto niqira sasaga i laoqira popono na tinoni ni Israel, me mologira kara idavanigira na toga, na sangatu, na tsege sangavulu ma na sangavulu. ");
INSERT INTO gri_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Migira nogo ara aqo kalavata tana tinete omea vanigira na tinoni, ma na omea loki sosongo moa ti ara adimai vania a Moses, ma na vaiganigi tetelo igira segeniqira nogo ara tinetea. ");
INSERT INTO gri_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mi muri, ma Moses e vailivua a Jetro, ma Jetro e visutugua i verana. ");
INSERT INTO gri_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Migira na tinoni ni Israel ara mololea i Repidim, mi tana kesanina dani tana tolunina vula murina kalina ara mololea i Ejipt migira ara mai tsau tana kaomate ni Sinai. Mi tana i tuana nogo na Vungavunga Sinai ara vaturikaegira niqira valepolo, ");
INSERT INTO gri_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ma Moses e dato tana vungavunga ke ba goko kolua God. Ma na Taovia e tû i kelana na vungavunga me soâ a Moses, me ketsalia ke tsaria na omea iani vanigira na toga ni Israel, igira nogo na kukuana a Jakob, ");
INSERT INTO gri_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Igamu segenimui nogo amu reilakana na omea loki inau na Taovia au nauvanigira na tinoni ni Ejipt, me koegua kalina inau au tsebakaegamu igamu vaga na manuloki kalina e tsebakaea na dalena tetelo i gotuna na rapona, mau adimaigamu ieni i mataqu inau. ");
INSERT INTO gri_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mi kalina ia, ti vaga igamu kamu rongomangaqu dou, ma kamu manalia gamui tabana na vaitasogi au naunogoa kolugamu, me sauba igamu kamu lia niqu tinoni segeni inau. Na barangengo popono niqu tamani segeni nogo inau, migamu sauba kamu lia niqu tinoni vivili, ");
INSERT INTO gri_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","na puku manetabu ma na mamatana tinoni tabu.” ");
INSERT INTO gri_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mi tana ma Moses e tsunatugua i lao, me soasaigira gaqira ida na tinoni me turupatuna vanigira pipi sui na omea na Taovia e ketsalia ke tsarivanigira. ");
INSERT INTO gri_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Migira sui na tinoni ara gokovisu kesa moa kalina mara tsaria, “Sauba kami nau mananâ pipi sui na omea aia na Taovia e tsaria.” Mi tana e tû a Moses me visu bâ i konina na Taovia me tsarivulagi vania niqira goko na toga. ");
INSERT INTO gri_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ma na Taovia e tsarivania a Moses, “Inau sauba kau tsunamai i konimu igoe i laona na parako matolu rongona igira na toga kara gini rongomiau inau kalina kau goko kolugo, ma kara gini tutunimu igoe.” Ma Moses e tsarivulagi vania na Taovia na omea vaga igira na tinoni ara tsarivisua, ");
INSERT INTO gri_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ma na Taovia e tsaria, “E dou, mi kalina ia igoe ko visutsuna tugua i koniqira na toga, mo ko tsarivanigira kara malesi segeniqira i dani eni me ke dani, ma kara tsagia na poloqira, ");
INSERT INTO gri_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ma kara totu vangarau vania na maiaqu ke danina, rongona tana dani ia inau sauba kau tsunamai tana Vungavunga Sinai i tana igira sui na tinoni tangomana kara morosiau inau. ");
INSERT INTO gri_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ko moloa na votavota polia na tuana na vungavunga, i tana niqira aqo na tinoni kara tau liusia, mo ko tsarivanigira kara laka goto na datomai tana vungavunga, se na mai varangisiana goto. Me ti vaga ke kesa ke molo tuana i konina, aia kamu matesia; ");
INSERT INTO gri_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","nimui aqo nomoa kamu taimatesia, se kamu vanasiginia na pipili, me ke laka goto ke kesa na peleana. Na ketsa iani e kalegira sui na tinoni ma na omea tuavati; niqira aqo kara mate. Mi kalina kamu rongomia ke tangi tatavata na tavuli, mi tana ti igira na toga kara mai tana tuana na vungavunga.” ");
INSERT INTO gri_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mi muri, ma Moses e tsunamaitugua tania na vungavunga, me tsarivanigira na toga kara vangarau segeniqira vania na samasama. Me vaga ia, migira sui ara tsagia na poloqira, ");
INSERT INTO gri_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ma Moses e tsarivanigira, “Kamu vangarau segenimui vania ke danina, ma kamu laka na maturu sai koluaqira na taumui tana tagu iani.” ");
INSERT INTO gri_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mi tana matsaraka na tolunina dani, e poda loki na vivisa me kirapi na angaanga, me kesa na parako matolu e laba i kelana na vungavunga, mara rongomia kesa na tavuli e tangi loki sosongo. Me pipi sui na tinoni ara totu i tana ara viri gariri tana matagu. ");
INSERT INTO gri_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ma Moses e idavanigira, mara mololea tana nauna i tana ara vaturikaegira niqira valepolo, mara mai tutû i matana God tana tuana na vungavunga. ");
INSERT INTO gri_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ma na pungu loki e tsavu poponoa na Vungavunga Sinai, rongona na Taovia e tsunamai i kelana tana rereina na lake. Ma na pungu ia e vulosudato vaga moa na punguna kesa na biti loki, me kakasisi na vungavunga popono. ");
INSERT INTO gri_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Me tangi loki goto bâ na tavuli, ma Moses e goko, ma God e tuguvisua i laona na quluqulu. ");
INSERT INTO gri_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Na Taovia e tsunamai i kelana na Vungavunga Sinai me soâ a Moses ke dato bâ i konina. Ma Moses e dato ");
INSERT INTO gri_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ma na Taovia e tsarivania, “Ko tsunabatugua mo ko parovatavigira na tinoni kara laka saikesa na liusiana na votavota ma na mai na morosiaqu inau; me ti vaga kara naua, me sauba kara danga na vidaqira kara mate. ");
INSERT INTO gri_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Me atsa goto moa ti igira na manetabu igira ara dona na mai varangisiaqu inau, ma niqira aqo goto igira kara malesi segeniqira talu, me ti tagara minau sauba kau kedegira.” ");
INSERT INTO gri_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ma Moses e tsarivania na Taovia, “Igira na toga e utu kara dato mai ieni, rongona igoe nogo o ketsaliginigami igami kami balovanigo na Vungavunga Sinai ma kami moloa na votavota polipolia.” ");
INSERT INTO gri_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ma na Taovia e tsarivania, “Ko tsuna tugua mo ko dulikolu datomaia a Aaron. Migira moa na manetabu ma na toga niqira aqo kara laka saikesa na liusiana na votavota ma na datomai i koniqu inau, me ti vaga kara naua minau sauba kau kedegira.” ");
INSERT INTO gri_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mi muri, ma Moses e visutugua i koniqira na toga, me ba turupatu vanigira na omea na Taovia e tsaria. ");
INSERT INTO gri_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ma God e goko, migirani nogo nina tsaqina goko aia e tsaria: ");
INSERT INTO gri_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Inau na Taovia nimui God minau nogo au adirutsumigamu tania na Ejipt i tana igamu amu totu tseka. ");
INSERT INTO gri_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Kamu laka goto na samasama vaniana sa god tavosi. Inau segeni moa kamu samasama vaniau. ");
INSERT INTO gri_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Kamu laka goto na aqosiana sa nununa sa god peropero se sa omea i baragata se tana barangengo, se tana kô i vavana na barangengo. ");
INSERT INTO gri_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kamu laka na tsuporu tsuna vaniana se na samasama vaniana na titinonina sa god peropero, rongona inau nogo na Taovia nimui God me utu goto kau tamivanigamu kamu tamanina sa god tavosi. Inau sauba kau kedegira igira ara reisaviau inau me ke tsau bâ tana tolunina ma na vatinina vatavata na kukuaqira. ");
INSERT INTO gri_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ma kau sauvulagia niqu galuve vanigira na toga na vatavata igira ara padalokiau inau mara muridougira niqu ketsa. ");
INSERT INTO gri_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Kamu laka na soasekoliana na asaqu, rongona inau na Taovia nimui God me sauba kau kedea asei ti ke soasekolia na asaqu. ");
INSERT INTO gri_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Kamu muridoua na ketsa na mango tana Dani na Sabat, ma kamu laka na aqo tana. ");
INSERT INTO gri_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ara ono na dani i tana tangomana igamu kamu naua nimui aqo, ");
INSERT INTO gri_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ma na vitunina dani, aia na dani na mango, inau au balonogoa vaniau. Tana dani ia ke laka goto na aqo ke kesa, atsa moa ti igamu, se igira na dalemui, se nimui tseka, se nimui omea tuavati, se igira goto na tinoni ni veratavosi ara mauri i laona na veramui. ");
INSERT INTO gri_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","I laona e ono na dani, inau na Taovia au aqosia na barangengo, na masaoka, na tasi, me pipi sui na omea i laoqira, mi tana vitunina dani au mango. Maia nogoria na rongona ti inau na Taovia au baloa na dani na Sabat mau tabua. ");
INSERT INTO gri_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kamu kukuni tanikaira na tamamui ma na tinamui, ti kamu gini mauri oka tana kao inau na Taovia nimui God au tusuvanigamu. ");
INSERT INTO gri_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kamu laka na labumatesi tinoni. ");
INSERT INTO gri_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Kamu laka na kiboga. ");
INSERT INTO gri_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kamu laka na komi. ");
INSERT INTO gri_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Kamu laka na keli seko vaniana na kulamui. ");
INSERT INTO gri_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Kamu laka na ngaoana na valena kulamui; ma kamu laka goto na ngaoana na tauna kulamui, se nina tinoni aqo, na mane se na daki, se nina buluka ma nina asi, se sa nina omea koegua moa aia e tamanina.” ");
INSERT INTO gri_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mi kalina igira na toga ara rongomia e poda na vivisa, me tangi loki na tavuli, mara reia na kirapina na angaanga, ma na pungu e vulosudato tana vungavunga, migira ara viri matagu loki mara gagariri mara tutû ao moa. ");
INSERT INTO gri_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mara tsarivania a Moses, “Ti vaga igoe segenimu nogo ko goko vanigami, migami sauba kami rorongo; mo ko laka moa na tamivaniana God ke goko vanigami kami tau mate.” ");
INSERT INTO gri_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ma Moses e tsarivanigira, “Kamu laka na matagu; God e mai ke tovolegamu moa, me ke naua ma kamu gini tau kuti na kukuni taniana, ma kamu gini tau puka tana sasi.” ");
INSERT INTO gri_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Migira na toga ara tutû ao babâ moa, ma Moses segeni moa e ba varangisia na parako matolu i tana e totu God. ");
INSERT INTO gri_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Na Taovia e ketsalia a Moses ke tsarivaganana iani vanigira na toga ni Israel, “Igamu amu morosinogoa e koegua kalina inau na Taovia au goko vanigamu tû i gotu i baragata. ");
INSERT INTO gri_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kamu laka na aqosivaniamui segeni na titinonina sa god peropero ginia na siliva se na qolumila gana na kamagaginiana na samasama vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kamu aqosiginia na kao na belatabu vaniau inau, mi kelana nogo ia kamu savorigira nimui sipi ma nimui buluka vaga na savori-kodokodo ma na sausau tangomana na tinoni kara ganipatâ na turina. Me pipi sui tana nauna inau kau vilivanigamu i tana kamu samasama vaniau minau sauba kau mai totu i konimui i tana ma kau tabugamu. ");
INSERT INTO gri_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Me ti vaga kamu ngaoa na aqosivaniaqu kesa na belatabu vatu, ma kamu laka na aqosiginiana na vatu kakatsu, rongona ti kamu gini aqo na gau na katsuvatu tana aqosiana na belatabu ia, maia sauba ke tau ulagana na gini samasama vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Kamu laka goto na logoana na belatabu ke tamani sasana na tsotsodato i konina; rongona ti vaga kamu nauvaganana ia me sauba ke laba lê na tutukemui kalina kamu tsotsodato i konina. ");
INSERT INTO gri_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Igirani nogo na ketsa ko tusuvanigira na toga ni Israel: ");
INSERT INTO gri_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ti vaga igoe ko volia ke kesa na Hibru ke lia nimu tseka, ma nina aqo aia ke aqo vanigo i laona ke ono moa na ngalitupa. Mi tana vitunina ngalitupa nimu aqo igoe ko nusiligilea me tau goto kilia ke tsonia sa qolo. ");
INSERT INTO gri_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Me ti vaga aia e tau vati tauga kalina o volia, me ke laka goto na adiana sa tauna kolua kalina aia ke vanoligi; me ti vaga aia e tauga nogo kalina e lia nimu tseka, maia tangomana ke adia na tauna kalina ke vano. ");
INSERT INTO gri_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Me ti vaga gana taovia ke tusuvania sa tauna maia e vasuvania ke visana na dalena mane se na dalena daki, ma na daki ia migira goto na dalena e tamanigira sui gana taovia, mi kalina ti ke sui nina tagu na aqo vaniana gana taovia na mane tseka ia, maia nina aqo ke vanoligi segenina. ");
INSERT INTO gri_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Me ti vaga na mane tseka ia e tsaria laka e padaloki sosongolia gana taovia, ma na tauna, migira goto na dalena, me tau ngaoa na totu tanusi, ");
INSERT INTO gri_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ma nina aqo gana taovia ke adivanoa tana nauna gana na samasama, mi tana aia ke molovania ke tu vataragi ligisana na matsapa, se tana gaitudato tana matsapa, me ke ovativania na kulina. Mi muri, maia ke lia nina tseka tana maurina popono. ");
INSERT INTO gri_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Me ti vaga kesa mane ke tsoni tsekâ sa dalena daki, ma na baka daki ia e utu goto kara nusilea vaga ara nauvanigira na tseka mane. ");
INSERT INTO gri_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Me ti vaga na baka daki ia kara tsabirivania sa mane e ngaoa na taugaana, mi muri ma na mane ia e tau tugua ngaoa na taugaana, mi tana ma nina aqo ke tsabiri visutugua na baka daki ia vania na tamana; me tabu vanigotoa gana taovia ke tsabirivania sa tinoni ni veratavosi, rongona aia e tau nogo mana vania. ");
INSERT INTO gri_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Me ti vaga kesa mane ke volivania na dalena mane sa daki tseka, ma nina aqo na mane ia ke nauvania vaga ti na dalena daki segeni nogo ia. ");
INSERT INTO gri_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Me ti vaga ke kesa mane ke adigotoa na rukanina tauna, ma nina aqo ke sau babâ vania moa na kesanina tauna na dangana na mutsa ma na polo ma gana susuliga i laona na vale, ke atsa vaga moa na omea e sauvaninogoa tana idana. ");
INSERT INTO gri_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Me ti vaga na mane ia ke tau nautovusi vania na aqo girani, ma nina aqo aia ke nusilea moa me ke tau goto nongi qolona. ");
INSERT INTO gri_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Masei moa ti vaga ke labua sa tinoni me ke mate, nimui aqo kamu labumatesigotoa aia. ");
INSERT INTO gri_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Me ti vaga ke tau padâ na matesiana me tavongani matesia moa, maia tangomana moa ke tsogo me ke ba toturavi kesa tana nauna i tana inau sauba kau vilivanigamu gana na mani tsogoravi. ");
INSERT INTO gri_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mi kalina ti vaga kesa tinoni ke kore me ke pada mananâ i tobana na labumatesiana kesa tinoni, nimui aqo kamu labumatesigotoa aia, atsa moa ti aia ke tsogovano tana niqu belatabu gana ke gini toturavi. ");
INSERT INTO gri_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Masei moa ti vaga ke labua na tamana se na tinana, ma nimui aqo kamu labumatesia aia. ");
INSERT INTO gri_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Masei moa ti vaga ke adikomia sa tinoni, me atsa moa ti kara tsodoa ke tototu moa i konina se ke tsabirinogoa ma nimui aqo kamu labumatesia aia. ");
INSERT INTO gri_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Masei moa ti vaga ke vealaginia na tamana se na tinana, ma nimui aqo kamu labumatesia aia. ");
INSERT INTO gri_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Me ti vaga ke laba kesa na vailabugi, me ke tû kesa me ke taiginia na vatu sa tinoni tavosi se ke labuginia na kapurukuna limana, me tau moa matesia, maia e tau kilia kamu kedea. Me ti vaga na mane aia e labua ke boka loki me tugua ke tsaro i nigena, mi muri me tangomana ke tû tugua me ke gini vanovano bamai na itoro i tano, maia na mane e nauvania ia nina aqo nomoa ke volia na maurina me ke reitutugua poi tsau ke dou visutugua. ");
INSERT INTO gri_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Me ti vaga kesa tinoni ke labuginia na gai nina tseka, atsa moa na mane se na daki, ma na tseka ia ke mate saviliu, ma na mane ia nimui aqo kamu kedea. ");
INSERT INTO gri_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Me ti vaga na tseka ia ke tau mate saviliu, mi murina kesa se ruka dani ti ke mate, ma nimui aqo kamu tau kedea gana taovia; rongona na nangaliana nina omea tatamani e tugunogoa ngiti gana kede. ");
INSERT INTO gri_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Me ti vaga visana kara vailabugi ma kara ba kidâ kesa daki titiana, me ke gini vasubutoa na dalena ma na daki ia e tau moa boka, maia e kidâ na daki ia nina aqo ke tasolu matena, me ke tsonia na dangana na qolo vaga ke ngaoa na savana, taonia niqira pede na manepede. ");
INSERT INTO gri_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Me ti vaga na daki segeni goto nogo ke boka, ma na kedena ia sauba ke vaga iani: ti vaga ke mate na daki ia me sauba kamu matesigotoa na mane ia, ");
INSERT INTO gri_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","me ti vaga ke putsulia na matana, ma kamu putsuli vanigotoa na matana ia, me ti vaga ke lumuvutia na livona, ma kamu lumuvutigotoa na livona na mane ia, me ti vaga ke kutsia na limana, ma kamu kutsi vanigotoa na limana na mane ia, me ti vaga ke kutsia na tuana, ma kamu kutsivanigotoa na tuana na mane ia, ");
INSERT INTO gri_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","me ti vaga ke gâ na daki ia, ma kamu kodogotoa na mane ia, me ti vaga ke boka, ma kamu bokaligotoa na mane ia, me ti vaga ke tsomo, ma nimui aqo kamu naua me ke tsomo goto na mane ia. ");
INSERT INTO gri_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Me ti vaga kesa tinoni ke labua na matana nina mane tseka se nina daki tseka me gini nanga na matana, aia nina aqo ke moloa nina tseka ke totu tanusi vaga na vovolina na matana. ");
INSERT INTO gri_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Me ti vaga ke labukutsia kesa livona, aia nina aqo ke moloa nina tseka ke totu tanusi vaga na vovolina na livona. ");
INSERT INTO gri_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Me ti vaga kesa na buluka mane ke labuginia kesa tinoni na kakatsana me ke mate, ma nimui aqo kamu taimatesia na buluka ia, ma na velesina kamu tau gania; ma kamu tau goto kedea na tamanina na buluka. ");
INSERT INTO gri_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Me ti vaga na buluka mane ia na vanga kore nogo me dona na takuvi tinoni, mara parovatavinogoa na tamanina, maia e tau molosagea i laona na bara, me ke tû na buluka mane ia, me ke labuginia kesa tinoni na kakatsana me ke mate, ma kamu taimatesia na buluka ia, ma kamu labumatesigotoa na tamanina. ");
INSERT INTO gri_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Me ti vaga kamu tamivania na tamanina ke tsonia na qolo na keke ke gini mauri, ma nina aqo ke tsonia na matena popono ara tsarivania. ");
INSERT INTO gri_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Me ti vaga na buluka mane ke matesia kesa sa baka mane se sa baka daki, me ke kesa atsa moa na ketsa kamu gini aqo. ");
INSERT INTO gri_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Me ti vaga na buluka mane ke matesia sa mane se sa daki tseka, ma na tamanina na buluka ia ke tsonia ke tolu sangavulu na tavina siliva na matena vania na tamanina na tseka ia, ma kamu taimatesia na buluka ia. ");
INSERT INTO gri_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Me ti vaga ke kesa ke adiligia na tsatsavuna kesa na qilu, se ke tsaia kesa na qilu me ke tau tsavudoua, me ke mai kesa na buluka mane se na asi me ke puka sage i laona, ");
INSERT INTO gri_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ma nina aqo na mane ia ke tsonimatena na omea tuavati ia vania na tamanina, me dou moa ti ke tangolivisua na omea tuavati e mate. ");
INSERT INTO gri_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Me ti vaga nina buluka mane kesa tinoni ke matesia nina buluka mane kesa tinoni tavosi, mi kaira sui ruka na tamanina buluka kara tsabiria na buluka mamauri ia, ma kara ka vaivotagi na qolona; ma kara ka vaivotagi goto na velesina na buluka e mate. ");
INSERT INTO gri_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Me ti vaga ara dona nogo laka na buluka mane ia nina lavu nogo na nauvaganana ia, ma na tamanina e tau moa molosagea i laona na bara, ma nina aqo ia ke tugua na buluka mane e mate ginia kesa na buluka mamauri, me dou moa ti ke tangolivisua aia e mate. ");
INSERT INTO gri_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Me ti vaga kesa na mane ke komia kesa na buluka daki se kesa na sipi me ke matesia se ke tsabiria, ma nina aqo ke tuguvisuginia ke tsege na buluka daki na tuguna kesa na buluka daki me ke vati na sipi na tuguna kesa na sipi. ");
INSERT INTO gri_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Nina aqo na mane e komi ke tsonia na matena popono na omea aia e komia. Me ti vaga aia ke tau tamani sa omea, ma na mane ia sauba kara tsabiria vaga na tseka gana ke gini mategâ na omea e kominogoa. Me ti vaga na omea tuavati aia e komia, atsa moa ti na buluka, se na asi, se na sipi, kara reia ke totu mamauri moa i konina, me sauba nina aqo na mane ia e komi ke mategaginia ruka na tuguna kesa. “Me ti vaga kesa na mane komi ara tangolia kalina e kokomi i laona kesa vale tana bongi ma kara matesia, aia e matesia na mane ia e tau kutsia na ketsa na labumate. Me ti vaga na omea iani ke laba tana dani male, maia e sogo tana ketsa na labumate. ");
INSERT INTO gri_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Me ti vaga kesa mane ke tsoni rutsumigira nina omea tuavati kara ba mutsa i laona kesa nina uta, se i konina kesa nina itai na uaeni, me tamivanigira moa kara vano i laona nina uta kesa tinoni tavosi ma kara ganisuia pipi na omea tsukatsuka i laona, ma nina aqo na tamanina na omea tuavati gira ke tuguvisuginia nina omea tsukatsuka i laona nina uta segeni se nina itai na uaeni segeni. ");
INSERT INTO gri_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Me ti vaga kesa tinoni ke tungilake i laona nina uta, me ke iru bâ i laona na buruburu me ke ba tsau tana nina uta kesa tinoni tavosi, me ke ganisuia na sila ara dadato i laona, se na sila ara ivogogira nogo mara tsupulaginigira, ma nina aqo aia e tungilake ke tsonimatena na omea ara seko. ");
INSERT INTO gri_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Me ti vaga kesa tinoni ke tami na reitutugu vaniana nina qolo kesa tinoni tavosi se ke visana nina omea loki matena, me ke kesa ke ba komigira i laona na valena, ma na mane komi ia ti vaga kara tsodoa, nina aqo ke tsonia na qolo ke pabo ruka kalina na dangana. ");
INSERT INTO gri_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Me ti vaga kara tau tsodoa na mane e komi, ma kara adivanoa na mane reitutugu omea ia tana nauna gana na samasama, mi tana ti aia ke gini vatsa i matana God laka aia e tau manana komia nina omea tatamani aia e mololakâ omea i konina. ");
INSERT INTO gri_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Me pipi tana vaiganigi tana rongona na omea tatamani, atsa moa ti vaga ke kalegira na buluka, se na asi, se na sipi, se na polo, se sa omea tavosi goto e nanga, mi kaira ruka ara ka gini vailaugi tana rongona na omea tatamani ia, kara adivanokaira i matana God tana nauna gana na samasama, mi tana maia na mane God e tsaria laka e sasi nina aqo ke tsonia na qolo ke pabo ruka kalina vania na mane tavosi. ");
INSERT INTO gri_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Me ti vaga kesa ke tamia na reitutuguana nina asi, se nina buluka, se nina sipi, se ke kesa segeni goto na omea tuavati tavosi vania kesa tinoni, ma na omea tuavati ia ke mate, se ke boka, se kara laua tana vailabu, me ti vaga ke tagara ke kesa ke sanga na morosiana na omea e laba, ");
INSERT INTO gri_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ma nina aqo na mane ia ke vano tana nauna gana na samasama, me ke ba vatsa i matana God laka aia e tau komia nina omea tuavati na tinoni tavosi. Me ti vaga aia e tau komi mananâ na omea tuavati ia, maia na tamanina omea nina aqo ke tabea moa nina vatsa, ma na mane reitutugu omea e tau kilia ke tsoni matena; ");
INSERT INTO gri_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","me ti vaga aia e komia na omea tuavati ia, ma nina aqo ke tusutuguna vania na tamanina. ");
INSERT INTO gri_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Me ti vaga ke kesa na omea atsi ke gati matesia, ma nina aqo na mane reitutugu omea ke adimaia na turina agana ke gini sauvulagia na manana; mi tana me tau kilia aia ke tsonimatena na omea tuavati ara gatimatesia na omea atsi. ");
INSERT INTO gri_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Me ti vaga kesa tinoni ke nongia ke gini aqo kesa nina omea tuavati kesa tinoni tavosi, ma na omea tuavati ia ke boka se ke mate kalina e tau totu na tamanina, ma nina aqo na mane ia ke tsonimatena vania na tamanina. ");
INSERT INTO gri_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Me ti vaga na omea vaga ia ke laba kalina e totu moa na tamanina, ma na mane ia e tau kilia ke tsonimatena. Me ti vaga aia e tabanogoa na omea tuavati kalina e adia, ma na qolona na taba e tsavunogoa na matena na omea tuavati e mate. ");
INSERT INTO gri_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Me ti vaga kesa na mane e maturu kolua kesa na baka daki vaolu e tau vaianegi kolua kesa, aia nina aqo ke tsonia na qolo na vuvuti me ke taugâ. ");
INSERT INTO gri_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Me ti vaga na tamana e tau tamivania na mane ia ke taugâ na dalena, ma nina aqo na mane ia ke tsonivania na tamana na baka daki na qolo ke atsa kolua na qolo na vutiana kesa na baka daki vaolu. ");
INSERT INTO gri_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kamu labumatesia na daki aia e basutidao. ");
INSERT INTO gri_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Kamu labumatesia na mane e sasi kolua kesa na omea tuavati. ");
INSERT INTO gri_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Kamu pede matesia aia e savori-kodoputsa vania sa god tavosi me tau savori vaniau inau na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kamu laka na rotasiaqira lê se na bingi sekoliaqira igira na tinoni ni veratavosi ara tsinogomai i veramui; kamu padatugua laka i sau igamu goto amu rota na totu tsinogo tana vera ni Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kamu laka goto na molorota vaniana sa daki se sa baka tinamate. ");
INSERT INTO gri_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Rongona ti vaga igamu kamu nauvaganana ia, minau nogo na Taovia sauba kau isutuguqira kalina igira kara ngangaidato vaniau kau sangagira, ");
INSERT INTO gri_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","me sauba kau kore loki ma kau labumatesiginigamu na isi tana vailabu. Mi tana ti igira na taumui segenimui nogo igamu kara totu tinamate lê, migira na dalemui kara tau goto tamani tamaqira. ");
INSERT INTO gri_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Me ti vaga kamu tamivania kesa niqu tinoni aia e tau tamanina sa omea ke kaoni qolo i konimui, migamu kamu laka na nauvaniana vaga ara naua visana, igira ara dona na nongi papabona i koniqira na tinoni ara kaoni qolo i koniqira. ");
INSERT INTO gri_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Me ti vaga kamu adia na polona sagesage kesa tinoni e tau tamanina sa omea rongona aia e kaoni qolo nogo i konimui, ma nimui aqo kamu tusuvisu vaninogoa na polona ti ke sû na aso, ");
INSERT INTO gri_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","rongona aia lelê moa ngiti polona sagesage aia e tamanina gana ke gini popolo me ke gini papara na konina. ?Rongona ti vaga kamu tau tusuvisu vania na polona, me sauba nagua goto aia ke gini tsatsavu kalina ke maturu? Mi kalina aia ke tû me ke ngangai dato vaniau inau kau sangâ, minau sauba nomoa kau rongomia nina nonginongi ma kau sangâ, rongona inau au dona sosongo na galuveaqira na tinoni. ");
INSERT INTO gri_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kamu laka na gokoseko vaniana God, ma kamu laka goto na vealaginiana kesa niqira ida nimui tinoni. ");
INSERT INTO gri_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Laka goto na kisa na sauvaniaqu inau na sausau e talu tana nimui uta na sila, nimui uaeni ma nimui oela na olive. “Ma kamu sauvaniau na dalemui mane botsaida. ");
INSERT INTO gri_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ma kamu saugotoa vaniau na daleqira botsaida nimui buluka ma nimui sipi. Kamu molotalua ke totu kolua na tinana ke vitu na dani, mi tana alunina dani ti kamu savori vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Igamu niqu tinoni inau, me vaga ia, ma nimui aqo kamu tau gania na velesina sa omea tuavati igira na omea atsi ara gati matesia, ma kamu sauvanigira moa nogo na pai kara gania. ");
INSERT INTO gri_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kamu laka na govula bamaiana na goko peropero ni sautu, ma kamu laka goto na sogogana na tinoni e tsutsukibo ma na isutuguna tana pede. ");
INSERT INTO gri_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kamu laka na bulu bâ tabana koniqira ara danga kalina ara sasi, se kalina ara saugokona peropero me gini tau vano goto na pede. ");
INSERT INTO gri_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ma kamu laka goto na sanga tabana konina kesa e tau tamanina sa omea kalina aia e totu tana pede. ");
INSERT INTO gri_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Me ti vaga igoe ko reia nina buluka se nina asi gamu gala ke tova, ko adivisu vania moa. ");
INSERT INTO gri_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Me ti vaga nina asi ke mamava gana lutsa me ke puka, ko sangâ na tatatuuana tugu. Ko laka na liuputsi lê taniana. ");
INSERT INTO gri_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kamu laka goto na tiatagaraana na pedegoto vania sa tinoni e tau tamanina sa omea kalina aia ke laba tana pede. ");
INSERT INTO gri_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kamu laka goto na keli peropero vaniana asei, ma kamu laka goto na labumatesiana na tinoni tsalapo, rongona inau sauba kau kedea asei aia e naua na omea seko vaga ia. ");
INSERT INTO gri_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kamu laka goto na adiqolona na sanga pede kesa tabana, rongona na sanga pede kesa tabana e naua me gini doko na matana tinoni, me gini tau morosigadovia na omea e goto me tukapusia na pede ke goto vania aia e tau tsukia na sasi. ");
INSERT INTO gri_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kamu laka na rotasiaqira lê na tinoni ni veratavosi ara tsinogomai i veramui; igamu segenimui goto amu donagininogoa na vatana na vavatsangi vaga ia kalina amu totu tsinogo tana Ejipt i sau. ");
INSERT INTO gri_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Mi laona ke ono na ngalitupa igamu kamu tsuka mutsa tana nimui uta ma kamu tsurivia na lakana. ");
INSERT INTO gri_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mi tana vitunina ngalitupa kamu moloa ke mango lê na kao, ma kamu laka goto na tsuriviana sa omea ke dato i laona. Molovanigira na tinoni ara tau tamanina sa omea kara gania na vangana ara dato tana nimui uta, ma na omea e kauvisu kamu molovanigira na omea tuavati atsi kara gania. Ma kamu nauvaganana goto ia tana nimui itai na uaeni ma nimui gai na olive. ");
INSERT INTO gri_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kamu aqo ke ono dani i laona kesa uiki, ma kamu laka na aqo tana vitunina dani, rongona kara gini mango igira nimui tseka, migira na tinoni ni veratavosi ara aqo vanigamu, migira goto nimui omea tuavati. ");
INSERT INTO gri_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Kamu rongomi vatavidoua pipi sui na omea inau na Taovia au vasini tsarivanigamu. Kamu laka na nonginongi vaniaqira na god tavosi; ma kamu laka goto na soana na asaqira. ");
INSERT INTO gri_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“I laona pipi na ngalitupa kamu lokisitugira tolu na dani tabu gana na mani padalokiginiaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tana vulana Abib, na vula vaga nogo igamu amu mololea i Ejipt, nimui aqo kamu lokisia na Dani Tabu na Bredi Tagara Isti Konina, nautaonia na omea inau au ketsaliginigamu nogo. Mi laona ke vitu na dani kamu gania moa na bredi e tagara isti i laona. Ma kamu laka goto tagara na adimaiana nimui sausau kalina kamu mai na samasama vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Kamu lokisigotoa na Dani Tabu na Pipitsu kalina igamu amu tuturiga moa na tsuriviana gamui mutsa. “Kamu lokisigotoa na Dani Tabu na Babale tana ka gaqira levuga na tagu na papara ma na tagu na bisi, i kalina igamu amu angunikolugira na vuana nimui itai na uaeni ma na vuana nimui gai mutsamutsa. ");
INSERT INTO gri_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Me pipi ngalitupa tana taguna tugira tolu na bongi tabu tugirani igamu sui pipi na mane nimui aqo kamu mai na samasama vaniaqu inau na Taovia nimui GOD. ");
INSERT INTO gri_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Kamu laka na savoriana na bredi e totu na isti konina kalina kamu savoria na gabuna na omea tuavati vaniau inau. Ma na seregana na omea tuavati amu savori vaniau tana dani tabu tugirani ke laka goto na totuvisu ma na tsauliana na matsaraka na dani ngana. ");
INSERT INTO gri_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Pipi ngalitupa kamu adimaia tana valena na Taovia nimui God na kesanina pipitsu na sila amu pitsugira. “Kamu laka na kukiana na dalena sipi se na naniqoti tana kô na tsutsuna tinana. ");
INSERT INTO gri_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Inau sauba kau moloa kesa na angelo ke idagana sautu vanigamu, me ke reitutugugamu kalina igamu kamu vavano, me ke adivanogamu tana vera inau au vangaraunogoa vanigamu. ");
INSERT INTO gri_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kamu gini boe nina goko aia ma kamu rongomangana. Kamu laka na sove taniana, rongona inau nogo au molo bâ vanigamu, maia sauba e utu ke padalea nimui petsakoe. ");
INSERT INTO gri_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Me ti vaga igamu kamu rongomangana aia ma kamu naua pipi sui na omea inau au ketsaliginigamu, minau sauba kau vailabu kolugira pipi sui gamui gala. ");
INSERT INTO gri_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ma niqu angelo sauba ke idagana sautu vanigamu, me ke adivanogamu tana niqira kao na Amor, ma na Het, ma na Peres, ma na Kanaan, ma na Hivi, ma na Jebus, minau sauba kau toroutsanigira sui na tinoni girani. ");
INSERT INTO gri_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Kamu laka goto na tsuporu tsuna tana samasama vaniaqira niqira god peropero, ma na nautaoniana niqira aqo na lotu. Kamu toroutsanigira na titinonina niqira god peropero, ma kamu vuipukaligira niqira tuguru tabu. ");
INSERT INTO gri_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ti vaga kamu samasama vaniau inau na Taovia nimui God, minau sauba kau vangalaka vanigamu ginia na mutsa ma na kô, ma kau maurisigamu tanigira sui gamui lobogu. ");
INSERT INTO gri_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mi laona nimui kao popono sauba ke tagara goto sa daki ke reobaka, se ke tagara sa dalena. Me sauba goto kau molovanigamu kamu mauri oka. ");
INSERT INTO gri_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Minau sauba kau naua migira na tinoni ara maiginigamu kara mataguniau inau; me ke gini ponopala na tobaqira ma kara viritsogo tanigamu. ");
INSERT INTO gri_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Inau sauba kau sarangasigira gamui gala; ma kau tsialigigira na Hivi, ma na Kanaan, ma na Het, kalina igamu amu maimai moa i sautu. ");
INSERT INTO gri_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Minau sauba e utu moa kau tsialigigira sui saikesa i laona kesa moa na ngalitupa; me ti vaga kau nauvaganana ia, ma na kao popono ke lia na kaomate; migira na omea tuavati atsi sauba kara danga sosongo vanigamu. ");
INSERT INTO gri_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Eo, inau sauba kau kiki rago moa kau tsialigigira, poi tsau ke tugugamu igamu kamu aditamanimui niqira kao. ");
INSERT INTO gri_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Inau sauba kau ratsua na vovotana nimui kao ke tû tana Mangalonga ni Aqaba, me ke votu bâ tsau tana Tasi Mediteranean, me ke tû tana kaomate me ke tsau bâ tana Kô Euprates. Inau sauba kau sauvanigamu na susuliga gana na tuliusiaqira na tamanina na kao ia, me sauba kamu tsialigigira kalina kamu maimai moa i sautu. ");
INSERT INTO gri_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Kamu laka na nauana sa vekesai koluaqira, se kolugira niqira god peropero. ");
INSERT INTO gri_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Kamu laka na tamivaniaqira na tinoni girani kara totu i laona na veramui; me ti vaga kamu tamivanigira, me sauba kara naua ma kamu sasi i mataqu inau. Me ti vaga kamu samasama vanigira niqira god peropero igira, me sauba ke lia vaga ti gamui taviti loki gana kamu sogo i laona.” ");
INSERT INTO gri_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Na Taovia e tsarivania a Moses, “Ko datomai tana vungavunga i koniqu inau, igoe mi tugira a Aaron, ma Nadab, ma Abihu ma kara vitu sangavulu goto na ida tana Israel; mi kalina kamu maimai ao moa, ma kamu tsuporu tsuna tana samasama. ");
INSERT INTO gri_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Migoe segeni moa a Moses ko mai varangisiau inau, migira sui na tavosina kara laka. Migira na toga sui kara laka goto na mai varangi tana vungavunga.” ");
INSERT INTO gri_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Maia Moses e vano me tsarivulagia vanigira na toga nina ketsa na Taovia me pipi sui goto nina vali, migira na toga sui ara gokodato kesa moa kalina mara tsaria, “Igami sui sauba kami muridougira pipi sui na ketsa na Taovia e vaturi vanigami.” ");
INSERT INTO gri_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ma Moses e maretsunagira pipi sui nina ketsa na Taovia. Mi tana matsaraka bongibongi na dani ngana, maia Moses e aqosia kesa na belatabu i tuana na vungavunga, me turuvaginigira sangavulu ruka na vatu, papadana ara sangavulu ruka na duli tana Israel. ");
INSERT INTO gri_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mi muri maia e mologira visana na mane vaolu kara vano na savori-kodokodo vaniana na Taovia, ma kara savorigotoa na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ma Moses e adia na turina na gabuqira na omea tuavati ara savorigira, me molotsavua i laoqira visana na popo; ma na turina e tsirikagini bâ tana belatabu. ");
INSERT INTO gri_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mi muri, ma Moses e adia na papi na taso i tana e maretsunâ nina ketsa ma nina vali na Taovia, me tsokovulagia i mataqira na toga sui. Migira ara tabea mara tsaria, “Igami sauba kami rongomangana na Taovia, ma kami muridougira pipi sui nina ketsa aia e vaturi vanigami.” ");
INSERT INTO gri_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mi muri, ma Moses e adia na gabu e totu tana popo me tsirikagini bâ i koniqira na toga me tsaria, “Iani nogo na gabu e manalia na taso aia na Taovia e naupatâ kolugamu kalina e vaturigira vanigamu na ketsa sui girani.” ");
INSERT INTO gri_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mi tugira a Moses, ma Aaron, ma Nadab, ma Abihu, migira na vitu sangavulu na ida tana Israel ara dato bâ tana vungavunga, ");
INSERT INTO gri_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","mara reilakana niqira God na Israel. Mi vavana na tuana aia e totu kesa na omea e rerei vaga na pakoka ara aqosiginia na vatu angaanga sapaia me bora vaga na masaoka. ");
INSERT INTO gri_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ma God e tau moa matesigira igira na ida tana Israel; ara reilakana God, mi muri mara mutsa mara inu sai. ");
INSERT INTO gri_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ma na Taovia e tsarivania a Moses, “Ko datomai tana vungavunga i koniqu inau, mi kalina igoe ko totu ieni minau sauba kau sauvanigo ke ruka na pavavatu i tana au maregira na ketsa sui na mani sasaniginiaqira na tinoni.” ");
INSERT INTO gri_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mi kaira a Moses ma Josua gana sasanga ara ka aligiri, maia Moses e tuturiga na dato bâ tana vungavunga tabu. ");
INSERT INTO gri_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ma Moses e tsarivanigira na ida, “Kamu pitukagami ieni poi kami ka visumai. Kaira a Aaron ma Hur ara ka totuvisu ieni kolugamu; me ti vaga kesa na vaiganigi ke labadato i laomui, me tangomana kamu ba ka koniqira kaira ma kara ka gotosia vanigamu.” ");
INSERT INTO gri_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mi kalina a Moses e dato bâ tana Vungavunga Sinai ma na parako e tsavu poponoa na vungavunga. ");
INSERT INTO gri_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ma na mararana angaanga na Taovia e tsunamai tana vungavunga. Migira na Israel ara reia na marara ia me vaga moa ti na lake e iruiru i kelana na vungavunga. Ma na parako ia e tsavu poponoa na vungavunga i laona e ono na dani, mi tana vitunina dani ma na Taovia e totu i laona na parako e soâ a Moses. ");
INSERT INTO gri_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ma Moses e dato bâ tana vungavunga me sage i laona na parako. Mi tana aia e totu vati sangavulu na dani me vati sangavulu na bongi. ");
INSERT INTO gri_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ko tsarivanigira na Israel kara adimai vaniau niqira sausau. Ma na omea gua moa kesa tinoni e padangaoa na sauana migoe nogo ko adituguqu inau. ");
INSERT INTO gri_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Migirani nogo na sausau nimu aqo ko adia i koniqira: na qolumila, ma na siliva, ma na tapalamila; ");
INSERT INTO gri_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ma na polo vovosi laka; ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi; ma na polo ara vosiginia na ivuna na naniqoti; ");
INSERT INTO gri_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na kokorana na sipi mane ara somua me tsitsi; na kokorana na naniqoti; na gaina na akasia; ");
INSERT INTO gri_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","na oela gana na bulu iruiru; na papasa sisigini dou gana na oela na nina omea, ma na bulunagai uruuru; ");
INSERT INTO gri_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na vatu angaanga tsitsi, migira goto visana na vatana na vatu angaanga tavosi loki matena, gana na moloana tana nina epod ma na todo tetelo tana aseasena na Mane Tabu Loki. ");
INSERT INTO gri_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Niqira aqo na tinoni kara vaturi vaniau kesa na valepolo tabu, rongona inau kau gini totu i levugaqira. ");
INSERT INTO gri_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kamu aqosia na valepolo ia me pipi sui na vangana taonia na omea inau sauba kau sauvanigo. ");
INSERT INTO gri_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ko aqosiginia na gai na akasia kesa na bokisi, ke tinaqe tsege na katsina, me ke tinaqe tolu na damana, me ke tinaqe tolu na datona. ");
INSERT INTO gri_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ko tsavu poponoginia na qolumila laka i laona mi taba, mo ko mologotoa na qolumila polia na liligina i gotu. ");
INSERT INTO gri_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Mo ko aqosiginigotoa na qolumila ke vati na ringi mo ko bulu bâ tugira vati tana tuana, ke ruka na ringi kesa tabana, me ke ruka kesa tabana. ");
INSERT INTO gri_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ko aqosiginia na gai na akasia ke ruka na gai na kalagai mo ko lesoviginikaira na qolumila, ");
INSERT INTO gri_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","mo ko tsukulaginikaira bâ tana ringi ara totu ruka tabana na bokisi. ");
INSERT INTO gri_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ma na gai na kalagai kaira kara ka totu kalavata tana ringi, ma kamu laka goto na loqoligiana. ");
INSERT INTO gri_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mi muri, migoe ko molosagea i laona na bokisi ia kaira ruka na pavavatu inau sauba kau tusuvanigo mi tana au maregira niqu ketsa. ");
INSERT INTO gri_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ma na vovongona ko aqosiginia na qolumila laka, ke tinaqe tsege na katsina me ke tinaqe tolu na damana. ");
INSERT INTO gri_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ma na qolumila ara tai tapetapea ko aqosiginikaira ke ruka na nununa na angelo, ");
INSERT INTO gri_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","mo ko molokaira kara ka totu ruka tabana na isuisuna na vovongona na bokisi ia. Mo ko aqosisaikaira kolunogoa na vovongona na bokisi ia. ");
INSERT INTO gri_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mi kaira na nununa na angelo kara ka vaiarovigi ma ka rapoqira kara tatakatsi ma kara tsavu poponoa na vovongona na bokisi. ");
INSERT INTO gri_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mo ko molosagekaira ruka na pavavatu i laona na bokisi mo ko molo bâ na vovongona i kelana. ");
INSERT INTO gri_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Minau sauba kau tsodogo igoe i tana, mi kelana na vovongona i ka levugaqira na nununa na angelo kaira, i tana nogo inau sauba kau tusuvanigo niqu ketsa sui vanigira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Ko aqosiginigotoa na gai na akasia ke kesa na bela, me ke tinaqe vati na katsina, me ke tinaqe ruka na damana me ke tinaqe tolu na datona. ");
INSERT INTO gri_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ko lesovi poponoginia na qolumila laka mo ko moloa na qolumila polia na liligina i gotu. ");
INSERT INTO gri_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ko aqosia na titibana ke labuvati na damana polipolia na bela mo ko moloa na qolumila polia na liligina na titibana. ");
INSERT INTO gri_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ko aqosivanigotoa ke vati na ringi qolumila, mo ko bulubagira vati tana tsutsukena i tana ara totu na tuana. ");
INSERT INTO gri_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mi tugira na ringi gana na tangoliginiaqira kaira na gai na mani kalagaiana na bela ko molotugira kara tu totu varangisia na titibana. ");
INSERT INTO gri_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ko aqosiginia na gai na akasia ke ruka na gai na kalagai, mo ko lesoviginikaira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ko aqosigotoa na peleti, na bilo, na popovatu, ma na popo laka gana na gini aqo tana savori uaeni. Igira sui lakalaka ko aqosiginigira na qolumila laka. ");
INSERT INTO gri_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ma na bela ia, ko moloa ke totu i matana na Bokisi na Taso, mi kelana nogo na bela ia ke totu sailagi na bredi tabu kamu savori vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Ko aqosiginigotoa na qolumila laka kesa na gai na mani molodato bilona bulu iruiru. Kaira na tuana ma na gai gotona ko aqosiginia na qolumila ara tai tapetapea. Ma na inilauna na nununa na tsitsi oqo ma na tsitsi tavuresi ko aqosisai kolunogoa na gaina. ");
INSERT INTO gri_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kara tu ono na arana kara tu varaga bâ tana gaigotona, tolu kesa tabana me tolu kesa tabana. ");
INSERT INTO gri_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Pipi tugira ono na arana kara tamanina tolu na nununa tsitsi i konina kara rerei vaga na latsena na gatsoga kolu oqona ma na tavuresina. ");
INSERT INTO gri_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ma na gaigotona ke totu goto ke vati na nununa tsitsi i konina, ma kara rerei vaga na latsena na gatsoga kolu oqona ma na tavuresina. ");
INSERT INTO gri_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nina aqo ke kesa na oqona ke totu i vavana i tana ara ka varagasai pipi ruka na arana. ");
INSERT INTO gri_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Igira na nununa na tsitsi oqo, ma na arana, kara aqosisaigira kolunogoa na gaigotona ginia na qolumila laka ara tai tapetapea. ");
INSERT INTO gri_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ko aqosigira ke vitu na bilo gana na mani molodatoana bâ tana arana, ma kamu mologira kara mararamai i nago. ");
INSERT INTO gri_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Igira na kapi ma na omea agana na kalagaiginiaqira na bilona bulu, ko aqosiginigira na qolumila laka. ");
INSERT INTO gri_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ke tolu sangavulu tsege na kilo na qolumila laka ko gini aqo tana na aqosiginiana na gai na mani molodato bilona bulu iruiru ma na vangana sui girani. ");
INSERT INTO gri_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ko parovata dou mo ko muritaonia na aqona na omea vaga inau au sauvulaginogoa vanigo tana vungavunga. ");
INSERT INTO gri_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ko aqosia na laona na Valepolo Tabu, aia na Valepolo i tana kau totu inau, ginia sangavulu na turina na polo vovosi laka ara vosiginia na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi. Mo ko tula mamaregasigira taonia na nunuqira na angelo. ");
INSERT INTO gri_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Me ke atsa moa na katsina ma na damana pipi turina, ke sangava ono na katsina me ke sangava kesa na damana. ");
INSERT INTO gri_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ko tulasaigira tsege turina, mo ko nauvaganana goto tugira tsege na turina tavosi. ");
INSERT INTO gri_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ma na polo bora ko aqosiginia na kakauna tana ka isuisuqira kaira na turina loki. ");
INSERT INTO gri_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ko mologira ke tsege sangavulu na kakauna tana liligina na kesanina turina loki, me ke tsege sangavulu na kakauna ke kale bâ tana liligina na turina loki tavosi. ");
INSERT INTO gri_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ko aqosigira kara tsege sangavulu na salili qolumila gana kara raqasaikaira ruka na turina loki ma kara ka gini lia kesa moa na polo popono. ");
INSERT INTO gri_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ko aqosiginia na ivuna na naniqoti ke sangavulu kesa na turina na polo gana na tsatsavuna na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ko aqosigira kara atsa moa na katsiqira ma na damaqira, ke sangava ono tabailima na katsiqira me ke sangava kesa na damaqira. ");
INSERT INTO gri_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ko tulasaigira tsege turina kara lia kesa moa turina loki, mo ko nauvaganana goto tugira ono na turina tavosi. Ko buniruka na ononina turina i matana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ko mologira kara tsege sangavulu na kakauna tana liligina na kesanina turina loki, me ke tsege sangavulu goto na kakauna tana liligina na rukanina turina loki. ");
INSERT INTO gri_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ko aqosigira kara tsege sangavulu na salili tapalamila, mo ko mologira bâ tana kakauna gana kara gini raqasaikaira na turina loki ma kara ka gini lia kesa moa na tsatsavu. ");
INSERT INTO gri_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ko moloa na turina e tsara ke tsavua na murina na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Na tsatsavuna na Valepolo ke tinaqe ruka buto kakau ke tsatsau gana ke gini tsavuginikaira ruka tabana na buriti. ");
INSERT INTO gri_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Ko aqosia ke ruka goto na tsatsavuna, kesa ko aqosiginia na kokorana na sipi mane mo ko somua ke tsitsi, me kesa ko aqosiginia na kokorana na naniqoti, aia gana ke pala i taba. ");
INSERT INTO gri_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ko adia na gai na akasia mo ko aqosi manogatigira na pava damadama agana na mani vaturikaeana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Me pipi na pava damadama ke sangava ruka na katsina, me ke tinaqe tolu na damana. ");
INSERT INTO gri_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Me pipi tana isuisuna na pava damadama ko kavisasana rongona kara gini tangomana na tugutasai. Pipi sui na pava damadama ko kavisasaqira manoga vaga ia. ");
INSERT INTO gri_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ko vangaraugira ke rukapatu na pava damadama gana tabana i ata, ");
INSERT INTO gri_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","me ke vati sangavulu na tototo siliva gana na tuaqira na pava damadama gira, ke ruka na tototo i tuana kesa na pava damadama, gana ke gado bâ tana nauna ara kavisasana. ");
INSERT INTO gri_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ko vangaraugira goto ke rukapatu na pava damadama gana tabana i vava na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","me ke vati sangavulu na tototo siliva, ruka tototo i tuana kesa na pava damadama. ");
INSERT INTO gri_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Gana i murina na Valepolo tabana i tasi ko vangarau manogatigira ke ono na pava damadama. ");
INSERT INTO gri_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","me ke ruka na pava damadama gana tana tsuruna. ");
INSERT INTO gri_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ma na pava damadama karani kara ka sai tû i lao me tsau bâ i gotu. Mi kaira na pava damadama gana ruka tana tsuruna ko nauvaganana nogo iani. ");
INSERT INTO gri_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Me vaga ia me kilia kara alu na pava damadama kolua ke sangavulu ono na tototo siliva, ruka tototo i tuana kesa na pava damadama. ");
INSERT INTO gri_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ko vangaraugotoa ke sangavulu tsege na qaroqaro ginia na gai na akasia, tsege na qaroqaro gana na pava damadama kesa tabana na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","me ke tsege gana kesa tabana, me ke tsege goto gana i murina tabana i tasi. ");
INSERT INTO gri_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ma na qaroqaro ke liu i levugaqira na pava damadama ke vano saviliu tû kesa tabana na Valepolo me ke tsau bâ tabana. ");
INSERT INTO gri_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ma pava damadama gira ko lesoviginigira na qolumila, mo ko molo bâ na ringi qolumila i koniqira gana kara tangoli ginigira na qaroqaro, ma na qaroqaro goto ko lesoviginigira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ko vaturikaea na Valepolo muritaonia na omea vaga inau au sauvulagi vanigo nogo tana vungavunga. ");
INSERT INTO gri_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Me ke kesa na polo katsi ko vosiginia na terete laka ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi. Mo ko tula mamaregasia taonia na nununa na angelo i konina. ");
INSERT INTO gri_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Maia ko tsauraginia bâ i tu koniqira vati na tuguru na gai na akasia ara lesoviginitugira na qolumila, mara molo salili i tu koniqira, mara turuvaginitugira i tu kelaqira vati na tototo siliva. ");
INSERT INTO gri_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Mo ko kauraginikaira na polokatsi ia tana salili me ke tsautsau, mi murina na polokatsi ia ko moloa na Bokisi na Taso ara ka totu ruka na pavavatu i laona. Ma na polokatsi ia ke votakaira na Nauna Tabu ma na Nauna Tabu Loki Sosongo. ");
INSERT INTO gri_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mi muri mo ko molo bâ na vovongona na Bokisi na Taso. ");
INSERT INTO gri_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Mi tabana i tano na Nauna Tabu Loki Sosongo ko moloa na bela na molo bredi gana na savori ke totu tabana i vava na Valepolo, ma na gai na molodato bilona bulu iruiru ke totu tabana i ata. ");
INSERT INTO gri_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Ma gana na matsapana na Valepolo ko vosia kesa na polokatsi ginia na terete laka ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, mo ko tula mamaregasia na inilauna. ");
INSERT INTO gri_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ma gana na mani tsauraginiana na polokatsi ia, ko vangaraua ke tsege na tuguru na gai na akasia mo ko lesoviginitugira na qolumila, mo ko tsukulagini bâ na salili i tu koniqira; mo ko aqosigotoa ke tsege na tototo tapalamila gana tana kara tukae. ");
INSERT INTO gri_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ko aqosiginia na gai na akasia ke kesa na belatabu. Me ke atsa saikesa na katsina ma na damana, ke sangava kesa tinaqe kesa na katsina me ke sangava kesa tinaqe kesa na damana, me ke tinaqe tsege labu tsege na datona. ");
INSERT INTO gri_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ko moloa ke vati na gai kara katsadato vati tana tsukena. Mo ko aqosisaitugira kolunogoa na belatabu, ma na belatabu popono ko lesoviginia na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ko aqosigira kara visana na tapala tapetape gana na mani karo tsavuana na tora i laona, mo ko aqosigira goto ke visana na savolo, na popo, na poka ma na bilo tapala na mani kodoana na bulunagai uruuru i laona. Ma na omea sui girani ko aqosiginigira na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ko aqosiginia na tapalamila kesa na didilana lake me ke viri ovaova, mo ko molo bâ ke vati na ringi tapalamila vati tana tsukena gana na kalagaiginiana. ");
INSERT INTO gri_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mo ko moloa na didilana lake iani ke tû i lao, me ke dato tsau bâ gana ngongo na levugana na belatabu. ");
INSERT INTO gri_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ko aqosiginigotoa na gai na akasia ke ruka na gai na kalagai, mo ko lesoviginikaira na tapalamila, ");
INSERT INTO gri_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","mo ko tsukulagini sagekaira tana ringi tabana mi tabana na belatabu kalina kamu tû na kalagaiana. ");
INSERT INTO gri_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ma na belatabu ko aqosiginia na pava damadama mi kelana ke ova tsapatugu, vaga nogo na omea inau au sauvulaginogoa vanigo tana vungavunga. ");
INSERT INTO gri_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ko barapoliginia na polokatsi vovosi laka na pakokana na Valepolo. Mi tabana i ata nina aqo ke sangava rukapatu ruka na katsina na polo, ");
INSERT INTO gri_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","me ke rukapatu na tuguru tapalamila me ke rukapatu goto na tototo tapalamila gana na tuaqira na tuguru, kolugira goto na salili ma na qala ara aqosiginia na siliva gana na mani tsauragini polo. ");
INSERT INTO gri_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ke kesa moa atsa na omea ko naua tabana i vava na bara ia. ");
INSERT INTO gri_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Mi tabana i tasi na polokatsi nina aqo ke sangava sangavulu kesa na katsina, kolugira sangavulu na tuguru me sangavulu na tototoqira. ");
INSERT INTO gri_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mi tabana i longa, tana e totu na matsapa, nina aqo goto na bara ke sangava sangavulu kesa na damana. ");
INSERT INTO gri_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Me ruka tabana na matsapa, nina aqo ke sangava tolu tinaqe tolu na polona katsi, kolutugira tolu na tuguru me tolu tu tototoqira. ");
INSERT INTO gri_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Mi tana matsapana na bara, nina aqo ke sangava vati tabailima na katsina na polokatsi ara vosiginia na terete laka ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, ma kara inilauginia na tula mamarega. Me ke vati na tuguruna me ke vati na tototoqira. ");
INSERT INTO gri_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Pipi sui na tuguru polipolia na bara niqira aqo kara tamanina na qala ma na salili ara aqosiginigira na siliva, kolu tototoqira tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Na bara popono ia nina aqo ke sangava rukapatu ruka na katsina, me ke sangava sangavulu kesa na damana, me ke sangava kesa tinaqe kesa na datona. Ma na polokatsi gira nimu aqo ko vosiginigira na terete laka, ma na tototoqira ko aqosiginigira na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Me pipi na vangana sui gana na gini aqo tana Valepolo, me pipi sui na gai gana na mani soriginiaqira na itaina na Valepolo, ma na gai gana na mani soribaaqira na itaina na polokatsi tana bara, igira sui nimu aqo ko aqosiginigira na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ko ketsaligira na tinoni ni Israel kara adimai vanigo na oela na olive dou liuliu bâ gana na bulu iruiru, rongona kara gini tungigira pipi tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Niqira aqo nogo tugira a Aaron migira na dalena kara turuvaginigira na gaina na bilona na bulu iruiru i laona na Valepolo i tabana i tano na polokatsi e tsautsau i matana na Bokisi na Taso. Mi tana kara reitutugugira kara iru sailagi i mataqu inau tû tana ngulavi me ke tsau bâ tana matsaraka. Ma na ketsa iani niqira aqo nogo igira na tinoni ni Israel ma na kukuaqira kara muri sailaginia. ");
INSERT INTO gri_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“I laoqira na toga popono na Israel, ko soamaia a Aaron na kulamu, mi tugira na dalena, tugira nogo a Nadab, ma Abihu, ma Eleasar, ma Itamar, rongona kara tu gini aqo vaniau inau vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ko vosi polo tabu vania a Aaron na kulamu, gana ke gini rerei ulagana ma kara gini padalokia. ");
INSERT INTO gri_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ko soasaigira pipi sui na tinoni ara dona dou na aqosi omea levolevo, igira inau nogo au sauvanigira na sasagana, mo ko tsarivanigira kara vosi polona a Aaron, gana ke sagelia tana dani ara tabua, rongona nina aqo aia ke aqo vaniau inau vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ko tsarivanigira kara aqosia kesa na todo tetelo gana na aseasena, kesa na epod, kesa na polo sagesage katsi, kesa na sote ara tula mamaregasia, kesa na kepi, me kesa na itai na soriana i levugana. Niqira aqo kara vosigira na polotabu girani vania a Aaron na kulamu mitugira goto na dalena, rongona kara tu gini aqo vaniau inau vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Migira na mane girani kara aqosigira na omea girani, kara gini aqo na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, ma na terete qolumila ma na terete laka. ");
INSERT INTO gri_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Niqira aqo kara vosiginigotoa na epod na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi ma na terete qolumila, ma na terete laka, ma kara inilauginia na tula mamarega. ");
INSERT INTO gri_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ma nina aqo na epod ke tamanina ke ruka na itai gana na sorisaiana tana kokovena na manetabu ruka tabana. ");
INSERT INTO gri_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Me ke kesa na itaina polo gana na sosori i levuga kara vosi lakâ ma kara tulasai kolunogoa na epod, ma kara aqosiginia kesa moa atsa na polo vovosi laka. ");
INSERT INTO gri_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ko adia ke ruka na vatu angaanga tsitsi loki matena, mo ko kiria i ka koniqira tu soaqira tugira na sangavulu ruka na dalena mane a Jakob ");
INSERT INTO gri_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","muritaonia tu niqira botsa, kara tu ono na soa konina kesa vatu, ma kara tu ono konina kesa. ");
INSERT INTO gri_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ko lavea ke kesa na tinoni e dona dou sosongo na gini aqo na vatu angaanga loki matena ke kiria tu soaqira tugira na dalena a Jakob tana vatu kaira, me ke molosagekaira i laona ruka na omea momolilo qolumila. ");
INSERT INTO gri_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mo ko molokaira tana itai na kokove ruka tabana tana epod, na papadana tugira sangavulu ruka na puku tana Israel. Mi tana nauvaganana ia, maia Aaron sauba ke kalagaia tana kokovena tu soaqira, rongona inau na Taovia kau gini pada sailaginigira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ko aqosia ke ruka na omea momolilo qolumila, ");
INSERT INTO gri_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","me ke ruka na tseni qolumila laka ko milivaganana na itai, mo ko sori bâ kaira tana omea momolilo qolumila. ");
INSERT INTO gri_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ko aqosia ke kesa na todo tetelo gana ke tsautsau tana aseasena na Mane Tabu Loki agana aia ke gini aqo na mani tsodovulagiana nina kili God. Ma na todo ia ko aqosiginigotoa ke kesa moa atsa na polo vovosi laka vaga o aqosiginia na epod, me ke atsa goto na tula mamarega i konina. ");
INSERT INTO gri_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Nina aqo ke atsa na katsina ma na damana mo ko bunirukâ. Ke tinaqe kesa na katsina me ke tinaqe kesa na damana. ");
INSERT INTO gri_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","20","Ko adigira ke sangavulu ruka na vatana tavosi babâ na vatu angaanga loki matena, mo ko molosagetugira tana omea momolilo qolumila. Mi muri, ko molotugira i konina na todo tetelo ia, ke vati na palatete, me ke tolu na vatu tavosi i kelana pipi na palatete. ");
INSERT INTO gri_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Mi konina pipi tu vidaqira na sangavulu ruka na vatu tugirani, nimu aqo ko kiria na soana kesa tu vidaqira na dalena mane a Jakob i konina, vaga na papadana tugira sangavulu ruka na puku tana Israel. ");
INSERT INTO gri_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ma gana na todo tetelo tana aseasena, ko aqosivania na tseni qolumila laka ara mili vaganana na itai. ");
INSERT INTO gri_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ko aqosia ke ruka na ringi qolumila mo ko sorikaira tana ruka tsutsukena i gotu na todo tetelo ia, ");
INSERT INTO gri_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","mo ko sorikakai bâ kaira ruka na tseni qolumila ka koniqira kaira ruka na ringi qolumila karani. ");
INSERT INTO gri_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ko soribâ kaira goto ruka na isuisuna na tseni kaira, ka koniqira kaira ruka na omea momolilo qolumila, me vaga ia ko sori bâ i nago tana itai na kokove na epod. ");
INSERT INTO gri_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Mi muri, mo ko aqosigotoa ke ruka na ringi qolumila mo ko soribakaira ruka tana isuisuna i lao na todo tetelo tabana i laona varangisia na epod. ");
INSERT INTO gri_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ko aqosia ke ruka goto na ringi qolumila, mo ko molokaira bâ i nago tana ruka na isuisuna na itaina kokove na epod, varangisia tana sasaina i kelana na itaina polo vovosi laka gana na sosori i levuga. ");
INSERT INTO gri_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ma na na itai bora ko soriginia na ringina na todo tetelo tana ringina na epod, rongona na todo tetelo ia ke gini totu kakai dou i kelana na itai na sosori i levuga me ke gini tau tatatsora lê. ");
INSERT INTO gri_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Me pipi kalina ti vaga a Aaron ke sage bâ tana Nauna Tabu ma nina aqo ke moloa tana aseasena na todo tetelo iani i tana ara kiria tu soaqira na sangavulu ruka puku tana Israel, rongona inau na Taovia kau gini padasailaginigira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ko molosagea na Urim ma na Tumim i laona na todo tetelo ia, rongona kara ka gini totu varangisia na kosuna a Aaron pipi kalina aia ke mai i mataqu inau. Mi tana tagu vaga ia, ma nina aqo ke molo sailaginia na todo tetelo ia tana aseasena, rongona ke gini tangomana na tsodovulagiana niqu kili inau vanigira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Na polo sagesage katsi e pala i vavana na epod ko vosigini saikesalia moa na terete bora ara aqosiginia na ivuna sipi. ");
INSERT INTO gri_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nina aqo ke tamanina na ovaova gana na lova, mi tana liligina na ovaova ia ko tula matolusidoua gana ke gini tau taratsi tsaku. ");
INSERT INTO gri_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Ko aqosiginia na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, visana na nununa na vuanagai momolilo, mo ko tula polipoligira tana tuana na polokatsi ia, ma kara tsautsau na belo qolumila i levugaqira. ");
INSERT INTO gri_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Nina aqo a Aaron ke sagelia na polo sagesage katsi iani kalina ke naua nina aqo manetabu. Me pipi kalina aia ke sagemai i mataqu inau tana Nauna Tabu, mi kalina goto aia ke rutsu, me sauba kara tatangi na belo girani, me ke gini tau mate. ");
INSERT INTO gri_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ko aqosiginia na qolumila laka kesa na inilau mo ko kiria i konina na goko iani, ‘BALOVANINOGOA NA TAOVIA.’ ");
INSERT INTO gri_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Mo ko soriginia na itai bora i nagona nina kepi. ");
INSERT INTO gri_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ma nina aqo a Aaron ke moloa i lovana rongona inau na Taovia kau gini tabea pipi sui na sausau igira na Israel kara sauvaniau, atsa moa ti igira na tinoni kara nau sasilia sa omea kalina ara saugira. ");
INSERT INTO gri_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Ko vosiginigotoa na terete laka gana sote ma gana kepi a Aaron, mo ko vosigotoa kesa na itaina polo gana na sosori i levuga, mo ko inilauginia na tula mamarega. ");
INSERT INTO gri_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Ko vosivanitugira goto na dalena mane a Aaron na sote, na itaina polo gana na sosori i levuga ma na kepi, gana ke gini rerei tu ulagaqira ma kara gini padalokitugira. ");
INSERT INTO gri_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ko sagelivania a Aaron mi tugira na dalena na polo girani. Mi muri ti ko ninaginitugira na oela na olive, mo ko tabutugira rongona kara tu gini totu kalavata tana aqo vaniau inau vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Mo ko vosivanitugira goto na polo ni laona kara tu sagelia i vavana na polo katsi ke tû tana bunguqira me ke tsau bâ tana kakabaqira rongona kara tu gini tau sauvulagi segeniqira. ");
INSERT INTO gri_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ma nina aqo a Aaron mi tugira na dalena kara tu sageli sailaginigira na polo ni laona girani pipi kalina kara tu sagemai i mataqu inau tana Valepolo, se kara tu mai varangisia na belatabu na nauana tu niqira aqo manetabu tana Nauna Tabu, rongona kara tu gini tau sauvulagi segeniqira ma kara tu mate. Na ketsa iani e totu kalavata vania a Aaron migira sui na kukuana. ");
INSERT INTO gri_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Iani na omea nimu aqo ko nauvania a Aaron mi tugira na dalena mane, gana ko tabutugira ma kara tu lia na manetabu tana aqo vaniaqu inau. Ko adia ke kesa na buluka mane vaolu me ke ruka na sipi mane, me ke tau goto seko sa tabana tu koniqira. ");
INSERT INTO gri_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mo ko adigotoa na uiti dou bâ, mo ko laka na moloana na isti i laona, mo ko aqosia ke visana na bredi kolua na oela na olive, me ke visana ke tagara na uela i koniqira, me ke visana kara vaga na biskete ara saluvaginigira na uela. ");
INSERT INTO gri_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ko molosagegira i laona kesa na kei mo ko savorigira vaniau inau kalina ko gini savori-kodokodo na buluka mane mi kaira na sipi mane. ");
INSERT INTO gri_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Ko adimaia a Aaron mitugira na dalena i matana na Valepolo i tana au totu inau, mo ko tsarivanitugira kara tu lesomale dou. ");
INSERT INTO gri_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Mi muri, mo ko sagelivania a Aaron na polona manetabu: na sote, na polo sagesage katsi i vavana na epod, na epod, ma na todo tetelo tana aseasena, ma na itaina na soripolo. ");
INSERT INTO gri_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ko molo bâ na kepi i lovana, mo ko sori bâ na kikiri tabu tana e totu na goko vaga iani, ‘BALOVANINOGOA NA TAOVIA.’ ");
INSERT INTO gri_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Mi muri mo ko adia na oela tabu, mo ko qetu bâ i lovana, mo ko ninaginia. ");
INSERT INTO gri_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Ko adimaitugira goto na dalena mane mo ko sagelivanitugira na polo sagesage; ");
INSERT INTO gri_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ko molo bâ na itai na soripolo polia tu bunguqira ma na kepi i tu lovaqira. Nimu aqo nogo igoe ko nauvaganana iani kalina ko tabua a Aaron mitugira na dalena. Tugira, migira goto na kukuaqira, niqira aqo kara aqo manetabu sailagi vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ko adimaia na buluka mane i matana na Valepolo i tana au totu inau, mo ko tsarivania a Aaron mitugira na dalena kara tu moloa tu limaqira tana lovana. ");
INSERT INTO gri_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mo ko matesia na buluka mane ia i mataqu inau i matsapana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ko adia na turina na gabuna mo ko lumia na kakaumu i laona, mo ko molo bâ tana gai ara katsadato tana tsukena na belatabu. Mo ko adia na turina na gabu e totuvisu mo ko qetu bâ tana tuana na belatabu. ");
INSERT INTO gri_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Mi muri mai, mo ko adia na seregana sui ara tsavua na vangalevona, ma na turina dou bâ na atena, mi kaira ruka na piuna ni laona kolua na seregana i konina, mo ko kodogira sui tana belatabu vaga na sausau vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mo ko adia na velesina kolu kokorana ma na tinaena, mo ko ba kodogira tabana i tano tania na vera. Iani na sausau gana na adiligiana niqira sasi na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ko adia kesa ka vidaqira na sipi mane mo ko tsarivania a Aaron mitugira na dalena kara tu moloa tu limaqira tana lovana. ");
INSERT INTO gri_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mi muri mo ko labumatesia na sipi ia, mo ko adia na gabuna mo ko tsoni bâ tana vati liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ko pari kotsokotsoa, mo ko malesia na vangalevona ma na aranimuri, mo ko mologira i kelana na lovana migira na paparina tavosi. ");
INSERT INTO gri_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ko kodoa na sipi popono i kelana na belatabu vaga na savori-kodokodo. Na vuruna na vatana na sausau vaga ia au sigini ngaoa inau. ");
INSERT INTO gri_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Mo ko adigotoa na rukanina sipi mane mo ko tsarivania a Aaron mitugira na dalena kara tu mologotoa tu limaqira tana lovana. ");
INSERT INTO gri_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mi muri mo ko labumatesigotoa, mo ko adia na turina na gabuna, mo ko molo bâ tana rarauna kulina madoa a Aaron mitugira na dalena, mi tana kakauqira loki tu limaqira madoa mi tana kakauqira loki tu tuaqira madoa. Mo ko tsoni bâ na turina na gabu tana vati liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ko adia na turina na gabu e totu tana belatabu ma na oela tabu, mo ko tsirikagini bâ konina a Aaron ma na polona, mi tu koniqira goto tugira na dalena ma tu poloqira. Mi tana nauvaganana ia, ti ko gini balovaniau a Aaron, mitugira na dalena, kolua tu poloqira. ");
INSERT INTO gri_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ko pariligia na seregana na sipi mane, ma na kalina serega, ma na seregana e tsavua na vangalevona, ma na turina dou bâ na atena, mi kaira ruka na piuna ni laona kolua na seregana, ma na arana madoa ni muri. ");
INSERT INTO gri_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Mi laona na kei na bredi e tagara isti i konina aia o saunogoa vaniau inau, ko adia: ke kesa na sivona tana bredi ara aqosiginia na oela na olive, me ke kesa ara tau aqosiginia na oela, me ke kesa na biskete. ");
INSERT INTO gri_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mo ko mologira sui i limana a Aaron mitugira na dalena na mutsa girani mo ko tsarivanitugira kara tu saugira vaniau inau vaga kesa na sausau laka. ");
INSERT INTO gri_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mi muri, migoe ko adiligia na mutsa girani tanitugira, mo ko bâ kodogira tana belatabu i kelana na savori-kodokodo vaga na sausau na mutsa vaniau. Ma na vuruna na sausau vaga ia au sigini ngaoa inau. ");
INSERT INTO gri_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Ko adia na arona na sipi mane ia, mo ko sauvaniau inau vaga kesa na sausau laka. Ma na turina iani gamu tuva nogo igoe. ");
INSERT INTO gri_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Me pipi kalina ti vaga kara tû na tabuana kesa na manetabu, ma na arona ma na aranimuri na sipi mane ara gini aqo tana tabuana na manetabu ia, kara sauvaniau inau vaga na sausau laka mi muri ma kamu mololigivanigira na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Iani nogo na omea au pedea ke totu kalavata: laka kalina igira niqu tinoni kara savoria niqira sausau tangomana na tinoni kara ganipatâ na turina, ma na arona kolua na aranimuri na omea tuavati ara savoria ke lia gaqira tuva na manetabu. Iani nogo niqira vangalaka na tinoni vaniau inau na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Mi kalina ke mate a Aaron, ma nina polo na manetabu kara tangolidatogira igira na kukuana i muri, gana kara sageligira kalina kara tabugira. ");
INSERT INTO gri_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ma na dalena a Aaron aia e tugua tamana tana aqo manetabu, aia nina aqo ke sageligira na polo girani i laona ke vitu na dani, kalina aia ke vano tana Valepolo i tana au totu inau gana ke naua nina aqo tana Nauna Tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ko adia na velesina na sipi mane o gini aqo tana tabuana a Aaron mitugira na dalena, mo ko kukia kesa tana nauna tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Mi tana matsapana na Valepolo i tana au totu inau, a Aaron mitugira na dalena kara tu ganikolua na bredi ara tsaravisu i laona na kei. ");
INSERT INTO gri_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kara tu gania na vangana na omea o gini aqo tana sausau gana na veoligiana tu niqira sasi tana tagu o tabutugira. Migira moa na manetabu tangomana kara gania na mutsa iani rongona na mutsa ia e lia nogo na omea tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Me ti vaga kara visana na velesi na sipi se visana na bredi ara tau ganisuigira ma kara totu tsau bâ tana matsaraka, ma nimui aqo kamu kodogira; kamu laka na ganiaqira rongona ara lia nogo na mutsa tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ko naua na vovorona na tabuana a Aaron migira na dalena i laona ke vitu laka na dani, vaga saikesa nogo au ketsaliginigo inau. ");
INSERT INTO gri_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Me pipi dani nimu aqo ko gini savori-kodoputsa kesa na buluka mane ngiti sesemateqira na sasi. Mi tana nauvaganana ia ti o pungua na belatabu. Mi muri mo ko ninaginia na belatabu na oela na olive gana ke gini tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ko naua na omea iani pipi dani i laona ke vitu na dani. Mi tana ti na belatabu ke tabu saikesa, ma na omea gua moa ti vaga ke pelea na belatabu ia, maia sauba ke lia goto na omea tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Me pipi dani tana tagu popono ke mai, nimui aqo kamu gini savori-kodoputsa tana belatabu ke ruka na dalena sipi ke kesa moa ka ngalitupaqira. ");
INSERT INTO gri_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kamu gini savori-kodokodo kesa ka vidaqira tana matsaraka, ma na rukanina tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kamu savorikolua na kesanina dalena sipi ke kesa kilo na pulaoa dou bâ ke lalo kolua kesa lita na oela na olive laka. Ma kamu qetu ba gotoa ke kesa lita na uaeni gana na inu. ");
INSERT INTO gri_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kamu savoria na rukanina dalena sipi tana ngulavi, ma kamu savorikolua ke kesa moa atsa na dangana na pulaoa, ma na oela na olive, ma na uaeni, vaga nogo tana matsaraka. Girani na sausau na mutsa vaniau na Taovia, ma na vuruna ia au sigini ngaoa inau. ");
INSERT INTO gri_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mi tana tagu sui ke mai, ma nimui aqo kamu savoria na savori-kodokodo vaga girani tana matsapana na Valepolo i tana au totu inau. Mi tana nogo inau sauba kau mai tsodogo igoe ma kau goko kolugo. ");
INSERT INTO gri_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mi tana goto nogo sauba kau mai tsodogira na tinoni ni Israel, ma na marara angaanga i tana au totu inau sauba ke naua na nauna ia me ke tabu. ");
INSERT INTO gri_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Inau sauba kau tabua na Valepolo ma na belatabu, ma kau balogotoa a Aaron mitugira na dalena gana kara tu aqo manetabu vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Inau sauba kau totu i laoqira na tinoni ni Israel, ma kau lia niqira God. ");
INSERT INTO gri_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Migira sauba kara donaginia laka inau na Taovia niqira God au adirutsumigira tania na Ejipt rongona kau gini mauri i laoqira. Inau nogo na Taovia niqira God. ");
INSERT INTO gri_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ko aqosiginia na gai na akasia ke kesa na belatabu gana na kodo bulunagai uruuru. ");
INSERT INTO gri_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Nina aqo ke atsa na katsina ma na damana, ke tinaqe ruka labu kesa na katsina, me ke tinaqe ruka labu kesa na damana, me ke tinaqe vati labu ruka na datona. Ma na gai ara katsadato tana vati tsutsukena kara aqosisai kolunogoa na belatabu ia. ");
INSERT INTO gri_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ko lesoviginia na qolumila laka na kelana, mi tugira sui vati na tabana, migira na gai ara katsadato tana tsukena, mo ko mologotoa na qolumila polipolia na liligina. ");
INSERT INTO gri_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Mi vavana na liligina tabana mi tabana ko bulu bâ ke ruka na ringi qolumila gana na tsukulaginiana na gai na kalagai. ");
INSERT INTO gri_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ko aqosiginia na gai na akasia kaira na gai na kalagai mo ko lesoviginikaira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ko moloa na belatabu ia i nagona na polokatsi e tsautsau i matana na Bokisi na Taso. Mi tana na nauna nogo ia inau sauba kau ba tsodogo. ");
INSERT INTO gri_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Pipi matsaraka kalina a Aaron ke mai na aragoaqira na bulu iruiru, ma nina aqo ke kodoa na bulunagai uruuru i kelana na belatabu ia. ");
INSERT INTO gri_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Me ke nauvaganana goto ia kalina ke tungigira na bulu iruiru tana ngulavi, rongona ke gini dato sailagi na punguna na bulunagai uruuru ia i mataqu inau tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Mi kelana na belatabu iani ko laka na savoriana sa bulunagai e tau ulagana, mo ko laka goto na savoriana sa omea tuavati, se sa sausau na uiti, ma na qetu baana sa savori na uaeni i konina. ");
INSERT INTO gri_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Me ke kesa moa kalina i laona pipi ngalitupa a Aaron ke aqosia na vovorona gana na punguana na belatabu, tana moloana tana vati kakatsana na belatabu na gabuna na omea tuavati ara savoria gana na sese mateqira na sasi. Ma na omea vaga iani nimui aqo kamu naua pipi ngalitupa tana tagu sui ke mai. Na belatabu iani nina aqo ke tabu saikesa, ma kamu baloa vaniau inau na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Kalina igoe ko naua na aqo na tsokoaqira na tinoni ni Israel, ma nina aqo pipi sui na mane ke soli vaniau inau na matena na maurina, rongona ke gini tau gadovia sa omea seko kalina igoe ko aqosia na tsoko tinoni. ");
INSERT INTO gri_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Pipi tinoni ara marea na soaqira tana tsoko tinoni ia nina aqo ke saua na dangana na qolo vaga ara pedea, taonia na tovomamava ara gini aqo tana tagu ia. Niqira aqo pipi tinoni kara tsonia na qolo iani vaga na sausau vaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Pipi sui lakalaka na tinoni ara tsokogira tana tsoko tinoni iani, igira sui na mane ara tsaulinogoa rukapatu na ngalitupaqira se liusia, niqira aqo kara tsonivaniau inau na qolo iani. ");
INSERT INTO gri_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Mi kalina na tinoni kara tû na tsoniana na qolo iani na matena na mauriqira, migira ara tamani danga kara tau tsonia ke danga bâ, migira ara tau tamani kara tau tsonia ke tetelo lê. ");
INSERT INTO gri_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ko adia na qolo iani i koniqira na tinoni ni Israel, gana na aragoana na Valepolo Tabu. Ma na takesi iani agana nogo na suilovaqira, me sauba inau kau gini padâ na reitutuguaqira.” ");
INSERT INTO gri_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ko aqosia kesa na popo tapalamila kolua na tototona tapalamila. Ko moloa i ka levugaqira na Valepolo ma na belatabu, mo ko moloa na kô i laona. ");
INSERT INTO gri_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ma Aaron mitugira na dalena tu niqira aqo kara tu vulia tu limaqira ma tu tuaqira tana kô ia, ");
INSERT INTO gri_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","idavia kara tu sage bâ i laona na Valepolo se kara tu bâ tana belatabu na savori-kodoputsa. Mi tana nauvaganana ia ti kara tu gini tau mate. ");
INSERT INTO gri_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Tu niqira aqo nomoa kara tu vulimalea tu limaqira ma tu tuaqira, rongona kara tu gini tau mate. Iani nogo e kesa na vovorona kara tu nautaoni sailaginia tugira migira goto na kukuaqira.” ");
INSERT INTO gri_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ko adigira na papasa sisigini dou bâ girani: ke ono kilo na busina na gai vavai, ke tolu kilo na gotso sisigini dou, me ke tolu kilo na tovu sisigini dou, ");
INSERT INTO gri_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","me ke ono kilo na kokorana na kasia, ma na mamavaqira na omea sui girani ke taonia na tovomamava ara gini aqo tana tagu ia. Mo ko lalo kolugotoa ke vati lita na oela na olive, ");
INSERT INTO gri_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","mo ko aqosiginia na oela tabu gana na nina omea ko lalo vaganana nogo ara naua igira niqira aqo na aqosi kô sisigini dou. ");
INSERT INTO gri_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ko gini aqo nogo na oela tabu ia na ninaginiana na Valepolo i tana au totu inau, ma na Bokisi na Taso, ");
INSERT INTO gri_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ma na bela na molo bredi me pipi sui na vangana, ma na gai na molokae bilona bulu iruiru me pipi sui na vangana, ma na belatabu gana na kodo bulunagai uruuru, ");
INSERT INTO gri_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ma na belatabu gana na savori-kodoputsa kolugira pipi sui na vangana, ma na popo na vulivuli kolua na tototona. ");
INSERT INTO gri_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ko balogira na omea sui girani tana nauvaganana ia, me sauba igira sui kara tabu manana, ma na omea gua moa ti ke pelegira na omea girani, maia sauba ke lia goto na omea tabu. ");
INSERT INTO gri_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Mi muri migoe ko ninaginia a Aaron mitugira na dalena, mo ko tabutugira vaga na manetabu tana aqo vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ko tsarivanigira na tinoni ni Israel, ‘Iani na oela tabu gana na nina omea kara gini aqo moa tana aqo vaniaqu inau tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Nimui aqo kamu tau qetua i konina sa tinoni lê moa, ma kamu laka goto na aqosi taoniana sa nimui oela segeni vaga iani. Rongona na oela iani na oela tabu ma nimui aqo kamu kukuni tania vaga na omea e tabu. ");
INSERT INTO gri_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Masei moa ke nautaonia sa oela vaga ia, se ke gini aqo na ninaginiana kesa e tau na manetabu, maia sauba kau tsidavaginia tanigira niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Na Taovia e tsarivania a Moses, “Ko adia ke kesa moa atsa na dangana vati tavosi na papasa sisigini dou. ");
INSERT INTO gri_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mo ko gini aqo girani gana na aqosiginiana na bulunagai uruuru, vaga ara naua igira ara aqosi kô sisigini dou. Mo ko molo bâ na solo i konina gana ke gini totu male me ke tabu. ");
INSERT INTO gri_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ko rutua na turina me ke lia na papasa maripu dou, mo ko adi bâ i laona na Valepolo Tabu, mo ko moloa i matana na Bokisi na Taso. Ma na bulunagai uruuru iani ko nauvani vaganana na omea tabu manana. ");
INSERT INTO gri_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ke laka goto ke kesa na aqosi taoniana sa nina bulunagai uruuru segeni ke atsa kolua iani. Ko nauvani vaganana saikesa moa na omea tabu ara balovaniau inau. ");
INSERT INTO gri_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Me ti vaga ke kesa ke aqositaonia sa omea vaga ia gana ke gini lia nina kô sisigini, minau sauba kau tsidavaginia tanigira niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Inau au vilinogoa a Besalel, na dalena a Uri ma na kukuana a Hur, tana puku konina a Juda, ");
INSERT INTO gri_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","mau dangaliginia na susuligaqu. Mau sauvania na sasaga loki ma na na padagado, ma na donadou tana aqosiana pipi sui vatana na omea mamarega, ");
INSERT INTO gri_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ma na botsangiana pipi vata na mamare mamarega ma na aqosiginiaqira na qolumila, ma na siliva ma na tapalamila; ");
INSERT INTO gri_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ma na lasiaqira na vatu angaanga gana na baruaqira na omea levolevo; ma na katsu gai; me pipi sui goto na vatana na aqosi omea mamarega tavosi. ");
INSERT INTO gri_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mau viligotoa a Oholiab na dalena a Ahisamak, tana puku konina a Dan, ke aqo kolua. Minau au sauvanigira sui goto igira na tinoni sasaga tana aqosi omea levolevo na sasaga loki rongona kara gini tangomana na aqosiaqira pipi sui na omea inau au ketsaliginigamu kamu naua: ");
INSERT INTO gri_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","igira nogo na Valepolo Tabu, ma na Bokisi na Taso ma na vovongona, me pipi sui na vangana na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ma na bela na molo bredi me pipi sui na vangana, na gai na molodato bilona bulu iruiru qolumila laka me pipi sui na vangana, ma na belatabu gana na kodoana na buluna gai uruuru, ");
INSERT INTO gri_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ma na belatabu gana na savori-kodoputsa me pipi sui na vangana, na popo na vulivuli ma na tototona, ");
INSERT INTO gri_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","na polo manetabu rereidou sosongo vania a Aaron mitugira na dalena gana kara tu sagelia kalina kara tu naua tu niqira aqo manetabu, ");
INSERT INTO gri_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","na oela tabu ma na bulunagai uruuru dou sosongo gana na Nauna Tabu. Mi tana aqosiaqira na omea sui girani, niqira aqo kara nautaoni saikesalia vaga nogo au ketsaliginigo inau.” ");
INSERT INTO gri_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Na Taovia e ketsalia a Moses, ");
INSERT INTO gri_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ko tsarivanigira na tinoni ni Israel na goko iani, ‘Kamu padalokia na Sabat aia niqu dani na mango inau, rongona aia nogo na papadana na vaitasogi i levugada igita tana tagu popono ke mai, ma kamu donaginia laka inau na Taovia au naua migamu amu gini lia niqu tinoni segeni. ");
INSERT INTO gri_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Nimui aqo kamu padalokia na dani na mango, rongona na dani ia na dani tabu. Masei moa ke tau padalokia me ke aqo tana dani ia, ma nimui aqo kamu labumatesia. ");
INSERT INTO gri_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Igamu amu tamanina ono na dani i tana kamu naua nimui aqo, ma na vitunina dani aia na dani na mango kamu balovaniau inau. Masei moa ke naua sa aqo tana dani ia nimui aqo kamu labumatesia. ");
INSERT INTO gri_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Igira na tinoni ni Israel niqira aqo kara padalokia na dani iani vaga na papadana niqu vaitasogi kolugira. ");
INSERT INTO gri_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Sauba ke lia sailagi na papadana i levugaqira na tinoni ni Israel minau, rongona inau na Taovia au aqosia na baragata ma na barangengo i laona e ono na dani, mi tana vitunina dani inau au mango rago.” ");
INSERT INTO gri_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mi kalina God e goko sui vania a Moses tana Vungavunga Sinai, maia e sauvania ruka na pavavatu i tana aia segenina nogo e maretsunagira na ketsa. ");
INSERT INTO gri_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mi kalina igira na toga ara reia laka a Moses e tau vati tsunamai tania na vungavunga, me tototu oka sosongo i gotu, migira ara saimai polia a Aaron mara tsarivania, “Igami ami tau dona nagua e laba vania a Moses aia na mane e adirutsumigami tania i Ejipt. Me vaga ia me dou ti igoe ko aqosivanigami sa god gana ke idagana sautu vanigami.” ");
INSERT INTO gri_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ma Aaron e tsarivanigira, “Kamu adiligigira sui na tsaukuli qolumila tana kuliqira na taumui ma na dalemui ma kamu adigira mai vaniau inau.” ");
INSERT INTO gri_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mi tana, migira sui na tinoni ara adiligigira gaqira tsaukuli qolumila, mara adigira mai vania a Aaron. ");
INSERT INTO gri_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Maia e adigira na tsaukuli girani, me mologira tana lake mara rono, me qetu bâ tana omea ara aqositaonia na nununa na buluka mane ara vangarau manogatinogoa, me gini laba kesa na nununa na buluka mane qolumila. Migira na toga ara tsaria, “!Israel, iani nogo nida god igita, aia e adirutsumigita tania i Ejipt!” ");
INSERT INTO gri_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Mi kalina a Aaron e reivaganana ia, maia e tû me logoa kesa na belatabu i matana na buluka mane qolumila ia, me tsaria, “Ke dani nogo sauba ke laba na dani tabu gana na padalokiana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mi tana matsaraka bongibongi na dani ngana igira ara adimaigira visana na omea tuavati gana na savori-kodokodo, me visana gana na sausau tangomana na tinoni kara ganipatâ na turina. Migira na toga ara totupuka i lao tana mutsa, mara totu matengana na inu bule ma na sinagi bubulega. ");
INSERT INTO gri_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Na Taovia e tsarivania a Moses, “Ko tsaku mo ko visutsuna i lao, rongona igira nimu toga, igira igoe o adirutsumigira tania i Ejipt, ara sasi mara piloligi taniau inau. ");
INSERT INTO gri_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ara mololenogoa na sautu inau au ketsaligira kara muria; mara tû mara aqosi segeniqira kesa na dalena buluka mane qolumila, mara samasama i matana mara kodoputsa vania. Mara tsaria laka aia nogoria niqira god e adirutsumigira tania i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Au donagininogoa laka ara tsatsarae sosongo na tinoni girani. ");
INSERT INTO gri_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Mi kalina ia migoe ko laka na tovoana na utusiaqu. E dato sosongo na kore i tobaqu vanigira, mau padâ nomoa kau labumatesigira. Mi muri bâ ti inau sauba kau naua migoe migira na kukuamu kamu lia kesa na puku loki.” ");
INSERT INTO gri_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mi tana, ma Moses e ngangai savosavo bâ konina na Taovia nina God me tsaria, “?Lao kiki Taovia, egua te o kore loki sosongo vaga sagata ia vanigira nimu tinoni, igoe nogo o laumaurisigira tania na Ejipt ginia na susuligamu loki? ");
INSERT INTO gri_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","?Rongona gua ti igira na Ejipt kara tangomana na tsariana laka kalina igoe o adirutsumigira nogo nimu toga tania i Ejipt, mo padâ moa na matesiaqira tana vungavunga, ma kara nangaligi saikesa? Ko laka na kore sosongo vaga ia; ko olia nimu papada mo ko laka na molomaiana na omea seko loki iani vanigira nimu tinoni. ");
INSERT INTO gri_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ko padavisutugira nimu maneaqo a Abraham, ma Isaak, ma Jakob. Mo ko padatugua nimu veke o nauvanitugira laka ko tusuvanitugira ke danga tu kukuaqira, ma kara danga vaga na veitugu i gotu tana masaoka, me laka sauba ko tusuvanigira tu kukuaqira kara tamanina na kao igoe o vekenogoa vanigira kara tamanina sailagi.” ");
INSERT INTO gri_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mi tana, maia na Taovia e olitugua nina papada, me tau tugua naua na omea seko aia e padâ laka ke nauvanigira nina tinoni. ");
INSERT INTO gri_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ma Moses e tsunatugua tania na vungavunga, me tabelekaira na pavavatu tana e totu na mamarena na ketsa ruka sui tabana. ");
INSERT INTO gri_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God segenina nogo e aqosikaira na pavavatu kaira, me kirigira nina ketsa ka koniqira. ");
INSERT INTO gri_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ma Josua e rongomigira na tinoni ara gugû me tsarivania a Moses, “Inau au rongomia na leleo vaga moa ti ara vailabu i vera.” ");
INSERT INTO gri_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ma Moses e tsaria, “Aia e tau rorongo vaga na gû na tangomana tana vailabu, se ke vaga na ngangai kalina ara tau tangomana; aia e rorongo vaga moa na linge.” ");
INSERT INTO gri_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mi kalina a Moses e mai varangisia na vera maia e reia na nununa na buluka mane ara aqosia, migira na tinoni ara gagavai, me gini momosa loki na tobana. Mi tana, i tuana nogo na vungavunga, aia e tsonitsunakaira na pavavatu aia e tabelekaira mara ka takotso sui. ");
INSERT INTO gri_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Maia e adia na nununa na buluka mane ia me tsonisagea i laona na lake, me tairutua me lia na papasa me laloginia na kô, mi muri maia e turuginigira na toga ni Israel kara inuvia. ");
INSERT INTO gri_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Maia e tsarivania a Aaron, “?Nagua sagata ara nauavanigo igoe na tinoni girani, te o tamivanigira mara gini naua na sasi loki vaga sagata ia?” ");
INSERT INTO gri_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ma Aaron e tuguvisua me tsaria, “Ko laka na kore vaniaqu inau. Igoe o dona nogo laka na tinoni girani ara padakuti matena moa na nausasi. ");
INSERT INTO gri_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Igira ara tsarivaniau inau, ‘Igami ami tau dona nagua e laba vania a Moses, aia na mane e adirutsumigami tania i Ejipt; me vaga ia me dou ti igoe ko aqosivanigami sa god gana ke idagana sautu vanigami.’ ");
INSERT INTO gri_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Minau au nongigira kara adimai vaniau niqira inilau qolumila, migira ara tamani visana ara adiligigira mara saugira vaniau inau. !Minau au tsonisagegira na inilau girani i laona na lake me tavongani laba kesa na nununa na buluka mane qolumila!” ");
INSERT INTO gri_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","A Moses e reigadovia laka a Aaron nogo e tamivanigira na tinoni kara muria niqira papada segeni te ara naua na sasi vaga ia, mara gini paluvangamaqira segeni i mataqira gaqira gala. ");
INSERT INTO gri_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Me vaga ia, ma Moses e vano me ba tû i matana na nauna tana ara tototu, me gû me tsaria, “!Pipi sui igira ara totu tabana konina na Taovia kara mai tutû ieni!” Me vaga ia, migira sui na Levi ara mai mara tupolia, ");
INSERT INTO gri_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","maia e tsarivanigira, “Na Taovia God ni Israel e ketsalia pipi vidamui igamu ke moloa nina isi i bunguna, me ke liu i laona na nauna popono i tana igita a vaturikaegira nida valepolo, ke tû ieni, me ke tsau bâ i tabana, me ke matesigira na tasina, ma gana sai dou, ma gana verakolu.” ");
INSERT INTO gri_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Migira na Levi ara rongomangana a Moses, mara ba matesigira ara gana ngongo tolu toga na mane tana dani ia. ");
INSERT INTO gri_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ma Moses e tsarivanigira na Levi, “I dani eni nogo igamu amu sausegenimui vania na Taovia tana aqo manetabu, rongona amu labumatesigira na dalemui mane ma na kulamui, me vaga ia ma na Taovia e tabugamu i dani eni.” ");
INSERT INTO gri_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mi tana dani ngana ma Moses e tsarivanigira na tinoni, “Igamu amu naua kesa na sasi loki sosongo. Mi kalina ia inau sauba kau dato ba tugua konina na Taovia tana vungavunga; me tau utu ti kau tangomana na sese matena nimui sasi ma na Taovia ke padale vanigamu.” ");
INSERT INTO gri_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mi muri, ma Moses e visubatugua i konina na Taovia me tsaria, “!Alao Taovia igira na tinoni girani ara naua kesa na sasi loki sosongo! Ara aqosia kesa na god qolumila mara samasama vania. ");
INSERT INTO gri_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Kiki ko padale vanigira moa niqira sasi; me ti ke tagara, mo ko adiligia na soaqu inau tania na papi i tana igoe o maretsunagira na soaqira nimu tinoni.” ");
INSERT INTO gri_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma na Taovia e tsarivania, “Tagara, igira moa ara naua na sasi iani sauba kau adiligia na soaqira tania niqu papi. ");
INSERT INTO gri_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Mi kalina ia, migoe ko visutsuna bâ, mo ko idagana sautu vanigira niqu tinoni na vano i tana inau au tsarivanigo nogo. Ko padatugua laka niqu angelo sauba ke mataligamu, me maimai varangi nogo na tagu i tana inau sauba kau kedegira na tinoni girani tana rongona niqira sasi.” ");
INSERT INTO gri_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Me vaga ia, ma na Taovia e molomai vanigira na tinoni kesa na lobogu seko, rongona igira ara turua a Aaron ke aqosivanigira na nununa na buluka mane qolumila ia. ");
INSERT INTO gri_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Na Taovia e tsarivania a Moses, “Ko mololea na nauna iani, igoe migira na tinoni o adirutsumigira tania na Ejipt, ma kamu vano tana kao inau au vekevanitugira nogo a Abraham, ma Isaak, ma Jakob ma tu kukuaqira. ");
INSERT INTO gri_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Inau sauba kau moloa kesa niqu angelo ke mataligamu, ma kau tsialigigira na Kanaan, ma na Amor, ma na Het, ma na Peres, ma na Hivi, ma na Jebus. ");
INSERT INTO gri_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kamu vano igamu tana kao lakatana me vuaga dou ia, minau segeniqu moa e utu kau dulikolugamu, rongona igamu na tinoni tsatsarae sosongo, me tau utu kau ba matesigamu lê i sautu.” ");
INSERT INTO gri_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mi kalina na tinoni ara rongomia na goko vaga ia, migira ara padasavi sosongo mara ngangai, mara tau goto sagelia niqira inilau angaanga. ");
INSERT INTO gri_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Rongona na Taovia e ketsalinogoa a Moses ke tsarivanigira, “Igamu na tinoni tsatsarae sosongo. Me ti vaga inau kau dulikolugamu atsa moa kesa tana tagu tetelo, me sauba e utu ke tagara kau matesiligigamu sui saikesa. Mi kalina ia kamu adiligigira sui nimui inilau angaanga, minau kau pedea na omea gua sauba kau nauvanigamu.” ");
INSERT INTO gri_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Mi murina, kalina igira na tinoni ni Israel ara mololea na Vungavunga Sinai, mara tau nogo sagelia niqira inilau angaanga. ");
INSERT INTO gri_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Pipi kalina igira na tinoni ni Israel ara vaturikaegira niqira valepolo segeni, mi tana ma Moses ke adia na Valepolo Tabu me ke vaturikaea ao tetelo tania na nauna ia. Mara soaginia na Valepolo ia na Valepolo i tana e totu na Taovia, me ti vaga asei ke ngaoa na lavegoko i konina na Taovia ma nina aqo ke vano i tana. ");
INSERT INTO gri_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Me pipi kalina ke vano a Moses i tana, migira na tinoni kara tutû moa tana matsapana niqira valepolo, ma kara matania a Moses poi kalina aia ke ba sage. ");
INSERT INTO gri_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mi muri kalina ke ba sage nogo a Moses, ma na parako ke tsunamai me ke totu tana matsapana na Valepolo, ma na Taovia ke goko vania a Moses talu i laona na parako. ");
INSERT INTO gri_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Mi kalina tsotsodo igira na tinoni kara morosia na parako ia tana matsapana na Valepolo, migira sui kara tsuporu tsuna. ");
INSERT INTO gri_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mi tana ma na Taovia ke goko kolua a Moses, vaga moa kalina kesa tinoni e goko kolua kesa gana sai dou. Mi muri ma Moses ke visubatugua tana ara totu igira na tinoni. Maia moa a Josua na mane vaolu, aia na dalena a Nun, ma gana sasanga a Moses, ke totuvisu i laona na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ma Moses e tsarivania na Taovia, “E mana igoe o tsarinogoa vaniau kau idagana sautu vanigira na tinoni girani na vano tana kao ia, mea moa igoe o tau tsarivaniau inau laka asei sauba ke dulikoluau. Mo tsarigotoa laka o donadouginiau inau mo reingaoau. ");
INSERT INTO gri_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Mi kalina ia, ti vaga igoe o reingaoau manana, mau nongigo ko tsarivulagi vaniau nimu papada, rongona kau gini tangomana na aqo dou vaniamu, ma kau gini naudou babâ moa i matamu igoe. Ko padatugugotoa laka igoe segenimu nogo o vilia na puku na tinoni girani kara lia nimu tinoni segeni.” ");
INSERT INTO gri_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ma na Taovia e tsaria, “Inau sauba kau vano kolugamu, ma kau sangagamu ma kamu gini tangomana.” ");
INSERT INTO gri_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ma Moses e gokovisu me tsaria, “Me ti vaga igoe ko tau dulikolugami, mo ko laka goto na raiamami kami mololea na nauna iani. ");
INSERT INTO gri_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","?Ke koegua ti na tinoni kara donaginia laka igoe o reingaoau inau migira goto nimu tinoni, ti vaga igoe ko tau dulikolugami? Ma nimu totu kolugami nogo igoe sauba ke sauvulagia laka igami ami gini tavosi tanigira na tinoni tavosi sui tana barangengo.” ");
INSERT INTO gri_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Na Taovia e tsarivania a Moses, “Inau sauba kau nau saikesalia moa na omea o nongiau igoe, rongona inau au donadouginigo igoe mau reingaogo.” ");
INSERT INTO gri_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mi muri ma Moses e nongigotoa, “Kiki Taovia ko tamivaniau ma kau reilakana na mararamu angaanga.” ");
INSERT INTO gri_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ma na Taovia e tuguvisua me tsaria, “Inau sauba kau naua ma niqu doulaka popono ke liuputsi tanigo, mi matamu nogo igoe inau sauba kau tsarivulagia na soaqu tabu. Inau nogo na Taovia, minau au vangalaka vaniasei moa au ngaoa kau vangalaka vania, mau galuvea asei moa au ngaoa kau galuvea. ");
INSERT INTO gri_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Minau e utu kau tamivanigo ko morosilakana na mataqu, rongona e tau tangomana ke kesa ke reilakana na mataqu me ke mauri. ");
INSERT INTO gri_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mieni i ligisaqu nogo inau, e totu kesa nauna i tana igoe tangomana ko tû i kelana na vatu. ");
INSERT INTO gri_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mi kalina na mararaqu angaanga ke liuputsi, minau sauba kau molosagego tana mangamangana na vatu ma kau tsavupoiginigo na limaqu poi kalina kau vanoputsi tanigo. ");
INSERT INTO gri_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mi muri, minau sauba kau adiligia na limaqu, migoe sauba tangomana ko reia moa na gotuqu me utu moa vanigo ko reilakana na mataqu.” ");
INSERT INTO gri_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Na Taovia e tsarivania a Moses, “Ko katsukaira tugua ke ruka na pavavatu vaga nogo kaira o katsukaira tana idana, minau sauba kau maretugua i ka koniqira na goko vaga au marenogoa ka koniqira ruka na pavavatu igoe o kotsokaira tana idana. ");
INSERT INTO gri_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Me ke matsaraka ke dani ko datomaitugua i kelana na Vungavunga Sinai na tsodoaqu inau. ");
INSERT INTO gri_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ke laka goto na datomai koluamu ke kesa; ma kau tau goto reia sa tinoni ke totu sa tabana goto na vungavunga; ke tagara goto sa sipi se sa buluka ke mutsamutsa bamai i tuana na vungavunga.” ");
INSERT INTO gri_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mi tana, ma Moses e katsukaira tugua ruka na pavavatu, mi tana matsaraka bongibongi na dani ngana, maia e kalagaidato kaira i kelana na Vungavunga Sinai, vaga nogo na Taovia e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Maia na Taovia e tsunamai i laona na parako, me tutû kolua a Moses i tana, me katevulagi vania na asana tabu, laka na soana aia Taovia. ");
INSERT INTO gri_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mi muri ma na Taovia e liuputsimai i matana a Moses me gokodato me tsaria, “Inau na Taovia inau nogo na God na galuve ma na tobalaka, mau tau dona na kore tsaku, mau dona moa na galuve sosongoliaqira na tinoni, mau totu kalavata i koniqira. ");
INSERT INTO gri_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Au manalia niqu veke vanigira na toga na vatavata, mau padalea na omea seko ara naua ma niqira sasi; me sauba nomoa e utu kau terevia na kedeaqira na dalemui ma na kukuamui tsau bâ tana tolunina ma na vatinina vatavata kara botsamai i muri tana rongona niqira sasi na tamaqira.” ");
INSERT INTO gri_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ma Moses e tsaku sosongo e tsuporu tsuna tana kao me samasama vania God. ");
INSERT INTO gri_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Me tsaria, “Taovia, ti vaga igoe o reingaoau manana inau, mau nongigo ko dulikolugami mo ko reitutugugami i sautu. Eo, e manana nomoa laka na tinoni girani ara tsatsarae sosongo, me atsa moa e vaga Taovia, migoe ko padalegira moa na omea seko ami naua, ma nimami sasi, mo ko tabegami moa vaga nogo nimu tinoni segeni.” ");
INSERT INTO gri_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Na Taovia e tsarivania a Moses, “Kalina ia inau sauba kau naua kesa na vaitasogi kolugira na tinoni ni Israel. Mi mataqira igira inau sauba kau naugira na omea loki sosongo, vaga au tau saikesa vati naua sa nauna tana barangengo mi laona goto sa puku na tinoni tavosi. Pipi sui na tinoni sauba kara reigira na omea loki sosongo inau na Taovia au tangomana na nauana, rongona inau sauba kau naua kesa na omea mamataguniga loki vanigamu. ");
INSERT INTO gri_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Migamu nimui aqo kamu muridougira na ketsa ma na vali inau au sauvanigamu i dani eni. Minau sauba kau tsialigigira na Amor, ma na Kanaan, ma na Het, ma na Peres, ma na Hivi, ma na Jebus, kalina igamu kamu maimai moa i sautu. ");
INSERT INTO gri_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kamu laka goto na nauana sa vekesai koluaqira na tinonina na vera i tana igamu amu vanokalea, rongona ti vaga kamu nauvaganana ia, me tau utu ti ke lia vaga na taviti seko vanigamu. ");
INSERT INTO gri_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ma nimui aqo kamu vui pukaligira niqira belatabu, ma kamu toroutsanigira niqira tuguru tabu, ma kamu kavi pukaligira na nununa niqira god daki ko Asera. ");
INSERT INTO gri_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Kamu laka goto na samasama vaniana sa god tavosi, rongona inau nogo na Taovia nimui God me utu goto kau tamivanigamu kamu tamanina sa god tavosi. ");
INSERT INTO gri_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kamu laka goto na nauana sa vekesai koluaqira na tinonina na vera ia, rongona kalina igira kara vano na samasama vaniaqira niqira god ponotoba ma na savori-kodoputsa vaniaqira, me sauba kara soagamu kamu ba sangagira, mi tana migamu sauba kamu ngaoa na ba sanga na ganiana na mutsa igira ara savori vanigira niqira god ponotoba. ");
INSERT INTO gri_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Me tau utu ti igira na dalemui mane kara taugagira na daki ni veratavosi girani, migira sauba kara raqa sasiligira na dalemui ma kara tau totu kakai i koniqu inau, ma kara ba sanga na samasama vaniaqira niqira god ponotoba. ");
INSERT INTO gri_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Kamu laka goto na aqosiginiaqira na tapala na nunuqira na god peropero ma na samasama vaniaqira. ");
INSERT INTO gri_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Kamu lokisia na Dani Tabu na Bredi Tagara Isti Konina. Me vaga nogo na omea inau au ketsaliginigamu, kamu gania moa na bredi e tagara isti konina i laona ke vitu na dani tana vulana Abib, rongona tana vula vaga nogo ia igamu amu mololea i Ejipt. ");
INSERT INTO gri_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Pipi sui na baka mane botsaida, ma na idana na daleqira mane nimui omea tuavati papala ara tamaniqu sui inau, ");
INSERT INTO gri_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","migamu nimui aqo kamu volivisua kesa na dalena asi mane botsaida tana savoriana kesa na dalena sipi na tuguna. Me ti vaga kamu tau ngaoa na volivisuana na asi ia, ma kamu birukutsia moa na liona. Ma nimui aqo kamu volivisua pipi sui na dalemui mane botsaida. “Me ke laka goto ke kesa na mai laba i mataqu inau, ti ke tagara nina sausau. ");
INSERT INTO gri_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Igamu amu tamanina nogo e ono na dani i tana kamu naua nimui aqo, mi tana vitunina dani igamu kamu tau goto naua sa aqo, atsa moa ti ke gado tana tagu na tsutsuka se na pipitsu. ");
INSERT INTO gri_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Kamu lokisia na Dani Tabu na Pipitsu kalina igamu amu tuturiga moa na pitsuana na kesanina pipitsu nimui uiti, ma kamu lokisigotoa na Dani Tabu na Babale tana ka gaqira levuga na tagu na papara ma na tagu na bisi kalina igamu amu angunikolugira nimui vuana gai mutsamutsa. ");
INSERT INTO gri_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Ke tolu na tagu i laona kesa na ngalitupa niqira aqo pipi sui nimui mane kara mai na samasama vaniaqu inau na Taovia na God ni Israel. ");
INSERT INTO gri_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mi muri kalina kau tsialigigira na puku sui na tinoni tavosi i matamui igamu, ma kau ratsuvanigamu nogo nimui butona kao, me sauba ke tagara goto ke kesa ke tovoa na sugutiana na veramui tana tolu na dani tabu tugirani. ");
INSERT INTO gri_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Kamu laka na savoriana na bredi na isti i konina kalina kamu gini savori-kodokodo vaniau kesa na omea tuavati. Kamu laka goto na moloana ke totu tsaulina na matsaraka na dani ngana sa turina na omea tuavati amu matesia tana Dani Tabu na Paseka. ");
INSERT INTO gri_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Pipi ngalitupa kamu adimaia tana valena na Taovia na kesanina pipitsu tana nimui uta. “Ma kamu laka na kukiana sa dalena naniqoti tana kona na tsutsuna tinana.” ");
INSERT INTO gri_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mi muri ma na Taovia e tsarivania a Moses, “Ko maretsunagira na goko girani, rongona tana tsaqina goko nogo girani e pukuga na vaitasogi au naukolugo igoe kalina eni me kolugira na tinoni ni Israel.” ");
INSERT INTO gri_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ma Moses e totu i tana kolua na Taovia e vati sangavulu na dani me vati sangavulu na bongi, me tau goto gania me ke inuvia sa omea. Mi tana pavavatu kaira aia e maretsunâ na gokona na taso, igira nogo na Sangavulu Ketsa. ");
INSERT INTO gri_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mi kalina a Moses e visumaitugua tania na Vungavunga Sinai kolukaira ruka na pavavatu i tana e maregira na Sangavulu Ketsa, maia e tau moa dona laka e angaanga na ngorana tana rongona aia e talu na goko koluana na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mi kalina a Aaron migira sui na toga ara reia e angaanga na ngorana a Moses, migira ara matagu na ba varangisiana. ");
INSERT INTO gri_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Maia Moses e soamaigira, ma Aaron migira sui na ida tana saikolu ara bâ i konina, ma Moses e goko vanigira. ");
INSERT INTO gri_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Mi murina ia, migira sui na tinoni ni Israel ara saimai i konina, ma Moses e tsarivulagi vanigira pipi sui na ketsa aia na Taovia e sauvaninogoa tana Vungavunga Sinai. ");
INSERT INTO gri_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mi kalina a Moses e sui na goko vaniaqira, maia e tsavupoiginia na polo na lovana. ");
INSERT INTO gri_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Me pipi kalina a Moses ke vano i laona na Valepolo Tabu na goko koluana na Taovia, maia ke adiligia na polo ia tania na lovana. Mi kalina aia ke rutsumaitugua, maia ke ba tsarivanigira na tinoni ni Israel pipi sui na omea na Taovia e raiginia ke tsarivanigira, ");
INSERT INTO gri_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","migira kara morosia na ngorana ke angaanga. Mi muri ti aia ke tsavupoigini tugua na polo na lovana, poi ke tsau kalina aia ke vanotugua na goko koluana na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ma Moses e soasaigira na saikolu popono na tinoni ni Israel me tsarivanigira, “Iani nogo e vaga na omea e ketsaliginigamu na Taovia kamu naua: ");
INSERT INTO gri_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Igamu amu tamanina nogo e ono na dani i tana kamu naua nimui aqo, ma na vitunina dani aia ke lia nimui dani tabu, na dani na mango amu baloa vaniau inau na Taovia. Me ti vaga asei ke naua na aqo tana dani ia, ma nimui aqo kamu labumatesia. ");
INSERT INTO gri_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kamu laka goto na soqoi lake i laona na valemui tana Dani na Sabat.” ");
INSERT INTO gri_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Ma Moses e tsarivanigira sui na tinoni ni Israel na goko vaga iani, “Iani nogo na omea e ketsaliginigamu na Taovia: ");
INSERT INTO gri_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kamu adia i laoqira nimui omea tatamani na vangana na sausau vania na Taovia. Me ti vaga asei ke ngaoa na nauana ma nina aqo ke adimaia na sausau na qolumila, ma na siliva, ma na tapalamila; ");
INSERT INTO gri_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ma na polo ara vosiginia na terete laka; ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi; na polo ara vosiginia na ivuna na naniqoti; ");
INSERT INTO gri_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","na kokorana na sipi mane ara somua me tsitsi; na kokorana goto na naniqoti; na gai na na akasia; ");
INSERT INTO gri_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","na oela gana na bulu iruiru; na papasa sisigini dou gana na oela na nina omea, ma na buluna gai uruuru sisigini dou; ");
INSERT INTO gri_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","na vatu angaanga tsitsi, migira goto visana na vatana na vatu angaanga loki matena tavosi gana na moloana tana nina epod ma na todo tetelo tana aseasena na Mane Tabu Loki. ");
INSERT INTO gri_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Igira sui na mane i laomui igira ara sasaga tana aqosi omea levolevo kara mai ma kara aqosigira na omea sui e ketsaligamu na Taovia kamu naua: ");
INSERT INTO gri_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","na Valepolo, ma na tsatsavuna i laona mi taba, na salilina ma na pava damadama, na qaroqaro, na tuguruna, ma na tototona; ");
INSERT INTO gri_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","na Bokisi na Taso, ma na gai na mani kalagaiginiana, na vovongona, ma na polokatsi gana na tsauraginiana i matana; ");
INSERT INTO gri_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","na bela gana na molo bredi, ma na gai na mani kalagaiginiana, me pipi sui na vangana; ma na bredi gana na sauvaniana God; ");
INSERT INTO gri_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","na gai na molodato bilona bulu iruiru migira na vangana; na bilo kolugira na bulu; ");
INSERT INTO gri_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","na belatabu gana na kodo buluna gai uruuru ma na gai na mani kalagaiginiana; na oela tabu gana na nina omea; na bulunagai uruuru sisigini dou; na polokatsi gana na tsauraginiana tana matsapana na Valepolo; ");
INSERT INTO gri_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","na belatabu gana na savori-kodoputsa, kolua na didilana lake tapalamila, ma na gai na mani kalagaiginiana, migira sui na vangana; na popo na vulivuli ma na tototona; ");
INSERT INTO gri_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","na polokatsi gana na bara poliana na pakokana, na tuguruna ma na tototoqira; ma na polokatsi gana na matsapana na bara; ");
INSERT INTO gri_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na itai na kakaisiginiana na Valepolo ma na polona na bara, ma na gai tetelo gana na sori itai; ");
INSERT INTO gri_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ma na poloqira tabu rereidou sosongo a Aaron mitugira na dalena gana kara tu sagelia kalina kara tu ba naua niqira aqo i laona na Nauna Tabu.” ");
INSERT INTO gri_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mi murina e goko sui a Moses, migira sui na tinoni ni Israel ara tavota mara vano, ");
INSERT INTO gri_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","migira sui ara padangaoa na nauana ara tû, mara adimaia niqira sausau vania na Taovia gana na aqosiginiana na Valepolo i tana ke totu aia. Mara adimaia pipi sui na omea e kilia gana na gini aqo tana samasama ma gana na aqosiginiana na poloqira na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Igira sui na mane ma na daki ara padangaoa na nauana, ara adimaigira na pini na inilau, na tsaukuli, na ringi, na liolio, me lelevoga na vatana na inilau qolumila, mara saugira sui vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Migira sui ara tamanina na terete laka; ma na terete bora, tsitsibora, se tsitsilaka, ara aqosiginia na ivuna sipi; ma na polo ara vosiginia na ivuna naniqoti; ma na kokorana sipi mane ara somua me tsitsi; se na kokorana na naniqoti, ara adimaigira vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Migira sui ara tangomana kara saua na siliva se na tapalamila ara adimaia niqira sausau vania na Taovia, migira sui goto ara tamanina na gai na akasia e ulagana kara gini aqo tana pipi vatana na aqo, ara adimaigira goto. ");
INSERT INTO gri_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Igira sui na daki ara dona dou sosongo na vosipolo ara adimaia na terete laka, ma na terete bora, tsitsibora, me tsitsilaka ara aqosiginia na ivuna sipi, igira segeni nogo ara vosia. ");
INSERT INTO gri_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ara aqosigotoa na terete ginia na ivuna na naniqoti. ");
INSERT INTO gri_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Migira na ida ara adimaigira na vatu angaanga tsitsi, migira goto visana na vatana na vatu angaanga tavosi loki matena, gana kara mologira bâ tana epod ma na todo tetelo gana na aseasena na Mane Tabu Loki, ");
INSERT INTO gri_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","na papasa sisigini dou ma na bulu gana na bilo, na oela gana na nina omea, ma gana goto na bulunagai sisigini dou. ");
INSERT INTO gri_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Migira sui na tinoni ni Israel ara padangaoa na nauana ara tû mara adimaigira niqira sausau vania na Taovia gana na aqosiginiaqira na omea aia na Taovia e ketsaliginia a Moses ke naua. ");
INSERT INTO gri_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ma Moses e tsarivanigira na tinoni ni Israel, “Na Taovia e vilinogoa a Besalel na dalena a Uri ma na kukuana a Hur tana puku konina a Juda. ");
INSERT INTO gri_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ma God e dangaliginia na susuligana, me sauvaninogoa na sasaga loki, ma na padagado, ma na donalevo tana aqosiana pipi sui vatana na omea mamarega, ");
INSERT INTO gri_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ma na botsangiana pipi vatana na mamare mamarega, ma na aqosiginiaqira na qolumila, ma na siliva, ma na tapalamila; ");
INSERT INTO gri_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ma na lasiaqira na vatu angaanga gana na baruaqira na omea levolevo; ma na katsu gai; me pipi sui goto vatana na aqosi omea mamarega tavosi. ");
INSERT INTO gri_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Na Taovia e sauvanikaira nogo a Besalel ma Oholiab aia na dalena a Ahisamak tana puku konina a Dan, na sasaga gana na taraiaqira na tinoni tavosi tana aqosi omea levolevo vaga ara ka dona kaira. ");
INSERT INTO gri_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Maia e sauvanikaira na sasaga loki gana na donadouginiana pipi vatana na aqo vaga ara naua igira ara dona sosongo na aqosiana na kikiri tana omea levolevo, se na botsangiana pipi vatana na mamare mamarega, se na gini vosipolo na terete laka; ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi; me visana goto vatana na polo tavosi. Kaira ara ka tangomana sosongo na nauana pipi sui na vatana na aqo, mara ka dona dou sosongo goto na botsangiana na omea vaolu. ");
INSERT INTO gri_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Kaira a Besalel ma Oholiab, migira sui tavosi goto na mane sasaga aia na Taovia e sauvanigira nogo na padagado ma na donalevo mara donadouginia na aqosiana pipi na omea sui ara kilia gana na logoana na Valepolo Tabu, igira nogo niqira aqo kara aqosigira pipi sui na omea girani taoninogoa na omea e ketsaliginigira na Taovia.” ");
INSERT INTO gri_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ma Moses e soamaikaira a Besalel, ma Oholiab, migira sui goto na mane sasaga tavosi aia na Taovia e sauvanigira nogo na sasaga gana na aqosi omea levolevo, mara padangaoa na sasanga, ma Moses e tsarivanigira kara tuturiga na aqo. ");
INSERT INTO gri_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ma Moses e tusuvanigira pipi sui na sausau igira na tinoni ni Israel ara adimaia gana na aqosiana na Valepolo Tabu. Migira na tinoni ni Israel ara tau kuti na adimai vaniana a Moses niqira sausau pipi matsaraka. ");
INSERT INTO gri_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Migira na mane sasaga ara naua na aqo ia, ara vano ");
INSERT INTO gri_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mara ba tsarivania a Moses, “Igira na tinoni ara adiadi mai moa danga sosongo na omea, liusia na omea igita a kilia gana na aqosiaqira na omea sui na Taovia e ketsaliginigita ka naua.” ");
INSERT INTO gri_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Me vaga ia ma Moses e mologoko i laona na vera popono me tsarivanigira kara laka goto na sauana babâ niqira vangalaka gana na aqosiana na Valepolo Tabu ma na vangana sui; mi tana migira na tinoni ara tau goto adimaia sa niqira vangalaka. ");
INSERT INTO gri_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Igira na omea ara adimainogoa e danga liusinogoa na omea e tugua na aqosiginiaqira pipi sui na aqo. ");
INSERT INTO gri_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Igira ara sasaga sosongo bâ i laoqira na tinoni aqo, ara aqosia na Valepolo tana ke totu na Taovia. Ara aqosiginia sangavulu turina na polo vovosi laka ara vosiginia na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, mara tula mamaregasigira taonia na nunuqira na angelo. ");
INSERT INTO gri_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Me pipi na turina e kesa moa atsa na katsina ma na damana, ara sangava ono na katsina me sangava kesa na damana. ");
INSERT INTO gri_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ara tulasaigira tsege na turina, mara nauvaganana goto ia tugira tsege na turina tavosi. ");
INSERT INTO gri_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mara aqosiginia na polo bora na kakauna tana ka isuisuqira kaira na turina loki. ");
INSERT INTO gri_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Mara mologira ara tsege sangavulu na kakauna tana liligina na kesanina turina loki, me tsege sangavulu goto na kakauna kale bâ tana liligina na rukanina turina loki. ");
INSERT INTO gri_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Mara aqosigira goto tsege sangavulu na salili qolumila gana kara raqasaiginikaira ruka na turina loki ma kara ka gini lia kesa moa na polo popono. ");
INSERT INTO gri_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Mi muri, mara aqosiginia na ivuna na naniqoti ara sangavulu kesa na turina na polo gana na tsatsavuna na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Mara aqosigira ara kesa moa atsa na katsiqira ma na damaqira, ara sangava ono tabailima na katsiqira me sangava kesa na damaqira. ");
INSERT INTO gri_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ara tulasaigira tsege na turina me gini lia kesa turina loki, mara tulasai vaganana goto tugira ono na turina tavosi. ");
INSERT INTO gri_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ara mologira tsege sangavulu na kakauna tana liligina na kesanina turina loki, me tsege sangavulu goto na kakauna tana liligina na rukanina turina loki. ");
INSERT INTO gri_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ara mologotoa tsege sangavulu na salili tapalamila gana ke raqasaikaira na turina kaira rongona kara ka gini lia kesa moa na tsatsavu. ");
INSERT INTO gri_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mara aqosikaira goto ruka goto na tsatsavuna, kesa ara aqosiginia na kokorana na sipi mane ara somua me tsitsi, me kesa ara aqosiginia na kokorana na naniqoti, aia gana ke pala i taba. ");
INSERT INTO gri_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Migira na pava damadama gana na mani vaturikaeana na Valepolo ara aqosiginia na gai na akasia. ");
INSERT INTO gri_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Me pipi na pava damadama e sangava ruka na katsina, me tinaqe tolu na damana, ");
INSERT INTO gri_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","mara kavisasana ruka na isuisuna pipi na pava damadama rongona kara gini tangomana na tugutasai dou. Me pipi sui na pava damadama ara kavisasaqira manoga vaga ia. ");
INSERT INTO gri_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Mara aqosi manogatigira ara rukapatu na pava damadama gana tabana i ata, ");
INSERT INTO gri_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","me vati sangavulu na tototo siliva gana na tuaqira na pava damadama gira, ruka tototo i tuana kesa na pava damadama gana ke gado bâ tana nauna ara kavisasana. ");
INSERT INTO gri_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Mara aqosigira goto rukapatu na pava damadama gana tabana i vava na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","me vati sangavulu na tototo siliva, ruka tototo i tuana pipi na pava damadama. ");
INSERT INTO gri_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Gana i murina na Valepolo tabana i tasi ara aqosigira goto ono na pava damadama, ");
INSERT INTO gri_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","me ruka na pava damadama gana tana tsuruna. ");
INSERT INTO gri_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ma na pava damadama tana tsuruna ara ka sai tû i lao me tsau bâ i gotu. Mara aqosivaganana ia na pava damadama ruka tana tsuruna. ");
INSERT INTO gri_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Me vaga ia mara alu na pava damadama kolugira sangavulu ono na tototo siliva, ruka tototo i tuana kesa na pava damadama. ");
INSERT INTO gri_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Mara aqosigira goto sangavulu tsege na qaroqaro ginia na gai na akasia, tsege na qaroqaro gana na pava damadama kesa tabana na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","me tsege gana kesa tabana, me tsege goto gana i murina tabana i tasi. ");
INSERT INTO gri_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ma na qaroqaro e liu i levugaqira na pava damadama e vano saviliu tuturiga kesa tabana na Valepolo me tsau bâ i tabana. ");
INSERT INTO gri_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ma na pava damadama gira ara lesoviginigira popono na qolumila, mara molo bâ na ringi qolumila i koniqira gana kara tangoliginigira na qaroqaro, ma na qaroqaro goto ara lesoviginigira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ma na polokatsi ara vosiginia na terete laka, ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, mara tula mamaregasia taonia na nununa na angelo i konina. ");
INSERT INTO gri_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Mara aqositugira goto vati na tuguru ginia na gai na akasia gana na tsauraginiana na polokatsi ia, mara lesoviginitugira na qolumila, mara molo bâ na salili tu koniqira. Mi muri, mara aqositugira vati na tototo siliva gana kara tangoli kakaigira na tuguru tugira. ");
INSERT INTO gri_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mara vosigotoa kesa na polokatsi gana tana matsapana na Valepolo ginia na terete laka, ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, mara inilauginia na tula mamarega levolevo. ");
INSERT INTO gri_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ma gana na mani tsauraginiana na polokatsi iani ara aqositugira tsege na tuguru mara tsukulagini bâ na salili tu koniqira, mara lesoviginia na qolumila tu i kelaqira na tuguru ma na gaina na tsauragini polo, mara aqosigira goto tu tsege na tototo tapalamila gana kara tukae na tuguru tugirani. ");
INSERT INTO gri_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ma Besalel e aqosiginigotoa na gai na akasia na Bokisi na Taso, e tinaqe tsege na katsina, me tinaqe tolu na damana, me tinaqe tolu na datona. ");
INSERT INTO gri_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Maia e tsavu poponoginia na qolumila laka i laona mi taba, me mologotoa na qolumila polia na liligina i gotu. ");
INSERT INTO gri_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Me aqosiginigotoa na qolumila tu vati na ringi me bulu bâ tugira vati tana tuana, ruka ringi tabana, me ruka tabana. ");
INSERT INTO gri_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Me aqosiginia na gai na akasia ruka na gai na kalagai me lesoviginikaira na qolumila, ");
INSERT INTO gri_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","me tsukulagini sagekaira bâ tana ringi ara totu ruka tabana na bokisi. ");
INSERT INTO gri_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Maia e aqosiginia na qolumila laka na vovongona, e tinaqe tsege na katsina me tinaqe tolu na damana. ");
INSERT INTO gri_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Me aqosiginia na qolumila ara tai tapetapea ruka na nununa na angelo, ");
INSERT INTO gri_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","mara molokaira kara ka totu ruka tabana na isuisuna na vovongona na bokisi ia. Me aqosisaikaira kolunogoa na vovongo ia. ");
INSERT INTO gri_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ma na nununa na angelo kaira ara ka tu vaiarovigi i kelana na vovongo, ma ka rapoqira ara tatakatsi mara tsavu poponoa. ");
INSERT INTO gri_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Maia e aqosiginigotoa na gai na akasia kesa na bela, e tinaqe vati na katsina, me tinaqe ruka na damana me tinaqe tolu na datona. ");
INSERT INTO gri_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Me lesovi poponoginia na qolumila laka me moloa na qolumila polia na liligina i gotu. ");
INSERT INTO gri_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Me aqosia na titibana e labuvati na damana polipolia na bela, me moloa na qolumila polia na liligina na titibana. ");
INSERT INTO gri_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Maia e aqositugira goto vati na ringi qolumila gana na tsukulagini baana na gai na kalagai, me molobatugira tana vati tsutsukena i tana ara totu na tuana. ");
INSERT INTO gri_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mi tugira na ringi gana na tangoliginiaqira kaira na gai na mani kalagaiana na bela, aia e molotugira kara tu totu varangisia na titibana. ");
INSERT INTO gri_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Me aqosiginia na gai na akasia ruka na gai na kalagai, me lesoviginikaira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Maia e aqosiginia na qolumila laka na vangana na belatabu ia: na peleti, na bilo, na popovatu, migira na popo laka gana na gini aqo tana savori uaeni. ");
INSERT INTO gri_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Maia e aqosiginia na qolumila laka kesa na gai na mani molodato bilona bulu iruiru. Me aqosiginigotoa na qolumila ara tai tapetapea na tuana ma na gai gotona; migira na inilauna kolugira na nununa na tsitsi oqo ma na tsitsi tavuresi e aqosisai kolunogoa na gaina. ");
INSERT INTO gri_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mara tu ono na arana ara tu varaga bâ tana gai gotona, tolu kesa tabana me tolu kesa tabana. ");
INSERT INTO gri_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Pipi ono na arana ara tu tamanina tolu na nununa tsitsi i konina ara rerei vaga na latsena na gatsoga kolu oqona ma na tavuresina. ");
INSERT INTO gri_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Mi tana gai gotona e totu goto vati na nununa na tsitsi i konina, ara rerei vaga na latsena na gatsoga kolu oqona ma na tavuresina. ");
INSERT INTO gri_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Me kesa na oqona e totu i ka vavaqira i tana ara ka varagasai pipi ruka na arana. ");
INSERT INTO gri_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Igira na nununa na tsitsi oqo ma na arana e aqosisai kolunogoa na gai gotona ginia na qolumila laka ara tai tapetapea. ");
INSERT INTO gri_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Me aqosigira goto vitu na bilo gana na mani molodatoana bâ tana arana, migira na kapi ma na omea agana na kalagaiginiaqira na bilona na bulu aia e aqosiginia na qolumila laka. ");
INSERT INTO gri_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Aia e gini aqo tolu sangavulu tsege na kilo na qolumila laka na aqosiginiana na gai na mani molodato bilona bulu iruiru kolugira pipi sui na vangana. ");
INSERT INTO gri_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Me aqosiginia na gai na akasia kesa na belatabu gana na kodo bulunagai uruuru. Aia e atsa saikesa na katsina ma na damana, e tinaqe ruka labu kesa na katsina, me tinaqe ruka labu kesa na damana, me tinaqe vati labu ruka na datona. Ma na gai ara katsadato tana vati tsukena e aqosisai kolunogoa na belatabu ia. ");
INSERT INTO gri_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Maia e lesoviginia na qolumila laka na kelana, mi tugira sui vati tabana, mi tugira na gai ara katsadato, me mologotoa na qolumila polipolia na liligina i gotu. ");
INSERT INTO gri_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Me aqosigotoa ruka na ringi qolumila gana na tsukulaginiana na gai na kalagaia, me molobagira i vavana na liligina tabana mi tabana, gana na tangoliginiana na gai na kalagai kalina kara kalagaia. ");
INSERT INTO gri_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Me aqosiginia na gai na akasia kaira na gai na kalagai me lesoviginikaira na qolumila. ");
INSERT INTO gri_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Aia e aqosigotoa na oela tabu gana na nina omea ma na bulunagai uruuru sisigini dou, e lalo vaganana nogo ara naua igira niqira aqo na aqosi kô sisigini dou. ");
INSERT INTO gri_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ma gana na savori-kodoputsa aia e aqosiginia na gai na akasia kesa segeni goto na belatabu. E atsa saikesa na katsina ma na damana, e sangava kesa tinaqe ruka na katsina ma na damana, me tinaqe vitu na datona. ");
INSERT INTO gri_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Me aqosisai kolunogoa na belatabu tugira vati na gai ara katsadato vati tana tsukena. Ma na belatabu popono aia e lesoviginia na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Maia e aqosiginigotoa na tapalamila na vangana sui na belatabu: na bilo tapala gana na mani kodoana na bulunagai uruuru i laona, na savolo, na popo, na poka, ma na tapala tapetape gana na adimadaova gagâ. ");
INSERT INTO gri_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Aia e aqosiginigotoa na tapalamila na didilana lake me molo bâ i vavana na titibana na belatabu me ke tsuna tsau bâ ganangongo i levugana. ");
INSERT INTO gri_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Maia e aqosigotoa vati na ringi gana na tsukulaginiana na gai na kalagai, me mologira bâ tana vati tsutsukena. ");
INSERT INTO gri_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Me aqosiginigotoa na gai na akasia ruka na gai na kalagaiginiana, me lesoviginikaira na tapalamila, ");
INSERT INTO gri_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","me tsukulaginisage kaira i laona na ringi ara totu i tabana mi tabana na belatabu. Ma na belatabu ia e aqosiginia na pava damadama, mi kelana e ova tsapatugu. ");
INSERT INTO gri_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Maia e aqosiginia na popo tapalamila ma na tototona tapalamila niqira qilasi na tironunu igira na daki ara aqo tana matana na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ma gana na pakokana na Valepolo Tabu aia e aqosiginia na bara na polokatsi vovosi laka. I tabana i ata e sangava rukapatu ruka na katsina, ");
INSERT INTO gri_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","mara rukapatu na tuguru tapalamila kolugira rukapatu na tototo tapalamila ara tangolia na polokatsi ia, kolugira na salili ma na qala gana na tsauragini polokatsi e aqosiginia na siliva. ");
INSERT INTO gri_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tabana i vava na bara ia, aia e aqosi vaganana goto. ");
INSERT INTO gri_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mi tabana i tasi na polo e sangava sangavulu kesa na katsina, kolugira sangavulu na tuguru mara sangavulu na tototoqira, kolugira goto na salili ma na gai na tsauragini polo e aqosiginia na siliva. ");
INSERT INTO gri_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mi tabana i longa, i tana e totu na matsapa, na bara e sangava sangavulu kesa goto na damana. ");
INSERT INTO gri_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Me ruka tabana na matsapa na polokatsi e sangava tolu tinaqe ono na katsina, kolugira tolu na tuguru me tolu na tototoqira. ");
INSERT INTO gri_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Me pipi sui na polokatsi na bara ia, aia e aqosiginia na polo vovosi laka. ");
INSERT INTO gri_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ma na tototo gana na tuguru e aqosiginigira na tapalamila, ma na salili, ma na qala gana na tsauragini polo, ma na tsatsavuna na tuguru e aqosiginigira sui na siliva. Pipi sui na tuguru polipolia na bara aia e sorisaikolugira na qala siliva gana na tsauragini polo. ");
INSERT INTO gri_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Na polokatsi gana tana matsapana na bara, aia e vosiginia na terete laka, kolua na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, me inilauginia na tula mamarega levolevo. E sangava vati tabailima na katsina me sangava kesa na datona, vaga nogo igira na polokatsi tavosi tana bara ia. ");
INSERT INTO gri_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","E vati na tuguru i laona vati na tototo tapalamila ara tangolia na polokatsi iani. Na saliliqira, na tsatsavuqira na tuguru, ma na qalaqira e aqosiginigira sui na siliva. ");
INSERT INTO gri_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Pipi sui na gai tetelo gana na mani sori itaina na Valepolo ma na polokatsi na bara e polipolia na pakokana e aqosiginigira sui goto na tapalamila. ");
INSERT INTO gri_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Iani nogo na mamarena na dangaqira na omea ara gini aqo tana aqosiana na Valepolo Tabu, i tana ara ka totu kaira ruka na pavavatu tana e totu na mamarena na Sangavulu Ketsa. Tana nina rarai a Moses, migira na Levi ara aqo i vavana nina tagao a Itamar na dalena a Aaron na manetabu, ara maretsunâ na dangaqira na omea ara gini aqo. ");
INSERT INTO gri_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","A Besalel, na dalena a Uri ma na kukuana a Hur tana puku konina a Juda, e aqosigira pipi sui na omea aia na Taovia e ketsaligira kara naua. ");
INSERT INTO gri_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ma gana sasanga, aia Oholiab na dalena a Ahisamak tana puku konina a Dan, nina aqo ia na aqosi kikiri, ma na botsangiana pipi vatana na mamare mamarega, ma na vosiginiana na terete laka, ma na terete bora, tsitsibora, me tsitsilaka ara aqosiginia na ivuna sipi. ");
INSERT INTO gri_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Igira sui na qolumila ara balovania na Taovia gana na Valepolo Tabu, e kesa toga na kilo na mamavana, taonia na tovomamava ara gini aqo tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ma na siliva ara adia i koniqira igira ara maretsunâ na soaqira tana tagu ara naua na tsoko tinoni e 3,430 kilo na mamavana, taonia na tovomamava ara gini aqo tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Iani nogo e vaga na dangaqira na omea ara saua igira na tinoni ara maretsunâ na soaqira tana tagu ara naua na tsoko tinoni, pipi tinoni e tsonia na dangana vaga ara pedea, taoninogoa na tovomamava ara gini aqo tana tagu ia. Ara 603,550 na mane e tsaulia rukapatu ngalitupaqira me dato ara tsokogira tana tsoko tinoni. ");
INSERT INTO gri_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tana siliva, e 3,400 kilo ara gini aqo tana aqosiaqira kesa sangatu na tototo gana na Valepolo Tabu me gana na polokatsi, me 34 kilo gana pipi na tototo. ");
INSERT INTO gri_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Mi tana 30 kilo na siliva ara totuvisu, a Besalel e aqosiginigira na qala gana na mani tsauragini polo, ma na salili gana na tuguru, ma na tsatsavu i kelaqira na tuguru. ");
INSERT INTO gri_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ma na tapalamila ara balovania na Taovia e tsaulia 2,425 kilo. ");
INSERT INTO gri_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Mi tana tapalamila girani a Besalel e aqosiginigira na tototo gana na matsapana na Valepolo Tabu, na belatabu tapalamila kolua na didilana lake tapalamila, me pipi sui na vangana na belatabu, ");
INSERT INTO gri_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","na tototo gana na tuguru polipolia na bara, me gana na matsapana na bara, me pipi sui na gai tetelo gana na sori itaina na Valepolo ma na polona na bara e polipolia na pakokana. ");
INSERT INTO gri_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ara vosiginia na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, na polo rerei dou sosongo kara sagelia igira na manetabu kalina kara tû na nauana niqira aqo tana Nauna Tabu. Mara aqosi polotabu vania a Aaron vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ara vosiginia na epod na polo vovosi laka; ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, ma na terete qolumila. ");
INSERT INTO gri_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ara tai tapetapegira na qolumila, mara sire katsikatsigira mara vosilalo kolua na terete laka, me kolugotoa na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi. ");
INSERT INTO gri_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ara aqosikaira ruka na itai na kokove gana na epod mara sorikaira bâ ruka tabana rongona ke gini totu kakai na epod. ");
INSERT INTO gri_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ma na itai na polo vovosi laka gana na sosori i levuga ara tulasai kolugotoa na epod, ginia kesa moa atsa na terete laka, ma na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, ma na terete qolumila, vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mara vangaraukaira ruka na vatu angaanga tsitsi loki matena, mara kiri bâ i ka koniqira tu soaqira na sangavulu ruka na dalena mane a Jakob, mara molotsavukaira bâ tana omea momolilo qolumila. ");
INSERT INTO gri_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mara tulakaira bâ tana itaina kokove na epod vaga na papadana tugira na sangavulu ruka na puku tana Israel, vaga nogo na Taovia e ketsaliginigira a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Mara aqosiginia na todo tetelo gana ke tsautsau tana aseasena na Mane Tabu Loki e kesa moa atsa na polo vovosi laka vaga ara aqosiginia na epod, me atsa goto na tula mamarega i konina. ");
INSERT INTO gri_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ara aqosia e kesa atsa moa na katsina ma na damana mara bunirukâ, e tinaqe kesa na katsina me tinaqe kesa na damana. ");
INSERT INTO gri_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","13","Mara adigira e sangavulu ruka na vatana tavosi babâ na vatu angaanga loki matena, mara molosagetugira tana omea momolilo qolumila. Mi muri, mara molotugira i konina na todo tetelo ia, e vati na palatete, me tolu na vatu tavosi i kelana pipi na palatete. ");
INSERT INTO gri_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","I konina pipi tu vidaqira sangavulu ruka na vatu tugirani, ara kiria na soana kesa tu vidaqira na dalena mane a Jakob, na papadana tugira sangavulu ruka puku tana Israel. ");
INSERT INTO gri_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ma gana na todo tetelo tana asease ara aqosivania na tseni qolumila laka mara mili vaganana na itai. ");
INSERT INTO gri_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Mara aqosigotoa ruka na omea momolilo qolumila me ruka na ringi qolumila, mara sorikaira na ringi kaira tana tsutsukena i gotu na todo tetelo gana na asease. ");
INSERT INTO gri_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mara sori bâ na isuisuna kaira ruka na tseni qolumila ka koniqira kaira ruka na ringi qolumila, ");
INSERT INTO gri_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","mara sori bâ kaira goto na isuisuna tavosi na tseni kaira, ka koniqira ruka na omea momolilo qolumila, me vaga ia mara sorikaira bâ i nago tana itai na kokove tana epod. ");
INSERT INTO gri_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Mara aqosigotoa ruka na ringi qolumila, mara sorikaira bâ ruka tana isuisuna i lao na todo tetelo gana na asease, tabana i laona varangisia na epod. ");
INSERT INTO gri_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mara aqosigotoa ruka na ringi qolumila, mara molokaira bâ i nago tana susuina na itaina kokove na epod, varangisia na sasaina i kelana na itai na polo vovosi laka gana na sosori i levuga. ");
INSERT INTO gri_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Me vaga nogo na omea na Taovia e ketsaliginia a Moses, igira ara soriginia na itai bora na ringina na todo tetelo gana na asease tana ringina na epod, rongona na todo tetelo ia ke totu kakai dou i kelana na itai na sosori levuga, me ke gini tau tatatsora lê. ");
INSERT INTO gri_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Na polo sagesage katsi aia e pala i vavana na epod, ara vosigini saikesalia moa na terete bora ara aqosiginia na ivuna sipi. ");
INSERT INTO gri_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ma na liligina na ovaova gana na lova, ara tula matolusidoua gana ke gini tau taratsi tsaku. ");
INSERT INTO gri_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Mara tula polipolia na tuana na polo sagesage katsi ia visana na nununa na vuanagai momolilo ginia na terete bora, tsitsibora, me tsitsilaka, ara aqosiginia na ivuna sipi, mara tula na belo qolumila laka kara tsautsau i levugaqira na vuanagai gira, vaga nogo na omea na Taovia e ketsaligininogoa a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Mara tula sote vania a Aaron mitugira na dalena, ");
INSERT INTO gri_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ma na kepi, ma na polo ni laona kara tu sagelia i vavana na polo katsi, ");
INSERT INTO gri_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","mara vosi itai na sosori i levuga ginia na terete laka, ma na terete bora, tsitsibora me tsitsilaka, ara aqosiginia na ivuna sipi, mara inilauginigira na tula mamarega levolevo, vaga nogo na omea na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Mara aqosiginia na qolumila laka kesa na inilau, vaga na papadana na omea ara baloa, mara kiria i konina na goko iani, “BALOVANINOGOA NA TAOVIA.” ");
INSERT INTO gri_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mara soriginia na itai bora i nagona nina kepi a Aaron, vaga nogo na omea na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mi tana mara suilavagini saikesalia pipi sui na aqona na Valepolo Tabu. Igira na toga ni Israel ara naua pipi sui na omea vaga na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ara adimai vania a Moses na Valepolo me pipi sui na vangana, na salilina, na pava damadama, na qaroqaro, na tuguruna, ma na tototona; ");
INSERT INTO gri_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na tsatsavuna ara aqosiginia na kokorana sipi mane ara somua me tsitsi; ma na tsatsavuna ara aqosiginia na kokorana na naniqoti; ma na polokatsi gana i matana na Bokisi na Taso; ");
INSERT INTO gri_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na Bokisi na Taso i tana ara ka totu kaira ruka na pavavatu, ma na gai na mani kalagaiginiana, ma na vovongona; ");
INSERT INTO gri_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na bela gana na molo bredi ma na vangana sui; ma na bredi ara sauvania God; ");
INSERT INTO gri_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na gai na mani molo dato bilona bulu iruiru ara aqosiginia na qolumila laka, na bilona, me pipi sui na vangana, ma na bulu gana na bilo; ");
INSERT INTO gri_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ma na belatabu qolumila gana na kodo buluna gai iruiru sisigini dou; na oela tabu gana na nina omea, na bulunagai uruuru sisigini dou; na polokatsi gana na matsapana na Valepolo; ");
INSERT INTO gri_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na belatabu tapalamila ma na didilana lake tapalamila, ma na gai na kalagaiginiana, me pipi sui na vangana; ma na popo na vulivuli kolu tototona; ");
INSERT INTO gri_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na polokatsi gana na bara poliana na pakokana ma na tuguruna ma na tototoqira; na polokatsi gana na matsapana na bara kolu itaina; na gai tetelo gana na sori itaina na Valepolo; me pipi sui lakalaka na vangana gana na gini aqo i laona na Valepolo; ");
INSERT INTO gri_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","migira na pologira tabu rerei dou sosongo a Aaron mitugira na dalena kara tu sagelia kalina kara tu naua tu niqira aqo i laona na Nauna Tabu. ");
INSERT INTO gri_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Igira na tinoni ni Israel ara nausuinogoa pipi sui na aqo vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ma Moses e vilekegira pipi sui na omea, me reia laka ara aqosigira saikesa nogo vaga na Taovia e ketsaligira. Mi tana ma Moses e tabugira. ");
INSERT INTO gri_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tana kesanina dani i laona na kesanina vula ko vaturikaea na Valepolo i tana ke totu na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ko molosagea i laona na Valepolo na Bokisi na Taso tana e totu na Sangavulu Ketsa mo ko tsauraginia na polokatsi i matana. ");
INSERT INTO gri_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ko adisagea na bela na molo bredi, mo ko moloa na vangana i konina. Ko adisagegotoa na gaina na mani molodato bilona bulu iruiru, mo ko molo bâ na bilona i konina. ");
INSERT INTO gri_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ko moloa na belatabu qolumila gana na kodo bulunagai uruuru i matana na Bokisi na Taso mo ko tsauraginia na polokatsi tana matsapana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ko moloa i matana na Valepolo na belatabu gana na savori-kodoputsa. ");
INSERT INTO gri_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ko moloa na popo na vulivuli i ka qaqira levuga kaira na Valepolo ma na belatabu mo ko dangaliginia na kô. ");
INSERT INTO gri_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ko turuvaginia na bara polipolia na pakokana mo ko tsauraginia na polokatsi tana matsapana. ");
INSERT INTO gri_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Mi muri, migoe ko tabua na Valepolo me pipi sui na vangana tana ninaginiana na oela tabu, me sauba ke tabu. ");
INSERT INTO gri_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mi muri, mo ko tabua na belatabu me pipi sui na vangana tana ninaginiana na oela tabu, me sauba ke tabu saikesa. ");
INSERT INTO gri_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ko tabu vaganana goto ia na popo na vulivuli kolu tototona. ");
INSERT INTO gri_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ko adimaia a Aaron mi tugira na dalena mane tana matana na Valepolo mo ko tsarivanitugira kara tu lesomale dou. ");
INSERT INTO gri_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ko sagelivania a Aaron na polo na manetabu, mo ko ninaginia na oela tabu, mi tana nauvaganana ia igoe ko tabua rongona ke gini ulagana na aqo vaniaqu inau vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ko adimaitugira goto na dalena mo ko sagelivanitugira tu gaqira sote. ");
INSERT INTO gri_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ko ninaginitugira goto na oela tabu vaga o ninagininogoa tu tamaqira rongona ke gini ulagaqira na aqo vaniaqu inau vaga na manetabu. Na ninaginiaqira na oela tabu iani sauba ke naua ma kara lia na manetabu tana tagu sui ke mai.” ");
INSERT INTO gri_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ma Moses e naua pipi sui na omea vaga saikesa nogo e ketsaliginia na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Me vaga ia, mi tana kesanina dani i laona na kesanina vula tana rukanina ngalitupa murina kalina ara mololea i Ejipt, igira ara vaturikaea na Valepolo tana ke totu na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ma Moses e molo bâ na tototona, me vaturikaegira na pava damadama, me soribagira na qaroqarona, me vaturikaegira na tuguruna. ");
INSERT INTO gri_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Maia e vuresia bâ na tsatsavuna na Valepolo, me molo bâ goto na tsatsavuna ni taba, vaga saikesa nogo e ketsaliginia na Taovia. ");
INSERT INTO gri_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Mi muri, maia e adikaira ruka na pavavatu me molosage ba kaira i laona na Bokisi na Taso. Me tsukulaginisage kaira na gai na kalagaiginiana i laona na ringi tana Bokisi na Taso me molo bâ na vovongona i konina. ");
INSERT INTO gri_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Mi muri, maia e molosagea na bokisi i laona na Valepolo, me tsauragini bâ na polokatsi i matana. Mi tana nauvaganana ia aia e popoisiginia na Bokisi na Taso vaga nogo na Taovia e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Maia e molosagea na bela na molo bredi i laona na Valepolo, i tabana i vava tabana mai na polokatsi e poisia na Bokisi na Taso, ");
INSERT INTO gri_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","me moloa i kelana na bela ia na bredi ara sauvania na Taovia, vaga nogo na Taovia e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Me mologotoa na gai na molodato bilona bulu iruiru i laona na Valepolo, tabana i ata gana ngongo tana e totu na bela na molo bredi ");
INSERT INTO gri_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","mi tana nogo i matana na Taovia aia e tungigira na bulu iruiru vaga nogo na Taovia e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Aia e molosagegotoa na belatabu qolumila i laona na Valepolo i matana na polokatsi ara tsauraginia, ");
INSERT INTO gri_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","me kodogira na bulunagai uruuru vaga nogo na Taovia e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mi muri maia e tsauraginia na polokatsi tana matsapana na Valepolo, ");
INSERT INTO gri_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","mi tana i matana na polokatsi gana na matsapana na Valepolo ia, aia e moloa na belatabu gana na savori-kodoputsa. Mi kelana na belatabu ia aia e savoria na savori-kodokodo ma na sausau na uiti vaga nogo na Taovia e ketsaliginia. ");
INSERT INTO gri_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Aia e moloa na popo na vulivuli ka gaqira levuga na Valepolo ma na belatabu, me dangaliginia na kô. ");
INSERT INTO gri_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ma Moses, ma Aaron, mi tugira na dalena ara tu vulia tu limaqira ma tu tuaqira i laona na popo ia ");
INSERT INTO gri_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","pipi kalina ara tu sagemai i laona na Valepolo se ara tu vano tana belatabu, vaga nogo na Taovia e ketsaliginigira. ");
INSERT INTO gri_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ma Moses e vaturikaea na bara polipolia na pakokana na Valepolo ma na belatabu, me tsauraginia na polokatsi tana matsapana na bara. Mi tana, aia e suilavagini saikesalia pipi sui na aqo. ");
INSERT INTO gri_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mi muri, ma na parako e tsunamai me tsavu poponoa na Valepolo ma na mararana angaanga na Taovia e mararasi poponoa. ");
INSERT INTO gri_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Me rongona na parako e tsavu poponoa tana nauna ia, te a Moses e tau tangomana ke sagebâ i laona na Valepolo. ");
INSERT INTO gri_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mi kalina moa na parako ke datoligi tania na Valepolo, ti igira na tinoni ni Israel kara vutia niqira valepolo, ma kara ratsuvano kesa tana nauna segeni. ");
INSERT INTO gri_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mi tana tagu popono e totu na parako ia i kelana na Valepolo, igira ara totu moa i tana mara tau goto aligiri na vavano. ");
INSERT INTO gri_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tana tagu popono ara liubamai i laona na kaomate ara reia na parakona na Taovia i kelana na Valepolo tana dani, ma na lapina lake e iruiru tana bongi.");
INSERT INTO gri_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Na Taovia aia e totu i laona na Valepolo Tabu e soâ a Moses me tsarivania: ");
INSERT INTO gri_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Ko tsarivanigira na tinoni ni Israel laka niqira aqo kara muritaonia na ketsa girani kalina kara tû na savori-kodoputsa vaniana na Taovia. “Kalina ti vaga ke kesa ke ngaoa na gini savori-kodoputsa kesa nina omea tuavati, ma nina aqo ke adimaia kesa nina buluka, se kesa nina sipi se kesa nina naniqoti. ");
INSERT INTO gri_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Me ti vaga aia ke ngaoa na gini savori-kodokodo kesa nina buluka ma nina aqo ke adimaia kesa na buluka mane me ke tau seko sa tabana konina. Me ke saua i matana na Valepolo i tana e totu na Taovia, rongona na Taovia ke tabea. ");
INSERT INTO gri_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ma nina aqo na mane ia ke moloa na limana i lovana nina buluka, maia God sauba ke tabea vaga na kodoputsa gana na mani veoligiana nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Mi tana nogo aia ke labumatesia nina buluka, migira na manetabu tana duli konina a Aaron kara adia na gabuna ma kara sauvania na Taovia, mi muri ma kara qetu bâ pipi tana vati liligina na belatabu aia e totu i matana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Mi muri, ma na mane ia ke paloligia na kokorana nina buluka me ke paria, ");
INSERT INTO gri_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","migira na manetabu kara vangaraua na lake i kelana na belatabu ma kara tungia. ");
INSERT INTO gri_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ma kara mologira na paparina na buluka tana lake kolu lovana ma na seregana. ");
INSERT INTO gri_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ma nina aqo goto na tamanina buluka ke vulimalegira na vangalevona mi kaira na aranimuri, me sui ia, maia na manetabu aia e tangolia na aqona na kodoputsa tana dani ia, ke kodo poponogira i kelana na belatabu. Ma na vuruna na omea ara savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Me ti vaga na mane ia ke ngaoa na gini savori kesa nina sipi se kesa nina naniqoti, ma nina aqo ke vilia na manena me ke tau moa seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ke labumatesia i liligina na belatabu, tabana i vava, migira na manetabu kara qetu bâ na gabuna tana vati liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Mi kalina na mane ia ke parisuia, maia na manetabu aia e tangolia na aqona na kodoputsa tana dani ia ke mologira sui na paparina tana lake kolu lovana ma na seregana. ");
INSERT INTO gri_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ma nina aqo goto na tamanina ke vulimalegira na vangalevona mi kaira na aranimuri, maia na manetabu ke saugira vania na Taovia me ke kodo poponogira i kelana na belatabu. Ma na vuruna na omea ara savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Me ti vaga na mane ia ke ngaoa na gini savori-kodoputsa kesa na manu, maia nina aqo ke adia na kulukulu se na kurau. ");
INSERT INTO gri_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ma na manetabu ke adi bâ na manu tana belatabu me ke birukutia na liona, me ke kodoa na lovana tana belatabu, ma na gabuna ke moloa ke roro tsuna tana liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ke pariligia na todo tana liona kolua na vangana i laona, me ke tsonibagira tana tora ara totu ligisana na belatabu tabana i longa. ");
INSERT INTO gri_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Mi muri maia ke tangolikaira na rapona me ke sasia na konina, me ke laka moa na tasasiligiana na rapona, mi muri me ke kodo poponoa tana belatabu. Ma na vuruna na omea ara savori vaganana ia e punâ na Taovia me gini laona sosongo.” ");
INSERT INTO gri_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Na Taovia e ketsalia a Moses ke tsarivanganana iani vanigira na tinoni ni Israel: “Mi kalina ti vaga ke kesa ke ngaoa na gini savori vaniana na Taovia kesa nina sausau na uiti, ma nina aqo ke giria talu me ke maripu vaga na pulaoa. Me ke molo bâ na oela na olive ma na bulunagai uruuru i konina, ");
INSERT INTO gri_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","me ke adi bâ vanigira na manetabu tana duli konina a Aaron. Maia na manetabu aia e tangolia na aqona na kodoputsa tana dani ia, ke adia kesa na kakarona na pulaoa ma na oela, ma na bulunagai uruuru popono, me ke kodogira tana belatabu, ngiti papadana laka ara savorigira sui popono nogo vania na Taovia. Ma na vuruna na omea ara savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ma na tsarana na sausau na uiti ia kara aditamaniqira igira na manetabu; me gini lia na omea tabu loki sosongo rongona e talu tana vangana na mutsa ara sauvania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Me ti vaga kamu ngaoa na savoriana na sivona bredi bibiti, me ke laka na totu na isti i konina. Me dou moa kamu adimaigira na sivona matolu amu aqosiginigira na pulaoa lalo koluginia na oela na olive, se na biskete amu saluvaginigira na uela na olive. ");
INSERT INTO gri_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Me ti vaga kamu ngaoa na savoriana na bredi amu magovosia tana tapala tapetape, ma nimui aqo kamu aqosiginia na pulaoa lalo koluginia na oela na olive me ke tagara na isti i konina. ");
INSERT INTO gri_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ma kamu gurâ, ma kamu qetutsavua na oela i konina kalina moa kamu tû na gini savori. ");
INSERT INTO gri_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Me ti vaga kamu ngaoa na savoriana na bredi amu paraepania, kamu aqosiginia na pulaoa lalo koluginia na oela na olive. ");
INSERT INTO gri_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kamu adimaia ngiti nimui savori vania na Taovia, ma kamu sauvanitalua na manetabu, maia ke adivanoa tana belatabu. ");
INSERT INTO gri_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Maia sauba ke adia na turina ngiti papadana laka amu savori popononogoa vania na Taovia, me ke ba kodoa tana belatabu. Ma na vuruna na omea amu savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ma na tsarana na sausau ia gaqira nogo igira na manetabu; me gini lia na omea tabu loki sosongo rongona e talu tana vangana na mutsa amu sauvania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Pipi sui na sausau na uiti amu gini savori vania na Taovia i kelana na belatabu ke laka na totu sa isti i konina; e tabu saikesa na lalo koluginiana na isti se na bulumitsua sa mutsa amu gini savori vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mi tana savoriana na bredi amu aqosiginia na uiti amu pitsugira tana kesanina pipitsu pipi ngalitupa, e dou moa ti kamu lalo koluginia na isti se na bulumitsua, ma kamu laka moa na kodoana i kelana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kamu molo solo i koniqira pipi sui na sausau na uiti, rongona na solo aia nogo na papadana na vaitasogi God e naukolugamu. Nimui aqo ti kamu molo solona i koniqira pipi sui na omea amu gini savori. ");
INSERT INTO gri_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Mi kalina ti kamu tû na adivaniana na Taovia na sausau na kesanina uiti amu pitsugira, kamu giritalua se kamu kodogira ti kamu saua. ");
INSERT INTO gri_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ma kamu moloa na oela na olive ma na bulunagai uruuru i konina. ");
INSERT INTO gri_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Maia na manetabu sauba ke kodoa na turina na uiti ma na oela kolua na bulunagai uruuru popono ngiti papadana laka na amu savori poponoa vania na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Na Taovia e ketsalia a Moses ke tsarivaganana iani vanigira na tinoni ni Israel: “Mi kalina ti vaga ke kesa ke ngaoa na savoriana kesa nina buluka vaga na sausau tangomana na tinoni kara ganipatâ na turina, maia e dou moa ti ke saua na manena se na dakina, me ke tau moa seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ma na tinoni ia ke molo bâ na limana tana lovana nina buluka me ke labumatesia i matana na Valepolo i tana e totu na Taovia. Migira na manetabu tana duli konina a Aaron kara adia na gabuna ma kara qetu bâ pipi tana vati liligina na belatabu, ");
INSERT INTO gri_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ma kara gini savori-kodokodo vania na Taovia na turina vaga girani: pipi sui na seregana e tsavua na vangalevona, ");
INSERT INTO gri_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kaira na piuna ni laona kolu seregana, ma na turina dou bâ na atena. ");
INSERT INTO gri_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Migira na manetabu kara kodogira sui na omea girani tana belatabu i kelana na vangana na savori-kodokodo. Ma na vuruna na omea ara savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Me ti vaga ke kesa ke gini aqo na sipi se na naniqoti kesa tana nauana na sausau tangomana na tinoni kara ganipatâ na turina, me dou moa ti na manena se na dakina, me ke tau moa seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Me ti vaga ke kesa ke ngaoa na gini savori kesa nina sipi, ");
INSERT INTO gri_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ma nina aqo ke molo bâ na limana tana lovana me ke labumatesia i matana na Valepolo. Migira na manetabu kara adia na gabuna ma kara qetu bâ pipi tana vati liligina na belatabu, ");
INSERT INTO gri_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ma kara gini savori-kodokodo vania na Taovia na turina vaga girani: na seregana, ma na kalina popono ara putsikutia varangisia na sulina gotuna, me pipi sui goto na seregana ara tsavua na vangalevona, ");
INSERT INTO gri_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","mi kaira na piuna ni laona kolu seregana, ma na turina dou bâ na atena. ");
INSERT INTO gri_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ma na manetabu aia e tangolia na aqona na kodoputsa tana dani ia, ke ba kodogira na omea sui popono girani tana belatabu ngiti savori-kodokodo vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Me ti vaga ke kesa ke ngaoa na gini savori-kodoputsa nina naniqoti, ");
INSERT INTO gri_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","maia nina aqo ke molobatalua na limana tana lovana nina naniqoti, mi muri me ke ba labumatesia i matana na Valepolo. Migira na manetabu kara adia na gabuna, ma kara qetu bâ pipi tana vati liligina na belatabu, ");
INSERT INTO gri_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","mi muri ma kara gini savori-kodokodo vania na Taovia na turina vaga girani: na seregana popono e tsavua na vangalevona, ");
INSERT INTO gri_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","mi kaira na piuna ni laona kolu seregana, ma na turina dou bâ na atena. ");
INSERT INTO gri_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Maia na manetabu ke kodogira sui na omea girani i kelana na belatabu, ngiti savori-kodokodo vaga e sigini ngaoa na Taovia. Igira sui lakalaka na seregana e tamanina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ke laka goto ke kesa na tinoni ni Israel na ganiana sa serega se na gabuna; iani nogo e kesa na ketsa niqira aqo kara muri kalavatavia na dani ma na dani igira sui popono na tinoni ni Israel atsa moa ti iava kara totu.” ");
INSERT INTO gri_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Na Taovia e ketsalia a Moses, ");
INSERT INTO gri_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ko bâ mo ko tsarivanigira na toga ni Israel laka ti vaga ke kesa ke tavongani tsukia sa sasi, se ke gini kutsia sa vidaqira nina ketsa na Taovia kalina aia e tau pada mananâ na nauana, ma nina aqo ke murigira na vovorona na ketsa vaga girani. ");
INSERT INTO gri_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Ti aia na Mane Tabu Loki segeni nogo e sasi ma na vangamana e gado i koniqira na toga sui, ma nina aqo ia ke saua kesa na buluka mane vaolu me ke tau seko sa tabana konina, me ke gini kodoputsa vania na Taovia na matena nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Maia ke adi bâ na buluka ia i matana na Valepolo, me ke moloa na limana tana lovana, me ke labumatesia i tana i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mi muri, maia na Mane Tabu Loki ke adia na turina na gabuna na buluka ia me ke sage kolua i laona na Valepolo. ");
INSERT INTO gri_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Mi tana ke lumitsuna na kakauna tana gabu me ke tsirikagini bâ ke vitu kalina i matana na polokatsi e tsautsau i matana na Nauna Tabu Loki. ");
INSERT INTO gri_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Me ke saluvaginitugira na gai ara katsadato vati tana tsukena na belatabu e totu i laona na Valepolo i tana ara kodoa na bulunagai uruuru. Ma na tsarana na gabu ke qetu bâ i tuana na belatabu aia e totu i tano i matana na Valepolo, i tana ara savori-kodoputsa. ");
INSERT INTO gri_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Me ke adia na seregana popono na buluka mane ia, na seregana ara tsavua na vangalevona, ");
INSERT INTO gri_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","mi kaira na piuna ni laona kolu seregana, ma na turina dou bâ na atena. ");
INSERT INTO gri_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ma na manetabu ke adia na seregana sui iani me ke kodoa tana belatabu i tana ara savori-kodokodo, vaga nogo aia e naua kalina e kodoa na seregana na omea tuavati ara savoria gana na sausau tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Me ke adigira na kokorana, ma na velesina popono, ma na lovana, ma na tuana, ma na vangalevona kolu tinaena, ");
INSERT INTO gri_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","me ke adirutsumigira sui tania na vera kesa tana nauna ara balonogoa agana na tsoniana na torana na kodoputsa, mi tana nogo ke ba kodogira. Iani nogo e vaga na savori-kodoputsa matena nina sasi segeni na Mane Tabu Loki. ");
INSERT INTO gri_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Me ti vaga igira na toga popono ni Israel kara tavongani tsukia sa sasi mara gini kutsia kesa nina ketsa na Taovia kalina ara tau pada mananâ na nauana, ");
INSERT INTO gri_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","mi kalina tsotsodo ara vasini reigadovia laka ara sasi, mi tana igira na saikolu popono kara tû, ma kara adia kesa na buluka mane vaolu ngiti sausau matena niqira sasi. Kara adi bâ i matana na Valepolo i tana e totu na Taovia; ");
INSERT INTO gri_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","migira na ida sui tana saikolu kara moloa na limaqira tana lovana, ma kara labumatesinogoa i tana. ");
INSERT INTO gri_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Maia na Mane Tabu Loki ke adia na turina na gabuna na buluka ia me ke sage kolua i laona na Valepolo, ");
INSERT INTO gri_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","mi tana ke lumia na kakauna tana gabu me ke tsirikagini bâ ke vitu kalina i matana na polokatsi. ");
INSERT INTO gri_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Me ke saluvaginitugira na gai ara katsadato vati tana tsukena na belatabu aia e totu i laona na Valepolo i tana ara kodoa na bulunagai uruuru. ");
INSERT INTO gri_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mi muri, me ke ba kodogira pipi sui na seregana tana belatabu. ");
INSERT INTO gri_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Me ke nauvanigotoa na buluka iani na omea atsa vaga aia e nauvania na buluka e gini savori na matena nina sasi segeni, mi tana nauvaganana ia, maia sauba ke tsonimatena niqira sasi na toga, me sauba God ke padalea niqira sasi. ");
INSERT INTO gri_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Mi muri, maia ke adivanoa na buluka ia i taba i tano tania na vera me ke ba kodoa vaga nogo aia e kodoa na buluka e gini savori matena nina sasi segeni nogo ia. Iani nogo e vaga na savori-kodoputsa matena niqira sasi na saikolu popono. ");
INSERT INTO gri_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Me ti vaga ia ke kesa na mane tagao ke tavongani tsukia sa sasi me ke gini kutsia kesa nina ketsa na Taovia, maia e tau pada mananâ na nauana, ");
INSERT INTO gri_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","mi kalina tsotsodo kara tsarivania laka aia e sasi, maia nina aqo ke adimaia kesa na naniqoti mane me ke tau goto seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Me ke molo bâ na limana tana lovana me ke ba labumatesia liligina na belatabu, tabana i vava, i tana ara matesigira na omea tuavati gana na savori-kodokodo. Iani nogo e vaga na sausau agana na sese matena nina sasi na mane tagao. ");
INSERT INTO gri_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ma na manetabu nina aqo ke lumia na kakauna tana gabuna na naniqoti ia, me ke ba saluvâ tana gai ara katsadato vati tana tsukena na belatabu, me ke qetu bâ na turina i tuana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mi muri, maia ke kodogira sui na seregana i kelana na belatabu, vaga nogo aia e naua kalina e kodoa na seregana na omea tuavati tana sausau tangomana na tinoni kara ganipatâ na turina. Nina aqo nogo na manetabu ke nauvaganana ia kalina aia ke savori-kodoputsa matena nina sasi na taovia tagao vera, maia God sauba ke padalea nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Me ti vaga ke kesa tinoni lê moa ke tavongani tsukia sa sasi me ke gini kutsia kesa nina ketsa na Taovia kalina aia ke tau pada mananâ na nauana, ");
INSERT INTO gri_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","mi kalina tsotsodo ara tsarivania laka aia e sasi, maia nina aqo ke adimaia ngiti sausau kesa na naniqoti daki me ke tau goto seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Me ke molo bâ na limana tana lovana me ke ba labumatesia liligina na belatabu, tabana i vava i tana nogo ara matesigira sailagi na omea tuavati gana na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ma na manetabu ke lumia na kakauna tana gabuna na naniqoti ia, me ke ba saluvâ tana gai ara katsadato vati tana tsukena na belatabu, me ke qetu bâ na turina i tuana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mi muri, maia ke pariligia sui na seregana, vaga nogo ara nauvanigira na omea tuavati ara matesigira kalina ara savoria na sausau tangomana na tinoni kara ganipatâ na turina, mi muri maia ke ba kodoa tana belatabu rongona na vuruna ke punâ na Taovia me ke gini laona sosongo. Nina aqo nogo na manetabu ke nauvaganana ia kalina ke naua na savori-kodoputsa matena nina sasi na mane ia, me sauba God ke padalea nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Me ti vaga ke kesa ke adimaia kesa nina sipi gana na sausau matena nina sasi, maia nina aqo ke adimaia na dakina, me ke tau goto seko sa tabana konina. ");
INSERT INTO gri_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Maia ke moloa na limana tana lovana me ke labumatesia liligina na belatabu tabana i vava, i tana nogo ara labugira sailagi na omea tuavati gana na savori-kodoputsa. ");
INSERT INTO gri_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ma na manetabu ke lumia na kakauna tana gabuna na sipi ia, me ke saluva bâ tana gai ara katsadato vati tana tsukena na belatabu, me ke qetu bâ na turina i tuana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Mi muri, me ke pariligia na seregana popono, vaga nogo ara nauvanigira na sipi ara labugira kalina ara savoria na sausau tangomana na tinoni kara ganipatâ na turina, mi muri, maia ke bâ kodoa i kelana na belatabu kolugira sui na vangana na kodoputsa ara gini savori vania na Taovia. Nina aqo nogo na manetabu ke nauvaganana ia kalina ke naua na savori-kodoputsa matena nina sasi na mane ia, me sauba God ke padalea nina sasi.” ");
INSERT INTO gri_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ma na Taovia e tsarigotoa vaganana iani, “Ti vaga ke kesa kara vailivua ke ba goko tana pede rongona na omea aia e donaginia, maia ke sove na tsarivulagiana na omea e reia se e rongomia, maia e sasi i matana God me sauba ke gadovikedena. ");
INSERT INTO gri_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Me ti vaga ke kesa ke tau pada mananâ na nauana me ke ba pelea kesa na omea e tau masidi tana vovorona na lotu, vaga na omea tuavati mate, maia e kaulinaqu me tsutsukibo kalina tsotsodo aia e reigadovia na omea e naua. ");
INSERT INTO gri_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Me ti vaga ke kesa ke tau pada mananâ na nauana me ke ba pelea kesa na omea naqu e talu tana konina tinoni, atsa moa na omea koegua ia, maia e tsutsukibo kalina tsotsodo e reigadovia na omea e naua. ");
INSERT INTO gri_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Me ti vaga ke kesa ke vatsakoba moa me atsa moa ti na omea koegua moa e vatsa kalea, maia e tsutsukibo nogo kalina tsotsodo aia e reigadovia na omea e naua. ");
INSERT INTO gri_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Me ti vaga kesa tinoni ke tsutsukibo, ma nina aqo ke katevulagia nina sasi, ");
INSERT INTO gri_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","me ngiti sese matena nina sasi nina aqo ke adimai vania na Taovia kesa na sipi se na naniqoti daki gana na sausau matena nina sasi. Ma na manetabu sauba ke gini savori-kodoputsa matena nina sasi na tinoni ia. ");
INSERT INTO gri_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Me ti vaga ke kesa ke utugana vania na sauana na sipi se na naniqoti, maia nina aqo ke adimaivania na Taovia ngiti sese matena nina sasi ke ruka moa na kulukulu se ke ruka na kurau, kesa agana na sausau na sese matena nina sasi, me kesa agana na mani savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Maia nina aqo ke adigira mai vania na manetabu, maia na manetabu ke ida ke savoritalua na manu agana na sausau matena na sasi. Ke birua na liona me ke tau moa kutivota, ");
INSERT INTO gri_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","me ke tsirikagini bâ na turina na gabuna tana liligina na belatabu. Ma na tsarana na gabuna ke qetu bâ i tuana na belatabu. Aia nogo e vaga na savori-sausau matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Mi muri, maia ke savoria na rukanina manu agana na savori-kodokodo, muri taonia na vovorona na omea ara pedea. Nina aqo nogo na manetabu ke nauvaganana ia kalina ke savori-kodoputsa matena nina sasi na tinoni ia, me sauba God ke padale vania nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Me ti vaga ke kesa ke utugana vania na tsodoana ke ruka na kulukulu se ke ruka na kurau, ma nina aqo ke adimaia ke kesa moa kilo na pulaoa agana na savori-sausau na sese matena nina sasi. Me ke laka moa na moloana na oela na olive, se na bulunagai uruuru i konina, rongona aia na savori-sausau matena na sasi, me tau na sausau na uiti. ");
INSERT INTO gri_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Aia ke adi bâ vania na manetabu na pulaoa, maia na manetabu ke adia kesa na kakarona ngiti papadana laka aia e saugira popono sui vania na Taovia, maia ke kodoa i kelana na belatabu vaga na sausau na mutsa. Aia nogo e vaga na savori-sausau matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nina aqo nogo na manetabu ke nauvaganana ia kalina ke savori-kodoputsa matena nina sasi na tinoni ia, me sauba God ke padale vania nina sasi. Ma na tsarana na pulaoa ke tamanina na manetabu, vaga nogo aia e naua tana sausau na uiti.” ");
INSERT INTO gri_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ma na Taovia e sauvanigotoa a Moses na vovorona na ketsa girani: ");
INSERT INTO gri_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ti vaga ke kesa aia ke tau pada mananâ na nauana, me ke padalea na sauana vania na Taovia na omea nina aqo ke saua, maia e sasi ma nina aqo ke adimaia kesa na sipi se kesa na naniqoti mane me ke tau goto seko sa tabana konina, ngiti nina sausau na volivisu vaniana na Taovia. Ma na matena ke tsonia ke muri taoninogoa na omea ara pedea tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Nina aqo ke ponotivisua na matena popono me ke paboginigotoa rukapatu i kelana pipi kesa sangatu. Me ke sauvania na manetabu, maia na manetabu ke gini savori-kodoputsa na omea tuavati na matena nina sasi na mane ia, me sauba God ke padale vania nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Me ti vaga ke kesa ke tau pada mananâ na nauana me ke tavongani tsukia na sasi, me ke gini kutsia kesa vidaqira nina ketsa na Taovia, ma na tinoni vaga ia e tsutsukibo manana ma nina aqo ke sese matena. ");
INSERT INTO gri_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ke adivano vania na manetabu ngiti sese matena nina sasi ke kesa na sipi se na naniqoti mane me ke tau goto seko sa tabana konina. Ma na matena ke tsonia ke muritaoninogoa na omea ara pedea tana tagu ia. Maia na manetabu ke savori-kodoputsa matena nina sasi na mane ia, me sauba God ke padale vania nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aia nogo e vaga na aqona na sausau na volivisu matena nina sasi aia e sasi i matana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ma na Taovia e sauvanigotoa a Moses na vovorona na ketsa girani: ");
INSERT INTO gri_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ti vaga ke kesa ke sove na tusuvisu vaniana kesa gana verakolu na Israel nina qolo segeni na mane ia e sauvania ke reitutugu vania moa, se ke komia kesa nina omea, se ke peqoa, ");
INSERT INTO gri_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","se ke gini pero tana rongona nina omea kesa tinoni e nangali oka nogoa, maia e ba tsodoa me gini vatsa laka e tau reia, ma na tinoni e nauvaganana ia e sasi. ");
INSERT INTO gri_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Mi kalina ti kesa tinoni ke gini loaga na sasi vaga girani, ma nina aqo ke tuguvisua na omea aia e adia tana komi, se na peqo, se tana vatsa pero. Mi tana dani nogo ara tsodovulagia laka aia e tsutsukibo, ma nina aqo ke volivisu popono vania na tamanina, me ke paboginigotoa rukapatu i kelana pipi kesa sangatu. ");
INSERT INTO gri_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Me ke adi bâ vania na manetabu ngiti sese matena nina sasi ke kesa na sipi se na naniqoti mane me ke tau goto seko sa tabana konina. Ma na matena ke tsonia ke muri taoninogoa na omea ara pedea tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Maia na manetabu ke gini savori-kodoputsa nina omea tuavati na mane ia na matena nina sasi me sauba God ke padale vania nina sasi.” ");
INSERT INTO gri_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ma na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","ke tsarivanitugira a Aaron ma na dalena na vovorona na ketsa girani e kalegira na vatana na savori ara kodo poponoa: “Igira na omea ara gini savori-kodokodo kara moloa ke totu na bongi popono i kelana na belatabu, ma na lake ke gagâ saviliu. ");
INSERT INTO gri_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mi muri, ma na manetabu ke sagelia nina polokatsi vovosi laka, ma na polo ni laona, me ke ba saroligia na tora e totu tana belatabu me ke molotsunâ liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Mi muri, maia ke ba oli polona, me ke adia na tora, me ke ba tsonia i taba tania na vera kesa tana nauna ara balonogoa agana na tsoniana na torana na vangana na kodoputsa. ");
INSERT INTO gri_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ma na lake tana belatabu ke gagâ saviliu moa me ke tau goto mate. Me pipi tana matsaraka aia na manetabu nina aqo ke pabo lakena me ke mologira na vangana na savori-kodokodo i kelana, me ke kodogira na seregana ara talu tana sausau tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ma na lake nina aqo nomoa ke iruiru saviliu tana belatabu, me ke tau goto mate.” ");
INSERT INTO gri_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ma na Taovia e tsarigotoa: “Igirani nogo na ketsa e kalegira na sausau na uiti. Nina aqo nogo kesa na manetabu tana puku konina a Aaron ke savorivania na Taovia na sausau na uiti i matana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Maia ke tû me ke adia kesa na kakarona na pulaoa ma na oela, ma na bulunagai uruuru e totu i konina, me ke kodogira tana belatabu vaga na papadana laka ara savorigira sui popono vania na Taovia. Ma na vuruna na omea ara gini savori vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Migira na manetabu kara gania na tsarana. Kara aqosiginia na bredi tagara isti konina, ma kara ba gania kesa tana nauna tabu tana pakokana na Valepolo i tana e totu na Taovia. Na Taovia nogo e sauvanigira na manetabu ngiti gaqira tuva tana turina na mutsa ara gini savori vania. Ma na mutsa iani e tabu loki sosongo, vaga nogo igira na savori-sausau matena na sasi, ma na sausau na volivisu. ");
INSERT INTO gri_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mi tana tagu sui ke mai, migira moa na kukuana a Aaron tangomana kara gania na mutsa ia ngiti gaqira tuva kalavata tana mutsa ara sauvania na Taovia. Ma na omea gua moa ti ke pelea na mutsa vaga ia maia sauba ke lia goto na omea tabu.” ");
INSERT INTO gri_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ma na Taovia e sauvanigotoa a Moses na vovorona na ketsa iani, ");
INSERT INTO gri_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","tana rongona na tabuana kesa na manetabu tana puku konina a Aaron: “Tana dani nogo ara tabua, ma nina aqo aia ke sauvania na Taovia ngiti savori kesa na kilo na pulaoa ke vaga nogo na dangana ara saua pipi dani tana sausau na uiti, ke kesa turina tana matsaraka, me ke kesa turina tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ke lalo koluginia na oela me ke magovosia tana tapala tapetape, mi muri me ke gurâ, me ke gini savori vania na Taovia ngiti sausau na uiti, ma na vuruna ke punâ na Taovia me ke gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mi tana tagu sui ke mai, me pipi sui na kukuana a Aaron, igira ara tangolia na aqo Mane Tabu Loki, niqira aqo nogo kara savoria na sausau vaga iani. Nina aqo ke kodogira sui saikesa ngiti savori-kodokodo vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Me pipi sui na sausau na uiti e naua na manetabu nina aqo ke kodogira sui saikesa, me vali goto na ganiana sa turina.” ");
INSERT INTO gri_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ma na Taovia e moloketsa vania a Moses ");
INSERT INTO gri_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","ke sauvanitugira a Aaron ma na dalena na vovorona na ketsa girani tana rongona na savori-sausau matena na sasi: “Na omea tuavati gana na savori-sausau matena na sasi kara labumatesia liligina na belatabu, tabana i vava, i tana nogo ara labugira sailagi na omea tuavati agana na savori-kodokodo. Na savori iani aia na sausau tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ma na manetabu aia e savoria na omea tuavati ia, ke gania na lakana kesa tana nauna tabu tana pakokana nogo na Valepolo i tana e totu na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Me ti vaga sa tinoni se sa omea moa ke pelea na velesina na omea tuavati ia, maia sauba ke lia na omea tabu. Me ti vaga na gabuna na omea tuavati ia ke tsiriki bâ i konina sa polo, ma niqira aqo kara ba tsagimalea kesa tana nauna tabu. ");
INSERT INTO gri_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Me pipi sui moa na popo vatu ara kukiginia na velesina na omea tuavati niqira aqo kara tairutua kalina ke sui na gini aqo, me ti vaga na popo tapala kara gini aqo, ma niqira aqo kara gitsi maledoua ma kara vulia tana kô. ");
INSERT INTO gri_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Migira moa na mane tana duli konina a Aaron e tangomana vanigira kara gania na savori-sausau iani; rongona aia e tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Me ti vaga na turina na gabuna na omea tuavati ia kara adisagea i laona na Valepolo, ma kara gini aqo tana vovorona na suisui matena na sasi, me tabu saikesa vanigira na manetabu na ganiana na lakana; niqira aqo kara kodo poponoa.” ");
INSERT INTO gri_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Igirani na ketsa e kalegira na sausau na volivisu aia na Taovia e tsarivania a Moses: “Migirani nogo na vovorona gana na sausau na volivisu, ma na sausau girani ara tabu loki sosongo: ");
INSERT INTO gri_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Igira na omea tuavati agana na sausau na volivisu kara labumatesia liligina na belatabu tabana i vava, i tana nogo ara labugira sailagi na omea tuavati gana na savori-kodokodo, ma na gabuna kara qetu bâ vati tana liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Kara adiligia na seregana popono ma kara gini savoria tana belatabu: na kalina serega, ma na seregana e tsavua na vangalevona, ");
INSERT INTO gri_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mi kaira ruka na piuna ni laona kolu seregana, ma na turina dou bâ na atena. ");
INSERT INTO gri_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Na manetabu ke ba kodogira tana belatabu vaga na sausau na mutsa vania na Taovia. Aia nogoria e vaga na aqona na sausau na volivisu matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Migira moa na mane tana vungu manetabu tangomana kara gania na savori-kodoputsa iani, ma kara ba gania kesa tana nauna tabu, rongona na mutsa vaga ia e tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Me kesa moa atsa na vovorona na ketsa e kalekaira na savori-sausau matena na sasi, ma na sausau na volivisu: na velesina, gana tuva nogo na manetabu aia e naua na savori-kodoputsa ia. ");
INSERT INTO gri_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Maia goto na kokorana na omea tuavati ara gini savori-kodokodo e tamanina na manetabu aia e naua na savori-kodoputsa ia. ");
INSERT INTO gri_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Pipi sui na sausau na uiti ara bitigira tana umu, se ara magovosigira tana tapala tapetape, se ara paraepanigira, igira sui e tamanina nogo aia na manetabu e savorigira vania God. ");
INSERT INTO gri_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Me pipi sui na uiti qoaqoa gana na savoriana, atsa moa ti kara lalo koluginia na oela se ke mamatsa lê, igira sui gaqira sui moa na manetabu tana duli konina a Aaron, ma niqira aqo kara vaituvarigi dou i laoqira segeni.” ");
INSERT INTO gri_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ma na Taovia e tsarigotoa vaganana iani: “Migirani nogo na vovorona ara kalea na sausau ara sauvania na Taovia, me tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ti vaga ke kesa ke ngaoa na nauana kesa na savori gana na soadouana God, ma nina aqo ke saukolua na omea tuavati aia e gini savori-kodoputsa, visana bredi tagara isti konina; ke visana na sivona matolu e aqosiginia na pulaoa lalokoluginia na oela na olive, se ke visana na biskete e saluvaginia na oela na olive, se ke visana na gola e aqosiginia na pulaoa lalokoluginia na oela na olive. ");
INSERT INTO gri_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Me ke paboginigotoa visana na sivona bredi ara aqosiginia na isti. ");
INSERT INTO gri_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ma nina aqo ke saua kesa na bredi tana pipi vatana na bredi ngiti nina vangalaka vania na Taovia; ma na bredi girani gana tuva nogo na manetabu aia e qetu bâ na gabuna nina omea tuavati tana belatabu. ");
INSERT INTO gri_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ma na lakana na omea tuavati kara ganisuinogoa tana dani ara gini savori-kodoputsa; ma kara laka goto na moloana sa turina ke totu tsaulina na matsaraka na dani i muri. ");
INSERT INTO gri_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Me ti vaga kesa tinoni ke savoria na kodoputsa gana na manaliana kesa nina veke aia e naua, se ke savoria tana nina padangao segeni, me tau kilia kara ganisuia tana dani aia e savoria, me ti ke kauvisu turina tangomana moa kara gania tana dani i muri. ");
INSERT INTO gri_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Me ti vaga visana na lakana na omea tuavati ke totu moa tsaulina tana tolunina dani, ma niqira aqo kara kodogira sui tana lake. ");
INSERT INTO gri_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Me ti vaga kara gania na turina tana tolunina dani, me sauba God ke tau tabea nina sausau na mane ia. Ma nina sausau ia sauba ke tau lelê pelu vania sa omea, rongona e kaulinaqu nogo, masei ti ke gania sa turina e sasi i matana God me sauba ke gadovikedena. ");
INSERT INTO gri_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Me ti vaga na lakana na omea tuavati ia ke pelea sa omea e tau masidi tana vovorona na lotu, ma niqira aqo kara tau gania ma kara kodolea moa tana lake. “Masei moa e totu male taonia na vovorona na lotu tangomana ke gania na velesina, ");
INSERT INTO gri_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","me ti vaga kesa e kaulinaqu tana vovorona na lotu me ke sanga na ganiana, ma na tinoni vaga ia kara tsidavaginia tania niqira saikolu igira nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Me atsa vaga goto ti kalina kesa ke sanga na ganiana na velesina na omea tuavati ara gini savori-kodoputsa murina aia e pelenogoa sa omea e tau male tana vovorona na lotu, atsa moa ti na naqu ia e talu tana konina tinoni se na omea tuavati, ma na tinoni vaga ia kara tsidavaginia tania niqira saikolu igira nina tinoni God.” ");
INSERT INTO gri_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ma na Taovia e saugotoa vania a Moses na vovorona na ketsa girani ");
INSERT INTO gri_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","vanigira na toga ni Israel: “Kara laka saikesa na ganiana sa seregana na buluka, se na sipi, se na naniqoti. ");
INSERT INTO gri_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ma na seregana kesa na omea tuavati e mate segenina, se e gati matesia kesa na omea tuavati atsi, kara laka saikesa goto na ganiana, me tau moa seko ti vaga kara gini aqo visana tana omea tavosi. ");
INSERT INTO gri_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Asei moa ke gania na seregana sa omea tuavati e tugua kara gini savori-kodoputsa vania na Taovia, na tinoni vaga ia kara tsidavaginia tania niqira saikolu igira nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Me atsa moa ti iava kara totu igira na tinoni ni Israel, me vali saikesa vanigira na ganiana na velesina na manu se na omea tuavati kolu gabuna. ");
INSERT INTO gri_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Masei moa ti ke kutsia na ketsa iani kara tsidavaginia tania niqira saikolu igira nina tinoni God.” ");
INSERT INTO gri_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ma na Taovia e tsarigotoa vania a Moses: ");
INSERT INTO gri_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Asei moa ti ke tû na savoriana kesa na sausau tangomana na tinoni kara ganipatâ na turina, ma nina aqo ke adimaia na turina ngiti nina vangalaka segeni vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Maia ke adimaiginia na limana segeni rongona aia nogo nina sausau na mutsa vania na Taovia. Ke adia na seregana na omea tuavati kolua na arona me ke saugira vaga nina vangalaka segeni vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Maia na manetabu nina aqo ke kodogira na seregana tana belatabu, ma na arona kara adigaqira igira na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ma na arana madoa ni muri na omea tuavati ke lia gana tuva ");
INSERT INTO gri_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","na manetabu aia e savoria na gabuna ma na seregana na omea tuavati ia ara gini aqo tana savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Na arona na omea tuavati, ma na arana madoa ni muri kaira niqira vangalaka dou bâ igira na tinoni ni Israel vania na Taovia, maia e sauvanigira na manetabu. Miani nogoria na omea vaga igira na tinoni ni Israel niqira aqo kara sauvanigira na manetabu tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Maia nogoria na turina na mutsa ara savorivania na Taovia, mara tusuvania a Aaron migira na dalena tana dani ara tabugira mara lia na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Mi tana dani nogo ia, maia na Taovia e ketsaligira na tinoni ni Israel kara saua na turina na mutsa vaga girani ara gini savori vania ke lia gaqira tuva na manetabu tana tagu sui ke mai.” ");
INSERT INTO gri_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Igirani nogo na vovorona ara kalea na aqona na savori-kodokodo, ma na sausau na uiti, ma na savori-sausau matena na sasi, ma na sausau na volivisu, ma na sausau tana dani ara tabugira na manetabu, migira na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Na Taovia e sauvania a Moses na vovorona na ketsa girani tana Vungavunga Sinai tana kaomate, tana dani aia e tsarivanigira na toga ni Israel kara adimai vania niqira sausau. ");
INSERT INTO gri_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ma na Taovia e tsarivanigotoa a Moses, ");
INSERT INTO gri_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ko adimaia a Aaron mi tugira na dalena i matana na Valepolo i tana au totu inau, mo ko adimaigira goto na polo na manetabu, ma na oela gana na nina omea, me kesa na buluka mane vaolu gana na savori-sausau matena na sasi, me ke ruka na sipi mane, me ke kesa na kei na bredi tagara isti i konina. ");
INSERT INTO gri_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Mi muri mo ko soamaigira na alaala na toga popono ma kara saimai sui lakalaka ieni.” ");
INSERT INTO gri_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Maia Moses e naua na omea vaga na Taovia e ketsaliginia ke naua. Mi kalina ara saimai sui nogo na toga popono, ");
INSERT INTO gri_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","maia e tsarivaganana vanigira, “Na omea inau au vangaraua na nauana kalina ia aia nogo na Taovia e ketsaliginiau kau naua.” ");
INSERT INTO gri_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mi tana, ma Moses e aditugira mai a Aaron ma na dalena i mataqira na toga, me lesoviginitugira na kô muritaonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Me sagelivania a Aaron na sote ma na polo sagesage katsi, ma na itai na soripolo. Me sagelivanigotoa na epod, me sorikakai taligua tana bunguna ginia kesa na itai vovosi laka. ");
INSERT INTO gri_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Me moloa na todo tetelo ke tsautsuna i aseasena, me molotsavukaira na Urim ma na Tumim i laona. ");
INSERT INTO gri_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Me molokae vania gana kepi tana lovana, me sori bâ na kikiri tabu qolumila i konina, aia nogo na papadana laka ara balonogoa vania na Taovia vaga nogo na Taovia e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mi muri ma Moses e adia na oela tabu gana na nina omea, me ninaginia na Valepolo i tana e totu na Taovia ma na omea sui i laona, mi tana nauvaganana ia, maia e baloginigira na omea sui vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Me adia na oela me tsirikagini bâ vitu kalina tana belatabu, mi tana vangana sui, ma na popo na vulivuli, ma na tototona, rongona ke baloginigira sui vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mi tana, maia e qetu bâ na turina na oela tabu i lovana a Aaron, me ninaginia, me baloginia vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Me sui ia, maia Moses e adimaitugira na dalena mane a Aaron, me sagelivanitugira na polo sagesage, me soritaligua na itai na soripolo tana bunguqira, me moloa na kepi i tu lovaqira, vaga nogo na omea na Taovia e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Me sui ia, ma Moses e adia na buluka mane vaolu agana na savori-sausau matena na sasi, ma Aaron mi tugira na dalena ara tu moloa tu limaqira i lovana. ");
INSERT INTO gri_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mi muri, ma Moses e labumatesia na buluka ia, me adia na turina na gabuna, me lumia na kakauna i laona, me ulikagini bâ vati tana gai ara katsadato tana tsukena na belatabu, rongona ke baloginia na belatabu ia. Mi tana nauvaganana ia, aia e pungua na belatabu ke gini male, me balovania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ma Moses e adigira sui na seregana e tsavua na vangalevona, ma na turina dou bâ na atena, mi kaira na piuna ni laona kolu seregana, me ba kodogira sui i kelana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mi muri, me adia na buluka popono kolu kokorana, ma na velesina, ma na tinaena, me ba kodoa i taba i tano tania na vera, vaga nogo na Taovia e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Mi muri, ma Moses e adia kesa ka vidaqira na sipi mane aia agana na savori-kodokodo, ma Aaron mi tugira na dalena ara tu moloa tu limaqira i lovana. ");
INSERT INTO gri_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ma Moses e labumatesia na sipi, me adia na gabuna me qetu bâ vati tana liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Me pari kutikutia na sipi, me vulimalegira tana kô na vangalevona ma na aranimuri, me gini savori-kodokodo na lovana, ma na seregana, migira sui na paparina popono na sipi ia i kelana na belatabu, vaga nogo na omea na Taovia e ketsaliginia ke naua. Ma na vuruna na omea ara savori-kodokodo vaganana ia e punâ na Taovia me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Mi muri, ma Moses e adimaigotoa na rukanina sipi mane, aia agana na tabuaqira na manetabu, maia Aaron mi tugira na dalena ara tu mologotoa tu limaqira i lovana. ");
INSERT INTO gri_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ma Moses e labumatesia, me adia na turina na gabuna me saluvaginia na rarauna kulina madoa a Aaron, ma na kakau lokina tana limana madoa, ma na kakau lokina tana tuana madoa. ");
INSERT INTO gri_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Me tû, me adimaitugira goto na dalena mane a Aaron, me saluvagotoa na gabu tana rarauna tu kuliqira madoa, mi tana kakauqira loki i tu limaqira madoa, mi tana kakauqira loki i tu tuaqira madoa. Mi muri, ma Moses e qetu bâ na turina na gabu e kauvisu vati tana liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Me adigira na seregana popono, ma na kalina serega, ma na seregana e tsavua na vangalevona, ma na turina dou bâ na atena, mi kaira ruka na piuna ni laona kolu seregana, ma na arana madoa ni muri. ");
INSERT INTO gri_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Me adigotoa kesa na sivona bredi i laona na kei i tana ara totu na bredi tagara isti konina ara sauvaninogoa na Taovia, me kesa na sivona tana bredi ara aqosiginia na pulaoa lalo koluginia na oela, me kesa na biskete, me mologira i kelana na seregana ma na arana madoa ni muri. ");
INSERT INTO gri_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Me molobagira sui na mutsa girani tana limana a Aaron mi tugira na dalena, mara tu savorigira vaga kesa na vangalaka dou bâ vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mi tana, ma Moses e adigira tugua na omea girani tania tu limaqira me ba kodogira tana belatabu, i kelana na savori-kodokodo ara savoria gana na tabuaqira na manetabu. Ma na vuruna na omea ara savori-kodokodo vaganana ia e punâ na Taovia, me gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Me sui ia, ma Moses e adia na arona na sipi ia me sauvania na Taovia vaga kesa na vangalaka dou bâ vania. Maia nogo gana tuva a Moses tana sipi e gini savori gana na tabuaqira na manetabu. Ma Moses e naugira pipi sui lakalaka na omea vaga na Taovia nogo e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ma Moses e adia na turina na oela gana na nina omea, ma na turina na gabu e totu tana belatabu, me tsirikagini bâ i tu koniqira a Aaron ma na dalena mi tana tu poloqira goto. Mi tana nauvaganana ia, maia e tabutugira kolugotoa tu poloqira me gini balotugira tana aqo vaniana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Me sui ia, me tû a Moses me tsarivaganana iani vania a Aaron mi tugira na dalena, “Kamu tu adia na velesina girani ma kamu tu bâ kukia i matsapana na Valepolo i tana e totu na Taovia, ma kamu tu gania i tana kolua na bredi ara totu i laona na kei i tana ara totu na bredi ma na biskete ara saua agana na tabuaqira na manetabu, vaga nogo na Taovia e ketsaliginitugamu na nauana. ");
INSERT INTO gri_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Me ti vaga kara kauvisu visana turina na velesina ma na bredi ma tu nimui aqo kamu tu kodoligigira. ");
INSERT INTO gri_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ma kamu tu laka goto na vanoligi taniana na matsapana na Valepolo i laona ke vitu na dani, poi tsau kalina ke tovu popono na aqona na tabuamui vaga na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Na Taovia nogo e moloketsana vanigita ka naua na omea vaga ia i dani eni, rongona ke gini tanusiligi tu nimui sasi. ");
INSERT INTO gri_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Me vaga ia ma nimui aqo tugamu kamu tu totu kalavata tana matsapana na Valepolo na dani ma na bongi i laona ke vitu na dani, ma kamu tu naua na omea aia na Taovia e ketsaliginitugamu. Me ti vaga kamu tu tau nauvaganana ia, me sauba kamu tu mate. Aia nogo e vaga na omea na Taovia e moloketsana vaniau inau.” ");
INSERT INTO gri_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Me vaga ia, ma Aaron mi tugira na dalena ara tu naua na omea sui vaga na Taovia e ketsaliginitugira tana mangana a Moses. ");
INSERT INTO gri_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Mi tana dani murina e sui na aqona na tabuaqira a Aaron mi tugira na dalena vaga na manetabu, ma Moses e soamaitugira a Aaron ma na dalena, kolugira na ida sui tana Israel, kara saimai i matana. ");
INSERT INTO gri_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Maia e tsarivania a Aaron, “Ko adia ke kesa na buluka mane vaolu me ke kesa na sipi mane me ke tau goto seko sa tabana ka koniqira, mo ko savorikaira vania na Taovia, aia na buluka mane agana na savori-sausau matena na sasi, ma na sipi mane agana na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Mi muri, mo ko tsarivanigira goto na toga ni Israel kara adimaia ke kesa na naniqoti mane agana na savori-sausau matena na sasi, me ke kesa na dalena buluka ke kesa moa na ngalitupana, me ke kesa na dalena sipi mane ke kesa goto moa na ngalitupana, agana na mani savori-kodokodo, me ke tau goto seko sa tabana ka koniqira. ");
INSERT INTO gri_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Me ke kesa na buluka mane me ke kesa na sipi mane agana na mani savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. Ma kara savorigira na omea girani vania na Taovia kolua na sausau na uiti ara lalo koluginia na oela. Niqira aqo nogo igira kara naugira na omea vaga girani rongona i dani eni nogo sauba na Taovia ke labavulagia vanigira.” ");
INSERT INTO gri_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Migira ara adimaigira i matana na Valetabu na omea sui vaga nogo a Moses e ketsaliginigira, ma na saikolu popono ara labasai i tana mara samasama vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Me tû a Moses me tsarivanigira, “Aia nogo na Taovia e moloketsana vanigamu kamu naugira na omea sui girani, rongona na marara angaanga i tana e totu aia ke labavulagia vanigamu.” ");
INSERT INTO gri_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Maia e pilo bâ konina a Aaron me tsarivania, “Ko bâ tana belatabu mo ko saua na savori-sausau matena na sasi, ma na savori-kodokodo gana na veoligiaqira nimu sasi igoe ma niqira sasi na toga sui. Mi muri ti ko adigira niqira sausau na toga, mo ko savorigira matena niqira sasi, vaga nogo na Taovia e moloketsana vanigo.” ");
INSERT INTO gri_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ma Aaron e bâ tana belatabu me labumatesia na buluka mane vaolu, aia agana na mani savori-sausau matena nina sasi segeni nogo. ");
INSERT INTO gri_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Mi tugira na dalena ara adimai vania na gabu, maia e lumia na kakauna i laona me saluvaginigira na gai ara katsadato vati tana tsukena na belatabu, ma na turina na gabu e kauvisu e qetu bâ i tuana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Mi muri, maia e kodogira tana belatabu na seregana, na piuna ni laona, ma na turina dou bâ na atena, vaga nogo na omea na Taovia e moloketsana vania a Moses. ");
INSERT INTO gri_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Maia e adigira na velesina ma na kokorana me ba kodogira i taba i tano tania na vera. ");
INSERT INTO gri_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Me labugotoa na omea tuavati agana nina savori-kodokodo segenina aia. Mi tugira na dalena ara adimai vania na gabu, maia e qetu bâ tana vati liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Mi tugira ara tu adiba vania na lovana ma na paparina tavosi, maia e kodogira i kelana na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Mi muri me vuligira na vangalevona ma na aranimuri me kodogira tana belatabu i kelaqira na turina tavosi ara gini savori-kodokodo nogo. ");
INSERT INTO gri_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Mi murina ia, maia e savorigira niqira sausau na toga. Me adia na naniqoti aia agana na mani savori-sausau matena niqira sasi na toga, me labumatesia me savoria, vaga nogo e naua kalina e savori-sausau matena nina sasi segeni nogo. ");
INSERT INTO gri_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Me adigotoa na omea tuavati agana na mani savori-kodokodo, me savoria muritaoninogoa na vovorona na ketsa. ");
INSERT INTO gri_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Maia e savorigotoa na sausau na uiti me adia kesa na kakarona na pulaoa me ba kodoa i kelana na belatabu. Aia na kamagana moa na savori-kodokodo ara naua pipi matsaraka. ");
INSERT INTO gri_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Maia e matesikaira na buluka mane ma na sipi mane ara adimaia igira na toga, gana na savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. Mi tugira na dalena ara tu adimai vania na gabu, maia e qetu bâ tana vati liligina na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ma Aaron e molokaea na seregana na buluka mane ma na sipi mane ");
INSERT INTO gri_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","i kelana na arona na omea tuavati, me tseba vanogira sui tana belatabu. Mi tana maia e kodoa na seregana tana belatabu, ");
INSERT INTO gri_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","me adikaira na arona ma na arana madoa ni muri me savoridatokaira vaga kesa na vangalaka dou bâ vania na Taovia, vaga a Moses e moloketsana nogo. ");
INSERT INTO gri_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Mi kalina a Aaron e nausuigira nogo na aqona na savori-kodoputsa girani, maia e saukaea na limana i kelaqira na toga me tabugira. Mi muri, maia e tsotso tsuna i lao. ");
INSERT INTO gri_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mi kaira a Moses ma Aaron ara ka duli vano tana Valepolo i tana e totu na Taovia, mi kalina ara ka rutsumai ara ka tabugira na toga, ma na mararana angaanga na Taovia e toravigira na toga popono. ");
INSERT INTO gri_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ma na Taovia e tavongani molomaia na lake me ganigira popono na vangana na savori-kodokodo ma na seregana ara totu i kelana na belatabu. Mi kalina igira na toga ara reivaganana ia, migira sui ara gudato mara puka kovoragi tsuna tana kao. ");
INSERT INTO gri_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Mi kaira na dalena a Aaron aia a Nadab ma Abihu, ara ka adia tangokesa na tapala tapetape mara ka vanitsavua na madaova gagâ i laona, kolua na bulunagai uruuru, mara ka savorivania na Taovia na lake e tau na lake tabu, rongona na Taovia e tau ketsalikaira kara ka savorivania. ");
INSERT INTO gri_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ma na Taovia e tû, me molomaia na lake, me gani matesikaira nogo i tana i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mi tana ma Moses e tsarivania a Aaron, “Aia nogoria na omea vaga ia na Taovia e gini goko tana rongona kalina aia e tsaria, ‘Igira sui ara aqo vaniau inau, niqira aqo kara kukuni taniau matena inau au God tabu loki sosongo; me sauba kau saulabatia na susuligaqu i mataqira na tinoni sui migira kara tsonikaeginiau inau.’ ” Maia Aaron e mui lê moa. ");
INSERT INTO gri_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ma Moses e soamaikaira a Misael ma Elsapan, kaira na dalena na niana a Aaron aia a Usiel, me tsarivanikaira, “Kamu ka mai tsebâ ka koniqira ka tasimui tania na Valepolo Tabu, ma kamu ka ba molokaira i taba i tano tania na vera.” ");
INSERT INTO gri_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Mi kaira ara ka mai mara ka tangoliginikaira nogo ka poloqira mara ka tsebaligi vanoa ka koniqira tabana i tano tania na vera, vaga nogo a Moses e ketsaliginikaira. ");
INSERT INTO gri_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mi tana ma Moses e tû me tsarivania a Aaron mi kaira a Eleasar ma Itamar na dalena, “I tugamu kamu tu laka na roku ma na sauvulagiana laka amu tu totu tana melu rongona ka mateaqira kaira. Rongona ti vaga kamu tu nauvaganana ia, me sauba kamu tu mate, ma na Taovia sauba ke kore vania na saikolu popono. Migira sui moa na tinoni ni Israel tugamui verakolu e dou moa ti kara tangitangi tana ka rongoqira kaira ara ka gini mate na lake na Taovia e molomaia me ganikaira. ");
INSERT INTO gri_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mi tugamu kamu tu laka goto na vanoligi taniana na matsapana na Valepolo kamu tu tau mate, rongona au tabuginitugamu nogo nina oela tabu na Taovia.” Me vaga ia mi tugira ara tu muria na omea vaga a Moses e tsaria. ");
INSERT INTO gri_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ma na Taovia e goko vania a Aaron me tsaria, ");
INSERT INTO gri_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Igoe mi kaira na dalemu kamu tu laka na sage tana Valepolo i tana au totu inau ti vaga amu tu inuvia na uaeni se na bia. Ti vaga kamu tu nauvaganana ia, me sauba kamu tu mate. Iani nogo kesa na ketsa kamu tu taoni kalavatavia tugamu migira sui tu kukuamui. ");
INSERT INTO gri_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Rongona tu nimui aqo nogo tugamu kamu tu sasaga na reigadoviana na omea e kalea God ma na omea e kalegira na tinoni, na omea e male taonia na vovorona na lotu ma na omea e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ma tu nimui aqo goto kamu tu sasaniginigira na toga ni Israel pipi sui na ketsa inau au saunogoa vanigamu tana mangana a Moses.” ");
INSERT INTO gri_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Maia Moses e tsarivania a Aaron mi kaira na dalena mane ara ka mauri moa, kaira nogo a Eleasar ma Itamar, “I tugamu kamu tu adia na lakana na uiti ara tsaravisu tana mutsa ara gini savorivania na Taovia, ma kamu tu aqosiginia na bredi tagara isti konina, ma kamu tu ba ganigira i ligisana na belatabu rongona na sausau iani e tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kamu tu ganigira kesa tana nauna tabu; igira nogoria gamu tuva igoe mi kaira na dalemu ara talumai tana mutsa ara gini savorivania na Taovia. Iani nogo na omea na Taovia e moloketsana vaniau inau. ");
INSERT INTO gri_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","I tugamu migira tu nimui tamadale e dou moa kamu gania na arona ma na aranimuri igira na omea tuavati na tinoni ara gini savori vaga niqira vangalaka dou bâ vania na Taovia. Migamu kamu ganigira kesa tana nauna e masidi dou taonia na vovorona na lotu. Ara saugira nogo vanitugamu migira na dalemui vaga gamui tuva e talu tana omea igira na toga ni Israel ara nauginia na savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Igira kara adimai vanitugamu na aranimuri ma na arona kalina tsotsodo ara savoria na seregana vaga na sausau na mutsa vania na Taovia. Migira nogo na paparina vaga gira kara lia tugamui tuva i tugamu migira tu dalemui na dani ma na dani, vaga nogo na Taovia e moloketsana.” ");
INSERT INTO gri_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ma Moses e veisua tana rongona na naniqoti gana na savori-sausau matena na sasi, mara tsarivania laka ara kodo suinogoa. Me gini kore loki sosongo vanikaira a Eleasar ma Itamar, me veisuakaira, ");
INSERT INTO gri_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“?Laka egua ti amu ka tau gania kesa tana nauna tabu na savori-sausau matena na sasi? Aia na omea tabu loki sosongo, ma na Taovia nogo e saua vanikagamu gana na mani veoligiginiana niqira sasi igira na saikolu popono. ");
INSERT INTO gri_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ma na rongona amu ka tau adisagea na gabuna i laona na Valepolo Tabu, ma ka nimui aqo nogo kamu ka gania i laona nogo na Valepolo, vaga nogo inau au moloketsana vanigamu.” ");
INSERT INTO gri_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Maia Aaron e tsarivania a Moses, “Ko reia, i dani eni igira na toga ara saua niqira savori-sausau matena na sasi, ma niqira savori-kodokodo i matana na Taovia, me atsa moa ara nauvaganana ia minau e gadoviau na rota loki. ?Me ti vaga inau kau ba gania gaqu tuva e talu tana niqira savori-sausau matena na sasi i dani eni, me laka ke reingaoa moa na Taovia? Inau au padâ e tagara.” ");
INSERT INTO gri_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mi kalina a Moses e rongomia na goko vaga ia, me gini doutugua na tobana. ");
INSERT INTO gri_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ma na Taovia e tusuvanikaira a Moses ma Aaron na vovorona na ketsa girani ");
INSERT INTO gri_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","vanigira na tinoni ni Israel. “I laoqira na omea tuavati sui ara mauri tana kao igirani nogo e tau vali vanigamu na ganiana: ");
INSERT INTO gri_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","igira na omea e masanga ruka na perana tuaqira mara dona na qatavisuana gaqira mutsa, ");
INSERT INTO gri_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","me valivanigamu na ganiaqira na kamelo, ma na kadorabo, ma na rabit. Na omea vaga gira ara qatavisuragoa gaqira mutsa me tau moa masanga ruka na perana tuaqira. ");
INSERT INTO gri_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Me valivanigamu goto na ganiana na bô, rongona na bô, atsa moa ti e masanga ruka na perana tuaqira, mara vô na qatavisuana gaqira mutsa. ");
INSERT INTO gri_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Na vatana na omea mamauri vaga gira kamu laka saikesa na ganiaqira se na peleana goto na matena na koniqira. Igira ara tau masidi tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Igamu kamu ganigira rago pipi sui na vatana tsetse ara tamanina na kakakaqira ma na vidoqira. ");
INSERT INTO gri_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Migira moa na omea ara mauri i laona na kô, mara tau tamanina na kakakaqira ma na vidoqira, e vali vanigamu na ganiaqira. ");
INSERT INTO gri_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Igira na omea mamauri vaga gira ara tau masidi tana vovorona na lotu. Kamu laka saikesa na ganiaqira se na peleana goto na matena na koniqira. ");
INSERT INTO gri_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nimui aqo kamu tau gania sa vidaqira na omea ara mauri i laona na kô mara tau tamanina na kakakaqira ma na vidoqira. ");
INSERT INTO gri_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“Ma nimui aqo goto kamu laka na ganiana sa vidaqira na manu vaga girani: na manuloki, na tei, na roga bora, ma na roga sere; na tavakea, na manusata, na kaokao; na tsou, na qaro, na oa, na gaova, na garanga, na manganikona, na kitso, ma na kasike. ");
INSERT INTO gri_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Igira sui na omea tetelo ara dona na lovo kamu sibi tanigira. ");
INSERT INTO gri_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Igira moa na omea ara dona na tsipu ");
INSERT INTO gri_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","vaga na kipo, na potsokatso, ma na kipo rarauga, e tau valimui na ganiaqira. ");
INSERT INTO gri_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Migira sui pipi na omea tetelo tavosi ara tamanina na rapoqira mara dona goto na taqutaqu tana kao, nimui aqo kamu sibi tanigira. ");
INSERT INTO gri_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","“Masei ti vaga ke pelea moa na matena na omea vaga girani sauba ke kaulinaqu poi tsau tana ngulavi: igira sui na omea tuavati e matolu na perana tuaqira me tau masanga ruka mara tau dona na qatavisuana gaqira mutsa, migira sui goto na omea tuavati e mapou lê na perana tuaqira. Masei ti ke kalagaia na matena na koniqira na omea vaga girani ma nina aqo ke tsagimaledoua na polona, maia sauba ke totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“Na kusikusi, na bogu, na goru, ma na qota, nimui aqo kamu sibi tanigira. ");
INSERT INTO gri_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Masei ti vaga ke pelea moa na matena na konina na omea vaga girani, maia ke totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Me ti vaga na matena na koniqira ke puka bâ me ke pelea na omea gua moa, vaga na tapana gai, se na polo, se sa omea ara aqosiginia na kokorana na omea tuavati, se sa lapa, ma nimui aqo kamu lumia na omea ia tana kô, me ke totu kaulinaqu nomoa poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Me ti vaga na matena na konina ke pukatsuna i laona sa popovatu, ma na omea sui ara totu i laona ara gini kaulinaqu, ma nimui aqo kamu tairutua moa na popovatu ia. ");
INSERT INTO gri_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Me ti vaga kara qetu bâ na kô e totu i laona na popovatu vaga ia i konina sa vatana mutsa e dou na ganiana, ma na mutsa ia e gini kaulinaqu goto, ma na kô na inu e totu i laona na popovatu ia e kaulinaqu goto. ");
INSERT INTO gri_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Na omea sui moa e puka bâ na matena i konina kesa na omea vaga girani, ma na omea ia e gini kaulinaqu; me ti na umu ma kamu toroveoa, me ti na kuki ma kamu taitapalia, ");
INSERT INTO gri_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","me ti na vuravura se na tuvu, maia e tau gini kaulinaqu, atsa moa ti ara gini kaulinaqu na omea sui tavosi ara pelea na matena na koniqira na omea vaga gira. ");
INSERT INTO gri_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Me ti vaga na matena kesa vidaqira na omea vaga gira ke puka bâ i koniqira na vatuna na omea agana na tsukatsuka ma na vatuna na omea vaga ia ara tau kaulinaqu, ara totu male dou moa. ");
INSERT INTO gri_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Me ti vaga na vatuna na omea agana na tsukatsuka ara molonogoa tana kô, vangarau na tsukaaqira me ke kesa na omea mate ke puka me ke pelegira, ma na vatuna na omea tsukatsuka girani ara gini kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Me ti vaga ke tavongani mate lê sa vidaqira na omea tuavati e dou na ganiana, masei ke pelea moa na konina maia sauba ke totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Me ti vaga ke kesa ke gania sa turina na omea tuavati e mate lê vaga ia se ke kalagaia, ma nina aqo ke tsagimalegira na polona, maia ke totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Nimui aqo kamu laka goto na ganiana ke kesa vidaqira na omea mamauri tetelo igira ara dona na vanovano tana kao, ");
INSERT INTO gri_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","atsa moa ti ara taqutaqu se ara gini vanovano vati na tuaqira, se ara tamanina e danga na kakauqira. ");
INSERT INTO gri_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kamu laka na nau segeniana ma na gini kaulinaqu tana ganiana kesa vidaqira na omea vaga girani. ");
INSERT INTO gri_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Inau na Taovia nimui God, ma nimui aqo kamu doulaka saviliu, rongona inau au doulaka saviliu. ");
INSERT INTO gri_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Inau nogo na Taovia au adirutsumigamu tania na vera ni Ejipt rongona inau kau gini lia nimui God. Me vaga ia ma nimui aqo igamu kamu doulaka rongona inau au doulaka. ");
INSERT INTO gri_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Miani nogoria e vaga na ketsa tana rongoqira na omea tuavati, ma na manu, me pipi sui na omea ara mauri i kô mi tasi, ma na omea sui ara liu bamai tana kao. ");
INSERT INTO gri_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ma nimui aqo kamu parovata ma kamu dona na reigadoviana na omea e male ma na omea e tau male taonia na vovorona na lotu, ma na omea tuavati e dou moa na ganiaqira migira e vali na ganiaqira.” ");
INSERT INTO gri_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ma na Taovia e sauvania a Moses na vovorona na ketsa girani ");
INSERT INTO gri_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","vanigira na tinoni ni Israel. “Kalina kesa na daki ke vasua kesa na dalena mane, ma na daki ia e kaulinaqu tana vovorona na lotu i laona e vitu na dani, vaga nogo kalina aia e reivula. ");
INSERT INTO gri_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mi tana alunina dani ma kara paripapadana na baka ia. ");
INSERT INTO gri_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Mi muri me kau ke tolu sangavulu tolu goto na dani ti ke suisui me ke maletugua tania na gabu aia e vanolia; maia ke tau goto pelea sa omea tabu se ke sage i laona na Valepolo Tabu poi tsau kara tovu na danina na suisui. ");
INSERT INTO gri_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Mi kalina kesa na daki ke vasua kesa na dalena daki, ma na daki ia e kaulinaqu tana vovorona na lotu i laona e sangavulu vati na dani vaga nogo kalina aia e reivula. Me tû tana me kau ke ono sangavulu ono goto na dani ti ke suisui me ke maletugua tania na gabu aia e vanolia. ");
INSERT INTO gri_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Mi kalina ke suilavaginia nina tagu na suisui matena e vasua kesa na baka mane se kesa na baka daki, maia nina aqo ke adi bâ vania na manetabu tana matsapana na Valepolo i tana e totu na Taovia ke kesa na dalena sipi ke kesa moa na ngalitupana agana na mani savori-kodokodo, me ke kesa na kurau se na kulukulu agana na savori-sausau matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Ma nina aqo na manetabu ke sauvania na Taovia nina vangalaka na daki ia, me ke nauvania na vovorona na suisui me ke gini masidi doutugua i matana na lotu. Aia nogoria na omea vaga nina aqo na daki ke naua murina kalina ke vasua kesa na dalena. ");
INSERT INTO gri_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Me ti vaga na daki ia e utu vania na sauana kesa na dalena sipi, ma nina aqo ke adia ke ruka na kulukulu se ke ruka na kurau, ke kesa agana na mani savori-kodokodo, me ke kesa agana na savori-sausau matena na sasi, maia na manetabu ke adigira me ke nauvania na vovorona na suisui me ke gini masidi doutugua na daki ia i matana na lotu.” ");
INSERT INTO gri_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Na Taovia e saugotoa vanikaira a Moses ma Aaron na ketsa girani. ");
INSERT INTO gri_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ti vaga ke kesa ke tamanina kesa na vora tana kokorana, se kesa na tsope se na tsomo me rerei vaga ti sauba ke lia na mudo, kara adi bâ na tinoni ia i konina na manetabu tana duli konina a Aaron. ");
INSERT INTO gri_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Maia na manetabu ke vilekevania na vorana, me ti vaga ke reia ke sere na vuvuluna, ma na lakana na vora ke qou me ke vanekae polipolia na liligina na vora, maia nogoria na lobogu seko, maia na manetabu ke tsarivulagi vania laka aia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Me ti vaga na vora ia ke sere lê moa me ke tau gani qoua liusia na kokorana polipoli, ma na vuvuluna ke tau rerei vaga ti ke sere, mi tana maia na manetabu ke raia na tinoni ia ke ba totu tabaligi segenina talu tanigira na tinoni tavosi ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mi tana vitunina dani maia na manetabu ke vileketugua, me ti vaga ke reia laka na vora ia ke rerei atsa moa me ke tau goto gani babâ na kokorana, maia sauba ke raia na tinoni ia ke totu tabaligi tugua ke vitu goto na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mi tana vitunina goto na dani, ma na manetabu sauba ke vileketugua, me ti vaga na vora ia ke tuturiga na mavu me tau goto gani babâ moa na kokorana, maia ke tsarivulagia laka na tinoni ia e totu male taonia na vovorona na lotu; ma na vora ia na vora lê moa. Ma na tinoni ia nina aqo ke tsagimaledoua moa na polona me ke gini totu male. ");
INSERT INTO gri_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mi muri ti vaga na vora ia ke labavisutugua, ma nina aqo na mane ia ke ba labatugua i matana na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ma na manetabu ke vileke doutugua, me ti vaga ke tsodovulagia laka na vora ia e raratsu moa, maia ke tsarivulagi vania laka e kaulinaqu nogo; e tsodoa na mudo. ");
INSERT INTO gri_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Me ti vaga ke kesa ke tsodoa na mudo, kara adi bâ na tinoni ia i konina na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ma na manetabu ke vilekedoua, me ti vaga ke reia na vorana e sere kolu vuvuluna me butongoga, ");
INSERT INTO gri_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","maia nogoria na lobogu na mudo. Maia na manetabu ke tsarivulagia vania laka e tau male tana vovorona na lotu; me tau goto kilia ke raia ke ba totu tabaligi talu, rongona e labamaka nogo laka na lobogu seko e totu i konina. ");
INSERT INTO gri_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Me ti vaga na lobogu seko ia ke gani babâ me ke liuvia na kokorana popono tû i lovana me tsautsuna i tuana, ");
INSERT INTO gri_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","maia na manetabu nina aqo ke vileketugua. Me ti vaga ke tsodovulagia laka e pale nogo na vora tana kokorana popono, maia sauba ke tsarivania na tinoni ia laka aia e male nogo. Rongona ti vaga na kokorana popono ke palenogoa maia e totu male nogo taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mi kalina tsotsodo ti ke labavisutugua kesa na vora tana kokorana, maia e gini kaulinaqu tugua. ");
INSERT INTO gri_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Me sauba na manetabu ke vileke doutugua, me ti vaga ke reia kesa na vora e labavisutugua me ganiqoua na kokorana, me sauba ke tsarivania laka aia e kaulinaqu tugua. ");
INSERT INTO gri_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mi kalina ti vaga ke mavu nogo na vora ia, me ke pale sere tugua na kokorana, maia nina aqo ke visutugua i konina na manetabu, ");
INSERT INTO gri_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","maia sauba ke vileketugua. Me ti vaga ke reia ke pale sui nogo, maia e tau nogo kaulinaqu, ma na manetabu ke tsarivania laka aia e male dou nogo. ");
INSERT INTO gri_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Me ti vaga kesa ke tsope me ke mavu sui nogo, ");
INSERT INTO gri_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mi muri me ke labatugua kesa na tsomo sere se na tuputupu tsitsi-sere tana nauna i tana e tsope tana idana, maia nina aqo ke ba laba i konina na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ma na manetabu ke vilekea, me ti vaga na tutupuna ke rerei vaga laka ti ke qou liusia na liligina tana kokorana ma na vuvuluna ke sere, maia sauba ke tsarivania laka aia e kaulinaqu. Aia e kesa na lobogu seko e tuturiga tana tsope. ");
INSERT INTO gri_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Me ti vaga na manetabu ke vilekea me ke tsodoa laka e tau sere na vuvuluna, me laka na vora e tau ganiqou liusia na liligina, me seresereaga moa na rereina, ma nina aqo na manetabu ke moloa ke totu tabaligi i laona ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Me ti vaga na tupu ia ke gani babâ moa na kokorana na tinoni ia, me sauba na manetabu ke tsarivania laka aia e kaulinaqu; na lobogu seko e totu i konina. ");
INSERT INTO gri_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Me ti vaga na tupu ia ke tau oli me ke tau goto gania babâ moa na kokorana, maia na palena lê moa na tsope, ma na manetabu sauba ke tsarivania laka aia e male dou tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Me ti vaga kesa ke gania na lake me ke takevu na kokorana, mi tana nauna e gania na lake e sere se e tsitsi-sere, ");
INSERT INTO gri_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","me sauba na manetabu ke vilekea. Me ti vaga ke reia na vuvuluna ke sere tana nauna e gania na lake, ma na vora ke qou liusia na liligina, maia nogoria na lobogu seko e tuturiga tana nauna e gania na lake, ma na manetabu ke tsarivulagia vania laka aia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Me ti vaga na vuvuluna e tû i laona ke tau sere, ma na vora e tau qou liusia na liligina, me seresereaga moa na rereina, ma na manetabu ke moloa ke totu tabaligi i laona ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Mi tana vitunina dani me sauba na manetabu ke vileketugua, me ti vaga aia ke reia laka e gani babâ moa na kokorana, maia nogoria na lobogu seko, ma na manetabu nina aqo ke tsarivulagia vania na tinoni ia laka e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Me ti vaga na tupu ia ke totu atsa vaga moa me tau goto raratsu, me seresereaga moa na rereina, maia e tau na lobogu seko. Maia na manetabu ke tsarivulagia vania laka e male dou moa tana vovorona na lotu, rongona aia na palena lê moa tana nauna e gania na lake. ");
INSERT INTO gri_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Me ti vaga ke kesa na mane se na daki ke vora na lovana se na ngongoena, ");
INSERT INTO gri_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ma nina aqo na manetabu ke vilekea. Me ti vaga ke reia laka na vora ia e qou liusia na liligina, ma na vuvuluna ke milamilaga mara tuturiga na tagori, maia nogoria na lobogu seko, ma na manetabu ke tsarivulagia vania na tinoni ia laka aia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Me ti vaga kalina na manetabu ke vilekea na vora ia, me ke reia laka e tau vaga ti ke qou liusia na liligina, me tau moa mamauriga dou na vuvuluna i laona, maia sauba moa ke moloa na tinoni ia ke totu tabaligi i laona ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Mi tana vitunina dani ma na manetabu sauba ke vileketugua na vora ia, me ti vaga ke tau goto gani babâ moa, me ke tau milamilaga na vuvuluna i laona, me ke tau goto qou liusia na liligina, ");
INSERT INTO gri_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","eo, ma na tinoni ia nina aqo ke tsara polipolia tana nauna e totu na vora. Ma na manetabu sauba ke moloa ke totu tabaligi i laona ke vitu goto na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Mi tana vitunina dani, ma na manetabu nina aqo ke vileketugua na vora ia, me ti vaga ke reia laka e tau goto gani babâ moa, me ke tau goto vaga ke gani qoua liusia na liligina, maia sauba ke tsarivulagia vania laka aia e totu male nogo tana vovorona na lotu. Nina aqo na tinoni ia ke tsagimaledougira na polona, maia ke maletugua. ");
INSERT INTO gri_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Me ti vaga na vora ia ke tuturiga visutugua murina ara tsarivaninogoa laka aia e male nogo, ");
INSERT INTO gri_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mi tana maia na manetabu sauba ke vileketugua. Me ti vaga ke reia laka na vora ia ke gania babâ moa, me tau goto kilia ke lavea laka ti ke reia ke mila na vuvuluna; rongona e labamaka nogo laka na lobogu seko e totu i konina. ");
INSERT INTO gri_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Me ti vaga na manetabu e padâ laka na vora ia e tau raratsu, me dadato varimauri na vuvuluna i laona, ma na vora ia e mavu nogo, ma na manetabu ke tsarivulagia vania laka aia e maletugua tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Mi kalina ti vaga kesa na mane se na daki ke totu na tuputupu tana kokorana, ");
INSERT INTO gri_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ma na manetabu nina aqo ke vilekea na tinoni ia. Me ti vaga ke reia laka igira na tuputupu ara papasaga sere lê moa, maia na kinikiniuga lê moa e tavongani laba tana kokorana na tinoni ia; maia e totu male dou moa tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","“Me ti vaga kesa na mane me ke tagoriligi lê moa na kolina ivuna tana murina lovana se tana nagona lovana, maia e tau gini kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Me ti vaga ke labadato kesa na vora tana latina me ke tsitsi-sere, maia nogoria na lobogu seko. ");
INSERT INTO gri_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ma na manetabu nina aqo ke vilekea, me ti vaga ke reia na vora ia ke tsitsi-sere, ");
INSERT INTO gri_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ma na manetabu ke tsarivulagia vania laka na lobogu seko e laba tana lovana. ");
INSERT INTO gri_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ma na tinoni e tsodoa na mudo nina aqo ke sagelia na polo tataratsi, me ke laka na komuana na ivuna, me ke tangolipoia na mangana me ke gudato, ‘!Au mudo inau, au mudo inau!’ ");
INSERT INTO gri_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Maia e kaulinaqu tana tagu popono e totu na lobogu seko ia i konina, ma nina aqo ke ba totu tabaligi tania na vera ma na tinoni tavosi. ");
INSERT INTO gri_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Mi kalina ti vaga na voko ke totu tana polona tinoni, atsa moa ti na polo ia ara aqosiginia na ivuna sipi se na polo vovosi laka, ");
INSERT INTO gri_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","se i konina kesa turina moa na polo vovosi laka se na polo ara aqosiginia na ivuna sipi, se na turina na kokorana na omea tuavati, se kesa na omea ara aqosiginia na kokorana na omea tuavati, ");
INSERT INTO gri_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","me ti vaga na voko ia e mamaraoga se ke tsitsiaga na rereina, maia nogo na vatana na voko e dona na tavosa bamai me kilia kara tusuvulagia vania na manetabu ke reia. ");
INSERT INTO gri_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ma na manetabu ke vilekea me ke moloa ke totu tabaligi i laona ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Mi tana vitunina dani ma nina aqo ke vileketugua, me ti vaga ke reia na voko ia e tavosa bamai, ma na omea ia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ma nina aqo na manetabu ke kodoa, rongona na vatana na voko vaga ia e dona sosongo na tavosa bamai me kilia na kodoligiana tana lake. ");
INSERT INTO gri_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Me ti vaga kalina na manetabu ke vilekea me ke reivulagia laka na voko e tau tavosa bamai tana omea ia, ");
INSERT INTO gri_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","maia ke ketsaligira kara kotsamaledoua ma kara mololigia i laona ke vitu goto na dani. ");
INSERT INTO gri_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mi muri, maia ke vileketugua, me ti vaga ke reia laka na voko ia e tau goto oli na rereina, me atsa ti e tau goto tavosa bamai, maia na omea ia e kaulinaqu moa; ma nina aqo ke kodoa, atsa moa ti na voko seko ia e totu tabana i laona se i taba. ");
INSERT INTO gri_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Me ti vaga kalina na manetabu ke vileketugua, me ke reia na vokona e tau nogo labamaka, maia ke ratsiligia na turina na polo se na omea tana e totu na voko. ");
INSERT INTO gri_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Mi muri, ti vaga na voko ia ke labavisu tugua, me ke tuturiga tugua na tavosa bamai, maia na tamanina nina aqo ke kodoa na omea ia. ");
INSERT INTO gri_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Me ti vaga ke kotsâ na omea ia me ke nanga na tuputupuna ma nina aqo ke kotsamaletugua, me sauba ke maletugua tana vovorona na lotu.” ");
INSERT INTO gri_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Miani nogoria e vaga na ketsa e kalea na voko e laba tana polona tinoni, atsa moa ti na polo ara aqosiginia na ivuna sipi se na polo vovosi laka, se i konina kesa turina moa na polo vovosi laka, se na polo ara aqosiginia na ivuna sipi, se kesa tana omea ara aqosiginia na kokorana na omea tuavati, na mani tsodovulagiana laka ti na omea ia e kaulinaqu se tau kaulinaqu tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ma na Taovia e sauvania a Moses ");
INSERT INTO gri_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","na vovorona na ketsa vaga girani tana rongona na suisui murina kalina e mavu nogo na mudona kesa tinoni. “Tana dani tsotsodo i tana kara katevulagia vania kesa tinoni laka aia e male nogo tania na mudona, ma niqira aqo kara adi bâ i konina na manetabu, ");
INSERT INTO gri_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","maia na manetabu ke adirutsumia i taba i tano tania na vera me ke vilekea. Me ti vaga ke reia laka e sui nogo gana lobogu, ");
INSERT INTO gri_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ma nina aqo na manetabu ke raia ke adimaia ke ruka na manu ara ka male dou taonia na vovorona na lotu, kolugotoa kesa na tapana na gai na sida, me ke kesa na kolina itai tsitsi, me ke kesa na kokopuna na qoraqora. ");
INSERT INTO gri_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mi muri, ma na manetabu ke ketsaligira kara matesia kesa ka vidaqira na manu i kelana kesa na popovatu i tana e totu na kô maroga ara vasini torea moa tana vuravura. ");
INSERT INTO gri_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mi muri maia ke adia na rukanina manu kolu tapana na gai na sida, ma na kolina na itai tsitsi ma na kokopuna na qoraqora, me ke lumigira i laona na gabuna na manu ara matesinogoa. ");
INSERT INTO gri_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Me ke tsirikagini bâ na gabu ke vitu kalina i konina na tinoni aia ara nauvania na suisui, matena e sui nogo gana lobogu seko, mi muri ke tsarivulagia vania laka e male nogo. Me ke moloa na manu mamauri ke lovoligi. ");
INSERT INTO gri_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ma na tinoni ia ke bâ me ke tsagimaledougira na polona, me ke tsaraligigira na ivuna sui me ke lesomale dou; maia sauba ke gini totu maletugua tana vovorona na lotu, me ke tangomana tugua ke sage bâ i laona na vera, me tabu vania moa ke sage i laona nina valepolo segeni ke vitu goto na dani. ");
INSERT INTO gri_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Mi tana vitunina dani maia ke tsaratugua na lovana, ma na ngolana, ma na vasuna matana, migira sui lakalaka na ivuna tavosi tana kokorana; me ke tsagimalegira na polona me ke leso dou, mi tana ti aia ke gini maletugua tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Mi tana alunina dani maia nina aqo ke adimaia ke ruka na dalena sipi mane me ke kesa na dakina me ke kesa moa tu ngalitupaqira, me ke tau seko sa tabana tu koniqira, me ke tolu na kilo na pulaoa lalo koluginia ke labu tolu na dangana na oela na olive. ");
INSERT INTO gri_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ma na manetabu sauba ke adia na tinoni ia kolugira nina omea sui agana na mani savori me ke bâ i matasapana na Valepolo i tana e totu na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mi tana maia na manetabu sauba ke adia kesa ka vidaqira na sipi mane kolua na oela na olive, me ke savoria ngiti sausau na volivisu, vaga kesa na vangalaka dou bâ vania na Taovia me ke lia gana tuva na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Mi muri me ke labumatesia na sipi tana nauna tabu i tana ara matesigira na omea tuavati agana na savori-sausau mateqira na sasi ma na savori-kodokodo. Nina aqo nogo ke nauvaganana ia, rongona na sausau na volivisu, vaga goto na savori-sausau mateqira na sasi, igira sui gana tuva na manetabu, mara tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ma na manetabu ke adia na turina na gabuna na sipi me ke molo bâ tana rarauna na kulina madoa, mi tana kakau lokina na limana madoa, mi tana kakau lokina na tuana madoa aia na mane ara nauvania na vovorona na suisui. ");
INSERT INTO gri_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Mi muri ma na manetabu ke adia na turina na oela na olive me ke qetu bâ tana perana limana mauli segeni nogo ia, ");
INSERT INTO gri_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","me ke lumia kesa na kakauna na limana madoa i laona, me ke tsirikagini bâ ke vitu kalina i tana nogo i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Me ke adigotoa na turina na oela e totu nogo tana perana limana ma na turina na gabuna sipi, me ke molobavania tana rarauna na kulina madoa, mi tana kakau lokina na limana madoa, mi tana kakau lokina na tuana madoa aia na mane ara nauvania na aqona na suisui. ");
INSERT INTO gri_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mi muri maia ke molo bâ i lovana na mane ia na turina na oela e kauvisu tana perana limana. Ke nauvaganana nogo ia ti ke gini naua na aqona na suisui matena na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Mi tana ma na manetabu ke naua na savori-sausau matena na sasi, me ke naugotoa na aqona na suisui matena na mane ia. Mi murina ia, maia ke labumatesia na sipi agana na mani savori-kodokodo, ");
INSERT INTO gri_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","me ke savorikolua na sausau na uiti i kelana na belatabu. Ke nauvaganana nogo ia ti ke gini naua na aqona na suisui, ma na mane ia ke gini maletugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Me ti vaga na mane ia e tau tamani sa omea, me gini utu gana vania ke saua na vangana sui na savori vaga girani, ma nina aqo ke adia kesa moa na dalena sipi mane ke lia nina sausau na volivisu, aia nogo nina vangalaka dou bâ vania na Taovia me ke lia gana tuva na manetabu. Me ke adia kesa moa na kilo na pulaoa lalo koluginia ke labu tolu na dangana na oela na olive, agana na nauana na sausau na uiti. ");
INSERT INTO gri_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Me ke adimaigotoa ke ruka na kulukulu se na kurau, kesa agana na mani savori-sausau matena na sasi, me kesa agana na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Mi tana alunina dani maia ke saugira vania na manetabu i matsapana na Valepolo. ");
INSERT INTO gri_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Maia na manetabu ke adia na sipi ma na oela na olive, me ke saugira vaga kesa na vangalaka dou bâ vania na Taovia me ke lia gana tuva na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ma na manetabu ke labua na dalena sipi ia me ke adia na turina na gabuna, me ke molo bâ tana rarauna na kulina madoa na mane ia, mi tana kakau lokina na limana madoa, mi tana kakau lokina na tuana madoa. ");
INSERT INTO gri_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ma na manetabu ke qetu bâ na turina na oela tana perana limana mauli segeni nogo ia, ");
INSERT INTO gri_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","me ke lumia kesa na kakauna na limana madoa tana oela ia, me ke tsirikagini bâ ke vitu kalina i tana nogo i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Me ke molobagotoa na turina oela i tana aia e molonogoa na gabu: tana rarauna na kulina madoa na mane ia, mi tana kakau lokina na limana madoa, mi tana kakau lokina na tuana madoa. ");
INSERT INTO gri_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ma na turina na oela e totuvisu tana perana limana ke moloa i lovana na mane ia. Nina aqo ke nauvaganana nogo ia ti ke gini naua na aqona na suisui matena na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Mi muri, maia ke savoria kesa ka vidaqira na kulukulu se na kurau, ");
INSERT INTO gri_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","agana na savori-sausau matena na sasi, me ke kesa agana na savori-kodokodo, kolua na sausau na uiti. Ke nauvaganana nogo ia ti na manetabu ke gini naua na aqona na suisui matena na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Iani nogoria na vovorona na ketsa e kalea na tinoni e gadovia na mudo, me utugana vania na sauana na vangana popono na omea e kilia agana na suisui.” ");
INSERT INTO gri_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Na Taovia e tsarivanikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Kalina kamu sage tana vera ni Kanaan, i tana nogo inau au vangaraua na sauvaniamui kamu gini tamanina sailagi, ");
INSERT INTO gri_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","me ti vaga ke kesa ke tsodovulagia laka na Taovia e moloa na voko i laona valena maia nina aqo ke bâ i konina na manetabu me ke tsarivulagia vania. ");
INSERT INTO gri_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ma na manetabu ke ketsalia na tamanina na vale ia ke adiligigira talu pipi sui lakalaka nina omea tania na valena, ti aia ke bâ me ke vilekea na voko i laona; me ti vaga na tamanina ke tau adiligigira talu nina omea sui, migira ara totuvisu i laona sauba kara kaulinaqu goto. Mi muri ti na manetabu ke ba sage i laona na vale ia, ");
INSERT INTO gri_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","me ke vilekea na voko. Me ti ke reigira visana na tuputupu mamaraoga se tsitsiaga ara tuturiga na ganiana i laona na ponopono, ");
INSERT INTO gri_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","maia ke rutsuligi tania na vale ia, me ke ravekakaia, me ke vongoa i laona ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Mi tana vitunina dani maia ke visu me ke vileketugua na vale ia. Me ti vaga ke reia na voko ke gani babâ moa, ");
INSERT INTO gri_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","maia nina aqo ke raia na tamanina na vale ia ke loqoligigira na vatu voko me ke ba tsoniligigira kesa tana tsavutsavu i taba i tano tania na vera. ");
INSERT INTO gri_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Mi murina ia, ma nina aqo ke karimalegira na ponopono i laona na valena, me ke karogira sui na duduna na simente ara puka me ke tsoniligigira kesa tana tsavutsavu i taba i tano tania na vera. ");
INSERT INTO gri_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Me ke adigira na vatu vaolu me ke oliginigira na vatu aia e loqoligigira nogo, me ke adia na simente vaolu me ke poroginitugua na ponopono. ");
INSERT INTO gri_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Me ti vaga na voko ke labavisutugua tana vale ia murina kalina ara loqoligigira nogo na vatu seko, mara karimalegira nogo na ponopono mara poro vaolusigira nogo, ");
INSERT INTO gri_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ma na manetabu nina aqo ke bâ me ke reia. Me ti vaga na voko e tavosa babâ moa, ma na vale ia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ma nina aqo na tamanina ke toroveo poponoa, me ke karosaigira na vatuna, ma na gaina, ma na duduna na simente, me ke kalagaigira sui vano kesa tana tsavutsavu i taba i tano tania na vera. ");
INSERT INTO gri_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Me ti ke kesa ke ba sage i laona na vale ia kalina ara ravekakaisinogoa, maia ke kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Me ti vaga kesa ke ba tsaro se ke mutsagana i laona na vale ia, ma nina aqo ke tsagimalegira na polona. ");
INSERT INTO gri_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Me ti vaga kalina na manetabu ke mai na vilekeana tugua na vale ia, me ke tau reia na voko ke labavisutugua murina kalina ara poro vaolusitugua, maia sauba ke tsarivulagia laka na vale ia e tau nogo kaulinaqu, rongona na voko e nangaligi saikesa nogo. ");
INSERT INTO gri_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Magana ke gini suia na vale ia me ke gini male dou tugua, maia na tamanina ke adia ke ruka na manu, me ke visana tapana na gai na sida ma na kokolina na itai tsitsi ma na kokopuna na qoraqora me ke adigira sui vania na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Maia na manetabu ke ba matesia kesa ka vidaqira na manu i kelana kesa na popovatu i tana e totu na kô maroga ara vasini torea moa tana vuravura. ");
INSERT INTO gri_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Mi muri, maia ke adigira na tapana na gai na sida, ma na kokopuna na qoraqora, ma na kokolina na itai tsitsi kolua na manu mamauri, me ke lumi tsunagira sui tana gabuna na manu aia e matesinogoa, mi laona goto na kô ara vasini moa torea tana vuravura, me ke tsirikagini bâ tana vale ia ke vitu kalina. ");
INSERT INTO gri_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Mi tana nauvaganana ia, maia ke suia na vale ia kolua na gabuna na manu, ma na kô maroga, ma na manu mamauri, ma na tapana na gai na sida, ma na kokopuna na qoraqora ma na kokolina na itai tsitsi. ");
INSERT INTO gri_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Mi muri maia ke lovosia na manu mamauri me ke lovovano i taba i tano tania na vera tana poi mangasâ. Ke nauvaganana ia ti ke gini naua na aqona na suisui matena na vale ia, me ke maletugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Igirani nogo na vovorona na ketsa tana rongoqira na mudo; ");
INSERT INTO gri_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","na vora, na tsope ma na tsomo; ma na voko tana polo ma na vale. ");
INSERT INTO gri_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ma na ketsa girani ara vota makalia tana rongona ti kesa na omea ke kaulinaqu se ke totu male taonia na vovorona na lotu.” ");
INSERT INTO gri_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ma na Taovia e sauvanikaira goto a Moses ma Aaron na vovorona na ketsa girani ");
INSERT INTO gri_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","kara muria igira na tinoni ni Israel. “Kalina ti vaga kesa na mane ke tsodoa na saqerebei, ma na mane ia e tau male tana vovorona na lotu, ");
INSERT INTO gri_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","atsa moa ti vaga ke roro na butongo se ke ponotia na sautuna. ");
INSERT INTO gri_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Me ti vaga na mane ia ke totu se ke tsaro konina kesa na nige, ma na nige ia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Masei ti ke pelelea moa na nige ia, ");
INSERT INTO gri_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","se ke totu i konina sa omea e gini totu na mane ia, ma na tinoni ia nina aqo ke tsagimalea na polona me ke leso dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Masei ti vaga ke pelelea moa na mane e gadovia na lobogu vaga ia, ma nina aqo ke tsagimalea na polona me ke leso dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Me ti vaga na mane e gadovia na lobogu ia ke tsuvelia kesa aia e totu male tana vovorona na lotu, ma nina aqo na tinoni ia ke tsagimalea na polona me ke leso dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Me ti vaga na mane ia ke totukae i kelana na omea gana na totukae tana asi, ma na omea na totukae ia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Masei ti ke pelea moa sa omea na mane ia e gini totu ma na tinoni ia e totu kaulinaqu poi tsau tana ngulavi. Me ti vaga ke kesa ke kalagaia sa omea na mane ia e gini totu, ma nina aqo ke tsagimalea na polona me ke lesomale dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Me ti vaga na mane e gadovia na lobogu vaga ia ke pelea moa sa tinoni tavosi me ke tau vati vulia moa na limana, ma nina aqo na tinoni aia e pelea ke tsagimalegira na polona me ke lesomale dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Pipi na popovatu na mane ia ke pelea niqira aqo kara tairutua, me ti vaga kesa na popo gai aia ke pelea, ma niqira aqo kara vulimaledoua. ");
INSERT INTO gri_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Mi murina kalina ke sui na lobogu e gadovia na mane ia, ma nina aqo ke pitu talu ke putsi ke vitu na dani, mi muri ti ke tsagimalea na polona, me ke ba leso kesa tana kô vuravura male dou, maia sauba ke maletugua tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Mi tana alunina dani ma nina aqo na mane ia ke adi bâ ke ruka na kulukulu se na kurau i matana na Valepolo i tana e totu na Taovia me ke saukaira vania na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ma na manetabu ke savoria kesa ka vidaqira vaga na savori-sausau matena na sasi, ma na rukanina ke nauginia na savori-kodokodo. Ke nauvaganana ia ti ke gini naua na aqona na suisui matena na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Mi kalina ti vaga kesa mane ke tavongani rutsu lê na konagana, nina aqo ke lesovimalea na konina popono, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ti ke puka i konina kesa na polo se kesa na omea ara aqosiginia na kokorana na omea tuavati, ma nina aqo ke vulimalea na omea ia, me totu kaulinaqu moa poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mi murina kara ka vainaugi kaira na mane ma na daki ma ka niqira aqo kara ka lesomale dou, mara ka totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Mi kalina ti ke laba nina tagu na reivula kesa daki, ma na daki ia e totu kaulinaqu i laona ke vitu na dani. Masei ti vaga ke pelelea moa na daki ia maia e totu kaulinaqu goto poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ma na omea sui aia ke gini totu, se ke gini tsaro tana tagu aia e reivula, igira sui ara kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Masei ti vaga ke pelelea moa na nigena na daki ia se na omea aia e gini totu, ma nina aqo ke tsagimalea na polona me ke leso dou, me totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Me ti vaga kesa na mane ke tsarokolua na daki ia tana tagu aia e reivula, ma na mane ia e savunigotoa nina kaulinaqu na daki ia, maia goto e gini kaulinaqu i laona e vitu na dani, ma na nige tana aia e tsaro e kaulinaqu goto. ");
INSERT INTO gri_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Ti vaga ke kesa daki ke tavongani reivula visana na dani kalina e tau vati tsau moa nina tagu, se ke reivula babâ moa kalina e sui nina tagu, ma na daki ia e gini kaulinaqu tana tagu popono e vanoli gabu, vaga nogo tana tagu kalina aia e reivula laka. ");
INSERT INTO gri_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Me ti vaga sa nige aia ke tsaro i konina, se sa omea ke gini totu tana tagu vaga ia, ma na omea ia e kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Masei ke pelelegira moa na omea ia maia goto e kaulinaqu, ma nina aqo ke tsagimalea na polona me ke leso dou; me gini totu kaulinaqu poi tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Mi kalina ke sui na reivula ma nina aqo ke pipitu goto ke vitu na dani, ti aia ke male tugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Mi tana alunina dani maia ke adia ke ruka na kulukulu se na kurau, me ke ba sauvania na manetabu i matsapana na Valepolo i tana e totu na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ma na manetabu sauba ke savoria kesa ka vidaqira agana na savori-sausau matena na sasi, me ke kesa agana na savori-kodokodo, ti ke gini naua na aqona na suisui matena na daki ia. ");
INSERT INTO gri_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Ka nimui aqo nogo kagamu kamu ka parovatavigira kakai na toga ni Israel tana rongona na naqu vaga ia tana koniqira, ma kara tau ba sage tana niqu Valepolo Tabu aia e totu i levugaqira ma kara naqugasia. Me ti vaga kara nauvaganana ia, me sauba kara mate.” ");
INSERT INTO gri_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Igirani nogo na ketsa ara kalea tana rongona kesa mane kalina e tsodoa na saqerebei, se ke rutsumilea na konagana, ");
INSERT INTO gri_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","mi tana rongona kesa daki kalina aia e reivula, se kalina kesa na mane e maturu kolua kesa na daki aia e totu kaulinaqu moa tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Na Taovia e goko vania a Moses murina ka mateaqira kaira na dalena mane a Aaron, rongona ara ka gini savoria na lake lê vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Me tsarivaganana iani, “Ko tsarivania a Aaron na tasimu ke laka saikesa na tavongani sage bâ tana Nauna Tabu Loki Sosongo i murina na polo katsi. Ke sage bâ tana tagu lelê moa inau kau titivania, rongona i tana nogo inau au totu i laona na parako i kelana na vovongona na Bokisi na Taso. Me ti vaga aia ke petsakoe me ke tavongani sage bâ maia sauba ke mate. ");
INSERT INTO gri_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Idavia ke sage bâ tana Nauna Tabu Loki Sosongo ma nina aqo ke adimai talua ke kesa na buluka mane vaolu agana na savori-sausau matena na sasi me ke kesa na sipi mane agana na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ke lesomale dou talu, me ke sageligira na polona na manetabu: na polokatsi vovosi laka, ma na polo ni laona, na itai na soripolo, ma gana kepi. ");
INSERT INTO gri_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Migira na saikolu popono ni Israel kara adimai vania a Aaron ke ruka na naniqoti mane agana na savori-sausau matena na sasi, me ke kesa na sipi mane agana na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Maia nina aqo ke savori idatalua ke kesa na buluka mane agana na mani kodoputsa mateqira nina sasi segeni nogo ia migira sui i valena. ");
INSERT INTO gri_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Mi muri, maia ke adibakaira na naniqoti mane i matsapana na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Mi tana maia ke gini tsonikutsu ruka na vatu, i konina kesa ara kiria na goko vaga iani ‘vania na Taovia’, mi konina kesa ‘vania a Asasel’. ");
INSERT INTO gri_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Maia Aaron nina aqo ke gini savori-sausau matena na sasi na naniqoti e gado tana tsonikutsu laka nina na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ma na naniqoti e gado tana tsonikutsu laka nina Asasel nina aqo a Aaron ke adimamauri bâ vania na Taovia, mi muri me ke molovanoa vania Asasel i laona na kaomate, agana ke gini kalagailigigira niqira sasi na toga. ");
INSERT INTO gri_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Mi kalina a Aaron ke tû na savoriana na buluka mane agana na sese matena nina sasi segeni ia migira sui i valena, ");
INSERT INTO gri_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","maia ke adia na tapala tapetape, me ke molotsavua i konina na madaova gagâ e adia tana belatabu, me ke ruka na kakarona na bulunagai uruuru laka, me ke adivanogira i laona na Nauna Tabu Loki Sosongo. ");
INSERT INTO gri_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Mi tana, i mataqu inau na Taovia, aia ke ba moloa na bulunagai uruuru tana lake, ma na punguna na bulunagai uruuru ke poisi poponoa na vovongona na Bokisi na Taso, rongona ke gini utu vania na reiana me ke tau mate. ");
INSERT INTO gri_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Maia ke adia na turina na gabuna na buluka me ke lumia na kakauna i laona me ke tsirikagini bâ i kelana na vovongona, mi muri me ke tsirikagini ba gotoa ke vitu kalina i matana na Bokisi na Taso. ");
INSERT INTO gri_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Mi murina ia, maia ke matesia na naniqoti gana na savori-sausau matena niqira sasi na toga, me ke adisagea na gabuna i laona na Nauna Tabu Loki Sosongo, me ke tsirikagini bâ tana vovongona, mi matana na Bokisi na Taso vaga nogo na omea e nauginia na gabuna na buluka. ");
INSERT INTO gri_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mi tana nauvaganana nogo ia, ti aia ke gini pungua na Nauna Tabu Loki Sosongo tania na naquqira ma niqira sasi sui na toga ni Israel. Nina aqo aia ke nauvaganana vania na Valepolo, rongona na Valepolo ia e totu i levugana patupatu na nauna tana ara tototu igira, ma na nauna ia e tau masidi tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Me ke tû kalina a Aaron ke sage bâ na nauana na aqona na punguana na Nauna Tabu Loki Sosongo me ke tsau kalina aia ke rutsumai, ke laka goto na totu ke kesa i laona na Valepolo. Mi kalina aia ke nausuinogoa na aqona na suisui matena nina sasi segeni nogo, ma niqira sasi goto nina tamadale, ma na saikolu popono, ");
INSERT INTO gri_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","maia nina aqo ke rutsu tania na Valepolo me ke bâ pungugotoa na belatabu agana na savori-kodokodo. Ke adigotoa na turina na gabuna na buluka mane ma na naniqoti, me ke saluvaginitugira popono na gai ara tu katsadato tana vati tsukena na belatabu. ");
INSERT INTO gri_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Me ke lumia na kakauna tana gabu me ke tsirikagini bâ ke vitu kalina tana belatabu. Mi tana nauvaganana ia aia ke punguginia na belatabu tania niqira sasi na toga ni Israel me ke gini totu maletugua.” ");
INSERT INTO gri_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ma na Taovia e tsarigotoa, “Kalina a Aaron ke nausuinogoa na aqona na punguana na Nauna Tabu Loki Sosongo kolua na Valepolo popono ma na belatabu, maia nina aqo ke sauvania na Taovia na naniqoti mamauri e gado tana tsonikutsu laka aia nina a Asasel. ");
INSERT INTO gri_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Maia ke molokaekaira na limana i lovana na naniqoti ia me ke katevulagigigra pipi sui lakalaka na omea seko ara naua, ma niqira sasi ma niqira petsakoe igira na toga ni Israel, mi tana nauvaganana ia aia ke molobagira sui tana lovana na naniqoti ia. Mi muri me ke molovania kesa na mane ke tsialigi bâ tana kaomate. ");
INSERT INTO gri_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ma na naniqoti ia sauba ke kalagailigigira pipi sui niqira sasi kesa tana nauna mangu lê. ");
INSERT INTO gri_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Mi muri, maia Aaron ke sagetugua i laona na Valepolo, me ke tsoraligigira na polona manetabu aia e sageligira nogo tana idana aia e ba sage tana Nauna Tabu Loki Sosongo, me ke mololegira i tana. ");
INSERT INTO gri_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Maia ke ba leso kesa tana nauna tabu me ke sageligira tugua na polona segeni. Mi murina ia, ti aia ke rutsu i tano me ke naua na savori-kodokodo matena nina sasi segeni ma niqira sasi na toga sui. ");
INSERT INTO gri_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ke kodoa tana belatabu na seregana na omea tuavati agana na savori-sausau matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Maia na mane e tsiavanoa na naniqoti vania a Asasel tana kaomate, nina aqo ia ke tsagimalegira na polona me ke lesomale dou ti ke visumaitugua i vera. ");
INSERT INTO gri_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kaira na buluka mane ma na naniqoti ara gini aqo tana savori-sausau matena na sasi, ma ka gabuqira ara adivanonogoa i laona na Nauna Tabu Loki Sosongo gana na gini aqo tana veoligiana na sasi, kara adivanokaira i taba tania na vera, ma kara ba kodogira sui na kokorana, ma na lakana, ma na tinaena. ");
INSERT INTO gri_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ma na tinoni e kodogira na omea girani nina aqo ke tsagimalegira na polona, me ke lesomale dou, ti ke visumaitugua i vera.” ");
INSERT INTO gri_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Me goko moa na Taovia me tsaria, “Igirani nogo na vovorona na ketsa niqira aqo kara murigira tana tagu sui ke mai. Tana sangavulunina dani i laona na vitunina vula igira na Israel migira na tinoni ni veratavosi igira ara mauri i laoqira, niqira aqo kara tsonivitoaqira segeni ma kara tau goto pelea sa aqo. ");
INSERT INTO gri_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Mi tana dani nogo ia kara naua na aqona na suisui kara gini tanusi tania niqira sasi, ma kara gini masidi doutugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ma na dani ia, na dani tabu loki sosongo, na dani i tana igira kara tsonivitoaqira segeni ma kara tau saikesa pelea sa aqo. Na vovorona na ketsa girani niqira aqo kara murigira tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Maia moa na Mane Tabu Loki, aia ara tabua mara molokaea ke tangolidatoa nina aqo na tamana, aia moa e ulagana ke naua na aqona na suisui. Me ke sageligira na polona manetabu ");
INSERT INTO gri_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","me ke pungua na Nauna Tabu Loki Sosongo, kolua na Valepolo popono, ma na belatabu, me ke naua na aqona na suisui mateqira na manetabu migira na toga popono ni Israel. ");
INSERT INTO gri_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Na vovorona na ketsa girani niqira aqo kara murigira tana tagu sui ke mai. Na aqo tabu iani kara aqosia kesa kalina i laona pipi na ngalitupa na mani veoligiaqira niqira sasi na toga ni Israel.” Migira ara nauvaganana nogo na Taovia e ketsaliginia a Moses ke naua. ");
INSERT INTO gri_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ke sauvania a Aaron ma na dalena migira sui lakalaka na tinoni tana Israel na vovorona na ketsa girani. ");
INSERT INTO gri_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","“Ti vaga kesa na tinoni ni Israel ke labu bamailea i laona na vera se tabana i tano sa nina buluka, se sa nina sipi, se sa nina naniqoti, agana na savori vaniana na Taovia, me ke tau adimaia ieni tana matsapana na Valepolo i tana e totu na Taovia, ma na tinoni ia e sasi sosongo vaga moa ti ke naua na labu tinoni, ma niqira aqo kara tsidavaginia tania niqira saikolu igira nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ma na rongona na ketsa iani, laka tû kalina eni me ke bâ, niqira aqo igira na tinoni ni Israel kara laka goto na matesiana niqira omea tuavati tana nauna tavosi bamai lê. Kara adimaigira vania na manetabu i matsapana na Valepolo i tana e totu na Taovia, mi tana nogo kara matesigira agana na savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ma na manetabu ke tsirikagini bâ na gabuna tana vati liligina na belatabu e totu i matsapana na Valepolo, me ke kodoa na seregana, rongona na vuruna ke punâ na Taovia me ke gini laona. ");
INSERT INTO gri_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ma niqira aqo na tinoni ni Israel kara tau goto petsakoe vania na Taovia ma kara ba labugira niqira omea tuavati visana tana nauna bamai lê ma kara savorigira vanigira na tidao. Migira na tinoni ni Israel niqira aqo nogo kara muria na vovorona na ketsa iani tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Ti vaga ke kesa vidaqira na tinoni ni Israel se ke kesa na tinoni ni veratavosi aia e mauri i laoqira ke savoria kesa na savori-kodokodo, se ke kesa goto na vatana na kodoputsa ");
INSERT INTO gri_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","vania na Taovia me ke tau goto naua i matsapana na Valepolo, na tinoni vaga ia kara tsidavaginia tania niqira saikolu igira nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Me ti vaga ke kesa vidaqira na tinoni ni Israel, se ke kesa na tinoni ni veratavosi e mauri i laoqira, ke gania na velesi kolu gabu i konina, minau sauba kau piloligi tania, ma kau tsidavaginia tania niqira saikolu igira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Na maurina pipi sui lakalaka na omea mamauri e totu tana gabu, maia nogo na rongona ti inau au moloketsana laka na gabu sui popono kara qetu bâ tana belatabu, agana na mani veoligiana niqira sasi na tinoni. Na gabu, aia na pukuna na mauri, maia segeni e susuliga na veoligiana niqira sasi na tinoni. ");
INSERT INTO gri_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Aia nogoria na rongona ti au tsarivanigira na tinoni ni Israel laka igira se sa vidaqira na tinoni ni veratavosi ara mauri i laoqira, kara laka saikesa na ganiana sa velesi kolu gabu i konina. ");
INSERT INTO gri_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Me ti vaga sa vidaqira na tinoni ni Israel, se sa tinoni ni veratavosi e mauri i laoqira ke ba rugu, me ke adia sa omea tuavati se sa manu ke tau valiqira na ganiana, maia nina aqo ke reotsunâ na gabuna tana kao me ke saropunua. ");
INSERT INTO gri_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Na maurina pipi sui na omea mamauri e totu tana gabu, maia nogoria na rongona ti au ketsaligira na tinoni ni Israel kara laka na ganiana sa velesi kolu gabu i konina. Me ti vaga ke kesa ke nauvaganana ia, me sauba kau tsidavaginia tania niqira saikolu niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Me ti vaga sa tinoni, atsa moa na tinoni ni Israel se sa tinoni ni veratavosi, ke gania na velesina na omea tuavati e mate segenina, se kara gati matesia na omea tuavati atsi, ma nina aqo ke tsagimalea na polona me ke lesomale dou, me ke totu kaulinaqu poi tsau tana ngulavi, mi tana ti aia ke maletugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Me ti vaga ke tau nauvaganana ia, maia sauba ke gadovikede.” ");
INSERT INTO gri_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Maia na Taovia e tsarivania a Moses ");
INSERT INTO gri_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ke tsarivanigira na tinoni ni Israel, “Inau nogoria na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kamu laka na muriaqira niqira sasaga igira na tinoni ni Ejipt, i tana amu totu nogo i sau, se niqira sasaga na tinoni ara totu tana kao ni Kanaan i tana inau au adigamu bâ kalina ia. ");
INSERT INTO gri_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kamu murigira niqu ketsa ma kamu naugira na omea sui au ketsaliginigamu. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kamu muridougira niqu vali ma niqu ketsa au saua vanigamu; me ti kamu nauvaganana ia, me sauba kamu gini mauri. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Kamu laka na vainaugi koluana kesa vidaqira na kamamui. ");
INSERT INTO gri_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Kamu laka na paluvangamana na tamamui tana vainaugi koluana na tinamui. Ma kamu laka goto na paluvangamana na tinamui segeni. ");
INSERT INTO gri_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ma kamu laka goto na paluvangamana na tamamui tana vainaugi koluana kesa vidaqira na tauna tavosi. ");
INSERT INTO gri_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Me vali vanigamu goto na vainaugi koluaqira na vavinemui, se kesa segeni na dalena daki na tamamui se na tinamui, atsa moa ti na baka daki ia kara kutisaigamu i laona kesa moa vale se tagara. ");
INSERT INTO gri_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ma kamu laka goto na vainaugi koluana na dalena daki kesa na dalemu; na omea vaga ia ke paluvangamamui sosongo. ");
INSERT INTO gri_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Kamu laka goto na vainaugi koluana na dalena daki kesa goto na tauna tamamui rongona aia kesa goto na vavinemui igamu. ");
INSERT INTO gri_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Kamu laka na vainaugi koluana na vavinena na tamamui, rongona aia na kamana varavara na tamamui. ");
INSERT INTO gri_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Kamu laka na vainaugi goto koluana na tasina daki na tinamui, rongona aia na kamana varavara na tinamui. ");
INSERT INTO gri_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Kamu laka na vainaugi koluana na tauna na tamamui tetelo; rongona aia goto na kamamui varavara. ");
INSERT INTO gri_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Kamu laka goto na vainaugi koluana na tauna na dalemui mane ");
INSERT INTO gri_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","se na tauna kesa na tasimui mane. ");
INSERT INTO gri_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kamu laka goto na vainaugi koluana kesa na dalena daki se na kukuana kesa na daki aia igoe o vainaugi kolunogoa; e tau utu kara kamaga sai kolugamu, mi tana igamu amu gini tsio. ");
INSERT INTO gri_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kamu laka goto na taugaana kesa na tasina daki na taumui kalina e mamauri moa na taumui. ");
INSERT INTO gri_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Kamu laka goto na vainaugi koluana kesa na daki kalina e laba nina tagu na reivula, rongona tana tagu vaga ia maia e kaulinaqu tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Kamu laka goto na vainaugi koluana na tauna kesa na mane tavosi; rongona sauba ke naua ma kamu gini kaulinaqu tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Kamu laka na sauana kesa vidaqira na dalemui agana kara gini kodoputsa vania Molek na god peropero, rongona tana nauvaganana ia igamu amu gini paluvangamana na asana God nimui Taovia. ");
INSERT INTO gri_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ke laka goto kesa na mane na vaitsovogi koluana kesa na mane tavosi; God e reisavi sosongolia na sasaga vaga ia. ");
INSERT INTO gri_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ke laka goto kesa na mane se kesa na daki na vainaugi koluana kesa na omea tuavati; na taposasa vaga ia e tau goto tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Kamu laka goto na nauana sa vatana na sasaga vaga girani ma na gini kaulinaqu tana vovorona na lotu, rongona ara nauvaganana nogo igira na ponotoba, mara gini kaulinaqu igira sui ara totu ida nogo tana kao iani, maia nogo na Taovia e tsialigigira rongona kamu gini sagemai igamu. ");
INSERT INTO gri_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Niqira sasaga tabaru igira ara sisi loboloboginia na kao popono me gini maresibiga, maia nogo na rongona ti na Taovia e kedeginia na kao ia, ma na kao ia e sove tanigira popono igira na tinoni ara totu ida nogo i laona. ");
INSERT INTO gri_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","Igira ara naugira na omea maresibiga vaga girani, mara naua me gini kaulinaqu goto na kao ia, migamu nimui aqo kamu laka na reinunu i koniqira. Pipi gamu sui lakalaka, atsa moa ti na tinoni ni Israel se na tinoni ni veratavosi ara totu i laomui, nimui aqo kamu muridougira sui pipi nina vali ma nina ketsa na Taovia, ");
INSERT INTO gri_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","mi tana ti sauba na kao ke gini tau sove tanigamu, vaga e sove tanigira igira na ponotoba ara totu ida nogo i tana. ");
INSERT INTO gri_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Igamu amu dona nogo laka asei moa ti vaga ke naugira na vatana na omea maresibiga vaga girani, sauba kara tsidavaginia tania niqira saikolu igira nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Kamu muridougira na ketsa ma na vali inau au saunogoa vanigamu, ma kamu laka goto na reinunu tana niqira omeomea igira na tinoni ara totu idanogo tana kao iani, ma kamu laka na nauana sa vidaqira na omea vaga girani ma na gini kaulinaqu i mataqu inau. Inau nogo na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Maia na Taovia e tsarivania a Moses ");
INSERT INTO gri_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ke tsarivaganana iani vanigira na saikolu popono tana Israel, “Nimui aqo kamu doulaka vaga nogo inau na Taovia nimui God au doulaka. ");
INSERT INTO gri_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Pipi kesa vidamui nina aqo ke kukuni tanikaira na tinana ma na tamana, me ke muridoua na ketsa na mango tana Dani na Sabat, vaga nogo inau au moloketsana vanigamu. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Kamu laka na piloligi taniaqu ma na samasama vaniaqira na titinonina na god peropero; ma kamu laka goto na aqosiginiana na tapala na nunuqira na god peropero ma na samasama vaniaqira. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Mi kalina kamu labua kesa nimui omea tuavati agana na mani savori-kodoputsa tangomana na tinoni kara ganipatâ na turina, migamu kamu muridougira na vovorona na ketsa inau au saunogoa vanigamu, mi tana ti inau sauba kau tabea nimui sausau. ");
INSERT INTO gri_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ma nimui aqo kamu gania na velesina na omea tuavati ia tana dani nogo amu labumatesia, se tana dani ngana. Me ti vaga visana na velesina kara tototu moa tsau tana tolunina dani ma nimui aqo kamu kodoligigira, ");
INSERT INTO gri_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","rongona ara tau nogo male taonia na vovorona na lotu, me ti vaga ke kesa ke gania, me sauba inau e utu goto kau tabea na adiana nina sausau. ");
INSERT INTO gri_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Masei moa ke gania sauba ke loaga matena, rongona e tau kukuni tania na omea ara balonogoa vaniau, minau sauba kau tsidavaginia tania niqira saikolu igira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Mi kalina kamu tsurivia nimui uta ma kamu laka na adiaqira na uiti ara totu tana tsavuna uta, ma kamu laka goto na visubatugua ma na tsakoaqira igira ara kauvisu. ");
INSERT INTO gri_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ma kamu laka goto na visu ma na pitsuaqira na vuana na uaeni ara kauvisu se na tsakoaqira na vuana ara dudu segeni; mologira ma kara totuvisu vanigira na tinoni ara tau tamanina sa omea migira goto na tinoni ni veratavosi. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Kamu laka goto na komi, se na peqo se na pero. ");
INSERT INTO gri_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kamu laka na gini vatsa pero na asaqu inau, rongona ti kamu nauvaganana ia mamu gini paluvangamana na asaqu inau. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Kamu laka na peqoleana kesa tinoni se na komiana nina omea. Kamu laka na tangolivisuana na vovolina nina aqo kesa tinoni e aqo vanigamu, kamu laka goto na pituana ke tsau tana dani i muri. ");
INSERT INTO gri_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kamu laka goto na asu vaniana na tinoni e mui kulina, se na molo kapusiana kesa na omea tana sautu i tana ke liu bâ na tinoni e koko matana rongona ke gini tubulagi i konina. Kamu mataguniau inau. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Kamu naua na pedegoto kalina kamu tinete; kamu laka na sanga kesa tabana kalina amu pedegira na tinoni ara tau tamani sa omea, se na mataguniaqira igira ara tamani omea danga. ");
INSERT INTO gri_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Kamu laka na govula gokopero tana rongona kesa tinoni. Mi kalina ti vaga kesa tinoni ara raqâ tana tinete rongona aia e tsukia kesa na sasi loki, migamu amu tangomana kamu sangâ tana goko e dou kamu ba sangâ. E tau dou kamu mui lê, ma kara pedematesia. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Kamu laka goto na molotoba vaniana ke kesa, kamu tovoa moa na vaigotosigi koluana rongona kamu gini tau puka tana sasi tana rongona na tinoni vaga ia. ");
INSERT INTO gri_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kamu laka na tangotugu se na reisaviana babâ moa kesa tinoni, nimui aqo kamu galuvegira na kulamui vaga igamu amu galuve segenimui. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Kamu muridougira niqu ketsa ma niqu vali. Kamu laka na tamiana kesa vatana segeni na buluka ke tsauvia nimui buluka; laka goto na tsukana ke ruka tavosi na vatana na mutsa i laona kesa moa na uta. Kamu laka na sageliana na polo ara vosiginia ruka tavosi na vatana na terete. ");
INSERT INTO gri_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Me ti vaga kesa na mane ke sasi kolua kesa na baka daki tseka aia ara anevaninogoa kesa na mane tavosi mara tau moa vati vutia, se kara tau vati tamivania ke tanusi tania nina totu tseka, me sauba kara kedekaira moa, me utu kara matesikaira rongona na baka daki ia e totu tseka moa. ");
INSERT INTO gri_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Nina aqo moa na mane ia ke adi bâ ke kesa na sipi mane i matsapana na Valepolo i tana au totu inau vaga nina sausau na volivisu, ");
INSERT INTO gri_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ma na manetabu ke nauginia na aqona na suisui gana na veoligiana nina sasi na mane ia, ma God sauba ke padale vania nina sasi. ");
INSERT INTO gri_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Mi kalina kamu ba sage tana kao ni Kanaan ma kamu tsukagira pipi vatana na gai mutsamutsa, me vali vanigamu na ganiana na vuaqira i laona ke tolu ngalitupa. ");
INSERT INTO gri_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mi tana vatinina ngalitupa kamu balovaniau inau na vuaqira sui lakalaka na gai mutsamutsa vaga nimui sausau na mani soadouaqu inau na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mi tana tsegenina ngalitupa migamu kamu ganigira rago gamui vuana gai mutsamutsa. Me ti vaga igamu amu naua na omea sui girani, me sauba pipi sui nimui gai mutsamutsa kara vungu sosongo bâ. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Kamu laka na ganiana sa velesi kolu gabu i konina. Kamu laka goto na gini aqo pipi vatana na sosolo, na ketso ma na basutidao. ");
INSERT INTO gri_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kamu laka na putsiana na ivu tana ruka tabana na rauvilamui, se na tsaraligiana moa sa turina na ngolamui, ");
INSERT INTO gri_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","se na rapuana na kokoramui, se na pariana na konimui na mani sauvulagiana laka amu melu tana rongona na tinoni mate. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Kamu laka na paluvangamaqira na dalemui daki ma na moloaqira kara lia na rebina niqira valetabu na ponotoba; me ti vaga kamu nauvaganana ia, migamu goto sauba kamu mololeau inau ma kamu pilo bâ i koniqira na god tavosi, ma na sasi moa ke dangadato i laona na veramui. ");
INSERT INTO gri_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kamu muridoua na ketsa na mango tana Sabat, ma kamu kukuni tania na nauna i tana ara samasama vaniau inau. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Kamu laka na rageviaqira na tinoni ara dona na basutidao. Me ti vaga kamu nauvaganana ia, me sauba kamu kaulinaqu tana vovorona na lotu. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Kamu kukuni tanigira na tuqatuqa ma na dakidaki ma kamu padalokigira. Ma kamu kukuni taniau goto inau na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Kamu laka na rotasiaqira igira na tinoni ni veratavosi ara totu i laomui. ");
INSERT INTO gri_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kamu naudou vanigira vaga nogo igamu amu naudoua vanigira gamui verakolu na Israel, ma kamu galuvegira vaga nogo igamu amu galuve segenimui. Kamu padatugua laka i sau igamu goto amu rota na totu tsinogo tana vera ni Ejipt. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Kamu laka na peqoana ke kesa tana gini aqo na tovo omea ara tau mana, vaga tana tovo katsina se na tovo mamava se na tovo dangana. ");
INSERT INTO gri_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kamu gini aqo moa na tovo omea ara mana, na tovo katsina manana, na tovo mamava manana, ma na tovo dangana manana. Inau na Taovia nimui God, minau nogo au adirutsumigamu tania na Ejipt. ");
INSERT INTO gri_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kamu muridougira sui pipi niqu ketsa ma niqu vali. Inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Na Taovia e tsarivania a Moses ");
INSERT INTO gri_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ke tsarivanigira na toga ni Israel, “Ti kesa vidamui igamu se sa vidaqira na tinoni ni veratavosi ara totu i laomui ke saua na dalena ke lia agana na mani kodoputsa vaniana Molek na god peropero, ma na saikolu popono kara taimatesiginia na vatu. ");
INSERT INTO gri_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Me ti vaga ke kesa ke sauvaganana ia sa dalena vania Molek na god peropero, maia e naqugasia niqu Valepolo Tabu me paluvangamana na asaqu tabu inau, minau sauba kau piloligi tania ma kau tsidavaginia tania niqira saikolu niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Me ti vaga na saikolu popono kara reilea na sasaga e naua na tinoni ia ma kara tau pedea ke mate, ");
INSERT INTO gri_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","minau segeniqu nogo sauba kau piloligi tania kolugira nina tamadale popono, me tanigira goto ara muria tana samasama vaniana Molek. Minau sauba kau tsidavaginigira sui tania niqira saikolu niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Me ti vaga ke kesa ke ragevigira na tinoni ara dona na basutidao, minau sauba kau piloligi tania aia, ma kau tsidavaginia tania niqira saikolu niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kamu parovatavi segenimui me ke doulaka nimui sasaga, rongona inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kamu muridougira sui niqu ketsa ma niqu vali, rongona inau na Taovia au naua migamu amu gini doulaka. ");
INSERT INTO gri_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Asei moa ti ke vealaginia na tamana se na tinana, ma nimui aqo kamu matesia. Aia segenina nogo e alomaia gana matemate. ");
INSERT INTO gri_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Me ti vaga kesa na mane ke kibogasia na tauna kesa gana verakolu, ma nimui aqo kamu matesikaira sui na mane ma na daki ia. ");
INSERT INTO gri_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Me ti vaga kesa na mane ke vainaugi kolua kesa vidaqira igira na tauna na tamana maia e paluvangamana na tamana segeni, ma nimui aqo kamu matesikaira sui na mane ma na daki ia. Ara ka alomai segenia ka gaqira matemate. ");
INSERT INTO gri_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Me ti vaga kesa na mane ke vainaugi kolua na tauna na dalena mane, ma nimui aqo kamu matesikaira sui na mane ma na daki ia. Ara ka tsio mara ka alomai segenia ka gaqira matemate. ");
INSERT INTO gri_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Me ti kesa na mane ke vainaugi kolua kesa goto na mane, mi kaira sui ara ka naua na omea e maresibiga loki sosongo, ma nimui aqo kamu labumatesikaira sui. Ara ka alomai segenia ka gaqira matemate. ");
INSERT INTO gri_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Me ti vaga ke kesa na mane ke taugâ kesa na daki kolugotoa na tinana, ma nimui aqo kamu kodo matesitugira sui, rongona na omea paluvangamaga loki ara tu naua. Na omea vaga ia ke laka saikesa na labadato i laomui. ");
INSERT INTO gri_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Me ti vaga kesa na mane ke vainaugi kolua kesa na omea tuavati, ma kamu labumatesikaira sui na mane ma na omea tuavati ia. ");
INSERT INTO gri_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Me ti vaga kesa na daki ke tovolea na vainaugi koluana kesa na omea tuavati, ma kamu labumatesikaira sui na daki ia ma na omea tuavati. Kaira ara ka alomai segenia ka gaqira matemate. ");
INSERT INTO gri_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Me ti vaga kesa na mane ke taugâ na vavinena segeni, se na dalena daki kesa segeni goto na tauna tamana, ma nimui aqo kamu palu ka vangamaqira i mataqira na toga, ma kamu tsonitsunakaira tania nimui saikolu. Na mane ia e tsiogana, ma nina aqo ke gadovikedena. ");
INSERT INTO gri_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ti vaga kesa na mane ke vainaugi kolua kesa na daki kalina e laba nina tagu na reivula, ma nimui aqo kamu tsonitsunakaira tania nimui saikolu, rongona ara ka kutsia na vali na kaulinaqu tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Me ti vaga kesa na mane ke vainaugi kolua na tinana tetelo, se na tasina daki na tamana, sauba kara ka gadovikedena rongona ara ka tsio. ");
INSERT INTO gri_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Me ti vaga ke kesa na mane ke vainaugi kolua na tauna na niana, maia e paluvangamana sosongo na niana, mi kaira na mane ma na daki sauba kara ka gadovikedena; sauba ke utu goto kara ka tamanina sa ka daleqira. ");
INSERT INTO gri_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Me ti vaga kesa na mane ke taugâ na tauna na tasina, me sauba ke utu goto kara ka tamanina sa ka daleqira. Aia e naua na omea e gini kaulinaqu tana vovorona na lotu, me paluvangamana na tasina. ");
INSERT INTO gri_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Kamu muridougira pipi sui niqu ketsa ma niqu vali, rongona ke tau tsonilegamu na kao ni Kanaan i tana inau nogo au adigamu bâ. ");
INSERT INTO gri_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Kamu laka na muriana niqira lavu igira na tinoni ara mauri i tana. Inau nogo au tsialigigira na ponotoba ara totu i tana rongona igamu kamu gini totuvia niqira kao. Igira ara lavu na nauana na omea seko sui girani, te au gini reisavigira. ");
INSERT INTO gri_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Minau au vekenogoa vanigamu laka na kao lakataga me vangaga dou sosongo iani ke lia na tamanimui igamu, me sauba nomoa kau tusua vanigamu. Inau nogo na Taovia nimui God, mau vililigigamu tanigira sui na vera tavosi. ");
INSERT INTO gri_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Me vaga ia, ma kamu parovata, ma kamu dona na reigadoviana na omea tuavati ma na manu ara masidi tana vovorona na lotu, migira ara tau masidi. Kamu laka na ganiana sa omea tuavati se sa manu e vali na ganiana. Inau nogo au tsarivanigamu laka ara valimui na ganiana, me ti vaga kamu ganigira moa me sauba kamu gini kaulinaqu i mataqu inau. ");
INSERT INTO gri_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Nimui aqo kamu doulaka ma kamu lia niqu tamani segeni moa inau, rongona inau na Taovia minau au doulaka. Inau nogo au vilivotagamu tanigira sui na vera tavosi rongona kamu gini lia niqu tamani segeni moa inau. ");
INSERT INTO gri_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Me ti vaga kesa na mane se kesa na daki ke basutidao, ma nimui aqo kamu taimatesia. Masei ke nauvaganana ia e alomai segenia gana matemate.” ");
INSERT INTO gri_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Maia na Taovia e ketsalia a Moses ke tsarivaganana vanigira na manetabu tana duli konina a Aaron, “Ke laka goto sa manetabu na nauana kesa na omea ke gini kaulinaqu tana vovorona na lotu, me ke sangâ tana aqona na qiluana na konina kesa na kamana kalina ke mate, ");
INSERT INTO gri_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ti vaga e tau na tinana, se na tamana, se na dalena mane, se na dalena daki, se na tasina, ");
INSERT INTO gri_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","se kesa na vavinena e tau vati tauga me totu moa i valena. ");
INSERT INTO gri_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Me ke laka goto na nauana me ke gini kaulinaqu tana mateaqira igira ara kamaga kolua tana vaitaugagi. ");
INSERT INTO gri_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Ke laka goto sa manetabu na tsarana sa tabana na lovana, se na tsaraligiana moa sa turina na ngolana, se na pariana na konina, na mani sauvulagiana laka aia e roku. ");
INSERT INTO gri_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Nina aqo ke totu male dou saviliu, me ke laka goto na paluvangamana na asaqu inau. Aia nogo e savorigira na sausau na mutsa vaniau, maia nogoria na rongona ti e kilia ke totu male dou saviliu. ");
INSERT INTO gri_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Na manetabu ke laka na taugaana kesa na daki rebi, se na daki e reimane nogo, se sa daki e tsonitsunanogoa sa mane; rongona na manetabu nina aqo ke totu male dou saviliu tana aqo vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Niqira aqo na tinoni kara padagadovia laka na manetabu e kesa na tinoni tabu, rongona aia nogo e savorivaniau na sausau na mutsa. Inau nogo na Taovia. Au doulaka mau naua migamu niqu tinoni amu doulaka. ");
INSERT INTO gri_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Me ti vaga kesa na dalena daki na manetabu ke lia na rebi, maia e paluvangamana na tamana; ma nimui aqo kamu matesia. ");
INSERT INTO gri_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Na Mane Tabu Loki ara qetunogoa na oela tabu tana lovana mara tabunogoa gana ke sagelia na polo na manetabu, ma nina aqo ke komudoua na ivuna, me ke tau ratsia na polona, na mani sauvulagiana laka aia e roku. ");
INSERT INTO gri_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","Aia ara balovaniau nogo inau, ma nina aqo ke tau naua sa omea ke gini kaulinaqu tana vovorona na lotu, me ke laka goto na naqugasiana niqu Valepolo Tabu ma na rutsu taniana na ba sage kesa tana vale i tana e totu na konina kesa tinoni e mate, atsa moa ti na tamana se na tinana segeni nogo ia. ");
INSERT INTO gri_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ma nina aqo ke taugâ kesa na daki siama, ");
INSERT INTO gri_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","me tau na daki tinamate, se na daki e tsonitsunanogoa sa mane, se kesa na daki rebi. Nina aqo nomoa ke taugâ kesa na daki siama ke talumai nogo tana nina duli segeni. ");
INSERT INTO gri_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Me ti ke tau nauvaganana ia, migira na dalena sauba kara kaulinaqu tana vovorona na lotu. Inau na Taovia minau nogo au vililigia i laoqira na toga ke lia na Mane Tabu Loki.” ");
INSERT INTO gri_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ma na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","ke tsarivaganana vania a Aaron, “E tabu vania sa vidaqira na kukuamu igoe aia e seko sa tabana konina, na savori vaniaqu na sausau na mutsa. Na ketsa iani kamu tangolidatoa tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ke laka sa tinoni aia e seko sa tabana na konina na mai varangisiana niqu belatabu: aia e koko, se e logu, se e viri palepale na ngorana se e tau tovu dou sa turina na konina; ");
INSERT INTO gri_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","se e labe na limana se e matea na tuana; ");
INSERT INTO gri_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","se e vogu na gotuna, se e ngetu; se e seko na matana, se e viri voravora na kokorana, se e seko na velena. ");
INSERT INTO gri_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Me ke laka goto sa vidaqira na kukuana a Aaron na manetabu na mai ma na savori vaniaqu inau sa sausau na mutsa ti vaga ke seko sa tabana na konina. ");
INSERT INTO gri_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Na mane vaga ia e dou moa ti ke sanga rago na ganiana na mutsa ara gini savori vaniau, atsa moa ti na mutsa tabu, se na mutsa e tabu loki sosongo, ");
INSERT INTO gri_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","me rongona aia e seko kesa tabana na konina me tabu vania ke mai varavara tana polokatsi tabu, se ke mai varangisia na belatabu. Nina aqo ke laka na tsairaboana na omea tabu girani, rongona inau na Taovia, minau nogo au naua mara gini lia na omea tabu.” ");
INSERT INTO gri_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Igirani nogo na omea a Moses e tsarivania a Aaron migira na dalena, ma na toga popono tana Israel. ");
INSERT INTO gri_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Maia na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ke tsarivaganana vania a Aaron migira na dalena: “Nimui aqo kamu kukuni tanigira na sausau tabu igira na toga ni Israel ara balogira vaniau, rongona kamu tau paluvangamana na asaqu tabu. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Me ti vaga ke kesa vidaqira na kukuamui ke mai varangisigira na sausau tabu igira na toga ni Israel ara balogira vaniau inau, kalina aia e kaulinaqu me tau vati suisui moa, na tinoni vaga ia e tabu saikesa vania ke aqo goto tana belatabu. Na ketsa iani kamu tangolidatoa tana tagu sui ke mai. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“E tabu vania sa kukuana a Aaron aia e gadovia na lobogu seko tana kokorana, se ke tsodoa na saqerebei, na ganiana kesa na sausau tabu poi tsau kalina ke masidi doutugua taonia na vovorona na lotu. Na manetabu e gini kaulinaqu ti vaga ke pelea sa omea e pelea na konina na tinoni mate, se ti ke tavongani rutsu lê na konagana, ");
INSERT INTO gri_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","se ti ke pelea kesa na omea tuavati se kesa tinoni e totu kaulinaqu nogo tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ti kesa na manetabu e kaulinaqu nogo tana vovorona na lotu, me sauba ke totu kaulinaqu poi tsau tana ngulavi, me valina goto ke gania sa sausau tabu poi tsau kalina ke lesomale. ");
INSERT INTO gri_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Mi murina kalina ke sû nogo na aso, maia ke maletugua, me tangomana vanitugua ke gania na vangana na sausau tabu, igira nogoria gana tuva. ");
INSERT INTO gri_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ke laka goto na ganiana na velesina sa omea tuavati e mate segenina, se kara gati matesia na omea tuavati atsi; rongona ke tau naua me ke gini kaulinaqu i mataqu inau. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Pipi sui lakalaka na manetabu niqira aqo kara muridougira na vovorona na ketsa girani. Me ti vaga ke tagara, me sauba kara gini tsutsugaqira ma kara mate, rongona ara petsakoe mara tau murigira na ketsa tabu. Inau na Taovia, minau nogo au naua mara gini lia na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Migira segeni moa na vungu manetabu tangomana kara sanga na ganiana na omea ara nauginia na sausau tabu; me vali vanigira na tinoni sui tavosi na ganiana, atsa moa ti ke kesa ke mai na lelaviana na manetabu, se ke kesa nina maneaqo. ");
INSERT INTO gri_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Migira moa nina tseka na manetabu, igira aia e voliginigira nina qolo segeni, se kara botsa nogo i valena, tangomana vanigira goto kara sanga na ganiana gana mutsa na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Me ti vaga na dalena daki kesa na manetabu ke taugâ kesa na tinoni lê e tau na manetabu, ma na daki ia e valivania na ganiana na vangana na sausau tabu. ");
INSERT INTO gri_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Me ti vaga kesa na dalena daki e tinamate, se na savana e tsonitsunâ me tau tamani dalena, maia e visutugua i valena tamana, ma na daki ia tangomana vania ke sanga na ganiana na mutsa na tamana e adia tana nina aqo manetabu. Migira moa na vungu manetabu tangomana kara sanga na ganiana na mutsa vaga ia. ");
INSERT INTO gri_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Me ti vaga sa tinoni aia e tau kesa i laoqira na vungu manetabu, maia ke tau padakuti matena talu me ke gania na turina na vangana na sausau tabu, ma nina aqo ke volivisua i konina na manetabu na matena popono me ke pabogotoa. ");
INSERT INTO gri_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Na manetabu kara laka na tsairaboana na sausau tabu ");
INSERT INTO gri_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","tana tavongani tami vaniaqira na tinoni moa soana na ganiana; rongona ti kara nauvaganana ia, migira ara alomai segenia gaqira kede. Inau na Taovia minau nogo au naua mara gini lia na omea tabu na sausau girani.” ");
INSERT INTO gri_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ma na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ke sauvania a Aaron, ma na dalena, migira na toga popono ni Israel na vovorona na ketsa vaga girani. “Kalina ti vaga sa tinoni ni Israel se sa tinoni ni veratavosi e totu i laona na Israel ke tû na savoriana kesa na savori-kodokodo, atsa moa ti vaga aia ke naua agana na manaliana kesa nina veke, se ke saua moa tana nina padangao segeni, ma na omea tuavati ke adimaia ke tau goto seko sa tabana na konina. ");
INSERT INTO gri_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Ti vaga God ke tabea na sausau ia, me kilia ke kesa na manena me ke tau goto seko sa tabana na konina. ");
INSERT INTO gri_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Me ti vaga igamu kamu sauvania na Taovia kesa na omea tuavati e seko sa tabana na konina, me sauba na Taovia e utu ke tabea. ");
INSERT INTO gri_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mi kalina kesa ke savori vania na Taovia kesa na sausau tangomana na tinoni kara ganipatâ na turina, atsa moa ti vaga aia ke naua gana na manaliana kesa nina veke, se ke saua moa tana nina padangao segeni, ma na omea tuavati ke adimaia ke tau goto seko sa tabana na konina, ti na Taovia ke tabea. ");
INSERT INTO gri_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kamu laka goto na savori vaniana na Taovia kesa na omea tuavati e koko matana, se e logu na tuana, se kara bokalia, se e vora me rutsu na kô tana vorana, se e qatu, se e qaruqaru. Kamu laka na gini savori-kodoputsa tana belatabu sa vidaqira na omea tuavati vaga gira. ");
INSERT INTO gri_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ti vaga kamu ngaoa na savoriana sa omea tana nimui papada segeni, e dou moa ti kamu savoria kesa na omea tuavati e seko sa tabana na konina, ma na omea tuavati vaga ia e tau moa ulagana kamu savoria gana na manaliana kesa nimui veke. ");
INSERT INTO gri_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kamu laka goto na gini sausau vania na Taovia kesa na omea tuavati ti vaga na bogona kara bokalia, se kara rapasia, se kara paria, se kara raqa ratsia. I laona na veramui e tabu vanigamu na savoriana na omea tuavati vaga ia. ");
INSERT INTO gri_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Me tabu goto na savoriana agana nimui sausau na mutsa sa omea tuavati e seko vaga ia amu adia i konina kesa na tinoni ni veratavosi. Na omea tuavati e seko vaga ia e utu goto God ke tabea. ");
INSERT INTO gri_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","“Kalina ti ke vasini botsa na dalena kesa na buluka, se kesa na sipi se kesa na naniqoti, kamu moloa ke totu kolutalua na tinana ke vitu na dani, mi muri ti ke ulagana na savoriana gana na sausau na mutsa vaniana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kamu laka na adisaiana na gini kodoputsa kesa moa dani kesa na buluka daki kolu dalena, se kesa na sipi kolu dalena, se kesa na naniqoti kolu dalena. ");
INSERT INTO gri_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kalina igamu kamu tû na savori-kodoputsa gana na soadouana na Taovia, ma kamu muridougira na vovorona, me vaga ia ma na Taovia sauba ke tabea; ");
INSERT INTO gri_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ma kamu ganisuia tana dani nogo ia, ma kamu laka goto na moloana sa turina ke tsau tana matsaraka na dani ngana. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Kamu muridougira niqu ketsa ma niqu vali inau nogo na Taovia au sauvanigamu. ");
INSERT INTO gri_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Kamu laka goto na paluvangamana na asaqu tabu; migira na toga popono tana Israel niqira aqo kara padagadovia laka inau au doulaka saikesa. Inau na Taovia minau nogo au naua migamu amu gini doulaka; ");
INSERT INTO gri_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","minau segeni nogo au adirutsumigamu tania na Ejipt rongona kau gini lia nimui God. Inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Na Taovia e sauvania a Moses ");
INSERT INTO gri_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","na vovorona na ketsa girani ara kalea na muridouana na aqona na dani tabu, kalina igira na toga ni Israel niqira aqo kara labasai na samasama. ");
INSERT INTO gri_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Iani nogo na ketsa e kalea na Dani na Sabat: “Igamu amu tamanina nogo e ono na dani i tana igamu kamu naugira pipi sui nimui aqo, ma kamu padadoua laka tana vitunina dani, aia na Dani na Sabat, na dani na mango. Mi tana dani ia igamu kamu laka goto na peleana sa aqo, ma kamu labasai moa matena na samasama atsa moa ti iava amu totu igamu. Na Dani na Sabat nina nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ma na Taovia e tsarigotoa, “Igirani nogo na Dani Tabu nimui aqo kamu saimai na lokisiaqira kalina ke gado niqira tagu. ");
INSERT INTO gri_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Na Dani Tabu na Paseka e tuturiga kalina e sû na aso tana sangavulu vatinina dani tana kesanina vula. ");
INSERT INTO gri_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Mi tana sangavulu tsegenina dani e tuturiga na Dani Tabu na Bredi Tagara Isti Konina, mi laona ke vitu na dani popono, nimui aqo kamu laka na ganiana na bredi ara aqosiginia na isti. ");
INSERT INTO gri_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mi tana kesanina dani i laona na uiki ia nimui aqo kamu maisai sui matena na samasama, ma kamu laka goto na peleana sa nimui aqo. ");
INSERT INTO gri_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mi laona ke vitu na dani kamu savoria nimui sausau na mutsa vania na Taovia. Mi tana vitunina dani ma kamu saimaitugua matena na samasama, ma kamu laka saikesa moa na peleana sa nimui aqo vaga amu lavu na nauana pipi dani.” ");
INSERT INTO gri_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Ma na Taovia e tsarigotoa vania a Moses, “Ko tsarivaganana iani vanigira na toga ni Israel: Kalina kamu ba sage i laona na kao na Taovia ke sauvanigamu, ma kamu tsurivigira nimui uiti ganoga vaolu, ma na kesanina tsotsodo na ivogo kamu ivogoa kamu adibavania na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Maia na manetabu ke saua vaga kesa na vangalaka dou bâ vania na Taovia rongona aia ke gini tabegamu. Ma na sausau ia na manetabu ke savoria tana dani murina na Sabat. ");
INSERT INTO gri_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Mi tana dani nogo amu gini sausau nimui uiti, ma kamu gini savori-kodokodo goto ke kesa na dalena sipi mane e kesa moa na ngalitupana, me ke tau goto seko sa tabana na konina. ");
INSERT INTO gri_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ma kamu savorikolugotoa ke ruka kilo na pulaoa lalo koluginia na oela na olive vaga na sausau na mutsa. Ma na vuruna na sausau vaga ia e punâ na Taovia me gini laona sosongo. Ma kamu saukolugotoa kesa na lita na uaeni. ");
INSERT INTO gri_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kamu laka na mavi na ganiana nimui uiti ganoga vaolu, atsa moa ti na qoqoana, se na kokodona, se amu gini aqosibredi, poi tsau kalina kamu adi bâ nimui sausau iani vania God. Ma na ketsa iani niqira aqo igira na kukuamui kara tangolidatoa tana tagu sui ke mai.” ");
INSERT INTO gri_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ma na Taovia e tsarigotoa vaganana iani: “Kamu tsokogira ke vitu na uiki popono, ke tû tana dani murina na Dani na Sabat i tana amu sauvania na Taovia nimui ivogo na uiti vaolu. ");
INSERT INTO gri_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mi tana tsege sangavulunina dani, aia na dani i murina na vitunina Dani na Sabat, kamu savorivania na Taovia ke kesa goto nimui sausau na uiti. ");
INSERT INTO gri_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Pipi na tamadale tatasa kara adimaia tango ruka na sivona bredi, ma kara gini savorivania na Taovia vaga kesa na vangalaka dou bâ. Pipi sivona kara aqosiginia ke ruka na kilo na pulaoa kolu isti ma kara bitia, ma kara gini savorivania na Taovia vaga na sausau ara aqosiginia na kesanina tsotsodo na tsuri ara naua tana niqira uta na uiti. ");
INSERT INTO gri_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ma na saikolu popono kara saukolua na bredi ke vitu na dalena sipi mane ke kesa moa na ngalitupaqira, me kesa na buluka mane, me ke ruka na naniqoti mane, me ke tagara goto sa vidaqira ke seko sa tabana konina. Ma kara savorigira vania na Taovia ngiti savori-kodokodo, ke vano sai kolua na sausau na uiti ma na sausau na uaeni. Ma na vuruqira na sausau girani ke punâ na Taovia me ke gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ma kamu saugotoa kesa na naniqoti mane gana na savori-sausau matena na sasi, me ke ruka na dalena sipi ke kesa moa ka ngalitupaqira gana na savori-kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Maia na manetabu sauba ke savoria na bredi kolukaira ruka na dalena sipi vaga kesa na vangalaka dou bâ vania na Taovia me ke lia gaqira tuva na manetabu. Ma na savori vaga girani ara lia na omea tabu. ");
INSERT INTO gri_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mi tana dani ia kamu laka saikesa na peleana sa nimui aqo vaga amu lavu na nauana pipi dani, kamu maisai sui matena na samasama. Ma niqira aqo na kukuamui atsa moa iava i tana kara totu, kara tangolidatoa na vovorona na ketsa iani tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Mi kalina kamu tsurivia nimui uta na uiti, kamu laka na adiaqira na uiti ara totu tana tsavuna uta, ma kamu laka goto na visubatugua ma na tsakoaqira igira ara kauvisu; kamu mologira ma kara totuvisu vanigira na tinoni ara tau tamani sa omea, migira goto na tinoni ni veratavosi. Inau nogo na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Mi tana kesanina dani tana vitunina vula nimui aqo kamu nauginia na dani na mango, mi kalina ke tangi na tavuli, ma kamu saimai matena na samasama. ");
INSERT INTO gri_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kamu sauvania na Taovia nimui sausau na mutsa, ma kamu laka na peleana sa nimui aqo vaga amu lavu na nauana pipi dani.” ");
INSERT INTO gri_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ma na Taovia e tsarigotoa vania a Moses, ");
INSERT INTO gri_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Tana sangavulunina dani i laona na vitunina vula aia nogo na dani i tana nimui aqo kamu naua na aqona na suisui matena niqira sasi na toga. Mi tana dani ia kamu laka goto na ganiana sa omea. Kamu saimai matena moa na samasama ma na savoriana na sausau na mutsa vaniana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ma kamu laka goto na peleana sa nimui aqo tana dani ia, rongona aia nogo na dani na manetabu e naua na aqona na suisui matena na sasi. ");
INSERT INTO gri_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Me ti vaga ke kesa ke gania sa omea tana dani ia, me sauba kara tsidavaginia tania niqira saikolu nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Me ti vaga ke kesa ke naua sa aqo tana dani ia, maia na Taovia segeni nogo sauba ke matesia. ");
INSERT INTO gri_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ma na vovorona na ketsa iani niqira aqo na kukuamui kara tangolidatoa sailagi atsa moa ti iava tana ara totu. ");
INSERT INTO gri_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ke tû kalina ke sû na aso tana siunina dani tana vula ia, me ke tsau bâ kalina ke sû na aso tana sangavulunina dani kamu nauginia na dani na mango, ma kamu laka goto na ganiana sa omea.” ");
INSERT INTO gri_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ma na Taovia e tsarigotoa vania a Moses, ");
INSERT INTO gri_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Na Dani Tabu na Babale ke tuturiga tana sangavulu tsegenina dani i laona na vitunina vula, mi tana migira na tinoni sui tana Israel kara totu moa i laona na babale ke vitu na dani. ");
INSERT INTO gri_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mi tana kesanina dani kamu saimai matena na samasama, ma kamu laka goto na peleana sa nimui aqo. ");
INSERT INTO gri_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Me pipi dani i laona na uiki iani nimui aqo kamu savoria kesa na sausau na mutsa. Mi tana alunina dani ma kamu mai totusaitugua matena na samasama, ma kamu savorigotoa kesa na sausau na mutsa. Na dani ia na dani na samasama, ma kamu laka goto na nauana sa aqo. ");
INSERT INTO gri_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Igirani nogo na dani tabu i tana igamu kamu padalokiginia na Taovia tana mai totusai matena na samasama ma na savoriaqira nimui sausau na mutsa, ma na savori-kodokodo, ma na sausau na uiti, na kodoputsa, ma na sausau na uaeni, vaga e kilia na nauana tana dani ara titia. ");
INSERT INTO gri_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ma na dani tabu girani na kamagana moa na dani na mango pipi tana Sabat, ma na sausau girani na papabona nimui vangalaka amu lavu na sauana, ma na papabona goto nimui sausau gana na manaliana nimui veke, ma na omea amu savorivania na Taovia tana nimui padangao segeni. ");
INSERT INTO gri_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Mi kalina kamu tsurivigira sui nogo na vuana nimui uta, nimui aqo kamu lokisia na dani tabu iani i laona ke vitu na dani, tuturiga tana sangavulu tsegenina dani tana vitunina vula. Ma na kesanina dani aia ke lia na dani na mango. ");
INSERT INTO gri_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Mi tana dani ia kamu adigira visana na vuana gai dou bâ tana nimui gai mutsamutsa, ma kamu adigira goto na gabana na koirou ma na arana gai kolu rauqira, ma kamu tuturiga na lokisiana na dani tabu na mani padalokiana na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ma kamu lokisia i laona ke vitu na dani. Ma na vovorona na ketsa iani niqira aqo na kukuamui kara tangolidatoa tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Migira sui na toga ni Israel kara totu i laona na babale ke vitu na dani, ");
INSERT INTO gri_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","rongona igira na kukuaqira kara donaginia laka na Taovia nogo e naua ti igira na tinoni ni Israel ara mauri moa tana babale lê kalina aia e adirutsumigira tania na Ejipt. Inau nogo na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Tana tsaqina goko vaga nogo girani a Moses e sauvanigira na toga ni Israel na vovorona na ketsa e kalea na muridouana na aqona na dani tabu na mani padalokiana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ko ketsaligira na tinoni ni Israel kara adimaia na oela na olive dou liuliu bâ gana na laeti i laona na Valepolo, rongona na bulu ke gini iruiru sailagi. ");
INSERT INTO gri_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Me pipi tana ngulavi nina aqo a Aaron ke tungigira me ke reitutugua kara iruiru i matana na Taovia tsau tana matsaraka, i tabana i tano na polokatsi e tsautsau i matana na Bokisi na Taso, aia e totu i laona na Nauna Tabu Loki Sosongo. Ma na vovorona na ketsa iani niqira aqo nogo kara muri sailaginia tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ma nina aqo a Aaron ke reitutugugira na bulu iruiru ara totu i kelana na gai na mani molodato bilona bulu iruiru ara aqosiginia na qolumila laka, me ke reia kara iru sailagi i matana na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Na Taovia e tsarigotoa vania a Moses, “Kamu adia ke sangavulu ruka kilo na pulaoa ma kamu bitia ke sangavulu ruka na bredi. ");
INSERT INTO gri_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kamu mologira ke ruka tana palatete, ke ono na sivona kesa tete, i kelana na bela ara tsavuginia na qolumila laka e totu i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ma kamu mologira ke visana na bulunagai uruuru laka pipi tana palatete, mi muri ma kamu savori vania na Taovia na bulunagai uruuru iani ngiti olina na bredi. ");
INSERT INTO gri_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Me pipi sui tana dani na Sabat tana tagu sui ke mai, migira na manetabu niqira aqo kara moloa na bredi iani i matana na Taovia. Aia niqira aqo kalavata kara nau sailaginia igira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ma na bredi ia gana tuva nogo a Aaron migira na kukuana, migira kara gania kesa tana nauna tabu, rongona na bredi ia na turina tabu loki sosongo tana mutsa ara gini savorivania na Taovia.” ");
INSERT INTO gri_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Me totu i tana kesa na mane ka daleqira kesa na mane ni Ejipt ma na daki ni Israel, aia ko Selomit na soana maia na dalena daki a Dibri tana puku konina a Dan. Me kesa dani, ma na mane ia e vaiganigi kolua kesa na tinoni ni Israel. Mi laona ka niqira vaiganigi maia e asu seko sosongo vania God. Mi tana, migira ara tû mara adi bâ i matana a Moses. ");
INSERT INTO gri_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mara moloa i limaqira na mane matali, mara pipitua na Taovia ke tsarivanigira nagua kara nauvania na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ma na Taovia e goko vania a Moses me tsaria, ");
INSERT INTO gri_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ko adirutsumia na mane ia tabana i tano tania na veramui. Me pipi sui igira ara rongomia kalina aia e tsonia na asu seko kara moloa na limaqira tana lovana na mani sauvulagiana laka e tsutsukibo manana nomoa, mi muri ti igira na toga popono kara taimatesiginia na vatu. ");
INSERT INTO gri_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Mi muri mo ko tsarivanigira na toga sui tana Israel laka ti vaga ke kesa ke asu seko vania God me sauba ke gadovikedena ");
INSERT INTO gri_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ma kara taimatesia. Me ti vaga kesa vidaqira na Israel, se sa tinoni ni veratavosi ara mauri tana Israel, ke asu seko vania na Taovia ma niqira aqo na toga popono kara taimatesia. ");
INSERT INTO gri_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Me ti vaga kesa ke naua na labumate, kamu labumatesi gotoa aia. ");
INSERT INTO gri_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Me ti vaga kesa ke labumatesia sa omea tuavati e tamanina sa tinoni tavosi, ma nina aqo ke sautuguna. Na maurina kesa ke oliginia na maurina kesa. ");
INSERT INTO gri_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Me ti vaga ke kesa ke bokalia kesa tinoni tavosi, ma na omea vaga aia e naua vania na tinoni tavosi kara nauvanigotoa aia. ");
INSERT INTO gri_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ti vaga aia ke kutsia na sulina kesa tinoni, ma kara kutsi vanigotoa na sulina aia; me ti vaga ke dokoli vania na tabana matana kesa tinoni, ma kara dokoli vanigotoa kesa tabana na matana aia; me ti vaga ke lumuvuti vania na livona kesa, ma kara lumuvuti vanigotoa na livona aia. Atsa moa na vatana koegua na boka kesa ke naua vania kesa tinoni tavosi, ma kara nauvaganana vanigotoa aia. ");
INSERT INTO gri_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Masei ti vaga ke labumatesia kesa na omea tuavati, ma nina aqo ke sautuguna, masei ti vaga ke labumatesia kesa tinoni ma kara labumatesigotoa aia. ");
INSERT INTO gri_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Na vovorona na ketsa iani e totu vanigamu sui igamu na tinoni ni Israel, me vanigira sui goto na tinoni ni veratavosi ara totu i laomui, rongona inau nogo na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mi kalina a Moses e tsarivaganana sui ia vanigira na toga ni Israel, migira ara tû mara adirutsumia i tano na mane ia mara taimatesiginia na vatu. Mi tana nauvaganana ia migira na tinoni ni Israel ara naua na omea na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Na Taovia e goko vania a Moses tana Vungavunga Sinai me ketsalia ");
INSERT INTO gri_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ke tusuvanigira na toga ni Israel na vovorona na ketsa girani. “Kalina ti kamu ba sage tana kao aia na Taovia sauba ke saua vanigamu, ma nimui aqo kamu molovania na kao ke mango pipi tana vitunina ngalitupa. ");
INSERT INTO gri_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","I laona ke ono na ngalitupa kamu tsukagira rago nimui uta, ma kamu vasugigira nimui itai na uaeni, ma kamu angunikolugira na lakana nimui uta. ");
INSERT INTO gri_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ma na vitunina ngalitupa ke lia na ngalitupa na mango vania na kao, ma nimui aqo kamu balovania na Taovia. Kamu laka goto na tsukaana sa omea tana nimui uta; se na vasugiaqira nimui uta na uaeni. ");
INSERT INTO gri_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kamu laka goto na tsuriviana na vuaqira na omea ara dato segeniqira mamu tau tsukagira, ma kamu laka goto na pitsuana na vuaqira nimui itai na uaeni amu tau vasugigira, matena aia na ngalitupa ia na mango saikesa vania na kao. ");
INSERT INTO gri_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ma na omea gua moa ke dato tana nimui kao i laona na ngalitupa popono ia, sauba nomoa ke palagamu igamu, migira goto nimui tseka, ma nimui tinoni aqo, migira na tinoni ni veratavosi ara mauri i laomui, ");
INSERT INTO gri_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","migira nimui omea tuavati papala, migira goto na omea tuavati atsi ara totu tana nimui uta. Me pipi sui na omea mutsamutsa kara dato tana nimui kao tana tagu ia e tugua kamu ganigira.” ");
INSERT INTO gri_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ma na Taovia e tsarigotoa, “Kamu tsokogira ke vitu kalina ke vitu na ngalitupa, me saisai me vati sangavulu siu na ngalitupa. ");
INSERT INTO gri_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Mi tana sangavulunina dani i laona na vitunina vula, tana nogo e gado na Dani Tabu na Sese. Mi tana dani ia kamu moloa ke kesa na mane ke uvia na tavuli pipi nauna i laona nimui butona kao popono. ");
INSERT INTO gri_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Migamu kamu baloginia na tsege sangavulunina ngalitupa, ma kamu katevulagia laka igira sui ara loaga tana butona kao popono ara tanusi. Mi laona na ngalitupa vaga ia, migira sui ara voli kao i konina kesa tinoni tavosi niqira aqo kara tusuvisua vania na tamanina pukuga se vanigira na kukuana, masei ti vaga ke aqo tseka vania kesa tinoni ma nina aqo aia e volia, ke molovisutugua i konina nina tamadale. ");
INSERT INTO gri_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kamu laka goto na tsukaana sa mutsa i laona nimui uta se na tsuriviana ma na mololakaana na uiti ara viri vovo segeni, se na tsakoana ma na rapasiana na vuaqira nimui itai na uaeni amu tau vasugigira. ");
INSERT INTO gri_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Na ngalitupa popono ia ke lia na ngalitupa tabu vanigamu; me sauba kamu gania na mutsa ara dato segeni i laona nimui kao. ");
INSERT INTO gri_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Mi laona nogo na ngalitupa ia pipi sui tinoni e tsabiri vania kesa tinoni tavosi nina kao, ma nina aqo ke adivisutugua nina kao i konina aia e volia. ");
INSERT INTO gri_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Me vaga ia, mi kalina ti kamu tsabiri kao vania kesa gamui verakolu, se kamu voli kao i konina, ma kamu reia kamu tau vaipeqogi. ");
INSERT INTO gri_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kamu titia na matena na voli kao taonia na dangana na ngalitupa tugua na kao ia ke molovuana ti ke laba tugua na Ngalitupa na Sauvisu Omea. ");
INSERT INTO gri_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ti vaga ke totu danga moa na ngalitupa ma na matena na voliana sauba ke dato, me ti vaga ke tsaurae nogo na ngalitupa, me ke tsuna lê na matena, rongona igamu amu tau tsabiria na kao, tagara, amu tsabiria moa na tagu na aqoaqo tana kao ia. ");
INSERT INTO gri_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kamu laka na peqoaqira gamui verakolu, ma kamu kukuni tania nimui God rongona inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Kamu muridougira pipi nina ketsa ma nina vali na Taovia, me sauba kamu gini totu ravidou i laona nimui kao. ");
INSERT INTO gri_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tana kao ia sauba kara dato magobu dou pipi na omea tsukatsuka, me sauba kamu tamanina pipi sui na omea amu padangaoa na ganiana, ma kamu totu raviravi dou. ");
INSERT INTO gri_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Me ke visana sauba kara veisua vaga iani, ‘?Ma nagua sagata sauba igita ka gania tana vitunina ngalitupa, ti vaga ka tau aqo uta, ma ka tau tsurivia na lakana sa omea?’ ");
INSERT INTO gri_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Na Taovia sauba ke tabua na kao tana ononina ngalitupa, me ke lakaga na mutsa ke tugugamu na ganiana i laona ke ruka na ngalitupa popono. ");
INSERT INTO gri_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mi tana alunina ngalitupa kalina igamu kamu tsuka vaolugira tugua nimui uta, migamu sauba kamu ganigira moa na mutsa amu tsurivigira manoga nogo tana ononina ngalitupa, me sauba ke tugugamu na ganiana poi ke tsau kalina kara raranga na mutsa amu tsukavaolugira tana ngalitupa ia. ");
INSERT INTO gri_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Kalina ti kamu tsabiria nimui kao ma kamu tau moa padâ laka amu tsabiri saikesalia, rongona na kao ia e tau nimui tamani igamu; nina tamani nogo God, migamu amu vaga moa ti na tinoni ni veratavosi, ma God e tamivanigamu kamu gini aqo moa. ");
INSERT INTO gri_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Mi kalina ti kesa vidamui ke voli kao i konina kesa gana verakolu, ma nina aqo ke pada gadovidoua laka ti vaga na tamanina pukuga ke ngaoa na volivisuana nina kao me tangomana vania ke naua. ");
INSERT INTO gri_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Me ti vaga ke kesa gamui verakolu ke tau tamanina sa omea, me kilia ke tsabiria nina kao rongona ke gini tamaniqolo na mauri, ma nina aqo ke kesa na kamana varavara ke volivisu vania. ");
INSERT INTO gri_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Me ti vaga na tinoni ia e tagara sa kamana varavara ke volivisu vania nina kao, me tau utu ti i muri aia segenina ke tamani qolo tugua gana ke gini volivisu segenina. ");
INSERT INTO gri_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Mi tana ma nina aqo aia ke tusuvania na mane aia e volia na kao i konina, na matena e tugua moa na dangana na ngalitupa na aqoaqo e kau ti ke tsau bâ tana Ngalitupa na Sauvisu Omea, mi muri ti nina kao ke visutugua i konina. ");
INSERT INTO gri_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Me ti vaga aia ke tau tamanina na qolo ke tugua na volivisuginiana nina kao, ma na kao ia sauba ke totu kalavata moa i limana na mane aia e volia i konina tana idana, poi ke tsau bâ tana Ngalitupa na Sauvisu Omea. Mi tana ngalitupa ia ti na kao ia ke visutugua i konina na tamanina pukuga. ");
INSERT INTO gri_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Me ti vaga ke kesa ke tsabiria kesa na valena e totu kesa tana verabau ara barapoliginia na vatu, maia e tangomana ke volivisua na vale ia i laona na kesanina moa ngalitupa murina kalina aia e tsabiri vania na mane ia. ");
INSERT INTO gri_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Me ti vaga aia ke tau goto volivisua tana ngalitupa nogo ia, maia e utu nogo ke volivisua, ma na vale ia e lia nina tamani saikesa nogo na mane aia e volia kolugira goto igira na kukuana; mi tana Ngalitupa na Sauvisu Omea ma na vale ia e utu goto ke visutugua i konina aia e tamanina tana idana. ");
INSERT INTO gri_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Migira na vale ara totu tana vera ara tau barapoliginigira na vatu, kara nauvanigira vaga na uta; igira na tamanina pukuga tangomana kara volivisua, me sauba kara visutugua i koniqira tana Ngalitupa na Sauvisu Omea. ");
INSERT INTO gri_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Migira moa na Levite tangomana kara volivisua tana tagu moa soana niqira kao tana verabau ara sauvanigira nogo kara aditamaniqira tana idana. ");
INSERT INTO gri_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Me ti vaga kesa Levite ke tsabiria kesa na vale e totu i laona kesa vidaqira na verabau girani me tau volivisua, ma nina aqo aia e volia i konina na Levite ke sauvisu lea vania tana Ngalitupa na Sauvisu Omea, rongona na vale ara totu i laona na veraqira na Levite niqira tamani kalavata nogo igira i laoqira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ma na kao laka tana e dato dou na buruburu ara totu polipoligira niqira verabau na Levite, kara laka saikesa na tsabiriaqira; niqira tamani kalavata nogo igira.” ");
INSERT INTO gri_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ma na Taovia e tsarigotoa, “Me ti vaga ke kesa gamui verakolu e tau saikesa tamani sa omea me utu vanigotoa na tsodo maurina segeni, ma nimui aqo igamu kamu sangâ vaga nogo amu nauvanigira na tinoni ni veratavosi ara mai i veramui, rongona ke gini tangomana na totu koluamui babâ moa. ");
INSERT INTO gri_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kamu laka goto na kiliana i konina na qolobotsa, kamu kukuni tania God ma kamu moloa moa aia gamui verakolu ke totu i laomui. ");
INSERT INTO gri_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ma kamu laka goto na raiana ke tusuvanigamu na qolobotsa tana qolo aia e kaoni i konimui, ma kamu laka goto na kililokiana na matena na mutsa amu tsabiri vania. ");
INSERT INTO gri_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Iani nogo na omea au ketsaliginigamu inau na Taovia nimui God inau au adirutsumigamu tania na vera ni Ejipt, rongona kau tusuvanigamu na kao ni Kanaan ma kau lia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Me ti vaga ke kesa gamui verakolu e totu i laomui, maia ke tau saikesa tamani sa omea, me ke tû me ke tsabiri segenina vanigamu vaga moa ti na tseka, migamu kamu laka na raiana ke aqo mala tseka vanigamu. ");
INSERT INTO gri_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Maia ke totu rago i konimui vaga kesa nimui mane aqo, me ke aqosage vanigamu poi tsau kalina ke laba kesa goto na Ngalitupa na Sauvisu Omea. ");
INSERT INTO gri_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Bâ, mi tana tagu ia maia kolugira nina tamadale kara mololegamu ma kara visutugua i koniqira na kamaqira, mi tana niqira kao na mumuaqira. ");
INSERT INTO gri_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Igira na toga sui ni Israel ara niqu tseka nogo inau na Taovia, minau nogo au adirutsumigamu tania na vera ni Ejipt; me tabu saikesa na tsonitsekaqira. ");
INSERT INTO gri_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kamu laka na rotasiaqira sosongo, ma kamu kukuni taniau inau nimui God. ");
INSERT INTO gri_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Me ti vaga kamu kilia na tamani tseka, ma nimui aqo kamu ba voligira i laoqira na verabau ara totu polipoligamu. ");
INSERT INTO gri_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Me tugugotoa kamu voligira ma kara lia nimui tamani igira na tinoni ni veratavosi ara totu i laomui, migira goto na daleqira ara botsa nogo tana nimui kao. ");
INSERT INTO gri_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Me dou moa goto ti kamu mologira kara lia niqira tseka na dalemui, ma kara aqo vanigira tana mauriqira popono. Migamu nimui aqo kamu laka na rotasi sosongoliana kesa gamui verakolu na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Me ti vaga kesa na tinoni ni veratavosi e totu i laomui maia e tamanina nina omea danga, me ke kesa gamui verakolu na Israel ke tau tamanina sa omea, maia ke tû me ke tsabiri segenina mala tseka vania na tinoni ni veratavosi ia, se vania kesa na kamana, ");
INSERT INTO gri_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","mi murina kalina ara volinogoa, me tangomana moa sa tasina segeni, ");
INSERT INTO gri_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","se sa niana se sa tasina savusavu, se ke kesa segeni na kamana varavara ke volivisua aia; se ti vaga aia ke aqo me ke tsodoa na qolo e tugua ke gini volivisu segenina, me tau utu aia ke voli segenia nina totu tanusi. ");
INSERT INTO gri_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ma nina aqo ke gokosai talu kolua aia e volia tana idana, ma kara ka tsokosaigira na dangana na ngalitupa tuturiga tana tagu kalina aia e tsabiri segenina, me poi tsau ke laba tugua na Ngalitupa na Sauvisu Omea, ma kara ka titia ke visa na qolo na vovolina na nusileana ke atsa kolua na qolo ara voliginia kesa na tinoni aqo. ");
INSERT INTO gri_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Me ti ke kau moa ke danga na ngalitupa me sauba ke danga na qolo ke voliginia nina totu tanusi. ");
INSERT INTO gri_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Me ti vaga ke tsaurae lê nogo na ngalitupa ti ke laba tugua na Ngalitupa na Sauvisu Omea, me sauba ke tau danga na qolo ke tsonia na voliginiana nina totu tanusi. ");
INSERT INTO gri_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ma na dangana na qolo ke atsa kolua na qolo e voliginigira igira ara aqo vania i laona kesa na ngalitupa. Ma gana taovia nina aqo ke tau rotasi sosongolia. ");
INSERT INTO gri_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Me atsa moa ti ke tau tangomana na totu tanusi i laona sa vidaqira na sautu vaga girani, mi kalina ke laba tugua na Ngalitupa na Sauvisu Omea ma nina aqo gana taovia ke moloa aia migira na dalena kara totu tanusi. ");
INSERT INTO gri_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Rongona igira na tinoni ni Israel ara niqu tinoni aqo nogo inau. Minau nogo au adirutsumigira tania na vera ni Ejipt; minau na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ma na Taovia e tsarigotoa, “Kamu laka na aqosiaqira na titinonina na god peropero, se na molokaeana na nunuqira, ma na turuvaginiaqira na tuguru vatu, se na vatu kakatsu agana na mani samasama vaniaqira. Inau nogo na Taovia nimui God. ");
INSERT INTO gri_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kamu lokisigira na dani tabu ma kamu kukuni tania na nauna i tana ara samasama vaniau. Inau nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Me ti vaga igamu kamu mauri murigira niqu vali, ma kamu muridougira niqu ketsa, ");
INSERT INTO gri_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","minau sauba kau molovanigamu na usa tana tagu laka, me ke lakaga dou na mutsa tana nimui uta, ma kara vua dou nimui gai mutsamutsa. ");
INSERT INTO gri_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Me sauba kara danga sosongo nimui omea tsukatsuka, migamu sauba kamu totu matengana moa na tsuriviana nimui uta na uiti kalina ke laba na tagu na pitsuaqira na vuana na uaeni, me sauba kamu totu matengana moa na pitsuaqira na vuana uaeni kalina ke laba na tagu na tsuka uiti. Ma kamu tamanina na mutsa sui amu ngaoa na ganiana, ma kamu totu raviravi dou tana nimui kao. ");
INSERT INTO gri_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Minau sauba kau moloa na rago i laona na veramui, ma kamu gini maturu dou, ma kamu tau goto matagunia sa omea. Me sauba kau tsialigigira sui lakalaka na omea tuavati atsi veveiga tania nimui kao, me ke tau goto laba sa vailabu loki i laona. ");
INSERT INTO gri_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Migamu, sauba ke managamui na tuliusiaqira gamui gala; ");
INSERT INTO gri_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","me sauba kara tsege lelê moa na vidamui kara tangomana na tuliusiaqira kesa sangatu na gala, ma kara kesa lelê moa sangatu kara tangomana na tuliusiaqira sangavulu na toga. ");
INSERT INTO gri_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Minau sauba kau vangalaka vanigamu ma kau sauvanigamu ke danga na dalemui; ma kau manalia niqu tabana na vaitasogi au naunogoa kolugamu. ");
INSERT INTO gri_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Me sauba ke danga sosongo nimui mutsa ma kamu gagania moa poi kamu tsurivia na uta vaolu, me sauba ke kilia kamu tsonilegira na tsarana na omea amu tsurivia tana idana, rongona ke gini molo mangamanga vanigira na mutsa vaolu. ");
INSERT INTO gri_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Inau sauba kau totu i levugamui i laona niqu Valepolo Tabu, me utu goto kau piloligi tanigamu. ");
INSERT INTO gri_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ma kau totu kalavata i konimui; ma kau lia nimui God, migamu kamu lia niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Inau na Taovia nimui God inau nogo au adirutsumigamu tania na vera ni Ejipt, rongona igamu kamu tau nogo tseka. Minau nogo au adiligia gaqira susuliga igira ara bingi sekoligamu mamu gini pidikae tugua.” ");
INSERT INTO gri_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ma na Taovia e tsarigotoa, “Ti vaga igamu kamu tau muridougira niqu ketsa, minau sauba kau kedegamu. ");
INSERT INTO gri_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Me ti vaga kamu sove na muriaqira niqu ketsa ma niqu vali, ma kamu veoa na vaitasogi au naua kolugamu, ");
INSERT INTO gri_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","minau sauba kau kedegamu. Sauba kau alomaia na rota seko loki ke gadovigamu: vaga na lobogu seko, ma na masagi loki e utugana na taliana, me ke gini koko na matamui, me ke tavongani tsuna lê na konimui. Migamu sauba kamu tsukaragoa nimui uta, me sauba ke taigamu lê, rongona igira gamui gala sauba kara mai ma kara tuliusigamu, ma kara ganigira na omea sui igamu amu tsukagira. ");
INSERT INTO gri_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Inau sauba kau piloligi tanigamu, migira gamui gala kara tuliusigamu lê. Migira ara reisavigamu sauba kara tagaovi kaputigamu. Migamu sauba kamu matagu loki sosongo, ma kamu tavongani tsogo lê kalina ke tau vati takuvigamu moa ke kesa. ");
INSERT INTO gri_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Mi murina kalina kara laba na omea sui vaga girani migamu kamu tau vati rongomangaqu moa inau, me sauba inau kau paboa nimui kede ke vitu goto kalina na sekona. ");
INSERT INTO gri_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Eo, sauba kau pukalia nimui kaekae loki; me ke tau goto tumu tsunamai sa usa, ma kara viri mamatsa lê sui nimui kao me ke kakai vaga na tapala. ");
INSERT INTO gri_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Me pipi sui nimui aqo kakai amu naua sauba ke tau lelê pelugamu, rongona e utu ke lakaga sa mutsa i laona nimui kao, migira nimui gai mutsamutsa e utu kara tamani sa vuaqira. ");
INSERT INTO gri_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Me ti vaga kamu tobakakai babâ moa vaniau inau ma kamu sove na rongomangaqu, me sauba inau kau pabo gotoa gamui kede ke vitu goto bâ kalina na sekona. ");
INSERT INTO gri_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Sauba kau molobagira na omea tuavati atsi veveiga kara gati matesigira na dalemui, ma kara matesigira sui goto nimui buluka, migamu sauba kamu tsaurae lê moa kamu mauri, migira sui na sautu i laona na veramui kara totu mangu lê. ");
INSERT INTO gri_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Me ti vaga i murina ara laba na kede sui vaga girani, migamu kamu tau moa vati rongomangaqu goto inau, ma kamu tobaseko vaniau babâ moa, ");
INSERT INTO gri_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","minau goto sauba kau tobaseko vanigamu, ma kau kedegamu ke vitu kalina ke seko liusia bâ na omea au nauvanigamu tana idana. ");
INSERT INTO gri_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Me ti vaga igamu kamu kutsia nimui tabana na vaitasogi amu naukoluau, minau sauba kau mologira gamui gala kara mai na vailabu koluamui, me ti vaga kamu tovoa na ba toturavi i laona nimui verabau, minau sauba kau moloa ke gadovigamu na lobogu seko loki e utugana na taliana, ma kau livugamu lê i limaqira gamui gala. ");
INSERT INTO gri_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Sauba kau kukurisia gamui mutsa,ma kara sangavulu na daki kara biti gaqira bredi i laona kesa moa na umu. Mi kalina kara tuvaria, me kilia kara piqe tetelo sosongolia, migamu kamu gania ma kamu tau gini masu. ");
INSERT INTO gri_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Me ti vaga i murina ara laba na omea sui vaga girani, migamu kamu tobaseko vaniau babâ moa inau, ma kamu sove na rongomangaqu, ");
INSERT INTO gri_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","me sauba inau goto kau tobaseko vanigamu, mi tana niqu momosatoba loki sauba kau kedegamu ke vitu kalina ke seko liusia bâ na omea au nauvanigamu tana idana. ");
INSERT INTO gri_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Migamu sauba kamu vitoa seko sosongo ma kamu ganigira na dalemui segeni. ");
INSERT INTO gri_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Minau sauba kau reisavi sosongoligamu, ma kau toroutsanigira nimui nauna na mani samasama vaniaqira nimui god peropero i kelaqira na tetena, ma kau vui pukaligira sui nimui belatabu gana na savori bulunagai uruuru, ma kau matesigamu, ma kau tsoni bâ na konimui i kelaqira na titinonina nimui god peropero ara tsatsaro lê tana kao. ");
INSERT INTO gri_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Me sauba kau toroutsanigira na veramui, ma kau toroveogira pipi nauna i tana amu samasama, me utu kau tabegira nimui omea amu gini savori-kodoputsa. ");
INSERT INTO gri_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Sauba kau sekoli poponoa nimui butona kao, mi kalina igira gamui gala kara mai totuvia sauba kara gini beke sosongo na reiana. ");
INSERT INTO gri_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Inau kau adia niqu isi ma kau takuvi rasavaginigamu, migamu sauba kamu viri tsogo piriutsa bamai i laona niqira kao na tinoni ni veratavosi. Ma nimui kao segeni ke totu mangu lê, ma nimui verabau kara toroutsa sui. ");
INSERT INTO gri_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Mi tana ti nimui kao ke mango rago na tuguqira na ngalitupa igamu amu tau molovania ke mango; maia sauba ke totu mangu lê me ke mango tana tagu popono igamu amu totu tsinogo tana niqira kao igira gamui gala. ");
INSERT INTO gri_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Me sauba inau kau naua, migamu amu totu tsinogo sauba kamu gini matagu loki sosongo kalina kamu rongomia na rerekena na rau e uvia na guguri, ma kamu viri tsogo lê. Ma kamu ulo vaga moa kalina ti kara takuvigamu tana tagu na vailabu, me sauba kamu viri puka lê kalina e tagara goto sa gamui gala ke varangisigamu. ");
INSERT INTO gri_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Sauba kamu vaitsogorigi lê kalina e tagara goto kesa ke takuvigamu, ma kamu tau goto susuliga na vailabugi koluaqira gamui gala. ");
INSERT INTO gri_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Migamu sauba kamu mate kalina amu totu tsinogo, eo, sauba ke konomi poponogamu niqira kao gamui gala. ");
INSERT INTO gri_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Migira i laomui kara kauvisu tana niqira kao gamui gala, sauba ke tsutsuna moa na koniqira poi kara mate tana rongona nimui sasi segeni igamu, ma niqira sasi igira na mumuamui. ");
INSERT INTO gri_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Me sauba kara tû igira na kukuamui ma kara koevulagigira niqira sasi segeni ma niqira sasi na mumuaqira, igira nogoria ara sove na rongomangaqu inau mara tobaseko vaniau, ");
INSERT INTO gri_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","mara naua minau au gini piloligi tanigira, mau molovanogira kara ba totu tsinogo tana niqira kao gaqira gala. Mi tana susuina, kalina igira na kukuamui kara molotsunali segeniqira i mataqu inau, ma kara sese matena niqira sasi, ");
INSERT INTO gri_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","mi tana ti inau sauba kau padavisua niqu vaitasogi au naukolutugira a Jakob, ma Isaak, ma Abraham, ma kau vaolusitugua niqu veke au naua laka kau saua na kao iani vanigira niqu tinoni. ");
INSERT INTO gri_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mi tana idana e kilia kara vanoligi talu na tinoni sui tania na kao ia me ke totu mango rago, ma kara tsonitalua na matena popono niqira sasi, rongona ara sove na muriaqira niqu ketsa ma niqu vali. ");
INSERT INTO gri_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Me atsa moa ke vaga ia, minau sauba kau tau vanoligi saikesa tanigira kalina igira ara totu moa i laona niqira kao gaqira gala, se kau matesiligigira sui, rongona ke tau luvu lê na vaitasogi inau au naua kolugira, minau nogoria na Taovia niqira God. ");
INSERT INTO gri_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Sauba kau vaolusitugua niqu vaitasogi au naua kolugira na mumuaqira, kalina au sauvulagia na susuligaqu loki i mataqira na vera loki sui tana tagu au adirutsumigira niqu tinoni tania na vera ni Ejipt, rongona inau na Taovia kau gini lia niqira God.” ");
INSERT INTO gri_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Igirani nogoria na ketsa ma na vali sui aia na Taovia e sauvania a Moses tana Vungavunga Sinai vanigira na toga ni Israel. ");
INSERT INTO gri_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Na Taovia e sauvania a Moses ");
INSERT INTO gri_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","na vovorona na ketsa girani vanigira na tinoni ni Israel. “Kalina kara balovania na Taovia kesa tinoni agana na manaliginiana kesa na veke, ma na dangana na qolo gana na tusutuguna na tinoni ia ");
INSERT INTO gri_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","ke muritaoninogoa na matena ara pedea tana tagu ia: — ti vaga kesa na mane loki, tû tana rukapatu me tsau tana ono sangavulunina ngalitupana: kara tsonia ke 50 tavina siliva — ti vaga kesa na daki loki: ke 30 tavina siliva — ti vaga kesa na mane vaolu, tû tana tsegenina me tsau tana rukapatunina ngalitupana: ke 20 tavina siliva — ti vaga kesa na daki vaolu: ke 10 tavina siliva — ti vaga kesa na baka mane e tau vati tsaulia na tsegenina ngalitupana: ke 5 tavina siliva — ti vaga kesa na baka daki e tau vati tsaulia na tsegenina ngalitupana: ke 3 tavina siliva — ti vaga kesa na mane loki e liusinogoa ono sangavulu ngalitupana: ke 15 tavina siliva — ti vaga kesa na daki loki e liusinogoa ono sangavulu ngalitupana: ke 10 tavina siliva. ");
INSERT INTO gri_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Me ti vaga na tinoni e naua na veke vaga iani, me tau tugua ke tsonia na matena popono vaga ara titinogoa, ma niqira aqo kara adimaia na tinoni ia vania na manetabu, ma na manetabu ke tsunali vania na matena vaga e tugua ke tsonia. ");
INSERT INTO gri_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Me ti vaga na veke ia ke kalea kesa na omea tuavati e ulagana na savori vaniana na Taovia, ma na omea tuavati ia e lia na omea tabu. ");
INSERT INTO gri_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Maia na mane e naua na veke ia, nina aqo ke tau goto adia sa omea tuavati tavosi ke tuguginia. Me ti vaga ke nauvaganana ia, mi kaira sui na omea tuavati kara ka lia nina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Me ti vaga na veke ia ke kalea kesa na omea tuavati e tau masidi tana vovorona na lotu, me tau ulagana na savori vaniana na Taovia, ma na mane ia nina aqo ke adi bâ na omea tuavati ia i konina na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Maia na manetabu ke vileketalua ti vaga na douna se na sekona, mi muri ti ke titivania na matena, me utu goto ke oli. ");
INSERT INTO gri_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Me ti vaga na mane ke ngaoa na volivisuana, ma nina aqo ke tsonia na matena ara titivaninogoa me ke pabogotoa ke visana na qolo. ");
INSERT INTO gri_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Me ti vaga ke kesa ke ngaoa na baloana na valena vania na Taovia, maia na manetabu ke vileketalua ti vaga na douna se na sekona, mi muri ti ke titivania na matena, me utu goto ke oli. ");
INSERT INTO gri_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Me ti vaga aia e balonogoa na valena vania na Taovia ke ngaoa na volivisuana, ma nina aqo ke tsonia na matena ara titivaninogoa me ke pabogotoa ke visana na qolo. ");
INSERT INTO gri_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Me ti vaga kesa tinoni ke balovania na Taovia ma turina nina kao, kara titia na matena muritaonia na dangana na vatuna na barli e tugua kara tsuka tana uta ia, ke sangavulu na tavina siliva na matena pipi rukapatu kilo na barli. ");
INSERT INTO gri_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Me ti vaga aia ke baloa nina kao ia kalina e vasini moa e sui na Ngalitupa na Sauvisu Omea, me kilia ke tsonia na matena popono. ");
INSERT INTO gri_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Me ti vaga aia ke baloa nina kao kesa tana tagu i muri, maia na manetabu ke titia na matena muritaonia na dangana na ngalitupa ara kau ti ke laba tugua na Ngalitupa na Sauvisu Omea, me ke tsunali vania na matena. ");
INSERT INTO gri_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Me ti vaga na mane aia e balonogoa na kao ia ke ngaoa na volivisuana, ma nina aqo ke tsonia na matena me ke pabogotoa. ");
INSERT INTO gri_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Me ti vaga na mane ia ke tau vati volivisua nina kao, ke tû me ke tsabiri vania kesa tinoni tavosi, me utu vanigotoa ke volivisua nina kao. ");
INSERT INTO gri_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mi kalina ke laba tugua na Ngalitupa na Sauvisu Omea, ma na kao ia ke tamanina saikesa nogo na Taovia; me ke lia niqira kao na manetabu. ");
INSERT INTO gri_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Ti vaga kesa tinoni ke balovania na Taovia kesa na kao aia e volinogoa i konina kesa tinoni tavosi, ");
INSERT INTO gri_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ma na manetabu ke titivania na matena muritaonia na dangana na ngalitupa ara kau ti ke laba tugua na Ngalitupa na Sauvisu Omea, ma nina aqo na mane ia ke tusua na matena tana dani nogo ia; ma na qolo ia nina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mi tana Ngalitupa na Sauvisu Omea na kao ia ke visutugua i konina na tamanina pukuga se i koniqira na kukuana. ");
INSERT INTO gri_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Na dangana na qolo kara titivanigira pipi na omea ke muritaoninogoa na matena ara pedea tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Me pipi na volati i laoqira na omea tuavati nina nogo na Taovia, me tabu vania kesa tinoni na gini savori tana nina padangaoa segeni, atsa moa ti na dalena buluka, se na dalena sipi se na dalena naniqoti, ara nina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Maia moa na volati i laoqira na omea tuavati ara tau masidi tana vovorona na lotu, e dou moa na volivisuana, me kilia na tamanina ke tsonia na matena vaga ara titinogoa me ke pabogotoa. Me ti vaga aia ke tau volivisua, me dou moa ti na manetabu ke tsabiria vania kesa na tinoni tavosi na matena vaga ara titinogoa. ");
INSERT INTO gri_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Ke laka goto ke kesa na tsabiriana se na volivisuana tugua na omea aia e balo saikesalinogoa vania na Taovia, atsa moa ti na tinoni, se na omea tuavati, se na kao. Aia nina tamani saikesa nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Atsa moa ti vaga kesa tinoni ara balo saikesalinogoa vania na Taovia, me utu goto kara volivisua; e kilia nomoa kara matesia. ");
INSERT INTO gri_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Na sangavulunina turina pipi na omea tsukatsuka me pipi na vuanagai, ara nina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Me ti vaga kesa tinoni ke ngaoa na volivisuana na turina, ma nina aqo ke tsonia na matena vaga ara titinogoa me ke pabogotoa. ");
INSERT INTO gri_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mi kalina ti kamu tû na tsokoaqira nimui omea tuavati papala, me pipi na sangavulunina ke tamanina nogo na Taovia. ");
INSERT INTO gri_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Me tabu vanigotoa na tamanina ke vilivotagira na douna ma na sekona, rongona ke gini saua moa na sekona, se ke adia kesa na omea tuavati tavosi ke tuguginia kesa segeni. Me ti vaga aia ke adia kesa na omea tuavati tavosi ke tuguginia kesa segeni, mi tana mi kaira sui ruka na omea tuavati nina omea sui moa na Taovia, me sauba ke utugana goto na volivisuaqira.” ");
INSERT INTO gri_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Igirani nogo na ketsa aia na Taovia e sauvania a Moses tana Vungavunga Sinai vanigira na toga ni Israel.");
INSERT INTO gri_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Tana kesanina dani tana rukanina vula i laona na rukanina ngalitupa i murina kalina igira na tinoni ni Israel ara mololea i Ejipt, ma na Taovia e goko vania a Moses i laona nina Valepolo Tabu, tana kaomate ni Sinai. Maia e tsari vaganana vania, ");
INSERT INTO gri_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Igoe ma Aaron, kagamu kamu ka aqosia ke kesa na tsoko tinoni i laoqira na toga ni Israel, murigira na duli ma na vungu. Kamu ka maretsunagira na soaqira pipi sui na mane ");
INSERT INTO gri_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ara tsaulia e rukapatu na ngalitupaqira me liusia, igira e tugugira nogo na sangasage tana alaala na mane vaumate. ");
INSERT INTO gri_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ma kamu ka vilia ke kesa na taoviana na duli ke talumai i laona pipi na puku ma kara sangakagamu.” ");
INSERT INTO gri_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Migirani nogo na soaqira na mane ara viligira kara sangakaira a Moses ma Aaron na nauana na aqo iani: tana puku konina a Ruben ara vilia a Elisur na dalena a Sedeur; tana puku konina a Simeon ara vilia a Selumiel na dalena a Surisadai; tana puku konina a Juda ara vilia a Nason na dalena a Aminadab; tana puku konina a Isakar ara vilia a Netanel na dalena a Suar; tana puku konina a Sebulun ara vilia a Eliab na dalena a Helon; tana puku konina a Epraim ara vilia a Elisama na dalena a Amihud; tana puku konina a Manase ara vilia a Gamaliel na dalena a Pedasur; tana puku konina a Benjamin ara vilia a Abidan na dalena a Gideoni; tana puku konina a Dan ara vilia a Ahieser na dalena a Amisadai; tana puku konina a Aser ara vilia a Pagiel na dalena a Okran; tana puku konina a Gad ara vilia a Eliasap na dalena a Deuel; tana puku konina a Naptali ara vilia a Ahira na dalena a Enan. ");
INSERT INTO gri_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Tugira sangavulu ruka na mane girani ara tu sangakaira a Moses ma Aaron ");
INSERT INTO gri_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na soasaiaqira sui lakalaka na saikolu popono tana kesanina dani tana rukanina vula, mara maretsunagira na soaqira na tinoni sui lakalaka muri duli ma na vungu. Ara tsokosaia mara maretsunâ na soaqira pipi sui lakalaka na mane ara tsaulia rukapatu na ngalitupaqira me liusia, ");
INSERT INTO gri_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","vaga nogo na Taovia e moloketsana vanigira. A Moses e maresoaqira na tinoni tana kaomate ni Sinai. ");
INSERT INTO gri_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","45","Migira na mane e rukapatu na ngalitupaqira me liusia, igira e tugugira kara sangasage tana alaala na mane vaumate ara maretsuna na soaqira muri duli ma na vungu, tuturiga tana puku konina a Ruben aia na idana dalena a Jakob. Ma na dangaqira e vaga iani: tana puku konina a Ruben ara 46,500 mane; tana puku konina a Simeon ara 59,300 mane; tana puku konina a Gad ara 45,650 mane; tana puku konina a Juda ara 74,600 mane; tana puku konina a Isakar ara 54,400 mane; tana puku konina a Sebulun ara 57,400 mane; tana puku konina a Epraim ara 40,500 mane; tana puku konina a Manase ara 32,200 mane; tana puku konina a Benjamin ara 35,400 mane; tana puku konina a Dan ara 62,700 mane; tana puku konina a Aser ara 41,500 mane; mi tana puku konina a Naptali ara 53,400 mane. ");
INSERT INTO gri_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Migira sui saisai na mane e rukapatu na ngalitupaqira me liusia ara 603,550. ");
INSERT INTO gri_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Migira moa na Levite ara tau maresoaqira kolugira na puku tavosi, ");
INSERT INTO gri_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","rongona na Taovia e tsarinogoa vania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Kalina igoe ko tû na maresoaqira na mane e tugugira nogo na sage tana alaala na mane vaumate, mo ko laka moa na maresai koluaqira igira na mane tana duli konina a Levi. ");
INSERT INTO gri_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ma nimu aqo ko molovanigira na Levite kara reitutugua na Valepolo i tana au totu inau, ma na vangana sui i laona. Igira nogo kara kalagaia kolu vangana sui ma kara naua niqira aqo tabu i laona, ma kara vaturikaegira niqira valepolo polipolia. ");
INSERT INTO gri_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Me pipi kalina ti vaga igamu kamu tû na vano kesa tana nauna segeni, migira nogo na Levite niqira aqo kara veoa na Valepolo Tabu, ma kara ba vaturikae tugua i tana sauba kamu ba totu. Masei tinoni tavosi ti ke ba liu varangisia na Valepolo Tabu ia, nimui aqo kamu labumatesia. ");
INSERT INTO gri_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Migira na tinoni ni Israel kara vaturikaea niqira valepolo muritaoninogoa niqira duli babâ, me pipi ma mane tana nina alaala segeni, mi vavana na pulaqena nina duli segeni. ");
INSERT INTO gri_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Migira na Levite kara vaturikaegira niqira valepolo polipolia na Valepolo Tabu ma kara vangataoa, rongona ke gini tau goto mai varangisia ke kesa, me ke gini tsaia na korequ, ma kau redogira na saikolu popono ni Israel.” ");
INSERT INTO gri_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Me vaga ia, migira na toga sui ni Israel ara naugira pipi sui na omea na Taovia e raiginia a Moses. ");
INSERT INTO gri_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ma na Taovia e goko vanikaira a Moses ma Aaron me tsaria, ");
INSERT INTO gri_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Kalina igira na toga ni Israel kara vangaraua na nauna i tana kara totu, me pipi tinoni tatasa nina aqo ke vaturikaea nina valepolo i vavana na pulaqena nina vungu ma nina duli segeni. Ma kara vaturikaegira polipolia na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","“Mi tabana i longa tugira na puku ara totu i vavana niqira pulaqe igira na Juda, kara totu tana niqira alaala i vavana gaqira ida: tana puku konina a Juda ara 74,600 mane, maia Nason na dalena a Aminadab gaqira ida; tana puku konina a Isakar ara 54,400 mane, maia Netanel na dalena a Suar gaqira ida; tana puku konina a Sebulun ara 57,400 mane, ma Eliab na dalena a Helon gaqira ida. ");
INSERT INTO gri_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Mi tugira sui saisai na alaala konina a Juda ara 186,400 mane. Me pipi kalina ti kamu tû na vano, migira nogo kara ida na vano. ");
INSERT INTO gri_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Mi tabana i ata tugira na puku ara totu i vavana niqira pulaqe igira na Ruben kara totu tana niqira alaala, i vavana gaqira ida: tana puku konina a Ruben ara 46,500 mane, ma Elisur na dalena a Sedeur gaqira ida; tana puku konina a Simeon ara 59,300 mane, ma Selumiel na dalena a Surisadai gaqira ida; tana puku konina a Gad ara 45,650 mane, ma Eliasap na dalena a Deuel gaqira ida. ");
INSERT INTO gri_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Mi tugira sui saisai na alaala konina a Ruben ara 151,450 mane, ma niqira aqo kara tsari ba i muriqira na Juda. ");
INSERT INTO gri_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Mi ka muriqira na kesanina ma na rukanina alaala ma kara tete tsari bâ igira na Levite kolua niqu Valepolo Tabu. Ma kara ka tsari i muri kaira na tolunina ma na vatinina alaala. Mi kalina ti kara aligiri na vavano, me pipi gira na alaala babâ kara vaitsarimurigi vaga goto. ");
INSERT INTO gri_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Mi tabana i tasi tugira na puku ara totu i vavana niqira pulaqe igira na Epraim, kara totu tana niqira alaala i vavana gaqira ida: tana puku konina a Epraim ara 40,500 mane, ma Elisama na dalena a Amihud gaqira ida; tana puku konina a Manase ara 32,200 mane, ma Gamaliel na dalena a Pedasur gaqira ida; tana puku konina a Benjamin ara 35,400 mane, ma Abidan na dalena a Gideoni gaqira ida. ");
INSERT INTO gri_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Mi tugira sui saisai na alaala konina a Epraim ara 108,100 mane, ma niqira aqo kara tete tsari muriqira na Levite. ");
INSERT INTO gri_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Mi tabana i vava, tugira na puku ara totu i vavana niqira pulaqe igira na Dan, kara totu tana niqira alaala i vavana gaqira ida: tana puku konina a Dan ara 62,700 mane, ma Ahieser na dalena a Amisadai gaqira ida; tana puku konina a Aser ara 41,500 mane, ma Pagiel na dalena a Okran gaqira ida; tana puku konina a Naptali ara 53,400 mane, ma Ahira na dalena a Enan gaqira ida. ");
INSERT INTO gri_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Mi tugira sui saisai na alaala i konina a Dan ara 157,600 mane, migira kara tete tsari i muri tsotsodo.” ");
INSERT INTO gri_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","E saisai na dangaqira na tinoni popono ni Israel i laona niqira alaala babâ mara tsaulia 603,550. ");
INSERT INTO gri_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mara tau maretsunâ na soaqira na Levite kolugira na tinoni tavosi ni Israel vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Me vaga ia, migira na tinoni ni Israel ara muria na omea na Taovia e ketsaliginia a Moses. Pipi tinoni e vaturikaea nina valepolo i vavana nina pulaqe segeni nogo, mi kalina ara vavano, me pipi tinoni e vano kolua nina duli segeni. ");
INSERT INTO gri_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iani nogoria e vaga na tamadale ka koniqira a Aaron ma Moses tana tagu na Taovia e goko vania a Moses tana Vungavunga Sinai. ");
INSERT INTO gri_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","A Aaron e tamanitugira vati na dalena mane: tugira a Nadab aia na idana botsa, ma Abihu, ma Eleasar ma Itamar. ");
INSERT INTO gri_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Tugira ara ninaginitugira na oela tabu, mara tu lia na manetabu, ");
INSERT INTO gri_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","mi kaira a Nadab ma Abihu na Taovia e matesikaira tana kaomate ni Sinai kalina ara ka gini savori-sausau vania na Taovia na lake lê e tau tabu. Mara ka tau goto tamani ka daleqira, me vaga ia mi kaira moa a Eleasar ma Itamar ara ka aqo manetabu tana maurina popono a Aaron. ");
INSERT INTO gri_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ko adimaigira na puku konina a Levi ieni i matana a Aaron na manetabu, mo ko molokaegira kara lia gana sasanga aia. ");
INSERT INTO gri_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Igira nogo kara naua na aqo i laona na Valepolo i tana au totu inau, ma kara sangagira na manetabu migira na toga popono tana aqo vaniaqu inau. ");
INSERT INTO gri_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Igira nogo kara reitutugua pipi na vangana sui niqu Valepolo Tabu, ma kara aqo tuguqira na toga sui tana Israel. ");
INSERT INTO gri_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ngiti niqira aqo kalavata nogo igira na Levite, aia na sangaana a Aaron ma na dalena. ");
INSERT INTO gri_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Mo ko molokaetugira a Aaron ma na dalena ma kara tu naua tu niqira aqo manetabu. Me ti vaga ke kesa ke tavongani tovoa laka ke naua na aqo vaga ia, ma nimui aqo kamu labumatesia.” ");
INSERT INTO gri_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Me goko tugua na Taovia me tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Mi kalina ia, migira na Levite ara lia niqu tamani segeni nogo inau. Tana tagu kalina inau au labumatesigira pipi sui na baka mane botsaida i laoqira na Ejipt, minau au balovaniau segeni pipi na baka mane botsaida i laoqira na Israel, migira goto na daleqira mane botsaida pipi sui na omea tuavati. Mi kalina ia, migira na Levite ara lia nogo na tuguqira na baka mane botsaida tana Israel; ara lia niqu tamani segeni nogo inau. Inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mi laona na Kaomate ni Sinai, na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ke tsokoa na dangaqira na tinoni tana puku konina a Levi, me ke muri duli ma na vungu me ke maresoaqira pipi na baka mane ara tsaulinogoa kesa na vulaqira me liusia, ");
INSERT INTO gri_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","maia Moses e nauvanganana ia. ");
INSERT INTO gri_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","A Levi e tamanitugira tolu na dalena mane: tugira nogo a Gerson, ma Kohat ma Merari. ");
INSERT INTO gri_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Maia Gerson e tamanikaira ruka na dalena mane: kaira nogo a Libni ma Simei. ");
INSERT INTO gri_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ma Kohat e tamanitugira vati na dalena mane: tugira nogo a Amram, ma Isar, ma Hebron, ma Usiel. ");
INSERT INTO gri_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Maia Merari e tamanikaira ruka na dalena mane: kaira nogo a Mali ma Musi. Mi tugira nogo na mumuaqira na vungu ara adidatoa na soa tu koniqira. ");
INSERT INTO gri_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Na duli konina a Gerson e tamanina ruka moa na vungu, na vungu ka koniqira a Libni ma Simei. ");
INSERT INTO gri_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ma na dangana na mane ara maretsunâ na soaqira, igira e tû tana kesa vulaqira me liusia ara tsaulia e 7,500. ");
INSERT INTO gri_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Migira tana duli iani kara vaturikaea niqira valepolo i murina na Valepolo Tabu tabana i tasi, ");
INSERT INTO gri_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","maia Eliasap na dalena a Lael aia nogo gaqira taovia. ");
INSERT INTO gri_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Niqira aqo igira na reitutuguana na Valepolo Tabu, na tsatsavuna ni laona ma na tsatsavuna ni taba, na polokatsi e tsau tsuna tana matsapana na Valepolo, ");
INSERT INTO gri_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","migira na polokatsi ara barapoliginia na pakokana na Valepolo ma na belatabu, ma na polokatsi e tsautsuna tana matsapana na bara ia. Niqira aqo nogo igira na nauana pipi na aqo e kalegira na omea girani. ");
INSERT INTO gri_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Maia na duli konina a Kohat e tamanina vati na vungu, tugira nogo na vungu tu koniqira a Amram, ma Isar, ma Hebron, ma Usiel. ");
INSERT INTO gri_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ma na dangana na mane ara maretsunâ na soaqira igira e tû tana kesa vulaqira me liusia ara tsaulia 8,600. ");
INSERT INTO gri_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Migira tana duli iani kara vaturikaea niqira valepolo i tabana i ata na Valepolo Tabu, ");
INSERT INTO gri_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ma Elisapan na dalena a Usiel aia nogo gaqira taovia. ");
INSERT INTO gri_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Niqira aqo igira na reitutuguana na Bokisi na Taso, na bela tana ara moloa na bredi tabu, na gai na mani molodato bilona bulu iruiru, kaira na belatabu, ma na omea levolevo igira na manetabu ara gini aqo i laona na Nauna Tabu, ma na polokatsi e voroa na mani sage bâ tana Nauna Tabu Loki. Niqira aqo nogo igira na nauana pipi na aqo e kalegira na omea girani. ");
INSERT INTO gri_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ma gaqira taovia igira na Levite aia nogo a Eleasar na dalena a Aaron na manetabu. Aia e ida vanigira igira ara tangolia na aqo i laona na Nauna Tabu. ");
INSERT INTO gri_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ma na duli konina a Merari e tamanina ruka moa na vungu, kaira na vungu ka koniqira a Mali ma Musi. ");
INSERT INTO gri_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ma na dangana na mane ara maretsunâ na soaqira, igira e tû tana kesa vulaqira me liusia ara tsaulia 6,200. ");
INSERT INTO gri_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Migira tana duli iani kara vaturikaea niqira valepolo i tabana i vava na Valepolo Tabu, ma Suriel na dalena a Abihail aia nogo gaqira taovia. ");
INSERT INTO gri_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Niqira aqo igira na reitutuguaqira na pava damadama agana na mani vaturikaeana na Valepolo, ma na qaroqaro, ma na tuguru, ma na tototoqira, me pipi sui na omeana levolevo. Niqira aqo nogo igira na nauana pipi na aqo e kalegira na omea girani. ");
INSERT INTO gri_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Migira goto kara reitutugugira na tuguruna na bara e polipolia na pakokana na Valepolo Tabu ma na tototoqira, ma na takutina gai tetelo ma na itai gana na mani sorikakaiaqira na polo ara barapoliginia na pakokana. ");
INSERT INTO gri_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ma Moses ma Aaron migira na dalena kara tu vaturikaea tu niqira valepolo i matana na Valepolo Tabu tabana i longa. Tu niqira aqo tugira na sage i laona na Nauna Tabu ma na nauana na aqo tabu sui tuguqira na tinoni ni Israel. Me ti vaga ke kesa ke tavongani tovoa laka ke naua na aqo vaga ia, ma niqira aqo kara labumatesia. ");
INSERT INTO gri_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ma na dangaqira na mane tana puku konina a Levi, igira e tû tana kesa vulaqira me liusia, igira a Moses e maresoaqira muri duli vaga nogo na Taovia e moloketsana vania, ara saisai mara 22,000. ");
INSERT INTO gri_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ma na Taovia e tsarivania a Moses, “Pipi sui na baka mane botsaida tana Israel ara niqu tamani sui inau. Me vaga ia, ma nimu aqo ko maresoaqira sui pipi na baka mane botsaida tana Israel, igira e kesa na vulaqira me liusia. ");
INSERT INTO gri_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Mi muri migoe ko balogira sui na Levite vaniau inau na Taovia, na tuguqira na baka mane botsaida tana Israel; ma niqira buluka na Levite na tuguqira niqira dalena buluka mane botsaida na Israel.” ");
INSERT INTO gri_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ma Moses e rongomangana na Taovia me maretsunâ na soaqira pipi sui na baka mane botsaida tana Israel, ");
INSERT INTO gri_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","igira e kesa na vulaqira me liusia; mara saisai mara tsaulia 22,273. ");
INSERT INTO gri_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ma na Taovia e tsarivanigotoa a Moses, ");
INSERT INTO gri_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Mi kalina ia, migoe ko balogira na Levite vaniau ma kara lia na tamaniqu inau, na tuguqira na daleqira mane botsaida na tinoni ni Israel, mo ko balogira vaniau goto niqira buluka na Levite, na tuguna niqira dalena buluka mane botsaida na Israel. ");
INSERT INTO gri_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ma na dangana na daleqira mane botsaida igira na Israel ara 273 liusia na dangaqira na Levite. Me vaga ia me kilia igoe ko volivisugira na 273 ara liuliu. ");
INSERT INTO gri_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Me pipi kesa tatasa ko voliginia ke tsege na tavina siliva, taoninogoa na pedemamava ara gini aqo tana tagu ia, ");
INSERT INTO gri_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","mo ko saua na qolo iani vanitugira a Aaron ma na dalena.” ");
INSERT INTO gri_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ma Moses e rongomangana na Taovia me adigira ");
INSERT INTO gri_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","na 1,365 tavina siliva, ");
INSERT INTO gri_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","me tusuvanitugira a Aaron ma na dalena. ");
INSERT INTO gri_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ko tsokoa na dangaqira na tinoni tana duli konina a Kohat, ke muri vungu ma na tina babâ, ");
INSERT INTO gri_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","mo ko maresoaqira pipi na mane ke tû tana tolu sangavulu me ke tsau tana tsege sangavulu na ngalitupaqira, igira e tugugira na nauana na aqo i laona na Valepolo i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ma niqira aqo igira na reitutuguaqira na omea ara tabu loki sosongo. ");
INSERT INTO gri_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Mi kalina ti vaga igira na tinoni ni Israel kara ngaoa na vano kesa tana nauna vaolu, ma tu niqira aqo talu a Aaron ma na dalena kara tu sage bâ tana Valepolo Tabu, ma kara tu aditsunâ na polokatsi e tsautsau i matana na Bokisi na Taso, ma kara tu tsavupoiginia na Bokisi. ");
INSERT INTO gri_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ma kara tu tsavu kaputiginia kesa sangava na kokorana naniqoti malutsi, ma kara vuresia kesa na polo bora i kelana, mi muri ma kara tsukulaginisage kaira na gai na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Ma kara tsaboa kesa na polo bora i kelana na bela i tana ara molokaegira na bredi ara savorivania na Taovia, ma kara moloa i konina na peleti, ma na tseu na mani molo bulunagai uruuru, ma na tseu ara gini aqo tana sausau, ma na tosu ara gini aqo tana sausau na uaeni. Ma na bredi goto ke totu sailagi i kelana na bela ia. ");
INSERT INTO gri_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ma na omea sui girani kara tsaboginia kesa na polo tsitsi, ma kara tsavu kaputiginia kesa sangava na kokorana naniqoti malutsi, mi muri ma kara tsukulaginisage kaira na gai na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ma kara adia kesa na polo bora ma kara tsavuginia na gai na molodato buluna gai iruiru, kolu na vangana levolevo, na bilo, na kapi, ma na tosu agana na molotsavuana na oela na olive. ");
INSERT INTO gri_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kara veqodoua na gaina kolu vangana sui kesa tana sangava na kokorana naniqoti malutsi, ma kara molokaegira i kelana kesa na bela na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Mi muri, ma kara adia kesa na polo bora ma kara tsaboa i kelana na belatabu qolumila, ma kara tsavu kaputiginia kesa sangava na kokorana naniqoti malutsi, mi muri ma kara tsukulaginisage kaira na gai na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ma kara adigira goto pipi sui na omea levolevo ara gini aqo tana Nauna Tabu ma kara veqodougira ginia kesa na polo bora, ma kara tsavu kaputiginigira kesa sangava na kokorana naniqoti malutsi, ma kara molokaegira i kelana kesa na bela na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kara adiligia na torana na omea ara gini kodoputsa tania na belatabu, ma kara vuresia kesa na polo tsitsibora i kelana. ");
INSERT INTO gri_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ma kara molo bâ i konina pipi sui na vangana na omea levolevo ara gini aqo tana belatabu: na bilo tapala na mani kodoana na bulunagai uruuru i laona, na salili, na savolo, ma na popo. Mi muri ma kara tsavu kaputiginia kesa na sangava na kokorana na naniqoti malutsi, ma kara tsukulaginisage kaira na gai na kalagai. ");
INSERT INTO gri_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Mi kalina ke laba na tagu na vano kesa tana nauna vaolu ma Aaron mi tugira na dalena ara tu tsavusuigira nogo na omea tabu, mi tana ti migira na duli konina a Kohat kara mai, ma kara kalagaigira na omea tabu sui girani. Ma niqira aqo moa kara laka saikesa na peleaqira na omea tabu girani, me ti kara pelegira me sauba nomoa kara mate. “Igirani na omea niqira aqo nogo igira tana duli konina a Kohat kara reitutugugira kalina ti vaga kara oli sasana na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Maia Eleasar na dalena a Aaron na manetabu nina aqo na reitutuguana na Valepolo popono, ma na oela gana na laeti, na bulunagai uruuru, na uiti gana na sausau, na oela na mani ninina, me pipi sui goto na omea tavosi i laona na Valepolo Tabu igira ara balovaniau nogo inau na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ma na Taovia e tsarivanikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kalina igira tana duli konina a Kohat kara mai na adiaqira na omea tabu girani, ma ka nimui aqo kagamu kamu ka reitutugugira dou kara tau pelea sa omea tabu, ");
INSERT INTO gri_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ma kara tau gini mate. Ma na didiana rongona ke tau laba na omea vaga iani, tugira segeni moa a Aaron ma na dalena, kara sage i laona na Valepolo Tabu ma kara vota aqo vania pipi tinoni tatasa, ma kara pede vania na omea aia ke kalagaia. ");
INSERT INTO gri_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Me ti vaga igira tana duli konina a Kohat kara sage bâ tana Valepolo Tabu, ma kara reilakaqira na manetabu kalina ara vangaraugira na omea tabu gana na vavano, me sauba nomoa kara mate.” ");
INSERT INTO gri_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ma na Taovia e tsarigotoa vania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Ko tsokoa na dangaqira na tinoni tana duli konina a Gerson, ke muri vungu ma na tina babâ, ");
INSERT INTO gri_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","mo ko maresoaqira pipi na mane ke tû tana tolu sangavulu me ke tsau tana tsege sangavulu na ngalitupaqira, igira e tugugira na nauana na aqo i laona na Valepolo Tabu i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ma niqira aqo nogo igira na kalagaiaqira na omea sui vaga girani: ");
INSERT INTO gri_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","na Valepolo Tabu, na tsatsavuna ni laona, ma na tsatsavuna ni taba, ma na sangava na kokorana na naniqoti ara tsavuginia, ma na polokatsi e tsautsuna i savuna matsapana, ");
INSERT INTO gri_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","migira na polokatsi ma na itaiqira ara barapoliginia na pakokana polipolia na Valepolo ma na belatabu, migira na polokatsi e tsautsuna tana matsapana na bara ia, me pipi sui na omea levolevo ara gini aqo tana vaturiaqira na omea girani. Niqira aqo nogo igira na nauana pipi na aqona na omea sui girani. ");
INSERT INTO gri_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ma tu niqira aqo nogo a Aaron, ma na dalena kara tu reitutugua ti na tinoni tana duli konina a Gerson kara naudoua niqira aqo, ma kara kalagaigira pipi na omea sui ara tu pedevanigira na kalagaiana. ");
INSERT INTO gri_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Igira nogo na omea niqira aqo igira tana duli konina a Gerson kara naua i laona na Valepolo Tabu; ma kara naua i vavana nina tagao a Itamar na dalena a Aaron na manetabu. ");
INSERT INTO gri_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Mo ko tsokogotoa na dangaqira na tinoni tana duli konina a Merari, ke muri vungu ma na tina babâ, ");
INSERT INTO gri_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","mo ko maresoaqira pipi na mane ke tû tana tolu sangavulu me ke tsau tana tsege sangavulu na ngalitupaqira, igira e tugugira na nauana na aqo i laona na Valepolo i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ma niqira aqo igira na kalagaiaqira na pava damadama, na qaroqaro, na tuguru kolu tototoqira gana na Valepolo Tabu, ");
INSERT INTO gri_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","migira goto na tuguru kolu tototoqira, ma na gai tetelo ma na itai gana na mani sorikakaiaqira na polo ara barapoliginia na pakokana na Valepolo Tabu, me pipi sui na omea levolevo ara gini aqo tana vaturiaqira na omea girani. Pipi mane tatavosi nina aqo ke kalagaia na omea na manetabu ara pedevania. ");
INSERT INTO gri_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Igira nogo na omea niqira aqo igira tana duli konina a Merari kara naua i laona na Valepolo Tabu; ma kara naua i vavana nina tagao a Itamar na dalena a Aaron na manetabu.” ");
INSERT INTO gri_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","47","Maia Moses ma Aaron, migira na ida i laoqira na saikolu popono, ara naua na omea e ketsaliginigira na Taovia, mara tsokoa na dangaqira na mane sui i laoqira na duli tu koniqira a Kohat, ma Gerson, ma Merari, tugira na dalena a Levi. Mara muri vungu ma na tina babâ, mara maresoaqira pipi na mane, igira e tû tana tolu sangavulu me tsau tana tsege sangavulu na ngalitupaqira, igira e tugugira na nauana na aqo i laona na Valepolo Tabu i tana e totu na Taovia. Ma na dangaqira e vaga iani: tana duli konina a Kohat ara 2,750 mane; tana duli konina a Gerson ara 2,630 mane; tana duli konina a Merari ara 3,200 mane. ");
INSERT INTO gri_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Me saisai igira sui mara 8,580 mane. ");
INSERT INTO gri_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ara maresoana pipi mane tatasa vaga nogo na Taovia e ketsaliginia a Moses; mara pedevania pipi na mane tatasa gana aqo ke naua i laona na Valepolo, ma na omea aia ke kalagaia. ");
INSERT INTO gri_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ko ketsaligira na tinoni ni Israel kara railigigira tania na nauna tana amu vaturikaea nimui valepolo, igira sui e gadovigira na lobogu seko na mudo, se ke rutsu na butongo tana koniqira, migira sui goto ara kaulinaqu rongona ara pelea na konina tinoni mate. ");
INSERT INTO gri_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ko railigigira sui na tinoni vaga girani ara kaulinaqu taonia na vovorona na lotu, rongona kara tau naqugasiginia na nauna i tana amu tototu igamu, mi tana goto au totu inau i levugamui igamu niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Migira na tinoni ni Israel ara rongomangana na Taovia, mara railigigira sui lakalaka igira e gadovigira na lobogu vaga gira tania na nauna tana ara tototu. ");
INSERT INTO gri_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Na Taovia e ketsalia a Moses ke sauvanigira na tinoni ni Israel na goko totosasaga vaga girani, ");
INSERT INTO gri_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Kalina ti ke kesa na mane se na daki ke tau muridoua niqu ketsa inau, me ke tû me ke naua kesa na omea seko vania kesa tinoni tavosi, ");
INSERT INTO gri_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","maia nina aqo ke katevulagia nina sasi, me ke tsonia na matena popono, me ke paboginigotoa rukapatu i kelana pipi kesa sangatu, me ke tusuvania na tinoni aia e nauvania na omea seko. ");
INSERT INTO gri_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Me ti vaga na tinoni ia aia e nauvania na omea seko ke mate nogo, me ke tau goto totu ke kesa na kamana varavara tugua aia ke tsonivania na qolo matena nina sasi, ma nina aqo ke sauvania moa na Taovia, me ke aditamanina na mane tabu, me ke saugotoa kesa na sipi mane gana na suisui matena na loana. ");
INSERT INTO gri_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Me ke vaga goto igira na sausau tabu sui na tinoni ni Israel kara sauvaniau inau na Taovia, ke aditamanina nogo aia na manetabu igira ara sauvania tana dani ia. ");
INSERT INTO gri_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Pipi sui na omea igira na tinoni kara sauvania kesa na manetabu ke gini savori vaniau inau, ke aditamanina na manetabu ia.” ");
INSERT INTO gri_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","ke tsarivaganana iani vanigira na tinoni ni Israel. “Kalina ti vaga ke kesa na mane ke gunurua laka na tauna e ba maturu kolua kesa na mane tavosi, maia ke tau moa dona dou ti na manana, rongona na tauna e naupoia me tagara kesa ke reia. Me tau utu ke kesa na mane ke tavongani gunurua laka na tauna e maturu kolua kesa na mane tavosi kalina aia e tau maturu kolua. ");
INSERT INTO gri_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Me ti kalina ke laba na omea vaga ia, ma nina aqo na mane ia ke adi bâ na tauna i matana na manetabu. Me ke adigotoa kesa na kilo na pulaoa na barli ngiti sausau, me ke laka goto na qetu tsavuana na oela na olive i konina, se na moloana na bulunagai uruuru i kelana, rongona na savori vaga ia nina kesa na mane e gunurua na tauna me ngaoa ke gini adilabatia i malena na manana. ");
INSERT INTO gri_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Ma na manetabu ke soamaia na daki ke mai tû i matana na belatabu. ");
INSERT INTO gri_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ma na manetabu ke qetu tsavua na kô tabu i laona kesa na bilo vatu, me ke karoa visana na kao i laona na Valepolo i tana au totu inau, me ke molotsavua i laona na kô me ke gini vavai. ");
INSERT INTO gri_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Me ke nusiligi vania na sosorina na ivuna na daki ia, me ke molo bâ na sausau na pulaoa i limana. Ma na manetabu ke tangolia na bilo e totu na kô vavai i laona, aia nogo e dona ke redo tinoni. ");
INSERT INTO gri_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Mi muri, ma na manetabu ke ngasua na daki ia ke tabea na goko na vealagi vaga aia ke tsarivania. Me ke goko vaga iani: ‘Ti vaga igoe o tau kiboga, me sauba ke tau labusaginigo na vealagi kalina ko inuvia na kô iani. ");
INSERT INTO gri_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Me ti vaga igoe o kibogagamu manana, ");
INSERT INTO gri_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","maia na Taovia ke naua ma na soamu ke tangiseko i laoqira nimu tinoni sui. Me ke naua ma na meamu ke kukuperuperu ma na tobamu ke subu. ");
INSERT INTO gri_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ma na kô vavai nogo iani ke sage i tobamu me ke gini subu, ma na meamu ke kukuperuperu.’ “Ma na daki ke gokovisu me ke tsaria, ‘Eo, au tami. Na Taovia ke nauvaganana nogo ia.’ ");
INSERT INTO gri_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Mi tana, ma na manetabu ke maretsuna na gokona na vealagi ia, me sui me ke vuliligia na mamarena i laona na bilona na ko vavai. ");
INSERT INTO gri_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Mi tana idana ke saua na kô ia vania na daki ke inuvia, aia e tau utu ke vavaisi sekolia na tobana me ke sosongo loki, ");
INSERT INTO gri_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","na manetabu ke adiligia na sausau na pulaoa tania na limana na daki, me ke saukaea papadana e baloa vania na Taovia, me ke ba moloa i kelana na belatabu. ");
INSERT INTO gri_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Mi muri, me ke adia kesa na kakarona na pulaoa me ke kodoa tana belatabu ngiti papadana laka e savori poponoa vania na Taovia. Mi tana susuina maia ke saua na kô vania na daki ke inuvia. ");
INSERT INTO gri_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Me ti vaga ke kibogagana manana, ma na kô ia sauba ke tsukia me ke gini vatsangi savi sosongo, me ke subu na tobana, me ke gini kukuperuperu na meana. Ma na soana ke tangiseko i laoqira na tinoni. ");
INSERT INTO gri_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Me ti vaga na daki ia e tau naua sa sasi, me sauba na kô ia ke tau lelê labusaginia, me sauba ke tangomana moa na tamani dalena. ");
INSERT INTO gri_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“Iani nogo na ketsa e kalea na mane e masugu me gunurua laka e kiboga na tauna. Kara turuvaginia na daki ia i matana na belatabu, maia na manetabu ke nauvania na omea vaga ia. ");
INSERT INTO gri_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ma na mane aia na savana na daki ia, e tau gini loaga sa omea, ma na daki moa ia, ti vaga ke manalia laka aia e kiboga, sauba nomoa ke gadovia na rota rongona nina aqo seko e naua.” ");
INSERT INTO gri_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ke sauvanigira na tinoni ni Israel na vovorona vaga girani. “Ti vaga ke kesa na mane se na daki ke naua kesa nina veke gana na lia na Nasirite, me ke balo segenina vaniau na Taovia, ");
INSERT INTO gri_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","maia nina aqo ke mololea na inu uaeni ma na bia. Me ke laka goto na inuviana na kôna na vuana na uaeni, se na ganiana na vuana vaolu se na makedena. ");
INSERT INTO gri_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mi tana tagu popono aia e vali, ma nina aqo ke tau goto gania ke kesa na omea ke talumai tana itai na uaeni; atsa moa ti na vatuna se na kokorana lê na vuana. ");
INSERT INTO gri_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Mi tana tagu popono ke vali, ke laka na putsiligiana na ivuna se na tsaraligiana na ngolana. Maia e ngolia na muri kalavataviana na aqona na omea e gini veke tana tagu popono aia e balo segenina vaniau na Taovia, me ke moloa ke rau na ivuna me ke katsi na ngolana. ");
INSERT INTO gri_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Ma na ivuna rau nogo e lia na papadana laka aia e balo segenina vania God, me vaga ia ma nina aqo ke tau gini kaulinaqu tana ba varangisiana na tsaborona tinoni mate, atsa moa ti na tsaborona tamana, se tinana, se kulana, se vavinena. ");
INSERT INTO gri_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tana tagu popono aia e totu tana vali, maia e balo segenina nogo vaniau na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Me ti vaga ke tavongani mate kesa tinoni i ligisana aia e balo segenina vaniau, ma na ivuna e gini kaulinaqu nogo, ma nina aqo ke pitu ke vitu na dani, mi muri ti ke putsiligia na ivuna me ke tsarâ na ngolana; mi tana nauvaganana ia ke gini male dou tugua taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Mi tana alunina dani maia ke adimai ke ruka na kulukulu se ke ruka na kurau i matana na Valepolo i tana au totu inau, me ke saukaira vania na manetabu. ");
INSERT INTO gri_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ma na manetabu nina aqo ke savoria kesa gana na savori matena na sasi, me kesa gana na savori-kodokodo, na mani suisui matena nina sasi rongona e kutsia na valina kalina aia e ba varangisia na konina tinoni mate. Mi tana dani goto nogo ia, ma na mane ia ke balo visutugua na ivuna, ");
INSERT INTO gri_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","me ke sausegenina vaolu tugua vaniau na Taovia. Na tagu popono tana idana aia e ba varangisia na konina tinoni mate e tau nogo mana, rongona aia e kaulinaqu nogo. Ma nina aqo goto ke adimaia kesa na dalena sipi ke kesa moa na ngalitupana ngiti sausau na volivisu. ");
INSERT INTO gri_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Mi kalina kesa na Nasirite ke sui nina tagu na veke, maia nina aqo ke nauvaganana iani: Aia ke bâ tana matsapana na Valepolo Tabu, ");
INSERT INTO gri_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","me ke sauvania na Taovia ke tolu na omea tuavati me ke tau goto seko sa tabana tu koniqira: ke kesa na dalena sipi mane e kesa moa na ngalitupana agana na savori-kodokodo, me ke kesa na dalena sipi daki e kesa moa na ngalitupana gana na savori matena na sasi, me kesa na sipi mane gana na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Me ke saugotoa kesa na dangana kopeta na bredi e tagara isti konina: na sivona bredi matolu ara aqosiginia na pulaoa ara lalokoluginia na oela na olive, ma na biskete ara gitsi koluginia na oela na olive, me ke paboginigotoa na sausau na uiti ma na uaeni vaga ara pedenogoa. ");
INSERT INTO gri_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ma nina aqo na manetabu ke saugira pipi sui na omea girani vania na Taovia, me ke savoria na sausau matena na sasi ma na savori-kodokodo. ");
INSERT INTO gri_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Me ke gini savoria na sipi mane vania na Taovia gana na kodoputsa tangomana na tinoni kara ganipatâ na turina, me ke saukolugotoa kesa na dangana na kopeta na bredi; me ke savorigotoa na sausau na uiti ma na uaeni. ");
INSERT INTO gri_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Mi matana nogo na Valepolo Tabu aia na Nasirite ke putsiligia na ivuna me ke molo ba gira tana lake i tana ara kodoa na vangana na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Mi muri kalina ke magovo nogo na arana na sipi mane, maia ke adikolua kesa na sivona bredi matolu, me kesa na biskete, me ke molobagira tana limana na Nasirite. ");
INSERT INTO gri_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Mi muri, ma na manetabu ke savorigira vaga kesa na sausau laka vania na Taovia; ma na sausau tabu girani ara lia gaqira tuva na manetabu, paboginia na paparina na arona ma kesa tuana na sipi mane. Mi murina ia, ma na tinoni ia e tau nogo vali vania na inu uaeni. ");
INSERT INTO gri_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Iani nogo e vaga na vovorona na ketsa e kalegira na Nasirite; me ti vaga ke kesa na Nasirite ke ngaoa na sauana kesa goto na omea segeni paboginia na omea ara pedevaninogoa, maia nina aqo ke tau tagara na manaliana.” ");
INSERT INTO gri_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","ke tsarivanitugira a Aaron ma na dalena kara tu gini aqo na tsaqina goko vaga girani tana tabuginiaqira na tinoni ni Israel: ");
INSERT INTO gri_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Na Taovia ke tabugamu me ke vangataogamu; ");
INSERT INTO gri_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Na Taovia ke irovigamu me ke vangalaka vanigamu. ");
INSERT INTO gri_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Na Taovia ke galuvegamu, me ke tusuvanigamu nina rago. ");
INSERT INTO gri_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Me ti vaga kara tu soâ na asaqu inau kalina kara tu tabugira na tinoni ni Israel, minau sauba kau tabugira manana.” ");
INSERT INTO gri_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mi tana dani a Moses e suilavaginia na vaturikaeana na Valepolo i tana e totu na Taovia, maia e adia na oela tabu me ninaginia me tabua kolugira goto na vangana sui i laona, ma na belatabu me pipi sui lakalaka na vangana na mani aqo i konina. ");
INSERT INTO gri_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Mi tana migira na taovia na duli igira na ida i laoqira na puku ni Israel, igira tsotsodo nogo na mane ara tangolinogoa na aqona na maresoaqira na tinoni, ");
INSERT INTO gri_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ara tû mara adimaigira niqira sausau vania na Taovia: e ono na terê me sangavulu ruka na buluka na aqo, ke kesa na terê vania pipi ruka na ida, me pipi na ida e tango kesa na buluka na aqo. Mara saugira vania na Taovia i matana na Valepolo Tabu. Me sui ia, ");
INSERT INTO gri_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ko adigira na vangalaka girani mo ko tusugira vanigira na Levite, gana kara gini aqo tana lutsangiana na Valepolo Tabu.” ");
INSERT INTO gri_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Me vaga ia, ma Moses e saugira na terê ma na buluka vanigira na Levite. ");
INSERT INTO gri_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Me tusua ruka na terê me vati na buluka na aqo vanigira na duli konina a Gerson, ");
INSERT INTO gri_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","me vati na terê me alu na buluka na aqo vanigira na duli konina a Merari. Me pipi sui lakalaka na aqo ara naua kara naua i vavana nina tagao a Itamar na dalena a Aaron. ");
INSERT INTO gri_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ma Moses e tau tusua sa terê se sa buluka na aqo vanigira na duli konina a Kohat, rongona na omea tabu ara reitutugua igira, niqira aqo kara kalagaigira tana kokoveqira. ");
INSERT INTO gri_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Migira na ida ara adimaigira goto niqira sausau na mani lokisiana na dani na tabuana na belatabu. Mi kalina igira ara mai nogo na sauana niqira vangalaka tana belatabu, ");
INSERT INTO gri_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ma na Taovia e tsarivania a Moses, “Ko tsarivanigira laka pipi dani i laona ke sangavulu ruka na dani, ke kesa i laoqira na ida ke saua nina vangalaka agana na tabuana na belatabu.” ");
INSERT INTO gri_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Migira ara adimaigira tatasa niqira sausau tana dani vaga girani. Tana kesanina dani, a Nason na dalena a Aminadab tana puku konina a Juda e adimaia nina sausau. Tana rukanina dani, a Netanel na dalena a Suar tana puku konina a Isakar e adimaia nina sausau. Tana tolunina dani, aia Eliab na dalena a Helon tana puku konina a Sebulun e adimaia nina sausau. Tana vatinina dani, aia Elisur na dalena a Sedeur tana puku konina a Ruben e adimaia nina sausau. Tana tsegenina dani, aia Selumiel na dalena a Surisadai tana puku konina a Simeon e adimaia nina sausau. Tana ononina dani, aia Eliasap na dalena a Deuel tana puku konina a Gad e adimaia nina sausau. Tana vitunina dani, aia Elisama na dalena a Amihud tana puku konina a Epraim e adimaia nina sausau. Tana alunina dani, a Gamaliel na dalena a Pedasur tana puku konina a Manase e adimaia nina sausau. Tana siunina dani, aia Abidan na dalena a Gideoni tana puku konina a Benjamin e adimaia nina sausau. Tana sangavulunina dani, aia Ahieser na dalena a Amisadai tana puku konina a Dan e adimaia nina sausau. Tana sangavulu kesanina dani, aia Pagiel na dalena a Okran tana puku konina a Aser e adimaia nina sausau. Tana sangavulu rukanina dani, aia Ahira na dalena a Enan tana puku konina a Naptali e adimaia nina sausau. Migira sui na sausau pipi vidaqira ara adimaia ara atsa sui saikesa: pipi kesa e tango kesa na popo siliva, e kesa kilo me kesa turina na mamavana, me kesa na bilo siliva e alu sangatu gram na mamavana, taonia na tovomamava ara gini aqo tana tagu ia, mi kaira sui ara dangaliginikaira na pulaoa lalokolua na oela agana na sausau na uiti; me kesa na pileti qolu e kesa sangatu sangavulu kilo na mamavana, ara dangaliginia na bulunagai uruuru; me kesa na buluka mane vaolu, me kesa na sipi mane, me kesa na dalena sipi e kesa moa na ngalitupana tugira agana na savori-kodokodo; me kesa na naniqoti na mani savori matena na sasi; me ruka na buluka mane, me tsege na sipi mane, me tsege na naniqoti; me tsege na dalena sipi e kesa moa na ngalitupaqira agana na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Me saisai na dangaqira na omea ara adimaia igira na sangavulu ruka na ida agana na tabuana na belatabu, me vaga iani: — ara sangavulu ruka na popo siliva me sangavulu ruka na bilo siliva, saisai me 28 kilo na mamavaqira; — me sangavulu ruka na pileti qolu, saisai me 1320 gram na mamavaqira, ara dangaligi- dangaliginigira nigira na bulunagai uruuru; — me sangavulu ruka na buluka mane, me sangavulu ruka na sipi mane, me sangavulu ruka na dalena sipi e kesa moa na ngalitupaqira, kolugira na sausau na uiti gana na savori-kodokodo; — me sangavulu ruka na naniqoti na mani savori matena na sasi; — me rukapatu vati na buluka mane, me ono sangavulu na sipi mane, me ono sangavulu na naniqoti, me ono sangavulu na dalena sipi e kesa moa na ngalitupaqira, agana na kodoputsa tangomana na tinoni kara ganipatâ na turina. ");
INSERT INTO gri_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mi kalina a Moses e sage bâ tana Valepolo Tabu na goko koluana na Taovia, maia e rongomia na Taovia e gokomai talu i gotuna na vovongona na Bokisi na Taso tana ka levugaqira ruka na angelo. ");
INSERT INTO gri_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ma na Taovia e goko vania a Moses me tsaria, ");
INSERT INTO gri_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ko tsarivania a Aaron laka kalina ti ke molokaetugira vitu na bilona bulu iruiru tana gai na molokae bulu iruiru, nina aqo ke mologira kara marara bâ i nago.” ");
INSERT INTO gri_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Maia Aaron e rongomangana na Taovia me molokaetugira na bilona bulu iruiru kara marara bâ i nagona na gai na molokae bulu iruiru. ");
INSERT INTO gri_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Me tû i gotu me tsautsuna i tuana na gai na molokae bilona bulu iruiru ara aqosiginia na qolumila ara tai tapetapea, taoninogoa na omea na Taovia e tusuvulagia vania a Moses. ");
INSERT INTO gri_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Igoe ko molovotagira na Levite tanigira na tinoni tavosi ni Israel, mo ko nauvanigira na aqona na suisui. ");
INSERT INTO gri_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Mo ko naua vaga iani: ko tsirikagini bâ i koniqira na kô na suisui, mo ko tsarivanigira kara tsarâ na kokoraqira popono, ma kara tsagigira na poloqira. Mi tana ti igira kara totu male i mataqu inau. ");
INSERT INTO gri_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Me ke sui, migira kara adimaia kesa na buluka mane vaolu, ma na sausau na uiti, aia nogo na pulaoa ara lalokolua na oela na olive vaga ara pedenogoa; migoe ko adimaigotoa kesa na buluka mane agana na sausau na sese. ");
INSERT INTO gri_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Mi tana, migoe ko soamaigira sui na saikolu popono ni Israel, mo ko tsarivanigira na Levite kara ba tû sui tana matsapana na Valepolo i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Migira na toga ni Israel kara moloa na limaqira tana lovaqira na Levite, ");
INSERT INTO gri_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","mi tana ti ke tû a Aaron me ke balogira na Levite tana aqo vaniaqu inau vaga kesa na vangalaka dou bâ e talu i laoqira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Mi muri migira na Levite kara moloa na limaqira i ka lovaqira kaira ruka na buluka mane; ke kesa gana na sausau na sese, me ke kesa agana na savori-kodokodo, kaira na sausau kaira gana na mani sese matena niqira sasi igira na Levite. ");
INSERT INTO gri_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Ko balogira na Levite vaga nogo kesa na vangalaka dou bâ vaniau, mo ko molovania a Aaron migira na dalena kara taovia vanigira. ");
INSERT INTO gri_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ko molovotagira vaganana igira na Levite tanigira na tinoni tavosi ni Israel, rongona kara gini lia niqu tamani segeni nogo inau. ");
INSERT INTO gri_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Mi murina kalina igoe ko nausuinogoa vanigira na Levite na aqona na suisui, mo balogira vaniau, mi tana ti ke ulagaqira na tangoliana na aqo i laona na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Inau nogo au viligira kara lia na tuguqira na daleqira mane botsaida igira na Israel, migira ara niqu tamani segeni nogo inau. ");
INSERT INTO gri_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Eo, kalina inau au labumatesigira sui pipi na daleqira mane botsaida igira na Ejipt, minau au balovaniau segeni pipi na baka mane botsaida i laoqira na tamadale popono tana Israel, migira goto na daleqira mane botsaida pipi sui na omea tuavati. ");
INSERT INTO gri_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mi kalina ia, minau au adigira na Levite ngiti tuguqira pipi sui na baka mane botsaida tana Israel, ");
INSERT INTO gri_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","mau molo vataraginigira na Levite tana tu limaqira a Aaron ma na dalena, agana kara gini aqo tana Valepolo Tabu na tuguqira na tinoni ni Israel, ma kara savoria na sausau matena niqira sasi, rongona ke tau gadovigira na toga ni Israel na rota seko loki ti vaga kara mai varangisia na Nauna Tabu.” ");
INSERT INTO gri_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Me vaga ia, ma Moses, ma Aaron, migira sui na toga ni Israel, ara balogira na Levite vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Migira na Levite ara tû mara lesomale mara tsagimalegira na poloqira, maia Aaron e balogira vania na Taovia vaga kesa na vangalaka dou bâ. Me nauvanigira goto na aqona na suisui kara gini totu male i matana na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Migira na toga ara naugira pipi sui na omea na Taovia e ketsaliginia a Moses tana rongoqira na Levite. Mi muri, migira na Levite ara sage bâ tana Valepolo Tabu mara naua niqira aqo i vavana a Aaron migira na dalena. ");
INSERT INTO gri_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Pipi na Levite e tsaulinogoa rukapatu tsege na ngalitupana, nina aqo ke aqo i laona na Valepolo i tana au totu inau, ");
INSERT INTO gri_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","mi kalina ke tsaulia na tsege sangavulunina ngalitupana, mi tana ke sui nina aqo. ");
INSERT INTO gri_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mi muri, ti vaga aia ke ngaoa, me ke sangagira rago na Levite tavosi na nauana niqira aqo i laona na Valepolo Tabu, me ke tau moa nau segenia kesa na aqo. Aia nogoria ko nauvaganana kalina ko vota aqo vanigira Levite.” ");
INSERT INTO gri_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ma na Taovia e goko vania a Moses tana Kaomate ni Sinai tana kesanina vula i laona na rukanina ngalitupa murina kalina igira na tinoni ni Israel ara mololea na Ejipt. Me tsaria, ");
INSERT INTO gri_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Tana sangavulu vatinina dani tana vula iani, ke tuturiga kalina ke sû tsotsodo na aso, migira na tinoni ni Israel kara lokisia na Dani Tabu na Paseka muritaonigira pipi sui na vovorona ma na ketsana.” ");
INSERT INTO gri_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Me vaga ia, maia Moses e tsarivanigira na toga kara lokisia na Dani na Paseka, ");
INSERT INTO gri_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","mi tana ngulavi na sangavulu vatinina dani tana kesanina vula, migira ara lokisia na Dani Tabu na Paseka, tana Kaomate ni Sinai. Migira na toga ara naugira na omea sui vaga nogo na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mara totu tana visana na mane ara gini kaulinaqu tana vovorona na lotu, rongona ara pelea na konina tinoni mate, me gini vali vanigira na sangâ na lokisiana na Dani Tabu na Paseka tana dani nogo ia. Migira ara ba laba i ka koniqira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","mara tsaria, “Igami ami totu kaulinaqu rongona ami pelea na konina tinoni mate. ?Me matena gua te e valivanigami igami na sauana nimami sausau vania na Taovia kolugira na tinoni tavosi tana Israel?” ");
INSERT INTO gri_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ma Moses e gokovisu vanigira me tsaria, “Kamu pitu poi ke tsau kalina inau kau rongomia sa goko ke talumai konina na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ke tsarivanigira na toga ni Israel, “Kalina ti vaga ke kesa i laomui igamu se i laoqira na kukuamui kara gini kaulinaqu tana peleana na konina na tinoni mate, se ke totu ao tana vinano, maia e padangaoa moa ke sanga na lokisiana na Dani Tabu na Paseka, ");
INSERT INTO gri_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","me dou moa ti kamu lokisia tana vula i muri, tana ngulavi na sangavulu vatinina dani i laona na rukanina vula. Ma kamu lokisiginia na bredi e tagara isti konina, ma na kusa vavai. ");
INSERT INTO gri_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ma kamu laka goto na molovisuana sa turina na mutsa ke totu tsau tana matsaraka na dani ngana, ma kamu laka goto na kutsiana na suliqira na omea tuavati. Ma kamu muritaonigira pipi sui na vovorona tana lokisiana na Dani Tabu na Paseka. ");
INSERT INTO gri_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Masei ti ke totu male moa tana vovorona na lotu, me tau goto vano ao tana vinano, maia ke tau moa mai sangâ na lokisiana na Dani Tabu na Paseka, na tinoni vaga ia e tau nogo tugua na soaginiana niqu tinoni inau, rongona e tau sanga mai na savoriana nina sausau vaniaqu inau tana tagu tititi laka. Nina aqo nomoa aia ke rota matena nina sasi. ");
INSERT INTO gri_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Me ti vaga kesa tinoni ni veratavosi aia e mauri i laomui igamu, me ke ngaoa ke sanga na lokisiana na Dani Tabu na Paseka, maia nina aqo ke muridougira sui na ketsana ma na valina. E kesa moa atsa na ketsa e kalegira na tinoni sui, atsa moa ti na bobotsana ni Israel se na tinoni ni veratavosi.” ");
INSERT INTO gri_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Mi tana dani ara vaturikaea na Valepolo i tana e totu na Taovia, me kesa na parako e tsunamai me tsavu poponoa. Mi tana bongi ma na parako ia e iru vaga na lake. ");
INSERT INTO gri_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mi kalina moa na parako ke datoligi, ti igira na toga ni Israel kara vutikaegira niqira valepolo, ma kara ba vaturikaegira tugua tana nauna i tana ke ba tsuna na parako ia. ");
INSERT INTO gri_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Migira na toga ara aligiri na vavano kalina moa ke ketsaligira na Taovia, mi tana nina ketsa goto aia ti igira kara vaturikae tugua niqira valepolo. Mi tana tagu popono e totu na parako ia i kelana na Valepolo Tabu, migira ara totu kalavata moa i tana. ");
INSERT INTO gri_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Mi kalina na parako e totu oka i kelana na Valepolo Tabu migira ara rongomangana moa na Taovia mara tau goto aligiri na vavano. ");
INSERT INTO gri_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Me visana kalina na parako ia e dona ke totu i kelana na Valepolo Tabu e ruka se tolu lelê moa na dani; me atsa moa ti ke oka koegua, migira ara totu dodo se ara vavano muria moa nina pede na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Me visana kalina na parako ia e dona ke totu moa tû tana ngulavi me ke tsau tana matsaraka dani ngana, mi kalina e datoligitugua na parako, migira ara aligiritugua na vavano. Eo, pipi kalina moa e dato na parako migira ara tû mara vano. ");
INSERT INTO gri_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Me atsa moa ti vaga ke ruka lelê moa na dani, se ke kesa na vula, se ke kesa na ngalitupa popono, se ke oka bâ, ke totu na parako ia i kelana na Valepolo Tabu, migira na tinoni ni Israel ara totu moa tana mara tau aligiri na vano; mi kalina moa e datoligi na parako ti ara vavano. ");
INSERT INTO gri_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Igira ara vaturikaegira niqira valepolo, mara aligiri na vavano taonia moa nina ketsa na Taovia aia e saua tana mangana a Moses. ");
INSERT INTO gri_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ko tai tapetapea ke visana na siliva mo ko aqosiginia ke ruka na tavuli, gana na mani soasaiaqira na toga ma na vangarau na aligiri ma na vavano. ");
INSERT INTO gri_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Mi kalina ti kara ka tangi tatavata kaira ruka sui na tavuli, maia nogo na papadana laka na toga popono kara saikolumai i konimu igoe i matana na Valepolo i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mi kalina ti vaga ke kesa lelê moa na tavuli ke tangi tatavata, ma na papadana laka igira moa na ida kara mai tupoligo igoe. ");
INSERT INTO gri_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Mi kalina ti vaga ke tangi kesakesa na tavuli, ma na papadana laka igira na puku ara totu tabana i longa kara ida na aligiri ma kara vano. ");
INSERT INTO gri_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Mi tana rukanina kalina ke tangi kesakesa migira na duli ara totu tabana i ata kara aligiri na vavano. Me vaga ia, ma kara uvia ke tangi kesakesa na tavuli kalina ke laba na tagu na mololeana kesa nauna ma na vano, ");
INSERT INTO gri_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","me ke tangi tatavata kalina moa kara soasaigira na toga popono. ");
INSERT INTO gri_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Migira segeni moa na dalena a Aaron na manetabu niqira aqo na uviana na tavuli. Ma na vovorona na ketsa iani niqira aqo kara muridatoa tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Mi kalina ti gamui gala kara mai na vailabu koluamui i laona nimui kao, migamu kamu uvi kaira sui na tavuli karani gana na vangarauana na vailabu, minau na Taovia nimui God, sauba kau sangagamu ma kau maurisigamu tanigira gamui gala. ");
INSERT INTO gri_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Me ke vaga goto pipi tana nimui dani tabu, kalina ke gado nimui Dani Tabu na Vula Vaolu, migira sui goto nimui dani tabu tavosi, igamu kamu uvi kaira sui na tavuli kalina kamu savorigira nimui savori-kodokodo, ma nimui kodoputsa tangomana na tinoni kara ganipatâ na turina. Mi tana ti inau sauba kau sangagamu, inau na Taovia nimui God.” ");
INSERT INTO gri_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Mi tana rukapatunina dani tana rukanina vula i laona na rukanina ngalitupa i murina kalina igira na Israel ara mololea na Ejipt, maia na parako e tsavua na Valepolo i tana e totu na Taovia e datoligi, ");
INSERT INTO gri_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","migira na toga ara tû mara mololea i Sinai. Mi kalina ara ba tsau tana kaomate ni Paran ma na parako e tsuna me totu tana. ");
INSERT INTO gri_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mi kalina ara aligiri na vavano, mara muritaonia na omea vaga na Taovia e ketsaliginia a Moses. ");
INSERT INTO gri_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ara ida na vano igira ara totu i vavana na pulaqena na puku konina a Juda tana niqira duli tatavosi babâ, ma Nason na dalena a Aminadab e tagaovigira. ");
INSERT INTO gri_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ma Netanel na dalena a Suar e tagaovigira na puku konina a Isakar, ");
INSERT INTO gri_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ma Eliab na dalena a Helon e tagaovigira na puku konina a Sebulun. ");
INSERT INTO gri_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Mi tana, mara aditsunâ na Valepolo Tabu, migira tana duli ka koniqira a Gerson ma Merari ara kalagaia mara tsarimuriqira tugira tolu na puku ara ida vano nogo. ");
INSERT INTO gri_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Mara tsari bâ igira ara totu i vavana na pulaqena na puku konina a Ruben, tana niqira duli tatavosi babâ, ma Elisur na dalena a Sedeur e tagaovigira. ");
INSERT INTO gri_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Maia Selumiel na dalena a Surisadai e tagaovigira na puku konina a Simeon, ");
INSERT INTO gri_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ma Eliasap na dalena a Deuel e tagaovigira na puku konina a Gad. ");
INSERT INTO gri_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Mi muri migira na Levite tana duli konina a Kohat ara kalagaigira na omea tabu mara aligiri na vavano. Mi kalina ara ba tsau tana rukanina nauna tana kara tototu, migira na Levite igira ara ida vano ara vaturikaenogoa na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Mara tsari bâ igira ara totu i vavana na pulaqena na puku konina a Epraim tana niqira duli tatavosi babâ, ma Elisama na dalena a Amihud e tagaovigira. ");
INSERT INTO gri_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Maia Gamaliel na dalena a Pedasur e tagaovigira na puku konina a Manase, ");
INSERT INTO gri_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ma Abidan na dalena a Gideoni e tagaovigira na puku konina a Benjamin. ");
INSERT INTO gri_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Mi muri tsotsodo, ara tsari bâ igira ara totu i vavana na pulaqena na puku konina a Dan, tana niqira duli tatavosi babâ, ma Ahieser na dalena a Amisadai e tagaovigira. ");
INSERT INTO gri_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Maia Pagiel na dalena a Okran e tagaovigira na puku konina a Aser, ");
INSERT INTO gri_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ma Ahira na dalena a Enan e tagaovigira na puku konina a Naptali. ");
INSERT INTO gri_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mi tana tagu sui moa ti vaga na tinoni ni Israel kara tû na mololeana kesa nauna ma na vano, ma niqira aqo kara vaitsarimurigi vaga nogo ia. ");
INSERT INTO gri_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Maia Moses e tsarivania na ivana, aia a Hobab na dalena a Jetro na mane ni Midian, “Igami ami vangaraua kami vano kalea tana nauna na Taovia e tsaria laka sauba ke saua vanigami. Maia e vekenogoa laka sauba kami totu dou i tana. Me vaga ia, me dou ti igoe ko dulikolugami, migami sauba kami pata kolugo na omea na Taovia sauba ke saua vanigami.” ");
INSERT INTO gri_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Maia Hobab e gokovisu me tsaria, “Tagara, inau niqu aqo kau visutugua tana niqu kao segeni koniqira niqu tinoni.” ");
INSERT INTO gri_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ma Moses e tsarivania, “Ko laka kiki na mololeamami. Igoe nogo o dona iava tana igami kami vaturikaegira nimami valepolo tana kaomate iani, me dou ti igoe ko idagana sautu vanigami. ");
INSERT INTO gri_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Me ti vaga igoe ko dulikolugami, migami sauba kami pata kolugo pipi sui na vangalaka na Taovia ke saua vanigami.” ");
INSERT INTO gri_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Mi kalina igira na toga ara mololea i Sinai, aia na vungavunga tabu, ara vavano i laona e tolu na dani popono. Migira ara kalagaia nina Bokisi na Taso na Taovia ara idagana sautu vanigira gana kara lavea na nauna i tana kara ba tototu. ");
INSERT INTO gri_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Me pipi dani kalina igira ara vavano i sautu, ma nina parako na Taovia e totu tana gaqira ngongo dato. ");
INSERT INTO gri_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Me pipi kalina kara tû na kalagaiana na Bokisi na Taso, ma Moses ke nonginongi vaga iani, “!Ko tû Taovia, mo ko sarangasigira gamu gala, ma kara viri tsogo bamai igira ara reisavigo!” ");
INSERT INTO gri_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Me pipi kalina kara mango ma kara molotsunâ na Bokisi na Taso, maia Moses ke tsaria, “Ko visumai Taovia, i koniqira nimu toga ni Israel.” ");
INSERT INTO gri_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Migira na toga ara tuturiga na goko korekore vaniana na Taovia tana rongona na rota loki e gadovigira. Mi kalina na Taovia e rongomigira, maia e kore vanigira me molomaia na lake me iruvi sekolia kesa tabana popono i murina tana nauna i tana ara tototu. ");
INSERT INTO gri_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Migira na toga ara ngangai vania a Moses ke sangagira; maia e nongia na Taovia, me gini mate na lake. ");
INSERT INTO gri_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mi tana nauna ia ara soaginia i Tabera rongona i tana nogo nina lake na Taovia e irudato i laoqira. ");
INSERT INTO gri_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mara visana goto na tinoni ni veratavosi ara dulikolugira na tinoni ni Israel. Me silovi sosongoligira na ngao gani sabo, migira goto na tinoni ni Israel ara gini goko korekore sosongo mara tsaria: “!Igita goto a ngaoa ka ganigira ke visana gada sabo! ");
INSERT INTO gri_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","I Ejipt igita a tau kuti na ganiana pipi na vatana tsetse igita a padangaoa, ma tau lelê goto tsonia sa qolo na matena. !Ka padatugua na kiukaba, ma na meleni, ma pipi vatana na parasa igita a ganigira. ");
INSERT INTO gri_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mi kalina ia ma na susuligada e puka sui nogo. Me tagara nogo sa gada mutsa ka gania, na mana lelê moa igita a totu matengana na ganiana na dani ma na dani!” ");
INSERT INTO gri_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ma na mana e vaga moa na piuna gai tetelo, me sere milamilaga. ");
INSERT INTO gri_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Maia e viri dudutsuna kolua na kolobu tana bongi tana nauna i tana ara tototu. Mi tana matsaraka migira na tinoni ara liu bamai na tsakoaqira, mara gotosigira, se ara lumu rapasigira kara gini lia vaga na pulaoa, mi muri mara kukia, mara buloa me madeve vaga na gola poqa. Me gani vaga moa na bredi ara lalokolua na oela na olive. ");
INSERT INTO gri_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ma Moses e rongomia niqira goko korekore na toga ara naua kalina ara totu tsuputsupu i matana niqira valepolo. Maia e gini padasavi sosongo rongona na Taovia e kore vanigira, ");
INSERT INTO gri_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","me tû me tsarivania na Taovia, “?Taovia laka egua ti o nausekoli vaniau sosongo vaga ia? ?Megua ti o reisaviau inau? ?Megua ti o molovaniau na aqo na reitutuguaqira na toga popono girani? ");
INSERT INTO gri_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","!Inau au tau volagira, se kau vasugira! ?Megua ti igoe o ngasuginiau kau kutigira ma kau tabelegira tana limaqu vaga na baka tetelo e tû i Ejipt me tsau bâ tana kao igoe o vekenogoa vanigira na mumuaqira? ");
INSERT INTO gri_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","?Me laka iava tana sauba inau kau tsodoa na sabo ke tugugira na toga vaga girani? Igira ara totu matengana moa na gini ngangai vaniau na sabo. ");
INSERT INTO gri_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","!Inau kesa lelê moa tinoni, mau tau tangomana na reitutuguaqira na toga vaga girani; e mamava vaniau sosongo na aqo ia! ");
INSERT INTO gri_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Me ti vaga igoe ko nauvaganana vaniau ia, me dou bâ ti ko galuveau mo ko matesiligiau moa, ma kau tau goto gini rota na vatsangiana nimu tobaseko vaniau.” ");
INSERT INTO gri_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ma na Taovia e tsarivania a Moses, “Ko soasaigira kara vitu sangavulu na mane nonoru igoe o dona laka ara tinoni loki i laoqira na toga, mo ko adimaigira vaniau i matana na Valepolo i tana au totu inau, mo ko tsarivanigira kara mai tû i ligisamu igoe. ");
INSERT INTO gri_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Minau kau tsunamai ma kau goko kolugo i tana, me sauba kau adia na turina na susuligana na Tarunga au saunogoa vanigo igoe, ma kau sauvanigira goto igira. Mi tana ti igira kara tangomana na sangaamu igoe na bariana na kalagai mamava na reitutuguaqira na tinoni girani, mo ko gini tau rota sosongo na kalagai segeniana. ");
INSERT INTO gri_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Mi kalina ia, migoe ko tsarivanigira na tinoni, ‘Kamu suisui segenimui gana ke matsaraka ke dani; me sauba kamu tamanina gamui sabo agana na kamatsi. Na Taovia e rongominogoa nimui ngangai, mamu tsaria laka e silovigamu sosongo na gani sabo, me laka amu dou bâ kalina amu totu i Ejipt. Eo, mi kalina ia me sauba na Taovia ke tusuvanigamu na sabo, ma nimui aqo nomoa kamu gania. ");
INSERT INTO gri_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Igamu sauba kamu ganigira, me tau laka ke kesa moa se ke ruka na dani, se ke tsege, se ke sangavulu, se atsa moa ke rukapatu na dani, ");
INSERT INTO gri_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","tagara, mi laona na vula popono kamu ganigira poi tsau kalina kamu masudoka ma kamu vatsa na ganiana. Sauba ke gini laba vaga ia rongona igamu amu sove tania na Taovia aia e totu ieni i laomui, mamu tsarivania laka ke dou bâ ti kamu tau mololea i Ejipt.’ ” ");
INSERT INTO gri_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ma Moses e tsarivania na Taovia, “Taovia inau au tagaovigira ara 600,000 na tinoni, migoe o tsaria laka sauba ko tusuvanigira gaqira sabo ke tugugira kesa na vula popono. ");
INSERT INTO gri_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","?Me atsa moa ti kami labugira sui nimami buluka ma nimami sipi, me laka kara gini masu sui na tinoni? ?Me laka pipi sui na tsetse i laona na tasi sauba ke tugugira?” ");
INSERT INTO gri_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ma na Taovia e gokovisu vania a Moses me tsaria, “?Egua laka o pada igoe laka e kurikuri na limaqu inau? !Sauba nomoa ko reia, e utu goto ke oka, ti vaga na omea au tsaria inau kara laba se tagara!” ");
INSERT INTO gri_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mi tana, ma Moses e rutsu i tano, me ba tsarivanigira na toga na omea vaga e tsaria na Taovia. Me soamaigira vitu sangavulu na ida, me mologira kara tu polipolia na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ma na Taovia e tsunamai i laona na parako me goko vania a Moses. Me adia na turina na susuligana na Tarunga aia e saunogoa vania a Moses, me sauvanigira goto igira na vitu sangavulu na ida. Mi kalina na Tarunga e totuvigira, migira ara tuturiga na gudato vaga nogo ara naua igira na propete, me tau moa oka sagata. ");
INSERT INTO gri_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mara ka ruka i laoqira na vitu sangavulu na ida kaira a Eldad ma Medad, ara ka totuvisu moa, mara ka tau ba sanga na tû koluana a Moses i matana na Valepolo Tabu. Me totuvikaira na Tarunga, mi kaira goto ara ka tuturiga na gudato i laona na nauna i tana ara tototu vaga ara naua igira na propete. ");
INSERT INTO gri_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Me kesa na borau e ulo tsaku me ba tatamanga vania a Moses ka rongoqira a Eldad ma Medad. ");
INSERT INTO gri_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Maia Josua na dalena a Nun, aia e sangâ a Moses tû kalina e borau, aia e goko dato me tsarivania a Moses, “!Taovia, ko tongovanikaira!” ");
INSERT INTO gri_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ma Moses e gokovisu vania a Josua me tsaria, “?Laka igoe o gini masugu tana rongoqu inau? !Minau au padangaoa ti vaga na Taovia ke saua nina Tarunga vanigira sui lakalaka nina tinoni, ma kara gudato sui vaga ara naua igira na propete!” ");
INSERT INTO gri_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mi tana ma Moses migira na vitu sangavulu na ida tana Israel ara tu visu bâ tana nauna i tana igira na tinoni ara tototu. ");
INSERT INTO gri_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ma na Taovia e tavongani moloa kesa na guguri loki me adimaigira na alaala popono na manu ara talumai i tasi, mara viri lovo liu mai lê i lao e kesa moa na mita tania na kao, mara mai pukatsuna polipoli tana nauna i tana ara tototu igira, ara tsupudato mara tsavua na kao popono na aona e tugua kesa na dani popono na vanovano tabana mi tabana na nauna i tana ara tototu. ");
INSERT INTO gri_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Me vaga ia, mi tana dani popono ia, mi tana bongi popono, mi tana dani ngana goto, migira na tinoni ara totu matengana moa na tangoliaqira na manu; me pipi tinoni e tsako liusia kesa toga na kilo na dangana. Mara parigira mara molo lenga tadasigira vania na aso polia na nauna i tana ara tototu, rongona na aso ke rangigira ma kara gini makede. ");
INSERT INTO gri_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mi kalina e totu danga moa gaqira sabo, ma na Taovia e kore sosongo vanigira na tinoni me moloa kesa na lobogu seko ke gadovigira. ");
INSERT INTO gri_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Mi tana nauna ia ara soaginia i Kibrot Hataava, ma na rongona na soa ia “Na Qiluqilu na Kili Kamatsi,” rongona i tana nogo ara qilugira na tinoni ara gini livusuguradi tana rongona na gani sabo. ");
INSERT INTO gri_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Me tû i tana, migira na tinoni ara aligiritugua mara ba tsau i Haserot, mi tana ara ba vaturikaegira tugua niqira valepolo. ");
INSERT INTO gri_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Me kesa dani, mi kaira ko Miriam ma Aaron ara ka taimatana a Moses rongona e taugâ na daki ni Midian. ");
INSERT INTO gri_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Mara ka tsaria, “?Egua, laka i konina moa a Moses aia na Taovia e dona ke moloa nina goko? ?Me laka e tau goto dona ke moloa nina goko vanikaita goto kaita?” Ma na Taovia e rongomia na omea vaga ara ka tsaria. ");
INSERT INTO gri_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ma Moses aia e kesa na mane tsalapo dou sosongo me molotsuna segenina, me tagara goto ke kesa tana barangengo popono ke atsalina aia. ");
INSERT INTO gri_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ara ka vasini goko sui moa, ma na Taovia e tsarivanitugira a Moses, ma Aaron, ma ko Miriam, “Inau au ngaoa tugamu sui kamu tu mai tana Valepolo i tana au totu inau.” Mi tugira ara tu mai, ");
INSERT INTO gri_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ma na Taovia e tsunamai tana parako i matana na Valepolo Tabu me soakaira, “!Kagamu a Aaron ma ko Miriam kamu ka mai!” Mi kaira ara ka mai varangi i konina, ");
INSERT INTO gri_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ma na Taovia e tsarivanikaira, “!Mi kalina ia, kamu ka rongomia na omea inau kau tsarivanikagamu! Kalina igira na propete ara totu i laomui igamu, minau au laba vanigira tana moro, mau goko vanigira tana bolebole. ");
INSERT INTO gri_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Minau au tau nauvaganana ia kalina au goko kolua a Moses niqu maneaqo; inau nogo au molovania ke tagaovigira niqu toga popono ni Israel. ");
INSERT INTO gri_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","!Me vaga ia, minau au goko kolua vaga moa kalina kesa tinoni e gogoko kolua kesa gana sai dou, mau goko maka dou kolua, tau tana gokolia; maia e reilakana na mararaqu! ?Megua vaga kagamu te amu ka tau matagu na taimatana a Moses niqu maneaqo?” ");
INSERT INTO gri_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ma na Taovia e kore vanikaira; mi kalina aia e mololekaira, ");
INSERT INTO gri_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ma na parako e datoligi tania na Valepolo Tabu, ma na kokorana popono ko Miriam e tavongani gani poponoa na mudo, me viri sere popono vaga na poke. Mi kalina a Aaron e morosia na mudo e gania na konina popono ko Miriam, ");
INSERT INTO gri_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","maia e tsarivania a Moses, “Kiki, gaqu taovia igoe, ko laka na moloana ke gadovikagami na rota loki vaga iani rongona ka nimami sasaga bubulega ami ka naua mami ka gini sasi. ");
INSERT INTO gri_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ko laka na tamivaniana ko Miriam ke vaga kesa na baka e mate i tobana tinana, mi kalina e botsa ma na kokorana e vanoligi sui nogo.” ");
INSERT INTO gri_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Maia Moses e ngangaidato vania na Taovia me tsaria, “!Kiki, Taovia, au nongigo ko maurisia ko Miriam!” ");
INSERT INTO gri_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ma na Taovia e gokovisu me tsaria, “?Ti vaga na tamana na daki iani ke tsuvelia na ngorana, me laka e tau nina aqo ke totu vangamâ i laona ke vitu na dani? Me vaga ia mo ko molovanoa ke totuligi tania na nauna i tana amu tototu i laona ke vitu na dani popono, mi muri ti aia tangomana ke visumaitugua i konimui.” ");
INSERT INTO gri_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Maia ko Miriam e totu i taba i laona e vitu na dani, migira na toga ara totuvisu moa i tana, poi kalina ara adisagetugua ko Miriam. ");
INSERT INTO gri_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Mi muri, migira ara mololea i Haserot, mara ba vaturikaegira niqira valepolo tana kaomate ni Paran. ");
INSERT INTO gri_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ko vilia tango kesa na ida i laoqira tugira na sangavulu ruka puku, mo ko molovanotugira kara tu ba togavia na kao popono i loana na Kanaan, na kao i tana inau sauba kau saua vanigira na tinoni ni Israel.” ");
INSERT INTO gri_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","15","Maia Moses e rongomangana na Taovia, me tû tana kaomate i Paran, aia e molovanotugira na ida tugirani: A Samua na dalena a Sakur tana puku konina a Ruben; a Sapat na dalena a Hori tana puku konina a Simeon; a Kaleb na dalena a Jepune tana puku konina a Juda; a Igal na dalena a Josep tana puku konina a Isakar; a Hosea na dalena a Nun tana puku konina a Epraim; a Palti na dalena a Rapu tana puku konina a Benjamin; a Gadiel na dalena a Sodi tana puku konina a Sebulun; a Gadi na dalena a Susi tana puku konina a Manase; a Amiel na dalena a Gemali tana puku konina a Dan; a Setur na dalena a Mikael tana puku konina a Aser; a Nabi na dalena a Vopsi tana puku konina a Naptali; ma Geuel na dalena a Maki tana puku konina a Gad. ");
INSERT INTO gri_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mi tugirani nogo na mane togatoga a Moses e molovanotugira kara tu togavia na laona na kao popono tana Kanaan. Me tû me olia na soana a Hosea na dalena a Nun me soaginia a Josua. ");
INSERT INTO gri_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mi kalina a Moses e molovanotugira, maia e tsarivanitugira vaga iani, “Kamu tu liu tave bâ tana Negev ma kamu tu bâ tsau tana kao vungavungaga tana Kanaan tabana i ata. ");
INSERT INTO gri_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ma kamu tu tsodovulagia laka na vatana na butona kao koegua aia, me visa na dangana na tinoni ara totu i tana, me laka ara susuliga koegua. ");
INSERT INTO gri_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ma kamu tu ba tsodovulagigotoa ti vaga na kao ia na kao dou se tau dou, me ti vaga igira na tinonina ara totu tana vera tagara baravatuna, se tana vera ara poliginia na vatu. ");
INSERT INTO gri_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ma kamu tu tsodovulagigotoa ti na kao lakataga se tagara, me laka ara danga na gai i tana se tagara. Ma kamu laka goto na padaleana na adivisumaiana ke visana na vuaqira na gai ara dato i tana.” Mi tana tagu ia na tagu ara tuturiga nogo mada na vuana uaeni. ");
INSERT INTO gri_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Me vaga ia, mi tugira na mane ara tu liu tave bâ tabana i vava mara togavia na kao popono tû tana kaomote ni Sin i ata, mara tsau bâ i Rehob ligisana na Matana Sautu ni Hamat tabana i vava. ");
INSERT INTO gri_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Mara tu vano talu tana Negev mara tu liu bâ talu i tabana i ata na kao mara tu bâ tsau i Hebron i tana ara totu na duli tu koniqira a Ahiman, ma Sesai ma Talmai, igira na kukuaqira na mamatana na mumû ara soaginigira na Anakim. Ara ida ara logoa na vera ni Hebron, me vitu na ngalitupa i muri ti igira na Ejipt ara logoa na vera ni Soan. ");
INSERT INTO gri_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Mara ba laba tana Poi ni Eskol, mi tana ara kutia kesa lelê moa na vunguna na uaeni, me mamava sosongo na vuana konina me tugua ruka na tinoni kara ka kalagaia tana gogola. Mara adivisumaigira goto visana na vuana gai mutsamutsa pui dou. ");
INSERT INTO gri_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Mi tana nauna ia ara soaginia na Poi ni Eskol rongona na vunguna na uaeni igira na tinoni ni Israel ara kavia i tana. ");
INSERT INTO gri_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Mi murina ara tu togavia na kao ia i laona e vati sangavulu na dani, mi tugira na mane togatoga ara tu visubatugua ");
INSERT INTO gri_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","i ka koniqira a Moses ma Aaron, migira sui na alaala popono na tinoni ni Israel ara totu moa i Kades tana kaomate ni Paran. Mara tu tatamangana na omea sui ara tu morosigira, mara tu sauvulagigotoa vanigira na vuana gai ara adimaia. ");
INSERT INTO gri_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mara tu tsarivania a Moses, “Tugami ami tu togavi polia na kao popono, mami tu tsodovulagia laka na kao dou tana me dato dou sosongo na mutsa ma na omea levolevo i konina; migirani visana na vuana ami tu adimaigira. ");
INSERT INTO gri_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Migira na tinoni ara totu i tana ara susuliga tango sosongo, ma niqira verabau ara loki mara barapoliginigira na vatu kakai. Ma na omea e gini seko sosongo goto bâ, igami ami reigira na kukuaqira na mumû ara totu i tana. ");
INSERT INTO gri_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Igira na Amalek ara totu tana butona tabana i ata na kao ia; migira na Het, ma na Jebus, ma na Amor ara totu tana kao vungavungaga; ma na Kanaan ara totu taonia na liligina Tasi Mediteranean ma na Kô Jordan.” ");
INSERT INTO gri_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Mi kalina igira na toga ara rongomi vaganana ia mara gini matagu mate, mara tsonia danga na goko vania a Moses. Maia Kaleb e kesa nogo na vidaqira na mane togatoga e tû me labua niqira goko me tsaria, “E tugu sosongolia igita ka baginigira kalina ia ma ka tangolia niqira kao; gada susuliga igita e tuguragoa ka tangoliginia.” ");
INSERT INTO gri_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mi tugira na mane ara dulikolua a Kaleb tana togatoga ara tsaria, “Tagara, igita a tau lelê susuliga na baginiaqira; igira na tinoni ni tana ara susuliga sosongo bâ liusigita.” ");
INSERT INTO gri_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Mi tugira ara tu rasavagini bamaia na turupatu peropero i laoqira na tinoni ni Israel tana rongona na kao i tana ara tu ba togavia. Mara tu tsarivaganana, “Na kao i tana e tau na kao dou. E tau lelê danga na mutsa i konina, me tau goto tugua kara gini mauri na tinoni ara totu i tana. Me pipi sui na tinoni ami tu reigira i tana ara katsi sosongo, ");
INSERT INTO gri_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","mami tu reigotoa na mumû igira na kukuaqira na Anak. Mi kalina ami reigira igira, mami padâ laka igami ami tetelo lê pitsu vaga moa ti na kipo, mami padâ laka igira goto ara reigami vaga goto moa ti na kipo.” ");
INSERT INTO gri_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mi tana bongi popono na tinoni sui ara ngangaidato tana padasavi loki. ");
INSERT INTO gri_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Mara goko korekore sosongo vanikaira a Moses ma Aaron mara tsaria, “!Ke dou sosongo bâ ti vaga kami mate nogo i Ejipt se ieni nogo tana kaomate! ");
INSERT INTO gri_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","?Rongona gua ti na Taovia e ngaoa ke adibagami tana kao ia? I tana sauba kara matesigami tana vailabu, ma kara laugira na taumami ma na dalemami. !Ke dou bâ vanigami ti kami visutugua moa i Ejipt!” ");
INSERT INTO gri_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Me vaga ia, migira ara vaigokovigi mara tsaria, “!Ida gita ma ka vilia kesa gada ida segeni ma ka visutugua i Ejipt!” ");
INSERT INTO gri_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mi tana mi kaira a Moses ma Aaron ara ka tsuporu tsuna tana kao i mataqira na toga sui. ");
INSERT INTO gri_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Mi kaira a Josua na dalena a Nun ma Kaleb na dalena a Jepune kaira nogo ruka na vidaqira na mane togatoga, ara ka ratsia ka poloqira tana melu, ");
INSERT INTO gri_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","mara ka tsarivanigira na toga, “Na kao ia ami tu ba togavia aia na kao dou mate sosongo. ");
INSERT INTO gri_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Me ti vaga na Taovia ke tobadou vanigita, me sauba nomoa aia ke adivanogita i tana, me ke sauvanigita na kao mauri me lakataga dou sosongo. ");
INSERT INTO gri_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ma kamu laka goto na sove taniana na Taovia, ma na mataguniaqira na tinoni ara totu i tana. Sauba ke tau lelê kakai vanigita na tuliusiaqira. Na Taovia e totu i konida, maia e pukalinogoa gaqira susuliga niqira god ara reitutugugira igira; me vaga ia, migamu kamu laka na matagu.” ");
INSERT INTO gri_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Migira na saikolu popono ara tau goto tutunina ka niqira goko a Josua ma Kaleb mara area laka kara tai matesiginikaira na vatu, mi tana mara tavongani morosia na mararana loki na Taovia e mararasi poponoa na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ma na Taovia e tsarivania a Moses, “?Sauba ke oka koegua sagata kara sove taniau igira na tinoni girani? ?Me ke oka koegua sagata goto kara sove na noruaqu, atsa moa ti ara reiginia na mataqira segeni na valatsatsa danga inau au naua i laoqira? ");
INSERT INTO gri_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Eo, sauba inau kau moloa ke liu kesa na lobogu seko i laoqira me ke matesiligigira. !Me sauba goto kau naua migoe ko lia na tamaqira na puku ke loki me ke susuliga bâ liusigira igira!” ");
INSERT INTO gri_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Maia Moses e tsarivania na Taovia, “Igoe nogo Taovia o adirutsumigira na tinoni girani tania i Ejipt tana susuligamu loki. Mi kalina igira na tinoni ni Ejipt kara rongomia na omea igoe o naua vanigira nimu tinoni, ");
INSERT INTO gri_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","me sauba igira kara gini turupatuna vanigira na tinoni ara totu tana kao iani. Ma na tinoni girani ara rongominogoa laka igoe Taovia o totu i konimami, me laka ami reilakamu nogo igoe, ma nimu parako e totu gamami ngongo dato igami, me laka igoe nogo o idagana sautu vanigami i laona na parako tana dani, mi tana ketsuma na lake iruiru tana bongi. ");
INSERT INTO gri_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Mi kalina ia, ti vaga igoe ko labumatesigira sui nimu tinoni, migira na puku tavosi sui ara rongominogoa gamu tangirongo igoe sauba kara tsaria ");
INSERT INTO gri_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","laka o labumatesigira lê nimu tinoni tana kaomate rongona e tau tugugo igoe na adiaqira tsau tana kao o vekenogoa laka ko saua vanigira. ");
INSERT INTO gri_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Bâ, mi kalina ia Taovia, au nongigo ko sauvulagia vanigami na susuligamu, mo ko naua na omea igoe o vekenogoa vanigami kalina igoe o tsaria, ");
INSERT INTO gri_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Inau na Taovia, au tau dona na kore tsaku, mau sauvulagia na galuve loki ma na tobalaka vanigira na tinoni, mau padalea niqira sasi ma niqira tobaseko vaniau. Me atsa moa au vaga, me utu kau tau kedegira na daleqira ma na kukuaqira tsau tana tolunina ma na vatinina na vatavata na vasusu dato, tana rongona nogo niqira sasi igira na tamaga ma na tinaga.’ ");
INSERT INTO gri_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Eo, mi kalina ia Taovia, tana nimu galuve loki e vo oli au nongigo ko padalea niqira sasi na tinoni girani, vaga nogo igoe o padale vanigira niqira sasi tû kalina igira ara mololea Ejipt.” ");
INSERT INTO gri_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ma na Taovia e gokovisu me tsaria, “E dou, minau sauba kau padale vanigira niqira sasi vaga nogo igoe o nongiau. ");
INSERT INTO gri_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Minau au gini vatsa nomoa tana soaqu segeni, me manana vaga nogo na mararaqu e dangali tovua na barangengo popono, ");
INSERT INTO gri_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","laka ke tagara goto sa vidaqira na tinoni ara mauri kalina eni ke sage tana kao ia. Igira ara reilakana nogo na mararaqu, migira na valatsatsa au naua i mataqira i Ejipt mi laona na kaomate, migira ara tau kuti na tovoleaqu babâ moa mara sove na rongomangaqu inau. ");
INSERT INTO gri_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Me utu saikesa kara sanga sage tana kao inau au vekenogoa vanigira na mumuaqira. Eo e tagara lelê goto sa vidaqira igira ara sove taniau tangomana ke sage bâ i tana. ");
INSERT INTO gri_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ma na rongona aia Kaleb niqu maneaqo dou e kesa segeni nina sasaga, me totukakai kalavata i koniqu inau, ti inau sauba kau adisagea tana kao aia e togavinogoa, migira na kukuana sauba kara aditamaniqira na kao popono ");
INSERT INTO gri_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","i tana igira na Amalek ma na Kanaan ara totuvia na poina kalina ia. Bâ, me ke matsaraka migamu kamu pilo ma kamu visu bâ i laona na kaomate tana sautu e aro kalea na Mangalonga ni Aqaba.” ");
INSERT INTO gri_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ma na Taovia e tsarivanikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“?Sauba ke oka koegua sagata kara goko korekore vaniau na tinoni vanga tsutsukibo girani? !Inau au qisi nogo na rongomiana niqira goko korekore dangadanga! ");
INSERT INTO gri_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Mi kalina ia, ko tsarivisu vanigira na goko vaga iani: ‘Inau au gini vatsa tana soaqu segeni vaga nogo inau au totu mamauri, laka sauba kau nauvanigamu vaga saikesa nogo na omea igamu amu nongia i koniqu. Inau nogo na Taovia au goko vaga. ");
INSERT INTO gri_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Igamu sauba kamu mate, ma na konimui sauba kara viri totu piriutsa bamai tana kaomate. Mi tana rongona nogo igamu amu totu matengana moa na goko korekore vaniaqu inau, ti sauba ke tagara lelê goto sa vidamui igamu e liusinogoa rukapatu na ngalitupana ke sage i laona na kao ia. ");
INSERT INTO gri_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Inau au veke vanigamu rago nogo laka sauba kamu ba totu tana kao ia, me sauba ke tagara lelê goto sa vidamaui igamu tangomana ke sage ba i tana, mi kaira lelê moa a Kaleb ma Josua. ");
INSERT INTO gri_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Igamu amu tsaria laka sauba kara laugira na dalemui, eo, minau sauba kau adibamaigira na dalemui i laona na kao igamu amu sove tania, mi tana nogo ke lia na veraqira. ");
INSERT INTO gri_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Migamu sauba kamu mate sui ieni i laona na kaomate. ");
INSERT INTO gri_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Migira na dalemui sauba kara liu bamai i laona na kaomate ke vati sangavulu na ngalitupa, na rota matena nimui tobaseko vaniau, poi tsau ke mate aia na susuina tana vatavata i konimui igamu. ");
INSERT INTO gri_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Eo, sauba kamu rota na sese matena nimui sasi i laona ke vati sangavulu na ngalitupa, ke kesa na ngalitupa popono na matena pipi kesa na dani i laona na vati sangavulu na dani i tana igamu amu togavi polia na kao ia. !Mi tana nogo ti sauba igamu kamu donaginia laka inau au reisavia nimui sasaga kaekae amu naua vaniau! ");
INSERT INTO gri_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Inau au gini vatsa laka sauba nomoa kau nauvanigamu na omea iani igamu na tinoni vanga tsutsukibo amu gini totu saisai na veitsari gaqu. Mieni nogo i laona na kaomate sauba pipi kesa vidamui igamu ke mate. Inau nogo na Taovia au tsarivaganana!” ");
INSERT INTO gri_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Mi tugira na mane a Moses e molovanotugira kara tu ba togavia na kao ia mara tu adivisumaia na turupatu peropero te e gini tsau e seko na tobaqira na tinoni mara gini goko korekore vania na Taovia, maia na Taovia e redotugira mara tu gini mate na lobogu seko. ");
INSERT INTO gri_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mi tu laoqira na sangavulu ruka mane togatoga, i kaira segeni moa a Josua ma Kaleb ara ka kauvisu. ");
INSERT INTO gri_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mi kalina a Moses e tsarivulagia vanigira na toga na goko e tsaria na Taovia, migira ara gini ngangai loki. ");
INSERT INTO gri_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mi tana matsaraka bongibongi na dani i muri migira ara vangaraua na vano na bokiana na kao vungavungaga mara tsarivania a Moses, “Igami ami reigadovinogoa laka igami ami sasi i matana na Taovia. Mi kalina ia ami vangaraunogoa na ba sage tana nauna na Taovia e tsarinogoa vanigami.” ");
INSERT INTO gri_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Maia Moses e tû me tsarivanigira, “?Me vaga ia, megua ti amu petsakoe mangana na Taovia kalina ia? !Sauba e utu saikesa kamu tangomana! ");
INSERT INTO gri_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Kamu laka moa na vano. Na Taovia e utu ke dulikolugamu, migira gamui gala sauba kara tuliusigamu. ");
INSERT INTO gri_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Me ti vaga kamu vano nomoa, mi kalina kamu baginigira na Amalek ma na Kanaan, me sauba kamu mate sui tana vailabu. Na Taovia sauba ke tau nogo totu kolugamu, rongona igamu amu sove na rongomangana.” ");
INSERT INTO gri_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Migira ara petsakoe moa, mara tû mara vano tana kao vungavungaga, atsa moa ti nina Bokisi na Taso na Taovia ma Moses goto ara ka totuvisu moa i tana. ");
INSERT INTO gri_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Migira na Amalek ma na Kanaan ara totu i tana ara maiginigira mara tuliusigira, mara takuvi tsarigira tsau bâ i Horma. ");
INSERT INTO gri_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Na Taovia e sauvania a Moses ");
INSERT INTO gri_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","na vovorona na ketsa vaga girani vanigira na toga ni Israel, “Kalina igamu kamu sage tana kao i tana sauba inau kau sauvanigamu, ");
INSERT INTO gri_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mamu padangaoa na kodoputsa vaniana na Taovia, ma nimui aqo kamu adia kesa na buluka mane, se kesa na sipi mane, se kesa na naniqoti, ma kamu aqosiginia na savori-kodokodo vania na Taovia, se na kodoputsa gana na manaliana kesa nimui veke, se kesa na sausau amu padangao segenia na savoriana, se na sausau amu lavu nogo na savoriana tana nimui dani tabu; ma na vuruna na sausau girani ke punâ na Taovia me ke gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Me ti vaga asei ke ngaoa na gini savori-kodokodo kesa nina sipi se nina naniqoti vania na Taovia, maia nina aqo ke adikolugotoa kesa na kilo na pulaoa lalo koluginia kesa na lita na oela na olive ngiti sausau na uiti, kolugotoa kesa na lita na uaeni. ");
INSERT INTO gri_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Me ti vaga kesa ke ngaoa na gini savori kesa nina sipi mane, ma nina aqo ke adikolugotoa ke ruka na kilo na pulaoa lalo koluginia kesa lita me kesa turina na oela na olive ngiti sausau na uiti, ");
INSERT INTO gri_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kolugotoa kesa lita me kesa turina na uaeni. Ma na vuruna na sausau girani ke punâ na Taovia me ke gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Mi ti vaga kesa ke ngaoa na gini savori-kodokodo vania na Taovia kesa nina buluka mane, se ke gini kodoputsa gana na manaliana kesa nina veke, se na kodoputsa tangomana na tinoni kara ganipatâ na turina, ");
INSERT INTO gri_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ma nina aqo ke adigotoa ke tolu kilo na pulaoa lalo koluginia ruka na lita na oela na olive, ");
INSERT INTO gri_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","kolugotoa ke ruka na lita na uaeni. Ma na vuruna na kodoputsa iani ke punâ na Taovia me ke gini laona sosongo. ");
INSERT INTO gri_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Ma na omea nogo vaga girani nimui aqo kamu savorigira kolua pipi kesa na buluka mane, se na sipi mane, se na dalena sipi se na naniqoti. ");
INSERT INTO gri_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Me ti vaga kamu savorigira ke ruka se ke tolu na omea tuavati, me nimui aqo kamu pabogotoa ke ruka se ke tolu na dangana pulaoa ma na oela na olive ma na uaeni. ");
INSERT INTO gri_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Nina aqo nogo pipi na bobotsana ni Israel ke nauvaganana ia kalina ti ke tû na savoriana nina sausau na mutsa, ma na vuruna na sausau ia e siginingaoa na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Me ti vaga kesa na tinoni ni veratavosi atsa moa ke totu tetelo moa kolugamu se ke mauri kalavata i laomui, ke ngaoa na savoriana kesa na sausau na mutsa vaga e siginingaoa na Taovia na vuruna, maia nina aqo ke muritaonia ke kesa moa atsa na vovorona. ");
INSERT INTO gri_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mi tana tagu sui ke mai, ke kesa moa atsa na ketsa e ngoligamu na muriana igamu migira goto na tinoni ni veratavosi ara mauri i laomui. Igamu migira, amu kesa moa na atsa i matana na Taovia; ");
INSERT INTO gri_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","me kesa moa atsa na ketsa ma na vali e kalegamu igamu me kalegira goto igira.” ");
INSERT INTO gri_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ma na Taovia e tsarigotoa vania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ko sauvanigira na tinoni ni Israel na vovorona na ketsa girani kara murigira tana kao i tana sauba kau sauvanigira. ");
INSERT INTO gri_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Kalina kamu tsurivigira na mutsa amu aqoa tana kao ia ma kamu ganigira, ma kamu mololigigira ke visana vaga nimui vangalaka dou bâ vania na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mi kalina kamu biti bredi, ma na kesanina sivona amu aqosiginia na uiti vaolu amu tau vati gotsâ moa, nimui aqo kamu savoria vania na Taovia. Ma kamu savori vaganana nogo kalina amu gini savoria na sausau na uiti amu gotsanogoa. ");
INSERT INTO gri_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mi tana tagu sui ke mai, iani e kesa na vangalaka dou bâ nimui aqo kamu savori vania na Taovia e talu tana nimui bredi amu bitia. ");
INSERT INTO gri_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“Me tau utu ti ke kesa tinoni ke tau pada mananâ i tobana na kutsiana visana na ketsa girani na Taovia e sauvania a Moses, mi tana tagu ke mai, e tau goto utu ti na saikolu popono kara tau muridougira sui na omea na Taovia e ketsaligira tana mangana a Moses. ");
INSERT INTO gri_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Me ti vaga na sasi ia e laba, migira na saikolu ara tau pada mananâ na nauana, ma niqira aqo kara gini savori-kodokodo kesa na buluka mane, na savori kodokodo vaga e siginingaoa na Taovia na vuruna, kolugotoa na sausau na uiti ma na uaeni, vaga e totu nogo tana vovorona na ketsa. Ma kara paboginigotoa kesa na naniqoti mane ngiti savori matena na sasi. ");
INSERT INTO gri_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Maia na manetabu ke naua na aqona na suisui mateqira na saikolu popono, minau na Taovia sauba kau padalea niqira sasi, rongona ara tau pada mananâ na nauana, mara adimaigira nogo niqira sausau matena na sasi ngiti sausau na mutsa vaniau na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Minau sauba kau padalea niqira sasi igira na saikolu popono ni Israel migira na tinoni ni veratavosi ara mauri i laoqira, rongona ara sanga sage sui moa i laona na sasi ia. ");
INSERT INTO gri_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Me ti vaga ke kesa moa tinoni maia e tsukia kesa na sasi e tau pada mananâ na nauana, ma nina aqo ke gini savoria kesa na naniqoti daki ke kesa moa na ngalitupana ngiti sausau matena nina sasi. ");
INSERT INTO gri_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Maia na manetabu ke naua na aqona na suisui tana belatabu na matena nina sasi na tinoni ia, minau sauba kau padalea nina sasi. ");
INSERT INTO gri_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Me kesa moa atsa na vovorona na ketsa e kalegira igira sui ara tsukia kesa na sasi mara tau pada mananâ na nauana, atsa moa ti na bobotsana ni Israel se na tinoni ni veratavosi ara totu i laoqira. ");
INSERT INTO gri_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Me ti vaga kesa tinoni maia e tami mananâ na tsukiana kesa na sasi, me atsa moa ti aia na bobotsana ni Israel se na tinoni ni veratavosi, maia e gini sasi manana nogo ma nimui aqo kamu labumatesia, ");
INSERT INTO gri_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","rongona e peâ na mangana na Taovia me tami tana tobana popono na kutsiana nina ketsa. Aia e tsuki segenia gana matemate.” ");
INSERT INTO gri_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Me kesa dani, kalina igira na tinoni ni Israel ara totu moa tana kaomate, mara tsodoa kesa na mane e tsako lake tana Dani na Sabat. ");
INSERT INTO gri_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Mara adi bâ vanikaira a Moses ma Aaron migira na saikolu popono, ");
INSERT INTO gri_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","mara moloa kesa na mane ke matalia, rongona ara tau vati dona maka dou nagua kara nauvania. ");
INSERT INTO gri_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ma na Taovia e tsarivania a Moses, “Na mane iani nimui aqo kamu matesia; migira na saikolu popono kara taimatesiginia na vatu i tabana i tano tania na nauna i tana amu tototu.” ");
INSERT INTO gri_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Me vaga ia, ma na saikolu popono ara adivanoa na mane ia i tabana i tano tania na nauna i tana ara tototu, mara taimatesia vaga nogo na Taovia e ketsaliginigira. ");
INSERT INTO gri_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ma na Taovia e raiginia a Moses ");
INSERT INTO gri_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","ke tsarivanigira na tinoni ni Israel na goko vaga iani: “Kamu adigira ke visana takutina terete ma kamu vosi moliloa ma kamu tsauragini bâ tana vati tsukena na polomui ma kamu sori bâ kesa na itai bora pipi tana omea momolilo. Igamu nimui aqo kamu naua babâ na omea vaga iani tana tagu sui ke mai. ");
INSERT INTO gri_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Migira na omea momolilo girani kara ngiti papadana vanigamu, me pipi kalina igamu kamu reigira me sauba kamu padatugugira pipi sui niqu ketsa ma kamu muridougira; mi tana migamu sauba kamu tau goto piloligi taniau ma kamu muria moa na tobamui segeni. ");
INSERT INTO gri_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Igira na omea momolilo vaga girani sauba kara molo papada vanigamu gana kamu muridougira pipi sui niqu ketsa, migamu sauba kamu lia saikesa nogo niqu tinoni inau. ");
INSERT INTO gri_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Inau nogo na Taovia nimui God. Inau au adirutsumigamu tania na Ejipt rongona kau lia nimui God. Inau nogo na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Maia Kora na dalena a Isar, aia e kesa na Levite tana duli konina a Kohat, kolutugira a Datan ma Abiram kaira na dalena a Eliab, ma On na dalena a Pelet, me kolugira goto ara 250 na mane tavosi, igira na saikolu popono ara viligira kara lia gaqira ida, ");
INSERT INTO gri_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ara mai laba ka koniqira a Moses ma Aaron mara tsarivanikaira, “!Kagamu amu ka vano ao sosongo nogo tana omea amu ka naua! Migira sui na tinoni popono i laona nida saikolu, igira sui lakalaka ara nina nogo na Taovia, ma na Taovia nogo e totu i konida igita sui. ?Megua vaga ti kagamu amu ka molokae segenimui liusigami sui i laona nina saikolu na Taovia?” ");
INSERT INTO gri_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mi kalina a Moses e rongomi vaganana ia, maia tsuporu tsuna tana kao me nonginongi. ");
INSERT INTO gri_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Me pidikae tugua, me tsarivania a Kora migira ara tsarimurina, “Ke matsaraka ke dani na Taovia sauba ke sauvulagia vanigita laka asei gira aia e tamanigira; maia nogo sauba ke tamivania aia kesa e vilinogoa ke mai tu varangisia aia tana belatabu. ");
INSERT INTO gri_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Mi tana matsaraka ke dani migoe migira gamu dulikolu kamu adimaigira nimui bilo tapala na mani kodoana na bulunagai uruuru i laona, ma kamu molotsavua na madaova gagâ ma na bulunagai uruuru i kelaqira, ma kamu adibagira tana belatabu. Mi tana ti sauba ka reigadoviginia laka asei nomoa i laoda igita na Taovia e vilia. !Migamu saikesa nogo na Levite amu vano ao sosongo nogo tana omea amu naua!” ");
INSERT INTO gri_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Maia Moses e goko babâ moa vania a Kora me tsaria, “!Kamu rorongo dou igamu na Levite! ");
INSERT INTO gri_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","?Amu pada ngatsua igamu laka na omea lê e nauvanigamu na Taovia kalina aia e vililigigamu tanigira na tinoni tavosi tana Israel, me tamivanigamu nogo kamu ba varangisia aia, ma kamu naua nimui aqo tana nina Valepolo na Taovia, ma kamu tû i mataqira na toga ma kamu aqo na tuguqira? ");
INSERT INTO gri_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Maia e tamivanigo nogo igoe a Kora, me vanigira na Levite tavosi, kamu tangolia na aqo loki iani, eo, mi kalina ia migoe o ngaogotoa ko lia na manetabu! ");
INSERT INTO gri_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Mi kalina igoe o goko korekore vania a Aaron, mi tana migoe migira gamu duli amu sove tanigotoa na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mi muri ma Moses e vailivukaira a Datan ma Abiram, mi kaira ara ka tsaria, “!Sauba e utu kami ka ba i konimu! ");
INSERT INTO gri_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Igoe nogo o adirutsumigami tania na kao dou ni Ejipt rongona ko gini matesigami ieni tana kaomate. ?Me laka igoe o ngaogotoa ko taovia kaputigami igami? ");
INSERT INTO gri_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Igoe o tau saikesa adigami bâ i laona kesa na kao dou, se ko tusuvanigami ke kesa gamami uta na mutsa se na uta na uaeni kami gini tamanina, mi kalina ia igoe o tovogotoa laka ko pero bulesigami. !Mi kagami e utu saikesa kami ka ba reigo!” ");
INSERT INTO gri_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Maia Moses e kore me tsarivania na Taovia, “Ko laka na tabeana sa niqira sausau kara adi bâ vanigo na mane girani. Inau au tau lelê tsukia sa sasi ke kalea sa vidaqira; mau tau goto vati komia sa nina asi sa vidaqira.” ");
INSERT INTO gri_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Maia Moses e pilo bâ i konina a Kora me tsarivania, “Ke dani nogo igoe migira na 250 gamu duli nimui aqo kamu mai laba i matana na Valepolo i tana e totu na Taovia; ma Aaron goto sauba ke totu i tana. ");
INSERT INTO gri_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Me pipi kesa vidamui igamu nina aqo ke tatango mai nina bilo tapala na madaova gagâ i laona, me ke molotsavua na bulunagai uruuru i konina, me ke ba saua tana belatabu.” ");
INSERT INTO gri_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Me vaga ia migira sui lakalaka na mane ara tatango mai niqira bilo tapala, mara molotsavua na madaova gagâ ma na bulunagai uruuru i koniqira, mara mai tutû i matana na Valepolo Tabu kolukaira a Moses ma Aaron. ");
INSERT INTO gri_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mi muri, maia Kora e ba soasaigira na saikolu popono, mara mai tutû aro bâ ka koniqira a Moses ma Aaron i matana na Valepolo Tabu. Me tavongani laba na mararana loki na Taovia i mataqira na saikolu popono, ");
INSERT INTO gri_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ma na Taovia e tsarivanikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Kamu ka tu tabaligi tanigira na tinoni girani, minau sauba kau matesiligigira sui kalina tsotsodo nogo ia.” ");
INSERT INTO gri_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mi kaira a Moses ma Aaron ara ka tsuporu tsuna tana kao mara ka tsaria, “God, kiki, igoe nogo na uluqira pipi sui lakalaka na mauri. ?Mi kalina ti ke kesa lelê moa na tinoni ke tsukia na sasi, me laka e dou igoe ko kore vanigira na toga sui popono?” ");
INSERT INTO gri_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ko tsarivanigira na tinoni kara ratsuligi tania tu niqira valepolo tugira a Kora, ma Datan, ma Abiram.” ");
INSERT INTO gri_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mi muri ma Moses, kolugira sui na ida tana Israel, ara tû mara ala bâ ka koniqira a Datan ma Abiram. ");
INSERT INTO gri_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ma Moses e tsarivanigira na toga, “Kamu totu tabaligi tania tu niqira valepolo na tinoni vanga tsutsukibo tu girani, ma kamu laka goto na peleana kesa niqira omea tatamani. Rongona ti vaga kamu nauvaganana ia, me sauba kamu luvu takuti kolugira tana rongona niqira sasi igira.” ");
INSERT INTO gri_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Me vaga ia migira sui ara gatsuligi mara tû tabaligi tania tu niqira valepolo tugira a Kora, ma Datan, ma Abiram. Mi kaira a Datan ma Abiram ara ka rutsumai mara tutû i matana ka niqira valepolo, kolugira ka tauqira ma ka daleqira. ");
INSERT INTO gri_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Maia Moses e tsarivanigira na toga, “Mi kalina nogo ia sauba kamu reia kesa na omea ke laba, mi tana ti kamu gini donaginia laka aia nogo na Taovia e ketsaliau kau naugira na omea sui girani, mau tau naugira tana niqu papada segeni. ");
INSERT INTO gri_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Me ti vaga na tinoni girani kara mate vaga nogo na tinoni sui, me ke tau tana rongona laka God e kedegira, mi tana ti sauba kamu donaginia laka na Taovia e tau mologiniau inau. ");
INSERT INTO gri_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Me ti vaga na Taovia ke nauvanigira kesa na omea igamu amu tau vati morosia moa tana maurimui popono, me ke naua me ke tavongani bilolo na kao, me ke konomi poponogira kolugira pipi niqira omea levolevo ara tamanina, ma kara tsuna mamauri tana barangengo na mate, mi tana ti kamu donaginia laka na tinoni girani ara sove manana tania na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mi kalina tsotsodo a Moses e goko sui vaga ia, ma na kao i tana ara ka tutû a Datan ma Abiram e tavongani tangiti me bilolo, ");
INSERT INTO gri_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","me konomikaira sui kolu ka tauqira ma ka daleqira, kolugira sui goto na vungu konina a Kora ma niqira omea levolevo. ");
INSERT INTO gri_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mi tana migira sui ara viri tsuna mamauri tana barangengo na mate kolu niqira omea tatamani sui. Ma na kao e munu kaputigira mara nanga lê takuti. ");
INSERT INTO gri_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mi kalina igira na tinoni ni Israel ara totu varangi tana ara rongomigira ara viri gû mara kanga, migira ara tsaria, “!Ida tsaku ma ka tsogo! !Ke tau munugita sui goto na kao!” ");
INSERT INTO gri_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Mi muri ma na Taovia e molomaia na lake iruiru me ganigira sui na 250 mane igira ara savoria na bulunagai uruuru. ");
INSERT INTO gri_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Mi muri ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Igoe ko tsarivania a Eleasar na dalena a Aaron na manetabu ke ba adiligigira na bilo tapalamila tanigira na mane e gani matesigira nogo na lake, mo ko sarangasigira bâ sa tabana segeni na madaova gagâ ara totu i laoqira, rongona na bilo gira ara tabu. ");
INSERT INTO gri_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ara gini lia na omea tabu kalina ara saugira vania na Taovia tana belatabu. Me vaga ia, ma kamu adigira niqira bilo tapala na mane ara mate nogo tana rongona niqira sasi, ma kamu tai madevegira, ma kamu aqosiginia na tsatsavuna na belatabu. Ma na omea iani ke lia mala parovata vanigira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ma Eleasar e ba adigira na bilo tapala me tai madevegira, me aqosiginia na tsatsavuna na belatabu. ");
INSERT INTO gri_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Maia nogo e lia mala parovata vanigira na tinoni ni Israel rongona ke laka goto ke kesa ti aia e tau na kukuana a Aaron, na mai tana belatabu ma na kodoana na bulunagai uruuru i matana na Taovia. Me ti vaga kesa ke petsakoe me ke nauvaganana ia, me sauba ke mate vaga goto a Kora migira gana sasanga. Ma Eleasar e naua na omea sui vaga gira vaga nogo na Taovia e ketsaliginia tana mangana a Moses. ");
INSERT INTO gri_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mi tana dani ngana mara tû igira na saikolu popono mara tai ka mataqira a Moses ma Aaron mara tsaria, “Kagamu nogo amu ka matesigira danga nina tinoni na Taovia.” ");
INSERT INTO gri_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Mi kalina ara goko korekore sui vaga ia vanikaira a Moses ma Aaron, mara pilovisu tana Valepolo Tabu mara rei bâ na parako e tsavu poponoa, ma na mararana loki na Taovia e laba tana. ");
INSERT INTO gri_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mi kaira a Moses ma Aaron ara ka ba tû i matana na Valepolo ia, ");
INSERT INTO gri_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","me goko na Taovia me tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“!Kamu ka ba tû tabaligi tanigira na toga girani, minau kau matesiligigira sui lakalaka nogo kalina ia!” Mi kaira ara ka tsuporu tsuna me pelea na kao ka ngoraqira, ");
INSERT INTO gri_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","maia Moses e tsarivania a Aaron, “Ko adia nimu bilo tapala mo ko vanitsavua i laona na madaova gagâ o adia tana belatabu, mo ko moloa na bulunagai uruuru i kelana na madaova gagâ. Mo ko ulo ba tsaku i laoqira na toga mo ko ba naua na aqona na suisui mateqira. !Ko tsaku! E labadato nogo na korena na Taovia, me tuturiga nogo na liu na lobogu seko.” ");
INSERT INTO gri_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ma Aaron e rongomangana a Moses, me tû me adia nina bilo tapala me ulo ba tsaku i laoqira na toga ara saikolu i tana. Mi kalina aia e reia laka e tuturiga nogo na laba i koniqira na lobogu seko ia, maia e molotsavua na bulunagai uruuru tana madaova gagâ, me naua na aqona na suilovaqira na toga. ");
INSERT INTO gri_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Mi tana me gini totu puka na liuna na lobogu seko loki ia, maia Aaron e tutû i levugaqira na maurina ma na matena. ");
INSERT INTO gri_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ma na dangaqira na tinoni ara mate tana ara 14,700, mara tau tsokosai kolugira igira ara mate tana rongona nina petsakoe a Kora. ");
INSERT INTO gri_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Mi kalina e totupuka nogo na liuna na lobogu seko loki ia, ma Aaron e visutugua i konina a Moses i matana na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ko tsarivanigira na toga ni Israel kara sauvanigo ke sangavulu ruka na itoro, ke kesa ke talu babâ i koniqira pipi na ida i laoqira na sangavulu ruka na puku. Migoe ko marea na asana pipi na ida tana nina itoro segeni nogo. ");
INSERT INTO gri_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Mi muri mo ko marea na asana a Aaron tana niqira itoro igira na puku konina a Levi. ");
INSERT INTO gri_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Mo ko adimaigira i laona na Valepolo i tana au totu inau, mo ko mologira i matana na Bokisi na Taso, i tana nogo inau au lavu na goko koluamu igoe. ");
INSERT INTO gri_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mi tana ma nina itoro aia na mane inau au vilinogoa sauba ke kutsu me ke araga. Mi tana nauvaganana nogo ia ti inau sauba kau vongo kapusiginia niqira goko korekore ara naua vanigo sailagi na tinoni ni Israel girani.” ");
INSERT INTO gri_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Me vaga ia, ma Moses e goko vanigira na tinoni ni Israel, me pipi gaqira ida ara adimai vania gaqira itoro, kesa itoro kesa puku, ara saisai mara sangavulu ruka, ma gana itoro goto a Aaron i laoqira. ");
INSERT INTO gri_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Me tû a Moses me adigira sui lakalaka na itoro, me ba mologira i laona na Valepolo Tabu i matana nina Bokisi na Taso na Taovia. ");
INSERT INTO gri_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mi tana dani i muri, ma Moses e ba sagetugua i laona na Valepolo Tabu me reia gana itoro a Aaron, aia niqira itoro na puku konina a Levi, e kutsu me araga, me latse me tupa na vuana gatsoga i konina. ");
INSERT INTO gri_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Maia Moses e tsakosaigira na itoro sui me tusuvulagigira vanigira na toga ni Israel. Migira ara morosia na omea vaga e laba, me pipi na ida e adivisu segenia gana itoro. ");
INSERT INTO gri_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ma na Taovia e tsarivania a Moses, “Ko molovisua gana itoro a Aaron i matana na Bokisi na Taso. Me ke totu sailagi i tana ngiti parovata vanigira na tinoni vanga petsakoe ni Israel, laka sauba nomoa kara mate ti vaga kara tau mololea niqira goko korekore.” ");
INSERT INTO gri_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ma Moses e naua na omea vaga nogo na Taovia e ketsaliginia ke naua. ");
INSERT INTO gri_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Migira na toga ni Israel ara tsarivania a Moses, “!Alao, sauba nomoa kami mate sui igami! !Sauba nomoa kami nanga lê sui! ");
INSERT INTO gri_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Igoe o tsaria laka asei moa ti ke liu varangisia na Valepolo Tabu sauba ke mate. ?Me vaga ia, me laka igami sui sauba kami mate?” ");
INSERT INTO gri_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ma na Taovia e tsarivania a Aaron, “Ti vaga igoe, ma na dalemu, migira na Levite kamu nau sasilia kesa na aqona i laona niqu Valepolo Tabu, me sauba ke gadovigamu sui na kedena. Me ti vaga tugamu segeni moa na dalemu, kamu tu nausasilia kesa na omea tana aqo manetabu, mi tugamu segeni moa sauba ke gadovitugamu na kedena. ");
INSERT INTO gri_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ko adimaigira na kamamu, igira tana puku konina a Levi, kara aqo kolugo ma kara sangago kalina igoe migira na dalemu amu tu naua tu nimui aqo i laona na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Igira kara naua na aqo igoe ko pedevanigira, ma kara sanga na aqo i laona na Valepolo Tabu, ma kara tau moa tavongani pelegira na omea tabu i laona na Nauna Tabu se tana belatabu. Me ti vaga kara nauvaganana ia, migamu sui kolu, igoe migira, sauba kamu mate sui. ");
INSERT INTO gri_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Igira nogo na Levite kara aqo kolugo ma kara naua niqira aqo i laona na Valepolo Tabu, me ke laka goto sa tinoni tavosi ke sanga aqo kolugo i tana. ");
INSERT INTO gri_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Igoe segeni moa migira na dalemu, kamu tu naugira na aqo sui i laona na Nauna Tabu mi tana belatabu, rongona ke tau botsadato tugua na korequ vanigira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Inau nogoria au viligira na Levite igira na kamamu igoe, i laoqira na toga ni Israel, mau tusugira vanigo vaga nogo kesa na vangalaka vanigo. Au balogira vaniau inau rongona ke gini ulagaqira na nauana niqira aqo i laona niqu Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mi tugamu segeni moa na dalemu, tu nimui aqo kamu tu naua pipi sui na aqo manetabu tana belatabu mi laona na Nauna Tabu Loki Sosongo. Inau au sauvanitugamu na aqo manetabu vaga kesa na vangalaka loki vanitugamu. Me ti vaga sa tinoni tavosi ke mai varangisigira na omea tabu gira, migamu kamu labumatesia.” ");
INSERT INTO gri_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ma na Taovia e tsarigotoa vania a Aaron, “Mi kalina ia inau au tusuvanigo nogo pipi sui na vangalaka kara sauvaniau igira na tinoni mara tau gana na mani kodoputsa. Au saugira sui vanigo migira na kukuamu vaga gamui tuva sailagi na dani ma na dani. ");
INSERT INTO gri_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mi laoqira na sausau tabu loki ara tau kodogira tana belatabu, igirani nogo na tamanimui igamu: igira vaga na sausau na uiti, ma na sausau matena na sasi, ma na sausau na volivisu. Migira na omea sui lakalaka kara saua vaniau vaga kesa na savori tabu loki kara lia sui na tamanimui tugamu, igoe ma na dalemu mane. ");
INSERT INTO gri_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ma nimui aqo kamu ganigira na omea girani i laona kesa na nauna tabu, migira segeni moa na mane kara ganigira; rongona na omea girani na omea tabu. ");
INSERT INTO gri_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Ma na kamagana na omea girani, igira sui na vangalaka tavosi ara sauvaniau igira na tinoni ni Israel kara lia goto na tamanimu igoe. Inau au saugira vanigo, me vanigira na dalemu mane ma na dalemu daki, kamu tamanina tana tagu sui ke mai. Migira sui tana nimu tamadale tangomana kara ganigira ti vaga ara totu male taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Inau au sauvanigamu na turina dou bâ na vuana idaida na omea tsukatsuka ara tsurivia igira na tinoni ni Israel mara sauvaniau pipi ngalitupa: niqira oela na olive, ma na uaeni, ma na uiti. ");
INSERT INTO gri_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Na omea sui girani na tamanimu nogo igoe. Migira sui tana nimu tamadale tangomana kara ganigira ti vaga kara totu male taonia na vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Me pipi sui na omea kara balo saikesalia vaniau igira na tinoni ni Israel, kara lia sui na tamanimu igoe. ");
INSERT INTO gri_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Migira sui na baka botsaida, se na omea tuavati botsaida igira na Israel kara saugira vaniau inau, kara lia sui na tamanimu igoe. Ma nimu aqo nomoa ko tamivanigira na tinoni ni Israel kara volivisugira na daleqira mane botsaida, migira goto na daleqira botsaida pipi na omea tuavati ara tau masidi tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Migira na baka botsaida kara volivisugira kalina kara tsaulia kesa moa na vulaqira, ma na matena ara moloa e tsege moa na tavina siliva muri taoninogoa na matena na omea ara pedea tana tagu ia. ");
INSERT INTO gri_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Migira moa na daleqira botsaida na buluka, ma na sipi, ma na naniqoti, ara tau gana na mani volivisuaqira. Ara niqu tamani saikesa nogo inau, gana kamu gini kodoputsa vaniau. Kamu qetu bâ na gabuqira tana belatabu, ma kamu kodoa na seregaqira vaga kesa na sausau na mutsa, ma na vuruna na sausau ia e sigini dou sosongo vaniau inau. ");
INSERT INTO gri_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ma na lakaqira gamui nogo igamu, vaga goto na arona ma na arana madoa ni muri tana omea tuavati ara savoria vaga kesa na vangalaka dou bâ vaniau. ");
INSERT INTO gri_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Inau au sauvanigo, me vanigira na dalemu mane ma na dalemu daki, tana tagu sui ke mai, pipi sui na vangana na vangalaka dou bâ ara sauvaniau igira na tinoni ni Israel. Inau au naua na vaitasogi iani kolugo igoe me kolugira na kukuamu, me utu goto ke taveo kesa dani.” ");
INSERT INTO gri_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ma na Taovia e tsarigotoa vania a Aaron, “Migoe sauba ko tau tangolidatoa sa turina na kao i laona na Israel. Rongona inau nogo na Taovia sauba kau tusuvanigo na omea sui o kilia gana na mauri.” ");
INSERT INTO gri_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ma na Taovia e tsarigotoa, “Inau au saunogoa vanigira na Levite pipi na sangavulunina turina na omea kara sauvaniau igira na tinoni ni Israel. Miani nogo ngiti vovolina niqira aqo na reitutuguana na Valepolo i tana au totu inau. ");
INSERT INTO gri_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Me tû kalina ia, me vali vanigira na tinoni tavosi tana Israel na liu varangisiana na Valepolo Tabu, rongona kara tau alomai segenia gaqira matemate. ");
INSERT INTO gri_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Me tû kalina ia me ke bâ niqira aqo segeni moa na Levite na reitutuguana na Valepolo Tabu ma na tangoliana na aqo popono i laona. Ma na ketsa iani ke totu kalavata vanigira goto na kukuaqira i muri. Migira na Levite sauba kara tau tamanina sa niqira kao pukuga i laona na Israel, ");
INSERT INTO gri_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","matena inau au sauvanigira ngiti gaqira tuva pipi na sangavulunina turina niqira omea ara sauvaniau igira na tinoni ni Israel. Aia nogoria na rongona ti inau au gini tsarivanigira laka sauba ke utu vanigira kara tamanina kesa niqira kao pukuga i laona na Israel.” ");
INSERT INTO gri_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ma na Taovia e ketsalia a Moses ");
INSERT INTO gri_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","ke tsarivaganana vanigira na Levite: “Kalina ti vaga kamu adia i koniqira na tinoni ni Israel na sangavulunina turina na omea igira ara tusuvania na Taovia maia e sauvanigamu, ma nimui aqo igamu kamu sauvisua vania vaga kesa na vangalaka dou bâ na sangavulunina turina pipi sui na omea na tinoni ara saua vanigamu. ");
INSERT INTO gri_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ma na vangalaka dou bâ vaga ia sauba na Taovia ke tabea vaga moa kalina aia e tabea niqira sausau na uiti ma na uaeni vaolu igira na tinoni ara sauvania. ");
INSERT INTO gri_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mi tana nauvaganana ia, migamu goto sauba kamu saugira nimui vangalaka dou bâ vania na Taovia ara talumai pipi tana sangavulunina turina amu adia i koniqira na tinoni ni Israel. Ma na vangalaka dou bâ iani amu sauvania na Taovia, kamu sauvania a Aaron na manetabu. ");
INSERT INTO gri_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kamu saua na turina dou bâ i laoqira na omea igamu amu adia i koniqira na tinoni. ");
INSERT INTO gri_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Mi kalina kamu gini sausau na turina dou bâ, ma kamu aditamanimui na tsarana, vaga saikesa nogo e naua na mane tamanina na uta, aia e adi nina na tsarana murina kalina aia e gini savori na turina dou bâ. ");
INSERT INTO gri_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Migamu migira nimui tamadale kamu ganigira rago na tsarana tana nauna moa amu ngaoa, rongona aia nogoria ngiti vovolimui na matena nimui aqo i laona na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Me ti vaga kamu sau ida nogoa na turina dou ba vania na Taovia, me utu goto kamu gini loaga ti kamu gania na tsarana. Ma kamu parovata dou kamu laka na tutsavuana na vangalaka tabu ara sauvanigamu igira na tinoni ni Israel ma na ida talu na ganiana sa turina kalina amu tau vati savoria na turina dou bâ vania na Taovia; me ti vaga kamu nauvaganana ia me sauba nomoa kamu mate.” ");
INSERT INTO gri_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ma na Taovia e ketsalikaira a Moses ma Aaron ");
INSERT INTO gri_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","kara ka sauvanigira na tinoni ni Israel na vovorona na ketsa vaga girani. “Niqira aqo na toga kara adimai vanikagamu ke kesa na buluka daki tsitsi me ke tau goto seko sa tabana konina, ma kara tau vati gini aqo moa, ");
INSERT INTO gri_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ma kamu ka ba sauvania a Eleasar na manetabu. Ma kara adi bâ i taba i tano tania na nauna i tana amu tototu, mi tana kara matesia i matana a Eleasar. ");
INSERT INTO gri_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Mi muri, ma Eleasar ke adia na turina na gabuna me ke lumia na kakauna i laona me ke tsirikagini bâ ke vitu kalina tana gana ngongo bâ na Valepolo Tabu. ");
INSERT INTO gri_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ma na buluka popono, kolu kokorana, ma na lakana, ma na gabuna ma na tinaena, kara kodogira sui i matana na manetabu. ");
INSERT INTO gri_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Mi muri maia ke adia ke kesa na tapana na gai na sida, ma na kokopuna na qoraqora, ma na kokolina na itai tsitsi me ke tsoni bâ gira i laona na lake. ");
INSERT INTO gri_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Mi murina ia maia ke tsagigira na polona, me ke tsalaladoua na konina, mi tana ti aia ke visutugua tana ara tototu; maia ke totu kaulinaqu moa poi ke tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Maia goto na mane e kodoa na buluka ia nina aqo ke tsagigira goto na polona me ke tsalaladoua na konina, maia ke totu kaulinaqu goto poi ke tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Mi tana, ma kesa na mane e totu male taonia na vovorona na lotu, ke tû me ke karogira na torana na buluka ia, me ke ba mologira kesa tana nauna male i taba tania na nauna i tana ara tototu, ma kara totu manoga nogo i tana vanigira na toga ni Israel agana kara gini aqo tana vangarauana na kô gana na vulimaleginiaqira na omea ara kaulinaqu tana vovorona na lotu, ma na nauana na aqona na suisui matena na sasi. ");
INSERT INTO gri_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Maia na mane e karogira na torana na buluka ia aia goto nina aqo ke tsagimalegira dou na polona, me ke totu kaulinaqu goto poi ke tsau tana ngulavi. Ma na vovorona na ketsa iani ke totu kalavata vanigira na tinoni ni Israel tana tagu sui ke mai, me vanigira goto na tinoni ni veratavosi ara totu i laoqira. ");
INSERT INTO gri_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Masei ti ke pelea na konina tinoni mate, maia ke totu kaulinaqu i laona ke vitu na dani popono. ");
INSERT INTO gri_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ma nina aqo ke lesovimale segenina tana kô na suisui tana tolunina ma na vitunina dani, mi tana ti aia ke gini male dou tugua. Me ti vaga aia ke tau suisui segenina tana tolunina ma na vitunina dani, maia e totu kaulinaqu moa. ");
INSERT INTO gri_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Masei ti vaga ke pelea moa na konina tinoni mate me ke tau vati suisui segenina moa, maia ke totu kaulinaqu kalavata moa, rongona ara tau vati langoviginia moa na kô na suisui. Maia e naqugasia nina Valepolo na Taovia, ma nimui aqo kamu tsidavaginia na tinoni vaga ia tania niqira saikolu nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Me ti vaga ke kesa ke mate i laona kesa na valepolo, masei moa ke totu i laona na valepolo ia kalina e mate na tinoni ia, se ke ba sage i laona tana tagu ia, maia ke totu kaulinaqu i laona ke vitu na dani popono. ");
INSERT INTO gri_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Me pipi sui na bilo ma na popo ara totu i laona na valepolo ia ara tau tamani vovongoqira, igira sui goto ara kaulinaqu. ");
INSERT INTO gri_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Me ti vaga ke kesa ke pelea na konina na tinoni ara labumatesia, se kesa e tavongani mate segenina i tano, se ti vaga ke kesa ke pelea na sulina tinoni se na qiluna, nina aqo ke totu kaulinaqu i laona ke vitu na dani popono. ");
INSERT INTO gri_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Masei ti ke gini kaulinaqu tana peleana na konina tinoni mate, se na sulina se na qiluna ma nina aqo ke adia na torana na buluka daki tsitsi ara kodonogoa agana na mani veoligiana na sasi, me ke molotsavua i laona kesa na popo me ke paboginia na ko maroga dou. ");
INSERT INTO gri_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Mi muri me ke kesa na tinoni aia e totu male taonia na vovorona na lotu, ke adia na kokopuna na qoraqora, me ke lumia tana kô ia, me ke tsirikagini bâ tana valepolo i tana e totu na konina tinoni mate, mi koniqira pipi sui na tinoni ma na omea ara totu i laona. Me ke tsirikagini ba gotoa i konina na mane aia e pelea na sulina, se na konina se na qiluna kesa tinoni e mate segeni se ara labumatesia. ");
INSERT INTO gri_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mi tana tolunina ma na vitunina dani, maia na tinoni e totu male taonia na vovorona na lotu ke tsirikagini bâ na kô ia i konina na tinoni e kaulinaqu. Mi tana vitunina dani maia ke nauvania na suisui, mi muri ma na tinoni ia ke tsagimalegira na polona me ke qetutsavua na kô i konina, mi tana sû na aso maia ke masidi dou tugua tana vovorona na lotu. ");
INSERT INTO gri_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Me ti ke kesa e gini kaulinaqu tana vovorona na lotu, me tau goto vati suisui segenina moa, maia e totu kaulinaqu kalavata moa, rongona ara tau vati langoviginia moa na kô na suisui. Maia e totu kolu naqu moa, me naqugasia nina Valepolo na Taovia, ma nimui aqo kamu tsidavaginia na tinoni vaga ia tania niqira saikolu nina tinoni God. ");
INSERT INTO gri_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Nimui aqo kamu tangolikakaia na vovorona na ketsa iani tana tagu sui ke mai. Ma na tinoni aia e tsirikaginia na kô na suisui nina aqo goto ke tsagidougira na polona; masei moa ti vaga ke pelea na kô ia e totu kaulinaqu goto poi ke tsau tana ngulavi. ");
INSERT INTO gri_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ma na omea sui moa ti na tinoni e kaulinaqu ke pelegira migira ara kaulinaqu goto, masei goto ti vaga ke pelegira moa na omea gira, maia goto ke totu kaulinaqu poi ke tsau tana ngulavi.” ");
INSERT INTO gri_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mi tana kesanina vula migira sui na saikolu popono tana Israel ara mai tana kaomate ni Sin, mara vaturikaegira niqira valepolo i Kades. Me mate ko Miriam mara qilua i tana. ");
INSERT INTO gri_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Mi tana nauna ia e tau totu sa kô, migira na toga ara mai tupolikaira a Moses ma Aaron, ");
INSERT INTO gri_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","mara goko korekore vanikaira mara tsaria: “!Ke dou sosongo ba vanigami ti vaga kami mate goto igami i matana nina Valepolo na Taovia kolugira na tasimami! ");
INSERT INTO gri_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","?Megua ti kagamu amu ka adigami mai i laona na kaomate iani? ?Rongona ngatsu amu ka ngaoa igami migira goto nimami omea tuavati kami gini mate sui ieni? ");
INSERT INTO gri_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","?Egua vaga ti amu ka adiligigami tania na Ejipt na mai ieni tana nauna sekoseko lê i tana e utu lelê ke dato sa omea? Mieni e tagara sa uiti, se sa vuana uaeni, se sa vuana gai mutsamutsa pui dou. !Me tau goto totu sa kô na inu!” ");
INSERT INTO gri_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mi kaira a Moses ma Aaron ara ka tuligi tanigira na toga, mara ka ba tû i matana na Valepolo Tabu. Mara ka tsuporu tsuna tana kao, ma na makana na mararana na Taovia e tavongani laba vanikaira. ");
INSERT INTO gri_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ma na Taovia e tsarivania a Moses, ");
INSERT INTO gri_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ko bâ mo ko adia na itoro e totu i matana na Bokisi na Taso, migoe maia Aaron kamu ka soasaigira na saikolu popono. Mi tana i mataqira igira sui lakalaka migoe ko goko bâ vania na maragova tabana garia, ma na kô sauba ke bubusu tsunamai i konina. Mi tana nauvaganana nogo ia ti sauba ko naua me ke busu tsunamai na kô tana maragova ia vanigira na toga, me vanigira goto niqira omea tuavati kara inu.” ");
INSERT INTO gri_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ma Moses e bâ me adia na itoro ia vaga nogo na Taovia e raiginia ke naua. ");
INSERT INTO gri_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mi kaira a Moses ma Aaron ara ka soasaigira na saikolu popono i tuana na maragova ia, ma Moses e tsarivanigira, “!Kamu rorongo sui igamu na vanga goko korekore! ?Laka amu ngaoa kami ka adi kô vanigamu tana maragova iani?” ");
INSERT INTO gri_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mi tana ma Moses e saukaea na itoro, me ruka kalina e toubaginia na maragova, ma na vuravura loki na kô e bubusu tsunamai, migira na toga sui ma niqira omea tuavati ara inu sui. ");
INSERT INTO gri_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ma na Taovia e totosasaga vanikaira a Moses ma Aaron me tsaria, “Tana rongona nogo i kagamu amu ka tau tutuniqu inau, mamu ka tau sauvulagia na susuligaqu tabu i mataqira na tinoni ni Israel, ti sauba e utu kamu ka ida vanigira na sage tana kao inau au vekenogoa kau saua vanigira.” ");
INSERT INTO gri_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Na omea vaga ia e laba i Meriba i tana nogo igira na tinoni ni Israel ara goko korekore vania na Taovia, mi tana goto aia e sauvulagi vanigira laka aia e tabu sosongo. ");
INSERT INTO gri_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kalina igira na tinoni ni Israel ara totu moa i Kades, maia Moses e molobagira visana na mane i konina na taovia tsapakae ni Edom ma kara tsarivania, “Igami ami adimaia kesa na goko e talu i koniqira na puku ni Israel igira nogo na kamamui igamu. Igoe o donagininogoa na rota loki ami tsodoa ");
INSERT INTO gri_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","me laka e koegua igira na mumuamami ara vano i Ejipt, mi tana ami totu e danga na ngalitupa. Migira na tinoni ni Ejipt ara rotasi sosongoligira na mumuamami migami goto, ");
INSERT INTO gri_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","migami ami ngangaidato vania na Taovia rongona ke sangagami. Maia e rongomia nimami nonginongi me molovanigami kesa na angelo, maia nogo e adimaurisigami tania na Ejipt. Mi kalina ia migami ami tototu i Kades, kesa na vera tana votavotana nimu butona kao igoe. ");
INSERT INTO gri_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Mami nongigo kiki laka ko tamivanigami moa kami liusaviliu bâ i laona nimu kao igoe. Igami migira nimami omea tuavati sauba e utu goto kami soba tania na sautu loki, ma kami liu bâ i laoqira nimu uta na mutsa se nimu uta na uaeni igoe, me sauba e utu goto kami inu tana nimu tuvu. Sauba kami muri kalavatavia moa na sautu loki poi ke tsau kami putsi tania nimu butona kao igoe.” ");
INSERT INTO gri_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Migira na tinoni ni Edom ara tuguvisua mara tsaria, “!Igami ami tau tamivanigamu kamu liusavu bâ i laona na veramami! Me ti vaga kamu tovoa na liusavu bâ, migami sauba kami ala bâ ma kami baginigamu.” ");
INSERT INTO gri_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Migira na tinoni ni Israel ara tsaria, “Igami sauba kami muri kalavatavia moa na sautu loki, me ti vaga igami se igira nimami omea tuavati kara inuvia ke visana nimui kô igamu, me sauba kami tsoni matena. Ma nimami papada igami, ami ngaoa moa kami liu vano saviliu.” ");
INSERT INTO gri_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Migira na tinoni ni Edom ara tsaria, “!Igami ami tau tamivanigamu!” Mara tû mara raqâ kesa niqira alaala na mane vaumate susuliga laka kara baginigira na tinoni ni Israel. ");
INSERT INTO gri_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mi tana rongona igira na tinoni ni Edom ara tau saikesa tamivanigira na Israel kara savu taligu tana niqira butona kao, te igira na Israel ara pilo mara liu kesa tana sautu segeni. ");
INSERT INTO gri_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Migira na saikolu popono tana Israel ara mololea i Kades, mara ba laba tana Vungavunga Hor, ");
INSERT INTO gri_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","tana niqira votavota na Edom. Mi tana ma na Taovia e tsarivanikaira a Moses ma Aaron. ");
INSERT INTO gri_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aia a Aaron e utu ke bâ tsau tana kao inau au vekenogoa laka kau sauvanigira na tinoni ni Israel; aia ke mate nomoa nogo ieni, rongona i kagamu sui amu ka petsakoe mangaqu i Meriba. ");
INSERT INTO gri_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Migoe a Moses ko adikaira a Aaron ma Eleasar na dalena mo ko dato kolukaira i kelana na Vungavunga Hor, ");
INSERT INTO gri_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","mi tana ko tsoraligia na polona na aqo manetabu i konina a Aaron, mo ko sagelivania a Eleasar na dalena. Maia Aaron sauba ke mate nogo i tana.” ");
INSERT INTO gri_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Maia Moses e naua na omea vaga na Taovia e ketsaliginia ke naua. Mi mataqira na saikolu popono i tugira ara tu dato i kelana na Vungavunga Hor. ");
INSERT INTO gri_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ma Moses e tsoraligia na polona na aqo manetabu i konina a Aaron, me sagelivania a Eleasar. Mi tana nogo i kelana na vungavunga e mate a Aaron, mi kaira moa a Moses ma Eleasar ara ka visutsunamai. ");
INSERT INTO gri_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mi kalina igira na toga popono ara rongomia laka e mate a Aaron, migira sui ara tangisia i laona e tolu sangavulu na dani. ");
INSERT INTO gri_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mi kalina na taovia tsapakae ni Kanaan aia e totu i Arad tabana i ata tana kao ni Kanaan, e rongomia laka igira na tinoni ni Israel ara maimai nogo tana sautu ni Atarim, maia e raqa alaala me baginigira, me laugira visana vidaqira. ");
INSERT INTO gri_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mi tana igira na Israel ara tû mara naua kesa na veke vania na Taovia mara tsaria: “Ti vaga igoe ko tamivanigami na tuliusiaqira na tinoni girani, migami ami gini vatsa vanigo laka sauba kami balo saikesaligira kolu veraqira vanigo igoe, ma kami toroveogira sui.” ");
INSERT INTO gri_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ma na Taovia e rongomia niqira nonginongi me sangagira na tuliusiaqira na tinoni ni Kanaan. Migira na Israel ara matesiligigira sui lakalaka na tinoni ni Kanaan, mara toroveogira niqira verabau, mara soaginia tana nauna ia i Horma. ");
INSERT INTO gri_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Migira na toga ni Israel ara mololea na Vungavunga Hor, mara liu tana sautu e kale bâ tana Mangalonga ni Aqaba, rongona kara liu polia niqira butona kao igira na Edom. Mi sautu migira na tinoni ara kolae sosongo, mara qisi na vanovano, ");
INSERT INTO gri_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","mara tû mara suâ ka mangaqira God ma Moses. Mara goko korekore vanikaira mara tsarivaganana, “?Egua ti amu ka adirutsumigami tania i Ejipt rongona kami gini mai mate i laona na kaomate iani, i tana e tagara lelê sa mutsa se sa kô na inu? !Migami e utu saikesa kami berengiti goto na gani sailaginiana na mutsa sekoseko iani!” ");
INSERT INTO gri_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mi tana ma na Taovia e molomai i laoqira na toga na muata veveiga, mara gatigira danga na Israel mara gini mate. ");
INSERT INTO gri_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Migira na toga ara mai tugua i konina a Moses mara tsaria, “Igami ami sasi loki sosongo kalina ami sua ka mangamui kagamu igoe ma na Taovia. Mi kalina ia migoe ko nongia na Taovia me ke adiligigira tanigami na muata veveiga girani.” Maia Moses e nonginongi mateqira na toga. ");
INSERT INTO gri_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mi tana ma na Taovia e tsarivania a Moses ke aqosia kesa na muata tapala me ke molokaea i kelana kesa na tuguru, rongona ti vaga ke kesa ke gatia na muata, maia ke moro bâ tana muata tapala me ke mauri. ");
INSERT INTO gri_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Me vaga ia, maia Moses e aqosia kesa na muata tapalamila me tsauraginikaea i kelana kesa na tuguru. Masei moa ti vaga ke gatia na muata, maia ke moro ba moa i konina na muata tapalamila ia me ke mauri. ");
INSERT INTO gri_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Migira na Israel ara vano babâ moa mara ba vaturikaegira niqira valepolo i Obot. ");
INSERT INTO gri_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Mi kalina ara mololea i Obot, mara ba vaturikaegira niqira valepolo tana avuna vera ni Abarim tana kaomate tabana i longa niqira butona kao na Moab. ");
INSERT INTO gri_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Mi kalina ara mololea i tana mara ba tototu tana Poi ni Sered. ");
INSERT INTO gri_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Mara mololegotoa i tana mara ba tototu tabana i vava na Kô Arnon, tana kaomate tana vovotana niqira kao igira na Amor. Na Kô Arnon aia nogoria niqira votavota na tinoni ni Moab ma na tinoni ni Amor. ");
INSERT INTO gri_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Aia nogoria na rongona ti ara gini goko tana rongona mara marea tana Papina nina Vailabu na Taovia na goko vaga iani: “ ... na verabau ni Uaheb i laona na tsatsapa ni Supa, mi tana poina; ma na Kô Arnon, ");
INSERT INTO gri_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","mi tana tudatona na poi, me tsau bâ tana vera ni Ar, me vano kalea niqira votavota igira na Moab.” ");
INSERT INTO gri_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Me tû i tana, migira ara vano babâ moa tsau tana nauna ara soaginia Na Tuvu, mi tana ma na Taovia e tsarivania a Moses, “Ko soasaigira na toga, minau sauba kau sauvanigira gaqira kô.” ");
INSERT INTO gri_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Mi tana tagu nogo ia igira na toga ni Israel ara lingena na linge iani: “Igoe na tuvu, ke danga dato na kô i laomu; Migami kami linge vanigo tana mage. ");
INSERT INTO gri_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Na tuvu ara tsaia igira na tinoni lokiloki ma gaqira ida na toga, ginia gana itoro na taovia ma gaqira itoro na vanovano.” Migira ara mololea tana kaomate mara vano i Matana, ");
INSERT INTO gri_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","me tû i Matana mara vano kalea i Nahaliel, me tû i Nahaliel mara bâ i Bamot, ");
INSERT INTO gri_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","me tû i Bamot mara vano kalea tana poi tana niqira butona kao igira na Moab, varangisia na Vungavunga Pisga i tana tangomana na moro gaukuti bâ tana kaomate. ");
INSERT INTO gri_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mi muri migira na toga ni Israel ara mologoko bâ vania a Sihon gaqira taovia tsapakae na Amor mara tsaria: ");
INSERT INTO gri_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Ami nongigo ko tamivanigami ma kami liu saviliu bâ tana nimu butona kao. Igami migira goto nimami omea tuavati sauba e utu goto kami soba tania na sautu loki ma kami liu bâ i laoqira nimu uta na mutsa se nimu uta na uaeni igoe, me sauba e utu goto kami inu tana nimu tuvu. Sauba kami muri kalavatavia moa na sautu loki poi ke tsau kami putsi tania nimu butona kao igoe.” ");
INSERT INTO gri_vpl VALUES ("NU21_23","0