﻿USE sofia;
DROP TABLE IF EXISTS sofia.grctr_vpl;
CREATE TABLE grctr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES grctr_vpl WRITE;
INSERT INTO grctr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Βίβλος γενέσεως Ἰησοῦ Χριστοῦ, υἱοῦ Δαβίδ, υἱοῦ Ἀβραάμ. ");
INSERT INTO grctr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ἀβραὰμ ἐγέννησε τὸν Ἰσαάκ· Ἰσαὰκ δὲ ἐγέννησε τὸν Ἰακώβ· Ἰακὼβ δὲ ἐγέννησε τὸν Ἰούδαν καὶ τοὺς ἀδελφοὺς αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ἰούδας δὲ ἐγέννησε τὸν Φαρὲς καὶ τὸν Ζαρὰ ἐκ τῆς Θάμαρ· Φαρὲς δὲ ἐγέννησε τὸν Ἑσρώμ· Ἑσρὼμ δὲ ἐγέννησε τὸν Ἀράμ· ");
INSERT INTO grctr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ἀρὰμ δὲ ἐγέννησε τὸν Ἀμιναδάβ· Ἀμιναδὰβ δὲ ἐγέννησε τὸν Ναασσών· Ναασσὼν δὲ ἐγέννησε τὸν Σαλμών· ");
INSERT INTO grctr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Σαλμὼν δὲ ἐγέννησε τὸν Βοὸζ ἐκ τῆς Ῥαχάβ· Βοὸζ δὲ ἐγέννησε τὸν Ὠβὴδ ἐκ τῆς Ῥούθ· Ὠβὴδ δὲ ἐγέννησε τὸν Ἰεσσαί· ");
INSERT INTO grctr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ἰεσσαὶ δὲ ἐγέννησε τὸν Δαβὶδ τὸν βασιλέα. Δαβὶδ δὲ ὁ βασιλεὺς ἐγέννησε τὸν Σολομῶντα ἐκ τῆς τοῦ Οὐρίου· ");
INSERT INTO grctr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Σολομὼν δὲ ἐγέννησε τὸν Ῥοβοάμ· Ῥοβοὰμ δὲ ἐγέννησε τὸν Ἀβιά· Ἀβιὰ δὲ ἐγέννησε τὸν Ἀσά· ");
INSERT INTO grctr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ἀσὰ δὲ ἐγέννησε τὸν Ἰωσαφάτ· Ἰωσαφὰτ δὲ ἐγέννησε τὸν Ἰωράμ· Ἰωρὰμ δὲ ἐγέννησε τὸν Ὀζίαν· ");
INSERT INTO grctr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ὀζίας δὲ ἐγέννησε τὸν Ἰωάθαμ· Ἰωάθαμ δὲ ἐγέννησε τὸν Ἄχαζ· Ἄχαζ δὲ ἐγέννησε τὸν Ἑζεκίαν· ");
INSERT INTO grctr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ἑζεκίας δὲ ἐγέννησε τὸν Μανασσῆ· Μανασσῆς δὲ ἐγέννησε τὸν Ἀμών· Ἀμὼν δὲ ἐγέννησε τὸν Ἰωσίαν· ");
INSERT INTO grctr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ἰωσίας δὲ ἐγέννησε τὸν Ἰεχονίαν καὶ τοὺς ἀδελφοὺς αὐτοῦ, ἐπὶ τῆς μετοικεσίας Βαβυλῶνος. ");
INSERT INTO grctr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Μετὰ δὲ τὴν μετοικεσίαν Βαβυλῶνος, Ἰεχονίας ἐγέννησε τὸν Σαλαθιήλ· Σαλαθιὴλ δὲ ἐγέννησε τὸν Ζοροβάβελ· ");
INSERT INTO grctr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ζοροβάβελ δὲ ἐγέννησε τὸν Ἀβιούδ· Ἀβιοὺδ δὲ ἐγέννησε τὸν Ἐλιακείμ· Ἐλιακεὶμ δὲ ἐγέννησε τὸν Ἀζώρ· ");
INSERT INTO grctr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ἀζὼρ δὲ ἐγέννησε τὸν Σαδώκ· Σαδὼκ δὲ ἐγέννησε τὸν Ἀχείμ· Ἀχεὶμ δὲ ἐγέννησε τὸν Ἐλιούδ· ");
INSERT INTO grctr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ἐλιοὺδ δὲ ἐγέννησε τὸν Ἐλεάζαρ· Ἐλεάζαρ δὲ ἐγέννησε τὸν Ματθάν· Ματθὰν δὲ ἐγέννησε τὸν Ἰακώβ· ");
INSERT INTO grctr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ἰακὼβ δὲ ἐγέννησε τὸν Ἰωσὴφ τὸν ἄνδρα Μαρίας, ἐξ ἧς ἐγεννήθη Ἰησοῦς, ὁ λεγόμενος Χριστός. ");
INSERT INTO grctr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Πᾶσαι οὖν αἱ γενεαὶ ἀπὸ Ἀβραὰμ ἕως Δαβὶδ γενεαὶ δεκατέσσαρες· καὶ ἀπὸ Δαβὶδ ἕως τῆς μετοικεσίας Βαβυλῶνος, γενεαὶ δεκατέσσαρες· καὶ ἀπὸ τῆς μετοικεσίας Βαβυλῶνος ἕως τοῦ Χριστοῦ, γενεαὶ δεκατέσσαρες. ");
INSERT INTO grctr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Τοῦ δὲ Ἰησοῦ Χριστοῦ ἡ γέννησις οὕτως ἦν· μνηστευθείσης γὰρ τῆς μητρὸς αὐτοῦ Μαρίας τῷ Ἰωσήφ, πρὶν ἢ συνελθεῖν αὐτούς, εὑρέθη ἐν γαστρὶ ἔχουσα ἐκ πνεύματος ἁγίου. ");
INSERT INTO grctr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ἰωσὴφ δὲ ὁ ἀνὴρ αὐτῆς, δίκαιος ὤν, καὶ μὴ θέλων αὐτὴν παραδειγματίσαι, ἐβουλήθη λάθρᾳ ἀπολῦσαι αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ταῦτα δὲ αὐτοῦ ἐνθυμηθέντος, ἰδού, ἄγγελος Κυρίου κατ᾿ ὄναρ ἐφάνη αὐτῷ, λέγων, Ἰωσήφ, υἱὸς Δαβίδ, μὴ φοβηθῇς παραλαβεῖν Μαριὰμ τὴν γυναῖκά σου· τὸ γὰρ ἐν αὐτῇ γεννηθὲν ἐκ πνεύματός ἐστιν ἁγίου. ");
INSERT INTO grctr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Τέξεται δὲ υἱόν, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰησοῦν· αὐτὸς γὰρ σώσει τὸν λαὸν αὐτοῦ ἀπὸ τῶν ἁμαρτιῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Τοῦτο δὲ ὅλον γέγονεν, ἵνα πληρωθῇ τὸ ῥηθὲν ὑπὸ τοῦ Κυρίου διὰ τοῦ προφήτου, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ἰδού, ἡ παρθένος ἐν γαστρὶ ἕξει καὶ τέξεται υἱόν, καὶ καλέσουσι τὸ ὄνομα αὐτοῦ Ἐμμανουήλ, ὅ ἐστι μεθερμηνευόμενον, Μεθ᾿ ἡμῶν ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Διεγερθεὶς δὲ ὁ Ἰωσὴφ ἀπὸ τοῦ ὕπνου, ἐποίησεν ὡς προσέταξεν αὐτῷ ὁ ἄγγελος Κυρίου· καὶ παρέλαβε τὴν γυναῖκα αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","καὶ οὐκ ἐγίνωσκεν αὐτὴν ἕως οὗ ἔτεκε τὸν υἱὸν αὐτῆς τὸν πρωτότοκον· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Τοῦ δὲ Ἰησοῦ γεννηθέντος ἐν Βηθλεὲμ τῆς Ἰουδαίας, ἐν ἡμέραις Ἡρῴδου τοῦ βασιλέως, ἰδού, μάγοι ἀπὸ ἀνατολῶν παρεγένοντο εἰς Ἱεροσόλυμα, ");
INSERT INTO grctr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","λέγοντες, Ποῦ ἐστὶν ὁ τεχθεὶς βασιλεὺς τῶν Ἰουδαίων; Εἴδομεν γὰρ αὐτοῦ τὸν ἀστέρα ἐν τῇ ἀνατολῇ, καὶ ἤλθομεν προσκυνῆσαι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ἀκούσας δὲ Ἡρῴδης ὁ βασιλεὺς ἐταράχθη, καὶ πᾶσα Ἱεροσόλυμα μετ᾿ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","καὶ συναγαγὼν πάντας τοὺς ἀρχιερεῖς καὶ γραμματεῖς τοῦ λαοῦ, ἐπυνθάνετο παρ᾿ αὐτῶν ποῦ ὁ Χριστὸς γεννᾶται. ");
INSERT INTO grctr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Οἱ δὲ εἶπον αὐτῷ, Ἐν Βηθλεὲμ τῆς Ἰουδαίας· οὕτω γὰρ γέγραπται διὰ τοῦ προφήτου, ");
INSERT INTO grctr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Καὶ σὺ Βηθλεέμ, γῆ Ἰούδα, οὐδαμῶς ἐλαχίστη εἶ ἐν τοῖς ἡγεμόσιν Ἰούδα· ἐκ σοῦ γὰρ ἐξελεύσεται ἡγούμενος, ὅστις ποιμανεῖ τὸν λαόν μου τὸν Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Τότε Ἡρῴδης, λάθρᾳ καλέσας τοὺς μάγους, ἠκρίβωσε παρ᾿ αὐτῶν τὸν χρόνον τοῦ φαινομένου ἀστέρος. ");
INSERT INTO grctr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Καὶ πέμψας αὐτοὺς εἰς Βηθλεὲμ εἶπε, Πορευθέντες ἀκριβῶς ἐξετάσατε περὶ τοῦ παιδίου· ἐπὰν δὲ εὕρητε, ἀπαγγείλατέ μοι, ὅπως κἀγὼ ἐλθὼν προσκυνήσω αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Οἱ δὲ ἀκούσαντες τοῦ βασιλέως ἐπορεύθησαν· καὶ ἰδού, ὁ ἀστήρ, ὃν εἶδον ἐν τῇ ἀνατολῇ, προῆγεν αὐτούς, ἕως ἐλθὼν ἔστη ἐπάνω οὗ ἦν τὸ παιδίον. ");
INSERT INTO grctr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ἰδόντες δὲ τὸν ἀστέρα, ἐχάρησαν χαρὰν μεγάλην σφόδρα. ");
INSERT INTO grctr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Καὶ ἐλθόντες εἰς τὴν οἰκίαν, εὗρον τὸ παιδίον μετὰ Μαρίας τῆς μητρὸς αὐτοῦ, καὶ πεσόντες προσεκύνησαν αὐτῷ, καὶ ἀνοίξαντες τοὺς θησαυροὺς αὐτῶν προσήνεγκαν αὐτῷ δῶρα, χρυσὸν καὶ λίβανον καὶ σμύρναν. ");
INSERT INTO grctr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Καὶ χρηματισθέντες κατ᾿ ὄναρ μὴ ἀνακάμψαι πρὸς Ἡρῴδην, δι᾿ ἄλλης ὁδοῦ ἀνεχώρησαν εἰς τὴν χώραν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ἀναχωρησάντων δὲ αὐτῶν, ἰδού, ἄγγελος Κυρίου φαίνεται κατ᾿ ὄναρ τῷ Ἰωσήφ, λέγων, Ἐγερθεὶς παράλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ, καὶ φεῦγε εἰς Αἴγυπτον, καὶ ἴσθι ἐκεῖ ἕως ἂν εἴπω σοί· μέλλει γὰρ Ἡρῴδης ζητεῖν τὸ παιδίον, τοῦ ἀπολέσαι αὐτό. ");
INSERT INTO grctr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ὁ δὲ ἐγερθεὶς παρέλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ νυκτός, καὶ ἀνεχώρησεν εἰς Αἴγυπτον, ");
INSERT INTO grctr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","καὶ ἦν ἐκεῖ ἕως τῆς τελευτῆς Ἡρῴδου· ἵνα πληρωθῇ τὸ ῥηθὲν ὑπὸ τοῦ Κυρίου διὰ τοῦ προφήτου, λέγοντος, Ἐξ Αἰγύπτου ἐκάλεσα τὸν υἱόν μου. ");
INSERT INTO grctr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Τότε Ἡρῴδης, ἰδὼν ὅτι ἐνεπαίχθη ὑπὸ τῶν μάγων, ἐθυμώθη λίαν, καὶ ἀποστείλας ἀνεῖλε πάντας τοὺς παῖδας τοὺς ἐν Βηθλεὲμ καὶ ἐν πᾶσι τοῖς ὁρίοις αὐτῆς, ἀπὸ διετοῦς καὶ κατωτέρω, κατὰ τὸν χρόνον ὃν ἠκρίβωσε παρὰ τῶν μάγων. ");
INSERT INTO grctr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Τότε ἐπληρώθη τὸ ῥηθὲν ὑπὸ Ἰερεμίου τοῦ προφήτου, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Φωνὴ ἐν Ῥαμᾶ ἠκούσθη, θρῆνος καὶ κλαυθμὸς καὶ ὀδυρμὸς πολύς, Ῥαχὴλ κλαίουσα τὰ τέκνα αὐτῆς, καὶ οὐκ ἤθελε παρακληθῆναι, ὅτι οὐκ εἰσί. ");
INSERT INTO grctr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Τελευτήσαντος δὲ τοῦ Ἡρῴδου, ἰδού, ἄγγελος Κυρίου κατ᾿ ὄναρ φαίνεται τῷ Ἰωσὴφ ἐν Αἰγύπτῳ, ");
INSERT INTO grctr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","λέγων, Ἐγερθεὶς παράλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ, καὶ πορεύου εἰς γῆν Ἰσραήλ· τεθνήκασι γὰρ οἱ ζητοῦντες τὴν ψυχὴν τοῦ παιδίου. ");
INSERT INTO grctr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ὁ δὲ ἐγερθεὶς παρέλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ, καὶ ἦλθεν εἰς γῆν Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ἀκούσας δὲ ὅτι Ἀρχέλαος βασιλεύει ἐπὶ τῆς Ἰουδαίας ἀντὶ Ἡρῴδου τοῦ πατρὸς αὐτοῦ, ἐφοβήθη ἐκεῖ ἀπελθεῖν· χρηματισθεὶς δὲ κατ᾿ ὄναρ, ἀνεχώρησεν εἰς τὰ μέρη τῆς Γαλιλαίας, ");
INSERT INTO grctr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","καὶ ἐλθὼν κατῴκησεν εἰς πόλιν λεγομένην Ναζαρέτ· ὅπως πληρωθῇ τὸ ῥηθὲν διὰ τῶν προφητῶν, ὅτι Ναζωραῖος κληθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ἐν δὲ ταῖς ἡμέραις ἐκείναις παραγίνεται Ἰωάννης ὁ βαπτιστής, κηρύσσων ἐν τῇ ἐρήμῳ τῆς Ἰουδαίας, ");
INSERT INTO grctr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","καὶ λέγων, Μετανοεῖτε· ἤγγικε γὰρ ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Οὗτος γάρ ἐστιν ὁ ῥηθεὶς ὑπὸ Ἠσαΐου τοῦ προφήτου, λέγοντος, Φωνὴ βοῶντος ἐν τῇ ἐρήμῳ, Ἑτοιμάσατε τὴν ὁδὸν Κυρίου· εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Αὐτὸς δὲ ὁ Ἰωάννης εἶχε τὸ ἔνδυμα αὐτοῦ ἀπὸ τριχῶν καμήλου, καὶ ζώνην δερματίνην περὶ τὴν ὀσφὺν αὐτοῦ· ἡ δὲ τροφὴ αὐτοῦ ἦν ἀκρίδες καὶ μέλι ἄγριον. ");
INSERT INTO grctr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Τότε ἐξεπορεύετο πρὸς αὐτὸν Ἱεροσόλυμα καὶ πᾶσα ἡ Ἰουδαία καὶ πᾶσα ἡ περίχωρος τοῦ Ἰορδάνου· ");
INSERT INTO grctr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","καὶ ἐβαπτίζοντο ἐν τῷ Ἰορδάνῃ ὑπ᾿ αὐτοῦ, ἐξομολογούμενοι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ἰδὼν δὲ πολλοὺς τῶν Φαρισαίων καὶ Σαδδουκαίων ἐρχομένους ἐπὶ τὸ βάπτισμα αὐτοῦ, εἶπεν αὐτοῖς, Γεννήματα ἐχιδνῶν, τίς ὑπέδειξεν ὑμῖν φυγεῖν ἀπὸ τῆς μελλούσης ὀργῆς; ");
INSERT INTO grctr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ποιήσατε οὖν καρποὺς ἄξιους τῆς μετανοίας· ");
INSERT INTO grctr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","καὶ μὴ δόξητε λέγειν ἐν ἑαυτοῖς, Πατέρα ἔχομεν τὸν Ἀβραάμ· λέγω γὰρ ὑμῖν ὅτι δύναται ὁ Θεὸς ἐκ τῶν λίθων τούτων ἐγεῖραι τέκνα τῷ Ἀβραάμ. ");
INSERT INTO grctr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ἤδη δὲ καὶ ἡ ἀξίνη πρὸς τὴν ῥίζαν τῶν δένδρων κεῖται· πᾶν οὖν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grctr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ἐγὼ μὲν βαπτίζω ὑμᾶς ἐν ὕδατι εἰς μετάνοιαν· ὁ δὲ ὀπίσω μου ἐρχόμενος ἰσχυρότερός μου ἐστίν, οὗ οὐκ εἰμὶ ἱκανὸς τὰ ὑποδήματα βαστάσαι· αὐτὸς ὑμᾶς βαπτίσει ἐν πνεύματι ἁγίῳ καὶ πυρί. ");
INSERT INTO grctr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Οὗ τὸ πτύον ἐν τῇ χειρὶ αὐτοῦ, καὶ διακαθαριεῖ τὴν ἅλωνα αὐτοῦ, καὶ συνάξει τὸν σῖτον αὐτοῦ εἰς τὴν ἀποθήκην, τὸ δὲ ἄχυρον κατακαύσει πυρὶ ἀσβέστῳ. ");
INSERT INTO grctr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Τότε παραγίνεται ὁ Ἰησοῦς ἀπὸ τῆς Γαλιλαίας ἐπὶ τὸν Ἰορδάνην πρὸς τὸν Ἰωάννην, τοῦ βαπτισθῆναι ὑπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ὁ δὲ Ἰωάννης διεκώλυεν αὐτόν, λέγων, Ἐγὼ χρείαν ἔχω ὑπὸ σοῦ βαπτισθῆναι, καὶ σὺ ἔρχῃ πρός με; ");
INSERT INTO grctr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπε πρὸς αὐτόν, Ἄφες ἄρτι· οὕτω γὰρ πρέπον ἐστὶν ἡμῖν πληρῶσαι πᾶσαν δικαιοσύνην. Τότε ἀφίησιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Καὶ βαπτισθεὶς ὁ Ἰησοῦς ἀνέβη εὐθὺς ἀπὸ τοῦ ὕδατος· καὶ ἰδού, ἀνεῴχθησαν αὐτῷ οἱ οὐρανοί, καὶ εἶδε τὸ πνεῦμα τοῦ Θεοῦ καταβαῖνον ὡσεὶ περιστερὰν καὶ ἐρχόμενον ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Καὶ ἰδού, φωνὴ ἐκ τῶν οὐρανῶν, λέγουσα, Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός, ἐν ᾧ εὐδόκησα. ");
INSERT INTO grctr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Τότε ὁ Ἰησοῦς ἀνήχθη εἰς τὴν ἔρημον ὑπὸ τοῦ πνεύματος, πειρασθῆναι ὑπὸ τοῦ διαβόλου. ");
INSERT INTO grctr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Καὶ νηστεύσας ἡμέρας τεσσαράκοντα καὶ νύκτας τεσσαράκοντα, ὕστερον ἐπείνασε. ");
INSERT INTO grctr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Καὶ προσελθὼν αὐτῷ ὁ πειράζων εἶπεν, Εἰ υἱὸς εἶ τοῦ Θεοῦ, εἰπὲ ἵνα οἱ λίθοι οὗτοι ἄρτοι γένωνται. ");
INSERT INTO grctr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ὁ δὲ ἀποκριθεὶς εἶπε, Γέγραπται, Οὐκ ἐπ᾿ ἄρτῳ μόνῳ ζήσεται ἄνθρωπος, ἀλλ᾿ ἐπὶ παντὶ ῥήματι ἐκπορευομένῳ διὰ στόματος Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Τότε παραλαμβάνει αὐτὸν ὁ διάβολος εἰς τὴν ἁγίαν πόλιν, καὶ ἵστησιν αὐτὸν ἐπὶ τὸ πτερύγιον τοῦ ἱεροῦ, ");
INSERT INTO grctr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","καὶ λέγει αὐτῷ, Εἰ υἱὸς εἶ τοῦ Θεοῦ, βάλε σεαυτὸν κάτω· γέγραπται γὰρ ὅτι Τοῖς ἀγγέλοις αὐτοῦ ἐντελεῖται περὶ σοῦ· καί, Ἐπὶ χειρῶν ἀροῦσί σε, μήποτε προσκόψῃς πρὸς λίθον τὸν πόδα σοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ἔφη αὐτῷ ὁ Ἰησοῦς, Πάλιν γέγραπται, Οὐκ ἐκπειράσεις Κύριον τὸν Θεόν σου. ");
INSERT INTO grctr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Πάλιν παραλαμβάνει αὐτὸν ὁ διάβολος εἰς ὄρος ὑψηλὸν λίαν, καὶ δείκνυσιν αὐτῷ πάσας τὰς βασιλείας τοῦ κόσμου καὶ τὴν δόξαν αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","καὶ λέγει αὐτῷ, Ταῦτα πάντα σοι δώσω, ἐὰν πεσὼν προσκυνήσῃς μοι. ");
INSERT INTO grctr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Τότε λέγει αὐτῷ ὁ Ἰησοῦς, Ὕπαγε, Σατανᾶ· γέγραπται γάρ, Κύριον τὸν Θεόν σου προσκυνήσεις, καὶ αὐτῷ μόνῳ λατρεύσεις. ");
INSERT INTO grctr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Τότε ἀφίησιν αὐτὸν ὁ διάβολος· καὶ ἰδού, ἄγγελοι προσῆλθον καὶ διηκόνουν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ἀκούσας δὲ ὁ Ἰησοῦς ὅτι Ἰωάννης παρεδόθη, ἀνεχώρησεν εἰς τὴν Γαλιλαίαν· ");
INSERT INTO grctr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","καὶ καταλιπὼν τὴν Ναζαρέτ, ἐλθὼν κατῴκησεν εἰς Καπερναοὺμ τὴν παραθαλασσίαν, ἐν ὁρίοις Ζαβουλὼν καὶ Νεφθαλείμ· ");
INSERT INTO grctr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ἵνα πληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Γῆ Ζαβουλὼν καὶ γῆ Νεφθαλείμ, ὁδὸν θαλάσσης, πέραν τοῦ Ἰορδάνου, Γαλιλαία τῶν ἐθνῶν, ");
INSERT INTO grctr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ὁ λαὸς ὁ καθήμενος ἐν σκότει εἶδε φῶς μέγα, καὶ τοῖς καθημένοις ἐν χώρᾳ καὶ σκιᾷ θανάτου, φῶς ἀνέτειλεν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ἀπὸ τότε ἤρξατο ὁ Ἰησοῦς κηρύσσειν καὶ λέγειν, Μετανοεῖτε· ἤγγικε γὰρ ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Περιπατῶν δὲ ὁ Ἰησοῦς παρὰ τὴν θάλασσαν τῆς Γαλιλαίας εἶδε δύο ἀδελφούς, Σίμωνα τὸν λεγόμενον Πέτρον, καὶ Ἀνδρέαν τὸν ἀδελφὸν αὐτοῦ, βάλλοντας ἀμφίβληστρον εἰς τὴν θάλασσαν· ἦσαν γὰρ ἁλιεῖς. ");
INSERT INTO grctr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Καὶ λέγει αὐτοῖς, Δεῦτε ὀπίσω μου, καὶ ποιήσω ὑμᾶς ἁλιεῖς ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Οἱ δὲ εὐθέως ἀφέντες τὰ δίκτυα ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Καὶ προβὰς ἐκεῖθεν, εἶδεν ἄλλους δύο ἀδελφούς, Ἰάκωβον τὸν τοῦ Ζεβεδαίου καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, ἐν τῷ πλοίῳ μετὰ Ζεβεδαίου τοῦ πατρὸς αὐτῶν, καταρτίζοντας τὰ δίκτυα αὐτῶν· καὶ ἐκάλεσεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Οἱ δὲ εὐθέως ἀφέντες τὸ πλοῖον καὶ τὸν πατέρα αὐτῶν ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Καὶ περιῆγεν ὅλην τὴν Γαλιλαίαν ὁ Ἰησοῦς, διδάσκων ἐν ταῖς συναγωγαῖς αὐτῶν, καὶ κηρύσσων τὸ εὐαγγέλιον τῆς βασιλείας, καὶ θεραπεύων πᾶσαν νόσον καὶ πᾶσαν μαλακίαν ἐν τῷ λαῷ. ");
INSERT INTO grctr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Καὶ ἀπῆλθεν ἡ ἀκοὴ αὐτοῦ εἰς ὅλην τὴν Συρίαν· καὶ προσήνεγκαν αὐτῷ πάντας τοὺς κακῶς ἔχοντας, ποικίλαις νόσοις καὶ βασάνοις συνεχομένους, καὶ δαιμονιζομένους, καὶ σεληνιαζομένους, καὶ παραλυτικούς· καὶ ἐθεράπευσεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Καὶ ἠκολούθησαν αὐτῷ ὄχλοι πολλοὶ ἀπὸ τῆς Γαλιλαίας καὶ Δεκαπόλεως καὶ Ἱεροσολύμων καὶ Ἰουδαίας καὶ πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grctr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ἰδὼν δὲ τοὺς ὄχλους, ἀνέβη εἰς τὸ ὄρος· καὶ καθίσαντος αὐτοῦ, προσῆλθον αὐτῷ οἱ μαθηταὶ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","καὶ ἀνοίξας τὸ στόμα αὐτοῦ, ἐδίδασκεν αὐτούς, λέγων, ");
INSERT INTO grctr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Μακάριοι οἱ πτωχοὶ τῷ πνεύματι· ὅτι αὐτῶν ἐστιν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Μακάριοι οἱ πενθοῦντες· ὅτι αὐτοὶ παρακληθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Μακάριοι οἱ πρᾳεῖς· ὅτι αὐτοὶ κληρονομήσουσι τὴν γῆν. ");
INSERT INTO grctr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Μακάριοι οἱ πεινῶντες καὶ διψῶντες τὴν δικαιοσύνην· ὅτι αὐτοὶ χορτασθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Μακάριοι οἱ ἐλεήμονες· ὅτι αὐτοὶ ἐλεηθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Μακάριοι οἱ καθαροὶ τῇ καρδίᾳ· ὅτι αὐτοὶ τὸν Θεὸν ὄψονται. ");
INSERT INTO grctr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Μακάριοι οἱ εἰρηνοποιοί· ὅτι αὐτοὶ υἱοὶ Θεοῦ κληθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Μακάριοι οἱ δεδιωγμένοι ἕνεκεν δικαιοσύνης· ὅτι αὐτῶν ἐστιν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Μακάριοί ἐστε, ὅταν ὀνειδίσωσιν ὑμᾶς καὶ διώξωσι, καὶ εἴπωσι πᾶν πονηρὸν ῥῆμα καθ᾿ ὑμῶν ψευδόμενοι, ἕνεκεν ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Χαίρετε καὶ ἀγαλλιᾶσθε, ὅτι ὁ μισθὸς ὑμῶν πολὺς ἐν τοῖς οὐρανοῖς· οὕτω γὰρ ἐδίωξαν τοὺς προφήτας τοὺς πρὸ ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ὑμεῖς ἐστε τὸ ἅλας τῆς γῆς· ἐὰν δὲ τὸ ἅλας μωρανθῇ, ἐν τίνι ἁλισθήσεται; Εἰς οὐδὲν ἰσχύει ἔτι, εἰ μὴ βληθῆναι ἔξω καὶ καταπατεῖσθαι ὑπὸ τῶν ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ὑμεῖς ἐστε τὸ φῶς τοῦ κόσμου· οὐ δύναται πόλις κρυβῆναι ἐπάνω ὄρους κειμένη· ");
INSERT INTO grctr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","οὐδὲ καίουσι λύχνον καὶ τιθέασιν αὐτὸν ὑπὸ τὸν μόδιον, ἀλλ᾿ ἐπὶ τὴν λυχνίαν, καὶ λάμπει πᾶσι τοῖς ἐν τῇ οἰκίᾳ. ");
INSERT INTO grctr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Οὕτω λαμψάτω τὸ φῶς ὑμῶν ἔμπροσθεν τῶν ἀνθρώπων, ὅπως ἴδωσιν ὑμῶν τὰ καλὰ ἔργα, καὶ δοξάσωσι τὸν πατέρα ὑμῶν τὸν ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Μὴ νομίσητε ὅτι ἦλθον καταλῦσαι τὸν νόμον ἢ τοὺς προφήτας· οὐκ ἦλθον καταλῦσαι ἀλλὰ πληρῶσαι. ");
INSERT INTO grctr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ἀμὴν γὰρ λέγω ὑμῖν, ἕως ἂν παρέλθῃ ὁ οὐρανὸς καὶ ἡ γῆ, ἰῶτα ἓν ἢ μία κεραία οὐ μὴ παρέλθῃ ἀπὸ τοῦ νόμου, ἕως ἂν πάντα γένηται. ");
INSERT INTO grctr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ὃς ἐὰν οὖν λύσῃ μίαν τῶν ἐντολῶν τούτων τῶν ἐλαχίστων, καὶ διδάξῃ οὕτω τοὺς ἀνθρώπους, ἐλάχιστος κληθήσεται ἐν τῇ βασιλείᾳ τῶν οὐρανῶν· ὃς δ᾿ ἂν ποιήσῃ καὶ διδάξῃ, οὗτος μέγας κληθήσεται ἐν τῇ βασιλείᾳ τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Λέγω γὰρ ὑμῖν ὅτι ἐὰν μὴ περισσεύσῃ ἡ δικαιοσύνη ὑμῶν πλεῖον τῶν γραμματέων καὶ Φαρισαίων, οὐ μὴ εἰσέλθητε εἰς τὴν βασιλείαν τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ἠκούσατε ὅτι ἐρρέθη τοῖς ἀρχαίοις, Οὐ φονεύσεις· ὃς δ᾿ ἂν φονεύσῃ, ἔνοχος ἔσται τῇ κρίσει· ");
INSERT INTO grctr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ἐγὼ δὲ λέγω ὑμῖν ὅτι πᾶς ὁ ὀργιζόμενος τῷ ἀδελφῷ αὐτοῦ εἰκῇ ἔνοχος ἔσται τῇ κρίσει· ὃς δ᾿ ἂν εἴπῃ τῷ ἀδελφῷ αὐτοῦ, Ῥακά, ἔνοχος ἔσται τῷ συνεδρίῳ· ὃς δ᾿ ἂν εἴπῃ, Μωρέ, ἔνοχος ἔσται εἰς τὴν γέενναν τοῦ πυρός. ");
INSERT INTO grctr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ἐὰν οὖν προσφέρῃς τὸ δῶρόν σου ἐπὶ τὸ θυσιαστήριον, κἀκεῖ μνησθῇς ὅτι ὁ ἀδελφός σου ἔχει τι κατὰ σοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ἄφες ἐκεῖ τὸ δῶρόν σου ἔμπροσθεν τοῦ θυσιαστηρίου, καὶ ὕπαγε, πρῶτον διαλλάγηθι τῷ ἀδελφῷ σου, καὶ τότε ἐλθὼν πρόσφερε τὸ δῶρόν σου. ");
INSERT INTO grctr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ἴσθι εὐνοῶν τῷ ἀντιδίκῳ σου ταχύ, ἕως ὅτου εἶ ἐν τῇ ὁδῷ μετ᾿ αὐτοῦ, μήποτέ σε παραδῷ ὁ ἀντίδικος τῷ κριτῇ, καὶ ὁ κριτής σε παραδῷ τῷ ὑπηρέτῃ, καὶ εἰς φυλακὴν βληθήσῃ. ");
INSERT INTO grctr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ἀμὴν λέγω σοι, οὐ μὴ ἐξέλθῃς ἐκεῖθεν, ἕως ἂν ἀποδῷς τὸν ἔσχατον κοδράντην. ");
INSERT INTO grctr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ἠκούσατε ὅτι ἐρρέθη τοῖς ἀρχαίοις, Οὐ μοιχεύσεις· ");
INSERT INTO grctr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ἐγὼ δὲ λέγω ὑμῖν ὅτι πᾶς ὁ βλέπων γυναῖκα πρὸς τὸ ἐπιθυμῆσαι αὐτῆς ἤδη ἐμοίχευσεν αὐτὴν ἐν τῇ καρδίᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Εἰ δὲ ὁ ὀφθαλμός σου ὁ δεξιὸς σκανδαλίζει σε, ἔξελε αὐτὸν καὶ βάλε ἀπὸ σοῦ· συμφέρει γάρ σοι ἵνα ἀπόληται ἓν τῶν μελῶν σου, καὶ μὴ ὅλον τὸ σῶμά σου βληθῇ εἰς γέενναν. ");
INSERT INTO grctr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Καὶ εἰ ἡ δεξιά σου χεὶρ σκανδαλίζει σε, ἔκκοψον αὐτὴν καὶ βάλε ἀπὸ σοῦ· συμφέρει γάρ σοι ἵνα ἀπόληται ἓν τῶν μελῶν σου, καὶ μὴ ὅλον τὸ σῶμά σου βληθῇ εἰς γέενναν. ");
INSERT INTO grctr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ἐρρέθη δὲ ὅτι Ὃς ἂν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ, δότω αὐτῇ ἀποστάσιον· ");
INSERT INTO grctr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ἐγὼ δὲ λέγω ὑμῖν ὅτι ὃς ἂν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ, παρεκτὸς λόγου πορνείας, ποιεῖ αὐτὴν μοιχᾶσθαι· καὶ ὃς ἐὰν ἀπολελυμένην γαμήσῃ μοιχᾶται. ");
INSERT INTO grctr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Πάλιν ἠκούσατε ὅτι ἐρρέθη τοῖς ἀρχαίοις, Οὐκ ἐπιορκήσεις, ἀποδώσεις δὲ τῷ Κυρίῳ τοὺς ὅρκους σου· ");
INSERT INTO grctr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ἐγὼ δὲ λέγω ὑμῖν μὴ ὀμόσαι ὅλως· μήτε ἐν τῷ οὐρανῷ, ὅτι θρόνος ἐστὶ τοῦ Θεοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","μήτε ἐν τῇ γῇ, ὅτι ὑποπόδιόν ἐστι τῶν ποδῶν αὐτοῦ· μήτε εἰς Ἱεροσόλυμα, ὅτι πόλις ἐστὶ τοῦ μεγάλου βασιλέως· ");
INSERT INTO grctr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","μήτε ἐν τῇ κεφαλῇ σου ὀμόσῃς, ὅτι οὐ δύνασαι μίαν τρίχα λευκὴν ἢ μέλαιναν ποιῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ἔστω δὲ ὁ λόγος ὑμῶν, ναὶ ναί, οὒ οὔ· τὸ δὲ περισσὸν τούτων ἐκ τοῦ πονηροῦ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ἠκούσατε ὅτι ἐρρέθη, Ὀφθαλμὸν ἀντὶ ὀφθαλμοῦ, καὶ ὀδόντα ἀντὶ ὀδόντος· ");
INSERT INTO grctr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ἐγὼ δὲ λέγω ὑμῖν μὴ ἀντιστῆναι τῷ πονηρῷ· ἀλλ᾿ ὅστις σε ῥαπίσει ἐπὶ τὴν δεξιάν σου σιαγόνα, στρέψον αὐτῷ καὶ τὴν ἄλλην· ");
INSERT INTO grctr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","καὶ τῷ θέλοντί σοι κριθῆναι καὶ τὸν χιτῶνά σου λαβεῖν, ἄφες αὐτῷ καὶ τὸ ἱμάτιον· ");
INSERT INTO grctr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","καὶ ὅστις σε ἀγγαρεύσει μίλιον ἕν, ὕπαγε μετ᾿ αὐτοῦ δύο. ");
INSERT INTO grctr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Τῷ αἰτοῦντί σε δίδου· καὶ τὸν θέλοντα ἀπὸ σοῦ δανείσασθαι μὴ ἀποστραφῇς. ");
INSERT INTO grctr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ἠκούσατε ὅτι ἐρρέθη, Ἀγαπήσεις τὸν πλησίον σου, καὶ μισήσεις τὸν ἐχθρόν σου· ");
INSERT INTO grctr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ἐγὼ δὲ λέγω ὑμῖν, Ἀγαπᾶτε τοὺς ἐχθροὺς ὑμῶν, εὐλογεῖτε τοὺς καταρωμένους ὑμᾶς, καλῶς ποιεῖτε τοὺς μισοῦντας ὑμᾶς, καὶ προσεύχεσθε ὑπὲρ τῶν ἐπηρεαζόντων ὑμᾶς, καὶ διωκόντων ὑμᾶς· ");
INSERT INTO grctr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ὅπως γένησθε υἱοὶ τοῦ πατρὸς ὑμῶν τοῦ ἐν οὐρανοῖς, ὅτι τὸν ἥλιον αὐτοῦ ἀνατέλλει ἐπὶ πονηροὺς καὶ ἀγαθούς, καὶ βρέχει ἐπὶ δικαίους καὶ ἀδίκους. ");
INSERT INTO grctr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ἐὰν γὰρ ἀγαπήσητε τοὺς ἀγαπῶντας ὑμᾶς, τίνα μισθὸν ἔχετε; Οὐχὶ καὶ οἱ τελῶναι τὸ αὐτὸ ποιοῦσι; ");
INSERT INTO grctr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Καὶ ἐὰν ἀσπάσησθε τοὺς ἀδελφοὺς ὑμῶν μόνον, τί περισσὸν ποιεῖτε; Οὐχὶ καὶ οἱ τελῶναι οὕτω ποιοῦσιν; ");
INSERT INTO grctr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ἔσεσθε οὖν ὑμεῖς τέλειοι, ὥσπερ ὁ πατὴρ ὑμῶν ὁ ἐν τοῖς οὐρανοῖς τέλειός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Προσέχετε τὴν ἐλεημοσύνην ὑμῶν μὴ ποιεῖν ἔμπροσθεν τῶν ἀνθρώπων, πρὸς τὸ θεαθῆναι αὐτοῖς· εἰ δὲ μήγε, μισθὸν οὐκ ἔχετε παρὰ τῷ πατρὶ ὑμῶν τῷ ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ὅταν οὖν ποιῇς ἐλεημοσύνην, μὴ σαλπίσῃς ἔμπροσθέν σου, ὥσπερ οἱ ὑποκριταὶ ποιοῦσιν ἐν ταῖς συναγωγαῖς καὶ ἐν ταῖς ῥύμαις, ὅπως δοξασθῶσιν ὑπὸ τῶν ἀνθρώπων· ἀμὴν λέγω ὑμῖν, ἀπέχουσι τὸν μισθὸν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Σοῦ δὲ ποιοῦντος ἐλεημοσύνην, μὴ γνώτω ἡ ἀριστερά σου τί ποιεῖ ἡ δεξιά σου, ");
INSERT INTO grctr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ὅπως ᾖ σου ἡ ἐλεημοσύνη ἐν τῷ κρυπτῷ· καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ κρυπτῷ αὐτὸς ἀποδώσει σοι ἐν τῷ φανερῷ. ");
INSERT INTO grctr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Καὶ ὅταν προσεύχῃ, οὐκ ἔσῃ ὥσπερ οἱ ὑποκριταί, ὅτι φιλοῦσιν ἐν ταῖς συναγωγαῖς καὶ ἐν ταῖς γωνίαις τῶν πλατειῶν ἑστῶτες προσεύχεσθαι, ὅπως ἂν φανῶσι τοῖς ἀνθρώποις· ἀμὴν λέγω ὑμῖν ὅτι ἀπέχουσι τὸν μισθὸν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Σὺ δέ, ὅταν προσεύχῃ, εἴσελθε εἰς τὸ ταμιεῖόν σου, καὶ κλείσας τὴν θύραν σου, πρόσευξαι τῷ πατρί σου τῷ ἐν τῷ κρυπτῷ· καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ κρυπτῷ ἀποδώσει σοι ἐν τῷ φανερῷ. ");
INSERT INTO grctr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Προσευχόμενοι δὲ μὴ βαττολογήσητε, ὥσπερ οἱ ἐθνικοί· δοκοῦσι γὰρ ὅτι ἐν τῇ πολυλογίᾳ αὐτῶν εἰσακουσθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Μὴ οὖν ὁμοιωθῆτε αὐτοῖς· οἶδε γὰρ ὁ πατὴρ ὑμῶν ὧν χρείαν ἔχετε, πρὸ τοῦ ὑμᾶς αἰτῆσαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Οὕτως οὖν προσεύχεσθε ὑμεῖς· Πάτερ ἡμῶν ὁ ἐν τοῖς οὐρανοῖς, ἁγιασθήτω τὸ ὄνομά σου. ");
INSERT INTO grctr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ἐλθέτω ἡ βασιλεία σου. Γενηθήτω τὸ θέλημά σου, ὡς ἐν οὐρανῷ, καὶ ἐπὶ τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Τὸν ἄρτον ἡμῶν τὸν ἐπιούσιον δὸς ἡμῖν σήμερον. ");
INSERT INTO grctr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Καὶ ἄφες ἡμῖν τὰ ὀφειλήματα ἡμῶν, ὡς καὶ ἡμεῖς ἀφίεμεν τοῖς ὀφειλέταις ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Καὶ μὴ εἰσενέγκῃς ἡμᾶς εἰς πειρασμόν, ἀλλὰ ῥῦσαι ἡμᾶς ἀπὸ τοῦ πονηροῦ. Ὅτι σοῦ ἐστιν ἡ βασιλεία καὶ ἡ δύναμις καὶ ἡ δόξα εἰς τοὺς αἰῶνας. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ἐὰν γὰρ ἀφῆτε τοῖς ἀνθρώποις τὰ παραπτώματα αὐτῶν, ἀφήσει καὶ ὑμῖν ὁ πατὴρ ὑμῶν ὁ οὐράνιος· ");
INSERT INTO grctr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ἐὰν δὲ μὴ ἀφῆτε τοῖς ἀνθρώποις τὰ παραπτώματα αὐτῶν, οὐδὲ ὁ πατὴρ ὑμῶν ἀφήσει τὰ παραπτώματα ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ὅταν δὲ νηστεύητε, μὴ γίνεσθε ὥσπερ οἱ ὑποκριταὶ σκυθρωποί· ἀφανίζουσι γὰρ τὰ πρόσωπα αὐτῶν, ὅπως φανῶσι τοῖς ἀνθρώποις νηστεύοντες· ἀμὴν λέγω ὑμῖν ὅτι ἀπέχουσι τὸν μισθὸν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Σὺ δὲ νηστεύων ἄλειψαί σου τὴν κεφαλήν, καὶ τὸ πρόσωπόν σου νίψαι, ");
INSERT INTO grctr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ὅπως μὴ φανῇς τοῖς ἀνθρώποις νηστεύων, ἀλλὰ τῷ πατρί σου τῷ ἐν τῷ κρυπτῷ· καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ κρυπτῷ ἀποδώσει σοι ἐν τῷ φανερῷ. ");
INSERT INTO grctr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Μὴ θησαυρίζετε ὑμῖν θησαυροὺς ἐπὶ τῆς γῆς, ὅπου σὴς καὶ βρῶσις ἀφανίζει, καὶ ὅπου κλέπται διορύσσουσι καὶ κλέπτουσι· ");
INSERT INTO grctr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","θησαυρίζετε δὲ ὑμῖν θησαυροὺς ἐν οὐρανῷ, ὅπου οὔτε σὴς οὔτε βρῶσις ἀφανίζει, καὶ ὅπου κλέπται οὐ διορύσσουσιν οὐδὲ κλέπτουσιν. ");
INSERT INTO grctr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ὅπου γάρ ἐστιν ὁ θησαυρὸς ὑμῶν, ἐκεῖ ἔσται καὶ ἡ καρδία ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ὁ λύχνος τοῦ σώματός ἐστιν ὁ ὀφθαλμός· ἐὰν οὖν ὁ ὀφθαλμός σου ἁπλοῦς ᾖ, ὅλον τὸ σῶμά σου φωτεινὸν ἔσται· ");
INSERT INTO grctr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ἐὰν δὲ ὁ ὀφθαλμός σου πονηρὸς ᾖ, ὅλον τὸ σῶμά σου σκοτεινὸν ἔσται. Εἰ οὖν τὸ φῶς τὸ ἐν σοὶ σκότος ἐστί, τὸ σκότος πόσον; ");
INSERT INTO grctr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Οὐδεὶς δύναται δυσὶ κυρίοις δουλεύειν· ἢ γὰρ τὸν ἕνα μισήσει, καὶ τὸν ἕτερον ἀγαπήσει· ἢ ἑνὸς ἀνθέξεται, καὶ τοῦ ἑτέρου καταφρονήσει. Οὐ δύνασθε Θεῷ δουλεύειν καὶ μαμμωνᾷ. ");
INSERT INTO grctr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Διὰ τοῦτο λέγω ὑμῖν, μὴ μεριμνᾶτε τῇ ψυχῇ ὑμῶν, τί φάγητε καὶ τί πίητε· μηδὲ τῷ σώματι ὑμῶν, τί ἐνδύσησθε. Οὐχὶ ἡ ψυχὴ πλεῖόν ἐστι τῆς τροφῆς, καὶ τὸ σῶμα τοῦ ἐνδύματος; ");
INSERT INTO grctr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ἐμβλέψατε εἰς τὰ πετεινὰ τοῦ οὐρανοῦ, ὅτι οὐ σπείρουσιν, οὐδὲ θερίζουσιν, οὐδὲ συνάγουσιν εἰς ἀποθήκας, καὶ ὁ πατὴρ ὑμῶν ὁ οὐράνιος τρέφει αὐτά· οὐχ ὑμεῖς μᾶλλον διαφέρετε αὐτῶν; ");
INSERT INTO grctr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Τίς δὲ ἐξ ὑμῶν μεριμνῶν δύναται προσθεῖναι ἐπὶ τὴν ἡλικίαν αὐτοῦ πῆχυν ἕνα; ");
INSERT INTO grctr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Καὶ περὶ ἐνδύματος τί μεριμνᾶτε; Καταμάθετε τὰ κρίνα τοῦ ἀγροῦ, πῶς αὐξάνει· οὐ κοπιᾷ, οὐδὲ νήθει· ");
INSERT INTO grctr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","λέγω δὲ ὑμῖν ὅτι οὐδὲ Σολομὼν ἐν πάσῃ τῇ δόξῃ αὐτοῦ περιεβάλετο ὡς ἓν τούτων. ");
INSERT INTO grctr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Εἰ δὲ τὸν χόρτον τοῦ ἀγροῦ, σήμερον ὄντα, καὶ αὔριον εἰς κλίβανον βαλλόμενον, ὁ Θεὸς οὕτως ἀμφιέννυσιν, οὐ πολλῷ μᾶλλον ὑμᾶς, ὀλιγόπιστοι; ");
INSERT INTO grctr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Μὴ οὖν μεριμνήσητε, λέγοντες, Τί φάγωμεν, ἢ τί πίωμεν, ἢ τί περιβαλώμεθα; ");
INSERT INTO grctr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Πάντα γὰρ ταῦτα τὰ ἔθνη ἐπιζητεῖ· οἶδε γὰρ ὁ πατὴρ ὑμῶν ὁ οὐράνιος ὅτι χρῄζετε τούτων ἁπάντων. ");
INSERT INTO grctr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ζητεῖτε δὲ πρῶτον τὴν βασιλείαν τοῦ Θεοῦ καὶ τὴν δικαιοσύνην αὐτοῦ, καὶ ταῦτα πάντα προστεθήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Μὴ οὖν μεριμνήσητε εἰς τὴν αὔριον· ἡ γὰρ αὔριον μεριμνήσει τὰ ἑαυτῆς. Ἀρκετὸν τῇ ἡμέρᾳ ἡ κακία αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Μὴ κρίνετε, ἵνα μὴ κριθῆτε· ");
INSERT INTO grctr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ἐν ᾧ γὰρ κρίματι κρίνετε, κριθήσεσθε· καὶ ἐν ᾧ μέτρῳ μετρεῖτε, ἀντιμετρηθήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Τί δὲ βλέπεις τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου, τὴν δὲ ἐν τῷ σῷ ὀφθαλμῷ δοκὸν οὐ κατανοεῖς; ");
INSERT INTO grctr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ἢ πῶς ἐρεῖς τῷ ἀδελφῷ σου, Ἄφες ἐκβάλω τὸ κάρφος ἀπὸ τοῦ ὀφθαλμοῦ σου· καὶ ἰδού, ἡ δοκὸς ἐν τῷ ὀφθαλμῷ σου; ");
INSERT INTO grctr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ὑποκριτά, ἔκβαλε πρῶτον τὴν δοκὸν ἐκ τοῦ ὀφθαλμοῦ σου, καὶ τότε διαβλέψεις ἐκβαλεῖν τὸ κάρφος ἐκ τοῦ ὀφθαλμοῦ τοῦ ἀδελφοῦ σου. ");
INSERT INTO grctr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Μὴ δῶτε τὸ ἅγιον τοῖς κυσί· μηδὲ βάλητε τοὺς μαργαρίτας ὑμῶν ἔμπροσθεν τῶν χοίρων, μήποτε καταπατήσωσιν αὐτοὺς ἐν τοῖς ποσὶν αὐτῶν, καὶ στραφέντες ῥήξωσιν ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Αἰτεῖτε, καὶ δοθήσεται ὑμῖν· ζητεῖτε, καὶ εὑρήσετε· κρούετε, καὶ ἀνοιγήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Πᾶς γὰρ ὁ αἰτῶν λαμβάνει, καὶ ὁ ζητῶν εὑρίσκει, καὶ τῷ κρούοντι ἀνοιγήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ἢ τίς ἐστιν ἐξ ὑμῶν ἄνθρωπος, ὃν ἐὰν αἰτήσῃ ὁ υἱὸς αὐτοῦ ἄρτον, μὴ λίθον ἐπιδώσει αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Καὶ ἐὰν ἰχθὺν αἰτήσῃ, μὴ ὄφιν ἐπιδώσει αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Εἰ οὖν ὑμεῖς, πονηροὶ ὄντες, οἴδατε δόματα ἀγαθὰ διδόναι τοῖς τέκνοις ὑμῶν, πόσῳ μᾶλλον ὁ πατὴρ ὑμῶν ὁ ἐν τοῖς οὐρανοῖς δώσει ἀγαθὰ τοῖς αἰτοῦσιν αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Πάντα οὖν ὅσα ἂν θέλητε ἵνα ποιῶσιν ὑμῖν οἱ ἄνθρωποι, οὕτω καὶ ὑμεῖς ποιεῖτε αὐτοῖς· οὗτος γάρ ἐστιν ὁ νόμος καὶ οἱ προφῆται. ");
INSERT INTO grctr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Εἰσέλθετε διὰ τῆς στενῆς πύλης· ὅτι πλατεῖα ἡ πύλη, καὶ εὐρύχωρος ἡ ὁδὸς ἡ ἀπάγουσα εἰς τὴν ἀπώλειαν, καὶ πολλοί εἰσιν οἱ εἰσερχόμενοι δι᾿ αὐτῆς· ");
INSERT INTO grctr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ὅτι στενὴ ἡ πύλη, καὶ τεθλιμμένη ἡ ὁδὸς ἡ ἀπάγουσα εἰς τὴν ζωήν, καὶ ὀλίγοι εἰσὶν οἱ εὑρίσκοντες αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Προσέχετε δὲ ἀπὸ τῶν ψευδοπροφητῶν, οἵτινες ἔρχονται πρὸς ὑμᾶς ἐν ἐνδύμασι προβάτων, ἔσωθεν δέ εἰσι λύκοι ἅρπαγες. ");
INSERT INTO grctr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ἀπὸ τῶν καρπῶν αὐτῶν ἐπιγνώσεσθε αὐτούς· μήτι συλλέγουσιν ἀπὸ ἀκανθῶν σταφυλήν, ἢ ἀπὸ τριβόλων σῦκα; ");
INSERT INTO grctr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Οὕτω πᾶν δένδρον ἀγαθὸν καρποὺς καλοὺς ποιεῖ· τὸ δὲ σαπρὸν δένδρον καρποὺς πονηροὺς ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Οὐ δύναται δένδρον ἀγαθὸν καρποὺς πονηροὺς ποιεῖν, οὐδὲ δένδρον σαπρὸν καρποὺς καλοὺς ποιεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Πᾶν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grctr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ἄρα γε ἀπὸ τῶν καρπῶν αὐτῶν ἐπιγνώσεσθε αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Οὐ πᾶς ὁ λέγων μοι, Κύριε, Κύριε, εἰσελεύσεται εἰς τὴν βασιλείαν τῶν οὐρανῶν· ἀλλ᾿ ὁ ποιῶν τὸ θέλημα τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Πολλοὶ ἐροῦσί μοι ἐν ἐκείνῃ τῇ ἡμέρᾳ, Κύριε, Κύριε, οὐ τῷ σῷ ὀνόματι προεφητεύσαμεν, καὶ τῷ σῷ ὀνόματι δαιμόνια ἐξεβάλομεν, καὶ τῷ σῷ ὀνόματι δυνάμεις πολλὰς ἐποιήσαμεν; ");
INSERT INTO grctr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Καὶ τότε ὁμολογήσω αὐτοῖς ὅτι Οὐδέποτε ἔγνων ὑμᾶς· ἀποχωρεῖτε ἀπ᾿ ἐμοῦ οἱ ἐργαζόμενοι τὴν ἀνομίαν. ");
INSERT INTO grctr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Πᾶς οὖν ὅστις ἀκούει μου τοὺς λόγους τούτους καὶ ποιεῖ αὐτούς, ὁμοιώσω αὐτὸν ἀνδρὶ φρονίμῳ, ὅστις ᾠκοδόμησε τὴν οἰκίαν αὐτοῦ ἐπὶ τὴν πέτραν· ");
INSERT INTO grctr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","καὶ κατέβη ἡ βροχὴ καὶ ἦλθον οἱ ποταμοὶ καὶ ἔπνευσαν οἱ ἄνεμοι, καὶ προσέπεσον τῇ οἰκίᾳ ἐκείνῃ, καὶ οὐκ ἔπεσε· τεθεμελίωτο γὰρ ἐπὶ τὴν πέτραν. ");
INSERT INTO grctr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Καὶ πᾶς ὁ ἀκούων μου τοὺς λόγους τούτους καὶ μὴ ποιῶν αὐτούς, ὁμοιωθήσεται ἀνδρὶ μωρῷ, ὅστις ᾠκοδόμησε τὴν οἰκίαν αὐτοῦ ἐπὶ τὴν ἄμμον· ");
INSERT INTO grctr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","καὶ κατέβη ἡ βροχὴ καὶ ἦλθον οἱ ποταμοὶ καὶ ἔπνευσαν οἱ ἄνεμοι, καὶ προσέκοψαν τῇ οἰκίᾳ ἐκείνῃ, καὶ ἔπεσε· καὶ ἦν ἡ πτῶσις αὐτῆς μεγάλη. ");
INSERT INTO grctr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Καὶ ἐγένετο ὅτε συνετέλεσεν ὁ Ἰησοῦς τοὺς λόγους τούτους, ἐξεπλήσσοντο οἱ ὄχλοι ἐπὶ τῇ διδαχῇ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ἦν γὰρ διδάσκων αὐτοὺς ὡς ἐξουσίαν ἔχων, καὶ οὐχ ὡς οἱ γραμματεῖς. ");
INSERT INTO grctr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Καταβάντι δὲ αὐτῷ ἀπὸ τοῦ ὄρους, ἠκολούθησαν αὐτῷ ὄχλοι πολλοί· ");
INSERT INTO grctr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","καὶ ἰδού, λεπρὸς ἐλθὼν προσεκύνει αὐτῷ, λέγων, Κύριε, ἐὰν θέλῃς, δύνασαί με καθαρίσαι. ");
INSERT INTO grctr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Καὶ ἐκτείνας τὴν χεῖρα, ἥψατο αὐτοῦ ὁ Ἰησοῦς, λέγων, Θέλω, καθαρίσθητι. Καὶ εὐθέως ἐκαθαρίσθη αὐτοῦ ἡ λέπρα. ");
INSERT INTO grctr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Καὶ λέγει αὐτῷ ὁ Ἰησοῦς, Ὅρα μηδενὶ εἴπῃς· ἀλλ᾿ ὕπαγε, σεαυτὸν δεῖξον τῷ ἱερεῖ, καὶ προσένεγκε τὸ δῶρον ὃ προσέταξε Μωσῆς, εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Εἰσελθόντι δὲ τῷ Ἰησοῦ εἰς Καπερναούμ, προσῆλθεν αὐτῷ ἑκατόνταρχος παρακαλῶν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","καὶ λέγων, Κύριε, ὁ παῖς μου βέβληται ἐν τῇ οἰκίᾳ παραλυτικός, δεινῶς βασανιζόμενος. ");
INSERT INTO grctr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Καὶ λέγει αὐτῷ ὁ Ἰησοῦς, Ἐγὼ ἐλθὼν θεραπεύσω αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Καὶ ἀποκριθεὶς ὁ ἑκατόνταρχος ἔφη, Κύριε, οὐκ εἰμὶ ἱκανὸς ἵνα μου ὑπὸ τὴν στέγην εἰσέλθῃς· ἀλλὰ μόνον εἰπὲ λόγον, καὶ ἰαθήσεται ὁ παῖς μου. ");
INSERT INTO grctr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Καὶ γὰρ ἐγὼ ἄνθρωπός εἰμι ὑπὸ ἐξουσίαν, ἔχων ὑπ᾿ ἐμαυτὸν στρατιώτας· καὶ λέγω τούτῳ, Πορεύθητι, καὶ πορεύεται· καὶ ἄλλῳ, Ἔρχου, καὶ ἔρχεται· καὶ τῷ δούλῳ μου, Ποίησον τοῦτο, καὶ ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ἀκούσας δὲ ὁ Ἰησοῦς ἐθαύμασε, καὶ εἶπε τοῖς ἀκολουθοῦσιν, Ἀμὴν λέγω ὑμῖν, οὐδὲ ἐν τῷ Ἰσραὴλ τοσαύτην πίστιν εὗρον. ");
INSERT INTO grctr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Λέγω δὲ ὑμῖν ὅτι πολλοὶ ἀπὸ ἀνατολῶν καὶ δυσμῶν ἥξουσι, καὶ ἀνακλιθήσονται μετὰ Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ ἐν τῇ βασιλείᾳ τῶν οὐρανῶν· ");
INSERT INTO grctr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","οἱ δὲ υἱοὶ τῆς βασιλείας ἐκβληθήσονται εἰς τὸ σκότος τὸ ἐξώτερον· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Καὶ εἶπεν ὁ Ἰησοῦς τῷ ἑκατοντάρχῳ, Ὕπαγε, καὶ ὡς ἐπίστευσας γενηθήτω σοι. Καὶ ἰάθη ὁ παῖς αὐτοῦ ἐν τῇ ὥρᾳ ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Καὶ ἐλθὼν ὁ Ἰησοῦς εἰς τὴν οἰκίαν Πέτρου, εἶδε τὴν πενθερὰν αὐτοῦ βεβλημένην καὶ πυρέσσουσαν, ");
INSERT INTO grctr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","καὶ ἥψατο τῆς χειρὸς αὐτῆς, καὶ ἀφῆκεν αὐτὴν ὁ πυρετός· καὶ ἠγέρθη, καὶ διηκόνει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ὀψίας δὲ γενομένης προσήνεγκαν αὐτῷ δαιμονιζομένους πολλούς· καὶ ἐξέβαλε τὰ πνεύματα λόγῳ, καὶ πάντας τοὺς κακῶς ἔχοντας ἐθεράπευσεν· ");
INSERT INTO grctr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ὅπως πληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου, λέγοντος, Αὐτὸς τὰς ἀσθενείας ἡμῶν ἔλαβε, καὶ τὰς νόσους ἐβάστασεν. ");
INSERT INTO grctr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ἰδὼν δὲ ὁ Ἰησοῦς πολλοὺς ὄχλους περὶ αὐτόν, ἐκέλευσεν ἀπελθεῖν εἰς τὸ πέραν. ");
INSERT INTO grctr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Καὶ προσελθὼν εἷς γραμματεὺς εἶπεν αὐτῷ, Διδάσκαλε, ἀκολουθήσω σοι ὅπου ἐὰν ἀπέρχῃ. ");
INSERT INTO grctr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Καὶ λέγει αὐτῷ ὁ Ἰησοῦς, Αἱ ἀλώπεκες φωλεοὺς ἔχουσι, καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνώσεις· ὁ δὲ υἱὸς τοῦ ἀνθρώπου οὐκ ἔχει ποῦ τὴν κεφαλὴν κλίνῃ. ");
INSERT INTO grctr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ἕτερος δὲ τῶν μαθητῶν αὐτοῦ εἶπεν αὐτῷ, Κύριε, ἐπίτρεψόν μοι πρῶτον ἀπελθεῖν καὶ θάψαι τὸν πατέρα μου. ");
INSERT INTO grctr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Ἀκολούθει μοι, καὶ ἄφες τοὺς νεκροὺς θάψαι τοὺς ἑαυτῶν νεκρούς. ");
INSERT INTO grctr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Καὶ ἐμβάντι αὐτῷ εἰς τὸ πλοῖον, ἠκολούθησαν αὐτῷ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Καὶ ἰδού, σεισμὸς μέγας ἐγένετο ἐν τῇ θαλάσσῃ, ὥστε τὸ πλοῖον καλύπτεσθαι ὑπὸ τῶν κυμάτων· αὐτὸς δὲ ἐκάθευδε. ");
INSERT INTO grctr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Καὶ προσελθόντες οἱ μαθηταὶ αὐτοῦ ἤγειραν αὐτόν, λέγοντες, Κύριε, σῶσον ἡμᾶς, ἀπολλύμεθα. ");
INSERT INTO grctr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Καὶ λέγει αὐτοῖς, Τί δειλοί ἐστε, ὀλιγόπιστοι; Τότε ἐγερθεὶς ἐπετίμησε τοῖς ἀνέμοις καὶ τῇ θαλάσσῃ, καὶ ἐγένετο γαλήνη μεγάλη. ");
INSERT INTO grctr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Οἱ δὲ ἄνθρωποι ἐθαύμασαν, λέγοντες, Ποταπός ἐστιν οὗτος, ὅτι καὶ οἱ ἄνεμοι καὶ ἡ θάλασσα ὑπακούουσιν αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Καὶ ἐλθόντι αὐτῷ εἰς τὸ πέραν εἰς τὴν χώραν τῶν Γεργεσηνῶν, ὑπήντησαν αὐτῷ δύο δαιμονιζόμενοι ἐκ τῶν μνημείων ἐξερχόμενοι, χαλεποὶ λίαν, ὥστε μὴ ἰσχύειν τινὰ παρελθεῖν διὰ τῆς ὁδοῦ ἐκείνης· ");
INSERT INTO grctr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","καὶ ἰδού, ἔκραξαν λέγοντες, Τί ἡμῖν καὶ σοί, Ἰησοῦ υἱὲ τοῦ Θεοῦ; Ἦλθες ὧδε πρὸ καιροῦ βασανίσαι ἡμᾶς; ");
INSERT INTO grctr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ἦν δὲ μακρὰν ἀπ᾿ αὐτῶν ἀγέλη χοίρων πολλῶν βοσκομένη. ");
INSERT INTO grctr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Οἱ δὲ δαίμονες παρεκάλουν αὐτόν, λέγοντες, Εἰ ἐκβάλλεις ἡμᾶς, ἐπίτρεψον ἡμῖν ἀπελθεῖν εἰς τὴν ἀγέλην τῶν χοίρων. ");
INSERT INTO grctr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Καὶ εἶπεν αὐτοῖς, Ὑπάγετε. Οἱ δὲ ἐξελθόντες ἀπῆλθον εἰς τὴν ἀγέλην τῶν χοίρων· καὶ ἰδού, ὥρμησε πᾶσα ἡ ἀγέλη τῶν χοίρων κατὰ τοῦ κρημνοῦ εἰς τὴν θάλασσαν, καὶ ἀπέθανον ἐν τοῖς ὕδασιν. ");
INSERT INTO grctr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Οἱ δὲ βόσκοντες ἔφυγον, καὶ ἀπελθόντες εἰς τὴν πόλιν ἀπήγγειλαν πάντα, καὶ τὰ τῶν δαιμονιζομένων. ");
INSERT INTO grctr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Καὶ ἰδού, πᾶσα ἡ πόλις ἐξῆλθεν εἰς συνάντησιν τῷ Ἰησοῦ· καὶ ἰδόντες αὐτόν, παρεκάλεσαν ὅπως μεταβῇ ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Καὶ ἐμβὰς εἰς τὸ πλοῖον διεπέρασε καὶ ἦλθεν εἰς τὴν ἰδίαν πόλιν. ");
INSERT INTO grctr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Καὶ ἰδού, προσέφερον αὐτῷ παραλυτικὸν ἐπὶ κλίνης βεβλημένον· καὶ ἰδὼν ὁ Ἰησοῦς τὴν πίστιν αὐτῶν εἶπε τῷ παραλυτικῷ, Θάρσει, τέκνον· ἀφέωνταί σοι αἱ ἁμαρτίαι σου. ");
INSERT INTO grctr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Καὶ ἰδού, τινὲς τῶν γραμματέων εἶπον ἐν ἑαυτοῖς, Οὗτος βλασφημεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Καὶ ἰδὼν ὁ Ἰησοῦς τὰς ἐνθυμήσεις αὐτῶν εἶπεν, Ἵνα τί ὑμεῖς ἐνθυμεῖσθε πονηρὰ ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Τί γάρ ἐστιν εὐκοπώτερον, εἰπεῖν, Ἀφέωνταί σοι αἱ ἁμαρτίαι· ἢ εἰπεῖν, Ἔγειραι καὶ περιπάτει; ");
INSERT INTO grctr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ἵνα δὲ εἰδῆτε, ὅτι ἐξουσίαν ἔχει ὁ υἱὸς τοῦ ἀνθρώπου ἐπὶ τῆς γῆς ἀφιέναι ἁμαρτίας — τότε λέγει τῷ παραλυτικῷ — Ἐγερθεὶς ἆρόν σου τὴν κλίνην, καὶ ὕπαγε εἰς τὸν οἶκόν σου. ");
INSERT INTO grctr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Καὶ ἐγερθεὶς ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ἰδόντες δὲ οἱ ὄχλοι ἐθαύμασαν, καὶ ἐδόξασαν τὸν Θεόν, τὸν δόντα ἐξουσίαν τοιαύτην τοῖς ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Καὶ παράγων ὁ Ἰησοῦς ἐκεῖθεν εἶδεν ἄνθρωπον καθήμενον ἐπὶ τὸ τελώνιον, Ματθαῖον λεγόμενον, καὶ λέγει αὐτῷ, Ἀκολούθει μοι. Καὶ ἀναστὰς ἠκολούθησεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Καὶ ἐγένετο αὐτοῦ ἀνακειμένου ἐν τῇ οἰκίᾳ, καὶ ἰδού, πολλοὶ τελῶναι καὶ ἁμαρτωλοὶ ἐλθόντες συνανέκειντο τῷ Ἰησοῦ καὶ τοῖς μαθηταῖς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Καὶ ἰδόντες οἱ Φαρισαῖοι εἶπον τοῖς μαθηταῖς αὐτοῦ, Διὰ τί μετὰ τῶν τελωνῶν καὶ ἁμαρτωλῶν ἐσθίει ὁ διδάσκαλος ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ὁ δὲ Ἰησοῦς ἀκούσας εἶπεν αὐτοῖς, Οὐ χρείαν ἔχουσιν οἱ ἰσχύοντες ἰατροῦ, ἀλλ᾿ οἱ κακῶς ἔχοντες. ");
INSERT INTO grctr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Πορευθέντες δὲ μάθετε τί ἐστιν, Ἔλεον θέλω, καὶ οὐ θυσίαν· οὐ γὰρ ἦλθον καλέσαι δικαίους, ἀλλ᾿ ἁμαρτωλοὺς εἰς μετάνοιαν. ");
INSERT INTO grctr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Τότε προσέρχονται αὐτῷ οἱ μαθηταὶ Ἰωάννου, λέγοντες, Διὰ τί ἡμεῖς καὶ οἱ Φαρισαῖοι νηστεύομεν πολλά, οἱ δὲ μαθηταί σου οὐ νηστεύουσι; ");
INSERT INTO grctr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς, Μὴ δύνανται οἱ υἱοὶ τοῦ νυμφῶνος πενθεῖν, ἐφ᾿ ὅσον μετ᾿ αὐτῶν ἐστιν ὁ νυμφίος; Ἐλεύσονται δὲ ἡμέραι ὅταν ἀπαρθῇ ἀπ᾿ αὐτῶν ὁ νυμφίος, καὶ τότε νηστεύσουσιν. ");
INSERT INTO grctr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Οὐδεὶς δὲ ἐπιβάλλει ἐπίβλημα ῥάκους ἀγνάφου ἐπὶ ἱματίῳ παλαιῷ· αἴρει γὰρ τὸ πλήρωμα αὐτοῦ ἀπὸ τοῦ ἱματίου, καὶ χεῖρον σχίσμα γίνεται. ");
INSERT INTO grctr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Οὐδὲ βάλλουσιν οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μήγε, ῥήγνυνται οἱ ἀσκοί, καὶ ὁ οἶνος ἐκχεῖται, καὶ οἱ ἀσκοὶ ἀπολοῦνται· ἀλλὰ βάλλουσιν οἶνον νέον εἰς ἀσκοὺς καινούς, καὶ ἀμφότερα συντηροῦνται. ");
INSERT INTO grctr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ταῦτα αὐτοῦ λαλοῦντος αὐτοῖς, ἰδού, ἄρχων ἐλθὼν προσεκύνει αὐτῷ, λέγων ὅτι Ἡ θυγάτηρ μου ἄρτι ἐτελεύτησεν· ἀλλὰ ἐλθὼν ἐπίθες τὴν χεῖρά σου ἐπ᾿ αὐτήν, καὶ ζήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Καὶ ἐγερθεὶς ὁ Ἰησοῦς ἠκολούθησεν αὐτῷ καὶ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Καὶ ἰδού, γυνὴ αἱμορροοῦσα δώδεκα ἔτη, προσελθοῦσα ὄπισθεν, ἥψατο τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ἔλεγε γὰρ ἐν ἑαυτῇ, Ἐὰν μόνον ἅψωμαι τοῦ ἱματίου αὐτοῦ, σωθήσομαι. ");
INSERT INTO grctr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ὁ δὲ Ἰησοῦς ἐπιστραφεὶς καὶ ἰδὼν αὐτὴν εἶπε, Θάρσει, θύγατερ· ἡ πίστις σου σέσωκέ σε. Καὶ ἐσώθη ἡ γυνὴ ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grctr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Καὶ ἐλθὼν ὁ Ἰησοῦς εἰς τὴν οἰκίαν τοῦ ἄρχοντος, καὶ ἰδὼν τοὺς αὐλητὰς καὶ τὸν ὄχλον θορυβούμενον, ");
INSERT INTO grctr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","λέγει αὐτοῖς, Ἀναχωρεῖτε· οὐ γὰρ ἀπέθανε τὸ κοράσιον, ἀλλὰ καθεύδει. Καὶ κατεγέλων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ὅτε δὲ ἐξεβλήθη ὁ ὄχλος, εἰσελθὼν ἐκράτησε τῆς χειρὸς αὐτῆς, καὶ ἠγέρθη τὸ κοράσιον. ");
INSERT INTO grctr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Καὶ ἐξῆλθεν ἡ φήμη αὕτη εἰς ὅλην τὴν γῆν ἐκείνην. ");
INSERT INTO grctr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Καὶ παράγοντι ἐκεῖθεν τῷ Ἰησοῦ, ἠκολούθησαν αὐτῷ δύο τυφλοί, κράζοντες καὶ λέγοντες, Ἐλέησον ἡμᾶς, υἱὲ Δαβίδ. ");
INSERT INTO grctr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ἐλθόντι δὲ εἰς τὴν οἰκίαν, προσῆλθον αὐτῷ οἱ τυφλοί, καὶ λέγει αὐτοῖς ὁ Ἰησοῦς, Πιστεύετε ὅτι δύναμαι τοῦτο ποιῆσαι; Λέγουσιν αὐτῷ, Ναί, Κύριε. ");
INSERT INTO grctr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Τότε ἥψατο τῶν ὀφθαλμῶν αὐτῶν, λέγων, Κατὰ τὴν πίστιν ὑμῶν γενηθήτω ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Καὶ ἀνεῴχθησαν αὐτῶν οἱ ὀφθαλμοί· καὶ ἐνεβριμήσατο αὐτοῖς ὁ Ἰησοῦς, λέγων, Ὁρᾶτε μηδεὶς γινωσκέτω. ");
INSERT INTO grctr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Οἱ δὲ ἐξελθόντες διεφήμισαν αὐτὸν ἐν ὅλῃ τῇ γῇ ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Αὐτῶν δὲ ἐξερχομένων, ἰδού, προσήνεγκαν αὐτῷ ἄνθρωπον κωφὸν δαιμονιζόμενον. ");
INSERT INTO grctr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Καὶ ἐκβληθέντος τοῦ δαιμονίου, ἐλάλησεν ὁ κωφός· καὶ ἐθαύμασαν οἱ ὄχλοι, λέγοντες ὅτι Οὐδέποτε ἐφάνη οὕτως ἐν τῷ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Οἱ δὲ Φαρισαῖοι ἔλεγον, Ἐν τῷ ἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια. ");
INSERT INTO grctr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Καὶ περιῆγεν ὁ Ἰησοῦς τὰς πόλεις πάσας καὶ τὰς κώμας, διδάσκων ἐν ταῖς συναγωγαῖς αὐτῶν, καὶ κηρύσσων τὸ εὐαγγέλιον τῆς βασιλείας, καὶ θεραπεύων πᾶσαν νόσον καὶ πᾶσαν μαλακίαν ἐν τῷ λαῷ. ");
INSERT INTO grctr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ἰδὼν δὲ τοὺς ὄχλους, ἐσπλαγχνίσθη περὶ αὐτῶν, ὅτι ἦσαν ἐκλελυμένοι καὶ ἐρριμμένοι ὡσεὶ πρόβατα μὴ ἔχοντα ποιμένα. ");
INSERT INTO grctr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Τότε λέγει τοῖς μαθηταῖς αὐτοῦ, Ὁ μὲν θερισμὸς πολύς, οἱ δὲ ἐργάται ὀλίγοι· ");
INSERT INTO grctr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","δεήθητε οὖν τοῦ Κυρίου τοῦ θερισμοῦ, ὅπως ἐκβάλῃ ἐργάτας εἰς τὸν θερισμὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Καὶ προσκαλεσάμενος τοὺς δώδεκα μαθητὰς αὐτοῦ, ἔδωκεν αὐτοῖς ἐξουσίαν πνευμάτων ἀκαθάρτων, ὥστε ἐκβάλλειν αὐτά, καὶ θεραπεύειν πᾶσαν νόσον καὶ πᾶσαν μαλακίαν. ");
INSERT INTO grctr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Τῶν δὲ δώδεκα ἀποστόλων τὰ ὀνόματά ἐστι ταῦτα· πρῶτος Σίμων ὁ λεγόμενος Πέτρος, καὶ Ἀνδρέας ὁ ἀδελφὸς αὐτοῦ· Ἰάκωβος ὁ τοῦ Ζεβεδαίου, καὶ Ἰωάννης ὁ ἀδελφὸς αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Φίλιππος, καὶ Βαρθολομαῖος· Θωμᾶς, καὶ Ματθαῖος ὁ τελώνης· Ἰάκωβος ὁ τοῦ Ἀλφαίου, καὶ Λεββαῖος ὁ ἐπικληθεὶς Θαδδαῖος· ");
INSERT INTO grctr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Σίμων ὁ Κανανίτης, καὶ Ἰούδας Ἰσκαριώτης ὁ καὶ παραδοὺς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Τούτους τοὺς δώδεκα ἀπέστειλεν ὁ Ἰησοῦς, παραγγείλας αὐτοῖς, λέγων, Εἰς ὁδὸν ἐθνῶν μὴ ἀπέλθητε, καὶ εἰς πόλιν Σαμαρειτῶν μὴ εἰσέλθητε· ");
INSERT INTO grctr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","πορεύεσθε δὲ μᾶλλον πρὸς τὰ πρόβατα τὰ ἀπολωλότα οἴκου Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Πορευόμενοι δὲ κηρύσσετε, λέγοντες ὅτι Ἤγγικεν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ἀσθενοῦντας θεραπεύετε, λεπροὺς καθαρίζετε, νεκροὺς ἐγείρετε, δαιμόνια ἐκβάλλετε· δωρεὰν ἐλάβετε, δωρεὰν δότε. ");
INSERT INTO grctr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Μὴ κτήσησθε χρυσόν, μηδὲ ἄργυρον, μηδὲ χαλκὸν εἰς τὰς ζώνας ὑμῶν, ");
INSERT INTO grctr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","μὴ πήραν εἰς ὁδόν, μηδὲ δύο χιτῶνας, μηδὲ ὑποδήματα, μηδὲ ῥάβδον· ἄξιος γὰρ ὁ ἐργάτης τῆς τροφῆς αὐτοῦ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Εἰς ἣν δ᾿ ἂν πόλιν ἢ κώμην εἰσέλθητε, ἐξετάσατε τίς ἐν αὐτῇ ἄξιός ἐστι· κἀκεῖ μείνατε, ἕως ἂν ἐξέλθητε. ");
INSERT INTO grctr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Εἰσερχόμενοι δὲ εἰς τὴν οἰκίαν, ἀσπάσασθε αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Καὶ ἐὰν μὲν ᾖ ἡ οἰκία ἀξία, ἐλθέτω ἡ εἰρήνη ὑμῶν ἐπ᾿ αὐτήν· ἐὰν δὲ μὴ ᾖ ἀξία, ἡ εἰρήνη ὑμῶν πρὸς ὑμᾶς ἐπιστραφήτω. ");
INSERT INTO grctr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Καὶ ὃς ἐὰν μὴ δέξηται ὑμᾶς μηδὲ ἀκούσῃ τοὺς λόγους ὑμῶν, ἐξερχόμενοι τῆς οἰκίας ἢ τῆς πόλεως ἐκείνης, ἐκτινάξατε τὸν κονιορτὸν τῶν ποδῶν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ἀμὴν λέγω ὑμῖν, ἀνεκτότερον ἔσται γῇ Σοδόμων καὶ Γομόρρων ἐν ἡμέρᾳ κρίσεως, ἢ τῇ πόλει ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ἰδού, ἐγὼ ἀποστέλλω ὑμᾶς ὡς πρόβατα ἐν μέσῳ λύκων· γίνεσθε οὖν φρόνιμοι ὡς οἱ ὄφεις, καὶ ἀκέραιοι ὡς αἱ περιστεραί. ");
INSERT INTO grctr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Προσέχετε δὲ ἀπὸ τῶν ἀνθρώπων· παραδώσουσι γὰρ ὑμᾶς εἰς συνέδρια, καὶ ἐν ταῖς συναγωγαῖς αὐτῶν μαστιγώσουσιν ὑμᾶς· ");
INSERT INTO grctr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","καὶ ἐπὶ ἡγεμόνας δὲ καὶ βασιλεῖς ἀχθήσεσθε ἕνεκεν ἐμοῦ, εἰς μαρτύριον αὐτοῖς καὶ τοῖς ἔθνεσιν. ");
INSERT INTO grctr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ὅταν δὲ παραδιδῶσιν ὑμᾶς, μὴ μεριμνήσητε πῶς ἢ τί λαλήσητε· δοθήσεται γὰρ ὑμῖν ἐν ἐκείνῃ τῇ ὥρᾳ τί λαλήσετε· ");
INSERT INTO grctr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","οὐ γὰρ ὑμεῖς ἐστὲ οἱ λαλοῦντες, ἀλλὰ τὸ πνεῦμα τοῦ πατρὸς ὑμῶν τὸ λαλοῦν ἐν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Παραδώσει δὲ ἀδελφὸς ἀδελφὸν εἰς θάνατον, καὶ πατὴρ τέκνον· καὶ ἐπαναστήσονται τέκνα ἐπὶ γονεῖς, καὶ θανατώσουσιν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου· ὁ δὲ ὑπομείνας εἰς τέλος, οὗτος σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ὅταν δὲ διώκωσιν ὑμᾶς ἐν τῇ πόλει ταύτῃ, φεύγετε εἰς τὴν ἄλλην· ἀμὴν γὰρ λέγω ὑμῖν, οὐ μὴ τελέσητε τὰς πόλεις τοῦ Ἰσραήλ, ἕως ἂν ἔλθῃ ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Οὐκ ἔστι μαθητὴς ὑπὲρ τὸν διδάσκαλον, οὐδὲ δοῦλος ὑπὲρ τὸν κύριον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ἀρκετὸν τῷ μαθητῇ ἵνα γένηται ὡς ὁ διδάσκαλος αὐτοῦ, καὶ ὁ δοῦλος ὡς ὁ κύριος αὐτοῦ. Εἰ τὸν οἰκοδεσπότην Βεελζεβοὺλ ἐκάλεσαν, πόσῳ μᾶλλον τοὺς οἰκιακοὺς αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Μὴ οὖν φοβηθῆτε αὐτούς· οὐδὲν γάρ ἐστι κεκαλυμμένον ὃ οὐκ ἀποκαλυφθήσεται, καὶ κρυπτὸν ὃ οὐ γνωσθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ὃ λέγω ὑμῖν ἐν τῇ σκοτίᾳ, εἴπατε ἐν τῷ φωτί· καὶ ὃ εἰς τὸ οὖς ἀκούετε, κηρύξατε ἐπὶ τῶν δωμάτων. ");
INSERT INTO grctr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Καὶ μὴ φοβηθῆτε ἀπὸ τῶν ἀποκτεινόντων τὸ σῶμα, τὴν δὲ ψυχὴν μὴ δυναμένων ἀποκτεῖναι· φοβήθητε δὲ μᾶλλον τὸν δυνάμενον καὶ ψυχὴν καὶ σῶμα ἀπολέσαι ἐν γεέννῃ. ");
INSERT INTO grctr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Οὐχὶ δύο στρουθία ἀσσαρίου πωλεῖται; Καὶ ἓν ἐξ αὐτῶν οὐ πεσεῖται ἐπὶ τὴν γῆν ἄνευ τοῦ πατρὸς ὑμῶν· ");
INSERT INTO grctr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ὑμῶν δὲ καὶ αἱ τρίχες τῆς κεφαλῆς πᾶσαι ἠριθμημέναι εἰσί. ");
INSERT INTO grctr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Μὴ οὖν φοβηθῆτε· πολλῶν στρουθίων διαφέρετε ὑμεῖς. ");
INSERT INTO grctr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Πᾶς οὖν ὅστις ὁμολογήσει ἐν ἐμοὶ ἔμπροσθεν τῶν ἀνθρώπων, ὁμολογήσω κἀγὼ ἐν αὐτῷ ἔμπροσθεν τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ὅστις δ᾿ ἂν ἀρνήσηταί με ἔμπροσθεν τῶν ἀνθρώπων, ἀρνήσομαι αὐτὸν κἀγὼ ἔμπροσθεν τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Μὴ νομίσητε ὅτι ἦλθον βαλεῖν εἰρήνην ἐπὶ τὴν γῆν· οὐκ ἦλθον βαλεῖν εἰρήνην, ἀλλὰ μάχαιραν. ");
INSERT INTO grctr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ἦλθον γὰρ διχάσαι ἄνθρωπον κατὰ τοῦ πατρὸς αὐτοῦ, καὶ θυγατέρα κατὰ τῆς μητρὸς αὐτῆς, καὶ νύμφην κατὰ τῆς πενθερᾶς αὐτῆς· ");
INSERT INTO grctr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","καὶ ἐχθροὶ τοῦ ἀνθρώπου οἱ οἰκιακοὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ὁ φιλῶν πατέρα ἢ μητέρα ὑπὲρ ἐμέ, οὐκ ἔστι μου ἄξιος· καὶ ὁ φιλῶν υἱὸν ἢ θυγατέρα ὑπὲρ ἐμέ, οὐκ ἔστι μου ἄξιος· ");
INSERT INTO grctr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","καὶ ὃς οὐ λαμβάνει τὸν σταυρὸν αὐτοῦ καὶ ἀκολουθεῖ ὀπίσω μου, οὐκ ἔστι μου ἄξιος. ");
INSERT INTO grctr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ὁ εὑρὼν τὴν ψυχὴν αὐτοῦ ἀπολέσει αὐτήν· καὶ ὁ ἀπολέσας τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ εὑρήσει αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ὁ δεχόμενος ὑμᾶς ἐμὲ δέχεται· καὶ ὁ ἐμὲ δεχόμενος δέχεται τὸν ἀποστείλαντά με. ");
INSERT INTO grctr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ὁ δεχόμενος προφήτην εἰς ὄνομα προφήτου μισθὸν προφήτου λήψεται· καὶ ὁ δεχόμενος δίκαιον εἰς ὄνομα δικαίου μισθὸν δικαίου λήψεται. ");
INSERT INTO grctr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Καὶ ὃς ἐὰν ποτίσῃ ἕνα τῶν μικρῶν τούτων ποτήριον ψυχροῦ μόνον εἰς ὄνομα μαθητοῦ, ἀμὴν λέγω ὑμῖν, οὐ μὴ ἀπολέσῃ τὸν μισθὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς διατάσσων τοῖς δώδεκα μαθηταῖς αὐτοῦ, μετέβη ἐκεῖθεν τοῦ διδάσκειν καὶ κηρύσσειν ἐν ταῖς πόλεσιν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ὁ δὲ Ἰωάννης ἀκούσας ἐν τῷ δεσμωτηρίῳ τὰ ἔργα τοῦ Χριστοῦ, πέμψας δύο τῶν μαθητῶν αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","εἶπεν αὐτῷ, Σὺ εἶ ὁ ἐρχόμενος, ἢ ἕτερον προσδοκῶμεν; ");
INSERT INTO grctr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Πορευθέντες ἀπαγγείλατε Ἰωάννῃ ἃ ἀκούετε καὶ βλέπετε· ");
INSERT INTO grctr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","τυφλοὶ ἀναβλέπουσι, καὶ χωλοὶ περιπατοῦσι, λεπροὶ καθαρίζονται, καὶ κωφοὶ ἀκούουσι, νεκροὶ ἐγείρονται, καὶ πτωχοὶ εὐαγγελίζονται· ");
INSERT INTO grctr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","καὶ μακάριός ἐστιν, ὃς ἐὰν μὴ σκανδαλισθῇ ἐν ἐμοί. ");
INSERT INTO grctr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Τούτων δὲ πορευομένων, ἤρξατο ὁ Ἰησοῦς λέγειν τοῖς ὄχλοις περὶ Ἰωάννου, Τί ἐξήλθετε εἰς τὴν ἔρημον θεάσασθαι; Κάλαμον ὑπὸ ἀνέμου σαλευόμενον; ");
INSERT INTO grctr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ἀλλὰ τί ἐξήλθετε ἰδεῖν; Ἄνθρωπον ἐν μαλακοῖς ἱματίοις ἠμφιεσμένον; Ἰδού, οἱ τὰ μαλακὰ φοροῦντες ἐν τοῖς οἴκοις τῶν βασιλέων εἰσίν. ");
INSERT INTO grctr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ἀλλὰ τί ἐξήλθετε ἰδεῖν; Προφήτην; Ναί, λέγω ὑμῖν, καὶ περισσότερον προφήτου. ");
INSERT INTO grctr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Οὗτος γάρ ἐστι περὶ οὗ γέγραπται, Ἰδού, ἐγὼ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν σου ἔμπροσθέν σου. ");
INSERT INTO grctr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ἀμὴν λέγω ὑμῖν, οὐκ ἐγήγερται ἐν γεννητοῖς γυναικῶν μείζων Ἰωάννου τοῦ βαπτιστοῦ· ὁ δὲ μικρότερος ἐν τῇ βασιλείᾳ τῶν οὐρανῶν μείζων αὐτοῦ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ἀπὸ δὲ τῶν ἡμερῶν Ἰωάννου τοῦ βαπτιστοῦ ἕως ἄρτι ἡ βασιλεία τῶν οὐρανῶν βιάζεται, καὶ βιασταὶ ἁρπάζουσιν αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Πάντες γὰρ οἱ προφῆται καὶ ὁ νόμος ἕως Ἰωάννου προεφήτευσαν· ");
INSERT INTO grctr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","καὶ εἰ θέλετε δέξασθαι, αὐτός ἐστιν Ἠλίας ὁ μέλλων ἔρχεσθαι. ");
INSERT INTO grctr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Τίνι δὲ ὁμοιώσω τὴν γενεὰν ταύτην; Ὁμοία ἐστὶ παιδαρίοις ἐν ἀγοραῖς καθημένοις, καὶ προσφωνοῦσι τοῖς ἑταίροις αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","καὶ λέγουσιν, Ηὐλήσαμεν ὑμῖν, καὶ οὐκ ὠρχήσασθε· ἐθρηνήσαμεν ὑμῖν, καὶ οὐκ ἐκόψασθε. ");
INSERT INTO grctr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ἦλθε γὰρ Ἰωάννης μήτε ἐσθίων μήτε πίνων, καὶ λέγουσι, Δαιμόνιον ἔχει. ");
INSERT INTO grctr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ἦλθεν ὁ υἱὸς τοῦ ἀνθρώπου ἐσθίων καὶ πίνων, καὶ λέγουσιν, Ἰδού, ἄνθρωπος φάγος καὶ οἰνοπότης, τελωνῶν φίλος καὶ ἁμαρτωλῶν. Καὶ ἐδικαιώθη ἡ σοφία ἀπὸ τῶν τέκνων αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Τότε ἤρξατο ὀνειδίζειν τὰς πόλεις ἐν αἷς ἐγένοντο αἱ πλεῖσται δυνάμεις αὐτοῦ, ὅτι οὐ μετενόησαν. ");
INSERT INTO grctr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Οὐαί σοι, Χοραζίν, οὐαί σοι, Βηθσαϊδάν, ὅτι εἰ ἐν Τύρῳ καὶ Σιδῶνι ἐγένοντο αἱ δυνάμεις αἱ γενόμεναι ἐν ὑμῖν, πάλαι ἂν ἐν σάκκῳ καὶ σποδῷ μετενόησαν. ");
INSERT INTO grctr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Πλὴν λέγω ὑμῖν, Τύρῳ καὶ Σιδῶνι ἀνεκτότερον ἔσται ἐν ἡμέρᾳ κρίσεως, ἢ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Καὶ σύ, Καπερναούμ, ἡ ἕως τοῦ οὐρανοῦ ὑψωθεῖσα, ἕως ᾍδου καταβιβασθήσῃ· ὅτι εἰ ἐν Σοδόμοις ἐγένοντο αἱ δυνάμεις αἱ γενόμεναι ἐν σοί, ἔμειναν ἂν μέχρι τῆς σήμερον. ");
INSERT INTO grctr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Πλὴν λέγω ὑμῖν ὅτι γῇ Σοδόμων ἀνεκτότερον ἔσται ἐν ἡμέρᾳ κρίσεως, ἢ σοί. ");
INSERT INTO grctr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ἐν ἐκείνῳ τῷ καιρῷ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν, Ἐξομολογοῦμαί σοι, πάτερ, Κύριε τοῦ οὐρανοῦ καὶ τῆς γῆς, ὅτι ἀπέκρυψας ταῦτα ἀπὸ σοφῶν καὶ συνετῶν, καὶ ἀπεκάλυψας αὐτὰ νηπίοις. ");
INSERT INTO grctr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ναί, ὁ πατήρ, ὅτι οὕτως ἐγένετο εὐδοκία ἔμπροσθέν σου. ");
INSERT INTO grctr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Πάντα μοι παρεδόθη ὑπὸ τοῦ πατρός μου· καὶ οὐδεὶς ἐπιγινώσκει τὸν υἱόν, εἰ μὴ ὁ πατήρ· οὐδὲ τὸν πατέρα τις ἐπιγινώσκει, εἰ μὴ ὁ υἱός, καὶ ᾧ ἐὰν βούληται ὁ υἱὸς ἀποκαλύψαι. ");
INSERT INTO grctr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Δεῦτε πρός με πάντες οἱ κοπιῶντες καὶ πεφορτισμένοι, κἀγὼ ἀναπαύσω ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ἄρατε τὸν ζυγόν μου ἐφ᾿ ὑμᾶς καὶ μάθετε ἀπ᾿ ἐμοῦ, ὅτι πρᾷός εἰμι καὶ ταπεινὸς τῇ καρδίᾳ· καὶ εὑρήσετε ἀνάπαυσιν ταῖς ψυχαῖς ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ὁ γὰρ ζυγός μου χρηστός, καὶ τὸ φορτίον μου ἐλαφρόν ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ἐν ἐκείνῳ τῷ καιρῷ ἐπορεύθη ὁ Ἰησοῦς τοῖς σάββασι διὰ τῶν σπορίμων· οἱ δὲ μαθηταὶ αὐτοῦ ἐπείνασαν, καὶ ἤρξαντο τίλλειν στάχυας καὶ ἐσθίειν. ");
INSERT INTO grctr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Οἱ δὲ Φαρισαῖοι ἰδόντες εἶπον αὐτῷ, Ἰδού, οἱ μαθηταί σου ποιοῦσιν ὃ οὐκ ἔξεστι ποιεῖν ἐν σαββάτῳ. ");
INSERT INTO grctr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ὁ δὲ εἶπεν αὐτοῖς, Οὐκ ἀνέγνωτε τί ἐποίησε Δαβίδ, ὅτε ἐπείνασεν αὐτὸς καὶ οἱ μετ᾿ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","πῶς εἰσῆλθεν εἰς τὸν οἶκον τοῦ Θεοῦ, καὶ τοὺς ἄρτους τῆς προθέσεως ἔφαγεν, οὓς οὐκ ἐξὸν ἦν αὐτῷ φαγεῖν, οὐδὲ τοῖς μετ᾿ αὐτοῦ, εἰ μὴ τοῖς ἱερεῦσι μόνοις; ");
INSERT INTO grctr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ἢ οὐκ ἀνέγνωτε ἐν τῷ νόμῳ, ὅτι τοῖς σάββασιν οἱ ἱερεῖς ἐν τῷ ἱερῷ τὸ σάββατον βεβηλοῦσι, καὶ ἀναίτιοί εἰσι; ");
INSERT INTO grctr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Λέγω δὲ ὑμῖν ὅτι τοῦ ἱεροῦ μείζων ἐστιν ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Εἰ δὲ ἐγνώκειτε τί ἐστιν, Ἔλεον θέλω καὶ οὐ θυσίαν, οὐκ ἂν κατεδικάσατε τοὺς ἀναιτίους. ");
INSERT INTO grctr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Κύριος γάρ ἐστι καὶ τοῦ σαββάτου ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Καὶ μεταβὰς ἐκεῖθεν ἦλθεν εἰς τὴν συναγωγὴν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Καὶ ἰδού, ἄνθρωπος ἦν τὴν χεῖρα ἔχων ξηράν· καὶ ἐπηρώτησαν αὐτόν, λέγοντες, Εἰ ἔξεστι τοῖς σάββασι θεραπεύειν; ἵνα κατηγορήσωσιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ὁ δὲ εἶπεν αὐτοῖς, Τίς ἔσται ἐξ ὑμῶν ἄνθρωπος, ὃς ἕξει πρόβατον ἕν, καὶ ἐὰν ἐμπέσῃ τοῦτο τοῖς σάββασιν εἰς βόθυνον, οὐχὶ κρατήσει αὐτὸ καὶ ἐγερεῖ; ");
INSERT INTO grctr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Πόσῳ οὖν διαφέρει ἄνθρωπος προβάτου. Ὥστε ἔξεστι τοῖς σάββασι καλῶς ποιεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Τότε λέγει τῷ ἀνθρώπῳ, Ἔκτεινον τὴν χεῖρά σου. Καὶ ἐξέτεινε, καὶ ἀποκατεστάθη ὑγιὴς ὡς ἡ ἄλλη. ");
INSERT INTO grctr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Οἱ δὲ Φαρισαῖοι συμβούλιον ἔλαβον κατ᾿ αὐτοῦ ἐξελθόντες, ὅπως αὐτὸν ἀπολέσωσιν. ");
INSERT INTO grctr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ὁ δὲ Ἰησοῦς γνοὺς ἀνεχώρησεν ἐκεῖθεν· καὶ ἠκολούθησαν αὐτῷ ὄχλοι πολλοί, καὶ ἐθεράπευσεν αὐτοὺς πάντας, ");
INSERT INTO grctr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","καὶ ἐπετίμησεν αὐτοῖς, ἵνα μὴ φανερὸν αὐτὸν ποιήσωσιν· ");
INSERT INTO grctr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ὅπως πληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ἰδού, ὁ παῖς μου ὃν ᾑρέτισα· ὁ ἀγαπητός μου εἰς ὃν εὐδόκησεν ἡ ψυχή μου· θήσω τὸ πνεῦμά μου ἐπ᾿ αὐτόν, καὶ κρίσιν τοῖς ἔθνεσιν ἀπαγγελεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Οὐκ ἐρίσει, οὐδὲ κραυγάσει· οὐδὲ ἀκούσει τις ἐν ταῖς πλατείαις τὴν φωνὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Κάλαμον συντετριμμένον οὐ κατεάξει, καὶ λίνον τυφόμενον οὐ σβέσει· ἕως ἂν ἐκβάλῃ εἰς νῖκος τὴν κρίσιν. ");
INSERT INTO grctr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Καὶ ἐν τῷ ὀνόματι αὐτοῦ ἔθνη ἐλπιοῦσι. ");
INSERT INTO grctr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Τότε προσηνέχθη αὐτῷ δαιμονιζόμενος, τυφλὸς καὶ κωφός· καὶ ἐθεράπευσεν αὐτόν, ὥστε τὸν τυφλὸν καὶ κωφὸν καὶ λαλεῖν καὶ βλέπειν. ");
INSERT INTO grctr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Καὶ ἐξίσταντο πάντες οἱ ὄχλοι καὶ ἔλεγον, Μήτι οὗτός ἐστιν ὁ υἱὸς Δαβίδ; ");
INSERT INTO grctr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Οἱ δὲ Φαρισαῖοι ἀκούσαντες εἶπον, Οὗτος οὐκ ἐκβάλλει τὰ δαιμόνια, εἰ μὴ ἐν τῷ Βεελζεβοὺλ ἄρχοντι τῶν δαιμονίων. ");
INSERT INTO grctr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Εἰδὼς δὲ ὁ Ἰησοῦς τὰς ἐνθυμήσεις αὐτῶν εἶπεν αὐτοῖς, Πᾶσα βασιλεία μερισθεῖσα καθ᾿ ἑαυτῆς ἐρημοῦται· καὶ πᾶσα πόλις ἢ οἰκία μερισθεῖσα καθ᾿ ἑαυτῆς οὐ σταθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Καὶ εἰ ὁ Σατανᾶς τὸν Σατανᾶν ἐκβάλλει, ἐφ᾿ ἑαυτὸν ἐμερίσθη· πῶς οὖν σταθήσεται ἡ βασιλεία αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Καὶ εἰ ἐγὼ ἐν Βεελζεβοὺλ ἐκβάλλω τὰ δαιμόνια, οἱ υἱοὶ ὑμῶν ἐν τίνι ἐκβάλλουσι; Διὰ τοῦτο αὐτοὶ ὑμῶν ἔσονται κριταί. ");
INSERT INTO grctr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Εἰ δὲ ἐγὼ ἐν πνεύματι Θεοῦ ἐκβάλλω τὰ δαιμόνια, ἄρα ἔφθασεν ἐφ᾿ ὑμᾶς ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ἢ πῶς δύναταί τις εἰσελθεῖν εἰς τὴν οἰκίαν τοῦ ἰσχυροῦ καὶ τὰ σκεύη αὐτοῦ διαρπάσαι, ἐὰν μὴ πρῶτον δήσῃ τὸν ἰσχυρόν; Καὶ τότε τὴν οἰκίαν αὐτοῦ διαρπάσει. ");
INSERT INTO grctr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ὁ μὴ ὢν μετ᾿ ἐμοῦ κατ᾿ ἐμοῦ ἐστι· καὶ ὁ μὴ συνάγων μετ᾿ ἐμοῦ σκορπίζει. ");
INSERT INTO grctr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Διὰ τοῦτο λέγω ὑμῖν, Πᾶσα ἁμαρτία καὶ βλασφημία ἀφεθήσεται τοῖς ἀνθρώποις· ἡ δὲ τοῦ πνεύματος βλασφημία οὐκ ἀφεθήσεται τοῖς ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Καὶ ὃς ἂν εἴπῃ λόγον κατὰ τοῦ υἱοῦ τοῦ ἀνθρώπου, ἀφεθήσεται αὐτῷ· ὃς δ᾿ ἂν εἴπῃ κατὰ τοῦ πνεύματος τοῦ ἁγίου, οὐκ ἀφεθήσεται αὐτῷ, οὔτε ἐν τούτῳ τῷ αἰῶνι οὔτε ἐν τῷ μέλλοντι. ");
INSERT INTO grctr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ἢ ποιήσατε τὸ δένδρον καλόν, καὶ τὸν καρπὸν αὐτοῦ καλόν, ἢ ποιήσατε τὸ δένδρον σαπρόν, καὶ τὸν καρπὸν αὐτοῦ σαπρόν· ἐκ γὰρ τοῦ καρποῦ τὸ δένδρον γινώσκεται. ");
INSERT INTO grctr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Γεννήματα ἐχιδνῶν, πῶς δύνασθε ἀγαθὰ λαλεῖν, πονηροὶ ὄντες; Ἐκ γὰρ τοῦ περισσεύματος τῆς καρδίας τὸ στόμα λαλεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ὁ ἀγαθὸς ἄνθρωπος ἐκ τοῦ ἀγαθοῦ θησαυροῦ τῆς καρδίας ἐκβάλλει τὰ ἀγαθά· καὶ ὁ πονηρὸς ἄνθρωπος ἐκ τοῦ πονηροῦ θησαυροῦ ἐκβάλλει πονηρά. ");
INSERT INTO grctr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Λέγω δὲ ὑμῖν ὅτι πᾶν ῥῆμα ἀργόν, ὃ ἐὰν λαλήσωσιν οἱ ἄνθρωποι, ἀποδώσουσι περὶ αὐτοῦ λόγον ἐν ἡμέρᾳ κρίσεως. ");
INSERT INTO grctr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ἐκ γὰρ τῶν λόγων σου δικαιωθήσῃ, καὶ ἐκ τῶν λόγων σου καταδικασθήσῃ. ");
INSERT INTO grctr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Τότε ἀπεκρίθησάν τινες τῶν γραμματέων καὶ Φαρισαίων, λέγοντες, Διδάσκαλε, θέλομεν ἀπὸ σοῦ σημεῖον ἰδεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Γενεὰ πονηρὰ καὶ μοιχαλὶς σημεῖον ἐπιζητεῖ· καὶ σημεῖον οὐ δοθήσεται αὐτῇ, εἰ μὴ τὸ σημεῖον Ἰωνᾶ τοῦ προφήτου. ");
INSERT INTO grctr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ὥσπερ γὰρ ἦν Ἰωνᾶς ἐν τῇ κοιλίᾳ τοῦ κήτους τρεῖς ἡμέρας καὶ τρεῖς νύκτας, οὕτως ἔσται ὁ υἱὸς τοῦ ἀνθρώπου ἐν τῇ καρδίᾳ τῆς γῆς τρεῖς ἡμέρας καὶ τρεῖς νύκτας. ");
INSERT INTO grctr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ἄνδρες Νινευῖται ἀναστήσονται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινοῦσιν αὐτήν· ὅτι μετενόησαν εἰς τὸ κήρυγμα Ἰωνᾶ· καὶ ἰδού, πλεῖον Ἰωνᾶ ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Βασίλισσα νότου ἐγερθήσεται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινεῖ αὐτήν· ὅτι ἦλθεν ἐκ τῶν περάτων τῆς γῆς ἀκοῦσαι τὴν σοφίαν Σολομῶντος· καὶ ἰδού, πλεῖον Σολομῶντος ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ὅταν δὲ τὸ ἀκάθαρτον πνεῦμα ἐξέλθῃ ἀπὸ τοῦ ἀνθρώπου, διέρχεται δι᾿ ἀνύδρων τόπων, ζητοῦν ἀνάπαυσιν, καὶ οὐχ εὑρίσκει. ");
INSERT INTO grctr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Τότε λέγει, Ἐπιστρέψω εἰς τὸν οἶκόν μου ὅθεν ἐξῆλθον. Καὶ ἐλθὸν εὑρίσκει σχολάζοντα, σεσαρωμένον καὶ κεκοσμημένον. ");
INSERT INTO grctr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Τότε πορεύεται καὶ παραλαμβάνει μεθ᾿ ἑαυτοῦ ἑπτὰ ἕτερα πνεύματα πονηρότερα ἑαυτοῦ, καὶ εἰσελθόντα κατοικεῖ ἐκεῖ· καὶ γίνεται τὰ ἔσχατα τοῦ ἀνθρώπου ἐκείνου χείρονα τῶν πρώτων. Οὕτως ἔσται καὶ τῇ γενεᾷ ταύτῃ τῇ πονηρᾷ. ");
INSERT INTO grctr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ἔτι δὲ αὐτοῦ λαλοῦντος τοῖς ὄχλοις, ἰδού, ἡ μήτηρ καὶ οἱ ἀδελφοὶ αὐτοῦ εἱστήκεισαν ἔξω, ζητοῦντες αὐτῷ λαλῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Εἶπε δέ τις αὐτῷ, Ἰδού, ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου ἔξω ἑστήκασι, ζητοῦντές σοι λαλῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ὁ δὲ ἀποκριθεὶς εἶπε τῷ εἰπόντι αὐτῷ, Τίς ἐστιν ἡ μήτηρ μου; Καὶ τίνες εἰσὶν οἱ ἀδελφοί μου; ");
INSERT INTO grctr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Καὶ ἐκτείνας τὴν χεῖρα αὐτοῦ ἐπὶ τοὺς μαθητὰς αὐτοῦ εἶπεν, Ἰδού, ἡ μήτηρ μου καὶ οἱ ἀδελφοί μου. ");
INSERT INTO grctr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ὅστις γὰρ ἂν ποιήσῃ τὸ θέλημα τοῦ πατρός μου τοῦ ἐν οὐρανοῖς, αὐτός μου ἀδελφὸς καὶ ἀδελφὴ καὶ μήτηρ ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ἐν δὲ τῇ ἡμέρᾳ ἐκείνῃ ἐξελθὼν ὁ Ἰησοῦς ἀπὸ τῆς οἰκίας ἐκάθητο παρὰ τὴν θάλασσαν. ");
INSERT INTO grctr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Καὶ συνήχθησαν πρὸς αὐτὸν ὄχλοι πολλοί, ὥστε αὐτὸν εἰς τὸ πλοῖον ἐμβάντα καθῆσθαι· καὶ πᾶς ὁ ὄχλος ἐπὶ τὸν αἰγιαλὸν εἱστήκει. ");
INSERT INTO grctr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Καὶ ἐλάλησεν αὐτοῖς πολλὰ ἐν παραβολαῖς, λέγων, Ἰδού, ἐξῆλθεν ὁ σπείρων τοῦ σπείρειν. ");
INSERT INTO grctr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Καὶ ἐν τῷ σπείρειν αὐτόν, ἃ μὲν ἔπεσε παρὰ τὴν ὁδόν, καὶ ἦλθε τὰ πετεινὰ καὶ κατέφαγεν αὐτά. ");
INSERT INTO grctr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ἄλλα δὲ ἔπεσεν ἐπὶ τὰ πετρώδη, ὅπου οὐκ εἶχε γῆν πολλήν· καὶ εὐθέως ἐξανέτειλε, διὰ τὸ μὴ ἔχειν βάθος γῆς· ");
INSERT INTO grctr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ἡλίου δὲ ἀνατείλαντος ἐκαυματίσθη, καὶ διὰ τὸ μὴ ἔχειν ῥίζαν ἐξηράνθη. ");
INSERT INTO grctr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ἄλλα δὲ ἔπεσεν ἐπὶ τὰς ἀκάνθας, καὶ ἀνέβησαν αἱ ἄκανθαι καὶ ἀπέπνιξαν αὐτά. ");
INSERT INTO grctr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ἄλλα δὲ ἔπεσεν ἐπὶ τὴν γῆν τὴν καλήν· καὶ ἐδίδου καρπόν, ὃ μὲν ἑκατόν, ὃ δὲ ἑξήκοντα, ὃ δὲ τριάκοντα. ");
INSERT INTO grctr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Καὶ προσελθόντες οἱ μαθηταὶ εἶπον αὐτῷ, Διὰ τί ἐν παραβολαῖς λαλεῖς αὐτοῖς; ");
INSERT INTO grctr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς ὅτι Ὑμῖν δέδοται γνῶναι τὰ μυστήρια τῆς βασιλείας τῶν οὐρανῶν, ἐκείνοις δὲ οὐ δέδοται. ");
INSERT INTO grctr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ὅστις γὰρ ἔχει, δοθήσεται αὐτῷ καὶ περισσευθήσεται· ὅστις δὲ οὐκ ἔχει, καὶ ὃ ἔχει ἀρθήσεται ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Διὰ τοῦτο ἐν παραβολαῖς αὐτοῖς λαλῶ, ὅτι βλέποντες οὐ βλέπουσι, καὶ ἀκούοντες οὐκ ἀκούουσιν, οὐδὲ συνιοῦσι. ");
INSERT INTO grctr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Καὶ ἀναπληροῦται ἐπ᾿ αὐτοῖς ἡ προφητεία Ἠσαΐου, ἡ λέγουσα, Ἀκοῇ ἀκούσετε, καὶ οὐ μὴ συνῆτε· καὶ βλέποντες βλέψετε, καὶ οὐ μὴ ἴδητε. ");
INSERT INTO grctr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ἐπαχύνθη γὰρ ἡ καρδία τοῦ λαοῦ τούτου, καὶ τοῖς ὠσὶ βαρέως ἤκουσαν, καὶ τοὺς ὀφθαλμοὺς αὐτῶν ἐκάμμυσαν· μήποτε ἴδωσι τοῖς ὀφθαλμοῖς, καὶ τοῖς ὠσὶν ἀκούσωσι, καὶ τῇ καρδίᾳ συνῶσι, καὶ ἐπιστρέψωσι, καὶ ἰάσωμαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ὑμῶν δὲ μακάριοι οἱ ὀφθαλμοί, ὅτι βλέπουσι· καὶ τὰ ὦτα ὑμῶν, ὅτι ἀκούει. ");
INSERT INTO grctr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ἀμὴν γὰρ λέγω ὑμῖν ὅτι πολλοὶ προφῆται καὶ δίκαιοι ἐπεθύμησαν ἰδεῖν ἃ βλέπετε, καὶ οὐκ εἶδον· καὶ ἀκοῦσαι ἃ ἀκούετε, καὶ οὐκ ἤκουσαν. ");
INSERT INTO grctr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ὑμεῖς οὖν ἀκούσατε τὴν παραβολὴν τοῦ σπείροντος. ");
INSERT INTO grctr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Παντὸς ἀκούοντος τὸν λόγον τῆς βασιλείας καὶ μὴ συνιέντος, ἔρχεται ὁ πονηρός, καὶ ἁρπάζει τὸ ἐσπαρμένον ἐν τῇ καρδίᾳ αὐτοῦ· οὗτός ἐστιν ὁ παρὰ τὴν ὁδὸν σπαρείς. ");
INSERT INTO grctr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ὁ δὲ ἐπὶ τὰ πετρώδη σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων, καὶ εὐθὺς μετὰ χαρᾶς λαμβάνων αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","οὐκ ἔχει δὲ ῥίζαν ἐν ἑαυτῷ, ἀλλὰ πρόσκαιρός ἐστι· γενομένης δὲ θλίψεως ἢ διωγμοῦ διὰ τὸν λόγον, εὐθὺς σκανδαλίζεται. ");
INSERT INTO grctr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ὁ δὲ εἰς τὰς ἀκάνθας σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων, καὶ ἡ μέριμνα τοῦ αἰῶνος τούτου καὶ ἡ ἀπάτη τοῦ πλούτου συμπνίγει τὸν λόγον, καὶ ἄκαρπος γίνεται. ");
INSERT INTO grctr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ὁ δὲ ἐπὶ τὴν γῆν τὴν καλὴν σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων καὶ συνιών· ὃς δὴ καρποφορεῖ, καὶ ποιεῖ ὁ μὲν ἑκατόν, ὁ δὲ ἑξήκοντα, ὁ δὲ τριάκοντα. ");
INSERT INTO grctr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ἄλλην παραβολὴν παρέθηκεν αὐτοῖς, λέγων, Ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ σπείροντι καλὸν σπέρμα ἐν τῷ ἀγρῷ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ἐν δὲ τῷ καθεύδειν τοὺς ἀνθρώπους, ἦλθεν αὐτοῦ ὁ ἐχθρὸς καὶ ἔσπειρε ζιζάνια ἀνὰ μέσον τοῦ σίτου, καὶ ἀπῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ὅτε δὲ ἐβλάστησεν ὁ χόρτος καὶ καρπὸν ἐποίησε, τότε ἐφάνη καὶ τὰ ζιζάνια. ");
INSERT INTO grctr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Προσελθόντες δὲ οἱ δοῦλοι τοῦ οἰκοδεσπότου εἶπον αὐτῷ, Κύριε, οὐχὶ καλὸν σπέρμα ἔσπειρας ἐν τῷ σῷ ἀγρῷ; Πόθεν οὖν ἔχει τὰ ζιζάνια; ");
INSERT INTO grctr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ὁ δὲ ἔφη αὐτοῖς, Ἐχθρὸς ἄνθρωπος τοῦτο ἐποίησεν. Οἱ δὲ δοῦλοι εἶπον αὐτῷ, Θέλεις οὖν ἀπελθόντες συλλέξωμεν αὐτά; ");
INSERT INTO grctr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ὁ δὲ ἔφη, Οὔ· μήποτε, συλλέγοντες τὰ ζιζάνια, ἐκριζώσητε ἅμα αὐτοῖς τὸν σῖτον. ");
INSERT INTO grctr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ἄφετε συναυξάνεσθαι ἀμφότερα μέχρι τοῦ θερισμοῦ· καὶ ἐν τῷ καιρῷ τοῦ θερισμοῦ ἐρῶ τοῖς θερισταῖς, Συλλέξατε πρῶτον τὰ ζιζάνια, καὶ δήσατε αὐτὰ εἰς δέσμας πρὸς τὸ κατακαῦσαι αὐτά· τὸν δὲ σῖτον συναγάγετε εἰς τὴν ἀποθήκην μου. ");
INSERT INTO grctr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ἄλλην παραβολὴν παρέθηκεν αὐτοῖς, λέγων, Ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν κόκκῳ σινάπεως, ὃν λαβὼν ἄνθρωπος ἔσπειρεν ἐν τῷ ἀγρῷ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ὃ μικρότερον μέν ἐστι πάντων τῶν σπερμάτων· ὅταν δὲ αὐξηθῇ, μεῖζον τῶν λαχάνων ἐστί, καὶ γίνεται δένδρον, ὥστε ἐλθεῖν τὰ πετεινὰ τοῦ οὐρανοῦ καὶ κατασκηνοῦν ἐν τοῖς κλάδοις αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ἄλλην παραβολὴν ἐλάλησεν αὐτοῖς, Ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν ζύμῃ, ἣν λαβοῦσα γυνὴ ἐνέκρυψεν εἰς ἀλεύρου σάτα τρία, ἕως οὗ ἐζυμώθη ὅλον. ");
INSERT INTO grctr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ταῦτα πάντα ἐλάλησεν ὁ Ἰησοῦς ἐν παραβολαῖς τοῖς ὄχλοις, καὶ χωρὶς παραβολῆς οὐκ ἐλάλει αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ὅπως πληρωθῇ τὸ ῥηθὲν διὰ τοῦ προφήτου, λέγοντος, Ἀνοίξω ἐν παραβολαῖς τὸ στόμα μου, ἐρεύξομαι κεκρυμμένα ἀπὸ καταβολῆς κόσμου. ");
INSERT INTO grctr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Τότε ἀφεὶς τοὺς ὄχλους ἦλθεν εἰς τὴν οἰκίαν ὁ Ἰησοῦς· καὶ προσῆλθον αὐτῷ οἱ μαθηταὶ αὐτοῦ, λέγοντες, Φράσον ἡμῖν τὴν παραβολὴν τῶν ζιζανίων τοῦ ἀγροῦ. ");
INSERT INTO grctr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Ὁ σπείρων τὸ καλὸν σπέρμα ἐστὶν ὁ υἱὸς τοῦ ἀνθρώπου· ");
INSERT INTO grctr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ὁ δὲ ἀγρός ἐστιν ὁ κόσμος· τὸ δὲ καλὸν σπέρμα, οὗτοί εἰσιν οἱ υἱοὶ τῆς βασιλείας· τὰ δὲ ζιζάνιά εἰσιν οἱ υἱοὶ τοῦ πονηροῦ· ");
INSERT INTO grctr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ὁ δὲ ἐχθρὸς ὁ σπείρας αὐτά ἐστιν ὁ διάβολος· ὁ δὲ θερισμὸς συντέλεια τοῦ αἰῶνός ἐστιν· οἱ δὲ θερισταὶ ἄγγελοί εἰσιν. ");
INSERT INTO grctr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ὥσπερ οὖν συλλέγεται τὰ ζιζάνια καὶ πυρὶ κατακαίεται, οὕτως ἔσται ἐν τῇ συντελείᾳ τοῦ αἰῶνος τούτου. ");
INSERT INTO grctr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ἀποστελεῖ ὁ υἱὸς τοῦ ἀνθρώπου τοὺς ἀγγέλους αὐτοῦ, καὶ συλλέξουσιν ἐκ τῆς βασιλείας αὐτοῦ πάντα τὰ σκάνδαλα καὶ τοὺς ποιοῦντας τὴν ἀνομίαν, ");
INSERT INTO grctr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","καὶ βαλοῦσιν αὐτοὺς εἰς τὴν κάμινον τοῦ πυρός· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Τότε οἱ δίκαιοι ἐκλάμψουσιν ὡς ὁ ἥλιος ἐν τῇ βασιλείᾳ τοῦ πατρὸς αὐτῶν. Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Πάλιν ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν θησαυρῷ κεκρυμμένῳ ἐν τῷ ἀγρῷ, ὃν εὑρὼν ἄνθρωπος ἔκρυψε· καὶ ἀπὸ τῆς χαρᾶς αὐτοῦ ὑπάγει, καὶ πάντα ὅσα ἔχει πωλεῖ, καὶ ἀγοράζει τὸν ἀγρὸν ἐκεῖνον. ");
INSERT INTO grctr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Πάλιν ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ ἐμπόρῳ ζητοῦντι καλοὺς μαργαρίτας· ");
INSERT INTO grctr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ὃς εὑρὼν ἕνα πολύτιμον μαργαρίτην, ἀπελθὼν πέπρακε πάντα ὅσα εἶχε, καὶ ἠγόρασεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Πάλιν ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν σαγήνῃ βληθείσῃ εἰς τὴν θάλασσαν, καὶ ἐκ παντὸς γένους συναγαγούσῃ· ");
INSERT INTO grctr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ἥν, ὅτε ἐπληρώθη, ἀναβιβάσαντες ἐπὶ τὸν αἰγιαλόν, καὶ καθίσαντες, συνέλεξαν τὰ καλὰ εἰς ἀγγεῖα, τὰ δὲ σαπρὰ ἔξω ἔβαλον. ");
INSERT INTO grctr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Οὕτως ἔσται ἐν τῇ συντελείᾳ τοῦ αἰῶνος· ἐξελεύσονται οἱ ἄγγελοι, καὶ ἀφοριοῦσι τοὺς πονηροὺς ἐκ μέσου τῶν δικαίων, ");
INSERT INTO grctr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","καὶ βαλοῦσιν αὐτοὺς εἰς τὴν κάμινον τοῦ πυρός· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Λέγει αὐτοῖς ὁ Ἰησοῦς, Συνήκατε ταῦτα πάντα; Λέγουσιν αὐτῷ, Ναί, Κύριε. ");
INSERT INTO grctr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ὁ δὲ εἶπεν αὐτοῖς, Διὰ τοῦτο πᾶς γραμματεὺς μαθητευθεὶς εἰς τὴν βασιλείαν τῶν οὐρανῶν ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδεσπότῃ, ὅστις ἐκβάλλει ἐκ τοῦ θησαυροῦ αὐτοῦ καινὰ καὶ παλαιά. ");
INSERT INTO grctr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς τὰς παραβολὰς ταύτας, μετῆρεν ἐκεῖθεν· ");
INSERT INTO grctr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","καὶ ἐλθὼν εἰς τὴν πατρίδα αὐτοῦ ἐδίδασκεν αὐτοὺς ἐν τῇ συναγωγῇ αὐτῶν, ὥστε ἐκπλήττεσθαι αὐτοὺς καὶ λέγειν, Πόθεν τούτῳ ἡ σοφία αὕτη καὶ αἱ δυνάμεις; ");
INSERT INTO grctr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Οὐχ οὗτός ἐστιν ὁ τοῦ τέκτονος υἱός; Οὐχὶ ἡ μήτηρ αὐτοῦ λέγεται Μαριάμ, καὶ οἱ ἀδελφοὶ αὐτοῦ Ἰάκωβος καὶ Ἰωσῆς καὶ Σίμων καὶ Ἰούδας; ");
INSERT INTO grctr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Καὶ αἱ ἀδελφαὶ αὐτοῦ οὐχὶ πᾶσαι πρὸς ἡμᾶς εἰσί; Πόθεν οὖν τούτῳ ταῦτα πάντα; ");
INSERT INTO grctr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Καὶ ἐσκανδαλίζοντο ἐν αὐτῷ. Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Οὐκ ἔστι προφήτης ἄτιμος, εἰ μὴ ἐν τῇ πατρίδι αὐτοῦ καὶ ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Καὶ οὐκ ἐποίησεν ἐκεῖ δυνάμεις πολλάς, διὰ τὴν ἀπιστίαν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ἐν ἐκείνῳ τῷ καιρῷ ἤκουσεν Ἡρῴδης ὁ τετράρχης τὴν ἀκοὴν Ἰησοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","καὶ εἶπε τοῖς παισὶν αὐτοῦ, Οὗτός ἐστιν Ἰωάννης ὁ βαπτιστής· αὐτὸς ἠγέρθη ἀπὸ τῶν νεκρῶν, καὶ διὰ τοῦτο αἱ δυνάμεις ἐνεργοῦσιν ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ὁ γὰρ Ἡρῴδης κρατήσας τὸν Ἰωάννην ἔδησεν αὐτὸν καὶ ἔθετο ἐν φυλακῇ, διὰ Ἡρῳδιάδα τὴν γυναῖκα Φιλίππου τοῦ ἀδελφοῦ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ἔλεγε γὰρ αὐτῷ ὁ Ἰωάννης, Οὐκ ἔξεστί σοι ἔχειν αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Καὶ θέλων αὐτὸν ἀποκτεῖναι, ἐφοβήθη τὸν ὄχλον, ὅτι ὡς προφήτην αὐτὸν εἶχον. ");
INSERT INTO grctr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Γενεσίων δὲ ἀγομένων τοῦ Ἡρῴδου, ὠρχήσατο ἡ θυγάτηρ τῆς Ἡρῳδιάδος ἐν τῷ μέσῳ, καὶ ἤρεσε τῷ Ἡρῴδῃ· ");
INSERT INTO grctr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ὅθεν μεθ᾿ ὅρκου ὡμολόγησεν αὐτῇ δοῦναι ὃ ἐὰν αἰτήσηται. ");
INSERT INTO grctr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ἡ δέ, προβιβασθεῖσα ὑπὸ τῆς μητρὸς αὐτῆς, Δός μοι, φησίν, ὧδε ἐπὶ πίνακι τὴν κεφαλὴν Ἰωάννου τοῦ βαπτιστοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Καὶ ἐλυπήθη ὁ βασιλεύς, διὰ δὲ τοὺς ὅρκους καὶ τοὺς συνανακειμένους ἐκέλευσε δοθῆναι· ");
INSERT INTO grctr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","καὶ πέμψας ἀπεκεφάλισε τὸν Ἰωάννην ἐν τῇ φυλακῇ. ");
INSERT INTO grctr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Καὶ ἠνέχθη ἡ κεφαλὴ αὐτοῦ ἐπὶ πίνακι, καὶ ἐδόθη τῷ κορασίῳ· καὶ ἤνεγκε τῇ μητρὶ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Καὶ προσελθόντες οἱ μαθηταὶ αὐτοῦ ἦραν τὸ σῶμα, καὶ ἔθαψαν αὐτό· καὶ ἐλθόντες ἀπήγγειλαν τῷ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Καὶ ἀκούσας ὁ Ἰησοῦς ἀνεχώρησεν ἐκεῖθεν ἐν πλοίῳ εἰς ἔρημον τόπον κατ᾿ ἰδίαν· καὶ ἀκούσαντες οἱ ὄχλοι ἠκολούθησαν αὐτῷ πεζῇ ἀπὸ τῶν πόλεων. ");
INSERT INTO grctr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Καὶ ἐξελθὼν ὁ Ἰησοῦς εἶδε πολὺν ὄχλον, καὶ ἐσπλαγχνίσθη ἐπ᾿ αὐτούς, καὶ ἐθεράπευσε τοὺς ἀρρώστους αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ὀψίας δὲ γενομένης, προσῆλθον αὐτῷ οἱ μαθηταὶ αὐτοῦ, λέγοντες, Ἔρημός ἐστιν ὁ τόπος, καὶ ἡ ὥρα ἤδη παρῆλθεν· ἀπόλυσον τοὺς ὄχλους, ἵνα ἀπελθόντες εἰς τὰς κώμας ἀγοράσωσιν ἑαυτοῖς βρώματα. ");
INSERT INTO grctr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Οὐ χρείαν ἔχουσιν ἀπελθεῖν· δότε αὐτοῖς ὑμεῖς φαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Οἱ δὲ λέγουσιν αὐτῷ, Οὐκ ἔχομεν ὧδε εἰ μὴ πέντε ἄρτους καὶ δύο ἰχθύας. ");
INSERT INTO grctr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ὁ δὲ εἶπε, Φέρετέ μοι αὐτοὺς ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Καὶ κελεύσας τοὺς ὄχλους ἀνακλιθῆναι ἐπὶ τοὺς χόρτους, καὶ λαβὼν τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας, ἀναβλέψας εἰς τὸν οὐρανόν, εὐλόγησε, καὶ κλάσας ἔδωκε τοῖς μαθηταῖς τοὺς ἄρτους, οἱ δὲ μαθηταὶ τοῖς ὄχλοις. ");
INSERT INTO grctr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Καὶ ἔφαγον πάντες, καὶ ἐχορτάσθησαν· καὶ ἦραν τὸ περισσεῦον τῶν κλασμάτων, δώδεκα κοφίνους πλήρεις. ");
INSERT INTO grctr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Οἱ δὲ ἐσθίοντες ἦσαν ἄνδρες ὡσεὶ πεντακισχίλιοι, χωρὶς γυναικῶν καὶ παιδίων. ");
INSERT INTO grctr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Καὶ εὐθέως ἠνάγκασεν ὁ Ἰησοῦς τοὺς μαθητὰς αὐτοῦ ἐμβῆναι εἰς τὸ πλοῖον, καὶ προάγειν αὐτὸν εἰς τὸ πέραν, ἕως οὗ ἀπολύσῃ τοὺς ὄχλους. ");
INSERT INTO grctr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Καὶ ἀπολύσας τοὺς ὄχλους, ἀνέβη εἰς τὸ ὄρος κατ᾿ ἰδίαν προσεύξασθαι· ὀψίας δὲ γενομένης, μόνος ἦν ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Τὸ δὲ πλοῖον ἤδη μέσον τῆς θαλάσσης ἦν, βασανιζόμενον ὑπὸ τῶν κυμάτων· ἦν γὰρ ἐναντίος ὁ ἄνεμος. ");
INSERT INTO grctr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Τετάρτῃ δὲ φυλακῇ τῆς νυκτὸς ἀπῆλθε πρὸς αὐτοὺς ὁ Ἰησοῦς, περιπατῶν ἐπὶ τῆς θαλάσσης. ");
INSERT INTO grctr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Καὶ ἰδόντες αὐτὸν οἱ μαθηταὶ ἐπὶ τὴν θάλασσαν περιπατοῦντα ἐταράχθησαν, λέγοντες ὅτι Φάντασμά ἐστι· καὶ ἀπὸ τοῦ φόβου ἔκραξαν. ");
INSERT INTO grctr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Εὐθέως δὲ ἐλάλησεν αὐτοῖς ὁ Ἰησοῦς, λέγων, Θαρσεῖτε· ἐγώ εἰμι· μὴ φοβεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ἀποκριθεὶς δὲ αὐτῷ ὁ Πέτρος εἶπε, Κύριε, εἰ σὺ εἶ, κέλευσόν με πρός σε ἐλθεῖν ἐπὶ τὰ ὕδατα. ");
INSERT INTO grctr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ὁ δὲ εἶπεν, Ἐλθέ. Καὶ καταβὰς ἀπὸ τοῦ πλοίου ὁ Πέτρος περιεπάτησεν ἐπὶ τὰ ὕδατα, ἐλθεῖν πρὸς τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Βλέπων δὲ τὸν ἄνεμον ἰσχυρὸν ἐφοβήθη· καὶ ἀρξάμενος καταποντίζεσθαι ἔκραξε, λέγων, Κύριε, σῶσόν με. ");
INSERT INTO grctr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Εὐθέως δὲ ὁ Ἰησοῦς ἐκτείνας τὴν χεῖρα ἐπελάβετο αὐτοῦ, καὶ λέγει αὐτῷ, Ὀλιγόπιστε, εἰς τί ἐδίστασας; ");
INSERT INTO grctr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Καὶ ἐμβάντων αὐτῶν εἰς τὸ πλοῖον, ἐκόπασεν ὁ ἄνεμος· ");
INSERT INTO grctr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","οἱ δὲ ἐν τῷ πλοίῳ ἐλθόντες προσεκύνησαν αὐτῷ, λέγοντες, Ἀληθῶς Θεοῦ υἱὸς εἶ. ");
INSERT INTO grctr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Καὶ διαπεράσαντες ἦλθον εἰς τὴν γῆν Γεννησαρέτ. ");
INSERT INTO grctr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Καὶ ἐπιγνόντες αὐτὸν οἱ ἄνδρες τοῦ τόπου ἐκείνου ἀπέστειλαν εἰς ὅλην τὴν περίχωρον ἐκείνην, καὶ προσήνεγκαν αὐτῷ πάντας τοὺς κακῶς ἔχοντας· ");
INSERT INTO grctr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","καὶ παρεκάλουν αὐτόν, ἵνα μόνον ἅψωνται τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ· καὶ ὅσοι ἥψαντο διεσώθησαν. ");
INSERT INTO grctr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Τότε προσέρχονται τῷ Ἰησοῦ οἱ ἀπὸ Ἱεροσολύμων γραμματεῖς καὶ Φαρισαῖοι, λέγοντες, ");
INSERT INTO grctr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Διὰ τί οἱ μαθηταί σου παραβαίνουσι τὴν παράδοσιν τῶν πρεσβυτέρων; Οὐ γὰρ νίπτονται τὰς χεῖρας αὐτῶν, ὅταν ἄρτον ἐσθίωσιν. ");
INSERT INTO grctr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Διὰ τί καὶ ὑμεῖς παραβαίνετε τὴν ἐντολὴν τοῦ Θεοῦ διὰ τὴν παράδοσιν ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ὁ γὰρ Θεὸς ἐνετείλατο, λέγων, Τίμα τὸν πατέρα σοῦ καὶ τὴν μητέρα· καί, Ὁ κακολογῶν πατέρα ἢ μητέρα θανάτῳ τελευτάτω· ");
INSERT INTO grctr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ὑμεῖς δὲ λέγετε, Ὃς ἂν εἴπῃ τῷ πατρὶ ἢ τῇ μητρί, Δῶρον, ὃ ἐὰν ἐξ ἐμοῦ ὠφεληθῇς, καὶ οὐ μὴ τιμήσῃ τὸν πατέρα αὐτοῦ ἢ τὴν μητέρα αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","καὶ ἠκυρώσατε τὴν ἐντολὴν τοῦ Θεοῦ διὰ τὴν παράδοσιν ὑμῶν· ");
INSERT INTO grctr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ὑποκριταί, καλῶς προεφήτευσε περὶ ὑμῶν Ἠσαΐας, λέγων, ");
INSERT INTO grctr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ἐγγίζει μοι ὁ λαὸς οὗτος τῷ στόματι αὐτῶν, καὶ τοῖς χείλεσί με τιμᾷ, ἡ δὲ καρδία αὐτῶν πόρρω ἀπέχει ἀπ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Μάτην δὲ σέβονταί με, διδάσκοντες διδασκαλίας ἐντάλματα ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Καὶ προσκαλεσάμενος τὸν ὄχλον, εἶπεν αὐτοῖς, Ἀκούετε καὶ συνίετε. ");
INSERT INTO grctr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Οὐ τὸ εἰσερχόμενον εἰς τὸ στόμα κοινοῖ τὸν ἄνθρωπον· ἀλλὰ τὸ ἐκπορευόμενον ἐκ τοῦ στόματος, τοῦτο κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Τότε προσελθόντες οἱ μαθηταὶ αὐτοῦ εἶπον αὐτῷ, Οἶδας ὅτι οἱ Φαρισαῖοι ἀκούσαντες τὸν λόγον ἐσκανδαλίσθησαν; ");
INSERT INTO grctr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ὁ δὲ ἀποκριθεὶς εἶπε, Πᾶσα φυτεία, ἣν οὐκ ἐφύτευσεν ὁ πατήρ μου ὁ οὐράνιος, ἐκριζωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ἄφετε αὐτούς· ὁδηγοί εἰσι τυφλοὶ τυφλῶν· τυφλὸς δὲ τυφλὸν ἐὰν ὁδηγῇ, ἀμφότεροι εἰς βόθυνον πεσοῦνται. ");
INSERT INTO grctr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ἀποκριθεὶς δὲ ὁ Πέτρος εἶπεν αὐτῷ, Φράσον ἡμῖν τὴν παραβολὴν ταύτην. ");
INSERT INTO grctr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ὁ δὲ Ἰησοῦς εἶπεν, Ἀκμὴν καὶ ὑμεῖς ἀσύνετοί ἐστε; ");
INSERT INTO grctr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Οὔπω νοεῖτε ὅτι πᾶν τὸ εἰσπορευόμενον εἰς τὸ στόμα εἰς τὴν κοιλίαν χωρεῖ, καὶ εἰς ἀφεδρῶνα ἐκβάλλεται; ");
INSERT INTO grctr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Τὰ δὲ ἐκπορευόμενα ἐκ τοῦ στόματος ἐκ τῆς καρδίας ἐξέρχεται, κἀκεῖνα κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ἐκ γὰρ τῆς καρδίας ἐξέρχονται διαλογισμοὶ πονηροί, φόνοι, μοιχεῖαι, πορνεῖαι, κλοπαί, ψευδομαρτυρίαι, βλασφημίαι· ");
INSERT INTO grctr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ταῦτά ἐστι τὰ κοινοῦντα τὸν ἄνθρωπον· τὸ δὲ ἀνίπτοις χερσὶ φαγεῖν οὐ κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Καὶ ἐξελθὼν ἐκεῖθεν ὁ Ἰησοῦς ἀνεχώρησεν εἰς τὰ μέρη Τύρου καὶ Σιδῶνος. ");
INSERT INTO grctr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Καὶ ἰδού, γυνὴ Χαναναία ἀπὸ τῶν ὁρίων ἐκείνων ἐξελθοῦσα ἐκραύγασεν αὐτῷ, λέγουσα, Ἐλέησόν με, Κύριε, υἱὲ Δαβίδ· ἡ θυγάτηρ μου κακῶς δαιμονίζεται. ");
INSERT INTO grctr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ὁ δὲ οὐκ ἀπεκρίθη αὐτῇ λόγον. Καὶ προσελθόντες οἱ μαθηταὶ αὐτοῦ ἠρώτων αὐτόν, λέγοντες, Ἀπόλυσον αὐτήν, ὅτι κράζει ὄπισθεν ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ὁ δὲ ἀποκριθεὶς εἶπεν, Οὐκ ἀπεστάλην εἰ μὴ εἰς τὰ πρόβατα τὰ ἀπολωλότα οἴκου Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ἡ δὲ ἐλθοῦσα προσεκύνηει αὐτῷ λέγουσα, Κύριε, βοήθει μοι. ");
INSERT INTO grctr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ὁ δὲ ἀποκριθεὶς εἶπεν, Οὐκ ἔστι καλὸν λαβεῖν τὸν ἄρτον τῶν τέκνων καὶ βαλεῖν τοῖς κυναρίοις. ");
INSERT INTO grctr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ἡ δὲ εἶπε, Ναί, Κύριε· καὶ γὰρ τὰ κυνάρια ἐσθίει ἀπὸ τῶν ψιχίων τῶν πιπτόντων ἀπὸ τῆς τραπέζης τῶν κυρίων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Τότε ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτῇ, Ὦ γύναι, μεγάλη σου ἡ πίστις· γενηθήτω σοι ὡς θέλεις. Καὶ ἰάθη ἡ θυγάτηρ αὐτῆς ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grctr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Καὶ μεταβὰς ἐκεῖθεν ὁ Ἰησοῦς ἦλθε παρὰ τὴν θάλασσαν τῆς Γαλιλαίας· καὶ ἀναβὰς εἰς τὸ ὄρος ἐκάθητο ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Καὶ προσῆλθον αὐτῷ ὄχλοι πολλοί, ἔχοντες μεθ᾿ ἑαυτῶν χωλούς, τυφλούς, κωφούς, κυλλούς, καὶ ἑτέρους πολλούς, καὶ ἔρριψαν αὐτοὺς παρὰ τοὺς πόδας τοῦ Ἰησοῦ καὶ ἐθεράπευσεν αὐτούς· ");
INSERT INTO grctr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ὥστε τοὺς ὄχλους θαυμάσαι, βλέποντας κωφοὺς λαλοῦντας, κυλλοὺς ὑγιεῖς, χωλοὺς περιπατοῦντας, καὶ τυφλοὺς βλέποντας· καὶ ἐδόξασαν τὸν Θεὸν Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ὁ δὲ Ἰησοῦς προσκαλεσάμενος τοὺς μαθητὰς αὐτοῦ εἶπε, Σπλαγχνίζομαι ἐπὶ τὸν ὄχλον, ὅτι ἤδη ἡμέρας τρεῖς προσμένουσί μοι, καὶ οὐκ ἔχουσι τί φάγωσι· καὶ ἀπολῦσαι αὐτοὺς νήστεις οὐ θέλω, μήποτε ἐκλυθῶσιν ἐν τῇ ὁδῷ. ");
INSERT INTO grctr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Καὶ λέγουσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ, Πόθεν ἡμῖν ἐν ἐρημίᾳ ἄρτοι τοσοῦτοι, ὥστε χορτάσαι ὄχλον τοσοῦτον; ");
INSERT INTO grctr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Καὶ λέγει αὐτοῖς ὁ Ἰησοῦς, Πόσους ἄρτους ἔχετε; Οἱ δὲ εἶπον, Ἑπτά, καὶ ὀλίγα ἰχθύδια. ");
INSERT INTO grctr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Καὶ ἐκέλευσε τοῖς ὄχλοις ἀναπεσεῖν ἐπὶ τὴν γῆν· ");
INSERT INTO grctr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","καὶ λαβὼν τοὺς ἑπτὰ ἄρτους καὶ τοὺς ἰχθύας, εὐχαριστήσας ἔκλασε, καὶ ἔδωκε τοῖς μαθηταῖς αὐτοῦ, οἱ δὲ μαθηταὶ τῷ ὄχλῳ. ");
INSERT INTO grctr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Καὶ ἔφαγον πάντες καὶ ἐχορτάσθησαν· καὶ ἦραν τὸ περισσεῦον τῶν κλασμάτων, ἑπτὰ σπυρίδας πλήρεις. ");
INSERT INTO grctr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Οἱ δὲ ἐσθίοντες ἦσαν τετρακισχίλιοι ἄνδρες, χωρὶς γυναικῶν καὶ παιδίων. ");
INSERT INTO grctr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Καὶ ἀπολύσας τοὺς ὄχλους ἐνέβη εἰς τὸ πλοῖον, καὶ ἦλθεν εἰς τὰ ὅρια Μαγδαλά. ");
INSERT INTO grctr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Καὶ προσελθόντες οἱ Φαρισαῖοι καὶ Σαδδουκαῖοι πειράζοντες ἐπηρώτησαν αὐτὸν σημεῖον ἐκ τοῦ οὐρανοῦ ἐπιδεῖξαι αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Ὀψίας γενομένης λέγετε, Εὐδία· πυρράζει γὰρ ὁ οὐρανός. ");
INSERT INTO grctr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Καὶ πρωΐ, Σήμερον χειμών· πυρράζει γὰρ στυγνάζων ὁ οὐρανός. Ὑποκριταί, τὸ μὲν πρόσωπον τοῦ οὐρανοῦ γινώσκετε διακρίνειν, τὰ δὲ σημεῖα τῶν καιρῶν οὐ δύνασθε; ");
INSERT INTO grctr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Γενεὰ πονηρὰ καὶ μοιχαλὶς σημεῖον ἐπιζητεῖ· καὶ σημεῖον οὐ δοθήσεται αὐτῇ, εἰ μὴ τὸ σημεῖον Ἰωνᾶ τοῦ προφήτου. Καὶ καταλιπὼν αὐτούς, ἀπῆλθε. ");
INSERT INTO grctr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Καὶ ἐλθόντες οἱ μαθηταὶ αὐτοῦ εἰς τὸ πέραν ἐπελάθοντο ἄρτους λαβεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Ὁρᾶτε καὶ προσέχετε ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ Σαδδουκαίων. ");
INSERT INTO grctr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Οἱ δὲ διελογίζοντο ἐν ἑαυτοῖς, λέγοντες ὅτι Ἄρτους οὐκ ἐλάβομεν. ");
INSERT INTO grctr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Γνοὺς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Τί διαλογίζεσθε ἐν ἑαυτοῖς, ὀλιγόπιστοι, ὅτι ἄρτους οὐκ ἐλάβετε; ");
INSERT INTO grctr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Οὔπω νοεῖτε, οὐδὲ μνημονεύετε τοὺς πέντε ἄρτους τῶν πεντακισχιλίων, καὶ πόσους κοφίνους ἐλάβετε; ");
INSERT INTO grctr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Οὐδὲ τοὺς ἑπτὰ ἄρτους τῶν τετρακισχιλίων, καὶ πόσας σπυρίδας ἐλάβετε; ");
INSERT INTO grctr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Πῶς οὐ νοεῖτε, ὅτι οὐ περὶ ἄρτου εἶπον ὑμῖν προσέχειν ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ Σαδδουκαίων; ");
INSERT INTO grctr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Τότε συνῆκαν ὅτι οὐκ εἶπε προσέχειν ἀπὸ τῆς ζύμης τοῦ ἄρτου, ἀλλ᾿ ἀπὸ τῆς διδαχῆς τῶν Φαρισαίων καὶ Σαδδουκαίων. ");
INSERT INTO grctr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ἐλθὼν δὲ ὁ Ἰησοῦς εἰς τὰ μέρη Καισαρείας τῆς Φιλίππου ἠρώτα τοὺς μαθητὰς αὐτοῦ, λέγων, Τίνα με λέγουσιν οἱ ἄνθρωποι εἶναι, τὸν υἱὸν τοῦ ἀνθρώπου; ");
INSERT INTO grctr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Οἱ δὲ εἶπον, Οἱ μὲν Ἰωάννην τὸν βαπτιστήν· ἄλλοι δὲ Ἠλίαν· ἕτεροι δὲ Ἰερεμίαν, ἢ ἕνα τῶν προφητῶν. ");
INSERT INTO grctr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Λέγει αὐτοῖς, Ὑμεῖς δὲ τίνα με λέγετε εἶναι; ");
INSERT INTO grctr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ἀποκριθεὶς δὲ Σίμων Πέτρος εἶπε, Σὺ εἶ ὁ Χριστὸς ὁ υἱὸς τοῦ Θεοῦ τοῦ ζῶντος. ");
INSERT INTO grctr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτῷ, Μακάριος εἶ, Σίμων Βαριωνᾶ, ὅτι σὰρξ καὶ αἷμα οὐκ ἀπεκάλυψέ σοι, ἀλλ᾿ ὁ πατήρ μου ὁ ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Κἀγὼ δέ σοι λέγω, ὅτι σὺ εἶ Πέτρος, καὶ ἐπὶ ταύτῃ τῇ πέτρᾳ οἰκοδομήσω μου τὴν ἐκκλησίαν, καὶ πύλαι ᾍδου οὐ κατισχύσουσιν αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Καὶ δώσω σοὶ τὰς κλεῖς τῆς βασιλείας τῶν οὐρανῶν· καὶ ὃ ἐὰν δήσῃς ἐπὶ τῆς γῆς, ἔσται δεδεμένον ἐν τοῖς οὐρανοῖς· καὶ ὃ ἐὰν λύσῃς ἐπὶ τῆς γῆς, ἔσται λελυμένον ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Τότε διεστείλατο τοῖς μαθηταῖς αὐτοῦ ἵνα μηδενὶ εἴπωσιν ὅτι αὐτός ἐστιν Ἰησοῦς ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ἀπὸ τότε ἤρξατο ὁ Ἰησοῦς δεικνύειν τοῖς μαθηταῖς αὐτοῦ ὅτι δεῖ αὐτὸν ἀπελθεῖν εἰς Ἱεροσόλυμα, καὶ πολλὰ παθεῖν ἀπὸ τῶν πρεσβυτέρων καὶ ἀρχιερέων καὶ γραμματέων, καὶ ἀποκτανθῆναι, καὶ τῇ τρίτῃ ἡμέρᾳ ἐγερθῆναι. ");
INSERT INTO grctr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Καὶ προσλαβόμενος αὐτὸν ὁ Πέτρος ἤρξατο ἐπιτιμᾷν αὐτῷ λέγων, Ἵλεώς σοι, Κύριε· οὐ μὴ ἔσται σοι τοῦτο. ");
INSERT INTO grctr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ὁ δὲ στραφεὶς εἶπε τῷ Πέτρῳ, Ὕπαγε ὀπίσω μου, Σατανᾶ, σκάνδαλόν μου εἶ· ὅτι οὐ φρονεῖς τὰ τοῦ Θεοῦ, ἀλλὰ τὰ τῶν ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Τότε ὁ Ἰησοῦς εἶπε τοῖς μαθηταῖς αὐτοῦ, Εἴ τις θέλει ὀπίσω μου ἐλθεῖν, ἀπαρνησάσθω ἑαυτόν, καὶ ἀράτω τὸν σταυρὸν αὐτοῦ, καὶ ἀκολουθείτω μοι. ");
INSERT INTO grctr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ὃς γὰρ ἂν θέλῃ τὴν ψυχὴν αὐτοῦ σῶσαι, ἀπολέσει αὐτήν· ὃς δ᾿ ἂν ἀπολέσῃ τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ εὑρήσει αὐτήν· ");
INSERT INTO grctr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","τί γὰρ ὠφελεῖται ἄνθρωπος ἐὰν τὸν κόσμον ὅλον κερδήσῃ, τὴν δὲ ψυχὴν αὐτοῦ ζημιωθῇ; Ἢ τί δώσει ἄνθρωπος ἀντάλλαγμα τῆς ψυχῆς αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Μέλλει γὰρ ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεσθαι ἐν τῇ δόξῃ τοῦ πατρὸς αὐτοῦ μετὰ τῶν ἀγγέλων αὐτοῦ, καὶ τότε ἀποδώσει ἑκάστῳ κατὰ τὴν πρᾶξιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ἀμὴν λέγω ὑμῖν, εἰσί τινες τῶν ὧδε ἑστῶτες, οἵτινες οὐ μὴ γεύσωνται θανάτου, ἕως ἂν ἴδωσι τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν τῇ βασιλείᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Καὶ μεθ᾿ ἡμέρας ἓξ παραλαμβάνει ὁ Ἰησοῦς τὸν Πέτρον καὶ Ἰάκωβον καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, καὶ ἀναφέρει αὐτοὺς εἰς ὄρος ὑψηλὸν κατ᾿ ἰδίαν. ");
INSERT INTO grctr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Καὶ μετεμορφώθη ἔμπροσθεν αὐτῶν, καὶ ἔλαμψε τὸ πρόσωπον αὐτοῦ ὡς ὁ ἥλιος, τὰ δὲ ἱμάτια αὐτοῦ ἐγένετο λευκὰ ὡς τὸ φῶς. ");
INSERT INTO grctr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Καὶ ἰδού, ὤφθησαν αὐτοῖς Μωσῆς καὶ Ἠλίας, μετ᾿ αὐτοῦ συλλαλοῦντες. ");
INSERT INTO grctr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ἀποκριθεὶς δὲ ὁ Πέτρος εἶπε τῷ Ἰησοῦ, Κύριε, καλόν ἐστιν ἡμᾶς ὧδε εἶναι· εἰ θέλεις, ποιήσωμεν ὧδε τρεῖς σκηνάς, σοὶ μίαν, καὶ Μωσῇ μίαν, καὶ μίαν Ἠλίᾳ. ");
INSERT INTO grctr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ἔτι αὐτοῦ λαλοῦντος, ἰδού, νεφέλη φωτεινὴ ἐπεσκίασεν αὐτούς· καὶ ἰδού, φωνὴ ἐκ τῆς νεφέλης, λέγουσα, Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός, ἐν ᾧ εὐδόκησα· αὐτοῦ ἀκούετε. ");
INSERT INTO grctr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Καὶ ἀκούσαντες οἱ μαθηταὶ ἔπεσον ἐπὶ πρόσωπον αὐτῶν, καὶ ἐφοβήθησαν σφόδρα. ");
INSERT INTO grctr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Καὶ προσελθὼν ὁ Ἰησοῦς ἥψατο αὐτῶν καὶ εἶπεν, Ἐγέρθητε καὶ μὴ φοβεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ἐπάραντες δὲ τοὺς ὀφθαλμοὺς αὐτῶν, οὐδένα εἶδον, εἰ μὴ τὸν Ἰησοῦν μόνον. ");
INSERT INTO grctr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Καὶ καταβαινόντων αὐτῶν ἀπὸ τοῦ ὄρους, ἐνετείλατο αὐτοῖς ὁ Ἰησοῦς, λέγων, Μηδενὶ εἴπητε τὸ ὅραμα, ἕως οὗ ὁ υἱὸς τοῦ ἀνθρώπου ἐκ νεκρῶν ἀναστῇ. ");
INSERT INTO grctr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Καὶ ἐπηρώτησαν αὐτὸν οἱ μαθηταὶ αὐτοῦ λέγοντες, Τί οὖν οἱ γραμματεῖς λέγουσιν ὅτι Ἠλίαν δεῖ ἐλθεῖν πρῶτον; ");
INSERT INTO grctr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ὁ δὲ Ἰησοῦς ἀποκριθεὶς εἶπεν αὐτοῖς, Ἠλίας μὲν ἔρχεται πρῶτον, καὶ ἀποκαταστήσει πάντα· ");
INSERT INTO grctr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","λέγω δὲ ὑμῖν ὅτι Ἠλίας ἤδη ἦλθε, καὶ οὐκ ἐπέγνωσαν αὐτόν, ἀλλ᾿ ἐποίησαν ἐν αὐτῷ ὅσα ἠθέλησαν· οὕτω καὶ ὁ υἱὸς τοῦ ἀνθρώπου μέλλει πάσχειν ὑπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Τότε συνῆκαν οἱ μαθηταὶ ὅτι περὶ Ἰωάννου τοῦ βαπτιστοῦ εἶπεν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Καὶ ἐλθόντων αὐτῶν πρὸς τὸν ὄχλον, προσῆλθεν αὐτῷ ἄνθρωπος γονυπετῶν αὐτῷ ");
INSERT INTO grctr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","καὶ λέγων, Κύριε, ἐλέησόν μου τὸν υἱόν, ὅτι σεληνιάζεται καὶ κακῶς πάσχει· πολλάκις γὰρ πίπτει εἰς τὸ πῦρ, καὶ πολλάκις εἰς τὸ ὕδωρ. ");
INSERT INTO grctr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Καὶ προσήνεγκα αὐτὸν τοῖς μαθηταῖς σου, καὶ οὐκ ἠδυνήθησαν αὐτὸν θεραπεῦσαι. ");
INSERT INTO grctr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Ὦ γενεὰ ἄπιστος καὶ διεστραμμένη, ἕως πότε ἔσομαι μεθ᾿ ὑμῶν; Ἕως πότε ἀνέξομαι ὑμῶν; Φέρετέ μοι αὐτὸν ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς, καὶ ἐξῆλθεν ἀπ᾿ αὐτοῦ τὸ δαιμόνιον, καὶ ἐθεραπεύθη ὁ παῖς ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grctr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Τότε προσελθόντες οἱ μαθηταὶ τῷ Ἰησοῦ κατ᾿ ἰδίαν εἶπον, Διὰ τί ἡμεῖς οὐκ ἠδυνήθημεν ἐκβαλεῖν αὐτό; ");
INSERT INTO grctr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Διὰ τὴν ἀπιστίαν ὑμῶν. Ἀμὴν γὰρ λέγω ὑμῖν, ἐὰν ἔχητε πίστιν ὡς κόκκον σινάπεως, ἐρεῖτε τῷ ὄρει τούτῳ, Μετάβηθι ἐντεῦθεν ἐκεῖ, καὶ μεταβήσεται· καὶ οὐδὲν ἀδυνατήσει ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Τοῦτο δὲ τὸ γένος οὐκ ἐκπορεύεται εἰ μὴ ἐν προσευχῇ καὶ νηστείᾳ. ");
INSERT INTO grctr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ἀναστρεφομένων δὲ αὐτῶν ἐν τῇ Γαλιλαίᾳ, εἶπεν αὐτοῖς ὁ Ἰησοῦς, Μέλλει ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοσθαι εἰς χεῖρας ἀνθρώπων, ");
INSERT INTO grctr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","καὶ ἀποκτενοῦσιν αὐτόν, καὶ τῇ τρίτῃ ἡμέρᾳ ἐγερθήσεται. Καὶ ἐλυπήθησαν σφόδρα. ");
INSERT INTO grctr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ἐλθόντων δὲ αὐτῶν εἰς Καπερναούμ, προσῆλθον οἱ τὰ δίδραχμα λαμβάνοντες τῷ Πέτρῳ καὶ εἶπον, Ὁ διδάσκαλος ὑμῶν οὐ τελεῖ τὰ δίδραχμα; ");
INSERT INTO grctr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Λέγει, Ναί. Καὶ ὅτε εἰσῆλθεν εἰς τὴν οἰκίαν, προέφθασεν αὐτὸν ὁ Ἰησοῦς, λέγων, Τί σοι δοκεῖ, Σίμων; Οἱ βασιλεῖς τῆς γῆς ἀπὸ τίνων λαμβάνουσι τέλη ἢ κῆνσον; Ἀπὸ τῶν υἱῶν αὐτῶν, ἢ ἀπὸ τῶν ἀλλοτρίων; ");
INSERT INTO grctr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Λέγει αὐτῷ ὁ Πέτρος, Ἀπὸ τῶν ἀλλοτρίων. Ἔφη αὐτῷ ὁ Ἰησοῦς, Ἄρα γε ἐλεύθεροί εἰσιν οἱ υἱοί. ");
INSERT INTO grctr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ἵνα δὲ μὴ σκανδαλίσωμεν αὐτούς, πορευθεὶς εἰς τὴν θάλασσαν βάλε ἄγκιστρον, καὶ τὸν ἀναβάντα πρῶτον ἰχθὺν ἆρον· καὶ ἀνοίξας τὸ στόμα αὐτοῦ, εὑρήσεις στατῆρα· ἐκεῖνον λαβὼν δὸς αὐτοῖς ἀντὶ ἐμοῦ καὶ σοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ἐν ἐκείνῃ τῇ ὥρᾳ προσῆλθον οἱ μαθηταὶ τῷ Ἰησοῦ, λέγοντες, Τίς ἄρα μείζων ἐστὶν ἐν τῇ βασιλείᾳ τῶν οὐρανῶν; ");
INSERT INTO grctr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Καὶ προσκαλεσάμενος ὁ Ἰησοῦς παιδίον ἔστησεν αὐτὸ ἐν μέσῳ αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","καὶ εἶπεν, Ἀμὴν λέγω ὑμῖν, ἐὰν μὴ στραφῆτε καὶ γένησθε ὡς τὰ παιδία, οὐ μὴ εἰσέλθητε εἰς τὴν βασιλείαν τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ὅστις οὖν ταπεινώσῃ ἑαυτὸν ὡς τὸ παιδίον τοῦτο, οὗτός ἐστιν ὁ μείζων ἐν τῇ βασιλείᾳ τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Καὶ ὃς ἐὰν δέξηται παιδίον τοιοῦτον ἓν ἐπὶ τῷ ὀνόματί μου, ἐμὲ δέχεται· ");
INSERT INTO grctr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ὃς δ᾿ ἂν σκανδαλίσῃ ἕνα τῶν μικρῶν τούτων τῶν πιστευόντων εἰς ἐμέ, συμφέρει αὐτῷ ἵνα κρεμασθῇ μύλος ὀνικὸς ἐπὶ τὸν τράχηλον αὐτοῦ, καὶ καταποντισθῇ ἐν τῷ πελάγει τῆς θαλάσσης. ");
INSERT INTO grctr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Οὐαὶ τῷ κόσμῳ ἀπὸ τῶν σκανδάλων· ἀνάγκη γάρ ἐστιν ἐλθεῖν τὰ σκάνδαλα· πλὴν οὐαὶ τῷ ἀνθρώπῳ ἐκείνῳ, δι᾿ οὗ τὸ σκάνδαλον ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Εἰ δὲ ἡ χείρ σου ἢ ὁ πούς σου σκανδαλίζει σε, ἔκκοψον αὐτὰ καὶ βάλε ἀπὸ σοῦ· καλόν σοι ἐστὶν εἰσελθεῖν εἰς τὴν ζωὴν χωλὸν ἢ κυλλόν, ἢ δύο χεῖρας ἢ δύο πόδας ἔχοντα βληθῆναι εἰς τὸ πῦρ τὸ αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Καὶ εἰ ὁ ὀφθαλμός σου σκανδαλίζει σε, ἔξελε αὐτὸν καὶ βάλε ἀπὸ σοῦ· καλόν σοι ἐστὶ μονόφθαλμον εἰς τὴν ζωὴν εἰσελθεῖν, ἢ δύο ὀφθαλμοὺς ἔχοντα βληθῆναι εἰς τὴν γέενναν τοῦ πυρός. ");
INSERT INTO grctr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ὁρᾶτε μὴ καταφρονήσητε ἑνὸς τῶν μικρῶν τούτων, λέγω γὰρ ὑμῖν ὅτι οἱ ἄγγελοι αὐτῶν ἐν οὐρανοῖς διὰ παντὸς βλέπουσι τὸ πρόσωπον τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ἦλθε γὰρ ὁ υἱὸς τοῦ ἀνθρώπου σῶσαι τὸ ἀπολωλός. ");
INSERT INTO grctr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Τί ὑμῖν δοκεῖ; Ἐὰν γένηταί τινι ἀνθρώπῳ ἑκατὸν πρόβατα, καὶ πλανηθῇ ἓν ἐξ αὐτῶν· οὐχὶ ἀφεὶς τὰ ἐννενηκονταεννέα, ἐπὶ τὰ ὄρη πορευθεὶς ζητεῖ τὸ πλανώμενον; ");
INSERT INTO grctr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Καὶ ἐὰν γένηται εὑρεῖν αὐτό, ἀμὴν λέγω ὑμῖν ὅτι χαίρει ἐπ᾿ αὐτῷ μᾶλλον, ἢ ἐπὶ τοῖς ἐννενηκονταεννέα τοῖς μὴ πεπλανημένοις. ");
INSERT INTO grctr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Οὕτως οὐκ ἔστι θέλημα ἔμπροσθεν τοῦ πατρὸς ὑμῶν τοῦ ἐν οὐρανοῖς, ἵνα ἀπόληται εἷς τῶν μικρῶν τούτων. ");
INSERT INTO grctr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ἐὰν δὲ ἁμαρτήσῃ εἰς σὲ ὁ ἀδελφός σου, ὕπαγε καὶ ἔλεγξον αὐτὸν μεταξὺ σοῦ καὶ αὐτοῦ μόνου. Ἐάν σου ἀκούσῃ, ἐκέρδησας τὸν ἀδελφόν σου· ");
INSERT INTO grctr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ἐὰν δὲ μὴ ἀκούσῃ, παράλαβε μετὰ σοῦ ἔτι ἕνα ἢ δύο, ἵνα ἐπὶ στόματος δύο μαρτύρων ἢ τριῶν σταθῇ πᾶν ῥῆμα· ");
INSERT INTO grctr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ἐὰν δὲ παρακούσῃ αὐτῶν, εἰπὲ τῇ ἐκκλησίᾳ· ἐὰν δὲ καὶ τῆς ἐκκλησίας παρακούσῃ, ἔστω σοι ὥσπερ ὁ ἐθνικὸς καὶ ὁ τελώνης. ");
INSERT INTO grctr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ἀμὴν λέγω ὑμῖν, ὅσα ἐὰν δήσητε ἐπὶ τῆς γῆς, ἔσται δεδεμένα ἐν τῷ οὐρανῷ· καὶ ὅσα ἐὰν λύσητε ἐπὶ τῆς γῆς, ἔσται λελυμένα ἐν τῷ οὐρανῷ. ");
INSERT INTO grctr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Πάλιν λέγω ὑμῖν ὅτι ἐὰν δύο ὑμῶν συμφωνήσωσιν ἐπὶ τῆς γῆς περὶ παντὸς πράγματος οὗ ἐὰν αἰτήσωνται, γενήσεται αὐτοῖς παρὰ τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Οὗ γάρ εἰσι δύο ἢ τρεῖς συνηγμένοι εἰς τὸ ἐμὸν ὄνομα, ἐκεῖ εἰμὶ ἐν μέσῳ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Τότε προσελθὼν αὐτῷ ὁ Πέτρος εἶπε, Κύριε, ποσάκις ἁμαρτήσει εἰς ἐμὲ ὁ ἀδελφός μου, καὶ ἀφήσω αὐτῷ; Ἕως ἑπτάκις; ");
INSERT INTO grctr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Λέγει αὐτῷ ὁ Ἰησοῦς, Οὐ λέγω σοι ἕως ἑπτάκις, ἀλλ᾿ ἕως ἑβδομηκοντάκις ἑπτά. ");
INSERT INTO grctr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Διὰ τοῦτο ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ βασιλεῖ, ὃς ἠθέλησε συνᾶραι λόγον μετὰ τῶν δούλων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ἀρξαμένου δὲ αὐτοῦ συναίρειν, προσηνέχθη αὐτῷ εἷς ὀφειλέτης μυρίων ταλάντων. ");
INSERT INTO grctr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Μὴ ἔχοντος δὲ αὐτοῦ ἀποδοῦναι ἐκέλευσεν αὐτὸν ὁ κύριος αὐτοῦ πραθῆναι, καὶ τὴν γυναῖκα αὐτοῦ καὶ τὰ τέκνα, καὶ πάντα ὅσα εἶχε, καὶ ἀποδοθῆναι. ");
INSERT INTO grctr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Πεσὼν οὖν ὁ δοῦλος προσεκύνει αὐτῷ, λέγων, Κύριε, μακροθύμησον ἐπ᾿ ἐμοί, καὶ πάντα σοι ἀποδώσω. ");
INSERT INTO grctr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Σπλαγχνισθεὶς δὲ ὁ κύριος τοῦ δούλου ἐκείνου ἀπέλυσεν αὐτόν, καὶ τὸ δάνειον ἀφῆκεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ἐξελθὼν δὲ ὁ δοῦλος ἐκεῖνος εὗρεν ἕνα τῶν συνδούλων αὐτοῦ, ὃς ὤφειλεν αὐτῷ ἑκατὸν δηνάρια, καὶ κρατήσας αὐτὸν ἔπνιγε, λέγων, Ἀπόδος μοι ὅ τι ὀφείλεις. ");
INSERT INTO grctr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Πεσὼν οὖν ὁ σύνδουλος αὐτοῦ εἰς τοὺς πόδας αὐτοῦ παρεκάλει αὐτόν, λέγων, Μακροθύμησον ἐπ᾿ ἐμοί, καὶ πάντα ἀποδώσω σοι. ");
INSERT INTO grctr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ὁ δὲ οὐκ ἤθελεν, ἀλλ᾿ ἀπελθὼν ἔβαλεν αὐτὸν εἰς φυλακήν, ἕως οὗ ἀποδῷ τὸ ὀφειλόμενον. ");
INSERT INTO grctr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ἰδόντες δὲ οἱ σύνδουλοι αὐτοῦ τὰ γενόμενα ἐλυπήθησαν σφόδρα· καὶ ἐλθόντες διεσάφησαν τῷ κυρίῳ αὐτῶν πάντα τὰ γενόμενα. ");
INSERT INTO grctr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Τότε προσκαλεσάμενος αὐτὸν ὁ κύριος αὐτοῦ λέγει αὐτῷ, Δοῦλε πονηρέ, πᾶσαν τὴν ὀφειλὴν ἐκείνην ἀφῆκά σοι, ἐπεὶ παρεκάλεσάς με· ");
INSERT INTO grctr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","οὐκ ἔδει καὶ σὲ ἐλεῆσαι τὸν σύνδουλόν σου, ὡς καὶ ἐγώ σε ἠλέησα; ");
INSERT INTO grctr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Καὶ ὀργισθεὶς ὁ κύριος αὐτοῦ παρέδωκεν αὐτὸν τοῖς βασανισταῖς, ἕως οὗ ἀποδῷ πᾶν τὸ ὀφειλόμενον αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Οὕτω καὶ ὁ πατήρ μου ὁ ἐπουράνιος ποιήσει ὑμῖν, ἐὰν μὴ ἀφῆτε ἕκαστος τῷ ἀδελφῷ αὐτοῦ ἀπὸ τῶν καρδιῶν ὑμῶν τὰ παραπτώματα αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς τοὺς λόγους τούτους, μετῆρεν ἀπὸ τῆς Γαλιλαίας, καὶ ἦλθεν εἰς τὰ ὅρια τῆς Ἰουδαίας πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grctr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Καὶ ἠκολούθησαν αὐτῷ ὄχλοι πολλοί, καὶ ἐθεράπευσεν αὐτοὺς ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Καὶ προσῆλθον αὐτῷ οἱ Φαρισαῖοι πειράζοντες αὐτόν, καὶ λέγοντες αὐτῷ, Εἰ ἔξεστιν ἀνθρώπῳ ἀπολῦσαι τὴν γυναῖκα αὐτοῦ κατὰ πᾶσαν αἰτίαν; ");
INSERT INTO grctr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Οὐκ ἀνέγνωτε ὅτι ὁ ποιήσας ἀπ᾿ ἀρχῆς ἄρσεν καὶ θῆλυ ἐποίησεν αὐτούς, ");
INSERT INTO grctr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","καὶ εἶπεν, Ἕνεκεν τούτου καταλείψει ἄνθρωπος τὸν πατέρα καὶ τὴν μητέρα, καὶ προσκολληθήσεται τῇ γυναικὶ αὐτοῦ, καὶ ἔσονται οἱ δύο εἰς σάρκα μίαν; ");
INSERT INTO grctr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ὥστε οὐκέτι εἰσὶ δύο, ἀλλὰ σὰρξ μία. Ὃ οὖν ὁ Θεὸς συνέζευξεν, ἄνθρωπος μὴ χωριζέτω. ");
INSERT INTO grctr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Λέγουσιν αὐτῷ, Τί οὖν Μωσῆς ἐνετείλατο δοῦναι βιβλίον ἀποστασίου, καὶ ἀπολῦσαι αὐτήν; ");
INSERT INTO grctr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Λέγει αὐτοῖς ὅτι Μωσῆς πρὸς τὴν σκληροκαρδίαν ὑμῶν ἐπέτρεψεν ὑμῖν ἀπολῦσαι τὰς γυναῖκας ὑμῶν· ἀπ᾿ ἀρχῆς δὲ οὐ γέγονεν οὕτω. ");
INSERT INTO grctr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Λέγω δὲ ὑμῖν ὅτι ὃς ἂν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ, εἰ μὴ ἐπὶ πορνείᾳ, καὶ γαμήσῃ ἄλλην, μοιχᾶται· καὶ ὁ ἀπολελυμένην γαμήσας μοιχᾶται. ");
INSERT INTO grctr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Λέγουσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ, Εἰ οὕτως ἐστὶν ἡ αἰτία τοῦ ἀνθρώπου μετὰ τῆς γυναικός, οὐ συμφέρει γαμῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ὁ δὲ εἶπεν αὐτοῖς, Οὐ πάντες χωροῦσι τὸν λόγον τοῦτον, ἀλλ᾿ οἷς δέδοται. ");
INSERT INTO grctr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Εἰσὶ γὰρ εὐνοῦχοι, οἵτινες ἐκ κοιλίας μητρὸς ἐγεννήθησαν οὕτω· καί εἰσιν εὐνοῦχοι, οἵτινες εὐνουχίσθησαν ὑπὸ τῶν ἀνθρώπων· καί εἰσιν εὐνοῦχοι, οἵτινες εὐνούχισαν ἑαυτοὺς διὰ τὴν βασιλείαν τῶν οὐρανῶν. Ὁ δυνάμενος χωρεῖν χωρείτω. ");
INSERT INTO grctr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Τότε προσηνέχθη αὐτῷ παιδία, ἵνα τὰς χεῖρας ἐπιθῇ αὐτοῖς, καὶ προσεύξηται· οἱ δὲ μαθηταὶ ἐπετίμησαν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ὁ δὲ Ἰησοῦς εἶπεν, Ἄφετε τὰ παιδία, καὶ μὴ κωλύετε αὐτὰ ἐλθεῖν πρός με· τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Καὶ ἐπιθεὶς αὐτοῖς τὰς χεῖρας, ἐπορεύθη ἐκεῖθεν. ");
INSERT INTO grctr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Καὶ ἰδού, εἷς προσελθὼν εἶπεν αὐτῷ, Διδάσκαλε ἀγαθέ, τί ἀγαθὸν ποιήσω, ἵνα ἔχω ζωὴν αἰώνιον; ");
INSERT INTO grctr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ὁ δὲ εἶπεν αὐτῷ, Τί με λέγεις ἀγαθόν; Οὐδεὶς ἀγαθός, εἰ μὴ εἷς, ὁ Θεός. Εἰ δὲ θέλεις εἰσελθεῖν εἰς τὴν ζωήν, τήρησον τὰς ἐντολάς. ");
INSERT INTO grctr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Λέγει αὐτῷ, Ποίας; Ὁ δὲ Ἰησοῦς εἶπε, Τὸ Οὐ φονεύσεις· οὐ μοιχεύσεις· οὐ κλέψεις· οὐ ψευδομαρτυρήσεις· ");
INSERT INTO grctr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","τίμα τὸν πατέρα σου καὶ τὴν μητέρα· καί, ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grctr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Λέγει αὐτῷ ὁ νεανίσκος, Πάντα ταῦτα ἐφυλαξάμην ἐκ νεότητός μου· τί ἔτι ὑστερῶ; ");
INSERT INTO grctr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ἔφη αὐτῷ ὁ Ἰησοῦς, Εἰ θέλεις τέλειος εἶναι, ὕπαγε, πώλησόν σου τὰ ὑπάρχοντα καὶ δὸς πτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν οὐρανῷ· καὶ δεῦρο, ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ἀκούσας δὲ ὁ νεανίσκος τὸν λόγον ἀπῆλθε λυπούμενος· ἦν γὰρ ἔχων κτήματα πολλά. ");
INSERT INTO grctr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ὁ δὲ Ἰησοῦς εἶπε τοῖς μαθηταῖς αὐτοῦ, Ἀμὴν λέγω ὑμῖν ὅτι δυσκόλως πλούσιος εἰσελεύσεται εἰς τὴν βασιλείαν τῶν οὐρανῶν. ");
INSERT INTO grctr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Πάλιν δὲ λέγω ὑμῖν, εὐκοπώτερόν ἐστι κάμηλον διὰ τρυπήματος ῥαφίδος διελθεῖν, ἢ πλούσιον εἰς τὴν βασιλείαν τοῦ Θεοῦ εἰσελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ἀκούσαντες δὲ οἱ μαθηταὶ αὐτοῦ ἐξεπλήσσοντο σφόδρα, λέγοντες, Τίς ἄρα δύναται σωθῆναι; ");
INSERT INTO grctr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ἐμβλέψας δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Παρὰ ἀνθρώποις τοῦτο ἀδύνατόν ἐστι, παρὰ δὲ Θεῷ πάντα δυνατά ἐστι. ");
INSERT INTO grctr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Τότε ἀποκριθεὶς ὁ Πέτρος εἶπεν αὐτῷ, Ἰδού, ἡμεῖς ἀφήκαμεν πάντα καὶ ἠκολουθήσαμέν σοι· τί ἄρα ἔσται ἡμῖν; ");
INSERT INTO grctr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Ἀμὴν λέγω ὑμῖν ὅτι ὑμεῖς οἱ ἀκολουθήσαντές μοι, ἐν τῇ παλιγγενεσίᾳ ὅταν καθίσῃ ὁ υἱὸς τοῦ ἀνθρώπου ἐπὶ θρόνου δόξης αὐτοῦ, καθίσεσθε καὶ ὑμεῖς ἐπὶ δώδεκα θρόνους, κρίνοντες τὰς δώδεκα φυλὰς τοῦ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Καὶ πᾶς ὃς ἀφῆκεν οἰκίας, ἢ ἀδελφούς, ἢ ἀδελφάς, ἢ πατέρα, ἢ μητέρα, ἢ γυναῖκα, ἢ τέκνα, ἢ ἀγρούς, ἕνεκεν τοῦ ὀνόματός μου, ἑκατονταπλασίονα λήψεται, καὶ ζωὴν αἰώνιον κληρονομήσει. ");
INSERT INTO grctr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Πολλοὶ δὲ ἔσονται πρῶτοι ἔσχατοι, καὶ ἔσχατοι πρῶτοι. ");
INSERT INTO grctr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ὁμοία γάρ ἐστιν ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ οἰκοδεσπότῃ, ὅστις ἐξῆλθεν ἅμα πρωῒ μισθώσασθαι ἐργάτας εἰς τὸν ἀμπελῶνα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Συμφωνήσας δὲ μετὰ τῶν ἐργατῶν ἐκ δηναρίου τὴν ἡμέραν, ἀπέστειλεν αὐτοὺς εἰς τὸν ἀμπελῶνα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Καὶ ἐξελθὼν περὶ τὴν τρίτην ὥραν, εἶδεν ἄλλους ἑστῶτας ἐν τῇ ἀγορᾷ ἀργούς· ");
INSERT INTO grctr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","κἀκείνοις εἶπεν, Ὑπάγετε καὶ ὑμεῖς εἰς τὸν ἀμπελῶνα, καὶ ὃ ἐὰν ᾖ δίκαιον δώσω ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Οἱ δὲ ἀπῆλθον. Πάλιν ἐξελθὼν περὶ ἕκτην καὶ ἐννάτην ὥραν, ἐποίησεν ὡσαύτως. ");
INSERT INTO grctr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Περὶ δὲ τὴν ἑνδεκάτην ὥραν ἐξελθών, εὗρεν ἄλλους ἑστῶτας ἀργούς, καὶ λέγει αὐτοῖς, Τί ὧδε ἑστήκατε ὅλην τὴν ἡμέραν ἀργοί; ");
INSERT INTO grctr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Λέγουσιν αὐτῷ, Ὅτι οὐδεὶς ἡμᾶς ἐμισθώσατο. Λέγει αὐτοῖς, Ὑπάγετε καὶ ὑμεῖς εἰς τὸν ἀμπελῶνα, καὶ ὃ ἐὰν ᾖ δίκαιον λήψεσθε. ");
INSERT INTO grctr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ὀψίας δὲ γενομένης λέγει ὁ κύριος τοῦ ἀμπελῶνος τῷ ἐπιτρόπῳ αὐτοῦ, Κάλεσον τοὺς ἐργάτας, καὶ ἀπόδος αὐτοῖς τὸν μισθόν, ἀρξάμενος ἀπὸ τῶν ἐσχάτων ἕως τῶν πρώτων. ");
INSERT INTO grctr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Καὶ ἐλθόντες οἱ περὶ τὴν ἑνδεκάτην ὥραν ἔλαβον ἀνὰ δηνάριον. ");
INSERT INTO grctr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ἐλθόντες δὲ οἱ πρῶτοι ἐνόμισαν ὅτι πλείονα λήψονται· καὶ ἔλαβον καὶ αὐτοὶ ἀνὰ δηνάριον. ");
INSERT INTO grctr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Λαβόντες δὲ ἐγόγγυζον κατὰ τοῦ οἰκοδεσπότου, ");
INSERT INTO grctr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","λέγοντες ὅτι Οὗτοι οἱ ἔσχατοι μίαν ὥραν ἐποίησαν, καὶ ἴσους ἡμῖν αὐτοὺς ἐποίησας, τοῖς βαστάσασι τὸ βάρος τῆς ἡμέρας καὶ τὸν καύσωνα. ");
INSERT INTO grctr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ὁ δὲ ἀποκριθεὶς εἶπεν ἑνὶ αὐτῶν, Ἑταῖρε, οὐκ ἀδικῶ σε· οὐχὶ δηναρίου συνεφώνησάς μοι; ");
INSERT INTO grctr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ἆρον τὸ σὸν καὶ ὕπαγε· θέλω δὲ τούτῳ τῷ ἐσχάτῳ δοῦναι ὡς καὶ σοί. ");
INSERT INTO grctr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ἢ οὐκ ἔξεστί μοι ποιῆσαι ὃ θέλω ἐν τοῖς ἐμοῖς; Εἰ ὁ ὀφθαλμός σου πονηρός ἐστιν, ὅτι ἐγὼ ἀγαθός εἰμι; ");
INSERT INTO grctr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Οὕτως ἔσονται οἱ ἔσχατοι πρῶτοι, καὶ οἱ πρῶτοι ἔσχατοι· πολλοὶ γάρ εἰσι κλητοί, ὀλίγοι δὲ ἐκλεκτοί. ");
INSERT INTO grctr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Καὶ ἀναβαίνων ὁ Ἰησοῦς εἰς Ἱεροσόλυμα παρέλαβε τοὺς δώδεκα μαθητὰς κατ᾿ ἰδίαν ἐν τῇ ὁδῷ, καὶ εἶπεν αὐτοῖς, ");
INSERT INTO grctr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ἰδού, ἀναβαίνομεν εἰς Ἱεροσόλυμα, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδοθήσεται τοῖς ἀρχιερεῦσι καὶ γραμματεῦσι, καὶ κατακρινοῦσιν αὐτὸν θανάτῳ, ");
INSERT INTO grctr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","καὶ παραδώσουσιν αὐτὸν τοῖς ἔθνεσιν εἰς τὸ ἐμπαῖξαι καὶ μαστιγῶσαι καὶ σταυρῶσαι· καὶ τῇ τρίτῃ ἡμέρᾳ ἀναστήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Τότε προσῆλθεν αὐτῷ ἡ μήτηρ τῶν υἱῶν Ζεβεδαίου μετὰ τῶν υἱῶν αὐτῆς, προσκυνοῦσα καὶ αἰτοῦσά τι παρ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ὁ δὲ εἶπεν αὐτῇ, Τί θέλεις; Λέγει αὐτῷ, Εἰπὲ ἵνα καθίσωσιν οὗτοι οἱ δύο υἱοί μου, εἷς ἐκ δεξιῶν σου, καὶ εἷς ἐξ εὐωνύμων, ἐν τῇ βασιλείᾳ σου. ");
INSERT INTO grctr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Οὐκ οἴδατε τί αἰτεῖσθε. Δύνασθε πιεῖν τὸ ποτήριον ὃ ἐγὼ μέλλω πίνειν, καὶ τὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθῆναι; Λέγουσιν αὐτῷ, Δυνάμεθα. ");
INSERT INTO grctr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Καὶ λέγει αὐτοῖς, Τὸ μὲν ποτήριόν μου πίεσθε, καὶ τὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθήσεσθε· τὸ δὲ καθίσαι ἐκ δεξιῶν μου καὶ ἐξ εὐωνύμων μου οὐκ ἔστιν ἐμὸν δοῦναι, ἀλλ᾿ οἷς ἡτοίμασται ὑπὸ τοῦ πατρός μου. ");
INSERT INTO grctr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Καὶ ἀκούσαντες οἱ δέκα ἠγανάκτησαν περὶ τῶν δύο ἀδελφῶν. ");
INSERT INTO grctr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ὁ δὲ Ἰησοῦς προσκαλεσάμενος αὐτοὺς εἶπεν, Οἴδατε ὅτι οἱ ἄρχοντες τῶν ἐθνῶν κατακυριεύουσιν αὐτῶν, καὶ οἱ μεγάλοι κατεξουσιάζουσιν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Οὐχ οὕτω δὲ ἔσται ἐν ὑμῖν· ἀλλ᾿ ὃς ἐὰν θέλῃ ἐν ὑμῖν μέγας γενέσθαι ἔστω ὑμῶν διάκονος· ");
INSERT INTO grctr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","καὶ ὃς ἐὰν θέλῃ ἐν ὑμῖν εἶναι πρῶτος, ἔστω ὑμῶν δοῦλος· ");
INSERT INTO grctr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ὥσπερ ὁ υἱὸς τοῦ ἀνθρώπου οὐκ ἦλθε διακονηθῆναι, ἀλλὰ διακονῆσαι, καὶ δοῦναι τὴν ψυχὴν αὐτοῦ λύτρον ἀντὶ πολλῶν. ");
INSERT INTO grctr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Καὶ ἐκπορευομένων αὐτῶν ἀπὸ Ἰεριχώ, ἠκολούθησεν αὐτῷ ὄχλος πολύς. ");
INSERT INTO grctr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Καὶ ἰδού, δύο τυφλοὶ καθήμενοι παρὰ τὴν ὁδόν, ἀκούσαντες ὅτι Ἰησοῦς παράγει, ἔκραξαν, λέγοντες, Ἐλέησον ἡμᾶς, Κύριε, υἱὸς Δαβίδ. ");
INSERT INTO grctr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ὁ δὲ ὄχλος ἐπετίμησεν αὐτοῖς ἵνα σιωπήσωσιν. Οἱ δὲ μεῖζον ἔκραζον, λέγοντες, Ἐλέησον ἡμᾶς, Κύριε, υἱὸς Δαβίδ. ");
INSERT INTO grctr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Καὶ στὰς ὁ Ἰησοῦς ἐφώνησεν αὐτούς, καὶ εἶπε, Τί θέλετε ποιήσω ὑμῖν; ");
INSERT INTO grctr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Λέγουσιν αὐτῷ, Κύριε, ἵνα ἀνοιχθῶσιν ἡμῶν οἱ ὀφθαλμοί. ");
INSERT INTO grctr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Σπλαγχνισθεὶς δὲ ὁ Ἰησοῦς ἥψατο τῶν ὀφθαλμῶν αὐτῶν· καὶ εὐθέως ἀνέβλεψαν αὐτῶν οἱ ὀφθαλμοί, καὶ ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Καὶ ὅτε ἤγγισαν εἰς Ἱεροσόλυμα, καὶ ἦλθον εἰς Βηθφαγὴ πρὸς τὸ ὄρος τῶν Ἐλαιῶν, τότε ὁ Ἰησοῦς ἀπέστειλε δύο μαθητάς, ");
INSERT INTO grctr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","λέγων αὐτοῖς, Πορεύθητε εἰς τὴν κώμην τὴν ἀπέναντι ὑμῶν, καὶ εὐθέως εὑρήσετε ὄνον δεδεμένην, καὶ πῶλον μετ᾿ αὐτῆς· λύσαντες ἀγάγετέ μοι. ");
INSERT INTO grctr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Καὶ ἐάν τις ὑμῖν εἴπῃ τι, ἐρεῖτε ὅτι Ὁ Κύριος αὐτῶν χρείαν ἔχει· εὐθέως δὲ ἀποστελεῖ αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Τοῦτο δὲ ὅλον γέγονεν, ἵνα πληρωθῇ τὸ ῥηθὲν διὰ τοῦ προφήτου, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Εἴπατε τῇ θυγατρὶ Σιών, Ἰδού, ὁ βασιλεύς σου ἔρχεταί σοι, πραῢς καὶ ἐπιβεβηκὼς ἐπὶ ὄνον καὶ πῶλον υἱὸν ὑποζυγίου. ");
INSERT INTO grctr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Πορευθέντες δὲ οἱ μαθηταί, καὶ ποιήσαντες καθὼς προσέταξεν αὐτοῖς ὁ Ἰησοῦς, ");
INSERT INTO grctr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ἤγαγον τὴν ὄνον καὶ τὸν πῶλον· καὶ ἐπέθηκαν ἐπάνω αὐτῶν τὰ ἱμάτια αὐτῶν, καὶ ἐπεκάθισαν ἐπάνω αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ὁ δὲ πλεῖστος ὄχλος ἔστρωσαν ἑαυτῶν τὰ ἱμάτια ἐν τῇ ὁδῷ· ἄλλοι δὲ ἔκοπτον κλάδους ἀπὸ τῶν δένδρων, καὶ ἐστρώννυον ἐν τῇ ὁδῷ. ");
INSERT INTO grctr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Οἱ δὲ ὄχλοι οἱ προάγοντες καὶ οἱ ἀκολουθοῦντες ἔκραζον, λέγοντες, Ὡσαννὰ τῷ υἱῷ Δαβίδ· εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι Κυρίου. Ὡσαννὰ ἐν τοῖς ὑψίστοις. ");
INSERT INTO grctr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Καὶ εἰσελθόντος αὐτοῦ εἰς Ἱεροσόλυμα, ἐσείσθη πᾶσα ἡ πόλις, λέγουσα, Τίς ἐστιν οὗτος; ");
INSERT INTO grctr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Οἱ δὲ ὄχλοι ἔλεγον, Οὗτός ἐστιν Ἰησοῦς ὁ προφήτης, ὁ ἀπὸ Ναζαρὲθ τῆς Γαλιλαίας. ");
INSERT INTO grctr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Καὶ εἰσῆλθεν ὁ Ἰησοῦς εἰς τὸ ἱερὸν τοῦ Θεοῦ, καὶ ἐξέβαλε πάντας τοὺς πωλοῦντας καὶ ἀγοράζοντας ἐν τῷ ἱερῷ, καὶ τὰς τραπέζας τῶν κολλυβιστῶν κατέστρεψε, καὶ τὰς καθέδρας τῶν πωλούντων τὰς περιστεράς. ");
INSERT INTO grctr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Καὶ λέγει αὐτοῖς, Γέγραπται, Ὁ οἶκός μου οἶκος προσευχῆς κληθήσεται· ὑμεῖς δὲ αὐτὸν ἐποιήσατε σπήλαιον λῃστῶν. ");
INSERT INTO grctr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Καὶ προσῆλθον αὐτῷ τυφλοὶ καὶ χωλοὶ ἐν τῷ ἱερῷ· καὶ ἐθεράπευσεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ἰδόντες δὲ οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς τὰ θαυμάσια ἃ ἐποίησε, καὶ τοὺς παῖδας κράζοντας ἐν τῷ ἱερῷ, καὶ λέγοντας, Ὡσαννὰ τῷ υἱῷ Δαβίδ, ἠγανάκτησαν, ");
INSERT INTO grctr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","καὶ εἶπον αὐτῷ, Ἀκούεις τί οὗτοι λέγουσιν; Ὁ δὲ Ἰησοῦς λέγει αὐτοῖς, Ναί· οὐδέποτε ἀνέγνωτε ὅτι Ἐκ στόματος νηπίων καὶ θηλαζόντων κατηρτίσω αἶνον; ");
INSERT INTO grctr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Καὶ καταλιπὼν αὐτοὺς ἐξῆλθεν ἔξω τῆς πόλεως εἰς Βηθανίαν, καὶ ηὐλίσθη ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Πρωΐας δὲ ἐπανάγων εἰς τὴν πόλιν, ἐπείνασε. ");
INSERT INTO grctr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Καὶ ἰδὼν συκῆν μίαν ἐπὶ τῆς ὁδοῦ, ἦλθεν ἐπ᾿ αὐτήν, καὶ οὐδὲν εὗρεν ἐν αὐτῇ εἰ μὴ φύλλα μόνον· καὶ λέγει αὐτῇ, Μηκέτι ἐκ σοῦ καρπὸς γένηται εἰς τὸν αἰῶνα. Καὶ ἐξηράνθη παραχρῆμα ἡ συκῆ. ");
INSERT INTO grctr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Καὶ ἰδόντες οἱ μαθηταὶ ἐθαύμασαν, λέγοντες, Πῶς παραχρῆμα ἐξηράνθη ἡ συκῆ; ");
INSERT INTO grctr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Ἀμὴν λέγω ὑμῖν, ἐὰν ἔχητε πίστιν, καὶ μὴ διακριθῆτε, οὐ μόνον τὸ τῆς συκῆς ποιήσετε, ἀλλὰ κἂν τῷ ὄρει τούτῳ εἴπητε, Ἄρθητι, καὶ βλήθητι εἰς τὴν θάλασσαν, γενήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Καὶ πάντα ὅσα ἂν αἰτήσητε ἐν τῇ προσευχῇ, πιστεύοντες, λήψεσθε. ");
INSERT INTO grctr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Καὶ ἐλθόντι αὐτῷ εἰς τὸ ἱερόν, προσῆλθον αὐτῷ διδάσκοντι οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τοῦ λαοῦ, λέγοντες, Ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς; Καὶ τίς σοι ἔδωκε τὴν ἐξουσίαν ταύτην; ");
INSERT INTO grctr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Ἐρωτήσω ὑμᾶς κἀγὼ λόγον ἕνα, ὃν ἐὰν εἴπητέ μοι, κἀγὼ ὑμῖν ἐρῶ ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Τὸ βάπτισμα Ἰωάννου πόθεν ἦν; Ἐξ οὐρανοῦ ἢ ἐξ ἀνθρώπων; Οἱ δὲ διελογίζοντο παρ᾿ ἑαυτοῖς, λέγοντες, Ἐὰν εἴπωμεν, Ἐξ οὐρανοῦ, ἐρεῖ ἡμῖν, Διὰ τί οὖν οὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ἐὰν δὲ εἴπωμεν, Ἐξ ἀνθρώπων, φοβούμεθα τὸν ὄχλον· πάντες γὰρ ἔχουσι τὸν Ἰωάννην ὡς προφήτην. ");
INSERT INTO grctr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Καὶ ἀποκριθέντες τῷ Ἰησοῦ εἶπον, Οὐκ οἴδαμεν. Ἔφη αὐτοῖς καὶ αὐτός, Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Τί δὲ ὑμῖν δοκεῖ; Ἄνθρωπος εἶχε τέκνα δύο, καὶ προσελθὼν τῷ πρώτῳ εἶπε, Τέκνον, ὕπαγε, σήμερον ἐργάζου ἐν τῷ ἀμπελῶνί μου. ");
INSERT INTO grctr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ὁ δὲ ἀποκριθεὶς εἶπεν, Οὐ θέλω· ὕστερον δὲ μεταμεληθείς, ἀπῆλθε. ");
INSERT INTO grctr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Καὶ προσελθὼν τῷ δευτέρῳ εἶπεν ὡσαύτως. Ὁ δὲ ἀποκριθεὶς εἶπεν, Ἐγώ, κύριε· καὶ οὐκ ἀπῆλθε. ");
INSERT INTO grctr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Τίς ἐκ τῶν δύο ἐποίησε τὸ θέλημα τοῦ πατρός; Λέγουσιν αὐτῷ, Ὁ πρῶτος. Λέγει αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν λέγω ὑμῖν ὅτι οἱ τελῶναι καὶ αἱ πόρναι προάγουσιν ὑμᾶς εἰς τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ἦλθε γὰρ πρὸς ὑμᾶς Ἰωάννης ἐν ὁδῷ δικαιοσύνης, καὶ οὐκ ἐπιστεύσατε αὐτῷ· οἱ δὲ τελῶναι καὶ αἱ πόρναι ἐπίστευσαν αὐτῷ· ὑμεῖς δὲ ἰδόντες οὐ μετεμελήθητε ὕστερον τοῦ πιστεῦσαι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ἄλλην παραβολὴν ἀκούσατε. Ἄνθρωπός τις ἦν οἰκοδεσπότης, ὅστις ἐφύτευσεν ἀμπελῶνα, καὶ φραγμὸν αὐτῷ περιέθηκε, καὶ ὤρυξεν ἐν αὐτῷ ληνόν, καὶ ᾠκοδόμησε πύργον, καὶ ἐξέδοτο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησεν. ");
INSERT INTO grctr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ὅτε δὲ ἤγγισεν ὁ καιρὸς τῶν καρπῶν, ἀπέστειλε τοὺς δούλους αὐτοῦ πρὸς τοὺς γεωργούς, λαβεῖν τοὺς καρποὺς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Καὶ λαβόντες οἱ γεωργοὶ τοὺς δούλους αὐτοῦ, ὃν μὲν ἔδειραν, ὃν δὲ ἀπέκτειναν, ὃν δὲ ἐλιθοβόλησαν. ");
INSERT INTO grctr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Πάλιν ἀπέστειλεν ἄλλους δούλους πλείονας τῶν πρώτων· καὶ ἐποίησαν αὐτοῖς ὡσαύτως. ");
INSERT INTO grctr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ὕστερον δὲ ἀπέστειλε πρὸς αὐτοὺς τὸν υἱὸν αὐτοῦ, λέγων, Ἐντραπήσονται τὸν υἱόν μου. ");
INSERT INTO grctr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Οἱ δὲ γεωργοὶ ἰδόντες τὸν υἱὸν εἶπον ἐν ἑαυτοῖς, Οὗτός ἐστιν ὁ κληρονόμος· δεῦτε, ἀποκτείνωμεν αὐτόν, καὶ κατάσχωμεν τὴν κληρονομίαν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Καὶ λαβόντες αὐτὸν ἐξέβαλον ἔξω τοῦ ἀμπελῶνος καὶ ἀπέκτειναν. ");
INSERT INTO grctr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ὅταν οὖν ἔλθῃ ὁ κύριος τοῦ ἀμπελῶνος, τί ποιήσει τοῖς γεωργοῖς ἐκείνοις; ");
INSERT INTO grctr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Λέγουσιν αὐτῷ, Κακοὺς κακῶς ἀπολέσει αὐτούς, καὶ τὸν ἀμπελῶνα ἐκδόσεται ἄλλοις γεωργοῖς, οἵτινες ἀποδώσουσιν αὐτῷ τοὺς καρποὺς ἐν τοῖς καιροῖς αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Λέγει αὐτοῖς ὁ Ἰησοῦς, Οὐδέποτε ἀνέγνωτε ἐν ταῖς γραφαῖς, Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες, οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας· παρὰ Κυρίου ἐγένετο αὕτη, καὶ ἔστι θαυμαστὴ ἐν ὀφθαλμοῖς ἡμῶν; ");
INSERT INTO grctr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Διὰ τοῦτο λέγω ὑμῖν ὅτι ἀρθήσεται ἀφ᾿ ὑμῶν ἡ βασιλεία τοῦ Θεοῦ, καὶ δοθήσεται ἔθνει ποιοῦντι τοὺς καρποὺς αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Καὶ ὁ πεσὼν ἐπὶ τὸν λίθον τοῦτον συνθλασθήσεται· ἐφ᾿ ὃν δ᾿ ἂν πέσῃ, λικμήσει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Καὶ ἀκούσαντες οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι τὰς παραβολὰς αὐτοῦ ἔγνωσαν ὅτι περὶ αὐτῶν λέγει. ");
INSERT INTO grctr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Καὶ ζητοῦντες αὐτὸν κρατῆσαι, ἐφοβήθησαν τοὺς ὄχλους, ἐπειδὴ ὡς προφήτην αὐτὸν εἶχον. ");
INSERT INTO grctr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς πάλιν εἶπεν αὐτοῖς ἐν παραβολαῖς, λέγων, ");
INSERT INTO grctr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ βασιλεῖ, ὅστις ἐποίησε γάμους τῷ υἱῷ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","καὶ ἀπέστειλε τοὺς δούλους αὐτοῦ καλέσαι τοὺς κεκλημένους εἰς τοὺς γάμους, καὶ οὐκ ἤθελον ἐλθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Πάλιν ἀπέστειλεν ἄλλους δούλους, λέγων, Εἴπατε τοῖς κεκλημένοις. Ἰδού, τὸ ἄριστόν μου ἡτοίμασα, οἱ ταῦροί μου καὶ τὰ σιτιστὰ τεθυμένα, καὶ πάντα ἕτοιμα· δεῦτε εἰς τοὺς γάμους. ");
INSERT INTO grctr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Οἱ δὲ ἀμελήσαντες ἀπῆλθον, ὁ μὲν εἰς τὸν ἴδιον ἀγρόν, ὁ δὲ εἰς τὴν ἐμπορίαν αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","οἱ δὲ λοιποὶ κρατήσαντες τοὺς δούλους αὐτοῦ ὕβρισαν καὶ ἀπέκτειναν. ");
INSERT INTO grctr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ἀκούσας δὲ ὁ βασιλεὺς ὠργίσθη, καὶ πέμψας τὰ στρατεύματα αὐτοῦ ἀπώλεσε τοὺς φονεῖς ἐκείνους, καὶ τὴν πόλιν αὐτῶν ἐνέπρησε. ");
INSERT INTO grctr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Τότε λέγει τοῖς δούλοις αὐτοῦ, Ὁ μὲν γάμος ἕτοιμός ἐστιν, οἱ δὲ κεκλημένοι οὐκ ἦσαν ἄξιοι. ");
INSERT INTO grctr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Πορεύεσθε οὖν ἐπὶ τὰς διεξόδους τῶν ὁδῶν, καὶ ὅσους ἂν εὕρητε, καλέσατε εἰς τοὺς γάμους. ");
INSERT INTO grctr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Καὶ ἐξελθόντες οἱ δοῦλοι ἐκεῖνοι εἰς τὰς ὁδοὺς συνήγαγον πάντας ὅσους εὗρον, πονηρούς τε καὶ ἀγαθούς· καὶ ἐπλήσθη ὁ γάμος ἀνακειμένων. ");
INSERT INTO grctr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Εἰσελθὼν δὲ ὁ βασιλεὺς θεάσασθαι τοὺς ἀνακειμένους εἶδεν ἐκεῖ ἄνθρωπον οὐκ ἐνδεδυμένον ἔνδυμα γάμου· ");
INSERT INTO grctr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","καὶ λέγει αὐτῷ, Ἑταῖρε, πῶς εἰσῆλθες ὧδε μὴ ἔχων ἔνδυμα γάμου; Ὁ δὲ ἐφιμώθη. ");
INSERT INTO grctr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Τότε εἶπεν ὁ βασιλεὺς τοῖς διακόνοις, Δήσαντες αὐτοῦ πόδας καὶ χεῖρας, ἄρατε αὐτὸν καὶ ἐκβάλετε εἰς τὸ σκότος τὸ ἐξώτερον· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Πολλοὶ γάρ εἰσι κλητοί, ὀλίγοι δὲ ἐκλεκτοί. ");
INSERT INTO grctr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Τότε πορευθέντες οἱ Φαρισαῖοι συμβούλιον ἔλαβον ὅπως αὐτὸν παγιδεύσωσιν ἐν λόγῳ. ");
INSERT INTO grctr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Καὶ ἀποστέλλουσιν αὐτῷ τοὺς μαθητὰς αὐτῶν μετὰ τῶν Ἡρῳδιανῶν, λέγοντες, Διδάσκαλε, οἴδαμεν ὅτι ἀληθὴς εἶ, καὶ τὴν ὁδὸν τοῦ Θεοῦ ἐν ἀληθείᾳ διδάσκεις, καὶ οὐ μέλει σοι περὶ οὐδενός· οὐ γὰρ βλέπεις εἰς πρόσωπον ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Εἰπὲ οὖν ἡμῖν, τί σοι δοκεῖ; Ἔξεστι δοῦναι κῆνσον Καίσαρι, ἢ οὔ; ");
INSERT INTO grctr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Γνοὺς δὲ ὁ Ἰησοῦς τὴν πονηρίαν αὐτῶν εἶπε, Τί με πειράζετε, ὑποκριταί; ");
INSERT INTO grctr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ἐπιδείξατέ μοι τὸ νόμισμα τοῦ κήνσου. Οἱ δὲ προσήνεγκαν αὐτῷ δηνάριον. ");
INSERT INTO grctr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Καὶ λέγει αὐτοῖς, Τίνος ἡ εἰκὼν αὕτη καὶ ἡ ἐπιγραφή; ");
INSERT INTO grctr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Λέγουσιν αὐτῷ, Καίσαρος. Τότε λέγει αὐτοῖς, Ἀπόδοτε οὖν τὰ Καίσαρος Καίσαρι, καὶ τὰ τοῦ Θεοῦ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Καὶ ἀκούσαντες ἐθαύμασαν· καὶ ἀφέντες αὐτὸν ἀπῆλθον. ");
INSERT INTO grctr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ἐν ἐκείνῃ τῇ ἡμέρᾳ προσῆλθον αὐτῷ Σαδδουκαῖοι, οἱ λέγοντες μὴ εἶναι ἀνάστασιν, καὶ ἐπηρώτησαν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","λέγοντες, Διδάσκαλε, Μωσῆς εἶπεν, Ἐάν τις ἀποθάνῃ μὴ ἔχων τέκνα, ἐπιγαμβρεύσει ὁ ἀδελφὸς αὐτοῦ τὴν γυναῖκα αὐτοῦ, καὶ ἀναστήσει σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ἦσαν δὲ παρ᾿ ἡμῖν ἑπτὰ ἀδελφοί· καὶ ὁ πρῶτος γαμήσας ἐτελεύτησε· καὶ μὴ ἔχων σπέρμα, ἀφῆκε τὴν γυναῖκα αὐτοῦ τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ὁμοίως καὶ ὁ δεύτερος, καὶ ὁ τρίτος, ἕως τῶν ἑπτά. ");
INSERT INTO grctr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ὕστερον δὲ πάντων ἀπέθανε καὶ ἡ γυνή. ");
INSERT INTO grctr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ἐν τῇ οὖν ἀναστάσει, τίνος τῶν ἑπτὰ ἔσται γυνή; Πάντες γὰρ ἔσχον αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Πλανᾶσθε, μὴ εἰδότες τὰς γραφάς, μηδὲ τὴν δύναμιν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ἐν γὰρ τῇ ἀναστάσει οὔτε γαμοῦσιν, οὔτε ἐκγαμίζονται, ἀλλ᾿ ὡς ἄγγελοι τοῦ Θεοῦ ἐν οὐρανῷ εἰσι. ");
INSERT INTO grctr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Περὶ δὲ τῆς ἀναστάσεως τῶν νεκρῶν, οὐκ ἀνέγνωτε τὸ ῥηθὲν ὑμῖν ὑπὸ τοῦ Θεοῦ, λέγοντος, ");
INSERT INTO grctr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ἐγώ εἰμι ὁ Θεὸς Ἀβραάμ, καὶ ὁ Θεὸς Ἰσαάκ, καὶ ὁ Θεὸς Ἰακώβ; Οὐκ ἔστιν ὁ Θεὸς Θεὸς νεκρῶν, ἀλλὰ ζώντων. ");
INSERT INTO grctr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Καὶ ἀκούσαντες οἱ ὄχλοι ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Οἱ δὲ Φαρισαῖοι, ἀκούσαντες ὅτι ἐφίμωσε τοὺς Σαδδουκαίους, συνήχθησαν ἐπὶ τὸ αὐτό. ");
INSERT INTO grctr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Καὶ ἐπηρώτησεν εἷς ἐξ αὐτῶν νομικός, πειράζων αὐτόν, καὶ λέγων, ");
INSERT INTO grctr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Διδάσκαλε, ποία ἐντολὴ μεγάλη ἐν τῷ νόμῳ; ");
INSERT INTO grctr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Ἀγαπήσεις Κύριον τὸν Θεόν σου, ἐν ὅλῃ τῇ καρδίᾳ σου, καὶ ἐν ὅλῃ τῇ ψυχῇ σου, καὶ ἐν ὅλῃ τῇ διανοίᾳ σου. ");
INSERT INTO grctr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Αὕτη ἐστὶ πρώτη καὶ μεγάλη ἐντολή. ");
INSERT INTO grctr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Δευτέρα δὲ ὁμοία αὐτῇ, Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grctr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ἐν ταύταις ταῖς δυσὶν ἐντολαῖς ὅλος ὁ νόμος καὶ οἱ προφῆται κρέμανται. ");
INSERT INTO grctr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Συνηγμένων δὲ τῶν Φαρισαίων, ἐπηρώτησεν αὐτοὺς ὁ Ἰησοῦς, ");
INSERT INTO grctr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","λέγων, Τί ὑμῖν δοκεῖ περὶ τοῦ Χριστοῦ; Τίνος υἱός ἐστι; Λέγουσιν αὐτῷ, Τοῦ Δαβίδ. ");
INSERT INTO grctr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Λέγει αὐτοῖς, Πῶς οὖν Δαβὶδ ἐν πνεύματι Κύριον αὐτὸν καλεῖ, λέγων, ");
INSERT INTO grctr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Εἶπεν ὁ Κύριος τῷ Κυρίῳ μου, Κάθου ἐκ δεξιῶν μου, ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου; ");
INSERT INTO grctr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Εἰ οὖν Δαβὶδ καλεῖ αὐτὸν Κύριον, πῶς υἱὸς αὐτοῦ ἐστι; ");
INSERT INTO grctr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Καὶ οὐδεὶς ἐδύνατο αὐτῷ ἀποκριθῆναι λόγον· οὐδὲ ἐτόλμησέ τις ἀπ᾿ ἐκείνης τῆς ἡμέρας ἐπερωτῆσαι αὐτὸν οὐκέτι. ");
INSERT INTO grctr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Τότε ὁ Ἰησοῦς ἐλάλησε τοῖς ὄχλοις καὶ τοῖς μαθηταῖς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","λέγων, Ἐπὶ τῆς Μωσέως καθέδρας ἐκάθισαν οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι· ");
INSERT INTO grctr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","πάντα οὖν ὅσα ἂν εἴπωσιν ὑμῖν τηρεῖν, τηρεῖτε καὶ ποιεῖτε· κατὰ δὲ τὰ ἔργα αὐτῶν μὴ ποιεῖτε, λέγουσι γὰρ καὶ οὐ ποιοῦσι. ");
INSERT INTO grctr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Δεσμεύουσι γὰρ φορτία βαρέα καὶ δυσβάστακτα, καὶ ἐπιτιθέασιν ἐπὶ τοὺς ὤμους τῶν ἀνθρώπων, τῷ δὲ δακτύλῳ αὐτῶν οὐ θέλουσι κινῆσαι αὐτά. ");
INSERT INTO grctr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Πάντα δὲ τὰ ἔργα αὐτῶν ποιοῦσι πρὸς τὸ θεαθῆναι τοῖς ἀνθρώποις· πλατύνουσι δὲ τὰ φυλακτήρια αὐτῶν, καὶ μεγαλύνουσι τὰ κράσπεδα τῶν ἱματίων αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","φιλοῦσί τε τὴν πρωτοκλισίαν ἐν τοῖς δείπνοις, καὶ τὰς πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς, ");
INSERT INTO grctr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","καὶ τοὺς ἀσπασμοὺς ἐν ταῖς ἀγοραῖς, καὶ καλεῖσθαι ὑπὸ τῶν ἀνθρώπων, Ῥαββί, ῥαββί· ");
INSERT INTO grctr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ὑμεῖς δὲ μὴ κληθῆτε Ῥαββί· εἷς γάρ ἐστιν ὑμῶν ὁ καθηγητής, ὁ Χριστός· πάντες δὲ ὑμεῖς ἀδελφοί ἐστε. ");
INSERT INTO grctr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Καὶ πατέρα μὴ καλέσητε ὑμῶν ἐπὶ τῆς γῆς· εἷς γάρ ἐστιν ὁ πατὴρ ὑμῶν, ὁ ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Μηδὲ κληθῆτε καθηγηταί· εἷς γὰρ ὑμῶν ἐστιν ὁ καθηγητής, ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ὁ δὲ μείζων ὑμῶν ἔσται ὑμῶν διάκονος. ");
INSERT INTO grctr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ὅστις δὲ ὑψώσει ἑαυτόν, ταπεινωθήσεται· καὶ ὅστις ταπεινώσει ἑαυτόν, ὑψωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Οὐαὶ δὲ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι κλείετε τὴν βασιλείαν τῶν οὐρανῶν ἔμπροσθεν τῶν ἀνθρώπων· ὑμεῖς γὰρ οὐκ εἰσέρχεσθε, οὐδὲ τοὺς εἰσερχομένους ἀφίετε εἰσελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι κατεσθίετε τὰς οἰκίας τῶν χηρῶν, καὶ προφάσει μακρὰ προσευχόμενοι· διὰ τοῦτο λήψεσθε περισσότερον κρίμα. ");
INSERT INTO grctr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι περιάγετε τὴν θάλασσαν καὶ τὴν ξηρὰν ποιῆσαι ἕνα προσήλυτον, καὶ ὅταν γένηται, ποιεῖτε αὐτὸν υἱὸν γεέννης διπλότερον ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Οὐαὶ ὑμῖν, ὁδηγοὶ τυφλοί, οἱ λέγοντες, Ὃς ἂν ὀμόσῃ ἐν τῷ ναῷ, οὐδέν ἐστιν· ὃς δ᾿ ἂν ὀμόσῃ ἐν τῷ χρυσῷ τοῦ ναοῦ, ὀφείλει. ");
INSERT INTO grctr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Μωροὶ καὶ τυφλοί· τίς γὰρ μείζων ἐστίν, ὁ χρυσός, ἢ ὁ ναὸς ὁ ἁγιάζων τὸν χρυσόν; ");
INSERT INTO grctr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Καί, Ὃς ἐὰν ὀμόσῃ ἐν τῷ θυσιαστηρίῳ, οὐδέν ἐστιν· ὃς δ᾿ ἂν ὀμόσῃ ἐν τῷ δώρῳ τῷ ἐπάνω αὐτοῦ, ὀφείλει. ");
INSERT INTO grctr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Μωροὶ καὶ τυφλοί· τί γὰρ μεῖζον, τὸ δῶρον, ἢ τὸ θυσιαστήριον τὸ ἁγιάζον τὸ δῶρον; ");
INSERT INTO grctr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ὁ οὖν ὀμόσας ἐν τῷ θυσιαστηρίῳ ὀμνύει ἐν αὐτῷ καὶ ἐν πᾶσι τοῖς ἐπάνω αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","καὶ ὁ ὀμόσας ἐν τῷ ναῷ ὀμνύει ἐν αὐτῷ καὶ ἐν τῷ κατοικοῦντι αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","καὶ ὁ ὀμόσας ἐν τῷ οὐρανῷ ὀμνύει ἐν τῷ θρόνῳ τοῦ Θεοῦ καὶ ἐν τῷ καθημένῳ ἐπάνω αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι ἀποδεκατοῦτε τὸ ἡδύοσμον καὶ τὸ ἄνηθον καὶ τὸ κύμινον, καὶ ἀφήκατε τὰ βαρύτερα τοῦ νόμου, τὴν κρίσιν καὶ τὸν ἔλεον καὶ τὴν πίστιν· ταῦτα ἔδει ποιῆσαι, κἀκεῖνα μὴ ἀφιέναι. ");
INSERT INTO grctr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ὁδηγοὶ τυφλοί, οἱ διϋλίζοντες τὸν κώνωπα, τὴν δὲ κάμηλον καταπίνοντες. ");
INSERT INTO grctr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι καθαρίζετε τὸ ἔξωθεν τοῦ ποτηρίου καὶ τῆς παροψίδος, ἔσωθεν δὲ γέμουσιν ἐξ ἁρπαγῆς καὶ ἀκρασίας. ");
INSERT INTO grctr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Φαρισαῖε τυφλέ, καθάρισον πρῶτον τὸ ἐντὸς τοῦ ποτηρίου καὶ τῆς παροψίδος, ἵνα γένηται καὶ τὸ ἐκτὸς αὐτῶν καθαρόν. ");
INSERT INTO grctr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι παρομοιάζετε τάφοις κεκονιαμένοις, οἵτινες ἔξωθεν μὲν φαίνονται ὡραῖοι, ἔσωθεν δὲ γέμουσιν ὀστέων νεκρῶν καὶ πάσης ἀκαθαρσίας. ");
INSERT INTO grctr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Οὕτω καὶ ὑμεῖς ἔξωθεν μὲν φαίνεσθε τοῖς ἀνθρώποις δίκαιοι, ἔσωθεν δὲ μεστοί ἐστε ὑποκρίσεως καὶ ἀνομίας. ");
INSERT INTO grctr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι οἰκοδομεῖτε τοὺς τάφους τῶν προφητῶν, καὶ κοσμεῖτε τὰ μνημεῖα τῶν δικαίων, ");
INSERT INTO grctr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","καὶ λέγετε, Εἰ ἦμεν ἐν ταῖς ἡμέραις τῶν πατέρων ἡμῶν, οὐκ ἂν ἦμεν κοινωνοὶ αὐτῶν ἐν τῷ αἵματι τῶν προφητῶν. ");
INSERT INTO grctr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ὥστε μαρτυρεῖτε ἑαυτοῖς ὅτι υἱοί ἐστε τῶν φονευσάντων τοὺς προφήτας· ");
INSERT INTO grctr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","καὶ ὑμεῖς πληρώσατε τὸ μέτρον τῶν πατέρων ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ὄφεις, γεννήματα ἐχιδνῶν, πῶς φύγητε ἀπὸ τῆς κρίσεως τῆς γεέννης; ");
INSERT INTO grctr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Διὰ τοῦτο, ἰδού, ἐγὼ ἀποστέλλω πρὸς ὑμᾶς προφήτας καὶ σοφοὺς καὶ γραμματεῖς· καὶ ἐξ αὐτῶν ἀποκτενεῖτε καὶ σταυρώσετε, καὶ ἐξ αὐτῶν μαστιγώσετε ἐν ταῖς συναγωγαῖς ὑμῶν καὶ διώξετε ἀπὸ πόλεως εἰς πόλιν· ");
INSERT INTO grctr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ὅπως ἔλθῃ ἐφ᾿ ὑμᾶς πᾶν αἷμα δίκαιον ἐκχυνόμενον ἐπὶ τῆς γῆς, ἀπὸ τοῦ αἵματος Ἄβελ τοῦ δικαίου ἕως τοῦ αἵματος Ζαχαρίου υἱοῦ Βαραχίου, ὃν ἐφονεύσατε μεταξὺ τοῦ ναοῦ καὶ τοῦ θυσιαστηρίου. ");
INSERT INTO grctr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ἀμὴν λέγω ὑμῖν, ἥξει ταῦτα πάντα ἐπὶ τὴν γενεὰν ταύτην. ");
INSERT INTO grctr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ἱερουσαλήμ, Ἱερουσαλήμ, ἡ ἀποκτείνουσα τοὺς προφήτας καὶ λιθοβολοῦσα τοὺς ἀπεσταλμένους πρὸς αὐτήν, ποσάκις ἠθέλησα ἐπισυναγαγεῖν τὰ τέκνα σου, ὃν τρόπον ἐπισυνάγει ὄρνις τὰ νοσσία ἑαυτῆς ὑπὸ τὰς πτέρυγας, καὶ οὐκ ἠθελήσατε. ");
INSERT INTO grctr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ἰδού, ἀφίεται ὑμῖν ὁ οἶκος ὑμῶν ἔρημος. ");
INSERT INTO grctr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Λέγω γὰρ ὑμῖν, οὐ μή με ἴδητε ἀπ᾿ ἄρτι ἕως ἂν εἴπητε, Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Καὶ ἐξελθὼν ὁ Ἰησοῦς ἐπορεύετο ἀπὸ τοῦ ἱεροῦ· καὶ προσῆλθον οἱ μαθηταὶ αὐτοῦ ἐπιδεῖξαι αὐτῷ τὰς οἰκοδομὰς τοῦ ἱεροῦ. ");
INSERT INTO grctr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Οὐ βλέπετε πάντα ταῦτα; Ἀμὴν λέγω ὑμῖν, οὐ μὴ ἀφεθῇ ὧδε λίθος ἐπὶ λίθον, ὃς οὐ μὴ καταλυθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Καθημένου δὲ αὐτοῦ ἐπὶ τοῦ ὄρους τῶν Ἐλαιῶν, προσῆλθον αὐτῷ οἱ μαθηταὶ κατ᾿ ἰδίαν, λέγοντες, Εἰπὲ ἡμῖν, πότε ταῦτα ἔσται; Καὶ τί τὸ σημεῖον τῆς σῆς παρουσίας, καὶ τῆς συντελείας τοῦ αἰῶνος; ");
INSERT INTO grctr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Βλέπετε μή τις ὑμᾶς πλανήσῃ. ");
INSERT INTO grctr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Πολλοὶ γὰρ ἐλεύσονται ἐπὶ τῷ ὀνόματί μου, λέγοντες, Ἐγώ εἰμι ὁ Χριστός· καὶ πολλοὺς πλανήσουσι. ");
INSERT INTO grctr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Μελλήσετε δὲ ἀκούειν πολέμους καὶ ἀκοὰς πολέμων· ὁρᾶτε, μὴ θροεῖσθε· δεῖ γὰρ πάντα γενέσθαι, ἀλλ᾿ οὔπω ἐστὶ τὸ τέλος. ");
INSERT INTO grctr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ἐγερθήσεται γὰρ ἔθνος ἐπὶ ἔθνος, καὶ βασιλεία ἐπὶ βασιλείαν· καὶ ἔσονται λιμοὶ καὶ λοιμοὶ καὶ σεισμοὶ κατὰ τόπους. ");
INSERT INTO grctr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Πάντα δὲ ταῦτα ἀρχὴ ὠδίνων. ");
INSERT INTO grctr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Τότε παραδώσουσιν ὑμᾶς εἰς θλίψιν, καὶ ἀποκτενοῦσιν ὑμᾶς. Καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων τῶν ἐθνῶν διὰ τὸ ὄνομά μου. ");
INSERT INTO grctr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Καὶ τότε σκανδαλισθήσονται πολλοί, καὶ ἀλλήλους παραδώσουσι, καὶ μισήσουσιν ἀλλήλους. ");
INSERT INTO grctr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Καὶ πολλοὶ ψευδοπροφῆται ἐγερθήσονται, καὶ πλανήσουσι πολλούς. ");
INSERT INTO grctr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Καὶ διὰ τὸ πληθυνθῆναι τὴν ἀνομίαν, ψυγήσεται ἡ ἀγάπη τῶν πολλῶν· ");
INSERT INTO grctr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ὁ δὲ ὑπομείνας εἰς τέλος, οὗτος σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Καὶ κηρυχθήσεται τοῦτο τὸ εὐαγγέλιον τῆς βασιλείας ἐν ὅλῃ τῇ οἰκουμένῃ εἰς μαρτύριον πᾶσι τοῖς ἔθνεσι· καὶ τότε ἥξει τὸ τέλος. ");
INSERT INTO grctr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ὅταν οὖν ἴδητε τὸ βδέλυγμα τῆς ἐρημώσεως, τὸ ῥηθὲν διὰ Δανιὴλ τοῦ προφήτου, ἑστὼς ἐν τόπῳ ἁγίῳ — ὁ ἀναγινώσκων νοείτω — ");
INSERT INTO grctr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν ἐπὶ τὰ ὄρη· ");
INSERT INTO grctr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ὁ ἐπὶ τοῦ δώματος μὴ καταβαινέτω ἆραί τι ἐκ τῆς οἰκίας αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","καὶ ὁ ἐν τῷ ἀγρῷ μὴ ἐπιστρεψάτω ὀπίσω ἆραι τὰ ἱμάτια αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Οὐαὶ δὲ ταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grctr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Προσεύχεσθε δὲ ἵνα μὴ γένηται ἡ φυγὴ ὑμῶν χειμῶνος, μηδὲ ἐν σαββάτῳ. ");
INSERT INTO grctr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ἔσται γὰρ τότε θλίψις μεγάλη, οἵα οὐ γέγονεν ἀπ᾿ ἀρχῆς κόσμου ἕως τοῦ νῦν, οὐδ᾿ οὐ μὴ γένηται. ");
INSERT INTO grctr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Καὶ εἰ μὴ ἐκολοβώθησαν αἱ ἡμέραι ἐκεῖναι, οὐκ ἂν ἐσώθη πᾶσα σάρξ· διὰ δὲ τοὺς ἐκλεκτοὺς κολοβωθήσονται αἱ ἡμέραι ἐκεῖναι. ");
INSERT INTO grctr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Τότε ἐάν τις ὑμῖν εἴπῃ, Ἰδού, ὧδε ὁ Χριστός, ἢ ὧδε, μὴ πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ἐγερθήσονται γὰρ ψευδόχριστοι καὶ ψευδοπροφῆται, καὶ δώσουσι σημεῖα μεγάλα καὶ τέρατα, ὥστε πλανῆσαι, εἰ δυνατόν, καὶ τοὺς ἐκλεκτούς. ");
INSERT INTO grctr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ἰδού, προείρηκα ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ἐὰν οὖν εἴπωσιν ὑμῖν, Ἰδού, ἐν τῇ ἐρήμῳ ἐστί, μὴ ἐξέλθητε· Ἰδού, ἐν τοῖς ταμείοις, μὴ πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ὥσπερ γὰρ ἡ ἀστραπὴ ἐξέρχεται ἀπὸ ἀνατολῶν καὶ φαίνεται ἕως δυσμῶν, οὕτως ἔσται καὶ ἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ὅπου γὰρ ἐὰν ᾖ τὸ πτῶμα, ἐκεῖ συναχθήσονται οἱ ἀετοί. ");
INSERT INTO grctr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Εὐθέως δὲ μετὰ τὴν θλίψιν τῶν ἡμερῶν ἐκείνων, ὁ ἥλιος σκοτισθήσεται, καὶ ἡ σελήνη οὐ δώσει τὸ φέγγος αὐτῆς, καὶ οἱ ἀστέρες πεσοῦνται ἀπὸ τοῦ οὐρανοῦ, καὶ αἱ δυνάμεις τῶν οὐρανῶν σαλευθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Καὶ τότε φανήσεται τὸ σημεῖον τοῦ υἱοῦ τοῦ ἀνθρώπου ἐν τῷ οὐρανῷ· καὶ τότε κόψονται πᾶσαι αἱ φυλαὶ τῆς γῆς, καὶ ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐπὶ τῶν νεφελῶν τοῦ οὐρανοῦ μετὰ δυνάμεως καὶ δόξης πολλῆς. ");
INSERT INTO grctr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Καὶ ἀποστελεῖ τοὺς ἀγγέλους αὐτοῦ μετὰ σάλπιγγος φωνῆς μεγάλης, καὶ ἐπισυνάξουσι τοὺς ἐκλεκτοὺς αὐτοῦ ἐκ τῶν τεσσάρων ἀνέμων, ἀπ᾿ ἄκρων οὐρανῶν ἕως ἄκρων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ἀπὸ δὲ τῆς συκῆς μάθετε τὴν παραβολήν· ὅταν ἤδη ὁ κλάδος αὐτῆς γένηται ἁπαλός, καὶ τὰ φύλλα ἐκφύῃ, γινώσκετε ὅτι ἐγγὺς τὸ θέρος· ");
INSERT INTO grctr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","οὕτω καὶ ὑμεῖς, ὅταν ἴδητε πάντα ταῦτα, γινώσκετε ὅτι ἐγγύς ἐστιν ἐπὶ θύραις. ");
INSERT INTO grctr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ἀμὴν λέγω ὑμῖν, οὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη, ἕως ἂν πάντα ταῦτα γένηται. ");
INSERT INTO grctr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ὁ οὐρανὸς καὶ ἡ γῆ παρελεύσονται, οἱ δὲ λόγοι μου οὐ μὴ παρέλθωσι. ");
INSERT INTO grctr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Περὶ δὲ τῆς ἡμέρας ἐκείνης καὶ τῆς ὥρας οὐδεὶς οἶδεν, οὐδὲ οἱ ἄγγελοι τῶν οὐρανῶν, εἰ μὴ ὁ πατήρ μου μόνος. ");
INSERT INTO grctr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ὥσπερ δὲ αἱ ἡμέραι τοῦ Νῶε, οὕτως ἔσται καὶ ἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ὥσπερ γὰρ ἦσαν ἐν ταῖς ἡμέραις ταῖς πρὸ τοῦ κατακλυσμοῦ τρώγοντες καὶ πίνοντες, γαμοῦντες καὶ ἐκγαμίζοντες, ἄχρι ἧς ἡμέρας εἰσῆλθε Νῶε εἰς τὴν κιβωτόν, ");
INSERT INTO grctr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","καὶ οὐκ ἔγνωσαν, ἕως ἦλθεν ὁ κατακλυσμὸς καὶ ἦρεν ἅπαντας, οὕτως ἔσται καὶ ἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Τότε δύο ἔσονται ἐν τῷ ἀγρῷ· ὁ εἷς παραλαμβάνεται, καὶ ὁ εἷς ἀφίεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Δύο ἀλήθουσαι ἐν τῷ μύλωνι· μία παραλαμβάνεται, καὶ μία ἀφίεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Γρηγορεῖτε οὖν, ὅτι οὐκ οἴδατε ποίᾳ ὥρᾳ ὁ Κύριος ὑμῶν ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ἐκεῖνο δὲ γινώσκετε, ὅτι εἰ ᾔδει ὁ οἰκοδεσπότης ποίᾳ φυλακῇ ὁ κλέπτης ἔρχεται, ἐγρηγόρησεν ἄν, καὶ οὐκ ἂν εἴασε διορυγῆναι τὴν οἰκίαν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Διὰ τοῦτο καὶ ὑμεῖς γίνεσθε ἕτοιμοι· ὅτι ᾗ ὥρᾳ οὐ δοκεῖτε ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Τίς ἄρα ἐστὶν ὁ πιστὸς δοῦλος καὶ φρόνιμος, ὃν κατέστησεν ὁ κύριος αὐτοῦ ἐπὶ τῆς θεραπείας αὐτοῦ, τοῦ διδόναι αὐτοῖς τὴν τροφὴν ἐν καιρῷ; ");
INSERT INTO grctr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Μακάριος ὁ δοῦλος ἐκεῖνος, ὃν ἐλθὼν ὁ κύριος αὐτοῦ εὑρήσει ποιοῦντα οὕτως. ");
INSERT INTO grctr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ἀμὴν λέγω ὑμῖν ὅτι ἐπὶ πᾶσι τοῖς ὑπάρχουσιν αὐτοῦ καταστήσει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ἐὰν δὲ εἴπῃ ὁ κακὸς δοῦλος ἐκεῖνος ἐν τῇ καρδίᾳ αὐτοῦ, Χρονίζει ὁ κύριός μου ἐλθεῖν, ");
INSERT INTO grctr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","καὶ ἄρξηται τύπτειν τοὺς συνδούλους, ἐσθίειν δὲ καὶ πίνειν μετὰ τῶν μεθυόντων, ");
INSERT INTO grctr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ἥξει ὁ κύριος τοῦ δούλου ἐκείνου ἐν ἡμέρᾳ ᾗ οὐ προσδοκᾷ, καὶ ἐν ὥρᾳ ᾗ οὐ γινώσκει, ");
INSERT INTO grctr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","καὶ διχοτομήσει αὐτόν, καὶ τὸ μέρος αὐτοῦ μετὰ τῶν ὑποκριτῶν θήσει· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Τότε ὁμοιωθήσεται ἡ βασιλεία τῶν οὐρανῶν δέκα παρθένοις, αἵτινες λαβοῦσαι τὰς λαμπάδας αὐτῶν ἐξῆλθον εἰς ἀπάντησιν τοῦ νυμφίου. ");
INSERT INTO grctr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Πέντε δὲ ἦσαν ἐξ αὐτῶν φρόνιμοι, καὶ αἱ πέντε μωραί. ");
INSERT INTO grctr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Αἵτινες μωραί, λαβοῦσαι τὰς λαμπάδας ἑαυτῶν, οὐκ ἔλαβον μεθ᾿ ἑαυτῶν ἔλαιον· ");
INSERT INTO grctr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","αἱ δὲ φρόνιμοι ἔλαβον ἔλαιον ἐν τοῖς ἀγγείοις αὐτῶν μετὰ τῶν λαμπάδων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Χρονίζοντος δὲ τοῦ νυμφίου, ἐνύσταξαν πᾶσαι καὶ ἐκάθευδον. ");
INSERT INTO grctr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Μέσης δὲ νυκτὸς κραυγὴ γέγονεν, Ἰδού, ὁ νυμφίος ἔρχεται, ἐξέρχεσθε εἰς ἀπάντησιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Τότε ἠγέρθησαν πᾶσαι αἱ παρθένοι ἐκεῖναι, καὶ ἐκόσμησαν τὰς λαμπάδας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Αἱ δὲ μωραὶ ταῖς φρονίμοις εἶπον, Δότε ἡμῖν ἐκ τοῦ ἐλαίου ὑμῶν, ὅτι αἱ λαμπάδες ἡμῶν σβέννυνται. ");
INSERT INTO grctr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ἀπεκρίθησαν δὲ αἱ φρόνιμοι, λέγουσαι, Μήποτε οὐκ ἀρκέσῃ ἡμῖν καὶ ὑμῖν· πορεύεσθε δὲ μᾶλλον πρὸς τοὺς πωλοῦντας καὶ ἀγοράσατε ἑαυταῖς. ");
INSERT INTO grctr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ἀπερχομένων δὲ αὐτῶν ἀγοράσαι, ἦλθεν ὁ νυμφίος· καὶ αἱ ἕτοιμοι εἰσῆλθον μετ᾿ αὐτοῦ εἰς τοὺς γάμους, καὶ ἐκλείσθη ἡ θύρα. ");
INSERT INTO grctr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ὕστερον δὲ ἔρχονται καὶ αἱ λοιπαὶ παρθένοι, λέγουσαι, Κύριε, Κύριε, ἄνοιξον ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ὁ δὲ ἀποκριθεὶς εἶπεν, Ἀμὴν λέγω ὑμῖν, οὐκ οἶδα ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Γρηγορεῖτε οὖν, ὅτι οὐκ οἴδατε τὴν ἡμέραν οὐδὲ τὴν ὥραν, ἐν ᾗ ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ὥσπερ γὰρ ἄνθρωπος ἀποδημῶν ἐκάλεσε τοὺς ἰδίους δούλους, καὶ παρέδωκεν αὐτοῖς τὰ ὑπάρχοντα αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","καὶ ᾧ μὲν ἔδωκε πέντε τάλαντα, ᾧ δὲ δύο, ᾧ δὲ ἕν, ἑκάστῳ κατὰ τὴν ἰδίαν δύναμιν· καὶ ἀπεδήμησεν εὐθέως. ");
INSERT INTO grctr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Πορευθεὶς δὲ ὁ τὰ πέντε τάλαντα λαβὼν εἰργάσατο ἐν αὐτοῖς, καὶ ἐποίησεν ἄλλα πέντε τάλαντα. ");
INSERT INTO grctr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ὡσαύτως καὶ ὁ τὰ δύο ἐκέρδησε καὶ αὐτὸς ἄλλα δύο. ");
INSERT INTO grctr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ὁ δὲ τὸ ἓν λαβὼν ἀπελθὼν ὤρυξεν ἐν τῇ γῇ, καὶ ἀπέκρυψε τὸ ἀργύριον τοῦ κυρίου αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Μετὰ δὲ χρόνον πολὺν ἔρχεται ὁ κύριος τῶν δούλων ἐκείνων, καὶ συναίρει μετ᾿ αὐτῶν λόγον. ");
INSERT INTO grctr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Καὶ προσελθὼν ὁ τὰ πέντε τάλαντα λαβὼν προσήνεγκεν ἄλλα πέντε τάλαντα, λέγων, Κύριε, πέντε τάλαντά μοι παρέδωκας· ἴδε, ἄλλα πέντε τάλαντα ἐκέρδησα ἐπ᾿ αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ἔφη δὲ αὐτῷ ὁ κύριος αὐτοῦ, Εὖ, δοῦλε ἀγαθὲ καὶ πιστέ, ἐπὶ ὀλίγα ἦς πιστός, ἐπὶ πολλῶν σε καταστήσω· εἴσελθε εἰς τὴν χαρὰν τοῦ κυρίου σου. ");
INSERT INTO grctr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Προσελθὼν δὲ καὶ ὁ τὰ δύο τάλαντα λαβὼν εἶπε, Κύριε, δύο τάλαντά μοι παρέδωκας· ἴδε, ἄλλα δύο τάλαντα ἐκέρδησα ἐπ᾿ αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ἔφη αὐτῷ ὁ κύριος αὐτοῦ, Εὖ, δοῦλε ἀγαθὲ καὶ πιστέ, ἐπὶ ὀλίγα ἦς πιστός, ἐπὶ πολλῶν σε καταστήσω· εἴσελθε εἰς τὴν χαρὰν τοῦ κυρίου σου. ");
INSERT INTO grctr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Προσελθὼν δὲ καὶ ὁ τὸ ἓν τάλαντον εἰληφὼς εἶπε, Κύριε, ἔγνων σε ὅτι σκληρὸς εἶ ἄνθρωπος, θερίζων ὅπου οὐκ ἔσπειρας, καὶ συνάγων ὅθεν οὐ διεσκόρπισας· ");
INSERT INTO grctr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","καὶ φοβηθείς, ἀπελθὼν ἔκρυψα τὸ τάλαντόν σου ἐν τῇ γῇ· ἴδε, ἔχεις τὸ σόν. ");
INSERT INTO grctr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ἀποκριθεὶς δὲ ὁ κύριος αὐτοῦ εἶπεν αὐτῷ, Πονηρὲ δοῦλε καὶ ὀκνηρέ, ᾔδεις ὅτι θερίζω ὅπου οὐκ ἔσπειρα, καὶ συνάγω ὅθεν οὐ διεσκόρπισα· ");
INSERT INTO grctr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ἔδει οὖν σε βαλεῖν τὸ ἀργύριόν μου τοῖς τραπεζίταις, καὶ ἐλθὼν ἐγὼ ἐκομισάμην ἂν τὸ ἐμὸν σὺν τόκῳ. ");
INSERT INTO grctr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ἄρατε οὖν ἀπ᾿ αὐτοῦ τὸ τάλαντον, καὶ δότε τῷ ἔχοντι τὰ δέκα τάλαντα. ");
INSERT INTO grctr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Τῷ γὰρ ἔχοντι παντὶ δοθήσεται καὶ περισσευθήσεται· ἀπὸ δὲ τοῦ μὴ ἔχοντος, καὶ ὃ ἔχει ἀρθήσεται ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Καὶ τὸν ἀχρεῖον δοῦλον ἐκβάλλετε εἰς τὸ σκότος τὸ ἐξώτερον. Ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grctr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ὅταν δὲ ἔλθῃ ὁ υἱὸς τοῦ ἀνθρώπου ἐν τῇ δόξῃ αὐτοῦ, καὶ πάντες οἱ ἅγιοι ἄγγελοι μετ᾿ αὐτοῦ, τότε καθίσει ἐπὶ θρόνου δόξης αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","καὶ συναχθήσεται ἔμπροσθεν αὐτοῦ πάντα τὰ ἔθνη, καὶ ἀφοριεῖ αὐτοὺς ἀπ᾿ ἀλλήλων, ὥσπερ ὁ ποιμὴν ἀφορίζει τὰ πρόβατα ἀπὸ τῶν ἐρίφων· ");
INSERT INTO grctr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","καὶ στήσει τὰ μὲν πρόβατα ἐκ δεξιῶν αὐτοῦ, τὰ δὲ ἐρίφια ἐξ εὐωνύμων. ");
INSERT INTO grctr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Τότε ἐρεῖ ὁ βασιλεὺς τοῖς ἐκ δεξιῶν αὐτοῦ, Δεῦτε, οἱ εὐλογημένοι τοῦ πατρός μου, κληρονομήσατε τὴν ἡτοιμασμένην ὑμῖν βασιλείαν ἀπὸ καταβολῆς κόσμου. ");
INSERT INTO grctr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ἐπείνασα γάρ, καὶ ἐδώκατέ μοι φαγεῖν· ἐδίψησα, καὶ ἐποτίσατέ με· ξένος ἤμην, καὶ συνηγάγετέ με· ");
INSERT INTO grctr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","γυμνός, καὶ περιεβάλετέ με· ἠσθένησα, καὶ ἐπεσκέψασθέ με· ἐν φυλακῇ ἤμην, καὶ ἤλθετε πρός με. ");
INSERT INTO grctr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Τότε ἀποκριθήσονται αὐτῷ οἱ δίκαιοι, λέγοντες, Κύριε, πότε σὲ εἴδομεν πεινῶντα, καὶ ἐθρέψαμεν; Ἢ διψῶντα, καὶ ἐποτίσαμεν; ");
INSERT INTO grctr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Πότε δέ σε εἴδομεν ξένον, καὶ συνηγάγομεν; Ἢ γυμνόν, καὶ περιεβάλομεν; ");
INSERT INTO grctr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Πότε δέ σε εἴδομεν ἀσθενῆ, ἢ ἐν φυλακῇ, καὶ ἤλθομεν πρός σε; ");
INSERT INTO grctr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Καὶ ἀποκριθεὶς ὁ βασιλεὺς ἐρεῖ αὐτοῖς, Ἀμὴν λέγω ὑμῖν, ἐφ᾿ ὅσον ἐποιήσατε ἑνὶ τούτων τῶν ἀδελφῶν μου τῶν ἐλαχίστων, ἐμοὶ ἐποιήσατε. ");
INSERT INTO grctr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Τότε ἐρεῖ καὶ τοῖς ἐξ εὐωνύμων, Πορεύεσθε ἀπ᾿ ἐμοῦ, οἱ κατηραμένοι, εἰς τὸ πῦρ τὸ αἰώνιον, τὸ ἡτοιμασμένον τῷ διαβόλῳ καὶ τοῖς ἀγγέλοις αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ἐπείνασα γάρ, καὶ οὐκ ἐδώκατέ μοι φαγεῖν· ἐδίψησα, καὶ οὐκ ἐποτίσατέ με· ");
INSERT INTO grctr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ξένος ἤμην, καὶ οὐ συνηγάγετέ με· γυμνός, καὶ οὐ περιεβάλετέ με· ἀσθενής, καὶ ἐν φυλακῇ, καὶ οὐκ ἐπεσκέψασθέ με. ");
INSERT INTO grctr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Τότε ἀποκριθήσονται αὐτῷ καὶ αὐτοί, λέγοντες, Κύριε, πότε σὲ εἴδομεν πεινῶντα, ἢ διψῶντα, ἢ ξένον, ἢ γυμνόν, ἢ ἀσθενῆ, ἢ ἐν φυλακῇ, καὶ οὐ διηκονήσαμέν σοι; ");
INSERT INTO grctr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Τότε ἀποκριθήσεται αὐτοῖς, λέγων, Ἀμὴν λέγω ὑμῖν, ἐφ᾿ ὅσον οὐκ ἐποιήσατε ἑνὶ τούτων τῶν ἐλαχίστων, οὐδὲ ἐμοὶ ἐποιήσατε. ");
INSERT INTO grctr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Καὶ ἀπελεύσονται οὗτοι εἰς κόλασιν αἰώνιον· οἱ δὲ δίκαιοι εἰς ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς πάντας τοὺς λόγους τούτους, εἶπε τοῖς μαθηταῖς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Οἴδατε ὅτι μετὰ δύο ἡμέρας τὸ Πάσχα γίνεται, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς τὸ σταυρωθῆναι. ");
INSERT INTO grctr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Τότε συνήχθησαν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς καὶ οἱ πρεσβύτεροι τοῦ λαοῦ εἰς τὴν αὐλὴν τοῦ ἀρχιερέως τοῦ λεγομένου Καϊάφα, ");
INSERT INTO grctr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","καὶ συνεβουλεύσαντο ἵνα τὸν Ἰησοῦν κρατήσωσι δόλῳ καὶ ἀποκτείνωσιν. ");
INSERT INTO grctr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ἔλεγον δέ, Μὴ ἐν τῇ ἑορτῇ, ἵνα μὴ θόρυβος γένηται ἐν τῷ λαῷ. ");
INSERT INTO grctr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Τοῦ δὲ Ἰησοῦ γενομένου ἐν Βηθανίᾳ ἐν οἰκίᾳ Σίμωνος τοῦ λεπροῦ, ");
INSERT INTO grctr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","προσῆλθεν αὐτῷ γυνὴ ἀλάβαστρον μύρου ἔχουσα βαρυτίμου, καὶ κατέχεεν ἐπὶ τὴν κεφαλὴν αὐτοῦ ἀνακειμένου. ");
INSERT INTO grctr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ἰδόντες δὲ οἱ μαθηταὶ αὐτοῦ ἠγανάκτησαν, λέγοντες, Εἰς τί ἡ ἀπώλεια αὕτη; ");
INSERT INTO grctr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ἠδύνατο γὰρ τοῦτο τὸ μύρον πραθῆναι πολλοῦ, καὶ δοθῆναι πτωχοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Γνοὺς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Τί κόπους παρέχετε τῇ γυναικί; Ἔργον γὰρ καλὸν εἰργάσατο εἰς ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Πάντοτε γὰρ τοὺς πτωχοὺς ἔχετε μεθ᾿ ἑαυτῶν, ἐμὲ δὲ οὐ πάντοτε ἔχετε. ");
INSERT INTO grctr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Βαλοῦσα γὰρ αὕτη τὸ μύρον τοῦτο ἐπὶ τοῦ σώματός μου, πρὸς τὸ ἐνταφιάσαι με ἐποίησεν. ");
INSERT INTO grctr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ἀμὴν λέγω ὑμῖν, ὅπου ἐὰν κηρυχθῇ τὸ εὐαγγέλιον τοῦτο ἐν ὅλῳ τῷ κόσμῳ, λαληθήσεται καὶ ὃ ἐποίησεν αὕτη εἰς μνημόσυνον αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Τότε πορευθεὶς εἷς τῶν δώδεκα, ὁ λεγόμενος Ἰούδας Ἰσκαριώτης, πρὸς τοὺς ἀρχιερεῖς, ");
INSERT INTO grctr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","εἶπε, Τί θέλετέ μοι δοῦναι, κἀγὼ ὑμῖν παραδώσω αὐτόν; Οἱ δὲ ἔστησαν αὐτῷ τριάκοντα ἀργύρια, ");
INSERT INTO grctr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","καὶ ἀπὸ τότε ἐζήτει εὐκαιρίαν ἵνα αὐτὸν παραδῷ. ");
INSERT INTO grctr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Τῇ δὲ πρώτῃ τῶν ἀζύμων προσῆλθον οἱ μαθηταὶ τῷ Ἰησοῦ, λέγοντες αὐτῷ, Ποῦ θέλεις ἑτοιμάσωμέν σοι φαγεῖν τὸ Πάσχα; ");
INSERT INTO grctr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ὁ δὲ εἶπεν, Ὑπάγετε εἰς τὴν πόλιν πρὸς τὸν δεῖνα, καὶ εἴπατε αὐτῷ, Ὁ διδάσκαλος λέγει, Ὁ καιρός μου ἐγγύς ἐστι· πρὸς σε ποιῶ τὸ Πάσχα μετὰ τῶν μαθητῶν μου. ");
INSERT INTO grctr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Καὶ ἐποίησαν οἱ μαθηταὶ ὡς συνέταξεν αὐτοῖς ὁ Ἰησοῦς, καὶ ἡτοίμασαν τὸ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ὀψίας δὲ γενομένης ἀνέκειτο μετὰ τῶν δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Καὶ ἐσθιόντων αὐτῶν εἶπεν, Ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με. ");
INSERT INTO grctr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Καὶ λυπούμενοι σφόδρα ἤρξαντο λέγειν αὐτῷ ἕκαστος αὐτῶν, Μήτι ἐγώ εἰμι, Κύριε; ");
INSERT INTO grctr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ὁ δὲ ἀποκριθεὶς εἶπεν, Ὁ ἐμβάψας μετ᾿ ἐμοῦ ἐν τῷ τρυβλίῳ τὴν χεῖρα, οὗτός με παραδώσει. ");
INSERT INTO grctr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ὁ μὲν υἱὸς τοῦ ἀνθρώπου ὑπάγει, καθὼς γέγραπται περὶ αὐτοῦ· οὐαὶ δὲ τῷ ἀνθρώπῳ ἐκείνῳ δι᾿ οὗ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται· καλὸν ἦν αὐτῷ εἰ οὐκ ἐγεννήθη ὁ ἄνθρωπος ἐκεῖνος. ");
INSERT INTO grctr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ἀποκριθεὶς δὲ Ἰούδας ὁ παραδιδοὺς αὐτὸν εἶπε, Μήτι ἐγώ εἰμι, ῥαββί; Λέγει αὐτῷ, Σὺ εἶπας. ");
INSERT INTO grctr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ἐσθιόντων δὲ αὐτῶν, λαβὼν ὁ Ἰησοῦς τὸν ἄρτον, καὶ εὐλογήσας ἔκλασε καὶ ἐδίδου τοῖς μαθηταῖς, καὶ εἶπε, Λάβετε, φάγετε· τοῦτό ἐστι τὸ σῶμά μου. ");
INSERT INTO grctr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Καὶ λαβὼν τὸ ποτήριον καὶ εὐχαριστήσας ἔδωκεν αὐτοῖς, λέγων, Πίετε ἐξ αὐτοῦ πάντες· ");
INSERT INTO grctr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","τοῦτο γάρ ἐστι τὸ αἷμά μου, τὸ τῆς καινῆς διαθήκης, τὸ περὶ πολλῶν ἐκχυνόμενον εἰς ἄφεσιν ἁμαρτιῶν. ");
INSERT INTO grctr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Λέγω δὲ ὑμῖν ὅτι οὐ μὴ πίω ἀπ᾿ ἄρτι ἐκ τούτου τοῦ γεννήματος τῆς ἀμπέλου, ἕως τῆς ἡμέρας ἐκείνης ὅταν αὐτὸ πίνω μεθ᾿ ὑμῶν καινὸν ἐν τῇ βασιλείᾳ τοῦ πατρός μου. ");
INSERT INTO grctr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Καὶ ὑμνήσαντες ἐξῆλθον εἰς τὸ ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grctr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Τότε λέγει αὐτοῖς ὁ Ἰησοῦς, Πάντες ὑμεῖς σκανδαλισθήσεσθε ἐν ἐμοὶ ἐν τῇ νυκτὶ ταύτῃ· γέγραπται γάρ, Πατάξω τὸν ποιμένα, καὶ διασκορπισθήσεται τὰ πρόβατα τῆς ποίμνης. ");
INSERT INTO grctr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Μετὰ δὲ τὸ ἐγερθῆναί με, προάξω ὑμᾶς εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grctr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ἀποκριθεὶς δὲ ὁ Πέτρος εἶπεν αὐτῷ, Εἰ καὶ πάντες σκανδαλισθήσονται ἐν σοί, ἐγὼ οὐδέποτε σκανδαλισθήσομαι. ");
INSERT INTO grctr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ἔφη αὐτῷ ὁ Ἰησοῦς, Ἀμὴν λέγω σοι ὅτι ἐν ταύτῃ τῇ νυκτί, πρὶν ἀλέκτορα φωνῆσαι, τρὶς ἀπαρνήσῃ με. ");
INSERT INTO grctr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Λέγει αὐτῷ ὁ Πέτρος, Κἂν δέῃ με σὺν σοὶ ἀποθανεῖν, οὐ μή σε ἀπαρνήσομαι. Ὁμοίως καὶ πάντες οἱ μαθηταὶ εἶπον. ");
INSERT INTO grctr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Τότε ἔρχεται μετ᾿ αὐτῶν ὁ Ἰησοῦς εἰς χωρίον λεγόμενον Γεθσημανῆ, καὶ λέγει τοῖς μαθηταῖς, Καθίσατε αὐτοῦ, ἕως οὗ ἀπελθὼν προσεύξωμαι ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Καὶ παραλαβὼν τὸν Πέτρον καὶ τοὺς δύο υἱοὺς Ζεβεδαίου, ἤρξατο λυπεῖσθαι καὶ ἀδημονεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Τότε λέγει αὐτοῖς, Περίλυπός ἐστιν ἡ ψυχή μου ἕως θανάτου· μείνατε ὧδε καὶ γρηγορεῖτε μετ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Καὶ προελθὼν μικρόν, ἔπεσεν ἐπὶ πρόσωπον αὐτοῦ προσευχόμενος καὶ λέγων, Πάτερ μου, εἰ δυνατόν ἐστι, παρελθέτω ἀπ᾿ ἐμοῦ τὸ ποτήριον τοῦτο· πλὴν οὐχ ὡς ἐγὼ θέλω, ἀλλ᾿ ὡς σύ. ");
INSERT INTO grctr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Καὶ ἔρχεται πρὸς τοὺς μαθητὰς καὶ εὑρίσκει αὐτοὺς καθεύδοντας, καὶ λέγει τῷ Πέτρῳ, Οὕτως οὐκ ἰσχύσατε μίαν ὥραν γρηγορῆσαι μετ᾿ ἐμοῦ; ");
INSERT INTO grctr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Γρηγορεῖτε καὶ προσεύχεσθε, ἵνα μὴ εἰσέλθητε εἰς πειρασμόν. Τὸ μὲν πνεῦμα πρόθυμον, ἡ δὲ σὰρξ ἀσθενής. ");
INSERT INTO grctr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Πάλιν ἐκ δευτέρου ἀπελθὼν προσηύξατο, λέγων, Πάτερ μου, εἰ οὐ δύναται τοῦτο τὸ ποτήριον παρελθεῖν ἀπ᾿ ἐμοῦ, ἐὰν μὴ αὐτὸ πίω, γενηθήτω τὸ θέλημά σου. ");
INSERT INTO grctr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Καὶ ἐλθὼν εὑρίσκει αὐτοὺς πάλιν καθεύδοντας· ἦσαν γὰρ αὐτῶν οἱ ὀφθαλμοὶ βεβαρημένοι. ");
INSERT INTO grctr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Καὶ ἀφεὶς αὐτοὺς ἀπελθὼν πάλιν προσηύξατο ἐκ τρίτου, τὸν αὐτὸν λόγον εἰπών. ");
INSERT INTO grctr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Τότε ἔρχεται πρὸς τοὺς μαθητὰς αὐτοῦ, καὶ λέγει αὐτοῖς, Καθεύδετε τὸ λοιπὸν καὶ ἀναπαύεσθε. Ἰδού, ἤγγικεν ἡ ὥρα, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς χεῖρας ἁμαρτωλῶν. ");
INSERT INTO grctr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ἐγείρεσθε, ἄγωμεν. Ἰδού, ἤγγικεν ὁ παραδιδούς με. ");
INSERT INTO grctr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Καὶ ἔτι αὐτοῦ λαλοῦντος, ἰδού, Ἰούδας, εἷς τῶν δώδεκα, ἦλθε καὶ μετ᾿ αὐτοῦ ὄχλος πολὺς μετὰ μαχαιρῶν καὶ ξύλων, ἀπὸ τῶν ἀρχιερέων καὶ πρεσβυτέρων τοῦ λαοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ὁ δὲ παραδιδοὺς αὐτὸν ἔδωκεν αὐτοῖς σημεῖον, λέγων, Ὃν ἂν φιλήσω, αὐτός ἐστι· κρατήσατε αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Καὶ εὐθέως προσελθὼν τῷ Ἰησοῦ εἶπε, Χαῖρε, ῥαββί· καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Ἑταῖρε, ἐφ᾿ ᾧ πάρει; Τότε προσελθόντες ἐπέβαλον τὰς χεῖρας ἐπὶ τὸν Ἰησοῦν, καὶ ἐκράτησαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Καὶ ἰδού, εἷς τῶν μετὰ Ἰησοῦ, ἐκτείνας τὴν χεῖρα, ἀπέσπασε τὴν μάχαιραν αὐτοῦ, καὶ πατάξας τὸν δοῦλον τοῦ ἀρχιερέως ἀφεῖλεν αὐτοῦ τὸ ὠτίον. ");
INSERT INTO grctr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Τότε λέγει αὐτῷ ὁ Ἰησοῦς, Ἀπόστρεψόν σου τὴν μάχαιραν εἰς τὸν τόπον αὐτῆς· πάντες γὰρ οἱ λαβόντες μάχαιραν ἐν μαχαίρᾳ ἀπολοῦνται. ");
INSERT INTO grctr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ἢ δοκεῖς ὅτι οὐ δύναμαι ἄρτι παρακαλέσαι τὸν πατέρα μου, καὶ παραστήσει μοι πλείους ἢ δώδεκα λεγεῶνας ἀγγέλων; ");
INSERT INTO grctr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Πῶς οὖν πληρωθῶσιν αἱ γραφαί, ὅτι οὕτω δεῖ γενέσθαι; ");
INSERT INTO grctr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ἐν ἐκείνῃ τῇ ὥρᾳ εἶπεν ὁ Ἰησοῦς τοῖς ὄχλοις, Ὡς ἐπὶ λῃστὴν ἐξήλθετε μετὰ μαχαιρῶν καὶ ξύλων συλλαβεῖν με; Καθ᾿ ἡμέραν πρὸς ὑμᾶς ἐκαθεζόμην διδάσκων ἐν τῷ ἱερῷ, καὶ οὐκ ἐκρατήσατέ με. ");
INSERT INTO grctr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Τοῦτο δὲ ὅλον γέγονεν, ἵνα πληρωθῶσιν αἱ γραφαὶ τῶν προφητῶν. Τότε οἱ μαθηταὶ πάντες ἀφέντες αὐτὸν ἔφυγον. ");
INSERT INTO grctr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Οἱ δὲ κρατήσαντες τὸν Ἰησοῦν ἀπήγαγον πρὸς Καϊάφαν τὸν ἀρχιερέα, ὅπου οἱ γραμματεῖς καὶ οἱ πρεσβύτεροι συνήχθησαν. ");
INSERT INTO grctr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ὁ δὲ Πέτρος ἠκολούθει αὐτῷ ἀπὸ μακρόθεν, ἕως τῆς αὐλῆς τοῦ ἀρχιερέως· καὶ εἰσελθὼν ἔσω ἐκάθητο μετὰ τῶν ὑπηρετῶν, ἰδεῖν τὸ τέλος. ");
INSERT INTO grctr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Οἱ δὲ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι καὶ τὸ συνέδριον ὅλον ἐζήτουν ψευδομαρτυρίαν κατὰ τοῦ Ἰησοῦ, ὅπως αὐτὸν θανατώσωσιν, ");
INSERT INTO grctr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","καὶ οὐχ εὗρον. Καὶ πολλῶν ψευδομαρτύρων προσελθόντων, οὐχ εὗρον. ");
INSERT INTO grctr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ὕστερον δὲ προσελθόντες δύο ψευδομάρτυρες εἶπον, Οὗτος ἔφη, Δύναμαι καταλῦσαι τὸν ναὸν τοῦ Θεοῦ, καὶ διὰ τριῶν ἡμερῶν οἰκοδομῆσαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Καὶ ἀναστὰς ὁ ἀρχιερεὺς εἶπεν αὐτῷ, Οὐδὲν ἀποκρίνῃ; Τί οὗτοί σου καταμαρτυροῦσιν; ");
INSERT INTO grctr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ὁ δὲ Ἰησοῦς ἐσιώπα. Καὶ ἀποκριθεὶς ὁ ἀρχιερεὺς εἶπεν αὐτῷ, Ἐξορκίζω σε κατὰ τοῦ Θεοῦ τοῦ ζῶντος, ἵνα ἡμῖν εἴπῃς εἰ σὺ εἶ ὁ Χριστός, ὁ υἱὸς τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Λέγει αὐτῷ ὁ Ἰησοῦς, Σὺ εἶπας. Πλὴν λέγω ὑμῖν, ἀπ᾿ ἄρτι ὄψεσθε τὸν υἱὸν τοῦ ἀνθρώπου καθήμενον ἐκ δεξιῶν τῆς δυνάμεως καὶ ἐρχόμενον ἐπὶ τῶν νεφελῶν τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Τότε ὁ ἀρχιερεὺς διέρρηξε τὰ ἱμάτια αὐτοῦ, λέγων ὅτι Ἐβλασφήμησε· τί ἔτι χρείαν ἔχομεν μαρτύρων; Ἴδε, νῦν ἠκούσατε τὴν βλασφημίαν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Τί ὑμῖν δοκεῖ; Οἱ δὲ ἀποκριθέντες εἶπον, Ἔνοχος θανάτου ἐστί. ");
INSERT INTO grctr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Τότε ἐνέπτυσαν εἰς τὸ πρόσωπον αὐτοῦ καὶ ἐκολάφισαν αὐτόν· οἱ δὲ ἐρράπισαν, ");
INSERT INTO grctr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","λέγοντες, Προφήτευσον ἡμῖν, Χριστέ. Τίς ἐστιν ὁ παίσας σε; ");
INSERT INTO grctr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ὁ δὲ Πέτρος ἔξω ἐκάθητο ἐν τῇ αὐλῇ· καὶ προσῆλθεν αὐτῷ μία παιδίσκη, λέγουσα, Καὶ σὺ ἦσθα μετὰ Ἰησοῦ τοῦ Γαλιλαίου. ");
INSERT INTO grctr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ὁ δὲ ἠρνήσατο ἔμπροσθεν πάντων, λέγων, Οὐκ οἶδα τί λέγεις. ");
INSERT INTO grctr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ἐξελθόντα δὲ αὐτὸν εἰς τὸν πυλῶνα, εἶδεν αὐτὸν ἄλλη, καὶ λέγει τοῖς ἐκεῖ, Καὶ οὗτος ἦν μετὰ Ἰησοῦ τοῦ Ναζωραίου. ");
INSERT INTO grctr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Καὶ πάλιν ἠρνήσατο μεθ᾿ ὅρκου ὅτι Οὐκ οἶδα τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Μετὰ μικρὸν δὲ προσελθόντες οἱ ἑστῶτες εἶπον τῷ Πέτρῳ, Ἀληθῶς καὶ σὺ ἐξ αὐτῶν εἶ· καὶ γὰρ ἡ λαλιά σου δῆλόν σε ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Τότε ἤρξατο καταναθεματίζειν καὶ ὀμνύειν ὅτι Οὐκ οἶδα τὸν ἄνθρωπον. Καὶ εὐθέως ἀλέκτωρ ἐφώνησε. ");
INSERT INTO grctr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Καὶ ἐμνήσθη ὁ Πέτρος τοῦ ῥήματος τοῦ Ἰησοῦ εἰρηκότος αὐτῷ ὅτι Πρὶν ἀλέκτορα φωνῆσαι, τρὶς ἀπαρνήσῃ με. Καὶ ἐξελθὼν ἔξω ἔκλαυσε πικρῶς. ");
INSERT INTO grctr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Πρωΐας δὲ γενομένης, συμβούλιον ἔλαβον πάντες οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τοῦ λαοῦ κατὰ τοῦ Ἰησοῦ, ὥστε θανατῶσαι αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","καὶ δήσαντες αὐτὸν ἀπήγαγον καὶ παρέδωκαν αὐτὸν Ποντίῳ Πιλάτῳ τῷ ἡγεμόνι. ");
INSERT INTO grctr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Τότε ἰδὼν Ἰούδας ὁ παραδιδοὺς αὐτὸν ὅτι κατεκρίθη, μεταμεληθεὶς ἀπέστρεψε τὰ τριάκοντα ἀργύρια τοῖς ἀρχιερεῦσι καὶ τοῖς πρεσβυτέροις, ");
INSERT INTO grctr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","λέγων, Ἥμαρτον παραδοὺς αἷμα ἀθῷον. Οἱ δὲ εἶπον, Τί πρὸς ἡμᾶς; Σὺ ὄψει. ");
INSERT INTO grctr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Καὶ ῥίψας τὰ ἀργύρια ἐν τῷ ναῷ, ἀνεχώρησε· καὶ ἀπελθὼν ἀπήγξατο. ");
INSERT INTO grctr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Οἱ δὲ ἀρχιερεῖς λαβόντες τὰ ἀργύρια εἶπον, Οὐκ ἔξεστι βαλεῖν αὐτὰ εἰς τὸν κορβανᾶν, ἐπεὶ τιμὴ αἵματός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Συμβούλιον δὲ λαβόντες ἠγόρασαν ἐξ αὐτῶν τὸν ἀγρὸν τοῦ κεραμέως, εἰς ταφὴν τοῖς ξένοις. ");
INSERT INTO grctr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Διὸ ἐκλήθη ὁ ἀγρὸς ἐκεῖνος Ἀγρὸς Αἵματος, ἕως τῆς σήμερον. ");
INSERT INTO grctr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Τότε ἐπληρώθη τὸ ῥηθὲν διὰ Ἰερεμίου τοῦ προφήτου, λέγοντος, Καὶ ἔλαβον τὰ τριάκοντα ἀργύρια, τὴν τιμὴν τοῦ τετιμημένου, ὃν ἐτιμήσαντο ἀπὸ υἱῶν Ἰσραήλ· ");
INSERT INTO grctr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","καὶ ἔδωκαν αὐτὰ εἰς τὸν ἀγρὸν τοῦ κεραμέως, καθὰ συνέταξέ μοι Κύριος. ");
INSERT INTO grctr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ὁ δὲ Ἰησοῦς ἔστη ἔμπροσθεν τοῦ ἡγεμόνος· καὶ ἐπηρώτησεν αὐτὸν ὁ ἡγεμών, λέγων, Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; Ὁ δὲ Ἰησοῦς ἔφη αὐτῷ, Σὺ λέγεις. ");
INSERT INTO grctr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Καὶ ἐν τῷ κατηγορεῖσθαι αὐτὸν ὑπὸ τῶν ἀρχιερέων καὶ τῶν πρεσβυτέρων, οὐδὲν ἀπεκρίνατο. ");
INSERT INTO grctr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Τότε λέγει αὐτῷ ὁ Πιλάτος, Οὐκ ἀκούεις πόσα σου καταμαρτυροῦσι; ");
INSERT INTO grctr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Καὶ οὐκ ἀπεκρίθη αὐτῷ πρὸς οὐδὲ ἓν ῥῆμα, ὥστε θαυμάζειν τὸν ἡγεμόνα λίαν. ");
INSERT INTO grctr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Κατὰ δὲ ἑορτὴν εἰώθει ὁ ἡγεμὼν ἀπολύειν ἕνα τῷ ὄχλῳ δέσμιον, ὃν ἤθελον. ");
INSERT INTO grctr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Εἶχον δὲ τότε δέσμιον ἐπίσημον, λεγόμενον Βαραββᾶν. ");
INSERT INTO grctr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Συνηγμένων οὖν αὐτῶν, εἶπεν αὐτοῖς ὁ Πιλάτος, Τίνα θέλετε ἀπολύσω ὑμῖν; Βαραββᾶν, ἢ Ἰησοῦν τὸν λεγόμενον Χριστόν; ");
INSERT INTO grctr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ᾜδει γὰρ ὅτι διὰ φθόνον παρέδωκαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Καθημένου δὲ αὐτοῦ ἐπὶ τοῦ βήματος, ἀπέστειλε πρὸς αὐτὸν ἡ γυνὴ αὐτοῦ, λέγουσα, Μηδέν σοι καὶ τῷ δικαίῳ ἐκείνῳ· πολλὰ γὰρ ἔπαθον σήμερον κατ᾿ ὄναρ δι᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Οἱ δὲ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι ἔπεισαν τοὺς ὄχλους ἵνα αἰτήσωνται τὸν Βαραββᾶν, τὸν δὲ Ἰησοῦν ἀπολέσωσιν. ");
INSERT INTO grctr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ἀποκριθεὶς δὲ ὁ ἡγεμὼν εἶπεν αὐτοῖς, Τίνα θέλετε ἀπὸ τῶν δύο ἀπολύσω ὑμῖν; Οἱ δὲ εἶπον, Βαραββᾶν. ");
INSERT INTO grctr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Λέγει αὐτοῖς ὁ Πιλάτος, Τί οὖν ποιήσω Ἰησοῦν τὸν λεγόμενον Χριστόν; Λέγουσιν αὐτῷ πάντες, Σταυρωθήτω. ");
INSERT INTO grctr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ὁ δὲ ἡγεμὼν ἔφη, Τί γὰρ κακὸν ἐποίησεν; Οἱ δὲ περισσῶς ἔκραζον, λέγοντες, Σταυρωθήτω. ");
INSERT INTO grctr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ἰδὼν δὲ ὁ Πιλάτος ὅτι οὐδὲν ὠφελεῖ, ἀλλὰ μᾶλλον θόρυβος γίνεται, λαβὼν ὕδωρ, ἀπενίψατο τὰς χεῖρας ἀπέναντι τοῦ ὄχλου, λέγων, Ἀθῷός εἰμι ἀπὸ τοῦ αἵματος τοῦ δικαίου τούτου· ὑμεῖς ὄψεσθε. ");
INSERT INTO grctr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Καὶ ἀποκριθεὶς πᾶς ὁ λαὸς εἶπε, Τὸ αἷμα αὐτοῦ ἐφ᾿ ἡμᾶς καὶ ἐπὶ τὰ τέκνα ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Τότε ἀπέλυσεν αὐτοῖς τὸν Βαραββᾶν· τὸν δὲ Ἰησοῦν φραγελλώσας παρέδωκεν ἵνα σταυρωθῇ. ");
INSERT INTO grctr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Τότε οἱ στρατιῶται τοῦ ἡγεμόνος, παραλαβόντες τὸν Ἰησοῦν εἰς τὸ πραιτώριον, συνήγαγον ἐπ᾿ αὐτὸν ὅλην τὴν σπεῖραν· ");
INSERT INTO grctr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","καὶ ἐκδύσαντες αὐτόν, περιέθηκαν αὐτῷ χλαμύδα κοκκίνην. ");
INSERT INTO grctr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Καὶ πλέξαντες στέφανον ἐξ ἀκανθῶν, ἐπέθηκαν ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ κάλαμον ἐπὶ τὴν δεξιὰν αὐτοῦ· καὶ γονυπετήσαντες ἔμπροσθεν αὐτοῦ ἐνέπαιζον αὐτῷ, λέγοντες, Χαῖρε, ὁ βασιλεὺς τῶν Ἰουδαίων· ");
INSERT INTO grctr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","καὶ ἐμπτύσαντες εἰς αὐτόν, ἔλαβον τὸν κάλαμον, καὶ ἔτυπτον εἰς τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Καὶ ὅτε ἐνέπαιξαν αὐτῷ, ἐξέδυσαν αὐτὸν τὴν χλαμύδα, καὶ ἐνέδυσαν αὐτὸν τὰ ἱμάτια αὐτοῦ, καὶ ἀπήγαγον αὐτὸν εἰς τὸ σταυρῶσαι. ");
INSERT INTO grctr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ἐξερχόμενοι δὲ εὗρον ἄνθρωπον Κυρηναῖον, ὀνόματι Σίμωνα· τοῦτον ἠγγάρευσαν ἵνα ἄρῃ τὸν σταυρὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Καὶ ἐλθόντες εἰς τόπον λεγόμενον Γολγοθᾶ, ὅς ἐστι λεγόμενος Κρανίου Τόπος, ");
INSERT INTO grctr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ἔδωκαν αὐτῷ πιεῖν ὄξος μετὰ χολῆς μεμιγμένον· καὶ γευσάμενος οὐκ ἤθελε πιεῖν. ");
INSERT INTO grctr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Σταυρώσαντες δὲ αὐτόν, διεμερίσαντο τὰ ἱμάτια αὐτοῦ, βάλλοντες κλῆρον· ἵνα πληρωθῇ τὸ ῥηθὲν ὑπὸ τοῦ προφήτου, Διεμερίσαντο τὰ ἱμάτιά μου ἑαυτοῖς, καὶ ἐπὶ τὸν ἱματισμόν μου ἔβαλον κλῆρον. ");
INSERT INTO grctr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Καὶ καθήμενοι ἐτήρουν αὐτὸν ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Καὶ ἐπέθηκαν ἐπάνω τῆς κεφαλῆς αὐτοῦ τὴν αἰτίαν αὐτοῦ γεγραμμένην, Οὗτός ἐστιν Ἰησοῦς ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Τότε σταυροῦνται σὺν αὐτῷ δύο λῃσταί, εἷς ἐκ δεξιῶν καὶ εἷς ἐξ εὐωνύμων. ");
INSERT INTO grctr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Οἱ δὲ παραπορευόμενοι ἐβλασφήμουν αὐτόν, κινοῦντες τὰς κεφαλὰς αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","καὶ λέγοντες, Ὁ καταλύων τὸν ναὸν καὶ ἐν τρισὶν ἡμέραις οἰκοδομῶν, σῶσον σεαυτόν· εἰ υἱὸς εἶ τοῦ Θεοῦ, κατάβηθι ἀπὸ τοῦ σταυροῦ. ");
INSERT INTO grctr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ὁμοίως δὲ καὶ οἱ ἀρχιερεῖς ἐμπαίζοντες μετὰ τῶν γραμματέων καὶ πρεσβυτέρων ἔλεγον, ");
INSERT INTO grctr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ἄλλους ἔσωσεν, ἑαυτὸν οὐ δύναται σῶσαι. Εἰ βασιλεὺς Ἰσραήλ ἐστι, καταβάτω νῦν ἀπὸ τοῦ σταυροῦ, καὶ πιστεύσομεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Πέποιθεν ἐπὶ τὸν Θεόν· ῥυσάσθω νῦν αὐτόν, εἰ θέλει αὐτόν. Εἶπε γὰρ ὅτι Θεοῦ εἰμι υἱός. ");
INSERT INTO grctr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Τὸ δ᾿ αὐτὸ καὶ οἱ λῃσταὶ οἱ συσταυρωθέντες αὐτῷ ὠνείδιζον αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ἀπὸ δὲ ἕκτης ὥρας σκότος ἐγένετο ἐπὶ πᾶσαν τὴν γῆν ἕως ὥρας ἐννάτης. ");
INSERT INTO grctr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Περὶ δὲ τὴν ἐννάτην ὥραν ἀνεβόησεν ὁ Ἰησοῦς φωνῇ μεγάλῃ, λέγων, Ἠλί, Ἠλί, λαμὰ σαβαχθανί; Τοῦτ᾿ ἔστι, Θεέ μου, Θεέ μου, ἵνα τί με ἐγκατέλιπες; ");
INSERT INTO grctr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Τινὲς δὲ τῶν ἐκεῖ ἑστώτων ἀκούσαντες ἔλεγον ὅτι Ἠλίαν φωνεῖ οὗτος. ");
INSERT INTO grctr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Καὶ εὐθέως δραμὼν εἷς ἐξ αὐτῶν, καὶ λαβὼν σπόγγον, πλήσας τε ὄξους, καὶ περιθεὶς καλάμῳ, ἐπότιζεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Οἱ δὲ λοιποὶ ἔλεγον, Ἄφες, ἴδωμεν εἰ ἔρχεται Ἠλίας σώσων αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ὁ δὲ Ἰησοῦς πάλιν κράξας φωνῇ μεγάλῃ ἀφῆκε τὸ πνεῦμα. ");
INSERT INTO grctr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Καὶ ἰδού, τὸ καταπέτασμα τοῦ ναοῦ ἐσχίσθη εἰς δύο ἀπὸ ἄνωθεν ἕως κάτω· καὶ ἡ γῆ ἐσείσθη· καὶ αἱ πέτραι ἐσχίσθησαν· ");
INSERT INTO grctr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","καὶ τὰ μνημεῖα ἀνεῴχθησαν· καὶ πολλὰ σώματα τῶν κεκοιμημένων ἁγίων ἠγέρθη· ");
INSERT INTO grctr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","καὶ ἐξελθόντες ἐκ τῶν μνημείων μετὰ τὴν ἔγερσιν αὐτοῦ εἰσῆλθον εἰς τὴν ἁγίαν πόλιν, καὶ ἐνεφανίσθησαν πολλοῖς. ");
INSERT INTO grctr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ὁ δὲ ἑκατόνταρχος καὶ οἱ μετ᾿ αὐτοῦ τηροῦντες τὸν Ἰησοῦν, ἰδόντες τὸν σεισμὸν καὶ τὰ γενόμενα, ἐφοβήθησαν σφόδρα, λέγοντες, Ἀληθῶς Θεοῦ υἱὸς ἦν οὗτος. ");
INSERT INTO grctr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ἦσαν δὲ ἐκεῖ γυναῖκες πολλαὶ ἀπὸ μακρόθεν θεωροῦσαι, αἵτινες ἠκολούθησαν τῷ Ἰησοῦ ἀπὸ τῆς Γαλιλαίας, διακονοῦσαι αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ἐν αἷς ἦν Μαρία ἡ Μαγδαληνή, καὶ Μαρία ἡ τοῦ Ἰακώβου καὶ Ἰωσῆ μήτηρ, καὶ ἡ μήτηρ τῶν υἱῶν Ζεβεδαίου. ");
INSERT INTO grctr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ὀψίας δὲ γενομένης, ἦλθεν ἄνθρωπος πλούσιος ἀπὸ Ἀριμαθαίας, τοὔνομα Ἰωσήφ, ὃς καὶ αὐτὸς ἐμαθήτευσε τῷ Ἰησοῦ· ");
INSERT INTO grctr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","οὗτος προσελθὼν τῷ Πιλάτῳ, ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ. Τότε ὁ Πιλάτος ἐκέλευσεν ἀποδοθῆναι τὸ σῶμα. ");
INSERT INTO grctr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Καὶ λαβὼν τὸ σῶμα ὁ Ἰωσὴφ ἐνετύλιξεν αὐτὸ σινδόνι καθαρᾷ, ");
INSERT INTO grctr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","καὶ ἔθηκεν αὐτὸ ἐν τῷ καινῷ αὐτοῦ μνημείῳ, ὃ ἐλατόμησεν ἐν τῇ πέτρᾳ· καὶ προσκυλίσας λίθον μέγαν τῇ θύρᾳ τοῦ μνημείου, ἀπῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ἦν δὲ ἐκεῖ Μαρία ἡ Μαγδαληνή, καὶ ἡ ἄλλη Μαρία, καθήμεναι ἀπέναντι τοῦ τάφου. ");
INSERT INTO grctr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Τῇ δὲ ἐπαύριον, ἥτις ἐστὶ μετὰ τὴν Παρασκευήν, συνήχθησαν οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι πρὸς Πιλάτον, ");
INSERT INTO grctr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","λέγοντες, Κύριε, ἐμνήσθημεν ὅτι ἐκεῖνος ὁ πλάνος εἶπεν ἔτι ζῶν, Μετὰ τρεῖς ἡμέρας ἐγείρομαι. ");
INSERT INTO grctr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Κέλευσον οὖν ἀσφαλισθῆναι τὸν τάφον ἕως τῆς τρίτης ἡμέρας· μήποτε ἐλθόντες οἱ μαθηταὶ αὐτοῦ νυκτὸς κλέψωσιν αὐτόν, καὶ εἴπωσι τῷ λαῷ, Ἠγέρθη ἀπὸ τῶν νεκρῶν· καὶ ἔσται ἡ ἐσχάτη πλάνη χείρων τῆς πρώτης. ");
INSERT INTO grctr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ἔφη δὲ αὐτοῖς ὁ Πιλάτος, Ἔχετε κουστωδίαν· ὑπάγετε, ἀσφαλίσασθε ὡς οἴδατε. ");
INSERT INTO grctr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Οἱ δὲ πορευθέντες ἠσφαλίσαντο τὸν τάφον, σφραγίσαντες τὸν λίθον, μετὰ τῆς κουστωδίας. ");
INSERT INTO grctr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ὀψὲ δὲ σαββάτων, τῇ ἐπιφωσκούσῃ εἰς μίαν σαββάτων, ἦλθε Μαρία ἡ Μαγδαληνή, καὶ ἡ ἄλλη Μαρία, θεωρῆσαι τὸν τάφον. ");
INSERT INTO grctr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Καὶ ἰδού, σεισμὸς ἐγένετο μέγας· ἄγγελος γὰρ Κυρίου καταβὰς ἐξ οὐρανοῦ, προσελθὼν ἀπεκύλισε τὸν λίθον ἀπὸ τῆς θύρας, καὶ ἐκάθητο ἐπάνω αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ἦν δὲ ἡ ἰδέα αὐτοῦ ὡς ἀστραπή, καὶ τὸ ἔνδυμα αὐτοῦ λευκὸν ὡσεὶ χιών. ");
INSERT INTO grctr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ἀπὸ δὲ τοῦ φόβου αὐτοῦ ἐσείσθησαν οἱ τηροῦντες καὶ ἐγένοντο ὡσεὶ νεκροί. ");
INSERT INTO grctr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ἀποκριθεὶς δὲ ὁ ἄγγελος εἶπε ταῖς γυναιξί, Μὴ φοβεῖσθε ὑμεῖς· οἶδα γὰρ ὅτι Ἰησοῦν τὸν ἐσταυρωμένον ζητεῖτε. ");
INSERT INTO grctr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Οὐκ ἔστιν ὧδε· ἠγέρθη γάρ, καθὼς εἶπε. Δεῦτε, ἴδετε τὸν τόπον ὅπου ἔκειτο ὁ Κύριος. ");
INSERT INTO grctr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Καὶ ταχὺ πορευθεῖσαι εἴπατε τοῖς μαθηταῖς αὐτοῦ ὅτι Ἠγέρθη ἀπὸ τῶν νεκρῶν· καὶ ἰδού, προάγει ὑμᾶς εἰς τὴν Γαλιλαίαν· ἐκεῖ αὐτὸν ὄψεσθε· ἰδού, εἶπον ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Καὶ ἐξελθοῦσαι ταχὺ ἀπὸ τοῦ μνημείου μετὰ φόβου καὶ χαρᾶς μεγάλης, ἔδραμον ἀπαγγεῖλαι τοῖς μαθηταῖς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ὡς δὲ ἐπορεύοντο ἀπαγγεῖλαι τοῖς μαθηταῖς αὐτοῦ, καὶ ἰδού, ὁ Ἰησοῦς ἀπήντησεν αὐταῖς, λέγων, Χαίρετε. Αἱ δὲ προσελθοῦσαι ἐκράτησαν αὐτοῦ τοὺς πόδας, καὶ προσεκύνησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Τότε λέγει αὐταῖς ὁ Ἰησοῦς· Μὴ φοβεῖσθε· ὑπάγετε, ἀπαγγείλατε τοῖς ἀδελφοῖς μου ἵνα ἀπέλθωσιν εἰς τὴν Γαλιλαίαν, κἀκεῖ με ὄψονται. ");
INSERT INTO grctr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Πορευομένων δὲ αὐτῶν, ἰδού, τινὲς τῆς κουστωδίας ἐλθόντες εἰς τὴν πόλιν ἀπήγγειλαν τοῖς ἀρχιερεῦσιν ἅπαντα τὰ γενόμενα. ");
INSERT INTO grctr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Καὶ συναχθέντες μετὰ τῶν πρεσβυτέρων, συμβούλιόν τε λαβόντες, ἀργύρια ἱκανὰ ἔδωκαν τοῖς στρατιώταις, ");
INSERT INTO grctr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","λέγοντες, Εἴπατε ὅτι Οἱ μαθηταὶ αὐτοῦ νυκτὸς ἐλθόντες ἔκλεψαν αὐτὸν ἡμῶν κοιμωμένων. ");
INSERT INTO grctr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Καὶ ἐὰν ἀκουσθῇ τοῦτο ἐπὶ τοῦ ἡγεμόνος, ἡμεῖς πείσομεν αὐτόν, καὶ ὑμᾶς ἀμερίμνους ποιήσομεν. ");
INSERT INTO grctr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Οἱ δὲ λαβόντες τὰ ἀργύρια ἐποίησαν ὡς ἐδιδάχθησαν. Καὶ διεφημίσθη ὁ λόγος οὗτος παρὰ Ἰουδαίοις μέχρι τῆς σήμερον. ");
INSERT INTO grctr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Οἱ δὲ ἕνδεκα μαθηταὶ ἐπορεύθησαν εἰς τὴν Γαλιλαίαν, εἰς τὸ ὄρος οὗ ἐτάξατο αὐτοῖς ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Καὶ ἰδόντες αὐτὸν προσεκύνησαν αὐτῷ· οἱ δὲ ἐδίστασαν. ");
INSERT INTO grctr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Καὶ προσελθὼν ὁ Ἰησοῦς ἐλάλησεν αὐτοῖς, λέγων, Ἐδόθη μοι πᾶσα ἐξουσία ἐν οὐρανῷ καὶ ἐπὶ γῆς. ");
INSERT INTO grctr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Πορευθέντες οὖν μαθητεύσατε πάντα τὰ ἔθνη, βαπτίζοντες αὐτοὺς εἰς τὸ ὄνομα τοῦ Πατρὸς καὶ τοῦ Υἱοῦ καὶ τοῦ Ἁγίου Πνεύματος· ");
INSERT INTO grctr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","διδάσκοντες αὐτοὺς τηρεῖν πάντα ὅσα ἐνετειλάμην ὑμῖν· καὶ ἰδού, ἐγὼ μεθ᾿ ὑμῶν εἰμι πάσας τὰς ἡμέρας ἕως τῆς συντελείας τοῦ αἰῶνος. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ἀρχὴ τοῦ εὐαγγελίου Ἰησοῦ Χριστοῦ, υἱοῦ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ὡς γέγραπται ἐν τοῖς προφήταις, Ἰδού, ἐγὼ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν σου ἔμπροσθέν σου. ");
INSERT INTO grctr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Φωνὴ βοῶντος ἐν τῇ ἐρήμῳ, Ἑτοιμάσατε τὴν ὁδὸν Κυρίου· εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ἐγένετο Ἰωάννης βαπτίζων ἐν τῇ ἐρήμῳ, καὶ κηρύσσων βάπτισμα μετανοίας εἰς ἄφεσιν ἁμαρτιῶν. ");
INSERT INTO grctr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Καὶ ἐξεπορεύετο πρὸς αὐτὸν πᾶσα ἡ Ἰουδαία χώρα, καὶ οἱ Ἱεροσολυμῖται, καὶ ἐβαπτίζοντο πάντες ἐν τῷ Ἰορδάνῃ ποταμῷ ὑπ᾿ αὐτοῦ, ἐξομολογούμενοι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ἦν δὲ Ἰωάννης ἐνδεδυμένος τρίχας καμήλου, καὶ ζώνην δερματίνην περὶ τὴν ὀσφὺν αὐτοῦ, καὶ ἐσθίων ἀκρίδας καὶ μέλι ἄγριον. ");
INSERT INTO grctr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Καὶ ἐκήρυσσε, λέγων, Ἔρχεται ὁ ἰσχυρότερός μου ὀπίσω μου, οὗ οὐκ εἰμὶ ἱκανὸς κύψας λῦσαι τὸν ἱμάντα τῶν ὑποδημάτων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ἐγὼ μὲν ἐβάπτισα ὑμᾶς ἐν ὕδατι· αὐτὸς δὲ βαπτίσει ὑμᾶς ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grctr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Καὶ ἐγένετο ἐν ἐκείναις ταῖς ἡμέραις, ἦλθεν Ἰησοῦς ἀπὸ Ναζαρὲθ τῆς Γαλιλαίας, καὶ ἐβαπτίσθη ὑπὸ Ἰωάννου εἰς τὸν Ἰορδάνην. ");
INSERT INTO grctr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Καὶ εὐθέως ἀναβαίνων ἀπὸ τοῦ ὕδατος, εἶδε σχιζομένους τοὺς οὐρανούς, καὶ τὸ πνεῦμα ὡσεὶ περιστερὰν καταβαῖνον ἐπ᾿ αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","καὶ φωνὴ ἐγένετο ἐκ τῶν οὐρανῶν, Σὺ εἶ ὁ υἱός μου ὁ ἀγαπητός, ἐν ᾧ εὐδόκησα. ");
INSERT INTO grctr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Καὶ εὐθὺς τὸ πνεῦμα αὐτὸν ἐκβάλλει εἰς τὴν ἔρημον. ");
INSERT INTO grctr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Καὶ ἦν ἐκεῖ ἐν τῇ ἐρήμῳ ἡμέρας τεσσαράκοντα πειραζόμενος ὑπὸ τοῦ Σατανᾶ, καὶ ἦν μετὰ τῶν θηρίων, καὶ οἱ ἄγγελοι διηκόνουν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Μετὰ δὲ τὸ παραδοθῆναι τὸν Ἰωάννην, ἦλθεν ὁ Ἰησοῦς εἰς τὴν Γαλιλαίαν, κηρύσσων τὸ εὐαγγέλιον τῆς βασιλείας τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","καὶ λέγων ὅτι Πεπλήρωται ὁ καιρός, καὶ ἤγγικεν ἡ βασιλεία τοῦ Θεοῦ· μετανοεῖτε, καὶ πιστεύετε ἐν τῷ εὐαγγελίῳ. ");
INSERT INTO grctr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Περιπατῶν δὲ παρὰ τὴν θάλασσαν τῆς Γαλιλαίας εἶδε Σίμωνα καὶ Ἀνδρέαν τὸν ἀδελφὸν αὐτοῦ βάλλοντας ἀμφίβληστρον ἐν τῇ θαλάσσῃ· ἦσαν γὰρ ἁλιεῖς. ");
INSERT INTO grctr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς, Δεῦτε ὀπίσω μου, καὶ ποιήσω ὑμᾶς γενέσθαι ἁλιεῖς ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Καὶ εὐθέως ἀφέντες τὰ δίκτυα αὐτῶν, ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Καὶ προβὰς ἐκεῖθεν ὀλίγον, εἶδεν Ἰάκωβον τὸν τοῦ Ζεβεδαίου, καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, καὶ αὐτοὺς ἐν τῷ πλοίῳ καταρτίζοντας τὰ δίκτυα. ");
INSERT INTO grctr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Καὶ εὐθέως ἐκάλεσεν αὐτούς· καὶ ἀφέντες τὸν πατέρα αὐτῶν Ζεβεδαῖον ἐν τῷ πλοίῳ μετὰ τῶν μισθωτῶν ἀπῆλθον ὀπίσω αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Καὶ εἰσπορεύονται εἰς Καπερναούμ· καὶ εὐθέως τοῖς σάββασιν εἰσελθὼν εἰς τὴν συναγωγήν, ἐδίδασκε. ");
INSERT INTO grctr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Καὶ ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ· ἦν γὰρ διδάσκων αὐτοὺς ὡς ἐξουσίαν ἔχων, καὶ οὐχ ὡς οἱ γραμματεῖς. ");
INSERT INTO grctr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Καὶ ἦν ἐν τῇ συναγωγῇ αὐτῶν ἄνθρωπος ἐν πνεύματι ἀκαθάρτῳ, καὶ ἀνέκραξε, ");
INSERT INTO grctr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","λέγων, Ἔα, τί ἡμῖν καὶ σοί, Ἰησοῦ Ναζαρηνέ; Ἦλθες ἀπολέσαι ἡμᾶς; Οἶδά σε τίς εἶ, ὁ ἅγιος τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς, λέγων, Φιμώθητι, καὶ ἔξελθε ἐξ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Καὶ σπαράξαν αὐτὸν τὸ πνεῦμα τὸ ἀκάθαρτον καὶ κράξαν φωνῇ μεγάλῃ, ἐξῆλθεν ἐξ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Καὶ ἐθαμβήθησαν πάντες, ὥστε συζητεῖν πρὸς αὐτούς, λέγοντας, Τί ἐστι τοῦτο; Τίς ἡ διδαχὴ ἡ καινὴ αὕτη, ὅτι κατ᾿ ἐξουσίαν καὶ τοῖς πνεύμασι τοῖς ἀκαθάρτοις ἐπιτάσσει, καὶ ὑπακούουσιν αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ἐξῆλθε δὲ ἡ ἀκοὴ αὐτοῦ εὐθὺς εἰς ὅλην τὴν περίχωρον τῆς Γαλιλαίας. ");
INSERT INTO grctr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Καὶ εὐθέως ἐκ τῆς συναγωγῆς ἐξελθόντες, ἦλθον εἰς τὴν οἰκίαν Σίμωνος καὶ Ἀνδρέου, μετὰ Ἰακώβου καὶ Ἰωάννου. ");
INSERT INTO grctr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ἡ δὲ πενθερὰ Σίμωνος κατέκειτο πυρέσσουσα, καὶ εὐθέως λέγουσιν αὐτῷ περὶ αὐτῆς· ");
INSERT INTO grctr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","καὶ προσελθὼν ἤγειρεν αὐτήν, κρατήσας τῆς χειρὸς αὐτῆς· καὶ ἀφῆκεν αὐτὴν ὁ πυρετὸς εὐθέως, καὶ διηκόνει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ὀψίας δὲ γενομένης, ὅτε ἔδυ ὁ ἥλιος, ἔφερον πρὸς αὐτὸν πάντας τοὺς κακῶς ἔχοντας καὶ τοὺς δαιμονιζομένους· ");
INSERT INTO grctr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","καὶ ἡ πόλις ὅλη ἐπισυνηγμένη ἦν πρὸς τὴν θύραν. ");
INSERT INTO grctr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Καὶ ἐθεράπευσε πολλοὺς κακῶς ἔχοντας ποικίλαις νόσοις, καὶ δαιμόνια πολλὰ ἐξέβαλε, καὶ οὐκ ἤφιε λαλεῖν τὰ δαιμόνια, ὅτι ᾔδεισαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Καὶ πρωῒ ἔννυχον λίαν ἀναστὰς ἐξῆλθε, καὶ ἀπῆλθεν εἰς ἔρημον τόπον, κἀκεῖ προσηύχετο. ");
INSERT INTO grctr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Καὶ κατεδίωξαν αὐτὸν ὁ Σίμων καὶ οἱ μετ᾿ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","καὶ εὑρόντες αὐτὸν λέγουσιν αὐτῷ ὅτι Πάντες ζητοῦσί σε. ");
INSERT INTO grctr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Καὶ λέγει αὐτοῖς, Ἄγωμεν εἰς τὰς ἐχομένας κωμοπόλεις, ἵνα κἀκεῖ κηρύξω· εἰς τοῦτο γὰρ ἐξελήλυθα. ");
INSERT INTO grctr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Καὶ ἦν κηρύσσων ἐν ταῖς συναγωγαῖς αὐτῶν εἰς ὅλην τὴν Γαλιλαίαν, καὶ τὰ δαιμόνια ἐκβάλλων. ");
INSERT INTO grctr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Καὶ ἔρχεται πρὸς αὐτὸν λεπρός, παρακαλῶν αὐτὸν καὶ γονυπετῶν αὐτόν, καὶ λέγων αὐτῷ ὅτι Ἐὰν θέλῃς, δύνασαί με καθαρίσαι. ");
INSERT INTO grctr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ὁ δὲ Ἰησοῦς σπλαγχνισθείς, ἐκτείνας τὴν χεῖρα, ἥψατο αὐτοῦ, καὶ λέγει αὐτῷ, Θέλω, καθαρίσθητι. ");
INSERT INTO grctr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Καὶ εἰπόντος αὐτοῦ εὐθέως ἀπῆλθεν ἀπ᾿ αὐτοῦ ἡ λέπρα, καὶ ἐκαθαρίσθη. ");
INSERT INTO grctr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Καὶ ἐμβριμησάμενος αὐτῷ, εὐθέως ἐξέβαλεν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","καὶ λέγει αὐτῷ, Ὅρα μηδενὶ μηδὲν εἴπῃς· ἀλλ᾿ ὕπαγε, σεαυτὸν δεῖξον τῷ ἱερεῖ, καὶ προσένεγκε περὶ τοῦ καθαρισμοῦ σου ἃ προσέταξε Μωσῆς, εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ὁ δὲ ἐξελθὼν ἤρξατο κηρύσσειν πολλὰ καὶ διαφημίζειν τὸν λόγον, ὥστε μηκέτι αὐτὸν δύνασθαι φανερῶς εἰς πόλιν εἰσελθεῖν, ἀλλ᾿ ἔξω ἐν ἐρήμοις τόποις ἦν· καὶ ἤρχοντο πρὸς αὐτὸν πανταχόθεν. ");
INSERT INTO grctr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Καὶ πάλιν εἰσῆλθεν εἰς Καπερναοὺμ δι᾿ ἡμερῶν· καὶ ἠκούσθη ὅτι εἰς οἶκόν ἐστι. ");
INSERT INTO grctr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Καὶ εὐθέως συνήχθησαν πολλοί, ὥστε μηκέτι χωρεῖν μηδὲ τὰ πρὸς τὴν θύραν· καὶ ἐλάλει αὐτοῖς τὸν λόγον. ");
INSERT INTO grctr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Καὶ ἔρχονται πρὸς αὐτόν, παραλυτικὸν φέροντες, αἰρόμενον ὑπὸ τεσσάρων. ");
INSERT INTO grctr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Καὶ μὴ δυνάμενοι προσεγγίσαι αὐτῷ διὰ τὸν ὄχλον, ἀπεστέγασαν τὴν στέγην ὅπου ἦν, καὶ ἐξορύξαντες χαλῶσι τὸν κράββατον ἐφ᾿ ᾧ ὁ παραλυτικὸς κατέκειτο. ");
INSERT INTO grctr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ἰδὼν δὲ ὁ Ἰησοῦς τὴν πίστιν αὐτῶν λέγει τῷ παραλυτικῷ, Τέκνον, ἀφέωνταί σοι αἱ ἁμαρτίαι σου. ");
INSERT INTO grctr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ἦσαν δέ τινες τῶν γραμματέων ἐκεῖ καθήμενοι, καὶ διαλογιζόμενοι ἐν ταῖς καρδίαις αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Τί οὗτος οὕτω λαλεῖ βλασφημίας; Τίς δύναται ἀφιέναι ἁμαρτίας εἰ μὴ εἷς, ὁ Θεός; ");
INSERT INTO grctr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Καὶ εὐθέως ἐπιγνοὺς ὁ Ἰησοῦς τῷ πνεύματι αὐτοῦ ὅτι οὕτω διαλογίζονται ἐν ἑαυτοῖς, εἶπεν αὐτοῖς, Τί ταῦτα διαλογίζεσθε ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Τί ἐστιν εὐκοπώτερον, εἰπεῖν τῷ παραλυτικῷ, Ἀφέωνταί σοι αἱ ἁμαρτίαι, ἢ εἰπεῖν, Ἔγειραι, καὶ ἆρόν σου τὸν κράββατον, καὶ περιπάτει; ");
INSERT INTO grctr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ἵνα δὲ εἰδῆτε ὅτι ἐξουσίαν ἔχει ὁ υἱὸς τοῦ ἀνθρώπου ἀφιέναι ἐπὶ τῆς γῆς ἁμαρτίας — λέγει τῷ παραλυτικῷ — ");
INSERT INTO grctr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Σοὶ λέγω, ἔγειραι καὶ ἆρον τὸν κράββατόν σου, καὶ ὕπαγε εἰς τὸν οἶκόν σου. ");
INSERT INTO grctr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Καὶ ἠγέρθη εὐθέως, καὶ ἄρας τὸν κράββατον, ἐξῆλθεν ἐναντίον πάντων· ὥστε ἐξίστασθαι πάντας, καὶ δοξάζειν τὸν Θεόν, λέγοντας ὅτι Οὐδέποτε οὕτως εἴδομεν. ");
INSERT INTO grctr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Καὶ ἐξῆλθε πάλιν παρὰ τὴν θάλασσαν· καὶ πᾶς ὁ ὄχλος ἤρχετο πρὸς αὐτόν, καὶ ἐδίδασκεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Καὶ παράγων εἶδε Λευῒν τὸν τοῦ Ἀλφαίου καθήμενον ἐπὶ τὸ τελώνιον, καὶ λέγει αὐτῷ, Ἀκολούθει μοι. Καὶ ἀναστὰς ἠκολούθησεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Καὶ ἐγένετο ἐν τῷ κατακεῖσθαι αὐτὸν ἐν τῇ οἰκίᾳ αὐτοῦ, καὶ πολλοὶ τελῶναι καὶ ἁμαρτωλοὶ συνανέκειντο τῷ Ἰησοῦ καὶ τοῖς μαθηταῖς αὐτοῦ· ἦσαν γὰρ πολλοί, καὶ ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Καὶ οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι, ἰδόντες αὐτὸν ἐσθίοντα μετὰ τῶν τελωνῶν καὶ ἁμαρτωλῶν, ἔλεγον τοῖς μαθηταῖς αὐτοῦ, Τί ὅτι μετὰ τῶν τελωνῶν καὶ ἁμαρτωλῶν ἐσθίει καὶ πίνει; ");
INSERT INTO grctr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Καὶ ἀκούσας ὁ Ἰησοῦς λέγει αὐτοῖς, Οὐ χρείαν ἔχουσιν οἱ ἰσχύοντες ἰατροῦ, ἀλλ᾿ οἱ κακῶς ἔχοντες. Οὐκ ἦλθον καλέσαι δικαίους, ἀλλὰ ἁμαρτωλοὺς εἰς μετάνοιαν. ");
INSERT INTO grctr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Καὶ ἦσαν οἱ μαθηταὶ Ἰωάννου καὶ οἱ τῶν Φαρισαίων νηστεύοντες· καὶ ἔρχονται καὶ λέγουσιν αὐτῷ, Διὰ τί οἱ μαθηταὶ Ἰωάννου καὶ οἱ τῶν Φαρισαίων νηστεύουσιν, οἱ δὲ σοὶ μαθηταὶ οὐ νηστεύουσι; ");
INSERT INTO grctr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς, Μὴ δύνανται οἱ υἱοὶ τοῦ νυμφῶνος, ἐν ᾧ ὁ νυμφίος μετ᾿ αὐτῶν ἐστι, νηστεύειν; Ὅσον χρόνον μεθ᾿ ἑαυτῶν ἔχουσι τὸν νυμφίον, οὐ δύνανται νηστεύειν· ");
INSERT INTO grctr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ἐλεύσονται δὲ ἡμέραι ὅταν ἀπαρθῇ ἀπ᾿ αὐτῶν ὁ νυμφίος, καὶ τότε νηστεύσουσιν ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grctr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Καὶ οὐδεὶς ἐπίβλημα ῥάκους ἀγνάφου ἐπιρράπτει ἐπὶ ἱματίῳ παλαιῷ· εἰ δὲ μή, αἴρει τὸ πλήρωμα αὐτοῦ τὸ καινὸν τοῦ παλαιοῦ, καὶ χεῖρον σχίσμα γίνεται. ");
INSERT INTO grctr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Καὶ οὐδεὶς βάλλει οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μή, ῥήσσει ὁ οἶνος ὁ νέος τοὺς ἀσκούς, καὶ ὁ οἶνος ἐκχεῖται καὶ οἱ ἀσκοὶ ἀπολοῦνται· ἀλλὰ οἶνον νέον εἰς ἀσκοὺς καινοὺς βλητέον. ");
INSERT INTO grctr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Καὶ ἐγένετο παραπορεύεσθαι αὐτὸν ἐν τοῖς σάββασι διὰ τῶν σπορίμων, καὶ ἤρξαντο οἱ μαθηταὶ αὐτοῦ ὁδὸν ποιεῖν τίλλοντες τοὺς στάχυας. ");
INSERT INTO grctr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Καὶ οἱ Φαρισαῖοι ἔλεγον αὐτῷ, Ἴδε, τί ποιοῦσιν ἐν τοῖς σάββασιν ὃ οὐκ ἔξεστι; ");
INSERT INTO grctr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Καὶ αὐτὸς ἔλεγεν αὐτοῖς, Οὐδέποτε ἀνέγνωτε τί ἐποίησε Δαβίδ, ὅτε χρείαν ἔσχε καὶ ἐπείνασεν αὐτὸς καὶ οἱ μετ᾿ αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Πῶς εἰσῆλθεν εἰς τὸν οἶκον τοῦ Θεοῦ ἐπὶ Ἀβιάθαρ τοῦ ἀρχιερέως, καὶ τοὺς ἄρτους τῆς προθέσεως ἔφαγεν, οὓς οὐκ ἔξεστι φαγεῖν εἰ μὴ τοῖς ἱερεῦσι, καὶ ἔδωκε καὶ τοῖς σὺν αὐτῷ οὖσι; ");
INSERT INTO grctr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Καὶ ἔλεγεν αὐτοῖς, Τὸ σάββατον διὰ τὸν ἄνθρωπον ἐγένετο, οὐχ ὁ ἄνθρωπος διὰ τὸ σάββατον· ");
INSERT INTO grctr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ὥστε Κύριός ἐστιν ὁ υἱὸς τοῦ ἀνθρώπου καὶ τοῦ σαββάτου. ");
INSERT INTO grctr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Καὶ εἰσῆλθε πάλιν εἰς τὴν συναγωγήν, καὶ ἦν ἐκεῖ ἄνθρωπος ἐξηραμμένην ἔχων τὴν χεῖρα. ");
INSERT INTO grctr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Καὶ παρετήρουν αὐτὸν εἰ τοῖς σάββασι θεραπεύσει αὐτόν, ἵνα κατηγορήσωσιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Καὶ λέγει τῷ ἀνθρώπῳ τῷ ἐξηραμμένην ἔχοντι τὴν χεῖρα, Ἔγειραι εἰς τὸ μέσον. ");
INSERT INTO grctr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Καὶ λέγει αὐτοῖς, Ἔξεστι τοῖς σάββασιν ἀγαθοποιῆσαι ἢ κακοποιῆσαι; Ψυχὴν σῶσαι ἢ ἀποκτεῖναι; Οἱ δὲ ἐσιώπων. ");
INSERT INTO grctr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Καὶ περιβλεψάμενος αὐτοὺς μετ᾿ ὀργῆς, συλλυπούμενος ἐπὶ τῇ πωρώσει τῆς καρδίας αὐτῶν, λέγει τῷ ἀνθρώπῳ, Ἔκτεινον τὴν χεῖρά σου. Καὶ ἐξέτεινε, καὶ ἀποκατεστάθη ἡ χεὶρ αὐτοῦ ὑγιὴς ὡς ἡ ἄλλη. ");
INSERT INTO grctr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Καὶ ἐξελθόντες οἱ Φαρισαῖοι εὐθέως μετὰ τῶν Ἡρῳδιανῶν συμβούλιον ἐποίουν κατ᾿ αὐτοῦ, ὅπως αὐτὸν ἀπολέσωσι. ");
INSERT INTO grctr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Καὶ ὁ Ἰησοῦς ἀνεχώρησε μετὰ τῶν μαθητῶν αὐτοῦ πρὸς τὴν θάλασσαν· καὶ πολὺ πλῆθος ἀπὸ τῆς Γαλιλαίας ἠκολούθησαν αὐτῷ, καὶ ἀπὸ τῆς Ἰουδαίας, ");
INSERT INTO grctr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","καὶ ἀπὸ Ἱεροσολύμων, καὶ ἀπὸ τῆς Ἰδουμαίας, καὶ πέραν τοῦ Ἰορδάνου, καὶ οἱ περὶ Τύρον καὶ Σιδῶνα, πλῆθος πολύ, ἀκούσαντες ὅσα ἐποίει, ἦλθον πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Καὶ εἶπε τοῖς μαθηταῖς αὐτοῦ ἵνα πλοιάριον προσκαρτερῇ αὐτῷ διὰ τὸν ὄχλον, ἵνα μὴ θλίβωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Πολλοὺς γὰρ ἐθεράπευσεν, ὥστε ἐπιπίπτειν αὐτῷ, ἵνα αὐτοῦ ἅψωνται, ὅσοι εἶχον μάστιγας. ");
INSERT INTO grctr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Καὶ τὰ πνεύματα τὰ ἀκάθαρτα, ὅταν αὐτὸν ἐθεώρει, προσέπιπτεν αὐτῷ, καὶ ἔκραζε, λέγοντα ὅτι Σὺ εἶ ὁ υἱὸς τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Καὶ πολλὰ ἐπετίμα αὐτοῖς ἵνα μὴ αὐτὸν φανερὸν ποιήσωσι. ");
INSERT INTO grctr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Καὶ ἀναβαίνει εἰς τὸ ὄρος, καὶ προσκαλεῖται οὓς ἤθελεν αὐτός· καὶ ἀπῆλθον πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Καὶ ἐποίησε δώδεκα, ἵνα ὦσι μετ᾿ αὐτοῦ, καὶ ἵνα ἀποστέλλῃ αὐτοὺς κηρύσσειν, ");
INSERT INTO grctr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","καὶ ἔχειν ἐξουσίαν θεραπεύειν τὰς νόσους, καὶ ἐκβάλλειν τὰ δαιμόνια· ");
INSERT INTO grctr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","καὶ ἐπέθηκε τῷ Σίμωνι ὄνομα Πέτρον· ");
INSERT INTO grctr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","καὶ Ἰάκωβον τὸν τοῦ Ζεβεδαίου, καὶ Ἰωάννην τὸν ἀδελφὸν τοῦ Ἰακώβου· καὶ ἐπέθηκεν αὐτοῖς ὀνόματα Βοανεργές, ὅ ἐστιν, Υἱοὶ Βροντῆς· ");
INSERT INTO grctr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","καὶ Ἀνδρέαν, καὶ Φίλιππον, καὶ Βαρθολομαῖον, καὶ Ματθαῖον, καὶ Θωμᾶν, καὶ Ἰάκωβον τὸν τοῦ Ἀλφαίου, καὶ Θαδδαῖον, καὶ Σίμωνα τὸν Κανανίτην, ");
INSERT INTO grctr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","καὶ Ἰούδαν Ἰσκαριώτην, ὃς καὶ παρέδωκεν αὐτόν. Καὶ ἔρχονται εἰς οἶκον· ");
INSERT INTO grctr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","καὶ συνέρχεται πάλιν ὄχλος, ὥστε μὴ δύνασθαι αὐτοὺς μήτε ἄρτον φαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Καὶ ἀκούσαντες οἱ παρ᾿ αὐτοῦ ἐξῆλθον κρατῆσαι αὐτόν· ἔλεγον γὰρ ὅτι Ἐξέστη. ");
INSERT INTO grctr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Καὶ οἱ γραμματεῖς οἱ ἀπὸ Ἱεροσολύμων καταβάντες ἔλεγον ὅτι Βεελζεβοὺλ ἔχει, καὶ ὅτι Ἐν τῷ ἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια. ");
INSERT INTO grctr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Καὶ προσκαλεσάμενος αὐτούς, ἐν παραβολαῖς ἔλεγεν αὐτοῖς, Πῶς δύναται Σατανᾶς Σατανᾶν ἐκβάλλειν; ");
INSERT INTO grctr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Καὶ ἐὰν βασιλεία ἐφ᾿ ἑαυτὴν μερισθῇ, οὐ δύναται σταθῆναι ἡ βασιλεία ἐκείνη. ");
INSERT INTO grctr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Καὶ ἐὰν οἰκία ἐφ᾿ ἑαυτὴν μερισθῇ, οὐ δύναται σταθῆναι ἡ οἰκία ἐκείνη. ");
INSERT INTO grctr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Καὶ εἰ ὁ Σατανᾶς ἀνέστη ἐφ᾿ ἑαυτὸν καὶ μεμέρισται, οὐ δύναται σταθῆναι, ἀλλὰ τέλος ἔχει. ");
INSERT INTO grctr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Οὐ δύναται οὐδεὶς τὰ σκεύη τοῦ ἰσχυροῦ, εἰσελθὼν εἰς τὴν οἰκίαν αὐτοῦ, διαρπάσαι, ἐὰν μὴ πρῶτον τὸν ἰσχυρὸν δήσῃ, καὶ τότε τὴν οἰκίαν αὐτοῦ διαρπάσει. ");
INSERT INTO grctr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ἀμὴν λέγω ὑμῖν ὅτι πάντα ἀφεθήσεται τὰ ἁμαρτήματα τοῖς υἱοῖς τῶν ἀνθρώπων, καὶ βλασφημίαι ὅσας ἂν βλασφημήσωσιν· ");
INSERT INTO grctr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ὃς δ᾿ ἂν βλασφημήσῃ εἰς τὸ πνεῦμα τὸ ἅγιον, οὐκ ἔχει ἄφεσιν εἰς τὸν αἰῶνα, ἀλλ᾿ ἔνοχός ἐστιν αἰωνίου κρίσεως. ");
INSERT INTO grctr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ὅτι ἔλεγον, Πνεῦμα ἀκάθαρτον ἔχει. ");
INSERT INTO grctr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ἔρχονται οὖν οἱ ἀδελφοὶ καὶ ἡ μήτηρ αὐτοῦ, καὶ ἔξω ἑστῶτες ἀπέστειλαν πρὸς αὐτόν, φωνοῦντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Καὶ ἐκάθητο ὄχλος περὶ αὐτόν· εἶπον δὲ αὐτῷ, Ἰδού, ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου ἔξω ζητοῦσί σε. ");
INSERT INTO grctr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Καὶ ἀπεκρίθη αὐτοῖς λέγων, Τίς ἐστιν ἡ μήτηρ μου ἢ οἱ ἀδελφοί μου; ");
INSERT INTO grctr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Καὶ περιβλεψάμενος κύκλῳ τοὺς περὶ αὐτὸν καθημένους, λέγει, Ἴδε, ἡ μήτηρ μου καὶ οἱ ἀδελφοί μου. ");
INSERT INTO grctr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ὃς γὰρ ἂν ποιήσῃ τὸ θέλημα τοῦ Θεοῦ, οὗτος ἀδελφός μου καὶ ἀδελφή μου καὶ μήτηρ ἐστί. ");
INSERT INTO grctr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Καὶ πάλιν ἤρξατο διδάσκειν παρὰ τὴν θάλασσαν. Καὶ συνήχθη πρὸς αὐτὸν ὄχλος πολύς, ὥστε αὐτὸν ἐμβάντα εἰς τὸ πλοῖον καθῆσθαι ἐν τῇ θαλάσσῃ· καὶ πᾶς ὁ ὄχλος πρὸς τὴν θάλασσαν ἐπὶ τῆς γῆς ἦν. ");
INSERT INTO grctr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Καὶ ἐδίδασκεν αὐτοὺς ἐν παραβολαῖς πολλά, καὶ ἔλεγεν αὐτοῖς ἐν τῇ διδαχῇ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ἀκούετε· ἰδού, ἐξῆλθεν ὁ σπείρων τοῦ σπεῖραι. ");
INSERT INTO grctr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Καὶ ἐγένετο ἐν τῷ σπείρειν, ὃ μὲν ἔπεσε παρὰ τὴν ὁδόν, καὶ ἦλθε τὰ πετεινὰ τοῦ οὐρανοῦ καὶ κατέφαγεν αὐτό. ");
INSERT INTO grctr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ἄλλο δὲ ἔπεσεν ἐπὶ τὸ πετρῶδες, ὅπου οὐκ εἶχε γῆν πολλήν· καὶ εὐθέως ἐξανέτειλε, διὰ τὸ μὴ ἔχειν βάθος γῆς· ");
INSERT INTO grctr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ἡλίου δὲ ἀνατείλαντος ἐκαυματίσθη, καὶ διὰ τὸ μὴ ἔχειν ῥίζαν ἐξηράνθη. ");
INSERT INTO grctr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Καὶ ἄλλο ἔπεσεν εἰς τὰς ἀκάνθας, καὶ ἀνέβησαν αἱ ἄκανθαι, καὶ συνέπνιξαν αὐτό, καὶ καρπὸν οὐκ ἔδωκε. ");
INSERT INTO grctr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Καὶ ἄλλο ἔπεσεν εἰς τὴν γῆν τὴν καλήν· καὶ ἐδίδου καρπὸν ἀναβαίνοντα καὶ αὐξάνοντα, καὶ ἔφερεν ἐν τριάκοντα, καὶ ἐν ἑξήκοντα, καὶ ἐν ἑκατόν. ");
INSERT INTO grctr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Καὶ ἔλεγεν αὐτοῖς, Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ὅτε δὲ ἐγένετο καταμόνας, ἠρώτησαν αὐτὸν οἱ περὶ αὐτὸν σὺν τοῖς δώδεκα τὴν παραβολήν. ");
INSERT INTO grctr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Καὶ ἔλεγεν αὐτοῖς, Ὑμῖν δέδοται γνῶναι τὸ μυστήριον τῆς βασιλείας τοῦ Θεοῦ· ἐκείνοις δὲ τοῖς ἔξω, ἐν παραβολαῖς τὰ πάντα γίνεται· ");
INSERT INTO grctr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ἵνα βλέποντες βλέπωσι, καὶ μὴ ἴδωσι· καὶ ἀκούοντες ἀκούωσι, καὶ μὴ συνιῶσι· μήποτε ἐπιστρέψωσι, καὶ ἀφεθῇ αὐτοῖς τὰ ἁμαρτήματα. ");
INSERT INTO grctr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Καὶ λέγει αὐτοῖς, Οὐκ οἴδατε τὴν παραβολὴν ταύτην; Καὶ πῶς πάσας τὰς παραβολὰς γνώσεσθε; ");
INSERT INTO grctr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ὁ σπείρων τὸν λόγον σπείρει. ");
INSERT INTO grctr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Οὗτοι δέ εἰσιν οἱ παρὰ τὴν ὁδόν, ὅπου σπείρεται ὁ λόγος, καὶ ὅταν ἀκούσωσιν, εὐθέως ἔρχεται ὁ Σατανᾶς καὶ αἴρει τὸν λόγον τὸν ἐσπαρμένον ἐν ταῖς καρδίαις αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Καὶ οὗτοί εἰσιν ὁμοίως οἱ ἐπὶ τὰ πετρώδη σπειρόμενοι, οἵ, ὅταν ἀκούσωσι τὸν λόγον, εὐθέως μετὰ χαρᾶς λαμβάνουσιν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","καὶ οὐκ ἔχουσι ῥίζαν ἐν ἑαυτοῖς, ἀλλὰ πρόσκαιροί εἰσιν· εἶτα γενομένης θλίψεως ἢ διωγμοῦ διὰ τὸν λόγον, εὐθέως σκανδαλίζονται. ");
INSERT INTO grctr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Καὶ οὗτοί εἰσιν οἱ εἰς τὰς ἀκάνθας σπειρόμενοι, οὗτοί εἰσιν οἱ τὸν λόγον ἀκούοντες, ");
INSERT INTO grctr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","καὶ αἱ μέριμναι τοῦ αἰῶνος τούτου, καὶ ἡ ἀπάτη τοῦ πλούτου, καὶ αἱ περὶ τὰ λοιπὰ ἐπιθυμίαι εἰσπορευόμεναι συμπνίγουσι τὸν λόγον, καὶ ἄκαρπος γίνεται. ");
INSERT INTO grctr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Καὶ οὗτοί εἰσιν οἱ ἐπὶ τὴν γῆν τὴν καλὴν σπαρέντες, οἵτινες ἀκούουσι τὸν λόγον, καὶ παραδέχονται, καὶ καρποφοροῦσιν, ἐν τριάκοντα, καὶ ἐν ἑξήκοντα, καὶ ἐν ἑκατόν. ");
INSERT INTO grctr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Καὶ ἔλεγεν αὐτοῖς, Μήτι ὁ λύχνος ἔρχεται ἵνα ὑπὸ τὸν μόδιον τεθῇ ἢ ὑπὸ τὴν κλίνην; Οὐχ ἵνα ἐπὶ τὴν λυχνίαν ἐπιτεθῇ; ");
INSERT INTO grctr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Οὐ γάρ ἐστί τι κρυπτόν, ὃ ἐὰν μὴ φανερωθῇ· οὐδὲ ἐγένετο ἀπόκρυφον, ἀλλ᾿ ἵνα εἰς φανερὸν ἔλθῃ. ");
INSERT INTO grctr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Εἴ τις ἔχει ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Καὶ ἔλεγεν αὐτοῖς, Βλέπετε τί ἀκούετε. Ἐν ᾧ μέτρῳ μετρεῖτε μετρηθήσεται ὑμῖν, καὶ προστεθήσεται ὑμῖν τοῖς ἀκούουσιν. ");
INSERT INTO grctr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ὃς γὰρ ἂν ἔχῃ, δοθήσεται αὐτῷ· καὶ ὃς οὐκ ἔχει, καὶ ὃ ἔχει ἀρθήσεται ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Καὶ ἔλεγεν, Οὕτως ἐστὶν ἡ βασιλεία τοῦ Θεοῦ, ὡς ἐὰν ἄνθρωπος βάλῃ τὸν σπόρον ἐπὶ τῆς γῆς, ");
INSERT INTO grctr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","καὶ καθεύδῃ καὶ ἐγείρηται νύκτα καὶ ἡμέραν, καὶ ὁ σπόρος βλαστάνῃ καὶ μηκύνηται ὡς οὐκ οἶδεν αὐτός. ");
INSERT INTO grctr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Αὐτομάτη γὰρ ἡ γῆ καρποφορεῖ, πρῶτον χόρτον, εἶτα στάχυν, εἶτα πλήρη σῖτον ἐν τῷ στάχυϊ. ");
INSERT INTO grctr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ὅταν δὲ παραδῷ ὁ καρπός, εὐθέως ἀποστέλλει τὸ δρέπανον, ὅτι παρέστηκεν ὁ θερισμός. ");
INSERT INTO grctr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Καὶ ἔλεγε, Τίνι ὁμοιώσωμεν τὴν βασιλείαν τοῦ Θεοῦ; Ἢ ἐν ποίᾳ παραβολῇ παραβάλωμεν αὐτήν; ");
INSERT INTO grctr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ὡς κόκκῳ σινάπεως, ὅς, ὅταν σπαρῇ ἐπὶ τῆς γῆς, μικρότερος πάντων τῶν σπερμάτων ἐστὶ τῶν ἐπὶ τῆς γῆς· ");
INSERT INTO grctr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","καὶ ὅταν σπαρῇ, ἀναβαίνει, καὶ γίνεται πάντων τῶν λαχάνων μείζων, καὶ ποιεῖ κλάδους μεγάλους, ὥστε δύνασθαι ὑπὸ τὴν σκιὰν αὐτοῦ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνοῦν. ");
INSERT INTO grctr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Καὶ τοιαύταις παραβολαῖς πολλαῖς ἐλάλει αὐτοῖς τὸν λόγον, καθὼς ἠδύναντο ἀκούειν· ");
INSERT INTO grctr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","χωρὶς δὲ παραβολῆς οὐκ ἐλάλει αὐτοῖς· κατ᾿ ἰδίαν δὲ τοῖς μαθηταῖς αὐτοῦ ἐπέλυε πάντα. ");
INSERT INTO grctr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Καὶ λέγει αὐτοῖς ἐν ἐκείνῃ τῇ ἡμέρᾳ, ὀψίας γενομένης, Διέλθωμεν εἰς τὸ πέραν. ");
INSERT INTO grctr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Καὶ ἀφέντες τὸν ὄχλον, παραλαμβάνουσιν αὐτὸν ὡς ἦν ἐν τῷ πλοίῳ. Καὶ ἄλλα δὲ πλοιάρια ἦν μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Καὶ γίνεται λαῖλαψ ἀνέμου μεγάλη· τὰ δὲ κύματα ἐπέβαλλεν εἰς τὸ πλοῖον, ὥστε αὐτὸ ἤδη γεμίζεσθαι. ");
INSERT INTO grctr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Καὶ ἦν αὐτὸς ἐπὶ τῇ πρύμνῃ ἐπὶ τὸ προσκεφάλαιον καθεύδων· καὶ διεγείρουσιν αὐτόν, καὶ λέγουσιν αὐτῷ, Διδάσκαλε, οὐ μέλει σοι ὅτι ἀπολλύμεθα; ");
INSERT INTO grctr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Καὶ διεγερθεὶς ἐπετίμησε τῷ ἀνέμῳ, καὶ εἶπε τῇ θαλάσσῃ, Σιώπα, πεφίμωσο. Καὶ ἐκόπασεν ὁ ἄνεμος, καὶ ἐγένετο γαλήνη μεγάλη. ");
INSERT INTO grctr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Καὶ εἶπεν αὐτοῖς, Τί δειλοί ἐστε οὕτω; Πῶς οὐκ ἔχετε πίστιν; ");
INSERT INTO grctr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Καὶ ἐφοβήθησαν φόβον μέγαν, καὶ ἔλεγον πρὸς ἀλλήλους, Τίς ἄρα οὗτός ἐστιν, ὅτι καὶ ὁ ἄνεμος καὶ ἡ θάλασσα ὑπακούουσιν αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Καὶ ἦλθον εἰς τὸ πέραν τῆς θαλάσσης, εἰς τὴν χώραν τῶν Γαδαρηνῶν. ");
INSERT INTO grctr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Καὶ ἐξελθόντι αὐτῷ ἐκ τοῦ πλοίου, εὐθέως ἀπήντησεν αὐτῷ ἐκ τῶν μνημείων ἄνθρωπος ἐν πνεύματι ἀκαθάρτῳ, ");
INSERT INTO grctr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ὃς τὴν κατοίκησιν εἶχεν ἐν τοῖς μνημείοις· καὶ οὔτε ἁλύσεσιν οὐδεὶς ἠδύνατο αὐτὸν δῆσαι, ");
INSERT INTO grctr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","διὰ τὸ αὐτὸν πολλάκις πέδαις καὶ ἁλύσεσι δεδέσθαι, καὶ διεσπᾶσθαι ὑπ᾿ αὐτοῦ τὰς ἁλύσεις, καὶ τὰς πέδας συντετρίφθαι· καὶ οὐδεὶς αὐτὸν ἴσχυε δαμάσαι· ");
INSERT INTO grctr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","καὶ διὰ παντός, νυκτὸς καὶ ἡμέρας, ἐν τοῖς ὄρεσι καὶ ἐν τοῖς μνήμασιν ἦν κράζων καὶ κατακόπτων ἑαυτὸν λίθοις. ");
INSERT INTO grctr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ἰδὼν δὲ τὸν Ἰησοῦν ἀπὸ μακρόθεν, ἔδραμε καὶ προσεκύνησεν αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","καὶ κράξας φωνῇ μεγάλῃ εἶπε, Τί ἐμοὶ καὶ σοί, Ἰησοῦ, υἱὲ τοῦ Θεοῦ τοῦ ὑψίστου; Ὁρκίζω σε τὸν Θεόν, μή με βασανίσῃς. ");
INSERT INTO grctr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ἔλεγε γὰρ αὐτῷ, Ἔξελθε, τὸ πνεῦμα τὸ ἀκάθαρτον, ἐκ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Καὶ ἐπηρώτα αὐτόν, Τί σοι ὄνομα; Καὶ ἀπεκρίθη, λέγων, Λεγεὼν ὄνομά μοι, ὅτι πολλοί ἐσμεν. ");
INSERT INTO grctr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Καὶ παρεκάλει αὐτὸν πολλὰ ἵνα μὴ αὐτοὺς ἀποστείλῃ ἔξω τῆς χώρας. ");
INSERT INTO grctr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ἦν δὲ ἐκεῖ πρὸς τὰ ὄρη ἀγέλη χοίρων μεγάλη βοσκομένη· ");
INSERT INTO grctr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","καὶ παρεκάλεσαν αὐτὸν πάντες οἱ δαίμονες, λέγοντες, Πέμψον ἡμᾶς εἰς τοὺς χοίρους, ἵνα εἰς αὐτοὺς εἰσέλθωμεν. ");
INSERT INTO grctr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Καὶ ἐπέτρεψεν αὐτοῖς εὐθέως ὁ Ἰησοῦς. Καὶ ἐξελθόντα τὰ πνεύματα τὰ ἀκάθαρτα εἰσῆλθον εἰς τοὺς χοίρους· καὶ ὥρμησεν ἡ ἀγέλη κατὰ τοῦ κρημνοῦ εἰς τὴν θάλασσαν· ἦσαν δὲ ὡς δισχίλιοι· καὶ ἐπνίγοντο ἐν τῇ θαλάσσῃ. ");
INSERT INTO grctr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Οἱ δὲ βόσκοντες τοὺς χοίρους ἔφυγον, καὶ ἀνήγγειλαν εἰς τὴν πόλιν καὶ εἰς τοὺς ἀγρούς. Καὶ ἐξῆλθον ἰδεῖν τί ἐστι τὸ γεγονός· ");
INSERT INTO grctr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","καὶ ἔρχονται πρὸς τὸν Ἰησοῦν, καὶ θεωροῦσι τὸν δαιμονιζόμενον καθήμενον καὶ ἱματισμένον καὶ σωφρονοῦντα, τὸν ἐσχηκότα τὸν Λεγεῶνα· καὶ ἐφοβήθησαν. ");
INSERT INTO grctr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Καὶ διηγήσαντο αὐτοῖς οἱ ἰδόντες πῶς ἐγένετο τῷ δαιμονιζομένῳ, καὶ περὶ τῶν χοίρων. ");
INSERT INTO grctr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Καὶ ἤρξαντο παρακαλεῖν αὐτὸν ἀπελθεῖν ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Καὶ ἐμβάντος αὐτοῦ εἰς τὸ πλοῖον, παρεκάλει αὐτὸν ὁ δαιμονισθείς, ἵνα ᾖ μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ὁ δὲ Ἰησοῦς οὐκ ἀφῆκεν αὐτόν, ἀλλὰ λέγει αὐτῷ, Ὕπαγε εἰς τὸν οἶκόν σου πρὸς τοὺς σούς, καὶ ἀνάγγειλον αὐτοῖς ὅσα σοι ὁ Κύριος ἐποίησε, καὶ ἠλέησέ σε. ");
INSERT INTO grctr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Καὶ ἀπῆλθε καὶ ἤρξατο κηρύσσειν ἐν τῇ Δεκαπόλει ὅσα ἐποίησεν αὐτῷ ὁ Ἰησοῦς· καὶ πάντες ἐθαύμαζον. ");
INSERT INTO grctr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Καὶ διαπεράσαντος τοῦ Ἰησοῦ ἐν τῷ πλοίῳ πάλιν εἰς τὸ πέραν, συνήχθη ὄχλος πολὺς ἐπ᾿ αὐτόν, καὶ ἦν παρὰ τὴν θάλασσαν. ");
INSERT INTO grctr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Καὶ ἰδού, ἔρχεται εἷς τῶν ἀρχισυναγώγων, ὀνόματι Ἰάειρος, καὶ ἰδὼν αὐτόν, πίπτει πρὸς τοὺς πόδας αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","καὶ παρεκάλει αὐτὸν πολλά, λέγων ὅτι Τὸ θυγάτριόν μου ἐσχάτως ἔχει· ἵνα ἐλθὼν ἐπιθῇς αὐτῇ τὰς χεῖρας, ὅπως σωθῇ καὶ ζήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Καὶ ἀπῆλθε μετ᾿ αὐτοῦ· καὶ ἠκολούθει αὐτῷ ὄχλος πολύς, καὶ συνέθλιβον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Καὶ γυνή τις οὖσα ἐν ῥύσει αἵματος ἔτη δώδεκα, ");
INSERT INTO grctr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","καὶ πολλὰ παθοῦσα ὑπὸ πολλῶν ἰατρῶν, καὶ δαπανήσασα τὰ παρ᾿ ἑαυτῆς πάντα, καὶ μηδὲν ὠφεληθεῖσα, ἀλλὰ μᾶλλον εἰς τὸ χεῖρον ἐλθοῦσα, ");
INSERT INTO grctr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ἀκούσασα περὶ τοῦ Ἰησοῦ, ἐλθοῦσα ἐν τῷ ὄχλῳ ὄπισθεν, ἥψατο τοῦ ἱματίου αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ἔλεγε γὰρ ὅτι Κἂν τῶν ἱματίων αὐτοῦ ἅψωμαι, σωθήσομαι. ");
INSERT INTO grctr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Καὶ εὐθέως ἐξηράνθη ἡ πηγὴ τοῦ αἵματος αὐτῆς, καὶ ἔγνω τῷ σώματι ὅτι ἴαται ἀπὸ τῆς μάστιγος. ");
INSERT INTO grctr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Καὶ εὐθέως ὁ Ἰησοῦς ἐπιγνοὺς ἐν ἑαυτῷ τὴν ἐξ αὐτοῦ δύναμιν ἐξελθοῦσαν, ἐπιστραφεὶς ἐν τῷ ὄχλῳ, ἔλεγε, Τίς μου ἥψατο τῶν ἱματίων; ");
INSERT INTO grctr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Καὶ ἔλεγον αὐτῷ οἱ μαθηταὶ αὐτοῦ, Βλέπεις τὸν ὄχλον συνθλίβοντά σε, καὶ λέγεις, Τίς μου ἥψατο; ");
INSERT INTO grctr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Καὶ περιεβλέπετο ἰδεῖν τὴν τοῦτο ποιήσασαν. ");
INSERT INTO grctr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ἡ δὲ γυνὴ φοβηθεῖσα καὶ τρέμουσα, εἰδυῖα ὃ γέγονεν ἐπ᾿ αὐτῇ, ἦλθε καὶ προσέπεσεν αὐτῷ, καὶ εἶπεν αὐτῷ πᾶσαν τὴν ἀλήθειαν. ");
INSERT INTO grctr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ὁ δὲ εἶπεν αὐτῇ, Θύγατερ, ἡ πίστις σου σέσωκέ σε· ὕπαγε εἰς εἰρήνην, καὶ ἴσθι ὑγιὴς ἀπὸ τῆς μάστιγός σου. ");
INSERT INTO grctr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ἔτι αὐτοῦ λαλοῦντος, ἔρχονται ἀπὸ τοῦ ἀρχισυναγώγου, λέγοντες ὅτι Ἡ θυγάτηρ σου ἀπέθανε· τί ἔτι σκύλλεις τὸν διδάσκαλον; ");
INSERT INTO grctr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ὁ δὲ Ἰησοῦς εὐθέως ἀκούσας τὸν λόγον λαλούμενον λέγει τῷ ἀρχισυναγώγῳ, Μὴ φοβοῦ· μόνον πίστευε. ");
INSERT INTO grctr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Καὶ οὐκ ἀφῆκεν οὐδένα αὐτῷ συνακολουθῆσαι, εἰ μὴ Πέτρον καὶ Ἰάκωβον καὶ Ἰωάννην τὸν ἀδελφὸν Ἰακώβου. ");
INSERT INTO grctr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Καὶ ἔρχεται εἰς τὸν οἶκον τοῦ ἀρχισυναγώγου, καὶ θεωρεῖ θόρυβον, κλαίοντας καὶ ἀλαλάζοντας πολλά. ");
INSERT INTO grctr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Καὶ εἰσελθὼν λέγει αὐτοῖς, Τί θορυβεῖσθε καὶ κλαίετε; Τὸ παιδίον οὐκ ἀπέθανεν, ἀλλὰ καθεύδει. ");
INSERT INTO grctr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Καὶ κατεγέλων αὐτοῦ. Ὁ δέ, ἐκβαλὼν ἅπαντας, παραλαμβάνει τὸν πατέρα τοῦ παιδίου καὶ τὴν μητέρα καὶ τοὺς μετ᾿ αὐτοῦ, καὶ εἰσπορεύεται ὅπου ἦν τὸ παιδίον ἀνακείμενον. ");
INSERT INTO grctr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Καὶ κρατήσας τῆς χειρὸς τοῦ παιδίου, λέγει αὐτῇ, Ταλιθά, κοῦμι· ὅ ἐστι μεθερμηνευόμενον, Τὸ κοράσιον, σοὶ λέγω, ἔγειραι. ");
INSERT INTO grctr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Καὶ εὐθέως ἀνέστη τὸ κοράσιον καὶ περιεπάτει, ἦν γὰρ ἐτῶν δώδεκα· καὶ ἐξέστησαν ἐκστάσει μεγάλῃ. ");
INSERT INTO grctr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Καὶ διεστείλατο αὐτοῖς πολλὰ ἵνα μηδεὶς γνῷ τοῦτο· καὶ εἶπε δοθῆναι αὐτῇ φαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Καὶ ἐξῆλθεν ἐκεῖθεν, καὶ ἦλθεν εἰς τὴν πατρίδα αὐτοῦ· καὶ ἀκολουθοῦσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Καὶ γενομένου σαββάτου, ἤρξατο ἐν τῇ συναγωγῇ διδάσκειν· καὶ πολλοὶ ἀκούοντες ἐξεπλήσσοντο, λέγοντες, Πόθεν τούτῳ ταῦτα; Καὶ τίς ἡ σοφία ἡ δοθεῖσα αὐτῷ, ὅτι καὶ δυνάμεις τοιαῦται διὰ τῶν χειρῶν αὐτοῦ γίνονται; ");
INSERT INTO grctr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Οὐχ οὗτός ἐστιν ὁ τέκτων, ὁ υἱὸς Μαρίας, ἀδελφὸς δὲ Ἰακώβου καὶ Ἰωσῆ καὶ Ἰούδα καὶ Σίμωνος; Καὶ οὐκ εἰσὶν αἱ ἀδελφαὶ αὐτοῦ ὧδε πρὸς ἡμᾶς; Καὶ ἐσκανδαλίζοντο ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ἔλεγε δὲ αὐτοῖς ὁ Ἰησοῦς ὅτι Οὐκ ἔστι προφήτης ἄτιμος, εἰ μὴ ἐν τῇ πατρίδι αὐτοῦ, καὶ ἐν τοῖς συγγενέσι καὶ ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Καὶ οὐκ ἠδύνατο ἐκεῖ οὐδεμίαν δύναμιν ποιῆσαι, εἰ μὴ ὀλίγοις ἀρρώστοις ἐπιθεὶς τὰς χεῖρας, ἐθεράπευσε. ");
INSERT INTO grctr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Καὶ ἐθαύμαζε διὰ τὴν ἀπιστίαν αὐτῶν. Καὶ περιῆγε τὰς κώμας κύκλῳ διδάσκων. ");
INSERT INTO grctr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Καὶ προσκαλεῖται τοὺς δώδεκα, καὶ ἤρξατο αὐτοὺς ἀποστέλλειν δύο δύο, καὶ ἐδίδου αὐτοῖς ἐξουσίαν τῶν πνευμάτων τῶν ἀκαθάρτων. ");
INSERT INTO grctr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Καὶ παρήγγειλεν αὐτοῖς ἵνα μηδὲν αἴρωσιν εἰς ὁδόν, εἰ μὴ ῥάβδον μόνον· μὴ πήραν, μὴ ἄρτον, μὴ εἰς τὴν ζώνην χαλκόν· ");
INSERT INTO grctr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ἀλλ᾿ ὑποδεδεμένους σανδάλια· καὶ μὴ ἐνδύσασθαι δύο χιτῶνας. ");
INSERT INTO grctr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Καὶ ἔλεγεν αὐτοῖς, Ὅπου ἐὰν εἰσέλθητε εἰς οἰκίαν, ἐκεῖ μένετε ἕως ἂν ἐξέλθητε ἐκεῖθεν. ");
INSERT INTO grctr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Καὶ ὅσοι ἂν μὴ δέξωνται ὑμᾶς, μηδὲ ἀκούσωσιν ὑμῶν, ἐκπορευόμενοι ἐκεῖθεν, ἐκτινάξατε τὸν χοῦν τὸν ὑποκάτω τῶν ποδῶν ὑμῶν εἰς μαρτύριον αὐτοῖς. Ἀμὴν λέγω ὑμῖν, ἀνεκτότερον ἔσται Σοδόμοις ἢ Γομόρροις ἐν ἡμέρᾳ κρίσεως, ἢ τῇ πόλει ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Καὶ ἐξελθόντες ἐκήρυσσον ἵνα μετανοήσωσι· ");
INSERT INTO grctr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","καὶ δαιμόνια πολλὰ ἐξέβαλλον, καὶ ἤλειφον ἐλαίῳ πολλοὺς ἀρρώστους καὶ ἐθεράπευον. ");
INSERT INTO grctr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Καὶ ἤκουσεν ὁ βασιλεὺς Ἡρῴδης, φανερὸν γὰρ ἐγένετο τὸ ὄνομα αὐτοῦ, καὶ ἔλεγεν ὅτι Ἰωάννης ὁ βαπτίζων ἐκ νεκρῶν ἠγέρθη, καὶ διὰ τοῦτο ἐνεργοῦσιν αἱ δυνάμεις ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ἄλλοι ἔλεγον ὅτι Ἠλίας ἐστίν· ἄλλοι δὲ ἔλεγον ὅτι Προφήτης ἐστίν, ἢ ὡς εἷς τῶν προφητῶν. ");
INSERT INTO grctr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ἀκούσας δὲ ὁ Ἡρῴδης εἶπεν ὅτι Ὃν ἐγὼ ἀπεκεφάλισα Ἰωάννην, οὗτός ἐστιν· αὐτὸς ἠγέρθη ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Αὐτὸς γὰρ ὁ Ἡρῴδης ἀποστείλας ἐκράτησε τὸν Ἰωάννην, καὶ ἔδησεν αὐτὸν ἐν τῇ φυλακῇ, διὰ Ἡρῳδιάδα τὴν γυναῖκα Φιλίππου τοῦ ἀδελφοῦ αὐτοῦ, ὅτι αὐτὴν ἐγάμησεν. ");
INSERT INTO grctr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ἔλεγε γὰρ ὁ Ἰωάννης τῷ Ἡρῴδῃ ὅτι Οὐκ ἔξεστί σοι ἔχειν τὴν γυναῖκα τοῦ ἀδελφοῦ σου. ");
INSERT INTO grctr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ἡ δὲ Ἡρῳδιὰς ἐνεῖχεν αὐτῷ, καὶ ἤθελεν αὐτὸν ἀποκτεῖναι· καὶ οὐκ ἠδύνατο· ");
INSERT INTO grctr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ὁ γὰρ Ἡρῴδης ἐφοβεῖτο τὸν Ἰωάννην, εἰδὼς αὐτὸν ἄνδρα δίκαιον καὶ ἅγιον, καὶ συνετήρει αὐτόν· καὶ ἀκούσας αὐτοῦ, πολλὰ ἐποίει, καὶ ἡδέως αὐτοῦ ἤκουε. ");
INSERT INTO grctr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Καὶ γενομένης ἡμέρας εὐκαίρου, ὅτε Ἡρῴδης τοῖς γενεσίοις αὐτοῦ δεῖπνον ἐποίει τοῖς μεγιστᾶσιν αὐτοῦ καὶ τοῖς χιλιάρχοις καὶ τοῖς πρώτοις τῆς Γαλιλαίας, ");
INSERT INTO grctr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","καὶ εἰσελθούσης τῆς θυγατρὸς αὐτῆς τῆς Ἡρῳδιάδος καὶ ὀρχησαμένης, καὶ ἀρεσάσης τῷ Ἡρῴδῃ καὶ τοῖς συνανακειμένοις, εἶπεν ὁ βασιλεὺς τῷ κορασίῳ, Αἴτησόν με ὃ ἐὰν θέλῃς, καὶ δώσω σοί· ");
INSERT INTO grctr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","καὶ ὤμοσεν αὐτῇ ὅτι Ὃ ἐάν με αἰτήσῃς, δώσω σοί, ἕως ἡμίσους τῆς βασιλείας μου. ");
INSERT INTO grctr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ἡ δὲ ἐξελθοῦσα εἶπε τῇ μητρὶ αὐτῆς, Τί αἰτήσομαι; Ἡ δὲ εἶπε, Τὴν κεφαλὴν Ἰωάννου τοῦ βαπτιστοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Καὶ εἰσελθοῦσα εὐθέως μετὰ σπουδῆς πρὸς τὸν βασιλέα, ᾐτήσατο, λέγουσα, Θέλω ἵνα μοι δῷς ἐξαυτῆς ἐπὶ πίνακι τὴν κεφαλὴν Ἰωάννου τοῦ βαπτιστοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Καὶ περίλυπος γενόμενος ὁ βασιλεύς, διὰ τοὺς ὅρκους καὶ τοὺς συνανακειμένους οὐκ ἠθέλησεν αὐτὴν ἀθετῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Καὶ εὐθέως ἀποστείλας ὁ βασιλεὺς σπεκουλάτωρα ἐπέταξεν ἐνεχθῆναι τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ὁ δὲ ἀπελθὼν ἀπεκεφάλισεν αὐτὸν ἐν τῇ φυλακῇ, καὶ ἤνεγκε τὴν κεφαλὴν αὐτοῦ ἐπὶ πίνακι, καὶ ἔδωκεν αὐτὴν τῷ κορασίῳ· καὶ τὸ κοράσιον ἔδωκεν αὐτὴν τῇ μητρὶ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Καὶ ἀκούσαντες οἱ μαθηταὶ αὐτοῦ ἦλθον, καὶ ἦραν τὸ πτῶμα αὐτοῦ, καὶ ἔθηκαν αὐτὸ ἐν μνημείῳ. ");
INSERT INTO grctr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Καὶ συνάγονται οἱ ἀπόστολοι πρὸς τὸν Ἰησοῦν, καὶ ἀπήγγειλαν αὐτῷ πάντα, καὶ ὅσα ἐποίησαν καὶ ὅσα ἐδίδαξαν. ");
INSERT INTO grctr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Καὶ εἶπεν αὐτοῖς, Δεῦτε ὑμεῖς αὐτοὶ κατ᾿ ἰδίαν εἰς ἔρημον τόπον, καὶ ἀναπαύεσθε ὀλίγον. Ἦσαν γὰρ οἱ ἐρχόμενοι καὶ οἱ ὑπάγοντες πολλοί, καὶ οὐδὲ φαγεῖν ηὐκαίρουν. ");
INSERT INTO grctr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Καὶ ἀπῆλθον εἰς ἔρημον τόπον τῷ πλοίῳ κατ᾿ ἰδίαν. ");
INSERT INTO grctr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Καὶ εἶδον αὐτοὺς ὑπάγοντας οἱ ὄχλοι, καὶ ἐπέγνωσαν αὐτὸν πολλοί, καὶ πεζῇ ἀπὸ πασῶν τῶν πόλεων συνέδραμον ἐκεῖ, καὶ προῆλθον αὐτούς, καὶ συνῆλθον πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Καὶ ἐξελθὼν εἶδεν ὁ Ἰησοῦς πολὺν ὄχλον, καὶ ἐσπλαγχνίσθη ἐπ᾿ αὐτοῖς, ὅτι ἦσαν ὡς πρόβατα μὴ ἔχοντα ποιμένα· καὶ ἤρξατο διδάσκειν αὐτοὺς πολλά. ");
INSERT INTO grctr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Καὶ ἤδη ὥρας πολλῆς γενομένης, προσελθόντες αὐτῷ οἱ μαθηταὶ αὐτοῦ λέγουσιν ὅτι Ἔρημός ἐστιν ὁ τόπος, καὶ ἤδη ὥρα πολλή· ");
INSERT INTO grctr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ἀπόλυσον αὐτούς, ἵνα ἀπελθόντες εἰς τοὺς κύκλῳ ἀγροὺς καὶ κώμας ἀγοράσωσιν ἑαυτοῖς ἄρτους. Τί γὰρ φάγωσιν οὐκ ἔχουσιν. ");
INSERT INTO grctr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Δότε αὐτοῖς ὑμεῖς φαγεῖν. Καὶ λέγουσιν αὐτῷ, Ἀπελθόντες ἀγοράσωμεν διακοσίων δηναρίων ἄρτους, καὶ δῶμεν αὐτοῖς φαγεῖν; ");
INSERT INTO grctr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ὁ δὲ λέγει αὐτοῖς, Πόσους ἄρτους ἔχετε; Ὑπάγετε καὶ ἴδετε. Καὶ γνόντες λέγουσι, Πέντε, καὶ δύο ἰχθύας. ");
INSERT INTO grctr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Καὶ ἐπέταξεν αὐτοῖς ἀνακλῖναι πάντας συμπόσια συμπόσια ἐπὶ τῷ χλωρῷ χόρτῳ. ");
INSERT INTO grctr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Καὶ ἀνέπεσον πρασιαὶ πρασιαί, ἀνὰ ἑκατὸν καὶ ἀνὰ πεντήκοντα. ");
INSERT INTO grctr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Καὶ λαβὼν τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας, ἀναβλέψας εἰς τὸν οὐρανόν, εὐλόγησε, καὶ κατέκλασε τοὺς ἄρτους, καὶ ἐδίδου τοῖς μαθηταῖς αὐτοῦ ἵνα παραθῶσιν αὐτοῖς· καὶ τοὺς δύο ἰχθύας ἐμέρισε πᾶσι. ");
INSERT INTO grctr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Καὶ ἔφαγον πάντες, καὶ ἐχορτάσθησαν· ");
INSERT INTO grctr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","καὶ ἦραν κλασμάτων δώδεκα κοφίνους πλήρεις, καὶ ἀπὸ τῶν ἰχθύων. ");
INSERT INTO grctr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Καὶ ἦσαν οἱ φαγόντες τοὺς ἄρτους ὡσεὶ πεντακισχίλιοι ἄνδρες. ");
INSERT INTO grctr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Καὶ εὐθέως ἠνάγκασε τοὺς μαθητὰς αὐτοῦ ἐμβῆναι εἰς τὸ πλοῖον, καὶ προάγειν εἰς τὸ πέραν πρὸς Βηθσαϊδάν, ἕως αὐτὸς ἀπολύσῃ τὸν ὄχλον. ");
INSERT INTO grctr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Καὶ ἀποταξάμενος αὐτοῖς, ἀπῆλθεν εἰς τὸ ὄρος προσεύξασθαι. ");
INSERT INTO grctr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Καὶ ὀψίας γενομένης, ἦν τὸ πλοῖον ἐν μέσῳ τῆς θαλάσσης, καὶ αὐτὸς μόνος ἐπὶ τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Καὶ εἶδεν αὐτοὺς βασανιζομένους ἐν τῷ ἐλαύνειν, ἦν γὰρ ὁ ἄνεμος ἐναντίος αὐτοῖς, καὶ περὶ τετάρτην φυλακὴν τῆς νυκτὸς ἔρχεται πρὸς αὐτούς, περιπατῶν ἐπὶ τῆς θαλάσσης· καὶ ἤθελε παρελθεῖν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Οἱ δέ, ἰδόντες αὐτὸν περιπατοῦντα ἐπὶ τῆς θαλάσσης, ἔδοξαν φάντασμα εἶναι, καὶ ἀνέκραξαν· ");
INSERT INTO grctr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","πάντες γὰρ αὐτὸν εἶδον, καὶ ἐταράχθησαν. Καὶ εὐθέως ἐλάλησε μετ᾿ αὐτῶν, καὶ λέγει αὐτοῖς, Θαρσεῖτε· ἐγώ εἰμι, μὴ φοβεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Καὶ ἀνέβη πρὸς αὐτοὺς εἰς τὸ πλοῖον, καὶ ἐκόπασεν ὁ ἄνεμος· καὶ λίαν ἐκπερισσοῦ ἐν ἑαυτοῖς ἐξίσταντο, καὶ ἐθαύμαζον. ");
INSERT INTO grctr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Οὐ γὰρ συνῆκαν ἐπὶ τοῖς ἄρτοις· ἦν γὰρ ἡ καρδία αὐτῶν πεπωρωμένη. ");
INSERT INTO grctr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Καὶ διαπεράσαντες ἦλθον ἐπὶ τὴν γῆν Γενησαρέτ, καὶ προσωρμίσθησαν. ");
INSERT INTO grctr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Καὶ ἐξελθόντων αὐτῶν ἐκ τοῦ πλοίου, εὐθέως ἐπιγνόντες αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","περιδραμόντες ὅλην τὴν περίχωρον ἐκείνην, ἤρξαντο ἐπὶ τοῖς κραββάτοις τοὺς κακῶς ἔχοντας περιφέρειν, ὅπου ἤκουον ὅτι ἐκεῖ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Καὶ ὅπου ἂν εἰσεπορεύετο εἰς κώμας ἢ πόλεις ἢ ἀγρούς, ἐν ταῖς ἀγοραῖς ἐτίθουν τοὺς ἀσθενοῦντας, καὶ παρεκάλουν αὐτὸν ἵνα κἂν τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ ἅψωνται· καὶ ὅσοι ἂν ἥπτοντο αὐτοῦ ἐσώζοντο. ");
INSERT INTO grctr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Καὶ συνάγονται πρὸς αὐτὸν οἱ Φαρισαῖοι, καί τινες τῶν γραμματέων, ἐλθόντες ἀπὸ Ἱεροσολύμων· ");
INSERT INTO grctr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","καὶ ἰδόντες τινὰς τῶν μαθητῶν αὐτοῦ κοιναῖς χερσί, τοῦτ᾿ ἔστιν ἀνίπτοις, ἐσθίοντας ἄρτους ἐμέμψαντο. ");
INSERT INTO grctr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Οἱ γὰρ Φαρισαῖοι καὶ πάντες οἱ Ἰουδαῖοι, ἐὰν μὴ πυγμῇ νίψωνται τὰς χεῖρας, οὐκ ἐσθίουσι, κρατοῦντες τὴν παράδοσιν τῶν πρεσβυτέρων· ");
INSERT INTO grctr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","καὶ ἀπὸ ἀγορᾶς, ἐὰν μὴ βαπτίσωνται, οὐκ ἐσθίουσι· καὶ ἄλλα πολλά ἐστιν ἃ παρέλαβον κρατεῖν, βαπτισμοὺς ποτηρίων καὶ ξεστῶν καὶ χαλκίων καὶ κλινῶν. ");
INSERT INTO grctr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ἔπειτα ἐπερωτῶσιν αὐτὸν οἱ Φαρισαῖοι καὶ οἱ γραμματεῖς, Διὰ τί οἱ μαθηταί σου οὐ περιπατοῦσι κατὰ τὴν παράδοσιν τῶν πρεσβυτέρων, ἀλλὰ ἀνίπτοις χερσὶν ἐσθίουσι τὸν ἄρτον; ");
INSERT INTO grctr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς ὅτι Καλῶς προεφήτευσεν Ἠσαΐας περὶ ὑμῶν τῶν ὑποκριτῶν, ὡς γέγραπται, Οὗτος ὁ λαὸς τοῖς χείλεσί με τιμᾷ, ἡ δὲ καρδία αὐτῶν πόρρω ἀπέχει ἀπ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Μάτην δὲ σέβονταί με, διδάσκοντες διδασκαλίας ἐντάλματα ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ἀφέντες γὰρ τὴν ἐντολὴν τοῦ Θεοῦ, κρατεῖτε τὴν παράδοσιν τῶν ἀνθρώπων, βαπτισμοὺς ξεστῶν καὶ ποτηρίων· καὶ ἄλλα παρόμοια τοιαῦτα πολλὰ ποιεῖτε. ");
INSERT INTO grctr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Καὶ ἔλεγεν αὐτοῖς, Καλῶς ἀθετεῖτε τὴν ἐντολὴν τοῦ Θεοῦ, ἵνα τὴν παράδοσιν ὑμῶν τηρήσητε. ");
INSERT INTO grctr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Μωσῆς γὰρ εἶπε, Τίμα τὸν πατέρα σου καὶ τὴν μητέρα σου· καί, Ὁ κακολογῶν πατέρα ἢ μητέρα θανάτῳ τελευτάτω· ");
INSERT INTO grctr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ὑμεῖς δὲ λέγετε, Ἐὰν εἴπῃ ἄνθρωπος τῷ πατρὶ ἢ τῇ μητρί, Κορβᾶν, ὅ ἐστι, δῶρον, ὃ ἐὰν ἐξ ἐμοῦ ὠφεληθῇς· ");
INSERT INTO grctr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","καὶ οὐκέτι ἀφίετε αὐτὸν οὐδὲν ποιῆσαι τῷ πατρὶ αὐτοῦ ἢ τῇ μητρὶ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ἀκυροῦντες τὸν λόγον τοῦ Θεοῦ τῇ παραδόσει ὑμῶν ᾗ παρεδώκατε· καὶ παρόμοια τοιαῦτα πολλὰ ποιεῖτε. ");
INSERT INTO grctr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Καὶ προσκαλεσάμενος πάντα τὸν ὄχλον, ἔλεγεν αὐτοῖς, Ἀκούετέ μου πάντες, καὶ συνίετε. ");
INSERT INTO grctr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Οὐδέν ἐστιν ἔξωθεν τοῦ ἀνθρώπου εἰσπορευόμενον εἰς αὐτόν, ὃ δύναται αὐτὸν κοινῶσαι· ἀλλὰ τὰ ἐκπορευόμενα ἀπ᾿ αὐτοῦ, ἐκεῖνά ἐστι τὰ κοινοῦντα τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Εἴ τις ἔχει ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Καὶ ὅτε εἰσῆλθεν εἰς οἶκον ἀπὸ τοῦ ὄχλου, ἐπηρώτων αὐτὸν οἱ μαθηταὶ αὐτοῦ περὶ τῆς παραβολῆς. ");
INSERT INTO grctr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Καὶ λέγει αὐτοῖς, Οὕτω καὶ ὑμεῖς ἀσύνετοί ἐστε; Οὐ νοεῖτε ὅτι πᾶν τὸ ἔξωθεν εἰσπορευόμενον εἰς τὸν ἄνθρωπον οὐ δύναται αὐτὸν κοινῶσαι, ");
INSERT INTO grctr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ὅτι οὐκ εἰσπορεύεται αὐτοῦ εἰς τὴν καρδίαν, ἀλλ᾿ εἰς τὴν κοιλίαν, καὶ εἰς τὸν ἀφεδρῶνα ἐκπορεύεται, καθαρίζον πάντα τὰ βρώματα. ");
INSERT INTO grctr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ἔλεγε δὲ ὅτι Τὸ ἐκ τοῦ ἀνθρώπου ἐκπορευόμενον, ἐκεῖνο κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ἔσωθεν γάρ, ἐκ τῆς καρδίας τῶν ἀνθρώπων οἱ διαλογισμοὶ οἱ κακοὶ ἐκπορεύονται, μοιχεῖαι, πορνεῖαι, φόνοι, ");
INSERT INTO grctr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","κλοπαί, πλεονεξίαι, πονηρίαι, δόλος, ἀσέλγεια, ὀφθαλμὸς πονηρός, βλασφημία, ὑπερηφανία, ἀφροσύνη· ");
INSERT INTO grctr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","πάντα ταῦτα τὰ πονηρὰ ἔσωθεν ἐκπορεύεται, καὶ κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Καὶ ἐκεῖθεν ἀναστὰς ἀπῆλθεν εἰς τὰ μεθόρια Τύρου καὶ Σιδῶνος. Καὶ εἰσελθὼν εἰς τὴν οἰκίαν, οὐδένα ἤθελε γνῶναι, καὶ οὐκ ἠδυνήθη λαθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ἀκούσασα γὰρ γυνὴ περὶ αὐτοῦ, ἧς εἶχε τὸ θυγάτριον αὐτῆς πνεῦμα ἀκάθαρτον, ἐλθοῦσα προσέπεσε πρὸς τοὺς πόδας αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ἦν δὲ ἡ γυνὴ Ἑλληνίς, Συροφοίνισσα τῷ γένει· καὶ ἠρώτα αὐτὸν ἵνα τὸ δαιμόνιον ἐκβάλλῃ ἐκ τῆς θυγατρὸς αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῇ, Ἄφες πρῶτον χορτασθῆναι τὰ τέκνα· οὐ γὰρ καλόν ἐστι λαβεῖν τὸν ἄρτον τῶν τέκνων καὶ βαλεῖν τοῖς κυναρίοις. ");
INSERT INTO grctr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ἡ δὲ ἀπεκρίθη καὶ λέγει αὐτῷ, Ναί, Κύριε· καὶ γὰρ τὰ κυνάρια ὑποκάτω τῆς τραπέζης ἐσθίει ἀπὸ τῶν ψιχίων τῶν παιδίων. ");
INSERT INTO grctr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Καὶ εἶπεν αὐτῇ, Διὰ τοῦτον τὸν λόγον ὕπαγε· ἐξελήλυθε τὸ δαιμόνιον ἐκ τῆς θυγατρός σου. ");
INSERT INTO grctr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Καὶ ἀπελθοῦσα εἰς τὸν οἶκον αὐτῆς, εὗρε τὸ δαιμόνιον ἐξεληλυθός, καὶ τὴν θυγατέρα βεβλημένην ἐπὶ τῆς κλίνης. ");
INSERT INTO grctr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Καὶ πάλιν ἐξελθὼν ἐκ τῶν ὁρίων Τύρου καὶ Σιδῶνος, ἦλθε πρὸς τὴν θάλασσαν τῆς Γαλιλαίας, ἀνὰ μέσον τῶν ὁρίων Δεκαπόλεως. ");
INSERT INTO grctr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Καὶ φέρουσιν αὐτῷ κωφὸν μογιλάλον, καὶ παρακαλοῦσιν αὐτὸν ἵνα ἐπιθῇ αὐτῷ τὴν χεῖρα. ");
INSERT INTO grctr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Καὶ ἀπολαβόμενος αὐτὸν ἀπὸ τοῦ ὄχλου κατ᾿ ἰδίαν, ἔβαλε τοὺς δακτύλους αὐτοῦ εἰς τὰ ὦτα αὐτοῦ, καὶ πτύσας ἥψατο τῆς γλώσσης αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","καὶ ἀναβλέψας εἰς τὸν οὐρανόν, ἐστέναξε, καὶ λέγει αὐτῷ, Ἐφφαθά, ὅ ἐστι, Διανοίχθητι. ");
INSERT INTO grctr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Καὶ εὐθέως διηνοίχθησαν αὐτοῦ αἱ ἀκοαί· καὶ ἐλύθη ὁ δεσμὸς τῆς γλώσσης αὐτοῦ, καὶ ἐλάλει ὀρθῶς. ");
INSERT INTO grctr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Καὶ διεστείλατο αὐτοῖς ἵνα μηδενὶ εἴπωσιν· ὅσον δὲ αὐτὸς αὐτοῖς διεστέλλετο, μᾶλλον περισσότερον ἐκήρυσσον. ");
INSERT INTO grctr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Καὶ ὑπερπερισσῶς ἐξεπλήσσοντο, λέγοντες, Καλῶς πάντα πεποίηκε· καὶ τοὺς κωφοὺς ποιεῖ ἀκούειν, καὶ τοὺς ἀλάλους λαλεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ἐν ἐκείναις ταῖς ἡμέραις, παμπόλλου ὄχλου ὄντος, καὶ μὴ ἐχόντων τί φάγωσι, προσκαλεσάμενος ὁ Ἰησοῦς τοὺς μαθητὰς αὐτοῦ λέγει αὐτοῖς, ");
INSERT INTO grctr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Σπλαγχνίζομαι ἐπὶ τὸν ὄχλον, ὅτι ἤδη ἡμέρας τρεῖς προσμένουσί μοι, καὶ οὐκ ἔχουσι τί φάγωσι· ");
INSERT INTO grctr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","καὶ ἐὰν ἀπολύσω αὐτοὺς νήστεις εἰς οἶκον αὐτῶν, ἐκλυθήσονται ἐν τῇ ὁδῷ· τινὲς γὰρ αὐτῶν μακρόθεν ἥκασι. ");
INSERT INTO grctr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Καὶ ἀπεκρίθησαν αὐτῷ οἱ μαθηταὶ αὐτοῦ, Πόθεν τούτους δυνήσεταί τις ὧδε χορτάσαι ἄρτων ἐπ᾿ ἐρημίας; ");
INSERT INTO grctr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Καὶ ἐπηρώτα αὐτούς, Πόσους ἔχετε ἄρτους; Οἱ δὲ εἶπον, Ἑπτά. ");
INSERT INTO grctr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Καὶ παρήγγειλε τῷ ὄχλῳ ἀναπεσεῖν ἐπὶ τῆς γῆς· καὶ λαβὼν τοὺς ἑπτὰ ἄρτους, εὐχαριστήσας ἔκλασε καὶ ἐδίδου τοῖς μαθηταῖς αὐτοῦ, ἵνα παραθῶσι· καὶ παρέθηκαν τῷ ὄχλῳ. ");
INSERT INTO grctr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Καὶ εἶχον ἰχθύδια ὀλίγα· καὶ εὐλογήσας εἶπε παραθεῖναι καὶ αὐτά. ");
INSERT INTO grctr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ἔφαγον δέ, καὶ ἐχορτάσθησαν· καὶ ἦραν περισσεύματα κλασμάτων ἑπτὰ σπυρίδας. ");
INSERT INTO grctr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ἦσαν δὲ οἱ φαγόντες ὡς τετρακισχίλιοι· καὶ ἀπέλυσεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Καὶ εὐθέως ἐμβὰς εἰς τὸ πλοῖον μετὰ τῶν μαθητῶν αὐτοῦ, ἦλθεν εἰς τὰ μέρη Δαλμανουθά. ");
INSERT INTO grctr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Καὶ ἐξῆλθον οἱ Φαρισαῖοι, καὶ ἤρξαντο συζητεῖν αὐτῷ, ζητοῦντες παρ᾿ αὐτοῦ σημεῖον ἀπὸ τοῦ οὐρανοῦ, πειράζοντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Καὶ ἀναστενάξας τῷ πνεύματι αὐτοῦ λέγει, Τί ἡ γενεὰ αὕτη σημεῖον ἐπιζητεῖ; Ἀμὴν λέγω ὑμῖν, εἰ δοθήσεται τῇ γενεᾷ ταύτῃ σημεῖον. ");
INSERT INTO grctr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Καὶ ἀφεὶς αὐτούς, ἐμβὰς πάλιν εἰς τὸ πλοῖον, ἀπῆλθεν εἰς τὸ πέραν. ");
INSERT INTO grctr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Καὶ ἐπελάθοντο λαβεῖν ἄρτους, καὶ εἰ μὴ ἕνα ἄρτον οὐκ εἶχον μεθ᾿ ἑαυτῶν ἐν τῷ πλοίῳ. ");
INSERT INTO grctr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Καὶ διεστέλλετο αὐτοῖς, λέγων, Ὁρᾶτε, βλέπετε ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ τῆς ζύμης Ἡρῴδου. ");
INSERT INTO grctr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Καὶ διελογίζοντο πρὸς ἀλλήλους, λέγοντες ὅτι Ἄρτους οὐκ ἔχομεν. ");
INSERT INTO grctr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Καὶ γνοὺς ὁ Ἰησοῦς λέγει αὐτοῖς, Τί διαλογίζεσθε ὅτι ἄρτους οὐκ ἔχετε; Οὔπω νοεῖτε, οὐδὲ συνίετε; Ἔτι πεπωρωμένην ἔχετε τὴν καρδίαν ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ὀφθαλμοὺς ἔχοντες οὐ βλέπετε; Καὶ ὦτα ἔχοντες οὐκ ἀκούετε; Καὶ οὐ μνημονεύετε; ");
INSERT INTO grctr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ὅτε τοὺς πέντε ἄρτους ἔκλασα εἰς τοὺς πεντακισχιλίους, πόσους κοφίνους πλήρεις κλασμάτων ἤρατε; Λέγουσιν αὐτῷ, Δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ὅτε δὲ τοὺς ἑπτὰ εἰς τοὺς τετρακισχιλίους, πόσων σπυρίδων πληρώματα κλασμάτων ἤρατε; Οἱ δὲ εἶπον, Ἑπτά. ");
INSERT INTO grctr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Καὶ ἔλεγεν αὐτοῖς, Πῶς οὐ συνίετε; ");
INSERT INTO grctr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Καὶ ἔρχεται εἰς Βηθσαϊδάν. Καὶ φέρουσιν αὐτῷ τυφλόν, καὶ παρακαλοῦσιν αὐτὸν ἵνα αὐτοῦ ἅψηται. ");
INSERT INTO grctr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Καὶ ἐπιλαβόμενος τῆς χειρὸς τοῦ τυφλοῦ, ἐξήγαγεν αὐτὸν ἔξω τῆς κώμης· καὶ πτύσας εἰς τὰ ὄμματα αὐτοῦ, ἐπιθεὶς τὰς χεῖρας αὐτῷ, ἐπηρώτα αὐτὸν εἴ τι βλέπει. ");
INSERT INTO grctr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Καὶ ἀναβλέψας ἔλεγε, Βλέπω τοὺς ἀνθρώπους, ὅτι ὡς δένδρα ὁρῶ περιπατοῦντας. ");
INSERT INTO grctr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Εἶτα πάλιν ἐπέθηκε τὰς χεῖρας ἐπὶ τοὺς ὀφθαλμοὺς αὐτοῦ, καὶ ἐποίησεν αὐτὸν ἀναβλέψαι. Καὶ ἀποκατεστάθη, καὶ ἐνέβλεψε τηλαυγῶς ἅπαντας. ");
INSERT INTO grctr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Καὶ ἀπέστειλεν αὐτὸν εἰς τὸν οἶκον αὐτοῦ, λέγων, Μηδὲ εἰς τὴν κώμην εἰσέλθῃς, μηδὲ εἴπῃς τινὶ ἐν τῇ κώμῃ. ");
INSERT INTO grctr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Καὶ ἐξῆλθεν ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὰς κώμας Καισαρείας τῆς Φιλίππου· καὶ ἐν τῇ ὁδῷ ἐπηρώτα τοὺς μαθητὰς αὐτοῦ, λέγων αὐτοῖς, Τίνα με λέγουσιν οἱ ἄνθρωποι εἶναι; ");
INSERT INTO grctr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Οἱ δὲ ἀπεκρίθησαν, Ἰωάννην τὸν βαπτιστήν· καὶ ἄλλοι Ἠλίαν· ἄλλοι δὲ ἕνα τῶν προφητῶν. ");
INSERT INTO grctr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Καὶ αὐτὸς λέγει αὐτοῖς, Ὑμεῖς δὲ τίνα με λέγετε εἶναι; Ἀποκριθεὶς δὲ ὁ Πέτρος λέγει αὐτῷ, Σὺ εἶ ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Καὶ ἐπετίμησεν αὐτοῖς, ἵνα μηδενὶ λέγωσι περὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Καὶ ἤρξατο διδάσκειν αὐτούς, ὅτι δεῖ τὸν υἱὸν τοῦ ἀνθρώπου πολλὰ παθεῖν, καὶ ἀποδοκιμασθῆναι ἀπὸ τῶν πρεσβυτέρων καὶ ἀρχιερέων καὶ γραμματέων, καὶ ἀποκτανθῆναι, καὶ μετὰ τρεῖς ἡμέρας ἀναστῆναι· ");
INSERT INTO grctr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","καὶ παρρησίᾳ τὸν λόγον ἐλάλει. Καὶ προσλαβόμενος αὐτὸν ὁ Πέτρος ἤρξατο ἐπιτιμᾷν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ὁ δὲ ἐπιστραφείς, καὶ ἰδὼν τοὺς μαθητὰς αὐτοῦ, ἐπετίμησε τῷ Πέτρῳ, λέγων, Ὕπαγε ὀπίσω μου, Σατανᾶ· ὅτι οὐ φρονεῖς τὰ τοῦ Θεοῦ, ἀλλὰ τὰ τῶν ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Καὶ προσκαλεσάμενος τὸν ὄχλον σὺν τοῖς μαθηταῖς αὐτοῦ, εἶπεν αὐτοῖς, Ὅστις θέλει ὀπίσω μου ἐλθεῖν, ἀπαρνησάσθω ἑαυτόν, καὶ ἀράτω τὸν σταυρὸν αὐτοῦ, καὶ ἀκολουθείτω μοι. ");
INSERT INTO grctr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ὃς γὰρ ἂν θέλῃ τὴν ψυχὴν αὐτοῦ σῶσαι, ἀπολέσει αὐτήν· ὃς δ᾿ ἂν ἀπολέσῃ τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ καὶ τοῦ εὐαγγελίου, οὗτος σώσει αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Τί γὰρ ὠφελήσει ἄνθρωπον, ἐὰν κερδήσῃ τὸν κόσμον ὅλον, καὶ ζημιωθῇ τὴν ψυχὴν αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ἢ τί δώσει ἄνθρωπος ἀντάλλαγμα τῆς ψυχῆς αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ὃς γὰρ ἂν ἐπαισχυνθῇ με καὶ τοὺς ἐμοὺς λόγους ἐν τῇ γενεᾷ ταύτῃ τῇ μοιχαλίδι καὶ ἁμαρτωλῷ, καὶ ὁ υἱὸς τοῦ ἀνθρώπου ἐπαισχυνθήσεται αὐτόν, ὅταν ἔλθῃ ἐν τῇ δόξῃ τοῦ πατρὸς αὐτοῦ μετὰ τῶν ἀγγέλων τῶν ἁγίων. ");
INSERT INTO grctr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Καὶ ἔλεγεν αὐτοῖς, Ἀμὴν λέγω ὑμῖν ὅτι εἰσί τινες τῶν ὧδε ἑστηκότων, οἵτινες οὐ μὴ γεύσωνται θανάτου, ἕως ἂν ἴδωσι τὴν βασιλείαν τοῦ Θεοῦ ἐληλυθυῖαν ἐν δυνάμει. ");
INSERT INTO grctr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Καὶ μεθ᾿ ἡμέρας ἓξ παραλαμβάνει ὁ Ἰησοῦς τὸν Πέτρον καὶ τὸν Ἰάκωβον καὶ τὸν Ἰωάννην, καὶ ἀναφέρει αὐτοὺς εἰς ὄρος ὑψηλὸν κατ᾿ ἰδίαν μόνους. Καὶ μετεμορφώθη ἔμπροσθεν αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","καὶ τὰ ἱμάτια αὐτοῦ ἐγένετο στίλβοντα, λευκὰ λίαν ὡς χιών, οἷα γναφεὺς ἐπὶ τῆς γῆς οὐ δύναται λευκᾶναι. ");
INSERT INTO grctr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Καὶ ὤφθη αὐτοῖς Ἠλίας σὺν Μωσεῖ, καὶ ἦσαν συλλαλοῦντες τῷ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Καὶ ἀποκριθεὶς ὁ Πέτρος λέγει τῷ Ἰησοῦ, Ῥαββί, καλόν ἐστιν ἡμᾶς ὧδε εἶναι· καὶ ποιήσωμεν σκηνὰς τρεῖς, σοὶ μίαν, καὶ Μωσεῖ μίαν, καὶ Ἠλίᾳ μίαν. ");
INSERT INTO grctr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Οὐ γὰρ ᾔδει τί λαλήσῃ· ἦσαν γὰρ ἔκφοβοι. ");
INSERT INTO grctr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Καὶ ἐγένετο νεφέλη ἐπισκιάζουσα αὐτοῖς· καὶ ἦλθε φωνὴ ἐκ τῆς νεφέλης λέγουσα, Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός· αὐτοῦ ἀκούετε. ");
INSERT INTO grctr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Καὶ ἐξάπινα περιβλεψάμενοι, οὐκέτι οὐδένα εἶδον, ἀλλὰ τὸν Ἰησοῦν μόνον μεθ᾿ ἑαυτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Καταβαινόντων δὲ αὐτῶν ἀπὸ τοῦ ὄρους, διεστείλατο αὐτοῖς ἵνα μηδενὶ διηγήσωνται ἃ εἶδον, εἰ μὴ ὅταν ὁ υἱὸς τοῦ ἀνθρώπου ἐκ νεκρῶν ἀναστῇ. ");
INSERT INTO grctr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Καὶ τὸν λόγον ἐκράτησαν πρὸς ἑαυτούς, συζητοῦντες τί ἐστι τὸ ἐκ νεκρῶν ἀναστῆναι. ");
INSERT INTO grctr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Καὶ ἐπηρώτων αὐτόν, λέγοντες ὅτι Λέγουσιν οἱ γραμματεῖς ὅτι Ἠλίαν δεῖ ἐλθεῖν πρῶτον; ");
INSERT INTO grctr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ὁ δὲ ἀποκριθείς, εἶπεν αὐτοῖς, Ἠλίας μὲν ἐλθὼν πρῶτον, ἀποκαθιστᾷ πάντα· καὶ πῶς γέγραπται ἐπὶ τὸν υἱὸν τοῦ ἀνθρώπου, ἵνα πολλὰ πάθῃ καὶ ἐξουδενωθῇ. ");
INSERT INTO grctr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ἀλλὰ λέγω ὑμῖν ὅτι καὶ Ἠλίας ἐλήλυθε, καὶ ἐποίησαν αὐτῷ ὅσα ἠθέλησαν, καθὼς γέγραπται ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Καὶ ἐλθὼν πρὸς τοὺς μαθητάς, εἶδεν ὄχλον πολὺν περὶ αὐτούς, καὶ γραμματεῖς συζητοῦντας αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Καὶ εὐθέως πᾶς ὁ ὄχλος ἰδὼν αὐτὸν ἐξεθαμβήθη, καὶ προστρέχοντες ἠσπάζοντο αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Καὶ ἐπηρώτησε τοὺς γραμματεῖς, Τί συζητεῖτε πρὸς αὐτούς; ");
INSERT INTO grctr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Καὶ ἀποκριθεὶς εἷς ἐκ τοῦ ὄχλου εἶπε, Διδάσκαλε, ἤνεγκα τὸν υἱόν μου πρός σε, ἔχοντα πνεῦμα ἄλαλον. ");
INSERT INTO grctr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Καὶ ὅπου ἂν αὐτὸν καταλάβῃ, ῥήσσει αὐτόν· καὶ ἀφρίζει, καὶ τρίζει τοὺς ὀδόντας αὐτοῦ, καὶ ξηραίνεται· καὶ εἶπον τοῖς μαθηταῖς σου ἵνα αὐτὸ ἐκβάλωσι, καὶ οὐκ ἴσχυσαν. ");
INSERT INTO grctr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ὁ δὲ ἀποκριθεὶς αὐτῷ λέγει, Ὦ γενεὰ ἄπιστος, ἕως πότε πρὸς ὑμᾶς ἔσομαι; Ἕως πότε ἀνέξομαι ὑμῶν; Φέρετε αὐτὸν πρός με. ");
INSERT INTO grctr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Καὶ ἤνεγκαν αὐτὸν πρὸς αὐτόν· καὶ ἰδὼν αὐτόν, εὐθέως τὸ πνεῦμα ἐσπάραξεν αὐτόν· καὶ πεσὼν ἐπὶ τῆς γῆς, ἐκυλίετο ἀφρίζων. ");
INSERT INTO grctr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Καὶ ἐπηρώτησε τὸν πατέρα αὐτοῦ, Πόσος χρόνος ἐστίν, ὡς τοῦτο γέγονεν αὐτῷ; Ὁ δὲ εἶπε, Παιδιόθεν. ");
INSERT INTO grctr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Καὶ πολλάκις αὐτὸν καὶ εἰς πῦρ ἔβαλε καὶ εἰς ὕδατα, ἵνα ἀπολέσῃ αὐτόν· ἀλλ᾿ εἴ τι δύνασαι, βοήθησον ἡμῖν, σπλαγχνισθεὶς ἐφ᾿ ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Τὸ εἰ δύνασαι πιστεῦσαι, πάντα δυνατὰ τῷ πιστεύοντι. ");
INSERT INTO grctr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Καὶ εὐθέως κράξας ὁ πατὴρ τοῦ παιδίου, μετὰ δακρύων ἔλεγε, Πιστεύω, Κύριε, βοήθει μου τῇ ἀπιστίᾳ. ");
INSERT INTO grctr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ἰδὼν δὲ ὁ Ἰησοῦς ὅτι ἐπισυντρέχει ὄχλος, ἐπετίμησε τῷ πνεύματι τῷ ἀκαθάρτῳ, λέγων αὐτῷ, Τὸ πνεῦμα τὸ ἄλαλον καὶ κωφόν, ἐγώ σοι ἐπιτάσσω, ἔξελθε ἐξ αὐτοῦ, καὶ μηκέτι εἰσέλθῃς εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Καὶ κράξαν, καὶ πολλὰ σπαράξαν αὐτόν, ἐξῆλθε· καὶ ἐγένετο ὡσεὶ νεκρός, ὥστε πολλοὺς λέγειν ὅτι ἀπέθανεν. ");
INSERT INTO grctr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ὁ δὲ Ἰησοῦς κρατήσας αὐτὸν τῆς χειρός, ἤγειρεν αὐτόν· καὶ ἀνέστη. ");
INSERT INTO grctr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Καὶ εἰσελθόντα αὐτὸν εἰς οἶκον, οἱ μαθηταὶ αὐτοῦ ἐπηρώτων αὐτὸν κατ᾿ ἰδίαν ὅτι Ἡμεῖς οὐκ ἠδυνήθημεν ἐκβαλεῖν αὐτό; ");
INSERT INTO grctr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Καὶ εἶπεν αὐτοῖς, Τοῦτο τὸ γένος ἐν οὐδενὶ δύναται ἐξελθεῖν, εἰ μὴ ἐν προσευχῇ καὶ νηστείᾳ. ");
INSERT INTO grctr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Καὶ ἐκεῖθεν ἐξελθόντες παρεπορεύοντο διὰ τῆς Γαλιλαίας· καὶ οὐκ ἤθελεν ἵνα τις γνῷ. ");
INSERT INTO grctr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ἐδίδασκε γὰρ τοὺς μαθητὰς αὐτοῦ, καὶ ἔλεγεν αὐτοῖς ὅτι Ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς χεῖρας ἀνθρώπων, καὶ ἀποκτενοῦσιν αὐτόν· καὶ ἀποκτανθείς, τῇ τρίτῃ ἡμέρᾳ ἀναστήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Οἱ δὲ ἠγνόουν τὸ ῥῆμα, καὶ ἐφοβοῦντο αὐτὸν ἐπερωτῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Καὶ ἦλθεν εἰς Καπερναούμ· καὶ ἐν τῇ οἰκίᾳ γενόμενος ἐπηρώτα αὐτούς, Τί ἐν τῇ ὁδῷ πρὸς ἑαυτοὺς διελογίζεσθε; ");
INSERT INTO grctr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Οἱ δὲ ἐσιώπων· πρὸς ἀλλήλους γὰρ διελέχθησαν ἐν τῇ ὁδῷ, τίς μείζων. ");
INSERT INTO grctr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Καὶ καθίσας ἐφώνησε τοὺς δώδεκα, καὶ λέγει αὐτοῖς, Εἴ τις θέλει πρῶτος εἶναι, ἔσται πάντων ἔσχατος, καὶ πάντων διάκονος. ");
INSERT INTO grctr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Καὶ λαβὼν παιδίον, ἔστησεν αὐτὸ ἐν μέσῳ αὐτῶν· καὶ ἐναγκαλισάμενος αὐτό, εἶπεν αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ὃς ἐὰν ἓν τῶν τοιούτων παιδίων δέξηται ἐπὶ τῷ ὀνόματί μου, ἐμὲ δέχεται· καὶ ὃς ἐὰν ἐμὲ δέξηται, οὐκ ἐμὲ δέχεται, ἀλλὰ τὸν ἀποστείλαντά με. ");
INSERT INTO grctr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ἀπεκρίθη δὲ αὐτῷ ὁ Ἰωάννης, λέγων, Διδάσκαλε, εἴδομέν τινα ἐν τῷ ὀνόματί σου ἐκβάλλοντα δαιμόνια, ὃς οὐκ ἀκολουθεῖ ἡμῖν· καὶ ἐκωλύσαμεν αὐτόν, ὅτι οὐκ ἀκολουθεῖ ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ὁ δὲ Ἰησοῦς εἶπε, Μὴ κωλύετε αὐτόν· οὐδεὶς γάρ ἐστιν ὃς ποιήσει δύναμιν ἐπὶ τῷ ὀνόματί μου, καὶ δυνήσεται ταχὺ κακολογῆσαί με. ");
INSERT INTO grctr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ὃς γὰρ οὐκ ἔστι καθ᾿ ἡμῶν ὑπὲρ ἡμῶν ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ὃς γὰρ ἂν ποτίσῃ ὑμᾶς ποτήριον ὕδατος ἐν τῷ ὀνόματί μου, ὅτι Χριστοῦ ἐστέ, ἀμὴν λέγω ὑμῖν, οὐ μὴ ἀπολέσῃ τὸν μισθὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Καὶ ὃς ἂν σκανδαλίσῃ ἕνα τῶν μικρῶν τῶν πιστευόντων εἰς ἐμέ, καλόν ἐστιν αὐτῷ μᾶλλον εἰ περίκειται λίθος μυλικὸς περὶ τὸν τράχηλον αὐτοῦ, καὶ βέβληται εἰς τὴν θάλασσαν. ");
INSERT INTO grctr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Καὶ ἐὰν σκανδαλίζῃ σε ἡ χείρ σου, ἀπόκοψον αὐτήν· καλόν σοι ἐστὶ κυλλὸν εἰς τὴν ζωὴν εἰσελθεῖν, ἢ τὰς δύο χεῖρας ἔχοντα ἀπελθεῖν εἰς τὴν γέενναν, εἰς τὸ πῦρ τὸ ἄσβεστον, ");
INSERT INTO grctr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ὅπου ὁ σκώληξ αὐτῶν οὐ τελευτᾷ, καὶ τὸ πῦρ οὐ σβέννυται. ");
INSERT INTO grctr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Καὶ ἐὰν ὁ πούς σου σκανδαλίζῃ σε, ἀπόκοψον αὐτόν· καλόν ἐστί σοι εἰσελθεῖν εἰς τὴν ζωὴν χωλόν, ἢ τοὺς δύο πόδας ἔχοντα βληθῆναι εἰς τὴν γέενναν, εἰς τὸ πῦρ τὸ ἄσβεστον, ");
INSERT INTO grctr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ὅπου ὁ σκώληξ αὐτῶν οὐ τελευτᾷ, καὶ τὸ πῦρ οὐ σβέννυται. ");
INSERT INTO grctr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Καὶ ἐὰν ὁ ὀφθαλμός σου σκανδαλίζῃ σε, ἔκβαλε αὐτόν· καλόν σοι ἐστὶ μονόφθαλμον εἰσελθεῖν εἰς τὴν βασιλείαν τοῦ Θεοῦ, ἢ δύο ὀφθαλμοὺς ἔχοντα βληθῆναι εἰς τὴν γέενναν τοῦ πυρός, ");
INSERT INTO grctr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ὅπου ὁ σκώληξ αὐτῶν οὐ τελευτᾷ, καὶ τὸ πῦρ οὐ σβέννυται. ");
INSERT INTO grctr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Πᾶς γὰρ πυρὶ ἁλισθήσεται, καὶ πᾶσα θυσία ἁλὶ ἁλισθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Καλὸν τὸ ἅλας· ἐὰν δὲ τὸ ἅλας ἄναλον γένηται, ἐν τίνι αὐτὸ ἀρτύσετε; Ἔχετε ἐν ἑαυτοῖς ἅλας, καὶ εἰρηνεύετε ἐν ἀλλήλοις. ");
INSERT INTO grctr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Κἀκεῖθεν ἀναστὰς ἔρχεται εἰς τὰ ὅρια τῆς Ἰουδαίας διὰ τοῦ πέραν τοῦ Ἰορδάνου· καὶ συμπορεύονται πάλιν ὄχλοι πρὸς αὐτόν· καί, ὡς εἰώθει, πάλιν ἐδίδασκεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Καὶ προσελθόντες οἱ Φαρισαῖοι ἐπηρώτησαν αὐτόν, Εἰ ἔξεστιν ἀνδρὶ γυναῖκα ἀπολῦσαι, πειράζοντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Τί ὑμῖν ἐνετείλατο Μωσῆς; ");
INSERT INTO grctr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Οἱ δὲ εἶπον, Μωσῆς ἐπέτρεψε βιβλίον ἀποστασίου γράψαι, καὶ ἀπολῦσαι. ");
INSERT INTO grctr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Πρὸς τὴν σκληροκαρδίαν ὑμῶν ἔγραψεν ὑμῖν τὴν ἐντολὴν ταύτην· ");
INSERT INTO grctr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ἀπὸ δὲ ἀρχῆς κτίσεως, ἄρσεν καὶ θῆλυ ἐποίησεν αὐτοὺς ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ἕνεκεν τούτου καταλείψει ἄνθρωπος τὸν πατέρα αὐτοῦ καὶ τὴν μητέρα, καὶ προσκολληθήσεται πρὸς τὴν γυναῖκα αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","καὶ ἔσονται οἱ δύο εἰς σάρκα μίαν. Ὥστε οὐκέτι εἰσὶ δύο, ἀλλὰ μία σάρξ. ");
INSERT INTO grctr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ὃ οὖν ὁ Θεὸς συνέζευξεν, ἄνθρωπος μὴ χωριζέτω. ");
INSERT INTO grctr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Καὶ ἐν τῇ οἰκίᾳ πάλιν οἱ μαθηταὶ αὐτοῦ περὶ τοῦ αὐτοῦ ἐπηρώτησαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Καὶ λέγει αὐτοῖς, Ὃς ἐὰν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ καὶ γαμήσῃ ἄλλην, μοιχᾶται ἐπ᾿ αὐτήν· ");
INSERT INTO grctr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","καὶ ἐὰν γυνὴ ἀπολύσῃ τὸν ἄνδρα αὐτῆς καὶ γαμηθῇ ἄλλῳ, μοιχᾶται. ");
INSERT INTO grctr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Καὶ προσέφερον αὐτῷ παιδία, ἵνα ἅψηται αὐτῶν· οἱ δὲ μαθηταὶ ἐπετίμων τοῖς προσφέρουσιν. ");
INSERT INTO grctr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ἰδὼν δὲ ὁ Ἰησοῦς ἠγανάκτησε, καὶ εἶπεν αὐτοῖς, Ἄφετε τὰ παιδία ἔρχεσθαι πρός με· καὶ μὴ κωλύετε αὐτά· τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ἀμὴν λέγω ὑμῖν, ὃς ἐὰν μὴ δέξηται τὴν βασιλείαν τοῦ Θεοῦ ὡς παιδίον, οὐ μὴ εἰσέλθῃ εἰς αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Καὶ ἐναγκαλισάμενος αὐτά, τιθεὶς τὰς χεῖρας ἐπ᾿ αὐτά, ηὐλόγει αὐτά. ");
INSERT INTO grctr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Καὶ ἐκπορευομένου αὐτοῦ εἰς ὁδόν, προσδραμὼν εἷς καὶ γονυπετήσας αὐτὸν ἐπηρώτα αὐτόν, Διδάσκαλε ἀγαθέ, τί ποιήσω ἵνα ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grctr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Τί με λέγεις ἀγαθόν; Οὐδεὶς ἀγαθός, εἰ μὴ εἷς, ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Τὰς ἐντολὰς οἶδας, Μὴ μοιχεύσῃς, μὴ φονεύσῃς, μὴ κλέψῃς, μὴ ψευδομαρτυρήσῃς, μὴ ἀποστερήσῃς, τίμα τὸν πατέρα σου καὶ τὴν μητέρα. ");
INSERT INTO grctr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτῷ, Διδάσκαλε, ταῦτα πάντα ἐφυλαξάμην ἐκ νεότητός μου. ");
INSERT INTO grctr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ὁ δὲ Ἰησοῦς ἐμβλέψας αὐτῷ ἠγάπησεν αὐτόν, καὶ εἶπεν αὐτῷ, Ἕν σοι ὑστερεῖ· ὕπαγε, ὅσα ἔχεις πώλησον, καὶ δὸς τοῖς πτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν οὐρανῷ· καὶ δεῦρο, ἀκολούθει μοι, ἄρας τὸν σταυρόν. ");
INSERT INTO grctr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ὁ δὲ στυγνάσας ἐπὶ τῷ λόγῳ ἀπῆλθε λυπούμενος· ἦν γὰρ ἔχων κτήματα πολλά. ");
INSERT INTO grctr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Καὶ περιβλεψάμενος ὁ Ἰησοῦς λέγει τοῖς μαθηταῖς αὐτοῦ, Πῶς δυσκόλως οἱ τὰ χρήματα ἔχοντες εἰς τὴν βασιλείαν τοῦ Θεοῦ εἰσελεύσονται. ");
INSERT INTO grctr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Οἱ δὲ μαθηταὶ ἐθαμβοῦντο ἐπὶ τοῖς λόγοις αὐτοῦ. Ὁ δὲ Ἰησοῦς πάλιν ἀποκριθεὶς λέγει αὐτοῖς, Τέκνα, πῶς δύσκολόν ἐστι τοὺς πεποιθότας ἐπὶ τοῖς χρήμασιν εἰς τὴν βασιλείαν τοῦ Θεοῦ εἰσελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Εὐκοπώτερόν ἐστι κάμηλον διὰ τῆς τρυμαλιᾶς τῆς ῥαφίδος διελθεῖν, ἢ πλούσιον εἰς τὴν βασιλείαν τοῦ Θεοῦ εἰσελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Οἱ δὲ περισσῶς ἐξεπλήσσοντο, λέγοντες πρὸς ἑαυτούς, Καὶ τίς δύναται σωθῆναι; ");
INSERT INTO grctr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ἐμβλέψας δὲ αὐτοῖς ὁ Ἰησοῦς λέγει, Παρὰ ἀνθρώποις ἀδύνατον, ἀλλ᾿ οὐ παρὰ τῷ Θεῷ· πάντα γὰρ δυνατά ἐστι παρὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Καὶ ἤρξατο ὁ Πέτρος λέγειν αὐτῷ, Ἰδού, ἡμεῖς ἀφήκαμεν πάντα καὶ ἠκολουθήσαμέν σοι. ");
INSERT INTO grctr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Ἀμὴν λέγω ὑμῖν, οὐδείς ἐστιν ὃς ἀφῆκεν οἰκίαν, ἢ ἀδελφούς, ἢ ἀδελφάς, ἢ πατέρα, ἢ μητέρα, ἢ γυναῖκα, ἢ τέκνα, ἢ ἀγρούς, ἕνεκεν ἐμοῦ καὶ τοῦ εὐαγγελίου, ");
INSERT INTO grctr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ἐὰν μὴ λάβῃ ἑκατονταπλασίονα νῦν ἐν τῷ καιρῷ τούτῳ, οἰκίας καὶ ἀδελφοὺς καὶ ἀδελφὰς καὶ μητέρας καὶ τέκνα καὶ ἀγρούς, μετὰ διωγμῶν, καὶ ἐν τῷ αἰῶνι τῷ ἐρχομένῳ ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Πολλοὶ δὲ ἔσονται πρῶτοι ἔσχατοι, καὶ οἱ ἔσχατοι πρῶτοι. ");
INSERT INTO grctr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ἦσαν δὲ ἐν τῇ ὁδῷ ἀναβαίνοντες εἰς Ἱεροσόλυμα· καὶ ἦν προάγων αὐτοὺς ὁ Ἰησοῦς, καὶ ἐθαμβοῦντο, καὶ ἀκολουθοῦντες ἐφοβοῦντο. Καὶ παραλαβὼν πάλιν τοὺς δώδεκα, ἤρξατο αὐτοῖς λέγειν τὰ μέλλοντα αὐτῷ συμβαίνειν· ");
INSERT INTO grctr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ὅτι Ἰδού, ἀναβαίνομεν εἰς Ἱεροσόλυμα, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδοθήσεται τοῖς ἀρχιερεῦσι καὶ τοῖς γραμματεῦσι, καὶ κατακρινοῦσιν αὐτὸν θανάτῳ, καὶ παραδώσουσιν αὐτὸν τοῖς ἔθνεσι, ");
INSERT INTO grctr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","καὶ ἐμπαίξουσιν αὐτῷ, καὶ μαστιγώσουσιν αὐτόν, καὶ ἐμπτύσουσιν αὐτῷ, καὶ ἀποκτενοῦσιν αὐτόν· καὶ τῇ τρίτῃ ἡμέρᾳ ἀναστήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Καὶ προσπορεύονται αὐτῷ Ἰάκωβος καὶ Ἰωάννης οἱ υἱοὶ Ζεβεδαίου, λέγοντες, Διδάσκαλε, θέλομεν ἵνα ὃ ἐὰν αἰτήσωμεν, ποιήσῃς ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ὁ δὲ εἶπεν αὐτοῖς, Τί θέλετε ποιῆσαί με ὑμῖν; ");
INSERT INTO grctr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Οἱ δὲ εἶπον αὐτῷ, Δὸς ἡμῖν, ἵνα εἷς ἐκ δεξιῶν σου καὶ εἷς ἐξ εὐωνύμων σου καθίσωμεν ἐν τῇ δόξῃ σου. ");
INSERT INTO grctr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Οὐκ οἴδατε τί αἰτεῖσθε. Δύνασθε πιεῖν τὸ ποτήριον ὃ ἐγὼ πίνω, καὶ τὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθῆναι; ");
INSERT INTO grctr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Οἱ δὲ εἶπον αὐτῷ, Δυνάμεθα. Ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς, Τὸ μὲν ποτήριον ὃ ἐγὼ πίνω πίεσθε, καὶ τὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθήσεσθε· ");
INSERT INTO grctr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","τὸ δὲ καθίσαι ἐκ δεξιῶν μου καὶ ἐξ εὐωνύμων μου οὐκ ἔστιν ἐμὸν δοῦναι, ἀλλ᾿ οἷς ἡτοίμασται. ");
INSERT INTO grctr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Καὶ ἀκούσαντες οἱ δέκα ἤρξαντο ἀγανακτεῖν περὶ Ἰακώβου καὶ Ἰωάννου. ");
INSERT INTO grctr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ὁ δὲ Ἰησοῦς προσκαλεσάμενος αὐτοὺς λέγει αὐτοῖς, Οἴδατε ὅτι οἱ δοκοῦντες ἄρχειν τῶν ἐθνῶν κατακυριεύουσιν αὐτῶν, καὶ οἱ μεγάλοι αὐτῶν κατεξουσιάζουσιν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Οὐχ οὕτω δὲ ἔσται ἐν ὑμῖν· ἀλλ᾿ ὃς ἐὰν θέλῃ γενέσθαι μέγας ἐν ὑμῖν ἔσται διάκονος ὑμῶν· ");
INSERT INTO grctr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","καὶ ὃς ἂν θέλῃ ὑμῶν γενέσθαι πρῶτος, ἔσται πάντων δοῦλος. ");
INSERT INTO grctr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Καὶ γὰρ ὁ υἱὸς τοῦ ἀνθρώπου οὐκ ἦλθε διακονηθῆναι, ἀλλὰ διακονῆσαι, καὶ δοῦναι τὴν ψυχὴν αὐτοῦ λύτρον ἀντὶ πολλῶν. ");
INSERT INTO grctr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Καὶ ἔρχονται εἰς Ἰεριχώ· καὶ ἐκπορευομένου αὐτοῦ ἀπὸ Ἰεριχώ, καὶ τῶν μαθητῶν αὐτοῦ, καὶ ὄχλου ἱκανοῦ, υἱὸς Τιμαίου Βαρτίμαιος ὁ τυφλὸς ἐκάθητο παρὰ τὴν ὁδὸν προσαιτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Καὶ ἀκούσας ὅτι Ἰησοῦς ὁ Ναζωραῖός ἐστιν, ἤρξατο κράζειν καὶ λέγειν, Ὁ υἱὸς Δαβίδ, Ἰησοῦ, ἐλέησόν με. ");
INSERT INTO grctr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Καὶ ἐπετίμων αὐτῷ πολλοί, ἵνα σιωπήσῃ· ὁ δὲ πολλῷ μᾶλλον ἔκραζεν, Υἱὲ Δαβίδ, ἐλέησόν με. ");
INSERT INTO grctr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Καὶ στὰς ὁ Ἰησοῦς εἶπεν αὐτὸν φωνηθῆναι· καὶ φωνοῦσι τὸν τυφλόν, λέγοντες αὐτῷ, Θάρσει· ἔγειραι, φωνεῖ σε. ");
INSERT INTO grctr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ὁ δὲ ἀποβαλὼν τὸ ἱμάτιον αὐτοῦ ἀναστὰς ἦλθε πρὸς τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Καὶ ἀποκριθεὶς λέγει αὐτῷ ὁ Ἰησοῦς, Τί θέλεις ποιήσω σοί; Ὁ δὲ τυφλὸς εἶπεν αὐτῷ, Ῥαββονί, ἵνα ἀναβλέψω. ");
INSERT INTO grctr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Ὕπαγε· ἡ πίστις σου σέσωκέ σε. Καὶ εὐθέως ἀνέβλεψε, καὶ ἠκολούθει τῷ Ἰησοῦ ἐν τῇ ὁδῷ. ");
INSERT INTO grctr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Καὶ ὅτε ἐγγίζουσιν εἰς Ἱερουσαλήμ, εἰς Βηθφαγὴ καὶ Βηθανίαν, πρὸς τὸ ὄρος τῶν Ἐλαιῶν, ἀποστέλλει δύο τῶν μαθητῶν αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","καὶ λέγει αὐτοῖς, Ὑπάγετε εἰς τὴν κώμην τὴν κατέναντι ὑμῶν· καὶ εὐθέως εἰσπορευόμενοι εἰς αὐτὴν εὑρήσετε πῶλον δεδεμένον, ἐφ᾿ ὃν οὐδεὶς ἀνθρώπων κεκάθικε· λύσαντες αὐτὸν ἀγάγετε. ");
INSERT INTO grctr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Καὶ ἐάν τις ὑμῖν εἴπῃ, Τί ποιεῖτε τοῦτο; εἴπατε ὅτι Ὁ Κύριος αὐτοῦ χρείαν ἔχει· καὶ εὐθέως αὐτὸν ἀποστελεῖ ὧδε. ");
INSERT INTO grctr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ἀπῆλθον δὲ καὶ εὗρον τὸν πῶλον δεδεμένον πρὸς τὴν θύραν ἔξω ἐπὶ τοῦ ἀμφόδου, καὶ λύουσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Καί τινες τῶν ἐκεῖ ἑστηκότων ἔλεγον αὐτοῖς, Τί ποιεῖτε λύοντες τὸν πῶλον; ");
INSERT INTO grctr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Οἱ δὲ εἶπον αὐτοῖς καθὼς ἐνετείλατο ὁ Ἰησοῦς· καὶ ἀφῆκαν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Καὶ ἤγαγον τὸν πῶλον πρὸς τὸν Ἰησοῦν· καὶ ἐπέβαλον αὐτῷ τὰ ἱμάτια αὐτῶν, καὶ ἐκάθισεν ἐπ᾿ αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Πολλοὶ δὲ τὰ ἱμάτια αὐτῶν ἔστρωσαν εἰς τὴν ὁδόν· ἄλλοι δὲ στοιβάδας ἔκοπτον ἐκ τῶν δένδρων, καὶ ἐστρώννυον εἰς τὴν ὁδόν. ");
INSERT INTO grctr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Καὶ οἱ προάγοντες καὶ οἱ ἀκολουθοῦντες ἔκραζον, λέγοντες, Ὡσαννά· εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Εὐλογημένη ἡ ἐρχομένη βασιλεία ἐν ὀνόματι Κυρίου τοῦ πατρὸς ἡμῶν Δαβίδ. Ὡσαννὰ ἐν τοῖς ὑψίστοις. ");
INSERT INTO grctr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Καὶ εἰσῆλθεν εἰς Ἱεροσόλυμα ὁ Ἰησοῦς, καὶ εἰς τὸ ἱερόν· καὶ περιβλεψάμενος πάντα, ὀψίας ἤδη οὔσης τῆς ὥρας, ἐξῆλθεν εἰς Βηθανίαν μετὰ τῶν δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Καὶ τῇ ἐπαύριον ἐξελθόντων αὐτῶν ἀπὸ Βηθανίας, ἐπείνασε. ");
INSERT INTO grctr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Καὶ ἰδὼν συκῆν μακρόθεν, ἔχουσαν φύλλα, ἦλθεν εἰ ἄρα εὑρήσει τι ἐν αὐτῇ· καὶ ἐλθὼν ἐπ᾿ αὐτήν, οὐδὲν εὗρεν εἰ μὴ φύλλα· οὐ γὰρ ἦν καιρὸς σύκων. ");
INSERT INTO grctr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτῇ, Μηκέτι ἐκ σοῦ εἰς τὸν αἰῶνα μηδεὶς καρπὸν φάγοι. Καὶ ἤκουον οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Καὶ ἔρχονται εἰς Ἱεροσόλυμα· καὶ εἰσελθὼν ὁ Ἰησοῦς εἰς τὸ ἱερὸν ἤρξατο ἐκβάλλειν τοὺς πωλοῦντας καὶ ἀγοράζοντας ἐν τῷ ἱερῷ· καὶ τὰς τραπέζας τῶν κολλυβιστῶν, καὶ τὰς καθέδρας τῶν πωλούντων τὰς περιστερὰς κατέστρεψε· ");
INSERT INTO grctr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","καὶ οὐκ ἤφιεν ἵνα τις διενέγκῃ σκεῦος διὰ τοῦ ἱεροῦ. ");
INSERT INTO grctr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Καὶ ἐδίδασκε, λέγων αὐτοῖς, Οὐ γέγραπται ὅτι Ὁ οἶκός μου οἶκος προσευχῆς κληθήσεται πᾶσι τοῖς ἔθνεσιν; Ὑμεῖς δὲ ἐποιήσατε αὐτὸν σπήλαιον λῃστῶν. ");
INSERT INTO grctr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Καὶ ἤκουσαν οἱ γραμματεῖς καὶ οἱ ἀρχιερεῖς, καὶ ἐζήτουν πῶς αὐτὸν ἀπολέσουσιν· ἐφοβοῦντο γὰρ αὐτόν, ὅτι πᾶς ὁ ὄχλος ἐξεπλήσσετο ἐπὶ τῇ διδαχῇ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Καὶ ὅτε ὀψὲ ἐγένετο, ἐξεπορεύετο ἔξω τῆς πόλεως. ");
INSERT INTO grctr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Καὶ πρωῒ παραπορευόμενοι, εἶδον τὴν συκῆν ἐξηραμμένην ἐκ ῥιζῶν. ");
INSERT INTO grctr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Καὶ ἀναμνησθεὶς ὁ Πέτρος λέγει αὐτῷ, Ῥαββί, ἴδε, ἡ συκῆ ἣν κατηράσω ἐξήρανται. ");
INSERT INTO grctr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Καὶ ἀποκριθεὶς Ἰησοῦς λέγει αὐτοῖς, Ἔχετε πίστιν Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ἀμὴν γὰρ λέγω ὑμῖν ὅτι ὃς ἂν εἴπῃ τῷ ὄρει τούτῳ, Ἄρθητι, καὶ βλήθητι εἰς τὴν θάλασσαν, καὶ μὴ διακριθῇ ἐν τῇ καρδίᾳ αὐτοῦ, ἀλλὰ πιστεύσῃ ὅτι ἃ λέγει γίνεται· ἔσται αὐτῷ ὃ ἐὰν εἴπῃ. ");
INSERT INTO grctr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Διὰ τοῦτο λέγω ὑμῖν, Πάντα ὅσα ἂν προσευχόμενοι αἰτεῖσθε, πιστεύετε ὅτι λαμβάνετε, καὶ ἔσται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Καὶ ὅταν στήκητε προσευχόμενοι, ἀφίετε εἴ τι ἔχετε κατά τινος· ἵνα καὶ ὁ πατὴρ ὑμῶν ὁ ἐν τοῖς οὐρανοῖς ἀφῇ ὑμῖν τὰ παραπτώματα ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Εἰ δὲ ὑμεῖς οὐκ ἀφίετε, οὐδὲ ὁ πατὴρ ὑμῶν ὁ ἐν τοῖς οὐρανοῖς ἀφήσει τὰ παραπτώματα ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Καὶ ἔρχονται πάλιν εἰς Ἱεροσόλυμα· καὶ ἐν τῷ ἱερῷ περιπατοῦντος αὐτοῦ, ἔρχονται πρὸς αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς καὶ οἱ πρεσβύτεροι, ");
INSERT INTO grctr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","καὶ λέγουσιν αὐτῷ, Ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς; Καὶ τίς σοι τὴν ἐξουσίαν ταύτην ἔδωκεν ἵνα ταῦτα ποιῇς; ");
INSERT INTO grctr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ὁ δὲ Ἰησοῦς ἀποκριθεὶς εἶπεν αὐτοῖς, Ἐπερωτήσω ὑμᾶς κἀγὼ ἕνα λόγον, καὶ ἀποκρίθητέ μοι, καὶ ἐρῶ ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Τὸ βάπτισμα Ἰωάννου ἐξ οὐρανοῦ ἦν, ἢ ἐξ ἀνθρώπων; Ἀποκρίθητέ μοι. ");
INSERT INTO grctr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Καὶ ἐλογίζοντο πρὸς ἑαυτούς, λέγοντες, Ἐὰν εἴπωμεν, Ἐξ οὐρανοῦ, ἐρεῖ, Διὰ τί οὖν οὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ἀλλ᾿ ἐὰν εἴπωμεν, Ἐξ ἀνθρώπων, ἐφοβοῦντο τὸν λαόν· ἅπαντες γὰρ εἶχον τὸν Ἰωάννην, ὅτι ὄντως προφήτης ἦν. ");
INSERT INTO grctr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Καὶ ἀποκριθέντες λέγουσι τῷ Ἰησοῦ, Οὐκ οἴδαμεν. Καὶ ὁ Ἰησοῦς ἀποκριθεὶς λέγει αὐτοῖς, Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Καὶ ἤρξατο αὐτοῖς ἐν παραβολαῖς λέγειν, Ἀμπελῶνα ἐφύτευσεν ἄνθρωπος, καὶ περιέθηκε φραγμόν, καὶ ὤρυξεν ὑπολήνιον, καὶ ᾠκοδόμησε πύργον, καὶ ἐξέδοτο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησε. ");
INSERT INTO grctr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Καὶ ἀπέστειλε πρὸς τοὺς γεωργοὺς τῷ καιρῷ δοῦλον, ἵνα παρὰ τῶν γεωργῶν λάβῃ ἀπὸ τοῦ καρποῦ τοῦ ἀμπελῶνος. ");
INSERT INTO grctr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Οἱ δὲ λαβόντες αὐτὸν ἔδειραν, καὶ ἀπέστειλαν κενόν. ");
INSERT INTO grctr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Καὶ πάλιν ἀπέστειλε πρὸς αὐτοὺς ἄλλον δοῦλον· κἀκεῖνον λιθοβολήσαντες ἐκεφαλαίωσαν, καὶ ἀπέστειλαν ἠτιμωμένον. ");
INSERT INTO grctr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Καὶ πάλιν ἄλλον ἀπέστειλε· κἀκεῖνον ἀπέκτειναν· καὶ πολλοὺς ἄλλους, τοὺς μὲν δέροντες, τοὺς δὲ ἀποκτείνοντες. ");
INSERT INTO grctr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ἔτι οὖν ἕνα υἱὸν ἔχων ἀγαπητὸν αὐτοῦ, ἀπέστειλε καὶ αὐτὸν πρὸς αὐτοὺς ἔσχατον, λέγων ὅτι Ἐντραπήσονται τὸν υἱόν μου. ");
INSERT INTO grctr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ἐκεῖνοι δὲ οἱ γεωργοὶ εἶπον πρὸς ἑαυτοὺς ὅτι Οὗτός ἐστιν ὁ κληρονόμος· δεῦτε, ἀποκτείνωμεν αὐτόν, καὶ ἡμῶν ἔσται ἡ κληρονομία. ");
INSERT INTO grctr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Καὶ λαβόντες αὐτὸν ἀπέκτειναν, καὶ ἐξέβαλον ἔξω τοῦ ἀμπελῶνος. ");
INSERT INTO grctr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Τί οὖν ποιήσει ὁ κύριος τοῦ ἀμπελῶνος; Ἐλεύσεται καὶ ἀπολέσει τοὺς γεωργούς, καὶ δώσει τὸν ἀμπελῶνα ἄλλοις. ");
INSERT INTO grctr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Οὐδὲ τὴν γραφὴν ταύτην ἀνέγνωτε, Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες, οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας· ");
INSERT INTO grctr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","παρὰ Κυρίου ἐγένετο αὕτη, καὶ ἔστι θαυμαστὴ ἐν ὀφθαλμοῖς ἡμῶν; ");
INSERT INTO grctr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Καὶ ἐζήτουν αὐτὸν κρατῆσαι, καὶ ἐφοβήθησαν τὸν ὄχλον· ἔγνωσαν γὰρ ὅτι πρὸς αὐτοὺς τὴν παραβολὴν εἶπε· καὶ ἀφέντες αὐτὸν ἀπῆλθον. ");
INSERT INTO grctr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Καὶ ἀποστέλλουσι πρὸς αὐτόν τινας τῶν Φαρισαίων καὶ τῶν Ἡρῳδιανῶν, ἵνα αὐτὸν ἀγρεύσωσι λόγῳ. ");
INSERT INTO grctr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Οἱ δὲ ἐλθόντες λέγουσιν αὐτῷ, Διδάσκαλε, οἴδαμεν ὅτι ἀληθὴς εἶ, καὶ οὐ μέλει σοι περὶ οὐδενός· οὐ γὰρ βλέπεις εἰς πρόσωπον ἀνθρώπων, ἀλλ᾿ ἐπ᾿ ἀληθείας τὴν ὁδὸν τοῦ Θεοῦ διδάσκεις. Ἔξεστι κῆνσον Καίσαρι δοῦναι, ἢ οὔ; ");
INSERT INTO grctr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Δῶμεν, ἢ μὴ δῶμεν; Ὁ δὲ εἰδὼς αὐτῶν τὴν ὑπόκρισιν εἶπεν αὐτοῖς, Τί με πειράζετε; Φέρετέ μοι δηνάριον, ἵνα ἴδω. ");
INSERT INTO grctr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Οἱ δὲ ἤνεγκαν. Καὶ λέγει αὐτοῖς, Τίνος ἡ εἰκὼν αὕτη καὶ ἡ ἐπιγραφή; Οἱ δὲ εἶπον αὐτῷ, Καίσαρος. ");
INSERT INTO grctr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Ἀπόδοτε τὰ Καίσαρος Καίσαρι, καὶ τὰ τοῦ Θεοῦ τῷ Θεῷ. Καὶ ἐθαύμασαν ἐπ᾿ αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Καὶ ἔρχονται Σαδδουκαῖοι πρὸς αὐτόν, οἵτινες λέγουσιν ἀνάστασιν μὴ εἶναι· καὶ ἐπηρώτησαν αὐτόν, λέγοντες, ");
INSERT INTO grctr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Διδάσκαλε, Μωσῆς ἔγραψεν ἡμῖν ὅτι Ἐάν τινος ἀδελφὸς ἀποθάνῃ, καὶ καταλίπῃ γυναῖκα, καὶ τέκνα μὴ ἀφῇ, ἵνα λάβῃ ὁ ἀδελφὸς αὐτοῦ τὴν γυναῖκα αὐτοῦ, καὶ ἐξαναστήσῃ σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ἑπτὰ οὖν ἀδελφοὶ ἦσαν· καὶ ὁ πρῶτος ἔλαβε γυναῖκα, καὶ ἀποθνῄσκων οὐκ ἀφῆκε σπέρμα· ");
INSERT INTO grctr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","καὶ ὁ δεύτερος ἔλαβεν αὐτήν, καὶ ἀπέθανε, καὶ οὐδὲ αὐτὸς ἀφῆκε σπέρμα· καὶ ὁ τρίτος ὡσαύτως. ");
INSERT INTO grctr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Καὶ ἔλαβον αὐτὴν οἱ ἑπτά, καὶ οὐκ ἀφῆκαν σπέρμα. Ἐσχάτη πάντων ἀπέθανε καὶ ἡ γυνή. ");
INSERT INTO grctr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ἐν τῇ οὖν ἀναστάσει, ὅταν ἀναστῶσι, τίνος αὐτῶν ἔσται γυνή; Οἱ γὰρ ἑπτὰ ἔσχον αὐτὴν γυναῖκα. ");
INSERT INTO grctr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Οὐ διὰ τοῦτο πλανᾶσθε, μὴ εἰδότες τὰς γραφάς, μηδὲ τὴν δύναμιν τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ὅταν γὰρ ἐκ νεκρῶν ἀναστῶσιν, οὔτε γαμοῦσιν, οὔτε γαμίσκονται, ἀλλ᾿ εἰσὶν ὡς ἄγγελοι οἱ ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Περὶ δὲ τῶν νεκρῶν, ὅτι ἐγείρονται, οὐκ ἀνέγνωτε ἐν τῇ βίβλῳ Μωσέως, ἐπὶ τῆς βάτου, ὡς εἶπεν αὐτῷ ὁ Θεός, λέγων, Ἐγὼ ὁ Θεὸς Ἀβραάμ, καὶ ὁ Θεὸς Ἰσαάκ, καὶ ὁ Θεὸς Ἰακώβ; ");
INSERT INTO grctr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Οὐκ ἔστιν ὁ Θεὸς νεκρῶν, ἀλλὰ Θεὸς ζώντων· ὑμεῖς οὖν πολὺ πλανᾶσθε. ");
INSERT INTO grctr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Καὶ προσελθὼν εἷς τῶν γραμματέων, ἀκούσας αὐτῶν συζητούντων, εἰδὼς ὅτι καλῶς αὐτοῖς ἀπεκρίθη, ἐπηρώτησεν αὐτόν, Ποία ἐστὶ πρώτη πασῶν ἐντολή; ");
INSERT INTO grctr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ὁ δὲ Ἰησοῦς ἀπεκρίθη αὐτῷ ὅτι Πρώτη πασῶν τῶν ἐντολῶν, Ἄκουε, Ἰσραήλ· Κύριος ὁ Θεὸς ἡμῶν, Κύριος εἷς ἐστί· ");
INSERT INTO grctr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","καὶ ἀγαπήσεις Κύριον τὸν Θεόν σου ἐξ ὅλης τῆς καρδίας σου, καὶ ἐξ ὅλης τῆς ψυχῆς σου, καὶ ἐξ ὅλης τῆς διανοίας σου, καὶ ἐξ ὅλης τῆς ἰσχύος σου. Αὕτη πρώτη ἐντολή. ");
INSERT INTO grctr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Καὶ δευτέρα ὁμοία αὕτη, Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. Μείζων τούτων ἄλλη ἐντολὴ οὐκ ἔστι. ");
INSERT INTO grctr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Καὶ εἶπεν αὐτῷ ὁ γραμματεύς, Καλῶς, διδάσκαλε, ἐπ᾿ ἀληθείας εἶπας ὅτι εἷς ἐστι Θεός, καὶ οὐκ ἔστιν ἄλλος πλὴν αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","καὶ τὸ ἀγαπᾷν αὐτὸν ἐξ ὅλης τῆς καρδίας, καὶ ἐξ ὅλης τῆς συνέσεως, καὶ ἐξ ὅλης τῆς ψυχῆς, καὶ ἐξ ὅλης τῆς ἰσχύος, καὶ τὸ ἀγαπᾷν τὸν πλησίον ὡς ἑαυτόν, πλεῖόν ἐστι πάντων τῶν ὁλοκαυτωμάτων καὶ τῶν θυσιῶν. ");
INSERT INTO grctr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Καὶ ὁ Ἰησοῦς ἰδὼν αὐτὸν ὅτι νουνεχῶς ἀπεκρίθη, εἶπεν αὐτῷ, Οὐ μακρὰν εἶ ἀπὸ τῆς βασιλείας τοῦ Θεοῦ. Καὶ οὐδεὶς οὐκέτι ἐτόλμα αὐτὸν ἐπερωτῆσαι. ");
INSERT INTO grctr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς ἔλεγε, διδάσκων ἐν τῷ ἱερῷ, Πῶς λέγουσιν οἱ γραμματεῖς ὅτι ὁ Χριστὸς υἱός ἐστι Δαβίδ; ");
INSERT INTO grctr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Αὐτὸς γὰρ Δαβὶδ εἶπεν ἐν τῷ πνεύματι τῷ ἁγίῳ, Εἶπεν ὁ Κύριος τῷ Κυρίῳ μου, Κάθου ἐκ δεξιῶν μου, ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου. ");
INSERT INTO grctr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Αὐτὸς οὖν Δαβὶδ λέγει αὐτὸν Κύριον· καὶ πόθεν υἱὸς αὐτοῦ ἐστι; Καὶ ὁ πολὺς ὄχλος ἤκουεν αὐτοῦ ἡδέως. ");
INSERT INTO grctr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Καὶ ἔλεγεν αὐτοῖς ἐν τῇ διδαχῇ αὐτοῦ, Βλέπετε ἀπὸ τῶν γραμματέων, τῶν θελόντων ἐν στολαῖς περιπατεῖν, καὶ ἀσπασμοὺς ἐν ταῖς ἀγοραῖς, ");
INSERT INTO grctr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","καὶ πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς, καὶ πρωτοκλισίας ἐν τοῖς δείπνοις· ");
INSERT INTO grctr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","οἱ κατεσθίοντες τὰς οἰκίας τῶν χηρῶν, καὶ προφάσει μακρὰ προσευχόμενοι· οὗτοι λήψονται περισσότερον κρίμα. ");
INSERT INTO grctr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Καὶ καθίσας ὁ Ἰησοῦς κατέναντι τοῦ γαζοφυλακίου ἐθεώρει πῶς ὁ ὄχλος βάλλει χαλκὸν εἰς τὸ γαζοφυλάκιον· καὶ πολλοὶ πλούσιοι ἔβαλλον πολλά. ");
INSERT INTO grctr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Καὶ ἐλθοῦσα μία χήρα πτωχὴ ἔβαλε λεπτὰ δύο, ὅ ἐστι κοδράντης. ");
INSERT INTO grctr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Καὶ προσκαλεσάμενος τοὺς μαθητὰς αὐτοῦ, λέγει αὐτοῖς, Ἀμὴν λέγω ὑμῖν ὅτι ἡ χήρα αὕτη ἡ πτωχὴ πλεῖον πάντων βέβληκε τῶν βαλόντων εἰς τὸ γαζοφυλάκιον· ");
INSERT INTO grctr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","πάντες γὰρ ἐκ τοῦ περισσεύοντος αὐτοῖς ἔβαλον· αὕτη δὲ ἐκ τῆς ὑστερήσεως αὐτῆς πάντα ὅσα εἶχεν ἔβαλεν, ὅλον τὸν βίον αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Καὶ ἐκπορευομένου αὐτοῦ ἐκ τοῦ ἱεροῦ, λέγει αὐτῷ εἷς τῶν μαθητῶν αὐτοῦ, Διδάσκαλε, ἴδε, ποταποὶ λίθοι καὶ ποταπαὶ οἰκοδομαί. ");
INSERT INTO grctr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Καὶ ὁ Ἰησοῦς ἀποκριθεὶς εἶπεν αὐτῷ, Βλέπεις ταύτας τὰς μεγάλας οἰκοδομάς; Οὐ μὴ ἀφεθῇ λίθος ἐπὶ λίθῳ, ὃς οὐ μὴ καταλυθῇ. ");
INSERT INTO grctr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Καὶ καθημένου αὐτοῦ εἰς τὸ ὄρος τῶν Ἐλαιῶν κατέναντι τοῦ ἱεροῦ, ἐπηρώτων αὐτὸν κατ᾿ ἰδίαν Πέτρος καὶ Ἰάκωβος καὶ Ἰωάννης καὶ Ἀνδρέας, ");
INSERT INTO grctr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Εἰπὲ ἡμῖν, πότε ταῦτα ἔσται; Καὶ τί τὸ σημεῖον ὅταν μέλλῃ πάντα ταῦτα συντελεῖσθαι; ");
INSERT INTO grctr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ὁ δὲ Ἰησοῦς ἀποκριθεὶς αὐτοῖς ἤρξατο λέγειν, Βλέπετε μή τις ὑμᾶς πλανήσῃ. ");
INSERT INTO grctr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Πολλοὶ γὰρ ἐλεύσονται ἐπὶ τῷ ὀνόματί μου, λέγοντες ὅτι Ἐγώ εἰμι· καὶ πολλοὺς πλανήσουσιν. ");
INSERT INTO grctr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ὅταν δὲ ἀκούσητε πολέμους καὶ ἀκοὰς πολέμων, μὴ θροεῖσθε· δεῖ γὰρ γενέσθαι, ἀλλ᾿ οὔπω τὸ τέλος. ");
INSERT INTO grctr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ἐγερθήσεται γὰρ ἔθνος ἐπὶ ἔθνος, καὶ βασιλεία ἐπὶ βασιλείαν· καὶ ἔσονται σεισμοὶ κατὰ τόπους, καὶ ἔσονται λιμοὶ καὶ ταραχαί· ἀρχαὶ ὠδίνων ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Βλέπετε δὲ ὑμεῖς ἑαυτούς· παραδώσουσι γὰρ ὑμᾶς εἰς συνέδρια, καὶ εἰς συναγωγὰς δαρήσεσθε, καὶ ἐπὶ ἡγεμόνων καὶ βασιλέων σταθήσεσθε ἕνεκεν ἐμοῦ, εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Καὶ εἰς πάντα τὰ ἔθνη δεῖ πρῶτον κηρυχθῆναι τὸ εὐαγγέλιον. ");
INSERT INTO grctr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ὅταν δὲ ἀγάγωσιν ὑμᾶς παραδιδόντες, μὴ προμεριμνᾶτε τί λαλήσητε, μηδὲ μελετᾶτε· ἀλλ᾿ ὃ ἐὰν δοθῇ ὑμῖν ἐν ἐκείνῃ τῇ ὥρᾳ, τοῦτο λαλεῖτε· οὐ γάρ ἐστε ὑμεῖς οἱ λαλοῦντες, ἀλλὰ τὸ πνεῦμα τὸ ἅγιον. ");
INSERT INTO grctr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Παραδώσει δὲ ἀδελφὸς ἀδελφὸν εἰς θάνατον, καὶ πατὴρ τέκνον· καὶ ἐπαναστήσονται τέκνα ἐπὶ γονεῖς, καὶ θανατώσουσιν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου· ὁ δὲ ὑπομείνας εἰς τέλος, οὗτος σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ὅταν δὲ ἴδητε τὸ βδέλυγμα τῆς ἐρημώσεως, τὸ ῥηθὲν ὑπὸ Δανιὴλ τοῦ προφήτου, ἑστὼς ὅπου οὐ δεῖ — ὁ ἀναγινώσκων νοείτω — τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν εἰς τὰ ὄρη· ");
INSERT INTO grctr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ὁ δὲ ἐπὶ τοῦ δώματος μὴ καταβάτω εἰς τὴν οἰκίαν, μηδὲ εἰσελθέτω ἆραί τι ἐκ τῆς οἰκίας αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","καὶ ὁ εἰς τὸν ἀγρὸν ὢν μὴ ἐπιστρεψάτω εἰς τὰ ὀπίσω, ἆραι τὸ ἱμάτιον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Οὐαὶ δὲ ταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grctr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Προσεύχεσθε δὲ ἵνα μὴ γένηται ἡ φυγὴ ὑμῶν χειμῶνος. ");
INSERT INTO grctr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ἔσονται γὰρ αἱ ἡμέραι ἐκεῖναι θλίψις, οἵα οὐ γέγονε τοιαύτη ἀπ᾿ ἀρχῆς κτίσεως ἧς ἔκτισεν ὁ Θεὸς ἕως τοῦ νῦν, καὶ οὐ μὴ γένηται. ");
INSERT INTO grctr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Καὶ εἰ μὴ Κύριος ἐκολόβωσε τὰς ἡμέρας, οὐκ ἂν ἐσώθη πᾶσα σάρξ· ἀλλὰ διὰ τοὺς ἐκλεκτούς, οὓς ἐξελέξατο, ἐκολόβωσε τὰς ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Καὶ τότε ἐάν τις ὑμῖν εἴπῃ, Ἰδού, ὧδε ὁ Χριστός, ἢ Ἰδού, ἐκεῖ, μὴ πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ἐγερθήσονται γὰρ ψευδόχριστοι καὶ ψευδοπροφῆται, καὶ δώσουσι σημεῖα καὶ τέρατα, πρὸς τὸ ἀποπλανᾷν, εἰ δυνατόν, καὶ τοὺς ἐκλεκτούς. ");
INSERT INTO grctr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ὑμεῖς δὲ βλέπετε· ἰδού, προείρηκα ὑμῖν πάντα. ");
INSERT INTO grctr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ἀλλ᾿ ἐν ἐκείναις ταῖς ἡμέραις, μετὰ τὴν θλίψιν ἐκείνην, ὁ ἥλιος σκοτισθήσεται, καὶ ἡ σελήνη οὐ δώσει τὸ φέγγος αὐτῆς, ");
INSERT INTO grctr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","καὶ οἱ ἀστέρες τοῦ οὐρανοῦ ἔσονται ἐκπίπτοντες, καὶ αἱ δυνάμεις αἱ ἐν τοῖς οὐρανοῖς σαλευθήσονται. ");
INSERT INTO grctr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Καὶ τότε ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν νεφέλαις μετὰ δυνάμεως πολλῆς καὶ δόξης. ");
INSERT INTO grctr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Καὶ τότε ἀποστελεῖ τοὺς ἀγγέλους αὐτοῦ, καὶ ἐπισυνάξει τοὺς ἐκλεκτοὺς αὐτοῦ ἐκ τῶν τεσσάρων ἀνέμων, ἀπ᾿ ἄκρου γῆς ἕως ἄκρου οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ἀπὸ δὲ τῆς συκῆς μάθετε τὴν παραβολήν· ὅταν αὐτῆς ἤδη ὁ κλάδος ἁπαλὸς γένηται, καὶ ἐκφύῃ τὰ φύλλα, γινώσκετε ὅτι ἐγγὺς τὸ θέρος ἐστίν· ");
INSERT INTO grctr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","οὕτω καὶ ὑμεῖς, ὅταν ταῦτα ἴδητε γινόμενα, γινώσκετε ὅτι ἐγγύς ἐστιν ἐπὶ θύραις. ");
INSERT INTO grctr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ἀμὴν λέγω ὑμῖν ὅτι οὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη, μέχρις οὗ πάντα ταῦτα γένηται. ");
INSERT INTO grctr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ὁ οὐρανὸς καὶ ἡ γῆ παρελεύσονται, οἱ δὲ λόγοι μου οὐ μὴ παρέλθωσι. ");
INSERT INTO grctr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Περὶ δὲ τῆς ἡμέρας ἐκείνης καὶ τῆς ὥρας οὐδεὶς οἶδεν, οὐδὲ οἱ ἄγγελοι οἱ ἐν οὐρανῷ, οὐδὲ ὁ υἱός, εἰ μὴ ὁ πατήρ. ");
INSERT INTO grctr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Βλέπετε, ἀγρυπνεῖτε καὶ προσεύχεσθε· οὐκ οἴδατε γὰρ πότε ὁ καιρός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ὡς ἄνθρωπος ἀπόδημος ἀφεὶς τὴν οἰκίαν αὐτοῦ, καὶ δοὺς τοῖς δούλοις αὐτοῦ τὴν ἐξουσίαν, καὶ ἑκάστῳ τὸ ἔργον αὐτοῦ, καὶ τῷ θυρωρῷ ἐνετείλατο ἵνα γρηγορῇ. ");
INSERT INTO grctr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Γρηγορεῖτε οὖν· οὐκ οἴδατε γὰρ πότε ὁ κύριος τῆς οἰκίας ἔρχεται, ὀψέ, ἢ μεσονυκτίου, ἢ ἀλεκτοροφωνίας, ἢ πρωΐ· ");
INSERT INTO grctr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","μὴ ἐλθὼν ἐξαίφνης εὕρῃ ὑμᾶς καθεύδοντας. ");
INSERT INTO grctr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ἃ δὲ ὑμῖν λέγω πᾶσι λέγω, Γρηγορεῖτε. ");
INSERT INTO grctr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ἦν δὲ τὸ Πάσχα καὶ τὰ ἄζυμα μετὰ δύο ἡμέρας· καὶ ἐζήτουν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς πῶς αὐτὸν ἐν δόλῳ κρατήσαντες ἀποκτείνωσιν. ");
INSERT INTO grctr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ἔλεγον δέ, Μὴ ἐν τῇ ἑορτῇ, μήποτε θόρυβος ἔσται τοῦ λαοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Καὶ ὄντος αὐτοῦ ἐν Βηθανίᾳ, ἐν τῇ οἰκίᾳ Σίμωνος τοῦ λεπροῦ, κατακειμένου αὐτοῦ, ἦλθε γυνὴ ἔχουσα ἀλάβαστρον μύρου νάρδου πιστικῆς πολυτελοῦς· καὶ συντρίψασα τὸ ἀλάβαστρον, κατέχεεν αὐτοῦ κατὰ τῆς κεφαλῆς. ");
INSERT INTO grctr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ἦσαν δέ τινες ἀγανακτοῦντες πρὸς ἑαυτούς, καὶ λέγοντες, Εἰς τί ἡ ἀπώλεια αὕτη τοῦ μύρου γέγονεν; ");
INSERT INTO grctr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ἠδύνατο γὰρ τοῦτο πραθῆναι ἐπάνω τριακοσίων δηναρίων, καὶ δοθῆναι τοῖς πτωχοῖς. Καὶ ἐνεβριμῶντο αὐτῇ. ");
INSERT INTO grctr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ὁ δὲ Ἰησοῦς εἶπεν, Ἄφετε αὐτήν· τί αὐτῇ κόπους παρέχετε; Καλὸν ἔργον εἰργάσατο εἰς ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Πάντοτε γὰρ τοὺς πτωχοὺς ἔχετε μεθ᾿ ἑαυτῶν, καὶ ὅταν θέλητε δύνασθε αὐτοὺς εὖ ποιῆσαι· ἐμὲ δὲ οὐ πάντοτε ἔχετε. ");
INSERT INTO grctr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ὃ εἶχεν αὕτη ἐποίησε· προέλαβε μυρίσαι μου τὸ σῶμα εἰς τὸν ἐνταφιασμόν. ");
INSERT INTO grctr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ἀμὴν λέγω ὑμῖν, ὅπου ἂν κηρυχθῇ τὸ εὐαγγέλιον τοῦτο εἰς ὅλον τὸν κόσμον, καὶ ὃ ἐποίησεν αὕτη λαληθήσεται εἰς μνημόσυνον αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Καὶ ὁ Ἰούδας ὁ Ἰσκαριώτης, εἷς τῶν δώδεκα, ἀπῆλθε πρὸς τοὺς ἀρχιερεῖς, ἵνα παραδῷ αὐτὸν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Οἱ δὲ ἀκούσαντες ἐχάρησαν, καὶ ἐπηγγείλαντο αὐτῷ ἀργύριον δοῦναι, καὶ ἐζήτει πῶς εὐκαίρως αὐτὸν παραδῷ. ");
INSERT INTO grctr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Καὶ τῇ πρώτῃ ἡμέρᾳ τῶν ἀζύμων, ὅτε τὸ Πάσχα ἔθυον, λέγουσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ, Ποῦ θέλεις ἀπελθόντες ἑτοιμάσωμεν ἵνα φάγῃς τὸ Πάσχα; ");
INSERT INTO grctr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Καὶ ἀποστέλλει δύο τῶν μαθητῶν αὐτοῦ, καὶ λέγει αὐτοῖς, Ὑπάγετε εἰς τὴν πόλιν, καὶ ἀπαντήσει ὑμῖν ἄνθρωπος κεράμιον ὕδατος βαστάζων· ἀκολουθήσατε αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","καὶ ὅπου ἐὰν εἰσέλθῃ, εἴπατε τῷ οἰκοδεσπότῃ ὅτι Ὁ διδάσκαλος λέγει, Ποῦ ἐστι τὸ κατάλυμα, ὅπου τὸ Πάσχα μετὰ τῶν μαθητῶν μου φάγω; ");
INSERT INTO grctr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Καὶ αὐτὸς ὑμῖν δείξει ἀνώγεον μέγα ἐστρωμένον ἕτοιμον· ἐκεῖ ἑτοιμάσατε ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Καὶ ἐξῆλθον οἱ μαθηταὶ αὐτοῦ, καὶ ἦλθον εἰς τὴν πόλιν, καὶ εὗρον καθὼς εἶπεν αὐτοῖς, καὶ ἡτοίμασαν τὸ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Καὶ ὀψίας γενομένης ἔρχεται μετὰ τῶν δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Καὶ ἀνακειμένων αὐτῶν καὶ ἐσθιόντων, εἶπεν ὁ Ἰησοῦς, Ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με, ὁ ἐσθίων μετ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Οἱ δὲ ἤρξαντο λυπεῖσθαι, καὶ λέγειν αὐτῷ εἷς καθ᾿ εἷς, Μήτι ἐγώ; Καὶ ἄλλος, Μήτι ἐγώ; ");
INSERT INTO grctr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς, Εἷς ἐκ τῶν δώδεκα, ὁ ἐμβαπτόμενος μετ᾿ ἐμοῦ εἰς τὸ τρυβλίον. ");
INSERT INTO grctr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ὁ μὲν υἱὸς τοῦ ἀνθρώπου ὑπάγει, καθὼς γέγραπται περὶ αὐτοῦ· οὐαὶ δὲ τῷ ἀνθρώπῳ ἐκείνῳ δι᾿ οὗ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται· καλὸν ἦν αὐτῷ εἰ οὐκ ἐγεννήθη ὁ ἄνθρωπος ἐκεῖνος. ");
INSERT INTO grctr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Καὶ ἐσθιόντων αὐτῶν, λαβὼν ὁ Ἰησοῦς ἄρτον, εὐλογήσας ἔκλασε καὶ ἔδωκεν αὐτοῖς, καὶ εἶπε, Λάβετε, φάγετε· τοῦτό ἐστι τὸ σῶμά μου. ");
INSERT INTO grctr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Καὶ λαβὼν τὸ ποτήριον, εὐχαριστήσας ἔδωκεν αὐτοῖς, καὶ ἔπιον ἐξ αὐτοῦ πάντες. ");
INSERT INTO grctr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Καὶ εἶπεν αὐτοῖς, Τοῦτό ἐστι τὸ αἷμά μου, τὸ τῆς καινῆς διαθήκης, τὸ περὶ πολλῶν ἐκχυνόμενον. ");
INSERT INTO grctr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ἀμὴν λέγω ὑμῖν ὅτι οὐκέτι οὐ μὴ πίω ἐκ τοῦ γεννήματος τῆς ἀμπέλου, ἕως τῆς ἡμέρας ἐκείνης ὅταν αὐτὸ πίνω καινὸν ἐν τῇ βασιλείᾳ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Καὶ ὑμνήσαντες ἐξῆλθον εἰς τὸ ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grctr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Καὶ λέγει αὐτοῖς ὁ Ἰησοῦς ὅτι Πάντες σκανδαλισθήσεσθε ἐν ἐμοὶ ἐν τῇ νυκτὶ ταύτῃ· ὅτι γέγραπται, Πατάξω τὸν ποιμένα, καὶ διασκορπισθήσεται τὰ πρόβατα. ");
INSERT INTO grctr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ἀλλὰ μετὰ τὸ ἐγερθῆναί με, προάξω ὑμᾶς εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grctr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ὁ δὲ Πέτρος ἔφη αὐτῷ, Καὶ εἰ πάντες σκανδαλισθήσονται, ἀλλ᾿ οὐκ ἐγώ. ");
INSERT INTO grctr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Καὶ λέγει αὐτῷ ὁ Ἰησοῦς, Ἀμὴν λέγω σοι ὅτι σήμερον ἐν τῇ νυκτὶ ταύτῃ, πρὶν ἢ δὶς ἀλέκτορα φωνῆσαι, τρὶς ἀπαρνήσῃ με. ");
INSERT INTO grctr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ὁ δὲ ἐκπερισσοῦ ἔλεγε μᾶλλον, Ἐάν με δέῃ συναποθανεῖν σοι, οὐ μή σε ἀπαρνήσομαι. Ὡσαύτως δὲ καὶ πάντες ἔλεγον. ");
INSERT INTO grctr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Καὶ ἔρχονται εἰς χωρίον οὗ τὸ ὄνομα Γεθσημανῆ, καὶ λέγει τοῖς μαθηταῖς αὐτοῦ, Καθίσατε ὧδε, ἕως προσεύξωμαι. ");
INSERT INTO grctr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Καὶ παραλαμβάνει τὸν Πέτρον καὶ τὸν Ἰάκωβον καὶ Ἰωάννην μεθ᾿ ἑαυτοῦ, καὶ ἤρξατο ἐκθαμβεῖσθαι καὶ ἀδημονεῖν. ");
INSERT INTO grctr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Καὶ λέγει αὐτοῖς, Περίλυπός ἐστιν ἡ ψυχή μου ἕως θανάτου· μείνατε ὧδε καὶ γρηγορεῖτε. ");
INSERT INTO grctr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Καὶ προελθὼν μικρόν, ἔπεσεν ἐπὶ τῆς γῆς, καὶ προσηύχετο ἵνα, εἰ δυνατόν ἐστι, παρέλθῃ ἀπ᾿ αὐτοῦ ἡ ὥρα. ");
INSERT INTO grctr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Καὶ ἔλεγεν, Ἀββᾶ, ὁ πατήρ, πάντα δυνατά σοι. Παρένεγκε τὸ ποτήριον ἀπ᾿ ἐμοῦ τοῦτο· ἀλλ᾿ οὐ τί ἐγὼ θέλω, ἀλλὰ τί σύ. ");
INSERT INTO grctr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Καὶ ἔρχεται καὶ εὑρίσκει αὐτοὺς καθεύδοντας, καὶ λέγει τῷ Πέτρῳ, Σίμων, καθεύδεις; Οὐκ ἴσχυσας μίαν ὥραν γρηγορῆσαι; ");
INSERT INTO grctr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Γρηγορεῖτε καὶ προσεύχεσθε, ἵνα μὴ εἰσέλθητε εἰς πειρασμόν. Τὸ μὲν πνεῦμα πρόθυμον, ἡ δὲ σὰρξ ἀσθενής. ");
INSERT INTO grctr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Καὶ πάλιν ἀπελθὼν προσηύξατο, τὸν αὐτὸν λόγον εἰπών. ");
INSERT INTO grctr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Καὶ ὑποστρέψας εὗρεν αὐτοὺς πάλιν καθεύδοντας· ἦσαν γὰρ οἱ ὀφθαλμοὶ αὐτῶν βεβαρημένοι, καὶ οὐκ ᾔδεισαν τί αὐτῷ ἀποκριθῶσι. ");
INSERT INTO grctr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Καὶ ἔρχεται τὸ τρίτον, καὶ λέγει αὐτοῖς, Καθεύδετε τὸ λοιπὸν καὶ ἀναπαύεσθε. Ἀπέχει· ἦλθεν ἡ ὥρα. Ἰδού, παραδίδοται ὁ υἱὸς τοῦ ἀνθρώπου εἰς τὰς χεῖρας τῶν ἁμαρτωλῶν. ");
INSERT INTO grctr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ἐγείρεσθε, ἄγωμεν. Ἰδού, ὁ παραδιδούς με ἤγγικε. ");
INSERT INTO grctr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Καὶ εὐθέως, ἔτι αὐτοῦ λαλοῦντος, παραγίνεται Ἰούδας, εἷς ὢν τῶν δώδεκα, καὶ μετ᾿ αὐτοῦ ὄχλος πολὺς μετὰ μαχαιρῶν καὶ ξύλων, παρὰ τῶν ἀρχιερέων καὶ τῶν γραμματέων καὶ τῶν πρεσβυτέρων. ");
INSERT INTO grctr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Δεδώκει δὲ ὁ παραδιδοὺς αὐτὸν σύσσημον αὐτοῖς, λέγων, Ὃν ἂν φιλήσω, αὐτός ἐστι· κρατήσατε αὐτόν, καὶ ἀπαγάγετε ἀσφαλῶς. ");
INSERT INTO grctr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Καὶ ἐλθών, εὐθέως προσελθὼν αὐτῷ λέγει, Ῥαββί, ῥαββί· καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Οἱ δὲ ἐπέβαλον ἐπ᾿ αὐτὸν τὰς χεῖρας αὐτῶν, καὶ ἐκράτησαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Εἷς δέ τις τῶν παρεστηκότων σπασάμενος τὴν μάχαιραν ἔπαισε τὸν δοῦλον τοῦ ἀρχιερέως, καὶ ἀφεῖλεν αὐτοῦ τὸ ὠτίον. ");
INSERT INTO grctr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Ὡς ἐπὶ λῃστὴν ἐξήλθετε μετὰ μαχαιρῶν καὶ ξύλων συλλαβεῖν με; ");
INSERT INTO grctr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Καθ᾿ ἡμέραν ἤμην πρὸς ὑμᾶς ἐν τῷ ἱερῷ διδάσκων, καὶ οὐκ ἐκρατήσατέ με· ἀλλ᾿ ἵνα πληρωθῶσιν αἱ γραφαί. ");
INSERT INTO grctr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Καὶ ἀφέντες αὐτὸν πάντες ἔφυγον. ");
INSERT INTO grctr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Καὶ εἷς τις νεανίσκος ἠκολούθει αὐτῷ, περιβεβλημένος σινδόνα ἐπὶ γυμνοῦ. Καὶ κρατοῦσιν αὐτὸν οἱ νεανίσκοι· ");
INSERT INTO grctr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ὁ δὲ καταλιπὼν τὴν σινδόνα γυμνὸς ἔφυγεν ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Καὶ ἀπήγαγον τὸν Ἰησοῦν πρὸς τὸν ἀρχιερέα· καὶ συνέρχονται αὐτῷ πάντες οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι καὶ οἱ γραμματεῖς. ");
INSERT INTO grctr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Καὶ ὁ Πέτρος ἀπὸ μακρόθεν ἠκολούθησεν αὐτῷ ἕως ἔσω εἰς τὴν αὐλὴν τοῦ ἀρχιερέως· καὶ ἦν συγκαθήμενος μετὰ τῶν ὑπηρετῶν, καὶ θερμαινόμενος πρὸς τὸ φῶς. ");
INSERT INTO grctr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Οἱ δὲ ἀρχιερεῖς καὶ ὅλον τὸ συνέδριον ἐζήτουν κατὰ τοῦ Ἰησοῦ μαρτυρίαν, εἰς τὸ θανατῶσαι αὐτόν, καὶ οὐχ εὕρισκον. ");
INSERT INTO grctr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Πολλοὶ γὰρ ἐψευδομαρτύρουν κατ᾿ αὐτοῦ, καὶ ἴσαι αἱ μαρτυρίαι οὐκ ἦσαν. ");
INSERT INTO grctr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Καί τινες ἀναστάντες ἐψευδομαρτύρουν κατ᾿ αὐτοῦ, λέγοντες ");
INSERT INTO grctr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ὅτι Ἡμεῖς ἠκούσαμεν αὐτοῦ λέγοντος ὅτι Ἐγὼ καταλύσω τὸν ναὸν τοῦτον τὸν χειροποίητον, καὶ διὰ τριῶν ἡμερῶν ἄλλον ἀχειροποίητον οἰκοδομήσω. ");
INSERT INTO grctr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Καὶ οὐδὲ οὕτως ἴση ἦν ἡ μαρτυρία αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Καὶ ἀναστὰς ὁ ἀρχιερεὺς εἰς τὸ μέσον ἐπηρώτησε τὸν Ἰησοῦν, λέγων, Οὐκ ἀποκρίνῃ οὐδέν; Τί οὗτοί σου καταμαρτυροῦσιν; ");
INSERT INTO grctr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ὁ δὲ ἐσιώπα, καὶ οὐδὲν ἀπεκρίνατο. Πάλιν ὁ ἀρχιερεὺς ἐπηρώτα αὐτόν, καὶ λέγει αὐτῷ, Σὺ εἶ ὁ Χριστός, ὁ υἱὸς τοῦ εὐλογητοῦ; ");
INSERT INTO grctr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ὁ δὲ Ἰησοῦς εἶπεν, Ἐγώ εἰμι. Καὶ ὄψεσθε τὸν υἱὸν τοῦ ἀνθρώπου καθήμενον ἐκ δεξιῶν τῆς δυνάμεως, καὶ ἐρχόμενον μετὰ τῶν νεφελῶν τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ὁ δὲ ἀρχιερεὺς διαρρήξας τοὺς χιτῶνας αὐτοῦ λέγει, Τί ἔτι χρείαν ἔχομεν μαρτύρων; ");
INSERT INTO grctr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ἠκούσατε τῆς βλασφημίας. Τί ὑμῖν φαίνεται; Οἱ δὲ πάντες κατέκριναν αὐτὸν εἶναι ἔνοχον θανάτου. ");
INSERT INTO grctr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Καὶ ἤρξαντό τινες ἐμπτύειν αὐτῷ, καὶ περικαλύπτειν τὸ πρόσωπον αὐτοῦ, καὶ κολαφίζειν αὐτόν, καὶ λέγειν αὐτῷ, Προφήτευσον. Καὶ οἱ ὑπηρέται ῥαπίσμασιν αὐτὸν ἔβαλλον. ");
INSERT INTO grctr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Καὶ ὄντος τοῦ Πέτρου ἐν τῇ αὐλῇ κάτω, ἔρχεται μία τῶν παιδισκῶν τοῦ ἀρχιερέως, ");
INSERT INTO grctr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","καὶ ἰδοῦσα τὸν Πέτρον θερμαινόμενον, ἐμβλέψασα αὐτῷ λέγει, Καὶ σὺ μετὰ τοῦ Ναζαρηνοῦ Ἰησοῦ ἦσθα. ");
INSERT INTO grctr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ὁ δὲ ἠρνήσατο, λέγων, Οὐκ οἶδα, οὐδὲ ἐπίσταμαι τί σὺ λέγεις. Καὶ ἐξῆλθεν ἔξω εἰς τὸ προαύλιον· καὶ ἀλέκτωρ ἐφώνησε. ");
INSERT INTO grctr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Καὶ ἡ παιδίσκη ἰδοῦσα αὐτὸν πάλιν ἤρξατο λέγειν τοῖς παρεστηκόσιν ὅτι Οὗτος ἐξ αὐτῶν ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ὁ δὲ πάλιν ἠρνεῖτο. Καὶ μετὰ μικρὸν πάλιν οἱ παρεστῶτες ἔλεγον τῷ Πέτρῳ, Ἀληθῶς ἐξ αὐτῶν εἶ· καὶ γὰρ Γαλιλαῖος εἶ, καὶ ἡ λαλιά σου ὁμοιάζει. ");
INSERT INTO grctr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ὁ δὲ ἤρξατο ἀναθεματίζειν καὶ ὀμνύειν ὅτι Οὐκ οἶδα τὸν ἄνθρωπον τοῦτον ὃν λέγετε. ");
INSERT INTO grctr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Καὶ ἐκ δευτέρου ἀλέκτωρ ἐφώνησε. Καὶ ἀνεμνήσθη ὁ Πέτρος τοῦ ῥήματος οὗ εἶπεν αὐτῷ ὁ Ἰησοῦς ὅτι Πρὶν ἀλέκτορα φωνῆσαι δίς, ἀπαρνήσῃ με τρίς. Καὶ ἐπιβαλὼν ἔκλαιε. ");
INSERT INTO grctr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Καὶ εὐθέως ἐπὶ τὸ πρωῒ συμβούλιον ποιήσαντες οἱ ἀρχιερεῖς μετὰ τῶν πρεσβυτέρων καὶ γραμματέων, καὶ ὅλον τὸ συνέδριον, δήσαντες τὸν Ἰησοῦν ἀπήνεγκαν καὶ παρέδωκαν τῷ Πιλάτῳ. ");
INSERT INTO grctr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Καὶ ἐπηρώτησεν αὐτὸν ὁ Πιλάτος, Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; Ὁ δὲ ἀποκριθεὶς εἶπεν αὐτῷ, Σὺ λέγεις. ");
INSERT INTO grctr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Καὶ κατηγόρουν αὐτοῦ οἱ ἀρχιερεῖς πολλά· ");
INSERT INTO grctr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ὁ δὲ Πιλάτος πάλιν ἐπηρώτησεν αὐτόν, λέγων, Οὐκ ἀποκρίνῃ οὐδέν; Ἴδε, πόσα σου καταμαρτυροῦσιν. ");
INSERT INTO grctr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ὁ δὲ Ἰησοῦς οὐκέτι οὐδὲν ἀπεκρίθη, ὥστε θαυμάζειν τὸν Πιλάτον. ");
INSERT INTO grctr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Κατὰ δὲ ἑορτὴν ἀπέλυεν αὐτοῖς ἕνα δέσμιον, ὅνπερ ᾐτοῦντο. ");
INSERT INTO grctr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ἦν δὲ ὁ λεγόμενος Βαραββᾶς μετὰ τῶν συστασιαστῶν δεδεμένος, οἵτινες ἐν τῇ στάσει φόνον πεποιήκεισαν. ");
INSERT INTO grctr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Καὶ ἀναβοήσας ὁ ὄχλος ἤρξατο αἰτεῖσθαι καθὼς ἀεὶ ἐποίει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ὁ δὲ Πιλάτος ἀπεκρίθη αὐτοῖς, λέγων, Θέλετε ἀπολύσω ὑμῖν τὸν βασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grctr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ἐγίνωσκε γὰρ ὅτι διὰ φθόνον παραδεδώκεισαν αὐτὸν οἱ ἀρχιερεῖς. ");
INSERT INTO grctr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Οἱ δὲ ἀρχιερεῖς ἀνέσεισαν τὸν ὄχλον ἵνα μᾶλλον τὸν Βαραββᾶν ἀπολύσῃ αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ὁ δὲ Πιλάτος ἀποκριθεὶς πάλιν εἶπεν αὐτοῖς, Τί οὖν θέλετε ποιήσω ὃν λέγετε βασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grctr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Οἱ δὲ πάλιν ἔκραξαν, Σταύρωσον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ὁ δὲ Πιλάτος ἔλεγεν αὐτοῖς, Τί γὰρ κακὸν ἐποίησεν; Οἱ δὲ περισσοτέρως ἔκραξαν, Σταύρωσον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ὁ δὲ Πιλάτος βουλόμενος τῷ ὄχλῳ τὸ ἱκανὸν ποιῆσαι, ἀπέλυσεν αὐτοῖς τὸν Βαραββᾶν· καὶ παρέδωκε τὸν Ἰησοῦν φραγελλώσας ἵνα σταυρωθῇ. ");
INSERT INTO grctr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Οἱ δὲ στρατιῶται ἀπήγαγον αὐτὸν ἔσω τῆς αὐλῆς, ὅ ἐστι πραιτώριον, καὶ συγκαλοῦσιν ὅλην τὴν σπεῖραν. ");
INSERT INTO grctr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Καὶ ἐνδύουσιν αὐτὸν πορφύραν, καὶ περιτιθέασιν αὐτῷ πλέξαντες ἀκάνθινον στέφανον, ");
INSERT INTO grctr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","καὶ ἤρξαντο ἀσπάζεσθαι αὐτόν, Χαῖρε, βασιλεῦ τῶν Ἰουδαίων· ");
INSERT INTO grctr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","καὶ ἔτυπτον αὐτοῦ τὴν κεφαλὴν καλάμῳ, καὶ ἐνέπτυον αὐτῷ, καὶ τιθέντες τὰ γόνατα προσεκύνουν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Καὶ ὅτε ἐνέπαιξαν αὐτῷ, ἐξέδυσαν αὐτὸν τὴν πορφύραν, καὶ ἐνέδυσαν αὐτὸν τὰ ἱμάτια τὰ ἴδια, καὶ ἐξάγουσιν αὐτὸν ἵνα σταυρώσωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Καὶ ἀγγαρεύουσι παράγοντά τινα Σίμωνα Κυρηναῖον, ἐρχόμενον ἀπ᾿ ἀγροῦ, τὸν πατέρα Ἀλεξάνδρου καὶ Ῥούφου, ἵνα ἄρῃ τὸν σταυρὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Καὶ φέρουσιν αὐτὸν ἐπὶ Γολγοθᾶ τόπον, ὅ ἐστι μεθερμηνευόμενον Κρανίου Τόπος. ");
INSERT INTO grctr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Καὶ ἐδίδουν αὐτῷ πιεῖν ἐσμυρνισμένον οἶνον· ὁ δὲ οὐκ ἔλαβε. ");
INSERT INTO grctr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Καὶ σταυρώσαντες αὐτόν, διεμέριζον τὰ ἱμάτια αὐτοῦ, βάλλοντες κλῆρον ἐπ᾿ αὐτά, τίς τί ἄρῃ. ");
INSERT INTO grctr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ἦν δὲ ὥρα τρίτη, καὶ ἐσταύρωσαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Καὶ ἦν ἡ ἐπιγραφὴ τῆς αἰτίας αὐτοῦ ἐπιγεγραμμένη, Ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Καὶ σὺν αὐτῷ σταυροῦσι δύο λῃστάς, ἕνα ἐκ δεξιῶν καὶ ἕνα ἐξ εὐωνύμων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Καὶ ἐπληρώθη ἡ γραφὴ ἡ λέγουσα, Καὶ μετὰ ἀνόμων ἐλογίσθη. ");
INSERT INTO grctr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Καὶ οἱ παραπορευόμενοι ἐβλασφήμουν αὐτόν, κινοῦντες τὰς κεφαλὰς αὐτῶν, καὶ λέγοντες, Οὐά, ὁ καταλύων τὸν ναὸν καὶ ἐν τρισὶν ἡμέραις οἰκοδομῶν, ");
INSERT INTO grctr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","σῶσον σεαυτόν, καὶ κατάβα ἀπὸ τοῦ σταυροῦ. ");
INSERT INTO grctr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ὁμοίως δὲ καὶ οἱ ἀρχιερεῖς ἐμπαίζοντες πρὸς ἀλλήλους μετὰ τῶν γραμματέων ἔλεγον, Ἄλλους ἔσωσεν, ἑαυτὸν οὐ δύναται σῶσαι. ");
INSERT INTO grctr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ὁ Χριστὸς ὁ βασιλεὺς τοῦ Ἰσραὴλ καταβάτω νῦν ἀπὸ τοῦ σταυροῦ, ἵνα ἴδωμεν καὶ πιστεύσωμεν. Καὶ οἱ συνεσταυρωμένοι αὐτῷ ὠνείδιζον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Γενομένης δὲ ὥρας ἕκτης, σκότος ἐγένετο ἐφ᾿ ὅλην τὴν γῆν ἕως ὥρας ἐννάτης. ");
INSERT INTO grctr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Καὶ τῇ ὥρᾳ τῇ ἐννάτῃ ἐβόησεν ὁ Ἰησοῦς φωνῇ μεγάλῃ, λέγων, Ἐλωΐ, Ἐλωΐ, λαμμᾶ σαβαχθανί; Ὅ ἐστι μεθερμηνευόμενον, Ὁ Θεός μου, ὁ Θεός μου, εἰς τί με ἐγκατέλιπες; ");
INSERT INTO grctr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Καί τινες τῶν παρεστηκότων ἀκούσαντες ἔλεγον, Ἰδού, Ἠλίαν φωνεῖ. ");
INSERT INTO grctr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Δραμὼν δὲ εἷς, καὶ γεμίσας σπόγγον ὄξους, περιθείς τε καλάμῳ, ἐπότιζεν αὐτόν, λέγων, Ἄφετε, ἴδωμεν εἰ ἔρχεται Ἠλίας καθελεῖν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ὁ δὲ Ἰησοῦς ἀφεὶς φωνὴν μεγάλην ἐξέπνευσε. ");
INSERT INTO grctr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Καὶ τὸ καταπέτασμα τοῦ ναοῦ ἐσχίσθη εἰς δύο ἀπὸ ἄνωθεν ἕως κάτω. ");
INSERT INTO grctr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ἰδὼν δὲ ὁ κεντυρίων ὁ παρεστηκὼς ἐξ ἐναντίας αὐτοῦ ὅτι οὕτω κράξας ἐξέπνευσεν, εἶπεν, Ἀληθῶς ὁ ἄνθρωπος οὗτος υἱὸς ἦν Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ἦσαν δὲ καὶ γυναῖκες ἀπὸ μακρόθεν θεωροῦσαι, ἐν αἷς ἦν καὶ Μαρία ἡ Μαγδαληνή, καὶ Μαρία ἡ τοῦ Ἰακώβου τοῦ μικροῦ καὶ Ἰωσῆ μήτηρ, καὶ Σαλώμη, ");
INSERT INTO grctr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","αἳ καί, ὅτε ἦν ἐν τῇ Γαλιλαίᾳ, ἠκολούθουν αὐτῷ, καὶ διηκόνουν αὐτῷ, καὶ ἄλλαι πολλαὶ αἱ συναναβᾶσαι αὐτῷ εἰς Ἱεροσόλυμα. ");
INSERT INTO grctr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Καὶ ἤδη ὀψίας γενομένης, ἐπεὶ ἦν Παρασκευή, ὅ ἐστι προσάββατον, ");
INSERT INTO grctr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ἦλθεν Ἰωσὴφ ὁ ἀπὸ Ἀριμαθαίας, εὐσχήμων βουλευτής, ὃς καὶ αὐτὸς ἦν προσδεχόμενος τὴν βασιλείαν τοῦ Θεοῦ· τολμήσας εἰσῆλθε πρὸς Πιλάτον, καὶ ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ὁ δὲ Πιλάτος ἐθαύμασεν εἰ ἤδη τέθνηκε· καὶ προσκαλεσάμενος τὸν κεντυρίωνα, ἐπηρώτησεν αὐτὸν εἰ πάλαι ἀπέθανε. ");
INSERT INTO grctr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Καὶ γνοὺς ἀπὸ τοῦ κεντυρίωνος, ἐδωρήσατο τὸ σῶμα τῷ Ἰωσήφ. ");
INSERT INTO grctr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Καὶ ἀγοράσας σινδόνα, καὶ καθελὼν αὐτόν, ἐνείλησε τῇ σινδόνι, καὶ κατέθηκεν αὐτὸν ἐν μνημείῳ, ὃ ἦν λελατομημένον ἐκ πέτρας· καὶ προσεκύλισε λίθον ἐπὶ τὴν θύραν τοῦ μνημείου. ");
INSERT INTO grctr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ἡ δὲ Μαρία ἡ Μαγδαληνὴ καὶ Μαρία Ἰωσῆ ἐθεώρουν ποῦ τίθεται. ");
INSERT INTO grctr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Καὶ διαγενομένου τοῦ σαββάτου, Μαρία ἡ Μαγδαληνὴ καὶ Μαρία ἡ τοῦ Ἰακώβου καὶ Σαλώμη ἠγόρασαν ἀρώματα, ἵνα ἐλθοῦσαι ἀλείψωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Καὶ λίαν πρωῒ τῆς μιᾶς σαββάτων ἔρχονται ἐπὶ τὸ μνημεῖον, ἀνατείλαντος τοῦ ἡλίου. ");
INSERT INTO grctr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Καὶ ἔλεγον πρὸς ἑαυτάς, Τίς ἀποκυλίσει ἡμῖν τὸν λίθον ἐκ τῆς θύρας τοῦ μνημείου; ");
INSERT INTO grctr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Καὶ ἀναβλέψασαι θεωροῦσιν ὅτι ἀποκεκύλισται ὁ λίθος· ἦν γὰρ μέγας σφόδρα. ");
INSERT INTO grctr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Καὶ εἰσελθοῦσαι εἰς τὸ μνημεῖον, εἶδον νεανίσκον καθήμενον ἐν τοῖς δεξιοῖς, περιβεβλημένον στολὴν λευκήν· καὶ ἐξεθαμβήθησαν. ");
INSERT INTO grctr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ὁ δὲ λέγει αὐταῖς, Μὴ ἐκθαμβεῖσθε· Ἰησοῦν ζητεῖτε τὸν Ναζαρηνὸν τὸν ἐσταυρωμένον· ἠγέρθη, οὐκ ἔστιν ὧδε· ἴδε, ὁ τόπος ὅπου ἔθηκαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ἀλλ᾿ ὑπάγετε, εἴπατε τοῖς μαθηταῖς αὐτοῦ καὶ τῷ Πέτρῳ ὅτι Προάγει ὑμᾶς εἰς τὴν Γαλιλαίαν· ἐκεῖ αὐτὸν ὄψεσθε, καθὼς εἶπεν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Καὶ ἐξελθοῦσαι ταχὺ ἔφυγον ἀπὸ τοῦ μνημείου· εἶχε δὲ αὐτὰς τρόμος καὶ ἔκστασις· καὶ οὐδενὶ οὐδὲν εἶπον, ἐφοβοῦντο γάρ. ");
INSERT INTO grctr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ἀναστὰς δὲ πρωῒ πρώτῃ σαββάτου ἐφάνη πρῶτον Μαρίᾳ τῇ Μαγδαληνῇ, ἀφ᾿ ἧς ἐκβεβλήκει ἑπτὰ δαιμόνια. ");
INSERT INTO grctr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ἐκείνη πορευθεῖσα ἀπήγγειλε τοῖς μετ᾿ αὐτοῦ γενομένοις, πενθοῦσι καὶ κλαίουσι. ");
INSERT INTO grctr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Κἀκεῖνοι ἀκούσαντες ὅτι ζῇ καὶ ἐθεάθη ὑπ᾿ αὐτῆς ἠπίστησαν. ");
INSERT INTO grctr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Μετὰ δὲ ταῦτα δυσὶν ἐξ αὐτῶν περιπατοῦσιν ἐφανερώθη ἐν ἑτέρᾳ μορφῇ, πορευομένοις εἰς ἀγρόν. ");
INSERT INTO grctr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Κἀκεῖνοι ἀπελθόντες ἀπήγγειλαν τοῖς λοιποῖς· οὐδὲ ἐκείνοις ἐπίστευσαν. ");
INSERT INTO grctr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ὕστερον ἀνακειμένοις αὐτοῖς τοῖς ἕνδεκα ἐφανερώθη, καὶ ὠνείδισε τὴν ἀπιστίαν αὐτῶν καὶ σκληροκαρδίαν, ὅτι τοῖς θεασαμένοις αὐτὸν ἐγηγερμένον οὐκ ἐπίστευσαν. ");
INSERT INTO grctr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Καὶ εἶπεν αὐτοῖς, Πορευθέντες εἰς τὸν κόσμον ἅπαντα, κηρύξατε τὸ εὐαγγέλιον πάσῃ τῇ κτίσει. ");
INSERT INTO grctr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ὁ πιστεύσας καὶ βαπτισθεὶς σωθήσεται· ὁ δὲ ἀπιστήσας κατακριθήσεται. ");
INSERT INTO grctr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Σημεῖα δὲ τοῖς πιστεύσασι ταῦτα παρακολουθήσει· ἐν τῷ ὀνόματί μου δαιμόνια ἐκβαλοῦσι· γλώσσαις λαλήσουσι καιναῖς· ");
INSERT INTO grctr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ὄφεις ἀροῦσι· κἂν θανάσιμόν τι πίωσιν, οὐ μὴ αὐτοὺς βλάψει· ἐπὶ ἀρρώστους χεῖρας ἐπιθήσουσι, καὶ καλῶς ἕξουσιν. ");
INSERT INTO grctr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ὁ μὲν οὖν Κύριος, μετὰ τὸ λαλῆσαι αὐτοῖς, ἀνελήφθη εἰς τὸν οὐρανόν, καὶ ἐκάθισεν ἐκ δεξιῶν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ἐκεῖνοι δὲ ἐξελθόντες ἐκήρυξαν πανταχοῦ, τοῦ Κυρίου συνεργοῦντος, καὶ τὸν λόγον βεβαιοῦντος διὰ τῶν ἐπακολουθούντων σημείων. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ἐπειδήπερ πολλοὶ ἐπεχείρησαν ἀνατάξασθαι διήγησιν περὶ τῶν πεπληροφορημένων ἐν ἡμῖν πραγμάτων, ");
INSERT INTO grctr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","καθὼς παρέδοσαν ἡμῖν οἱ ἀπ᾿ ἀρχῆς αὐτόπται καὶ ὑπηρέται γενόμενοι τοῦ λόγου, ");
INSERT INTO grctr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ἔδοξε κἀμοί, παρηκολουθηκότι ἄνωθεν πᾶσιν ἀκριβῶς, καθεξῆς σοι γράψαι, κράτιστε Θεόφιλε, ");
INSERT INTO grctr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ἵνα ἐπιγνῷς περὶ ὧν κατηχήθης λόγων τὴν ἀσφάλειαν. ");
INSERT INTO grctr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ἐγένετο ἐν ταῖς ἡμέραις Ἡρῴδου τοῦ βασιλέως τῆς Ἰουδαίας ἱερεύς τις ὀνόματι Ζαχαρίας, ἐξ ἐφημερίας Ἀβιά· καὶ ἡ γυνὴ αὐτοῦ ἐκ τῶν θυγατέρων Ἀαρών, καὶ τὸ ὄνομα αὐτῆς Ἐλισάβετ. ");
INSERT INTO grctr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ἦσαν δὲ δίκαιοι ἀμφότεροι ἐνώπιον τοῦ Θεοῦ, πορευόμενοι ἐν πάσαις ταῖς ἐντολαῖς καὶ δικαιώμασι τοῦ Κυρίου ἄμεμπτοι. ");
INSERT INTO grctr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Καὶ οὐκ ἦν αὐτοῖς τέκνον, καθότι ἡ Ἐλισάβετ ἦν στεῖρα, καὶ ἀμφότεροι προβεβηκότες ἐν ταῖς ἡμέραις αὐτῶν ἦσαν. ");
INSERT INTO grctr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ἐγένετο δὲ ἐν τῷ ἱερατεύειν αὐτὸν ἐν τῇ τάξει τῆς ἐφημερίας αὐτοῦ ἔναντι τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","κατὰ τὸ ἔθος τῆς ἱερατείας, ἔλαχε τοῦ θυμιᾶσαι εἰσελθὼν εἰς τὸν ναὸν τοῦ Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Καὶ πᾶν τὸ πλῆθος τοῦ λαοῦ ἦν προσευχόμενον ἔξω τῇ ὥρᾳ τοῦ θυμιάματος. ");
INSERT INTO grctr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ὤφθη δὲ αὐτῷ ἄγγελος Κυρίου, ἑστὼς ἐκ δεξιῶν τοῦ θυσιαστηρίου τοῦ θυμιάματος. ");
INSERT INTO grctr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Καὶ ἐταράχθη Ζαχαρίας ἰδών, καὶ φόβος ἐπέπεσεν ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Εἶπε δὲ πρὸς αὐτὸν ὁ ἄγγελος, Μὴ φοβοῦ, Ζαχαρία· διότι εἰσηκούσθη ἡ δέησίς σου, καὶ ἡ γυνή σου Ἐλισάβετ γεννήσει υἱόν σοι, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰωάννην. ");
INSERT INTO grctr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Καὶ ἔσται χαρά σοι καὶ ἀγαλλίασις, καὶ πολλοὶ ἐπὶ τῇ γεννήσει αὐτοῦ χαρήσονται. ");
INSERT INTO grctr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ἔσται γὰρ μέγας ἐνώπιον τοῦ Κυρίου, καὶ οἶνον καὶ σίκερα οὐ μὴ πίῃ, καὶ πνεύματος ἁγίου πλησθήσεται ἔτι ἐκ κοιλίας μητρὸς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Καὶ πολλοὺς τῶν υἱῶν Ἰσραὴλ ἐπιστρέψει ἐπὶ Κύριον τὸν Θεὸν αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","καὶ αὐτὸς προελεύσεται ἐνώπιον αὐτοῦ ἐν πνεύματι καὶ δυνάμει Ἠλίου, ἐπιστρέψαι καρδίας πατέρων ἐπὶ τέκνα, καὶ ἀπειθεῖς ἐν φρονήσει δικαίων, ἑτοιμάσαι Κυρίῳ λαὸν κατεσκευασμένον. ");
INSERT INTO grctr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Καὶ εἶπε Ζαχαρίας πρὸς τὸν ἄγγελον, Κατὰ τί γνώσομαι τοῦτο; Ἐγὼ γάρ εἰμι πρεσβύτης, καὶ ἡ γυνή μου προβεβηκυῖα ἐν ταῖς ἡμέραις αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Καὶ ἀποκριθεὶς ὁ ἄγγελος εἶπεν αὐτῷ, Ἐγώ εἰμι Γαβριὴλ ὁ παρεστηκὼς ἐνώπιον τοῦ Θεοῦ· καὶ ἀπεστάλην λαλῆσαι πρός σε, καὶ εὐαγγελίσασθαί σοι ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Καὶ ἰδού, ἔσῃ σιωπῶν καὶ μὴ δυνάμενος λαλῆσαι, ἄχρι ἧς ἡμέρας γένηται ταῦτα, ἀνθ᾿ ὧν οὐκ ἐπίστευσας τοῖς λόγοις μου, οἵτινες πληρωθήσονται εἰς τὸν καιρὸν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Καὶ ἦν ὁ λαὸς προσδοκῶν τὸν Ζαχαρίαν· καὶ ἐθαύμαζον ἐν τῷ χρονίζειν αὐτὸν ἐν τῷ ναῷ. ");
INSERT INTO grctr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ἐξελθὼν δὲ οὐκ ἠδύνατο λαλῆσαι αὐτοῖς· καὶ ἐπέγνωσαν ὅτι ὀπτασίαν ἑώρακεν ἐν τῷ ναῷ· καὶ αὐτὸς ἦν διανεύων αὐτοῖς, καὶ διέμενε κωφός. ");
INSERT INTO grctr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Καὶ ἐγένετο, ὡς ἐπλήσθησαν αἱ ἡμέραι τῆς λειτουργίας αὐτοῦ, ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Μετὰ δὲ ταύτας τὰς ἡμέρας συνέλαβεν Ἐλισάβετ ἡ γυνὴ αὐτοῦ, καὶ περιέκρυβεν ἑαυτὴν μῆνας πέντε, λέγουσα ");
INSERT INTO grctr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ὅτι Οὕτω μοι πεποίηκεν ὁ Κύριος ἐν ἡμέραις αἷς ἐπεῖδεν ἀφελεῖν τὸ ὄνειδός μου ἐν ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ἐν δὲ τῷ μηνὶ τῷ ἕκτῳ ἀπεστάλη ὁ ἄγγελος Γαβριὴλ ὑπὸ τοῦ Θεοῦ εἰς πόλιν τῆς Γαλιλαίας, ᾗ ὄνομα Ναζαρέθ, ");
INSERT INTO grctr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","πρὸς παρθένον μεμνηστευμένην ἀνδρί, ᾧ ὄνομα Ἰωσήφ, ἐξ οἴκου Δαβίδ· καὶ τὸ ὄνομα τῆς παρθένου Μαριάμ. ");
INSERT INTO grctr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Καὶ εἰσελθὼν ὁ ἄγγελος πρὸς αὐτὴν εἶπε, Χαῖρε, κεχαριτωμένη· ὁ Κύριος μετὰ σοῦ, εὐλογημένη σὺ ἐν γυναιξίν. ");
INSERT INTO grctr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ἡ δὲ ἰδοῦσα διεταράχθη ἐπὶ τῷ λόγῳ αὐτοῦ, καὶ διελογίζετο ποταπὸς εἴη ὁ ἀσπασμὸς οὗτος. ");
INSERT INTO grctr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Καὶ εἶπεν ὁ ἄγγελος αὐτῇ, Μὴ φοβοῦ, Μαριάμ· εὗρες γὰρ χάριν παρὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Καὶ ἰδού, συλλήψῃ ἐν γαστρί, καὶ τέξῃ υἱόν, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Οὗτος ἔσται μέγας, καὶ υἱὸς ὑψίστου κληθήσεται· καὶ δώσει αὐτῷ Κύριος ὁ Θεὸς τὸν θρόνον Δαβὶδ τοῦ πατρὸς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","καὶ βασιλεύσει ἐπὶ τὸν οἶκον Ἰακὼβ εἰς τοὺς αἰῶνας, καὶ τῆς βασιλείας αὐτοῦ οὐκ ἔσται τέλος. ");
INSERT INTO grctr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Εἶπε δὲ Μαριὰμ πρὸς τὸν ἄγγελον, Πῶς ἔσται τοῦτο, ἐπεὶ ἄνδρα οὐ γινώσκω; ");
INSERT INTO grctr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Καὶ ἀποκριθεὶς ὁ ἄγγελος εἶπεν αὐτῇ, Πνεῦμα ἅγιον ἐπελεύσεται ἐπὶ σέ, καὶ δύναμις ὑψίστου ἐπισκιάσει σοι· διὸ καὶ τὸ γεννώμενον ἅγιον κληθήσεται υἱὸς Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Καὶ ἰδού, Ἐλισάβετ ἡ συγγενής σου, καὶ αὐτὴ συνειληφυῖα υἱὸν ἐν γήρᾳ αὐτῆς· καὶ οὗτος μὴν ἕκτος ἐστὶν αὐτῇ τῇ καλουμένῃ στείρᾳ. ");
INSERT INTO grctr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ὅτι οὐκ ἀδυνατήσει παρὰ τῷ Θεῷ πᾶν ῥῆμα. ");
INSERT INTO grctr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Εἶπε δὲ Μαριάμ, Ἰδού, ἡ δούλη Κυρίου· γένοιτό μοι κατὰ τὸ ῥῆμά σου. Καὶ ἀπῆλθεν ἀπ᾿ αὐτῆς ὁ ἄγγελος. ");
INSERT INTO grctr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ἀναστᾶσα δὲ Μαριὰμ ἐν ταῖς ἡμέραις ταύταις ἐπορεύθη εἰς τὴν ὀρεινὴν μετὰ σπουδῆς, εἰς πόλιν Ἰούδα, ");
INSERT INTO grctr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","καὶ εἰσῆλθεν εἰς τὸν οἶκον Ζαχαρίου, καὶ ἠσπάσατο τὴν Ἐλισάβετ. ");
INSERT INTO grctr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Καὶ ἐγένετο ὡς ἤκουσεν ἡ Ἐλισάβετ τὸν ἀσπασμὸν τῆς Μαρίας, ἐσκίρτησε τὸ βρέφος ἐν τῇ κοιλίᾳ αὐτῆς· καὶ ἐπλήσθη πνεύματος ἁγίου ἡ Ἐλισάβετ, ");
INSERT INTO grctr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","καὶ ἀνεφώνησε φωνῇ μεγάλῃ, καὶ εἶπεν, Εὐλογημένη σὺ ἐν γυναιξί, καὶ εὐλογημένος ὁ καρπὸς τῆς κοιλίας σου. ");
INSERT INTO grctr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Καὶ πόθεν μοι τοῦτο, ἵνα ἔλθῃ ἡ μήτηρ τοῦ Κυρίου μου πρός με; ");
INSERT INTO grctr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ἰδοὺ γάρ, ὡς ἐγένετο ἡ φωνὴ τοῦ ἀσπασμοῦ σου εἰς τὰ ὦτά μου, ἐσκίρτησεν ἐν ἀγαλλιάσει τὸ βρέφος ἐν τῇ κοιλίᾳ μου. ");
INSERT INTO grctr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Καὶ μακαρία ἡ πιστεύσασα, ὅτι ἔσται τελείωσις τοῖς λελαλημένοις αὐτῇ παρὰ Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Καὶ εἶπε Μαριάμ, Μεγαλύνει ἡ ψυχή μου τὸν Κύριον, ");
INSERT INTO grctr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","καὶ ἠγαλλίασε τὸ πνεῦμά μου ἐπὶ τῷ Θεῷ τῷ σωτῆρί μου. ");
INSERT INTO grctr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ὅτι ἐπέβλεψεν ἐπὶ τὴν ταπείνωσιν τῆς δούλης αὐτοῦ. Ἰδοὺ γάρ, ἀπὸ τοῦ νῦν μακαριοῦσί με πᾶσαι αἱ γενεαί. ");
INSERT INTO grctr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ὅτι ἐποίησέ μοι μεγαλεῖα ὁ δυνατός, καὶ ἅγιον τὸ ὄνομα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Καὶ τὸ ἔλεος αὐτοῦ εἰς γενεὰς γενεῶν τοῖς φοβουμένοις αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ἐποίησε κράτος ἐν βραχίονι αὐτοῦ· διεσκόρπισεν ὑπερηφάνους διανοίᾳ καρδίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Καθεῖλε δυνάστας ἀπὸ θρόνων, καὶ ὕψωσε ταπεινούς. ");
INSERT INTO grctr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Πεινῶντας ἐνέπλησεν ἀγαθῶν, καὶ πλουτοῦντας ἐξαπέστειλε κενούς. ");
INSERT INTO grctr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ἀντελάβετο Ἰσραὴλ παιδὸς αὐτοῦ, μνησθῆναι ἐλέους, ");
INSERT INTO grctr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","καθὼς ἐλάλησε πρὸς τοὺς πατέρας ἡμῶν, τῷ Ἀβραὰμ καὶ τῷ σπέρματι αὐτοῦ εἰς τὸν αἰῶνα. ");
INSERT INTO grctr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ἔμεινε δὲ Μαριὰμ σὺν αὐτῇ ὡσεὶ μῆνας τρεῖς, καὶ ὑπέστρεψεν εἰς τὸν οἶκον αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Τῇ δὲ Ἐλισάβετ ἐπλήσθη ὁ χρόνος τοῦ τεκεῖν αὐτήν, καὶ ἐγέννησεν υἱόν. ");
INSERT INTO grctr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Καὶ ἤκουσαν οἱ περίοικοι καὶ οἱ συγγενεῖς αὐτῆς ὅτι ἐμεγάλυνε Κύριος τὸ ἔλεος αὐτοῦ μετ᾿ αὐτῆς, καὶ συνέχαιρον αὐτῇ. ");
INSERT INTO grctr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Καὶ ἐγένετο ἐν τῇ ὀγδόῃ ἡμέρᾳ, ἦλθον περιτεμεῖν τὸ παιδίον· καὶ ἐκάλουν αὐτὸ ἐπὶ τῷ ὀνόματι τοῦ πατρὸς αὐτοῦ Ζαχαρίαν. ");
INSERT INTO grctr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Καὶ ἀποκριθεῖσα ἡ μήτηρ αὐτοῦ εἶπεν, Οὐχί, ἀλλὰ κληθήσεται Ἰωάννης. ");
INSERT INTO grctr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Καὶ εἶπον πρὸς αὐτὴν ὅτι Οὐδείς ἐστιν ἐν τῇ συγγενείᾳ σου ὃς καλεῖται τῷ ὀνόματι τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ἐνένευον δὲ τῷ πατρὶ αὐτοῦ, τὸ τί ἂν θέλοι καλεῖσθαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Καὶ αἰτήσας πινακίδιον ἔγραψε, λέγων, Ἰωάννης ἐστὶ τὸ ὄνομα αὐτοῦ· καὶ ἐθαύμασαν πάντες. ");
INSERT INTO grctr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ἀνεῴχθη δὲ τὸ στόμα αὐτοῦ παραχρῆμα καὶ ἡ γλῶσσα αὐτοῦ, καὶ ἐλάλει εὐλογῶν τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Καὶ ἐγένετο ἐπὶ πάντας φόβος τοὺς περιοικοῦντας αὐτούς· καὶ ἐν ὅλῃ τῇ ὀρεινῇ τῆς Ἰουδαίας διελαλεῖτο πάντα τὰ ῥήματα ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Καὶ ἔθεντο πάντες οἱ ἀκούσαντες ἐν τῇ καρδίᾳ αὐτῶν, λέγοντες, Τί ἄρα τὸ παιδίον τοῦτο ἔσται; Καὶ χεὶρ Κυρίου ἦν μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Καὶ Ζαχαρίας ὁ πατὴρ αὐτοῦ ἐπλήσθη πνεύματος ἁγίου, καὶ προεφήτευσε, λέγων, ");
INSERT INTO grctr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Εὐλογητὸς Κύριος ὁ Θεὸς τοῦ Ἰσραήλ, ὅτι ἐπεσκέψατο καὶ ἐποίησε λύτρωσιν τῷ λαῷ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","καὶ ἤγειρε κέρας σωτηρίας ἡμῖν ἐν τῷ οἴκῳ Δαβὶδ τοῦ παιδὸς αὐτοῦ — ");
INSERT INTO grctr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","καθὼς ἐλάλησε διὰ στόματος τῶν ἁγίων τῶν ἀπ᾿ αἰῶνος προφητῶν αὐτοῦ — ");
INSERT INTO grctr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","σωτηρίαν ἐξ ἐχθρῶν ἡμῶν, καὶ ἐκ χειρὸς πάντων τῶν μισούντων ἡμᾶς· ");
INSERT INTO grctr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ποιῆσαι ἔλεος μετὰ τῶν πατέρων ἡμῶν, καὶ μνησθῆναι διαθήκης ἁγίας αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ὅρκον ὃν ὤμοσε πρὸς Ἀβραὰμ τὸν πατέρα ἡμῶν, τοῦ δοῦναι ἡμῖν, ");
INSERT INTO grctr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ἀφόβως, ἐκ χειρὸς τῶν ἐχθρῶν ἡμῶν ῥυσθέντας, λατρεύειν αὐτῷ ");
INSERT INTO grctr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ἐν ὁσιότητι καὶ δικαιοσύνῃ ἐνώπιον αὐτοῦ πάσας τὰς ἡμέρας τῆς ζωῆς ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Καὶ σύ, παιδίον, προφήτης ὑψίστου κληθήσῃ· προπορεύσῃ γὰρ πρὸ προσώπου Κυρίου ἑτοιμάσαι ὁδοὺς αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","τοῦ δοῦναι γνῶσιν σωτηρίας τῷ λαῷ αὐτοῦ ἐν ἀφέσει ἁμαρτιῶν αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","διὰ σπλάγχνα ἐλέους Θεοῦ ἡμῶν, ἐν οἷς ἐπεσκέψατο ἡμᾶς ἀνατολὴ ἐξ ὕψους, ");
INSERT INTO grctr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ἐπιφᾶναι τοῖς ἐν σκότει καὶ σκιᾷ θανάτου καθημένοις, τοῦ κατευθῦναι τοὺς πόδας ἡμῶν εἰς ὁδὸν εἰρήνης. ");
INSERT INTO grctr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Τὸ δὲ παιδίον ηὔξανε καὶ ἐκραταιοῦτο πνεύματι, καὶ ἦν ἐν ταῖς ἐρήμοις ἕως ἡμέρας ἀναδείξεως αὐτοῦ πρὸς τὸν Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ἐκείναις, ἐξῆλθε δόγμα παρὰ Καίσαρος Αὐγούστου, ἀπογράφεσθαι πᾶσαν τὴν οἰκουμένην. ");
INSERT INTO grctr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Αὕτη ἡ ἀπογραφὴ πρώτη ἐγένετο ἡγεμονεύοντος τῆς Συρίας Κυρηνίου. ");
INSERT INTO grctr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Καὶ ἐπορεύοντο πάντες ἀπογράφεσθαι, ἕκαστος εἰς τὴν ἰδίαν πόλιν. ");
INSERT INTO grctr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ἀνέβη δὲ καὶ Ἰωσὴφ ἀπὸ τῆς Γαλιλαίας, ἐκ πόλεως Ναζαρέθ, εἰς τὴν Ἰουδαίαν, εἰς πόλιν Δαβίδ, ἥτις καλεῖται Βηθλέεμ, διὰ τὸ εἶναι αὐτὸν ἐξ οἴκου καὶ πατριᾶς Δαβίδ, ");
INSERT INTO grctr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ἀπογράψασθαι σὺν Μαριὰμ τῇ μεμνηστευμένῃ αὐτῷ γυναικί, οὔσῃ ἐγκύῳ. ");
INSERT INTO grctr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ἐγένετο δὲ ἐν τῷ εἶναι αὐτοὺς ἐκεῖ, ἐπλήσθησαν αἱ ἡμέραι τοῦ τεκεῖν αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Καὶ ἔτεκε τὸν υἱὸν αὐτῆς τὸν πρωτότοκον, καὶ ἐσπαργάνωσεν αὐτόν, καὶ ἀνέκλινεν αὐτὸν ἐν τῇ φάτνῃ, διότι οὐκ ἦν αὐτοῖς τόπος ἐν τῷ καταλύματι. ");
INSERT INTO grctr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Καὶ ποιμένες ἦσαν ἐν τῇ χώρᾳ τῇ αὐτῇ ἀγραυλοῦντες καὶ φυλάσσοντες φυλακὰς τῆς νυκτὸς ἐπὶ τὴν ποίμνην αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Καὶ ἰδού, ἄγγελος Κυρίου ἐπέστη αὐτοῖς, καὶ δόξα Κυρίου περιέλαμψεν αὐτούς· καὶ ἐφοβήθησαν φόβον μέγαν. ");
INSERT INTO grctr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Καὶ εἶπεν αὐτοῖς ὁ ἄγγελος, Μὴ φοβεῖσθε· ἰδοὺ γάρ, εὐαγγελίζομαι ὑμῖν χαρὰν μεγάλην, ἥτις ἔσται παντὶ τῷ λαῷ· ");
INSERT INTO grctr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ὅτι ἐτέχθη ὑμῖν σήμερον σωτήρ, ὅς ἐστι Χριστὸς Κύριος, ἐν πόλει Δαβίδ. ");
INSERT INTO grctr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Καὶ τοῦτο ὑμῖν τὸ σημεῖον· εὑρήσετε βρέφος ἐσπαργανωμένον, κείμενον ἐν τῇ φάτνῃ. ");
INSERT INTO grctr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Καὶ ἐξαίφνης ἐγένετο σὺν τῷ ἀγγέλῳ πλῆθος στρατιᾶς οὐρανίου, αἰνούντων τὸν Θεόν, καὶ λεγόντων, ");
INSERT INTO grctr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Δόξα ἐν ὑψίστοις Θεῷ, καὶ ἐπὶ γῆς εἰρήνη· ἐν ἀνθρώποις εὐδοκία. ");
INSERT INTO grctr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Καὶ ἐγένετο, ὡς ἀπῆλθον ἀπ᾿ αὐτῶν εἰς τὸν οὐρανὸν οἱ ἄγγελοι, καὶ οἱ ἄνθρωποι οἱ ποιμένες εἶπον πρὸς ἀλλήλους, Διέλθωμεν δὴ ἕως Βηθλέεμ, καὶ ἴδωμεν τὸ ῥῆμα τοῦτο τὸ γεγονός, ὃ ὁ Κύριος ἐγνώρισεν ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Καὶ ἦλθον σπεύσαντες, καὶ ἀνεῦρον τήν τε Μαριὰμ καὶ τὸν Ἰωσήφ, καὶ τὸ βρέφος κείμενον ἐν τῇ φάτνῃ. ");
INSERT INTO grctr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ἰδόντες δὲ διεγνώρισαν περὶ τοῦ ῥήματος τοῦ λαληθέντος αὐτοῖς περὶ τοῦ παιδίου τούτου. ");
INSERT INTO grctr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Καὶ πάντες οἱ ἀκούσαντες ἐθαύμασαν περὶ τῶν λαληθέντων ὑπὸ τῶν ποιμένων πρὸς αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ἡ δὲ Μαριὰμ πάντα συνετήρει τὰ ῥήματα ταῦτα, συμβάλλουσα ἐν τῇ καρδίᾳ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Καὶ ἐπέστρεψαν οἱ ποιμένες, δοξάζοντες καὶ αἰνοῦντες τὸν Θεὸν ἐπὶ πᾶσιν οἷς ἤκουσαν καὶ εἶδον, καθὼς ἐλαλήθη πρὸς αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Καὶ ὅτε ἐπλήσθησαν ἡμέραι ὀκτὼ τοῦ περιτεμεῖν τὸ παιδίον, καὶ ἐκλήθη τὸ ὄνομα αὐτοῦ Ἰησοῦς, τὸ κληθὲν ὑπὸ τοῦ ἀγγέλου πρὸ τοῦ συλληφθῆναι αὐτὸν ἐν τῇ κοιλίᾳ. ");
INSERT INTO grctr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Καὶ ὅτε ἐπλήσθησαν αἱ ἡμέραι τοῦ καθαρισμοῦ αὐτῆς κατὰ τὸν νόμον Μωσέως, ἀνήγαγον αὐτὸν εἰς Ἱεροσόλυμα, παραστῆσαι τῷ Κυρίῳ — ");
INSERT INTO grctr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","καθὼς γέγραπται ἐν νόμῳ Κυρίου ὅτι Πᾶν ἄρσεν διανοῖγον μήτραν ἅγιον τῷ Κυρίῳ κληθήσεται — ");
INSERT INTO grctr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","καὶ τοῦ δοῦναι θυσίαν κατὰ τὸ εἰρημένον ἐν νόμῳ Κυρίου, Ζεῦγος τρυγόνων ἢ δύο νεοσσοὺς περιστερῶν. ");
INSERT INTO grctr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Καὶ ἰδού, ἦν ἄνθρωπος ἐν Ἱερουσαλήμ, ᾧ ὄνομα Συμεών, καὶ ὁ ἄνθρωπος οὗτος δίκαιος καὶ εὐλαβής, προσδεχόμενος παράκλησιν τοῦ Ἰσραήλ, καὶ πνεῦμα ἅγιον ἦν ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Καὶ ἦν αὐτῷ κεχρηματισμένον ὑπὸ τοῦ πνεύματος τοῦ ἁγίου, μὴ ἰδεῖν θάνατον πρὶν ἢ ἴδῃ τὸν Χριστὸν Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Καὶ ἦλθεν ἐν τῷ πνεύματι εἰς τὸ ἱερόν· καὶ ἐν τῷ εἰσαγαγεῖν τοὺς γονεῖς τὸ παιδίον Ἰησοῦν, τοῦ ποιῆσαι αὐτοὺς κατὰ τὸ εἰθισμένον τοῦ νόμου περὶ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","καὶ αὐτὸς ἐδέξατο αὐτὸ εἰς τὰς ἀγκάλας αὐτοῦ, καὶ εὐλόγησε τὸν Θεόν, καὶ εἶπε, ");
INSERT INTO grctr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Νῦν ἀπολύεις τὸν δοῦλόν σου, δέσποτα, κατὰ τὸ ῥῆμά σου, ἐν εἰρήνῃ· ");
INSERT INTO grctr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ὅτι εἶδον οἱ ὀφθαλμοί μου τὸ σωτήριόν σου, ");
INSERT INTO grctr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ὃ ἡτοίμασας κατὰ πρόσωπον πάντων τῶν λαῶν· ");
INSERT INTO grctr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","φῶς εἰς ἀποκάλυψιν ἐθνῶν, καὶ δόξαν λαοῦ σου Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Καὶ ἦν Ἰωσὴφ καὶ ἡ μήτηρ αὐτοῦ θαυμάζοντες ἐπὶ τοῖς λαλουμένοις περὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Καὶ εὐλόγησεν αὐτοὺς Συμεών, καὶ εἶπε πρὸς Μαριὰμ τὴν μητέρα αὐτοῦ, Ἰδού, οὗτος κεῖται εἰς πτῶσιν καὶ ἀνάστασιν πολλῶν ἐν τῷ Ἰσραήλ, καὶ εἰς σημεῖον ἀντιλεγόμενον· ");
INSERT INTO grctr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","καὶ σοῦ δὲ αὐτῆς τὴν ψυχὴν διελεύσεται ῥομφαία· ὅπως ἂν ἀποκαλυφθῶσιν ἐκ πολλῶν καρδιῶν διαλογισμοί. ");
INSERT INTO grctr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Καὶ ἦν Ἅννα προφῆτις, θυγάτηρ Φανουήλ, ἐκ φυλῆς Ἀσήρ — αὕτη προβεβηκυῖα ἐν ἡμέραις πολλαῖς, ζήσασα ἔτη μετὰ ἀνδρὸς ἑπτὰ ἀπὸ τῆς παρθενίας αὐτῆς, ");
INSERT INTO grctr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","καὶ αὕτη χήρα ὡς ἐτῶν ὀγδοήκοντα τεσσάρων — ἣ οὐκ ἀφίστατο ἀπὸ τοῦ ἱεροῦ, νηστείαις καὶ δεήσεσι λατρεύουσα νύκτα καὶ ἡμέραν. ");
INSERT INTO grctr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Καὶ αὕτη αὐτῇ τῇ ὥρᾳ ἐπιστᾶσα ἀνθωμολογεῖτο τῷ Κυρίῳ, καὶ ἐλάλει περὶ αὐτοῦ πᾶσι τοῖς προσδεχομένοις λύτρωσιν ἐν Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Καὶ ὡς ἐτέλεσαν ἅπαντα τὰ κατὰ τὸν νόμον Κυρίου, ὑπέστρεψαν εἰς τὴν Γαλιλαίαν, εἰς τὴν πόλιν αὐτῶν Ναζαρέθ. ");
INSERT INTO grctr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Τὸ δὲ παιδίον ηὔξανε, καὶ ἐκραταιοῦτο πνεύματι, πληρούμενον σοφίας· καὶ χάρις Θεοῦ ἦν ἐπ᾿ αὐτό. ");
INSERT INTO grctr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Καὶ ἐπορεύοντο οἱ γονεῖς αὐτοῦ κατ᾿ ἔτος εἰς Ἱερουσαλὴμ τῇ ἑορτῇ τοῦ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Καὶ ὅτε ἐγένετο ἐτῶν δώδεκα, ἀναβάντων αὐτῶν εἰς Ἱεροσόλυμα κατὰ τὸ ἔθος τῆς ἑορτῆς, ");
INSERT INTO grctr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","καὶ τελειωσάντων τὰς ἡμέρας, ἐν τῷ ὑποστρέφειν αὐτούς, ὑπέμεινεν Ἰησοῦς ὁ παῖς ἐν Ἱερουσαλήμ· καὶ οὐκ ἔγνω Ἰωσὴφ καὶ ἡ μήτηρ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","νομίσαντες δὲ αὐτὸν ἐν τῇ συνοδίᾳ εἶναι, ἦλθον ἡμέρας ὁδόν, καὶ ἀνεζήτουν αὐτὸν ἐν τοῖς συγγενέσι καὶ ἐν τοῖς γνωστοῖς· ");
INSERT INTO grctr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","καὶ μὴ εὑρόντες αὐτόν, ὑπέστρεψαν εἰς Ἱερουσαλήμ, ζητοῦντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Καὶ ἐγένετο, μεθ᾿ ἡμέρας τρεῖς εὗρον αὐτὸν ἐν τῷ ἱερῷ, καθεζόμενον ἐν μέσῳ τῶν διδασκάλων, καὶ ἀκούοντα αὐτῶν, καὶ ἐπερωτῶντα αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ἐξίσταντο δὲ πάντες οἱ ἀκούοντες αὐτοῦ ἐπὶ τῇ συνέσει καὶ ταῖς ἀποκρίσεσιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Καὶ ἰδόντες αὐτὸν ἐξεπλάγησαν· καὶ πρὸς αὐτὸν ἡ μήτηρ αὐτοῦ εἶπε, Τέκνον, τί ἐποίησας ἡμῖν οὕτως; Ἰδού, ὁ πατήρ σου κἀγὼ ὀδυνώμενοι ἐζητοῦμέν σε. ");
INSERT INTO grctr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Καὶ εἶπε πρὸς αὐτούς, Τί ὅτι ἐζητεῖτέ με; Οὐκ ᾔδειτε ὅτι ἐν τοῖς τοῦ πατρός μου δεῖ εἶναί με; ");
INSERT INTO grctr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Καὶ αὐτοὶ οὐ συνῆκαν τὸ ῥῆμα ὃ ἐλάλησεν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Καὶ κατέβη μετ᾿ αὐτῶν, καὶ ἦλθεν εἰς Ναζαρέθ· καὶ ἦν ὑποτασσόμενος αὐτοῖς. Καὶ ἡ μήτηρ αὐτοῦ διετήρει πάντα τὰ ῥήματα ταῦτα ἐν τῇ καρδίᾳ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Καὶ Ἰησοῦς προέκοπτε σοφίᾳ καὶ ἡλικίᾳ, καὶ χάριτι παρὰ Θεῷ καὶ ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ἐν ἔτει δὲ πεντεκαιδεκάτῳ τῆς ἡγεμονίας Τιβερίου Καίσαρος, ἡγεμονεύοντος Ποντίου Πιλάτου τῆς Ἰουδαίας, καὶ τετραρχοῦντος τῆς Γαλιλαίας Ἡρῴδου, Φιλίππου δὲ τοῦ ἀδελφοῦ αὐτοῦ τετραρχοῦντος τῆς Ἰτουραίας καὶ Τραχωνίτιδος χώρας, καὶ Λυσανίου τῆς Ἀβιληνῆς τετραρχοῦντος, ");
INSERT INTO grctr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ἐπ᾿ ἀρχιερέων Ἄννα καὶ Καϊάφα, ἐγένετο ῥῆμα Θεοῦ ἐπὶ Ἰωάννην τὸν τοῦ Ζαχαρίου υἱὸν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grctr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Καὶ ἦλθεν εἰς πᾶσαν τὴν περίχωρον τοῦ Ἰορδάνου, κηρύσσων βάπτισμα μετανοίας εἰς ἄφεσιν ἁμαρτιῶν· ");
INSERT INTO grctr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ὡς γέγραπται ἐν βίβλῳ λόγων Ἠσαΐου τοῦ προφήτου, λέγοντος, Φωνὴ βοῶντος ἐν τῇ ἐρήμῳ, Ἑτοιμάσατε τὴν ὁδὸν Κυρίου· εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Πᾶσα φάραγξ πληρωθήσεται, καὶ πᾶν ὄρος καὶ βουνὸς ταπεινωθήσεται· καὶ ἔσται τὰ σκολιὰ εἰς εὐθεῖαν, καὶ αἱ τραχεῖαι εἰς ὁδοὺς λείας· ");
INSERT INTO grctr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","καὶ ὄψεται πᾶσα σὰρξ τὸ σωτήριον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ἔλεγεν οὖν τοῖς ἐκπορευομένοις ὄχλοις βαπτισθῆναι ὑπ᾿ αὐτοῦ, Γεννήματα ἐχιδνῶν, τίς ὑπέδειξεν ὑμῖν φυγεῖν ἀπὸ τῆς μελλούσης ὀργῆς; ");
INSERT INTO grctr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ποιήσατε οὖν καρποὺς ἀξίους τῆς μετανοίας· καὶ μὴ ἄρξησθε λέγειν ἐν ἑαυτοῖς, Πατέρα ἔχομεν τὸν Ἀβραάμ· λέγω γὰρ ὑμῖν ὅτι δύναται ὁ Θεὸς ἐκ τῶν λίθων τούτων ἐγεῖραι τέκνα τῷ Ἀβραάμ. ");
INSERT INTO grctr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ἤδη δὲ καὶ ἡ ἀξίνη πρὸς τὴν ῥίζαν τῶν δένδρων κεῖται· πᾶν οὖν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grctr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Καὶ ἐπηρώτων αὐτὸν οἱ ὄχλοι λέγοντες, Τί οὖν ποιήσομεν; ");
INSERT INTO grctr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ἀποκριθεὶς δὲ λέγει αὐτοῖς, Ὁ ἔχων δύο χιτῶνας μεταδότω τῷ μὴ ἔχοντι· καὶ ὁ ἔχων βρώματα ὁμοίως ποιείτω. ");
INSERT INTO grctr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ἦλθον δὲ καὶ τελῶναι βαπτισθῆναι, καὶ εἶπον πρὸς αὐτόν, Διδάσκαλε, τί ποιήσομεν; ");
INSERT INTO grctr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ὁ δὲ εἶπε πρὸς αὐτούς, Μηδὲν πλέον παρὰ τὸ διατεταγμένον ὑμῖν πράσσετε. ");
INSERT INTO grctr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ἐπηρώτων δὲ αὐτὸν καὶ στρατευόμενοι, λέγοντες, Καὶ ἡμεῖς τί ποιήσομεν; Καὶ εἶπε πρὸς αὐτούς, Μηδένα διασείσητε, μηδὲ συκοφαντήσητε· καὶ ἀρκεῖσθε τοῖς ὀψωνίοις ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Προσδοκῶντος δὲ τοῦ λαοῦ, καὶ διαλογιζομένων πάντων ἐν ταῖς καρδίαις αὐτῶν περὶ τοῦ Ἰωάννου, μήποτε αὐτὸς εἴη ὁ Χριστός, ");
INSERT INTO grctr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ἀπεκρίνατο ὁ Ἰωάννης, ἅπασι λέγων, Ἐγὼ μὲν ὕδατι βαπτίζω ὑμᾶς· ἔρχεται δὲ ὁ ἰσχυρότερός μου, οὗ οὐκ εἰμὶ ἱκανὸς λῦσαι τὸν ἱμάντα τῶν ὑποδημάτων αὐτοῦ· αὐτὸς ὑμᾶς βαπτίσει ἐν πνεύματι ἁγίῳ καὶ πυρί· ");
INSERT INTO grctr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","οὗ τὸ πτύον ἐν τῇ χειρὶ αὐτοῦ, καὶ διακαθαριεῖ τὴν ἅλωνα αὐτοῦ, καὶ συνάξει τὸν σῖτον εἰς τὴν ἀποθήκην αὐτοῦ, τὸ δὲ ἄχυρον κατακαύσει πυρὶ ἀσβέστῳ. ");
INSERT INTO grctr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Πολλὰ μὲν οὖν καὶ ἕτερα παρακαλῶν εὐηγγελίζετο τὸν λαόν· ");
INSERT INTO grctr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ὁ δὲ Ἡρῴδης ὁ τετράρχης, ἐλεγχόμενος ὑπ᾿ αὐτοῦ περὶ Ἡρῳδιάδος τῆς γυναικὸς Φιλίππου τοῦ ἀδελφοῦ αὐτοῦ, καὶ περὶ πάντων ὧν ἐποίησε πονηρῶν ὁ Ἡρῴδης, ");
INSERT INTO grctr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","προσέθηκε καὶ τοῦτο ἐπὶ πᾶσι, καὶ κατέκλεισε τὸν Ἰωάννην ἐν τῇ φυλακῇ. ");
INSERT INTO grctr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ἐγένετο δὲ ἐν τῷ βαπτισθῆναι ἅπαντα τὸν λαόν, καὶ Ἰησοῦ βαπτισθέντος καὶ προσευχομένου, ἀνεῳχθῆναι τὸν οὐρανόν, ");
INSERT INTO grctr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","καὶ καταβῆναι τὸ πνεῦμα τὸ ἅγιον σωματικῷ εἴδει ὡσεὶ περιστερὰν ἐπ᾿ αὐτόν, καὶ φωνὴν ἐξ οὐρανοῦ γενέσθαι, λέγουσαν, Σὺ εἶ ὁ υἱός μου ὁ ἀγαπητός, ἐν σοὶ ηὐδόκησα. ");
INSERT INTO grctr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Καὶ αὐτὸς ἦν ὁ Ἰησοῦς ὡσεὶ ἐτῶν τριάκοντα ἀρχόμενος, ὢν — ὡς ἐνομίζετο — υἱὸς Ἰωσήφ, τοῦ Ἡλί, ");
INSERT INTO grctr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","τοῦ Ματθάτ, τοῦ Λευΐ, τοῦ Μελχί, τοῦ Ἰαννά, τοῦ Ἰωσήφ, ");
INSERT INTO grctr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","τοῦ Ματταθίου, τοῦ Ἀμώς, τοῦ Ναούμ, τοῦ Ἐσλί, τοῦ Ναγγαί, ");
INSERT INTO grctr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","τοῦ Μαάθ, τοῦ Ματταθίου, τοῦ Σεμεΐ, τοῦ Ἰωσήφ, τοῦ Ἰούδα, ");
INSERT INTO grctr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","τοῦ Ἰωαννᾶ, τοῦ Ῥησά, τοῦ Ζοροβάβελ, τοῦ Σαλαθιήλ, τοῦ Νηρί, ");
INSERT INTO grctr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","τοῦ Μελχί, τοῦ Ἀδδί, τοῦ Κωσάμ, τοῦ Ἐλμωδάμ, τοῦ Ἤρ, ");
INSERT INTO grctr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","τοῦ Ἰωσή, τοῦ Ἐλιέζερ, τοῦ Ἰωρείμ, τοῦ Ματθάτ, τοῦ Λευΐ, ");
INSERT INTO grctr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","τοῦ Συμεών, τοῦ Ἰούδα, τοῦ Ἰωσήφ, τοῦ Ἰωνάν, τοῦ Ἐλιακείμ, ");
INSERT INTO grctr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","τοῦ Μελεᾶ, τοῦ Μαϊνάν, τοῦ Ματταθά, τοῦ Ναθάν, τοῦ Δαβίδ, ");
INSERT INTO grctr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","τοῦ Ἰεσσαί, τοῦ Ὠβήδ, τοῦ Βοόζ, τοῦ Σαλμών, τοῦ Ναασσών, ");
INSERT INTO grctr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","τοῦ Ἀμιναδάβ, τοῦ Ἀράμ, τοῦ Ἑσρώμ, τοῦ Φαρές, τοῦ Ἰούδα, ");
INSERT INTO grctr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","τοῦ Ἰακώβ, τοῦ Ἰσαάκ, τοῦ Ἀβραάμ, τοῦ Θάρα, τοῦ Ναχώρ, ");
INSERT INTO grctr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","τοῦ Σαρούχ, τοῦ Ῥαγαῦ, τοῦ Φαλέκ, τοῦ Ἑβέρ, τοῦ Σαλά, ");
INSERT INTO grctr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","τοῦ Καϊνάν, τοῦ Ἀρφαξάδ, τοῦ Σήμ, τοῦ Νῶε, τοῦ Λάμεχ, ");
INSERT INTO grctr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","τοῦ Μαθουσάλα, τοῦ Ἐνώχ, τοῦ Ἰαρέδ, τοῦ Μαλελεήλ, τοῦ Καϊνάν, ");
INSERT INTO grctr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","τοῦ Ἐνώς, τοῦ Σήθ, τοῦ Ἀδάμ, τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ἰησοῦς δὲ πνεύματος ἁγίου πλήρης ὑπέστρεψεν ἀπὸ τοῦ Ἰορδάνου, καὶ ἤγετο ἐν τῷ πνεύματι εἰς τὴν ἔρημον, ");
INSERT INTO grctr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ἡμέρας τεσσαράκοντα πειραζόμενος ὑπὸ τοῦ διαβόλου. Καὶ οὐκ ἔφαγεν οὐδὲν ἐν ταῖς ἡμέραις ἐκείναις· καὶ συντελεσθεισῶν αὐτῶν, ὕστερον ἐπείνασε. ");
INSERT INTO grctr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Καὶ εἶπεν αὐτῷ ὁ διάβολος, Εἰ υἱὸς εἶ τοῦ Θεοῦ, εἰπὲ τῷ λίθῳ τούτῳ ἵνα γένηται ἄρτος. ");
INSERT INTO grctr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Καὶ ἀπεκρίθη Ἰησοῦς πρὸς αὐτόν, λέγων, Γέγραπται ὅτι Οὐκ ἐπ᾿ ἄρτῳ μόνῳ ζήσεται ὁ ἄνθρωπος, ἀλλ᾿ ἐπὶ παντὶ ῥήματι Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Καὶ ἀναγαγὼν αὐτὸν ὁ διάβολος εἰς ὄρος ὑψηλὸν ἔδειξεν αὐτῷ πάσας τὰς βασιλείας τῆς οἰκουμένης ἐν στιγμῇ χρόνου. ");
INSERT INTO grctr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Καὶ εἶπεν αὐτῷ ὁ διάβολος, Σοὶ δώσω τὴν ἐξουσίαν ταύτην ἅπασαν καὶ τὴν δόξαν αὐτῶν· ὅτι ἐμοὶ παραδέδοται, καὶ ᾧ ἐὰν θέλω δίδωμι αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Σὺ οὖν ἐὰν προσκυνήσῃς ἐνώπιόν μου, ἔσται σοῦ πάντα. ");
INSERT INTO grctr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Καὶ ἀποκριθεὶς αὐτῷ εἶπεν ὁ Ἰησοῦς, Ὕπαγε ὀπίσω μου, Σατανᾶ· γέγραπται γάρ, Προσκυνήσεις Κύριον τὸν Θεόν σου, καὶ αὐτῷ μόνῳ λατρεύσεις. ");
INSERT INTO grctr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Καὶ ἤγαγεν αὐτὸν εἰς Ἱερουσαλήμ, καὶ ἔστησεν αὐτὸν ἐπὶ τὸ πτερύγιον τοῦ ἱεροῦ, καὶ εἶπεν αὐτῷ, Εἰ ὁ υἱὸς εἶ τοῦ Θεοῦ, βάλε σεαυτὸν ἐντεῦθεν κάτω· ");
INSERT INTO grctr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","γέγραπται γὰρ ὅτι Τοῖς ἀγγέλοις αὐτοῦ ἐντελεῖται περὶ σοῦ, τοῦ διαφυλάξαι σε· ");
INSERT INTO grctr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","καὶ ὅτι Ἐπὶ χειρῶν ἀροῦσί σε, μήποτε προσκόψῃς πρὸς λίθον τὸν πόδα σου. ");
INSERT INTO grctr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Καὶ ἀποκριθεὶς εἶπεν αὐτῷ ὁ Ἰησοῦς ὅτι Εἴρηται, Οὐκ ἐκπειράσεις Κύριον τὸν Θεόν σου. ");
INSERT INTO grctr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Καὶ συντελέσας πάντα πειρασμὸν ὁ διάβολος ἀπέστη ἀπ᾿ αὐτοῦ ἄχρι καιροῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Καὶ ὑπέστρεψεν ὁ Ἰησοῦς ἐν τῇ δυνάμει τοῦ πνεύματος εἰς τὴν Γαλιλαίαν· καὶ φήμη ἐξῆλθε καθ᾿ ὅλης τῆς περιχώρου περὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Καὶ αὐτὸς ἐδίδασκεν ἐν ταῖς συναγωγαῖς αὐτῶν, δοξαζόμενος ὑπὸ πάντων. ");
INSERT INTO grctr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Καὶ ἦλθεν εἰς τὴν Ναζαρέθ, οὗ ἦν τεθραμμένος· καὶ εἰσῆλθε, κατὰ τὸ εἰωθὸς αὐτῷ, ἐν τῇ ἡμέρᾳ τῶν σαββάτων εἰς τὴν συναγωγήν, καὶ ἀνέστη ἀναγνῶναι. ");
INSERT INTO grctr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Καὶ ἐπεδόθη αὐτῷ βιβλίον Ἠσαΐου τοῦ προφήτου. Καὶ ἀναπτύξας τὸ βιβλίον, εὗρε τὸν τόπον οὗ ἦν γεγραμμένον, ");
INSERT INTO grctr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Πνεῦμα Κυρίου ἐπ᾿ ἐμέ, οὗ ἕνεκεν ἔχρισέ με εὐαγγελίζεσθαι πτωχοῖς· ἀπέσταλκέ με ἰάσασθαι τοὺς συντετριμμένους τὴν καρδίαν· κηρύξαι αἰχμαλώτοις ἄφεσιν, καὶ τυφλοῖς ἀνάβλεψιν, ἀποστεῖλαι τεθραυσμένους ἐν ἀφέσει, ");
INSERT INTO grctr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","κηρύξαι ἐνιαυτὸν Κυρίου δεκτόν. ");
INSERT INTO grctr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Καὶ πτύξας τὸ βιβλίον, ἀποδοὺς τῷ ὑπηρέτῃ, ἐκάθισε· καὶ πάντων ἐν τῇ συναγωγῇ οἱ ὀφθαλμοὶ ἦσαν ἀτενίζοντες αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ἤρξατο δὲ λέγειν πρὸς αὐτοὺς ὅτι Σήμερον πεπλήρωται ἡ γραφὴ αὕτη ἐν τοῖς ὠσὶν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Καὶ πάντες ἐμαρτύρουν αὐτῷ, καὶ ἐθαύμαζον ἐπὶ τοῖς λόγοις τῆς χάριτος τοῖς ἐκπορευομένοις ἐκ τοῦ στόματος αὐτοῦ, καὶ ἔλεγον, Οὐχ οὗτός ἐστιν ὁ υἱὸς Ἰωσήφ; ");
INSERT INTO grctr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Καὶ εἶπε πρὸς αὐτούς, Πάντως ἐρεῖτέ μοι τὴν παραβολὴν ταύτην, Ἰατρέ, θεράπευσον σεαυτόν· ὅσα ἠκούσαμεν γενόμενα ἐν τῇ Καπερναούμ, ποίησον καὶ ὧδε ἐν τῇ πατρίδι σου. ");
INSERT INTO grctr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Εἶπε δέ, Ἀμὴν λέγω ὑμῖν ὅτι οὐδεὶς προφήτης δεκτός ἐστιν ἐν τῇ πατρίδι αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ἐπ᾿ ἀληθείας δὲ λέγω ὑμῖν, πολλαὶ χῆραι ἦσαν ἐν ταῖς ἡμέραις Ἠλίου ἐν τῷ Ἰσραήλ, ὅτε ἐκλείσθη ὁ οὐρανὸς ἐπὶ ἔτη τρία καὶ μῆνας ἕξ, ὡς ἐγένετο λιμὸς μέγας ἐπὶ πᾶσαν τὴν γῆν· ");
INSERT INTO grctr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","καὶ πρὸς οὐδεμίαν αὐτῶν ἐπέμφθη Ἠλίας, εἰ μὴ εἰς Σάρεπτα τῆς Σιδῶνος πρὸς γυναῖκα χήραν. ");
INSERT INTO grctr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Καὶ πολλοὶ λεπροὶ ἦσαν ἐπὶ Ἐλισσαίου τοῦ προφήτου ἐν τῷ Ἰσραήλ· καὶ οὐδεὶς αὐτῶν ἐκαθαρίσθη, εἰ μὴ Νεεμὰν ὁ Σύρος. ");
INSERT INTO grctr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Καὶ ἐπλήσθησαν πάντες θυμοῦ ἐν τῇ συναγωγῇ, ἀκούοντες ταῦτα, ");
INSERT INTO grctr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","καὶ ἀναστάντες ἐξέβαλον αὐτὸν ἔξω τῆς πόλεως, καὶ ἤγαγον αὐτὸν ἕως τῆς ὀφρύος τοῦ ὄρους ἐφ᾿ οὗ ἡ πόλις αὐτῶν ᾠκοδόμητο, εἰς τὸ κατακρημνίσαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Αὐτὸς δὲ διελθὼν διὰ μέσου αὐτῶν ἐπορεύετο. ");
INSERT INTO grctr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Καὶ κατῆλθεν εἰς Καπερναοὺμ πόλιν τῆς Γαλιλαίας· καὶ ἦν διδάσκων αὐτοὺς ἐν τοῖς σάββασι. ");
INSERT INTO grctr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Καὶ ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ, ὅτι ἐν ἐξουσίᾳ ἦν ὁ λόγος αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Καὶ ἐν τῇ συναγωγῇ ἦν ἄνθρωπος ἔχων πνεῦμα δαιμονίου ἀκαθάρτου, καὶ ἀνέκραξε φωνῇ μεγάλῃ, ");
INSERT INTO grctr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","λέγων, Ἔα, τί ἡμῖν καὶ σοί, Ἰησοῦ Ναζαρηνέ; Ἦλθες ἀπολέσαι ἡμᾶς; Οἶδά σε τίς εἶ, ὁ ἅγιος τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς, λέγων, Φιμώθητι, καὶ ἔξελθε ἐξ αὐτοῦ. Καὶ ῥίψαν αὐτὸν τὸ δαιμόνιον εἰς τὸ μέσον ἐξῆλθεν ἀπ᾿ αὐτοῦ, μηδὲν βλάψαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Καὶ ἐγένετο θάμβος ἐπὶ πάντας, καὶ συνελάλουν πρὸς ἀλλήλους, λέγοντες, Τίς ὁ λόγος οὗτος, ὅτι ἐν ἐξουσίᾳ καὶ δυνάμει ἐπιτάσσει τοῖς ἀκαθάρτοις πνεύμασι, καὶ ἐξέρχονται; ");
INSERT INTO grctr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Καὶ ἐξεπορεύετο ἦχος περὶ αὐτοῦ εἰς πάντα τόπον τῆς περιχώρου. ");
INSERT INTO grctr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ἀναστὰς δὲ ἐκ τῆς συναγωγῆς, εἰσῆλθεν εἰς τὴν οἰκίαν Σίμωνος· ἡ πενθερὰ δὲ τοῦ Σίμωνος ἦν συνεχομένη πυρετῷ μεγάλῳ· καὶ ἠρώτησαν αὐτὸν περὶ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Καὶ ἐπιστὰς ἐπάνω αὐτῆς, ἐπετίμησε τῷ πυρετῷ, καὶ ἀφῆκεν αὐτήν· παραχρῆμα δὲ ἀναστᾶσα διηκόνει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Δύνοντος δὲ τοῦ ἡλίου, πάντες ὅσοι εἶχον ἀσθενοῦντας νόσοις ποικίλαις ἤγαγον αὐτοὺς πρὸς αὐτόν· ὁ δὲ ἑνὶ ἑκάστῳ αὐτῶν τὰς χεῖρας ἐπιθεὶς ἐθεράπευσεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ἐξήρχετο δὲ καὶ δαιμόνια ἀπὸ πολλῶν, κράζοντα καὶ λέγοντα ὅτι Σὺ εἶ ὁ Χριστὸς ὁ υἱὸς τοῦ Θεοῦ. Καὶ ἐπιτιμῶν οὐκ εἴα αὐτὰ λαλεῖν, ὅτι ᾔδεισαν τὸν Χριστὸν αὐτὸν εἶναι. ");
INSERT INTO grctr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Γενομένης δὲ ἡμέρας, ἐξελθὼν ἐπορεύθη εἰς ἔρημον τόπον, καὶ οἱ ὄχλοι ἐζήτουν αὐτόν, καὶ ἦλθον ἕως αὐτοῦ, καὶ κατεῖχον αὐτὸν τοῦ μὴ πορεύεσθαι ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ὁ δὲ εἶπε πρὸς αὐτοὺς ὅτι Καὶ ταῖς ἑτέραις πόλεσιν εὐαγγελίσασθαί με δεῖ τὴν βασιλείαν τοῦ Θεοῦ· ὅτι εἰς τοῦτο ἀπέσταλμαι. ");
INSERT INTO grctr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Καὶ ἦν κηρύσσων ἐν ταῖς συναγωγαῖς τῆς Γαλιλαίας. ");
INSERT INTO grctr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ἐγένετο δὲ ἐν τῷ τὸν ὄχλον ἐπικεῖσθαι αὐτῷ τοῦ ἀκούειν τὸν λόγον τοῦ Θεοῦ, καὶ αὐτὸς ἦν ἑστὼς παρὰ τὴν λίμνην Γεννησαρέτ· ");
INSERT INTO grctr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","καὶ εἶδε δύο πλοῖα ἑστῶτα παρὰ τὴν λίμνην· οἱ δὲ ἁλιεῖς ἀποβάντες ἀπ᾿ αὐτῶν ἀπέπλυναν τὰ δίκτυα. ");
INSERT INTO grctr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ἐμβὰς δὲ εἰς ἓν τῶν πλοίων, ὃ ἦν τοῦ Σίμωνος, ἠρώτησεν αὐτὸν ἀπὸ τῆς γῆς ἐπαναγαγεῖν ὀλίγον. Καὶ καθίσας ἐδίδασκεν ἐκ τοῦ πλοίου τοὺς ὄχλους. ");
INSERT INTO grctr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ὡς δὲ ἐπαύσατο λαλῶν, εἶπε πρὸς τὸν Σίμωνα, Ἐπανάγαγε εἰς τὸ βάθος, καὶ χαλάσατε τὰ δίκτυα ὑμῶν εἰς ἄγραν. ");
INSERT INTO grctr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Καὶ ἀποκριθεὶς ὁ Σίμων εἶπεν αὐτῷ, Ἐπιστάτα, δι᾿ ὅλης τῆς νυκτὸς κοπιάσαντες οὐδὲν ἐλάβομεν· ἐπὶ δὲ τῷ ῥήματί σου χαλάσω τὸ δίκτυον. ");
INSERT INTO grctr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Καὶ τοῦτο ποιήσαντες, συνέκλεισαν ἰχθύων πλῆθος πολύ· διερρήγνυτο δὲ τὸ δίκτυον αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","καὶ κατένευσαν τοῖς μετόχοις τοῖς ἐν τῷ ἑτέρῳ πλοίῳ, τοῦ ἐλθόντας συλλαβέσθαι αὐτοῖς· καὶ ἦλθον καὶ ἔπλησαν ἀμφότερα τὰ πλοῖα, ὥστε βυθίζεσθαι αὐτά. ");
INSERT INTO grctr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ἰδὼν δὲ Σίμων Πέτρος προσέπεσε τοῖς γόνασι τοῦ Ἰησοῦ, λέγων, Ἔξελθε ἀπ᾿ ἐμοῦ, ὅτι ἀνὴρ ἁμαρτωλός εἰμι, Κύριε. ");
INSERT INTO grctr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Θάμβος γὰρ περιέσχεν αὐτὸν καὶ πάντας τοὺς σὺν αὐτῷ, ἐπὶ τῇ ἄγρᾳ τῶν ἰχθύων ᾗ συνέλαβον· ");
INSERT INTO grctr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ὁμοίως δὲ καὶ Ἰάκωβον καὶ Ἰωάννην, υἱοὺς Ζεβεδαίου, οἳ ἦσαν κοινωνοὶ τῷ Σίμωνι. Καὶ εἶπε πρὸς τὸν Σίμωνα ὁ Ἰησοῦς, Μὴ φοβοῦ· ἀπὸ τοῦ νῦν ἀνθρώπους ἔσῃ ζωγρῶν. ");
INSERT INTO grctr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Καὶ καταγαγόντες τὰ πλοῖα ἐπὶ τὴν γῆν, ἀφέντες ἅπαντα, ἠκολούθησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Καὶ ἐγένετο, ἐν τῷ εἶναι αὐτὸν ἐν μιᾷ τῶν πόλεων, καὶ ἰδού, ἀνὴρ πλήρης λέπρας· καὶ ἰδὼν τὸν Ἰησοῦν, πεσὼν ἐπὶ πρόσωπον, ἐδεήθη αὐτοῦ, λέγων, Κύριε, ἐὰν θέλῃς, δύνασαί με καθαρίσαι. ");
INSERT INTO grctr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Καὶ ἐκτείνας τὴν χεῖρα ἥψατο αὐτοῦ, εἰπών, Θέλω, καθαρίσθητι. Καὶ εὐθέως ἡ λέπρα ἀπῆλθεν ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Καὶ αὐτὸς παρήγγειλεν αὐτῷ μηδενὶ εἰπεῖν· ἀλλὰ ἀπελθὼν δεῖξον σεαυτὸν τῷ ἱερεῖ, καὶ προσένεγκε περὶ τοῦ καθαρισμοῦ σου, καθὼς προσέταξε Μωσῆς, εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Διήρχετο δὲ μᾶλλον ὁ λόγος περὶ αὐτοῦ· καὶ συνήρχοντο ὄχλοι πολλοὶ ἀκούειν, καὶ θεραπεύεσθαι ὑπ᾿ αὐτοῦ ἀπὸ τῶν ἀσθενειῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Αὐτὸς δὲ ἦν ὑποχωρῶν ἐν ταῖς ἐρήμοις καὶ προσευχόμενος. ");
INSERT INTO grctr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Καὶ ἐγένετο ἐν μιᾷ τῶν ἡμερῶν, καὶ αὐτὸς ἦν διδάσκων· καὶ ἦσαν καθήμενοι Φαρισαῖοι καὶ νομοδιδάσκαλοι, οἳ ἦσαν ἐληλυθότες ἐκ πάσης κώμης τῆς Γαλιλαίας καὶ Ἰουδαίας καὶ Ἱερουσαλήμ· καὶ δύναμις Κυρίου ἦν εἰς τὸ ἰᾶσθαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Καὶ ἰδού, ἄνδρες φέροντες ἐπὶ κλίνης ἄνθρωπον ὃς ἦν παραλελυμένος, καὶ ἐζήτουν αὐτὸν εἰσενεγκεῖν καὶ θεῖναι ἐνώπιον αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","καὶ μὴ εὑρόντες διὰ ποίας εἰσενέγκωσιν αὐτὸν διὰ τὸν ὄχλον, ἀναβάντες ἐπὶ τὸ δῶμα, διὰ τῶν κεράμων καθῆκαν αὐτὸν σὺν τῷ κλινιδίῳ εἰς τὸ μέσον ἔμπροσθεν τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Καὶ ἰδὼν τὴν πίστιν αὐτῶν, εἶπεν αὐτῷ, Ἄνθρωπε, ἀφέωνταί σοι αἱ ἁμαρτίαι σου. ");
INSERT INTO grctr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Καὶ ἤρξαντο διαλογίζεσθαι οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι, λέγοντες, Τίς ἐστιν οὗτος ὃς λαλεῖ βλασφημίας; Τίς δύναται ἀφιέναι ἁμαρτίας, εἰ μὴ μόνος ὁ Θεός; ");
INSERT INTO grctr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ἐπιγνοὺς δὲ ὁ Ἰησοῦς τοὺς διαλογισμοὺς αὐτῶν ἀποκριθεὶς εἶπε πρὸς αὐτούς, Τί διαλογίζεσθε ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Τί ἐστιν εὐκοπώτερον, εἰπεῖν, Ἀφέωνταί σοι αἱ ἁμαρτίαι σου, ἢ εἰπεῖν, Ἔγειραι καὶ περιπάτει; ");
INSERT INTO grctr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ἵνα δὲ εἰδῆτε ὅτι ἐξουσίαν ἔχει ὁ υἱὸς τοῦ ἀνθρώπου ἐπὶ τῆς γῆς ἀφιέναι ἁμαρτίας — εἶπε τῷ παραλελυμένῳ — Σοὶ λέγω, ἔγειραι, καὶ ἄρας τὸ κλινίδιόν σου, πορεύου εἰς τὸν οἶκόν σου. ");
INSERT INTO grctr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Καὶ παραχρῆμα ἀναστὰς ἐνώπιον αὐτῶν, ἄρας ἐφ᾿ ᾧ κατέκειτο, ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ, δοξάζων τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Καὶ ἔκστασις ἔλαβεν ἅπαντας, καὶ ἐδόξαζον τὸν Θεόν, καὶ ἐπλήσθησαν φόβου, λέγοντες ὅτι Εἴδομεν παράδοξα σήμερον. ");
INSERT INTO grctr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Καὶ μετὰ ταῦτα ἐξῆλθε, καὶ ἐθεάσατο τελώνην, ὀνόματι Λευΐν, καθήμενον ἐπὶ τὸ τελώνιον, καὶ εἶπεν αὐτῷ, Ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Καὶ καταλιπὼν ἅπαντα, ἀναστὰς ἠκολούθησεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Καὶ ἐποίησε δοχὴν μεγάλην ὁ Λευῒς αὐτῷ ἐν τῇ οἰκίᾳ αὐτοῦ· καὶ ἦν ὄχλος τελωνῶν πολύς, καὶ ἄλλων οἳ ἦσαν μετ᾿ αὐτῶν κατακείμενοι. ");
INSERT INTO grctr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Καὶ ἐγόγγυζον οἱ γραμματεῖς αὐτῶν καὶ οἱ Φαρισαῖοι πρὸς τοὺς μαθητὰς αὐτοῦ, λέγοντες, Διὰ τί μετὰ τελωνῶν καὶ ἁμαρτωλῶν ἐσθίετε καὶ πίνετε; ");
INSERT INTO grctr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπε πρὸς αὐτούς, Οὐ χρείαν ἔχουσιν οἱ ὑγιαίνοντες ἰατροῦ, ἀλλ᾿ οἱ κακῶς ἔχοντες. ");
INSERT INTO grctr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Οὐκ ἐλήλυθα καλέσαι δικαίους, ἀλλὰ ἁμαρτωλοὺς εἰς μετάνοιαν. ");
INSERT INTO grctr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Οἱ δὲ εἶπον πρὸς αὐτόν, Διὰ τί οἱ μαθηταὶ Ἰωάννου νηστεύουσι πυκνά, καὶ δεήσεις ποιοῦνται, ὁμοίως καὶ οἱ τῶν Φαρισαίων· οἱ δὲ σοὶ ἐσθίουσι καὶ πίνουσιν; ");
INSERT INTO grctr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ὁ δὲ εἶπε πρὸς αὐτούς, Μὴ δύνασθε τοὺς υἱοὺς τοῦ νυμφῶνος, ἐν ᾧ ὁ νυμφίος μετ᾿ αὐτῶν ἐστι, ποιῆσαι νηστεύειν; ");
INSERT INTO grctr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ἐλεύσονται δὲ ἡμέραι, καὶ ὅταν ἀπαρθῇ ἀπ᾿ αὐτῶν ὁ νυμφίος, τότε νηστεύσουσιν ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grctr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ἔλεγε δὲ καὶ παραβολὴν πρὸς αὐτοὺς ὅτι Οὐδεὶς ἐπίβλημα ἱματίου καινοῦ ἐπιβάλλει ἐπὶ ἱμάτιον παλαιόν· εἰ δὲ μήγε, καὶ τὸ καινὸν σχίζει, καὶ τῷ παλαιῷ οὐ συμφωνεῖ ἐπίβλημα τὸ ἀπὸ τοῦ καινοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Καὶ οὐδεὶς βάλλει οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μήγε, ῥήξει ὁ νέος οἶνος τοὺς ἀσκούς, καὶ αὐτὸς ἐκχυθήσεται, καὶ οἱ ἀσκοὶ ἀπολοῦνται. ");
INSERT INTO grctr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ἀλλὰ οἶνον νέον εἰς ἀσκοὺς καινοὺς βλητέον, καὶ ἀμφότεροι συντηροῦνται. ");
INSERT INTO grctr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Καὶ οὐδεὶς πιὼν παλαιὸν εὐθέως θέλει νέον· λέγει γάρ, Ὁ παλαιὸς χρηστότερός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ἐγένετο δὲ ἐν σαββάτῳ δευτεροπρώτῳ διαπορεύεσθαι αὐτὸν διὰ τῶν σπορίμων· καὶ ἔτιλλον οἱ μαθηταὶ αὐτοῦ τοὺς στάχυας, καὶ ἤσθιον, ψώχοντες ταῖς χερσί. ");
INSERT INTO grctr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Τινὲς δὲ τῶν Φαρισαίων εἶπον αὐτοῖς, Τί ποιεῖτε ὃ οὐκ ἔξεστι ποιεῖν ἐν τοῖς σάββασι; ");
INSERT INTO grctr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Καὶ ἀποκριθεὶς πρὸς αὐτοὺς εἶπεν ὁ Ἰησοῦς, Οὐδὲ τοῦτο ἀνέγνωτε, ὃ ἐποίησε Δαβίδ, ὁπότε ἐπείνασεν αὐτὸς καὶ οἱ μετ᾿ αὐτοῦ ὄντες; ");
INSERT INTO grctr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ὡς εἰσῆλθεν εἰς τὸν οἶκον τοῦ Θεοῦ, καὶ τοὺς ἄρτους τῆς προθέσεως ἔλαβε, καὶ ἔφαγε, καὶ ἔδωκε καὶ τοῖς μετ᾿ αὐτοῦ, οὓς οὐκ ἔξεστι φαγεῖν εἰ μὴ μόνους τοὺς ἱερεῖς; ");
INSERT INTO grctr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Καὶ ἔλεγεν αὐτοῖς ὅτι Κύριός ἐστιν ὁ υἱὸς τοῦ ἀνθρώπου καὶ τοῦ σαββάτου. ");
INSERT INTO grctr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ἐγένετο δὲ καὶ ἐν ἑτέρῳ σαββάτῳ εἰσελθεῖν αὐτὸν εἰς τὴν συναγωγὴν καὶ διδάσκειν· καὶ ἦν ἐκεῖ ἄνθρωπος, καὶ ἡ χεὶρ αὐτοῦ ἡ δεξιὰ ἦν ξηρά. ");
INSERT INTO grctr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Παρετήρουν δὲ αὐτὸν οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι, εἰ ἐν τῷ σαββάτῳ θεραπεύσει· ἵνα εὕρωσι κατηγορίαν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Αὐτὸς δὲ ᾔδει τοὺς διαλογισμοὺς αὐτῶν, καὶ εἶπε τῷ ἀνθρώπῳ τῷ ξηρὰν ἔχοντι τὴν χεῖρα, Ἔγειραι, καὶ στῆθι εἰς τὸ μέσον. Ὁ δὲ ἀναστὰς ἔστη. ");
INSERT INTO grctr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Εἶπεν οὖν ὁ Ἰησοῦς πρὸς αὐτούς, Ἐπερωτήσω ὑμᾶς τί, Ἔξεστι τοῖς σάββασιν ἀγαθοποιῆσαι ἢ κακοποιῆσαι; Ψυχὴν σῶσαι ἢ ἀπολέσαι; ");
INSERT INTO grctr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Καὶ περιβλεψάμενος πάντας αὐτούς, εἶπε τῷ ἀνθρώπῳ, Ἔκτεινον τὴν χεῖρά σου. Ὁ δὲ ἐποίησεν οὕτω· καὶ ἀποκατεστάθη ἡ χεὶρ αὐτοῦ ὑγιὴς ὡς ἡ ἄλλη. ");
INSERT INTO grctr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Αὐτοὶ δὲ ἐπλήσθησαν ἀνοίας· καὶ διελάλουν πρὸς ἀλλήλους, τί ἂν ποιήσειαν τῷ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ταύταις ἐξῆλθεν εἰς τὸ ὄρος προσεύξασθαι· καὶ ἦν διανυκτερεύων ἐν τῇ προσευχῇ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Καὶ ὅτε ἐγένετο ἡμέρα, προσεφώνησε τοὺς μαθητὰς αὐτοῦ· καὶ ἐκλεξάμενος ἀπ᾿ αὐτῶν δώδεκα, οὓς καὶ ἀποστόλους ὠνόμασε, ");
INSERT INTO grctr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Σίμωνα ὃν καὶ ὠνόμασε Πέτρον, καὶ Ἀνδρέαν τὸν ἀδελφὸν αὐτοῦ, Ἰάκωβον καὶ Ἰωάννην, Φίλιππον καὶ Βαρθολομαῖον, ");
INSERT INTO grctr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ματθαῖον καὶ Θωμᾶν, Ἰάκωβον τὸν τοῦ Ἁλφαίου, καὶ Σίμωνα τὸν καλούμενον Ζηλωτήν, ");
INSERT INTO grctr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ἰούδαν Ἰακώβου, καὶ Ἰούδαν Ἰσκαριώτην, ὃς καὶ ἐγένετο προδότης. ");
INSERT INTO grctr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Καὶ καταβὰς μετ᾿ αὐτῶν, ἔστη ἐπὶ τόπου πεδινοῦ, καὶ ὄχλος μαθητῶν αὐτοῦ, καὶ πλῆθος πολὺ τοῦ λαοῦ ἀπὸ πάσης τῆς Ἰουδαίας καὶ Ἱερουσαλήμ, καὶ τῆς παραλίου Τύρου καὶ Σιδῶνος, οἳ ἦλθον ἀκοῦσαι αὐτοῦ, καὶ ἰαθῆναι ἀπὸ τῶν νόσων αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","καὶ οἱ ὀχλούμενοι ὑπὸ πνευμάτων ἀκαθάρτων, καὶ ἐθεραπεύοντο. ");
INSERT INTO grctr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Καὶ πᾶς ὁ ὄχλος ἐζήτει ἅπτεσθαι αὐτοῦ· ὅτι δύναμις παρ᾿ αὐτοῦ ἐξήρχετο καὶ ἰᾶτο πάντας. ");
INSERT INTO grctr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Καὶ αὐτὸς ἐπάρας τοὺς ὀφθαλμοὺς αὐτοῦ εἰς τοὺς μαθητὰς αὐτοῦ ἔλεγε, Μακάριοι οἱ πτωχοί, ὅτι ὑμετέρα ἐστὶν ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Μακάριοι οἱ πεινῶντες νῦν, ὅτι χορτασθήσεσθε. Μακάριοι οἱ κλαίοντες νῦν, ὅτι γελάσετε. ");
INSERT INTO grctr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Μακάριοί ἐστε, ὅταν μισήσωσιν ὑμᾶς οἱ ἄνθρωποι, καὶ ὅταν ἀφορίσωσιν ὑμᾶς, καὶ ὀνειδίσωσι, καὶ ἐκβάλωσι τὸ ὄνομα ὑμῶν ὡς πονηρόν, ἕνεκα τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Χαίρετε ἐν ἐκείνῃ τῇ ἡμέρᾳ καὶ σκιρτήσατε· ἰδοὺ γάρ, ὁ μισθὸς ὑμῶν πολὺς ἐν τῷ οὐρανῷ· κατὰ ταῦτα γὰρ ἐποίουν τοῖς προφήταις οἱ πατέρες αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Πλὴν οὐαὶ ὑμῖν τοῖς πλουσίοις, ὅτι ἀπέχετε τὴν παράκλησιν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Οὐαὶ ὑμῖν, οἱ ἐμπεπλησμένοι, ὅτι πεινάσετε. Οὐαὶ ὑμῖν, οἱ γελῶντες νῦν, ὅτι πενθήσετε καὶ κλαύσετε. ");
INSERT INTO grctr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Οὐαὶ ὑμῖν, ὅταν καλῶς ὑμᾶς εἴπωσι πάντες οἱ ἄνθρωποι· κατὰ ταῦτα γὰρ ἐποίουν τοῖς ψευδοπροφήταις οἱ πατέρες αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ἀλλ᾿ ὑμῖν λέγω τοῖς ἀκούουσιν, Ἀγαπᾶτε τοὺς ἐχθροὺς ὑμῶν, καλῶς ποιεῖτε τοῖς μισοῦσιν ὑμᾶς, ");
INSERT INTO grctr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","εὐλογεῖτε τοὺς καταρωμένους ὑμῖν, καὶ προσεύχεσθε ὑπὲρ τῶν ἐπηρεαζόντων ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Τῷ τύπτοντί σε ἐπὶ τὴν σιαγόνα, πάρεχε καὶ τὴν ἄλλην· καὶ ἀπὸ τοῦ αἴροντός σου τὸ ἱμάτιον, καὶ τὸν χιτῶνα μὴ κωλύσῃς. ");
INSERT INTO grctr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Παντὶ δὲ τῷ αἰτοῦντί σε δίδου· καὶ ἀπὸ τοῦ αἴροντος τὰ σὰ μὴ ἀπαίτει. ");
INSERT INTO grctr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Καὶ καθὼς θέλετε ἵνα ποιῶσιν ὑμῖν οἱ ἄνθρωποι, καὶ ὑμεῖς ποιεῖτε αὐτοῖς ὁμοίως. ");
INSERT INTO grctr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Καὶ εἰ ἀγαπᾶτε τοὺς ἀγαπῶντας ὑμᾶς, ποία ὑμῖν χάρις ἐστί; Καὶ γὰρ οἱ ἁμαρτωλοὶ τοὺς ἀγαπῶντας αὐτοὺς ἀγαπῶσι. ");
INSERT INTO grctr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Καὶ ἐὰν ἀγαθοποιῆτε τοὺς ἀγαθοποιοῦντας ὑμᾶς, ποία ὑμῖν χάρις ἐστί; Καὶ γὰρ οἱ ἁμαρτωλοὶ τὸ αὐτὸ ποιοῦσι. ");
INSERT INTO grctr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Καὶ ἐὰν δανείζητε παρ᾿ ὧν ἐλπίζετε ἀπολαβεῖν, ποία ὑμῖν χάρις ἐστί; Καὶ γὰρ οἱ ἁμαρτωλοὶ ἁμαρτωλοῖς δανείζουσιν, ἵνα ἀπολάβωσι τὰ ἴσα. ");
INSERT INTO grctr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Πλὴν ἀγαπᾶτε τοὺς ἐχθροὺς ὑμῶν, καὶ ἀγαθοποιεῖτε, καὶ δανείζετε, μηδὲν ἀπελπίζοντες· καὶ ἔσται ὁ μισθὸς ὑμῶν πολύς, καὶ ἔσεσθε υἱοὶ τοῦ ὑψίστου· ὅτι αὐτὸς χρηστός ἐστιν ἐπὶ τοὺς ἀχαρίστους καὶ πονηρούς. ");
INSERT INTO grctr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Γίνεσθε οὖν οἰκτίρμονες, καθὼς καὶ ὁ πατὴρ ὑμῶν οἰκτίρμων ἐστί. ");
INSERT INTO grctr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Καὶ μὴ κρίνετε, καὶ οὐ μὴ κριθῆτε. Μὴ καταδικάζετε, καὶ οὐ μὴ καταδικασθῆτε· ἀπολύετε, καὶ ἀπολυθήσεσθε· ");
INSERT INTO grctr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","δίδοτε, καὶ δοθήσεται ὑμῖν· μέτρον καλόν, πεπιεσμένον καὶ σεσαλευμένον καὶ ὑπερεκχυνόμενον δώσουσιν εἰς τὸν κόλπον ὑμῶν. Τῷ γὰρ αὐτῷ μέτρῳ ᾧ μετρεῖτε ἀντιμετρηθήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Εἶπε δὲ παραβολὴν αὐτοῖς, Μήτι δύναται τυφλὸς τυφλὸν ὁδηγεῖν; Οὐχὶ ἀμφότεροι εἰς βόθυνον πεσοῦνται; ");
INSERT INTO grctr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Οὐκ ἔστι μαθητὴς ὑπὲρ τὸν διδάσκαλον αὐτοῦ· κατηρτισμένος δὲ πᾶς ἔσται ὡς ὁ διδάσκαλος αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Τί δὲ βλέπεις τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου, τὴν δὲ δοκὸν τὴν ἐν τῷ ἰδίῳ ὀφθαλμῷ οὐ κατανοεῖς; ");
INSERT INTO grctr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ἢ πῶς δύνασαι λέγειν τῷ ἀδελφῷ σου, Ἀδελφέ, ἄφες ἐκβάλω τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ σου, αὐτὸς τὴν ἐν τῷ ὀφθαλμῷ σου δοκὸν οὐ βλέπων; Ὑποκριτά, ἔκβαλε πρῶτον τὴν δοκὸν ἐκ τοῦ ὀφθαλμοῦ σου, καὶ τότε διαβλέψεις ἐκβαλεῖν τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου. ");
INSERT INTO grctr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Οὐ γάρ ἐστι δένδρον καλὸν ποιοῦν καρπὸν σαπρόν· οὐδὲ δένδρον σαπρὸν ποιοῦν καρπὸν καλόν. ");
INSERT INTO grctr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ἕκαστον γὰρ δένδρον ἐκ τοῦ ἰδίου καρποῦ γινώσκεται. Οὐ γὰρ ἐξ ἀκανθῶν συλλέγουσι σῦκα, οὐδὲ ἐκ βάτου τρυγῶσι σταφυλήν. ");
INSERT INTO grctr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ὁ ἀγαθὸς ἄνθρωπος ἐκ τοῦ ἀγαθοῦ θησαυροῦ τῆς καρδίας αὐτοῦ προφέρει τὸ ἀγαθόν, καὶ ὁ πονηρὸς ἄνθρωπος ἐκ τοῦ πονηροῦ θησαυροῦ τῆς καρδίας αὐτοῦ προφέρει τὸ πονηρόν· ἐκ γὰρ τοῦ περισσεύματος τῆς καρδίας λαλεῖ τὸ στόμα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Τί δέ με καλεῖτε, Κύριε, Κύριε, καὶ οὐ ποιεῖτε ἃ λέγω; ");
INSERT INTO grctr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Πᾶς ὁ ἐρχόμενος πρός με καὶ ἀκούων μου τῶν λόγων καὶ ποιῶν αὐτούς, ὑποδείξω ὑμῖν τίνι ἐστὶν ὅμοιος· ");
INSERT INTO grctr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδομοῦντι οἰκίαν, ὃς ἔσκαψε καὶ ἐβάθυνε, καὶ ἔθηκε θεμέλιον ἐπὶ τὴν πέτραν· πλημμύρας δὲ γενομένης, προσέρρηξεν ὁ ποταμὸς τῇ οἰκίᾳ ἐκείνῃ, καὶ οὐκ ἴσχυσε σαλεῦσαι αὐτήν· τεθεμελίωτο γὰρ ἐπὶ τὴν πέτραν. ");
INSERT INTO grctr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ὁ δὲ ἀκούσας καὶ μὴ ποιήσας ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδομήσαντι οἰκίαν ἐπὶ τὴν γῆν χωρὶς θεμελίου· ᾗ προσέρρηξεν ὁ ποταμός, καὶ εὐθέως ἔπεσε, καὶ ἐγένετο τὸ ῥῆγμα τῆς οἰκίας ἐκείνης μέγα. ");
INSERT INTO grctr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ἐπεὶ δὲ ἐπλήρωσε πάντα τὰ ῥήματα αὐτοῦ εἰς τὰς ἀκοὰς τοῦ λαοῦ, εἰσῆλθεν εἰς Καπερναούμ. ");
INSERT INTO grctr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ἑκατοντάρχου δέ τινος δοῦλος κακῶς ἔχων ἤμελλε τελευτᾷν, ὃς ἦν αὐτῷ ἔντιμος. ");
INSERT INTO grctr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ἀκούσας δὲ περὶ τοῦ Ἰησοῦ, ἀπέστειλε πρὸς αὐτὸν πρεσβυτέρους τῶν Ἰουδαίων, ἐρωτῶν αὐτὸν ὅπως ἐλθὼν διασώσῃ τὸν δοῦλον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Οἱ δέ, παραγενόμενοι πρὸς τὸν Ἰησοῦν, παρεκάλουν αὐτὸν σπουδαίως, λέγοντες ὅτι ἄξιός ἐστιν ᾧ παρέξει τοῦτο· ");
INSERT INTO grctr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ἀγαπᾷ γὰρ τὸ ἔθνος ἡμῶν, καὶ τὴν συναγωγὴν αὐτὸς ᾠκοδόμησεν ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ὁ δὲ Ἰησοῦς ἐπορεύετο σὺν αὐτοῖς. Ἤδη δὲ αὐτοῦ οὐ μακρὰν ἀπέχοντος ἀπὸ τῆς οἰκίας, ἔπεμψε πρὸς αὐτὸν ὁ ἑκατόνταρχος φίλους, λέγων αὐτῷ, Κύριε, μὴ σκύλλου· οὐ γάρ εἰμι ἱκανὸς ἵνα ὑπὸ τὴν στέγην μου εἰσέλθῃς· ");
INSERT INTO grctr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","διὸ οὐδὲ ἐμαυτὸν ἠξίωσα πρός σε ἐλθεῖν· ἀλλὰ εἰπὲ λόγῳ, καὶ ἰαθήσεται ὁ παῖς μου. ");
INSERT INTO grctr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Καὶ γὰρ ἐγὼ ἄνθρωπός εἰμι ὑπὸ ἐξουσίαν τασσόμενος, ἔχων ὑπ᾿ ἐμαυτὸν στρατιώτας, καὶ λέγω τούτῳ, Πορεύθητι, καὶ πορεύεται· καὶ ἄλλῳ, Ἔρχου, καὶ ἔρχεται· καὶ τῷ δούλῳ μου, Ποίησον τοῦτο, καὶ ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ἀκούσας δὲ ταῦτα ὁ Ἰησοῦς ἐθαύμασεν αὐτόν, καὶ στραφεὶς τῷ ἀκολουθοῦντι αὐτῷ ὄχλῳ εἶπε, Λέγω ὑμῖν, οὐδὲ ἐν τῷ Ἰσραὴλ τοσαύτην πίστιν εὗρον. ");
INSERT INTO grctr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Καὶ ὑποστρέψαντες οἱ πεμφθέντες εἰς τὸν οἶκον εὗρον τὸν ἀσθενοῦντα δοῦλον ὑγιαίνοντα. ");
INSERT INTO grctr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Καὶ ἐγένετο ἐν τῇ ἑξῆς, ἐπορεύετο εἰς πόλιν καλουμένην Ναΐν· καὶ συνεπορεύοντο αὐτῷ οἱ μαθηταὶ αὐτοῦ ἱκανοί, καὶ ὄχλος πολύς. ");
INSERT INTO grctr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ὡς δὲ ἤγγισε τῇ πύλῃ τῆς πόλεως, καὶ ἰδού, ἐξεκομίζετο τεθνηκώς, υἱὸς μονογενὴς τῇ μητρὶ αὐτοῦ, καὶ αὕτη ἦν χήρα· καὶ ὄχλος τῆς πόλεως ἱκανὸς ἦν σὺν αὐτῇ. ");
INSERT INTO grctr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Καὶ ἰδὼν αὐτὴν ὁ Κύριος ἐσπλαγχνίσθη ἐπ᾿ αὐτῇ, καὶ εἶπεν αὐτῇ, Μὴ κλαῖε. ");
INSERT INTO grctr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Καὶ προσελθὼν ἥψατο τῆς σοροῦ· οἱ δὲ βαστάζοντες ἔστησαν. Καὶ εἶπε, Νεανίσκε, σοὶ λέγω, ἐγέρθητι. ");
INSERT INTO grctr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Καὶ ἀνεκάθισεν ὁ νεκρός, καὶ ἤρξατο λαλεῖν. Καὶ ἔδωκεν αὐτὸν τῇ μητρὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ἔλαβε δὲ φόβος ἅπαντας, καὶ ἐδόξαζον τὸν Θεόν, λέγοντες ὅτι Προφήτης μέγας ἐγήγερται ἐν ἡμῖν, καὶ ὅτι Ἐπεσκέψατο ὁ Θεὸς τὸν λαὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Καὶ ἐξῆλθεν ὁ λόγος οὗτος ἐν ὅλῃ τῇ Ἰουδαίᾳ περὶ αὐτοῦ, καὶ ἐν πάσῃ τῇ περιχώρῳ. ");
INSERT INTO grctr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Καὶ ἀπήγγειλαν Ἰωάννῃ οἱ μαθηταὶ αὐτοῦ περὶ πάντων τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Καὶ προσκαλεσάμενος δύο τινὰς τῶν μαθητῶν αὐτοῦ ὁ Ἰωάννης ἔπεμψε πρὸς τὸν Ἰησοῦν, λέγων, Σὺ εἶ ὁ ἐρχόμενος, ἢ ἄλλον προσδοκῶμεν; ");
INSERT INTO grctr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Παραγενόμενοι δὲ πρὸς αὐτὸν οἱ ἄνδρες εἶπον, Ἰωάννης ὁ βαπτιστὴς ἀπέσταλκεν ἡμᾶς πρός σε, λέγων, Σὺ εἶ ὁ ἐρχόμενος, ἢ ἄλλον προσδοκῶμεν; ");
INSERT INTO grctr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ἐν αὐτῇ δὲ τῇ ὥρᾳ ἐθεράπευσε πολλοὺς ἀπὸ νόσων καὶ μαστίγων καὶ πνευμάτων πονηρῶν, καὶ τυφλοῖς πολλοῖς ἐχαρίσατο τὸ βλέπειν. ");
INSERT INTO grctr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Πορευθέντες ἀπαγγείλατε Ἰωάννῃ ἃ εἴδετε καὶ ἠκούσατε· ὅτι τυφλοὶ ἀναβλέπουσι, χωλοὶ περιπατοῦσι, λεπροὶ καθαρίζονται, κωφοὶ ἀκούουσι, νεκροὶ ἐγείρονται, πτωχοὶ εὐαγγελίζονται· ");
INSERT INTO grctr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","καὶ μακάριός ἐστιν, ὃς ἐὰν μὴ σκανδαλισθῇ ἐν ἐμοί. ");
INSERT INTO grctr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ἀπελθόντων δὲ τῶν ἀγγέλων Ἰωάννου, ἤρξατο λέγειν πρὸς τοὺς ὄχλους περὶ Ἰωάννου, Τί ἐξεληλύθατε εἰς τὴν ἔρημον θεάσασθαι; Κάλαμον ὑπὸ ἀνέμου σαλευόμενον; ");
INSERT INTO grctr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ἀλλὰ τί ἐξεληλύθατε ἰδεῖν; Ἄνθρωπον ἐν μαλακοῖς ἱματίοις ἠμφιεσμένον; Ἰδού, οἱ ἐν ἱματισμῷ ἐνδόξῳ καὶ τρυφῇ ὑπάρχοντες ἐν τοῖς βασιλείοις εἰσίν. ");
INSERT INTO grctr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ἀλλὰ τί ἐξεληλύθατε ἰδεῖν; Προφήτην; Ναί, λέγω ὑμῖν, καὶ περισσότερον προφήτου. ");
INSERT INTO grctr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Οὗτός ἐστι περὶ οὗ γέγραπται, Ἰδού, ἐγὼ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν σου ἔμπροσθέν σου. ");
INSERT INTO grctr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Λέγω γὰρ ὑμῖν, μείζων ἐν γεννητοῖς γυναικῶν προφήτης Ἰωάννου τοῦ βαπτιστοῦ οὐδείς ἐστιν· ὁ δὲ μικρότερος ἐν τῇ βασιλείᾳ τοῦ Θεοῦ μείζων αὐτοῦ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Καὶ πᾶς ὁ λαὸς ἀκούσας καὶ οἱ τελῶναι ἐδικαίωσαν τὸν Θεόν, βαπτισθέντες τὸ βάπτισμα Ἰωάννου· ");
INSERT INTO grctr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","οἱ δὲ Φαρισαῖοι καὶ οἱ νομικοὶ τὴν βουλὴν τοῦ Θεοῦ ἠθέτησαν εἰς ἑαυτούς, μὴ βαπτισθέντες ὑπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Εἶπε δὲ ὁ Κύριος, Τίνι οὖν ὁμοιώσω τοὺς ἀνθρώπους τῆς γενεᾶς ταύτης, καὶ τίνι εἰσὶν ὅμοιοι; ");
INSERT INTO grctr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ὅμοιοί εἰσι παιδίοις τοῖς ἐν ἀγορᾷ καθημένοις, καὶ προσφωνοῦσιν ἀλλήλοις, καὶ λέγουσιν, Ηὐλήσαμεν ὑμῖν, καὶ οὐκ ὠρχήσασθε· ἐθρηνήσαμεν ὑμῖν, καὶ οὐκ ἐκλαύσατε. ");
INSERT INTO grctr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ἐλήλυθε γὰρ Ἰωάννης ὁ βαπτιστὴς μήτε ἄρτον ἐσθίων μήτε οἶνον πίνων, καὶ λέγετε, Δαιμόνιον ἔχει· ");
INSERT INTO grctr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ἐλήλυθεν ὁ υἱὸς τοῦ ἀνθρώπου ἐσθίων καὶ πίνων, καὶ λέγετε, Ἰδού, ἄνθρωπος φάγος καὶ οἰνοπότης, τελωνῶν φίλος καὶ ἁμαρτωλῶν. ");
INSERT INTO grctr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Καὶ ἐδικαιώθη ἡ σοφία ἀπὸ τῶν τέκνων αὐτῆς πάντων. ");
INSERT INTO grctr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ἠρώτα δέ τις αὐτὸν τῶν Φαρισαίων ἵνα φάγῃ μετ᾿ αὐτοῦ· καὶ εἰσελθὼν εἰς τὴν οἰκίαν τοῦ Φαρισαίου ἀνεκλίθη. ");
INSERT INTO grctr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Καὶ ἰδού, γυνὴ ἐν τῇ πόλει, ἥτις ἦν ἁμαρτωλός, ἐπιγνοῦσα ὅτι ἀνάκειται ἐν τῇ οἰκίᾳ τοῦ Φαρισαίου, κομίσασα ἀλάβαστρον μύρου, ");
INSERT INTO grctr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","καὶ στᾶσα παρὰ τοὺς πόδας αὐτοῦ ὀπίσω κλαίουσα, ἤρξατο βρέχειν τοὺς πόδας αὐτοῦ τοῖς δάκρυσι, καὶ ταῖς θριξὶ τῆς κεφαλῆς αὐτῆς ἐξέμασσε, καὶ κατεφίλει τοὺς πόδας αὐτοῦ, καὶ ἤλειφε τῷ μύρῳ. ");
INSERT INTO grctr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ἰδὼν δὲ ὁ Φαρισαῖος ὁ καλέσας αὐτὸν εἶπεν ἐν ἑαυτῷ λέγων, Οὗτος, εἰ ἦν προφήτης, ἐγίνωσκεν ἂν τίς καὶ ποταπὴ ἡ γυνὴ ἥτις ἅπτεται αὐτοῦ, ὅτι ἁμαρτωλός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπε πρὸς αὐτόν, Σίμων, ἔχω σοί τι εἰπεῖν. Ὁ δέ φησι, Διδάσκαλε, εἰπέ. ");
INSERT INTO grctr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Δύο χρεωφειλέται ἦσαν δανειστῇ τινί· ὁ εἷς ὤφειλε δηνάρια πεντακόσια, ὁ δὲ ἕτερος πεντήκοντα. ");
INSERT INTO grctr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Μὴ ἐχόντων δὲ αὐτῶν ἀποδοῦναι, ἀμφοτέροις ἐχαρίσατο. Τίς οὖν αὐτῶν, εἰπέ, πλεῖον αὐτὸν ἀγαπήσει; ");
INSERT INTO grctr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ἀποκριθεὶς δὲ ὁ Σίμων εἶπεν, Ὑπολαμβάνω ὅτι ᾧ τὸ πλεῖον ἐχαρίσατο. Ὁ δὲ εἶπεν αὐτῷ, Ὀρθῶς ἔκρινας. ");
INSERT INTO grctr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Καὶ στραφεὶς πρὸς τὴν γυναῖκα, τῷ Σίμωνι ἔφη, Βλέπεις ταύτην τὴν γυναῖκα; Εἰσῆλθόν σου εἰς τὴν οἰκίαν, ὕδωρ ἐπὶ τοὺς πόδας μου οὐκ ἔδωκας· αὕτη δὲ τοῖς δάκρυσιν ἔβρεξέ μου τοὺς πόδας, καὶ ταῖς θριξὶ τῆς κεφαλῆς αὐτῆς ἐξέμαξε. ");
INSERT INTO grctr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Φίλημά μοι οὐκ ἔδωκας· αὕτη δέ, ἀφ᾿ ἧς εἰσῆλθον, οὐ διέλιπε καταφιλοῦσά μου τοὺς πόδας. ");
INSERT INTO grctr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ἐλαίῳ τὴν κεφαλήν μου οὐκ ἤλειψας· αὕτη δὲ μύρῳ ἤλειψέ μου τοὺς πόδας. ");
INSERT INTO grctr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Οὗ χάριν, λέγω σοι, ἀφέωνται αἱ ἁμαρτίαι αὐτῆς αἱ πολλαί, ὅτι ἠγάπησε πολύ· ᾧ δὲ ὀλίγον ἀφίεται, ὀλίγον ἀγαπᾷ. ");
INSERT INTO grctr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Εἶπε δὲ αὐτῇ, Ἀφέωνταί σου αἱ ἁμαρτίαι. ");
INSERT INTO grctr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Καὶ ἤρξαντο οἱ συνανακείμενοι λέγειν ἐν ἑαυτοῖς, Τίς οὗτός ἐστιν ὃς καὶ ἁμαρτίας ἀφίησιν; ");
INSERT INTO grctr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Εἶπε δὲ πρὸς τὴν γυναῖκα, Ἡ πίστις σου σέσωκέ σε· πορεύου εἰς εἰρήνην. ");
INSERT INTO grctr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Καὶ ἐγένετο ἐν τῷ καθεξῆς, καὶ αὐτὸς διώδευε κατὰ πόλιν καὶ κώμην, κηρύσσων καὶ εὐαγγελιζόμενος τὴν βασιλείαν τοῦ Θεοῦ· καὶ οἱ δώδεκα σὺν αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","καὶ γυναῖκές τινες αἳ ἦσαν τεθεραπευμέναι ἀπὸ πνευμάτων πονηρῶν καὶ ἀσθενειῶν, Μαρία ἡ καλουμένη Μαγδαληνή, ἀφ᾿ ἧς δαιμόνια ἑπτὰ ἐξεληλύθει, ");
INSERT INTO grctr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","καὶ Ἰωάννα γυνὴ Χουζᾶ ἐπιτρόπου Ἡρῴδου, καὶ Σουσάννα, καὶ ἕτεραι πολλαί, αἵτινες διηκόνουν αὐτῷ ἀπὸ τῶν ὑπαρχόντων αὐταῖς. ");
INSERT INTO grctr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Συνιόντος δὲ ὄχλου πολλοῦ, καὶ τῶν κατὰ πόλιν ἐπιπορευομένων πρὸς αὐτόν, εἶπε διὰ παραβολῆς, ");
INSERT INTO grctr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ἐξῆλθεν ὁ σπείρων τοῦ σπεῖραι τὸν σπόρον αὐτοῦ. Καὶ ἐν τῷ σπείρειν αὐτόν, ὃ μὲν ἔπεσε παρὰ τὴν ὁδόν, καὶ κατεπατήθη, καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατέφαγεν αὐτό. ");
INSERT INTO grctr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Καὶ ἕτερον ἔπεσεν ἐπὶ τὴν πέτραν, καὶ φυὲν ἐξηράνθη, διὰ τὸ μὴ ἔχειν ἰκμάδα. ");
INSERT INTO grctr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Καὶ ἕτερον ἔπεσεν ἐν μέσῳ τῶν ἀκανθῶν, καὶ συμφυεῖσαι αἱ ἄκανθαι ἀπέπνιξαν αὐτό. ");
INSERT INTO grctr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Καὶ ἕτερον ἔπεσεν ἐπὶ τὴν γῆν τὴν ἀγαθήν, καὶ φυὲν ἐποίησε καρπὸν ἑκατονταπλασίονα. Ταῦτα λέγων ἐφώνει, Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ἐπηρώτων δὲ αὐτὸν οἱ μαθηταὶ αὐτοῦ, λέγοντες, Τίς εἴη ἡ παραβολὴ αὕτη; ");
INSERT INTO grctr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ὁ δὲ εἶπεν, Ὑμῖν δέδοται γνῶναι τὰ μυστήρια τῆς βασιλείας τοῦ Θεοῦ· τοῖς δὲ λοιποῖς ἐν παραβολαῖς, ἵνα βλέποντες μὴ βλέπωσι, καὶ ἀκούοντες μὴ συνιῶσιν. ");
INSERT INTO grctr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ἔστι δὲ αὕτη ἡ παραβολή· Ὁ σπόρος ἐστὶν ὁ λόγος τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Οἱ δὲ παρὰ τὴν ὁδὸν εἰσὶν οἱ ἀκούοντες, εἶτα ἔρχεται ὁ διάβολος καὶ αἴρει τὸν λόγον ἀπὸ τῆς καρδίας αὐτῶν, ἵνα μὴ πιστεύσαντες σωθῶσιν. ");
INSERT INTO grctr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Οἱ δὲ ἐπὶ τῆς πέτρας οἵ, ὅταν ἀκούσωσι, μετὰ χαρᾶς δέχονται τὸν λόγον, καὶ οὗτοι ῥίζαν οὐκ ἔχουσιν, οἳ πρὸς καιρὸν πιστεύουσι, καὶ ἐν καιρῷ πειρασμοῦ ἀφίστανται. ");
INSERT INTO grctr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Τὸ δὲ εἰς τὰς ἀκάνθας πεσόν, οὗτοί εἰσιν οἱ ἀκούσαντες, καὶ ὑπὸ μεριμνῶν καὶ πλούτου καὶ ἡδονῶν τοῦ βίου πορευόμενοι συμπνίγονται, καὶ οὐ τελεσφοροῦσι. ");
INSERT INTO grctr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Τὸ δὲ ἐν τῇ καλῇ γῇ, οὗτοί εἰσιν οἵτινες ἐν καρδίᾳ καλῇ καὶ ἀγαθῇ, ἀκούσαντες τὸν λόγον κατέχουσι, καὶ καρποφοροῦσιν ἐν ὑπομονῇ. ");
INSERT INTO grctr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Οὐδεὶς δὲ λύχνον ἅψας καλύπτει αὐτὸν σκεύει, ἢ ὑποκάτω κλίνης τίθησιν, ἀλλ᾿ ἐπὶ λυχνίας ἐπιτίθησιν, ἵνα οἱ εἰσπορευόμενοι βλέπωσι τὸ φῶς. ");
INSERT INTO grctr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Οὐ γάρ ἐστι κρυπτόν, ὃ οὐ φανερὸν γενήσεται· οὐδὲ ἀπόκρυφον, ὃ οὐ γνωσθήσεται καὶ εἰς φανερὸν ἔλθῃ. ");
INSERT INTO grctr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Βλέπετε οὖν πῶς ἀκούετε· ὃς γὰρ ἂν ἔχῃ, δοθήσεται αὐτῷ· καὶ ὃς ἂν μὴ ἔχῃ, καὶ ὃ δοκεῖ ἔχειν ἀρθήσεται ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Παρεγένοντο δὲ πρὸς αὐτὸν ἡ μήτηρ καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ οὐκ ἠδύναντο συντυχεῖν αὐτῷ διὰ τὸν ὄχλον. ");
INSERT INTO grctr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Καὶ ἀπηγγέλη αὐτῷ, λεγόντων, Ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου ἑστήκασιν ἔξω, ἰδεῖν σε θέλοντες. ");
INSERT INTO grctr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ὁ δὲ ἀποκριθεὶς εἶπε πρὸς αὐτούς, Μήτηρ μου καὶ ἀδελφοί μου οὗτοί εἰσιν, οἱ τὸν λόγον τοῦ Θεοῦ ἀκούοντες καὶ ποιοῦντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Καὶ ἐγένετο ἐν μιᾷ τῶν ἡμερῶν, καὶ αὐτὸς ἐνέβη εἰς πλοῖον καὶ οἱ μαθηταὶ αὐτοῦ, καὶ εἶπε πρὸς αὐτούς, Διέλθωμεν εἰς τὸ πέραν τῆς λίμνης. Καὶ ἀνήχθησαν. ");
INSERT INTO grctr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Πλεόντων δὲ αὐτῶν ἀφύπνωσε· καὶ κατέβη λαῖλαψ ἀνέμου εἰς τὴν λίμνην, καὶ συνεπληροῦντο, καὶ ἐκινδύνευον. ");
INSERT INTO grctr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Προσελθόντες δὲ διήγειραν αὐτόν, λέγοντες, Ἐπιστάτα, ἐπιστάτα, ἀπολλύμεθα. Ὁ δὲ ἐγερθεὶς ἐπετίμησε τῷ ἀνέμῳ καὶ τῷ κλύδωνι τοῦ ὕδατος· καὶ ἐπαύσαντο, καὶ ἐγένετο γαλήνη. ");
INSERT INTO grctr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Εἶπε δὲ αὐτοῖς, Ποῦ ἐστιν ἡ πίστις ὑμῶν; Φοβηθέντες δὲ ἐθαύμασαν, λέγοντες πρὸς ἀλλήλους, Τίς ἄρα οὗτός ἐστιν, ὅτι καὶ τοῖς ἀνέμοις ἐπιτάσσει καὶ τῷ ὕδατι, καὶ ὑπακούουσιν αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Καὶ κατέπλευσαν εἰς τὴν χώραν τῶν Γαδαρηνῶν, ἥτις ἐστὶν ἀντιπέραν τῆς Γαλιλαίας. ");
INSERT INTO grctr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ἐξελθόντι δὲ αὐτῷ ἐπὶ τὴν γῆν, ὑπήντησεν αὐτῷ ἀνήρ τις ἐκ τῆς πόλεως, ὃς εἶχε δαιμόνια ἐκ χρόνων ἱκανῶν, καὶ ἱμάτιον οὐκ ἐνεδιδύσκετο, καὶ ἐν οἰκίᾳ οὐκ ἔμενεν, ἀλλ᾿ ἐν τοῖς μνήμασιν. ");
INSERT INTO grctr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ἰδὼν δὲ τὸν Ἰησοῦν, καὶ ἀνακράξας, προσέπεσεν αὐτῷ, καὶ φωνῇ μεγάλῃ εἶπε, Τί ἐμοὶ καὶ σοί, Ἰησοῦ, υἱὲ τοῦ Θεοῦ τοῦ ὑψίστου; Δέομαί σου, μή με βασανίσῃς. ");
INSERT INTO grctr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Παρήγγειλε γὰρ τῷ πνεύματι τῷ ἀκαθάρτῳ ἐξελθεῖν ἀπὸ τοῦ ἀνθρώπου· πολλοῖς γὰρ χρόνοις συνηρπάκει αὐτόν, καὶ ἐδεσμεῖτο ἁλύσεσι καὶ πέδαις φυλασσόμενος, καὶ διαρρήσσων τὰ δεσμὰ ἠλαύνετο ὑπὸ τοῦ δαίμονος εἰς τὰς ἐρήμους. ");
INSERT INTO grctr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ἐπηρώτησε δὲ αὐτὸν ὁ Ἰησοῦς, λέγων, Τί σοι ἐστὶν ὄνομα; Ὁ δὲ εἶπε, Λεγεών, ὅτι δαιμόνια πολλὰ εἰσῆλθεν εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Καὶ παρεκάλει αὐτὸν ἵνα μὴ ἐπιτάξῃ αὐτοῖς εἰς τὴν ἄβυσσον ἀπελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ἦν δὲ ἐκεῖ ἀγέλη χοίρων ἱκανῶν βοσκομένων ἐν τῷ ὄρει· καὶ παρεκάλουν αὐτὸν ἵνα ἐπιτρέψῃ αὐτοῖς εἰς ἐκείνους εἰσελθεῖν. Καὶ ἐπέτρεψεν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ἐξελθόντα δὲ τὰ δαιμόνια ἀπὸ τοῦ ἀνθρώπου εἰσῆλθεν εἰς τοὺς χοίρους· καὶ ὥρμησεν ἡ ἀγέλη κατὰ τοῦ κρημνοῦ εἰς τὴν λίμνην, καὶ ἀπεπνίγη. ");
INSERT INTO grctr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ἰδόντες δὲ οἱ βόσκοντες τὸ γεγενημένον ἔφυγον, καὶ ἀπελθόντες ἀπήγγειλαν εἰς τὴν πόλιν καὶ εἰς τοὺς ἀγρούς. ");
INSERT INTO grctr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ἐξῆλθον δὲ ἰδεῖν τὸ γεγονός· καὶ ἦλθον πρὸς τὸν Ἰησοῦν, καὶ εὗρον καθήμενον τὸν ἄνθρωπον ἀφ᾿ οὗ τὰ δαιμόνια ἐξεληλύθει, ἱματισμένον καὶ σωφρονοῦντα, παρὰ τοὺς πόδας τοῦ Ἰησοῦ· καὶ ἐφοβήθησαν. ");
INSERT INTO grctr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ἀπήγγειλαν δὲ αὐτοῖς καὶ οἱ ἰδόντες πῶς ἐσώθη ὁ δαιμονισθείς. ");
INSERT INTO grctr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Καὶ ἠρώτησαν αὐτὸν ἅπαν τὸ πλῆθος τῆς περιχώρου τῶν Γαδαρηνῶν ἀπελθεῖν ἀπ᾿ αὐτῶν, ὅτι φόβῳ μεγάλῳ συνείχοντο· αὐτὸς δὲ ἐμβὰς εἰς τὸ πλοῖον ὑπέστρεψεν. ");
INSERT INTO grctr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ἐδέετο δὲ αὐτοῦ ὁ ἀνὴρ ἀφ᾿ οὗ ἐξεληλύθει τὰ δαιμόνια εἶναι σὺν αὐτῷ. Ἀπέλυσε δὲ αὐτὸν ὁ Ἰησοῦς λέγων, ");
INSERT INTO grctr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ὑπόστρεφε εἰς τὸν οἶκόν σου, καὶ διηγοῦ ὅσα ἐποίησέ σοι ὁ Θεός. Καὶ ἀπῆλθε, καθ᾿ ὅλην τὴν πόλιν κηρύσσων ὅσα ἐποίησεν αὐτῷ ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ἐγένετο δὲ ἐν τῷ ὑποστρέψαι τὸν Ἰησοῦν, ἀπεδέξατο αὐτὸν ὁ ὄχλος· ἦσαν γὰρ πάντες προσδοκῶντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Καὶ ἰδού, ἦλθεν ἀνὴρ ᾧ ὄνομα Ἰάειρος, καὶ αὐτὸς ἄρχων τῆς συναγωγῆς ὑπῆρχε, καὶ πεσὼν παρὰ τοὺς πόδας τοῦ Ἰησοῦ παρεκάλει αὐτὸν εἰσελθεῖν εἰς τὸν οἶκον αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ὅτι θυγάτηρ μονογενὴς ἦν αὐτῷ ὡς ἐτῶν δώδεκα, καὶ αὕτη ἀπέθνῃσκεν. Ἐν δὲ τῷ ὑπάγειν αὐτὸν οἱ ὄχλοι συνέπνιγον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Καὶ γυνὴ οὖσα ἐν ῥύσει αἵματος ἀπὸ ἐτῶν δώδεκα, ἥτις εἰς ἰατροῖς προσαναλώσασα ὅλον τὸν βίον οὐκ ἴσχυσεν ὑπ᾿ οὐδενὸς θεραπευθῆναι, ");
INSERT INTO grctr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","προσελθοῦσα ὄπισθεν, ἥψατο τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ· καὶ παραχρῆμα ἔστη ἡ ῥύσις τοῦ αἵματος αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Καὶ εἶπεν ὁ Ἰησοῦς, Τίς ὁ ἁψάμενός μου; Ἀρνουμένων δὲ πάντων, εἶπεν ὁ Πέτρος καὶ οἱ μετ᾿ αὐτοῦ, Ἐπιστάτα, οἱ ὄχλοι συνέχουσί σε καὶ ἀποθλίβουσι, καὶ λέγεις, Τίς ὁ ἁψάμενός μου; ");
INSERT INTO grctr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ὁ δὲ Ἰησοῦς εἶπεν, Ἥψατό μού τις· ἐγὼ γὰρ ἔγνων δύναμιν ἐξελθοῦσαν ἀπ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ἰδοῦσα δὲ ἡ γυνὴ ὅτι οὐκ ἔλαθε, τρέμουσα ἦλθε, καὶ προσπεσοῦσα αὐτῷ, δι᾿ ἣν αἰτίαν ἥψατο αὐτοῦ ἀπήγγειλεν αὐτῷ ἐνώπιον παντὸς τοῦ λαοῦ, καὶ ὡς ἰάθη παραχρῆμα. ");
INSERT INTO grctr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ὁ δὲ εἶπεν αὐτῇ, Θάρσει, θύγατερ, ἡ πίστις σου σέσωκέ σε· πορεύου εἰς εἰρήνην. ");
INSERT INTO grctr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ἔτι αὐτοῦ λαλοῦντος, ἔρχεταί τις παρὰ τοῦ ἀρχισυναγώγου, λέγων αὐτῷ ὅτι Τέθνηκεν ἡ θυγάτηρ σου· μὴ σκύλλε τὸν διδάσκαλον. ");
INSERT INTO grctr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ὁ δὲ Ἰησοῦς ἀκούσας ἀπεκρίθη αὐτῷ, λέγων, Μὴ φοβοῦ· μόνον πίστευε, καὶ σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Εἰσελθὼν δὲ εἰς τὴν οἰκίαν, οὐκ ἀφῆκεν εἰσελθεῖν οὐδένα, εἰ μὴ Πέτρον καὶ Ἰάκωβον καὶ Ἰωάννην, καὶ τὸν πατέρα τῆς παιδὸς καὶ τὴν μητέρα. ");
INSERT INTO grctr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ἔκλαιον δὲ πάντες, καὶ ἐκόπτοντο αὐτήν. Ὁ δὲ εἶπε, Μὴ κλαίετε· οὐκ ἀπέθανεν, ἀλλὰ καθεύδει. ");
INSERT INTO grctr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Καὶ κατεγέλων αὐτοῦ, εἰδότες ὅτι ἀπέθανεν. ");
INSERT INTO grctr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Αὐτὸς δὲ ἐκβαλὼν ἔξω πάντας, καὶ κρατήσας τῆς χειρὸς αὐτῆς, ἐφώνησε λέγων, Ἡ παῖς, ἐγείρου. ");
INSERT INTO grctr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Καὶ ἐπέστρεψε τὸ πνεῦμα αὐτῆς, καὶ ἀνέστη παραχρῆμα· καὶ διέταξεν αὐτῇ δοθῆναι φαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Καὶ ἐξέστησαν οἱ γονεῖς αὐτῆς· ὁ δὲ παρήγγειλεν αὐτοῖς μηδενὶ εἰπεῖν τὸ γεγονός. ");
INSERT INTO grctr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Συγκαλεσάμενος δὲ τοὺς δώδεκα μαθητὰς αὐτοῦ, ἔδωκεν αὐτοῖς δύναμιν καὶ ἐξουσίαν ἐπὶ πάντα τὰ δαιμόνια, καὶ νόσους θεραπεύειν. ");
INSERT INTO grctr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Καὶ ἀπέστειλεν αὐτοὺς κηρύσσειν τὴν βασιλείαν τοῦ Θεοῦ, καὶ ἰᾶσθαι τοὺς ἀσθενοῦντας. ");
INSERT INTO grctr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Καὶ εἶπε πρὸς αὐτούς, Μηδὲν αἴρετε εἰς τὴν ὁδόν· μήτε ῥάβδους, μήτε πήραν, μήτε ἄρτον, μήτε ἀργύριον, μήτε ἀνὰ δύο χιτῶνας ἔχειν. ");
INSERT INTO grctr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Καὶ εἰς ἣν ἂν οἰκίαν εἰσέλθητε, ἐκεῖ μένετε, καὶ ἐκεῖθεν ἐξέρχεσθε. ");
INSERT INTO grctr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Καὶ ὅσοι ἂν μὴ δέξωνται ὑμᾶς, ἐξερχόμενοι ἀπὸ τῆς πόλεως ἐκείνης καὶ τὸν κονιορτὸν ἀπὸ τῶν ποδῶν ὑμῶν ἀποτινάξατε εἰς μαρτύριον ἐπ᾿ αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ἐξερχόμενοι δὲ διήρχοντο κατὰ τὰς κώμας, εὐαγγελιζόμενοι καὶ θεραπεύοντες πανταχοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ἤκουσε δὲ Ἡρῴδης ὁ τετράρχης τὰ γινόμενα ὑπ᾿ αὐτοῦ πάντα· καὶ διηπόρει, διὰ τὸ λέγεσθαι ὑπό τινων ὅτι Ἰωάννης ἐγήγερται ἐκ νεκρῶν· ");
INSERT INTO grctr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ὑπό τινων δὲ ὅτι Ἠλίας ἐφάνη· ἄλλων δὲ ὅτι Προφήτης εἷς τῶν ἀρχαίων ἀνέστη. ");
INSERT INTO grctr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Καὶ εἶπεν ὁ Ἡρῴδης, Ἰωάννην ἐγὼ ἀπεκεφάλισα· τίς δέ ἐστιν οὗτος, περὶ οὗ ἐγὼ ἀκούω τοιαῦτα; Καὶ ἐζήτει ἰδεῖν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Καὶ ὑποστρέψαντες οἱ ἀπόστολοι διηγήσαντο αὐτῷ ὅσα ἐποίησαν. Καὶ παραλαβὼν αὐτούς, ὑπεχώρησε κατ᾿ ἰδίαν εἰς τόπον ἔρημον πόλεως καλουμένης Βηθσαϊδά. ");
INSERT INTO grctr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Οἱ δὲ ὄχλοι γνόντες ἠκολούθησαν αὐτῷ· καὶ δεξάμενος αὐτούς, ἐλάλει αὐτοῖς περὶ τῆς βασιλείας τοῦ Θεοῦ, καὶ τοὺς χρείαν ἔχοντας θεραπείας ἰᾶτο. ");
INSERT INTO grctr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ἡ δὲ ἡμέρα ἤρξατο κλίνειν· προσελθόντες δὲ οἱ δώδεκα εἶπον αὐτῷ, Ἀπόλυσον τὸν ὄχλον, ἵνα ἀπελθόντες εἰς τὰς κύκλῳ κώμας καὶ τοὺς ἀγροὺς καταλύσωσι, καὶ εὕρωσιν ἐπισιτισμόν· ὅτι ὧδε ἐν ἐρήμῳ τόπῳ ἐσμέν. ");
INSERT INTO grctr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Εἶπε δὲ πρὸς αὐτούς, Δότε αὐτοῖς ὑμεῖς φαγεῖν. Οἱ δὲ εἶπον, Οὐκ εἰσὶν ἡμῖν πλεῖον ἢ πέντε ἄρτοι καὶ δύο ἰχθύες, εἰ μήτι πορευθέντες ἡμεῖς ἀγοράσωμεν εἰς πάντα τὸν λαὸν τοῦτον βρώματα. ");
INSERT INTO grctr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ἦσαν γὰρ ὡσεὶ ἄνδρες πεντακισχίλιοι. Εἶπε δὲ πρὸς τοὺς μαθητὰς αὐτοῦ, Κατακλίνατε αὐτοὺς κλισίας ἀνὰ πεντήκοντα. ");
INSERT INTO grctr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Καὶ ἐποίησαν οὕτω, καὶ ἀνέκλιναν ἅπαντας. ");
INSERT INTO grctr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Λαβὼν δὲ τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας, ἀναβλέψας εἰς τὸν οὐρανόν, εὐλόγησεν αὐτούς, καὶ κατέκλασε, καὶ ἐδίδου τοῖς μαθηταῖς παρατιθέναι τῷ ὄχλῳ. ");
INSERT INTO grctr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Καὶ ἔφαγον καὶ ἐχορτάσθησαν πάντες· καὶ ἤρθη τὸ περισσεῦσαν αὐτοῖς κλασμάτων, κόφινοι δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Καὶ ἐγένετο ἐν τῷ εἶναι αὐτὸν προσευχόμενον καταμόνας, συνῆσαν αὐτῷ οἱ μαθηταί· καὶ ἐπηρώτησεν αὐτούς, λέγων, Τίνα με λέγουσιν οἱ ὄχλοι εἶναι; ");
INSERT INTO grctr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Οἱ δὲ ἀποκριθέντες εἶπον, Ἰωάννην τὸν βαπτιστήν· ἄλλοι δὲ Ἠλίαν· ἄλλοι δὲ ὅτι Προφήτης τις τῶν ἀρχαίων ἀνέστη. ");
INSERT INTO grctr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Εἶπε δὲ αὐτοῖς, Ὑμεῖς δὲ τίνα με λέγετε εἶναι; Ἀποκριθεὶς δὲ ὁ Πέτρος εἶπε, Τὸν Χριστὸν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ὁ δὲ ἐπιτιμήσας αὐτοῖς παρήγγειλε μηδενὶ εἰπεῖν τοῦτο, ");
INSERT INTO grctr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","εἰπὼν ὅτι Δεῖ τὸν υἱὸν τοῦ ἀνθρώπου πολλὰ παθεῖν, καὶ ἀποδοκιμασθῆναι ἀπὸ τῶν πρεσβυτέρων καὶ ἀρχιερέων καὶ γραμματέων, καὶ ἀποκτανθῆναι, καὶ τῇ τρίτῃ ἡμέρᾳ ἐγερθῆναι. ");
INSERT INTO grctr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ἔλεγε δὲ πρὸς πάντας, Εἴ τις θέλει ὀπίσω μου ἐλθεῖν, ἀπαρνησάσθω ἑαυτόν, καὶ ἀράτω τὸν σταυρὸν αὐτοῦ καθ᾿ ἡμέραν, καὶ ἀκολουθείτω μοι. ");
INSERT INTO grctr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ὃς γὰρ ἂν θέλῃ τὴν ψυχὴν αὐτοῦ σῶσαι, ἀπολέσει αὐτήν· ὃς δ᾿ ἂν ἀπολέσῃ τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ, οὗτος σώσει αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Τί γὰρ ὠφελεῖται ἄνθρωπος, κερδήσας τὸν κόσμον ὅλον, ἑαυτὸν δὲ ἀπολέσας ἢ ζημιωθείς; ");
INSERT INTO grctr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ὃς γὰρ ἂν ἐπαισχυνθῇ με καὶ τοὺς ἐμοὺς λόγους, τοῦτον ὁ υἱὸς τοῦ ἀνθρώπου ἐπαισχυνθήσεται, ὅταν ἔλθῃ ἐν τῇ δόξῃ αὐτοῦ καὶ τοῦ πατρὸς καὶ τῶν ἁγίων ἀγγέλων. ");
INSERT INTO grctr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Λέγω δὲ ὑμῖν ἀληθῶς, εἰσί τινες τῶν ὧδε ἑστηκότων, οἳ οὐ μὴ γεύσονται θανάτου, ἕως ἂν ἴδωσι τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ἐγένετο δὲ μετὰ τοὺς λόγους τούτους ὡσεὶ ἡμέραι ὀκτώ, καὶ παραλαβὼν τὸν Πέτρον καὶ Ἰωάννην καὶ Ἰάκωβον, ἀνέβη εἰς τὸ ὄρος προσεύξασθαι. ");
INSERT INTO grctr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Καὶ ἐγένετο, ἐν τῷ προσεύχεσθαι αὐτόν, τὸ εἶδος τοῦ προσώπου αὐτοῦ ἕτερον, καὶ ὁ ἱματισμὸς αὐτοῦ λευκὸς ἐξαστράπτων. ");
INSERT INTO grctr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Καὶ ἰδού, ἄνδρες δύο συνελάλουν αὐτῷ, οἵτινες ἦσαν Μωσῆς καὶ Ἠλίας, ");
INSERT INTO grctr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","οἳ ὀφθέντες ἐν δόξῃ ἔλεγον τὴν ἔξοδον αὐτοῦ ἣν ἔμελλε πληροῦν ἐν Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ὁ δὲ Πέτρος καὶ οἱ σὺν αὐτῷ ἦσαν βεβαρημένοι ὕπνῳ· διαγρηγορήσαντες δὲ εἶδον τὴν δόξαν αὐτοῦ, καὶ τοὺς δύο ἄνδρας τοὺς συνεστῶτας αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Καὶ ἐγένετο, ἐν τῷ διαχωρίζεσθαι αὐτοὺς ἀπ᾿ αὐτοῦ, εἶπεν ὁ Πέτρος πρὸς τὸν Ἰησοῦν, Ἐπιστάτα, καλόν ἐστιν ἡμᾶς ὧδε εἶναι· καὶ ποιήσωμεν σκηνὰς τρεῖς, μίαν σοί, καὶ Μωσεῖ μίαν, καὶ μίαν Ἠλίᾳ· μὴ εἰδὼς ὃ λέγει. ");
INSERT INTO grctr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ταῦτα δὲ αὐτοῦ λέγοντος, ἐγένετο νεφέλη καὶ ἐπεσκίασεν αὐτούς· ἐφοβήθησαν δὲ ἐν τῷ ἐκείνους εἰσελθεῖν εἰς τὴν νεφέλην. ");
INSERT INTO grctr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Καὶ φωνὴ ἐγένετο ἐκ τῆς νεφέλης, λέγουσα, Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός· αὐτοῦ ἀκούετε. ");
INSERT INTO grctr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Καὶ ἐν τῷ γενέσθαι τὴν φωνήν, εὑρέθη ὁ Ἰησοῦς μόνος. Καὶ αὐτοὶ ἐσίγησαν, καὶ οὐδενὶ ἀπήγγειλαν ἐν ἐκείναις ταῖς ἡμέραις οὐδὲν ὧν ἑωράκασιν. ");
INSERT INTO grctr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ἐγένετο δὲ ἐν τῇ ἑξῆς ἡμέρᾳ, κατελθόντων αὐτῶν ἀπὸ τοῦ ὄρους, συνήντησεν αὐτῷ ὄχλος πολύς. ");
INSERT INTO grctr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Καὶ ἰδού, ἀνὴρ ἀπὸ τοῦ ὄχλου ἀνεβόησε, λέγων, Διδάσκαλε, δέομαί σου, ἐπίβλεψον ἐπὶ τὸν υἱόν μου, ὅτι μονογενής ἐστί μοι· ");
INSERT INTO grctr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","καὶ ἰδού, πνεῦμα λαμβάνει αὐτόν, καὶ ἐξαίφνης κράζει, καὶ σπαράσσει αὐτὸν μετὰ ἀφροῦ, καὶ μόγις ἀποχωρεῖ ἀπ᾿ αὐτοῦ, συντρῖβον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Καὶ ἐδεήθην τῶν μαθητῶν σου ἵνα ἐκβάλλωσιν αὐτό, καὶ οὐκ ἠδυνήθησαν. ");
INSERT INTO grctr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Ὦ γενεὰ ἄπιστος καὶ διεστραμμένη, ἕως πότε ἔσομαι πρὸς ὑμᾶς, καὶ ἀνέξομαι ὑμῶν; Προσάγαγε ὧδε τὸν υἱόν σου. ");
INSERT INTO grctr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ἔτι δὲ προσερχομένου αὐτοῦ, ἔρρηξεν αὐτὸν τὸ δαιμόνιον καὶ συνεσπάραξεν· ἐπετίμησε δὲ ὁ Ἰησοῦς τῷ πνεύματι τῷ ἀκαθάρτῳ, καὶ ἰάσατο τὸν παῖδα, καὶ ἀπέδωκεν αὐτὸν τῷ πατρὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ἐξεπλήσσοντο δὲ πάντες ἐπὶ τῇ μεγαλειότητι τοῦ Θεοῦ. Πάντων δὲ θαυμαζόντων ἐπὶ πᾶσιν οἷς ἐποίησεν ὁ Ἰησοῦς, εἶπε πρὸς τοὺς μαθητὰς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Θέσθε ὑμεῖς εἰς τὰ ὦτα ὑμῶν τοὺς λόγους τούτους· ὁ γὰρ υἱὸς τοῦ ἀνθρώπου μέλλει παραδίδοσθαι εἰς χεῖρας ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Οἱ δὲ ἠγνόουν τὸ ῥῆμα τοῦτο, καὶ ἦν παρακεκαλυμμένον ἀπ᾿ αὐτῶν, ἵνα μὴ αἴσθωνται αὐτό· καὶ ἐφοβοῦντο ἐρωτῆσαι αὐτὸν περὶ τοῦ ῥήματος τούτου. ");
INSERT INTO grctr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Εἰσῆλθε δὲ διαλογισμὸς ἐν αὐτοῖς, τὸ τίς ἂν εἴη μείζων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ὁ δὲ Ἰησοῦς ἰδὼν τὸν διαλογισμὸν τῆς καρδίας αὐτῶν, ἐπιλαβόμενος παιδίου, ἔστησεν αὐτὸ παρ᾿ ἑαυτῷ, ");
INSERT INTO grctr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","καὶ εἶπεν αὐτοῖς, Ὃς ἐὰν δέξηται τοῦτο τὸ παιδίον ἐπὶ τῷ ὀνόματί μου ἐμὲ δέχεται· καὶ ὃς ἐὰν ἐμὲ δέξηται δέχεται τὸν ἀποστείλαντά με· ὁ γὰρ μικρότερος ἐν πᾶσιν ὑμῖν ὑπάρχων οὗτος ἔσται μέγας. ");
INSERT INTO grctr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ἀποκριθεὶς δὲ ὁ Ἰωάννης εἶπεν, Ἐπιστάτα, εἴδομέν τινα ἐπὶ τῷ ὀνόματί σου ἐκβάλλοντα τὰ δαιμόνια· καὶ ἐκωλύσαμεν αὐτόν, ὅτι οὐκ ἀκολουθεῖ μεθ᾿ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Καὶ εἶπε πρὸς αὐτὸν ὁ Ἰησοῦς, Μὴ κωλύετε· ὃς γὰρ οὐκ ἔστι καθ᾿ ἡμῶν ὑπὲρ ἡμῶν ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ἐγένετο δὲ ἐν τῷ συμπληροῦσθαι τὰς ἡμέρας τῆς ἀναλήψεως αὐτοῦ, καὶ αὐτὸς τὸ πρόσωπον αὐτοῦ ἐστήριξε τοῦ πορεύεσθαι εἰς Ἱερουσαλήμ, ");
INSERT INTO grctr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","καὶ ἀπέστειλεν ἀγγέλους πρὸ προσώπου αὐτοῦ· καὶ πορευθέντες εἰσῆλθον εἰς κώμην Σαμαρειτῶν, ὥστε ἑτοιμάσαι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Καὶ οὐκ ἐδέξαντο αὐτόν, ὅτι τὸ πρόσωπον αὐτοῦ ἦν πορευόμενον εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ἰδόντες δὲ οἱ μαθηταὶ αὐτοῦ Ἰάκωβος καὶ Ἰωάννης εἶπον, Κύριε, θέλεις εἴπωμεν πῦρ καταβῆναι ἀπὸ τοῦ οὐρανοῦ, καὶ ἀναλῶσαι αὐτούς, ὡς καὶ Ἠλίας ἐποίησε; ");
INSERT INTO grctr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Στραφεὶς δὲ ἐπετίμησεν αὐτοῖς, καὶ εἶπεν, Οὐκ οἴδατε οἵου πνεύματός ἐστε ὑμεῖς· ");
INSERT INTO grctr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ὁ γὰρ υἱὸς τοῦ ἀνθρώπου οὐκ ἦλθε ψυχὰς ἀνθρώπων ἀπολέσαι, ἀλλὰ σῶσαι. Καὶ ἐπορεύθησαν εἰς ἑτέραν κώμην. ");
INSERT INTO grctr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ἐγένετο δὲ πορευομένων αὐτῶν ἐν τῇ ὁδῷ, εἶπέ τις πρὸς αὐτόν, Ἀκολουθήσω σοι ὅπου ἂν ἀπέρχῃ, Κύριε. ");
INSERT INTO grctr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Καὶ εἶπεν αὐτῷ ὁ Ἰησοῦς, Αἱ ἀλώπεκες φωλεοὺς ἔχουσι, καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνώσεις· ὁ δὲ υἱὸς τοῦ ἀνθρώπου οὐκ ἔχει ποῦ τὴν κεφαλὴν κλίνῃ. ");
INSERT INTO grctr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Εἶπε δὲ πρὸς ἕτερον, Ἀκολούθει μοι. Ὁ δὲ εἶπε, Κύριε, ἐπίτρεψόν μοι ἀπελθόντι πρῶτον θάψαι τὸν πατέρα μου. ");
INSERT INTO grctr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Εἶπε δὲ αὐτῷ ὁ Ἰησοῦς, Ἄφες τοὺς νεκροὺς θάψαι τοὺς ἑαυτῶν νεκρούς· σὺ δὲ ἀπελθὼν διάγγελλε τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Εἶπε δὲ καὶ ἕτερος, Ἀκολουθήσω σοι, Κύριε· πρῶτον δὲ ἐπίτρεψόν μοι ἀποτάξασθαι τοῖς εἰς τὸν οἶκόν μου. ");
INSERT INTO grctr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Εἶπε δὲ πρὸς αὐτὸν ὁ Ἰησοῦς, Οὐδείς, ἐπιβαλὼν τὴν χεῖρα αὐτοῦ ἐπ᾿ ἄροτρον, καὶ βλέπων εἰς τὰ ὀπίσω, εὔθετός ἐστιν εἰς τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Μετὰ δὲ ταῦτα ἀνέδειξεν ὁ Κύριος καὶ ἑτέρους ἑβδομήκοντα, καὶ ἀπέστειλεν αὐτοὺς ἀνὰ δύο πρὸ προσώπου αὐτοῦ εἰς πᾶσαν πόλιν καὶ τόπον οὗ ἔμελλεν αὐτὸς ἔρχεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ἔλεγεν οὖν πρὸς αὐτούς, Ὁ μὲν θερισμὸς πολύς, οἱ δὲ ἐργάται ὀλίγοι· δεήθητε οὖν τοῦ Κυρίου τοῦ θερισμοῦ, ὅπως ἐκβάλλῃ ἐργάτας εἰς τὸν θερισμὸν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ὑπάγετε· ἰδού, ἐγὼ ἀποστέλλω ὑμᾶς ὡς ἄρνας ἐν μέσῳ λύκων. ");
INSERT INTO grctr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Μὴ βαστάζετε βαλάντιον, μὴ πήραν, μηδὲ ὑποδήματα· καὶ μηδένα κατὰ τὴν ὁδὸν ἀσπάσησθε. ");
INSERT INTO grctr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Εἰς ἣν δ᾿ ἂν οἰκίαν εἰσέρχησθε, πρῶτον λέγετε, Εἰρήνη τῷ οἴκῳ τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Καὶ ἐὰν μὲν ᾖ ἐκεῖ ὁ υἱὸς εἰρήνης, ἐπαναπαύσεται ἐπ᾿ αὐτὸν ἡ εἰρήνη ὑμῶν· εἰ δὲ μήγε, ἐφ᾿ ὑμᾶς ἀνακάμψει. ");
INSERT INTO grctr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ἐν αὐτῇ δὲ τῇ οἰκίᾳ μένετε, ἐσθίοντες καὶ πίνοντες τὰ παρ᾿ αὐτῶν· ἄξιος γὰρ ὁ ἐργάτης τοῦ μισθοῦ αὐτοῦ ἐστί. Μὴ μεταβαίνετε ἐξ οἰκίας εἰς οἰκίαν. ");
INSERT INTO grctr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Καὶ εἰς ἣν δ᾿ ἂν πόλιν εἰσέρχησθε, καὶ δέχωνται ὑμᾶς, ἐσθίετε τὰ παρατιθέμενα ὑμῖν, ");
INSERT INTO grctr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","καὶ θεραπεύετε τοὺς ἐν αὐτῇ ἀσθενεῖς, καὶ λέγετε αὐτοῖς, Ἤγγικεν ἐφ᾿ ὑμᾶς ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Εἰς ἣν δ᾿ ἂν πόλιν εἰσέρχησθε, καὶ μὴ δέχωνται ὑμᾶς, ἐξελθόντες εἰς τὰς πλατείας αὐτῆς εἴπατε, ");
INSERT INTO grctr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Καὶ τὸν κονιορτὸν τὸν κολληθέντα ἡμῖν ἐκ τῆς πόλεως ὑμῶν ἀπομασσόμεθα ὑμῖν· πλὴν τοῦτο γινώσκετε, ὅτι ἤγγικεν ἐφ᾿ ὑμᾶς ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Λέγω δὲ ὑμῖν ὅτι Σοδόμοις ἐν τῇ ἡμέρᾳ ἐκείνῃ ἀνεκτότερον ἔσται, ἢ τῇ πόλει ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Οὐαί σοι, Χωραζίν, οὐαί σοι, Βηθσαϊδά· ὅτι εἰ ἐν Τύρῳ καὶ Σιδῶνι ἐγένοντο αἱ δυνάμεις αἱ γενόμεναι ἐν ὑμῖν, πάλαι ἂν ἐν σάκκῳ καὶ σποδῷ καθήμεναι μετενόησαν. ");
INSERT INTO grctr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Πλὴν Τύρῳ καὶ Σιδῶνι ἀνεκτότερον ἔσται ἐν τῇ κρίσει, ἢ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Καὶ σύ, Καπερναούμ, ἡ ἕως τοῦ οὐρανοῦ ὑψωθεῖσα, ἕως ᾍδου καταβιβασθήσῃ. ");
INSERT INTO grctr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ὁ ἀκούων ὑμῶν ἐμοῦ ἀκούει· καὶ ὁ ἀθετῶν ὑμᾶς ἐμὲ ἀθετεῖ· ὁ δὲ ἐμὲ ἀθετῶν ἀθετεῖ τὸν ἀποστείλαντά με. ");
INSERT INTO grctr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ὑπέστρεψαν δὲ οἱ ἑβδομήκοντα μετὰ χαρᾶς, λέγοντες, Κύριε, καὶ τὰ δαιμόνια ὑποτάσσεται ἡμῖν ἐν τῷ ὀνόματί σου. ");
INSERT INTO grctr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Εἶπε δὲ αὐτοῖς, Ἐθεώρουν τὸν Σατανᾶν ὡς ἀστραπὴν ἐκ τοῦ οὐρανοῦ πεσόντα. ");
INSERT INTO grctr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ἰδού, δίδωμι ὑμῖν τὴν ἐξουσίαν τοῦ πατεῖν ἐπάνω ὄφεων καὶ σκορπίων, καὶ ἐπὶ πᾶσαν τὴν δύναμιν τοῦ ἐχθροῦ· καὶ οὐδὲν ὑμᾶς οὐ μὴ ἀδικήσει. ");
INSERT INTO grctr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Πλὴν ἐν τούτῳ μὴ χαίρετε ὅτι τὰ πνεύματα ὑμῖν ὑποτάσσεται· χαίρετε δὲ μᾶλλον ὅτι τὰ ὀνόματα ὑμῶν ἐγράφη ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ἐν αὐτῇ τῇ ὥρᾳ ἠγαλλιάσατο τῷ πνεύματι ὁ Ἰησοῦς, καὶ εἶπεν, Ἐξομολογοῦμαί σοι, πάτερ, Κύριε τοῦ οὐρανοῦ καὶ τῆς γῆς, ὅτι ἀπέκρυψας ταῦτα ἀπὸ σοφῶν καὶ συνετῶν, καὶ ἀπεκάλυψας αὐτὰ νηπίοις. Ναί, ὁ πατήρ, ὅτι οὕτως ἐγένετο εὐδοκία ἔμπροσθέν σου. ");
INSERT INTO grctr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Πάντα παρεδόθη μοι ὑπὸ τοῦ πατρός μου· καὶ οὐδεὶς γινώσκει τίς ἐστιν ὁ υἱός, εἰ μὴ ὁ πατήρ, καὶ τίς ἐστιν ὁ πατήρ, εἰ μὴ ὁ υἱός, καὶ ᾧ ἐὰν βούληται ὁ υἱὸς ἀποκαλύψαι. ");
INSERT INTO grctr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Καὶ στραφεὶς πρὸς τοὺς μαθητὰς κατ᾿ ἰδίαν εἶπε, Μακάριοι οἱ ὀφθαλμοὶ οἱ βλέποντες ἃ βλέπετε. ");
INSERT INTO grctr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Λέγω γὰρ ὑμῖν ὅτι πολλοὶ προφῆται καὶ βασιλεῖς ἠθέλησαν ἰδεῖν ἃ ὑμεῖς βλέπετε, καὶ οὐκ εἶδον· καὶ ἀκοῦσαι ἃ ἀκούετε, καὶ οὐκ ἤκουσαν. ");
INSERT INTO grctr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Καὶ ἰδού, νομικός τις ἀνέστη, ἐκπειράζων αὐτόν, καὶ λέγων, Διδάσκαλε, τί ποιήσας ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grctr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ὁ δὲ εἶπε πρὸς αὐτόν, Ἐν τῷ νόμῳ τί γέγραπται; Πῶς ἀναγινώσκεις; ");
INSERT INTO grctr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ὁ δὲ ἀποκριθεὶς εἶπεν, Ἀγαπήσεις Κύριον τὸν Θεόν σου, ἐξ ὅλης τῆς καρδίας σου, καὶ ἐξ ὅλης τῆς ψυχῆς σου, καὶ ἐξ ὅλης τῆς ἰσχύος σου, καὶ ἐξ ὅλης τῆς διανοίας σου· καὶ τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grctr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Εἶπε δὲ αὐτῷ, Ὀρθῶς ἀπεκρίθης· τοῦτο ποίει, καὶ ζήσῃ. ");
INSERT INTO grctr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ὁ δὲ θέλων δικαιοῦν ἑαυτὸν εἶπε πρὸς τὸν Ἰησοῦν, Καὶ τίς ἐστί μου πλησίον; ");
INSERT INTO grctr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ὑπολαβὼν δὲ ὁ Ἰησοῦς εἶπεν, Ἄνθρωπός τις κατέβαινεν ἀπὸ Ἱερουσαλὴμ εἰς Ἰεριχώ, καὶ λῃσταῖς περιέπεσεν, οἳ καὶ ἐκδύσαντες αὐτὸν καὶ πληγὰς ἐπιθέντες ἀπῆλθον, ἀφέντες ἡμιθανῆ τυγχάνοντα. ");
INSERT INTO grctr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Κατὰ συγκυρίαν δὲ ἱερεύς τις κατέβαινεν ἐν τῇ ὁδῷ ἐκείνῃ· καὶ ἰδὼν αὐτὸν ἀντιπαρῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ὁμοίως δὲ καὶ Λευΐτης γενόμενος κατὰ τὸν τόπον ἐλθὼν καὶ ἰδὼν ἀντιπαρῆλθε. ");
INSERT INTO grctr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Σαμαρείτης δέ τις ὁδεύων ἦλθε κατ᾿ αὐτόν, καὶ ἰδὼν αὐτὸν ἐσπλαγχνίσθη, ");
INSERT INTO grctr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","καὶ προσελθὼν κατέδησε τὰ τραύματα αὐτοῦ, ἐπιχέων ἔλαιον καὶ οἶνον· ἐπιβιβάσας δὲ αὐτὸν ἐπὶ τὸ ἴδιον κτῆνος, ἤγαγεν αὐτὸν εἰς πανδοχεῖον, καὶ ἐπεμελήθη αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Καὶ ἐπὶ τὴν αὔριον ἐξελθών, ἐκβαλὼν δύο δηνάρια ἔδωκε τῷ πανδοχεῖ, καὶ εἶπεν αὐτῷ, Ἐπιμελήθητι αὐτοῦ· καὶ ὅ τι ἂν προσδαπανήσῃς, ἐγὼ ἐν τῷ ἐπανέρχεσθαί με ἀποδώσω σοι. ");
INSERT INTO grctr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Τίς οὖν τούτων τῶν τριῶν δοκεῖ σοι πλησίον γεγονέναι τοῦ ἐμπεσόντος εἰς τοὺς λῃστάς; ");
INSERT INTO grctr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ὁ δὲ εἶπεν, Ὁ ποιήσας τὸ ἔλεος μετ᾿ αὐτοῦ. Εἶπεν οὖν αὐτῷ ὁ Ἰησοῦς, Πορεύου, καὶ σὺ ποίει ὁμοίως. ");
INSERT INTO grctr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ἐγένετο δὲ ἐν τῷ πορεύεσθαι αὐτούς, καὶ αὐτὸς εἰσῆλθεν εἰς κώμην τινά· γυνὴ δέ τις ὀνόματι Μάρθα ὑπεδέξατο αὐτὸν εἰς τὸν οἶκον αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Καὶ τῇδε ἦν ἀδελφὴ καλουμένη Μαρία, ἣ καὶ παρακαθίσασα παρὰ τοὺς πόδας τοῦ Ἰησοῦ ἤκουε τὸν λόγον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ἡ δὲ Μάρθα περιεσπᾶτο περὶ πολλὴν διακονίαν· ἐπιστᾶσα δὲ εἶπε, Κύριε, οὐ μέλει σοι ὅτι ἡ ἀδελφή μου μόνην με κατέλιπε διακονεῖν; Εἰπὲ οὖν αὐτῇ ἵνα μοι συναντιλάβηται. ");
INSERT INTO grctr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ἀποκριθεὶς δὲ εἶπεν αὐτῇ ὁ Ἰησοῦς, Μάρθα, Μάρθα, μεριμνᾷς καὶ τυρβάζῃ περὶ πολλά· ");
INSERT INTO grctr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ἑνὸς δέ ἐστι χρεία· Μαρία δὲ τὴν ἀγαθὴν μερίδα ἐξελέξατο, ἥτις οὐκ ἀφαιρεθήσεται ἀπ᾿ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Καὶ ἐγένετο ἐν τῷ εἶναι αὐτὸν ἐν τόπῳ τινὶ προσευχόμενον, ὡς ἐπαύσατο, εἶπέ τις τῶν μαθητῶν αὐτοῦ πρὸς αὐτόν, Κύριε, δίδαξον ἡμᾶς προσεύχεσθαι, καθὼς καὶ Ἰωάννης ἐδίδαξε τοὺς μαθητὰς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Εἶπε δὲ αὐτοῖς, Ὅταν προσεύχησθε, λέγετε, Πάτερ ἡμῶν ὁ ἐν τοῖς οὐρανοῖς, ἁγιασθήτω τὸ ὄνομά σου. Ἐλθέτω ἡ βασιλεία σου. Γενηθήτω τὸ θέλημά σου, ὡς ἐν οὐρανῷ, καὶ ἐπὶ τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Τὸν ἄρτον ἡμῶν τὸν ἐπιούσιον δίδου ἡμῖν τὸ καθ᾿ ἡμέραν. ");
INSERT INTO grctr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Καὶ ἄφες ἡμῖν τὰς ἁμαρτίας ἡμῶν, καὶ γὰρ αὐτοὶ ἀφίεμεν παντὶ ὀφείλοντι ἡμῖν. Καὶ μὴ εἰσενέγκῃς ἡμᾶς εἰς πειρασμόν, ἀλλὰ ῥῦσαι ἡμᾶς ἀπὸ τοῦ πονηροῦ. ");
INSERT INTO grctr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Καὶ εἶπε πρὸς αὐτούς, Τίς ἐξ ὑμῶν ἕξει φίλον, καὶ πορεύσεται πρὸς αὐτὸν μεσονυκτίου, καὶ εἴπῃ αὐτῷ, Φίλε, χρῆσόν μοι τρεῖς ἄρτους, ");
INSERT INTO grctr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ἐπειδὴ φίλος μου παρεγένετο ἐξ ὁδοῦ πρός με, καὶ οὐκ ἔχω ὃ παραθήσω αὐτῷ· ");
INSERT INTO grctr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","κἀκεῖνος ἔσωθεν ἀποκριθεὶς εἴπῃ, Μή μοι κόπους πάρεχε· ἤδη ἡ θύρα κέκλεισται, καὶ τὰ παιδία μου μετ᾿ ἐμοῦ εἰς τὴν κοίτην εἰσίν· οὐ δύναμαι ἀναστὰς δοῦναί σοι. ");
INSERT INTO grctr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Λέγω ὑμῖν, εἰ καὶ οὐ δώσει αὐτῷ ἀναστάς, διὰ τὸ εἶναι αὐτοῦ φίλον, διά γε τὴν ἀναίδειαν αὐτοῦ ἐγερθεὶς δώσει αὐτῷ ὅσων χρῄζει. ");
INSERT INTO grctr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Κἀγὼ ὑμῖν λέγω, αἰτεῖτε, καὶ δοθήσεται ὑμῖν· ζητεῖτε, καὶ εὑρήσετε· κρούετε, καὶ ἀνοιγήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Πᾶς γὰρ ὁ αἰτῶν λαμβάνει· καὶ ὁ ζητῶν εὑρίσκει· καὶ τῷ κρούοντι ἀνοιγήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Τίνα δὲ ὑμῶν τὸν πατέρα αἰτήσει ὁ υἱὸς ἄρτον, μὴ λίθον ἐπιδώσει αὐτῷ; Εἰ καὶ ἰχθύν, μὴ ἀντὶ ἰχθύος ὄφιν ἐπιδώσει αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ἢ καὶ ἐὰν αἰτήσῃ ᾠόν, μὴ ἐπιδώσει αὐτῷ σκορπίον; ");
INSERT INTO grctr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Εἰ οὖν ὑμεῖς πονηροὶ ὑπάρχοντες οἴδατε ἀγαθὰ δόματα διδόναι τοῖς τέκνοις ὑμῶν, πόσῳ μᾶλλον ὁ πατὴρ ὁ ἐξ οὐρανοῦ δώσει πνεῦμα ἅγιον τοῖς αἰτοῦσιν αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Καὶ ἦν ἐκβάλλων δαιμόνιον, καὶ αὐτὸ ἦν κωφόν. Ἐγένετο δέ, τοῦ δαιμονίου ἐξελθόντος, ἐλάλησεν ὁ κωφός· καὶ ἐθαύμασαν οἱ ὄχλοι. ");
INSERT INTO grctr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Τινὲς δὲ ἐξ αὐτῶν εἶπον, Ἐν Βεελζεβοὺλ ἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια. ");
INSERT INTO grctr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ἕτεροι δὲ πειράζοντες σημεῖον παρ᾿ αὐτοῦ ἐζήτουν ἐξ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Αὐτὸς δὲ εἰδὼς αὐτῶν τὰ διανοήματα εἶπεν αὐτοῖς, Πᾶσα βασιλεία ἐφ᾿ ἑαυτὴν διαμερισθεῖσα ἐρημοῦται· καὶ οἶκος ἐπὶ οἶκον, πίπτει. ");
INSERT INTO grctr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Εἰ δὲ καὶ ὁ Σατανᾶς ἐφ᾿ ἑαυτὸν διεμερίσθη, πῶς σταθήσεται ἡ βασιλεία αὐτοῦ; Ὅτι λέγετε ἐν Βεελζεβοὺλ ἐκβάλλειν με τὰ δαιμόνια. ");
INSERT INTO grctr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Εἰ δὲ ἐγὼ ἐν Βεελζεβοὺλ ἐκβάλλω τὰ δαιμόνια, οἱ υἱοὶ ὑμῶν ἐν τίνι ἐκβάλλουσι; Διὰ τοῦτο κριταὶ ὑμῶν αὐτοὶ ἔσονται. ");
INSERT INTO grctr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Εἰ δὲ ἐν δακτύλῳ Θεοῦ ἐκβάλλω τὰ δαιμόνια, ἄρα ἔφθασεν ἐφ᾿ ὑμᾶς ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ὅταν ὁ ἰσχυρὸς καθωπλισμένος φυλάσσῃ τὴν ἑαυτοῦ αὐλήν, ἐν εἰρήνῃ ἐστὶ τὰ ὑπάρχοντα αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ἐπὰν δὲ ὁ ἰσχυρότερος αὐτοῦ ἐπελθὼν νικήσῃ αὐτόν, τὴν πανοπλίαν αὐτοῦ αἴρει ἐφ᾿ ᾗ ἐπεποίθει, καὶ τὰ σκῦλα αὐτοῦ διαδίδωσιν. ");
INSERT INTO grctr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ὁ μὴ ὢν μετ᾿ ἐμοῦ κατ᾿ ἐμοῦ ἐστι· καὶ ὁ μὴ συνάγων μετ᾿ ἐμοῦ σκορπίζει. ");
INSERT INTO grctr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ὅταν τὸ ἀκάθαρτον πνεῦμα ἐξέλθῃ ἀπὸ τοῦ ἀνθρώπου, διέρχεται δι᾿ ἀνύδρων τόπων, ζητοῦν ἀνάπαυσιν· καὶ μὴ εὑρίσκον λέγει, Ὑποστρέψω εἰς τὸν οἶκόν μου ὅθεν ἐξῆλθον. ");
INSERT INTO grctr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Καὶ ἐλθὸν εὑρίσκει σεσαρωμένον καὶ κεκοσμημένον. ");
INSERT INTO grctr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Τότε πορεύεται καὶ παραλαμβάνει ἑπτὰ ἕτερα πνεύματα πονηρότερα ἑαυτοῦ, καὶ εἰσελθόντα κατοικεῖ ἐκεῖ· καὶ γίνεται τὰ ἔσχατα τοῦ ἀνθρώπου ἐκείνου χείρονα τῶν πρώτων. ");
INSERT INTO grctr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ἐγένετο δὲ ἐν τῷ λέγειν αὐτὸν ταῦτα, ἐπάρασά τις γυνὴ φωνὴν ἐκ τοῦ ὄχλου εἶπεν αὐτῷ, Μακαρία ἡ κοιλία ἡ βαστάσασά σε, καὶ μαστοὶ οὓς ἐθήλασας. ");
INSERT INTO grctr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Αὐτὸς δὲ εἶπε, Μενοῦνγε μακάριοι οἱ ἀκούοντες τὸν λόγον τοῦ Θεοῦ καὶ φυλάσσοντες αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Τῶν δὲ ὄχλων ἐπαθροιζομένων ἤρξατο λέγειν, Ἡ γενεὰ αὕτη πονηρά ἐστι· σημεῖον ἐπιζητεῖ, καὶ σημεῖον οὐ δοθήσεται αὐτῇ, εἰ μὴ τὸ σημεῖον Ἰωνᾶ τοῦ προφήτου. ");
INSERT INTO grctr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Καθὼς γὰρ ἐγένετο Ἰωνᾶς σημεῖον τοῖς Νινευΐταις, οὕτως ἔσται καὶ ὁ υἱὸς τοῦ ἀνθρώπου τῇ γενεᾷ ταύτῃ. ");
INSERT INTO grctr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Βασίλισσα νότου ἐγερθήσεται ἐν τῇ κρίσει μετὰ τῶν ἀνδρῶν τῆς γενεᾶς ταύτης, καὶ κατακρινεῖ αὐτούς· ὅτι ἦλθεν ἐκ τῶν περάτων τῆς γῆς ἀκοῦσαι τὴν σοφίαν Σολομῶντος, καὶ ἰδού, πλεῖον Σολομῶντος ὧδε. ");
INSERT INTO grctr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ἄνδρες Νινευῒ ἀναστήσονται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινοῦσιν αὐτήν· ὅτι μετενόησαν εἰς τὸ κήρυγμα Ἰωνᾶ, καὶ ἰδού, πλεῖον Ἰωνᾶ ὧδε. ");
INSERT INTO grctr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Οὐδεὶς δὲ λύχνον ἅψας εἰς κρυπτὸν τίθησιν, οὐδὲ ὑπὸ τὸν μόδιον, ἀλλ᾿ ἐπὶ τὴν λυχνίαν, ἵνα οἱ εἰσπορευόμενοι τὸ φέγγος βλέπωσιν. ");
INSERT INTO grctr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ὁ λύχνος τοῦ σώματός ἐστιν ὁ ὀφθαλμός· ὅταν οὖν ὁ ὀφθαλμός σου ἁπλοῦς ᾖ, καὶ ὅλον τὸ σῶμά σου φωτεινόν ἐστιν· ἐπὰν δὲ πονηρὸς ᾖ, καὶ τὸ σῶμά σου σκοτεινόν. ");
INSERT INTO grctr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Σκόπει οὖν μὴ τὸ φῶς τὸ ἐν σοὶ σκότος ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Εἰ οὖν τὸ σῶμά σου ὅλον φωτεινόν, μὴ ἔχον τι μέρος σκοτεινόν, ἔσται φωτεινὸν ὅλον, ὡς ὅταν ὁ λύχνος τῇ ἀστραπῇ φωτίζῃ σε. ");
INSERT INTO grctr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ἐν δὲ τῷ λαλῆσαι, ἠρώτα αὐτὸν Φαρισαῖός τις ὅπως ἀριστήσῃ παρ᾿ αὐτῷ· εἰσελθὼν δὲ ἀνέπεσεν. ");
INSERT INTO grctr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ὁ δὲ Φαρισαῖος ἰδὼν ἐθαύμασεν ὅτι οὐ πρῶτον ἐβαπτίσθη πρὸ τοῦ ἀρίστου. ");
INSERT INTO grctr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Εἶπε δὲ ὁ Κύριος πρὸς αὐτόν, Νῦν ὑμεῖς οἱ Φαρισαῖοι τὸ ἔξωθεν τοῦ ποτηρίου καὶ τοῦ πίνακος καθαρίζετε, τὸ δὲ ἔσωθεν ὑμῶν γέμει ἁρπαγῆς καὶ πονηρίας. ");
INSERT INTO grctr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ἄφρονες, οὐχ ὁ ποιήσας τὸ ἔξωθεν καὶ τὸ ἔσωθεν ἐποίησε; ");
INSERT INTO grctr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Πλὴν τὰ ἐνόντα δότε ἐλεημοσύνην· καὶ ἰδού, πάντα καθαρὰ ὑμῖν ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ἀλλ᾿ οὐαὶ ὑμῖν τοῖς Φαρισαίοις, ὅτι ἀποδεκατοῦτε τὸ ἡδύοσμον καὶ τὸ πήγανον καὶ πᾶν λάχανον, καὶ παρέρχεσθε τὴν κρίσιν καὶ τὴν ἀγάπην τοῦ Θεοῦ· ταῦτα ἔδει ποιῆσαι, κἀκεῖνα μὴ ἀφιέναι. ");
INSERT INTO grctr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Οὐαὶ ὑμῖν τοῖς Φαρισαίοις, ὅτι ἀγαπᾶτε τὴν πρωτοκαθεδρίαν ἐν ταῖς συναγωγαῖς, καὶ τοὺς ἀσπασμοὺς ἐν ταῖς ἀγοραῖς. ");
INSERT INTO grctr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι, ὑποκριταί, ὅτι ἐστὲ ὡς τὰ μνημεῖα τὰ ἄδηλα, καὶ οἱ ἄνθρωποι οἱ περιπατοῦντες ἐπάνω οὐκ οἴδασιν. ");
INSERT INTO grctr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ἀποκριθεὶς δέ τις τῶν νομικῶν λέγει αὐτῷ, Διδάσκαλε, ταῦτα λέγων καὶ ἡμᾶς ὑβρίζεις. ");
INSERT INTO grctr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ὁ δὲ εἶπε, Καὶ ὑμῖν τοῖς νομικοῖς οὐαί, ὅτι φορτίζετε τοὺς ἀνθρώπους φορτία δυσβάστακτα, καὶ αὐτοὶ ἑνὶ τῶν δακτύλων ὑμῶν οὐ προσψαύετε τοῖς φορτίοις. ");
INSERT INTO grctr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Οὐαὶ ὑμῖν, ὅτι οἰκοδομεῖτε τὰ μνημεῖα τῶν προφητῶν, οἱ δὲ πατέρες ὑμῶν ἀπέκτειναν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ἄρα μαρτυρεῖτε καὶ συνευδοκεῖτε τοῖς ἔργοις τῶν πατέρων ὑμῶν· ὅτι αὐτοὶ μὲν ἀπέκτειναν αὐτούς, ὑμεῖς δὲ οἰκοδομεῖτε αὐτῶν τὰ μνημεῖα. ");
INSERT INTO grctr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Διὰ τοῦτο καὶ ἡ σοφία τοῦ Θεοῦ εἶπεν, Ἀποστελῶ εἰς αὐτοὺς προφήτας καὶ ἀποστόλους, καὶ ἐξ αὐτῶν ἀποκτενοῦσι καὶ ἐκδιώξουσιν· ");
INSERT INTO grctr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ἵνα ἐκζητηθῇ τὸ αἷμα πάντων τῶν προφητῶν τὸ ἐκχυνόμενον ἀπὸ καταβολῆς κόσμου ἀπὸ τῆς γενεᾶς ταύτης, ");
INSERT INTO grctr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ἀπὸ τοῦ αἵματος Ἄβελ ἕως τοῦ αἵματος Ζαχαρίου τοῦ ἀπολομένου μεταξὺ τοῦ θυσιαστηρίου καὶ τοῦ οἴκου. Ναί, λέγω ὑμῖν, ἐκζητηθήσεται ἀπὸ τῆς γενεᾶς ταύτης. ");
INSERT INTO grctr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Οὐαὶ ὑμῖν τοῖς νομικοῖς, ὅτι ἤρατε τὴν κλεῖδα τῆς γνώσεως· αὐτοὶ οὐκ εἰσήλθετε, καὶ τοὺς εἰσερχομένους ἐκωλύσατε. ");
INSERT INTO grctr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Λέγοντος δὲ αὐτοῦ ταῦτα πρὸς αὐτούς, ἤρξαντο οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι δεινῶς ἐνέχειν, καὶ ἀποστοματίζειν αὐτὸν περὶ πλειόνων, ");
INSERT INTO grctr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ἐνεδρεύοντες αὐτόν, καὶ ζητοῦντες θηρεῦσαί τι ἐκ τοῦ στόματος αὐτοῦ, ἵνα κατηγορήσωσιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ἐν οἷς ἐπισυναχθεισῶν τῶν μυριάδων τοῦ ὄχλου, ὥστε καταπατεῖν ἀλλήλους, ἤρξατο λέγειν πρὸς τοὺς μαθητὰς αὐτοῦ πρῶτον, Προσέχετε ἑαυτοῖς ἀπὸ τῆς ζύμης τῶν Φαρισαίων, ἥτις ἐστὶν ὑπόκρισις. ");
INSERT INTO grctr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Οὐδὲν δὲ συγκεκαλυμμένον ἐστὶν ὃ οὐκ ἀποκαλυφθήσεται, καὶ κρυπτὸν ὃ οὐ γνωσθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ἀνθ᾿ ὧν ὅσα ἐν τῇ σκοτίᾳ εἴπατε, ἐν τῷ φωτὶ ἀκουσθήσεται· καὶ ὃ πρὸς τὸ οὖς ἐλαλήσατε ἐν τοῖς ταμείοις, κηρυχθήσεται ἐπὶ τῶν δωμάτων. ");
INSERT INTO grctr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Λέγω δὲ ὑμῖν τοῖς φίλοις μου, Μὴ φοβηθῆτε ἀπὸ τῶν ἀποκτεινόντων τὸ σῶμα, καὶ μετὰ ταῦτα μὴ ἐχόντων περισσότερόν τι ποιῆσαι. ");
INSERT INTO grctr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ὑποδείξω δὲ ὑμῖν τίνα φοβηθῆτε· φοβήθητε τὸν μετὰ τὸ ἀποκτεῖναι ἐξουσίαν ἔχοντα ἐμβαλεῖν εἰς τὴν γέενναν· ναί, λέγω ὑμῖν, τοῦτον φοβήθητε. ");
INSERT INTO grctr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Οὐχὶ πέντε στρουθία πωλεῖται ἀσσαρίων δύο; Καὶ ἓν ἐξ αὐτῶν οὐκ ἔστιν ἐπιλελησμένον ἐνώπιον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ἀλλὰ καὶ αἱ τρίχες τῆς κεφαλῆς ὑμῶν πᾶσαι ἠρίθμηνται. Μὴ οὖν φοβεῖσθε· πολλῶν στρουθίων διαφέρετε. ");
INSERT INTO grctr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Λέγω δὲ ὑμῖν, Πᾶς ὃς ἂν ὁμολογήσῃ ἐν ἐμοὶ ἔμπροσθεν τῶν ἀνθρώπων, καὶ ὁ υἱὸς τοῦ ἀνθρώπου ὁμολογήσει ἐν αὐτῷ ἔμπροσθεν τῶν ἀγγέλων τοῦ Θεοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ὁ δὲ ἀρνησάμενός με ἐνώπιον τῶν ἀνθρώπων ἀπαρνηθήσεται ἐνώπιον τῶν ἀγγέλων τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Καὶ πᾶς ὃς ἐρεῖ λόγον εἰς τὸν υἱὸν τοῦ ἀνθρώπου, ἀφεθήσεται αὐτῷ· τῷ δὲ εἰς τὸ ἅγιον πνεῦμα βλασφημήσαντι οὐκ ἀφεθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ὅταν δὲ προσφέρωσιν ὑμᾶς ἐπὶ τὰς συναγωγὰς καὶ τὰς ἀρχὰς καὶ τὰς ἐξουσίας, μὴ μεριμνᾶτε πῶς ἢ τί ἀπολογήσησθε, ἢ τί εἴπητε· ");
INSERT INTO grctr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","τὸ γὰρ ἅγιον πνεῦμα διδάξει ὑμᾶς ἐν αὐτῇ τῇ ὥρᾳ, ἃ δεῖ εἰπεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Εἶπε δέ τις αὐτῷ ἐκ τοῦ ὄχλου, Διδάσκαλε, εἰπὲ τῷ ἀδελφῷ μου μερίσασθαι μετ᾿ ἐμοῦ τὴν κληρονομίαν. ");
INSERT INTO grctr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ὁ δὲ εἶπεν αὐτῷ, Ἄνθρωπε, τίς με κατέστησε δικαστὴν ἢ μεριστὴν ἐφ᾿ ὑμᾶς; ");
INSERT INTO grctr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Εἶπε δὲ πρὸς αὐτούς, Ὁρᾶτε καὶ φυλάσσεσθε ἀπὸ τῆς πλεονεξίας· ὅτι οὐκ ἐν τῷ περισσεύειν τινὶ ἡ ζωὴ αὐτοῦ ἐστὶν ἐκ τῶν ὑπαρχόντων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Εἶπε δὲ παραβολὴν πρὸς αὐτούς, λέγων, Ἀνθρώπου τινὸς πλουσίου εὐφόρησεν ἡ χώρα· ");
INSERT INTO grctr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","καὶ διελογίζετο ἐν ἑαυτῷ λέγων, Τί ποιήσω, ὅτι οὐκ ἔχω ποῦ συνάξω τοὺς καρπούς μου; ");
INSERT INTO grctr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Καὶ εἶπε, Τοῦτο ποιήσω· καθελῶ μου τὰς ἀποθήκας, καὶ μείζονας οἰκοδομήσω, καὶ συνάξω ἐκεῖ πάντα τὰ γενήματά μου καὶ τὰ ἀγαθά μου. ");
INSERT INTO grctr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Καὶ ἐρῶ τῇ ψυχῇ μου, Ψυχή, ἔχεις πολλὰ ἀγαθὰ κείμενα εἰς ἔτη πολλά· ἀναπαύου, φάγε, πίε, εὐφραίνου. ");
INSERT INTO grctr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Εἶπε δὲ αὐτῷ ὁ Θεός, Ἄφρων, ταύτῃ τῇ νυκτὶ τὴν ψυχήν σου ἀπαιτοῦσιν ἀπὸ σοῦ· ἃ δὲ ἡτοίμασας, τίνι ἔσται; ");
INSERT INTO grctr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Οὕτως ὁ θησαυρίζων ἑαυτῷ, καὶ μὴ εἰς Θεὸν πλουτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Εἶπε δὲ πρὸς τοὺς μαθητὰς αὐτοῦ, Διὰ τοῦτο ὑμῖν λέγω, μὴ μεριμνᾶτε τῇ ψυχῇ ὑμῶν, τί φάγητε· μηδὲ τῷ σώματι, τί ἐνδύσησθε. ");
INSERT INTO grctr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ἡ ψυχὴ πλεῖόν ἐστι τῆς τροφῆς, καὶ τὸ σῶμα τοῦ ἐνδύματος. ");
INSERT INTO grctr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Κατανοήσατε τοὺς κόρακας, ὅτι οὐ σπείρουσιν, οὐδὲ θερίζουσιν, οἷς οὐκ ἔστι ταμεῖον οὐδὲ ἀποθήκη, καὶ ὁ Θεὸς τρέφει αὐτούς· πόσῳ μᾶλλον ὑμεῖς διαφέρετε τῶν πετεινῶν; ");
INSERT INTO grctr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Τίς δὲ ἐξ ὑμῶν μεριμνῶν δύναται προσθεῖναι ἐπὶ τὴν ἡλικίαν αὐτοῦ πῆχυν ἕνα; ");
INSERT INTO grctr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Εἰ οὖν οὔτε ἐλάχιστον δύνασθε, τί περὶ τῶν λοιπῶν μεριμνᾶτε; ");
INSERT INTO grctr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Κατανοήσατε τὰ κρίνα πῶς αὐξάνει· οὐ κοπιᾷ, οὐδὲ νήθει· λέγω δὲ ὑμῖν, οὐδὲ Σολομὼν ἐν πάσῃ τῇ δόξῃ αὐτοῦ περιεβάλετο ὡς ἓν τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Εἰ δὲ τὸν χόρτον ἐν τῷ ἀγρῷ σήμερον ὄντα, καὶ αὔριον εἰς κλίβανον βαλλόμενον, ὁ Θεὸς οὕτως ἀμφιέννυσι, πόσῳ μᾶλλον ὑμᾶς, ὀλιγόπιστοι; ");
INSERT INTO grctr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Καὶ ὑμεῖς μὴ ζητεῖτε τί φάγητε, ἢ τί πίητε· καὶ μὴ μετεωρίζεσθε. ");
INSERT INTO grctr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ταῦτα γὰρ πάντα τὰ ἔθνη τοῦ κόσμου ἐπιζητεῖ· ὑμῶν δὲ ὁ πατὴρ οἶδεν ὅτι χρῄζετε τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Πλὴν ζητεῖτε τὴν βασιλείαν τοῦ Θεοῦ, καὶ ταῦτα πάντα προστεθήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Μὴ φοβοῦ, τὸ μικρὸν ποίμνιον· ὅτι εὐδόκησεν ὁ πατὴρ ὑμῶν δοῦναι ὑμῖν τὴν βασιλείαν. ");
INSERT INTO grctr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Πωλήσατε τὰ ὑπάρχοντα ὑμῶν καὶ δότε ἐλεημοσύνην. Ποιήσατε ἑαυτοῖς βαλάντια μὴ παλαιούμενα, θησαυρὸν ἀνέκλειπτον ἐν τοῖς οὐρανοῖς, ὅπου κλέπτης οὐκ ἐγγίζει, οὐδὲ σὴς διαφθείρει· ");
INSERT INTO grctr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ὅπου γάρ ἐστιν ὁ θησαυρὸς ὑμῶν, ἐκεῖ καὶ ἡ καρδία ὑμῶν ἔσται. ");
INSERT INTO grctr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ἔστωσαν ὑμῶν αἱ ὀσφύες περιεζωσμέναι, καὶ οἱ λύχνοι καιόμενοι· ");
INSERT INTO grctr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","καὶ ὑμεῖς ὅμοιοι ἀνθρώποις προσδεχομένοις τὸν κύριον ἑαυτῶν, πότε ἀναλύσει ἐκ τῶν γάμων, ἵνα, ἐλθόντος καὶ κρούσαντος, εὐθέως ἀνοίξωσιν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Μακάριοι οἱ δοῦλοι ἐκεῖνοι, οὓς ἐλθὼν ὁ κύριος εὑρήσει γρηγοροῦντας· ἀμὴν λέγω ὑμῖν ὅτι περιζώσεται καὶ ἀνακλινεῖ αὐτούς, καὶ παρελθὼν διακονήσει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Καὶ ἐὰν ἔλθῃ ἐν τῇ δευτέρᾳ φυλακῇ, καὶ ἐν τῇ τρίτῃ φυλακῇ ἔλθῃ, καὶ εὕρῃ οὕτω, μακάριοί εἰσιν οἱ δοῦλοι ἐκεῖνοι. ");
INSERT INTO grctr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Τοῦτο δὲ γινώσκετε, ὅτι εἰ ᾔδει ὁ οἰκοδεσπότης ποίᾳ ὥρᾳ ὁ κλέπτης ἔρχεται, ἐγρηγόρησεν ἄν, καὶ οὐκ ἂν ἀφῆκε διορυγῆναι τὸν οἶκον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Καὶ ὑμεῖς οὖν γίνεσθε ἕτοιμοι· ὅτι ᾗ ὥρᾳ οὐ δοκεῖτε ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Εἶπε δὲ αὐτῷ ὁ Πέτρος, Κύριε, πρὸς ἡμᾶς τὴν παραβολὴν ταύτην λέγεις, ἢ καὶ πρὸς πάντας; ");
INSERT INTO grctr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Εἶπε δὲ ὁ Κύριος, Τίς ἄρα ἐστὶν ὁ πιστὸς οἰκονόμος καὶ φρόνιμος, ὃν καταστήσει ὁ κύριος ἐπὶ τῆς θεραπείας αὐτοῦ, τοῦ διδόναι ἐν καιρῷ τὸ σιτομέτριον; ");
INSERT INTO grctr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Μακάριος ὁ δοῦλος ἐκεῖνος, ὃν ἐλθὼν ὁ κύριος αὐτοῦ εὑρήσει ποιοῦντα οὕτως. ");
INSERT INTO grctr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ἀληθῶς λέγω ὑμῖν ὅτι ἐπὶ πᾶσι τοῖς ὑπάρχουσιν αὐτοῦ καταστήσει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ἐὰν δὲ εἴπῃ ὁ δοῦλος ἐκεῖνος ἐν τῇ καρδίᾳ αὐτοῦ, Χρονίζει ὁ κύριός μου ἔρχεσθαι, καὶ ἄρξηται τύπτειν τοὺς παῖδας καὶ τὰς παιδίσκας, ἐσθίειν τε καὶ πίνειν καὶ μεθύσκεσθαι· ");
INSERT INTO grctr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ἥξει ὁ κύριος τοῦ δούλου ἐκείνου ἐν ἡμέρᾳ ᾗ οὐ προσδοκᾷ, καὶ ἐν ὥρᾳ ᾗ οὐ γινώσκει, καὶ διχοτομήσει αὐτόν, καὶ τὸ μέρος αὐτοῦ μετὰ τῶν ἀπίστων θήσει. ");
INSERT INTO grctr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ἐκεῖνος δὲ ὁ δοῦλος ὁ γνοὺς τὸ θέλημα τοῦ κυρίου ἑαυτοῦ, καὶ μὴ ἑτοιμάσας μηδὲ ποιήσας πρὸς τὸ θέλημα αὐτοῦ, δαρήσεται πολλάς· ");
INSERT INTO grctr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ὁ δὲ μὴ γνούς, ποιήσας δὲ ἄξια πληγῶν, δαρήσεται ὀλίγας. Παντὶ δὲ ᾧ ἐδόθη πολύ, πολὺ ζητηθήσεται παρ᾿ αὐτοῦ· καὶ ᾧ παρέθεντο πολύ, περισσότερον αἰτήσουσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Πῦρ ἦλθον βαλεῖν εἰς τὴν γῆν, καὶ τί θέλω εἰ ἤδη ἀνήφθη; ");
INSERT INTO grctr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Βάπτισμα δὲ ἔχω βαπτισθῆναι, καὶ πῶς συνέχομαι ἕως οὗ τελεσθῇ. ");
INSERT INTO grctr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Δοκεῖτε ὅτι εἰρήνην παρεγενόμην δοῦναι ἐν τῇ γῇ; Οὐχί, λέγω ὑμῖν, ἀλλ᾿ ἢ διαμερισμόν. ");
INSERT INTO grctr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ἔσονται γὰρ ἀπὸ τοῦ νῦν πέντε ἐν οἴκῳ ἑνὶ διαμεμερισμένοι, τρεῖς ἐπὶ δυσί, καὶ δύο ἐπὶ τρισί. ");
INSERT INTO grctr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Διαμερισθήσεται πατὴρ ἐφ᾿ υἱῷ, καὶ υἱὸς ἐπὶ πατρί· μήτηρ ἐπὶ θυγατρί, καὶ θυγάτηρ ἐπὶ μητρί· πενθερὰ ἐπὶ τὴν νύμφην αὐτῆς, καὶ νύμφη ἐπὶ τὴν πενθερὰν αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ἔλεγε δὲ καὶ τοῖς ὄχλοις, Ὅταν ἴδητε τὴν νεφέλην ἀνατέλλουσαν ἀπὸ δυσμῶν, εὐθέως λέγετε, Ὄμβρος ἔρχεται· καὶ γίνεται οὕτω. ");
INSERT INTO grctr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Καὶ ὅταν νότον πνέοντα, λέγετε ὅτι Καύσων ἔσται· καὶ γίνεται. ");
INSERT INTO grctr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ὑποκριταί, τὸ πρόσωπον τῆς γῆς καὶ τοῦ οὐρανοῦ οἴδατε δοκιμάζειν· τὸν δὲ καιρὸν τοῦτον πῶς οὐ δοκιμάζετε; ");
INSERT INTO grctr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Τί δὲ καὶ ἀφ᾿ ἑαυτῶν οὐ κρίνετε τὸ δίκαιον; ");
INSERT INTO grctr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ὡς γὰρ ὑπάγεις μετὰ τοῦ ἀντιδίκου σου ἐπ᾿ ἄρχοντα, ἐν τῇ ὁδῷ δὸς ἐργασίαν ἀπηλλάχθαι ἀπ᾿ αὐτοῦ· μήποτε κατασύρῃ σε πρὸς τὸν κριτήν, καὶ ὁ κριτής σε παραδῷ τῷ πράκτορι, καὶ ὁ πράκτωρ σε βάλλῃ εἰς φυλακήν. ");
INSERT INTO grctr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Λέγω σοι, οὐ μὴ ἐξέλθῃς ἐκεῖθεν, ἕως οὗ καὶ τὸ ἔσχατον λεπτὸν ἀποδῷς. ");
INSERT INTO grctr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Παρῆσαν δέ τινες ἐν αὐτῷ τῷ καιρῷ ἀπαγγέλλοντες αὐτῷ περὶ τῶν Γαλιλαίων, ὧν τὸ αἷμα Πιλάτος ἔμιξε μετὰ τῶν θυσιῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς, Δοκεῖτε ὅτι οἱ Γαλιλαῖοι οὗτοι ἁμαρτωλοὶ παρὰ πάντας τοὺς Γαλιλαίους ἐγένοντο, ὅτι τοιαῦτα πεπόνθασιν; ");
INSERT INTO grctr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Οὐχί, λέγω ὑμῖν· ἀλλ᾿ ἐὰν μὴ μετανοῆτε, πάντες ὡσαύτως ἀπολεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ἢ ἐκεῖνοι οἱ δέκα καὶ ὀκτώ, ἐφ᾿ οὓς ἔπεσεν ὁ πύργος ἐν τῷ Σιλωὰμ καὶ ἀπέκτεινεν αὐτούς, δοκεῖτε ὅτι οὗτοι ὀφειλέται ἐγένοντο παρὰ πάντας ἀνθρώπους τοὺς κατοικοῦντας ἐν Ἱερουσαλήμ; ");
INSERT INTO grctr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Οὐχί, λέγω ὑμῖν· ἀλλ᾿ ἐὰν μὴ μετανοῆτε, πάντες ὁμοίως ἀπολεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ἔλεγε δὲ ταύτην τὴν παραβολήν· Συκῆν εἶχέ τις ἐν τῷ ἀμπελῶνι αὐτοῦ πεφυτευμένην· καὶ ἦλθε καρπὸν ζητῶν ἐν αὐτῇ, καὶ οὐχ εὗρεν. ");
INSERT INTO grctr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Εἶπε δὲ πρὸς τὸν ἀμπελουργόν, Ἰδού, τρία ἔτη ἔρχομαι ζητῶν καρπὸν ἐν τῇ συκῇ ταύτῃ, καὶ οὐχ εὑρίσκω· ἔκκοψον αὐτήν· ἵνα τί καὶ τὴν γῆν καταργεῖ; ");
INSERT INTO grctr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ὁ δὲ ἀποκριθεὶς λέγει αὐτῷ, Κύριε, ἄφες αὐτὴν καὶ τοῦτο τὸ ἔτος, ἕως ὅτου σκάψω περὶ αὐτήν, καὶ βάλω κοπρίαν· ");
INSERT INTO grctr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","κἂν μὲν ποιήσῃ καρπόν· εἰ δὲ μήγε, εἰς τὸ μέλλον ἐκκόψεις αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ἦν δὲ διδάσκων ἐν μιᾷ τῶν συναγωγῶν ἐν τοῖς σάββασι· ");
INSERT INTO grctr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","καὶ ἰδού, γυνὴ ἦν πνεῦμα ἔχουσα ἀσθενείας ἔτη δέκα καὶ ὀκτώ, καὶ ἦν συγκύπτουσα, καὶ μὴ δυναμένη ἀνακύψαι εἰς τὸ παντελές. ");
INSERT INTO grctr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ἰδὼν δὲ αὐτὴν ὁ Ἰησοῦς προσεφώνησε, καὶ εἶπεν αὐτῇ, Γύναι, ἀπολέλυσαι τῆς ἀσθενείας σου. ");
INSERT INTO grctr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Καὶ ἐπέθηκεν αὐτῇ τὰς χεῖρας· καὶ παραχρῆμα ἀνωρθώθη, καὶ ἐδόξαζε τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ἀποκριθεὶς δὲ ὁ ἀρχισυνάγωγος, ἀγανακτῶν ὅτι τῷ σαββάτῳ ἐθεράπευσεν ὁ Ἰησοῦς, ἔλεγε τῷ ὄχλῳ, Ἓξ ἡμέραι εἰσὶν ἐν αἷς δεῖ ἐργάζεσθαι· ἐν ταύταις οὖν ἐρχόμενοι θεραπεύεσθε, καὶ μὴ τῇ ἡμέρᾳ τοῦ σαββάτου. ");
INSERT INTO grctr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ἀπεκρίθη οὖν αὐτῷ ὁ Κύριος, καὶ εἶπεν, Ὑποκριτά, ἕκαστος ὑμῶν τῷ σαββάτῳ οὐ λύει τὸν βοῦν αὐτοῦ ἢ τὸν ὄνον ἀπὸ τῆς φάτνης, καὶ ἀπαγαγὼν ποτίζει; ");
INSERT INTO grctr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ταύτην δέ, θυγατέρα Ἀβραὰμ οὖσαν, ἣν ἔδησεν ὁ Σατανᾶς, ἰδού, δέκα καὶ ὀκτὼ ἔτη, οὐκ ἔδει λυθῆναι ἀπὸ τοῦ δεσμοῦ τούτου τῇ ἡμέρᾳ τοῦ σαββάτου; ");
INSERT INTO grctr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Καὶ ταῦτα λέγοντος αὐτοῦ, κατῃσχύνοντο πάντες οἱ ἀντικείμενοι αὐτῷ· καὶ πᾶς ὁ ὄχλος ἔχαιρεν ἐπὶ πᾶσι τοῖς ἐνδόξοις τοῖς γινομένοις ὑπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ἔλεγε δέ, Τίνι ὁμοία ἐστὶν ἡ βασιλεία τοῦ Θεοῦ; Καὶ τίνι ὁμοιώσω αὐτήν; ");
INSERT INTO grctr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ὁμοία ἐστὶ κόκκῳ σινάπεως, ὃν λαβὼν ἄνθρωπος ἔβαλεν εἰς κῆπον ἑαυτοῦ· καὶ ηὔξησε, καὶ ἐγένετο εἰς δένδρον μέγα, καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατεσκήνωσεν ἐν τοῖς κλάδοις αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Καὶ πάλιν εἶπε, Τίνι ὁμοιώσω τὴν βασιλείαν τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ὁμοία ἐστὶ ζύμῃ, ἣν λαβοῦσα γυνὴ ἐνέκρυψεν εἰς ἀλεύρου σάτα τρία, ἕως οὗ ἐζυμώθη ὅλον. ");
INSERT INTO grctr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Καὶ διεπορεύετο κατὰ πόλεις καὶ κώμας διδάσκων, καὶ πορείαν ποιούμενος εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Εἶπε δέ τις αὐτῷ, Κύριε, εἰ ὀλίγοι οἱ σῳζόμενοι; Ὁ δὲ εἶπε πρὸς αὐτούς, ");
INSERT INTO grctr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ἀγωνίζεσθε εἰσελθεῖν διὰ τῆς στενῆς πύλης· ὅτι πολλοί, λέγω ὑμῖν, ζητήσουσιν εἰσελθεῖν, καὶ οὐκ ἰσχύσουσιν. ");
INSERT INTO grctr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ἀφ᾿ οὗ ἂν ἐγερθῇ ὁ οἰκοδεσπότης καὶ ἀποκλείσῃ τὴν θύραν, καὶ ἄρξησθε ἔξω ἑστάναι καὶ κρούειν τὴν θύραν, λέγοντες, Κύριε, Κύριε, ἄνοιξον ἡμῖν· καὶ ἀποκριθεὶς ἐρεῖ ὑμῖν, Οὐκ οἶδα ὑμᾶς, πόθεν ἐστέ· ");
INSERT INTO grctr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","τότε ἄρξεσθε λέγειν, Ἐφάγομεν ἐνώπιόν σου καὶ ἐπίομεν, καὶ ἐν ταῖς πλατείαις ἡμῶν ἐδίδαξας. ");
INSERT INTO grctr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Καὶ ἐρεῖ, Λέγω ὑμῖν, οὐκ οἶδα ὑμᾶς πόθεν ἐστέ· ἀπόστητε ἀπ᾿ ἐμοῦ πάντες οἱ ἐργάται τῆς ἀδικίας. ");
INSERT INTO grctr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων, ὅταν ὄψησθε Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ καὶ πάντας τοὺς προφήτας ἐν τῇ βασιλείᾳ τοῦ Θεοῦ, ὑμᾶς δὲ ἐκβαλλομένους ἔξω. ");
INSERT INTO grctr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Καὶ ἥξουσιν ἀπὸ ἀνατολῶν καὶ δυσμῶν, καὶ ἀπὸ βορρᾶ καὶ νότου, καὶ ἀνακλιθήσονται ἐν τῇ βασιλείᾳ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Καὶ ἰδού, εἰσὶν ἔσχατοι οἳ ἔσονται πρῶτοι, καὶ εἰσὶ πρῶτοι οἳ ἔσονται ἔσχατοι. ");
INSERT INTO grctr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ἐν αὐτῇ τῇ ἡμέρᾳ προσῆλθόν τινες Φαρισαῖοι, λέγοντες αὐτῷ, Ἔξελθε καὶ πορεύου ἐντεῦθεν, ὅτι Ἡρῴδης θέλει σε ἀποκτεῖναι. ");
INSERT INTO grctr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Καὶ εἶπεν αὐτοῖς, Πορευθέντες εἴπατε τῇ ἀλώπεκι ταύτῃ, Ἰδού, ἐκβάλλω δαιμόνια καὶ ἰάσεις ἐπιτελῶ σήμερον καὶ αὔριον, καὶ τῇ τρίτῃ τελειοῦμαι. ");
INSERT INTO grctr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Πλὴν δεῖ με σήμερον καὶ αὔριον καὶ τῇ ἐχομένῃ πορεύεσθαι· ὅτι οὐκ ἐνδέχεται προφήτην ἀπολέσθαι ἔξω Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ἱερουσαλήμ, Ἱερουσαλήμ, ἡ ἀποκτείνουσα τοὺς προφήτας καὶ λιθοβολοῦσα τοὺς ἀπεσταλμένους πρὸς αὐτήν, ποσάκις ἠθέλησα ἐπισυνάξαι τὰ τέκνα σου, ὃν τρόπον ὄρνις τὴν ἑαυτῆς νοσσιὰν ὑπὸ τὰς πτέρυγας, καὶ οὐκ ἠθελήσατε. ");
INSERT INTO grctr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ἰδού, ἀφίεται ὑμῖν ὁ οἶκος ὑμῶν ἔρημος. Ἀμὴν δὲ λέγω ὑμῖν ὅτι οὐ μή με ἴδητε ἕως ἂν ἥξῃ, ὅτε εἴπητε, Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Καὶ ἐγένετο ἐν τῷ ἐλθεῖν αὐτὸν εἰς οἶκόν τινος τῶν ἀρχόντων τῶν Φαρισαίων σαββάτῳ φαγεῖν ἄρτον, καὶ αὐτοὶ ἦσαν παρατηρούμενοι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Καὶ ἰδού, ἄνθρωπός τις ἦν ὑδρωπικὸς ἔμπροσθεν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπε πρὸς τοὺς νομικοὺς καὶ Φαρισαίους, λέγων, Εἰ ἔξεστι τῷ σαββάτῳ θεραπεύειν; ");
INSERT INTO grctr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Οἱ δὲ ἡσύχασαν. Καὶ ἐπιλαβόμενος ἰάσατο αὐτόν, καὶ ἀπέλυσε. ");
INSERT INTO grctr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Καὶ ἀποκριθεὶς πρὸς αὐτοὺς εἶπε, Τίνος ὑμῶν ὄνος ἢ βοῦς εἰς φρέαρ ἐμπεσεῖται, καὶ οὐκ εὐθέως ἀνασπάσει αὐτὸν ἐν τῇ ἡμέρᾳ τοῦ σαββάτου; ");
INSERT INTO grctr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Καὶ οὐκ ἴσχυσαν ἀνταποκριθῆναι αὐτῷ πρὸς ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ἔλεγε δὲ πρὸς τοὺς κεκλημένους παραβολήν, ἐπέχων πῶς τὰς πρωτοκλισίας ἐξελέγοντο, λέγων πρὸς αὐτούς, ");
INSERT INTO grctr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ὅταν κληθῇς ὑπό τινος εἰς γάμους, μὴ κατακλιθῇς εἰς τὴν πρωτοκλισίαν· μήποτε ἐντιμότερός σου ᾖ κεκλημένος ὑπ᾿ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","καὶ ἐλθὼν ὁ σὲ καὶ αὐτὸν καλέσας ἐρεῖ σοι, Δὸς τούτῳ τόπον· καὶ τότε ἄρξῃ μετ᾿ αἰσχύνης τὸν ἔσχατον τόπον κατέχειν. ");
INSERT INTO grctr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ἀλλ᾿ ὅταν κληθῇς, πορευθεὶς ἀνάπεσον εἰς τὸν ἔσχατον τόπον· ἵνα, ὅταν ἔλθῃ ὁ κεκληκώς σε, εἴπῃ σοι, Φίλε, προσανάβηθι ἀνώτερον· τότε ἔσται σοι δόξα ἐνώπιον τῶν συνανακειμένων σοι. ");
INSERT INTO grctr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ὅτι πᾶς ὁ ὑψῶν ἑαυτὸν ταπεινωθήσεται, καὶ ὁ ταπεινῶν ἑαυτὸν ὑψωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ἔλεγε δὲ καὶ τῷ κεκληκότι αὐτόν, Ὅταν ποιῇς ἄριστον ἢ δεῖπνον, μὴ φώνει τοὺς φίλους σου, μηδὲ τοὺς ἀδελφούς σου, μηδὲ τοὺς συγγενεῖς σου, μηδὲ γείτονας πλουσίους· μήποτε καὶ αὐτοί σε ἀντικαλέσωσι, καὶ γένηταί σοι ἀνταπόδομα. ");
INSERT INTO grctr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ἀλλ᾿ ὅταν ποιῇς δοχήν, κάλει πτωχούς, ἀναπήρους, χωλούς, τυφλούς· ");
INSERT INTO grctr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","καὶ μακάριος ἔσῃ, ὅτι οὐκ ἔχουσιν ἀνταποδοῦναί σοι· ἀνταποδοθήσεται γάρ σοι ἐν τῇ ἀναστάσει τῶν δικαίων. ");
INSERT INTO grctr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ἀκούσας δέ τις τῶν συνανακειμένων ταῦτα εἶπεν αὐτῷ, Μακάριος, ὃς φάγεται ἄρτον ἐν τῇ βασιλείᾳ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ὁ δὲ εἶπεν αὐτῷ, Ἄνθρωπός τις ἐποίησε δεῖπνον μέγα, καὶ ἐκάλεσε πολλούς· ");
INSERT INTO grctr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","καὶ ἀπέστειλε τὸν δοῦλον αὐτοῦ τῇ ὥρᾳ τοῦ δείπνου εἰπεῖν τοῖς κεκλημένοις, Ἔρχεσθε, ὅτι ἤδη ἕτοιμά ἐστι πάντα. ");
INSERT INTO grctr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Καὶ ἤρξαντο ἀπὸ μιᾶς παραιτεῖσθαι πάντες. Ὁ πρῶτος εἶπεν αὐτῷ, Ἀγρὸν ἠγόρασα, καὶ ἔχω ἀνάγκην ἐξελθεῖν καὶ ἰδεῖν αὐτόν· ἐρωτῶ σε, ἔχε με παρῃτημένον. ");
INSERT INTO grctr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Καὶ ἕτερος εἶπε, Ζεύγη βοῶν ἠγόρασα πέντε, καὶ πορεύομαι δοκιμάσαι αὐτά· ἐρωτῶ σε, ἔχε με παρῃτημένον. ");
INSERT INTO grctr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Καὶ ἕτερος εἶπε, Γυναῖκα ἔγημα, καὶ διὰ τοῦτο οὐ δύναμαι ἐλθεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Καὶ παραγενόμενος ὁ δοῦλος ἐκεῖνος ἀπήγγειλε τῷ κυρίῳ αὐτοῦ ταῦτα. Τότε ὀργισθεὶς ὁ οἰκοδεσπότης εἶπε τῷ δούλῳ αὐτοῦ, Ἔξελθε ταχέως εἰς τὰς πλατείας καὶ ῥύμας τῆς πόλεως, καὶ τοὺς πτωχοὺς καὶ ἀναπήρους καὶ χωλοὺς καὶ τυφλοὺς εἰσάγαγε ὧδε. ");
INSERT INTO grctr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Καὶ εἶπεν ὁ δοῦλος, Κύριε, γέγονεν ὡς ἐπέταξας, καὶ ἔτι τόπος ἐστί. ");
INSERT INTO grctr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Καὶ εἶπεν ὁ κύριος πρὸς τὸν δοῦλον, Ἔξελθε εἰς τὰς ὁδοὺς καὶ φραγμούς, καὶ ἀνάγκασον εἰσελθεῖν, ἵνα γεμισθῇ ὁ οἶκός μου. ");
INSERT INTO grctr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Λέγω γὰρ ὑμῖν ὅτι οὐδεὶς τῶν ἀνδρῶν ἐκείνων τῶν κεκλημένων γεύσεταί μου τοῦ δείπνου. ");
INSERT INTO grctr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Συνεπορεύοντο δὲ αὐτῷ ὄχλοι πολλοί· καὶ στραφεὶς εἶπε πρὸς αὐτούς, ");
INSERT INTO grctr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Εἴ τις ἔρχεται πρός με, καὶ οὐ μισεῖ τὸν πατέρα ἑαυτοῦ, καὶ τὴν μητέρα, καὶ τὴν γυναῖκα, καὶ τὰ τέκνα, καὶ τοὺς ἀδελφούς, καὶ τὰς ἀδελφάς, ἔτι δὲ καὶ τὴν ἑαυτοῦ ψυχήν, οὐ δύναταί μου μαθητὴς εἶναι. ");
INSERT INTO grctr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Καὶ ὅστις οὐ βαστάζει τὸν σταυρὸν αὐτοῦ καὶ ἔρχεται ὀπίσω μου, οὐ δύναταί μου εἶναί μαθητής. ");
INSERT INTO grctr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Τίς γὰρ ἐξ ὑμῶν, θέλων πύργον οἰκοδομῆσαι, οὐχὶ πρῶτον καθίσας ψηφίζει τὴν δαπάνην, εἰ ἔχει τὰ πρὸς ἀπαρτισμόν; ");
INSERT INTO grctr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ἵνα μήποτε, θέντος αὐτοῦ θεμέλιον καὶ μὴ ἰσχύοντος ἐκτελέσαι, πάντες οἱ θεωροῦντες ἄρξωνται ἐμπαίζειν αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","λέγοντες, ὅτι Οὗτος ὁ ἄνθρωπος ἤρξατο οἰκοδομεῖν, καὶ οὐκ ἴσχυσεν ἐκτελέσαι. ");
INSERT INTO grctr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ἢ τίς βασιλεὺς πορευόμενος συμβαλεῖν ἑτέρῳ βασιλεῖ εἰς πόλεμον οὐχὶ καθίσας πρῶτον βουλεύεται εἰ δυνατός ἐστιν ἐν δέκα χιλιάσιν ἀπαντῆσαι τῷ μετὰ εἴκοσι χιλιάδων ἐρχομένῳ ἐπ᾿ αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Εἰ δὲ μήγε, ἔτι αὐτοῦ πόρρω ὄντος, πρεσβείαν ἀποστείλας ἐρωτᾷ τὰ πρὸς εἰρήνην. ");
INSERT INTO grctr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Οὕτως οὖν πᾶς ἐξ ὑμῶν ὃς οὐκ ἀποτάσσεται πᾶσι τοῖς ἑαυτοῦ ὑπάρχουσιν, οὐ δύναταί μου εἶναι μαθητής. ");
INSERT INTO grctr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Καλὸν τὸ ἅλας· ἐὰν δὲ τὸ ἅλας μωρανθῇ, ἐν τίνι ἀρτυθήσεται; ");
INSERT INTO grctr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Οὔτε εἰς γῆν οὔτε εἰς κοπρίαν εὔθετόν ἐστιν· ἔξω βάλλουσιν αὐτό. Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grctr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ἦσαν δὲ ἐγγίζοντες αὐτῷ πάντες οἱ τελῶναι καὶ οἱ ἁμαρτωλοί, ἀκούειν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Καὶ διεγόγγυζον οἱ Φαρισαῖοι καὶ οἱ γραμματεῖς λέγοντες ὅτι Οὗτος ἁμαρτωλοὺς προσδέχεται, καὶ συνεσθίει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Εἶπε δὲ πρὸς αὐτοὺς τὴν παραβολὴν ταύτην, λέγων, ");
INSERT INTO grctr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Τίς ἄνθρωπος ἐξ ὑμῶν ἔχων ἑκατὸν πρόβατα, καὶ ἀπολέσας ἓν ἐξ αὐτῶν, οὐ καταλείπει τὰ ἐννενηκονταεννέα ἐν τῇ ἐρήμῳ, καὶ πορεύεται ἐπὶ τὸ ἀπολωλός, ἕως εὕρῃ αὐτό; ");
INSERT INTO grctr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Καὶ εὑρὼν ἐπιτίθησιν ἐπὶ τοὺς ὤμους ἑαυτοῦ χαίρων. ");
INSERT INTO grctr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Καὶ ἐλθὼν εἰς τὸν οἶκον, συγκαλεῖ τοὺς φίλους καὶ τοὺς γείτονας, λέγων αὐτοῖς, Συγχάρητέ μοι, ὅτι εὗρον τὸ πρόβατόν μου τὸ ἀπολωλός. ");
INSERT INTO grctr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Λέγω ὑμῖν ὅτι οὕτω χαρὰ ἔσται ἐν τῷ οὐρανῷ ἐπὶ ἑνὶ ἁμαρτωλῷ μετανοοῦντι, ἢ ἐπὶ ἐννενηκονταεννέα δικαίοις, οἵτινες οὐ χρείαν ἔχουσι μετανοίας. ");
INSERT INTO grctr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ἢ τίς γυνὴ δραχμὰς ἔχουσα δέκα, ἐὰν ἀπολέσῃ δραχμὴν μίαν, οὐχὶ ἅπτει λύχνον, καὶ σαροῖ τὴν οἰκίαν, καὶ ζητεῖ ἐπιμελῶς ἕως ὅτου εὕρῃ; ");
INSERT INTO grctr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Καὶ εὑροῦσα συγκαλεῖται τὰς φίλας καὶ τὰς γείτονας, λέγουσα, Συγχάρητέ μοι, ὅτι εὗρον τὴν δραχμὴν ἣν ἀπώλεσα. ");
INSERT INTO grctr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Οὕτω, λέγω ὑμῖν, χαρὰ γίνεται ἐνώπιον τῶν ἀγγέλων τοῦ Θεοῦ ἐπὶ ἑνὶ ἁμαρτωλῷ μετανοοῦντι. ");
INSERT INTO grctr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Εἶπε δέ, Ἄνθρωπός τις εἶχε δύο υἱούς· ");
INSERT INTO grctr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","καὶ εἶπεν ὁ νεώτερος αὐτῶν τῷ πατρί, Πάτερ, δός μοι τὸ ἐπιβάλλον μέρος τῆς οὐσίας. Καὶ διεῖλεν αὐτοῖς τὸν βίον. ");
INSERT INTO grctr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Καὶ μετ᾿ οὐ πολλὰς ἡμέρας συναγαγὼν ἅπαντα ὁ νεώτερος υἱὸς ἀπεδήμησεν εἰς χώραν μακράν, καὶ ἐκεῖ διεσκόρπισε τὴν οὐσίαν αὐτοῦ, ζῶν ἀσώτως. ");
INSERT INTO grctr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Δαπανήσαντος δὲ αὐτοῦ πάντα, ἐγένετο λιμὸς ἰσχυρὸς κατὰ τὴν χώραν ἐκείνην, καὶ αὐτὸς ἤρξατο ὑστερεῖσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Καὶ πορευθεὶς ἐκολλήθη ἑνὶ τῶν πολιτῶν τῆς χώρας ἐκείνης· καὶ ἔπεμψεν αὐτὸν εἰς τοὺς ἀγροὺς αὐτοῦ βόσκειν χοίρους. ");
INSERT INTO grctr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Καὶ ἐπεθύμει γεμίσαι τὴν κοιλίαν αὐτοῦ ἀπὸ τῶν κερατίων ὧν ἤσθιον οἱ χοῖροι· καὶ οὐδεὶς ἐδίδου αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Εἰς ἑαυτὸν δὲ ἐλθὼν εἶπε, Πόσοι μίσθιοι τοῦ πατρός μου περισσεύουσιν ἄρτων, ἐγὼ δὲ λιμῷ ἀπόλλυμαι· ");
INSERT INTO grctr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ἀναστὰς πορεύσομαι πρὸς τὸν πατέρα μου, καὶ ἐρῶ αὐτῷ, Πάτερ, ἥμαρτον εἰς τὸν οὐρανὸν καὶ ἐνώπιόν σου· ");
INSERT INTO grctr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","καὶ οὐκέτι εἰμὶ ἄξιος κληθῆναι υἱός σου· ποίησόν με ὡς ἕνα τῶν μισθίων σου. ");
INSERT INTO grctr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Καὶ ἀναστὰς ἦλθε πρὸς τὸν πατέρα ἑαυτοῦ. Ἔτι δὲ αὐτοῦ μακρὰν ἀπέχοντος, εἶδεν αὐτὸν ὁ πατὴρ αὐτοῦ, καὶ ἐσπλαγχνίσθη, καὶ δραμὼν ἐπέπεσεν ἐπὶ τὸν τράχηλον αὐτοῦ, καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Εἶπε δὲ αὐτῷ ὁ υἱός, Πάτερ, ἥμαρτον εἰς τὸν οὐρανὸν καὶ ἐνώπιόν σου, καὶ οὐκέτι εἰμὶ ἄξιος κληθῆναι υἱός σου. ");
INSERT INTO grctr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Εἶπε δὲ ὁ πατὴρ πρὸς τοὺς δούλους αὐτοῦ, Ἐξενέγκατε τὴν στολὴν τὴν πρώτην καὶ ἐνδύσατε αὐτόν, καὶ δότε δακτύλιον εἰς τὴν χεῖρα αὐτοῦ, καὶ ὑποδήματα εἰς τοὺς πόδας· ");
INSERT INTO grctr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","καὶ ἐνέγκαντες τὸν μόσχον τὸν σιτευτὸν θύσατε, καὶ φαγόντες εὐφρανθῶμεν· ");
INSERT INTO grctr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ὅτι οὗτος ὁ υἱός μου νεκρὸς ἦν, καὶ ἀνέζησε· καὶ ἀπολωλὼς ἦν, καὶ εὑρέθη. Καὶ ἤρξαντο εὐφραίνεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ἦν δὲ ὁ υἱὸς αὐτοῦ ὁ πρεσβύτερος ἐν ἀγρῷ· καὶ ὡς ἐρχόμενος ἤγγισε τῇ οἰκίᾳ, ἤκουσε συμφωνίας καὶ χορῶν. ");
INSERT INTO grctr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Καὶ προσκαλεσάμενος ἕνα τῶν παίδων, ἐπυνθάνετο τί εἴη ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ὁ δὲ εἶπεν αὐτῷ ὅτι Ὁ ἀδελφός σου ἥκει· καὶ ἔθυσεν ὁ πατήρ σου τὸν μόσχον τὸν σιτευτόν, ὅτι ὑγιαίνοντα αὐτὸν ἀπέλαβεν. ");
INSERT INTO grctr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ὠργίσθη δέ, καὶ οὐκ ἤθελεν εἰσελθεῖν· ὁ οὖν πατὴρ αὐτοῦ ἐξελθὼν παρεκάλει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ὁ δὲ ἀποκριθεὶς εἶπε τῷ πατρί, Ἰδού, τοσαῦτα ἔτη δουλεύω σοι, καὶ οὐδέποτε ἐντολήν σου παρῆλθον, καὶ ἐμοὶ οὐδέποτε ἔδωκας ἔριφον, ἵνα μετὰ τῶν φίλων μου εὐφρανθῶ. ");
INSERT INTO grctr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ὅτε δὲ ὁ υἱός σου οὗτος ὁ καταφαγών σου τὸν βίον μετὰ πορνῶν ἦλθεν, ἔθυσας αὐτῷ τὸν μόσχον τὸν σιτευτόν. ");
INSERT INTO grctr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ὁ δὲ εἶπεν αὐτῷ, Τέκνον, σὺ πάντοτε μετ᾿ ἐμοῦ εἶ, καὶ πάντα τὰ ἐμὰ σά ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Εὐφρανθῆναι δὲ καὶ χαρῆναι ἔδει· ὅτι ὁ ἀδελφός σου οὗτος νεκρὸς ἦν, καὶ ἀνέζησε· καὶ ἀπολωλὼς ἦν, καὶ εὑρέθη. ");
INSERT INTO grctr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ἔλεγε δὲ καὶ πρὸς τοὺς μαθητὰς αὐτοῦ, Ἄνθρωπός τις ἦν πλούσιος, ὃς εἶχεν οἰκονόμον· καὶ οὗτος διεβλήθη αὐτῷ ὡς διασκορπίζων τὰ ὑπάρχοντα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Καὶ φωνήσας αὐτὸν εἶπεν αὐτῷ, Τί τοῦτο ἀκούω περὶ σοῦ; Ἀπόδος τὸν λόγον τῆς οἰκονομίας σου· οὐ γὰρ δυνήσῃ ἔτι οἰκονομεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Εἶπε δὲ ἐν ἑαυτῷ ὁ οἰκονόμος, Τί ποιήσω, ὅτι ὁ κύριός μου ἀφαιρεῖται τὴν οἰκονομίαν ἀπ᾿ ἐμοῦ; Σκάπτειν οὐκ ἰσχύω, ἐπαιτεῖν αἰσχύνομαι. ");
INSERT INTO grctr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ἔγνων τί ποιήσω, ἵνα, ὅταν μετασταθῶ τῆς οἰκονομίας, δέξωνταί με εἰς τοὺς οἴκους αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Καὶ προσκαλεσάμενος ἕνα ἕκαστον τῶν χρεωφειλετῶν τοῦ κυρίου ἑαυτοῦ, ἔλεγε τῷ πρώτῳ, Πόσον ὀφείλεις τῷ κυρίῳ μου; ");
INSERT INTO grctr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ὁ δὲ εἶπεν, Ἑκατὸν βάτους ἐλαίου. Καὶ εἶπεν αὐτῷ, Δέξαι σου τὸ γράμμα, καὶ καθίσας ταχέως γράψον πεντήκοντα. ");
INSERT INTO grctr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ἔπειτα ἑτέρῳ εἶπε, Σὺ δὲ πόσον ὀφείλεις; Ὁ δὲ εἶπεν, Ἑκατὸν κόρους σίτου. Καὶ λέγει αὐτῷ, Δέξαι σου τὸ γράμμα, καὶ γράψον ὀγδοήκοντα. ");
INSERT INTO grctr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Καὶ ἐπῄνεσεν ὁ κύριος τὸν οἰκονόμον τῆς ἀδικίας ὅτι φρονίμως ἐποίησεν· ὅτι οἱ υἱοὶ τοῦ αἰῶνος τούτου φρονιμώτεροι ὑπὲρ τοὺς υἱοὺς τοῦ φωτὸς εἰς τὴν γενεὰν τὴν ἑαυτῶν εἰσί. ");
INSERT INTO grctr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Κἀγὼ ὑμῖν λέγω, Ποιήσατε ἑαυτοῖς φίλους ἐκ τοῦ μαμωνᾶ τῆς ἀδικίας, ἵνα, ὅταν ἐκλίπητε, δέξωνται ὑμᾶς εἰς τὰς αἰωνίους σκηνάς. ");
INSERT INTO grctr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ὁ πιστὸς ἐν ἐλαχίστῳ καὶ ἐν πολλῷ πιστός ἐστι, καὶ ὁ ἐν ἐλαχίστῳ ἄδικος καὶ ἐν πολλῷ ἄδικός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Εἰ οὖν ἐν τῷ ἀδίκῳ μαμωνᾷ πιστοὶ οὐκ ἐγένεσθε, τὸ ἀληθινὸν τίς ὑμῖν πιστεύσει; ");
INSERT INTO grctr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Καὶ εἰ ἐν τῷ ἀλλοτρίῳ πιστοὶ οὐκ ἐγένεσθε, τὸ ὑμέτερον τίς ὑμῖν δώσει; ");
INSERT INTO grctr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Οὐδεὶς οἰκέτης δύναται δυσὶ κυρίοις δουλεύειν· ἢ γὰρ τὸν ἕνα μισήσει, καὶ τὸν ἕτερον ἀγαπήσει· ἢ ἑνὸς ἀνθέξεται, καὶ τοῦ ἑτέρου καταφρονήσει. Οὐ δύνασθε Θεῷ δουλεύειν καὶ μαμωνᾷ. ");
INSERT INTO grctr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ἤκουον δὲ ταῦτα πάντα καὶ οἱ Φαρισαῖοι φιλάργυροι ὑπάρχοντες, καὶ ἐξεμυκτήριζον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Καὶ εἶπεν αὐτοῖς, Ὑμεῖς ἐστε οἱ δικαιοῦντες ἑαυτοὺς ἐνώπιον τῶν ἀνθρώπων, ὁ δὲ Θεὸς γινώσκει τὰς καρδίας ὑμῶν· ὅτι τὸ ἐν ἀνθρώποις ὑψηλὸν βδέλυγμα ἐνώπιον τοῦ Θεοῦ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ὁ νόμος καὶ οἱ προφῆται ἕως Ἰωάννου· ἀπὸ τότε ἡ βασιλεία τοῦ Θεοῦ εὐαγγελίζεται, καὶ πᾶς εἰς αὐτὴν βιάζεται. ");
INSERT INTO grctr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Εὐκοπώτερον δέ ἐστι τὸν οὐρανὸν καὶ τὴν γῆν παρελθεῖν, ἢ τοῦ νόμου μίαν κεραίαν πεσεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Πᾶς ὁ ἀπολύων τὴν γυναῖκα αὐτοῦ καὶ γαμῶν ἑτέραν μοιχεύει· καὶ πᾶς ὁ ἀπολελυμένην ἀπὸ ἀνδρὸς γαμῶν μοιχεύει. ");
INSERT INTO grctr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ἄνθρωπος δέ τις ἦν πλούσιος, καὶ ἐνεδιδύσκετο πορφύραν καὶ βύσσον, εὐφραινόμενος καθ᾿ ἡμέραν λαμπρῶς. ");
INSERT INTO grctr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Πτωχὸς δέ τις ἦν ὀνόματι Λάζαρος, ὃς ἐβέβλητο πρὸς τὸν πυλῶνα αὐτοῦ ἡλκωμένος ");
INSERT INTO grctr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","καὶ ἐπιθυμῶν χορτασθῆναι ἀπὸ τῶν ψιχίων τῶν πιπτόντων ἀπὸ τῆς τραπέζης τοῦ πλουσίου· ἀλλὰ καὶ οἱ κύνες ἐρχόμενοι ἀπέλειχον τὰ ἕλκη αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ἐγένετο δὲ ἀποθανεῖν τὸν πτωχόν, καὶ ἀπενεχθῆναι αὐτὸν ὑπὸ τῶν ἀγγέλων εἰς τὸν κόλπον τοῦ Ἀβραάμ· ἀπέθανε δὲ καὶ ὁ πλούσιος, καὶ ἐτάφη. ");
INSERT INTO grctr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Καὶ ἐν τῷ ᾍδῃ ἐπάρας τοὺς ὀφθαλμοὺς αὐτοῦ, ὑπάρχων ἐν βασάνοις, ὁρᾷ τὸν Ἀβραὰμ ἀπὸ μακρόθεν, καὶ Λάζαρον ἐν τοῖς κόλποις αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Καὶ αὐτὸς φωνήσας εἶπε, Πάτερ Ἀβραάμ, ἐλέησόν με, καὶ πέμψον Λάζαρον, ἵνα βάψῃ τὸ ἄκρον τοῦ δακτύλου αὐτοῦ ὕδατος, καὶ καταψύξῃ τὴν γλῶσσάν μου· ὅτι ὀδυνῶμαι ἐν τῇ φλογὶ ταύτῃ. ");
INSERT INTO grctr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Εἶπε δὲ Ἀβραάμ, Τέκνον, μνήσθητι ὅτι ἀπέλαβες σὺ τὰ ἀγαθά σου ἐν τῇ ζωῇ σου, καὶ Λάζαρος ὁμοίως τὰ κακά· νῦν δὲ ὅδε παρακαλεῖται, σὺ δὲ ὀδυνᾶσαι. ");
INSERT INTO grctr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Καὶ ἐπὶ πᾶσι τούτοις, μεταξὺ ἡμῶν καὶ ὑμῶν χάσμα μέγα ἐστήρικται, ὅπως οἱ θέλοντες διαβῆναι ἐντεῦθεν πρὸς ὑμᾶς μὴ δύνωνται, μηδὲ οἱ ἐκεῖθεν πρὸς ἡμᾶς διαπερῶσιν. ");
INSERT INTO grctr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Εἶπε δέ, Ἐρωτῶ οὖν σε, πάτερ, ἵνα πέμψῃς αὐτὸν εἰς τὸν οἶκον τοῦ πατρός μου, ");
INSERT INTO grctr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ἔχω γὰρ πέντε ἀδελφούς, ὅπως διαμαρτύρηται αὐτοῖς, ἵνα μὴ καὶ αὐτοὶ ἔλθωσιν εἰς τὸν τόπον τοῦτον τῆς βασάνου. ");
INSERT INTO grctr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Λέγει αὐτῷ Ἀβραάμ, Ἔχουσι Μωσέα καὶ τοὺς προφήτας· ἀκουσάτωσαν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ὁ δὲ εἶπεν, Οὐχί, πάτερ Ἀβραάμ· ἀλλ᾿ ἐάν τις ἀπὸ νεκρῶν πορευθῇ πρὸς αὐτούς, μετανοήσουσιν. ");
INSERT INTO grctr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Εἶπε δὲ αὐτῷ, Εἰ Μωσέως καὶ τῶν προφητῶν οὐκ ἀκούουσιν, οὐδέ, ἐάν τις ἐκ νεκρῶν ἀναστῇ, πεισθήσονται. ");
INSERT INTO grctr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Εἶπε δὲ πρὸς τοὺς μαθητάς, Ἀνένδεκτόν ἐστι τοῦ μὴ ἐλθεῖν τὰ σκάνδαλα· οὐαὶ δὲ δι᾿ οὗ ἔρχεται. ");
INSERT INTO grctr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Λυσιτελεῖ αὐτῷ εἰ μύλος ὀνικὸς περίκειται περὶ τὸν τράχηλον αὐτοῦ, καὶ ἔρριπται εἰς τὴν θάλασσαν, ἢ ἵνα σκανδαλίσῃ ἕνα τῶν μικρῶν τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Προσέχετε ἑαυτοῖς. Ἐὰν δὲ ἁμάρτῃ εἰς σὲ ὁ ἀδελφός σου, ἐπιτίμησον αὐτῷ· καὶ ἐὰν μετανοήσῃ, ἄφες αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Καὶ ἐὰν ἑπτάκις τῆς ἡμέρας ἁμάρτῃ εἰς σέ, καὶ ἑπτάκις τῆς ἡμέρας ἐπιστρέψῃ ἐπί σε, λέγων, Μετανοῶ, ἀφήσεις αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Καὶ εἶπον οἱ ἀπόστολοι τῷ Κυρίῳ, Πρόσθες ἡμῖν πίστιν. ");
INSERT INTO grctr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Εἶπε δὲ ὁ Κύριος, Εἰ εἴχετε πίστιν ὡς κόκκον σινάπεως, ἐλέγετε ἂν τῇ συκαμίνῳ ταύτῃ, Ἐκριζώθητι, καὶ φυτεύθητι ἐν τῇ θαλάσσῃ· καὶ ὑπήκουσεν ἂν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Τίς δὲ ἐξ ὑμῶν δοῦλον ἔχων ἀροτριῶντα ἢ ποιμαίνοντα, ὃς εἰσελθόντι ἐκ τοῦ ἀγροῦ ἐρεῖ εὐθέως, Παρελθὼν ἀνάπεσαι· ");
INSERT INTO grctr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ἀλλ᾿ οὐχὶ ἐρεῖ αὐτῷ, Ἑτοίμασον τί δειπνήσω, καὶ περιζωσάμενος διακόνει μοι, ἕως φάγω καὶ πίω· καὶ μετὰ ταῦτα φάγεσαι καὶ πίεσαι σύ; ");
INSERT INTO grctr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Μὴ χάριν ἔχει τῷ δούλῳ ἐκείνῳ ὅτι ἐποίησε τὰ διαταχθέντα αὐτῷ; Οὐ δοκῶ. ");
INSERT INTO grctr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Οὕτω καὶ ὑμεῖς, ὅταν ποιήσητε πάντα τὰ διαταχθέντα ὑμῖν, λέγετε ὅτι Δοῦλοι ἀχρεῖοί ἐσμεν· ὅτι ὃ ὠφείλομεν ποιῆσαι πεποιήκαμεν. ");
INSERT INTO grctr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Καὶ ἐγένετο ἐν τῷ πορεύεσθαι αὐτὸν εἰς Ἱερουσαλήμ, καὶ αὐτὸς διήρχετο διὰ μέσου Σαμαρείας καὶ Γαλιλαίας. ");
INSERT INTO grctr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Καὶ εἰσερχομένου αὐτοῦ εἴς τινα κώμην, ἀπήντησαν αὐτῷ δέκα λεπροὶ ἄνδρες, οἳ ἔστησαν πόρρωθεν· ");
INSERT INTO grctr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","καὶ αὐτοὶ ἦραν φωνήν, λέγοντες, Ἰησοῦ, ἐπιστάτα, ἐλέησον ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Καὶ ἰδὼν εἶπεν αὐτοῖς, Πορευθέντες ἐπιδείξατε ἑαυτοὺς τοῖς ἱερεῦσι. Καὶ ἐγένετο ἐν τῷ ὑπάγειν αὐτούς, ἐκαθαρίσθησαν. ");
INSERT INTO grctr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Εἷς δὲ ἐξ αὐτῶν, ἰδὼν ὅτι ἰάθη, ὑπέστρεψε, μετὰ φωνῆς μεγάλης δοξάζων τὸν Θεόν· ");
INSERT INTO grctr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","καὶ ἔπεσεν ἐπὶ πρόσωπον παρὰ τοὺς πόδας αὐτοῦ, εὐχαριστῶν αὐτῷ· καὶ αὐτὸς ἦν Σαμαρείτης. ");
INSERT INTO grctr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Οὐχὶ οἱ δέκα ἐκαθαρίσθησαν; Οἱ δὲ ἐννέα ποῦ; ");
INSERT INTO grctr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Οὐχ εὑρέθησαν ὑποστρέψαντες δοῦναι δόξαν τῷ Θεῷ, εἰ μὴ ὁ ἀλλογενὴς οὗτος. ");
INSERT INTO grctr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Καὶ εἶπεν αὐτῷ, Ἀναστὰς πορεύου· ἡ πίστις σου σέσωκέ σε. ");
INSERT INTO grctr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ἐπερωτηθεὶς δὲ ὑπὸ τῶν Φαρισαίων, πότε ἔρχεται ἡ βασιλεία τοῦ Θεοῦ, ἀπεκρίθη αὐτοῖς καὶ εἶπεν, Οὐκ ἔρχεται ἡ βασιλεία τοῦ Θεοῦ μετὰ παρατηρήσεως· ");
INSERT INTO grctr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","οὐδὲ ἐροῦσιν, Ἰδοὺ ὧδε, ἤ, Ἰδοὺ ἐκεῖ. Ἰδοὺ γάρ, ἡ βασιλεία τοῦ Θεοῦ ἐντὸς ὑμῶν ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Εἶπε δὲ πρὸς τοὺς μαθητάς, Ἐλεύσονται ἡμέραι ὅτε ἐπιθυμήσετε μίαν τῶν ἡμερῶν τοῦ υἱοῦ τοῦ ἀνθρώπου ἰδεῖν, καὶ οὐκ ὄψεσθε. ");
INSERT INTO grctr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Καὶ ἐροῦσιν ὑμῖν, Ἰδοὺ ὧδε, ἤ, Ἰδοὺ ἐκεῖ· μὴ ἀπέλθητε, μηδὲ διώξητε. ");
INSERT INTO grctr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ὥσπερ γὰρ ἡ ἀστραπὴ ἡ ἀστράπτουσα ἐκ τῆς ὑπ᾿ οὐρανὸν εἰς τὴν ὑπ᾿ οὐρανὸν λάμπει, οὕτως ἔσται καὶ ὁ υἱὸς τοῦ ἀνθρώπου ἐν τῇ ἡμέρᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Πρῶτον δὲ δεῖ αὐτὸν πολλὰ παθεῖν καὶ ἀποδοκιμασθῆναι ἀπὸ τῆς γενεᾶς ταύτης. ");
INSERT INTO grctr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Καὶ καθὼς ἐγένετο ἐν ταῖς ἡμέραις τοῦ Νῶε, οὕτως ἔσται καὶ ἐν ταῖς ἡμέραις τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ἤσθιον, ἔπινον, ἐγάμουν, ἐξεγαμίζοντο, ἄχρι ἧς ἡμέρας εἰσῆλθε Νῶε εἰς τὴν κιβωτόν, καὶ ἦλθεν ὁ κατακλυσμός, καὶ ἀπώλεσεν ἅπαντας. ");
INSERT INTO grctr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ὁμοίως καὶ ὡς ἐγένετο ἐν ταῖς ἡμέραις Λώτ· ἤσθιον, ἔπινον, ἠγόραζον, ἐπώλουν, ἐφύτευον, ᾠκοδόμουν· ");
INSERT INTO grctr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ᾗ δὲ ἡμέρᾳ ἐξῆλθε Λὼτ ἀπὸ Σοδόμων, ἔβρεξε πῦρ καὶ θεῖον ἀπ᾿ οὐρανοῦ, καὶ ἀπώλεσεν ἅπαντας· ");
INSERT INTO grctr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","κατὰ ταῦτα ἔσται ᾗ ἡμέρᾳ ὁ υἱὸς τοῦ ἀνθρώπου ἀποκαλύπτεται. ");
INSERT INTO grctr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ἐν ἐκείνῃ τῇ ἡμέρᾳ, ὃς ἔσται ἐπὶ τοῦ δώματος, καὶ τὰ σκεύη αὐτοῦ ἐν τῇ οἰκίᾳ, μὴ καταβάτω ἆραι αὐτά· καὶ ὁ ἐν τῷ ἀγρῷ ὁμοίως μὴ ἐπιστρεψάτω εἰς τὰ ὀπίσω. ");
INSERT INTO grctr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Μνημονεύετε τῆς γυναικὸς Λώτ. ");
INSERT INTO grctr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ὃς ἐὰν ζητήσῃ τὴν ψυχὴν αὐτοῦ σῶσαι ἀπολέσει αὐτήν· καὶ ὃς ἐὰν ἀπολέσῃ αὐτὴν ζῳογονήσει αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Λέγω ὑμῖν, ταύτῃ τῇ νυκτὶ ἔσονται δύο ἐπὶ κλίνης μιᾶς· ὁ εἷς παραληφθήσεται, καὶ ὁ ἕτερος ἀφεθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Δύο ἔσονται ἀλήθουσαι ἐπὶ τὸ αὐτό· ἡ μία παραληφθήσεται, καὶ ἡ ἑτέρα ἀφεθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Δύο ἔσονται ἐν τῷ ἀγρῷ· ὁ εἷς παραληφθήσεται, καὶ ὁ ἕτερος ἀφεθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Καὶ ἀποκριθέντες λέγουσιν αὐτῷ, Ποῦ, Κύριε; Ὁ δὲ εἶπεν αὐτοῖς, Ὅπου τὸ σῶμα, ἐκεῖ συναχθήσονται οἱ ἀετοί. ");
INSERT INTO grctr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ἔλεγε δὲ καὶ παραβολὴν αὐτοῖς πρὸς τὸ δεῖν πάντοτε προσεύχεσθαι, καὶ μὴ ἐκκακεῖν, ");
INSERT INTO grctr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","λέγων, Κριτής τις ἦν ἔν τινι πόλει, τὸν Θεὸν μὴ φοβούμενος, καὶ ἄνθρωπον μὴ ἐντρεπόμενος· ");
INSERT INTO grctr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","χήρα δὲ ἦν ἐν τῇ πόλει ἐκείνῃ, καὶ ἤρχετο πρὸς αὐτόν, λέγουσα, Ἐκδίκησόν με ἀπὸ τοῦ ἀντιδίκου μου. ");
INSERT INTO grctr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Καὶ οὐκ ἠθέλησεν ἐπὶ χρόνον· μετὰ δὲ ταῦτα εἶπεν ἐν ἑαυτῷ, Εἰ καὶ τὸν Θεὸν οὐ φοβοῦμαι, καὶ ἄνθρωπον οὐκ ἐντρέπομαι· ");
INSERT INTO grctr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","διά γε τὸ παρέχειν μοι κόπον τὴν χήραν ταύτην, ἐκδικήσω αὐτήν, ἵνα μὴ εἰς τέλος ἐρχομένη ὑπωπιάζῃ με. ");
INSERT INTO grctr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Εἶπε δὲ ὁ Κύριος, Ἀκούσατε τί ὁ κριτὴς τῆς ἀδικίας λέγει. ");
INSERT INTO grctr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ὁ δὲ Θεὸς οὐ μὴ ποιήσει τὴν ἐκδίκησιν τῶν ἐκλεκτῶν αὐτοῦ τῶν βοώντων πρὸς αὐτὸν ἡμέρας καὶ νυκτός, καὶ μακροθυμῶν ἐπ᾿ αὐτοῖς; ");
INSERT INTO grctr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Λέγω ὑμῖν ὅτι ποιήσει τὴν ἐκδίκησιν αὐτῶν ἐν τάχει. Πλὴν ὁ υἱὸς τοῦ ἀνθρώπου ἐλθὼν ἆρα εὑρήσει τὴν πίστιν ἐπὶ τῆς γῆς; ");
INSERT INTO grctr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Εἶπε δὲ καὶ πρός τινας τοὺς πεποιθότας ἐφ᾿ ἑαυτοῖς ὅτι εἰσὶ δίκαιοι, καὶ ἐξουθενοῦντας τοὺς λοιπούς, τὴν παραβολὴν ταύτην· ");
INSERT INTO grctr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ἄνθρωποι δύο ἀνέβησαν εἰς τὸ ἱερὸν προσεύξασθαι· ὁ εἷς Φαρισαῖος, καὶ ὁ ἕτερος τελώνης. ");
INSERT INTO grctr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ὁ Φαρισαῖος σταθεὶς πρὸς ἑαυτὸν ταῦτα προσηύχετο, Ὁ Θεός, εὐχαριστῶ σοι ὅτι οὐκ εἰμὶ ὥσπερ οἱ λοιποὶ τῶν ἀνθρώπων, ἅρπαγες, ἄδικοι, μοιχοί, ἢ καὶ ὡς οὗτος ὁ τελώνης. ");
INSERT INTO grctr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Νηστεύω δὶς τοῦ σαββάτου, ἀποδεκατῶ πάντα ὅσα κτῶμαι. ");
INSERT INTO grctr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Καὶ ὁ τελώνης μακρόθεν ἑστὼς οὐκ ἤθελεν οὐδὲ τοὺς ὀφθαλμοὺς εἰς τὸν οὐρανὸν ἐπᾶραι, ἀλλ᾿ ἔτυπτεν εἰς τὸ στῆθος αὐτοῦ, λέγων, Ὁ Θεός, ἱλάσθητί μοι τῷ ἁμαρτωλῷ. ");
INSERT INTO grctr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Λέγω ὑμῖν, κατέβη οὗτος δεδικαιωμένος εἰς τὸν οἶκον αὐτοῦ ἢ ἐκεῖνος· ὅτι πᾶς ὁ ὑψῶν ἑαυτὸν ταπεινωθήσεται, ὁ δὲ ταπεινῶν ἑαυτὸν ὑψωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Προσέφερον δὲ αὐτῷ καὶ τὰ βρέφη, ἵνα αὐτῶν ἅπτηται· ἰδόντες δὲ οἱ μαθηταὶ ἐπετίμησαν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ὁ δὲ Ἰησοῦς προσκαλεσάμενος αὐτὰ εἶπεν, Ἄφετε τὰ παιδία ἔρχεσθαι πρός με, καὶ μὴ κωλύετε αὐτά· τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ἀμὴν λέγω ὑμῖν, ὃς ἐὰν μὴ δέξηται τὴν βασιλείαν τοῦ Θεοῦ ὡς παιδίον, οὐ μὴ εἰσέλθῃ εἰς αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Καὶ ἐπηρώτησέ τις αὐτὸν ἄρχων, λέγων, Διδάσκαλε ἀγαθέ, τί ποιήσας ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grctr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Εἶπε δὲ αὐτῷ ὁ Ἰησοῦς, Τί με λέγεις ἀγαθόν; Οὐδεὶς ἀγαθός, εἰ μὴ εἷς, ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Τὰς ἐντολὰς οἶδας, Μὴ μοιχεύσῃς, μὴ φονεύσῃς, μὴ κλέψῃς, μὴ ψευδομαρτυρήσῃς, τίμα τὸν πατέρα σου καὶ τὴν μητέρα σου. ");
INSERT INTO grctr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ὁ δὲ εἶπε, Ταῦτα πάντα ἐφυλαξάμην ἐκ νεότητός μου. ");
INSERT INTO grctr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ἀκούσας δὲ ταῦτα ὁ Ἰησοῦς εἶπεν αὐτῷ, Ἔτι ἕν σοι λείπει· πάντα ὅσα ἔχεις πώλησον, καὶ διάδος πτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν οὐρανῷ· καὶ δεῦρο, ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ὁ δὲ ἀκούσας ταῦτα περίλυπος ἐγένετο· ἦν γὰρ πλούσιος σφόδρα. ");
INSERT INTO grctr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ἰδὼν δὲ αὐτὸν ὁ Ἰησοῦς περίλυπον γενόμενον εἶπε, Πῶς δυσκόλως οἱ τὰ χρήματα ἔχοντες εἰσελεύσονται εἰς τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Εὐκοπώτερον γάρ ἐστι κάμηλον διὰ τρυμαλιᾶς ῥαφίδος εἰσελθεῖν, ἢ πλούσιον εἰς τὴν βασιλείαν τοῦ Θεοῦ εἰσελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Εἶπον δὲ οἱ ἀκούσαντες, Καὶ τίς δύναται σωθῆναι; ");
INSERT INTO grctr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ὁ δὲ εἶπε, Τὰ ἀδύνατα παρὰ ἀνθρώποις δυνατά ἐστι παρὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Εἶπε δὲ ὁ Πέτρος, Ἰδού, ἡμεῖς ἀφήκαμεν πάντα καὶ ἠκολουθήσαμέν σοι. ");
INSERT INTO grctr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ὁ δὲ εἶπεν αὐτοῖς, Ἀμὴν λέγω ὑμῖν ὅτι οὐδείς ἐστιν ὃς ἀφῆκεν οἰκίαν, ἢ γονεῖς, ἢ ἀδελφούς, ἢ γυναῖκα, ἢ τέκνα, ἕνεκεν τῆς βασιλείας τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ὃς οὐ μὴ ἀπολάβῃ πολλαπλασίονα ἐν τῷ καιρῷ τούτῳ, καὶ ἐν τῷ αἰῶνι τῷ ἐρχομένῳ ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Παραλαβὼν δὲ τοὺς δώδεκα, εἶπε πρὸς αὐτούς, Ἰδού, ἀναβαίνομεν εἰς Ἱεροσόλυμα, καὶ τελεσθήσεται πάντα τὰ γεγραμμένα διὰ τῶν προφητῶν τῷ υἱῷ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Παραδοθήσεται γὰρ τοῖς ἔθνεσι, καὶ ἐμπαιχθήσεται, καὶ ὑβρισθήσεται, καὶ ἐμπτυσθήσεται, ");
INSERT INTO grctr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","καὶ μαστιγώσαντες ἀποκτενοῦσιν αὐτόν· καὶ τῇ ἡμέρᾳ τῇ τρίτῃ ἀναστήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Καὶ αὐτοὶ οὐδὲν τούτων συνῆκαν, καὶ ἦν τὸ ῥῆμα τοῦτο κεκρυμμένον ἀπ᾿ αὐτῶν, καὶ οὐκ ἐγίνωσκον τὰ λεγόμενα. ");
INSERT INTO grctr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ἐγένετο δὲ ἐν τῷ ἐγγίζειν αὐτὸν εἰς Ἰεριχώ, τυφλός τις ἐκάθητο παρὰ τὴν ὁδὸν προσαιτῶν· ");
INSERT INTO grctr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ἀκούσας δὲ ὄχλου διαπορευομένου, ἐπυνθάνετο τί εἴη τοῦτο. ");
INSERT INTO grctr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ἀπήγγειλαν δὲ αὐτῷ ὅτι Ἰησοῦς ὁ Ναζωραῖος παρέρχεται. ");
INSERT INTO grctr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Καὶ ἐβόησε, λέγων, Ἰησοῦ, υἱὲ Δαβίδ, ἐλέησόν με. ");
INSERT INTO grctr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Καὶ οἱ προάγοντες ἐπετίμων αὐτῷ ἵνα σιωπήσῃ· αὐτὸς δὲ πολλῷ μᾶλλον ἔκραζεν, Υἱὲ Δαβίδ, ἐλέησόν με. ");
INSERT INTO grctr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Σταθεὶς δὲ ὁ Ἰησοῦς ἐκέλευσεν αὐτὸν ἀχθῆναι πρὸς αὐτόν· ἐγγίσαντος δὲ αὐτοῦ ἐπηρώτησεν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","λέγων, Τί σοι θέλεις ποιήσω; Ὁ δὲ εἶπε, Κύριε, ἵνα ἀναβλέψω. ");
INSERT INTO grctr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Καὶ ὁ Ἰησοῦς εἶπεν αὐτῷ, Ἀνάβλεψον· ἡ πίστις σου σέσωκέ σε. ");
INSERT INTO grctr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Καὶ παραχρῆμα ἀνέβλεψε, καὶ ἠκολούθει αὐτῷ, δοξάζων τὸν Θεόν· καὶ πᾶς ὁ λαὸς ἰδὼν ἔδωκεν αἶνον τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Καὶ εἰσελθὼν διήρχετο τὴν Ἰεριχώ. ");
INSERT INTO grctr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Καὶ ἰδού, ἀνὴρ ὀνόματι καλούμενος Ζακχαῖος, καὶ αὐτὸς ἦν ἀρχιτελώνης, καὶ οὗτος ἦν πλούσιος. ");
INSERT INTO grctr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Καὶ ἐζήτει ἰδεῖν τὸν Ἰησοῦν τίς ἐστι, καὶ οὐκ ἠδύνατο ἀπὸ τοῦ ὄχλου, ὅτι τῇ ἡλικίᾳ μικρὸς ἦν. ");
INSERT INTO grctr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Καὶ προδραμὼν ἔμπροσθεν ἀνέβη ἐπὶ συκομωραίαν ἵνα ἴδῃ αὐτόν· ὅτι δι᾿ ἐκείνης ἤμελλε διέρχεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Καὶ ὡς ἦλθεν ἐπὶ τὸν τόπον, ἀναβλέψας ὁ Ἰησοῦς εἶδεν αὐτόν, καὶ εἶπε πρὸς αὐτόν, Ζακχαῖε, σπεύσας κατάβηθι· σήμερον γὰρ ἐν τῷ οἴκῳ σου δεῖ με μεῖναι. ");
INSERT INTO grctr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Καὶ σπεύσας κατέβη, καὶ ὑπεδέξατο αὐτὸν χαίρων. ");
INSERT INTO grctr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Καὶ ἰδόντες ἅπαντες διεγόγγυζον, λέγοντες ὅτι Παρὰ ἁμαρτωλῷ ἀνδρὶ εἰσῆλθε καταλῦσαι. ");
INSERT INTO grctr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Σταθεὶς δὲ Ζακχαῖος εἶπε πρὸς τὸν Κύριον, Ἰδού, τὰ ἡμίση τῶν ὑπαρχόντων μου, Κύριε, δίδωμι τοῖς πτωχοῖς· καὶ εἴ τινός τι ἐσυκοφάντησα, ἀποδίδωμι τετραπλοῦν. ");
INSERT INTO grctr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Εἶπε δὲ πρὸς αὐτὸν ὁ Ἰησοῦς ὅτι Σήμερον σωτηρία τῷ οἴκῳ τούτῳ ἐγένετο, καθότι καὶ αὐτὸς υἱὸς Ἀβραάμ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ἦλθε γὰρ ὁ υἱὸς τοῦ ἀνθρώπου ζητῆσαι καὶ σῶσαι τὸ ἀπολωλός. ");
INSERT INTO grctr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ἀκουόντων δὲ αὐτῶν ταῦτα, προσθεὶς εἶπε παραβολήν, διὰ τὸ ἐγγὺς αὐτὸν εἶναι Ἱερουσαλήμ, καὶ δοκεῖν αὐτοὺς ὅτι παραχρῆμα μέλλει ἡ βασιλεία τοῦ Θεοῦ ἀναφαίνεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Εἶπεν οὖν, Ἄνθρωπός τις εὐγενὴς ἐπορεύθη εἰς χώραν μακράν, λαβεῖν ἑαυτῷ βασιλείαν, καὶ ὑποστρέψαι. ");
INSERT INTO grctr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Καλέσας δὲ δέκα δούλους ἑαυτοῦ, ἔδωκεν αὐτοῖς δέκα μνᾶς, καὶ εἶπε πρὸς αὐτούς, Πραγματεύσασθε ἕως ἔρχομαι. ");
INSERT INTO grctr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Οἱ δὲ πολῖται αὐτοῦ ἐμίσουν αὐτόν, καὶ ἀπέστειλαν πρεσβείαν ὀπίσω αὐτοῦ, λέγοντες, Οὐ θέλομεν τοῦτον βασιλεῦσαι ἐφ᾿ ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Καὶ ἐγένετο ἐν τῷ ἐπανελθεῖν αὐτὸν λαβόντα τὴν βασιλείαν, καὶ εἶπε φωνηθῆναι αὐτῷ τοὺς δούλους τούτους, οἷς ἔδωκε τὸ ἀργύριον, ἵνα γνῷ τίς τί διεπραγματεύσατο. ");
INSERT INTO grctr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Παρεγένετο δὲ ὁ πρῶτος, λέγων, Κύριε, ἡ μνᾶ σου προσειργάσατο δέκα μνᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Καὶ εἶπεν αὐτῷ, Εὖ, ἀγαθὲ δοῦλε· ὅτι ἐν ἐλαχίστῳ πιστὸς ἐγένου, ἴσθι ἐξουσίαν ἔχων ἐπάνω δέκα πόλεων. ");
INSERT INTO grctr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Καὶ ἦλθεν ὁ δεύτερος, λέγων, Κύριε, ἡ μνᾶ σου ἐποίησε πέντε μνᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Εἶπε δὲ καὶ τούτῳ, Καὶ σὺ γίνου ἐπάνω πέντε πόλεων. ");
INSERT INTO grctr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Καὶ ἕτερος ἦλθε, λέγων, Κύριε, ἰδού, ἡ μνᾶ σου, ἣν εἶχον ἀποκειμένην ἐν σουδαρίῳ· ");
INSERT INTO grctr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ἐφοβούμην γάρ σε, ὅτι ἄνθρωπος αὐστηρὸς εἶ· αἴρεις ὃ οὐκ ἔθηκας, καὶ θερίζεις ὃ οὐκ ἔσπειρας. ");
INSERT INTO grctr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Λέγει δὲ αὐτῷ, Ἐκ τοῦ στόματός σου κρινῶ σε, πονηρὲ δοῦλε. ᾜδεις ὅτι ἐγὼ ἄνθρωπος αὐστηρός εἰμι, αἴρων ὃ οὐκ ἔθηκα, καὶ θερίζων ὃ οὐκ ἔσπειρα· ");
INSERT INTO grctr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","καὶ διὰ τί οὐκ ἔδωκας τὸ ἀργύριόν μου ἐπὶ τὴν τράπεζαν, καὶ ἐγὼ ἐλθὼν σὺν τόκῳ ἂν ἔπραξα αὐτό; ");
INSERT INTO grctr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Καὶ τοῖς παρεστῶσιν εἶπεν, Ἄρατε ἀπ᾿ αὐτοῦ τὴν μνᾶν, καὶ δότε τῷ τὰς δέκα μνᾶς ἔχοντι. ");
INSERT INTO grctr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Καὶ εἶπον αὐτῷ, Κύριε, ἔχει δέκα μνᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Λέγω γὰρ ὑμῖν ὅτι παντὶ τῷ ἔχοντι δοθήσεται· ἀπὸ δὲ τοῦ μὴ ἔχοντος, καὶ ὃ ἔχει ἀρθήσεται ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Πλὴν τοὺς ἐχθρούς μου ἐκείνους, τοὺς μὴ θελήσαντάς με βασιλεῦσαι ἐπ᾿ αὐτούς, ἀγάγετε ὧδε, καὶ κατασφάξατε ἔμπροσθέν μου. ");
INSERT INTO grctr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Καὶ εἰπὼν ταῦτα, ἐπορεύετο ἔμπροσθεν, ἀναβαίνων εἰς Ἱεροσόλυμα. ");
INSERT INTO grctr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Καὶ ἐγένετο ὡς ἤγγισεν εἰς Βηθφαγὴ καὶ Βηθανίαν πρὸς τὸ ὄρος τὸ καλούμενον Ἐλαιῶν, ἀπέστειλε δύο τῶν μαθητῶν αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","εἰπών, Ὑπάγετε εἰς τὴν κατέναντι κώμην· ἐν ᾗ εἰσπορευόμενοι εὑρήσετε πῶλον δεδεμένον, ἐφ᾿ ὃν οὐδεὶς πώποτε ἀνθρώπων ἐκάθισε· λύσαντες αὐτὸν ἀγάγετε. ");
INSERT INTO grctr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Καὶ ἐάν τις ὑμᾶς ἐρωτᾷ, Διὰ τί λύετε; οὕτως ἐρεῖτε αὐτῷ ὅτι Ὁ Κύριος αὐτοῦ χρείαν ἔχει. ");
INSERT INTO grctr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ἀπελθόντες δὲ οἱ ἀπεσταλμένοι εὗρον καθὼς εἶπεν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Λυόντων δὲ αὐτῶν τὸν πῶλον, εἶπον οἱ κύριοι αὐτοῦ πρὸς αὐτούς, Τί λύετε τὸν πῶλον; ");
INSERT INTO grctr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Οἱ δὲ εἶπον, Ὁ Κύριος αὐτοῦ χρείαν ἔχει. ");
INSERT INTO grctr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Καὶ ἤγαγον αὐτὸν πρὸς τὸν Ἰησοῦν· καὶ ἐπιρρίψαντες ἑαυτῶν τὰ ἱμάτια ἐπὶ τὸν πῶλον, ἐπεβίβασαν τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Πορευομένου δὲ αὐτοῦ, ὑπεστρώννυον τὰ ἱμάτια αὐτῶν ἐν τῇ ὁδῷ. ");
INSERT INTO grctr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ἐγγίζοντος δὲ αὐτοῦ ἤδη πρὸς τῇ καταβάσει τοῦ ὄρους τῶν Ἐλαιῶν, ἤρξαντο ἅπαν τὸ πλῆθος τῶν μαθητῶν χαίροντες αἰνεῖν τὸν Θεὸν φωνῇ μεγάλῃ περὶ πασῶν ὧν εἶδον δυνάμεων, ");
INSERT INTO grctr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","λέγοντες, Εὐλογημένος ὁ ἐρχόμενος βασιλεὺς ἐν ὀνόματι Κυρίου· εἰρήνη ἐν οὐρανῷ, καὶ δόξα ἐν ὑψίστοις. ");
INSERT INTO grctr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Καί τινες τῶν Φαρισαίων ἀπὸ τοῦ ὄχλου εἶπον πρὸς αὐτόν, Διδάσκαλε, ἐπιτίμησον τοῖς μαθηταῖς σου. ");
INSERT INTO grctr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Καὶ ἀποκριθεὶς εἶπεν αὐτοῖς, Λέγω ὑμῖν ὅτι ἐὰν οὗτοι σιωπήσωσιν, οἱ λίθοι κεκράξονται. ");
INSERT INTO grctr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Καὶ ὡς ἤγγισεν, ἰδὼν τὴν πόλιν, ἔκλαυσεν ἐπ᾿ αὐτῇ, ");
INSERT INTO grctr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","λέγων ὅτι Εἰ ἔγνως καὶ σύ, καί γε ἐν τῇ ἡμέρᾳ σου ταύτῃ, τὰ πρὸς εἰρήνην σου· νῦν δὲ ἐκρύβη ἀπὸ ὀφθαλμῶν σου. ");
INSERT INTO grctr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ὅτι ἥξουσιν ἡμέραι ἐπὶ σέ, καὶ περιβαλοῦσιν οἱ ἐχθροί σου χάρακά σοι, καὶ περικυκλώσουσί σε, καὶ συνέξουσί σε πάντοθεν, ");
INSERT INTO grctr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","καὶ ἐδαφιοῦσί σε καὶ τὰ τέκνα σου ἐν σοί, καὶ οὐκ ἀφήσουσιν ἐν σοὶ λίθον ἐπὶ λίθῳ· ἀνθ᾿ ὧν οὐκ ἔγνως τὸν καιρὸν τῆς ἐπισκοπῆς σου. ");
INSERT INTO grctr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Καὶ εἰσελθὼν εἰς τὸ ἱερόν, ἤρξατο ἐκβάλλειν τοὺς πωλοῦντας ἐν αὐτῷ καὶ ἀγοράζοντας, ");
INSERT INTO grctr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","λέγων αὐτοῖς, Γέγραπται, Ὁ οἶκός μου οἶκος προσευχῆς ἐστίν· ὑμεῖς δὲ αὐτὸν ἐποιήσατε σπήλαιον λῃστῶν. ");
INSERT INTO grctr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Καὶ ἦν διδάσκων τὸ καθ᾿ ἡμέραν ἐν τῷ ἱερῷ· οἱ δὲ ἀρχιερεῖς καὶ οἱ γραμματεῖς ἐζήτουν αὐτὸν ἀπολέσαι, καὶ οἱ πρῶτοι τοῦ λαοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","καὶ οὐχ εὕρισκον τὸ τί ποιήσωσιν, ὁ λαὸς γὰρ ἅπας ἐξεκρέματο αὐτοῦ ἀκούων. ");
INSERT INTO grctr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Καὶ ἐγένετο ἐν μιᾷ τῶν ἡμερῶν ἐκείνων, διδάσκοντος αὐτοῦ τὸν λαὸν ἐν τῷ ἱερῷ καὶ εὐαγγελιζομένου, ἐπέστησαν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς σὺν τοῖς πρεσβυτέροις, ");
INSERT INTO grctr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","καὶ εἶπον πρὸς αὐτόν, λέγοντες, Εἰπὲ ἡμῖν, ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς, ἢ τίς ἐστιν ὁ δούς σοι τὴν ἐξουσίαν ταύτην; ");
INSERT INTO grctr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ἀποκριθεὶς δὲ εἶπε πρὸς αὐτούς, Ἐρωτήσω ὑμᾶς κἀγὼ ἕνα λόγον, καὶ εἴπατέ μοι· ");
INSERT INTO grctr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Τὸ βάπτισμα Ἰωάννου ἐξ οὐρανοῦ ἦν, ἢ ἐξ ἀνθρώπων; ");
INSERT INTO grctr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Οἱ δὲ συνελογίσαντο πρὸς ἑαυτούς, λέγοντες ὅτι Ἐὰν εἴπωμεν, Ἐξ οὐρανοῦ, ἐρεῖ, Διὰ τί οὖν οὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ἐὰν δὲ εἴπωμεν, Ἐξ ἀνθρώπων, πᾶς ὁ λαὸς καταλιθάσει ἡμᾶς· πεπεισμένος γάρ ἐστιν Ἰωάννην προφήτην εἶναι. ");
INSERT INTO grctr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Καὶ ἀπεκρίθησαν μὴ εἰδέναι πόθεν. ");
INSERT INTO grctr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Καὶ ὁ Ἰησοῦς εἶπεν αὐτοῖς, Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ἤρξατο δὲ πρὸς τὸν λαὸν λέγειν τὴν παραβολὴν ταύτην· Ἄνθρωπός τις ἐφύτευσεν ἀμπελῶνα, καὶ ἐξέδοτο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησε χρόνους ἱκανούς· ");
INSERT INTO grctr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","καὶ ἐν καιρῷ ἀπέστειλε πρὸς τοὺς γεωργοὺς δοῦλον, ἵνα ἀπὸ τοῦ καρποῦ τοῦ ἀμπελῶνος δῶσιν αὐτῷ. Οἱ δὲ γεωργοὶ δείραντες αὐτὸν ἐξαπέστειλαν κενόν. ");
INSERT INTO grctr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Καὶ προσέθετο πέμψαι ἕτερον δοῦλον· οἱ δὲ κἀκεῖνον δείραντες καὶ ἀτιμάσαντες ἐξαπέστειλαν κενόν. ");
INSERT INTO grctr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Καὶ προσέθετο πέμψαι τρίτον· οἱ δὲ καὶ τοῦτον τραυματίσαντες ἐξέβαλον. ");
INSERT INTO grctr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Εἶπε δὲ ὁ κύριος τοῦ ἀμπελῶνος, Τί ποιήσω; Πέμψω τὸν υἱόν μου τὸν ἀγαπητόν· ἴσως τοῦτον ἰδόντες ἐντραπήσονται. ");
INSERT INTO grctr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ἰδόντες δὲ αὐτὸν οἱ γεωργοὶ διελογίζοντο πρὸς ἑαυτούς, λέγοντες, Οὗτός ἐστιν ὁ κληρονόμος· δεῦτε, ἀποκτείνωμεν αὐτόν, ἵνα ἡμῶν γένηται ἡ κληρονομία. ");
INSERT INTO grctr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Καὶ ἐκβαλόντες αὐτὸν ἔξω τοῦ ἀμπελῶνος, ἀπέκτειναν. Τί οὖν ποιήσει αὐτοῖς ὁ κύριος τοῦ ἀμπελῶνος; ");
INSERT INTO grctr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ἐλεύσεται καὶ ἀπολέσει τοὺς γεωργοὺς τούτους, καὶ δώσει τὸν ἀμπελῶνα ἄλλοις. Ἀκούσαντες δὲ εἶπον, Μὴ γένοιτο. ");
INSERT INTO grctr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ὁ δὲ ἐμβλέψας αὐτοῖς εἶπε, Τί οὖν ἐστι τὸ γεγραμμένον τοῦτο, Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες, οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας; ");
INSERT INTO grctr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Πᾶς ὁ πεσὼν ἐπ᾿ ἐκεῖνον τὸν λίθον συνθλασθήσεται· ἐφ᾿ ὃν δ᾿ ἂν πέσῃ, λικμήσει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Καὶ ἐζήτησαν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς ἐπιβαλεῖν ἐπ᾿ αὐτὸν τὰς χεῖρας ἐν αὐτῇ τῇ ὥρᾳ, καὶ ἐφοβήθησαν τὸν λαόν· ἔγνωσαν γὰρ ὅτι πρὸς αὐτοὺς τὴν παραβολὴν ταύτην εἶπε. ");
INSERT INTO grctr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Καὶ παρατηρήσαντες ἀπέστειλαν ἐγκαθέτους, ὑποκρινομένους ἑαυτοὺς δικαίους εἶναι, ἵνα ἐπιλάβωνται αὐτοῦ λόγου, εἰς τὸ παραδοῦναι αὐτὸν τῇ ἀρχῇ καὶ τῇ ἐξουσίᾳ τοῦ ἡγεμόνος. ");
INSERT INTO grctr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Καὶ ἐπηρώτησαν αὐτόν, λέγοντες, Διδάσκαλε, οἴδαμεν ὅτι ὀρθῶς λέγεις καὶ διδάσκεις· καὶ οὐ λαμβάνεις πρόσωπον, ἀλλ᾿ ἐπ᾿ ἀληθείας τὴν ὁδὸν τοῦ Θεοῦ διδάσκεις. ");
INSERT INTO grctr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ἔξεστιν ἡμῖν Καίσαρι φόρον δοῦναι, ἢ οὔ; ");
INSERT INTO grctr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Κατανοήσας δὲ αὐτῶν τὴν πανουργίαν, εἶπε πρὸς αὐτούς, Τί με πειράζετε; ");
INSERT INTO grctr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ἐπιδείξατέ μοι δηνάριον· τίνος ἔχει εἰκόνα καὶ ἐπιγραφήν; Ἀποκριθέντες δὲ εἶπον, Καίσαρος. ");
INSERT INTO grctr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ὁ δὲ εἶπεν αὐτοῖς, Ἀπόδοτε τοίνυν τὰ Καίσαρος Καίσαρι, καὶ τὰ τοῦ Θεοῦ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Καὶ οὐκ ἴσχυσαν ἐπιλαβέσθαι αὐτοῦ ῥήματος ἐναντίον τοῦ λαοῦ· καὶ θαυμάσαντες ἐπὶ τῇ ἀποκρίσει αὐτοῦ, ἐσίγησαν. ");
INSERT INTO grctr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Προσελθόντες δέ τινες τῶν Σαδδουκαίων, οἱ ἀντιλέγοντες ἀνάστασιν μὴ εἶναι, ἐπηρώτησαν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","λέγοντες, Διδάσκαλε, Μωσῆς ἔγραψεν ἡμῖν, Ἐάν τινος ἀδελφὸς ἀποθάνῃ ἔχων γυναῖκα, καὶ οὗτος ἄτεκνος ἀποθάνῃ, ἵνα λάβῃ ὁ ἀδελφὸς αὐτοῦ τὴν γυναῖκα, καὶ ἐξαναστήσῃ σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ἑπτὰ οὖν ἀδελφοὶ ἦσαν· καὶ ὁ πρῶτος λαβὼν γυναῖκα, ἀπέθανεν ἄτεκνος· ");
INSERT INTO grctr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","καὶ ἔλαβεν ὁ δεύτερος τὴν γυναῖκα, καὶ οὗτος ἀπέθανεν ἄτεκνος. ");
INSERT INTO grctr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Καὶ ὁ τρίτος ἔλαβεν αὐτήν. Ὡσαύτως δὲ καὶ οἱ ἑπτά· καὶ οὐ κατέλιπον τέκνα, καὶ ἀπέθανον. ");
INSERT INTO grctr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ὕστερον δὲ πάντων ἀπέθανε καὶ ἡ γυνή. ");
INSERT INTO grctr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ἐν τῇ οὖν ἀναστάσει, τίνος αὐτῶν γίνεται γυνή; Οἱ γὰρ ἑπτὰ ἔσχον αὐτὴν γυναῖκα. ");
INSERT INTO grctr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Καὶ ἀποκριθεὶς εἶπεν αὐτοῖς ὁ Ἰησοῦς, Οἱ υἱοὶ τοῦ αἰῶνος τούτου γαμοῦσι καὶ ἐκγαμίσκονται· ");
INSERT INTO grctr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","οἱ δὲ καταξιωθέντες τοῦ αἰῶνος ἐκείνου τυχεῖν καὶ τῆς ἀναστάσεως τῆς ἐκ νεκρῶν οὔτε γαμοῦσιν οὔτε ἐκγαμίσκονται· ");
INSERT INTO grctr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","οὔτε γὰρ ἀποθανεῖν ἔτι δύνανται· ἰσάγγελοι γάρ εἰσι, καὶ υἱοί εἰσι τοῦ Θεοῦ, τῆς ἀναστάσεως υἱοὶ ὄντες. ");
INSERT INTO grctr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ὅτι δὲ ἐγείρονται οἱ νεκροί, καὶ Μωσῆς ἐμήνυσεν ἐπὶ τῆς βάτου, ὡς λέγει, Κύριον τὸν Θεὸν Ἀβραὰμ καὶ τὸν Θεὸν Ἰσαὰκ καὶ τὸν Θεὸν Ἰακώβ. ");
INSERT INTO grctr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Θεὸς δὲ οὐκ ἔστι νεκρῶν, ἀλλὰ ζώντων· πάντες γὰρ αὐτῷ ζῶσιν. ");
INSERT INTO grctr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ἀποκριθέντες δέ τινες τῶν γραμματέων εἶπον, Διδάσκαλε, καλῶς εἶπας. ");
INSERT INTO grctr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Οὐκέτι δὲ ἐτόλμων ἐπερωτᾷν αὐτὸν οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Εἶπε δὲ πρὸς αὐτούς, Πῶς λέγουσι τὸν Χριστὸν υἱὸν Δαβὶδ εἶναι; ");
INSERT INTO grctr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Καὶ αὐτὸς Δαβὶδ λέγει ἐν βίβλῳ ψαλμῶν, Εἶπεν ὁ Κύριος τῷ Κυρίῳ μου, Κάθου ἐκ δεξιῶν μου, ");
INSERT INTO grctr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου. ");
INSERT INTO grctr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Δαβὶδ οὖν Κύριον αὐτὸν καλεῖ, καὶ πῶς υἱὸς αὐτοῦ ἐστιν; ");
INSERT INTO grctr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ἀκούοντος δὲ παντὸς τοῦ λαοῦ, εἶπε τοῖς μαθηταῖς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Προσέχετε ἀπὸ τῶν γραμματέων τῶν θελόντων περιπατεῖν ἐν στολαῖς, καὶ φιλούντων ἀσπασμοὺς ἐν ταῖς ἀγοραῖς, καὶ πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς, καὶ πρωτοκλισίας ἐν τοῖς δείπνοις· ");
INSERT INTO grctr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","οἳ κατεσθίουσι τὰς οἰκίας τῶν χηρῶν, καὶ προφάσει μακρὰ προσεύχονται. Οὗτοι λήψονται περισσότερον κρίμα. ");
INSERT INTO grctr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ἀναβλέψας δὲ εἶδε τοὺς βάλλοντας τὰ δῶρα αὐτῶν εἰς τὸ γαζοφυλάκιον πλουσίους· ");
INSERT INTO grctr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","εἶδε δέ καὶ τινα χήραν πενιχρὰν βάλλουσαν ἐκεῖ δύο λεπτά, ");
INSERT INTO grctr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","καὶ εἶπεν, Ἀληθῶς λέγω ὑμῖν ὅτι ἡ χήρα ἡ πτωχὴ αὕτη πλεῖον πάντων ἔβαλεν· ");
INSERT INTO grctr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ἅπαντες γὰρ οὗτοι ἐκ τοῦ περισσεύοντος αὐτοῖς ἔβαλον εἰς τὰ δῶρα τοῦ Θεοῦ· αὕτη δὲ ἐκ τοῦ ὑστερήματος αὐτῆς ἅπαντα τὸν βίον ὃν εἶχεν ἔβαλε. ");
INSERT INTO grctr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Καί τινων λεγόντων περὶ τοῦ ἱεροῦ, ὅτι λίθοις καλοῖς καὶ ἀναθήμασι κεκόσμηται, εἶπε, ");
INSERT INTO grctr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ταῦτα ἃ θεωρεῖτε, ἐλεύσονται ἡμέραι ἐν αἷς οὐκ ἀφεθήσεται λίθος ἐπὶ λίθῳ, ὃς οὐ καταλυθήσεται. ");
INSERT INTO grctr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ἐπηρώτησαν δὲ αὐτόν, λέγοντες, Διδάσκαλε, πότε οὖν ταῦτα ἔσται; Καὶ τί τὸ σημεῖον ὅταν μέλλῃ ταῦτα γίνεσθαι; ");
INSERT INTO grctr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ὁ δὲ εἶπε, Βλέπετε μὴ πλανηθῆτε· πολλοὶ γὰρ ἐλεύσονται ἐπὶ τῷ ὀνόματί μου, λέγοντες ὅτι Ἐγώ εἰμι· καί, Ὁ καιρὸς ἤγγικε, μὴ οὖν πορευθῆτε ὀπίσω αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ὅταν δὲ ἀκούσητε πολέμους καὶ ἀκαταστασίας, μὴ πτοηθῆτε· δεῖ γὰρ ταῦτα γενέσθαι πρῶτον, ἀλλ᾿ οὐκ εὐθέως τὸ τέλος. ");
INSERT INTO grctr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Τότε ἔλεγεν αὐτοῖς, Ἐγερθήσεται ἔθνος ἐπὶ ἔθνος, καὶ βασιλεία ἐπὶ βασιλείαν· ");
INSERT INTO grctr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","σεισμοί τε μεγάλοι κατὰ τόπους καὶ λιμοὶ καὶ λοιμοὶ ἔσονται, φόβητρά τε καὶ σημεῖα ἀπ᾿ οὐρανοῦ μεγάλα ἔσται. ");
INSERT INTO grctr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Πρὸ δὲ τούτων ἁπάντων ἐπιβαλοῦσιν ἐφ᾿ ὑμᾶς τὰς χεῖρας αὐτῶν, καὶ διώξουσι, παραδιδόντες εἰς συναγωγὰς καὶ φυλακάς, ἀγομένους ἐπὶ βασιλεῖς καὶ ἡγεμόνας, ἕνεκεν τοῦ ὀνόματός μου. ");
INSERT INTO grctr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ἀποβήσεται δὲ ὑμῖν εἰς μαρτύριον. ");
INSERT INTO grctr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Θέσθε οὖν εἰς τὰς καρδίας ὑμῶν μὴ προμελετᾷν ἀπολογηθῆναι· ");
INSERT INTO grctr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ἐγὼ γὰρ δώσω ὑμῖν στόμα καὶ σοφίαν, ᾗ οὐ δυνήσονται ἀντειπεῖν οὐδὲ ἀντιστῆναι πάντες οἱ ἀντικείμενοι ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Παραδοθήσεσθε δὲ καὶ ὑπὸ γονέων καὶ ἀδελφῶν καὶ συγγενῶν καὶ φίλων, καὶ θανατώσουσιν ἐξ ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου. ");
INSERT INTO grctr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Καὶ θρὶξ ἐκ τῆς κεφαλῆς ὑμῶν οὐ μὴ ἀπόληται. ");
INSERT INTO grctr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ἐν τῇ ὑπομονῇ ὑμῶν κτήσασθε τὰς ψυχὰς ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ὅταν δὲ ἴδητε κυκλουμένην ὑπὸ στρατοπέδων τὴν Ἱερουσαλήμ, τότε γνῶτε ὅτι ἤγγικεν ἡ ἐρήμωσις αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν εἰς τὰ ὄρη· καὶ οἱ ἐν μέσῳ αὐτῆς ἐκχωρείτωσαν· καὶ οἱ ἐν ταῖς χώραις μὴ εἰσερχέσθωσαν εἰς αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ὅτι ἡμέραι ἐκδικήσεως αὗταί εἰσι, τοῦ πληρωθῆναι πάντα τὰ γεγραμμένα. ");
INSERT INTO grctr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Οὐαὶ δὲ ταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις· ἔσται γὰρ ἀνάγκη μεγάλη ἐπὶ τῆς γῆς, καὶ ὀργὴ ἐν τῷ λαῷ τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Καὶ πεσοῦνται στόματι μαχαίρας, καὶ αἰχμαλωτισθήσονται εἰς πάντα τὰ ἔθνη· καὶ Ἱερουσαλὴμ ἔσται πατουμένη ὑπὸ ἐθνῶν, ἄχρι πληρωθῶσι καιροὶ ἐθνῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Καὶ ἔσται σημεῖα ἐν ἡλίῳ καὶ σελήνῃ καὶ ἄστροις, καὶ ἐπὶ τῆς γῆς συνοχὴ ἐθνῶν ἐν ἀπορίᾳ, ἠχούσης θαλάσσης καὶ σάλου, ");
INSERT INTO grctr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ἀποψυχόντων ἀνθρώπων ἀπὸ φόβου καὶ προσδοκίας τῶν ἐπερχομένων τῇ οἰκουμένῃ· αἱ γὰρ δυνάμεις τῶν οὐρανῶν σαλευθήσονται. ");
INSERT INTO grctr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Καὶ τότε ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν νεφέλῃ μετὰ δυνάμεως καὶ δόξης πολλῆς. ");
INSERT INTO grctr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ἀρχομένων δὲ τούτων γίνεσθαι, ἀνακύψατε καὶ ἐπάρατε τὰς κεφαλὰς ὑμῶν· διότι ἐγγίζει ἡ ἀπολύτρωσις ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Καὶ εἶπε παραβολὴν αὐτοῖς, Ἴδετε τὴν συκῆν καὶ πάντα τὰ δένδρα· ");
INSERT INTO grctr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ὅταν προβάλωσιν ἤδη, βλέποντες ἀφ᾿ ἑαυτῶν γινώσκετε ὅτι ἤδη ἐγγὺς τὸ θέρος ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Οὕτω καὶ ὑμεῖς, ὅταν ἴδητε ταῦτα γινόμενα, γινώσκετε ὅτι ἐγγύς ἐστιν ἡ βασιλεία τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ἀμὴν λέγω ὑμῖν ὅτι οὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη, ἕως ἂν πάντα γένηται. ");
INSERT INTO grctr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ὁ οὐρανὸς καὶ ἡ γῆ παρελεύσονται, οἱ δὲ λόγοι μου οὐ μὴ παρέλθωσι. ");
INSERT INTO grctr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Προσέχετε δὲ ἑαυτοῖς, μήποτε βαρυνθῶσιν ὑμῶν αἱ καρδίαι ἐν κραιπάλῃ καὶ μέθῃ καὶ μερίμναις βιωτικαῖς, καὶ αἰφνίδιος ἐφ᾿ ὑμᾶς ἐπιστῇ ἡ ἡμέρα ἐκείνη· ");
INSERT INTO grctr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ὡς παγὶς γὰρ ἐπελεύσεται ἐπὶ πάντας τοὺς καθημένους ἐπὶ πρόσωπον πάσης τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ἀγρυπνεῖτε οὖν ἐν παντὶ καιρῷ δεόμενοι, ἵνα καταξιωθῆτε ἐκφυγεῖν ταῦτα πάντα τὰ μέλλοντα γίνεσθαι, καὶ σταθῆναι ἔμπροσθεν τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ἦν δὲ τὰς ἡμέρας ἐν τῷ ἱερῷ διδάσκων· τὰς δὲ νύκτας ἐξερχόμενος ηὐλίζετο εἰς τὸ ὄρος τὸ καλούμενον Ἐλαιῶν. ");
INSERT INTO grctr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Καὶ πᾶς ὁ λαὸς ὤρθριζε πρὸς αὐτὸν ἐν τῷ ἱερῷ ἀκούειν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ἤγγιζε δὲ ἡ ἑορτὴ τῶν ἀζύμων, ἡ λεγομένη Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Καὶ ἐζήτουν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς τὸ πῶς ἀνέλωσιν αὐτόν· ἐφοβοῦντο γὰρ τὸν λαόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Εἰσῆλθε δὲ ὁ Σατανᾶς εἰς Ἰούδαν τὸν ἐπικαλούμενον Ἰσκαριώτην, ὄντα ἐκ τοῦ ἀριθμοῦ τῶν δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Καὶ ἀπελθὼν συνελάλησε τοῖς ἀρχιερεῦσι καὶ τοῖς στρατηγοῖς τὸ πῶς αὐτὸν παραδῷ αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Καὶ ἐχάρησαν, καὶ συνέθεντο αὐτῷ ἀργύριον δοῦναι. ");
INSERT INTO grctr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Καὶ ἐξωμολόγησε καὶ ἐζήτει εὐκαιρίαν τοῦ παραδοῦναι αὐτὸν αὐτοῖς ἄτερ ὄχλου. ");
INSERT INTO grctr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ἦλθε δὲ ἡ ἡμέρα τῶν ἀζύμων, ἐν ᾗ ἔδει θύεσθαι τὸ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Καὶ ἀπέστειλε Πέτρον καὶ Ἰωάννην, εἰπών, Πορευθέντες ἑτοιμάσατε ἡμῖν τὸ Πάσχα, ἵνα φάγωμεν. ");
INSERT INTO grctr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Οἱ δὲ εἶπον αὐτῷ, Ποῦ θέλεις ἑτοιμάσωμεν; ");
INSERT INTO grctr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ὁ δὲ εἶπεν αὐτοῖς, Ἰδού, εἰσελθόντων ὑμῶν εἰς τὴν πόλιν, συναντήσει ὑμῖν ἄνθρωπος κεράμιον ὕδατος βαστάζων· ἀκολουθήσατε αὐτῷ εἰς τὴν οἰκίαν οὗ εἰσπορεύεται. ");
INSERT INTO grctr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Καὶ ἐρεῖτε τῷ οἰκοδεσπότῃ τῆς οἰκίας, Λέγει σοι ὁ διδάσκαλος, Ποῦ ἐστι τὸ κατάλυμα, ὅπου τὸ Πάσχα μετὰ τῶν μαθητῶν μου φάγω; ");
INSERT INTO grctr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Κἀκεῖνος ὑμῖν δείξει ἀνώγεον μέγα ἐστρωμένον· ἐκεῖ ἑτοιμάσατε. ");
INSERT INTO grctr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ἀπελθόντες δὲ εὗρον καθὼς εἴρηκεν αὐτοῖς, καὶ ἡτοίμασαν τὸ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Καὶ ὅτε ἐγένετο ἡ ὥρα, ἀνέπεσε, καὶ οἱ δώδεκα ἀπόστολοι σὺν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Καὶ εἶπε πρὸς αὐτούς, Ἐπιθυμίᾳ ἐπεθύμησα τοῦτο τὸ Πάσχα φαγεῖν μεθ᾿ ὑμῶν πρὸ τοῦ με παθεῖν· ");
INSERT INTO grctr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","λέγω γὰρ ὑμῖν ὅτι οὐκέτι οὐ μὴ φάγω ἐξ αὐτοῦ, ἕως ὅτου πληρωθῇ ἐν τῇ βασιλείᾳ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Καὶ δεξάμενος ποτήριον, εὐχαριστήσας εἶπε, Λάβετε τοῦτο, καὶ διαμερίσατε ἑαυτοῖς· ");
INSERT INTO grctr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","λέγω γὰρ ὑμῖν ὅτι οὐ μὴ πίω ἀπὸ τοῦ γεννήματος τῆς ἀμπέλου, ἕως ὅτου ἡ βασιλεία τοῦ Θεοῦ ἔλθῃ. ");
INSERT INTO grctr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Καὶ λαβὼν ἄρτον, εὐχαριστήσας ἔκλασε καὶ ἔδωκεν αὐτοῖς, λέγων, Τοῦτό ἐστι τὸ σῶμά μου τὸ ὑπὲρ ὑμῶν διδόμενον· τοῦτο ποιεῖτε εἰς τὴν ἐμὴν ἀνάμνησιν. ");
INSERT INTO grctr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ὡσαύτως καὶ τὸ ποτήριον μετὰ τὸ δειπνῆσαι, λέγων, Τοῦτο τὸ ποτήριον ἡ καινὴ διαθήκη ἐν τῷ αἵματί μου, τὸ ὑπὲρ ὑμῶν ἐκχυνόμενον. ");
INSERT INTO grctr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Πλὴν ἰδού, ἡ χεὶρ τοῦ παραδιδόντος με μετ᾿ ἐμοῦ ἐπὶ τῆς τραπέζης. ");
INSERT INTO grctr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Καὶ ὁ μὲν υἱὸς τοῦ ἀνθρώπου πορεύεται κατὰ τὸ ὡρισμένον· πλὴν οὐαὶ τῷ ἀνθρώπῳ ἐκείνῳ δι᾿ οὗ παραδίδοται. ");
INSERT INTO grctr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Καὶ αὐτοὶ ἤρξαντο συζητεῖν πρὸς ἑαυτοὺς τὸ τίς ἄρα εἴη ἐξ αὐτῶν ὁ τοῦτο μέλλων πράσσειν. ");
INSERT INTO grctr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ἐγένετο δὲ καὶ φιλονεικία ἐν αὐτοῖς τὸ τίς αὐτῶν δοκεῖ εἶναι μείζων. ");
INSERT INTO grctr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ὁ δὲ εἶπεν αὐτοῖς, Οἱ βασιλεῖς τῶν ἐθνῶν κυριεύουσιν αὐτῶν, καὶ οἱ ἐξουσιάζοντες αὐτῶν εὐεργέται καλοῦνται. ");
INSERT INTO grctr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ὑμεῖς δὲ οὐχ οὕτως· ἀλλ᾿ ὁ μείζων ἐν ὑμῖν γενέσθω ὡς ὁ νεώτερος· καὶ ὁ ἡγούμενος ὡς ὁ διακονῶν. ");
INSERT INTO grctr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Τίς γὰρ μείζων, ὁ ἀνακείμενος ἢ ὁ διακονῶν; Οὐχὶ ὁ ἀνακείμενος; Ἐγὼ δέ εἰμι ἐν μέσῳ ὑμῶν ὡς ὁ διακονῶν. ");
INSERT INTO grctr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ὑμεῖς δέ ἐστε οἱ διαμεμενηκότες μετ᾿ ἐμοῦ ἐν τοῖς πειρασμοῖς μου· ");
INSERT INTO grctr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","κἀγὼ διατίθεμαι ὑμῖν, καθὼς διέθετό μοι ὁ πατήρ μου, βασιλείαν, ");
INSERT INTO grctr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ἵνα ἐσθίητε καὶ πίνητε ἐπὶ τῆς τραπέζης μου ἐν τῇ Βασιλείᾳ μου, καὶ καθίσησθε ἐπὶ θρόνων, κρίνοντες τὰς δώδεκα φυλὰς τοῦ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Εἶπε δὲ ὁ Κύριος, Σίμων, Σίμων, ἰδού, ὁ Σατανᾶς ἐξῃτήσατο ὑμᾶς, τοῦ σινιάσαι ὡς τὸν σῖτον· ");
INSERT INTO grctr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ἐγὼ δὲ ἐδεήθην περὶ σοῦ, ἵνα μὴ ἐκλείπῃ ἡ πίστις σου· καὶ σύ ποτε ἐπιστρέψας στήριξον τοὺς ἀδελφούς σου. ");
INSERT INTO grctr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ὁ δὲ εἶπεν αὐτῷ, Κύριε, μετὰ σοῦ ἕτοιμός εἰμι καὶ εἰς φυλακὴν καὶ εἰς θάνατον πορεύεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ὁ δὲ εἶπε, Λέγω σοι, Πέτρε, οὐ μὴ φωνήσει σήμερον ἀλέκτωρ, πρὶν ἢ τρὶς ἀπαρνήσῃ μὴ εἰδέναι με. ");
INSERT INTO grctr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Καὶ εἶπεν αὐτοῖς, Ὅτε ἀπέστειλα ὑμᾶς ἄτερ βαλαντίου καὶ πήρας καὶ ὑποδημάτων, μή τινος ὑστερήσατε; Οἱ δὲ εἶπον, Οὐδενός. ");
INSERT INTO grctr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Εἶπεν οὖν αὐτοῖς, Ἀλλὰ νῦν ὁ ἔχων βαλάντιον ἀράτω, ὁμοίως καὶ πήραν· καὶ ὁ μὴ ἔχων, πωλησάτω τὸ ἱμάτιον αὐτοῦ, καὶ ἀγορασάτω μάχαιραν. ");
INSERT INTO grctr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Λέγω γὰρ ὑμῖν ὅτι ἔτι τοῦτο τὸ γεγραμμένον δεῖ τελεσθῆναι ἐν ἐμοί, τὸ Καὶ μετὰ ἀνόμων ἐλογίσθη· καὶ γὰρ τὰ περὶ ἐμοῦ τέλος ἔχει. ");
INSERT INTO grctr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Οἱ δὲ εἶπον, Κύριε, ἰδού, μάχαιραι ὧδε δύο. Ὁ δὲ εἶπεν αὐτοῖς, Ἱκανόν ἐστι. ");
INSERT INTO grctr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Καὶ ἐξελθὼν ἐπορεύθη κατὰ τὸ ἔθος εἰς τὸ ὄρος τῶν Ἐλαιῶν· ἠκολούθησαν δὲ αὐτῷ καὶ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Γενόμενος δὲ ἐπὶ τοῦ τόπου, εἶπεν αὐτοῖς, Προσεύχεσθε μὴ εἰσελθεῖν εἰς πειρασμόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Καὶ αὐτὸς ἀπεσπάσθη ἀπ᾿ αὐτῶν ὡσεὶ λίθου βολήν, καὶ θεὶς τὰ γόνατα προσηύχετο, ");
INSERT INTO grctr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","λέγων, Πάτερ, εἰ βούλει παρενεγκεῖν τὸ ποτήριον τοῦτο ἀπ᾿ ἐμοῦ· πλὴν μὴ τὸ θέλημά μου, ἀλλὰ τὸ σὸν γενέσθω. ");
INSERT INTO grctr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ὤφθη δὲ αὐτῷ ἄγγελος ἀπ᾿ οὐρανοῦ ἐνισχύων αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Καὶ γενόμενος ἐν ἀγωνίᾳ, ἐκτενέστερον προσηύχετο. Ἐγένετο δὲ ὁ ἱδρὼς αὐτοῦ ὡσεὶ θρόμβοι αἵματος καταβαίνοντες ἐπὶ τὴν γῆν. ");
INSERT INTO grctr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Καὶ ἀναστὰς ἀπὸ τῆς προσευχῆς, ἐλθὼν πρὸς τοὺς μαθητὰς αὐτοῦ εὗρεν αὐτοὺς κοιμωμένους ἀπὸ τῆς λύπης, ");
INSERT INTO grctr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","καὶ εἶπεν αὐτοῖς, Τί καθεύδετε; Ἀναστάντες προσεύχεσθε, ἵνα μὴ εἰσέλθητε εἰς πειρασμόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ἔτι δὲ αὐτοῦ λαλοῦντος, ἰδού, ὄχλος καὶ ὁ λεγόμενος Ἰούδας, εἷς τῶν δώδεκα, προήρχετο αὐτῶν, καὶ ἤγγισε τῷ Ἰησοῦ φιλῆσαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ, Ἰούδα, φιλήματι τὸν υἱὸν τοῦ ἀνθρώπου παραδίδως; ");
INSERT INTO grctr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ἰδόντες δὲ οἱ περὶ αὐτὸν τὸ ἐσόμενον εἶπον αὐτῷ, Κύριε, εἰ πατάξομεν ἐν μαχαίρᾳ; ");
INSERT INTO grctr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Καὶ ἐπάταξεν εἷς τις ἐξ αὐτῶν τὸν δοῦλον τοῦ ἀρχιερέως, καὶ ἀφεῖλεν αὐτοῦ τὸ οὖς τὸ δεξιόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν, Ἐᾶτε ἕως τούτου. Καὶ ἁψάμενος τοῦ ὠτίου αὐτοῦ, ἰάσατο αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Εἶπε δὲ ὁ Ἰησοῦς πρὸς τοὺς παραγενομένους ἐπ᾿ αὐτὸν ἀρχιερεῖς καὶ στρατηγοὺς τοῦ ἱεροῦ καὶ πρεσβυτέρους, Ὡς ἐπὶ λῃστὴν ἐξεληλύθατε μετὰ μαχαιρῶν καὶ ξύλων; ");
INSERT INTO grctr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Καθ᾿ ἡμέραν ὄντος μου μεθ᾿ ὑμῶν ἐν τῷ ἱερῷ, οὐκ ἐξετείνατε τὰς χεῖρας ἐπ᾿ ἐμέ. Ἀλλ᾿ αὕτη ὑμῶν ἐστιν ἡ ὥρα, καὶ ἡ ἐξουσία τοῦ σκότους. ");
INSERT INTO grctr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Συλλαβόντες δὲ αὐτὸν ἤγαγον, καὶ εἰσήγαγον αὐτὸν εἰς τὸν οἶκον τοῦ ἀρχιερέως· ὁ δὲ Πέτρος ἠκολούθει μακρόθεν. ");
INSERT INTO grctr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ἁψάντων δὲ πῦρ ἐν μέσῳ τῆς αὐλῆς, καὶ συγκαθισάντων αὐτῶν, ἐκάθητο ὁ Πέτρος ἐν μέσῳ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ἰδοῦσα δὲ αὐτὸν παιδίσκη τις καθήμενον πρὸς τὸ φῶς, καὶ ἀτενίσασα αὐτῷ, εἶπε, Καὶ οὗτος σὺν αὐτῷ ἦν. ");
INSERT INTO grctr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ὁ δὲ ἠρνήσατο αὐτόν, λέγων, Γύναι, οὐκ οἶδα αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Καὶ μετὰ βραχὺ ἕτερος ἰδὼν αὐτὸν ἔφη, Καὶ σὺ ἐξ αὐτῶν εἶ. Ὁ δὲ Πέτρος εἶπεν, Ἄνθρωπε, οὐκ εἰμί. ");
INSERT INTO grctr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Καὶ διαστάσης ὡσεὶ ὥρας μιᾶς, ἄλλος τις διϊσχυρίζετο, λέγων, Ἐπ᾿ ἀληθείας καὶ οὗτος μετ᾿ αὐτοῦ ἦν· καὶ γὰρ Γαλιλαῖός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Εἶπε δὲ ὁ Πέτρος, Ἄνθρωπε, οὐκ οἶδα ὃ λέγεις. Καὶ παραχρῆμα, ἔτι λαλοῦντος αὐτοῦ, ἐφώνησεν ὁ ἀλέκτωρ. ");
INSERT INTO grctr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Καὶ στραφεὶς ὁ Κύριος ἐνέβλεψε τῷ Πέτρῳ. Καὶ ὑπεμνήσθη ὁ Πέτρος τοῦ λόγου τοῦ Κυρίου, ὡς εἶπεν αὐτῷ ὅτι Πρὶν ἀλέκτορα φωνῆσαι, ἀπαρνήσῃ με τρίς. ");
INSERT INTO grctr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Καὶ ἐξελθὼν ἔξω ὁ Πέτρος ἔκλαυσε πικρῶς. ");
INSERT INTO grctr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Καὶ οἱ ἄνδρες οἱ συνέχοντες τὸν Ἰησοῦν ἐνέπαιζον αὐτῷ, δέροντες. ");
INSERT INTO grctr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Καὶ περικαλύψαντες αὐτόν, ἔτυπτον αὐτοῦ τὸ πρόσωπον, καὶ ἐπηρώτων αὐτόν, λέγοντες, Προφήτευσον. Τίς ἐστιν ὁ παίσας σε; ");
INSERT INTO grctr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Καὶ ἕτερα πολλὰ βλασφημοῦντες ἔλεγον εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Καὶ ὡς ἐγένετο ἡμέρα, συνήχθη τὸ πρεσβυτέριον τοῦ λαοῦ, ἀρχιερεῖς τε καὶ γραμματεῖς, καὶ ἀνήγαγον αὐτὸν εἰς τὸ συνέδριον ἑαυτῶν, λέγοντες, ");
INSERT INTO grctr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Εἰ σὺ εἶ ὁ Χριστός, εἰπὲ ἡμῖν. Εἶπε δὲ αὐτοῖς, Ἐὰν ὑμῖν εἴπω, οὐ μὴ πιστεύσητε· ");
INSERT INTO grctr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ἐὰν δὲ καὶ ἐρωτήσω, οὐ μὴ ἀποκριθῆτέ μοι, ἢ ἀπολύσητε. ");
INSERT INTO grctr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ἀπὸ τοῦ νῦν ἔσται ὁ υἱὸς τοῦ ἀνθρώπου καθήμενος ἐκ δεξιῶν τῆς δυνάμεως τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Εἶπον δὲ πάντες, Σὺ οὖν εἶ ὁ υἱὸς τοῦ Θεοῦ; Ὁ δὲ πρὸς αὐτοὺς ἔφη, Ὑμεῖς λέγετε ὅτι ἐγώ εἰμι. ");
INSERT INTO grctr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Οἱ δὲ εἶπον, Τί ἔτι χρείαν ἔχομεν μαρτυρίας; Αὐτοὶ γὰρ ἠκούσαμεν ἀπὸ τοῦ στόματος αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Καὶ ἀναστὰν ἅπαν τὸ πλῆθος αὐτῶν, ἤγαγεν αὐτὸν ἐπὶ τὸν Πιλάτον. ");
INSERT INTO grctr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ἤρξαντο δὲ κατηγορεῖν αὐτοῦ, λέγοντες, Τοῦτον εὕρομεν διαστρέφοντα τὸ ἔθνος, καὶ κωλύοντα Καίσαρι φόρους διδόναι, λέγοντα ἑαυτὸν Χριστὸν βασιλέα εἶναι. ");
INSERT INTO grctr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ὁ δὲ Πιλάτος ἐπηρώτησεν αὐτόν, λέγων, Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; Ὁ δὲ ἀποκριθεὶς αὐτῷ ἔφη, Σὺ λέγεις. ");
INSERT INTO grctr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ὁ δὲ Πιλάτος εἶπε πρὸς τοὺς ἀρχιερεῖς καὶ τοὺς ὄχλους, Οὐδὲν εὑρίσκω αἴτιον ἐν τῷ ἀνθρώπῳ τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Οἱ δὲ ἐπίσχυον, λέγοντες ὅτι Ἀνασείει τὸν λαόν, διδάσκων καθ᾿ ὅλης τῆς Ἰουδαίας, ἀρξάμενος ἀπὸ τῆς Γαλιλαίας ἕως ὧδε. ");
INSERT INTO grctr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Πιλάτος δὲ ἀκούσας Γαλιλαίαν ἐπηρώτησεν εἰ ὁ ἄνθρωπος Γαλιλαῖός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Καὶ ἐπιγνοὺς ὅτι ἐκ τῆς ἐξουσίας Ἡρῴδου ἐστίν, ἀνέπεμψεν αὐτὸν πρὸς Ἡρῴδην, ὄντα καὶ αὐτὸν ἐν Ἱεροσολύμοις ἐν ταύταις ταῖς ἡμέραις. ");
INSERT INTO grctr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ὁ δὲ Ἡρῴδης ἰδὼν τὸν Ἰησοῦν ἐχάρη λίαν· ἦν γὰρ θέλων ἐξ ἱκανοῦ ἰδεῖν αὐτόν, διὰ τὸ ἀκούειν πολλὰ περὶ αὐτοῦ· καὶ ἤλπιζέ τι σημεῖον ἰδεῖν ὑπ᾿ αὐτοῦ γινόμενον. ");
INSERT INTO grctr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ἐπηρώτα δὲ αὐτὸν ἐν λόγοις ἱκανοῖς· αὐτὸς δὲ οὐδὲν ἀπεκρίνατο αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Εἱστήκεισαν δὲ οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς, εὐτόνως κατηγοροῦντες αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ἐξουθενήσας δὲ αὐτὸν ὁ Ἡρῴδης σὺν τοῖς στρατεύμασιν αὐτοῦ, καὶ ἐμπαίξας, περιβαλὼν αὐτὸν ἐσθῆτα λαμπράν, ἀνέπεμψεν αὐτὸν τῷ Πιλάτῳ. ");
INSERT INTO grctr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ἐγένοντο δὲ φίλοι ὅ τε Πιλάτος καὶ ὁ Ἡρῴδης ἐν αὐτῇ τῇ ἡμέρᾳ μετ᾿ ἀλλήλων· προϋπῆρχον γὰρ ἐν ἔχθρᾳ ὄντες πρὸς ἑαυτούς. ");
INSERT INTO grctr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Πιλάτος δὲ συγκαλεσάμενος τοὺς ἀρχιερεῖς καὶ τοὺς ἄρχοντας καὶ τὸν λαόν, ");
INSERT INTO grctr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","εἶπε πρὸς αὐτούς, Προσηνέγκατέ μοι τὸν ἄνθρωπον τοῦτον, ὡς ἀποστρέφοντα τὸν λαόν· καὶ ἰδού, ἐγὼ ἐνώπιον ὑμῶν ἀνακρίνας οὐδὲν εὗρον ἐν τῷ ἀνθρώπῳ τούτῳ αἴτιον ὧν κατηγορεῖτε κατ᾿ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ἀλλ᾿ οὐδὲ Ἡρῴδης· ἀνέπεμψα γὰρ ὑμᾶς πρὸς αὐτόν, καὶ ἰδού, οὐδὲν ἄξιον θανάτου ἐστὶ πεπραγμένον αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Παιδεύσας οὖν αὐτὸν ἀπολύσω. ");
INSERT INTO grctr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ἀνάγκην δὲ εἶχεν ἀπολύειν αὐτοῖς κατὰ ἑορτὴν ἕνα. ");
INSERT INTO grctr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ἀνέκραξαν δὲ παμπληθεί, λέγοντες, Αἶρε τοῦτον, ἀπόλυσον δὲ ἡμῖν τὸν Βαραββᾶν· ");
INSERT INTO grctr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ὅστις ἦν διὰ στάσιν τινὰ γενομένην ἐν τῇ πόλει καὶ φόνον βεβλημένος εἰς φυλακήν. ");
INSERT INTO grctr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Πάλιν οὖν ὁ Πιλάτος προσεφώνησε, θέλων ἀπολῦσαι τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Οἱ δὲ ἐπεφώνουν, λέγοντες, Σταύρωσον, σταύρωσον αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ὁ δὲ τρίτον εἶπε πρὸς αὐτούς, Τί γὰρ κακὸν ἐποίησεν οὗτος; Οὐδὲν αἴτιον θανάτου εὗρον ἐν αὐτῷ· παιδεύσας οὖν αὐτὸν ἀπολύσω. ");
INSERT INTO grctr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Οἱ δὲ ἐπέκειντο φωναῖς μεγάλαις, αἰτούμενοι αὐτὸν σταυρωθῆναι· καὶ κατίσχυον αἱ φωναὶ αὐτῶν καὶ τῶν ἀρχιερέων. ");
INSERT INTO grctr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ὁ δὲ Πιλάτος ἐπέκρινε γενέσθαι τὸ αἴτημα αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ἀπέλυσε δὲ αὐτοῖς τὸν διὰ στάσιν καὶ φόνον βεβλημένον εἰς τὴν φυλακήν, ὃν ᾐτοῦντο· τὸν δὲ Ἰησοῦν παρέδωκε τῷ θελήματι αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Καὶ ὡς ἀπήγαγον αὐτόν, ἐπιλαβόμενοι Σίμωνός τινος Κυρηναίου τοῦ ἐρχομένου ἀπ᾿ ἀγροῦ, ἐπέθηκαν αὐτῷ τὸν σταυρόν, φέρειν ὄπισθεν τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ἠκολούθει δὲ αὐτῷ πολὺ πλῆθος τοῦ λαοῦ, καὶ γυναικῶν αἳ καὶ ἐκόπτοντο καὶ ἐθρήνουν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Στραφεὶς δὲ πρὸς αὐτὰς ὁ Ἰησοῦς εἶπε, Θυγατέρες Ἱερουσαλήμ, μὴ κλαίετε ἐπ᾿ ἐμέ, πλὴν ἐφ᾿ ἑαυτὰς κλαίετε καὶ ἐπὶ τὰ τέκνα ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ὅτι ἰδού, ἔρχονται ἡμέραι ἐν αἷς ἐροῦσι, Μακάριαι αἱ στεῖραι, καὶ κοιλίαι αἳ οὐκ ἐγέννησαν, καὶ μαστοὶ οἳ οὐκ ἐθήλασαν. ");
INSERT INTO grctr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Τότε ἄρξονται λέγειν τοῖς ὄρεσι, Πέσετε ἐφ᾿ ἡμᾶς· καὶ τοῖς βουνοῖς, Καλύψατε ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ὅτι εἰ ἐν τῷ ὑγρῷ ξύλῳ ταῦτα ποιοῦσιν, ἐν τῷ ξηρῷ τί γένηται; ");
INSERT INTO grctr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ἤγοντο δὲ καὶ ἕτεροι δύο κακοῦργοι σὺν αὐτῷ ἀναιρεθῆναι. ");
INSERT INTO grctr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Καὶ ὅτε ἀπῆλθον ἐπὶ τὸν τόπον τὸν καλούμενον Κρανίον, ἐκεῖ ἐσταύρωσαν αὐτόν, καὶ τοὺς κακούργους, ὃν μὲν ἐκ δεξιῶν, ὃν δὲ ἐξ ἀριστερῶν. ");
INSERT INTO grctr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ὁ δὲ Ἰησοῦς ἔλεγε, Πάτερ, ἄφες αὐτοῖς· οὐ γὰρ οἴδασι τί ποιοῦσι. Διαμεριζόμενοι δὲ τὰ ἱμάτια αὐτοῦ, ἔβαλον κλῆρον. ");
INSERT INTO grctr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Καὶ εἱστήκει ὁ λαὸς θεωρῶν. Ἐξεμυκτήριζον δὲ καὶ οἱ ἄρχοντες σὺν αὐτοῖς, λέγοντες, Ἄλλους ἔσωσε, σωσάτω ἑαυτόν, εἰ οὗτός ἐστιν ὁ Χριστός, ὁ τοῦ Θεοῦ ἐκλεκτός. ");
INSERT INTO grctr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ἐνέπαιζον δὲ αὐτῷ καὶ οἱ στρατιῶται, προσερχόμενοι καὶ ὄξος προσφέροντες αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","καὶ λέγοντες, Εἰ σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων, σῶσον σεαυτόν. ");
INSERT INTO grctr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ἦν δὲ καὶ ἐπιγραφὴ γεγραμμένη ἐπ᾿ αὐτῷ γράμμασιν Ἑλληνικοῖς καὶ Ῥωμαϊκοῖς καὶ Ἑβραϊκοῖς, Οὗτός ἐστιν ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Εἷς δὲ τῶν κρεμασθέντων κακούργων ἐβλασφήμει αὐτόν, λέγων, Εἰ σὺ εἶ ὁ Χριστός, σῶσον σεαυτὸν καὶ ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ἀποκριθεὶς δὲ ὁ ἕτερος ἐπετίμα αὐτῷ, λέγων, Οὐδὲ φοβῇ σὺ τὸν Θεόν, ὅτι ἐν τῷ αὐτῷ κρίματι εἶ; ");
INSERT INTO grctr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Καὶ ἡμεῖς μὲν δικαίως, ἄξια γὰρ ὧν ἐπράξαμεν ἀπολαμβάνομεν· οὗτος δὲ οὐδὲν ἄτοπον ἔπραξε. ");
INSERT INTO grctr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Καὶ ἔλεγε τῷ Ἰησοῦ, Μνήσθητί μου, Κύριε, ὅταν ἔλθῃς ἐν τῇ βασιλείᾳ σου. ");
INSERT INTO grctr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Καὶ εἶπεν αὐτῷ ὁ Ἰησοῦς, Ἀμὴν λέγω σοι, σήμερον μετ᾿ ἐμοῦ ἔσῃ ἐν τῷ παραδείσῳ. ");
INSERT INTO grctr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ἦν δὲ ὡσεὶ ὥρα ἕκτη, καὶ σκότος ἐγένετο ἐφ᾿ ὅλην τὴν γῆν ἕως ὥρας ἐννάτης. ");
INSERT INTO grctr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Καὶ ἐσκοτίσθη ὁ ἥλιος, καὶ ἐσχίσθη τὸ καταπέτασμα τοῦ ναοῦ μέσον. ");
INSERT INTO grctr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Καὶ φωνήσας φωνῇ μεγάλῃ ὁ Ἰησοῦς εἶπε, Πάτερ, εἰς χεῖράς σου παραθήσομαι τὸ πνεῦμά μου· καὶ ταῦτα εἰπὼν ἐξέπνευσεν. ");
INSERT INTO grctr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ἰδὼν δὲ ὁ ἑκατόνταρχος τὸ γενόμενον, ἐδόξασε τὸν Θεόν, λέγων, Ὄντως ὁ ἄνθρωπος οὗτος δίκαιος ἦν. ");
INSERT INTO grctr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Καὶ πάντες οἱ συμπαραγενόμενοι ὄχλοι ἐπὶ τὴν θεωρίαν ταύτην, θεωροῦντες τὰ γενόμενα, τύπτοντες ἑαυτῶν τὰ στήθη ὑπέστρεφον. ");
INSERT INTO grctr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Εἱστήκεισαν δὲ πάντες οἱ γνωστοὶ αὐτοῦ μακρόθεν, καὶ γυναῖκες αἱ συνακολουθήσασαι αὐτῷ ἀπὸ τῆς Γαλιλαίας, ὁρῶσαι ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Καὶ ἰδού, ἀνὴρ ὀνόματι Ἰωσήφ, βουλευτὴς ὑπάρχων, ἀνὴρ ἀγαθὸς καὶ δίκαιος — ");
INSERT INTO grctr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","οὗτος οὐκ ἦν συγκατατεθειμένος τῇ βουλῇ καὶ τῇ πράξει αὐτῶν — ἀπὸ Ἀριμαθαίας πόλεως τῶν Ἰουδαίων, ὃς καὶ προσεδέχετο καὶ αὐτὸς τὴν βασιλείαν τοῦ Θεοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","οὗτος προσελθὼν τῷ Πιλάτῳ ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Καὶ καθελὼν αὐτὸ ἐνετύλιξεν αὐτὸ σινδόνι, καὶ ἔθηκεν αὐτὸ ἐν μνήματι λαξευτῷ, οὗ οὐκ ἦν οὐδέπω οὐδεὶς κείμενος. ");
INSERT INTO grctr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Καὶ ἡμέρα ἦν Παρασκευή, καὶ σάββατον ἐπέφωσκε. ");
INSERT INTO grctr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Κατακολουθήσασαι δὲ καὶ γυναῖκες, αἵτινες ἦσαν συνεληλυθυῖαι αὐτῷ ἐκ τῆς Γαλιλαίας, ἐθεάσαντο τὸ μνημεῖον, καὶ ὡς ἐτέθη τὸ σῶμα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ὑποστρέψασαι δὲ ἡτοίμασαν ἀρώματα καὶ μύρα. Καὶ τὸ μὲν σάββατον ἡσύχασαν κατὰ τὴν ἐντολήν. ");
INSERT INTO grctr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Τῇ δὲ μιᾷ τῶν σαββάτων, ὄρθρου βαθέος, ἦλθον ἐπὶ τὸ μνῆμα, φέρουσαι ἃ ἡτοίμασαν ἀρώματα, καί τινες σὺν αὐταῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Εὗρον δὲ τὸν λίθον ἀποκεκυλισμένον ἀπὸ τοῦ μνημείου. ");
INSERT INTO grctr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Καὶ εἰσελθοῦσαι οὐχ εὗρον τὸ σῶμα τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Καὶ ἐγένετο ἐν τῷ διαπορεῖσθαι αὐτὰς περὶ τούτου, καὶ ἰδού, δύο ἄνδρες ἐπέστησαν αὐταῖς ἐν ἐσθήσεσιν ἀστραπτούσαις· ");
INSERT INTO grctr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ἐμφόβων δὲ γενομένων αὐτῶν, καὶ κλινουσῶν τὸ πρόσωπον εἰς τὴν γῆν, εἶπον πρὸς αὐτάς, Τί ζητεῖτε τὸν ζῶντα μετὰ τῶν νεκρῶν; ");
INSERT INTO grctr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Οὐκ ἔστιν ὧδε, ἀλλ᾿ ἠγέρθη· μνήσθητε ὡς ἐλάλησεν ὑμῖν, ἔτι ὢν ἐν τῇ Γαλιλαίᾳ, ");
INSERT INTO grctr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","λέγων ὅτι δεῖ τὸν υἱὸν τοῦ ἀνθρώπου παραδοθῆναι εἰς χεῖρας ἀνθρώπων ἁμαρτωλῶν, καὶ σταυρωθῆναι, καὶ τῇ τρίτῃ ἡμέρᾳ ἀναστῆναι. ");
INSERT INTO grctr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Καὶ ἐμνήσθησαν τῶν ῥημάτων αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","καὶ ὑποστρέψασαι ἀπὸ τοῦ μνημείου, ἀπήγγειλαν ταῦτα πάντα τοῖς ἕνδεκα καὶ πᾶσι τοῖς λοιποῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ἦσαν δὲ ἡ Μαγδαληνὴ Μαρία καὶ Ἰωάννα καὶ Μαρία Ἰακώβου, καὶ αἱ λοιπαὶ σὺν αὐταῖς, αἳ ἔλεγον πρὸς τοὺς ἀποστόλους ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Καὶ ἐφάνησαν ἐνώπιον αὐτῶν ὡσεὶ λῆρος τὰ ῥήματα αὐτῶν, καὶ ἠπίστουν αὐταῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ὁ δὲ Πέτρος ἀναστὰς ἔδραμεν ἐπὶ τὸ μνημεῖον, καὶ παρακύψας βλέπει τὰ ὀθόνια κείμενα μόνα· καὶ ἀπῆλθε πρὸς ἑαυτὸν θαυμάζων τὸ γεγονός. ");
INSERT INTO grctr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Καὶ ἰδού, δύο ἐξ αὐτῶν ἦσαν πορευόμενοι ἐν αὐτῇ τῇ ἡμέρᾳ εἰς κώμην ἀπέχουσαν σταδίους ἑξήκοντα ἀπὸ Ἱερουσαλήμ, ᾗ ὄνομα Ἐμμαούς. ");
INSERT INTO grctr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Καὶ αὐτοὶ ὡμίλουν πρὸς ἀλλήλους περὶ πάντων τῶν συμβεβηκότων τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Καὶ ἐγένετο ἐν τῷ ὁμιλεῖν αὐτοὺς καὶ συζητεῖν, καὶ αὐτὸς ὁ Ἰησοῦς ἐγγίσας συνεπορεύετο αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Οἱ δὲ ὀφθαλμοὶ αὐτῶν ἐκρατοῦντο τοῦ μὴ ἐπιγνῶναι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Εἶπε δὲ πρὸς αὐτούς, Τίνες οἱ λόγοι οὗτοι οὓς ἀντιβάλλετε πρὸς ἀλλήλους περιπατοῦντες, καί ἐστε σκυθρωποί; ");
INSERT INTO grctr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ἀποκριθεὶς δὲ ὁ εἷς, ᾧ ὄνομα Κλεοπᾶς, εἶπε πρὸς αὐτόν, Σὺ μόνος παροικεῖς ἐν Ἱερουσαλήμ, καὶ οὐκ ἔγνως τὰ γενόμενα ἐν αὐτῇ ἐν ταῖς ἡμέραις ταύταις; ");
INSERT INTO grctr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Καὶ εἶπεν αὐτοῖς, Ποῖα; Οἱ δὲ εἶπον αὐτῷ, Τὰ περὶ Ἰησοῦ τοῦ Ναζωραίου, ὃς ἐγένετο ἀνὴρ προφήτης δυνατὸς ἐν ἔργῳ καὶ λόγῳ ἐναντίον τοῦ Θεοῦ καὶ παντὸς τοῦ λαοῦ· ");
INSERT INTO grctr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ὅπως τε παρέδωκαν αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ ἄρχοντες ἡμῶν εἰς κρίμα θανάτου, καὶ ἐσταύρωσαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ἡμεῖς δὲ ἠλπίζομεν ὅτι αὐτός ἐστιν ὁ μέλλων λυτροῦσθαι τὸν Ἰσραήλ. Ἀλλά γε σὺν πᾶσι τούτοις τρίτην ταύτην ἡμέραν ἄγει σήμερον ἀφ᾿ οὗ ταῦτα ἐγένετο. ");
INSERT INTO grctr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ἀλλὰ καὶ γυναῖκές τινες ἐξ ἡμῶν ἐξέστησαν ἡμᾶς, γενόμεναι ὄρθριαι ἐπὶ τὸ μνημεῖον· ");
INSERT INTO grctr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","καὶ μὴ εὑροῦσαι τὸ σῶμα αὐτοῦ, ἦλθον λέγουσαι καὶ ὀπτασίαν ἀγγέλων ἑωρακέναι, οἳ λέγουσιν αὐτὸν ζῇν. ");
INSERT INTO grctr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Καὶ ἀπῆλθόν τινες τῶν σὺν ἡμῖν ἐπὶ τὸ μνημεῖον, καὶ εὗρον οὕτω καθὼς καὶ αἱ γυναῖκες εἶπον· αὐτὸν δὲ οὐκ εἶδον. ");
INSERT INTO grctr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Καὶ αὐτὸς εἶπε πρὸς αὐτούς, Ὦ ἀνόητοι καὶ βραδεῖς τῇ καρδίᾳ τοῦ πιστεύειν ἐπὶ πᾶσιν οἷς ἐλάλησαν οἱ προφῆται· ");
INSERT INTO grctr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","οὐχὶ ταῦτα ἔδει παθεῖν τὸν Χριστόν, καὶ εἰσελθεῖν εἰς τὴν δόξαν αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Καὶ ἀρξάμενος ἀπὸ Μωσέως καὶ ἀπὸ πάντων τῶν προφητῶν, διηρμήνευεν αὐτοῖς ἐν πάσαις ταῖς γραφαῖς τὰ περὶ ἑαυτοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Καὶ ἤγγισαν εἰς τὴν κώμην οὗ ἐπορεύοντο· καὶ αὐτὸς προσεποιεῖτο πορρωτέρω πορεύεσθαι. ");
INSERT INTO grctr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Καὶ παρεβιάσαντο αὐτόν, λέγοντες, Μεῖνον μεθ᾿ ἡμῶν, ὅτι πρὸς ἑσπέραν ἐστί, καὶ κέκλικεν ἡ ἡμέρα. Καὶ εἰσῆλθε τοῦ μεῖναι σὺν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Καὶ ἐγένετο ἐν τῷ κατακλιθῆναι αὐτὸν μετ᾿ αὐτῶν, λαβὼν τὸν ἄρτον εὐλόγησε, καὶ κλάσας ἐπεδίδου αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Αὐτῶν δὲ διηνοίχθησαν οἱ ὀφθαλμοί, καὶ ἐπέγνωσαν αὐτόν· καὶ αὐτὸς ἄφαντος ἐγένετο ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Καὶ εἶπον πρὸς ἀλλήλους, Οὐχὶ ἡ καρδία ἡμῶν καιομένη ἦν ἐν ἡμῖν, ὡς ἐλάλει ἡμῖν ἐν τῇ ὁδῷ, καὶ ὡς διήνοιγεν ἡμῖν τὰς γραφάς; ");
INSERT INTO grctr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Καὶ ἀναστάντες αὐτῇ τῇ ὥρᾳ ὑπέστρεψαν εἰς Ἱερουσαλήμ, καὶ εὗρον συνηθροισμένους τοὺς ἕνδεκα καὶ τοὺς σὺν αὐτοῖς, ");
INSERT INTO grctr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","λέγοντας ὅτι Ἠγέρθη ὁ Κύριος ὄντως, καὶ ὤφθη Σίμωνι. ");
INSERT INTO grctr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Καὶ αὐτοὶ ἐξηγοῦντο τὰ ἐν τῇ ὁδῷ, καὶ ὡς ἐγνώσθη αὐτοῖς ἐν τῇ κλάσει τοῦ ἄρτου. ");
INSERT INTO grctr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ταῦτα δὲ αὐτῶν λαλούντων, αὐτὸς ὁ Ἰησοῦς ἔστη ἐν μέσῳ αὐτῶν, καὶ λέγει αὐτοῖς, Εἰρήνη ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Πτοηθέντες δὲ καὶ ἔμφοβοι γενόμενοι ἐδόκουν πνεῦμα θεωρεῖν. ");
INSERT INTO grctr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Καὶ εἶπεν αὐτοῖς, Τί τεταραγμένοι ἐστέ, καὶ διὰ τί διαλογισμοὶ ἀναβαίνουσιν ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grctr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ἴδετε τὰς χεῖράς μου καὶ τοὺς πόδας μου, ὅτι αὐτὸς ἐγώ εἰμι· ψηλαφήσατέ με καὶ ἴδετε, ὅτι πνεῦμα σάρκα καὶ ὀστέα οὐκ ἔχει, καθὼς ἐμὲ θεωρεῖτε ἔχοντα. ");
INSERT INTO grctr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Καὶ τοῦτο εἰπὼν ἐπέδειξεν αὐτοῖς τὰς χεῖρας καὶ τοὺς πόδας. ");
INSERT INTO grctr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ἔτι δὲ ἀπιστούντων αὐτῶν ἀπὸ τῆς χαρᾶς καὶ θαυμαζόντων, εἶπεν αὐτοῖς, Ἔχετέ τι βρώσιμον ἐνθάδε; ");
INSERT INTO grctr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Οἱ δὲ ἐπέδωκαν αὐτῷ ἰχθύος ὀπτοῦ μέρος, καὶ ἀπὸ μελισσίου κηρίου. ");
INSERT INTO grctr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Καὶ λαβὼν ἐνώπιον αὐτῶν ἔφαγεν. ");
INSERT INTO grctr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Εἶπε δὲ αὐτοῖς, Οὗτοι οἱ λόγοι οὓς ἐλάλησα πρὸς ὑμᾶς ἔτι ὢν σὺν ὑμῖν, ὅτι δεῖ πληρωθῆναι πάντα τὰ γεγραμμένα ἐν τῷ νόμῳ Μωσέως καὶ προφήταις καὶ ψαλμοῖς περὶ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Τότε διήνοιξεν αὐτῶν τὸν νοῦν, τοῦ συνιέναι τὰς γραφάς· ");
INSERT INTO grctr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","καὶ εἶπεν αὐτοῖς ὅτι Οὕτω γέγραπται, καὶ οὕτως ἔδει παθεῖν τὸν Χριστόν, καὶ ἀναστῆναι ἐκ νεκρῶν τῇ τρίτῃ ἡμέρᾳ, ");
INSERT INTO grctr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","καὶ κηρυχθῆναι ἐπὶ τῷ ὀνόματι αὐτοῦ μετάνοιαν καὶ ἄφεσιν ἁμαρτιῶν εἰς πάντα τὰ ἔθνη, ἀρξάμενον ἀπὸ Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ὑμεῖς δέ ἐστε μάρτυρες τούτων. ");
INSERT INTO grctr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Καὶ ἰδού, ἐγὼ ἀποστέλλω τὴν ἐπαγγελίαν τοῦ πατρός μου ἐφ᾿ ὑμᾶς· ὑμεῖς δὲ καθίσατε ἐν τῇ πόλει Ἱερουσαλήμ, ἕως οὗ ἐνδύσησθε δύναμιν ἐξ ὕψους. ");
INSERT INTO grctr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ἐξήγαγε δὲ αὐτοὺς ἔξω ἕως εἰς Βηθανίαν· καὶ ἐπάρας τὰς χεῖρας αὐτοῦ εὐλόγησεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Καὶ ἐγένετο ἐν τῷ εὐλογεῖν αὐτὸν αὐτούς, διέστη ἀπ᾿ αὐτῶν, καὶ ἀνεφέρετο εἰς τὸν οὐρανόν. ");
INSERT INTO grctr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Καὶ αὐτοὶ προσκυνήσαντες αὐτόν, ὑπέστρεψαν εἰς Ἱερουσαλὴμ μετὰ χαρᾶς μεγάλης· ");
INSERT INTO grctr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","καὶ ἦσαν διὰ παντὸς ἐν τῷ ἱερῷ, αἰνοῦντες καὶ εὐλογοῦντες τὸν Θεόν. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ἐν ἀρχῇ ἦν ὁ λόγος, καὶ ὁ λόγος ἦν πρὸς τὸν Θεόν, καὶ Θεὸς ἦν ὁ λόγος. ");
INSERT INTO grctr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Οὗτος ἦν ἐν ἀρχῇ πρὸς τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Πάντα δι᾿ αὐτοῦ ἐγένετο, καὶ χωρὶς αὐτοῦ ἐγένετο οὐδὲ ἓν ὃ γέγονεν. ");
INSERT INTO grctr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ἐν αὐτῷ ζωὴ ἦν, καὶ ἡ ζωὴ ἦν τὸ φῶς τῶν ἀνθρώπων, ");
INSERT INTO grctr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","καὶ τὸ φῶς ἐν τῇ σκοτίᾳ φαίνει, καὶ ἡ σκοτία αὐτὸ οὐ κατέλαβεν. ");
INSERT INTO grctr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ἐγένετο ἄνθρωπος ἀπεσταλμένος παρὰ Θεοῦ, ὄνομα αὐτῷ Ἰωάννης. ");
INSERT INTO grctr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Οὗτος ἦλθεν εἰς μαρτυρίαν, ἵνα μαρτυρήσῃ περὶ τοῦ φωτός, ἵνα πάντες πιστεύσωσι δι᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Οὐκ ἦν ἐκεῖνος τὸ φῶς, ἀλλ᾿ ἵνα μαρτυρήσῃ περὶ τοῦ φωτός. ");
INSERT INTO grctr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ἦν τὸ φῶς τὸ ἀληθινόν, ὃ φωτίζει πάντα ἄνθρωπον ἐρχόμενον εἰς τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ἐν τῷ κόσμῳ ἦν, καὶ ὁ κόσμος δι᾿ αὐτοῦ ἐγένετο, καὶ ὁ κόσμος αὐτὸν οὐκ ἔγνω. ");
INSERT INTO grctr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Εἰς τὰ ἴδια ἦλθε, καὶ οἱ ἴδιοι αὐτὸν οὐ παρέλαβον. ");
INSERT INTO grctr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ὅσοι δὲ ἔλαβον αὐτόν, ἔδωκεν αὐτοῖς ἐξουσίαν τέκνα Θεοῦ γενέσθαι, τοῖς πιστεύουσιν εἰς τὸ ὄνομα αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","οἳ οὐκ ἐξ αἱμάτων, οὐδὲ ἐκ θελήματος σαρκός, οὐδὲ ἐκ θελήματος ἀνδρός, ἀλλ᾿ ἐκ Θεοῦ ἐγεννήθησαν. ");
INSERT INTO grctr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Καὶ ὁ λόγος σὰρξ ἐγένετο, καὶ ἐσκήνωσεν ἐν ἡμῖν — καὶ ἐθεασάμεθα τὴν δόξαν αὐτοῦ, δόξαν ὡς μονογενοῦς παρὰ πατρός — πλήρης χάριτος καὶ ἀληθείας. ");
INSERT INTO grctr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ἰωάννης μαρτυρεῖ περὶ αὐτοῦ, καὶ κέκραγε λέγων, Οὗτος ἦν ὃν εἶπον, Ὁ ὀπίσω μου ἐρχόμενος ἔμπροσθέν μου γέγονεν· ὅτι πρῶτός μου ἦν. ");
INSERT INTO grctr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Καὶ ἐκ τοῦ πληρώματος αὐτοῦ ἡμεῖς πάντες ἐλάβομεν, καὶ χάριν ἀντὶ χάριτος. ");
INSERT INTO grctr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ὅτι ὁ νόμος διὰ Μωσέως ἐδόθη, ἡ χάρις καὶ ἡ ἀλήθεια διὰ Ἰησοῦ Χριστοῦ ἐγένετο. ");
INSERT INTO grctr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Θεὸν οὐδεὶς ἑώρακε πώποτε· ὁ μονογενὴς υἱός, ὁ ὢν εἰς τὸν κόλπον τοῦ πατρός, ἐκεῖνος ἐξηγήσατο. ");
INSERT INTO grctr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Καὶ αὕτη ἐστὶν ἡ μαρτυρία τοῦ Ἰωάννου, ὅτε ἀπέστειλαν οἱ Ἰουδαῖοι ἐξ Ἱεροσολύμων ἱερεῖς καὶ Λευΐτας ἵνα ἐρωτήσωσιν αὐτόν, Σὺ τίς εἶ; ");
INSERT INTO grctr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Καὶ ὡμολόγησε, καὶ οὐκ ἠρνήσατο· καὶ ὡμολόγησεν ὅτι Οὐκ εἰμὶ ἐγὼ ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Καὶ ἠρώτησαν αὐτόν, Τί οὖν; Ἠλίας εἶ σύ; Καὶ λέγει, Οὐκ εἰμί. Ὁ προφήτης εἶ σύ; Καὶ ἀπεκρίθη, Οὔ. ");
INSERT INTO grctr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Εἶπον οὖν αὐτῷ, Τίς εἶ; Ἵνα ἀπόκρισιν δῶμεν τοῖς πέμψασιν ἡμᾶς. Τί λέγεις περὶ σεαυτοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ἔφη, Ἐγὼ φωνὴ βοῶντος ἐν τῇ ἐρήμῳ, Εὐθύνατε τὴν ὁδὸν Κυρίου, καθὼς εἶπεν Ἠσαΐας ὁ προφήτης. ");
INSERT INTO grctr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Καὶ οἱ ἀπεσταλμένοι ἦσαν ἐκ τῶν Φαρισαίων. ");
INSERT INTO grctr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Καὶ ἠρώτησαν αὐτόν, καὶ εἶπον αὐτῷ, Τί οὖν βαπτίζεις, εἰ σὺ οὐκ εἶ ὁ Χριστός, οὔτε Ἠλίας, οὔτε ὁ προφήτης; ");
INSERT INTO grctr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ἀπεκρίθη αὐτοῖς ὁ Ἰωάννης λέγων, Ἐγὼ βαπτίζω ἐν ὕδατι· μέσος δὲ ὑμῶν ἕστηκεν ὃν ὑμεῖς οὐκ οἴδατε. ");
INSERT INTO grctr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Αὐτός ἐστιν ὁ ὀπίσω μου ἐρχόμενος, ὃς ἔμπροσθέν μου γέγονεν· οὗ ἐγὼ οὐκ εἰμὶ ἄξιος ἵνα λύσω αὐτοῦ τὸν ἱμάντα τοῦ ὑποδήματος. ");
INSERT INTO grctr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ταῦτα ἐν Βηθαβαρᾶ ἐγένετο πέραν τοῦ Ἰορδάνου, ὅπου ἦν Ἰωάννης βαπτίζων. ");
INSERT INTO grctr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Τῇ ἐπαύριον βλέπει ὁ Ἰωάννης τὸν Ἰησοῦν ἐρχόμενον πρὸς αὐτόν, καὶ λέγει, Ἴδε ὁ ἀμνὸς τοῦ Θεοῦ, ὁ αἴρων τὴν ἁμαρτίαν τοῦ κόσμου. ");
INSERT INTO grctr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Οὗτός ἐστι περὶ οὗ ἐγὼ εἶπον, Ὀπίσω μου ἔρχεται ἀνὴρ ὃς ἔμπροσθέν μου γέγονεν, ὅτι πρῶτός μου ἦν. ");
INSERT INTO grctr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Κἀγὼ οὐκ ᾔδειν αὐτόν· ἀλλ᾿ ἵνα φανερωθῇ τῷ Ἰσραήλ, διὰ τοῦτο ἦλθον ἐγὼ ἐν τῷ ὕδατι βαπτίζων. ");
INSERT INTO grctr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Καὶ ἐμαρτύρησεν Ἰωάννης λέγων ὅτι Τεθέαμαι τὸ πνεῦμα καταβαῖνον ὡσεὶ περιστερὰν ἐξ οὐρανοῦ, καὶ ἔμεινεν ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Κἀγὼ οὐκ ᾔδειν αὐτόν· ἀλλ᾿ ὁ πέμψας με βαπτίζειν ἐν ὕδατι, ἐκεῖνός μοι εἶπεν, Ἐφ᾿ ὃν ἂν ἴδῃς τὸ πνεῦμα καταβαῖνον καὶ μένον ἐπ᾿ αὐτόν, οὗτός ἐστιν ὁ βαπτίζων ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grctr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Κἀγὼ ἑώρακα, καὶ μεμαρτύρηκα ὅτι οὗτός ἐστιν ὁ υἱὸς τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Τῇ ἐπαύριον πάλιν εἱστήκει ὁ Ἰωάννης, καὶ ἐκ τῶν μαθητῶν αὐτοῦ δύο· ");
INSERT INTO grctr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","καὶ ἐμβλέψας τῷ Ἰησοῦ περιπατοῦντι, λέγει, Ἴδε ὁ ἀμνὸς τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Καὶ ἤκουσαν αὐτοῦ οἱ δύο μαθηταὶ λαλοῦντος, καὶ ἠκολούθησαν τῷ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Στραφεὶς δὲ ὁ Ἰησοῦς καὶ θεασάμενος αὐτοὺς ἀκολουθοῦντας, λέγει αὐτοῖς, Τί ζητεῖτε; Οἱ δὲ εἶπον αὐτῷ, Ῥαββί — ὃ λέγεται ἑρμηνευόμενον, Διδάσκαλε — ποῦ μένεις; ");
INSERT INTO grctr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Λέγει αὐτοῖς, Ἔρχεσθε καὶ ἴδετε. Ἦλθον καὶ εἶδον ποῦ μένει· καὶ παρ᾿ αὐτῷ ἔμειναν τὴν ἡμέραν ἐκείνην· ὥρα δὲ ἦν ὡς δεκάτη. ");
INSERT INTO grctr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ἦν Ἀνδρέας ὁ ἀδελφὸς Σίμωνος Πέτρου εἷς ἐκ τῶν δύο τῶν ἀκουσάντων παρὰ Ἰωάννου καὶ ἀκολουθησάντων αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Εὑρίσκει οὗτος πρῶτος τὸν ἀδελφὸν τὸν ἴδιον Σίμωνα, καὶ λέγει αὐτῷ, Εὑρήκαμεν τὸν Μεσσίαν — ὅ ἐστι μεθερμηνευόμενον, ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Καὶ ἤγαγεν αὐτὸν πρὸς τὸν Ἰησοῦν. Ἐμβλέψας δὲ αὐτῷ ὁ Ἰησοῦς εἶπε, Σὺ εἶ Σίμων ὁ υἱὸς Ἰωνᾶ· σὺ κληθήσῃ Κηφᾶς — ὃ ἑρμηνεύεται Πέτρος. ");
INSERT INTO grctr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Τῇ ἐπαύριον ἠθέλησεν ὁ Ἰησοῦς ἐξελθεῖν εἰς τὴν Γαλιλαίαν, καὶ εὑρίσκει Φίλιππον, καὶ λέγει αὐτῷ, Ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ἦν δὲ ὁ Φίλιππος ἀπὸ Βηθσαϊδά, ἐκ τῆς πόλεως Ἀνδρέου καὶ Πέτρου. ");
INSERT INTO grctr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Εὑρίσκει Φίλιππος τὸν Ναθαναήλ, καὶ λέγει αὐτῷ, Ὃν ἔγραψε Μωσῆς ἐν τῷ νόμῳ καὶ οἱ προφῆται εὑρήκαμεν, Ἰησοῦν τὸν υἱὸν τοῦ Ἰωσὴφ τὸν ἀπὸ Ναζαρέθ. ");
INSERT INTO grctr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Καὶ εἶπεν αὐτῷ Ναθαναήλ, Ἐκ Ναζαρὲθ δύναταί τι ἀγαθὸν εἶναι; Λέγει αὐτῷ Φίλιππος, Ἔρχου καὶ ἴδε. ");
INSERT INTO grctr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Εἶδεν ὁ Ἰησοῦς τὸν Ναθαναὴλ ἐρχόμενον πρὸς αὐτόν, καὶ λέγει περὶ αὐτοῦ, Ἴδε ἀληθῶς Ἰσραηλίτης, ἐν ᾧ δόλος οὐκ ἔστι. ");
INSERT INTO grctr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Λέγει αὐτῷ Ναθαναήλ, Πόθεν με γινώσκεις; Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτῷ, Πρὸ τοῦ σε Φίλιππον φωνῆσαι, ὄντα ὑπὸ τὴν συκῆν, εἶδόν σε. ");
INSERT INTO grctr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ἀπεκρίθη Ναθαναὴλ καὶ λέγει αὐτῷ, Ῥαββί, σὺ εἶ ὁ υἱὸς τοῦ Θεοῦ, σὺ εἶ ὁ βασιλεὺς τοῦ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ, Ὅτι εἶπόν σοι, Εἶδόν σε ὑποκάτω τῆς συκῆς, πιστεύεις; Μείζω τούτων ὄψει. ");
INSERT INTO grctr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Καὶ λέγει αὐτῷ, Ἀμὴν ἀμὴν λέγω ὑμῖν, ἀπ᾿ ἄρτι ὄψεσθε τὸν οὐρανὸν ἀνεῳγότα, καὶ τοὺς ἀγγέλους τοῦ Θεοῦ ἀναβαίνοντας καὶ καταβαίνοντας ἐπὶ τὸν υἱὸν τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Καὶ τῇ ἡμέρᾳ τῇ τρίτῃ γάμος ἐγένετο ἐν Κανᾷ τῆς Γαλιλαίας, καὶ ἦν ἡ μήτηρ τοῦ Ἰησοῦ ἐκεῖ· ");
INSERT INTO grctr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ἐκλήθη δὲ καὶ ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὸν γάμον. ");
INSERT INTO grctr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Καὶ ὑστερήσαντος οἴνου, λέγει ἡ μήτηρ τοῦ Ἰησοῦ πρὸς αὐτόν, Οἶνον οὐκ ἔχουσι. ");
INSERT INTO grctr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Λέγει αὐτῇ ὁ Ἰησοῦς, Τί ἐμοὶ καὶ σοί, γύναι; Οὔπω ἥκει ἡ ὥρα μου. ");
INSERT INTO grctr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Λέγει ἡ μήτηρ αὐτοῦ τοῖς διακόνοις, Ὅ τι ἂν λέγῃ ὑμῖν, ποιήσατε. ");
INSERT INTO grctr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ἦσαν δὲ ἐκεῖ ὑδρίαι λίθιναι ἓξ κείμεναι κατὰ τὸν καθαρισμὸν τῶν Ἰουδαίων, χωροῦσαι ἀνὰ μετρητὰς δύο ἢ τρεῖς. ");
INSERT INTO grctr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Λέγει αὐτοῖς ὁ Ἰησοῦς, Γεμίσατε τὰς ὑδρίας ὕδατος. Καὶ ἐγέμισαν αὐτὰς ἕως ἄνω. ");
INSERT INTO grctr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Καὶ λέγει αὐτοῖς, Ἀντλήσατε νῦν, καὶ φέρετε τῷ ἀρχιτρικλίνῳ. Καὶ ἤνεγκαν. ");
INSERT INTO grctr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ὡς δὲ ἐγεύσατο ὁ ἀρχιτρίκλινος τὸ ὕδωρ οἶνον γεγενημένον, καὶ οὐκ ᾔδει πόθεν ἐστίν — οἱ δὲ διάκονοι ᾔδεισαν οἱ ἠντληκότες τὸ ὕδωρ — φωνεῖ τὸν νυμφίον ὁ ἀρχιτρίκλινος, ");
INSERT INTO grctr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","καὶ λέγει αὐτῷ, Πᾶς ἄνθρωπος πρῶτον τὸν καλὸν οἶνον τίθησι, καὶ ὅταν μεθυσθῶσι, τότε τὸν ἐλάσσω· σὺ τετήρηκας τὸν καλὸν οἶνον ἕως ἄρτι. ");
INSERT INTO grctr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ταύτην ἐποίησε τὴν ἀρχὴν τῶν σημείων ὁ Ἰησοῦς ἐν Κανᾷ τῆς Γαλιλαίας, καὶ ἐφανέρωσε τὴν δόξαν αὐτοῦ· καὶ ἐπίστευσαν εἰς αὐτὸν οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Μετὰ τοῦτο κατέβη εἰς Καπερναούμ, αὐτὸς καὶ ἡ μήτηρ αὐτοῦ, καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ οἱ μαθηταὶ αὐτοῦ· καὶ ἐκεῖ ἔμειναν οὐ πολλὰς ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Καὶ ἐγγὺς ἦν τὸ Πάσχα τῶν Ἰουδαίων, καὶ ἀνέβη εἰς Ἱεροσόλυμα ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Καὶ εὗρεν ἐν τῷ ἱερῷ τοὺς πωλοῦντας βόας καὶ πρόβατα καὶ περιστεράς, καὶ τοὺς κερματιστὰς καθημένους. ");
INSERT INTO grctr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Καὶ ποιήσας φραγέλλιον ἐκ σχοινίων πάντας ἐξέβαλεν ἐκ τοῦ ἱεροῦ, τά τε πρόβατα καὶ τοὺς βόας· καὶ τῶν κολλυβιστῶν ἐξέχεε τὸ κέρμα, καὶ τὰς τραπέζας ἀνέστρεψε· ");
INSERT INTO grctr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","καὶ τοῖς τὰς περιστερὰς πωλοῦσιν εἶπεν, Ἄρατε ταῦτα ἐντεῦθεν· μὴ ποιεῖτε τὸν οἶκον τοῦ πατρός μου οἶκον ἐμπορίου. ");
INSERT INTO grctr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ἐμνήσθησαν δὲ οἱ μαθηταὶ αὐτοῦ ὅτι γεγραμμένον ἐστίν, Ὁ ζῆλος τοῦ οἴκου σου κατέφαγέ με. ");
INSERT INTO grctr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ἀπεκρίθησαν οὖν οἱ Ἰουδαῖοι καὶ εἶπον αὐτῷ, Τί σημεῖον δεικνύεις ἡμῖν, ὅτι ταῦτα ποιεῖς; ");
INSERT INTO grctr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτοῖς, Λύσατε τὸν ναὸν τοῦτον, καὶ ἐν τρισὶν ἡμέραις ἐγερῶ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Εἶπον οὖν οἱ Ἰουδαῖοι, Τεσσαράκοντα καὶ ἓξ ἔτεσιν ᾠκοδομήθη ὁ ναὸς οὗτος, καὶ σὺ ἐν τρισὶν ἡμέραις ἐγερεῖς αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ἐκεῖνος δὲ ἔλεγε περὶ τοῦ ναοῦ τοῦ σώματος αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ὅτε οὖν ἠγέρθη ἐκ νεκρῶν, ἐμνήσθησαν οἱ μαθηταὶ αὐτοῦ ὅτι τοῦτο ἔλεγεν αὐτοῖς· καὶ ἐπίστευσαν τῇ γραφῇ, καὶ τῷ λόγῳ ᾧ εἶπεν ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ὡς δὲ ἦν ἐν Ἱεροσολύμοις ἐν τῷ Πάσχα, ἐν τῇ ἑορτῇ, πολλοὶ ἐπίστευσαν εἰς τὸ ὄνομα αὐτοῦ, θεωροῦντες αὐτοῦ τὰ σημεῖα ἃ ἐποίει. ");
INSERT INTO grctr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Αὐτὸς δὲ ὁ Ἰησοῦς οὐκ ἐπίστευεν ἑαυτὸν αὐτοῖς, διὰ τὸ αὐτὸν γινώσκειν πάντας, ");
INSERT INTO grctr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","καὶ ὅτι οὐ χρείαν εἶχεν ἵνα τις μαρτυρήσῃ περὶ τοῦ ἀνθρώπου· αὐτὸς γὰρ ἐγίνωσκε τί ἦν ἐν τῷ ἀνθρώπῳ. ");
INSERT INTO grctr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ἦν δὲ ἄνθρωπος ἐκ τῶν Φαρισαίων, Νικόδημος ὄνομα αὐτῷ, ἄρχων τῶν Ἰουδαίων· ");
INSERT INTO grctr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","οὗτος ἦλθε πρὸς τὸν Ἰησοῦν νυκτός, καὶ εἶπεν αὐτῷ, Ῥαββί, οἴδαμεν ὅτι ἀπὸ Θεοῦ ἐλήλυθας διδάσκαλος· οὐδεὶς γὰρ ταῦτα τὰ σημεῖα δύναται ποιεῖν ἃ σὺ ποιεῖς, ἐὰν μὴ ᾖ ὁ Θεὸς μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτῷ, Ἀμὴν ἀμὴν λέγω σοι, ἐὰν μή τις γεννηθῇ ἄνωθεν, οὐ δύναται ἰδεῖν τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Λέγει πρὸς αὐτὸν ὁ Νικόδημος, Πῶς δύναται ἄνθρωπος γεννηθῆναι γέρων ὤν; Μὴ δύναται εἰς τὴν κοιλίαν τῆς μητρὸς αὐτοῦ δεύτερον εἰσελθεῖν καὶ γεννηθῆναι; ");
INSERT INTO grctr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ἀπεκρίθη ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω σοι, ἐὰν μή τις γεννηθῇ ἐξ ὕδατος καὶ πνεύματος, οὐ δύναται εἰσελθεῖν εἰς τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Τὸ γεγεννημένον ἐκ τῆς σαρκὸς σάρξ ἐστι· καὶ τὸ γεγεννημένον ἐκ τοῦ πνεύματος πνεῦμά ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Μὴ θαυμάσῃς ὅτι εἶπόν σοι, Δεῖ ὑμᾶς γεννηθῆναι ἄνωθεν. ");
INSERT INTO grctr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Τὸ πνεῦμα ὅπου θέλει πνεῖ, καὶ τὴν φωνὴν αὐτοῦ ἀκούεις, ἀλλ᾿ οὐκ οἶδας πόθεν ἔρχεται καὶ ποῦ ὑπάγει· οὕτως ἐστὶ πᾶς ὁ γεγεννημένος ἐκ τοῦ πνεύματος. ");
INSERT INTO grctr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ἀπεκρίθη Νικόδημος καὶ εἶπεν αὐτῷ, Πῶς δύναται ταῦτα γενέσθαι; ");
INSERT INTO grctr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτῷ, Σὺ εἶ ὁ διδάσκαλος τοῦ Ἰσραήλ, καὶ ταῦτα οὐ γινώσκεις; ");
INSERT INTO grctr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ἀμὴν ἀμὴν λέγω σοι ὅτι ὃ οἴδαμεν λαλοῦμεν, καὶ ὃ ἑωράκαμεν μαρτυροῦμεν· καὶ τὴν μαρτυρίαν ἡμῶν οὐ λαμβάνετε. ");
INSERT INTO grctr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Εἰ τὰ ἐπίγεια εἶπον ὑμῖν καὶ οὐ πιστεύετε, πῶς, ἐὰν εἴπω ὑμῖν τὰ ἐπουράνια, πιστεύσετε; ");
INSERT INTO grctr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Καὶ οὐδεὶς ἀναβέβηκεν εἰς τὸν οὐρανόν, εἰ μὴ ὁ ἐκ τοῦ οὐρανοῦ καταβάς, ὁ υἱὸς τοῦ ἀνθρώπου ὁ ὢν ἐν τῷ οὐρανῷ. ");
INSERT INTO grctr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Καὶ καθὼς Μωσῆς ὕψωσε τὸν ὄφιν ἐν τῇ ἐρήμῳ, οὕτως ὑψωθῆναι δεῖ τὸν υἱὸν τοῦ ἀνθρώπου· ");
INSERT INTO grctr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ἵνα πᾶς ὁ πιστεύων εἰς αὐτὸν μὴ ἀπόληται, ἀλλ᾿ ἔχῃ ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Οὕτω γὰρ ἠγάπησεν ὁ Θεὸς τὸν κόσμον, ὥστε τὸν υἱὸν αὐτοῦ τὸν μονογενῆ ἔδωκεν, ἵνα πᾶς ὁ πιστεύων εἰς αὐτὸν μὴ ἀπόληται, ἀλλ᾿ ἔχῃ ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Οὐ γὰρ ἀπέστειλεν ὁ Θεὸς τὸν υἱὸν αὐτοῦ εἰς τὸν κόσμον ἵνα κρίνῃ τὸν κόσμον, ἀλλ᾿ ἵνα σωθῇ ὁ κόσμος δι᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ὁ πιστεύων εἰς αὐτὸν οὐ κρίνεται· ὁ δὲ μὴ πιστεύων ἤδη κέκριται, ὅτι μὴ πεπίστευκεν εἰς τὸ ὄνομα τοῦ μονογενοῦς υἱοῦ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Αὕτη δέ ἐστιν ἡ κρίσις, ὅτι τὸ φῶς ἐλήλυθεν εἰς τὸν κόσμον, καὶ ἠγάπησαν οἱ ἄνθρωποι μᾶλλον τὸ σκότος ἢ τὸ φῶς· ἦν γὰρ πονηρὰ αὐτῶν τὰ ἔργα. ");
INSERT INTO grctr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Πᾶς γὰρ ὁ φαῦλα πράσσων μισεῖ τὸ φῶς, καὶ οὐκ ἔρχεται πρὸς τὸ φῶς, ἵνα μὴ ἐλεγχθῇ τὰ ἔργα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ὁ δὲ ποιῶν τὴν ἀλήθειαν ἔρχεται πρὸς τὸ φῶς, ἵνα φανερωθῇ αὐτοῦ τὰ ἔργα, ὅτι ἐν Θεῷ ἐστιν εἰργασμένα. ");
INSERT INTO grctr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Μετὰ ταῦτα ἦλθεν ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὴν Ἰουδαίαν γῆν· καὶ ἐκεῖ διέτριβε μετ᾿ αὐτῶν καὶ ἐβάπτιζεν. ");
INSERT INTO grctr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ἦν δὲ καὶ Ἰωάννης βαπτίζων ἐν Αἰνὼν ἐγγὺς τοῦ Σαλείμ, ὅτι ὕδατα πολλὰ ἦν ἐκεῖ· καὶ παρεγίνοντο καὶ ἐβαπτίζοντο. ");
INSERT INTO grctr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Οὔπω γὰρ ἦν βεβλημένος εἰς τὴν φυλακὴν ὁ Ἰωάννης. ");
INSERT INTO grctr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ἐγένετο οὖν ζήτησις ἐκ τῶν μαθητῶν Ἰωάννου μετὰ Ἰουδαίων περὶ καθαρισμοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Καὶ ἦλθον πρὸς τὸν Ἰωάννην καὶ εἶπον αὐτῷ, Ῥαββί, ὃς ἦν μετὰ σοῦ πέραν τοῦ Ἰορδάνου, ᾧ σὺ μεμαρτύρηκας, ἴδε οὗτος βαπτίζει, καὶ πάντες ἔρχονται πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ἀπεκρίθη Ἰωάννης καὶ εἶπεν, Οὐ δύναται ἄνθρωπος λαμβάνειν οὐδέν, ἐὰν μὴ ᾖ δεδομένον αὐτῷ ἐκ τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Αὐτοὶ ὑμεῖς μοι μαρτυρεῖτε ὅτι εἶπον, Οὐκ εἰμὶ ἐγὼ ὁ Χριστός, ἀλλ᾿ ὅτι Ἀπεσταλμένος εἰμὶ ἔμπροσθεν ἐκείνου. ");
INSERT INTO grctr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ὁ ἔχων τὴν νύμφην, νυμφίος ἐστίν· ὁ δὲ φίλος τοῦ νυμφίου, ὁ ἑστηκὼς καὶ ἀκούων αὐτοῦ, χαρᾷ χαίρει διὰ τὴν φωνὴν τοῦ νυμφίου· αὕτη οὖν ἡ χαρὰ ἡ ἐμὴ πεπλήρωται. ");
INSERT INTO grctr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ἐκεῖνον δεῖ αὐξάνειν, ἐμὲ δὲ ἐλαττοῦσθαι. ");
INSERT INTO grctr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ὁ ἄνωθεν ἐρχόμενος ἐπάνω πάντων ἐστίν. Ὁ ὢν ἐκ τῆς γῆς, ἐκ τῆς γῆς ἐστι, καὶ ἐκ τῆς γῆς λαλεῖ· ὁ ἐκ τοῦ οὐρανοῦ ἐρχόμενος ἐπάνω πάντων ἐστί. ");
INSERT INTO grctr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Καὶ ὃ ἑώρακε καὶ ἤκουσε, τοῦτο μαρτυρεῖ· καὶ τὴν μαρτυρίαν αὐτοῦ οὐδεὶς λαμβάνει. ");
INSERT INTO grctr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ὁ λαβὼν αὐτοῦ τὴν μαρτυρίαν ἐσφράγισεν ὅτι ὁ Θεὸς ἀληθής ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ὃν γὰρ ἀπέστειλεν ὁ Θεός, τὰ ῥήματα τοῦ Θεοῦ λαλεῖ· οὐ γὰρ ἐκ μέτρου δίδωσιν ὁ Θεὸς τὸ πνεῦμα. ");
INSERT INTO grctr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ὁ πατὴρ ἀγαπᾷ τὸν υἱόν, καὶ πάντα δέδωκεν ἐν τῇ χειρὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ὁ πιστεύων εἰς τὸν υἱὸν ἔχει ζωὴν αἰώνιον· ὁ δὲ ἀπειθῶν τῷ υἱῷ, οὐκ ὄψεται ζωήν, ἀλλ᾿ ἡ ὀργὴ τοῦ Θεοῦ μένει ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ὡς οὖν ἔγνω ὁ Κύριος ὅτι ἤκουσαν οἱ Φαρισαῖοι ὅτι Ἰησοῦς πλείονας μαθητὰς ποιεῖ καὶ βαπτίζει ἢ Ἰωάννης — ");
INSERT INTO grctr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","καίτοιγε Ἰησοῦς αὐτὸς οὐκ ἐβάπτιζεν, ἀλλ᾿ οἱ μαθηταὶ αὐτοῦ — ");
INSERT INTO grctr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ἀφῆκε τὴν Ἰουδαίαν, καὶ ἀπῆλθε πάλιν εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grctr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ἔδει δὲ αὐτὸν διέρχεσθαι διὰ τῆς Σαμαρείας. ");
INSERT INTO grctr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ἔρχεται οὖν εἰς πόλιν τῆς Σαμαρείας λεγομένην Συχάρ, πλησίον τοῦ χωρίου ὃ ἔδωκεν Ἰακὼβ Ἰωσὴφ τῷ υἱῷ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ἦν δὲ ἐκεῖ πηγὴ τοῦ Ἰακώβ. Ὁ οὖν Ἰησοῦς κεκοπιακὼς ἐκ τῆς ὁδοιπορίας ἐκαθέζετο οὕτως ἐπὶ τῇ πηγῇ. Ὥρα ἦν ὡσεὶ ἕκτη. ");
INSERT INTO grctr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ἔρχεται γυνὴ ἐκ τῆς Σαμαρείας ἀντλῆσαι ὕδωρ· λέγει αὐτῇ ὁ Ἰησοῦς, Δός μοι πιεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Οἱ γὰρ μαθηταὶ αὐτοῦ ἀπεληλύθεισαν εἰς τὴν πόλιν, ἵνα τροφὰς ἀγοράσωσι. ");
INSERT INTO grctr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Λέγει οὖν αὐτῷ ἡ γυνὴ ἡ Σαμαρεῖτις, Πῶς σὺ Ἰουδαῖος ὢν παρ᾿ ἐμοῦ πιεῖν αἰτεῖς, οὔσης γυναικὸς Σαμαρείτιδος; — Οὐ γὰρ συγχρῶνται Ἰουδαῖοι Σαμαρείταις. ");
INSERT INTO grctr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῇ, Εἰ ᾔδεις τὴν δωρεὰν τοῦ Θεοῦ, καὶ τίς ἐστιν ὁ λέγων σοι, Δός μοι πιεῖν, σὺ ἂν ᾔτησας αὐτόν, καὶ ἔδωκεν ἄν σοι ὕδωρ ζῶν. ");
INSERT INTO grctr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Λέγει αὐτῷ ἡ γυνή, Κύριε, οὔτε ἄντλημα ἔχεις, καὶ τὸ φρέαρ ἐστὶ βαθύ· πόθεν οὖν ἔχεις τὸ ὕδωρ τὸ ζῶν; ");
INSERT INTO grctr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Μὴ σὺ μείζων εἶ τοῦ πατρὸς ἡμῶν Ἰακώβ, ὃς ἔδωκεν ἡμῖν τὸ φρέαρ, καὶ αὐτὸς ἐξ αὐτοῦ ἔπιε, καὶ οἱ υἱοὶ αὐτοῦ, καὶ τὰ θρέμματα αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτῇ, Πᾶς ὁ πίνων ἐκ τοῦ ὕδατος τούτου, διψήσει πάλιν· ");
INSERT INTO grctr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ὃς δ᾿ ἂν πίῃ ἐκ τοῦ ὕδατος οὗ ἐγὼ δώσω αὐτῷ, οὐ μὴ διψήσῃ εἰς τὸν αἰῶνα· ἀλλὰ τὸ ὕδωρ ὃ δώσω αὐτῷ γενήσεται ἐν αὐτῷ πηγὴ ὕδατος ἁλλομένου εἰς ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Λέγει πρὸς αὐτὸν ἡ γυνή, Κύριε, δός μοι τοῦτο τὸ ὕδωρ, ἵνα μὴ διψῶ, μηδὲ ἔρχωμαι ἐνθάδε ἀντλεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Λέγει αὐτῇ ὁ Ἰησοῦς, Ὕπαγε, φώνησον τὸν ἄνδρα σοῦ, καὶ ἐλθὲ ἐνθάδε. ");
INSERT INTO grctr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ἀπεκρίθη ἡ γυνὴ καὶ εἶπεν, Οὐκ ἔχω ἄνδρα. Λέγει αὐτῇ ὁ Ἰησοῦς, Καλῶς εἶπας ὅτι Ἄνδρα οὐκ ἔχω· ");
INSERT INTO grctr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","πέντε γὰρ ἄνδρας ἔσχες, καὶ νῦν ὃν ἔχεις οὐκ ἔστι σου ἀνήρ· τοῦτο ἀληθὲς εἴρηκας. ");
INSERT INTO grctr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Λέγει αὐτῷ ἡ γυνή, Κύριε, θεωρῶ ὅτι προφήτης εἶ σύ. ");
INSERT INTO grctr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Οἱ πατέρες ἡμῶν ἐν τούτῳ τῷ ὄρει προσεκύνησαν· καὶ ὑμεῖς λέγετε ὅτι ἐν Ἱεροσολύμοις ἐστὶν ὁ τόπος ὅπου δεῖ προσκυνεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Λέγει αὐτῇ ὁ Ἰησοῦς, Γύναι, πίστευσόν μοι ὅτι ἔρχεται ὥρα, ὅτε οὔτε ἐν τῷ ὄρει τούτῳ οὔτε ἐν Ἱεροσολύμοις προσκυνήσετε τῷ πατρί. ");
INSERT INTO grctr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ὑμεῖς προσκυνεῖτε ὃ οὐκ οἴδατε· ἡμεῖς προσκυνοῦμεν ὃ οἴδαμεν· ὅτι ἡ σωτηρία ἐκ τῶν Ἰουδαίων ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ἀλλ᾿ ἔρχεται ὥρα καὶ νῦν ἐστιν, ὅτε οἱ ἀληθινοὶ προσκυνηταὶ προσκυνήσουσι τῷ πατρὶ ἐν πνεύματι καὶ ἀληθείᾳ· καὶ γὰρ ὁ πατὴρ τοιούτους ζητεῖ τοὺς προσκυνοῦντας αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Πνεῦμα ὁ Θεός· καὶ τοὺς προσκυνοῦντας αὐτόν, ἐν πνεύματι καὶ ἀληθείᾳ δεῖ προσκυνεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Λέγει αὐτῷ ἡ γυνή, Οἶδα ὅτι Μεσσίας ἔρχεται — ὁ λεγόμενος Χριστός· ὅταν ἔλθῃ ἐκεῖνος, ἀναγγελεῖ ἡμῖν πάντα. ");
INSERT INTO grctr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Λέγει αὐτῇ ὁ Ἰησοῦς, Ἐγώ εἰμι, ὁ λαλῶν σοι. ");
INSERT INTO grctr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Καὶ ἐπὶ τούτῳ ἦλθον οἱ μαθηταὶ αὐτοῦ, καὶ ἐθαύμασαν ὅτι μετὰ γυναικὸς ἐλάλει· οὐδεὶς μέντοι εἶπε, Τί ζητεῖς; ἤ, Τί λαλεῖς μετ᾿ αὐτῆς; ");
INSERT INTO grctr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ἀφῆκεν οὖν τὴν ὑδρίαν αὐτῆς ἡ γυνή, καὶ ἀπῆλθεν εἰς τὴν πόλιν, καὶ λέγει τοῖς ἀνθρώποις, ");
INSERT INTO grctr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Δεῦτε, ἴδετε ἄνθρωπον, ὃς εἶπέ μοι πάντα ὅσα ἐποίησα· μήτι οὗτός ἐστιν ὁ Χριστός; ");
INSERT INTO grctr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ἐξῆλθον οὖν ἐκ τῆς πόλεως, καὶ ἤρχοντο πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ἐν δὲ τῷ μεταξὺ ἠρώτων αὐτὸν οἱ μαθηταί, λέγοντες, Ῥαββί, φάγε. ");
INSERT INTO grctr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ὁ δὲ εἶπεν αὐτοῖς, Ἐγὼ βρῶσιν ἔχω φαγεῖν ἣν ὑμεῖς οὐκ οἴδατε. ");
INSERT INTO grctr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ἔλεγον οὖν οἱ μαθηταὶ πρὸς ἀλλήλους, Μή τις ἤνεγκεν αὐτῷ φαγεῖν; ");
INSERT INTO grctr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Λέγει αὐτοῖς ὁ Ἰησοῦς, Ἐμὸν βρῶμά ἐστιν, ἵνα ποιῶ τὸ θέλημα τοῦ πέμψαντός με, καὶ τελειώσω αὐτοῦ τὸ ἔργον. ");
INSERT INTO grctr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Οὐχ ὑμεῖς λέγετε ὅτι Ἔτι τετράμηνόν ἐστι, καὶ ὁ θερισμὸς ἔρχεται; Ἰδού, λέγω ὑμῖν, ἐπάρατε τοὺς ὀφθαλμοὺς ὑμῶν, καὶ θεάσασθε τὰς χώρας, ὅτι λευκαί εἰσι πρὸς θερισμὸν ἤδη. ");
INSERT INTO grctr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Καὶ ὁ θερίζων μισθὸν λαμβάνει, καὶ συνάγει καρπὸν εἰς ζωὴν αἰώνιον· ἵνα καὶ ὁ σπείρων ὁμοῦ χαίρῃ καὶ ὁ θερίζων. ");
INSERT INTO grctr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ἐν γὰρ τούτῳ ὁ λόγος ἐστὶν ὁ ἀληθινός, ὅτι Ἄλλος ἐστὶν ὁ σπείρων, καὶ ἄλλος ὁ θερίζων. ");
INSERT INTO grctr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ἐγὼ ἀπέστειλα ὑμᾶς θερίζειν ὃ οὐχ ὑμεῖς κεκοπιάκατε· ἄλλοι κεκοπιάκασι, καὶ ὑμεῖς εἰς τὸν κόπον αὐτῶν εἰσεληλύθατε. ");
INSERT INTO grctr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ἐκ δὲ τῆς πόλεως ἐκείνης πολλοὶ ἐπίστευσαν εἰς αὐτὸν τῶν Σαμαρειτῶν διὰ τὸν λόγον τῆς γυναικὸς μαρτυρούσης ὅτι Εἶπέ μοι πάντα ὅσα ἐποίησα. ");
INSERT INTO grctr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ὡς οὖν ἦλθον πρὸς αὐτὸν οἱ Σαμαρεῖται, ἠρώτων αὐτὸν μεῖναι παρ᾿ αὐτοῖς· καὶ ἔμεινεν ἐκεῖ δύο ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Καὶ πολλῷ πλείους ἐπίστευσαν διὰ τὸν λόγον αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","τῇ τε γυναικὶ ἔλεγον ὅτι Οὐκέτι διὰ τὴν σὴν λαλιὰν πιστεύομεν· αὐτοὶ γὰρ ἀκηκόαμεν, καὶ οἴδαμεν ὅτι οὗτός ἐστιν ἀληθῶς ὁ σωτὴρ τοῦ κόσμου, ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Μετὰ δὲ τὰς δύο ἡμέρας ἐξῆλθεν ἐκεῖθεν, καὶ ἀπῆλθεν εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grctr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Αὐτὸς γὰρ ὁ Ἰησοῦς ἐμαρτύρησεν ὅτι προφήτης ἐν τῇ ἰδίᾳ πατρίδι τιμὴν οὐκ ἔχει. ");
INSERT INTO grctr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ὅτε οὖν ἦλθεν εἰς τὴν Γαλιλαίαν, ἐδέξαντο αὐτὸν οἱ Γαλιλαῖοι, πάντα ἑωρακότες ἃ ἐποίησεν ἐν Ἱεροσολύμοις ἐν τῇ ἑορτῇ· καὶ αὐτοὶ γὰρ ἦλθον εἰς τὴν ἑορτήν. ");
INSERT INTO grctr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ἦλθεν οὖν ὁ Ἰησοῦς πάλιν εἰς τὴν Κανᾶ τῆς Γαλιλαίας, ὅπου ἐποίησε τὸ ὕδωρ οἶνον. Καὶ ἦν τις βασιλικός, οὗ ὁ υἱὸς ἠσθένει ἐν Καπερναούμ. ");
INSERT INTO grctr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Οὗτος ἀκούσας ὅτι Ἰησοῦς ἥκει ἐκ τῆς Ἰουδαίας εἰς τὴν Γαλιλαίαν, ἀπῆλθε πρὸς αὐτόν, καὶ ἠρώτα αὐτὸν ἵνα καταβῇ καὶ ἰάσηται αὐτοῦ τὸν υἱόν· ἤμελλε γὰρ ἀποθνῄσκειν. ");
INSERT INTO grctr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Εἶπεν οὖν ὁ Ἰησοῦς πρὸς αὐτόν, Ἐὰν μὴ σημεῖα καὶ τέρατα ἴδητε, οὐ μὴ πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Λέγει πρὸς αὐτὸν ὁ βασιλικός, Κύριε, κατάβηθι πρὶν ἀποθανεῖν τὸ παιδίον μου. ");
INSERT INTO grctr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Λέγει αὐτῷ ὁ Ἰησοῦς, Πορεύου· ὁ υἱός σου ζῇ. Καὶ ἐπίστευσεν ὁ ἄνθρωπος τῷ λόγῳ ᾧ εἶπεν αὐτῷ Ἰησοῦς, καὶ ἐπορεύετο. ");
INSERT INTO grctr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ἤδη δὲ αὐτοῦ καταβαίνοντος, οἱ δοῦλοι αὐτοῦ ἀπήντησαν αὐτῷ, καὶ ἀπήγγειλαν λέγοντες ὅτι Ὁ παῖς σου ζῇ. ");
INSERT INTO grctr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ἐπύθετο οὖν παρ᾿ αὐτῶν τὴν ὥραν ἐν ᾗ κομψότερον ἔσχε. Καὶ εἶπον αὐτῷ ὅτι Χθὲς ὥραν ἑβδόμην ἀφῆκεν αὐτὸν ὁ πυρετός. ");
INSERT INTO grctr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ἔγνω οὖν ὁ πατὴρ ὅτι ἐν ἐκείνῃ τῇ ὥρᾳ, ἐν ᾗ εἶπεν αὐτῷ ὁ Ἰησοῦς ὅτι Ὁ υἱός σου ζῇ· καὶ ἐπίστευσεν αὐτὸς καὶ ἡ οἰκία αὐτοῦ ὅλη. ");
INSERT INTO grctr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Τοῦτο πάλιν δεύτερον σημεῖον ἐποίησεν ὁ Ἰησοῦς, ἐλθὼν ἐκ τῆς Ἰουδαίας εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grctr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Μετὰ ταῦτα ἦν ἑορτὴ τῶν Ἰουδαίων, καὶ ἀνέβη ὁ Ἰησοῦς εἰς Ἱεροσόλυμα. ");
INSERT INTO grctr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ἔστι δὲ ἐν τοῖς Ἱεροσολύμοις ἐπὶ τῇ προβατικῇ κολυμβήθρα, ἡ ἐπιλεγομένη Ἑβραϊστὶ Βηθεσδά, πέντε στοὰς ἔχουσα. ");
INSERT INTO grctr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ἐν ταύταις κατέκειτο πλῆθος πολὺ τῶν ἀσθενούντων, τυφλῶν, χωλῶν, ξηρῶν, ἐκδεχομένων τὴν τοῦ ὕδατος κίνησιν. ");
INSERT INTO grctr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ἄγγελος γὰρ κατὰ καιρὸν κατέβαινεν ἐν τῇ κολυμβήθρᾳ, καὶ ἐτάρασσε τὸ ὕδωρ· ὁ οὖν πρῶτος ἐμβὰς μετὰ τὴν ταραχὴν τοῦ ὕδατος, ὑγιὴς ἐγίνετο, ᾧ δήποτε κατείχετο νοσήματι. ");
INSERT INTO grctr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ἦν δέ τις ἄνθρωπος ἐκεῖ τριακονταοκτὼ ἔτη ἔχων ἐν τῇ ἀσθενείᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Τοῦτον ἰδὼν ὁ Ἰησοῦς κατακείμενον, καὶ γνοὺς ὅτι πολὺν ἤδη χρόνον ἔχει, λέγει αὐτῷ, Θέλεις ὑγιὴς γενέσθαι; ");
INSERT INTO grctr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ἀπεκρίθη αὐτῷ ὁ ἀσθενῶν, Κύριε, ἄνθρωπον οὐκ ἔχω ἵνα, ὅταν ταραχθῇ τὸ ὕδωρ, βάλλῃ με εἰς τὴν κολυμβήθραν· ἐν ᾧ δὲ ἔρχομαι ἐγώ, ἄλλος πρὸ ἐμοῦ καταβαίνει. ");
INSERT INTO grctr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Λέγει αὐτῷ ὁ Ἰησοῦς, Ἔγειραι, ἆρον τὸν κράββατόν σου, καὶ περιπάτει. ");
INSERT INTO grctr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Καὶ εὐθέως ἐγένετο ὑγιὴς ὁ ἄνθρωπος, καὶ ἦρε τὸν κράββατον αὐτοῦ καὶ περιεπάτει. Ἦν δὲ σάββατον ἐν ἐκείνῃ τῇ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ἔλεγον οὖν οἱ Ἰουδαῖοι τῷ τεθεραπευμένῳ, Σάββατόν ἐστιν· οὐκ ἔξεστί σοι ἆραι τὸν κράββατον. ");
INSERT INTO grctr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ἀπεκρίθη αὐτοῖς, Ὁ ποιήσας με ὑγιῆ, ἐκεῖνός μοι εἶπεν, Ἆρον τὸν κράββατόν σου καὶ περιπάτει. ");
INSERT INTO grctr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ἠρώτησαν οὖν αὐτόν, Τίς ἐστιν ὁ ἄνθρωπος ὁ εἰπών σοι, Ἆρον τὸν κράββατόν σου καὶ περιπάτει; ");
INSERT INTO grctr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ὁ δὲ ἰαθεὶς οὐκ ᾔδει τίς ἐστιν· ὁ γὰρ Ἰησοῦς ἐξένευσεν, ὄχλου ὄντος ἐν τῷ τόπῳ. ");
INSERT INTO grctr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Μετὰ ταῦτα εὑρίσκει αὐτὸν ὁ Ἰησοῦς ἐν τῷ ἱερῷ, καὶ εἶπεν αὐτῷ, Ἴδε ὑγιὴς γέγονας· μηκέτι ἁμάρτανε, ἵνα μὴ χεῖρόν τί σοι γένηται. ");
INSERT INTO grctr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ἀπῆλθεν ὁ ἄνθρωπος, καὶ ἀνήγγειλε τοῖς Ἰουδαίοις ὅτι Ἰησοῦς ἐστιν ὁ ποιήσας αὐτὸν ὑγιῆ. ");
INSERT INTO grctr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Καὶ διὰ τοῦτο ἐδίωκον τὸν Ἰησοῦν οἱ Ἰουδαῖοι, καὶ ἐζήτουν αὐτὸν ἀποκτεῖναι, ὅτι ταῦτα ἐποίει ἐν σαββάτῳ. ");
INSERT INTO grctr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ὁ δὲ Ἰησοῦς ἀπεκρίνατο αὐτοῖς, Ὁ πατήρ μου ἕως ἄρτι ἐργάζεται, κἀγὼ ἐργάζομαι. ");
INSERT INTO grctr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Διὰ τοῦτο οὖν μᾶλλον ἐζήτουν αὐτὸν οἱ Ἰουδαῖοι ἀποκτεῖναι, ὅτι οὐ μόνον ἔλυε τὸ σάββατον, ἀλλὰ καὶ πατέρα ἴδιον ἔλεγε τὸν Θεόν, ἴσον ἑαυτὸν ποιῶν τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ἀπεκρίνατο οὖν ὁ Ἰησοῦς καὶ εἶπεν αὐτοῖς, Ἀμὴν ἀμὴν λέγω ὑμῖν, οὐ δύναται ὁ υἱὸς ποιεῖν ἀφ᾿ ἑαυτοῦ οὐδέν, ἐὰν μή τι βλέπῃ τὸν πατέρα ποιοῦντα· ἃ γὰρ ἂν ἐκεῖνος ποιῇ, ταῦτα καὶ ὁ υἱὸς ὁμοίως ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ὁ γὰρ πατὴρ φιλεῖ τὸν υἱόν, καὶ πάντα δείκνυσιν αὐτῷ ἃ αὐτὸς ποιεῖ· καὶ μείζονα τούτων δείξει αὐτῷ ἔργα, ἵνα ὑμεῖς θαυμάζητε. ");
INSERT INTO grctr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ὥσπερ γὰρ ὁ πατὴρ ἐγείρει τοὺς νεκροὺς καὶ ζῳοποιεῖ, οὕτω καὶ ὁ υἱὸς οὓς θέλει ζῳοποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Οὐδὲ γὰρ ὁ πατὴρ κρίνει οὐδένα, ἀλλὰ τὴν κρίσιν πᾶσαν δέδωκε τῷ υἱῷ· ");
INSERT INTO grctr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ἵνα πάντες τιμῶσι τὸν υἱόν, καθὼς τιμῶσι τὸν πατέρα. Ὁ μὴ τιμῶν τὸν υἱόν, οὐ τιμᾷ τὸν πατέρα τὸν πέμψαντα αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ὁ τὸν λόγον μου ἀκούων, καὶ πιστεύων τῷ πέμψαντί με, ἔχει ζωὴν αἰώνιον· καὶ εἰς κρίσιν οὐκ ἔρχεται, ἀλλὰ μεταβέβηκεν ἐκ τοῦ θανάτου εἰς τὴν ζωήν. ");
INSERT INTO grctr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ἔρχεται ὥρα καὶ νῦν ἐστιν, ὅτε οἱ νεκροὶ ἀκούσονται τῆς φωνῆς τοῦ υἱοῦ τοῦ Θεοῦ, καὶ οἱ ἀκούσαντες ζήσονται. ");
INSERT INTO grctr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ὥσπερ γὰρ ὁ πατὴρ ἔχει ζωὴν ἐν ἑαυτῷ, οὕτως ἔδωκε καὶ τῷ υἱῷ ζωὴν ἔχειν ἐν ἑαυτῷ· ");
INSERT INTO grctr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","καὶ ἐξουσίαν ἔδωκεν αὐτῷ καὶ κρίσιν ποιεῖν, ὅτι υἱὸς ἀνθρώπου ἐστί. ");
INSERT INTO grctr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Μὴ θαυμάζετε τοῦτο· ὅτι ἔρχεται ὥρα, ἐν ᾗ πάντες οἱ ἐν τοῖς μνημείοις ἀκούσονται τῆς φωνῆς αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","καὶ ἐκπορεύσονται, οἱ τὰ ἀγαθὰ ποιήσαντες, εἰς ἀνάστασιν ζωῆς· οἱ δὲ τὰ φαῦλα πράξαντες, εἰς ἀνάστασιν κρίσεως. ");
INSERT INTO grctr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Οὐ δύναμαι ἐγὼ ποιεῖν ἀπ᾿ ἐμαυτοῦ οὐδέν· καθὼς ἀκούω, κρίνω· καὶ ἡ κρίσις ἡ ἐμὴ δικαία ἐστίν· ὅτι οὐ ζητῶ τὸ θέλημα τὸ ἐμόν, ἀλλὰ τὸ θέλημα τοῦ πέμψαντός με πατρός. ");
INSERT INTO grctr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ἐὰν ἐγὼ μαρτυρῶ περὶ ἐμαυτοῦ, ἡ μαρτυρία μου οὐκ ἔστιν ἀληθής. ");
INSERT INTO grctr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ἄλλος ἐστὶν ὁ μαρτυρῶν περὶ ἐμοῦ, καὶ οἶδα ὅτι ἀληθής ἐστιν ἡ μαρτυρία ἣν μαρτυρεῖ περὶ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ὑμεῖς ἀπεστάλκατε πρὸς Ἰωάννην, καὶ μεμαρτύρηκε τῇ ἀληθείᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ἐγὼ δὲ οὐ παρὰ ἀνθρώπου τὴν μαρτυρίαν λαμβάνω, ἀλλὰ ταῦτα λέγω ἵνα ὑμεῖς σωθῆτε. ");
INSERT INTO grctr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ἐκεῖνος ἦν ὁ λύχνος ὁ καιόμενος καὶ φαίνων, ὑμεῖς δὲ ἠθελήσατε ἀγαλλιασθῆναι πρὸς ὥραν ἐν τῷ φωτὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ἐγὼ δὲ ἔχω τὴν μαρτυρίαν μείζω τοῦ Ἰωάννου· τὰ γὰρ ἔργα ἃ ἔδωκέ μοι ὁ πατὴρ ἵνα τελειώσω αὐτά, αὐτὰ τὰ ἔργα ἃ ἐγὼ ποιῶ, μαρτυρεῖ περὶ ἐμοῦ ὅτι ὁ πατήρ με ἀπέσταλκε. ");
INSERT INTO grctr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Καὶ ὁ πέμψας με πατήρ, αὐτὸς μεμαρτύρηκε περὶ ἐμοῦ. Οὔτε φωνὴν αὐτοῦ ἀκηκόατε πώποτε, οὔτε εἶδος αὐτοῦ ἑωράκατε. ");
INSERT INTO grctr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Καὶ τὸν λόγον αὐτοῦ οὐκ ἔχετε μένοντα ἐν ὑμῖν, ὅτι ὃν ἀπέστειλεν ἐκεῖνος, τούτῳ ὑμεῖς οὐ πιστεύετε. ");
INSERT INTO grctr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ἐρευνᾶτε τὰς γραφάς, ὅτι ὑμεῖς δοκεῖτε ἐν αὐταῖς ζωὴν αἰώνιον ἔχειν, καὶ ἐκεῖναί εἰσιν αἱ μαρτυροῦσαι περὶ ἐμοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","καὶ οὐ θέλετε ἐλθεῖν πρός με, ἵνα ζωὴν ἔχητε. ");
INSERT INTO grctr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Δόξαν παρὰ ἀνθρώπων οὐ λαμβάνω· ");
INSERT INTO grctr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ἀλλ᾿ ἔγνωκα ὑμᾶς, ὅτι τὴν ἀγάπην τοῦ Θεοῦ οὐκ ἔχετε ἐν ἑαυτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ἐγὼ ἐλήλυθα ἐν τῷ ὀνόματι τοῦ πατρός μου, καὶ οὐ λαμβάνετέ με· ἐὰν ἄλλος ἔλθῃ ἐν τῷ ὀνόματι τῷ ἰδίῳ, ἐκεῖνον λήψεσθε. ");
INSERT INTO grctr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Πῶς δύνασθε ὑμεῖς πιστεῦσαι, δόξαν παρὰ ἀλλήλων λαμβάνοντες, καὶ τὴν δόξαν τὴν παρὰ τοῦ μόνου Θεοῦ οὐ ζητεῖτε; ");
INSERT INTO grctr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Μὴ δοκεῖτε ὅτι ἐγὼ κατηγορήσω ὑμῶν πρὸς τὸν πατέρα· ἔστιν ὁ κατηγορῶν ὑμῶν, Μωσῆς, εἰς ὃν ὑμεῖς ἠλπίκατε. ");
INSERT INTO grctr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Εἰ γὰρ ἐπιστεύετε Μωσῇ, ἐπιστεύετε ἂν ἐμοί· περὶ γὰρ ἐμοῦ ἐκεῖνος ἔγραψεν. ");
INSERT INTO grctr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Εἰ δὲ τοῖς ἐκείνου γράμμασιν οὐ πιστεύετε, πῶς τοῖς ἐμοῖς ῥήμασι πιστεύσετε; ");
INSERT INTO grctr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Μετὰ ταῦτα ἀπῆλθεν ὁ Ἰησοῦς πέραν τῆς θαλάσσης τῆς Γαλιλαίας, τῆς Τιβεριάδος. ");
INSERT INTO grctr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Καὶ ἠκολούθει αὐτῷ ὄχλος πολύς, ὅτι ἑώρων αὐτοῦ τὰ σημεῖα ἃ ἐποίει ἐπὶ τῶν ἀσθενούντων. ");
INSERT INTO grctr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ἀνῆλθε δὲ εἰς τὸ ὄρος ὁ Ἰησοῦς, καὶ ἐκεῖ ἐκάθητο μετὰ τῶν μαθητῶν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ἦν δὲ ἐγγὺς τὸ Πάσχα, ἡ ἑορτὴ τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ἐπάρας οὖν ὁ Ἰησοῦς τοὺς ὀφθαλμούς, καὶ θεασάμενος ὅτι πολὺς ὄχλος ἔρχεται πρὸς αὐτόν, λέγει πρὸς τὸν Φίλιππον, Πόθεν ἀγοράσομεν ἄρτους, ἵνα φάγωσιν οὗτοι; ");
INSERT INTO grctr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Τοῦτο δὲ ἔλεγε πειράζων αὐτόν· αὐτὸς γὰρ ᾔδει τί ἔμελλε ποιεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ἀπεκρίθη αὐτῷ Φίλιππος, Διακοσίων δηναρίων ἄρτοι οὐκ ἀρκοῦσιν αὐτοῖς, ἵνα ἕκαστος αὐτῶν βραχύ τι λάβῃ. ");
INSERT INTO grctr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Λέγει αὐτῷ εἷς ἐκ τῶν μαθητῶν αὐτοῦ, Ἀνδρέας ὁ ἀδελφὸς Σίμωνος Πέτρου, ");
INSERT INTO grctr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ἔστι παιδάριον ἓν ὧδε, ὃ ἔχει πέντε ἄρτους κριθίνους καὶ δύο ὀψάρια· ἀλλὰ ταῦτα τί ἐστιν εἰς τοσούτους; ");
INSERT INTO grctr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Εἶπε δὲ ὁ Ἰησοῦς, Ποιήσατε τοὺς ἀνθρώπους ἀναπεσεῖν. Ἦν δὲ χόρτος πολὺς ἐν τῷ τόπῳ. Ἀνέπεσον οὖν οἱ ἄνδρες τὸν ἀριθμὸν ὡσεὶ πεντακισχίλιοι. ");
INSERT INTO grctr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ἔλαβε δὲ τοὺς ἄρτους ὁ Ἰησοῦς, καὶ εὐχαριστήσας διέδωκε τοῖς μαθηταῖς, οἱ δὲ μαθηταὶ τοῖς ἀνακειμένοις· ὁμοίως καὶ ἐκ τῶν ὀψαρίων ὅσον ἤθελον. ");
INSERT INTO grctr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ὡς δὲ ἐνεπλήσθησαν, λέγει τοῖς μαθηταῖς αὐτοῦ, Συναγάγετε τὰ περισσεύσαντα κλάσματα, ἵνα μή τι ἀπόληται. ");
INSERT INTO grctr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Συνήγαγον οὖν, καὶ ἐγέμισαν δώδεκα κοφίνους κλασμάτων ἐκ τῶν πέντε ἄρτων τῶν κριθίνων, ἃ ἐπερίσσευσε τοῖς βεβρωκόσιν. ");
INSERT INTO grctr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Οἱ οὖν ἄνθρωποι ἰδόντες ὃ ἐποίησε σημεῖον ὁ Ἰησοῦς, ἔλεγον ὅτι Οὗτός ἐστιν ἀληθῶς ὁ προφήτης ὁ ἐρχόμενος εἰς τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ἰησοῦς οὖν γνοὺς ὅτι μέλλουσιν ἔρχεσθαι καὶ ἁρπάζειν αὐτόν, ἵνα ποιήσωσιν αὐτὸν βασιλέα, ἀνεχώρησε πάλιν εἰς τὸ ὄρος αὐτὸς μόνος. ");
INSERT INTO grctr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ὡς δὲ ὀψία ἐγένετο, κατέβησαν οἱ μαθηταὶ αὐτοῦ ἐπὶ τὴν θάλασσαν, ");
INSERT INTO grctr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","καὶ ἐμβάντες εἰς τὸ πλοῖον, ἤρχοντο πέραν τῆς θαλάσσης εἰς Καπερναούμ. Καὶ σκοτία ἤδη ἐγεγόνει, καὶ οὐκ ἐληλύθει πρὸς αὐτοὺς ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ἥ τε θάλασσα ἀνέμου μεγάλου πνέοντος διηγείρετο. ");
INSERT INTO grctr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ἐληλακότες οὖν ὡς σταδίους εἴκοσι πέντε ἢ τριάκοντα, θεωροῦσι τὸν Ἰησοῦν περιπατοῦντα ἐπὶ τῆς θαλάσσης, καὶ ἐγγὺς τοῦ πλοίου γινόμενον· καὶ ἐφοβήθησαν. ");
INSERT INTO grctr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ὁ δὲ λέγει αὐτοῖς, Ἐγώ εἰμι· μὴ φοβεῖσθε. ");
INSERT INTO grctr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ἤθελον οὖν λαβεῖν αὐτὸν εἰς τὸ πλοῖον· καὶ εὐθέως τὸ πλοῖον ἐγένετο ἐπὶ τῆς γῆς εἰς ἣν ὑπῆγον. ");
INSERT INTO grctr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Τῇ ἐπαύριον ὁ ὄχλος ὁ ἑστηκὼς πέραν τῆς θαλάσσης, ἰδὼν ὅτι πλοιάριον ἄλλο οὐκ ἦν ἐκεῖ εἰ μὴ ἓν ἐκεῖνο εἰς ὃ ἐνέβησαν οἱ μαθηταὶ αὐτοῦ, καὶ ὅτι οὐ συνεισῆλθε τοῖς μαθηταῖς αὐτοῦ ὁ Ἰησοῦς εἰς τὸ πλοιάριον, ἀλλὰ μόνοι οἱ μαθηταὶ αὐτοῦ ἀπῆλθον — ");
INSERT INTO grctr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ἄλλα δὲ ἦλθε πλοιάρια ἐκ Τιβεριάδος ἐγγὺς τοῦ τόπου ὅπου ἔφαγον τὸν ἄρτον, εὐχαριστήσαντος τοῦ Κυρίου — ");
INSERT INTO grctr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ὅτε οὖν εἶδεν ὁ ὄχλος ὅτι Ἰησοῦς οὐκ ἔστιν ἐκεῖ οὐδὲ οἱ μαθηταὶ αὐτοῦ, ἐνέβησαν καὶ αὐτοὶ εἰς τὰ πλοῖα, καὶ ἦλθον εἰς Καπερναούμ, ζητοῦντες τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Καὶ εὑρόντες αὐτὸν πέραν τῆς θαλάσσης, εἶπον αὐτῷ, Ῥαββί, πότε ὧδε γέγονας; ");
INSERT INTO grctr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς καὶ εἶπεν, Ἀμὴν ἀμὴν λέγω ὑμῖν, ζητεῖτέ με, οὐχ ὅτι εἴδετε σημεῖα, ἀλλ᾿ ὅτι ἐφάγετε ἐκ τῶν ἄρτων καὶ ἐχορτάσθητε. ");
INSERT INTO grctr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ἐργάζεσθε μὴ τὴν βρῶσιν τὴν ἀπολλυμένην, ἀλλὰ τὴν βρῶσιν τὴν μένουσαν εἰς ζωὴν αἰώνιον, ἣν ὁ υἱὸς τοῦ ἀνθρώπου ὑμῖν δώσει· τοῦτον γὰρ ὁ πατὴρ ἐσφράγισεν, ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Εἶπον οὖν πρὸς αὐτόν, Τί ποιῶμεν, ἵνα ἐργαζώμεθα τὰ ἔργα τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτοῖς, Τοῦτό ἐστι τὸ ἔργον τοῦ Θεοῦ, ἵνα πιστεύσητε εἰς ὃν ἀπέστειλεν ἐκεῖνος. ");
INSERT INTO grctr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Εἶπον οὖν αὐτῷ, Τί οὖν ποιεῖς σὺ σημεῖον, ἵνα ἴδωμεν καὶ πιστεύσωμέν σοι; Τί ἐργάζῃ; ");
INSERT INTO grctr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Οἱ πατέρες ἡμῶν τὸ μάννα ἔφαγον ἐν τῇ ἐρήμῳ, καθώς ἐστι γεγραμμένον, Ἄρτον ἐκ τοῦ οὐρανοῦ ἔδωκεν αὐτοῖς φαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω ὑμῖν, οὐ Μωσῆς δέδωκεν ὑμῖν τὸν ἄρτον ἐκ τοῦ οὐρανοῦ· ἀλλ᾿ ὁ πατήρ μου δίδωσιν ὑμῖν τὸν ἄρτον ἐκ τοῦ οὐρανοῦ τὸν ἀληθινόν. ");
INSERT INTO grctr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ὁ γὰρ ἄρτος τοῦ Θεοῦ ἐστιν ὁ καταβαίνων ἐκ τοῦ οὐρανοῦ καὶ ζωὴν διδοὺς τῷ κόσμῳ. ");
INSERT INTO grctr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Εἶπον οὖν πρὸς αὐτόν, Κύριε, πάντοτε δὸς ἡμῖν τὸν ἄρτον τοῦτον. ");
INSERT INTO grctr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Εἶπε δὲ αὐτοῖς ὁ Ἰησοῦς, Ἐγώ εἰμι ὁ ἄρτος τῆς ζωῆς· ὁ ἐρχόμενος πρός με οὐ μὴ πεινάσῃ· καὶ ὁ πιστεύων εἰς ἐμὲ οὐ μὴ διψήσῃ πώποτε. ");
INSERT INTO grctr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ἀλλ᾿ εἶπον ὑμῖν ὅτι καὶ ἑωράκατέ με, καὶ οὐ πιστεύετε. ");
INSERT INTO grctr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Πᾶν ὃ δίδωσί μοι ὁ πατὴρ πρὸς ἐμὲ ἥξει· καὶ τὸν ἐρχόμενον πρός με οὐ μὴ ἐκβάλω ἔξω. ");
INSERT INTO grctr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ὅτι καταβέβηκα ἐκ τοῦ οὐρανοῦ, οὐχ ἵνα ποιῶ τὸ θέλημα τὸ ἐμόν, ἀλλὰ τὸ θέλημα τοῦ πέμψαντός με. ");
INSERT INTO grctr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Τοῦτο δέ ἐστι τὸ θέλημα τοῦ πέμψαντός με πατρός, ἵνα πᾶν ὃ δέδωκέ μοι, μὴ ἀπολέσω ἐξ αὐτοῦ, ἀλλὰ ἀναστήσω αὐτὸ ἐν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Τοῦτο δέ ἐστι τὸ θέλημα τοῦ πέμψαντός με, ἵνα πᾶς ὁ θεωρῶν τὸν υἱὸν καὶ πιστεύων εἰς αὐτόν, ἔχῃ ζωὴν αἰώνιον, καὶ ἀναστήσω αὐτὸν ἐγὼ τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ἐγόγγυζον οὖν οἱ Ἰουδαῖοι περὶ αὐτοῦ, ὅτι εἶπεν, Ἐγώ εἰμι ὁ ἄρτος ὁ καταβὰς ἐκ τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Καὶ ἔλεγον, Οὐχ οὗτός ἐστιν Ἰησοῦς ὁ υἱὸς Ἰωσήφ, οὗ ἡμεῖς οἴδαμεν τὸν πατέρα καὶ τὴν μητέρα; Πῶς οὖν λέγει οὗτος ὅτι Ἐκ τοῦ οὐρανοῦ καταβέβηκα; ");
INSERT INTO grctr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ἀπεκρίθη οὖν ὁ Ἰησοῦς καὶ εἶπεν αὐτοῖς, Μὴ γογγύζετε μετ᾿ ἀλλήλων. ");
INSERT INTO grctr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Οὐδεὶς δύναται ἐλθεῖν πρός με, ἐὰν μὴ ὁ πατὴρ ὁ πέμψας με ἑλκύσῃ αὐτόν, καὶ ἐγὼ ἀναστήσω αὐτὸν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ἔστι γεγραμμένον ἐν τοῖς προφήταις, Καὶ ἔσονται πάντες διδακτοὶ τοῦ Θεοῦ. Πᾶς οὖν ὁ ἀκούσας παρὰ τοῦ πατρὸς καὶ μαθών, ἔρχεται πρός με. ");
INSERT INTO grctr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Οὐχ ὅτι τὸν πατέρα τις ἑώρακεν, εἰ μὴ ὁ ὢν παρὰ τοῦ Θεοῦ, οὗτος ἑώρακε τὸν πατέρα. ");
INSERT INTO grctr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ πιστεύων εἰς ἐμέ, ἔχει ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ἐγώ εἰμι ὁ ἄρτος τῆς ζωῆς. ");
INSERT INTO grctr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Οἱ πατέρες ὑμῶν ἔφαγον τὸ μάννα ἐν τῇ ἐρήμῳ, καὶ ἀπέθανον. ");
INSERT INTO grctr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Οὗτός ἐστιν ὁ ἄρτος ὁ ἐκ τοῦ οὐρανοῦ καταβαίνων, ἵνα τις ἐξ αὐτοῦ φάγῃ καὶ μὴ ἀποθάνῃ. ");
INSERT INTO grctr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ἐγώ εἰμι ὁ ἄρτος ὁ ζῶν, ὁ ἐκ τοῦ οὐρανοῦ καταβάς· ἐάν τις φάγῃ ἐκ τούτου τοῦ ἄρτου, ζήσεται εἰς τὸν αἰῶνα. Καὶ ὁ ἄρτος δὲ ὃν ἐγὼ δώσω, ἡ σάρξ μου ἐστίν, ἣν ἐγὼ δώσω ὑπὲρ τῆς τοῦ κόσμου ζωῆς. ");
INSERT INTO grctr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ἐμάχοντο οὖν πρὸς ἀλλήλους οἱ Ἰουδαῖοι λέγοντες, Πῶς δύναται οὗτος ἡμῖν δοῦναι τὴν σάρκα φαγεῖν; ");
INSERT INTO grctr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω ὑμῖν, ἐὰν μὴ φάγητε τὴν σάρκα τοῦ υἱοῦ τοῦ ἀνθρώπου καὶ πίητε αὐτοῦ τὸ αἷμα, οὐκ ἔχετε ζωὴν ἐν ἑαυτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ὁ τρώγων μου τὴν σάρκα καὶ πίνων μου τὸ αἷμα, ἔχει ζωὴν αἰώνιον, καὶ ἐγὼ ἀναστήσω αὐτὸν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ἡ γὰρ σάρξ μου ἀληθῶς ἐστι βρῶσις, καὶ τὸ αἷμά μου ἀληθῶς ἐστι πόσις. ");
INSERT INTO grctr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ὁ τρώγων μου τὴν σάρκα καὶ πίνων μου τὸ αἷμα, ἐν ἐμοὶ μένει, κἀγὼ ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Καθὼς ἀπέστειλέ με ὁ ζῶν πατήρ, κἀγὼ ζῶ διὰ τὸν πατέρα· καὶ ὁ τρώγων με, κἀκεῖνος ζήσεται δι᾿ ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Οὗτός ἐστιν ὁ ἄρτος ὁ ἐκ τοῦ οὐρανοῦ καταβάς· οὐ καθὼς ἔφαγον οἱ πατέρες ὑμῶν τὸ μάννα, καὶ ἀπέθανον· ὁ τρώγων τοῦτον τὸν ἄρτον, ζήσεται εἰς τὸν αἰῶνα. ");
INSERT INTO grctr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ταῦτα εἶπεν ἐν συναγωγῇ διδάσκων ἐν Καπερναούμ. ");
INSERT INTO grctr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Πολλοὶ οὖν ἀκούσαντες ἐκ τῶν μαθητῶν αὐτοῦ εἶπον, Σκληρός ἐστιν οὗτος ὁ λόγος· τίς δύναται αὐτοῦ ἀκούειν; ");
INSERT INTO grctr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Εἰδὼς δὲ ὁ Ἰησοῦς ἐν ἑαυτῷ ὅτι γογγύζουσι περὶ τούτου οἱ μαθηταὶ αὐτοῦ, εἶπεν αὐτοῖς, Τοῦτο ὑμᾶς σκανδαλίζει; ");
INSERT INTO grctr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ἐὰν οὖν θεωρῆτε τὸν υἱὸν τοῦ ἀνθρώπου ἀναβαίνοντα ὅπου ἦν τὸ πρότερον; ");
INSERT INTO grctr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Τὸ πνεῦμά ἐστι τὸ ζῳοποιοῦν, ἡ σὰρξ οὐκ ὠφελεῖ οὐδέν· τὰ ῥήματα ἃ ἐγὼ λαλῶ ὑμῖν, πνεῦμά ἐστι καὶ ζωή ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ἀλλ᾿ εἰσὶν ἐξ ὑμῶν τινες οἳ οὐ πιστεύουσιν. ᾜδει γὰρ ἐξ ἀρχῆς ὁ Ἰησοῦς, τίνες εἰσὶν οἱ μὴ πιστεύοντες, καὶ τίς ἐστιν ὁ παραδώσων αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Καὶ ἔλεγε, Διὰ τοῦτο εἴρηκα ὑμῖν ὅτι οὐδεὶς δύναται ἐλθεῖν πρός με, ἐὰν μὴ ᾖ δεδομένον αὐτῷ ἐκ τοῦ πατρός μου. ");
INSERT INTO grctr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ἐκ τούτου πολλοὶ ἀπῆλθον τῶν μαθητῶν αὐτοῦ εἰς τὰ ὀπίσω, καὶ οὐκέτι μετ᾿ αὐτοῦ περιεπάτουν. ");
INSERT INTO grctr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Εἶπεν οὖν ὁ Ἰησοῦς τοῖς δώδεκα, Μὴ καὶ ὑμεῖς θέλετε ὑπάγειν; ");
INSERT INTO grctr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ἀπεκρίθη οὖν αὐτῷ Σίμων Πέτρος, Κύριε, πρὸς τίνα ἀπελευσόμεθα; Ῥήματα ζωῆς αἰωνίου ἔχεις. ");
INSERT INTO grctr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Καὶ ἡμεῖς πεπιστεύκαμεν καὶ ἐγνώκαμεν ὅτι σὺ εἶ ὁ Χριστὸς ὁ υἱὸς τοῦ Θεοῦ τοῦ ζῶντος. ");
INSERT INTO grctr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Οὐκ ἐγὼ ὑμᾶς τοὺς δώδεκα ἐξελεξάμην, καὶ ἐξ ὑμῶν εἷς διάβολός ἐστιν; ");
INSERT INTO grctr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ἔλεγε δὲ τὸν Ἰούδαν Σίμωνος Ἰσκαριώτην· οὗτος γὰρ ἤμελλεν αὐτὸν παραδιδόναι, εἷς ὢν ἐκ τῶν δώδεκα. ");
INSERT INTO grctr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Καὶ περιεπάτει ὁ Ἰησοῦς μετὰ ταῦτα ἐν τῇ Γαλιλαίᾳ· οὐ γὰρ ἤθελεν ἐν τῇ Ἰουδαίᾳ περιπατεῖν, ὅτι ἐζήτουν αὐτὸν οἱ Ἰουδαῖοι ἀποκτεῖναι. ");
INSERT INTO grctr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ἦν δὲ ἐγγὺς ἡ ἑορτὴ τῶν Ἰουδαίων ἡ Σκηνοπηγία. ");
INSERT INTO grctr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Εἶπον οὖν πρὸς αὐτὸν οἱ ἀδελφοὶ αὐτοῦ, Μετάβηθι ἐντεῦθεν, καὶ ὕπαγε εἰς τὴν Ἰουδαίαν, ἵνα καὶ οἱ μαθηταί σου θεωρήσωσι τὰ ἔργα σου ἃ ποιεῖς. ");
INSERT INTO grctr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Οὐδεὶς γὰρ ἐν κρυπτῷ τι ποιεῖ, καὶ ζητεῖ αὐτὸς ἐν παρρησίᾳ εἶναι. Εἰ ταῦτα ποιεῖς, φανέρωσον σεαυτὸν τῷ κόσμῳ. ");
INSERT INTO grctr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Οὐδὲ γὰρ οἱ ἀδελφοὶ αὐτοῦ ἐπίστευον εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Λέγει οὖν αὐτοῖς ὁ Ἰησοῦς, Ὁ καιρὸς ὁ ἐμὸς οὔπω πάρεστιν, ὁ δὲ καιρὸς ὁ ὑμέτερος πάντοτέ ἐστιν ἕτοιμος. ");
INSERT INTO grctr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Οὐ δύναται ὁ κόσμος μισεῖν ὑμᾶς· ἐμὲ δὲ μισεῖ, ὅτι ἐγὼ μαρτυρῶ περὶ αὐτοῦ, ὅτι τὰ ἔργα αὐτοῦ πονηρά ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ὑμεῖς ἀνάβητε εἰς τὴν ἑορτὴν ταύτην· ἐγὼ οὔπω ἀναβαίνω εἰς τὴν ἑορτὴν ταύτην, ὅτι ὁ καιρὸς ὁ ἐμὸς οὔπω πεπλήρωται. ");
INSERT INTO grctr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ταῦτα δὲ εἰπὼν αὐτοῖς, ἔμεινεν ἐν τῇ Γαλιλαίᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ὡς δὲ ἀνέβησαν οἱ ἀδελφοὶ αὐτοῦ, τότε καὶ αὐτὸς ἀνέβη εἰς τὴν ἑορτήν, οὐ φανερῶς, ἀλλ᾿ ὡς ἐν κρυπτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Οἱ οὖν Ἰουδαῖοι ἐζήτουν αὐτὸν ἐν τῇ ἑορτῇ, καὶ ἔλεγον, Ποῦ ἐστιν ἐκεῖνος; ");
INSERT INTO grctr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Καὶ γογγυσμὸς πολὺς περὶ αὐτοῦ ἦν ἐν τοῖς ὄχλοις· οἱ μὲν ἔλεγον ὅτι Ἀγαθός ἐστιν· ἄλλοι δὲ ἔλεγον, Οὔ, ἀλλὰ πλανᾷ τὸν ὄχλον. ");
INSERT INTO grctr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Οὐδεὶς μέντοι παρρησίᾳ ἐλάλει περὶ αὐτοῦ διὰ τὸν φόβον τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ἤδη δὲ τῆς ἑορτῆς μεσούσης, ἀνέβη ὁ Ἰησοῦς εἰς τὸ ἱερόν, καὶ ἐδίδασκε. ");
INSERT INTO grctr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Καὶ ἐθαύμαζον οἱ Ἰουδαῖοι λέγοντες, Πῶς οὗτος γράμματα οἶδε, μὴ μεμαθηκώς; ");
INSERT INTO grctr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς καὶ εἶπεν, Ἡ ἐμὴ διδαχὴ οὐκ ἔστιν ἐμή, ἀλλὰ τοῦ πέμψαντός με. ");
INSERT INTO grctr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ἐάν τις θέλῃ τὸ θέλημα αὐτοῦ ποιεῖν, γνώσεται περὶ τῆς διδαχῆς, πότερον ἐκ τοῦ Θεοῦ ἐστιν, ἢ ἐγὼ ἀπ᾿ ἐμαυτοῦ λαλῶ. ");
INSERT INTO grctr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ὁ ἀφ᾿ ἑαυτοῦ λαλῶν, τὴν δόξαν τὴν ἰδίαν ζητεῖ· ὁ δὲ ζητῶν τὴν δόξαν τοῦ πέμψαντος αὐτόν, οὗτος ἀληθής ἐστι, καὶ ἀδικία ἐν αὐτῷ οὐκ ἔστιν. ");
INSERT INTO grctr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Οὐ Μωσῆς δέδωκεν ὑμῖν τὸν νόμον, καὶ οὐδεὶς ἐξ ὑμῶν ποιεῖ τὸν νόμον; Τί με ζητεῖτε ἀποκτεῖναι; ");
INSERT INTO grctr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ἀπεκρίθη ὁ ὄχλος καὶ εἶπε, Δαιμόνιον ἔχεις· τίς σε ζητεῖ ἀποκτεῖναι; ");
INSERT INTO grctr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτοῖς, Ἓν ἔργον ἐποίησα, καὶ πάντες θαυμάζετε. ");
INSERT INTO grctr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Διὰ τοῦτο Μωσῆς δέδωκεν ὑμῖν τὴν περιτομήν — οὐχ ὅτι ἐκ τοῦ Μωσέως ἐστίν, ἀλλ᾿ ἐκ τῶν πατέρων — καὶ ἐν σαββάτῳ περιτέμνετε ἄνθρωπον. ");
INSERT INTO grctr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Εἰ περιτομὴν λαμβάνει ἄνθρωπος ἐν σαββάτῳ, ἵνα μὴ λυθῇ ὁ νόμος Μωσέως, ἐμοὶ χολᾶτε ὅτι ὅλον ἄνθρωπον ὑγιῆ ἐποίησα ἐν σαββάτῳ; ");
INSERT INTO grctr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Μὴ κρίνετε κατ᾿ ὄψιν, ἀλλὰ τὴν δικαίαν κρίσιν κρίνατε. ");
INSERT INTO grctr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ἔλεγον οὖν τινες ἐκ τῶν Ἱεροσολυμιτῶν, Οὐχ οὗτός ἐστιν ὃν ζητοῦσιν ἀποκτεῖναι; ");
INSERT INTO grctr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Καὶ ἴδε παρρησίᾳ λαλεῖ, καὶ οὐδὲν αὐτῷ λέγουσι. Μήποτε ἀληθῶς ἔγνωσαν οἱ ἄρχοντες ὅτι οὗτός ἐστιν ἀληθῶς ὁ Χριστός; ");
INSERT INTO grctr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ἀλλὰ τοῦτον οἴδαμεν πόθεν ἐστίν· ὁ δὲ Χριστὸς ὅταν ἔρχηται, οὐδεὶς γινώσκει πόθεν ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ἔκραξεν οὖν ἐν τῷ ἱερῷ διδάσκων ὁ Ἰησοῦς καὶ λέγων, Κἀμὲ οἴδατε, καὶ οἴδατε πόθεν εἰμί· καὶ ἀπ᾿ ἐμαυτοῦ οὐκ ἐλήλυθα, ἀλλ᾿ ἔστιν ἀληθινὸς ὁ πέμψας με, ὃν ὑμεῖς οὐκ οἴδατε. ");
INSERT INTO grctr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ἐγὼ δὲ οἶδα αὐτόν, ὅτι παρ᾿ αὐτοῦ εἰμι, κἀκεῖνός με ἀπέστειλεν. ");
INSERT INTO grctr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ἐζήτουν οὖν αὐτὸν πιάσαι. Καὶ οὐδεὶς ἐπέβαλεν ἐπ᾿ αὐτὸν τὴν χεῖρα, ὅτι οὔπω ἐληλύθει ἡ ὥρα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Πολλοὶ δὲ ἐκ τοῦ ὄχλου ἐπίστευσαν εἰς αὐτόν, καὶ ἔλεγον ὅτι Ὁ Χριστὸς ὅταν ἔλθῃ, μήτι πλείονα σημεῖα τούτων ποιήσει ὧν οὗτος ἐποίησεν; ");
INSERT INTO grctr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ἤκουσαν οἱ Φαρισαῖοι τοῦ ὄχλου γογγύζοντος περὶ αὐτοῦ ταῦτα· καὶ ἀπέστειλαν οἱ Φαρισαῖοι καὶ οἱ ἀρχιερεῖς ὑπηρέτας ἵνα πιάσωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Ἔτι μικρὸν χρόνον μεθ᾿ ὑμῶν εἰμι, καὶ ὑπάγω πρὸς τὸν πέμψαντά με. ");
INSERT INTO grctr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ζητήσετέ με, καὶ οὐχ εὑρήσετε· καὶ ὅπου εἰμὶ ἐγώ, ὑμεῖς οὐ δύνασθε ἐλθεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Εἶπον οὖν οἱ Ἰουδαῖοι πρὸς ἑαυτούς, Ποῦ οὗτος μέλλει πορεύεσθαι ὅτι ἡμεῖς οὐχ εὑρήσομεν αὐτόν; Μὴ εἰς τὴν διασπορὰν τῶν Ἑλλήνων μέλλει πορεύεσθαι, καὶ διδάσκειν τοὺς Ἕλληνας; ");
INSERT INTO grctr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Τίς ἐστιν οὗτος ὁ λόγος ὃν εἶπε, Ζητήσετέ με, καὶ οὐχ εὑρήσετε· καὶ ὅπου εἰμὶ ἐγώ, ὑμεῖς οὐ δύνασθε ἐλθεῖν; ");
INSERT INTO grctr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ἐν δὲ τῇ ἐσχάτῃ ἡμέρᾳ τῇ μεγάλῃ τῆς ἑορτῆς εἱστήκει ὁ Ἰησοῦς καὶ ἔκραξε, λέγων, Ἐάν τις διψᾷ, ἐρχέσθω πρός με καὶ πινέτω. ");
INSERT INTO grctr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ὁ πιστεύων εἰς ἐμέ, καθὼς εἶπεν ἡ γραφή, ποταμοὶ ἐκ τῆς κοιλίας αὐτοῦ ῥεύσουσιν ὕδατος ζῶντος. ");
INSERT INTO grctr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Τοῦτο δὲ εἶπε περὶ τοῦ πνεύματος οὗ ἔμελλον λαμβάνειν οἱ πιστεύοντες εἰς αὐτόν· οὔπω γὰρ ἦν πνεῦμα ἅγιον, ὅτι ὁ Ἰησοῦς οὐδέπω ἐδοξάσθη. ");
INSERT INTO grctr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Πολλοὶ οὖν ἐκ τοῦ ὄχλου ἀκούσαντες τὸν λόγον ἔλεγον, Οὗτός ἐστιν ἀληθῶς ὁ προφήτης. ");
INSERT INTO grctr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ἄλλοι ἔλεγον, Οὗτός ἐστιν ὁ Χριστός. Ἄλλοι δὲ ἔλεγον, Μὴ γὰρ ἐκ τῆς Γαλιλαίας ὁ Χριστὸς ἔρχεται; ");
INSERT INTO grctr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Οὐχὶ ἡ γραφὴ εἶπεν ὅτι ἐκ τοῦ σπέρματος Δαβίδ, καὶ ἀπὸ Βηθλεέμ, τῆς κώμης ὅπου ἦν Δαβίδ, ὁ Χριστὸς ἔρχεται; ");
INSERT INTO grctr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Σχίσμα οὖν ἐν τῷ ὄχλῳ ἐγένετο δι᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Τινὲς δὲ ἤθελον ἐξ αὐτῶν πιάσαι αὐτόν, ἀλλ᾿ οὐδεὶς ἐπέβαλεν ἐπ᾿ αὐτὸν τὰς χεῖρας. ");
INSERT INTO grctr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ἦλθον οὖν οἱ ὑπηρέται πρὸς τοὺς ἀρχιερεῖς καὶ Φαρισαίους· καὶ εἶπον αὐτοῖς ἐκεῖνοι, Διὰ τί οὐκ ἠγάγετε αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ἀπεκρίθησαν οἱ ὑπηρέται, Οὐδέποτε οὕτως ἐλάλησεν ἄνθρωπος, ὡς οὗτος ὁ ἄνθρωπος. ");
INSERT INTO grctr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ἀπεκρίθησαν οὖν αὐτοῖς οἱ Φαρισαῖοι, Μὴ καὶ ὑμεῖς πεπλάνησθε; ");
INSERT INTO grctr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Μή τις ἐκ τῶν ἀρχόντων ἐπίστευσεν εἰς αὐτόν, ἢ ἐκ τῶν Φαρισαίων; ");
INSERT INTO grctr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ἀλλ᾿ ὁ ὄχλος οὗτος ὁ μὴ γινώσκων τὸν νόμον ἐπικατάρατοί εἰσι. ");
INSERT INTO grctr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Λέγει Νικόδημος πρὸς αὐτούς — ὁ ἐλθὼν νυκτὸς πρὸς αὐτόν, εἷς ὢν ἐξ αὐτῶν — ");
INSERT INTO grctr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Μὴ ὁ νόμος ἡμῶν κρίνει τὸν ἄνθρωπον, ἐὰν μὴ ἀκούσῃ παρ᾿ αὐτοῦ πρότερον καὶ γνῷ τί ποιεῖ; ");
INSERT INTO grctr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ἀπεκρίθησαν καὶ εἶπον αὐτῷ, Μὴ καὶ σὺ ἐκ τῆς Γαλιλαίας εἶ; Ἐρεύνησον καὶ ἴδε ὅτι προφήτης ἐκ τῆς Γαλιλαίας οὐκ ἐγήγερται. ");
INSERT INTO grctr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Καὶ ἐπορεύθη ἕκαστος εἰς τὸν οἶκον αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ἰησοῦς δὲ ἐπορεύθη εἰς τὸ ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grctr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ὄρθρου δὲ πάλιν παρεγένετο εἰς τὸ ἱερόν, καὶ πᾶς ὁ λαὸς ἤρχετο πρὸς αὐτόν· καὶ καθίσας ἐδίδασκεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ἄγουσι δὲ οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι πρὸς αὐτὸν γυναῖκα ἐν μοιχείᾳ κατειλημμένην· καὶ στήσαντες αὐτὴν ἐν μέσῳ, ");
INSERT INTO grctr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","λέγουσιν αὐτῷ, Διδάσκαλε, αὕτη ἡ γυνὴ κατειλήφθη ἐπαυτοφώρῳ μοιχευομένη. ");
INSERT INTO grctr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ἐν δὲ τῷ νόμῳ Μωσῆς ἡμῖν ἐνετείλατο τὰς τοιαύτας λιθοβολεῖσθαι· σὺ οὖν τί λέγεις; ");
INSERT INTO grctr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Τοῦτο δὲ ἔλεγον πειράζοντες αὐτόν, ἵνα ἔχωσι κατηγορεῖν αὐτοῦ. Ὁ δὲ Ἰησοῦς κάτω κύψας, τῷ δακτύλῳ ἔγραφεν εἰς τὴν γῆν. ");
INSERT INTO grctr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ὡς δὲ ἐπέμενον ἐρωτῶντες αὐτόν, ἀνακύψας εἶπε πρὸς αὐτούς, Ὁ ἀναμάρτητος ὑμῶν, πρῶτος τὸν λίθον ἐπ᾿ αὐτῇ βαλέτω. ");
INSERT INTO grctr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Καὶ πάλιν κάτω κύψας ἔγραφεν εἰς τὴν γῆν. ");
INSERT INTO grctr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Οἱ δέ, ἀκούσαντες, καὶ ὑπὸ τῆς συνειδήσεως ἐλεγχόμενοι, ἐξήρχοντο εἷς καθ᾿ εἷς, ἀρξάμενοι ἀπὸ τῶν πρεσβυτέρων ἕως τῶν ἐσχάτων· καὶ κατελείφθη μόνος ὁ Ἰησοῦς, καὶ ἡ γυνὴ ἐν μέσῳ ἑστῶσα. ");
INSERT INTO grctr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ἀνακύψας δὲ ὁ Ἰησοῦς, καὶ μηδένα θεασάμενος πλὴν τῆς γυναικός, εἶπεν αὐτῇ, Ἡ γυνή, ποῦ εἰσιν ἐκεῖνοι οἱ κατήγοροί σου; Οὐδείς σε κατέκρινεν; ");
INSERT INTO grctr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ἡ δὲ εἶπεν, Οὐδείς, Κύριε. Εἶπε δὲ αὐτῇ ὁ Ἰησοῦς, Οὐδὲ ἐγώ σε κατακρίνω· πορεύου καὶ μηκέτι ἁμάρτανε. ");
INSERT INTO grctr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Πάλιν οὖν ὁ Ἰησοῦς αὐτοῖς ἐλάλησε λέγων, Ἐγώ εἰμι τὸ φῶς τοῦ κόσμου· ὁ ἀκολουθῶν ἐμοὶ οὐ μὴ περιπατήσει ἐν τῇ σκοτίᾳ, ἀλλ᾿ ἕξει τὸ φῶς τῆς ζωῆς. ");
INSERT INTO grctr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Εἶπον οὖν αὐτῷ οἱ Φαρισαῖοι, Σὺ περὶ σεαυτοῦ μαρτυρεῖς· ἡ μαρτυρία σου οὐκ ἔστιν ἀληθής. ");
INSERT INTO grctr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτοῖς, Κἂν ἐγὼ μαρτυρῶ περὶ ἐμαυτοῦ, ἀληθής ἐστιν ἡ μαρτυρία μου· ὅτι οἶδα πόθεν ἦλθον, καὶ ποῦ ὑπάγω· ὑμεῖς δὲ οὐκ οἴδατε πόθεν ἔρχομαι, καὶ ποῦ ὑπάγω. ");
INSERT INTO grctr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ὑμεῖς κατὰ τὴν σάρκα κρίνετε· ἐγὼ οὐ κρίνω οὐδένα. ");
INSERT INTO grctr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Καὶ ἐὰν κρίνω δὲ ἐγώ, ἡ κρίσις ἡ ἐμὴ ἀληθής ἐστιν· ὅτι μόνος οὐκ εἰμί, ἀλλ᾿ ἐγὼ καὶ ὁ πέμψας με πατήρ. ");
INSERT INTO grctr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Καὶ ἐν τῷ νόμῳ δὲ τῷ ὑμετέρῳ γέγραπται ὅτι δύο ἀνθρώπων ἡ μαρτυρία ἀληθής ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ἐγώ εἰμι ὁ μαρτυρῶν περὶ ἐμαυτοῦ, καὶ μαρτυρεῖ περὶ ἐμοῦ ὁ πέμψας με πατήρ. ");
INSERT INTO grctr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ἔλεγον οὖν αὐτῷ, Ποῦ ἐστιν ὁ πατήρ σου; Ἀπεκρίθη ὁ Ἰησοῦς, Οὔτε ἐμὲ οἴδατε, οὔτε τὸν πατέρα μου· εἰ ἐμὲ ᾔδειτε, καὶ τὸν πατέρα μου ᾔδειτε ἄν. ");
INSERT INTO grctr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ταῦτα τὰ ῥήματα ἐλάλησεν ὁ Ἰησοῦς ἐν τῷ γαζοφυλακίῳ, διδάσκων ἐν τῷ ἱερῷ· καὶ οὐδεὶς ἐπίασεν αὐτόν, ὅτι οὔπω ἐληλύθει ἡ ὥρα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Εἶπεν οὖν πάλιν αὐτοῖς ὁ Ἰησοῦς, Ἐγὼ ὑπάγω, καὶ ζητήσετέ με, καὶ ἐν τῇ ἁμαρτίᾳ ὑμῶν ἀποθανεῖσθε· ὅπου ἐγὼ ὑπάγω, ὑμεῖς οὐ δύνασθε ἐλθεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ἔλεγον οὖν οἱ Ἰουδαῖοι, Μήτι ἀποκτενεῖ ἑαυτόν, ὅτι λέγει, Ὅπου ἐγὼ ὑπάγω, ὑμεῖς οὐ δύνασθε ἐλθεῖν; ");
INSERT INTO grctr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Καὶ εἶπεν αὐτοῖς, Ὑμεῖς ἐκ τῶν κάτω ἐστέ, ἐγὼ ἐκ τῶν ἄνω εἰμί· ὑμεῖς ἐκ τοῦ κόσμου τούτου ἐστέ, ἐγὼ οὐκ εἰμὶ ἐκ τοῦ κόσμου τούτου. ");
INSERT INTO grctr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Εἶπον οὖν ὑμῖν ὅτι ἀποθανεῖσθε ἐν ταῖς ἁμαρτίαις ὑμῶν· ἐὰν γὰρ μὴ πιστεύσητε ὅτι ἐγώ εἰμι, ἀποθανεῖσθε ἐν ταῖς ἁμαρτίαις ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ἔλεγον οὖν αὐτῷ, Σὺ τίς εἶ; Καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς, Τὴν ἀρχὴν ὅ τι καὶ λαλῶ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Πολλὰ ἔχω περὶ ὑμῶν λαλεῖν καὶ κρίνειν· ἀλλ᾿ ὁ πέμψας με ἀληθής ἐστι, κἀγὼ ἃ ἤκουσα παρ᾿ αὐτοῦ, ταῦτα λέγω εἰς τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Οὐκ ἔγνωσαν ὅτι τὸν πατέρα αὐτοῖς ἔλεγεν. ");
INSERT INTO grctr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Ὅταν ὑψώσητε τὸν υἱὸν τοῦ ἀνθρώπου, τότε γνώσεσθε ὅτι ἐγώ εἰμι, καὶ ἀπ᾿ ἐμαυτοῦ ποιῶ οὐδέν, ἀλλὰ καθὼς ἐδίδαξέ με ὁ πατήρ μου, ταῦτα λαλῶ· ");
INSERT INTO grctr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","καὶ ὁ πέμψας με μετ᾿ ἐμοῦ ἐστιν· οὐκ ἀφῆκέ με μόνον ὁ πατήρ, ὅτι ἐγὼ τὰ ἀρεστὰ αὐτῷ ποιῶ πάντοτε. ");
INSERT INTO grctr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ταῦτα αὐτοῦ λαλοῦντος πολλοὶ ἐπίστευσαν εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ἔλεγεν οὖν ὁ Ἰησοῦς πρὸς τοὺς πεπιστευκότας αὐτῷ Ἰουδαίους, Ἐὰν ὑμεῖς μείνητε ἐν τῷ λόγῳ τῷ ἐμῷ, ἀληθῶς μαθηταί μου ἐστέ· ");
INSERT INTO grctr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","καὶ γνώσεσθε τὴν ἀλήθειαν, καὶ ἡ ἀλήθεια ἐλευθερώσει ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ἀπεκρίθησαν αὐτῷ, Σπέρμα Ἀβραάμ ἐσμεν, καὶ οὐδενὶ δεδουλεύκαμεν πώποτε· πῶς σὺ λέγεις ὅτι Ἐλεύθεροι γενήσεσθε; ");
INSERT INTO grctr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι πᾶς ὁ ποιῶν τὴν ἁμαρτίαν δοῦλός ἐστι τῆς ἁμαρτίας. ");
INSERT INTO grctr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ὁ δὲ δοῦλος οὐ μένει ἐν τῇ οἰκίᾳ εἰς τὸν αἰῶνα· ὁ υἱὸς μένει εἰς τὸν αἰῶνα. ");
INSERT INTO grctr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ἐὰν οὖν ὁ υἱὸς ὑμᾶς ἐλευθερώσῃ, ὄντως ἐλεύθεροι ἔσεσθε. ");
INSERT INTO grctr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Οἶδα ὅτι σπέρμα Ἀβραάμ ἐστε· ἀλλὰ ζητεῖτέ με ἀποκτεῖναι, ὅτι ὁ λόγος ὁ ἐμὸς οὐ χωρεῖ ἐν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ἐγὼ ὃ ἑώρακα παρὰ τῷ πατρί μου, λαλῶ· καὶ ὑμεῖς οὖν ὃ ἑωράκατε παρὰ τῷ πατρὶ ὑμῶν, ποιεῖτε. ");
INSERT INTO grctr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ἀπεκρίθησαν καὶ εἶπον αὐτῷ, Ὁ πατὴρ ἡμῶν Ἀβραάμ ἐστι. Λέγει αὐτοῖς ὁ Ἰησοῦς, Εἰ τέκνα τοῦ Ἀβραὰμ ἦτε, τὰ ἔργα τοῦ Ἀβραὰμ ἐποιεῖτε ἄν. ");
INSERT INTO grctr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Νῦν δὲ ζητεῖτέ με ἀποκτεῖναι, ἄνθρωπον ὃς τὴν ἀλήθειαν ὑμῖν λελάληκα, ἣν ἤκουσα παρὰ τοῦ Θεοῦ· τοῦτο Ἀβραὰμ οὐκ ἐποίησεν. ");
INSERT INTO grctr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ὑμεῖς ποιεῖτε τὰ ἔργα τοῦ πατρὸς ὑμῶν. Εἶπον οὖν αὐτῷ, Ἡμεῖς ἐκ πορνείας οὐ γεγεννήμεθα· ἕνα πατέρα ἔχομεν, τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Εἰ ὁ Θεὸς πατὴρ ὑμῶν ἦν, ἠγαπᾶτε ἂν ἐμέ· ἐγὼ γὰρ ἐκ τοῦ Θεοῦ ἐξῆλθον καὶ ἥκω· οὐδὲ γὰρ ἀπ᾿ ἐμαυτοῦ ἐλήλυθα, ἀλλ᾿ ἐκεῖνός με ἀπέστειλε. ");
INSERT INTO grctr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Διὰ τί τὴν λαλιὰν τὴν ἐμὴν οὐ γινώσκετε; Ὅτι οὐ δύνασθε ἀκούειν τὸν λόγον τὸν ἐμόν. ");
INSERT INTO grctr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ὑμεῖς ἐκ πατρὸς τοῦ διαβόλου ἐστέ, καὶ τὰς ἐπιθυμίας τοῦ πατρὸς ὑμῶν θέλετε ποιεῖν. Ἐκεῖνος ἀνθρωποκτόνος ἦν ἀπ᾿ ἀρχῆς, καὶ ἐν τῇ ἀληθείᾳ οὐχ ἕστηκεν, ὅτι οὐκ ἔστιν ἀλήθεια ἐν αὐτῷ. Ὅταν λαλῇ τὸ ψεῦδος, ἐκ τῶν ἰδίων λαλεῖ· ὅτι ψεύστης ἐστὶ καὶ ὁ πατὴρ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ἐγὼ δὲ ὅτι τὴν ἀλήθειαν λέγω, οὐ πιστεύετέ μοι. ");
INSERT INTO grctr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Τίς ἐξ ὑμῶν ἐλέγχει με περὶ ἁμαρτίας; Εἰ δὲ ἀλήθειαν λέγω, διὰ τί ὑμεῖς οὐ πιστεύετέ μοι; ");
INSERT INTO grctr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ὁ ὢν ἐκ τοῦ Θεοῦ τὰ ῥήματα τοῦ Θεοῦ ἀκούει· διὰ τοῦτο ὑμεῖς οὐκ ἀκούετε, ὅτι ἐκ τοῦ Θεοῦ οὐκ ἐστέ. ");
INSERT INTO grctr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ἀπεκρίθησαν οὖν οἱ Ἰουδαῖοι καὶ εἶπον αὐτῷ, Οὐ καλῶς λέγομεν ἡμεῖς ὅτι Σαμαρείτης εἶ σύ, καὶ δαιμόνιον ἔχεις; ");
INSERT INTO grctr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ἀπεκρίθη Ἰησοῦς, Ἐγὼ δαιμόνιον οὐκ ἔχω, ἀλλὰ τιμῶ τὸν πατέρα μου, καὶ ὑμεῖς ἀτιμάζετέ με. ");
INSERT INTO grctr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ἐγὼ δὲ οὐ ζητῶ τὴν δόξαν μου· ἔστιν ὁ ζητῶν καὶ κρίνων. ");
INSERT INTO grctr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ἀμὴν ἀμὴν λέγω ὑμῖν, ἐάν τις τὸν λόγον τὸν ἐμὸν τηρήσῃ, θάνατον οὐ μὴ θεωρήσῃ εἰς τὸν αἰῶνα. ");
INSERT INTO grctr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Εἶπον οὖν αὐτῷ οἱ Ἰουδαῖοι, Νῦν ἐγνώκαμεν ὅτι δαιμόνιον ἔχεις. Ἀβραὰμ ἀπέθανε καὶ οἱ προφῆται, καὶ σὺ λέγεις, Ἐάν τις τὸν λόγον μου τηρήσῃ, οὐ μὴ γεύσεται θανάτου εἰς τὸν αἰῶνα. ");
INSERT INTO grctr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Μὴ σὺ μείζων εἶ τοῦ πατρὸς ἡμῶν Ἀβραάμ, ὅστις ἀπέθανε; Καὶ οἱ προφῆται ἀπέθανον· τίνα σεαυτὸν σὺ ποιεῖς; ");
INSERT INTO grctr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ἀπεκρίθη Ἰησοῦς, Ἐὰν ἐγὼ δοξάζω ἐμαυτόν, ἡ δόξα μου οὐδέν ἐστιν· ἔστιν ὁ πατήρ μου ὁ δοξάζων με, ὃν ὑμεῖς λέγετε ὅτι Θεὸς ὑμῶν ἐστι, ");
INSERT INTO grctr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","καὶ οὐκ ἐγνώκατε αὐτόν· ἐγὼ δὲ οἶδα αὐτόν, καὶ ἐὰν εἴπω ὅτι οὐκ οἶδα αὐτόν, ἔσομαι ὅμοιος ὑμῶν, ψεύστης· ἀλλ᾿ οἶδα αὐτόν, καὶ τὸν λόγον αὐτοῦ τηρῶ. ");
INSERT INTO grctr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ἀβραὰμ ὁ πατὴρ ὑμῶν ἠγαλλιάσατο ἵνα ἴδῃ τὴν ἡμέραν τὴν ἐμήν, καὶ εἶδε καὶ ἐχάρη. ");
INSERT INTO grctr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Εἶπον οὖν οἱ Ἰουδαῖοι πρὸς αὐτόν, Πεντήκοντα ἔτη οὔπω ἔχεις, καὶ Ἀβραὰμ ἑώρακας; ");
INSERT INTO grctr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Εἶπεν αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω ὑμῖν, πρὶν Ἀβραὰμ γενέσθαι, ἐγώ εἰμι. ");
INSERT INTO grctr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ἦραν οὖν λίθους ἵνα βάλωσιν ἐπ᾿ αὐτόν· Ἰησοῦς δὲ ἐκρύβη, καὶ ἐξῆλθεν ἐκ τοῦ ἱεροῦ, διελθὼν διὰ μέσου αὐτῶν· καὶ παρῆγεν οὕτως. ");
INSERT INTO grctr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Καὶ παράγων εἶδεν ἄνθρωπον τυφλὸν ἐκ γενετῆς. ");
INSERT INTO grctr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Καὶ ἠρώτησαν αὐτὸν οἱ μαθηταὶ αὐτοῦ λέγοντες, Ῥαββί, τίς ἥμαρτεν, οὗτος ἢ οἱ γονεῖς αὐτοῦ, ἵνα τυφλὸς γεννηθῇ; ");
INSERT INTO grctr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ἀπεκρίθη ὁ Ἰησοῦς, Οὔτε οὗτος ἥμαρτεν οὔτε οἱ γονεῖς αὐτοῦ· ἀλλ᾿ ἵνα φανερωθῇ τὰ ἔργα τοῦ Θεοῦ ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ἐμὲ δεῖ ἐργάζεσθαι τὰ ἔργα τοῦ πέμψαντός με ἕως ἡμέρα ἐστίν· ἔρχεται νύξ, ὅτε οὐδεὶς δύναται ἐργάζεσθαι. ");
INSERT INTO grctr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ὅταν ἐν τῷ κόσμῳ ὦ, φῶς εἰμι τοῦ κόσμου. ");
INSERT INTO grctr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ταῦτα εἰπών, ἔπτυσε χαμαί, καὶ ἐποίησε πηλὸν ἐκ τοῦ πτύσματος, καὶ ἐπέχρισε τὸν πηλὸν ἐπὶ τοὺς ὀφθαλμοὺς τοῦ τυφλοῦ, ");
INSERT INTO grctr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","καὶ εἶπεν αὐτῷ, Ὕπαγε νίψαι εἰς τὴν κολυμβήθραν τοῦ Σιλωάμ — ὃ ἑρμηνεύεται, Ἀπεσταλμένος. Ἀπῆλθεν οὖν καὶ ἐνίψατο, καὶ ἦλθε βλέπων. ");
INSERT INTO grctr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Οἱ οὖν γείτονες καὶ οἱ θεωροῦντες αὐτὸν τὸ πρότερον ὅτι τυφλὸς ἦν, ἔλεγον, Οὐχ οὗτός ἐστιν ὁ καθήμενος καὶ προσαιτῶν; ");
INSERT INTO grctr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ἄλλοι ἔλεγον ὅτι Οὗτός ἐστιν· ἄλλοι δὲ ὅτι Ὅμοιος αὐτῷ ἐστιν. Ἐκεῖνος ἔλεγεν ὅτι Ἐγώ εἰμι. ");
INSERT INTO grctr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ἔλεγον οὖν αὐτῷ, Πῶς ἀνεῴχθησάν σου οἱ ὀφθαλμοί; ");
INSERT INTO grctr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ἀπεκρίθη ἐκεῖνος καὶ εἶπεν, Ἄνθρωπος λεγόμενος Ἰησοῦς πηλὸν ἐποίησε, καὶ ἐπέχρισέ μου τοὺς ὀφθαλμούς, καὶ εἶπέ μοι, Ὕπαγε εἰς τὴν κολυμβήθραν τοῦ Σιλωάμ, καὶ νίψαι. Ἀπελθὼν δὲ καὶ νιψάμενος, ἀνέβλεψα. ");
INSERT INTO grctr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Εἶπον οὖν αὐτῷ, Ποῦ ἐστιν ἐκεῖνος; Λέγει, Οὐκ οἶδα. ");
INSERT INTO grctr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ἄγουσιν αὐτὸν πρὸς τοὺς Φαρισαίους, τόν ποτε τυφλόν. ");
INSERT INTO grctr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ἦν δὲ σάββατον ὅτε τὸν πηλὸν ἐποίησεν ὁ Ἰησοῦς, καὶ ἀνέῳξεν αὐτοῦ τοὺς ὀφθαλμούς. ");
INSERT INTO grctr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Πάλιν οὖν ἠρώτων αὐτὸν καὶ οἱ Φαρισαῖοι, πῶς ἀνέβλεψεν. Ὁ δὲ εἶπεν αὐτοῖς, Πηλὸν ἐπέθηκέν ἐπὶ τοὺς ὀφθαλμούς μου, καὶ ἐνιψάμην, καὶ βλέπω. ");
INSERT INTO grctr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ἔλεγον οὖν ἐκ τῶν Φαρισαίων τινές, Οὗτος ὁ ἄνθρωπος οὐκ ἔστι παρὰ τοῦ Θεοῦ, ὅτι τὸ σάββατον οὐ τηρεῖ. Ἄλλοι ἔλεγον, Πῶς δύναται ἄνθρωπος ἁμαρτωλὸς τοιαῦτα σημεῖα ποιεῖν; Καὶ σχίσμα ἦν ἐν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Λέγουσι τῷ τυφλῷ πάλιν, Σὺ τί λέγεις περὶ αὐτοῦ, ὅτι ἤνοιξέ σου τοὺς ὀφθαλμούς; Ὁ δὲ εἶπεν ὅτι Προφήτης ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Οὐκ ἐπίστευσαν οὖν οἱ Ἰουδαῖοι περὶ αὐτοῦ, ὅτι τυφλὸς ἦν καὶ ἀνέβλεψεν, ἕως ὅτου ἐφώνησαν τοὺς γονεῖς αὐτοῦ τοῦ ἀναβλέψαντος, ");
INSERT INTO grctr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","καὶ ἠρώτησαν αὐτοὺς λέγοντες, Οὗτός ἐστιν ὁ υἱὸς ὑμῶν, ὃν ὑμεῖς λέγετε ὅτι τυφλὸς ἐγεννήθη; Πῶς οὖν ἄρτι βλέπει; ");
INSERT INTO grctr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ἀπεκρίθησαν αὐτοῖς οἱ γονεῖς αὐτοῦ καὶ εἶπον, Οἴδαμεν ὅτι οὗτός ἐστιν ὁ υἱὸς ἡμῶν, καὶ ὅτι τυφλὸς ἐγεννήθη· ");
INSERT INTO grctr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","πῶς δὲ νῦν βλέπει, οὐκ οἴδαμεν· ἢ τίς ἤνοιξεν αὐτοῦ τοὺς ὀφθαλμούς, ἡμεῖς οὐκ οἴδαμεν· αὐτὸς ἡλικίαν ἔχει· αὐτὸν ἐρωτήσατε, αὐτὸς περὶ αὐτοῦ λαλήσει. ");
INSERT INTO grctr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ταῦτα εἶπον οἱ γονεῖς αὐτοῦ, ὅτι ἐφοβοῦντο τοὺς Ἰουδαίους· ἤδη γὰρ συνετέθειντο οἱ Ἰουδαῖοι, ἵνα ἐάν τις αὐτὸν ὁμολογήσῃ Χριστόν, ἀποσυνάγωγος γένηται. ");
INSERT INTO grctr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Διὰ τοῦτο οἱ γονεῖς αὐτοῦ εἶπον ὅτι Ἡλικίαν ἔχει, αὐτὸν ἐρωτήσατε. ");
INSERT INTO grctr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ἐφώνησαν οὖν ἐκ δευτέρου τὸν ἄνθρωπον ὃς ἦν τυφλός, καὶ εἶπον αὐτῷ, Δὸς δόξαν τῷ Θεῷ· ἡμεῖς οἴδαμεν ὅτι ὁ ἄνθρωπος οὗτος ἁμαρτωλός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ἀπεκρίθη οὖν ἐκεῖνος καὶ εἶπεν, Εἰ ἁμαρτωλός ἐστιν, οὐκ οἶδα· ἓν οἶδα, ὅτι τυφλὸς ὤν, ἄρτι βλέπω. ");
INSERT INTO grctr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Εἶπον δὲ αὐτῷ πάλιν, Τί ἐποίησέ σοι; Πῶς ἤνοιξέ σου τοὺς ὀφθαλμούς; ");
INSERT INTO grctr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ἀπεκρίθη αὐτοῖς, Εἶπον ὑμῖν ἤδη, καὶ οὐκ ἠκούσατε. Τί πάλιν θέλετε ἀκούειν; Μὴ καὶ ὑμεῖς θέλετε αὐτοῦ μαθηταὶ γενέσθαι; ");
INSERT INTO grctr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ἐλοιδόρησαν οὖν αὐτόν, καὶ εἶπον, Σὺ εἶ μαθητὴς ἐκείνου· ἡμεῖς δὲ τοῦ Μωσέως ἐσμὲν μαθηταί. ");
INSERT INTO grctr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ἡμεῖς οἴδαμεν ὅτι Μωσῇ λελάληκεν ὁ Θεός· τοῦτον δὲ οὐκ οἴδαμεν πόθεν ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ἀπεκρίθη ὁ ἄνθρωπος καὶ εἶπεν αὐτοῖς, Ἐν γὰρ τούτῳ θαυμαστόν ἐστιν, ὅτι ὑμεῖς οὐκ οἴδατε πόθεν ἐστί, καὶ ἀνέῳξέ μου τοὺς ὀφθαλμούς. ");
INSERT INTO grctr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Οἴδαμεν δὲ ὅτι ἁμαρτωλῶν ὁ Θεὸς οὐκ ἀκούει· ἀλλ᾿ ἐάν τις θεοσεβὴς ᾖ, καὶ τὸ θέλημα αὐτοῦ ποιῇ, τούτου ἀκούει. ");
INSERT INTO grctr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ἐκ τοῦ αἰῶνος οὐκ ἠκούσθη ὅτι ἤνοιξέ τις ὀφθαλμοὺς τυφλοῦ γεγεννημένου. ");
INSERT INTO grctr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Εἰ μὴ ἦν οὗτος παρὰ Θεοῦ, οὐκ ἠδύνατο ποιεῖν οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ἀπεκρίθησαν καὶ εἶπον αὐτῷ, Ἐν ἁμαρτίαις σὺ ἐγεννήθης ὅλος, καὶ σὺ διδάσκεις ἡμᾶς; Καὶ ἐξέβαλον αὐτὸν ἔξω. ");
INSERT INTO grctr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ἤκουσεν ὁ Ἰησοῦς ὅτι ἐξέβαλον αὐτὸν ἔξω· καὶ εὑρὼν αὐτόν, εἶπεν αὐτῷ, Σὺ πιστεύεις εἰς τὸν υἱὸν τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ἀπεκρίθη ἐκεῖνος καὶ εἶπε, Τίς ἐστι, Κύριε, ἵνα πιστεύσω εἰς αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Εἶπε δὲ αὐτῷ ὁ Ἰησοῦς, Καὶ ἑώρακας αὐτόν, καὶ ὁ λαλῶν μετὰ σοῦ ἐκεῖνός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ὁ δὲ ἔφη, Πιστεύω, Κύριε· καὶ προσεκύνησεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Καὶ εἶπεν ὁ Ἰησοῦς, Εἰς κρίμα ἐγὼ εἰς τὸν κόσμον τοῦτον ἦλθον, ἵνα οἱ μὴ βλέποντες βλέπωσι, καὶ οἱ βλέποντες τυφλοὶ γένωνται. ");
INSERT INTO grctr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Καὶ ἤκουσαν ἐκ τῶν Φαρισαίων ταῦτα οἱ ὄντες μετ᾿ αὐτοῦ, καὶ εἶπον αὐτῷ, Μὴ καὶ ἡμεῖς τυφλοί ἐσμεν; ");
INSERT INTO grctr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Εἶπεν αὐτοῖς ὁ Ἰησοῦς, Εἰ τυφλοὶ ἦτε, οὐκ ἂν εἴχετε ἁμαρτίαν· νῦν δὲ λέγετε ὅτι Βλέπομεν· ἡ οὖν ἁμαρτία ὑμῶν μένει. ");
INSERT INTO grctr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ μὴ εἰσερχόμενος διὰ τῆς θύρας εἰς τὴν αὐλὴν τῶν προβάτων, ἀλλὰ ἀναβαίνων ἀλλαχόθεν, ἐκεῖνος κλέπτης ἐστὶ καὶ λῃστής. ");
INSERT INTO grctr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ὁ δὲ εἰσερχόμενος διὰ τῆς θύρας ποιμήν ἐστι τῶν προβάτων. ");
INSERT INTO grctr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Τούτῳ ὁ θυρωρὸς ἀνοίγει, καὶ τὰ πρόβατα τῆς φωνῆς αὐτοῦ ἀκούει, καὶ τὰ ἴδια πρόβατα καλεῖ κατ᾿ ὄνομα, καὶ ἐξάγει αὐτά. ");
INSERT INTO grctr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Καὶ ὅταν τὰ ἴδια πρόβατα ἐκβάλῃ, ἔμπροσθεν αὐτῶν πορεύεται· καὶ τὰ πρόβατα αὐτῷ ἀκολουθεῖ, ὅτι οἴδασι τὴν φωνὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ἀλλοτρίῳ δὲ οὐ μὴ ἀκολουθήσωσιν, ἀλλὰ φεύξονται ἀπ᾿ αὐτοῦ· ὅτι οὐκ οἴδασι τῶν ἀλλοτρίων τὴν φωνήν. ");
INSERT INTO grctr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ταύτην τὴν παροιμίαν εἶπεν αὐτοῖς ὁ Ἰησοῦς· ἐκεῖνοι δὲ οὐκ ἔγνωσαν τίνα ἦν ἃ ἐλάλει αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Εἶπεν οὖν πάλιν αὐτοῖς ὁ Ἰησοῦς, Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ἐγώ εἰμι ἡ θύρα τῶν προβάτων. ");
INSERT INTO grctr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Πάντες ὅσοι πρὸ ἐμοῦ ἦλθον κλέπται εἰσὶ καὶ λῃσταί· ἀλλ᾿ οὐκ ἤκουσαν αὐτῶν τὰ πρόβατα. ");
INSERT INTO grctr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ἐγώ εἰμι ἡ θύρα· δι᾿ ἐμοῦ ἐάν τις εἰσέλθῃ, σωθήσεται, καὶ εἰσελεύσεται καὶ ἐξελεύσεται, καὶ νομὴν εὑρήσει. ");
INSERT INTO grctr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ὁ κλέπτης οὐκ ἔρχεται εἰ μὴ ἵνα κλέψῃ καὶ θύσῃ καὶ ἀπολέσῃ· ἐγὼ ἦλθον ἵνα ζωὴν ἔχωσι, καὶ περισσὸν ἔχωσιν. ");
INSERT INTO grctr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ἐγώ εἰμι ὁ ποιμὴν ὁ καλός· ὁ ποιμὴν ὁ καλὸς τὴν ψυχὴν αὐτοῦ τίθησιν ὑπὲρ τῶν προβάτων. ");
INSERT INTO grctr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ὁ μισθωτὸς δέ, καὶ οὐκ ὢν ποιμήν, οὗ οὐκ εἰσὶ τὰ πρόβατα ἴδια, θεωρεῖ τὸν λύκον ἐρχόμενον, καὶ ἀφίησι τὰ πρόβατα, καὶ φεύγει· καὶ ὁ λύκος ἁρπάζει αὐτά, καὶ σκορπίζει τὰ πρόβατα. ");
INSERT INTO grctr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ὁ δὲ μισθωτὸς φεύγει, ὅτι μισθωτός ἐστι, καὶ οὐ μέλει αὐτῷ περὶ τῶν προβάτων. ");
INSERT INTO grctr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ἐγώ εἰμι ὁ ποιμὴν ὁ καλός, καὶ γινώσκω τὰ ἐμά, καὶ γινώσκομαι ὑπὸ τῶν ἐμῶν. ");
INSERT INTO grctr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Καθὼς γινώσκει με ὁ πατήρ, κἀγὼ γινώσκω τὸν πατέρα· καὶ τὴν ψυχήν μου τίθημι ὑπὲρ τῶν προβάτων. ");
INSERT INTO grctr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Καὶ ἄλλα πρόβατα ἔχω, ἃ οὐκ ἔστιν ἐκ τῆς αὐλῆς ταύτης· κἀκεῖνά με δεῖ ἀγαγεῖν, καὶ τῆς φωνῆς μου ἀκούσουσι· καὶ γενήσεται μία ποίμνη, εἷς ποιμήν. ");
INSERT INTO grctr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Διὰ τοῦτο ὁ πατήρ με ἀγαπᾷ, ὅτι ἐγὼ τίθημι τὴν ψυχήν μου, ἵνα πάλιν λάβω αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Οὐδεὶς αἴρει αὐτὴν ἀπ᾿ ἐμοῦ, ἀλλ᾿ ἐγὼ τίθημι αὐτὴν ἀπ᾿ ἐμαυτοῦ. Ἐξουσίαν ἔχω θεῖναι αὐτήν, καὶ ἐξουσίαν ἔχω πάλιν λαβεῖν αὐτήν. Ταύτην τὴν ἐντολὴν ἔλαβον παρὰ τοῦ πατρός μου. ");
INSERT INTO grctr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Σχίσμα οὖν πάλιν ἐγένετο ἐν τοῖς Ἰουδαίοις διὰ τοὺς λόγους τούτους. ");
INSERT INTO grctr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ἔλεγον δὲ πολλοὶ ἐξ αὐτῶν, Δαιμόνιον ἔχει καὶ μαίνεται· τί αὐτοῦ ἀκούετε; ");
INSERT INTO grctr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ἄλλοι ἔλεγον, Ταῦτα τὰ ῥήματα οὐκ ἔστι δαιμονιζομένου· μὴ δαιμόνιον δύναται τυφλῶν ὀφθαλμοὺς ἀνοίγειν; ");
INSERT INTO grctr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ἐγένετο δὲ τὰ Ἐγκαίνια ἐν τοῖς Ἱεροσολύμοις, καὶ χειμὼν ἦν· ");
INSERT INTO grctr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","καὶ περιεπάτει ὁ Ἰησοῦς ἐν τῷ ἱερῷ ἐν τῇ στοᾷ τοῦ Σολομῶντος. ");
INSERT INTO grctr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ἐκύκλωσαν οὖν αὐτὸν οἱ Ἰουδαῖοι, καὶ ἔλεγον αὐτῷ, Ἕως πότε τὴν ψυχὴν ἡμῶν αἴρεις; Εἰ σὺ εἶ ὁ Χριστός, εἰπὲ ἡμῖν παρρησίᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Εἶπον ὑμῖν, καὶ οὐ πιστεύετε· τὰ ἔργα ἃ ἐγὼ ποιῶ ἐν τῷ ὀνόματι τοῦ πατρός μου, ταῦτα μαρτυρεῖ περὶ ἐμοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ἀλλ᾿ ὑμεῖς οὐ πιστεύετε· οὐ γάρ ἐστε ἐκ τῶν προβάτων τῶν ἐμῶν, καθὼς εἶπον ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Τὰ πρόβατα τὰ ἐμὰ τῆς φωνῆς μου ἀκούει, κἀγὼ γινώσκω αὐτά, καὶ ἀκολουθοῦσί μοι· ");
INSERT INTO grctr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","κἀγὼ ζωὴν αἰώνιον δίδωμι αὐτοῖς· καὶ οὐ μὴ ἀπόλωνται εἰς τὸν αἰῶνα, καὶ οὐχ ἁρπάσει τις αὐτὰ ἐκ τῆς χειρός μου. ");
INSERT INTO grctr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ὁ πατήρ μου ὃς δέδωκέ μοι, μείζων πάντων ἐστί· καὶ οὐδεὶς δύναται ἁρπάζειν ἐκ τῆς χειρὸς τοῦ πατρός μου. ");
INSERT INTO grctr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ἐγὼ καὶ ὁ πατὴρ ἕν ἐσμεν. ");
INSERT INTO grctr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ἐβάστασαν οὖν πάλιν λίθους οἱ Ἰουδαῖοι ἵνα λιθάσωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Πολλὰ καλὰ ἔργα ἔδειξα ὑμῖν ἐκ τοῦ πατρός μου· διὰ ποῖον αὐτῶν ἔργον λιθάζετέ με; ");
INSERT INTO grctr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ἀπεκρίθησαν αὐτῷ οἱ Ἰουδαῖοι λέγοντες, Περὶ καλοῦ ἔργου οὐ λιθάζομέν σε, ἀλλὰ περὶ βλασφημίας, καὶ ὅτι σὺ ἄνθρωπος ὢν ποιεῖς σεαυτὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Οὐκ ἔστι γεγραμμένον ἐν τῷ νόμῳ ὑμῶν, Ἐγὼ εἶπα, Θεοί ἐστε; ");
INSERT INTO grctr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Εἰ ἐκείνους εἶπε θεούς, πρὸς οὓς ὁ λόγος τοῦ Θεοῦ ἐγένετο — καὶ οὐ δύναται λυθῆναι ἡ γραφή — ");
INSERT INTO grctr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ὃν ὁ πατὴρ ἡγίασε καὶ ἀπέστειλεν εἰς τὸν κόσμον, ὑμεῖς λέγετε ὅτι Βλασφημεῖς, ὅτι εἶπον, Υἱὸς τοῦ Θεοῦ εἰμι; ");
INSERT INTO grctr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Εἰ οὐ ποιῶ τὰ ἔργα τοῦ πατρός μου, μὴ πιστεύετέ μοι· ");
INSERT INTO grctr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","εἰ δὲ ποιῶ, κἂν ἐμοὶ μὴ πιστεύητε, τοῖς ἔργοις πιστεύσατε· ἵνα γνῶτε καὶ πιστεύσητε ὅτι ἐν ἐμοὶ ὁ πατήρ, κἀγὼ ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ἐζήτουν οὖν πάλιν αὐτὸν πιάσαι· καὶ ἐξῆλθεν ἐκ τῆς χειρὸς αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Καὶ ἀπῆλθε πάλιν πέραν τοῦ Ἰορδάνου εἰς τὸν τόπον ὅπου ἦν Ἰωάννης τὸ πρῶτον βαπτίζων· καὶ ἔμεινεν ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Καὶ πολλοὶ ἦλθον πρὸς αὐτόν, καὶ ἔλεγον ὅτι Ἰωάννης μὲν σημεῖον ἐποίησεν οὐδέν· πάντα δὲ ὅσα εἶπεν Ἰωάννης περὶ τούτου, ἀληθῆ ἦν. ");
INSERT INTO grctr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Καὶ ἐπίστευσαν πολλοὶ ἐκεῖ εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ἦν δέ τις ἀσθενῶν Λάζαρος ἀπὸ Βηθανίας, ἐκ τῆς κώμης Μαρίας καὶ Μάρθας τῆς ἀδελφῆς αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ἦν δὲ Μαρία ἡ ἀλείψασα τὸν Κύριον μύρῳ, καὶ ἐκμάξασα τοὺς πόδας αὐτοῦ ταῖς θριξὶν αὐτῆς, ἧς ὁ ἀδελφὸς Λάζαρος ἠσθένει. ");
INSERT INTO grctr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ἀπέστειλαν οὖν αἱ ἀδελφαὶ πρὸς αὐτὸν λέγουσαι, Κύριε, ἴδε ὃν φιλεῖς ἀσθενεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ἀκούσας δὲ ὁ Ἰησοῦς εἶπεν, Αὕτη ἡ ἀσθένεια οὐκ ἔστι πρὸς θάνατον, ἀλλ᾿ ὑπὲρ τῆς δόξης τοῦ Θεοῦ, ἵνα δοξασθῇ ὁ υἱὸς τοῦ Θεοῦ δι᾿ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ἠγάπα δὲ ὁ Ἰησοῦς τὴν Μάρθαν καὶ τὴν ἀδελφὴν αὐτῆς καὶ τὸν Λάζαρον. ");
INSERT INTO grctr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ὡς οὖν ἤκουσεν ὅτι ἀσθενεῖ, τότε μὲν ἔμεινεν ἐν ᾧ ἦν τόπῳ δύο ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ἔπειτα μετὰ τοῦτο λέγει τοῖς μαθηταῖς, Ἄγωμεν εἰς τὴν Ἰουδαίαν πάλιν. ");
INSERT INTO grctr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Λέγουσιν αὐτῷ οἱ μαθηταί, Ῥαββί, νῦν ἐζήτουν σε λιθάσαι οἱ Ἰουδαῖοι, καὶ πάλιν ὑπάγεις ἐκεῖ; ");
INSERT INTO grctr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ἀπεκρίθη ὁ Ἰησοῦς, Οὐχὶ δώδεκά εἰσιν ὧραι τῆς ἡμέρας; Ἐάν τις περιπατῇ ἐν τῇ ἡμέρᾳ, οὐ προσκόπτει, ὅτι τὸ φῶς τοῦ κόσμου τούτου βλέπει. ");
INSERT INTO grctr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ἐὰν δέ τις περιπατῇ ἐν τῇ νυκτί, προσκόπτει, ὅτι τὸ φῶς οὐκ ἔστιν ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ταῦτα εἶπε, καὶ μετὰ τοῦτο λέγει αὐτοῖς, Λάζαρος ὁ φίλος ἡμῶν κεκοίμηται· ἀλλὰ πορεύομαι ἵνα ἐξυπνίσω αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Εἶπον οὖν οἱ μαθηταὶ αὐτοῦ, Κύριε, εἰ κεκοίμηται, σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Εἰρήκει δὲ ὁ Ἰησοῦς περὶ τοῦ θανάτου αὐτοῦ· ἐκεῖνοι δὲ ἔδοξαν ὅτι περὶ τῆς κοιμήσεως τοῦ ὕπνου λέγει. ");
INSERT INTO grctr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Τότε οὖν εἶπεν αὐτοῖς ὁ Ἰησοῦς παρρησίᾳ, Λάζαρος ἀπέθανε. ");
INSERT INTO grctr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Καὶ χαίρω δι᾿ ὑμᾶς, ἵνα πιστεύσητε, ὅτι οὐκ ἤμην ἐκεῖ· ἀλλ᾿ ἄγωμεν πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Εἶπεν οὖν Θωμᾶς, ὁ λεγόμενος Δίδυμος, τοῖς συμμαθηταῖς, Ἄγωμεν καὶ ἡμεῖς, ἵνα ἀποθάνωμεν μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ἐλθὼν οὖν ὁ Ἰησοῦς εὗρεν αὐτὸν τέσσαρας ἡμέρας ἤδη ἔχοντα ἐν τῷ μνημείῳ. ");
INSERT INTO grctr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ἦν δὲ ἡ Βηθανία ἐγγὺς τῶν Ἱεροσολύμων, ὡς ἀπὸ σταδίων δεκαπέντε· ");
INSERT INTO grctr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","καὶ πολλοὶ ἐκ τῶν Ἰουδαίων ἐληλύθεισαν πρὸς τὰς περὶ Μάρθαν καὶ Μαρίαν, ἵνα παραμυθήσωνται αὐτὰς περὶ τοῦ ἀδελφοῦ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ἡ οὖν Μάρθα, ὡς ἤκουσεν ὅτι ὁ Ἰησοῦς ἔρχεται, ὑπήντησεν αὐτῷ· Μαρία δὲ ἐν τῷ οἴκῳ ἐκαθέζετο. ");
INSERT INTO grctr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Εἶπεν οὖν ἡ Μάρθα πρὸς τὸν Ἰησοῦν, Κύριε, εἰ ἦς ὧδε, ὁ ἀδελφός μου οὐκ ἂν ἐτεθνήκει. ");
INSERT INTO grctr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ἀλλὰ καὶ νῦν οἶδα ὅτι ὅσα ἂν αἰτήσῃ τὸν Θεόν, δώσει σοι ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Λέγει αὐτῇ ὁ Ἰησοῦς, Ἀναστήσεται ὁ ἀδελφός σου. ");
INSERT INTO grctr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Λέγει αὐτῷ Μάρθα, Οἶδα ὅτι ἀναστήσεται ἐν τῇ ἀναστάσει ἐν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Εἶπεν αὐτῇ ὁ Ἰησοῦς, Ἐγώ εἰμι ἡ ἀνάστασις καὶ ἡ ζωή· ὁ πιστεύων εἰς ἐμέ, κἂν ἀποθάνῃ, ζήσεται· ");
INSERT INTO grctr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","καὶ πᾶς ὁ ζῶν καὶ πιστεύων εἰς ἐμέ, οὐ μὴ ἀποθάνῃ εἰς τὸν αἰῶνα. Πιστεύεις τοῦτο; ");
INSERT INTO grctr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Λέγει αὐτῷ, Ναί, Κύριε· ἐγὼ πεπίστευκα, ὅτι σὺ εἶ ὁ Χριστός, ὁ υἱὸς τοῦ Θεοῦ, ὁ εἰς τὸν κόσμον ἐρχόμενος. ");
INSERT INTO grctr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Καὶ ταῦτα εἰποῦσα ἀπῆλθε, καὶ ἐφώνησε Μαρίαν τὴν ἀδελφὴν αὐτῆς λάθρᾳ, εἰποῦσα, Ὁ διδάσκαλος πάρεστι καὶ φωνεῖ σε. ");
INSERT INTO grctr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ἐκείνη ὡς ἤκουσεν, ἐγείρεται ταχὺ καὶ ἔρχεται πρὸς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Οὔπω δὲ ἐληλύθει ὁ Ἰησοῦς εἰς τὴν κώμην, ἀλλ᾿ ἦν ἐν τῷ τόπῳ ὅπου ὑπήντησεν αὐτῷ ἡ Μάρθα. ");
INSERT INTO grctr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Οἱ οὖν Ἰουδαῖοι οἱ ὄντες μετ᾿ αὐτῆς ἐν τῇ οἰκίᾳ καὶ παραμυθούμενοι αὐτήν, ἰδόντες τὴν Μαρίαν ὅτι ταχέως ἀνέστη καὶ ἐξῆλθεν, ἠκολούθησαν αὐτῇ, λέγοντες ὅτι Ὑπάγει εἰς τὸ μνημεῖον, ἵνα κλαύσῃ ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ἡ οὖν Μαρία, ὡς ἦλθεν ὅπου ἦν ὁ Ἰησοῦς, ἰδοῦσα αὐτόν, ἔπεσεν εἰς τοὺς πόδας αὐτοῦ λέγουσα αὐτῷ, Κύριε, εἰ ἦς ὧδε, οὐκ ἂν ἀπέθανέ μου ὁ ἀδελφός. ");
INSERT INTO grctr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ἰησοῦς οὖν ὡς εἶδεν αὐτὴν κλαίουσαν, καὶ τοὺς συνελθόντας αὐτῇ Ἰουδαίους κλαίοντας, ἐνεβριμήσατο τῷ πνεύματι, καὶ ἐτάραξεν ἑαυτόν, ");
INSERT INTO grctr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","καὶ εἶπε, Ποῦ τεθείκατε αὐτόν; Λέγουσιν αὐτῷ, Κύριε, ἔρχου καὶ ἴδε. ");
INSERT INTO grctr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ἐδάκρυσεν ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ἔλεγον οὖν οἱ Ἰουδαῖοι, Ἴδε πῶς ἐφίλει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Τινὲς δὲ ἐξ αὐτῶν εἶπον, Οὐκ ἠδύνατο οὗτος, ὁ ἀνοίξας τοὺς ὀφθαλμοὺς τοῦ τυφλοῦ, ποιῆσαι ἵνα καὶ οὗτος μὴ ἀποθάνῃ; ");
INSERT INTO grctr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ἰησοῦς οὖν πάλιν ἐμβριμώμενος ἐν ἑαυτῷ ἔρχεται εἰς τὸ μνημεῖον. Ἦν δὲ σπήλαιον, καὶ λίθος ἐπέκειτο ἐπ᾿ αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Λέγει ὁ Ἰησοῦς, Ἄρατε τὸν λίθον. Λέγει αὐτῷ ἡ ἀδελφὴ τοῦ τεθνηκότος Μάρθα, Κύριε, ἤδη ὄζει· τεταρταῖος γάρ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Λέγει αὐτῇ ὁ Ἰησοῦς, Οὐκ εἶπόν σοι ὅτι ἐὰν πιστεύσῃς, ὄψει τὴν δόξαν τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ἦραν οὖν τὸν λίθον, οὗ ἦν ὁ τεθνηκὼς κείμενος. Ὁ δὲ Ἰησοῦς ἦρε τοὺς ὀφθαλμοὺς ἄνω, καὶ εἶπε, Πάτερ, εὐχαριστῶ σοι ὅτι ἤκουσάς μου. ");
INSERT INTO grctr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ἐγὼ δὲ ᾔδειν ὅτι πάντοτέ μου ἀκούεις· ἀλλὰ διὰ τὸν ὄχλον τὸν περιεστῶτα εἶπον, ἵνα πιστεύσωσιν ὅτι σύ με ἀπέστειλας. ");
INSERT INTO grctr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Καὶ ταῦτα εἰπών, φωνῇ μεγάλῃ ἐκραύγασε, Λάζαρε, δεῦρο ἔξω. ");
INSERT INTO grctr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Καὶ ἐξῆλθεν ὁ τεθνηκώς, δεδεμένος τοὺς πόδας καὶ τὰς χεῖρας κειρίαις, καὶ ἡ ὄψις αὐτοῦ σουδαρίῳ περιεδέδετο. Λέγει αὐτοῖς ὁ Ἰησοῦς, Λύσατε αὐτόν, καὶ ἄφετε ὑπάγειν. ");
INSERT INTO grctr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Πολλοὶ οὖν ἐκ τῶν Ἰουδαίων, οἱ ἐλθόντες πρὸς τὴν Μαρίαν καὶ θεασάμενοι ἃ ἐποίησεν ὁ Ἰησοῦς, ἐπίστευσαν εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Τινὲς δὲ ἐξ αὐτῶν ἀπῆλθον πρὸς τοὺς Φαρισαίους, καὶ εἶπον αὐτοῖς ἃ ἐποίησεν ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Συνήγαγον οὖν οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι συνέδριον, καὶ ἔλεγον, Τί ποιοῦμεν; Ὅτι οὗτος ὁ ἄνθρωπος πολλὰ σημεῖα ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ἐὰν ἀφῶμεν αὐτὸν οὕτω, πάντες πιστεύσουσιν εἰς αὐτόν· καὶ ἐλεύσονται οἱ Ῥωμαῖοι καὶ ἀροῦσιν ἡμῶν καὶ τὸν τόπον καὶ τὸ ἔθνος. ");
INSERT INTO grctr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Εἷς δέ τις ἐξ αὐτῶν Καϊάφας, ἀρχιερεὺς ὢν τοῦ ἐνιαυτοῦ ἐκείνου, εἶπεν αὐτοῖς, Ὑμεῖς οὐκ οἴδατε οὐδέν, ");
INSERT INTO grctr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","οὐδὲ διαλογίζεσθε ὅτι συμφέρει ἡμῖν ἵνα εἷς ἄνθρωπος ἀποθάνῃ ὑπὲρ τοῦ λαοῦ, καὶ μὴ ὅλον τὸ ἔθνος ἀπόληται. ");
INSERT INTO grctr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Τοῦτο δὲ ἀφ᾿ ἑαυτοῦ οὐκ εἶπεν, ἀλλὰ ἀρχιερεὺς ὢν τοῦ ἐνιαυτοῦ ἐκείνου, προεφήτευσεν ὅτι ἔμελλεν ὁ Ἰησοῦς ἀποθνῄσκειν ὑπὲρ τοῦ ἔθνους, ");
INSERT INTO grctr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","καὶ οὐχ ὑπὲρ τοῦ ἔθνους μόνον, ἀλλ᾿ ἵνα καὶ τὰ τέκνα τοῦ Θεοῦ τὰ διεσκορπισμένα συναγάγῃ εἰς ἕν. ");
INSERT INTO grctr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ἀπ᾿ ἐκείνης οὖν τῆς ἡμέρας συνεβουλεύσαντο ἵνα ἀποκτείνωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ἰησοῦς οὖν οὐκέτι παρρησίᾳ περιεπάτει ἐν τοῖς Ἰουδαίοις, ἀλλὰ ἀπῆλθεν ἐκεῖθεν εἰς τὴν χώραν ἐγγὺς τῆς ἐρήμου, εἰς Ἐφραῒμ λεγομένην πόλιν, κἀκεῖ διέτριβε μετὰ τῶν μαθητῶν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ἦν δὲ ἐγγὺς τὸ Πάσχα τῶν Ἰουδαίων· καὶ ἀνέβησαν πολλοὶ εἰς Ἱεροσόλυμα ἐκ τῆς χώρας πρὸ τοῦ Πάσχα, ἵνα ἁγνίσωσιν ἑαυτούς. ");
INSERT INTO grctr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ἐζήτουν οὖν τὸν Ἰησοῦν, καὶ ἔλεγον μετ᾿ ἀλλήλων ἐν τῷ ἱερῷ ἑστηκότες, Τί δοκεῖ ὑμῖν; Ὅτι οὐ μὴ ἔλθῃ εἰς τὴν ἑορτήν; ");
INSERT INTO grctr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Δεδώκεισαν δὲ καὶ οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι ἐντολήν, ἵνα ἐάν τις γνῷ ποῦ ἐστι, μηνύσῃ, ὅπως πιάσωσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ὁ οὖν Ἰησοῦς πρὸ ἓξ ἡμερῶν τοῦ Πάσχα ἦλθεν εἰς Βηθανίαν, ὅπου ἦν Λάζαρος ὁ τεθνηκώς, ὃν ἤγειρεν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ἐποίησαν οὖν αὐτῷ δεῖπνον ἐκεῖ, καὶ ἡ Μάρθα διηκόνει· ὁ δὲ Λάζαρος εἷς ἦν τῶν συνανακειμένων αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ἡ οὖν Μαρία λαβοῦσα λίτραν μύρου νάρδου πιστικῆς πολυτίμου, ἤλειψε τοὺς πόδας τοῦ Ἰησοῦ, καὶ ἐξέμαξε ταῖς θριξὶν αὐτῆς τοὺς πόδας αὐτοῦ· ἡ δὲ οἰκία ἐπληρώθη ἐκ τῆς ὀσμῆς τοῦ μύρου. ");
INSERT INTO grctr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Λέγει οὖν εἷς ἐκ τῶν μαθητῶν αὐτοῦ, Ἰούδας Σίμωνος Ἰσκαριώτης, ὁ μέλλων αὐτὸν παραδιδόναι, ");
INSERT INTO grctr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Διὰ τί τοῦτο τὸ μύρον οὐκ ἐπράθη τριακοσίων δηναρίων, καὶ ἐδόθη πτωχοῖς; ");
INSERT INTO grctr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Εἶπε δὲ τοῦτο, οὐχ ὅτι περὶ τῶν πτωχῶν ἔμελεν αὐτῷ, ἀλλ᾿ ὅτι κλέπτης ἦν, καὶ τὸ γλωσσόκομον εἶχε, καὶ τὰ βαλλόμενα ἐβάσταζεν. ");
INSERT INTO grctr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Εἶπεν οὖν ὁ Ἰησοῦς, Ἄφες αὐτήν· εἰς τὴν ἡμέραν τοῦ ἐνταφιασμοῦ μου τετήρηκεν αὐτό. ");
INSERT INTO grctr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Τοὺς πτωχοὺς γὰρ πάντοτε ἔχετε μεθ᾿ ἑαυτῶν, ἐμὲ δὲ οὐ πάντοτε ἔχετε. ");
INSERT INTO grctr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ἔγνω οὖν ὄχλος πολὺς ἐκ τῶν Ἰουδαίων ὅτι ἐκεῖ ἐστι· καὶ ἦλθον οὐ διὰ τὸν Ἰησοῦν μόνον, ἀλλ᾿ ἵνα καὶ τὸν Λάζαρον ἴδωσιν, ὃν ἤγειρεν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ἐβουλεύσαντο δὲ οἱ ἀρχιερεῖς ἵνα καὶ τὸν Λάζαρον ἀποκτείνωσιν· ");
INSERT INTO grctr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ὅτι πολλοὶ δι᾿ αὐτὸν ὑπῆγον τῶν Ἰουδαίων, καὶ ἐπίστευον εἰς τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Τῇ ἐπαύριον ὄχλος πολὺς ὁ ἐλθὼν εἰς τὴν ἑορτήν, ἀκούσαντες ὅτι ἔρχεται ὁ Ἰησοῦς εἰς Ἱεροσόλυμα, ");
INSERT INTO grctr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ἔλαβον τὰ βαΐα τῶν φοινίκων, καὶ ἐξῆλθον εἰς ὑπάντησιν αὐτῷ, καὶ ἔκραζον, Ὡσαννά· εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι Κυρίου, ὁ βασιλεὺς τοῦ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Εὑρὼν δὲ ὁ Ἰησοῦς ὀνάριον, ἐκάθισεν ἐπ᾿ αὐτό, καθώς ἐστι γεγραμμένον, ");
INSERT INTO grctr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Μὴ φοβοῦ, θύγατερ Σιών· ἰδού, ὁ βασιλεύς σου ἔρχεται, καθήμενος ἐπὶ πῶλον ὄνου. ");
INSERT INTO grctr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ταῦτα δὲ οὐκ ἔγνωσαν οἱ μαθηταὶ αὐτοῦ τὸ πρῶτον· ἀλλ᾿ ὅτε ἐδοξάσθη ὁ Ἰησοῦς, τότε ἐμνήσθησαν ὅτι ταῦτα ἦν ἐπ᾿ αὐτῷ γεγραμμένα, καὶ ταῦτα ἐποίησαν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ἐμαρτύρει οὖν ὁ ὄχλος ὁ ὢν μετ᾿ αὐτοῦ ὅτε τὸν Λάζαρον ἐφώνησεν ἐκ τοῦ μνημείου, καὶ ἤγειρεν αὐτὸν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Διὰ τοῦτο καὶ ὑπήντησεν αὐτῷ ὁ ὄχλος, ὅτι ἤκουσε τοῦτο αὐτὸν πεποιηκέναι τὸ σημεῖον. ");
INSERT INTO grctr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Οἱ οὖν Φαρισαῖοι εἶπον πρὸς ἑαυτούς, Θεωρεῖτε ὅτι οὐκ ὠφελεῖτε οὐδέν; ἴδε ὁ κόσμος ὀπίσω αὐτοῦ ἀπῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ἦσαν δέ τινες Ἕλληνες ἐκ τῶν ἀναβαινόντων ἵνα προσκυνήσωσιν ἐν τῇ ἑορτῇ· ");
INSERT INTO grctr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","οὗτοι οὖν προσῆλθον Φιλίππῳ τῷ ἀπὸ Βηθσαϊδὰ τῆς Γαλιλαίας, καὶ ἠρώτων αὐτὸν λέγοντες, Κύριε, θέλομεν τὸν Ἰησοῦν ἰδεῖν. ");
INSERT INTO grctr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ἔρχεται Φίλιππος καὶ λέγει τῷ Ἀνδρέᾳ· καὶ πάλιν Ἀνδρέας καὶ Φίλιππος λέγουσι τῷ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ὁ δὲ Ἰησοῦς ἀπεκρίνατο αὐτοῖς λέγων, Ἐλήλυθεν ἡ ὥρα ἵνα δοξασθῇ ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ἀμὴν ἀμὴν λέγω ὑμῖν, ἐὰν μὴ ὁ κόκκος τοῦ σίτου πεσὼν εἰς τὴν γῆν ἀποθάνῃ, αὐτὸς μόνος μένει· ἐὰν δὲ ἀποθάνῃ, πολὺν καρπὸν φέρει. ");
INSERT INTO grctr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ὁ φιλῶν τὴν ψυχὴν αὐτοῦ ἀπολέσει αὐτήν· καὶ ὁ μισῶν τὴν ψυχὴν αὐτοῦ ἐν τῷ κόσμῳ τούτῳ εἰς ζωὴν αἰώνιον φυλάξει αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ἐὰν ἐμοὶ διακονῇ τις, ἐμοὶ ἀκολουθείτω· καὶ ὅπου εἰμὶ ἐγώ, ἐκεῖ καὶ ὁ διάκονος ὁ ἐμὸς ἔσται· καὶ ἐάν τις ἐμοὶ διακονῇ, τιμήσει αὐτὸν ὁ πατήρ. ");
INSERT INTO grctr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Νῦν ἡ ψυχή μου τετάρακται· καὶ τί εἴπω; Πάτερ, σῶσόν με ἐκ τῆς ὥρας ταύτης. Ἀλλὰ διὰ τοῦτο ἦλθον εἰς τὴν ὥραν ταύτην. ");
INSERT INTO grctr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Πάτερ, δόξασόν σου τὸ ὄνομα. Ἦλθεν οὖν φωνὴ ἐκ τοῦ οὐρανοῦ, Καὶ ἐδόξασα, καὶ πάλιν δοξάσω. ");
INSERT INTO grctr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ὁ οὖν ὄχλος ὁ ἑστὼς καὶ ἀκούσας ἔλεγε βροντὴν γεγονέναι· ἄλλοι ἔλεγον, Ἄγγελος αὐτῷ λελάληκεν. ");
INSERT INTO grctr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν, Οὐ δι᾿ ἐμὲ αὕτη ἡ φωνὴ γέγονεν, ἀλλὰ δι᾿ ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Νῦν κρίσις ἐστὶ τοῦ κόσμου τούτου· νῦν ὁ ἄρχων τοῦ κόσμου τούτου ἐκβληθήσεται ἔξω. ");
INSERT INTO grctr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Κἀγὼ ἐὰν ὑψωθῶ ἐκ τῆς γῆς, πάντας ἑλκύσω πρὸς ἐμαυτόν. ");
INSERT INTO grctr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Τοῦτο δὲ ἔλεγε, σημαίνων ποίῳ θανάτῳ ἤμελλεν ἀποθνῄσκειν. ");
INSERT INTO grctr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ἀπεκρίθη αὐτῷ ὁ ὄχλος, Ἡμεῖς ἠκούσαμεν ἐκ τοῦ νόμου ὅτι ὁ Χριστὸς μένει εἰς τὸν αἰῶνα· καὶ πῶς σὺ λέγεις ὅτι Δεῖ ὑψωθῆναι τὸν υἱὸν τοῦ ἀνθρώπου; Τίς ἐστιν οὗτος ὁ υἱὸς τοῦ ἀνθρώπου; ");
INSERT INTO grctr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς, Ἔτι μικρὸν χρόνον τὸ φῶς μεθ᾿ ὑμῶν ἐστι. Περιπατεῖτε ἕως τὸ φῶς ἔχετε, ἵνα μὴ σκοτία ὑμᾶς καταλάβῃ· καὶ ὁ περιπατῶν ἐν τῇ σκοτίᾳ οὐκ οἶδε ποῦ ὑπάγει. ");
INSERT INTO grctr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ἕως τὸ φῶς ἔχετε, πιστεύετε εἰς τὸ φῶς, ἵνα υἱοὶ φωτὸς γένησθε. Ταῦτα ἐλάλησεν ὁ Ἰησοῦς, καὶ ἀπελθὼν ἐκρύβη ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Τοσαῦτα δὲ αὐτοῦ σημεῖα πεποιηκότος ἔμπροσθεν αὐτῶν, οὐκ ἐπίστευον εἰς αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ἵνα ὁ λόγος Ἠσαΐου τοῦ προφήτου πληρωθῇ, ὃν εἶπε, Κύριε, τίς ἐπίστευσε τῇ ἀκοῇ ἡμῶν; Καὶ ὁ βραχίων Κυρίου τίνι ἀπεκαλύφθη; ");
INSERT INTO grctr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Διὰ τοῦτο οὐκ ἠδύναντο πιστεύειν, ὅτι πάλιν εἶπεν Ἠσαΐας, ");
INSERT INTO grctr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Τετύφλωκεν αὐτῶν τοὺς ὀφθαλμούς, καὶ πεπώρωκεν αὐτῶν τὴν καρδίαν· ἵνα μὴ ἴδωσι τοῖς ὀφθαλμοῖς, καὶ νοήσωσι τῇ καρδίᾳ, καὶ ἐπιστραφῶσι, καὶ ἰάσωμαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ταῦτα εἶπεν Ἠσαΐας, ὅτε εἶδε τὴν δόξαν αὐτοῦ, καὶ ἐλάλησε περὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ὅμως μέντοι καὶ ἐκ τῶν ἀρχόντων πολλοὶ ἐπίστευσαν εἰς αὐτόν· ἀλλὰ διὰ τοὺς Φαρισαίους οὐχ ὡμολόγουν, ἵνα μὴ ἀποσυνάγωγοι γένωνται. ");
INSERT INTO grctr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ἠγάπησαν γὰρ τὴν δόξαν τῶν ἀνθρώπων μᾶλλον ἤπερ τὴν δόξαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ἰησοῦς δὲ ἔκραξε καὶ εἶπεν, Ὁ πιστεύων εἰς ἐμέ, οὐ πιστεύει εἰς ἐμέ, ἀλλ᾿ εἰς τὸν πέμψαντά με· ");
INSERT INTO grctr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","καὶ ὁ θεωρῶν ἐμέ, θεωρεῖ τὸν πέμψαντά με. ");
INSERT INTO grctr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ἐγὼ φῶς εἰς τὸν κόσμον ἐλήλυθα, ἵνα πᾶς ὁ πιστεύων εἰς ἐμέ, ἐν τῇ σκοτίᾳ μὴ μείνῃ. ");
INSERT INTO grctr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Καὶ ἐάν τίς μου ἀκούσῃ τῶν ῥημάτων καὶ μὴ πιστεύσῃ, ἐγὼ οὐ κρίνω αὐτόν· οὐ γὰρ ἦλθον ἵνα κρίνω τὸν κόσμον, ἀλλ᾿ ἵνα σώσω τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ὁ ἀθετῶν ἐμὲ καὶ μὴ λαμβάνων τὰ ῥήματά μου, ἔχει τὸν κρίνοντα αὐτόν· ὁ λόγος ὃν ἐλάλησα, ἐκεῖνος κρινεῖ αὐτὸν ἐν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ὅτι ἐγὼ ἐξ ἐμαυτοῦ οὐκ ἐλάλησα· ἀλλ᾿ ὁ πέμψας με πατήρ, αὐτός μοι ἐντολὴν ἔδωκε, τί εἴπω καὶ τί λαλήσω. ");
INSERT INTO grctr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Καὶ οἶδα ὅτι ἡ ἐντολὴ αὐτοῦ ζωὴ αἰώνιός ἐστιν· ἃ οὖν λαλῶ ἐγώ, καθὼς εἴρηκέ μοι ὁ πατήρ, οὕτω λαλῶ. ");
INSERT INTO grctr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Πρὸ δὲ τῆς ἑορτῆς τοῦ Πάσχα, εἰδὼς ὁ Ἰησοῦς ὅτι ἐλήλυθεν αὐτοῦ ἡ ὥρα ἵνα μεταβῇ ἐκ τοῦ κόσμου τούτου πρὸς τὸν πατέρα, ἀγαπήσας τοὺς ἰδίους τοὺς ἐν τῷ κόσμῳ, εἰς τέλος ἠγάπησεν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Καὶ δείπνου γενομένου, τοῦ διαβόλου ἤδη βεβληκότος εἰς τὴν καρδίαν Ἰούδα Σίμωνος Ἰσκαριώτου ἵνα αὐτὸν παραδῷ, ");
INSERT INTO grctr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","εἰδὼς ὁ Ἰησοῦς ὅτι πάντα δέδωκεν αὐτῷ ὁ πατὴρ εἰς τὰς χεῖρας, καὶ ὅτι ἀπὸ Θεοῦ ἐξῆλθε καὶ πρὸς τὸν Θεὸν ὑπάγει, ");
INSERT INTO grctr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ἐγείρεται ἐκ τοῦ δείπνου, καὶ τίθησι τὰ ἱμάτια, καὶ λαβὼν λέντιον διέζωσεν ἑαυτόν. ");
INSERT INTO grctr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Εἶτα βάλλει ὕδωρ εἰς τὸν νιπτῆρα, καὶ ἤρξατο νίπτειν τοὺς πόδας τῶν μαθητῶν, καὶ ἐκμάσσειν τῷ λεντίῳ ᾧ ἦν διεζωσμένος. ");
INSERT INTO grctr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ἔρχεται οὖν πρὸς Σίμωνα Πέτρον· καὶ λέγει αὐτῷ ἐκεῖνος, Κύριε, σύ μου νίπτεις τοὺς πόδας; ");
INSERT INTO grctr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ, Ὃ ἐγὼ ποιῶ, σὺ οὐκ οἶδας ἄρτι, γνώσῃ δὲ μετὰ ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Λέγει αὐτῷ Πέτρος, Οὐ μὴ νίψῃς τοὺς πόδας μου εἰς τὸν αἰῶνα. Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Ἐὰν μὴ νίψω σε, οὐκ ἔχεις μέρος μετ᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Λέγει αὐτῷ Σίμων Πέτρος, Κύριε, μὴ τοὺς πόδας μου μόνον, ἀλλὰ καὶ τὰς χεῖρας καὶ τὴν κεφαλήν. ");
INSERT INTO grctr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Λέγει αὐτῷ ὁ Ἰησοῦς, Ὁ λελουμένος οὐ χρείαν ἔχει ἢ τοὺς πόδας νίψασθαι, ἀλλ᾿ ἔστι καθαρὸς ὅλος· καὶ ὑμεῖς καθαροί ἐστε, ἀλλ᾿ οὐχὶ πάντες. ");
INSERT INTO grctr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ᾜδει γὰρ τὸν παραδιδόντα αὐτόν· διὰ τοῦτο εἶπεν, Οὐχὶ πάντες καθαροί ἐστε. ");
INSERT INTO grctr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ὅτε οὖν ἔνιψε τοὺς πόδας αὐτῶν, καὶ ἔλαβε τὰ ἱμάτια αὐτοῦ, ἀναπεσὼν πάλιν, εἶπεν αὐτοῖς, Γινώσκετε τί πεποίηκα ὑμῖν; ");
INSERT INTO grctr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ὑμεῖς φωνεῖτέ με, Ὁ διδάσκαλος, καὶ Ὁ Κύριος· καὶ καλῶς λέγετε, εἰμὶ γάρ. ");
INSERT INTO grctr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Εἰ οὖν ἐγὼ ἔνιψα ὑμῶν τοὺς πόδας, ὁ Κύριος καὶ ὁ διδάσκαλος, καὶ ὑμεῖς ὀφείλετε ἀλλήλων νίπτειν τοὺς πόδας. ");
INSERT INTO grctr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ὑπόδειγμα γὰρ ἔδωκα ὑμῖν, ἵνα καθὼς ἐγὼ ἐποίησα ὑμῖν, καὶ ὑμεῖς ποιῆτε. ");
INSERT INTO grctr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ἀμὴν ἀμὴν λέγω ὑμῖν, Οὐκ ἔστι δοῦλος μείζων τοῦ κυρίου αὐτοῦ, οὐδὲ ἀπόστολος μείζων τοῦ πέμψαντος αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Εἰ ταῦτα οἴδατε, μακάριοί ἐστε ἐὰν ποιῆτε αὐτά. ");
INSERT INTO grctr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Οὐ περὶ πάντων ὑμῶν λέγω· ἐγὼ οἶδα οὓς ἐξελεξάμην· ἀλλ᾿ ἵνα ἡ γραφὴ πληρωθῇ, Ὁ τρώγων μετ᾿ ἐμοῦ τὸν ἄρτον ἐπῆρεν ἐπ᾿ ἐμὲ τὴν πτέρναν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ἀπ᾿ ἄρτι λέγω ὑμῖν πρὸ τοῦ γενέσθαι, ἵνα, ὅταν γένηται, πιστεύσητε ὅτι ἐγώ εἰμι. ");
INSERT INTO grctr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ἀμὴν ἀμὴν λέγω ὑμῖν, Ὁ λαμβάνων ἐάν τινα πέμψω, ἐμὲ λαμβάνει· ὁ δὲ ἐμὲ λαμβάνων, λαμβάνει τὸν πέμψαντά με. ");
INSERT INTO grctr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ταῦτα εἰπὼν ὁ Ἰησοῦς ἐταράχθη τῷ πνεύματι, καὶ ἐμαρτύρησε καὶ εἶπεν, Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με. ");
INSERT INTO grctr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ἔβλεπον οὖν εἰς ἀλλήλους οἱ μαθηταί, ἀπορούμενοι περὶ τίνος λέγει. ");
INSERT INTO grctr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ἦν δὲ ἀνακείμενος εἷς τῶν μαθητῶν αὐτοῦ ἐν τῷ κόλπῳ τοῦ Ἰησοῦ, ὃν ἠγάπα ὁ Ἰησοῦς· ");
INSERT INTO grctr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","νεύει οὖν τούτῳ Σίμων Πέτρος πυθέσθαι τίς ἂν εἴη περὶ οὗ λέγει. ");
INSERT INTO grctr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ἐπιπεσὼν δὲ ἐκεῖνος ἐπὶ τὸ στῆθος τοῦ Ἰησοῦ, λέγει αὐτῷ, Κύριε, τίς ἐστιν; ");
INSERT INTO grctr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ἀποκρίνεται ὁ Ἰησοῦς, Ἐκεῖνός ἐστιν ᾧ ἐγὼ βάψας τὸ ψωμίον ἐπιδώσω. Καὶ ἐμβάψας τὸ ψωμίον, δίδωσιν Ἰούδᾳ Σίμωνος Ἰσκαριώτῃ. ");
INSERT INTO grctr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Καὶ μετὰ τὸ ψωμίον, τότε εἰσῆλθεν εἰς ἐκεῖνον ὁ Σατανᾶς. Λέγει οὖν αὐτῷ ὁ Ἰησοῦς, Ὃ ποιεῖς, ποίησον τάχιον. ");
INSERT INTO grctr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Τοῦτο δὲ οὐδεὶς ἔγνω τῶν ἀνακειμένων πρὸς τί εἶπεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Τινὲς γὰρ ἐδόκουν, ἐπεὶ τὸ γλωσσόκομον εἶχεν ὁ Ἰούδας, ὅτι λέγει αὐτῷ ὁ Ἰησοῦς, Ἀγόρασον ὧν χρείαν ἔχομεν εἰς τὴν ἑορτήν· ἢ τοῖς πτωχοῖς ἵνα τι δῷ. ");
INSERT INTO grctr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Λαβὼν οὖν τὸ ψωμίον ἐκεῖνος, εὐθέως ἐξῆλθεν· ἦν δὲ νύξ. ");
INSERT INTO grctr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ὅτε οὖν ἐξῆλθε, λέγει ὁ Ἰησοῦς, Νῦν ἐδοξάσθη ὁ υἱὸς τοῦ ἀνθρώπου, καὶ ὁ Θεὸς ἐδοξάσθη ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Εἰ ὁ Θεὸς ἐδοξάσθη ἐν αὐτῷ, καὶ ὁ Θεὸς δοξάσει αὐτὸν ἐν ἑαυτῷ, καὶ εὐθὺς δοξάσει αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Τεκνία, ἔτι μικρὸν μεθ᾿ ὑμῶν εἰμι. Ζητήσετέ με, καὶ καθὼς εἶπον τοῖς Ἰουδαίοις ὅτι Ὅπου ὑπάγω ἐγώ, ὑμεῖς οὐ δύνασθε ἐλθεῖν, καὶ ὑμῖν λέγω ἄρτι. ");
INSERT INTO grctr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ἐντολὴν καινὴν δίδωμι ὑμῖν, ἵνα ἀγαπᾶτε ἀλλήλους· καθὼς ἠγάπησα ὑμᾶς, ἵνα καὶ ὑμεῖς ἀγαπᾶτε ἀλλήλους. ");
INSERT INTO grctr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ἐν τούτῳ γνώσονται πάντες ὅτι ἐμοὶ μαθηταί ἐστε, ἐὰν ἀγάπην ἔχητε ἐν ἀλλήλοις. ");
INSERT INTO grctr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Λέγει αὐτῷ Σίμων Πέτρος, Κύριε, ποῦ ὑπάγεις; Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Ὅπου ὑπάγω, οὐ δύνασαί μοι νῦν ἀκολουθῆσαι, ὕστερον δὲ ἀκολουθήσεις μοι. ");
INSERT INTO grctr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Λέγει αὐτῷ ὁ Πέτρος, Κύριε, διὰ τί οὐ δύναμαί σοι ἀκολουθῆσαι ἄρτι; Τὴν ψυχήν μου ὑπὲρ σοῦ θήσω. ");
INSERT INTO grctr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Τὴν ψυχήν σου ὑπὲρ ἐμοῦ θήσεις; Ἀμὴν ἀμὴν λέγω σοι, οὐ μὴ ἀλέκτωρ φωνήσει ἕως οὗ ἀπαρνήσῃ με τρίς. ");
INSERT INTO grctr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Μὴ ταρασσέσθω ὑμῶν ἡ καρδία· πιστεύετε εἰς τὸν Θεόν, καὶ εἰς ἐμὲ πιστεύετε. ");
INSERT INTO grctr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ἐν τῇ οἰκίᾳ τοῦ πατρός μου μοναὶ πολλαί εἰσιν· εἰ δὲ μή, εἶπον ἂν ὑμῖν· Πορεύομαι ἑτοιμάσαι τόπον ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Καὶ ἐὰν πορευθῶ καὶ ἑτοιμάσω ὑμῖν τόπον, πάλιν ἔρχομαι καὶ παραλήψομαι ὑμᾶς πρὸς ἐμαυτόν, ἵνα ὅπου εἰμὶ ἐγώ, καὶ ὑμεῖς ἦτε. ");
INSERT INTO grctr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Καὶ ὅπου ἐγὼ ὑπάγω οἴδατε, καὶ τὴν ὁδὸν οἴδατε. ");
INSERT INTO grctr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Λέγει αὐτῷ Θωμᾶς, Κύριε, οὐκ οἴδαμεν ποῦ ὑπάγεις· καὶ πῶς δυνάμεθα τὴν ὁδὸν εἰδέναι; ");
INSERT INTO grctr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Λέγει αὐτῷ ὁ Ἰησοῦς, Ἐγώ εἰμι ἡ ὁδὸς καὶ ἡ ἀλήθεια καὶ ἡ ζωή· οὐδεὶς ἔρχεται πρὸς τὸν πατέρα, εἰ μὴ δι᾿ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Εἰ ἐγνώκειτέ με, καὶ τὸν πατέρα μου ἐγνώκειτε ἄν· καὶ ἀπ᾿ ἄρτι γινώσκετε αὐτόν, καὶ ἑωράκατε αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Λέγει αὐτῷ Φίλιππος, Κύριε, δεῖξον ἡμῖν τὸν πατέρα, καὶ ἀρκεῖ ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Λέγει αὐτῷ ὁ Ἰησοῦς, Τοσοῦτον χρόνον μεθ᾿ ὑμῶν εἰμι, καὶ οὐκ ἔγνωκάς με, Φίλιππε; Ὁ ἑωρακὼς ἐμέ, ἑώρακε τὸν πατέρα· καὶ πῶς σὺ λέγεις, Δεῖξον ἡμῖν τὸν πατέρα; ");
INSERT INTO grctr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Οὐ πιστεύεις ὅτι ἐγὼ ἐν τῷ πατρί, καὶ ὁ πατὴρ ἐν ἐμοί ἐστι; Τὰ ῥήματα ἃ ἐγὼ λαλῶ ὑμῖν, ἀπ᾿ ἐμαυτοῦ οὐ λαλῶ· ὁ δὲ πατὴρ ὁ ἐν ἐμοὶ μένων, αὐτὸς ποιεῖ τὰ ἔργα. ");
INSERT INTO grctr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Πιστεύετέ μοι ὅτι ἐγὼ ἐν τῷ πατρί, καὶ ὁ πατὴρ ἐν ἐμοί· εἰ δὲ μή, διὰ τὰ ἔργα αὐτὰ πιστεύετέ μοι. ");
INSERT INTO grctr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ πιστεύων εἰς ἐμέ, τὰ ἔργα ἃ ἐγὼ ποιῶ κἀκεῖνος ποιήσει, καὶ μείζονα τούτων ποιήσει· ὅτι ἐγὼ πρὸς τὸν πατέρα μου πορεύομαι. ");
INSERT INTO grctr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Καὶ ὅ τι ἂν αἰτήσητε ἐν τῷ ὀνόματί μου, τοῦτο ποιήσω, ἵνα δοξασθῇ ὁ πατὴρ ἐν τῷ υἱῷ. ");
INSERT INTO grctr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ἐάν τι αἰτήσητε ἐν τῷ ὀνόματί μου, ἐγὼ ποιήσω. ");
INSERT INTO grctr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ἐὰν ἀγαπᾶτέ με, τὰς ἐντολὰς τὰς ἐμὰς τηρήσατε. ");
INSERT INTO grctr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Καὶ ἐγὼ ἐρωτήσω τὸν πατέρα, καὶ ἄλλον παράκλητον δώσει ὑμῖν, ἵνα μένῃ μεθ᾿ ὑμῶν εἰς τὸν αἰῶνα, ");
INSERT INTO grctr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","τὸ πνεῦμα τῆς ἀληθείας, ὃ ὁ κόσμος οὐ δύναται λαβεῖν, ὅτι οὐ θεωρεῖ αὐτό, οὐδὲ γινώσκει αὐτό. Ὑμεῖς δὲ γινώσκετε αὐτό, ὅτι παρ᾿ ὑμῖν μένει, καὶ ἐν ὑμῖν ἔσται. ");
INSERT INTO grctr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Οὐκ ἀφήσω ὑμᾶς ὀρφανούς· ἔρχομαι πρὸς ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ἔτι μικρὸν καὶ ὁ κόσμος με οὐκέτι θεωρεῖ, ὑμεῖς δὲ θεωρεῖτέ με· ὅτι ἐγὼ ζῶ, καὶ ὑμεῖς ζήσεσθε. ");
INSERT INTO grctr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ἐν ἐκείνῃ τῇ ἡμέρᾳ γνώσεσθε ὑμεῖς ὅτι ἐγὼ ἐν τῷ πατρί μου, καὶ ὑμεῖς ἐν ἐμοί, κἀγὼ ἐν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ὁ ἔχων τὰς ἐντολάς μου καὶ τηρῶν αὐτάς, ἐκεῖνός ἐστιν ὁ ἀγαπῶν με· ὁ δὲ ἀγαπῶν με, ἀγαπηθήσεται ὑπὸ τοῦ πατρός μου· καὶ ἐγὼ ἀγαπήσω αὐτόν, καὶ ἐμφανίσω αὐτῷ ἐμαυτόν. ");
INSERT INTO grctr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Λέγει αὐτῷ Ἰούδας, οὐχ ὁ Ἰσκαριώτης, Κύριε, τί γέγονεν ὅτι ἡμῖν μέλλεις ἐμφανίζειν σεαυτόν, καὶ οὐχὶ τῷ κόσμῳ; ");
INSERT INTO grctr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ἀπεκρίθη ὁ Ἰησοῦς καὶ εἶπεν αὐτῷ, Ἐάν τις ἀγαπᾷ με, τὸν λόγον μου τηρήσει, καὶ ὁ πατήρ μου ἀγαπήσει αὐτόν, καὶ πρὸς αὐτὸν ἐλευσόμεθα, καὶ μονὴν παρ᾿ αὐτῷ ποιήσομεν. ");
INSERT INTO grctr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ὁ μὴ ἀγαπῶν με, τοὺς λόγους μου οὐ τηρεῖ· καὶ ὁ λόγος ὃν ἀκούετε οὐκ ἔστιν ἐμός, ἀλλὰ τοῦ πέμψαντός με πατρός. ");
INSERT INTO grctr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ταῦτα λελάληκα ὑμῖν παρ᾿ ὑμῖν μένων. ");
INSERT INTO grctr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ὁ δὲ παράκλητος, τὸ πνεῦμα τὸ ἅγιον, ὃ πέμψει ὁ πατὴρ ἐν τῷ ὀνόματί μου, ἐκεῖνος ὑμᾶς διδάξει πάντα, καὶ ὑπομνήσει ὑμᾶς πάντα ἃ εἶπον ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Εἰρήνην ἀφίημι ὑμῖν, εἰρήνην τὴν ἐμὴν δίδωμι ὑμῖν· οὐ καθὼς ὁ κόσμος δίδωσιν, ἐγὼ δίδωμι ὑμῖν. Μὴ ταρασσέσθω ὑμῶν ἡ καρδία, μηδὲ δειλιάτω. ");
INSERT INTO grctr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ἠκούσατε ὅτι ἐγὼ εἶπον ὑμῖν, Ὑπάγω καὶ ἔρχομαι πρὸς ὑμᾶς. Εἰ ἠγαπᾶτέ με, ἐχάρητε ἂν ὅτι εἶπον, Πορεύομαι πρὸς τὸν πατέρα· ὅτι ὁ πατήρ μου μείζων μού ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Καὶ νῦν εἴρηκα ὑμῖν πρὶν γενέσθαι· ἵνα, ὅταν γένηται, πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Οὐκέτι πολλὰ λαλήσω μεθ᾿ ὑμῶν· ἔρχεται γὰρ ὁ τοῦ κόσμου τούτου ἄρχων, καὶ ἐν ἐμοὶ οὐκ ἔχει οὐδέν· ");
INSERT INTO grctr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ἀλλ᾿ ἵνα γνῷ ὁ κόσμος ὅτι ἀγαπῶ τὸν πατέρα, καὶ καθὼς ἐνετείλατό μοι ὁ πατήρ, οὕτω ποιῶ. Ἐγείρεσθε, ἄγωμεν ἐντεῦθεν. ");
INSERT INTO grctr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ἐγώ εἰμι ἡ ἄμπελος ἡ ἀληθινή, καὶ ὁ πατήρ μου ὁ γεωργός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Πᾶν κλῆμα ἐν ἐμοὶ μὴ φέρον καρπόν, αἴρει αὐτό· καὶ πᾶν τὸ καρπὸν φέρον, καθαίρει αὐτό, ἵνα πλείονα καρπὸν φέρῃ. ");
INSERT INTO grctr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ἤδη ὑμεῖς καθαροί ἐστε διὰ τὸν λόγον ὃν λελάληκα ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Μείνατε ἐν ἐμοί, κἀγὼ ἐν ὑμῖν. Καθὼς τὸ κλῆμα οὐ δύναται καρπὸν φέρειν ἀφ᾿ ἑαυτοῦ, ἐὰν μὴ μείνῃ ἐν τῇ ἀμπέλῳ, οὕτως οὐδὲ ὑμεῖς, ἐὰν μὴ ἐν ἐμοὶ μείνητε. ");
INSERT INTO grctr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ἐγώ εἰμι ἡ ἄμπελος, ὑμεῖς τὰ κλήματα. Ὁ μένων ἐν ἐμοί, κἀγὼ ἐν αὐτῷ, οὗτος φέρει καρπὸν πολύν· ὅτι χωρὶς ἐμοῦ οὐ δύνασθε ποιεῖν οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ἐὰν μή τις μείνῃ ἐν ἐμοί, ἐβλήθη ἔξω ὡς τὸ κλῆμα, καὶ ἐξηράνθη, καὶ συνάγουσιν αὐτὰ καὶ εἰς πῦρ βάλλουσι, καὶ καίεται. ");
INSERT INTO grctr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ἐὰν μείνητε ἐν ἐμοί, καὶ τὰ ῥήματά μου ἐν ὑμῖν μείνῃ, ὃ ἐὰν θέλητε αἰτήσεσθε, καὶ γενήσεται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ἐν τούτῳ ἐδοξάσθη ὁ πατήρ μου, ἵνα καρπὸν πολὺν φέρητε· καὶ γενήσεσθε ἐμοὶ μαθηταί. ");
INSERT INTO grctr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Καθὼς ἠγάπησέ με ὁ πατήρ, κἀγὼ ἠγάπησα ὑμᾶς· μείνατε ἐν τῇ ἀγάπῃ τῇ ἐμῇ. ");
INSERT INTO grctr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ἐὰν τὰς ἐντολάς μου τηρήσητε, μενεῖτε ἐν τῇ ἀγάπῃ μου· καθὼς ἐγὼ τὰς ἐντολὰς τοῦ πατρός μου τετήρηκα, καὶ μένω αὐτοῦ ἐν τῇ ἀγάπῃ. ");
INSERT INTO grctr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ταῦτα λελάληκα ὑμῖν, ἵνα ἡ χαρὰ ἡ ἐμὴ ἐν ὑμῖν μείνῃ, καὶ ἡ χαρὰ ὑμῶν πληρωθῇ. ");
INSERT INTO grctr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Αὕτη ἐστὶν ἡ ἐντολὴ ἡ ἐμή, ἵνα ἀγαπᾶτε ἀλλήλους, καθὼς ἠγάπησα ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Μείζονα ταύτης ἀγάπην οὐδεὶς ἔχει, ἵνα τις τὴν ψυχὴν αὐτοῦ θῇ ὑπὲρ τῶν φίλων αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ὑμεῖς φίλοι μου ἐστέ, ἐὰν ποιῆτε ὅσα ἐγὼ ἐντέλλομαι ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Οὐκέτι ὑμᾶς λέγω δούλους, ὅτι ὁ δοῦλος οὐκ οἶδε τί ποιεῖ αὐτοῦ ὁ κύριος· ὑμᾶς δὲ εἴρηκα φίλους, ὅτι πάντα ἃ ἤκουσα παρὰ τοῦ πατρός μου ἐγνώρισα ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Οὐχ ὑμεῖς με ἐξελέξασθε, ἀλλ᾿ ἐγὼ ἐξελεξάμην ὑμᾶς, καὶ ἔθηκα ὑμᾶς, ἵνα ὑμεῖς ὑπάγητε καὶ καρπὸν φέρητε, καὶ ὁ καρπὸς ὑμῶν μένῃ· ἵνα ὅ τι ἂν αἰτήσητε τὸν πατέρα ἐν τῷ ὀνόματί μου, δῷ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ταῦτα ἐντέλλομαι ὑμῖν, ἵνα ἀγαπᾶτε ἀλλήλους. ");
INSERT INTO grctr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Εἰ ὁ κόσμος ὑμᾶς μισεῖ, γινώσκετε ὅτι ἐμὲ πρῶτον ὑμῶν μεμίσηκεν. ");
INSERT INTO grctr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Εἰ ἐκ τοῦ κόσμου ἦτε, ὁ κόσμος ἂν τὸ ἴδιον ἐφίλει· ὅτι δὲ ἐκ τοῦ κόσμου οὐκ ἐστέ, ἀλλ᾿ ἐγὼ ἐξελεξάμην ὑμᾶς ἐκ τοῦ κόσμου, διὰ τοῦτο μισεῖ ὑμᾶς ὁ κόσμος. ");
INSERT INTO grctr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Μνημονεύετε τοῦ λόγου οὗ ἐγὼ εἶπον ὑμῖν, Οὐκ ἔστι δοῦλος μείζων τοῦ κυρίου αὐτοῦ. Εἰ ἐμὲ ἐδίωξαν, καὶ ὑμᾶς διώξουσιν· εἰ τὸν λόγον μου ἐτήρησαν, καὶ τὸν ὑμέτερον τηρήσουσιν. ");
INSERT INTO grctr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ἀλλὰ ταῦτα πάντα ποιήσουσιν ὑμῖν διὰ τὸ ὄνομά μου, ὅτι οὐκ οἴδασι τὸν πέμψαντά με. ");
INSERT INTO grctr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Εἰ μὴ ἦλθον καὶ ἐλάλησα αὐτοῖς, ἁμαρτίαν οὐκ εἶχον· νῦν δὲ πρόφασιν οὐκ ἔχουσι περὶ τῆς ἁμαρτίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ὁ ἐμὲ μισῶν, καὶ τὸν πατέρα μου μισεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Εἰ τὰ ἔργα μὴ ἐποίησα ἐν αὐτοῖς ἃ οὐδεὶς ἄλλος πεποίηκεν, ἁμαρτίαν οὐκ εἶχον· νῦν δὲ καὶ ἑωράκασι καὶ μεμισήκασι καὶ ἐμὲ καὶ τὸν πατέρα μου. ");
INSERT INTO grctr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ἀλλ᾿ ἵνα πληρωθῇ ὁ λόγος ὁ γεγραμμένος ἐν τῷ νόμῳ αὐτῶν ὅτι Ἐμίσησάν με δωρεάν. ");
INSERT INTO grctr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ὅταν δὲ ἔλθῃ ὁ παράκλητος, ὃν ἐγὼ πέμψω ὑμῖν παρὰ τοῦ πατρός, τὸ πνεῦμα τῆς ἀληθείας, ὃ παρὰ τοῦ πατρὸς ἐκπορεύεται, ἐκεῖνος μαρτυρήσει περὶ ἐμοῦ· ");
INSERT INTO grctr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","καὶ ὑμεῖς δὲ μαρτυρεῖτε, ὅτι ἀπ᾿ ἀρχῆς μετ᾿ ἐμοῦ ἐστε. ");
INSERT INTO grctr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ταῦτα λελάληκα ὑμῖν, ἵνα μὴ σκανδαλισθῆτε. ");
INSERT INTO grctr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ἀποσυναγώγους ποιήσουσιν ὑμᾶς· ἀλλ᾿ ἔρχεται ὥρα, ἵνα πᾶς ὁ ἀποκτείνας ὑμᾶς δόξῃ λατρείαν προσφέρειν τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Καὶ ταῦτα ποιήσουσιν ὑμῖν, ὅτι οὐκ ἔγνωσαν τὸν πατέρα οὐδὲ ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ἀλλὰ ταῦτα λελάληκα ὑμῖν, ἵνα ὅταν ἔλθῃ ἡ ὥρα, μνημονεύητε αὐτῶν, ὅτι ἐγὼ εἶπον ὑμῖν. Ταῦτα δὲ ὑμῖν ἐξ ἀρχῆς οὐκ εἶπον, ὅτι μεθ᾿ ὑμῶν ἤμην. ");
INSERT INTO grctr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Νῦν δὲ ὑπάγω πρὸς τὸν πέμψαντά με, καὶ οὐδεὶς ἐξ ὑμῶν ἐρωτᾷ με, Ποῦ ὑπάγεις; ");
INSERT INTO grctr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ἀλλ᾿ ὅτι ταῦτα λελάληκα ὑμῖν, ἡ λύπη πεπλήρωκεν ὑμῶν τὴν καρδίαν. ");
INSERT INTO grctr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ἀλλ᾿ ἐγὼ τὴν ἀλήθειαν λέγω ὑμῖν· συμφέρει ὑμῖν ἵνα ἐγὼ ἀπέλθω· ἐὰν γὰρ μὴ ἀπέλθω, ὁ παράκλητος οὐκ ἐλεύσεται πρὸς ὑμᾶς· ἐὰν δὲ πορευθῶ, πέμψω αὐτὸν πρὸς ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Καὶ ἐλθὼν ἐκεῖνος ἐλέγξει τὸν κόσμον περὶ ἁμαρτίας καὶ περὶ δικαιοσύνης καὶ περὶ κρίσεως· ");
INSERT INTO grctr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","περὶ ἁμαρτίας μέν, ὅτι οὐ πιστεύουσιν εἰς ἐμέ· ");
INSERT INTO grctr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","περὶ δικαιοσύνης δέ, ὅτι πρὸς τὸν πατέρα μου ὑπάγω, καὶ οὐκέτι θεωρεῖτέ με· ");
INSERT INTO grctr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","περὶ δὲ κρίσεως, ὅτι ὁ ἄρχων τοῦ κόσμου τούτου κέκριται. ");
INSERT INTO grctr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ἔτι πολλὰ ἔχω λέγειν ὑμῖν, ἀλλ᾿ οὐ δύνασθε βαστάζειν ἄρτι. ");
INSERT INTO grctr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ὅταν δὲ ἔλθῃ ἐκεῖνος, τὸ πνεῦμα τῆς ἀληθείας, ὁδηγήσει ὑμᾶς εἰς πᾶσαν τὴν ἀλήθειαν· οὐ γὰρ λαλήσει ἀφ᾿ ἑαυτοῦ, ἀλλ᾿ ὅσα ἂν ἀκούσῃ λαλήσει, καὶ τὰ ἐρχόμενα ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ἐκεῖνος ἐμὲ δοξάσει, ὅτι ἐκ τοῦ ἐμοῦ λήψεται, καὶ ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Πάντα ὅσα ἔχει ὁ πατὴρ ἐμά ἐστι· διὰ τοῦτο εἶπον, ὅτι ἐκ τοῦ ἐμοῦ λήψεται, καὶ ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Μικρὸν καὶ οὐ θεωρεῖτέ με, καὶ πάλιν μικρὸν καὶ ὄψεσθέ με, ὅτι ἐγὼ ὑπάγω πρὸς τὸν πατέρα. ");
INSERT INTO grctr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Εἶπον οὖν ἐκ τῶν μαθητῶν αὐτοῦ πρὸς ἀλλήλους, Τί ἐστι τοῦτο ὃ λέγει ἡμῖν, Μικρὸν καὶ οὐ θεωρεῖτέ με, καὶ πάλιν μικρὸν καὶ ὄψεσθέ με; Καὶ ὅτι Ἐγὼ ὑπάγω πρὸς τὸν πατέρα; ");
INSERT INTO grctr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ἔλεγον οὖν, Τοῦτο τί ἐστιν ὃ λέγει, τὸ μικρόν; Οὐκ οἴδαμεν τί λαλεῖ. ");
INSERT INTO grctr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ἔγνω οὖν ὁ Ἰησοῦς ὅτι ἤθελον αὐτὸν ἐρωτᾷν, καὶ εἶπεν αὐτοῖς, Περὶ τούτου ζητεῖτε μετ᾿ ἀλλήλων, ὅτι εἶπον, Μικρὸν καὶ οὐ θεωρεῖτέ με, καὶ πάλιν μικρὸν καὶ ὄψεσθέ με; ");
INSERT INTO grctr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι κλαύσετε καὶ θρηνήσετε ὑμεῖς, ὁ δὲ κόσμος χαρήσεται· ὑμεῖς δὲ λυπηθήσεσθε, ἀλλ᾿ ἡ λύπη ὑμῶν εἰς χαρὰν γενήσεται. ");
INSERT INTO grctr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ἡ γυνὴ ὅταν τίκτῃ λύπην ἔχει, ὅτι ἦλθεν ἡ ὥρα αὐτῆς· ὅταν δὲ γεννήσῃ τὸ παιδίον, οὐκέτι μνημονεύει τῆς θλίψεως, διὰ τὴν χαρὰν ὅτι ἐγεννήθη ἄνθρωπος εἰς τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Καὶ ὑμεῖς οὖν λύπην μὲν νῦν ἔχετε· πάλιν δὲ ὄψομαι ὑμᾶς, καὶ χαρήσεται ὑμῶν ἡ καρδία, καὶ τὴν χαρὰν ὑμῶν οὐδεὶς αἴρει ἀφ᾿ ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Καὶ ἐν ἐκείνῃ τῇ ἡμέρᾳ ἐμὲ οὐκ ἐρωτήσετε οὐδέν. Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ὅσα ἂν αἰτήσητε τὸν πατέρα ἐν τῷ ὀνόματί μου, δώσει ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ἕως ἄρτι οὐκ ᾐτήσατε οὐδὲν ἐν τῷ ὀνόματί μου· αἰτεῖτε, καὶ λήψεσθε, ἵνα ἡ χαρὰ ὑμῶν ᾖ πεπληρωμένη. ");
INSERT INTO grctr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ταῦτα ἐν παροιμίαις λελάληκα ὑμῖν· ἀλλ᾿ ἔρχεται ὥρα ὅτε οὐκέτι ἐν παροιμίαις λαλήσω ὑμῖν, ἀλλὰ παρρησίᾳ περὶ τοῦ πατρὸς ἀναγγελῶ ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ἐν ἐκείνῃ τῇ ἡμέρᾳ ἐν τῷ ὀνόματί μου αἰτήσεσθε· καὶ οὐ λέγω ὑμῖν ὅτι ἐγὼ ἐρωτήσω τὸν πατέρα περὶ ὑμῶν· ");
INSERT INTO grctr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","αὐτὸς γὰρ ὁ πατὴρ φιλεῖ ὑμᾶς, ὅτι ὑμεῖς ἐμὲ πεφιλήκατε, καὶ πεπιστεύκατε ὅτι ἐγὼ παρὰ τοῦ Θεοῦ ἐξῆλθον. ");
INSERT INTO grctr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ἐξῆλθον παρὰ τοῦ πατρός, καὶ ἐλήλυθα εἰς τὸν κόσμον· πάλιν ἀφίημι τὸν κόσμον, καὶ πορεύομαι πρὸς τὸν πατέρα. ");
INSERT INTO grctr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Λέγουσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ, Ἴδε, νῦν παρρησίᾳ λαλεῖς, καὶ παροιμίαν οὐδεμίαν λέγεις. ");
INSERT INTO grctr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Νῦν οἴδαμεν ὅτι οἶδας πάντα, καὶ οὐ χρείαν ἔχεις ἵνα τίς σε ἐρωτᾷ· ἐν τούτῳ πιστεύομεν ὅτι ἀπὸ Θεοῦ ἐξῆλθες. ");
INSERT INTO grctr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς, Ἄρτι πιστεύετε; ");
INSERT INTO grctr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ἰδού, ἔρχεται ὥρα καὶ νῦν ἐλήλυθεν, ἵνα σκορπισθῆτε ἕκαστος εἰς τὰ ἴδια, καὶ ἐμὲ μόνον ἀφῆτε· καὶ οὐκ εἰμὶ μόνος, ὅτι ὁ πατὴρ μετ᾿ ἐμοῦ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ταῦτα λελάληκα ὑμῖν, ἵνα ἐν ἐμοὶ εἰρήνην ἔχητε. Ἐν τῷ κόσμῳ θλίψιν ἕξετε· ἀλλὰ θαρσεῖτε, ἐγὼ νενίκηκα τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ταῦτα ἐλάλησεν ὁ Ἰησοῦς, καὶ ἐπῆρε τοὺς ὀφθαλμοὺς αὐτοῦ εἰς τὸν οὐρανόν, καὶ εἶπε, Πάτερ, ἐλήλυθεν ἡ ὥρα· δόξασόν σου τὸν υἱόν, ἵνα καὶ ὁ υἱός σου δοξάσῃ σε· ");
INSERT INTO grctr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","καθὼς ἔδωκας αὐτῷ ἐξουσίαν πάσης σαρκός, ἵνα πᾶν ὃ δέδωκας αὐτῷ, δώσῃ αὐτοῖς ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Αὕτη δέ ἐστιν ἡ αἰώνιος ζωή, ἵνα γινώσκωσί σε τὸν μόνον ἀληθινὸν Θεόν, καὶ ὃν ἀπέστειλας Ἰησοῦν Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ἐγώ σε ἐδόξασα ἐπὶ τῆς γῆς· τὸ ἔργον ἐτελείωσα ὃ δέδωκάς μοι ἵνα ποιήσω. ");
INSERT INTO grctr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Καὶ νῦν δόξασόν με σύ, πάτερ, παρὰ σεαυτῷ τῇ δόξῃ ᾗ εἶχον πρὸ τοῦ τὸν κόσμον εἶναι παρὰ σοί. ");
INSERT INTO grctr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ἐφανέρωσά σου τὸ ὄνομα τοῖς ἀνθρώποις οὓς δέδωκάς μοι ἐκ τοῦ κόσμου· σοὶ ἦσαν, καὶ ἐμοὶ αὐτοὺς δέδωκας· καὶ τὸν λόγον σου τετηρήκασι. ");
INSERT INTO grctr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Νῦν ἔγνωκαν ὅτι πάντα ὅσα δέδωκάς μοι, παρὰ σοῦ ἐστιν· ");
INSERT INTO grctr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ὅτι τὰ ῥήματα ἃ δέδωκάς μοι, δέδωκα αὐτοῖς· καὶ αὐτοὶ ἔλαβον, καὶ ἔγνωσαν ἀληθῶς ὅτι παρὰ σοῦ ἐξῆλθον, καὶ ἐπίστευσαν ὅτι σύ με ἀπέστειλας. ");
INSERT INTO grctr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ἐγὼ περὶ αὐτῶν ἐρωτῶ· οὐ περὶ τοῦ κόσμου ἐρωτῶ, ἀλλὰ περὶ ὧν δέδωκάς μοι, ὅτι σοί εἰσι· ");
INSERT INTO grctr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","καὶ τὰ ἐμὰ πάντα σά ἐστι, καὶ τὰ σὰ ἐμά· καὶ δεδόξασμαι ἐν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Καὶ οὐκέτι εἰμὶ ἐν τῷ κόσμῳ, καὶ οὗτοι ἐν τῷ κόσμῳ εἰσί, καὶ ἐγὼ πρός σε ἔρχομαι. Πάτερ ἅγιε, τήρησον αὐτοὺς ἐν τῷ ὀνόματί σου, οὓς δέδωκάς μοι, ἵνα ὦσιν ἕν, καθὼς ἡμεῖς. ");
INSERT INTO grctr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ὅτε ἤμην μετ᾿ αὐτῶν ἐν τῷ κόσμῳ, ἐγὼ ἐτήρουν αὐτοὺς ἐν τῷ ὀνόματί σου· οὓς δέδωκάς μοι, ἐφύλαξα, καὶ οὐδεὶς ἐξ αὐτῶν ἀπώλετο, εἰ μὴ ὁ υἱὸς τῆς ἀπωλείας, ἵνα ἡ γραφὴ πληρωθῇ. ");
INSERT INTO grctr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Νῦν δὲ πρός σε ἔρχομαι, καὶ ταῦτα λαλῶ ἐν τῷ κόσμῳ, ἵνα ἔχωσι τὴν χαρὰν τὴν ἐμὴν πεπληρωμένην ἐν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ἐγὼ δέδωκα αὐτοῖς τὸν λόγον σου, καὶ ὁ κόσμος ἐμίσησεν αὐτούς, ὅτι οὐκ εἰσὶν ἐκ τοῦ κόσμου, καθὼς ἐγὼ οὐκ εἰμὶ ἐκ τοῦ κόσμου. ");
INSERT INTO grctr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Οὐκ ἐρωτῶ ἵνα ἄρῃς αὐτοὺς ἐκ τοῦ κόσμου, ἀλλ᾿ ἵνα τηρήσῃς αὐτοὺς ἐκ τοῦ πονηροῦ. ");
INSERT INTO grctr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ἐκ τοῦ κόσμου οὐκ εἰσί, καθὼς ἐγὼ ἐκ τοῦ κόσμου οὐκ εἰμί. ");
INSERT INTO grctr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ἁγίασον αὐτοὺς ἐν τῇ ἀληθείᾳ σου· ὁ λόγος ὁ σὸς ἀλήθειά ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Καθὼς ἐμὲ ἀπέστειλας εἰς τὸν κόσμον, κἀγὼ ἀπέστειλα αὐτοὺς εἰς τὸν κόσμον. ");
INSERT INTO grctr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Καὶ ὑπὲρ αὐτῶν ἐγὼ ἁγιάζω ἐμαυτόν, ἵνα καὶ αὐτοὶ ὦσιν ἡγιασμένοι ἐν ἀληθείᾳ. ");
INSERT INTO grctr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Οὐ περὶ τούτων δὲ ἐρωτῶ μόνον, ἀλλὰ καὶ περὶ τῶν πιστευσόντων διὰ τοῦ λόγου αὐτῶν εἰς ἐμέ· ");
INSERT INTO grctr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ἵνα πάντες ἓν ὦσι· καθὼς σύ, πάτερ, ἐν ἐμοί, κἀγὼ ἐν σοί, ἵνα καὶ αὐτοὶ ἐν ἡμῖν ἓν ὦσιν· ἵνα ὁ κόσμος πιστεύσῃ ὅτι σύ με ἀπέστειλας. ");
INSERT INTO grctr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Καὶ ἐγὼ τὴν δόξαν ἣν δέδωκάς μοι, δέδωκα αὐτοῖς, ἵνα ὦσιν ἕν, καθὼς ἡμεῖς ἕν ἐσμεν. ");
INSERT INTO grctr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ἐγὼ ἐν αὐτοῖς, καὶ σὺ ἐν ἐμοί, ἵνα ὦσι τετελειωμένοι εἰς ἕν, καὶ ἵνα γινώσκῃ ὁ κόσμος ὅτι σύ με ἀπέστειλας, καὶ ἠγάπησας αὐτούς, καθὼς ἐμὲ ἠγάπησας. ");
INSERT INTO grctr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Πάτερ, οὓς δέδωκάς μοι, θέλω ἵνα ὅπου εἰμὶ ἐγὼ κἀκεῖνοι ὦσι μετ᾿ ἐμοῦ· ἵνα θεωρῶσι τὴν δόξαν τὴν ἐμὴν ἣν ἔδωκάς μοι, ὅτι ἠγάπησάς με πρὸ καταβολῆς κόσμου. ");
INSERT INTO grctr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Πάτερ δίκαιε, καὶ ὁ κόσμος σε οὐκ ἔγνω, ἐγὼ δέ σε ἔγνων, καὶ οὗτοι ἔγνωσαν ὅτι σύ με ἀπέστειλας· ");
INSERT INTO grctr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","καὶ ἐγνώρισα αὐτοῖς τὸ ὄνομά σου, καὶ γνωρίσω· ἵνα ἡ ἀγάπη, ἣν ἠγάπησάς με, ἐν αὐτοῖς ᾖ, κἀγὼ ἐν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ταῦτα εἰπὼν ὁ Ἰησοῦς ἐξῆλθε σὺν τοῖς μαθηταῖς αὐτοῦ πέραν τοῦ χειμάρρου τῶν Κέδρων, ὅπου ἦν κῆπος, εἰς ὃν εἰσῆλθεν αὐτὸς καὶ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ᾜδει δὲ καὶ Ἰούδας, ὁ παραδιδοὺς αὐτόν, τὸν τόπον· ὅτι πολλάκις συνήχθη ὁ Ἰησοῦς ἐκεῖ μετὰ τῶν μαθητῶν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ὁ οὖν Ἰούδας, λαβὼν τὴν σπεῖραν, καὶ ἐκ τῶν ἀρχιερέων καὶ Φαρισαίων ὑπηρέτας, ἔρχεται ἐκεῖ μετὰ φανῶν καὶ λαμπάδων καὶ ὅπλων. ");
INSERT INTO grctr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ἰησοῦς οὖν, εἰδὼς πάντα τὰ ἐρχόμενα ἐπ᾿ αὐτόν, ἐξελθὼν εἶπεν αὐτοῖς, Τίνα ζητεῖτε; ");
INSERT INTO grctr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ἀπεκρίθησαν αὐτῷ, Ἰησοῦν τὸν Ναζωραῖον. Λέγει αὐτοῖς ὁ Ἰησοῦς, Ἐγώ εἰμι. Εἱστήκει δὲ καὶ Ἰούδας ὁ παραδιδοὺς αὐτὸν μετ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ὡς οὖν εἶπεν αὐτοῖς ὅτι Ἐγώ εἰμι, ἀπῆλθον εἰς τὰ ὀπίσω, καὶ ἔπεσον χαμαί. ");
INSERT INTO grctr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Πάλιν οὖν αὐτοὺς ἐπηρώτησε, Τίνα ζητεῖτε; Οἱ δὲ εἶπον, Ἰησοῦν τὸν Ναζωραῖον. ");
INSERT INTO grctr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ἀπεκρίθη ὁ Ἰησοῦς, Εἶπον ὑμῖν ὅτι ἐγώ εἰμι· εἰ οὖν ἐμὲ ζητεῖτε, ἄφετε τούτους ὑπάγειν· ");
INSERT INTO grctr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ἵνα πληρωθῇ ὁ λόγος ὃν εἶπεν ὅτι Οὓς δέδωκάς μοι, οὐκ ἀπώλεσα ἐξ αὐτῶν οὐδένα. ");
INSERT INTO grctr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Σίμων οὖν Πέτρος ἔχων μάχαιραν εἵλκυσεν αὐτήν, καὶ ἔπαισε τὸν τοῦ ἀρχιερέως δοῦλον, καὶ ἀπέκοψεν αὐτοῦ τὸ ὠτίον τὸ δεξιόν. Ἦν δὲ ὄνομα τῷ δούλῳ Μάλχος. ");
INSERT INTO grctr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Εἶπεν οὖν ὁ Ἰησοῦς τῷ Πέτρῳ, Βάλε τὴν μάχαιράν σου εἰς τὴν θήκην· τὸ ποτήριον ὃ δέδωκέ μοι ὁ πατήρ, οὐ μὴ πίω αὐτό; ");
INSERT INTO grctr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ἡ οὖν σπεῖρα καὶ ὁ χιλίαρχος καὶ οἱ ὑπηρέται τῶν Ἰουδαίων συνέλαβον τὸν Ἰησοῦν, καὶ ἔδησαν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","καὶ ἀπήγαγον αὐτὸν πρὸς Ἄνναν πρῶτον· ἦν γὰρ πενθερὸς τοῦ Καϊάφα, ὃς ἦν ἀρχιερεὺς τοῦ ἐνιαυτοῦ ἐκείνου. ");
INSERT INTO grctr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ἦν δὲ Καϊάφας ὁ συμβουλεύσας τοῖς Ἰουδαίοις, ὅτι συμφέρει ἕνα ἄνθρωπον ἀπολέσθαι ὑπὲρ τοῦ λαοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ἠκολούθει δὲ τῷ Ἰησοῦ Σίμων Πέτρος, καὶ ὁ ἄλλος μαθητής. Ὁ δὲ μαθητὴς ἐκεῖνος ἦν γνωστὸς τῷ ἀρχιερεῖ, καὶ συνεισῆλθε τῷ Ἰησοῦ εἰς τὴν αὐλὴν τοῦ ἀρχιερέως· ");
INSERT INTO grctr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ὁ δὲ Πέτρος εἱστήκει πρὸς τῇ θύρᾳ ἔξω. Ἐξῆλθεν οὖν ὁ μαθητὴς ὁ ἄλλος ὃς ἦν γνωστὸς τῷ ἀρχιερεῖ, καὶ εἶπε τῇ θυρωρῷ, καὶ εἰσήγαγε τὸν Πέτρον. ");
INSERT INTO grctr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Λέγει οὖν ἡ παιδίσκη ἡ θυρωρὸς τῷ Πέτρῳ, Μὴ καὶ σὺ ἐκ τῶν μαθητῶν εἶ τοῦ ἀνθρώπου τούτου; Λέγει ἐκεῖνος, Οὐκ εἰμί. ");
INSERT INTO grctr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Εἱστήκεισαν δὲ οἱ δοῦλοι καὶ οἱ ὑπηρέται ἀνθρακιὰν πεποιηκότες, ὅτι ψύχος ἦν, καὶ ἐθερμαίνοντο· ἦν δὲ μετ᾿ αὐτῶν ὁ Πέτρος ἑστὼς καὶ θερμαινόμενος. ");
INSERT INTO grctr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ὁ οὖν ἀρχιερεὺς ἠρώτησε τὸν Ἰησοῦν περὶ τῶν μαθητῶν αὐτοῦ, καὶ περὶ τῆς διδαχῆς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Ἐγὼ παρρησίᾳ ἐλάλησα τῷ κόσμῳ· ἐγὼ πάντοτε ἐδίδαξα ἐν τῇ συναγωγῇ καὶ ἐν τῷ ἱερῷ, ὅπου πάντοτε οἱ Ἰουδαῖοι συνέρχονται, καὶ ἐν κρυπτῷ ἐλάλησα οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Τί με ἐπερωτᾷς; Ἐπερώτησον τοὺς ἀκηκοότας, τί ἐλάλησα αὐτοῖς· ἴδε, οὗτοι οἴδασιν ἃ εἶπον ἐγώ. ");
INSERT INTO grctr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ταῦτα δὲ αὐτοῦ εἰπόντος, εἷς τῶν ὑπηρετῶν παρεστηκὼς ἔδωκε ῥάπισμα τῷ Ἰησοῦ, εἰπών, Οὕτως ἀποκρίνῃ τῷ ἀρχιερεῖ; ");
INSERT INTO grctr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Εἰ κακῶς ἐλάλησα, μαρτύρησον περὶ τοῦ κακοῦ· εἰ δὲ καλῶς, τί με δέρεις; ");
INSERT INTO grctr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ἀπέστειλεν οὖν αὐτὸν ὁ Ἄννας δεδεμένον πρὸς Καϊάφαν τὸν ἀρχιερέα. ");
INSERT INTO grctr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ἦν δὲ Σίμων Πέτρος ἑστὼς καὶ θερμαινόμενος· εἶπον οὖν αὐτῷ, Μὴ καὶ σὺ ἐκ τῶν μαθητῶν αὐτοῦ εἶ; Ἠρνήσατο ἐκεῖνος, καὶ εἶπεν, Οὐκ εἰμί. ");
INSERT INTO grctr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Λέγει εἷς ἐκ τῶν δούλων τοῦ ἀρχιερέως, συγγενὴς ὢν οὗ ἀπέκοψε Πέτρος τὸ ὠτίον, Οὐκ ἐγώ σε εἶδον ἐν τῷ κήπῳ μετ᾿ αὐτοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Πάλιν οὖν ἠρνήσατο ὁ Πέτρος, καὶ εὐθέως ἀλέκτωρ ἐφώνησεν. ");
INSERT INTO grctr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ἄγουσιν οὖν τὸν Ἰησοῦν ἀπὸ τοῦ Καϊάφα εἰς τὸ πραιτώριον· ἦν δὲ πρωΐα, καὶ αὐτοὶ οὐκ εἰσῆλθον εἰς τὸ πραιτώριον, ἵνα μὴ μιανθῶσιν, ἀλλ᾿ ἵνα φάγωσι τὸ Πάσχα. ");
INSERT INTO grctr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ἐξῆλθεν οὖν ὁ Πιλάτος πρὸς αὐτούς, καὶ εἶπε, Τίνα κατηγορίαν φέρετε κατὰ τοῦ ἀνθρώπου τούτου; ");
INSERT INTO grctr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ἀπεκρίθησαν καὶ εἶπον αὐτῷ, Εἰ μὴ ἦν οὗτος κακοποιός, οὐκ ἄν σοι παρεδώκαμεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Εἶπεν οὖν αὐτοῖς ὁ Πιλάτος, Λάβετε αὐτὸν ὑμεῖς, καὶ κατὰ τὸν νόμον ὑμῶν κρίνατε αὐτόν. Εἶπον οὖν αὐτῷ οἱ Ἰουδαῖοι, Ἡμῖν οὐκ ἔξεστιν ἀποκτεῖναι οὐδένα· ");
INSERT INTO grctr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ἵνα ὁ λόγος τοῦ Ἰησοῦ πληρωθῇ, ὃν εἶπε, σημαίνων ποίῳ θανάτῳ ἤμελλεν ἀποθνῄσκειν. ");
INSERT INTO grctr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Εἰσῆλθεν οὖν εἰς τὸ πραιτώριον πάλιν ὁ Πιλάτος, καὶ ἐφώνησε τὸν Ἰησοῦν, καὶ εἶπεν αὐτῷ, Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; ");
INSERT INTO grctr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ἀπεκρίθη αὐτῷ ὁ Ἰησοῦς, Ἀφ᾿ ἑαυτοῦ σὺ τοῦτο λέγεις, ἢ ἄλλοι σοι εἶπον περὶ ἐμοῦ; ");
INSERT INTO grctr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ἀπεκρίθη ὁ Πιλάτος, Μήτι ἐγὼ Ἰουδαῖός εἰμι; Τὸ ἔθνος τὸ σὸν καὶ οἱ ἀρχιερεῖς παρέδωκάν σε ἐμοί· τί ἐποίησας; ");
INSERT INTO grctr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ἀπεκρίθη ὁ Ἰησοῦς, Ἡ βασιλεία ἡ ἐμὴ οὐκ ἔστιν ἐκ τοῦ κόσμου τούτου· εἰ ἐκ τοῦ κόσμου τούτου ἦν ἡ βασιλεία ἡ ἐμή, οἱ ὑπηρέται ἂν οἱ ἐμοὶ ἠγωνίζοντο, ἵνα μὴ παραδοθῶ τοῖς Ἰουδαίοις· νῦν δὲ ἡ βασιλεία ἡ ἐμὴ οὐκ ἔστιν ἐντεῦθεν. ");
INSERT INTO grctr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Εἶπεν οὖν αὐτῷ ὁ Πιλάτος, Οὐκοῦν βασιλεὺς εἶ σύ; Ἀπεκρίθη ὁ Ἰησοῦς, Σὺ λέγεις, ὅτι βασιλεύς εἰμι ἐγώ. Ἐγὼ εἰς τοῦτο γεγέννημαι, καὶ εἰς τοῦτο ἐλήλυθα εἰς τὸν κόσμον, ἵνα μαρτυρήσω τῇ ἀληθείᾳ. Πᾶς ὁ ὢν ἐκ τῆς ἀληθείας ἀκούει μου τῆς φωνῆς. ");
INSERT INTO grctr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Λέγει αὐτῷ ὁ Πιλάτος, Τί ἐστιν ἀλήθεια; Καὶ τοῦτο εἰπών, πάλιν ἐξῆλθε πρὸς τοὺς Ἰουδαίους, καὶ λέγει αὐτοῖς, Ἐγὼ οὐδεμίαν αἰτίαν εὑρίσκω ἐν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ἔστι δὲ συνήθεια ὑμῖν, ἵνα ἕνα ὑμῖν ἀπολύσω ἐν τῷ Πάσχα· βούλεσθε οὖν ὑμῖν ἀπολύσω τὸν βασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grctr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ἐκραύγασαν οὖν πάλιν πάντες, λέγοντες, Μὴ τοῦτον, ἀλλὰ τὸν Βαραββᾶν· ἦν δὲ ὁ Βαραββᾶς λῃστής. ");
INSERT INTO grctr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Τότε οὖν ἔλαβεν ὁ Πιλάτος τὸν Ἰησοῦν, καὶ ἐμαστίγωσε. ");
INSERT INTO grctr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Καὶ οἱ στρατιῶται πλέξαντες στέφανον ἐξ ἀκανθῶν ἐπέθηκαν αὐτοῦ τῇ κεφαλῇ, καὶ ἱμάτιον πορφυροῦν περιέβαλον αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","καὶ ἔλεγον, Χαῖρε, ὁ βασιλεὺς τῶν Ἰουδαίων· καὶ ἐδίδουν αὐτῷ ῥαπίσματα. ");
INSERT INTO grctr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ἐξῆλθεν οὖν πάλιν ἔξω ὁ Πιλάτος, καὶ λέγει αὐτοῖς, Ἴδε, ἄγω ὑμῖν αὐτὸν ἔξω, ἵνα γνῶτε ὅτι ἐν αὐτῷ οὐδεμίαν αἰτίαν εὑρίσκω. ");
INSERT INTO grctr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ἐξῆλθεν οὖν ὁ Ἰησοῦς ἔξω, φορῶν τὸν ἀκάνθινον στέφανον καὶ τὸ πορφυροῦν ἱμάτιον. Καὶ λέγει αὐτοῖς, Ἴδε, ὁ ἄνθρωπος. ");
INSERT INTO grctr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ὅτε οὖν εἶδον αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ ὑπηρέται, ἐκραύγασαν λέγοντες, Σταύρωσον, σταύρωσον. Λέγει αὐτοῖς ὁ Πιλάτος, Λάβετε αὐτὸν ὑμεῖς καὶ σταυρώσατε· ἐγὼ γὰρ οὐχ εὑρίσκω ἐν αὐτῷ αἰτίαν. ");
INSERT INTO grctr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ἀπεκρίθησαν αὐτῷ οἱ Ἰουδαῖοι, Ἡμεῖς νόμον ἔχομεν, καὶ κατὰ τὸν νόμον ἡμῶν ὀφείλει ἀποθανεῖν, ὅτι ἑαυτὸν υἱὸν τοῦ Θεοῦ ἐποίησεν. ");
INSERT INTO grctr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ὅτε οὖν ἤκουσεν ὁ Πιλάτος τοῦτον τὸν λόγον, μᾶλλον ἐφοβήθη, ");
INSERT INTO grctr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","καὶ εἰσῆλθεν εἰς τὸ πραιτώριον πάλιν, καὶ λέγει τῷ Ἰησοῦ, Πόθεν εἶ σύ; Ὁ δὲ Ἰησοῦς ἀπόκρισιν οὐκ ἔδωκεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Λέγει οὖν αὐτῷ ὁ Πιλάτος, Ἐμοὶ οὐ λαλεῖς; Οὐκ οἶδας ὅτι ἐξουσίαν ἔχω σταυρῶσαί σε, καὶ ἐξουσίαν ἔχω ἀπολῦσαί σε; ");
INSERT INTO grctr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ἀπεκρίθη ὁ Ἰησοῦς, Οὐκ εἶχες ἐξουσίαν οὐδεμίαν κατ᾿ ἐμοῦ, εἰ μὴ ἦν σοι δεδομένον ἄνωθεν· διὰ τοῦτο ὁ παραδιδούς μέ σοι μείζονα ἁμαρτίαν ἔχει. ");
INSERT INTO grctr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ἐκ τούτου ἐζήτει ὁ Πιλάτος ἀπολῦσαι αὐτόν. Οἱ δὲ Ἰουδαῖοι ἔκραζον λέγοντες, Ἐὰν τοῦτον ἀπολύσῃς, οὐκ εἶ φίλος τοῦ Καίσαρος· πᾶς ὁ βασιλέα αὐτὸν ποιῶν, ἀντιλέγει τῷ Καίσαρι. ");
INSERT INTO grctr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ὁ οὖν Πιλάτος ἀκούσας τοῦτον τὸν λόγον ἤγαγεν ἔξω τὸν Ἰησοῦν, καὶ ἐκάθισεν ἐπὶ τοῦ βήματος, εἰς τόπον λεγόμενον Λιθόστρωτον, Ἑβραϊστὶ δὲ Γαββαθᾶ· ");
INSERT INTO grctr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ἦν δὲ Παρασκευὴ τοῦ Πάσχα, ὥρα δὲ ὡσεὶ ἕκτη· καὶ λέγει τοῖς Ἰουδαίοις, Ἴδε, ὁ βασιλεὺς ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Οἱ δὲ ἐκραύγασαν, Ἆρον, ἆρον, σταύρωσον αὐτόν. Λέγει αὐτοῖς ὁ Πιλάτος, Τὸν βασιλέα ὑμῶν σταυρώσω; Ἀπεκρίθησαν οἱ ἀρχιερεῖς, Οὐκ ἔχομεν βασιλέα εἰ μὴ Καίσαρα. ");
INSERT INTO grctr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Τότε οὖν παρέδωκεν αὐτὸν αὐτοῖς ἵνα σταυρωθῇ. Παρέλαβον δὲ τὸν Ἰησοῦν καὶ ἀπήγαγον· ");
INSERT INTO grctr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","καὶ βαστάζων τὸν σταυρὸν αὐτοῦ ἐξῆλθεν εἰς τὸν λεγόμενον Κρανίου Τόπον, ὃς λέγεται Ἑβραϊστὶ Γολγοθᾶ· ");
INSERT INTO grctr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ὅπου αὐτὸν ἐσταύρωσαν, καὶ μετ᾿ αὐτοῦ ἄλλους δύο, ἐντεῦθεν καὶ ἐντεῦθεν, μέσον δὲ τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ἔγραψε δὲ καὶ τίτλον ὁ Πιλάτος, καὶ ἔθηκεν ἐπὶ τοῦ σταυροῦ· ἦν δὲ γεγραμμένον, Ἰησοῦς ὁ Ναζωραῖος ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Τοῦτον οὖν τὸν τίτλον πολλοὶ ἀνέγνωσαν τῶν Ἰουδαίων, ὅτι ἐγγὺς ἦν τῆς πόλεως ὁ τόπος ὅπου ἐσταυρώθη ὁ Ἰησοῦς· καὶ ἦν γεγραμμένον Ἑβραϊστί, Ἑλληνιστί, Ῥωμαϊστί. ");
INSERT INTO grctr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ἔλεγον οὖν τῷ Πιλάτῳ οἱ ἀρχιερεῖς τῶν Ἰουδαίων, Μὴ γράφε, Ὁ βασιλεὺς τῶν Ἰουδαίων· ἀλλ᾿ ὅτι Ἐκεῖνος εἶπε, Βασιλεύς εἰμι τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ἀπεκρίθη ὁ Πιλάτος, Ὃ γέγραφα, γέγραφα. ");
INSERT INTO grctr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Οἱ οὖν στρατιῶται, ὅτε ἐσταύρωσαν τὸν Ἰησοῦν, ἔλαβον τὰ ἱμάτια αὐτοῦ, καὶ ἐποίησαν τέσσαρα μέρη, ἑκάστῳ στρατιώτῃ μέρος, καὶ τὸν χιτῶνα. Ἦν δὲ ὁ χιτὼν ἄρραφος, ἐκ τῶν ἄνωθεν ὑφαντὸς δι᾿ ὅλου. ");
INSERT INTO grctr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Εἶπον οὖν πρὸς ἀλλήλους, Μὴ σχίσωμεν αὐτόν, ἀλλὰ λάχωμεν περὶ αὐτοῦ, τίνος ἔσται· ἵνα ἡ γραφὴ πληρωθῇ ἡ λέγουσα, Διεμερίσαντο τὰ ἱμάτιά μου ἑαυτοῖς, καὶ ἐπὶ τὸν ἱματισμόν μου ἔβαλον κλῆρον. Οἱ μὲν οὖν στρατιῶται ταῦτα ἐποίησαν. ");
INSERT INTO grctr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Εἱστήκεισαν δὲ παρὰ τῷ σταυρῷ τοῦ Ἰησοῦ ἡ μήτηρ αὐτοῦ, καὶ ἡ ἀδελφὴ τῆς μητρὸς αὐτοῦ, Μαρία ἡ τοῦ Κλωπᾶ, καὶ Μαρία ἡ Μαγδαληνή. ");
INSERT INTO grctr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ἰησοῦς οὖν ἰδὼν τὴν μητέρα, καὶ τὸν μαθητὴν παρεστῶτα ὃν ἠγάπα, λέγει τῇ μητρὶ αὐτοῦ, Γύναι, ἰδοὺ ὁ υἱός σου. ");
INSERT INTO grctr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Εἶτα λέγει τῷ μαθητῇ, Ἰδοὺ ἡ μήτηρ σου. Καὶ ἀπ᾿ ἐκείνης τῆς ὥρας ἔλαβεν αὐτὴν ὁ μαθητὴς εἰς τὰ ἴδια. ");
INSERT INTO grctr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Μετὰ τοῦτο εἰδὼς ὁ Ἰησοῦς ὅτι πάντα ἤδη τετέλεσται, ἵνα τελειωθῇ ἡ γραφή, λέγει, Διψῶ. ");
INSERT INTO grctr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Σκεῦος οὖν ἔκειτο ὄξους μεστόν· οἱ δέ, πλήσαντες σπόγγον ὄξους, καὶ ὑσσώπῳ περιθέντες, προσήνεγκαν αὐτοῦ τῷ στόματι. ");
INSERT INTO grctr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ὅτε οὖν ἔλαβε τὸ ὄξος ὁ Ἰησοῦς, εἶπε, Τετέλεσται· καὶ κλίνας τὴν κεφαλήν, παρέδωκε τὸ πνεῦμα. ");
INSERT INTO grctr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Οἱ οὖν Ἰουδαῖοι, ἵνα μὴ μείνῃ ἐπὶ τοῦ σταυροῦ τὰ σώματα ἐν τῷ σαββάτῳ, ἐπεὶ Παρασκευὴ ἦν — ἦν γὰρ μεγάλη ἡ ἡμέρα ἐκείνου τοῦ σαββάτου — ἠρώτησαν τὸν Πιλάτον ἵνα κατεαγῶσιν αὐτῶν τὰ σκέλη, καὶ ἀρθῶσιν. ");
INSERT INTO grctr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ἦλθον οὖν οἱ στρατιῶται, καὶ τοῦ μὲν πρώτου κατέαξαν τὰ σκέλη καὶ τοῦ ἄλλου τοῦ συσταυρωθέντος αὐτῷ· ");
INSERT INTO grctr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ἐπὶ δὲ τὸν Ἰησοῦν ἐλθόντες, ὡς εἶδον αὐτὸν ἤδη τεθνηκότα, οὐ κατέαξαν αὐτοῦ τὰ σκέλη· ");
INSERT INTO grctr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ἀλλ᾿ εἷς τῶν στρατιωτῶν λόγχῃ αὐτοῦ τὴν πλευρὰν ἔνυξε, καὶ εὐθὺς ἐξῆλθεν αἷμα καὶ ὕδωρ. ");
INSERT INTO grctr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Καὶ ὁ ἑωρακὼς μεμαρτύρηκε, καὶ ἀληθινὴ αὐτοῦ ἐστιν ἡ μαρτυρία, κἀκεῖνος οἶδεν ὅτι ἀληθῆ λέγει, ἵνα ὑμεῖς πιστεύσητε. ");
INSERT INTO grctr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ἐγένετο γὰρ ταῦτα ἵνα ἡ γραφὴ πληρωθῇ, Ὀστοῦν οὐ συντριβήσεται αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Καὶ πάλιν ἑτέρα γραφὴ λέγει, Ὄψονται εἰς ὃν ἐξεκέντησαν. ");
INSERT INTO grctr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Μετὰ δὲ ταῦτα ἠρώτησε τὸν Πιλάτον ὁ Ἰωσὴφ ὁ ἀπὸ Ἀριμαθαίας, ὢν μαθητὴς τοῦ Ἰησοῦ, κεκρυμμένος δὲ διὰ τὸν φόβον τῶν Ἰουδαίων, ἵνα ἄρῃ τὸ σῶμα τοῦ Ἰησοῦ· καὶ ἐπέτρεψεν ὁ Πιλάτος. Ἦλθεν οὖν καὶ ἦρε τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ἦλθε δὲ καὶ Νικόδημος, ὁ ἐλθὼν πρὸς τὸν Ἰησοῦν νυκτὸς τὸ πρῶτον, φέρων μίγμα σμύρνης καὶ ἀλόης ὡσεὶ λίτρας ἑκατόν. ");
INSERT INTO grctr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ἔλαβον οὖν τὸ σῶμα τοῦ Ἰησοῦ, καὶ ἔδησαν αὐτὸ ὀθονίοις μετὰ τῶν ἀρωμάτων, καθὼς ἔθος ἐστὶ τοῖς Ἰουδαίοις ἐνταφιάζειν. ");
INSERT INTO grctr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ἦν δὲ ἐν τῷ τόπῳ ὅπου ἐσταυρώθη κῆπος, καὶ ἐν τῷ κήπῳ μνημεῖον καινόν, ἐν ᾧ οὐδέπω οὐδεὶς ἐτέθη. ");
INSERT INTO grctr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ἐκεῖ οὖν διὰ τὴν Παρασκευὴν τῶν Ἰουδαίων, ὅτι ἐγγὺς ἦν τὸ μνημεῖον, ἔθηκαν τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Τῇ δὲ μιᾷ τῶν σαββάτων Μαρία ἡ Μαγδαληνὴ ἔρχεται πρωΐ, σκοτίας ἔτι οὔσης, εἰς τὸ μνημεῖον, καὶ βλέπει τὸν λίθον ἠρμένον ἐκ τοῦ μνημείου. ");
INSERT INTO grctr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Τρέχει οὖν καὶ ἔρχεται πρὸς Σίμωνα Πέτρον καὶ πρὸς τὸν ἄλλον μαθητὴν ὃν ἐφίλει ὁ Ἰησοῦς, καὶ λέγει αὐτοῖς, Ἦραν τὸν Κύριον ἐκ τοῦ μνημείου, καὶ οὐκ οἴδαμεν ποῦ ἔθηκαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ἐξῆλθεν οὖν ὁ Πέτρος καὶ ὁ ἄλλος μαθητής, καὶ ἤρχοντο εἰς τὸ μνημεῖον. ");
INSERT INTO grctr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ἔτρεχον δὲ οἱ δύο ὁμοῦ· καὶ ὁ ἄλλος μαθητὴς προέδραμε τάχιον τοῦ Πέτρου, καὶ ἦλθε πρῶτος εἰς τὸ μνημεῖον, ");
INSERT INTO grctr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","καὶ παρακύψας βλέπει κείμενα τὰ ὀθόνια, οὐ μέντοι εἰσῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ἔρχεται οὖν Σίμων Πέτρος ἀκολουθῶν αὐτῷ, καὶ εἰσῆλθεν εἰς τὸ μνημεῖον, καὶ θεωρεῖ τὰ ὀθόνια κείμενα, ");
INSERT INTO grctr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","καὶ τὸ σουδάριον ὃ ἦν ἐπὶ τῆς κεφαλῆς αὐτοῦ, οὐ μετὰ τῶν ὀθονίων κείμενον, ἀλλὰ χωρὶς ἐντετυλιγμένον εἰς ἕνα τόπον. ");
INSERT INTO grctr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Τότε οὖν εἰσῆλθε καὶ ὁ ἄλλος μαθητὴς ὁ ἐλθὼν πρῶτος εἰς τὸ μνημεῖον, καὶ εἶδε, καὶ ἐπίστευσεν· ");
INSERT INTO grctr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","οὐδέπω γὰρ ᾔδεισαν τὴν γραφήν, ὅτι δεῖ αὐτὸν ἐκ νεκρῶν ἀναστῆναι. ");
INSERT INTO grctr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ἀπῆλθον οὖν πάλιν πρὸς ἑαυτοὺς οἱ μαθηταί. ");
INSERT INTO grctr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Μαρία δὲ εἱστήκει πρὸς τὸ μνημεῖον κλαίουσα ἔξω· ὡς οὖν ἔκλαιε, παρέκυψεν εἰς τὸ μνημεῖον, ");
INSERT INTO grctr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","καὶ θεωρεῖ δύο ἀγγέλους ἐν λευκοῖς καθεζομένους, ἕνα πρὸς τῇ κεφαλῇ, καὶ ἕνα πρὸς τοῖς ποσίν, ὅπου ἔκειτο τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Καὶ λέγουσιν αὐτῇ ἐκεῖνοι, Γύναι, τί κλαίεις; Λέγει αὐτοῖς, ὅτι Ἦραν τὸν Κύριόν μου, καὶ οὐκ οἶδα ποῦ ἔθηκαν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Καὶ ταῦτα εἰποῦσα ἐστράφη εἰς τὰ ὀπίσω, καὶ θεωρεῖ τὸν Ἰησοῦν ἑστῶτα, καὶ οὐκ ᾔδει ὅτι ὁ Ἰησοῦς ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Λέγει αὐτῇ ὁ Ἰησοῦς, Γύναι, τί κλαίεις; Τίνα ζητεῖς; Ἐκείνη, δοκοῦσα ὅτι ὁ κηπουρός ἐστι, λέγει αὐτῷ, Κύριε, εἰ σὺ ἐβάστασας αὐτόν, εἰπέ μοι ποῦ αὐτὸν ἔθηκας, κἀγὼ αὐτὸν ἀρῶ. ");
INSERT INTO grctr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Λέγει αὐτῇ ὁ Ἰησοῦς, Μαρία. Στραφεῖσα ἐκείνη λέγει αὐτῷ, Ῥαββουνί — ὃ λέγεται, Διδάσκαλε. ");
INSERT INTO grctr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Λέγει αὐτῇ ὁ Ἰησοῦς, Μή μου ἅπτου, οὔπω γὰρ ἀναβέβηκα πρὸς τὸν πατέρα μου· πορεύου δὲ πρὸς τοὺς ἀδελφούς μου, καὶ εἰπὲ αὐτοῖς, Ἀναβαίνω πρὸς τὸν πατέρα μου καὶ πατέρα ὑμῶν, καὶ Θεόν μου καὶ Θεὸν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ἔρχεται Μαρία ἡ Μαγδαληνὴ ἀπαγγέλλουσα τοῖς μαθηταῖς ὅτι ἑώρακε τὸν Κύριον, καὶ ταῦτα εἶπεν αὐτῇ. ");
INSERT INTO grctr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Οὔσης οὖν ὀψίας, τῇ ἡμέρᾳ ἐκείνῃ τῇ μιᾷ τῶν σαββάτων, καὶ τῶν θυρῶν κεκλεισμένων ὅπου ἦσαν οἱ μαθηταὶ συνηγμένοι, διὰ τὸν φόβον τῶν Ἰουδαίων, ἦλθεν ὁ Ἰησοῦς καὶ ἔστη εἰς τὸ μέσον, καὶ λέγει αὐτοῖς, Εἰρήνη ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Καὶ τοῦτο εἰπὼν ἔδειξεν αὐτοῖς τὰς χεῖρας καὶ τὴν πλευρὰν αὐτοῦ. Ἐχάρησαν οὖν οἱ μαθηταὶ ἰδόντες τὸν Κύριον. ");
INSERT INTO grctr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς πάλιν, Εἰρήνη ὑμῖν· καθὼς ἀπέσταλκέ με ὁ πατήρ, κἀγὼ πέμπω ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Καὶ τοῦτο εἰπὼν ἐνεφύσησε καὶ λέγει αὐτοῖς, Λάβετε πνεῦμα ἅγιον. ");
INSERT INTO grctr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ἄν τινων ἀφῆτε τὰς ἁμαρτίας, ἀφίενται αὐτοῖς· ἄν τινων κρατῆτε, κεκράτηνται. ");
INSERT INTO grctr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Θωμᾶς δέ, εἷς ἐκ τῶν δώδεκα, ὁ λεγόμενος Δίδυμος, οὐκ ἦν μετ᾿ αὐτῶν ὅτε ἦλθεν ὁ Ἰησοῦς. ");
INSERT INTO grctr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ἔλεγον οὖν αὐτῷ οἱ ἄλλοι μαθηταί, Ἑωράκαμεν τὸν Κύριον. Ὁ δὲ εἶπεν αὐτοῖς, Ἐὰν μὴ ἴδω ἐν ταῖς χερσὶν αὐτοῦ τὸν τύπον τῶν ἥλων, καὶ βάλω τὸν δάκτυλόν μου εἰς τὸν τύπον τῶν ἥλων, καὶ βάλω τὴν χεῖρά μου εἰς τὴν πλευρὰν αὐτοῦ, οὐ μὴ πιστεύσω. ");
INSERT INTO grctr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Καὶ μεθ᾿ ἡμέρας ὀκτὼ πάλιν ἦσαν ἔσω οἱ μαθηταὶ αὐτοῦ, καὶ Θωμᾶς μετ᾿ αὐτῶν. Ἔρχεται ὁ Ἰησοῦς, τῶν θυρῶν κεκλεισμένων, καὶ ἔστη εἰς τὸ μέσον καὶ εἶπεν, Εἰρήνη ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Εἶτα λέγει τῷ Θωμᾷ, Φέρε τὸν δάκτυλόν σου ὧδε, καὶ ἴδε τὰς χεῖράς μου· καὶ φέρε τὴν χεῖρά σου, καὶ βάλε εἰς τὴν πλευράν μου· καὶ μὴ γίνου ἄπιστος, ἀλλὰ πιστός. ");
INSERT INTO grctr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Καὶ ἀπεκρίθη ὁ Θωμᾶς, καὶ εἶπεν αὐτῷ, Ὁ Κύριός μου καὶ ὁ Θεός μου. ");
INSERT INTO grctr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Λέγει αὐτῷ ὁ Ἰησοῦς, Ὅτι ἑώρακάς με, Θωμᾶ, πεπίστευκας· μακάριοι οἱ μὴ ἰδόντες, καὶ πιστεύσαντες. ");
INSERT INTO grctr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Πολλὰ μὲν οὖν καὶ ἄλλα σημεῖα ἐποίησεν ὁ Ἰησοῦς ἐνώπιον τῶν μαθητῶν αὐτοῦ, ἃ οὐκ ἔστι γεγραμμένα ἐν τῷ βιβλίῳ τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ταῦτα δὲ γέγραπται, ἵνα πιστεύσητε ὅτι ὁ Ἰησοῦς ἐστιν ὁ Χριστὸς ὁ υἱὸς τοῦ Θεοῦ, καὶ ἵνα πιστεύοντες ζωὴν ἔχητε ἐν τῷ ὀνόματι αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Μετὰ ταῦτα ἐφανέρωσεν ἑαυτὸν πάλιν ὁ Ἰησοῦς τοῖς μαθηταῖς ἐπὶ τῆς θαλάσσης τῆς Τιβεριάδος· ἐφανέρωσε δὲ οὕτως. ");
INSERT INTO grctr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ἦσαν ὁμοῦ Σίμων Πέτρος, καὶ Θωμᾶς ὁ λεγόμενος Δίδυμος, καὶ Ναθαναὴλ ὁ ἀπὸ Κανᾶ τῆς Γαλιλαίας, καὶ οἱ τοῦ Ζεβεδαίου, καὶ ἄλλοι ἐκ τῶν μαθητῶν αὐτοῦ δύο. ");
INSERT INTO grctr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Λέγει αὐτοῖς Σίμων Πέτρος, Ὑπάγω ἁλιεύειν. Λέγουσιν αὐτῷ, Ἐρχόμεθα καὶ ἡμεῖς σὺν σοί. Ἐξῆλθον καὶ ἀνέβησαν εἰς τὸ πλοῖον εὐθύς, καὶ ἐν ἐκείνῃ τῇ νυκτὶ ἐπίασαν οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Πρωΐας δὲ ἤδη γενομένης ἔστη ὁ Ἰησοῦς εἰς τὸν αἰγιαλόν· οὐ μέντοι ᾔδεισαν οἱ μαθηταὶ ὅτι Ἰησοῦς ἐστι. ");
INSERT INTO grctr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Λέγει οὖν αὐτοῖς ὁ Ἰησοῦς, Παιδία, μή τι προσφάγιον ἔχετε; Ἀπεκρίθησαν αὐτῷ, Οὔ. ");
INSERT INTO grctr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ὁ δὲ εἶπεν αὐτοῖς, Βάλετε εἰς τὰ δεξιὰ μέρη τοῦ πλοίου τὸ δίκτυον, καὶ εὑρήσετε. Ἔβαλον οὖν, καὶ οὐκέτι αὐτὸ ἑλκύσαι ἴσχυσαν ἀπὸ τοῦ πλήθους τῶν ἰχθύων. ");
INSERT INTO grctr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Λέγει οὖν ὁ μαθητὴς ἐκεῖνος ὃν ἠγάπα ὁ Ἰησοῦς τῷ Πέτρῳ, Ὁ Κύριός ἐστι. Σίμων οὖν Πέτρος, ἀκούσας ὅτι ὁ Κύριός ἐστι, τὸν ἐπενδύτην διεζώσατο — ἦν γὰρ γυμνός — καὶ ἔβαλεν ἑαυτὸν εἰς τὴν θάλασσαν. ");
INSERT INTO grctr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Οἱ δὲ ἄλλοι μαθηταὶ τῷ πλοιαρίῳ ἦλθον — οὐ γὰρ ἦσαν μακρὰν ἀπὸ τῆς γῆς, ἀλλ᾿ ὡς ἀπὸ πηχῶν διακοσίων — σύροντες τὸ δίκτυον τῶν ἰχθύων. ");
INSERT INTO grctr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ὡς οὖν ἀπέβησαν εἰς τὴν γῆν, βλέπουσιν ἀνθρακιὰν κειμένην καὶ ὀψάριον ἐπικείμενον, καὶ ἄρτον. ");
INSERT INTO grctr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Λέγει αὐτοῖς ὁ Ἰησοῦς, Ἐνέγκατε ἀπὸ τῶν ὀψαρίων ὧν ἐπιάσατε νῦν. ");
INSERT INTO grctr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ἀνέβη Σίμων Πέτρος, καὶ εἵλκυσε τὸ δίκτυον ἐπὶ τῆς γῆς, μεστὸν ἰχθύων μεγάλων ἑκατὸν πεντήκοντα τριῶν· καὶ τοσούτων ὄντων, οὐκ ἐσχίσθη τὸ δίκτυον. ");
INSERT INTO grctr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Λέγει αὐτοῖς ὁ Ἰησοῦς, Δεῦτε ἀριστήσατε. Οὐδεὶς δὲ ἐτόλμα τῶν μαθητῶν ἐξετάσαι αὐτόν, Σὺ τίς εἶ; εἰδότες ὅτι ὁ Κύριός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ἔρχεται οὖν ὁ Ἰησοῦς, καὶ λαμβάνει τὸν ἄρτον, καὶ δίδωσιν αὐτοῖς, καὶ τὸ ὀψάριον ὁμοίως. ");
INSERT INTO grctr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Τοῦτο ἤδη τρίτον ἐφανερώθη ὁ Ἰησοῦς τοῖς μαθηταῖς αὐτοῦ, ἐγερθεὶς ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ὅτε οὖν ἠρίστησαν, λέγει τῷ Σίμωνι Πέτρῳ ὁ Ἰησοῦς, Σίμων Ἰωνᾶ, ἀγαπᾷς με πλεῖον τούτων; Λέγει αὐτῷ, Ναὶ Κύριε· σὺ οἶδας ὅτι φιλῶ σε. Λέγει αὐτῷ, Βόσκε τὰ ἀρνία μου. ");
INSERT INTO grctr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Λέγει αὐτῷ πάλιν δεύτερον, Σίμων Ἰωνᾶ, ἀγαπᾷς με; Λέγει αὐτῷ, Ναὶ Κύριε· σὺ οἶδας ὅτι φιλῶ σε. Λέγει αὐτῷ, Ποίμαινε τὰ πρόβατά μου. ");
INSERT INTO grctr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Λέγει αὐτῷ τὸ τρίτον, Σίμων Ἰωνᾶ, φιλεῖς με; Ἐλυπήθη ὁ Πέτρος ὅτι εἶπεν αὐτῷ τὸ τρίτον, Φιλεῖς με; Καὶ εἶπεν αὐτῷ, Κύριε, σὺ πάντα οἶδας· σὺ γινώσκεις ὅτι φιλῶ σε. Λέγει αὐτῷ ὁ Ἰησοῦς, Βόσκε τὰ πρόβατά μου. ");
INSERT INTO grctr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ἀμὴν ἀμὴν λέγω σοι, ὅτε ἦς νεώτερος, ἐζώννυες σεαυτόν, καὶ περιεπάτεις ὅπου ἤθελες· ὅταν δὲ γηράσῃς, ἐκτενεῖς τὰς χεῖράς σου, καὶ ἄλλος σε ζώσει, καὶ οἴσει ὅπου οὐ θέλεις. ");
INSERT INTO grctr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Τοῦτο δὲ εἶπε, σημαίνων ποίῳ θανάτῳ δοξάσει τὸν Θεόν. Καὶ τοῦτο εἰπὼν λέγει αὐτῷ, Ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ἐπιστραφεὶς δὲ ὁ Πέτρος βλέπει τὸν μαθητὴν ὃν ἠγάπα ὁ Ἰησοῦς ἀκολουθοῦντα, ὃς καὶ ἀνέπεσεν ἐν τῷ δείπνῳ ἐπὶ τὸ στῆθος αὐτοῦ καὶ εἶπε, Κύριε, τίς ἐστιν ὁ παραδιδούς σε; ");
INSERT INTO grctr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Τοῦτον ἰδὼν ὁ Πέτρος λέγει τῷ Ἰησοῦ, Κύριε, οὗτος δὲ τί; ");
INSERT INTO grctr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Λέγει αὐτῷ ὁ Ἰησοῦς, Ἐὰν αὐτὸν θέλω μένειν ἕως ἔρχομαι, τί πρός σε; Σὺ ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ἐξῆλθεν οὖν ὁ λόγος οὗτος εἰς τοὺς ἀδελφούς, ὅτι ὁ μαθητὴς ἐκεῖνος οὐκ ἀποθνῄσκει· καὶ οὐκ εἶπεν αὐτῷ ὁ Ἰησοῦς, ὅτι οὐκ ἀποθνῄσκει· ἀλλ᾿, Ἐὰν αὐτὸν θέλω μένειν ἕως ἔρχομαι, τί πρός σε; ");
INSERT INTO grctr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Οὗτός ἐστιν ὁ μαθητὴς ὁ μαρτυρῶν περὶ τούτων, καὶ γράψας ταῦτα· καὶ οἴδαμεν ὅτι ἀληθής ἐστιν ἡ μαρτυρία αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ἔστι δὲ καὶ ἄλλα πολλὰ ὅσα ἐποίησεν ὁ Ἰησοῦς, ἅτινα ἐὰν γράφηται καθ᾿ ἕν, οὐδὲ αὐτὸν οἶμαι τὸν κόσμον χωρῆσαι τὰ γραφόμενα βιβλία. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Τὸν μὲν πρῶτον λόγον ἐποιησάμην περὶ πάντων, ὦ Θεόφιλε, ὧν ἤρξατο ὁ Ἰησοῦς ποιεῖν τε καὶ διδάσκειν, ");
INSERT INTO grctr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ἄχρι ἧς ἡμέρας, ἐντειλάμενος τοῖς ἀποστόλοις διὰ πνεύματος ἁγίου οὓς ἐξελέξατο, ἀνελήφθη· ");
INSERT INTO grctr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","οἷς καὶ παρέστησεν ἑαυτὸν ζῶντα μετὰ τὸ παθεῖν αὐτὸν ἐν πολλοῖς τεκμηρίοις, δι᾿ ἡμερῶν τεσσαράκοντα ὀπτανόμενος αὐτοῖς, καὶ λέγων τὰ περὶ τῆς βασιλείας τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Καὶ συναλιζόμενος παρήγγειλεν αὐτοῖς ἀπὸ Ἱεροσολύμων μὴ χωρίζεσθαι, ἀλλὰ περιμένειν τὴν ἐπαγγελίαν τοῦ πατρός, Ἣν ἠκούσατέ μου· ");
INSERT INTO grctr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ὅτι Ἰωάννης μὲν ἐβάπτισεν ὕδατι, ὑμεῖς δὲ βαπτισθήσεσθε ἐν πνεύματι ἁγίῳ οὐ μετὰ πολλὰς ταύτας ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Οἱ μὲν οὖν συνελθόντες ἐπηρώτων αὐτὸν λέγοντες, Κύριε, εἰ ἐν τῷ χρόνῳ τούτῳ ἀποκαθιστάνεις τὴν βασιλείαν τῷ Ἰσραήλ; ");
INSERT INTO grctr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Εἶπε δὲ πρὸς αὐτούς, Οὐχ ὑμῶν ἐστι γνῶναι χρόνους ἢ καιροὺς οὓς ὁ πατὴρ ἔθετο ἐν τῇ ἰδίᾳ ἐξουσίᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ἀλλὰ λήψεσθε δύναμιν, ἐπελθόντος τοῦ ἁγίου πνεύματος ἐφ᾿ ὑμᾶς· καὶ ἔσεσθέ μοι μάρτυρες ἔν τε Ἱερουσαλήμ, καὶ ἐν πάσῃ τῇ Ἰουδαίᾳ καὶ Σαμαρείᾳ, καὶ ἕως ἐσχάτου τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Καὶ ταῦτα εἰπών, βλεπόντων αὐτῶν ἐπήρθη, καὶ νεφέλη ὑπέλαβεν αὐτὸν ἀπὸ τῶν ὀφθαλμῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Καὶ ὡς ἀτενίζοντες ἦσαν εἰς τὸν οὐρανόν, πορευομένου αὐτοῦ, καὶ ἰδοὺ ἄνδρες δύο παρειστήκεισαν αὐτοῖς ἐν ἐσθῆτι λευκῇ, ");
INSERT INTO grctr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","οἳ καὶ εἶπον, Ἄνδρες Γαλιλαῖοι, τί ἑστήκατε ἐμβλέποντες εἰς τὸν οὐρανόν; Οὗτος ὁ Ἰησοῦς, ὁ ἀναληφθεὶς ἀφ᾿ ὑμῶν εἰς τὸν οὐρανόν, οὕτως ἐλεύσεται ὃν τρόπον ἐθεάσασθε αὐτὸν πορευόμενον εἰς τὸν οὐρανόν. ");
INSERT INTO grctr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Τότε ὑπέστρεψαν εἰς Ἱερουσαλὴμ ἀπὸ ὄρους τοῦ καλουμένου Ἐλαιῶνος, ὅ ἐστιν ἐγγὺς Ἱερουσαλήμ, σαββάτου ἔχον ὁδόν. ");
INSERT INTO grctr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Καὶ ὅτε εἰσῆλθον, ἀνέβησαν εἰς τὸ ὑπερῷον οὗ ἦσαν καταμένοντες, ὅ τε Πέτρος καὶ Ἰάκωβος καὶ Ἰωάννης καὶ Ἀνδρέας, Φίλιππος καὶ Θωμᾶς, Βαρθολομαῖος καὶ Ματθαῖος, Ἰάκωβος Ἀλφαίου καὶ Σίμων ὁ Ζηλωτής, καὶ Ἰούδας Ἰακώβου. ");
INSERT INTO grctr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Οὗτοι πάντες ἦσαν προσκαρτεροῦντες ὁμοθυμαδὸν τῇ προσευχῇ καὶ τῇ δεήσει, σὺν γυναιξὶ καὶ Μαρίᾳ τῇ μητρὶ τοῦ Ἰησοῦ, καὶ σὺν τοῖς ἀδελφοῖς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Καὶ ἐν ταῖς ἡμέραις ταύταις ἀναστὰς Πέτρος ἐν μέσῳ τῶν μαθητῶν εἶπεν — ἦν τε ὄχλος ὀνομάτων ἐπὶ τὸ αὐτὸ ὡς ἑκατὸν εἴκοσιν — ");
INSERT INTO grctr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ἄνδρες ἀδελφοί, ἔδει πληρωθῆναι τὴν γραφὴν ταύτην, ἣν προεῖπε τὸ πνεῦμα τὸ ἅγιον διὰ στόματος Δαβὶδ περὶ Ἰούδα, τοῦ γενομένου ὁδηγοῦ τοῖς συλλαβοῦσι τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ὅτι κατηριθμημένος ἦν σὺν ἡμῖν, καὶ ἔλαχε τὸν κλῆρον τῆς διακονίας ταύτης — ");
INSERT INTO grctr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Οὗτος μὲν οὖν ἐκτήσατο χωρίον ἐκ τοῦ μισθοῦ τῆς ἀδικίας, καὶ πρηνὴς γενόμενος ἐλάκησε μέσος, καὶ ἐξεχύθη πάντα τὰ σπλάγχνα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Καὶ γνωστὸν ἐγένετο πᾶσι τοῖς κατοικοῦσιν Ἱερουσαλήμ, ὥστε κληθῆναι τὸ χωρίον ἐκεῖνο τῇ ἰδίᾳ διαλέκτῳ αὐτῶν Ἀκελδαμά, τοῦτ᾿ ἔστι, χωρίον αἵματος — ");
INSERT INTO grctr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Γέγραπται γὰρ ἐν βίβλῳ Ψαλμῶν, Γενηθήτω ἡ ἔπαυλις αὐτοῦ ἔρημος, καὶ μὴ ἔστω ὁ κατοικῶν ἐν αὐτῇ· καί, Τὴν ἐπισκοπὴν αὐτοῦ λάβοι ἕτερος. ");
INSERT INTO grctr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Δεῖ οὖν τῶν συνελθόντων ἡμῖν ἀνδρῶν ἐν παντὶ χρόνῳ ἐν ᾧ εἰσῆλθε καὶ ἐξῆλθεν ἐφ᾿ ἡμᾶς ὁ Κύριος Ἰησοῦς, ");
INSERT INTO grctr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ἀρξάμενος ἀπὸ τοῦ βαπτίσματος Ἰωάννου, ἕως τῆς ἡμέρας ἧς ἀνελήφθη ἀφ᾿ ἡμῶν, μάρτυρα τῆς ἀναστάσεως αὐτοῦ γενέσθαι σὺν ἡμῖν ἕνα τούτων. ");
INSERT INTO grctr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Καὶ ἔστησαν δύο, Ἰωσὴφ τὸν καλούμενον Βαρσαβᾶν, ὃς ἐπεκλήθη Ἰοῦστος, καὶ Ματθίαν. ");
INSERT INTO grctr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Καὶ προσευξάμενοι εἶπον, Σὺ Κύριε καρδιογνῶστα πάντων, ἀνάδειξον ἐκ τούτων τῶν δύο ἕνα ὃν ἐξελέξω, ");
INSERT INTO grctr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","λαβεῖν τὸν κλῆρον τῆς διακονίας ταύτης καὶ ἀποστολῆς, ἐξ ἧς παρέβη Ἰούδας, πορευθῆναι εἰς τὸν τόπον τὸν ἴδιον. ");
INSERT INTO grctr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Καὶ ἔδωκαν κλήρους αὐτῶν, καὶ ἔπεσεν ὁ κλῆρος ἐπὶ Ματθίαν, καὶ συγκατεψηφίσθη μετὰ τῶν ἕνδεκα ἀποστόλων. ");
INSERT INTO grctr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Καὶ ἐν τῷ συμπληροῦσθαι τὴν ἡμέραν τῆς Πεντηκοστῆς, ἦσαν ἅπαντες ὁμοθυμαδὸν ἐπὶ τὸ αὐτό. ");
INSERT INTO grctr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Καὶ ἐγένετο ἄφνω ἐκ τοῦ οὐρανοῦ ἦχος ὥσπερ φερομένης πνοῆς βιαίας, καὶ ἐπλήρωσεν ὅλον τὸν οἶκον οὗ ἦσαν καθήμενοι. ");
INSERT INTO grctr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Καὶ ὤφθησαν αὐτοῖς διαμεριζόμεναι γλῶσσαι ὡσεὶ πυρός, ἐκάθισέ τε ἐφ᾿ ἕνα ἕκαστον αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Καὶ ἐπλήσθησαν ἅπαντες πνεύματος ἁγίου, καὶ ἤρξαντο λαλεῖν ἑτέραις γλώσσαις, καθὼς τὸ πνεῦμα ἐδίδου αὐτοῖς ἀποφθέγγεσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ἦσαν δὲ ἐν Ἱερουσαλὴμ κατοικοῦντες Ἰουδαῖοι, ἄνδρες εὐλαβεῖς, ἀπὸ παντὸς ἔθνους τῶν ὑπὸ τὸν οὐρανόν. ");
INSERT INTO grctr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Γενομένης δὲ τῆς φωνῆς ταύτης, συνῆλθε τὸ πλῆθος καὶ συνεχύθη, ὅτι ἤκουον εἷς ἕκαστος τῇ ἰδίᾳ διαλέκτῳ λαλούντων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ἐξίσταντο δὲ πάντες καὶ ἐθαύμαζον, λέγοντες πρὸς ἀλλήλους, Οὐκ ἰδοὺ πάντες οὗτοί εἰσιν οἱ λαλοῦντες Γαλιλαῖοι; ");
INSERT INTO grctr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Καὶ πῶς ἡμεῖς ἀκούομεν ἕκαστος τῇ ἰδίᾳ διαλέκτῳ ἡμῶν ἐν ᾗ ἐγεννήθημεν; ");
INSERT INTO grctr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Πάρθοι καὶ Μῆδοι καὶ Ἐλαμῖται, καὶ οἱ κατοικοῦντες τὴν Μεσοποταμίαν, Ἰουδαίαν τε καὶ Καππαδοκίαν, Πόντον καὶ τὴν Ἀσίαν, ");
INSERT INTO grctr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Φρυγίαν τε καὶ Παμφυλίαν, Αἴγυπτον καὶ τὰ μέρη τῆς Λιβύης τῆς κατὰ Κυρήνην, καὶ οἱ ἐπιδημοῦντες Ῥωμαῖοι, Ἰουδαῖοί τε καὶ προσήλυτοι, ");
INSERT INTO grctr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Κρῆτες καὶ Ἄραβες, ἀκούομεν λαλούντων αὐτῶν ταῖς ἡμετέραις γλώσσαις τὰ μεγαλεῖα τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ἐξίσταντο δὲ πάντες καὶ διηπόρουν, ἄλλος πρὸς ἄλλον λέγοντες, Τί ἂν θέλοι τοῦτο εἶναι; ");
INSERT INTO grctr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ἕτεροι δὲ χλευάζοντες ἔλεγον ὅτι Γλεύκους μεμεστωμένοι εἰσί. ");
INSERT INTO grctr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Σταθεὶς δὲ Πέτρος σὺν τοῖς ἕνδεκα, ἐπῆρε τὴν φωνὴν αὐτοῦ, καὶ ἀπεφθέγξατο αὐτοῖς, Ἄνδρες Ἰουδαῖοι, καὶ οἱ κατοικοῦντες Ἱερουσαλὴμ ἅπαντες, τοῦτο ὑμῖν γνωστὸν ἔστω, καὶ ἐνωτίσασθε τὰ ῥήματά μου. ");
INSERT INTO grctr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Οὐ γάρ, ὡς ὑμεῖς ὑπολαμβάνετε, οὗτοι μεθύουσιν· ἔστι γὰρ ὥρα τρίτη τῆς ἡμέρας· ");
INSERT INTO grctr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ἀλλὰ τοῦτό ἐστι τὸ εἰρημένον διὰ τοῦ προφήτου Ἰωήλ, ");
INSERT INTO grctr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Καὶ ἔσται ἐν ταῖς ἐσχάταις ἡμέραις, λέγει ὁ Θεός, ἐκχεῶ ἀπὸ τοῦ πνεύματός μου ἐπὶ πᾶσαν σάρκα· καὶ προφητεύσουσιν οἱ υἱοὶ ὑμῶν καὶ αἱ θυγατέρες ὑμῶν, καὶ οἱ νεανίσκοι ὑμῶν ὁράσεις ὄψονται, καὶ οἱ πρεσβύτεροι ὑμῶν ἐνύπνια ἐνυπνιασθήσονται· ");
INSERT INTO grctr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","καί γε ἐπὶ τοὺς δούλους μου καὶ ἐπὶ τὰς δούλας μου ἐν ταῖς ἡμέραις ἐκείναις ἐκχεῶ ἀπὸ τοῦ πνεύματός μου, καὶ προφητεύσουσι. ");
INSERT INTO grctr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Καὶ δώσω τέρατα ἐν τῷ οὐρανῷ ἄνω, καὶ σημεῖα ἐπὶ τῆς γῆς κάτω, αἷμα καὶ πῦρ καὶ ἀτμίδα καπνοῦ· ");
INSERT INTO grctr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ὁ ἥλιος μεταστραφήσεται εἰς σκότος, καὶ ἡ σελήνη εἰς αἷμα, πρὶν ἢ ἐλθεῖν τὴν ἡμέραν Κυρίου τὴν μεγάλην καὶ ἐπιφανῆ· ");
INSERT INTO grctr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","καὶ ἔσται, πᾶς ὃς ἂν ἐπικαλέσηται τὸ ὄνομα Κυρίου σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ἄνδρες Ἰσραηλῖται, ἀκούσατε τοὺς λόγους τούτους· Ἰησοῦν τὸν Ναζωραῖον, ἄνδρα ἀπὸ τοῦ Θεοῦ ἀποδεδειγμένον εἰς ὑμᾶς δυνάμεσι καὶ τέρασι καὶ σημείοις, οἷς ἐποίησε δι᾿ αὐτοῦ ὁ Θεὸς ἐν μέσῳ ὑμῶν, καθὼς καὶ αὐτοὶ οἴδατε, ");
INSERT INTO grctr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","τοῦτον τῇ ὡρισμένῃ βουλῇ καὶ προγνώσει τοῦ Θεοῦ ἔκδοτον λαβόντες, διὰ χειρῶν ἀνόμων προσπήξαντες ἀνείλετε· ");
INSERT INTO grctr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ὃν ὁ Θεὸς ἀνέστησε, λύσας τὰς ὠδῖνας τοῦ θανάτου, καθότι οὐκ ἦν δυνατὸν κρατεῖσθαι αὐτὸν ὑπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Δαβὶδ γὰρ λέγει εἰς αὐτόν, Προωρώμην τὸν Κύριον ἐνώπιόν μου διὰ παντός· ὅτι ἐκ δεξιῶν μου ἐστίν, ἵνα μὴ σαλευθῶ· ");
INSERT INTO grctr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","διὰ τοῦτο εὐφράνθη ἡ καρδία μου, καὶ ἠγαλλιάσατο ἡ γλῶσσά μου· ἔτι δὲ καὶ ἡ σάρξ μου κατασκηνώσει ἐπ᾿ ἐλπίδι· ");
INSERT INTO grctr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ὅτι οὐκ ἐγκαταλείψεις τὴν ψυχήν μου εἰς ᾍδου, οὐδὲ δώσεις τὸν ὅσιόν σου ἰδεῖν διαφθοράν. ");
INSERT INTO grctr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ἐγνώρισάς μοι ὁδοὺς ζωῆς· πληρώσεις με εὐφροσύνης μετὰ τοῦ προσώπου σου. ");
INSERT INTO grctr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ἄνδρες ἀδελφοί, ἐξὸν εἰπεῖν μετὰ παρρησίας πρὸς ὑμᾶς περὶ τοῦ πατριάρχου Δαβίδ, ὅτι καὶ ἐτελεύτησε καὶ ἐτάφη, καὶ τὸ μνῆμα αὐτοῦ ἐστιν ἐν ἡμῖν ἄχρι τῆς ἡμέρας ταύτης. ");
INSERT INTO grctr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Προφήτης οὖν ὑπάρχων, καὶ εἰδὼς ὅτι ὅρκῳ ὤμοσεν αὐτῷ ὁ Θεός, ἐκ καρποῦ τῆς ὀσφύος αὐτοῦ τὸ κατὰ σάρκα ἀναστήσειν τὸν Χριστόν, καθίσαι ἐπὶ τοῦ θρόνου αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","προϊδὼν ἐλάλησε περὶ τῆς ἀναστάσεως τοῦ Χριστοῦ, ὅτι οὐ κατελείφθη ἡ ψυχὴ αὐτοῦ εἰς ᾍδου, οὐδὲ ἡ σὰρξ αὐτοῦ εἶδε διαφθοράν. ");
INSERT INTO grctr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Τοῦτον τὸν Ἰησοῦν ἀνέστησεν ὁ Θεός, οὗ πάντες ἡμεῖς ἐσμεν μάρτυρες. ");
INSERT INTO grctr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Τῇ δεξιᾷ οὖν τοῦ Θεοῦ ὑψωθείς, τήν τε ἐπαγγελίαν τοῦ ἁγίου πνεύματος λαβὼν παρὰ τοῦ πατρός, ἐξέχεε τοῦτο ὃ νῦν ὑμεῖς βλέπετε καὶ ἀκούετε. ");
INSERT INTO grctr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Οὐ γὰρ Δαβὶδ ἀνέβη εἰς τοὺς οὐρανούς, λέγει δὲ αὐτός, Εἶπεν ὁ Κύριος τῷ Κυρίῳ μου, Κάθου ἐκ δεξιῶν μου, ");
INSERT INTO grctr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου. ");
INSERT INTO grctr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ἀσφαλῶς οὖν γινωσκέτω πᾶς οἶκος Ἰσραήλ, ὅτι καὶ Κύριον καὶ Χριστὸν αὐτὸν ὁ Θεὸς ἐποίησε, τοῦτον τὸν Ἰησοῦν ὃν ὑμεῖς ἐσταυρώσατε. ");
INSERT INTO grctr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ἀκούσαντες δὲ κατενύγησαν τῇ καρδίᾳ, εἶπόν τε πρὸς τὸν Πέτρον καὶ τοὺς λοιποὺς ἀποστόλους, Τί ποιήσομεν, ἄνδρες ἀδελφοί; ");
INSERT INTO grctr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Πέτρος δὲ ἔφη πρὸς αὐτούς, Μετανοήσατε, καὶ βαπτισθήτω ἕκαστος ὑμῶν ἐπὶ τῷ ὀνόματι Ἰησοῦ Χριστοῦ εἰς ἄφεσιν ἁμαρτιῶν, καὶ λήψεσθε τὴν δωρεὰν τοῦ ἁγίου πνεύματος. ");
INSERT INTO grctr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ὑμῖν γάρ ἐστιν ἡ ἐπαγγελία, καὶ τοῖς τέκνοις ὑμῶν, καὶ πᾶσι τοῖς εἰς μακράν, ὅσους ἂν προσκαλέσηται Κύριος ὁ Θεὸς ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ἑτέροις τε λόγοις πλείοσι διεμαρτύρετο καὶ παρεκάλει λέγων, Σώθητε ἀπὸ τῆς γενεᾶς τῆς σκολιᾶς ταύτης. ");
INSERT INTO grctr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Οἱ μὲν οὖν ἀσμένως ἀποδεξάμενοι τὸν λόγον αὐτοῦ ἐβαπτίσθησαν· καὶ προσετέθησαν τῇ ἡμέρᾳ ἐκείνῃ ψυχαὶ ὡσεὶ τρισχίλιαι. ");
INSERT INTO grctr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ἦσαν δὲ προσκαρτεροῦντες τῇ διδαχῇ τῶν ἀποστόλων καὶ τῇ κοινωνίᾳ, καὶ τῇ κλάσει τοῦ ἄρτου καὶ ταῖς προσευχαῖς. ");
INSERT INTO grctr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ἐγένετο δὲ πάσῃ ψυχῇ φόβος, πολλά τε τέρατα καὶ σημεῖα διὰ τῶν ἀποστόλων ἐγίνετο. ");
INSERT INTO grctr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Πάντες δὲ οἱ πιστεύοντες ἦσαν ἐπὶ τὸ αὐτό, καὶ εἶχον ἅπαντα κοινά, ");
INSERT INTO grctr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","καὶ τὰ κτήματα καὶ τὰς ὑπάρξεις ἐπίπρασκον, καὶ διεμέριζον αὐτὰ πᾶσι, καθότι ἄν τις χρείαν εἶχε. ");
INSERT INTO grctr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Καθ᾿ ἡμέραν τε προσκαρτεροῦντες ὁμοθυμαδὸν ἐν τῷ ἱερῷ, κλῶντές τε κατ᾿ οἶκον ἄρτον, μετελάμβανον τροφῆς ἐν ἀγαλλιάσει καὶ ἀφελότητι καρδίας, ");
INSERT INTO grctr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","αἰνοῦντες τὸν Θεόν, καὶ ἔχοντες χάριν πρὸς ὅλον τὸν λαόν. Ὁ δὲ Κύριος προσετίθει τοὺς σῳζομένους καθ᾿ ἡμέραν τῇ ἐκκλησίᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ἐπὶ τὸ αὐτὸ δὲ Πέτρος καὶ Ἰωάννης ἀνέβαινον εἰς τὸ ἱερὸν ἐπὶ τὴν ὥραν τῆς προσευχῆς τὴν ἐννάτην. ");
INSERT INTO grctr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Καί τις ἀνὴρ χωλὸς ἐκ κοιλίας μητρὸς αὐτοῦ ὑπάρχων ἐβαστάζετο· ὃν ἐτίθουν καθ᾿ ἡμέραν πρὸς τὴν θύραν τοῦ ἱεροῦ τὴν λεγομένην Ὡραίαν, τοῦ αἰτεῖν ἐλεημοσύνην παρὰ τῶν εἰσπορευομένων εἰς τὸ ἱερόν. ");
INSERT INTO grctr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ὃς ἰδὼν Πέτρον καὶ Ἰωάννην μέλλοντας εἰσιέναι εἰς τὸ ἱερόν, ἠρώτα ἐλεημοσύνην λαβεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ἀτενίσας δὲ Πέτρος εἰς αὐτὸν σὺν τῷ Ἰωάννῃ, εἶπε, Βλέψον εἰς ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ὁ δὲ ἐπεῖχεν αὐτοῖς, προσδοκῶν τι παρ᾿ αὐτῶν λαβεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Εἶπε δὲ Πέτρος, Ἀργύριον καὶ χρυσίον οὐχ ὑπάρχει μοι· ὃ δὲ ἔχω, τοῦτό σοι δίδωμι. Ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ τοῦ Ναζωραίου, ἔγειραι καὶ περιπάτει. ");
INSERT INTO grctr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Καὶ πιάσας αὐτὸν τῆς δεξιᾶς χειρὸς ἤγειρε· παραχρῆμα δὲ ἐστερεώθησαν αὐτοῦ αἱ βάσεις καὶ τὰ σφυρά. ");
INSERT INTO grctr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Καὶ ἐξαλλόμενος ἔστη καὶ περιεπάτει, καὶ εἰσῆλθε σὺν αὐτοῖς εἰς τὸ ἱερόν, περιπατῶν καὶ ἁλλόμενος καὶ αἰνῶν τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Καὶ εἶδεν αὐτὸν πᾶς ὁ λαὸς περιπατοῦντα καὶ αἰνοῦντα τὸν Θεόν· ");
INSERT INTO grctr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ἐπεγίνωσκόν τε αὐτὸν ὅτι οὗτος ἦν ὁ πρὸς τὴν ἐλεημοσύνην καθήμενος ἐπὶ τῇ Ὡραίᾳ πύλῃ τοῦ ἱεροῦ· καὶ ἐπλήσθησαν θάμβους καὶ ἐκστάσεως ἐπὶ τῷ συμβεβηκότι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Κρατοῦντος δὲ τοῦ ἰαθέντος χωλοῦ τὸν Πέτρον καὶ Ἰωάννην, συνέδραμε πρὸς αὐτοὺς πᾶς ὁ λαὸς ἐπὶ τῇ στοᾷ τῇ καλουμένῃ Σολομῶντος, ἔκθαμβοι. ");
INSERT INTO grctr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ἰδὼν δὲ Πέτρος ἀπεκρίνατο πρὸς τὸν λαόν, Ἄνδρες Ἰσραηλῖται, τί θαυμάζετε ἐπὶ τούτῳ, ἢ ἡμῖν τί ἀτενίζετε, ὡς ἰδίᾳ δυνάμει ἢ εὐσεβείᾳ πεποιηκόσι τοῦ περιπατεῖν αὐτόν; ");
INSERT INTO grctr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ὁ Θεὸς Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακώβ, ὁ Θεὸς τῶν πατέρων ἡμῶν, ἐδόξασε τὸν παῖδα αὐτοῦ Ἰησοῦν· ὃν ὑμεῖς παρεδώκατε, καὶ ἠρνήσασθε αὐτὸν κατὰ πρόσωπον Πιλάτου, κρίναντος ἐκείνου ἀπολύειν. ");
INSERT INTO grctr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ὑμεῖς δὲ τὸν ἅγιον καὶ δίκαιον ἠρνήσασθε, καὶ ᾐτήσασθε ἄνδρα φονέα χαρισθῆναι ὑμῖν, ");
INSERT INTO grctr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","τὸν δὲ ἀρχηγὸν τῆς ζωῆς ἀπεκτείνατε· ὃν ὁ Θεὸς ἤγειρεν ἐκ νεκρῶν, οὗ ἡμεῖς μάρτυρές ἐσμεν. ");
INSERT INTO grctr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Καὶ ἐπὶ τῇ πίστει τοῦ ὀνόματος αὐτοῦ, τοῦτον ὃν θεωρεῖτε καὶ οἴδατε ἐστερέωσε τὸ ὄνομα αὐτοῦ· καὶ ἡ πίστις ἡ δι᾿ αὐτοῦ ἔδωκεν αὐτῷ τὴν ὁλοκληρίαν ταύτην ἀπέναντι πάντων ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Καὶ νῦν, ἀδελφοί, οἶδα ὅτι κατὰ ἄγνοιαν ἐπράξατε, ὥσπερ καὶ οἱ ἄρχοντες ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ὁ δὲ Θεὸς ἃ προκατήγγειλε διὰ στόματος πάντων τῶν προφητῶν αὐτοῦ, παθεῖν τὸν Χριστόν, ἐπλήρωσεν οὕτω. ");
INSERT INTO grctr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Μετανοήσατε οὖν καὶ ἐπιστρέψατε, εἰς τὸ ἐξαλειφθῆναι ὑμῶν τὰς ἁμαρτίας, ὅπως ἂν ἔλθωσι καιροὶ ἀναψύξεως ἀπὸ προσώπου τοῦ Κυρίου, ");
INSERT INTO grctr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","καὶ ἀποστείλῃ τὸν προκεκηρυγμένον ὑμῖν Ἰησοῦν Χριστὸν· ");
INSERT INTO grctr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ὃν δεῖ οὐρανὸν μὲν δέξασθαι ἄχρι χρόνων ἀποκαταστάσεως πάντων, ὧν ἐλάλησεν ὁ Θεὸς διὰ στόματος πάντων ἁγίων αὐτοῦ προφητῶν ἀπ᾿ αἰῶνος. ");
INSERT INTO grctr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Μωσῆς μὲν γὰρ πρὸς τοὺς πατέρας εἶπεν ὅτι Προφήτην ὑμῖν ἀναστήσει Κύριος ὁ Θεὸς ὑμῶν ἐκ τῶν ἀδελφῶν ὑμῶν ὡς ἐμέ· αὐτοῦ ἀκούσεσθε κατὰ πάντα ὅσα ἂν λαλήσῃ πρὸς ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ἔσται δέ, πᾶσα ψυχή, ἥτις ἂν μὴ ἀκούσῃ τοῦ προφήτου ἐκείνου, ἐξολοθρευθήσεται ἐκ τοῦ λαοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Καὶ πάντες δὲ οἱ προφῆται ἀπὸ Σαμουὴλ καὶ τῶν καθεξῆς, ὅσοι ἐλάλησαν, καὶ προκατήγγειλαν τὰς ἡμέρας ταύτας. ");
INSERT INTO grctr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ὑμεῖς ἐστε υἱοὶ τῶν προφητῶν, καὶ τῆς διαθήκης ἧς διέθετο ὁ Θεὸς πρὸς τοὺς πατέρας ἡμῶν, λέγων πρὸς Ἀβραάμ, Καὶ τῷ σπέρματί σου ἐνευλογηθήσονται πᾶσαι αἱ πατριαὶ τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ὑμῖν πρῶτον ὁ Θεός, ἀναστήσας τὸν παῖδα αὐτοῦ Ἰησοῦν, ἀπέστειλεν αὐτὸν εὐλογοῦντα ὑμᾶς, ἐν τῷ ἀποστρέφειν ἕκαστον ἀπὸ τῶν πονηριῶν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Λαλούντων δὲ αὐτῶν πρὸς τὸν λαόν, ἐπέστησαν αὐτοῖς οἱ ἱερεῖς καὶ ὁ στρατηγὸς τοῦ ἱεροῦ καὶ οἱ Σαδδουκαῖοι, ");
INSERT INTO grctr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","διαπονούμενοι διὰ τὸ διδάσκειν αὐτοὺς τὸν λαόν, καὶ καταγγέλλειν ἐν τῷ Ἰησοῦ τὴν ἀνάστασιν τὴν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Καὶ ἐπέβαλον αὐτοῖς τὰς χεῖρας, καὶ ἔθεντο εἰς τήρησιν εἰς τὴν αὔριον· ἦν γὰρ ἑσπέρα ἤδη. ");
INSERT INTO grctr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Πολλοὶ δὲ τῶν ἀκουσάντων τὸν λόγον ἐπίστευσαν· καὶ ἐγενήθη ὁ ἀριθμὸς τῶν ἀνδρῶν ὡσεὶ χιλιάδες πέντε. ");
INSERT INTO grctr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ἐγένετο δὲ ἐπὶ τὴν αὔριον συναχθῆναι αὐτῶν τοὺς ἄρχοντας καὶ πρεσβυτέρους καὶ γραμματεῖς εἰς Ἱερουσαλήμ, ");
INSERT INTO grctr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","καὶ Ἄνναν τὸν ἀρχιερέα, καὶ Καϊάφαν, καὶ Ἰωάννην, καὶ Ἀλέξανδρον, καὶ ὅσοι ἦσαν ἐκ γένους ἀρχιερατικοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Καὶ στήσαντες αὐτοὺς ἐν τῷ μέσῳ ἐπυνθάνοντο, Ἐν ποίᾳ δυνάμει ἢ ἐν ποίῳ ὀνόματι ἐποιήσατε τοῦτο ὑμεῖς; ");
INSERT INTO grctr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Τότε Πέτρος πλησθεὶς πνεύματος ἁγίου εἶπε πρὸς αὐτούς, Ἄρχοντες τοῦ λαοῦ καὶ πρεσβύτεροι τοῦ Ἰσραήλ, ");
INSERT INTO grctr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","εἰ ἡμεῖς σήμερον ἀνακρινόμεθα ἐπὶ εὐεργεσίᾳ ἀνθρώπου ἀσθενοῦς, ἐν τίνι οὗτος σέσῳσται· ");
INSERT INTO grctr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","γνωστὸν ἔστω πᾶσιν ὑμῖν καὶ παντὶ τῷ λαῷ Ἰσραήλ, ὅτι ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ τοῦ Ναζωραίου, ὃν ὑμεῖς ἐσταυρώσατε, ὃν ὁ Θεὸς ἤγειρεν ἐκ νεκρῶν, ἐν τούτῳ οὗτος παρέστηκεν ἐνώπιον ὑμῶν ὑγιής. ");
INSERT INTO grctr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Οὗτός ἐστιν ὁ λίθος ὁ ἐξουθενηθεὶς ὑφ᾿ ὑμῶν τῶν οἰκοδομούντων, ὁ γενόμενος εἰς κεφαλὴν γωνίας. ");
INSERT INTO grctr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Καὶ οὐκ ἔστιν ἐν ἄλλῳ οὐδενὶ ἡ σωτηρία· οὔτε γὰρ ὄνομά ἐστιν ἕτερον ὑπὸ τὸν οὐρανὸν τὸ δεδομένον ἐν ἀνθρώποις, ἐν ᾧ δεῖ σωθῆναι ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Θεωροῦντες δὲ τὴν τοῦ Πέτρου παρρησίαν καὶ Ἰωάννου, καὶ καταλαβόμενοι ὅτι ἄνθρωποι ἀγράμματοί εἰσι καὶ ἰδιῶται, ἐθαύμαζον, ἐπεγίνωσκόν τε αὐτοὺς ὅτι σὺν τῷ Ἰησοῦ ἦσαν. ");
INSERT INTO grctr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Τὸν δὲ ἄνθρωπον βλέποντες σὺν αὐτοῖς ἑστῶτα τὸν τεθεραπευμένον, οὐδὲν εἶχον ἀντειπεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Κελεύσαντες δὲ αὐτοὺς ἔξω τοῦ συνεδρίου ἀπελθεῖν, συνέβαλον πρὸς ἀλλήλους, ");
INSERT INTO grctr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","λέγοντες, Τί ποιήσομεν τοῖς ἀνθρώποις τούτοις; Ὅτι μὲν γὰρ γνωστὸν σημεῖον γέγονε δι᾿ αὐτῶν, πᾶσι τοῖς κατοικοῦσιν Ἱερουσαλὴμ φανερόν, καὶ οὐ δυνάμεθα ἀρνήσασθαι. ");
INSERT INTO grctr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ἀλλ᾿ ἵνα μὴ ἐπὶ πλεῖον διανεμηθῇ εἰς τὸν λαόν, ἀπειλῇ ἀπειλησώμεθα αὐτοῖς μηκέτι λαλεῖν ἐπὶ τῷ ὀνόματι τούτῳ μηδενὶ ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Καὶ καλέσαντες αὐτούς, παρήγγειλαν αὐτοῖς τὸ καθόλου μὴ φθέγγεσθαι μηδὲ διδάσκειν ἐπὶ τῷ ὀνόματι τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ὁ δὲ Πέτρος καὶ Ἰωάννης ἀποκριθέντες πρὸς αὐτοὺς εἶπον, Εἰ δίκαιόν ἐστιν ἐνώπιον τοῦ Θεοῦ ὑμῶν ἀκούειν μᾶλλον ἢ τοῦ Θεοῦ, κρίνατε. ");
INSERT INTO grctr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Οὐ δυνάμεθα γὰρ ἡμεῖς, ἃ εἴδομεν καὶ ἠκούσαμεν, μὴ λαλεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Οἱ δὲ προσαπειλησάμενοι ἀπέλυσαν αὐτούς, μηδὲν εὑρίσκοντες τὸ πῶς κολάσωνται αὐτούς, διὰ τὸν λαόν, ὅτι πάντες ἐδόξαζον τὸν Θεὸν ἐπὶ τῷ γεγονότι. ");
INSERT INTO grctr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ἐτῶν γὰρ ἦν πλειόνων τεσσαράκοντα ὁ ἄνθρωπος ἐφ᾿ ὃν ἐγεγόνει τὸ σημεῖον τοῦτο τῆς ἰάσεως. ");
INSERT INTO grctr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ἀπολυθέντες δὲ ἦλθον πρὸς τοὺς ἰδίους, καὶ ἀπήγγειλαν ὅσα πρὸς αὐτοὺς οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι εἶπον. ");
INSERT INTO grctr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Οἱ δὲ ἀκούσαντες ὁμοθυμαδὸν ἦραν φωνὴν πρὸς τὸν Θεόν, καὶ εἶπον, Δέσποτα, σὺ ὁ Θεὸς ὁ ποιήσας τὸν οὐρανὸν καὶ τὴν γῆν καὶ τὴν θάλασσαν καὶ πάντα τὰ ἐν αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ὁ διὰ στόματος Δαβὶδ τοῦ παιδός σου εἰπών, Ἵνα τί ἐφρύαξαν ἔθνη, καὶ λαοὶ ἐμελέτησαν κενά; ");
INSERT INTO grctr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Παρέστησαν οἱ βασιλεῖς τῆς γῆς, καὶ οἱ ἄρχοντες συνήχθησαν ἐπὶ τὸ αὐτὸ κατὰ τοῦ Κυρίου, καὶ κατὰ τοῦ Χριστοῦ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","συνήχθησαν γὰρ ἐπ᾿ ἀληθείας ἐπὶ τὸν ἅγιον παῖδά σου Ἰησοῦν, ὃν ἔχρισας, Ἡρῴδης τε καὶ Πόντιος Πιλάτος, σὺν ἔθνεσι καὶ λαοῖς Ἰσραήλ, ");
INSERT INTO grctr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ποιῆσαι ὅσα ἡ χείρ σου καὶ ἡ βουλή σου προώρισε γενέσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Καὶ τὰ νῦν, Κύριε, ἔπιδε ἐπὶ τὰς ἀπειλὰς αὐτῶν, καὶ δὸς τοῖς δούλοις σου μετὰ παρρησίας πάσης λαλεῖν τὸν λόγον σου, ");
INSERT INTO grctr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ἐν τῷ τὴν χεῖρά σου ἐκτείνειν σε εἰς ἴασιν, καὶ σημεῖα καὶ τέρατα γίνεσθαι διὰ τοῦ ὀνόματος τοῦ ἁγίου παιδός σου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Καὶ δεηθέντων αὐτῶν ἐσαλεύθη ὁ τόπος ἐν ᾧ ἦσαν συνηγμένοι, καὶ ἐπλήσθησαν ἅπαντες πνεύματος ἁγίου, καὶ ἐλάλουν τὸν λόγον τοῦ Θεοῦ μετὰ παρρησίας. ");
INSERT INTO grctr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Τοῦ δὲ πλήθους τῶν πιστευσάντων ἦν ἡ καρδία καὶ ἡ ψυχὴ μία· καὶ οὐδ᾿ εἷς τι τῶν ὑπαρχόντων αὐτῷ ἔλεγεν ἴδιον εἶναι, ἀλλ᾿ ἦν αὐτοῖς ἅπαντα κοινά. ");
INSERT INTO grctr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Καὶ μεγάλῃ δυνάμει ἀπεδίδουν τὸ μαρτύριον οἱ ἀπόστολοι τῆς ἀναστάσεως τοῦ Κυρίου Ἰησοῦ, χάρις τε μεγάλη ἦν ἐπὶ πάντας αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Οὐδὲ γὰρ ἐνδεής τις ὑπῆρχεν ἐν αὐτοῖς· ὅσοι γὰρ κτήτορες χωρίων ἢ οἰκιῶν ὑπῆρχον, πωλοῦντες ἔφερον τὰς τιμὰς τῶν πιπρασκομένων, ");
INSERT INTO grctr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","καὶ ἐτίθουν παρὰ τοὺς πόδας τῶν ἀποστόλων· διεδίδοτο δὲ ἑκάστῳ καθότι ἄν τις χρείαν εἶχεν. ");
INSERT INTO grctr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ἰωσῆς δέ, ὁ ἐπικληθεὶς Βαρνάβας ὑπὸ τῶν ἀποστόλων — ὅ ἐστι, μεθερμηνευόμενον, υἱὸς παρακλήσεως — Λευΐτης, Κύπριος τῷ γένει, ");
INSERT INTO grctr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ὑπάρχοντος αὐτῷ ἀγροῦ, πωλήσας ἤνεγκε τὸ χρῆμα, καὶ ἔθηκε παρὰ τοὺς πόδας τῶν ἀποστόλων. ");
INSERT INTO grctr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ἀνὴρ δέ τις Ἀνανίας ὀνόματι, σὺν Σαπφείρῃ τῇ γυναικὶ αὐτοῦ, ἐπώλησε κτῆμα, ");
INSERT INTO grctr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","καὶ ἐνοσφίσατο ἀπὸ τῆς τιμῆς, συνειδυίας καὶ τῆς γυναικὸς αὐτοῦ, καὶ ἐνέγκας μέρος τι παρὰ τοὺς πόδας τῶν ἀποστόλων ἔθηκεν. ");
INSERT INTO grctr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Εἶπε δὲ Πέτρος, Ἀνανία, διὰ τί ἐπλήρωσεν ὁ Σατανᾶς τὴν καρδίαν σου, ψεύσασθαί σε τὸ πνεῦμα τὸ ἅγιον, καὶ νοσφίσασθαι ἀπὸ τῆς τιμῆς τοῦ χωρίου; ");
INSERT INTO grctr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Οὐχὶ μένον σοὶ ἔμενε, καὶ πραθὲν ἐν τῇ σῇ ἐξουσίᾳ ὑπῆρχε; Τί ὅτι ἔθου ἐν τῇ καρδίᾳ σου τὸ πρᾶγμα τοῦτο; Οὐκ ἐψεύσω ἀνθρώποις, ἀλλὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ἀκούων δὲ Ἀνανίας τοὺς λόγους τούτους, πεσὼν ἐξέψυξε· καὶ ἐγένετο φόβος μέγας ἐπὶ πάντας τοὺς ἀκούοντας ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ἀναστάντες δὲ οἱ νεώτεροι συνέστειλαν αὐτόν, καὶ ἐξενέγκαντες ἔθαψαν. ");
INSERT INTO grctr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ἐγένετο δὲ ὡς ὡρῶν τριῶν διάστημα, καὶ ἡ γυνὴ αὐτοῦ μὴ εἰδυῖα τὸ γεγονὸς εἰσῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ἀπεκρίθη δὲ αὐτῇ ὁ Πέτρος, Εἰπέ μοι, εἰ τοσούτου τὸ χωρίον ἀπέδοσθε; Ἡ δὲ εἶπε, Ναί, τοσούτου. ");
INSERT INTO grctr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ὁ δὲ Πέτρος εἶπε πρὸς αὐτήν, Τί ὅτι συνεφωνήθη ὑμῖν πειράσαι τὸ πνεῦμα Κυρίου; Ἰδού, οἱ πόδες τῶν θαψάντων τὸν ἄνδρα σου ἐπὶ τῇ θύρᾳ, καὶ ἐξοίσουσί σε. ");
INSERT INTO grctr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ἔπεσε δὲ παραχρῆμα παρὰ τοὺς πόδας αὐτοῦ, καὶ ἐξέψυξεν· εἰσελθόντες δὲ οἱ νεανίσκοι εὗρον αὐτὴν νεκράν, καὶ ἐξενέγκαντες ἔθαψαν πρὸς τὸν ἄνδρα αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Καὶ ἐγένετο φόβος μέγας ἐφ᾿ ὅλην τὴν ἐκκλησίαν, καὶ ἐπὶ πάντας τοὺς ἀκούοντας ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Διὰ δὲ τῶν χειρῶν τῶν ἀποστόλων ἐγίνετο σημεῖα καὶ τέρατα ἐν τῷ λαῷ πολλά· καὶ ἦσαν ὁμοθυμαδὸν ἅπαντες ἐν τῇ στοᾷ Σολομῶντος. ");
INSERT INTO grctr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Τῶν δὲ λοιπῶν οὐδεὶς ἐτόλμα κολλᾶσθαι αὐτοῖς, ἀλλ᾿ ἐμεγάλυνεν αὐτοὺς ὁ λαός· ");
INSERT INTO grctr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","μᾶλλον δὲ προσετίθεντο πιστεύοντες τῷ Κυρίῳ, πλήθη ἀνδρῶν τε καὶ γυναικῶν· ");
INSERT INTO grctr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ὥστε κατὰ τὰς πλατείας ἐκφέρειν τοὺς ἀσθενεῖς, καὶ τιθέναι ἐπὶ κλινῶν καὶ κραββάτων, ἵνα ἐρχομένου Πέτρου κἂν ἡ σκιὰ ἐπισκιάσῃ τινὶ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Συνήρχετο δὲ καὶ τὸ πλῆθος τῶν πέριξ πόλεων εἰς Ἱερουσαλήμ, φέροντες ἀσθενεῖς καὶ ὀχλουμένους ὑπὸ πνευμάτων ἀκαθάρτων, οἵτινες ἐθεραπεύοντο ἅπαντες. ");
INSERT INTO grctr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ἀναστὰς δὲ ὁ ἀρχιερεὺς καὶ πάντες οἱ σὺν αὐτῷ — ἡ οὖσα αἵρεσις τῶν Σαδδουκαίων — ἐπλήσθησαν ζήλου, ");
INSERT INTO grctr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","καὶ ἐπέβαλον τὰς χεῖρας αὐτῶν ἐπὶ τοὺς ἀποστόλους, καὶ ἔθεντο αὐτοὺς ἐν τηρήσει δημοσίᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ἄγγελος δὲ Κυρίου διὰ τῆς νυκτὸς ἤνοιξε τὰς θύρας τῆς φυλακῆς, ἐξαγαγών τε αὐτοὺς εἶπε, ");
INSERT INTO grctr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Πορεύεσθε, καὶ σταθέντες λαλεῖτε ἐν τῷ ἱερῷ τῷ λαῷ πάντα τὰ ῥήματα τῆς ζωῆς ταύτης. ");
INSERT INTO grctr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ἀκούσαντες δὲ εἰσῆλθον ὑπὸ τὸν ὄρθρον εἰς τὸ ἱερόν, καὶ ἐδίδασκον. Παραγενόμενος δὲ ὁ ἀρχιερεὺς καὶ οἱ σὺν αὐτῷ, συνεκάλεσαν τὸ συνέδριον καὶ πᾶσαν τὴν γερουσίαν τῶν υἱῶν Ἰσραήλ, καὶ ἀπέστειλαν εἰς τὸ δεσμωτήριον, ἀχθῆναι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Οἱ δὲ ὑπηρέται παραγενόμενοι οὐχ εὗρον αὐτοὺς ἐν τῇ φυλακῇ· ἀναστρέψαντες δὲ ἀπήγγειλαν, ");
INSERT INTO grctr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","λέγοντες ὅτι Τὸ μὲν δεσμωτήριον εὕρομεν κεκλεισμένον ἐν πάσῃ ἀσφαλείᾳ, καὶ τοὺς φύλακας ἔξω ἑστῶτας πρὸ τῶν θυρῶν· ἀνοίξαντες δέ, ἔσω οὐδένα εὕρομεν. ");
INSERT INTO grctr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ὡς δὲ ἤκουσαν τοὺς λόγους τούτους ὅ τε ἱερεὺς καὶ ὁ στρατηγὸς τοῦ ἱεροῦ καὶ οἱ ἀρχιερεῖς, διηπόρουν περὶ αὐτῶν, τί ἂν γένοιτο τοῦτο. ");
INSERT INTO grctr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Παραγενόμενος δέ τις ἀπήγγειλεν αὐτοῖς λέγων ὅτι Ἰδού, οἱ ἄνδρες οὓς ἔθεσθε ἐν τῇ φυλακῇ εἰσὶν ἐν τῷ ἱερῷ ἑστῶτες καὶ διδάσκοντες τὸν λαόν. ");
INSERT INTO grctr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Τότε ἀπελθὼν ὁ στρατηγὸς σὺν τοῖς ὑπηρέταις ἤγαγεν αὐτούς, οὐ μετὰ βίας, ἐφοβοῦντο γὰρ τὸν λαόν, ἵνα μὴ λιθασθῶσιν. ");
INSERT INTO grctr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ἀγαγόντες δὲ αὐτοὺς ἔστησαν ἐν τῷ συνεδρίῳ. Καὶ ἐπηρώτησεν αὐτοὺς ὁ ἀρχιερεύς, ");
INSERT INTO grctr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","λέγων, Οὐ παραγγελίᾳ παρηγγείλαμεν ὑμῖν μὴ διδάσκειν ἐπὶ τῷ ὀνόματι τούτῳ; Καὶ ἰδοὺ πεπληρώκατε τὴν Ἱερουσαλὴμ τῆς διδαχῆς ὑμῶν, καὶ βούλεσθε ἐπαγαγεῖν ἐφ᾿ ἡμᾶς τὸ αἷμα τοῦ ἀνθρώπου τούτου. ");
INSERT INTO grctr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ἀποκριθεὶς δὲ ὁ Πέτρος καὶ οἱ ἀπόστολοι εἶπον, Πειθαρχεῖν δεῖ Θεῷ μᾶλλον ἢ ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ὁ Θεὸς τῶν πατέρων ἡμῶν ἤγειρεν Ἰησοῦν, ὃν ὑμεῖς διεχειρίσασθε, κρεμάσαντες ἐπὶ ξύλου. ");
INSERT INTO grctr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Τοῦτον ὁ Θεὸς ἀρχηγὸν καὶ σωτῆρα ὕψωσε τῇ δεξιᾷ αὐτοῦ, δοῦναι μετάνοιαν τῷ Ἰσραὴλ καὶ ἄφεσιν ἁμαρτιῶν. ");
INSERT INTO grctr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Καὶ ἡμεῖς ἐσμεν αὐτοῦ μάρτυρες τῶν ῥημάτων τούτων, καὶ τὸ πνεῦμα δὲ τὸ ἅγιον, ὃ ἔδωκεν ὁ Θεὸς τοῖς πειθαρχοῦσιν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Οἱ δὲ ἀκούσαντες διεπρίοντο, καὶ ἐβουλεύοντο ἀνελεῖν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ἀναστὰς δέ τις ἐν τῷ συνεδρίῳ Φαρισαῖος, ὀνόματι Γαμαλιήλ, νομοδιδάσκαλος, τίμιος παντὶ τῷ λαῷ, ἐκέλευσεν ἔξω βραχύ τι τοὺς ἀποστόλους ποιῆσαι. ");
INSERT INTO grctr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Εἶπέ τε πρὸς αὐτούς, Ἄνδρες Ἰσραηλῖται, προσέχετε ἑαυτοῖς ἐπὶ τοῖς ἀνθρώποις τούτοις, τί μέλλετε πράσσειν. ");
INSERT INTO grctr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Πρὸ γὰρ τούτων τῶν ἡμερῶν ἀνέστη Θευδᾶς, λέγων εἶναί τινα ἑαυτόν, ᾧ προσεκολλήθη ἀριθμὸς ἀνδρῶν ὡσεὶ τετρακοσίων· ὃς ἀνῃρέθη, καὶ πάντες ὅσοι ἐπείθοντο αὐτῷ διελύθησαν καὶ ἐγένοντο εἰς οὐδέν. ");
INSERT INTO grctr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Μετὰ τοῦτον ἀνέστη Ἰούδας ὁ Γαλιλαῖος ἐν ταῖς ἡμέραις τῆς ἀπογραφῆς, καὶ ἀπέστησε λαὸν ἱκανὸν ὀπίσω αὐτοῦ· κἀκεῖνος ἀπώλετο, καὶ πάντες ὅσοι ἐπείθοντο αὐτῷ διεσκορπίσθησαν. ");
INSERT INTO grctr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Καὶ τὰ νῦν λέγω ὑμῖν, ἀπόστητε ἀπὸ τῶν ἀνθρώπων τούτων, καὶ ἐάσατε αὐτούς· ὅτι ἐὰν ᾖ ἐξ ἀνθρώπων ἡ βουλὴ αὕτη ἢ τὸ ἔργον τοῦτο, καταλυθήσεται· ");
INSERT INTO grctr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","εἰ δὲ ἐκ Θεοῦ ἐστιν, οὐ δύνασθε καταλῦσαι αὐτό, μήποτε καὶ θεομάχοι εὑρεθῆτε. ");
INSERT INTO grctr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ἐπείσθησαν δὲ αὐτῷ· καὶ προσκαλεσάμενοι τοὺς ἀποστόλους, δείραντες παρήγγειλαν μὴ λαλεῖν ἐπὶ τῷ ὀνόματι τοῦ Ἰησοῦ, καὶ ἀπέλυσαν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Οἱ μὲν οὖν ἐπορεύοντο χαίροντες ἀπὸ προσώπου τοῦ συνεδρίου, ὅτι ὑπὲρ τοῦ ὀνόματος αὐτοῦ κατηξιώθησαν ἀτιμασθῆναι. ");
INSERT INTO grctr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Πᾶσάν τε ἡμέραν, ἐν τῷ ἱερῷ καὶ κατ᾿ οἶκον, οὐκ ἐπαύοντο διδάσκοντες καὶ εὐαγγελιζόμενοι Ἰησοῦν τὸν Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ἐν δὲ ταῖς ἡμέραις ταύταις, πληθυνόντων τῶν μαθητῶν, ἐγένετο γογγυσμὸς τῶν Ἑλληνιστῶν πρὸς τοὺς Ἑβραίους, ὅτι παρεθεωροῦντο ἐν τῇ διακονίᾳ τῇ καθημερινῇ αἱ χῆραι αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Προσκαλεσάμενοι δὲ οἱ δώδεκα τὸ πλῆθος τῶν μαθητῶν, εἶπον, Οὐκ ἀρεστόν ἐστιν ἡμᾶς, καταλείψαντας τὸν λόγον τοῦ Θεοῦ, διακονεῖν τραπέζαις. ");
INSERT INTO grctr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ἐπισκέψασθε οὖν, ἀδελφοί, ἄνδρας ἐξ ὑμῶν μαρτυρουμένους ἑπτά, πλήρεις πνεύματος ἁγίου καὶ σοφίας, οὓς καταστήσομεν ἐπὶ τῆς χρείας ταύτης. ");
INSERT INTO grctr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ἡμεῖς δὲ τῇ προσευχῇ καὶ τῇ διακονίᾳ τοῦ λόγου προσκαρτερήσομεν. ");
INSERT INTO grctr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Καὶ ἤρεσεν ὁ λόγος ἐνώπιον παντὸς τοῦ πλήθους· καὶ ἐξελέξαντο Στέφανον, ἄνδρα πλήρη πίστεως καὶ πνεύματος ἁγίου, καὶ Φίλιππον, καὶ Πρόχορον, καὶ Νικάνορα, καὶ Τίμωνα, καὶ Παρμενᾶν, καὶ Νικόλαον προσήλυτον Ἀντιοχέα, ");
INSERT INTO grctr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","οὓς ἔστησαν ἐνώπιον τῶν ἀποστόλων· καὶ προσευξάμενοι ἐπέθηκαν αὐτοῖς τὰς χεῖρας. ");
INSERT INTO grctr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Καὶ ὁ λόγος τοῦ Θεοῦ ηὔξανε, καὶ ἐπληθύνετο ὁ ἀριθμὸς τῶν μαθητῶν ἐν Ἱερουσαλὴμ σφόδρα, πολύς τε ὄχλος τῶν ἱερέων ὑπήκουον τῇ πίστει. ");
INSERT INTO grctr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Στέφανος δὲ πλήρης πίστεως καὶ δυνάμεως ἐποίει τέρατα καὶ σημεῖα μεγάλα ἐν τῷ λαῷ. ");
INSERT INTO grctr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ἀνέστησαν δέ τινες τῶν ἐκ τῆς συναγωγῆς τῆς λεγομένης Λιβερτίνων, καὶ Κυρηναίων, καὶ Ἀλεξανδρέων, καὶ τῶν ἀπὸ Κιλικίας καὶ Ἀσίας, συζητοῦντες τῷ Στεφάνῳ. ");
INSERT INTO grctr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Καὶ οὐκ ἴσχυον ἀντιστῆναι τῇ σοφίᾳ καὶ τῷ πνεύματι ᾧ ἐλάλει. ");
INSERT INTO grctr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Τότε ὑπέβαλον ἄνδρας λέγοντας ὅτι Ἀκηκόαμεν αὐτοῦ λαλοῦντος ῥήματα βλάσφημα εἰς Μωσῆν καὶ τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Συνεκίνησάν τε τὸν λαὸν καὶ τοὺς πρεσβυτέρους καὶ τοὺς γραμματεῖς, καὶ ἐπιστάντες συνήρπασαν αὐτόν, καὶ ἤγαγον εἰς τὸ συνέδριον, ");
INSERT INTO grctr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ἔστησάν τε μάρτυρας ψευδεῖς λέγοντας, Ὁ ἄνθρωπος οὗτος οὐ παύεται ῥήματα βλάσφημα λαλῶν κατὰ τοῦ τόπου τοῦ ἁγίου τούτου καὶ τοῦ νόμου· ");
INSERT INTO grctr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ἀκηκόαμεν γὰρ αὐτοῦ λέγοντος ὅτι Ἰησοῦς ὁ Ναζωραῖος οὗτος καταλύσει τὸν τόπον τοῦτον, καὶ ἀλλάξει τὰ ἔθη ἃ παρέδωκεν ἡμῖν Μωϋσῆς. ");
INSERT INTO grctr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Καὶ ἀτενίσαντες εἰς αὐτὸν ἅπαντες οἱ καθεζόμενοι ἐν τῷ συνεδρίῳ, εἶδον τὸ πρόσωπον αὐτοῦ ὡσεὶ πρόσωπον ἀγγέλου. ");
INSERT INTO grctr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Εἶπε δὲ ὁ ἀρχιερεύς, Εἰ ἄρα ταῦτα οὕτως ἔχει; ");
INSERT INTO grctr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ὁ δὲ ἔφη, Ἄνδρες ἀδελφοὶ καὶ πατέρες, ἀκούσατε. Ὁ Θεὸς τῆς δόξης ὤφθη τῷ πατρὶ ἡμῶν Ἀβραὰμ ὄντι ἐν τῇ Μεσοποταμίᾳ, πρὶν ἢ κατοικῆσαι αὐτὸν ἐν Χαρράν, ");
INSERT INTO grctr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","καὶ εἶπε πρὸς αὐτόν, Ἔξελθε ἐκ τῆς γῆς σου καὶ ἐκ τῆς συγγενείας σου, καὶ δεῦρο εἰς γῆν ἣν ἄν σοι δείξω. ");
INSERT INTO grctr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Τότε ἐξελθὼν ἐκ γῆς Χαλδαίων κατῴκησεν ἐν Χαρράν· κἀκεῖθεν, μετὰ τὸ ἀποθανεῖν τὸν πατέρα αὐτοῦ, μετῴκισεν αὐτὸν εἰς τὴν γῆν ταύτην εἰς ἣν ὑμεῖς νῦν κατοικεῖτε· ");
INSERT INTO grctr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","καὶ οὐκ ἔδωκεν αὐτῷ κληρονομίαν ἐν αὐτῇ, οὐδὲ βῆμα ποδός· καὶ ἐπηγγείλατο αὐτῷ δοῦναι εἰς κατάσχεσιν αὐτήν, καὶ τῷ σπέρματι αὐτοῦ μετ᾿ αὐτόν, οὐκ ὄντος αὐτῷ τέκνου. ");
INSERT INTO grctr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ἐλάλησε δὲ οὕτως ὁ Θεός, ὅτι ἔσται τὸ σπέρμα αὐτοῦ πάροικον ἐν γῇ ἀλλοτρίᾳ, καὶ δουλώσουσιν αὐτὸ καὶ κακώσουσιν, ἔτη τετρακόσια. ");
INSERT INTO grctr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Καὶ τὸ ἔθνος, ᾧ ἐὰν δουλεύσωσι, κρινῶ ἐγώ, εἶπεν ὁ Θεός· καὶ μετὰ ταῦτα ἐξελεύσονται, καὶ λατρεύσουσί μοι ἐν τῷ τόπῳ τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Καὶ ἔδωκεν αὐτῷ διαθήκην περιτομῆς· καὶ οὕτως ἐγέννησε τὸν Ἰσαάκ, καὶ περιέτεμεν αὐτὸν τῇ ἡμέρᾳ τῇ ὀγδόῃ· καὶ ὁ Ἰσαὰκ τὸν Ἰακώβ, καὶ ὁ Ἰακὼβ τοὺς δώδεκα πατριάρχας. ");
INSERT INTO grctr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Καὶ οἱ πατριάρχαι ζηλώσαντες τὸν Ἰωσὴφ ἀπέδοντο εἰς Αἴγυπτον· καὶ ἦν ὁ Θεὸς μετ᾿ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","καὶ ἐξείλετο αὐτὸν ἐκ πασῶν τῶν θλίψεων αὐτοῦ, καὶ ἔδωκεν αὐτῷ χάριν καὶ σοφίαν ἐναντίον Φαραὼ βασιλέως Αἰγύπτου, καὶ κατέστησεν αὐτὸν ἡγούμενον ἐπ᾿ Αἴγυπτον καὶ ὅλον τὸν οἶκον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ἦλθε δὲ λιμὸς ἐφ᾿ ὅλην τὴν γῆν Αἰγύπτου καὶ Χαναάν, καὶ θλίψις μεγάλη· καὶ οὐχ εὕρισκον χορτάσματα οἱ πατέρες ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ἀκούσας δὲ Ἰακὼβ ὄντα σῖτα ἐν Αἰγύπτῳ, ἐξαπέστειλε τοὺς πατέρας ἡμῶν πρῶτον. ");
INSERT INTO grctr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Καὶ ἐν τῷ δευτέρῳ ἀνεγνωρίσθη Ἰωσὴφ τοῖς ἀδελφοῖς αὐτοῦ, καὶ φανερὸν ἐγένετο τῷ Φαραὼ τὸ γένος τοῦ Ἰωσήφ. ");
INSERT INTO grctr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ἀποστείλας δὲ Ἰωσὴφ μετεκαλέσατο τὸν πατέρα αὐτοῦ Ἰακώβ, καὶ πᾶσαν τὴν συγγένειαν αὐτοῦ, ἐν ψυχαῖς ἑβδομήκοντα πέντε. ");
INSERT INTO grctr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Κατέβη δὲ Ἰακὼβ εἰς Αἴγυπτον, καὶ ἐτελεύτησεν αὐτὸς καὶ οἱ πατέρες ἡμῶν· ");
INSERT INTO grctr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","καὶ μετετέθησαν εἰς Συχέμ, καὶ ἐτέθησαν ἐν τῷ μνήματι ὃ ὠνήσατο Ἀβραὰμ τιμῆς ἀργυρίου παρὰ τῶν υἱῶν Ἐμμὸρ τοῦ Συχέμ. ");
INSERT INTO grctr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Καθὼς δὲ ἤγγιζεν ὁ χρόνος τῆς ἐπαγγελίας ἧς ὤμοσεν ὁ Θεὸς τῷ Ἀβραάμ, ηὔξησεν ὁ λαὸς καὶ ἐπληθύνθη ἐν Αἰγύπτῳ, ");
INSERT INTO grctr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ἄχρις οὗ ἀνέστη βασιλεὺς ἕτερος, ὃς οὐκ ᾔδει τὸν Ἰωσήφ. ");
INSERT INTO grctr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Οὗτος κατασοφισάμενος τὸ γένος ἡμῶν, ἐκάκωσε τοὺς πατέρας ἡμῶν, τοῦ ποιεῖν ἔκθετα τὰ βρέφη αὐτῶν, εἰς τὸ μὴ ζῳογονεῖσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ἐν ᾧ καιρῷ ἐγεννήθη Μωσῆς, καὶ ἦν ἀστεῖος τῷ Θεῷ· ὃς ἀνετράφη μῆνας τρεῖς ἐν τῷ οἴκῳ τοῦ πατρὸς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ἐκτεθέντα δὲ αὐτόν, ἀνείλετο αὐτὸν ἡ θυγάτηρ Φαραώ, καὶ ἀνεθρέψατο αὐτὸν ἑαυτῇ εἰς υἱόν. ");
INSERT INTO grctr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Καὶ ἐπαιδεύθη Μωσῆς πάσῃ σοφίᾳ Αἰγυπτίων· ἦν δὲ δυνατὸς ἐν λόγοις καὶ ἐν ἔργοις. ");
INSERT INTO grctr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ὡς δὲ ἐπληροῦτο αὐτῷ τεσσαρακονταετὴς χρόνος, ἀνέβη ἐπὶ τὴν καρδίαν αὐτοῦ ἐπισκέψασθαι τοὺς ἀδελφοὺς αὐτοῦ τοὺς υἱοὺς Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Καὶ ἰδών τινα ἀδικούμενον, ἠμύνατο καὶ ἐποίησεν ἐκδίκησιν τῷ καταπονουμένῳ, πατάξας τὸν Αἰγύπτιον· ");
INSERT INTO grctr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ἐνόμιζε δὲ συνιέναι τοὺς ἀδελφοὺς αὐτοῦ ὅτι ὁ Θεὸς διὰ χειρὸς αὐτοῦ δίδωσιν αὐτοῖς σωτηρίαν· οἱ δὲ οὐ συνῆκαν. ");
INSERT INTO grctr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Τῇ δὲ ἐπιούσῃ ἡμέρᾳ ὤφθη αὐτοῖς μαχομένοις, καὶ συνήλασεν αὐτοὺς εἰς εἰρήνην, εἰπών, Ἄνδρες, ἀδελφοί ἐστε ὑμεῖς· ἵνα τί ἀδικεῖτε ἀλλήλους; ");
INSERT INTO grctr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ὁ δὲ ἀδικῶν τὸν πλησίον ἀπώσατο αὐτόν, εἰπών, Τίς σε κατέστησεν ἄρχοντα καὶ δικαστὴν ἐφ᾿ ἡμᾶς; ");
INSERT INTO grctr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Μὴ ἀνελεῖν με σὺ θέλεις, ὃν τρόπον ἀνεῖλες χθὲς τὸν Αἰγύπτιον; ");
INSERT INTO grctr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ἔφυγε δὲ Μωσῆς ἐν τῷ λόγῳ τούτῳ, καὶ ἐγένετο πάροικος ἐν γῇ Μαδιάμ, οὗ ἐγέννησεν υἱοὺς δύο. ");
INSERT INTO grctr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Καὶ πληρωθέντων ἐτῶν τεσσαράκοντα, ὤφθη αὐτῷ ἐν τῇ ἐρήμῳ τοῦ ὄρους Σινᾶ ἄγγελος Κυρίου ἐν φλογὶ πυρὸς βάτου. ");
INSERT INTO grctr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ὁ δὲ Μωσῆς ἰδὼν ἐθαύμασε τὸ ὅραμα· προσερχομένου δὲ αὐτοῦ κατανοῆσαι, ἐγένετο φωνὴ Κυρίου πρὸς αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ἐγὼ ὁ Θεὸς τῶν πατέρων σου, ὁ Θεὸς Ἀβραὰμ καὶ ὁ Θεὸς Ἰσαὰκ καὶ ὁ Θεὸς Ἰακώβ. Ἔντρομος δὲ γενόμενος Μωσῆς οὐκ ἐτόλμα κατανοῆσαι. ");
INSERT INTO grctr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Εἶπε δὲ αὐτῷ ὁ Κύριος, Λῦσον τὸ ὑπόδημα τῶν ποδῶν σου· ὁ γὰρ τόπος ἐν ᾧ ἕστηκας γῆ ἁγία ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ἰδὼν εἶδον τὴν κάκωσιν τοῦ λαοῦ μου τοῦ ἐν Αἰγύπτῳ, καὶ τοῦ στεναγμοῦ αὐτῶν ἤκουσα· καὶ κατέβην ἐξελέσθαι αὐτούς· καὶ νῦν δεῦρο, ἀποστελῶ σε εἰς Αἴγυπτον. ");
INSERT INTO grctr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Τοῦτον τὸν Μωϋσῆν ὃν ἠρνήσαντο εἰπόντες, Τίς σε κατέστησεν ἄρχοντα καὶ δικαστήν; τοῦτον ὁ Θεὸς ἄρχοντα καὶ λυτρωτὴν ἀπέστειλεν ἐν χειρὶ ἀγγέλου τοῦ ὀφθέντος αὐτῷ ἐν τῇ βάτῳ. ");
INSERT INTO grctr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Οὗτος ἐξήγαγεν αὐτούς, ποιήσας τέρατα καὶ σημεῖα ἐν γῇ Αἰγύπτου καὶ ἐν Ἐρυθρᾷ θαλάσσῃ, καὶ ἐν τῇ ἐρήμῳ ἔτη τεσσαράκοντα. ");
INSERT INTO grctr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Οὗτός ἐστιν ὁ Μωϋσῆς ὁ εἰπὼν τοῖς υἱοῖς Ἰσραήλ, Προφήτην ὑμῖν ἀναστήσει Κύριος ὁ Θεὸς ὑμῶν ἐκ τῶν ἀδελφῶν ὑμῶν ὡς ἐμέ· αὐτοῦ ἀκούσεσθε. ");
INSERT INTO grctr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Οὗτός ἐστιν ὁ γενόμενος ἐν τῇ ἐκκλησίᾳ ἐν τῇ ἐρήμῳ μετὰ τοῦ ἀγγέλου τοῦ λαλοῦντος αὐτῷ ἐν τῷ ὄρει Σινᾶ καὶ τῶν πατέρων ἡμῶν· ὃς ἐδέξατο λόγια ζῶντα δοῦναι ἡμῖν· ");
INSERT INTO grctr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ᾧ οὐκ ἠθέλησαν ὑπήκοοι γενέσθαι οἱ πατέρες ἡμῶν, ἀλλ᾿ ἀπώσαντο, καὶ ἐστράφησαν ταῖς καρδίαις αὐτῶν εἰς Αἴγυπτον, ");
INSERT INTO grctr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","εἰπόντες τῷ Ἀαρών, Ποίησον ἡμῖν θεοὺς οἳ προπορεύσονται ἡμῶν· ὁ γὰρ Μωσῆς οὗτος, ὃς ἐξήγαγεν ἡμᾶς ἐκ γῆς Αἰγύπτου, οὐκ οἴδαμεν τί γέγονεν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Καὶ ἐμοσχοποίησαν ἐν ταῖς ἡμέραις ἐκείναις, καὶ ἀνήγαγον θυσίαν τῷ εἰδώλῳ, καὶ εὐφραίνοντο ἐν τοῖς ἔργοις τῶν χειρῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ἔστρεψε δὲ ὁ Θεός, καὶ παρέδωκεν αὐτοὺς λατρεύειν τῇ στρατιᾷ τοῦ οὐρανοῦ· καθὼς γέγραπται ἐν βίβλῳ τῶν προφητῶν, Μὴ σφάγια καὶ θυσίας προσηνέγκατέ μοι ἔτη τεσσαράκοντα ἐν τῇ ἐρήμῳ, οἶκος Ἰσραήλ; ");
INSERT INTO grctr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Καὶ ἀνελάβετε τὴν σκηνὴν τοῦ Μολόχ, καὶ τὸ ἄστρον τοῦ θεοῦ ὑμῶν Ῥεμφάν, τοὺς τύπους οὓς ἐποιήσατε προσκυνεῖν αὐτοῖς· καὶ μετοικιῶ ὑμᾶς ἐπέκεινα Βαβυλῶνος. ");
INSERT INTO grctr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ἡ σκηνὴ τοῦ μαρτυρίου ἦν ἐν τοῖς πατράσιν ἡμῶν ἐν τῇ ἐρήμῳ, καθὼς διετάξατο ὁ λαλῶν τῷ Μωσῇ, ποιῆσαι αὐτὴν κατὰ τὸν τύπον ὃν ἑωράκει. ");
INSERT INTO grctr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ἣν καὶ εἰσήγαγον διαδεξάμενοι οἱ πατέρες ἡμῶν μετὰ Ἰησοῦ ἐν τῇ κατασχέσει τῶν ἐθνῶν, ὧν ἐξῶσεν ὁ Θεὸς ἀπὸ προσώπου τῶν πατέρων ἡμῶν, ἕως τῶν ἡμερῶν Δαβίδ· ");
INSERT INTO grctr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ὃς εὗρε χάριν ἐνώπιον τοῦ Θεοῦ, καὶ ᾐτήσατο εὑρεῖν σκήνωμα τῷ Θεῷ Ἰακώβ. ");
INSERT INTO grctr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Σολομῶν δὲ ᾠκοδόμησεν αὐτῷ οἶκον. ");
INSERT INTO grctr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ἀλλ᾿ οὐχ ὁ ὕψιστος ἐν χειροποιήτοις ναοῖς κατοικεῖ, καθὼς ὁ προφήτης λέγει, ");
INSERT INTO grctr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ὁ οὐρανός μοι θρόνος, ἡ δὲ γῆ ὑποπόδιον τῶν ποδῶν μου· ποῖον οἶκον οἰκοδομήσετέ μοι; λέγει Κύριος· ἢ τίς τόπος τῆς καταπαύσεώς μου; ");
INSERT INTO grctr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Οὐχὶ ἡ χείρ μου ἐποίησε ταῦτα πάντα; ");
INSERT INTO grctr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Σκληροτράχηλοι καὶ ἀπερίτμητοι τῇ καρδίᾳ καὶ τοῖς ὠσίν, ὑμεῖς ἀεὶ τῷ πνεύματι τῷ ἁγίῳ ἀντιπίπτετε· ὡς οἱ πατέρες ὑμῶν, καὶ ὑμεῖς. ");
INSERT INTO grctr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Τίνα τῶν προφητῶν οὐκ ἐδίωξαν οἱ πατέρες ὑμῶν; Καὶ ἀπέκτειναν τοὺς προκαταγγείλαντας περὶ τῆς ἐλεύσεως τοῦ δικαίου, οὗ νῦν ὑμεῖς προδόται καὶ φονεῖς γεγένησθε· ");
INSERT INTO grctr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","οἵτινες ἐλάβετε τὸν νόμον εἰς διαταγὰς ἀγγέλων, καὶ οὐκ ἐφυλάξατε. ");
INSERT INTO grctr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ἀκούοντες δὲ ταῦτα, διεπρίοντο ταῖς καρδίαις αὐτῶν, καὶ ἔβρυχον τοὺς ὀδόντας ἐπ᾿ αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ὑπάρχων δὲ πλήρης πνεύματος ἁγίου, ἀτενίσας εἰς τὸν οὐρανόν, εἶδε δόξαν Θεοῦ, καὶ Ἰησοῦν ἑστῶτα ἐκ δεξιῶν τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","καὶ εἶπεν, Ἰδού, θεωρῶ τοὺς οὐρανοὺς ἀνεῳγμένους, καὶ τὸν υἱὸν τοῦ ἀνθρώπου ἐκ δεξιῶν ἑστῶτα τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Κράξαντες δὲ φωνῇ μεγάλῃ, συνέσχον τὰ ὦτα αὐτῶν, καὶ ὥρμησαν ὁμοθυμαδὸν ἐπ᾿ αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","καὶ ἐκβαλόντες ἔξω τῆς πόλεως, ἐλιθοβόλουν· καὶ οἱ μάρτυρες ἀπέθεντο τὰ ἱμάτια αὐτῶν παρὰ τοὺς πόδας νεανίου καλουμένου Σαύλου. ");
INSERT INTO grctr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Καὶ ἐλιθοβόλουν τὸν Στέφανον, ἐπικαλούμενον καὶ λέγοντα, Κύριε Ἰησοῦ, δέξαι τὸ πνεῦμά μου. ");
INSERT INTO grctr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Θεὶς δὲ τὰ γόνατα, ἔκραξε φωνῇ μεγάλῃ, Κύριε, μὴ στήσῃς αὐτοῖς τὴν ἁμαρτίαν ταύτην. Καὶ τοῦτο εἰπὼν ἐκοιμήθη. ");
INSERT INTO grctr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Σαῦλος δὲ ἦν συνευδοκῶν τῇ ἀναιρέσει αὐτοῦ. Ἐγένετο δὲ ἐν ἐκείνῃ τῇ ἡμέρᾳ διωγμὸς μέγας ἐπὶ τὴν ἐκκλησίαν τὴν ἐν Ἱεροσολύμοις· πάντες τε διεσπάρησαν κατὰ τὰς χώρας τῆς Ἰουδαίας καὶ Σαμαρείας, πλὴν τῶν ἀποστόλων. ");
INSERT INTO grctr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Συνεκόμισαν δὲ τὸν Στέφανον ἄνδρες εὐλαβεῖς, καὶ ἐποιήσαντο κοπετὸν μέγαν ἐπ᾿ αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Σαῦλος δὲ ἐλυμαίνετο τὴν ἐκκλησίαν, κατὰ τοὺς οἴκους εἰσπορευόμενος, σύρων τε ἄνδρας καὶ γυναῖκας παρεδίδου εἰς φυλακήν. ");
INSERT INTO grctr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Οἱ μὲν οὖν διασπαρέντες διῆλθον, εὐαγγελιζόμενοι τὸν λόγον. ");
INSERT INTO grctr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Φίλιππος δὲ κατελθὼν εἰς πόλιν τῆς Σαμαρείας, ἐκήρυσσεν αὐτοῖς τὸν Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Προσεῖχόν τε οἱ ὄχλοι τοῖς λεγομένοις ὑπὸ τοῦ Φιλίππου ὁμοθυμαδόν, ἐν τῷ ἀκούειν αὐτοὺς καὶ βλέπειν τὰ σημεῖα ἃ ἐποίει. ");
INSERT INTO grctr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Πολλῶν γὰρ τῶν ἐχόντων πνεύματα ἀκάθαρτα, βοῶντα μεγάλῃ φωνῇ ἐξήρχετο· πολλοὶ δὲ παραλελυμένοι καὶ χωλοὶ ἐθεραπεύθησαν. ");
INSERT INTO grctr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Καὶ ἐγένετο χαρὰ μεγάλη ἐν τῇ πόλει ἐκείνῃ. ");
INSERT INTO grctr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ἀνὴρ δέ τις ὀνόματι Σίμων προϋπῆρχεν ἐν τῇ πόλει μαγεύων καὶ ἐξιστῶν τὸ ἔθνος τῆς Σαμαρείας, λέγων εἶναί τινα ἑαυτὸν μέγαν· ");
INSERT INTO grctr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ᾧ προσεῖχον πάντες ἀπὸ μικροῦ ἕως μεγάλου, λέγοντες, Οὗτός ἐστιν ἡ δύναμις τοῦ Θεοῦ ἡ μεγάλη. ");
INSERT INTO grctr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Προσεῖχον δὲ αὐτῷ, διὰ τὸ ἱκανῷ χρόνῳ ταῖς μαγείαις ἐξεστακέναι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ὅτε δὲ ἐπίστευσαν τῷ Φιλίππῳ εὐαγγελιζομένῳ τὰ περὶ τῆς βασιλείας τοῦ Θεοῦ καὶ τοῦ ὀνόματος τοῦ Ἰησοῦ Χριστοῦ, ἐβαπτίζοντο ἄνδρες τε καὶ γυναῖκες. ");
INSERT INTO grctr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ὁ δὲ Σίμων καὶ αὐτὸς ἐπίστευσε, καὶ βαπτισθεὶς ἦν προσκαρτερῶν τῷ Φιλίππῳ· θεωρῶν τε σημεῖα καὶ δυνάμεις μεγάλας γινομένας, ἐξίστατο. ");
INSERT INTO grctr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ἀκούσαντες δὲ οἱ ἐν Ἱεροσολύμοις ἀπόστολοι ὅτι δέδεκται ἡ Σαμάρεια τὸν λόγον τοῦ Θεοῦ, ἀπέστειλαν πρὸς αὐτοὺς τὸν Πέτρον καὶ Ἰωάννην· ");
INSERT INTO grctr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","οἵτινες καταβάντες προσηύξαντο περὶ αὐτῶν, ὅπως λάβωσι πνεῦμα ἅγιον· ");
INSERT INTO grctr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","οὔπω γὰρ ἦν ἐπ᾿ οὐδενὶ αὐτῶν ἐπιπεπτωκός, μόνον δὲ βεβαπτισμένοι ὑπῆρχον εἰς τὸ ὄνομα τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Τότε ἐπετίθουν τὰς χεῖρας ἐπ᾿ αὐτούς, καὶ ἐλάμβανον πνεῦμα ἅγιον. ");
INSERT INTO grctr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Θεασάμενος δὲ ὁ Σίμων ὅτι διὰ τῆς ἐπιθέσεως τῶν χειρῶν τῶν ἀποστόλων δίδοται τὸ πνεῦμα τὸ ἅγιον, προσήνεγκεν αὐτοῖς χρήματα, ");
INSERT INTO grctr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","λέγων, Δότε κἀμοὶ τὴν ἐξουσίαν ταύτην, ἵνα ᾧ ἐὰν ἐπιθῶ τὰς χεῖρας, λαμβάνῃ πνεῦμα ἅγιον. ");
INSERT INTO grctr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Πέτρος δὲ εἶπε πρὸς αὐτόν, Τὸ ἀργύριόν σου σὺν σοὶ εἴη εἰς ἀπώλειαν, ὅτι τὴν δωρεὰν τοῦ Θεοῦ ἐνόμισας διὰ χρημάτων κτᾶσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Οὐκ ἔστι σοι μερὶς οὐδὲ κλῆρος ἐν τῷ λόγῳ τούτῳ. Ἡ γὰρ καρδία σου οὐκ ἔστιν εὐθεῖα ἐνώπιον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Μετανόησον οὖν ἀπὸ τῆς κακίας σου ταύτης, καὶ δεήθητι τοῦ Θεοῦ, εἰ ἄρα ἀφεθήσεταί σοι ἡ ἐπίνοια τῆς καρδίας σου. ");
INSERT INTO grctr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Εἰς γὰρ χολὴν πικρίας καὶ σύνδεσμον ἀδικίας ὁρῶ σε ὄντα. ");
INSERT INTO grctr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ἀποκριθεὶς δὲ ὁ Σίμων εἶπε, Δεήθητε ὑμεῖς ὑπὲρ ἐμοῦ πρὸς τὸν Κύριον, ὅπως μηδὲν ἐπέλθῃ ἐπ᾿ ἐμὲ ὧν εἰρήκατε. ");
INSERT INTO grctr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Οἱ μὲν οὖν διαμαρτυράμενοι καὶ λαλήσαντες τὸν λόγον τοῦ Κυρίου, ὑπέστρεψαν εἰς Ἱερουσαλήμ, πολλάς τε κώμας τῶν Σαμαρειτῶν εὐηγγελίσαντο. ");
INSERT INTO grctr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ἄγγελος δὲ Κυρίου ἐλάλησε πρὸς Φίλιππον, λέγων, Ἀνάστηθι καὶ πορεύου κατὰ μεσημβρίαν ἐπὶ τὴν ὁδὸν τὴν καταβαίνουσαν ἀπὸ Ἱερουσαλὴμ εἰς Γάζαν· αὕτη ἐστὶν ἔρημος. ");
INSERT INTO grctr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Καὶ ἀναστὰς ἐπορεύθη· καὶ ἰδού, ἀνὴρ Αἰθίοψ εὐνοῦχος δυνάστης Κανδάκης τῆς βασιλίσσης Αἰθιόπων, ὃς ἦν ἐπὶ πάσης τῆς γάζης αὐτῆς, ὃς ἐληλύθει προσκυνήσων εἰς Ἱερουσαλήμ, ");
INSERT INTO grctr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ἦν τε ὑποστρέφων καὶ καθήμενος ἐπὶ τοῦ ἅρματος αὐτοῦ, καὶ ἀνεγίνωσκε τὸν προφήτην Ἠσαΐαν. ");
INSERT INTO grctr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Εἶπε δὲ τὸ πνεῦμα τῷ Φιλίππῳ, Πρόσελθε καὶ κολλήθητι τῷ ἅρματι τούτῳ. ");
INSERT INTO grctr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Προσδραμὼν δὲ ὁ Φίλιππος ἤκουσεν αὐτοῦ ἀναγινώσκοντος τὸν προφήτην Ἠσαΐαν, καὶ εἶπεν, Ἆρά γε γινώσκεις ἃ ἀναγινώσκεις; ");
INSERT INTO grctr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ὁ δὲ εἶπε, Πῶς γὰρ ἂν δυναίμην, ἐὰν μή τις ὁδηγήσῃ με; Παρεκάλεσέ τε τὸν Φίλιππον ἀναβάντα καθίσαι σὺν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ἡ δὲ περιοχὴ τῆς γραφῆς ἣν ἀνεγίνωσκεν ἦν αὕτη, Ὡς πρόβατον ἐπὶ σφαγὴν ἤχθη, καὶ ὡς ἀμνὸς ἐναντίον τοῦ κείροντος αὐτὸν ἄφωνος, οὕτως οὐκ ἀνοίγει τὸ στόμα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ἐν τῇ ταπεινώσει αὐτοῦ ἡ κρίσις αὐτοῦ ἤρθη, τὴν δὲ γενεὰν αὐτοῦ τίς διηγήσεται; Ὅτι αἴρεται ἀπὸ τῆς γῆς ἡ ζωὴ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ἀποκριθεὶς δὲ ὁ εὐνοῦχος τῷ Φιλίππῳ εἶπε, Δέομαί σου, περὶ τίνος ὁ προφήτης λέγει τοῦτο; Περὶ ἑαυτοῦ, ἢ περὶ ἑτέρου τινός; ");
INSERT INTO grctr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ἀνοίξας δὲ ὁ Φίλιππος τὸ στόμα αὐτοῦ, καὶ ἀρξάμενος ἀπὸ τῆς γραφῆς ταύτης, εὐηγγελίσατο αὐτῷ τὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ὡς δὲ ἐπορεύοντο κατὰ τὴν ὁδόν, ἦλθον ἐπί τι ὕδωρ· καί φησιν ὁ εὐνοῦχος, Ἰδού, ὕδωρ· τί κωλύει με βαπτισθῆναι; ");
INSERT INTO grctr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Εἶπε δὲ ὁ Φίλιππος, Εἰ πιστεύεις ἐξ ὅλης τῆς καρδίας, ἔξεστιν. Ἀποκριθεὶς δὲ εἶπε, Πιστεύω τὸν υἱὸν τοῦ Θεοῦ εἶναι τὸν Ἰησοῦν Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Καὶ ἐκέλευσε στῆναι τὸ ἅρμα· καὶ κατέβησαν ἀμφότεροι εἰς τὸ ὕδωρ, ὅ τε Φίλιππος καὶ ὁ εὐνοῦχος· καὶ ἐβάπτισεν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ὅτε δὲ ἀνέβησαν ἐκ τοῦ ὕδατος, πνεῦμα Κυρίου ἥρπασε τὸν Φίλιππον· καὶ οὐκ εἶδεν αὐτὸν οὐκέτι ὁ εὐνοῦχος, ἐπορεύετο γὰρ τὴν ὁδὸν αὐτοῦ χαίρων. ");
INSERT INTO grctr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Φίλιππος δὲ εὑρέθη εἰς Ἄζωτον· καὶ διερχόμενος εὐηγγελίζετο τὰς πόλεις πάσας, ἕως τοῦ ἐλθεῖν αὐτὸν εἰς Καισάρειαν. ");
INSERT INTO grctr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ὁ δὲ Σαῦλος ἔτι ἐμπνέων ἀπειλῆς καὶ φόνου εἰς τοὺς μαθητὰς τοῦ Κυρίου, προσελθὼν τῷ ἀρχιερεῖ, ");
INSERT INTO grctr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ᾐτήσατο παρ᾿ αὐτοῦ ἐπιστολὰς εἰς Δαμασκὸν πρὸς τὰς συναγωγάς, ὅπως ἐάν τινας εὕρῃ τῆς ὁδοῦ ὄντας ἄνδρας τε καὶ γυναῖκας, δεδεμένους ἀγάγῃ εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ἐν δὲ τῷ πορεύεσθαι, ἐγένετο αὐτὸν ἐγγίζειν τῇ Δαμασκῷ· καὶ ἐξαίφνης περιήστραψεν αὐτὸν φῶς ἀπὸ τοῦ οὐρανοῦ· ");
INSERT INTO grctr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","καὶ πεσὼν ἐπὶ τὴν γῆν, ἤκουσε φωνὴν λέγουσαν αὐτῷ, Σαούλ, Σαούλ, τί με διώκεις; ");
INSERT INTO grctr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Εἶπε δέ, Τίς εἶ, Κύριε; Ὁ δὲ Κύριος εἶπεν, Ἐγώ εἰμι Ἰησοῦς ὃν σὺ διώκεις· σκληρόν σοι πρὸς κέντρα λακτίζειν. ");
INSERT INTO grctr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Τρέμων τε καὶ θαμβῶν εἶπε, Κύριε, τί με θέλεις ποιῆσαι; Καὶ ὁ Κύριος πρὸς αὐτόν, Ἀνάστηθι καὶ εἴσελθε εἰς τὴν πόλιν, καὶ λαληθήσεταί σοι τί σε δεῖ ποιεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Οἱ δὲ ἄνδρες οἱ συνοδεύοντες αὐτῷ εἱστήκεισαν ἐννεοί, ἀκούοντες μὲν τῆς φωνῆς, μηδένα δὲ θεωροῦντες. ");
INSERT INTO grctr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ἠγέρθη δὲ ὁ Σαῦλος ἀπὸ τῆς γῆς· ἀνεῳγμένων δὲ τῶν ὀφθαλμῶν αὐτοῦ, οὐδένα ἔβλεπε, χειραγωγοῦντες δὲ αὐτὸν εἰσήγαγον εἰς Δαμασκόν. ");
INSERT INTO grctr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Καὶ ἦν ἡμέρας τρεῖς μὴ βλέπων, καὶ οὐκ ἔφαγεν οὐδὲ ἔπιεν. ");
INSERT INTO grctr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ἦν δέ τις μαθητὴς ἐν Δαμασκῷ ὀνόματι Ἀνανίας, καὶ εἶπε πρὸς αὐτὸν ὁ Κύριος ἐν ὁράματι, Ἀνανία. Ὁ δὲ εἶπεν, Ἰδοὺ ἐγώ, Κύριε. ");
INSERT INTO grctr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ὁ δὲ Κύριος πρὸς αὐτόν, Ἀναστὰς πορεύθητι ἐπὶ τὴν ῥύμην τὴν καλουμένην Εὐθεῖαν, καὶ ζήτησον ἐν οἰκίᾳ Ἰούδα Σαῦλον ὀνόματι, Ταρσέα· ἰδοὺ γὰρ προσεύχεται, ");
INSERT INTO grctr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","καὶ εἶδεν ἐν ὁράματι ἄνδρα ὀνόματι Ἀνανίαν εἰσελθόντα καὶ ἐπιθέντα αὐτῷ χεῖρα, ὅπως ἀναβλέψῃ. ");
INSERT INTO grctr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ἀπεκρίθη δὲ ὁ Ἀνανίας, Κύριε, ἀκήκοα ἀπὸ πολλῶν περὶ τοῦ ἀνδρὸς τούτου, ὅσα κακὰ ἐποίησε τοῖς ἁγίοις σου ἐν Ἱερουσαλήμ· ");
INSERT INTO grctr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","καὶ ὧδε ἔχει ἐξουσίαν παρὰ τῶν ἀρχιερέων, δῆσαι πάντας τοὺς ἐπικαλουμένους τὸ ὄνομά σου. ");
INSERT INTO grctr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Εἶπε δὲ πρὸς αὐτὸν ὁ Κύριος, Πορεύου, ὅτι σκεῦος ἐκλογῆς μοι ἐστὶν οὗτος, τοῦ βαστάσαι τὸ ὄνομά μου ἐνώπιον ἐθνῶν καὶ βασιλέων, υἱῶν τε Ἰσραήλ· ");
INSERT INTO grctr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ἐγὼ γὰρ ὑποδείξω αὐτῷ ὅσα δεῖ αὐτὸν ὑπὲρ τοῦ ὀνόματός μου παθεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ἀπῆλθε δὲ Ἀνανίας καὶ εἰσῆλθεν εἰς τὴν οἰκίαν, καὶ ἐπιθεὶς ἐπ᾿ αὐτὸν τὰς χεῖρας εἶπε, Σαοὺλ ἀδελφέ, ὁ Κύριος ἀπέσταλκέ με, Ἰησοῦς ὁ ὀφθείς σοι ἐν τῇ ὁδῷ ᾗ ἤρχου, ὅπως ἀναβλέψῃς καὶ πλησθῇς πνεύματος ἁγίου. ");
INSERT INTO grctr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Καὶ εὐθέως ἀπέπεσον ἀπὸ τῶν ὀφθαλμῶν αὐτοῦ ὡσεὶ λεπίδες, ἀνέβλεψέ τε παραχρῆμα, καὶ ἀναστὰς ἐβαπτίσθη, ");
INSERT INTO grctr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","καὶ λαβὼν τροφὴν ἐνίσχυσεν. Ἐγένετο δὲ ὁ Σαῦλος μετὰ τῶν ἐν Δαμασκῷ μαθητῶν ἡμέρας τινάς. ");
INSERT INTO grctr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Καὶ εὐθέως ἐν ταῖς συναγωγαῖς ἐκήρυσσε τὸν Χριστόν, ὅτι οὗτός ἐστιν ὁ υἱὸς τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ἐξίσταντο δὲ πάντες οἱ ἀκούοντες καὶ ἔλεγον, Οὐχ οὗτός ἐστιν ὁ πορθήσας ἐν Ἱερουσαλὴμ τοὺς ἐπικαλουμένους τὸ ὄνομα τοῦτο, καὶ ὧδε εἰς τοῦτο ἐληλύθει ἵνα δεδεμένους αὐτοὺς ἀγάγῃ ἐπὶ τοὺς ἀρχιερεῖς; ");
INSERT INTO grctr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Σαῦλος δὲ μᾶλλον ἐνεδυναμοῦτο, καὶ συνέχυνε τοὺς Ἰουδαίους τοὺς κατοικοῦντας ἐν Δαμασκῷ, συμβιβάζων ὅτι οὗτός ἐστιν ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ὡς δὲ ἐπληροῦντο ἡμέραι ἱκαναί, συνεβουλεύσαντο οἱ Ἰουδαῖοι ἀνελεῖν αὐτόν· ");
INSERT INTO grctr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ἐγνώσθη δὲ τῷ Σαύλῳ ἡ ἐπιβουλὴ αὐτῶν. Παρετήρουν τε τὰς πύλας ἡμέρας τε καὶ νυκτός, ὅπως αὐτὸν ἀνέλωσι· ");
INSERT INTO grctr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","λαβόντες δὲ αὐτὸν οἱ μαθηταὶ νυκτός, καθῆκαν διὰ τοῦ τείχους, χαλάσαντες ἐν σπυρίδι. ");
INSERT INTO grctr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Παραγενόμενος δὲ ὁ Σαῦλος εἰς Ἱερουσαλήμ, ἐπειρᾶτο κολλᾶσθαι τοῖς μαθηταῖς· καὶ πάντες ἐφοβοῦντο αὐτόν, μὴ πιστεύοντες ὅτι ἐστὶ μαθητής. ");
INSERT INTO grctr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Βαρνάβας δὲ ἐπιλαβόμενος αὐτὸν ἤγαγε πρὸς τοὺς ἀποστόλους, καὶ διηγήσατο αὐτοῖς πῶς ἐν τῇ ὁδῷ εἶδε τὸν Κύριον, καὶ ὅτι ἐλάλησεν αὐτῷ, καὶ πῶς ἐν Δαμασκῷ ἐπαρρησιάσατο ἐν τῷ ὀνόματι τοῦ Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Καὶ ἦν μετ᾿ αὐτῶν εἰσπορευόμενος καὶ ἐκπορευόμενος ἐν Ἱερουσαλήμ, καὶ παρρησιαζόμενος ἐν τῷ ὀνόματι τοῦ Κυρίου Ἰησοῦ, ");
INSERT INTO grctr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ἐλάλει τε καὶ συνεζήτει πρὸς τοὺς Ἑλληνιστάς· οἱ δὲ ἐπεχείρουν αὐτὸν ἀνελεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ἐπιγνόντες δὲ οἱ ἀδελφοὶ κατήγαγον αὐτὸν εἰς Καισάρειαν, καὶ ἐξαπέστειλαν αὐτὸν εἰς Ταρσόν. ");
INSERT INTO grctr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Αἱ μὲν οὖν ἐκκλησίαι καθ᾿ ὅλης τῆς Ἰουδαίας καὶ Γαλιλαίας καὶ Σαμαρείας εἶχον εἰρήνην οἰκοδομούμεναι, καὶ πορευόμεναι τῷ φόβῳ τοῦ Κυρίου καὶ τῇ παρακλήσει τοῦ ἁγίου πνεύματος ἐπληθύνοντο. ");
INSERT INTO grctr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ἐγένετο δὲ Πέτρον διερχόμενον διὰ πάντων κατελθεῖν καὶ πρὸς τοὺς ἁγίους τοὺς κατοικοῦντας Λύδδαν. ");
INSERT INTO grctr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Εὗρε δὲ ἐκεῖ ἄνθρωπόν τινα Αἰνέαν ὀνόματι, ἐξ ἐτῶν ὀκτὼ κατακείμενον ἐπὶ κραββάτῳ, ὃς ἦν παραλελυμένος. ");
INSERT INTO grctr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Καὶ εἶπεν αὐτῷ ὁ Πέτρος, Αἰνέα, ἰᾶταί σε Ἰησοῦς ὁ Χριστός· ἀνάστηθι καὶ στρῶσον σεαυτῷ. Καὶ εὐθέως ἀνέστη. ");
INSERT INTO grctr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Καὶ εἶδον αὐτὸν πάντες οἱ κατοικοῦντες Λύδδαν καὶ τὸν Σάρωνα, οἵτινες ἐπέστρεψαν ἐπὶ τὸν Κύριον. ");
INSERT INTO grctr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ἐν Ἰόππῃ δέ τις ἦν μαθήτρια ὀνόματι Ταβιθά, ἣ διερμηνευομένη λέγεται Δορκάς· αὕτη ἦν πλήρης ἀγαθῶν ἔργων καὶ ἐλεημοσυνῶν ὧν ἐποίει. ");
INSERT INTO grctr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ἐκείναις ἀσθενήσασαν αὐτὴν ἀποθανεῖν· λούσαντες δὲ αὐτὴν ἔθηκαν ἐν ὑπερῴῳ. ");
INSERT INTO grctr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ἐγγὺς δὲ οὔσης Λύδδης τῇ Ἰόππῃ, οἱ μαθηταὶ ἀκούσαντες ὅτι Πέτρος ἐστὶν ἐν αὐτῇ, ἀπέστειλαν δύο ἄνδρας πρὸς αὐτόν, παρακαλοῦντες μὴ ὀκνῆσαι διελθεῖν ἕως αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ἀναστὰς δὲ Πέτρος συνῆλθεν αὐτοῖς· ὃν παραγενόμενον ἀνήγαγον εἰς τὸ ὑπερῷον, καὶ παρέστησαν αὐτῷ πᾶσαι αἱ χῆραι κλαίουσαι καὶ ἐπιδεικνύμεναι χιτῶνας καὶ ἱμάτια ὅσα ἐποίει μετ᾿ αὐτῶν οὖσα ἡ Δορκάς. ");
INSERT INTO grctr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ἐκβαλὼν δὲ ἔξω πάντας ὁ Πέτρος θεὶς τὰ γόνατα προσηύξατο· καὶ ἐπιστρέψας πρὸς τὸ σῶμα, εἶπε, Ταβιθά, ἀνάστηθι. Ἡ δὲ ἤνοιξε τοὺς ὀφθαλμοὺς αὐτῆς· καὶ ἰδοῦσα τὸν Πέτρον, ἀνεκάθισε. ");
INSERT INTO grctr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Δοὺς δὲ αὐτῇ χεῖρα, ἀνέστησεν αὐτήν· φωνήσας δὲ τοὺς ἁγίους καὶ τὰς χήρας, παρέστησεν αὐτὴν ζῶσαν. ");
INSERT INTO grctr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Γνωστὸν δὲ ἐγένετο καθ᾿ ὅλης τῆς Ἰόππης, καὶ πολλοὶ ἐπίστευσαν ἐπὶ τὸν Κύριον. ");
INSERT INTO grctr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ἐγένετο δὲ ἡμέρας ἱκανὰς μεῖναι αὐτὸν ἐν Ἰόππῃ παρά τινι Σίμωνι βυρσεῖ. ");
INSERT INTO grctr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ἀνὴρ δέ τις ἦν ἐν Καισαρείᾳ ὀνόματι Κορνήλιος, ἑκατοντάρχης ἐκ σπείρης τῆς καλουμένης Ἰταλικῆς, ");
INSERT INTO grctr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","εὐσεβὴς καὶ φοβούμενος τὸν Θεὸν σὺν παντὶ τῷ οἴκῳ αὐτοῦ, ποιῶν τε ἐλεημοσύνας πολλὰς τῷ λαῷ, καὶ δεόμενος τοῦ Θεοῦ διὰ παντός. ");
INSERT INTO grctr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Εἶδεν ἐν ὁράματι φανερῶς, ὡσεὶ ὥραν ἐννάτην τῆς ἡμέρας, ἄγγελον τοῦ Θεοῦ εἰσελθόντα πρὸς αὐτόν, καὶ εἰπόντα αὐτῷ, Κορνήλιε. ");
INSERT INTO grctr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ὁ δὲ ἀτενίσας αὐτῷ καὶ ἔμφοβος γενόμενος εἶπε, Τί ἐστι, Κύριε; Εἶπε δὲ αὐτῷ, Αἱ προσευχαί σου καὶ αἱ ἐλεημοσύναι σου ἀνέβησαν εἰς μνημόσυνον ἐνώπιον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Καὶ νῦν πέμψον εἰς Ἰόππην ἄνδρας, καὶ μετάπεμψαι Σίμωνα ὃς ἐπικαλεῖται Πέτρος· ");
INSERT INTO grctr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","οὗτος ξενίζεται παρά τινι Σίμωνι βυρσεῖ, ᾧ ἐστιν οἰκία παρὰ θάλασσαν· οὗτος λαλήσει σοι τί σε δεῖ ποιεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ὡς δὲ ἀπῆλθεν ὁ ἄγγελος ὁ λαλῶν τῷ Κορνηλίῳ, φωνήσας δύο τῶν οἰκετῶν αὐτοῦ, καὶ στρατιώτην εὐσεβῆ τῶν προσκαρτερούντων αὐτῷ, ");
INSERT INTO grctr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","καὶ ἐξηγησάμενος αὐτοῖς ἅπαντα, ἀπέστειλεν αὐτοὺς εἰς τὴν Ἰόππην. ");
INSERT INTO grctr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Τῇ δὲ ἐπαύριον, ὁδοιπορούντων ἐκείνων καὶ τῇ πόλει ἐγγιζόντων, ἀνέβη Πέτρος ἐπὶ τὸ δῶμα προσεύξασθαι, περὶ ὥραν ἕκτην· ");
INSERT INTO grctr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ἐγένετο δὲ πρόσπεινος, καὶ ἤθελε γεύσασθαι· παρασκευαζόντων δὲ ἐκείνων, ἐπέπεσεν ἐπ᾿ αὐτὸν ἔκστασις, ");
INSERT INTO grctr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","καὶ θεωρεῖ τὸν οὐρανὸν ἀνεῳγμένον, καὶ καταβαῖνον ἐπ᾿ αὐτὸν σκεῦός τι ὡς ὀθόνην μεγάλην, τέσσαρσιν ἀρχαῖς δεδεμένον, καὶ καθιέμενον ἐπὶ τῆς γῆς· ");
INSERT INTO grctr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ἐν ᾧ ὑπῆρχε πάντα τὰ τετράποδα τῆς γῆς καὶ τὰ θηρία καὶ τὰ ἑρπετὰ καὶ τὰ πετεινὰ τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Καὶ ἐγένετο φωνὴ πρὸς αὐτόν, Ἀναστάς, Πέτρε, θῦσον καὶ φάγε. ");
INSERT INTO grctr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ὁ δὲ Πέτρος εἶπε, Μηδαμῶς, Κύριε· ὅτι οὐδέποτε ἔφαγον πᾶν κοινὸν ἢ ἀκάθαρτον. ");
INSERT INTO grctr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Καὶ φωνὴ πάλιν ἐκ δευτέρου πρὸς αὐτόν, Ἃ ὁ Θεὸς ἐκαθάρισε, σὺ μὴ κοίνου. ");
INSERT INTO grctr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Τοῦτο δὲ ἐγένετο ἐπὶ τρίς· καὶ πάλιν ἀνελήφθη τὸ σκεῦος εἰς τὸν οὐρανόν. ");
INSERT INTO grctr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ὡς δὲ ἐν ἑαυτῷ διηπόρει ὁ Πέτρος τί ἂν εἴη τὸ ὅραμα ὃ εἶδε, καὶ ἰδού, οἱ ἄνδρες οἱ ἀπεσταλμένοι ἀπὸ τοῦ Κορνηλίου, διερωτήσαντες τὴν οἰκίαν Σίμωνος, ἐπέστησαν ἐπὶ τὸν πυλῶνα, ");
INSERT INTO grctr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","καὶ φωνήσαντες ἐπυνθάνοντο εἰ Σίμων, ὁ ἐπικαλούμενος Πέτρος, ἐνθάδε ξενίζεται. ");
INSERT INTO grctr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Τοῦ δὲ Πέτρου ἐνθυμουμένου περὶ τοῦ ὁράματος, εἶπεν αὐτῷ τὸ πνεῦμα, Ἰδού, ἄνδρες τρεῖς ζητοῦσί σε. ");
INSERT INTO grctr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ἀλλὰ ἀναστὰς κατάβηθι, καὶ πορεύου σὺν αὐτοῖς, μηδὲν διακρινόμενος· διότι ἐγὼ ἀπέσταλκα αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Καταβὰς δὲ Πέτρος πρὸς τοὺς ἄνδρας τοὺς ἀπεσταλμένους ἀπὸ τοῦ Κορνηλίου πρὸς αὐτόν, εἶπεν, Ἰδού, ἐγώ εἰμι ὃν ζητεῖτε· τίς ἡ αἰτία δι᾿ ἣν πάρεστε; ");
INSERT INTO grctr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Οἱ δὲ εἶπον, Κορνήλιος ἑκατοντάρχης, ἀνὴρ δίκαιος καὶ φοβούμενος τὸν Θεόν, μαρτυρούμενός τε ὑπὸ ὅλου τοῦ ἔθνους τῶν Ἰουδαίων, ἐχρηματίσθη ὑπὸ ἀγγέλου ἁγίου μεταπέμψασθαί σε εἰς τὸν οἶκον αὐτοῦ, καὶ ἀκοῦσαι ῥήματα παρὰ σοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Εἰσκαλεσάμενος οὖν αὐτοὺς ἐξένισε. Τῇ δὲ ἐπαύριον ὁ Πέτρος ἐξῆλθε σὺν αὐτοῖς, καί τινες τῶν ἀδελφῶν τῶν ἀπὸ τῆς Ἰόππης συνῆλθον αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Καὶ τῇ ἐπαύριον εἰσῆλθον εἰς τὴν Καισάρειαν. Ὁ δὲ Κορνήλιος ἦν προσδοκῶν αὐτούς, συγκαλεσάμενος τοὺς συγγενεῖς αὐτοῦ καὶ τοὺς ἀναγκαίους φίλους. ");
INSERT INTO grctr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ὡς δὲ ἐγένετο εἰσελθεῖν τὸν Πέτρον, συναντήσας αὐτῷ ὁ Κορνήλιος, πεσὼν ἐπὶ τοὺς πόδας, προσεκύνησεν. ");
INSERT INTO grctr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ὁ δὲ Πέτρος αὐτὸν ἤγειρε λέγων, Ἀνάστηθι· κἀγὼ αὐτὸς ἄνθρωπός εἰμι. ");
INSERT INTO grctr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Καὶ συνομιλῶν αὐτῷ εἰσῆλθε, καὶ εὑρίσκει συνεληλυθότας πολλούς, ");
INSERT INTO grctr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ἔφη τε πρὸς αὐτούς, Ὑμεῖς ἐπίστασθε ὡς ἀθέμιτόν ἐστιν ἀνδρὶ Ἰουδαίῳ κολλᾶσθαι ἢ προσέρχεσθαι ἀλλοφύλῳ· καὶ ἐμοὶ ὁ Θεὸς ἔδειξε μηδένα κοινὸν ἢ ἀκάθαρτον λέγειν ἄνθρωπον· ");
INSERT INTO grctr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","διὸ καὶ ἀναντιρρήτως ἦλθον μεταπεμφθείς. Πυνθάνομαι οὖν, τίνι λόγῳ μετεπέμψασθέ με. ");
INSERT INTO grctr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Καὶ ὁ Κορνήλιος ἔφη, Ἀπὸ τετάρτης ἡμέρας μέχρι ταύτης τῆς ὥρας ἤμην νηστεύων, καὶ τὴν ἐννάτην ὥραν προσευχόμενος ἐν τῷ οἴκῳ μου· καὶ ἰδού, ἀνὴρ ἔστη ἐνώπιόν μου ἐν ἐσθῆτι λαμπρᾷ, ");
INSERT INTO grctr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","καί φησι, Κορνήλιε, εἰσηκούσθη σου ἡ προσευχή, καὶ αἱ ἐλεημοσύναι σου ἐμνήσθησαν ἐνώπιον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Πέμψον οὖν εἰς Ἰόππην, καὶ μετακάλεσαι Σίμωνα ὃς ἐπικαλεῖται Πέτρος· οὗτος ξενίζεται ἐν οἰκίᾳ Σίμωνος βυρσέως παρὰ θάλασσαν· ὃς παραγενόμενος λαλήσει σοι. ");
INSERT INTO grctr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ἐξαυτῆς οὖν ἔπεμψα πρός σε· σύ τε καλῶς ἐποίησας παραγενόμενος. Νῦν οὖν πάντες ἡμεῖς ἐνώπιον τοῦ Θεοῦ πάρεσμεν ἀκοῦσαι πάντα τὰ προστεταγμένα σοι ὑπὸ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ἀνοίξας δὲ Πέτρος τὸ στόμα εἶπεν, Ἐπ᾿ ἀληθείας καταλαμβάνομαι ὅτι οὐκ ἔστι προσωπολήπτης ὁ Θεός· ");
INSERT INTO grctr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ἀλλ᾿ ἐν παντὶ ἔθνει ὁ φοβούμενος αὐτὸν καὶ ἐργαζόμενος δικαιοσύνην, δεκτὸς αὐτῷ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Τὸν λόγον ὃν ἀπέστειλε τοῖς υἱοῖς Ἰσραήλ, εὐαγγελιζόμενος εἰρήνην διὰ Ἰησοῦ Χριστοῦ — οὗτός ἐστι πάντων Κύριος — ");
INSERT INTO grctr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ὑμεῖς οἴδατε, τὸ γενόμενον ῥῆμα καθ᾿ ὅλης τῆς Ἰουδαίας, ἀρξάμενον ἀπὸ τῆς Γαλιλαίας, μετὰ τὸ βάπτισμα ὃ ἐκήρυξεν Ἰωάννης· ");
INSERT INTO grctr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ἰησοῦν τὸν ἀπὸ Ναζαρέθ, ὡς ἔχρισεν αὐτὸν ὁ Θεὸς πνεύματι ἁγίῳ καὶ δυνάμει, ὃς διῆλθεν εὐεργετῶν καὶ ἰώμενος πάντας τοὺς καταδυναστευομένους ὑπὸ τοῦ διαβόλου, ὅτι ὁ Θεὸς ἦν μετ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Καὶ ἡμεῖς ἐσμεν μάρτυρες πάντων ὧν ἐποίησεν ἔν τε τῇ χώρᾳ τῶν Ἰουδαίων καὶ ἐν Ἱερουσαλήμ· ὃν ἀνεῖλον κρεμάσαντες ἐπὶ ξύλου. ");
INSERT INTO grctr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Τοῦτον ὁ Θεὸς ἤγειρε τῇ τρίτῃ ἡμέρᾳ, καὶ ἔδωκεν αὐτὸν ἐμφανῆ γενέσθαι, ");
INSERT INTO grctr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","οὐ παντὶ τῷ λαῷ, ἀλλὰ μάρτυσι τοῖς προκεχειροτονημένοις ὑπὸ τοῦ Θεοῦ, ἡμῖν, οἵτινες συνεφάγομεν καὶ συνεπίομεν αὐτῷ μετὰ τὸ ἀναστῆναι αὐτὸν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Καὶ παρήγγειλεν ἡμῖν κηρύξαι τῷ λαῷ, καὶ διαμαρτύρασθαι ὅτι αὐτός ἐστιν ὁ ὡρισμένος ὑπὸ τοῦ Θεοῦ κριτὴς ζώντων καὶ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Τούτῳ πάντες οἱ προφῆται μαρτυροῦσιν, ἄφεσιν ἁμαρτιῶν λαβεῖν διὰ τοῦ ὀνόματος αὐτοῦ πάντα τὸν πιστεύοντα εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ἔτι λαλοῦντος τοῦ Πέτρου τὰ ῥήματα ταῦτα, ἐπέπεσε τὸ πνεῦμα τὸ ἅγιον ἐπὶ πάντας τοὺς ἀκούοντας τὸν λόγον. ");
INSERT INTO grctr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Καὶ ἐξέστησαν οἱ ἐκ περιτομῆς πιστοί, ὅσοι συνῆλθον τῷ Πέτρῳ, ὅτι καὶ ἐπὶ τὰ ἔθνη ἡ δωρεὰ τοῦ ἁγίου πνεύματος ἐκκέχυται. ");
INSERT INTO grctr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ἤκουον γὰρ αὐτῶν λαλούντων γλώσσαις, καὶ μεγαλυνόντων τὸν Θεόν. Τότε ἀπεκρίθη ὁ Πέτρος, ");
INSERT INTO grctr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Μήτι τὸ ὕδωρ κωλῦσαι δύναταί τις, τοῦ μὴ βαπτισθῆναι τούτους, οἵτινες τὸ πνεῦμα τὸ ἅγιον ἔλαβον καθὼς καὶ ἡμεῖς; ");
INSERT INTO grctr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Προσέταξέ τε αὐτοὺς βαπτισθῆναι ἐν τῷ ὀνόματι τοῦ Κυρίου. Τότε ἠρώτησαν αὐτὸν ἐπιμεῖναι ἡμέρας τινάς. ");
INSERT INTO grctr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ἤκουσαν δὲ οἱ ἀπόστολοι καὶ οἱ ἀδελφοὶ οἱ ὄντες κατὰ τὴν Ἰουδαίαν ὅτι καὶ τὰ ἔθνη ἐδέξαντο τὸν λόγον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Καὶ ὅτε ἀνέβη Πέτρος εἰς Ἱεροσόλυμα, διεκρίνοντο πρὸς αὐτὸν οἱ ἐκ περιτομῆς, ");
INSERT INTO grctr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","λέγοντες ὅτι Πρὸς ἄνδρας ἀκροβυστίαν ἔχοντας εἰσῆλθες, καὶ συνέφαγες αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ἀρξάμενος δὲ ὁ Πέτρος ἐξετίθετο αὐτοῖς καθεξῆς λέγων, ");
INSERT INTO grctr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ἐγὼ ἤμην ἐν πόλει Ἰόππῃ προσευχόμενος, καὶ εἶδον ἐν ἐκστάσει ὅραμα, καταβαῖνον σκεῦός τι, ὡς ὀθόνην μεγάλην τέσσαρσιν ἀρχαῖς καθιεμένην ἐκ τοῦ οὐρανοῦ, καὶ ἦλθεν ἄχρις ἐμοῦ· ");
INSERT INTO grctr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","εἰς ἣν ἀτενίσας κατενόουν, καὶ εἶδον τὰ τετράποδα τῆς γῆς καὶ τὰ θηρία καὶ τὰ ἑρπετὰ καὶ τὰ πετεινὰ τοῦ οὐρανοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ἤκουσα δὲ φωνῆς λεγούσης μοι, Ἀναστάς, Πέτρε, θῦσον καὶ φάγε. ");
INSERT INTO grctr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Εἶπον δέ, Μηδαμῶς, Κύριε· ὅτι πᾶν κοινὸν ἢ ἀκάθαρτον οὐδέποτε εἰσῆλθεν εἰς τὸ στόμα μου. ");
INSERT INTO grctr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ἀπεκρίθη δέ μοι φωνὴ ἐκ δευτέρου ἐκ τοῦ οὐρανοῦ, Ἃ ὁ Θεὸς ἐκαθάρισε, σὺ μὴ κοίνου. ");
INSERT INTO grctr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Τοῦτο δὲ ἐγένετο ἐπὶ τρίς, καὶ πάλιν ἀνεσπάσθη ἅπαντα εἰς τὸν οὐρανόν. ");
INSERT INTO grctr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Καὶ ἰδού, ἐξαυτῆς τρεῖς ἄνδρες ἐπέστησαν ἐπὶ τὴν οἰκίαν ἐν ᾗ ἤμην, ἀπεσταλμένοι ἀπὸ Καισαρείας πρός με. ");
INSERT INTO grctr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Εἶπε δέ μοι τὸ πνεῦμα συνελθεῖν αὐτοῖς, μηδὲν διακρινόμενον. Ἦλθον δὲ σὺν ἐμοὶ καὶ οἱ ἓξ ἀδελφοὶ οὗτοι, καὶ εἰσήλθομεν εἰς τὸν οἶκον τοῦ ἀνδρός· ");
INSERT INTO grctr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ἀπήγγειλέ τε ἡμῖν πῶς εἶδε τὸν ἄγγελον ἐν τῷ οἴκῳ αὐτοῦ σταθέντα, καὶ εἰπόντα αὐτῷ, Ἀπόστειλον εἰς Ἰόππην ἄνδρας, καὶ μετάπεμψαι Σίμωνα, τὸν ἐπικαλούμενον Πέτρον, ");
INSERT INTO grctr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ὃς λαλήσει ῥήματα πρός σε, ἐν οἷς σωθήσῃ σὺ καὶ πᾶς ὁ οἶκός σου. ");
INSERT INTO grctr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ἐν δὲ τῷ ἄρξασθαί με λαλεῖν, ἐπέπεσε τὸ πνεῦμα τὸ ἅγιον ἐπ᾿ αὐτούς, ὥσπερ καὶ ἐφ᾿ ἡμᾶς ἐν ἀρχῇ. ");
INSERT INTO grctr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ἐμνήσθην δὲ τοῦ ῥήματος Κυρίου, ὡς ἔλεγεν, Ἰωάννης μὲν ἐβάπτισεν ὕδατι, ὑμεῖς δὲ βαπτισθήσεσθε ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grctr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Εἰ οὖν τὴν ἴσην δωρεὰν ἔδωκεν αὐτοῖς ὁ Θεὸς ὡς καὶ ἡμῖν, πιστεύσασιν ἐπὶ τὸν Κύριον Ἰησοῦν Χριστόν, ἐγὼ δὲ τίς ἤμην δυνατὸς κωλῦσαι τὸν Θεόν; ");
INSERT INTO grctr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ἀκούσαντες δὲ ταῦτα ἡσύχασαν, καὶ ἐδόξαζον τὸν Θεόν, λέγοντες, Ἄρα γε καὶ τοῖς ἔθνεσιν ὁ Θεὸς τὴν μετάνοιαν ἔδωκεν εἰς ζωήν. ");
INSERT INTO grctr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Οἱ μὲν οὖν διασπαρέντες ἀπὸ τῆς θλίψεως τῆς γενομένης ἐπὶ Στεφάνῳ διῆλθον ἕως Φοινίκης καὶ Κύπρου καὶ Ἀντιοχείας, μηδενὶ λαλοῦντες τὸν λόγον εἰ μὴ μόνον Ἰουδαίοις. ");
INSERT INTO grctr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ἦσαν δέ τινες ἐξ αὐτῶν ἄνδρες Κύπριοι καὶ Κυρηναῖοι, οἵτινες εἰσελθόντες εἰς Ἀντιόχειαν, ἐλάλουν πρὸς τοὺς Ἑλληνιστάς, εὐαγγελιζόμενοι τὸν Κύριον Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Καὶ ἦν χεὶρ Κυρίου μετ᾿ αὐτῶν· πολύς τε ἀριθμὸς πιστεύσας ἐπέστρεψεν ἐπὶ τὸν Κύριον. ");
INSERT INTO grctr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ἠκούσθη δὲ ὁ λόγος εἰς τὰ ὦτα τῆς ἐκκλησίας τῆς ἐν Ἱεροσολύμοις περὶ αὐτῶν· καὶ ἐξαπέστειλαν Βαρνάβαν διελθεῖν ἕως Ἀντιοχείας· ");
INSERT INTO grctr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ὃς παραγενόμενος καὶ ἰδὼν τὴν χάριν τοῦ Θεοῦ ἐχάρη, καὶ παρεκάλει πάντας τῇ προθέσει τῆς καρδίας προσμένειν τῷ Κυρίῳ· ");
INSERT INTO grctr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ὅτι ἦν ἀνὴρ ἀγαθὸς καὶ πλήρης πνεύματος ἁγίου καὶ πίστεως· καὶ προσετέθη ὄχλος ἱκανὸς τῷ Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ἐξῆλθε δὲ εἰς Ταρσὸν ὁ Βαρνάβας ἀναζητῆσαι Σαῦλον, ");
INSERT INTO grctr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","καὶ εὑρὼν αὐτὸν ἤγαγεν αὐτὸν εἰς Ἀντιόχειαν. Ἐγένετο δὲ αὐτοὺς ἐνιαυτὸν ὅλον συναχθῆναι ἐν τῇ ἐκκλησίᾳ καὶ διδάξαι ὄχλον ἱκανόν, χρηματίσαι τε πρῶτον ἐν Ἀντιοχείᾳ τοὺς μαθητὰς Χριστιανούς. ");
INSERT INTO grctr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ἐν ταύταις δὲ ταῖς ἡμέραις κατῆλθον ἀπὸ Ἱεροσολύμων προφῆται εἰς Ἀντιόχειαν. ");
INSERT INTO grctr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ἀναστὰς δὲ εἷς ἐξ αὐτῶν ὀνόματι Ἄγαβος, ἐσήμανε διὰ τοῦ πνεύματος λιμὸν μέγαν μέλλειν ἔσεσθαι ἐφ᾿ ὅλην τὴν οἰκουμένην· ὅστις καὶ ἐγένετο ἐπὶ Κλαυδίου Καίσαρος. ");
INSERT INTO grctr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Τῶν δὲ μαθητῶν καθὼς ηὐπορεῖτό τις, ὥρισαν ἕκαστος αὐτῶν εἰς διακονίαν πέμψαι τοῖς κατοικοῦσιν ἐν τῇ Ἰουδαίᾳ ἀδελφοῖς· ");
INSERT INTO grctr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ὃ καὶ ἐποίησαν, ἀποστείλαντες πρὸς τοὺς πρεσβυτέρους διὰ χειρὸς Βαρνάβα καὶ Σαύλου. ");
INSERT INTO grctr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Κατ᾿ ἐκεῖνον δὲ τὸν καιρὸν ἐπέβαλεν Ἡρῴδης ὁ βασιλεὺς τὰς χεῖρας κακῶσαί τινας τῶν ἀπὸ τῆς ἐκκλησίας. ");
INSERT INTO grctr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ἀνεῖλε δὲ Ἰάκωβον τὸν ἀδελφὸν Ἰωάννου μαχαίρᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Καὶ ἰδὼν ὅτι ἀρεστόν ἐστι τοῖς Ἰουδαίοις, προσέθετο συλλαβεῖν καὶ Πέτρον — ἦσαν δὲ ἡμέραι τῶν ἀζύμων — ");
INSERT INTO grctr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ὃν καὶ πιάσας ἔθετο εἰς φυλακήν, παραδοὺς τέσσαρσι τετραδίοις στρατιωτῶν φυλάσσειν αὐτόν, βουλόμενος μετὰ τὸ Πάσχα ἀναγαγεῖν αὐτὸν τῷ λαῷ. ");
INSERT INTO grctr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ὁ μὲν οὖν Πέτρος ἐτηρεῖτο ἐν τῇ φυλακῇ· προσευχὴ δὲ ἦν ἐκτενὴς γινομένη ὑπὸ τῆς ἐκκλησίας πρὸς τὸν Θεὸν ὑπὲρ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ὅτε δὲ ἔμελλεν αὐτὸν προάγειν ὁ Ἡρῴδης, τῇ νυκτὶ ἐκείνῃ ἦν ὁ Πέτρος κοιμώμενος μεταξὺ δύο στρατιωτῶν, δεδεμένος ἁλύσεσι δυσί· φύλακές τε πρὸ τῆς θύρας ἐτήρουν τὴν φυλακήν. ");
INSERT INTO grctr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Καὶ ἰδού, ἄγγελος Κυρίου ἐπέστη, καὶ φῶς ἔλαμψεν ἐν τῷ οἰκήματι· πατάξας δὲ τὴν πλευρὰν τοῦ Πέτρου, ἤγειρεν αὐτὸν λέγων, Ἀνάστα ἐν τάχει. Καὶ ἐξέπεσον αὐτοῦ αἱ ἁλύσεις ἐκ τῶν χειρῶν. ");
INSERT INTO grctr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Εἶπέ τε ὁ ἄγγελος πρὸς αὐτόν, Περίζωσαι καὶ ὑπόδησαι τὰ σανδάλιά σου. Ἐποίησε δὲ οὕτω. Καὶ λέγει αὐτῷ, Περιβαλοῦ τὸ ἱμάτιόν σου, καὶ ἀκολούθει μοι. ");
INSERT INTO grctr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Καὶ ἐξελθὼν ἠκολούθει αὐτῷ· καὶ οὐκ ᾔδει ὅτι ἀληθές ἐστι τὸ γινόμενον διὰ τοῦ ἀγγέλου, ἐδόκει δὲ ὅραμα βλέπειν. ");
INSERT INTO grctr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Διελθόντες δὲ πρώτην φυλακὴν καὶ δευτέραν, ἦλθον ἐπὶ τὴν πύλην τὴν σιδηρᾶν, τὴν φέρουσαν εἰς τὴν πόλιν, ἥτις αὐτομάτη ἠνοίχθη αὐτοῖς· καὶ ἐξελθόντες προῆλθον ῥύμην μίαν, καὶ εὐθέως ἀπέστη ὁ ἄγγελος ἀπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Καὶ ὁ Πέτρος, γενόμενος ἐν ἑαυτῷ, εἶπε, Νῦν οἶδα ἀληθῶς ὅτι ἐξαπέστειλε Κύριος τὸν ἄγγελον αὐτοῦ, καὶ ἐξείλετό με ἐκ χειρὸς Ἡρῴδου καὶ πάσης τῆς προσδοκίας τοῦ λαοῦ τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Συνιδών τε ἦλθεν ἐπὶ τὴν οἰκίαν Μαρίας τῆς μητρὸς Ἰωάννου τοῦ ἐπικαλουμένου Μάρκου, οὗ ἦσαν ἱκανοὶ συνηθροισμένοι καὶ προσευχόμενοι. ");
INSERT INTO grctr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Κρούσαντος δὲ τοῦ Πέτρου τὴν θύραν τοῦ πυλῶνος, προσῆλθε παιδίσκη ὑπακοῦσαι, ὀνόματι Ῥόδη. ");
INSERT INTO grctr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Καὶ ἐπιγνοῦσα τὴν φωνὴν τοῦ Πέτρου, ἀπὸ τῆς χαρᾶς οὐκ ἤνοιξε τὸν πυλῶνα, εἰσδραμοῦσα δὲ ἀπήγγειλεν ἑστάναι τὸν Πέτρον πρὸ τοῦ πυλῶνος. ");
INSERT INTO grctr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Οἱ δὲ πρὸς αὐτὴν εἶπον, Μαίνῃ. Ἡ δὲ διϊσχυρίζετο οὕτως ἔχειν. Οἱ δ᾿ ἔλεγον, Ὁ ἄγγελος αὐτοῦ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ὁ δὲ Πέτρος ἐπέμενε κρούων· ἀνοίξαντες δὲ εἶδον αὐτόν, καὶ ἐξέστησαν. ");
INSERT INTO grctr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Κατασείσας δὲ αὐτοῖς τῇ χειρὶ σιγᾷν, διηγήσατο αὐτοῖς πῶς ὁ Κύριος αὐτὸν ἐξήγαγεν ἐκ τῆς φυλακῆς. Εἶπε δέ, Ἀπαγγείλατε Ἰακώβῳ καὶ τοῖς ἀδελφοῖς ταῦτα. Καὶ ἐξελθὼν ἐπορεύθη εἰς ἕτερον τόπον. ");
INSERT INTO grctr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Γενομένης δὲ ἡμέρας, ἦν τάραχος οὐκ ὀλίγος ἐν τοῖς στρατιώταις, τί ἄρα ὁ Πέτρος ἐγένετο. ");
INSERT INTO grctr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ἡρῴδης δὲ ἐπιζητήσας αὐτὸν καὶ μὴ εὑρών, ἀνακρίνας τοὺς φύλακας, ἐκέλευσεν ἀπαχθῆναι. Καὶ κατελθὼν ἀπὸ τῆς Ἰουδαίας εἰς τὴν Καισάρειαν διέτριβεν. ");
INSERT INTO grctr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ἦν δὲ ὁ Ἡρῴδης θυμομαχῶν Τυρίοις καὶ Σιδωνίοις· ὁμοθυμαδὸν δὲ παρῆσαν πρὸς αὐτόν, καὶ πείσαντες Βλάστον τὸν ἐπὶ τοῦ κοιτῶνος τοῦ βασιλέως, ᾐτοῦντο εἰρήνην, διὰ τὸ τρέφεσθαι αὐτῶν τὴν χώραν ἀπὸ τῆς βασιλικῆς. ");
INSERT INTO grctr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Τακτῇ δὲ ἡμέρᾳ ὁ Ἡρῴδης ἐνδυσάμενος ἐσθῆτα βασιλικήν, καὶ καθίσας ἐπὶ τοῦ βήματος, ἐδημηγόρει πρὸς αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ὁ δὲ δῆμος ἐπεφώνει, Θεοῦ φωνὴ καὶ οὐκ ἀνθρώπου. ");
INSERT INTO grctr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Παραχρῆμα δὲ ἐπάταξεν αὐτὸν ἄγγελος Κυρίου, ἀνθ᾿ ὧν οὐκ ἔδωκε τὴν δόξαν τῷ Θεῷ· καὶ γενόμενος σκωληκόβρωτος, ἐξέψυξεν. ");
INSERT INTO grctr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ὁ δὲ λόγος τοῦ Θεοῦ ηὔξανε καὶ ἐπληθύνετο. ");
INSERT INTO grctr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Βαρνάβας δὲ καὶ Σαῦλος ὑπέστρεψαν ἐξ Ἱερουσαλήμ, πληρώσαντες τὴν διακονίαν, συμπαραλαβόντες καὶ Ἰωάννην τὸν ἐπικληθέντα Μάρκον. ");
INSERT INTO grctr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ἦσαν δέ τινες ἐν Ἀντιοχείᾳ κατὰ τὴν οὖσαν ἐκκλησίαν προφῆται καὶ διδάσκαλοι, ὅ τε Βαρνάβας καὶ Συμεὼν ὁ καλούμενος Νίγερ, καὶ Λούκιος ὁ Κυρηναῖος, Μαναήν τε Ἡρῴδου τοῦ τετράρχου σύντροφος, καὶ Σαῦλος. ");
INSERT INTO grctr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Λειτουργούντων δὲ αὐτῶν τῷ Κυρίῳ καὶ νηστευόντων, εἶπε τὸ πνεῦμα τὸ ἅγιον, Ἀφορίσατε δή μοι τὸν τε Βαρνάβαν καὶ τὸν Σαῦλον εἰς τὸ ἔργον ὃ προσκέκλημαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Τότε νηστεύσαντες καὶ προσευξάμενοι καὶ ἐπιθέντες τὰς χεῖρας αὐτοῖς, ἀπέλυσαν. ");
INSERT INTO grctr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Οὗτοι μὲν οὖν, ἐκπεμφθέντες ὑπὸ τοῦ πνεύματος τοῦ ἁγίου, κατῆλθον εἰς τὴν Σελεύκειαν· ἐκεῖθέν τε ἀπέπλευσαν εἰς τὴν Κύπρον. ");
INSERT INTO grctr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Καὶ γενόμενοι ἐν Σαλαμῖνι, κατήγγελλον τὸν λόγον τοῦ Θεοῦ ἐν ταῖς συναγωγαῖς τῶν Ἰουδαίων· εἶχον δὲ καὶ Ἰωάννην ὑπηρέτην. ");
INSERT INTO grctr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Διελθόντες δὲ τὴν νῆσον ἄχρι Πάφου, εὗρόν τινα μάγον ψευδοπροφήτην Ἰουδαῖον, ᾧ ὄνομα Βαρϊησοῦς, ");
INSERT INTO grctr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ὃς ἦν σὺν τῷ ἀνθυπάτῳ Σεργίῳ Παύλῳ, ἀνδρὶ συνετῷ. Οὗτος προσκαλεσάμενος Βαρνάβαν καὶ Σαῦλον ἐπεζήτησεν ἀκοῦσαι τὸν λόγον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ἀνθίστατο δὲ αὐτοῖς Ἐλύμας, ὁ μάγος — οὕτω γὰρ μεθερμηνεύεται τὸ ὄνομα αὐτοῦ — ζητῶν διαστρέψαι τὸν ἀνθύπατον ἀπὸ τῆς πίστεως. ");
INSERT INTO grctr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Σαῦλος δέ, ὁ καὶ Παῦλος, πλησθεὶς πνεύματος ἁγίου, καὶ ἀτενίσας εἰς αὐτὸν ");
INSERT INTO grctr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","εἶπεν, Ὦ πλήρης παντὸς δόλου καὶ πάσης ῥᾳδιουργίας, υἱὲ διαβόλου, ἐχθρὲ πάσης δικαιοσύνης, οὐ παύσῃ διαστρέφων τὰς ὁδοὺς Κυρίου τὰς εὐθείας; ");
INSERT INTO grctr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Καὶ νῦν ἰδού, χεὶρ τοῦ Κυρίου ἐπὶ σέ, καὶ ἔσῃ τυφλός, μὴ βλέπων τὸν ἥλιον ἄχρι καιροῦ. Παραχρῆμα δὲ ἐπέπεσεν ἐπ᾿ αὐτὸν ἀχλὺς καὶ σκότος, καὶ περιάγων ἐζήτει χειραγωγούς. ");
INSERT INTO grctr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Τότε ἰδὼν ὁ ἀνθύπατος τὸ γεγονὸς ἐπίστευσεν, ἐκπλησσόμενος ἐπὶ τῇ διδαχῇ τοῦ Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ἀναχθέντες δὲ ἀπὸ τῆς Πάφου οἱ περὶ τὸν Παῦλον ἦλθον εἰς Πέργην τῆς Παμφυλίας. Ἰωάννης δὲ ἀποχωρήσας ἀπ᾿ αὐτῶν ὑπέστρεψεν εἰς Ἱεροσόλυμα. ");
INSERT INTO grctr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Αὐτοὶ δὲ διελθόντες ἀπὸ τῆς Πέργης, παρεγένοντο εἰς Ἀντιόχειαν τῆς Πισιδίας, καὶ εἰσελθόντες εἰς τὴν συναγωγὴν τῇ ἡμέρᾳ τῶν σαββάτων, ἐκάθισαν. ");
INSERT INTO grctr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Μετὰ δὲ τὴν ἀνάγνωσιν τοῦ νόμου καὶ τῶν προφητῶν, ἀπέστειλαν οἱ ἀρχισυνάγωγοι πρὸς αὐτούς, λέγοντες, Ἄνδρες ἀδελφοί, εἰ ἔστι λόγος ἐν ὑμῖν παρακλήσεως πρὸς τὸν λαόν, λέγετε. ");
INSERT INTO grctr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ἀναστὰς δὲ Παῦλος, καὶ κατασείσας τῇ χειρί, εἶπεν, Ἄνδρες Ἰσραηλῖται, καὶ οἱ φοβούμενοι τὸν Θεόν, ἀκούσατε. ");
INSERT INTO grctr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ὁ Θεὸς τοῦ λαοῦ τούτου Ἰσραὴλ ἐξελέξατο τοὺς πατέρας ἡμῶν, καὶ τὸν λαὸν ὕψωσεν ἐν τῇ παροικίᾳ ἐν γῇ Αἰγύπτῳ, καὶ μετὰ βραχίονος ὑψηλοῦ ἐξήγαγεν αὐτοὺς ἐξ αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Καὶ ὡς τεσσαρακονταετῆ χρόνον ἐτροποφόρησεν αὐτοὺς ἐν τῇ ἐρήμῳ. ");
INSERT INTO grctr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Καὶ καθελὼν ἔθνη ἑπτὰ ἐν γῇ Χαναάν, κατεκληροδότησεν αὐτοῖς τὴν γῆν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Καὶ μετὰ ταῦτα, ὡς ἔτεσι τετρακοσίοις καὶ πεντήκοντα, ἔδωκε κριτὰς ἕως Σαμουὴλ τοῦ προφήτου. ");
INSERT INTO grctr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Κἀκεῖθεν ᾐτήσαντο βασιλέα, καὶ ἔδωκεν αὐτοῖς ὁ Θεὸς τὸν Σαοὺλ υἱὸν Κίς, ἄνδρα ἐκ φυλῆς Βενιαμίν, ἔτη τεσσαράκοντα. ");
INSERT INTO grctr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Καὶ μεταστήσας αὐτόν, ἤγειρεν αὐτοῖς τὸν Δαβὶδ εἰς βασιλέα, ᾧ καὶ εἶπε μαρτυρήσας, Εὗρον Δαβὶδ τὸν τοῦ Ἰεσσαί, ἄνδρα κατὰ τὴν καρδίαν μου, ὃς ποιήσει πάντα τὰ θελήματά μου. ");
INSERT INTO grctr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Τούτου ὁ Θεὸς ἀπὸ τοῦ σπέρματος κατ᾿ ἐπαγγελίαν ἤγειρε τῷ Ἰσραὴλ σωτῆρα Ἰησοῦν, ");
INSERT INTO grctr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","προκηρύξαντος Ἰωάννου πρὸ προσώπου τῆς εἰσόδου αὐτοῦ βάπτισμα μετανοίας παντὶ τῷ λαῷ Ἰσραήλ. ");
INSERT INTO grctr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ὡς δὲ ἐπλήρου ὁ Ἰωάννης τὸν δρόμον, ἔλεγε, Τίνα με ὑπονοεῖτε εἶναι; Οὐκ εἰμὶ ἐγώ. Ἀλλ᾿ ἰδού, ἔρχεται μετ᾿ ἐμέ, οὗ οὐκ εἰμὶ ἄξιος τὸ ὑπόδημα τῶν ποδῶν λῦσαι. ");
INSERT INTO grctr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ἄνδρες ἀδελφοί, υἱοὶ γένους Ἀβραάμ, καὶ οἱ ἐν ὑμῖν φοβούμενοι τὸν Θεόν, ὑμῖν ὁ λόγος τῆς σωτηρίας ταύτης ἀπεστάλη. ");
INSERT INTO grctr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Οἱ γὰρ κατοικοῦντες ἐν Ἱερουσαλὴμ καὶ οἱ ἄρχοντες αὐτῶν, τοῦτον ἀγνοήσαντες, καὶ τὰς φωνὰς τῶν προφητῶν τὰς κατὰ πᾶν σάββατον ἀναγινωσκομένας, κρίναντες ἐπλήρωσαν. ");
INSERT INTO grctr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Καὶ μηδεμίαν αἰτίαν θανάτου εὑρόντες, ᾐτήσαντο Πιλάτον ἀναιρεθῆναι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ὡς δὲ ἐτέλεσαν ἅπαντα τὰ περὶ αὐτοῦ γεγραμμένα, καθελόντες ἀπὸ τοῦ ξύλου, ἔθηκαν εἰς μνημεῖον. ");
INSERT INTO grctr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ὁ δὲ Θεὸς ἤγειρεν αὐτὸν ἐκ νεκρῶν· ");
INSERT INTO grctr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ὃς ὤφθη ἐπὶ ἡμέρας πλείους τοῖς συναναβᾶσιν αὐτῷ ἀπὸ τῆς Γαλιλαίας εἰς Ἱερουσαλήμ, οἵτινές εἰσι μάρτυρες αὐτοῦ πρὸς τὸν λαόν. ");
INSERT INTO grctr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Καὶ ἡμεῖς ὑμᾶς εὐαγγελιζόμεθα τὴν πρὸς τοὺς πατέρας ἐπαγγελίαν γενομένην, ὅτι ταύτην ὁ Θεὸς ἐκπεπλήρωκε τοῖς τέκνοις αὐτῶν ἡμῖν, ἀναστήσας Ἰησοῦν· ");
INSERT INTO grctr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ὡς καὶ ἐν τῷ ψαλμῷ τῷ δευτέρῳ γέγραπται, Υἱός μου εἶ σύ, ἐγὼ σήμερον γεγέννηκά σε. ");
INSERT INTO grctr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ὅτι δὲ ἀνέστησεν αὐτὸν ἐκ νεκρῶν, μηκέτι μέλλοντα ὑποστρέφειν εἰς διαφθοράν, οὕτως εἴρηκεν ὅτι Δώσω ὑμῖν τὰ ὅσια Δαβὶδ τὰ πιστά. ");
INSERT INTO grctr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Διὸ καὶ ἐν ἑτέρῳ λέγει, Οὐ δώσεις τὸν ὅσιόν σου ἰδεῖν διαφθοράν· ");
INSERT INTO grctr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Δαβὶδ μὲν γὰρ ἰδίᾳ γενεᾷ ὑπηρετήσας τῇ τοῦ Θεοῦ βουλῇ ἐκοιμήθη, καὶ προσετέθη πρὸς τοὺς πατέρας αὐτοῦ, καὶ εἶδε διαφθοράν· ");
INSERT INTO grctr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ὃν δὲ ὁ Θεὸς ἤγειρεν, οὐκ εἶδε διαφθοράν. ");
INSERT INTO grctr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Γνωστὸν οὖν ἔστω ὑμῖν, ἄνδρες ἀδελφοί, ὅτι διὰ τούτου ὑμῖν ἄφεσις ἁμαρτιῶν καταγγέλλεται· ");
INSERT INTO grctr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","καὶ ἀπὸ πάντων ὧν οὐκ ἠδυνήθητε ἐν τῷ νόμῳ Μωσέως δικαιωθῆναι, ἐν τούτῳ πᾶς ὁ πιστεύων δικαιοῦται. ");
INSERT INTO grctr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Βλέπετε οὖν μὴ ἐπέλθῃ ἐφ᾿ ὑμᾶς τὸ εἰρημένον ἐν τοῖς προφήταις, ");
INSERT INTO grctr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ἴδετε, οἱ καταφρονηταί, καὶ θαυμάσατε, καὶ ἀφανίσθητε· ὅτι ἔργον ἐγὼ ἐργάζομαι ἐν ταῖς ἡμέραις ὑμῶν, ἔργον ᾧ οὐ μὴ πιστεύσητε, ἐάν τις ἐκδιηγῆται ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ἐξιόντων δὲ ἐκ τῆς συναγωγῆς τῶν Ἰουδαίων, παρεκάλουν τὰ ἔθνη εἰς τὸ μεταξὺ σάββατον λαληθῆναι αὐτοῖς τὰ ῥήματα ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Λυθείσης δὲ τῆς συναγωγῆς, ἠκολούθησαν πολλοὶ τῶν Ἰουδαίων καὶ τῶν σεβομένων προσηλύτων τῷ Παύλῳ καὶ τῷ Βαρνάβᾳ· οἵτινες προσλαλοῦντες αὐτοῖς, ἔπειθον αὐτοὺς ἐπιμένειν τῇ χάριτι τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Τῷ δὲ ἐρχομένῳ σαββάτῳ σχεδὸν πᾶσα ἡ πόλις συνήχθη ἀκοῦσαι τὸν λόγον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ἰδόντες δὲ οἱ Ἰουδαῖοι τοὺς ὄχλους ἐπλήσθησαν ζήλου, καὶ ἀντέλεγον τοῖς ὑπὸ τοῦ Παύλου λεγομένοις, ἀντιλέγοντες καὶ βλασφημοῦντες. ");
INSERT INTO grctr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Παρρησιασάμενοι δὲ ὁ Παῦλος καὶ ὁ Βαρνάβας εἶπον, Ὑμῖν ἦν ἀναγκαῖον πρῶτον λαληθῆναι τὸν λόγον τοῦ Θεοῦ. Ἐπειδὴ δὲ ἀπωθεῖσθε αὐτόν, καὶ οὐκ ἀξίους κρίνετε ἑαυτοὺς τῆς αἰωνίου ζωῆς, ἰδοὺ στρεφόμεθα εἰς τὰ ἔθνη. ");
INSERT INTO grctr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Οὕτω γὰρ ἐντέταλται ἡμῖν ὁ Κύριος, Τέθεικά σε εἰς φῶς ἐθνῶν, τοῦ εἶναί σε εἰς σωτηρίαν ἕως ἐσχάτου τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ἀκούοντα δὲ τὰ ἔθνη ἔχαιρον, καὶ ἐδόξαζον τὸν λόγον τοῦ Κυρίου, καὶ ἐπίστευσαν ὅσοι ἦσαν τεταγμένοι εἰς ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Διεφέρετο δὲ ὁ λόγος τοῦ Κυρίου δι᾿ ὅλης τῆς χώρας. ");
INSERT INTO grctr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Οἱ δὲ Ἰουδαῖοι παρώτρυναν τὰς σεβομένας γυναῖκας καὶ τὰς εὐσχήμονας καὶ τοὺς πρώτους τῆς πόλεως, καὶ ἐπήγειραν διωγμὸν ἐπὶ τὸν Παῦλον καὶ τὸν Βαρνάβαν, καὶ ἐξέβαλον αὐτοὺς ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Οἱ δὲ ἐκτιναξάμενοι τὸν κονιορτὸν τῶν ποδῶν αὐτῶν ἐπ᾿ αὐτούς, ἦλθον εἰς Ἰκόνιον. ");
INSERT INTO grctr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Οἱ δὲ μαθηταὶ ἐπληροῦντο χαρᾶς καὶ πνεύματος ἁγίου. ");
INSERT INTO grctr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ἐγένετο δὲ ἐν Ἰκονίῳ, κατὰ τὸ αὐτὸ εἰσελθεῖν αὐτοὺς εἰς τὴν συναγωγὴν τῶν Ἰουδαίων, καὶ λαλῆσαι οὕτως ὥστε πιστεῦσαι Ἰουδαίων τε καὶ Ἑλλήνων πολὺ πλῆθος. ");
INSERT INTO grctr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Οἱ δὲ ἀπειθοῦντες Ἰουδαῖοι ἐπήγειραν καὶ ἐκάκωσαν τὰς ψυχὰς τῶν ἐθνῶν κατὰ τῶν ἀδελφῶν. ");
INSERT INTO grctr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ἱκανὸν μὲν οὖν χρόνον διέτριψαν παρρησιαζόμενοι ἐπὶ τῷ Κυρίῳ τῷ μαρτυροῦντι τῷ λόγῳ τῆς χάριτος αὐτοῦ, καὶ διδόντι σημεῖα καὶ τέρατα γίνεσθαι διὰ τῶν χειρῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ἐσχίσθη δὲ τὸ πλῆθος τῆς πόλεως· καὶ οἱ μὲν ἦσαν σὺν τοῖς Ἰουδαίοις, οἱ δὲ σὺν τοῖς ἀποστόλοις. ");
INSERT INTO grctr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ὡς δὲ ἐγένετο ὁρμὴ τῶν ἐθνῶν τε καὶ Ἰουδαίων σὺν τοῖς ἄρχουσιν αὐτῶν, ὑβρίσαι καὶ λιθοβολῆσαι αὐτούς, ");
INSERT INTO grctr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","συνιδόντες κατέφυγον εἰς τὰς πόλεις τῆς Λυκαονίας, Λύστραν καὶ Δέρβην, καὶ τὴν περίχωρον· ");
INSERT INTO grctr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","κἀκεῖ ἦσαν εὐαγγελιζόμενοι. ");
INSERT INTO grctr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Καί τις ἀνὴρ ἐν Λύστροις ἀδύνατος τοῖς ποσὶν ἐκάθητο, χωλὸς ἐκ κοιλίας μητρὸς αὐτοῦ ὑπάρχων, ὃς οὐδέποτε περιεπεπατήκει. ");
INSERT INTO grctr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Οὗτος ἤκουε τοῦ Παύλου λαλοῦντος· ὃς ἀτενίσας αὐτῷ, καὶ ἰδὼν ὅτι πίστιν ἔχει τοῦ σωθῆναι, ");
INSERT INTO grctr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","εἶπε μεγάλῃ τῇ φωνῇ, Ἀνάστηθι ἐπὶ τοὺς πόδας σου ὀρθός. Καὶ ἥλλετο καὶ περιεπάτει. ");
INSERT INTO grctr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Οἱ δὲ ὄχλοι, ἰδόντες ὃ ἐποίησεν ὁ Παῦλος, ἐπῆραν τὴν φωνὴν αὐτῶν Λυκαονιστὶ λέγοντες, Οἱ θεοὶ ὁμοιωθέντες ἀνθρώποις κατέβησαν πρὸς ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ἐκάλουν τε τὸν μὲν Βαρνάβαν, Δία· τὸν δὲ Παῦλον, Ἑρμῆν, ἐπειδὴ αὐτὸς ἦν ὁ ἡγούμενος τοῦ λόγου. ");
INSERT INTO grctr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ὁ δὲ ἱερεὺς τοῦ Διὸς τοῦ ὄντος πρὸ τῆς πόλεως αὐτῶν, ταύρους καὶ στέμματα ἐπὶ τοὺς πυλῶνας ἐνέγκας, σὺν τοῖς ὄχλοις ἤθελε θύειν. ");
INSERT INTO grctr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ἀκούσαντες δὲ οἱ ἀπόστολοι Βαρνάβας καὶ Παῦλος, διαρρήξαντες τὰ ἱμάτια αὐτῶν, εἰσεπήδησαν εἰς τὸν ὄχλον, κράζοντες ");
INSERT INTO grctr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","καὶ λέγοντες, Ἄνδρες, τί ταῦτα ποιεῖτε; Καὶ ἡμεῖς ὁμοιοπαθεῖς ἐσμεν ὑμῖν ἄνθρωποι, εὐαγγελιζόμενοι ὑμᾶς ἀπὸ τούτων τῶν ματαίων ἐπιστρέφειν ἐπὶ τὸν Θεὸν τὸν ζῶντα, ὃς ἐποίησε τὸν οὐρανὸν καὶ τὴν γῆν καὶ τὴν θάλασσαν καὶ πάντα τὰ ἐν αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ὃς ἐν ταῖς παρῳχημέναις γενεαῖς εἴασε πάντα τὰ ἔθνη πορεύεσθαι ταῖς ὁδοῖς αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Καίτοιγε οὐκ ἀμάρτυρον ἑαυτὸν ἀφῆκεν ἀγαθοποιῶν, οὐρανόθεν ἡμῖν ὑετοὺς διδοὺς καὶ καιροὺς καρποφόρους, ἐμπιπλῶν τροφῆς καὶ εὐφροσύνης τὰς καρδίας ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Καὶ ταῦτα λέγοντες, μόλις κατέπαυσαν τοὺς ὄχλους τοῦ μὴ θύειν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ἐπῆλθον δὲ ἀπὸ Ἀντιοχείας καὶ Ἰκονίου Ἰουδαῖοι, καὶ πείσαντες τοὺς ὄχλους, καὶ λιθάσαντες τὸν Παῦλον, ἔσυρον ἔξω τῆς πόλεως, νομίσαντες αὐτὸν τεθνάναι. ");
INSERT INTO grctr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Κυκλωσάντων δὲ αὐτὸν τῶν μαθητῶν, ἀναστὰς εἰσῆλθεν εἰς τὴν πόλιν· καὶ τῇ ἐπαύριον ἐξῆλθε σὺν τῷ Βαρνάβᾳ εἰς Δέρβην. ");
INSERT INTO grctr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Εὐαγγελισάμενοί τε τὴν πόλιν ἐκείνην, καὶ μαθητεύσαντες ἱκανούς, ὑπέστρεψαν εἰς τὴν Λύστραν καὶ Ἰκόνιον καὶ Ἀντιόχειαν, ");
INSERT INTO grctr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ἐπιστηρίζοντες τὰς ψυχὰς τῶν μαθητῶν, παρακαλοῦντες ἐμμένειν τῇ πίστει, καὶ ὅτι διὰ πολλῶν θλίψεων δεῖ ἡμᾶς εἰσελθεῖν εἰς τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Χειροτονήσαντες δὲ αὐτοῖς πρεσβυτέρους κατ᾿ ἐκκλησίαν, προσευξάμενοι μετὰ νηστειῶν, παρέθεντο αὐτοὺς τῷ Κυρίῳ εἰς ὃν πεπιστεύκεισαν. ");
INSERT INTO grctr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Καὶ διελθόντες τὴν Πισιδίαν ἦλθον εἰς Παμφυλίαν. ");
INSERT INTO grctr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Καὶ λαλήσαντες ἐν Πέργῃ τὸν λόγον, κατέβησαν εἰς Ἀττάλειαν· ");
INSERT INTO grctr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","κἀκεῖθεν ἀπέπλευσαν εἰς Ἀντιόχειαν, ὅθεν ἦσαν παραδεδομένοι τῇ χάριτι τοῦ Θεοῦ εἰς τὸ ἔργον ὃ ἐπλήρωσαν. ");
INSERT INTO grctr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Παραγενόμενοι δὲ καὶ συναγαγόντες τὴν ἐκκλησίαν, ἀνήγγειλαν ὅσα ἐποίησεν ὁ Θεὸς μετ᾿ αὐτῶν, καὶ ὅτι ἤνοιξε τοῖς ἔθνεσι θύραν πίστεως. ");
INSERT INTO grctr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Διέτριβον δὲ ἐκεῖ χρόνον οὐκ ὀλίγον σὺν τοῖς μαθηταῖς. ");
INSERT INTO grctr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Καί τινες κατελθόντες ἀπὸ τῆς Ἰουδαίας, ἐδίδασκον τοὺς ἀδελφοὺς ὅτι Ἐὰν μὴ περιτέμνησθε τῷ ἔθει Μωϋσέως, οὐ δύνασθε σωθῆναι. ");
INSERT INTO grctr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Γενομένης οὖν στάσεως καὶ συζητήσεως οὐκ ὀλίγης τῷ Παύλῳ καὶ τῷ Βαρνάβᾳ πρὸς αὐτούς, ἔταξαν ἀναβαίνειν Παῦλον καὶ Βαρνάβαν καί τινας ἄλλους ἐξ αὐτῶν πρὸς τοὺς ἀποστόλους καὶ πρεσβυτέρους εἰς Ἱερουσαλὴμ περὶ τοῦ ζητήματος τούτου. ");
INSERT INTO grctr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Οἱ μὲν οὖν, προπεμφθέντες ὑπὸ τῆς ἐκκλησίας, διήρχοντο τὴν Φοινίκην καὶ Σαμάρειαν, ἐκδιηγούμενοι τὴν ἐπιστροφὴν τῶν ἐθνῶν· καὶ ἐποίουν χαρὰν μεγάλην πᾶσι τοῖς ἀδελφοῖς. ");
INSERT INTO grctr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Παραγενόμενοι δὲ εἰς Ἱερουσαλήμ, ἀπεδέχθησαν ὑπὸ τῆς ἐκκλησίας καὶ τῶν ἀποστόλων καὶ τῶν πρεσβυτέρων, ἀνήγγειλάν τε ὅσα ὁ Θεὸς ἐποίησε μετ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ἐξανέστησαν δέ τινες τῶν ἀπὸ τῆς αἱρέσεως τῶν Φαρισαίων πεπιστευκότες, λέγοντες ὅτι Δεῖ περιτέμνειν αὐτούς, παραγγέλλειν τε τηρεῖν τὸν νόμον Μωϋσέως. ");
INSERT INTO grctr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Συνήχθησαν δὲ οἱ ἀπόστολοι καὶ οἱ πρεσβύτεροι ἰδεῖν περὶ τοῦ λόγου τούτου. ");
INSERT INTO grctr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Πολλῆς δὲ συζητήσεως γενομένης, ἀναστὰς Πέτρος εἶπε πρὸς αὐτούς, Ἄνδρες ἀδελφοί, ὑμεῖς ἐπίστασθε ὅτι ἀφ᾿ ἡμερῶν ἀρχαίων ὁ Θεὸς ἐν ἡμῖν ἐξελέξατο, διὰ τοῦ στόματός μου ἀκοῦσαι τὰ ἔθνη τὸν λόγον τοῦ εὐαγγελίου, καὶ πιστεῦσαι. ");
INSERT INTO grctr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Καὶ ὁ καρδιογνώστης Θεὸς ἐμαρτύρησεν αὐτοῖς, δοὺς αὐτοῖς τὸ πνεῦμα τὸ ἅγιον, καθὼς καὶ ἡμῖν· ");
INSERT INTO grctr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","καὶ οὐδὲν διέκρινε μεταξὺ ἡμῶν τε καὶ αὐτῶν, τῇ πίστει καθαρίσας τὰς καρδίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Νῦν οὖν τί πειράζετε τὸν Θεόν, ἐπιθεῖναι ζυγὸν ἐπὶ τὸν τράχηλον τῶν μαθητῶν, ὃν οὔτε οἱ πατέρες ἡμῶν οὔτε ἡμεῖς ἰσχύσαμεν βαστάσαι; ");
INSERT INTO grctr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ἀλλὰ διὰ τῆς χάριτος Κυρίου Ἰησοῦ Χριστοῦ πιστεύομεν σωθῆναι, καθ᾿ ὃν τρόπον κἀκεῖνοι. ");
INSERT INTO grctr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ἐσίγησε δὲ πᾶν τὸ πλῆθος, καὶ ἤκουον Βαρνάβα καὶ Παύλου ἐξηγουμένων ὅσα ἐποίησεν ὁ Θεὸς σημεῖα καὶ τέρατα ἐν τοῖς ἔθνεσι δι᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Μετὰ δὲ τὸ σιγῆσαι αὐτούς, ἀπεκρίθη Ἰάκωβος λέγων, Ἄνδρες ἀδελφοί, ἀκούσατέ μου· ");
INSERT INTO grctr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Συμεὼν ἐξηγήσατο καθὼς πρῶτον ὁ Θεὸς ἐπεσκέψατο λαβεῖν ἐξ ἐθνῶν λαὸν ἐπὶ τῷ ὀνόματι αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Καὶ τούτῳ συμφωνοῦσιν οἱ λόγοι τῶν προφητῶν, καθὼς γέγραπται, ");
INSERT INTO grctr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Μετὰ ταῦτα ἀναστρέψω, καὶ ἀνοικοδομήσω τὴν σκηνὴν Δαβὶδ τὴν πεπτωκυῖαν· καὶ τὰ κατεσκαμμένα αὐτῆς ἀνοικοδομήσω, καὶ ἀνορθώσω αὐτήν· ");
INSERT INTO grctr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ὅπως ἂν ἐκζητήσωσιν οἱ κατάλοιποι τῶν ἀνθρώπων τὸν Κύριον, καὶ πάντα τὰ ἔθνη, ἐφ᾿ οὓς ἐπικέκληται τὸ ὄνομά μου ἐπ᾿ αὐτούς, λέγει Κύριος ὁ ποιῶν ταῦτα πάντα. ");
INSERT INTO grctr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Γνωστὰ ἀπ᾿ αἰῶνός ἐστι τῷ Θεῷ πάντα τὰ ἔργα αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Διὸ ἐγὼ κρίνω μὴ παρενοχλεῖν τοῖς ἀπὸ τῶν ἐθνῶν ἐπιστρέφουσιν ἐπὶ τὸν Θεόν· ");
INSERT INTO grctr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ἀλλὰ ἐπιστεῖλαι αὐτοῖς τοῦ ἀπέχεσθαι ἀπὸ τῶν ἀλισγημάτων τῶν εἰδώλων καὶ τῆς πορνείας καὶ τοῦ πνικτοῦ καὶ τοῦ αἵματος. ");
INSERT INTO grctr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Μωσῆς γὰρ ἐκ γενεῶν ἀρχαίων κατὰ πόλιν τοὺς κηρύσσοντας αὐτὸν ἔχει, ἐν ταῖς συναγωγαῖς κατὰ πᾶν σάββατον ἀναγινωσκόμενος. ");
INSERT INTO grctr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Τότε ἔδοξε τοῖς ἀποστόλοις καὶ τοῖς πρεσβυτέροις σὺν ὅλῃ τῇ ἐκκλησίᾳ, ἐκλεξαμένους ἄνδρας ἐξ αὐτῶν πέμψαι εἰς Ἀντιόχειαν σὺν τῷ Παύλῳ καὶ Βαρνάβᾳ, Ἰούδαν τὸν ἐπικαλούμενον Βαρσαβᾶν, καὶ Σίλαν, ἄνδρας ἡγουμένους ἐν τοῖς ἀδελφοῖς, ");
INSERT INTO grctr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","γράψαντες διὰ χειρὸς αὐτῶν τάδε, Οἱ ἀπόστολοι καὶ οἱ πρεσβύτεροι καὶ οἱ ἀδελφοὶ τοῖς κατὰ τὴν Ἀντιόχειαν καὶ Συρίαν καὶ Κιλικίαν ἀδελφοῖς τοῖς ἐξ ἐθνῶν, χαίρειν· ");
INSERT INTO grctr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ἐπειδὴ ἠκούσαμεν ὅτι τινὲς ἐξ ἡμῶν ἐξελθόντες ἐτάραξαν ὑμᾶς λόγοις, ἀνασκευάζοντες τὰς ψυχὰς ὑμῶν, λέγοντες περιτέμνεσθαι καὶ τηρεῖν τὸν νόμον, οἷς οὐ διεστειλάμεθα· ");
INSERT INTO grctr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ἔδοξεν ἡμῖν γενομένοις ὁμοθυμαδόν, ἐκλεξαμένους ἄνδρας πέμψαι πρὸς ὑμᾶς, σὺν τοῖς ἀγαπητοῖς ἡμῶν Βαρνάβᾳ καὶ Παύλῳ, ");
INSERT INTO grctr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ἀνθρώποις παραδεδωκόσι τὰς ψυχὰς αὐτῶν ὑπὲρ τοῦ ὀνόματος τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ἀπεστάλκαμεν οὖν Ἰούδαν καὶ Σίλαν, καὶ αὐτοὺς διὰ λόγου ἀπαγγέλλοντας τὰ αὐτά. ");
INSERT INTO grctr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ἔδοξε γὰρ τῷ ἁγίῳ πνεύματι, καὶ ἡμῖν, μηδὲν πλέον ἐπιτίθεσθαι ὑμῖν βάρος, πλὴν τῶν ἐπάναγκες τούτων, ");
INSERT INTO grctr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ἀπέχεσθαι εἰδωλοθύτων καὶ αἵματος καὶ πνικτοῦ καὶ πορνείας· ἐξ ὧν διατηροῦντες ἑαυτούς, εὖ πράξετε. Ἔρρωσθε. ");
INSERT INTO grctr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Οἱ μὲν οὖν ἀπολυθέντες ἦλθον εἰς Ἀντιόχειαν· καὶ συναγαγόντες τὸ πλῆθος, ἐπέδωκαν τὴν ἐπιστολήν. ");
INSERT INTO grctr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ἀναγνόντες δέ, ἐχάρησαν ἐπὶ τῇ παρακλήσει. ");
INSERT INTO grctr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ἰούδας δὲ καὶ Σίλας, καὶ αὐτοὶ προφῆται ὄντες, διὰ λόγου πολλοῦ παρεκάλεσαν τοὺς ἀδελφούς, καὶ ἐπεστήριξαν. ");
INSERT INTO grctr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ποιήσαντες δὲ χρόνον, ἀπελύθησαν μετ᾿ εἰρήνης ἀπὸ τῶν ἀδελφῶν πρὸς τοὺς ἀποστόλους. ");
INSERT INTO grctr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ἔδοξε δὲ τῷ Σίλᾳ ἐπιμεῖναι αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Παῦλος δὲ καὶ Βαρνάβας διέτριβον ἐν Ἀντιοχείᾳ, διδάσκοντες καὶ εὐαγγελιζόμενοι, μετὰ καὶ ἑτέρων πολλῶν, τὸν λόγον τοῦ Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Μετὰ δέ τινας ἡμέρας εἶπε Παῦλος πρὸς Βαρνάβαν, Ἐπιστρέψαντες δὴ ἐπισκεψώμεθα τοὺς ἀδελφοὺς ἡμῶν κατὰ πᾶσαν πόλιν, ἐν αἷς κατηγγείλαμεν τὸν λόγον τοῦ Κυρίου, πῶς ἔχουσι. ");
INSERT INTO grctr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Βαρνάβας δὲ ἐβουλεύσατο συμπαραλαβεῖν τὸν Ἰωάννην, τὸν καλούμενον Μάρκον. ");
INSERT INTO grctr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Παῦλος δὲ ἠξίου, τὸν ἀποστάντα ἀπ᾿ αὐτῶν ἀπὸ Παμφυλίας, καὶ μὴ συνελθόντα αὐτοῖς εἰς τὸ ἔργον, μὴ συμπαραλαβεῖν τοῦτον. ");
INSERT INTO grctr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ἐγένετο οὖν παροξυσμός, ὥστε ἀποχωρισθῆναι αὐτοὺς ἀπ᾿ ἀλλήλων, τόν τε Βαρνάβαν παραλαβόντα τὸν Μάρκον ἐκπλεῦσαι εἰς Κύπρον· ");
INSERT INTO grctr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Παῦλος δὲ ἐπιλεξάμενος Σίλαν ἐξῆλθε, παραδοθεὶς τῇ χάριτι τοῦ Θεοῦ ὑπὸ τῶν ἀδελφῶν. ");
INSERT INTO grctr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Διήρχετο δὲ τὴν Συρίαν καὶ Κιλικίαν, ἐπιστηρίζων τὰς ἐκκλησίας. ");
INSERT INTO grctr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Κατήντησε δὲ εἰς Δέρβην καὶ Λύστραν· καὶ ἰδού, μαθητής τις ἦν ἐκεῖ, ὀνόματι Τιμόθεος, υἱὸς γυναικός τινος Ἰουδαίας πιστῆς, πατρὸς δὲ Ἕλληνος· ");
INSERT INTO grctr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ὃς ἐμαρτυρεῖτο ὑπὸ τῶν ἐν Λύστροις καὶ Ἰκονίῳ ἀδελφῶν. ");
INSERT INTO grctr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Τοῦτον ἠθέλησεν ὁ Παῦλος σὺν αὐτῷ ἐξελθεῖν, καὶ λαβὼν περιέτεμεν αὐτόν, διὰ τοὺς Ἰουδαίους τοὺς ὄντας ἐν τοῖς τόποις ἐκείνοις· ᾔδεισαν γὰρ ἅπαντες τὸν πατέρα αὐτοῦ, ὅτι Ἕλλην ὑπῆρχεν. ");
INSERT INTO grctr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ὡς δὲ διεπορεύοντο τὰς πόλεις, παρεδίδουν αὐτοῖς φυλάσσειν τὰ δόγματα τὰ κεκριμένα ὑπὸ τῶν ἀποστόλων καὶ τῶν πρεσβυτέρων τῶν ἐν Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Αἱ μὲν οὖν ἐκκλησίαι ἐστερεοῦντο τῇ πίστει, καὶ ἐπερίσσευον τῷ ἀριθμῷ καθ᾿ ἡμέραν. ");
INSERT INTO grctr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Διελθόντες δὲ τὴν Φρυγίαν καὶ τὴν Γαλατικὴν χώραν, κωλυθέντες ὑπὸ τοῦ ἁγίου πνεύματος λαλῆσαι τὸν λόγον ἐν τῇ Ἀσίᾳ, ");
INSERT INTO grctr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ἐλθόντες κατὰ τὴν Μυσίαν ἐπείραζον κατὰ τὴν Βιθυνίαν πορεύεσθαι· καὶ οὐκ εἴασεν αὐτοὺς τὸ πνεῦμα· ");
INSERT INTO grctr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","παρελθόντες δὲ τὴν Μυσίαν κατέβησαν εἰς Τρῳάδα. ");
INSERT INTO grctr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Καὶ ὅραμα διὰ τῆς νυκτὸς ὤφθη τῷ Παύλῳ· ἀνήρ τις ἦν Μακεδὼν ἑστώς, παρακαλῶν αὐτὸν καὶ λέγων, Διαβὰς εἰς Μακεδονίαν, βοήθησον ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ὡς δὲ τὸ ὅραμα εἶδεν, εὐθέως ἐζητήσαμεν ἐξελθεῖν εἰς τὴν Μακεδονίαν, συμβιβάζοντες ὅτι προσκέκληται ἡμᾶς ὁ Κύριος εὐαγγελίσασθαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ἀναχθέντες οὖν ἀπὸ τῆς Τρῳάδος, εὐθυδρομήσαμεν εἰς Σαμοθρᾴκην, τῇ τε ἐπιούσῃ εἰς Νεάπολιν, ");
INSERT INTO grctr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ἐκεῖθέν τε εἰς Φιλίππους, ἥτις ἐστὶ πρώτη τῆς μερίδος τῆς Μακεδονίας πόλις, κολωνία· ἦμεν δὲ ἐν ταύτῃ τῇ πόλει διατρίβοντες ἡμέρας τινάς. ");
INSERT INTO grctr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Τῇ τε ἡμέρᾳ τῶν σαββάτων ἐξήλθομεν ἔξω τῆς πόλεως παρὰ ποταμόν, οὗ ἐνομίζετο προσευχὴ εἶναι, καὶ καθίσαντες ἐλαλοῦμεν ταῖς συνελθούσαις γυναιξί. ");
INSERT INTO grctr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Καί τις γυνὴ ὀνόματι Λυδία, πορφυρόπωλις πόλεως Θυατείρων, σεβομένη τὸν Θεόν, ἤκουεν· ἧς ὁ Κύριος διήνοιξε τὴν καρδίαν, προσέχειν τοῖς λαλουμένοις ὑπὸ τοῦ Παύλου. ");
INSERT INTO grctr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ὡς δὲ ἐβαπτίσθη, καὶ ὁ οἶκος αὐτῆς, παρεκάλεσε λέγουσα, Εἰ κεκρίκατέ με πιστὴν τῷ Κυρίῳ εἶναι, εἰσελθόντες εἰς τὸν οἶκόν μου, μείνατε. Καὶ παρεβιάσατο ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ἐγένετο δὲ πορευομένων ἡμῶν εἰς προσευχήν, παιδίσκην τινὰ ἔχουσαν πνεῦμα Πύθωνος ἀπαντῆσαι ἡμῖν, ἥτις ἐργασίαν πολλὴν παρεῖχε τοῖς κυρίοις αὐτῆς, μαντευομένη. ");
INSERT INTO grctr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Αὕτη κατακολουθήσασα τῷ Παύλῳ καὶ ἡμῖν, ἔκραζε λέγουσα, Οὗτοι οἱ ἄνθρωποι δοῦλοι τοῦ Θεοῦ τοῦ ὑψίστου εἰσίν, οἵτινες καταγγέλλουσιν ἡμῖν ὁδὸν σωτηρίας. ");
INSERT INTO grctr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Τοῦτο δὲ ἐποίει ἐπὶ πολλὰς ἡμέρας. Διαπονηθεὶς δὲ ὁ Παῦλος, καὶ ἐπιστρέψας, τῷ πνεύματι εἶπε, Παραγγέλλω σοι ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ, ἐξελθεῖν ἀπ᾿ αὐτῆς. Καὶ ἐξῆλθεν αὐτῇ τῇ ὥρᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ἰδόντες δὲ οἱ κύριοι αὐτῆς ὅτι ἐξῆλθεν ἡ ἐλπὶς τῆς ἐργασίας αὐτῶν, ἐπιλαβόμενοι τὸν Παῦλον καὶ τὸν Σίλαν, εἵλκυσαν εἰς τὴν ἀγορὰν ἐπὶ τοὺς ἄρχοντας, ");
INSERT INTO grctr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","καὶ προσαγαγόντες αὐτοὺς τοῖς στρατηγοῖς εἶπον, Οὗτοι οἱ ἄνθρωποι ἐκταράσσουσιν ἡμῶν τὴν πόλιν, Ἰουδαῖοι ὑπάρχοντες, ");
INSERT INTO grctr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","καὶ καταγγέλλουσιν ἔθη ἃ οὐκ ἔξεστιν ἡμῖν παραδέχεσθαι οὐδὲ ποιεῖν, Ῥωμαίοις οὖσι. ");
INSERT INTO grctr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Καὶ συνεπέστη ὁ ὄχλος κατ᾿ αὐτῶν, καὶ οἱ στρατηγοὶ περιρρήξαντες αὐτῶν τὰ ἱμάτια ἐκέλευον ῥαβδίζειν. ");
INSERT INTO grctr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Πολλάς τε ἐπιθέντες αὐτοῖς πληγὰς ἔβαλον εἰς φυλακήν, παραγγείλαντες τῷ δεσμοφύλακι ἀσφαλῶς τηρεῖν αὐτούς· ");
INSERT INTO grctr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ὅς, παραγγελίαν τοιαύτην εἰληφώς, ἔβαλεν αὐτοὺς εἰς τὴν ἐσωτέραν φυλακήν, καὶ τοὺς πόδας αὐτῶν ἠσφαλίσατο εἰς τὸ ξύλον. ");
INSERT INTO grctr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Κατὰ δὲ τὸ μεσονύκτιον Παῦλος καὶ Σίλας προσευχόμενοι ὕμνουν τὸν Θεόν, ἐπηκροῶντο δὲ αὐτῶν οἱ δέσμιοι· ");
INSERT INTO grctr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ἄφνω δὲ σεισμὸς ἐγένετο μέγας, ὥστε σαλευθῆναι τὰ θεμέλια τοῦ δεσμωτηρίου· ἀνεῴχθησάν τε παραχρῆμα αἱ θύραι πᾶσαι, καὶ πάντων τὰ δεσμὰ ἀνέθη. ");
INSERT INTO grctr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ἔξυπνος δὲ γενόμενος ὁ δεσμοφύλαξ, καὶ ἰδὼν ἀνεῳγμένας τὰς θύρας τῆς φυλακῆς, σπασάμενος μάχαιραν, ἔμελλεν ἑαυτὸν ἀναιρεῖν, νομίζων ἐκπεφευγέναι τοὺς δεσμίους. ");
INSERT INTO grctr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ἐφώνησε δὲ φωνῇ μεγάλῃ ὁ Παῦλος λέγων, Μηδὲν πράξῃς σεαυτῷ κακόν· ἅπαντες γάρ ἐσμεν ἐνθάδε. ");
INSERT INTO grctr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Αἰτήσας δὲ φῶτα εἰσεπήδησε, καὶ ἔντρομος γενόμενος προσέπεσε τῷ Παύλῳ καὶ τῷ Σίλᾳ, ");
INSERT INTO grctr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","καὶ προαγαγὼν αὐτοὺς ἔξω ἔφη, Κύριοι, τί με δεῖ ποιεῖν ἵνα σωθῶ; ");
INSERT INTO grctr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Οἱ δὲ εἶπον, Πίστευσον ἐπὶ τὸν Κύριον Ἰησοῦν Χριστόν, καὶ σωθήσῃ σὺ καὶ ὁ οἶκός σου. ");
INSERT INTO grctr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Καὶ ἐλάλησαν αὐτῷ τὸν λόγον τοῦ Κυρίου, καὶ πᾶσι τοῖς ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Καὶ παραλαβὼν αὐτοὺς ἐν ἐκείνῃ τῇ ὥρᾳ τῆς νυκτὸς ἔλουσεν ἀπὸ τῶν πληγῶν, καὶ ἐβαπτίσθη αὐτὸς καὶ οἱ αὐτοῦ πάντες παραχρῆμα. ");
INSERT INTO grctr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ἀναγαγών τε αὐτοὺς εἰς τὸν οἶκον αὐτοῦ παρέθηκε τράπεζαν, καὶ ἠγαλλιάσατο πανοικὶ πεπιστευκὼς τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ἡμέρας δὲ γενομένης, ἀπέστειλαν οἱ στρατηγοὶ τοὺς ῥαβδούχους λέγοντες, Ἀπόλυσον τοὺς ἀνθρώπους ἐκείνους. ");
INSERT INTO grctr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ἀπήγγειλε δὲ ὁ δεσμοφύλαξ τοὺς λόγους τούτους πρὸς τὸν Παῦλον ὅτι Ἀπεστάλκασιν οἱ στρατηγοί, ἵνα ἀπολυθῆτε· νῦν οὖν ἐξελθόντες πορεύεσθε ἐν εἰρήνῃ. ");
INSERT INTO grctr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ὁ δὲ Παῦλος ἔφη πρὸς αὐτούς, Δείραντες ἡμᾶς δημοσίᾳ, ἀκατακρίτους, ἀνθρώπους Ῥωμαίους ὑπάρχοντας, ἔβαλον εἰς φυλακήν, καὶ νῦν λάθρᾳ ἡμᾶς ἐκβάλλουσιν; Οὐ γάρ· ἀλλὰ ἐλθόντες αὐτοὶ ἡμᾶς ἐξαγαγέτωσαν. ");
INSERT INTO grctr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ἀνήγγειλαν δὲ τοῖς στρατηγοῖς οἱ ῥαβδοῦχοι τὰ ῥήματα ταῦτα· καὶ ἐφοβήθησαν ἀκούσαντες ὅτι Ῥωμαῖοί εἰσι, ");
INSERT INTO grctr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","καὶ ἐλθόντες παρεκάλεσαν αὐτούς, καὶ ἐξαγαγόντες ἠρώτων ἐξελθεῖν τῆς πόλεως. ");
INSERT INTO grctr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ἐξελθόντες δὲ ἐκ τῆς φυλακῆς εἰσῆλθον εἰς τὴν Λυδίαν· καὶ ἰδόντες τοὺς ἀδελφούς, παρεκάλεσαν αὐτούς, καὶ ἐξῆλθον. ");
INSERT INTO grctr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Διοδεύσαντες δὲ τὴν Ἀμφίπολιν καὶ Ἀπολλωνίαν, ἦλθον εἰς Θεσσαλονίκην, ὅπου ἦν ἡ συναγωγὴ τῶν Ἰουδαίων· ");
INSERT INTO grctr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","κατὰ δὲ τὸ εἰωθὸς τῷ Παύλῳ εἰσῆλθε πρὸς αὐτούς, καὶ ἐπὶ σάββατα τρία διελέγετο αὐτοῖς ἀπὸ τῶν γραφῶν, ");
INSERT INTO grctr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","διανοίγων καὶ παρατιθέμενος, ὅτι Τὸν Χριστὸν ἔδει παθεῖν καὶ ἀναστῆναι ἐκ νεκρῶν, καὶ ὅτι Οὗτός ἐστιν ὁ Χριστὸς Ἰησοῦς, ὃν ἐγὼ καταγγέλλω ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Καί τινες ἐξ αὐτῶν ἐπείσθησαν, καὶ προσεκληρώθησαν τῷ Παύλῳ καὶ τῷ Σίλᾳ, τῶν τε σεβομένων Ἑλλήνων πολὺ πλῆθος, γυναικῶν τε τῶν πρώτων οὐκ ὀλίγαι. ");
INSERT INTO grctr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ζηλώσαντες δὲ οἱ ἀπειθοῦντες Ἰουδαῖοι, καὶ προσλαβόμενοι τῶν ἀγοραίων τινὰς ἄνδρας πονηρούς, καὶ ὀχλοποιήσαντες, ἐθορύβουν τὴν πόλιν· ἐπιστάντες τε τῇ οἰκίᾳ Ἰάσονος, ἐζήτουν αὐτοὺς ἀγαγεῖν εἰς τὸν δῆμον. ");
INSERT INTO grctr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Μὴ εὑρόντες δὲ αὐτούς, ἔσυρον τὸν Ἰάσονα καί τινας ἀδελφοὺς ἐπὶ τοὺς πολιτάρχας, βοῶντες ὅτι Οἱ τὴν οἰκουμένην ἀναστατώσαντες, οὗτοι καὶ ἐνθάδε πάρεισιν, ");
INSERT INTO grctr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","οὓς ὑποδέδεκται Ἰάσων· καὶ οὗτοι πάντες ἀπέναντι τῶν δογμάτων Καίσαρος πράττουσι, βασιλέα λέγοντες ἕτερον εἶναι, Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ἐτάραξαν δὲ τὸν ὄχλον καὶ τοὺς πολιτάρχας ἀκούοντας ταῦτα. ");
INSERT INTO grctr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Καὶ λαβόντες τὸ ἱκανὸν παρὰ τοῦ Ἰάσονος καὶ τῶν λοιπῶν, ἀπέλυσαν αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Οἱ δὲ ἀδελφοὶ εὐθέως διὰ τῆς νυκτὸς ἐξέπεμψαν τόν τε Παῦλον καὶ τὸν Σίλαν εἰς Βέροιαν· οἵτινες παραγενόμενοι εἰς τὴν συναγωγὴν τῶν Ἰουδαίων ἀπῄεσαν. ");
INSERT INTO grctr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Οὗτοι δὲ ἦσαν εὐγενέστεροι τῶν ἐν Θεσσαλονίκῃ, οἵτινες ἐδέξαντο τὸν λόγον μετὰ πάσης προθυμίας, τὸ καθ᾿ ἡμέραν ἀνακρίνοντες τὰς γραφάς, εἰ ἔχοι ταῦτα οὕτω. ");
INSERT INTO grctr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Πολλοὶ μὲν οὖν ἐξ αὐτῶν ἐπίστευσαν, καὶ τῶν Ἑλληνίδων γυναικῶν τῶν εὐσχημόνων καὶ ἀνδρῶν οὐκ ὀλίγοι. ");
INSERT INTO grctr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ὡς δὲ ἔγνωσαν οἱ ἀπὸ τῆς Θεσσαλονίκης Ἰουδαῖοι ὅτι καὶ ἐν τῇ Βεροίᾳ κατηγγέλη ὑπὸ τοῦ Παύλου ὁ λόγος τοῦ Θεοῦ, ἦλθον κἀκεῖ σαλεύοντες τοὺς ὄχλους. ");
INSERT INTO grctr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Εὐθέως δὲ τότε τὸν Παῦλον ἐξαπέστειλαν οἱ ἀδελφοὶ πορεύεσθαι ὡς ἐπὶ τὴν θάλασσαν· ὑπέμενον δὲ ὅ τε Σίλας καὶ ὁ Τιμόθεος ἐκεῖ. ");
INSERT INTO grctr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Οἱ δὲ καθιστῶντες τὸν Παῦλον, ἤγαγον αὐτὸν ἕως Ἀθηνῶν· καὶ λαβόντες ἐντολὴν πρὸς τὸν Σίλαν καὶ Τιμόθεον, ἵνα ὡς τάχιστα ἔλθωσι πρὸς αὐτόν, ἐξῄεσαν. ");
INSERT INTO grctr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ἐν δὲ ταῖς Ἀθήναις ἐκδεχομένου αὐτοὺς τοῦ Παύλου, παρωξύνετο τὸ πνεῦμα αὐτοῦ ἐν αὐτῷ, θεωροῦντι κατείδωλον οὖσαν τὴν πόλιν. ");
INSERT INTO grctr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Διελέγετο μὲν οὖν ἐν τῇ συναγωγῇ τοῖς Ἰουδαίοις καὶ τοῖς σεβομένοις, καὶ ἐν τῇ ἀγορᾷ κατὰ πᾶσαν ἡμέραν πρὸς τοὺς παρατυγχάνοντας. ");
INSERT INTO grctr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Τινὲς δὲ τῶν Ἐπικουρείων καὶ τῶν Στωϊκῶν φιλοσόφων συνέβαλλον αὐτῷ. Καί τινες ἔλεγον, Τί ἂν θέλοι ὁ σπερμολόγος οὗτος λέγειν; Οἱ δέ, Ξένων δαιμονίων δοκεῖ καταγγελεὺς εἶναι· ὅτι τὸν Ἰησοῦν καὶ τὴν ἀνάστασιν αὐτοῖς εὐηγγελίζετο. ");
INSERT INTO grctr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ἐπιλαβόμενοί τε αὐτοῦ, ἐπὶ τὸν Ἄρειον πάγον ἤγαγον λέγοντες, Δυνάμεθα γνῶναι, τίς ἡ καινὴ αὕτη ἡ ὑπὸ σοῦ λαλουμένη διδαχή; ");
INSERT INTO grctr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ξενίζοντα γάρ τινα εἰσφέρεις εἰς τὰς ἀκοὰς ἡμῶν· βουλόμεθα οὖν γνῶναι, τί ἂν θέλοι ταῦτα εἶναι — ");
INSERT INTO grctr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ἀθηναῖοι δὲ πάντες καὶ οἱ ἐπιδημοῦντες ξένοι εἰς οὐδὲν ἕτερον εὐκαίρουν, ἢ λέγειν τι καὶ ἀκούειν καινότερον. ");
INSERT INTO grctr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Σταθεὶς δὲ ὁ Παῦλος ἐν μέσῳ τοῦ Ἀρείου πάγου ἔφη, Ἄνδρες Ἀθηναῖοι, κατὰ πάντα ὡς δεισιδαιμονεστέρους ὑμᾶς θεωρῶ. ");
INSERT INTO grctr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Διερχόμενος γὰρ καὶ ἀναθεωρῶν τὰ σεβάσματα ὑμῶν, εὗρον καὶ βωμὸν ἐν ᾧ ἐπεγέγραπτο, Ἀγνώστῳ Θεῷ. Ὃν οὖν ἀγνοοῦντες εὐσεβεῖτε, τοῦτον ἐγὼ καταγγέλλω ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ὁ Θεὸς ὁ ποιήσας τὸν κόσμον καὶ πάντα τὰ ἐν αὐτῷ, οὗτος, οὐρανοῦ καὶ γῆς Κύριος ὑπάρχων, οὐκ ἐν χειροποιήτοις ναοῖς κατοικεῖ, ");
INSERT INTO grctr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","οὐδὲ ὑπὸ χειρῶν ἀνθρώπων θεραπεύεται, προσδεόμενός τινος, αὐτὸς διδοὺς πᾶσι ζωὴν καὶ πνοὴν καὶ τὰ πάντα· ");
INSERT INTO grctr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ἐποίησέ τε ἐξ ἑνὸς αἵματος πᾶν ἔθνος ἀνθρώπων, κατοικεῖν ἐπὶ πᾶν τὸ πρόσωπον τῆς γῆς, ὁρίσας προτεταγμένους καιροὺς καὶ τὰς ὁροθεσίας τῆς κατοικίας αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ζητεῖν τὸν Κύριον, εἰ ἄρα γε ψηλαφήσειαν αὐτὸν καὶ εὕροιεν, καίτοιγε οὐ μακρὰν ἀπὸ ἑνὸς ἑκάστου ἡμῶν ὑπάρχοντα. ");
INSERT INTO grctr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ἐν αὐτῷ γὰρ ζῶμεν καὶ κινούμεθα καί ἐσμεν· ὡς καί τινες τῶν καθ᾿ ὑμᾶς ποιητῶν εἰρήκασι, Τοῦ γὰρ καὶ γένος ἐσμέν. ");
INSERT INTO grctr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Γένος οὖν ὑπάρχοντες τοῦ Θεοῦ, οὐκ ὀφείλομεν νομίζειν χρυσῷ ἢ ἀργύρῳ ἢ λίθῳ, χαράγματι τέχνης καὶ ἐνθυμήσεως ἀνθρώπου, τὸ θεῖον εἶναι ὅμοιον. ");
INSERT INTO grctr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Τοὺς μὲν οὖν χρόνους τῆς ἀγνοίας ὑπεριδὼν ὁ Θεός, τὰ νῦν παραγγέλλει τοῖς ἀνθρώποις πᾶσι πανταχοῦ μετανοεῖν· ");
INSERT INTO grctr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","διότι ἔστησεν ἡμέραν, ἐν ᾗ μέλλει κρίνειν τὴν οἰκουμένην ἐν δικαιοσύνῃ, ἐν ἀνδρὶ ᾧ ὥρισε, πίστιν παρασχὼν πᾶσιν, ἀναστήσας αὐτὸν ἐκ νεκρῶν. ");
INSERT INTO grctr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ἀκούσαντες δὲ ἀνάστασιν νεκρῶν, οἱ μὲν ἐχλεύαζον· οἱ δὲ εἶπον, Ἀκουσόμεθά σου πάλιν περὶ τούτου. ");
INSERT INTO grctr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Καὶ οὕτως ὁ Παῦλος ἐξῆλθεν ἐκ μέσου αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Τινὲς δὲ ἄνδρες κολληθέντες αὐτῷ, ἐπίστευσαν· ἐν οἷς καὶ Διονύσιος ὁ Ἀρεοπαγίτης, καὶ γυνὴ ὀνόματι Δάμαρις, καὶ ἕτεροι σὺν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Μετὰ δὲ ταῦτα χωρισθεὶς ὁ Παῦλος ἐκ τῶν Ἀθηνῶν ἦλθεν εἰς Κόρινθον. ");
INSERT INTO grctr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Καὶ εὑρών τινα Ἰουδαῖον ὀνόματι Ἀκύλαν, Ποντικὸν τῷ γένει, προσφάτως ἐληλυθότα ἀπὸ τῆς Ἰταλίας, καὶ Πρίσκιλλαν γυναῖκα αὐτοῦ, διὰ τὸ διατεταχέναι Κλαύδιον χωρίζεσθαι πάντας τοὺς Ἰουδαίους ἐκ τῆς Ῥώμης, προσῆλθεν αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","καὶ διὰ τὸ ὁμότεχνον εἶναι, ἔμενε παρ᾿ αὐτοῖς καὶ εἰργάζετο· ἦσαν γὰρ σκηνοποιοὶ τὴν τέχνην. ");
INSERT INTO grctr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Διελέγετο δὲ ἐν τῇ συναγωγῇ κατὰ πᾶν σάββατον, ἔπειθέ τε Ἰουδαίους καὶ Ἕλληνας. ");
INSERT INTO grctr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ὡς δὲ κατῆλθον ἀπὸ τῆς Μακεδονίας ὅ τε Σίλας καὶ ὁ Τιμόθεος, συνείχετο τῷ πνεύματι ὁ Παῦλος, διαμαρτυρόμενος τοῖς Ἰουδαίοις τὸν Χριστὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ἀντιτασσομένων δὲ αὐτῶν καὶ βλασφημούντων, ἐκτιναξάμενος τὰ ἱμάτια, εἶπε πρὸς αὐτούς, Τὸ αἷμα ὑμῶν ἐπὶ τὴν κεφαλὴν ὑμῶν· καθαρὸς ἐγώ· ἀπὸ τοῦ νῦν εἰς τὰ ἔθνη πορεύσομαι. ");
INSERT INTO grctr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Καὶ μεταβὰς ἐκεῖθεν ἦλθεν εἰς οἰκίαν τινὸς ὀνόματι Ἰούστου, σεβομένου τὸν Θεόν, οὗ ἡ οἰκία ἦν συνομοροῦσα τῇ συναγωγῇ. ");
INSERT INTO grctr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Κρίσπος δὲ ὁ ἀρχισυνάγωγος ἐπίστευσε τῷ Κυρίῳ σὺν ὅλῳ τῷ οἴκῳ αὐτοῦ· καὶ πολλοὶ τῶν Κορινθίων ἀκούοντες ἐπίστευον καὶ ἐβαπτίζοντο. ");
INSERT INTO grctr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Εἶπε δὲ ὁ Κύριος δι᾿ ὁράματος ἐν νυκτὶ τῷ Παύλῳ, Μὴ φοβοῦ, ἀλλὰ λάλει καὶ μὴ σιωπήσῃς· ");
INSERT INTO grctr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","διότι ἐγώ εἰμι μετὰ σοῦ, καὶ οὐδεὶς ἐπιθήσεταί σοι τοῦ κακῶσαί σε· διότι λαός ἐστί μοι πολὺς ἐν τῇ πόλει ταύτῃ. ");
INSERT INTO grctr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ἐκάθισέ τε ἐνιαυτὸν καὶ μῆνας ἕξ, διδάσκων ἐν αὐτοῖς τὸν λόγον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Γαλλίωνος δὲ ἀνθυπατεύοντος τῆς Ἀχαΐας, κατεπέστησαν ὁμοθυμαδὸν οἱ Ἰουδαῖοι τῷ Παύλῳ, καὶ ἤγαγον αὐτὸν ἐπὶ τὸ βῆμα, ");
INSERT INTO grctr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","λέγοντες ὅτι Παρὰ τὸν νόμον οὗτος ἀναπείθει τοὺς ἀνθρώπους σέβεσθαι τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Μέλλοντος δὲ τοῦ Παύλου ἀνοίγειν τὸ στόμα, εἶπεν ὁ Γαλλίων πρὸς τοὺς Ἰουδαίους, Εἰ μὲν οὖν ἦν ἀδίκημά τι ἢ ῥᾳδιούργημα πονηρόν, ὦ Ἰουδαῖοι, κατὰ λόγον ἂν ἠνεσχόμην ὑμῶν· ");
INSERT INTO grctr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","εἰ δὲ ζήτημά ἐστι περὶ λόγου καὶ ὀνομάτων καὶ νόμου τοῦ καθ᾿ ὑμᾶς, ὄψεσθε αὐτοί· κριτὴς γὰρ ἐγὼ τούτων οὐ βούλομαι εἶναι. ");
INSERT INTO grctr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Καὶ ἀπήλασεν αὐτοὺς ἀπὸ τοῦ βήματος. ");
INSERT INTO grctr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ἐπιλαβόμενοι δὲ πάντες οἱ Ἕλληνες Σωσθένην τὸν ἀρχισυνάγωγον ἔτυπτον ἔμπροσθεν τοῦ βήματος. Καὶ οὐδὲν τούτων τῷ Γαλλίωνι ἔμελεν. ");
INSERT INTO grctr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ὁ δὲ Παῦλος ἔτι προσμείνας ἡμέρας ἱκανάς, τοῖς ἀδελφοῖς ἀποταξάμενος, ἐξέπλει εἰς τὴν Συρίαν, καὶ σὺν αὐτῷ Πρίσκιλλα καὶ Ἀκύλας, κειράμενος τὴν κεφαλὴν ἐν Κεγχρεαῖς· εἶχε γὰρ εὐχήν. ");
INSERT INTO grctr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Κατήντησε δὲ εἰς Ἔφεσον, κἀκείνους κατέλιπεν αὐτοῦ· αὐτὸς δὲ εἰσελθὼν εἰς τὴν συναγωγὴν διελέχθη τοῖς Ἰουδαίοις. ");
INSERT INTO grctr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ἐρωτώντων δὲ αὐτῶν ἐπὶ πλείονα χρόνον μεῖναι παρ᾿ αὐτοῖς, οὐκ ἐπένευσεν· ");
INSERT INTO grctr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ἀλλ᾿ ἀπετάξατο αὐτοῖς εἰπών, Δεῖ με πάντως τὴν ἑορτὴν τὴν ἐρχομένην ποιῆσαι εἰς Ἱεροσόλυμα· πάλιν δὲ ἀνακάμψω πρὸς ὑμᾶς, τοῦ Θεοῦ θέλοντος. Καὶ ἀνήχθη ἀπὸ τῆς Ἐφέσου, ");
INSERT INTO grctr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","καὶ κατελθὼν εἰς Καισάρειαν, ἀναβὰς καὶ ἀσπασάμενος τὴν ἐκκλησίαν, κατέβη εἰς Ἀντιόχειαν. ");
INSERT INTO grctr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Καὶ ποιήσας χρόνον τινὰ ἐξῆλθε, διερχόμενος καθεξῆς τὴν Γαλατικὴν χώραν καὶ Φρυγίαν, ἐπιστηρίζων πάντας τοὺς μαθητάς. ");
INSERT INTO grctr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ἰουδαῖος δέ τις Ἀπολλὼς ὀνόματι, Ἀλεξανδρεὺς τῷ γένει, ἀνὴρ λόγιος, κατήντησεν εἰς Ἔφεσον, δυνατὸς ὢν ἐν ταῖς γραφαῖς. ");
INSERT INTO grctr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Οὗτος ἦν κατηχημένος τὴν ὁδὸν τοῦ Κυρίου, καὶ ζέων τῷ πνεύματι ἐλάλει καὶ ἐδίδασκεν ἀκριβῶς τὰ περὶ τοῦ Κυρίου, ἐπιστάμενος μόνον τὸ βάπτισμα Ἰωάννου· ");
INSERT INTO grctr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","οὗτός τε ἤρξατο παρρησιάζεσθαι ἐν τῇ συναγωγῇ. Ἀκούσαντες δὲ αὐτοῦ Ἀκύλας καὶ Πρίσκιλλα, προσελάβοντο αὐτόν, καὶ ἀκριβέστερον αὐτῷ ἐξέθεντο τὴν τοῦ Θεοῦ ὁδόν. ");
INSERT INTO grctr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Βουλομένου δὲ αὐτοῦ διελθεῖν εἰς τὴν Ἀχαΐαν, προτρεψάμενοι οἱ ἀδελφοὶ ἔγραψαν τοῖς μαθηταῖς ἀποδέξασθαι αὐτόν· ὃς παραγενόμενος συνεβάλετο πολὺ τοῖς πεπιστευκόσι διὰ τῆς χάριτος· ");
INSERT INTO grctr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","εὐτόνως γὰρ τοῖς Ἰουδαίοις διακατηλέγχετο δημοσίᾳ, ἐπιδεικνὺς διὰ τῶν γραφῶν εἶναι τὸν Χριστὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ἐγένετο δέ, ἐν τῷ τὸν Ἀπολλὼ εἶναι ἐν Κορίνθῳ, Παῦλον διελθόντα τὰ ἀνωτερικὰ μέρη ἐλθεῖν εἰς Ἔφεσον· καὶ εὑρών τινας μαθητὰς ");
INSERT INTO grctr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","εἶπε πρὸς αὐτούς, Εἰ πνεῦμα ἅγιον ἐλάβετε πιστεύσαντες; Οἱ δὲ εἶπον πρὸς αὐτόν, Ἀλλ᾿ οὐδὲ εἰ πνεῦμα ἅγιόν ἐστιν, ἠκούσαμεν. ");
INSERT INTO grctr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Εἶπέ τε πρὸς αὐτούς, Εἰς τί οὖν ἐβαπτίσθητε; Οἱ δὲ εἶπον, Εἰς τὸ Ἰωάννου βάπτισμα. ");
INSERT INTO grctr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Εἶπε δὲ Παῦλος, Ἰωάννης μὲν ἐβάπτισε βάπτισμα μετανοίας, τῷ λαῷ λέγων εἰς τὸν ἐρχόμενον μετ᾿ αὐτὸν ἵνα πιστεύσωσι, τοῦτ᾿ ἔστιν, εἰς τὸν Χριστὸν Ἰησοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ἀκούσαντες δὲ ἐβαπτίσθησαν εἰς τὸ ὄνομα τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Καὶ ἐπιθέντος αὐτοῖς τοῦ Παύλου τὰς χεῖρας, ἦλθε τὸ πνεῦμα τὸ ἅγιον ἐπ᾿ αὐτούς, ἐλάλουν τε γλώσσαις καὶ προεφήτευον. ");
INSERT INTO grctr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ἦσαν δὲ οἱ πάντες ἄνδρες ὡσεὶ δεκαδύο. ");
INSERT INTO grctr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Εἰσελθὼν δὲ εἰς τὴν συναγωγὴν ἐπαρρησιάζετο, ἐπὶ μῆνας τρεῖς διαλεγόμενος καὶ πείθων τὰ περὶ τῆς βασιλείας τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ὡς δέ τινες ἐσκληρύνοντο καὶ ἠπείθουν, κακολογοῦντες τὴν ὁδὸν ἐνώπιον τοῦ πλήθους, ἀποστὰς ἀπ᾿ αὐτῶν ἀφώρισε τοὺς μαθητάς, καθ᾿ ἡμέραν διαλεγόμενος ἐν τῇ σχολῇ Τυράννου τινός. ");
INSERT INTO grctr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Τοῦτο δὲ ἐγένετο ἐπὶ ἔτη δύο, ὥστε πάντας τοὺς κατοικοῦντας τὴν Ἀσίαν ἀκοῦσαι τὸν λόγον τοῦ Κυρίου Ἰησοῦ, Ἰουδαίους τε καὶ Ἕλληνας. ");
INSERT INTO grctr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Δυνάμεις τε οὐ τὰς τυχούσας ἐποίει ὁ Θεὸς διὰ τῶν χειρῶν Παύλου, ");
INSERT INTO grctr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ὥστε καὶ ἐπὶ τοὺς ἀσθενοῦντας ἐπιφέρεσθαι ἀπὸ τοῦ χρωτὸς αὐτοῦ σουδάρια ἢ σιμικίνθια, καὶ ἀπαλλάσσεσθαι ἀπ᾿ αὐτῶν τὰς νόσους, τά τε πνεύματα τὰ πονηρὰ ἐξέρχεσθαι ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ἐπεχείρησαν δέ τινες ἀπὸ τῶν περιερχομένων Ἰουδαίων ἐξορκιστῶν ὀνομάζειν ἐπὶ τοὺς ἔχοντας τὰ πνεύματα τὰ πονηρὰ τὸ ὄνομα τοῦ Κυρίου Ἰησοῦ, λέγοντες, Ὁρκίζομεν ὑμᾶς τὸν Ἰησοῦν ὃν ὁ Παῦλος κηρύσσει. ");
INSERT INTO grctr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ἦσαν δέ τινες υἱοὶ Σκευᾶ Ἰουδαίου ἀρχιερέως ἑπτὰ οἱ τοῦτο ποιοῦντες. ");
INSERT INTO grctr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ἀποκριθὲν δὲ τὸ πνεῦμα τὸ πονηρὸν εἶπε, Τὸν Ἰησοῦν γινώσκω, καὶ τὸν Παῦλον ἐπίσταμαι· ὑμεῖς δὲ τίνες ἐστέ; ");
INSERT INTO grctr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Καὶ ἐφαλλόμενος ἐπ᾿ αὐτοὺς ὁ ἄνθρωπος ἐν ᾧ ἦν τὸ πνεῦμα τὸ πονηρόν, καὶ κατακυριεύσας αὐτῶν, ἴσχυσε κατ᾿ αὐτῶν, ὥστε γυμνοὺς καὶ τετραυματισμένους ἐκφυγεῖν ἐκ τοῦ οἴκου ἐκείνου. ");
INSERT INTO grctr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Τοῦτο δὲ ἐγένετο γνωστὸν πᾶσιν Ἰουδαίοις τε καὶ Ἕλλησι τοῖς κατοικοῦσι τὴν Ἔφεσον, καὶ ἐπέπεσε φόβος ἐπὶ πάντας αὐτούς, καὶ ἐμεγαλύνετο τὸ ὄνομα τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Πολλοί τε τῶν πεπιστευκότων ἤρχοντο, ἐξομολογούμενοι, καὶ ἀναγγέλλοντες τὰς πράξεις αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ἱκανοὶ δὲ τῶν τὰ περίεργα πραξάντων συνενέγκαντες τὰς βίβλους κατέκαιον ἐνώπιον πάντων· καὶ συνεψήφισαν τὰς τιμὰς αὐτῶν, καὶ εὗρον ἀργυρίου μυριάδας πέντε. ");
INSERT INTO grctr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Οὕτω κατὰ κράτος ὁ λόγος τοῦ Κυρίου ηὔξανε καὶ ἴσχυεν. ");
INSERT INTO grctr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ὡς δὲ ἐπληρώθη ταῦτα, ἔθετο ὁ Παῦλος ἐν τῷ πνεύματι, διελθὼν τὴν Μακεδονίαν καὶ Ἀχαΐαν, πορεύεσθαι εἰς Ἱερουσαλήμ, εἰπὼν ὅτι Μετὰ τὸ γενέσθαι με ἐκεῖ, δεῖ με καὶ Ῥώμην ἰδεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ἀποστείλας δὲ εἰς τὴν Μακεδονίαν δύο τῶν διακονούντων αὐτῷ, Τιμόθεον καὶ Ἔραστον, αὐτὸς ἐπέσχε χρόνον εἰς τὴν Ἀσίαν. ");
INSERT INTO grctr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ἐγένετο δὲ κατὰ τὸν καιρὸν ἐκεῖνον τάραχος οὐκ ὀλίγος περὶ τῆς ὁδοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Δημήτριος γάρ τις ὀνόματι, ἀργυροκόπος, ποιῶν ναοὺς ἀργυροῦς Ἀρτέμιδος, παρείχετο τοῖς τεχνίταις ἐργασίαν οὐκ ὀλίγην· ");
INSERT INTO grctr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","οὓς συναθροίσας, καὶ τοὺς περὶ τὰ τοιαῦτα ἐργάτας, εἶπεν, Ἄνδρες, ἐπίστασθε ὅτι ἐκ ταύτης τῆς ἐργασίας ἡ εὐπορία ἡμῶν ἐστι. ");
INSERT INTO grctr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Καὶ θεωρεῖτε καὶ ἀκούετε ὅτι οὐ μόνον Ἐφέσου, ἀλλὰ σχεδὸν πάσης τῆς Ἀσίας, ὁ Παῦλος οὗτος πείσας μετέστησεν ἱκανὸν ὄχλον, λέγων ὅτι οὐκ εἰσὶ θεοὶ οἱ διὰ χειρῶν γινόμενοι. ");
INSERT INTO grctr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Οὐ μόνον δὲ τοῦτο κινδυνεύει ἡμῖν τὸ μέρος εἰς ἀπελεγμὸν ἐλθεῖν, ἀλλὰ καὶ τὸ τῆς μεγάλης θεᾶς Ἀρτέμιδος ἱερὸν εἰς οὐδὲν λογισθῆναι, μέλλειν τε καὶ καθαιρεῖσθαι τὴν μεγαλειότητα αὐτῆς, ἣν ὅλη ἡ Ἀσία καὶ ἡ οἰκουμένη σέβεται. ");
INSERT INTO grctr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ἀκούσαντες δὲ καὶ γενόμενοι πλήρεις θυμοῦ, ἔκραζον λέγοντες, Μεγάλη ἡ Ἄρτεμις Ἐφεσίων. ");
INSERT INTO grctr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Καὶ ἐπλήσθη ἡ πόλις ὅλη συγχύσεως· ὥρμησάν τε ὁμοθυμαδὸν εἰς τὸ θέατρον, συναρπάσαντες Γάϊον καὶ Ἀρίσταρχον Μακεδόνας, συνεκδήμους τοῦ Παύλου. ");
INSERT INTO grctr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Τοῦ δὲ Παύλου βουλομένου εἰσελθεῖν εἰς τὸν δῆμον, οὐκ εἴων αὐτὸν οἱ μαθηταί. ");
INSERT INTO grctr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Τινὲς δὲ καὶ τῶν Ἀσιαρχῶν, ὄντες αὐτῷ φίλοι, πέμψαντες πρὸς αὐτόν, παρεκάλουν μὴ δοῦναι ἑαυτὸν εἰς τὸ θέατρον. ");
INSERT INTO grctr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ἄλλοι μὲν οὖν ἄλλο τι ἔκραζον· ἦν γὰρ ἡ ἐκκλησία συγκεχυμένη, καὶ οἱ πλείους οὐκ ᾔδεισαν τίνος ἕνεκεν συνεληλύθεισαν. ");
INSERT INTO grctr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ἐκ δὲ τοῦ ὄχλου προεβίβασαν Ἀλέξανδρον, προβαλλόντων αὐτὸν τῶν Ἰουδαίων. Ὁ δὲ Ἀλέξανδρος, κατασείσας τὴν χεῖρα, ἤθελεν ἀπολογεῖσθαι τῷ δήμῳ. ");
INSERT INTO grctr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ἐπιγνόντων δὲ ὅτι Ἰουδαῖός ἐστι, φωνὴ ἐγένετο μία ἐκ πάντων ὡς ἐπὶ ὥρας δύο κραζόντων, Μεγάλη ἡ Ἄρτεμις Ἐφεσίων. ");
INSERT INTO grctr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Καταστείλας δὲ ὁ γραμματεὺς τὸν ὄχλον φησίν, Ἄνδρες Ἐφέσιοι, τίς γάρ ἐστιν ἄνθρωπος ὃς οὐ γινώσκει τὴν Ἐφεσίων πόλιν νεωκόρον οὖσαν τῆς μεγάλης θεᾶς Ἀρτέμιδος καὶ τοῦ Διοπετοῦς; ");
INSERT INTO grctr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ἀναντιρρήτων οὖν ὄντων τούτων, δέον ἐστὶν ὑμᾶς κατεσταλμένους ὑπάρχειν, καὶ μηδὲν προπετὲς πράττειν. ");
INSERT INTO grctr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ἠγάγετε γὰρ τοὺς ἄνδρας τούτους, οὔτε ἱεροσύλους οὔτε βλασφημοῦντας τὴν θεὰν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Εἰ μὲν οὖν Δημήτριος καὶ οἱ σὺν αὐτῷ τεχνῖται πρός τινα λόγον ἔχουσιν, ἀγοραῖοι ἄγονται, καὶ ἀνθύπατοί εἰσιν· ἐγκαλείτωσαν ἀλλήλοις. ");
INSERT INTO grctr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Εἰ δέ τι περὶ ἑτέρων ἐπιζητεῖτε, ἐν τῇ ἐννόμῳ ἐκκλησίᾳ ἐπιλυθήσεται. ");
INSERT INTO grctr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Καὶ γὰρ κινδυνεύομεν ἐγκαλεῖσθαι στάσεως περὶ τῆς σήμερον, μηδενὸς αἰτίου ὑπάρχοντος περὶ οὗ δυνησόμεθα ἀποδοῦναι λόγον τῆς συστροφῆς ταύτης. ");
INSERT INTO grctr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Καὶ ταῦτα εἰπών, ἀπέλυσε τὴν ἐκκλησίαν. ");
INSERT INTO grctr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Μετὰ δὲ τὸ παύσασθαι τὸν θόρυβον, προσκαλεσάμενος ὁ Παῦλος τοὺς μαθητάς, καὶ ἀσπασάμενος, ἐξῆλθε πορευθῆναι εἰς τὴν Μακεδονίαν. ");
INSERT INTO grctr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Διελθὼν δὲ τὰ μέρη ἐκεῖνα, καὶ παρακαλέσας αὐτοὺς λόγῳ πολλῷ, ἦλθεν εἰς τὴν Ἑλλάδα. ");
INSERT INTO grctr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ποιήσας τε μῆνας τρεῖς, γενομένης αὐτῷ ἐπιβουλῆς ὑπὸ τῶν Ἰουδαίων μέλλοντι ἀνάγεσθαι εἰς τὴν Συρίαν, ἐγένετο γνώμη τοῦ ὑποστρέφειν διὰ Μακεδονίας. ");
INSERT INTO grctr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Συνείπετο δὲ αὐτῷ ἄχρι τῆς Ἀσίας Σώπατρος Βεροιαῖος· Θεσσαλονικέων δέ, Ἀρίσταρχος καὶ Σεκοῦνδος, καὶ Γάϊος Δερβαῖος, καὶ Τιμόθεος· Ἀσιανοὶ δέ, Τυχικὸς καὶ Τρόφιμος. ");
INSERT INTO grctr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Οὗτοι προελθόντες ἔμενον ἡμᾶς ἐν Τρῳάδι. ");
INSERT INTO grctr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ἡμεῖς δὲ ἐξεπλεύσαμεν μετὰ τὰς ἡμέρας τῶν ἀζύμων ἀπὸ Φιλίππων, καὶ ἤλθομεν πρὸς αὐτοὺς εἰς τὴν Τρῳάδα ἄχρις ἡμερῶν πέντε, οὗ διετρίψαμεν ἡμέρας ἑπτά. ");
INSERT INTO grctr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ἐν δὲ τῇ μιᾷ τῶν σαββάτων, συνηγμένων τῶν μαθητῶν τοῦ κλάσαι ἄρτον, ὁ Παῦλος διελέγετο αὐτοῖς, μέλλων ἐξιέναι τῇ ἐπαύριον, παρέτεινέ τε τὸν λόγον μέχρι μεσονυκτίου. ");
INSERT INTO grctr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ἦσαν δὲ λαμπάδες ἱκαναὶ ἐν τῷ ὑπερῴῳ οὗ ἦσαν συνηγμένοι. ");
INSERT INTO grctr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Καθήμενος δέ τις νεανίας ὀνόματι Εὔτυχος ἐπὶ τῆς θυρίδος, καταφερόμενος ὕπνῳ βαθεῖ, διαλεγομένου τοῦ Παύλου ἐπὶ πλεῖον, κατενεχθεὶς ἀπὸ τοῦ ὕπνου ἔπεσεν ἀπὸ τοῦ τριστέγου κάτω, καὶ ἤρθη νεκρός. ");
INSERT INTO grctr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Καταβὰς δὲ ὁ Παῦλος ἐπέπεσεν αὐτῷ, καὶ συμπεριλαβὼν εἶπε, Μὴ θορυβεῖσθε· ἡ γὰρ ψυχὴ αὐτοῦ ἐν αὐτῷ ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ἀναβὰς δὲ καὶ κλάσας ἄρτον καὶ γευσάμενος, ἐφ᾿ ἱκανόν τε ὁμιλήσας ἄχρις αὐγῆς, οὕτως ἐξῆλθεν. ");
INSERT INTO grctr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ἤγαγον δὲ τὸν παῖδα ζῶντα, καὶ παρεκλήθησαν οὐ μετρίως. ");
INSERT INTO grctr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ἡμεῖς δέ, προελθόντες ἐπὶ τὸ πλοῖον, ἀνήχθημεν εἰς τὴν Ἄσσον, ἐκεῖθεν μέλλοντες ἀναλαμβάνειν τὸν Παῦλον· οὕτω γὰρ ἦν διατεταγμένος, μέλλων αὐτὸς πεζεύειν. ");
INSERT INTO grctr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ὡς δὲ συνέβαλεν ἡμῖν εἰς τὴν Ἄσσον, ἀναλαβόντες αὐτὸν ἤλθομεν εἰς Μιτυλήνην. ");
INSERT INTO grctr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Κἀκεῖθεν ἀποπλεύσαντες, τῇ ἐπιούσῃ κατηντήσαμεν ἀντικρὺ Χίου· τῇ δὲ ἑτέρᾳ παρεβάλομεν εἰς Σάμον· καὶ μείναντες ἐν Τρωγυλλίῳ, τῇ ἐχομένῃ ἤλθομεν εἰς Μίλητον. ");
INSERT INTO grctr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ἔκρινε γὰρ ὁ Παῦλος παραπλεῦσαι τὴν Ἔφεσον, ὅπως μὴ γένηται αὐτῷ χρονοτριβῆσαι ἐν τῇ Ἀσίᾳ· ἔσπευδε γάρ, εἰ δυνατὸν ἦν αὐτῷ, τὴν ἡμέραν τῆς Πεντηκοστῆς γενέσθαι εἰς Ἱεροσόλυμα. ");
INSERT INTO grctr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ἀπὸ δὲ τῆς Μιλήτου πέμψας εἰς Ἔφεσον μετεκαλέσατο τοὺς πρεσβυτέρους τῆς ἐκκλησίας. ");
INSERT INTO grctr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ὡς δὲ παρεγένοντο πρὸς αὐτόν, εἶπεν αὐτοῖς, Ὑμεῖς ἐπίστασθε, ἀπὸ πρώτης ἡμέρας ἀφ᾿ ἧς ἐπέβην εἰς τὴν Ἀσίαν, πῶς μεθ᾿ ὑμῶν τὸν πάντα χρόνον ἐγενόμην, ");
INSERT INTO grctr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","δουλεύων τῷ Κυρίῳ μετὰ πάσης ταπεινοφροσύνης καὶ πολλῶν δακρύων καὶ πειρασμῶν τῶν συμβάντων μοι ἐν ταῖς ἐπιβουλαῖς τῶν Ἰουδαίων· ");
INSERT INTO grctr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ὡς οὐδὲν ὑπεστειλάμην τῶν συμφερόντων, τοῦ μὴ ἀναγγεῖλαι ὑμῖν καὶ διδάξαι ὑμᾶς δημοσίᾳ καὶ κατ᾿ οἴκους, ");
INSERT INTO grctr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","διαμαρτυρόμενος Ἰουδαίοις τε καὶ Ἕλλησι τὴν εἰς τὸν Θεὸν μετάνοιαν, καὶ πίστιν τὴν εἰς τὸν Κύριον ἡμῶν Ἰησοῦν Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Καὶ νῦν ἰδού, ἐγὼ δεδεμένος τῷ πνεύματι πορεύομαι εἰς Ἱερουσαλήμ, τὰ ἐν αὐτῇ συναντήσοντά μοι μὴ εἰδώς, ");
INSERT INTO grctr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","πλὴν ὅτι τὸ πνεῦμα τὸ ἅγιον κατὰ πόλιν διαμαρτύρεται λέγον ὅτι δεσμά με καὶ θλίψεις μένουσιν. ");
INSERT INTO grctr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ἀλλ᾿ οὐδενὸς λόγον ποιοῦμαι, οὐδὲ ἔχω τὴν ψυχήν μου τιμίαν ἐμαυτῷ, ὡς τελειῶσαι τὸν δρόμον μου μετὰ χαρᾶς, καὶ τὴν διακονίαν ἣν ἔλαβον παρὰ τοῦ Κυρίου Ἰησοῦ, διαμαρτύρασθαι τὸ εὐαγγέλιον τῆς χάριτος τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Καὶ νῦν ἰδού, ἐγὼ οἶδα ὅτι οὐκέτι ὄψεσθε τὸ πρόσωπόν μου ὑμεῖς πάντες, ἐν οἷς διῆλθον κηρύσσων τὴν βασιλείαν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Διὸ μαρτύρομαι ὑμῖν ἐν τῇ σήμερον ἡμέρᾳ, ὅτι καθαρὸς ἐγὼ ἀπὸ τοῦ αἵματος πάντων. ");
INSERT INTO grctr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Οὐ γὰρ ὑπεστειλάμην τοῦ μὴ ἀναγγεῖλαι ὑμῖν πᾶσαν τὴν βουλὴν τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Προσέχετε οὖν ἑαυτοῖς καὶ παντὶ τῷ ποιμνίῳ, ἐν ᾧ ὑμᾶς τὸ πνεῦμα τὸ ἅγιον ἔθετο ἐπισκόπους, ποιμαίνειν τὴν ἐκκλησίαν τοῦ Θεοῦ, ἣν περιεποιήσατο διὰ τοῦ ἰδίου αἵματος. ");
INSERT INTO grctr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ἐγὼ γὰρ οἶδα τοῦτο, ὅτι εἰσελεύσονται μετὰ τὴν ἄφιξίν μου λύκοι βαρεῖς εἰς ὑμᾶς, μὴ φειδόμενοι τοῦ ποιμνίου· ");
INSERT INTO grctr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","καὶ ἐξ ὑμῶν αὐτῶν ἀναστήσονται ἄνδρες λαλοῦντες διεστραμμένα, τοῦ ἀποσπᾷν τοὺς μαθητὰς ὀπίσω αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Διὸ γρηγορεῖτε, μνημονεύοντες ὅτι τριετίαν νύκτα καὶ ἡμέραν οὐκ ἐπαυσάμην μετὰ δακρύων νουθετῶν ἕνα ἕκαστον. ");
INSERT INTO grctr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Καὶ τὰ νῦν παρατίθεμαι ὑμᾶς, ἀδελφοί, τῷ Θεῷ καὶ τῷ λόγῳ τῆς χάριτος αὐτοῦ, τῷ δυναμένῳ ἐποικοδομῆσαι, καὶ δοῦναι ὑμῖν κληρονομίαν ἐν τοῖς ἡγιασμένοις πᾶσιν. ");
INSERT INTO grctr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ἀργυρίου ἢ χρυσίου ἢ ἱματισμοῦ οὐδενὸς ἐπεθύμησα. ");
INSERT INTO grctr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Αὐτοὶ δὲ γινώσκετε ὅτι ταῖς χρείαις μου καὶ τοῖς οὖσι μετ᾿ ἐμοῦ ὑπηρέτησαν αἱ χεῖρες αὗται. ");
INSERT INTO grctr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Πάντα ὑπέδειξα ὑμῖν, ὅτι οὕτω κοπιῶντας δεῖ ἀντιλαμβάνεσθαι τῶν ἀσθενούντων, μνημονεύειν τε τῶν λόγων τοῦ Κυρίου Ἰησοῦ, ὅτι αὐτὸς εἶπε, Μακάριόν ἐστι διδόναι μᾶλλον ἢ λαμβάνειν. ");
INSERT INTO grctr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Καὶ ταῦτα εἰπών, θεὶς τὰ γόνατα αὐτοῦ, σὺν πᾶσιν αὐτοῖς προσηύξατο. ");
INSERT INTO grctr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ἱκανὸς δὲ ἐγένετο κλαυθμὸς πάντων· καὶ ἐπιπεσόντες ἐπὶ τὸν τράχηλον τοῦ Παύλου κατεφίλουν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ὀδυνώμενοι μάλιστα ἐπὶ τῷ λόγῳ ᾧ εἰρήκει, ὅτι οὐκέτι μέλλουσι τὸ πρόσωπον αὐτοῦ θεωρεῖν. Προέπεμπον δὲ αὐτὸν εἰς τὸ πλοῖον. ");
INSERT INTO grctr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ὡς δὲ ἐγένετο ἀναχθῆναι ἡμᾶς ἀποσπασθέντας ἀπ᾿ αὐτῶν, εὐθυδρομήσαντες ἤλθομεν εἰς τὴν Κῶν, τῇ δὲ ἑξῆς εἰς τὴν Ῥόδον, κἀκεῖθεν εἰς Πάταρα· ");
INSERT INTO grctr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","καὶ εὑρόντες πλοῖον διαπερῶν εἰς Φοινίκην, ἐπιβάντες ἀνήχθημεν. ");
INSERT INTO grctr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ἀναφάναντες δὲ τὴν Κύπρον, καὶ καταλιπόντες αὐτὴν εὐώνυμον, ἐπλέομεν εἰς Συρίαν, καὶ κατήχθημεν εἰς Τύρον· ἐκεῖσε γὰρ ἦν τὸ πλοῖον ἀποφορτιζόμενον τὸν γόμον. ");
INSERT INTO grctr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Καὶ ἀνευρόντες τοὺς μαθητάς, ἐπεμείναμεν αὐτοῦ ἡμέρας ἑπτά· οἵτινες τῷ Παύλῳ ἔλεγον διὰ τοῦ πνεύματος, μὴ ἀναβαίνειν εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ὅτε δὲ ἐγένετο ἡμᾶς ἐξαρτίσαι τὰς ἡμέρας, ἐξελθόντες ἐπορευόμεθα, προπεμπόντων ἡμᾶς πάντων σὺν γυναιξὶ καὶ τέκνοις ἕως ἔξω τῆς πόλεως· καὶ θέντες τὰ γόνατα ἐπὶ τὸν αἰγιαλὸν προσηυξάμεθα. ");
INSERT INTO grctr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Καὶ ἀσπασάμενοι ἀλλήλους, ἐπέβημεν εἰς τὸ πλοῖον, ἐκεῖνοι δὲ ὑπέστρεψαν εἰς τὰ ἴδια. ");
INSERT INTO grctr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ἡμεῖς δέ, τὸν πλοῦν διανύσαντες ἀπὸ Τύρου, κατηντήσαμεν εἰς Πτολεμαΐδα, καὶ ἀσπασάμενοι τοὺς ἀδελφοὺς ἐμείναμεν ἡμέραν μίαν παρ᾿ αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Τῇ δὲ ἐπαύριον ἐξελθόντες οἱ περὶ τὸν Παῦλον ἤλθομεν εἰς Καισάρειαν· καὶ εἰσελθόντες εἰς τὸν οἶκον Φιλίππου τοῦ εὐαγγελιστοῦ, τοῦ ὄντος ἐκ τῶν ἑπτά, ἐμείναμεν παρ᾿ αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Τούτῳ δὲ ἦσαν θυγατέρες παρθένοι τέσσαρες προφητεύουσαι. ");
INSERT INTO grctr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ἐπιμενόντων δὲ ἡμῶν ἡμέρας πλείους, κατῆλθέ τις ἀπὸ τῆς Ἰουδαίας προφήτης ὀνόματι Ἄγαβος. ");
INSERT INTO grctr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Καὶ ἐλθὼν πρὸς ἡμᾶς, καὶ ἄρας τὴν ζώνην τοῦ Παύλου, δήσας τε αὐτοῦ τὰς χεῖρας καὶ τοὺς πόδας εἶπε, Τάδε λέγει τὸ πνεῦμα τὸ ἅγιον, Τὸν ἄνδρα οὗ ἐστιν ἡ ζώνη αὕτη, οὕτω δήσουσιν ἐν Ἱερουσαλὴμ οἱ Ἰουδαῖοι, καὶ παραδώσουσιν εἰς χεῖρας ἐθνῶν. ");
INSERT INTO grctr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ὡς δὲ ἠκούσαμεν ταῦτα, παρεκαλοῦμεν ἡμεῖς τε καὶ οἱ ἐντόπιοι, τοῦ μὴ ἀναβαίνειν αὐτὸν εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ἀπεκρίθη δὲ ὁ Παῦλος, Τί ποιεῖτε κλαίοντες καὶ συνθρύπτοντές μου τὴν καρδίαν; Ἐγὼ γὰρ οὐ μόνον δεθῆναι, ἀλλὰ καὶ ἀποθανεῖν εἰς Ἱερουσαλὴμ ἑτοίμως ἔχω ὑπὲρ τοῦ ὀνόματος τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Μὴ πειθομένου δὲ αὐτοῦ, ἡσυχάσαμεν εἰπόντες, Τὸ θέλημα τοῦ Κυρίου γενέσθω. ");
INSERT INTO grctr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Μετὰ δὲ τὰς ἡμέρας ταύτας ἀποσκευασάμενοι ἀνεβαίνομεν εἰς Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Συνῆλθον δὲ καὶ τῶν μαθητῶν ἀπὸ Καισαρείας σὺν ἡμῖν, ἄγοντες παρ᾿ ᾧ ξενισθῶμεν, Μνάσωνί τινι Κυπρίῳ, ἀρχαίῳ μαθητῇ. ");
INSERT INTO grctr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Γενομένων δὲ ἡμῶν εἰς Ἱεροσόλυμα, ἀσμένως ἐδέξαντο ἡμᾶς οἱ ἀδελφοί. ");
INSERT INTO grctr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Τῇ δὲ ἐπιούσῃ εἰσῄει ὁ Παῦλος σὺν ἡμῖν πρὸς Ἰάκωβον, πάντες τε παρεγένοντο οἱ πρεσβύτεροι. ");
INSERT INTO grctr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Καὶ ἀσπασάμενος αὐτούς, ἐξηγεῖτο καθ᾿ ἓν ἕκαστον ὧν ἐποίησεν ὁ Θεὸς ἐν τοῖς ἔθνεσι διὰ τῆς διακονίας αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Οἱ δὲ ἀκούσαντες ἐδόξαζον τὸν Κύριον, εἶπόν τε αὐτῷ, Θεωρεῖς, ἀδελφέ, πόσαι μυριάδες εἰσὶν Ἰουδαίων τῶν πεπιστευκότων· καὶ πάντες ζηλωταὶ τοῦ νόμου ὑπάρχουσι· ");
INSERT INTO grctr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","κατηχήθησαν δὲ περὶ σοῦ, ὅτι ἀποστασίαν διδάσκεις ἀπὸ Μωσέως τοὺς κατὰ τὰ ἔθνη πάντας Ἰουδαίους, λέγων μὴ περιτέμνειν αὐτοὺς τὰ τέκνα, μηδὲ τοῖς ἔθεσι περιπατεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Τί οὖν ἐστι; Πάντως δεῖ πλῆθος συνελθεῖν· ἀκούσονται γὰρ ὅτι ἐλήλυθας. ");
INSERT INTO grctr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Τοῦτο οὖν ποίησον ὅ σοι λέγομεν· εἰσὶν ἡμῖν ἄνδρες τέσσαρες εὐχὴν ἔχοντες ἐφ᾿ ἑαυτῶν· ");
INSERT INTO grctr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","τούτους παραλαβὼν ἁγνίσθητι σὺν αὐτοῖς, καὶ δαπάνησον ἐπ᾿ αὐτοῖς, ἵνα ξυρήσωνται τὴν κεφαλήν, καὶ γνῶσι πάντες ὅτι ὧν κατήχηνται περὶ σοῦ οὐδέν ἐστιν, ἀλλὰ στοιχεῖς καὶ αὐτὸς τὸν νόμον φυλάσσων. ");
INSERT INTO grctr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Περὶ δὲ τῶν πεπιστευκότων ἐθνῶν ἡμεῖς ἐπεστείλαμεν, κρίναντες μηδὲν τοιοῦτον τηρεῖν αὐτούς, εἰ μὴ φυλάσσεσθαι αὐτοὺς τό τε εἰδωλόθυτον καὶ τὸ αἷμα καὶ πνικτὸν καὶ πορνείαν. ");
INSERT INTO grctr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Τότε ὁ Παῦλος παραλαβὼν τοὺς ἄνδρας, τῇ ἐχομένῃ ἡμέρᾳ σὺν αὐτοῖς ἁγνισθεὶς εἰσῄει εἰς τὸ ἱερόν, διαγγέλλων τὴν ἐκπλήρωσιν τῶν ἡμερῶν τοῦ ἁγνισμοῦ, ἕως οὗ προσηνέχθη ὑπὲρ ἑνὸς ἑκάστου αὐτῶν ἡ προσφορά. ");
INSERT INTO grctr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ὡς δὲ ἔμελλον αἱ ἑπτὰ ἡμέραι συντελεῖσθαι, οἱ ἀπὸ τῆς Ἀσίας Ἰουδαῖοι, θεασάμενοι αὐτὸν ἐν τῷ ἱερῷ, συνέχεον πάντα τὸν ὄχλον, καὶ ἐπέβαλον τὰς χεῖρας ἐπ᾿ αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","κράζοντες, Ἄνδρες Ἰσραηλῖται, βοηθεῖτε. Οὗτός ἐστιν ὁ ἄνθρωπος ὁ κατὰ τοῦ λαοῦ καὶ τοῦ νόμου καὶ τοῦ τόπου τούτου πάντας πανταχοῦ διδάσκων· ἔτι τε καὶ Ἕλληνας εἰσήγαγεν εἰς τὸ ἱερόν, καὶ κεκοίνωκε τὸν ἅγιον τόπον τοῦτον. ");
INSERT INTO grctr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ἦσαν γὰρ προεωρακότες Τρόφιμον τὸν Ἐφέσιον ἐν τῇ πόλει σὺν αὐτῷ, ὃν ἐνόμιζον ὅτι εἰς τὸ ἱερὸν εἰσήγαγεν ὁ Παῦλος. ");
INSERT INTO grctr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ἐκινήθη τε ἡ πόλις ὅλη, καὶ ἐγένετο συνδρομὴ τοῦ λαοῦ· καὶ ἐπιλαβόμενοι τοῦ Παύλου εἷλκον αὐτὸν ἔξω τοῦ ἱεροῦ· καὶ εὐθέως ἐκλείσθησαν αἱ θύραι. ");
INSERT INTO grctr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ζητούντων δὲ αὐτὸν ἀποκτεῖναι, ἀνέβη φάσις τῷ χιλιάρχῳ τῆς σπείρης, ὅτι ὅλη συγκέχυται Ἱερουσαλήμ· ");
INSERT INTO grctr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ὃς ἐξαυτῆς παραλαβὼν στρατιώτας καὶ ἑκατοντάρχους, κατέδραμεν ἐπ᾿ αὐτούς· οἱ δέ, ἰδόντες τὸν χιλίαρχον καὶ τοὺς στρατιώτας, ἐπαύσαντο τύπτοντες τὸν Παῦλον. ");
INSERT INTO grctr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Τότε ἐγγίσας ὁ χιλίαρχος ἐπελάβετο αὐτοῦ, καὶ ἐκέλευσε δεθῆναι ἁλύσεσι δυσί· καὶ ἐπυνθάνετο τίς ἂν εἴη, καὶ τί ἐστι πεποιηκώς. ");
INSERT INTO grctr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ἄλλοι δὲ ἄλλο τι ἐβόων ἐν τῷ ὄχλῳ· μὴ δυνάμενος δὲ γνῶναι τὸ ἀσφαλὲς διὰ τὸν θόρυβον, ἐκέλευσεν ἄγεσθαι αὐτὸν εἰς τὴν παρεμβολήν. ");
INSERT INTO grctr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ὅτε δὲ ἐγένετο ἐπὶ τοὺς ἀναβαθμούς, συνέβη βαστάζεσθαι αὐτὸν ὑπὸ τῶν στρατιωτῶν διὰ τὴν βίαν τοῦ ὄχλου. ");
INSERT INTO grctr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ἠκολούθει γὰρ τὸ πλῆθος τοῦ λαοῦ κρᾶζον, Αἶρε αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Μέλλων τε εἰσάγεσθαι εἰς τὴν παρεμβολὴν ὁ Παῦλος λέγει τῷ χιλιάρχῳ, Εἰ ἔξεστί μοι εἰπεῖν τι πρός σε; Ὁ δὲ ἔφη, Ἑλληνιστὶ γινώσκεις; ");
INSERT INTO grctr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Οὐκ ἄρα σὺ εἶ ὁ Αἰγύπτιος ὁ πρὸ τούτων τῶν ἡμερῶν ἀναστατώσας καὶ ἐξαγαγὼν εἰς τὴν ἔρημον τοὺς τετρακισχιλίους ἄνδρας τῶν σικαρίων; ");
INSERT INTO grctr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Εἶπε δὲ ὁ Παῦλος, Ἐγὼ ἄνθρωπος μέν εἰμι Ἰουδαῖος, Ταρσεὺς τῆς Κιλικίας, οὐκ ἀσήμου πόλεως πολίτης· δέομαι δέ σου, ἐπίτρεψόν μοι λαλῆσαι πρὸς τὸν λαόν. ");
INSERT INTO grctr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ἐπιτρέψαντος δὲ αὐτοῦ, ὁ Παῦλος ἑστὼς ἐπὶ τῶν ἀναβαθμῶν κατέσεισε τῇ χειρὶ τῷ λαῷ· πολλῆς δὲ σιγῆς γενομένης, προσεφώνησε τῇ Ἑβραΐδι διαλέκτῳ λέγων, ");
INSERT INTO grctr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ἄνδρες ἀδελφοὶ καὶ πατέρες, ἀκούσατέ μου τῆς πρὸς ὑμᾶς νῦν ἀπολογίας. ");
INSERT INTO grctr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ἀκούσαντες δὲ ὅτι τῇ Ἑβραΐδι διαλέκτῳ προσεφώνει αὐτοῖς, μᾶλλον παρέσχον ἡσυχίαν. Καί φησιν, ");
INSERT INTO grctr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ἐγὼ μέν εἰμι ἀνὴρ Ἰουδαῖος, γεγεννημένος ἐν Ταρσῷ τῆς Κιλικίας, ἀνατεθραμμένος δὲ ἐν τῇ πόλει ταύτῃ παρὰ τοὺς πόδας Γαμαλιήλ, πεπαιδευμένος κατὰ ἀκρίβειαν τοῦ πατρῴου νόμου, ζηλωτὴς ὑπάρχων τοῦ Θεοῦ, καθὼς πάντες ὑμεῖς ἐστε σήμερον· ");
INSERT INTO grctr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ὃς ταύτην τὴν ὁδὸν ἐδίωξα ἄχρι θανάτου, δεσμεύων καὶ παραδιδοὺς εἰς φυλακὰς ἄνδρας τε καὶ γυναῖκας. ");
INSERT INTO grctr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ὡς καὶ ὁ ἀρχιερεὺς μαρτυρεῖ μοι, καὶ πᾶν τὸ πρεσβυτέριον· παρ᾿ ὧν καὶ ἐπιστολὰς δεξάμενος πρὸς τοὺς ἀδελφούς, εἰς Δαμασκὸν ἐπορευόμην, ἄξων καὶ τοὺς ἐκεῖσε ὄντας δεδεμένους εἰς Ἱερουσαλήμ, ἵνα τιμωρηθῶσιν. ");
INSERT INTO grctr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ἐγένετο δέ μοι πορευομένῳ καὶ ἐγγίζοντι τῇ Δαμασκῷ, περὶ μεσημβρίαν, ἐξαίφνης ἐκ τοῦ οὐρανοῦ περιαστράψαι φῶς ἱκανὸν περὶ ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ἔπεσόν τε εἰς τὸ ἔδαφος, καὶ ἤκουσα φωνῆς λεγούσης μοι, Σαούλ, Σαούλ, τί με διώκεις; ");
INSERT INTO grctr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ἐγὼ δὲ ἀπεκρίθην, Τίς εἶ, Κύριε; Εἶπέ τε πρός με, Ἐγώ εἰμι Ἰησοῦς ὁ Ναζωραῖος ὃν σὺ διώκεις. ");
INSERT INTO grctr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Οἱ δὲ σὺν ἐμοὶ ὄντες τὸ μὲν φῶς ἐθεάσαντο, καὶ ἔμφοβοι ἐγένοντο· τὴν δὲ φωνὴν οὐκ ἤκουσαν τοῦ λαλοῦντός μοι. ");
INSERT INTO grctr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Εἶπον δέ, Τί ποιήσω, Κύριε; Ὁ δὲ Κύριος εἶπε πρός με, Ἀναστὰς πορεύου εἰς Δαμασκόν· κἀκεῖ σοι λαληθήσεται περὶ πάντων ὧν τέτακταί σοι ποιῆσαι. ");
INSERT INTO grctr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ὡς δὲ οὐκ ἐνέβλεπον ἀπὸ τῆς δόξης τοῦ φωτὸς ἐκείνου, χειραγωγούμενος ὑπὸ τῶν συνόντων μοι, ἦλθον εἰς Δαμασκόν. ");
INSERT INTO grctr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ἀνανίας δέ τις, ἀνὴρ εὐσεβὴς κατὰ τὸν νόμον, μαρτυρούμενος ὑπὸ πάντων τῶν κατοικούντων Ἰουδαίων, ");
INSERT INTO grctr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ἐλθὼν πρός με καὶ ἐπιστὰς εἶπέ μοι, Σαοὺλ ἀδελφέ, ἀνάβλεψον. Κἀγὼ αὐτῇ τῇ ὥρᾳ ἀνέβλεψα εἰς αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ὁ δὲ εἶπεν, Ὁ Θεὸς τῶν πατέρων ἡμῶν προεχειρίσατό σε γνῶναι τὸ θέλημα αὐτοῦ, καὶ ἰδεῖν τὸν δίκαιον, καὶ ἀκοῦσαι φωνὴν ἐκ τοῦ στόματος αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ὅτι ἔσῃ μάρτυς αὐτῷ πρὸς πάντας ἀνθρώπους ὧν ἑώρακας καὶ ἤκουσας. ");
INSERT INTO grctr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Καὶ νῦν τί μέλλεις; Ἀναστὰς βάπτισαι καὶ ἀπόλουσαι τὰς ἁμαρτίας σου, ἐπικαλεσάμενος τὸ ὄνομα τοῦ Κυρίου. ");
INSERT INTO grctr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ἐγένετο δέ μοι ὑποστρέψαντι εἰς Ἱερουσαλήμ, καὶ προσευχομένου μου ἐν τῷ ἱερῷ, γενέσθαι με ἐν ἐκστάσει, ");
INSERT INTO grctr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","καὶ ἰδεῖν αὐτὸν λέγοντά μοι, Σπεῦσον καὶ ἔξελθε ἐν τάχει ἐξ Ἱερουσαλήμ· διότι οὐ παραδέξονταί σου τὴν μαρτυρίαν περὶ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Κἀγὼ εἶπον, Κύριε, αὐτοὶ ἐπίστανται ὅτι ἐγὼ ἤμην φυλακίζων καὶ δέρων κατὰ τὰς συναγωγὰς τοὺς πιστεύοντας ἐπὶ σέ· ");
INSERT INTO grctr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","καὶ ὅτε ἐξεχεῖτο τὸ αἷμα Στεφάνου τοῦ μάρτυρός σου, καὶ αὐτὸς ἤμην ἐφεστὼς καὶ συνευδοκῶν τῇ ἀναιρέσει αὐτοῦ, καὶ φυλάσσων τὰ ἱμάτια τῶν ἀναιρούντων αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Καὶ εἶπε πρός με, Πορεύου, ὅτι ἐγὼ εἰς ἔθνη μακρὰν ἐξαποστελῶ σε. ");
INSERT INTO grctr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ἤκουον δὲ αὐτοῦ ἄχρι τούτου τοῦ λόγου, καὶ ἐπῆραν τὴν φωνὴν αὐτῶν λέγοντες, Αἶρε ἀπὸ τῆς γῆς τὸν τοιοῦτον· οὐ γὰρ καθῆκον αὐτὸν ζῇν. ");
INSERT INTO grctr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Κραυγαζόντων δὲ αὐτῶν, καὶ ῥιπτούντων τὰ ἱμάτια, καὶ κονιορτὸν βαλλόντων εἰς τὸν ἀέρα, ");
INSERT INTO grctr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ἐκέλευσεν αὐτὸν ὁ χιλίαρχος ἄγεσθαι εἰς τὴν παρεμβολήν, εἰπὼν μάστιξιν ἀνετάζεσθαι αὐτόν, ἵνα ἐπιγνῷ δι᾿ ἣν αἰτίαν οὕτως ἐπεφώνουν αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ὡς δὲ προέτεινεν αὐτὸν τοῖς ἱμᾶσιν, εἶπε πρὸς τὸν ἑστῶτα ἑκατόνταρχον ὁ Παῦλος, Εἰ ἄνθρωπον Ῥωμαῖον καὶ ἀκατάκριτον ἔξεστιν ὑμῖν μαστίζειν; ");
INSERT INTO grctr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ἀκούσας δὲ ὁ ἑκατόνταρχος, προσελθὼν ἀπήγγειλε τῷ χιλιάρχῳ λέγων, Ὅρα τί μέλλεις ποιεῖν· ὁ γὰρ ἄνθρωπος οὗτος Ῥωμαῖός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Προσελθὼν δὲ ὁ χιλίαρχος εἶπεν αὐτῷ, Λέγε μοι, εἰ σὺ Ῥωμαῖος εἶ; Ὁ δὲ ἔφη, Ναί. ");
INSERT INTO grctr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ἀπεκρίθη τε ὁ χιλίαρχος, Ἐγὼ πολλοῦ κεφαλαίου τὴν πολιτείαν ταύτην ἐκτησάμην. Ὁ δὲ Παῦλος ἔφη, Ἐγὼ δὲ καὶ γεγέννημαι. ");
INSERT INTO grctr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Εὐθέως οὖν ἀπέστησαν ἀπ᾿ αὐτοῦ οἱ μέλλοντες αὐτὸν ἀνετάζειν. Καὶ ὁ χιλίαρχος δὲ ἐφοβήθη, ἐπιγνοὺς ὅτι Ῥωμαῖός ἐστι, καὶ ὅτι ἦν αὐτὸν δεδεκώς. ");
INSERT INTO grctr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Τῇ δὲ ἐπαύριον βουλόμενος γνῶναι τὸ ἀσφαλές, τὸ τί κατηγορεῖται παρὰ τῶν Ἰουδαίων, ἔλυσεν αὐτὸν ἀπὸ τῶν δεσμῶν, καὶ ἐκέλευσεν ἐλθεῖν τοὺς ἀρχιερεῖς καὶ ὅλον τὸ συνέδριον αὐτῶν, καὶ καταγαγὼν τὸν Παῦλον ἔστησεν εἰς αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ἀτενίσας δὲ ὁ Παῦλος τῷ συνεδρίῳ εἶπεν, Ἄνδρες ἀδελφοί, ἐγὼ πάσῃ συνειδήσει ἀγαθῇ πεπολίτευμαι τῷ Θεῷ ἄχρι ταύτης τῆς ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ὁ δὲ ἀρχιερεὺς Ἀνανίας ἐπέταξε τοῖς παρεστῶσιν αὐτῷ τύπτειν αὐτοῦ τὸ στόμα. ");
INSERT INTO grctr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Τότε ὁ Παῦλος πρὸς αὐτὸν εἶπε, Τύπτειν σε μέλλει ὁ Θεός, τοῖχε κεκονιαμένε· καὶ σὺ κάθῃ κρίνων με κατὰ τὸν νόμον, καὶ παρανομῶν κελεύεις με τύπτεσθαι; ");
INSERT INTO grctr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Οἱ δὲ παρεστῶτες εἶπον, Τὸν ἀρχιερέα τοῦ Θεοῦ λοιδορεῖς; ");
INSERT INTO grctr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ἔφη τε ὁ Παῦλος, Οὐκ ᾔδειν, ἀδελφοί, ὅτι ἐστὶν ἀρχιερεύς· γέγραπται γάρ, Ἄρχοντα τοῦ λαοῦ σου οὐκ ἐρεῖς κακῶς. ");
INSERT INTO grctr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Γνοὺς δὲ ὁ Παῦλος ὅτι τὸ ἓν μέρος ἐστὶ Σαδδουκαίων, τὸ δὲ ἕτερον Φαρισαίων, ἔκραξεν ἐν τῷ συνεδρίῳ, Ἄνδρες ἀδελφοί, ἐγὼ Φαρισαῖός εἰμι, υἱὸς Φαρισαίου· περὶ ἐλπίδος καὶ ἀναστάσεως νεκρῶν ἐγὼ κρίνομαι. ");
INSERT INTO grctr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Τοῦτο δὲ αὐτοῦ λαλήσαντος, ἐγένετο στάσις τῶν Φαρισαίων καὶ τῶν Σαδδουκαίων, καὶ ἐσχίσθη τὸ πλῆθος. ");
INSERT INTO grctr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Σαδδουκαῖοι μὲν γὰρ λέγουσι μὴ εἶναι ἀνάστασιν, μηδὲ ἄγγελον, μήτε πνεῦμα· Φαρισαῖοι δὲ ὁμολογοῦσι τὰ ἀμφότερα. ");
INSERT INTO grctr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ἐγένετο δὲ κραυγὴ μεγάλη· καὶ ἀναστάντες οἱ γραμματεῖς τοῦ μέρους τῶν Φαρισαίων διεμάχοντο λέγοντες, Οὐδὲν κακὸν εὑρίσκομεν ἐν τῷ ἀνθρώπῳ τούτῳ· εἰ δὲ πνεῦμα ἐλάλησεν αὐτῷ ἢ ἄγγελος, μὴ θεομαχῶμεν. ");
INSERT INTO grctr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Πολλῆς δὲ γενομένης στάσεως, εὐλαβηθεὶς ὁ χιλίαρχος μὴ διασπασθῇ ὁ Παῦλος ὑπ᾿ αὐτῶν, ἐκέλευσε τὸ στράτευμα καταβὰν ἁρπάσαι αὐτὸν ἐκ μέσου αὐτῶν, ἄγειν τε εἰς τὴν παρεμβολήν. ");
INSERT INTO grctr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Τῇ δὲ ἐπιούσῃ νυκτὶ ἐπιστὰς αὐτῷ ὁ Κύριος εἶπε, Θάρσει Παῦλε· ὡς γὰρ διεμαρτύρω τὰ περὶ ἐμοῦ εἰς Ἱερουσαλήμ, οὕτω σε δεῖ καὶ εἰς Ῥώμην μαρτυρῆσαι. ");
INSERT INTO grctr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Γενομένης δὲ ἡμέρας, ποιήσαντές τινες τῶν Ἰουδαίων συστροφήν, ἀνεθεμάτισαν ἑαυτούς, λέγοντες μήτε φαγεῖν μήτε πιεῖν ἕως οὗ ἀποκτείνωσι τὸν Παῦλον. ");
INSERT INTO grctr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ἦσαν δὲ πλείους τεσσαράκοντα οἱ ταύτην τὴν συνωμοσίαν πεποιηκότες· ");
INSERT INTO grctr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","οἵτινες προσελθόντες τοῖς ἀρχιερεῦσι καὶ τοῖς πρεσβυτέροις εἶπον, Ἀναθέματι ἀνεθεματίσαμεν ἑαυτούς, μηδενὸς γεύσασθαι ἕως οὗ ἀποκτείνωμεν τὸν Παῦλον. ");
INSERT INTO grctr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Νῦν οὖν ὑμεῖς ἐμφανίσατε τῷ χιλιάρχῳ σὺν τῷ συνεδρίῳ, ὅπως αὔριον αὐτὸν καταγάγῃ πρὸς ὑμᾶς, ὡς μέλλοντας διαγινώσκειν ἀκριβέστερον τὰ περὶ αὐτοῦ· ἡμεῖς δέ, πρὸ τοῦ ἐγγίσαι αὐτόν, ἕτοιμοί ἐσμεν τοῦ ἀνελεῖν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ἀκούσας δὲ ὁ υἱὸς τῆς ἀδελφῆς Παύλου τὴν ἐνέδραν, παραγενόμενος καὶ εἰσελθὼν εἰς τὴν παρεμβολήν, ἀπήγγειλε τῷ Παύλῳ. ");
INSERT INTO grctr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Προσκαλεσάμενος δὲ ὁ Παῦλος ἕνα τῶν ἑκατοντάρχων ἔφη, Τὸν νεανίαν τοῦτον ἀπάγαγε πρὸς τὸν χιλίαρχον· ἔχει γάρ τι ἀπαγγεῖλαι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ὁ μὲν οὖν παραλαβὼν αὐτὸν ἤγαγε πρὸς τὸν χιλίαρχον, καί φησιν, Ὁ δέσμιος Παῦλος προσκαλεσάμενός με ἠρώτησε τοῦτον τὸν νεανίαν ἀγαγεῖν πρός σε, ἔχοντά τι λαλῆσαί σοι. ");
INSERT INTO grctr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ἐπιλαβόμενος δὲ τῆς χειρὸς αὐτοῦ ὁ χιλίαρχος, καὶ ἀναχωρήσας κατ᾿ ἰδίαν ἐπυνθάνετο, Τί ἐστιν ὃ ἔχεις ἀπαγγεῖλαί μοι; ");
INSERT INTO grctr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Εἶπε δὲ ὅτι Οἱ Ἰουδαῖοι συνέθεντο τοῦ ἐρωτῆσαί σε, ὅπως αὔριον εἰς τὸ συνέδριον καταγάγῃς τὸν Παῦλον, ὡς μέλλοντές τι ἀκριβέστερον πυνθάνεσθαι περὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Σὺ οὖν μὴ πεισθῇς αὐτοῖς· ἐνεδρεύουσι γὰρ αὐτὸν ἐξ αὐτῶν ἄνδρες πλείους τεσσαράκοντα, οἵτινες ἀνεθεμάτισαν ἑαυτοὺς μήτε φαγεῖν μήτε πιεῖν ἕως οὗ ἀνέλωσιν αὐτόν· καὶ νῦν ἕτοιμοί εἰσι προσδεχόμενοι τὴν ἀπὸ σοῦ ἐπαγγελίαν. ");
INSERT INTO grctr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ὁ μὲν οὖν χιλίαρχος ἀπέλυσε τὸν νεανίαν, παραγγείλας Μηδενὶ ἐκλαλῆσαι ὅτι ταῦτα ἐνεφάνισας πρός με. ");
INSERT INTO grctr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Καὶ προσκαλεσάμενος δύο τινὰς τῶν ἑκατοντάρχων εἶπεν, Ἑτοιμάσατε στρατιώτας διακοσίους ὅπως πορευθῶσιν ἕως Καισαρείας, καὶ ἱππεῖς ἑβδομήκοντα, καὶ δεξιολάβους διακοσίους, ἀπὸ τρίτης ὥρας τῆς νυκτός· ");
INSERT INTO grctr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","κτήνη τε παραστῆσαι, ἵνα ἐπιβιβάσαντες τὸν Παῦλον διασώσωσι πρὸς Φήλικα τὸν ἡγεμόνα· ");
INSERT INTO grctr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","γράψας ἐπιστολὴν περιέχουσαν τὸν τύπον τοῦτον· ");
INSERT INTO grctr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Κλαύδιος Λυσίας τῷ κρατίστῳ ἡγεμόνι Φήλικι χαίρειν. ");
INSERT INTO grctr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Τὸν ἄνδρα τοῦτον συλληφθέντα ὑπὸ τῶν Ἰουδαίων, καὶ μέλλοντα ἀναιρεῖσθαι ὑπ᾿ αὐτῶν, ἐπιστὰς σὺν τῷ στρατεύματι ἐξειλόμην αὐτόν, μαθὼν ὅτι Ῥωμαῖός ἐστι. ");
INSERT INTO grctr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Βουλόμενος δὲ γνῶναι τὴν αἰτίαν δι᾿ ἣν ἐνεκάλουν αὐτῷ, κατήγαγον αὐτὸν εἰς τὸ συνέδριον αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ὃν εὗρον ἐγκαλούμενον περὶ ζητημάτων τοῦ νόμου αὐτῶν, μηδὲν δὲ ἄξιον θανάτου ἢ δεσμῶν ἔγκλημα ἔχοντα. ");
INSERT INTO grctr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Μηνυθείσης δέ μοι ἐπιβουλῆς εἰς τὸν ἄνδρα μέλλειν ἔσεσθαι ὑπὸ τῶν Ἰουδαίων, ἐξαυτῆς ἔπεμψα πρός σε, παραγγείλας καὶ τοῖς κατηγόροις λέγειν τὰ πρὸς αὐτὸν ἐπὶ σοῦ. Ἔρρωσο. ");
INSERT INTO grctr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Οἱ μὲν οὖν στρατιῶται, κατὰ τὸ διατεταγμένον αὐτοῖς, ἀναλαβόντες τὸν Παῦλον, ἤγαγον διὰ τῆς νυκτὸς εἰς τὴν Ἀντιπατρίδα. ");
INSERT INTO grctr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Τῇ δὲ ἐπαύριον ἐάσαντες τοὺς ἱππεῖς πορεύεσθαι σὺν αὐτῷ, ὑπέστρεψαν εἰς τὴν παρεμβολήν· ");
INSERT INTO grctr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","οἵτινες εἰσελθόντες εἰς τὴν Καισάρειαν, καὶ ἀναδόντες τὴν ἐπιστολὴν τῷ ἡγεμόνι, παρέστησαν καὶ τὸν Παῦλον αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ἀναγνοὺς δὲ ὁ ἡγεμών, καὶ ἐπερωτήσας ἐκ ποίας ἐπαρχίας ἐστί, καὶ πυθόμενος ὅτι ἀπὸ Κιλικίας, ");
INSERT INTO grctr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Διακούσομαί σου, ἔφη, ὅταν καὶ οἱ κατήγοροί σου παραγένωνται. Ἐκέλευσέ τε αὐτὸν ἐν τῷ πραιτωρίῳ τοῦ Ἡρῴδου φυλάσσεσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Μετὰ δὲ πέντε ἡμέρας κατέβη ὁ ἀρχιερεὺς Ἀνανίας μετὰ τῶν πρεσβυτέρων καὶ ῥήτορος Τερτύλλου τινός, οἵτινες ἐνεφάνισαν τῷ ἡγεμόνι κατὰ τοῦ Παύλου. ");
INSERT INTO grctr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Κληθέντος δὲ αὐτοῦ, ἤρξατο κατηγορεῖν ὁ Τέρτυλλος λέγων, Πολλῆς εἰρήνης τυγχάνοντες διὰ σοῦ, καὶ κατορθωμάτων γινομένων τῷ ἔθνει τούτῳ διὰ τῆς σῆς προνοίας, ");
INSERT INTO grctr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","πάντῃ τε καὶ πανταχοῦ ἀποδεχόμεθα, κράτιστε Φῆλιξ, μετὰ πάσης εὐχαριστίας. ");
INSERT INTO grctr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ἵνα δὲ μὴ ἐπὶ πλεῖόν σε ἐγκόπτω, παρακαλῶ ἀκοῦσαί σε ἡμῶν συντόμως τῇ σῇ ἐπιεικείᾳ. ");
INSERT INTO grctr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Εὑρόντες γὰρ τὸν ἄνδρα τοῦτον λοιμόν, καὶ κινοῦντα στάσιν πᾶσι τοῖς Ἰουδαίοις τοῖς κατὰ τὴν οἰκουμένην, πρωτοστάτην τε τῆς τῶν Ναζωραίων αἱρέσεως· ");
INSERT INTO grctr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ὃς καὶ τὸ ἱερὸν ἐπείρασε βεβηλῶσαι· ὃν καὶ ἐκρατήσαμεν καὶ κατὰ τὸν ἡμέτερον νόμον ἠθελήσαμεν κρίνειν. ");
INSERT INTO grctr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Παρελθὼν δὲ Λυσίας ὁ χιλίαρχος μετὰ πολλῆς βίας ἐκ τῶν χειρῶν ἡμῶν ἀπήγαγε, ");
INSERT INTO grctr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","κελεύσας τοὺς κατηγόρους αὐτοῦ ἔρχεσθαι ἐπὶ σέ· παρ᾿ οὗ δυνήσῃ, αὐτὸς ἀνακρίνας, περὶ πάντων τούτων ἐπιγνῶναι ὧν ἡμεῖς κατηγοροῦμεν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Συνέθεντο δὲ καὶ οἱ Ἰουδαῖοι, φάσκοντες ταῦτα οὕτως ἔχειν. ");
INSERT INTO grctr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ἀπεκρίθη δὲ ὁ Παῦλος, νεύσαντος αὐτῷ τοῦ ἡγεμόνος λέγειν, Ἐκ πολλῶν ἐτῶν ὄντα σε κριτὴν τῷ ἔθνει τούτῳ ἐπιστάμενος, εὐθυμότερον τὰ περὶ ἐμαυτοῦ ἀπολογοῦμαι, ");
INSERT INTO grctr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","δυναμένου σου γνῶναι ὅτι οὐ πλείους εἰσί μοι ἡμέραι ἢ δεκαδύο, ἀφ᾿ ἧς ἀνέβην προσκυνήσων ἐν Ἱερουσαλήμ· ");
INSERT INTO grctr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","καὶ οὔτε ἐν τῷ ἱερῷ εὗρόν με πρός τινα διαλεγόμενον ἢ ἐπισύστασιν ποιοῦντα ὄχλου, οὔτε ἐν ταῖς συναγωγαῖς, οὔτε κατὰ τὴν πόλιν. ");
INSERT INTO grctr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Οὔτε παραστῆσαί με δύνανται περὶ ὧν νῦν κατηγοροῦσί μου. ");
INSERT INTO grctr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ὁμολογῶ δὲ τοῦτό σοι, ὅτι κατὰ τὴν ὁδὸν ἣν λέγουσιν αἵρεσιν, οὕτω λατρεύω τῷ πατρῴῳ Θεῷ, πιστεύων πᾶσι τοῖς κατὰ τὸν νόμον καὶ τοῖς προφήταις γεγραμμένοις· ");
INSERT INTO grctr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ἐλπίδα ἔχων εἰς τὸν Θεόν, ἣν καὶ αὐτοὶ οὗτοι προσδέχονται, ἀνάστασιν μέλλειν ἔσεσθαι νεκρῶν, δικαίων τε καὶ ἀδίκων. ");
INSERT INTO grctr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ἐν τούτῳ δὲ αὐτὸς ἀσκῶ, ἀπρόσκοπον συνείδησιν ἔχειν πρὸς τὸν Θεὸν καὶ τοὺς ἀνθρώπους διὰ παντός. ");
INSERT INTO grctr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Δι᾿ ἐτῶν δὲ πλειόνων παρεγενόμην ἐλεημοσύνας ποιήσων εἰς τὸ ἔθνος μου καὶ προσφοράς· ");
INSERT INTO grctr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ἐν οἷς εὗρόν με ἡγνισμένον ἐν τῷ ἱερῷ, οὐ μετὰ ὄχλου οὐδὲ μετὰ θορύβου, τινὲς ἀπὸ τῆς Ἀσίας Ἰουδαῖοι· ");
INSERT INTO grctr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","οὓς ἔδει ἐπὶ σοῦ παρεῖναι καὶ κατηγορεῖν εἴ τι ἔχοιεν πρός με. ");
INSERT INTO grctr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ἢ αὐτοὶ οὗτοι εἰπάτωσαν, εἴ τι εὗρον ἐν ἐμοὶ ἀδίκημα, στάντος μου ἐπὶ τοῦ συνεδρίου, ");
INSERT INTO grctr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ἢ περὶ μιᾶς ταύτης φωνῆς, ἧς ἔκραξα ἑστὼς ἐν αὐτοῖς, ὅτι Περὶ ἀναστάσεως νεκρῶν ἐγὼ κρίνομαι σήμερον ὑφ᾿ ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ἀκούσας δὲ ταῦτα ὁ Φῆλιξ ἀνεβάλετο αὐτούς, ἀκριβέστερον εἰδὼς τὰ περὶ τῆς ὁδοῦ, εἰπών, Ὅταν Λυσίας ὁ χιλίαρχος καταβῇ, διαγνώσομαι τὰ καθ᾿ ὑμᾶς· ");
INSERT INTO grctr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","διαταξάμενός τε τῷ ἑκατοντάρχῃ τηρεῖσθαι τὸν Παῦλον, ἔχειν τε ἄνεσιν, καὶ μηδένα κωλύειν τῶν ἰδίων αὐτοῦ ὑπηρετεῖν ἢ προσέρχεσθαι αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Μετὰ δὲ ἡμέρας τινάς, παραγενόμενος ὁ Φῆλιξ σὺν Δρουσίλλῃ τῇ γυναικὶ αὐτοῦ οὔσῃ Ἰουδαίᾳ, μετεπέμψατο τὸν Παῦλον, καὶ ἤκουσεν αὐτοῦ περὶ τῆς εἰς Χριστὸν πίστεως. ");
INSERT INTO grctr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Διαλεγομένου δὲ αὐτοῦ περὶ δικαιοσύνης καὶ ἐγκρατείας καὶ τοῦ κρίματος τοῦ μέλλοντος ἔσεσθαι, ἔμφοβος γενόμενος ὁ Φῆλιξ ἀπεκρίθη, Τὸ νῦν ἔχον πορεύου· καιρὸν δὲ μεταλαβὼν μετακαλέσομαί σε· ");
INSERT INTO grctr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ἅμα δὲ καὶ ἐλπίζων ὅτι χρήματα δοθήσεται αὐτῷ ὑπὸ τοῦ Παύλου, ὅπως λύσῃ αὐτόν· διὸ καὶ πυκνότερον αὐτὸν μεταπεμπόμενος ὡμίλει αὐτῷ. ");
INSERT INTO grctr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Διετίας δὲ πληρωθείσης, ἔλαβε διάδοχον ὁ Φῆλιξ Πόρκιον Φῆστον· θέλων τε χάριτας καταθέσθαι τοῖς Ἰουδαίοις ὁ Φῆλιξ κατέλιπε τὸν Παῦλον δεδεμένον. ");
INSERT INTO grctr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Φῆστος οὖν ἐπιβὰς τῇ ἐπαρχίᾳ, μετὰ τρεῖς ἡμέρας ἀνέβη εἰς Ἱεροσόλυμα ἀπὸ Καισαρείας. ");
INSERT INTO grctr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ἐνεφάνισαν δὲ αὐτῷ ὁ ἀρχιερεὺς καὶ οἱ πρῶτοι τῶν Ἰουδαίων κατὰ τοῦ Παύλου, καὶ παρεκάλουν αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","αἰτούμενοι χάριν κατ᾿ αὐτοῦ, ὅπως μεταπέμψηται αὐτὸν εἰς Ἱερουσαλήμ, ἐνέδραν ποιοῦντες ἀνελεῖν αὐτὸν κατὰ τὴν ὁδόν. ");
INSERT INTO grctr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ὁ μὲν οὖν Φῆστος ἀπεκρίθη, τηρεῖσθαι τὸν Παῦλον ἐν Καισαρείᾳ, ἑαυτὸν δὲ μέλλειν ἐν τάχει ἐκπορεύεσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Οἱ οὖν δυνατοὶ ἐν ὑμῖν, φησί, συγκαταβάντες, εἴ τι ἐστὶν ἐν τῷ ἀνδρὶ τούτῳ, κατηγορείτωσαν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Διατρίψας δὲ ἐν αὐτοῖς ἡμέρας πλείους ἢ δέκα, καταβὰς εἰς Καισάρειαν, τῇ ἐπαύριον καθίσας ἐπὶ τοῦ βήματος ἐκέλευσε τὸν Παῦλον ἀχθῆναι. ");
INSERT INTO grctr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Παραγενομένου δὲ αὐτοῦ, περιέστησαν οἱ ἀπὸ Ἱεροσολύμων καταβεβηκότες Ἰουδαῖοι, πολλὰ καὶ βαρέα αἰτιάματα φέροντες κατὰ τοῦ Παύλου, ἃ οὐκ ἴσχυον ἀποδεῖξαι, ");
INSERT INTO grctr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ἀπολογουμένου αὐτοῦ ὅτι Οὔτε εἰς τὸν νόμον τῶν Ἰουδαίων, οὔτε εἰς τὸ ἱερόν, οὔτε εἰς Καίσαρά τι ἥμαρτον. ");
INSERT INTO grctr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ὁ Φῆστος δὲ τοῖς Ἰουδαίοις θέλων χάριν καταθέσθαι, ἀποκριθεὶς τῷ Παύλῳ εἶπε, Θέλεις εἰς Ἱεροσόλυμα ἀναβάς, ἐκεῖ περὶ τούτων κρίνεσθαι ἐπ᾿ ἐμοῦ; ");
INSERT INTO grctr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Εἶπε δὲ ὁ Παῦλος, Ἐπὶ τοῦ βήματος Καίσαρος ἑστώς εἰμι, οὗ με δεῖ κρίνεσθαι· Ἰουδαίους οὐδὲν ἠδίκησα, ὡς καὶ σὺ κάλλιον ἐπιγινώσκεις. ");
INSERT INTO grctr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Εἰ μὲν γὰρ ἀδικῶ καὶ ἄξιον θανάτου πέπραχά τι, οὐ παραιτοῦμαι τὸ ἀποθανεῖν· εἰ δὲ οὐδέν ἐστιν ὧν οὗτοι κατηγοροῦσί μου, οὐδείς με δύναται αὐτοῖς χαρίσασθαι. Καίσαρα ἐπικαλοῦμαι. ");
INSERT INTO grctr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Τότε ὁ Φῆστος συλλαλήσας μετὰ τοῦ συμβουλίου ἀπεκρίθη, Καίσαρα ἐπικέκλησαι; Ἐπὶ Καίσαρα πορεύσῃ. ");
INSERT INTO grctr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ἡμερῶν δὲ διαγενομένων τινῶν, Ἀγρίππας ὁ βασιλεὺς καὶ Βερνίκη κατήντησαν εἰς Καισάρειαν, ἀσπασόμενοι τὸν Φῆστον. ");
INSERT INTO grctr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ὡς δὲ πλείους ἡμέρας διέτριβον ἐκεῖ, ὁ Φῆστος τῷ βασιλεῖ ἀνέθετο τὰ κατὰ τὸν Παῦλον, λέγων, Ἀνήρ τίς ἐστι καταλελειμμένος ὑπὸ Φήλικος δέσμιος, ");
INSERT INTO grctr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","περὶ οὗ, γενομένου μου εἰς Ἱεροσόλυμα, ἐνεφάνισαν οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τῶν Ἰουδαίων, αἰτούμενοι κατ᾿ αὐτοῦ δίκην. ");
INSERT INTO grctr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Πρὸς οὓς ἀπεκρίθην, ὅτι οὐκ ἔστιν ἔθος Ῥωμαίοις χαρίζεσθαί τινα ἄνθρωπον εἰς ἀπώλειαν, πρὶν ἢ ὁ κατηγορούμενος κατὰ πρόσωπον ἔχοι τοὺς κατηγόρους, τόπον τε ἀπολογίας λάβοι περὶ τοῦ ἐγκλήματος. ");
INSERT INTO grctr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Συνελθόντων οὖν αὐτῶν ἐνθάδε, ἀναβολὴν μηδεμίαν ποιησάμενος, τῇ ἑξῆς καθίσας ἐπὶ τοῦ βήματος, ἐκέλευσα ἀχθῆναι τὸν ἄνδρα· ");
INSERT INTO grctr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","περὶ οὗ σταθέντες οἱ κατήγοροι οὐδεμίαν αἰτίαν ἐπέφερον ὧν ὑπενόουν ἐγώ, ");
INSERT INTO grctr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ζητήματα δέ τινα περὶ τῆς ἰδίας δεισιδαιμονίας εἶχον πρὸς αὐτόν, καὶ περί τινος Ἰησοῦ τεθνηκότος, ὃν ἔφασκεν ὁ Παῦλος ζῇν. ");
INSERT INTO grctr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ἀπορούμενος δὲ ἐγὼ εἰς τὴν περὶ τούτου ζήτησιν, ἔλεγον, εἰ βούλοιτο πορεύεσθαι εἰς Ἱερουσαλήμ, κἀκεῖ κρίνεσθαι περὶ τούτων. ");
INSERT INTO grctr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Τοῦ δὲ Παύλου ἐπικαλεσαμένου τηρηθῆναι αὐτὸν εἰς τὴν τοῦ Σεβαστοῦ διάγνωσιν, ἐκέλευσα τηρεῖσθαι αὐτόν, ἕως οὗ πέμψω αὐτὸν πρὸς Καίσαρα. ");
INSERT INTO grctr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ἀγρίππας δὲ πρὸς τὸν Φῆστον ἔφη, Ἐβουλόμην καὶ αὐτὸς τοῦ ἀνθρώπου ἀκοῦσαι. Ὁ δέ, Αὔριον, φησίν, ἀκούσῃ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Τῇ οὖν ἐπαύριον, ἐλθόντος τοῦ Ἀγρίππα καὶ τῆς Βερνίκης μετὰ πολλῆς φαντασίας, καὶ εἰσελθόντων εἰς τὸ ἀκροατήριον, σύν τε τοῖς χιλιάρχοις καὶ ἀνδράσι τοῖς κατ᾿ ἐξοχὴν οὖσι τῆς πόλεως, καὶ κελεύσαντος τοῦ Φήστου, ἤχθη ὁ Παῦλος. ");
INSERT INTO grctr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Καί φησιν ὁ Φῆστος, Ἀγρίππα βασιλεῦ, καὶ πάντες οἱ συμπαρόντες ἡμῖν ἄνδρες, θεωρεῖτε τοῦτον περὶ οὗ πᾶν τὸ πλῆθος τῶν Ἰουδαίων ἐνέτυχόν μοι ἔν τε Ἱεροσολύμοις καὶ ἐνθάδε, ἐπιβοῶντες μὴ δεῖν ζῇν αὐτὸν μηκέτι. ");
INSERT INTO grctr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ἐγὼ δὲ καταλαβόμενος μηδὲν ἄξιον θανάτου αὐτὸν πεπραχέναι, καὶ αὐτοῦ δὲ τούτου ἐπικαλεσαμένου τὸν Σεβαστόν, ἔκρινα πέμπειν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Περὶ οὗ ἀσφαλές τι γράψαι τῷ κυρίῳ οὐκ ἔχω. Διὸ προήγαγον αὐτὸν ἐφ᾿ ὑμῶν, καὶ μάλιστα ἐπὶ σοῦ, βασιλεῦ Ἀγρίππα, ὅπως τῆς ἀνακρίσεως γενομένης σχῶ τι γράψαι. ");
INSERT INTO grctr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ἄλογον γάρ μοι δοκεῖ, πέμποντα δέσμιον, μὴ καὶ τὰς κατ᾿ αὐτοῦ αἰτίας σημᾶναι. ");
INSERT INTO grctr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ἀγρίππας δὲ πρὸς τὸν Παῦλον ἔφη, Ἐπιτρέπεταί σοι ὑπὲρ σεαυτοῦ λέγειν. Τότε ὁ Παῦλος ἀπελογεῖτο, ἐκτείνας τὴν χεῖρα, ");
INSERT INTO grctr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Περὶ πάντων ὧν ἐγκαλοῦμαι ὑπὸ Ἰουδαίων, βασιλεῦ Ἀγρίππα, ἥγημαι ἐμαυτὸν μακάριον μέλλων ἀπολογεῖσθαι ἐπὶ σοῦ σήμερον· ");
INSERT INTO grctr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","μάλιστα γνώστην ὄντα σὲ πάντων τῶν κατὰ Ἰουδαίους ἐθῶν τε καὶ ζητημάτων· διὸ δέομαί σου, μακροθύμως ἀκοῦσαί μου. ");
INSERT INTO grctr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Τὴν μὲν οὖν βίωσίν μου τὴν ἐκ νεότητος, τὴν ἀπ᾿ ἀρχῆς γενομένην ἐν τῷ ἔθνει μου ἐν Ἱεροσολύμοις, ἴσασι πάντες οἱ Ἰουδαῖοι, ");
INSERT INTO grctr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","προγινώσκοντές με ἄνωθεν, ἐὰν θέλωσι μαρτυρεῖν, ὅτι κατὰ τὴν ἀκριβεστάτην αἵρεσιν τῆς ἡμετέρας θρησκείας ἔζησα Φαρισαῖος. ");
INSERT INTO grctr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Καὶ νῦν ἐπ᾿ ἐλπίδι τῆς πρὸς τοὺς πατέρας ἐπαγγελίας γενομένης ὑπὸ τοῦ Θεοῦ ἕστηκα κρινόμενος, ");
INSERT INTO grctr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","εἰς ἣν τὸ δωδεκάφυλον ἡμῶν ἐν ἐκτενείᾳ νύκτα καὶ ἡμέραν λατρεῦον ἐλπίζει καταντῆσαι· περὶ ἧς ἐλπίδος ἐγκαλοῦμαι, βασιλεῦ Ἀγρίππα, ὑπὸ τῶν Ἰουδαίων. ");
INSERT INTO grctr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Τί ἄπιστον κρίνεται παρ᾿ ὑμῖν, εἰ ὁ Θεὸς νεκροὺς ἐγείρει; ");
INSERT INTO grctr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ἐγὼ μὲν οὖν ἔδοξα ἐμαυτῷ πρὸς τὸ ὄνομα Ἰησοῦ τοῦ Ναζωραίου δεῖν πολλὰ ἐναντία πρᾶξαι· ");
INSERT INTO grctr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ὃ καὶ ἐποίησα ἐν Ἱεροσολύμοις, καὶ πολλοὺς τῶν ἁγίων ἐγὼ φυλακαῖς κατέκλεισα, τὴν παρὰ τῶν ἀρχιερέων ἐξουσίαν λαβών, ἀναιρουμένων τε αὐτῶν κατήνεγκα ψῆφον. ");
INSERT INTO grctr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Καὶ κατὰ πάσας τὰς συναγωγὰς πολλάκις τιμωρῶν αὐτούς, ἠνάγκαζον βλασφημεῖν· περισσῶς τε ἐμμαινόμενος αὐτοῖς, ἐδίωκον ἕως καὶ εἰς τὰς ἔξω πόλεις. ");
INSERT INTO grctr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ἐν οἷς καὶ πορευόμενος εἰς τὴν Δαμασκὸν μετ᾿ ἐξουσίας καὶ ἐπιτροπῆς τῆς παρὰ τῶν ἀρχιερέων, ");
INSERT INTO grctr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ἡμέρας μέσης, κατὰ τὴν ὁδὸν εἶδον, βασιλεῦ, οὐρανόθεν ὑπὲρ τὴν λαμπρότητα τοῦ ἡλίου, περιλάμψαν με φῶς καὶ τοὺς σὺν ἐμοὶ πορευομένους. ");
INSERT INTO grctr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Πάντων δὲ καταπεσόντων ἡμῶν εἰς τὴν γῆν, ἤκουσα φωνὴν λαλοῦσαν πρός με καὶ λέγουσαν τῇ Ἑβραΐδι διαλέκτῳ, Σαούλ, Σαούλ, τί με διώκεις; Σκληρόν σοι πρὸς κέντρα λακτίζειν. ");
INSERT INTO grctr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ἐγὼ δὲ εἶπον, Τίς εἶ, Κύριε; Ὁ δὲ εἶπεν, Ἐγώ εἰμι Ἰησοῦς ὃν σὺ διώκεις. ");
INSERT INTO grctr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ἀλλὰ ἀνάστηθι, καὶ στῆθι ἐπὶ τοὺς πόδας σου· εἰς τοῦτο γὰρ ὤφθην σοι, προχειρίσασθαί σε ὑπηρέτην καὶ μάρτυρα ὧν τε εἶδες ὧν τε ὀφθήσομαί σοι, ");
INSERT INTO grctr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ἐξαιρούμενός σε ἐκ τοῦ λαοῦ καὶ τῶν ἐθνῶν, εἰς οὓς νῦν σε ἀποστέλλω, ");
INSERT INTO grctr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ἀνοῖξαι ὀφθαλμοὺς αὐτῶν, τοῦ ἐπιστρέψαι ἀπὸ σκότους εἰς φῶς καὶ τῆς ἐξουσίας τοῦ Σατανᾶ ἐπὶ τὸν Θεόν, τοῦ λαβεῖν αὐτοὺς ἄφεσιν ἁμαρτιῶν, καὶ κλῆρον ἐν τοῖς ἡγιασμένοις πίστει τῇ εἰς ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ὅθεν, βασιλεῦ Ἀγρίππα, οὐκ ἐγενόμην ἀπειθὴς τῇ οὐρανίῳ ὀπτασίᾳ, ");
INSERT INTO grctr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ἀλλὰ τοῖς ἐν Δαμασκῷ πρῶτον καὶ Ἱεροσολύμοις, εἰς πᾶσάν τε τὴν χώραν τῆς Ἰουδαίας, καὶ τοῖς ἔθνεσιν, ἀπήγγελλον μετανοεῖν, καὶ ἐπιστρέφειν ἐπὶ τὸν Θεόν, ἄξια τῆς μετανοίας ἔργα πράσσοντας. ");
INSERT INTO grctr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ἕνεκα τούτων με οἱ Ἰουδαῖοί συλλαβόμενοι ἐν τῷ ἱερῷ ἐπειρῶντο διαχειρίσασθαι. ");
INSERT INTO grctr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ἐπικουρίας οὖν τυχὼν τῆς παρὰ τοῦ Θεοῦ, ἄχρι τῆς ἡμέρας ταύτης ἕστηκα μαρτυρούμενος μικρῷ τε καὶ μεγάλῳ, οὐδὲν ἐκτὸς λέγων ὧν τε οἱ προφῆται ἐλάλησαν μελλόντων γίνεσθαι καὶ Μωσῆς, ");
INSERT INTO grctr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","εἰ παθητὸς ὁ Χριστός, εἰ πρῶτος ἐξ ἀναστάσεως νεκρῶν φῶς μέλλει καταγγέλλειν τῷ λαῷ καὶ τοῖς ἔθνεσι. ");
INSERT INTO grctr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ταῦτα δὲ αὐτοῦ ἀπολογουμένου, ὁ Φῆστος μεγάλῃ τῇ φωνῇ ἔφη, Μαίνῃ, Παῦλε· τὰ πολλά σε γράμματα εἰς μανίαν περιτρέπει. ");
INSERT INTO grctr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ὁ δέ, Οὐ μαίνομαι, φησί, κράτιστε Φῆστε, ἀλλ᾿ ἀληθείας καὶ σωφροσύνης ῥήματα ἀποφθέγγομαι. ");
INSERT INTO grctr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ἐπίσταται γὰρ περὶ τούτων ὁ βασιλεύς, πρὸς ὃν καὶ παρρησιαζόμενος λαλῶ· λανθάνειν γὰρ αὐτόν τι τούτων οὐ πείθομαι οὐδέν· οὐ γὰρ ἐστιν ἐν γωνίᾳ πεπραγμένον τοῦτο. ");
INSERT INTO grctr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Πιστεύεις, βασιλεῦ Ἀγρίππα, τοῖς προφήταις; Οἶδα ὅτι πιστεύεις. ");
INSERT INTO grctr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ὁ δὲ Ἀγρίππας πρὸς τὸν Παῦλον ἔφη, Ἐν ὀλίγῳ με πείθεις Χριστιανὸν γενέσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ὁ δὲ Παῦλος εἶπεν, Εὐξαίμην ἂν τῷ Θεῷ, καὶ ἐν ὀλίγῳ καὶ ἐν πολλῷ οὐ μόνον σε, ἀλλὰ καὶ πάντας τοὺς ἀκούοντάς μου σήμερον, γενέσθαι τοιούτους ὁποῖος κἀγώ εἰμι, παρεκτὸς τῶν δεσμῶν τούτων. ");
INSERT INTO grctr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Καὶ ταῦτα εἰπόντος αὐτοῦ, ἀνέστη ὁ βασιλεὺς καὶ ὁ ἡγεμών, ἥ τε Βερνίκη, καὶ οἱ συγκαθήμενοι αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","καὶ ἀναχωρήσαντες ἐλάλουν πρὸς ἀλλήλους, λέγοντες ὅτι Οὐδὲν θανάτου ἄξιον ἢ δεσμῶν πράσσει ὁ ἄνθρωπος οὗτος. ");
INSERT INTO grctr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ἀγρίππας δὲ τῷ Φήστῳ ἔφη, Ἀπολελύσθαι ἐδύνατο ὁ ἄνθρωπος οὗτος, εἰ μὴ ἐπεκέκλητο Καίσαρα. ");
INSERT INTO grctr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ὡς δὲ ἐκρίθη τοῦ ἀποπλεῖν ἡμᾶς εἰς τὴν Ἰταλίαν, παρεδίδουν τόν τε Παῦλον καί τινας ἑτέρους δεσμώτας ἑκατοντάρχῃ, ὀνόματι Ἰουλίῳ, σπείρης Σεβαστῆς. ");
INSERT INTO grctr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ἐπιβάντες δὲ πλοίῳ Ἀδραμυττηνῷ, μέλλοντες πλεῖν τοὺς κατὰ τὴν Ἀσίαν τόπους, ἀνήχθημεν, ὄντος σὺν ἡμῖν Ἀριστάρχου Μακεδόνος Θεσσαλονικέως. ");
INSERT INTO grctr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Τῇ τε ἑτέρᾳ κατήχθημεν εἰς Σιδῶνα· φιλανθρώπως τε ὁ Ἰούλιος τῷ Παύλῳ χρησάμενος ἐπέτρεψε πρὸς φίλους πορευθέντα ἐπιμελείας τυχεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Κἀκεῖθεν ἀναχθέντες ὑπεπλεύσαμεν τὴν Κύπρον, διὰ τὸ τοὺς ἀνέμους εἶναι ἐναντίους. ");
INSERT INTO grctr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Τό τε πέλαγος τὸ κατὰ τὴν Κιλικίαν καὶ Παμφυλίαν διαπλεύσαντες, κατήλθομεν εἰς Μύρα τῆς Λυκίας. ");
INSERT INTO grctr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Κἀκεῖ εὑρὼν ὁ ἑκατόνταρχος πλοῖον Ἀλεξανδρῖνον πλέον εἰς τὴν Ἰταλίαν, ἐνεβίβασεν ἡμᾶς εἰς αὐτό. ");
INSERT INTO grctr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ἐν ἱκαναῖς δὲ ἡμέραις βραδυπλοοῦντες, καὶ μόλις γενόμενοι κατὰ τὴν Κνίδον, μὴ προσεῶντος ἡμᾶς τοῦ ἀνέμου, ὑπεπλεύσαμεν τὴν Κρήτην κατὰ Σαλμώνην· ");
INSERT INTO grctr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","μόλις τε παραλεγόμενοι αὐτὴν ἤλθομεν εἰς τόπον τινὰ καλούμενον Καλοὺς Λιμένας, ᾧ ἐγγὺς ἦν πόλις Λασαία. ");
INSERT INTO grctr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ἱκανοῦ δὲ χρόνου διαγενομένου, καὶ ὄντος ἤδη ἐπισφαλοῦς τοῦ πλοός, διὰ τὸ καὶ τὴν νηστείαν ἤδη παρεληλυθέναι, παρῄνει ὁ Παῦλος ");
INSERT INTO grctr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","λέγων αὐτοῖς, Ἄνδρες, θεωρῶ ὅτι μετὰ ὕβρεως καὶ πολλῆς ζημίας, οὐ μόνον τοῦ φόρτου καὶ τοῦ πλοίου ἀλλὰ καὶ τῶν ψυχῶν ἡμῶν, μέλλειν ἔσεσθαι τὸν πλοῦν. ");
INSERT INTO grctr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ὁ δὲ ἑκατόνταρχος τῷ κυβερνήτῃ καὶ τῷ ναυκλήρῳ ἐπείθετο μᾶλλον ἢ τοῖς ὑπὸ τοῦ Παύλου λεγομένοις. ");
INSERT INTO grctr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ἀνευθέτου δὲ τοῦ λιμένος ὑπάρχοντος πρὸς παραχειμασίαν, οἱ πλείους ἔθεντο βουλὴν ἀναχθῆναι κἀκεῖθεν, εἴ πως δύναιντο καταντήσαντες εἰς Φοίνικα παραχειμάσαι, λιμένα τῆς Κρήτης βλέποντα κατὰ λίβα καὶ κατὰ χῶρον. ");
INSERT INTO grctr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ὑποπνεύσαντος δὲ νότου, δόξαντες τῆς προθέσεως κεκρατηκέναι, ἄραντες ἆσσον παρελέγοντο τὴν Κρήτην. ");
INSERT INTO grctr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Μετ᾿ οὐ πολὺ δὲ ἔβαλε κατ᾿ αὐτῆς ἄνεμος τυφωνικός, ὁ καλούμενος Εὐροκλύδων· ");
INSERT INTO grctr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","συναρπασθέντος δὲ τοῦ πλοίου, καὶ μὴ δυναμένου ἀντοφθαλμεῖν τῷ ἀνέμῳ, ἐπιδόντες ἐφερόμεθα. ");
INSERT INTO grctr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Νησίον δέ τι ὑποδραμόντες καλούμενον Κλαύδην μόλις ἰσχύσαμεν περικρατεῖς γενέσθαι τῆς σκάφης· ");
INSERT INTO grctr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ἣν ἄραντες, βοηθείαις ἐχρῶντο, ὑποζωννύντες τὸ πλοῖον· φοβούμενοί τε μὴ εἰς τὴν Σύρτιν ἐκπέσωσι, χαλάσαντες τὸ σκεῦος, οὕτως ἐφέροντο. ");
INSERT INTO grctr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Σφοδρῶς δὲ χειμαζομένων ἡμῶν, τῇ ἑξῆς ἐκβολὴν ἐποιοῦντο· ");
INSERT INTO grctr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","καὶ τῇ τρίτῃ αὐτόχειρες τὴν σκευὴν τοῦ πλοίου ἐρρίψαμεν. ");
INSERT INTO grctr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Μήτε δὲ ἡλίου μήτε ἄστρων ἐπιφαινόντων ἐπὶ πλείονας ἡμέρας, χειμῶνός τε οὐκ ὀλίγου ἐπικειμένου, λοιπὸν περιῃρεῖτο πᾶσα ἐλπὶς τοῦ σώζεσθαι ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Πολλῆς δὲ ἀσιτίας ὑπαρχούσης, τότε σταθεὶς ὁ Παῦλος ἐν μέσῳ αὐτῶν εἶπεν, Ἔδει μέν, ὦ ἄνδρες, πειθαρχήσαντάς μοι μὴ ἀνάγεσθαι ἀπὸ τῆς Κρήτης, κερδῆσαί τε τὴν ὕβριν ταύτην καὶ τὴν ζημίαν. ");
INSERT INTO grctr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Καὶ τὰ νῦν παραινῶ ὑμᾶς εὐθυμεῖν· ἀποβολὴ γὰρ ψυχῆς οὐδεμία ἔσται ἐξ ὑμῶν, πλὴν τοῦ πλοίου. ");
INSERT INTO grctr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Παρέστη γάρ μοι τῇ νυκτὶ ταύτῃ ἄγγελος τοῦ Θεοῦ, οὗ εἰμι, ᾧ καὶ λατρεύω, ");
INSERT INTO grctr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","λέγων, Μὴ φοβοῦ, Παῦλε· Καίσαρί σε δεῖ παραστῆναι· καὶ ἰδού, κεχάρισταί σοι ὁ Θεὸς πάντας τοὺς πλέοντας μετὰ σοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Διὸ εὐθυμεῖτε ἄνδρες· πιστεύω γὰρ τῷ Θεῷ ὅτι οὕτως ἔσται καθ᾿ ὃν τρόπον λελάληταί μοι. ");
INSERT INTO grctr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Εἰς νῆσον δέ τινα δεῖ ἡμᾶς ἐκπεσεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ὡς δὲ τεσσαρεσκαιδεκάτη νὺξ ἐγένετο, διαφερομένων ἡμῶν ἐν τῷ Ἀδρίᾳ, κατὰ μέσον τῆς νυκτὸς ὑπενόουν οἱ ναῦται προσάγειν τινὰ αὐτοῖς χώραν· ");
INSERT INTO grctr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","καὶ βολίσαντες εὗρον ὀργυιὰς εἴκοσι· βραχὺ δὲ διαστήσαντες, καὶ πάλιν βολίσαντες, εὗρον ὀργυιὰς δεκαπέντε· ");
INSERT INTO grctr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","φοβούμενοί τε μήπως εἰς τραχεῖς τόπους ἐκπέσωσιν, ἐκ πρύμνης ῥίψαντες ἀγκύρας τέσσαρας, ηὔχοντο ἡμέραν γενέσθαι. ");
INSERT INTO grctr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Τῶν δὲ ναυτῶν ζητούντων φυγεῖν ἐκ τοῦ πλοίου, καὶ χαλασάντων τὴν σκάφην εἰς τὴν θάλασσαν, προφάσει ὡς ἐκ πρῴρας μελλόντων ἀγκύρας ἐκτείνειν, ");
INSERT INTO grctr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","εἶπεν ὁ Παῦλος τῷ ἑκατοντάρχῃ καὶ τοῖς στρατιώταις, Ἐὰν μὴ οὗτοι μείνωσιν ἐν τῷ πλοίῳ, ὑμεῖς σωθῆναι οὐ δύνασθε. ");
INSERT INTO grctr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Τότε οἱ στρατιῶται ἀπέκοψαν τὰ σχοινία τῆς σκάφης, καὶ εἴασαν αὐτὴν ἐκπεσεῖν. ");
INSERT INTO grctr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ἄχρι δὲ οὗ ἔμελλεν ἡμέρα γίνεσθαι, παρεκάλει ὁ Παῦλος ἅπαντας μεταλαβεῖν τροφῆς, λέγων, Τεσσαρεσκαιδεκάτην σήμερον ἡμέραν προσδοκῶντες ἄσιτοι διατελεῖτε, μηδὲν προσλαβόμενοι. ");
INSERT INTO grctr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Διὸ παρακαλῶ ὑμᾶς προσλαβεῖν τροφῆς· τοῦτο γὰρ πρὸς τῆς ὑμετέρας σωτηρίας ὑπάρχει· οὐδενὸς γὰρ ὑμῶν θρὶξ ἐκ τῆς κεφαλῆς πεσεῖται. ");
INSERT INTO grctr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Εἰπὼν δὲ ταῦτα, καὶ λαβὼν ἄρτον, εὐχαρίστησε τῷ Θεῷ ἐνώπιον πάντων· καὶ κλάσας ἤρξατο ἐσθίειν. ");
INSERT INTO grctr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Εὔθυμοι δὲ γενόμενοι πάντες καὶ αὐτοὶ προσελάβοντο τροφῆς. ");
INSERT INTO grctr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ἦμεν δὲ ἐν τῷ πλοίῳ αἱ πᾶσαι ψυχαί, διακόσιαι ἑβδομήκοντα ἕξ. ");
INSERT INTO grctr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Κορεσθέντες δὲ τροφῆς ἐκούφιζον τὸ πλοῖον, ἐκβαλλόμενοι τὸν σῖτον εἰς τὴν θάλασσαν. ");
INSERT INTO grctr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ὅτε δὲ ἡμέρα ἐγένετο, τὴν γῆν οὐκ ἐπεγίνωσκον· κόλπον δέ τινα κατενόουν ἔχοντα αἰγιαλόν, εἰς ὃν ἐβουλεύσαντο, εἰ δύναιντο, ἐξῶσαι τὸ πλοῖον. ");
INSERT INTO grctr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Καὶ τὰς ἀγκύρας περιελόντες εἴων εἰς τὴν θάλασσαν, ἅμα ἀνέντες τὰς ζευκτηρίας τῶν πηδαλίων· καὶ ἐπάραντες τὸν ἀρτέμονα τῇ πνεούσῃ κατεῖχον εἰς τὸν αἰγιαλόν. ");
INSERT INTO grctr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Περιπεσόντες δὲ εἰς τόπον διθάλασσον ἐπώκειλαν τὴν ναῦν· καὶ ἡ μὲν πρῷρα ἐρείσασα ἔμεινεν ἀσάλευτος, ἡ δὲ πρύμνα ἐλύετο ὑπὸ τῆς βίας τῶν κυμάτων. ");
INSERT INTO grctr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Τῶν δὲ στρατιωτῶν βουλὴ ἐγένετο ἵνα τοὺς δεσμώτας ἀποκτείνωσι, μή τις ἐκκολυμβήσας διαφύγοι. ");
INSERT INTO grctr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ὁ δὲ ἑκατόνταρχος, βουλόμενος διασῶσαι τὸν Παῦλον, ἐκώλυσεν αὐτοὺς τοῦ βουλήματος, ἐκέλευσέ τε τοὺς δυναμένους κολυμβᾷν ἀπορρίψαντας πρώτους ἐπὶ τὴν γῆν ἐξιέναι· ");
INSERT INTO grctr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","καὶ τοὺς λοιπούς, οὓς μὲν ἐπὶ σανίσιν, οὓς δὲ ἐπί τινων τῶν ἀπὸ τοῦ πλοίου. Καὶ οὕτως ἐγένετο πάντας διασωθῆναι ἐπὶ τὴν γῆν. ");
INSERT INTO grctr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Καὶ διασωθέντες, τότε ἐπέγνωσαν ὅτι Μελίτη ἡ νῆσος καλεῖται. ");
INSERT INTO grctr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Οἱ δὲ βάρβαροι παρεῖχον οὐ τὴν τυχοῦσαν φιλανθρωπίαν ἡμῖν· ἀνάψαντες γὰρ πυράν, προσελάβοντο πάντας ἡμᾶς, διὰ τὸν ὑετὸν τὸν ἐφεστῶτα, καὶ διὰ τὸ ψῦχος. ");
INSERT INTO grctr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Συστρέψαντος δὲ τοῦ Παύλου φρυγάνων πλῆθος, καὶ ἐπιθέντος ἐπὶ τὴν πυράν, ἔχιδνα ἐκ τῆς θέρμης ἐξελθοῦσα καθῆψε τῆς χειρὸς αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ὡς δὲ εἶδον οἱ βάρβαροι κρεμάμενον τὸ θηρίον ἐκ τῆς χειρὸς αὐτοῦ, ἔλεγον πρὸς ἀλλήλους, Πάντως φονεύς ἐστιν ὁ ἄνθρωπος οὗτος, ὃν διασωθέντα ἐκ τῆς θαλάσσης ἡ Δίκη ζῇν οὐκ εἴασεν. ");
INSERT INTO grctr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ὁ μὲν οὖν, ἀποτινάξας τὸ θηρίον εἰς τὸ πῦρ, ἔπαθεν οὐδὲν κακόν. ");
INSERT INTO grctr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Οἱ δὲ προσεδόκων αὐτὸν μέλλειν πίμπρασθαι ἢ καταπίπτειν ἄφνω νεκρόν· ἐπὶ πολὺ δὲ αὐτῶν προσδοκώντων, καὶ θεωρούντων μηδὲν ἄτοπον εἰς αὐτὸν γινόμενον, μεταβαλλόμενοι ἔλεγον θεὸν αὐτὸν εἶναι. ");
INSERT INTO grctr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ἐν δὲ τοῖς περὶ τὸν τόπον ἐκεῖνον ὑπῆρχε χωρία τῷ πρώτῳ τῆς νήσου, ὀνόματι Ποπλίῳ, ὃς ἀναδεξάμενος ἡμᾶς τρεῖς ἡμέρας φιλοφρόνως ἐξένισεν. ");
INSERT INTO grctr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ἐγένετο δὲ τὸν πατέρα τοῦ Ποπλίου πυρετοῖς καὶ δυσεντερίᾳ συνεχόμενον κατακεῖσθαι· πρὸς ὃν ὁ Παῦλος εἰσελθών, καὶ προσευξάμενος, ἐπιθεὶς τὰς χεῖρας αὐτῷ, ἰάσατο αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Τούτου οὖν γενομένου, καὶ οἱ λοιποὶ οἱ ἔχοντες ἀσθενείας ἐν τῇ νήσῳ προσήρχοντο καὶ ἐθεραπεύοντο· ");
INSERT INTO grctr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","οἳ καὶ πολλαῖς τιμαῖς ἐτίμησαν ἡμᾶς, καὶ ἀναγομένοις ἐπέθεντο τὰ πρὸς τὴν χρείαν. ");
INSERT INTO grctr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Μετὰ δὲ τρεῖς μῆνας ἀνήχθημεν ἐν πλοίῳ παρακεχειμακότι ἐν τῇ νήσῳ, Ἀλεξανδρίνῳ, παρασήμῳ Διοσκούροις. ");
INSERT INTO grctr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Καὶ καταχθέντες εἰς Συρακούσας ἐπεμείναμεν ἡμέρας τρεῖς· ");
INSERT INTO grctr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ὅθεν περιελθόντες κατηντήσαμεν εἰς Ῥήγιον, καὶ μετὰ μίαν ἡμέραν ἐπιγενομένου νότου, δευτεραῖοι ἤλθομεν εἰς Ποτιόλους· ");
INSERT INTO grctr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","οὗ εὑρόντες ἀδελφούς, παρεκλήθημεν ἐπ᾿ αὐτοῖς ἐπιμεῖναι ἡμέρας ἑπτά· καὶ οὕτως εἰς τὴν Ῥώμην ἤλθομεν. ");
INSERT INTO grctr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Κἀκεῖθεν οἱ ἀδελφοὶ ἀκούσαντες τὰ περὶ ἡμῶν, ἐξῆλθον εἰς ἀπάντησιν ἡμῖν ἄχρις Ἀππίου Φόρου καὶ Τριῶν Ταβερνῶν· οὓς ἰδὼν ὁ Παῦλος, εὐχαριστήσας τῷ Θεῷ, ἔλαβε θάρσος. ");
INSERT INTO grctr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ὅτε δὲ ἤλθομεν εἰς Ῥώμην, ὁ ἑκατόνταρχος παρέδωκε τοὺς δεσμίους τῷ στρατοπεδάρχῃ· τῷ δὲ Παύλῳ ἐπετράπη μένειν καθ᾿ ἑαυτόν, σὺν τῷ φυλάσσοντι αὐτὸν στρατιώτῃ. ");
INSERT INTO grctr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ἐγένετο δὲ μετὰ ἡμέρας τρεῖς συγκαλέσασθαι τὸν Παῦλον τοὺς ὄντας τῶν Ἰουδαίων πρώτους· συνελθόντων δὲ αὐτῶν, ἔλεγε πρὸς αὐτούς, Ἄνδρες ἀδελφοί, ἐγὼ οὐδὲν ἐναντίον ποιήσας τῷ λαῷ ἢ τοῖς ἔθεσι τοῖς πατρῴοις, δέσμιος ἐξ Ἱεροσολύμων παρεδόθην εἰς τὰς χεῖρας τῶν Ῥωμαίων· ");
INSERT INTO grctr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","οἵτινες ἀνακρίναντές με ἐβούλοντο ἀπολῦσαι, διὰ τὸ μηδεμίαν αἰτίαν θανάτου ὑπάρχειν ἐν ἐμοί. ");
INSERT INTO grctr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ἀντιλεγόντων δὲ τῶν Ἰουδαίων, ἠναγκάσθην ἐπικαλέσασθαι Καίσαρα, οὐχ ὡς τοῦ ἔθνους μου ἔχων τι κατηγορῆσαι. ");
INSERT INTO grctr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Διὰ ταύτην οὖν τὴν αἰτίαν παρεκάλεσα ὑμᾶς ἰδεῖν καὶ προσλαλῆσαι· ἕνεκεν γὰρ τῆς ἐλπίδος τοῦ Ἰσραὴλ τὴν ἅλυσιν ταύτην περίκειμαι. ");
INSERT INTO grctr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Οἱ δὲ πρὸς αὐτὸν εἶπον, Ἡμεῖς οὔτε γράμματα περὶ σοῦ ἐδεξάμεθα ἀπὸ τῆς Ἰουδαίας, οὔτε παραγενόμενός τις τῶν ἀδελφῶν ἀπήγγειλεν ἢ ἐλάλησέ τι περὶ σοῦ πονηρόν. ");
INSERT INTO grctr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ἀξιοῦμεν δὲ παρὰ σοῦ ἀκοῦσαι ἃ φρονεῖς· περὶ μὲν γὰρ τῆς αἱρέσεως ταύτης γνωστόν ἐστιν ἡμῖν ὅτι πανταχοῦ ἀντιλέγεται. ");
INSERT INTO grctr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ταξάμενοι δὲ αὐτῷ ἡμέραν, ἧκον πρὸς αὐτὸν εἰς τὴν ξενίαν πλείονες· οἷς ἐξετίθετο διαμαρτυρόμενος τὴν βασιλείαν τοῦ Θεοῦ, πείθων τε αὐτοὺς τὰ περὶ τοῦ Ἰησοῦ, ἀπό τε τοῦ νόμου Μωσέως καὶ τῶν προφητῶν, ἀπὸ πρωῒ ἕως ἑσπέρας. ");
INSERT INTO grctr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Καὶ οἱ μὲν ἐπείθοντο τοῖς λεγομένοις, οἱ δὲ ἠπίστουν. ");
INSERT INTO grctr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ἀσύμφωνοι δὲ ὄντες πρὸς ἀλλήλους ἀπελύοντο, εἰπόντος τοῦ Παύλου ῥῆμα ἕν, ὅτι Καλῶς τὸ πνεῦμα τὸ ἅγιον ἐλάλησε διὰ Ἠσαΐου τοῦ προφήτου πρὸς τοὺς πατέρας ἡμῶν, ");
INSERT INTO grctr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","λέγον, Πορεύθητι πρὸς τὸν λαὸν τοῦτον καὶ εἰπέ, Ἀκοῇ ἀκούσετε, καὶ οὐ μὴ συνῆτε· καὶ βλέποντες βλέψετε, καὶ οὐ μὴ ἴδητε. ");
INSERT INTO grctr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ἐπαχύνθη γὰρ ἡ καρδία τοῦ λαοῦ τούτου, καὶ τοῖς ὠσὶ βαρέως ἤκουσαν, καὶ τοὺς ὀφθαλμοὺς αὐτῶν ἐκάμμυσαν· μήποτε ἴδωσι τοῖς ὀφθαλμοῖς, καὶ τοῖς ὠσὶν ἀκούσωσι, καὶ τῇ καρδίᾳ συνῶσι, καὶ ἐπιστρέψωσι, καὶ ἰάσωμαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Γνωστὸν οὖν ἔστω ὑμῖν ὅτι τοῖς ἔθνεσιν ἀπεστάλη τὸ σωτήριον τοῦ Θεοῦ, αὐτοὶ καὶ ἀκούσονται. ");
INSERT INTO grctr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Καὶ ταῦτα αὐτοῦ εἰπόντος, ἀπῆλθον οἱ Ἰουδαῖοι, πολλὴν ἔχοντες ἐν ἑαυτοῖς συζήτησιν. ");
INSERT INTO grctr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ἔμεινε δὲ ὁ Παῦλος διετίαν ὅλην ἐν ἰδίῳ μισθώματι, καὶ ἀπεδέχετο πάντας τοὺς εἰσπορευομένους πρὸς αὐτόν, ");
INSERT INTO grctr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","κηρύσσων τὴν βασιλείαν τοῦ Θεοῦ, καὶ διδάσκων τὰ περὶ τοῦ Κυρίου Ἰησοῦ Χριστοῦ, μετὰ πάσης παρρησίας, ἀκωλύτως. ");
INSERT INTO grctr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Παῦλος, δοῦλος Ἰησοῦ Χριστοῦ, κλητὸς ἀπόστολος, ἀφωρισμένος εἰς εὐαγγέλιον Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ὃ προεπηγγείλατο διὰ τῶν προφητῶν αὐτοῦ ἐν γραφαῖς ἁγίαις, ");
INSERT INTO grctr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","περὶ τοῦ υἱοῦ αὐτοῦ, τοῦ γενομένου ἐκ σπέρματος Δαβὶδ κατὰ σάρκα, ");
INSERT INTO grctr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","τοῦ ὁρισθέντος υἱοῦ Θεοῦ ἐν δυνάμει, κατὰ πνεῦμα ἁγιωσύνης, ἐξ ἀναστάσεως νεκρῶν, Ἰησοῦ Χριστοῦ τοῦ Κυρίου ἡμῶν, ");
INSERT INTO grctr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","δι᾿ οὗ ἐλάβομεν χάριν καὶ ἀποστολὴν εἰς ὑπακοὴν πίστεως ἐν πᾶσι τοῖς ἔθνεσιν, ὑπὲρ τοῦ ὀνόματος αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ἐν οἷς ἐστὲ καὶ ὑμεῖς, κλητοὶ Ἰησοῦ Χριστοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","πᾶσι τοῖς οὖσιν ἐν Ῥώμῃ ἀγαπητοῖς Θεοῦ, κλητοῖς ἁγίοις· χάρις ὑμῖν καὶ εἰρήνη ἀπὸ Θεοῦ πατρὸς ἡμῶν καὶ Κυρίου Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Πρῶτον μὲν εὐχαριστῶ τῷ Θεῷ μου διὰ Ἰησοῦ Χριστοῦ ὑπὲρ πάντων ὑμῶν, ὅτι ἡ πίστις ὑμῶν καταγγέλλεται ἐν ὅλῳ τῷ κόσμῳ. ");
INSERT INTO grctr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Μάρτυς γάρ μού ἐστιν ὁ Θεός, ᾧ λατρεύω ἐν τῷ πνεύματί μου ἐν τῷ εὐαγγελίῳ τοῦ υἱοῦ αὐτοῦ, ὡς ἀδιαλείπτως μνείαν ὑμῶν ποιοῦμαι, ");
INSERT INTO grctr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","πάντοτε ἐπὶ τῶν προσευχῶν μου δεόμενος, εἴ πως ἤδη ποτὲ εὐοδωθήσομαι ἐν τῷ θελήματι τοῦ Θεοῦ ἐλθεῖν πρὸς ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ἐπιποθῶ γὰρ ἰδεῖν ὑμᾶς, ἵνα τι μεταδῶ χάρισμα ὑμῖν πνευματικόν, εἰς τὸ στηριχθῆναι ὑμᾶς, ");
INSERT INTO grctr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","τοῦτο δέ ἐστι, συμπαρακληθῆναι ἐν ὑμῖν διὰ τῆς ἐν ἀλλήλοις πίστεως ὑμῶν τε καὶ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Οὐ θέλω δὲ ὑμᾶς ἀγνοεῖν, ἀδελφοί, ὅτι πολλάκις προεθέμην ἐλθεῖν πρὸς ὑμᾶς — καὶ ἐκωλύθην ἄχρι τοῦ δεῦρο — ἵνα καρπόν τινα σχῶ καὶ ἐν ὑμῖν, καθὼς καὶ ἐν τοῖς λοιποῖς ἔθνεσιν. ");
INSERT INTO grctr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ἕλλησί τε καὶ βαρβάροις, σοφοῖς τε καὶ ἀνοήτοις ὀφειλέτης εἰμί· ");
INSERT INTO grctr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","οὕτω τὸ κατ᾿ ἐμὲ πρόθυμον καὶ ὑμῖν τοῖς ἐν Ῥώμῃ εὐαγγελίσασθαι. ");
INSERT INTO grctr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Οὐ γὰρ ἐπαισχύνομαι τὸ εὐαγγέλιον τοῦ Χριστοῦ· δύναμις γὰρ Θεοῦ ἐστιν εἰς σωτηρίαν παντὶ τῷ πιστεύοντι, Ἰουδαίῳ τε πρῶτον καὶ Ἕλληνι. ");
INSERT INTO grctr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Δικαιοσύνη γὰρ Θεοῦ ἐν αὐτῷ ἀποκαλύπτεται ἐκ πίστεως εἰς πίστιν, καθὼς γέγραπται, Ὁ δὲ δίκαιος ἐκ πίστεως ζήσεται. ");
INSERT INTO grctr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ἀποκαλύπτεται γὰρ ὀργὴ Θεοῦ ἀπ᾿ οὐρανοῦ ἐπὶ πᾶσαν ἀσέβειαν καὶ ἀδικίαν ἀνθρώπων τῶν τὴν ἀλήθειαν ἐν ἀδικίᾳ κατεχόντων· ");
INSERT INTO grctr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","διότι τὸ γνωστὸν τοῦ Θεοῦ φανερόν ἐστιν ἐν αὐτοῖς· ὁ γὰρ Θεὸς αὐτοῖς ἐφανέρωσε. ");
INSERT INTO grctr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Τὰ γὰρ ἀόρατα αὐτοῦ ἀπὸ κτίσεως κόσμου τοῖς ποιήμασι νοούμενα καθορᾶται, ἥ τε ἀΐδιος αὐτοῦ δύναμις καὶ θειότης, εἰς τὸ εἶναι αὐτοὺς ἀναπολογήτους· ");
INSERT INTO grctr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","διότι γνόντες τὸν Θεόν, οὐχ ὡς Θεὸν ἐδόξασαν ἢ εὐχαρίστησαν, ἀλλ᾿ ἐματαιώθησαν ἐν τοῖς διαλογισμοῖς αὐτῶν, καὶ ἐσκοτίσθη ἡ ἀσύνετος αὐτῶν καρδία. ");
INSERT INTO grctr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Φάσκοντες εἶναι σοφοὶ ἐμωράνθησαν, ");
INSERT INTO grctr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","καὶ ἤλλαξαν τὴν δόξαν τοῦ ἀφθάρτου Θεοῦ ἐν ὁμοιώματι εἰκόνος φθαρτοῦ ἀνθρώπου καὶ πετεινῶν καὶ τετραπόδων καὶ ἑρπετῶν. ");
INSERT INTO grctr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Διὸ καὶ παρέδωκεν αὐτοὺς ὁ Θεὸς ἐν ταῖς ἐπιθυμίαις τῶν καρδιῶν αὐτῶν εἰς ἀκαθαρσίαν, τοῦ ἀτιμάζεσθαι τὰ σώματα αὐτῶν ἐν ἑαυτοῖς· ");
INSERT INTO grctr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","οἵτινες μετήλλαξαν τὴν ἀλήθειαν τοῦ Θεοῦ ἐν τῷ ψεύδει, καὶ ἐσεβάσθησαν καὶ ἐλάτρευσαν τῇ κτίσει παρὰ τὸν κτίσαντα, ὅς ἐστιν εὐλογητὸς εἰς τοὺς αἰῶνας. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Διὰ τοῦτο παρέδωκεν αὐτοὺς ὁ Θεὸς εἰς πάθη ἀτιμίας· αἵ τε γὰρ θήλειαι αὐτῶν μετήλλαξαν τὴν φυσικὴν χρῆσιν εἰς τὴν παρὰ φύσιν· ");
INSERT INTO grctr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ὁμοίως τε καὶ οἱ ἄρσενες, ἀφέντες τὴν φυσικὴν χρῆσιν τῆς θηλείας, ἐξεκαύθησαν ἐν τῇ ὀρέξει αὐτῶν εἰς ἀλλήλους, ἄρσενες ἐν ἄρσεσι τὴν ἀσχημοσύνην κατεργαζόμενοι, καὶ τὴν ἀντιμισθίαν ἣν ἔδει τῆς πλάνης αὐτῶν ἐν ἑαυτοῖς ἀπολαμβάνοντες. ");
INSERT INTO grctr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Καὶ καθὼς οὐκ ἐδοκίμασαν τὸν Θεὸν ἔχειν ἐν ἐπιγνώσει, παρέδωκεν αὐτοὺς ὁ Θεὸς εἰς ἀδόκιμον νοῦν, ποιεῖν τὰ μὴ καθήκοντα, ");
INSERT INTO grctr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","πεπληρωμένους πάσῃ ἀδικίᾳ, πορνείᾳ, πονηρίᾳ, πλεονεξίᾳ, κακίᾳ· μεστοὺς φθόνου, φόνου, ἔριδος, δόλου, κακοηθείας· ψιθυριστάς, ");
INSERT INTO grctr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","καταλάλους, θεοστυγεῖς, ὑβριστάς, ὑπερηφάνους, ἀλαζόνας, ἐφευρετὰς κακῶν, γονεῦσιν ἀπειθεῖς, ");
INSERT INTO grctr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ἀσυνέτους, ἀσυνθέτους, ἀστόργους, ἀσπόνδους, ἀνελεήμονας· ");
INSERT INTO grctr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","οἵτινες τὸ δικαίωμα τοῦ Θεοῦ ἐπιγνόντες, ὅτι οἱ τὰ τοιαῦτα πράσσοντες ἄξιοι θανάτου εἰσίν, οὐ μόνον αὐτὰ ποιοῦσιν, ἀλλὰ καὶ συνευδοκοῦσι τοῖς πράσσουσι. ");
INSERT INTO grctr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Διὸ ἀναπολόγητος εἶ, ὦ ἄνθρωπε πᾶς ὁ κρίνων· ἐν ᾧ γὰρ κρίνεις τὸν ἕτερον, σεαυτὸν κατακρίνεις, τὰ γὰρ αὐτὰ πράσσεις ὁ κρίνων. ");
INSERT INTO grctr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Οἴδαμεν δὲ ὅτι τὸ κρίμα τοῦ Θεοῦ ἐστι κατὰ ἀλήθειαν ἐπὶ τοὺς τὰ τοιαῦτα πράσσοντας. ");
INSERT INTO grctr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Λογίζῃ δὲ τοῦτο, ὦ ἄνθρωπε ὁ κρίνων τοὺς τὰ τοιαῦτα πράσσοντας καὶ ποιῶν αὐτά, ὅτι σὺ ἐκφεύξῃ τὸ κρίμα τοῦ Θεοῦ; ");
INSERT INTO grctr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ἢ τοῦ πλούτου τῆς χρηστότητος αὐτοῦ καὶ τῆς ἀνοχῆς καὶ τῆς μακροθυμίας καταφρονεῖς, ἀγνοῶν ὅτι τὸ χρηστὸν τοῦ Θεοῦ εἰς μετάνοιάν σε ἄγει; ");
INSERT INTO grctr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Κατὰ δὲ τὴν σκληρότητά σου καὶ ἀμετανόητον καρδίαν θησαυρίζεις σεαυτῷ ὀργὴν ἐν ἡμέρᾳ ὀργῆς καὶ ἀποκαλύψεως δικαιοκρισίας τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ὃς ἀποδώσει ἑκάστῳ κατὰ τὰ ἔργα αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","τοῖς μὲν καθ᾿ ὑπομονὴν ἔργου ἀγαθοῦ δόξαν καὶ τιμὴν καὶ ἀφθαρσίαν ζητοῦσι, ζωὴν αἰώνιον· ");
INSERT INTO grctr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","τοῖς δὲ ἐξ ἐριθείας, καὶ ἀπειθοῦσι μὲν τῇ ἀληθείᾳ πειθομένοις δὲ τῇ ἀδικίᾳ, θυμὸς καὶ ὀργή, ");
INSERT INTO grctr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","θλίψις καὶ στενοχωρία, ἐπὶ πᾶσαν ψυχὴν ἀνθρώπου τοῦ κατεργαζομένου τὸ κακόν, Ἰουδαίου τε πρῶτον καὶ Ἕλληνος· ");
INSERT INTO grctr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","δόξα δὲ καὶ τιμὴ καὶ εἰρήνη παντὶ τῷ ἐργαζομένῳ τὸ ἀγαθόν, Ἰουδαίῳ τε πρῶτον καὶ Ἕλληνι· ");
INSERT INTO grctr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","οὐ γάρ ἐστι προσωποληψία παρὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ὅσοι γὰρ ἀνόμως ἥμαρτον, ἀνόμως καὶ ἀπολοῦνται· καὶ ὅσοι ἐν νόμῳ ἥμαρτον, διὰ νόμου κριθήσονται· ");
INSERT INTO grctr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","οὐ γὰρ οἱ ἀκροαταὶ τοῦ νόμου δίκαιοι παρὰ τῷ Θεῷ, ἀλλ᾿ οἱ ποιηταὶ τοῦ νόμου δικαιωθήσονται. ");
INSERT INTO grctr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ὅταν γὰρ ἔθνη τὰ μὴ νόμον ἔχοντα φύσει τὰ τοῦ νόμου ποιῇ, οὗτοι, νόμον μὴ ἔχοντες, ἑαυτοῖς εἰσι νόμος· ");
INSERT INTO grctr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","οἵτινες ἐνδείκνυνται τὸ ἔργον τοῦ νόμου γραπτὸν ἐν ταῖς καρδίαις αὐτῶν, συμμαρτυρούσης αὐτῶν τῆς συνειδήσεως, καὶ μεταξὺ ἀλλήλων τῶν λογισμῶν κατηγορούντων ἢ καὶ ἀπολογουμένων, ");
INSERT INTO grctr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ἐν ἡμέρᾳ ὅτε κρινεῖ ὁ Θεὸς τὰ κρυπτὰ τῶν ἀνθρώπων, κατὰ τὸ εὐαγγέλιόν μου, διὰ Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ἴδε σὺ Ἰουδαῖος ἐπονομάζῃ, καὶ ἐπαναπαύῃ τῷ νόμῳ, καὶ καυχᾶσαι ἐν Θεῷ, ");
INSERT INTO grctr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","καὶ γινώσκεις τὸ θέλημα, καὶ δοκιμάζεις τὰ διαφέροντα, κατηχούμενος ἐκ τοῦ νόμου, ");
INSERT INTO grctr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","πέποιθάς τε σεαυτὸν ὁδηγὸν εἶναι τυφλῶν, φῶς τῶν ἐν σκότει, ");
INSERT INTO grctr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","παιδευτὴν ἀφρόνων, διδάσκαλον νηπίων, ἔχοντα τὴν μόρφωσιν τῆς γνώσεως καὶ τῆς ἀληθείας ἐν τῷ νόμῳ· ");
INSERT INTO grctr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ὁ οὖν διδάσκων ἕτερον, σεαυτὸν οὐ διδάσκεις; Ὁ κηρύσσων μὴ κλέπτειν, κλέπτεις; ");
INSERT INTO grctr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ὁ λέγων μὴ μοιχεύειν, μοιχεύεις; Ὁ βδελυσσόμενος τὰ εἴδωλα, ἱεροσυλεῖς; ");
INSERT INTO grctr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ὃς ἐν νόμῳ καυχᾶσαι, διὰ τῆς παραβάσεως τοῦ νόμου τὸν Θεὸν ἀτιμάζεις; ");
INSERT INTO grctr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Τὸ γὰρ ὄνομα τοῦ Θεοῦ δι᾿ ὑμᾶς βλασφημεῖται ἐν τοῖς ἔθνεσι, καθὼς γέγραπται. ");
INSERT INTO grctr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Περιτομὴ μὲν γὰρ ὠφελεῖ, ἐὰν νόμον πράσσῃς· ἐὰν δὲ παραβάτης νόμου ᾖς, ἡ περιτομή σου ἀκροβυστία γέγονεν. ");
INSERT INTO grctr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ἐὰν οὖν ἡ ἀκροβυστία τὰ δικαιώματα τοῦ νόμου φυλάσσῃ, οὐχὶ ἡ ἀκροβυστία αὐτοῦ εἰς περιτομὴν λογισθήσεται; ");
INSERT INTO grctr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Καὶ κρινεῖ ἡ ἐκ φύσεως ἀκροβυστία, τὸν νόμον τελοῦσα, σὲ τὸν διὰ γράμματος καὶ περιτομῆς παραβάτην νόμου; ");
INSERT INTO grctr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Οὐ γὰρ ὁ ἐν τῷ φανερῷ Ἰουδαῖός ἐστιν, οὐδὲ ἡ ἐν τῷ φανερῷ ἐν σαρκὶ περιτομή· ");
INSERT INTO grctr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ἀλλ᾿ ὁ ἐν τῷ κρυπτῷ Ἰουδαῖος, καὶ περιτομὴ καρδίας ἐν πνεύματι, οὐ γράμματι· οὗ ὁ ἔπαινος οὐκ ἐξ ἀνθρώπων, ἀλλ᾿ ἐκ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Τί οὖν τὸ περισσὸν τοῦ Ἰουδαίου, ἢ τίς ἡ ὠφέλεια τῆς περιτομῆς; ");
INSERT INTO grctr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Πολὺ κατὰ πάντα τρόπον· πρῶτον μὲν γὰρ ὅτι ἐπιστεύθησαν τὰ λόγια τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Τί γὰρ εἰ ἠπίστησάν τινες; Μὴ ἡ ἀπιστία αὐτῶν τὴν πίστιν τοῦ Θεοῦ καταργήσει; ");
INSERT INTO grctr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Μὴ γένοιτο· γινέσθω δὲ ὁ Θεὸς ἀληθής, πᾶς δὲ ἄνθρωπος ψεύστης, καθὼς γέγραπται, Ὅπως ἂν δικαιωθῇς ἐν τοῖς λόγοις σου, καὶ νικήσῃς ἐν τῷ κρίνεσθαί σε. ");
INSERT INTO grctr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Εἰ δὲ ἡ ἀδικία ἡμῶν Θεοῦ δικαιοσύνην συνίστησι, τί ἐροῦμεν; Μὴ ἄδικος ὁ Θεὸς ὁ ἐπιφέρων τὴν ὀργήν; — κατὰ ἄνθρωπον λέγω — ");
INSERT INTO grctr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Μὴ γένοιτο· ἐπεὶ πῶς κρινεῖ ὁ Θεὸς τὸν κόσμον; ");
INSERT INTO grctr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Εἰ γὰρ ἡ ἀλήθεια τοῦ Θεοῦ ἐν τῷ ἐμῷ ψεύσματι ἐπερίσσευσεν εἰς τὴν δόξαν αὐτοῦ, τί ἔτι κἀγὼ ὡς ἁμαρτωλὸς κρίνομαι; ");
INSERT INTO grctr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Καὶ μή — καθὼς βλασφημούμεθα, καὶ καθώς φασί τινες ἡμᾶς λέγειν — ὅτι Ποιήσωμεν τὰ κακὰ ἵνα ἔλθῃ τὰ ἀγαθά; Ὧν τὸ κρίμα ἔνδικόν ἐστι. ");
INSERT INTO grctr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Τί οὖν; Προεχόμεθα; Οὐ πάντως· προῃτιασάμεθα γὰρ Ἰουδαίους τε καὶ Ἕλληνας πάντας ὑφ᾿ ἁμαρτίαν εἶναι, ");
INSERT INTO grctr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","καθὼς γέγραπται ὅτι Οὐκ ἔστι δίκαιος οὐδὲ εἷς· ");
INSERT INTO grctr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","οὐκ ἔστιν ὁ συνιῶν, οὐκ ἔστιν ὁ ἐκζητῶν τὸν Θεόν· ");
INSERT INTO grctr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","πάντες ἐξέκλιναν, ἅμα ἠχρειώθησαν· οὐκ ἔστι ποιῶν χρηστότητα, οὐκ ἔστιν ἕως ἑνός· ");
INSERT INTO grctr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","τάφος ἀνεῳγμένος ὁ λάρυγξ αὐτῶν, ταῖς γλώσσαις αὐτῶν ἐδολιοῦσαν· ἰὸς ἀσπίδων ὑπὸ τὰ χείλη αὐτῶν· ");
INSERT INTO grctr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ὧν τὸ στόμα ἀρᾶς καὶ πικρίας γέμει· ");
INSERT INTO grctr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ὀξεῖς οἱ πόδες αὐτῶν ἐκχέαι αἷμα· ");
INSERT INTO grctr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","σύντριμμα καὶ ταλαιπωρία ἐν ταῖς ὁδοῖς αὐτῶν, ");
INSERT INTO grctr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","καὶ ὁδὸν εἰρήνης οὐκ ἔγνωσαν· ");
INSERT INTO grctr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","οὐκ ἔστι φόβος Θεοῦ ἀπέναντι τῶν ὀφθαλμῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Οἴδαμεν δὲ ὅτι ὅσα ὁ νόμος λέγει, τοῖς ἐν τῷ νόμῳ λαλεῖ, ἵνα πᾶν στόμα φραγῇ, καὶ ὑπόδικος γένηται πᾶς ὁ κόσμος τῷ Θεῷ· ");
INSERT INTO grctr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","διότι ἐξ ἔργων νόμου οὐ δικαιωθήσεται πᾶσα σὰρξ ἐνώπιον αὐτοῦ· διὰ γὰρ νόμου ἐπίγνωσις ἁμαρτίας. ");
INSERT INTO grctr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Νυνὶ δὲ χωρὶς νόμου δικαιοσύνη Θεοῦ πεφανέρωται, μαρτυρουμένη ὑπὸ τοῦ νόμου καὶ τῶν προφητῶν· ");
INSERT INTO grctr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","δικαιοσύνη δὲ Θεοῦ διὰ πίστεως Ἰησοῦ Χριστοῦ εἰς πάντας καὶ ἐπὶ πάντας τοὺς πιστεύοντας· οὐ γάρ ἐστι διαστολή· ");
INSERT INTO grctr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","πάντες γὰρ ἥμαρτον καὶ ὑστεροῦνται τῆς δόξης τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","δικαιούμενοι δωρεὰν τῇ αὐτοῦ χάριτι διὰ τῆς ἀπολυτρώσεως τῆς ἐν Χριστῷ Ἰησοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ὃν προέθετο ὁ Θεὸς ἱλαστήριον, διὰ τῆς πίστεως, ἐν τῷ αὐτοῦ αἵματι, εἰς ἔνδειξιν τῆς δικαιοσύνης αὐτοῦ, διὰ τὴν πάρεσιν τῶν προγεγονότων ἁμαρτημάτων, ");
INSERT INTO grctr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ἐν τῇ ἀνοχῇ τοῦ Θεοῦ· πρὸς ἔνδειξιν τῆς δικαιοσύνης αὐτοῦ ἐν τῷ νῦν καιρῷ, εἰς τὸ εἶναι αὐτὸν δίκαιον καὶ δικαιοῦντα τὸν ἐκ πίστεως Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ποῦ οὖν ἡ καύχησις; Ἐξεκλείσθη. Διὰ ποίου νόμου; Τῶν ἔργων; Οὐχί, ἀλλὰ διὰ νόμου πίστεως. ");
INSERT INTO grctr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Λογιζόμεθα οὖν πίστει δικαιοῦσθαι ἄνθρωπον, χωρὶς ἔργων νόμου. ");
INSERT INTO grctr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ἢ Ἰουδαίων ὁ Θεὸς μόνον; Οὐχὶ δὲ καὶ ἐθνῶν; Ναὶ καὶ ἐθνῶν· ");
INSERT INTO grctr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ἐπείπερ εἷς ὁ Θεός, ὃς δικαιώσει περιτομὴν ἐκ πίστεως, καὶ ἀκροβυστίαν διὰ τῆς πίστεως. ");
INSERT INTO grctr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Νόμον οὖν καταργοῦμεν διὰ τῆς πίστεως; Μὴ γένοιτο· ἀλλὰ νόμον ἱστῶμεν. ");
INSERT INTO grctr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Τί οὖν ἐροῦμεν Ἀβραὰμ τὸν πατέρα ἡμῶν εὑρηκέναι κατὰ σάρκα; ");
INSERT INTO grctr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Εἰ γὰρ Ἀβραὰμ ἐξ ἔργων ἐδικαιώθη, ἔχει καύχημα, ἀλλ᾿ οὐ πρὸς τὸν Θεόν. ");
INSERT INTO grctr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Τί γὰρ ἡ γραφὴ λέγει; Ἐπίστευσε δὲ Ἀβραὰμ τῷ Θεῷ, καὶ ἐλογίσθη αὐτῷ εἰς δικαιοσύνην. ");
INSERT INTO grctr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Τῷ δὲ ἐργαζομένῳ ὁ μισθὸς οὐ λογίζεται κατὰ χάριν, ἀλλὰ κατὰ τὸ ὀφείλημα. ");
INSERT INTO grctr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Τῷ δὲ μὴ ἐργαζομένῳ, πιστεύοντι δὲ ἐπὶ τὸν δικαιοῦντα τὸν ἀσεβῆ, λογίζεται ἡ πίστις αὐτοῦ εἰς δικαιοσύνην. ");
INSERT INTO grctr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Καθάπερ καὶ Δαβὶδ λέγει τὸν μακαρισμὸν τοῦ ἀνθρώπου, ᾧ ὁ Θεὸς λογίζεται δικαιοσύνην χωρὶς ἔργων, ");
INSERT INTO grctr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Μακάριοι ὧν ἀφέθησαν αἱ ἀνομίαι, καὶ ὧν ἐπεκαλύφθησαν αἱ ἁμαρτίαι. ");
INSERT INTO grctr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Μακάριος ἀνὴρ ᾧ οὐ μὴ λογίσηται Κύριος ἁμαρτίαν. ");
INSERT INTO grctr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ὁ μακαρισμὸς οὖν οὗτος ἐπὶ τὴν περιτομήν, ἢ καὶ ἐπὶ τὴν ἀκροβυστίαν; Λέγομεν γὰρ ὅτι Ἐλογίσθη τῷ Ἀβραὰμ ἡ πίστις εἰς δικαιοσύνην. ");
INSERT INTO grctr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Πῶς οὖν ἐλογίσθη; Ἐν περιτομῇ ὄντι, ἢ ἐν ἀκροβυστίᾳ; Οὐκ ἐν περιτομῇ, ἀλλ᾿ ἐν ἀκροβυστίᾳ· ");
INSERT INTO grctr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","καὶ σημεῖον ἔλαβε περιτομῆς, σφραγῖδα τῆς δικαιοσύνης τῆς πίστεως τῆς ἐν τῇ ἀκροβυστίᾳ· εἰς τὸ εἶναι αὐτὸν πατέρα πάντων τῶν πιστευόντων δι᾿ ἀκροβυστίας, εἰς τὸ λογισθῆναι καὶ αὐτοῖς τὴν δικαιοσύνην· ");
INSERT INTO grctr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","καὶ πατέρα περιτομῆς τοῖς οὐκ ἐκ περιτομῆς μόνον, ἀλλὰ καὶ τοῖς στοιχοῦσι τοῖς ἴχνεσι τῆς ἐν τῇ ἀκροβυστίᾳ πίστεως τοῦ πατρὸς ἡμῶν Ἀβραάμ. ");
INSERT INTO grctr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Οὐ γὰρ διὰ νόμου ἡ ἐπαγγελία τῷ Ἀβραὰμ ἢ τῷ σπέρματι αὐτοῦ, τὸ κληρονόμον αὐτὸν εἶναι τοῦ κόσμου, ἀλλὰ διὰ δικαιοσύνης πίστεως. ");
INSERT INTO grctr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Εἰ γὰρ οἱ ἐκ νόμου κληρονόμοι, κεκένωται ἡ πίστις, καὶ κατήργηται ἡ ἐπαγγελία· ");
INSERT INTO grctr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ὁ γὰρ νόμος ὀργὴν κατεργάζεται· οὗ γὰρ οὐκ ἔστι νόμος, οὐδὲ παράβασις. ");
INSERT INTO grctr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Διὰ τοῦτο ἐκ πίστεως, ἵνα κατὰ χάριν, εἰς τὸ εἶναι βεβαίαν τὴν ἐπαγγελίαν παντὶ τῷ σπέρματι, οὐ τῷ ἐκ τοῦ νόμου μόνον, ἀλλὰ καὶ τῷ ἐκ πίστεως Ἀβραάμ, ὅς ἐστι πατὴρ πάντων ἡμῶν — ");
INSERT INTO grctr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","καθὼς γέγραπται ὅτι Πατέρα πολλῶν ἐθνῶν τέθεικά σε — κατέναντι οὗ ἐπίστευσε Θεοῦ, τοῦ ζῳοποιοῦντος τοὺς νεκρούς, καὶ καλοῦντος τὰ μὴ ὄντα ὡς ὄντα. ");
INSERT INTO grctr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ὃς παρ᾿ ἐλπίδα ἐπ᾿ ἐλπίδι ἐπίστευσεν, εἰς τὸ γενέσθαι αὐτὸν πατέρα πολλῶν ἐθνῶν, κατὰ τὸ εἰρημένον, Οὕτως ἔσται τὸ σπέρμα σου. ");
INSERT INTO grctr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Καὶ μὴ ἀσθενήσας τῇ πίστει, οὐ κατενόησε τὸ ἑαυτοῦ σῶμα ἤδη νενεκρωμένον — ἑκατονταέτης που ὑπάρχων — καὶ τὴν νέκρωσιν τῆς μήτρας Σάρρας· ");
INSERT INTO grctr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","εἰς δὲ τὴν ἐπαγγελίαν τοῦ Θεοῦ οὐ διεκρίθη τῇ ἀπιστίᾳ, ἀλλ᾿ ἐνεδυναμώθη τῇ πίστει, δοὺς δόξαν τῷ Θεῷ, ");
INSERT INTO grctr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","καὶ πληροφορηθεὶς ὅτι ὃ ἐπήγγελται, δυνατός ἐστι καὶ ποιῆσαι. ");
INSERT INTO grctr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Διὸ καὶ ἐλογίσθη αὐτῷ εἰς δικαιοσύνην. ");
INSERT INTO grctr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Οὐκ ἐγράφη δὲ δι᾿ αὐτὸν μόνον, ὅτι ἐλογίσθη αὐτῷ· ");
INSERT INTO grctr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ἀλλὰ καὶ δι᾿ ἡμᾶς, οἷς μέλλει λογίζεσθαι, τοῖς πιστεύουσιν ἐπὶ τὸν ἐγείραντα Ἰησοῦν τὸν Κύριον ἡμῶν ἐκ νεκρῶν, ");
INSERT INTO grctr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ὃς παρεδόθη διὰ τὰ παραπτώματα ἡμῶν, καὶ ἠγέρθη διὰ τὴν δικαίωσιν ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Δικαιωθέντες οὖν ἐκ πίστεως, εἰρήνην ἔχομεν πρὸς τὸν Θεὸν διὰ τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","δι᾿ οὗ καὶ τὴν προσαγωγὴν ἐσχήκαμεν τῇ πίστει εἰς τὴν χάριν ταύτην ἐν ᾗ ἑστήκαμεν, καὶ καυχώμεθα ἐπ᾿ ἐλπίδι τῆς δόξης τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Οὐ μόνον δέ, ἀλλὰ καὶ καυχώμεθα ἐν ταῖς θλίψεσιν, εἰδότες ὅτι ἡ θλίψις ὑπομονὴν κατεργάζεται, ");
INSERT INTO grctr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ἡ δὲ ὑπομονὴ δοκιμήν, ἡ δὲ δοκιμὴ ἐλπίδα· ");
INSERT INTO grctr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ἡ δὲ ἐλπὶς οὐ καταισχύνει, ὅτι ἡ ἀγάπη τοῦ Θεοῦ ἐκκέχυται ἐν ταῖς καρδίαις ἡμῶν διὰ πνεύματος ἁγίου τοῦ δοθέντος ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ἔτι γὰρ Χριστός, ὄντων ἡμῶν ἀσθενῶν, κατὰ καιρὸν ὑπὲρ ἀσεβῶν ἀπέθανε. ");
INSERT INTO grctr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Μόλις γὰρ ὑπὲρ δικαίου τις ἀποθανεῖται· ὑπὲρ γὰρ τοῦ ἀγαθοῦ τάχα τις καὶ τολμᾷ ἀποθανεῖν. ");
INSERT INTO grctr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Συνίστησι δὲ τὴν ἑαυτοῦ ἀγάπην εἰς ἡμᾶς ὁ Θεός, ὅτι ἔτι ἁμαρτωλῶν ὄντων ἡμῶν Χριστὸς ὑπὲρ ἡμῶν ἀπέθανε. ");
INSERT INTO grctr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Πολλῷ οὖν μᾶλλον, δικαιωθέντες νῦν ἐν τῷ αἵματι αὐτοῦ, σωθησόμεθα δι᾿ αὐτοῦ ἀπὸ τῆς ὀργῆς. ");
INSERT INTO grctr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Εἰ γὰρ ἐχθροὶ ὄντες κατηλλάγημεν τῷ Θεῷ διὰ τοῦ θανάτου τοῦ υἱοῦ αὐτοῦ, πολλῷ μᾶλλον καταλλαγέντες σωθησόμεθα ἐν τῇ ζωῇ αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","οὐ μόνον δέ, ἀλλὰ καὶ καυχώμενοι ἐν τῷ Θεῷ διὰ τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, δι᾿ οὗ νῦν τὴν καταλλαγὴν ἐλάβομεν. ");
INSERT INTO grctr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Διὰ τοῦτο, ὥσπερ δι᾿ ἑνὸς ἀνθρώπου ἡ ἁμαρτία εἰς τὸν κόσμον εἰσῆλθε, καὶ διὰ τῆς ἁμαρτίας ὁ θάνατος, καὶ οὕτως εἰς πάντας ἀνθρώπους ὁ θάνατος διῆλθεν, ἐφ᾿ ᾧ πάντες ἥμαρτον — ");
INSERT INTO grctr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ἄχρι γὰρ νόμου ἁμαρτία ἦν ἐν κόσμῳ· ἁμαρτία δὲ οὐκ ἐλλογεῖται, μὴ ὄντος νόμου. ");
INSERT INTO grctr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ἀλλ᾿ ἐβασίλευσεν ὁ θάνατος ἀπὸ Ἀδὰμ μέχρι Μωσέως καὶ ἐπὶ τοὺς μὴ ἁμαρτήσαντας ἐπὶ τῷ ὁμοιώματι τῆς παραβάσεως Ἀδάμ, ὅς ἐστι τύπος τοῦ μέλλοντος. ");
INSERT INTO grctr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ἀλλ᾿ οὐχ ὡς τὸ παράπτωμα, οὕτω καὶ τὸ χάρισμα. Εἰ γὰρ τῷ τοῦ ἑνὸς παραπτώματι οἱ πολλοὶ ἀπέθανον, πολλῷ μᾶλλον ἡ χάρις τοῦ Θεοῦ καὶ ἡ δωρεὰ ἐν χάριτι τῇ τοῦ ἑνὸς ἀνθρώπου Ἰησοῦ Χριστοῦ εἰς τοὺς πολλοὺς ἐπερίσσευσε. ");
INSERT INTO grctr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Καὶ οὐχ ὡς δι᾿ ἑνὸς ἁμαρτήσαντος, τὸ δώρημα· τὸ μὲν γὰρ κρίμα ἐξ ἑνὸς εἰς κατάκριμα, τὸ δὲ χάρισμα ἐκ πολλῶν παραπτωμάτων εἰς δικαίωμα. ");
INSERT INTO grctr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Εἰ γὰρ τῷ τοῦ ἑνὸς παραπτώματι ὁ θάνατος ἐβασίλευσε διὰ τοῦ ἑνός, πολλῷ μᾶλλον οἱ τὴν περισσείαν τῆς χάριτος καὶ τῆς δωρεᾶς τῆς δικαιοσύνης λαμβάνοντες ἐν ζωῇ βασιλεύσουσι διὰ τοῦ ἑνὸς Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ἄρα οὖν ὡς δι᾿ ἑνὸς παραπτώματος εἰς πάντας ἀνθρώπους εἰς κατάκριμα, οὕτω καὶ δι᾿ ἑνὸς δικαιώματος εἰς πάντας ἀνθρώπους εἰς δικαίωσιν ζωῆς. ");
INSERT INTO grctr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ὥσπερ γὰρ διὰ τῆς παρακοῆς τοῦ ἑνὸς ἀνθρώπου ἁμαρτωλοὶ κατεστάθησαν οἱ πολλοί, οὕτω καὶ διὰ τῆς ὑπακοῆς τοῦ ἑνὸς δίκαιοι κατασταθήσονται οἱ πολλοί. ");
INSERT INTO grctr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Νόμος δὲ παρεισῆλθεν, ἵνα πλεονάσῃ τὸ παράπτωμα· οὗ δὲ ἐπλεόνασεν ἡ ἁμαρτία, ὑπερεπερίσσευσεν ἡ χάρις· ");
INSERT INTO grctr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ἵνα ὥσπερ ἐβασίλευσεν ἡ ἁμαρτία ἐν τῷ θανάτῳ, οὕτω καὶ ἡ χάρις βασιλεύσῃ διὰ δικαιοσύνης εἰς ζωὴν αἰώνιον, διὰ Ἰησοῦ Χριστοῦ τοῦ Κυρίου ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Τί οὖν ἐροῦμεν; Ἐπιμενοῦμεν τῇ ἁμαρτίᾳ, ἵνα ἡ χάρις πλεονάσῃ; ");
INSERT INTO grctr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Μὴ γένοιτο. Οἵτινες ἀπεθάνομεν τῇ ἁμαρτίᾳ, πῶς ἔτι ζήσομεν ἐν αὐτῇ; ");
INSERT INTO grctr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ἢ ἀγνοεῖτε ὅτι ὅσοι ἐβαπτίσθημεν εἰς Χριστὸν Ἰησοῦν, εἰς τὸν θάνατον αὐτοῦ ἐβαπτίσθημεν; ");
INSERT INTO grctr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Συνετάφημεν οὖν αὐτῷ διὰ τοῦ βαπτίσματος εἰς τὸν θάνατον· ἵνα ὥσπερ ἠγέρθη Χριστὸς ἐκ νεκρῶν διὰ τῆς δόξης τοῦ πατρός, οὕτω καὶ ἡμεῖς ἐν καινότητι ζωῆς περιπατήσωμεν. ");
INSERT INTO grctr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Εἰ γὰρ σύμφυτοι γεγόναμεν τῷ ὁμοιώματι τοῦ θανάτου αὐτοῦ, ἀλλὰ καὶ τῆς ἀναστάσεως ἐσόμεθα· ");
INSERT INTO grctr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","τοῦτο γινώσκοντες, ὅτι ὁ παλαιὸς ἡμῶν ἄνθρωπος συνεσταυρώθη, ἵνα καταργηθῇ τὸ σῶμα τῆς ἁμαρτίας, τοῦ μηκέτι δουλεύειν ἡμᾶς τῇ ἁμαρτίᾳ· ");
INSERT INTO grctr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ὁ γὰρ ἀποθανὼν δεδικαίωται ἀπὸ τῆς ἁμαρτίας. ");
INSERT INTO grctr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Εἰ δὲ ἀπεθάνομεν σὺν Χριστῷ, πιστεύομεν ὅτι καὶ συζήσομεν αὐτῷ· ");
INSERT INTO grctr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","εἰδότες ὅτι Χριστὸς ἐγερθεὶς ἐκ νεκρῶν οὐκέτι ἀποθνῄσκει· θάνατος αὐτοῦ οὐκέτι κυριεύει. ");
INSERT INTO grctr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ὃ γὰρ ἀπέθανε, τῇ ἁμαρτίᾳ ἀπέθανεν ἐφάπαξ· ὃ δὲ ζῇ, ζῇ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Οὕτω καὶ ὑμεῖς λογίζεσθε ἑαυτοὺς νεκροὺς μὲν εἶναι τῇ ἁμαρτίᾳ, ζῶντας δὲ τῷ Θεῷ ἐν Χριστῷ Ἰησοῦ τῷ Κυρίῳ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Μὴ οὖν βασιλευέτω ἡ ἁμαρτία ἐν τῷ θνητῷ ὑμῶν σώματι, εἰς τὸ ὑπακούειν αὐτῇ ἐν ταῖς ἐπιθυμίαις αὐτοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","μηδὲ παριστάνετε τὰ μέλη ὑμῶν ὅπλα ἀδικίας τῇ ἁμαρτίᾳ· ἀλλὰ παραστήσατε ἑαυτοὺς τῷ Θεῷ ὡς ἐκ νεκρῶν ζῶντας, καὶ τὰ μέλη ὑμῶν ὅπλα δικαιοσύνης τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ἁμαρτία γὰρ ὑμῶν οὐ κυριεύσει· οὐ γάρ ἐστε ὑπὸ νόμον, ἀλλ᾿ ὑπὸ χάριν. ");
INSERT INTO grctr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Τί οὖν; Ἁμαρτήσομεν, ὅτι οὐκ ἐσμὲν ὑπὸ νόμον, ἀλλ᾿ ὑπὸ χάριν; Μὴ γένοιτο. ");
INSERT INTO grctr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Οὐκ οἴδατε ὅτι ᾧ παριστάνετε ἑαυτοὺς δούλους εἰς ὑπακοήν, δοῦλοί ἐστε ᾧ ὑπακούετε, ἤτοι ἁμαρτίας εἰς θάνατον, ἢ ὑπακοῆς εἰς δικαιοσύνην; ");
INSERT INTO grctr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Χάρις δὲ τῷ Θεῷ, ὅτι ἦτε δοῦλοι τῆς ἁμαρτίας, ὑπηκούσατε δὲ ἐκ καρδίας εἰς ὃν παρεδόθητε τύπον διδαχῆς· ");
INSERT INTO grctr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ἐλευθερωθέντες δὲ ἀπὸ τῆς ἁμαρτίας, ἐδουλώθητε τῇ δικαιοσύνῃ. ");
INSERT INTO grctr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ἀνθρώπινον λέγω διὰ τὴν ἀσθένειαν τῆς σαρκὸς ὑμῶν· ὥσπερ γὰρ παρεστήσατε τὰ μέλη ὑμῶν δοῦλα τῇ ἀκαθαρσίᾳ καὶ τῇ ἀνομίᾳ εἰς τὴν ἀνομίαν, οὕτω νῦν παραστήσατε τὰ μέλη ὑμῶν δοῦλα τῇ δικαιοσύνῃ εἰς ἁγιασμόν. ");
INSERT INTO grctr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ὅτε γὰρ δοῦλοι ἦτε τῆς ἁμαρτίας, ἐλεύθεροι ἦτε τῇ δικαιοσύνῃ. ");
INSERT INTO grctr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Τίνα οὖν καρπὸν εἴχετε τότε ἐφ᾿ οἷς νῦν ἐπαισχύνεσθε; Τὸ γὰρ τέλος ἐκείνων θάνατος. ");
INSERT INTO grctr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Νυνὶ δὲ ἐλευθερωθέντες ἀπὸ τῆς ἁμαρτίας, δουλωθέντες δὲ τῷ Θεῷ, ἔχετε τὸν καρπὸν ὑμῶν εἰς ἁγιασμόν, τὸ δὲ τέλος ζωὴν αἰώνιον. ");
INSERT INTO grctr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Τὰ γὰρ ὀψώνια τῆς ἁμαρτίας θάνατος, τὸ δὲ χάρισμα τοῦ Θεοῦ ζωὴ αἰώνιος ἐν Χριστῷ Ἰησοῦ τῷ Κυρίῳ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ἢ ἀγνοεῖτε, ἀδελφοί — γινώσκουσι γὰρ νόμον λαλῶ — ὅτι ὁ νόμος κυριεύει τοῦ ἀνθρώπου ἐφ᾿ ὅσον χρόνον ζῇ; ");
INSERT INTO grctr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ἡ γὰρ ὕπανδρος γυνὴ τῷ ζῶντι ἀνδρὶ δέδεται νόμῳ· ἐὰν δὲ ἀποθάνῃ ὁ ἀνήρ, κατήργηται ἀπὸ τοῦ νόμου τοῦ ἀνδρός. ");
INSERT INTO grctr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ἄρα οὖν ζῶντος τοῦ ἀνδρὸς μοιχαλὶς χρηματίσει, ἐὰν γένηται ἀνδρὶ ἑτέρῳ· ἐὰν δὲ ἀποθάνῃ ὁ ἀνήρ, ἐλευθέρα ἐστὶν ἀπὸ τοῦ νόμου, τοῦ μὴ εἶναι αὐτὴν μοιχαλίδα, γενομένην ἀνδρὶ ἑτέρῳ. ");
INSERT INTO grctr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ὥστε, ἀδελφοί μου, καὶ ὑμεῖς ἐθανατώθητε τῷ νόμῳ διὰ τοῦ σώματος τοῦ Χριστοῦ, εἰς τὸ γενέσθαι ὑμᾶς ἑτέρῳ, τῷ ἐκ νεκρῶν ἐγερθέντι, ἵνα καρποφορήσωμεν τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ὅτε γὰρ ἦμεν ἐν τῇ σαρκί, τὰ παθήματα τῶν ἁμαρτιῶν τὰ διὰ τοῦ νόμου ἐνηργεῖτο ἐν τοῖς μέλεσιν ἡμῶν εἰς τὸ καρποφορῆσαι τῷ θανάτῳ. ");
INSERT INTO grctr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Νυνὶ δὲ κατηργήθημεν ἀπὸ τοῦ νόμου, ἀποθανόντος ἐν ᾧ κατειχόμεθα, ὥστε δουλεύειν ἡμᾶς ἐν καινότητι πνεύματος, καὶ οὐ παλαιότητι γράμματος. ");
INSERT INTO grctr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Τί οὖν ἐροῦμεν; Ὁ νόμος ἁμαρτία; Μὴ γένοιτο· ἀλλὰ τὴν ἁμαρτίαν οὐκ ἔγνων, εἰ μὴ διὰ νόμου· τήν τε γὰρ ἐπιθυμίαν οὐκ ᾔδειν, εἰ μὴ ὁ νόμος ἔλεγεν, Οὐκ ἐπιθυμήσεις· ");
INSERT INTO grctr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ἀφορμὴν δὲ λαβοῦσα ἡ ἁμαρτία διὰ τῆς ἐντολῆς κατειργάσατο ἐν ἐμοὶ πᾶσαν ἐπιθυμίαν· χωρὶς γὰρ νόμου ἁμαρτία νεκρά. ");
INSERT INTO grctr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ἐγὼ δὲ ἔζων χωρὶς νόμου ποτέ· ἐλθούσης δὲ τῆς ἐντολῆς, ἡ ἁμαρτία ἀνέζησεν, ἐγὼ δὲ ἀπέθανον· ");
INSERT INTO grctr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","καὶ εὑρέθη μοι ἡ ἐντολὴ ἡ εἰς ζωήν, αὕτη εἰς θάνατον· ");
INSERT INTO grctr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ἡ γὰρ ἁμαρτία ἀφορμὴν λαβοῦσα διὰ τῆς ἐντολῆς ἐξηπάτησέ με, καὶ δι᾿ αὐτῆς ἀπέκτεινεν. ");
INSERT INTO grctr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ὥστε ὁ μὲν νόμος ἅγιος, καὶ ἡ ἐντολὴ ἁγία καὶ δικαία καὶ ἀγαθή. ");
INSERT INTO grctr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Τὸ οὖν ἀγαθὸν ἐμοὶ γέγονε θάνατος; Μὴ γένοιτο. Ἀλλὰ ἡ ἁμαρτία, ἵνα φανῇ ἁμαρτία, διὰ τοῦ ἀγαθοῦ μοι κατεργαζομένη θάνατον — ἵνα γένηται καθ᾿ ὑπερβολὴν ἁμαρτωλὸς ἡ ἁμαρτία διὰ τῆς ἐντολῆς. ");
INSERT INTO grctr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Οἴδαμεν γὰρ ὅτι ὁ νόμος πνευματικός ἐστιν· ἐγὼ δὲ σαρκικός εἰμι, πεπραμένος ὑπὸ τὴν ἁμαρτίαν. ");
INSERT INTO grctr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ὃ γὰρ κατεργάζομαι, οὐ γινώσκω· οὐ γὰρ ὃ θέλω, τοῦτο πράσσω· ἀλλ᾿ ὃ μισῶ, τοῦτο ποιῶ. ");
INSERT INTO grctr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Εἰ δὲ ὃ οὐ θέλω, τοῦτο ποιῶ, σύμφημι τῷ νόμῳ ὅτι καλός. ");
INSERT INTO grctr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Νυνὶ δὲ οὐκέτι ἐγὼ κατεργάζομαι αὐτό, ἀλλ᾿ ἡ οἰκοῦσα ἐν ἐμοὶ ἁμαρτία. ");
INSERT INTO grctr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Οἶδα γὰρ ὅτι οὐκ οἰκεῖ ἐν ἐμοί, τοῦτ᾿ ἔστιν ἐν τῇ σαρκί μου, ἀγαθόν· τὸ γὰρ θέλειν παράκειταί μοι, τὸ δὲ κατεργάζεσθαι τὸ καλὸν οὐχ εὑρίσκω. ");
INSERT INTO grctr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Οὐ γὰρ ὃ θέλω, ποιῶ ἀγαθόν· ἀλλ᾿ ὃ οὐ θέλω κακόν, τοῦτο πράσσω. ");
INSERT INTO grctr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Εἰ δὲ ὃ οὐ θέλω ἐγώ, τοῦτο ποιῶ, οὐκέτι ἐγὼ κατεργάζομαι αὐτό, ἀλλ᾿ ἡ οἰκοῦσα ἐν ἐμοὶ ἁμαρτία. ");
INSERT INTO grctr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Εὑρίσκω ἄρα τὸν νόμον τῷ θέλοντι ἐμοὶ ποιεῖν τὸ καλόν, ὅτι ἐμοὶ τὸ κακὸν παράκειται. ");
INSERT INTO grctr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Συνήδομαι γὰρ τῷ νόμῳ τοῦ Θεοῦ κατὰ τὸν ἔσω ἄνθρωπον· ");
INSERT INTO grctr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","βλέπω δὲ ἕτερον νόμον ἐν τοῖς μέλεσί μου ἀντιστρατευόμενον τῷ νόμῳ τοῦ νοός μου, καὶ αἰχμαλωτίζοντά με τῷ νόμῳ τῆς ἁμαρτίας τῷ ὄντι ἐν τοῖς μέλεσί μου. ");
INSERT INTO grctr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ταλαίπωρος ἐγὼ ἄνθρωπος· τίς με ῥύσεται ἐκ τοῦ σώματος τοῦ θανάτου τούτου; ");
INSERT INTO grctr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Εὐχαριστῶ τῷ Θεῷ διὰ Ἰησοῦ Χριστοῦ τοῦ Κυρίου ἡμῶν. Ἄρα οὖν αὐτὸς ἐγὼ τῷ μὲν νοῒ δουλεύω νόμῳ Θεοῦ, τῇ δὲ σαρκὶ νόμῳ ἁμαρτίας. ");
INSERT INTO grctr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Οὐδὲν ἄρα νῦν κατάκριμα τοῖς ἐν Χριστῷ Ἰησοῦ, μὴ κατὰ σάρκα περιπατοῦσιν, ἀλλὰ κατὰ πνεῦμα. ");
INSERT INTO grctr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ὁ γὰρ νόμος τοῦ πνεύματος τῆς ζωῆς ἐν Χριστῷ Ἰησοῦ ἠλευθέρωσέ με ἀπὸ τοῦ νόμου τῆς ἁμαρτίας καὶ τοῦ θανάτου. ");
INSERT INTO grctr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Τὸ γὰρ ἀδύνατον τοῦ νόμου, ἐν ᾧ ἠσθένει διὰ τῆς σαρκός, ὁ Θεὸς τὸν ἑαυτοῦ υἱὸν πέμψας ἐν ὁμοιώματι σαρκὸς ἁμαρτίας καὶ περὶ ἁμαρτίας κατέκρινε τὴν ἁμαρτίαν ἐν τῇ σαρκί· ");
INSERT INTO grctr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ἵνα τὸ δικαίωμα τοῦ νόμου πληρωθῇ ἐν ἡμῖν, τοῖς μὴ κατὰ σάρκα περιπατοῦσιν, ἀλλὰ κατὰ πνεῦμα. ");
INSERT INTO grctr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Οἱ γὰρ κατὰ σάρκα ὄντες τὰ τῆς σαρκὸς φρονοῦσιν· οἱ δὲ κατὰ πνεῦμα τὰ τοῦ πνεύματος. ");
INSERT INTO grctr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Τὸ γὰρ φρόνημα τῆς σαρκὸς θάνατος· τὸ δὲ φρόνημα τοῦ πνεύματος ζωὴ καὶ εἰρήνη· ");
INSERT INTO grctr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","διότι τὸ φρόνημα τῆς σαρκὸς ἔχθρα εἰς Θεόν, τῷ γὰρ νόμῳ τοῦ Θεοῦ οὐχ ὑποτάσσεται, οὐδὲ γὰρ δύναται· ");
INSERT INTO grctr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","οἱ δὲ ἐν σαρκὶ ὄντες Θεῷ ἀρέσαι οὐ δύνανται. ");
INSERT INTO grctr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ὑμεῖς δὲ οὐκ ἐστὲ ἐν σαρκί, ἀλλ᾿ ἐν πνεύματι, εἴπερ πνεῦμα Θεοῦ οἰκεῖ ἐν ὑμῖν. Εἰ δέ τις πνεῦμα Χριστοῦ οὐκ ἔχει, οὗτος οὐκ ἔστιν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Εἰ δὲ Χριστὸς ἐν ὑμῖν, τὸ μὲν σῶμα νεκρὸν δι᾿ ἁμαρτίαν, τὸ δὲ πνεῦμα ζωὴ διὰ δικαιοσύνην. ");
INSERT INTO grctr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Εἰ δὲ τὸ πνεῦμα τοῦ ἐγείραντος Ἰησοῦν ἐκ νεκρῶν οἰκεῖ ἐν ὑμῖν, ὁ ἐγείρας τὸν Χριστὸν ἐκ νεκρῶν ζῳοποιήσει καὶ τὰ θνητὰ σώματα ὑμῶν, διὰ τοῦ ἐνοικοῦντος αὐτοῦ πνεύματος ἐν ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ἄρα οὖν, ἀδελφοί, ὀφειλέται ἐσμέν, οὐ τῇ σαρκί, τοῦ κατὰ σάρκα ζῇν· ");
INSERT INTO grctr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","εἰ γὰρ κατὰ σάρκα ζῆτε, μέλλετε ἀποθνῄσκειν· εἰ δὲ πνεύματι τὰς πράξεις τοῦ σώματος θανατοῦτε, ζήσεσθε. ");
INSERT INTO grctr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ὅσοι γὰρ πνεύματι Θεοῦ ἄγονται, οὗτοί εἰσιν υἱοὶ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Οὐ γὰρ ἐλάβετε πνεῦμα δουλείας πάλιν εἰς φόβον, ἀλλ᾿ ἐλάβετε πνεῦμα υἱοθεσίας, ἐν ᾧ κράζομεν, Ἀββᾶ, ὁ πατήρ. ");
INSERT INTO grctr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Αὐτὸ τὸ πνεῦμα συμμαρτυρεῖ τῷ πνεύματι ἡμῶν, ὅτι ἐσμὲν τέκνα Θεοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","εἰ δὲ τέκνα, καὶ κληρονόμοι· κληρονόμοι μὲν Θεοῦ, συγκληρονόμοι δὲ Χριστοῦ· εἴπερ συμπάσχομεν, ἵνα καὶ συνδοξασθῶμεν. ");
INSERT INTO grctr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Λογίζομαι γὰρ ὅτι οὐκ ἄξια τὰ παθήματα τοῦ νῦν καιροῦ πρὸς τὴν μέλλουσαν δόξαν ἀποκαλυφθῆναι εἰς ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ἡ γὰρ ἀποκαραδοκία τῆς κτίσεως τὴν ἀποκάλυψιν τῶν υἱῶν τοῦ Θεοῦ ἀπεκδέχεται. ");
INSERT INTO grctr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Τῇ γὰρ ματαιότητι ἡ κτίσις ὑπετάγη, οὐχ ἑκοῦσα, ἀλλὰ διὰ τὸν ὑποτάξαντα, ἐπ᾿ ἐλπίδι· ");
INSERT INTO grctr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ὅτι καὶ αὐτὴ ἡ κτίσις ἐλευθερωθήσεται ἀπὸ τῆς δουλείας τῆς φθορᾶς εἰς τὴν ἐλευθερίαν τῆς δόξης τῶν τέκνων τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Οἴδαμεν γὰρ ὅτι πᾶσα ἡ κτίσις συστενάζει καὶ συνωδίνει ἄχρι τοῦ νῦν. ");
INSERT INTO grctr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Οὐ μόνον δέ, ἀλλὰ καὶ αὐτοὶ τὴν ἀπαρχὴν τοῦ πνεύματος ἔχοντες, καὶ ἡμεῖς αὐτοὶ ἐν ἑαυτοῖς στενάζομεν, υἱοθεσίαν ἀπεκδεχόμενοι, τὴν ἀπολύτρωσιν τοῦ σώματος ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Τῇ γὰρ ἐλπίδι ἐσώθημεν· ἐλπὶς δὲ βλεπομένη οὐκ ἔστιν ἐλπίς· ὃ γὰρ βλέπει τις, τί καὶ ἐλπίζει; ");
INSERT INTO grctr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Εἰ δὲ ὃ οὐ βλέπομεν ἐλπίζομεν, δι᾿ ὑπομονῆς ἀπεκδεχόμεθα. ");
INSERT INTO grctr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ὡσαύτως δὲ καὶ τὸ πνεῦμα συναντιλαμβάνεται ταῖς ἀσθενείαις ἡμῶν· τὸ γὰρ τί προσευξώμεθα καθὸ δεῖ, οὐκ οἴδαμεν, ἀλλ᾿ αὐτὸ τὸ πνεῦμα ὑπερεντυγχάνει ὑπὲρ ἡμῶν στεναγμοῖς ἀλαλήτοις· ");
INSERT INTO grctr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ὁ δὲ ἐρευνῶν τὰς καρδίας οἶδε τί τὸ φρόνημα τοῦ πνεύματος, ὅτι κατὰ Θεὸν ἐντυγχάνει ὑπὲρ ἁγίων. ");
INSERT INTO grctr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Οἴδαμεν δὲ ὅτι τοῖς ἀγαπῶσι τὸν Θεὸν πάντα συνεργεῖ εἰς ἀγαθόν, τοῖς κατὰ πρόθεσιν κλητοῖς οὖσιν. ");
INSERT INTO grctr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ὅτι οὓς προέγνω, καὶ προώρισε συμμόρφους τῆς εἰκόνος τοῦ υἱοῦ αὐτοῦ, εἰς τὸ εἶναι αὐτὸν πρωτότοκον ἐν πολλοῖς ἀδελφοῖς· ");
INSERT INTO grctr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","οὓς δὲ προώρισε, τούτους καὶ ἐκάλεσε· καὶ οὓς ἐκάλεσε, τούτους καὶ ἐδικαίωσεν· οὓς δὲ ἐδικαίωσε, τούτους καὶ ἐδόξασε. ");
INSERT INTO grctr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Τί οὖν ἐροῦμεν πρὸς ταῦτα; Εἰ ὁ Θεὸς ὑπὲρ ἡμῶν, τίς καθ᾿ ἡμῶν; ");
INSERT INTO grctr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ὅς γε τοῦ ἰδίου υἱοῦ οὐκ ἐφείσατο, ἀλλ᾿ ὑπὲρ ἡμῶν πάντων παρέδωκεν αὐτόν, πῶς οὐχὶ καὶ σὺν αὐτῷ τὰ πάντα ἡμῖν χαρίσεται; ");
INSERT INTO grctr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Τίς ἐγκαλέσει κατὰ ἐκλεκτῶν Θεοῦ; Θεὸς ὁ δικαιῶν· ");
INSERT INTO grctr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","τίς ὁ κατακρίνων; Χριστὸς ὁ ἀποθανών, μᾶλλον δὲ καὶ ἐγερθείς, ὃς καὶ ἔστιν ἐν δεξιᾷ τοῦ Θεοῦ, ὃς καὶ ἐντυγχάνει ὑπὲρ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Τίς ἡμᾶς χωρίσει ἀπὸ τῆς ἀγάπης τοῦ Χριστοῦ; Θλίψις, ἢ στενοχωρία, ἢ διωγμός, ἢ λιμός, ἢ γυμνότης, ἢ κίνδυνος, ἢ μάχαιρα; ");
INSERT INTO grctr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Καθὼς γέγραπται ὅτι Ἕνεκά σου θανατούμεθα ὅλην τὴν ἡμέραν· ἐλογίσθημεν ὡς πρόβατα σφαγῆς. ");
INSERT INTO grctr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ἀλλ᾿ ἐν τούτοις πᾶσιν ὑπερνικῶμεν διὰ τοῦ ἀγαπήσαντος ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Πέπεισμαι γὰρ ὅτι οὔτε θάνατος οὔτε ζωὴ οὔτε ἄγγελοι οὔτε ἀρχαὶ οὔτε δυνάμεις οὔτε ἐνεστῶτα οὔτε μέλλοντα ");
INSERT INTO grctr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","οὔτε ὕψωμα οὔτε βάθος οὔτε τις κτίσις ἑτέρα δυνήσεται ἡμᾶς χωρίσαι ἀπὸ τῆς ἀγάπης τοῦ Θεοῦ τῆς ἐν Χριστῷ Ἰησοῦ τῷ Κυρίῳ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ἀλήθειαν λέγω ἐν Χριστῷ, οὐ ψεύδομαι, συμμαρτυρούσης μοι τῆς συνειδήσεώς μου ἐν πνεύματι ἁγίῳ, ");
INSERT INTO grctr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ὅτι λύπη μοι ἐστὶ μεγάλη, καὶ ἀδιάλειπτος ὀδύνη τῇ καρδίᾳ μου. ");
INSERT INTO grctr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ηὐχόμην γὰρ αὐτὸς ἐγὼ ἀνάθεμα εἶναι ἀπὸ τοῦ Χριστοῦ ὑπὲρ τῶν ἀδελφῶν μου, τῶν συγγενῶν μου κατὰ σάρκα· ");
INSERT INTO grctr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","οἵτινές εἰσιν Ἰσραηλῖται, ὧν ἡ υἱοθεσία καὶ ἡ δόξα καὶ αἱ διαθῆκαι καὶ ἡ νομοθεσία καὶ ἡ λατρεία καὶ αἱ ἐπαγγελίαι, ");
INSERT INTO grctr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ὧν οἱ πατέρες, καὶ ἐξ ὧν ὁ Χριστὸς τὸ κατὰ σάρκα, ὁ ὢν ἐπὶ πάντων, Θεὸς εὐλογητὸς εἰς τοὺς αἰῶνας. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Οὐχ οἷον δὲ ὅτι ἐκπέπτωκεν ὁ λόγος τοῦ Θεοῦ. Οὐ γὰρ πάντες οἱ ἐξ Ἰσραήλ, οὗτοι Ἰσραήλ· ");
INSERT INTO grctr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","οὐδ᾿ ὅτι εἰσὶ σπέρμα Ἀβραάμ, πάντες τέκνα· ἀλλ᾿ Ἐν Ἰσαὰκ κληθήσεταί σοι σπέρμα. ");
INSERT INTO grctr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Τοῦτ᾿ ἔστιν, οὐ τὰ τέκνα τῆς σαρκός, ταῦτα τέκνα τοῦ Θεοῦ· ἀλλὰ τὰ τέκνα τῆς ἐπαγγελίας λογίζεται εἰς σπέρμα. ");
INSERT INTO grctr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ἐπαγγελίας γὰρ ὁ λόγος οὗτος, Κατὰ τὸν καιρὸν τοῦτον ἐλεύσομαι, καὶ ἔσται τῇ Σάρρᾳ υἱός. ");
INSERT INTO grctr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Οὐ μόνον δέ, ἀλλὰ καὶ Ῥεβέκκα ἐξ ἑνὸς κοίτην ἔχουσα, Ἰσαὰκ τοῦ πατρὸς ἡμῶν — ");
INSERT INTO grctr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","μήπω γὰρ γεννηθέντων, μηδὲ πραξάντων τι ἀγαθὸν ἢ κακόν, ἵνα ἡ κατ᾿ ἐκλογὴν τοῦ Θεοῦ πρόθεσις μένῃ, οὐκ ἐξ ἔργων, ἀλλ᾿ ἐκ τοῦ καλοῦντος, ");
INSERT INTO grctr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ἐρρήθη αὐτῇ ὅτι Ὁ μείζων δουλεύσει τῷ ἐλάσσονι. ");
INSERT INTO grctr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Καθὼς γέγραπται, Τὸν Ἰακὼβ ἠγάπησα, τὸν δὲ Ἠσαῦ ἐμίσησα. ");
INSERT INTO grctr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Τί οὖν ἐροῦμεν; Μὴ ἀδικία παρὰ τῷ Θεῷ; Μὴ γένοιτο. ");
INSERT INTO grctr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Τῷ γὰρ Μωσῇ λέγει, Ἐλεήσω ὃν ἂν ἐλεῶ, καὶ οἰκτειρήσω ὃν ἂν οἰκτείρω. ");
INSERT INTO grctr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ἄρα οὖν οὐ τοῦ θέλοντος, οὐδὲ τοῦ τρέχοντος, ἀλλὰ τοῦ ἐλεοῦντος Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Λέγει γὰρ ἡ γραφὴ τῷ Φαραὼ ὅτι Εἰς αὐτὸ τοῦτο ἐξήγειρά σε, ὅπως ἐνδείξωμαι ἐν σοὶ τὴν δύναμίν μου, καὶ ὅπως διαγγελῇ τὸ ὄνομά μου ἐν πάσῃ τῇ γῇ. ");
INSERT INTO grctr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ἄρα οὖν ὃν θέλει ἐλεεῖ· ὃν δὲ θέλει σκληρύνει. ");
INSERT INTO grctr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ἐρεῖς οὖν μοι, Τί ἔτι μέμφεται; Τῷ γὰρ βουλήματι αὐτοῦ τίς ἀνθέστηκε; ");
INSERT INTO grctr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Μενοῦνγε, ὦ ἄνθρωπε, σὺ τίς εἶ ὁ ἀνταποκρινόμενος τῷ Θεῷ; Μὴ ἐρεῖ τὸ πλάσμα τῷ πλάσαντι, Τί με ἐποίησας οὕτως; ");
INSERT INTO grctr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ἢ οὐκ ἔχει ἐξουσίαν ὁ κεραμεὺς τοῦ πηλοῦ, ἐκ τοῦ αὐτοῦ φυράματος ποιῆσαι ὃ μὲν εἰς τιμὴν σκεῦος, ὃ δὲ εἰς ἀτιμίαν; ");
INSERT INTO grctr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Εἰ δὲ θέλων ὁ Θεὸς ἐνδείξασθαι τὴν ὀργήν, καὶ γνωρίσαι τὸ δυνατὸν αὐτοῦ, ἤνεγκεν ἐν πολλῇ μακροθυμίᾳ σκεύη ὀργῆς κατηρτισμένα εἰς ἀπώλειαν· ");
INSERT INTO grctr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","καὶ ἵνα γνωρίσῃ τὸν πλοῦτον τῆς δόξης αὐτοῦ ἐπὶ σκεύη ἐλέους, ἃ προητοίμασεν εἰς δόξαν, ");
INSERT INTO grctr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","οὓς καὶ ἐκάλεσεν ἡμᾶς οὐ μόνον ἐξ Ἰουδαίων, ἀλλὰ καὶ ἐξ ἐθνῶν; ");
INSERT INTO grctr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ὡς καὶ ἐν τῷ Ὡσηὲ λέγει, Καλέσω τὸν οὐ λαόν μου λαόν μου· καὶ τὴν οὐκ ἠγαπημένην ἠγαπημένην. ");
INSERT INTO grctr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Καὶ ἔσται, ἐν τῷ τόπῳ οὗ ἐρρήθη αὐτοῖς, Οὐ λαός μου ὑμεῖς, ἐκεῖ κληθήσονται υἱοὶ Θεοῦ ζῶντος. ");
INSERT INTO grctr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ἠσαΐας δὲ κράζει ὑπὲρ τοῦ Ἰσραήλ, Ἐὰν ᾖ ὁ ἀριθμὸς τῶν υἱῶν Ἰσραὴλ ὡς ἡ ἄμμος τῆς θαλάσσης, τὸ κατάλειμμα σωθήσεται· ");
INSERT INTO grctr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","λόγον γὰρ συντελῶν καὶ συντέμνων ἐν δικαιοσύνῃ· ὅτι λόγον συντετμημένον ποιήσει Κύριος ἐπὶ τῆς γῆς. ");
INSERT INTO grctr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Καὶ καθὼς προείρηκεν Ἠσαΐας, Εἰ μὴ Κύριος Σαβαὼθ ἐγκατέλιπεν ἡμῖν σπέρμα, ὡς Σόδομα ἂν ἐγενήθημεν, καὶ ὡς Γόμορρα ἂν ὡμοιώθημεν. ");
INSERT INTO grctr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Τί οὖν ἐροῦμεν; Ὅτι ἔθνη τὰ μὴ διώκοντα δικαιοσύνην, κατέλαβε δικαιοσύνην, δικαιοσύνην δὲ τὴν ἐκ πίστεως· ");
INSERT INTO grctr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ἰσραὴλ δέ, διώκων νόμον δικαιοσύνης, εἰς νόμον δικαιοσύνης οὐκ ἔφθασε. ");
INSERT INTO grctr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Διὰ τί; Ὅτι οὐκ ἐκ πίστεως, ἀλλ᾿ ὡς ἐξ ἔργων νόμου· προσέκοψαν γὰρ τῷ λίθῳ τοῦ προσκόμματος, ");
INSERT INTO grctr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","καθὼς γέγραπται, Ἰδοὺ τίθημι ἐν Σιὼν λίθον προσκόμματος καὶ πέτραν σκανδάλου· καὶ πᾶς ὁ πιστεύων ἐπ᾿ αὐτῷ οὐ καταισχυνθήσεται. ");
INSERT INTO grctr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ἀδελφοί, ἡ μὲν εὐδοκία τῆς ἐμῆς καρδίας καὶ ἡ δέησις ἡ πρὸς τὸν Θεὸν ὑπὲρ τοῦ Ἰσραήλ ἐστιν εἰς σωτηρίαν. ");
INSERT INTO grctr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Μαρτυρῶ γὰρ αὐτοῖς ὅτι ζῆλον Θεοῦ ἔχουσιν, ἀλλ᾿ οὐ κατ᾿ ἐπίγνωσιν. ");
INSERT INTO grctr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ἀγνοοῦντες γὰρ τὴν τοῦ Θεοῦ δικαιοσύνην, καὶ τὴν ἰδίαν δικαιοσύνην ζητοῦντες στῆσαι, τῇ δικαιοσύνῃ τοῦ Θεοῦ οὐχ ὑπετάγησαν. ");
INSERT INTO grctr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Τέλος γὰρ νόμου Χριστὸς εἰς δικαιοσύνην παντὶ τῷ πιστεύοντι. ");
INSERT INTO grctr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Μωσῆς γὰρ γράφει τὴν δικαιοσύνην τὴν ἐκ τοῦ νόμου, ὅτι ὁ ποιήσας αὐτὰ ἄνθρωπος ζήσεται ἐν αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ἡ δὲ ἐκ πίστεως δικαιοσύνη οὕτω λέγει, Μὴ εἴπῃς ἐν τῇ καρδίᾳ σου, Τίς ἀναβήσεται εἰς τὸν οὐρανόν; — τοῦτ᾿ ἔστι Χριστὸν καταγαγεῖν — ");
INSERT INTO grctr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ἤ, Τίς καταβήσεται εἰς τὴν ἄβυσσον; — τοῦτ᾿ ἔστι Χριστὸν ἐκ νεκρῶν ἀναγαγεῖν. ");
INSERT INTO grctr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ἀλλὰ τί λέγει; Ἐγγύς σου τὸ ῥῆμά ἐστιν, ἐν τῷ στόματί σου καὶ ἐν τῇ καρδίᾳ σου· τοῦτ᾿ ἔστι τὸ ῥῆμα τῆς πίστεως ὃ κηρύσσομεν· ");
INSERT INTO grctr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ὅτι ἐὰν ὁμολογήσῃς ἐν τῷ στόματί σου Κύριον Ἰησοῦν, καὶ πιστεύσῃς ἐν τῇ καρδίᾳ σου ὅτι ὁ Θεὸς αὐτὸν ἤγειρεν ἐκ νεκρῶν, σωθήσῃ· ");
INSERT INTO grctr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","καρδίᾳ γὰρ πιστεύεται εἰς δικαιοσύνην, στόματι δὲ ὁμολογεῖται εἰς σωτηρίαν. ");
INSERT INTO grctr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Λέγει γὰρ ἡ γραφή, Πᾶς ὁ πιστεύων ἐπ᾿ αὐτῷ οὐ καταισχυνθήσεται. ");
INSERT INTO grctr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Οὐ γάρ ἐστι διαστολὴ Ἰουδαίου τε καὶ Ἕλληνος· ὁ γὰρ αὐτὸς Κύριος πάντων, πλουτῶν εἰς πάντας τοὺς ἐπικαλουμένους αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Πᾶς γὰρ ὃς ἂν ἐπικαλέσηται τὸ ὄνομα Κυρίου σωθήσεται. ");
INSERT INTO grctr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Πῶς οὖν ἐπικαλέσονται εἰς ὃν οὐκ ἐπίστευσαν; Πῶς δὲ πιστεύσουσιν οὗ οὐκ ἤκουσαν; Πῶς δὲ ἀκούσουσι χωρὶς κηρύσσοντος; ");
INSERT INTO grctr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Πῶς δὲ κηρύξουσιν ἐὰν μὴ ἀποσταλῶσι; Καθὼς γέγραπται, Ὡς ὡραῖοι οἱ πόδες τῶν εὐαγγελιζομένων εἰρήνην, τῶν εὐαγγελιζομένων τὰ ἀγαθά. ");
INSERT INTO grctr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ἀλλ᾿ οὐ πάντες ὑπήκουσαν τῷ εὐαγγελίῳ. Ἠσαΐας γὰρ λέγει, Κύριε, τίς ἐπίστευσε τῇ ἀκοῇ ἡμῶν; ");
INSERT INTO grctr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ἄρα ἡ πίστις ἐξ ἀκοῆς, ἡ δὲ ἀκοὴ διὰ ῥήματος Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ἀλλὰ λέγω, μὴ οὐκ ἤκουσαν; Μενοῦνγε· Εἰς πᾶσαν τὴν γῆν ἐξῆλθεν ὁ φθόγγος αὐτῶν, καὶ εἰς τὰ πέρατα τῆς οἰκουμένης τὰ ῥήματα αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ἀλλὰ λέγω, μὴ οὐκ ἔγνω Ἰσραήλ; Πρῶτος Μωσῆς λέγει, Ἐγὼ παραζηλώσω ὑμᾶς ἐπ᾿ οὐκ ἔθνει, ἐπὶ ἔθνει ἀσυνέτῳ παροργιῶ ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ἠσαΐας δὲ ἀποτολμᾷ καὶ λέγει, Εὑρέθην τοῖς ἐμὲ μὴ ζητοῦσιν, ἐμφανὴς ἐγενόμην τοῖς ἐμὲ μὴ ἐπερωτῶσι. ");
INSERT INTO grctr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Πρὸς δὲ τὸν Ἰσραὴλ λέγει, Ὅλην τὴν ἡμέραν ἐξεπέτασα τὰς χεῖράς μου πρὸς λαὸν ἀπειθοῦντα καὶ ἀντιλέγοντα. ");
INSERT INTO grctr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Λέγω οὖν, μὴ ἀπώσατο ὁ Θεὸς τὸν λαὸν αὐτοῦ; Μὴ γένοιτο. Καὶ γὰρ ἐγὼ Ἰσραηλίτης εἰμί, ἐκ σπέρματος Ἀβραάμ, φυλῆς Βενιαμίν. ");
INSERT INTO grctr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Οὐκ ἀπώσατο ὁ Θεὸς τὸν λαὸν αὐτοῦ ὃν προέγνω. Ἢ οὐκ οἴδατε ἐν Ἠλίᾳ τί λέγει ἡ γραφή; Ὡς ἐντυγχάνει τῷ Θεῷ κατὰ τοῦ Ἰσραήλ, λέγων, ");
INSERT INTO grctr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Κύριε, τοὺς προφήτας σου ἀπέκτειναν, καὶ τὰ θυσιαστήριά σου κατέσκαψαν· κἀγὼ ὑπελείφθην μόνος, καὶ ζητοῦσι τὴν ψυχήν μου. ");
INSERT INTO grctr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ἀλλὰ τί λέγει αὐτῷ ὁ χρηματισμός; Κατέλιπον ἐμαυτῷ ἑπτακισχιλίους ἄνδρας, οἵτινες οὐκ ἔκαμψαν γόνυ τῇ Βάαλ. ");
INSERT INTO grctr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Οὕτως οὖν καὶ ἐν τῷ νῦν καιρῷ λεῖμμα κατ᾿ ἐκλογὴν χάριτος γέγονεν. ");
INSERT INTO grctr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Εἰ δὲ χάριτι, οὐκέτι ἐξ ἔργων· ἐπεὶ ἡ χάρις οὐκέτι γίνεται χάρις. Εἰ δὲ ἐξ ἔργων, οὐκέτι ἐστὶ χάρις· ἐπεὶ τὸ ἔργον οὐκέτι ἐστὶν ἔργον. ");
INSERT INTO grctr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Τί οὖν; Ὃ ἐπιζητεῖ Ἰσραήλ, τούτου οὐκ ἐπέτυχεν, ἡ δὲ ἐκλογὴ ἐπέτυχεν, οἱ δὲ λοιποὶ ἐπωρώθησαν· ");
INSERT INTO grctr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","καθὼς γέγραπται, Ἔδωκεν αὐτοῖς ὁ Θεὸς πνεῦμα κατανύξεως, ὀφθαλμοὺς τοῦ μὴ βλέπειν, καὶ ὦτα τοῦ μὴ ἀκούειν, ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grctr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Καὶ Δαβὶδ λέγει, Γενηθήτω ἡ τράπεζα αὐτῶν εἰς παγίδα καὶ εἰς θήραν, καὶ εἰς σκάνδαλον, καὶ εἰς ἀνταπόδομα αὐτοῖς· ");
INSERT INTO grctr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","σκοτισθήτωσαν οἱ ὀφθαλμοὶ αὐτῶν τοῦ μὴ βλέπειν, καὶ τὸν νῶτον αὐτῶν διὰ παντὸς σύγκαμψον. ");
INSERT INTO grctr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Λέγω οὖν, μὴ ἔπταισαν ἵνα πέσωσι; Μὴ γένοιτο· ἀλλὰ τῷ αὐτῶν παραπτώματι ἡ σωτηρία τοῖς ἔθνεσιν, εἰς τὸ παραζηλῶσαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Εἰ δὲ τὸ παράπτωμα αὐτῶν πλοῦτος κόσμου, καὶ τὸ ἥττημα αὐτῶν πλοῦτος ἐθνῶν, πόσῳ μᾶλλον τὸ πλήρωμα αὐτῶν; ");
INSERT INTO grctr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ὑμῖν γὰρ λέγω τοῖς ἔθνεσιν. Ἐφ᾿ ὅσον μέν εἰμι ἐγὼ ἐθνῶν ἀπόστολος, τὴν διακονίαν μου δοξάζω· ");
INSERT INTO grctr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","εἴ πως παραζηλώσω μου τὴν σάρκα, καὶ σώσω τινὰς ἐξ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Εἰ γὰρ ἡ ἀποβολὴ αὐτῶν καταλλαγὴ κόσμου, τίς ἡ πρόσληψις, εἰ μὴ ζωὴ ἐκ νεκρῶν; ");
INSERT INTO grctr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Εἰ δὲ ἡ ἀπαρχὴ ἁγία, καὶ τὸ φύραμα· καὶ εἰ ἡ ῥίζα ἁγία, καὶ οἱ κλάδοι. ");
INSERT INTO grctr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Εἰ δέ τινες τῶν κλάδων ἐξεκλάσθησαν, σὺ δὲ ἀγριέλαιος ὢν ἐνεκεντρίσθης ἐν αὐτοῖς, καὶ συγκοινωνὸς τῆς ῥίζης καὶ τῆς πιότητος τῆς ἐλαίας ἐγένου, ");
INSERT INTO grctr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","μὴ κατακαυχῶ τῶν κλάδων· εἰ δὲ κατακαυχᾶσαι, οὐ σὺ τὴν ῥίζαν βαστάζεις, ἀλλ᾿ ἡ ῥίζα σέ. ");
INSERT INTO grctr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ἐρεῖς οὖν, Ἐξεκλάσθησαν οἱ κλάδοι, ἵνα ἐγὼ ἐγκεντρισθῶ. ");
INSERT INTO grctr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Καλῶς· τῇ ἀπιστίᾳ ἐξεκλάσθησαν, σὺ δὲ τῇ πίστει ἕστηκας. Μὴ ὑψηλοφρόνει, ἀλλὰ φοβοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","εἰ γὰρ ὁ Θεὸς τῶν κατὰ φύσιν κλάδων οὐκ ἐφείσατο, μήπως οὐδέ σου φείσηται. ");
INSERT INTO grctr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ἴδε οὖν χρηστότητα καὶ ἀποτομίαν Θεοῦ· ἐπὶ μὲν τοὺς πεσόντας, ἀποτομίαν· ἐπὶ δὲ σὲ, χρηστότητα, ἐὰν ἐπιμείνῃς τῇ χρηστότητι· ἐπεὶ καὶ σὺ ἐκκοπήσῃ. ");
INSERT INTO grctr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Καὶ ἐκεῖνοι δέ, ἐὰν μὴ ἐπιμείνωσι τῇ ἀπιστίᾳ, ἐγκεντρισθήσονται· δυνατὸς γάρ ἐστιν ὁ Θεός πάλιν ἐγκεντρίσαι αὐτούς. ");
INSERT INTO grctr_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Εἰ γὰρ σὺ ἐκ τῆς κατὰ φύσιν ἐξεκόπης ἀγριελαίου, καὶ παρὰ φύσιν ἐνεκεντρίσθης εἰς καλλιέλαιον, πόσῳ μᾶλλον οὗτοι, οἱ κατὰ φύσιν, ἐγκεντρισθήσονται τῇ ἰδίᾳ ἐλαίᾳ; ");
INSERT INTO grctr_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Οὐ γὰρ θέλω ὑμᾶς ἀγνοεῖν, ἀδελφοί, τὸ μυστήριον τοῦτο, ἵνα μὴ ἦτε παρ᾿ ἑαυτοῖς φρόνιμοι, ὅτι πώρωσις ἀπὸ μέρους τῷ Ἰσραὴλ γέγονεν, ἄχρις οὗ τὸ πλήρωμα τῶν ἐθνῶν εἰσέλθῃ· ");
INSERT INTO grctr_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","καὶ οὕτω πᾶς Ἰσραὴλ σωθήσεται· καθὼς γέγραπται, Ἥξει ἐκ Σιὼν ὁ ῥυόμενος, καὶ ἀποστρέψει ἀσεβείας ἀπὸ Ἰακώβ· ");
INSERT INTO grctr_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","καὶ αὕτη αὐτοῖς ἡ παρ᾿ ἐμοῦ διαθήκη, ὅταν ἀφέλωμαι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Κατὰ μὲν τὸ εὐαγγέλιον, ἐχθροὶ δι᾿ ὑμᾶς· κατὰ δὲ τὴν ἐκλογήν, ἀγαπητοὶ διὰ τοὺς πατέρας. ");
INSERT INTO grctr_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ἀμεταμέλητα γὰρ τὰ χαρίσματα καὶ ἡ κλῆσις τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ὥσπερ γὰρ καὶ ὑμεῖς ποτὲ ἠπειθήσατε τῷ Θεῷ, νῦν δὲ ἠλεήθητε τῇ τούτων ἀπειθείᾳ· ");
INSERT INTO grctr_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","οὕτω καὶ οὗτοι νῦν ἠπείθησαν, τῷ ὑμετέρῳ ἐλέει ἵνα καὶ αὐτοὶ ἐλεηθῶσι· ");
INSERT INTO grctr_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","συνέκλεισε γὰρ ὁ Θεὸς τοὺς πάντας εἰς ἀπείθειαν, ἵνα τοὺς πάντας ἐλεήσῃ. ");
INSERT INTO grctr_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ὦ βάθος πλούτου καὶ σοφίας καὶ γνώσεως Θεοῦ. Ὡς ἀνεξερεύνητα τὰ κρίματα αὐτοῦ, καὶ ἀνεξιχνίαστοι αἱ ὁδοὶ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Τίς γὰρ ἔγνω νοῦν Κυρίου; Ἢ τίς σύμβουλος αὐτοῦ ἐγένετο; ");
INSERT INTO grctr_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ἢ τίς προέδωκεν αὐτῷ, καὶ ἀνταποδοθήσεται αὐτῷ; ");
INSERT INTO grctr_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ὅτι ἐξ αὐτοῦ καὶ δι᾿ αὐτοῦ καὶ εἰς αὐτὸν τὰ πάντα· αὐτῷ ἡ δόξα εἰς τοὺς αἰῶνας. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Παρακαλῶ οὖν ὑμᾶς, ἀδελφοί, διὰ τῶν οἰκτιρμῶν τοῦ Θεοῦ, παραστῆσαι τὰ σώματα ὑμῶν θυσίαν ζῶσαν, ἁγίαν, εὐάρεστον τῷ Θεῷ, τὴν λογικὴν λατρείαν ὑμῶν, ");
INSERT INTO grctr_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","καὶ μὴ συσχηματίζεσθε τῷ αἰῶνι τούτῳ, ἀλλὰ μεταμορφοῦσθε τῇ ἀνακαινώσει τοῦ νοὸς ὑμῶν, εἰς τὸ δοκιμάζειν ὑμᾶς τί τὸ θέλημα τοῦ Θεοῦ τὸ ἀγαθὸν καὶ εὐάρεστον καὶ τέλειον. ");
INSERT INTO grctr_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Λέγω γάρ, διὰ τῆς χάριτος τῆς δοθείσης μοι, παντὶ τῷ ὄντι ἐν ὑμῖν, μὴ ὑπερφρονεῖν παρ᾿ ὃ δεῖ φρονεῖν, ἀλλὰ φρονεῖν εἰς τὸ σωφρονεῖν, ἑκάστῳ ὡς ὁ Θεὸς ἐμέρισε μέτρον πίστεως. ");
INSERT INTO grctr_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Καθάπερ γὰρ ἐν ἑνὶ σώματι μέλη πολλὰ ἔχομεν, τὰ δὲ μέλη πάντα οὐ τὴν αὐτὴν ἔχει πρᾶξιν· ");
INSERT INTO grctr_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","οὕτως οἱ πολλοὶ ἓν σῶμά ἐσμεν ἐν Χριστῷ, ὁ δὲ καθ᾿ εἷς ἀλλήλων μέλη. ");
INSERT INTO grctr_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ἔχοντες δὲ χαρίσματα κατὰ τὴν χάριν τὴν δοθεῖσαν ἡμῖν διάφορα, εἴτε προφητείαν, κατὰ τὴν ἀναλογίαν τῆς πίστεως· ");
INSERT INTO grctr_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","εἴτε διακονίαν, ἐν τῇ διακονίᾳ· εἴτε ὁ διδάσκων, ἐν τῇ διδασκαλίᾳ· ");
INSERT INTO grctr_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","εἴτε ὁ παρακαλῶν, ἐν τῇ παρακλήσει· ὁ μεταδιδούς, ἐν ἁπλότητι· ὁ προϊστάμενος, ἐν σπουδῇ· ὁ ἐλεῶν, ἐν ἱλαρότητι. ");
INSERT INTO grctr_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ἡ ἀγάπη ἀνυπόκριτος. Ἀποστυγοῦντες τὸ πονηρόν, κολλώμενοι τῷ ἀγαθῷ. ");
INSERT INTO grctr_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Τῇ φιλαδελφίᾳ εἰς ἀλλήλους φιλόστοργοι· τῇ τιμῇ ἀλλήλους προηγούμενοι· ");
INSERT INTO grctr_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","τῇ σπουδῇ μὴ ὀκνηροί· τῷ πνεύματι ζέοντες· τῷ Κυρίῳ δουλεύοντες· ");
INSERT INTO grctr_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","τῇ ἐλπίδι χαίροντες· τῇ θλίψει ὑπομένοντες· τῇ προσευχῇ προσκαρτεροῦντες· ");
INSERT INTO grctr_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ταῖς χρείαις τῶν ἁγίων κοινωνοῦντες· τὴν φιλοξενίαν διώκοντες. ");
INSERT INTO grctr_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Εὐλογεῖτε τοὺς διώκοντας ὑμᾶς· εὐλογεῖτε, καὶ μὴ καταρᾶσθε. ");
INSERT INTO grctr_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Χαίρειν μετὰ χαιρόντων, καὶ κλαίειν μετὰ κλαιόντων. ");
INSERT INTO grctr_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Τὸ αὐτὸ εἰς ἀλλήλους φρονοῦντες. Μὴ τὰ ὑψηλὰ φρονοῦντες, ἀλλὰ τοῖς ταπεινοῖς συναπαγόμενοι. Μὴ γίνεσθε φρόνιμοι παρ᾿ ἑαυτοῖς. ");
INSERT INTO grctr_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Μηδενὶ κακὸν ἀντὶ κακοῦ ἀποδιδόντες. Προνοούμενοι καλὰ ἐνώπιον πάντων ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Εἰ δυνατόν, τὸ ἐξ ὑμῶν, μετὰ πάντων ἀνθρώπων εἰρηνεύοντες. ");
INSERT INTO grctr_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Μὴ ἑαυτοὺς ἐκδικοῦντες, ἀγαπητοί, ἀλλὰ δότε τόπον τῇ ὀργῇ· γέγραπται γάρ, Ἐμοὶ ἐκδίκησις, ἐγὼ ἀνταποδώσω, λέγει Κύριος. ");
INSERT INTO grctr_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ἐὰν οὖν πεινᾷ ὁ ἐχθρός σου, ψώμιζε αὐτόν· ἐὰν διψᾷ, πότιζε αὐτόν· τοῦτο γὰρ ποιῶν, ἄνθρακας πυρὸς σωρεύσεις ἐπὶ τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Μὴ νικῶ ὑπὸ τοῦ κακοῦ, ἀλλὰ νίκα ἐν τῷ ἀγαθῷ τὸ κακόν. ");
INSERT INTO grctr_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Πᾶσα ψυχὴ ἐξουσίαις ὑπερεχούσαις ὑποτασσέσθω· οὐ γάρ ἐστιν ἐξουσία εἰ μὴ ἀπὸ Θεοῦ, αἱ δὲ οὖσαι ἐξουσίαι ὑπὸ τοῦ Θεοῦ τεταγμέναι εἰσίν. ");
INSERT INTO grctr_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ὥστε ὁ ἀντιτασσόμενος τῇ ἐξουσίᾳ, τῇ τοῦ Θεοῦ διαταγῇ ἀνθέστηκεν· οἱ δὲ ἀνθεστηκότες ἑαυτοῖς κρίμα λήψονται. ");
INSERT INTO grctr_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Οἱ γὰρ ἄρχοντες οὐκ εἰσὶ φόβος τῶν ἀγαθῶν ἔργων, ἀλλὰ τῶν κακῶν. Θέλεις δὲ μὴ φοβεῖσθαι τὴν ἐξουσίαν; Τὸ ἀγαθὸν ποίει, καὶ ἕξεις ἔπαινον ἐξ αὐτῆς· ");
INSERT INTO grctr_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Θεοῦ γὰρ διάκονός ἐστί σοι εἰς τὸ ἀγαθόν. Ἐὰν δὲ τὸ κακὸν ποιῇς, φοβοῦ· οὐ γὰρ εἰκῇ τὴν μάχαιραν φορεῖ· Θεοῦ γὰρ διάκονός ἐστιν, ἔκδικος εἰς ὀργὴν τῷ τὸ κακὸν πράσσοντι. ");
INSERT INTO grctr_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Διὸ ἀνάγκη ὑποτάσσεσθαι, οὐ μόνον διὰ τὴν ὀργήν, ἀλλὰ καὶ διὰ τὴν συνείδησιν. ");
INSERT INTO grctr_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Διὰ τοῦτο γὰρ καὶ φόρους τελεῖτε· λειτουργοὶ γὰρ Θεοῦ εἰσιν, εἰς αὐτὸ τοῦτο προσκαρτεροῦντες. ");
INSERT INTO grctr_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ἀπόδοτε οὖν πᾶσι τὰς ὀφειλάς· τῷ τὸν φόρον τὸν φόρον· τῷ τὸ τέλος τὸ τέλος· τῷ τὸν φόβον τὸν φόβον· τῷ τὴν τιμὴν τὴν τιμήν. ");
INSERT INTO grctr_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Μηδενὶ μηδὲν ὀφείλετε, εἰ μὴ τὸ ἀγαπᾷν ἀλλήλους· ὁ γὰρ ἀγαπῶν τὸν ἕτερον, νόμον πεπλήρωκε. ");
INSERT INTO grctr_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Τὸ γάρ, Οὐ μοιχεύσεις, οὐ φονεύσεις, οὐ κλέψεις, οὐ ψευδομαρτυρήσεις, οὐκ ἐπιθυμήσεις, καὶ εἴ τις ἑτέρα ἐντολή, ἐν τούτῳ τῷ λόγῳ ἀνακεφαλαιοῦται, ἐν τῷ, Ἀγαπήσεις τὸν πλησίον σου ὡς ἑαυτόν. ");
INSERT INTO grctr_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ἡ ἀγάπη τῷ πλησίον κακὸν οὐκ ἐργάζεται· πλήρωμα οὖν νόμου ἡ ἀγάπη. ");
INSERT INTO grctr_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Καὶ τοῦτο, εἰδότες τὸν καιρόν, ὅτι ὥρα ἡμᾶς ἤδη ἐξ ὕπνου ἐγερθῆναι· νῦν γὰρ ἐγγύτερον ἡμῶν ἡ σωτηρία ἢ ὅτε ἐπιστεύσαμεν. ");
INSERT INTO grctr_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ἡ νὺξ προέκοψεν, ἡ δὲ ἡμέρα ἤγγικεν· ἀποθώμεθα οὖν τὰ ἔργα τοῦ σκότους, καὶ ἐνδυσώμεθα τὰ ὅπλα τοῦ φωτός. ");
INSERT INTO grctr_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ὡς ἐν ἡμέρᾳ, εὐσχημόνως περιπατήσωμεν, μὴ κώμοις καὶ μέθαις, μὴ κοίταις καὶ ἀσελγείαις, μὴ ἔριδι καὶ ζήλῳ. ");
INSERT INTO grctr_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ἀλλ᾿ ἐνδύσασθε τὸν Κύριον Ἰησοῦν Χριστόν, καὶ τῆς σαρκὸς πρόνοιαν μὴ ποιεῖσθε, εἰς ἐπιθυμίας. ");
INSERT INTO grctr_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Τὸν δὲ ἀσθενοῦντα τῇ πίστει προσλαμβάνεσθε, μὴ εἰς διακρίσεις διαλογισμῶν. ");
INSERT INTO grctr_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Ὃς μὲν πιστεύει φαγεῖν πάντα, ὁ δὲ ἀσθενῶν λάχανα ἐσθίει. ");
INSERT INTO grctr_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ὁ ἐσθίων τὸν μὴ ἐσθίοντα μὴ ἐξουθενείτω, καὶ ὁ μὴ ἐσθίων τὸν ἐσθίοντα μὴ κρινέτω· ὁ Θεὸς γὰρ αὐτὸν προσελάβετο. ");
INSERT INTO grctr_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Σὺ τίς εἶ ὁ κρίνων ἀλλότριον οἰκέτην; Τῷ ἰδίῳ κυρίῳ στήκει ἢ πίπτει. Σταθήσεται δέ· δυνατὸς γάρ ἐστιν ὁ Θεὸς στῆσαι αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ὃς μὲν κρίνει ἡμέραν παρ᾿ ἡμέραν, ὃς δὲ κρίνει πᾶσαν ἡμέραν. Ἕκαστος ἐν τῷ ἰδίῳ νοῒ πληροφορείσθω. ");
INSERT INTO grctr_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ὁ φρονῶν τὴν ἡμέραν, Κυρίῳ φρονεῖ· καὶ ὁ μὴ φρονῶν τὴν ἡμέραν, Κυρίῳ οὐ φρονεῖ. Ὁ ἐσθίων Κυρίῳ ἐσθίει, εὐχαριστεῖ γὰρ τῷ Θεῷ· καὶ ὁ μὴ ἐσθίων Κυρίῳ οὐκ ἐσθίει, καὶ εὐχαριστεῖ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Οὐδεὶς γὰρ ἡμῶν ἑαυτῷ ζῇ, καὶ οὐδεὶς ἑαυτῷ ἀποθνῄσκει. ");
INSERT INTO grctr_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ἐάν τε γὰρ ζῶμεν, τῷ Κυρίῳ ζῶμεν· ἐάν τε ἀποθνῄσκωμεν, τῷ Κυρίῳ ἀποθνῄσκομεν· ἐάν τε οὖν ζῶμεν, ἐάν τε ἀποθνῄσκωμεν, τοῦ Κυρίου ἐσμέν. ");
INSERT INTO grctr_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Εἰς τοῦτο γὰρ Χριστὸς καὶ ἀπέθανε καὶ ἀνέστη καὶ ἀνέζησεν, ἵνα καὶ νεκρῶν καὶ ζώντων κυριεύσῃ. ");
INSERT INTO grctr_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Σὺ δὲ τί κρίνεις τὸν ἀδελφόν σου; Ἢ καὶ σὺ τί ἐξουθενεῖς τὸν ἀδελφόν σου; Πάντες γὰρ παραστησόμεθα τῷ βήματι τοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Γέγραπται γάρ, Ζῶ ἐγώ, λέγει Κύριος· ὅτι ἐμοὶ κάμψει πᾶν γόνυ, καὶ πᾶσα γλῶσσα ἐξομολογήσεται τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ἄρα οὖν ἕκαστος ἡμῶν περὶ ἑαυτοῦ λόγον δώσει τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Μηκέτι οὖν ἀλλήλους κρίνωμεν· ἀλλὰ τοῦτο κρίνατε μᾶλλον, τὸ μὴ τιθέναι πρόσκομμα τῷ ἀδελφῷ ἢ σκάνδαλον. ");
INSERT INTO grctr_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Οἶδα καὶ πέπεισμαι ἐν Κυρίῳ Ἰησοῦ, ὅτι οὐδὲν κοινὸν δι᾿ ἑαυτοῦ· εἰ μὴ τῷ λογιζομένῳ τι κοινὸν εἶναι, ἐκείνῳ κοινόν. ");
INSERT INTO grctr_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Εἰ δὲ διὰ βρῶμα ὁ ἀδελφός σου λυπεῖται, οὐκέτι κατὰ ἀγάπην περιπατεῖς. Μὴ τῷ βρώματί σου ἐκεῖνον ἀπόλλυε, ὑπὲρ οὗ Χριστὸς ἀπέθανε. ");
INSERT INTO grctr_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Μὴ βλασφημείσθω οὖν ὑμῶν τὸ ἀγαθόν· ");
INSERT INTO grctr_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","οὐ γάρ ἐστιν ἡ βασιλεία τοῦ Θεοῦ βρῶσις καὶ πόσις, ἀλλὰ δικαιοσύνη καὶ εἰρήνη καὶ χαρὰ ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ὁ γὰρ ἐν τούτοις δουλεύων τῷ Χριστῷ εὐάρεστος τῷ Θεῷ, καὶ δόκιμος τοῖς ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ἄρα οὖν τὰ τῆς εἰρήνης διώκωμεν, καὶ τὰ τῆς οἰκοδομῆς τῆς εἰς ἀλλήλους. ");
INSERT INTO grctr_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Μὴ ἕνεκεν βρώματος κατάλυε τὸ ἔργον τοῦ Θεοῦ. Πάντα μὲν καθαρά, ἀλλὰ κακὸν τῷ ἀνθρώπῳ τῷ διὰ προσκόμματος ἐσθίοντι. ");
INSERT INTO grctr_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Καλὸν τὸ μὴ φαγεῖν κρέα, μηδὲ πιεῖν οἶνον, μηδὲ ἐν ᾧ ὁ ἀδελφός σου προσκόπτει ἢ σκανδαλίζεται ἢ ἀσθενεῖ. ");
INSERT INTO grctr_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Σὺ πίστιν ἔχεις; Κατὰ σαυτὸν ἔχε ἐνώπιον τοῦ Θεοῦ. Μακάριος ὁ μὴ κρίνων ἑαυτὸν ἐν ᾧ δοκιμάζει. ");
INSERT INTO grctr_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ὁ δὲ διακρινόμενος, ἐὰν φάγῃ, κατακέκριται, ὅτι οὐκ ἐκ πίστεως· πᾶν δὲ ὃ οὐκ ἐκ πίστεως, ἁμαρτία ἐστίν. ");
INSERT INTO grctr_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ὀφείλομεν δὲ ἡμεῖς οἱ δυνατοὶ τὰ ἀσθενήματα τῶν ἀδυνάτων βαστάζειν, καὶ μὴ ἑαυτοῖς ἀρέσκειν. ");
INSERT INTO grctr_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ἕκαστος γὰρ ἡμῶν τῷ πλησίον ἀρεσκέτω εἰς τὸ ἀγαθὸν πρὸς οἰκοδομήν. ");
INSERT INTO grctr_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Καὶ γὰρ ὁ Χριστὸς οὐχ ἑαυτῷ ἤρεσεν, ἀλλά, καθὼς γέγραπται, Οἱ ὀνειδισμοὶ τῶν ὀνειδιζόντων σε ἐπέπεσον ἐπ᾿ ἐμέ. ");
INSERT INTO grctr_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ὅσα γὰρ προεγράφη, εἰς τὴν ἡμετέραν διδασκαλίαν προεγράφη, ἵνα διὰ τῆς ὑπομονῆς καὶ τῆς παρακλήσεως τῶν γραφῶν τὴν ἐλπίδα ἔχωμεν. ");
INSERT INTO grctr_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ὁ δὲ Θεὸς τῆς ὑπομονῆς καὶ τῆς παρακλήσεως δῴη ὑμῖν τὸ αὐτὸ φρονεῖν ἐν ἀλλήλοις κατὰ Χριστὸν Ἰησοῦν· ");
INSERT INTO grctr_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ἵνα ὁμοθυμαδὸν ἐν ἑνὶ στόματι δοξάζητε τὸν Θεὸν καὶ πατέρα τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ ");
INSERT INTO grctr_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Διὸ προσλαμβάνεσθε ἀλλήλους, καθὼς καὶ ὁ Χριστὸς προσελάβετο ἡμᾶς, εἰς δόξαν Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Λέγω δέ, Ἰησοῦν Χριστὸν διάκονον γεγενῆσθαι περιτομῆς ὑπὲρ ἀληθείας Θεοῦ, εἰς τὸ βεβαιῶσαι τὰς ἐπαγγελίας τῶν πατέρων· ");
INSERT INTO grctr_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","τὰ δὲ ἔθνη ὑπὲρ ἐλέους δοξάσαι τὸν Θεόν, καθὼς γέγραπται, Διὰ τοῦτο ἐξομολογήσομαί σοι ἐν ἔθνεσι, καὶ τῷ ὀνόματί σου ψαλῶ. ");
INSERT INTO grctr_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Καὶ πάλιν λέγει, Εὐφράνθητε, ἔθνη, μετὰ τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Καὶ πάλιν, Αἰνεῖτε τὸν Κύριον πάντα τὰ ἔθνη, καὶ ἐπαινέσατε αὐτὸν πάντες οἱ λαοί. ");
INSERT INTO grctr_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Καὶ πάλιν Ἠσαΐας λέγει, Ἔσται ἡ ῥίζα τοῦ Ἰεσσαί, καὶ ὁ ἀνιστάμενος ἄρχειν ἐθνῶν· ἐπ᾿ αὐτῷ ἔθνη ἐλπιοῦσιν. ");
INSERT INTO grctr_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ὁ δὲ Θεὸς τῆς ἐλπίδος πληρώσαι ὑμᾶς πάσης χαρᾶς καὶ εἰρήνης ἐν τῷ πιστεύειν, εἰς τὸ περισσεύειν ὑμᾶς ἐν τῇ ἐλπίδι, ἐν δυνάμει πνεύματος ἁγίου. ");
INSERT INTO grctr_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Πέπεισμαι δέ, ἀδελφοί μου, καὶ αὐτὸς ἐγὼ περὶ ὑμῶν, ὅτι καὶ αὐτοὶ μεστοί ἐστε ἀγαθωσύνης, πεπληρωμένοι πάσης γνώσεως, δυνάμενοι καὶ ἀλλήλους νουθετεῖν. ");
INSERT INTO grctr_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Τολμηρότερον δὲ ἔγραψα ὑμῖν, ἀδελφοί, ἀπὸ μέρους, ὡς ἐπαναμιμνῄσκων ὑμᾶς, διὰ τὴν χάριν τὴν δοθεῖσάν μοι ὑπὸ τοῦ Θεοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","εἰς τὸ εἶναί με λειτουργὸν Ἰησοῦ Χριστοῦ εἰς τὰ ἔθνη, ἱερουργοῦντα τὸ εὐαγγέλιον τοῦ Θεοῦ, ἵνα γένηται ἡ προσφορὰ τῶν ἐθνῶν εὐπρόσδεκτος, ἡγιασμένη ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ἔχω οὖν καύχησιν ἐν Χριστῷ Ἰησοῦ τὰ πρὸς Θεόν. ");
INSERT INTO grctr_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Οὐ γὰρ τολμήσω λαλεῖν τι ὧν οὐ κατειργάσατο Χριστὸς δι᾿ ἐμοῦ, εἰς ὑπακοὴν ἐθνῶν, λόγῳ καὶ ἔργῳ, ");
INSERT INTO grctr_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ἐν δυνάμει σημείων καὶ τεράτων, ἐν δυνάμει πνεύματος Θεοῦ· ὥστε με ἀπὸ Ἱερουσαλὴμ καὶ κύκλῳ μέχρι τοῦ Ἰλλυρικοῦ πεπληρωκέναι τὸ εὐαγγέλιον τοῦ Χριστοῦ· ");
INSERT INTO grctr_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","οὕτω δὲ φιλοτιμούμενον εὐαγγελίζεσθαι, οὐχ ὅπου ὠνομάσθη Χριστός, ἵνα μὴ ἐπ᾿ ἀλλότριον θεμέλιον οἰκοδομῶ· ");
INSERT INTO grctr_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ἀλλά, καθὼς γέγραπται, Οἷς οὐκ ἀνηγγέλη περὶ αὐτοῦ, ὄψονται· καὶ οἳ οὐκ ἀκηκόασι συνήσουσι. ");
INSERT INTO grctr_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Διὸ καὶ ἐνεκοπτόμην τὰ πολλὰ τοῦ ἐλθεῖν πρὸς ὑμᾶς· ");
INSERT INTO grctr_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","νυνὶ δὲ μηκέτι τόπον ἔχων ἐν τοῖς κλίμασι τούτοις, ἐπιποθίαν δὲ ἔχων τοῦ ἐλθεῖν πρὸς ὑμᾶς ἀπὸ πολλῶν ἐτῶν, ");
INSERT INTO grctr_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ὡς ἐὰν πορεύωμαι εἰς τὴν Σπανίαν, ἐλεύσομαι πρὸς ὑμᾶς· ἐλπίζω γὰρ διαπορευόμενος θεάσασθαι ὑμᾶς, καὶ ὑφ᾿ ὑμῶν προπεμφθῆναι ἐκεῖ, ἐὰν ὑμῶν πρῶτον ἀπὸ μέρους ἐμπλησθῶ. ");
INSERT INTO grctr_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Νυνὶ δὲ πορεύομαι εἰς Ἱερουσαλήμ, διακονῶν τοῖς ἁγίοις. ");
INSERT INTO grctr_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Εὐδόκησαν γὰρ Μακεδονία καὶ Ἀχαΐα κοινωνίαν τινὰ ποιήσασθαι εἰς τοὺς πτωχοὺς τῶν ἁγίων τῶν ἐν Ἱερουσαλήμ. ");
INSERT INTO grctr_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Εὐδόκησαν γάρ, καὶ ὀφειλέται αὐτῶν εἰσιν. Εἰ γὰρ τοῖς πνευματικοῖς αὐτῶν ἐκοινώνησαν τὰ ἔθνη, ὀφείλουσι καὶ ἐν τοῖς σαρκικοῖς λειτουργῆσαι αὐτοῖς. ");
INSERT INTO grctr_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Τοῦτο οὖν ἐπιτελέσας, καὶ σφραγισάμενος αὐτοῖς τὸν καρπὸν τοῦτον, ἀπελεύσομαι δι᾿ ὑμῶν εἰς τὴν Σπανίαν. ");
INSERT INTO grctr_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Οἶδα δὲ ὅτι ἐρχόμενος πρὸς ὑμᾶς ἐν πληρώματι εὐλογίας τοῦ εὐαγγελίου τοῦ Χριστοῦ ἐλεύσομαι. ");
INSERT INTO grctr_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, διὰ τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, καὶ διὰ τῆς ἀγάπης τοῦ πνεύματος, συναγωνίσασθαί μοι ἐν ταῖς προσευχαῖς ὑπὲρ ἐμοῦ πρὸς τὸν Θεόν· ");
INSERT INTO grctr_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ἵνα ῥυσθῶ ἀπὸ τῶν ἀπειθούντων ἐν τῇ Ἰουδαίᾳ, καὶ ἵνα ἡ διακονία μου ἡ εἰς Ἱερουσαλὴμ εὐπρόσδεκτος γένηται τοῖς ἁγίοις· ");
INSERT INTO grctr_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ἵνα ἐν χαρᾷ ἔλθω πρὸς ὑμᾶς διὰ θελήματος Θεοῦ, καὶ συναναπαύσωμαι ὑμῖν. ");
INSERT INTO grctr_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ὁ δὲ Θεὸς τῆς εἰρήνης μετὰ πάντων ὑμῶν. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Συνίστημι δὲ ὑμῖν Φοίβην τὴν ἀδελφὴν ἡμῶν, οὖσαν διάκονον τῆς ἐκκλησίας τῆς ἐν Κεγχρεαῖς· ");
INSERT INTO grctr_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ἵνα αὐτὴν προσδέξησθε ἐν Κυρίῳ ἀξίως τῶν ἁγίων, καὶ παραστῆτε αὐτῇ ἐν ᾧ ἂν ὑμῶν χρῄζῃ πράγματι· καὶ γὰρ αὕτη προστάτις πολλῶν ἐγενήθη, καὶ αὐτοῦ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ἀσπάσασθε Πρίσκιλλαν καὶ Ἀκύλαν τοὺς συνεργούς μου ἐν Χριστῷ Ἰησοῦ, ");
INSERT INTO grctr_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","οἵτινες ὑπὲρ τῆς ψυχῆς μου τὸν ἑαυτῶν τράχηλον ὑπέθηκαν, οἷς οὐκ ἐγὼ μόνος εὐχαριστῶ, ἀλλὰ καὶ πᾶσαι αἱ ἐκκλησίαι τῶν ἐθνῶν· ");
INSERT INTO grctr_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","καὶ τὴν κατ᾿ οἶκον αὐτῶν ἐκκλησίαν. Ἀσπάσασθε Ἐπαίνετον τὸν ἀγαπητόν μου, ὅς ἐστιν ἀπαρχὴ τῆς Ἀχαΐας εἰς Χριστόν. ");
INSERT INTO grctr_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ἀσπάσασθε Μαριάμ, ἥτις πολλὰ ἐκοπίασεν εἰς ἡμᾶς. ");
INSERT INTO grctr_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ἀσπάσασθε Ἀνδρόνικον καὶ Ἰουνίαν τοὺς συγγενεῖς μου καὶ συναιχμαλώτους μου, οἵτινές εἰσιν ἐπίσημοι ἐν τοῖς ἀποστόλοις, οἳ καὶ πρὸ ἐμοῦ γεγόνασιν ἐν Χριστῷ. ");
INSERT INTO grctr_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ἀσπάσασθε Ἀμπλίαν τὸν ἀγαπητόν μου ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ἀσπάσασθε Οὐρβανὸν τὸν συνεργὸν ἡμῶν ἐν Χριστῷ, καὶ Στάχυν τὸν ἀγαπητόν μου. ");
INSERT INTO grctr_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ἀσπάσασθε Ἀπελλῆν τὸν δόκιμον ἐν Χριστῷ. Ἀσπάσασθε τοὺς ἐκ τῶν Ἀριστοβούλου. ");
INSERT INTO grctr_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ἀσπάσασθε Ἡροδίωνα τὸν συγγενῆ μου. Ἀσπάσασθε τοὺς ἐκ τῶν Ναρκίσσου, τοὺς ὄντας ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ἀσπάσασθε Τρύφαιναν καὶ Τρυφῶσαν τὰς κοπιώσας ἐν Κυρίῳ. Ἀσπάσασθε Περσίδα τὴν ἀγαπητήν, ἥτις πολλὰ ἐκοπίασεν ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ἀσπάσασθε Ῥοῦφον τὸν ἐκλεκτὸν ἐν Κυρίῳ, καὶ τὴν μητέρα αὐτοῦ καὶ ἐμοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ἀσπάσασθε Ἀσύγκριτον, Φλέγοντα, Ἑρμᾶν, Πατρόβαν, Ἑρμῆν, καὶ τοὺς σὺν αὐτοῖς ἀδελφούς. ");
INSERT INTO grctr_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ἀσπάσασθε Φιλόλογον καὶ Ἰουλίαν, Νηρέα καὶ τὴν ἀδελφὴν αὐτοῦ, καὶ Ὀλυμπᾶν, καὶ τοὺς σὺν αὐτοῖς πάντας ἁγίους. ");
INSERT INTO grctr_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ἀσπάσασθε ἀλλήλους ἐν φιλήματι ἁγίῳ. Ἀσπάζονται ὑμᾶς αἱ ἐκκλησίαι τοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, σκοπεῖν τοὺς τὰς διχοστασίας καὶ τὰ σκάνδαλα, παρὰ τὴν διδαχὴν ἣν ὑμεῖς ἐμάθετε, ποιοῦντας· καὶ ἐκκλίνατε ἀπ᾿ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Οἱ γὰρ τοιοῦτοι τῷ Κυρίῳ ἡμῶν Ἰησοῦ Χριστῷ οὐ δουλεύουσιν, ἀλλὰ τῇ ἑαυτῶν κοιλίᾳ· καὶ διὰ τῆς χρηστολογίας καὶ εὐλογίας ἐξαπατῶσι τὰς καρδίας τῶν ἀκάκων. ");
INSERT INTO grctr_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ἡ γὰρ ὑμῶν ὑπακοὴ εἰς πάντας ἀφίκετο. Χαίρω οὖν τὸ ἐφ᾿ ὑμῖν· θέλω δὲ ὑμᾶς σοφοὺς μὲν εἶναι εἰς τὸ ἀγαθόν, ἀκεραίους δὲ εἰς τὸ κακόν. ");
INSERT INTO grctr_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ὁ δὲ Θεὸς τῆς εἰρήνης συντρίψει τὸν Σατανᾶν ὑπὸ τοὺς πόδας ὑμῶν ἐν τάχει. Ἡ χάρις τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ μεθ᾿ ὑμῶν. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Ἀσπάζονται ὑμᾶς Τιμόθεος ὁ συνεργός μου, καὶ Λούκιος καὶ Ἰάσων καὶ Σωσίπατρος οἱ συγγενεῖς μου. ");
INSERT INTO grctr_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ἀσπάζομαι ὑμᾶς ἐγὼ Τέρτιος, ὁ γράψας τὴν ἐπιστολήν, ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Ἀσπάζεται ὑμᾶς Γάϊος ὁ ξένος μου καὶ τῆς ἐκκλησίας ὅλης. Ἀσπάζεται ὑμᾶς Ἔραστος ὁ οἰκονόμος τῆς πόλεως, καὶ Κούαρτος ὁ ἀδελφός. ");
INSERT INTO grctr_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Ἡ χάρις τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ μετὰ πάντων ὑμῶν. Ἀμήν. ");
INSERT INTO grctr_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Τῷ δὲ δυναμένῳ ὑμᾶς στηρίξαι κατὰ τὸ εὐαγγέλιόν μου καὶ τὸ κήρυγμα Ἰησοῦ Χριστοῦ, κατὰ ἀποκάλυψιν μυστηρίου χρόνοις αἰωνίοις σεσιγημένου, ");
INSERT INTO grctr_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","φανερωθέντος δὲ νῦν, διά τε γραφῶν προφητικῶν, κατ᾿ ἐπιταγὴν τοῦ αἰωνίου Θεοῦ, εἰς ὑπακοὴν πίστεως εἰς πάντα τὰ ἔθνη γνωρισθέντος, ");
INSERT INTO grctr_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","μόνῳ σοφῷ Θεῷ, διὰ Ἰησοῦ Χριστοῦ, ᾧ ἡ δόξα εἰς τοὺς αἰῶνας. Ἀμήν. Πρὸς Ῥωμαίους ἐγράφη ἀπὸ Κορίνθου διὰ Φοίβης τῆς διακόνου τῆς ἐν Κεγχρεαῖς ἐκκλησίας. ");
INSERT INTO grctr_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Παῦλος κλητὸς ἀπόστολος Ἰησοῦ Χριστοῦ διὰ θελήματος Θεοῦ, καὶ Σωσθένης ὁ ἀδελφός, ");
INSERT INTO grctr_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","τῇ ἐκκλησίᾳ τοῦ Θεοῦ τῇ οὔσῃ ἐν Κορίνθῳ, ἡγιασμένοις ἐν Χριστῷ Ἰησοῦ, κλητοῖς ἁγίοις, σὺν πᾶσι τοῖς ἐπικαλουμένοις τὸ ὄνομα τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ ἐν παντὶ τόπῳ, αὐτῶν τε καὶ ἡμῶν· ");
INSERT INTO grctr_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","χάρις ὑμῖν καὶ εἰρήνη ἀπὸ Θεοῦ πατρὸς ἡμῶν καὶ Κυρίου Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Εὐχαριστῶ τῷ Θεῷ μου πάντοτε περὶ ὑμῶν, ἐπὶ τῇ χάριτι τοῦ Θεοῦ τῇ δοθείσῃ ὑμῖν ἐν Χριστῷ Ἰησοῦ· ");
INSERT INTO grctr_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ὅτι ἐν παντὶ ἐπλουτίσθητε ἐν αὐτῷ, ἐν παντὶ λόγῳ καὶ πάσῃ γνώσει, ");
INSERT INTO grctr_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","καθὼς τὸ μαρτύριον τοῦ Χριστοῦ ἐβεβαιώθη ἐν ὑμῖν· ");
INSERT INTO grctr_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ὥστε ὑμᾶς μὴ ὑστερεῖσθαι ἐν μηδενὶ χαρίσματι, ἀπεκδεχομένους τὴν ἀποκάλυψιν τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, ");
INSERT INTO grctr_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ὃς καὶ βεβαιώσει ὑμᾶς ἕως τέλους, ἀνεγκλήτους ἐν τῇ ἡμέρᾳ τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Πιστὸς ὁ Θεός, δι᾿ οὗ ἐκλήθητε εἰς κοινωνίαν τοῦ υἱοῦ αὐτοῦ Ἰησοῦ Χριστοῦ τοῦ Κυρίου ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, διὰ τοῦ ὀνόματος τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, ἵνα τὸ αὐτὸ λέγητε πάντες, καὶ μὴ ᾖ ἐν ὑμῖν σχίσματα, ἦτε δὲ κατηρτισμένοι ἐν τῷ αὐτῷ νοῒ καὶ ἐν τῇ αὐτῇ γνώμῃ. ");
INSERT INTO grctr_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ἐδηλώθη γάρ μοι περὶ ὑμῶν, ἀδελφοί μου, ὑπὸ τῶν Χλόης, ὅτι ἔριδες ἐν ὑμῖν εἰσι. ");
INSERT INTO grctr_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Λέγω δὲ τοῦτο, ὅτι ἕκαστος ὑμῶν λέγει, Ἐγὼ μέν εἰμι Παύλου, Ἐγὼ δὲ Ἀπολλώ, Ἐγὼ δὲ Κηφᾶ, Ἐγὼ δὲ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Μεμέρισται ὁ Χριστός; Μὴ Παῦλος ἐσταυρώθη ὑπὲρ ὑμῶν, ἢ εἰς τὸ ὄνομα Παύλου ἐβαπτίσθητε; ");
INSERT INTO grctr_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Εὐχαριστῶ τῷ Θεῷ ὅτι οὐδένα ὑμῶν ἐβάπτισα, εἰ μὴ Κρίσπον καὶ Γάϊον· ");
INSERT INTO grctr_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ἵνα μή τις εἴπῃ ὅτι εἰς τὸ ἐμὸν ὄνομα ἐβάπτισα. ");
INSERT INTO grctr_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ἐβάπτισα δὲ καὶ τὸν Στεφανᾶ οἶκον· λοιπὸν οὐκ οἶδα εἴ τινα ἄλλον ἐβάπτισα. ");
INSERT INTO grctr_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Οὐ γὰρ ἀπέστειλέ με Χριστὸς βαπτίζειν, ἀλλ᾿ εὐαγγελίζεσθαι· οὐκ ἐν σοφίᾳ λόγου, ἵνα μὴ κενωθῇ ὁ σταυρὸς τοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ὁ λόγος γὰρ ὁ τοῦ σταυροῦ τοῖς μὲν ἀπολλυμένοις μωρία ἐστί, τοῖς δὲ σῳζομένοις ἡμῖν δύναμις Θεοῦ ἐστι. ");
INSERT INTO grctr_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Γέγραπται γάρ, Ἀπολῶ τὴν σοφίαν τῶν σοφῶν, καὶ τὴν σύνεσιν τῶν συνετῶν ἀθετήσω. ");
INSERT INTO grctr_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ποῦ σοφός; Ποῦ γραμματεύς; Ποῦ συζητητὴς τοῦ αἰῶνος τούτου; Οὐχὶ ἐμώρανεν ὁ Θεὸς τὴν σοφίαν τοῦ κόσμου τούτου; ");
INSERT INTO grctr_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ἐπειδὴ γὰρ ἐν τῇ σοφίᾳ τοῦ Θεοῦ οὐκ ἔγνω ὁ κόσμος διὰ τῆς σοφίας τὸν Θεόν, εὐδόκησεν ὁ Θεὸς διὰ τῆς μωρίας τοῦ κηρύγματος σῶσαι τοὺς πιστεύοντας. ");
INSERT INTO grctr_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ἐπειδὴ καὶ Ἰουδαῖοι σημεῖον αἰτοῦσι, καὶ Ἕλληνες σοφίαν ζητοῦσιν· ");
INSERT INTO grctr_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ἡμεῖς δὲ κηρύσσομεν Χριστὸν ἐσταυρωμένον, Ἰουδαίοις μὲν σκάνδαλον, Ἕλλησι δὲ μωρίαν· ");
INSERT INTO grctr_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","αὐτοῖς δὲ τοῖς κλητοῖς, Ἰουδαίοις τε καὶ Ἕλλησι, Χριστὸν Θεοῦ δύναμιν καὶ Θεοῦ σοφίαν. ");
INSERT INTO grctr_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Ὅτι τὸ μωρὸν τοῦ Θεοῦ σοφώτερον τῶν ἀνθρώπων ἐστί, καὶ τὸ ἀσθενὲς τοῦ Θεοῦ ἰσχυρότερον τῶν ἀνθρώπων ἐστί. ");
INSERT INTO grctr_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Βλέπετε γὰρ τὴν κλῆσιν ὑμῶν, ἀδελφοί, ὅτι οὐ πολλοὶ σοφοὶ κατὰ σάρκα, οὐ πολλοὶ δυνατοί, οὐ πολλοὶ εὐγενεῖς· ");
INSERT INTO grctr_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ἀλλὰ τὰ μωρὰ τοῦ κόσμου ἐξελέξατο ὁ Θεός, ἵνα τοὺς σοφοὺς καταισχύνῃ· καὶ τὰ ἀσθενῆ τοῦ κόσμου ἐξελέξατο ὁ Θεός, ἵνα καταισχύνῃ τὰ ἰσχυρά· ");
INSERT INTO grctr_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","καὶ τὰ ἀγενῆ τοῦ κόσμου καὶ τὰ ἐξουθενημένα ἐξελέξατο ὁ Θεός, καὶ τὰ μὴ ὄντα, ἵνα τὰ ὄντα καταργήσῃ· ");
INSERT INTO grctr_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ὅπως μὴ καυχήσηται πᾶσα σὰρξ ἐνώπιον αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ἐξ αὐτοῦ δὲ ὑμεῖς ἐστε ἐν Χριστῷ Ἰησοῦ, ὃς ἐγενήθη ἡμῖν σοφία ἀπὸ Θεοῦ, δικαιοσύνη τε καὶ ἁγιασμός, καὶ ἀπολύτρωσις· ");
INSERT INTO grctr_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ἵνα, καθὼς γέγραπται, Ὁ καυχώμενος, ἐν Κυρίῳ καυχάσθω. ");
INSERT INTO grctr_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Κἀγὼ ἐλθὼν πρὸς ὑμᾶς, ἀδελφοί, ἦλθον οὐ καθ᾿ ὑπεροχὴν λόγου ἢ σοφίας καταγγέλλων ὑμῖν τὸ μαρτύριον τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Οὐ γὰρ ἔκρινα τοῦ εἰδέναι τι ἐν ὑμῖν, εἰ μὴ Ἰησοῦν Χριστόν, καὶ τοῦτον ἐσταυρωμένον. ");
INSERT INTO grctr_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Καὶ ἐγὼ ἐν ἀσθενείᾳ καὶ ἐν φόβῳ καὶ ἐν τρόμῳ πολλῷ ἐγενόμην πρὸς ὑμᾶς. ");
INSERT INTO grctr_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Καὶ ὁ λόγος μου καὶ τὸ κήρυγμά μου οὐκ ἐν πειθοῖς ἀνθρωπίνης σοφίας λόγοις, ἀλλ᾿ ἐν ἀποδείξει πνεύματος καὶ δυνάμεως· ");
INSERT INTO grctr_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ἵνα ἡ πίστις ὑμῶν μὴ ᾖ ἐν σοφίᾳ ἀνθρώπων, ἀλλ᾿ ἐν δυνάμει Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Σοφίαν δὲ λαλοῦμεν ἐν τοῖς τελείοις· σοφίαν δὲ οὐ τοῦ αἰῶνος τούτου, οὐδὲ τῶν ἀρχόντων τοῦ αἰῶνος τούτου, τῶν καταργουμένων· ");
INSERT INTO grctr_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ἀλλὰ λαλοῦμεν σοφίαν Θεοῦ ἐν μυστηρίῳ, τὴν ἀποκεκρυμμένην, ἣν προώρισεν ὁ Θεὸς πρὸ τῶν αἰώνων εἰς δόξαν ἡμῶν· ");
INSERT INTO grctr_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ἣν οὐδεὶς τῶν ἀρχόντων τοῦ αἰῶνος τούτου ἔγνωκεν· εἰ γὰρ ἔγνωσαν, οὐκ ἂν τὸν Κύριον τῆς δόξης ἐσταύρωσαν· ");
INSERT INTO grctr_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ἀλλὰ καθὼς γέγραπται, Ἃ ὀφθαλμὸς οὐκ εἶδε, καὶ οὖς οὐκ ἤκουσε, καὶ ἐπὶ καρδίαν ἀνθρώπου οὐκ ἀνέβη, ἃ ἡτοίμασεν ὁ Θεὸς τοῖς ἀγαπῶσιν αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ἡμῖν δὲ ὁ Θεὸς ἀπεκάλυψε διὰ τοῦ πνεύματος αὐτοῦ· τὸ γὰρ πνεῦμα πάντα ἐρευνᾷ, καὶ τὰ βάθη τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Τίς γὰρ οἶδεν ἀνθρώπων τὰ τοῦ ἀνθρώπου, εἰ μὴ τὸ πνεῦμα τοῦ ἀνθρώπου τὸ ἐν αὐτῷ; Οὕτω καὶ τὰ τοῦ Θεοῦ οὐδεὶς οἶδεν, εἰ μὴ τὸ πνεῦμα τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Ἡμεῖς δὲ οὐ τὸ πνεῦμα τοῦ κόσμου ἐλάβομεν, ἀλλὰ τὸ πνεῦμα τὸ ἐκ τοῦ Θεοῦ, ἵνα εἰδῶμεν τὰ ὑπὸ τοῦ Θεοῦ χαρισθέντα ἡμῖν. ");
INSERT INTO grctr_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ἃ καὶ λαλοῦμεν, οὐκ ἐν διδακτοῖς ἀνθρωπίνης σοφίας λόγοις, ἀλλ᾿ ἐν διδακτοῖς πνεύματος ἁγίου, πνευματικοῖς πνευματικὰ συγκρίνοντες. ");
INSERT INTO grctr_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ψυχικὸς δὲ ἄνθρωπος οὐ δέχεται τὰ τοῦ πνεύματος τοῦ Θεοῦ· μωρία γὰρ αὐτῷ ἐστι, καὶ οὐ δύναται γνῶναι, ὅτι πνευματικῶς ἀνακρίνεται. ");
INSERT INTO grctr_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ὁ δὲ πνευματικὸς ἀνακρίνει μὲν πάντα, αὐτὸς δὲ ὑπ᾿ οὐδενὸς ἀνακρίνεται. ");
INSERT INTO grctr_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Τίς γὰρ ἔγνω νοῦν Κυρίου, ὃς συμβιβάσει αὐτόν; Ἡμεῖς δὲ νοῦν Χριστοῦ ἔχομεν. ");
INSERT INTO grctr_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Καὶ ἐγώ, ἀδελφοί, οὐκ ἠδυνήθην λαλῆσαι ὑμῖν ὡς πνευματικοῖς, ἀλλ᾿ ὡς σαρκικοῖς, ὡς νηπίοις ἐν Χριστῷ. ");
INSERT INTO grctr_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Γάλα ὑμᾶς ἐπότισα, καὶ οὐ βρῶμα· οὔπω γὰρ ἠδύνασθε, ἀλλ᾿ οὔτε ἔτι νῦν δύνασθε· ");
INSERT INTO grctr_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ἔτι γὰρ σαρκικοί ἐστε· ὅπου γὰρ ἐν ὑμῖν ζῆλος καὶ ἔρις καὶ διχοστασίαι, οὐχὶ σαρκικοί ἐστε, καὶ κατὰ ἄνθρωπον περιπατεῖτε; ");
INSERT INTO grctr_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Ὅταν γὰρ λέγῃ τις, Ἐγὼ μέν εἰμι Παύλου, ἕτερος δέ, Ἐγὼ Ἀπολλώ, οὐχὶ σαρκικοί ἐστε; ");
INSERT INTO grctr_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Τίς οὖν ἐστι Παῦλος, τίς δὲ Ἀπολλώς, ἀλλ᾿ ἢ διάκονοι δι᾿ ὧν ἐπιστεύσατε, καὶ ἑκάστῳ ὡς ὁ Κύριος ἔδωκεν; ");
INSERT INTO grctr_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ἐγὼ ἐφύτευσα, Ἀπολλὼς ἐπότισεν, ἀλλ᾿ ὁ Θεὸς ηὔξανεν. ");
INSERT INTO grctr_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ὥστε οὔτε ὁ φυτεύων ἐστί τι, οὔτε ὁ ποτίζων, ἀλλ᾿ ὁ αὐξάνων Θεός. ");
INSERT INTO grctr_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ὁ φυτεύων δὲ καὶ ὁ ποτίζων ἕν εἰσιν· ἕκαστος δὲ τὸν ἴδιον μισθὸν λήψεται κατὰ τὸν ἴδιον κόπον. ");
INSERT INTO grctr_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Θεοῦ γάρ ἐσμεν συνεργοί· Θεοῦ γεώργιον, Θεοῦ οἰκοδομή ἐστε. ");
INSERT INTO grctr_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Κατὰ τὴν χάριν τοῦ Θεοῦ τὴν δοθεῖσάν μοι, ὡς σοφὸς ἀρχιτέκτων θεμέλιον τέθεικα, ἄλλος δὲ ἐποικοδομεῖ. Ἕκαστος δὲ βλεπέτω πῶς ἐποικοδομεῖ. ");
INSERT INTO grctr_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Θεμέλιον γὰρ ἄλλον οὐδεὶς δύναται θεῖναι παρὰ τὸν κείμενον, ὅς ἐστιν Ἰησοῦς ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Εἰ δέ τις ἐποικοδομεῖ ἐπὶ τὸν θεμέλιον τοῦτον χρυσόν, ἄργυρον, λίθους τιμίους, ξύλα, χόρτον, καλάμην, ");
INSERT INTO grctr_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ἑκάστου τὸ ἔργον φανερὸν γενήσεται· ἡ γὰρ ἡμέρα δηλώσει, ὅτι ἐν πυρὶ ἀποκαλύπτεται· καὶ ἑκάστου τὸ ἔργον ὁποῖόν ἐστι τὸ πῦρ δοκιμάσει. ");
INSERT INTO grctr_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Εἴ τινος τὸ ἔργον μένει ὃ ἐπῳκοδόμησε, μισθὸν λήψεται. ");
INSERT INTO grctr_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Εἴ τινος τὸ ἔργον κατακαήσεται, ζημιωθήσεται· αὐτὸς δὲ σωθήσεται, οὕτω δὲ ὡς διὰ πυρός. ");
INSERT INTO grctr_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Οὐκ οἴδατε ὅτι ναὸς Θεοῦ ἐστε, καὶ τὸ πνεῦμα τοῦ Θεοῦ οἰκεῖ ἐν ὑμῖν; ");
INSERT INTO grctr_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Εἴ τις τὸν ναὸν τοῦ Θεοῦ φθείρει, φθερεῖ τοῦτον ὁ Θεός· ὁ γὰρ ναὸς τοῦ Θεοῦ ἅγιός ἐστιν, οἵτινές ἐστε ὑμεῖς. ");
INSERT INTO grctr_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Μηδεὶς ἑαυτὸν ἐξαπατάτω· εἴ τις δοκεῖ σοφὸς εἶναι ἐν ὑμῖν ἐν τῷ αἰῶνι τούτῳ, μωρὸς γενέσθω, ἵνα γένηται σοφός. ");
INSERT INTO grctr_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ἡ γὰρ σοφία τοῦ κόσμου τούτου μωρία παρὰ τῷ Θεῷ ἐστι. Γέγραπται γάρ, Ὁ δρασσόμενος τοὺς σοφοὺς ἐν τῇ πανουργίᾳ αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Καὶ πάλιν, Κύριος γινώσκει τοὺς διαλογισμοὺς τῶν σοφῶν, ὅτι εἰσὶ μάταιοι. ");
INSERT INTO grctr_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ὥστε μηδεὶς καυχάσθω ἐν ἀνθρώποις· πάντα γὰρ ὑμῶν ἐστιν, ");
INSERT INTO grctr_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","εἴτε Παῦλος, εἴτε Ἀπολλώς, εἴτε Κηφᾶς, εἴτε κόσμος, εἴτε ζωή, εἴτε θάνατος, εἴτε ἐνεστῶτα, εἴτε μέλλοντα· πάντα ὑμῶν ἐστιν, ");
INSERT INTO grctr_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ὑμεῖς δὲ Χριστοῦ, Χριστὸς δὲ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Οὕτως ἡμᾶς λογιζέσθω ἄνθρωπος, ὡς ὑπηρέτας Χριστοῦ καὶ οἰκονόμους μυστηρίων Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ὃ δὲ λοιπόν, ζητεῖται ἐν τοῖς οἰκονόμοις, ἵνα πιστός τις εὑρεθῇ. ");
INSERT INTO grctr_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ἐμοὶ δὲ εἰς ἐλάχιστόν ἐστιν ἵνα ὑφ᾿ ὑμῶν ἀνακριθῶ, ἢ ὑπὸ ἀνθρωπίνης ἡμέρας· ἀλλ᾿ οὐδὲ ἐμαυτὸν ἀνακρίνω. ");
INSERT INTO grctr_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Οὐδὲν γὰρ ἐμαυτῷ σύνοιδα, ἀλλ᾿ οὐκ ἐν τούτῳ δεδικαίωμαι· ὁ δὲ ἀνακρίνων με Κύριός ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ὥστε μὴ πρὸ καιροῦ τι κρίνετε, ἕως ἂν ἔλθῃ ὁ Κύριος, ὃς καὶ φωτίσει τὰ κρυπτὰ τοῦ σκότους, καὶ φανερώσει τὰς βουλὰς τῶν καρδιῶν· καὶ τότε ὁ ἔπαινος γενήσεται ἑκάστῳ ἀπὸ τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ταῦτα δέ, ἀδελφοί, μετεσχημάτισα εἰς ἐμαυτὸν καὶ Ἀπολλὼ δι᾿ ὑμᾶς, ἵνα ἐν ἡμῖν μάθητε τὸ μὴ ὑπὲρ ὃ γέγραπται φρονεῖν, ἵνα μὴ εἷς ὑπὲρ τοῦ ἑνὸς φυσιοῦσθε κατὰ τοῦ ἑτέρου. ");
INSERT INTO grctr_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Τίς γάρ σε διακρίνει; Τί δὲ ἔχεις ὃ οὐκ ἔλαβες; Εἰ δὲ καὶ ἔλαβες, τί καυχᾶσαι ὡς μὴ λαβών; ");
INSERT INTO grctr_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ἤδη κεκορεσμένοι ἐστέ, ἤδη ἐπλουτήσατε, χωρὶς ἡμῶν ἐβασιλεύσατε· καὶ ὄφελόν γε ἐβασιλεύσατε, ἵνα καὶ ἡμεῖς ὑμῖν συμβασιλεύσωμεν. ");
INSERT INTO grctr_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Δοκῶ γὰρ ὅτι ὁ Θεὸς ἡμᾶς τοὺς ἀποστόλους ἐσχάτους ἀπέδειξεν ὡς ἐπιθανατίους· ὅτι θέατρον ἐγενήθημεν τῷ κόσμῳ, καὶ ἀγγέλοις, καὶ ἀνθρώποις. ");
INSERT INTO grctr_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Ἡμεῖς μωροὶ διὰ Χριστόν, ὑμεῖς δὲ φρόνιμοι ἐν Χριστῷ· ἡμεῖς ἀσθενεῖς, ὑμεῖς δὲ ἰσχυροί· ὑμεῖς ἔνδοξοι, ἡμεῖς δὲ ἄτιμοι. ");
INSERT INTO grctr_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Ἄχρι τῆς ἄρτι ὥρας καὶ πεινῶμεν, καὶ διψῶμεν, καὶ γυμνητεύομεν, καὶ κολαφιζόμεθα, καὶ ἀστατοῦμεν, ");
INSERT INTO grctr_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","καὶ κοπιῶμεν ἐργαζόμενοι ταῖς ἰδίαις χερσί· λοιδορούμενοι εὐλογοῦμεν· διωκόμενοι ἀνεχόμεθα· ");
INSERT INTO grctr_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","βλασφημούμενοι παρακαλοῦμεν· ὡς περικαθάρματα τοῦ κόσμου ἐγενήθημεν, πάντων περίψημα ἕως ἄρτι. ");
INSERT INTO grctr_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Οὐκ ἐντρέπων ὑμᾶς γράφω ταῦτα, ἀλλ᾿ ὡς τέκνα μου ἀγαπητὰ νουθετῶ. ");
INSERT INTO grctr_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Ἐὰν γὰρ μυρίους παιδαγωγοὺς ἔχητε ἐν Χριστῷ, ἀλλ᾿ οὐ πολλοὺς πατέρας· ἐν γὰρ Χριστῷ Ἰησοῦ διὰ τοῦ εὐαγγελίου ἐγὼ ὑμᾶς ἐγέννησα. ");
INSERT INTO grctr_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Παρακαλῶ οὖν ὑμᾶς, μιμηταί μου γίνεσθε. ");
INSERT INTO grctr_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Διὰ τοῦτο ἔπεμψα ὑμῖν Τιμόθεον, ὅς ἐστι τέκνον μου ἀγαπητὸν καὶ πιστὸν ἐν Κυρίῳ, ὃς ὑμᾶς ἀναμνήσει τὰς ὁδούς μου τὰς ἐν Χριστῷ, καθὼς πανταχοῦ ἐν πάσῃ ἐκκλησίᾳ διδάσκω. ");
INSERT INTO grctr_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Ὡς μὴ ἐρχομένου δέ μου πρὸς ὑμᾶς ἐφυσιώθησάν τινες. ");
INSERT INTO grctr_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ἐλεύσομαι δὲ ταχέως πρὸς ὑμᾶς, ἐὰν ὁ Κύριος θελήσῃ, καὶ γνώσομαι οὐ τὸν λόγον τῶν πεφυσιωμένων, ἀλλὰ τὴν δύναμιν. ");
INSERT INTO grctr_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Οὐ γὰρ ἐν λόγῳ ἡ βασιλεία τοῦ Θεοῦ, ἀλλ᾿ ἐν δυνάμει. ");
INSERT INTO grctr_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Τί θέλετε; Ἐν ῥάβδῳ ἔλθω πρὸς ὑμᾶς, ἢ ἐν ἀγάπῃ πνεύματί τε πρᾳότητος; ");
INSERT INTO grctr_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Ὅλως ἀκούεται ἐν ὑμῖν πορνεία, καὶ τοιαύτη πορνεία, ἥτις οὐδὲ ἐν τοῖς ἔθνεσιν ὀνομάζεται, ὥστε γυναῖκά τινα τοῦ πατρὸς ἔχειν. ");
INSERT INTO grctr_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Καὶ ὑμεῖς πεφυσιωμένοι ἐστέ, καὶ οὐχὶ μᾶλλον ἐπενθήσατε, ἵνα ἐξαρθῇ ἐκ μέσου ὑμῶν ὁ τὸ ἔργον τοῦτο ποιήσας. ");
INSERT INTO grctr_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ἐγὼ μὲν γὰρ ὡς ἀπὼν τῷ σώματι παρὼν δὲ τῷ πνεύματι, ἤδη κέκρικα ὡς παρών, τὸν οὕτω τοῦτο κατεργασάμενον, ");
INSERT INTO grctr_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ἐν τῷ ὀνόματι τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, συναχθέντων ὑμῶν καὶ τοῦ ἐμοῦ πνεύματος, σὺν τῇ δυνάμει τοῦ Κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, ");
INSERT INTO grctr_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","παραδοῦναι τὸν τοιοῦτον τῷ Σατανᾷ εἰς ὄλεθρον τῆς σαρκός, ἵνα τὸ πνεῦμα σωθῇ ἐν τῇ ἡμέρᾳ τοῦ Κυρίου Ἰησοῦ. ");
INSERT INTO grctr_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Οὐ καλὸν τὸ καύχημα ὑμῶν. Οὐκ οἴδατε ὅτι μικρὰ ζύμη ὅλον τὸ φύραμα ζυμοῖ; ");
INSERT INTO grctr_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Ἐκκαθάρατε οὖν τὴν παλαιὰν ζύμην, ἵνα ἦτε νέον φύραμα, καθώς ἐστε ἄζυμοι. Καὶ γὰρ τὸ Πάσχα ἡμῶν ὑπὲρ ἡμῶν ἐθύθη Χριστός· ");
INSERT INTO grctr_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ὥστε ἑορτάζωμεν, μὴ ἐν ζύμῃ παλαιᾷ, μηδὲ ἐν ζύμῃ κακίας καὶ πονηρίας, ἀλλ᾿ ἐν ἀζύμοις εἰλικρινείας καὶ ἀληθείας. ");
INSERT INTO grctr_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ἔγραψα ὑμῖν ἐν τῇ ἐπιστολῇ μὴ συναναμίγνυσθαι πόρνοις· ");
INSERT INTO grctr_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","καὶ οὐ πάντως τοῖς πόρνοις τοῦ κόσμου τούτου ἢ τοῖς πλεονέκταις, ἢ ἅρπαξιν, ἢ εἰδωλολάτραις· ἐπεὶ ὀφείλετε ἄρα ἐκ τοῦ κόσμου ἐξελθεῖν. ");
INSERT INTO grctr_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Νυνὶ δὲ ἔγραψα ὑμῖν μὴ συναναμίγνυσθαι, ἐάν τις ἀδελφὸς ὀνομαζόμενος ᾖ πόρνος, ἢ πλεονέκτης, ἢ εἰδωλολάτρης, ἢ λοίδορος, ἢ μέθυσος, ἢ ἅρπαξ· τῷ τοιούτῳ μηδὲ συνεσθίειν. ");
INSERT INTO grctr_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Τί γάρ μοι καὶ τοὺς ἔξω κρίνειν; Οὐχὶ τοὺς ἔσω ὑμεῖς κρίνετε; ");
INSERT INTO grctr_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Τοὺς δὲ ἔξω ὁ Θεὸς κρίνει. Καὶ ἐξαρεῖτε τὸν πονηρὸν ἐξ ὑμῶν αὐτῶν. ");
INSERT INTO grctr_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Τολμᾷ τις ὑμῶν, πρᾶγμα ἔχων πρὸς τὸν ἕτερον, κρίνεσθαι ἐπὶ τῶν ἀδίκων, καὶ οὐχὶ ἐπὶ τῶν ἁγίων; ");
INSERT INTO grctr_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Οὐκ οἴδατε ὅτι οἱ ἅγιοι τὸν κόσμον κρινοῦσι; Καὶ εἰ ἐν ὑμῖν κρίνεται ὁ κόσμος, ἀνάξιοί ἐστε κριτηρίων ἐλαχίστων; ");
INSERT INTO grctr_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Οὐκ οἴδατε ὅτι ἀγγέλους κρινοῦμεν; Μήτι γε βιωτικά; ");
INSERT INTO grctr_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Βιωτικὰ μὲν οὖν κριτήρια ἐὰν ἔχητε, τοὺς ἐξουθενημένους ἐν τῇ ἐκκλησίᾳ, τούτους καθίζετε. ");
INSERT INTO grctr_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Πρὸς ἐντροπὴν ὑμῖν λέγω. Οὕτως οὐκ ἔστιν ἐν ὑμῖν σοφὸς οὐδὲ εἷς, ὃς δυνήσεται διακρῖναι ἀνὰ μέσον τοῦ ἀδελφοῦ αὐτοῦ, ");
INSERT INTO grctr_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ἀλλὰ ἀδελφὸς μετὰ ἀδελφοῦ κρίνεται, καὶ τοῦτο ἐπὶ ἀπίστων; ");
INSERT INTO grctr_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ἤδη μὲν οὖν ὅλως ἥττημα ἐν ὑμῖν ἐστιν, ὅτι κρίματα ἔχετε μεθ᾿ ἑαυτῶν. Διὰ τί οὐχὶ μᾶλλον ἀδικεῖσθε; Διὰ τί οὐχὶ μᾶλλον ἀποστερεῖσθε; ");
INSERT INTO grctr_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ἀλλὰ ὑμεῖς ἀδικεῖτε καὶ ἀποστερεῖτε, καὶ ταῦτα ἀδελφούς. ");
INSERT INTO grctr_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ἢ οὐκ οἴδατε ὅτι ἄδικοι βασιλείαν Θεοῦ οὐ κληρονομήσουσι; Μὴ πλανᾶσθε· οὔτε πόρνοι, οὔτε εἰδωλολάτραι, οὔτε μοιχοί, οὔτε μαλακοί, οὔτε ἀρσενοκοῖται, ");
INSERT INTO grctr_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","οὔτε κλέπται, οὔτε πλεονέκται, οὔτε μέθυσοι, οὐ λοίδοροι, οὐχ ἅρπαγες, βασιλείαν Θεοῦ οὐ κληρονομήσουσι. ");
INSERT INTO grctr_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Καὶ ταῦτά τινες ἦτε· ἀλλὰ ἀπελούσασθε, ἀλλὰ ἡγιάσθητε, ἀλλ᾿ ἐδικαιώθητε ἐν τῷ ὀνόματι τοῦ Κυρίου Ἰησοῦ, καὶ ἐν τῷ πνεύματι τοῦ Θεοῦ ἡμῶν. ");
INSERT INTO grctr_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Πάντα μοι ἔξεστιν, ἀλλ᾿ οὐ πάντα συμφέρει· πάντα μοι ἔξεστιν, ἀλλ᾿ οὐκ ἐγὼ ἐξουσιασθήσομαι ὑπό τινος. ");
INSERT INTO grctr_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Τὰ βρώματα τῇ κοιλίᾳ, καὶ ἡ κοιλία τοῖς βρώμασιν· ὁ δὲ Θεὸς καὶ ταύτην καὶ ταῦτα καταργήσει. Τὸ δὲ σῶμα οὐ τῇ πορνείᾳ, ἀλλὰ τῷ Κυρίῳ, καὶ ὁ Κύριος τῷ σώματι· ");
INSERT INTO grctr_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ὁ δὲ Θεὸς καὶ τὸν Κύριον ἤγειρε καὶ ἡμᾶς ἐξεγερεῖ διὰ τῆς δυνάμεως αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Οὐκ οἴδατε ὅτι τὰ σώματα ὑμῶν μέλη Χριστοῦ ἐστιν; Ἄρας οὖν τὰ μέλη τοῦ Χριστοῦ ποιήσω πόρνης μέλη; Μὴ γένοιτο. ");
INSERT INTO grctr_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Ἢ οὐκ οἴδατε ὅτι ὁ κολλώμενος τῇ πόρνῃ ἓν σῶμά ἐστιν; Ἔσονται γάρ, φησίν, οἱ δύο εἰς σάρκα μίαν. ");
INSERT INTO grctr_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ὁ δὲ κολλώμενος τῷ Κυρίῳ ἓν πνεῦμά ἐστι. ");
INSERT INTO grctr_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Φεύγετε τὴν πορνείαν. Πᾶν ἁμάρτημα ὃ ἐὰν ποιήσῃ ἄνθρωπος ἐκτὸς τοῦ σώματός ἐστιν· ὁ δὲ πορνεύων εἰς τὸ ἴδιον σῶμα ἁμαρτάνει. ");
INSERT INTO grctr_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ἢ οὐκ οἴδατε ὅτι τὸ σῶμα ὑμῶν ναὸς τοῦ ἐν ὑμῖν ἁγίου πνεύματός ἐστιν, οὗ ἔχετε ἀπὸ Θεοῦ; Καὶ οὐκ ἐστὲ ἑαυτῶν, ");
INSERT INTO grctr_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ἠγοράσθητε γὰρ τιμῆς· δοξάσατε δὴ τὸν Θεὸν ἐν τῷ σώματι ὑμῶν, καὶ ἐν τῷ πνεύματι ὑμῶν, ἅτινά ἐστι τοῦ Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Περὶ δὲ ὧν ἐγράψατέ μοι, καλὸν ἀνθρώπῳ γυναικὸς μὴ ἅπτεσθαι. ");
INSERT INTO grctr_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Διὰ δὲ τὰς πορνείας ἕκαστος τὴν ἑαυτοῦ γυναῖκα ἐχέτω, καὶ ἑκάστη τὸν ἴδιον ἄνδρα ἐχέτω. ");
INSERT INTO grctr_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Τῇ γυναικὶ ὁ ἀνὴρ τὴν ὀφειλομένην εὔνοιαν ἀποδιδότω· ὁμοίως δὲ καὶ ἡ γυνὴ τῷ ἀνδρί. ");
INSERT INTO grctr_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Ἡ γυνὴ τοῦ ἰδίου σώματος οὐκ ἐξουσιάζει, ἀλλ᾿ ὁ ἀνήρ· ὁμοίως δὲ καὶ ὁ ἀνὴρ τοῦ ἰδίου σώματος οὐκ ἐξουσιάζει, ἀλλ᾿ ἡ γυνή. ");
INSERT INTO grctr_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Μὴ ἀποστερεῖτε ἀλλήλους, εἰ μήτι ἂν ἐκ συμφώνου πρὸς καιρόν, ἵνα σχολάζητε τῇ νηστείᾳ καὶ τῇ προσευχῇ, καὶ πάλιν ἐπὶ τὸ αὐτὸ συνέρχησθε, ἵνα μὴ πειράζῃ ὑμᾶς ὁ Σατανᾶς διὰ τὴν ἀκρασίαν ὑμῶν. ");
INSERT INTO grctr_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Τοῦτο δὲ λέγω κατὰ συγγνώμην, οὐ κατ᾿ ἐπιταγήν. ");
INSERT INTO grctr_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Θέλω γὰρ πάντας ἀνθρώπους εἶναι ὡς καὶ ἐμαυτόν· ἀλλ᾿ ἕκαστος ἴδιον χάρισμα ἔχει ἐκ Θεοῦ, ὃς μὲν οὕτως, ὃς δὲ οὕτως. ");
INSERT INTO grctr_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Λέγω δὲ τοῖς ἀγάμοις καὶ ταῖς χήραις, καλὸν αὐτοῖς ἐστιν ἐὰν μείνωσιν ὡς κἀγώ. ");
INSERT INTO grctr_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Εἰ δὲ οὐκ ἐγκρατεύονται, γαμησάτωσαν· κρεῖσσον γάρ ἐστι γαμῆσαι ἢ πυροῦσθαι. ");
INSERT INTO grctr_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Τοῖς δὲ γεγαμηκόσι παραγγέλλω, οὐκ ἐγώ, ἀλλ᾿ ὁ Κύριος, γυναῖκα ἀπὸ ἀνδρὸς μὴ χωρισθῆναι· ");
INSERT INTO grctr_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ἐὰν δὲ καὶ χωρισθῇ, μενέτω ἄγαμος, ἢ τῷ ἀνδρὶ καταλλαγήτω — καὶ ἄνδρα γυναῖκα μὴ ἀφιέναι. ");
INSERT INTO grctr_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Τοῖς δὲ λοιποῖς ἐγὼ λέγω, οὐχ ὁ Κύριος· εἴ τις ἀδελφὸς γυναῖκα ἔχει ἄπιστον, καὶ αὐτὴ συνευδοκεῖ οἰκεῖν μετ᾿ αὐτοῦ, μὴ ἀφιέτω αὐτήν. ");
INSERT INTO grctr_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Καὶ γυνὴ ἥτις ἔχει ἄνδρα ἄπιστον, καὶ αὐτὸς συνευδοκεῖ οἰκεῖν μετ᾿ αὐτῆς, μὴ ἀφιέτω αὐτόν. ");
INSERT INTO grctr_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Ἡγίασται γὰρ ὁ ἀνὴρ ὁ ἄπιστος ἐν τῇ γυναικί, καὶ ἡγίασται ἡ γυνὴ ἡ ἄπιστος ἐν τῷ ἀνδρί· ἐπεὶ ἄρα τὰ τέκνα ὑμῶν ἀκάθαρτά ἐστι, νῦν δὲ ἅγιά ἐστιν. ");
INSERT INTO grctr_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Εἰ δὲ ὁ ἄπιστος χωρίζεται, χωριζέσθω. Οὐ δεδούλωται ὁ ἀδελφὸς ἢ ἡ ἀδελφὴ ἐν τοῖς τοιούτοις· ἐν δὲ εἰρήνῃ κέκληκεν ἡμᾶς ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Τί γὰρ οἶδας, γύναι, εἰ τὸν ἄνδρα σώσεις; Ἢ τί οἶδας, ἄνερ, εἰ τὴν γυναῖκα σώσεις; ");
INSERT INTO grctr_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Εἰ μὴ ἑκάστῳ ὡς ἐμέρισεν ὁ Θεός, ἕκαστον ὡς κέκληκεν ὁ Κύριος, οὕτω περιπατείτω. Καὶ οὕτως ἐν ταῖς ἐκκλησίαις πάσαις διατάσσομαι. ");
INSERT INTO grctr_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Περιτετμημένος τις ἐκλήθη; Μὴ ἐπισπάσθω. Ἐν ἀκροβυστίᾳ τις ἐκλήθη; Μὴ περιτεμνέσθω. ");
INSERT INTO grctr_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Ἡ περιτομὴ οὐδέν ἐστι, καὶ ἡ ἀκροβυστία οὐδέν ἐστιν, ἀλλὰ τήρησις ἐντολῶν Θεοῦ. ");
INSERT INTO grctr_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ἕκαστος ἐν τῇ κλήσει ᾗ ἐκλήθη, ἐν ταύτῃ μενέτω. ");
INSERT INTO grctr_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Δοῦλος ἐκλήθης; Μή σοι μελέτω· ἀλλ᾿ εἰ καὶ δύνασαι ἐλεύθερος γενέσθαι, μᾶλλον χρῆσαι. ");
INSERT INTO grctr_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ὁ γὰρ ἐν Κυρίῳ κληθεὶς δοῦλος, ἀπελεύθερος Κυρίου ἐστίν· ὁμοίως καὶ ὁ ἐλεύθερος κληθείς, δοῦλός ἐστι Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Τιμῆς ἠγοράσθητε· μὴ γίνεσθε δοῦλοι ἀνθρώπων. ");
INSERT INTO grctr_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Ἕκαστος ἐν ᾧ ἐκλήθη, ἀδελφοί, ἐν τούτῳ μενέτω παρὰ τῷ Θεῷ. ");
INSERT INTO grctr_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Περὶ δὲ τῶν παρθένων ἐπιταγὴν Κυρίου οὐκ ἔχω· γνώμην δὲ δίδωμι ὡς ἠλεημένος ὑπὸ Κυρίου πιστὸς εἶναι. ");
INSERT INTO grctr_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Νομίζω οὖν τοῦτο καλὸν ὑπάρχειν διὰ τὴν ἐνεστῶσαν ἀνάγκην, ὅτι καλὸν ἀνθρώπῳ τὸ οὕτως εἶναι. ");
INSERT INTO grctr_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Δέδεσαι γυναικί; Μὴ ζήτει λύσιν. Λέλυσαι ἀπὸ γυναικός; Μὴ ζήτει γυναῖκα. ");
INSERT INTO grctr_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ἐὰν δὲ καὶ γήμῃς, οὐχ ἥμαρτες· καὶ ἐὰν γήμῃ ἡ παρθένος, οὐχ ἥμαρτε. Θλίψιν δὲ τῇ σαρκὶ ἕξουσιν οἱ τοιοῦτοι· ἐγὼ δὲ ὑμῶν φείδομαι. ");
INSERT INTO grctr_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Τοῦτο δέ φημι, ἀδελφοί, ὅτι ὁ καιρὸς συνεσταλμένος· τὸ λοιπόν ἐστιν ἵνα καὶ οἱ ἔχοντες γυναῖκας ὡς μὴ ἔχοντες ὦσι· ");
INSERT INTO grctr_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","καὶ οἱ κλαίοντες, ὡς μὴ κλαίοντες· καὶ οἱ χαίροντες, ὡς μὴ χαίροντες· καὶ οἱ ἀγοράζοντες, ὡς μὴ κατέχοντες· ");
INSERT INTO grctr_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","καὶ οἱ χρώμενοι τῷ κόσμῳ τούτῳ, ὡς μὴ καταχρώμενοι· παράγει γὰρ τὸ σχῆμα τοῦ κόσμου τούτου. ");
INSERT INTO grctr_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Θέλω δὲ ὑμᾶς ἀμερίμνους εἶναι. Ὁ ἄγαμος μεριμνᾷ τὰ τοῦ Κυρίου, πῶς ἀρέσει τῷ Κυρίῳ· ");
INSERT INTO grctr_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ὁ δὲ γαμήσας μεριμνᾷ τὰ τοῦ κόσμου, πῶς ἀρέσει τῇ γυναικί. ");
INSERT INTO grctr_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Μεμέρισται ἡ γυνὴ καὶ ἡ παρθένος. Ἡ ἄγαμος μεριμνᾷ τὰ τοῦ Κυρίου, ἵνα ᾖ ἁγία καὶ σώματι καὶ πνεύματι· ἡ δὲ γαμήσασα μεριμνᾷ τὰ τοῦ κόσμου, πῶς ἀρέσει τῷ ἀνδρί. ");
INSERT INTO grctr_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Τοῦτο δὲ πρὸς τὸ ὑμῶν αὐτῶν συμφέρον λέγω· οὐχ ἵνα βρόχον ὑμῖν ἐπιβάλω, ἀλλὰ πρὸς τὸ εὔσχημον καὶ εὐπρόσεδρον τῷ Κυρίῳ ἀπερισπάστως. ");
INSERT INTO grctr_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Εἰ δέ τις ἀσχημονεῖν ἐπὶ τὴν παρθένον αὐτοῦ νομίζει, ἐὰν ᾖ ὑπέρακμος, καὶ οὕτως ὀφείλει γίνεσθαι, ὃ θέλει ποιείτω· οὐχ ἁμαρτάνει· γαμείτωσαν. ");
INSERT INTO grctr_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ὃς δὲ ἕστηκεν ἑδραῖος ἐν τῇ καρδίᾳ, μὴ ἔχων ἀνάγκην, ἐξουσίαν δὲ ἔχει περὶ τοῦ ἰδίου θελήματος, καὶ τοῦτο κέκρικεν ἐν τῇ καρδίᾳ αὐτοῦ, τοῦ τηρεῖν τὴν ἑαυτοῦ παρθένον, καλῶς ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ὥστε καὶ ὁ ἐκγαμίζων καλῶς ποιεῖ· ὁ δὲ μὴ ἐκγαμίζων κρεῖσσον ποιεῖ. ");
INSERT INTO grctr_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Γυνὴ δέδεται νόμῳ ἐφ᾿ ὅσον χρόνον ζῇ ὁ ἀνὴρ αὐτῆς· ἐὰν δὲ κοιμηθῇ ὁ ἀνὴρ αὐτῆς, ἐλευθέρα ἐστὶν ᾧ θέλει γαμηθῆναι, μόνον ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Μακαριωτέρα δέ ἐστιν ἐὰν οὕτω μείνῃ, κατὰ τὴν ἐμὴν γνώμην· δοκῶ δὲ κἀγὼ πνεῦμα Θεοῦ ἔχειν. ");
INSERT INTO grctr_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Περὶ δὲ τῶν εἰδωλοθύτων, οἴδαμεν ὅτι πάντες γνῶσιν ἔχομεν. Ἡ γνῶσις φυσιοῖ, ἡ δὲ ἀγάπη οἰκοδομεῖ. ");
INSERT INTO grctr_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Εἰ δέ τις δοκεῖ εἰδέναι τι, οὐδέπω οὐδὲν ἔγνωκε καθὼς δεῖ γνῶναι· ");
INSERT INTO grctr_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","εἰ δέ τις ἀγαπᾷ τὸν Θεόν, οὗτος ἔγνωσται ὑπ᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Περὶ τῆς βρώσεως οὖν τῶν εἰδωλοθύτων, οἴδαμεν ὅτι οὐδὲν εἴδωλον ἐν κόσμῳ, καὶ ὅτι οὐδεὶς Θεὸς ἕτερος εἰ μὴ εἷς. ");
INSERT INTO grctr_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Καὶ γὰρ εἴπερ εἰσὶ λεγόμενοι θεοί, εἴτε ἐν οὐρανῷ εἴτε ἐπὶ τῆς γῆς· ὥσπερ εἰσὶ θεοὶ πολλοί, καὶ κύριοι πολλοί· ");
INSERT INTO grctr_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ἀλλ᾿ ἡμῖν εἷς Θεὸς ὁ πατήρ, ἐξ οὗ τὰ πάντα, καὶ ἡμεῖς εἰς αὐτόν· καὶ εἷς Κύριος Ἰησοῦς Χριστός, δι᾿ οὗ τὰ πάντα, καὶ ἡμεῖς δι᾿ αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ἀλλ᾿ οὐκ ἐν πᾶσιν ἡ γνῶσις· τινὲς δὲ τῇ συνειδήσει τοῦ εἰδώλου ἕως ἄρτι ὡς εἰδωλόθυτον ἐσθίουσι, καὶ ἡ συνείδησις αὐτῶν ἀσθενὴς οὖσα μολύνεται. ");
INSERT INTO grctr_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Βρῶμα δὲ ἡμᾶς οὐ παρίστησι τῷ Θεῷ· οὔτε γὰρ ἐὰν φάγωμεν περισσεύομεν, οὔτε ἐὰν μὴ φάγωμεν ὑστερούμεθα. ");
INSERT INTO grctr_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Βλέπετε δὲ μήπως ἡ ἐξουσία ὑμῶν αὕτη πρόσκομμα γένηται τοῖς ἀσθενοῦσιν. ");
INSERT INTO grctr_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ἐὰν γάρ τις ἴδῃ σε τὸν ἔχοντα γνῶσιν ἐν εἰδωλείῳ κατακείμενον, οὐχὶ ἡ συνείδησις αὐτοῦ ἀσθενοῦς ὄντος οἰκοδομηθήσεται εἰς τὸ τὰ εἰδωλόθυτα ἐσθίειν; ");
INSERT INTO grctr_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Καὶ ἀπολεῖται ὁ ἀσθενῶν ἀδελφὸς ἐπὶ τῇ σῇ γνώσει, δι᾿ ὃν Χριστὸς ἀπέθανεν; ");
INSERT INTO grctr_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Οὕτω δὲ ἁμαρτάνοντες εἰς τοὺς ἀδελφούς, καὶ τύπτοντες αὐτῶν τὴν συνείδησιν ἀσθενοῦσαν, εἰς Χριστὸν ἁμαρτάνετε. ");
INSERT INTO grctr_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Διόπερ εἰ βρῶμα σκανδαλίζει τὸν ἀδελφόν μου, οὐ μὴ φάγω κρέα εἰς τὸν αἰῶνα, ἵνα μὴ τὸν ἀδελφόν μου σκανδαλίσω. ");
INSERT INTO grctr_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Οὐκ εἰμὶ ἀπόστολος; Οὐκ εἰμὶ ἐλεύθερος; Οὐχὶ Ἰησοῦν Χριστὸν τὸν Κύριον ἡμῶν ἑώρακα; Οὐ τὸ ἔργον μου ὑμεῖς ἐστε ἐν Κυρίῳ; ");
INSERT INTO grctr_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Εἰ ἄλλοις οὐκ εἰμὶ ἀπόστολος, ἀλλά γε ὑμῖν εἰμι· ἡ γὰρ σφραγὶς τῆς ἐμῆς ἀποστολῆς ὑμεῖς ἐστε ἐν Κυρίῳ. ");
INSERT INTO grctr_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Ἡ ἐμὴ ἀπολογία τοῖς ἐμὲ ἀνακρίνουσιν αὕτη ἐστί. ");
INSERT INTO grctr_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Μὴ οὐκ ἔχομεν ἐξουσίαν φαγεῖν καὶ πιεῖν; ");
INSERT INTO grctr_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Μὴ οὐκ ἔχομεν ἐξουσίαν ἀδελφὴν γυναῖκα περιάγειν, ὡς καὶ οἱ λοιποὶ ἀπόστολοι, καὶ οἱ ἀδελφοὶ τοῦ Κυρίου, καὶ Κηφᾶς; ");
INSERT INTO grctr_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Ἢ μόνος ἐγὼ καὶ Βαρνάβας οὐκ ἔχομεν ἐξουσίαν τοῦ μὴ ἐργάζεσθαι; ");
INSERT INTO grctr_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Τίς στρατεύεται ἰδίοις ὀψωνίοις ποτέ; Τίς φυτεύει ἀμπελῶνα, καὶ ἐκ τοῦ καρποῦ αὐτοῦ οὐκ ἐσθίει; Ἢ τίς ποιμαίνει ποίμνην, καὶ ἐκ τοῦ γάλακτος τῆς ποίμνης οὐκ ἐσθίει; ");
INSERT INTO grctr_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Μὴ κατὰ ἄνθρωπον ταῦτα λαλῶ; Ἢ οὐχὶ καὶ ὁ νόμος ταῦτα λέγει; ");
INSERT INTO grctr_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Ἐν γὰρ τῷ Μωσέως νόμῳ γέγραπται, Οὐ φιμώσεις βοῦν ἀλοῶντα. Μὴ τῶν βοῶν μέλει τῷ Θεῷ; ");
INSERT INTO grctr_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ἢ δι᾿ ἡμᾶς πάντως λέγει; Δι᾿ ἡμᾶς γὰρ ἐγράφη, ὅτι ἐπ᾿ ἐλπίδι ὀφείλει ὁ ἀροτριῶν ἀροτριᾷν, καὶ ὁ ἀλοῶν τῆς ἐλπίδος αὐτοῦ μετέχειν ἐπ᾿ ἐλπίδι. ");
INSERT INTO grctr_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Εἰ ἡμεῖς ὑμῖν τὰ πνευματικὰ ἐσπείραμεν, μέγα εἰ ἡμεῖς ὑμῶν τὰ σαρκικὰ θερίσομεν; ");
INSERT INTO grctr_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Εἰ ἄλλοι τῆς ἐξουσίας ὑμῶν μετέχουσιν, οὐ μᾶλλον ἡμεῖς; Ἀλλ᾿ οὐκ ἐχρησάμεθα τῇ ἐξουσίᾳ ταύτῃ, ἀλλὰ πάντα στέγομεν, ἵνα μὴ ἐγκοπήν τινα δῶμεν τῷ εὐαγγελίῳ τοῦ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Οὐκ οἴδατε ὅτι οἱ τὰ ἱερὰ ἐργαζόμενοι ἐκ τοῦ ἱεροῦ ἐσθίουσιν, οἱ τῷ θυσιαστηρίῳ προσεδρεύοντες τῷ θυσιαστηρίῳ συμμερίζονται; ");
INSERT INTO grctr_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Οὕτω καὶ ὁ Κύριος διέταξε τοῖς τὸ εὐαγγέλιον καταγγέλλουσιν ἐκ τοῦ εὐαγγελίου ζῇν. ");
INSERT INTO grctr_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ἐγὼ δὲ οὐδενὶ ἐχρησάμην τούτων· οὐκ ἔγραψα δὲ ταῦτα ἵνα οὕτω γένηται ἐν ἐμοί· καλὸν γάρ μοι μᾶλλον ἀποθανεῖν, ἢ τὸ καύχημά μου ἵνα τις κενώσῃ. ");
INSERT INTO grctr_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Ἐὰν γὰρ εὐαγγελίζωμαι, οὐκ ἔστι μοι καύχημα· ἀνάγκη γάρ μοι ἐπίκειται· οὐαὶ δέ μοι ἐστίν, ἐὰν μὴ εὐαγγελίζωμαι. ");
INSERT INTO grctr_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Εἰ γὰρ ἑκὼν τοῦτο πράσσω, μισθὸν ἔχω· εἰ δὲ ἄκων, οἰκονομίαν πεπίστευμαι. ");
INSERT INTO grctr_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Τίς οὖν μοί ἐστιν ὁ μισθός; Ἵνα εὐαγγελιζόμενος ἀδάπανον θήσω τὸ εὐαγγέλιον τοῦ Χριστοῦ, εἰς τὸ μὴ καταχρήσασθαι τῇ ἐξουσίᾳ μου ἐν τῷ εὐαγγελίῳ. ");
INSERT INTO grctr_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Ἐλεύθερος γὰρ ὢν ἐκ πάντων, πᾶσιν ἐμαυτὸν ἐδούλωσα, ἵνα τοὺς πλείονας κερδήσω. ");
INSERT INTO grctr_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Καὶ ἐγενόμην τοῖς Ἰουδαίοις ὡς Ἰουδαῖος, ἵνα Ἰουδαίους κερδήσω· τοῖς ὑπὸ νόμον ὡς ὑπὸ νόμον, ἵνα τοὺς ὑπὸ νόμον κερδήσω· ");
INSERT INTO grctr_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","τοῖς ἀνόμοις ὡς ἄνομος, μὴ ὢν ἄνομος Θεῷ ἀλλ᾿ ἔννομος Χριστῷ, ἵνα κερδήσω ἀνόμους. ");
INSERT INTO grctr_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ἐγενόμην τοῖς ἀσθενέσιν ὡς ἀσθενής, ἵνα τοὺς ἀσθενεῖς κερδήσω. Τοῖς πᾶσι γέγονα τὰ πάντα, ἵνα πάντως τινὰς σώσω. ");
INSERT INTO grctr_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Τοῦτο δὲ ποιῶ διὰ τὸ εὐαγγέλιον, ἵνα συγκοινωνὸς αὐτοῦ γένωμαι. ");
INSERT INTO grctr_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Οὐκ οἴδατε ὅτι οἱ ἐν σταδίῳ τρέχοντες πάντες μὲν τρέχουσιν, εἷς δὲ λαμβάνει τὸ βραβεῖον; Οὕτω τρέχετε, ἵνα καταλάβητε. ");
INSERT INTO grctr_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Πᾶς δὲ ὁ ἀγωνιζόμενος πάντα ἐγκρατεύεται· ἐκεῖνοι μὲν οὖν ἵνα φθαρτὸν στέφανον λάβωσιν, ἡμεῖς δὲ ἄφθαρτον. ");
INSERT INTO grctr_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Ἐγὼ τοίνυν οὕτω τρέχω ὡς οὐκ ἀδήλως· οὕτω πυκτεύω, ὡς οὐκ ἀέρα δέρων· ");
INSERT INTO grctr_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ἀλλ᾿ ὑπωπιάζω μου τὸ σῶμα καὶ δουλαγωγῶ, μήπως, ἄλλοις κηρύξας, αὐτὸς ἀδόκιμος γένωμαι. ");
INSERT INTO grctr_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Οὐ θέλω δὲ ὑμᾶς ἀγνοεῖν, ἀδελφοί, ὅτι οἱ πατέρες ἡμῶν πάντες ὑπὸ τὴν νεφέλην ἦσαν, καὶ πάντες διὰ τῆς θαλάσσης διῆλθον, ");
INSERT INTO grctr_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","καὶ πάντες εἰς τὸν Μωσῆν ἐβαπτίσαντο ἐν τῇ νεφέλῃ καὶ ἐν τῇ θαλάσσῃ, ");
INSERT INTO grctr_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","καὶ πάντες τὸ αὐτὸ βρῶμα πνευματικὸν ἔφαγον, ");
INSERT INTO grctr_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","καὶ πάντες τὸ αὐτὸ πόμα πνευματικὸν ἔπιον· ἔπινον γὰρ ἐκ πνευματικῆς ἀκολουθούσης πέτρας· ἡ δὲ πέτρα ἦν ὁ Χριστός. ");
INSERT INTO grctr_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Ἀλλ᾿ οὐκ ἐν τοῖς πλείοσιν αὐτῶν εὐδόκησεν ὁ Θεός· κατεστρώθησαν γὰρ ἐν τῇ ἐρήμῳ. ");
INSERT INTO grctr_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Ταῦτα δὲ τύποι ἡμῶν ἐγενήθησαν, εἰς τὸ μὴ εἶναι ἡμᾶς ἐπιθυμητὰς κακῶν, καθὼς κἀκεῖνοι ἐπεθύμησαν. ");
INSERT INTO grctr_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Μηδὲ εἰδωλολάτραι γίνεσθε, καθώς τινες αὐτῶν· ὡς γέγραπται, Ἐκάθισεν ὁ λαὸς φαγεῖν καὶ πιεῖν, καὶ ἀνέστησαν παίζειν. ");
INSERT INTO grctr_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Μηδὲ πορνεύωμεν, καθώς τινες αὐτῶν ἐπόρνευσαν, καὶ ἔπεσον ἐν μιᾷ ἡμέρᾳ εἴκοσι τρεῖς χιλιάδες. ");
INSERT INTO grctr_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Μηδὲ ἐκπειράζωμεν τὸν Χριστόν, καθὼς καί τινες αὐτῶν ἐπείρασαν, καὶ ὑπὸ τῶν ὄφεων ἀπώλοντο. ");
INSERT INTO grctr_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Μηδὲ γογγύζετε, καθὼς καί τινες αὐτῶν ἐγόγγυσαν, καὶ ἀπώλοντο ὑπὸ τοῦ ὀλοθρευτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ταῦτα δὲ πάντα τύποι συνέβαινον ἐκείνοις· ἐγράφη δὲ πρὸς νουθεσίαν ἡμῶν, εἰς οὓς τὰ τέλη τῶν αἰώνων κατήντησεν. ");
INSERT INTO grctr_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Ὥστε ὁ δοκῶν ἑστάναι, βλεπέτω μὴ πέσῃ. ");
INSERT INTO grctr_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Πειρασμὸς ὑμᾶς οὐκ εἴληφεν εἰ μὴ ἀνθρώπινος· πιστὸς δὲ ὁ Θεός, ὃς οὐκ ἐάσει ὑμᾶς πειρασθῆναι ὑπὲρ ὃ δύνασθε, ἀλλὰ ποιήσει σὺν τῷ πειρασμῷ καὶ τὴν ἔκβασιν, τοῦ δύνασθαι ὑμᾶς ὑπενεγκεῖν. ");
INSERT INTO grctr_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Διόπερ, ἀγαπητοί μου, φεύγετε ἀπὸ τῆς εἰδωλολατρείας. ");
INSERT INTO grctr_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ὡς φρονίμοις λέγω, κρίνατε ὑμεῖς ὅ φημι. ");
INSERT INTO grctr_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Τὸ ποτήριον τῆς εὐλογίας ὃ εὐλογοῦμεν, οὐχὶ κοινωνία τοῦ αἵματος τοῦ Χριστοῦ ἐστί; Τὸν ἄρτον ὃν κλῶμεν, οὐχὶ κοινωνία τοῦ σώματος τοῦ Χριστοῦ ἐστίν; ");
INSERT INTO grctr_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Ὅτι εἷς ἄρτος, ἓν σῶμα, οἱ πολλοί ἐσμεν· οἱ γὰρ πάντες ἐκ τοῦ ἑνὸς ἄρτου μετέχομεν. ");
INSERT INTO grctr_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Βλέπετε τὸν Ἰσραὴλ κατὰ σάρκα· οὐχὶ οἱ ἐσθίοντες τὰς θυσίας κοινωνοὶ τοῦ θυσιαστηρίου εἰσί; ");
INSERT INTO grctr_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Τί οὖν φημι; Ὅτι εἴδωλόν τί ἐστιν; Ἢ ὅτι εἰδωλόθυτόν τί ἐστιν; ");
INSERT INTO grctr_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Ἀλλ᾿ ὅτι ἃ θύει τὰ ἔθνη, δαιμονίοις θύει, καὶ οὐ Θεῷ· οὐ θέλω δὲ ὑμᾶς κοινωνοὺς τῶν δαιμονίων γίνεσθαι. ");
INSERT INTO grctr_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Οὐ δύνασθε ποτήριον Κυρίου πίνειν καὶ ποτήριον δαιμονίων· οὐ δύνασθε τραπέζης Κυρίου μετέχειν καὶ τραπέζης δαιμονίων. ");
INSERT INTO grctr_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Ἢ παραζηλοῦμεν τὸν Κύριον; Μὴ ἰσχυρότεροι αὐτοῦ ἐσμέν; ");
INSERT INTO grctr_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Πάντα μοι ἔξεστιν, ἀλλ᾿ οὐ πάντα συμφέρει. Πάντα μοι ἔξεστιν, ἀλλ᾿ οὐ πάντα οἰκοδομεῖ. ");
INSERT INTO grctr_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Μηδεὶς τὸ ἑαυτοῦ ζητείτω, ἀλλὰ τὸ τοῦ ἑτέρου ἕκαστος. ");
INSERT INTO grctr_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Πᾶν τὸ ἐν μακέλλῳ πωλούμενον ἐσθίετε, μηδὲν ἀνακρίνοντες διὰ τὴν συνείδησιν· ");
INSERT INTO grctr_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Τοῦ γὰρ Κυρίου ἡ γῆ καὶ τὸ πλήρωμα αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Εἰ δέ τις καλεῖ ὑμᾶς τῶν ἀπίστων, καὶ θέλετε πορεύεσθαι, πᾶν τὸ παρατιθέμενον ὑμῖν ἐσθίετε, μηδὲν ἀνακρίνοντες διὰ τὴν συνείδησιν. ");
INSERT INTO grctr_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ἐὰν δέ τις ὑμῖν εἴπῃ, Τοῦτο εἰδωλόθυτόν ἐστι, μὴ ἐσθίετε δι᾿ ἐκεῖνον τὸν μηνύσαντα καὶ τὴν συνείδησιν· Τοῦ γὰρ Κυρίου ἡ γῆ καὶ τὸ πλήρωμα αὐτῆς. ");
INSERT INTO grctr_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Συνείδησιν δὲ λέγω, οὐχὶ τὴν ἑαυτοῦ, ἀλλὰ τὴν τοῦ ἑτέρου· ἵνα τί γὰρ ἡ ἐλευθερία μου κρίνεται ὑπὸ ἄλλης συνειδήσεως; ");
INSERT INTO grctr_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Εἰ δὲ ἐγὼ χάριτι μετέχω, τί βλασφημοῦμαι ὑπὲρ οὗ ἐγὼ εὐχαριστῶ; ");
INSERT INTO grctr_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Εἴτε οὖν ἐσθίετε, εἴτε πίνετε, εἴτε τι ποιεῖτε, πάντα εἰς δόξαν Θεοῦ ποιεῖτε. ");
INSERT INTO grctr_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ἀπρόσκοποι γίνεσθε καὶ Ἰουδαίοις καὶ Ἕλλησι καὶ τῇ ἐκκλησίᾳ τοῦ Θεοῦ· ");
INSERT INTO grctr_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","καθὼς κἀγὼ πάντα πᾶσιν ἀρέσκω, μὴ ζητῶν τὸ ἐμαυτοῦ συμφέρον, ἀλλὰ τὸ τῶν πολλῶν, ἵνα σωθῶσι. ");
INSERT INTO grctr_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Μιμηταί μου γίνεσθε, καθὼς κἀγὼ Χριστοῦ. ");
INSERT INTO grctr_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ἐπαινῶ δὲ ὑμᾶς, ἀδελφοί, ὅτι πάντα μου μέμνησθε, καὶ καθὼς παρέδωκα ὑμῖν τὰς παραδόσεις κατέχετε. ");
INSERT INTO grctr_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Θέλω δὲ ὑμᾶς εἰδέναι, ὅτι παντὸς ἀνδρὸς ἡ κεφαλὴ ὁ Χριστός ἐστι· κεφαλὴ δὲ γυναικός, ὁ ἀνήρ· κεφαλὴ δὲ Χριστοῦ, ὁ Θεός. ");
INSERT INTO grctr_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Πᾶς ἀνὴρ προσευχόμενος ἢ προφητεύων, κατὰ κεφαλῆς ἔχων, καταισχύνει τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grctr_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Πᾶσα δὲ γυνὴ προσευχομένη ἢ προφητεύουσα ἀκατακαλύπτῳ τῇ κεφαλῇ, καταισχύνει τὴν κεφαλὴν ἑαυτῆς· ἓν γάρ ἐστι καὶ τὸ αὐτὸ τῇ ἐξυρημένῃ. ");
INSERT INTO grctr_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Εἰ γὰρ οὐ κατακαλύπτεται γυνή, καὶ κειράσθω· εἰ δὲ αἰσχρὸν γυναικὶ τὸ κείρασθαι ἢ ξυρᾶσθαι, κατακαλυπ