﻿USE sofia;
DROP TABLE IF EXISTS sofia.grcsbl_vpl;
CREATE TABLE grcsbl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES grcsbl_vpl WRITE;
INSERT INTO grcsbl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Βίβλος γενέσεως Ἰησοῦ χριστοῦ υἱοῦ Δαυὶδ υἱοῦ Ἀβραάμ. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ἀβραὰμ ἐγέννησεν τὸν Ἰσαάκ, Ἰσαὰκ δὲ ἐγέννησεν τὸν Ἰακώβ, Ἰακὼβ δὲ ἐγέννησεν τὸν Ἰούδαν καὶ τοὺς ἀδελφοὺς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ἰούδας δὲ ἐγέννησεν τὸν Φαρὲς καὶ τὸν Ζάρα ἐκ τῆς Θαμάρ, Φαρὲς δὲ ἐγέννησεν τὸν Ἑσρώμ, Ἑσρὼμ δὲ ἐγέννησεν τὸν Ἀράμ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ἀρὰμ δὲ ἐγέννησεν τὸν Ἀμιναδάβ, Ἀμιναδὰβ δὲ ἐγέννησεν τὸν Ναασσών, Ναασσὼν δὲ ἐγέννησεν τὸν Σαλμών, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Σαλμὼν δὲ ἐγέννησεν τὸν ⸂Βόες ἐκ τῆς Ῥαχάβ, Βόες δὲ ἐγέννησεν τὸν ⸂Ἰωβὴδ ἐκ τῆς Ῥούθ, Ἰωβὴδ δὲ ἐγέννησεν τὸν Ἰεσσαί, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ἰεσσαὶ δὲἐγέννησεν τὸν Δαυὶδ τὸν βασιλέα. Δαυὶδ ⸀δὲ ἐγέννησεν τὸν Σολομῶνα ἐκ τῆς τοῦ Οὐρίου, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Σολομὼν δὲ ἐγέννησεν τὸν Ῥοβοάμ, Ῥοβοὰμ δὲ ἐγέννησεν τὸν Ἀβιά, Ἀβιὰ δὲ ἐγέννησεν τὸν ⸂Ἀσάφ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ἀσὰφ⸃ δὲ ἐγέννησεν τὸν Ἰωσαφάτ, Ἰωσαφὰτ δὲ ἐγέννησεν τὸν Ἰωράμ, Ἰωρὰμ δὲ ἐγέννησεν τὸν Ὀζίαν, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ὀζίας δὲ ἐγέννησεν τὸν Ἰωαθάμ, Ἰωαθὰμ δὲ ἐγέννησεν τὸν Ἀχάζ, Ἀχὰζ δὲ ἐγέννησεν τὸν Ἑζεκίαν, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ἑζεκίας δὲ ἐγέννησεν τὸν Μανασσῆ, Μανασσῆς δὲ ἐγέννησεν τὸν ⸂Ἀμώς, Ἀμὼς⸃ δὲ ἐγέννησεν τὸν Ἰωσίαν, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ἰωσίας δὲ ἐγέννησεν τὸν Ἰεχονίαν καὶ τοὺς ἀδελφοὺς αὐτοῦ ἐπὶ τῆς μετοικεσίας Βαβυλῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Μετὰ δὲ τὴν μετοικεσίαν Βαβυλῶνος Ἰεχονίας ἐγέννησεν τὸν Σαλαθιήλ, Σαλαθιὴλ δὲ ἐγέννησεν τὸν Ζοροβαβέλ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ζοροβαβὲλ δὲ ἐγέννησεν τὸν Ἀβιούδ, Ἀβιοὺδ δὲ ἐγέννησεν τὸν Ἐλιακίμ, Ἐλιακὶμ δὲ ἐγέννησεν τὸν Ἀζώρ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ἀζὼρ δὲ ἐγέννησεν τὸν Σαδώκ, Σαδὼκ δὲ ἐγέννησεν τὸν Ἀχίμ, Ἀχὶμ δὲ ἐγέννησεν τὸν Ἐλιούδ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ἐλιοὺδ δὲ ἐγέννησεν τὸν Ἐλεάζαρ, Ἐλεάζαρ δὲ ἐγέννησεν τὸν Ματθάν, Ματθὰν δὲ ἐγέννησεν τὸν Ἰακώβ, ");
INSERT INTO grcsbl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ἰακὼβ δὲ ἐγέννησεν τὸν Ἰωσὴφ τὸν ἄνδρα Μαρίας, ἐξ ἧς ἐγεννήθη Ἰησοῦς ὁ λεγόμενος χριστός. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Πᾶσαι οὖν αἱ γενεαὶ ἀπὸ Ἀβραὰμ ἕως Δαυὶδ γενεαὶ δεκατέσσαρες, καὶ ἀπὸ Δαυὶδ ἕως τῆς μετοικεσίας Βαβυλῶνος γενεαὶ δεκατέσσαρες, καὶ ἀπὸ τῆς μετοικεσίας Βαβυλῶνος ἕως τοῦ χριστοῦ γενεαὶ δεκατέσσαρες. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Τοῦ δὲ ⸀Ἰησοῦχριστοῦ ἡ ⸀γένεσιςοὕτως ἦν. ⸀μνηστευθείσηςτῆς μητρὸς αὐτοῦ Μαρίας τῷ Ἰωσήφ, πρὶν ἢ συνελθεῖν αὐτοὺς εὑρέθη ἐν γαστρὶ ἔχουσα ἐκ πνεύματος ἁγίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ἰωσὴφ δὲ ὁ ἀνὴρ αὐτῆς, δίκαιος ὢν καὶ μὴ θέλων αὐτὴν ⸀δειγματίσαι ἐβουλήθη λάθρᾳ ἀπολῦσαι αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ταῦτα δὲ αὐτοῦ ἐνθυμηθέντος ἰδοὺ ἄγγελος κυρίου κατʼ ὄναρ ἐφάνη αὐτῷ λέγων· Ἰωσὴφ υἱὸς Δαυίδ, μὴ φοβηθῇς παραλαβεῖν ⸀Μαρίαντὴν γυναῖκά σου, τὸ γὰρ ἐν αὐτῇ γεννηθὲν ἐκ πνεύματός ἐστιν ἁγίου· ");
INSERT INTO grcsbl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","τέξεται δὲ υἱὸν καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰησοῦν, αὐτὸς γὰρ σώσει τὸν λαὸν αὐτοῦ ἀπὸ τῶν ἁμαρτιῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","τοῦτο δὲ ὅλον γέγονεν ἵνα πληρωθῇ τὸ ῥηθὲν ⸀ὑπὸκυρίου διὰ τοῦ προφήτου λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ἰδοὺ ἡ παρθένος ἐν γαστρὶ ἕξει καὶ τέξεται υἱόν, καὶ καλέσουσιν τὸ ὄνομα αὐτοῦ Ἐμμανουήλ· ὅ ἐστιν μεθερμηνευόμενον Μεθʼ ἡμῶν ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","⸀ἐγερθεὶςδὲ ὁ Ἰωσὴφ ἀπὸ τοῦ ὕπνου ἐποίησεν ὡς προσέταξεν αὐτῷ ὁ ἄγγελος κυρίου καὶ παρέλαβεν τὴν γυναῖκα αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","καὶ οὐκ ἐγίνωσκεν αὐτὴν ἕως οὗ ἔτεκεν ⸀υἱόν καὶ ἐκάλεσεν τὸ ὄνομα αὐτοῦ Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Τοῦ δὲ Ἰησοῦ γεννηθέντος ἐν Βηθλέεμ τῆς Ἰουδαίας ἐν ἡμέραις Ἡρῴδου τοῦ βασιλέως, ἰδοὺ μάγοι ἀπὸ ἀνατολῶν παρεγένοντο εἰς Ἱεροσόλυμα ");
INSERT INTO grcsbl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","λέγοντες· Ποῦ ἐστιν ὁ τεχθεὶς βασιλεὺς τῶν Ἰουδαίων; εἴδομεν γὰρ αὐτοῦ τὸν ἀστέρα ἐν τῇ ἀνατολῇ καὶ ἤλθομεν προσκυνῆσαι αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ἀκούσας δὲ ⸂ὁ βασιλεὺς Ἡρῴδης ἐταράχθη καὶ πᾶσα Ἱεροσόλυμα μετʼ αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","καὶ συναγαγὼν πάντας τοὺς ἀρχιερεῖς καὶ γραμματεῖς τοῦ λαοῦ ἐπυνθάνετο παρʼ αὐτῶν ποῦ ὁ χριστὸς γεννᾶται. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","οἱ δὲ εἶπαν αὐτῷ· Ἐν Βηθλέεμ τῆς Ἰουδαίας· οὕτως γὰρ γέγραπται διὰ τοῦ προφήτου· ");
INSERT INTO grcsbl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Καὶ σύ, Βηθλέεμ γῆ Ἰούδα, οὐδαμῶς ἐλαχίστη εἶ ἐν τοῖς ἡγεμόσιν Ἰούδα· ἐκ σοῦ γὰρ ἐξελεύσεται ἡγούμενος, ὅστις ποιμανεῖ τὸν λαόν μου τὸν Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Τότε Ἡρῴδης λάθρᾳ καλέσας τοὺς μάγους ἠκρίβωσεν παρʼ αὐτῶν τὸν χρόνον τοῦ φαινομένου ἀστέρος, ");
INSERT INTO grcsbl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","καὶ πέμψας αὐτοὺς εἰς Βηθλέεμ εἶπεν· Πορευθέντες ⸂ἐξετάσατε ἀκριβῶς περὶ τοῦ παιδίου· ἐπὰν δὲ εὕρητε, ἀπαγγείλατέ μοι, ὅπως κἀγὼ ἐλθὼν προσκυνήσω αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","οἱ δὲ ἀκούσαντες τοῦ βασιλέως ἐπορεύθησαν, καὶ ἰδοὺ ὁ ἀστὴρ ὃν εἶδον ἐν τῇ ἀνατολῇ προῆγεν αὐτούς, ἕως ἐλθὼν ⸀ἐστάθηἐπάνω οὗ ἦν τὸ παιδίον. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ἰδόντες δὲ τὸν ἀστέρα ἐχάρησαν χαρὰν μεγάλην σφόδρα. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","καὶ ἐλθόντες εἰς τὴν οἰκίαν εἶδον τὸ παιδίον μετὰ Μαρίας τῆς μητρὸς αὐτοῦ, καὶ πεσόντες προσεκύνησαν αὐτῷ, καὶ ἀνοίξαντες τοὺς θησαυροὺς αὐτῶν προσήνεγκαν αὐτῷ δῶρα, χρυσὸν καὶ λίβανον καὶ σμύρναν. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","καὶ χρηματισθέντες κατʼ ὄναρ μὴ ἀνακάμψαι πρὸς Ἡρῴδην διʼ ἄλλης ὁδοῦ ἀνεχώρησαν εἰς τὴν χώραν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ἀναχωρησάντων δὲ αὐτῶν ἰδοὺ ἄγγελος κυρίου ⸂φαίνεται κατʼ ὄναρ τῷ Ἰωσὴφ λέγων· Ἐγερθεὶς παράλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ καὶ φεῦγε εἰς Αἴγυπτον, καὶ ἴσθι ἐκεῖ ἕως ἂν εἴπω σοι· μέλλει γὰρ Ἡρῴδης ζητεῖν τὸ παιδίον τοῦ ἀπολέσαι αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ὁ δὲ ἐγερθεὶς παρέλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ νυκτὸς καὶ ἀνεχώρησεν εἰς Αἴγυπτον, ");
INSERT INTO grcsbl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","καὶ ἦν ἐκεῖ ἕως τῆς τελευτῆς Ἡρῴδου· ἵνα πληρωθῇ τὸ ῥηθὲν ⸀ὑπὸκυρίου διὰ τοῦ προφήτου λέγοντος· Ἐξ Αἰγύπτου ἐκάλεσα τὸν υἱόν μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Τότε Ἡρῴδης ἰδὼν ὅτι ἐνεπαίχθη ὑπὸ τῶν μάγων ἐθυμώθη λίαν, καὶ ἀποστείλας ἀνεῖλεν πάντας τοὺς παῖδας τοὺς ἐν Βηθλέεμ καὶ ἐν πᾶσι τοῖς ὁρίοις αὐτῆς ἀπὸ διετοῦς καὶ κατωτέρω, κατὰ τὸν χρόνον ὃν ἠκρίβωσεν παρὰ τῶν μάγων. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","τότε ἐπληρώθη τὸ ῥηθὲν ⸀διὰἸερεμίου τοῦ προφήτου λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Φωνὴ ἐν Ῥαμὰ ⸀ἠκούσθη κλαυθμὸς καὶ ὀδυρμὸς πολύς· Ῥαχὴλ κλαίουσα τὰ τέκνα αὐτῆς, καὶ οὐκ ἤθελεν παρακληθῆναι ὅτι οὐκ εἰσίν. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Τελευτήσαντος δὲ τοῦ Ἡρῴδου ἰδοὺ ἄγγελος κυρίου ⸂φαίνεται κατʼ ὄναρ τῷ Ἰωσὴφ ἐν Αἰγύπτῳ ");
INSERT INTO grcsbl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","λέγων· Ἐγερθεὶς παράλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ καὶ πορεύου εἰς γῆν Ἰσραήλ, τεθνήκασιν γὰρ οἱ ζητοῦντες τὴν ψυχὴν τοῦ παιδίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ὁ δὲ ἐγερθεὶς παρέλαβε τὸ παιδίον καὶ τὴν μητέρα αὐτοῦ καὶ ⸀εἰσῆλθενεἰς γῆν Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ἀκούσας δὲ ὅτι Ἀρχέλαος ⸀βασιλεύειτῆς Ἰουδαίας ἀντὶ ⸂τοῦ πατρὸς αὐτοῦ Ἡρῴδου ἐφοβήθη ἐκεῖ ἀπελθεῖν· χρηματισθεὶς δὲ κατʼ ὄναρ ἀνεχώρησεν εἰς τὰ μέρη τῆς Γαλιλαίας, ");
INSERT INTO grcsbl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","καὶ ἐλθὼν κατῴκησεν εἰς πόλιν λεγομένην Ναζαρέτ, ὅπως πληρωθῇ τὸ ῥηθὲν διὰ τῶν προφητῶν ὅτι Ναζωραῖος κληθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ἐν δὲ ταῖς ἡμέραις ἐκείναις παραγίνεται Ἰωάννης ὁ βαπτιστὴς κηρύσσων ἐν τῇ ἐρήμῳ τῆς Ἰουδαίας ");
INSERT INTO grcsbl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","⸀καὶλέγων· Μετανοεῖτε, ἤγγικεν γὰρ ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","οὗτος γάρ ἐστιν ὁ ῥηθεὶς ⸀διὰἨσαΐου τοῦ προφήτου λέγοντος· Φωνὴ βοῶντος ἐν τῇ ἐρήμῳ· Ἑτοιμάσατε τὴν ὁδὸν κυρίου, εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","αὐτὸς δὲ ὁ Ἰωάννης εἶχεν τὸ ἔνδυμα αὐτοῦ ἀπὸ τριχῶν καμήλου καὶ ζώνην δερματίνην περὶ τὴν ὀσφὺν αὐτοῦ, ἡ δὲ τροφὴ ⸂ἦν αὐτοῦ ἀκρίδες καὶ μέλι ἄγριον. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","τότε ἐξεπορεύετο πρὸς αὐτὸν Ἱεροσόλυμα καὶ πᾶσα ἡ Ἰουδαία καὶ πᾶσα ἡ περίχωρος τοῦ Ἰορδάνου, ");
INSERT INTO grcsbl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","καὶ ἐβαπτίζοντο ἐν τῷ Ἰορδάνῃ ⸀ποταμῷὑπʼ αὐτοῦ ἐξομολογούμενοι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ἰδὼν δὲ πολλοὺς τῶν Φαρισαίων καὶ Σαδδουκαίων ἐρχομένους ἐπὶ τὸ βάπτισμα ⸀αὐτοῦεἶπεν αὐτοῖς· Γεννήματα ἐχιδνῶν, τίς ὑπέδειξεν ὑμῖν φυγεῖν ἀπὸ τῆς μελλούσης ὀργῆς; ");
INSERT INTO grcsbl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ποιήσατε οὖν καρπὸν ἄξιον τῆς μετανοίας ");
INSERT INTO grcsbl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","καὶ μὴ δόξητε λέγειν ἐν ἑαυτοῖς· Πατέρα ἔχομεν τὸν Ἀβραάμ, λέγω γὰρ ὑμῖν ὅτι δύναται ὁ θεὸς ἐκ τῶν λίθων τούτων ἐγεῖραι τέκνα τῷ Ἀβραάμ. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ἤδη ⸀δὲἡ ἀξίνη πρὸς τὴν ῥίζαν τῶν δένδρων κεῖται· πᾶν οὖν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ἐγὼ μὲν ⸂ὑμᾶς βαπτίζω ἐν ὕδατι εἰς μετάνοιαν· ὁ δὲ ὀπίσω μου ἐρχόμενος ἰσχυρότερός μού ἐστιν, οὗ οὐκ εἰμὶ ἱκανὸς τὰ ὑποδήματα βαστάσαι· αὐτὸς ὑμᾶς βαπτίσει ἐν πνεύματι ἁγίῳ ⸂καὶ πυρί· ");
INSERT INTO grcsbl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","οὗ τὸ πτύον ἐν τῇ χειρὶ αὐτοῦ, καὶ διακαθαριεῖ τὴν ἅλωνα αὐτοῦ καὶ συνάξει τὸν σῖτον αὐτοῦ εἰς τὴν ⸀ἀποθήκην τὸ δὲ ἄχυρον κατακαύσει πυρὶ ἀσβέστῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Τότε παραγίνεται ὁ Ἰησοῦς ἀπὸ τῆς Γαλιλαίας ἐπὶ τὸν Ἰορδάνην πρὸς τὸν Ἰωάννην τοῦ βαπτισθῆναι ὑπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ὁ δὲ ⸀Ἰωάννηςδιεκώλυεν αὐτὸν λέγων· Ἐγὼ χρείαν ἔχω ὑπὸ σοῦ βαπτισθῆναι, καὶ σὺ ἔρχῃ πρός με; ");
INSERT INTO grcsbl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν ⸂πρὸς αὐτόν· Ἄφες ἄρτι, οὕτως γὰρ πρέπον ἐστὶν ἡμῖν πληρῶσαι πᾶσαν δικαιοσύνην. τότε ἀφίησιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","⸂βαπτισθεὶς δὲ ὁ Ἰησοῦς ⸂εὐθὺς ἀνέβη ἀπὸ τοῦ ὕδατος· καὶ ἰδοὺ ⸀ἠνεῴχθησανοἱ οὐρανοί, καὶ εἶδεν ⸀πνεῦμαθεοῦ καταβαῖνον ὡσεὶ ⸀περιστερὰν ἐρχόμενον ἐπʼ αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","καὶ ἰδοὺ φωνὴ ἐκ τῶν οὐρανῶν λέγουσα· Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός, ἐν ᾧ εὐδόκησα. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Τότε ὁ Ἰησοῦς ἀνήχθη εἰς τὴν ἔρημον ὑπὸ τοῦ πνεύματος, πειρασθῆναι ὑπὸ τοῦ διαβόλου. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","καὶ νηστεύσας ἡμέρας τεσσεράκοντα καὶ νύκτας τεσσεράκοντα ὕστερον ἐπείνασεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","καὶ προσελθὼν ⸂ὁ πειράζων εἶπεν αὐτῷ· Εἰ υἱὸς εἶ τοῦ θεοῦ, εἰπὲ ἵνα οἱ λίθοι οὗτοι ἄρτοι γένωνται. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ὁδὲ ἀποκριθεὶς εἶπεν· Γέγραπται· Οὐκ ἐπʼ ἄρτῳ μόνῳ ζήσεται ⸀ὁ ἄνθρωπος, ἀλλʼ ⸀ἐπὶπαντὶ ῥήματι ἐκπορευομένῳ διὰ στόματος θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Τότε παραλαμβάνει αὐτὸν ὁ διάβολος εἰς τὴν ἁγίαν πόλιν, καὶ ⸀ἔστησεναὐτὸν ἐπὶ τὸ πτερύγιον τοῦ ἱεροῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","καὶ λέγει αὐτῷ· Εἰ υἱὸς εἶ τοῦ θεοῦ, βάλε σεαυτὸν κάτω· γέγραπται γὰρ ὅτι Τοῖς ἀγγέλοις αὐτοῦ ἐντελεῖται περὶ σοῦ καὶ ἐπὶ χειρῶν ἀροῦσίν σε, μήποτε προσκόψῃς πρὸς λίθον τὸν πόδα σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ἔφη αὐτῷ ὁ Ἰησοῦς· Πάλιν γέγραπται· Οὐκ ἐκπειράσεις κύριον τὸν θεόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Πάλιν παραλαμβάνει αὐτὸν ὁ διάβολος εἰς ὄρος ὑψηλὸν λίαν, καὶ δείκνυσιν αὐτῷ πάσας τὰς βασιλείας τοῦ κόσμου καὶ τὴν δόξαν αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","καὶ ⸀εἶπεναὐτῷ· Ταῦτά ⸂σοι πάντα δώσω, ἐὰν πεσὼν προσκυνήσῃς μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","τότε λέγει αὐτῷ ὁ Ἰησοῦς· ⸀Ὕπαγε Σατανᾶ· γέγραπται γάρ· Κύριον τὸν θεόν σου προσκυνήσεις καὶ αὐτῷ μόνῳ λατρεύσεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","τότε ἀφίησιν αὐτὸν ὁ διάβολος, καὶ ἰδοὺ ἄγγελοι προσῆλθον καὶ διηκόνουν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ἀκούσας ⸀δὲὅτι Ἰωάννης παρεδόθη ἀνεχώρησεν εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","καὶ καταλιπὼν τὴν Ναζαρὰ ἐλθὼν κατῴκησεν εἰς Καφαρναοὺμ τὴν παραθαλασσίαν ἐν ὁρίοις Ζαβουλὼν καὶ Νεφθαλίμ· ");
INSERT INTO grcsbl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ἵνα πληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Γῆ Ζαβουλὼν καὶ γῆ Νεφθαλίμ, ὁδὸν θαλάσσης, πέραν τοῦ Ἰορδάνου, Γαλιλαία τῶν ἐθνῶν, ");
INSERT INTO grcsbl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ὁ λαὸς ὁ καθήμενος ἐν ⸀σκοτίᾳ⸂φῶς εἶδεν μέγα, καὶ τοῖς καθημένοις ἐν χώρᾳ καὶ σκιᾷ θανάτου φῶς ἀνέτειλεν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ἀπὸ τότε ἤρξατο ὁ Ἰησοῦς κηρύσσειν καὶ λέγειν· Μετανοεῖτε, ἤγγικεν γὰρ ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Περιπατῶν δὲ παρὰ τὴν θάλασσαν τῆς Γαλιλαίας εἶδεν δύο ἀδελφούς, Σίμωνα τὸν λεγόμενον Πέτρον καὶ Ἀνδρέαν τὸν ἀδελφὸν αὐτοῦ, βάλλοντας ἀμφίβληστρον εἰς τὴν θάλασσαν, ἦσαν γὰρ ἁλιεῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","καὶ λέγει αὐτοῖς· Δεῦτε ὀπίσω μου, καὶ ποιήσω ὑμᾶς ἁλιεῖς ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","οἱ δὲ εὐθέως ἀφέντες τὰ δίκτυα ἠκολούθησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Καὶ προβὰς ἐκεῖθεν εἶδεν ἄλλους δύο ἀδελφούς, Ἰάκωβον τὸν τοῦ Ζεβεδαίου καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, ἐν τῷ πλοίῳ μετὰ Ζεβεδαίου τοῦ πατρὸς αὐτῶν καταρτίζοντας τὰ δίκτυα αὐτῶν, καὶ ἐκάλεσεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","οἱ δὲ εὐθέως ἀφέντες τὸ πλοῖον καὶ τὸν πατέρα αὐτῶν ἠκολούθησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Καὶ περιῆγεν ⸂ἐν ὅλῃ τῇ Γαλιλαίᾳ, διδάσκων ἐν ταῖς συναγωγαῖς αὐτῶν καὶ κηρύσσων τὸ εὐαγγέλιον τῆς βασιλείας καὶ θεραπεύων πᾶσαν νόσον καὶ πᾶσαν μαλακίαν ἐν τῷ λαῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","καὶ ἀπῆλθεν ἡ ἀκοὴ αὐτοῦ εἰς ὅλην τὴν Συρίαν· καὶ προσήνεγκαν αὐτῷ πάντας τοὺς κακῶς ἔχοντας ποικίλαις νόσοις καὶ βασάνοις ⸀συνεχομένους δαιμονιζομένους καὶ σεληνιαζομένους καὶ παραλυτικούς, καὶ ἐθεράπευσεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","καὶ ἠκολούθησαν αὐτῷ ὄχλοι πολλοὶ ἀπὸ τῆς Γαλιλαίας καὶ Δεκαπόλεως καὶ Ἱεροσολύμων καὶ Ἰουδαίας καὶ πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ἰδὼν δὲ τοὺς ὄχλους ἀνέβη εἰς τὸ ὄρος· καὶ καθίσαντος αὐτοῦ προσῆλθαν αὐτῷ οἱ μαθηταὶ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","καὶ ἀνοίξας τὸ στόμα αὐτοῦ ἐδίδασκεν αὐτοὺς λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Μακάριοι οἱ πτωχοὶ τῷ πνεύματι, ὅτι αὐτῶν ἐστιν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","μακάριοι οἱ πενθοῦντες, ὅτι αὐτοὶ παρακληθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","μακάριοι οἱ πραεῖς, ὅτι αὐτοὶ κληρονομήσουσι τὴν γῆν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","μακάριοι οἱ πεινῶντες καὶ διψῶντες τὴν δικαιοσύνην, ὅτι αὐτοὶ χορτασθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","μακάριοι οἱ ἐλεήμονες, ὅτι αὐτοὶ ἐλεηθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","μακάριοι οἱ καθαροὶ τῇ καρδίᾳ, ὅτι αὐτοὶ τὸν θεὸν ὄψονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","μακάριοι οἱ εἰρηνοποιοί, ὅτι αὐτοὶ υἱοὶ θεοῦ κληθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","μακάριοι οἱ δεδιωγμένοι ἕνεκεν δικαιοσύνης, ὅτι αὐτῶν ἐστιν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","μακάριοί ἐστε ὅταν ὀνειδίσωσιν ὑμᾶς καὶ διώξωσιν καὶ εἴπωσιν πᾶν ⸀πονηρὸνκαθʼ ὑμῶν ψευδόμενοι ἕνεκεν ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","χαίρετε καὶ ἀγαλλιᾶσθε, ὅτι ὁ μισθὸς ὑμῶν πολὺς ἐν τοῖς οὐρανοῖς· οὕτως γὰρ ἐδίωξαν τοὺς προφήτας τοὺς πρὸ ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ὑμεῖς ἐστε τὸ ἅλας τῆς γῆς· ἐὰν δὲ τὸ ἅλας μωρανθῇ, ἐν τίνι ἁλισθήσεται; εἰς οὐδὲν ἰσχύει ἔτι εἰ μὴ ⸂βληθὲν ἔξω καταπατεῖσθαι ὑπὸ τῶν ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ὑμεῖς ἐστε τὸ φῶς τοῦ κόσμου. οὐ δύναται πόλις κρυβῆναι ἐπάνω ὄρους κειμένη· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","οὐδὲ καίουσιν λύχνον καὶ τιθέασιν αὐτὸν ὑπὸ τὸν μόδιον ἀλλʼ ἐπὶ τὴν λυχνίαν, καὶ λάμπει πᾶσιν τοῖς ἐν τῇ οἰκίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","οὕτως λαμψάτω τὸ φῶς ὑμῶν ἔμπροσθεν τῶν ἀνθρώπων, ὅπως ἴδωσιν ὑμῶν τὰ καλὰ ἔργα καὶ δοξάσωσιν τὸν πατέρα ὑμῶν τὸν ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Μὴ νομίσητε ὅτι ἦλθον καταλῦσαι τὸν νόμον ἢ τοὺς προφήτας· οὐκ ἦλθον καταλῦσαι ἀλλὰ πληρῶσαι· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ἀμὴν γὰρ λέγω ὑμῖν, ἕως ἂν παρέλθῃ ὁ οὐρανὸς καὶ ἡ γῆ, ἰῶτα ἓν ἢ μία κεραία οὐ μὴ παρέλθῃ ἀπὸ τοῦ νόμου, ἕως ἂν πάντα γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ὃς ἐὰν οὖν λύσῃ μίαν τῶν ἐντολῶν τούτων τῶν ἐλαχίστων καὶ διδάξῃ οὕτως τοὺς ἀνθρώπους, ἐλάχιστος κληθήσεται ἐν τῇ βασιλείᾳ τῶν οὐρανῶν· ὃς δʼ ἂν ποιήσῃ καὶ διδάξῃ, οὗτος μέγας κληθήσεται ἐν τῇ βασιλείᾳ τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","λέγω γὰρ ὑμῖν ὅτι ἐὰν μὴ περισσεύσῃ ⸂ὑμῶν ἡ δικαιοσύνη πλεῖον τῶν γραμματέων καὶ Φαρισαίων, οὐ μὴ εἰσέλθητε εἰς τὴν βασιλείαν τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ἠκούσατε ὅτι ἐρρέθη τοῖς ἀρχαίοις· Οὐ φονεύσεις· ὃς δʼ ἂν φονεύσῃ, ἔνοχος ἔσται τῇ κρίσει. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ἐγὼ δὲ λέγω ὑμῖν ὅτι πᾶς ὁ ὀργιζόμενος τῷ ἀδελφῷ ⸀αὐτοῦἔνοχος ἔσται τῇ κρίσει· ὃς δʼ ἂν εἴπῃ τῷ ἀδελφῷ αὐτοῦ· Ῥακά, ἔνοχος ἔσται τῷ συνεδρίῳ· ὃς δʼ ἂν εἴπῃ· Μωρέ, ἔνοχος ἔσται εἰς τὴν γέενναν τοῦ πυρός. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ἐὰν οὖν προσφέρῃς τὸ δῶρόν σου ἐπὶ τὸ θυσιαστήριον κἀκεῖ μνησθῇς ὅτι ὁ ἀδελφός σου ἔχει τι κατὰ σοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ἄφες ἐκεῖ τὸ δῶρόν σου ἔμπροσθεν τοῦ θυσιαστηρίου καὶ ὕπαγε πρῶτον διαλλάγηθι τῷ ἀδελφῷ σου, καὶ τότε ἐλθὼν πρόσφερε τὸ δῶρόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ἴσθι εὐνοῶν τῷ ἀντιδίκῳ σου ταχὺ ἕως ὅτου εἶ ⸂μετʼ αὐτοῦ ἐν τῇ ὁδῷ, μήποτέ σε παραδῷ ὁ ἀντίδικος τῷ κριτῇ, καὶ ὁ ⸀κριτὴςτῷ ὑπηρέτῃ, καὶ εἰς φυλακὴν βληθήσῃ· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ἀμὴν λέγω σοι, οὐ μὴ ἐξέλθῃς ἐκεῖθεν ἕως ἂν ἀποδῷς τὸν ἔσχατον κοδράντην. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ἠκούσατε ὅτι ἐρρέθη· Οὐ μοιχεύσεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ἐγὼ δὲ λέγω ὑμῖν ὅτι πᾶς ὁ βλέπων γυναῖκα πρὸς τὸ ἐπιθυμῆσαι αὐτὴν ἤδη ἐμοίχευσεν αὐτὴν ἐν τῇ καρδίᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","εἰ δὲ ὁ ὀφθαλμός σου ὁ δεξιὸς σκανδαλίζει σε, ἔξελε αὐτὸν καὶ βάλε ἀπὸ σοῦ, συμφέρει γάρ σοι ἵνα ἀπόληται ἓν τῶν μελῶν σου καὶ μὴ ὅλον τὸ σῶμά σου βληθῇ εἰς γέενναν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","καὶ εἰ ἡ δεξιά σου χεὶρ σκανδαλίζει σε, ἔκκοψον αὐτὴν καὶ βάλε ἀπὸ σοῦ, συμφέρει γάρ σοι ἵνα ἀπόληται ἓν τῶν μελῶν σου καὶ μὴ ὅλον τὸ σῶμά σου ⸂εἰς γέενναν ἀπέλθῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ἐρρέθη ⸀δέ Ὃς ἂν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ, δότω αὐτῇ ἀποστάσιον. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ἐγὼ δὲ λέγω ὑμῖν ὅτι ⸂πᾶς ὁ ἀπολύων τὴν γυναῖκα αὐτοῦ παρεκτὸς λόγου πορνείας ποιεῖ αὐτὴν ⸀μοιχευθῆναι καὶ ὃς ἐὰν ἀπολελυμένην γαμήσῃ μοιχᾶται. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Πάλιν ἠκούσατε ὅτι ἐρρέθη τοῖς ἀρχαίοις· Οὐκ ἐπιορκήσεις, ἀποδώσεις δὲ τῷ κυρίῳ τοὺς ὅρκους σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ἐγὼ δὲ λέγω ὑμῖν μὴ ὀμόσαι ὅλως· μήτε ἐν τῷ οὐρανῷ, ὅτι θρόνος ἐστὶν τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","μήτε ἐν τῇ γῇ, ὅτι ὑποπόδιόν ἐστιν τῶν ποδῶν αὐτοῦ· μήτε εἰς Ἱεροσόλυμα, ὅτι πόλις ἐστὶν τοῦ μεγάλου βασιλέως· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","μήτε ἐν τῇ κεφαλῇ σου ὀμόσῃς, ὅτι οὐ δύνασαι μίαν τρίχα λευκὴν ⸂ποιῆσαι ἢ μέλαιναν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ἔστω δὲ ὁ λόγος ὑμῶν ναὶ ναί, οὒ οὔ· τὸ δὲ περισσὸν τούτων ἐκ τοῦ πονηροῦ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ἠκούσατε ὅτι ἐρρέθη· Ὀφθαλμὸν ἀντὶ ὀφθαλμοῦ καὶ ὀδόντα ἀντὶ ὀδόντος. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ἐγὼ δὲ λέγω ὑμῖν μὴ ἀντιστῆναι τῷ πονηρῷ· ἀλλʼ ὅστις σε ⸀ῥαπίζει⸀εἰςτὴν δεξιὰν ⸀σιαγόνα στρέψον αὐτῷ καὶ τὴν ἄλλην· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","καὶ τῷ θέλοντί σοι κριθῆναι καὶ τὸν χιτῶνά σου λαβεῖν, ἄφες αὐτῷ καὶ τὸ ἱμάτιον· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","καὶ ὅστις σε ἀγγαρεύσει μίλιον ἕν, ὕπαγε μετʼ αὐτοῦ δύο. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","τῷ αἰτοῦντί σε ⸀δός καὶ τὸν θέλοντα ἀπὸ σοῦ δανίσασθαι μὴ ἀποστραφῇς. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ἠκούσατε ὅτι ἐρρέθη· Ἀγαπήσεις τὸν πλησίον σου καὶ μισήσεις τὸν ἐχθρόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ἐγὼ δὲ λέγω ὑμῖν, ἀγαπᾶτε τοὺς ἐχθροὺς ⸀ὑμῶνκαὶ προσεύχεσθε ὑπὲρ ⸀τῶνδιωκόντων ὑμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ὅπως γένησθε υἱοὶ τοῦ πατρὸς ὑμῶν τοῦ ⸀ἐνοὐρανοῖς, ὅτι τὸν ἥλιον αὐτοῦ ἀνατέλλει ἐπὶ πονηροὺς καὶ ἀγαθοὺς καὶ βρέχει ἐπὶ δικαίους καὶ ἀδίκους. ");
INSERT INTO grcsbl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ἐὰν γὰρ ἀγαπήσητε τοὺς ἀγαπῶντας ὑμᾶς, τίνα μισθὸν ἔχετε; οὐχὶ καὶ οἱ τελῶναι ⸂τὸ αὐτὸ ποιοῦσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","καὶ ἐὰν ἀσπάσησθε τοὺς ⸀ἀδελφοὺςὑμῶν μόνον, τί περισσὸν ποιεῖτε; οὐχὶ καὶ οἱ ⸀ἐθνικοὶ⸂τὸ αὐτὸ ποιοῦσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ἔσεσθε οὖν ὑμεῖς τέλειοι ⸀ὡςὁ πατὴρ ὑμῶν ὁ ⸀οὐράνιοςτέλειός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Προσέχετε ⸀δὲτὴν ⸀δικαιοσύνηνὑμῶν μὴ ποιεῖν ἔμπροσθεν τῶν ἀνθρώπων πρὸς τὸ θεαθῆναι αὐτοῖς· εἰ δὲ μή γε, μισθὸν οὐκ ἔχετε παρὰ τῷ πατρὶ ὑμῶν τῷ ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ὅταν οὖν ποιῇς ἐλεημοσύνην, μὴ σαλπίσῃς ἔμπροσθέν σου, ὥσπερ οἱ ὑποκριταὶ ποιοῦσιν ἐν ταῖς συναγωγαῖς καὶ ἐν ταῖς ῥύμαις, ὅπως δοξασθῶσιν ὑπὸ τῶν ἀνθρώπων· ἀμὴν λέγω ὑμῖν, ἀπέχουσιν τὸν μισθὸν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","σοῦ δὲ ποιοῦντος ἐλεημοσύνην μὴ γνώτω ἡ ἀριστερά σου τί ποιεῖ ἡ δεξιά σου, ");
INSERT INTO grcsbl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ὅπως ᾖ σου ἡ ἐλεημοσύνη ἐν τῷ κρυπτῷ καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ ⸀κρυπτῷ ἀποδώσει ⸀σοι ");
INSERT INTO grcsbl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Καὶ ὅταν ⸂προσεύχησθε, οὐκ ἔσεσθε ὡς οἱ ὑποκριταί· ὅτι φιλοῦσιν ἐν ταῖς συναγωγαῖς καὶ ἐν ταῖς γωνίαις τῶν πλατειῶν ἑστῶτες προσεύχεσθαι, ⸀ὅπωςφανῶσιν τοῖς ἀνθρώποις· ἀμὴν λέγω ⸀ὑμῖν ἀπέχουσι τὸν μισθὸν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","σὺ δὲ ὅταν προσεύχῃ, εἴσελθε εἰς τὸ ταμεῖόν σου καὶ κλείσας τὴν θύραν σου πρόσευξαι τῷ πατρί σου τῷ ἐν τῷ κρυπτῷ· καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ κρυπτῷ ἀποδώσει ⸀σοι ");
INSERT INTO grcsbl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Προσευχόμενοι δὲ μὴ βατταλογήσητε ὥσπερ οἱ ἐθνικοί, δοκοῦσιν γὰρ ὅτι ἐν τῇ πολυλογίᾳ αὐτῶν εἰσακουσθήσονται· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","μὴ οὖν ὁ οιωθῆτε αὐτοῖς, οἶδεν γὰρ ⸀ὁ πατὴρ ὑμῶν ὧν χρείαν ἔχετε πρὸ τοῦ ὑμᾶς αἰτῆσαι αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Οὕτως οὖν προσεύχεσθε ὑμεῖς· Πάτερ ἡμῶν ὁ ἐν τοῖς οὐρανοῖς· ἁγιασθήτω τὸ ὄνομά σου, ");
INSERT INTO grcsbl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ἐλθέτω ἡ βασιλεία σου, γενηθήτω τὸ θέλημά σου, ὡς ἐν οὐρανῷ καὶ ⸀ἐπὶγῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","τὸν ἄρτον ἡμῶν τὸν ἐπιούσιον δὸς ἡμῖν σήμερον· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","καὶ ἄφες ἡμῖν τὰ ὀφειλήματα ἡμῶν, ὡς καὶ ἡμεῖς ⸀ἀφήκαμεντοῖς ὀφειλέταις ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","καὶ μὴ εἰσενέγκῃς ἡμᾶς εἰς πειρασμόν, ἀλλὰ ῥῦσαι ἡμᾶς ἀπὸ τοῦ ⸀πονηροῦ ");
INSERT INTO grcsbl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ἐὰν γὰρ ἀφῆτε τοῖς ἀνθρώποις τὰ παραπτώματα αὐτῶν, ἀφήσει καὶ ὑμῖν ὁ πατὴρ ὑμῶν ὁ οὐράνιος· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ἐὰν δὲ μὴ ἀφῆτε τοῖς ⸀ἀνθρώποις οὐδὲ ὁ πατὴρ ὑμῶν ἀφήσει τὰ παραπτώματα ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ὅταν δὲ νηστεύητε, μὴ γίνεσθε ⸀ὡςοἱ ὑποκριταὶ σκυθρωποί, ἀφανίζουσιν γὰρ τὰ πρόσωπα αὐτῶν ὅπως φανῶσιν τοῖς ἀνθρώποις νηστεύοντες· ἀμὴν λέγω ⸀ὑμῖν ἀπέχουσιν τὸν μισθὸν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","σὺ δὲ νηστεύων ἄλειψαί σου τὴν κεφαλὴν καὶ τὸ πρόσωπόν σου νίψαι, ");
INSERT INTO grcsbl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ὅπως μὴ φανῇς τοῖς ἀνθρώποις νηστεύων ἀλλὰ τῷ πατρί σου τῷ ἐν τῷ ⸀κρυφαίῳ καὶ ὁ πατήρ σου ὁ βλέπων ἐν τῷ ⸁κρυφαίῳἀποδώσει σοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Μὴ θησαυρίζετε ὑμῖν θησαυροὺς ἐπὶ τῆς γῆς, ὅπου σὴς καὶ βρῶσις ἀφανίζει, καὶ ὅπου κλέπται διορύσσουσιν καὶ κλέπτουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","θησαυρίζετε δὲ ὑμῖν θησαυροὺς ἐν οὐρανῷ, ὅπου οὔτε σὴς οὔτε βρῶσις ἀφανίζει, καὶ ὅπου κλέπται οὐ διορύσσουσιν οὐδὲ κλέπτουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ὅπου γάρ ἐστιν ὁ θησαυρός ⸀σου ἐκεῖ ἔσται καὶ ἡ καρδία ⸁σου ");
INSERT INTO grcsbl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ὁ λύχνος τοῦ σώματός ἐστιν ὁ ὀφθαλμός. ἐὰν οὖν ⸂ᾖ ὁ ὀφθαλμός σου ἁπλοῦς, ὅλον τὸ σῶμά σου φωτεινὸν ἔσται· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ἐὰν δὲ ὁ ὀφθαλμός σου πονηρὸς ᾖ, ὅλον τὸ σῶμά σου σκοτεινὸν ἔσται. εἰ οὖν τὸ φῶς τὸ ἐν σοὶ σκότος ἐστίν, τὸ σκότος πόσον. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Οὐδεὶς δύναται δυσὶ κυρίοις δουλεύειν· ἢ γὰρ τὸν ἕνα μισήσει καὶ τὸν ἕτερον ἀγαπήσει, ἢ ἑνὸς ἀνθέξεται καὶ τοῦ ἑτέρου καταφρονήσει. οὐ δύνασθε θεῷ δουλεύειν καὶ μαμωνᾷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Διὰ τοῦτο λέγω ὑμῖν· μὴ μεριμνᾶτε τῇ ψυχῇ ὑμῶν τί ⸀φάγητε μηδὲ τῷ σώματι ὑμῶν τί ἐνδύσησθε· οὐχὶ ἡ ψυχὴ πλεῖόν ἐστι τῆς τροφῆς καὶ τὸ σῶμα τοῦ ἐνδύματος; ");
INSERT INTO grcsbl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ἐμβλέψατε εἰς τὰ πετεινὰ τοῦ οὐρανοῦ ὅτι οὐ σπείρουσιν οὐδὲ θερίζουσιν οὐδὲ συνάγουσιν εἰς ἀποθήκας, καὶ ὁ πατὴρ ὑμῶν ὁ οὐράνιος τρέφει αὐτά· οὐχ ὑμεῖς μᾶλλον διαφέρετε αὐτῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","τίς δὲ ἐξ ὑμῶν μεριμνῶν δύναται προσθεῖναι ἐπὶ τὴν ἡλικίαν αὐτοῦ πῆχυν ἕνα; ");
INSERT INTO grcsbl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","καὶ περὶ ἐνδύματος τί μεριμνᾶτε; καταμάθετε τὰ κρίνα τοῦ ἀγροῦ πῶς ⸂αὐξάνουσιν· οὐ κοπιῶσιν οὐδὲ νήθουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","λέγω δὲ ὑμῖν ὅτι οὐδὲ Σολομὼν ἐν πάσῃ τῇ δόξῃ αὐτοῦ περιεβάλετο ὡς ἓν τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","εἰ δὲ τὸν χόρτον τοῦ ἀγροῦ σήμερον ὄντα καὶ αὔριον εἰς κλίβανον βαλλόμενον ὁ θεὸς οὕτως ἀμφιέννυσιν, οὐ πολλῷ μᾶλλον ὑμᾶς, ὀλιγόπιστοι; ");
INSERT INTO grcsbl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","μὴ οὖν μεριμνήσητε λέγοντες· Τί φάγωμεν; ἤ· Τί πίωμεν; ἤ· Τί περιβαλώμεθα; ");
INSERT INTO grcsbl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","πάντα γὰρ ταῦτα τὰ ἔθνη ⸀ἐπιζητοῦσιν οἶδεν γὰρ ὁ πατὴρ ὑμῶν ὁ οὐράνιος ὅτι χρῄζετε τούτων ἁπάντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ζητεῖτε δὲ πρῶτον τὴν ⸀βασιλείανκαὶ τὴν δικαιοσύνην αὐτοῦ, καὶ ταῦτα πάντα προστεθήσεται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","μὴ οὖν μεριμνήσητε εἰς τὴν αὔριον, ἡ γὰρ αὔριον μεριμνήσει ⸀αὑτῆς ἀρκετὸν τῇ ἡμέρᾳ ἡ κακία αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Μὴ κρίνετε, ἵνα μὴ κριθῆτε· ");
INSERT INTO grcsbl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ἐν ᾧ γὰρ κρίματι κρίνετε κριθήσεσθε, καὶ ἐν ᾧ μέτρῳ μετρεῖτε μετρηθήσεται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","τί δὲ βλέπεις τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου, τὴν δὲ ἐν τῷ σῷ ὀφθαλμῷ δοκὸν οὐ κατανοεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ἢ πῶς ἐρεῖς τῷ ἀδελφῷ σου· Ἄφες ἐκάλω τὸ κάρφος ⸀ἐκ τοῦ ὀφθαλμοῦ σου, καὶ ἰδοὺ ἡ δοκὸς ἐν τῷ ὀφθαλμῷ σοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ὑποκριτά, ἔκβαλε πρῶτον ⸂ἐκ τοῦ ὀφθαλμοῦ σοῦ τὴν δοκόν, καὶ τότε διαβλέψεις ἐκβαλεῖν τὸ κάρφος ἐκ τοῦ ὀφθαλμοῦ τοῦ ἀδελφοῦ σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Μὴ δῶτε τὸ ἅγιον τοῖς κυσίν, μηδὲ βάλητε τοὺς μαργαρίτας ὑμῶν ἔμπροσθεν τῶν χοίρων, μήποτε ⸀καταπατήσουσιναὐτοὺς ἐν τοῖς ποσὶν αὐτῶν καὶ στραφέντες ῥήξωσιν ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Αἰτεῖτε, καὶ δοθήσεται ὑμῖν· ζητεῖτε, καὶ εὑρήσετε· κρούετε, καὶ ἀνοιγήσεται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","πᾶς γὰρ ὁ αἰτῶν λαμβάνει καὶ ὁ ζητῶν εὑρίσκει καὶ τῷ κρούοντι ⸀ἀνοιγήσεται ");
INSERT INTO grcsbl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ἢ τίς ⸀ἐστινἐξ ὑμῶν ἄνθρωπος, ὃν ⸀αἰτήσειὁ υἱὸς αὐτοῦ ἄρτον— μὴ λίθον ἐπιδώσει αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","⸀ἢκαὶ ⸂ἰχθὺν αἰτήσει— μὴ ὄφιν ἐπιδώσει αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","εἰ οὖν ὑμεῖς πονηροὶ ὄντες οἴδατε δόματα ἀγαθὰ διδόναι τοῖς τέκνοις ὑμῶν, πόσῳ μᾶλλον ὁ πατὴρ ὑμῶν ὁ ἐν τοῖς οὐρανοῖς δώσει ἀγαθὰ τοῖς αἰτοῦσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Πάντα οὖν ὅσα ⸀ἐὰνθέλητε ἵνα ποιῶσιν ὑμῖν οἱ ἄνθρωποι, οὕτως καὶ ὑμεῖς ποιεῖτε αὐτοῖς· οὗτος γάρ ἐστιν ὁ νόμος καὶ οἱ προφῆται. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Εἰσέλθατε διὰ τῆς στενῆς πύλης· ὅτι πλατεῖα ⸂ἡ πύλη καὶ εὐρύχωρος ἡ ὁδὸς ἡ ἀπάγουσα εἰς τὴν ἀπώλειαν, καὶ πολλοί εἰσιν οἱ εἰσερχόμενοι διʼ αὐτῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","⸀ὅτιστενὴ ἡ πύλη καὶ τεθλιμμένη ἡ ὁδὸς ἡ ἀπάγουσα εἰς τὴν ζωήν, καὶ ὀλίγοι εἰσὶν οἱ εὑρίσκοντες αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","⸀Προσέχετεἀπὸ τῶν ψευδοπροφητῶν, οἵτινες ἔρχονται πρὸς ὑμᾶς ἐν ἐνδύμασι προβάτων ἔσωθεν δέ εἰσιν λύκοι ἅρπαγες. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ἀπὸ τῶν καρπῶν αὐτῶν ἐπιγνώσεσθε αὐτούς. μήτι συλλέγουσιν ἀπὸ ἀκανθῶν ⸀σταφυλὰςἢ ἀπὸ τριβόλων σῦκα; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","οὕτως πᾶν δένδρον ἀγαθὸν καρποὺς καλοὺς ποιεῖ, τὸ δὲ σαπρὸν δένδρον καρποὺς πονηροὺς ποιεῖ· ");
INSERT INTO grcsbl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","οὐ δύναται δένδρον ἀγαθὸν καρποὺς πονηροὺς ⸀ποιεῖν οὐδὲ δένδρον σαπρὸν καρποὺς καλοὺς ποιεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","πᾶν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ἄρα γε ἀπὸ τῶν καρπῶν αὐτῶν ἐπιγνώσεσθε αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Οὐ πᾶς ὁ λέγων μοι· Κύριε κύριε εἰσελεύσεται εἰς τὴν βασιλείαν τῶν οὐρανῶν, ἀλλʼ ὁ ποιῶν τὸ θέλημα τοῦ πατρός μου τοῦ ἐν ⸀τοῖςοὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","πολλοὶ ἐροῦσίν μοι ἐν ἐκείνῃ τῇ ἡμέρᾳ· Κύριε κύριε, οὐ τῷ σῷ ὀνόματι ἐπροφητεύσαμεν, καὶ τῷ σῷ ὀνόματι δαιμόνια ἐξεβάλομεν, καὶ τῷ σῷ ὀνόματι δυνάμεις πολλὰς ἐποιήσαμεν; ");
INSERT INTO grcsbl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","καὶ τότε ὁμολογήσω αὐτοῖς ὅτι Οὐδέποτε ἔγνων ὑμᾶς· ἀποχωρεῖτε ἀπʼ ἐμοῦ οἱ ἐργαζόμενοι τὴν ἀνομίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Πᾶς οὖν ὅστις ἀκούει μου τοὺς λόγους τούτους καὶ ποιεῖ αὐτούς, ⸀ὁμοιωθήσεταιἀνδρὶ φρονίμῳ, ὅστις ᾠκοδόμησεν ⸂αὐτοῦ τὴν οἰκίαν ἐπὶ τὴν πέτραν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","καὶ κατέβη ἡ βροχὴ καὶ ἦλθον οἱ ποταμοὶ καὶ ἔπνευσαν οἱ ἄνεμοι καὶ προσέπεσαν τῇ οἰκίᾳ ἐκείνῃ, καὶ οὐκ ἔπεσεν, τεθεμελίωτο γὰρ ἐπὶ τὴν πέτραν. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","καὶ πᾶς ὁ ἀκούων μου τοὺς λόγους τούτους καὶ μὴ ποιῶν αὐτοὺς ὁμοιωθήσεται ἀνδρὶ μωρῷ, ὅστις ᾠκοδόμησεν ⸂αὐτοῦ τὴν οἰκίαν ἐπὶ τὴν ἄμμον. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","καὶ κατέβη ἡ βροχὴ καὶ ἦλθον οἱ ποταμοὶ καὶ ἔπνευσαν οἱ ἄνεμοι καὶ προσέκοψαν τῇ οἰκίᾳ ἐκείνῃ, καὶ ἔπεσεν, καὶ ἦν ἡ πτῶσις αὐτῆς μεγάλη. ");
INSERT INTO grcsbl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Καὶ ἐγένετο ὅτε ⸀ἐτέλεσενὁ Ἰησοῦς τοὺς λόγους τούτους, ἐξεπλήσσοντο οἱ ὄχλοι ἐπὶ τῇ διδαχῇ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ἦν γὰρ διδάσκων αὐτοὺς ὡς ἐξουσίαν ἔχων καὶ οὐχ ὡς οἱ γραμματεῖς ⸀αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","⸂Καταβάντος δὲ αὐτοῦ ἀπὸ τοῦ ὄρους ἠκολούθησαν αὐτῷ ὄχλοι πολλοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","καὶ ἰδοὺ λεπρὸς ⸀προσελθὼνπροσεκύνει αὐτῷ λέγων· Κύριε, ἐὰν θέλῃς δύνασαί με καθαρίσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","καὶ ἐκτείνας τὴν χεῖρα ἥψατο ⸀αὐτοῦλέγων· Θέλω, καθαρίσθητι· καὶ εὐθέως ἐκαθαρίσθη αὐτοῦ ἡ λέπρα. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","καὶ λέγει αὐτῷ ὁ Ἰησοῦς· Ὅρα μηδενὶ εἴπῃς, ἀλλὰ ὕπαγε σεαυτὸν δεῖξον τῷ ἱερεῖ, καὶ προσένεγκον τὸ δῶρον ὃ προσέταξεν Μωϋσῆς εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","⸂Εἰσελθόντος δὲ αὐτοῦ εἰς Καφαρναοὺμ προσῆλθεν αὐτῷ ἑκατόνταρχος παρακαλῶν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","καὶ λέγων· Κύριε, ὁ παῖς μου βέβληται ἐν τῇ οἰκίᾳ παραλυτικός, δεινῶς βασανιζόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","⸀καὶλέγει ⸀αὐτῷ Ἐγὼ ἐλθὼν θεραπεύσω αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","⸂καὶ ἀποκριθεὶς ὁ ἑκατόνταρχος ἔφη· Κύριε, οὐκ εἰμὶ ἱκανὸς ἵνα μου ὑπὸ τὴν στέγην εἰσέλθῃς· ἀλλὰ μόνον εἰπὲ λόγῳ, καὶ ἰαθήσεται ὁ παῖς μου· ");
INSERT INTO grcsbl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","καὶ γὰρ ἐγὼ ἄνθρωπός εἰμι ὑπὸ ⸀ἐξουσίαν ἔχων ὑπʼ ἐμαυτὸν στρατιώτας, καὶ λέγω τούτῳ· Πορεύθητι, καὶ πορεύεται, καὶ ἄλλῳ· Ἔρχου, καὶ ἔρχεται, καὶ τῷ δούλῳ μου· Ποίησον τοῦτο, καὶ ποιεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ἀκούσας δὲ ὁ Ἰησοῦς ἐθαύμασεν καὶ εἶπεν τοῖς ἀκολουθοῦσιν· Ἀμὴν λέγω ὑμῖν, ⸂παρʼ οὐδενὶ τοσαύτην πίστιν ἐν τῷ Ἰσραὴλ εὗρον. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","λέγω δὲ ὑμῖν ὅτι πολλοὶ ἀπὸ ἀνατολῶν καὶ δυσμῶν ἥξουσιν καὶ ἀνακλιθήσονται μετὰ Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ ἐν τῇ βασιλείᾳ τῶν οὐρανῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","οἱ δὲ υἱοὶ τῆς βασιλείας ἐκβληθήσονται εἰς τὸ σκότος τὸ ἐξώτερον· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","καὶ εἶπεν ὁ Ἰησοῦς τῷ ἑκατοντάρχῃ· Ὕπαγε, ⸀ὡςἐπίστευσας γενηθήτω σοι· καὶ ἰάθη ὁ ⸀παῖςἐν τῇ ὥρᾳ ἐκείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Καὶ ἐλθὼν ὁ Ἰησοῦς εἰς τὴν οἰκίαν Πέτρου εἶδεν τὴν πενθερὰν αὐτοῦ βεβλημένην καὶ πυρέσσουσαν· ");
INSERT INTO grcsbl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","καὶ ἥψατο τῆς χειρὸς αὐτῆς, καὶ ἀφῆκεν αὐτὴν ὁ πυρετός, καὶ ἠγέρθη καὶ διηκόνει αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ὀψίας δὲ γενομένης προσήνεγκαν αὐτῷ δαιμονιζομένους πολλούς· καὶ ἐξέβαλεν τὰ πνεύματα λόγῳ, καὶ πάντας τοὺς κακῶς ἔχοντας ἐθεράπευσεν· ");
INSERT INTO grcsbl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ὅπως πληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου λέγοντος· Αὐτὸς τὰς ἀσθενείας ἡμῶν ἔλαβεν καὶ τὰς νόσους ἐβάστασεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ἰδὼν δὲ ὁ Ἰησοῦς ⸂πολλοὺς ὄχλους περὶ αὐτὸν ἐκέλευσεν ἀπελθεῖν εἰς τὸ πέραν. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","καὶ προσελθὼν εἷς γραμματεὺς εἶπεν αὐτῷ· Διδάσκαλε, ἀκολουθήσω σοι ὅπου ἐὰν ἀπέρχῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","καὶ λέγει αὐτῷ ὁ Ἰησοῦς· Αἱ ἀλώπεκες φωλεοὺς ἔχουσιν καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνώσεις, ὁ δὲ υἱὸς τοῦ ἀνθρώπου οὐκ ἔχει ποῦ τὴν κεφαλὴν κλίνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ἕτερος δὲ τῶν ⸀μαθητῶνεἶπεν αὐτῷ· Κύριε, ἐπίτρεψόν μοι πρῶτον ἀπελθεῖν καὶ θάψαι τὸν πατέρα μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ὁ δὲ Ἰησοῦς ⸀λέγειαὐτῷ· Ἀκολούθει μοι, καὶ ἄφες τοὺς νεκροὺς θάψαι τοὺς ἑαυτῶν νεκρούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Καὶ ἐμβάντι αὐτῷ ⸀εἰςπλοῖον ἠκολούθησαν αὐτῷ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","καὶ ἰδοὺ σεισμὸς μέγας ἐγένετο ἐν τῇ θαλάσσῃ, ὥστε τὸ πλοῖον καλύπτεσθαι ὑπὸ τῶν κυμάτων, αὐτὸς δὲ ἐκάθευδεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","καὶ ⸀προσελθόντεςἤγειραν αὐτὸν λέγοντες· Κύριε, ⸀σῶσον ἀπολλύμεθα. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","καὶ λέγει αὐτοῖς· Τί δειλοί ἐστε, ὀλιγόπιστοι; τότε ἐγερθεὶς ἐπετίμησεν τοῖς ἀνέμοις καὶ τῇ θαλάσσῃ, καὶ ἐγένετο γαλήνη μεγάλη. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","οἱ δὲ ἄνθρωποι ἐθαύμασαν λέγοντες· Ποταπός ἐστιν οὗτος ὅτι καὶ οἱ ἄνεμοι καὶ ἡ θάλασσα ⸂αὐτῷ ὑπακούουσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Καὶ ⸂ἐλθόντος αὐτοῦ εἰς τὸ πέραν εἰς τὴν χώραν τῶν ⸀Γαδαρηνῶνὑπήντησαν αὐτῷ δύο δαιμονιζόμενοι ἐκ τῶν μνημείων ἐξερχόμενοι, χαλεποὶ λίαν ὥστε μὴ ἰσχύειν τινὰ παρελθεῖν διὰ τῆς ὁδοῦ ἐκείνης. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","καὶ ἰδοὺ ἔκραξαν λέγοντες· Τί ἡμῖν καὶ ⸀σοί υἱὲ τοῦ θεοῦ; ἦλθες ὧδε πρὸ καιροῦ βασανίσαι ἡμᾶς; ");
INSERT INTO grcsbl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ἦν δὲ μακρὰν ἀπʼ αὐτῶν ἀγέλη χοίρων πολλῶν βοσκομένη. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","οἱ δὲ δαίμονες παρεκάλουν αὐτὸν λέγοντες· Εἰ ἐκβάλλεις ἡμᾶς, ⸂ἀπόστειλον ἡμᾶς εἰς τὴν ἀγέλην τῶν χοίρων. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","καὶ εἶπεν αὐτοῖς· Ὑπάγετε. οἱ δὲ ἐξελθόντες ἀπῆλθον εἰς ⸂τοὺς χοίρους· καὶ ἰδοὺ ὥρμησεν πᾶσα ἡ ⸀ἀγέληκατὰ τοῦ κρημνοῦ εἰς τὴν θάλασσαν, καὶ ἀπέθανον ἐν τοῖς ὕδασιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","οἱ δὲ βόσκοντες ἔφυγον, καὶ ἀπελθόντες εἰς τὴν πόλιν ἀπήγγειλαν πάντα καὶ τὰ τῶν δαιμονιζομένων. ");
INSERT INTO grcsbl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","καὶ ἰδοὺ πᾶσα ἡ πόλις ἐξῆλθεν εἰς ⸀ὑπάντησιντῷ Ἰησοῦ, καὶ ἰδόντες αὐτὸν παρεκάλεσαν ὅπως μεταβῇ ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Καὶ ⸀ἐμβὰς⸀εἰςπλοῖον διεπέρασεν καὶ ἦλθεν εἰς τὴν ἰδίαν πόλιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Καὶ ἰδοὺ προσέφερον αὐτῷ παραλυτικὸν ἐπὶ κλίνης βεβλημένον. καὶ ἰδὼν ὁ Ἰησοῦς τὴν πίστιν αὐτῶν εἶπεν τῷ παραλυτικῷ· Θάρσει, τέκνον· ⸀ἀφίενταί⸂σου αἱ ἁμαρτίαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","καὶ ἰδού τινες τῶν γραμματέων εἶπαν ἐν ἑαυτοῖς· Οὗτος βλασφημεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","καὶ ⸀εἰδὼςὁ Ἰησοῦς τὰς ἐνθυμήσεις αὐτῶν εἶπεν· ⸀Ἱνατίἐνθυμεῖσθε πονηρὰ ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","τί γάρ ἐστιν εὐκοπώτερον, εἰπεῖν· ⸀Ἀφίενταίσου αἱ ἁμαρτίαι, ἢ εἰπεῖν· ⸀Ἔγειρεκαὶ περιπάτει; ");
INSERT INTO grcsbl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ἵνα δὲ εἰδῆτε ὅτι ἐξουσίαν ἔχει ὁ υἱὸς τοῦ ἀνθρώπου ἐπὶ τῆς γῆς ἀφιέναι ἁμαρτίας— τότε λέγει τῷ παραλυτικῷ· ⸀Ἐγερθεὶςἆρόν σου τὴν κλίνην καὶ ὕπαγε εἰς τὸν οἶκόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","καὶ ἐγερθεὶς ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ἰδόντες δὲ οἱ ὄχλοι ⸀ἐφοβήθησανκαὶ ἐδόξασαν τὸν θεὸν τὸν δόντα ἐξουσίαν τοιαύτην τοῖς ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Καὶ παράγων ὁ Ἰησοῦς ἐκεῖθεν εἶδεν ἄνθρωπον καθήμενον ἐπὶ τὸ τελώνιον, Μαθθαῖον λεγόμενον, καὶ λέγει αὐτῷ· Ἀκολούθει μοι· καὶ ἀναστὰς ἠκολούθησεν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Καὶ ἐγένετο αὐτοῦ ἀνακειμένου ἐν τῇ οἰκίᾳ, ⸀καὶἰδοὺ πολλοὶ τελῶναι καὶ ἁμαρτωλοὶ ἐλθόντες συνανέκειντο τῷ Ἰησοῦ καὶ τοῖς μαθηταῖς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","καὶ ἰδόντες οἱ Φαρισαῖοι ⸀ἔλεγοντοῖς μαθηταῖς αὐτοῦ· Διὰ τί μετὰ τῶν τελωνῶν καὶ ἁμαρτωλῶν ἐσθίει ὁ διδάσκαλος ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ὁ ⸀δὲἀκούσας ⸀εἶπεν Οὐ χρείαν ἔχουσιν οἱ ἰσχύοντες ἰατροῦ ἀλλὰ οἱ κακῶς ἔχοντες. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","πορευθέντες δὲ μάθετε τί ἐστιν· Ἔλεος θέλω καὶ οὐ θυσίαν· οὐ γὰρ ἦλθον καλέσαι δικαίους ἀλλὰ ⸀ἁμαρτωλούς ");
INSERT INTO grcsbl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Τότε προσέρχονται αὐτῷ οἱ μαθηταὶ Ἰωάννου λέγοντες· Διὰ τί ἡμεῖς καὶ οἱ Φαρισαῖοι νηστεύομεν ⸀πολλά οἱ δὲ μαθηταί σου οὐ νηστεύουσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς· Μὴ δύνανται οἱ υἱοὶ τοῦ νυμφῶνος πενθεῖν ἐφʼ ὅσον μετʼ αὐτῶν ἐστιν ὁ νυμφίος; ἐλεύσονται δὲ ἡμέραι ὅταν ἀπαρθῇ ἀπʼ αὐτῶν ὁ νυμφίος, καὶ τότε νηστεύσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","οὐδεὶς δὲ ἐπιβάλλει ἐπίβλημα ῥάκους ἀγνάφου ἐπὶ ἱματίῳ παλαιῷ· αἴρει γὰρ τὸ πλήρωμα αὐτοῦ ἀπὸ τοῦ ἱματίου, καὶ χεῖρον σχίσμα γίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","οὐδὲ βάλλουσιν οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μή γε, ῥήγνυνται οἱ ἀσκοί, καὶ ὁ οἶνος ἐκχεῖται καὶ οἱ ἀσκοὶ ⸀ἀπόλλυνται ἀλλὰ βάλλουσιν οἶνον νέον εἰς ἀσκοὺς καινούς, καὶ ἀμφότεροι συντηροῦνται. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ταῦτα αὐτοῦ λαλοῦντος αὐτοῖς ἰδοὺ ἄρχων εἷς ⸀ἐλθὼνπροσεκύνει αὐτῷ λέγων ὅτι Ἡ θυγάτηρ μου ἄρτι ἐτελεύτησεν· ἀλλὰ ἐλθὼν ἐπίθες τὴν χεῖρά σου ἐπʼ αὐτήν, καὶ ζήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","καὶ ἐγερθεὶς ὁ Ἰησοῦς ⸀ἠκολούθειαὐτῷ καὶ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Καὶ ἰδοὺ γυνὴ αἱμορροοῦσα δώδεκα ἔτη προσελθοῦσα ὄπισθεν ἥψατο τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ἔλεγεν γὰρ ἐν ἑαυτῇ· Ἐὰν μόνον ἅψωμαι τοῦ ἱματίου αὐτοῦ σωθήσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ὁ δὲ Ἰησοῦς ⸀στραφεὶςκαὶ ἰδὼν αὐτὴν εἶπεν· Θάρσει, θύγατερ· ἡ πίστις σου σέσωκέν σε. καὶ ἐσώθη ἡ γυνὴ ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","καὶ ἐλθὼν ὁ Ἰησοῦς εἰς τὴν οἰκίαν τοῦ ἄρχοντος καὶ ἰδὼν τοὺς αὐλητὰς καὶ τὸν ὄχλον θορυβούμενον ");
INSERT INTO grcsbl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","⸀ἔλεγεν Ἀναχωρεῖτε, οὐ γὰρ ἀπέθανεν τὸ κοράσιον ἀλλὰ καθεύδει· καὶ κατεγέλων αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ὅτε δὲ ἐξεβλήθη ὁ ὄχλος, εἰσελθὼν ἐκράτησεν τῆς χειρὸς αὐτῆς, καὶ ἠγέρθη τὸ κοράσιον. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","καὶ ἐξῆλθεν ἡ φήμη αὕτη εἰς ὅλην τὴν γῆν ἐκείνην. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Καὶ παράγοντι ἐκεῖθεν τῷ Ἰησοῦ ἠκολούθησαν ⸀αὐτῷδύο τυφλοὶ κράζοντες καὶ λέγοντες· Ἐλέησον ἡμᾶς, ⸀υἱὲΔαυίδ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ἐλθόντι δὲ εἰς τὴν οἰκίαν προσῆλθον αὐτῷ οἱ τυφλοί, καὶ λέγει αὐτοῖς ὁ Ἰησοῦς· Πιστεύετε ὅτι δύναμαι τοῦτο ποιῆσαι; λέγουσιν αὐτῷ· Ναί, κύριε. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","τότε ἥψατο τῶν ὀφθαλμῶν αὐτῶν λέγων· Κατὰ τὴν πίστιν ὑμῶν γενηθήτω ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","καὶ ἠνεῴχθησαν αὐτῶν οἱ ὀφθαλμοί. καὶ ⸀ἐνεβριμήθηαὐτοῖς ὁ Ἰησοῦς λέγων· Ὁρᾶτε μηδεὶς γινωσκέτω· ");
INSERT INTO grcsbl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","οἱ δὲ ἐξελθόντες διεφήμισαν αὐτὸν ἐν ὅλῃ τῇ γῇ ἐκείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Αὐτῶν δὲ ἐξερχομένων ἰδοὺ προσήνεγκαν αὐτῷ ⸀ἄνθρωπονκωφὸν δαιμονιζόμενον· ");
INSERT INTO grcsbl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","καὶ ἐκβληθέντος τοῦ δαιμονίου ἐλάλησεν ὁ κωφός. καὶ ἐθαύμασαν οἱ ὄχλοι λέγοντες· Οὐδέποτε ἐφάνη οὕτως ἐν τῷ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","οἱ δὲ Φαρισαῖοι ἔλεγον· Ἐν τῷ ἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Καὶ περιῆγεν ὁ Ἰησοῦς τὰς πόλεις πάσας καὶ τὰς κώμας, διδάσκων ἐν ταῖς συναγωγαῖς αὐτῶν καὶ κηρύσσων τὸ εὐαγγέλιον τῆς βασιλείας καὶ θεραπεύων πᾶσαν νόσον καὶ πᾶσαν ⸀μαλακίαν ");
INSERT INTO grcsbl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ἰδὼν δὲ τοὺς ὄχλους ἐσπλαγχνίσθη περὶ αὐτῶν ὅτι ἦσαν ἐσκυλμένοι καὶ ἐρριμμένοι ⸀ὡσεὶπρόβατα μὴ ἔχοντα ποιμένα. ");
INSERT INTO grcsbl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","τότε λέγει τοῖς μαθηταῖς αὐτοῦ· Ὁ μὲν θερισμὸς πολύς, οἱ δὲ ἐργάται ὀλίγοι· ");
INSERT INTO grcsbl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","δεήθητε οὖν τοῦ κυρίου τοῦ θερισμοῦ ὅπως ἐκβάλῃ ἐργάτας εἰς τὸν θερισμὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Καὶ προσκαλεσάμενος τοὺς δώδεκα μαθητὰς αὐτοῦ ἔδωκεν αὐτοῖς ἐξουσίαν πνευμάτων ἀκαθάρτων ὥστε ἐκβάλλειν αὐτὰ καὶ θεραπεύειν πᾶσαν νόσον καὶ πᾶσαν μαλακίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","τῶν δὲ δώδεκα ἀποστόλων τὰ ὀνόματά ἐστιν ταῦτα· πρῶτος Σίμων ὁ λεγόμενος Πέτρος καὶ Ἀνδρέας ὁ ἀδελφὸς ⸀αὐτοῦ Ἰάκωβος ὁ τοῦ Ζεβεδαίου καὶ Ἰωάννης ὁ ἀδελφὸς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Φίλιππος καὶ Βαρθολομαῖος, Θωμᾶς καὶ Μαθθαῖος ὁ τελώνης, Ἰάκωβος ὁ τοῦ Ἁλφαίου καὶ ⸀Θαδδαῖος ");
INSERT INTO grcsbl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Σίμων ὁ ⸀Καναναῖοςκαὶ Ἰούδας ⸀ὁἸσκαριώτης ὁ καὶ παραδοὺς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Τούτους τοὺς δώδεκα ἀπέστειλεν ὁ Ἰησοῦς παραγγείλας αὐτοῖς λέγων· Εἰς ὁδὸν ἐθνῶν μὴ ἀπέλθητε καὶ εἰς πόλιν Σαμαριτῶν μὴ εἰσέλθητε· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","πορεύεσθε δὲ μᾶλλον πρὸς τὰ πρόβατα τὰ ἀπολωλότα οἴκου Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","πορευόμενοι δὲ κηρύσσετε λέγοντες ὅτι Ἤγγικεν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ἀσθενοῦντας θεραπεύετε, ⸂νεκροὺς ἐγείρετε, λεπροὺς καθαρίζετε, δαιμόνια ἐκβάλλετε· δωρεὰν ἐλάβετε, δωρεὰν δότε. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","μὴ κτήσησθε χρυσὸν μηδὲ ἄργυρον μηδὲ χαλκὸν εἰς τὰς ζώνας ὑμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","μὴ πήραν εἰς ὁδὸν μηδὲ δύο χιτῶνας μηδὲ ὑποδήματα μηδὲ ⸀ῥάβδον ἄξιος γὰρ ὁ ἐργάτης τῆς τροφῆς ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","εἰς ἣν δʼ ἂν πόλιν ἢ κώμην εἰσέλθητε, ἐξετάσατε τίς ἐν αὐτῇ ἄξιός ἐστιν· κἀκεῖ μείνατε ἕως ἂν ἐξέλθητε. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","εἰσερχόμενοι δὲ εἰς τὴν οἰκίαν ἀσπάσασθε αὐτήν· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","καὶ ἐὰν μὲν ᾖ ἡ οἰκία ἀξία, ἐλθάτω ἡ εἰρήνη ὑμῶν ἐπʼ αὐτήν· ἐὰν δὲ μὴ ᾖ ἀξία, ἡ εἰρήνη ὑμῶν ⸀πρὸςὑμᾶς ἐπιστραφήτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","καὶ ὃς ⸀ἂνμὴ δέξηται ὑμᾶς μηδὲ ἀκούσῃ τοὺς λόγους ὑμῶν, ἐξερχόμενοι ⸀ἔξωτῆς οἰκίας ἢ τῆς πόλεως ἐκείνης ἐκτινάξατε τὸν κονιορτὸν τῶν ποδῶν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ἀμὴν λέγω ὑμῖν, ἀνεκτότερον ἔσται γῇ Σοδόμων καὶ Γομόρρων ἐν ἡμέρᾳ κρίσεως ἢ τῇ πόλει ἐκείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ἰδοὺ ἐγὼ ἀποστέλλω ὑμᾶς ὡς πρόβατα ἐν μέσῳ λύκων· γίνεσθε οὖν φρόνιμοι ὡς οἱ ὄφεις καὶ ἀκέραιοι ὡς αἱ περιστεραί. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","προσέχετε δὲ ἀπὸ τῶν ἀνθρώπων· παραδώσουσιν γὰρ ὑμᾶς εἰς συνέδρια, καὶ ἐν ταῖς συναγωγαῖς αὐτῶν μαστιγώσουσιν ὑμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","καὶ ἐπὶ ἡγεμόνας δὲ καὶ βασιλεῖς ἀχθήσεσθε ἕνεκεν ἐμοῦ εἰς μαρτύριον αὐτοῖς καὶ τοῖς ἔθνεσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ὅταν δὲ ⸀παραδῶσινὑμᾶς, μὴ μεριμνήσητε πῶς ἢ τί λαλήσητε δοθήσεται γὰρ ὑμῖν ἐν ἐκείνῃ τῇ ὥρᾳ τί ⸀λαλήσητε· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","οὐ γὰρ ὑμεῖς ἐστε οἱ λαλοῦντες ἀλλὰ τὸ πνεῦμα τοῦ πατρὸς ὑμῶν τὸ λαλοῦν ἐν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","παραδώσει δὲ ἀδελφὸς ἀδελφὸν εἰς θάνατον καὶ πατὴρ τέκνον, καὶ ἐπαναστήσονται τέκνα ἐπὶ γονεῖς καὶ θανατώσουσιν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου· ὁ δὲ ὑπομείνας εἰς τέλος οὗτος σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ὅταν δὲ διώκωσιν ὑμᾶς ἐν τῇ πόλει ταύτῃ, φεύγετε εἰς τὴν ⸀ἑτέραν ἀμὴν γὰρ λέγω ὑμῖν, οὐ μὴ τελέσητε τὰς πόλεις ⸀τοῦἸσραὴλ ἕως ⸀ἂνἔλθῃ ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Οὐκ ἔστιν μαθητὴς ὑπὲρ τὸν διδάσκαλον οὐδὲ δοῦλος ὑπὲρ τὸν κύριον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ἀρκετὸν τῷ μαθητῇ ἵνα γένηται ὡς ὁ διδάσκαλος αὐτοῦ, καὶ ὁ δοῦλος ὡς ὁ κύριος αὐτοῦ. εἰ τὸν οἰκοδεσπότην Βεελζεβοὺλ ⸀ἐπεκάλεσαν πόσῳ μᾶλλον τοὺς οἰκιακοὺς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Μὴ οὖν φοβηθῆτε αὐτούς· οὐδὲν γάρ ἐστιν κεκαλυμμένον ὃ οὐκ ἀποκαλυφθήσεται, καὶ κρυπτὸν ὃ οὐ γνωσθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ὃ λέγω ὑμῖν ἐν τῇ σκοτίᾳ, εἴπατε ἐν τῷ φωτί· καὶ ὃ εἰς τὸ οὖς ἀκούετε, κηρύξατε ἐπὶ τῶν δωμάτων. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","καὶ μὴ ⸀φοβεῖσθεἀπὸ τῶν ἀποκτεννόντων τὸ σῶμα τὴν δὲ ψυχὴν μὴ δυναμένων ἀποκτεῖναι· ⸁φοβεῖσθεδὲ μᾶλλον τὸν δυνάμενον ⸀καὶψυχὴν ⸁καὶσῶμα ἀπολέσαι ἐν γεέννῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","οὐχὶ δύο στρουθία ἀσσαρίου πωλεῖται; καὶ ἓν ἐξ αὐτῶν οὐ πεσεῖται ἐπὶ τὴν γῆν ἄνευ τοῦ πατρὸς ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ὑμῶν δὲ καὶ αἱ τρίχες τῆς κεφαλῆς πᾶσαι ἠριθμημέναι εἰσίν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","μὴ οὖν ⸀φοβεῖσθε πολλῶν στρουθίων διαφέρετε ὑμεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Πᾶς οὖν ὅστις ὁμολογήσει ἐνἐμοὶ ἔμπροσθεν τῶν ἀνθρώπων, ὁμολογήσω κἀγὼ ἐν αὐτῷ ἔμπροσθεν τοῦ πατρός μου τοῦ ⸀ἐν οὐρανοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ὅστις ⸂δʼ ἂν ἀρνήσηταί με ἔμπροσθεν τῶν ἀνθρώπων, ἀρνήσομαι ⸂κἀγὼ αὐτὸν ἔμπροσθεν τοῦ πατρός μου τοῦ ⸀ἐνοὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Μὴ νομίσητε ὅτι ἦλθον βαλεῖν εἰρήνην ἐπὶ τὴν γῆν· οὐκ ἦλθον βαλεῖν εἰρήνην ἀλλὰ μάχαιραν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ἦλθον γὰρ διχάσαι ἄνθρωπον κατὰ τοῦ πατρὸς αὐτοῦ καὶ θυγατέρα κατὰ τῆς μητρὸς αὐτῆς καὶ νύμφην κατὰ τῆς πενθερᾶς αὐτῆς, ");
INSERT INTO grcsbl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","καὶ ἐχθροὶ τοῦ ἀνθρώπου οἱ οἰκιακοὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ὁ φιλῶν πατέρα ἢ μητέρα ὑπὲρ ἐμὲ οὐκ ἔστιν μου ἄξιος· καὶ ὁ φιλῶν υἱὸν ἢ θυγατέρα ὑπὲρ ἐμὲ οὐκ ἔστιν μου ἄξιος· ");
INSERT INTO grcsbl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","καὶ ὃς οὐ λαμβάνει τὸν σταυρὸν αὐτοῦ καὶ ἀκολουθεῖ ὀπίσω μου, οὐκ ἔστιν μου ἄξιος. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ὁ εὑρὼν τὴν ψυχὴν αὐτοῦ ἀπολέσει αὐτήν, καὶ ὁ ἀπολέσας τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ εὑρήσει αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ὁ δεχόμενος ὑμᾶς ἐμὲ δέχεται, καὶ ὁ ἐμὲ δεχόμενος δέχεται τὸν ἀποστείλαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ὁ δεχόμενος προφήτην εἰς ὄνομα προφήτου μισθὸν προφήτου λήμψεται, καὶ ὁ δεχόμενος δίκαιον εἰς ὄνομα δικαίου μισθὸν δικαίου λήμψεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","καὶ ὃς ⸀ἂνποτίσῃ ἕνα τῶν μικρῶν τούτων ποτήριον ψυχροῦ μόνον εἰς ὄνομα μαθητοῦ, ἀμὴν λέγω ὑμῖν, οὐ μὴ ἀπολέσῃ τὸν μισθὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς διατάσσων τοῖς δώδεκα μαθηταῖς αὐτοῦ, μετέβη ἐκεῖθεν τοῦ διδάσκειν καὶ κηρύσσειν ἐν ταῖς πόλεσιν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ὁ δὲ Ἰωάννης ἀκούσας ἐν τῷ δεσμωτηρίῳ τὰ ἔργα τοῦ χριστοῦ πέμψας ⸀διὰτῶν μαθητῶν αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","εἶπεν αὐτῷ· Σὺ εἶ ὁ ἐρχόμενος ἢ ἕτερον προσδοκῶμεν; ");
INSERT INTO grcsbl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς· Πορευθέντες ἀπαγγείλατε Ἰωάννῃ ἃ ἀκούετε καὶ βλέπετε· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","τυφλοὶ ἀναβλέπουσιν καὶχωλοὶ περιπατοῦσιν, λεπροὶ καθαρίζονται καὶ κωφοὶ ἀκούουσιν, ⸀καὶ νεκροὶ ἐγείρονται καὶ πτωχοὶ εὐαγγελίζονται· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","καὶ μακάριός ἐστιν ὃς ⸀ἐὰνμὴ σκανδαλισθῇ ἐν ἐμοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Τούτων δὲ πορευομένων ἤρξατο ὁ Ἰησοῦς λέγειν τοῖς ὄχλοις περὶ Ἰωάννου· Τί ἐξήλθατε εἰς τὴν ἔρημον θεάσασθαι; κάλαμον ὑπὸ ἀνέμου σαλευόμενον; ");
INSERT INTO grcsbl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ἀλλὰ τί ἐξήλθατε ἰδεῖν; ἄνθρωπον ἐν ⸀μαλακοῖςἠμφιεσμένον; ἰδοὺ οἱ τὰ μαλακὰ φοροῦντες ἐν τοῖς οἴκοις τῶν ⸀βασιλέων⸀εἰσίν ");
INSERT INTO grcsbl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ἀλλὰ τί ἐξήλθατε⸂; προφήτην ἰδεῖν⸃; ναί, λέγω ὑμῖν, καὶ περισσότερον προφήτου. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","⸀οὗτόςἐστιν περὶ οὗ γέγραπται· Ἰδοὺ ἐγὼ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν σου ἔμπροσθέν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ἀμὴν λέγω ὑμῖν, οὐκ ἐγήγερται ἐν γεννητοῖς γυναικῶν μείζων Ἰωάννου τοῦ βαπτιστοῦ· ὁ δὲ μικρότερος ἐν τῇ βασιλείᾳ τῶν οὐρανῶν μείζων αὐτοῦ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ἀπὸ δὲ τῶν ἡμερῶν Ἰωάννου τοῦ βαπτιστοῦ ἕως ἄρτι ἡ βασιλεία τῶν οὐρανῶν βιάζεται, καὶ βιασταὶ ἁρπάζουσιν αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","πάντες γὰρ οἱ προφῆται καὶ ὁ νόμος ἕως Ἰωάννου ἐπροφήτευσαν· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","καὶ εἰ θέλετε δέξασθαι, αὐτός ἐστιν Ἠλίας ὁ μέλλων ἔρχεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ὁ ἔχων ⸀ὦταἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Τίνι δὲ ὁμοιώσω τὴν γενεὰν ταύτην; ὁμοία ἐστὶν παιδίοις ⸂καθημένοις ἐν ταῖς ἀγοραῖς ἃ προσφωνοῦντα τοῖς ἑτέροις ");
INSERT INTO grcsbl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","⸀λέγουσιν Ηὐλήσαμεν ὑμῖν καὶ οὐκ ὠρχήσασθε· ⸀ἐθρηνήσαμεν καὶ οὐκ ἐκόψασθε· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ἦλθεν γὰρ Ἰωάννης μήτε ἐσθίων μήτε πίνων, καὶ λέγουσιν· Δαιμόνιον ἔχει· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ἦλθεν ὁ υἱὸς τοῦ ἀνθρώπου ἐσθίων καὶ πίνων, καὶ λέγουσιν· Ἰδοὺ ἄνθρωπος φάγος καὶ οἰνοπότης, τελωνῶν φίλος καὶ ἁμαρτωλῶν. καὶ ἐδικαιώθη ἡ σοφία ἀπὸ τῶν ⸀ἔργωναὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Τότε ⸀ἤρξατοὀνειδίζειν τὰς πόλεις ἐν αἷς ἐγένοντο αἱ πλεῖσται δυνάμεις αὐτοῦ, ὅτι οὐ μετενόησαν· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Οὐαί σοι, Χοραζίν· οὐαί σοι, Βηθσαϊδά· ὅτι εἰ ἐν Τύρῳ καὶ Σιδῶνι ἐγένοντο αἱ δυνάμεις αἱ γενόμεναι ἐν ὑμῖν, πάλαι ἂν ἐν σάκκῳ καὶ σποδῷ μετενόησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","πλὴν λέγω ὑμῖν, Τύρῳ καὶ Σιδῶνι ἀνεκτότερον ἔσται ἐν ἡμέρᾳ κρίσεως ἢ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","καὶ σύ, Καφαρναούμ, ⸂μὴ ἕως οὐρανοῦ ὑψωθήσῃ; ἕως ᾅδου ⸀καταβήσῃ ὅτι εἰ ἐν Σοδόμοις ⸀ἐγενήθησαναἱ δυνάμεις αἱ γενόμεναι ἐν σοί, ⸀ἔμεινενἂν μέχρι τῆς σήμερον. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","πλὴν λέγω ὑμῖν ὅτι γῇ Σοδόμων ἀνεκτότερον ἔσται ἐν ἡμέρᾳ κρίσεως ἢ σοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ἐν ἐκείνῳ τῷ καιρῷ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν· Ἐξομολογοῦμαί σοι, πάτερ κύριε τοῦ οὐρανοῦ καὶ τῆς γῆς, ὅτι ⸀ἔκρυψαςταῦτα ἀπὸ σοφῶν καὶ συνετῶν, καὶ ἀπεκάλυψας αὐτὰ νηπίοις· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ναί, ὁ πατήρ, ὅτι οὕτως ⸂εὐδοκία ἐγένετο ἔμπροσθέν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Πάντα μοι παρεδόθη ὑπὸ τοῦ πατρός μου, καὶ οὐδεὶς ἐπιγινώσκει τὸν υἱὸν εἰ μὴ ὁ πατήρ, οὐδὲ τὸν πατέρα τις ἐπιγινώσκει εἰ μὴ ὁ υἱὸς καὶ ᾧ ἐὰν βούληται ὁ υἱὸς ἀποκαλύψαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Δεῦτε πρός με πάντες οἱ κοπιῶντες καὶ πεφορτισμένοι, κἀγὼ ἀναπαύσω ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ἄρατε τὸν ζυγόν μου ἐφʼ ὑμᾶς καὶ μάθετε ἀπʼ ἐμοῦ, ὅτι πραΰς εἰμι καὶ ταπεινὸς τῇ καρδίᾳ, καὶ εὑρήσετε ἀνάπαυσιν ταῖς ψυχαῖς ὑμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ὁ γὰρ ζυγός μου χρηστὸς καὶ τὸ φορτίον μου ἐλαφρόν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ἐν ἐκείνῳ τῷ καιρῷ ἐπορεύθη ὁ Ἰησοῦς τοῖς σάββασιν διὰ τῶν σπορίμων· οἱ δὲ μαθηταὶ αὐτοῦ ἐπείνασαν καὶ ἤρξαντο τίλλειν στάχυας καὶ ἐσθίειν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","οἱ δὲ Φαρισαῖοι ἰδόντες εἶπαν αὐτῷ· Ἰδοὺ οἱ μαθηταί σου ποιοῦσιν ὃ οὐκ ἔξεστιν ποιεῖν ἐν σαββάτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ὁ δὲ εἶπεν αὐτοῖς· Οὐκ ἀνέγνωτε τί ἐποίησεν Δαυὶδ ὅτε ⸀ἐπείνασενκαὶ οἱ μετʼ αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","πῶς εἰσῆλθεν εἰς τὸν οἶκον τοῦ θεοῦ καὶ τοὺς ἄρτους τῆς προθέσεως ⸂ἔφαγον, ὃ οὐκ ἐξὸν ἦν αὐτῷ φαγεῖν οὐδὲ τοῖς μετʼ αὐτοῦ, εἰ μὴ τοῖς ἱερεῦσιν μόνοις; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ἢ οὐκ ἀνέγνωτε ἐν τῷ νόμῳ ὅτι τοῖς σάββασιν οἱ ἱερεῖς ἐν τῷ ἱερῷ τὸ σάββατον βεβηλοῦσιν καὶ ἀναίτιοί εἰσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","λέγω δὲ ὑμῖν ὅτι τοῦ ἱεροῦ μεῖζόν ἐστιν ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","εἰ δὲ ἐγνώκειτε τί ἐστιν· Ἔλεος θέλω καὶ οὐ θυσίαν, οὐκ ἂν κατεδικάσατε τοὺς ἀναιτίους. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","κύριος γάρ ἐστιν τοῦ σαββάτου ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Καὶ μεταβὰς ἐκεῖθεν ἦλθεν εἰς τὴν συναγωγὴν αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","καὶ ἰδοὺ ⸀ἄνθρωποςχεῖρα ἔχων ξηράν. καὶ ἐπηρώτησαν αὐτὸν λέγοντες· Εἰ ἔξεστι τοῖς σάββασιν ⸀θεραπεύειν ἵνα κατηγορήσωσιν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ὁ δὲ εἶπεν αὐτοῖς· Τίς ⸀ἔσταιἐξ ὑμῶν ἄνθρωπος ὃς ἕξει πρόβατον ἕν, καὶ ἐὰν ἐμπέσῃ τοῦτο τοῖς σάββασιν εἰς βόθυνον, οὐχὶ κρατήσει αὐτὸ καὶ ἐγερεῖ; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","πόσῳ οὖν διαφέρει ἄνθρωπος προβάτου. ὥστε ἔξεστιν τοῖς σάββασιν καλῶς ποιεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","τότε λέγει τῷ ἀνθρώπῳ· Ἔκτεινόν ⸂σου τὴν χεῖρα· καὶ ἐξέτεινεν, καὶ ἀπεκατεστάθη ὑγιὴς ὡς ἡ ἄλλη. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","⸂ἐξελθόντες δὲ οἱ Φαρισαῖοι συμβούλιον ἔλαβον κατʼ αὐτοῦ ὅπως αὐτὸν ἀπολέσωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ὁ δὲ Ἰησοῦς γνοὺς ἀνεχώρησεν ἐκεῖθεν. καὶ ἠκολούθησαν ⸀αὐτῷπολλοί, καὶ ἐθεράπευσεν αὐτοὺς πάντας, ");
INSERT INTO grcsbl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","καὶ ἐπετίμησεν αὐτοῖς ἵνα μὴ φανερὸν αὐτὸν ποιήσωσιν, ");
INSERT INTO grcsbl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","⸀ἵναπληρωθῇ τὸ ῥηθὲν διὰ Ἠσαΐου τοῦ προφήτου λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ἰδοὺ ὁ παῖς μου ὃν ᾑρέτισα, ὁ ἀγαπητός μου ⸂εἰς ὃν εὐδόκησεν ἡ ψυχή μου· θήσω τὸ πνεῦμά μου ἐπʼ αὐτόν, καὶ κρίσιν τοῖς ἔθνεσιν ἀπαγγελεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","οὐκ ἐρίσει οὐδὲ κραυγάσει, οὐδὲ ἀκούσει τις ἐν ταῖς πλατείαις τὴν φωνὴν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","κάλαμον συντετριμμένον οὐ κατεάξει καὶ λίνον τυφόμενον οὐ σβέσει, ἕως ἂν ἐκβάλῃ εἰς νῖκος τὴν κρίσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","καὶ τῷ ὀνόματι αὐτοῦ ἔθνη ἐλπιοῦσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Τότε ⸂προσηνέχθη αὐτῷ δαιμονιζόμενος τυφλὸς καὶ κωφός· καὶ ἐθεράπευσεν αὐτόν, ὥστε τὸν ⸀κωφὸνλαλεῖν καὶ βλέπειν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","καὶ ἐξίσταντο πάντες οἱ ὄχλοι καὶ ἔλεγον· Μήτι οὗτός ἐστιν ὁ υἱὸς Δαυίδ; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","οἱ δὲ Φαρισαῖοι ἀκούσαντες εἶπον· Οὗτος οὐκ ἐκβάλλει τὰ δαιμόνια εἰ μὴ ἐν τῷ Βεελζεβοὺλ ἄρχοντι τῶν δαιμονίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","εἰδὼς ⸀δὲτὰς ἐνθυμήσεις αὐτῶν εἶπεν αὐτοῖς· Πᾶσα βασιλεία μερισθεῖσα καθʼ ἑαυτῆς ἐρημοῦται, καὶ πᾶσα πόλις ἢ οἰκία μερισθεῖσα καθʼ ἑαυτῆς οὐ σταθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","καὶ εἰ ὁ Σατανᾶς τὸν Σατανᾶν ἐκβάλλει, ἐφʼ ἑαυτὸν ἐμερίσθη· πῶς οὖν σταθήσεται ἡ βασιλεία αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","καὶ εἰ ἐγὼ ἐν Βεελζεβοὺλ ἐκβάλλω τὰ δαιμόνια, οἱ υἱοὶ ὑμῶν ἐν τίνι ἐκβάλλουσιν; διὰ τοῦτο αὐτοὶ ⸂κριταὶ ἔσονται ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","εἰ δὲ ἐν πνεύματι θεοῦ ἐγὼ ἐκβάλλω τὰ δαιμόνια, ἄρα ἔφθασεν ἐφʼ ὑμᾶς ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ἢ πῶς δύναταί τις εἰσελθεῖν εἰς τὴν οἰκίαν τοῦ ἰσχυροῦ καὶ τὰ σκεύη αὐτοῦ ⸀ἁρπάσαι ἐὰν μὴ πρῶτον δήσῃ τὸν ἰσχυρόν; καὶ τότε τὴν οἰκίαν αὐτοῦ ⸀διαρπάσει ");
INSERT INTO grcsbl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ὁ μὴ ὢν μετʼ ἐμοῦ κατʼ ἐμοῦ ἐστιν, καὶ ὁ μὴ συνάγων μετʼ ἐμοῦ σκορπίζει. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","διὰ τοῦτο λέγω ὑμῖν, πᾶσα ἁμαρτία καὶ βλασφημία ἀφεθήσεταιτοῖς ἀνθρώποις, ἡ δὲ τοῦ πνεύματος βλασφημία οὐκ ⸀ἀφεθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","καὶ ὃς ἐὰν εἴπῃ λόγον κατὰ τοῦ υἱοῦ τοῦ ἀνθρώπου, ἀφεθήσεται αὐτῷ· ὃς δʼ ἂν εἴπῃ κατὰ τοῦ πνεύματος τοῦ ἁγίου, οὐκ ἀφεθήσεται αὐτῷ οὔτε ἐν ⸂τούτῳ τῷ αἰῶνι οὔτε ἐν τῷ μέλλοντι. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ἢ ποιήσατε τὸ δένδρον καλὸν καὶ τὸν καρπὸν αὐτοῦ καλόν, ἢ ποιήσατε τὸ δένδρον σαπρὸν καὶ τὸν καρπὸν αὐτοῦ σαπρόν· ἐκ γὰρ τοῦ καρποῦ τὸ δένδρον γινώσκεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","γεννήματα ἐχιδνῶν, πῶς δύνασθε ἀγαθὰ λαλεῖν πονηροὶ ὄντες; ἐκ γὰρ τοῦ περισσεύματος τῆς καρδίας τὸ στόμα λαλεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ὁ ἀγαθὸς ἄνθρωπος ἐκ τοῦ ἀγαθοῦ θησαυροῦ ἐκβάλλει ἀγαθά, καὶ ὁ πονηρὸς ἄνθρωπος ἐκ τοῦ πονηροῦ θησαυροῦ ἐκβάλλει πονηρά. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","λέγω δὲ ὑμῖν ὅτι πᾶν ῥῆμα ἀργὸν ὃ ⸀λαλήσουσινοἱ ἄνθρωποι, ἀποδώσουσιν περὶ αὐτοῦ λόγον ἐν ἡμέρᾳ κρίσεως· ");
INSERT INTO grcsbl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ἐκ γὰρ τῶν λόγων σου δικαιωθήσῃ, καὶ ἐκ τῶν λόγων σου καταδικασθήσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Τότε ἀπεκρίθησαν ⸀αὐτῷτινες τῶν γραμματέων καὶ Φαρισαίων λέγοντες· Διδάσκαλε, θέλομεν ἀπὸ σοῦ σημεῖον ἰδεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς· Γενεὰ πονηρὰ καὶ μοιχαλὶς σημεῖον ἐπιζητεῖ, καὶ σημεῖον οὐ δοθήσεται αὐτῇ εἰ μὴ τὸ σημεῖον Ἰωνᾶ τοῦ προφήτου. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ὥσπερ γὰρ ἦν Ἰωνᾶς ἐν τῇ κοιλίᾳ τοῦ κήτους τρεῖς ἡμέρας καὶ τρεῖς νύκτας, οὕτως ἔσται ὁ υἱὸς τοῦ ἀνθρώπου ἐν τῇ καρδίᾳ τῆς γῆς τρεῖς ἡμέρας καὶ τρεῖς νύκτας. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ἄνδρες Νινευῖται ἀναστήσονται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινοῦσιν αὐτήν· ὅτι μετενόησαν εἰς τὸ κήρυγμα Ἰωνᾶ, καὶ ἰδοὺ πλεῖον Ἰωνᾶ ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","βασίλισσα νότου ἐγερθήσεται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινεῖ αὐτήν· ὅτι ἦλθεν ἐκ τῶν περάτων τῆς γῆς ἀκοῦσαι τὴν σοφίαν Σολομῶνος, καὶ ἰδοὺ πλεῖον Σολομῶνος ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ὅταν δὲ τὸ ἀκάθαρτον πνεῦμα ἐξέλθῃ ἀπὸ τοῦ ἀνθρώπου, διέρχεται διʼ ἀνύδρων τόπων ζητοῦν ἀνάπαυσιν, καὶ οὐχ εὑρίσκει. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","τότε λέγει· ⸂Εἰς τὸν οἶκόν μου ἐπιστρέψω ὅθεν ἐξῆλθον· καὶ ἐλθὸν ⸀εὑρίσκει⸀σχολάζοντασεσαρωμένον καὶ κεκοσμημένον. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","τότε πορεύεται καὶ παραλαμβάνει μεθʼ ἑαυτοῦ ἑπτὰ ἕτερα πνεύματα πονηρότερα ἑαυτοῦ, καὶ εἰσελθόντα κατοικεῖ ἐκεῖ· καὶ γίνεται τὰ ἔσχατα τοῦ ἀνθρώπου ἐκείνου χείρονα τῶν πρώτων. οὕτως ἔσται καὶ τῇ γενεᾷ ταύτῃ τῇ πονηρᾷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ἔτι ⸀δὲαὐτοῦ λαλοῦντος τοῖς ὄχλοις ἰδοὺ ἡ μήτηρ καὶ οἱ ἀδελφοὶ αὐτοῦ εἱστήκεισαν ἔξω ζητοῦντες αὐτῷ λαλῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","⸂εἶπεν δέ τις αὐτῷ· Ἰδοὺ ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου ἔξω ἑστήκασιν, ζητοῦντές σοι λαλῆσαι⸃ ");
INSERT INTO grcsbl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ὁ δὲ ἀποκριθεὶς εἶπεν τῷ ⸀λέγοντιαὐτῷ· Τίς ἐστιν ἡ μήτηρ μου, καὶ τίνες εἰσὶν οἱ ἀδελφοί μου; ");
INSERT INTO grcsbl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","καὶ ἐκτείνας τὴν χεῖρα αὐτοῦ ἐπὶ τοὺς μαθητὰς αὐτοῦ εἶπεν· Ἰδοὺ ἡ μήτηρ μου καὶ οἱ ἀδελφοί μου· ");
INSERT INTO grcsbl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ὅστις γὰρ ἂν ποιήσῃ τὸ θέλημα τοῦ πατρός μου τοῦ ἐν οὐρανοῖς, αὐτός μου ἀδελφὸς καὶ ἀδελφὴ καὶ μήτηρ ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","⸀Ἐντῇ ἡμέρᾳ ἐκείνῃ ἐξελθὼν ὁ Ἰησοῦς ⸀τῆςοἰκίας ἐκάθητο παρὰ τὴν θάλασσαν· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","καὶ συνήχθησαν πρὸς αὐτὸν ὄχλοι πολλοί, ὥστε αὐτὸν ⸀εἰςπλοῖον ἐμβάντα καθῆσθαι, καὶ πᾶς ὁ ὄχλος ἐπὶ τὸν αἰγιαλὸν εἱστήκει. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","καὶ ἐλάλησεν αὐτοῖς πολλὰ ἐν παραβολαῖς λέγων· Ἰδοὺ ἐξῆλθεν ὁ σπείρων τοῦ σπείρειν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","καὶ ἐν τῷ σπείρειν αὐτὸν ἃ μὲν ἔπεσεν παρὰ τὴν ὁδόν, καὶ ⸂ἐλθόντα τὰ πετεινὰ κατέφαγεν αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ἄλλα δὲ ἔπεσεν ἐπὶ τὰ πετρώδη ὅπου οὐκ εἶχεν γῆν πολλήν, καὶ εὐθέως ἐξανέτειλεν διὰ τὸ μὴ ἔχειν βάθος γῆς, ");
INSERT INTO grcsbl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ἡλίου δὲ ἀνατείλαντος ἐκαυματίσθη καὶ διὰ τὸ μὴ ἔχειν ῥίζαν ἐξηράνθη. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ἄλλα δὲ ἔπεσεν ἐπὶ τὰς ἀκάνθας, καὶ ἀνέβησαν αἱ ἄκανθαι καὶ ⸀ἔπνιξαναὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ἄλλα δὲ ἔπεσεν ἐπὶ τὴν γῆν τὴν καλὴν καὶ ἐδίδου καρπόν, ὃ μὲν ἑκατὸν ὃ δὲ ἑξήκοντα ὃ δὲ τριάκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ὁ ἔχων ⸀ὦταἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Καὶ προσελθόντες οἱ μαθηταὶ εἶπαν αὐτῷ· Διὰ τί ἐν παραβολαῖς λαλεῖς αὐτοῖς; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ὁ δὲ ἀποκριθεὶς εἶπεν ⸀αὐτοῖς Ὅτι ὑμῖν δέδοται γνῶναι τὰ μυστήρια τῆς βασιλείας τῶν οὐρανῶν, ἐκείνοις δὲ οὐ δέδοται. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ὅστις γὰρ ἔχει, δοθήσεται αὐτῷ καὶ περισσευθήσεται· ὅστις δὲ οὐκ ἔχει, καὶ ὃ ἔχει ἀρθήσεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","διὰ τοῦτο ἐν παραβολαῖς αὐτοῖς λαλῶ, ὅτι βλέποντες οὐ βλέπουσιν καὶ ἀκούοντες οὐκ ἀκούουσιν οὐδὲ συνίουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","καὶ ἀναπληροῦται αὐτοῖς ἡ προφητεία Ἠσαΐου ἡ λέγουσα· Ἀκοῇ ἀκούσετε καὶ οὐ μὴ συνῆτε, καὶ βλέποντες βλέψετε καὶ οὐ μὴ ἴδητε. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ἐπαχύνθη γὰρ ἡ καρδία τοῦ λαοῦ τούτου, καὶ τοῖς ὠσὶν βαρέως ἤκουσαν, καὶ τοὺς ὀφθαλμοὺς αὐτῶν ἐκάμμυσαν· μήποτε ἴδωσιν τοῖς ὀφθαλμοῖς καὶ τοῖς ὠσὶν ἀκούσωσιν καὶ τῇ καρδίᾳ συνῶσιν καὶ ἐπιστρέψωσιν, καὶ ἰάσομαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ὑμῶν δὲ μακάριοι οἱ ὀφθαλμοὶ ὅτι βλέπουσιν, καὶ τὰ ὦτα ὑμῶν ὅτι ⸀ἀκούουσιν ");
INSERT INTO grcsbl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ἀμὴν γὰρ λέγω ὑμῖν ὅτι πολλοὶ προφῆται καὶ δίκαιοι ἐπεθύμησαν ἰδεῖν ἃ βλέπετε καὶ οὐκ εἶδαν, καὶ ἀκοῦσαι ἃ ἀκούετε καὶ οὐκ ἤκουσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ὑμεῖς οὖν ἀκούσατε τὴν παραβολὴν τοῦ ⸀σπείραντος ");
INSERT INTO grcsbl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","παντὸς ἀκούοντος τὸν λόγον τῆς βασιλείας καὶ μὴ συνιέντος, ἔρχεται ὁ πονηρὸς καὶ ἁρπάζει τὸ ἐσπαρμένον ἐν τῇ καρδίᾳ αὐτοῦ· οὗτός ἐστιν ὁ παρὰ τὴν ὁδὸν σπαρείς. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ὁ δὲ ἐπὶ τὰ πετρώδη σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων καὶ εὐθὺς μετὰ χαρᾶς λαμβάνων αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","οὐκ ἔχει δὲ ῥίζαν ἐν ἑαυτῷ ἀλλὰ πρόσκαιρός ἐστιν, γενομένης δὲ θλίψεως ἢ διωγμοῦ διὰ τὸν λόγον εὐθὺς σκανδαλίζεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ὁ δὲ εἰς τὰς ἀκάνθας σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων, καὶ ἡ μέριμνα τοῦ αἰῶνος ⸀τούτουκαὶ ἡ ἀπάτη τοῦ πλούτου συμπνίγει τὸν λόγον, καὶ ἄκαρπος γίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ὁ δὲ ἐπὶ τὴν ⸂καλὴν γῆν σπαρείς, οὗτός ἐστιν ὁ τὸν λόγον ἀκούων καὶ ⸀συνιείς ὃς δὴ καρποφορεῖ καὶ ποιεῖ ὃ μὲν ἑκατὸν ὃ δὲ ἑξήκοντα ὃ δὲ τριάκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ἄλλην παραβολὴν παρέθηκεν αὐτοῖς λέγων· Ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ ⸀σπείραντικαλὸν σπέρμα ἐν τῷ ἀγρῷ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ἐν δὲ τῷ καθεύδειν τοὺς ἀνθρώπους ἦλθεν αὐτοῦ ὁ ἐχθρὸς καὶ ⸀ἐπέσπειρενζιζάνια ἀνὰ μέσον τοῦ σίτου καὶ ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ὅτε δὲ ἐβλάστησεν ὁ χόρτος καὶ καρπὸν ἐποίησεν, τότε ἐφάνη καὶ τὰ ζιζάνια. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","προσελθόντες δὲ οἱ δοῦλοι τοῦ οἰκοδεσπότου εἶπον αὐτῷ· Κύριε, οὐχὶ καλὸν σπέρμα ⸀ἔσπειραςἐν τῷ σῷ ἀγρῷ; πόθεν οὖν ἔχει ζιζάνια; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ὁ δὲ ἔφη αὐτοῖς· Ἐχθρὸς ἄνθρωπος τοῦτο ἐποίησεν. οἱ δὲ ⸂δοῦλοι αὐτῷ λέγουσιν· Θέλεις οὖν ἀπελθόντες ⸀συλλέξωμεναὐτά; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ὁ δέ ⸀φησιν Οὔ, μήποτε συλλέγοντες τὰ ζιζάνια ἐκριζώσητε ἅμα αὐτοῖς τὸν σῖτον· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ἄφετε συναυξάνεσθαι ἀμφότερα ⸀μέχριτοῦ θερισμοῦ· καὶ ἐν καιρῷ τοῦ θερισμοῦ ἐρῶ τοῖς θερισταῖς· Συλλέξατε πρῶτον τὰ ζιζάνια καὶ δήσατε αὐτὰ εἰς δέσμας πρὸς τὸ κατακαῦσαι αὐτά, τὸν δὲ σῖτον ⸀συναγάγετεεἰς τὴν ἀποθήκην μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ἄλλην παραβολὴν παρέθηκεν αὐτοῖς λέγων· Ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν κόκκῳ σινάπεως, ὃν λαβὼν ἄνθρωπος ἔσπειρεν ἐν τῷ ἀγρῷ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ὃ μικρότερον μέν ἐστιν πάντων τῶν σπερμάτων, ὅταν δὲ αὐξηθῇ μεῖζον τῶν λαχάνων ἐστὶν καὶ γίνεται δένδρον, ὥστε ἐλθεῖν τὰ πετεινὰ τοῦ οὐρανοῦ καὶ κατασκηνοῦν ἐν τοῖς κλάδοις αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ἄλλην παραβολὴν ἐλάλησεν αὐτοῖς· Ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν ζύμῃ, ἣν λαβοῦσα γυνὴ ⸀ἐνέκρυψενεἰς ἀλεύρου σάτα τρία ἕως οὗ ἐζυμώθη ὅλον. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ταῦτα πάντα ἐλάλησεν ὁ Ἰησοῦς ἐν παραβολαῖς τοῖς ὄχλοις, καὶ χωρὶς παραβολῆς ⸀οὐδὲνἐλάλει αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ὅπως πληρωθῇ τὸ ῥηθὲν διὰ τοῦ προφήτου λέγοντος· Ἀνοίξω ἐν παραβολαῖς τὸ στόμα μου, ἐρεύξομαι κεκρυμμένα ἀπὸ ⸀καταβολῆς ");
INSERT INTO grcsbl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Τότε ἀφεὶς τοὺς ὄχλους ἦλθεν εἰς τὴν ⸀οἰκίαν καὶ προσῆλθον αὐτῷ οἱ μαθηταὶ αὐτοῦ λέγοντες· ⸀Διασάφησονἡμῖν τὴν παραβολὴν τῶν ζιζανίων τοῦ ἀγροῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ὁ δὲ ἀποκριθεὶς ⸀εἶπεν Ὁ σπείρων τὸ καλὸν σπέρμα ἐστὶν ὁ υἱὸς τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ὁ δὲ ἀγρός ἐστιν ὁ κόσμος· τὸ δὲ καλὸν σπέρμα, οὗτοί εἰσιν οἱ υἱοὶ τῆς βασιλείας· τὰ δὲ ζιζάνιά εἰσιν οἱ υἱοὶ τοῦ πονηροῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ὁ δὲ ἐχθρὸς ὁ σπείρας αὐτά ἐστιν ὁ διάβολος· ὁ δὲ θερισμὸς συντέλεια ⸀αἰῶνόςἐστιν, οἱ δὲ θερισταὶ ἄγγελοί εἰσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ὥσπερ οὖν συλλέγεται τὰ ζιζάνια καὶ πυρὶ ⸀καίεται οὕτως ἔσται ἐν τῇ συντελείᾳ τοῦ ⸀αἰῶνος ");
INSERT INTO grcsbl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ἀποστελεῖ ὁ υἱὸς τοῦ ἀνθρώπου τοὺς ἀγγέλους αὐτοῦ, καὶ συλλέξουσιν ἐκ τῆς βασιλείας αὐτοῦ πάντα τὰ σκάνδαλα καὶ τοὺς ποιοῦντας τὴν ἀνομίαν, ");
INSERT INTO grcsbl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","καὶ βαλοῦσιν αὐτοὺς εἰς τὴν κάμινον τοῦ πυρός· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Τότε οἱ δίκαιοι ἐκλάμψουσιν ὡς ὁ ἥλιος ἐν τῇ βασιλείᾳ τοῦ πατρὸς αὐτῶν. ὁ ἔχων ⸀ὦταἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⸀Ὁμοίαἐστὶν ἡ βασιλεία τῶν οὐρανῶν θησαυρῷ κεκρυμμένῳ ἐν τῷ ἀγρῷ, ὃν εὑρὼν ἄνθρωπος ἔκρυψεν, καὶ ἀπὸ τῆς χαρᾶς αὐτοῦ ὑπάγει καὶ ⸂πωλεῖ πάντα ὅσα ἔχει καὶ ἀγοράζει τὸν ἀγρὸν ἐκεῖνον. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Πάλιν ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν ⸀ἀνθρώπῳἐμπόρῳ ζητοῦντι καλοὺς μαργαρίτας· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","⸂εὑρὼν δὲ ἕνα πολύτιμον μαργαρίτην ἀπελθὼν πέπρακεν πάντα ὅσα εἶχεν καὶ ἠγόρασεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Πάλιν ὁμοία ἐστὶν ἡ βασιλεία τῶν οὐρανῶν σαγήνῃ βληθείσῃ εἰς τὴν θάλασσαν καὶ ἐκ παντὸς γένους συναγαγούσῃ· ");
INSERT INTO grcsbl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ἣν ὅτε ἐπληρώθη ἀναβιβάσαντες ἐπὶ τὸν αἰγιαλὸν καὶ καθίσαντες συνέλεξαν τὰ καλὰ εἰς ⸀ἄγγη τὰ δὲ σαπρὰ ἔξω ἔβαλον. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","οὕτως ἔσται ἐν τῇ συντελείᾳ τοῦ αἰῶνος· ἐξελεύσονται οἱ ἄγγελοι καὶ ἀφοριοῦσιν τοὺς πονηροὺς ἐκ μέσου τῶν δικαίων ");
INSERT INTO grcsbl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","καὶ βαλοῦσιν αὐτοὺς εἰς τὴν κάμινον τοῦ πυρός· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⸀Συνήκατεταῦτα πάντα; λέγουσιν αὐτῷ· ⸀Ναί ");
INSERT INTO grcsbl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ὁ δὲ εἶπεν αὐτοῖς· Διὰ τοῦτο πᾶς γραμματεὺς μαθητευθεὶς ⸂τῇ βασιλείᾳ τῶν οὐρανῶν ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδεσπότῃ ὅστις ἐκβάλλει ἐκ τοῦ θησαυροῦ αὐτοῦ καινὰ καὶ παλαιά. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς τὰς παραβολὰς ταύτας, μετῆρεν ἐκεῖθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","καὶ ἐλθὼν εἰς τὴν πατρίδα αὐτοῦ ἐδίδασκεν αὐτοὺς ἐν τῇ συναγωγῇ αὐτῶν, ὥστε ἐκπλήσσεσθαι αὐτοὺς καὶ λέγειν· Πόθεν τούτῳ ἡ σοφία αὕτη καὶ αἱ δυνάμεις; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","οὐχοὗτός ἐστιν ὁ τοῦ τέκτονος υἱός; ⸀οὐχ ἡ μήτηρ αὐτοῦ λέγεται Μαριὰμ καὶ οἱ ἀδελφοὶ αὐτοῦ Ἰάκωβος καὶ ⸀Ἰωσὴφκαὶ Σίμων καὶ Ἰούδας; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","καὶ αἱ ἀδελφαὶ αὐτοῦ οὐχὶ πᾶσαι πρὸς ἡμᾶς εἰσιν; πόθεν οὖν τούτῳ ταῦτα πάντα; ");
INSERT INTO grcsbl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","καὶ ἐσκανδαλίζοντο ἐν αὐτῷ. ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Οὐκ ἔστιν προφήτης ἄτιμος εἰ μὴ ἐν τῇ ⸀πατρίδικαὶ ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","καὶ οὐκ ἐποίησεν ἐκεῖ δυνάμεις πολλὰς διὰ τὴν ἀπιστίαν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ἐν ἐκείνῳ τῷ καιρῷ ἤκουσεν Ἡρῴδης ὁ τετραάρχης τὴν ἀκοὴν Ἰησοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","καὶ εἶπεν τοῖς παισὶν αὐτοῦ· Οὗτός ἐστιν Ἰωάννης ὁ βαπτιστής· αὐτὸς ἠγέρθη ἀπὸ τῶν νεκρῶν, καὶ διὰ τοῦτο αἱ δυνάμεις ἐνεργοῦσιν ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ὁ γὰρ Ἡρῴδης κρατήσας τὸν Ἰωάννην ἔδησεν ⸀αὐτὸνκαὶ ⸂ἐν φυλακῇ ἀπέθετο διὰ Ἡρῳδιάδα τὴν γυναῖκα Φιλίππου τοῦ ἀδελφοῦ αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ἔλεγεν γὰρ ⸂αὐτῷ ὁ Ἰωάννης· Οὐκ ἔξεστίν σοι ἔχειν αὐτήν· ");
INSERT INTO grcsbl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","καὶ θέλων αὐτὸν ἀποκτεῖναι ἐφοβήθη τὸν ὄχλον, ὅτι ὡς προφήτην αὐτὸν εἶχον. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","⸂γενεσίοις δὲ γενομένοις τοῦ Ἡρῴδου ὠρχήσατο ἡ θυγάτηρ τῆς Ἡρῳδιάδος ἐν τῷ μέσῳ καὶ ἤρεσεν τῷ Ἡρῴδῃ, ");
INSERT INTO grcsbl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ὅθεν μετὰ ὅρκου ὡμολόγησεν αὐτῇ δοῦναι ὃ ⸀ἐὰναἰτήσηται. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ἡ δὲ προβιβασθεῖσα ὑπὸ τῆς μητρὸς αὐτῆς· Δός μοι, φησίν, ὧδε ἐπὶ πίνακι τὴν κεφαλὴν Ἰωάννου τοῦ βαπτιστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","καὶ ⸂λυπηθεὶς ὁ βασιλεὺς διὰ τοὺς ὅρκους καὶ τοὺς συνανακειμένους ἐκέλευσεν δοθῆναι, ");
INSERT INTO grcsbl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","καὶ πέμψας ἀπεκεφάλισεν ⸀τὸνἸωάννην ἐν τῇ φυλακῇ· ");
INSERT INTO grcsbl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","καὶ ἠνέχθη ἡ κεφαλὴ αὐτοῦ ἐπὶ πίνακι καὶ ἐδόθη τῷ κορασίῳ, καὶ ἤνεγκεν τῇ μητρὶ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","καὶ προσελθόντες οἱ μαθηταὶ αὐτοῦ ἦραν τὸ ⸀πτῶμακαὶ ἔθαψαν ⸀αὐτόν καὶ ἐλθόντες ἀπήγγειλαν τῷ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","⸂Ἀκούσας δὲ ὁ Ἰησοῦς ἀνεχώρησεν ἐκεῖθεν ἐν πλοίῳ εἰς ἔρημον τόπον κατʼ ἰδίαν· καὶ ἀκούσαντες οἱ ὄχλοι ἠκολούθησαν αὐτῷ πεζῇ ἀπὸ τῶν πόλεων. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","καὶ ⸀ἐξελθὼνεἶδεν πολὺν ὄχλον, καὶ ἐσπλαγχνίσθη ἐπʼ αὐτοῖς καὶ ἐθεράπευσεν τοὺς ἀρρώστους αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ὀψίας δὲ γενομένης προσῆλθον αὐτῷ οἱ ⸀μαθηταὶλέγοντες· Ἔρημός ἐστιν ὁ τόπος καὶ ἡ ὥρα ἤδη παρῆλθεν· ἀπόλυσον τοὺς ὄχλους, ἵνα ἀπελθόντες εἰς τὰς κώμας ἀγοράσωσιν ἑαυτοῖς βρώματα. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Οὐ χρείαν ἔχουσιν ἀπελθεῖν· δότε αὐτοῖς ὑμεῖς φαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","οἱ δὲ λέγουσιν αὐτῷ· Οὐκ ἔχομεν ὧδε εἰ μὴ πέντε ἄρτους καὶ δύο ἰχθύας. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ὁ δὲ εἶπεν· Φέρετέ μοι ⸂ὧδε αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","καὶ κελεύσας τοὺς ὄχλους ἀνακλιθῆναι ἐπὶ ⸂τοῦ χόρτου, λαβὼν τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας, ἀναβλέψας εἰς τὸν οὐρανὸν εὐλόγησεν καὶ κλάσας ἔδωκεν τοῖς μαθηταῖς τοὺς ἄρτους οἱ δὲ μαθηταὶ τοῖς ὄχλοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","καὶ ἔφαγον πάντες καὶ ἐχορτάσθησαν, καὶ ἦραν τὸ περισσεῦον τῶν κλασμάτων δώδεκα κοφίνους πλήρεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","οἱ δὲ ἐσθίοντες ἦσαν ἄνδρες ὡσεὶ πεντακισχίλιοι χωρὶς γυναικῶν καὶ παιδίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Καὶ εὐθέως ⸀ἠνάγκασεντοὺς μαθητὰς ἐμβῆναι ⸀εἰςπλοῖον καὶ προάγειν αὐτὸν εἰς τὸ πέραν, ἕως οὗ ἀπολύσῃ τοὺς ὄχλους. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","καὶ ἀπολύσας τοὺς ὄχλους ἀνέβη εἰς τὸ ὄρος κατʼ ἰδίαν προσεύξασθαι. ὀψίας δὲ γενομένης μόνος ἦν ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","τὸ δὲ πλοῖον ἤδη ⸂σταδίους πολλοὺς ἀπὸ τῆς γῆς ἀπεῖχεν, βασανιζόμενον ὑπὸ τῶν κυμάτων, ἦν γὰρ ἐναντίος ὁ ἄνεμος. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","τετάρτῃ δὲ φυλακῇ τῆς νυκτὸς ⸀ἦλθενπρὸς ⸀αὐτοὺςπεριπατῶν ἐπὶ ⸂τὴν θάλασσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","⸂οἱ δὲ μαθηταὶ ἰδόντες αὐτὸν ἐπὶ ⸂τῆς θαλάσσης περιπατοῦντα ἐταράχθησαν λέγοντες ὅτι Φάντασμά ἐστιν, καὶ ἀπὸ τοῦ φόβου ἔκραξαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","⸀εὐθὺςδὲ ἐλάλησεν ⸂αὐτοῖς ὁ Ἰησοῦς λέγων· Θαρσεῖτε, ἐγώ εἰμι· μὴ φοβεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ἀποκριθεὶς δὲ ⸂αὐτῷ ὁ Πέτρος εἶπεν· Κύριε, εἰ σὺ εἶ, κέλευσόν με ⸂ἐλθεῖν πρὸς σὲ ἐπὶ τὰ ὕδατα· ");
INSERT INTO grcsbl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ὁ δὲ εἶπεν· Ἐλθέ. καὶ καταβὰς ἀπὸ τοῦ ⸀πλοίουΠέτρος περιεπάτησεν ἐπὶ τὰ ὕδατα ⸂καὶ ἦλθεν πρὸς τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","βλέπων δὲ τὸν ἄνεμον ⸀ἰσχυρὸνἐφοβήθη, καὶ ἀρξάμενος καταποντίζεσθαι ἔκραξεν λέγων· Κύριε, σῶσόν με. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","εὐθέως δὲ ὁ Ἰησοῦς ἐκτείνας τὴν χεῖρα ἐπελάβετο αὐτοῦ καὶ λέγει αὐτῷ· Ὀλιγόπιστε, εἰς τί ἐδίστασας; ");
INSERT INTO grcsbl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","καὶ ⸀ἀναβάντωναὐτῶν εἰς τὸ πλοῖον ἐκόπασεν ὁ ἄνεμος. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","οἱ δὲ ἐν τῷ ⸀πλοίῳπροσεκύνησαν αὐτῷ λέγοντες· Ἀληθῶς θεοῦ υἱὸς εἶ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Καὶ διαπεράσαντες ἦλθον ⸂ἐπὶ τὴν γῆν εἰς Γεννησαρέτ. ");
INSERT INTO grcsbl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","καὶ ἐπιγνόντες αὐτὸν οἱ ἄνδρες τοῦ τόπου ἐκείνου ἀπέστειλαν εἰς ὅλην τὴν περίχωρον ἐκείνην, καὶ προσήνεγκαν αὐτῷ πάντας τοὺς κακῶς ἔχοντας, ");
INSERT INTO grcsbl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","καὶ παρεκάλουν αὐτὸν ἵνα μόνον ἅψωνται τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ· καὶ ὅσοι ἥψαντο διεσώθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Τότε προσέρχονται τῷ ⸀Ἰησοῦἀπὸ Ἱεροσολύμων ⸂Φαρισαῖοι καὶ γραμματεῖς λέγοντες ");
INSERT INTO grcsbl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Διὰ τί οἱ μαθηταί σου παραβαίνουσιν τὴν παράδοσιν τῶν πρεσβυτέρων; οὐ γὰρ νίπτονται τὰς χεῖρας ⸀αὐτῶνὅταν ἄρτον ἐσθίωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς· Διὰ τί καὶ ὑμεῖς παραβαίνετε τὴν ἐντολὴν τοῦ θεοῦ διὰ τὴν παράδοσιν ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ὁ γὰρ θεὸς ⸀εἶπεν Τίμα τὸν πατέρα καὶ τὴν μητέρα, καί· Ὁ κακολογῶν πατέρα ἢ μητέρα θανάτῳ τελευτάτω· ");
INSERT INTO grcsbl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ὑμεῖς δὲ λέγετε· Ὃς ἂν εἴπῃ τῷ πατρὶ ἢ τῇ μητρί· Δῶρον ὃ ἐὰν ἐξ ἐμοῦ ὠφεληθῇς, ");
INSERT INTO grcsbl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","⸀οὐμὴ ⸀τιμήσειτὸν πατέρα ⸀αὐτοῦ καὶ ἠκυρώσατε ⸂τὸν λόγον τοῦ θεοῦ διὰ τὴν παράδοσιν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ὑποκριταί, καλῶς ἐπροφήτευσεν περὶ ὑμῶν Ἠσαΐας λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","⸂Ὁ λαὸς οὗτος τοῖς χείλεσίν με τιμᾷ, ἡ δὲ καρδία αὐτῶν πόρρω ἀπέχει ἀπʼ ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","μάτην δὲ σέβονταί με, διδάσκοντες διδασκαλίας ἐντάλματα ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Καὶ προσκαλεσάμενος τὸν ὄχλον εἶπεν αὐτοῖς· Ἀκούετε καὶ συνίετε· ");
INSERT INTO grcsbl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","οὐ τὸ εἰσερχόμενον εἰς τὸ στόμα κοινοῖ τὸν ἄνθρωπον, ἀλλὰ τὸ ἐκπορευόμενον ἐκ τοῦ στόματος τοῦτο κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Τότε προσελθόντες οἱ ⸀μαθηταὶ⸀λέγουσιναὐτῷ· Οἶδας ὅτι οἱ Φαρισαῖοι ἀκούσαντες τὸν λόγον ἐσκανδαλίσθησαν; ");
INSERT INTO grcsbl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ὁ δὲ ἀποκριθεὶς εἶπεν· Πᾶσα φυτεία ἣν οὐκ ἐφύτευσεν ὁ πατήρ μου ὁ οὐράνιος ἐκριζωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ἄφετε αὐτούς· ⸂τυφλοί εἰσιν ὁδηγοὶ τυφλῶν· τυφλὸς δὲ τυφλὸν ἐὰν ὁδηγῇ, ἀμφότεροι εἰς βόθυνον πεσοῦνται. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ἀποκριθεὶς δὲ ὁ Πέτρος εἶπεν αὐτῷ· Φράσον ἡμῖν τὴν παραβολὴν ⸀ταύτην ");
INSERT INTO grcsbl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ὁ ⸀δὲεἶπεν· Ἀκμὴν καὶ ὑμεῖς ἀσύνετοί ἐστε; ");
INSERT INTO grcsbl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","⸀οὐνοεῖτε ὅτι πᾶν τὸ εἰσπορευόμενον εἰς τὸ στόμα εἰς τὴν κοιλίαν χωρεῖ καὶ εἰς ἀφεδρῶνα ἐκβάλλεται; ");
INSERT INTO grcsbl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","τὰ δὲ ἐκπορευόμενα ἐκ τοῦ στόματος ἐκ τῆς καρδίας ἐξέρχεται, κἀκεῖνα κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ἐκ γὰρ τῆς καρδίας ἐξέρχονται διαλογισμοὶ πονηροί, φόνοι, μοιχεῖαι, πορνεῖαι, κλοπαί, ψευδομαρτυρίαι, βλασφημίαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ταῦτά ἐστιν τὰ κοινοῦντα τὸν ἄνθρωπον, τὸ δὲ ἀνίπτοις χερσὶν φαγεῖν οὐ κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Καὶ ἐξελθὼν ἐκεῖθεν ὁ Ἰησοῦς ἀνεχώρησεν εἰς τὰ μέρη Τύρου καὶ Σιδῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","καὶ ἰδοὺ γυνὴ Χαναναία ἀπὸ τῶν ὁρίων ἐκείνων ἐξελθοῦσα ⸀ἔκραζενλέγουσα· Ἐλέησόν με, κύριε ⸀υἱὸςΔαυίδ· ἡ θυγάτηρ μου κακῶς δαιμονίζεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ὁ δὲ οὐκ ἀπεκρίθη αὐτῇ λόγον. καὶ προσελθόντες οἱ μαθηταὶ αὐτοῦ ⸀ἠρώτουναὐτὸν λέγοντες· Ἀπόλυσον αὐτήν, ὅτι κράζει ὄπισθεν ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ὁ δὲ ἀποκριθεὶς εἶπεν· Οὐκ ἀπεστάλην εἰ μὴ εἰς τὰ πρόβατα τὰ ἀπολωλότα οἴκου Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ἡ δὲ ἐλθοῦσα ⸀προσεκύνειαὐτῷ λέγουσα· Κύριε, βοήθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ὁ δὲ ἀποκριθεὶς εἶπεν· Οὐκ ἔστιν καλὸν λαβεῖν τὸν ἄρτον τῶν τέκνων καὶ βαλεῖν τοῖς κυναρίοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ἡ δὲ εἶπεν· Ναί, κύριε, καὶ γὰρ τὰ κυνάρια ἐσθίει ἀπὸ τῶν ψιχίων τῶν πιπτόντων ἀπὸ τῆς τραπέζης τῶν κυρίων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","τότε ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτῇ· Ὦ γύναι, μεγάλη σου ἡ πίστις· γενηθήτω σοι ὡς θέλεις. καὶ ἰάθη ἡ θυγάτηρ αὐτῆς ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Καὶ μεταβὰς ἐκεῖθεν ὁ Ἰησοῦς ἦλθεν παρὰ τὴν θάλασσαν τῆς Γαλιλαίας, καὶ ἀναβὰς εἰς τὸ ὄρος ἐκάθητο ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","καὶ προσῆλθον αὐτῷ ὄχλοι πολλοὶ ἔχοντες μεθʼ ἑαυτῶν ⸂κωφούς, τυφλούς, χωλούς, κυλλούς, καὶ ἑτέρους πολλούς, καὶ ἔρριψαν αὐτοὺς παρὰ τοὺς πόδας ⸀αὐτοῦ καὶ ἐθεράπευσεν αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ὥστε ⸂τὸν ὄχλον θαυμάσαι βλέποντας κωφοὺς λαλοῦντας ⸂κυλλοὺς ὑγιεῖς ⸀καὶχωλοὺς περιπατοῦντας καὶ τυφλοὺς βλέποντας· καὶ ἐδόξασαν τὸν θεὸν Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ὁ δὲ Ἰησοῦς προσκαλεσάμενος τοὺς μαθητὰς αὐτοῦ εἶπεν· Σπλαγχνίζομαι ἐπὶ τὸν ὄχλον, ὅτι ἤδη ἡμέραι τρεῖς προσμένουσίν μοι καὶ οὐκ ἔχουσιν τί φάγωσιν· καὶ ἀπολῦσαι αὐτοὺς νήστεις οὐ θέλω, μήποτε ἐκλυθῶσιν ἐν τῇ ὁδῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","καὶ λέγουσιν αὐτῷ οἱ ⸀μαθηταί Πόθεν ἡμῖν ἐν ἐρημίᾳ ἄρτοι τοσοῦτοι ὥστε χορτάσαι ὄχλον τοσοῦτον; ");
INSERT INTO grcsbl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","καὶ λέγει αὐτοῖς ὁ Ἰησοῦς· Πόσους ἄρτους ἔχετε; οἱ δὲ εἶπαν· Ἑπτά, καὶ ὀλίγα ἰχθύδια. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","καὶ ⸀παραγγείλας⸂τῷ ὄχλῳ ἀναπεσεῖν ἐπὶ τὴν γῆν ");
INSERT INTO grcsbl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","⸀ἔλαβεντοὺς ἑπτὰ ἄρτους καὶτοὺς ἰχθύας ⸀καὶ εὐχαριστήσας ἔκλασεν καὶ ⸀ἐδίδουτοῖς ⸀μαθηταῖςοἱ δὲ μαθηταὶ ⸂τοῖς ὄχλοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","καὶ ἔφαγον πάντες καὶ ἐχορτάσθησαν, καὶ ⸂τὸ περισσεῦον τῶν κλασμάτων ἦραν ἑπτὰ σπυρίδας πλήρεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","οἱ δὲ ἐσθίοντες ἦσαν τετρακισχίλιοι ἄνδρες χωρὶς γυναικῶν καὶ παιδίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","καὶ ἀπολύσας τοὺς ὄχλους ἐνέβη εἰς τὸ πλοῖον, καὶ ἦλθεν εἰς τὰ ὅρια ⸀Μαγαδάν ");
INSERT INTO grcsbl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Καὶ προσελθόντες οἱ Φαρισαῖοι καὶ Σαδδουκαῖοι πειράζοντες ἐπηρώτησαν αὐτὸν σημεῖον ἐκ τοῦ οὐρανοῦ ἐπιδεῖξαι αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς· ⸂Ὀψίας γενομένης λέγετε· Εὐδία, πυρράζει γὰρ ὁ οὐρανός· ");
INSERT INTO grcsbl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","καὶ πρωΐ· Σήμερον χειμών, πυρράζει γὰρ στυγνάζων ὁ οὐρανός. ⸀τὸ μὲν πρόσωπον τοῦ οὐρανοῦ γινώσκετε διακρίνειν, τὰ δὲ σημεῖα τῶν καιρῶν οὐ δύνασθε.⸃ ");
INSERT INTO grcsbl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Γενεὰ πονηρὰ καὶ μοιχαλὶς σημεῖον ἐπιζητεῖ, καὶ σημεῖον οὐ δοθήσεται αὐτῇ εἰ μὴ τὸ σημεῖον ⸀Ἰωνᾶ καὶ καταλιπὼν αὐτοὺς ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Καὶ ἐλθόντες οἱ ⸀μαθηταὶεἰς τὸ πέραν ἐπελάθοντο ἄρτους λαβεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Ὁρᾶτε καὶ προσέχετε ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ Σαδδουκαίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","οἱ δὲ διελογίζοντο ἐν ἑαυτοῖς λέγοντες ὅτι Ἄρτους οὐκ ἐλάβομεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","γνοὺς δὲ ὁ Ἰησοῦς ⸀εἶπεν Τί διαλογίζεσθε ἐν ἑαυτοῖς, ὀλιγόπιστοι, ὅτι ἄρτους οὐκ ⸀ἐλάβετε ");
INSERT INTO grcsbl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","οὔπω νοεῖτε, οὐδὲ μνημονεύετε τοὺς πέντε ἄρτους τῶν πεντακισχιλίων καὶ πόσους κοφίνους ἐλάβετε; ");
INSERT INTO grcsbl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","οὐδὲ τοὺς ἑπτὰ ἄρτους τῶν τετρακισχιλίων καὶ πόσας σπυρίδας ἐλάβετε; ");
INSERT INTO grcsbl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","πῶς οὐ νοεῖτε ὅτι οὐ περὶ ⸀ἄρτωνεἶπον ὑμῖν; ⸂προσέχετε δὲ ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ Σαδδουκαίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","τότε συνῆκαν ὅτι οὐκ εἶπεν προσέχειν ἀπὸ τῆς ζύμης ⸂τῶν ἄρτων ἀλλὰ ἀπὸ τῆς διδαχῆς τῶν Φαρισαίων καὶ Σαδδουκαίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ἐλθὼν δὲ ὁ Ἰησοῦς εἰς τὰ μέρη Καισαρείας τῆς Φιλίππου ἠρώτα τοὺς μαθητὰς αὐτοῦ λέγων· ⸀Τίναλέγουσιν οἱ ἄνθρωποι εἶναι τὸν υἱὸν τοῦ ἀνθρώπου; ");
INSERT INTO grcsbl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","οἱ δὲ εἶπαν· Οἱ μὲν Ἰωάννην τὸν βαπτιστήν, ἄλλοι δὲ Ἠλίαν, ἕτεροι δὲ Ἰερεμίαν ἢ ἕνα τῶν προφητῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","λέγει αὐτοῖς· Ὑμεῖς δὲ τίνα με λέγετε εἶναι; ");
INSERT INTO grcsbl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ἀποκριθεὶς δὲ Σίμων Πέτρος εἶπεν· Σὺ εἶ ὁ χριστὸς ὁ υἱὸς τοῦ θεοῦ τοῦ ζῶντος. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","⸂ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτῷ· Μακάριος εἶ, Σίμων Βαριωνᾶ, ὅτι σὰρξ καὶ αἷμα οὐκ ἀπεκάλυψέν σοι ἀλλʼ ὁ πατήρ μου ὁ ἐν τοῖς οὐρανοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","κἀγὼ δέ σοι λέγω ὅτι σὺ εἶ Πέτρος, καὶ ἐπὶ ταύτῃ τῇ πέτρᾳ οἰκοδομήσω μου τὴν ἐκκλησίαν, καὶ πύλαι ᾅδου οὐ κατισχύσουσιν αὐτῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","⸀δώσωσοι τὰς ⸀κλεῖδαςτῆς βασιλείας τῶν οὐρανῶν, καὶ ὃ ⸀ἐὰνδήσῃς ἐπὶ τῆς γῆς ἔσται δεδεμένον ἐν τοῖς οὐρανοῖς, καὶ ὃ ⸁ἐὰνλύσῃς ἐπὶ τῆς γῆς ἔσται λελυμένον ἐν τοῖς οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","τότε ⸀διεστείλατοτοῖς ⸀μαθηταῖςἵνα μηδενὶ εἴπωσιν ὅτι αὐτός ⸀ἐστινὁ χριστός. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ἀπὸ τότε ἤρξατο ⸂ὁ Ἰησοῦς δεικνύειν τοῖς μαθηταῖς αὐτοῦ ὅτι δεῖ αὐτὸν ⸂εἰς Ἱεροσόλυμα ἀπελθεῖν καὶ πολλὰ παθεῖν ἀπὸ τῶν πρεσβυτέρων καὶ ἀρχιερέων καὶ γραμματέων καὶ ἀποκτανθῆναι καὶ τῇ τρίτῃ ἡμέρᾳ ἐγερθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","καὶ προσλαβόμενος αὐτὸν ὁ Πέτρος ἤρξατο ἐπιτιμᾶν αὐτῷ λέγων· Ἵλεώς σοι, κύριε· οὐ μὴ ἔσται σοι τοῦτο. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ὁ δὲ στραφεὶς εἶπεν τῷ Πέτρῳ· Ὕπαγε ὀπίσω μου, Σατανᾶ· σκάνδαλον ⸂εἶ ἐμοῦ, ὅτι οὐ φρονεῖς τὰ τοῦ θεοῦ ἀλλὰ τὰ τῶν ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Τότε ὁ Ἰησοῦς εἶπεν τοῖς μαθηταῖς αὐτοῦ· Εἴ τις θέλει ὀπίσω μου ἐλθεῖν, ἀπαρνησάσθω ἑαυτὸν καὶ ἀράτω τὸν σταυρὸν αὐτοῦ καὶ ἀκολουθείτω μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ὃς γὰρ ⸀ἐὰνθέλῃ τὴν ψυχὴν αὐτοῦ σῶσαι ἀπολέσει αὐτήν· ὃς δʼ ἂν ἀπολέσῃ τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ εὑρήσει αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","τί γὰρ ⸀ὠφεληθήσεταιἄνθρωπος ἐὰν τὸν κόσμον ὅλον κερδήσῃ τὴν δὲ ψυχὴν αὐτοῦ ζημιωθῇ; ἢ τί δώσει ἄνθρωπος ἀντάλλαγμα τῆς ψυχῆς αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","μέλλει γὰρ ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεσθαι ἐν τῇ δόξῃ τοῦ πατρὸς αὐτοῦ μετὰ τῶν ἀγγέλων αὐτοῦ, καὶ τότε ἀποδώσει ἑκάστῳ κατὰ τὴν πρᾶξιν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ἀμὴν λέγω ὑμῖν ⸀ὅτιεἰσίν τινες ⸂τῶν ὧδε ἑστώτων οἵτινες οὐ μὴ γεύσωνται θανάτου ἕως ἂν ἴδωσιν τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν τῇ βασιλείᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Καὶ μεθʼ ἡμέρας ἓξ παραλαμβάνει ὁ Ἰησοῦς τὸν Πέτρον καὶ Ἰάκωβον καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, καὶ ἀναφέρει αὐτοὺς εἰς ὄρος ὑψηλὸν κατʼ ἰδίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","καὶ μετεμορφώθη ἔμπροσθεν αὐτῶν, καὶ ἔλαμψεν τὸ πρόσωπον αὐτοῦ ὡς ὁ ἥλιος, τὰ δὲ ἱμάτια αὐτοῦ ⸀ἐγένετολευκὰ ὡς τὸ φῶς. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","καὶ ἰδοὺ ⸀ὤφθηαὐτοῖς Μωϋσῆς καὶ Ἠλίας ⸂συλλαλοῦντες μετʼ αὐτοῦ⸃. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ἀποκριθεὶς δὲ ὁ Πέτρος εἶπεν τῷ Ἰησοῦ· Κύριε, καλόν ἐστιν ἡμᾶς ὧδε εἶναι· εἰ θέλεις, ⸀ποιήσωὧδε τρεῖς σκηνάς, σοὶ μίαν καὶ Μωϋσεῖ μίαν καὶ ⸂Ἠλίᾳ μίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ἔτι αὐτοῦ λαλοῦντος ἰδοὺ νεφέλη φωτεινὴ ἐπεσκίασεν αὐτούς, καὶ ἰδοὺ φωνὴ ἐκ τῆς νεφέλης λέγουσα· Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός, ἐν ᾧ εὐδόκησα· ⸂ἀκούετε αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","καὶ ἀκούσαντες οἱ μαθηταὶ ἔπεσαν ἐπὶ πρόσωπον αὐτῶν καὶ ἐφοβήθησαν σφόδρα. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","καὶ ⸂προσῆλθεν ὁ Ἰησοῦς καὶ ἁψάμενος αὐτῶν εἶπεν· Ἐγέρθητε καὶ μὴ φοβεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ἐπάραντες δὲ τοὺς ὀφθαλμοὺς αὐτῶν οὐδένα εἶδον εἰ μὴ ⸀αὐτὸνἸησοῦν μόνον. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Καὶ καταβαινόντων αὐτῶν ἐκ τοῦ ὄρους ἐνετείλατο αὐτοῖς ὁ Ἰησοῦς λέγων· Μηδενὶ εἴπητε τὸ ὅραμα ἕως οὗ ὁ υἱὸς τοῦ ἀνθρώπου ἐκ νεκρῶν ⸀ἐγερθῇ ");
INSERT INTO grcsbl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","καὶ ἐπηρώτησαν αὐτὸν οἱ ⸀μαθηταὶλέγοντες· Τί οὖν οἱ γραμματεῖς λέγουσιν ὅτι Ἠλίαν δεῖ ἐλθεῖν πρῶτον; ");
INSERT INTO grcsbl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ὁ ⸀δὲἀποκριθεὶς ⸀εἶπεν Ἠλίας μὲν ⸀ἔρχεταικαὶ ἀποκαταστήσει πάντα· ");
INSERT INTO grcsbl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","λέγω δὲ ὑμῖν ὅτι Ἠλίας ἤδη ἦλθεν, καὶ οὐκ ἐπέγνωσαν αὐτὸν ἀλλὰ ἐποίησαν ἐν αὐτῷ ὅσα ἠθέλησαν· οὕτως καὶ ὁ υἱὸς τοῦ ἀνθρώπου μέλλει πάσχειν ὑπʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","τότε συνῆκαν οἱ μαθηταὶ ὅτι περὶ Ἰωάννου τοῦ βαπτιστοῦ εἶπεν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Καὶ ⸀ἐλθόντωνπρὸς τὸν ὄχλον προσῆλθεν αὐτῷ ἄνθρωπος γονυπετῶν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","καὶ λέγων· Κύριε, ἐλέησόν μου τὸν υἱόν, ὅτι σεληνιάζεται καὶ κακῶς ⸀πάσχει πολλάκις γὰρ πίπτει εἰς τὸ πῦρ καὶ πολλάκις εἰς τὸ ὕδωρ. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","καὶ προσήνεγκα αὐτὸν τοῖς μαθηταῖς σου, καὶ οὐκ ἠδυνήθησαν αὐτὸν θεραπεῦσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν· Ὦ γενεὰ ἄπιστος καὶ διεστραμμένη, ἕως πότε ⸂μεθʼ ὑμῶν ἔσομαι; ἕως πότε ἀνέξομαι ὑμῶν; φέρετέ μοι αὐτὸν ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς, καὶ ἐξῆλθεν ἀπʼ αὐτοῦ τὸ δαιμόνιον· καὶ ἐθεραπεύθη ὁ παῖς ἀπὸ τῆς ὥρας ἐκείνης. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Τότε προσελθόντες οἱ μαθηταὶ τῷ Ἰησοῦ κατʼ ἰδίαν εἶπον· Διὰ τί ἡμεῖς οὐκ ἠδυνήθημεν ἐκβαλεῖν αὐτό; ");
INSERT INTO grcsbl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ὁ δὲ ⸀λέγειαὐτοῖς· Διὰ τὴν ⸀ὀλιγοπιστίανὑμῶν· ἀμὴν γὰρ λέγω ὑμῖν, ἐὰν ἔχητε πίστιν ὡς κόκκον σινάπεως, ἐρεῖτε τῷ ὄρει τούτῳ· ⸂Μετάβα ἔνθεν ἐκεῖ, καὶ μεταβήσεται, καὶ οὐδὲν ἀδυνατήσει ⸀ὑμῖν ");
INSERT INTO grcsbl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⸀Συστρεφομένωνδὲ αὐτῶν ἐν τῇ Γαλιλαίᾳ εἶπεν αὐτοῖς ὁ Ἰησοῦς· Μέλλει ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοσθαι εἰς χεῖρας ἀνθρώπων, ");
INSERT INTO grcsbl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","καὶ ἀποκτενοῦσιν αὐτόν, καὶ τῇ τρίτῃ ἡμέρᾳ ἐγερθήσεται. καὶ ἐλυπήθησαν σφόδρα. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ἐλθόντων δὲ αὐτῶν εἰς Καφαρναοὺμ προσῆλθον οἱ τὰ δίδραχμα λαμβάνοντες τῷ Πέτρῳ καὶ εἶπαν· Ὁ διδάσκαλος ὑμῶν οὐ τελεῖ τὰ δίδραχμα; ");
INSERT INTO grcsbl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","λέγει· Ναί. καὶ ⸀ἐλθόνταεἰς τὴν οἰκίαν προέφθασεν αὐτὸν ὁ Ἰησοῦς λέγων· Τί σοι δοκεῖ, Σίμων; οἱ βασιλεῖς τῆς γῆς ἀπὸ τίνων λαμβάνουσιν τέλη ἢ κῆνσον; ἀπὸ τῶν υἱῶν αὐτῶν ἢ ἀπὸ τῶν ἀλλοτρίων; ");
INSERT INTO grcsbl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","⸂εἰπόντος δέ· Ἀπὸ τῶν ἀλλοτρίων, ἔφη αὐτῷ ὁ Ἰησοῦς· Ἄρα γε ἐλεύθεροί εἰσιν οἱ υἱοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ἵνα δὲ μὴ σκανδαλίσωμεν αὐτούς, πορευθεὶς ⸀εἰςθάλασσαν βάλε ἄγκιστρον καὶ τὸν ⸀ἀναβάνταπρῶτον ἰχθὺν ἆρον, καὶ ἀνοίξας τὸ στόμα αὐτοῦ εὑρήσεις στατῆρα· ἐκεῖνον λαβὼν δὸς αὐτοῖς ἀντὶ ἐμοῦ καὶ σοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ἐν ἐκείνῃ τῇ ὥρᾳ προσῆλθον οἱ μαθηταὶ τῷ Ἰησοῦ λέγοντες· Τίς ἄρα μείζων ἐστὶν ἐν τῇ βασιλείᾳ τῶν οὐρανῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","καὶ ⸀προσκαλεσάμενοςπαιδίον ἔστησεν αὐτὸ ἐν μέσῳ αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","καὶ εἶπεν· Ἀμὴν λέγω ὑμῖν, ἐὰν μὴ στραφῆτε καὶ γένησθε ὡς τὰ παιδία, οὐ μὴ εἰσέλθητε εἰς τὴν βασιλείαν τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ὅστις οὖν ταπεινώσει ἑαυτὸν ὡς τὸ παιδίον τοῦτο, οὗτός ἐστιν ὁ μείζων ἐν τῇ βασιλείᾳ τῶν οὐρανῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","καὶ ὃς ⸀ἐὰνδέξηται ⸂ἓν παιδίον τοιοῦτο ἐπὶ τῷ ὀνόματί μου, ἐμὲ δέχεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ὃς δʼ ἂν σκανδαλίσῃ ἕνα τῶν μικρῶν τούτων τῶν πιστευόντων εἰςἐμέ, συμφέρει αὐτῷ ἵνα κρεμασθῇ μύλος ὀνικὸς ⸀εἰς τὸν τράχηλον αὐτοῦ καὶ καταποντισθῇ ἐν τῷ πελάγει τῆς θαλάσσης. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","οὐαὶ τῷ κόσμῳ ἀπὸ τῶν σκανδάλων· ἀνάγκη ⸀γὰρἐλθεῖν τὰ σκάνδαλα, πλὴν οὐαὶ τῷ ⸀ἀνθρώπῳδιʼ οὗ τὸ σκάνδαλον ἔρχεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Εἰ δὲ ἡ χείρ σου ἢ ὁ πούς σου σκανδαλίζει σε, ἔκκοψον ⸀αὐτὸνκαὶ βάλε ἀπὸ σοῦ· καλόν σοί ἐστιν εἰσελθεῖν εἰς τὴν ζωὴν ⸂κυλλὸν ἢ χωλόν, ἢ δύο χεῖρας ἢ δύο πόδας ἔχοντα βληθῆναι εἰς τὸ πῦρ τὸ αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","καὶ εἰ ὁ ὀφθαλμός σου σκανδαλίζει σε, ἔξελε αὐτὸν καὶ βάλε ἀπὸ σοῦ· καλόν σοί ἐστιν μονόφθαλμον εἰς τὴν ζωὴν εἰσελθεῖν, ἢ δύο ὀφθαλμοὺς ἔχοντα βληθῆναι εἰς τὴν γέενναν τοῦ πυρός. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ὁρᾶτε μὴ καταφρονήσητε ἑνὸς τῶν μικρῶν τούτων, λέγω γὰρ ὑμῖν ὅτι οἱ ἄγγελοι αὐτῶν ἐν οὐρανοῖςδιὰ παντὸς βλέπουσι τὸ πρόσωπον τοῦ πατρός μου τοῦ ἐν ⸀οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","τί ὑμῖν δοκεῖ; ἐὰν γένηταί τινι ἀνθρώπῳ ἑκατὸν πρόβατα καὶ πλανηθῇ ἓν ἐξ αὐτῶν, οὐχὶ ⸀ἀφήσειτὰ ἐνενήκοντα ἐννέα ἐπὶ τὰ ὄρη ⸀καὶπορευθεὶς ζητεῖ τὸ πλανώμενον; ");
INSERT INTO grcsbl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","καὶ ἐὰν γένηται εὑρεῖν αὐτό, ἀμὴν λέγω ὑμῖν ὅτι χαίρει ἐπʼ αὐτῷ μᾶλλον ἢ ἐπὶ τοῖς ἐνενήκοντα ἐννέα τοῖς μὴ πεπλανημένοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","οὕτως οὐκ ἔστιν θέλημα ⸀ἔμπροσθεντοῦ πατρὸς ⸀ὑμῶντοῦ ἐν οὐρανοῖς ἵνα ἀπόληται ⸀ἓντῶν μικρῶν τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ἐὰν δὲ ἁμαρτήσῃ ⸂εἰς σὲ ὁ ἀδελφός σου, ⸀ὕπαγεἔλεγξον αὐτὸν μεταξὺ σοῦ καὶ αὐτοῦ μόνου. ἐάν σου ἀκούσῃ, ἐκέρδησας τὸν ἀδελφόν σου· ");
INSERT INTO grcsbl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ἐὰν δὲ μὴ ἀκούσῃ, παράλαβε μετὰ σοῦ ἔτι ἕνα ἢ δύο, ἵνα ἐπὶ στόματος δύο μαρτύρων ἢ τριῶν σταθῇ πᾶν ῥῆμα· ");
INSERT INTO grcsbl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ἐὰν δὲ παρακούσῃ αὐτῶν, εἰπὸν τῇ ἐκκλησίᾳ· ἐὰν δὲ καὶ τῆς ἐκκλησίας παρακούσῃ, ἔστω σοι ὥσπερ ὁ ἐθνικὸς καὶ ὁ τελώνης. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ἀμὴν λέγω ὑμῖν, ὅσα ⸀ἐὰνδήσητε ἐπὶ τῆς γῆς ἔσται δεδεμένα ⸀ἐνοὐρανῷ καὶ ὅσα ἐὰν λύσητε ἐπὶ τῆς γῆς ἔσται λελυμένα ⸁ἐνοὐρανῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Πάλιν ⸀ἀμὴνλέγω ὑμῖν ὅτι ἐὰν δύο ⸂συμφωνήσωσιν ἐξ ὑμῶν ἐπὶ τῆς γῆς περὶ παντὸς πράγματος οὗ ἐὰν αἰτήσωνται, γενήσεται αὐτοῖς παρὰ τοῦ πατρός μου τοῦ ἐν οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","οὗ γάρ εἰσιν δύο ἢ τρεῖς συνηγμένοι εἰς τὸ ἐμὸν ὄνομα, ἐκεῖ εἰμι ἐν μέσῳ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Τότε προσελθὼν ⸂αὐτῷ ὁ Πέτρος εἶπεν· Κύριε, ποσάκις ἁμαρτήσει εἰς ἐμὲ ὁ ἀδελφός μου καὶ ἀφήσω αὐτῷ; ἕως ἑπτάκις; ");
INSERT INTO grcsbl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","λέγει αὐτῷ ὁ Ἰησοῦς· Οὐ λέγω σοι ἕως ἑπτάκις ἀλλὰ ἕως ἑβδομηκοντάκις ἑπτά. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Διὰ τοῦτο ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ βασιλεῖ ὃς ἠθέλησεν συνᾶραι λόγον μετὰ τῶν δούλων αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ἀρξαμένου δὲ αὐτοῦ συναίρειν ⸀προσηνέχθη⸂αὐτῷ εἷς⸃ ὀφειλέτης μυρίων ταλάντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","μὴ ἔχοντος δὲ αὐτοῦ ἀποδοῦναι ἐκέλευσεν αὐτὸν ὁ ⸀κύριοςπραθῆναι καὶ τὴν ⸀γυναῖκακαὶ τὰ τέκνα καὶ πάντα ὅσα ⸀ἔχεικαὶ ἀποδοθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","πεσὼν οὖν ὁ δοῦλος προσεκύνει αὐτῷ λέγων· ⸀Μακροθύμησονἐπʼ ⸀ἐμοί καὶ πάντα ⸂ἀποδώσω σοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","σπλαγχνισθεὶς δὲ ὁ κύριος τοῦ δούλου ἐκείνου ἀπέλυσεν αὐτόν, καὶ τὸ δάνειον ἀφῆκεν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ἐξελθὼν δὲ ὁ δοῦλος ἐκεῖνος εὗρεν ἕνα τῶν συνδούλων αὐτοῦ ὃς ὤφειλεν αὐτῷ ἑκατὸν δηνάρια, καὶ κρατήσας αὐτὸν ἔπνιγεν λέγων· ⸀Ἀπόδοςεἴ τι ὀφείλεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","πεσὼν οὖν ὁ σύνδουλος ⸀αὐτοῦπαρεκάλει αὐτὸν λέγων· Μακροθύμησον ἐπʼ ⸀ἐμοί καὶ ἀποδώσω σοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ὁ δὲ οὐκ ἤθελεν, ἀλλὰ ἀπελθὼν ἔβαλεν αὐτὸν εἰς φυλακὴν ἕως ⸀οὗἀποδῷ τὸ ὀφειλόμενον. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ἰδόντες ⸀οὖνοἱ σύνδουλοι αὐτοῦ τὰ γενόμενα ἐλυπήθησαν σφόδρα, καὶ ἐλθόντες διεσάφησαν τῷ κυρίῳ ἑαυτῶν πάντα τὰ γενόμενα. ");
INSERT INTO grcsbl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","τότε προσκαλεσάμενος αὐτὸν ὁ κύριος αὐτοῦ λέγει αὐτῷ· Δοῦλε πονηρέ, πᾶσαν τὴν ὀφειλὴν ἐκείνην ἀφῆκά σοι, ἐπεὶ παρεκάλεσάς με· ");
INSERT INTO grcsbl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","οὐκ ἔδει καὶ σὲ ἐλεῆσαι τὸν σύνδουλόν σου, ὡς κἀγὼ σὲ ἠλέησα; ");
INSERT INTO grcsbl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","καὶ ὀργισθεὶς ὁ κύριος αὐτοῦ παρέδωκεν αὐτὸν τοῖς βασανισταῖς ἕως οὗ ἀποδῷ πᾶν τὸ ⸀ὀφειλόμενον ");
INSERT INTO grcsbl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Οὕτως καὶ ὁ πατήρ μου ὁ ⸀οὐράνιοςποιήσει ὑμῖν ἐὰν μὴ ἀφῆτε ἕκαστος τῷ ἀδελφῷ αὐτοῦ ἀπὸ τῶν καρδιῶν ⸀ὑμῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς τοὺς λόγους τούτους, μετῆρεν ἀπὸ τῆς Γαλιλαίας καὶ ἦλθεν εἰς τὰ ὅρια τῆς Ἰουδαίας πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","καὶ ἠκολούθησαν αὐτῷ ὄχλοι πολλοί, καὶ ἐθεράπευσεν αὐτοὺς ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Καὶ προσῆλθον ⸀αὐτῷΦαρισαῖοι πειράζοντες αὐτὸν καὶ ⸀λέγοντες Εἰ ἔξεστιν ⸀ἀνθρώπῳἀπολῦσαι τὴν γυναῖκα αὐτοῦ κατὰ πᾶσαν αἰτίαν; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ὁ δὲ ἀποκριθεὶς ⸀εἶπεν Οὐκ ἀνέγνωτε ὅτι ὁ ⸀κτίσαςἀπʼ ἀρχῆς ἄρσεν καὶ θῆλυ ἐποίησεν αὐτοὺς ");
INSERT INTO grcsbl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","καὶ εἶπεν· ⸀Ἕνεκατούτου καταλείψει ἄνθρωπος τὸν πατέρα καὶ τὴν μητέρα καὶ ⸀κολληθήσεταιτῇ γυναικὶ αὐτοῦ, καὶ ἔσονται οἱ δύο εἰς σάρκα μίαν; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ὥστε οὐκέτι εἰσὶν δύο ἀλλὰ σὰρξ μία. ὃ οὖν ὁ θεὸς συνέζευξεν ἄνθρωπος μὴ χωριζέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","λέγουσιν αὐτῷ· Τί οὖν Μωϋσῆς ἐνετείλατο δοῦναι βιβλίον ἀποστασίου καὶ ἀπολῦσαι ⸀αὐτήν ");
INSERT INTO grcsbl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","λέγει αὐτοῖς ὅτι Μωϋσῆς πρὸς τὴν σκληροκαρδίαν ὑμῶν ἐπέτρεψεν ὑμῖν ἀπολῦσαι τὰς γυναῖκας ὑμῶν, ἀπʼ ἀρχῆς δὲ οὐ γέγονεν οὕτως. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","λέγω δὲ ὑμῖν ⸀ὅτιὃς ἂν ἀπολύσῃ τὴν γυναῖκα αὐτοῦ μὴ ἐπὶ πορνείᾳ καὶ γαμήσῃ ἄλλην μοιχᾶται ⸂καὶ ὁ ἀπολελυμένην γαμήσας μοιχᾶται. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Λέγουσιν αὐτῷ οἱ ⸀μαθηταί Εἰ οὕτως ἐστὶν ἡ αἰτία τοῦ ἀνθρώπου μετὰ τῆς γυναικός, οὐ συμφέρει γαμῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ὁ δὲ εἶπεν αὐτοῖς· Οὐ πάντες χωροῦσι τὸν λόγον ⸀τοῦτονἀλλʼ οἷς δέδοται. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","εἰσὶν γὰρ εὐνοῦχοι οἵτινες ἐκ κοιλίας μητρὸς ἐγεννήθησαν οὕτως, καὶ εἰσὶν εὐνοῦχοι οἵτινες εὐνουχίσθησαν ὑπὸ τῶν ἀνθρώπων, καὶ εἰσὶν εὐνοῦχοι οἵτινες εὐνούχισαν ἑαυτοὺς διὰ τὴν βασιλείαν τῶν οὐρανῶν. ὁ δυνάμενος χωρεῖν χωρείτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Τότε ⸀προσηνέχθησαναὐτῷ παιδία ἵνα τὰς χεῖρας ἐπιθῇ αὐτοῖς καὶ προσεύξηται· οἱ δὲ μαθηταὶ ἐπετίμησαν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ὁ δὲ Ἰησοῦς εἶπεν· Ἄφετε τὰ παιδία καὶ μὴ κωλύετε αὐτὰ ἐλθεῖν πρός με, τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τῶν οὐρανῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","καὶ ἐπιθεὶς ⸂τὰς χεῖρας αὐτοῖς ἐπορεύθη ἐκεῖθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Καὶ ἰδοὺ εἷς προσελθὼν ⸂αὐτῷ εἶπεν· ⸀Διδάσκαλε τί ἀγαθὸν ποιήσω ἵνα ⸀σχῶζωὴν αἰώνιον; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ὁ δὲ εἶπεν αὐτῷ· Τί με ⸂ἐρωτᾷς περὶ τοῦ ἀγαθοῦ; εἷς ἐστιν ὁ ἀγαθός· εἰ δὲ θέλεις ⸂εἰς τὴν ζωὴν εἰσελθεῖν, ⸀τήρησοντὰς ἐντολάς. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","λέγει αὐτῷ· Ποίας; ὁ δὲ Ἰησοῦς ⸀εἶπεν Τὸ Οὐ φονεύσεις, Οὐ μοιχεύσεις, Οὐ κλέψεις, Οὐ ψευδομαρτυρήσεις, ");
INSERT INTO grcsbl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Τίμα τὸν πατέρα καὶ τὴν μητέρα, καὶ Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","λέγει αὐτῷ ὁ νεανίσκος· ⸂Πάντα ταῦτα ⸀ἐφύλαξα τί ἔτι ὑστερῶ; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ἔφη αὐτῷ ὁ Ἰησοῦς· Εἰ θέλεις τέλειος εἶναι, ὕπαγε πώλησόν σου τὰ ὑπάρχοντα καὶ ⸀δὸςπτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν ⸀οὐρανοῖς καὶ δεῦρο ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ἀκούσας δὲ ὁ νεανίσκος τὸν ⸀λόγονἀπῆλθεν λυπούμενος, ἦν γὰρ ἔχων κτήματα πολλά. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ὁ δὲ Ἰησοῦς εἶπεν τοῖς μαθηταῖς αὐτοῦ· Ἀμὴν λέγω ὑμῖν ὅτι ⸂πλούσιος δυσκόλως εἰσελεύσεται εἰς τὴν βασιλείαν τῶν οὐρανῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","πάλιν δὲ λέγω ὑμῖν, εὐκοπώτερόν ἐστιν κάμηλον διὰ ⸀τρυπήματοςῥαφίδος ⸀εἰσελθεῖνἢ πλούσιον ⸂εἰς τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ἀκούσαντες δὲ οἱ ⸀μαθηταὶἐξεπλήσσοντο σφόδρα λέγοντες· Τίς ἄρα δύναται σωθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ἐμβλέψας δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Παρὰ ἀνθρώποις τοῦτο ἀδύνατόν ἐστιν, παρὰ δὲ θεῷ πάντα δυνατά. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Τότε ἀποκριθεὶς ὁ Πέτρος εἶπεν αὐτῷ· Ἰδοὺ ἡμεῖς ἀφήκαμεν πάντα καὶ ἠκολουθήσαμέν σοι· τί ἄρα ἔσται ἡμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Ἀμὴν λέγω ὑμῖν ὅτι ὑμεῖς οἱ ἀκολουθήσαντές μοι ἐν τῇ παλιγγενεσίᾳ, ὅταν καθίσῃ ὁ υἱὸς τοῦ ἀνθρώπου ἐπὶ θρόνου δόξης αὐτοῦ, ⸀καθήσεσθεκαὶ ⸀ὑμεῖςἐπὶ δώδεκα θρόνους κρίνοντες τὰς δώδεκα φυλὰς τοῦ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","καὶ πᾶς ⸀ὅστιςἀφῆκεν ⸂οἰκίας ἢ ἀδελφοὺς ἢ ἀδελφὰς ἢ πατέρα ἢ μητέρα ἢ ⸂γυναῖκα ἢ τέκνα ἢ ⸀ἀγροὺςἕνεκεν τοῦ ⸂ὀνόματός μου, ⸀ἑκατονταπλασίοναλήμψεται καὶ ζωὴν αἰώνιον κληρονομήσει. ");
INSERT INTO grcsbl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","πολλοὶ δὲ ἔσονται πρῶτοι ἔσχατοι καὶ ἔσχατοι πρῶτοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ὁμοία γάρ ἐστιν ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ οἰκοδεσπότῃ ὅστις ἐξῆλθεν ἅμα πρωῒ μισθώσασθαι ἐργάτας εἰς τὸν ἀμπελῶνα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","⸂συμφωνήσας δὲ μετὰ τῶν ἐργατῶν ἐκ δηναρίου τὴν ἡμέραν ἀπέστειλεν αὐτοὺς εἰς τὸν ἀμπελῶνα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","καὶ ἐξελθὼν περὶ τρίτην ὥραν εἶδεν ἄλλους ἑστῶτας ἐν τῇ ἀγορᾷ ἀργούς· ");
INSERT INTO grcsbl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","καὶ ἐκείνοις εἶπεν· Ὑπάγετε καὶ ὑμεῖς εἰς τὸν ἀμπελῶνα, καὶ ὃ ἐὰν ᾖ δίκαιον δώσω ὑμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","οἱ δὲ ἀπῆλθον. ⸀πάλινἐξελθὼν περὶ ἕκτην καὶ ἐνάτην ὥραν ἐποίησεν ὡσαύτως. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","περὶ δὲ τὴν ⸀ἑνδεκάτηνἐξελθὼν εὗρεν ἄλλους ⸀ἑστῶτας καὶ λέγει αὐτοῖς· Τί ὧδε ἑστήκατε ὅλην τὴν ἡμέραν ἀργοί; ");
INSERT INTO grcsbl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","λέγουσιν αὐτῷ· Ὅτι οὐδεὶς ἡμᾶς ἐμισθώσατο. λέγει αὐτοῖς· Ὑπάγετε καὶ ὑμεῖς εἰς τὸν ⸀ἀμπελῶνα ");
INSERT INTO grcsbl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ὀψίας δὲ γενομένης λέγει ὁ κύριος τοῦ ἀμπελῶνος τῷ ἐπιτρόπῳ αὐτοῦ· Κάλεσον τοὺς ἐργάτας καὶ ἀπόδος ⸀αὐτοῖςτὸν μισθὸν ἀρξάμενος ἀπὸ τῶν ἐσχάτων ἕως τῶν πρώτων. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","⸂καὶ ἐλθόντες οἱ περὶ τὴν ἑνδεκάτην ὥραν ἔλαβον ἀνὰ δηνάριον. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","⸂καὶ ἐλθόντες οἱ πρῶτοι ἐνόμισαν ὅτι ⸀πλεῖονλήμψονται· καὶ ἔλαβον ⸂τὸ ἀνὰ δηνάριον καὶ αὐτοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","λαβόντες δὲ ἐγόγγυζον κατὰ τοῦ οἰκοδεσπότου ");
INSERT INTO grcsbl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","⸀λέγοντες Οὗτοι οἱ ἔσχατοι μίαν ὥραν ἐποίησαν, καὶ ἴσους ⸂αὐτοὺς ἡμῖν ἐποίησας τοῖς βαστάσασι τὸ βάρος τῆς ἡμέρας καὶ τὸν καύσωνα. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ὁ δὲ ἀποκριθεὶς ⸂ἑνὶ αὐτῶν εἶπεν· Ἑταῖρε, οὐκ ἀδικῶ σε· οὐχὶ δηναρίου συνεφώνησάς μοι; ");
INSERT INTO grcsbl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ἆρον τὸ σὸν καὶ ὕπαγε· θέλω δὲ τούτῳ τῷ ἐσχάτῳ δοῦναι ὡς καὶ σοί· ");
INSERT INTO grcsbl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","⸀οὐκἔξεστίν μοι ⸂ὃ θέλω ποιῆσαι ἐν τοῖς ἐμοῖς; ⸀ἢὁ ὀφθαλμός σου πονηρός ἐστιν ὅτι ἐγὼ ἀγαθός εἰμι; ");
INSERT INTO grcsbl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","οὕτως ἔσονται οἱ ἔσχατοιπρῶτοι καὶ οἱ πρῶτοι ⸀ἔσχατοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","⸂Καὶ ἀναβαίνων ὁ Ἰησοῦς εἰς Ἱεροσόλυμα παρέλαβεν τοὺς δώδεκα ⸀μαθητὰςκατʼ ἰδίαν, ⸂καὶ ἐν τῇ ὁδῷ εἶπεν αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ἰδοὺ ἀναβαίνομεν εἰς Ἱεροσόλυμα, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδοθήσεται τοῖς ἀρχιερεῦσιν καὶ γραμματεῦσιν, καὶ κατακρινοῦσιν αὐτὸν θανάτῳ, ");
INSERT INTO grcsbl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","καὶ παραδώσουσιν αὐτὸν τοῖς ἔθνεσιν εἰς τὸ ἐμπαῖξαι καὶ μαστιγῶσαι καὶ σταυρῶσαι, καὶ τῇ τρίτῃ ἡμέρᾳ ⸀ἐγερθήσεται ");
INSERT INTO grcsbl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Τότε προσῆλθεν αὐτῷ ἡ μήτηρ τῶν υἱῶν Ζεβεδαίου μετὰ τῶν υἱῶν αὐτῆς προσκυνοῦσα καὶ αἰτοῦσά τι ⸀παρʼαὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ὁ δὲ εἶπεν αὐτῇ· Τί θέλεις; λέγει αὐτῷ· Εἰπὲ ἵνα καθίσωσιν οὗτοι οἱ δύο υἱοί μου εἷς ἐκ δεξιῶν ⸀σουκαὶ εἷς ἐξ εὐωνύμων σου ἐν τῇ βασιλείᾳ σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν· Οὐκ οἴδατε τί αἰτεῖσθε· δύνασθε πιεῖν τὸ ποτήριον ὃ ἐγὼ μέλλω ⸀πίνειν λέγουσιν αὐτῷ· Δυνάμεθα. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","⸀λέγειαὐτοῖς· Τὸ μὲν ποτήριόν μου ⸀πίεσθε τὸ δὲ καθίσαι ἐκ δεξιῶν μου καὶ ἐξ ⸀εὐωνύμωνοὐκ ἔστιν ⸀ἐμὸνδοῦναι, ἀλλʼ οἷς ἡτοίμασται ὑπὸ τοῦ πατρός μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Καὶ ἀκούσαντες οἱ δέκα ἠγανάκτησαν περὶ τῶν δύο ἀδελφῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ὁ δὲ Ἰησοῦς προσκαλεσάμενος αὐτοὺς εἶπεν· Οἴδατε ὅτι οἱ ἄρχοντες τῶν ἐθνῶν κατακυριεύουσιν αὐτῶν καὶ οἱ μεγάλοι κατεξουσιάζουσιν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","οὐχ οὕτως ⸀ἔσταιἐν ὑμῖν· ἀλλʼ ὃς ⸀ἂνθέλῃ ἐν ὑμῖν μέγας γενέσθαι ἔσται ὑμῶν διάκονος, ");
INSERT INTO grcsbl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","καὶ ὃς ⸀ἂνθέλῃ ἐν ὑμῖν εἶναι πρῶτος ⸀ἔσταιὑμῶν δοῦλος· ");
INSERT INTO grcsbl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ὥσπερ ὁ υἱὸς τοῦ ἀνθρώπου οὐκ ἦλθεν διακονηθῆναι ἀλλὰ διακονῆσαι καὶ δοῦναι τὴν ψυχὴν αὐτοῦ λύτρον ἀντὶ πολλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Καὶ ἐκπορευομένων αὐτῶν ἀπὸ Ἰεριχὼ ἠκολούθησεν αὐτῷ ὄχλος πολύς. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","καὶ ἰδοὺ δύο τυφλοὶ καθήμενοι παρὰ τὴν ὁδόν, ἀκούσαντες ὅτι Ἰησοῦς παράγει, ἔκραξαν λέγοντες· ⸂Κύριε, ἐλέησον ἡμᾶς⸃, ⸀υἱὸς Δαυίδ. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ὁ δὲ ὄχλος ἐπετίμησεν αὐτοῖς ἵνα σιωπήσωσιν· οἱ δὲ μεῖζον ⸀ἔκραξανλέγοντες· ⸂Κύριε, ἐλέησον ἡμᾶς⸃, ⸀υἱὸς Δαυίδ. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","καὶ στὰς ὁ Ἰησοῦς ἐφώνησεν αὐτοὺς καὶ εἶπεν· Τί θέλετε ποιήσω ὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","λέγουσιν αὐτῷ· Κύριε, ἵνα ⸂ἀνοιγῶσιν οἱ ὀφθαλμοὶ ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","σπλαγχνισθεὶς δὲ ὁ Ἰησοῦς ἥψατο τῶν ⸀ὀμμάτωναὐτῶν, καὶ εὐθέως ⸀ἀνέβλεψανκαὶ ἠκολούθησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Καὶ ὅτε ἤγγισαν εἰςἹεροσόλυμα καὶ ἦλθον εἰς Βηθφαγὴ ⸀εἰς τὸ Ὄρος τῶν Ἐλαιῶν, τότε ⸀Ἰησοῦςἀπέστειλεν δύο μαθητὰς ");
INSERT INTO grcsbl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","λέγων αὐτοῖς· ⸀Πορεύεσθεεἰς τὴν κώμην τὴν ⸀κατέναντιὑμῶν, καὶ ⸀εὐθέωςεὑρήσετε ὄνον δεδεμένην καὶ πῶλον μετʼ αὐτῆς· λύσαντες ⸀ἀγάγετέμοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","καὶ ἐάν τις ὑμῖν εἴπῃ τι, ἐρεῖτε ὅτι Ὁ κύριος αὐτῶν χρείαν ἔχει· ⸀εὐθὺςδὲ ⸀ἀποστελεῖαὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Τοῦτο ⸀δὲγέγονεν ἵνα πληρωθῇ τὸ ῥηθὲν διὰ τοῦ προφήτου λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Εἴπατε τῇ θυγατρὶ Σιών· Ἰδοὺ ὁ βασιλεύς σου ἔρχεταί σοι πραῢς καὶ ἐπιβεβηκὼς ἐπὶὄνον καὶ ⸀ἐπὶ πῶλον υἱὸν ὑποζυγίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","πορευθέντες δὲ οἱ μαθηταὶ καὶ ποιήσαντες καθὼς ⸀συνέταξεναὐτοῖς ὁ Ἰησοῦς ");
INSERT INTO grcsbl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ἤγαγον τὴν ὄνον καὶ τὸν πῶλον, καὶ ἐπέθηκαν ⸀ἐπʼαὐτῶν τὰ ⸀ἱμάτια καὶ ἐπεκάθισεν ἐπάνω αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ὁ δὲ πλεῖστος ὄχλος ἔστρωσαν ἑαυτῶν τὰ ἱμάτια ἐν τῇ ὁδῷ, ἄλλοι δὲ ἔκοπτον κλάδους ἀπὸ τῶν δένδρων καὶ ἐστρώννυον ἐν τῇ ὁδῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","οἱ δὲ ὄχλοι οἱ προάγοντες ⸀αὐτὸνκαὶ οἱ ἀκολουθοῦντες ἔκραζον λέγοντες· Ὡσαννὰ τῷ υἱῷ Δαυίδ· Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι κυρίου· Ὡσαννὰ ἐν τοῖς ὑψίστοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","καὶ εἰσελθόντος αὐτοῦ εἰς Ἱεροσόλυμα ἐσείσθη πᾶσα ἡ πόλις λέγουσα· Τίς ἐστιν οὗτος; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","οἱ δὲ ὄχλοι ἔλεγον· Οὗτός ἐστιν ⸂ὁ προφήτης Ἰησοῦς ὁ ἀπὸ Ναζαρὲθ τῆς Γαλιλαίας. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Καὶ εἰσῆλθεν ⸀Ἰησοῦςεἰς τὸ ⸀ἱερόν καὶ ἐξέβαλεν πάντας τοὺς πωλοῦντας καὶ ἀγοράζοντας ἐν τῷ ἱερῷ καὶ τὰς τραπέζας τῶν κολλυβιστῶν κατέστρεψεν καὶ τὰς καθέδρας τῶν πωλούντων τὰς περιστεράς, ");
INSERT INTO grcsbl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","καὶ λέγει αὐτοῖς· Γέγραπται· Ὁ οἶκός μου οἶκος προσευχῆς κληθήσεται, ὑμεῖς δὲ αὐτὸν ⸀ποιεῖτεσπήλαιον λῃστῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Καὶ προσῆλθον αὐτῷ ⸂τυφλοὶ καὶ χωλοὶ ἐν τῷ ἱερῷ, καὶ ἐθεράπευσεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ἰδόντες δὲ οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς τὰ θαυμάσια ἃ ἐποίησεν καὶ τοὺςπαῖδας ⸀τοὺς κράζοντας ἐν τῷ ἱερῷ καὶ λέγοντας· Ὡσαννὰ τῷ υἱῷ Δαυίδ, ἠγανάκτησαν ");
INSERT INTO grcsbl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","καὶ εἶπαν αὐτῷ· Ἀκούεις τί οὗτοι λέγουσιν; ὁ δὲ Ἰησοῦς λέγει αὐτοῖς· Ναί. οὐδέποτε ἀνέγνωτε ὅτι Ἐκ στόματος νηπίων καὶ θηλαζόντων κατηρτίσω αἶνον; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","καὶ καταλιπὼν αὐτοὺς ἐξῆλθεν ἔξω τῆς πόλεως εἰς Βηθανίαν, καὶ ηὐλίσθη ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","⸀Πρωῒδὲ ⸀ἐπανάγωνεἰς τὴν πόλιν ἐπείνασεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","καὶ ἰδὼν συκῆν μίαν ἐπὶ τῆς ὁδοῦ ἦλθεν ἐπʼ αὐτήν, καὶ οὐδὲν εὗρεν ἐν αὐτῇ εἰ μὴ φύλλα μόνον, καὶ λέγει αὐτῇ· ⸀Μηκέτιἐκ σοῦ καρπὸς γένηται εἰς τὸν αἰῶνα· καὶ ἐξηράνθη παραχρῆμα ἡ συκῆ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","καὶ ἰδόντες οἱ μαθηταὶ ἐθαύμασαν λέγοντες· Πῶς παραχρῆμα ἐξηράνθη ἡ συκῆ; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Ἀμὴν λέγω ὑμῖν, ἐὰν ἔχητε πίστιν καὶ μὴ διακριθῆτε, οὐ μόνον τὸ τῆς συκῆς ποιήσετε, ἀλλὰ κἂν τῷ ὄρει τούτῳ εἴπητε· Ἄρθητι καὶ βλήθητι εἰς τὴν θάλασσαν, γενήσεται· ");
INSERT INTO grcsbl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","καὶ πάντα ὅσα ⸀ἂναἰτήσητε ἐν τῇ προσευχῇ πιστεύοντες λήμψεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Καὶ ⸂ἐλθόντος αὐτοῦ εἰς τὸ ἱερὸν προσῆλθον αὐτῷ διδάσκοντι οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τοῦ λαοῦ λέγοντες· Ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς; καὶ τίς σοι ἔδωκεν τὴν ἐξουσίαν ταύτην; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Ἐρωτήσω ὑμᾶς κἀγὼ λόγον ἕνα, ὃν ἐὰν εἴπητέ μοι κἀγὼ ὑμῖν ἐρῶ ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ· ");
INSERT INTO grcsbl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","τὸβάπτισμα ⸀τὸ Ἰωάννου πόθεν ἦν; ἐξ οὐρανοῦ ἢ ἐξ ἀνθρώπων; οἱ δὲ διελογίζοντο ⸀ἐνἑαυτοῖς λέγοντες· Ἐὰν εἴπωμεν· Ἐξ οὐρανοῦ, ἐρεῖ ἡμῖν· Διὰ τί οὖν οὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ἐὰν δὲ εἴπωμεν· Ἐξ ἀνθρώπων, φοβούμεθα τὸν ὄχλον, πάντες γὰρ ⸂ὡς προφήτην ἔχουσιν τὸν Ἰωάννην. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","καὶ ἀποκριθέντες τῷ Ἰησοῦ εἶπαν· Οὐκ οἴδαμεν. ἔφη αὐτοῖς καὶ αὐτός· Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Τί δὲ ὑμῖν δοκεῖ; ἄνθρωπος εἶχεν τέκνα δύο. ⸀προσελθὼντῷ πρώτῳ εἶπεν· Τέκνον, ὕπαγε σήμερον ἐργάζου ἐν τῷ ⸀ἀμπελῶνι ");
INSERT INTO grcsbl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ὁ δὲ ἀποκριθεὶς εἶπεν· ⸂Οὐ θέλω· ὕστερον δὲ μεταμεληθεὶς⸃ ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","⸂προσελθὼν δὲ τῷ ⸀δευτέρῳεἶπεν ὡσαύτως· ὁ δὲ ἀποκριθεὶς εἶπεν· ⸂Ἐγώ, κύριε· καὶ οὐκ⸃ ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","τίς ἐκ τῶν δύο ἐποίησεν τὸ θέλημα τοῦ πατρός; ⸀λέγουσιν Ὁ ⸀πρῶτος λέγει αὐτοῖς ὁ Ἰησοῦς· Ἀμὴν λέγω ὑμῖν ὅτι οἱ τελῶναι καὶ αἱ πόρναι προάγουσιν ὑμᾶς εἰς τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ἦλθεν γὰρ ⸂Ἰωάννης πρὸς ὑμᾶς ἐν ὁδῷ δικαιοσύνης, καὶ οὐκ ἐπιστεύσατε αὐτῷ· οἱ δὲ τελῶναι καὶ αἱ πόρναι ἐπίστευσαν αὐτῷ· ὑμεῖς δὲ ἰδόντες ⸀οὐδὲμετεμελήθητε ὕστερον τοῦ πιστεῦσαι αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ἄλλην παραβολὴν ἀκούσατε. ⸀Ἄνθρωποςἦν οἰκοδεσπότης ὅστις ἐφύτευσεν ἀμπελῶνα καὶ φραγμὸν αὐτῷ περιέθηκεν καὶ ὤρυξεν ἐν αὐτῷ ληνὸν καὶ ᾠκοδόμησεν πύργον, καὶ ἐξέδετο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ὅτε δὲ ἤγγισεν ὁ καιρὸς τῶν καρπῶν, ἀπέστειλεν τοὺς δούλους αὐτοῦ πρὸς τοὺς γεωργοὺς λαβεῖν τοὺς καρποὺς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","καὶ λαβόντες οἱ γεωργοὶ τοὺς δούλους αὐτοῦ ὃν μὲν ἔδειραν, ὃν δὲ ἀπέκτειναν, ὃν δὲ ἐλιθοβόλησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","πάλιν ἀπέστειλεν ἄλλους δούλους πλείονας τῶν πρώτων, καὶ ἐποίησαν αὐτοῖς ὡσαύτως. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ὕστερον δὲ ἀπέστειλεν πρὸς αὐτοὺς τὸν υἱὸν αὐτοῦ λέγων· Ἐντραπήσονται τὸν υἱόν μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","οἱ δὲ γεωργοὶ ἰδόντες τὸν υἱὸν εἶπον ἐν ἑαυτοῖς· Οὗτός ἐστιν ὁ κληρονόμος· δεῦτε ἀποκτείνωμεν αὐτὸν καὶ ⸀σχῶμεντὴν κληρονομίαν αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","καὶ λαβόντες αὐτὸν ἐξέβαλον ἔξω τοῦ ἀμπελῶνος καὶ ἀπέκτειναν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ὅταν οὖν ἔλθῃ ὁ κύριος τοῦ ἀμπελῶνος, τί ποιήσει τοῖς γεωργοῖς ἐκείνοις; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","λέγουσιν αὐτῷ· Κακοὺς κακῶς ἀπολέσει αὐτούς, καὶ τὸν ἀμπελῶνα ἐκδώσεται ἄλλοις γεωργοῖς, οἵτινες ἀποδώσουσιν αὐτῷ τοὺς καρποὺς ἐν τοῖς καιροῖς αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Λέγει αὐτοῖς ὁ Ἰησοῦς· Οὐδέποτε ἀνέγνωτε ἐν ταῖς γραφαῖς· Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας· παρὰ κυρίου ἐγένετο αὕτη, καὶ ἔστιν θαυμαστὴ ἐν ὀφθαλμοῖς ἡμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","διὰ τοῦτο λέγω ὑμῖν ὅτι ἀρθήσεται ἀφʼ ὑμῶν ἡ βασιλεία τοῦ θεοῦ καὶ δοθήσεται ἔθνει ποιοῦντι τοὺς καρποὺς αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","⸂Καὶ ὁ πεσὼν ἐπὶ τὸν λίθον τοῦτον συνθλασθήσεται· ἐφʼ ὃν δʼ ἂν πέσῃ λικμήσει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Καὶ ἀκούσαντες οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι τὰς παραβολὰς αὐτοῦ ἔγνωσαν ὅτι περὶ αὐτῶν λέγει· ");
INSERT INTO grcsbl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","καὶ ζητοῦντες αὐτὸν κρατῆσαι ἐφοβήθησαν τοὺς ὄχλους, ⸂ἐπεὶ εἰς προφήτην αὐτὸν εἶχον. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς πάλιν εἶπεν ⸂ἐν παραβολαῖς αὐτοῖς λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ὡμοιώθη ἡ βασιλεία τῶν οὐρανῶν ἀνθρώπῳ βασιλεῖ, ὅστις ἐποίησεν γάμους τῷ υἱῷ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","καὶ ἀπέστειλεν τοὺς δούλους αὐτοῦ καλέσαι τοὺς κεκλημένους εἰς τοὺς γάμους, καὶ οὐκ ἤθελον ἐλθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","πάλιν ἀπέστειλεν ἄλλους δούλους λέγων· Εἴπατε τοῖς κεκλημένοις· Ἰδοὺ τὸ ἄριστόν μου ⸀ἡτοίμακα οἱ ταῦροί μου καὶ τὰ σιτιστὰ τεθυμένα, καὶ πάντα ἕτοιμα· δεῦτε εἰς τοὺς γάμους. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","οἱ δὲ ἀμελήσαντες ἀπῆλθον, ⸀ὃςμὲν εἰς τὸν ἴδιον ἀγρόν, ⸁ὃςδὲ ⸀ἐπὶτὴν ἐμπορίαν αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","οἱ δὲ λοιποὶ κρατήσαντες τοὺς δούλους αὐτοῦ ὕβρισαν καὶ ἀπέκτειναν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","⸂ὁ δὲ βασιλεὺς ὠργίσθη, καὶ πέμψας τὰ στρατεύματα αὐτοῦ ἀπώλεσεν τοὺς φονεῖς ἐκείνους καὶ τὴν πόλιν αὐτῶν ἐνέπρησεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","τότε λέγει τοῖς δούλοις αὐτοῦ· Ὁ μὲν γάμος ἕτοιμός ἐστιν, οἱ δὲ κεκλημένοι οὐκ ἦσαν ἄξιοι· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","πορεύεσθε οὖν ἐπὶ τὰς διεξόδους τῶν ὁδῶν, καὶ ὅσους ⸀ἐὰνεὕρητε καλέσατε εἰς τοὺς γάμους. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","καὶ ἐξελθόντες οἱ δοῦλοι ἐκεῖνοι εἰς τὰς ὁδοὺς συνήγαγον πάντας ⸀οὓςεὗρον, πονηρούς τε καὶ ἀγαθούς· καὶ ἐπλήσθη ὁ ⸀γάμοςἀνακειμένων. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","εἰσελθὼν δὲ ὁ βασιλεὺς θεάσασθαι τοὺς ἀνακειμένους εἶδεν ἐκεῖ ἄνθρωπον οὐκ ἐνδεδυμένον ἔνδυμα γάμου· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","καὶ λέγει αὐτῷ· Ἑταῖρε, πῶς εἰσῆλθες ὧδε μὴ ἔχων ἔνδυμα γάμου; ὁ δὲ ἐφιμώθη. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","τότε ⸂ὁ βασιλεὺς εἶπεν τοῖς διακόνοις· Δήσαντες αὐτοῦ πόδας καὶ χεῖρας ⸂ἐκβάλετε αὐτὸν εἰς τὸ σκότος τὸ ἐξώτερον· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","πολλοὶ γάρ εἰσιν κλητοὶ ὀλίγοι δὲ ἐκλεκτοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Τότε πορευθέντες οἱ Φαρισαῖοι συμβούλιον ἔλαβον ὅπως αὐτὸν παγιδεύσωσιν ἐν λόγῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","καὶ ἀποστέλλουσιν αὐτῷ τοὺς μαθητὰς αὐτῶν μετὰ τῶν Ἡρῳδιανῶν ⸀λέγοντες Διδάσκαλε, οἴδαμεν ὅτι ἀληθὴς εἶ καὶ τὴν ὁδὸν τοῦ θεοῦ ἐν ἀληθείᾳ διδάσκεις, καὶ οὐ μέλει σοι περὶ οὐδενός, οὐ γὰρ βλέπεις εἰς πρόσωπον ἀνθρώπων· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","εἰπὸν οὖν ἡμῖν τί σοι δοκεῖ· ἔξεστιν δοῦναι κῆνσον Καίσαρι ἢ οὔ; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","γνοὺς δὲ ὁ Ἰησοῦς τὴν πονηρίαν αὐτῶν εἶπεν· Τί με πειράζετε, ὑποκριταί; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ἐπιδείξατέ μοι τὸ νόμισμα τοῦ κήνσου. οἱ δὲ προσήνεγκαν αὐτῷ δηνάριον. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","καὶ λέγει αὐτοῖς· Τίνος ἡ εἰκὼν αὕτη καὶ ἡ ἐπιγραφή; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","λέγουσιν ⸀αὐτῷ Καίσαρος. τότε λέγει αὐτοῖς· Ἀπόδοτε οὖν τὰ Καίσαρος Καίσαρι καὶ τὰ τοῦ θεοῦ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","καὶ ἀκούσαντες ἐθαύμασαν, καὶ ἀφέντες αὐτὸν ἀπῆλθαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ἐν ἐκείνῃ τῇ ἡμέρᾳ προσῆλθον αὐτῷ Σαδδουκαῖοι, ⸀λέγοντεςμὴ εἶναι ἀνάστασιν, καὶ ἐπηρώτησαν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","λέγοντες· Διδάσκαλε, Μωϋσῆς εἶπεν· Ἐάν τις ἀποθάνῃ μὴ ἔχων τέκνα, ἐπιγαμβρεύσει ὁ ἀδελφὸς αὐτοῦ τὴν γυναῖκα αὐτοῦ καὶ ἀναστήσει σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ἦσαν δὲ παρʼ ἡμῖν ἑπτὰ ἀδελφοί· καὶ ὁ πρῶτος ⸀γήμαςἐτελεύτησεν, καὶ μὴ ἔχων σπέρμα ἀφῆκεν τὴν γυναῖκα αὐτοῦ τῷ ἀδελφῷ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ὁμοίως καὶ ὁ δεύτερος καὶ ὁ τρίτος, ἕως τῶν ἑπτά· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ὕστερον δὲ πάντων ἀπέθανεν ⸀ἡγυνή. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ἐν τῇ ⸂ἀναστάσει οὖν τίνος τῶν ἑπτὰ ἔσται γυνή; πάντες γὰρ ἔσχον αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Πλανᾶσθε μὴ εἰδότες τὰς γραφὰς μηδὲ τὴν δύναμιν τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ἐν γὰρ τῇ ἀναστάσει οὔτε γαμοῦσιν οὔτε ⸀γαμίζονται ἀλλʼ ὡς ἄγγελοι ⸀θεοῦἐν ⸀τῷοὐρανῷ εἰσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","περὶ δὲ τῆς ἀναστάσεως τῶν νεκρῶν οὐκ ἀνέγνωτε τὸ ῥηθὲν ὑμῖν ὑπὸ τοῦ θεοῦ λέγοντος· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ἐγώ εἰμι ὁ θεὸςἈβραὰμ καὶ ὁ θεὸς Ἰσαὰκ καὶ ὁ θεὸς Ἰακώβ; οὐκ ἔστιν ⸂ὁ θεὸς⸃ νεκρῶν ἀλλὰ ζώντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","καὶ ἀκούσαντες οἱ ὄχλοι ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Οἱ δὲ Φαρισαῖοι ἀκούσαντες ὅτι ἐφίμωσεν τοὺς Σαδδουκαίους συνήχθησαν ἐπὶ τὸ αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","καὶ ἐπηρώτησεν εἷς ἐξ αὐτῶν νομικὸς πειράζων ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Διδάσκαλε, ποία ἐντολὴ μεγάλη ἐν τῷ νόμῳ; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ὁ ⸀δὲἔφη αὐτῷ· Ἀγαπήσεις κύριον τὸν θεόν σου ἐν ὅλῃ ⸀τῇκαρδίᾳ σου καὶ ἐν ὅλῃ ⸁τῇψυχῇ σου καὶ ἐν ὅλῃ τῇ διανοίᾳ σου· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","αὕτη ἐστὶν ⸂ἡ μεγάλη καὶ πρώτη ἐντολή. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Δευτέρα ⸀δὲὁμοία ⸀αὐτῇ Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ἐν ταύταις ταῖς δυσὶν ἐντολαῖς ὅλος ὁ νόμος ⸂κρέμαται καὶ οἱ προφῆται. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Συνηγμένων δὲ τῶν Φαρισαίων ἐπηρώτησεν αὐτοὺς ὁ Ἰησοῦς ");
INSERT INTO grcsbl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","λέγων· Τί ὑμῖν δοκεῖ περὶ τοῦ χριστοῦ; τίνος υἱός ἐστιν; λέγουσιν αὐτῷ· Τοῦ Δαυίδ. ");
INSERT INTO grcsbl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","λέγει αὐτοῖς· Πῶς οὖν Δαυὶδ ἐν πνεύματι ⸂καλεῖ αὐτὸν κύριον λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","⸀Εἶπενκύριος τῷ κυρίῳ μου· Κάθου ἐκ δεξιῶν μου ἕως ἂν θῶ τοὺς ἐχθρούς σου ⸀ὑποκάτωτῶν ποδῶν σου; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","εἰ οὖν Δαυὶδ καλεῖ αὐτὸν κύριον, πῶς υἱὸς αὐτοῦ ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","καὶ οὐδεὶς ἐδύνατο ⸂ἀποκριθῆναι αὐτῷ λόγον, οὐδὲ ἐτόλμησέν τις ἀπʼ ἐκείνης τῆς ἡμέρας ἐπερωτῆσαι αὐτὸν οὐκέτι. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Τότε ὁ Ἰησοῦς ἐλάλησεν τοῖς ὄχλοις καὶ τοῖς μαθηταῖς αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","λέγων· Ἐπὶ τῆς Μωϋσέως καθέδρας ἐκάθισαν οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","πάντα οὖν ὅσα ⸀ἐὰνεἴπωσιν ὑμῖν ⸂ποιήσατε καὶ τηρεῖτε, κατὰ δὲ τὰ ἔργα αὐτῶν μὴ ποιεῖτε, λέγουσιν γὰρ καὶ οὐ ποιοῦσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","δεσμεύουσιν ⸀δὲφορτία ⸀βαρέακαὶ ἐπιτιθέασιν ἐπὶ τοὺς ὤμους τῶν ἀνθρώπων, ⸂αὐτοὶ δὲ τῷ δακτύλῳ αὐτῶν οὐ θέλουσιν κινῆσαι αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","πάντα δὲ τὰ ἔργα αὐτῶν ποιοῦσιν πρὸς τὸ θεαθῆναι τοῖς ἀνθρώποις· πλατύνουσι ⸀γὰρτὰ φυλακτήρια αὐτῶν καὶ μεγαλύνουσι τὰ ⸀κράσπεδα ");
INSERT INTO grcsbl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","φιλοῦσι ⸀δὲτὴν πρωτοκλισίαν ἐν τοῖς δείπνοις καὶ τὰς πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς ");
INSERT INTO grcsbl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","καὶ τοὺς ἀσπασμοὺς ἐν ταῖς ἀγοραῖς καὶ καλεῖσθαι ὑπὸ τῶν ἀνθρώπων· ⸀Ῥαββί ");
INSERT INTO grcsbl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ὑμεῖς δὲ μὴ κληθῆτε· Ῥαββί, εἷς γάρ ἐστιν ὑμῶν ὁ ⸀διδάσκαλος πάντες δὲ ὑμεῖς ἀδελφοί ἐστε· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","καὶ πατέρα μὴ καλέσητε ὑμῶν ἐπὶ τῆς γῆς, εἷς γάρ ἐστιν ⸂ὑμῶν ὁ πατὴρ ὁ ⸀οὐράνιος ");
INSERT INTO grcsbl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","μηδὲ κληθῆτε καθηγηταί, ⸂ὅτι καθηγητὴς ὑμῶν ἐστιν εἷς ὁ χριστός· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ὁ δὲ μείζων ὑμῶν ἔσται ὑμῶν διάκονος. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ὅστις δὲ ὑψώσει ἑαυτὸν ταπεινωθήσεται, καὶ ὅστις ταπεινώσει ἑαυτὸν ⸀ὑψωθήσεται ");
INSERT INTO grcsbl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Οὐαὶ ⸀δὲὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι κλείετε τὴν βασιλείαν τῶν οὐρανῶν ἔμπροσθεν τῶν ἀνθρώπων· ὑμεῖς γὰρ οὐκ εἰσέρχεσθε, οὐδὲ τοὺς εἰσερχομένους ἀφίετε ⸀εἰσελθεῖν ");
INSERT INTO grcsbl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι περιάγετε τὴν θάλασσαν καὶ τὴν ξηρὰν ποιῆσαι ἕνα προσήλυτον, καὶ ὅταν γένηται ποιεῖτε αὐτὸν υἱὸν γεέννης διπλότερον ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Οὐαὶ ὑμῖν, ὁδηγοὶ τυφλοὶ οἱ λέγοντες· Ὃς ἂν ὀμόσῃ ἐν τῷ ναῷ, οὐδέν ἐστιν, ὃς δʼ ἂν ὀμόσῃ ἐν τῷ χρυσῷ τοῦ ναοῦ ὀφείλει. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","μωροὶ καὶ τυφλοί, τίς γὰρ μείζων ἐστίν, ὁ χρυσὸς ἢ ὁ ναὸς ὁ ⸀ἁγιάσαςτὸν χρυσόν; ");
INSERT INTO grcsbl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","καί· Ὃς ⸀ἂνὀμόσῃ ἐν τῷ θυσιαστηρίῳ, οὐδέν ἐστιν, ὃς δʼ ἂν ὀμόσῃ ἐν τῷ δώρῳ τῷ ἐπάνω αὐτοῦ ὀφείλει. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","⸀τυφλοί τί γὰρ μεῖζον, τὸ δῶρον ἢ τὸ θυσιαστήριον τὸ ἁγιάζον τὸ δῶρον; ");
INSERT INTO grcsbl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ὁ οὖν ὀμόσας ἐν τῷ θυσιαστηρίῳ ὀμνύει ἐν αὐτῷ καὶ ἐν πᾶσι τοῖς ἐπάνω αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","καὶ ὁ ὀμόσας ἐν τῷ ναῷ ὀμνύει ἐν αὐτῷ καὶ ἐν τῷ ⸀κατοικοῦντιαὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","καὶ ὁ ὀμόσας ἐν τῷ οὐρανῷ ὀμνύει ἐν τῷ θρόνῳ τοῦ θεοῦ καὶ ἐν τῷ καθημένῳ ἐπάνω αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι ἀποδεκατοῦτε τὸ ἡδύοσμον καὶ τὸ ἄνηθον καὶ τὸ κύμινον, καὶ ἀφήκατε τὰ βαρύτερα τοῦ νόμου, τὴν κρίσιν καὶ ⸂τὸ ἔλεος καὶ τὴν πίστιν· ⸀ταῦταἔδει ποιῆσαι κἀκεῖνα μὴ ⸀ἀφιέναι ");
INSERT INTO grcsbl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ὁδηγοὶ τυφλοί, ⸀οἱδιϋλίζοντες τὸν κώνωπα τὴν δὲ κάμηλον καταπίνοντες. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι καθαρίζετε τὸ ἔξωθεν τοῦ ποτηρίου καὶ τῆς παροψίδος, ἔσωθεν δὲ γέμουσιν ἐξ ἁρπαγῆς καὶ ⸀ἀκρασίας ");
INSERT INTO grcsbl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Φαρισαῖε τυφλέ, καθάρισον πρῶτον τὸ ἐντὸς τοῦ ποτηρίου ⸂καὶ τῆς παροψίδος, ἵνα γένηται καὶ τὸ ἐκτὸς ⸀αὐτοῦκαθαρόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι ⸀παρομοιάζετετάφοις κεκονιαμένοις, οἵτινες ἔξωθεν μὲν φαίνονται ὡραῖοι ἔσωθεν δὲ γέμουσιν ὀστέων νεκρῶν καὶ πάσης ἀκαθαρσίας· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","οὕτως καὶ ὑμεῖς ἔξωθεν μὲν φαίνεσθε τοῖς ἀνθρώποις δίκαιοι, ἔσωθεν δέ ⸂ἐστε μεστοὶ ὑποκρίσεως καὶ ἀνομίας. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Οὐαὶ ὑμῖν, γραμματεῖς καὶ Φαρισαῖοι ὑποκριταί, ὅτι οἰκοδομεῖτε τοὺς τάφους τῶν προφητῶν καὶ κοσμεῖτε τὰ μνημεῖα τῶν δικαίων, ");
INSERT INTO grcsbl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","καὶ λέγετε· Εἰ ⸀ἤμεθαἐν ταῖς ἡμέραις τῶν πατέρων ἡμῶν, οὐκ ἂν ⸁ἤμεθα⸂αὐτῶν κοινωνοὶ ἐν τῷ αἵματι τῶν προφητῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ὥστε μαρτυρεῖτε ἑαυτοῖς ὅτι υἱοί ἐστε τῶν φονευσάντων τοὺς προφήτας. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","καὶ ὑμεῖς πληρώσατε τὸ μέτρον τῶν πατέρων ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ὄφεις γεννήματα ἐχιδνῶν, πῶς φύγητε ἀπὸ τῆς κρίσεως τῆς γεέννης; ");
INSERT INTO grcsbl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","διὰ τοῦτο ἰδοὺ ἐγὼ ἀποστέλλω πρὸς ὑμᾶς προφήτας καὶ σοφοὺς καὶ γραμματεῖς· ⸀ἐξαὐτῶν ἀποκτενεῖτε καὶ σταυρώσετε, καὶ ἐξ αὐτῶν μαστιγώσετε ἐν ταῖς συναγωγαῖς ὑμῶν καὶ διώξετε ἀπὸ πόλεως εἰς πόλιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ὅπως ἔλθῃ ἐφʼ ὑμᾶς πᾶν αἷμα δίκαιον ἐκχυννόμενον ἐπὶ τῆς γῆς ἀπὸ τοῦ αἵματος Ἅβελ τοῦ δικαίου ἕως τοῦ αἵματος Ζαχαρίου υἱοῦ Βαραχίου, ὃν ἐφονεύσατε μεταξὺ τοῦ ναοῦ καὶ τοῦ θυσιαστηρίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ἀμὴν λέγω ὑμῖν, ⸀ἥξει⸂ταῦτα πάντα ἐπὶ τὴν γενεὰν ταύτην. ");
INSERT INTO grcsbl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ἰερουσαλὴμ Ἰερουσαλήμ, ἡ ⸀ἀποκτείνουσατοὺς προφήτας καὶ λιθοβολοῦσα τοὺς ἀπεσταλμένους πρὸς αὐτήν— ποσάκις ἠθέλησα ἐπισυναγαγεῖν τὰ τέκνα σου, ὃν τρόπον ⸂ὄρνις ἐπισυνάγει τὰ νοσσία ⸀αὐτῆςὑπὸ τὰς πτέρυγας, καὶ οὐκ ἠθελήσατε; ");
INSERT INTO grcsbl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ἰδοὺ ἀφίεται ὑμῖν ὁ οἶκος ὑμῶν ⸀ἔρημος ");
INSERT INTO grcsbl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","λέγω γὰρ ὑμῖν, οὐ μή με ἴδητε ἀπʼ ἄρτι ἕως ἂν εἴπητε· Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Καὶ ἐξελθὼν ὁ Ἰησοῦς ⸂ἀπὸ τοῦ ἱεροῦ ἐπορεύετο, καὶ προσῆλθον οἱ μαθηταὶ αὐτοῦ ἐπιδεῖξαι αὐτῷ τὰς οἰκοδομὰς τοῦ ἱεροῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ὁ δὲ ⸀ἀποκριθεὶςεἶπεν αὐτοῖς· Οὐ βλέπετε ⸂ταῦτα πάντα; ἀμὴν λέγω ὑμῖν, οὐ μὴ ἀφεθῇ ὧδε λίθος ἐπὶ λίθον ὃς οὐ καταλυθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Καθημένου δὲ αὐτοῦ ἐπὶ τοῦ Ὄρους τῶν Ἐλαιῶν προσῆλθον αὐτῷ οἱ μαθηταὶ κατʼ ἰδίαν λέγοντες· Εἰπὸν ἡμῖν πότε ταῦτα ἔσται, καὶτί τὸ σημεῖον τῆς σῆς παρουσίας ⸀καὶ συντελείας τοῦ αἰῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς· Βλέπετε μή τις ὑμᾶς πλανήσῃ· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","πολλοὶ γὰρ ἐλεύσονται ἐπὶ τῷ ὀνόματί μου λέγοντες· Ἐγώ εἰμι ὁ χριστός, καὶ πολλοὺς πλανήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","μελλήσετε δὲ ἀκούειν πολέμους καὶ ἀκοὰς πολέμων· ὁρᾶτε, μὴ θροεῖσθε· δεῖ ⸀γὰργενέσθαι, ἀλλʼ οὔπω ἐστὶν τὸ τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ἐγερθήσεται γὰρ ἔθνος ἐπὶ ἔθνος καὶ βασιλεία ἐπὶ βασιλείαν, καὶ ἔσονται ⸀λιμοὶκαὶ σεισμοὶ κατὰ τόπους· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","πάντα δὲ ταῦτα ἀρχὴ ὠδίνων. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Τότε παραδώσουσιν ὑμᾶς εἰς θλῖψιν καὶ ἀποκτενοῦσιν ὑμᾶς, καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων τῶν ἐθνῶν διὰ τὸ ὄνομά μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","καὶ τότε σκανδαλισθήσονται πολλοὶ καὶ ἀλλήλους παραδώσουσιν καὶ μισήσουσιν ἀλλήλους· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","καὶ πολλοὶ ψευδοπροφῆται ἐγερθήσονται καὶ πλανήσουσιν πολλούς· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","καὶ διὰ τὸ πληθυνθῆναι τὴν ἀνομίαν ψυγήσεται ἡ ἀγάπη τῶν πολλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ὁ δὲ ὑπομείνας εἰς τέλος οὗτος σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","καὶ κηρυχθήσεται τοῦτο τὸ εὐαγγέλιον τῆς βασιλείας ἐν ὅλῃ τῇ οἰκουμένῃ εἰς μαρτύριον πᾶσιν τοῖς ἔθνεσιν, καὶ τότε ἥξει τὸ τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ὅταν οὖν ἴδητε τὸ βδέλυγμα τῆς ἐρημώσεως τὸ ῥηθὲν διὰ Δανιὴλ τοῦ προφήτου ⸀ἑστὸςἐν τόπῳ ἁγίῳ, ὁ ἀναγινώσκων νοείτω, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν ⸀ἐπὶτὰ ὄρη, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ὁ ἐπὶ τοῦ δώματος μὴ ⸀καταβάτωἆραι τὰ ἐκ τῆς οἰκίας αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","καὶ ὁ ἐν τῷ ἀγρῷ μὴ ἐπιστρεψάτω ὀπίσω ἆραι ⸂τὸ ἱμάτιον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","οὐαὶ δὲ ταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","προσεύχεσθε δὲ ἵνα μὴ γένηται ἡ φυγὴ ὑμῶν χειμῶνος μηδὲ σαββάτῳ· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ἔσται γὰρ τότε θλῖψις μεγάλη οἵα οὐ γέγονεν ἀπʼ ἀρχῆς κόσμου ἕως τοῦ νῦν οὐδʼ οὐ μὴ γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","καὶ εἰ μὴ ἐκολοβώθησαν αἱ ἡμέραι ἐκεῖναι, οὐκ ἂν ἐσώθη πᾶσα σάρξ· διὰ δὲ τοὺς ἐκλεκτοὺς κολοβωθήσονται αἱ ἡμέραι ἐκεῖναι. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","τότε ἐάν τις ὑμῖν εἴπῃ· Ἰδοὺ ὧδε ὁ χριστός, ἤ· Ὧδε, μὴ πιστεύσητε· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ἐγερθήσονται γὰρ ψευδόχριστοι καὶ ψευδοπροφῆται, καὶ δώσουσιν σημεῖα μεγάλα καὶ τέρατα ὥστε ⸀πλανῆσαιεἰ δυνατὸν καὶ τοὺς ἐκλεκτούς· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ἰδοὺ προείρηκα ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ἐὰν οὖν εἴπωσιν ὑμῖν· Ἰδοὺ ἐν τῇ ἐρήμῳ ἐστίν, μὴ ἐξέλθητε· Ἰδοὺ ἐν τοῖς ταμείοις, μὴ πιστεύσητε· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ὥσπερ γὰρ ἡ ἀστραπὴ ἐξέρχεται ἀπὸ ἀνατολῶν καὶ φαίνεται ἕως δυσμῶν, οὕτως ⸀ἔσταιἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","⸀ὅπουἐὰν ᾖ τὸ πτῶμα, ἐκεῖ συναχθήσονται οἱ ἀετοί. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Εὐθέως δὲ μετὰ τὴν θλῖψιν τῶν ἡμερῶν ἐκείνων ὁ ἥλιος σκοτισθήσεται, καὶ ἡ σελήνη οὐ δώσει τὸ φέγγος αὐτῆς, καὶ οἱ ἀστέρες πεσοῦνται ἀπὸ τοῦ οὐρανοῦ, καὶ αἱ δυνάμεις τῶν οὐρανῶν σαλευθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","καὶ τότε φανήσεται τὸ σημεῖον τοῦ υἱοῦ τοῦ ἀνθρώπου ἐν ⸀τῷοὐρανῷ, καὶ τότε κόψονται πᾶσαι αἱ φυλαὶ τῆς γῆς καὶ ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐπὶ τῶν νεφελῶν τοῦ οὐρανοῦ μετὰ δυνάμεως καὶ δόξης πολλῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","καὶ ἀποστελεῖ τοὺς ἀγγέλους αὐτοῦ μετὰ ⸀σάλπιγγοςμεγάλης, καὶ ἐπισυνάξουσιν τοὺς ἐκλεκτοὺς αὐτοῦ ἐκ τῶντεσσάρων ἀνέμων ἀπʼ ἄκρων οὐρανῶν ἕως ⸀τῶν ἄκρων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ἀπὸ δὲ τῆς συκῆς μάθετε τὴν παραβολήν· ὅταν ἤδη ὁ κλάδος αὐτῆς γένηται ἁπαλὸς καὶ τὰ φύλλα ἐκφύῃ, γινώσκετε ὅτι ἐγγὺς τὸ θέρος· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","οὕτως καὶ ὑμεῖς, ὅταν ἴδητε ⸂πάντα ταῦτα, γινώσκετε ὅτι ἐγγύς ἐστιν ἐπὶ θύραις. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ἀμὴν λέγω ὑμῖν ⸀ὅτιοὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη ἕως ἂν πάντα ταῦτα γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ὁ οὐρανὸς καὶ ἡ γῆ ⸀παρελεύσεται οἱ δὲ λόγοι μου οὐ μὴ παρέλθωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Περὶ δὲ τῆς ἡμέρας ἐκείνης καὶ ὥρας οὐδεὶς οἶδεν, οὐδὲ οἱ ἄγγελοι τῶν οὐρανῶν ⸂οὐδὲ ὁ υἱός, εἰ μὴ ὁ ⸀πατὴρμόνος. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ὥσπερ ⸀γὰραἱ ἡμέραι τοῦ Νῶε, οὕτως ⸀ἔσταιἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⸀ὡςγὰρ ἦσαν ἐν ταῖς ⸀ἡμέραιςταῖς πρὸ τοῦ κατακλυσμοῦ τρώγοντες καὶ πίνοντες, γαμοῦντες καὶ ⸀γαμίζοντες ἄχρι ἧς ἡμέρας εἰσῆλθεν Νῶε εἰς τὴν κιβωτόν, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","καὶοὐκ ἔγνωσαν ἕως ἦλθεν ὁ κατακλυσμὸς καὶ ἦρεν ἅπαντας, οὕτως ἔσται ⸀καὶ ἡ παρουσία τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","τότε ⸂δύο ἔσονται ἐν τῷ ἀγρῷ, ⸀εἷςπαραλαμβάνεται καὶ ⸁εἷςἀφίεται· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","δύο ἀλήθουσαι ἐν τῷ ⸀μύλῳ μία παραλαμβάνεται καὶ μία ἀφίεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","γρηγορεῖτε οὖν, ὅτι οὐκ οἴδατε ποίᾳ ⸀ἡμέρᾳὁ κύριος ὑμῶν ἔρχεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ἐκεῖνο δὲ γινώσκετε ὅτι εἰ ᾔδει ὁ οἰκοδεσπότης ποίᾳ φυλακῇ ὁ κλέπτης ἔρχεται, ἐγρηγόρησεν ἂν καὶ οὐκ ἂν εἴασεν διορυχθῆναι τὴν οἰκίαν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","διὰ τοῦτο καὶ ὑμεῖς γίνεσθε ἕτοιμοι, ὅτι ᾗ ⸂οὐ δοκεῖτε ὥρᾳ ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεται. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Τίς ἄρα ἐστὶν ὁ πιστὸς δοῦλος καὶ φρόνιμος ὃν κατέστησεν ὁ ⸀κύριοςἐπὶ τῆς ⸀οἰκετείαςαὐτοῦ τοῦ ⸀δοῦναιαὐτοῖς τὴν τροφὴν ἐν καιρῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","μακάριος ὁ δοῦλος ἐκεῖνος ὃν ἐλθὼν ὁ κύριος αὐτοῦ εὑρήσει ⸂οὕτως ποιοῦντα· ");
INSERT INTO grcsbl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ἀμὴν λέγω ὑμῖν ὅτι ἐπὶ πᾶσιν τοῖς ὑπάρχουσιν αὐτοῦ καταστήσει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ἐὰν δὲ εἴπῃ ὁ κακὸς δοῦλος ἐκεῖνος ἐν τῇ καρδίᾳ αὐτοῦ· Χρονίζει ⸂μου ὁ κύριος, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","καὶ ἄρξηται τύπτειν τοὺς συνδούλους ⸂αὐτοῦ, ἐσθίῃ δὲ καὶ πίνῃ⸃ μετὰ τῶν μεθυόντων, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ἥξει ὁ κύριος τοῦ δούλου ἐκείνου ἐν ἡμέρᾳ ᾗ οὐ προσδοκᾷ καὶ ἐν ὥρᾳ ᾗ οὐ γινώσκει, ");
INSERT INTO grcsbl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","καὶ διχοτομήσει αὐτὸν καὶ τὸ μέρος αὐτοῦ μετὰ τῶν ὑποκριτῶν θήσει· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Τότε ὁμοιωθήσεται ἡ βασιλεία τῶν οὐρανῶν δέκα παρθένοις, αἵτινες λαβοῦσαι τὰς λαμπάδας ⸀ἑαυτῶνἐξῆλθον εἰς ⸀ὑπάντησιντοῦ νυμφίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","πέντε δὲ ⸂ἐξ αὐτῶν ἦσαν ⸂μωραὶ καὶ πέντε φρόνιμοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","⸂αἱ γὰρ μωραὶ λαβοῦσαι τὰς λαμπάδας αὐτῶν οὐκ ἔλαβον μεθʼ ἑαυτῶν ἔλαιον· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","αἱ δὲ φρόνιμοι ἔλαβον ἔλαιον ἐν τοῖς ⸀ἀγγείοιςμετὰ τῶν λαμπάδων ⸀ἑαυτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","χρονίζοντος δὲ τοῦ νυμφίου ἐνύσταξαν πᾶσαι καὶ ἐκάθευδον. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","μέσης δὲ νυκτὸς κραυγὴ γέγονεν· Ἰδοὺ ὁ ⸀νυμφίος ἐξέρχεσθε εἰς ἀπάντησιν ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","τότε ἠγέρθησαν πᾶσαι αἱ παρθένοι ἐκεῖναι καὶ ἐκόσμησαν τὰς λαμπάδας ⸀ἑαυτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","αἱ δὲ μωραὶ ταῖς φρονίμοις εἶπαν· Δότε ἡμῖν ἐκ τοῦ ἐλαίου ὑμῶν, ὅτι αἱ λαμπάδες ἡμῶν σβέννυνται. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ἀπεκρίθησαν δὲ αἱ φρόνιμοι λέγουσαι· Μήποτε ⸂οὐ μὴ ἀρκέσῃ ἡμῖν καὶ ὑμῖν· ⸀πορεύεσθεμᾶλλον πρὸς τοὺς πωλοῦντας καὶ ἀγοράσατε ἑαυταῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ἀπερχομένων δὲ αὐτῶν ἀγοράσαι ἦλθεν ὁ νυμφίος, καὶ αἱ ἕτοιμοι εἰσῆλθον μετʼ αὐτοῦ εἰς τοὺς γάμους, καὶ ἐκλείσθη ἡ θύρα. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ὕστερον δὲ ἔρχονται καὶ αἱ λοιπαὶ παρθένοι λέγουσαι· Κύριε κύριε, ἄνοιξον ἡμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ὁ δὲ ἀποκριθεὶς εἶπεν· Ἀμὴν λέγω ὑμῖν, οὐκ οἶδα ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","γρηγορεῖτε οὖν, ὅτι οὐκ οἴδατε τὴν ἡμέραν οὐδὲ τὴν ⸀ὥραν ");
INSERT INTO grcsbl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ὥσπερ γὰρ ἄνθρωπος ἀποδημῶν ἐκάλεσεν τοὺς ἰδίους δούλους καὶ παρέδωκεν αὐτοῖς τὰ ὑπάρχοντα αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","καὶ ᾧ μὲν ἔδωκεν πέντε τάλαντα ᾧ δὲ δύο ᾧ δὲ ἕν, ἑκάστῳ κατὰ τὴν ἰδίαν δύναμιν, καὶ ἀπεδήμησεν. εὐθέως ");
INSERT INTO grcsbl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","⸀πορευθεὶςὁ τὰ πέντε τάλαντα λαβὼν ἠργάσατο ἐν αὐτοῖς καὶ ⸀ἐκέρδησενἄλλα ⸀πέντε ");
INSERT INTO grcsbl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","⸀ὡσαύτωςὁ τὰ δύο ⸀ἐκέρδησενἄλλα δύο· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ὁ δὲ τὸ ἓν λαβὼν ἀπελθὼν ὤρυξεν ⸀γῆνκαὶ ⸀ἔκρυψεντὸ ἀργύριον τοῦ κυρίου αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","μετὰ δὲ ⸂πολὺν χρόνον ἔρχεται ὁ κύριος τῶν δούλων ἐκείνων καὶ συναίρει ⸂λόγον μετʼ αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","καὶ προσελθὼν ὁ τὰ πέντε τάλαντα λαβὼν προσήνεγκεν ἄλλα πέντε τάλαντα λέγων· Κύριε, πέντε τάλαντά μοι παρέδωκας· ἴδε ἄλλα πέντε τάλαντα ⸀ἐκέρδησα ");
INSERT INTO grcsbl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","⸀ἔφηαὐτῷ ὁ κύριος αὐτοῦ· Εὖ, δοῦλε ἀγαθὲ καὶ πιστέ, ἐπὶ ὀλίγα ἦς πιστός, ἐπὶ πολλῶν σε καταστήσω· εἴσελθε εἰς τὴν χαρὰν τοῦ κυρίου σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","προσελθὼν ⸀δὲκαὶ ὁ τὰ δύο ⸀τάλανταεἶπεν· Κύριε, δύο τάλαντά μοι παρέδωκας· ἴδε ἄλλα δύο τάλαντα ⸀ἐκέρδησα ");
INSERT INTO grcsbl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ἔφη αὐτῷ ὁ κύριος αὐτοῦ· Εὖ, δοῦλε ἀγαθὲ καὶ πιστέ, ἐπὶ ὀλίγα ἦς πιστός, ἐπὶ πολλῶν σε καταστήσω· εἴσελθε εἰς τὴν χαρὰν τοῦ κυρίου σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","προσελθὼν δὲ καὶ ὁ τὸ ἓν τάλαντον εἰληφὼς εἶπεν· Κύριε, ἔγνων σε ὅτι σκληρὸς εἶ ἄνθρωπος, θερίζων ὅπου οὐκ ἔσπειρας καὶ συνάγων ὅθεν οὐ διεσκόρπισας· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","καὶ φοβηθεὶς ἀπελθὼν ἔκρυψα τὸ τάλαντόν σου ἐν τῇ γῇ· ἴδε ἔχεις τὸ σόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ἀποκριθεὶς δὲ ὁ κύριος αὐτοῦ εἶπεν αὐτῷ· Πονηρὲ δοῦλε καὶ ὀκνηρέ, ᾔδεις ὅτι θερίζω ὅπου οὐκ ἔσπειρα καὶ συνάγω ὅθεν οὐ διεσκόρπισα; ");
INSERT INTO grcsbl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ἔδει ⸂σε οὖν βαλεῖν ⸂τὰ ἀργύριά μου τοῖς τραπεζίταις, καὶ ἐλθὼν ἐγὼ ἐκομισάμην ἂν τὸ ἐμὸν σὺν τόκῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ἄρατε οὖν ἀπʼ αὐτοῦ τὸ τάλαντον καὶ δότε τῷ ἔχοντι τὰ δέκα τάλαντα· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","τῷ γὰρ ἔχοντι παντὶ δοθήσεται καὶ περισσευθήσεται· ⸂τοῦ δὲ μὴ ἔχοντος καὶ ὃ ἔχει ἀρθήσεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","καὶ τὸν ἀχρεῖον δοῦλον ἐκβάλετε εἰς τὸ σκότος τὸ ἐξώτερον· ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ὅταν δὲ ἔλθῃ ὁ υἱὸς τοῦ ἀνθρώπου ἐν τῇ δόξῃ αὐτοῦ καὶ πάντες ⸀οἱἄγγελοι μετʼ αὐτοῦ, τότε καθίσει ἐπὶ θρόνου δόξης αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","καὶ ⸀συναχθήσονταιἔμπροσθεν αὐτοῦ πάντα τὰ ἔθνη, καὶ ἀφορίσει αὐτοὺς ἀπʼ ἀλλήλων, ὥσπερ ὁ ποιμὴν ἀφορίζει τὰ πρόβατα ἀπὸ τῶν ἐρίφων, ");
INSERT INTO grcsbl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","καὶ στήσει τὰ μὲν πρόβατα ἐκ δεξιῶν αὐτοῦ τὰ δὲ ἐρίφια ἐξ εὐωνύμων. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","τότε ἐρεῖ ὁ βασιλεὺς τοῖς ἐκ δεξιῶν αὐτοῦ· Δεῦτε, οἱ εὐλογημένοι τοῦ πατρός μου, κληρονομήσατε τὴν ἡτοιμασμένην ὑμῖν βασιλείαν ἀπὸ καταβολῆς κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ἐπείνασα γὰρ καὶ ἐδώκατέ μοι φαγεῖν, ἐδίψησα καὶ ἐποτίσατέ με, ξένος ἤμην καὶ συνηγάγετέ με, ");
INSERT INTO grcsbl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","γυμνὸς καὶ περιεβάλετέ με, ἠσθένησα καὶ ἐπεσκέψασθέ με, ἐν φυλακῇ ἤμην καὶ ἤλθατε πρός με. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","τότε ἀποκριθήσονται αὐτῷ οἱ δίκαιοι λέγοντες· Κύριε, πότε σε εἴδομεν πεινῶντα καὶ ἐθρέψαμεν, ἢ διψῶντα καὶ ἐποτίσαμεν; ");
INSERT INTO grcsbl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","πότε δέ σε εἴδομεν ξένον καὶ συνηγάγομεν, ἢ γυμνὸν καὶ περιεβάλομεν; ");
INSERT INTO grcsbl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","πότε δέ σε εἴδομεν ⸀ἀσθενοῦνταἢ ἐν φυλακῇ καὶ ἤλθομεν πρός σε; ");
INSERT INTO grcsbl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","καὶ ἀποκριθεὶς ὁ βασιλεὺς ἐρεῖ αὐτοῖς· Ἀμὴν λέγω ὑμῖν, ἐφʼ ὅσον ἐποιήσατε ἑνὶ τούτων τῶν ἀδελφῶν μου τῶν ἐλαχίστων, ἐμοὶ ἐποιήσατε. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","τότε ἐρεῖ καὶ τοῖς ἐξ εὐωνύμων· Πορεύεσθε ἀπʼ ἐμοῦ ⸀οἱκατηραμένοι εἰς τὸ πῦρ τὸ αἰώνιον τὸ ἡτοιμασμένον τῷ διαβόλῳ καὶ τοῖς ἀγγέλοις αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ἐπείνασα γὰρ καὶ οὐκ ἐδώκατέ μοι φαγεῖν, ⸀ἐδίψησακαὶ οὐκ ἐποτίσατέ με, ");
INSERT INTO grcsbl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ξένος ἤμην καὶ οὐ συνηγάγετέ με, γυμνὸς καὶ οὐ περιεβάλετέ με, ἀσθενὴς καὶ ἐν φυλακῇ καὶ οὐκ ἐπεσκέψασθέ με. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","τότε ἀποκριθήσονται καὶ αὐτοὶ λέγοντες· Κύριε, πότε σε εἴδομεν πεινῶντα ἢ διψῶντα ἢ ξένον ἢ γυμνὸν ἢ ἀσθενῆ ἢ ἐν φυλακῇ καὶ οὐ διηκονήσαμέν σοι; ");
INSERT INTO grcsbl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","τότε ἀποκριθήσεται αὐτοῖς λέγων· Ἀμὴν λέγω ὑμῖν, ἐφʼ ὅσον οὐκ ἐποιήσατε ἑνὶ τούτων τῶν ἐλαχίστων, οὐδὲ ἐμοὶ ἐποιήσατε. ");
INSERT INTO grcsbl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","καὶ ἀπελεύσονται οὗτοι εἰς κόλασιν αἰώνιον, οἱ δὲ δίκαιοι εἰς ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Καὶ ἐγένετο ὅτε ἐτέλεσεν ὁ Ἰησοῦς πάντας τοὺς λόγους τούτους, εἶπεν τοῖς μαθηταῖς αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Οἴδατε ὅτι μετὰ δύο ἡμέρας τὸ πάσχα γίνεται, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς τὸ σταυρωθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Τότε συνήχθησαν οἱ ⸀ἀρχιερεῖςκαὶ οἱ πρεσβύτεροι τοῦ λαοῦ εἰς τὴν αὐλὴν τοῦ ἀρχιερέως τοῦ λεγομένου Καϊάφα, ");
INSERT INTO grcsbl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","καὶ συνεβουλεύσαντο ἵνα τὸν Ἰησοῦν δόλῳ κρατήσωσιν καὶ ἀποκτείνωσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ἔλεγον δέ· Μὴ ἐν τῇ ἑορτῇ, ἵνα μὴ θόρυβος γένηται ἐν τῷ λαῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Τοῦ δὲ Ἰησοῦ γενομένου ἐν Βηθανίᾳ ἐν οἰκίᾳ Σίμωνος τοῦ λεπροῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","προσῆλθεν αὐτῷ γυνὴ ⸂ἔχουσα ἀλάβαστρον μύρου βαρυτίμου καὶ κατέχεεν ἐπὶ ⸂τῆς κεφαλῆς αὐτοῦ ἀνακειμένου. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ἰδόντες δὲ οἱ ⸀μαθηταὶἠγανάκτησαν λέγοντες· Εἰς τί ἡ ἀπώλεια αὕτη; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ἐδύνατο γὰρ ⸀τοῦτοπραθῆναι πολλοῦ καὶ δοθῆναι πτωχοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","γνοὺς δὲ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Τί κόπους παρέχετε τῇ γυναικί; ἔργον γὰρ καλὸν ἠργάσατο εἰς ἐμέ· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","πάντοτε γὰρ τοὺς πτωχοὺς ἔχετε μεθʼ ἑαυτῶν, ἐμὲ δὲ οὐ πάντοτε ἔχετε· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","βαλοῦσα γὰρ αὕτη τὸ μύρον τοῦτο ἐπὶ τοῦ σώματός μου πρὸς τὸ ἐνταφιάσαι με ἐποίησεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ἀμὴν λέγω ὑμῖν, ὅπου ἐὰν κηρυχθῇ τὸ εὐαγγέλιον τοῦτο ἐν ὅλῳ τῷ κόσμῳ, λαληθήσεται καὶ ὃ ἐποίησεν αὕτη εἰς μνημόσυνον αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Τότε πορευθεὶς εἷς τῶν δώδεκα, ὁ λεγόμενος Ἰούδας Ἰσκαριώτης, πρὸς τοὺς ἀρχιερεῖς ");
INSERT INTO grcsbl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","εἶπεν· Τί θέλετέ μοι δοῦναι κἀγὼ ὑμῖν παραδώσω αὐτόν; οἱ δὲ ἔστησαν αὐτῷ τριάκοντα ἀργύρια. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","καὶ ἀπὸ τότε ἐζήτει εὐκαιρίαν ἵνα αὐτὸν παραδῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Τῇ δὲ πρώτῃ τῶν ἀζύμων προσῆλθον οἱ μαθηταὶ τῷ Ἰησοῦ ⸀λέγοντες Ποῦ θέλεις ⸀ἑτοιμάσωμένσοι φαγεῖν τὸ πάσχα; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ὁ δὲ εἶπεν· Ὑπάγετε εἰς τὴν πόλιν πρὸς τὸν δεῖνα καὶ εἴπατε αὐτῷ· Ὁ διδάσκαλος λέγει· Ὁ καιρός μου ἐγγύς ἐστιν· πρὸς σὲ ποιῶ τὸ πάσχα μετὰ τῶν μαθητῶν μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","καὶ ἐποίησαν οἱ μαθηταὶ ὡς συνέταξεν αὐτοῖς ὁ Ἰησοῦς, καὶ ἡτοίμασαν τὸ πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ὀψίας δὲ γενομένης ἀνέκειτο μετὰ τῶν δώδεκα ⸀μαθητῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","καὶ ἐσθιόντων αὐτῶν εἶπεν· Ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","καὶ λυπούμενοι σφόδρα ἤρξαντο λέγειν αὐτῷ ⸂εἷς ἕκαστος· Μήτι ἐγώ εἰμι, κύριε; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ὁ δὲ ἀποκριθεὶς εἶπεν· Ὁ ἐμβάψας μετʼ ἐμοῦ ⸂τὴν χεῖρα ἐν τῷ τρυβλίῳ οὗτός με παραδώσει· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ὁ μὲν υἱὸς τοῦ ἀνθρώπου ὑπάγει καθὼς γέγραπται περὶ αὐτοῦ, οὐαὶ δὲ τῷ ἀνθρώπῳ ἐκείνῳ διʼ οὗ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται· καλὸν ἦν αὐτῷ εἰ οὐκ ἐγεννήθη ὁ ἄνθρωπος ἐκεῖνος. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ἀποκριθεὶς δὲ Ἰούδας ὁ παραδιδοὺς αὐτὸν εἶπεν· Μήτι ἐγώ εἰμι, ῥαββί; λέγει αὐτῷ· Σὺ εἶπας. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ἐσθιόντων δὲ αὐτῶν λαβὼν ὁ Ἰησοῦς ⸀ἄρτονκαὶ ⸀εὐλογήσαςἔκλασεν καὶ ⸂δοὺς τοῖς μαθηταῖς εἶπεν· Λάβετε φάγετε, τοῦτό ἐστιν τὸ σῶμά μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","καὶ ⸀λαβὼνποτήριον καὶ εὐχαριστήσας ἔδωκεν αὐτοῖς λέγων· Πίετε ἐξ αὐτοῦ πάντες, ");
INSERT INTO grcsbl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","τοῦτο γάρ ἐστιν τὸ αἷμά ⸀μου⸀τῆςδιαθήκης τὸ περὶ πολλῶν ἐκχυννόμενον εἰς ἄφεσιν ἁμαρτιῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","λέγω δὲ ⸀ὑμῖν οὐ μὴ πίω ἀπʼ ἄρτι ἐκ τούτου τοῦ γενήματος τῆς ἀμπέλου ἕως τῆς ἡμέρας ἐκείνης ὅταν αὐτὸ πίνω μεθʼ ὑμῶν καινὸν ἐν τῇ βασιλείᾳ τοῦ πατρός μου. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","καὶ ὑμνήσαντες ἐξῆλθον εἰς τὸ Ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Τότε λέγει αὐτοῖς ὁ Ἰησοῦς· Πάντες ὑμεῖς σκανδαλισθήσεσθε ἐν ἐμοὶ ἐν τῇ νυκτὶ ταύτῃ, γέγραπται γάρ· Πατάξω τὸν ποιμένα, καὶ ⸀διασκορπισθήσονταιτὰ πρόβατα τῆς ποίμνης· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","μετὰ δὲ τὸ ἐγερθῆναί με προάξω ὑμᾶς εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ἀποκριθεὶς δὲ ὁ Πέτρος εἶπεν αὐτῷ· Εἰ πάντες σκανδαλισθήσονται ἐν σοί, ⸀ἐγὼοὐδέποτε σκανδαλισθήσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ἔφη αὐτῷ ὁ Ἰησοῦς· Ἀμὴν λέγω σοι ὅτι ἐν ταύτῃ τῇ νυκτὶ πρὶν ἀλέκτορα φωνῆσαι τρὶς ἀπαρνήσῃ με. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","λέγει αὐτῷ ὁ Πέτρος· Κἂν δέῃ με σὺν σοὶ ἀποθανεῖν, οὐ μή σε ⸀ἀπαρνήσομαι ⸀ὁμοίωςκαὶ πάντες οἱ μαθηταὶ εἶπαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Τότε ἔρχεται μετʼ αὐτῶν ὁ Ἰησοῦς εἰς χωρίον λεγόμενον Γεθσημανί, καὶ λέγει τοῖς μαθηταῖς· Καθίσατε αὐτοῦ ἕως οὗ ἀπελθὼν ⸂ἐκεῖ προσεύξωμαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","καὶ παραλαβὼν τὸν Πέτρον καὶ τοὺς δύο υἱοὺς Ζεβεδαίου ἤρξατο λυπεῖσθαι καὶ ἀδημονεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","τότε λέγει ⸀αὐτοῖς Περίλυπός ἐστιν ἡ ψυχή μου ἕως θανάτου· μείνατε ὧδε καὶ γρηγορεῖτε μετʼ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","καὶ ⸀προελθὼνμικρὸν ἔπεσεν ἐπὶ πρόσωπον αὐτοῦ προσευχόμενος καὶ λέγων· Πάτερ μου, εἰ δυνατόν ἐστιν, παρελθάτω ἀπʼ ἐμοῦ τὸ ποτήριον τοῦτο· πλὴν οὐχ ὡς ἐγὼ θέλω ἀλλʼ ὡς σύ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","καὶ ἔρχεται πρὸς τοὺς μαθητὰς καὶ εὑρίσκει αὐτοὺς καθεύδοντας, καὶ λέγει τῷ Πέτρῳ· Οὕτως οὐκ ἰσχύσατε μίαν ὥραν γρηγορῆσαι μετʼ ἐμοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","γρηγορεῖτε καὶ προσεύχεσθε, ἵνα μὴ εἰσέλθητε εἰς πειρασμόν· τὸ μὲν πνεῦμα πρόθυμον ἡ δὲ σὰρξ ἀσθενής. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","πάλιν ἐκ δευτέρου ἀπελθὼν προσηύξατο λέγων· Πάτερ μου, εἰ οὐ δύναται ⸀τοῦτο⸀παρελθεῖνἐὰν μὴ αὐτὸ πίω, γενηθήτω τὸ θέλημά σου. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","καὶ ἐλθὼν ⸂πάλιν εὗρεν αὐτοὺς καθεύδοντας, ἦσαν γὰρ αὐτῶν οἱ ὀφθαλμοὶ βεβαρημένοι. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","καὶ ἀφεὶς αὐτοὺς ⸂πάλιν ἀπελθὼν προσηύξατο ἐκ τρίτου τὸν αὐτὸν λόγον εἰπὼν ⸀πάλιν ");
INSERT INTO grcsbl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","τότε ἔρχεται πρὸς τοὺς ⸀μαθητὰςκαὶ λέγει αὐτοῖς· Καθεύδετε ⸀τὸλοιπὸν καὶ ἀναπαύεσθε· ἰδοὺ ἤγγικεν ἡ ὥρα καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς χεῖρας ἁμαρτωλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ἐγείρεσθε ἄγωμεν· ἰδοὺ ἤγγικεν ὁ παραδιδούς με. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Καὶ ἔτι αὐτοῦ λαλοῦντος ἰδοὺ Ἰούδας εἷς τῶν δώδεκα ἦλθεν καὶ μετʼ αὐτοῦ ὄχλος πολὺς μετὰ μαχαιρῶν καὶ ξύλων ἀπὸ τῶν ἀρχιερέων καὶ πρεσβυτέρων τοῦ λαοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ὁ δὲ παραδιδοὺς αὐτὸν ἔδωκεν αὐτοῖς σημεῖον λέγων· Ὃν ἂν φιλήσω αὐτός ἐστιν· κρατήσατε αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","καὶ εὐθέως προσελθὼν τῷ Ἰησοῦ εἶπεν· Χαῖρε, ῥαββί· καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ· Ἑταῖρε, ἐφʼ ⸀ὃπάρει. τότε προσελθόντες ἐπέβαλον τὰς χεῖρας ἐπὶ τὸν Ἰησοῦν καὶ ἐκράτησαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","καὶ ἰδοὺ εἷς τῶν μετὰ Ἰησοῦ ἐκτείνας τὴν χεῖρα ἀπέσπασεν τὴν μάχαιραν αὐτοῦ καὶ πατάξας τὸν δοῦλον τοῦ ἀρχιερέως ἀφεῖλεν αὐτοῦ τὸ ὠτίον. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","τότε λέγει αὐτῷ ὁ Ἰησοῦς· Ἀπόστρεψον ⸂τὴν μάχαιράν σου εἰς τὸν τόπον αὐτῆς, πάντες γὰρ οἱ λαβόντες μάχαιραν ἐν μαχαίρῃ ⸀ἀπολοῦνται ");
INSERT INTO grcsbl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ἢ δοκεῖς ὅτι οὐ ⸀δύναμαιπαρακαλέσαι τὸν πατέρα μου, καὶ παραστήσει μοι ⸂ἄρτι πλείω δώδεκα λεγιῶνας ἀγγέλων; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","πῶς οὖν πληρωθῶσιν αἱ γραφαὶ ὅτι οὕτως δεῖ γενέσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ἐν ἐκείνῃ τῇ ὥρᾳ εἶπεν ὁ Ἰησοῦς τοῖς ὄχλοις· Ὡς ἐπὶ λῃστὴν ἐξήλθατε μετὰ μαχαιρῶν καὶ ξύλων συλλαβεῖν με; καθʼ ⸀ἡμέραν⸂ἐν τῷ ἱερῷ ἐκαθεζόμην διδάσκων καὶ οὐκ ἐκρατήσατέ με. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","τοῦτο δὲ ὅλον γέγονεν ἵνα πληρωθῶσιν αἱ γραφαὶ τῶν προφητῶν. τότε οἱ μαθηταὶ πάντες ἀφέντες αὐτὸν ἔφυγον. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Οἱ δὲ κρατήσαντες τὸν Ἰησοῦν ἀπήγαγον πρὸς Καϊάφαν τὸν ἀρχιερέα, ὅπου οἱ γραμματεῖς καὶ οἱ πρεσβύτεροι συνήχθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ὁ δὲ Πέτρος ἠκολούθει αὐτῷ ἀπὸ μακρόθεν ἕως τῆς αὐλῆς τοῦ ἀρχιερέως, καὶ εἰσελθὼν ἔσω ἐκάθητο μετὰ τῶν ὑπηρετῶν ἰδεῖν τὸ τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","οἱ δὲ ἀρχιερεῖς ⸀καὶτὸ συνέδριον ὅλον ἐζήτουν ψευδομαρτυρίαν κατὰ τοῦ Ἰησοῦ ὅπως ⸂αὐτὸν θανατώσωσιν, ");
INSERT INTO grcsbl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","καὶ οὐχ εὗρον ⸂πολλῶν προσελθόντων ψευδομαρτύρων. ὕστερον δὲ προσελθόντες δύο⸃ ");
INSERT INTO grcsbl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","εἶπαν· Οὗτος ἔφη· Δύναμαι καταλῦσαι τὸν ναὸν τοῦ θεοῦ καὶ διὰ τριῶν ἡμερῶν ⸀οἰκοδομῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","καὶ ἀναστὰς ὁ ἀρχιερεὺς εἶπεν αὐτῷ· Οὐδὲν ἀποκρίνῃ; τί οὗτοί σου καταμαρτυροῦσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ὁ δὲ Ἰησοῦς ἐσιώπα. ⸀καὶὁ ἀρχιερεὺς εἶπεν αὐτῷ· Ἐξορκίζω σε κατὰ τοῦ θεοῦ τοῦ ζῶντος ἵνα ἡμῖν εἴπῃς εἰ σὺ εἶ ὁ χριστὸς ὁ υἱὸς τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","λέγει αὐτῷ ὁ Ἰησοῦς· Σὺ εἶπας· πλὴν λέγω ὑμῖν, ἀπʼ ἄρτι ὄψεσθε τὸν υἱὸν τοῦ ἀνθρώπου καθήμενον ἐκ δεξιῶν τῆς δυνάμεως καὶ ἐρχόμενον ἐπὶ τῶν νεφελῶν τοῦ οὐρανοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","τότε ὁ ἀρχιερεὺς διέρρηξεν τὰ ἱμάτια αὐτοῦ ⸀λέγων Ἐβλασφήμησεν· τί ἔτι χρείαν ἔχομεν μαρτύρων; ἴδε νῦν ἠκούσατε τὴν ⸀βλασφημίαν ");
INSERT INTO grcsbl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","τί ὑμῖν δοκεῖ; οἱ δὲ ἀποκριθέντες εἶπαν· Ἔνοχος θανάτου ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","τότε ἐνέπτυσαν εἰς τὸ πρόσωπον αὐτοῦ καὶ ἐκολάφισαν αὐτόν, οἱ δὲ ἐράπισαν ");
INSERT INTO grcsbl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","λέγοντες· Προφήτευσον ἡμῖν, χριστέ, τίς ἐστιν ὁ παίσας σε; ");
INSERT INTO grcsbl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ὁ δὲ Πέτρος ⸂ἐκάθητο ἔξω ἐν τῇ αὐλῇ· καὶ προσῆλθεν αὐτῷ μία παιδίσκη λέγουσα· Καὶ σὺ ἦσθα μετὰ Ἰησοῦ τοῦ Γαλιλαίου· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ὁ δὲ ἠρνήσατο ⸀ἔμπροσθενπάντων λέγων· Οὐκ οἶδα τί λέγεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ἐξελθόντα ⸀δὲεἰς τὸν πυλῶνα εἶδεν αὐτὸν ἄλλη καὶ λέγει ⸀τοῖςἐκεῖ· ⸀Οὗτοςἦν μετὰ Ἰησοῦ τοῦ Ναζωραίου· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","καὶ πάλιν ἠρνήσατο μετὰ ὅρκου ὅτι Οὐκ οἶδα τὸν ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","μετὰ μικρὸν δὲ προσελθόντες οἱ ἑστῶτες εἶπον τῷ Πέτρῳ· Ἀληθῶς καὶ σὺ ἐξ αὐτῶν εἶ, καὶ γὰρ ἡ λαλιά σου δῆλόν σε ποιεῖ· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","τότε ἤρξατο καταθεματίζειν καὶ ὀμνύειν ὅτι Οὐκ οἶδα τὸν ἄνθρωπον. καὶ ⸀εὐθέωςἀλέκτωρ ἐφώνησεν· ");
INSERT INTO grcsbl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","καὶ ἐμνήσθη ὁ Πέτρος τοῦ ⸀ῥήματοςἸησοῦ ⸀εἰρηκότοςὅτι Πρὶν ἀλέκτορα φωνῆσαι τρὶς ἀπαρνήσῃ με, καὶ ἐξελθὼν ἔξω ἔκλαυσεν πικρῶς. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Πρωΐας δὲ γενομένης συμβούλιον ἔλαβον πάντες οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τοῦ λαοῦ κατὰ τοῦ Ἰησοῦ ὥστε θανατῶσαι αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","καὶ δήσαντες αὐτὸν ἀπήγαγον καὶ ⸀παρέδωκανΠιλάτῳ τῷ ἡγεμόνι. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Τότε ἰδὼν Ἰούδας ὁ ⸀παραδιδοὺςαὐτὸν ὅτι κατεκρίθη μεταμεληθεὶς ⸀ἔστρεψεντὰ τριάκοντα ἀργύρια τοῖς ἀρχιερεῦσιν ⸀καὶπρεσβυτέροις ");
INSERT INTO grcsbl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","λέγων· Ἥμαρτον παραδοὺς αἷμα ⸀ἀθῷον οἱ δὲ εἶπαν· Τί πρὸς ἡμᾶς; σὺ ⸀ὄψῃ ");
INSERT INTO grcsbl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","καὶ ῥίψας τὰ ἀργύρια ⸂εἰς τὸν ναὸν ἀνεχώρησεν, καὶ ἀπελθὼν ἀπήγξατο. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","οἱ δὲ ἀρχιερεῖς λαβόντες τὰ ἀργύρια εἶπαν· Οὐκ ἔξεστιν βαλεῖν αὐτὰ εἰς τὸν κορβανᾶν, ἐπεὶ τιμὴ αἵματός ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","συμβούλιον δὲ λαβόντες ἠγόρασαν ἐξ αὐτῶν τὸν Ἀγρὸν τοῦ Κεραμέως εἰς ταφὴν τοῖς ξένοις. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","διὸ ἐκλήθη ὁ ἀγρὸς ἐκεῖνος Ἀγρὸς Αἵματος ἕως τῆς σήμερον. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","τότε ἐπληρώθη τὸ ῥηθὲν διὰ Ἰερεμίου τοῦ προφήτου λέγοντος· Καὶ ἔλαβον τὰ τριάκοντα ἀργύρια, τὴν τιμὴν τοῦ τετιμημένου ὃν ἐτιμήσαντο ἀπὸ υἱῶν Ἰσραήλ, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","καὶ ἔδωκαν αὐτὰ εἰς τὸν ἀγρὸν τοῦ κεραμέως, καθὰ συνέταξέν μοι κύριος. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ὁ δὲ Ἰησοῦς ⸀ἐστάθηἔμπροσθεν τοῦ ἡγεμόνος· καὶ ἐπηρώτησεν αὐτὸν ὁ ἡγεμὼν λέγων· Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; ὁ δὲ Ἰησοῦς ⸀ἔφη Σὺ λέγεις. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","καὶἐν τῷ κατηγορεῖσθαι αὐτὸν ὑπὸ τῶν ἀρχιερέων ⸀καὶ πρεσβυτέρων οὐδὲν ἀπεκρίνατο. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","τότε λέγει αὐτῷ ὁ Πιλᾶτος· Οὐκ ἀκούεις πόσα σου καταμαρτυροῦσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","καὶ οὐκ ἀπεκρίθη αὐτῷ πρὸς οὐδὲ ἓν ῥῆμα, ὥστε θαυμάζειν τὸν ἡγεμόνα λίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Κατὰ δὲ ἑορτὴν εἰώθει ὁ ἡγεμὼν ἀπολύειν ἕνα τῷ ὄχλῳ δέσμιον ὃν ἤθελον. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","εἶχον δὲ τότε δέσμιον ἐπίσημον λεγόμενον ⸀ἸησοῦνΒαραββᾶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","συνηγμένων οὖν αὐτῶν εἶπεν αὐτοῖς ὁ Πιλᾶτος· Τίνα θέλετε ἀπολύσω ὑμῖν, ⸂Ἰησοῦν τὸν Βαραββᾶν ἢ Ἰησοῦν τὸν λεγόμενον χριστόν; ");
INSERT INTO grcsbl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ᾔδει γὰρ ὅτι διὰ φθόνον παρέδωκαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Καθημένου δὲ αὐτοῦ ἐπὶ τοῦ βήματος ἀπέστειλεν πρὸς αὐτὸν ἡ γυνὴ αὐτοῦ λέγουσα· Μηδὲν σοὶ καὶ τῷ δικαίῳ ἐκείνῳ, πολλὰ γὰρ ἔπαθον σήμερον κατʼ ὄναρ διʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Οἱ δὲ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι ἔπεισαν τοὺς ὄχλους ἵνα αἰτήσωνται τὸν Βαραββᾶν τὸν δὲ Ἰησοῦν ἀπολέσωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ἀποκριθεὶς δὲ ὁ ἡγεμὼν εἶπεν αὐτοῖς· Τίνα θέλετε ἀπὸ τῶν δύο ἀπολύσω ὑμῖν; οἱ δὲ εἶπαν· ⸀ΤὸνΒαραββᾶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","λέγει αὐτοῖς ὁ Πιλᾶτος· Τί οὖν ποιήσω Ἰησοῦν τὸν λεγόμενον χριστόν; ⸀λέγουσινπάντες· Σταυρωθήτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ὁ ⸀δὲἔφη· Τί γὰρ κακὸν ἐποίησεν; οἱ δὲ περισσῶς ἔκραζον λέγοντες· Σταυρωθήτω. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ἰδὼν δὲ ὁ Πιλᾶτος ὅτι οὐδὲν ὠφελεῖ ἀλλὰ μᾶλλον θόρυβος γίνεται λαβὼν ὕδωρ ἀπενίψατο τὰς χεῖρας ⸀ἀπέναντιτοῦ ὄχλου λέγων· Ἀθῷός εἰμι ἀπὸ τοῦ ⸀αἵματοςτούτου· ὑμεῖς ὄψεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","καὶ ἀποκριθεὶς πᾶς ὁ λαὸς εἶπεν· Τὸ αἷμα αὐτοῦ ἐφʼ ἡμᾶς καὶ ἐπὶ τὰ τέκνα ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","τότε ἀπέλυσεν αὐτοῖς τὸν Βαραββᾶν, τὸν δὲ Ἰησοῦν φραγελλώσας παρέδωκεν ἵνα σταυρωθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Τότε οἱ στρατιῶται τοῦ ἡγεμόνος παραλαβόντες τὸν Ἰησοῦν εἰς τὸ πραιτώριον συνήγαγον ἐπʼ αὐτὸν ὅλην τὴν σπεῖραν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","καὶ ἐκδύσαντες αὐτὸν ⸂χλαμύδα κοκκίνην περιέθηκαν αὐτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","καὶ πλέξαντες στέφανον ἐξ ἀκανθῶν ἐπέθηκαν ἐπὶ ⸂τῆς κεφαλῆς αὐτοῦ καὶ κάλαμον ⸂ἐν τῇ δεξιᾷ αὐτοῦ, καὶ γονυπετήσαντες ἔμπροσθεν αὐτοῦ ⸀ἐνέπαιξαναὐτῷ λέγοντες· Χαῖρε, ⸀βασιλεῦτῶν Ἰουδαίων, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","καὶ ἐμπτύσαντες εἰς αὐτὸν ἔλαβον τὸν κάλαμον καὶ ἔτυπτον εἰς τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","καὶ ὅτε ἐνέπαιξαν αὐτῷ, ἐξέδυσαν αὐτὸν τὴν χλαμύδα καὶ ἐνέδυσαν αὐτὸν τὰ ἱμάτια αὐτοῦ καὶ ἀπήγαγον αὐτὸν εἰς τὸ σταυρῶσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ἐξερχόμενοι δὲ εὗρον ἄνθρωπον Κυρηναῖον ὀνόματι Σίμωνα· τοῦτον ἠγγάρευσαν ἵνα ἄρῃ τὸν σταυρὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Καὶ ἐλθόντες εἰς τόπον λεγόμενον Γολγοθᾶ, ὅ ἐστιν ⸂Κρανίου Τόπος λεγόμενος, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ἔδωκαν αὐτῷ πιεῖν ⸀οἶνονμετὰ χολῆς μεμιγμένον· καὶ γευσάμενος οὐκ ⸀ἠθέλησενπιεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","σταυρώσαντες δὲ αὐτὸν διεμερίσαντο τὰ ἱμάτια αὐτοῦ βάλλοντες κλῆρον, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","καὶ καθήμενοι ἐτήρουν αὐτὸν ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","καὶ ἐπέθηκαν ἐπάνω τῆς κεφαλῆς αὐτοῦ τὴν αἰτίαν αὐτοῦ γεγραμμένην· Οὗτός ἐστιν Ἰησοῦς ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Τότε σταυροῦνται σὺν αὐτῷ δύο λῃσταί, εἷς ἐκ δεξιῶν καὶ εἷς ἐξ εὐωνύμων. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","οἱ δὲ παραπορευόμενοι ἐβλασφήμουν αὐτὸν κινοῦντες τὰς κεφαλὰς αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","καὶ λέγοντες· Ὁ καταλύων τὸν ναὸν καὶ ἐν τρισὶν ἡμέραις οἰκοδομῶν, σῶσον σεαυτόν· εἰ υἱὸς εἶ τοῦ θεοῦ, ⸀κατάβηθιἀπὸ τοῦ σταυροῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ὁμοίως ⸀καὶοἱ ἀρχιερεῖς ἐμπαίζοντες μετὰ τῶν γραμματέων καὶ ⸀πρεσβυτέρωνἔλεγον· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ἄλλους ἔσωσεν, ἑαυτὸν οὐ δύναται σῶσαι· ⸀βασιλεὺςἸσραήλ ἐστιν, καταβάτω νῦν ἀπὸ τοῦ σταυροῦ καὶ πιστεύσομεν ἐπʼ ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","πέποιθεν ἐπὶ τὸν θεόν, ῥυσάσθω ⸀νῦνεἰ θέλει αὐτόν· εἶπεν γὰρ ὅτι Θεοῦ εἰμι υἱός. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","τὸ δʼ αὐτὸ καὶ οἱ λῃσταὶ οἱ συσταυρωθέντες ⸀σὺναὐτῷ ὠνείδιζον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ἀπὸ δὲ ἕκτης ὥρας σκότος ἐγένετο ἐπὶ πᾶσαν τὴν γῆν ἕως ὥρας ἐνάτης. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","περὶ δὲ τὴν ἐνάτην ὥραν ⸀ἀνεβόησενὁ Ἰησοῦς φωνῇ μεγάλῃ λέγων· ⸂Ἠλὶ ἠλὶ λεμὰ σαβαχθάνι; τοῦτʼ ἔστιν· Θεέ μου θεέ μου, ἱνατί με ἐγκατέλιπες; ");
INSERT INTO grcsbl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","τινὲς δὲ τῶν ἐκεῖ ⸀ἑστηκότωνἀκούσαντες ἔλεγον ὅτι Ἠλίαν φωνεῖ οὗτος. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","καὶ εὐθέως δραμὼν εἷς ἐξ αὐτῶν καὶ λαβὼν σπόγγον πλήσας τε ὄξους καὶ περιθεὶς καλάμῳ ἐπότιζεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","οἱ δὲ λοιποὶ ⸀ἔλεγον Ἄφες ἴδωμεν εἰ ἔρχεται Ἠλίας σώσων ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ὁ δὲ Ἰησοῦς πάλιν κράξας φωνῇ μεγάλῃ ἀφῆκεν τὸ πνεῦμα. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","καὶ ἰδοὺ τὸ καταπέτασμα τοῦ ναοῦ ἐσχίσθη ⸂ἀπʼ ἄνωθεν ἕως κάτω εἰς δύο, καὶ ἡ γῆ ἐσείσθη, καὶ αἱ πέτραι ἐσχίσθησαν, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","καὶ τὰ μνημεῖα ἀνεῴχθησαν καὶ πολλὰ σώματα τῶν κεκοιμημένων ἁγίων ⸀ἠγέρθησαν ");
INSERT INTO grcsbl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","καὶ ἐξελθόντες ἐκ τῶν μνημείων μετὰ τὴν ἔγερσιν αὐτοῦ εἰσῆλθον εἰς τὴν ἁγίαν πόλιν καὶ ἐνεφανίσθησαν πολλοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ὁ δὲ ἑκατόνταρχος καὶ οἱ μετʼ αὐτοῦ τηροῦντες τὸν Ἰησοῦν ἰδόντες τὸν σεισμὸν καὶ τὰ ⸀γενόμεναἐφοβήθησαν σφόδρα λέγοντες· Ἀληθῶς ⸂θεοῦ υἱὸς ἦν οὗτος. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ἦσαν δὲ ἐκεῖ γυναῖκες πολλαὶ ἀπὸ μακρόθεν θεωροῦσαι, αἵτινες ἠκολούθησαν τῷ Ἰησοῦ ἀπὸ τῆς Γαλιλαίας διακονοῦσαι αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ἐν αἷς ἦν Μαρία ἡ Μαγδαληνὴ καὶ Μαρία ἡ τοῦ Ἰακώβου καὶ ⸀Ἰωσὴφμήτηρ καὶ ἡ μήτηρ τῶν υἱῶν Ζεβεδαίου. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ὀψίας δὲ γενομένης ἦλθεν ἄνθρωπος πλούσιος ἀπὸ Ἁριμαθαίας, τοὔνομα Ἰωσήφ, ὃς καὶ αὐτὸς ⸀ἐμαθητεύθητῷ Ἰησοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","οὗτος προσελθὼν τῷ Πιλάτῳ ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ. τότε ὁ Πιλᾶτος ἐκέλευσεν ⸀ἀποδοθῆναι ");
INSERT INTO grcsbl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","καὶ λαβὼν τὸ σῶμα ὁ Ἰωσὴφ ἐνετύλιξεν ⸀αὐτὸσινδόνι καθαρᾷ, ");
INSERT INTO grcsbl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","καὶ ἔθηκεν αὐτὸ ἐν τῷ καινῷ αὐτοῦ μνημείῳ ὃ ἐλατόμησεν ἐν τῇ πέτρᾳ, καὶ προσκυλίσας λίθον μέγαν τῇ θύρᾳ τοῦ μνημείου ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ἦν δὲ ἐκεῖ ⸀Μαριὰμἡ Μαγδαληνὴ καὶ ἡ ἄλλη Μαρία καθήμεναι ἀπέναντι τοῦ τάφου. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Τῇ δὲ ἐπαύριον, ἥτις ἐστὶν μετὰ τὴν παρασκευήν, συνήχθησαν οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι πρὸς Πιλᾶτον ");
INSERT INTO grcsbl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","λέγοντες· Κύριε, ἐμνήσθημεν ὅτι ἐκεῖνος ὁ πλάνος εἶπεν ἔτι ζῶν· Μετὰ τρεῖς ἡμέρας ἐγείρομαι· ");
INSERT INTO grcsbl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","κέλευσον οὖν ἀσφαλισθῆναι τὸν τάφον ἕως τῆς τρίτης ἡμέρας, μήποτε ἐλθόντες οἱ μαθηταὶ ⸀αὐτοῦκλέψωσιν αὐτὸν καὶ εἴπωσιν τῷ λαῷ· Ἠγέρθη ἀπὸ τῶν νεκρῶν, καὶ ἔσται ἡ ἐσχάτη πλάνη χείρων τῆς πρώτης. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","⸀ἔφηαὐτοῖς ὁ Πιλᾶτος· Ἔχετε κουστωδίαν· ὑπάγετε ἀσφαλίσασθε ὡς οἴδατε. ");
INSERT INTO grcsbl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","οἱ δὲ πορευθέντες ἠσφαλίσαντο τὸν τάφον σφραγίσαντες τὸν λίθον μετὰ τῆς κουστωδίας. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ὀψὲ δὲ σαββάτων, τῇ ἐπιφωσκούσῃ εἰς μίαν σαββάτων, ἦλθεν ⸀Μαριὰμἡ Μαγδαληνὴ καὶ ἡ ἄλλη Μαρία θεωρῆσαι τὸν τάφον. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","καὶἰδοὺ σεισμὸς ἐγένετο μέγας· ἄγγελος γὰρ κυρίου καταβὰς ἐξ οὐρανοῦ ⸀καὶ προσελθὼν ἀπεκύλισε τὸν ⸀λίθονκαὶ ἐκάθητο ἐπάνω αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ἦν δὲ ἡ εἰδέα αὐτοῦ ⸀ὡςἀστραπὴ καὶ τὸ ἔνδυμα αὐτοῦ λευκὸν ὡς χιών. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ἀπὸ δὲ τοῦ φόβου αὐτοῦ ἐσείσθησαν οἱ τηροῦντες καὶ ἐγενήθησαν ⸀ὡςνεκροί. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ἀποκριθεὶς δὲ ὁ ἄγγελος εἶπεν ταῖς γυναιξίν· Μὴ φοβεῖσθε ὑμεῖς, οἶδα γὰρ ὅτι Ἰησοῦν τὸν ἐσταυρωμένον ζητεῖτε· ");
INSERT INTO grcsbl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","οὐκ ἔστιν ὧδε, ἠγέρθη γὰρ καθὼς εἶπεν· δεῦτε ἴδετε τὸν τόπον ὅπου ⸀ἔκειτο ");
INSERT INTO grcsbl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","καὶ ταχὺ πορευθεῖσαι εἴπατε τοῖς μαθηταῖς αὐτοῦ ὅτι Ἠγέρθη ἀπὸ τῶν νεκρῶν, καὶ ἰδοὺ προάγει ὑμᾶς εἰς τὴν Γαλιλαίαν, ἐκεῖ αὐτὸν ὄψεσθε· ἰδοὺ εἶπον ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","καὶ ⸀ἀπελθοῦσαιταχὺ ἀπὸ τοῦ μνημείου μετὰ φόβου καὶ χαρᾶς μεγάλης ἔδραμον ἀπαγγεῖλαι τοῖς μαθηταῖς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","⸀καὶ⸀ἰδοὺἸησοῦς ⸀ὑπήντησεναὐταῖς λέγων· Χαίρετε· αἱ δὲ προσελθοῦσαι ἐκράτησαν αὐτοῦ τοὺς πόδας καὶ προσεκύνησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","τότε λέγει αὐταῖς ὁ Ἰησοῦς· Μὴ φοβεῖσθε· ὑπάγετε ἀπαγγείλατε τοῖς ἀδελφοῖς μου ἵνα ἀπέλθωσιν εἰς τὴν Γαλιλαίαν, κἀκεῖ με ὄψονται. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Πορευομένων δὲ αὐτῶν ἰδού τινες τῆς κουστωδίας ἐλθόντες εἰς τὴν πόλιν ἀπήγγειλαν τοῖς ἀρχιερεῦσιν ἅπαντα τὰ γενόμενα. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","καὶ συναχθέντες μετὰ τῶν πρεσβυτέρων συμβούλιόν τε λαβόντες ἀργύρια ἱκανὰ ἔδωκαν τοῖς στρατιώταις ");
INSERT INTO grcsbl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","λέγοντες· Εἴπατε ὅτι Οἱ μαθηταὶ αὐτοῦ νυκτὸς ἐλθόντες ἔκλεψαν αὐτὸν ἡμῶν κοιμωμένων· ");
INSERT INTO grcsbl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","καὶ ἐὰν ἀκουσθῇ τοῦτο ⸀ἐπὶτοῦ ἡγεμόνος, ἡμεῖς πείσομεν ⸀αὐτὸνκαὶ ὑμᾶς ἀμερίμνους ποιήσομεν. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","οἱ δὲ λαβόντες ⸀τὰἀργύρια ἐποίησαν ὡς ἐδιδάχθησαν. Καὶ διεφημίσθη ὁ λόγος οὗτος παρὰ Ἰουδαίοις μέχρι τῆς σήμερον ⸀ἡμέρας ");
INSERT INTO grcsbl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Οἱ δὲ ἕνδεκα μαθηταὶ ἐπορεύθησαν εἰς τὴν Γαλιλαίαν εἰς τὸ ὄρος οὗ ἐτάξατο αὐτοῖς ὁ Ἰησοῦς, ");
INSERT INTO grcsbl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","καὶ ἰδόντες αὐτὸν ⸀προσεκύνησαν οἱ δὲ ἐδίστασαν. ");
INSERT INTO grcsbl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","καὶ προσελθὼν ὁ Ἰησοῦς ἐλάλησεν αὐτοῖς λέγων· Ἐδόθη μοι πᾶσα ἐξουσία ἐν οὐρανῷ καὶ ἐπὶ ⸀τῆςγῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","πορευθέντες ⸀οὖνμαθητεύσατε πάντα τὰ ἔθνη, ⸀βαπτίζοντεςαὐτοὺς εἰς τὸ ὄνομα τοῦ πατρὸς καὶ τοῦ υἱοῦ καὶ τοῦ ἁγίου πνεύματος, ");
INSERT INTO grcsbl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","διδάσκοντες αὐτοὺς τηρεῖν πάντα ὅσα ἐνετειλάμην ὑμῖν· καὶ ἰδοὺ ἐγὼ μεθʼ ὑμῶν εἰμι πάσας τὰς ἡμέρας ἕως τῆς συντελείας τοῦ ⸀αἰῶνος ‘p /’ ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ἀρχὴ τοῦ εὐαγγελίου Ἰησοῦ ⸀χριστοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","⸀Καθὼςγέγραπται ἐν ⸂τῷ Ἠσαΐᾳ τῷ προφήτῃ· ⸀Ἰδοὺ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν ⸀σου· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","φωνὴ βοῶντος ἐν τῇ ἐρήμῳ· Ἑτοιμάσατε τὴν ὁδὸν κυρίου, εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ἐγένετο Ἰωάννης ⸀ὁβαπτίζων ἐν τῇ ⸀ἐρήμῳκηρύσσων βάπτισμα μετανοίας εἰς ἄφεσιν ἁμαρτιῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","καὶ ἐξεπορεύετο πρὸς αὐτὸν πᾶσα ἡ Ἰουδαία χώρα καὶ οἱ Ἱεροσολυμῖται ⸂πάντες, καὶ ἐβαπτίζοντο⸃ ⸂ὑπʼ αὐτοῦ ἐν τῷ Ἰορδάνῃ ποταμῷ⸃ ἐξομολογούμενοι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","⸂καὶ ἦν ὁ Ἰωάννης ἐνδεδυμένος τρίχας καμήλου καὶ ζώνην δερματίνην περὶ τὴν ὀσφὺν αὐτοῦ, καὶ ἔσθων ἀκρίδας καὶ μέλι ἄγριον. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","καὶ ἐκήρυσσεν λέγων· Ἔρχεται ὁ ἰσχυρότερός μου ὀπίσω μου, οὗ οὐκ εἰμὶ ἱκανὸς κύψας λῦσαι τὸν ἱμάντα τῶν ὑποδημάτων αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","⸀ἐγὼἐβάπτισα ⸀ὑμᾶςὕδατι, αὐτὸς δὲ βαπτίσει ὑμᾶς ⸀ἐνπνεύματι ἁγίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Καὶ ἐγένετο ἐν ἐκείναις ταῖς ἡμέραις ἦλθεν Ἰησοῦς ἀπὸ Ναζαρὲτ τῆς Γαλιλαίας καὶ ἐβαπτίσθη ⸂εἰς τὸν Ἰορδάνην ὑπὸ Ἰωάννου. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","καὶ ⸀εὐθὺςἀναβαίνων ⸀ἐκτοῦ ὕδατος εἶδεν σχιζομένους τοὺς οὐρανοὺς καὶ τὸ πνεῦμα ⸀ὡςπεριστερὰν καταβαῖνον ⸀εἰςαὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","καὶ φωνὴ ἐγένετο ἐκ τῶν οὐρανῶν· Σὺ εἶ ὁ υἱός μου ὁ ἀγαπητός, ἐν ⸀σοὶεὐδόκησα. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Καὶ εὐθὺς τὸ πνεῦμα αὐτὸν ἐκβάλλει εἰς τὴν ἔρημον. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","καὶ ⸀ἦνἐν τῇ ἐρήμῳ ⸂τεσσεράκοντα ἡμέρας πειραζόμενος ὑπὸ τοῦ Σατανᾶ, καὶ ἦν μετὰ τῶν θηρίων, καὶ οἱ ἄγγελοι διηκόνουν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","⸂Καὶ μετὰ τὸ παραδοθῆναι τὸν Ἰωάννην ἦλθεν ὁ Ἰησοῦς εἰς τὴν Γαλιλαίαν κηρύσσων τὸ ⸀εὐαγγέλιοντοῦ θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","καὶ λέγων ὅτι Πεπλήρωται ὁ καιρὸς καὶ ἤγγικεν ἡ βασιλεία τοῦ θεοῦ· μετανοεῖτε καὶ πιστεύετε ἐν τῷ εὐαγγελίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","⸂Καὶ παράγων παρὰ τὴν θάλασσαν τῆς Γαλιλαίας εἶδεν Σίμωνα καὶ Ἀνδρέαν τὸν ⸀ἀδελφὸνΣίμωνος ⸀ἀμφιβάλλονταςἐν τῇ θαλάσσῃ, ἦσαν γὰρ ἁλιεῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς· Δεῦτε ὀπίσω μου, καὶ ποιήσω ὑμᾶς γενέσθαι ἁλιεῖς ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","καὶ ⸀εὐθὺςἀφέντες τὰ ⸀δίκτυαἠκολούθησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","καὶ ⸀προβὰςὀλίγον εἶδεν Ἰάκωβον τὸν τοῦ Ζεβεδαίου καὶ Ἰωάννην τὸν ἀδελφὸν αὐτοῦ, καὶ αὐτοὺς ἐν τῷ πλοίῳ καταρτίζοντας τὰ δίκτυα, ");
INSERT INTO grcsbl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","καὶ ⸀εὐθὺςἐκάλεσεν αὐτούς. καὶ ἀφέντες τὸν πατέρα αὐτῶν Ζεβεδαῖον ἐν τῷ πλοίῳ μετὰ τῶν μισθωτῶν ἀπῆλθον ὀπίσω αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Καὶ εἰσπορεύονται εἰς Καφαρναούμ. καὶ ⸀εὐθὺςτοῖς σάββασιν ⸂ἐδίδασκεν εἰς τὴν συναγωγήν. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","καὶ ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ, ἦν γὰρ διδάσκων αὐτοὺς ὡς ἐξουσίαν ἔχων καὶ οὐχ ὡς οἱ γραμματεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","καὶ ⸀εὐθὺςἦν ἐν τῇ συναγωγῇ αὐτῶν ἄνθρωπος ἐν πνεύματι ἀκαθάρτῳ καὶ ἀνέκραξεν ");
INSERT INTO grcsbl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","λέγων· ⸀Τίἡμῖν καὶ σοί, Ἰησοῦ Ναζαρηνέ; ἦλθες ἀπολέσαι ἡμᾶς; οἶδά σε τίς εἶ, ὁ ἅγιος τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς λέγων· Φιμώθητι καὶ ἔξελθε ἐξ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","καὶ σπαράξαν αὐτὸν τὸ πνεῦμα τὸ ἀκάθαρτον καὶ ⸀φωνῆσανφωνῇ μεγάλῃ ἐξῆλθεν ἐξ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","καὶ ἐθαμβήθησαν ⸀ἅπαντες ὥστε συζητεῖν ⸂πρὸς ἑαυτοὺς λέγοντας· Τί ἐστιν τοῦτο; ⸂διδαχὴ καινή· κατʼ ἐξουσίαν καὶ τοῖς πνεύμασι τοῖς ἀκαθάρτοις ἐπιτάσσει, καὶ ὑπακούουσιν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","⸂καὶ ἐξῆλθεν ἡ ἀκοὴ αὐτοῦ εὐθὺς ⸀πανταχοῦεἰς ὅλην τὴν περίχωρον τῆς Γαλιλαίας. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Καὶ ⸀εὐθὺςἐκ τῆς συναγωγῆς ⸂ἐξελθόντες ἦλθον εἰς τὴν οἰκίαν Σίμωνος καὶ Ἀνδρέου μετὰ Ἰακώβου καὶ Ἰωάννου. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ἡ δὲ πενθερὰ Σίμωνος κατέκειτο πυρέσσουσα, καὶ ⸀εὐθὺςλέγουσιν αὐτῷ περὶ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","καὶ προσελθὼν ἤγειρεν αὐτὴν κρατήσας τῆς ⸀χειρός καὶ ἀφῆκεν αὐτὴν ὁ ⸀πυρετός καὶ διηκόνει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ὀψίας δὲ γενομένης, ὅτε ⸀ἔδυὁ ἥλιος, ἔφερον πρὸς αὐτὸν πάντας τοὺς κακῶς ἔχοντας καὶ τοὺς δαιμονιζομένους· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","καὶ ⸂ἦν ὅλη ἡ πόλις ἐπισυνηγμένη πρὸς τὴν θύραν. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","καὶ ἐθεράπευσεν πολλοὺς κακῶς ἔχοντας ποικίλαις νόσοις, καὶ δαιμόνια πολλὰ ἐξέβαλεν, καὶ οὐκ ἤφιεν λαλεῖν τὰ δαιμόνια, ὅτι ᾔδεισαν ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Καὶ πρωῒ ἔννυχα λίαν ἀναστὰς ἐξῆλθεν καὶ ἀπῆλθεν εἰς ἔρημον τόπον κἀκεῖ προσηύχετο. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","καὶ ⸀κατεδίωξεναὐτὸν ⸀Σίμωνκαὶ οἱ μετʼ αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","καὶ ⸂εὗρον αὐτὸν καὶ λέγουσιν αὐτῷ ὅτι Πάντες ⸂ζητοῦσίν σε. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","καὶ λέγει αὐτοῖς· Ἄγωμεν ⸀ἀλλαχοῦεἰς τὰς ἐχομένας κωμοπόλεις, ἵνα καὶ ἐκεῖ κηρύξω, εἰς τοῦτο γὰρ ⸀ἐξῆλθον ");
INSERT INTO grcsbl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","καὶ ⸀ἦλθενκηρύσσων ⸂εἰς τὰς συναγωγὰς αὐτῶν εἰς ὅλην τὴν Γαλιλαίαν καὶ τὰ δαιμόνια ἐκβάλλων. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Καὶ ἔρχεται πρὸς αὐτὸν λεπρὸς παρακαλῶν αὐτὸν καὶ ⸀γονυπετῶνλέγων αὐτῷ ὅτι Ἐὰν θέλῃς δύνασαί με καθαρίσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","⸀καὶ⸀ὀργισθεὶςἐκτείνας τὴν χεῖρα ⸂αὐτοῦ ἥψατο καὶ λέγει αὐτῷ· Θέλω, καθαρίσθητι· ");
INSERT INTO grcsbl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","καὶ ⸀εὐθὺςἀπῆλθεν ἀπʼ αὐτοῦ ἡ λέπρα, καὶ ἐκαθαρίσθη. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","καὶ ἐμβριμησάμενος αὐτῷ ⸀εὐθὺςἐξέβαλεν αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","καὶ λέγει αὐτῷ· Ὅρα μηδενὶ μηδὲν εἴπῃς, ἀλλὰ ὕπαγε σεαυτὸν δεῖξον τῷ ἱερεῖ καὶ προσένεγκε περὶ τοῦ καθαρισμοῦ σου ἃ προσέταξεν Μωϋσῆς εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ὁ δὲ ἐξελθὼν ἤρξατο κηρύσσειν πολλὰ καὶ διαφημίζειν τὸν λόγον, ὥστε μηκέτι αὐτὸν δύνασθαι φανερῶς εἰς πόλιν εἰσελθεῖν, ἀλλὰ ἔξω ⸀ἐπʼἐρήμοις τόποις ἦν· καὶ ἤρχοντο πρὸς αὐτὸν ⸀πάντοθεν ");
INSERT INTO grcsbl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Καὶ ⸀εἰσελθὼνπάλιν εἰς Καφαρναοὺμ διʼ ⸀ἡμερῶνἠκούσθη ὅτι ⸂ἐν οἴκῳ ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","⸀καὶσυνήχθησαν πολλοὶ ὥστε μηκέτι χωρεῖν μηδὲ τὰ πρὸς τὴν θύραν, καὶ ἐλάλει αὐτοῖς τὸν λόγον. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","καὶ ἔρχονται ⸂φέροντες πρὸς αὐτὸν παραλυτικὸν αἰρόμενον ὑπὸ τεσσάρων. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","καὶ μὴ δυνάμενοι ⸀προσενέγκαιαὐτῷ διὰ τὸν ὄχλον ἀπεστέγασαν τὴν στέγην ὅπουἦν, καὶ ἐξορύξαντες χαλῶσι τὸν κράβαττον ⸀ὅπου ὁ παραλυτικὸς κατέκειτο. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","⸂καὶ ἰδὼν ὁ Ἰησοῦς τὴν πίστιν αὐτῶν λέγει τῷ παραλυτικῷ· Τέκνον, ⸂ἀφίενταί σου αἱ ⸀ἁμαρτίαι ");
INSERT INTO grcsbl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ἦσαν δέ τινες τῶν γραμματέων ἐκεῖ καθήμενοι καὶ διαλογιζόμενοι ἐν ταῖς καρδίαις αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Τί οὗτος οὕτως λαλεῖ; ⸀βλασφημεῖ τίς δύναται ἀφιέναι ἁμαρτίας εἰ μὴ εἷς ὁ θεός; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","καὶ ⸀εὐθὺςἐπιγνοὺς ὁ Ἰησοῦς τῷ πνεύματι αὐτοῦ ὅτι ⸀οὕτωςδιαλογίζονται ἐν ἑαυτοῖς ⸀λέγειαὐτοῖς· Τί ταῦτα διαλογίζεσθε ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","τί ἐστιν εὐκοπώτερον, εἰπεῖν τῷ παραλυτικῷ· ⸀Ἀφίενταίσου αἱ ἁμαρτίαι, ἢ εἰπεῖν· ⸀Ἔγειρεκαὶ ἆρον ⸂τὸν κράβαττόν σου καὶ περιπάτει; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ἵνα δὲ εἰδῆτε ὅτι ἐξουσίαν ἔχει ὁ υἱὸς τοῦ ἀνθρώπου ⸂ἐπὶ τῆς γῆς ἀφιέναι ἁμαρτίας— λέγει τῷ παραλυτικῷ· ");
INSERT INTO grcsbl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Σοὶ λέγω, ⸀ἔγειρεἆρον τὸν κράβαττόν σου καὶ ὕπαγε εἰς τὸν οἶκόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","καὶ ἠγέρθη ⸂καὶ εὐθὺς ἄρας τὸν κράβαττον ἐξῆλθεν ⸀ἔμπροσθενπάντων, ὥστε ἐξίστασθαι πάντας καὶ δοξάζειν τὸν θεὸν λέγοντας ὅτι ⸂Οὕτως οὐδέποτε εἴδομεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Καὶ ἐξῆλθεν πάλιν παρὰ τὴν θάλασσαν· καὶ πᾶς ὁ ὄχλος ἤρχετο πρὸς αὐτόν, καὶ ἐδίδασκεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","καὶ παράγων εἶδεν Λευὶν τὸν τοῦ Ἁλφαίου καθήμενον ἐπὶ τὸ τελώνιον, καὶ λέγει αὐτῷ· Ἀκολούθει μοι. καὶ ἀναστὰς ἠκολούθησεν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Καὶ ⸀γίνεταικατακεῖσθαι αὐτὸν ἐν τῇ οἰκίᾳ αὐτοῦ, καὶ πολλοὶ τελῶναι καὶ ἁμαρτωλοὶ συνανέκειντο τῷ Ἰησοῦ καὶ τοῖς μαθηταῖς αὐτοῦ, ἦσαν γὰρ πολλοὶ καὶ ⸀ἠκολούθουναὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","καὶ οἱ γραμματεῖς ⸂τῶν Φαρισαίων ⸀ἰδόντες⸂ὅτι ἐσθίει μετὰ τῶν ⸂ἁμαρτωλῶν καὶ τελωνῶν ἔλεγον τοῖς μαθηταῖς αὐτοῦ· ⸀Ὅτιμετὰ τῶν ⸂τελωνῶν καὶ ἁμαρτωλῶν ⸀ἐσθίει ");
INSERT INTO grcsbl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","καὶ ἀκούσας ὁ Ἰησοῦς λέγει αὐτοῖς ⸀ὅτιΟὐ χρείαν ἔχουσιν οἱ ἰσχύοντες ἰατροῦ ἀλλʼ οἱ κακῶς ἔχοντες· οὐκ ἦλθον καλέσαι δικαίους ἀλλὰ ⸀ἁμαρτωλούς ");
INSERT INTO grcsbl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Καὶ ἦσαν οἱ μαθηταὶ Ἰωάννου καὶ οἱ ⸀Φαρισαῖοινηστεύοντες. καὶ ἔρχονται καὶ λέγουσιν αὐτῷ· Διὰ τί οἱ μαθηταὶἸωάννου καὶ οἱ ⸀μαθηταὶ τῶν Φαρισαίων νηστεύουσιν, οἱ δὲ σοὶ μαθηταὶ οὐ νηστεύουσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","καὶ εἶπεν αὐτοῖς ὁ Ἰησοῦς· Μὴ δύνανται οἱ υἱοὶ τοῦ νυμφῶνος ἐν ᾧ ὁ νυμφίος μετʼ αὐτῶν ἐστιν νηστεύειν; ὅσον χρόνον ⸂ἔχουσιν τὸν νυμφίον μετʼ αὐτῶν οὐ δύνανται νηστεύειν· ");
INSERT INTO grcsbl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ἐλεύσονται δὲ ἡμέραι ὅταν ἀπαρθῇ ἀπʼ αὐτῶν ὁ νυμφίος, καὶ τότε νηστεύσουσιν ἐν ⸂ἐκείνῃ τῇ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","⸀Οὐδεὶςἐπίβλημα ῥάκους ἀγνάφου ἐπιράπτει ἐπὶ ⸂ἱμάτιον παλαιόν· εἰ δὲ μή, αἴρει τὸ πλήρωμα ⸀ἀπʼαὐτοῦ τὸ καινὸν τοῦ παλαιοῦ, καὶ χεῖρον σχίσμα γίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","καὶ οὐδεὶς βάλλει οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μή, ⸂ῥήξει ὁ οἶνος τοὺς ἀσκούς, καὶ ὁ οἶνος ⸂ἀπόλλυται καὶ οἱ ἀσκοί. ἀλλὰ οἶνον νέον εἰς ἀσκοὺς ⸀καινούς ");
INSERT INTO grcsbl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Καὶ ἐγένετο ⸂αὐτὸν ἐν τοῖς σάββασιν παραπορεύεσθαι διὰ τῶν σπορίμων, καὶ ⸂οἱ μαθηταὶ αὐτοῦ ἤρξαντο ὁδὸν ποιεῖν τίλλοντες τοὺς στάχυας. ");
INSERT INTO grcsbl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","καὶ οἱ Φαρισαῖοι ἔλεγον αὐτῷ· Ἴδε τί ⸀ποιοῦσιντοῖς σάββασιν ὃ οὐκ ἔξεστιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","καὶ ⸀λέγειαὐτοῖς· Οὐδέποτε ἀνέγνωτε τί ἐποίησεν Δαυὶδ ὅτε χρείαν ἔσχεν καὶ ἐπείνασεν αὐτὸς καὶ οἱ μετʼ αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","⸀πῶςεἰσῆλθεν εἰς τὸν οἶκον τοῦ θεοῦ ἐπὶ Ἀβιαθὰρ ἀρχιερέως καὶ τοὺς ἄρτους τῆς προθέσεως ἔφαγεν, οὓς οὐκ ἔξεστιν φαγεῖν εἰ μὴ ⸂τοὺς ἱερεῖς, καὶ ἔδωκεν καὶ τοῖς σὺν αὐτῷ οὖσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","καὶἔλεγεν αὐτοῖς· Τὸ σάββατον διὰ τὸν ἄνθρωπον ἐγένετο ⸀καὶ οὐχ ὁ ἄνθρωπος διὰ τὸ σάββατον· ");
INSERT INTO grcsbl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ὥστε κύριός ἐστιν ὁ υἱὸς τοῦ ἀνθρώπου καὶ τοῦ σαββάτου. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Καὶ εἰσῆλθεν πάλιν ⸀εἰςσυναγωγήν, καὶ ἦν ἐκεῖ ἄνθρωπος ἐξηραμμένην ἔχων τὴν χεῖρα. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","καὶ παρετήρουν αὐτὸν εἰ τοῖς σάββασιν θεραπεύσει αὐτόν, ἵνα ⸀κατηγορήσωσιναὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","καὶ λέγει τῷ ἀνθρώπῳ τῷ ⸂τὴν χεῖρα ἔχοντι ξηράν· ⸀Ἔγειρεεἰς τὸ μέσον. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","καὶ λέγει αὐτοῖς· Ἔξεστιν τοῖς σάββασιν ⸀ἀγαθοποιῆσαιἢ κακοποιῆσαι, ψυχὴν σῶσαι ἢ ἀποκτεῖναι; οἱ δὲ ἐσιώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","καὶ περιβλεψάμενος αὐτοὺς μετʼ ὀργῆς, συλλυπούμενος ἐπὶ τῇ πωρώσει τῆς καρδίας αὐτῶν, λέγει τῷ ἀνθρώπῳ· Ἔκτεινον τὴν ⸀χεῖρα καὶ ἐξέτεινεν, καὶ ἀπεκατεστάθη ἡ χεὶρ ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","καὶ ἐξελθόντες οἱ Φαρισαῖοι ⸀εὐθὺςμετὰ τῶν Ἡρῳδιανῶν συμβούλιον ⸀ἐδίδουνκατʼ αὐτοῦ ὅπως αὐτὸν ἀπολέσωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Καὶ ὁ Ἰησοῦς ⸂μετὰ τῶν μαθητῶν αὐτοῦ ἀνεχώρησεν πρὸς τὴν θάλασσαν· καὶ πολὺ πλῆθος ἀπὸ τῆς Γαλιλαίας ⸀ἠκολούθησεν καὶ ἀπὸ τῆς Ἰουδαίας ");
INSERT INTO grcsbl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","καὶ ἀπὸ Ἱεροσολύμων καὶ ἀπὸ τῆς Ἰδουμαίας ⸀καὶπέραν τοῦ Ἰορδάνου ⸁καὶπερὶ Τύρον καὶ Σιδῶνα, πλῆθος πολύ, ⸀ἀκούοντεςὅσα ⸀ἐποίειἦλθον πρὸς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","καὶ εἶπεν τοῖς μαθηταῖς αὐτοῦ ἵνα πλοιάριον προσκαρτερῇ αὐτῷ διὰ τὸν ὄχλον ἵνα μὴ θλίβωσιν αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","πολλοὺς γὰρ ἐθεράπευσεν, ὥστε ἐπιπίπτειν αὐτῷ ἵνα αὐτοῦ ἅψωνται ὅσοι εἶχον μάστιγας. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","καὶ τὰ πνεύματα τὰ ἀκάθαρτα, ὅταν αὐτὸν ⸂ἐθεώρουν, προσέπιπτον⸃ αὐτῷ καὶ ⸀ἔκραζον ⸀λέγοντα ὅτι Σὺ εἶ ὁ υἱὸς τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","καὶ πολλὰ ἐπετίμα αὐτοῖς ἵνα μὴ ⸂αὐτὸν φανερὸν ⸀ποιήσωσιν ");
INSERT INTO grcsbl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Καὶ ἀναβαίνει εἰς τὸ ὄρος καὶ προσκαλεῖται οὓς ἤθελεν αὐτός, καὶ ἀπῆλθον πρὸς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","καὶ ἐποίησεν ⸀δώδεκα ἵνα ὦσιν μετʼ αὐτοῦ καὶ ἵνα ἀποστέλλῃ αὐτοὺς κηρύσσειν ");
INSERT INTO grcsbl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","καὶ ἔχειν ⸀ἐξουσίανἐκβάλλειν τὰ δαιμόνια· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","καὶ ⸂ἐποίησεν τοὺς δώδεκα, καὶ⸃ ἐπέθηκεν ⸂ὄνομα τῷ Σίμωνι⸃ Πέτρον, ");
INSERT INTO grcsbl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","καὶ Ἰάκωβον τὸν τοῦ Ζεβεδαίου καὶ Ἰωάννην τὸν ἀδελφὸν τοῦ Ἰακώβου (καὶ ἐπέθηκεν αὐτοῖς ⸀ὀνόματαΒοανηργές, ὅ ἐστιν Υἱοὶ Βροντῆς), ");
INSERT INTO grcsbl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","καὶ Ἀνδρέαν καὶ Φίλιππον καὶ Βαρθολομαῖον καὶ Μαθθαῖον καὶ Θωμᾶν καὶ Ἰάκωβον τὸν τοῦ Ἁλφαίου καὶ Θαδδαῖον καὶ Σίμωνα τὸν ⸀Καναναῖον ");
INSERT INTO grcsbl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","καὶ Ἰούδαν ⸀Ἰσκαριώθ ὃς καὶ παρέδωκεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Καὶ ⸀ἔρχεταιεἰς οἶκον· καὶ συνέρχεται πάλιν ⸀ὁὄχλος, ὥστε μὴ δύνασθαι αὐτοὺς ⸀μηδὲἄρτον φαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","καὶ ἀκούσαντες οἱ παρʼ αὐτοῦ ἐξῆλθον κρατῆσαι αὐτόν, ἔλεγον γὰρ ὅτι ἐξέστη. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","καὶ οἱ γραμματεῖς οἱ ἀπὸ Ἱεροσολύμων καταβάντες ἔλεγον ὅτι Βεελζεβοὺλ ἔχει καὶ ὅτι ἐν τῷ ἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","καὶ προσκαλεσάμενος αὐτοὺς ἐν παραβολαῖς ἔλεγεν αὐτοῖς· Πῶς δύναται Σατανᾶς Σατανᾶν ἐκβάλλειν; ");
INSERT INTO grcsbl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","καὶ ἐὰν βασιλεία ἐφʼ ἑαυτὴν μερισθῇ, οὐ δύναται σταθῆναι ἡ βασιλεία ἐκείνη· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","καὶ ἐὰν οἰκία ἐφʼ ἑαυτὴν μερισθῇ, οὐ ⸀δυνήσεται⸂ἡ οἰκία ἐκείνη σταθῆναι· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","καὶ εἰ ὁ Σατανᾶς ἀνέστη ἐφʼ ἑαυτὸν καὶ ⸀ἐμερίσθη οὐ δύναται ⸀στῆναιἀλλὰ τέλος ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","⸂ἀλλʼ οὐδεὶς δύναται ⸂εἰς τὴν οἰκίαν τοῦ ἰσχυροῦ εἰσελθὼν τὰ σκεύη αὐτοῦ διαρπάσαι ἐὰν μὴ πρῶτον τὸν ἰσχυρὸν δήσῃ, καὶ τότε τὴν οἰκίαν αὐτοῦ ⸀διαρπάσει ");
INSERT INTO grcsbl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ἀμὴν λέγω ὑμῖν ὅτι πάντα ἀφεθήσεται ⸂τοῖς υἱοῖς τῶν ἀνθρώπων, τὰ ἁμαρτήματα⸃ καὶ ⸂αἱ βλασφημίαι ὅσα ἐὰν⸃ βλασφημήσωσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ὃς δʼ ἂν βλασφημήσῃ εἰς τὸ πνεῦμα τὸ ἅγιον, οὐκ ἔχει ἄφεσιν εἰς τὸν αἰῶνα, ἀλλὰ ἔνοχός ἐστιν αἰωνίου ⸀ἁμαρτήματος ");
INSERT INTO grcsbl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ὅτι ἔλεγον· Πνεῦμα ἀκάθαρτον ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","⸂Καὶ ἔρχονται ⸂ἡ μήτηρ αὐτοῦ καὶ οἱ ἀδελφοὶ αὐτοῦ καὶ ἔξω ⸀στήκοντεςἀπέστειλαν πρὸς αὐτὸν ⸀καλοῦντεςαὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","καὶ ἐκάθητο ⸂περὶ αὐτὸν ὄχλος, ⸂καὶ λέγουσιν αὐτῷ· Ἰδοὺ ἡ μήτηρ σουκαὶ οἱ ἀδελφοί ⸀σου ἔξω ζητοῦσίν σε. ");
INSERT INTO grcsbl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","καὶ ⸂ἀποκριθεὶς αὐτοῖς λέγει· Τίς ἐστιν ἡ μήτηρ μου ⸀ἢοἱ ἀδελφοί ⸀μου ");
INSERT INTO grcsbl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","καὶ περιβλεψάμενος ⸂τοὺς περὶ αὐτὸν κύκλῳ καθημένους λέγει· Ἴδε ἡ μήτηρ μου καὶ οἱ ἀδελφοί μου· ");
INSERT INTO grcsbl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ὃς ⸀γὰρἂν ποιήσῃ τὸ θέλημα τοῦ θεοῦ, οὗτος ἀδελφός μου καὶ ⸀ἀδελφὴκαὶ μήτηρ ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Καὶ πάλιν ἤρξατο διδάσκειν παρὰ τὴν θάλασσαν. καὶ ⸀συνάγεταιπρὸς αὐτὸν ὄχλος ⸀πλεῖστος ὥστε αὐτὸν ⸂εἰς πλοῖον ἐμβάντα καθῆσθαι ἐν τῇ θαλάσσῃ, καὶ πᾶς ὁ ὄχλος πρὸς τὴν θάλασσαν ἐπὶ τῆς γῆς ⸀ἦσαν ");
INSERT INTO grcsbl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","καὶ ἐδίδασκεν αὐτοὺς ἐν παραβολαῖς πολλά, καὶ ἔλεγεν αὐτοῖς ἐν τῇ διδαχῇ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ἀκούετε. ἰδοὺ ἐξῆλθεν ὁ ⸀σπείρωνσπεῖραι. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","καὶ ἐγένετο ἐν τῷ σπείρειν ὃ μὲν ἔπεσεν παρὰ τὴν ὁδόν, καὶ ἦλθεν τὰ πετεινὰ καὶ κατέφαγεν αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","⸂καὶ ἄλλο ἔπεσεν ἐπὶ τὸ πετρῶδες ⸀ὅπουοὐκ εἶχεν γῆν πολλήν, καὶ ⸀εὐθὺςἐξανέτειλεν διὰ τὸ μὴ ἔχειν βάθος γῆς· ");
INSERT INTO grcsbl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","⸂καὶ ὅτε ἀνέτειλεν ὁ ἥλιος ⸀ἐκαυματίσθηκαὶ διὰ τὸ μὴ ἔχειν ῥίζαν ἐξηράνθη. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","καὶ ἄλλο ἔπεσεν εἰς τὰς ἀκάνθας, καὶ ἀνέβησαν αἱ ἄκανθαι καὶ συνέπνιξαν αὐτό, καὶ καρπὸν οὐκ ἔδωκεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","καὶ ⸀ἄλλαἔπεσεν εἰς τὴν γῆν τὴν καλήν, καὶ ἐδίδου καρπὸν ἀναβαίνοντα καὶ ⸀αὐξανόμενα καὶ ἔφερεν ⸂ἓν τριάκοντα καὶ ἓν ἑξήκοντα καὶ ἓν ἑκατόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","καὶ ἔλεγεν· ⸂Ὃς ἔχει ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","⸂Καὶ ὅτε ἐγένετο κατὰ μόνας, ⸀ἠρώτωναὐτὸν οἱ περὶ αὐτὸν σὺν τοῖς δώδεκα ⸂τὰς παραβολάς. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","καὶ ἔλεγεν αὐτοῖς· Ὑμῖν ⸂τὸ μυστήριον δέδοται τῆς βασιλείας τοῦ θεοῦ· ἐκείνοις δὲ τοῖς ἔξω ἐν παραβολαῖς τὰ πάντα γίνεται, ");
INSERT INTO grcsbl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ἵνα βλέποντες βλέπωσι καὶ μὴ ἴδωσιν, καὶ ἀκούοντες ἀκούωσι καὶ μὴ συνιῶσιν, μήποτε ἐπιστρέψωσιν καὶ ἀφεθῇ ⸀αὐτοῖς ");
INSERT INTO grcsbl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Καὶ λέγει αὐτοῖς· Οὐκ οἴδατε τὴν παραβολὴν ταύτην, καὶ πῶς πάσας τὰς παραβολὰς γνώσεσθε; ");
INSERT INTO grcsbl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ὁ σπείρων τὸν λόγον σπείρει. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","οὗτοι δέ εἰσιν οἱ παρὰ τὴν ὁδὸν ὅπου σπείρεται ὁ λόγος, καὶ ὅταν ἀκούσωσιν ⸀εὐθὺςἔρχεται ὁ Σατανᾶς καὶ αἴρει τὸν λόγον τὸν ἐσπαρμένον ⸂εἰς αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","καὶ οὗτοί εἰσιν ⸀ὁμοίωςοἱ ἐπὶ τὰ πετρώδη σπειρόμενοι, οἳ ὅταν ἀκούσωσιν τὸν λόγον ⸀εὐθὺςμετὰ χαρᾶς λαμβάνουσιν αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","καὶ οὐκ ἔχουσιν ῥίζαν ἐν ἑαυτοῖς ἀλλὰ πρόσκαιροί εἰσιν, εἶτα γενομένης θλίψεως ἢ διωγμοῦ διὰ τὸν λόγον ⸀εὐθὺςσκανδαλίζονται. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","καὶ ⸀ἄλλοιεἰσὶν οἱ εἰς τὰς ἀκάνθας σπειρόμενοι· ⸂οὗτοί εἰσιν οἱ τὸν λόγον ⸀ἀκούσαντες ");
INSERT INTO grcsbl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","καὶ αἱ μέριμναι τοῦ ⸀αἰῶνοςκαὶ ἡ ἀπάτη τοῦ πλούτου καὶ αἱ περὶ τὰ λοιπὰ ἐπιθυμίαι εἰσπορευόμεναι συμπνίγουσιν τὸν λόγον, καὶ ἄκαρπος γίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","καὶ ⸀ἐκεῖνοίεἰσιν οἱ ἐπὶ τὴν γῆν τὴν καλὴν σπαρέντες, οἵτινες ἀκούουσιν τὸν λόγον καὶ παραδέχονται καὶ καρποφοροῦσιν ⸂ἓν τριάκοντα καὶ ἓν ἑξήκοντα καὶ ἓν ἑκατόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Καὶ ἔλεγεν ⸀αὐτοῖς Μήτι ⸂ἔρχεται ὁ λύχνος ἵνα ὑπὸ τὸν μόδιον τεθῇἢ ὑπὸ τὴν κλίνην, οὐχ ἵνα ἐπὶ τὴν λυχνίαν ⸀τεθῇ; ");
INSERT INTO grcsbl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","οὐ γάρ ἐστιν ⸀κρυπτὸνἐὰν μὴ ⸀ἵναφανερωθῇ, οὐδὲ ἐγένετο ἀπόκρυφον ἀλλʼ ἵνα ⸂ἔλθῃ εἰς φανερόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","εἴ τις ἔχει ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","καὶ ἔλεγεν αὐτοῖς· Βλέπετε τί ἀκούετε. ἐν ᾧ μέτρῳ μετρεῖτε μετρηθήσεται ὑμῖνκαὶ προστεθήσεται ⸀ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ὃς γὰρ ⸀ἔχει δοθήσεται αὐτῷ· καὶ ὃ οὐκ ἔχει, καὶ ⸀ὃ ἔχει ἀρθήσεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Καὶ ἔλεγεν· Οὕτως ἐστὶν ἡ βασιλεία τοῦ θεοῦ ⸀ὡςἄνθρωπος βάλῃ τὸν σπόρον ἐπὶ τῆς γῆς ");
INSERT INTO grcsbl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","καὶ καθεύδῃ καὶ ἐγείρηται νύκτα καὶ ἡμέραν, καὶ ὁ σπόρος ⸀βλαστᾷκαὶ μηκύνηται ὡς οὐκ οἶδεν αὐτός. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","⸀αὐτομάτηἡ γῆ καρποφορεῖ, πρῶτον χόρτον, ⸂εἶτα στάχυν, εἶτα ⸂πλήρης σῖτον ἐν τῷ στάχυϊ. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ὅταν δὲ ⸀παραδοῖὁ καρπός, ⸀εὐθὺςἀποστέλλει τὸ δρέπανον, ὅτι παρέστηκεν ὁ θερισμός. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Καὶ ἔλεγεν· ⸀Πῶςὁμοιώσωμεν τὴν βασιλείαν τοῦ θεοῦ, ἢ ἐν ⸀τίνι⸂αὐτὴν παραβολῇ θῶμεν; ");
INSERT INTO grcsbl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ὡς ⸀κόκκῳσινάπεως, ὃς ὅταν σπαρῇ ἐπὶ τῆς γῆς, ⸂μικρότερον ὂν πάντων τῶν ⸀σπερμάτων τῶν ἐπὶ τῆς γῆς— ");
INSERT INTO grcsbl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","καὶ ὅταν σπαρῇ, ἀναβαίνει καὶ γίνεται ⸂μεῖζον πάντων τῶν λαχάνων καὶ ποιεῖ κλάδους μεγάλους, ὥστε δύνασθαι ὑπὸ τὴν σκιὰν αὐτοῦ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Καὶ τοιαύταις παραβολαῖς πολλαῖς ἐλάλει αὐτοῖς τὸν λόγον, καθὼς ἠδύναντο ἀκούειν· ");
INSERT INTO grcsbl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","χωρὶς δὲ παραβολῆς οὐκ ἐλάλει αὐτοῖς, κατʼ ἰδίαν δὲ τοῖς ⸂ἰδίοις μαθηταῖς ἐπέλυεν πάντα. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Καὶ λέγει αὐτοῖς ἐν ἐκείνῃ τῇ ἡμέρᾳ ὀψίας γενομένης· Διέλθωμεν εἰς τὸ πέραν. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","καὶ ἀφέντες τὸν ὄχλον παραλαμβάνουσιν αὐτὸν ὡς ἦν ἐν τῷ πλοίῳ, καὶ ἄλλα ⸀πλοῖαἦν μετʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","καὶ γίνεται λαῖλαψ ⸂μεγάλη ἀνέμου, ⸂καὶ τὰ κύματα ἐπέβαλλεν εἰς τὸ πλοῖον, ὥστε ⸂ἤδη γεμίζεσθαι τὸ πλοῖον. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","καὶ ⸂αὐτὸς ἦν ⸀ἐντῇ πρύμνῃ ἐπὶ τὸ προσκεφάλαιον καθεύδων· καὶ ⸀ἐγείρουσιναὐτὸν καὶ λέγουσιν αὐτῷ· Διδάσκαλε, οὐ μέλει σοι ὅτι ἀπολλύμεθα; ");
INSERT INTO grcsbl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","καὶ διεγερθεὶς ἐπετίμησεν τῷ ἀνέμῳ καὶ εἶπεν τῇ θαλάσσῃ· Σιώπα, πεφίμωσο. καὶ ἐκόπασεν ὁ ἄνεμος, καὶ ἐγένετο γαλήνη μεγάλη. ");
INSERT INTO grcsbl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","καὶ εἶπεν αὐτοῖς· Τί δειλοί ἐστε; ⸀οὔπωἔχετε πίστιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","καὶ ἐφοβήθησαν φόβον μέγαν, καὶ ἔλεγον πρὸς ἀλλήλους· Τίς ἄρα οὗτός ἐστιν ὅτι καὶ ὁ ἄνεμος καὶ ἡ θάλασσα ⸀ὑπακούειαὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Καὶ ἦλθον εἰς τὸ πέραν τῆς θαλάσσης εἰς τὴν χώραν τῶν ⸀Γερασηνῶν ");
INSERT INTO grcsbl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","καὶ ⸂ἐξελθόντος αὐτοῦ ἐκ τοῦ πλοίου ⸂εὐθὺς ὑπήντησεν αὐτῷ ἐκ τῶν μνημείων ἄνθρωπος ἐν πνεύματι ἀκαθάρτῳ, ");
INSERT INTO grcsbl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ὃς τὴν κατοίκησιν εἶχεν ἐν τοῖς μνήμασιν, καὶ ⸂οὐδὲ ἁλύσει οὐκέτι οὐδεὶς ἐδύνατο αὐτὸν δῆσαι ");
INSERT INTO grcsbl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","διὰ τὸ αὐτὸν πολλάκις πέδαις καὶ ἁλύσεσι δεδέσθαι καὶ διεσπάσθαι ὑπʼ αὐτοῦ τὰς ἁλύσεις καὶ τὰς πέδας συντετρῖφθαι, καὶ οὐδεὶς ⸂ἴσχυεν αὐτὸν δαμάσαι· ");
INSERT INTO grcsbl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","καὶ διὰ παντὸς νυκτὸς καὶ ἡμέρας ἐν τοῖς ⸂μνήμασιν καὶ ἐν τοῖς ὄρεσιν ἦν κράζων καὶ κατακόπτων ἑαυτὸν λίθοις. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","⸂καὶ ἰδὼν τὸν Ἰησοῦν ἀπὸ μακρόθεν ἔδραμεν καὶ προσεκύνησεν ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","καὶ κράξας φωνῇ μεγάλῃ ⸀λέγει Τί ἐμοὶ καὶ σοί, Ἰησοῦ υἱὲ τοῦ θεοῦ τοῦ ὑψίστου; ὁρκίζω σε τὸν θεόν, μή με βασανίσῃς. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ἔλεγεν γὰρ αὐτῷ· Ἔξελθε τὸ πνεῦμα τὸ ἀκάθαρτον ἐκ τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","καὶ ἐπηρώτα αὐτόν· Τί ⸂ὄνομά σοι; καὶ ⸂λέγει αὐτῷ· ⸀Λεγιὼνὄνομά μοι, ὅτι πολλοί ἐσμεν· ");
INSERT INTO grcsbl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","καὶ παρεκάλει αὐτὸν πολλὰ ἵνα μὴ ⸀αὐτὰἀποστείλῃ ἔξω τῆς χώρας. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ἦν δὲ ἐκεῖ πρὸς τῷ ὄρει ἀγέλη χοίρων μεγάλη βοσκομένη· ");
INSERT INTO grcsbl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","καὶ παρεκάλεσαν ⸀αὐτὸνλέγοντες· Πέμψον ἡμᾶς εἰς τοὺς χοίρους, ἵνα εἰς αὐτοὺς εἰσέλθωμεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","καὶ ἐπέτρεψεν ⸀αὐτοῖς καὶ ἐξελθόντα τὰ πνεύματα τὰ ἀκάθαρτα εἰσῆλθον εἰς τοὺς χοίρους, καὶ ὥρμησεν ἡ ἀγέλη κατὰ τοῦ κρημνοῦ εἰς τὴν θάλασσαν, ⸀ὡςδισχίλιοι, καὶ ἐπνίγοντο ἐν τῇ θαλάσσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","⸂Καὶ οἱ βόσκοντες ⸀αὐτοὺςἔφυγον καὶ ⸀ἀπήγγειλανεἰς τὴν πόλιν καὶ εἰς τοὺς ἀγρούς· καὶ ⸀ἦλθονἰδεῖν τί ἐστιν τὸ γεγονός. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","καὶ ἔρχονται πρὸς τὸν Ἰησοῦν, καὶ θεωροῦσιν τὸν δαιμονιζόμενον ⸀καθήμενονἱματισμένον καὶ σωφρονοῦντα, τὸν ἐσχηκότα τὸν ⸀λεγιῶνα καὶ ἐφοβήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","⸂καὶ διηγήσαντο αὐτοῖς οἱ ἰδόντες πῶς ἐγένετο τῷ δαιμονιζομένῳ καὶ περὶ τῶν χοίρων. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","καὶ ἤρξαντο παρακαλεῖν αὐτὸν ἀπελθεῖν ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","καὶ ⸀ἐμβαίνοντοςαὐτοῦ εἰς τὸ πλοῖον παρεκάλει αὐτὸν ὁ δαιμονισθεὶς ἵνα ⸂μετʼ αὐτοῦ ᾖ . ");
INSERT INTO grcsbl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","⸀καὶοὐκ ἀφῆκεν αὐτόν, ἀλλὰ λέγει αὐτῷ· Ὕπαγε εἰς τὸν οἶκόν σου πρὸς τοὺς σούς, καὶ ⸀ἀπάγγειλοναὐτοῖς ὅσα ⸂ὁ κύριός σοι πεποίηκεν καὶ ἠλέησέν σε. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","καὶ ἀπῆλθεν καὶ ἤρξατο κηρύσσειν ἐν τῇ Δεκαπόλει ὅσα ἐποίησεν αὐτῷ ὁ Ἰησοῦς, καὶ πάντες ἐθαύμαζον. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Καὶ διαπεράσαντος τοῦ Ἰησοῦ ἐν τῷ πλοίῳ πάλιν εἰς τὸ πέραν συνήχθη ὄχλος πολὺς ἐπʼ αὐτόν, καὶ ἦν παρὰ τὴν θάλασσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","⸀καὶἔρχεται εἷς τῶν ἀρχισυναγώγων, ὀνόματι Ἰάϊρος, καὶ ἰδὼν αὐτὸν πίπτει πρὸς τοὺς πόδας αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","καὶ ⸀παρακαλεῖαὐτὸν πολλὰ λέγων ὅτι Τὸ θυγάτριόν μου ἐσχάτως ἔχει, ἵνα ἐλθὼν ἐπιθῇς ⸂τὰς χεῖρας αὐτῇ ⸀ἵνασωθῇ καὶ ⸀ζήσῃ ");
INSERT INTO grcsbl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","καὶ ἀπῆλθεν μετʼ αὐτοῦ. Καὶ ἠκολούθει αὐτῷ ὄχλος πολύς, καὶ συνέθλιβον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","καὶ ⸀γυνὴοὖσα ἐν ῥύσει αἵματος ⸂δώδεκα ἔτη ");
INSERT INTO grcsbl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","καὶ πολλὰ παθοῦσα ὑπὸ πολλῶν ἰατρῶν καὶ δαπανήσασα τὰ παρʼ αὐτῆς πάντα καὶ μηδὲν ὠφεληθεῖσα ἀλλὰ μᾶλλον εἰς τὸ χεῖρον ἐλθοῦσα, ");
INSERT INTO grcsbl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","⸀ἀκούσασαπερὶ τοῦ Ἰησοῦ, ἐλθοῦσα ἐν τῷ ὄχλῳ ὄπισθεν ἥψατο τοῦ ἱματίου αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ἔλεγεν γὰρ ὅτι ⸂Ἐὰν ἅψωμαι κἂν τῶν ἱματίων αὐτοῦ σωθήσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","καὶ ⸀εὐθὺςἐξηράνθη ἡ πηγὴ τοῦ αἵματος αὐτῆς, καὶ ἔγνω τῷ σώματι ὅτι ἴαται ἀπὸ τῆς μάστιγος. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","καὶ ⸀εὐθὺςὁ Ἰησοῦς ἐπιγνοὺς ἐν ἑαυτῷ τὴν ἐξ αὐτοῦ δύναμιν ἐξελθοῦσαν ἐπιστραφεὶς ἐν τῷ ὄχλῳ ἔλεγεν· Τίς μου ἥψατο τῶν ἱματίων; ");
INSERT INTO grcsbl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","καὶ ἔλεγον αὐτῷ οἱ μαθηταὶ αὐτοῦ· Βλέπεις τὸν ὄχλον συνθλίβοντά σε, καὶ λέγεις· Τίς μου ἥψατο; ");
INSERT INTO grcsbl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","καὶ περιεβλέπετο ἰδεῖν τὴν τοῦτο ποιήσασαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ἡ δὲ γυνὴ φοβηθεῖσα καὶ τρέμουσα, εἰδυῖα ὃ γέγονεν ⸀αὐτῇ ἦλθεν καὶ προσέπεσεν αὐτῷ καὶ εἶπεν αὐτῷ πᾶσαν τὴν ἀλήθειαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ὁ δὲ εἶπεν αὐτῇ· ⸀Θυγάτηρ ἡ πίστις σου σέσωκέν σε· ὕπαγε εἰς εἰρήνην, καὶ ἴσθι ὑγιὴς ἀπὸ τῆς μάστιγός σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ἔτι αὐτοῦ λαλοῦντος ἔρχονται ἀπὸ τοῦ ἀρχισυναγώγου λέγοντες ὅτι Ἡ θυγάτηρ σου ἀπέθανεν· τί ἔτι σκύλλεις τὸν διδάσκαλον; ");
INSERT INTO grcsbl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ὁ δὲ Ἰησοῦς ⸀παρακούσαςτὸν λόγον λαλούμενον λέγει τῷ ἀρχισυναγώγῳ· Μὴ φοβοῦ, μόνον πίστευε. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","καὶ οὐκ ἀφῆκεν οὐδένα ⸂μετʼ αὐτοῦ συνακολουθῆσαι εἰ μὴ ⸀τὸνΠέτρον καὶ Ἰάκωβον καὶ Ἰωάννην τὸν ἀδελφὸν Ἰακώβου. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","καὶ ⸀ἔρχονταιεἰς τὸν οἶκον τοῦ ἀρχισυναγώγου, καὶθεωρεῖ θόρυβον ⸀καὶ κλαίοντας καὶ ἀλαλάζοντας πολλά, ");
INSERT INTO grcsbl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","καὶ εἰσελθὼν λέγει αὐτοῖς· Τί θορυβεῖσθε καὶ κλαίετε; τὸ παιδίον οὐκ ἀπέθανεν ἀλλὰ καθεύδει. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","καὶ κατεγέλων αὐτοῦ. ⸀αὐτὸςδὲ ἐκβαλὼν πάντας παραλαμβάνει τὸν πατέρα τοῦ παιδίου καὶ τὴν μητέρα καὶ τοὺς μετʼ αὐτοῦ, καὶ εἰσπορεύεται ὅπου ἦν τὸ ⸀παιδίον ");
INSERT INTO grcsbl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","καὶ κρατήσας τῆς χειρὸς τοῦ παιδίου λέγει αὐτῇ· Ταλιθα ⸀κουμ ὅ ἐστιν μεθερμηνευόμενον· Τὸ κοράσιον, σοὶ λέγω, ⸀ἔγειρε ");
INSERT INTO grcsbl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","καὶ ⸀εὐθὺςἀνέστη τὸ κοράσιον καὶ περιεπάτει, ἦν γὰρ ἐτῶν δώδεκα. καὶ ἐξέστησαν ⸁εὐθὺςἐκστάσει μεγάλῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","καὶ διεστείλατο αὐτοῖς πολλὰ ἵνα μηδεὶς γνοῖ τοῦτο, καὶ εἶπεν δοθῆναι αὐτῇ φαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Καὶ ἐξῆλθεν ἐκεῖθεν, καὶ ⸀ἔρχεταιεἰς τὴν πατρίδα αὐτοῦ, καὶ ἀκολουθοῦσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","καὶ γενομένου σαββάτου ἤρξατο ⸂διδάσκειν ἐν τῇ συναγωγῇ· καὶ ⸀οἱπολλοὶ ἀκούοντες ἐξεπλήσσοντο λέγοντες· Πόθεν τούτῳταῦτα, καὶ τίς ἡ σοφία ἡ δοθεῖσα ⸀τούτῳ, καὶ ⸀αἱδυνάμεις τοιαῦται διὰ τῶν χειρῶν αὐτοῦ ⸀γινόμεναι ");
INSERT INTO grcsbl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","οὐχ οὗτός ἐστιν ὁ τέκτων, ὁ υἱὸς ⸀τῆςΜαρίας ⸂καὶ ἀδελφὸς Ἰακώβου καὶ ⸀Ἰωσῆτοςκαὶ Ἰούδα καὶ Σίμωνος; καὶ οὐκ εἰσὶν αἱ ἀδελφαὶ αὐτοῦ ὧδε πρὸς ἡμᾶς; καὶ ἐσκανδαλίζοντο ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","⸂καὶ ἔλεγεν αὐτοῖς ὁ Ἰησοῦς ὅτι Οὐκ ἔστιν προφήτης ἄτιμος εἰ μὴ ἐν τῇ πατρίδι αὐτοῦ καὶ ἐν τοῖς ⸂συγγενεῦσιν αὐτοῦ καὶ ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","καὶ οὐκ ἐδύνατο ἐκεῖ ⸂ποιῆσαι οὐδεμίαν δύναμιν, εἰ μὴ ὀλίγοις ἀρρώστοις ἐπιθεὶς τὰς χεῖρας ἐθεράπευσεν· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","καὶ ⸀ἐθαύμαζενδιὰ τὴν ἀπιστίαν αὐτῶν. Καὶ περιῆγεν τὰς κώμας κύκλῳ διδάσκων. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","καὶ προσκαλεῖται τοὺς δώδεκα, καὶ ἤρξατο αὐτοὺς ἀποστέλλειν δύο δύο, καὶ ἐδίδου αὐτοῖς ἐξουσίαν τῶν πνευμάτων τῶν ἀκαθάρτων, ");
INSERT INTO grcsbl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","καὶ παρήγγειλεν αὐτοῖς ἵνα μηδὲν αἴρωσιν εἰς ὁδὸν εἰ μὴ ῥάβδον μόνον, μὴ ⸂ἄρτον, μὴ πήραν⸃, μὴ εἰς τὴν ζώνην χαλκόν, ");
INSERT INTO grcsbl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ἀλλὰ ὑποδεδεμένους σανδάλια, καὶ μὴ ⸀ἐνδύσησθεδύο χιτῶνας. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","καὶ ἔλεγεν αὐτοῖς· Ὅπου ⸀ἐὰνεἰσέλθητε εἰς οἰκίαν, ἐκεῖ μένετε ἕως ἂν ἐξέλθητε ἐκεῖθεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","καὶ ⸂ὃς ἂν τόπος μὴ δέξηται ὑμᾶς μηδὲ ἀκούσωσιν ὑμῶν, ἐκπορευόμενοι ἐκεῖθεν ἐκτινάξατε τὸν χοῦν τὸν ὑποκάτω τῶν ποδῶν ὑμῶν εἰς μαρτύριον ⸀αὐτοῖς ");
INSERT INTO grcsbl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Καὶ ἐξελθόντες ⸀ἐκήρυξανἵνα ⸀μετανοῶσιν ");
INSERT INTO grcsbl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","καὶ δαιμόνια πολλὰ ἐξέβαλλον, καὶ ἤλειφον ἐλαίῳ πολλοὺς ἀρρώστους καὶ ἐθεράπευον. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Καὶ ἤκουσεν ὁ βασιλεὺς Ἡρῴδης, φανερὸν γὰρ ἐγένετο τὸ ὄνομα αὐτοῦ, καὶ ⸀ἔλεγονὅτι Ἰωάννης ὁ βαπτίζων ⸂ἐγήγερται ἐκ νεκρῶν, καὶ διὰ τοῦτο ἐνεργοῦσιν αἱ δυνάμεις ἐν αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ἄλλοι ⸀δὲἔλεγον ὅτι Ἠλίας ἐστίν· ἄλλοι δὲ ἔλεγον ὅτι ⸀προφήτηςὡς εἷς τῶν προφητῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ἀκούσας δὲ ⸀ὁἩρῴδης ⸀ἔλεγεν Ὃν ἐγὼ ἀπεκεφάλισα Ἰωάννην, οὗτος ⸀ἠγέρθη ");
INSERT INTO grcsbl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Αὐτὸς γὰρ ὁ Ἡρῴδης ἀποστείλας ἐκράτησεν τὸν Ἰωάννην καὶ ἔδησεν αὐτὸν ἐν φυλακῇ διὰ Ἡρῳδιάδα τὴν γυναῖκα Φιλίππου τοῦ ἀδελφοῦ αὐτοῦ, ὅτι αὐτὴν ἐγάμησεν· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ἔλεγεν γὰρ ὁ Ἰωάννης τῷ Ἡρῴδῃ ὅτι Οὐκ ἔξεστίν σοι ἔχειν τὴν γυναῖκα τοῦ ἀδελφοῦ σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ἡ δὲ Ἡρῳδιὰς ἐνεῖχεν αὐτῷ καὶ ἤθελεν αὐτὸν ἀποκτεῖναι, καὶ οὐκ ἠδύνατο· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ὁ γὰρ Ἡρῴδης ἐφοβεῖτο τὸν Ἰωάννην, εἰδὼς αὐτὸν ἄνδρα δίκαιον καὶ ἅγιον, καὶ συνετήρει αὐτόν, καὶ ἀκούσας αὐτοῦ πολλὰ ⸀ἠπόρει καὶ ἡδέως αὐτοῦ ἤκουεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Καὶ γενομένης ἡμέρας εὐκαίρου ὅτε Ἡρῴδης τοῖς γενεσίοις αὐτοῦ δεῖπνον ⸀ἐποίησεντοῖς μεγιστᾶσιν αὐτοῦ καὶ τοῖς χιλιάρχοις καὶ τοῖς πρώτοις τῆς Γαλιλαίας, ");
INSERT INTO grcsbl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","καὶ εἰσελθούσης τῆς θυγατρὸς ⸂αὐτῆς τῆς Ἡρῳδιάδος καὶ ὀρχησαμένης ⸂καὶ ἀρεσάσης τῷ Ἡρῴδῃ καὶ τοῖς συνανακειμένοις, ⸂εἶπεν ὁ βασιλεὺς τῷ κορασίῳ· Αἴτησόν με ὃ ἐὰν θέλῃς, καὶ δώσω σοι· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","καὶ ὤμοσεν ⸀αὐτῇ ⸂Ὅ τι ἐάν με αἰτήσῃς δώσω σοι ἕως ἡμίσους τῆς βασιλείας μου. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","⸀καὶἐξελθοῦσα εἶπεν τῇ μητρὶ αὐτῆς· Τί ⸀αἰτήσωμαι ἡ δὲ εἶπεν· Τὴν κεφαλὴν Ἰωάννου τοῦ ⸀βαπτίζοντος ");
INSERT INTO grcsbl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","καὶ εἰσελθοῦσα ⸀εὐθὺςμετὰ σπουδῆς πρὸς τὸν βασιλέα ᾐτήσατο λέγουσα· Θέλω ἵνα ⸂ἐξαυτῆς δῷς μοι ἐπὶ πίνακι τὴν κεφαλὴν Ἰωάννου τοῦ βαπτιστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","καὶ περίλυπος γενόμενος ὁ βασιλεὺς διὰ τοὺς ὅρκους καὶ τοὺς ⸀ἀνακειμένουςοὐκ ἠθέλησεν ⸂ἀθετῆσαι αὐτήν· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","καὶ ⸀εὐθὺςἀποστείλας ὁ βασιλεὺς σπεκουλάτορα ἐπέταξεν ⸀ἐνέγκαιτὴν κεφαλὴν αὐτοῦ. ⸀καὶἀπελθὼν ἀπεκεφάλισεν αὐτὸν ἐν τῇ φυλακῇ ");
INSERT INTO grcsbl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","καὶ ἤνεγκεν τὴν κεφαλὴν αὐτοῦ ἐπὶ πίνακι καὶ ἔδωκεν αὐτὴν τῷ κορασίῳ, καὶ τὸ κοράσιον ἔδωκεν αὐτὴν τῇ μητρὶ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","καὶ ἀκούσαντες οἱ μαθηταὶ αὐτοῦ ἦλθον καὶ ἦραν τὸ πτῶμα αὐτοῦ καὶ ἔθηκαν αὐτὸ ἐν μνημείῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Καὶ συνάγονται οἱ ἀπόστολοι πρὸς τὸν Ἰησοῦν, καὶ ἀπήγγειλαν αὐτῷ ⸀πάνταὅσα ἐποίησαν καὶ ὅσα ἐδίδαξαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","καὶ ⸀λέγειαὐτοῖς· Δεῦτε ὑμεῖς αὐτοὶ κατʼ ἰδίαν εἰς ἔρημον τόπον καὶ ⸀ἀναπαύσασθεὀλίγον. ἦσαν γὰρ οἱ ἐρχόμενοι καὶ οἱ ὑπάγοντες πολλοί, καὶ οὐδὲ φαγεῖν εὐκαίρουν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","καὶ ἀπῆλθον ⸂ἐν τῷ πλοίῳ εἰς ἔρημον τόπον κατʼ ἰδίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","καὶ εἶδον αὐτοὺς ὑπάγοντας καὶ ⸀ἐπέγνωσανπολλοί, καὶ πεζῇ ἀπὸ πασῶν τῶν πόλεων συνέδραμον ἐκεῖ καὶ προῆλθον ⸀αὐτούς ");
INSERT INTO grcsbl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","καὶ ἐξελθὼν ⸀εἶδενπολὺν ὄχλον, καὶ ἐσπλαγχνίσθη ἐπʼ ⸀αὐτοὺςὅτι ἦσαν ὡς πρόβατα μὴ ἔχοντα ποιμένα, καὶ ἤρξατο διδάσκειν αὐτοὺς πολλά. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Καὶ ἤδη ὥρας πολλῆς γενομένης προσελθόντες αὐτῷ οἱ μαθηταὶ αὐτοῦ ⸀ἔλεγονὅτι Ἔρημός ἐστιν ὁ τόπος, καὶ ἤδη ὥρα πολλή· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ἀπόλυσον αὐτούς, ἵνα ἀπελθόντες εἰς τοὺς κύκλῳ ἀγροὺς καὶ κώμας ἀγοράσωσιν ἑαυτοῖς ⸂τί φάγωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς· Δότε αὐτοῖς ὑμεῖς φαγεῖν. καὶ λέγουσιν αὐτῷ· Ἀπελθόντες ἀγοράσωμεν δηναρίων διακοσίων ἄρτους καὶ ⸀δώσομεναὐτοῖς φαγεῖν; ");
INSERT INTO grcsbl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ὁ δὲ λέγει αὐτοῖς· Πόσους ⸂ἔχετε ἄρτους; ⸀ὑπάγετεἴδετε. καὶ γνόντες λέγουσιν· Πέντε, καὶ δύο ἰχθύας. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","καὶ ἐπέταξεν αὐτοῖς ⸀ἀνακλῖναιπάντας συμπόσια συμπόσια ἐπὶ τῷ χλωρῷ χόρτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","καὶ ἀνέπεσαν πρασιαὶ πρασιαὶ ⸀κατὰἑκατὸν καὶ ⸁κατὰπεντήκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","καὶ λαβὼν τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας ἀναβλέψας εἰς τὸν οὐρανὸν εὐλόγησεν καὶ κατέκλασεν τοὺς ἄρτους καὶ ἐδίδου τοῖς μαθηταῖς ⸀αὐτοῦἵνα ⸀παρατιθῶσιναὐτοῖς, καὶ τοὺς δύο ἰχθύας ἐμέρισεν πᾶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","καὶ ἔφαγον πάντες καὶ ἐχορτάσθησαν· ");
INSERT INTO grcsbl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","καὶ ἦραν ⸂κλάσματα δώδεκα κοφίνων πληρώματα καὶ ἀπὸ τῶν ἰχθύων. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","καὶ ἦσαν οἱ φαγόντες ⸂τοὺς ἄρτους πεντακισχίλιοι ἄνδρες. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Καὶ ⸀εὐθὺςἠνάγκασεν τοὺς μαθητὰς αὐτοῦ ἐμβῆναι εἰς τὸ πλοῖον καὶ προάγειν ⸂εἰς τὸ πέραν πρὸς Βηθσαϊδάν, ἕως αὐτὸς ⸀ἀπολύειτὸν ὄχλον. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","καὶ ἀποταξάμενος αὐτοῖς ἀπῆλθεν εἰς τὸ ὄρος προσεύξασθαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Καὶ ὀψίας γενομένης ἦν τὸ πλοῖον ἐν μέσῳ τῆς θαλάσσης, καὶ αὐτὸς μόνος ἐπὶ τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","καὶ ⸀ἰδὼναὐτοὺς βασανιζομένους ἐν τῷ ἐλαύνειν, ἦν γὰρ ὁ ἄνεμος ἐναντίος ⸀αὐτοῖς περὶ τετάρτην φυλακὴν τῆς νυκτὸς ἔρχεται πρὸς αὐτοὺς περιπατῶν ἐπὶ τῆς θαλάσσης· καὶ ἤθελεν παρελθεῖν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","οἱ δὲ ἰδόντες αὐτὸν ⸂ἐπὶ τῆς θαλάσσης περιπατοῦντα ἔδοξαν ⸂ὅτι φάντασμά ἐστιν καὶ ἀνέκραξαν, ");
INSERT INTO grcsbl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","πάντες γὰρ αὐτὸν εἶδον καὶ ἐταράχθησαν. ⸂ὁ δὲ εὐθὺς ἐλάλησεν μετʼ αὐτῶν, καὶ λέγει αὐτοῖς· Θαρσεῖτε, ἐγώ εἰμι, μὴ φοβεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","καὶ ἀνέβη πρὸς αὐτοὺς εἰς τὸ πλοῖον, καὶ ἐκόπασεν ὁ ἄνεμος. καὶ λίαν ⸂ἐκ περισσοῦ ἐν ἑαυτοῖς ⸀ἐξίσταντο ");
INSERT INTO grcsbl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","οὐ γὰρ συνῆκαν ἐπὶ τοῖς ἄρτοις, ⸂ἀλλʼ ἦν αὐτῶν ἡ καρδία πεπωρωμένη. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Καὶ διαπεράσαντες ⸂ἐπὶ τὴν γῆν ἦλθον εἰς Γεννησαρὲτ καὶ προσωρμίσθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","καὶ ἐξελθόντων αὐτῶν ἐκ τοῦ πλοίου ⸀εὐθὺςἐπιγνόντες αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","⸂περιέδραμον ὅλην τὴν χώραν ἐκείνην καὶ ἤρξαντο ἐπὶ τοῖς κραβάττοις τοὺς κακῶς ἔχοντας περιφέρειν ὅπου ἤκουον ⸀ὅτιἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","καὶ ὅπου ἂν εἰσεπορεύετο εἰς κώμας ἢ ⸂εἰς πόλεις ἢ εἰς ἀγροὺς ἐν ταῖς ἀγοραῖς ⸀ἐτίθεσαντοὺς ἀσθενοῦντας, καὶ παρεκάλουν αὐτὸν ἵνα κἂν τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ ἅψωνται· καὶ ὅσοι ἂν ⸀ἥψαντοαὐτοῦ ἐσῴζοντο. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Καὶ συνάγονται πρὸς αὐτὸν οἱ Φαρισαῖοι καί τινες τῶν γραμματέων ἐλθόντες ἀπὸ Ἱεροσολύμων ");
INSERT INTO grcsbl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","καὶ ἰδόντες τινὰς τῶν μαθητῶν αὐτοῦ ⸂ὅτι κοιναῖς χερσίν, τοῦτʼ ἔστιν ἀνίπτοις, ἐσθίουσιν ⸀τοὺς⸀ἄρτους ");
INSERT INTO grcsbl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","οἱ γὰρ Φαρισαῖοι καὶ πάντες οἱ Ἰουδαῖοι ἐὰν μὴ πυγμῇ νίψωνται τὰς χεῖρας οὐκ ἐσθίουσιν, κρατοῦντες τὴν παράδοσιν τῶν πρεσβυτέρων, ");
INSERT INTO grcsbl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","καὶ ἀπʼ ⸀ἀγορᾶςἐὰν μὴ ⸀βαπτίσωνταιοὐκ ἐσθίουσιν, καὶ ἄλλα πολλά ἐστιν ἃ παρέλαβον κρατεῖν, βαπτισμοὺς ποτηρίων καὶ ξεστῶν καὶ χαλκίων ⸂καὶ κλινῶν— ");
INSERT INTO grcsbl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","⸀καὶἐπερωτῶσιν αὐτὸν οἱ Φαρισαῖοι καὶ οἱ γραμματεῖς· Διὰ τί ⸂οὐ περιπατοῦσιν οἱ μαθηταί σου κατὰ τὴν παράδοσιν τῶν πρεσβυτέρων, ἀλλὰ ⸀κοιναῖςχερσὶν ἐσθίουσιν τὸν ἄρτον; ");
INSERT INTO grcsbl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ὁ ⸀δὲεἶπεν ⸀αὐτοῖς Καλῶς ἐπροφήτευσεν Ἠσαΐας περὶ ὑμῶν τῶν ὑποκριτῶν, ὡς γέγραπται ⸀ὅτιΟὗτος ὁ λαὸς τοῖς χείλεσίν με τιμᾷ, ἡ δὲ καρδία αὐτῶν πόρρω ἀπέχει ἀπʼ ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","μάτην δὲ σέβονταί με, διδάσκοντες διδασκαλίας ἐντάλματα ἀνθρώπων· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","⸀ἀφέντεςτὴν ἐντολὴν τοῦ θεοῦ κρατεῖτε τὴν παράδοσιν τῶν ⸀ἀνθρώπων ");
INSERT INTO grcsbl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Καὶ ἔλεγεν αὐτοῖς· Καλῶς ἀθετεῖτε τὴν ἐντολὴν τοῦ θεοῦ, ἵνα τὴν παράδοσιν ὑμῶν ⸀τηρήσητε ");
INSERT INTO grcsbl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Μωϋσῆς γὰρ εἶπεν· Τίμα τὸν πατέρα σου καὶ τὴν μητέρα σου, καί· Ὁ κακολογῶν πατέρα ἢ μητέρα θανάτῳ τελευτάτω· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ὑμεῖς δὲ λέγετε· Ἐὰν εἴπῃ ἄνθρωπος τῷ πατρὶ ἢ τῇ μητρί· Κορβᾶν, ὅ ἐστιν Δῶρον, ὃ ἐὰν ἐξ ἐμοῦ ὠφεληθῇς, ");
INSERT INTO grcsbl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","⸀οὐκέτιἀφίετε αὐτὸν οὐδὲν ποιῆσαι τῷ ⸀πατρὶἢ τῇ ⸀μητρί ");
INSERT INTO grcsbl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ἀκυροῦντες τὸν λόγον τοῦ θεοῦ τῇ παραδόσει ὑμῶν ᾗ παρεδώκατε· καὶ παρόμοια τοιαῦτα πολλὰ ποιεῖτε. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Καὶ προσκαλεσάμενος ⸀πάλιντὸν ὄχλον ἔλεγεν αὐτοῖς· ⸀Ἀκούσατέμου πάντες καὶ ⸀σύνετε ");
INSERT INTO grcsbl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","οὐδέν ἐστιν ἔξωθεν τοῦ ἀνθρώπου εἰσπορευόμενον εἰς αὐτὸν ὃ δύναται ⸂κοινῶσαι αὐτόν· ἀλλὰ τὰ ⸂ἐκ τοῦ ἀνθρώπου ἐκπορευόμενά ἐστιν τὰ κοινοῦντα τὸν ⸀ἄνθρωπον ");
INSERT INTO grcsbl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Καὶ ὅτε εἰσῆλθεν ⸀εἰςοἶκον ἀπὸ τοῦ ὄχλου, ἐπηρώτων αὐτὸν οἱ μαθηταὶ αὐτοῦ ⸂τὴν παραβολήν. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","καὶ λέγει αὐτοῖς· Οὕτως καὶ ὑμεῖς ἀσύνετοί ἐστε; οὐ νοεῖτε ὅτι πᾶν τὸ ἔξωθεν εἰσπορευόμενον εἰς τὸν ἄνθρωπον οὐ δύναται αὐτὸν κοινῶσαι, ");
INSERT INTO grcsbl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ὅτι οὐκ εἰσπορεύεται αὐτοῦ εἰς τὴν καρδίαν ἀλλʼ εἰς τὴν κοιλίαν, καὶ εἰς τὸν ἀφεδρῶνα ἐκπορεύεται;— ⸀καθαρίζωνπάντα τὰ βρώματα. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ἔλεγεν δὲ ὅτι Τὸ ἐκ τοῦ ἀνθρώπου ἐκπορευόμενον ἐκεῖνο κοινοῖ τὸν ἄνθρωπον· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ἔσωθεν γὰρ ἐκ τῆς καρδίας τῶν ἀνθρώπων οἱ διαλογισμοὶ οἱ κακοὶ ἐκπορεύονται, ⸂πορνεῖαι, κλοπαί, φόνοι, ");
INSERT INTO grcsbl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","μοιχεῖαι⸃, πλεονεξίαι, πονηρίαι, δόλος, ἀσέλγεια, ὀφθαλμὸς πονηρός, βλασφημία, ὑπερηφανία, ἀφροσύνη· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","πάντα ταῦτα τὰ πονηρὰ ἔσωθεν ἐκπορεύεται καὶ κοινοῖ τὸν ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","⸂Ἐκεῖθεν δὲ ἀναστὰς ἀπῆλθεν εἰς τὰ ⸀ὅρια⸀Τύρου καὶ εἰσελθὼν εἰς οἰκίαν οὐδένα ἤθελεν γνῶναι, καὶ οὐκ ἠδυνήθη λαθεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","⸂ἀλλʼ εὐθὺς ἀκούσασα γυνὴ περὶ αὐτοῦ, ἧς εἶχεν τὸ θυγάτριον αὐτῆς πνεῦμα ἀκάθαρτον, ἐλθοῦσα προσέπεσεν πρὸς τοὺς πόδας αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","⸂ἡ δὲ γυνὴ ἦν Ἑλληνίς, Συροφοινίκισσα τῷ γένει· καὶ ἠρώτα αὐτὸν ἵνα τὸ δαιμόνιον ἐκβάλῃ ἐκ τῆς θυγατρὸς αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","⸂καὶ ἔλεγεν αὐτῇ· Ἄφες πρῶτον χορτασθῆναι τὰ τέκνα, οὐ γὰρ ⸂καλόν ἐστιν λαβεῖν τὸν ἄρτον τῶν τέκνων καὶ ⸂τοῖς κυναρίοις βαλεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ἡ δὲ ἀπεκρίθη καὶ λέγει αὐτῷ· ⸀Κύριε ⸀καὶτὰ κυνάρια ὑποκάτω τῆς τραπέζης ⸀ἐσθίουσινἀπὸ τῶν ψιχίων τῶν παιδίων. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","καὶ εἶπεν αὐτῇ· Διὰ τοῦτον τὸν λόγον ὕπαγε, ἐξελήλυθεν ⸂ἐκ τῆς θυγατρός σου τὸ δαιμόνιον. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","καὶ ἀπελθοῦσα εἰς τὸν οἶκον αὐτῆς εὗρεν τὸ ⸂παιδίον βεβλημένον ἐπὶ τὴν κλίνην καὶ τὸ δαιμόνιον ἐξεληλυθός. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Καὶ πάλιν ἐξελθὼν ἐκ τῶν ὁρίων Τύρου ⸂ἦλθεν διὰ Σιδῶνος εἰς τὴν θάλασσαν τῆς Γαλιλαίας ἀνὰ μέσον τῶν ὁρίων Δεκαπόλεως. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","καὶφέρουσιν αὐτῷ κωφὸν ⸀καὶ ⸀μογιλάλον καὶ παρακαλοῦσιν αὐτὸν ἵνα ἐπιθῇ αὐτῷ τὴν χεῖρα. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","καὶ ἀπολαβόμενος αὐτὸν ἀπὸ τοῦ ὄχλου κατʼ ἰδίαν ἔβαλεν τοὺς δακτύλους αὐτοῦ εἰς τὰ ὦτα αὐτοῦ καὶ πτύσας ἥψατο τῆς γλώσσης αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","καὶ ἀναβλέψας εἰς τὸν οὐρανὸν ἐστέναξεν, καὶ λέγει αὐτῷ· Εφφαθα, ὅ ἐστιν Διανοίχθητι· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","⸀καὶ⸀ἠνοίγησαναὐτοῦ αἱ ἀκοαί, καὶ ἐλύθη ὁ δεσμὸς τῆς γλώσσης αὐτοῦ, καὶ ἐλάλει ὀρθῶς· ");
INSERT INTO grcsbl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","καὶ διεστείλατο αὐτοῖς ἵνα μηδενὶ ⸀λέγωσιν ὅσον δὲ ⸂αὐτοῖς διεστέλλετο, αὐτοὶ⸃ μᾶλλον περισσότερον ἐκήρυσσον. ");
INSERT INTO grcsbl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","καὶὑπερπερισσῶς ἐξεπλήσσοντο λέγοντες· Καλῶς πάντα πεποίηκεν, καὶ τοὺς κωφοὺς ποιεῖ ἀκούειν ⸀καὶ ἀλάλους λαλεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ἐν ἐκείναις ταῖς ἡμέραις ⸂πάλιν πολλοῦ ὄχλου ὄντος καὶ μὴ ἐχόντων τί φάγωσιν, ⸀προσκαλεσάμενος τοὺς ⸀μαθητὰς λέγει αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Σπλαγχνίζομαι ἐπὶ τὸν ὄχλον ὅτι ἤδη ἡμέραι τρεῖς προσμένουσίν μοι καὶ οὐκ ἔχουσιν τί φάγωσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","αὶ ἐὰν ἀπολύσω αὐτοὺς νήστεις εἰς οἶκον αὐτῶν, ἐκλυθήσονται ἐν τῇ ὁδῷ· ⸂καί τινες⸃ αὐτῶν ⸀ἀπὸμακρόθεν ⸀ἥκασιν ");
INSERT INTO grcsbl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","καὶ ἀπεκρίθησαν αὐτῷ οἱ μαθηταὶ αὐτοῦ ⸀ὅτιΠόθεν τούτους δυνήσεταί τις ὧδε χορτάσαι ἄρτων ἐπʼ ἐρημίας; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","καὶ ⸀ἠρώτααὐτούς· Πόσους ἔχετε ἄρτους; οἱ δὲ εἶπαν· Ἑπτά. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","καὶ ⸀παραγγέλλειτῷ ὄχλῳ ἀναπεσεῖν ἐπὶ τῆς γῆς· καὶ λαβὼν τοὺς ἑπτὰ ἄρτους εὐχαριστήσας ἔκλασεν καὶ ἐδίδου τοῖς μαθηταῖς αὐτοῦ ἵνα ⸀παρατιθῶσινκαὶ παρέθηκαν τῷ ὄχλῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","καὶ εἶχον ἰχθύδια ὀλίγα· καὶ εὐλογήσας ⸀αὐτὰεἶπεν ⸂καὶ ταῦτα παρατιθέναι. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","⸂καὶ ἔφαγον καὶ ἐχορτάσθησαν, καὶ ἦραν περισσεύματα κλασμάτων ἑπτὰ σπυρίδας. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ἦσαν ⸀δὲὡς τετρακισχίλιοι. καὶ ἀπέλυσεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","καὶ ⸀εὐθὺςἐμβὰς εἰς τὸ πλοῖον μετὰ τῶν μαθητῶν αὐτοῦ ἦλθεν εἰς τὰ μέρη Δαλμανουθά. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Καὶ ἐξῆλθον οἱ Φαρισαῖοι καὶ ἤρξαντο συζητεῖν αὐτῷ, ζητοῦντες παρʼ αὐτοῦ σημεῖον ἀπὸ τοῦ οὐρανοῦ, πειράζοντες αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","καὶ ἀναστενάξας τῷ πνεύματι αὐτοῦ λέγει· Τί ἡ γενεὰ αὕτη ⸂ζητεῖ σημεῖον; ἀμὴν λέγω ⸀ὑμῖν εἰ δοθήσεται τῇ γενεᾷ ταύτῃ σημεῖον. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","καὶ ἀφεὶς αὐτοὺς ⸂πάλιν ἐμβὰς ἀπῆλθεν εἰς τὸ πέραν. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Καὶ ἐπελάθοντο λαβεῖν ἄρτους, καὶ εἰ μὴ ἕνα ἄρτον οὐκ εἶχον μεθʼ ἑαυτῶν ἐν τῷ πλοίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","καὶ διεστέλλετο αὐτοῖς λέγων· Ὁρᾶτε, βλέπετε ἀπὸ τῆς ζύμης τῶν Φαρισαίων καὶ τῆς ζύμης Ἡρῴδου. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","καὶ διελογίζοντο πρὸς ⸀ἀλλήλουςὅτι ἄρτους οὐκ ⸀ἔχουσιν ");
INSERT INTO grcsbl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","καὶ ⸀γνοὺςλέγει αὐτοῖς· Τί διαλογίζεσθε ὅτι ἄρτους οὐκ ἔχετε; οὔπω νοεῖτε οὐδὲ συνίετε; ⸀πεπωρωμένηνἔχετε τὴν καρδίαν ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ὀφθαλμοὺς ἔχοντες οὐ βλέπετε καὶ ὦτα ἔχοντες οὐκ ἀκούετε; καὶ οὐ μνημονεύετε ");
INSERT INTO grcsbl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ὅτε τοὺς πέντε ἄρτους ἔκλασα εἰς τοὺς πεντακισχιλίους, πόσους κοφίνους ⸂κλασμάτων πλήρεις ἤρατε; λέγουσιν αὐτῷ· Δώδεκα. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ὅτε ⸀καὶτοὺς ἑπτὰ εἰς τοὺς τετρακισχιλίους, πόσων σπυρίδων πληρώματα κλασμάτων ἤρατε; ⸂καὶ λέγουσιν αὐτῷ· Ἑπτά. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","καὶ ἔλεγεν αὐτοῖς· ⸀Οὔπωσυνίετε; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Καὶ ⸀ἔρχονταιεἰς Βηθσαϊδάν. καὶ φέρουσιν αὐτῷ τυφλὸν καὶ παρακαλοῦσιν αὐτὸν ἵνα αὐτοῦ ἅψηται. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","καὶ ἐπιλαβόμενος τῆς χειρὸς τοῦ τυφλοῦ ⸀ἐξήνεγκεναὐτὸν ἔξω τῆς κώμης, καὶ πτύσας εἰς τὰ ὄμματα αὐτοῦ, ἐπιθεὶς τὰς χεῖρας αὐτῷ, ἐπηρώτα αὐτόν· Εἴ τι ⸀βλέπεις ");
INSERT INTO grcsbl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","καὶ ἀναβλέψας ἔλεγεν· Βλέπω τοὺς ἀνθρώπους ὅτι ὡς δένδρα ὁρῶ περιπατοῦντας. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","εἶτα πάλιν ⸀ἐπέθηκεντὰς χεῖρας ἐπὶ τοὺς ὀφθαλμοὺς αὐτοῦ, καὶ ⸂διέβλεψεν καὶ ἀπεκατέστη καὶ ἐνέβλεπεν τηλαυγῶς ⸀ἅπαντα ");
INSERT INTO grcsbl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","καὶ ἀπέστειλεν αὐτὸν ⸀εἰςοἶκον αὐτοῦ λέγων· Μηδὲ εἰς τὴν κώμην ⸀εἰσέλθῃς ");
INSERT INTO grcsbl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Καὶ ἐξῆλθεν ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὰς κώμας Καισαρείας τῆς Φιλίππου· καὶ ἐν τῇ ὁδῷ ἐπηρώτα τοὺς μαθητὰς αὐτοῦ λέγων αὐτοῖς· Τίνα με λέγουσιν οἱ ἄνθρωποι εἶναι; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","οἱ δὲ ⸂εἶπαν αὐτῷ λέγοντες ⸀ὅτιἸωάννην τὸν βαπτιστήν, καὶ ἄλλοι Ἠλίαν, ἄλλοι δὲ ⸂ὅτι εἷς τῶν προφητῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","καὶ αὐτὸς ⸂ἐπηρώτα αὐτούς· Ὑμεῖς δὲ τίνα με λέγετε εἶναι; ⸀ἀποκριθεὶςὁ Πέτρος λέγει αὐτῷ· Σὺ εἶ ὁ χριστός. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","καὶ ἐπετίμησεν αὐτοῖς ἵνα μηδενὶ λέγωσιν περὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Καὶ ἤρξατο διδάσκειν αὐτοὺς ὅτι δεῖ τὸν υἱὸν τοῦ ἀνθρώπου πολλὰ παθεῖν καὶ ἀποδοκιμασθῆναι ⸀ὑπὸτῶν πρεσβυτέρων καὶ τῶν ἀρχιερέων καὶ τῶν γραμματέων καὶ ἀποκτανθῆναι καὶ μετὰ τρεῖς ἡμέρας ἀναστῆναι· ");
INSERT INTO grcsbl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","καὶ παρρησίᾳ τὸν λόγον ἐλάλει. καὶ προσλαβόμενος ⸂ὁ Πέτρος αὐτὸν ἤρξατο ἐπιτιμᾶν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ὁ δὲ ἐπιστραφεὶς καὶ ἰδὼν τοὺς μαθητὰς αὐτοῦ ἐπετίμησεν ⸀Πέτρῳ⸂καὶ λέγει· Ὕπαγε ὀπίσω μου, Σατανᾶ, ὅτι οὐ φρονεῖς τὰ τοῦ θεοῦ ἀλλὰ τὰ τῶν ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Καὶ προσκαλεσάμενος τὸν ὄχλον σὺν τοῖς μαθηταῖς αὐτοῦ εἶπεν αὐτοῖς· ⸂Εἴ τις θέλει ὀπίσω μου ⸀ἐλθεῖν ἀπαρνησάσθω ἑαυτὸν καὶ ἀράτω τὸν σταυρὸν αὐτοῦ καὶ ἀκολουθείτω μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ὃς γὰρ ⸀ἐὰνθέλῃ τὴν ⸂ψυχὴν αὐτοῦ⸃σῶσαι ἀπολέσειαὐτήν· ὃς δʼ ἂν ⸀ἀπολέσει τὴν ⸄ψυχὴν αὐτοῦ⸅ἕνεκεν ἐμοῦ καὶ τοῦ εὐαγγελίου ⸀σώσειαὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","τί γὰρ ⸀ὠφελεῖ⸀ἄνθρωπον⸂κερδῆσαι τὸν κόσμον ὅλον καὶ ζημιωθῆναι τὴν ψυχὴν αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","⸂τί γὰρ ⸀δοῖἄνθρωπος ἀντάλλαγμα τῆς ψυχῆς αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ὃς γὰρ ἐὰν ἐπαισχυνθῇ με καὶ τοὺς ἐμοὺς λόγους ἐν τῇ γενεᾷ ταύτῃ τῇ μοιχαλίδι καὶ ἁμαρτωλῷ, καὶ ὁ υἱὸς τοῦ ἀνθρώπου ἐπαισχυνθήσεται αὐτὸν ὅταν ἔλθῃ ἐν τῇ δόξῃ τοῦ πατρὸς αὐτοῦ μετὰ τῶν ἀγγέλων τῶν ἁγίων. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","καὶ ἔλεγεν αὐτοῖς· Ἀμὴν λέγω ὑμῖν ὅτι εἰσίν τινες ⸂τῶν ὧδε ἑστηκότων οἵτινες οὐ μὴ γεύσωνται θανάτου ἕως ἂν ἴδωσιν τὴν βασιλείαν τοῦ θεοῦ ἐληλυθυῖαν ἐν δυνάμει. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Καὶ μετὰ ἡμέρας ἓξ παραλαμβάνει ὁ Ἰησοῦς τὸν Πέτρον καὶτὸν Ἰάκωβον ⸀καὶ Ἰωάννην, καὶ ἀναφέρει αὐτοὺς εἰς ὄρος ὑψηλὸν κατʼ ἰδίαν μόνους. καὶ μετεμορφώθη ἔμπροσθεν αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","καὶ τὰ ἱμάτια αὐτοῦ ⸀ἐγένετοστίλβοντα λευκὰ ⸀λίανοἷα γναφεὺς ἐπὶ τῆς γῆς οὐ δύναται ⸀οὕτωςλευκᾶναι. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","καὶ ὤφθη αὐτοῖς Ἠλίας σὺν Μωϋσεῖ, καὶ ἦσαν συλλαλοῦντες τῷ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","καὶ ἀποκριθεὶς ὁ Πέτρος λέγει τῷ Ἰησοῦ· Ῥαββί, καλόν ἐστιν ἡμᾶς ὧδε εἶναι, καὶ ποιήσωμεν ⸂τρεῖς σκηνάς, σοὶ μίαν καὶ Μωϋσεῖ μίαν καὶ Ἠλίᾳ μίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","οὐ γὰρ ᾔδει τί ⸀ἀποκριθῇ ⸂ἔκφοβοι γὰρ ἐγένοντο. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","καὶ ἐγένετονεφέλη ἐπισκιάζουσα αὐτοῖς, καὶ ⸀ἐγένετο φωνὴ ἐκ τῆς νεφέλης· Οὗτός ἐστιν ὁ υἱός μου ὁ ἀγαπητός, ⸂ἀκούετε αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","καὶ ἐξάπινα περιβλεψάμενοι οὐκέτι οὐδένα εἶδον ⸂ἀλλὰ τὸν Ἰησοῦν μόνον μεθʼ ἑαυτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","⸂Καὶ καταβαινόντων αὐτῶν ⸀ἐκτοῦ ὄρους διεστείλατο αὐτοῖς ἵνα μηδενὶ ⸂ἃ εἶδον διηγήσωνται, εἰ μὴ ὅταν ὁ υἱὸς τοῦ ἀνθρώπου ἐκ νεκρῶν ἀναστῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","καὶ τὸν λόγον ἐκράτησαν πρὸς ἑαυτοὺς συζητοῦντες τί ἐστιν τὸ ἐκ νεκρῶν ἀναστῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","καὶ ἐπηρώτων αὐτὸν λέγοντες· Ὅτι λέγουσιν οἱ γραμματεῖς ὅτι Ἠλίαν δεῖ ἐλθεῖν πρῶτον; ");
INSERT INTO grcsbl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ὁ δὲ ⸀ἔφηαὐτοῖς· Ἠλίας μὲν ἐλθὼν πρῶτον ⸀ἀποκαθιστάνειπάντα, καὶ πῶς γέγραπται ἐπὶ τὸν υἱὸν τοῦ ἀνθρώπου ἵνα πολλὰ πάθῃ καὶ ⸀ἐξουδενηθῇ ");
INSERT INTO grcsbl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ἀλλὰ λέγω ὑμῖν ὅτι καὶ Ἠλίας ἐλήλυθεν, καὶ ἐποίησαν αὐτῷ ὅσα ⸀ἤθελον καθὼς γέγραπται ἐπʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Καὶ ⸂ἐλθόντες πρὸς τοὺς μαθητὰς εἶδον ὄχλον πολὺν περὶ αὐτοὺς καὶ γραμματεῖς συζητοῦντας ⸂πρὸς αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","καὶ ⸀εὐθὺςπᾶς ὁ ὄχλος ⸂ἰδόντες αὐτὸν ἐξεθαμβήθησαν, καὶ προστρέχοντες ἠσπάζοντο αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","καὶ ἐπηρώτησεν ⸀αὐτούς Τί συζητεῖτε πρὸς ⸀αὑτούς ");
INSERT INTO grcsbl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","καὶ ⸂ἀπεκρίθη αὐτῷ εἷς ἐκ τοῦ ὄχλου· Διδάσκαλε, ἤνεγκα τὸν υἱόν μου πρὸς σέ, ἔχοντα πνεῦμα ἄλαλον· ");
INSERT INTO grcsbl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","καὶ ὅπου ⸀ἐὰναὐτὸν καταλάβῃ ῥήσσει αὐτόν, καὶ ἀφρίζει καὶ τρίζει τοὺς ⸀ὀδόνταςκαὶ ξηραίνεται· καὶ εἶπα τοῖς μαθηταῖς σου ἵνα αὐτὸ ἐκβάλωσιν, καὶ οὐκ ἴσχυσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ὁ δὲ ἀποκριθεὶς ⸀αὐτοῖςλέγει· Ὦ γενεὰ ἄπιστος, ἕως πότε πρὸς ὑμᾶς ἔσομαι; ἕως πότε ἀνέξομαι ὑμῶν; φέρετε αὐτὸν πρός με. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","καὶ ἤνεγκαν αὐτὸν πρὸς αὐτόν. καὶ ἰδὼν αὐτὸν ⸂τὸ πνεῦμα εὐθὺς ⸀συνεσπάραξεναὐτόν, καὶ πεσὼν ἐπὶ τῆς γῆς ἐκυλίετο ἀφρίζων. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","καὶ ἐπηρώτησεν τὸν πατέρα αὐτοῦ· Πόσος χρόνος ἐστὶν ὡς τοῦτο γέγονεν αὐτῷ; ὁ δὲ εἶπεν· ⸀Ἐκπαιδιόθεν· ");
INSERT INTO grcsbl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","καὶ πολλάκις ⸂καὶ εἰς πῦρ αὐτὸν ἔβαλεν καὶ εἰς ὕδατα ἵνα ἀπολέσῃ αὐτόν· ἀλλʼ εἴ τι ⸀δύνῃ βοήθησον ἡμῖν σπλαγχνισθεὶς ἐφʼ ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ· Τὸ Εἰ ⸀δύνῃ πάντα δυνατὰ τῷ πιστεύοντι. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","⸀εὐθὺςκράξας ὁ πατὴρ τοῦ ⸀παιδίουἔλεγεν· ⸀Πιστεύω βοήθει μου τῇ ἀπιστίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ἰδὼν δὲ ὁ Ἰησοῦς ὅτι ἐπισυντρέχει ὄχλος ἐπετίμησεν τῷ πνεύματι τῷ ἀκαθάρτῳ λέγων αὐτῷ· Τὸ ⸂ἄλαλον καὶ κωφὸν πνεῦμα, ἐγὼ ⸂ἐπιτάσσω σοι, ἔξελθε ἐξ αὐτοῦ καὶ μηκέτι εἰσέλθῃς εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","καὶ ⸂κράξας καὶ πολλὰ σπαράξας ἐξῆλθεν· καὶ ἐγένετο ὡσεὶ νεκρὸς ὥστε ⸀τοὺςπολλοὺς λέγειν ὅτι ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ὁ δὲ Ἰησοῦς κρατήσας ⸂τῆς χειρὸς αὐτοῦ ἤγειρεν αὐτόν, καὶ ἀνέστη. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","καὶ ⸂εἰσελθόντος αὐτοῦ εἰς οἶκον οἱ μαθηταὶ αὐτοῦ ⸂κατʼ ἰδίαν ἐπηρώτων αὐτόν· Ὅτι ἡμεῖς οὐκ ἠδυνήθημεν ἐκβαλεῖν αὐτό; ");
INSERT INTO grcsbl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","καὶ εἶπεν αὐτοῖς· Τοῦτο τὸ γένος ἐν οὐδενὶ δύναται ἐξελθεῖν εἰ μὴ ἐν ⸀προσευχῇ ");
INSERT INTO grcsbl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Κἀκεῖθεν ἐξελθόντες ⸀παρεπορεύοντοδιὰ τῆς Γαλιλαίας, καὶ οὐκ ἤθελεν ἵνα τις γνοῖ· ");
INSERT INTO grcsbl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ἐδίδασκεν γὰρ τοὺς μαθητὰς αὐτοῦ καὶ ἔλεγεν αὐτοῖς ὅτι Ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται εἰς χεῖρας ἀνθρώπων, καὶ ἀποκτενοῦσιν αὐτόν, καὶ ἀποκτανθεὶς ⸂μετὰ τρεῖς ἡμέρας ἀναστήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","οἱ δὲ ἠγνόουν τὸ ῥῆμα, καὶ ἐφοβοῦντο αὐτὸν ἐπερωτῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Καὶ ⸀ἦλθονεἰς Καφαρναούμ. καὶ ἐν τῇ οἰκίᾳ γενόμενος ἐπηρώτα αὐτούς· Τί ἐν τῇ ⸀ὁδῷδιελογίζεσθε; ");
INSERT INTO grcsbl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","οἱ δὲ ἐσιώπων, πρὸς ἀλλήλους γὰρ διελέχθησαν ἐν τῇ ὁδῷ τίς μείζων. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","καὶ καθίσας ἐφώνησεν τοὺς δώδεκα καὶ λέγει αὐτοῖς· Εἴ τις θέλει πρῶτος εἶναι ἔσται πάντων ἔσχατος καὶ πάντων διάκονος. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","καὶ λαβὼν παιδίον ἔστησεν αὐτὸ ἐν μέσῳ αὐτῶν καὶ ἐναγκαλισάμενος αὐτὸ εἶπεν αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ὃς ⸀ἂνἓν τῶν τοιούτων παιδίων δέξηται ἐπὶ τῷ ὀνόματί μου, ἐμὲ δέχεται· καὶ ὃς ⸁ἂνἐμὲ ⸀δέχηται οὐκ ἐμὲ δέχεται ἀλλὰ τὸν ἀποστείλαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","⸂Ἔφη αὐτῷ ὁ Ἰωάννης· Διδάσκαλε, εἴδομέν τινα ⸀ἐντῷ ὀνόματί σου ἐκβάλλοντα δαιμόνια, ⸂καὶ ἐκωλύομεν αὐτόν, ὅτι οὐκ ἠκολούθει ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ὁ δὲ Ἰησοῦς εἶπεν· Μὴ κωλύετε αὐτόν, οὐδεὶς γάρ ἐστιν ὃς ποιήσει δύναμιν ἐπὶ τῷ ὀνόματί μου καὶ δυνήσεται ταχὺ κακολογῆσαί με· ");
INSERT INTO grcsbl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ὃς γὰρ οὐκ ἔστιν καθʼ ⸂ἡμῶν, ὑπὲρ ἡμῶν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ὃς γὰρ ἂν ποτίσῃ ὑμᾶς ποτήριον ὕδατος ἐν ⸀ὀνόματιὅτιχριστοῦ ἐστε, ἀμὴν λέγω ὑμῖν ⸀ὅτι οὐ μὴ ⸀ἀπολέσῃτὸν μισθὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Καὶ ὃς ⸀ἂνσκανδαλίσῃ ἕνα τῶν μικρῶν ⸀τούτωντῶν πιστευόντων ⸂εἰς ἐμέ, καλόν ἐστιν αὐτῷ μᾶλλον εἰ περίκειται ⸂μύλος ὀνικὸς περὶ τὸν τράχηλον αὐτοῦ καὶ βέβληται εἰς τὴν θάλασσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Καὶ ἐὰν ⸀σκανδαλίζῃσε ἡ χείρ σου, ἀπόκοψον αὐτήν· καλόν ⸂ἐστίν σε κυλλὸν ⸂εἰσελθεῖν εἰς τὴν ζωὴν ἢ τὰς δύο χεῖρας ἔχοντα ἀπελθεῖν εἰς τὴν γέενναν, εἰς τὸ πῦρ τὸ ⸀ἄσβεστον ");
INSERT INTO grcsbl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","καὶ ἐὰν ὁ πούς σου σκανδαλίζῃ σε ἀπόκοψον αὐτόν· καλόν ἐστίν ⸀σε εἰσελθεῖν εἰς τὴν ζωὴν χωλὸν ἢ τοὺς δύο πόδας ἔχοντα βληθῆναι εἰς τὴν ⸀γέενναν ");
INSERT INTO grcsbl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","καὶ ἐὰν ὁ ὀφθαλμός σου σκανδαλίζῃ σε, ἔκβαλε αὐτόν· καλόν ⸀σέἐστιν μονόφθαλμον εἰσελθεῖν εἰς τὴνβασιλείαν τοῦ θεοῦ ἢ δύο ὀφθαλμοὺς ἔχοντα βληθῆναι εἰς ⸀τὴν ⸀γέενναν ");
INSERT INTO grcsbl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ὅπου ὁ σκώληξ αὐτῶν οὐ τελευτᾷ καὶ τὸ πῦρ οὐ σβέννυται. ");
INSERT INTO grcsbl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Πᾶς γὰρ πυρὶ ⸀ἁλισθήσεται ");
INSERT INTO grcsbl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","καλὸν τὸ ἅλα· ἐὰν δὲ τὸ ἅλας ἄναλον γένηται, ἐν τίνι αὐτὸ ἀρτύσετε; ἔχετε ἐν ἑαυτοῖς ⸀ἅλα, καὶ εἰρηνεύετε ἐν ἀλλήλοις. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Καὶ ἐκεῖθεν ἀναστὰς ἔρχεται εἰς τὰ ὅρια τῆς Ἰουδαίας ⸀καὶπέραν τοῦ Ἰορδάνου, καὶ συμπορεύονται πάλιν ὄχλοι πρὸς αὐτόν, καὶ ὡς εἰώθει πάλιν ἐδίδασκεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","⸀Καὶ⸀ἐπηρώτωναὐτὸν εἰ ἔξεστιν ἀνδρὶ γυναῖκα ἀπολῦσαι, πειράζοντες αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ὁ δὲ ἀποκριθεὶς εἶπεν αὐτοῖς· Τί ὑμῖν ἐνετείλατο Μωϋσῆς; ");
INSERT INTO grcsbl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","οἱ δὲ εἶπαν· ⸂Ἐπέτρεψεν Μωϋσῆς βιβλίον ἀποστασίου γράψαι καὶ ἀπολῦσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","⸂ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Πρὸς τὴν σκληροκαρδίαν ὑμῶν ἔγραψεν ὑμῖν τὴν ἐντολὴν ταύτην· ");
INSERT INTO grcsbl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ἀπὸ δὲ ἀρχῆς κτίσεως ἄρσεν καὶ θῆλυ ἐποίησεν ⸀αὐτούς ");
INSERT INTO grcsbl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ἕνεκεν τούτου καταλείψει ἄνθρωπος τὸν πατέρα αὐτοῦ καὶ τὴν μητέρα ⸂καὶ προσκολληθήσεται πρὸς τὴν γυναῖκα αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","καὶ ἔσονται οἱ δύο εἰς σάρκα μίαν· ὥστε οὐκέτι εἰσὶν δύο ἀλλὰ μία σάρξ· ");
INSERT INTO grcsbl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ὃ οὖν ὁ θεὸς συνέζευξεν ἄνθρωπος μὴ χωριζέτω. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Καὶ ⸂εἰς τὴν οἰκίαν πάλιν οἱ μαθηταὶ ⸂περὶ τούτου ⸀ἐπηρώτωναὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","καὶ λέγει αὐτοῖς· Ὃς ⸀ἂνἀπολύσῃ τὴν γυναῖκα αὐτοῦ καὶ γαμήσῃ ἄλλην μοιχᾶται ἐπʼ αὐτήν, ");
INSERT INTO grcsbl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","καὶ ἐὰν ⸂αὐτὴ ἀπολύσασα τὸν ἄνδρα αὐτῆς γαμήσῃ ἄλλον μοιχᾶται. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Καὶ προσέφερον αὐτῷ παιδία ἵνα ⸂αὐτῶν ἅψηται· οἱ δὲ μαθηταὶ ⸂ἐπετίμησαν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ἰδὼν δὲ ὁ Ἰησοῦς ἠγανάκτησεν καὶ εἶπεν αὐτοῖς· Ἄφετε τὰ παιδία ἔρχεσθαι πρός με, μὴ κωλύετε αὐτά, τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ἀμὴν λέγω ὑμῖν, ὃς ⸀ἂνμὴ δέξηται τὴν βασιλείαν τοῦ θεοῦ ὡς παιδίον, οὐ μὴ εἰσέλθῃ εἰς αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","καὶ ἐναγκαλισάμενος αὐτὰ ⸂κατευλόγει τιθεὶς τὰς χεῖρας ἐπʼ αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Καὶ ἐκπορευομένου αὐτοῦ εἰς ὁδὸν προσδραμὼν εἷς καὶ γονυπετήσας αὐτὸν ἐπηρώτα αὐτόν· Διδάσκαλε ἀγαθέ, τί ποιήσω ἵνα ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grcsbl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ὁ δὲ Ἰησοῦς εἶπεν αὐτῷ· Τί με λέγεις ἀγαθόν; οὐδεὶς ἀγαθὸς εἰ μὴ εἷς ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","τὰς ἐντολὰς οἶδας· Μὴ ⸂φονεύσῃς, Μὴ μοιχεύσῃς⸃, Μὴ κλέψῃς, Μὴ ψευδομαρτυρήσῃς, Μὴ ἀποστερήσῃς, Τίμα τὸν πατέρα σου καὶ τὴν μητέρα. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ὁ δὲ ⸀ἔφηαὐτῷ· Διδάσκαλε, ταῦτα πάντα ἐφυλαξάμην ἐκ νεότητός μου. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ὁ δὲ Ἰησοῦς ἐμβλέψας αὐτῷ ἠγάπησε αὐτὸν καὶ εἶπεν αὐτῷ· Ἕν ⸀σε ὑστερεῖ· ὕπαγε ὅσα ἔχεις πώλησον καὶ δὸς ⸀τοῖςπτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν οὐρανῷ, καὶ δεῦρο ἀκολούθει ⸀μοι ");
INSERT INTO grcsbl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ὁ δὲ στυγνάσας ἐπὶ τῷ λόγῳ ἀπῆλθεν λυπούμενος, ἦν γὰρ ἔχων κτήματα πολλά. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Καὶ περιβλεψάμενος ὁ Ἰησοῦς λέγει τοῖς μαθηταῖς αὐτοῦ· Πῶς δυσκόλως οἱ τὰ χρήματα ἔχοντες εἰς τὴν βασιλείαν τοῦ θεοῦ εἰσελεύσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","οἱ δὲ μαθηταὶ ἐθαμβοῦντο ἐπὶ τοῖς λόγοις αὐτοῦ. ὁ δὲ Ἰησοῦς πάλιν ἀποκριθεὶς λέγει αὐτοῖς· Τέκνα, πῶς δύσκολόν ⸀ἐστινεἰς τὴν βασιλείαν τοῦ θεοῦ εἰσελθεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","εὐκοπώτερόν ἐστιν κάμηλον διὰ ⸂τῆς τρυμαλιᾶς τῆς ῥαφίδος ⸀διελθεῖνἢ πλούσιον εἰς τὴν βασιλείαν τοῦ θεοῦ εἰσελθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","οἱ δὲ περισσῶς ἐξεπλήσσοντο λέγοντες πρὸς ⸀ἑαυτούς Καὶ τίς δύναται σωθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","⸀ἐμβλέψαςαὐτοῖς ὁ Ἰησοῦς λέγει· Παρὰ ἀνθρώποις ἀδύνατον ἀλλʼ οὐ παρὰ θεῷ, πάντα γὰρ ⸀δυνατὰπαρὰ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ἤρξατο ⸂λέγειν ὁ Πέτρος αὐτῷ· Ἰδοὺ ἡμεῖς ἀφήκαμεν πάντα καὶ ⸀ἠκολουθήκαμένσοι. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","⸂ἔφη ὁ Ἰησοῦς· Ἀμὴν λέγω ὑμῖν, οὐδείς ἐστιν ὃς ἀφῆκεν οἰκίαν ἢ ἀδελφοὺς ἢ ἀδελφὰς ἢ ⸂μητέρα ἢ πατέρα ἢ τέκνα ἢ ἀγροὺς ἕνεκεν ἐμοῦ καὶ ἕνεκεν τοῦ εὐαγγελίου, ");
INSERT INTO grcsbl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ἐὰν μὴ λάβῃ ἑκατονταπλασίονα νῦν ἐν τῷ καιρῷ τούτῳ οἰκίας καὶ ἀδελφοὺς καὶ ἀδελφὰς καὶ ⸀μητέραςκαὶ τέκνα καὶ ἀγροὺς μετὰ διωγμῶν, καὶ ἐν τῷ αἰῶνι τῷ ἐρχομένῳ ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","πολλοὶ δὲ ἔσονται πρῶτοι ἔσχατοι καὶ ⸀οἱἔσχατοι πρῶτοι. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ἦσαν δὲ ἐν τῇ ὁδῷ ἀναβαίνοντες εἰς Ἱεροσόλυμα, καὶ ἦν προάγων αὐτοὺς ὁ Ἰησοῦς, καὶ ἐθαμβοῦντο, ⸂οἱ δὲ ἀκολουθοῦντες ἐφοβοῦντο. καὶ παραλαβὼν πάλιν τοὺς δώδεκα ἤρξατο αὐτοῖς λέγειν τὰ μέλλοντα αὐτῷ συμβαίνειν ");
INSERT INTO grcsbl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ὅτι Ἰδοὺ ἀναβαίνομεν εἰς Ἱεροσόλυμα, καὶ ὁ υἱὸς τοῦ ἀνθρώπου παραδοθήσεται τοῖςἀρχιερεῦσιν καὶ ⸀τοῖς γραμματεῦσιν, καὶ κατακρινοῦσιν αὐτὸν θανάτῳ καὶ παραδώσουσιν αὐτὸν τοῖς ἔθνεσιν ");
INSERT INTO grcsbl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","καὶ ἐμπαίξουσιν αὐτῷ καὶ ⸂ἐμπτύσουσιν αὐτῷ καὶ μαστιγώσουσιν αὐτὸν καὶ ⸀ἀποκτενοῦσιν καὶ ⸂μετὰ τρεῖς ἡμέρας ἀναστήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Καὶ προσπορεύονται αὐτῷ Ἰάκωβος καὶ Ἰωάννης ⸀οἱυἱοὶ Ζεβεδαίου λέγοντες ⸀αὐτῷ Διδάσκαλε, θέλομεν ἵνα ὃ ἐὰν αἰτήσωμέν ⸀σεποιήσῃς ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ὁ δὲ εἶπεν αὐτοῖς· Τί θέλετε ⸀ποιήσωὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","οἱ δὲ εἶπαν αὐτῷ· Δὸς ἡμῖν ἵνα εἷς ⸂σου ἐκ δεξιῶν καὶ εἷς ἐξ ⸀ἀριστερῶνκαθίσωμεν ἐν τῇ δόξῃ σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· Οὐκ οἴδατε τί αἰτεῖσθε· δύνασθε πιεῖν τὸ ποτήριον ὃ ἐγὼ πίνω, ⸀ἢτὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","οἱ δὲ εἶπαν αὐτῷ· Δυνάμεθα. ὁ δὲ Ἰησοῦς εἶπεν αὐτοῖς· ⸀Τὸποτήριον ὃ ἐγὼ πίνω πίεσθε καὶ τὸ βάπτισμα ὃ ἐγὼ βαπτίζομαι βαπτισθήσεσθε, ");
INSERT INTO grcsbl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","τὸ δὲ καθίσαι ἐκ δεξιῶν μου ⸀ἢἐξ εὐωνύμων οὐκ ἔστιν ἐμὸν δοῦναι, ἀλλʼ οἷς ἡτοίμασται. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Καὶ ἀκούσαντες οἱ δέκα ἤρξαντο ἀγανακτεῖν περὶ Ἰακώβου καὶ Ἰωάννου. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","⸂καὶ προσκαλεσάμενος αὐτοὺς ὁ Ἰησοῦς λέγει αὐτοῖς· Οἴδατε ὅτι οἱ δοκοῦντες ἄρχειν τῶν ἐθνῶν κατακυριεύουσιν αὐτῶν καὶ οἱ μεγάλοι αὐτῶν κατεξουσιάζουσιν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","οὐχ οὕτως δέ ⸀ἐστινἐν ὑμῖν· ἀλλʼ ὃς ⸀ἂνθέλῃ ⸂μέγας γενέσθαι ἐν ὑμῖν, ἔσται ὑμῶν διάκονος, ");
INSERT INTO grcsbl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","καὶ ὃς ⸀ἂνθέλῃ ⸂ἐν ὑμῖν εἶναι πρῶτος, ἔσται πάντων δοῦλος· ");
INSERT INTO grcsbl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","καὶ γὰρ ὁ υἱὸς τοῦ ἀνθρώπου οὐκ ἦλθεν διακονηθῆναι ἀλλὰ διακονῆσαι καὶ δοῦναι τὴν ψυχὴν αὐτοῦ λύτρον ἀντὶ πολλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Καὶ ἔρχονται εἰς Ἰεριχώ. καὶ ἐκπορευομένου αὐτοῦ ἀπὸ Ἰεριχὼ καὶ τῶν μαθητῶν αὐτοῦ καὶ ὄχλου ἱκανοῦ ⸀ὁυἱὸς Τιμαίου Βαρτιμαῖος ⸀τυφλὸς⸂προσαίτης ἐκάθητο παρὰ τὴν ὁδόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","καὶ ἀκούσας ὅτι Ἰησοῦς ὁ ⸀Ναζαρηνόςἐστιν ἤρξατο κράζειν καὶ λέγειν· ⸀ΥἱὲΔαυὶδ Ἰησοῦ, ἐλέησόν με. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","καὶ ἐπετίμων αὐτῷ πολλοὶ ἵνα σιωπήσῃ· ὁ δὲ πολλῷ μᾶλλον ἔκραζεν· Υἱὲ Δαυίδ, ἐλέησόν με. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","καὶ στὰς ὁ Ἰησοῦς εἶπεν· ⸂Φωνήσατε αὐτόν. καὶ φωνοῦσι τὸν τυφλὸν λέγοντες αὐτῷ· Θάρσει, ⸀ἔγειρε φωνεῖ σε. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ὁ δὲ ἀποβαλὼν τὸ ἱμάτιον αὐτοῦ ⸀ἀναπηδήσαςἦλθεν πρὸς τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","καὶ ἀποκριθεὶς ⸂αὐτῷ ὁ Ἰησοῦς εἶπεν· Τί ⸂σοι θέλεις ποιήσω; ὁ δὲ τυφλὸς εἶπεν αὐτῷ· Ραββουνι, ἵνα ἀναβλέψω. ");
INSERT INTO grcsbl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","⸂καὶ ὁ Ἰησοῦς εἶπεν αὐτῷ· Ὕπαγε, ἡ πίστις σου σέσωκέν σε. καὶ ⸀εὐθὺςἀνέβλεψεν, καὶ ἠκολούθει ⸀αὐτῷἐν τῇ ὁδῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Καὶ ὅτε ἐγγίζουσιν εἰς Ἱεροσόλυμα εἰς Βηθφαγὴ καὶ Βηθανίαν πρὸς τὸ Ὄρος τῶν Ἐλαιῶν, ἀποστέλλει δύο τῶν μαθητῶν αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","καὶ λέγει αὐτοῖς· Ὑπάγετε εἰς τὴν κώμην τὴν κατέναντι ὑμῶν, καὶ ⸀εὐθὺςεἰσπορευόμενοι εἰς αὐτὴν εὑρήσετε πῶλον δεδεμένον ἐφʼ ὃν οὐδεὶς ⸀οὔπωἀνθρώπων ⸀ἐκάθισεν ⸂λύσατε αὐτὸν καὶ φέρετε. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","καὶ ἐάν τις ὑμῖν εἴπῃ· Τί ποιεῖτε τοῦτο; εἴπατε ⸀ὅτιὉ κύριος αὐτοῦ χρείαν ἔχει· καὶ ⸀εὐθὺςαὐτὸν ἀποστέλλει ⸀πάλινὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","⸂καὶ ἀπῆλθον καὶ εὗρον πῶλον δεδεμένον ⸀πρὸςθύραν ἔξω ἐπὶ τοῦ ἀμφόδου, καὶ λύουσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","καί τινες τῶν ἐκεῖ ἑστηκότων ἔλεγον αὐτοῖς· Τί ποιεῖτε λύοντες τὸν πῶλον; ");
INSERT INTO grcsbl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","οἱ δὲ εἶπαν αὐτοῖς καθὼς ⸀εἶπενὁ Ἰησοῦς· καὶ ἀφῆκαν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","καὶ ⸀φέρουσιντὸν πῶλον πρὸς τὸν Ἰησοῦν, καὶ ⸀ἐπιβάλλουσιναὐτῷ τὰ ἱμάτια αὐτῶν, καὶ ἐκάθισεν ἐπʼ ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","⸂καὶ πολλοὶ τὰ ἱμάτια αὐτῶν ἔστρωσαν εἰς τὴν ὁδόν, ἄλλοι δὲ στιβάδας ⸂κόψαντες ἐκ τῶν ἀγρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","καὶ οἱ προάγοντες καὶ οἱ ἀκολουθοῦντες ⸀ἔκραζον Ὡσαννά· Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι κυρίου· ");
INSERT INTO grcsbl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Εὐλογημένη ἡ ἐρχομένη ⸀βασιλείατοῦ πατρὸς ἡμῶν Δαυίδ· Ὡσαννὰ ἐν τοῖς ὑψίστοις. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Καὶ εἰσῆλθεν εἰς ⸀Ἱεροσόλυμαεἰς τὸ ἱερόν· καὶ περιβλεψάμενος πάντα ⸀ὀψὲἤδη οὔσης τῆς ὥρας ἐξῆλθεν εἰς Βηθανίαν μετὰ τῶν δώδεκα. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Καὶ τῇ ἐπαύριον ἐξελθόντων αὐτῶν ἀπὸ Βηθανίας ἐπείνασεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","καὶ ἰδὼν συκῆν ⸀ἀπὸμακρόθεν ἔχουσαν φύλλα ἦλθεν εἰ ἄρα ⸂τι εὑρήσει ἐν αὐτῇ, καὶ ἐλθὼν ἐπʼ αὐτὴν οὐδὲν εὗρεν εἰ μὴ φύλλα, ⸂ὁ γὰρ καιρὸς οὐκ ἦν σύκων. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","καὶ ⸀ἀποκριθεὶςεἶπεν αὐτῇ· Μηκέτι ⸂εἰς τὸν αἰῶνα ἐκ σοῦ μηδεὶς καρπὸν φάγοι. καὶ ἤκουον οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Καὶ ἔρχονται εἰς Ἱεροσόλυμα. καὶ ⸀εἰσελθὼνεἰς τὸ ἱερὸν ἤρξατο ἐκβάλλειν τοὺςπωλοῦντας καὶ ⸀τοὺς ἀγοράζοντας ἐν τῷ ἱερῷ, καὶ τὰς τραπέζας τῶν κολλυβιστῶν καὶ τὰς καθέδρας τῶν πωλούντων τὰς περιστερὰς κατέστρεψεν ");
INSERT INTO grcsbl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","καὶ οὐκ ἤφιεν ἵνα τις διενέγκῃ σκεῦος διὰ τοῦ ἱεροῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","καὶ ἐδίδασκεν ⸂καὶ ἔλεγεν ⸀αὐτοῖς Οὐ γέγραπται ὅτι Ὁ οἶκός μου οἶκος προσευχῆς κληθήσεται πᾶσιν τοῖς ἔθνεσιν; ὑμεῖς δὲ ⸀πεποιήκατεαὐτὸν σπήλαιον λῃστῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","καὶ ἤκουσαν οἱ ⸂ἀρχιερεῖς καὶ οἱ γραμματεῖς, καὶ ἐζήτουν πῶς αὐτὸν ἀπολέσωσιν· ἐφοβοῦντο γὰρ αὐτόν, ⸂πᾶς γὰρ ὁ ὄχλος ἐξεπλήσσετο ἐπὶ τῇ διδαχῇ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Καὶ ⸀ὅτανὀψὲ ἐγένετο, ⸀ἐξεπορεύοντοἔξω τῆς πόλεως. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Καὶ ⸂παραπορευόμενοι πρωῒ εἶδον τὴν συκῆν ἐξηραμμένην ἐκ ῥιζῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","καὶ ἀναμνησθεὶς ὁ Πέτρος λέγει αὐτῷ· Ῥαββί, ἴδε ἡ συκῆ ἣν κατηράσω ἐξήρανται. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","καὶ ἀποκριθεὶς ὁ Ἰησοῦς λέγει αὐτοῖς· Ἔχετε πίστιν θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","⸀ἀμὴνλέγω ὑμῖν ὅτι ὃς ἂν εἴπῃ τῷ ὄρει τούτῳ· Ἄρθητι καὶ βλήθητι εἰς τὴν θάλασσαν, καὶ μὴ διακριθῇ ἐν τῇ καρδίᾳ αὐτοῦ ἀλλὰ ⸀πιστεύῃὅτι ⸂ὃ λαλεῖ γίνεται, ἔσται αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","διὰ τοῦτο λέγω ὑμῖν, πάντα ὅσα ⸂προσεύχεσθε καὶ αἰτεῖσθε, πιστεύετε ὅτι ⸀ἐλάβετε καὶ ἔσται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","καὶ ὅταν ⸀στήκετεπροσευχόμενοι, ἀφίετε εἴ τι ἔχετε κατά τινος, ἵνα καὶ ὁ πατὴρ ὑμῶνὁ ἐν τοῖς οὐρανοῖς ἀφῇ ὑμῖν τὰ παραπτώματα ⸀ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Καὶ ἔρχονται πάλιν εἰς Ἱεροσόλυμα. καὶ ἐν τῷ ἱερῷ περιπατοῦντος αὐτοῦ ἔρχονται πρὸς αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς καὶ οἱ πρεσβύτεροι ");
INSERT INTO grcsbl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","καὶ ⸀ἔλεγοναὐτῷ· Ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς; ⸀ἢτίς σοι ⸂ἔδωκεν τὴν ἐξουσίαν ταύτην ἵνα ταῦτα ποιῇς; ");
INSERT INTO grcsbl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ὁ δὲ ⸀Ἰησοῦςεἶπεν αὐτοῖς· Ἐπερωτήσω ⸀ὑμᾶςἕνα λόγον, καὶ ἀποκρίθητέ μοι, καὶ ἐρῶ ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ· ");
INSERT INTO grcsbl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","τὸβάπτισμα ⸀τὸ Ἰωάννου ἐξ οὐρανοῦ ἦν ἢ ἐξ ἀνθρώπων; ἀποκρίθητέ μοι. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","καὶ ⸀διελογίζοντοπρὸς ἑαυτοὺς λέγοντες· ⸂Τί εἴπωμεν; ἐὰν εἴπωμεν· Ἐξ οὐρανοῦ, ἐρεῖ· Διὰ τί ⸀οὖνοὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ἀλλὰ εἴπωμεν· Ἐξ ἀνθρώπων;— ἐφοβοῦντο τὸν ⸀ὄχλον ἅπαντες γὰρ εἶχον τὸν Ἰωάννην ⸂ὄντως ὅτι προφήτης ἦν. ");
INSERT INTO grcsbl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","καὶ ἀποκριθέντες ⸂τῷ Ἰησοῦ λέγουσιν· Οὐκ οἴδαμεν. καὶ ὁ ⸀Ἰησοῦςλέγει αὐτοῖς· Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Καὶ ἤρξατο αὐτοῖς ἐν παραβολαῖς ⸀λαλεῖν Ἀμπελῶνα ⸂ἄνθρωπος ἐφύτευσεν, καὶ περιέθηκεν φραγμὸν καὶ ὤρυξεν ὑπολήνιον καὶ ᾠκοδόμησεν πύργον, καὶ ἐξέδετο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","καὶ ἀπέστειλεν πρὸς τοὺς γεωργοὺς τῷ καιρῷ δοῦλον, ἵνα παρὰ τῶν γεωργῶν λάβῃ ἀπὸ ⸂τῶν καρπῶν τοῦ ἀμπελῶνος· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","⸀καὶλαβόντες αὐτὸν ἔδειραν καὶ ἀπέστειλαν κενόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","καὶ πάλιν ἀπέστειλεν πρὸς αὐτοὺς ἄλλον δοῦλον· ⸀κἀκεῖνον⸀ἐκεφαλίωσανκαὶ ⸀ἠτίμασαν ");
INSERT INTO grcsbl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","⸀καὶἄλλον ἀπέστειλεν· κἀκεῖνον ἀπέκτειναν, καὶ πολλοὺς ἄλλους, ⸂οὓς μὲν δέροντες οὓς δὲ ἀποκτέννοντες. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ἔτι ⸂ἕνα εἶχεν, υἱὸν ἀγαπητόν· ἀπέστειλεν αὐτὸν ⸂ἔσχατον πρὸς αὐτοὺς λέγων ὅτι Ἐντραπήσονται τὸν υἱόν μου. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ἐκεῖνοι δὲ οἱ γεωργοὶ ⸂πρὸς ἑαυτοὺς εἶπαν ὅτι Οὗτός ἐστιν ὁ κληρονόμος· δεῦτε ἀποκτείνωμεν αὐτόν, καὶ ἡμῶν ἔσται ἡ κληρονομία. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","καὶ λαβόντες ⸂ἀπέκτειναν αὐτόν, καὶ ἐξέβαλον αὐτὸν ἔξω τοῦ ἀμπελῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","⸀τίποιήσει ὁ κύριος τοῦ ἀμπελῶνος; ἐλεύσεται καὶ ἀπολέσει τοὺς γεωργούς, καὶ δώσει τὸν ἀμπελῶνα ἄλλοις. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","οὐδὲ τὴν γραφὴν ταύτην ἀνέγνωτε· Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες, οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","παρὰ κυρίου ἐγένετο αὕτη, καὶ ἔστιν θαυμαστὴ ἐν ὀφθαλμοῖς ἡμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Καὶ ἐζήτουν αὐτὸν κρατῆσαι, καὶ ἐφοβήθησαν τὸν ὄχλον, ἔγνωσαν γὰρ ὅτι πρὸς αὐτοὺς τὴν παραβολὴν εἶπεν. καὶ ἀφέντες αὐτὸν ἀπῆλθον. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Καὶ ἀποστέλλουσιν πρὸς αὐτόν τινας τῶν Φαρισαίων καὶ τῶν Ἡρῳδιανῶν ἵνα αὐτὸν ἀγρεύσωσιν λόγῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","⸀καὶἐλθόντες λέγουσιν αὐτῷ· Διδάσκαλε, οἴδαμεν ὅτι ἀληθὴς εἶ καὶ οὐ μέλει σοι περὶ οὐδενός, οὐ γὰρ βλέπεις εἰς πρόσωπον ἀνθρώπων, ἀλλʼ ἐπʼ ἀληθείας τὴν ὁδὸν τοῦ θεοῦ διδάσκεις· ἔξεστιν ⸂δοῦναι κῆνσον Καίσαρι ἢ οὔ; δῶμεν ἢ μὴ δῶμεν; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ὁ δὲ εἰδὼς αὐτῶν τὴν ὑπόκρισιν εἶπεν αὐτοῖς· Τί με πειράζετε; φέρετέ μοι δηνάριον ἵνα ἴδω. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","οἱ δὲ ἤνεγκαν. καὶ λέγει αὐτοῖς· Τίνος ἡ εἰκὼν αὕτη καὶ ἡ ἐπιγραφή; οἱ δὲ εἶπαν αὐτῷ· Καίσαρος. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","⸂ὁ δὲ Ἰησοῦς εἶπεν ⸀αὐτοῖς ⸂Τὰ Καίσαρος ἀπόδοτε Καίσαρι καὶ τὰ τοῦ θεοῦ τῷ θεῷ. καὶ ⸀ἐξεθαύμαζονἐπʼ αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Καὶ ἔρχονται Σαδδουκαῖοι πρὸς αὐτόν, οἵτινες λέγουσιν ἀνάστασιν μὴ εἶναι, καὶ ⸀ἐπηρώτωναὐτὸν λέγοντες· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Διδάσκαλε, Μωϋσῆς ἔγραψεν ἡμῖν ὅτι ἐάν τινος ἀδελφὸς ἀποθάνῃ καὶ καταλίπῃ γυναῖκα καὶ ⸂μὴ ἀφῇ τέκνον, ἵνα λάβῃ ὁ ἀδελφὸς αὐτοῦ τὴν ⸀γυναῖκακαὶ ἐξαναστήσῃ σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ἑπτὰ ἀδελφοὶ ἦσαν· καὶ ὁ πρῶτος ἔλαβεν γυναῖκα, καὶ ἀποθνῄσκων οὐκ ἀφῆκεν σπέρμα· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","καὶ ὁ δεύτερος ἔλαβεν αὐτήν, καὶ ἀπέθανεν ⸂μὴ καταλιπὼν σπέρμα, καὶ ὁ τρίτος ὡσαύτως· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","καὶ ⸂οἱ ἑπτὰ οὐκ ἀφῆκαν σπέρμα· ⸀ἔσχατονπάντων ⸂καὶ ἡ γυνὴ ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ἐν τῇ ἀναστάσει ⸂ὅταν ἀναστῶσιν τίνος αὐτῶν ἔσται γυνή; οἱ γὰρ ἑπτὰ ἔσχον αὐτὴν γυναῖκα. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","⸂ἔφη αὐτοῖς ὁ Ἰησοῦς· Οὐ διὰ τοῦτο πλανᾶσθε μὴ εἰδότες τὰς γραφὰς μηδὲ τὴν δύναμιν τοῦ θεοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ὅταν γὰρ ἐκ νεκρῶν ἀναστῶσιν, οὔτε γαμοῦσιν οὔτε ⸀γαμίζονται ἀλλʼ εἰσὶν ὡς ⸀ἄγγελοιἐν τοῖς οὐρανοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","περὶ δὲ τῶν νεκρῶν ὅτι ἐγείρονται οὐκ ἀνέγνωτε ἐν τῇ βίβλῳ Μωϋσέως ἐπὶ τοῦ βάτου ⸀πῶςεἶπεν αὐτῷ ὁ θεὸς λέγων· Ἐγὼ ὁ θεὸς Ἀβραὰμ καὶ ⸂ὁ θεὸς Ἰσαὰκ καὶ ὁ θεὸς Ἰακώβ; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","οὐκ ἔστιν ⸀θεὸςνεκρῶν ⸀ἀλλὰζώντων· ⸀πολὺπλανᾶσθε. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Καὶ προσελθὼν εἷς τῶν γραμματέων ἀκούσας αὐτῶν συζητούντων, ⸀ἰδὼνὅτι καλῶς ⸂ἀπεκρίθη αὐτοῖς, ἐπηρώτησεν αὐτόν· Ποία ἐστὶν ⸂ἐντολὴ πρώτη πάντων; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","⸂ἀπεκρίθη ὁ Ἰησοῦς ὅτι Πρώτη ⸀ἐστίν Ἄκουε, Ἰσραήλ, κύριος ὁ θεὸς ἡμῶν κύριος εἷς ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","καὶ ἀγαπήσεις κύριον τὸν θεόν σου ἐξ ὅλης ⸀τῆςκαρδίας σουκαὶ ἐξ ὅλης τῆς ψυχῆς σου καὶ ἐξ ὅλης τῆς διανοίας σου καὶ ἐξ ὅλης τῆς ἰσχύος ⸀σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","⸀δευτέρααὕτη· Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. μείζων τούτων ἄλλη ἐντολὴ οὐκ ἔστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","⸀καὶεἶπεν αὐτῷ ὁ γραμματεύς· Καλῶς, διδάσκαλε, ἐπʼ ἀληθείας εἶπες ὅτι εἷς ἐστιν καὶ οὐκ ἔστιν ἄλλος πλὴν αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","καὶ τὸ ἀγαπᾶν αὐτὸν ἐξ ὅλης ⸀τῆςκαρδίας καὶ ἐξ ὅλης τῆς ⸀συνέσεωςκαὶ ἐξ ὅλης τῆς ἰσχύος καὶ τὸ ἀγαπᾶν τὸν πλησίον ὡς ἑαυτὸν ⸀περισσότερόνἐστιν πάντων τῶν ὁλοκαυτωμάτων καὶ θυσιῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","καὶ ὁ Ἰησοῦς ἰδὼν ⸀αὐτὸνὅτι νουνεχῶς ἀπεκρίθη εἶπεν αὐτῷ· Οὐ μακρὰν εἶ ἀπὸ τῆς βασιλείας τοῦ θεοῦ. καὶ οὐδεὶς οὐκέτι ἐτόλμα αὐτὸν ἐπερωτῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Καὶ ἀποκριθεὶς ὁ Ἰησοῦς ἔλεγεν διδάσκων ἐν τῷ ἱερῷ· Πῶς λέγουσιν οἱ γραμματεῖς ὅτι ὁ χριστὸς υἱὸς ⸂Δαυίδ ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⸀αὐτὸςΔαυὶδ εἶπεν ἐν ⸂τῷ πνεύματι τῷ ἁγίῳ· ⸀Εἶπεν⸀κύριοςτῷ κυρίῳ μου· ⸀Κάθουἐκ δεξιῶν μου ἕως ἂν θῶ τοὺς ἐχθρούς σου ⸀ὑποκάτωτῶν ποδῶν σου. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","⸀αὐτὸςΔαυὶδ λέγει αὐτὸν κύριον, καὶ πόθεν ⸂αὐτοῦ ἐστιν υἱός; καὶ ὁ πολὺς ὄχλος ἤκουεν αὐτοῦ ἡδέως. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Καὶ ⸂ἐν τῇ διδαχῇ αὐτοῦ ἔλεγεν· Βλέπετε ἀπὸ τῶν γραμματέων τῶν θελόντων ἐν στολαῖς περιπατεῖν καὶ ἀσπασμοὺς ἐν ταῖς ἀγοραῖς ");
INSERT INTO grcsbl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","καὶ πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς καὶ πρωτοκλισίας ἐν τοῖς δείπνοις, ");
INSERT INTO grcsbl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","οἱ κατεσθίοντες τὰς οἰκίας τῶν χηρῶν καὶ προφάσει μακρὰ προσευχόμενοι· οὗτοι λήμψονται περισσότερον κρίμα. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Καὶ ⸀καθίσας⸀κατέναντιτοῦ γαζοφυλακίου ἐθεώρει πῶς ὁ ὄχλος βάλλει χαλκὸν εἰς τὸ γαζοφυλάκιον· καὶ πολλοὶ πλούσιοι ἔβαλλον πολλά· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","καὶ ἐλθοῦσα μία χήρα πτωχὴ ἔβαλεν λεπτὰ δύο, ὅ ἐστιν κοδράντης. ");
INSERT INTO grcsbl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","καὶ προσκαλεσάμενος τοὺς μαθητὰς αὐτοῦ ⸀εἶπεναὐτοῖς· Ἀμὴν λέγω ὑμῖν ὅτι ἡ χήρα αὕτη ἡ πτωχὴ πλεῖον πάντων ⸀ἔβαλεντῶν βαλλόντων εἰς τὸ γαζοφυλάκιον· ");
INSERT INTO grcsbl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","πάντες γὰρ ἐκ τοῦ περισσεύοντος αὐτοῖς ἔβαλον, αὕτη δὲ ἐκ τῆς ὑστερήσεως αὐτῆς πάντα ὅσα εἶχεν ἔβαλεν, ὅλον τὸν βίον αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Καὶ ἐκπορευομένου αὐτοῦ ἐκ τοῦ ἱεροῦ λέγει αὐτῷ εἷς τῶν μαθητῶν αὐτοῦ· Διδάσκαλε, ἴδε ποταποὶ λίθοι καὶ ποταπαὶ οἰκοδομαί. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","καὶ ὁ ⸀Ἰησοῦςεἶπεν αὐτῷ· Βλέπεις ταύτας τὰς μεγάλας οἰκοδομάς; οὐ μὴ ἀφεθῇ ⸀ὧδελίθος ἐπὶ ⸀λίθονὃς οὐ μὴ καταλυθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Καὶ καθημένου αὐτοῦ εἰς τὸ Ὄρος τῶν Ἐλαιῶν κατέναντι τοῦ ἱεροῦ ⸀ἐπηρώτααὐτὸν κατʼ ἰδίαν Πέτρος καὶ Ἰάκωβος καὶ Ἰωάννης καὶ Ἀνδρέας· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Εἰπὸν ἡμῖν πότε ταῦτα ἔσται, καὶ τί τὸ σημεῖον ὅταν μέλλῃ ⸂ταῦτα συντελεῖσθαι πάντα. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ὁ δὲ Ἰησοῦς ⸂ἤρξατο λέγειν αὐτοῖς· Βλέπετε μή τις ὑμᾶς πλανήσῃ· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","⸀πολλοὶἐλεύσονται ἐπὶ τῷ ὀνόματί μου λέγοντες ὅτι Ἐγώ εἰμι, καὶ πολλοὺς πλανήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ὅταν δὲ ⸀ἀκούσητεπολέμους καὶ ἀκοὰς πολέμων, μὴ θροεῖσθε· ⸀δεῖγενέσθαι, ἀλλʼ οὔπω τὸ τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ἐγερθήσεται γὰρ ἔθνος ἐπʼ ἔθνος καὶ βασιλεία ἐπὶ βασιλείαν, ⸀ἔσονταισεισμοὶ κατὰ τόπους, ⸁ἔσονται⸀λιμοί ⸀ἀρχὴὠδίνων ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","βλέπετε δὲ ὑμεῖς ἑαυτούς· ⸀παραδώσουσινὑμᾶς εἰς συνέδρια καὶ εἰς συναγωγὰς δαρήσεσθε καὶ ἐπὶ ἡγεμόνων καὶ βασιλέων σταθήσεσθε ἕνεκεν ἐμοῦ εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","καὶ εἰς πάντα τὰ ἔθνη ⸂πρῶτον δεῖ κηρυχθῆναι τὸ εὐαγγέλιον. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","⸂καὶ ὅταν ⸀ἄγωσινὑμᾶς παραδιδόντες, μὴ προμεριμνᾶτε τί ⸀λαλήσητε ἀλλʼ ὃ ἐὰν δοθῇ ὑμῖν ἐν ἐκείνῃ τῇ ὥρᾳ τοῦτο λαλεῖτε, οὐ γάρ ἐστε ὑμεῖς οἱ λαλοῦντες ἀλλὰ τὸ πνεῦμα τὸ ἅγιον. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","⸂καὶ παραδώσει ἀδελφὸς ἀδελφὸν εἰς θάνατον καὶ πατὴρ τέκνον, καὶ ἐπαναστήσονται τέκνα ἐπὶ γονεῖς καὶ θανατώσουσιν αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου. ὁ δὲ ὑπομείνας εἰς τέλος οὗτος σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ὅταν δὲ ἴδητε τὸ βδέλυγμα τῆς ἐρημώσεως ⸀ἑστηκόταὅπου οὐ δεῖ, ὁ ἀναγινώσκων νοείτω, τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν εἰς τὰ ὄρη, ");
INSERT INTO grcsbl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","⸀ὁἐπὶ τοῦ δώματος μὴ ⸀καταβάτωμηδὲ εἰσελθάτω ⸂τι ἆραι ἐκ τῆς οἰκίας αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","καὶ ὁ εἰς τὸν ⸀ἀγρὸνμὴ ἐπιστρεψάτω εἰς τὰ ὀπίσω ἆραι τὸ ἱμάτιον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","οὐαὶ δὲ ταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","προσεύχεσθε δὲ ἵνα μὴ ⸀γένηταιχειμῶνος· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ἔσονται γὰρ αἱ ἡμέραι ἐκεῖναι θλῖψις οἵα οὐ γέγονεν τοιαύτη ἀπʼ ἀρχῆς κτίσεως ⸀ἣνἔκτισεν ὁ θεὸς ἕως τοῦ νῦν καὶ οὐ μὴ γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","καὶ εἰ μὴ ⸂ἐκολόβωσεν κύριος τὰς ἡμέρας, οὐκ ἂν ἐσώθη πᾶσα σάρξ. ἀλλὰ διὰ τοὺς ἐκλεκτοὺς οὓς ἐξελέξατο ἐκολόβωσεν τὰς ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","⸀καὶτότε ἐάν τις ὑμῖν εἴπῃ· ⸀Ἴδεὧδε ὁ ⸀χριστός ⸁Ἴδεἐκεῖ, μὴ πιστεύετε· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ἐγερθήσονται γὰρ ψευδόχριστοι καὶ ψευδοπροφῆται καὶ δώσουσιν σημεῖα καὶ τέρατα πρὸς τὸ ἀποπλανᾶν εἰ ⸀δυνατὸντοὺς ἐκλεκτούς· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ὑμεῖς δὲ βλέπετε· ⸀προείρηκαὑμῖν πάντα. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ἀλλὰ ἐν ἐκείναις ταῖς ἡμέραις μετὰ τὴν θλῖψιν ἐκείνην ὁ ἥλιος σκοτισθήσεται, καὶ ἡ σελήνη οὐ δώσει τὸ φέγγος αὐτῆς, ");
INSERT INTO grcsbl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","καὶ οἱ ἀστέρες ⸂ἔσονται ἐκ τοῦ οὐρανοῦ πίπτοντες, καὶ αἱ δυνάμεις αἱ ἐν τοῖς οὐρανοῖς σαλευθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","καὶ τότε ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν νεφέλαις μετὰ δυνάμεως πολλῆς καὶ δόξης· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","καὶ τότε ἀποστελεῖ τοὺς ⸀ἀγγέλουςκαὶ ἐπισυνάξει τοὺς ⸀ἐκλεκτοὺςἐκ τῶν τεσσάρων ἀνέμων ἀπʼ ἄκρου γῆς ἕως ἄκρου οὐρανοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ἀπὸ δὲ τῆς συκῆς μάθετε τὴν παραβολήν· ὅταν ⸂ἤδη ὁ κλάδος αὐτῆς ἁπαλὸς γένηται καὶ ἐκφύῃ τὰ φύλλα, γινώσκετε ὅτι ἐγγὺς τὸ θέρος ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","οὕτως καὶ ὑμεῖς, ὅταν ⸂ἴδητε ταῦτα γινόμενα, γινώσκετε ὅτι ἐγγύς ἐστιν ἐπὶ θύραις. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ἀμὴν λέγω ὑμῖν ὅτι οὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη μέχρις οὗ ⸂ταῦτα πάντα γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ὁ οὐρανὸς καὶ ἡ γῆ ⸀παρελεύσονται οἱ δὲ λόγοι μου οὐ ⸀μὴ⸁παρελεύσονται ");
INSERT INTO grcsbl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Περὶ δὲ τῆςἡμέρας ἐκείνης ἢ ⸀τῆς ὥρας οὐδεὶς οἶδεν, οὐδὲ οἱ ἄγγελοι ⸀ἐνοὐρανῷ οὐδὲ ὁ υἱός, εἰ μὴ ὁ πατήρ. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","βλέπετε ⸀ἀγρυπνεῖτε οὐκ οἴδατε γὰρ πότε ὁ καιρός ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ὡς ἄνθρωπος ἀπόδημος ἀφεὶς τὴν οἰκίαν αὐτοῦ καὶ δοὺς τοῖς δούλοις αὐτοῦ τὴν ἐξουσίαν, ⸀ἑκάστῳτὸ ἔργον αὐτοῦ, καὶ τῷ θυρωρῷ ἐνετείλατο ἵνα γρηγορῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","γρηγορεῖτε οὖν, οὐκ οἴδατε γὰρ πότε ὁ κύριος τῆς οἰκίας ἔρχεται, ⸀ἢὀψὲ ἢ ⸀μεσονύκτιονἢ ἀλεκτοροφωνίας ἢ πρωΐ, ");
INSERT INTO grcsbl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","μὴ ἐλθὼν ἐξαίφνης εὕρῃ ὑμᾶς καθεύδοντας· ");
INSERT INTO grcsbl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","⸀ὃδὲ ὑμῖν λέγω πᾶσιν λέγω· γρηγορεῖτε. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ἦν δὲ τὸ πάσχα καὶ τὰ ἄζυμα μετὰ δύο ἡμέρας. καὶ ἐζήτουν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς πῶς αὐτὸν ἐν δόλῳ κρατήσαντες ἀποκτείνωσιν, ");
INSERT INTO grcsbl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ἔλεγον ⸀γάρ Μὴ ἐν τῇ ἑορτῇ, μήποτε ⸂ἔσται θόρυβος τοῦ λαοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Καὶ ὄντος αὐτοῦ ἐν Βηθανίᾳ ἐν τῇ οἰκίᾳ Σίμωνος τοῦ λεπροῦ κατακειμένου αὐτοῦ ἦλθεν γυνὴ ἔχουσα ἀλάβαστρον μύρου νάρδου πιστικῆς πολυτελοῦς· ⸀συντρίψασα⸀τὴνἀλάβαστρον κατέχεεν ⸀αὐτοῦτῆς κεφαλῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ἦσαν δέ τινες ἀγανακτοῦντες πρὸς ⸀ἑαυτούς Εἰς τί ἡ ἀπώλεια αὕτη τοῦ μύρου γέγονεν; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ἠδύνατο γὰρ τοῦτο ⸂τὸ μύρον πραθῆναι ἐπάνω ⸂δηναρίων τριακοσίων καὶ δοθῆναι τοῖς πτωχοῖς· καὶ ἐνεβριμῶντο αὐτῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ὁ δὲ Ἰησοῦς εἶπεν· Ἄφετε αὐτήν· τί αὐτῇ κόπους παρέχετε; καλὸν ἔργον ἠργάσατο ἐν ἐμοί· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","πάντοτε γὰρ τοὺς πτωχοὺς ἔχετε μεθʼ ἑαυτῶν, καὶ ὅταν θέλητε δύνασθε ⸀αὐτοῖςεὖ ποιῆσαι, ἐμὲ δὲ οὐ πάντοτε ἔχετε· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ὃ ⸀ἔσχενἐποίησεν, προέλαβεν μυρίσαι ⸂τὸ σῶμά μου εἰς τὸν ἐνταφιασμόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ἀμὴν ⸀δὲλέγω ὑμῖν, ὅπου ⸀ἐὰνκηρυχθῇ τὸ ⸀εὐαγγέλιονεἰς ὅλον τὸν κόσμον, καὶ ὃ ἐποίησεν αὕτη λαληθήσεται εἰς μνημόσυνον αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","⸀ΚαὶἸούδας ⸂Ἰσκαριὼθ ὁ εἷς τῶν δώδεκα ἀπῆλθεν πρὸς τοὺς ἀρχιερεῖς ἵνα αὐτὸν ⸂παραδοῖ αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","οἱ δὲ ἀκούσαντες ἐχάρησαν καὶ ἐπηγγείλαντο αὐτῷ ἀργύριον δοῦναι. καὶ ἐζήτει πῶς ⸂αὐτὸν εὐκαίρως παραδοῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Καὶ τῇ πρώτῃ ἡμέρᾳ τῶν ἀζύμων, ὅτε τὸ πάσχα ἔθυον, λέγουσιν αὐτῷ οἱ μαθηταὶ αὐτοῦ· Ποῦ θέλεις ἀπελθόντες ἑτοιμάσωμεν ἵνα φάγῃς τὸ πάσχα; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","καὶ ἀποστέλλει δύο τῶν μαθητῶν αὐτοῦ καὶ λέγει αὐτοῖς· Ὑπάγετε εἰς τὴν πόλιν, καὶ ἀπαντήσει ὑμῖν ἄνθρωπος κεράμιον ὕδατος βαστάζων· ἀκολουθήσατε αὐτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","καὶ ὅπου ⸀ἐὰνεἰσέλθῃ εἴπατε τῷ οἰκοδεσπότῃ ὅτι Ὁ διδάσκαλος λέγει· Ποῦ ἐστιν τὸ κατάλυμά ⸀μουὅπου τὸ πάσχα μετὰ τῶν μαθητῶν μου φάγω; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","καὶαὐτὸς ὑμῖν δείξει ἀνάγαιον μέγα ἐστρωμένον ἕτοιμον· ⸀καὶ ἐκεῖ ἑτοιμάσατε ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","καὶ ἐξῆλθον οἱ ⸀μαθηταὶκαὶ ἦλθον εἰς τὴν πόλιν καὶ εὗρον καθὼς εἶπεν αὐτοῖς, καὶ ἡτοίμασαν τὸ πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Καὶ ὀψίας γενομένης ἔρχεται μετὰ τῶν δώδεκα. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","καὶ ἀνακειμένων αὐτῶν καὶ ἐσθιόντων ⸂ὁ Ἰησοῦς εἶπεν· Ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με ὁ ἐσθίων μετʼ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","⸀ἤρξαντολυπεῖσθαι καὶ λέγειν αὐτῷ εἷς κατὰ εἷς· Μήτι ⸀ἐγώ ");
INSERT INTO grcsbl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ὁ ⸀δὲεἶπεν αὐτοῖς· ⸀Εἷςτῶν δώδεκα, ὁ ἐμβαπτόμενος μετʼ ἐμοῦ εἰς ⸀τὸτρύβλιον· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","⸀ὅτιὁ μὲν υἱὸς τοῦ ἀνθρώπου ὑπάγει καθὼς γέγραπται περὶ αὐτοῦ, οὐαὶ δὲ τῷ ἀνθρώπῳ ἐκείνῳ διʼ οὗ ὁ υἱὸς τοῦ ἀνθρώπου παραδίδοται· ⸀καλὸναὐτῷ εἰ οὐκ ἐγεννήθη ὁ ἄνθρωπος ἐκεῖνος. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Καὶ ἐσθιόντων αὐτῶν ⸀λαβὼνἄρτον εὐλογήσας ἔκλασεν καὶ ἔδωκεν αὐτοῖς καὶ εἶπεν· ⸀Λάβετε, τοῦτό ἐστιν τὸ σῶμά μου. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","καὶ ⸀λαβὼνποτήριον εὐχαριστήσας ἔδωκεν αὐτοῖς, καὶ ἔπιον ἐξ αὐτοῦ πάντες. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","καὶ εἶπεν αὐτοῖς· Τοῦτό ἐστιν τὸ αἷμά μου ⸀τῆςδιαθήκης τὸ ⸂ἐκχυννόμενον ὑπὲρ πολλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ἀμὴν λέγω ὑμῖν ὅτι οὐκέτι οὐ μὴ πίω ἐκ τοῦ γενήματος τῆς ἀμπέλου ἕως τῆς ἡμέρας ἐκείνης ὅταν αὐτὸ πίνω καινὸν ἐν τῇ βασιλείᾳ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Καὶ ὑμνήσαντες ἐξῆλθον εἰς τὸ Ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Καὶ λέγει αὐτοῖς ὁ Ἰησοῦς ὅτι Πάντες ⸀σκανδαλισθήσεσθε ὅτι γέγραπται· Πατάξω τὸν ποιμένα, καὶ ⸂τὰ πρόβατα διασκορπισθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ἀλλὰ μετὰ τὸ ἐγερθῆναί με προάξω ὑμᾶς εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ὁ δὲ Πέτρος ἔφη αὐτῷ· ⸂Εἰ καὶ πάντες σκανδαλισθήσονται, ἀλλʼ οὐκ ἐγώ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","καὶ λέγει αὐτῷ ὁ Ἰησοῦς· Ἀμὴν λέγω σοι ὅτι σὺ σήμερον ⸂ταύτῃ τῇ νυκτὶ πρὶν ἢ δὶς ἀλέκτορα φωνῆσαι τρίς ⸂με ἀπαρνήσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ὁ δὲ ⸂ἐκπερισσῶς ἐλάλει· Ἐὰν ⸂δέῃ με συναποθανεῖν σοι, οὐ μή σε ⸀ἀπαρνήσομαι ὡσαύτως δὲ καὶ πάντες ἔλεγον. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Καὶ ἔρχονται εἰς χωρίον οὗ τὸ ὄνομα Γεθσημανί, καὶ λέγει τοῖς μαθηταῖς αὐτοῦ· Καθίσατε ὧδε ἕως προσεύξωμαι. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","καὶ παραλαμβάνει τὸν Πέτρον καὶ ⸂Ἰάκωβον καὶ Ἰωάννην μετʼ ⸀αὐτοῦ καὶ ἤρξατο ἐκθαμβεῖσθαι καὶ ἀδημονεῖν, ");
INSERT INTO grcsbl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","καὶ λέγει αὐτοῖς· Περίλυπός ἐστιν ἡ ψυχή μου ἕως θανάτου· μείνατε ὧδε καὶ γρηγορεῖτε. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","καὶ ⸂προελθὼν μικρὸν ἔπιπτεν ἐπὶ τῆς γῆς, καὶ προσηύχετο ἵνα εἰ δυνατόν ἐστιν παρέλθῃ ἀπʼ αὐτοῦ ἡ ὥρα, ");
INSERT INTO grcsbl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","καὶ ἔλεγεν· Αββα ὁ πατήρ, πάντα δυνατά σοι· παρένεγκε τὸ ποτήριον ⸂τοῦτο ἀπʼ ἐμοῦ· ἀλλʼ οὐ τί ἐγὼ θέλω ἀλλὰ τί σύ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","καὶ ἔρχεται καὶ εὑρίσκει αὐτοὺς καθεύδοντας, καὶ λέγει τῷ Πέτρῳ· Σίμων, καθεύδεις; οὐκ ἴσχυσας μίαν ὥραν γρηγορῆσαι; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","γρηγορεῖτε καὶ προσεύχεσθε, ἵνα μὴ ⸀ἔλθητεεἰς πειρασμόν· τὸ μὲν πνεῦμα πρόθυμον ἡ δὲ σὰρξ ἀσθενής. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","καὶ πάλιν ἀπελθὼν προσηύξατο τὸν αὐτὸν λόγον εἰπών. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","καὶ ⸂πάλιν ἐλθὼν εὗρεν αὐτοὺς καθεύδοντας, ἦσαν γὰρ ⸂αὐτῶν οἱ ὀφθαλμοὶ ⸀καταβαρυνόμενοι καὶ οὐκ ᾔδεισαν τί ⸂ἀποκριθῶσιν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","καὶ ἔρχεται τὸτρίτον καὶ λέγει αὐτοῖς· Καθεύδετε ⸀τὸ λοιπὸν καὶ ἀναπαύεσθε· ἀπέχει· ἦλθεν ἡ ὥρα, ἰδοὺ παραδίδοται ὁ υἱὸς τοῦ ἀνθρώπου εἰς τὰς χεῖρας τῶν ἁμαρτωλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ἐγείρεσθε ἄγωμεν· ἰδοὺ ὁ παραδιδούς με ἤγγικεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Καὶ ⸀εὐθὺςἔτι αὐτοῦ λαλοῦντος παραγίνεται ⸀Ἰούδας⸀εἷςτῶν δώδεκα καὶ μετʼ αὐτοῦ ⸀ὄχλοςμετὰ μαχαιρῶν καὶ ξύλων παρὰ τῶν ἀρχιερέων καὶ τῶν γραμματέων καὶ τῶν πρεσβυτέρων. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","δεδώκει δὲ ὁ παραδιδοὺς αὐτὸν σύσσημον αὐτοῖς λέγων· Ὃν ἂν φιλήσω αὐτός ἐστιν· κρατήσατε αὐτὸν καὶ ⸀ἀπάγετεἀσφαλῶς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","καὶ ἐλθὼν ⸀εὐθὺςπροσελθὼν αὐτῷ λέγει· ⸀Ῥαββί καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","οἱ δὲ ἐπέβαλαν ⸂τὰς χεῖρας αὐτῷ καὶ ἐκράτησαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","εἷς δέ ⸀τιςτῶν παρεστηκότων σπασάμενος τὴν μάχαιραν ἔπαισεν τὸν δοῦλον τοῦ ἀρχιερέως καὶ ἀφεῖλεν αὐτοῦ τὸ ⸀ὠτάριον ");
INSERT INTO grcsbl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν αὐτοῖς· Ὡς ἐπὶ λῃστὴν ἐξήλθατε μετὰ μαχαιρῶν καὶ ξύλων συλλαβεῖν με; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","καθʼ ἡμέραν ἤμην πρὸς ὑμᾶς ἐν τῷ ἱερῷ διδάσκων καὶ οὐκ ἐκρατήσατέ με· ἀλλʼ ἵνα πληρωθῶσιν αἱ γραφαί. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","καὶ ἀφέντες αὐτὸν ⸂ἔφυγον πάντες. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Καὶ ⸂νεανίσκος τις ⸀συνηκολούθειαὐτῷ περιβεβλημένος σινδόνα ἐπὶ γυμνοῦ, καὶ κρατοῦσιν ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ὁ δὲ καταλιπὼν τὴν σινδόνα γυμνὸς ⸀ἔφυγεν ");
INSERT INTO grcsbl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Καὶ ἀπήγαγον τὸν Ἰησοῦν πρὸς τὸν ἀρχιερέα, καὶ ⸀συνέρχονταιπάντες οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι καὶ οἱ γραμματεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","καὶ ὁ Πέτρος ἀπὸ μακρόθεν ἠκολούθησεν αὐτῷ ἕως ἔσω εἰς τὴν αὐλὴν τοῦ ἀρχιερέως καὶ ἦν συγκαθήμενος μετὰ τῶν ὑπηρετῶν καὶ θερμαινόμενος πρὸς τὸ φῶς. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","οἱ δὲ ἀρχιερεῖς καὶ ὅλον τὸ συνέδριον ἐζήτουν κατὰ τοῦ Ἰησοῦ μαρτυρίαν εἰς τὸ θανατῶσαι αὐτόν, καὶ οὐχ ηὕρισκον· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","πολλοὶ γὰρ ἐψευδομαρτύρουν κατʼ αὐτοῦ, καὶ ἴσαι αἱ μαρτυρίαι οὐκ ἦσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","καί τινες ἀναστάντες ἐψευδομαρτύρουν κατʼ αὐτοῦ λέγοντες ");
INSERT INTO grcsbl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ὅτι Ἡμεῖς ἠκούσαμεν αὐτοῦ λέγοντος ὅτι Ἐγὼ καταλύσω τὸν ναὸν τοῦτον τὸν χειροποίητον καὶ διὰ τριῶν ἡμερῶν ἄλλον ἀχειροποίητον οἰκοδομήσω· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","καὶ οὐδὲ οὕτως ἴση ἦν ἡ μαρτυρία αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","καὶ ἀναστὰς ὁ ἀρχιερεὺς εἰς μέσον ἐπηρώτησεν τὸν Ἰησοῦν λέγων· Οὐκ ἀποκρίνῃ οὐδέν; τί οὗτοί σου καταμαρτυροῦσιν; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ὁ δὲ ἐσιώπα καὶ ⸂οὐκ ἀπεκρίνατο οὐδέν. πάλιν ὁ ἀρχιερεὺς ἐπηρώτα αὐτὸν καὶ λέγει αὐτῷ· Σὺ εἶ ὁ χριστὸς ὁ υἱὸς τοῦ εὐλογητοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ὁ δὲ Ἰησοῦς εἶπεν· Ἐγώ εἰμι, καὶ ὄψεσθε τὸν υἱὸν τοῦ ἀνθρώπου ἐκ δεξιῶν καθήμενον τῆς δυνάμεως καὶ ἐρχόμενον μετὰ τῶν νεφελῶν τοῦ οὐρανοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ὁ δὲ ἀρχιερεὺς διαρρήξας τοὺς χιτῶνας αὐτοῦ λέγει· Τί ἔτι χρείαν ἔχομεν μαρτύρων; ");
INSERT INTO grcsbl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ἠκούσατε τῆς βλασφημίας· τί ὑμῖν φαίνεται; οἱ δὲ πάντες κατέκριναν αὐτὸν ⸂ἔνοχον εἶναι θανάτου. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","καὶ ἤρξαντό τινες ἐμπτύειν αὐτῷ καὶ περικαλύπτειν ⸂αὐτοῦ τὸ πρόσωπον καὶ κολαφίζειν αὐτὸν καὶ λέγειν αὐτῷ· Προφήτευσον, καὶ οἱ ὑπηρέται ῥαπίσμασιν αὐτὸν ⸀ἔλαβον ");
INSERT INTO grcsbl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Καὶ ὄντος τοῦ Πέτρου ⸂κάτω ἐν τῇ αὐλῇ ἔρχεται μία τῶν παιδισκῶν τοῦ ἀρχιερέως, ");
INSERT INTO grcsbl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","καὶ ἰδοῦσα τὸν Πέτρον θερμαινόμενον ἐμβλέψασα αὐτῷ λέγει· Καὶ σὺ μετὰ τοῦ Ναζαρηνοῦ ⸂ἦσθα τοῦ Ἰησοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ὁ δὲ ἠρνήσατο λέγων· ⸂Οὔτε οἶδα οὔτε ἐπίσταμαι σὺ τί λέγεις, καὶ ἐξῆλθεν ἔξω εἰς τὸ προαύλιον ⸂καὶ ἀλέκτωρ ἐφώνησεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","καὶ ἡ παιδίσκη ἰδοῦσα αὐτὸν ⸂ἤρξατο πάλιν λέγειν τοῖς ⸀παρεστῶσινὅτι Οὗτος ἐξ αὐτῶν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ὁ δὲ πάλιν ἠρνεῖτο. καὶ μετὰ μικρὸν πάλιν οἱ παρεστῶτες ἔλεγον τῷ Πέτρῳ· Ἀληθῶς ἐξ αὐτῶν εἶ, καὶ γὰρ Γαλιλαῖος εἶ ⸂καὶ ἡ λαλιά σου ὁμοιάζει· ");
INSERT INTO grcsbl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ὁ δὲ ἤρξατο ἀναθεματίζειν καὶ ὀμνύναι ὅτι Οὐκ οἶδα τὸν ἄνθρωπον τοῦτον ὃν λέγετε. ");
INSERT INTO grcsbl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","καὶ ⸀εὐθὺςἐκ δευτέρου ἀλέκτωρ ἐφώνησεν· καὶ ἀνεμνήσθη ὁ Πέτρος τὸ ῥῆμα ⸀ὡςεἶπεν αὐτῷ ὁ Ἰησοῦς ὅτι Πρὶν ἀλέκτορα ⸂φωνῆσαι δὶς τρίς με ἀπαρνήσῃ, καὶ ἐπιβαλὼν ἔκλαιεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Καὶ ⸀εὐθὺςπρωῒ συμβούλιον ποιήσαντες οἱ ἀρχιερεῖς μετὰ τῶν πρεσβυτέρων καὶ γραμματέων καὶ ὅλον τὸ συνέδριον δήσαντες τὸν Ἰησοῦν ἀπήνεγκαν καὶ ⸀παρέδωκανΠιλάτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","καὶ ἐπηρώτησεν αὐτὸν ὁ Πιλᾶτος· Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; ὁ δὲ ἀποκριθεὶς ⸂αὐτῷ λέγει· Σὺ λέγεις. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","καὶ κατηγόρουν αὐτοῦ οἱ ἀρχιερεῖς πολλά. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ὁ δὲ Πιλᾶτος πάλιν ⸀ἐπηρώτααὐτὸν λέγων· Οὐκ ἀποκρίνῃ οὐδέν; ἴδε πόσα σου ⸀κατηγοροῦσιν ");
INSERT INTO grcsbl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ὁ δὲ Ἰησοῦς οὐκέτι οὐδὲν ἀπεκρίθη, ὥστε θαυμάζειν τὸν Πιλᾶτον. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Κατὰ δὲ ἑορτὴν ἀπέλυεν αὐτοῖς ἕνα δέσμιον ⸂ὃν παρῃτοῦντο. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ἦν δὲ ὁ λεγόμενος Βαραββᾶς μετὰ τῶν ⸀στασιαστῶνδεδεμένος οἵτινες ἐν τῇ στάσει φόνον πεποιήκεισαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","καὶ ⸀ἀναβὰςὁ ὄχλος ἤρξατο αἰτεῖσθαι ⸀καθὼςἐποίει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ὁ δὲ Πιλᾶτος ἀπεκρίθη αὐτοῖς λέγων· Θέλετε ἀπολύσω ὑμῖν τὸν βασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grcsbl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ἐγίνωσκεν γὰρ ὅτι διὰ φθόνον παραδεδώκεισαν αὐτὸν οἱ ἀρχιερεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","οἱ δὲ ἀρχιερεῖς ἀνέσεισαν τὸν ὄχλον ἵνα μᾶλλον τὸν Βαραββᾶν ἀπολύσῃ αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ὁ δὲ Πιλᾶτος ⸂πάλιν ἀποκριθεὶς ἔλεγεν αὐτοῖς· Τί οὖν ⸀θέλετεποιήσω ⸂ὃν λέγετε ⸀τὸνβασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grcsbl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","οἱ δὲ πάλιν ἔκραξαν· Σταύρωσον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ὁ δὲ Πιλᾶτος ἔλεγεν αὐτοῖς· Τί γὰρ ⸂ἐποίησεν κακόν; οἱ δὲ ⸀περισσῶςἔκραξαν· Σταύρωσον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ὁ δὲ Πιλᾶτος βουλόμενος τῷ ὄχλῳ τὸ ἱκανὸν ποιῆσαι ἀπέλυσεν αὐτοῖς τὸν Βαραββᾶν, καὶ παρέδωκεν τὸν Ἰησοῦν φραγελλώσας ἵνα σταυρωθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Οἱ δὲ στρατιῶται ἀπήγαγον αὐτὸν ἔσω τῆς αὐλῆς, ὅ ἐστιν πραιτώριον, καὶ συγκαλοῦσιν ὅλην τὴν σπεῖραν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","καὶ ⸀ἐνδιδύσκουσιναὐτὸν πορφύραν καὶ περιτιθέασιν αὐτῷ πλέξαντες ἀκάνθινον στέφανον· ");
INSERT INTO grcsbl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","καὶ ἤρξαντο ἀσπάζεσθαι αὐτόν· Χαῖρε, ⸀βασιλεῦτῶν Ἰουδαίων· ");
INSERT INTO grcsbl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","καὶ ἔτυπτον αὐτοῦ τὴν κεφαλὴν καλάμῳ καὶ ἐνέπτυον αὐτῷ, καὶ τιθέντες τὰ γόνατα προσεκύνουν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","καὶ ὅτε ἐνέπαιξαν αὐτῷ, ἐξέδυσαν αὐτὸν τὴν πορφύραν καὶ ἐνέδυσαν αὐτὸν τὰ ἱμάτια ⸂τὰ ἴδια. καὶ ἐξάγουσιν αὐτὸν ἵνα ⸀σταυρώσωσιναὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Καὶ ἀγγαρεύουσιν παράγοντά τινα Σίμωνα Κυρηναῖον ἐρχόμενον ἀπʼ ἀγροῦ, τὸν πατέρα Ἀλεξάνδρου καὶ Ῥούφου, ἵνα ἄρῃ τὸν σταυρὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","καὶ φέρουσιν αὐτὸνἐπὶ ⸀τὸν ⸀Γολγοθᾶντόπον, ὅ ἐστιν ⸀μεθερμηνευόμενονΚρανίου Τόπος. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","καὶ ἐδίδουν ⸀αὐτῷἐσμυρνισμένον οἶνον, ⸀ὃςδὲ οὐκ ἔλαβεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","καὶ ⸂σταυροῦσιν αὐτὸν καὶ διαμερίζονται τὰ ἱμάτια αὐτοῦ, βάλλοντες κλῆρον ἐπʼ αὐτὰ τίς τί ἄρῃ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ἦν δὲ ὥρα τρίτη καὶ ἐσταύρωσαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","καὶ ἦν ἡ ἐπιγραφὴ τῆς αἰτίας αὐτοῦ ἐπιγεγραμμένη· Ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","καὶ σὺν αὐτῷ σταυροῦσιν δύο λῃστάς, ἕνα ἐκ δεξιῶν καὶ ἕνα ἐξ εὐωνύμων ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Καὶ οἱ παραπορευόμενοι ἐβλασφήμουν αὐτὸν κινοῦντες τὰς κεφαλὰς αὐτῶν καὶ λέγοντες· Οὐὰ ὁ καταλύων τὸν ναὸν καὶ ⸂οἰκοδομῶν ἐν τρισὶν ἡμέραις, ");
INSERT INTO grcsbl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","σῶσον σεαυτὸν ⸀καταβὰςἀπὸ τοῦ σταυροῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ὁμοίως καὶ οἱ ἀρχιερεῖς ἐμπαίζοντες πρὸς ἀλλήλους μετὰ τῶν γραμματέων ἔλεγον· Ἄλλους ἔσωσεν, ἑαυτὸν οὐ δύναται σῶσαι· ");
INSERT INTO grcsbl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ὁ χριστὸς ὁ ⸀βασιλεὺςἸσραὴλ καταβάτω νῦν ἀπὸ τοῦ σταυροῦ, ἵνα ἴδωμεν καὶ ⸀πιστεύσωμεν καὶ οἱ συνεσταυρωμένοι ⸀σὺναὐτῷ ὠνείδιζον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","⸂Καὶ γενομένης ὥρας ἕκτης σκότος ἐγένετο ἐφʼ ὅλην τὴν γῆν ἕως ὥρας ἐνάτης. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","καὶ τῇ ⸂ἐνάτῃ ὥρᾳ ἐβόησεν ὁ Ἰησοῦς φωνῇ ⸀μεγάλῃ Ἐλωῒ ἐλωῒ ⸀λεμὰσαβαχθάνι; ὅ ἐστιν μεθερμηνευόμενον Ὁ θεός μου ὁ θεός μου, εἰς τί ⸂ἐγκατέλιπές με; ");
INSERT INTO grcsbl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","καί τινες τῶν παρεστηκότων ἀκούσαντες ἔλεγον· ⸀ἼδεἨλίαν φωνεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","δραμὼν δέ ⸂τις καὶ γεμίσας σπόγγον ὄξους ⸀περιθεὶςκαλάμῳ ἐπότιζεν αὐτόν, λέγων· Ἄφετε ἴδωμεν εἰ ἔρχεται Ἠλίας καθελεῖν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ὁ δὲ Ἰησοῦς ἀφεὶς φωνὴν μεγάλην ἐξέπνευσεν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","καὶ τὸ καταπέτασμα τοῦ ναοῦ ἐσχίσθη εἰς δύο ἀπʼ ἄνωθεν ἕως κάτω. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ἰδὼν δὲ ὁ κεντυρίων ὁ παρεστηκὼς ἐξ ἐναντίας αὐτοῦ ὅτι ⸀οὕτωςἐξέπνευσεν εἶπεν· Ἀληθῶς ⸂οὗτος ὁ ἄνθρωπος υἱὸς ⸂θεοῦ ἦν. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ἦσαν δὲ καὶ γυναῖκες ἀπὸ μακρόθεν θεωροῦσαι, ἐν ⸀αἷςκαὶ ⸀ΜαρίαἡΜαγδαληνὴ καὶ Μαρία ⸀ἡ Ἰακώβου τοῦ μικροῦ καὶ ⸀Ἰωσῆτοςμήτηρ καὶ Σαλώμη, ");
INSERT INTO grcsbl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","⸀αἳὅτε ἦν ἐν τῇ Γαλιλαίᾳ ἠκολούθουν αὐτῷ καὶ διηκόνουν αὐτῷ, καὶ ἄλλαι πολλαὶ αἱ συναναβᾶσαι αὐτῷ εἰς Ἱεροσόλυμα. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Καὶ ἤδη ὀψίας γενομένης, ἐπεὶ ἦν παρασκευή, ὅ ἐστιν ⸀προσάββατον ");
INSERT INTO grcsbl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","⸀ἐλθὼνἸωσὴφ ⸀ὁἀπὸ Ἁριμαθαίας εὐσχήμων βουλευτής, ὃς καὶ αὐτὸς ἦν προσδεχόμενος τὴν βασιλείαν τοῦ θεοῦ, τολμήσας εἰσῆλθεν πρὸς ⸀τὸνΠιλᾶτον καὶ ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ὁ δὲ Πιλᾶτος ἐθαύμασεν εἰ ἤδη τέθνηκεν, καὶ προσκαλεσάμενος τὸν κεντυρίωνα ἐπηρώτησεν αὐτὸν εἰ ⸀πάλαιἀπέθανεν· ");
INSERT INTO grcsbl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","καὶ γνοὺς ἀπὸ τοῦ κεντυρίωνος ἐδωρήσατο τὸ ⸀πτῶματῷ Ἰωσήφ. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","καὶ ἀγοράσας ⸀σινδόνακαθελὼν αὐτὸν ἐνείλησεν τῇ σινδόνι καὶ ⸀ἔθηκεναὐτὸν ἐν ⸀μνημείῳὃ ἦν λελατομημένον ἐκ πέτρας, καὶ προσεκύλισεν λίθον ἐπὶ τὴν θύραν τοῦ μνημείου. ");
INSERT INTO grcsbl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ἡ δὲ Μαρία ἡ Μαγδαληνὴ καὶ Μαρία ⸂ἡ Ἰωσῆτος ἐθεώρουν ποῦ ⸀τέθειται ");
INSERT INTO grcsbl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Καὶ διαγενομένου τοῦ σαββάτου ⸀Μαρίαἡ Μαγδαληνὴ καὶ Μαρία ⸂ἡ τοῦ Ἰακώβου καὶ Σαλώμη ἠγόρασαν ἀρώματα ἵνα ἐλθοῦσαι ἀλείψωσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","καὶ λίαν πρωῒ ⸂τῇ μιᾷ τῶν σαββάτων ἔρχονται ἐπὶ τὸ μνημεῖον ἀνατείλαντος τοῦ ἡλίου. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","καὶ ἔλεγον πρὸς ἑαυτάς· Τίς ἀποκυλίσει ἡμῖν τὸν λίθον ⸀ἐκτῆς θύρας τοῦ μνημείου; ");
INSERT INTO grcsbl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","καὶ ἀναβλέψασαι θεωροῦσιν ὅτι ⸀ἀποκεκύλισταιὁ λίθος, ἦν γὰρ μέγας σφόδρα. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","καὶ εἰσελθοῦσαι εἰς τὸ μνημεῖον εἶδον νεανίσκον καθήμενον ἐν τοῖς δεξιοῖς περιβεβλημένον στολὴν λευκήν, καὶ ἐξεθαμβήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ὁ δὲ λέγει αὐταῖς· Μὴ ἐκθαμβεῖσθε· Ἰησοῦν ζητεῖτε τὸν Ναζαρηνὸν τὸν ἐσταυρωμένον· ἠγέρθη, οὐκ ἔστιν ὧδε· ἴδε ὁ τόπος ὅπου ἔθηκαν αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ἀλλὰ ὑπάγετε εἴπατε τοῖς μαθηταῖς αὐτοῦ καὶ τῷ Πέτρῳ ὅτι Προάγει ὑμᾶς εἰς τὴν Γαλιλαίαν· ἐκεῖ αὐτὸν ὄψεσθε, καθὼς εἶπεν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","καὶ ἐξελθοῦσαι ἔφυγον ἀπὸ τοῦ μνημείου, εἶχεν ⸀γὰραὐτὰς τρόμος καὶ ἔκστασις· καὶ οὐδενὶ οὐδὲν εἶπαν, ἐφοβοῦντο ⸁γάρ ⟦Πάντα δὲ τὰ παρηγγελμένα τοῖς περὶ τὸν Πέτρον συντόμως ἐξήγγειλαν. μετὰ δὲ ταῦτα καὶ αὐτὸς ὁ Ἰησοῦς ἀπὸ ἀνατολῆς καὶ ἄχρι δύσεως ἐξαπέστειλεν διʼ αὐτῶν τὸ ἱερὸν καὶ ἄφθαρτον κήρυγμα τῆς αἰωνίου σωτηρίας. ἀμήν.⟧ ");
INSERT INTO grcsbl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ἀναστὰς δὲ πρωῒ πρώτῃ σαββάτου ἐφάνη πρῶτον Μαρίᾳ τῇ Μαγδαληνῇ, ⸀παρʼ ἧς ἐκβεβλήκει ἑπτὰ δαιμόνια. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ἐκείνη πορευθεῖσα ἀπήγγειλεν τοῖς μετʼ αὐτοῦ γενομένοις πενθοῦσι καὶ κλαίουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","κἀκεῖνοι ἀκούσαντες ὅτι ζῇ καὶ ἐθεάθη ὑπʼ αὐτῆς ἠπίστησαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Μετὰ δὲ ταῦτα δυσὶν ἐξ αὐτῶν περιπατοῦσιν ἐφανερώθη ἐν ἑτέρᾳ μορφῇ πορευομένοις εἰς ἀγρόν· ");
INSERT INTO grcsbl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","κἀκεῖνοι ἀπελθόντες ἀπήγγειλαν τοῖς λοιποῖς· οὐδὲ ἐκείνοις ἐπίστευσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","στερον ⸀δὲ ἀνακειμένοις αὐτοῖς τοῖς ἕνδεκα ἐφανερώθη, καὶ ὠνείδισεν τὴν ἀπιστίαν αὐτῶν καὶ σκληροκαρδίαν ὅτι τοῖς θεασαμένοις αὐτὸν ⸀ἐγηγερμένονοὐκ ἐπίστευσαν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","καὶ εἶπεν αὐτοῖς· Πορευθέντες εἰς τὸν κόσμον ἅπαντα κηρύξατε τὸ εὐαγγέλιον πάσῃ τῇ κτίσει. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ὁ πιστεύσας καὶ βαπτισθεὶς σωθήσεται, ὁ δὲ ἀπιστήσας κατακριθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","σημεῖα δὲ τοῖς πιστεύσασιν ⸂ταῦτα παρακολουθήσει, ἐν τῷ ὀνόματί μου δαιμόνια ἐκβαλοῦσιν, γλώσσαις λαλήσουσιν ⸀καιναῖς ");
INSERT INTO grcsbl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","⸀ὄφειςἀροῦσιν κἂν θανάσιμόν τι πίωσιν οὐ μὴ αὐτοὺς βλάψῃ, ἐπὶ ἀρρώστους χεῖρας ἐπιθήσουσιν καὶ καλῶς ἕξουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","μὲν οὖν κύριος ⸀Ἰησοῦς μετὰ τὸ λαλῆσαι αὐτοῖς ἀνελήμφθη εἰς τὸν οὐρανὸν καὶ ἐκάθισεν ἐκ δεξιῶν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","κεῖνοι δὲ ἐξελθόντες ἐκήρυξαν πανταχοῦ, τοῦ κυρίου συνεργοῦντος καὶ τὸν λόγον βεβαιοῦντος διὰ τῶν ἐπακολουθούντων ⸀σημείων.⟧ ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ἐπειδήπερ πολλοὶ ἐπεχείρησαν ἀνατάξασθαι διήγησιν περὶ τῶν πεπληροφορημένων ἐν ἡμῖν πραγμάτων, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","καθὼς παρέδοσαν ἡμῖν οἱ ἀπʼ ἀρχῆς αὐτόπται καὶ ὑπηρέται γενόμενοι τοῦ λόγου, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ἔδοξε κἀμοὶ παρηκολουθηκότι ἄνωθεν πᾶσιν ἀκριβῶς καθεξῆς σοι γράψαι, κράτιστε Θεόφιλε, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ἵνα ἐπιγνῷς περὶ ὧν κατηχήθης λόγων τὴν ἀσφάλειαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ἐγένετο ἐν ταῖς ἡμέραις ⸀Ἡρῴδουβασιλέως τῆς Ἰουδαίας ἱερεύς τις ὀνόματι Ζαχαρίας ἐξ ἐφημερίας Ἀβιά, ⸀καὶγυνὴ ⸀αὐτῷἐκ τῶν θυγατέρων Ἀαρών, καὶ τὸ ὄνομα αὐτῆς Ἐλισάβετ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ἦσαν δὲ δίκαιοι ἀμφότεροι ⸀ἐναντίοντοῦ θεοῦ, πορευόμενοι ἐν πάσαις ταῖς ἐντολαῖς καὶ δικαιώμασιν τοῦ κυρίου ἄμεμπτοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","καὶ οὐκ ἦν αὐτοῖς τέκνον, καθότι ⸂ἦν ἡ Ἐλισάβετ στεῖρα, καὶ ἀμφότεροι προβεβηκότες ἐν ταῖς ἡμέραις αὐτῶν ἦσαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ἐγένετο δὲ ἐν τῷ ἱερατεύειν αὐτὸν ἐν τῇ τάξει τῆς ἐφημερίας αὐτοῦ ἔναντι τοῦ θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","κατὰ τὸ ἔθος τῆς ἱερατείας ἔλαχε τοῦ θυμιᾶσαι εἰσελθὼν εἰς τὸν ναὸν τοῦ κυρίου, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","καὶ πᾶν τὸ πλῆθος ἦν τοῦ λαοῦ προσευχόμενον ἔξω τῇ ὥρᾳ τοῦ θυμιάματος· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ὤφθη δὲ αὐτῷ ἄγγελος κυρίου ἑστὼς ἐκ δεξιῶν τοῦ θυσιαστηρίου τοῦ θυμιάματος. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","καὶ ἐταράχθη Ζαχαρίας ἰδών, καὶ φόβος ἐπέπεσεν ἐπʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","εἶπεν δὲ πρὸς αὐτὸν ὁ ἄγγελος· Μὴ φοβοῦ, Ζαχαρία, διότι εἰσηκούσθη ἡ δέησίς σου, καὶ ἡ γυνή σου Ἐλισάβετ γεννήσει υἱόν σοι, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰωάννην· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","καὶ ἔσται χαρά σοι καὶ ἀγαλλίασις, καὶ πολλοὶ ἐπὶ τῇ ⸀γενέσειαὐτοῦ χαρήσονται· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ἔσται γὰρ μέγας ἐνώπιον ⸀τοῦκυρίου, καὶ οἶνον καὶ σίκερα οὐ μὴ πίῃ, καὶ πνεύματος ἁγίου πλησθήσεται ἔτι ἐκ κοιλίας μητρὸς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","καὶ πολλοὺς τῶν υἱῶν Ἰσραὴλ ἐπιστρέψει ἐπὶ κύριον τὸν θεὸν αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","καὶ αὐτὸς προελεύσεται ἐνώπιον αὐτοῦ ἐν πνεύματι καὶ δυνάμει Ἠλίου, ἐπιστρέψαι καρδίας πατέρων ἐπὶ τέκνα καὶ ἀπειθεῖς ἐν φρονήσει δικαίων, ἑτοιμάσαι κυρίῳ λαὸν κατεσκευασμένον. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","καὶ εἶπεν Ζαχαρίας πρὸς τὸν ἄγγελον· Κατὰ τί γνώσομαι τοῦτο; ἐγὼ γάρ εἰμι πρεσβύτης καὶ ἡ γυνή μου προβεβηκυῖα ἐν ταῖς ἡμέραις αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","καὶ ἀποκριθεὶς ὁ ἄγγελος εἶπεν αὐτῷ· Ἐγώ εἰμι Γαβριὴλ ὁ παρεστηκὼς ἐνώπιον τοῦ θεοῦ, καὶ ἀπεστάλην λαλῆσαι πρὸς σὲ καὶ εὐαγγελίσασθαί σοι ταῦτα· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","καὶ ἰδοὺ ἔσῃ σιωπῶν καὶ μὴ δυνάμενος λαλῆσαι ἄχρι ἧς ἡμέρας γένηται ταῦτα, ἀνθʼ ὧν οὐκ ἐπίστευσας τοῖς λόγοις μου, οἵτινες πληρωθήσονται εἰς τὸν καιρὸν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Καὶ ἦν ὁ λαὸς προσδοκῶν τὸν Ζαχαρίαν, καὶ ἐθαύμαζον ἐν τῷ χρονίζειν ⸂ἐν τῷ ναῷ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ἐξελθὼν δὲ οὐκ ⸀ἐδύνατολαλῆσαι αὐτοῖς, καὶ ἐπέγνωσαν ὅτι ὀπτασίαν ἑώρακεν ἐν τῷ ναῷ· καὶ αὐτὸς ἦν διανεύων αὐτοῖς, καὶ διέμενεν κωφός. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","καὶ ἐγένετο ὡς ἐπλήσθησαν αἱ ἡμέραι τῆς λειτουργίας αὐτοῦ, ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Μετὰ δὲ ταύτας τὰς ἡμέρας συνέλαβεν Ἐλισάβετ ἡ γυνὴ αὐτοῦ· καὶ περιέκρυβεν ἑαυτὴν μῆνας πέντε, λέγουσα ");
INSERT INTO grcsbl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ὅτι Οὕτως μοι ⸀πεποίηκενκύριος ἐν ἡμέραις αἷς ἐπεῖδεν ⸀ἀφελεῖνὄνειδός μου ἐν ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ἐν δὲ τῷ μηνὶ τῷ ἕκτῳ ἀπεστάλη ὁ ἄγγελος Γαβριὴλ ⸀ἀπὸτοῦ θεοῦ εἰς πόλιν τῆς Γαλιλαίας ᾗ ὄνομα Ναζαρὲθ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","πρὸς παρθένον ⸀ἐμνηστευμένηνἀνδρὶ ᾧ ὄνομα Ἰωσὴφ ἐξ οἴκου Δαυίδ, καὶ τὸ ὄνομα τῆς παρθένου Μαριάμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","καὶ ⸀εἰσελθὼνπρὸς αὐτὴν εἶπεν· Χαῖρε, κεχαριτωμένη, ὁ κύριος μετὰ ⸀σοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ἡ δὲ ⸂ἐπὶ τῷ λόγῳ διεταράχθη καὶ διελογίζετο ποταπὸς εἴη ὁ ἀσπασμὸς οὗτος. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","καὶ εἶπεν ὁ ἄγγελος αὐτῇ· Μὴ φοβοῦ, Μαριάμ, εὗρες γὰρ χάριν παρὰ τῷ θεῷ· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","καὶ ἰδοὺ συλλήμψῃ ἐν γαστρὶ καὶ τέξῃ υἱόν, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","οὗτος ἔσται μέγας καὶ υἱὸς Ὑψίστου κληθήσεται, καὶ δώσει αὐτῷ κύριος ὁ θεὸς τὸν θρόνον Δαυὶδ τοῦ πατρὸς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","καὶ βασιλεύσει ἐπὶ τὸν οἶκον Ἰακὼβ εἰς τοὺς αἰῶνας, καὶ τῆς βασιλείας αὐτοῦ οὐκ ἔσται τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","εἶπεν δὲ Μαριὰμ πρὸς τὸν ἄγγελον· Πῶς ἔσται τοῦτο, ἐπεὶ ἄνδρα οὐ γινώσκω; ");
INSERT INTO grcsbl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","καὶ ἀποκριθεὶς ὁ ἄγγελος εἶπεν αὐτῇ· Πνεῦμα ἅγιον ἐπελεύσεται ἐπὶ σέ, καὶ δύναμις Ὑψίστου ἐπισκιάσει σοι· διὸ καὶ τὸ γεννώμενον ἅγιον κληθήσεται, υἱὸς θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","καὶ ἰδοὺ Ἐλισάβετ ἡ ⸀συγγενίςσου καὶ αὐτὴ ⸀συνείληφενυἱὸν ἐν γήρει αὐτῆς, καὶ οὗτος μὴν ἕκτος ἐστὶν αὐτῇ τῇ καλουμένῃ στείρᾳ· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ὅτι οὐκ ἀδυνατήσει παρὰ ⸂τοῦ θεοῦ πᾶν ῥῆμα. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","εἶπεν δὲ Μαριάμ· Ἰδοὺ ἡ δούλη κυρίου· γένοιτό μοι κατὰ τὸ ῥῆμά σου. καὶ ἀπῆλθεν ἀπʼ αὐτῆς ὁ ἄγγελος. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ἀναστᾶσα δὲ Μαριὰμ ἐν ταῖς ἡμέραις ταύταις ἐπορεύθη εἰς τὴν ὀρεινὴν μετὰ σπουδῆς εἰς πόλιν Ἰούδα, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","καὶ εἰσῆλθεν εἰς τὸν οἶκον Ζαχαρίου καὶ ἠσπάσατο τὴν Ἐλισάβετ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","καὶ ἐγένετο ὡς ἤκουσεν ⸂τὸν ἀσπασμὸν τῆς Μαρίας ἡ Ἐλισάβετ, ἐσκίρτησεν τὸ βρέφος ἐν τῇ κοιλίᾳ αὐτῆς, καὶ ἐπλήσθη πνεύματος ἁγίου ἡ Ἐλισάβετ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","καὶ ἀνεφώνησεν ⸀κραυγῇμεγάλῃ καὶ εἶπεν· Εὐλογημένη σὺ ἐν γυναιξίν, καὶ εὐλογημένος ὁ καρπὸς τῆς κοιλίας σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","καὶ πόθεν μοι τοῦτο ἵνα ἔλθῃ ἡ μήτηρ τοῦ κυρίου μου πρὸς ⸀ἐμέ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ἰδοὺ γὰρ ὡς ἐγένετο ἡ φωνὴ τοῦ ἀσπασμοῦ σου εἰς τὰ ὦτά μου, ἐσκίρτησεν ⸂ἐν ἀγαλλιάσει τὸ βρέφος ἐν τῇ κοιλίᾳ μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","καὶ μακαρία ἡ πιστεύσασα ὅτι ἔσται τελείωσις τοῖς λελαλημένοις αὐτῇ παρὰ κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Καὶ εἶπεν Μαριάμ· Μεγαλύνει ἡ ψυχή μου τὸν κύριον, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","καὶ ἠγαλλίασεν τὸ πνεῦμά μου ἐπὶ τῷ θεῷ τῷ σωτῆρί μου· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ὅτι ἐπέβλεψεν ἐπὶ τὴν ταπείνωσιν τῆς δούλης αὐτοῦ, ἰδοὺ γὰρ ἀπὸ τοῦ νῦν μακαριοῦσίν με πᾶσαι αἱ γενεαί· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ὅτι ἐποίησέν μοι ⸀μεγάλαὁ δυνατός, καὶ ἅγιον τὸ ὄνομα αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","καὶ τὸ ἔλεος αὐτοῦ εἰς γενεὰς ⸂καὶ γενεὰς τοῖς φοβουμένοις αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ἐποίησεν κράτος ἐν βραχίονι αὐτοῦ, διεσκόρπισεν ὑπερηφάνους διανοίᾳ καρδίας αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","καθεῖλεν δυνάστας ἀπὸ θρόνων καὶ ὕψωσεν ταπεινούς, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","πεινῶντας ἐνέπλησεν ἀγαθῶν καὶ πλουτοῦντας ἐξαπέστειλεν κενούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ἀντελάβετο Ἰσραὴλ παιδὸς αὐτοῦ, μνησθῆναι ἐλέους, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","καθὼς ἐλάλησεν πρὸς τοὺς πατέρας ἡμῶν, τῷ Ἀβραὰμ καὶ τῷ σπέρματι αὐτοῦ εἰς τὸν αἰῶνα. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ἔμεινεν δὲ Μαριὰμ σὺν αὐτῇ ⸀ὡςμῆνας τρεῖς, καὶ ὑπέστρεψεν εἰς τὸν οἶκον αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Τῇ δὲ Ἐλισάβετ ἐπλήσθη ὁ χρόνος τοῦ τεκεῖν αὐτήν, καὶ ἐγέννησεν υἱόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","καὶ ἤκουσαν οἱ περίοικοι καὶ οἱ συγγενεῖς αὐτῆς ὅτι ἐμεγάλυνεν κύριος τὸ ἔλεος αὐτοῦ μετʼ αὐτῆς, καὶ συνέχαιρον αὐτῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Καὶ ἐγένετο ἐν τῇ ⸂ἡμέρᾳ τῇ ὀγδόῃ ἦλθον περιτεμεῖν τὸ παιδίον, καὶ ἐκάλουν αὐτὸ ἐπὶ τῷ ὀνόματι τοῦ πατρὸς αὐτοῦ Ζαχαρίαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","καὶ ἀποκριθεῖσα ἡ μήτηρ αὐτοῦ εἶπεν· Οὐχί, ἀλλὰ κληθήσεται Ἰωάννης. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","καὶ εἶπαν πρὸς αὐτὴν ὅτι Οὐδείς ἐστιν ⸂ἐκ τῆς συγγενείας σου ὃς καλεῖται τῷ ὀνόματι τούτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ἐνένευον δὲ τῷ πατρὶ αὐτοῦ τὸ τί ἂν θέλοι καλεῖσθαι ⸀αὐτό ");
INSERT INTO grcsbl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","καὶ αἰτήσας πινακίδιον ἔγραψεν λέγων· Ἰωάννης ⸀ἐστὶνὄνομα αὐτοῦ. καὶ ἐθαύμασαν πάντες. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ἀνεῴχθη δὲ τὸ στόμα αὐτοῦ παραχρῆμα καὶ ἡ γλῶσσα αὐτοῦ, καὶ ἐλάλει εὐλογῶν τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","καὶ ἐγένετο ἐπὶ πάντας φόβος τοὺς περιοικοῦντας αὐτούς, καὶ ἐν ὅλῃ τῇ ὀρεινῇ τῆς Ἰουδαίας διελαλεῖτο πάντα τὰ ῥήματα ταῦτα, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","καὶ ἔθεντο πάντες οἱ ἀκούσαντες ἐν τῇ καρδίᾳ αὐτῶν, λέγοντες· Τί ἄρα τὸ παιδίον τοῦτο ἔσται; καὶ ⸀γὰρχεὶρ κυρίου ἦν μετʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Καὶ Ζαχαρίας ὁ πατὴρ αὐτοῦ ἐπλήσθη πνεύματος ἁγίου καὶ ⸀ἐπροφήτευσενλέγων· ");
INSERT INTO grcsbl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Εὐλογητὸς κύριος ὁ θεὸς τοῦ Ἰσραήλ, ὅτι ἐπεσκέψατο καὶ ἐποίησεν λύτρωσιν τῷ λαῷ αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","καὶ ἤγειρεν κέρας σωτηρίας ἡμῖν ⸀ἐνοἴκῳ ⸀Δαυὶδπαιδὸς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","καθὼς ἐλάλησεν διὰ στόματος τῶν ⸀ἁγίωνἀπʼ αἰῶνος προφητῶν αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","σωτηρίαν ἐξ ἐχθρῶν ἡμῶν καὶ ἐκ χειρὸς πάντων τῶν μισούντων ἡμᾶς, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ποιῆσαι ἔλεος μετὰ τῶν πατέρων ἡμῶν καὶ μνησθῆναι διαθήκης ἁγίας αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ὅρκον ὃν ὤμοσεν πρὸς Ἀβραὰμ τὸν πατέρα ἡμῶν, τοῦ δοῦναι ἡμῖν ");
INSERT INTO grcsbl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ἀφόβως ἐκ χειρὸς ⸀ἐχθρῶνῥυσθέντας λατρεύειν αὐτῷ ");
INSERT INTO grcsbl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ἐν ὁσιότητι καὶ δικαιοσύνῃ ἐνώπιον αὐτοῦ ⸂πάσαις ταῖς ἡμέραις ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","καὶ σὺ ⸀δέ παιδίον, προφήτης Ὑψίστου κληθήσῃ, προπορεύσῃ γὰρ ⸀ἐνώπιονκυρίου ἑτοιμάσαι ὁδοὺς αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","τοῦ δοῦναι γνῶσιν σωτηρίας τῷ λαῷ αὐτοῦ ἐν ἀφέσει ἁμαρτιῶν αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","διὰ σπλάγχνα ἐλέους θεοῦ ἡμῶν, ἐν οἷς ⸀ἐπισκέψεταιἡμᾶς ἀνατολὴ ἐξ ὕψους, ");
INSERT INTO grcsbl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ἐπιφᾶναι τοῖς ἐν σκότει καὶ σκιᾷ θανάτου καθημένοις, τοῦ κατευθῦναι τοὺς πόδας ἡμῶν εἰς ὁδὸν εἰρήνης. ");
INSERT INTO grcsbl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Τὸ δὲ παιδίον ηὔξανε καὶ ἐκραταιοῦτο πνεύματι, καὶ ἦν ἐν ταῖς ἐρήμοις ἕως ἡμέρας ἀναδείξεως αὐτοῦ πρὸς τὸν Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ἐκείναις ἐξῆλθεν δόγμα παρὰ Καίσαρος Αὐγούστου ἀπογράφεσθαι πᾶσαν τὴν οἰκουμένην· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(⸀αὕτηἀπογραφὴ πρώτη ἐγένετο ἡγεμονεύοντος τῆς Συρίας Κυρηνίου·) ");
INSERT INTO grcsbl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","καὶ ἐπορεύοντο πάντες ἀπογράφεσθαι, ἕκαστος εἰς τὴν ⸀ἑαυτοῦπόλιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ἀνέβη δὲ καὶ Ἰωσὴφ ἀπὸ τῆς Γαλιλαίας ἐκ πόλεως Ναζαρὲθ εἰς τὴν Ἰουδαίαν εἰς πόλιν Δαυὶδ ἥτις καλεῖται Βηθλέεμ, διὰ τὸ εἶναι αὐτὸν ἐξ οἴκου καὶ πατριᾶς Δαυίδ, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ἀπογράψασθαι σὺν Μαριὰμ τῇ ⸂ἐμνηστευμένῃ αὐτῷ, οὔσῃ ἐγκύῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ἐγένετο δὲ ἐν τῷ εἶναι αὐτοὺς ἐκεῖ ἐπλήσθησαν αἱ ἡμέραι τοῦ τεκεῖν αὐτήν, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","καὶ ἔτεκεν τὸν υἱὸν αὐτῆς τὸν πρωτότοκον, καὶ ἐσπαργάνωσεν αὐτὸν καὶ ἀνέκλινεν αὐτὸν ⸀ἐνφάτνῃ, διότι οὐκ ἦν αὐτοῖς τόπος ἐν τῷ καταλύματι. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Καὶ ποιμένες ἦσαν ἐν τῇ χώρᾳ τῇ αὐτῇ ἀγραυλοῦντες καὶ φυλάσσοντες φυλακὰς τῆς νυκτὸς ἐπὶ τὴν ποίμνην αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","⸀καὶἄγγελος κυρίου ἐπέστη αὐτοῖς καὶ δόξα κυρίου περιέλαμψεν αὐτούς, καὶ ἐφοβήθησαν φόβον μέγαν· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","καὶ εἶπεν αὐτοῖς ὁ ἄγγελος· Μὴ φοβεῖσθε, ἰδοὺ γὰρ εὐαγγελίζομαι ὑμῖν χαρὰν μεγάλην ἥτις ἔσται παντὶ τῷ λαῷ, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ὅτι ἐτέχθη ὑμῖν σήμερον σωτὴρ ὅς ἐστιν χριστὸς κύριος ἐν πόλει Δαυίδ· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","καὶ τοῦτο ὑμῖν ⸀τὸσημεῖον, εὑρήσετε βρέφος ἐσπαργανωμένον ⸀καὶκείμενον ἐν φάτνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","καὶ ἐξαίφνης ἐγένετο σὺν τῷ ἀγγέλῳ πλῆθος στρατιᾶς ⸀οὐρανίουαἰνούντων τὸν θεὸν καὶ λεγόντων· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Δόξα ἐν ὑψίστοις θεῷ καὶ ἐπὶ γῆς εἰρήνη ἐν ἀνθρώποις ⸀εὐδοκίας ");
INSERT INTO grcsbl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Καὶ ἐγένετο ὡς ἀπῆλθον ἀπʼ αὐτῶν εἰς τὸν οὐρανὸν οἱἄγγελοι, ⸀οἱ ποιμένες ⸀ἐλάλουνπρὸς ἀλλήλους· Διέλθωμεν δὴ ἕως Βηθλέεμ καὶ ἴδωμεν τὸ ῥῆμα τοῦτο τὸ γεγονὸς ὃ ὁ κύριος ἐγνώρισεν ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","καὶ ἦλθαν σπεύσαντες καὶ ἀνεῦραν τήν τε Μαριὰμ καὶ τὸν Ἰωσὴφ καὶ τὸ βρέφος κείμενον ἐν τῇ φάτνῃ· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ἰδόντες δὲ ⸀ἐγνώρισανπερὶ τοῦ ῥήματος τοῦ λαληθέντος αὐτοῖς περὶ τοῦ παιδίου τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","καὶ πάντες οἱ ἀκούσαντες ἐθαύμασαν περὶ τῶν λαληθέντων ὑπὸ τῶν ποιμένων πρὸς αὐτούς, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ἡ δὲ ⸀Μαρίαπάντα συνετήρει τὰ ῥήματα ταῦτα συμβάλλουσα ἐν τῇ καρδίᾳ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","καὶ ὑπέστρεψαν οἱ ποιμένες δοξάζοντες καὶ αἰνοῦντες τὸν θεὸν ἐπὶ πᾶσιν οἷς ἤκουσαν καὶ εἶδον καθὼς ἐλαλήθη πρὸς αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Καὶ ὅτε ἐπλήσθησαν ἡμέραι ὀκτὼ τοῦ περιτεμεῖν αὐτόν, καὶ ἐκλήθη τὸ ὄνομα αὐτοῦ Ἰησοῦς, τὸ κληθὲν ὑπὸ τοῦ ἀγγέλου πρὸ τοῦ συλλημφθῆναι αὐτὸν ἐν τῇ κοιλίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Καὶ ὅτε ἐπλήσθησαν αἱ ἡμέραι τοῦ καθαρισμοῦ αὐτῶν κατὰ τὸν νόμον Μωϋσέως, ἀνήγαγον αὐτὸν εἰς Ἱεροσόλυμα παραστῆσαι τῷ κυρίῳ, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","καθὼς γέγραπται ἐν νόμῳ κυρίου ὅτι Πᾶν ἄρσεν διανοῖγον μήτραν ἅγιον τῷ κυρίῳ κληθήσεται, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","καὶ τοῦ δοῦναι θυσίαν κατὰ τὸ εἰρημένον ἐν ⸀τῷνόμῳ κυρίου, ζεῦγος τρυγόνων ἢ δύο νοσσοὺς περιστερῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Καὶ ἰδοὺ ⸂ἄνθρωπος ἦν ἐν Ἰερουσαλὴμ ᾧ ὄνομα Συμεών, καὶ ὁ ἄνθρωπος οὗτος δίκαιος καὶ εὐλαβής, προσδεχόμενος παράκλησιν τοῦ Ἰσραήλ, καὶ πνεῦμα ἦν ἅγιον ἐπʼ αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","καὶ ἦν αὐτῷ κεχρηματισμένον ὑπὸ τοῦ πνεύματος τοῦ ἁγίου μὴ ἰδεῖν θάνατον πρὶν ⸂ἢ ἂν ἴδῃ τὸν χριστὸν κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","καὶ ἦλθεν ἐν τῷ πνεύματι εἰς τὸ ἱερόν· καὶ ἐν τῷ εἰσαγαγεῖν τοὺς γονεῖς τὸ παιδίον Ἰησοῦν τοῦ ποιῆσαι αὐτοὺς κατὰ τὸ εἰθισμένον τοῦ νόμου περὶ αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","καὶ αὐτὸς ἐδέξατο αὐτὸ εἰς τὰς ⸀ἀγκάλαςκαὶ εὐλόγησεν τὸν θεὸν καὶ εἶπεν· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Νῦν ἀπολύεις τὸν δοῦλόν σου, δέσποτα, κατὰ τὸ ῥῆμά σου ἐν εἰρήνῃ· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ὅτι εἶδον οἱ ὀφθαλμοί μου τὸ σωτήριόν σου ");
INSERT INTO grcsbl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ὃ ἡτοίμασας κατὰ πρόσωπον πάντων τῶν λαῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","φῶς εἰς ἀποκάλυψιν ἐθνῶν καὶ δόξαν λαοῦ σου Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","καὶ ἦν ⸂ὁ πατὴρ αὐτοῦ καὶ ἡ ⸀μήτηρθαυμάζοντες ἐπὶ τοῖς λαλουμένοις περὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","καὶ εὐλόγησεν αὐτοὺς Συμεὼν καὶ εἶπεν πρὸς Μαριὰμ τὴν μητέρα αὐτοῦ· Ἰδοὺ οὗτος κεῖται εἰς πτῶσιν καὶ ἀνάστασιν πολλῶν ἐν τῷ Ἰσραὴλ καὶ εἰς σημεῖον ἀντιλεγόμενον, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","καὶ σοῦ ⸀δὲαὐτῆς τὴν ψυχὴν διελεύσεται ῥομφαία, ὅπως ἂν ἀποκαλυφθῶσιν ἐκ πολλῶν καρδιῶν διαλογισμοί. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Καὶ ἦν Ἅννα προφῆτις, θυγάτηρ Φανουήλ, ἐκ φυλῆς Ἀσήρ (αὕτη προβεβηκυῖα ἐν ἡμέραις πολλαῖς, ζήσασα ⸂μετὰ ἀνδρὸς ἔτη ἑπτὰ ἀπὸ τῆς παρθενίας αὐτῆς, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","καὶ αὐτὴ χήρα ⸀ἕωςἐτῶν ὀγδοήκοντα τεσσάρων,) ἣ οὐκ ⸀ἀφίστατοτοῦ ἱεροῦ νηστείαις καὶ δεήσεσιν λατρεύουσα νύκτα καὶ ἡμέραν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","⸀καὶαὐτῇ τῇ ὥρᾳ ἐπιστᾶσα ἀνθωμολογεῖτο τῷ ⸀θεῷκαὶ ἐλάλει περὶ αὐτοῦ πᾶσιν τοῖς προσδεχομένοις ⸀λύτρωσιν Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Καὶ ὡς ἐτέλεσαν ⸀πάντατὰ κατὰ τὸν νόμον κυρίου, ⸀ἐπέστρεψανεἰςτὴν Γαλιλαίαν ⸀εἰς πόλιν ἑαυτῶν Ναζαρέθ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Τὸ δὲ παιδίον ηὔξανεν καὶ ἐκραταιοῦτο ⸂πληρούμενον σοφίᾳ, καὶ χάρις θεοῦ ἦν ἐπʼ αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Καὶ ἐπορεύοντο οἱ γονεῖς αὐτοῦ κατʼ ἔτος εἰς Ἰερουσαλὴμ τῇ ἑορτῇ τοῦ πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","καὶ ὅτε ἐγένετο ἐτῶν δώδεκα, ⸀ἀναβαινόντων⸀αὐτῶνκατὰ τὸ ἔθος τῆς ἑορτῆς ");
INSERT INTO grcsbl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","καὶ τελειωσάντων τὰς ἡμέρας, ἐν τῷ ὑποστρέφειν αὐτοὺς ὑπέμεινεν Ἰησοῦς ὁ παῖς ἐν Ἰερουσαλήμ, καὶ οὐκ ⸂ἔγνωσαν οἱ γονεῖς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","νομίσαντες δὲ αὐτὸν ⸂εἶναι ἐν τῇ συνοδίᾳ ἦλθον ἡμέρας ὁδὸν καὶἀνεζήτουν αὐτὸν ἐν τοῖς συγγενεῦσιν ⸀καὶ τοῖς γνωστοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","καὶ μὴ ⸀εὑρόντεςὑπέστρεψαν εἰς Ἰερουσαλὴμ ⸀ἀναζητοῦντεςαὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","καὶ ἐγένετο μετὰ ἡμέρας τρεῖς εὗρον αὐτὸν ἐν τῷ ἱερῷ καθεζόμενον ἐν μέσῳ τῶν διδασκάλων καὶ ἀκούοντα αὐτῶν καὶ ἐπερωτῶντα αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ἐξίσταντο δὲ πάντες οἱ ἀκούοντες αὐτοῦ ἐπὶ τῇ συνέσει καὶ ταῖς ἀποκρίσεσιν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","καὶ ἰδόντες αὐτὸν ἐξεπλάγησαν, καὶ ⸂εἶπεν πρὸς αὐτὸν ἡ μήτηρ αὐτοῦ· Τέκνον, τί ἐποίησας ἡμῖν οὕτως; ἰδοὺ ὁ πατήρ σου καὶ ἐγὼ ὀδυνώμενοι ⸀ἐζητοῦμένσε. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","καὶ εἶπεν πρὸς αὐτούς· Τί ὅτι ἐζητεῖτέ με; οὐκ ᾔδειτε ὅτι ἐν τοῖς τοῦ πατρός μου δεῖ εἶναί με; ");
INSERT INTO grcsbl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","καὶ αὐτοὶ οὐ συνῆκαν τὸ ῥῆμα ὃ ἐλάλησεν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","καὶ κατέβη μετʼ αὐτῶν καὶ ἦλθεν εἰς Ναζαρέθ, καὶ ἦν ὑποτασσόμενος αὐτοῖς. καὶ ἡ μήτηρ αὐτοῦ διετήρει πάντα τὰ ῥήματα ⸀ταῦταἐν τῇ καρδίᾳ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Καὶ Ἰησοῦς προέκοπτεν ⸂σοφίᾳ καὶ ἡλικίᾳ καὶ χάριτι παρὰ θεῷ καὶ ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ἐν ἔτει δὲ πεντεκαιδεκάτῳ τῆς ἡγεμονίας Τιβερίου Καίσαρος, ἡγεμονεύοντος Ποντίου Πιλάτου τῆς Ἰουδαίας, καὶ τετρααρχοῦντος τῆς Γαλιλαίας Ἡρῴδου, Φιλίππου δὲ τοῦ ἀδελφοῦ αὐτοῦ τετρααρχοῦντος τῆς Ἰτουραίας καὶ Τραχωνίτιδος χώρας, καὶ Λυσανίου τῆς Ἀβιληνῆς τετρααρχοῦντος, ");
INSERT INTO grcsbl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ἐπὶ ἀρχιερέως Ἅννα καὶ Καϊάφα, ἐγένετο ῥῆμα θεοῦ ἐπὶ Ἰωάννην τὸν Ζαχαρίου υἱὸν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","καὶ ἦλθεν εἰς ⸀πᾶσανπερίχωρον τοῦ Ἰορδάνου κηρύσσων βάπτισμα μετανοίας εἰς ἄφεσιν ἁμαρτιῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ὡς γέγραπται ἐν βίβλῳ λόγων Ἠσαΐου τοῦ ⸀προφήτου Φωνὴ βοῶντος ἐν τῇ ἐρήμῳ· Ἑτοιμάσατε τὴν ὁδὸν κυρίου, εὐθείας ποιεῖτε τὰς τρίβους αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","πᾶσα φάραγξ πληρωθήσεται καὶ πᾶν ὄρος καὶ βουνὸς ταπεινωθήσεται, καὶ ἔσται τὰ σκολιὰ εἰς ⸀εὐθείανκαὶ αἱ τραχεῖαι εἰς ὁδοὺς λείας· ");
INSERT INTO grcsbl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","καὶ ὄψεται πᾶσα σὰρξ τὸ σωτήριον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ἔλεγεν οὖν τοῖς ἐκπορευομένοις ὄχλοις βαπτισθῆναι ὑπʼ αὐτοῦ· Γεννήματα ἐχιδνῶν, τίς ὑπέδειξεν ὑμῖν φυγεῖν ἀπὸ τῆς μελλούσης ὀργῆς; ");
INSERT INTO grcsbl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ποιήσατε οὖν καρποὺς ἀξίους τῆς μετανοίας· καὶ μὴ ἄρξησθε λέγειν ἐν ἑαυτοῖς· Πατέρα ἔχομεν τὸν Ἀβραάμ, λέγω γὰρ ὑμῖν ὅτι δύναται ὁ θεὸς ἐκ τῶν λίθων τούτων ἐγεῖραι τέκνα τῷ Ἀβραάμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ἤδη δὲ καὶ ἡ ἀξίνη πρὸς τὴν ῥίζαν τῶν δένδρων κεῖται· πᾶν οὖν δένδρον μὴ ποιοῦν καρπὸν καλὸν ἐκκόπτεται καὶ εἰς πῦρ βάλλεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Καὶ ἐπηρώτων αὐτὸν οἱ ὄχλοι λέγοντες· Τί οὖν ⸀ποιήσωμεν ");
INSERT INTO grcsbl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ἀποκριθεὶς δὲ ⸀ἔλεγεναὐτοῖς· Ὁ ἔχων δύο χιτῶνας μεταδότω τῷ μὴ ἔχοντι, καὶ ὁ ἔχων βρώματα ὁμοίως ποιείτω. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ἦλθον δὲ καὶ τελῶναι βαπτισθῆναι καὶ εἶπαν πρὸς αὐτόν· Διδάσκαλε, τί ⸀ποιήσωμεν ");
INSERT INTO grcsbl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ὁ δὲ εἶπεν πρὸς αὐτούς· Μηδὲν πλέον παρὰ τὸ διατεταγμένον ὑμῖν πράσσετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ἐπηρώτων δὲ αὐτὸν καὶ στρατευόμενοι λέγοντες· ⸂Τί ποιήσωμεν καὶ ἡμεῖς; καὶ εἶπεν ⸀αὐτοῖς Μηδένα διασείσητε μηδὲ συκοφαντήσητε, καὶ ἀρκεῖσθε τοῖς ὀψωνίοις ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Προσδοκῶντος δὲ τοῦ λαοῦ καὶ διαλογιζομένων πάντων ἐν ταῖς καρδίαις αὐτῶν περὶ τοῦ Ἰωάννου, μήποτε αὐτὸς εἴη ὁ χριστός, ");
INSERT INTO grcsbl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ἀπεκρίνατο ⸂λέγων πᾶσιν ὁ Ἰωάννης· Ἐγὼ μὲν ὕδατι βαπτίζω ὑμᾶς· ἔρχεται δὲ ὁ ἰσχυρότερός μου, οὗ οὐκ εἰμὶ ἱκανὸς λῦσαι τὸν ἱμάντα τῶν ὑποδημάτων αὐτοῦ· αὐτὸς ὑμᾶς βαπτίσει ἐν πνεύματι ἁγίῳ καὶ πυρί· ");
INSERT INTO grcsbl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","οὗ τὸ πτύον ἐν τῇ χειρὶ αὐτοῦ ⸀διακαθᾶραιτὴν ἅλωνα αὐτοῦ καὶ ⸀συναγαγεῖντὸν σῖτον εἰς τὴν ἀποθήκην αὐτοῦ, τὸ δὲ ἄχυρον κατακαύσει πυρὶ ἀσβέστῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Πολλὰ μὲν οὖν καὶ ἕτερα παρακαλῶν εὐηγγελίζετο τὸν λαόν· ");
INSERT INTO grcsbl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ὁ δὲ Ἡρῴδης ὁ τετραάρχης, ἐλεγχόμενος ὑπʼ αὐτοῦ περὶ Ἡρῳδιάδος τῆς γυναικὸς τοῦ ἀδελφοῦ αὐτοῦ καὶ περὶ πάντων ὧν ἐποίησεν πονηρῶν ὁ Ἡρῴδης, ");
INSERT INTO grcsbl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","προσέθηκεν καὶτοῦτο ἐπὶ πᾶσιν, ⸀καὶ κατέκλεισεν τὸν Ἰωάννην ⸀ἐνφυλακῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ἐγένετο δὲ ἐν τῷ βαπτισθῆναι ἅπαντα τὸν λαὸν καὶ Ἰησοῦ βαπτισθέντος καὶ προσευχομένου ἀνεῳχθῆναι τὸν οὐρανὸν ");
INSERT INTO grcsbl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","καὶ καταβῆναι τὸ πνεῦμα τὸ ἅγιον σωματικῷ εἴδει ⸀ὡςπεριστερὰν ἐπʼ αὐτόν, καὶ φωνὴν ἐξ οὐρανοῦ ⸀γενέσθαι Σὺ εἶ ὁ υἱός μου ὁ ἀγαπητός, ἐν σοὶ εὐδόκησα. ");
INSERT INTO grcsbl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Καὶ αὐτὸς ⸀ἦνἸησοῦς ⸂ἀρχόμενος ὡσεὶ ἐτῶν τριάκοντα, ὢν ⸂υἱός, ὡς ἐνομίζετο⸃, Ἰωσὴφ τοῦ Ἠλὶ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","τοῦ Μαθθὰτ τοῦ Λευὶ τοῦ Μελχὶ τοῦ Ἰανναὶ τοῦ Ἰωσὴφ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","τοῦ Ματταθίου τοῦ Ἀμὼς τοῦ Ναοὺμ τοῦ Ἑσλὶ τοῦ Ναγγαὶ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","τοῦ Μάαθ τοῦ Ματταθίου τοῦ Σεμεῒν τοῦ ⸀Ἰωσὴχτοῦ Ἰωδὰ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","τοῦ Ἰωανὰν τοῦ Ῥησὰ τοῦ Ζοροβαβὲλ τοῦ Σαλαθιὴλ τοῦ Νηρὶ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","τοῦ Μελχὶ τοῦ Ἀδδὶ τοῦ Κωσὰμ τοῦ Ἐλμαδὰμ τοῦ Ἢρ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","τοῦ ⸀Ἰησοῦτοῦ Ἐλιέζερ τοῦ Ἰωρὶμ τοῦ Μαθθὰτ τοῦ Λευὶ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","τοῦ Συμεὼν τοῦ Ἰούδα τοῦ Ἰωσὴφ τοῦ Ἰωνὰμ τοῦ Ἐλιακὶμ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","τοῦ Μελεὰ τοῦ Μεννὰ τοῦ Ματταθὰ τοῦ Ναθὰμ τοῦ Δαυὶδ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","τοῦ Ἰεσσαὶ τοῦ Ἰωβὴλ τοῦ Βόος τοῦ ⸀Σαλὰτοῦ Ναασσὼν ");
INSERT INTO grcsbl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","τοῦ ⸂Ἀμιναδὰβ τοῦ Ἀδμὶν τοῦ Ἀρνὶ τοῦ Ἑσρὼμ τοῦ Φαρὲς τοῦ Ἰούδα ");
INSERT INTO grcsbl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","τοῦ Ἰακὼβ τοῦ Ἰσαὰκ τοῦ Ἀβραὰμ τοῦ Θάρα τοῦ Ναχὼρ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","τοῦ Σεροὺχ τοῦ Ῥαγαὺ τοῦ Φάλεκ τοῦ Ἔβερ τοῦ Σαλὰ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","τοῦ Καϊνὰμ τοῦ Ἀρφαξὰδ τοῦ Σὴμ τοῦ Νῶε τοῦ Λάμεχ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","τοῦ Μαθουσαλὰ τοῦ Ἑνὼχ τοῦ Ἰάρετ τοῦ Μαλελεὴλ τοῦ Καϊνὰμ ");
INSERT INTO grcsbl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","τοῦ Ἐνὼς τοῦ Σὴθ τοῦ Ἀδὰμ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ἰησοῦς δὲ ⸂πλήρης πνεύματος ἁγίου ὑπέστρεψεν ἀπὸ τοῦ Ἰορδάνου, καὶ ἤγετο ἐν τῷ πνεύματι ⸂ἐν τῇ ἐρήμῳ ");
INSERT INTO grcsbl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ἡμέρας τεσσεράκοντα πειραζόμενος ὑπὸ τοῦ διαβόλου. καὶ οὐκ ἔφαγεν οὐδὲν ἐν ταῖς ἡμέραις ἐκείναις, καὶ συντελεσθεισῶν ⸀αὐτῶνἐπείνασεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","⸂εἶπεν δὲ αὐτῷ ὁ διάβολος· Εἰ υἱὸς εἶ τοῦ θεοῦ, εἰπὲ τῷ λίθῳ τούτῳ ἵνα γένηται ἄρτος. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","καὶ ἀπεκρίθη ⸂πρὸς αὐτὸν ὁ Ἰησοῦς· Γέγραπται ὅτι Οὐκ ἐπʼ ἄρτῳ μόνῳ ζήσεται ⸀ὁ⸀ἄνθρωπος ");
INSERT INTO grcsbl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Καὶ ἀναγαγὼν ⸀αὐτὸνἔδειξεν αὐτῷ πάσας τὰς βασιλείας τῆς οἰκουμένης ἐν στιγμῇ χρόνου· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","καὶ εἶπεν αὐτῷ ὁ διάβολος· Σοὶ δώσω τὴν ἐξουσίαν ταύτην ἅπασαν καὶ τὴν δόξαν αὐτῶν, ὅτι ἐμοὶ παραδέδοται καὶ ᾧ ⸀ἂνθέλω δίδωμι αὐτήν· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","σὺ οὖν ἐὰν προσκυνήσῃς ἐνώπιον ἐμοῦ, ἔσται σοῦ πᾶσα. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","καὶ ἀποκριθεὶς ⸂ὁ Ἰησοῦς εἶπεν αὐτῷ· Γέγραπται· ⸂Κύριον τὸν θεόν σου προσκυνήσεις καὶ αὐτῷ μόνῳ λατρεύσεις. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","⸂Ἤγαγεν δὲ αὐτὸν εἰς Ἰερουσαλὴμ καὶ ⸀ἔστησενἐπὶ τὸ πτερύγιον τοῦ ἱεροῦ, καὶ εἶπεν αὐτῷ· Εἰ υἱὸς εἶ τοῦ θεοῦ, βάλε σεαυτὸν ἐντεῦθεν κάτω· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","γέγραπται γὰρ ὅτι Τοῖς ἀγγέλοις αὐτοῦ ἐντελεῖται περὶ σοῦ τοῦ διαφυλάξαι σε, ");
INSERT INTO grcsbl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","καὶ ⸀ὅτιἘπὶ χειρῶν ἀροῦσίν σε μήποτε προσκόψῃς πρὸς λίθον τὸν πόδα σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","καὶ ἀποκριθεὶς εἶπεν αὐτῷ ὁ Ἰησοῦς ὅτι Εἴρηται· Οὐκ ἐκπειράσεις κύριον τὸν θεόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","καὶ συντελέσας πάντα πειρασμὸν ὁ διάβολος ἀπέστη ἀπʼ αὐτοῦ ἄχρι καιροῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Καὶ ὑπέστρεψεν ὁ Ἰησοῦς ἐν τῇ δυνάμει τοῦ πνεύματος εἰς τὴν Γαλιλαίαν. καὶ φήμη ἐξῆλθεν καθʼ ὅλης τῆς περιχώρου περὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","καὶ αὐτὸς ἐδίδασκεν ἐν ταῖς συναγωγαῖς αὐτῶν, δοξαζόμενος ὑπὸ πάντων. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Καὶ ἦλθεν ⸀εἰςΝαζαρά, οὗ ἦν τεθραμμένος, καὶ εἰσῆλθεν κατὰ τὸ εἰωθὸς αὐτῷ ἐν τῇ ἡμέρᾳ τῶν σαββάτων εἰς τὴν συναγωγήν, καὶ ἀνέστη ἀναγνῶναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","καὶ ἐπεδόθη αὐτῷ βιβλίον ⸂τοῦ προφήτου Ἠσαΐου καὶ ⸀ἀναπτύξαςτὸ βιβλίον εὗρεν τὸν τόπον οὗ ἦν γεγραμμένον· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Πνεῦμα κυρίου ἐπʼ ἐμέ, οὗ εἵνεκεν ἔχρισέν μεεὐαγγελίσασθαι πτωχοῖς, ἀπέσταλκέν ⸀με κηρύξαι αἰχμαλώτοις ἄφεσιν καὶ τυφλοῖς ἀνάβλεψιν, ἀποστεῖλαι τεθραυσμένους ἐν ἀφέσει, ");
INSERT INTO grcsbl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","κηρύξαι ἐνιαυτὸν κυρίου δεκτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","καὶ πτύξας τὸ βιβλίον ἀποδοὺς τῷ ὑπηρέτῃ ἐκάθισεν· καὶ πάντων ⸂οἱ ὀφθαλμοὶ ἐν τῇ συναγωγῇ ἦσαν ἀτενίζοντες αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ἤρξατο δὲ λέγειν πρὸς αὐτοὺς ὅτι Σήμερον πεπλήρωται ἡ γραφὴ αὕτη ἐν τοῖς ὠσὶν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","καὶ πάντες ἐμαρτύρουν αὐτῷ καὶ ἐθαύμαζον ἐπὶ τοῖς λόγοις τῆς χάριτος τοῖς ἐκπορευομένοις ἐκ τοῦ στόματος αὐτοῦ, καὶ ἔλεγον· ⸂Οὐχὶ υἱός ἐστιν Ἰωσὴφ οὗτος; ");
INSERT INTO grcsbl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","καὶ εἶπεν πρὸς αὐτούς· Πάντως ἐρεῖτέ μοι τὴν παραβολὴν ταύτην· Ἰατρέ, θεράπευσον σεαυτόν· ὅσα ἠκούσαμεν γενόμενα ⸂εἰς τὴν Καφαρναοὺμ ποίησον καὶ ὧδε ἐν τῇ πατρίδι σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","εἶπεν δέ· Ἀμὴν λέγω ὑμῖν ὅτι οὐδεὶς προφήτης δεκτός ἐστιν ἐν τῇ πατρίδι αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ἐπʼ ἀληθείας δὲ λέγω ὑμῖν, πολλαὶ χῆραι ἦσαν ἐν ταῖς ἡμέραις Ἠλίου ἐν τῷ Ἰσραήλ, ὅτε ἐκλείσθη ὁ οὐρανὸς ⸀ἐπὶἔτη τρία καὶ μῆνας ἕξ, ὡς ἐγένετο λιμὸς μέγας ἐπὶ πᾶσαν τὴν γῆν, ");
INSERT INTO grcsbl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","καὶ πρὸς οὐδεμίαν αὐτῶν ἐπέμφθη Ἠλίας εἰ μὴ εἰς Σάρεπτα τῆς ⸀Σιδωνίαςπρὸς γυναῖκα χήραν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","καὶ πολλοὶ λεπροὶ ἦσαν ⸂ἐν τῷ Ἰσραὴλ ἐπὶ Ἐλισαίου τοῦ προφήτου, καὶ οὐδεὶς αὐτῶν ἐκαθαρίσθη, εἰ μὴ Ναιμὰν ὁ Σύρος. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","καὶ ἐπλήσθησαν πάντες θυμοῦ ἐν τῇ συναγωγῇ ἀκούοντες ταῦτα, ");
INSERT INTO grcsbl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","καὶ ἀναστάντες ἐξέβαλον αὐτὸν ἔξω τῆς πόλεως, καὶ ἤγαγον αὐτὸν ἕως ὀφρύος τοῦ ὄρους ἐφʼ οὗ ἡ πόλις ⸂ᾠκοδόμητο αὐτῶν, ὥστε⸃ κατακρημνίσαι αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","αὐτὸς δὲ διελθὼν διὰ μέσου αὐτῶν ἐπορεύετο. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Καὶ κατῆλθεν εἰς Καφαρναοὺμ πόλιν τῆς Γαλιλαίας. καὶ ἦν διδάσκων αὐτοὺς ἐν τοῖς σάββασιν· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","καὶ ἐξεπλήσσοντο ἐπὶ τῇ διδαχῇ αὐτοῦ, ὅτι ἐν ἐξουσίᾳ ἦν ὁ λόγος αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","καὶ ἐν τῇ συναγωγῇ ἦν ἄνθρωπος ἔχων πνεῦμα δαιμονίου ἀκαθάρτου, καὶ ἀνέκραξεν φωνῇ μεγάλῃ· ");
INSERT INTO grcsbl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","⸀Ἔα τί ἡμῖν καὶ σοί, Ἰησοῦ Ναζαρηνέ; ἦλθες ἀπολέσαι ἡμᾶς; οἶδά σε τίς εἶ, ὁ ἅγιος τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","καὶ ἐπετίμησεν αὐτῷ ὁ Ἰησοῦς λέγων· Φιμώθητι καὶ ἔξελθε ⸀ἀπʼαὐτοῦ. καὶ ῥίψαν αὐτὸ τὸ δαιμόνιον εἰς ⸀τὸ μέσον ἐξῆλθεν ἀπʼ αὐτοῦ μηδὲν βλάψαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","καὶ ἐγένετο θάμβος ἐπὶ πάντας, καὶ συνελάλουν πρὸς ἀλλήλους λέγοντες· Τίς ὁ λόγος οὗτος ὅτι ἐν ἐξουσίᾳ καὶ δυνάμει ἐπιτάσσει τοῖς ἀκαθάρτοις πνεύμασιν, καὶ ἐξέρχονται; ");
INSERT INTO grcsbl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","καὶ ἐξεπορεύετο ἦχος περὶ αὐτοῦ εἰς πάντα τόπον τῆς περιχώρου. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ἀναστὰς δὲ ⸀ἀπὸτῆς συναγωγῆς εἰσῆλθεν εἰς τὴν οἰκίαν Σίμωνος. πενθερὰ δὲ τοῦ Σίμωνος ἦν συνεχομένη πυρετῷ μεγάλῳ, καὶ ἠρώτησαν αὐτὸν περὶ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","καὶ ἐπιστὰς ἐπάνω αὐτῆς ἐπετίμησεν τῷ πυρετῷ, καὶ ἀφῆκεν αὐτήν· παραχρῆμα δὲ ἀναστᾶσα διηκόνει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Δύνοντος δὲ τοῦ ἡλίου ⸀ἅπαντεςὅσοι εἶχον ἀσθενοῦντας νόσοις ποικίλαις ἤγαγον αὐτοὺς πρὸς αὐτόν· ὁ δὲ ἑνὶ ἑκάστῳ αὐτῶν τὰς χεῖρας ⸂ἐπιτιθεὶς ἐθεράπευεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ἐξήρχετο δὲ καὶ δαιμόνια ἀπὸ πολλῶν ⸀κραυγάζοντακαὶ λέγοντα ὅτι Σὺ ⸀εἶὁ υἱὸς τοῦ θεοῦ. καὶ ἐπιτιμῶν οὐκ εἴα αὐτὰ λαλεῖν, ὅτι ᾔδεισαν τὸν χριστὸν αὐτὸν εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Γενομένης δὲ ἡμέρας ἐξελθὼν ἐπορεύθη εἰς ἔρημον τόπον· καὶ οἱ ὄχλοι ἐπεζήτουν αὐτόν, καὶ ἦλθον ἕως αὐτοῦ, καὶ κατεῖχον αὐτὸν τοῦ μὴ πορεύεσθαι ἀπʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ὁ δὲ εἶπεν πρὸς αὐτοὺς ὅτι Καὶ ταῖς ἑτέραις πόλεσιν εὐαγγελίσασθαί με δεῖ τὴν βασιλείαν τοῦ θεοῦ, ὅτι ⸀ἐπὶτοῦτο ⸀ἀπεστάλην ");
INSERT INTO grcsbl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","καὶ ἦν κηρύσσων ⸂εἰς τὰς συναγωγὰς τῆς ⸀Ἰουδαίας ");
INSERT INTO grcsbl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ἐγένετο δὲ ἐν τῷ τὸν ὄχλον ἐπικεῖσθαι αὐτῷ ⸀καὶἀκούειν τὸν λόγον τοῦ θεοῦ καὶ αὐτὸς ἦν ἑστὼς παρὰ τὴν λίμνην Γεννησαρέτ, ");
INSERT INTO grcsbl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","καὶ εἶδεν ⸂δύο πλοῖα ἑστῶτα παρὰ τὴν λίμνην, οἱ δὲ ἁλιεῖς ⸂ἀπʼ αὐτῶν ἀποβάντες ⸀ἔπλυνοντὰ δίκτυα. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ἐμβὰς δὲ εἰς ἓν τῶν πλοίων, ὃ ⸀ἦνΣίμωνος, ἠρώτησεν αὐτὸν ἀπὸ τῆς γῆς ἐπαναγαγεῖν ὀλίγον, ⸂καθίσας δὲ ἐκ τοῦ πλοίου ἐδίδασκεν τοὺς ὄχλους. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ὡς δὲ ἐπαύσατο λαλῶν, εἶπεν πρὸς τὸν Σίμωνα· Ἐπανάγαγε εἰς τὸ βάθος καὶ χαλάσατε τὰ δίκτυα ὑμῶν εἰς ἄγραν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","καὶ ἀποκριθεὶς ⸀Σίμων⸀εἶπεν Ἐπιστάτα, διʼ ⸀ὅληςνυκτὸς κοπιάσαντες οὐδὲν ἐλάβομεν, ἐπὶ δὲ τῷ ῥήματί σου χαλάσω ⸂τὰ δίκτυα. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","καὶ τοῦτο ποιήσαντες συνέκλεισαν πλῆθος ἰχθύων πολύ, ⸀διερρήσσετοδὲ ⸂τὰ δίκτυα αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","καὶ κατένευσαν τοῖς ⸀μετόχοιςἐν τῷ ἑτέρῳ πλοίῳ τοῦ ἐλθόντας συλλαβέσθαι αὐτοῖς· καὶ ἦλθον, καὶ ἔπλησαν ἀμφότερα τὰ πλοῖα ὥστε βυθίζεσθαι αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ἰδὼν δὲ Σίμων Πέτρος προσέπεσεν τοῖς γόνασιν Ἰησοῦ λέγων· Ἔξελθε ἀπʼ ἐμοῦ, ὅτι ἀνὴρ ἁμαρτωλός εἰμι, κύριε· ");
INSERT INTO grcsbl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","θάμβος γὰρ περιέσχεν αὐτὸν καὶ πάντας τοὺς σὺν αὐτῷ ἐπὶ τῇ ἄγρᾳ τῶν ἰχθύων ⸀ὧνσυνέλαβον, ");
INSERT INTO grcsbl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ὁοίως δὲ καὶ Ἰάκωβον καὶ Ἰωάννην υἱοὺς Ζεβεδαίου, οἳ ἦσαν κοινωνοὶ τῷ Σίμωνι. καὶ εἶπεν πρὸς τὸν Σίμωνα ⸀ὁ Ἰησοῦς· Μὴ φοβοῦ· ἀπὸ τοῦ νῦν ἀνθρώπους ἔσῃ ζωγρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","καὶ καταγαγόντες τὰ πλοῖα ἐπὶ τὴν γῆν ἀφέντες ⸀πάνταἠκολούθησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Καὶ ἐγένετο ἐν τῷ εἶναι αὐτὸν ἐν μιᾷ τῶν πόλεων καὶ ἰδοὺ ἀνὴρ πλήρης λέπρας· ⸂καὶ ἰδὼν τὸν Ἰησοῦν πεσὼν ἐπὶ πρόσωπον ἐδεήθη αὐτοῦ λέγων· Κύριε, ἐὰν θέλῃς δύνασαί με καθαρίσαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","καὶ ἐκτείνας τὴν χεῖρα ἥψατο αὐτοῦ ⸀εἰπών Θέλω, καθαρίσθητι· καὶ εὐθέως ἡ λέπρα ἀπῆλθεν ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","καὶ αὐτὸς παρήγγειλεν αὐτῷ μηδενὶ εἰπεῖν, ἀλλὰ ἀπελθὼν δεῖξον σεαυτὸν τῷ ἱερεῖ, καὶ προσένεγκε περὶ τοῦ καθαρισμοῦ σου καθὼς προσέταξεν Μωϋσῆς εἰς μαρτύριον αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","διήρχετο δὲ μᾶλλον ὁ λόγος περὶ αὐτοῦ, καὶ συνήρχοντο ὄχλοι πολλοὶ ἀκούειν καὶ ⸀θεραπεύεσθαιἀπὸ τῶν ἀσθενειῶν αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","αὐτὸς δὲ ἦν ὑποχωρῶν ἐν ταῖς ἐρήμοις καὶ προσευχόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Καὶ ἐγένετο ἐν μιᾷ τῶν ἡμερῶν καὶ αὐτὸς ἦν διδάσκων, καὶ ἦσαν καθήμενοι Φαρισαῖοι καὶ νομοδιδάσκαλοι οἳ ἦσαν ἐληλυθότες ἐκ πάσης κώμης τῆς Γαλιλαίας καὶ Ἰουδαίας καὶ Ἰερουσαλήμ· καὶ δύναμις κυρίου ἦν εἰς τὸ ἰᾶσθαι ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","καὶ ἰδοὺ ἄνδρες φέροντες ἐπὶ κλίνης ἄνθρωπον ὃς ἦν παραλελυμένος, καὶ ἐζήτουν αὐτὸν εἰσενεγκεῖν καὶ ⸀θεῖναιἐνώπιον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","καὶ μὴ εὑρόντες ποίας εἰσενέγκωσιν αὐτὸν διὰ τὸν ὄχλον ἀναβάντες ἐπὶ τὸ δῶμα διὰ τῶν κεράμων καθῆκαν αὐτὸν σὺν τῷ κλινιδίῳ εἰς τὸ μέσον ἔμπροσθεν τοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","καὶ ἰδὼν τὴν πίστιν αὐτῶν ⸀εἶπεν Ἄνθρωπε, ἀφέωνταί σοι αἱ ἁμαρτίαι σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","καὶ ἤρξαντο διαλογίζεσθαι οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι λέγοντες· Τίς ἐστιν οὗτος ὃς λαλεῖ βλασφημίας; τίς δύναται ⸂ἁμαρτίας ἀφεῖναι εἰ μὴ μόνος ὁ θεός; ");
INSERT INTO grcsbl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ἐπιγνοὺς δὲ ὁ Ἰησοῦς τοὺς διαλογισμοὺς αὐτῶν ἀποκριθεὶς εἶπεν πρὸς αὐτούς· Τί διαλογίζεσθε ἐν ταῖς καρδίαις ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","τί ἐστιν εὐκοπώτερον, εἰπεῖν· Ἀφέωνταί σοι αἱ ἁμαρτίαι σου, ἢ εἰπεῖν· ⸀Ἔγειρεκαὶ περιπάτει; ");
INSERT INTO grcsbl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ἵνα δὲ εἰδῆτε ὅτι ⸂ὁ υἱὸς τοῦ ἀνθρώπου ἐξουσίαν ἔχει ἐπὶ τῆς γῆς ἀφιέναι ἁμαρτίας— εἶπεν τῷ παραλελυμένῳ· Σοὶ λέγω, ⸀ἔγειρεκαὶ ἄρας τὸ κλινίδιόν σου πορεύου εἰς τὸν οἶκόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","καὶ παραχρῆμα ἀναστὰς ἐνώπιον αὐτῶν, ἄρας ἐφʼ ὃ κατέκειτο, ἀπῆλθεν εἰς τὸν οἶκον αὐτοῦ δοξάζων τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","καὶ ἔκστασις ἔλαβεν ἅπαντας καὶ ἐδόξαζον τὸν θεόν, καὶ ἐπλήσθησαν φόβου λέγοντες ὅτι Εἴδομεν παράδοξα σήμερον. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Καὶ μετὰ ταῦτα ἐξῆλθεν καὶ ἐθεάσατο τελώνην ὀνόματι Λευὶν καθήμενον ἐπὶ τὸ τελώνιον, καὶ εἶπεν αὐτῷ· Ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","καὶ καταλιπὼν ⸀πάνταἀναστὰς ⸀ἠκολούθειαὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Καὶ ἐποίησεν δοχὴν μεγάλην Λευὶς αὐτῷ ἐν τῇ οἰκίᾳ αὐτοῦ· καὶ ἦν ὄχλος ⸂πολὺς τελωνῶν καὶ ἄλλων οἳ ἦσαν μετʼ αὐτῶν κατακείμενοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","καὶ ἐγόγγυζον οἱ ⸂Φαρισαῖοι καὶ οἱ γραμματεῖς αὐτῶν πρὸς τοὺς μαθητὰς αὐτοῦ λέγοντες· Διὰ τί μετὰ τῶν τελωνῶν καὶ ἁμαρτωλῶν ἐσθίετε καὶ πίνετε; ");
INSERT INTO grcsbl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν πρὸς αὐτούς· Οὐ χρείαν ἔχουσιν οἱ ὑγιαίνοντες ἰατροῦ ἀλλὰ οἱ κακῶς ἔχοντες· ");
INSERT INTO grcsbl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","οὐκ ἐλήλυθα καλέσαι δικαίους ἀλλὰ ἁμαρτωλοὺς εἰς μετάνοιαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Οἱδὲ εἶπαν πρὸς αὐτόν· ⸀Οἱ μαθηταὶ Ἰωάννου νηστεύουσιν πυκνὰ καὶ δεήσεις ποιοῦνται, ὁμοίως καὶ οἱ τῶν Φαρισαίων, οἱ δὲ σοὶ ἐσθίουσιν καὶ πίνουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ὁ ⸀δὲεἶπεν πρὸς αὐτούς· Μὴ δύνασθε τοὺς υἱοὺς τοῦ νυμφῶνος ἐν ᾧ ὁ νυμφίος μετʼ αὐτῶν ἐστιν ποιῆσαι ⸀νηστεῦσαι ");
INSERT INTO grcsbl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ἐλεύσονται δὲ ἡμέραι, καὶ ὅταν ἀπαρθῇ ἀπʼ αὐτῶν ὁ νυμφίος τότε νηστεύσουσιν ἐν ἐκείναις ταῖς ἡμέραις. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ἔλεγεν δὲ καὶ παραβολὴν πρὸς αὐτοὺς ὅτι Οὐδεὶς ἐπίβλημα ⸀ἀπὸἱματίου καινοῦ ⸀σχίσαςἐπιβάλλει ἐπὶ ἱμάτιον παλαιόν· εἰ δὲ μήγε, καὶ τὸ καινὸν ⸀σχίσεικαὶ τῷ παλαιῷ οὐ ⸂συμφωνήσει τὸ ἐπίβλημα τὸ ἀπὸ τοῦ καινοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","καὶ οὐδεὶς βάλλει οἶνον νέον εἰς ἀσκοὺς παλαιούς· εἰ δὲ μήγε, ῥήξει ὁ ⸂οἶνος ὁ νέος τοὺς ἀσκούς, καὶ αὐτὸς ἐκχυθήσεται καὶ οἱ ἀσκοὶ ἀπολοῦνται· ");
INSERT INTO grcsbl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ἀλλὰ οἶνον νέον εἰς ἀσκοὺς καινοὺς ⸀βλητέον ");
INSERT INTO grcsbl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","⸀καὶοὐδεὶς πιὼν ⸀παλαιὸνθέλει νέον· λέγει γάρ· Ὁ παλαιὸς ⸀χρηστόςἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ἐγένετο δὲ ἐν ⸀σαββάτῳδιαπορεύεσθαι αὐτὸν ⸀διὰσπορίμων, καὶ ἔτιλλον οἱ μαθηταὶ αὐτοῦ ⸂καὶ ἤσθιον τοὺς στάχυας ψώχοντες ταῖς χερσίν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","τινὲς δὲ τῶν Φαρισαίων ⸀εἶπαν Τί ποιεῖτε ὃ οὐκ ⸀ἔξεστιντοῖς σάββασιν; ");
INSERT INTO grcsbl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","καὶ ἀποκριθεὶς πρὸς αὐτοὺς εἶπεν ὁ Ἰησοῦς· Οὐδὲ τοῦτο ἀνέγνωτε ὃ ἐποίησεν Δαυὶδ ⸀ὁπότεἐπείνασεν αὐτὸς καὶ οἱ μετʼ αὐτοῦ ⸀ὄντες ");
INSERT INTO grcsbl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","⸀ὡςεἰσῆλθεν εἰς τὸν οἶκον τοῦ θεοῦ καὶ τοὺς ἄρτους τῆς προθέσεως ⸀λαβὼνἔφαγεν καὶ ⸀ἔδωκεντοῖς μετʼ αὐτοῦ, οὓς οὐκ ἔξεστιν φαγεῖν εἰ μὴ μόνους τοὺς ἱερεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","καὶ ἔλεγεν ⸀αὐτοῖς Κύριός ἐστιν ⸂τοῦ σαββάτου ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ἐγένετο ⸀δὲἐν ἑτέρῳ σαββάτῳ εἰσελθεῖν αὐτὸν εἰς τὴν συναγωγὴν καὶ διδάσκειν· καὶ ἦν ⸂ἄνθρωπος ἐκεῖ καὶ ἡ χεὶρ αὐτοῦ ἡ δεξιὰ ἦν ξηρά· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","⸀παρετηροῦντο⸀δὲοἱ γραμματεῖς καὶ οἱ Φαρισαῖοι εἰ ἐν τῷ σαββάτῳ ⸀θεραπεύει ἵνα εὕρωσιν ⸀κατηγορεῖναὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","αὐτὸς δὲ ᾔδει τοὺς διαλογισμοὺς αὐτῶν, ⸂εἶπεν δὲ τῷ ⸀ἀνδρὶτῷ ξηρὰν ἔχοντι τὴν χεῖρα· ⸀Ἔγειρεκαὶστῆθι εἰς τὸ μέσον· ⸀καὶ ἀναστὰς ἔστη. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","εἶπεν ⸀δὲὁ Ἰησοῦς πρὸς αὐτούς· ⸀Ἐπερωτῶὑμᾶς, ⸀εἰἔξεστιν ⸂τῷ σαββάτῳ ἀγαθοποιῆσαι ἢ κακοποιῆσαι, ψυχὴν σῶσαι ἢ ⸀ἀπολέσαι ");
INSERT INTO grcsbl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","καὶ περιβλεψάμενος πάντας αὐτοὺς εἶπεν αὐτῷ· Ἔκτεινον τὴν χεῖρά σου· ὁ δὲ ἐποίησεν, καὶ ἀπεκατεστάθη ἡ χεὶρ ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","αὐτοὶ δὲ ἐπλήσθησαν ἀνοίας, καὶ διελάλουν πρὸς ἀλλήλους τί ἂν ποιήσαιεν τῷ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ταύταις ⸂ἐξελθεῖν αὐτὸν εἰς τὸ ὄρος προσεύξασθαι, καὶ ἦν διανυκτερεύων ἐν τῇ προσευχῇ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","καὶ ὅτε ἐγένετο ἡμέρα, προσεφώνησεν τοὺς μαθητὰς αὐτοῦ, καὶ ἐκλεξάμενος ἀπʼ αὐτῶν δώδεκα, οὓς καὶ ἀποστόλους ὠνόμασεν, ");
INSERT INTO grcsbl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Σίμωνα ὃν καὶ ὠνόμασεν Πέτρον καὶ Ἀνδρέαν τὸν ἀδελφὸν αὐτοῦ ⸀καὶἸάκωβον καὶ Ἰωάννην ⸁καὶΦίλιππον καὶ Βαρθολομαῖον ");
INSERT INTO grcsbl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","⸀καὶΜαθθαῖον καὶ Θωμᾶν ⸁καὶ⸀ἸάκωβονἉλφαίου καὶ Σίμωνα τὸν καλούμενον Ζηλωτὴν ");
INSERT INTO grcsbl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","⸀καὶἸούδαν Ἰακώβου καὶ Ἰούδαν ⸀Ἰσκαριὼθ⸀ὃςἐγένετο προδότης. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Καὶ καταβὰς μετʼ αὐτῶν ἔστη ἐπὶ τόπου πεδινοῦ, καὶ ὄχλος ⸀πολὺςμαθητῶν αὐτοῦ, καὶ πλῆθος πολὺ τοῦ λαοῦ ἀπὸ πάσης τῆς Ἰουδαίας καὶ Ἰερουσαλὴμ καὶ τῆς παραλίου Τύρου καὶ Σιδῶνος, ");
INSERT INTO grcsbl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","οἳ ἦλθον ἀκοῦσαι αὐτοῦ καὶ ἰαθῆναι ἀπὸ τῶν νόσων αὐτῶν· καὶ οἱ ⸂ἐνοχλούμενοι ἀπὸ πνευμάτων ⸀ἀκαθάρτωνἐθεραπεύοντο· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","καὶ πᾶς ὁ ὄχλος ⸀ἐζήτουνἅπτεσθαι αὐτοῦ, ὅτι δύναμις παρʼ αὐτοῦ ἐξήρχετο καὶ ἰᾶτο πάντας. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Καὶ αὐτὸς ἐπάρας τοὺς ὀφθαλμοὺς αὐτοῦ εἰς τοὺς μαθητὰς αὐτοῦ ἔλεγεν· Μακάριοι οἱ πτωχοί, ὅτι ὑμετέρα ἐστὶν ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","μακάριοι οἱ πεινῶντες νῦν, ὅτι χορτασθήσεσθε. μακάριοι οἱ κλαίοντες νῦν, ὅτι γελάσετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Μακάριοί ἐστε ὅταν μισήσωσιν ὑμᾶς οἱ ἄνθρωποι, καὶ ὅταν ἀφορίσωσιν ὑμᾶς καὶ ὀνειδίσωσιν καὶ ἐκβάλωσιν τὸ ὄνομα ὑμῶν ὡς πονηρὸν ἕνεκα τοῦ υἱοῦ τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","χάρητε ἐν ἐκείνῃ τῇ ἡμέρᾳ καὶ σκιρτήσατε, ἰδοὺ γὰρ ὁ μισθὸς ὑμῶν πολὺς ἐν τῷ οὐρανῷ· κατὰ ⸂τὰ αὐτὰ γὰρ ἐποίουν τοῖς προφήταις οἱ πατέρες αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","πλὴν οὐαὶ ὑμῖν τοῖς πλουσίοις, ὅτι ἀπέχετε τὴν παράκλησιν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","οὐαὶ ὑμῖν, οἱ ἐμπεπλησμένοι ⸀νῦν ὅτι πεινάσετε. ⸀οὐαί οἱ γελῶντες νῦν, ὅτι πενθήσετε καὶ κλαύσετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Οὐαὶ ὅταν ⸂καλῶς ὑμᾶς εἴπωσιν ⸀πάντεςοἱ ἄνθρωποι, κατὰ ⸂τὰ αὐτὰ γὰρ ἐποίουν τοῖς ψευδοπροφήταις οἱ πατέρες αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ἀλλὰ ὑμῖν λέγω τοῖς ἀκούουσιν, ἀγαπᾶτε τοὺς ἐχθροὺς ὑμῶν, καλῶς ποιεῖτε τοῖς μισοῦσιν ὑμᾶς, ");
INSERT INTO grcsbl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","εὐλογεῖτε τοὺς καταρωμένους ⸀ὑμᾶς προσεύχεσθε ⸀περὶτῶν ἐπηρεαζόντων ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","τῷ τύπτοντί σε ἐπὶ τὴν σιαγόνα πάρεχε καὶ τὴν ἄλλην, καὶ ἀπὸ τοῦ αἴροντός σου τὸ ἱμάτιον καὶ τὸν χιτῶνα μὴ κωλύσῃς. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","⸀παντὶαἰτοῦντί σε δίδου, καὶ ἀπὸ τοῦ αἴροντος τὰ σὰ μὴ ἀπαίτει. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","καὶ καθὼς θέλετε ἵνα ποιῶσιν ὑμῖν οἱ ⸀ἄνθρωποι ποιεῖτε αὐτοῖς ὁμοίως. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Καὶ εἰ ἀγαπᾶτε τοὺς ἀγαπῶντας ὑμᾶς, ποία ὑμῖν χάρις ἐστίν; καὶ γὰρ οἱ ἁμαρτωλοὶ τοὺς ἀγαπῶντας αὐτοὺς ἀγαπῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","⸀καὶἐὰν ἀγαθοποιῆτε τοὺς ἀγαθοποιοῦντας ὑμᾶς, ποία ὑμῖν χάρις ἐστίν; ⸁καὶοἱ ἁμαρτωλοὶ τὸ αὐτὸ ποιοῦσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","καὶ ἐὰν ⸀δανίσητεπαρʼ ὧν ἐλπίζετε ⸀λαβεῖν ποία ὑμῖν χάρις ἐστίν; ⸀καὶἁμαρτωλοὶ ἁμαρτωλοῖς δανίζουσιν ἵνα ἀπολάβωσιν τὰ ἴσα. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","πλὴν ἀγαπᾶτε τοὺς ἐχθροὺς ὑμῶν καὶ ἀγαθοποιεῖτε καὶ δανίζετε μηδὲν ἀπελπίζοντες· καὶ ἔσται ὁ μισθὸς ὑμῶν πολύς, καὶ ἔσεσθε υἱοὶ Ὑψίστου, ὅτι αὐτὸς χρηστός ἐστιν ἐπὶ τοὺς ἀχαρίστους καὶ πονηρούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","⸀γίνεσθεοἰκτίρμονες ⸀καθὼςὁ πατὴρ ὑμῶν οἰκτίρμων ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Καὶ μὴ κρίνετε, καὶοὐ μὴ κριθῆτε· ⸀καὶ μὴ καταδικάζετε, καὶ οὐ μὴ καταδικασθῆτε. ἀπολύετε, καὶ ἀπολυθήσεσθε· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","δίδοτε, καὶ δοθήσεται ὑμῖν· μέτρον καλὸν πεπιεσμένον ⸀σεσαλευμένονὑπερεκχυννόμενον δώσουσιν εἰς τὸν κόλπον ὑμῶν· ⸂ᾧ γὰρ μέτρῳ μετρεῖτε ἀντιμετρηθήσεται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Εἶπεν δὲ ⸀καὶπαραβολὴν αὐτοῖς· Μήτι δύναται τυφλὸς τυφλὸν ὁδηγεῖν; οὐχὶ ἀμφότεροι εἰς βόθυνον ⸀ἐμπεσοῦνται ");
INSERT INTO grcsbl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","οὐκ ἔστιν μαθητὴς ὑπὲρ τὸν ⸀διδάσκαλον κατηρτισμένος δὲ πᾶς ἔσται ὡς ὁ διδάσκαλος αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","τί δὲ βλέπεις τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου, τὴν δὲ δοκὸν τὴν ἐν τῷ ἰδίῳ ὀφθαλμῷ οὐ κατανοεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","⸀πῶςδύνασαι λέγειν τῷ ἀδελφῷ σου· Ἀδελφέ, ἄφες ἐκβάλω τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ σου, αὐτὸς τὴν ἐν τῷ ὀφθαλμῷ σοῦ δοκὸν οὐ βλέπων; ὑποκριτά, ἔκβαλε πρῶτον τὴν δοκὸν ἐκ τοῦ ὀφθαλμοῦ σοῦ, καὶ τότε διαβλέψεις ⸂τὸ κάρφος τὸ ἐν τῷ ὀφθαλμῷ τοῦ ἀδελφοῦ σου ἐκβαλεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Οὐ γάρ ἐστιν δένδρον καλὸν ποιοῦν καρπὸν σαπρόν, οὐδὲ ⸀πάλινδένδρον σαπρὸν ποιοῦν καρπὸν καλόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ἕκαστον γὰρ δένδρον ἐκ τοῦ ἰδίου καρποῦ γινώσκεται· οὐ γὰρ ἐξ ἀκανθῶν συλλέγουσιν σῦκα, οὐδὲ ἐκ βάτου ⸂σταφυλὴν τρυγῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ὁ ἀγαθὸς ἄνθρωπος ἐκ τοῦ ἀγαθοῦ θησαυροῦ τῆς καρδίας ⸀αὐτοῦπροφέρει τὸ ἀγαθόν, καὶ ὁ ⸀πονηρὸςἐκ τοῦ ⸀πονηροῦπροφέρει τὸ πονηρόν· ἐκ γὰρ ⸀περισσεύματοςκαρδίας λαλεῖ τὸ στόμα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Τί δέ με καλεῖτε· Κύριε κύριε, καὶ οὐ ποιεῖτε ἃ λέγω; ");
INSERT INTO grcsbl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","πᾶς ὁ ἐρχόμενος πρός με καὶ ἀκούων μου τῶν λόγων καὶ ποιῶν αὐτούς, ὑποδείξω ὑμῖν τίνι ἐστὶν ὅμοιος· ");
INSERT INTO grcsbl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδομοῦντι οἰκίαν ὃς ἔσκαψεν καὶ ἐβάθυνεν καὶ ἔθηκεν θεμέλιον ἐπὶ τὴν πέτραν· πλημμύρης δὲ γενομένης προσέρηξεν ὁ ποταμὸς τῇ οἰκίᾳ ἐκείνῃ, καὶ οὐκ ἴσχυσεν σαλεῦσαι αὐτὴν ⸂διὰ τὸ καλῶς οἰκοδομῆσθαι αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ὁ δὲ ἀκούσας καὶ μὴ ποιήσας ὅμοιός ἐστιν ἀνθρώπῳ οἰκοδομήσαντι οἰκίαν ἐπὶ τὴν γῆν χωρὶς θεμελίου, ᾗ προσέρηξεν ὁ ποταμός, καὶ ⸂εὐθὺς συνέπεσεν, καὶ ἐγένετο τὸ ῥῆγμα τῆς οἰκίας ἐκείνης μέγα. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","⸀Ἐπειδὴἐπλήρωσεν πάντα τὰ ῥήματα αὐτοῦ εἰς τὰς ἀκοὰς τοῦ λαοῦ, εἰσῆλθεν εἰς Καφαρναούμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ἑκατοντάρχου δέ τινος δοῦλος κακῶς ἔχων ἤμελλεν τελευτᾶν, ὃς ἦν αὐτῷ ἔντιμος. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ἀκούσας δὲ περὶ τοῦ Ἰησοῦ ἀπέστειλεν πρὸς αὐτὸν πρεσβυτέρους τῶν Ἰουδαίων, ἐρωτῶν αὐτὸν ὅπως ἐλθὼν διασώσῃ τὸν δοῦλον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","οἱ δὲ παραγενόμενοι πρὸς τὸν Ἰησοῦν παρεκάλουν αὐτὸν σπουδαίως λέγοντες ὅτι Ἄξιός ἐστιν ᾧ ⸀παρέξῃτοῦτο, ");
INSERT INTO grcsbl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ἀγαπᾷ γὰρ τὸ ἔθνος ἡμῶν καὶ τὴν συναγωγὴν αὐτὸς ᾠκοδόμησεν ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ὁ δὲ Ἰησοῦς ἐπορεύετο σὺν αὐτοῖς. ἤδη δὲ αὐτοῦ οὐ μακρὰν ἀπέχοντος ἀπὸ τῆς οἰκίας ἔπεμψεν ⸂φίλους ὁ ἑκατοντάρχης λέγων αὐτῷ· Κύριε, μὴ σκύλλου, οὐ γὰρ ⸂ἱκανός εἰμι ἵνα ὑπὸ τὴν στέγην μου εἰσέλθῃς· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","διὸ οὐδὲ ἐμαυτὸν ἠξίωσα πρὸς σὲ ἐλθεῖν· ἀλλὰ εἰπὲ λόγῳ, καὶ ⸀ἰαθήτωὁ παῖς μου· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","καὶ γὰρ ἐγὼ ἄνθρωπός εἰμι ὑπὸ ἐξουσίαν τασσόμενος, ἔχων ὑπʼ ἐμαυτὸν στρατιώτας, καὶ λέγω τούτῳ· Πορεύθητι, καὶ πορεύεται, καὶ ἄλλῳ· Ἔρχου, καὶ ἔρχεται, καὶ τῷ δούλῳ μου· Ποίησον τοῦτο, καὶ ποιεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ἀκούσας δὲ ταῦτα ὁ Ἰησοῦς ἐθαύμασεν αὐτόν, καὶ στραφεὶς τῷ ἀκολουθοῦντι αὐτῷ ὄχλῳ εἶπεν· Λέγω ὑμῖν, ⸀οὐδὲἐν τῷ Ἰσραὴλ τοσαύτην πίστιν εὗρον. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","καὶ ὑποστρέψαντες ⸂εἰς τὸν οἶκον οἱ πεμφθέντες εὗρον ⸀τὸνδοῦλον ὑγιαίνοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Καὶ ἐγένετο ἐν τῷ ἑξῆς ⸀ἐπορεύθηεἰς πόλιν καλουμένην Ναΐν, καὶ συνεπορεύοντο αὐτῷ οἱ μαθηταὶ ⸀αὐτοῦκαὶ ὄχλος πολύς. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ὡς δὲ ἤγγισεν τῇ πύλῃ τῆς πόλεως, καὶ ἰδοὺ ἐξεκομίζετο τεθνηκὼς ⸂μονογενὴς υἱὸς τῇ μητρὶ αὐτοῦ, καὶ αὐτὴ ⸀ἦνχήρα, καὶ ὄχλος τῆς πόλεως ἱκανὸς ⸁ἦνσὺν αὐτῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","καὶ ἰδὼν αὐτὴν ὁ κύριος ἐσπλαγχνίσθη ἐπʼ αὐτῇ καὶ εἶπεν αὐτῇ· Μὴ κλαῖε. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","καὶ προσελθὼν ἥψατο τῆς σοροῦ, οἱ δὲ βαστάζοντες ἔστησαν, καὶ εἶπεν· Νεανίσκε, σοὶ λέγω, ἐγέρθητι. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","καὶ ἀνεκάθισεν ὁ νεκρὸς καὶ ἤρξατο λαλεῖν, καὶ ἔδωκεν αὐτὸν τῇ μητρὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ἔλαβεν δὲ φόβος πάντας, καὶ ἐδόξαζον τὸν θεὸν λέγοντες ὅτι Προφήτης μέγας ⸀ἠγέρθηἐν ἡμῖν, καὶ ὅτι Ἐπεσκέψατο ὁ θεὸς τὸν λαὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","καὶἐξῆλθεν ὁ λόγος οὗτος ἐν ὅλῃ τῇ Ἰουδαίᾳ περὶ αὐτοῦ ⸀καὶ πάσῃ τῇ περιχώρῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Καὶ ἀπήγγειλαν Ἰωάννῃ οἱ μαθηταὶ αὐτοῦ περὶ πάντων τούτων. καὶ προσκαλεσάμενος δύο τινὰς τῶν μαθητῶν αὐτοῦ ὁ Ἰωάννης ");
INSERT INTO grcsbl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ἔπεμψεν πρὸς τὸν ⸀κύριονλέγων· Σὺ εἶ ὁ ἐρχόμενος ἢ ⸀ἄλλονπροσδοκῶμεν; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","παραγενόμενοι δὲ πρὸς αὐτὸν οἱ ἄνδρες εἶπαν· Ἰωάννης ὁ βαπτιστὴς ⸀ἀπέστειλενἡμᾶς πρὸς σὲ λέγων· Σὺ εἶ ὁ ἐρχόμενος ἢ ἄλλον προσδοκῶμεν; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ἐν ⸀ἐκείνῃτῇ ὥρᾳ ἐθεράπευσεν πολλοὺς ἀπὸ νόσων καὶ μαστίγων καὶ πνευμάτων πονηρῶν, καὶ τυφλοῖς πολλοῖς ⸀ἐχαρίσατοβλέπειν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","καὶ ⸀ἀποκριθεὶςεἶπεν αὐτοῖς· Πορευθέντες ἀπαγγείλατε Ἰωάννῃ ἃ εἴδετε καὶ ἠκούσατε· ⸀τυφλοὶἀναβλέπουσιν, χωλοὶ περιπατοῦσιν, λεπροὶ καθαρίζονται, ⸀κωφοὶἀκούουσιν, νεκροὶ ἐγείρονται, πτωχοὶ εὐαγγελίζονται· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","καὶ μακάριός ἐστιν ὃς ἐὰν μὴ σκανδαλισθῇ ἐν ἐμοί. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ἀπελθόντων δὲ τῶν ἀγγέλων Ἰωάννου ἤρξατο λέγειν ⸂πρὸς τοὺς ὄχλους περὶ Ἰωάννου· Τί ⸀ἐξήλθατεεἰς τὴν ἔρημον θεάσασθαι; κάλαμον ὑπὸ ἀνέμου σαλευόμενον; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ἀλλὰ τί ⸀ἐξήλθατεἰδεῖν; ἄνθρωπον ἐν μαλακοῖς ἱματίοις ἠμφιεσμένον; ἰδοὺ οἱ ἐν ἱματισμῷ ἐνδόξῳ καὶ τρυφῇ ὑπάρχοντες ἐν τοῖς βασιλείοις εἰσίν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ἀλλὰ τί ⸀ἐξήλθατεἰδεῖν; προφήτην; ναί, λέγω ὑμῖν, καὶ περισσότερον προφήτου. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","οὗτός ἐστιν περὶ οὗ γέγραπται· ⸀Ἰδοὺἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ὃς κατασκευάσει τὴν ὁδόν σου ἔμπροσθέν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","⸀λέγωὑμῖν, μείζων ἐν γεννητοῖς γυναικῶν ⸀Ἰωάννουοὐδείς ἐστιν· ὁ δὲ μικρότερος ἐν τῇ βασιλείᾳ τοῦ θεοῦ μείζων αὐτοῦ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(καὶ πᾶς ὁ λαὸς ἀκούσας καὶ οἱ τελῶναι ἐδικαίωσαν τὸν θεόν, βαπτισθέντες τὸ βάπτισμα Ἰωάννου· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","οἱ δὲ Φαρισαῖοι καὶ οἱ νομικοὶ τὴν βουλὴν τοῦ θεοῦ ἠθέτησαν εἰς ἑαυτούς, μὴ βαπτισθέντες ὑπʼ αὐτοῦ.) ");
INSERT INTO grcsbl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Τίνι οὖν ὁμοιώσω τοὺς ἀνθρώπους τῆς γενεᾶς ταύτης, καὶ τίνι εἰσὶν ὅμοιοι; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ὅμοιοί εἰσιν παιδίοις τοῖς ἐν ἀγορᾷ καθημένοις καὶ προσφωνοῦσιν ἀλλήλοις, ⸂ἃ λέγει· Ηὐλήσαμεν ὑμῖν καὶ οὐκ ὠρχήσασθε· ⸀ἐθρηνήσαμενκαὶ οὐκ ἐκλαύσατε· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ἐλήλυθεν γὰρ Ἰωάννης ὁ βαπτιστὴς ⸀μὴ⸂ἐσθίων ἄρτον μήτε πίνων οἶνον, καὶ λέγετε· Δαιμόνιον ἔχει· ");
INSERT INTO grcsbl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ἐλήλυθεν ὁ υἱὸς τοῦ ἀνθρώπου ἐσθίων καὶ πίνων, καὶ λέγετε· Ἰδοὺ ἄνθρωπος φάγος καὶ οἰνοπότης, φίλος τελωνῶν καὶ ἁμαρτωλῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","καὶ ἐδικαιώθη ἡ σοφία ἀπὸ ⸂πάντων τῶν τέκνων αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ἠρώτα δέ τις αὐτὸν τῶν Φαρισαίων ἵνα φάγῃ μετʼ αὐτοῦ· καὶ εἰσελθὼν εἰς ⸂τὸν οἶκον τοῦ Φαρισαίου ⸀κατεκλίθη ");
INSERT INTO grcsbl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","καὶ ἰδοὺ γυνὴ ⸂ἥτις ἦν ἐν τῇ πόλει ἁμαρτωλός, ⸀καὶἐπιγνοῦσα ὅτι ⸀κατάκειταιἐν τῇ οἰκίᾳ τοῦ Φαρισαίου, κομίσασα ἀλάβαστρον μύρου ");
INSERT INTO grcsbl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","καὶ στᾶσα ⸂ὀπίσω παρὰ τοὺς πόδας αὐτοῦ κλαίουσα, ⸂τοῖς δάκρυσιν ἤρξατο βρέχειν τοὺς πόδας αὐτοῦ καὶ ταῖς θριξὶν τῆς κεφαλῆς αὐτῆς ἐξέμασσεν, καὶ κατεφίλει τοὺς πόδας αὐτοῦ καὶ ἤλειφεν τῷ μύρῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ἰδὼν δὲ ὁ Φαρισαῖος ὁ καλέσας αὐτὸν εἶπεν ἐν ἑαυτῷ λέγων· Οὗτος εἰ ⸀ἦνπροφήτης, ἐγίνωσκεν ἂν τίς καὶ ποταπὴ ἡ γυνὴ ἥτις ἅπτεται αὐτοῦ, ὅτι ἁμαρτωλός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν πρὸς αὐτόν· Σίμων, ἔχω σοί τι εἰπεῖν. ὁ δέ· ⸂Διδάσκαλε, εἰπέ, φησίν⸃. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","δύο χρεοφειλέται ἦσαν δανιστῇ τινι· ὁ εἷς ὤφειλεν δηνάρια πεντακόσια, ὁ δὲ ἕτερος πεντήκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","μὴ ⸀ἐχόντωναὐτῶνἀποδοῦναι ἀμφοτέροις ἐχαρίσατο. τίς οὖν ⸀αὐτῶν πλεῖον ⸂ἀγαπήσει αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","⸀ἀποκριθεὶςΣίμων εἶπεν· Ὑπολαμβάνω ὅτι ᾧ τὸ πλεῖον ἐχαρίσατο. ὁ δὲ εἶπεν αὐτῷ· Ὀρθῶς ἔκρινας. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","καὶ στραφεὶς πρὸς τὴν γυναῖκα τῷ Σίμωνι ἔφη· Βλέπεις ταύτην τὴν γυναῖκα; εἰσῆλθόν σου εἰς τὴν οἰκίαν, ὕδωρ ⸀μοιἐπὶ ⸀πόδαςοὐκ ἔδωκας· αὕτη δὲ τοῖς δάκρυσιν ἔβρεξέν μου τοὺς πόδας καὶ ταῖς ⸀θριξὶναὐτῆς ἐξέμαξεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","φίλημά μοι οὐκ ἔδωκας· αὕτη δὲ ἀφʼ ἧς εἰσῆλθον οὐ διέλιπεν καταφιλοῦσά μου τοὺς πόδας. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ἐλαίῳ τὴν κεφαλήν μου οὐκ ἤλειψας· αὕτη δὲ μύρῳ ἤλειψεν ⸂τοὺς πόδας μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","οὗ χάριν, λέγω σοι, ἀφέωνται αἱ ἁμαρτίαι αὐτῆς αἱ πολλαί, ὅτι ἠγάπησεν πολύ· ᾧ δὲ ὀλίγον ἀφίεται, ὀλίγον ἀγαπᾷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","εἶπεν δὲ αὐτῇ· Ἀφέωνταί σου αἱ ἁμαρτίαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","καὶ ἤρξαντο οἱ συνανακείμενοι λέγειν ἐν ἑαυτοῖς· Τίς οὗτός ἐστιν ὃς καὶ ἁμαρτίας ἀφίησιν; ");
INSERT INTO grcsbl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","εἶπεν δὲ πρὸς τὴν γυναῖκα· Ἡ πίστις σου σέσωκέν σε· πορεύου εἰς εἰρήνην. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Καὶ ἐγένετο ἐν τῷ καθεξῆς καὶ αὐτὸς διώδευεν κατὰ πόλιν καὶ κώμην κηρύσσων καὶ εὐαγγελιζόμενος τὴν βασιλείαν τοῦ θεοῦ, καὶ οἱ δώδεκα σὺν αὐτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","καὶ γυναῖκές τινες αἳ ἦσαν τεθεραπευμέναι ἀπὸ πνευμάτων πονηρῶν καὶ ἀσθενειῶν, Μαρία ἡ καλουμένη Μαγδαληνή, ἀφʼ ἧς δαιμόνια ἑπτὰ ἐξεληλύθει, ");
INSERT INTO grcsbl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","καὶ Ἰωάννα γυνὴ Χουζᾶ ἐπιτρόπου Ἡρῴδου καὶ Σουσάννα καὶ ἕτεραι πολλαί, αἵτινες διηκόνουν αὐτοῖς ⸀ἐκτῶν ὑπαρχόντων αὐταῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Συνιόντος δὲ ὄχλου πολλοῦ καὶ τῶν κατὰ πόλιν ἐπιπορευομένων πρὸς αὐτὸν εἶπεν διὰ παραβολῆς· ");
INSERT INTO grcsbl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ἐξῆλθεν ὁ σπείρων τοῦ σπεῖραι τὸν σπόρον αὐτοῦ. καὶ ἐν τῷ σπείρειν αὐτὸν ὃ μὲν ἔπεσεν παρὰ τὴν ὁδόν, καὶ κατεπατήθη καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατέφαγεν αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","καὶ ἕτερον ⸀κατέπεσενἐπὶ τὴν πέτραν, καὶ φυὲν ἐξηράνθη διὰ τὸ μὴ ἔχειν ἰκμάδα. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","καὶ ἕτερον ἔπεσεν ἐν μέσῳ τῶν ἀκανθῶν, καὶ συμφυεῖσαι αἱ ἄκανθαι ἀπέπνιξαν αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","καὶ ἕτερον ἔπεσεν εἰς τὴν γῆν τὴν ἀγαθήν, καὶ φυὲν ἐποίησεν καρπὸν ἑκατονταπλασίονα. ταῦτα λέγων ἐφώνει· Ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ἐπηρώτων δὲ αὐτὸν οἱ μαθηταὶ ⸀αὐτοῦτίς ⸂αὕτη εἴη ἡ παραβολή. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ὁ δὲ εἶπεν· Ὑμῖν δέδοται γνῶναι τὰ μυστήρια τῆς βασιλείας τοῦ θεοῦ, τοῖς δὲ λοιποῖς ἐν παραβολαῖς, ἵνα βλέποντες μὴ βλέπωσιν καὶ ἀκούοντες μὴ συνιῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ἔστιν δὲ αὕτη ἡ παραβολή· Ὁ σπόρος ἐστὶν ὁ λόγος τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","οἱ δὲ παρὰ τὴν ὁδόν εἰσιν οἱ ⸀ἀκούσαντες εἶτα ἔρχεται ὁ διάβολος καὶ αἴρει τὸν λόγον ἀπὸ τῆς καρδίας αὐτῶν, ἵνα μὴ πιστεύσαντες σωθῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","οἱ δὲ ἐπὶ τῆς πέτρας οἳ ὅταν ἀκούσωσιν μετὰ χαρᾶς δέχονται τὸν λόγον, καὶ οὗτοι ῥίζαν οὐκ ἔχουσιν, οἳ πρὸς καιρὸν πιστεύουσιν καὶ ἐν καιρῷ πειρασμοῦ ἀφίστανται. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","τὸ δὲ εἰς τὰς ἀκάνθας πεσόν, οὗτοί εἰσιν οἱ ἀκούσαντες, καὶ ὑπὸ μεριμνῶν καὶ πλούτου καὶ ἡδονῶν τοῦ βίου πορευόμενοι συμπνίγονται καὶ οὐ τελεσφοροῦσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","τὸ δὲ ἐν τῇ καλῇ γῇ, οὗτοί εἰσιν οἵτινες ἐν καρδίᾳ καλῇ καὶ ἀγαθῇ ἀκούσαντες τὸν λόγον κατέχουσιν καὶ καρποφοροῦσιν ἐν ὑπομονῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Οὐδεὶς δὲ λύχνον ἅψας καλύπτει αὐτὸν σκεύει ἢ ὑποκάτω κλίνης τίθησιν ἀλλʼ ἐπὶ λυχνίας ⸀τίθησιν, ἵνα οἱ εἰσπορευόμενοι βλέπωσιν τὸ φῶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","οὐ γάρ ἐστιν κρυπτὸν ὃ οὐ φανερὸν γενήσεται, οὐδὲ ἀπόκρυφον ὃ οὐ ⸂μὴ γνωσθῇ καὶ εἰς φανερὸν ἔλθῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","βλέπετε οὖν πῶς ἀκούετε· ὃς ⸂ἂν γὰρ ἔχῃ, δοθήσεται αὐτῷ, καὶ ὃς ⸀ἂνμὴ ἔχῃ, καὶ ὃ δοκεῖ ἔχειν ἀρθήσεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","⸀Παρεγένετοδὲ πρὸς αὐτὸν ἡ μήτηρ καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ οὐκ ἠδύναντο συντυχεῖν αὐτῷ διὰ τὸν ὄχλον. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","⸂ἀπηγγέλη δὲ ⸀αὐτῷ Ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου ἑστήκασιν ἔξω ἰδεῖν ⸂σε θέλοντες. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ὁ δὲ ἀποκριθεὶς εἶπεν πρὸς αὐτούς· Μήτηρ μου καὶ ἀδελφοί μου οὗτοί εἰσιν οἱ τὸν λόγον τοῦ θεοῦ ἀκούοντες καὶ ⸀ποιοῦντες ");
INSERT INTO grcsbl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","⸂Ἐγένετο δὲ ἐν μιᾷ τῶν ἡμερῶν καὶ αὐτὸς ἐνέβη εἰς πλοῖον καὶ οἱ μαθηταὶ αὐτοῦ, καὶ εἶπεν πρὸς αὐτούς· Διέλθωμεν εἰς τὸ πέραν τῆς λίμνης, καὶ ἀνήχθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","πλεόντων δὲ αὐτῶν ἀφύπνωσεν. καὶ κατέβη λαῖλαψ ἀνέμου εἰς τὴν λίμνην, καὶ συνεπληροῦντο καὶ ἐκινδύνευον. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","προσελθόντες δὲ διήγειραν αὐτὸν λέγοντες· Ἐπιστάτα ἐπιστάτα, ἀπολλύμεθα· ὁ δὲ ⸀διεγερθεὶςἐπετίμησεν τῷ ἀνέμῳ καὶ τῷ κλύδωνι τοῦ ὕδατος, καὶ ἐπαύσαντο, καὶ ἐγένετο γαλήνη. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","εἶπεν δὲ αὐτοῖς· ⸀Ποῦἡ πίστις ὑμῶν; φοβηθέντες δὲ ἐθαύμασαν, λέγοντες πρὸς ἀλλήλους· Τίς ἄρα οὗτός ἐστιν ὅτι καὶ τοῖς ἀνέμοις ἐπιτάσσει καὶ τῷ ὕδατι, καὶ ὑπακούουσιν αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Καὶ κατέπλευσαν εἰς τὴν χώραν τῶν ⸀Γερασηνῶν ἥτις ἐστὶν ἀντιπέρα τῆς Γαλιλαίας. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ἐξελθόντι δὲ αὐτῷ ἐπὶ τὴν γῆν ⸀ὑπήντησενἀνήρ τις ἐκ τῆς πόλεως ⸀ἔχωνδαιμόνια· ⸂καὶ χρόνῳ ἱκανῷ οὐκ ἐνεδύσατο ἱμάτιον, καὶ ἐν οἰκίᾳ οὐκ ἔμενεν ἀλλʼ ἐν τοῖς μνήμασιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ἰδὼν δὲ τὸν ⸀Ἰησοῦνἀνακράξας προσέπεσεν αὐτῷ καὶ φωνῇ μεγάλῃ εἶπεν· Τί ἐμοὶ καὶ σοί, Ἰησοῦ υἱὲ τοῦ θεοῦ τοῦ ὑψίστου; δέομαί σου, μή με βασανίσῃς· ");
INSERT INTO grcsbl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","⸀παρήγγελλενγὰρ τῷ πνεύματι τῷ ἀκαθάρτῳ ἐξελθεῖν ἀπὸ τοῦ ἀνθρώπου. πολλοῖς γὰρ χρόνοις συνηρπάκει αὐτόν, καὶ ⸀ἐδεσμεύετοἁλύσεσιν καὶ πέδαις φυλασσόμενος, καὶ διαρρήσσων τὰ δεσμὰ ἠλαύνετο ⸀ὑπὸτοῦ ⸀δαιμονίουεἰς τὰς ἐρήμους. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ἐπηρώτησεν δὲ αὐτὸν ὁ ⸀Ἰησοῦς Τί σοι ⸂ὄνομά ἐστιν; ὁ δὲ εἶπεν· Λεγιών, ὅτι ⸂εἰσῆλθεν δαιμόνια πολλὰ εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","καὶ ⸀παρεκάλουναὐτὸν ἵνα μὴ ἐπιτάξῃ αὐτοῖς εἰς τὴν ἄβυσσον ἀπελθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ἦν δὲ ἐκεῖ ἀγέλη χοίρων ἱκανῶν ⸀βοσκομένηἐν τῷ ὄρει· καὶ ⸀παρεκάλεσαναὐτὸν ἵνα ἐπιτρέψῃ αὐτοῖς εἰς ἐκείνους εἰσελθεῖν· καὶ ἐπέτρεψεν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ἐξελθόντα δὲ τὰ δαιμόνια ἀπὸ τοῦ ἀνθρώπου εἰσῆλθον εἰς τοὺς χοίρους, καὶ ὥρμησεν ἡ ἀγέλη κατὰ τοῦ κρημνοῦ εἰς τὴν λίμνην καὶ ἀπεπνίγη. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ἰδόντες δὲ οἱ βόσκοντες τὸ ⸀γεγονὸςἔφυγον καὶ ἀπήγγειλαν εἰς τὴν πόλιν καὶ εἰς τοὺς ἀγρούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ἐξῆλθον δὲ ἰδεῖν τὸ γεγονὸς καὶ ἦλθον πρὸς τὸν Ἰησοῦν, καὶ εὗρον καθήμενον τὸν ἄνθρωπον ἀφʼ οὗ τὰ δαιμόνια ⸀ἐξῆλθενἱματισμένον καὶ σωφρονοῦντα παρὰ τοὺς πόδας τοῦ Ἰησοῦ, καὶ ἐφοβήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ἀπήγγειλαν δὲ ⸀αὐτοῖςοἱ ἰδόντες πῶς ἐσώθη ὁ δαιμονισθείς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","καὶ ⸀ἠρώτησεναὐτὸν ἅπαν τὸ πλῆθος τῆς περιχώρου τῶν ⸀Γερασηνῶνἀπελθεῖν ἀπʼ αὐτῶν, ὅτι φόβῳ μεγάλῳ συνείχοντο· αὐτὸς δὲ ἐμβὰς ⸀εἰςπλοῖον ὑπέστρεψεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ἐδεῖτο δὲ αὐτοῦ ὁ ἀνὴρ ἀφʼ οὗ ἐξεληλύθει τὰ δαιμόνια εἶναι σὺν αὐτῷ· ἀπέλυσεν δὲ ⸀αὐτὸνλέγων· ");
INSERT INTO grcsbl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ὑπόστρεφε εἰς τὸν οἶκόν σου, καὶ διηγοῦ ὅσα ⸂σοι ἐποίησεν ὁ θεός. καὶ ἀπῆλθεν καθʼ ὅλην τὴν πόλιν κηρύσσων ὅσα ἐποίησεν αὐτῷ ὁ Ἰησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","⸂Ἐν δὲ τῷ ⸀ὑποστρέφειντὸν Ἰησοῦν ἀπεδέξατο αὐτὸν ὁ ὄχλος, ἦσαν γὰρ πάντες προσδοκῶντες αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","καὶ ἰδοὺ ἦλθεν ἀνὴρ ᾧ ὄνομα Ἰάϊρος, καὶ ⸀οὗτοςἄρχων τῆς συναγωγῆς ὑπῆρχεν, καὶ πεσὼν παρὰ τοὺς πόδας ⸀τοῦἸησοῦ παρεκάλει αὐτὸν εἰσελθεῖν εἰς τὸν οἶκον αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ὅτι θυγάτηρ μονογενὴς ἦν αὐτῷ ὡς ἐτῶν δώδεκα καὶ αὐτὴ ἀπέθνῃσκεν. Ἐν δὲ τῷ ὑπάγειν αὐτὸν οἱ ὄχλοι συνέπνιγον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","καὶ γυνὴ οὖσα ἐν ῥύσει αἵματος ἀπὸ ἐτῶν δώδεκα, ἥτις ⸂ἰατροῖς προσαναλώσασα ὅλον τὸν βίον οὐκ ἴσχυσεν ⸀ἀπʼοὐδενὸς θεραπευθῆναι, ");
INSERT INTO grcsbl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","προσελθοῦσα ὄπισθεν ἥψατο τοῦ κρασπέδου τοῦ ἱματίου αὐτοῦ, καὶ παραχρῆμα ἔστη ἡ ῥύσις τοῦ αἵματος αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","καὶ εἶπεν ὁ Ἰησοῦς· Τίς ὁ ἁψάμενός μου; ἀρνουμένων δὲ πάντων εἶπεν ὁ ⸀Πέτρος Ἐπιστάτα, οἱ ὄχλοι συνέχουσίν σε καὶ ⸀ἀποθλίβουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ὁ δὲ Ἰησοῦς εἶπεν· Ἥψατό μού τις, ἐγὼ γὰρ ἔγνων δύναμιν ⸀ἐξεληλυθυῖανἀπʼ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ἰδοῦσα δὲ ἡ γυνὴ ὅτι οὐκ ἔλαθεν τρέμουσα ἦλθεν καὶ προσπεσοῦσα αὐτῷ διʼ ἣν αἰτίαν ἥψατο αὐτοῦ ⸀ἀπήγγειλενἐνώπιον παντὸς τοῦ λαοῦ καὶ ὡς ἰάθη παραχρῆμα. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ὁ δὲ εἶπεν αὐτῇ· ⸀Θυγάτηρ ἡ πίστις σου σέσωκέν σε· πορεύου εἰς εἰρήνην. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ἔτι αὐτοῦ λαλοῦντος ἔρχεταί τις παρὰ τοῦ ἀρχισυναγώγου ⸀λέγωνὅτι Τέθνηκεν ἡ θυγάτηρ σου, ⸀μηκέτισκύλλε τὸν διδάσκαλον. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ὁ δὲ Ἰησοῦς ἀκούσας ἀπεκρίθη ⸀αὐτῷ Μὴ φοβοῦ, μόνον ⸀πίστευσον καὶ σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ἐλθὼν δὲ εἰς τὴν οἰκίαν οὐκ ἀφῆκεν εἰσελθεῖν ⸂τινα σὺν αὐτῷ εἰ μὴ Πέτρον καὶ Ἰωάννην καὶ Ἰάκωβον καὶ τὸν πατέρα τῆς παιδὸς καὶ τὴν μητέρα. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ἔκλαιον δὲ πάντες καὶ ἐκόπτοντο αὐτήν. ὁ δὲ εἶπεν· Μὴ κλαίετε, ⸂οὐ γὰρ ἀπέθανεν ἀλλὰ καθεύδει. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","καὶ κατεγέλων αὐτοῦ, εἰδότες ὅτι ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","αὐτὸς ⸀δὲκρατήσας τῆς χειρὸς αὐτῆς ἐφώνησεν λέγων· Ἡ παῖς, ⸀ἔγειρε ");
INSERT INTO grcsbl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","καὶ ἐπέστρεψεν τὸ πνεῦμα αὐτῆς, καὶ ἀνέστη παραχρῆμα, καὶ διέταξεν αὐτῇ δοθῆναι φαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","καὶ ἐξέστησαν οἱ γονεῖς αὐτῆς· ὁ δὲ παρήγγειλεν αὐτοῖς μηδενὶ εἰπεῖν τὸ γεγονός. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Συγκαλεσάμενος δὲ τοὺς δώδεκα ἔδωκεν αὐτοῖς δύναμιν καὶ ἐξουσίαν ἐπὶ πάντα τὰ δαιμόνια καὶ νόσους θεραπεύειν, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","καὶ ἀπέστειλεν αὐτοὺς κηρύσσειν τὴν βασιλείαν τοῦ θεοῦ καὶ ἰᾶσθαι ⸂τοὺς ἀσθενεῖς, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","καὶ εἶπεν πρὸς αὐτούς· Μηδὲν αἴρετε εἰς τὴν ὁδόν, μήτε ⸀ῥάβδονμήτε πήραν μήτε ἄρτον μήτε ἀργύριον, μήτε ⸀ἀνὰδύο χιτῶνας ἔχειν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","καὶ εἰς ἣν ἂν οἰκίαν εἰσέλθητε, ἐκεῖ μένετε καὶ ἐκεῖθεν ἐξέρχεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","καὶ ὅσοι ⸀ἂνμὴ ⸀δέχωνταιὑμᾶς, ἐξερχόμενοι ἀπὸ τῆς πόλεως ⸀ἐκείνηςτὸν κονιορτὸν ἀπὸ τῶν ποδῶν ὑμῶν ⸀ἀποτινάσσετεεἰς μαρτύριον ἐπʼ αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ἐξερχόμενοι δὲ διήρχοντο κατὰ τὰς κώμας εὐαγγελιζόμενοι καὶ θεραπεύοντες πανταχοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ἤκουσεν δὲ Ἡρῴδης ὁ τετραάρχης τὰ ⸀γινόμεναπάντα, καὶ διηπόρει διὰ τὸ λέγεσθαι ὑπό τινων ὅτι Ἰωάννης ⸀ἠγέρθηἐκ νεκρῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ὑπό τινων δὲ ὅτι Ἠλίας ἐφάνη, ἄλλων δὲ ὅτι προφήτης ⸀τιςτῶν ἀρχαίων ἀνέστη. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","⸂εἶπεν δὲ ⸀ὁἩρῴδης· Ἰωάννην ἐγὼ ἀπεκεφάλισα· τίς δέ ἐστιν οὗος περὶ ⸀οὗ ἀκούω τοιαῦτα; καὶ ἐζήτει ἰδεῖν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Καὶ ὑποστρέψαντες οἱ ἀπόστολοι διηγήσαντο αὐτῷ ὅσα ἐποίησαν. καὶ παραλαβὼν αὐτοὺς ὑπεχώρησεν κατʼ ἰδίαν εἰς ⸂πόλιν καλουμένην Βηθσαϊδά. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","οἱ δὲ ὄχλοι γνόντες ἠκολούθησαν αὐτῷ. καὶ ⸀ἀποδεξάμενοςαὐτοὺς ἐλάλει αὐτοῖς περὶ τῆς βασιλείας τοῦ θεοῦ, καὶ τοὺς χρείαν ἔχοντας θεραπείας ἰᾶτο. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ἡ δὲ ἡμέρα ἤρξατο κλίνειν· προσελθόντες δὲ οἱ δώδεκα εἶπαν αὐτῷ· Ἀπόλυσον τὸν ὄχλον, ἵνα ⸀πορευθέντεςεἰς τὰς κύκλῳ κώμας ⸀καὶἀγροὺς καταλύσωσιν καὶ εὕρωσιν ἐπισιτισμόν, ὅτι ὧδε ἐν ἐρήμῳ τόπῳ ἐσμέν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","εἶπεν δὲ πρὸς αὐτούς· Δότε αὐτοῖς ⸂ὑμεῖς φαγεῖν. οἱ δὲ εἶπαν· Οὐκ εἰσὶν ἡμῖν πλεῖον ἢ ⸂ἄρτοι πέντε καὶ ἰχθύες δύο, εἰ μήτι πορευθέντες ἡμεῖς ἀγοράσωμεν εἰς πάντα τὸν λαὸν τοῦτον βρώματα. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ἦσαν γὰρ ὡσεὶἄνδρες πεντακισχίλιοι. εἶπεν δὲ πρὸς τοὺς μαθητὰς αὐτοῦ· Κατακλίνατε αὐτοὺς κλισίας ⸀ὡσεὶ ἀνὰ πεντήκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","καὶ ἐποίησαν οὕτως καὶ ⸀κατέκλινανἅπαντας. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","λαβὼν δὲ τοὺς πέντε ἄρτους καὶ τοὺς δύο ἰχθύας ἀναβλέψας εἰς τὸν οὐρανὸν εὐλόγησεν αὐτοὺς καὶ κατέκλασεν καὶ ἐδίδου τοῖς μαθηταῖς ⸀παραθεῖναιτῷ ὄχλῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","καὶ ἔφαγον καὶ ἐχορτάσθησαν πάντες, καὶ ἤρθη τὸ περισσεῦσαν αὐτοῖς κλασμάτων κόφινοι δώδεκα. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Καὶ ἐγένετο ἐν τῷ εἶναι αὐτὸν προσευχόμενον κατὰ μόνας συνῆσαν αὐτῷ οἱ μαθηταί, καὶ ἐπηρώτησεν αὐτοὺς λέγων· Τίνα με ⸂οἱ ὄχλοι λέγουσιν εἶναι; ");
INSERT INTO grcsbl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","οἱ δὲ ἀποκριθέντες εἶπαν· Ἰωάννην τὸν βαπτιστήν, ἄλλοι δὲ Ἠλίαν, ἄλλοι δὲ ὅτι προφήτης τις τῶν ἀρχαίων ἀνέστη. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","εἶπεν δὲ αὐτοῖς· Ὑμεῖς δὲ τίνα με λέγετε εἶναι; ⸂Πέτρος δὲ ἀποκριθεὶς εἶπεν· Τὸν χριστὸν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ὁ δὲ ἐπιτιμήσας αὐτοῖς παρήγγειλεν μηδενὶ ⸀λέγειντοῦτο, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","εἰπὼν ὅτι Δεῖ τὸν υἱὸν τοῦ ἀνθρώπου πολλὰ παθεῖν καὶ ἀποδοκιμασθῆναι ἀπὸ τῶν πρεσβυτέρων καὶ ἀρχιερέων καὶ γραμματέων καὶ ἀποκτανθῆναι καὶ τῇ τρίτῃ ἡμέρᾳ ⸀ἐγερθῆναι ");
INSERT INTO grcsbl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ἔλεγεν δὲ πρὸς πάντας· Εἴ τις θέλει ὀπίσω μου ⸂ἔρχεσθαι, ἀρνησάσθω⸃ ἑαυτὸν καὶ ἀράτω τὸν σταυρὸν αὐτοῦ ⸂καθʼ ἡμέραν⸃, καὶ ἀκολουθείτω μοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ὃς γὰρ ⸀ἂνθέλῃ τὴν ψυχὴν αὐτοῦ σῶσαι, ἀπολέσει αὐτήν· ὃς δʼ ἂν ἀπολέσῃ τὴν ψυχὴν αὐτοῦ ἕνεκεν ἐμοῦ, οὗτος σώσει αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","τί γὰρ ὠφελεῖται ἄνθρωπος κερδήσας τὸν κόσμον ὅλον ἑαυτὸν δὲ ἀπολέσας ἢ ζημιωθείς; ");
INSERT INTO grcsbl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ὃς γὰρ ἂν ἐπαισχυνθῇ με καὶ τοὺς ἐμοὺς λόγους, τοῦτον ὁ υἱὸς τοῦ ἀνθρώπου ἐπαισχυνθήσεται, ὅταν ἔλθῃ ἐν τῇ δόξῃ αὐτοῦ καὶ τοῦ πατρὸς καὶ τῶν ἁγίων ἀγγέλων. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","λέγω δὲ ὑμῖν ἀληθῶς, εἰσίν τινες τῶν ⸀αὐτοῦ⸀ἑστηκότωνοἳ οὐ μὴ γεύσωνται θανάτου ἕως ἂν ἴδωσιν τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ἐγένετο δὲ μετὰ τοὺς λόγους τούτους ὡσεὶ ἡμέραι ὀκτὼ ⸀καὶπαραλαβὼν Πέτρον καὶ Ἰωάννην καὶ Ἰάκωβον ἀνέβη εἰς τὸ ὄρος προσεύξασθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","καὶ ἐγένετο ἐν τῷ προσεύχεσθαι αὐτὸν τὸ εἶδος τοῦ προσώπου αὐτοῦ ἕτερον καὶ ὁ ἱματισμὸς αὐτοῦ λευκὸς ἐξαστράπτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","καὶ ἰδοὺ ἄνδρες δύο συνελάλουν αὐτῷ, οἵτινες ἦσαν Μωϋσῆς καὶ Ἠλίας, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","οἳ ὀφθέντες ἐν δόξῃ ἔλεγον τὴν ἔξοδον αὐτοῦ ἣν ἤμελλεν πληροῦν ἐν Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ὁ δὲ Πέτρος καὶ οἱ σὺν αὐτῷ ἦσαν βεβαρημένοι ὕπνῳ· διαγρηγορήσαντες δὲ εἶδον τὴν δόξαν αὐτοῦ καὶ τοὺς δύο ἄνδρας τοὺς συνεστῶτας αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","καὶ ἐγένετο ἐν τῷ διαχωρίζεσθαι αὐτοὺς ἀπʼ αὐτοῦ εἶπεν ⸀ὁΠέτρος πρὸς τὸν Ἰησοῦν· Ἐπιστάτα, καλόν ἐστιν ἡμᾶς ὧδε εἶναι, καὶ ποιήσωμεν σκηνὰς τρεῖς, μίαν σοὶ καὶ μίαν Μωϋσεῖ καὶ μίαν Ἠλίᾳ, μὴ εἰδὼς ὃ λέγει. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ταῦτα δὲ αὐτοῦ λέγοντος ἐγένετο νεφέλη καὶ ⸀ἐπεσκίαζεναὐτούς· ἐφοβήθησαν δὲ ἐν τῷ ⸂εἰσελθεῖν αὐτοὺς εἰς τὴν νεφέλην. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","καὶ φωνὴ ἐγένετο ἐκ τῆς νεφέλης λέγουσα· Οὗτός ἐστιν ὁ υἱός μου ὁ ⸀ἐκλελεγμένος αὐτοῦ ἀκούετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","καὶ ἐν τῷ γενέσθαι τὴν φωνὴν ⸀εὑρέθηἸησοῦς μόνος. καὶ αὐτοὶ ἐσίγησαν καὶ οὐδενὶ ἀπήγγειλαν ἐν ἐκείναις ταῖς ἡμέραις οὐδὲν ὧν ἑώρακαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ἐγένετο ⸀δὲτῇ ἑξῆς ἡμέρᾳ κατελθόντων αὐτῶν ἀπὸ τοῦ ὄρους συνήντησεν αὐτῷ ὄχλος πολύς. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","καὶ ἰδοὺ ἀνὴρ ἀπὸ τοῦ ὄχλου ⸀ἐβόησενλέγων· Διδάσκαλε, δέομαί σου ἐπιβλέψαι ἐπὶ τὸν υἱόν μου, ὅτι μονογενής ⸂μοί ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","καὶ ἰδοὺ πνεῦμα λαμβάνει αὐτόν, καὶ ἐξαίφνης κράζει, καὶ σπαράσσει αὐτὸν μετὰ ἀφροῦ καὶ ⸀μόγιςἀποχωρεῖ ἀπʼ αὐτοῦ συντρῖβον αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","καὶ ἐδεήθην τῶν μαθητῶν σου ἵνα ἐκβάλωσιν αὐτό, καὶ οὐκ ἠδυνήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν· Ὦ γενεὰ ἄπιστος καὶ διεστραμμένη, ἕως πότε ἔσομαι πρὸς ὑμᾶς καὶ ἀνέξομαι ὑμῶν; προσάγαγε ⸂ὧδε τὸν υἱόν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ἔτι δὲ προσερχομένου αὐτοῦ ἔρρηξεν αὐτὸν τὸ δαιμόνιον καὶ συνεσπάραξεν· ἐπετίμησεν δὲ ὁ Ἰησοῦς τῷ πνεύματι τῷ ἀκαθάρτῳ, καὶ ἰάσατο τὸν παῖδα καὶ ἀπέδωκεν αὐτὸν τῷ πατρὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ἐξεπλήσσοντο δὲ πάντες ἐπὶ τῇ μεγαλειότητι τοῦ θεοῦ. Πάντων δὲ θαυμαζόντων ἐπὶ πᾶσιν οἷς ⸀ἐποίει εἶπεν πρὸς τοὺς μαθητὰς αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Θέσθε ὑμεῖς εἰς τὰ ὦτα ὑμῶν τοὺς λόγους τούτους, ὁ γὰρ υἱὸς τοῦ ἀνθρώπου μέλλει παραδίδοσθαι εἰς χεῖρας ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","οἱ δὲ ἠγνόουν τὸ ῥῆμα τοῦτο, καὶ ἦν παρακεκαλυμμένον ἀπʼ αὐτῶν ἵνα μὴ αἴσθωνται αὐτό, καὶ ἐφοβοῦντο ἐρωτῆσαι αὐτὸν περὶ τοῦ ῥήματος τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Εἰσῆλθεν δὲ διαλογισμὸς ἐν αὐτοῖς, τὸ τίς ἂν εἴη μείζων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ὁ δὲ Ἰησοῦς ⸀εἰδὼςτὸν διαλογισμὸν τῆς καρδίας αὐτῶν ἐπιλαβόμενος ⸀παιδίονἔστησεν αὐτὸ παρʼ ἑαυτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","καὶ εἶπεν αὐτοῖς· Ὃς ⸀ἂνδέξηται τοῦτο τὸ παιδίον ἐπὶ τῷ ὀνόματί μου ἐμὲ δέχεται, καὶ ὃς ⸁ἂνἐμὲ δέξηται δέχεται τὸν ἀποστείλαντά με· ὁ γὰρ μικρότερος ἐν πᾶσιν ὑμῖν ὑπάρχων οὗτός ⸀ἐστινμέγας. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ἀποκριθεὶς ⸀δὲἸωάννης εἶπεν· Ἐπιστάτα, εἴδομέν τινα ⸀ἐντῷ ὀνόματί σου ἐκβάλλοντα δαιμόνια, καὶ ⸀ἐκωλύομεναὐτὸν ὅτι οὐκ ἀκολουθεῖ μεθʼ ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","⸂εἶπεν δὲ πρὸς αὐτὸν ⸀ὁἸησοῦς· Μὴ κωλύετε, ὃς γὰρ οὐκ ἔστιν καθʼ ⸂ὑμῶν ὑπὲρ ὑμῶν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ἐγένετο δὲ ἐν τῷ συμπληροῦσθαι τὰς ἡμέρας τῆς ἀναλήμψεως αὐτοῦ καὶ αὐτὸς τὸ ⸀πρόσωπον⸀ἐστήρισεντοῦ πορεύεσθαι εἰς Ἰερουσαλήμ, ");
INSERT INTO grcsbl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","καὶ ἀπέστειλεν ἀγγέλους πρὸ προσώπου αὐτοῦ. καὶ πορευθέντες εἰσῆλθον εἰς κώμην Σαμαριτῶν, ⸀ὡςἑτοιμάσαι αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","καὶ οὐκ ἐδέξαντο αὐτόν, ὅτι τὸ πρόσωπον αὐτοῦ ἦν πορευόμενον εἰς Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ἰδόντες δὲ οἱ ⸀μαθηταὶἸάκωβος καὶ Ἰωάννης εἶπαν· Κύριε, θέλεις εἴπωμεν πῦρ καταβῆναι ἀπὸ τοῦ οὐρανοῦ καὶ ἀναλῶσαι ⸀αὐτούς ");
INSERT INTO grcsbl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","στραφεὶς δὲ ἐπετίμησεν ⸀αὐτοῖς ");
INSERT INTO grcsbl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","⸀καὶἐπορεύθησαν εἰς ἑτέραν κώμην. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","⸀Καὶπορευομένων αὐτῶν ἐν τῇ ὁδῷ εἶπέν τις πρὸς αὐτόν· Ἀκολουθήσω σοι ὅπου ⸀ἐὰν⸀ἀπέρχῃ ");
INSERT INTO grcsbl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","καὶ εἶπεν αὐτῷ ὁ Ἰησοῦς· Αἱ ἀλώπεκες φωλεοὺς ἔχουσιν καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατασκηνώσεις, ὁ δὲ υἱὸς τοῦ ἀνθρώπου οὐκ ἔχει ποῦ τὴν κεφαλὴν κλίνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","εἶπεν δὲ πρὸς ἕτερον· Ἀκολούθει μοι. ὁ δὲ εἶπεν· ⸀Κύριε ἐπίτρεψόν μοι ⸂ἀπελθόντι πρῶτον θάψαι τὸν πατέρα μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","εἶπεν δὲ ⸀αὐτῷ Ἄφες τοὺς νεκροὺς θάψαι τοὺς ἑαυτῶν νεκρούς, σὺ δὲ ἀπελθὼν διάγγελλε τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","εἶπεν δὲ καὶ ἕτερος· Ἀκολουθήσω σοι, κύριε· πρῶτον δὲ ἐπίτρεψόν μοι ἀποτάξασθαι τοῖς εἰς τὸν οἶκόν μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","εἶπεν δὲ ⸂ὁ Ἰησοῦς· Οὐδεὶς ἐπιβαλὼν τὴν ⸀χεῖραἐπʼ ἄροτρον καὶ βλέπων εἰς τὰ ὀπίσω εὔθετός ἐστιν ⸂τῇ βασιλείᾳ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Μετὰ δὲ ταῦτα ἀνέδειξεν ὁ κύριος ⸀καὶἑτέρους ἑβδομήκοντα ⸀δύοκαὶ ἀπέστειλεν αὐτοὺς ἀνὰ δύο ⸁δύοπρὸ προσώπου αὐτοῦ εἰς πᾶσαν πόλιν καὶ τόπον οὗ ἤμελλεν αὐτὸς ἔρχεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ἔλεγεν ⸀δὲπρὸς αὐτούς· Ὁ μὲν θερισμὸς πολύς, οἱ δὲ ἐργάται ὀλίγοι· δεήθητε οὖν τοῦ κυρίου τοῦ θερισμοῦ ὅπως ⸂ἐργάτας ἐκβάλῃ εἰς τὸν θερισμὸν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ὑπάγετε· ⸀ἰδοὺἀποστέλλω ὑμᾶς ὡς ἄρνας ἐν μέσῳ λύκων. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","μὴβαστάζετε βαλλάντιον, μὴ πήραν, ⸀μὴ ὑποδήματα, καὶ μηδένα κατὰ τὴν ὁδὸν ἀσπάσησθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","εἰς ἣν δʼ ἂν ⸂εἰσέλθητε οἰκίαν πρῶτον λέγετε· Εἰρήνη τῷ οἴκῳ τούτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","καὶ ἐὰν ⸂ᾖ ἐκεῖ υἱὸς εἰρήνης, ἐπαναπαήσεται ἐπʼ αὐτὸν ἡ εἰρήνη ὑμῶν· εἰ δὲ μήγε, ἐφʼ ὑμᾶς ἀνακάμψει. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ἐν αὐτῇ δὲ τῇ οἰκίᾳ μένετε, ἐσθίοντες καὶ πίνοντες τὰ παρʼ αὐτῶν, ἄξιος γὰρ ὁ ἐργάτης τοῦ μισθοῦ ⸀αὐτοῦ μὴ μεταβαίνετε ἐξ οἰκίας εἰς οἰκίαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","καὶ εἰς ἣν ἂν πόλιν εἰσέρχησθε καὶ δέχωνται ὑμᾶς, ἐσθίετε τὰ παρατιθέμενα ὑμῖν, ");
INSERT INTO grcsbl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","καὶ θεραπεύετε τοὺς ἐν αὐτῇ ἀσθενεῖς, καὶ λέγετε αὐτοῖς· Ἤγγικεν ἐφʼ ὑμᾶς ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","εἰς ἣν δʼ ἂν πόλιν ⸀εἰσέλθητεκαὶ μὴ δέχωνται ὑμᾶς, ἐξελθόντες εἰς τὰς πλατείας αὐτῆς εἴπατε· ");
INSERT INTO grcsbl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Καὶ τὸν κονιορτὸν τὸν κολληθέντα ἡμῖν ἐκ τῆς πόλεως ὑμῶν ⸂εἰς τοὺς πόδας ἀπομασσόμεθα ὑμῖν· πλὴν τοῦτο γινώσκετε ὅτι ⸀ἤγγικενἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","λέγω ὑμῖν ὅτι Σοδόμοις ἐν τῇ ἡμέρᾳ ἐκείνῃ ἀνεκτότερον ἔσται ἢ τῇ πόλει ἐκείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Οὐαί σοι, Χοραζίν· οὐαί σοι, Βηθσαϊδά· ὅτι εἰ ἐν Τύρῳ καὶ Σιδῶνι ⸀ἐγενήθησαναἱ δυνάμεις αἱ γενόμεναι ἐν ὑμῖν, πάλαι ἂν ἐν σάκκῳ καὶ σποδῷ ⸀καθήμενοιμετενόησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","πλὴν Τύρῳ καὶ Σιδῶνι ἀνεκτότερον ἔσται ἐν τῇ κρίσει ἢ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","καὶ σύ, Καφαρναούμ, ⸂μὴ ἕως οὐρανοῦ ὑψωθήσῃ; ἕως ⸀τοῦᾅδου ⸀καταβιβασθήσῃ ");
INSERT INTO grcsbl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ὁ ἀκούων ὑμῶν ἐμοῦ ἀκούει, καὶ ὁ ἀθετῶν ὑμᾶς ἐμὲ ἀθετεῖ· ὁ δὲ ἐμὲ ἀθετῶν ἀθετεῖ τὸν ἀποστείλαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ὑπέστρεψαν δὲ οἱ ἑβδομήκοντα ⸀δύομετὰ χαρᾶς λέγοντες· Κύριε, καὶ τὰ δαιμόνια ὑποτάσσεται ἡμῖν ἐν τῷ ὀνόματί σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","εἶπεν δὲ αὐτοῖς· Ἐθεώρουν τὸν Σατανᾶν ὡς ἀστραπὴν ἐκ τοῦ οὐρανοῦ πεσόντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ἰδοὺ ⸀δέδωκαὑμῖν τὴν ἐξουσίαν τοῦ πατεῖν ἐπάνω ὄφεων καὶ σκορπίων, καὶ ἐπὶ πᾶσαν τὴν δύναμιν τοῦ ἐχθροῦ, καὶ οὐδὲν ὑμᾶς οὐ μὴ ⸀ἀδικήσῃ ");
INSERT INTO grcsbl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","πλὴν ἐν τούτῳ μὴ χαίρετε ὅτι τὰ πνεύματα ὑμῖν ὑποτάσσεται, χαίρετε δὲ ὅτι τὰ ὀνόματα ὑμῶν ⸀ἐγγέγραπταιἐν τοῖς οὐρανοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ἐν αὐτῇ τῇ ὥρᾳ ἠγαλλιάσατο ⸀τῷπνεύματι ⸂τῷ ἁγίῳ καὶ εἶπεν· Ἐξομολογοῦμαί σοι, πάτερ κύριε τοῦ οὐρανοῦ καὶ τῆς γῆς, ὅτι ἀπέκρυψας ταῦτα ἀπὸ σοφῶν καὶ συνετῶν, καὶ ἀπεκάλυψας αὐτὰ νηπίοις· ναί, ὁ πατήρ, ὅτι οὕτως ⸂εὐδοκία ἐγένετο ἔμπροσθέν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","⸀πάνταμοι παρεδόθη ὑπὸ τοῦ πατρός μου, καὶ οὐδεὶς γινώσκει τίς ἐστιν ὁ υἱὸς εἰ μὴ ὁ πατήρ, καὶ τίς ἐστιν ὁ πατὴρ εἰ μὴ ὁ υἱὸς καὶ ᾧ ⸀ἐὰνβούληται ὁ υἱὸς ἀποκαλύψαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Καὶ στραφεὶς πρὸς τοὺς μαθητὰς κατʼ ἰδίαν εἶπεν· Μακάριοι οἱ ὀφθαλμοὶ οἱ βλέποντες ἃ βλέπετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","λέγω γὰρ ὑμῖν ὅτι πολλοὶ προφῆται καὶ βασιλεῖς ἠθέλησαν ἰδεῖν ἃ ὑμεῖς βλέπετε καὶ οὐκ εἶδαν, καὶ ἀκοῦσαι ἃ ἀκούετε καὶ οὐκ ἤκουσαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Καὶ ἰδοὺ νομικός τις ἀνέστη ἐκπειράζων ⸀αὐτὸνλέγων· Διδάσκαλε, τί ποιήσας ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grcsbl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ὁ δὲ εἶπεν πρὸς αὐτόν· Ἐν τῷ νόμῳ τί γέγραπται; πῶς ἀναγινώσκεις; ");
INSERT INTO grcsbl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ὁ δὲ ἀποκριθεὶς εἶπεν· Ἀγαπήσεις κύριον τὸν θεόν σου ἐξ ὅλης ⸀τῆςκαρδίας σου καὶ ⸂ἐν ὅλῃ τῇ ψυχῇ σου καὶ ⸂ἐν ὅλῃ τῇ ἰσχύϊ σου καὶ ⸂ἐν ὅλῃ τῇ διανοίᾳ σου, καὶ τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","εἶπεν δὲ αὐτῷ· Ὀρθῶς ἀπεκρίθης· τοῦτο ποίει καὶ ζήσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ὁ δὲ θέλων ⸀δικαιῶσαιἑαυτὸν εἶπεν πρὸς τὸν Ἰησοῦν· Καὶ τίς ἐστίν μου πλησίον; ");
INSERT INTO grcsbl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ὑπολαβὼν ⸀δὲὁ Ἰησοῦς εἶπεν· Ἄνθρωπός τις κατέβαινεν ἀπὸ Ἰερουσαλὴμ εἰς Ἰεριχὼ καὶ λῃσταῖς περιέπεσεν, οἳ καὶ ἐκδύσαντες αὐτὸν καὶ πληγὰς ἐπιθέντες ἀπῆλθον ἀφέντες ⸀ἡμιθανῆ ");
INSERT INTO grcsbl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","κατὰ συγκυρίαν δὲ ἱερεύς τις κατέβαινεν ἐν τῇ ὁδῷ ἐκείνῃ, καὶ ἰδὼν αὐτὸν ἀντιπαρῆλθεν· ");
INSERT INTO grcsbl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ὁμοίως δὲ καὶ ⸀Λευίτηςκατὰ τὸν τόπον ἐλθὼν καὶ ἰδὼν ἀντιπαρῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Σαμαρίτης δέ τις ὁδεύων ἦλθεν κατʼ αὐτὸν καὶ ⸀ἰδὼνἐσπλαγχνίσθη, ");
INSERT INTO grcsbl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","καὶ προσελθὼν κατέδησεν τὰ τραύματα αὐτοῦ ἐπιχέων ἔλαιον καὶ οἶνον, ἐπιβιβάσας δὲ αὐτὸν ἐπὶ τὸ ἴδιον κτῆνος ἤγαγεν αὐτὸν εἰς πανδοχεῖον καὶ ἐπεμελήθη αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","καὶ ἐπὶ τὴν ⸀αὔριονἐκβαλὼν ⸂δύο δηνάρια ἔδωκεν τῷ πανδοχεῖ καὶ ⸀εἶπεν Ἐπιμελήθητι αὐτοῦ, καὶ ὅ τι ἂν προσδαπανήσῃς ἐγὼ ἐν τῷ ἐπανέρχεσθαί με ἀποδώσω σοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","⸀τίςτούτων τῶν τριῶν πλησίον δοκεῖ σοι γεγονέναι τοῦ ἐμπεσόντος εἰς τοὺς λῃστάς; ");
INSERT INTO grcsbl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ὁ δὲεἶπεν· Ὁ ποιήσας τὸ ἔλεος μετʼ αὐτοῦ. εἶπεν ⸀δὲ αὐτῷ ὁ Ἰησοῦς· Πορεύου καὶ σὺ ποίει ὁμοίως. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","⸂Ἐν δὲ τῷ πορεύεσθαι ⸀αὐτοὺςαὐτὸς εἰσῆλθεν εἰς κώμην τινά· γυνὴ δέ τις ὀνόματι Μάρθα ὑπεδέξατο ⸀αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","καὶ τῇδε ἦν ἀδελφὴ καλουμένη ⸀Μαριάμ ἣ καὶ ⸂παρακαθεσθεῖσα πρὸς τοὺς πόδας τοῦ ⸀Ἰησοῦἤκουεν τὸν λόγον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ἡ δὲ Μάρθα περιεσπᾶτο περὶ πολλὴν διακονίαν· ἐπιστᾶσα δὲ εἶπεν· Κύριε, οὐ μέλει σοι ὅτι ἡ ἀδελφή μου μόνην με ⸀κατέλειπενδιακονεῖν; ⸀εἰπὲοὖν αὐτῇ ἵνα μοι συναντιλάβηται. ");
INSERT INTO grcsbl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ἀποκριθεὶς δὲ εἶπεν αὐτῇ ὁ ⸀κύριος Μάρθα Μάρθα, μεριμνᾷς καὶ ⸀θορυβάζῃπερὶ πολλά, ");
INSERT INTO grcsbl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","⸂ὀλίγων δέ ἐστιν χρεία ἢ ἑνός· ⸂Μαριὰμ γὰρ τὴν ἀγαθὴν μερίδα ἐξελέξατο ἥτις οὐκ ἀφαιρεθήσεται ⸀αὐτῆς ");
INSERT INTO grcsbl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Καὶ ἐγένετο ἐν τῷ εἶναι αὐτὸν ἐν τόπῳ τινὶ προσευχόμενον, ὡς ἐπαύσατο, εἶπέν τις τῶν μαθητῶν αὐτοῦ πρὸς αὐτόν· Κύριε, δίδαξον ἡμᾶς προσεύχεσθαι, καθὼς καὶ Ἰωάννης ἐδίδαξεν τοὺς μαθητὰς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","εἶπεν δὲ αὐτοῖς· Ὅταν προσεύχησθε, λέγετε· ⸀Πάτερ ἁγιασθήτω τὸ ὄνομά σου ἐλθέτω ἡ βασιλεία ⸀σου· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","τὸν ἄρτον ἡμῶν τὸν ἐπιούσιον δίδου ἡμῖν τὸ καθʼ ἡμέραν· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","καὶ ἄφες ἡμῖν τὰς ἁμαρτίας ἡμῶν, καὶ γὰρ αὐτοὶ ἀφίομεν παντὶ ὀφείλοντι ἡμῖν· καὶ μὴ εἰσενέγκῃς ἡμᾶς εἰς ⸀πειρασμόν ");
INSERT INTO grcsbl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Καὶ εἶπεν πρὸς αὐτούς· Τίς ἐξ ὑμῶν ἕξει φίλον καὶ πορεύσεται πρὸς αὐτὸν μεσονυκτίου καὶ εἴπῃ αὐτῷ· Φίλε, χρῆσόν μοι τρεῖς ἄρτους, ");
INSERT INTO grcsbl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ἐπειδὴ φίλος ⸀μουπαρεγένετο ἐξ ὁδοῦ πρός με καὶ οὐκ ἔχω ὃ παραθήσω αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","κἀκεῖνος ἔσωθεν ἀποκριθεὶς εἴπῃ· Μή μοι κόπους πάρεχε· ἤδη ἡ θύρα κέκλεισται, καὶ τὰ παιδία μου μετʼ ἐμοῦ εἰς τὴν κοίτην εἰσίν· οὐ δύναμαι ἀναστὰς δοῦναί σοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","λέγω ὑμῖν, εἰ καὶ οὐ δώσει αὐτῷ ἀναστὰς διὰ τὸ εἶναι ⸂φίλον αὐτοῦ, διά γε τὴν ἀναίδειαν αὐτοῦ ἐγερθεὶς δώσει αὐτῷ ⸀ὅσωνχρῄζει. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Κἀγὼ ὑμῖν λέγω, αἰτεῖτε, καὶ δοθήσεται ὑμῖν· ζητεῖτε, καὶ εὑρήσετε· κρούετε, καὶ ἀνοιγήσεται ὑμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","πᾶς γὰρ ὁ αἰτῶν λαμβάνει, καὶ ὁ ζητῶν εὑρίσκει, καὶ τῷ κρούοντι ἀνοιγήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","τίνα δὲ ⸀ἐξὑμῶν τὸν πατέρα αἰτήσει ὁ ⸀υἱὸςἰχθύν, ⸀καὶἀντὶ ἰχθύος ὄφιν ⸂αὐτῷ ἐπιδώσει; ");
INSERT INTO grcsbl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ἢ καὶ ⸀αἰτήσειᾠόν, ⸀ἐπιδώσειαὐτῷ σκορπίον; ");
INSERT INTO grcsbl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","εἰ οὖν ὑμεῖς πονηροὶ ὑπάρχοντες οἴδατε δόματα ἀγαθὰ διδόναι τοῖς τέκνοις ὑμῶν, πόσῳ μᾶλλον ὁ πατὴρ ὁ ἐξ οὐρανοῦ δώσει πνεῦμα ἅγιον τοῖς αἰτοῦσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Καὶ ἦν ἐκβάλλων ⸀δαιμόνιονκωφόν· ἐγένετο δὲ τοῦ δαιμονίου ἐξελθόντος ἐλάλησεν ὁ κωφός. καὶ ἐθαύμασαν οἱ ὄχλοι· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","τινὲς δὲ ἐξ αὐτῶν εἶπον· Ἐν Βεελζεβοὺλ ⸀τῷἄρχοντι τῶν δαιμονίων ἐκβάλλει τὰ δαιμόνια· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ἕτεροι δὲ πειράζοντες σημεῖον ⸂ἐξ οὐρανοῦ ἐζήτουν παρʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","αὐτὸς δὲ εἰδὼς αὐτῶν τὰ διανοήματα εἶπεν αὐτοῖς· Πᾶσα βασιλεία ἐφʼ ἑαυτὴν διαμερισθεῖσα ἐρημοῦται, καὶ οἶκος ἐπὶ οἶκον πίπτει. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","εἰ δὲ καὶ ὁ Σατανᾶς ἐφʼ ἑαυτὸν διεμερίσθη, πῶς σταθήσεται ἡ βασιλεία αὐτοῦ; ὅτι λέγετε ἐν Βεελζεβοὺλ ἐκβάλλειν με τὰ δαιμόνια. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","εἰ δὲ ἐγὼ ἐν Βεελζεβοὺλ ἐκβάλλω τὰ δαιμόνια, οἱ υἱοὶ ὑμῶν ἐν τίνι ἐκβάλλουσιν; διὰ τοῦτο ⸂αὐτοὶ ὑμῶν κριταὶ ἔσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","εἰ δὲ ἐν δακτύλῳ ⸀θεοῦἐκβάλλω τὰ δαιμόνια, ἄρα ἔφθασεν ἐφʼ ὑμᾶς ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ὅταν ὁ ἰσχυρὸς καθωπλισμένος φυλάσσῃ τὴν ἑαυτοῦ αὐλήν, ἐν εἰρήνῃ ἐστὶν τὰ ὑπάρχοντα αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ἐπὰν ⸀δὲἰσχυρότερος ⸀αὐτοῦἐπελθὼν νικήσῃ αὐτόν, τὴν πανοπλίαν αὐτοῦ αἴρει ἐφʼ ᾗ ἐπεποίθει, καὶ τὰ σκῦλα αὐτοῦ διαδίδωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ὁ μὴ ὢν μετʼ ἐμοῦ κατʼ ἐμοῦ ἐστιν, καὶ ὁ μὴ συνάγων μετʼ ἐμοῦ σκορπίζει. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ὅταν τὸ ἀκάθαρτον πνεῦμα ἐξέλθῃ ἀπὸ τοῦ ἀνθρώπου, διέρχεται διʼ ἀνύδρων τόπων ζητοῦν ἀνάπαυσιν, καὶ μὴ ⸀εὑρίσκονλέγει· Ὑποστρέψω εἰς τὸν οἶκόν μου ὅθεν ἐξῆλθον· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","καὶ ἐλθὸν ⸀εὑρίσκεισεσαρωμένον καὶ κεκοσμημένον. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","τότε πορεύεται καὶ παραλαμβάνει ⸂ἕτερα πνεύματα πονηρότερα ἑαυτοῦ ἑπτά, καὶ ⸀εἰσελθόντακατοικεῖ ἐκεῖ, καὶ γίνεται τὰ ἔσχατα τοῦ ἀνθρώπου ἐκείνου χείρονα τῶν πρώτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ἐγένετο δὲ ἐν τῷ λέγειν αὐτὸν ταῦτα ἐπάρασά τις ⸂φωνὴν γυνὴ ἐκ τοῦ ὄχλου εἶπεν αὐτῷ· Μακαρία ἡ κοιλία ἡ βαστάσασά σε καὶ μαστοὶ οὓς ἐθήλασας· ");
INSERT INTO grcsbl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","αὐτὸς δὲ εἶπεν· ⸀Μενοῦνμακάριοι οἱ ἀκούοντες τὸν λόγον τοῦ θεοῦ καὶ ⸀φυλάσσοντες ");
INSERT INTO grcsbl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Τῶν δὲ ὄχλων ἐπαθροιζομένων ἤρξατο λέγειν· Ἡ γενεὰαὕτη ⸀γενεὰ πονηρά ἐστιν· σημεῖον ⸀ζητεῖ καὶ σημεῖον οὐ δοθήσεται αὐτῇ εἰ μὴ τὸ σημεῖον ⸀Ἰωνᾶ ");
INSERT INTO grcsbl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","καθὼς γὰρ ἐγένετο ⸀Ἰωνᾶς⸂τοῖς Νινευίταις σημεῖον, οὕτως ἔσται καὶ ὁ υἱὸς τοῦ ἀνθρώπου τῇ γενεᾷ ταύτῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","βασίλισσα νότου ἐγερθήσεται ἐν τῇ κρίσει μετὰ τῶν ἀνδρῶν τῆς γενεᾶς ταύτης καὶ κατακρινεῖ αὐτούς· ὅτι ἦλθεν ἐκ τῶν περάτων τῆς γῆς ἀκοῦσαι τὴν σοφίαν Σολομῶνος, καὶ ἰδοὺ πλεῖον Σολομῶνος ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ἄνδρες ⸀Νινευῖταιἀναστήσονται ἐν τῇ κρίσει μετὰ τῆς γενεᾶς ταύτης καὶ κατακρινοῦσιν αὐτήν· ὅτι μετενόησαν εἰς τὸ κήρυγμα Ἰωνᾶ, καὶ ἰδοὺ πλεῖον Ἰωνᾶ ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⸀Οὐδεὶςλύχνον ἅψας εἰς κρύπτην τίθησιν οὐδὲ ὑπὸ τὸν μόδιον ἀλλʼ ἐπὶ τὴν λυχνίαν, ἵνα οἱ εἰσπορευόμενοι τὸ ⸀φέγγοςβλέπωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ὁ λύχνος τοῦ σώματός ἐστιν ὁ ὀφθαλμός ⸀σου ⸀ὅτανὁ ὀφθαλμός σου ἁπλοῦς ᾖ, καὶ ὅλον τὸ σῶμά σου φωτεινόν ἐστιν· ἐπὰν δὲ πονηρὸς ᾖ, καὶ τὸ σῶμά σου σκοτεινόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","σκόπει οὖν μὴ τὸ φῶς τὸ ἐν σοὶ σκότος ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","εἰ οὖν τὸ σῶμά σου ὅλον φωτεινόν, μὴ ἔχον ⸂μέρος τι σκοτεινόν, ἔσται φωτεινὸν ὅλον ὡς ὅταν ὁ λύχνος τῇ ἀστραπῇ φωτίζῃ σε. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ἐν δὲ τῷ λαλῆσαι ⸀ἐρωτᾷαὐτὸν ⸀Φαρισαῖοςὅπως ἀριστήσῃ παρʼ αὐτῷ· εἰσελθὼν δὲ ἀνέπεσεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ὁ δὲ Φαρισαῖος ἰδὼν ἐθαύμασεν ὅτι οὐ πρῶτον ἐβαπτίσθη πρὸ τοῦ ἀρίστου. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","εἶπεν δὲ ὁ κύριος πρὸς αὐτόν· Νῦν ὑμεῖς οἱ Φαρισαῖοι τὸ ἔξωθεν τοῦ ποτηρίου καὶ τοῦ πίνακος καθαρίζετε, τὸ δὲ ἔσωθεν ὑμῶν γέμει ἁρπαγῆς καὶ πονηρίας. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ἄφρονες, οὐχ ὁ ποιήσας τὸ ἔξωθεν καὶ τὸ ἔσωθεν ἐποίησεν; ");
INSERT INTO grcsbl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","πλὴν τὰ ἐνόντα δότε ἐλεημοσύνην, καὶ ἰδοὺ πάντα καθαρὰ ὑμῖν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ἀλλὰ οὐαὶ ὑμῖν τοῖς Φαρισαίοις, ὅτι ἀποδεκατοῦτε τὸ ἡδύοσμον καὶ τὸ πήγανον καὶ πᾶν λάχανον, καὶ παρέρχεσθε τὴν κρίσιν καὶ τὴν ἀγάπην τοῦ θεοῦ· ταῦτα ⸀δὲἔδει ποιῆσαι κἀκεῖνα μὴ ⸀παρεῖναι ");
INSERT INTO grcsbl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","οὐαὶ ὑμῖν τοῖς Φαρισαίοις, ὅτι ἀγαπᾶτε τὴν πρωτοκαθεδρίαν ἐν ταῖς συναγωγαῖς καὶ τοὺς ἀσπασμοὺς ἐν ταῖς ἀγοραῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","οὐαὶ ⸀ὑμῖν ὅτι ἐστὲ ὡς τὰ μνημεῖα τὰ ἄδηλα, καὶ οἱἄνθρωποι ⸀οἱ περιπατοῦντες ἐπάνω οὐκ οἴδασιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ἀποκριθεὶς δέ τις τῶν νομικῶν λέγει αὐτῷ· Διδάσκαλε, ταῦτα λέγων καὶ ἡμᾶς ὑβρίζεις. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ὁ δὲ εἶπεν· Καὶ ὑμῖν τοῖς νομικοῖς οὐαί, ὅτι φορτίζετε τοὺς ἀνθρώπους φορτία δυσβάστακτα, καὶ αὐτοὶ ἑνὶ τῶν δακτύλων ὑμῶν οὐ προσψαύετε τοῖς φορτίοις. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","οὐαὶ ὑμῖν, ὅτι οἰκοδομεῖτε τὰ μνημεῖα τῶν προφητῶν οἱ δὲ πατέρες ὑμῶν ἀπέκτειναν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ἄρα ⸂μάρτυρές ἐστε καὶ συνευδοκεῖτε τοῖς ἔργοις τῶν πατέρων ὑμῶν, ὅτι αὐτοὶ μὲν ἀπέκτειναν αὐτοὺς ὑμεῖς δὲ ⸀οἰκοδομεῖτε ");
INSERT INTO grcsbl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","διὰ τοῦτο καὶ ἡ σοφία τοῦ θεοῦ εἶπεν· Ἀποστελῶ εἰς αὐτοὺς προφήτας καὶ ἀποστόλους, καὶ ἐξ αὐτῶν ἀποκτενοῦσιν καὶ ⸀διώξουσιν ");
INSERT INTO grcsbl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ἵνα ἐκζητηθῇ τὸ αἷμα πάντων τῶν προφητῶν τὸ ἐκκεχυμένον ἀπὸ καταβολῆς κόσμου ἀπὸ τῆς γενεᾶς ταύτης, ");
INSERT INTO grcsbl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","⸀ἀπὸαἵματος Ἅβελ ⸀ἕωςαἵματος Ζαχαρίου τοῦ ἀπολομένου μεταξὺ τοῦ θυσιαστηρίου καὶ τοῦ οἴκου· ναί, λέγω ὑμῖν, ἐκζητηθήσεται ἀπὸ τῆς γενεᾶς ταύτης. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","οὐαὶ ὑμῖν τοῖς νομικοῖς, ὅτι ἤρατε τὴν κλεῖδα τῆς γνώσεως· αὐτοὶ οὐκ εἰσήλθατε καὶ τοὺς εἰσερχομένους ἐκωλύσατε. ");
INSERT INTO grcsbl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","⸂Κἀκεῖθεν ἐξελθόντος αὐτοῦ ἤρξαντο οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι δεινῶς ἐνέχειν καὶ ἀποστοματίζειν αὐτὸν περὶ πλειόνων, ");
INSERT INTO grcsbl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ἐνεδρεύοντες ⸀αὐτὸνθηρεῦσαί τι ἐκ τοῦ στόματος ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ἐν οἷς ἐπισυναχθεισῶν τῶν μυριάδων τοῦ ὄχλου, ὥστε καταπατεῖν ἀλλήλους, ἤρξατο λέγειν πρὸς τοὺς μαθητὰς αὐτοῦ πρῶτον· Προσέχετε ἑαυτοῖς ἀπὸ τῆς ζύμης, ⸂ἥτις ἐστὶν ὑπόκρισις, τῶν Φαρισαίων⸃. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","οὐδὲν δὲ συγκεκαλυμμένον ἐστὶν ὃ οὐκ ἀποκαλυφθήσεται, καὶ κρυπτὸν ὃ οὐ γνωσθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ἀνθʼ ὧν ὅσα ἐν τῇ σκοτίᾳ εἴπατε ἐν τῷ φωτὶ ἀκουσθήσεται, καὶ ὃ πρὸς τὸ οὖς ἐλαλήσατε ἐν τοῖς ταμείοις κηρυχθήσεται ἐπὶ τῶν δωμάτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Λέγω δὲ ὑμῖν τοῖς φίλοις μου, μὴ φοβηθῆτε ἀπὸ τῶν ἀποκτεινόντων τὸ σῶμα καὶ μετὰ ταῦτα μὴ ἐχόντων περισσότερόν τι ποιῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ὑποδείξω δὲ ὑμῖν τίνα φοβηθῆτε· φοβήθητε τὸν μετὰ τὸ ἀποκτεῖναι ⸂ἔχοντα ἐξουσίαν ἐμβαλεῖν εἰς τὴν γέενναν· ναί, λέγω ὑμῖν, τοῦτον φοβήθητε. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","οὐχὶ πέντε στρουθία ⸀πωλοῦνταιἀσσαρίων δύο; καὶ ἓν ἐξ αὐτῶν οὐκ ἔστιν ἐπιλελησμένον ἐνώπιον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ἀλλὰ καὶ αἱ τρίχες τῆς κεφαλῆς ὑμῶν πᾶσαι ἠρίθμηνται· ⸀μὴφοβεῖσθε· πολλῶν στρουθίων διαφέρετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Λέγω δὲ ὑμῖν, πᾶς ὃς ἂν ⸀ὁμολογήσῃἐν ἐμοὶ ἔμπροσθεν τῶν ἀνθρώπων, καὶ ὁ υἱὸς τοῦ ἀνθρώπου ὁμολογήσει ἐν αὐτῷ ἔμπροσθεν τῶν ἀγγέλων τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ὁ δὲ ἀρνησάμενός με ἐνώπιον τῶν ἀνθρώπων ἀπαρνηθήσεται ἐνώπιον τῶν ἀγγέλων τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","καὶ πᾶς ὃς ἐρεῖ λόγον εἰς τὸν υἱὸν τοῦ ἀνθρώπου, ἀφεθήσεται αὐτῷ τῷ δὲ εἰς τὸ ἅγιον πνεῦμα βλασφημήσαντι οὐκ ἀφεθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ὅταν δὲ ⸀εἰσφέρωσινὑμᾶς ἐπὶ τὰς συναγωγὰς καὶ τὰς ἀρχὰς καὶ τὰς ἐξουσίας, μὴ ⸀μεριμνήσητεπῶς ⸂ἢ τί ἀπολογήσησθε ἢ τί εἴπητε· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","τὸ γὰρ ἅγιον πνεῦμα διδάξει ὑμᾶς ἐν αὐτῇ τῇ ὥρᾳ ἃ δεῖ εἰπεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Εἶπεν δέ τις ⸂ἐκ τοῦ ὄχλου αὐτῷ· Διδάσκαλε, εἰπὲ τῷ ἀδελφῷ μου μερίσασθαι μετʼ ἐμοῦ τὴν κληρονομίαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ὁ δὲ εἶπεν αὐτῷ· Ἄνθρωπε, τίς με κατέστησεν ⸀κριτὴνἢ μεριστὴν ἐφʼ ὑμᾶς; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","εἶπεν δὲ πρὸς αὐτούς· Ὁρᾶτε καὶ φυλάσσεσθε ἀπὸ ⸀πάσηςπλεονεξίας, ὅτι οὐκ ἐν τῷ περισσεύειν τινὶ ἡ ζωὴ ⸀αὐτοῦἐστιν ἐκ τῶν ὑπαρχόντων ⸀αὐτῷ ");
INSERT INTO grcsbl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","εἶπεν δὲ παραβολὴν πρὸς αὐτοὺς λέγων· Ἀνθρώπου τινὸς πλουσίου εὐφόρησεν ἡ χώρα. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","καὶ διελογίζετο ἐν ⸀ἑαυτῷλέγων· Τί ποιήσω, ὅτι οὐκ ἔχω ποῦ συνάξω τοὺς καρπούς μου; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","καὶ εἶπεν· Τοῦτο ποιήσω· καθελῶ μου τὰς ἀποθήκας καὶ μείζονας οἰκοδομήσω, καὶ συνάξω ἐκεῖ πάντα ⸂τὸν σῖτον καὶ τὰ ἀγαθά μου, ");
INSERT INTO grcsbl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","καὶ ἐρῶ τῇ ψυχῇ μου· Ψυχή, ἔχεις πολλὰ ἀγαθὰ κείμενα εἰς ἔτη πολλά· ἀναπαύου, φάγε, πίε, εὐφραίνου. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","εἶπεν δὲ αὐτῷ ὁ θεός· ⸀Ἄφρων ταύτῃ τῇ νυκτὶ τὴν ψυχήν σου ⸀ἀπαιτοῦσινἀπὸ σοῦ· ἃ δὲ ἡτοίμασας, τίνι ἔσται; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","οὕτως ὁ θησαυρίζων ⸀ἑαυτῷκαὶ μὴ εἰς θεὸν πλουτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Εἶπεν δὲ πρὸς τοὺς μαθητὰς αὐτοῦ· Διὰ τοῦτο ⸂λέγω ὑμῖν, μὴ μεριμνᾶτε τῇ ⸀ψυχῇτί φάγητε, μηδὲ τῷ ⸀σώματιτί ἐνδύσησθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ἡ ⸀γὰρψυχὴ πλεῖόν ἐστιν τῆς τροφῆς καὶ τὸ σῶμα τοῦ ἐνδύματος. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","κατανοήσατε τοὺς κόρακας ὅτι οὐ σπείρουσιν οὐδὲ θερίζουσιν, οἷς οὐκ ἔστιν ταμεῖον οὐδὲ ἀποθήκη, καὶ ὁ θεὸς τρέφει αὐτούς· πόσῳ μᾶλλον ὑμεῖς διαφέρετε τῶν πετεινῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","τίς δὲ ἐξ ὑμῶν μεριμνῶν δύναται ⸂ἐπὶ τὴν ἡλικίαν αὐτοῦ προσθεῖναι ⸀πῆχυν ");
INSERT INTO grcsbl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","εἰ οὖν ⸀οὐδὲἐλάχιστον δύνασθε, τί περὶ τῶν λοιπῶν μεριμνᾶτε; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","κατανοήσατε τὰ κρίνα πῶς αὐξάνει· οὐ κοπιᾷ οὐδὲ νήθει· λέγω δὲ ὑμῖν, οὐδὲ Σολομὼν ἐν πάσῃ τῇ δόξῃ αὐτοῦ περιεβάλετο ὡς ἓν τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","εἰ δὲ ⸂ἐν ἀγρῷ τὸν χόρτον ὄντα σήμερον καὶ αὔριον εἰς κλίβανον βαλλόμενον ὁ θεὸς οὕτως ⸀ἀμφιέζει πόσῳ μᾶλλον ὑμᾶς, ὀλιγόπιστοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","καὶὑμεῖς μὴ ζητεῖτε τί φάγητε ⸀καὶ τί πίητε, καὶ μὴ μετεωρίζεσθε, ");
INSERT INTO grcsbl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ταῦτα γὰρ πάντα τὰ ἔθνη τοῦ κόσμου ⸀ἐπιζητοῦσιν ὑμῶν δὲ ὁ πατὴρ οἶδεν ὅτι χρῄζετε τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","πλὴν ζητεῖτε τὴν βασιλείαν ⸀αὐτοῦ καὶ ⸀ταῦταπροστεθήσεται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Μὴ φοβοῦ, τὸ μικρὸν ποίμνιον, ὅτι εὐδόκησεν ὁ πατὴρ ὑμῶν δοῦναι ὑμῖν τὴν βασιλείαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","πωλήσατε τὰ ὑπάρχοντα ὑμῶν καὶ δότε ἐλεημοσύνην· ποιήσατε ἑαυτοῖς βαλλάντια μὴ παλαιούμενα, θησαυρὸν ἀνέκλειπτον ἐν τοῖς οὐρανοῖς, ὅπου κλέπτης οὐκ ἐγγίζει οὐδὲ σὴς διαφθείρει· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ὅπου γάρ ἐστιν ὁ θησαυρὸς ὑμῶν, ἐκεῖ καὶ ἡ καρδία ὑμῶν ἔσται. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ἔστωσαν ὑμῶν αἱ ὀσφύες περιεζωσμέναι καὶ οἱ λύχνοι καιόμενοι, ");
INSERT INTO grcsbl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","καὶ ὑμεῖς ὅμοιοι ἀνθρώποις προσδεχομένοις τὸν κύριον ἑαυτῶν πότε ἀναλύσῃ ἐκ τῶν γάμων, ἵνα ἐλθόντος καὶ κρούσαντος εὐθέως ἀνοίξωσιν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","μακάριοι οἱ δοῦλοι ἐκεῖνοι, οὓς ἐλθὼν ὁ κύριος εὑρήσει γρηγοροῦντας· ἀμὴν λέγω ὑμῖν ὅτι περιζώσεται καὶ ἀνακλινεῖ αὐτοὺς καὶ παρελθὼν διακονήσει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","⸂κἂν ἐν τῇ δευτέρᾳ κἂν ἐν τῇ τρίτῃ φυλακῇ ἔλθῃ καὶ εὕρῃ οὕτως, μακάριοί ⸀εἰσινἐκεῖνοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Τοῦτο δὲ γινώσκετε ὅτι εἰ ᾔδει ὁ οἰκοδεσπότης ποίᾳ ὥρᾳ ὁ κλέπτης ἔρχεται, ⸂οὐκ ἂν ἀφῆκεν ⸀διορυχθῆναιτὸν οἶκον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","καὶ ⸀ὑμεῖςγίνεσθε ἕτοιμοι, ὅτι ᾗ ὥρᾳ οὐ δοκεῖτε ὁ υἱὸς τοῦ ἀνθρώπου ἔρχεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Εἶπεν ⸀δὲὁ Πέτρος· Κύριε, πρὸς ἡμᾶς τὴν παραβολὴν ταύτην λέγεις ἢ καὶ πρὸς πάντας; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","⸂καὶ εἶπεν ὁ κύριος· Τίς ἄρα ἐστὶν ὁ πιστὸ οἰκονόμος, ⸀ὁ φρόνιμος, ὃν καταστήσει ὁ κύριος ἐπὶ τῆς θεραπείας αὐτοῦ τοῦ διδόναι ἐν καιρῷ ⸀τὸ σιτομέτριον; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","μακάριος ὁ δοῦλος ἐκεῖνος, ὃν ἐλθὼν ὁ κύριος αὐτοῦ εὑρήσει ποιοῦντα οὕτως· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ἀληθῶς λέγω ὑμῖν ὅτι ἐπὶ πᾶσιν τοῖς ὑπάρχουσιν αὐτοῦ καταστήσει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ἐὰν δὲ εἴπῃ ὁ δοῦλος ἐκεῖνος ἐν τῇ καρδίᾳ αὐτοῦ· Χρονίζει ὁ κύριός μου ἔρχεσθαι, καὶ ἄρξηται τύπτειν τοὺς παῖδας καὶ τὰς παιδίσκας, ἐσθίειν τε καὶ πίνειν καὶ μεθύσκεσθαι, ");
INSERT INTO grcsbl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ἥξει ὁ κύριος τοῦ δούλου ἐκείνου ἐν ἡμέρᾳ ᾗ οὐ προσδοκᾷ καὶ ἐν ὥρᾳ ᾗ οὐ γινώσκει, καὶ διχοτομήσει αὐτὸν καὶ τὸ μέρος αὐτοῦ μετὰ τῶν ἀπίστων θήσει. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ἐκεῖνος δὲ ὁ δοῦλος ὁ γνοὺς τὸ θέλημα τοῦ κυρίου ⸀αὐτοῦκαὶ μὴ ἑτοιμάσας ⸀ἢποιήσας πρὸς τὸ θέλημα αὐτοῦ δαρήσεται πολλάς· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ὁ δὲ μὴ γνοὺς ποιήσας δὲ ἄξια πληγῶν δαρήσεται ὀλίγας. παντὶ δὲ ᾧ ἐδόθη πολύ, πολὺ ζητηθήσεται παρʼ αὐτοῦ, καὶ ᾧ παρέθεντο πολύ, περισσότερον αἰτήσουσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Πῦρ ἦλθον βαλεῖν ⸀ἐπὶτὴν γῆν, καὶ τί θέλω εἰ ἤδη ἀνήφθη; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","βάπτισμα δὲ ἔχω βαπτισθῆναι, καὶ πῶς συνέχομαι ἕως ⸀ὅτουτελεσθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","δοκεῖτε ὅτι εἰρήνην παρεγενόμην δοῦναι ἐν τῇ γῇ; οὐχί, λέγω ὑμῖν, ἀλλʼ ἢ διαμερισμόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ἔσονται γὰρ ἀπὸ τοῦ νῦν πέντε ἐν ⸂ἑνὶ οἴκῳ διαμεμερισμένοι, τρεῖς ἐπὶ δυσὶν καὶ δύο ἐπὶ τρισίν, ");
INSERT INTO grcsbl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","⸀διαμερισθήσονταιπατὴρ ἐπὶυἱῷ καὶ υἱὸς ἐπὶ πατρί, μήτηρ ⸀ἐπὶ ⸀θυγατέρακαὶ θυγάτηρ ἐπὶ ⸂τὴν μητέρα, πενθερὰ ἐπὶ τὴν νύμφην αὐτῆς καὶ νύμφη ἐπὶ τὴν ⸀πενθεράν ");
INSERT INTO grcsbl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ἔλεγεν δὲ καὶ τοῖς ὄχλοις· Ὅταν ⸀ἴδητενεφέλην ἀνατέλλουσαν ⸀ἐπὶδυσμῶν, εὐθέως λέγετε ⸀ὅτιὌμβρος ἔρχεται, καὶ γίνεται οὕτως· ");
INSERT INTO grcsbl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","καὶ ὅταν νότον πνέοντα, λέγετε ὅτι Καύσων ἔσται, καὶ γίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ὑποκριταί, τὸ πρόσωπον τῆς γῆς καὶ τοῦ οὐρανοῦ οἴδατε δοκιμάζειν, τὸν ⸂δὲ καιρὸν τοῦτον πῶς ⸂οὐκ οἴδατε δοκιμάζειν; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Τί δὲ καὶ ἀφʼ ἑαυτῶν οὐ κρίνετε τὸ δίκαιον; ");
INSERT INTO grcsbl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ὡς γὰρ ὑπάγεις μετὰ τοῦ ἀντιδίκου σου ἐπʼ ἄρχοντα, ἐν τῇ ὁδῷ δὸς ἐργασίαν ἀπηλλάχθαι ἀπʼ αὐτοῦ, μήποτε κατασύρῃ σε πρὸς τὸν κριτήν, καὶ ὁ κριτής σε ⸀παραδώσειτῷ πράκτορι, καὶ ὁ πράκτωρ σε ⸀βαλεῖεἰς φυλακήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","λέγω σοι, οὐ μὴ ἐξέλθῃς ἐκεῖθεν ἕως ⸂καὶ τὸ ἔσχατον λεπτὸν ἀποδῷς. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Παρῆσαν δέ τινες ἐν αὐτῷ τῷ καιρῷ ἀπαγγέλλοντες αὐτῷ περὶ τῶν Γαλιλαίων ὧν τὸ αἷμα Πιλᾶτος ἔμιξεν μετὰ τῶν θυσιῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","καὶ ⸀ἀποκριθεὶςεἶπεν αὐτοῖς· Δοκεῖτε ὅτι οἱ Γαλιλαῖοι οὗτοι ἁμαρτωλοὶ παρὰ πάντας τοὺς Γαλιλαίους ἐγένοντο, ὅτι ⸀ταῦταπεπόνθασιν; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","οὐχί, λέγω ὑμῖν, ἀλλʼ ἐὰν μὴ μετανοῆτε πάντες ⸀ὁμοίωςἀπολεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ἢ ἐκεῖνοι οἱ ⸀δεκαοκτὼἐφʼ οὓς ἔπεσεν ὁ πύργος ἐν τῷ Σιλωὰμ καὶ ἀπέκτεινεν αὐτούς, δοκεῖτε ὅτι ⸀αὐτοὶὀφειλέται ἐγένοντο παρὰ πάντας ⸀τοὺςἀνθρώπους τοὺς ⸀κατοικοῦνταςἸερουσαλήμ; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","οὐχί, λέγω ὑμῖν, ἀλλʼ ἐὰν μὴ ⸀μετανοῆτεπάντες ⸀ὡσαύτωςἀπολεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ἔλεγεν δὲ ταύτην τὴν παραβολήν. Συκῆν εἶχέν τις ⸂πεφυτευμένην ἐν τῷ ἀμπελῶνι αὐτοῦ, καὶ ἦλθεν ζητῶν καρπὸν ἐν αὐτῇ καὶ οὐχ εὗρεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","εἶπεν δὲ πρὸς τὸν ἀμπελουργόν· Ἰδοὺ τρία ἔτη ⸂ἀφʼ οὗ ἔρχομαι ζητῶν καρπὸν ἐν τῇ συκῇ ταύτῃ καὶ οὐχ εὑρίσκω· ⸀ἔκκοψοναὐτήν· ἱνατί καὶ τὴν γῆν καταργεῖ; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ὁ δὲ ἀποκριθεὶς λέγει αὐτῷ· Κύριε, ἄφες αὐτὴν καὶ τοῦτο τὸ ἔτος, ἕως ὅτου σκάψω περὶ αὐτὴν καὶ βάλω κόπρια· ");
INSERT INTO grcsbl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","κἂν μὲν ποιήσῃ καρπὸν ⸂εἰς τὸ μέλλον— εἰ δὲ μήγε,⸃ ἐκκόψεις αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ἦν δὲ διδάσκων ἐν μιᾷ τῶν συναγωγῶν ἐν τοῖς σάββασιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","καὶ ἰδοὺ ⸀γυνὴπνεῦμα ἔχουσα ἀσθενείας ἔτη ⸀δεκαοκτώ καὶ ἦν συγκύπτουσα καὶ μὴ δυναμένη ἀνακύψαι εἰς τὸ παντελές. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ἰδὼν δὲ αὐτὴν ὁ Ἰησοῦς προσεφώνησεν καὶ εἶπεν αὐτῇ· Γύναι, ἀπολέλυσαι τῆς ἀσθενείας σου, ");
INSERT INTO grcsbl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","καὶ ἐπέθηκεν αὐτῇ τὰς χεῖρας· καὶ παραχρῆμα ἀνωρθώθη, καὶ ἐδόξαζεν τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ἀποκριθεὶς δὲ ὁ ἀρχισυνάγωγος, ἀγανακτῶν ὅτιτῷ σαββάτῳ ἐθεράπευσεν ὁ Ἰησοῦς, ἔλεγεν τῷ ὄχλῳ ⸀ὅτι Ἓξ ἡμέραι εἰσὶν ἐν αἷς δεῖ ἐργάζεσθαι· ἐν ⸀αὐταῖςοὖν ἐρχόμενοι θεραπεύεσθε καὶ μὴ τῇ ἡμέρᾳ τοῦ σαββάτου. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ἀπεκρίθη ⸀δὲαὐτῷ ὁ κύριος καὶ εἶπεν· Ὑποκριταί, ἕκαστος ὑμῶν τῷ σαββάτῳ οὐ λύει τὸν βοῦν αὐτοῦ ἢ τὸν ὄνον ἀπὸ τῆς φάτνης καὶ ⸀ἀπαγαγὼνποτίζει; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ταύτην δὲ θυγατέρα Ἀβραὰμ οὖσαν, ἣν ἔδησεν ὁ Σατανᾶς ἰδοὺ δέκα καὶ ὀκτὼ ἔτη, οὐκ ἔδει λυθῆναι ἀπὸ τοῦ δεσμοῦ τούτου τῇ ἡμέρᾳ τοῦ σαββάτου; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","καὶ ταῦτα λέγοντος αὐτοῦ κατῃσχύνοντο πάντες οἱ ἀντικείμενοι αὐτῷ, καὶ πᾶς ὁ ὄχλος ἔχαιρεν ἐπὶ πᾶσιν τοῖς ἐνδόξοις τοῖς γινομένοις ὑπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ἔλεγεν ⸀οὖν Τίνι ὁμοία ἐστὶν ἡ βασιλεία τοῦ θεοῦ, καὶ τίνι ὁμοιώσω αὐτήν; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ὁμοία ἐστὶν κόκκῳ σινάπεως, ὃν λαβὼν ἄνθρωπος ἔβαλεν εἰς κῆπον ἑαυτοῦ, καὶ ηὔξησεν καὶ ἐγένετο εἰς ⸀δένδρον καὶ τὰ πετεινὰ τοῦ οὐρανοῦ κατεσκήνωσεν ἐν τοῖς κλάδοις αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","⸀Καὶπάλιν εἶπεν· Τίνι ὁμοιώσω τὴν βασιλείαν τοῦ θεοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ὁμοία ἐστὶν ζύμῃ, ἣν λαβοῦσα γυνὴ ⸀ἔκρυψενεἰς ἀλεύρου σάτα τρία ἕως οὗ ἐζυμώθη ὅλον. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Καὶ διεπορεύετο κατὰ πόλεις καὶ κώμας διδάσκων καὶ πορείαν ποιούμενος εἰς ⸀Ἱεροσόλυμα ");
INSERT INTO grcsbl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","εἶπεν δέ τις αὐτῷ· Κύριε, εἰ ὀλίγοι οἱ σῳζόμενοι; ὁ δὲ εἶπεν πρὸς αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ἀγωνίζεσθε εἰσελθεῖν διὰ τῆς στενῆς ⸀θύρας ὅτι πολλοί, λέγω ὑμῖν, ζητήσουσιν εἰσελθεῖν καὶ οὐκ ἰσχύσουσιν, ");
INSERT INTO grcsbl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ἀφʼ οὗ ἂν ἐγερθῇ ὁ οἰκοδεσπότης καὶ ἀποκλείσῃ τὴν θύραν, καὶ ἄρξησθε ἔξω ἑστάναι καὶ κρούειν τὴν θύραν λέγοντες· ⸀Κύριε ἄνοιξον ἡμῖν· καὶ ἀποκριθεὶς ἐρεῖ ὑμῖν· Οὐκ οἶδα ὑμᾶς πόθεν ἐστέ. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","τότε ἄρξεσθε λέγειν· Ἐφάγομεν ἐνώπιόν σου καὶ ἐπίομεν, καὶ ἐν ταῖς πλατείαις ἡμῶν ἐδίδαξας· ");
INSERT INTO grcsbl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","καὶ ἐρεῖ ⸀λέγωνὑμῖν· Οὐκ ⸀οἶδαπόθεν ἐστέ· ἀπόστητε ἀπʼ ἐμοῦ, πάντες ⸀ἐργάταιἀδικίας. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ἐκεῖ ἔσται ὁ κλαυθμὸς καὶ ὁ βρυγμὸς τῶν ὀδόντων, ὅταν ⸀ὄψησθεἈβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ καὶ πάντας τοὺς προφήτας ἐν τῇ βασιλείᾳ τοῦ θεοῦ, ὑμᾶς δὲ ἐκβαλλομένους ἔξω. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","καὶ ἥξουσιν ἀπὸἀνατολῶν καὶ δυσμῶν καὶ ⸀ἀπὸ βορρᾶ καὶ νότου καὶ ἀνακλιθήσονται ἐν τῇ βασιλείᾳ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","καὶ ἰδοὺ εἰσὶν ἔσχατοι οἳ ἔσονται πρῶτοι, καὶ εἰσὶν πρῶτοι οἳ ἔσονται ἔσχατοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ἐν αὐτῇ τῇ ⸀ὥρᾳπροσῆλθάν τινες Φαρισαῖοι λέγοντες αὐτῷ· Ἔξελθε καὶ πορεύου ἐντεῦθεν, ὅτι Ἡρῴδης θέλει σε ἀποκτεῖναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","καὶ εἶπεν αὐτοῖς· Πορευθέντες εἴπατε τῇ ἀλώπεκι ταύτῃ· Ἰδοὺ ἐκβάλλω δαιμόνια καὶ ἰάσεις ⸀ἀποτελῶσήμερον καὶ αὔριον, καὶ τῇ τρίτῃ τελειοῦμαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","πλὴν δεῖ με σήμερον καὶ αὔριον καὶ τῇ ἐχομένῃ πορεύεσθαι, ὅτι οὐκ ἐνδέχεται προφήτην ἀπολέσθαι ἔξω Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ἰερουσαλὴμ Ἰερουσαλήμ, ἡ ἀποκτείνουσα τοὺς προφήτας καὶ λιθοβολοῦσα τοὺς ἀπεσταλμένους πρὸς αὐτήν— ποσάκις ἠθέλησα ἐπισυνάξαι τὰ τέκνα σου ὃν τρόπον ὄρνις τὴν ἑαυτῆς νοσσιὰν ὑπὸ τὰς πτέρυγας, καὶ οὐκ ἠθελήσατε. ");
INSERT INTO grcsbl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ἰδοὺ ἀφίεται ὑμῖν ὁ οἶκος ⸀ὑμῶν λέγω ⸀δὲ⸀ὑμῖν οὐ μὴ ⸂ἴδητέ με ἕως ⸂ἥξει ὅτε εἴπητε· Εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Καὶ ἐγένετο ἐν τῷ ἐλθεῖν αὐτὸν εἰς οἶκόν τινος τῶν ἀρχόντων τῶν Φαρισαίων σαββάτῳ φαγεῖν ἄρτον καὶ αὐτοὶ ἦσαν παρατηρούμενοι αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","καὶ ἰδοὺ ἄνθρωπός τις ἦν ὑδρωπικὸς ἔμπροσθεν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","καὶ ἀποκριθεὶς ὁ Ἰησοῦς εἶπεν πρὸς τοὺς νομικοὺς καὶ Φαρισαίους λέγων· ⸀Ἔξεστιντῷ σαββάτῳ ⸂θεραπεῦσαι ἢ οὔ; ");
INSERT INTO grcsbl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","οἱ δὲ ἡσύχασαν. καὶ ἐπιλαβόμενος ἰάσατο αὐτὸν καὶ ἀπέλυσεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","⸀καὶπρὸς αὐτοὺς εἶπεν· Τίνος ὑμῶν υἱὸς ἢ βοῦς εἰς φρέαρ ⸀πεσεῖται καὶ οὐκ εὐθέως ἀνασπάσει αὐτὸν ⸀ἐνἡμέρᾳ τοῦ σαββάτου; ");
INSERT INTO grcsbl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","καὶ οὐκ ἴσχυσαν ⸀ἀνταποκριθῆναιπρὸς ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ἔλεγεν δὲ πρὸς τοὺς κεκλημένους παραβολήν, ἐπέχων πῶς τὰς πρωτοκλισίας ἐξελέγοντο, λέγων πρὸς αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ὅταν κληθῇς ὑπό τινος εἰς γάμους, μὴ κατακλιθῇς εἰς τὴν πρωτοκλισίαν, μήποτε ἐντιμότερός σου ᾖ κεκλημένος ὑπʼ αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","καὶ ἐλθὼν ὁ σὲ καὶ αὐτὸν καλέσας ἐρεῖ σοι· Δὸς τούτῳ τόπον, καὶ τότε ἄρξῃ μετὰ αἰσχύνης τὸν ἔσχατον τόπον κατέχειν. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ἀλλʼ ὅταν κληθῇς πορευθεὶς ἀνάπεσε εἰς τὸν ἔσχατον τόπον, ἵνα ὅταν ἔλθῃ ὁ κεκληκώς σε ⸀ἐρεῖσοι· Φίλε, προσανάβηθι ἀνώτερον· τότε ἔσται σοι δόξα ἐνώπιον ⸀πάντωντῶν συνανακειμένων σοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ὅτι πᾶς ὁ ὑψῶν ἑαυτὸν ταπεινωθήσεται καὶ ὁ ταπεινῶν ἑαυτὸν ὑψωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ἔλεγεν δὲ καὶ τῷ κεκληκότι αὐτόν· Ὅταν ποιῇς ἄριστον ἢ δεῖπνον, μὴ φώνει τοὺς φίλους σου μηδὲ τοὺς ἀδελφούς σου μηδὲ τοὺς συγγενεῖς σου μηδὲ γείτονας πλουσίους, μήποτε καὶ αὐτοὶ ⸂ἀντικαλέσωσίν σε καὶ γένηται ⸂ἀνταπόδομά σοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ἀλλʼ ὅταν ⸂δοχὴν ποιῇς, κάλει πτωχούς, ἀναπείρους, χωλούς, τυφλούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","καὶ μακάριος ἔσῃ, ὅτι οὐκ ἔχουσιν ἀνταποδοῦναί σοι, ἀνταποδοθήσεται γάρ σοι ἐν τῇ ἀναστάσει τῶν δικαίων. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ἀκούσας δέ τις τῶν συνανακειμένων ταῦτα εἶπεν αὐτῷ· Μακάριος ⸀ὅστιςφάγεται ⸀ἄρτονἐν τῇ βασιλείᾳ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ὁ δὲ εἶπεν αὐτῷ· Ἄνθρωπός τις ⸀ἐποίειδεῖπνον μέγα, καὶ ἐκάλεσεν πολλούς, ");
INSERT INTO grcsbl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","καὶ ἀπέστειλεν τὸν δοῦλον αὐτοῦ τῇ ὥρᾳ τοῦ δείπνου εἰπεῖν τοῖς κεκλημένοις· Ἔρχεσθε, ὅτι ἤδη ἕτοιμά ⸀ἐστιν ");
INSERT INTO grcsbl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","καὶ ἤρξαντο ἀπὸ μιᾶς ⸂πάντες παραιτεῖσθαι. ὁ πρῶτος εἶπεν αὐτῷ· Ἀγρὸν ἠγόρασα καὶ ἔχω ἀνάγκην ⸀ἐξελθὼνἰδεῖν αὐτόν· ἐρωτῶ σε, ἔχε με παρῃτημένον. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","καὶ ἕτερος εἶπεν· Ζεύγη βοῶν ἠγόρασα πέντε καὶ πορεύομαι δοκιμάσαι αὐτά· ἐρωτῶ σε, ἔχε με παρῃτημένον. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","καὶ ἕτερος εἶπεν· Γυναῖκα ἔγημα καὶ διὰ τοῦτο οὐ δύναμαι ἐλθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","καὶ παραγενόμενος ὁ ⸀δοῦλοςἀπήγγειλεν τῷ κυρίῳ αὐτοῦ ταῦτα. τότε ὀργισθεὶς ὁ οἰκοδεσπότης εἶπεν τῷ δούλῳ αὐτοῦ· Ἔξελθε ταχέως εἰς τὰς πλατείας καὶ ῥύμας τῆς πόλεως, καὶ τοὺς πτωχοὺς καὶ ἀναπείρους καὶ ⸂τυφλοὺς καὶ χωλοὺς εἰσάγαγε ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","καὶ εἶπεν ὁ δοῦλος· Κύριε, γέγονεν ⸀ὃἐπέταξας, καὶ ἔτι τόπος ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","καὶ εἶπεν ὁ κύριος πρὸς τὸν δοῦλον· Ἔξελθε εἰς τὰς ὁδοὺς καὶ φραγμοὺς καὶ ἀνάγκασον εἰσελθεῖν, ἵνα γεμισθῇ ⸂μου ὁ οἶκος· ");
INSERT INTO grcsbl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","λέγω γὰρ ὑμῖν ὅτι οὐδεὶς τῶν ἀνδρῶν ἐκείνων τῶν κεκλημένων γεύσεταί μου τοῦ ⸀δείπνου ");
INSERT INTO grcsbl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Συνεπορεύοντο δὲ αὐτῷ ὄχλοι πολλοί, καὶ στραφεὶς εἶπεν πρὸς αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Εἴ τις ἔρχεται πρός με καὶ οὐ μισεῖ τὸν πατέρα ⸀ἑαυτοῦκαὶ τὴν μητέρα καὶ τὴν γυναῖκα καὶ τὰ τέκνα καὶ τοὺς ἀδελφοὺς καὶ τὰς ἀδελφάς, ἔτι ⸀τεκαὶ τὴν ⸂ψυχὴν ἑαυτοῦ, οὐ δύναται ⸂εἶναί μου μαθητής. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","⸀ὅστιςοὐ βαστάζει τὸν σταυρὸν ⸀ἑαυτοῦκαὶ ἔρχεται ὀπίσω μου, οὐ δύναται εἶναί μου μαθητής. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","τίς γὰρ ἐξ ⸀ὑμῶνθέλων πύργον οἰκοδομῆσαι οὐχὶ πρῶτον καθίσας ψηφίζει τὴν δαπάνην, εἰ ⸀ἔχειεἰς ἀπαρτισμόν; ");
INSERT INTO grcsbl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ἵνα μήποτε θέντος αὐτοῦ θεμέλιον καὶ μὴ ἰσχύοντος ἐκτελέσαι πάντες οἱ θεωροῦντες ἄρξωνται ⸂αὐτῷ ἐμπαίζειν ");
INSERT INTO grcsbl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","λέγοντες ὅτι Οὗτος ὁ ἄνθρωπος ἤρξατο οἰκοδομεῖν καὶ οὐκ ἴσχυσεν ἐκτελέσαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ἢ τίς βασιλεὺς πορευόμενος ⸂ἑτέρῳ βασιλεῖ συμβαλεῖν εἰς πόλεμον οὐχὶ καθίσας πρῶτον ⸀βουλεύσεταιεἰ δυνατός ἐστιν ἐν δέκα χιλιάσιν ⸀ὑπαντῆσαιτῷ μετὰ εἴκοσι χιλιάδων ἐρχομένῳ ἐπʼ αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","εἰ δὲ μήγε, ἔτι ⸂αὐτοῦ πόρρω ὄντος πρεσβείαν ἀποστείλας ἐρωτᾷ ⸀τὰπρὸς εἰρήνην. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","οὕτως οὖν πᾶς ἐξ ὑμῶν ὃς οὐκ ἀποτάσσεται πᾶσιν τοῖς ἑαυτοῦ ὑπάρχουσιν οὐ δύναται ⸂εἶναί μου μαθητής. ");
INSERT INTO grcsbl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Καλὸν ⸀οὖντὸ ἅλας· ἐὰν δὲ ⸀καὶτὸ ἅλας μωρανθῇ, ἐν τίνι ἀρτυθήσεται; ");
INSERT INTO grcsbl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","οὔτε εἰς γῆν οὔτε εἰς κοπρίαν εὔθετόν ἐστιν· ἔξω βάλλουσιν αὐτό. ὁ ἔχων ὦτα ἀκούειν ἀκουέτω. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ἦσαν δὲ ⸂αὐτῷ ἐγγίζοντες πάντες οἱ τελῶναι καὶ οἱ ἁμαρτωλοὶ ἀκούειν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","καὶ διεγόγγυζον οἵ ⸀τεΦαρισαῖοι καὶ οἱ γραμματεῖς λέγοντες ὅτι Οὗτος ἁμαρτωλοὺς προσδέχεται καὶ συνεσθίει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","εἶπεν δὲ πρὸς αὐτοὺς τὴν παραβολὴν ταύτην λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Τίς ἄνθρωπος ἐξ ὑμῶν ἔχων ἑκατὸν πρόβατα καὶ ⸀ἀπολέσας⸂ἐξ αὐτῶν ἓν οὐ καταλείπει τὰ ἐνενήκοντα ἐννέα ἐν τῇ ἐρήμῳ καὶ πορεύεται ἐπὶ τὸ ἀπολωλὸς ἕως εὕρῃ αὐτό; ");
INSERT INTO grcsbl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","καὶ εὑρὼν ἐπιτίθησιν ἐπὶ τοὺς ὤμους ⸀αὐτοῦχαίρων, ");
INSERT INTO grcsbl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","καὶ ἐλθὼν εἰς τὸν οἶκον συγκαλεῖ τοὺς φίλους καὶ τοὺς γείτονας, λέγων αὐτοῖς· Συγχάρητέ μοι ὅτι εὗρον τὸ πρόβατόν μου τὸ ἀπολωλός. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","λέγω ὑμῖν ὅτι οὕτως χαρὰ ⸂ἐν τῷ οὐρανῷ ἔσται ἐπὶ ἑνὶ ἁμαρτωλῷ μετανοοῦντι ἢ ἐπὶ ἐνενήκοντα ἐννέα δικαίοις οἵτινες οὐ χρείαν ἔχουσιν μετανοίας. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ἢ τίς γυνὴ δραχμὰς ἔχουσα δέκα, ἐὰν ἀπολέσῃ δραχμὴν μίαν, οὐχὶ ἅπτει λύχνον καὶ σαροῖ τὴν οἰκίαν καὶ ζητεῖ ἐπιμελῶς ἕως ⸀οὗεὕρῃ; ");
INSERT INTO grcsbl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","καὶ εὑροῦσα ⸀συγκαλεῖτὰς φίλας ⸀καὶγείτονας λέγουσα· Συγχάρητέ μοι ὅτι εὗρον τὴν δραχμὴν ἣν ἀπώλεσα. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","οὕτως, λέγω ὑμῖν, ⸂γίνεται χαρὰ ἐνώπιον τῶν ἀγγέλων τοῦ θεοῦ ἐπὶ ἑνὶ ἁμαρτωλῷ μετανοοῦντι. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Εἶπεν δέ· Ἄνθρωπός τις εἶχεν δύο υἱούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","καὶ εἶπεν ὁ νεώτερος αὐτῶν τῷ πατρί· Πάτερ, δός μοι τὸ ἐπιβάλλον μέρος τῆς οὐσίας· ⸂ὁ δὲ διεῖλεν αὐτοῖς τὸν βίον. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","καὶ μετʼ οὐ πολλὰς ἡμέρας συναγαγὼν ⸀πάνταὁ νεώτερος υἱὸς ἀπεδήμησεν εἰς χώραν μακράν, καὶ ἐκεῖ διεσκόρπισεν τὴν οὐσίαν αὐτοῦ ζῶν ἀσώτως. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","δαπανήσαντος δὲ αὐτοῦ πάντα ἐγένετο λιμὸς ⸀ἰσχυρὰκατὰ τὴν χώραν ἐκείνην, καὶ αὐτὸς ἤρξατο ὑστερεῖσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","καὶ πορευθεὶς ἐκολλήθη ἑνὶ τῶν πολιτῶν τῆς χώρας ἐκείνης, καὶ ἔπεμψεν αὐτὸν εἰς τοὺς ἀγροὺς αὐτοῦ βόσκειν χοίρους· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","καὶ ἐπεθύμει ⸂γεμίσαι τὴν κοιλίαν αὐτοῦ ἀπὸ τῶν κερατίων ὧν ἤσθιον οἱ χοῖροι, καὶ οὐδεὶς ἐδίδου αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","εἰς ἑαυτὸν δὲ ἐλθὼν ⸀ἔφη Πόσοι μίσθιοι τοῦ πατρός μου ⸀περισσεύονταιἄρτων, ἐγὼ δὲ ⸂λιμῷ ὧδε ἀπόλλυμαι· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ἀναστὰς πορεύσομαι πρὸς τὸν πατέρα μου καὶ ἐρῶ αὐτῷ· Πάτερ, ἥμαρτον εἰς τὸν οὐρανὸν καὶ ἐνώπιόν σου, ");
INSERT INTO grcsbl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","⸀οὐκέτιεἰμὶ ἄξιος κληθῆναι υἱός σου· ποίησόν με ὡς ἕνα τῶν μισθίων σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","καὶ ἀναστὰς ἦλθεν πρὸς τὸν πατέρα ⸀ἑαυτοῦ ἔτι δὲ αὐτοῦ μακρὰν ἀπέχοντος εἶδεν αὐτὸν ὁ πατὴρ αὐτοῦ καὶ ἐσπλαγχνίσθη καὶ δραμὼν ἐπέπεσεν ἐπὶ τὸν τράχηλον αὐτοῦ καὶ κατεφίλησεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","εἶπεν δὲ ⸂ὁ υἱὸς αὐτῷ· Πάτερ, ἥμαρτον εἰς τὸν οὐρανὸν καὶ ἐνώπιόν σου, ⸀οὐκέτιεἰμὶ ἄξιος κληθῆναι υἱός ⸀σου ");
INSERT INTO grcsbl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","εἶπεν δὲ ὁ πατὴρ πρὸς τοὺς δούλους αὐτοῦ· ⸀Ταχὺ⸀ἐξενέγκατεστολὴν τὴν πρώτην καὶ ἐνδύσατε αὐτόν, καὶ δότε δακτύλιον εἰς τὴν χεῖρα αὐτοῦ καὶ ὑποδήματα εἰς τοὺς πόδας, ");
INSERT INTO grcsbl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","καὶ ⸀φέρετετὸν μόσχον τὸν σιτευτόν, θύσατε, καὶ φαγόντες εὐφρανθῶμεν, ");
INSERT INTO grcsbl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ὅτι οὗτος ὁ υἱός μου νεκρὸς ἦν καὶ ἀνέζησεν, ⸂ἦν ἀπολωλὼς καὶ εὑρέθη. καὶ ἤρξαντο εὐφραίνεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ἦν δὲ ὁ υἱὸς αὐτοῦ ὁ πρεσβύτερος ἐν ἀγρῷ· καὶ ὡς ἐρχόμενος ἤγγισεν τῇ οἰκίᾳ, ἤκουσεν συμφωνίας καὶ χορῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","καὶ προσκαλεσάμενος ἕνα τῶν παίδων ἐπυνθάνετο τί ⸀ἂνεἴη ταῦτα· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ὁ δὲ εἶπεν αὐτῷ ὅτι Ὁ ἀδελφός σου ἥκει, καὶ ἔθυσεν ὁ πατήρ σου τὸν μόσχον τὸν σιτευτόν, ὅτι ὑγιαίνοντα αὐτὸν ἀπέλαβεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ὠργίσθη δὲκαὶ οὐκ ἤθελεν εἰσελθεῖν. ὁ ⸀δὲ πατὴρ αὐτοῦ ἐξελθὼν παρεκάλει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ὁ δὲ ἀποκριθεὶς εἶπεν τῷ πατρὶ ⸀αὐτοῦ Ἰδοὺ τοσαῦτα ἔτη δουλεύω σοι καὶ οὐδέποτε ἐντολήν σου παρῆλθον, καὶ ἐμοὶ οὐδέποτε ἔδωκας ἔριφον ἵνα μετὰ τῶν φίλων μου εὐφρανθῶ· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ὅτε δὲ ὁ υἱός σου οὗτος ὁ καταφαγών σου τὸν βίον ⸀μετὰπορνῶν ἦλθεν, ἔθυσας αὐτῷ τὸν ⸂σιτευτὸν μόσχον. ");
INSERT INTO grcsbl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ὁ δὲ εἶπεν αὐτῷ· Τέκνον, σὺ πάντοτε μετʼ ἐμοῦ εἶ, καὶ πάντα τὰ ἐμὰ σά ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","εὐφρανθῆναι δὲ καὶ χαρῆναι ἔδει, ὅτι ὁ ἀδελφός σου οὗτος νεκρὸς ἦν καὶ ⸀ἔζησεν καὶ ⸀ἀπολωλὼςκαὶ εὑρέθη. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ἔλεγεν δὲ καὶ πρὸς τοὺς ⸀μαθητάς Ἄνθρωπός τις ἦν πλούσιος ὃς εἶχεν οἰκονόμον, καὶ οὗτος διεβλήθη αὐτῷ ὡς διασκορπίζων τὰ ὑπάρχοντα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","καὶ φωνήσας αὐτὸν εἶπεν αὐτῷ· Τί τοῦτο ἀκούω περὶ σοῦ; ἀπόδος τὸν λόγον τῆς οἰκονομίας σου, οὐ γὰρ ⸀δύνῃἔτι οἰκονομεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","εἶπεν δὲ ἐν ἑαυτῷ ὁ οἰκονόμος· Τί ποιήσω ὅτι ὁ κύριός μου ἀφαιρεῖται τὴν οἰκονομίαν ἀπʼ ἐμοῦ; σκάπτειν οὐκ ἰσχύω, ἐπαιτεῖν αἰσχύνομαι· ");
INSERT INTO grcsbl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ἔγνων τί ποιήσω, ἵνα ὅταν μετασταθῶ ⸀ἐκτῆς οἰκονομίας δέξωνταί με εἰς τοὺς οἴκους ⸀ἑαυτῶν ");
INSERT INTO grcsbl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","καὶ προσκαλεσάμενος ἕνα ἕκαστον τῶν χρεοφειλετῶν τοῦ κυρίου ἑαυτοῦ ἔλεγεν τῷ πρώτῳ· Πόσον ὀφείλεις τῷ κυρίῳ μου; ");
INSERT INTO grcsbl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ὁ δὲεἶπεν· Ἑκατὸν βάτους ἐλαίου· ⸂ὁ δὲ⸃ εἶπεν αὐτῷ· Δέξαι σου ⸂τὰ γράμματα καὶ καθίσας ταχέως γράψον πεντήκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ἔπειτα ἑτέρῳ εἶπεν· Σὺ δὲ πόσον ὀφείλεις; ὁ δὲ εἶπεν· Ἑκατὸν κόρους σίτου· ⸀λέγειαὐτῷ· Δέξαι σου ⸂τὰ γράμματα καὶ γράψον ὀγδοήκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","καὶ ἐπῄνεσεν ὁ κύριος τὸν οἰκονόμον τῆς ἀδικίας ὅτι φρονίμως ἐποίησεν· ὅτι οἱ υἱοὶ τοῦ αἰῶνος τούτου φρονιμώτεροι ὑπὲρ τοὺς υἱοὺς τοῦ φωτὸς εἰς τὴν γενεὰν τὴν ἑαυτῶν εἰσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","καὶ ἐγὼ ὑμῖν λέγω, ⸂ἑαυτοῖς ποιήσατε φίλους ἐκ τοῦ μαμωνᾶ τῆς ἀδικίας, ἵνα ὅταν ⸀ἐκλίπῃδέξωνται ὑμᾶς εἰς τὰς αἰωνίους σκηνάς. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ὁ πιστὸς ἐν ἐλαχίστῳ καὶ ἐν πολλῷ πιστός ἐστιν, καὶ ὁ ἐν ἐλαχίστῳ ἄδικος καὶ ἐν πολλῷ ἄδικός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","εἰ οὖν ἐν τῷ ἀδίκῳ μαμωνᾷ πιστοὶ οὐκ ἐγένεσθε, τὸ ἀληθινὸν τίς ὑμῖν πιστεύσει; ");
INSERT INTO grcsbl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","καὶ εἰ ἐν τῷ ἀλλοτρίῳ πιστοὶ οὐκ ἐγένεσθε, τὸ ⸀ὑμέτεροντίς ⸂δώσει ὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","οὐδεὶς οἰκέτης δύναται δυσὶ κυρίοις δουλεύειν· ἢ γὰρ τὸν ἕνα μισήσει καὶ τὸν ἕτερον ἀγαπήσει, ἢ ἑνὸς ἀνθέξεται καὶ τοῦ ἑτέρου καταφρονήσει. οὐ δύνασθε θεῷ δουλεύειν καὶ μαμωνᾷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ἤκουον δὲ ταῦτα ⸀πάνταοἱ Φαρισαῖοι φιλάργυροι ὑπάρχοντες, καὶ ἐξεμυκτήριζον αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","καὶ εἶπεν αὐτοῖς· Ὑμεῖς ἐστε οἱ δικαιοῦντες ἑαυτοὺς ἐνώπιον τῶν ἀνθρώπων, ὁ δὲ θεὸς γινώσκει τὰς καρδίας ὑμῶν· ὅτι τὸ ἐν ἀνθρώποις ὑψηλὸν βδέλυγμα ἐνώπιον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ὁ νόμος καὶ οἱ προφῆται ⸀μέχριἸωάννου· ἀπὸ τότε ἡ βασιλεία τοῦ θεοῦ εὐαγγελίζεται καὶ πᾶς εἰς αὐτὴν βιάζεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Εὐκοπώτερον δέ ἐστιν τὸν οὐρανὸν καὶ τὴν γῆν παρελθεῖν ἢ τοῦ νόμου μίαν κεραίαν πεσεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Πᾶς ὁ ἀπολύων τὴν γυναῖκα αὐτοῦ καὶγαμῶν ἑτέραν μοιχεύει, ⸀καὶ ὁ ἀπολελυμένην ἀπὸ ἀνδρὸς γαμῶν μοιχεύει. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ἄνθρωπος δέ τις ἦν πλούσιος, καὶ ἐνεδιδύσκετο πορφύραν καὶ βύσσον εὐφραινόμενος καθʼ ἡμέραν λαμπρῶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","πτωχὸς δέ ⸀τιςὀνόματι ⸀Λάζαροςἐβέβλητο πρὸς τὸν πυλῶνα αὐτοῦ εἱλκωμένος ");
INSERT INTO grcsbl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","καὶ ἐπιθυμῶν χορτασθῆναι ⸀ἀπὸτῶν πιπτόντων ἀπὸ τῆς τραπέζης τοῦ πλουσίου· ἀλλὰ καὶ οἱ κύνες ἐρχόμενοι ⸀ἐπέλειχοντὰ ἕλκη αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ἐγένετο δὲ ἀποθανεῖν τὸν πτωχὸν καὶ ἀπενεχθῆναι αὐτὸν ὑπὸ τῶν ἀγγέλων εἰς τὸν κόλπον Ἀβραάμ· ἀπέθανεν δὲ καὶ ὁ πλούσιος καὶ ἐτάφη. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","καὶ ἐν τῷ ᾅδῃ ἐπάρας τοὺς ὀφθαλμοὺς αὐτοῦ, ὑπάρχων ἐν βασάνοις, ⸀ὁρᾷἈβραὰμ ἀπὸ μακρόθεν καὶ Λάζαρον ἐν τοῖς κόλποις αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","καὶ αὐτὸς φωνήσας εἶπεν· Πάτερ Ἀβραάμ, ἐλέησόν με καὶ πέμψον Λάζαρον ἵνα βάψῃ τὸ ἄκρον τοῦ δακτύλου αὐτοῦ ὕδατος καὶ καταψύξῃ τὴν γλῶσσάν μου, ὅτι ὀδυνῶμαι ἐν τῇ φλογὶ ταύτῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","εἶπεν δὲ Ἀβραάμ· Τέκνον, μνήσθητι ὅτι ⸀ἀπέλαβεςτὰ ἀγαθά σου ἐν τῇ ζωῇ σου, καὶ Λάζαρος ὁμοίως τὰ κακά· νῦν δὲ ὧδε παρακαλεῖται σὺ δὲ ὀδυνᾶσαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","καὶ ⸀ἐνπᾶσι τούτοις μεταξὺ ἡμῶν καὶ ὑμῶν χάσμα μέγα ἐστήρικται, ὅπως οἱ θέλοντες διαβῆναι ἔνθεν πρὸς ὑμᾶς μὴ δύνωνται, ⸀μηδὲ ἐκεῖθεν πρὸς ἡμᾶς διαπερῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","εἶπεν δέ· Ἐρωτῶ ⸂σε οὖν, πάτερ, ἵνα πέμψῃς αὐτὸν εἰς τὸν οἶκον τοῦ πατρός μου, ");
INSERT INTO grcsbl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ἔχω γὰρ πέντε ἀδελφούς, ὅπως διαμαρτύρηται αὐτοῖς, ἵνα μὴ καὶ αὐτοὶ ἔλθωσιν εἰς τὸν τόπον τοῦτον τῆς βασάνου. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","λέγει ⸀δὲἈβραάμ· Ἔχουσι Μωϋσέα καὶ τοὺς προφήτας· ἀκουσάτωσαν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ὁ δὲ εἶπεν· Οὐχί, πάτερ Ἀβραάμ, ἀλλʼ ἐάν τις ἀπὸ νεκρῶν πορευθῇ πρὸς αὐτοὺς μετανοήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","εἶπεν δὲ αὐτῷ· Εἰ Μωϋσέως καὶ τῶν προφητῶν οὐκ ἀκούουσιν, οὐδʼ ἐάν τις ἐκ νεκρῶν ἀναστῇ πεισθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Εἶπεν δὲ πρὸς τοὺς μαθητὰς ⸀αὐτοῦ Ἀνένδεκτόν ἐστιν τοῦ ⸂τὰ σκάνδαλα μὴ ἐλθεῖν, ⸂πλὴν οὐαὶ διʼ οὗ ἔρχεται· ");
INSERT INTO grcsbl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","λυσιτελεῖ αὐτῷ εἰ ⸂λίθος μυλικὸς περίκειται περὶ τὸν τράχηλον αὐτοῦ καὶ ἔρριπται εἰς τὴν θάλασσαν ἢ ἵνα σκανδαλίσῃ ⸂τῶν μικρῶν τούτων ἕνα. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","προσέχετε ἑαυτοῖς. ἐὰν ⸀ἁμάρτῃὁ ἀδελφός σου ἐπιτίμησον αὐτῷ, καὶ ἐὰν μετανοήσῃ ἄφες αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","καὶ ἐὰν ἑπτάκις τῆς ἡμέρας ⸀ἁμαρτήσῃεἰς σὲ καὶ ⸀ἑπτάκιςἐπιστρέψῃ ⸂πρὸς σὲ λέγων· Μετανοῶ, ἀφήσεις αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Καὶ εἶπαν οἱ ἀπόστολοι τῷ κυρίῳ· Πρόσθες ἡμῖν πίστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","εἶπεν δὲ ὁ κύριος· Εἰ ἔχετε πίστιν ὡς κόκκον σινάπεως, ἐλέγετε ἂν τῇ συκαμίνῳ ταύτῃ· Ἐκριζώθητι καὶ φυτεύθητι ἐν τῇ θαλάσσῃ· καὶ ὑπήκουσεν ἂν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Τίς δὲ ἐξ ὑμῶν δοῦλον ἔχων ἀροτριῶντα ἢ ποιμαίνοντα, ὃς εἰσελθόντι ἐκ τοῦ ἀγροῦ ἐρεῖ ⸀αὐτῷ Εὐθέως παρελθὼν ἀνάπεσε, ");
INSERT INTO grcsbl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ἀλλʼ οὐχὶ ἐρεῖ αὐτῷ· Ἑτοίμασον τί δειπνήσω καὶ περιζωσάμενος διακόνει μοι ἕως φάγω καὶ πίω, καὶ μετὰ ταῦτα φάγεσαι καὶ πίεσαι σύ; ");
INSERT INTO grcsbl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","μὴ ⸂ἔχει χάριν τῷ ⸀δούλῳὅτι ἐποίησεν τὰ ⸀διαταχθέντα ");
INSERT INTO grcsbl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","οὕτως καὶ ὑμεῖς, ὅταν ποιήσητε πάντα τὰ διαταχθέντα ὑμῖν, λέγετε ὅτι Δοῦλοι ἀχρεῖοί ἐσμεν, ⸂ὃ ὠφείλομεν ποιῆσαι πεποιήκαμεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Καὶ ἐγένετο ἐν τῷ ⸀πορεύεσθαιεἰς Ἰερουσαλὴμ καὶ αὐτὸς διήρχετο διὰ ⸀μέσονΣαμαρείας καὶ Γαλιλαίας. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","καὶ εἰσερχομένου αὐτοῦ εἴς τινα κώμην ⸀ἀπήντησανδέκα λεπροὶ ἄνδρες, οἳ ⸀ἔστησανπόρρωθεν, ");
INSERT INTO grcsbl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","καὶ αὐτοὶ ἦραν φωνὴν λέγοντες· Ἰησοῦ ἐπιστάτα, ἐλέησον ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","καὶ ἰδὼν εἶπεν αὐτοῖς· Πορευθέντες ἐπιδείξατε ἑαυτοὺς τοῖς ἱερεῦσιν. καὶ ἐγένετο ἐν τῷ ὑπάγειν αὐτοὺς ἐκαθαρίσθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","εἷς δὲ ἐξ αὐτῶν, ἰδὼν ὅτι ἰάθη, ὑπέστρεψεν μετὰ φωνῆς μεγάλης δοξάζων τὸν θεόν, ");
INSERT INTO grcsbl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","καὶ ἔπεσεν ἐπὶ πρόσωπον παρὰ τοὺς πόδας αὐτοῦ εὐχαριστῶν αὐτῷ· καὶ αὐτὸς ἦν Σαμαρίτης. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν· ⸀Οὐχὶοἱ δέκα ἐκαθαρίσθησαν; οἱ δὲ ἐννέα ποῦ; ");
INSERT INTO grcsbl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","οὐχ εὑρέθησαν ὑποστρέψαντες δοῦναι δόξαν τῷ θεῷ εἰ μὴ ὁ ἀλλογενὴς οὗτος; ");
INSERT INTO grcsbl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","καὶ εἶπεν αὐτῷ· Ἀναστὰς πορεύου· ἡ πίστις σου σέσωκέν σε. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ἐπερωτηθεὶς δὲ ὑπὸ τῶν Φαρισαίων πότε ἔρχεται ἡ βασιλεία τοῦ θεοῦ ἀπεκρίθη αὐτοῖς καὶ εἶπεν· Οὐκ ἔρχεται ἡ βασιλεία τοῦ θεοῦ μετὰ παρατηρήσεως, ");
INSERT INTO grcsbl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","οὐδὲ ἐροῦσιν· Ἰδοὺ ὧδε ἤ· ⸀Ἐκεῖ ἰδοὺ γὰρ ἡ βασιλεία τοῦ θεοῦ ἐντὸς ὑμῶν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Εἶπεν δὲ πρὸς τοὺς μαθητάς· Ἐλεύσονται ἡμέραι ὅτε ἐπιθυμήσετε μίαν τῶν ἡμερῶν τοῦ υἱοῦ τοῦ ἀνθρώπου ἰδεῖν καὶ οὐκ ὄψεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","καὶ ἐροῦσιν ὑμῖν· Ἰδοὺ ⸂ἐκεῖ· Ἰδοὺ ὧδε· μὴ ἀπέλθητε μηδὲ διώξητε. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ὥσπερ γὰρ ἡ ⸀ἀστραπὴἀστράπτουσα ἐκ τῆς ⸂ὑπὸ τὸν οὐρανὸν εἰς τὴν ὑπʼ οὐρανὸν λάμπει, οὕτως ἔσται ὁ υἱὸς τοῦ ἀνθρώπου ⸂ἐν τῇ ἡμέρᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","πρῶτον δὲ δεῖ αὐτὸν πολλὰ παθεῖν καὶ ἀποδοκιμασθῆναι ἀπὸ τῆς γενεᾶς ταύτης. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","καὶ καθὼς ἐγένετο ἐν ταῖς ἡμέραις Νῶε, οὕτως ἔσται καὶ ἐν ταῖς ἡμέραις τοῦ υἱοῦ τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ἤσθιον, ἔπινον, ἐγάμουν, ⸀ἐγαμίζοντο ἄχρι ἧς ἡμέρας εἰσῆλθεν Νῶε εἰς τὴν κιβωτόν, καὶ ἦλθεν ὁ κατακλυσμὸς καὶ ἀπώλεσεν ⸀πάντας ");
INSERT INTO grcsbl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ὁμοίως ⸀καθὼςἐγένετο ἐν ταῖς ἡμέραις Λώτ· ἤσθιον, ἔπινον, ἠγόραζον, ἐπώλουν, ἐφύτευον, ᾠκοδόμουν· ");
INSERT INTO grcsbl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ᾗ δὲ ἡμέρᾳ ἐξῆλθεν Λὼτ ἀπὸ Σοδόμων, ἔβρεξεν πῦρ καὶ θεῖον ἀπʼ οὐρανοῦ καὶ ἀπώλεσεν ⸀πάντας ");
INSERT INTO grcsbl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","κατὰ ⸂τὰ αὐτὰ ἔσται ᾗ ἡμέρᾳ ὁ υἱὸς τοῦ ἀνθρώπου ἀποκαλύπτεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ἐνἐκείνῃ τῇ ἡμέρᾳ ὃς ἔσται ἐπὶ τοῦ δώματος καὶ τὰ σκεύη αὐτοῦ ἐν τῇ οἰκίᾳ, μὴ καταβάτω ἆραι αὐτά, καὶ ὁ ⸀ἐν ἀγρῷ ὁμοίως μὴ ἐπιστρεψάτω εἰς τὰ ὀπίσω. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","μνημονεύετε τῆς γυναικὸς Λώτ. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ὃς ἐὰν ζητήσῃ τὴν ψυχὴν αὐτοῦ ⸀περιποιήσασθαιἀπολέσει αὐτήν, ⸂ὃς δʼ ἂν ⸀ἀπολέσῃζῳογονήσει αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","λέγω ὑμῖν, ταύτῃ τῇ νυκτὶ ἔσονται δύο ἐπὶ κλίνης μιᾶς, ⸀ὁεἷς παραλημφθήσεται καὶ ὁ ἕτερος ἀφεθήσεται· ");
INSERT INTO grcsbl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","⸂ἔσονται δύο ἀλήθουσαι ἐπὶ τὸ αὐτό, ⸀ἡμία παραλημφθήσεται ⸂ἡ δὲ ἑτέρα ⸀ἀφεθήσεται ");
INSERT INTO grcsbl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","καὶ ἀποκριθέντες λέγουσιν αὐτῷ· Ποῦ, κύριε; ὁ δὲ εἶπεν αὐτοῖς· Ὅπου τὸ σῶμα, ἐκεῖ ⸂καὶ οἱ ἀετοὶ ἐπισυναχθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ἔλεγεν ⸀δὲπαραβολὴν αὐτοῖς πρὸς τὸ δεῖν πάντοτε προσεύχεσθαι ⸀αὐτοὺςκαὶ μὴ ἐγκακεῖν, ");
INSERT INTO grcsbl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","λέγων· Κριτής τις ἦν ἔν τινι πόλει τὸν θεὸν μὴ φοβούμενος καὶ ἄνθρωπον μὴ ἐντρεπόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","χήρα δὲ ἦν ἐν τῇ πόλει ἐκείνῃ καὶ ἤρχετο πρὸς αὐτὸν λέγουσα· Ἐκδίκησόν με ἀπὸ τοῦ ἀντιδίκου μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","καὶ οὐκ ⸀ἤθελενἐπὶ χρόνον, μετὰ ⸂ταῦτα δὲ εἶπεν ἐν ἑαυτῷ· Εἰ καὶ τὸν θεὸν οὐ φοβοῦμαι ⸂οὐδὲ ἄνθρωπον ἐντρέπομαι, ");
INSERT INTO grcsbl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","διά γε τὸ παρέχειν μοι κόπον τὴν χήραν ταύτην ἐκδικήσω αὐτήν, ἵνα μὴ εἰς τέλος ἐρχομένη ὑπωπιάζῃ με. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","εἶπεν δὲ ὁ κύριος· Ἀκούσατε τί ὁ κριτὴς τῆς ἀδικίας λέγει· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ὁ δὲ θεὸς οὐ μὴ ποιήσῃ τὴν ἐκδίκησιν τῶν ἐκλεκτῶν αὐτοῦ τῶν βοώντων ⸀αὐτῷἡμέρας καὶ νυκτός, καὶ ⸀μακροθυμεῖἐπʼ αὐτοῖς; ");
INSERT INTO grcsbl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","λέγω ὑμῖν ὅτι ποιήσει τὴν ἐκδίκησιν αὐτῶν ἐν τάχει. πλὴν ὁ υἱὸς τοῦ ἀνθρώπου ἐλθὼν ἆρα εὑρήσει τὴν πίστιν ἐπὶ τῆς γῆς; ");
INSERT INTO grcsbl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Εἶπεν δὲ ⸀καὶπρός τινας τοὺς πεποιθότας ἐφʼ ἑαυτοῖς ὅτι εἰσὶν δίκαιοι καὶ ἐξουθενοῦντας τοὺς λοιποὺς τὴν παραβολὴν ταύτην· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ἄνθρωποι δύο ἀνέβησαν εἰς τὸ ἱερὸν προσεύξασθαι, ⸀ὁεἷς Φαρισαῖος καὶ ὁ ἕτερος τελώνης. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ὁ Φαρισαῖος σταθεὶς ⸂πρὸς ἑαυτὸν ταῦτα προσηύχετο· Ὁ θεός, εὐχαριστῶ σοι ὅτι οὐκ εἰμὶ ⸀ὥσπεροἱ λοιποὶ τῶν ἀνθρώπων, ἅρπαγες, ἄδικοι, μοιχοί, ἢ καὶ ὡς οὗτος ὁ τελώνης· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","νηστεύω δὶς τοῦ σαββάτου, ⸀ἀποδεκατῶπάντα ὅσα κτῶμαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","⸂ὁ δὲ τελώνης μακρόθεν ἑστὼς οὐκ ἤθελεν οὐδὲ τοὺς ὀφθαλμοὺς ⸂ἐπᾶραι εἰς τὸν οὐρανόν, ἀλλʼ ⸀ἔτυπτετὸ στῆθος ⸀αὐτοῦλέγων· Ὁ θεός, ἱλάσθητί μοι τῷ ἁμαρτωλῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","λέγω ὑμῖν, κατέβη οὗτος δεδικαιωμένος εἰς τὸν οἶκον αὐτοῦ ⸂παρʼ ἐκεῖνον· ὅτι πᾶς ὁ ὑψῶν ἑαυτὸν ταπεινωθήσεται, ὁ δὲ ταπεινῶν ἑαυτὸν ὑψωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Προσέφερον δὲ αὐτῷ καὶ τὰ βρέφη ἵνα αὐτῶν ἅπτηται· ἰδόντες δὲ οἱ μαθηταὶ ⸀ἐπετίμωναὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ὁ δὲ Ἰησοῦς ⸂προσεκαλέσατο αὐτὰ λέγων· Ἄφετε τὰ παιδία ἔρχεσθαι πρός με καὶ μὴ κωλύετε αὐτά, τῶν γὰρ τοιούτων ἐστὶν ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ἀμὴν λέγω ὑμῖν, ὃς ⸀ἂνμὴ δέξηται τὴν βασιλείαν τοῦ θεοῦ ὡς παιδίον, οὐ μὴ εἰσέλθῃ εἰς αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Καὶ ἐπηρώτησέν τις αὐτὸν ἄρχων λέγων· Διδάσκαλε ἀγαθέ, τί ποιήσας ζωὴν αἰώνιον κληρονομήσω; ");
INSERT INTO grcsbl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","εἶπεν δὲ αὐτῷ ὁ Ἰησοῦς· Τί με λέγεις ἀγαθόν; οὐδεὶς ἀγαθὸς εἰ μὴ εἷς ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","τὰς ἐντολὰς οἶδας· Μὴ μοιχεύσῃς, Μὴ φονεύσῃς, Μὴ κλέψῃς, Μὴ ψευδομαρτυρήσῃς, Τίμα τὸν πατέρα σου καὶ τὴν ⸀μητέρα ");
INSERT INTO grcsbl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ὁ δὲ εἶπεν· Ταῦτα πάντα ⸀ἐφύλαξαἐκ νεότητος ⸀μου ");
INSERT INTO grcsbl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ἀκούσας ⸀δὲὁ Ἰησοῦς εἶπεν αὐτῷ· Ἔτι ἕν σοι λείπει· πάντα ὅσα ἔχεις πώλησον καὶ διάδος πτωχοῖς, καὶ ἕξεις θησαυρὸν ἐν ⸀οὐρανοῖς καὶ δεῦρο ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ὁ δὲ ἀκούσας ταῦτα περίλυπος ⸀ἐγενήθη ἦν γὰρ πλούσιος σφόδρα. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ἰδὼν δὲ αὐτὸν ὁ ⸀Ἰησοῦςεἶπεν· Πῶς δυσκόλως οἱ τὰ χρήματα ἔχοντες ⸂εἰς τὴν βασιλείαν τοῦ θεοῦ εἰσπορεύονται· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","εὐκοπώτερον γάρ ἐστιν κάμηλον διὰ ⸂τρήματος βελόνης εἰσελθεῖν ἢ πλούσιον εἰς τὴν βασιλείαν τοῦ θεοῦ εἰσελθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Εἶπαν δὲ οἱ ἀκούσαντες· Καὶ τίς δύναται σωθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ὁ δὲ εἶπεν· Τὰ ἀδύνατα παρὰ ἀνθρώποις δυνατὰ ⸂παρὰ τῷ θεῷ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Εἶπεν δὲ ⸀ὁΠέτρος· Ἰδοὺ ἡμεῖς ⸂ἀφέντες τὰ ἴδια ἠκολουθήσαμέν σοι. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ὁ δὲ εἶπεν αὐτοῖς· Ἀμὴν λέγω ὑμῖν ὅτι οὐδείς ἐστιν ὃς ἀφῆκεν οἰκίαν ἢ ⸂γυναῖκα ἢ ἀδελφοὺς ἢ γονεῖς ἢ τέκνα ἕνεκεν τῆς βασιλείας τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ὃς ⸀οὐχὶμὴ ⸀ἀπολάβῃπολλαπλασίονα ἐν τῷ καιρῷ τούτῳ καὶ ἐν τῷ αἰῶνι τῷ ἐρχομένῳ ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Παραλαβὼν δὲ τοὺς δώδεκα εἶπεν πρὸς αὐτούς· Ἰδοὺ ἀναβαίνομεν εἰς ⸀Ἰερουσαλήμ καὶ τελεσθήσεται πάντα τὰ γεγραμμένα διὰ τῶν προφητῶν τῷ υἱῷ τοῦ ἀνθρώπου· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","παραδοθήσεται γὰρ τοῖς ἔθνεσιν καὶ ἐμπαιχθήσεται καὶ ὑβρισθήσεται καὶ ἐμπτυσθήσεται, ");
INSERT INTO grcsbl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","καὶ μαστιγώσαντες ἀποκτενοῦσιν αὐτόν, καὶ τῇ ἡμέρᾳ τῇ τρίτῃ ἀναστήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","καὶ αὐτοὶ οὐδὲν τούτων συνῆκαν, καὶ ἦν τὸ ῥῆμα τοῦτο κεκρυμμένον ἀπʼ αὐτῶν, καὶ οὐκ ἐγίνωσκον τὰ λεγόμενα. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ἐγένετο δὲ ἐν τῷ ἐγγίζειν αὐτὸν εἰς Ἰεριχὼ τυφλός τις ἐκάθητο παρὰ τὴν ὁδὸν ⸀ἐπαιτῶν ");
INSERT INTO grcsbl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ἀκούσας δὲ ὄχλου διαπορευομένου ἐπυνθάνετο ⸀τίεἴη τοῦτο· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ἀπήγγειλαν δὲ αὐτῷ ὅτι Ἰησοῦς ὁ Ναζωραῖος παρέρχεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","καὶ ἐβόησεν λέγων· Ἰησοῦ υἱὲ Δαυίδ, ἐλέησόν με. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","καὶ οἱ προάγοντες ἐπετίμων αὐτῷ ἵνα ⸀σιγήσῃ αὐτὸς δὲ πολλῷ μᾶλλον ἔκραζεν· Υἱὲ Δαυίδ, ἐλέησόν με. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","σταθεὶς δὲ ⸀ὁἸησοῦς ἐκέλευσεν αὐτὸν ἀχθῆναι πρὸς αὐτόν. ἐγγίσαντος δὲ αὐτοῦ ἐπηρώτησεν αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","⸀Τίσοι θέλεις ποιήσω; ὁ δὲ εἶπεν· Κύριε, ἵνα ἀναβλέψω. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","καὶ ὁ Ἰησοῦς εἶπεν αὐτῷ· Ἀνάβλεψον· ἡ πίστις σου σέσωκέν σε. ");
INSERT INTO grcsbl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","καὶ παραχρῆμα ἀνέβλεψεν, καὶ ἠκολούθει αὐτῷ δοξάζων τὸν θεόν. καὶ πᾶς ὁ λαὸς ἰδὼν ἔδωκεν αἶνον τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Καὶ εἰσελθὼν διήρχετο τὴν Ἰεριχώ. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","καὶ ἰδοὺ ἀνὴρ ὀνόματι ⸀καλούμενοςΖακχαῖος, καὶ αὐτὸςἦν ἀρχιτελώνης καὶ ⸀αὐτὸς πλούσιος· ");
INSERT INTO grcsbl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","καὶ ἐζήτει ἰδεῖν τὸν Ἰησοῦν τίς ἐστιν, καὶ οὐκ ἠδύνατο ἀπὸ τοῦ ὄχλου ὅτι τῇ ἡλικίᾳ μικρὸς ἦν. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","καὶ προδραμὼν ⸂εἰς τὸ ἔμπροσθεν ἀνέβη ἐπὶ συκομορέαν ἵνα ἴδῃ αὐτόν, ὅτι ἐκείνης ἤμελλεν διέρχεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","καὶ ὡς ἦλθεν ἐπὶ τὸν τόπον, ἀναβλέψας ὁ ⸀Ἰησοῦςεἶπεν πρὸς αὐτόν· Ζακχαῖε, σπεύσας κατάβηθι, σήμερον γὰρ ἐν τῷ οἴκῳ σου δεῖ με μεῖναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","καὶ σπεύσας κατέβη, καὶ ὑπεδέξατο αὐτὸν χαίρων. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","καὶ ἰδόντες πάντες διεγόγγυζον λέγοντες ὅτι Παρὰ ἁμαρτωλῷ ἀνδρὶ εἰσῆλθεν καταλῦσαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","σταθεὶς δὲ Ζακχαῖος εἶπεν πρὸς τὸν κύριον· Ἰδοὺ τὰ ⸀ἡμίσιά⸂μου τῶν ὑπαρχόντων, κύριε, ⸂τοῖς πτωχοῖς δίδωμι, καὶ εἴ τινός τι ἐσυκοφάντησα ἀποδίδωμι τετραπλοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","εἶπεν δὲ πρὸς αὐτὸν ὁ Ἰησοῦς ὅτι Σήμερον σωτηρία τῷ οἴκῳ τούτῳ ἐγένετο, καθότι καὶ αὐτὸς υἱὸς Ἀβραάμ ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ἦλθεν γὰρ ὁ υἱὸς τοῦ ἀνθρώπου ζητῆσαι καὶ σῶσαι τὸ ἀπολωλός. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ἀκουόντων δὲ αὐτῶν ταῦτα προσθεὶς εἶπεν παραβολὴν διὰ τὸ ἐγγὺς ⸂εἶναι Ἰερουσαλὴμ αὐτὸν καὶ δοκεῖν αὐτοὺς ὅτι παραχρῆμα μέλλει ἡ βασιλεία τοῦ θεοῦ ἀναφαίνεσθαι· ");
INSERT INTO grcsbl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","εἶπεν οὖν· Ἄνθρωπός τις εὐγενὴς ἐπορεύθη εἰς χώραν μακρὰν λαβεῖν ἑαυτῷ βασιλείαν καὶ ὑποστρέψαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","καλέσας δὲ δέκα δούλους ἑαυτοῦ ἔδωκεν αὐτοῖς δέκα μνᾶς καὶ εἶπεν πρὸς αὐτούς· ⸀Πραγματεύσασθε⸂ἐν ᾧ ἔρχομαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","οἱ δὲ πολῖται αὐτοῦ ἐμίσουν αὐτόν, καὶ ἀπέστειλαν πρεσβείαν ὀπίσω αὐτοῦ λέγοντες· Οὐ θέλομεν τοῦτον βασιλεῦσαι ἐφʼ ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","καὶ ἐγένετο ἐν τῷ ἐπανελθεῖν αὐτὸν λαβόντα τὴν βασιλείαν καὶ εἶπεν φωνηθῆναι αὐτῷ τοὺς δούλους τούτους οἷς ⸀δεδώκειτὸ ἀργύριον, ἵνα ⸀γνοῖτί ⸀διεπραγματεύσαντο ");
INSERT INTO grcsbl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","παρεγένετο δὲ ὁ πρῶτος λέγων· Κύριε, ἡ μνᾶ σου ⸂δέκα προσηργάσατο μνᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","καὶ εἶπεν αὐτῷ· ⸀Εὖγε ἀγαθὲ δοῦλε, ὅτι ἐν ἐλαχίστῳ πιστὸς ἐγένου, ἴσθι ἐξουσίαν ἔχων ἐπάνω δέκα πόλεων. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","καὶ ἦλθεν ὁ δεύτερος λέγων· ⸂Ἡ μνᾶ σου, κύριε⸃, ἐποίησεν πέντε μνᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","εἶπεν δὲ καὶ τούτῳ· Καὶ σὺ ⸂ἐπάνω γίνου πέντε πόλεων. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","καὶ ⸀ὁἕτερος ἦλθεν λέγων· Κύριε, ἰδοὺ ἡ μνᾶ σου ἣν εἶχον ἀποκειμένην ἐν σουδαρίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ἐφοβούμην γάρ σε ὅτι ἄνθρωπος αὐστηρὸς εἶ, αἴρεις ὃ οὐκ ἔθηκας καὶ θερίζεις ὃ οὐκ ἔσπειρας. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","⸀λέγειαὐτῷ· Ἐκ τοῦ στόματός σου κρίνω σε, πονηρὲ δοῦλε· ᾔδεις ὅτι ἐγὼ ἄνθρωπος αὐστηρός εἰμι, αἴρων ὃ οὐκ ἔθηκα καὶ θερίζων ὃ οὐκ ἔσπειρα; ");
INSERT INTO grcsbl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","καὶ διὰ τί οὐκ ἔδωκάς ⸂μου τὸ ἀργύριον ἐπὶ τράπεζαν; κἀγὼ ἐλθὼν σὺν τόκῳ ἂν ⸂αὐτὸ ἔπραξα. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","καὶ τοῖς παρεστῶσιν εἶπεν· Ἄρατε ἀπʼ αὐτοῦ τὴν μνᾶν καὶ δότε τῷ τὰς δέκα μνᾶς ἔχοντι— ");
INSERT INTO grcsbl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","καὶ εἶπαν αὐτῷ· Κύριε, ἔχει δέκα μνᾶς— ");
INSERT INTO grcsbl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","⸀λέγωὑμῖν ὅτι παντὶ τῷ ἔχοντι δοθήσεται, ἀπὸ δὲ τοῦ μὴ ἔχοντος καὶ ὃ ἔχει ⸀ἀρθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","πλὴν τοὺς ἐχθρούς μου ⸀τούτουςτοὺς μὴ θελήσαντάς με βασιλεῦσαι ἐπʼ αὐτοὺςἀγάγετε ὧδε καὶ κατασφάξατε ⸀αὐτοὺς ἔμπροσθέν μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Καὶ εἰπὼν ταῦτα ἐπορεύετο ἔμπροσθεν ἀναβαίνων εἰς Ἱεροσόλυμα. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Καὶ ἐγένετο ὡς ἤγγισεν εἰς Βηθφαγὴ καὶ Βηθανίαν πρὸς τὸ ὄρος τὸ καλούμενον Ἐλαιῶν, ἀπέστειλεν δύο τῶν ⸀μαθητῶν ");
INSERT INTO grcsbl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","⸀λέγων Ὑπάγετε εἰς τὴν κατέναντι κώμην, ἐν ᾗ εἰσπορευόμενοι εὑρήσετε πῶλον δεδεμένον, ἐφʼ ὃν οὐδεὶς πώποτε ἀνθρώπων ἐκάθισεν, ⸀καὶλύσαντες αὐτὸν ἀγάγετε. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","καὶ ἐάν τις ὑμᾶς ἐρωτᾷ· Διὰ τί λύετε; οὕτως ⸀ἐρεῖτεὅτι Ὁ κύριος αὐτοῦ χρείαν ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ἀπελθόντες δὲ οἱ ἀπεσταλμένοι εὗρον καθὼς εἶπεν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","λυόντων δὲ αὐτῶν τὸν πῶλον εἶπαν οἱ κύριοι αὐτοῦ πρὸς αὐτούς· Τί λύετε τὸν πῶλον; ");
INSERT INTO grcsbl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","οἱ δὲ εἶπαν ⸀ὅτιὉ κύριος αὐτοῦ χρείαν ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","καὶ ἤγαγον αὐτὸν πρὸς τὸν Ἰησοῦν, καὶ ἐπιρίψαντες ⸀αὐτῶντὰ ἱμάτια ἐπὶ τὸν πῶλον ἐπεβίβασαν τὸν Ἰησοῦν· ");
INSERT INTO grcsbl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","πορευομένου δὲ αὐτοῦ ὑπεστρώννυον τὰ ἱμάτια ⸀ἑαυτῶνἐν τῇ ὁδῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ἐγγίζοντος δὲ αὐτοῦ ἤδη πρὸς τῇ καταβάσει τοῦ Ὄρους τῶν Ἐλαιῶν ἤρξαντο ἅπαν τὸ πλῆθος τῶν μαθητῶν χαίροντες αἰνεῖν τὸν θεὸν φωνῇ μεγάλῃ περὶ ⸀πασῶνὧν εἶδον δυνάμεων, ");
INSERT INTO grcsbl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","λέγοντες· Εὐλογημένος ὁ ἐρχόμενος ⸀βασιλεὺςἐν ὀνόματι κυρίου· ⸂ἐν οὐρανῷ εἰρήνη καὶ δόξα ἐν ὑψίστοις. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","καί τινες τῶν Φαρισαίων ἀπὸ τοῦ ὄχλου εἶπαν πρὸς αὐτόν· Διδάσκαλε, ἐπιτίμησον τοῖς μαθηταῖς σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","καὶ ἀποκριθεὶς ⸀εἶπεν Λέγω ὑμῖν, ⸀ὅτιἐὰν οὗτοι ⸀σιωπήσουσιν οἱ λίθοι ⸀κράξουσιν ");
INSERT INTO grcsbl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Καὶ ὡς ἤγγισεν, ἰδὼν τὴν πόλιν ἔκλαυσεν ἐπʼ ⸀αὐτήν ");
INSERT INTO grcsbl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","λέγων ὅτι Εἰ ἔγνως ⸂ἐν τῇ ἡμέρᾳ ταύτῃ καὶ σὺ τὰ πρὸς ⸀εἰρήνην νῦν δὲ ἐκρύβη ἀπὸ ὀφθαλμῶν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ὅτι ἥξουσιν ἡμέραι ἐπὶ σὲ καὶ ⸀παρεμβαλοῦσινοἱ ἐχθροί σου χάρακά σοι καὶ περικυκλώσουσίν σε καὶ συνέξουσίν σε πάντοθεν, ");
INSERT INTO grcsbl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","καὶ ἐδαφιοῦσίν σε καὶ τὰ τέκνα σου ἐν σοί, καὶ οὐκ ἀφήσουσιν ⸂λίθον ἐπὶ λίθον ἐν σοί, ἀνθʼ ὧν οὐκ ἔγνως τὸν καιρὸν τῆς ἐπισκοπῆς σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Καὶ εἰσελθὼν εἰς τὸ ἱερὸν ἤρξατο ἐκβάλλειν τοὺς ⸀πωλοῦντας ");
INSERT INTO grcsbl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","λέγων αὐτοῖς· Γέγραπται· ⸂Καὶ ἔσται ὁ οἶκός μου οἶκος ⸀προσευχῆς ὑμεῖς δὲ αὐτὸν ἐποιήσατε σπήλαιον λῃστῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Καὶ ἦν διδάσκων τὸ καθʼ ἡμέραν ἐν τῷ ἱερῷ· οἱ δὲ ἀρχιερεῖς καὶ οἱ γραμματεῖς ἐζήτουν αὐτὸν ἀπολέσαι καὶ οἱ πρῶτοι τοῦ λαοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","καὶ οὐχ ⸀εὕρισκοντὸ τί ποιήσωσιν, ὁ λαὸς γὰρ ἅπας ἐξεκρέματο αὐτοῦ ἀκούων. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Καὶ ἐγένετο ἐν μιᾷ τῶν ⸀ἡμερῶνδιδάσκοντος αὐτοῦ τὸν λαὸν ἐν τῷ ἱερῷ καὶ εὐαγγελιζομένου ἐπέστησαν οἱ ⸀ἀρχιερεῖςκαὶ οἱ γραμματεῖς σὺν τοῖς πρεσβυτέροις, ");
INSERT INTO grcsbl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","καὶ εἶπαν ⸂λέγοντες πρὸς αὐτόν⸃· Εἰπὸν ἡμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιεῖς, ἢ τίς ἐστιν ὁ δούς σοι τὴν ἐξουσίαν ταύτην; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ἀποκριθεὶς δὲ εἶπεν πρὸς αὐτούς· Ἐρωτήσω ὑμᾶς ⸀κἀγὼλόγον, καὶ εἴπατέ μοι· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Τὸ βάπτισμα Ἰωάννου ἐξ οὐρανοῦ ἦν ἢ ἐξ ἀνθρώπων; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","οἱ δὲ συνελογίσαντο πρὸς ἑαυτοὺς λέγοντες ὅτι Ἐὰν εἴπωμεν· Ἐξ οὐρανοῦ, ἐρεῖ· Διὰ τί οὐκ ἐπιστεύσατε αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ἐὰν δὲ εἴπωμεν· Ἐξ ἀνθρώπων, ⸂ὁ λαὸς ἅπας καταλιθάσει ἡμᾶς, πεπεισμένος γάρ ἐστιν Ἰωάννην προφήτην εἶναι· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","καὶ ἀπεκρίθησαν μὴ εἰδέναι πόθεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","καὶ ὁ Ἰησοῦς εἶπεν αὐτοῖς· Οὐδὲ ἐγὼ λέγω ὑμῖν ἐν ποίᾳ ἐξουσίᾳ ταῦτα ποιῶ. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ἤρξατο δὲ πρὸς τὸν λαὸν λέγειν τὴν παραβολὴν ταύτην· ⸀Ἄνθρωποςἐφύτευσεν ἀμπελῶνα, καὶ ἐξέδετο αὐτὸν γεωργοῖς, καὶ ἀπεδήμησεν χρόνους ἱκανούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","⸀καὶκαιρῷ ἀπέστειλεν πρὸς τοὺς γεωργοὺς δοῦλον, ἵνα ἀπὸ τοῦ καρποῦ τοῦ ἀμπελῶνος ⸀δώσουσιναὐτῷ· οἱ δὲ γεωργοὶ ⸂ἐξαπέστειλαν αὐτὸν δείραντες κενόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","καὶ προσέθετο ⸂ἕτερον πέμψαι δοῦλον· οἱ δὲ κἀκεῖνον δείραντες καὶ ἀτιμάσαντες ἐξαπέστειλαν κενόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","καὶ προσέθετο ⸂τρίτον πέμψαι· οἱ δὲ καὶ τοῦτον τραυματίσαντες ἐξέβαλον. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","εἶπεν δὲ ὁ κύριος τοῦ ἀμπελῶνος· Τί ποιήσω; πέμψω τὸν υἱόν μου τὸν ἀγαπητόν· ἴσως ⸀τοῦτονἐντραπήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ἰδόντες δὲ αὐτὸν οἱ γεωργοὶ διελογίζοντο πρὸς ⸀ἀλλήλουςλέγοντες· Οὗτός ἐστιν ὁ κληρονόμος· ⸀ἀποκτείνωμεναὐτόν, ἵνα ἡμῶν γένηται ἡ κληρονομία· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","καὶ ἐκβαλόντες αὐτὸν ἔξω τοῦ ἀμπελῶνος ἀπέκτειναν. τί οὖν ποιήσει αὐτοῖς ὁ κύριος τοῦ ἀμπελῶνος; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ἐλεύσεται καὶ ἀπολέσει τοὺς γεωργοὺς τούτους, καὶ δώσει τὸν ἀμπελῶνα ἄλλοις. ἀκούσαντες δὲ εἶπαν· Μὴ γένοιτο. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ὁ δὲ ἐμβλέψας αὐτοῖς εἶπεν· Τί οὖν ἐστιν τὸ γεγραμμένον τοῦτο· Λίθον ὃν ἀπεδοκίμασαν οἱ οἰκοδομοῦντες, οὗτος ἐγενήθη εἰς κεφαλὴν γωνίας; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","πᾶς ὁ πεσὼν ἐπʼ ἐκεῖνον τὸν λίθον συνθλασθήσεται· ἐφʼ ὃν δʼ ἂν πέσῃ, λικμήσει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","καὶ ἐζήτησαν οἱ ⸂γραμματεῖς καὶ οἱ ἀρχιερεῖς ἐπιβαλεῖν ἐπʼ αὐτὸν τὰς χεῖρας ἐν αὐτῇ τῇ ὥρᾳ, καὶ ἐφοβήθησαν ⸂τὸν λαόν, ἔγνωσαν γὰρ ὅτι πρὸς αὐτοὺς ⸂εἶπεν τὴν παραβολὴν ταύτην. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Καὶ παρατηρήσαντες ἀπέστειλαν ἐγκαθέτους ὑποκρινομένους ἑαυτοὺς δικαίους εἶναι, ἵνα ἐπιλάβωνται αὐτοῦ λόγου, ⸀ὥστεπαραδοῦναι αὐτὸν τῇ ἀρχῇ καὶ τῇ ἐξουσίᾳ τοῦ ἡγεμόνος. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","καὶ ἐπηρώτησαν αὐτὸν λέγοντες· Διδάσκαλε, οἴδαμεν ὅτι ὀρθῶς λέγεις καὶ διδάσκεις καὶ οὐ λαμβάνεις πρόσωπον, ἀλλʼ ἐπʼ ἀληθείας τὴν ὁδὸν τοῦ θεοῦ διδάσκεις· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ἔξεστιν ⸀ἡμᾶςΚαίσαρι φόρον δοῦναι ἢ οὔ; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","κατανοήσας δὲ αὐτῶν τὴν πανουργίαν εἶπεν πρὸς ⸀αὐτούς ");
INSERT INTO grcsbl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","⸀Δείξατέμοι δηνάριον· τίνος ἔχει εἰκόνα καὶ ἐπιγραφήν; ⸀ἀποκριθέντεςδὲ εἶπαν· Καίσαρος. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ὁ δὲ εἶπεν ⸂πρὸς αὐτούς· Τοίνυν ἀπόδοτε⸃ τὰ Καίσαρος Καίσαρι καὶ τὰ τοῦ θεοῦ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","καὶ οὐκ ἴσχυσαν ἐπιλαβέσθαι ⸀τοῦῥήματος ἐναντίον τοῦ λαοῦ, καὶ θαυμάσαντες ἐπὶ τῇ ἀποκρίσει αὐτοῦ ἐσίγησαν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Προσελθόντες δέ τινες τῶν Σαδδουκαίων, οἱ ⸀ἀντιλέγοντεςἀνάστασιν μὴ εἶναι, ἐπηρώτησαν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","λέγοντες· Διδάσκαλε, Μωϋσῆς ἔγραψεν ἡμῖν, ἐάν τινος ἀδελφὸς ἀποθάνῃ ἔχων γυναῖκα, καὶ οὗτος ἄτεκνος ⸀ᾖ ἵνα λάβῃ ὁ ἀδελφὸς αὐτοῦ τὴν γυναῖκα καὶ ἐξαναστήσῃ σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ἑπτὰ οὖν ἀδελφοὶ ἦσαν· καὶ ὁ πρῶτος λαβὼν γυναῖκα ἀπέθανεν ἄτεκνος· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","καὶ ⸂ὁ δεύτερος ");
INSERT INTO grcsbl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","καὶ ὁ τρίτος ἔλαβεν ⸀αὐτήν ὡσαύτως δὲ καὶ οἱ ἑπτὰ οὐ κατέλιπον τέκνα καὶ ἀπέθανον· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ὕστερον ⸂καὶ ἡ γυνὴ ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","⸂ἡ γυνὴ οὖν ἐν τῇ ἀναστάσει τίνος αὐτῶν γίνεται γυνή; οἱ γὰρ ἑπτὰ ἔσχον αὐτὴν γυναῖκα. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","⸀Καὶεἶπεν αὐτοῖς ὁ Ἰησοῦς· Οἱ υἱοὶ τοῦ αἰῶνος τούτου γαμοῦσιν καὶ ⸀γαμίσκονται ");
INSERT INTO grcsbl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","οἱ δὲ καταξιωθέντες τοῦ αἰῶνος ἐκείνου τυχεῖν καὶ τῆς ἀναστάσεως τῆς ἐκ νεκρῶν οὔτε γαμοῦσιν οὔτε ⸀γαμίζονται ");
INSERT INTO grcsbl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","⸀οὐδὲγὰρ ἀποθανεῖν ἔτι δύνανται, ἰσάγγελοι γάρ εἰσινκαὶ υἱοί ⸀εἰσιν θεοῦ τῆς ἀναστάσεως υἱοὶ ὄντες. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ὅτι δὲ ἐγείρονται οἱ νεκροὶ καὶ Μωϋσῆς ἐμήνυσεν ἐπὶ τῆς βάτου, ὡς λέγει κύριον τὸν θεὸν Ἀβραὰμ ⸀καὶθεὸν Ἰσαὰκ ⸁καὶθεὸν Ἰακώβ· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","θεὸς δὲ οὐκ ἔστιν νεκρῶν ἀλλὰ ζώντων, πάντες γὰρ αὐτῷ ζῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ἀποκριθέντες δέ τινες τῶν γραμματέων εἶπαν· Διδάσκαλε, καλῶς εἶπας· ");
INSERT INTO grcsbl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","οὐκέτι ⸀γὰρἐτόλμων ἐπερωτᾶν αὐτὸν οὐδέν. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Εἶπεν δὲ πρὸς αὐτούς· Πῶς λέγουσιν τὸν χριστὸν ⸂εἶναι Δαυὶδ υἱόν; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","⸂αὐτὸς γὰρ Δαυὶδ λέγει ἐν βίβλῳ ψαλμῶν· ⸀Εἶπενκύριος τῷ κυρίῳ μου· Κάθου ἐκ δεξιῶν μου ");
INSERT INTO grcsbl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Δαυὶδ οὖν ⸂αὐτὸν κύριον καλεῖ, καὶ πῶς ⸂αὐτοῦ υἱός ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ἀκούοντος δὲ παντὸς τοῦ λαοῦ εἶπεν τοῖς ⸀μαθηταῖς ");
INSERT INTO grcsbl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Προσέχετε ἀπὸ τῶν γραμματέων τῶν θελόντων περιπατεῖν ἐν στολαῖς καὶ φιλούντων ἀσπασμοὺς ἐν ταῖς ἀγοραῖς καὶ πρωτοκαθεδρίας ἐν ταῖς συναγωγαῖς καὶ πρωτοκλισίας ἐν τοῖς δείπνοις, ");
INSERT INTO grcsbl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","οἳ κατεσθίουσιν τὰς οἰκίας τῶν χηρῶν καὶ προφάσει μακρὰ προσεύχονται· οὗτοι λήμψονται περισσότερον κρίμα. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ἀναβλέψας δὲ εἶδεν τοὺς βάλλοντας ⸂εἰς τὸ γαζοφυλάκιον τὰ δῶρα αὐτῶν πλουσίους. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","εἶδεν δέ ⸀τιναχήραν πενιχρὰν βάλλουσαν ἐκεῖ ⸂λεπτὰ δύο, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","καὶ εἶπεν· Ἀληθῶς λέγω ὑμῖν ὅτι ἡ χήρα ⸂ἡ πτωχὴ αὕτη πλεῖον πάντων ἔβαλεν· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","⸀πάντεςγὰρ οὗτοι ἐκ τοῦ περισσεύοντος αὐτοῖς ἔβαλον εἰς τὰ ⸀δῶρα αὕτη δὲ ἐκ τοῦ ὑστερήματος αὐτῆς ⸀πάντατὸν βίον ὃν εἶχεν ἔβαλεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Καί τινων λεγόντων περὶ τοῦ ἱεροῦ, ὅτι λίθοις καλοῖς καὶ ἀναθήμασιν κεκόσμηται εἶπεν· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ταῦτα ἃ θεωρεῖτε, ἐλεύσονται ἡμέραι ἐν αἷς οὐκ ἀφεθήσεται λίθος ἐπὶ ⸀λίθῳὃς οὐ καταλυθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ἐπηρώτησαν δὲ αὐτὸν λέγοντες· Διδάσκαλε, πότε οὖν ταῦτα ἔσται, καὶ τί τὸ σημεῖον ὅταν μέλλῃ ταῦτα γίνεσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ὁ δὲ εἶπεν· Βλέπετε μὴ πλανηθῆτε· πολλοὶ γὰρ ἐλεύσονται ἐπὶ τῷ ὀνόματί μου ⸀λέγοντες Ἐγώ εἰμι καί· Ὁ καιρὸς ἤγγικεν· ⸀μὴπορευθῆτε ὀπίσω αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ὅταν δὲ ἀκούσητε πολέμους καὶ ἀκαταστασίας, μὴ πτοηθῆτε· δεῖ γὰρ ταῦτα γενέσθαι πρῶτον, ἀλλʼ οὐκ εὐθέως τὸ τέλος. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","τότε ἔλεγεν αὐτοῖς· Ἐγερθήσεται ἔθνος ἐπʼ ἔθνος καὶ βασιλεία ἐπὶ βασιλείαν, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","σεισμοί τε μεγάλοι ⸂καὶ κατὰ τόπους ⸂λιμοὶ καὶ λοιμοὶ ἔσονται, φόβητρά τε καὶ ⸂σημεῖα ἀπʼ οὐρανοῦ μεγάλα ἔσται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Πρὸ δὲ τούτων πάντων ἐπιβαλοῦσιν ἐφʼ ὑμᾶς τὰςχεῖρας αὐτῶν καὶ διώξουσιν, παραδιδόντες εἰς ⸀τὰς συναγωγὰς καὶ φυλακάς, ⸀ἀπαγομένουςἐπὶ βασιλεῖς καὶ ἡγεμόνας ἕνεκεν τοῦ ὀνόματός μου· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","⸀ἀποβήσεταιὑμῖν εἰς μαρτύριον. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","⸀θέτεοὖν ⸂ἐν ταῖς καρδίαις ὑμῶν μὴ προμελετᾶν ἀπολογηθῆναι, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ἐγὼ γὰρ δώσω ὑμῖν στόμα καὶ σοφίαν ᾗ οὐ δυνήσονται ⸂ἀντιστῆναι ἢ ἀντειπεῖν ⸀ἅπαντεςοἱ ἀντικείμενοι ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","παραδοθήσεσθε δὲ καὶ ὑπὸ γονέων καὶ ⸂ἀδελφῶν καὶ συγγενῶν καὶ φίλων, καὶ θανατώσουσιν ἐξ ὑμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","καὶ ἔσεσθε μισούμενοι ὑπὸ πάντων διὰ τὸ ὄνομά μου. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","καὶ θρὶξ ἐκ τῆς κεφαλῆς ὑμῶν οὐ μὴ ἀπόληται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ἐν τῇ ὑπομονῇ ὑμῶν ⸀κτήσασθετὰς ψυχὰς ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ὅταν δὲ ἴδητε κυκλουμένην ὑπὸ ⸀στρατοπέδωνἸερουσαλήμ, τότε γνῶτε ὅτι ἤγγικεν ἡ ἐρήμωσις αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","τότε οἱ ἐν τῇ Ἰουδαίᾳ φευγέτωσαν εἰς τὰ ὄρη, καὶ οἱ ἐν μέσῳ αὐτῆς ἐκχωρείτωσαν, καὶ οἱ ἐν ταῖς χώραις μὴ εἰσερχέσθωσαν εἰς αὐτήν, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ὅτι ἡμέραι ἐκδικήσεως αὗταί εἰσιν τοῦ πλησθῆναι πάντα τὰ γεγραμμένα. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","⸀οὐαὶταῖς ἐν γαστρὶ ἐχούσαις καὶ ταῖς θηλαζούσαις ἐν ἐκείναις ταῖς ἡμέραις· ἔσται γὰρ ἀνάγκη μεγάλη ἐπὶ τῆς γῆς καὶ ⸀ὀργὴτῷ λαῷ τούτῳ, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","καὶ πεσοῦνται στόματι μαχαίρης καὶ αἰχμαλωτισθήσονται εἰς ⸂τὰ ἔθνη πάντα, καὶ Ἰερουσαλὴμ ἔσται πατουμένη ὑπὸ ἐθνῶν, ἄχρι ⸀οὗ⸀πληρωθῶσινκαιροὶ ἐθνῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Καὶ ⸀ἔσονταισημεῖα ἐν ἡλίῳ καὶ σελήνῃ καὶ ἄστροις, καὶ ἐπὶ τῆς γῆς συνοχὴ ἐθνῶν ἐν ἀπορίᾳ ⸀ἤχουςθαλάσσης καὶ σάλου, ");
INSERT INTO grcsbl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ἀποψυχόντων ἀνθρώπων ἀπὸ φόβου καὶ προσδοκίας τῶν ἐπερχομένων τῇ οἰκουμένῃ, αἱ γὰρ δυνάμεις τῶν οὐρανῶν σαλευθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","καὶ τότε ὄψονται τὸν υἱὸν τοῦ ἀνθρώπου ἐρχόμενον ἐν νεφέλῃ μετὰ δυνάμεως καὶ δόξης πολλῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ἀρχομένων δὲ τούτων γίνεσθαι ἀνακύψατε καὶ ἐπάρατε τὰς κεφαλὰς ὑμῶν, διότι ἐγγίζει ἡ ἀπολύτρωσις ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Καὶ εἶπεν παραβολὴν αὐτοῖς· Ἴδετε τὴν συκῆν καὶ πάντα τὰ δένδρα· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ὅταν προβάλωσιν ἤδη, βλέποντες ἀφʼ ἑαυτῶν γινώσκετε ὅτι ἤδη ἐγγὺς τὸ θέρος ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","οὕτως καὶ ὑμεῖς, ὅταν ἴδητε ταῦτα γινόμενα, γινώσκετε ὅτι ἐγγύς ἐστιν ἡ βασιλεία τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ἀμὴν λέγω ὑμῖν ὅτι οὐ μὴ παρέλθῃ ἡ γενεὰ αὕτη ἕως ἂν πάντα γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ὁ οὐρανὸς καὶ ἡ γῆ ⸀παρελεύσονται οἱ δὲ λόγοι μου οὐ μὴ παρελεύσονται. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Προσέχετε δὲ ἑαυτοῖς μήποτε βαρηθῶσιν ⸂ὑμῶν αἱ καρδίαι ἐν κραιπάλῃ καὶ μέθῃ καὶ μερίμναις βιωτικαῖς, καὶ ⸂ἐπιστῇ ἐφʼ ὑμᾶς αἰφνίδιος ἡ ἡμέρα ἐκείνη ");
INSERT INTO grcsbl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ὡς παγίς· ⸂ἐπεισελεύσεται γὰρ ἐπὶ πάντας τοὺς καθημένους ἐπὶ πρόσωπον πάσης τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ἀγρυπνεῖτε ⸀δὲἐν παντὶ καιρῷ δεόμενοι ἵνα ⸀κατισχύσητεἐκφυγεῖν ⸀ταῦταπάντα τὰ μέλλοντα γίνεσθαι, καὶ σταθῆναι ἔμπροσθεν τοῦ υἱοῦ τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ἦν δὲ τὰς ἡμέρας ⸂ἐν τῷ ἱερῷ διδάσκων, τὰς δὲ νύκτας ἐξερχόμενος ηὐλίζετο εἰς τὸ ὄρος τὸ καλούμενον Ἐλαιῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","καὶ πᾶς ὁ λαὸς ὤρθριζεν πρὸς αὐτὸν ἐν τῷ ἱερῷ ἀκούειν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ἤγγιζεν δὲ ἡ ἑορτὴ τῶν ἀζύμων ἡ λεγομένη Πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","καὶ ἐζήτουν οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς τὸ πῶς ἀνέλωσιν αὐτόν, ἐφοβοῦντο γὰρ τὸν λαόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Εἰσῆλθεν δὲ Σατανᾶς εἰς Ἰούδαν τὸν ⸀καλούμενονἸσκαριώτην, ὄντα ἐκ τοῦ ἀριθμοῦ τῶν δώδεκα· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","καὶ ἀπελθὼν συνελάλησεν τοῖς ἀρχιερεῦσιν καὶ στρατηγοῖς τὸ πῶς ⸂αὐτοῖς παραδῷ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","καὶ ἐχάρησαν καὶ συνέθεντο αὐτῷ ἀργύριον δοῦναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","καὶ ἐξωμολόγησεν, καὶ ἐζήτει εὐκαιρίαν τοῦ παραδοῦναι αὐτὸν ⸂ἄτερ ὄχλου αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ἦλθεν δὲ ἡ ἡμέρα τῶν ἀζύμων, ⸀ᾗἔδει θύεσθαι τὸ πάσχα· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","καὶ ἀπέστειλεν Πέτρον καὶ Ἰωάννην εἰπών· Πορευθέντες ἑτοιμάσατε ἡμῖν τὸ πάσχα ἵνα φάγωμεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","οἱ δὲ εἶπαν αὐτῷ· Ποῦ θέλεις ⸀ἑτοιμάσωμεν ");
INSERT INTO grcsbl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ὁ δὲ εἶπεν αὐτοῖς· Ἰδοὺ εἰσελθόντων ὑμῶν εἰς τὴν πόλιν συναντήσει ὑμῖν ἄνθρωπος κεράμιον ὕδατος βαστάζων· ἀκολουθήσατε αὐτῷ εἰς τὴν οἰκίαν ⸂εἰς ἣν εἰσπορεύεται. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","καὶ ἐρεῖτε τῷ οἰκοδεσπότῃ τῆς οἰκίας· Λέγει σοι ὁ διδάσκαλος· Ποῦ ἐστιν τὸ κατάλυμα ὅπου τὸ πάσχα μετὰ τῶν μαθητῶν μου φάγω; ");
INSERT INTO grcsbl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","κἀκεῖνος ὑμῖν δείξει ἀνάγαιον μέγα ἐστρωμένον· ἐκεῖ ἑτοιμάσατε. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ἀπελθόντες δὲ εὗρον καθὼς ⸀εἰρήκειαὐτοῖς, καὶ ἡτοίμασαν τὸ πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Καὶ ὅτε ἐγένετο ἡ ὥρα, ἀνέπεσεν καὶ ⸀οἱἀπόστολοι σὺν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","καὶ εἶπεν πρὸς αὐτούς· Ἐπιθυμίᾳ ἐπεθύμησα τοῦτο τὸ πάσχα φαγεῖν μεθʼ ὑμῶν πρὸ τοῦ με παθεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","λέγω γὰρ ὑμῖν ⸀ὅτιοὐ μὴ φάγω ⸀αὐτὸἕως ὅτου πληρωθῇ ἐν τῇ βασιλείᾳ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","καὶ δεξάμενος ποτήριον εὐχαριστήσας εἶπεν· Λάβετε τοῦτο καὶ διαμερίσατε ⸂εἰς ἑαυτούς· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","λέγω γὰρ ὑμῖν, ⸀οὐμὴ πίω ἀπὸ τοῦ ⸂νῦν ἀπὸ τοῦ γενήματος τῆς ἀμπέλου ἕως ⸀οὗἡ βασιλεία τοῦ θεοῦ ἔλθῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","καὶ λαβὼν ἄρτον εὐχαριστήσας ἔκλασεν καὶ ἔδωκεν αὐτοῖς λέγων· Τοῦτό ἐστιν τὸ σῶμά μου ⸂τὸ ὑπὲρ ὑμῶν διδόμενον· τοῦτο ποιεῖτε εἰς τὴν ἐμὴν ἀνάμνησιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","⸄καὶ τὸ ποτήριον ὡσαύτως⸅ μετὰ τὸ δειπνῆσαι, λέγων· Τοῦτο τὸ ποτήριον ἡ καινὴ διαθήκη ἐν τῷ αἵματί μου, τὸ ὑπὲρ ὑμῶν ἐκχυννόμενον⸃. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","πλὴν ἰδοὺ ἡ χεὶρ τοῦ παραδιδόντος με μετʼ ἐμοῦ ἐπὶ τῆς τραπέζης· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","⸂ὅτι ὁ υἱὸς μὲν τοῦ ἀνθρώπου ⸂κατὰ τὸ ὡρισμένον πορεύεται, πλὴν οὐαὶ τῷ ἀνθρώπῳ ἐκείνῳ διʼ οὗ παραδίδοται. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","καὶ αὐτοὶ ἤρξαντο συζητεῖν πρὸς ἑαυτοὺς τὸ τίς ἄρα εἴη ἐξ αὐτῶν ὁ τοῦτο μέλλων πράσσειν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ἐγένετο δὲ καὶ φιλονεικία ἐν αὐτοῖς, τὸ τίς αὐτῶν δοκεῖ εἶναι μείζων. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ὁ δὲ εἶπεν αὐτοῖς· Οἱ βασιλεῖς τῶν ἐθνῶν κυριεύουσιν αὐτῶν καὶ οἱ ἐξουσιάζοντες αὐτῶν εὐεργέται καλοῦνται. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ὑμεῖς δὲ οὐχ οὕτως, ἀλλʼ ὁ μείζων ἐν ὑμῖν ⸀γινέσθωὡς ὁ νεώτερος, καὶ ὁ ἡγούμενος ὡς ὁ διακονῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","τίς γὰρ μείζων, ὁ ἀνακείμενος ἢ ὁ διακονῶν; οὐχὶ ὁ ἀνακείμενος; ἐγὼ δὲ ⸂ἐν μέσῳ ὑμῶν εἰμι ὡς ὁ διακονῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ὑμεῖς δέ ἐστε οἱ διαμεμενηκότες μετʼ ἐμοῦ ἐν τοῖς πειρασμοῖς μου· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","κἀγὼ διατίθεμαι ὑμῖν, καθὼς διέθετό μοι ὁ πατήρ μου βασιλείαν, ");
INSERT INTO grcsbl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ἵνα ⸀ἔσθητεκαὶ πίνητε ἐπὶ τῆς τραπέζης μου ⸂ἐν τῇ βασιλείᾳ μου, καὶ ⸀καθήσεσθεἐπὶ θρόνων ⸂τὰς δώδεκα φυλὰς κρίνοντες τοῦ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","⸀ΣίμωνΣίμων, ἰδοὺ ὁ Σατανᾶς ἐξῃτήσατο ὑμᾶς τοῦ σινιάσαι ὡς τὸν σῖτον· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ἐγὼ δὲ ἐδεήθην περὶ σοῦ ἵνα μὴ ἐκλίπῃ ἡ πίστις σου· καὶ σύ ποτε ἐπιστρέψας ⸀στήρισοντοὺς ἀδελφούς σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ὁ δὲ εἶπεν αὐτῷ· Κύριε, μετὰ σοῦ ἕτοιμός εἰμι καὶ εἰς φυλακὴν καὶ εἰς θάνατον πορεύεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ὁ δὲ εἶπεν· Λέγω σοι, Πέτρε, οὐ ⸀φωνήσεισήμερον ἀλέκτωρ ⸀ἕωςτρίς ⸂με ἀπαρνήσῃ εἰδέναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Καὶ εἶπεν αὐτοῖς· Ὅτε ἀπέστειλα ὑμᾶς ἄτερ βαλλαντίου καὶ πήρας καὶ ὑποδημάτων, μή τινος ὑστερήσατε; οἱ δὲ εἶπαν· Οὐθενός. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","εἶπεν ⸀δὲαὐτοῖς· Ἀλλὰ νῦν ὁ ἔχων βαλλάντιον ἀράτω, ὁμοίως καὶ πήραν, καὶ ὁ μὴ ἔχων ⸀πωλησάτωτὸ ἱμάτιον αὐτοῦ καὶ ⸀ἀγορασάτωμάχαιραν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","λέγω γὰρ ὑμῖν ⸀ὅτιτοῦτο τὸγεγραμμένον δεῖ τελεσθῆναι ἐν ἐμοί, τό· Καὶ μετὰ ἀνόμων ἐλογίσθη· καὶ γὰρ ⸀τὸ περὶ ἐμοῦ τέλος ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","οἱ δὲ εἶπαν· Κύριε, ἰδοὺ μάχαιραι ὧδε δύο. ὁ δὲ εἶπεν αὐτοῖς· Ἱκανόν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Καὶ ἐξελθὼν ἐπορεύθη κατὰ τὸ ἔθος εἰς τὸ Ὄρος τῶν Ἐλαιῶν· ἠκολούθησαν δὲ αὐτῷ καὶ οἱ ⸀μαθηταί ");
INSERT INTO grcsbl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","γενόμενος δὲ ἐπὶ τοῦ τόπου εἶπεν αὐτοῖς· Προσεύχεσθε μὴ εἰσελθεῖν εἰς πειρασμόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","καὶ αὐτὸς ἀπεσπάσθη ἀπʼ αὐτῶν ὡσεὶ λίθου βολήν, καὶ θεὶς τὰ γόνατα προσηύχετο ");
INSERT INTO grcsbl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","λέγων· Πάτερ, εἰ βούλει ⸀παρένεγκε⸂τοῦτο τὸ ποτήριον ἀπʼ ἐμοῦ· πλὴν μὴ τὸ θέλημά μου ἀλλὰ τὸ σὸν ⸀γινέσθω ");
INSERT INTO grcsbl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","⸂ὤφθη δὲ αὐτῷ ἄγγελος ⸀ἀπʼ οὐρανοῦ ἐνισχύων αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","καὶ γενόμενος ἐν ἀγωνίᾳ ἐκτενέστερον προσηύχετο· ⸄καὶ ἐγένετο⸅ ὁ ἱδρὼς αὐτοῦ ὡσεὶ θρόμβοι αἵματος καταβαίνοντες ἐπὶ τὴν γῆν.⸃ ");
INSERT INTO grcsbl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","καὶ ἀναστὰς ἀπὸ τῆς προσευχῆς ἐλθὼν πρὸς τοὺς μαθητὰς εὗρεν ⸂κοιμωμένους αὐτοὺς ἀπὸ τῆς λύπης, ");
INSERT INTO grcsbl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","καὶ εἶπεν αὐτοῖς· Τί καθεύδετε; ἀναστάντες προσεύχεσθε, ἵνα μὴ εἰσέλθητε εἰς πειρασμόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","⸀Ἔτιαὐτοῦ λαλοῦντος ἰδοὺ ὄχλος, καὶ ὁ λεγόμενος Ἰούδας εἷς τῶν δώδεκα προήρχετο αὐτούς, καὶ ἤγγισεν τῷ Ἰησοῦ φιλῆσαι αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","⸂Ἰησοῦς δὲ εἶπεν αὐτῷ· Ἰούδα, φιλήματι τὸν υἱὸν τοῦ ἀνθρώπου παραδίδως; ");
INSERT INTO grcsbl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ἰδόντες δὲ οἱ περὶ αὐτὸν τὸ ἐσόμενον ⸀εἶπαν Κύριε, εἰ πατάξομεν ἐν μαχαίρῃ; ");
INSERT INTO grcsbl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","καὶ ἐπάταξεν εἷς τις ἐξ αὐτῶν ⸂τοῦ ἀρχιερέως τὸν δοῦλον καὶ ἀφεῖλεν ⸂τὸ οὖς αὐτοῦ τὸ δεξιόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ἀποκριθεὶς δὲ ὁ Ἰησοῦς εἶπεν· Ἐᾶτε ἕως τούτου· καὶ ἁψάμενος τοῦ ⸀ὠτίουἰάσατο αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","εἶπεν ⸀δὲἸησοῦς πρὸς τοὺς παραγενομένους ἐπʼ αὐτὸν ἀρχιερεῖς καὶ στρατηγοὺς τοῦ ἱεροῦ καὶ πρεσβυτέρους· Ὡς ἐπὶ λῃστὴν ⸀ἐξήλθατεμετὰ μαχαιρῶν καὶ ξύλων; ");
INSERT INTO grcsbl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","καθʼ ἡμέραν ὄντος μου μεθʼ ὑμῶν ἐν τῷ ἱερῷ οὐκ ἐξετείνατε τὰς χεῖρας ἐπʼ ἐμέ· ἀλλʼ αὕτη ⸂ἐστὶν ὑμῶν ἡ ὥρα καὶ ἡ ἐξουσία τοῦ σκότους. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Συλλαβόντες δὲ αὐτὸν ἤγαγον καὶ ⸀εἰσήγαγονεἰς ⸂τὴν οἰκίαν τοῦ ἀρχιερέως· ὁ δὲ Πέτρος ἠκολούθει μακρόθεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","⸀περιαψάντωνδὲ πῦρ ἐν μέσῳ τῆς αὐλῆς καὶ ⸀συγκαθισάντωνἐκάθητο ὁ Πέτρος ⸀μέσοςαὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ἰδοῦσα δὲ αὐτὸν παιδίσκη τις καθήμενον πρὸς τὸ φῶς καὶ ἀτενίσασα αὐτῷ εἶπεν· Καὶ οὗτος σὺν αὐτῷ ἦν· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ὁ δὲ ⸀ἠρνήσατολέγων· ⸂Οὐκ οἶδα αὐτόν, γύναι⸃. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","καὶ μετὰ βραχὺ ἕτερος ἰδὼν αὐτὸν ἔφη Καὶ σὺ ἐξ αὐτῶν εἶ· ὁ δὲ Πέτρος ⸀ἔφη· Ἄνθρωπε, οὐκ εἰμί. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","καὶ διαστάσης ὡσεὶ ὥρας μιᾶς ἄλλος τις διϊσχυρίζετο λέγων· Ἐπʼ ἀληθείας καὶ οὗτος μετʼ αὐτοῦ ἦν, καὶ γὰρ Γαλιλαῖός ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","εἶπεν δὲ ὁ Πέτρος· Ἄνθρωπε, οὐκ οἶδα ὃ λέγεις. καὶ παραχρῆμα ἔτι λαλοῦντος αὐτοῦ ἐφώνησεν ἀλέκτωρ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","καὶ στραφεὶς ὁ κύριος ἐνέβλεψεν τῷ Πέτρῳ, καὶ ὑπεμνήσθη ὁ Πέτρος τοῦ ⸀λόγουτοῦ κυρίου ὡς εἶπεν αὐτῷ ὅτι Πρὶν ἀλέκτορα φωνῆσαι ⸀σήμερονἀπαρνήσῃ με τρίς. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","καὶ ἐξελθὼν ⸀ἔξωἔκλαυσεν πικρῶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Καὶ οἱ ἄνδρες οἱ συνέχοντες ⸀αὐτὸνἐνέπαιζον αὐτῷ δέροντες, ");
INSERT INTO grcsbl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","καὶ περικαλύψαντες ⸂αὐτὸν ἐπηρώτων λέγοντες· Προφήτευσον, τίς ἐστιν ὁ παίσας σε; ");
INSERT INTO grcsbl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","καὶ ἕτερα πολλὰ βλασφημοῦντες ἔλεγον εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Καὶ ὡς ἐγένετο ἡμέρα, συνήχθη τὸ πρεσβυτέριον τοῦ λαοῦ, ἀρχιερεῖς ⸀τεκαὶ γραμματεῖς, καὶ ⸀ἀπήγαγοναὐτὸν εἰς τὸ συνέδριον αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","λέγοντες· Εἰ σὺ εἶ ὁ χριστός, εἰπὸν ἡμῖν. εἶπεν δὲ αὐτοῖς· Ἐὰν ὑμῖν εἴπω οὐ μὴ πιστεύσητε· ");
INSERT INTO grcsbl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ἐὰν ⸀δὲἐρωτήσω, οὐ μὴ ⸀ἀποκριθῆτε ");
INSERT INTO grcsbl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ἀπὸ τοῦ νῦν ⸀δὲἔσται ὁ υἱὸς τοῦ ἀνθρώπου καθήμενος ἐκ δεξιῶν τῆς δυνάμεως τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","εἶπαν δὲ πάντες· Σὺ οὖν εἶ ὁ υἱὸς τοῦ θεοῦ; ὁ δὲ πρὸς αὐτοὺς ἔφη· Ὑμεῖς λέγετε ὅτι ἐγώ εἰμι. ");
INSERT INTO grcsbl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","οἱ δὲ εἶπαν· Τί ἔτι ⸂ἔχομεν μαρτυρίας χρείαν; αὐτοὶ γὰρ ἠκούσαμεν ἀπὸ τοῦ στόματος αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Καὶ ἀναστὰν ἅπαν τὸ πλῆθος αὐτῶν ἤγαγον αὐτὸν ἐπὶ τὸν Πιλᾶτον. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ἤρξαντο δὲ κατηγορεῖν αὐτοῦ λέγοντες· Τοῦτον εὕραμεν διαστρέφοντα τὸ ἔθνος ⸀ἡμῶνκαὶ κωλύοντα ⸂φόρους Καίσαρι διδόναι ⸀καὶλέγοντα ⸀αὑτὸνχριστὸν βασιλέα εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ὁ δὲ Πιλᾶτος ⸀ἠρώτησεναὐτὸν λέγων· Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; ὁ δὲ ἀποκριθεὶς αὐτῷ ἔφη· Σὺ λέγεις. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ὁ δὲ Πιλᾶτος εἶπεν πρὸς τοὺς ἀρχιερεῖς καὶ τοὺς ὄχλους· Οὐδὲν εὑρίσκω αἴτιον ἐν τῷ ἀνθρώπῳ τούτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","οἱ δὲ ἐπίσχυον λέγοντες ὅτι Ἀνασείει τὸν λαὸν διδάσκων καθʼ ὅλης τῆς Ἰουδαίας, ⸀καὶἀρξάμενος ἀπὸ τῆς Γαλιλαίας ἕως ὧδε. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Πιλᾶτος δὲ ⸀ἀκούσαςἐπηρώτησεν εἰ ὁ ἄνθρωπος Γαλιλαῖός ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","καὶ ἐπιγνοὺς ὅτι ἐκ τῆς ἐξουσίας Ἡρῴδου ἐστὶν ἀνέπεμψεν αὐτὸν πρὸς Ἡρῴδην, ὄντα καὶ αὐτὸν ἐν Ἱεροσολύμοις ἐν ταύταις ταῖς ἡμέραις. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ὁ δὲ Ἡρῴδης ἰδὼν τὸν Ἰησοῦν ἐχάρη λίαν, ἦν γὰρ ⸂ἐξ ἱκανῶν χρόνων θέλων ἰδεῖν αὐτὸν διὰ τὸ ⸀ἀκούεινπερὶ αὐτοῦ, καὶ ἤλπιζέν τι σημεῖον ἰδεῖν ὑπʼ αὐτοῦ γινόμενον. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ἐπηρώτα δὲ αὐτὸν ἐν λόγοις ἱκανοῖς· αὐτὸς δὲ οὐδὲν ἀπεκρίνατο αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","εἱστήκεισαν δὲ οἱ ἀρχιερεῖς καὶ οἱ γραμματεῖς εὐτόνως κατηγοροῦντες αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ἐξουθενήσας δὲ αὐτὸν ⸀καὶὁ Ἡρῴδης σὺν τοῖς στρατεύμασιν αὐτοῦ καὶ ἐμπαίξας ⸀περιβαλὼνἐσθῆτα λαμπρὰν ἀνέπεμψεν αὐτὸν τῷ Πιλάτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ἐγένοντο δὲ φίλοι ὅ τε ⸂Ἡρῴδης καὶ ὁ Πιλᾶτος ἐν αὐτῇ τῇ ἡμέρᾳ μετʼ ἀλλήλων· προϋπῆρχον γὰρ ἐν ἔχθρᾳ ὄντες πρὸς ⸀αὑτούς ");
INSERT INTO grcsbl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Πιλᾶτος δὲ συγκαλεσάμενος τοὺς ἀρχιερεῖς καὶ τοὺς ἄρχοντας καὶ τὸν λαὸν ");
INSERT INTO grcsbl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","εἶπεν πρὸς αὐτούς· Προσηνέγκατέ μοι τὸν ἄνθρωπον τοῦτον ὡς ἀποστρέφοντα τὸν λαόν, καὶ ἰδοὺ ἐγὼ ἐνώπιον ὑμῶν ἀνακρίνας ⸀οὐθὲνεὗρον ἐν τῷ ἀνθρώπῳ τούτῳ αἴτιον ὧν κατηγορεῖτε κατʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ἀλλʼ οὐδὲ Ἡρῴδης, ⸂ἀνέπεμψεν γὰρ αὐτὸν πρὸς ἡμᾶς· καὶ ἰδοὺ οὐδὲν ἄξιον θανάτου ἐστὶν πεπραγμένον αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","παιδεύσας οὖν αὐτὸν ⸀ἀπολύσω ");
INSERT INTO grcsbl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","⸀Ἀνέκραγονδὲ παμπληθεὶ λέγοντες· Αἶρε τοῦτον, ἀπόλυσον δὲ ἡμῖν ⸀τὸνΒαραββᾶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ὅστις ἦν διὰ στάσιν τινὰ γενομένην ἐν τῇ πόλει καὶ φόνον ⸂βληθεὶς ἐν τῇ φυλακῇ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","πάλιν ⸀δὲὁ Πιλᾶτος ⸀προσεφώνησεν, θέλων ἀπολῦσαι τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","οἱ δὲ ἐπεφώνουν λέγοντες· ⸂Σταύρου σταύρου αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ὁ δὲ τρίτον εἶπεν πρὸς αὐτούς· Τί γὰρ κακὸν ἐποίησεν οὗτος; οὐδὲν αἴτιον θανάτου εὗρον ἐν αὐτῷ· παιδεύσας οὖν αὐτὸν ἀπολύσω. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","οἱ δὲ ἐπέκειντο φωναῖς μεγάλαις αἰτούμενοι αὐτὸν σταυρωθῆναι, καὶ κατίσχυον αἱ φωναὶ ⸀αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","⸀καὶΠιλᾶτος ἐπέκρινεν γενέσθαι τὸ αἴτημα αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ἀπέλυσεν δὲ τὸν διὰ στάσιν καὶ φόνον βεβλημένον ⸀εἰςφυλακὴν ὃν ᾐτοῦντο, τὸν δὲ Ἰησοῦν παρέδωκεν τῷ θελήματι αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Καὶ ὡς ἀπήγαγον αὐτόν, ἐπιλαβόμενοι ⸂Σίμωνά τινα Κυρηναῖον ἐρχόμενον ἀπʼ ἀγροῦ ἐπέθηκαν αὐτῷ τὸν σταυρὸν φέρειν ὄπισθεν τοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ἠκολούθει δὲ αὐτῷ πολὺ πλῆθος τοῦ λαοῦ καὶ γυναικῶν ⸀αἳἐκόπτοντο καὶ ἐθρήνουν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","στραφεὶς δὲ πρὸς αὐτὰς ⸀ὁἸησοῦς εἶπεν· Θυγατέρες Ἰερουσαλήμ, μὴ κλαίετε ἐπʼ ἐμέ· πλὴν ἐφʼ ἑαυτὰς κλαίετε καὶ ἐπὶ τὰ τέκνα ὑμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ὅτι ἰδοὺ ἔρχονται ἡμέραι ἐν αἷς ἐροῦσιν Μακάριαι αἱστεῖραι καὶ ⸀αἱ κοιλίαι αἳ οὐκ ἐγέννησαν καὶ μαστοὶ οἳ οὐκ ⸀ἔθρεψαν ");
INSERT INTO grcsbl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","τότε ἄρξονται λέγειν τοῖς ὄρεσιν· Πέσετε ἐφʼ ἡμᾶς, καὶ τοῖς βουνοῖς· Καλύψατε ἡμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ὅτι εἰ ἐν ⸀τῷὑγρῷ ξύλῳ ταῦτα ποιοῦσιν, ἐν τῷ ξηρῷ τί γένηται; ");
INSERT INTO grcsbl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ἤγοντο δὲ καὶ ἕτεροι ⸂κακοῦργοι δύο σὺν αὐτῷ ἀναιρεθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","καὶ ὅτε ⸀ἦλθονἐπὶ τὸν τόπον τὸν καλούμενον Κρανίον, ἐκεῖ ἐσταύρωσαν αὐτὸν καὶ τοὺς κακούργους, ὃν μὲν ἐκ δεξιῶν ὃν δὲ ἐξ ἀριστερῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","⸂ὁ δὲ Ἰησοῦς ἔλεγεν· Πάτερ, ἄφες αὐτοῖς, οὐ γὰρ οἴδασιν τί ποιοῦσιν⸃ διαμεριζόμενοι δὲ τὰ ἱμάτια αὐτοῦ ἔβαλον ⸀κλήρους ");
INSERT INTO grcsbl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","καὶ εἱστήκει ὁ λαὸς θεωρῶν. ἐξεμυκτήριζον δὲ καὶ οἱ ⸀ἄρχοντεςλέγοντες· Ἄλλους ἔσωσεν, σωσάτω ἑαυτόν, εἰ οὗτός ἐστιν ὁ χριστὸς ⸂τοῦ θεοῦ, ὁ⸃ ἐκλεκτός. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","⸀ἐνέπαιξανδὲ αὐτῷ καὶ οἱ στρατιῶται προσερχόμενοι, ⸀ὄξοςπροσφέροντες αὐτῷ ");
INSERT INTO grcsbl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","καὶ λέγοντες· Εἰ σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων, σῶσον σεαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ἦν δὲ καὶ ⸀ἐπιγραφὴἐπʼ ⸀αὐτῷ Ὁ βασιλεὺς τῶν Ἰουδαίων ⸀οὗτος ");
INSERT INTO grcsbl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Εἷς δὲ τῶν κρεμασθέντων κακούργων ἐβλασφήμει αὐτόν ⸀λέγων ⸀Οὐχὶσὺ εἶ ὁ χριστός; σῶσον σεαυτὸν καὶ ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ἀποκριθεὶς δὲ ὁ ἕτερος ⸂ἐπιτιμῶν αὐτῷ ἔφη· Οὐδὲ φοβῇ σὺ τὸν θεόν, ὅτι ἐν τῷ αὐτῷ κρίματι εἶ; ");
INSERT INTO grcsbl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","καὶ ἡμεῖς μὲν δικαίως, ἄξια γὰρ ὧν ἐπράξαμεν ἀπολαμβάνομεν· οὗτος δὲ οὐδὲν ἄτοπον ἔπραξεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","καὶ ⸀ἔλεγεν Ἰησοῦ, μνήσθητί ⸀μουὅταν ἔλθῃς ⸂ἐν τῇ βασιλείᾳ σου. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","καὶ εἶπεν ⸀αὐτῷ Ἀμήν ⸂σοι λέγω σήμερον μετʼ ἐμοῦ ἔσῃ ἐν τῷ παραδείσῳ. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","⸂Καὶ ἦν ⸀ἤδηὡσεὶ ὥρα ἕκτη καὶ σκότος ἐγένετο ἐφʼ ὅλην τὴν γῆν ἕως ὥρας ἐνάτης ");
INSERT INTO grcsbl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","⸂τοῦ ἡλίου ἐκλιπόντος, ἐσχίσθη ⸀δὲτὸ καταπέτασμα τοῦ ναοῦ μέσον. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","καὶ φωνήσας φωνῇ μεγάλῃ ὁ Ἰησοῦς εἶπεν· Πάτερ, εἰς χεῖράς σου ⸀παρατίθεμαιτὸ πνεῦμά μου. ⸂τοῦτο δὲ εἰπὼν ἐξέπνευσεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ἰδὼν δὲ ὁ ἑκατοντάρχης τὸ γενόμενον ⸀ἐδόξαζεντὸν θεὸν λέγων· Ὄντως ὁ ἄνθρωπος οὗτος δίκαιος ἦν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","καὶ πάντες οἱ συμπαραγενόμενοι ὄχλοι ἐπὶ τὴν θεωρίαν ταύτην, ⸀θεωρήσαντεςτὰ γενόμενα, ⸀τύπτοντεςτὰ στήθη ὑπέστρεφον. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","εἱστήκεισαν δὲ πάντες οἱ γνωστοὶ ⸀αὐτῷ⸀μακρόθεν καὶ γυναῖκες αἱ ⸀συνακολουθοῦσαιαὐτῷ ἀπὸ τῆς Γαλιλαίας, ὁρῶσαι ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Καὶ ἰδοὺ ἀνὴρὀνόματι Ἰωσὴφ βουλευτὴς ὑπάρχων, ⸀ἀνὴρ ἀγαθὸς καὶ δίκαιος— ");
INSERT INTO grcsbl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","οὗτος οὐκ ἦν συγκατατεθειμένος τῇ βουλῇ καὶ τῇ πράξει αὐτῶν— ἀπὸ Ἁριμαθαίας πόλεως τῶν Ἰουδαίων, ὃς ⸀προσεδέχετοτὴν βασιλείαν τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","οὗτος προσελθὼν τῷ Πιλάτῳ ᾐτήσατο τὸ σῶμα τοῦ Ἰησοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","καὶ ⸀καθελὼνἐνετύλιξεν αὐτὸ σινδόνι, καὶ ἔθηκεν ⸀αὐτὸνἐν μνήματι λαξευτῷ οὗ οὐκ ἦν ⸂οὐδεὶς οὔπω κείμενος. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","καὶ ἡμέρα ἦν ⸂παρασκευῆς, καὶ⸃ σάββατον ἐπέφωσκεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","κατακολουθήσασαι δὲ ⸀αἱγυναῖκες, αἵτινες ἦσαν συνεληλυθυῖαι ⸂ἐκ τῆς Γαλιλαίας αὐτῷ, ἐθεάσαντο τὸ μνημεῖον καὶ ὡς ἐτέθη τὸ σῶμα αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ὑποστρέψασαι δὲ ἡτοίμασαν ἀρώματα καὶ μύρα. Καὶ τὸ μὲν σάββατον ἡσύχασαν κατὰ τὴν ἐντολήν, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","τῇ δὲ μιᾷ τῶν σαββάτων ὄρθρου βαθέως ⸂ἐπὶ τὸ μνῆμα ἦλθον φέρουσαι ἃ ἡτοίμασαν ⸀ἀρώματα ");
INSERT INTO grcsbl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","εὗρον δὲ τὸν λίθον ἀποκεκυλισμένον ἀπὸ τοῦ μνημείου, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","⸂εἰσελθοῦσαι δὲ οὐχ εὗρον τὸ ⸀σῶμα ");
INSERT INTO grcsbl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","καὶ ἐγένετο ἐν τῷ ⸀ἀπορεῖσθαιαὐτὰς περὶ τούτου καὶ ἰδοὺ ἄνδρες δύο ἐπέστησαν αὐταῖς ἐν ⸂ἐσθῆτι ἀστραπτούσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ἐμφόβων δὲ γενομένων αὐτῶν καὶ κλινουσῶν ⸂τὰ πρόσωπα εἰς τὴν γῆν εἶπαν πρὸς αὐτάς· Τί ζητεῖτε τὸν ζῶντα μετὰ τῶν νεκρῶν; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","⸂οὐκ ἔστιν ὧδε, ἀλλὰ ἠγέρθη.⸃ μνήσθητε ὡς ἐλάλησεν ὑμῖν ἔτι ὢν ἐν τῇ Γαλιλαίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","λέγων ⸂τὸν υἱὸν τοῦ ἀνθρώπου ὅτι δεῖ παραδοθῆναι εἰς χεῖρας ἀνθρώπων ἁμαρτωλῶν καὶ σταυρωθῆναι καὶ τῇ τρίτῃ ἡμέρᾳ ἀναστῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","καὶ ἐμνήσθησαν τῶν ῥημάτων αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","καὶ ὑποστρέψασαι ἀπὸ τοῦ μνημείου ἀπήγγειλαν ταῦτα πάντα τοῖς ἕνδεκα καὶ πᾶσιν τοῖς λοιποῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ἦσαν δὲ ἡ Μαγδαληνὴ Μαρία καὶ Ἰωάννα καὶ Μαρία ⸀ἡ Ἰακώβου καὶ αἱ λοιπαὶ σὺν αὐταῖς· ⸀ἔλεγονπρὸς τοὺς ἀποστόλους ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","καὶ ἐφάνησαν ἐνώπιον αὐτῶν ὡσεὶ λῆρος τὰ ῥήματα ⸀ταῦτα καὶ ἠπίστουν αὐταῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","⸂Ὁ δὲ Πέτρος ἀναστὰς ἔδραμεν ἐπὶ τὸ μνημεῖον· καὶ παρακύψας βλέπει τὰ ⸀ὀθόνια μόνα· καὶ ἀπῆλθεν πρὸς ⸀αὑτὸν θαυμάζων τὸ γεγονός ");
INSERT INTO grcsbl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Καὶ ἰδοὺ δύο ἐξ αὐτῶν ⸂ἐν αὐτῇ τῇ ἡμέρᾳ ἦσαν πορευόμενοι εἰς κώμην ἀπέχουσαν σταδίους ἑξήκοντα ἀπὸ Ἰερουσαλήμ, ᾗ ὄνομα Ἐμμαοῦς, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","καὶ αὐτοὶ ὡμίλουν πρὸς ἀλλήλους περὶ πάντων τῶν συμβεβηκότων τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","καὶ ἐγένετο ἐν τῷ ὁμιλεῖν αὐτοὺς καὶ συζητεῖν καὶ ⸀αὐτὸςἸησοῦς ἐγγίσας συνεπορεύετο αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","οἱ δὲ ὀφθαλμοὶ αὐτῶν ἐκρατοῦντο τοῦ μὴ ἐπιγνῶναι αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","εἶπεν δὲ πρὸς αὐτούς· Τίνες οἱ λόγοι οὗτοι οὓς ἀντιβάλλετε πρὸς ἀλλήλους περιπατοῦντες; καὶ ⸀ἐστάθησανσκυθρωποί. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ἀποκριθεὶς δὲ ⸂εἷς ὀνόματι Κλεοπᾶς εἶπεν πρὸς αὐτόν· Σὺ μόνος παροικεῖς Ἰερουσαλὴμ καὶ οὐκ ἔγνως τὰ γενόμενα ἐν αὐτῇ ἐν ταῖς ἡμέραις ταύταις; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","καὶ εἶπεν αὐτοῖς· Ποῖα; οἱ δὲ εἶπαν αὐτῷ· Τὰ περὶ Ἰησοῦ τοῦ ⸀Ναζαρηνοῦ ὃς ἐγένετο ἀνὴρ προφήτης δυνατὸς ἐν ἔργῳ καὶ λόγῳ ἐναντίον τοῦ θεοῦ καὶ παντὸς τοῦ λαοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ὅπως τε παρέδωκαν αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ ἄρχοντες ἡμῶν εἰς κρίμα θανάτου καὶ ἐσταύρωσαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ἡμεῖς δὲ ἠλπίζομεν ὅτι αὐτός ἐστιν ὁ μέλλων λυτροῦσθαι τὸν Ἰσραήλ· ἀλλά γε ⸀καὶσὺν πᾶσιν τούτοις τρίτην ταύτην ἡμέραν ⸀ἄγειἀφʼ οὗ ταῦτα ἐγένετο. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ἀλλὰ καὶ γυναῖκές τινες ἐξ ἡμῶν ἐξέστησαν ἡμᾶς, γενόμεναι ⸀ὀρθριναὶἐπὶ τὸ μνημεῖον ");
INSERT INTO grcsbl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","καὶ μὴ εὑροῦσαι τὸ σῶμα αὐτοῦ ἦλθον λέγουσαι καὶ ὀπτασίαν ἀγγέλων ἑωρακέναι, οἳ λέγουσιν αὐτὸν ζῆν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","καὶἀπῆλθόν τινες τῶν σὺν ἡμῖν ἐπὶ τὸ μνημεῖον, καὶ εὗρον οὕτως καθὼς ⸀καὶ αἱ γυναῖκες εἶπον, αὐτὸν δὲ οὐκ εἶδον. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","καὶ αὐτὸς εἶπεν πρὸς αὐτούς· Ὦ ἀνόητοι καὶ βραδεῖς τῇ καρδίᾳ τοῦ πιστεύειν ἐπὶ πᾶσιν οἷς ἐλάλησαν οἱ προφῆται· ");
INSERT INTO grcsbl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","οὐχὶ ταῦτα ἔδει παθεῖν τὸν χριστὸν καὶ εἰσελθεῖν εἰς τὴν δόξαν αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","καὶ ἀρξάμενος ἀπὸ Μωϋσέως καὶ ἀπὸ πάντων τῶν προφητῶν ⸀διερμήνευσεναὐτοῖς ἐν πάσαις ταῖς γραφαῖς τὰ περὶ ⸀ἑαυτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Καὶ ἤγγισαν εἰς τὴν κώμην οὗ ἐπορεύοντο, καὶ αὐτὸς ⸀προσεποιήσατο⸀πορρώτερονπορεύεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","καὶ παρεβιάσαντο αὐτὸν λέγοντες· Μεῖνον μεθʼ ἡμῶν, ὅτι πρὸς ἑσπέραν ἐστὶν καὶ κέκλικεν ⸀ἤδηἡ ἡμέρα. καὶ εἰσῆλθεν τοῦ μεῖναι σὺν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","καὶ ἐγένετο ἐν τῷ κατακλιθῆναι αὐτὸν μετʼ αὐτῶν λαβὼν τὸν ἄρτον εὐλόγησεν καὶ κλάσας ἐπεδίδου αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","αὐτῶν δὲ διηνοίχθησαν οἱ ὀφθαλμοὶ καὶ ἐπέγνωσαν αὐτόν· καὶ αὐτὸς ἄφαντος ἐγένετο ἀπʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","καὶ εἶπαν πρὸς ἀλλήλους· Οὐχὶ ἡ καρδία ἡμῶν καιομένη ἦν ⸂ἐν ἡμῖν ὡςἐλάλει ἡμῖν ἐν τῇ ὁδῷ, ⸀ὡς διήνοιγεν ἡμῖν τὰς γραφάς; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","καὶ ἀναστάντες αὐτῇ τῇ ὥρᾳ ὑπέστρεψαν εἰς Ἰερουσαλήμ, καὶ εὗρον ⸀ἠθροισμένουςτοὺς ἕνδεκα καὶ τοὺς σὺν αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","λέγοντας ὅτι ⸂ὄντως ἠγέρθη ὁ κύριος καὶ ὤφθη Σίμωνι. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","καὶ αὐτοὶ ἐξηγοῦντο τὰ ἐν τῇ ὁδῷ καὶ ὡς ἐγνώσθη αὐτοῖς ἐν τῇ κλάσει τοῦ ἄρτου. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ταῦτα δὲ αὐτῶν λαλούντων ⸀αὐτὸςἔστη ἐν μέσῳ ⸀αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","πτοηθέντες δὲ καὶ ἔμφοβοι γενόμενοι ἐδόκουν πνεῦμα θεωρεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","καὶ εἶπεν αὐτοῖς· Τί τεταραγμένοι ἐστέ, καὶ διὰ τί διαλογισμοὶ ἀναβαίνουσιν ἐν ⸂τῇ καρδίᾳ ὑμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ἴδετε τὰς χεῖράς μου καὶ τοὺς πόδας μου ὅτι ⸂ἐγώ εἰμι αὐτός· ψηλαφήσατέ με καὶ ἴδετε, ὅτι πνεῦμα σάρκα καὶ ὀστέα οὐκ ἔχει καθὼς ἐμὲ θεωρεῖτε ἔχοντα. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","⸂καὶ τοῦτο εἰπὼν ⸀ἔδειξεν αὐτοῖς τὰς χεῖρας καὶ τοὺς πόδας.⸃ ");
INSERT INTO grcsbl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ἔτι δὲ ἀπιστούντων αὐτῶν ἀπὸ τῆς χαρᾶς καὶ θαυμαζόντων εἶπεν αὐτοῖς· Ἔχετέ τι βρώσιμον ἐνθάδε; ");
INSERT INTO grcsbl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","οἱ δὲ ἐπέδωκαν αὐτῷ ἰχθύος ὀπτοῦ ⸀μέρος ");
INSERT INTO grcsbl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","καὶ λαβὼν ἐνώπιον αὐτῶν ἔφαγεν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Εἶπεν δὲ ⸂πρὸς αὐτούς· Οὗτοι οἱ λόγοι ⸀μουοὓς ἐλάλησα πρὸς ὑμᾶς ἔτι ὢν σὺν ὑμῖν, ὅτι δεῖ πληρωθῆναι πάντα τὰ γεγραμμένα ἐν τῷ νόμῳ Μωϋσέως ⸀καὶπροφήταις καὶ ψαλμοῖς περὶ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","τότε διήνοιξεν αὐτῶν τὸν νοῦν τοῦ συνιέναι τὰς γραφάς, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","καὶ εἶπεν αὐτοῖς ὅτι οὕτως ⸀γέγραπταιπαθεῖν τὸν χριστὸν καὶ ἀναστῆναι ἐκ νεκρῶν τῇ τρίτῃ ἡμέρᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","καὶκηρυχθῆναι ἐπὶ τῷ ὀνόματι αὐτοῦ μετάνοιαν ⸀καὶ ἄφεσιν ἁμαρτιῶν εἰς πάντα τὰ ἔθνη— ⸀ἀρξάμενοιἀπὸ Ἰερουσαλήμ· ");
INSERT INTO grcsbl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ὑμεῖς ⸀ἐστεμάρτυρες τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","καὶ ἰδοὺ ἐγὼ ⸀ἐξαποστέλλωτὴν ἐπαγγελίαν τοῦ πατρός μου ἐφʼ ὑμᾶς· ὑμεῖς δὲ καθίσατε ἐν τῇ ⸀πόλειἕως οὗ ἐνδύσησθε ⸂ἐξ ὕψους δύναμιν. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ἐξήγαγεν δὲ αὐτοὺς ⸀ἕως⸀πρὸςΒηθανίαν, καὶ ἐπάρας τὰς χεῖρας αὐτοῦ εὐλόγησεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","καὶ ἐγένετο ἐν τῷ εὐλογεῖν αὐτὸν αὐτοὺς διέστη ἀπʼ αὐτῶν ⸂καὶ ἀνεφέρετο εἰς τὸν οὐρανόν⸃. ");
INSERT INTO grcsbl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","καὶ αὐτοὶ ⸂προσκυνήσαντες αὐτὸν⸃ ὑπέστρεψαν εἰς Ἰερουσαλὴμ μετὰ χαρᾶς μεγάλης, ");
INSERT INTO grcsbl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","καὶ ἦσαν διὰ παντὸς ἐν τῷ ἱερῷ ⸀εὐλογοῦντεςτὸν ⸀θεόν ‘p /’ ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ἐν ἀρχῇ ἦν ὁ λόγος, καὶ ὁ λόγος ἦν πρὸς τὸν θεόν, καὶ θεὸς ἦν ὁ λόγος. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","οὗτος ἦν ἐν ἀρχῇ πρὸς τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","πάντα διʼ αὐτοῦ ἐγένετο, καὶ χωρὶς αὐτοῦ ἐγένετο οὐδὲ ἕν. ὃ γέγονεν ");
INSERT INTO grcsbl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ἐν αὐτῷ ζωὴ ἦν, καὶ ἡ ζωὴ ἦν τὸ φῶς τῶν ἀνθρώπων· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","καὶ τὸ φῶς ἐν τῇ σκοτίᾳ φαίνει, καὶ ἡ σκοτία αὐτὸ οὐ κατέλαβεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ἐγένετο ἄνθρωπος ἀπεσταλμένος παρὰ θεοῦ, ὄνομα αὐτῷ Ἰωάννης· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","οὗτος ἦλθεν εἰς μαρτυρίαν, ἵνα μαρτυρήσῃ περὶ τοῦ φωτός, ἵνα πάντες πιστεύσωσιν διʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","οὐκ ἦν ἐκεῖνος τὸ φῶς, ἀλλʼ ἵνα μαρτυρήσῃ περὶ τοῦ φωτός. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ἦν τὸ φῶς τὸ ἀληθινὸν ὃ φωτίζει πάντα ἄνθρωπον ἐρχόμενον εἰς τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ἐν τῷ κόσμῳ ἦν, καὶ ὁ κόσμος διʼ αὐτοῦ ἐγένετο, καὶ ὁ κόσμος αὐτὸν οὐκ ἔγνω. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","εἰς τὰ ἴδια ἦλθεν, καὶ οἱ ἴδιοι αὐτὸν οὐ παρέλαβον. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ὅσοι δὲ ἔλαβον αὐτόν, ἔδωκεν αὐτοῖς ἐξουσίαν τέκνα θεοῦ γενέσθαι, τοῖς πιστεύουσιν εἰς τὸ ὄνομα αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","οἳ οὐκ ἐξ αἱμάτων οὐδὲ ἐκ θελήματος σαρκὸς οὐδὲ ἐκ θελήματος ἀνδρὸς ἀλλʼ ἐκ θεοῦ ἐγεννήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Καὶ ὁ λόγος σὰρξ ἐγένετο καὶ ἐσκήνωσεν ἐν ἡμῖν, καὶ ἐθεασάμεθα τὴν δόξαν αὐτοῦ, δόξαν ὡς μονογενοῦς παρὰ πατρός, πλήρης χάριτος καὶ ἀληθείας· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Ἰωάννης μαρτυρεῖ περὶ αὐτοῦ καὶ κέκραγεν λέγων· Οὗτος ἦν ⸂ὃν εἶπον· Ὁ ὀπίσω μου ἐρχόμενος ἔμπροσθέν μου γέγονεν, ὅτι πρῶτός μου ἦν·) ");
INSERT INTO grcsbl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","⸀ὅτιἐκ τοῦ πληρώματος αὐτοῦ ἡμεῖς πάντες ἐλάβομεν, καὶ χάριν ἀντὶ χάριτος· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ὅτι ὁ νόμος διὰ Μωϋσέως ἐδόθη, ἡ χάρις καὶ ἡ ἀλήθεια διὰ Ἰησοῦ Χριστοῦ ἐγένετο. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","θεὸν οὐδεὶς ἑώρακεν πώποτε· ⸂μονογενὴς θεὸς ὁ ὢν εἰς τὸν κόλπον τοῦ πατρὸς ἐκεῖνος ἐξηγήσατο. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Καὶ αὕτη ἐστὶν ἡ μαρτυρία τοῦ Ἰωάννου ὅτε ⸀ἀπέστειλανοἱ Ἰουδαῖοι ἐξ Ἱεροσολύμων ἱερεῖς καὶ Λευίτας ἵνα ἐρωτήσωσιν αὐτόν· Σὺ τίς εἶ; ");
INSERT INTO grcsbl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","καὶ ὡμολόγησεν καὶ οὐκ ἠρνήσατο, καὶ ὡμολόγησεν ὅτι ⸂Ἐγὼ οὐκ εἰμὶ ὁ χριστός. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","καὶ ἠρώτησαν αὐτόν· Τί οὖν; ⸂σὺ Ἠλίας εἶ; καὶ λέγει· Οὐκ εἰμί. Ὁ προφήτης εἶ σύ; καὶ ἀπεκρίθη· Οὔ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","εἶπαν οὖν αὐτῷ· Τίς εἶ; ἵνα ἀπόκρισιν δῶμεν τοῖς πέμψασιν ἡμᾶς· τί λέγεις περὶ σεαυτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ἔφη· Ἐγὼ φωνὴ βοῶντος ἐν τῇ ἐρήμῳ· Εὐθύνατε τὴν ὁδὸν κυρίου, καθὼς εἶπεν Ἠσαΐας ὁ προφήτης. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","⸀Καὶἀπεσταλμένοι ἦσαν ἐκ τῶν Φαρισαίων. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","καὶ ἠρώτησαν αὐτὸν καὶ εἶπαν αὐτῷ· Τί οὖν βαπτίζεις εἰ σὺ οὐκ εἶ ὁ χριστὸς ⸂οὐδὲ Ἠλίας οὐδὲ ὁ προφήτης; ");
INSERT INTO grcsbl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ἀπεκρίθη αὐτοῖς ὁ Ἰωάννης λέγων· Ἐγὼ βαπτίζω ἐν ὕδατι· ⸀μέσοςὑμῶν ⸀ἕστηκενὃν ὑμεῖς οὐκ οἴδατε, ");
INSERT INTO grcsbl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","⸀ὁὀπίσω μου ⸀ἐρχόμενος οὗ ⸂οὐκ εἰμὶ ἄξιος ἵνα λύσω αὐτοῦ τὸν ἱμάντα τοῦ ὑποδήματος. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ταῦτα ἐν Βηθανίᾳ ἐγένετο πέραν τοῦ Ἰορδάνου, ὅπου ἦν ⸀ὁἸωάννης βαπτίζων. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Τῇ ἐπαύριον βλέπει τὸν Ἰησοῦν ἐρχόμενον πρὸς αὐτόν, καὶ λέγει· Ἴδε ὁ ἀμνὸς τοῦ θεοῦ ὁ αἴρων τὴν ἁμαρτίαν τοῦ κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","οὗτός ἐστιν ⸀ὑπὲροὗ ἐγὼ εἶπον· Ὀπίσω μου ἔρχεται ἀνὴρ ὃς ἔμπροσθέν μου γέγονεν, ὅτι πρῶτός μου ἦν· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","κἀγὼ οὐκ ᾔδειν αὐτόν, ἀλλʼ ἵνα φανερωθῇ τῷ Ἰσραὴλ διὰ τοῦτο ἦλθον ἐγὼ ⸀ἐνὕδατι βαπτίζων. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","καὶ ἐμαρτύρησεν Ἰωάννης λέγων ὅτι Τεθέαμαι τὸ πνεῦμα καταβαῖνον ⸀ὡςπεριστερὰν ἐξ οὐρανοῦ, καὶ ἔμεινεν ἐπʼ αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","κἀγὼ οὐκ ᾔδειν αὐτόν, ἀλλʼ ὁ πέμψας με βαπτίζειν ἐν ὕδατι ἐκεῖνός μοι εἶπεν· Ἐφʼ ὃν ἂν ἴδῃς τὸ πνεῦμα καταβαῖνον καὶ μένον ἐπʼ αὐτόν, οὗτός ἐστιν ὁ βαπτίζων ἐν πνεύματι ἁγίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","κἀγὼ ἑώρακα, καὶ μεμαρτύρηκα ὅτι οὗτός ἐστιν ὁ ⸀ἐκλεκτὸςτοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Τῇ ἐπαύριον πάλιν εἱστήκει ⸀ὁἸωάννης καὶ ἐκ τῶν μαθητῶν αὐτοῦ δύο, ");
INSERT INTO grcsbl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","καὶ ἐμβλέψας τῷ Ἰησοῦ περιπατοῦντι λέγει· Ἴδε ὁ ἀμνὸς τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","καὶ ἤκουσαν ⸂οἱ δύο μαθηταὶ αὐτοῦ λαλοῦντος καὶ ἠκολούθησαν τῷ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","στραφεὶς δὲ ὁ Ἰησοῦς καὶ θεασάμενος αὐτοὺς ἀκολουθοῦντας λέγει αὐτοῖς· Τί ζητεῖτε; οἱ δὲ εἶπαν αὐτῷ· Ῥαββί (ὃ λέγεται ⸀μεθερμηνευόμενονΔιδάσκαλε), ποῦ μένεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","λέγει αὐτοῖς· Ἔρχεσθε καὶ ⸂ὄψεσθε. ἦλθαν οὖν καὶ εἶδαν ποῦ μένει, καὶ παρʼ αὐτῷ ἔμειναν τὴν ἡμέραν ἐκείνην· ὥρα ἦν ὡς δεκάτη. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ἦν Ἀνδρέας ὁ ἀδελφὸς Σίμωνος Πέτρου εἷς ἐκ τῶν δύο τῶν ἀκουσάντων παρὰ Ἰωάννου καὶ ἀκολουθησάντων αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","εὑρίσκει οὗτος ⸀πρῶτοντὸν ἀδελφὸν τὸν ἴδιον Σίμωνα καὶ λέγει αὐτῷ· Εὑρήκαμεν τὸν Μεσσίαν (ὅ ἐστιν μεθερμηνευόμενον χριστός). ");
INSERT INTO grcsbl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","⸀ἤγαγεναὐτὸν πρὸς τὸν Ἰησοῦν. ἐμβλέψας αὐτῷ ὁ Ἰησοῦς εἶπεν· Σὺ εἶ Σίμων ὁ υἱὸς ⸀Ἰωάννου σὺ κληθήσῃ Κηφᾶς (ὃ ἑρμηνεύεται Πέτρος). ");
INSERT INTO grcsbl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Τῇ ἐπαύριον ἠθέλησεν ἐξελθεῖν εἰς τὴν Γαλιλαίαν. καὶ εὑρίσκει Φίλιππον καὶ λέγει αὐτῷ ὁ Ἰησοῦς· Ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ἦν δὲ ὁ Φίλιππος ἀπὸ Βηθσαϊδά, ἐκ τῆς πόλεως Ἀνδρέου καὶ Πέτρου. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","εὑρίσκει Φίλιππος τὸν Ναθαναὴλ καὶ λέγει αὐτῷ· Ὃν ἔγραψεν Μωϋσῆς ἐν τῷ νόμῳ καὶ οἱ προφῆται εὑρήκαμεν, ⸀Ἰησοῦνυἱὸν τοῦ Ἰωσὴφ τὸν ἀπὸ Ναζαρέτ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","καὶ εἶπεν αὐτῷ Ναθαναήλ· Ἐκ Ναζαρὲτ δύναταί τι ἀγαθὸν εἶναι; λέγει αὐτῷ ⸀ὁΦίλιππος· Ἔρχου καὶ ἴδε. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","εἶδεν ⸀ὁἸησοῦς τὸν Ναθαναὴλ ἐρχόμενον πρὸς αὐτὸν καὶ λέγει περὶ αὐτοῦ· Ἴδε ἀληθῶς Ἰσραηλίτης ἐν ᾧ δόλος οὐκ ἔστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","λέγει αὐτῷ Ναθαναήλ· Πόθεν με γινώσκεις; ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ· Πρὸ τοῦ σε Φίλιππον φωνῆσαι ὄντα ὑπὸ τὴν συκῆν εἶδόν σε. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ἀπεκρίθη ⸂αὐτῷ Ναθαναήλ· Ῥαββί, σὺ εἶ ὁ υἱὸς τοῦ θεοῦ, σὺ ⸂βασιλεὺς εἶ τοῦ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ· Ὅτι εἶπόν σοι ⸀ὅτιεἶδόν σε ὑποκάτω τῆς συκῆς πιστεύεις; μείζω τούτων ⸀ὄψῃ ");
INSERT INTO grcsbl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","καὶ λέγει αὐτῷ· Ἀμὴν ἀμὴν λέγω ⸀ὑμῖν ὄψεσθε τὸν οὐρανὸν ἀνεῳγότα καὶ τοὺς ἀγγέλους τοῦ θεοῦ ἀναβαίνοντας καὶ καταβαίνοντας ἐπὶ τὸν υἱὸν τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Καὶ τῇ ⸂ἡμέρᾳ τῇ τρίτῃ γάμος ἐγένετο ἐν Κανὰ τῆς Γαλιλαίας, καὶ ἦν ἡ μήτηρ τοῦ Ἰησοῦ ἐκεῖ· ");
INSERT INTO grcsbl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ἐκλήθη δὲ καὶ ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὸν γάμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","καὶ ὑστερήσαντος οἴνου λέγει ἡ μήτηρ τοῦ Ἰησοῦ πρὸς αὐτόν· Οἶνον οὐκ ἔχουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","⸀καὶλέγει αὐτῇ ὁ Ἰησοῦς· Τί ἐμοὶ καὶ σοί, γύναι; οὔπω ἥκει ἡ ὥρα μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","λέγει ἡ μήτηρ αὐτοῦ τοῖς διακόνοις· ⸂Ὅ τι ἂν λέγῃ ὑμῖν ποιήσατε. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ἦσαν δὲ ἐκεῖ ⸂λίθιναι ὑδρίαι ἓξ ⸂κατὰ τὸν καθαρισμὸν τῶν Ἰουδαίων κείμεναι, χωροῦσαι ἀνὰ μετρητὰς δύο ἢ τρεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","λέγει αὐτοῖς ὁ Ἰησοῦς· Γεμίσατε τὰς ὑδρίας ὕδατος· καὶ ἐγέμισαν αὐτὰς ἕως ἄνω. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","καὶ λέγει αὐτοῖς· Ἀντλήσατε νῦν καὶ φέρετε τῷ ἀρχιτρικλίνῳ· ⸂οἱ δὲ ἤνεγκαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ὡς δὲ ἐγεύσατο ὁ ἀρχιτρίκλινος τὸ ὕδωρ οἶνον γεγενημένον, καὶ οὐκ ᾔδει πόθεν ἐστίν, οἱ δὲ διάκονοι ᾔδεισαν οἱ ἠντληκότες τὸ ὕδωρ, φωνεῖ τὸν νυμφίον ὁ ἀρχιτρίκλινος ");
INSERT INTO grcsbl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","καὶ λέγει αὐτῷ· Πᾶς ἄνθρωπος πρῶτον τὸν καλὸν οἶνον τίθησιν, καὶ ὅταν ⸀μεθυσθῶσιντὸν ἐλάσσω· σὺ τετήρηκας τὸν καλὸν οἶνον ἕως ἄρτι. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ταύτην ⸀ἐποίησενἀρχὴν τῶν σημείων ὁ Ἰησοῦς ἐν Κανὰ τῆς Γαλιλαίας καὶ ἐφανέρωσεν τὴν δόξαν αὐτοῦ, καὶ ἐπίστευσαν εἰς αὐτὸν οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Μετὰ τοῦτο κατέβη εἰς Καφαρναοὺμ αὐτὸς καὶ ἡ μήτηρ αὐτοῦ καὶ οἱ ⸀ἀδελφοὶκαὶ οἱ μαθηταὶ αὐτοῦ, καὶ ἐκεῖ ἔμειναν οὐ πολλὰς ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Καὶ ἐγγὺς ἦν τὸ πάσχα τῶν Ἰουδαίων, καὶ ἀνέβη εἰς Ἱεροσόλυμα ὁ Ἰησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","καὶ εὗρεν ἐν τῷ ἱερῷ τοὺς πωλοῦντας βόας καὶ πρόβατα καὶ περιστερὰς καὶ τοὺς κερματιστὰς καθημένους, ");
INSERT INTO grcsbl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","καὶ ποιήσας φραγέλλιον ἐκ σχοινίων πάντας ἐξέβαλεν ἐκ τοῦ ἱεροῦ τά τε πρόβατα καὶ τοὺς βόας, καὶ τῶν κολλυβιστῶν ἐξέχεεν ⸂τὰ κέρματα καὶ τὰς τραπέζας ⸀ἀνέστρεψεν ");
INSERT INTO grcsbl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","καὶ τοῖς τὰς περιστερὰς πωλοῦσιν εἶπεν· Ἄρατε ταῦτα ἐντεῦθεν, μὴ ποιεῖτε τὸν οἶκον τοῦ πατρός μου οἶκον ἐμπορίου. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","⸀ἐμνήσθησανοἱ μαθηταὶ αὐτοῦ ὅτι γεγραμμένον ἐστίν· Ὁ ζῆλος τοῦ οἴκου σου καταφάγεταί με. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ἀπεκρίθησαν οὖν οἱ Ἰουδαῖοι καὶ εἶπαν αὐτῷ· Τί σημεῖον δεικνύεις ἡμῖν, ὅτι ταῦτα ποιεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτοῖς· Λύσατε τὸν ναὸν τοῦτον καὶ ἐν τρισὶν ἡμέραις ἐγερῶ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","εἶπαν οὖν οἱ Ἰουδαῖοι· Τεσσεράκοντα καὶ ἓξ ἔτεσιν οἰκοδομήθη ὁ ναὸς οὗτος, καὶ σὺ ἐν τρισὶν ἡμέραις ἐγερεῖς αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ἐκεῖνος δὲ ἔλεγεν περὶ τοῦ ναοῦ τοῦ σώματος αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ὅτε οὖν ἠγέρθη ἐκ νεκρῶν, ἐμνήσθησαν οἱ μαθηταὶ αὐτοῦ ὅτι τοῦτο ἔλεγεν, καὶ ἐπίστευσαν τῇ γραφῇ καὶ τῷ λόγῳ ⸀ὃνεἶπεν ὁ Ἰησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ὡς δὲ ἦν ἐν τοῖς Ἱεροσολύμοις ἐν τῷ πάσχα ἐν τῇ ἑορτῇ, πολλοὶ ἐπίστευσαν εἰς τὸ ὄνομα αὐτοῦ, θεωροῦντες αὐτοῦ τὰ σημεῖα ἃ ἐποίει· ");
INSERT INTO grcsbl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","αὐτὸς ⸀δὲἸησοῦς οὐκ ἐπίστευεν ⸀αὑτὸναὐτοῖς διὰ τὸ αὐτὸν γινώσκειν πάντας ");
INSERT INTO grcsbl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","καὶ ὅτι οὐ χρείαν εἶχεν ἵνα τις μαρτυρήσῃ περὶ τοῦ ἀνθρώπου, αὐτὸς γὰρ ἐγίνωσκεν τί ἦν ἐν τῷ ἀνθρώπῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ἦν δὲ ἄνθρωπος ἐκ τῶν Φαρισαίων, Νικόδημος ὄνομα αὐτῷ, ἄρχων τῶν Ἰουδαίων· ");
INSERT INTO grcsbl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","οὗτος ἦλθεν πρὸς αὐτὸν νυκτὸς καὶ εἶπεν αὐτῷ· Ῥαββί, οἴδαμεν ὅτι ἀπὸ θεοῦ ἐλήλυθας διδάσκαλος· οὐδεὶς γὰρ ⸂δύναται ταῦτα τὰ σημεῖα ποιεῖν ἃ σὺ ποιεῖς, ἐὰν μὴ ᾖ ὁ θεὸς μετʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","⸀ἀπεκρίθηἸησοῦς καὶ εἶπεν αὐτῷ· Ἀμὴν ἀμὴν λέγω σοι, ἐὰν μή τις γεννηθῇ ἄνωθεν, οὐ δύναται ἰδεῖν τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","λέγει πρὸς αὐτὸν ⸀ὁΝικόδημος· Πῶς δύναται ἄνθρωπος γεννηθῆναι γέρων ὤν; μὴ δύναται εἰς τὴν κοιλίαν τῆς μητρὸς αὐτοῦ δεύτερον εἰσελθεῖν καὶ γεννηθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","⸀ἀπεκρίθηἸησοῦς· Ἀμὴν ἀμὴν λέγω σοι, ἐὰν μή τις γεννηθῇ ἐξ ὕδατος καὶ πνεύματος, οὐ δύναται εἰσελθεῖν εἰς τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","τὸ γεγεννημένον ἐκ τῆς σαρκὸς σάρξ ἐστιν, καὶ τὸ γεγεννημένον ἐκ τοῦ πνεύματος πνεῦμά ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","μὴ θαυμάσῃς ὅτι εἶπόν σοι Δεῖ ὑμᾶς γεννηθῆναι ἄνωθεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","τὸ πνεῦμα ὅπου θέλει πνεῖ, καὶ τὴν φωνὴν αὐτοῦ ἀκούεις, ἀλλʼ οὐκ οἶδας πόθεν ἔρχεται καὶ ποῦ ὑπάγει· οὕτως ἐστὶν πᾶς ὁ γεγεννημένος ἐκ τοῦ πνεύματος. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ἀπεκρίθη Νικόδημος καὶ εἶπεν αὐτῷ· Πῶς δύναται ταῦτα γενέσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ· Σὺ εἶ ὁ διδάσκαλος τοῦ Ἰσραὴλ καὶ ταῦτα οὐ γινώσκεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ἀμὴν ἀμὴν λέγω σοι ὅτι ὃ οἴδαμεν λαλοῦμεν καὶ ὃ ἑωράκαμεν μαρτυροῦμεν, καὶ τὴν μαρτυρίαν ἡμῶν οὐ λαμβάνετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","εἰ τὰ ἐπίγεια εἶπον ὑμῖν καὶ οὐ πιστεύετε, πῶς ἐὰν εἴπω ὑμῖν τὰ ἐπουράνια πιστεύσετε; ");
INSERT INTO grcsbl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","καὶ οὐδεὶς ἀναβέβηκεν εἰς τὸν οὐρανὸν εἰ μὴ ὁ ἐκ τοῦ οὐρανοῦ καταβάς, ὁ υἱὸς τοῦ ⸀ἀνθρώπου ");
INSERT INTO grcsbl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","καὶ καθὼς Μωϋσῆς ὕψωσεν τὸν ὄφιν ἐν τῇ ἐρήμῳ, οὕτως ὑψωθῆναι δεῖ τὸν υἱὸν τοῦ ἀνθρώπου, ");
INSERT INTO grcsbl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ἵνα πᾶς ὁ πιστεύων ⸂ἐν αὐτῷ ἔχῃ ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Οὕτως γὰρ ἠγάπησεν ὁ θεὸς τὸν κόσμον ὥστε τὸν ⸀υἱὸντὸν μονογενῆ ἔδωκεν, ἵνα πᾶς ὁ πιστεύων εἰς αὐτὸν μὴ ἀπόληται ἀλλὰ ἔχῃ ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","οὐ γὰρ ἀπέστειλεν ὁ θεὸς τὸν ⸀υἱὸνεἰς τὸν κόσμον ἵνα κρίνῃ τὸν κόσμον, ἀλλʼ ἵνα σωθῇ ὁ κόσμος διʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ὁ πιστεύων εἰς αὐτὸν οὐ κρίνεται· ὁ ⸀δὲμὴ πιστεύων ἤδη κέκριται, ὅτι μὴ πεπίστευκεν εἰς τὸ ὄνομα τοῦ μονογενοῦς υἱοῦ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","αὕτη δέ ἐστιν ἡ κρίσις ὅτι τὸ φῶς ἐλήλυθεν εἰς τὸν κόσμον καὶ ἠγάπησαν οἱ ἄνθρωποι μᾶλλον τὸ σκότος ἢ τὸ φῶς, ἦν γὰρ ⸂αὐτῶν πονηρὰ τὰ ἔργα. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","πᾶς γὰρ ὁ φαῦλα πράσσων μισεῖ τὸ φῶς καὶ οὐκ ἔρχεται πρὸς τὸ φῶς, ἵνα μὴ ἐλεγχθῇ τὰ ἔργα αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ὁ δὲ ποιῶν τὴν ἀλήθειαν ἔρχεται πρὸς τὸ φῶς, ἵνα φανερωθῇ αὐτοῦ τὰ ἔργα ὅτι ἐν θεῷ ἐστιν εἰργασμένα. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Μετὰ ταῦτα ἦλθεν ὁ Ἰησοῦς καὶ οἱ μαθηταὶ αὐτοῦ εἰς τὴν Ἰουδαίαν γῆν, καὶ ἐκεῖ διέτριβεν μετʼ αὐτῶν καὶ ἐβάπτιζεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ἦν δὲ καὶ ⸀ὁἸωάννης βαπτίζων ἐν Αἰνὼν ἐγγὺς τοῦ Σαλείμ, ὅτι ὕδατα πολλὰ ἦν ἐκεῖ, καὶ παρεγίνοντο καὶ ἐβαπτίζοντο· ");
INSERT INTO grcsbl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","οὔπω γὰρ ἦν βεβλημένος εἰς τὴν φυλακὴν ⸀ὁἸωάννης. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ἐγένετο οὖν ζήτησις ἐκ τῶν μαθητῶν Ἰωάννου μετὰ Ἰουδαίου περὶ καθαρισμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","καὶ ἦλθον πρὸς τὸν Ἰωάννην καὶ εἶπαν αὐτῷ· Ῥαββί, ὃς ἦν μετὰ σοῦ πέραν τοῦ Ἰορδάνου, ᾧ σὺ μεμαρτύρηκας, ἴδε οὗτος βαπτίζει καὶ πάντες ἔρχονται πρὸς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ἀπεκρίθη Ἰωάννης καὶ εἶπεν· Οὐ δύναται ἄνθρωπος λαμβάνειν ⸂οὐδὲ ἓν ἐὰν μὴ ᾖ δεδομένον αὐτῷ ἐκ τοῦ οὐρανοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","αὐτοὶ ὑμεῖς ⸀μοιμαρτυρεῖτε ὅτι ⸀εἶπον Οὐκ εἰμὶ ἐγὼ ὁ χριστός, ἀλλʼ ὅτι Ἀπεσταλμένος εἰμὶ ἔμπροσθεν ἐκείνου. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ὁ ἔχων τὴν νύμφην νυμφίος ἐστίν· ὁ δὲ φίλος τοῦ νυμφίου ὁ ἑστηκὼς καὶ ἀκούων αὐτοῦ, χαρᾷ χαίρει διὰ τὴν φωνὴν τοῦ νυμφίου. αὕτη οὖν ἡ χαρὰ ἡ ἐμὴ πεπλήρωται. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ἐκεῖνον δεῖ αὐξάνειν, ἐμὲ δὲ ἐλαττοῦσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ὁ ἄνωθεν ἐρχόμενος ἐπάνω πάντων ἐστίν. ὁ ὢν ἐκ τῆς γῆς ἐκ τῆς γῆς ἐστιν καὶ ἐκ τῆς γῆς λαλεῖ· ὁ ἐκ τοῦ οὐρανοῦ ἐρχόμενος ἐπάνω πάντων ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","⸀ὃἑώρακεν καὶ ἤκουσεν τοῦτο μαρτυρεῖ, καὶ τὴν μαρτυρίαν αὐτοῦ οὐδεὶς λαμβάνει. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ὁ λαβὼν αὐτοῦ τὴν μαρτυρίαν ἐσφράγισεν ὅτι ὁ θεὸς ἀληθής ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ὃν γὰρ ἀπέστειλεν ὁ θεὸς τὰ ῥήματα τοῦ θεοῦ λαλεῖ, οὐ γὰρ ἐκ μέτρου ⸀δίδωσιντὸ πνεῦμα. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ὁ πατὴρ ἀγαπᾷ τὸν υἱόν, καὶ πάντα δέδωκεν ἐν τῇ χειρὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ὁ πιστεύων εἰς τὸν υἱὸν ἔχει ζωὴν αἰώνιον· ὁ δὲ ἀπειθῶν τῷ υἱῷ οὐκ ὄψεται ζωήν, ἀλλʼ ἡ ὀργὴ τοῦ θεοῦ μένει ἐπʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ὡς οὖν ἔγνω ὁ ⸀Ἰησοῦςὅτι ἤκουσαν οἱ Φαρισαῖοι ὅτι Ἰησοῦς πλείονας μαθητὰς ποιεῖ καὶ βαπτίζει ἢ Ἰωάννης— ");
INSERT INTO grcsbl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","καίτοιγε Ἰησοῦς αὐτὸς οὐκ ἐβάπτιζεν ἀλλʼ οἱ μαθηταὶ αὐτοῦ— ");
INSERT INTO grcsbl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ἀφῆκεν τὴν Ἰουδαίαν καὶ ἀπῆλθεν ⸀πάλινεἰς τὴν Γαλιλαίαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ἔδει δὲ αὐτὸν διέρχεσθαι διὰ τῆς Σαμαρείας. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ἔρχεται οὖν εἰς πόλιν τῆς Σαμαρείας λεγομένην Συχὰρ πλησίον τοῦ χωρίου ὃ ἔδωκεν Ἰακὼβ ⸀τῷἸωσὴφ τῷ υἱῷ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ἦν δὲ ἐκεῖ πηγὴ τοῦ Ἰακώβ. ὁ οὖν Ἰησοῦς κεκοπιακὼς ἐκ τῆς ὁδοιπορίας ἐκαθέζετο οὕτως ἐπὶ τῇ πηγῇ· ὥρα ἦν ⸀ὡςἕκτη. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ἔρχεται γυνὴ ἐκ τῆς Σαμαρείας ἀντλῆσαι ὕδωρ. λέγει αὐτῇ ὁ Ἰησοῦς· Δός μοι πεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","οἱ γὰρ μαθηταὶ αὐτοῦ ἀπεληλύθεισαν εἰς τὴν πόλιν, ἵνα τροφὰς ἀγοράσωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","λέγει οὖν αὐτῷ ἡ γυνὴ ἡ Σαμαρῖτις· Πῶς σὺ Ἰουδαῖος ὢν παρʼ ἐμοῦ πεῖν αἰτεῖς ⸂γυναικὸς Σαμαρίτιδος οὔσης; οὐ γὰρ συγχρῶνται Ἰουδαῖοι Σαμαρίταις. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῇ· Εἰ ᾔδεις τὴν δωρεὰν τοῦ θεοῦ καὶ τίς ἐστιν ὁ λέγων σοι· Δός μοι πεῖν, σὺ ἂν ᾔτησας αὐτὸν καὶ ἔδωκεν ἄν σοι ὕδωρ ζῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","λέγει αὐτῷ ⸂ἡ γυνή· Κύριε, οὔτε ἄντλημα ἔχεις καὶ τὸ φρέαρ ἐστὶν βαθύ· πόθεν οὖν ἔχεις τὸ ὕδωρ τὸ ζῶν; ");
INSERT INTO grcsbl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","μὴ σὺ μείζων εἶ τοῦ πατρὸς ἡμῶν Ἰακώβ, ὃς ἔδωκεν ἡμῖν τὸ φρέαρ καὶ αὐτὸς ἐξ αὐτοῦ ἔπιεν καὶ οἱ υἱοὶ αὐτοῦ καὶ τὰ θρέμματα αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῇ· Πᾶς ὁ πίνων ἐκ τοῦ ὕδατος τούτου διψήσει πάλιν· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ὃς δʼ ἂν πίῃ ἐκ τοῦ ὕδατος οὗ ἐγὼ δώσω αὐτῷ, οὐ μὴ ⸀διψήσειεἰς τὸν αἰῶνα, ἀλλὰ τὸ ὕδωρ ὃ δώσω αὐτῷ γενήσεται ἐν αὐτῷ πηγὴ ὕδατος ἁλλομένου εἰς ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","λέγει πρὸς αὐτὸν ἡ γυνή· Κύριε, δός μοι τοῦτο τὸ ὕδωρ, ἵνα μὴ διψῶ μηδὲ ⸀διέρχωμαιἐνθάδε ἀντλεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Λέγει ⸀αὐτῇ Ὕπαγε φώνησον ⸂τὸν ἄνδρα σου καὶ ἐλθὲ ἐνθάδε. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ἀπεκρίθη ἡ γυνὴ καὶ εἶπεν ⸀αὐτῷ Οὐκ ἔχω ἄνδρα. λέγει αὐτῇ ὁ Ἰησοῦς· Καλῶς εἶπας ὅτι Ἄνδρα οὐκ ἔχω· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","πέντε γὰρ ἄνδρας ἔσχες, καὶ νῦν ὃν ἔχεις οὐκ ἔστιν σου ἀνήρ· τοῦτο ἀληθὲς εἴρηκας. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","λέγει αὐτῷ ἡ γυνή· Κύριε, θεωρῶ ὅτι προφήτης εἶ σύ. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","οἱ πατέρες ἡμῶν ἐν τῷ ὄρει τούτῳ προσεκύνησαν· καὶ ὑμεῖς λέγετε ὅτι ἐν Ἱεροσολύμοις ἐστὶν ὁ τόπος ὅπου ⸂προσκυνεῖν δεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","λέγει αὐτῇ ὁ Ἰησοῦς· ⸂Πίστευέ μοι, γύναι, ὅτι ἔρχεται ὥρα ὅτε οὔτε ἐν τῷ ὄρει τούτῳ οὔτε ἐν Ἱεροσολύμοις προσκυνήσετε τῷ πατρί. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ὑμεῖς προσκυνεῖτε ὃ οὐκ οἴδατε, ἡμεῖς προσκυνοῦμεν ὃ οἴδαμεν, ὅτι ἡ σωτηρία ἐκ τῶν Ἰουδαίων ἐστίν· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ἀλλὰ ἔρχεται ὥρα καὶ νῦν ἐστιν, ὅτε οἱ ἀληθινοὶ προσκυνηταὶ προσκυνήσουσιν τῷ πατρὶ ἐν πνεύματι καὶ ἀληθείᾳ, καὶ γὰρ ὁ πατὴρ τοιούτους ζητεῖ τοὺς προσκυνοῦντας αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","πνεῦμα ὁ θεός, καὶ τοὺς προσκυνοῦντας αὐτὸν ἐν πνεύματι καὶ ἀληθείᾳ δεῖ προσκυνεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","λέγει αὐτῷ ἡ γυνή· Οἶδα ὅτι Μεσσίας ἔρχεται, ὁ λεγόμενος χριστός· ὅταν ἔλθῃ ἐκεῖνος, ἀναγγελεῖ ἡμῖν ⸀ἅπαντα ");
INSERT INTO grcsbl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","λέγει αὐτῇ ὁ Ἰησοῦς· Ἐγώ εἰμι, ὁ λαλῶν σοι. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Καὶ ἐπὶ τούτῳ ἦλθαν οἱ μαθηταὶ αὐτοῦ, καὶ ⸀ἐθαύμαζονὅτι μετὰ γυναικὸς ἐλάλει· οὐδεὶς μέντοι εἶπεν· Τί ζητεῖς; ἢ τί λαλεῖς μετʼ αὐτῆς; ");
INSERT INTO grcsbl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ἀφῆκεν οὖν τὴν ὑδρίαν αὐτῆς ἡ γυνὴ καὶ ἀπῆλθεν εἰς τὴν πόλιν καὶ λέγει τοῖς ἀνθρώποις· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Δεῦτε ἴδετε ἄνθρωπον ὃς εἶπέ μοι πάντα ⸀ὅσαἐποίησα· μήτι οὗτός ἐστιν ὁ χριστός; ");
INSERT INTO grcsbl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ἐξῆλθον ἐκ τῆς πόλεως καὶ ἤρχοντο πρὸς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","⸀Ἐντῷ μεταξὺ ἠρώτων αὐτὸν οἱ μαθηταὶ λέγοντες· Ῥαββί, φάγε. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ὁ δὲ εἶπεν αὐτοῖς· Ἐγὼ βρῶσιν ἔχω φαγεῖν ἣν ὑμεῖς οὐκ οἴδατε. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ἔλεγον οὖν οἱ μαθηταὶ πρὸς ἀλλήλους· Μή τις ἤνεγκεν αὐτῷ φαγεῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","λέγει αὐτοῖς ὁ Ἰησοῦς· Ἐμὸν βρῶμά ἐστιν ἵνα ⸀ποιήσωτὸ θέλημα τοῦ πέμψαντός με καὶ τελειώσω αὐτοῦ τὸ ἔργον. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","οὐχ ὑμεῖς λέγετε ὅτι Ἔτι τετράμηνός ἐστιν καὶ ὁ θερισμὸς ἔρχεται; ἰδοὺ λέγω ὑμῖν, ἐπάρατε τοὺς ὀφθαλμοὺς ὑμῶν καὶ θεάσασθε τὰς χώρας ὅτι λευκαί εἰσιν πρὸς θερισμόν· ἤδη ");
INSERT INTO grcsbl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","⸀ὁθερίζων μισθὸν λαμβάνει καὶ συνάγει καρπὸν εἰς ζωὴν αἰώνιον, ⸀ἵναὁ σπείρων ὁμοῦ χαίρῃ καὶ ὁ θερίζων. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ἐν γὰρ τούτῳ ὁ λόγος ⸀ἐστὶνἀληθινὸς ὅτι Ἄλλος ἐστὶν ὁ σπείρων καὶ ἄλλος ὁ θερίζων· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ἐγὼ ἀπέστειλα ὑμᾶς θερίζειν ὃ οὐχ ὑμεῖς κεκοπιάκατε· ἄλλοι κεκοπιάκασιν, καὶ ὑμεῖς εἰς τὸν κόπον αὐτῶν εἰσεληλύθατε. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ἐκ δὲ τῆς πόλεως ἐκείνης πολλοὶ ἐπίστευσαν εἰς αὐτὸν τῶν Σαμαριτῶν διὰ τὸν λόγον τῆς γυναικὸς μαρτυρούσης ὅτι Εἶπέν μοι πάντα ⸀ἃἐποίησα. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ὡς οὖν ἦλθον πρὸς αὐτὸν οἱ Σαμαρῖται, ἠρώτων αὐτὸν μεῖναι παρʼ αὐτοῖς· καὶ ἔμεινεν ἐκεῖ δύο ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","καὶ πολλῷ πλείους ἐπίστευσαν διὰ τὸν λόγον αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","τῇ τε γυναικὶ ἔλεγον ὅτι Οὐκέτι διὰ τὴν σὴν λαλιὰν πιστεύομεν· αὐτοὶ γὰρ ἀκηκόαμεν, καὶ οἴδαμεν ὅτι οὗτός ἐστιν ἀληθῶς ὁ σωτὴρ τοῦ ⸀κόσμου ");
INSERT INTO grcsbl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Μετὰ δὲ τὰς δύο ἡμέρας ἐξῆλθεν ⸀ἐκεῖθενεἰς τὴν Γαλιλαίαν· ");
INSERT INTO grcsbl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","αὐτὸς ⸀γὰρἸησοῦς ἐμαρτύρησεν ὅτι προφήτης ἐν τῇ ἰδίᾳ πατρίδι τιμὴν οὐκ ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ὅτε οὖν ἦλθεν εἰς τὴν Γαλιλαίαν, ἐδέξαντο αὐτὸν οἱ Γαλιλαῖοι, πάντα ἑωρακότες ⸀ὅσαἐποίησεν ἐν Ἱεροσολύμοις ἐν τῇ ἑορτῇ, καὶ αὐτοὶ γὰρ ἦλθον εἰς τὴν ἑορτήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ἦλθεν οὖν ⸀πάλινεἰς τὴν Κανὰ τῆς Γαλιλαίας, ὅπου ἐποίησεν τὸ ὕδωρ οἶνον. καὶ ἦν τις βασιλικὸς οὗ ὁ υἱὸς ἠσθένει ἐν Καφαρναούμ. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","οὗτος ἀκούσας ὅτι Ἰησοῦς ἥκει ἐκ τῆς Ἰουδαίας εἰς τὴν Γαλιλαίαν ἀπῆλθεν πρὸς αὐτὸν καὶ ⸀ἠρώταἵνα καταβῇ καὶ ἰάσηται αὐτοῦ τὸν υἱόν, ἤμελλεν γὰρ ἀποθνῄσκειν. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","εἶπεν οὖν ὁ Ἰησοῦς πρὸς αὐτόν· Ἐὰν μὴ σημεῖα καὶ τέρατα ἴδητε, οὐ μὴ πιστεύσητε. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","λέγει πρὸς αὐτὸν ὁ βασιλικός· Κύριε, κατάβηθι πρὶν ἀποθανεῖν τὸ παιδίον μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","λέγει αὐτῷ ὁ Ἰησοῦς· Πορεύου· ὁ υἱός σου ζῇ. ⸀ἐπίστευσενὁ ἄνθρωπος τῷ λόγῳ ⸀ὃνεἶπεν αὐτῷ ὁ Ἰησοῦς καὶ ἐπορεύετο. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ἤδη δὲ αὐτοῦ καταβαίνοντος οἱ δοῦλοι αὐτοῦ ⸀ὑπήντησαν⸀αὐτῷλέγοντες ὅτι ὁ παῖς ⸀αὐτοῦζῇ. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ἐπύθετο οὖν ⸂τὴν ὥραν παρʼ αὐτῶν ἐν ᾗ κομψότερον ἔσχεν· ⸂εἶπαν οὖν αὐτῷ ὅτι ⸀Ἐχθὲςὥραν ἑβδόμην ἀφῆκεν αὐτὸν ὁ πυρετός. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ἔγνω οὖν ὁ πατὴρ ⸀ὅτιἐκείνῃ τῇ ὥρᾳ ἐν ᾗ εἶπεν αὐτῷ ὁ ⸀Ἰησοῦς Ὁ υἱός σου ζῇ, καὶ ἐπίστευσεν αὐτὸς καὶ ἡ οἰκία αὐτοῦ ὅλη. ");
INSERT INTO grcsbl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","τοῦτο ⸀δὲπάλιν δεύτερον σημεῖον ἐποίησεν ὁ Ἰησοῦς ἐλθὼν ἐκ τῆς Ἰουδαίας εἰς τὴν Γαλιλαίαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Μετὰ ταῦτα ⸀ἦνἑορτὴ τῶν Ἰουδαίων, καὶ ⸀ἀνέβηἸησοῦς εἰς Ἱεροσόλυμα. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ἔστιν δὲ ἐν τοῖς Ἱεροσολύμοις ἐπὶ τῇ προβατικῇ κολυμβήθρα ἡ ἐπιλεγομένη Ἑβραϊστὶ ⸀Βηθεσδά πέντε στοὰς ἔχουσα· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ἐν ταύταις κατέκειτο ⸀πλῆθοςτῶν ἀσθενούντων, τυφλῶν, χωλῶν, ⸀ξηρῶν ");
INSERT INTO grcsbl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ἦν δέ τις ἄνθρωπος ἐκεῖ ⸀τριάκονταὀκτὼ ἔτη ἔχων ἐν τῇ ἀσθενείᾳ ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","τοῦτον ἰδὼν ὁ Ἰησοῦς κατακείμενον, καὶ γνοὺς ὅτι πολὺν ἤδη χρόνον ἔχει, λέγει αὐτῷ· Θέλεις ὑγιὴς γενέσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ἀπεκρίθη αὐτῷ ὁ ἀσθενῶν· Κύριε, ἄνθρωπον οὐκ ἔχω ἵνα ὅταν ταραχθῇ τὸ ὕδωρ βάλῃ με εἰς τὴν κολυμβήθραν· ἐν ᾧ δὲ ἔρχομαι ἐγὼ ἄλλος πρὸ ἐμοῦ καταβαίνει. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","λέγει αὐτῷ ὁ Ἰησοῦς· ⸀Ἔγειρεἆρον τὸν κράβαττόν σου καὶ περιπάτει. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","καὶ εὐθέως ἐγένετο ὑγιὴς ὁ ἄνθρωπος καὶ ἦρε τὸν κράβαττον αὐτοῦ καὶ περιεπάτει. Ἦν δὲ σάββατον ἐν ἐκείνῃ τῇ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ἔλεγον οὖν οἱ Ἰουδαῖοι τῷ τεθεραπευμένῳ· Σάββατόν ἐστιν, ⸀καὶοὐκ ἔξεστίν σοι ἆραι τὸν ⸀κράβαττον ");
INSERT INTO grcsbl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","⸂ὃς δὲ ἀπεκρίθη αὐτοῖς· Ὁ ποιήσας με ὑγιῆ ἐκεῖνός μοι εἶπεν Ἆρον τὸν κράβαττόν σου καὶ περιπάτει. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ἠρώτησαν ⸀οὖναὐτόν· Τίς ἐστιν ὁ ἄνθρωπος ὁ εἰπών σοι· ⸀Ἆρονκαὶ περιπάτει; ");
INSERT INTO grcsbl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ὁ δὲ ἰαθεὶς οὐκ ᾔδει τίς ἐστιν, ὁ γὰρ Ἰησοῦς ἐξένευσεν ὄχλου ὄντος ἐν τῷ τόπῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","μετὰ ταῦτα εὑρίσκει αὐτὸν ὁ Ἰησοῦς ἐν τῷ ἱερῷ καὶ εἶπεν αὐτῷ· Ἴδε ὑγιὴς γέγονας· μηκέτι ἁμάρτανε, ἵνα μὴ χεῖρόν ⸂σοί τι γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ἀπῆλθεν ὁ ἄνθρωπος καὶ ⸀ἀνήγγειλεντοῖς Ἰουδαίοις ὅτι Ἰησοῦς ἐστιν ὁ ποιήσας αὐτὸν ὑγιῆ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","καὶ διὰ τοῦτο ἐδίωκον ⸂οἱ Ἰουδαῖοι τὸν Ἰησοῦν ὅτι ταῦτα ἐποίει ἐν σαββάτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ὁ ⸀δὲἀπεκρίνατο αὐτοῖς· Ὁ πατήρ μου ἕως ἄρτι ἐργάζεται κἀγὼ ἐργάζομαι. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","διὰ τοῦτο οὖν μᾶλλον ἐζήτουν αὐτὸν οἱ Ἰουδαῖοι ἀποκτεῖναι ὅτι οὐ μόνον ἔλυε τὸ σάββατον, ἀλλὰ καὶ πατέρα ἴδιον ἔλεγε τὸν θεόν, ἴσον ἑαυτὸν ποιῶν τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ἀπεκρίνατο οὖν ὁ Ἰησοῦς καὶ ⸀ἔλεγεναὐτοῖς· Ἀμὴν ἀμὴν λέγω ὑμῖν, οὐ δύναται ὁ υἱὸς ποιεῖν ἀφʼ ἑαυτοῦ οὐδὲν ⸀ἐὰνμή τι βλέπῃ τὸν πατέρα ποιοῦντα· ἃ γὰρ ἂν ἐκεῖνος ποιῇ, ταῦτα καὶ ὁ υἱὸς ὁμοίως ποιεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ὁ γὰρ πατὴρ φιλεῖ τὸν υἱὸν καὶ πάντα δείκνυσιν αὐτῷ ἃ αὐτὸς ποιεῖ, καὶ μείζονα τούτων δείξει αὐτῷ ἔργα, ἵνα ὑμεῖς θαυμάζητε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ὥσπερ γὰρ ὁ πατὴρ ἐγείρει τοὺς νεκροὺς καὶ ζῳοποιεῖ, οὕτως καὶ ὁ υἱὸς οὓς θέλει ζῳοποιεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","οὐδὲ γὰρ ὁ πατὴρ κρίνει οὐδένα, ἀλλὰ τὴν κρίσιν πᾶσαν δέδωκεν τῷ υἱῷ, ");
INSERT INTO grcsbl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ἵνα πάντες τιμῶσι τὸν υἱὸν καθὼς τιμῶσι τὸν πατέρα. ὁ μὴ τιμῶν τὸν υἱὸν οὐ τιμᾷ τὸν πατέρα τὸν πέμψαντα αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ὁ τὸν λόγον μου ἀκούων καὶ πιστεύων τῷ πέμψαντί με ἔχει ζωὴν αἰώνιον, καὶ εἰς κρίσιν οὐκ ἔρχεται ἀλλὰ μεταβέβηκεν ἐκ τοῦ θανάτου εἰς τὴν ζωήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι ἔρχεται ὥρα καὶ νῦν ἐστιν ὅτε οἱ νεκροὶ ⸀ἀκούσουσιντῆς φωνῆς τοῦ υἱοῦ τοῦ θεοῦ καὶ οἱ ἀκούσαντες ⸀ζήσουσιν ");
INSERT INTO grcsbl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ὥσπερ γὰρ ὁ πατὴρ ἔχει ζωὴν ἐν ἑαυτῷ, οὕτως ⸂καὶ τῷ υἱῷ ἔδωκεν ζωὴν ἔχειν ἐν ἑαυτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","καὶ ἐξουσίαν ἔδωκεν ⸀αὐτῷκρίσιν ποιεῖν, ὅτι υἱὸς ἀνθρώπου ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","μὴ θαυμάζετε τοῦτο, ὅτι ἔρχεται ὥρα ἐν ᾗ πάντες οἱ ἐν τοῖς μνημείοις ⸀ἀκούσουσιντῆς φωνῆς αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","καὶ ἐκπορεύσονται οἱ τὰ ἀγαθὰ ποιήσαντες εἰς ἀνάστασιν ζωῆς, οἱ ⸀δὲτὰ φαῦλα πράξαντες εἰς ἀνάστασιν κρίσεως. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Οὐ δύναμαι ἐγὼ ποιεῖν ἀπʼ ἐμαυτοῦ οὐδέν· καθὼς ἀκούω κρίνω, καὶ ἡ κρίσις ἡ ἐμὴ δικαία ἐστίν, ὅτι οὐ ζητῶ τὸ θέλημα τὸ ἐμὸν ἀλλὰ τὸ θέλημα τοῦ πέμψαντός ⸀με ");
INSERT INTO grcsbl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ἐὰν ἐγὼ μαρτυρῶ περὶ ἐμαυτοῦ, ἡ μαρτυρία μου οὐκ ἔστιν ἀληθής· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ἄλλος ἐστὶν ὁ μαρτυρῶν περὶ ἐμοῦ, καὶ οἶδα ὅτι ἀληθής ἐστιν ἡ μαρτυρία ἣν μαρτυρεῖ περὶ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ὑμεῖς ἀπεστάλκατε πρὸς Ἰωάννην, καὶ μεμαρτύρηκε τῇ ἀληθείᾳ· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ἐγὼ δὲ οὐ παρὰ ἀνθρώπου τὴν μαρτυρίαν λαμβάνω, ἀλλὰ ταῦτα λέγω ἵνα ὑμεῖς σωθῆτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ἐκεῖνος ἦν ὁ λύχνος ὁ καιόμενος καὶ φαίνων, ὑμεῖς δὲ ἠθελήσατε ἀγαλλιαθῆναι πρὸς ὥραν ἐν τῷ φωτὶ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ἐγὼ δὲ ἔχω τὴν μαρτυρίαν ⸀μείζωτοῦ Ἰωάννου, τὰ γὰρ ἔργα ἃ ⸀δέδωκένμοι ὁ πατὴρ ἵνα τελειώσω αὐτά, αὐτὰ τὰ ἔργα ⸀ἃποιῶ, μαρτυρεῖ περὶ ἐμοῦ ὅτι ὁ πατήρ με ἀπέσταλκεν, ");
INSERT INTO grcsbl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","καὶ ὁ πέμψας με πατὴρ ⸀ἐκεῖνοςμεμαρτύρηκεν περὶ ἐμοῦ. οὔτε φωνὴν αὐτοῦ ⸂πώποτε ἀκηκόατε οὔτε εἶδος αὐτοῦ ἑωράκατε, ");
INSERT INTO grcsbl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","καὶ τὸν λόγον αὐτοῦ οὐκ ἔχετε ⸂ἐν ὑμῖν μένοντα, ὅτι ὃν ἀπέστειλεν ἐκεῖνος τούτῳ ὑμεῖς οὐ πιστεύετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ἐραυνᾶτε τὰς γραφάς, ὅτι ὑμεῖς δοκεῖτε ἐν αὐταῖς ζωὴν αἰώνιον ἔχειν· καὶ ἐκεῖναί εἰσιν αἱ μαρτυροῦσαι περὶ ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","καὶ οὐ θέλετε ἐλθεῖν πρός με ἵνα ζωὴν ἔχητε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","δόξαν παρὰ ἀνθρώπων οὐ λαμβάνω, ");
INSERT INTO grcsbl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ἀλλὰ ἔγνωκα ὑμᾶς ὅτι τὴν ἀγάπην τοῦ θεοῦ οὐκ ἔχετε ἐν ἑαυτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ἐγὼ ἐλήλυθα ἐν τῷ ὀνόματι τοῦ πατρός μου καὶ οὐ λαμβάνετέ με· ἐὰν ἄλλος ἔλθῃ ἐν τῷ ὀνόματι τῷ ἰδίῳ, ἐκεῖνον λήμψεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","πῶς δύνασθε ὑμεῖς πιστεῦσαι, δόξαν παρʼ ἀλλήλων λαμβάνοντες, καὶ τὴν δόξαν τὴν παρὰ τοῦ μόνου θεοῦ οὐ ζητεῖτε; ");
INSERT INTO grcsbl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","μὴ δοκεῖτε ὅτι ἐγὼ κατηγορήσω ὑμῶν πρὸς τὸν πατέρα· ἔστιν ὁ κατηγορῶν ὑμῶν Μωϋσῆς, εἰς ὃν ὑμεῖς ἠλπίκατε. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","εἰ γὰρ ἐπιστεύετε Μωϋσεῖ, ἐπιστεύετε ἂν ἐμοί, περὶ γὰρ ἐμοῦ ἐκεῖνος ἔγραψεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","εἰ δὲ τοῖς ἐκείνου γράμμασιν οὐ πιστεύετε, πῶς τοῖς ἐμοῖς ῥήμασιν πιστεύσετε; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Μετὰ ταῦτα ἀπῆλθεν ὁ Ἰησοῦς πέραν τῆς θαλάσσης τῆς Γαλιλαίας τῆς Τιβεριάδος. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","⸂ἠκολούθει δὲ αὐτῷ ὄχλος πολύς, ὅτι ⸀ἐθεώρουντὰ σημεῖα ἃ ἐποίει ἐπὶ τῶν ἀσθενούντων. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ἀνῆλθεν δὲ εἰς τὸ ⸀ὄροςἸησοῦς, καὶ ἐκεῖ ἐκάθητο μετὰ τῶν μαθητῶν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ἦν δὲ ἐγγὺς τὸ πάσχα, ἡ ἑορτὴ τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ἐπάρας οὖν ⸂τοὺς ὀφθαλμοὺς ὁ Ἰησοῦς καὶ θεασάμενος ὅτι πολὺς ὄχλος ἔρχεται πρὸςαὐτὸν λέγει ⸀πρὸς Φίλιππον· Πόθεν ⸀ἀγοράσωμενἄρτους ἵνα φάγωσιν οὗτοι; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","τοῦτο δὲ ἔλεγεν πειράζων αὐτόν, αὐτὸς γὰρ ᾔδει τί ἔμελλεν ποιεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ἀπεκρίθη ⸀αὐτῷΦίλιππος· Διακοσίων δηναρίων ἄρτοι οὐκ ἀρκοῦσιν αὐτοῖς ἵνα ⸀ἕκαστοςβραχύ ⸀τιλάβῃ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","λέγει αὐτῷ εἷς ἐκ τῶν μαθητῶν αὐτοῦ, Ἀνδρέας ὁ ἀδελφὸς Σίμωνος Πέτρου· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ἔστιν ⸀παιδάριονὧδε ⸀ὃςἔχει πέντε ἄρτους κριθίνους καὶ δύο ὀψάρια· ἀλλὰ ταῦτα τί ἐστιν εἰς τοσούτους; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","⸀εἶπενὁ Ἰησοῦς· Ποιήσατε τοὺς ἀνθρώπους ἀναπεσεῖν. ἦν δὲ χόρτος πολὺς ἐν τῷ τόπῳ. ἀνέπεσαν οὖν οἱ ἄνδρες τὸν ἀριθμὸν ⸀ὡςπεντακισχίλιοι. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ἔλαβεν ⸀οὖντοὺς ἄρτους ὁ Ἰησοῦς καὶ εὐχαριστήσας ⸀διέδωκεντοῖς ἀνακειμένοις, ὁμοίως καὶ ἐκ τῶν ὀψαρίων ὅσον ἤθελον. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ὡς δὲ ἐνεπλήσθησαν λέγει τοῖς μαθηταῖς αὐτοῦ· Συναγάγετε τὰ περισσεύσαντα κλάσματα, ἵνα μή τι ἀπόληται. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","συνήγαγον οὖν, καὶ ἐγέμισαν δώδεκα κοφίνους κλασμάτων ἐκ τῶν πέντε ἄρτων τῶν κριθίνων ἃ ⸀ἐπερίσσευσαντοῖς βεβρωκόσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","οἱ οὖν ἄνθρωποι ἰδόντες ⸂ὃ ἐποίησεν σημεῖον ⸀ἔλεγονὅτι Οὗτός ἐστιν ἀληθῶς ὁ προφήτης ὁ ἐρχόμενος εἰς τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ἰησοῦς οὖν γνοὺς ὅτι μέλλουσιν ἔρχεσθαι καὶ ἁρπάζειν αὐτὸν ἵνα ⸀ποιήσωσινβασιλέα ἀνεχώρησεν ⸀πάλινεἰς τὸ ὄρος αὐτὸς μόνος. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ὡς δὲ ὀψία ἐγένετο κατέβησαν οἱ μαθηταὶ αὐτοῦ ἐπὶ τὴν θάλασσαν, ");
INSERT INTO grcsbl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","καὶ ἐμβάντες ⸀εἰςπλοῖον ἤρχοντο πέραν τῆς θαλάσσης εἰς Καφαρναούμ. καὶ σκοτία ἤδη ἐγεγόνει καὶ ⸀οὔπωἐληλύθει πρὸς αὐτοὺς ὁ Ἰησοῦς, ");
INSERT INTO grcsbl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ἥ τε θάλασσα ἀνέμου μεγάλου πνέοντος ⸀διεγείρετο ");
INSERT INTO grcsbl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ἐληλακότες οὖν ὡς σταδίους εἴκοσι πέντε ἢ τριάκοντα θεωροῦσιν τὸν Ἰησοῦν περιπατοῦντα ἐπὶ τῆς θαλάσσης καὶ ἐγγὺς τοῦ πλοίου γινόμενον, καὶ ἐφοβήθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ὁ δὲ λέγει αὐτοῖς· Ἐγώ εἰμι, μὴ φοβεῖσθε. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ἤθελον οὖν λαβεῖν αὐτὸν εἰς τὸ πλοῖον, καὶ εὐθέως ⸂ἐγένετο τὸ πλοῖον ἐπὶ τῆς γῆς εἰς ἣν ὑπῆγον. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Τῇ ἐπαύριον ὁ ὄχλος ὁ ἑστηκὼς πέραν τῆς θαλάσσης ⸀εἶδονὅτι πλοιάριον ἄλλο οὐκ ἦν ἐκεῖ εἰ μὴ ⸀ἕν καὶ ὅτι οὐ συνεισῆλθεν τοῖς μαθηταῖς αὐτοῦ ὁ Ἰησοῦς εἰς τὸ ⸀πλοῖονἀλλὰ μόνοι οἱ μαθηταὶ αὐτοῦ ἀπῆλθον· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","⸀ἀλλὰἦλθεν ⸀πλοιάριαἐκ Τιβεριάδος ἐγγὺς τοῦ τόπου ὅπου ἔφαγον τὸν ἄρτον εὐχαριστήσαντος τοῦ κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ὅτε οὖν εἶδεν ὁ ὄχλος ὅτι Ἰησοῦς οὐκ ἔστιν ἐκεῖ οὐδὲ οἱ μαθηταὶ αὐτοῦ, ἐνέβησαν αὐτοὶ εἰς τὰ ⸀πλοιάριακαὶ ἦλθον εἰς Καφαρναοὺμ ζητοῦντες τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Καὶ εὑρόντες αὐτὸν πέραν τῆς θαλάσσης εἶπον αὐτῷ· Ῥαββί, πότε ὧδε γέγονας; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς καὶ εἶπεν· Ἀμὴν ἀμὴν λέγω ὑμῖν, ζητεῖτέ με οὐχ ὅτι εἴδετε σημεῖα ἀλλʼ ὅτι ἐφάγετε ἐκ τῶν ἄρτων καὶ ἐχορτάσθητε· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ἐργάζεσθε μὴ τὴν βρῶσιν τὴν ἀπολλυμένην ἀλλὰ τὴν βρῶσιν τὴν μένουσαν εἰς ζωὴν αἰώνιον, ἣν ὁ υἱὸς τοῦ ἀνθρώπου ὑμῖν δώσει, τοῦτον γὰρ ὁ πατὴρ ἐσφράγισεν ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","εἶπον οὖν πρὸς αὐτόν· Τί ποιῶμεν ἵνα ἐργαζώμεθα τὰ ἔργα τοῦ θεοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ἀπεκρίθη ⸀ὁἸησοῦς καὶ εἶπεν αὐτοῖς· Τοῦτό ἐστιν τὸ ἔργον τοῦ θεοῦ ἵνα ⸀πιστεύητεεἰς ὃν ἀπέστειλεν ἐκεῖνος. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","εἶπον οὖν αὐτῷ· Τί οὖν ποιεῖς σὺ σημεῖον, ἵνα ἴδωμεν καὶ πιστεύσωμέν σοι; τί ἐργάζῃ; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","οἱ πατέρες ἡμῶν τὸ μάννα ἔφαγον ἐν τῇ ἐρήμῳ, καθώς ἐστιν γεγραμμένον· Ἄρτον ἐκ τοῦ οὐρανοῦ ἔδωκεν αὐτοῖς φαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς· Ἀμὴν ἀμὴν λέγω ὑμῖν, οὐ Μωϋσῆς ⸀δέδωκενὑμῖν τὸν ἄρτον ἐκ τοῦ οὐρανοῦ, ἀλλʼ ὁ πατήρ μου δίδωσιν ὑμῖν τὸν ἄρτον ἐκ τοῦ οὐρανοῦ τὸν ἀληθινόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ὁ γὰρ ἄρτος τοῦ θεοῦ ἐστιν ὁ καταβαίνων ἐκ τοῦ οὐρανοῦ καὶ ζωὴν διδοὺς τῷ κόσμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","εἶπον οὖν πρὸς αὐτόν· Κύριε, πάντοτε δὸς ἡμῖν τὸν ἄρτον τοῦτον. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","⸀Εἶπεναὐτοῖς ὁ Ἰησοῦς· Ἐγώ εἰμι ὁ ἄρτος τῆς ζωῆς· ὁ ἐρχόμενος πρὸς ἐμὲοὐ μὴ πεινάσῃ, καὶ ὁ πιστεύων εἰς ⸀ἐμὲ οὐ μὴ ⸀διψήσειπώποτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ἀλλʼ εἶπον ὑμῖν ὅτι καὶ ἑωράκατέ με καὶ οὐ πιστεύετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","πᾶν ὃ δίδωσίν μοι ὁ πατὴρ πρὸς ἐμὲ ἥξει, καὶ τὸν ἐρχόμεον πρός ⸀με οὐ μὴ ἐκβάλω ἔξω, ");
INSERT INTO grcsbl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ὅτι καταβέβηκα ⸀ἀπὸτοῦ οὐρανοῦ οὐχ ἵνα ποιῶ τὸ θέλημα τὸ ἐμὸν ἀλλὰ τὸ θέλημα τοῦ πέμψαντός με· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","τοῦτο δέ ἐστιν τὸ θέλημα τοῦ πέμψαντός ⸀μεἵνα πᾶν ὃ δέδωκέν μοι μὴ ἀπολέσω ἐξ αὐτοῦ ἀλλὰ ἀναστήσω ⸀αὐτὸτῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","τοῦτο ⸀γάρἐστιν τὸ θέλημα τοῦ ⸂πατρός μου ἵνα πᾶς ὁ θεωρῶν τὸν υἱὸν καὶ πιστεύων εἰς αὐτὸν ἔχῃ ζωὴν αἰώνιον, καὶ ἀναστήσω αὐτὸν ⸀ἐγὼτῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ἐγόγγυζον οὖν οἱ Ἰουδαῖοι περὶ αὐτοῦ ὅτι εἶπεν· Ἐγώ εἰμι ὁ ἄρτος ὁ καταβὰς ἐκ τοῦ οὐρανοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","καὶ ἔλεγον· ⸀Οὐχοὗτός ἐστιν Ἰησοῦς ὁ υἱὸς Ἰωσήφ, οὗ ἡμεῖς οἴδαμεν τὸν πατέρα καὶ τὴν μητέρα; πῶς ⸀νῦν⸀λέγειὅτι Ἐκ τοῦ οὐρανοῦ καταβέβηκα; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","⸀ἀπεκρίθηἸησοῦς καὶ εἶπεν αὐτοῖς· Μὴ γογγύζετε μετʼ ἀλλήλων. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","οὐδεὶς δύναται ἐλθεῖν πρός ⸀μεἐὰν μὴ ὁ πατὴρ ὁ πέμψας με ἑλκύσῃ αὐτόν, κἀγὼ ἀναστήσω αὐτὸν ἐν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ἔστιν γεγραμμένον ἐν τοῖς προφήταις· Καὶ ἔσονται πάντες διδακτοὶ θεοῦ· ⸀πᾶςὁ ⸀ἀκούσαςπαρὰ τοῦ πατρὸς καὶ μαθὼν ἔρχεται πρὸς ⸀ἐμέ ");
INSERT INTO grcsbl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","οὐχ ὅτι τὸν πατέρα ⸂ἑώρακέν τις εἰ μὴ ὁ ὢν παρὰ τοῦ θεοῦ, οὗτος ἑώρακεν τὸν πατέρα. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ ⸀πιστεύωνἔχει ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ἐγώ εἰμι ὁ ἄρτος τῆς ζωῆς· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","οἱ πατέρες ὑμῶν ἔφαγον ⸂ἐν τῇ ἐρήμῳ τὸ μάννα καὶ ἀπέθανον· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","οὗτός ἐστιν ὁ ἄρτος ὁ ἐκ τοῦ οὐρανοῦ καταβαίνων ἵνα τις ἐξ αὐτοῦ φάγῃ καὶ μὴ ἀποθάνῃ· ");
INSERT INTO grcsbl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ἐγώ εἰμι ὁ ἄρτος ὁ ζῶν ὁ ἐκ τοῦ οὐρανοῦ καταβάς· ἐάν τις φάγῃ ἐκ τούτου τοῦ ἄρτου ⸀ζήσειεἰς τὸν αἰῶνα, καὶ ὁ ἄρτος δὲ ὃν ἐγὼ δώσω ἡ σάρξ μού ⸀ἐστινὑπὲρ τῆς τοῦ κόσμου ζωῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ἐμάχοντο οὖν πρὸς ἀλλήλους οἱ Ἰουδαῖοι λέγοντες· Πῶς δύναται οὗτος ἡμῖν δοῦναι τὴν σάρκα ⸀αὐτοῦφαγεῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς· Ἀμὴν ἀμὴν λέγω ὑμῖν, ἐὰν μὴ φάγητε τὴν σάρκα τοῦ υἱοῦ τοῦ ἀνθρώπου καὶ πίητε αὐτοῦ τὸ αἷμα, οὐκ ἔχετε ζωὴν ἐν ἑαυτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ὁ τρώγων μου τὴν σάρκα καὶ πίνων μου τὸ αἷμα ἔχει ζωὴν αἰώνιον, κἀγὼ ἀναστήσω αὐτὸν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ἡ γὰρ σάρξ μου ⸀ἀληθήςἐστι βρῶσις, καὶ τὸ αἷμά μου ⸁ἀληθήςἐστι πόσις. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ὁ τρώγων μου τὴν σάρκα καὶ πίνων μου τὸ αἷμα ἐν ἐμοὶ μένει κἀγὼ ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","καθὼς ἀπέστειλέν με ὁ ζῶν πατὴρ κἀγὼ ζῶ διὰ τὸν πατέρα, καὶ ὁ τρώγων με κἀκεῖνος ⸀ζήσειδιʼ ἐμέ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","οὗτός ἐστιν ὁ ἄρτος ὁ ⸀ἐξοὐρανοῦ καταβάς, οὐ καθὼς ἔφαγον οἱ ⸀πατέρεςκαὶ ἀπέθανον· ὁ τρώγων τοῦτον τὸν ἄρτον ⸀ζήσειεἰς τὸν αἰῶνα. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ταῦτα εἶπεν ἐν συναγωγῇ διδάσκων ἐν Καφαρναούμ. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Πολλοὶ οὖν ἀκούσαντες ἐκ τῶν μαθητῶν αὐτοῦ εἶπαν· Σκληρός ἐστιν ⸂ὁ λόγος οὗτος· τίς δύναται αὐτοῦ ἀκούειν; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","εἰδὼς δὲ ὁ Ἰησοῦς ἐν ἑαυτῷ ὅτι γογγύζουσιν περὶ τούτου οἱ μαθηταὶ αὐτοῦ εἶπεν αὐτοῖς· Τοῦτο ὑμᾶς σκανδαλίζει; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ἐὰν οὖν θεωρῆτε τὸν υἱὸν τοῦ ἀνθρώπου ἀναβαίνοντα ὅπου ἦν τὸ πρότερον; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","τὸ πνεῦμά ἐστιν τὸ ζῳοποιοῦν, ἡ σὰρξ οὐκ ὠφελεῖ οὐδέν· τὰ ῥήματα ἃ ἐγὼ ⸀λελάληκαὑμῖν πνεῦμά ἐστιν καὶ ζωή ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ἀλλὰ εἰσὶν ἐξ ὑμῶν τινες οἳ οὐ πιστεύουσιν. ᾔδει γὰρ ἐξ ἀρχῆς ὁ Ἰησοῦς τίνες εἰσὶν οἱ μὴ πιστεύοντες καὶ τίς ἐστιν ὁ παραδώσων αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","καὶ ἔλεγεν· Διὰ τοῦτο εἴρηκα ὑμῖν ὅτι οὐδεὶς δύναται ἐλθεῖν πρός με ἐὰν μὴ ᾖ δεδομένον αὐτῷ ἐκ τοῦ ⸀πατρός ");
INSERT INTO grcsbl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ἐκ τούτου πολλοὶ ⸀ἐκ⸂τῶν μαθητῶν αὐτοῦ ἀπῆλθον εἰς τὰ ὀπίσω καὶ οὐκέτι μετʼ αὐτοῦ περιεπάτουν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","εἶπεν οὖν ὁ Ἰησοῦς τοῖς δώδεκα· Μὴ καὶ ὑμεῖς θέλετε ὑπάγειν; ");
INSERT INTO grcsbl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","⸀ἀπεκρίθηαὐτῷ Σίμων Πέτρος· Κύριε, πρὸς τίνα ἀπελευσόμεθα; ῥήματα ζωῆς αἰωνίου ἔχεις, ");
INSERT INTO grcsbl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","καὶ ἡμεῖς πεπιστεύκαμεν καὶ ἐγνώκαμεν ὅτι σὺ εἶ ὁ ⸀ἅγιοςτοῦ ⸀θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς· Οὐκ ἐγὼ ὑμᾶς τοὺς δώδεκα ἐξελεξάμην; καὶ ἐξ ὑμῶν εἷς διάβολός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ἔλεγεν δὲ τὸν Ἰούδαν Σίμωνος ⸀Ἰσκαριώτου οὗτος γὰρ ἔμελλεν ⸂παραδιδόναι αὐτόν, ⸀εἷςἐκ τῶν δώδεκα. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Καὶ ⸂μετὰ ταῦτα περιεπάτει ὁ Ἰησοῦς ἐν τῇ Γαλιλαίᾳ, οὐ γὰρ ἤθελεν ἐν τῇ Ἰουδαίᾳ περιπατεῖν, ὅτι ἐζήτουν αὐτὸν οἱ Ἰουδαῖοι ἀποκτεῖναι. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ἦν δὲ ἐγγὺς ἡ ἑορτὴ τῶν Ἰουδαίων ἡ σκηνοπηγία. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","εἶπον οὖν πρὸς αὐτὸν οἱ ἀδελφοὶ αὐτοῦ· Μετάβηθι ἐντεῦθεν καὶ ὕπαγε εἰς τὴν Ἰουδαίαν, ἵνα καὶ οἱ μαθηταί σου ⸀θεωρήσουσιν⸂σοῦ τὰ ἔργα ἃ ποιεῖς· ");
INSERT INTO grcsbl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","οὐδεὶς γάρ ⸂τι ἐν κρυπτῷ ποιεῖ καὶ ζητεῖ αὐτὸς ἐν παρρησίᾳ εἶναι· εἰ ταῦτα ποιεῖς, φανέρωσον σεαυτὸν τῷ κόσμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","οὐδὲ γὰρ οἱ ἀδελφοὶ αὐτοῦ ἐπίστευον εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","λέγει οὖν αὐτοῖς ὁ Ἰησοῦς· Ὁ καιρὸς ὁ ἐμὸς οὔπω πάρεστιν, ὁ δὲ καιρὸς ὁ ὑμέτερος πάντοτέ ἐστιν ἕτοιμος. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","οὐ δύναται ὁ κόσμος μισεῖν ὑμᾶς, ἐμὲ δὲ μισεῖ, ὅτι ἐγὼ μαρτυρῶ περὶ αὐτοῦ ὅτι τὰ ἔργα αὐτοῦ πονηρά ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ὑμεῖς ἀνάβητε εἰς τὴν ⸀ἑορτήν ἐγὼ ⸀οὐκἀναβαίνω εἰς τὴν ἑορτὴν ταύτην, ὅτι ὁ ⸂ἐμὸς καιρὸς οὔπω πεπλήρωται. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ταῦτα ⸀δὲεἰπὼν ⸀αὐτὸςἔμεινεν ἐν τῇ Γαλιλαίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ὡς δὲ ἀνέβησαν οἱ ἀδελφοὶ αὐτοῦ ⸂εἰς τὴν ἑορτήν, τότε καὶ αὐτὸς ἀνέβη⸃, οὐ φανερῶς ἀλλὰ ὡς ἐν κρυπτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","οἱ οὖν Ἰουδαῖοι ἐζήτουν αὐτὸν ἐν τῇ ἑορτῇ καὶ ἔλεγον· Ποῦ ἐστιν ἐκεῖνος; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","καὶ γογγυσμὸς ⸂περὶ αὐτοῦ ἦν πολὺς ἐν τοῖς ὄχλοις· οἱ μὲν ἔλεγον ὅτι Ἀγαθός ἐστιν, ἄλλοι ⸀δὲἔλεγον· Οὔ, ἀλλὰ πλανᾷ τὸν ὄχλον. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","οὐδεὶς μέντοι παρρησίᾳ ἐλάλει περὶ αὐτοῦ διὰ τὸν φόβον τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ἤδη δὲ τῆς ἑορτῆς μεσούσης ⸀ἀνέβηἸησοῦς εἰς τὸ ἱερὸν καὶ ἐδίδασκεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","⸂ἐθαύμαζον οὖν οἱ Ἰουδαῖοι λέγοντες· Πῶς οὗτος γράμματα οἶδεν μὴ μεμαθηκώς; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ἀπεκρίθη οὖν αὐτοῖς ⸀ὁἸησοῦς καὶ εἶπεν· Ἡ ἐμὴ διδαχὴ οὐκ ἔστιν ἐμὴ ἀλλὰ τοῦ πέμψαντός με· ");
INSERT INTO grcsbl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ἐάν τις θέλῃ τὸ θέλημα αὐτοῦ ποιεῖν, γνώσεται περὶ τῆς διδαχῆς πότερον ἐκ τοῦ θεοῦ ἐστιν ἢ ἐγὼ ἀπʼ ἐμαυτοῦ λαλῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ὁ ἀφʼ ἑαυτοῦ λαλῶν τὴν δόξαν τὴν ἰδίαν ζητεῖ· ὁ δὲ ζητῶν τὴν δόξαν τοῦ πέμψαντος αὐτὸν οὗτος ἀληθής ἐστιν καὶ ἀδικία ἐν αὐτῷ οὐκ ἔστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Οὐ Μωϋσῆς ⸀δέδωκενὑμῖν τὸν νόμον; καὶ οὐδεὶς ἐξ ὑμῶν ποιεῖ τὸν νόμον. τί με ζητεῖτε ἀποκτεῖναι; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ἀπεκρίθη ὁ ⸀ὄχλος Δαιμόνιον ἔχεις· τίς σε ζητεῖ ἀποκτεῖναι; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτοῖς· Ἓν ἔργον ἐποίησα καὶ πάντες θαυμάζετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","διὰ τοῦτο Μωϋσῆς δέδωκεν ὑμῖν τὴν περιτομήν— οὐχ ὅτι ἐκ τοῦ Μωϋσέως ἐστὶν ἀλλʼ ἐκ τῶν πατέρων— καὶ ἐν σαββάτῳ περιτέμνετε ἄνθρωπον. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","εἰ περιτομὴν ⸀λαμβάνειἄνθρωπος ἐν σαββάτῳ ἵνα μὴ λυθῇ ὁ νόμος Μωϋσέως, ἐμοὶ χολᾶτε ὅτι ὅλον ἄνθρωπον ὑγιῆ ἐποίησα ἐν σαββάτῳ; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","μὴ κρίνετεκατʼ ὄψιν, ἀλλὰ τὴν δικαίαν κρίσιν ⸀κρίνετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ἔλεγον οὖν τινες ἐκ τῶν Ἱεροσολυμιτῶν· Οὐχ οὗτός ἐστιν ὃν ζητοῦσιν ἀποκτεῖναι; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","καὶ ἴδε παρρησίᾳ λαλεῖ καὶ οὐδὲν αὐτῷ λέγουσιν· μήποτε ἀληθῶς ἔγνωσαν οἱ ἄρχοντες ὅτι οὗτός ⸀ἐστινὁ χριστός; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ἀλλὰ τοῦτον οἴδαμεν πόθεν ἐστίν· ὁ δὲ χριστὸς ὅταν ἔρχηται οὐδεὶς γινώσκει πόθεν ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ἔκραξεν οὖν ἐν τῷ ἱερῷ διδάσκων ὁ Ἰησοῦς καὶ λέγων· Κἀμὲ οἴδατε καὶ οἴδατε πόθεν εἰμί· καὶ ἀπʼ ἐμαυτοῦ οὐκ ἐλήλυθα, ἀλλʼ ἔστιν ἀληθινὸς ὁ πέμψας με, ὃν ὑμεῖς οὐκ οἴδατε· ");
INSERT INTO grcsbl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ἐγὼ οἶδα αὐτόν, ὅτι παρʼ αὐτοῦ εἰμι κἀκεῖνός με ἀπέστειλεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ἐζήτουν οὖν αὐτὸν πιάσαι, καὶ οὐδεὶς ἐπέβαλεν ἐπʼ αὐτὸν τὴν χεῖρα, ὅτι οὔπω ἐληλύθει ἡ ὥρα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","⸂ἐκ τοῦ ὄχλου δὲ πολλοὶ ἐπίστευσαν εἰς αὐτόν, καὶ ⸀ἔλεγον Ὁ χριστὸς ὅταν ἔλθῃ ⸀μὴπλείονα ⸀σημεῖαποιήσει ὧν οὗτος ἐποίησεν; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ἤκουσαν οἱ Φαρισαῖοι τοῦ ὄχλου γογγύζοντος περὶ αὐτοῦ ταῦτα, καὶ ἀπέστειλαν ⸂οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι ὑπηρέτας ἵνα πιάσωσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","εἶπεν οὖν ὁ Ἰησοῦς· Ἔτι ⸂χρόνον μικρὸν μεθʼ ὑμῶν εἰμι καὶ ὑπάγω πρὸς τὸν πέμψαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ζητήσετέ με καὶ οὐχ ⸀εὑρήσετε καὶ ὅπου εἰμὶ ἐγὼ ὑμεῖς οὐ δύνασθε ἐλθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","εἶπον οὖν οἱ Ἰουδαῖοι πρὸς ἑαυτούς· Ποῦ οὗτος μέλλει πορεύεσθαι ὅτι ἡμεῖς οὐχ εὑρήσομεν αὐτόν; μὴ εἰς τὴν διασπορὰν τῶν Ἑλλήνων μέλλει πορεύεσθαι καὶ διδάσκειν τοὺς Ἕλληνας; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","τίς ἐστιν ⸂ὁ λόγος οὗτος ὃν εἶπε· Ζητήσετέ με καὶ οὐχ ⸀εὑρήσετε καὶ ὅπου εἰμὶ ἐγὼ ὑμεῖς οὐ δύνασθε ἐλθεῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ἐν δὲ τῇ ἐσχάτῃ ἡμέρᾳ τῇ μεγάλῃ τῆς ἑορτῆς εἱστήκει ὁ Ἰησοῦς, καὶ ἔκραξεν λέγων· Ἐάν τις διψᾷ ἐρχέσθω πρός με καὶ πινέτω. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ὁ πιστεύων εἰς ἐμέ, καθὼς εἶπεν ἡ γραφή, ποταμοὶ ἐκ τῆς κοιλίας αὐτοῦ ῥεύσουσιν ὕδατος ζῶντος. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","τοῦτο δὲ εἶπεν περὶ τοῦ πνεύματος ⸀οὗἔμελλον λαμβάνειν οἱ ⸀πιστεύσαντεςεἰς αὐτόν· οὔπω γὰρ ἦν ⸀πνεῦμα ὅτι Ἰησοῦς ⸀οὐδέπωἐδοξάσθη. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","⸂Ἐκ τοῦ ὄχλου οὖν ἀκούσαντες ⸂τῶν λόγων τούτων ⸀ἔλεγον Οὗτός ἐστιν ἀληθῶς ὁ προφήτης· ");
INSERT INTO grcsbl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ἄλλοι ἔλεγον· Οὗτός ἐστιν ὁ χριστός· ⸂οἱ δὲ ἔλεγον· Μὴ γὰρ ἐκ τῆς Γαλιλαίας ὁ χριστὸς ἔρχεται; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","⸀οὐχἡ γραφὴ εἶπεν ὅτι ἐκ τοῦ σπέρματος Δαυίδ, καὶ ἀπὸ Βηθλέεμ τῆς κώμης ὅπου ἦν Δαυίδ, ⸂ἔρχεται ὁ χριστός; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","σχίσμα οὖν ⸂ἐγένετο ἐν τῷ ὄχλῳ διʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","τινὲς δὲ ἤθελον ἐξ αὐτῶν πιάσαι αὐτόν, ἀλλʼ οὐδεὶς ⸀ἐπέβαλενἐπʼ αὐτὸν τὰς χεῖρας. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ἦλθον οὖν οἱ ὑπηρέται πρὸς τοὺς ἀρχιερεῖς καὶ Φαρισαίους, καὶ εἶπον αὐτοῖς ἐκεῖνοι· Διὰ τί οὐκ ἠγάγετε αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ἀπεκρίθησαν οἱ ὑπηρέται· Οὐδέποτε ⸂ἐλάλησεν οὕτως ⸀ἄνθρωπος ");
INSERT INTO grcsbl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ἀπεκρίθησαν οὖν αὐτοῖς οἱ Φαρισαῖοι· Μὴ καὶ ὑμεῖς πεπλάνησθε; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","μή τις ἐκ τῶν ἀρχόντων ἐπίστευσεν εἰς αὐτὸν ἢ ἐκ τῶν Φαρισαίων; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ἀλλὰ ὁ ὄχλος οὗτος ὁ μὴ γινώσκων τὸν νόμον ⸀ἐπάρατοίεἰσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","λέγει Νικόδημος πρὸς αὐτούς, ὁ ⸀ἐλθὼνπρὸς αὐτὸν ⸀πρότερον εἷς ὢν ἐξ αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Μὴ ὁ νόμος ἡμῶν κρίνει τὸν ἄνθρωπον ἐὰν μὴ ἀκούσῃ ⸂πρῶτον παρʼ αὐτοῦ καὶ γνῷ τί ποιεῖ; ");
INSERT INTO grcsbl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ἀπεκρίθησαν καὶ εἶπαν αὐτῷ· Μὴ καὶ σὺ ἐκ τῆς Γαλιλαίας εἶ; ἐραύνησον καὶ ἴδε ὅτι ⸂ἐκ τῆς Γαλιλαίας προφήτης οὐκ ⸀ἐγείρεται ");
INSERT INTO grcsbl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","⟦καὶ ἐπορεύθη ἕκαστος εἰς τὸν οἶκον αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ἰησοῦς δὲ ἐπορεύθη εἰς τὸ ὄρος τῶν Ἐλαιῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ὄρθρου δὲ πάλιν παρεγένετο εἰς τὸ ἱερόν, καὶ πᾶς ὁ λαὸς ἤρχετο· καὶ καθίσας ἐδίδασκεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ἄγουσιν δὲ οἱ γραμματεῖς καὶ οἱ Φαρισαῖοι πρὸς αὐτὸν γυναῖκα ἐν μοιχείᾳ καταλήφθεισαν· καὶ στήσαντες αὐτὴν ἐν μέσῳ, ");
INSERT INTO grcsbl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","λέγουσιν αὐτῷ, πειράζοντες· Διδάσκαλε, αὕτη ἡ γυνὴ κατελήφθη ἐπʼ αὐτοφόρῳ μοιχευομένη. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ἐν δὲ τῷ νόμῳ Μωσῆς ἡμῖν ἐνετείλατο τὰς τοιαύτας λιθοβολεῖσθαι· σὺ οὖν τί λέγεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","τοῦτο δὲ ἔλεγον πειράζοντες αὐτόν, ἵνα ἔχωσιν κατηγορεῖν αὐτοῦ. ὁ δὲ Ἰησοῦς κάτω κύψας, τῷ δακτύλῳ ἔγραφεν εἰς τὴν γῆν, μὴ προσποιούμενος. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ὡς δὲ ἐπέμενον ἐρωτῶντες αὐτόν, ἀνακύψας εἶπεν πρὸς αὐτούς· Ὁ ἀναμάρτητος ὑμῶν, πρῶτον ἐπʼ αὐτὴν τὸν λίθον βαλέτω. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","καὶ πάλιν κάτω κύψας ἔγραφεν εἰς τὴν γῆν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","οἱ δέ, ἀκούσαντες, καὶ ὑπὸ τῆς συνειδήσεως ἐλεγχόμενοι, ἐξήρχοντο εἷς καθʼ εἷς, ἀρξάμενοι ἀπὸ τῶν πρεσβυτέρων· καὶ κατελείφθη μόνος ὁ Ἰησοῦς, καὶ ἡ γυνὴ ἐν μέσῳ οὖσα. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ἀνακύψας δὲ ὁ Ἰησοῦς, καὶ μηδένα θεασάμενος πλὴν τὴς γυναικός, εἶπεν αὐτῇ· Ποῦ εἰσιν ἐκεῖνοι οἱ κατήγοροί σου; Οὐδείς σε κατέκρινεν; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ἡ δὲ εἶπεν· Οὐδείς, κύριε. εἶπεν δὲ ὁ Ἰησοῦς· Οὐδὲ ἐγώ σε κρίνω· πορεύου καὶ μηκέτι ἁμάρτανε.⟧ ");
INSERT INTO grcsbl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Πάλιν οὖν αὐτοῖς ⸂ἐλάλησεν ὁ Ἰησοῦς λέγων· Ἐγώ εἰμι τὸ φῶς τοῦ κόσμου· ὁ ἀκολουθῶν ⸀ἐμοὶοὐ μὴ περιπατήσῃ ἐν τῇ σκοτίᾳ, ἀλλʼ ἕξει τὸ φῶς τῆς ζωῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","εἶπον οὖν αὐτῷ οἱ Φαρισαῖοι· Σὺ περὶ σεαυτοῦ μαρτυρεῖς· ἡ μαρτυρία σου οὐκ ἔστιν ἀληθής. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτοῖς· Κἂν ἐγὼ μαρτυρῶ περὶ ἐμαυτοῦ, ἀληθής ἐστιν ἡ μαρτυρία μου, ὅτι οἶδα πόθεν ἦλθον καὶ ποῦ ὑπάγω· ὑμεῖς δὲ οὐκ οἴδατε πόθεν ἔρχομαι ⸀ἢποῦ ὑπάγω. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ὑμεῖς κατὰ τὴν σάρκα κρίνετε, ἐγὼ οὐ κρίνω οὐδένα. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","καὶ ἐὰν κρίνω δὲ ἐγώ, ἡ κρίσις ἡ ἐμὴ ⸀ἀληθινήἐστιν, ὅτι μόνος οὐκ εἰμί, ἀλλʼ ἐγὼ καὶ ὁ πέμψας με πατήρ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","καὶ ἐν τῷ νόμῳ δὲ τῷ ὑμετέρῳ γέγραπται ὅτι δύο ἀνθρώπων ἡ μαρτυρία ἀληθής ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ἐγώ εἰμι ὁ μαρτυρῶν περὶ ἐμαυτοῦ καὶ μαρτυρεῖ περὶ ἐμοῦ ὁ πέμψας με πατήρ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ἔλεγον οὖν αὐτῷ· Ποῦ ἐστιν ὁ πατήρ σου; ἀπεκρίθη Ἰησοῦς· Οὔτε ἐμὲ οἴδατε οὔτε τὸν πατέρα μου· εἰ ἐμὲ ᾔδειτε, καὶ τὸν πατέρα μου ⸂ἂν ᾔδειτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ταῦτα τὰ ῥήματα ⸀ἐλάλησενἐν τῷ γαζοφυλακίῳ διδάσκων ἐν τῷ ἱερῷ· καὶ οὐδεὶς ἐπίασεν αὐτόν, ὅτι οὔπω ἐληλύθει ἡ ὥρα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Εἶπεν οὖν πάλιν ⸀αὐτοῖς Ἐγὼ ὑπάγω καὶ ζητήσετέ με, καὶ ἐν τῇ ἁμαρτίᾳ ὑμῶν ἀποθανεῖσθε· ὅπου ἐγὼ ὑπάγω ὑμεῖς οὐ δύνασθε ἐλθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ἔλεγον οὖν οἱ Ἰουδαῖοι· Μήτι ἀποκτενεῖ ἑαυτὸν ὅτι λέγει· Ὅπου ἐγὼ ὑπάγω ὑμεῖς οὐ δύνασθε ἐλθεῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","καὶ ⸀ἔλεγεναὐτοῖς· Ὑμεῖς ἐκ τῶν κάτω ἐστέ, ἐγὼ ἐκ τῶν ἄνω εἰμί· ὑμεῖς ἐκ ⸂τούτου τοῦ κόσμου ἐστέ, ἐγὼ οὐκ εἰμὶ ἐκ τοῦ κόσμου τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","εἶπον οὖν ὑμῖν ὅτι ἀποθανεῖσθε ἐν ταῖς ἁμαρτίαις ὑμῶν· ἐὰν γὰρ μὴ πιστεύσητε ὅτι ἐγώ εἰμι, ἀποθανεῖσθε ἐν ταῖς ἁμαρτίαις ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ἔλεγον οὖν αὐτῷ· Σὺ τίς εἶ; ⸀εἶπεναὐτοῖς ὁ Ἰησοῦς· Τὴν ἀρχὴν ⸂ὅ τι καὶ λαλῶ ὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","πολλὰ ἔχω περὶ ὑμῶν λαλεῖν καὶ κρίνειν· ἀλλʼ ὁ πέμψας με ἀληθής ἐστιν, κἀγὼ ἃ ἤκουσα παρʼ αὐτοῦ ταῦτα ⸀λαλῶεἰς τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","οὐκ ἔγνωσαν ὅτι τὸν πατέρα αὐτοῖς ἔλεγεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","εἶπεν ⸀οὖνὁ Ἰησοῦς· Ὅταν ὑψώσητε τὸν υἱὸν τοῦ ἀνθρώπου, τότε γνώσεσθε ὅτι ἐγώ εἰμι, καὶ ἀπʼ ἐμαυτοῦ ποιῶ οὐδέν, ἀλλὰ καθὼς ἐδίδαξέν με ὁ ⸀πατὴρταῦτα λαλῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","καὶ ὁ πέμψας με μετʼ ἐμοῦ ἐστιν· οὐκ ἀφῆκέν με ⸀μόνον ὅτι ἐγὼ τὰ ἀρεστὰ αὐτῷ ποιῶ πάντοτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ταῦτα αὐτοῦ λαλοῦντος πολλοὶ ἐπίστευσαν εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ἔλεγεν οὖν ὁ Ἰησοῦς πρὸς τοὺς πεπιστευκότας αὐτῷ Ἰουδαίους· Ἐὰν ὑμεῖς μείνητε ἐν τῷ λόγῳ τῷ ἐμῷ, ἀληθῶς μαθηταί μού ἐστε, ");
INSERT INTO grcsbl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","καὶ γνώσεσθε τὴν ἀλήθειαν, καὶ ἡ ἀλήθεια ἐλευθερώσει ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ἀπεκρίθησαν ⸂πρὸς αὐτόν· Σπέρμα Ἀβραάμ ἐσμεν καὶ οὐδενὶ δεδουλεύκαμεν πώποτε· πῶς σὺ λέγεις ὅτι Ἐλεύθεροι γενήσεσθε; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς· Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι πᾶς ὁ ποιῶν τὴν ἁμαρτίαν δοῦλός ἐστιν τῆς ἁμαρτίας· ");
INSERT INTO grcsbl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ὁδὲ δοῦλος οὐ μένει ἐν τῇ οἰκίᾳ εἰς τὸν αἰῶνα· ⸀ὁ υἱὸς μένει εἰς τὸν αἰῶνα. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ἐὰν οὖν ὁ υἱὸς ὑμᾶς ἐλευθερώσῃ, ὄντως ἐλεύθεροι ἔσεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","οἶδα ὅτι σπέρμα Ἀβραάμ ἐστε· ἀλλὰ ζητεῖτέ με ἀποκτεῖναι, ὅτι ὁ λόγος ὁ ἐμὸς οὐ χωρεῖ ἐν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","⸂ἃ ἐγὼ ἑώρακα παρὰ τῷ ⸀πατρὶλαλῶ· καὶ ὑμεῖς οὖν ⸂ἃ ἠκούσατε παρὰ ⸂τοῦ πατρὸς ποιεῖτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ἀπεκρίθησαν καὶ εἶπαν αὐτῷ· Ὁ πατὴρ ἡμῶν Ἀβραάμ ἐστιν. λέγει αὐτοῖς ὁ Ἰησοῦς· Εἰ τέκνα τοῦ Ἀβραάμ ⸀ἐστε τὰ ἔργα τοῦ Ἀβραὰμ ⸀ἐποιεῖτε ");
INSERT INTO grcsbl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","νῦν δὲ ζητεῖτέ με ἀποκτεῖναι, ἄνθρωπον ὃς τὴν ἀλήθειαν ὑμῖν λελάληκα ἣν ἤκουσα παρὰ τοῦ θεοῦ· τοῦτο Ἀβραὰμ οὐκ ἐποίησεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ὑμεῖς ποιεῖτε τὰ ἔργα τοῦ πατρὸς ὑμῶν. ⸀εἶπαναὐτῷ· Ἡμεῖς ἐκ πορνείας ⸂οὐ γεγεννήμεθα· ἕνα πατέρα ἔχομεν τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","⸀εἶπεναὐτοῖς ὁ Ἰησοῦς· Εἰ ὁ θεὸς πατὴρ ὑμῶν ἦν ἠγαπᾶτε ἂν ἐμέ, ἐγὼ γὰρ ἐκ τοῦ θεοῦ ἐξῆλθον καὶ ἥκω· οὐδὲ γὰρ ἀπʼ ἐμαυτοῦ ἐλήλυθα, ἀλλʼ ἐκεῖνός με ἀπέστειλεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","διὰ τί τὴν λαλιὰν τὴν ἐμὴν οὐ γινώσκετε; ὅτι οὐ δύνασθε ἀκούειν τὸν λόγον τὸν ἐμόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ὑμεῖς ἐκ τοῦ πατρὸς τοῦ διαβόλου ἐστὲ καὶ τὰς ἐπιθυμίας τοῦ πατρὸς ὑμῶν θέλετε ποιεῖν. ἐκεῖνος ἀνθρωποκτόνος ἦν ἀπʼ ἀρχῆς, καὶ ἐν τῇ ἀληθείᾳ ⸂οὐκ ἔστηκεν, ὅτι οὐκ ἔστιν ἀλήθεια ἐν αὐτῷ. ὅταν λαλῇ τὸ ψεῦδος, ἐκ τῶν ἰδίων λαλεῖ, ὅτι ψεύστης ἐστὶν καὶ ὁ πατὴρ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ἐγὼ δὲ ὅτι τὴν ἀλήθειαν λέγω, οὐ πιστεύετέ μοι. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","τίς ἐξ ὑμῶν ἐλέγχει με περὶ ἁμαρτίας; ⸀εἰἀλήθειαν λέγω, διὰ τί ὑμεῖς οὐ πιστεύετέ μοι; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ὁ ὢν ἐκ τοῦ θεοῦ τὰ ῥήματα τοῦ θεοῦ ἀκούει· διὰ τοῦτο ὑμεῖς οὐκ ἀκούετε ὅτι ἐκ τοῦ θεοῦ οὐκ ἐστέ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","⸀Ἀπεκρίθησανοἱ Ἰουδαῖοι καὶ εἶπαν αὐτῷ· Οὐ καλῶς λέγομεν ἡμεῖς ὅτι Σαμαρίτης εἶ σὺ καὶ δαιμόνιον ἔχεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ἀπεκρίθη Ἰησοῦς· Ἐγὼ δαιμόνιον οὐκ ἔχω, ἀλλὰ τιμῶ τὸν πατέρα μου, καὶ ὑμεῖς ἀτιμάζετέ με. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ἐγὼ δὲ οὐ ζητῶ τὴν δόξαν μου· ἔστιν ὁ ζητῶν καὶ κρίνων. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ἀμὴν ἀμὴν λέγω ὑμῖν, ἐάν τις τὸν ⸂ἐμὸν λόγον τηρήσῃ, θάνατον οὐ μὴ θεωρήσῃ εἰς τὸν αἰῶνα. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","⸀εἶποναὐτῷ οἱ Ἰουδαῖοι· Νῦν ἐγνώκαμεν ὅτι δαιμόνιον ἔχεις. Ἀβραὰμ ἀπέθανεν καὶ οἱ προφῆται, καὶ σὺ λέγεις· Ἐάν τις τὸν λόγον μου τηρήσῃ, οὐ μὴ γεύσηται θανάτου εἰς τὸν αἰῶνα· ");
INSERT INTO grcsbl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","μὴ σὺ μείζων εἶ τοῦ πατρὸς ἡμῶν Ἀβραάμ, ὅστις ἀπέθανεν; καὶ οἱ προφῆται ἀπέθανον· τίνα ⸀σεαυτὸνποιεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ἀπεκρίθη Ἰησοῦς· Ἐὰν ἐγὼ ⸀δοξάσωἐμαυτόν, ἡ δόξα μου οὐδέν ἐστιν· ἔστιν ὁ πατήρ μου ὁ δοξάζων με, ὃν ὑμεῖς λέγετε ὅτι θεὸς ⸀ἡμῶνἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","καὶ οὐκ ἐγνώκατε αὐτόν, ἐγὼ δὲ οἶδα αὐτόν· κἂν εἴπω ὅτι οὐκ οἶδα αὐτόν, ἔσομαι ὅμοιος ⸀ὑμῖνψεύστης· ἀλλὰ οἶδα αὐτὸν καὶ τὸν λόγον αὐτοῦ τηρῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ἀβραὰμ ὁ πατὴρ ὑμῶν ἠγαλλιάσατο ἵνα ἴδῃ τὴν ἡμέραν τὴν ἐμήν, καὶ εἶδεν καὶ ἐχάρη. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","εἶπον οὖν οἱ Ἰουδαῖοι πρὸς αὐτόν· Πεντήκοντα ἔτη οὔπω ἔχεις καὶ Ἀβραὰμ ἑώρακας; ");
INSERT INTO grcsbl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","εἶπεν ⸀αὐτοῖςἸησοῦς· Ἀμὴν ἀμὴν λέγω ὑμῖν, πρὶν Ἀβραὰμ γενέσθαι ἐγὼ εἰμί. ");
INSERT INTO grcsbl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ἦραν οὖν λίθους ἵνα βάλωσιν ἐπʼ αὐτόν· Ἰησοῦς δὲ ἐκρύβη καὶ ἐξῆλθεν ἐκ τοῦ ⸀ἱεροῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Καὶ παράγων εἶδεν ἄνθρωπον τυφλὸν ἐκ γενετῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","καὶ ἠρώτησαν αὐτὸν οἱ μαθηταὶ αὐτοῦ λέγοντες· Ῥαββί, τίς ἥμαρτεν, οὗτος ἢ οἱ γονεῖς αὐτοῦ, ἵνα τυφλὸς γεννηθῇ; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ἀπεκρίθη Ἰησοῦς· Οὔτε οὗτος ἥμαρτεν οὔτε οἱ γονεῖς αὐτοῦ, ἀλλʼ ἵνα φανερωθῇ τὰ ἔργα τοῦ θεοῦ ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","⸀ἡμᾶςδεῖ ἐργάζεσθαι τὰ ἔργα τοῦ πέμψαντός με ἕως ἡμέρα ἐστίν· ἔρχεται νὺξ ὅτε οὐδεὶς δύναται ἐργάζεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ὅταν ἐν τῷ κόσμῳ ὦ, φῶς εἰμι τοῦ κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ταῦτα εἰπὼν ἔπτυσεν χαμαὶ καὶ ἐποίησεν πηλὸν ἐκ τοῦ πτύσματος, καὶ ⸀ἐπέχρισεν⸀αὐτοῦτὸν πηλὸν ἐπὶ τοὺς ⸀ὀφθαλμούς ");
INSERT INTO grcsbl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","καὶ εἶπεν αὐτῷ· Ὕπαγε νίψαι εἰς τὴν κολυμβήθραν τοῦ Σιλωάμ (ὃ ἑρμηνεύεται Ἀπεσταλμένος). ἀπῆλθεν οὖν καὶ ἐνίψατο, καὶ ἦλθεν βλέπων. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","οἱ οὖν γείτονες καὶ οἱ θεωροῦντες αὐτὸν τὸ πρότερον ὅτι ⸀προσαίτηςἦν ἔλεγον· Οὐχ οὗτός ἐστιν ὁ καθήμενος καὶ προσαιτῶν; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ἄλλοι ἔλεγον ὅτι Οὗτός ἐστιν· ἄλλοι ⸂ἔλεγον· Οὐχί, ἀλλὰ⸃ ὅμοιος αὐτῷ ἐστιν. ἐκεῖνος ἔλεγεν ὅτι Ἐγώ εἰμι. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ἔλεγον οὖν αὐτῷ· ⸀Πῶςἠνεῴχθησάν σου οἱ ὀφθαλμοί; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ἀπεκρίθη ⸀ἐκεῖνος ⸂Ὁ ἄνθρωπος ὁ λεγόμενος Ἰησοῦς πηλὸν ἐποίησεν καὶ ἐπέχρισέν μου τοὺς ὀφθαλμοὺς καὶ εἶπέν μοι ⸀ὅτιὝπαγε εἰς ⸀τὸνΣιλωὰμ καὶ νίψαι· ἀπελθὼν ⸀οὖνκαὶ νιψάμενος ἀνέβλεψα. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","⸂καὶ εἶπαν αὐτῷ· Ποῦ ἐστιν ἐκεῖνος; λέγει· Οὐκ οἶδα. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ἄγουσιν αὐτὸν πρὸς τοὺς Φαρισαίους τόν ποτε τυφλόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ἦν δὲ σάββατον ⸂ἐν ᾗ ἡμέρᾳ τὸν πηλὸν ἐποίησεν ὁ Ἰησοῦς καὶ ἀνέῳξεν αὐτοῦ τοὺς ὀφθαλμούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","πάλιν οὖν ἠρώτων αὐτὸν καὶ οἱ Φαρισαῖοι πῶς ἀνέβλεψεν. ὁ δὲ εἶπεν αὐτοῖς· Πηλὸν ἐπέθηκέν μου ἐπὶ τοὺς ὀφθαλμούς, καὶ ἐνιψάμην, καὶ βλέπω. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ἔλεγον οὖν ἐκ τῶν Φαρισαίων τινές· ⸂Οὐκ ἔστιν οὗτος παρὰ θεοῦ ὁ ἄνθρωπος, ὅτι τὸ σάββατον οὐ τηρεῖ. ⸀ἄλλοιἔλεγον· Πῶς δύναται ἄνθρωπος ἁμαρτωλὸς τοιαῦτα σημεῖα ποιεῖν; καὶ σχίσμα ἦν ἐν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","λέγουσιν ⸀οὖντῷ τυφλῷ πάλιν· ⸂Τί σὺ λέγεις περὶ αὐτοῦ, ὅτι ἠνέῳξέν σου τοὺς ὀφθαλμούς; ὁ δὲ εἶπεν ὅτι Προφήτης ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Οὐκ ἐπίστευσαν οὖν οἱ Ἰουδαῖοι περὶ αὐτοῦ ὅτι ⸂ἦν τυφλὸς καὶ ἀνέβλεψεν, ἕως ὅτου ἐφώνησαν τοὺς γονεῖς αὐτοῦ ⸂τοῦ ἀναβλέψαντος ");
INSERT INTO grcsbl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","καὶ ἠρώτησαν αὐτοὺς λέγοντες· Οὗτός ἐστιν ὁ υἱὸς ὑμῶν, ὃν ὑμεῖς λέγετε ὅτι τυφλὸς ἐγεννήθη; πῶς οὖν ⸂βλέπει ἄρτι; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ἀπεκρίθησαν ⸀οὖνοἱ γονεῖς αὐτοῦ καὶ εἶπαν· Οἴδαμεν ὅτι οὗτός ἐστιν ὁ υἱὸς ἡμῶν καὶ ὅτι τυφλὸς ἐγεννήθη· ");
INSERT INTO grcsbl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","πῶς δὲ νῦν βλέπει οὐκ οἴδαμεν, ἢ τίς ἤνοιξεν αὐτοῦ τοὺς ὀφθαλμοὺς ἡμεῖς οὐκ οἴδαμεν· ⸂αὐτὸν ἐρωτήσατε, ἡλικίαν ἔχει⸃, αὐτὸς περὶ ἑαυτοῦ λαλήσει. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ταῦτα εἶπαν οἱ γονεῖς αὐτοῦ ὅτι ἐφοβοῦντο τοὺς Ἰουδαίους, ἤδη γὰρ συνετέθειντο οἱ Ἰουδαῖοι ἵνα ἐάν τις αὐτὸν ὁμολογήσῃ χριστόν, ἀποσυνάγωγος γένηται. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","διὰ τοῦτο οἱ γονεῖς αὐτοῦ εἶπαν ὅτι Ἡλικίαν ἔχει, αὐτὸν ⸀ἐπερωτήσατε ");
INSERT INTO grcsbl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ἐφώνησαν οὖν ⸂τὸν ἄνθρωπον ἐκ δευτέρου ὃς ἦν τυφλὸς καὶ εἶπαν αὐτῷ· Δὸς δόξαν τῷ θεῷ· ἡμεῖς οἴδαμεν ὅτι ⸂οὗτος ὁ ἄνθρωπος ἁμαρτωλός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ἀπεκρίθη οὖν ⸀ἐκεῖνος Εἰ ἁμαρτωλός ἐστιν οὐκ οἶδα· ἓν οἶδα ὅτι τυφλὸς ὢν ἄρτι βλέπω. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","εἶπον ⸂οὖν αὐτῷ· Τί ἐποίησέν σοι; πῶς ἤνοιξέν σου τοὺς ὀφθαλμούς; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ἀπεκρίθη αὐτοῖς· Εἶπον ὑμῖν ἤδη καὶ οὐκ ἠκούσατε· τί πάλιν θέλετε ἀκούειν; μὴ καὶ ὑμεῖς θέλετε αὐτοῦ μαθηταὶ γενέσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","⸀ἐλοιδόρησαναὐτὸν καὶ εἶπον· Σὺ ⸂μαθητὴς εἶ ἐκείνου, ἡμεῖς δὲ τοῦ Μωϋσέως ἐσμὲν μαθηταί· ");
INSERT INTO grcsbl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ἡμεῖς οἴδαμεν ὅτι Μωϋσεῖ λελάληκεν ὁ θεός, τοῦτον δὲ οὐκ οἴδαμεν πόθεν ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ἀπεκρίθη ὁ ἄνθρωπος καὶ εἶπεν αὐτοῖς· Ἐν ⸂τούτῳ γὰρ τὸ θαυμαστόν ἐστιν ὅτι ὑμεῖς οὐκ οἴδατε πόθεν ἐστίν, καὶ ἤνοιξέν μου τοὺς ὀφθαλμούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","⸀οἴδαμενὅτι ⸂ἁμαρτωλῶν ὁ θεὸς οὐκ ἀκούει, ἀλλʼ ἐάν τις θεοσεβὴς ᾖ καὶ τὸ θέλημα αὐτοῦ ποιῇ τούτου ἀκούει. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ἐκ τοῦ αἰῶνος οὐκ ἠκούσθη ὅτι ἠνέῳξέν τις ὀφθαλμοὺς τυφλοῦ γεγεννημένου· ");
INSERT INTO grcsbl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","εἰ μὴ ἦν οὗτος παρὰ θεοῦ, οὐκ ἠδύνατο ποιεῖν οὐδέν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ἀπεκρίθησαν καὶ εἶπαν αὐτῷ· Ἐν ἁμαρτίαις σὺ ἐγεννήθης ὅλος, καὶ σὺ διδάσκεις ἡμᾶς; καὶ ἐξέβαλον αὐτὸν ἔξω. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","⸀ἬκουσενἸησοῦς ὅτι ἐξέβαλον αὐτὸν ἔξω, καὶ εὑρὼν αὐτὸν ⸀εἶπεν Σὺ πιστεύεις εἰς τὸν υἱὸν τοῦ ⸀ἀνθρώπου ");
INSERT INTO grcsbl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ἀπεκρίθη ἐκεῖνος καὶ εἶπεν· Καὶ τίς ἐστιν, κύριε, ἵνα πιστεύσω εἰς αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","⸀εἶπεναὐτῷ ὁ Ἰησοῦς· Καὶ ἑώρακας αὐτὸν καὶ ὁ λαλῶν μετὰ σοῦ ἐκεῖνός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ὁ δὲ ἔφη· Πιστεύω, κύριε· καὶ προσεκύνησεν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","καὶ εἶπεν ὁ Ἰησοῦς· Εἰς κρίμα ἐγὼ εἰς τὸν κόσμον τοῦτον ἦλθον, ἵνα οἱ μὴ βλέποντες βλέπωσιν καὶ οἱ βλέποντες τυφλοὶ γένωνται. ");
INSERT INTO grcsbl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","⸀ἤκουσανἐκ τῶν Φαρισαίων ταῦτα οἱ ⸂μετʼ αὐτοῦ ὄντες, καὶ εἶπον αὐτῷ· Μὴ καὶ ἡμεῖς τυφλοί ἐσμεν; ");
INSERT INTO grcsbl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","εἶπεν αὐτοῖς ὁ Ἰησοῦς· Εἰ τυφλοὶ ἦτε, οὐκ ἂν εἴχετε ἁμαρτίαν· νῦν δὲ λέγετε ὅτι Βλέπομεν· ⸀ἡἁμαρτία ὑμῶν μένει. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ μὴ εἰσερχόμενος διὰ τῆς θύρας εἰς τὴν αὐλὴν τῶν προβάτων ἀλλὰ ἀναβαίνων ἀλλαχόθεν ἐκεῖνος κλέπτης ἐστὶν καὶ λῃστής· ");
INSERT INTO grcsbl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ὁ δὲ εἰσερχόμενος διὰ τῆς θύρας ποιμήν ἐστιν τῶν προβάτων. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","τούτῳ ὁ θυρωρὸς ἀνοίγει, καὶ τὰ πρόβατα τῆς φωνῆς αὐτοῦ ἀκούει καὶ τὰ ἴδια πρόβατα ⸀φωνεῖκατʼ ὄνομα καὶ ἐξάγει αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","⸀ὅταντὰ ἴδια ⸀πάνταἐκβάλῃ, ἔμπροσθεν αὐτῶν πορεύεται, καὶ τὰ πρόβατα αὐτῷ ἀκολουθεῖ, ὅτι οἴδασιν τὴν φωνὴν αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ἀλλοτρίῳ δὲ οὐ μὴ ⸀ἀκολουθήσουσινἀλλὰ φεύξονται ἀπʼ αὐτοῦ, ὅτι οὐκ οἴδασι τῶν ἀλλοτρίων τὴν φωνήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ταύτην τὴν παροιμίαν εἶπεν αὐτοῖς ὁ Ἰησοῦς· ἐκεῖνοι δὲ οὐκ ἔγνωσαν τίνα ⸀ἦνἃ ἐλάλει αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Εἶπεν οὖν πάλιν ⸀αὐτοῖςὁ Ἰησοῦς· Ἀμὴν ἀμὴν λέγω ὑμῖν ⸀ὅτιἐγώ εἰμι ἡ θύρα τῶν προβάτων. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","πάντες ὅσοι ἦλθον ⸂πρὸ ἐμοῦ κλέπται εἰσὶν καὶ λῃσταί· ἀλλʼ οὐκ ἤκουσαν αὐτῶν τὰ πρόβατα. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ἐγώ εἰμι ἡ θύρα· διʼ ἐμοῦ ἐάν τις εἰσέλθῃ σωθήσεται καὶ εἰσελεύσεται καὶ ἐξελεύσεται καὶ νομὴν εὑρήσει. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ὁ κλέπτης οὐκ ἔρχεται εἰ μὴ ἵνα κλέψῃ καὶ θύσῃ καὶ ἀπολέσῃ· ἐγὼ ἦλθον ἵνα ζωὴν ἔχωσιν καὶ περισσὸν ἔχωσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ἐγώ εἰμι ὁ ποιμὴν ὁ καλός· ὁ ποιμὴν ὁ καλὸς τὴν ψυχὴν αὐτοῦ τίθησιν ὑπὲρ τῶν προβάτων· ");
INSERT INTO grcsbl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ὁ ⸀μισθωτὸςκαὶ οὐκ ὢν ποιμήν, οὗ οὐκ ⸀ἔστιντὰ πρόβατα ἴδια, θεωρεῖ τὸν λύκον ἐρχόμενον καὶ ἀφίησιν τὰ πρόβατα καὶ φεύγει— καὶ ὁ λύκος ἁρπάζει αὐτὰ καὶ ⸀σκορπίζει ");
INSERT INTO grcsbl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","⸀ὅτιμισθωτός ἐστιν καὶ οὐ μέλει αὐτῷ περὶ τῶν προβάτων. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ἐγώ εἰμι ὁ ποιμὴν ὁ καλός, καὶ γινώσκω τὰ ἐμὰ καὶ ⸂γινώσκουσί με τὰ ἐμά, ");
INSERT INTO grcsbl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","καθὼς γινώσκει με ὁ πατὴρ κἀγὼ γινώσκω τὸν πατέρα, καὶ τὴν ψυχήν μου τίθημι ὑπὲρ τῶν προβάτων. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","καὶ ἄλλα πρόβατα ἔχω ἃ οὐκ ἔστιν ἐκ τῆς αὐλῆς ταύτης· κἀκεῖνα ⸂δεῖ με ἀγαγεῖν, καὶ τῆς φωνῆς μου ἀκούσουσιν, καὶ ⸀γενήσονταιμία ποίμνη, εἷς ποιμήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","διὰ τοῦτό ⸂με ὁ πατὴρ ἀγαπᾷ ὅτι ἐγὼ τίθημι τὴν ψυχήν μου, ἵνα πάλιν λάβω αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","οὐδεὶς ⸀αἴρειαὐτὴν ἀπʼ ἐμοῦ, ἀλλʼ ἐγὼ τίθημι αὐτὴν ἀπʼ ἐμαυτοῦ. ἐξουσίαν ἔχω θεῖναι αὐτήν, καὶ ἐξουσίαν ἔχω πάλιν λαβεῖν αὐτήν· ταύτην τὴν ἐντολὴν ἔλαβον παρὰ τοῦ πατρός μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","⸀Σχίσμαπάλιν ἐγένετο ἐν τοῖς Ἰουδαίοις διὰ τοὺς λόγους τούτους. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ἔλεγον δὲ πολλοὶ ἐξ αὐτῶν· Δαιμόνιον ἔχει καὶ μαίνεται· τί αὐτοῦ ἀκούετε; ");
INSERT INTO grcsbl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","⸀ἄλλοιἔλεγον· Ταῦτα τὰ ῥήματα οὐκ ἔστιν δαιμονιζομένου· μὴ δαιμόνιον δύναται τυφλῶν ὀφθαλμοὺς ⸀ἀνοῖξαι ");
INSERT INTO grcsbl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ἐγένετο ⸀τότετὰ ἐγκαίνια ἐν ⸀τοῖςἹεροσολύμοις· ⸀χειμὼνἦν, ");
INSERT INTO grcsbl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","καὶ περιεπάτει ὁ Ἰησοῦς ἐν τῷ ἱερῷ ἐν τῇ στοᾷ ⸀τοῦΣολομῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ἐκύκλωσαν οὖν αὐτὸν οἱ Ἰουδαῖοι καὶ ἔλεγον αὐτῷ· Ἕως πότε τὴν ψυχὴν ἡμῶν αἴρεις; εἰ σὺ εἶ ὁ χριστός, εἰπὲ ἡμῖν παρρησίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς· Εἶπον ὑμῖν καὶ οὐ πιστεύετε· τὰ ἔργα ἃ ἐγὼ ποιῶ ἐν τῷ ὀνόματι τοῦ πατρός μου ταῦτα μαρτυρεῖ περὶ ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ἀλλὰ ὑμεῖς οὐ πιστεύετε, ⸂ὅτι οὐκ ἐστὲ ἐκ τῶν προβάτων τῶν ⸀ἐμῶν ");
INSERT INTO grcsbl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","τὰ πρόβατα τὰ ἐμὰ τῆς φωνῆς μου ⸀ἀκούουσιν κἀγὼ γινώσκω αὐτά, καὶ ἀκολουθοῦσίν μοι, ");
INSERT INTO grcsbl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","κἀγὼ ⸂δίδωμι αὐτοῖς ζωὴν αἰώνιον, καὶ οὐ μὴ ἀπόλωνται εἰς τὸν αἰῶνα, καὶ οὐχ ἁρπάσει τις αὐτὰ ἐκ τῆς χειρός μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ὁ πατήρ μου ⸀ὃδέδωκέν ⸀μοι⸂πάντων μεῖζων ἐστίν, καὶ οὐδεὶς δύναται ἁρπάζειν ἐκ τῆς χειρὸς τοῦ ⸀πατρός ");
INSERT INTO grcsbl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ἐγὼ καὶ ὁ πατὴρ ἕν ἐσμεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ἐβάστασαν ⸀οὖνπάλιν λίθους οἱ Ἰουδαῖοι ἵνα λιθάσωσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς· Πολλὰ ⸂ἔργα καλὰ ἔδειξα ὑμῖν ἐκ τοῦ ⸀πατρός διὰ ποῖον αὐτῶν ἔργον ⸂ἐμὲ λιθάζετε; ");
INSERT INTO grcsbl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ἀπεκρίθησαν αὐτῷ οἱ ⸀Ἰουδαῖοι Περὶ καλοῦ ἔργου οὐ λιθάζομέν σε ἀλλὰ περὶ βλασφημίας, καὶ ὅτι σὺ ἄνθρωπος ὢν ποιεῖς σεαυτὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ἀπεκρίθη αὐτοῖς ὁ Ἰησοῦς· Οὐκ ἔστιν γεγραμμένον ἐν τῷ νόμῳ ὑμῶν ⸀ὅτιἘγὼ εἶπα· Θεοί ἐστε; ");
INSERT INTO grcsbl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","εἰ ἐκείνους εἶπεν θεοὺς πρὸς οὓς ὁ λόγος τοῦ θεοῦ ἐγένετο, καὶ οὐ δύναται λυθῆναι ἡ γραφή, ");
INSERT INTO grcsbl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ὃν ὁ πατὴρ ἡγίασεν καὶ ἀπέστειλεν εἰς τὸν κόσμον ὑμεῖς λέγετε ὅτι Βλασφημεῖς, ὅτι εἶπον· Υἱὸς τοῦ θεοῦ εἰμι; ");
INSERT INTO grcsbl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","εἰ οὐ ποιῶ τὰ ἔργα τοῦ πατρός μου, μὴ πιστεύετέ μοι· ");
INSERT INTO grcsbl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","εἰ δὲ ποιῶ, κἂν ἐμοὶ μὴ πιστεύητε τοῖς ἔργοις ⸀πιστεύετε ἵνα γνῶτε καὶ ⸀γινώσκητεὅτι ἐν ἐμοὶ ὁ πατὴρ κἀγὼ ἐν ⸂τῷ πατρί. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ἐζήτουν οὖν ⸂πάλιν αὐτὸν πιάσαι· καὶ ἐξῆλθεν ἐκ τῆς χειρὸς αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Καὶ ἀπῆλθεν πάλιν πέραν τοῦ Ἰορδάνου εἰς τὸν τόπον ὅπου ἦν Ἰωάννης τὸ πρῶτον βαπτίζων, καὶ ἔμεινεν ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","καὶ πολλοὶ ἦλθον πρὸς αὐτὸν καὶ ἔλεγον ὅτι Ἰωάννης μὲν σημεῖον ἐποίησεν οὐδέν, πάντα δὲ ὅσα εἶπεν Ἰωάννης περὶ τούτου ἀληθῆ ἦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","καὶ ⸂πολλοὶ ἐπίστευσαν εἰς αὐτὸν ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ἦν δέ τις ἀσθενῶν, Λάζαρος ἀπὸ Βηθανίας ἐκ τῆς κώμης Μαρίας καὶ Μάρθας τῆς ἀδελφῆς αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ἦν δὲ ⸀Μαριὰμἡ ἀλείψασα τὸν κύριον μύρῳ καὶ ἐκμάξασα τοὺς πόδας αὐτοῦ ταῖς θριξὶν αὐτῆς, ἧς ὁ ἀδελφὸς Λάζαρος ἠσθένει. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ἀπέστειλαν οὖν αἱ ἀδελφαὶ πρὸς αὐτὸν λέγουσαι· Κύριε, ἴδε ὃν φιλεῖς ἀσθενεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ἀκούσας δὲ ὁ Ἰησοῦς εἶπεν· Αὕτη ἡ ἀσθένεια οὐκ ἔστιν πρὸς θάνατον ἀλλʼ ὑπὲρ τῆς δόξης τοῦ θεοῦ ἵνα δοξασθῇ ὁ υἱὸς τοῦ θεοῦ διʼ αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ἠγάπα δὲ ὁ Ἰησοῦς τὴν Μάρθαν καὶ τὴν ἀδελφὴν αὐτῆς καὶ τὸν Λάζαρον. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ὡς οὖν ἤκουσεν ὅτι ἀσθενεῖ, τότε μὲν ἔμεινεν ἐν ᾧ ἦν τόπῳ δύο ἡμέρας· ");
INSERT INTO grcsbl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ἔπειτα μετὰ τοῦτο λέγει τοῖς μαθηταῖς· Ἄγωμεν εἰς τὴν Ἰουδαίαν πάλιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","λέγουσιν αὐτῷ οἱ μαθηταί· Ῥαββί, νῦν ἐζήτουν σε λιθάσαι οἱ Ἰουδαῖοι, καὶ πάλιν ὑπάγεις ἐκεῖ; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ἀπεκρίθη Ἰησοῦς· Οὐχὶ δώδεκα ⸂ὧραί εἰσιν τῆς ἡμέρας; ἐάν τις περιπατῇ ἐν τῇ ἡμέρᾳ, οὐ προσκόπτει, ὅτι τὸ φῶς τοῦ κόσμου τούτου βλέπει· ");
INSERT INTO grcsbl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ἐὰν δέ τις περιπατῇ ἐν τῇ νυκτί, προσκόπτει, ὅτι τὸ φῶς οὐκ ἔστιν ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ταῦτα εἶπεν, καὶ μετὰ τοῦτο λέγει αὐτοῖς· Λάζαρος ὁ φίλος ἡμῶν κεκοίμηται, ἀλλὰ πορεύομαι ἵνα ἐξυπνίσω αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","εἶπαν οὖν οἱ μαθηταὶ ⸀αὐτῷ Κύριε, εἰ κεκοίμηται σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","εἰρήκει δὲ ὁ Ἰησοῦς περὶ τοῦ θανάτου αὐτοῦ. ἐκεῖνοι δὲ ἔδοξαν ὅτι περὶ τῆς κοιμήσεως τοῦ ὕπνου λέγει. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","τότε οὖν εἶπεν αὐτοῖς ὁ Ἰησοῦς παρρησίᾳ· Λάζαρος ἀπέθανεν, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","καὶ χαίρω διʼ ὑμᾶς, ἵνα πιστεύσητε, ὅτι οὐκ ἤμην ἐκεῖ· ἀλλὰ ἄγωμεν πρὸς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","εἶπεν οὖν Θωμᾶς ὁ λεγόμενος Δίδυμος τοῖς συμμαθηταῖς· Ἄγωμεν καὶ ἡμεῖς ἵνα ἀποθάνωμεν μετʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ἐλθὼν οὖν ὁ Ἰησοῦς εὗρεν αὐτὸν τέσσαρας ⸂ἤδη ἡμέρας ἔχοντα ἐν τῷ μνημείῳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ἦν δὲ ⸀ἡΒηθανία ἐγγὺς τῶν Ἱεροσολύμων ὡς ἀπὸ σταδίων δεκαπέντε. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","⸂πολλοὶ δὲ ἐκ τῶν Ἰουδαίων ἐληλύθεισαν πρὸς ⸀τὴνΜάρθαν καὶ ⸀Μαριὰμἵνα παραμυθήσωνται αὐτὰς περὶ τοῦ ⸀ἀδελφοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ἡ οὖν Μάρθα ὡς ἤκουσεν ὅτι Ἰησοῦς ἔρχεται ὑπήντησεν αὐτῷ· ⸀Μαρίαδὲ ἐν τῷ οἴκῳ ἐκαθέζετο. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","εἶπεν οὖν ⸀ἡΜάρθα πρὸς ⸀τὸνἸησοῦν· Κύριε, εἰ ἦς ὧδε ⸂οὐκ ἂν ἀπέθανεν ὁ ἀδελφός μου· ");
INSERT INTO grcsbl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","⸀καὶνῦν οἶδα ὅτι ὅσα ἂν αἰτήσῃ τὸν θεὸν δώσει σοι ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","λέγει αὐτῇ ὁ Ἰησοῦς· Ἀναστήσεται ὁ ἀδελφός σου. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","λέγει αὐτῷ ⸀ἡΜάρθα· Οἶδα ὅτι ἀναστήσεται ἐν τῇ ἀναστάσει ἐν τῇ ἐσχάτῃ ἡμέρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","εἶπεν αὐτῇ ὁ Ἰησοῦς· Ἐγώ εἰμι ἡ ἀνάστασις καὶ ἡ ζωή· ὁ πιστεύων εἰς ἐμὲ κἂν ἀποθάνῃ ζήσεται, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","καὶ πᾶς ὁ ζῶν καὶ πιστεύων εἰς ἐμὲ οὐ μὴ ἀποθάνῃ εἰς τὸν αἰῶνα· πιστεύεις τοῦτο; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","λέγει αὐτῷ· Ναί, κύριε· ἐγὼ πεπίστευκα ὅτι σὺ εἶ ὁ χριστὸς ὁ υἱὸς τοῦ θεοῦ ὁ εἰς τὸν κόσμον ἐρχόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Καὶ ⸀τοῦτοεἰποῦσα ἀπῆλθεν καὶ ἐφώνησεν ⸀Μαριὰμτὴν ἀδελφὴν αὐτῆς λάθρᾳ εἰποῦσα· Ὁ διδάσκαλος πάρεστιν καὶ φωνεῖ σε. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ἐκείνη ⸀δὲὡς ἤκουσεν ⸀ἠγέρθηταχὺ καὶ ⸀ἤρχετοπρὸς αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","οὔπω δὲ ἐληλύθει ὁ Ἰησοῦς εἰς τὴν κώμην, ἀλλʼ ἦν ⸀ἔτιἐν τῷ τόπῳ ὅπου ὑπήντησεν αὐτῷ ἡ Μάρθα. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","οἱ οὖν Ἰουδαῖοι οἱ ὄντες μετʼ αὐτῆς ἐν τῇ οἰκίᾳ καὶ παραμυθούμενοι αὐτήν, ἰδόντες τὴν ⸀Μαριὰμὅτι ταχέως ἀνέστη καὶ ἐξῆλθεν, ἠκολούθησαν αὐτῇ ⸀δόξαντεςὅτι ὑπάγει εἰς τὸ μνημεῖον ἵνα κλαύσῃ ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ἡ οὖν ⸀Μαριὰμὡς ἦλθεν ὅπου ⸀ἦνἸησοῦς ἰδοῦσα αὐτὸν ἔπεσεν αὐτοῦ ⸀πρὸςτοὺς πόδας, λέγουσα αὐτῷ· Κύριε, εἰ ἦς ὧδε οὐκ ἄν ⸂μου ἀπέθανεν ὁ ἀδελφός. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ἰησοῦς οὖν ὡς εἶδεν αὐτὴν κλαίουσαν καὶ τοὺς συνελθόντας αὐτῇ Ἰουδαίους κλαίοντας ἐνεβριμήσατο τῷ πνεύματι καὶ ἐτάραξεν ἑαυτόν, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","καὶ εἶπεν· Ποῦ τεθείκατε αὐτόν; λέγουσιν αὐτῷ· Κύριε, ἔρχου καὶ ἴδε. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ἐδάκρυσεν ὁ Ἰησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ἔλεγον οὖν οἱ Ἰουδαῖοι· Ἴδε πῶς ἐφίλει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","τινὲς δὲ ἐξ αὐτῶν εἶπαν· Οὐκ ἐδύνατο οὗτος ὁ ἀνοίξας τοὺς ὀφθαλμοὺς τοῦ τυφλοῦ ποιῆσαι ἵνα καὶ οὗτος μὴ ἀποθάνῃ; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ἰησοῦς οὖν πάλιν ἐμβριμώμενος ἐν ἑαυτῷ ἔρχεται εἰς τὸ μνημεῖον· ἦν δὲ σπήλαιον, καὶ λίθος ἐπέκειτο ἐπʼ αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","λέγει ὁ Ἰησοῦς· Ἄρατε τὸν λίθον. λέγει αὐτῷ ἡ ἀδελφὴ τοῦ ⸀τετελευτηκότοςΜάρθα· Κύριε, ἤδη ὄζει, τεταρταῖος γάρ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","λέγει αὐτῇ ὁ Ἰησοῦς· Οὐκ εἶπόν σοι ὅτι ἐὰν πιστεύσῃς ⸀ὄψῃτὴν δόξαν τοῦ θεοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ἦραν οὖν τὸν ⸀λίθον ὁ δὲ Ἰησοῦς ἦρεν τοὺς ὀφθαλμοὺς ἄνω καὶ εἶπεν· Πάτερ, εὐχαριστῶ σοι ὅτι ἤκουσάς μου, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ἐγὼ δὲ ᾔδειν ὅτι πάντοτέ μου ἀκούεις· ἀλλὰ διὰ τὸν ὄχλον τὸν περιεστῶτα εἶπον, ἵνα πιστεύσωσιν ὅτι σύ με ἀπέστειλας. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","καὶ ταῦτα εἰπὼν φωνῇ μεγάλῃ ἐκραύγασεν· Λάζαρε, δεῦρο ἔξω. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","⸀ἐξῆλθενὁ τεθνηκὼς δεδεμένος τοὺς πόδας καὶ τὰς χεῖρας κειρίαις, καὶ ἡ ὄψις αὐτοῦ σουδαρίῳ περιεδέδετο. λέγει ⸂αὐτοῖς ὁ Ἰησοῦς· Λύσατε αὐτὸνκαὶ ἄφετε ⸀αὐτὸν ὑπάγειν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Πολλοὶ οὖν ἐκ τῶν Ἰουδαίων, οἱ ἐλθόντες πρὸς τὴν ⸀Μαριὰμκαὶ θεασάμενοι ⸀ἃ⸀ἐποίησεν ἐπίστευσαν εἰς αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","τινὲς δὲ ἐξ αὐτῶν ἀπῆλθον πρὸς τοὺς Φαρισαίους καὶ εἶπαν αὐτοῖς ἃ ⸀ἐποίησενἸησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","συνήγαγον οὖν οἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι συνέδριον, καὶ ἔλεγον· Τί ποιοῦμεν ὅτι οὗτος ὁ ἄνθρωπος πολλὰ ⸂ποιεῖ σημεῖα; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ἐὰν ἀφῶμεν αὐτὸν οὕτως, πάντες πιστεύσουσιν εἰς αὐτόν, καὶ ἐλεύσονται οἱ Ῥωμαῖοι καὶ ἀροῦσιν ἡμῶν καὶ τὸν τόπον καὶ τὸ ἔθνος. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","εἷς δέ τις ἐξ αὐτῶν Καϊάφας, ἀρχιερεὺς ὢν τοῦ ἐνιαυτοῦ ἐκείνου, εἶπεν αὐτοῖς· Ὑμεῖς οὐκ οἴδατε οὐδέν, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","οὐδὲ ⸀λογίζεσθεὅτι συμφέρει ⸀ὑμῖνἵνα εἷς ἄνθρωπος ἀποθάνῃ ὑπὲρ τοῦ λαοῦ καὶ μὴ ὅλον τὸ ἔθνος ἀπόληται. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","τοῦτο δὲ ἀφʼ ἑαυτοῦ οὐκ εἶπεν, ἀλλὰ ἀρχιερεὺς ὢν τοῦ ἐνιαυτοῦ ἐκείνου ἐπροφήτευσεν ὅτι ἔμελλεν Ἰησοῦς ἀποθνῄσκειν ὑπὲρ τοῦ ἔθνους, ");
INSERT INTO grcsbl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","καὶ οὐχ ὑπὲρ τοῦ ἔθνους μόνον, ἀλλʼ ἵνα καὶ τὰ τέκνα τοῦ θεοῦ τὰ διεσκορπισμένα συναγάγῃ εἰς ἕν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ἀπʼ ἐκείνης οὖν τῆς ἡμέρας ⸀ἐβουλεύσαντοἵνα ἀποκτείνωσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","⸂Ὁ οὖν Ἰησοῦς οὐκέτι παρρησίᾳ περιεπάτει ἐν τοῖς Ἰουδαίοις, ἀλλὰ ἀπῆλθεν ἐκεῖθεν εἰς τὴν χώραν ἐγγὺς τῆς ἐρήμου, εἰς Ἐφραὶμ λεγομένην πόλιν, κἀκεῖ ⸀ἔμεινενμετὰ τῶν ⸀μαθητῶν ");
INSERT INTO grcsbl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ἦν δὲ ἐγγὺς τὸ πάσχα τῶν Ἰουδαίων, καὶ ἀνέβησαν πολλοὶ εἰς Ἱεροσόλυμα ἐκ τῆς χώρας πρὸ τοῦ πάσχα ἵνα ἁγνίσωσιν ἑαυτούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ἐζήτουν οὖν τὸν Ἰησοῦν καὶ ἔλεγον μετʼ ἀλλήλων ἐν τῷ ἱερῷ ἑστηκότες· Τί δοκεῖ ὑμῖν; ὅτι οὐ μὴ ἔλθῃ εἰς τὴν ἑορτήν; ");
INSERT INTO grcsbl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","δεδώκεισαν ⸀δὲοἱ ἀρχιερεῖς καὶ οἱ Φαρισαῖοι ⸀ἐντολὰςἵνα ἐάν τις γνῷ ποῦ ἐστιν μηνύσῃ, ὅπως πιάσωσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ὁ οὖν Ἰησοῦς πρὸ ἓξ ἡμερῶν τοῦ πάσχα ἦλθεν εἰς Βηθανίαν, ὅπου ἦν ⸀Λάζαρος ὃν ἤγειρεν ἐκ νεκρῶν ⸀Ἰησοῦς ");
INSERT INTO grcsbl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ἐποίησαν οὖν αὐτῷ δεῖπνον ἐκῖ, καὶ ἡ Μάρθα διηκόνει, ὁ δὲ Λάζαρος εἷς ἦν ⸀ἐκ τῶν ἀνακειμένων σὺν αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ἡ οὖν ⸀Μαριὰμλαβοῦσα λίτραν μύρου νάρδου πιστικῆς πολυτίμου ἤλειψεν τοὺς πόδας τοῦ Ἰησοῦ καὶ ἐξέμαξεν ταῖς θριξὶν αὐτῆς τοὺς πόδας αὐτοῦ· ἡ δὲ οἰκία ἐπληρώθη ἐκ τῆς ὀσμῆς τοῦ μύρου. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","λέγει ⸀δὲ⸂Ἰούδας ὁ Ἰσκαριώτης εἷς τῶν μαθητῶν αὐτοῦ, ὁ μέλλων αὐτὸν παραδιδόναι· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Διὰ τί τοῦτο τὸ μύρον οὐκ ἐπράθη τριακοσίων δηναρίων καὶ ἐδόθη πτωχοῖς; ");
INSERT INTO grcsbl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","εἶπεν δὲ τοῦτο οὐχ ὅτι περὶ τῶν πτωχῶν ἔμελεν αὐτῷ, ἀλλʼ ὅτι κλέπτης ἦν καὶ τὸ γλωσσόκομον ⸀ἔχωντὰ βαλλόμενα ἐβάσταζεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","εἶπεν οὖν ὁ Ἰησοῦς· Ἄφες αὐτήν, ⸀ἵναεἰς τὴν ἡμέραν τοῦ ἐνταφιασμοῦ μου ⸀τηρήσῃαὐτό· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","τοὺς πτωχοὺς γὰρ πάντοτε ἔχετε μεθʼ ἑαυτῶν, ἐμὲ δὲ οὐ πάντοτε ἔχετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ἔγνω ⸀οὖνὄχλος πολὺς ἐκ τῶν Ἰουδαίων ὅτι ἐκεῖ ἐστιν, καὶ ἦλθον οὐ διὰ τὸν Ἰησοῦν μόνον, ἀλλʼ ἵνα καὶ τὸν Λάζαρον ἴδωσιν ὃν ἤγειρεν ἐκ νεκρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ἐβουλεύσαντο δὲ οἱ ἀρχιερεῖς ἵνα καὶ τὸν Λάζαρον ἀποκτείνωσιν, ");
INSERT INTO grcsbl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ὅτι πολλοὶ διʼ αὐτὸν ὑπῆγον τῶν Ἰουδαίων καὶ ἐπίστευον εἰς τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Τῇ ἐπαύριον ⸀ὁὄχλος πολὺς ὁ ἐλθὼν εἰς τὴν ἑορτήν, ἀκούσαντες ὅτι ἔρχεται ⸁ὁἸησοῦς εἰς Ἱεροσόλυμα, ");
INSERT INTO grcsbl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ἔλαβον τὰ βαΐα τῶν φοινίκων καὶ ἐξῆλθον εἰς ὑπάντησιν αὐτῷ, καὶ ⸀ἐκραύγαζον Ὡσαννά, εὐλογημένος ὁ ἐρχόμενος ἐν ὀνόματι κυρίου, ⸂καὶ ὁ βασιλεὺς τοῦ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","εὑρὼν δὲ ὁ Ἰησοῦς ὀνάριον ἐκάθισεν ἐπʼ αὐτό, καθώς ἐστιν γεγραμμένον· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Μὴ φοβοῦ, θυγάτηρ Σιών· ἰδοὺ ὁ βασιλεύς σου ἔρχεται, καθήμενος ἐπὶ πῶλον ὄνου. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","⸀ταῦταοὐκ ἔγνωσαν ⸂αὐτοῦ οἱ μαθηταὶ τὸ πρῶτον, ἀλλʼ ὅτε ἐδοξάσθη Ἰησοῦς τότε ἐμνήσθησαν ὅτι ταῦτα ἦν ἐπʼ αὐτῷ γεγραμμένα καὶ ταῦτα ἐποίησαν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ἐμαρτύρει οὖν ὁ ὄχλος ὁ ὢν μετʼ αὐτοῦ ὅτε τὸν Λάζαρον ἐφώνησεν ἐκ τοῦ μνημείου καὶ ἤγειρεν αὐτὸν ἐκ νεκρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","διὰ τοῦτο ⸀καὶὑπήντησεν αὐτῷ ὁ ὄχλος ὅτι ⸀ἤκουσαντοῦτο αὐτὸν πεποιηκέναι τὸ σημεῖον. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","οἱ οὖν Φαρισαῖοι εἶπαν πρὸς ἑαυτούς· Θεωρεῖτε ὅτι οὐκ ὠφελεῖτε οὐδέν· ἴδε ὁ ⸀κόσμοςὀπίσω αὐτοῦ ἀπῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ἦσαν δὲ ⸂Ἕλληνές τινες ἐκ τῶν ἀναβαινόντων ἵνα προσκυνήσωσιν ἐν τῇ ἑορτῇ· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","οὗτοι οὖν προσῆλθον Φιλίππῳ τῷ ἀπὸ Βηθσαϊδὰ τῆς Γαλιλαίας, καὶ ἠρώτων αὐτὸν λέγοντες· Κύριε, θέλομεν τὸν Ἰησοῦν ἰδεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ἔρχεται ⸀ὁΦίλιππος καὶ λέγει τῷ Ἀνδρέᾳ· ⸀ἔρχεταιἈνδρέας καὶΦίλιππος ⸀καὶ λέγουσιν τῷ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ὁ δὲ Ἰησοῦς ⸀ἀποκρίνεταιαὐτοῖς λέγων· Ἐλήλυθεν ἡ ὥρα ἵνα δοξασθῇ ὁ υἱὸς τοῦ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ἀμὴν ἀμὴν λέγω ὑμῖν, ἐὰν μὴ ὁ κόκκος τοῦ σίτου πεσὼν εἰς τὴν γῆν ἀποθάνῃ, αὐτὸς μόνος μένει· ἐὰν δὲ ἀποθάνῃ, πολὺν καρπὸν φέρει. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ὁ φιλῶν τὴν ψυχὴν αὐτοῦ ⸀ἀπολλύειαὐτήν, καὶ ὁ μισῶν τὴν ψυχὴν αὐτοῦ ἐν τῷ κόσμῳ τούτῳ εἰς ζωὴν αἰώνιον φυλάξει αὐτήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ἐὰν ἐμοί ⸂τις διακονῇ ἐμοὶ ἀκολουθείτω, καὶ ὅπου εἰμὶ ἐγὼ ἐκεῖ καὶ ὁ διάκονος ὁ ἐμὸς ἔσται· ⸀ἐάντις ἐμοὶ διακονῇ τιμήσει αὐτὸν ὁ πατήρ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Νῦν ἡ ψυχή μου τετάρακται, καὶ τί εἴπω; πάτερ, σῶσόν με ἐκ τῆς ὥρας ταύτης. ἀλλὰ διὰ τοῦτο ἦλθον εἰς τὴν ὥραν ταύτην. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","πάτερ, δόξασόν σου τὸ ὄνομα. ἦλθεν οὖν φωνὴ ἐκ τοῦ οὐρανοῦ· Καὶ ἐδόξασα καὶ πάλιν δοξάσω. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ὁ οὖν ὄχλος ὁ ἑστὼς καὶ ἀκούσας ἔλεγεν βροντὴν γεγονέναι· ἄλλοι ἔλεγον· Ἄγγελος αὐτῷ λελάληκεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ἀπεκρίθη ⸂Ἰησοῦς καὶ εἶπεν· Οὐ διʼ ἐμὲ ⸂ἡ φωνὴ αὕτη γέγονεν ἀλλὰ διʼ ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","νῦν κρίσις ἐστὶν τοῦ κόσμου τούτου, νῦν ὁ ἄρχων τοῦ κόσμου τούτου ἐκβληθήσεται ἔξω· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","κἀγὼ ⸀ἐὰνὑψωθῶ ἐκ τῆς γῆς, πάντας ἑλκύσω πρὸς ἐμαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","τοῦτο δὲ ἔλεγεν σημαίνων ποίῳ θανάτῳ ἤμελλεν ἀποθνῄσκειν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ἀπεκρίθη ⸀οὖναὐτῷ ὁ ὄχλος· Ἡμεῖς ἠκούσαμεν ἐκ τοῦ νόμου ὅτι ὁ χριστὸς μένει εἰς τὸν αἰῶνα, καὶ πῶς ⸂λέγεις σὺ ⸀ὅτιδεῖ ὑψωθῆναι τὸν υἱὸν τοῦ ἀνθρώπου; τίς ἐστιν οὗτος ὁ υἱὸς τοῦ ἀνθρώπου; ");
INSERT INTO grcsbl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","εἶπεν οὖν αὐτοῖς ὁ Ἰησοῦς· Ἔτι μικρὸν χρόνον τὸ φῶς ⸂ἐν ὑμῖν ἐστιν. περιπατεῖτε ⸀ὡςτὸ φῶς ἔχετε, ἵνα μὴ σκοτία ὑμᾶς καταλάβῃ, καὶ ὁ περιπατῶν ἐν τῇ σκοτίᾳ οὐκ οἶδεν ποῦ ὑπάγει. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","⸀ὡςτὸ φῶς ἔχετε, πιστεύετε εἰς τὸ φῶς, ἵνα υἱοὶ φωτὸς γένησθε. Ταῦτα ⸀ἐλάλησεν Ἰησοῦς, καὶ ἀπελθὼν ἐκρύβη ἀπʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","τοσαῦτα δὲ αὐτοῦ σημεῖα πεποιηκότος ἔμπροσθεν αὐτῶν οὐκ ἐπίστευον εἰς αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ἵνα ὁ λόγος Ἠσαΐου τοῦ προφήτου πληρωθῇ ὃν εἶπεν· Κύριε, τίς ἐπίστευσεν τῇ ἀκοῇ ἡμῶν; καὶ ὁ βραχίων κυρίου τίνι ἀπεκαλύφθη; ");
INSERT INTO grcsbl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","διὰ τοῦτο οὐκ ἠδύναντο πιστεύειν ὅτι πάλιν εἶπεν Ἠσαΐας· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Τετύφλωκεν αὐτῶν τοὺς ὀφθαλμοὺς καὶ ⸀ἐπώρωσεναὐτῶν τὴν καρδίαν, ἵνα μὴ ἴδωσιν τοῖς ὀφθαλμοῖς καὶ νοήσωσιν τῇ καρδίᾳ καὶ ⸀στραφῶσιν καὶ ⸀ἰάσομαιαὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ταῦτα εἶπεν Ἠσαΐας ⸀ὅτιεἶδεν τὴν δόξαν αὐτοῦ, καὶ ἐλάλησεν περὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ὅμως μέντοι καὶ ἐκ τῶν ἀρχόντων πολλοὶ ἐπίστευσαν εἰς αὐτόν, ἀλλὰ διὰ τοὺς Φαρισαίους οὐχ ὡμολόγουν ἵνα μὴ ἀποσυνάγωγοι γένωνται, ");
INSERT INTO grcsbl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ἠγάπησαν γὰρ τὴν δόξαν τῶν ἀνθρώπων μᾶλλον ἤπερ τὴν δόξαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ἰησοῦς δὲ ἔκραξεν καὶ εἶπεν· Ὁ πιστεύων εἰς ἐμὲ οὐ πιστεύει εἰς ἐμὲ ἀλλὰ εἰς τὸν πέμψαντά με, ");
INSERT INTO grcsbl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","καὶ ὁ θεωρῶν ἐμὲ θεωρεῖ τὸν πέμψαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ἐγὼ φῶς εἰς τὸν κόσμον ἐλήλυθα, ἵνα πᾶς ὁ πιστεύων εἰς ἐμὲ ἐν τῇ σκοτίᾳ μὴ μείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","καὶ ἐάν τίς μου ἀκούσῃ τῶν ῥημάτων καὶ μὴ ⸀φυλάξῃ ἐγὼ οὐ κρίνω αὐτόν, οὐ γὰρ ἦλθον ἵνα κρίνω τὸν κόσμον ἀλλʼ ἵνα σώσω τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ὁ ἀθετῶν ἐμὲ καὶ μὴ λαμβάνων τὰ ῥήματά μου ἔχει τὸν κρίνοντα αὐτόν· ὁ λόγος ὃν ἐλάλησα ἐκεῖνος κρινεῖ αὐτὸν ἐν τῇ ἐσχάτῃ ἡμέρᾳ· ");
INSERT INTO grcsbl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ὅτι ἐγὼ ἐξ ἐμαυτοῦ οὐκ ἐλάλησα, ἀλλʼ ὁ πέμψας με πατὴρ αὐτός μοι ἐντολὴν ⸀δέδωκεντί εἴπω καὶ τί λαλήσω. ");
INSERT INTO grcsbl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","καὶ οἶδα ὅτι ἡ ἐντολὴ αὐτοῦ ζωὴ αἰώνιός ἐστιν. ἃ οὖν ⸂ἐγὼ λαλῶ, καθὼς εἴρηκέν μοι ὁ πατήρ, οὕτως λαλῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Πρὸ δὲ τῆς ἑορτῆς τοῦ πάσχα εἰδὼς ὁ Ἰησοῦς ὅτι ⸀ἦλθεναὐτοῦ ἡ ὥρα ἵνα μεταβῇ ἐκ τοῦ κόσμου τούτου πρὸς τὸν πατέρα ἀγαπήσας τοὺς ἰδίους τοὺς ἐν τῷ κόσμῳ εἰς τέλος ἠγάπησεν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","καὶ δείπνου ⸀γινομένου τοῦ διαβόλου ἤδη βεβληκότος εἰς τὴν καρδίαν ⸂ἵνα παραδοῖ αὐτὸν Ἰούδας Σίμωνος ⸀Ἰσκαριώτου⸃, ");
INSERT INTO grcsbl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","⸀εἰδὼςὅτι πάντα ⸀ἔδωκεναὐτῷ ὁ πατὴρ εἰς τὰς χεῖρας, καὶ ὅτι ἀπὸ θεοῦ ἐξῆλθεν καὶ πρὸς τὸν θεὸν ὑπάγει, ");
INSERT INTO grcsbl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ἐγείρεται ἐκ τοῦ δείπνου καὶ τίθησιν τὰ ἱμάτια καὶ λαβὼν λέντιον διέζωσεν ἑαυτόν· ");
INSERT INTO grcsbl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","εἶτα βάλλει ὕδωρ εἰς τὸν νιπτῆρα, καὶ ἤρξατο νίπτειν τοὺς πόδας τῶν μαθητῶν καὶ ἐκμάσσειν τῷ λεντίῳ ᾧ ἦν διεζωσμένος. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ἔρχεται οὖν πρὸς Σίμωνα Πέτρον. ⸀λέγει⸀αὐτῷ Κύριε, σύ μου νίπτεις τοὺς πόδας; ");
INSERT INTO grcsbl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ· Ὃ ἐγὼ ποιῶ σὺ οὐκ οἶδας ἄρτι, γνώσῃ δὲ μετὰ ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","λέγει αὐτῷ Πέτρος· Οὐ μὴ νίψῃς ⸂μου τοὺς πόδας εἰς τὸν αἰῶνα. ἀπεκρίθη ⸂Ἰησοῦς αὐτῷ· Ἐὰν μὴ νίψω σε, οὐκ ἔχεις μέρος μετʼ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","λέγει αὐτῷ Σίμων Πέτρος· Κύριε, μὴ τοὺς πόδας μου μόνον ἀλλὰ καὶ τὰς χεῖρας καὶ τὴν κεφαλήν. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","λέγει αὐτῷ ⸀ὁἸησοῦς· Ὁ λελουμένος ⸂οὐκ ἔχει χρείαν ⸂εἰ μὴ τοὺς πόδας νίψασθαι, ἀλλʼ ἔστιν καθαρὸς ὅλος· καὶ ὑμεῖς καθαροί ἐστε, ἀλλʼ οὐχὶ πάντες. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ᾔδει γὰρ τὸν παραδιδόντα αὐτόν· διὰ τοῦτο εἶπεν ⸀ὅτιΟὐχὶ πάντες καθαροί ἐστε. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ὅτε οὖν ἔνιψεν τοὺς πόδας αὐτῶν ⸀καὶἔλαβεν τὰ ἱμάτια αὐτοῦ ⸂καὶ ἀνέπεσεν, πάλιν εἶπεν αὐτοῖς· Γινώσκετε τί πεποίηκα ὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ὑμεῖς φωνεῖτέ με Ὁ διδάσκαλος καὶ Ὁ κύριος, καὶ καλῶς λέγετε, εἰμὶ γάρ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","εἰ οὖν ἐγὼ ἔνιψα ὑμῶν τοὺς πόδας ὁ κύριος καὶ ὁ διδάσκαλος, καὶ ὑμεῖς ὀφείλετε ἀλλήλων νίπτειν τοὺς πόδας· ");
INSERT INTO grcsbl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ὑπόδειγμα γὰρ ἔδωκα ὑμῖν ἵνα καθὼς ἐγὼ ἐποίησα ὑμῖν καὶ ὑμεῖς ποιῆτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ἀμὴν ἀμὴν λέγω ὑμῖν, οὐκ ἔστιν δοῦλος μείζων τοῦ κυρίου αὐτοῦ οὐδὲ ἀπόστολος μείζων τοῦ πέμψαντος αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","εἰ ταῦτα οἴδατε, μακάριοί ἐστε ἐὰν ποιῆτε αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","οὐ περὶ πάντων ὑμῶν λέγω· ἐγὼ οἶδα ⸀τίναςἐξελεξάμην· ἀλλʼ ἵνα ἡ γραφὴ πληρωθῇ· Ὁ τρώγων ⸀μουτὸν ἄρτον ἐπῆρεν ἐπʼ ἐμὲ τὴν πτέρναν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ἀπʼ ἄρτι λέγω ὑμῖν πρὸ τοῦ γενέσθαι, ἵνα ⸂πιστεύσητε ὅταν γένηται ὅτι ἐγώ εἰμι. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ λαμβάνων ⸀ἄντινα πέμψω ἐμὲ λαμβάνει, ὁ δὲ ἐμὲ λαμβάνων λαμβάνει τὸν πέμψαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ταῦτα εἰπὼν ⸀ὁἸησοῦς ἐταράχθη τῷ πνεύματι καὶ ἐμαρτύρησεν καὶ εἶπεν· Ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι εἷς ἐξ ὑμῶν παραδώσει με. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","⸀ἔβλεπονεἰς ἀλλήλους οἱ μαθηταὶ ἀπορούμενοι περὶ τίνος λέγει. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","⸀ἦνἀνακείμενος εἷς ⸀ἐκτῶν μαθητῶν αὐτοῦ ἐν τῷ κόλπῳ τοῦ Ἰησοῦ, ὃν ἠγάπα ὁ Ἰησοῦς· ");
INSERT INTO grcsbl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","νεύει οὖν τούτῳ Σίμων Πέτρος ⸂πυθέσθαι τίς ἂν εἴη περὶ οὗ λέγει. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","⸀ἀναπεσὼνἐκεῖνος οὕτως ἐπὶ τὸ στῆθος τοῦ Ἰησοῦ λέγει αὐτῷ· Κύριε, τίς ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","⸀ἀποκρίνεταιὁ Ἰησοῦς· Ἐκεῖνός ἐστιν ᾧ ἐγὼ ⸀βάψωτὸ ψωμίον ⸂καὶ δώσω αὐτῷ· ⸂βάψας οὖν τὸ ⸀ψωμίονδίδωσιν Ἰούδᾳ Σίμωνος ⸀Ἰσκαριώτου ");
INSERT INTO grcsbl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","καὶ μετὰ τὸ ψωμίον τότε εἰσῆλθεν εἰς ἐκεῖνον ὁ Σατανᾶς. λέγει οὖν αὐτῷ ⸀ὁ Ἰησοῦς· Ὃ ποιεῖς ποίησον τάχιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","τοῦτο δὲ οὐδεὶς ἔγνω τῶν ἀνακειμένων πρὸς τί εἶπεν αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","τινὲς γὰρ ἐδόκουν, ἐπεὶ τὸ γλωσσόκομον ⸀εἶχενἸούδας, ὅτι λέγει αὐτῷ ⸀ὁἸησοῦς· Ἀγόρασον ὧν χρείαν ἔχομεν εἰς τὴν ἑορτήν, ἢ τοῖς πτωχοῖς ἵνα τι δῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","λαβὼν οὖν τὸ ψωμίον ἐκεῖνος ⸂ἐξῆλθεν εὐθύς. ἦν δὲ νύξ. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ὅτε ⸀οὖνἐξῆλθεν ⸀λέγειἸησοῦς· Νῦν ἐδοξάσθη ὁ υἱὸς τοῦ ἀνθρώπου, καὶ ὁ θεὸς ἐδοξάσθη ἐν αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","⸂εἰ ὁ θεὸς ἐδοξάσθη ἐν αὐτῷ⸃ καὶ ὁ θεὸς δοξάσει αὐτὸν ἐν ⸀αὑτῷ καὶ εὐθὺς δοξάσει αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","τεκνία, ἔτι μικρὸν μεθʼ ὑμῶν εἰμι· ζητήσετέ με, καὶ καθὼς εἶπον τοῖς Ἰουδαίοις ὅτι Ὅπου ⸂ἐγὼ ὑπάγω ὑμεῖς οὐ δύνασθε ἐλθεῖν, καὶ ὑμῖν λέγω ἄρτι. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ἐντολὴν καινὴν δίδωμι ὑμῖν ἵνα ἀγαπᾶτε ἀλλήλους, καθὼς ἠγάπησα ὑμᾶς ἵνα καὶ ὑμεῖς ἀγαπᾶτε ἀλλήλους. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ἐν τούτῳ γνώσονται πάντες ὅτι ἐμοὶ μαθηταί ἐστε, ἐὰν ἀγάπην ἔχητε ἐν ἀλλήλοις. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Λέγει αὐτῷ Σίμων Πέτρος· Κύριε, ποῦ ὑπάγεις; ⸀ἀπεκρίθηἸησοῦς· Ὅπου ὑπάγω οὐ δύνασαί μοι νῦν ἀκολουθῆσαι, ⸂ἀκολουθήσεις δὲ ὕστερον. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","λέγει αὐτῷ ⸀ὁΠέτρος· Κύριε, διὰ τί οὐ δύναμαί σοι ⸀ἀκολουθῆσαιἄρτι; τὴν ψυχήν μου ὑπὲρ σοῦ θήσω. ");
INSERT INTO grcsbl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","⸀ἀποκρίνεταιἸησοῦς· Τὴν ψυχήν σου ὑπὲρ ἐμοῦ θήσεις; ἀμὴν ἀμὴν λέγω σοι, οὐ μὴ ἀλέκτωρ φωνήσῃ ἕως οὗ ⸀ἀρνήσῃμε τρίς. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Μὴ ταρασσέσθω ὑμῶν ἡ καρδία· πιστεύετε εἰς τὸν θεόν, καὶ εἰς ἐμὲ πιστεύετε. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ἐν τῇ οἰκίᾳ τοῦ πατρός μου μοναὶ πολλαί εἰσιν· εἰ δὲ μή, εἶπον ἂν ὑμῖν ⸀ὅτιπορεύομαι ἑτοιμάσαι τόπον ὑμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","καὶἐὰν πορευθῶ ⸀καὶ ἑτοιμάσω ⸂τόπον ὑμῖν, πάλιν ἔρχομαι καὶ παραλήμψομαι ὑμᾶς πρὸς ἐμαυτόν, ἵνα ὅπου εἰμὶ ἐγὼ καὶ ὑμεῖς ἦτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","καὶ ὅπου ἐγὼ ὑπάγω οἴδατε ⸂τὴν ὁδόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","λέγει αὐτῷ Θωμᾶς· Κύριε, οὐκ οἴδαμεν ποῦ ὑπάγεις· ⸀πῶς⸂δυνάμεθα τὴν ὁδὸν εἰδέναι; ");
INSERT INTO grcsbl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","λέγει αὐτῷ ⸀ὁἸησοῦς· Ἐγώ εἰμι ἡ ὁδὸς καὶ ἡ ἀλήθεια καὶ ἡ ζωή· οὐδεὶς ἔρχεται πρὸς τὸν πατέρα εἰ μὴ διʼ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","εἰ ⸀ἐγνώκειτέμε, καὶ τὸν πατέρα μου ⸂ἂν ᾔδειτε· ⸀ἀπʼἄρτι γινώσκετε αὐτὸν καὶ ἑωράκατε ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Λέγει αὐτῷ Φίλιππος· Κύριε, δεῖξον ἡμῖν τὸν πατέρα, καὶ ἀρκεῖ ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","λέγει αὐτῷ ὁ Ἰησοῦς· ⸂Τοσούτῳ χρόνῳ μεθʼ ὑμῶν εἰμι καὶ οὐκ ἔγνωκάς με, Φίλιππε; ὁ ἑωρακὼς ἐμὲ ἑώρακεν τὸν πατέρα· ⸀πῶςσὺ λέγεις· Δεῖξον ἡμῖν τὸν πατέρα; ");
INSERT INTO grcsbl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","οὐ πιστεύεις ὅτι ἐγὼ ἐν τῷ πατρὶ καὶ ὁ πατὴρ ἐν ἐμοί ἐστιν; τὰ ῥήματα ἃ ἐγὼ ⸀λέγωὑμῖν ἀπʼ ἐμαυτοῦ οὐ λαλῶ, ὁ δὲ ⸀πατὴρἐν ἐμοὶ ⸀μένωνποιεῖ τὰ ἔργα ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","πιστεύετέ μοι ὅτι ἐγὼ ἐν τῷ πατρὶ καὶ ὁ πατὴρ ἐν ἐμοί· εἰ δὲ μή, διὰ τὰ ἔργα αὐτὰ ⸀πιστεύετε ");
INSERT INTO grcsbl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ἀμὴν ἀμὴν λέγω ὑμῖν, ὁ πιστεύων εἰς ἐμὲ τὰ ἔργα ἃ ἐγὼ ποιῶ κἀκεῖνος ποιήσει, καὶ μείζονα τούτων ποιήσει, ὅτι ἐγὼ πρὸς τὸν ⸀πατέραπορεύομαι· ");
INSERT INTO grcsbl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","καὶ ὅ τι ἂν αἰτήσητε ἐν τῷ ὀνόματί μου τοῦτο ποιήσω, ἵνα δοξασθῇ ὁ πατὴρ ἐν τῷ υἱῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ἐάν τι αἰτήσητέ ⸀μεἐν τῷ ὀνόματί μου ⸀ἐγὼποιήσω. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ἐὰν ἀγαπᾶτέ με, τὰς ἐντολὰς τὰς ἐμὰς ⸀τηρήσετε ");
INSERT INTO grcsbl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","κἀγὼ ἐρωτήσω τὸν πατέρα καὶ ἄλλον παράκλητον δώσει ὑμῖν ἵνα ⸀ᾖμεθʼ ὑμῶν εἰς τὸν ⸀αἰῶνα ");
INSERT INTO grcsbl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","τὸ πνεῦμα τῆς ἀληθείας, ὃ ὁ κόσμος οὐ δύναται λαβεῖν, ὅτι οὐ θεωρεῖ αὐτὸ οὐδὲ ⸀γινώσκει ⸀ὑμεῖςγινώσκετε αὐτό, ὅτι παρʼ ὑμῖν μένει καὶ ἐν ὑμῖν ⸀ἔσται ");
INSERT INTO grcsbl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Οὐκ ἀφήσω ὑμᾶς ὀρφανούς, ἔρχομαι πρὸς ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ἔτι μικρὸν καὶ ὁ κόσμος με οὐκέτι θεωρεῖ, ὑμεῖς δὲ θεωρεῖτέ με, ὅτι ἐγὼ ζῶ καὶ ὑμεῖς ⸀ζήσετε ");
INSERT INTO grcsbl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ἐν ἐκείνῃ τῇ ἡμέρᾳ ⸂γνώσεσθε ὑμεῖς ὅτι ἐγὼ ἐν τῷ πατρί μου καὶ ὑμεῖς ἐν ἐμοὶ κἀγὼ ἐν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ὁ ἔχων τὰς ἐντολάς μου καὶ τηρῶν αὐτὰς ἐκεῖνός ἐστιν ὁ ἀγαπῶν με· ὁ δὲ ἀγαπῶν με ἀγαπηθήσεται ὑπὸ τοῦ πατρός μου, κἀγὼ ἀγαπήσω αὐτὸν καὶ ἐμφανίσω αὐτῷ ἐμαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","λέγει αὐτῷ Ἰούδας, οὐχ ὁ Ἰσκαριώτης· Κύριε, ⸀τίγέγονεν ὅτι ἡμῖν μέλλεις ἐμφανίζειν σεαυτὸν καὶ οὐχὶ τῷ κόσμῳ; ");
INSERT INTO grcsbl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ἀπεκρίθη Ἰησοῦς καὶ εἶπεν αὐτῷ· Ἐάν τις ἀγαπᾷ με τὸν λόγον μου τηρήσει, καὶ ὁ πατήρ μου ἀγαπήσει αὐτόν, καὶ πρὸς αὐτὸν ἐλευσόμεθα καὶ μονὴν παρʼ αὐτῷ ⸀ποιησόμεθα ");
INSERT INTO grcsbl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ὁ μὴ ἀγαπῶν με τοὺς λόγους μου οὐ τηρεῖ· καὶ ὁ λόγος ὃν ἀκούετε οὐκ ἔστιν ἐμὸς ἀλλὰ τοῦ πέμψαντός με πατρός. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ταῦτα λελάληκα ὑμῖν παρʼ ὑμῖν μένων· ");
INSERT INTO grcsbl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ὁ δὲ παράκλητος, τὸ πνεῦμα τὸ ἅγιον ὃ πέμψει ὁ πατὴρ ἐν τῷ ὀνόματί μου, ἐκεῖνος ὑμᾶς διδάξει πάντα καὶ ὑπομνήσει ὑμᾶς πάντα ἃ εἶπον ⸀ὑμῖν ");
INSERT INTO grcsbl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","εἰρήνην ἀφίημι ὑμῖν, εἰρήνην τὴν ἐμὴν δίδωμι ὑμῖν· οὐ καθὼς ὁ κόσμος δίδωσιν ἐγὼ δίδωμι ὑμῖν. μὴ ταρασσέσθω ὑμῶν ἡ καρδία μηδὲ δειλιάτω. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ἠκούσατε ὅτιἐγὼ εἶπον ὑμῖν· Ὑπάγω καὶ ἔρχομαι πρὸς ὑμᾶς. εἰ ἠγαπᾶτέ με ἐχάρητε ἄν, ⸀ὅτι πορεύομαι πρὸς τὸν πατέρα, ὅτι ὁ ⸀πατὴρμείζων μού ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","καὶ νῦν εἴρηκα ὑμῖν πρὶν γενέσθαι, ἵνα ὅταν γένηται πιστεύσητε. ");
INSERT INTO grcsbl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","οὐκέτι πολλὰ λαλήσω μεθʼ ὑμῶν, ἔρχεται γὰρ ὁ τοῦ κόσμου ἄρχων· καὶ ἐν ἐμοὶ οὐκ ἔχει οὐδέν, ");
INSERT INTO grcsbl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ἀλλʼ ἵνα γνῷ ὁ κόσμος ὅτι ἀγαπῶ τὸν πατέρα, καὶ καθὼς ⸀ἐνετείλατομοι ὁ πατὴρ οὕτως ποιῶ. Ἐγείρεσθε, ἄγωμεν ἐντεῦθεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ἐγώ εἰμι ἡ ἄμπελος ἡ ἀληθινή, καὶ ὁ πατήρ μου ὁ γεωργός ἐστιν· ");
INSERT INTO grcsbl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","πᾶν κλῆμα ἐν ἐμοὶ μὴ φέρον καρπὸν αἴρει αὐτό, καὶ πᾶν τὸ καρπὸν φέρον καθαίρει αὐτὸ ἵνα ⸂καρπὸν πλείονα φέρῃ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ἤδη ὑμεῖς καθαροί ἐστε διὰ τὸν λόγον ὃν λελάληκα ὑμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","μείνατε ἐν ἐμοί, κἀγὼ ἐν ὑμῖν. καθὼς τὸ κλῆμα οὐ δύναται καρπὸν φέρειν ἀφʼ ἑαυτοῦ ἐὰν μὴ ⸀μένῃἐν τῇ ἀμπέλῳ, οὕτως οὐδὲ ὑμεῖς ἐὰν μὴ ἐν ἐμοὶ ⸀μένητε ");
INSERT INTO grcsbl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ἐγώ εἰμι ἡ ἄμπελος, ὑμεῖς τὰ κλήματα. ὁ μένων ἐν ἐμοὶ κἀγὼ ἐν αὐτῷ οὗτος φέρει καρπὸν πολύν, ὅτι χωρὶς ἐμοῦ οὐ δύνασθε ποιεῖν οὐδέν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ἐὰν μή τις ⸀μένῃἐν ἐμοί, ἐβλήθη ἔξω ὡς τὸ κλῆμα καὶ ἐξηράνθη, καὶ συνάγουσιν αὐτὰ καὶ εἰς τὸ πῦρ βάλλουσιν καὶ καίεται. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ἐὰν μείνητε ἐν ἐμοὶ καὶ τὰ ῥήματά μου ἐν ὑμῖν μείνῃ, ὃ ἐὰν θέλητε ⸀αἰτήσασθεκαὶ γενήσεται ὑμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ἐν τούτῳ ἐδοξάσθη ὁ πατήρ μου ἵνα καρπὸν πολὺν φέρητε καὶ ⸀γένησθεἐμοὶ μαθηταί. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","καθὼς ἠγάπησέν με ὁ πατήρ, κἀγὼ ⸂ὑμᾶς ἠγάπησα, μείνατε ἐν τῇ ἀγάπῃ τῇ ἐμῇ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ἐὰν τὰς ἐντολάς μου τηρήσητε, μενεῖτε ἐν τῇ ἀγάπῃ μου, καθὼς ἐγὼ ⸂τὰς ἐντολὰς τοῦ πατρός μου τετήρηκα καὶ μένω αὐτοῦ ἐν τῇ ἀγάπῃ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ταῦτα λελάληκα ὑμῖν ἵνα ἡ χαρὰ ἡ ἐμὴ ἐν ὑμῖν ⸀ᾖκαὶ ἡ χαρὰ ὑμῶν πληρωθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Αὕτη ἐστὶν ἡ ἐντολὴ ἡ ἐμὴ ἵνα ἀγαπᾶτε ἀλλήλους καθὼς ἠγάπησα ὑμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","μείζονα ταύτης ἀγάπην οὐδεὶς ἔχει, ἵνα τις τὴν ψυχὴν αὐτοῦ θῇ ὑπὲρ τῶν φίλων αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ὑμεῖς φίλοι μού ἐστε ἐὰν ποιῆτε ⸀ἃἐγὼ ἐντέλλομαι ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","οὐκέτι ⸂λέγω ὑμᾶς δούλους, ὅτι ὁ δοῦλος οὐκ οἶδεν τί ποιεῖ αὐτοῦ ὁ κύριος· ὑμᾶς δὲ εἴρηκα φίλους, ὅτι πάντα ἃ ἤκουσα παρὰ τοῦ πατρός μου ἐγνώρισα ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","οὐχ ὑμεῖς με ἐξελέξασθε, ἀλλʼ ἐγὼ ἐξελεξάμην ὑμᾶς, καὶ ἔθηκα ὑμᾶς ἵνα ὑμεῖς ὑπάγητε καὶ καρπὸν φέρητε καὶ ὁ καρπὸς ὑμῶν μένῃ, ἵνα ὅ τι ἂν αἰτήσητε τὸν πατέρα ἐν τῷ ὀνόματί μου δῷ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ταῦτα ἐντέλλομαι ὑμῖν ἵνα ἀγαπᾶτε ἀλλήλους. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Εἰ ὁ κόσμος ὑμᾶς μισεῖ, γινώσκετε ὅτι ἐμὲ πρῶτον ⸀ὑμῶνμεμίσηκεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","εἰ ἐκ τοῦ κόσμου ἦτε, ὁ κόσμος ἂν τὸ ἴδιον ἐφίλει· ὅτι δὲ ἐκ τοῦ κόσμου οὐκ ἐστέ, ἀλλʼ ἐγὼ ἐξελεξάμην ὑμᾶς ἐκ τοῦ κόσμου, διὰ τοῦτο μισεῖ ὑμᾶς ὁ κόσμος. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","μνημονεύετε τοῦ λόγου οὗ ἐγὼ εἶπον ὑμῖν· Οὐκ ἔστιν δοῦλος μείζων τοῦ κυρίου αὐτοῦ· εἰ ἐμὲ ἐδίωξαν, καὶ ὑμᾶς διώξουσιν· εἰ τὸν λόγον μου ἐτήρησαν, καὶ τὸν ὑμέτερον τηρήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ἀλλὰ ταῦτα πάντα ποιήσουσιν ⸂εἰς ὑμᾶς διὰ τὸ ὄνομά μου, ὅτι οὐκ οἴδασιν τὸν πέμψαντά με. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","εἰ μὴ ἦλθον καὶ ἐλάλησα αὐτοῖς, ἁμαρτίαν οὐκ ⸀εἴχοσαν νῦν δὲ πρόφασιν οὐκ ἔχουσιν περὶ τῆς ἁμαρτίας αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ὁ ἐμὲ μισῶν καὶ τὸν πατέρα μου μισεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","εἰ τὰ ἔργα μὴ ἐποίησα ἐν αὐτοῖς ἃ οὐδεὶς ἄλλος ⸀ἐποίησεν ἁμαρτίαν οὐκ ⸀εἴχοσαν νῦν δὲ καὶ ἑωράκασιν καὶ μεμισήκασιν καὶ ἐμὲ καὶ τὸν πατέρα μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ἀλλʼ ἵνα πληρωθῇ ὁ λόγος ὁ ⸂ἐν τῷ νόμῳ αὐτῶν γεγραμμένος ὅτι Ἐμίσησάν με δωρεάν. ");
INSERT INTO grcsbl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","⸀Ὅτανἔλθῃ ὁ παράκλητος ὃν ἐγὼ πέμψω ὑμῖν παρὰ τοῦ πατρός, τὸ πνεῦμα τῆς ἀληθείας ὃ παρὰ τοῦ πατρὸς ἐκπορεύεται, ἐκεῖνος μαρτυρήσει περὶ ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","καὶ ὑμεῖς δὲ μαρτυρεῖτε, ὅτι ἀπʼ ἀρχῆς μετʼ ἐμοῦ ἐστε. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ταῦτα λελάληκα ὑμῖν ἵνα μὴ σκανδαλισθῆτε. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ἀποσυναγώγους ποιήσουσιν ὑμᾶς· ἀλλʼ ἔρχεται ὥρα ἵνα πᾶς ὁ ἀποκτείνας ὑμᾶς δόξῃ λατρείαν προσφέρειν τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","καὶ ταῦτα ποιήσουσιν ὅτι οὐκ ἔγνωσαν τὸν πατέρα οὐδὲ ἐμέ. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ἀλλὰ ταῦτα λελάληκα ὑμῖν ἵνα ὅταν ἔλθῃ ἡ ὥρα ⸀αὐτῶνμνημονεύητε ⸁αὐτῶνὅτι ἐγὼ εἶπον ὑμῖν. Ταῦτα δὲ ὑμῖν ἐξ ἀρχῆς οὐκ εἶπον, ὅτι μεθʼ ὑμῶν ἤμην. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","νῦν δὲ ὑπάγω πρὸς τὸν πέμψαντά με καὶ οὐδεὶς ἐξ ὑμῶν ἐρωτᾷ με· Ποῦ ὑπάγεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ἀλλʼ ὅτι ταῦτα λελάληκα ὑμῖν ἡ λύπη πεπλήρωκεν ὑμῶν τὴν καρδίαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ἀλλʼ ἐγὼ τὴν ἀλήθειαν λέγω ὑμῖν, συμφέρει ὑμῖν ἵνα ἐγὼ ἀπέλθω. ἐὰν ⸀γὰρμὴ ἀπέλθω, ὁ παράκλητος ⸂οὐ μὴ ἔλθῃ πρὸς ὑμᾶς· ἐὰν δὲ πορευθῶ, πέμψω αὐτὸν πρὸς ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","καὶ ἐλθὼν ἐκεῖνος ἐλέγξει τὸν κόσμον περὶ ἁμαρτίας καὶ περὶ δικαιοσύνης καὶ περὶ κρίσεως· ");
INSERT INTO grcsbl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","περὶ ἁμαρτίας μέν, ὅτι οὐ πιστεύουσιν εἰς ἐμέ· ");
INSERT INTO grcsbl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","περὶ δικαιοσύνης δέ, ὅτι πρὸς τὸν ⸀πατέραὑπάγω καὶ οὐκέτι θεωρεῖτέ με· ");
INSERT INTO grcsbl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","περὶ δὲ κρίσεως, ὅτι ὁ ἄρχων τοῦ κόσμου τούτου κέκριται. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ἔτι πολλὰ ἔχω ⸂ὑμῖν λέγειν, ἀλλʼ οὐ δύνασθε βαστάζειν ἄρτι· ");
INSERT INTO grcsbl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ὅταν δὲ ἔλθῃ ἐκεῖνος, τὸ πνεῦμα τῆς ἀληθείας, ὁδηγήσει ὑμᾶς ⸂ἐν τῇ ἀληθείᾳ πάσῃ, οὐ γὰρ λαλήσει ἀφʼ ἑαυτοῦ, ἀλλʼ ὅσα ⸀ἀκούσειλαλήσει, καὶ τὰ ἐρχόμενα ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ἐκεῖνος ἐμὲ δοξάσει, ὅτι ἐκ τοῦ ἐμοῦ λήμψεται καὶ ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","πάντα ὅσα ἔχει ὁ πατὴρ ἐμά ἐστιν· διὰ τοῦτο εἶπον ὅτι ἐκ τοῦ ἐμοῦ λαμβάνει καὶ ἀναγγελεῖ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Μικρὸν καὶ ⸀οὐκέτιθεωρεῖτέ με καὶ πάλιν μικρὸν καὶ ὄψεσθέ ⸀με. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","εἶπαν οὖν ἐκ τῶν μαθητῶν αὐτοῦ πρὸς ἀλλήλους· Τί ἐστιν τοῦτο ὃ λέγει ἡμῖν· Μικρὸν καὶ οὐ θεωρεῖτέ με, καὶ πάλιν μικρὸν καὶ ὄψεσθέ με; καί· ⸀Ὅτιὑπάγω πρὸς τὸν πατέρα; ");
INSERT INTO grcsbl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ἔλεγον οὖν· ⸂Τί ἐστιν τοῦτο ὃ ⸀λέγειμικρόν; οὐκ οἴδαμεν τί λαλεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","⸀ἔγνωἸησοῦς ὅτι ἤθελον αὐτὸν ἐρωτᾶν, καὶ εἶπεν αὐτοῖς· Περὶ τούτου ζητεῖτε μετʼ ἀλλήλων ὅτι εἶπον· Μικρὸν καὶ οὐ θεωρεῖτέ με, καὶ πάλιν μικρὸν καὶ ὄψεσθέ με; ");
INSERT INTO grcsbl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ἀμὴν ἀμὴν λέγω ὑμῖν ὅτι κλαύσετε καὶ θρηνήσετε ὑμεῖς ὁ δὲ κόσμος χαρήσεται· ⸀ὑμεῖς λυπηθήσεσθε, ἀλλʼ ἡ λύπη ὑμῶν εἰς χαρὰν γενήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ἡ γυνὴ ὅταν τίκτῃ λύπην ἔχει, ὅτι ἦλθεν ἡ ὥρα αὐτῆς· ὅταν δὲ γεννήσῃ τὸ παιδίον, οὐκέτι μνημονεύει τῆς θλίψεως διὰ τὴν χαρὰν ὅτι ἐγεννήθη ἄνθρωπος εἰς τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","καὶ ὑμεῖς οὖν ⸂νῦν μὲν λύπην ἔχετε· πάλιν δὲ ὄψομαι ὑμᾶς, καὶ χαρήσεται ὑμῶν ἡ καρδία, καὶ τὴν χαρὰν ὑμῶν οὐδεὶς ⸀αἴρειἀφʼ ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","καὶ ἐν ἐκείνῃ τῇ ἡμέρᾳ ἐμὲ οὐκ ἐρωτήσετε οὐδέν· ἀμὴν ἀμὴν λέγω ὑμῖν, ⸂ἄν τι αἰτήσητε τὸν πατέρα ⸂δώσει ὑμῖν ἐν τῷ ὀνόματί μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ἕως ἄρτι οὐκ ᾐτήσατε οὐδὲν ἐν τῷ ὀνόματί μου· αἰτεῖτε καὶ λήμψεσθε, ἵνα ἡ χαρὰ ὑμῶν ᾖ πεπληρωμένη. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ταῦτα ἐν παροιμίαις λελάληκα ὑμῖν· ⸀ἔρχεταιὥρα ὅτε οὐκέτι ἐν παροιμίαις λαλήσω ὑμῖν ἀλλὰ παρρησίᾳ περὶ τοῦ πατρὸς ⸀ἀπαγγελῶὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ἐν ἐκείνῃ τῇ ἡμέρᾳ ἐν τῷ ὀνόματί μου αἰτήσεσθε, καὶ οὐ λέγω ὑμῖν ὅτι ἐγὼ ἐρωτήσω τὸν πατέρα περὶ ὑμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","αὐτὸς γὰρ ὁ πατὴρ φιλεῖ ὑμᾶς, ὅτι ὑμεῖς ἐμὲ πεφιλήκατε καὶ πεπιστεύκατε ὅτι ἐγὼ παρὰ τοῦ ⸀θεοῦἐξῆλθον. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ἐξῆλθον ⸀ἐκτοῦ πατρὸς καὶ ἐλήλυθα εἰς τὸν κόσμον· πάλιν ἀφίημι τὸν κόσμον καὶ πορεύομαι πρὸς τὸν πατέρα. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","⸀Λέγουσινοἱ μαθηταὶ αὐτοῦ· Ἴδε νῦν ⸀ἐνπαρρησίᾳ λαλεῖς, καὶ παροιμίαν οὐδεμίαν λέγεις. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","νῦν οἴδαμεν ὅτι οἶδας πάντα καὶ οὐ χρείαν ἔχεις ἵνα τίς σε ἐρωτᾷ· ἐν τούτῳ πιστεύομεν ὅτι ἀπὸ θεοῦ ἐξῆλθες. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ἀπεκρίθη ⸀αὐτοῖςἸησοῦς· Ἄρτι πιστεύετε; ");
INSERT INTO grcsbl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ἰδοὺ ἔρχεται ὥρα ⸀καὶἐλήλυθεν ἵνα σκορπισθῆτε ἕκαστος εἰς τὰ ἴδια κἀμὲ μόνον ἀφῆτε· καὶ οὐκ εἰμὶ μόνος, ὅτι ὁ πατὴρ μετʼ ἐμοῦ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ταῦτα λελάληκα ὑμῖν ἵνα ἐν ἐμοὶ εἰρήνην ἔχητε· ἐν τῷ κόσμῳ θλῖψιν ἔχετε, ἀλλὰ θαρσεῖτε, ἐγὼ νενίκηκα τὸν κόσμον. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ταῦτα ⸀ἐλάλησενἸησοῦς, καὶ ⸂ἐπάρας τοὺς ὀφθαλμοὺς αὐτοῦ εἰς τὸν οὐρανὸν εἶπεν· Πάτερ, ἐλήλυθεν ἡ ὥρα· δόξασόν σου τὸν υἱόν, ⸀ἵναὁ ⸀υἱὸςδοξάσῃ σέ, ");
INSERT INTO grcsbl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","καθὼς ἔδωκας αὐτῷ ἐξουσίαν πάσης σαρκός, ἵνα πᾶν ὃ δέδωκας αὐτῷ ⸀δώσῃαὐτοῖς ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","αὕτη δέ ἐστιν ἡ αἰώνιος ζωὴ ἵνα γινώσκωσι σὲ τὸν μόνον ἀληθινὸν θεὸν καὶ ὃν ἀπέστειλας Ἰησοῦν Χριστόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ἐγώ σε ἐδόξασα ἐπὶ τῆς γῆς, τὸ ἔργον ⸀τελειώσαςὃ δέδωκάς μοι ἵνα ποιήσω· ");
INSERT INTO grcsbl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","καὶ νῦν δόξασόν με σύ, πάτερ, παρὰ σεαυτῷ τῇ δόξῃ ᾗ εἶχον πρὸ τοῦ τὸν κόσμον εἶναι παρὰ σοί. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ἐφανέρωσά σου τὸ ὄνομα τοῖς ἀνθρώποις οὓς ⸀ἔδωκάςμοι ἐκ τοῦ κόσμου. σοὶ ἦσαν κἀμοὶ αὐτοὺς ⸁ἔδωκας καὶ τὸν λόγον σου τετήρηκαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","νῦν ἔγνωκαν ὅτι πάντα ὅσα ⸀δέδωκάςμοι παρὰ σοῦ ⸀εἰσιν ");
INSERT INTO grcsbl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ὅτι τὰ ῥήματα ἃ ⸀ἔδωκάςμοι δέδωκα αὐτοῖς, καὶ αὐτοὶ ἔλαβον καὶ ἔγνωσαν ἀληθῶς ὅτι παρὰ σοῦ ἐξῆλθον, καὶ ἐπίστευσαν ὅτι σύ με ἀπέστειλας. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ἐγὼ περὶ αὐτῶν ἐρωτῶ· οὐ περὶ τοῦ κόσμου ἐρωτῶ ἀλλὰ περὶ ὧν δέδωκάς μοι, ὅτι σοί εἰσιν, ");
INSERT INTO grcsbl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","καὶ τὰ ἐμὰ πάντα σά ἐστιν καὶ τὰ σὰ ἐμά, καὶ δεδόξασμαι ἐν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","καὶ οὐκέτι εἰμὶ ἐν τῷ κόσμῳ, καὶ ⸀αὐτοὶἐν τῷ κόσμῳ εἰσίν, κἀγὼ πρὸς σὲ ἔρχομαι. πάτερ ἅγιε, τήρησον αὐτοὺς ἐν τῷ ὀνόματί σου ᾧ δέδωκάς μοι, ἵνα ὦσιν ἓν ⸀καθὼςἡμεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ὅτε ἤμην μετʼ ⸀αὐτῶνἐγὼ ἐτήρουν αὐτοὺς ἐν τῷ ὀνόματί σου ⸀ᾧδέδωκάς μοι, ⸀καὶἐφύλαξα, καὶ οὐδεὶς ἐξ αὐτῶν ἀπώλετο εἰ μὴ ὁ υἱὸς τῆς ἀπωλείας, ἵνα ἡ γραφὴ πληρωθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","νῦν δὲ πρὸς σὲ ἔρχομαι, καὶ ταῦτα λαλῶ ἐν τῷ κόσμῳ ἵνα ἔχωσιν τὴν χαρὰν τὴν ἐμὴν πεπληρωμένην ἐν ⸀ἑαυτοῖς ");
INSERT INTO grcsbl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ἐγὼ δέδωκα αὐτοῖς τὸν λόγον σου, καὶ ὁ κόσμος ἐμίσησεν αὐτούς, ὅτι οὐκ εἰσὶν ἐκ τοῦ κόσμου καθὼς ἐγὼ οὐκ εἰμὶ ἐκ τοῦ κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","οὐκ ἐρωτῶ ἵνα ἄρῃς αὐτοὺς ἐκ τοῦ κόσμου ἀλλʼ ἵνα τηρήσῃς αὐτοὺς ἐκ τοῦ πονηροῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ἐκ τοῦ κόσμου οὐκ εἰσὶν καθὼς ἐγὼ ⸂οὐκ εἰμὶ ἐκ τοῦ κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ἁγίασον αὐτοὺς ἐν τῇ ⸀ἀληθείᾳ ὁ λόγος ὁ σὸς ἀλήθειά ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","καθὼς ἐμὲ ἀπέστειλας εἰς τὸν κόσμον, κἀγὼ ἀπέστειλα αὐτοὺς εἰς τὸν κόσμον· ");
INSERT INTO grcsbl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","καὶ ὑπὲρ αὐτῶν ἐγὼ ἁγιάζω ἐμαυτόν, ἵνα ⸂ὦσιν καὶ αὐτοὶ ἡγιασμένοι ἐν ἀληθείᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Οὐ περὶ τούτων δὲ ἐρωτῶ μόνον, ἀλλὰ καὶ περὶ τῶν πιστευόντων διὰ τοῦ λόγου αὐτῶν εἰς ἐμέ, ");
INSERT INTO grcsbl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ἵνα πάντες ἓν ὦσιν, καθὼς σύ, ⸀πάτερ ἐν ἐμοὶ κἀγὼ ἐν σοί, ἵνα καὶ αὐτοὶ ἐν ⸀ἡμῖνὦσιν, ἵνα ὁ κόσμος ⸀πιστεύῃὅτι σύ με ἀπέστειλας. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","κἀγὼ τὴν δόξαν ἣν δέδωκάς μοι δέδωκα αὐτοῖς, ἵνα ὦσιν ἓν καθὼς ἡμεῖς ⸀ἕν ");
INSERT INTO grcsbl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ἐγὼ ἐν αὐτοῖς καὶ σὺ ἐν ἐμοί, ἵναὦσιν τετελειωμένοι εἰς ἕν, ⸀ἵνα γινώσκῃ ὁ κόσμος ὅτι σύ με ἀπέστειλας καὶ ἠγάπησας αὐτοὺς καθὼς ἐμὲ ἠγάπησας. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","⸀πάτερ ⸀ὃδέδωκάςμοι, θέλω ἵνα ὅπου εἰμὶ ἐγὼ κἀκεῖνοι ὦσιν μετʼ ἐμοῦ, ἵνα θεωρῶσιν τὴν δόξαν τὴν ἐμὴν ἣν ⸀δέδωκάς μοι, ὅτι ἠγάπησάς με πρὸ καταβολῆς κόσμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","⸀Πάτερδίκαιε, καὶ ὁ κόσμος σε οὐκ ἔγνω, ἐγὼ δέ σε ἔγνων, καὶ οὗτοι ἔγνωσαν ὅτι σύ με ἀπέστειλας, ");
INSERT INTO grcsbl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","καὶ ἐγνώρισα αὐτοῖς τὸ ὄνομά σου καὶ γνωρίσω, ἵνα ἡ ἀγάπη ἣν ἠγάπησάς με ἐν αὐτοῖς ᾖ κἀγὼ ἐν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ταῦτα ⸀εἰπὼνἸησοῦς ἐξῆλθεν σὺν τοῖς μαθηταῖς αὐτοῦπέραν τοῦ χειμάρρου ⸀τοῦ Κεδρὼν ὅπου ἦν κῆπος, εἰς ὃν εἰσῆλθεν αὐτὸς καὶ οἱ μαθηταὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ᾔδει δὲ καὶ Ἰούδας ὁ παραδιδοὺς αὐτὸν τὸν τόπον, ὅτι πολλάκις ⸀συνήχθηἸησοῦς ἐκεῖ μετὰ τῶν μαθητῶν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ὁ οὖν Ἰούδας λαβὼν τὴν σπεῖραν καὶ ἐκ τῶνἀρχιερέων καὶ ⸂ἐκ τῶν⸃ Φαρισαίων ὑπηρέτας ἔρχεται ἐκεῖ μετὰ φανῶν καὶ λαμπάδων καὶ ὅπλων. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ἰησοῦς ⸀οὖνεἰδὼς πάντα τὰ ἐρχόμενα ἐπʼ αὐτὸν ⸂ἐξῆλθεν, καὶ λέγει⸃ αὐτοῖς· Τίνα ζητεῖτε; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ἀπεκρίθησαν αὐτῷ· Ἰησοῦν τὸν Ναζωραῖον. λέγει ⸀αὐτοῖς Ἐγώ εἰμι. εἱστήκει δὲ καὶ Ἰούδας ὁ παραδιδοὺς αὐτὸν μετʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ὡς οὖν εἶπεν ⸀αὐτοῖς Ἐγώ εἰμι, ἀπῆλθον εἰς τὰ ὀπίσω καὶ ἔπεσαν χαμαί. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","πάλιν οὖν ⸂ἐπηρώτησεν αὐτούς· Τίνα ζητεῖτε; οἱ δὲ εἶπαν· Ἰησοῦν τὸν Ναζωραῖον. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ἀπεκρίθη Ἰησοῦς· Εἶπον ὑμῖν ὅτι ἐγώ εἰμι· εἰ οὖν ἐμὲ ζητεῖτε, ἄφετε τούτους ὑπάγειν· ");
INSERT INTO grcsbl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ἵνα πληρωθῇ ὁ λόγος ὃν εἶπεν ὅτι Οὓς δέδωκάς μοι οὐκ ἀπώλεσα ἐξ αὐτῶν οὐδένα. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Σίμων οὖν Πέτρος ἔχων μάχαιραν εἵλκυσεν αὐτὴν καὶ ἔπαισεν τὸν τοῦ ἀρχιερέως δοῦλον καὶ ἀπέκοψεν αὐτοῦ τὸ ⸀ὠτάριοντὸ δεξιόν. ἦν δὲ ὄνομα τῷ δούλῳ Μάλχος. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","εἶπεν οὖν ὁ Ἰησοῦς τῷ Πέτρῳ· Βάλε τὴν ⸀μάχαιρανεἰς τὴν θήκην· τὸ ποτήριον ὃ δέδωκέν μοι ὁ πατὴρ οὐ μὴ πίω αὐτό; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ἡ οὖν σπεῖρα καὶ ὁ χιλίαρχος καὶ οἱ ὑπηρέται τῶν Ἰουδαίων συνέλαβον τὸν Ἰησοῦν καὶ ἔδησαν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","καὶ ⸀ἤγαγονπρὸς Ἅνναν πρῶτον· ἦν γὰρ πενθερὸς τοῦ Καϊάφα, ὃς ἦν ἀρχιερεὺς τοῦ ἐνιαυτοῦ ἐκείνου· ");
INSERT INTO grcsbl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ἦν δὲ Καϊάφας ὁ συμβουλεύσας τοῖς Ἰουδαίοις ὅτι συμφέρει ἕνα ἄνθρωπον ⸀ἀποθανεῖνὑπὲρ τοῦ λαοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ἠκολούθει δὲ τῷ Ἰησοῦ Σίμων Πέτρος ⸀καὶἄλλος μαθητής. ὁ δὲ μαθητὴς ἐκεῖνος ἦν γνωστὸς τῷ ἀρχιερεῖ καὶ συνεισῆλθεν τῷ Ἰησοῦ εἰς τὴν αὐλὴν τοῦ ἀρχιερέως, ");
INSERT INTO grcsbl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ὁδὲ Πέτρος εἱστήκει πρὸς τῇ θύρᾳ ἔξω. ἐξῆλθεν οὖν ὁ μαθητὴς ὁ ἄλλος ⸀ὁ γνωστὸς ⸂τοῦ ἀρχιερέως καὶ εἶπεν τῇ θυρωρῷ καὶ εἰσήγαγεν τὸν Πέτρον. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","λέγει οὖν ⸂τῷ Πέτρῳ ἡ παιδίσκη ἡ θυρωρός· Μὴ καὶ σὺ ἐκ τῶν μαθητῶν εἶ τοῦ ἀνθρώπου τούτου; λέγει ἐκεῖνος· Οὐκ εἰμί. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","εἱστήκεισαν δὲ οἱ δοῦλοι καὶ οἱ ὑπηρέται ἀνθρακιὰν πεποιηκότες, ὅτι ψῦχος ἦν, καὶ ἐθερμαίνοντο· ἦν δὲ ⸂καὶ ὁ Πέτρος μετʼ αὐτῶν ἑστὼς καὶ θερμαινόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ὁ οὖν ἀρχιερεὺς ἠρώτησεν τὸν Ἰησοῦν περὶ τῶν μαθητῶν αὐτοῦ καὶ περὶ τῆς διδαχῆς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ἀπεκρίθη ⸀αὐτῷἸησοῦς· Ἐγὼ παρρησίᾳ ⸀λελάληκατῷ κόσμῳ· ἐγὼ πάντοτε ἐδίδαξα ἐν συναγωγῇ καὶ ἐν τῷ ἱερῷ, ὅπου ⸀πάντεςοἱ Ἰουδαῖοι συνέρχονται, καὶ ἐν κρυπτῷ ἐλάλησα οὐδέν· ");
INSERT INTO grcsbl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","τί με ⸂ἐρωτᾷς; ἐρώτησον τοὺς ἀκηκοότας τί ἐλάλησα αὐτοῖς· ἴδε οὗτοι οἴδασιν ἃ εἶπον ἐγώ. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ταῦτα δὲ αὐτοῦ εἰπόντος εἷς ⸂παρεστηκὼς τῶν ὑπηρετῶν ἔδωκεν ῥάπισμα τῷ Ἰησοῦ εἰπών· Οὕτως ἀποκρίνῃ τῷ ἀρχιερεῖ; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ἀπεκρίθη ⸀αὐτῷἸησοῦς· Εἰ κακῶς ἐλάλησα, μαρτύρησον περὶ τοῦ κακοῦ· εἰ δὲ καλῶς, τί με δέρεις; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ἀπέστειλεν ⸀οὖναὐτὸν ὁ Ἅννας δεδεμένον πρὸς Καϊάφαν τὸν ἀρχιερέα. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ἦν δὲ Σίμων Πέτρος ἑστὼς καὶ θερμαινόμενος. εἶπον οὖν αὐτῷ· Μὴ καὶ σὺ ἐκ τῶν μαθητῶν αὐτοῦ εἶ; ⸀ἠρνήσατοἐκεῖνος καὶ εἶπεν· Οὐκ εἰμί. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","λέγει εἷς ἐκ τῶν δούλων τοῦ ἀρχιερέως, συγγενὴς ὢν οὗ ἀπέκοψεν Πέτρος τὸ ὠτίον· Οὐκ ἐγώ σε εἶδον ἐν τῷ κήπῳ μετʼ αὐτοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","πάλιν οὖν ⸀ἠρνήσατοΠέτρος· καὶ εὐθέως ἀλέκτωρ ἐφώνησεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ἄγουσιν οὖν τὸν Ἰησοῦν ἀπὸ τοῦ Καϊάφα εἰς τὸ πραιτώριον· ἦν δὲ πρωΐ· καὶ αὐτοὶ οὐκ εἰσῆλθον εἰς τὸ πραιτώριον, ἵνα μὴ μιανθῶσιν ⸀ἀλλὰφάγωσιν τὸ πάσχα. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ἐξῆλθεν οὖν ὁ Πιλᾶτος ⸀ἔξωπρὸς αὐτοὺς καὶ ⸀φησίν Τίνα κατηγορίαν φέρετε ⸀κατὰτοῦ ἀνθρώπου τούτου; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ἀπεκρίθησαν καὶ εἶπαν αὐτῷ· Εἰ μὴ ἦν οὗτος ⸂κακὸν ποιῶν, οὐκ ἄν σοι παρεδώκαμεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","εἶπεν οὖν αὐτοῖς ⸀ὁΠιλᾶτος· Λάβετε αὐτὸν ὑμεῖς, καὶ κατὰ τὸν νόμον ὑμῶν κρίνατε αὐτόν. ⸀εἶποναὐτῷ οἱ Ἰουδαῖοι· Ἡμῖν οὐκ ἔξεστιν ἀποκτεῖναι οὐδένα· ");
INSERT INTO grcsbl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ἵνα ὁ λόγος τοῦ Ἰησοῦ πληρωθῇ ὃν εἶπεν σημαίνων ποίῳ θανάτῳ ἤμελλεν ἀποθνῄσκειν. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Εἰσῆλθεν οὖν ⸂πάλιν εἰς τὸ πραιτώριον ὁ Πιλᾶτος καὶ ἐφώνησεν τὸν Ἰησοῦν καὶ εἶπεν αὐτῷ· Σὺ εἶ ὁ βασιλεὺς τῶν Ἰουδαίων; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","⸀ἀπεκρίθηἸησοῦς· ⸂Ἀπὸ σεαυτοῦ σὺ τοῦτο λέγεις ἢ ἄλλοι ⸂εἶπόν σοι περὶ ἐμοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ἀπεκρίθη ὁ Πιλᾶτος· Μήτι ἐγὼ Ἰουδαῖός εἰμι; τὸ ἔθνος τὸ σὸν καὶ οἱ ἀρχιερεῖς παρέδωκάν σε ἐμοί· τί ἐποίησας; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ἀπεκρίθη Ἰησοῦς· Ἡ βασιλεία ἡ ἐμὴ οὐκ ἔστιν ἐκ τοῦ κόσμου τούτου· εἰ ἐκ τοῦ κόσμου τούτου ἦν ἡ βασιλεία ἡ ἐμή, οἱ ὑπηρέται ⸂οἱ ἐμοὶ ἠγωνίζοντο ἄν, ἵνα μὴ παραδοθῶ τοῖς Ἰουδαίοις· νῦν δὲ ἡ βασιλεία ἡ ἐμὴ οὐκ ἔστιν ἐντεῦθεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","εἶπεν οὖν αὐτῷ ὁ Πιλᾶτος· Οὐκοῦν βασιλεὺς εἶ σύ; ἀπεκρίθη ⸀ὁ Ἰησοῦς· Σὺ λέγεις ὅτι βασιλεύς ⸀εἰμι ἐγὼ εἰς τοῦτο γεγέννημαι καὶ εἰς τοῦτο ἐλήλυθα εἰς τὸν κόσμον ἵνα μαρτυρήσω τῇ ἀληθείᾳ· πᾶς ὁ ὢν ἐκ τῆς ἀληθείας ἀκούει μου τῆς φωνῆς. ");
INSERT INTO grcsbl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","λέγει αὐτῷ ὁ Πιλᾶτος· Τί ἐστιν ἀλήθεια; Καὶ τοῦτο εἰπὼν πάλιν ἐξῆλθεν πρὸς τοὺς Ἰουδαίους, καὶ λέγει αὐτοῖς· Ἐγὼ οὐδεμίαν ⸂εὑρίσκω ἐν αὐτῷ αἰτίαν· ");
INSERT INTO grcsbl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ἔστιν δὲ συνήθεια ὑμῖν ἵνα ἕνα ⸂ἀπολύσω ὑμῖν⸃ἐν τῷ πάσχα· βούλεσθε οὖν ⸄ἀπολύσω ὑμῖν⸅τὸν βασιλέα τῶν Ἰουδαίων; ");
INSERT INTO grcsbl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ἐκραύγασαν οὖν ⸀πάλινλέγοντες· Μὴ τοῦτον ἀλλὰ τὸν Βαραββᾶν. ἦν δὲ ὁ Βαραββᾶς λῃστής. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Τότε οὖν ἔλαβεν ὁ Πιλᾶτος τὸν Ἰησοῦν καὶ ἐμαστίγωσεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","καὶ οἱ στρατιῶται πλέξαντες στέφανον ἐξ ἀκανθῶν ἐπέθηκαν αὐτοῦ τῇ κεφαλῇ, καὶ ἱμάτιον πορφυροῦν περιέβαλον αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","καὶ ⸂ἤρχοντο πρὸς αὐτὸν καὶ ἔλεγον· Χαῖρε, ὁ βασιλεὺς τῶν Ἰουδαίων· καὶ ἐδίδοσαν αὐτῷ ῥαπίσματα. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","⸂καὶ ἐξῆλθεν πάλιν ἔξω ὁ Πιλᾶτος καὶ λέγει αὐτοῖς· Ἴδε ἄγω ὑμῖν αὐτὸν ἔξω, ἵνα γνῶτε ὅτι ⸂οὐδεμίαν αἰτίαν εὑρίσκω ἐν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ἐξῆλθεν οὖν ὁ Ἰησοῦς ἔξω, φορῶν τὸν ἀκάνθινον στέφανον καὶ τὸ πορφυροῦν ἱμάτιον. καὶ λέγει αὐτοῖς· ⸀Ἰδοὺὁ ἄνθρωπος. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ὅτε οὖν εἶδον αὐτὸν οἱ ἀρχιερεῖς καὶ οἱ ὑπηρέται ἐκραύγασαν λέγοντες· Σταύρωσον ⸀σταύρωσον λέγει αὐτοῖς ὁ Πιλᾶτος· Λάβετε αὐτὸν ὑμεῖς καὶ σταυρώσατε, ἐγὼ γὰρ οὐχ εὑρίσκω ἐν αὐτῷ αἰτίαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ἀπεκρίθησαν αὐτῷ οἱ Ἰουδαῖοι· Ἡμεῖς νόμονἔχομεν, καὶ κατὰ τὸν ⸀νόμον ὀφείλει ἀποθανεῖν, ὅτι ⸂υἱὸν θεοῦ ἑαυτὸν ἐποίησεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ὅτε οὖν ἤκουσεν ὁ Πιλᾶτος τοῦτον τὸν λόγον, μᾶλλον ἐφοβήθη, ");
INSERT INTO grcsbl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","καὶ εἰσῆλθεν εἰς τὸ πραιτώριον πάλιν καὶ λέγει τῷ Ἰησοῦ· Πόθεν εἶ σύ; ὁ δὲ Ἰησοῦς ἀπόκρισιν οὐκ ἔδωκεν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","λέγει οὖν αὐτῷ ὁ Πιλᾶτος· Ἐμοὶ οὐ λαλεῖς; οὐκ οἶδας ὅτι ἐξουσίαν ἔχω ⸂ἀπολῦσαί σε καὶ ἐξουσίαν ἔχω σταυρῶσαί σε; ");
INSERT INTO grcsbl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ἀπεκρίθη ⸀αὐτῷἸησοῦς· Οὐκ εἶχες ἐξουσίαν ⸂κατʼ ἐμοῦ οὐδεμίαν εἰ μὴ ἦν ⸂δεδομένον σοι ἄνωθεν· διὰ τοῦτο ὁ ⸀παραδούςμέ σοι μείζονα ἁμαρτίαν ἔχει. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ἐκ τούτου ⸂ὁ Πιλᾶτος ἐζήτει ἀπολῦσαι αὐτόν· οἱ δὲ Ἰουδαῖοι ⸀ἐκραύγασανλέγοντες· Ἐὰν τοῦτον ἀπολύσῃς, οὐκ εἶ φίλος τοῦ Καίσαρος· πᾶς ὁ βασιλέα ἑαυτὸν ποιῶν ἀντιλέγει τῷ Καίσαρι. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ὁ οὖν Πιλᾶτος ἀκούσας ⸂τῶν λόγων τούτων ἤγαγεν ἔξω τὸν Ἰησοῦν, καὶ ἐκάθισεν ⸀ἐπὶβήματος εἰς τόπον λεγόμενον Λιθόστρωτον, Ἑβραϊστὶ δὲ Γαββαθα. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ἦν δὲ παρασκευὴ τοῦ πάσχα, ὥρα ⸂ἦν ὡς ἕκτη. καὶ λέγει τοῖς Ἰουδαίοις· Ἴδε ὁ βασιλεὺς ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","⸂ἐκραύγασαν οὖν ἐκεῖνοι· Ἆρον ἆρον, σταύρωσον αὐτόν. λέγει αὐτοῖς ὁ Πιλᾶτος· Τὸν βασιλέα ὑμῶν σταυρώσω; ἀπεκρίθησαν οἱ ἀρχιερεῖς· Οὐκ ἔχομεν βασιλέα εἰ μὴ Καίσαρα. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","τότε οὖνπαρέδωκεν αὐτὸν αὐτοῖς ἵνα σταυρωθῇ. Παρέλαβον ⸀οὖν τὸν ⸀Ἰησοῦν· ");
INSERT INTO grcsbl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","καὶ βαστάζων ⸂αὑτῷ τὸν σταυρὸν ἐξῆλθεν εἰς ⸀τὸνλεγόμενον Κρανίου Τόπον, ⸀ὃλέγεται Ἑβραϊστὶ Γολγοθα, ");
INSERT INTO grcsbl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ὅπου αὐτὸν ἐσταύρωσαν, καὶ μετʼ αὐτοῦ ἄλλους δύο ἐντεῦθεν καὶ ἐντεῦθεν, μέσον δὲ τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ἔγραψεν δὲ καὶ τίτλον ὁ Πιλᾶτος καὶ ἔθηκεν ἐπὶ τοῦ σταυροῦ· ἦν δὲ γεγραμμένον· Ἰησοῦς ὁ Ναζωραῖος ὁ βασιλεὺς τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","τοῦτον οὖν τὸν τίτλον πολλοὶ ἀνέγνωσαν τῶν Ἰουδαίων, ὅτι ἐγγὺς ἦν ὁ τόπος τῆς πόλεως ὅπου ἐσταυρώθη ὁ Ἰησοῦς· καὶ ἦν γεγραμμένον Ἑβραϊστί, ⸂Ῥωμαϊστί, Ἑλληνιστί⸃. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ἔλεγον οὖν τῷ Πιλάτῳ οἱ ἀρχιερεῖς τῶν Ἰουδαίων· Μὴ γράφε· Ὁ βασιλεὺς τῶν Ἰουδαίων, ἀλλʼ ὅτι ἐκεῖνος εἶπεν Βασιλεὺς ⸂τῶν Ἰουδαίων εἰμί. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ἀπεκρίθη ὁ Πιλᾶτος· Ὃ γέγραφα γέγραφα. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","οἱ οὖν στρατιῶται ὅτε ἐσταύρωσαν τὸν Ἰησοῦν ἔλαβον τὰ ἱμάτια αὐτοῦ καὶ ἐποίησαν τέσσαρα μέρη, ἑκάστῳ στρατιώτῃ μέρος, καὶ τὸν χιτῶνα. ἦν δὲ ὁ χιτὼν ἄραφος, ἐκ τῶν ἄνωθεν ὑφαντὸς διʼ ὅλου· ");
INSERT INTO grcsbl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","εἶπαν οὖν πρὸς ἀλλήλους· Μὴ σχίσωμεν αὐτόν, ἀλλὰ λάχωμεν περὶ αὐτοῦ τίνος ἔσται· ἵνα ἡ γραφὴ πληρωθῇ ⸂ἡ λέγουσα· Διεμερίσαντο τὰ ἱμάτιά μου ἑαυτοῖς καὶ ἐπὶ τὸν ἱματισμόν μου ἔβαλον κλῆρον. Οἱ μὲν οὖν στρατιῶται ταῦτα ἐποίησαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Εἱστήκεισαν δὲ παρὰ τῷ σταυρῷ τοῦ Ἰησοῦ ἡ μήτηρ αὐτοῦ καὶ ἡ ἀδελφὴ τῆς μητρὸς αὐτοῦ, Μαρία ἡ τοῦ Κλωπᾶ καὶ Μαρία ἡ Μαγδαληνή. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ἰησοῦς οὖν ἰδὼν τὴν μητέρα καὶ τὸν μαθητὴν παρεστῶτα ὃν ἠγάπα λέγει τῇ ⸀μητρί Γύναι, ⸀ἴδεὁ υἱός σου· ");
INSERT INTO grcsbl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","εἶτα λέγει τῷ μαθητῇ· ⸀Ἴδεἡ μήτηρ σου. καὶ ἀπʼ ἐκείνης τῆς ὥρας ἔλαβεν ὁ μαθητὴς αὐτὴν εἰς τὰ ἴδια. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Μετὰ τοῦτο ⸀εἰδὼςὁ Ἰησοῦς ὅτι ⸂ἤδη πάντα τετέλεσται ἵνα τελειωθῇ ἡ γραφὴ λέγει· Διψῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","⸀σκεῦοςἔκειτο ὄξους μεστόν· ⸂σπόγγον οὖν μεστὸν τοῦ ὄξους ⸀ὑσσώπῳπεριθέντες προσήνεγκαν αὐτοῦ τῷ στόματι. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ὅτε οὖν ἔλαβεν τὸ ὄξος ὁ Ἰησοῦς εἶπεν· Τετέλεσται, καὶ κλίνας τὴν κεφαλὴν παρέδωκεν τὸ πνεῦμα. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Οἱ οὖν Ἰουδαῖοι, ⸂ἐπεὶ παρασκευὴ ἦν, ἵνα μὴ μείνῃ ἐπὶ τοῦ σταυροῦ τὰ σώματα ἐν τῷ σαββάτῳ⸃, ἦν γὰρ μεγάλη ἡ ἡμέρα ἐκείνου τοῦ σαββάτου, ἠρώτησαν τὸν Πιλᾶτον ἵνα κατεαγῶσιν αὐτῶν τὰ σκέλη καὶ ἀρθῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ἦλθον οὖν οἱ στρατιῶται, καὶ τοῦ μὲν πρώτου κατέαξαν τὰ σκέλη καὶ τοῦ ἄλλου τοῦ συσταυρωθέντος αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ἐπὶ δὲ τὸν Ἰησοῦν ἐλθόντες, ὡς εἶδον ⸂ἤδη αὐτὸν τεθνηκότα, οὐ κατέαξαν αὐτοῦ τὰ σκέλη, ");
INSERT INTO grcsbl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ἀλλʼ εἷς τῶν στρατιωτῶν λόγχῃ αὐτοῦ τὴν πλευρὰν ἔνυξεν, καὶ ⸂ἐξῆλθεν εὐθὺς αἷμα καὶ ὕδωρ. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","καὶ ὁ ἑωρακὼς μεμαρτύρηκεν, καὶ ἀληθινὴ ⸂αὐτοῦ ἐστιν ἡ μαρτυρία, καὶἐκεῖνος οἶδεν ὅτι ἀληθῆ λέγει, ἵνα ⸀καὶ ὑμεῖς ⸀πιστεύητε ");
INSERT INTO grcsbl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ἐγένετο γὰρ ταῦτα ἵνα ἡ γραφὴ πληρωθῇ· Ὀστοῦν οὐ συντριβήσεται ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","καὶ πάλιν ἑτέρα γραφὴ λέγει· Ὄψονται εἰς ὃν ἐξεκέντησαν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Μετὰ ⸀δὲταῦτα ἠρώτησεν τὸν Πιλᾶτον Ἰωσὴφ ⸀ἀπὸἉριμαθαίας, ὢν μαθητὴς τοῦ Ἰησοῦ κεκρυμμένος δὲ διὰ τὸν φόβον τῶν Ἰουδαίων, ἵνα ἄρῃ τὸ σῶμα τοῦ Ἰησοῦ· καὶ ἐπέτρεψεν ὁ Πιλᾶτος. ἦλθεν οὖν καὶ ἦρεν τὸ σῶμα ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ἦλθεν δὲ καὶ Νικόδημος, ὁ ἐλθὼν πρὸς ⸀αὐτὸννυκτὸς τὸ πρῶτον, φέρων ⸀μίγμασμύρνης καὶ ἀλόης ὡς λίτρας ἑκατόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ἔλαβον οὖν τὸ σῶμα τοῦ Ἰησοῦ καὶ ἔδησαν ⸀αὐτὸὀθονίοις μετὰ τῶν ἀρωμάτων, καθὼς ἔθος ἐστὶν τοῖς Ἰουδαίοις ἐνταφιάζειν. ");
INSERT INTO grcsbl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ἦν δὲ ἐν τῷ τόπῳ ὅπου ἐσταυρώθη κῆπος, καὶ ἐν τῷ κήπῳ μνημεῖον καινόν, ἐν ᾧ οὐδέπω οὐδεὶς ⸂ἦν τεθειμένος· ");
INSERT INTO grcsbl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ἐκεῖ οὖν διὰ τὴν παρασκευὴν τῶν Ἰουδαίων, ὅτι ἐγγὺς ἦν τὸ μνημεῖον, ἔθηκαν τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Τῇ δὲ μιᾷ τῶν σαββάτων Μαρία ἡ Μαγδαληνὴ ἔρχεται πρωῒ σκοτίας ἔτι οὔσης εἰς τὸ μνημεῖον, καὶ βλέπει τὸν λίθον ἠρμένον ἐκ τοῦ μνημείου. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","τρέχει οὖν καὶ ἔρχεται πρὸς Σίμωνα Πέτρον καὶ πρὸς τὸν ἄλλον μαθητὴν ὃν ἐφίλει ὁ Ἰησοῦς, καὶ λέγει αὐτοῖς· Ἦραν τὸν κύριον ἐκ τοῦ μνημείου, καὶ οὐκ οἴδαμεν ποῦ ἔθηκαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ἐξῆλθεν οὖν ὁ Πέτρος καὶ ὁ ἄλλος μαθητής, καὶ ἤρχοντο εἰς τὸ μνημεῖον. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ἔτρεχον δὲ οἱ δύο ὁμοῦ· καὶ ὁ ἄλλος μαθητὴς προέδραμεν τάχιον τοῦ Πέτρου καὶ ἦλθεν πρῶτος εἰς τὸ μνημεῖον, ");
INSERT INTO grcsbl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","καὶ παρακύψας βλέπει κείμενα τὰ ὀθόνια, οὐ μέντοι εἰσῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ἔρχεται οὖν ⸀καὶΣίμων Πέτρος ἀκολουθῶν αὐτῷ, καὶ εἰσῆλθεν εἰς τὸ μνημεῖον· καὶ θεωρεῖ τὰ ὀθόνια κείμενα, ");
INSERT INTO grcsbl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","καὶ τὸ σουδάριον, ὃ ἦν ἐπὶ τῆς κεφαλῆς αὐτοῦ, οὐ μετὰ τῶν ὀθονίων κείμενον ἀλλὰ χωρὶς ἐντετυλιγμένον εἰς ἕνα τόπον· ");
INSERT INTO grcsbl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","τότε οὖν εἰσῆλθεν καὶ ὁ ἄλλος μαθητὴς ὁ ἐλθὼν πρῶτος εἰς τὸ μνημεῖον, καὶ εἶδεν καὶ ἐπίστευσεν· ");
INSERT INTO grcsbl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","οὐδέπω γὰρ ᾔδεισαν τὴν γραφὴν ὅτι δεῖ αὐτὸν ἐκ νεκρῶν ἀναστῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ἀπῆλθον οὖν πάλιν πρὸς ⸀αὑτοὺςοἱ μαθηταί. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Μαρία δὲ εἱστήκει πρὸς ⸂τῷ μνημείῳ ἔξω κλαίουσα. ὡς οὖν ἔκλαιεν παρέκυψεν εἰς τὸ μνημεῖον, ");
INSERT INTO grcsbl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","καὶ θεωρεῖ δύο ἀγγέλους ἐν λευκοῖς καθεζομένους, ἕνα πρὸς τῇ κεφαλῇ καὶ ἕνα πρὸς τοῖς ποσίν, ὅπου ἔκειτο τὸ σῶμα τοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","καὶ λέγουσιν αὐτῇ ἐκεῖνοι· Γύναι, τί κλαίεις; λέγει αὐτοῖς ὅτι Ἦραν τὸν κύριόν μου, καὶ οὐκ οἶδα ποῦ ἔθηκαν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","⸀ταῦταεἰποῦσα ἐστράφη εἰς τὰ ὀπίσω, καὶ θεωρεῖ τὸν Ἰησοῦν ἑστῶτα, καὶ οὐκ ᾔδει ὅτι Ἰησοῦς ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","λέγει ⸀αὐτῇἸησοῦς· Γύναι, τί κλαίεις; τίνα ζητεῖς; ἐκείνη δοκοῦσα ὅτι ὁ κηπουρός ἐστιν λέγει αὐτῷ· Κύριε, εἰ σὺ ἐβάστασας αὐτόν, εἰπέ μοι ποῦ ἔθηκας αὐτόν, κἀγὼ αὐτὸν ἀρῶ. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","λέγει ⸀αὐτῇἸησοῦς· ⸀Μαριάμ στραφεῖσα ἐκείνη λέγει αὐτῷ ⸀Ἑβραϊστί Ραββουνι (ὃ λέγεται Διδάσκαλε). ");
INSERT INTO grcsbl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","λέγει ⸀αὐτῇἸησοῦς· Μή μου ἅπτου, οὔπω γὰρ ἀναβέβηκα πρὸς τὸν ⸀πατέρα πορεύου δὲ πρὸς τοὺς ἀδελφούς μου καὶ εἰπὲ αὐτοῖς· Ἀναβαίνω πρὸς τὸν πατέρα μου καὶ πατέρα ὑμῶν καὶ θεόν μου καὶ θεὸν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ἔρχεται ⸀Μαριὰμἡ Μαγδαληνὴ ⸀ἀγγέλλουσατοῖς μαθηταῖς ὅτι ⸀Ἑώρακατὸν κύριον καὶ ταῦτα εἶπεν αὐτῇ. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Οὔσης οὖν ὀψίας τῇ ἡμέρᾳ ἐκείνῃ τῇ ⸀μιᾷσαββάτων, καὶ τῶν θυρῶν κεκλεισμένων ὅπου ἦσαν οἱ ⸀μαθηταὶδιὰ τὸν φόβον τῶν Ἰουδαίων, ἦλθεν ὁ Ἰησοῦς καὶ ἔστη εἰς τὸ μέσον, καὶ λέγει αὐτοῖς· Εἰρήνη ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","καὶ τοῦτο εἰπὼν ⸀ἔδειξεντὰς χεῖρας καὶ τὴν πλευρὰν ⸀αὐτοῖς ἐχάρησαν οὖν οἱ μαθηταὶ ἰδόντες τὸν κύριον. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","εἶπεν οὖν αὐτοῖς ⸂ὁ Ἰησοῦς πάλιν· Εἰρήνη ὑμῖν· καθὼς ἀπέσταλκέν με ὁ πατήρ, κἀγὼ πέμπω ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","καὶ τοῦτο εἰπὼν ἐνεφύσησεν καὶ λέγει αὐτοῖς· Λάβετε πνεῦμα ἅγιον· ");
INSERT INTO grcsbl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ἄν τινων ἀφῆτε τὰς ἁμαρτίας ⸀ἀφέωνταιαὐτοῖς· ἄν τινων κρατῆτε κεκράτηνται. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Θωμᾶς δὲ εἷς ἐκ τῶν δώδεκα, ὁ λεγόμενος Δίδυμος, οὐκ ἦν μετʼ αὐτῶν ὅτε ⸀ἦλθενἸησοῦς. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ἔλεγον οὖν αὐτῷ οἱ ἄλλοι μαθηταί· Ἑωράκαμεν τὸν κύριον. ὁ δὲ εἶπεν αὐτοῖς· Ἐὰν μὴ ἴδω ἐν ταῖς χερσὶν αὐτοῦ τὸν τύπον τῶν ἥλων καὶ βάλω τὸν δάκτυλόν μου εἰς τὸν τύπον τῶν ἥλων καὶ βάλω ⸂μου τὴν χεῖρα εἰς τὴν πλευρὰν αὐτοῦ, οὐ μὴ πιστεύσω. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Καὶ μεθʼ ἡμέρας ὀκτὼ πάλιν ἦσαν ἔσω οἱ μαθηταὶ αὐτοῦ καὶ Θωμᾶς μετʼ αὐτῶν. ἔρχεται ὁ Ἰησοῦς τῶν θυρῶν κεκλεισμένων, καὶ ἔστη εἰς τὸ μέσον καὶ εἶπεν· Εἰρήνη ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","εἶτα λέγει τῷ Θωμᾷ· Φέρε τὸν δάκτυλόν σου ὧδε καὶ ἴδε τὰς χεῖράς μου, καὶ φέρε τὴν χεῖρά σου καὶ βάλε εἰς τὴν πλευράν μου, καὶ μὴ γίνου ἄπιστος ἀλλὰ πιστός. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","⸀ἀπεκρίθηΘωμᾶς καὶ εἶπεν αὐτῷ· Ὁ κύριός μου καὶ ὁ θεός μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","λέγει αὐτῷ ὁ Ἰησοῦς· Ὅτι ἑώρακάς με πεπίστευκας; μακάριοι οἱ μὴ ἰδόντες καὶ πιστεύσαντες. ");
INSERT INTO grcsbl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Πολλὰ μὲν οὖν καὶ ἄλλα σημεῖα ἐποίησεν ὁ Ἰησοῦς ἐνώπιον τῶν ⸀μαθητῶν ἃ οὐκ ἔστιν γεγραμμένα ἐν τῷ βιβλίῳ τούτῳ· ");
INSERT INTO grcsbl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ταῦτα δὲ γέγραπται ἵνα ⸀πιστεύητεὅτι Ἰησοῦς ἐστιν ὁ χριστὸς ὁ υἱὸς τοῦ θεοῦ, καὶ ἵνα πιστεύοντες ζωὴν ἔχητε ἐν τῷ ὀνόματι αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Μετὰ ταῦτα ἐφανέρωσεν ἑαυτὸν πάλιν ⸀ὁἸησοῦς τοῖς μαθηταῖς ἐπὶ τῆς θαλάσσης τῆς Τιβεριάδος· ἐφανέρωσεν δὲ οὕτως. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ἦσαν ὁμοῦ Σίμων Πέτρος καὶ Θωμᾶς ὁ λεγόμενος Δίδυμος καὶ Ναθαναὴλ ὁ ἀπὸ Κανὰ τῆς Γαλιλαίας καὶ οἱ τοῦ Ζεβεδαίου καὶ ἄλλοι ἐκ τῶν μαθητῶν αὐτοῦ δύο. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","λέγει αὐτοῖς Σίμων Πέτρος· Ὑπάγω ἁλιεύειν· λέγουσιν αὐτῷ· Ἐρχόμεθα καὶ ἡμεῖς σὺν σοί. ἐξῆλθον καὶ ἐνέβησαν εἰς τὸ ⸀πλοῖον καὶ ἐν ἐκείνῃ τῇ νυκτὶ ἐπίασαν οὐδέν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Πρωΐας δὲ ἤδη ⸀γενομένης⸀ἔστηἸησοῦς εἰς τὸν αἰγιαλόν· οὐ μέντοι ᾔδεισαν οἱ μαθηταὶ ὅτι Ἰησοῦς ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","λέγει οὖν αὐτοῖς ⸀ὁἸησοῦς· Παιδία, μή τι προσφάγιον ἔχετε; ἀπεκρίθησαν αὐτῷ· Οὔ. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ὁ δὲ εἶπεν αὐτοῖς· Βάλετε εἰς τὰ δεξιὰ μέρη τοῦ πλοίου τὸ δίκτυον, καὶ εὑρήσετε. ἔβαλον οὖν, καὶ οὐκέτι αὐτὸ ἑλκύσαι ⸀ἴσχυονἀπὸ τοῦ πλήθους τῶν ἰχθύων. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","λέγει οὖν ὁ μαθητὴς ἐκεῖνος ὃν ἠγάπα ὁ Ἰησοῦς τῷ Πέτρῳ· Ὁ κύριός ἐστιν. Σίμων οὖν Πέτρος, ἀκούσας ὅτι ὁ κύριός ἐστιν, τὸν ἐπενδύτην διεζώσατο, ἦν γὰρ γυμνός, καὶ ἔβαλεν ἑαυτὸν εἰς τὴν θάλασσαν· ");
INSERT INTO grcsbl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","οἱ δὲ ἄλλοι μαθηταὶ τῷ πλοιαρίῳ ἦλθον, οὐ γὰρ ἦσαν μακρὰν ἀπὸ τῆς γῆς ἀλλὰ ὡς ἀπὸ πηχῶν διακοσίων, σύροντες τὸ δίκτυον τῶν ἰχθύων. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ὡς οὖν ἀπέβησαν εἰς τὴν γῆν βλέπουσιν ἀνθρακιὰν κειμένην καὶ ὀψάριον ἐπικείμενον καὶ ἄρτον. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","λέγει αὐτοῖς ὁ Ἰησοῦς· Ἐνέγκατε ἀπὸ τῶν ὀψαρίων ὧν ἐπιάσατε νῦν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ἀνέβη ⸀οὖνΣίμων Πέτρος καὶ εἵλκυσεν τὸ δίκτυον ⸂εἰς τὴν γῆν μεστὸν ἰχθύων μεγάλων ἑκατὸν πεντήκοντα τριῶν· καὶ τοσούτων ὄντων οὐκ ἐσχίσθη τὸ δίκτυον. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","λέγει αὐτοῖς ὁ Ἰησοῦς· Δεῦτε ἀριστήσατε. οὐδεὶς ⸀δὲἐτόλμα τῶν μαθητῶν ἐξετάσαι αὐτόν· Σὺ τίς εἶ; εἰδότες ὅτι ὁ κύριός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","⸀ἔρχεται⸀ὁἸησοῦς καὶ λαμβάνει τὸν ἄρτον καὶ δίδωσιν αὐτοῖς, καὶ τὸ ὀψάριον ὁμοίως. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","τοῦτο ἤδη τρίτον ἐφανερώθη ⸀ὁἸησοῦς τοῖς ⸀μαθηταῖςἐγερθεὶς ἐκ νεκρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ὅτε οὖν ἠρίστησαν λέγει τῷ Σίμωνι Πέτρῳ ὁ Ἰησοῦς· Σίμων ⸀Ἰωάννου ἀγαπᾷς με πλέον τούτων; λέγει αὐτῷ· Ναί, κύριε, σὺ οἶδας ὅτι φιλῶ σε. λέγει αὐτῷ· Βόσκε τὰ ἀρνία μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","λέγει αὐτῷ πάλιν δεύτερον· Σίμων ⸀Ἰωάννου ἀγαπᾷς με; λέγει αὐτῷ· Ναί, κύριε, σὺ οἶδας ὅτι φιλῶ σε. λέγει αὐτῷ· Ποίμαινε τὰ πρόβατά μου. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","λέγει αὐτῷ τὸ τρίτον· Σίμων ⸀Ἰωάννου φιλεῖς με; ἐλυπήθη ὁ Πέτρος ὅτι εἶπεναὐτῷ τὸ τρίτον· Φιλεῖς με; καὶ ⸀εἶπεν αὐτῷ· Κύριε, ⸂πάντα σὺ οἶδας, σὺ γινώσκεις ὅτι φιλῶ σε. λέγει αὐτῷ ⸀ὁἸησοῦς· Βόσκε τὰ ⸀πρόβατάμου. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ἀμὴν ἀμὴν λέγω σοι, ὅτε ἦς νεώτερος, ἐζώννυες σεαυτὸν καὶ περιεπάτεις ὅπου ἤθελες· ὅταν δὲ γηράσῃς, ἐκτενεῖς τὰς χεῖράς σου, καὶ ἄλλος ⸂σε ζώσει καὶ οἴσει ὅπου οὐ θέλεις. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","τοῦτο δὲ εἶπεν σημαίνων ποίῳ θανάτῳ δοξάσει τὸν θεόν. καὶ τοῦτο εἰπὼν λέγει αὐτῷ· Ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","⸀Ἐπιστραφεὶςὁ Πέτρος βλέπει τὸν μαθητὴν ὃν ἠγάπα ὁ Ἰησοῦς ἀκολουθοῦντα, ὃς καὶ ἀνέπεσεν ἐν τῷ δείπνῳ ἐπὶ τὸ στῆθος αὐτοῦ καὶ εἶπεν· Κύριε, τίς ἐστιν ὁ παραδιδούς σε; ");
INSERT INTO grcsbl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","τοῦτον ⸀οὖνἰδὼν ὁ Πέτρος λέγει τῷ Ἰησοῦ· Κύριε, οὗτος δὲ τί; ");
INSERT INTO grcsbl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","λέγει αὐτῷ ὁ Ἰησοῦς· Ἐὰν αὐτὸν θέλω μένειν ἕως ἔρχομαι, τί πρὸς σέ; σύ ⸂μοι ἀκολούθει. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ἐξῆλθεν οὖν ⸂οὗτος ὁ λόγος εἰς τοὺς ἀδελφοὺς ὅτι ὁ μαθητὴς ἐκεῖνος οὐκ ἀποθνῄσκει. ⸂οὐκ εἶπεν δὲ αὐτῷ ὁ Ἰησοῦς ὅτι οὐκ ἀποθνῄσκει ἀλλʼ· Ἐὰν αὐτὸν θέλω μένειν ἕως ἔρχομαι, τί πρὸς σέ; ");
INSERT INTO grcsbl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Οὗτός ἐστιν ὁ μαθητὴς ὁ μαρτυρῶν περὶ τούτων καὶ ⸀ὁ γράψας ταῦτα, καὶ οἴδαμεν ὅτι ἀληθὴς ⸂αὐτοῦ ἡ μαρτυρία ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ἔστιν δὲ καὶ ἄλλα πολλὰ ⸀ἃἐποίησεν ὁ Ἰησοῦς, ἅτινα ἐὰν γράφηται καθʼ ἕν, οὐδʼ αὐτὸν οἶμαι τὸν κόσμον ⸀χωρήσειντὰ γραφόμενα ⸀βιβλία ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Τὸν μὲν πρῶτον λόγον ἐποιησάμην περὶ πάντων, ὦ Θεόφιλε, ὧν ἤρξατο ⸀ὁἸησοῦς ποιεῖν τε καὶ διδάσκειν ");
INSERT INTO grcsbl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ἄχρι ἧς ἡμέρας ἐντειλάμενος τοῖς ἀποστόλοις διὰ πνεύματος ἁγίου οὓς ἐξελέξατο ἀνελήμφθη· ");
INSERT INTO grcsbl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","οἷς καὶ παρέστησεν ἑαυτὸν ζῶντα μετὰ τὸ παθεῖν αὐτὸν ἐν πολλοῖς τεκμηρίοις, διʼ ἡμερῶν τεσσεράκοντα ὀπτανόμενος αὐτοῖς καὶ λέγων τὰ περὶ τῆς βασιλείας τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","καὶ συναλιζόμενος παρήγγειλεν αὐτοῖς ἀπὸ Ἱεροσολύμων μὴ χωρίζεσθαι, ἀλλὰ περιμένειν τὴν ἐπαγγελίαν τοῦ πατρὸς ἣν ἠκούσατέ μου· ");
INSERT INTO grcsbl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ὅτι Ἰωάννης μὲν ἐβάπτισεν ὕδατι, ὑμεῖς δὲ ⸂ἐν πνεύματι βαπτισθήσεσθε ἁγίῳ οὐ μετὰ πολλὰς ταύτας ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Οἱ μὲν οὖν συνελθόντες ⸀ἠρώτωναὐτὸν λέγοντες· Κύριε, εἰ ἐν τῷ χρόνῳ τούτῳ ἀποκαθιστάνεις τὴν βασιλείαν τῷ Ἰσραήλ; ");
INSERT INTO grcsbl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","εἶπεν ⸀δὲπρὸς αὐτούς· Οὐχ ὑμῶν ἐστιν γνῶναι χρόνους ἢ καιροὺς οὓς ὁ πατὴρ ἔθετο ἐν τῇ ἰδίᾳ ἐξουσίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ἀλλὰ λήμψεσθε δύναμιν ἐπελθόντος τοῦ ἁγίου πνεύματος ἐφʼ ὑμᾶς, καὶ ἔσεσθέ ⸀μουμάρτυρες ἔν τε Ἰερουσαλὴμ καὶ ἐν πάσῃ τῇ Ἰουδαίᾳ καὶ Σαμαρείᾳ καὶ ἕως ἐσχάτου τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","καὶ ταῦτα εἰπὼν βλεπόντων αὐτῶν ἐπήρθη καὶ νεφέλη ὑπέλαβεν αὐτὸν ἀπὸ τῶν ὀφθαλμῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","καὶ ὡς ἀτενίζοντες ἦσαν εἰς τὸν οὐρανὸν πορευομένου αὐτοῦ, καὶ ἰδοὺ ἄνδρες δύο παρειστήκεισαν αὐτοῖς ἐν ⸂ἐσθήσεσι λευκαῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","οἳ καὶ εἶπαν· Ἄνδρες Γαλιλαῖοι, τί ἑστήκατε ⸀βλέποντεςεἰς τὸν οὐρανόν; οὗτος ὁ Ἰησοῦς ὁ ἀναλημφθεὶς ἀφʼ ὑμῶν εἰς τὸν οὐρανὸν οὕτως ἐλεύσεται ὃν τρόπον ἐθεάσασθε αὐτὸν πορευόμενον εἰς τὸν οὐρανόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Τότε ὑπέστρεψαν εἰς Ἰερουσαλὴμ ἀπὸ ὄρους τοῦ καλουμένου Ἐλαιῶνος, ὅ ἐστιν ἐγγὺς Ἰερουσαλὴμ σαββάτου ἔχον ὁδόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","καὶ ὅτε εἰσῆλθον, ⸂εἰς τὸ ὑπερῷον ἀνέβησαν οὗ ἦσαν καταμένοντες, ὅ τε Πέτρος καὶ ⸂Ἰωάννης καὶ Ἰάκωβος καὶ Ἀνδρέας, Φίλιππος καὶ Θωμᾶς, Βαρθολομαῖος καὶ Μαθθαῖος, Ἰάκωβος Ἁλφαίου καὶ Σίμων ὁ ζηλωτὴς καὶ Ἰούδας Ἰακώβου. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","οὗτοι πάντες ἦσαν προσκαρτεροῦντες ὁμοθυμαδὸν τῇ ⸀προσευχῇσὺν γυναιξὶν καὶ ⸀Μαριὰμτῇ μητρὶ τοῦ Ἰησοῦ καὶ ⸀σὺντοῖς ἀδελφοῖς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Καὶ ἐν ταῖς ἡμέραις ταύταις ἀναστὰς Πέτρος ἐν μέσῳ τῶν ⸀ἀδελφῶνεἶπεν (ἦν τε ὄχλος ὀνομάτων ἐπὶ τὸ αὐτὸ ⸀ὡςἑκατὸν εἴκοσι)· ");
INSERT INTO grcsbl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ἄνδρες ἀδελφοί, ἔδει πληρωθῆναι τὴν ⸀γραφὴνἣν προεῖπε τὸ πνεῦμα τὸ ἅγιον διὰ στόματος Δαυὶδ περὶ Ἰούδα τοῦ γενομένου ὁδηγοῦ τοῖς συλλαβοῦσιν ⸀Ἰησοῦν ");
INSERT INTO grcsbl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ὅτι κατηριθμημένος ἦν ⸀ἐνἡμῖν καὶ ἔλαχεν τὸν κλῆρον τῆς διακονίας ταύτης.— ");
INSERT INTO grcsbl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Οὗτος μὲν οὖν ἐκτήσατο χωρίον ἐκ μισθοῦ τῆς ἀδικίας, καὶ πρηνὴς γενόμενος ἐλάκησεν μέσος, καὶ ἐξεχύθη πάντα τὰ σπλάγχνα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","καὶ γνωστὸν ἐγένετο πᾶσι τοῖς κατοικοῦσιν Ἰερουσαλήμ, ὥστε κληθῆναι τὸ χωρίον ἐκεῖνο τῇ ⸀ἰδίᾳδιαλέκτῳ αὐτῶν Ἁκελδαμάχ, τοῦτʼ ἔστιν Χωρίον Αἵματος.— ");
INSERT INTO grcsbl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","γέγραπται γὰρ ἐν βίβλῳ ψαλμῶν· Γενηθήτω ἡ ἔπαυλις αὐτοῦ ἔρημος καὶ μὴ ἔστω ὁ κατοικῶν ἐν αὐτῇ, καί· Τὴν ἐπισκοπὴν αὐτοῦ ⸀λαβέτωἕτερος. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","δεῖ οὖν τῶν συνελθόντων ἡμῖν ἀνδρῶν ἐν παντὶ χρόνῳ ⸀ᾧεἰσῆλθεν καὶ ἐξῆλθεν ἐφʼ ἡμᾶς ὁ κύριος Ἰησοῦς, ");
INSERT INTO grcsbl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ἀρξάμενος ἀπὸ τοῦ βαπτίσματος Ἰωάννου ἕως τῆς ἡμέρας ἧς ἀνελήμφθη ἀφʼ ἡμῶν, μάρτυρα τῆς ἀναστάσεως αὐτοῦ ⸂σὺν ἡμῖν γενέσθαι ἕνα τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","καὶ ἔστησαν δύο, Ἰωσὴφ τὸν καλούμενον Βαρσαββᾶν, ὃς ἐπεκλήθη Ἰοῦστος, καὶ Μαθθίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","καὶ προσευξάμενοι εἶπαν Σὺ κύριε καρδιογνῶστα πάντων, ἀνάδειξον ὃν ἐξελέξω, ἐκ τούτων τῶν δύο ἕνα, ");
INSERT INTO grcsbl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","λαβεῖν τὸν ⸀τόποντῆς διακονίας ταύτης καὶ ἀποστολῆς, ⸀ἀφʼἧς παρέβη Ἰούδας πορευθῆναι εἰς τὸν τόπον τὸν ἴδιον. ");
INSERT INTO grcsbl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","καὶ ἔδωκαν κλήρους ⸀αὐτοῖς καὶ ἔπεσεν ὁ κλῆρος ἐπὶ Μαθθίαν, καὶ συγκατεψηφίσθη μετὰ τῶν ἕνδεκα ἀποστόλων. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Καὶ ἐν τῷ συμπληροῦσθαι τὴν ἡμέραν τῆς πεντηκοστῆς ἦσαν ⸂πάντες ὁμοῦ ἐπὶ τὸ αὐτό, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","καὶ ἐγένετο ἄφνω ἐκ τοῦ οὐρανοῦ ἦχος ὥσπερ φερομένης πνοῆς βιαίας καὶ ἐπλήρωσεν ὅλον τὸν οἶκον οὗ ἦσαν καθήμενοι, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","καὶ ὤφθησαν αὐτοῖς διαμεριζόμεναι γλῶσσαι ὡσεὶ πυρός, ⸂καὶ ἐκάθισεν ἐφʼ ἕνα ἕκαστον αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","καὶ ἐπλήσθησαν ⸀πάντεςπνεύματος ἁγίου, καὶ ἤρξαντο λαλεῖν ἑτέραις γλώσσαις καθὼς τὸ πνεῦμα ἐδίδου ⸂ἀποφθέγγεσθαι αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ἦσαν δὲ ⸀ἐνἸερουσαλὴμ κατοικοῦντες Ἰουδαῖοι, ἄνδρες εὐλαβεῖς ἀπὸ παντὸς ἔθνους τῶν ὑπὸ τὸν οὐρανόν· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","γενομένης δὲ τῆς φωνῆς ταύτης συνῆλθε τὸ πλῆθος καὶ συνεχύθη, ὅτι ⸀ἤκουονεἷς ἕκαστος τῇ ἰδίᾳ διαλέκτῳ λαλούντων αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ἐξίσταντο ⸀δὲκαὶ ἐθαύμαζον ⸀λέγοντες ⸀Οὐχἰδοὺ ⸀πάντεςοὗτοί εἰσιν οἱ λαλοῦντες Γαλιλαῖοι; ");
INSERT INTO grcsbl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","καὶ πῶς ἡμεῖς ἀκούομεν ἕκαστος τῇ ἰδίᾳ διαλέκτῳ ἡμῶν ἐν ᾗ ἐγεννήθημεν; ");
INSERT INTO grcsbl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Πάρθοι καὶ Μῆδοι καὶ Ἐλαμῖται, καὶ οἱ κατοικοῦντες τὴν Μεσοποταμίαν, Ἰουδαίαν τε καὶ Καππαδοκίαν, Πόντον καὶ τὴν Ἀσίαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Φρυγίαν τε καὶ Παμφυλίαν, Αἴγυπτον καὶ τὰ μέρη τῆς Λιβύης τῆς κατὰ Κυρήνην, καὶ οἱ ἐπιδημοῦντες Ῥωμαῖοι, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ἰουδαῖοί τε καὶ προσήλυτοι, Κρῆτες καὶ Ἄραβες, ἀκούομεν λαλούντων αὐτῶν ταῖς ἡμετέραις γλώσσαις τὰ μεγαλεῖα τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ἐξίσταντο δὲ πάντες καὶ ⸀διηπόρουν ἄλλος πρὸς ἄλλον λέγοντες· Τί ⸀θέλειτοῦτο εἶναι; ");
INSERT INTO grcsbl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ἕτεροι δὲ ⸀διαχλευάζοντεςἔλεγον ὅτι Γλεύκους μεμεστωμένοι εἰσίν. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Σταθεὶς δὲ ⸀ὁΠέτρος σὺν τοῖς ἕνδεκα ἐπῆρεν τὴν φωνὴν αὐτοῦ καὶ ἀπεφθέγξατο αὐτοῖς· Ἄνδρες Ἰουδαῖοι καὶ οἱ κατοικοῦντες Ἰερουσαλὴμ ⸀πάντες τοῦτο ὑμῖν γνωστὸν ἔστω καὶ ἐνωτίσασθε τὰ ῥήματά μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","οὐ γὰρ ὡς ὑμεῖς ὑπολαμβάνετε οὗτοι μεθύουσιν, ἔστιν γὰρ ὥρα τρίτη τῆς ἡμέρας, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ἀλλὰ τοῦτό ἐστιν τὸ εἰρημένον διὰ τοῦ προφήτου Ἰωήλ· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Καὶ ἔσται ἐν ταῖς ἐσχάταις ἡμέραις, λέγει ὁ θεός, ἐκχεῶ ἀπὸ τοῦ πνεύματός μου ἐπὶ πᾶσαν σάρκα, καὶ προφητεύσουσιν οἱ υἱοὶ ὑμῶν καὶ αἱ θυγατέρες ὑμῶν, καὶ οἱ νεανίσκοι ὑμῶν ὁράσεις ὄψονται, καὶ οἱ πρεσβύτεροι ὑμῶν ⸀ἐνυπνίοιςἐνυπνιασθήσονται· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","καί γε ἐπὶ τοὺς δούλους μου καὶ ἐπὶ τὰς δούλας μου ἐν ταῖς ἡμέραις ἐκείναις ἐκχεῶ ἀπὸ τοῦ πνεύματός μου, καὶ προφητεύσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","καὶ δώσω τέρατα ἐν τῷ οὐρανῷ ἄνω καὶ σημεῖα ἐπὶ τῆς γῆς κάτω, αἷμα καὶ πῦρ καὶ ἀτμίδα καπνοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ὁ ἥλιος μεταστραφήσεται εἰς σκότος καὶ ἡ σελήνη εἰς αἷμα πρὶν ⸀ἢ⸀ἐλθεῖνἡμέραν κυρίου τὴν μεγάλην καὶ ἐπιφανῆ. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","καὶ ἔσται πᾶς ὃς ⸀ἐὰνἐπικαλέσηται τὸ ὄνομα κυρίου σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ἄνδρες Ἰσραηλῖται, ἀκούσατε τοὺς λόγους τούτους. Ἰησοῦν τὸν Ναζωραῖον, ἄνδρα ⸂ἀποδεδειγμένον ἀπὸ τοῦ θεοῦ εἰς ὑμᾶς δυνάμεσι καὶ τέρασι καὶ σημείοις οἷς ἐποίησεν διʼ αὐτοῦ ὁ θεὸς ἐν μέσῳ ὑμῶν, ⸀καθὼςαὐτοὶ οἴδατε, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","τοῦτον τῇ ὡρισμένῃ βουλῇ καὶ προγνώσει τοῦ θεοῦ ⸀ἔκδοτονδιὰ ⸀χειρὸςἀνόμων προσπήξαντες ἀνείλατε, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ὃν ὁ θεὸς ἀνέστησεν λύσας τὰς ὠδῖνας τοῦ θανάτου, καθότι οὐκ ἦν δυνατὸν κρατεῖσθαι αὐτὸν ὑπʼ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Δαυὶδ γὰρ λέγει εἰς αὐτόν· Προορώμην τὸν κύριον ἐνώπιόν μου διὰ παντός, ὅτι ἐκ δεξιῶν μού ἐστιν ἵνα μὴ σαλευθῶ. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","διὰ τοῦτο ηὐφράνθη ⸂ἡ καρδία μου καὶ ἠγαλλιάσατο ἡ γλῶσσά μου, ἔτι δὲ καὶ ἡ σάρξ μου κατασκηνώσει ἐπʼ ἐλπίδι· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ὅτι οὐκ ἐγκαταλείψεις τὴν ψυχήν μου εἰς ⸀ᾅδην οὐδὲ δώσεις τὸν ὅσιόν σου ἰδεῖν διαφθοράν. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ἐγνώρισάς μοι ὁδοὺς ζωῆς, πληρώσεις με εὐφροσύνης μετὰ τοῦ προσώπου σου. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ἄνδρες ἀδελφοί, ἐξὸν εἰπεῖν μετὰ παρρησίας πρὸς ὑμᾶς περὶ τοῦ πατριάρχου Δαυίδ, ὅτι καὶ ἐτελεύτησεν καὶ ἐτάφη, καὶ τὸ μνῆμα αὐτοῦ ἔστιν ἐν ἡμῖν ἄχρι τῆς ἡμέρας ταύτης· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","προφήτης οὖν ὑπάρχων, καὶ εἰδὼς ὅτι ὅρκῳ ὤμοσεν αὐτῷ ὁ θεὸς ἐκ καρποῦ τῆς ὀσφύος ⸀αὐτοῦκαθίσαι ἐπὶ ⸂τὸν θρόνον αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","προϊδὼν ἐλάλησεν περὶ τῆς ἀναστάσεως τοῦ χριστοῦ ὅτι ⸂οὔτε ἐγκατελείφθη εἰς ⸀ᾅδην⸀οὔτεἡ σὰρξ αὐτοῦ εἶδεν διαφθοράν. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","τοῦτον τὸν Ἰησοῦν ἀνέστησεν ὁ θεός, οὗ πάντες ἡμεῖς ἐσμεν μάρτυρες. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","τῇ δεξιᾷ οὖν τοῦ θεοῦ ὑψωθεὶς τήν τε ἐπαγγελίαν τοῦ ⸂πνεύματος τοῦ ἁγίου λαβὼν παρὰ τοῦ πατρὸς ἐξέχεεν τοῦτο ⸀ὃ⸀ὑμεῖςβλέπετε καὶ ἀκούετε. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","οὐ γὰρ Δαυὶδ ἀνέβη εἰς τοὺς οὐρανούς, λέγει δὲ αὐτός· Εἶπεν ⸀ὁκύριος τῷ κυρίῳ μου· Κάθου ἐκ δεξιῶν μου, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ἕως ἂν θῶ τοὺς ἐχθρούς σου ὑποπόδιον τῶν ποδῶν σου. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ἀσφαλῶς οὖν γινωσκέτω πᾶς οἶκος Ἰσραὴλ ὅτι καὶ κύριον ⸂αὐτὸν καὶ χριστὸν ⸂ἐποίησεν ὁ θεός, τοῦτον τὸν Ἰησοῦν ὃν ὑμεῖς ἐσταυρώσατε. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ἀκούσαντες δὲ κατενύγησαν ⸂τὴν καρδίαν, εἶπόν τε πρὸς τὸν Πέτρον καὶ τοὺς λοιποὺς ἀποστόλους· Τί ⸀ποιήσωμεν ἄνδρες ἀδελφοί; ");
INSERT INTO grcsbl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Πέτρος δὲ ⸂πρὸς αὐτούς· Μετανοήσατε, καὶ βαπτισθήτω ἕκαστος ὑμῶν ⸀ἐπὶτῷ ὀνόματι Ἰησοῦ Χριστοῦ εἰς ἄφεσιν ⸀τῶνἁμαρτιῶν ⸀ὑμῶν καὶ λήμψεσθε τὴν δωρεὰν τοῦ ἁγίου πνεύματος· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ὑμῖν γάρ ἐστιν ἡ ἐπαγγελία καὶ τοῖς τέκνοις ὑμῶν καὶ πᾶσι τοῖς εἰς μακρὰν ὅσους ἂν προσκαλέσηται κύριος ὁ θεὸς ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ἑτέροις τε λόγοις πλείοσιν διεμαρτύρατο, καὶ παρεκάλει ⸀αὐτοὺςλέγων· Σώθητε ἀπὸ τῆς γενεᾶς τῆς σκολιᾶς ταύτης. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","οἱ μὲν ⸀οὖνἀποδεξάμενοι τὸν λόγον αὐτοῦ ἐβαπτίσθησαν, καὶ προσετέθησαν ⸀ἐντῇ ἡμέρᾳ ἐκείνῃ ψυχαὶ ὡσεὶ τρισχίλιαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ἦσαν δὲ προσκαρτεροῦντες τῇ διδαχῇ τῶν ἀποστόλων καὶ τῇ ⸀κοινωνίᾳ τῇ κλάσει τοῦ ἄρτου καὶ ταῖς προσευχαῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","⸀Ἐγίνετοδὲ πάσῃ ψυχῇ φόβος, πολλά ⸀τετέρατα καὶ σημεῖα διὰ τῶν ἀποστόλων ἐγίνετο. ");
INSERT INTO grcsbl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","πάντες δὲ οἱ ⸀πιστεύοντες⸂ἦσαν ἐπὶ τὸ αὐτὸ καὶ εἶχον ἅπαντα κοινά, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","καὶ τὰ κτήματα καὶ τὰς ὑπάρξεις ἐπίπρασκον καὶ διεμέριζον αὐτὰ πᾶσιν καθότι ἄν τις χρείαν εἶχεν· ");
INSERT INTO grcsbl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","καθʼ ἡμέραν τε προσκαρτεροῦντες ὁμοθυμαδὸν ἐν τῷ ἱερῷ, κλῶντές τε κατʼ οἶκον ἄρτον, μετελάμβανον τροφῆς ἐν ἀγαλλιάσει καὶ ἀφελότητι καρδίας, ");
INSERT INTO grcsbl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","αἰνοῦντες τὸν θεὸν καὶ ἔχοντες χάριν πρὸς ὅλον τὸν λαόν. ὁ δὲ κύριος προσετίθει τοὺς σῳζομένους καθʼ ἡμέραν ⸂ἐπὶ τὸ αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","⸂Πέτρος δὲ καὶ Ἰωάννης ἀνέβαινον εἰς τὸ ἱερὸν ἐπὶ τὴν ὥραν τῆς προσευχῆς τὴν ἐνάτην, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","καί τις ἀνὴρ χωλὸς ἐκ κοιλίας μητρὸς αὐτοῦ ὑπάρχων ἐβαστάζετο, ὃν ἐτίθουν καθʼ ἡμέραν πρὸς τὴν θύραν τοῦ ἱεροῦ τὴν λεγομένην Ὡραίαν τοῦ αἰτεῖν ἐλεημοσύνην παρὰ τῶν εἰσπορευομένων εἰς τὸ ἱερόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ὃς ἰδὼν Πέτρον καὶ Ἰωάννην μέλλοντας εἰσιέναι εἰς τὸ ἱερὸν ἠρώτα ἐλεημοσύνην ⸀λαβεῖν ");
INSERT INTO grcsbl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ἀτενίσας δὲ Πέτρος εἰς αὐτὸν σὺν τῷ Ἰωάννῃ εἶπεν· Βλέψον εἰς ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ὁ δὲ ἐπεῖχεν αὐτοῖς προσδοκῶν τι παρʼ αὐτῶν λαβεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","εἶπεν δὲ Πέτρος· Ἀργύριον καὶ χρυσίον οὐχ ὑπάρχει μοι, ὃ δὲ ἔχω τοῦτό σοι δίδωμι· ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ τοῦ Ναζωραίου ⸀περιπάτει ");
INSERT INTO grcsbl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","καὶ πιάσας αὐτὸν τῆς δεξιᾶς χειρὸς ἤγειρεν ⸀αὐτόν παραχρῆμα δὲ ἐστερεώθησαν ⸂αἱ βάσεις αὐτοῦ καὶ τὰ ⸀σφυδρά ");
INSERT INTO grcsbl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","καὶ ἐξαλλόμενος ἔστη καὶ περιεπάτει, καὶ εἰσῆλθεν σὺν αὐτοῖς εἰς τὸ ἱερὸν περιπατῶν καὶ ἁλλόμενος καὶ αἰνῶν τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","καὶ εἶδεν ⸂πᾶς ὁ λαὸς αὐτὸν περιπατοῦντα καὶ αἰνοῦντα τὸν θεόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ἐπεγίνωσκον ⸀δὲαὐτὸν ὅτι ⸀οὗτοςἦν ὁ πρὸς τὴν ἐλεημοσύνην καθήμενος ἐπὶ τῇ Ὡραίᾳ Πύλῃ τοῦ ἱεροῦ, καὶ ἐπλήσθησαν θάμβους καὶ ἐκστάσεως ἐπὶ τῷ συμβεβηκότι αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Κρατοῦντος δὲ ⸀αὐτοῦτὸνΠέτρον καὶ ⸀τὸν Ἰωάννην συνέδραμεν ⸂πᾶς ὁ λαὸς πρὸς αὐτοὺς ἐπὶ τῇ στοᾷ τῇ καλουμένῃ Σολομῶντος ἔκθαμβοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ἰδὼν δὲ ⸀ὁΠέτρος ἀπεκρίνατο πρὸς τὸν λαόν· Ἄνδρες Ἰσραηλῖται, τί θαυμάζετε ἐπὶ τούτῳ, ἢ ἡμῖν τί ἀτενίζετε ὡς ἰδίᾳ δυνάμει ἢ εὐσεβείᾳ πεποιηκόσιν τοῦ περιπατεῖν αὐτόν; ");
INSERT INTO grcsbl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ὁ θεὸς Ἀβραὰμ καὶ ⸂Ἰσαὰκ καὶ Ἰακώβ, ὁ θεὸς τῶν πατέρων ἡμῶν, ἐδόξασεν τὸν παῖδα αὐτοῦ Ἰησοῦν, ὃν ὑμεῖς ⸀μὲνπαρεδώκατε καὶ ⸀ἠρνήσασθεκατὰ πρόσωπον Πιλάτου, κρίναντος ἐκείνου ἀπολύειν· ");
INSERT INTO grcsbl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ὑμεῖς δὲ τὸν ἅγιον καὶ δίκαιον ἠρνήσασθε καὶ ᾐτήσασθε ἄνδρα φονέα χαρισθῆναι ὑμῖν, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","τὸν δὲ ἀρχηγὸν τῆς ζωῆς ἀπεκτείνατε, ὃν ὁ θεὸς ἤγειρεν ἐκ νεκρῶν, οὗ ἡμεῖς μάρτυρές ἐσμεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","καὶ ⸀ἐπὶτῇ πίστει τοῦ ὀνόματος αὐτοῦ τοῦτον ὃν θεωρεῖτε καὶ οἴδατε ἐστερέωσεν τὸ ὄνομα αὐτοῦ, καὶ ἡ πίστις ἡ διʼ αὐτοῦ ἔδωκεν αὐτῷ τὴν ὁλοκληρίαν ταύτην ἀπέναντι πάντων ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Καὶ νῦν, ἀδελφοί, οἶδα ὅτι κατὰ ἄγνοιαν ἐπράξατε, ὥσπερ καὶ οἱ ἄρχοντες ὑμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ὁ δὲ θεὸς ἃ προκατήγγειλεν διὰ στόματος πάντων τῶν ⸀προφητῶνπαθεῖν τὸν χριστὸν ⸀αὐτοῦἐπλήρωσεν οὕτως. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","μετανοήσατε οὖν καὶ ἐπιστρέψατε ⸀πρὸςτὸ ἐξαλειφθῆναι ὑμῶν τὰς ἁμαρτίας, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ὅπως ἂν ἔλθωσιν καιροὶ ἀναψύξεως ἀπὸ προσώπου τοῦ κυρίου καὶ ἀποστείλῃ τὸν προκεχειρισμένον ὑμῖν χριστὸν Ἰησοῦν, ");
INSERT INTO grcsbl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ὃν δεῖ οὐρανὸν μὲν δέξασθαι ἄχρι χρόνων ἀποκαταστάσεως πάντων ὧν ἐλάλησεν ὁ θεὸς διὰ ⸀στόματοςτῶν ἁγίων ⸂ἀπʼ αἰῶνος αὐτοῦ προφητῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Μωϋσῆς ⸀μὲνεἶπεν ὅτι Προφήτην ὑμῖν ἀναστήσει κύριος ὁ ⸀θεὸςἐκ τῶν ἀδελφῶν ὑμῶν ὡς ἐμέ· αὐτοῦ ἀκούσεσθε κατὰ πάντα ὅσα ἂν λαλήσῃ πρὸς ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ἔσται δὲ πᾶσα ψυχὴ ἥτις ⸀ἂνμὴ ἀκούσῃ τοῦ προφήτου ἐκείνου ἐξολεθρευθήσεται ἐκ τοῦ λαοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","καὶ πάντες δὲ οἱ προφῆται ἀπὸ Σαμουὴλ καὶ τῶν καθεξῆς ὅσοι ἐλάλησαν καὶ κατήγγειλαν τὰς ἡμέρας ταύτας. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ὑμεῖς ἐστε ⸀οἱυἱοὶ τῶν προφητῶν καὶ τῆς διαθήκης ἧς ⸂διέθετο ὁ θεὸς πρὸς τοὺς πατέρας ⸀ὑμῶν λέγων πρὸς Ἀβραάμ· Καὶ ἐν τῷ σπέρματί σου ⸀ἐνευλογηθήσονταιπᾶσαι αἱ πατριαὶ τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ὑμῖν πρῶτον ⸂ἀναστήσας ὁ θεὸς τὸν παῖδα ⸀αὐτοῦἀπέστειλεν αὐτὸν εὐλογοῦντα ὑμᾶς ἐν τῷ ἀποστρέφειν ἕκαστον ἀπὸ τῶν πονηριῶν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Λαλούντων δὲ αὐτῶν πρὸς τὸν λαὸν ἐπέστησαν αὐτοῖς οἱ ⸀ἱερεῖςκαὶ ὁ στρατηγὸς τοῦ ἱεροῦ καὶ οἱ Σαδδουκαῖοι, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","διαπονούμενοι διὰ τὸ διδάσκειν αὐτοὺς τὸν λαὸν καὶ καταγγέλλειν ἐν τῷ Ἰησοῦ τὴν ἀνάστασιν ⸂τὴν ἐκ νεκρῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","καὶ ἐπέβαλον αὐτοῖς τὰς χεῖρας καὶ ἔθεντο εἰς τήρησιν εἰς τὴν αὔριον, ἦν γὰρ ἑσπέρα ἤδη. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","πολλοὶ δὲ τῶν ἀκουσάντων τὸν λόγον ἐπίστευσαν, καὶ ἐγενήθη ⸀ὁἀριθμὸς τῶν ἀνδρῶν ⸀ὡςχιλιάδες πέντε. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ἐγένετο δὲ ἐπὶ τὴν αὔριον συναχθῆναι αὐτῶν τοὺς ἄρχοντας καὶ ⸀τοὺςπρεσβυτέρους καὶ ⸁τοὺςγραμματεῖς ⸀ἐνἸερουσαλήμ ");
INSERT INTO grcsbl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","(καὶ ⸂Ἅννας ὁ ἀρχιερεὺς καὶ Καϊάφας καὶ Ἰωάννης καὶ Ἀλέξανδρος καὶ ὅσοι ἦσαν ἐκ γένους ἀρχιερατικοῦ), ");
INSERT INTO grcsbl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","καὶ στήσαντες αὐτοὺς ἐν ⸀τῷμέσῳ ἐπυνθάνοντο· Ἐν ποίᾳ δυνάμει ἢ ἐν ποίῳ ὀνόματι ἐποιήσατε τοῦτο ὑμεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","τότε Πέτρος πλησθεὶς πνεύματος ἁγίου εἶπεν πρὸς αὐτούς· Ἄρχοντες τοῦ λαοῦ καὶ ⸀πρεσβύτεροι ");
INSERT INTO grcsbl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","εἰ ἡμεῖς σήμερον ἀνακρινόμεθα ἐπὶ εὐεργεσίᾳ ἀνθρώπου ἀσθενοῦς, ἐν τίνι οὗτος σέσωσται, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","γνωστὸν ἔστω πᾶσιν ὑμῖν καὶ παντὶ τῷ λαῷ Ἰσραὴλ ὅτι ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ τοῦ Ναζωραίου, ὃν ὑμεῖς ἐσταυρώσατε, ὃν ὁ θεὸς ἤγειρεν ἐκ νεκρῶν, ἐν τούτῳ οὗτος παρέστηκεν ἐνώπιον ὑμῶν ὑγιής. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","οὗτός ἐστιν ὁ λίθος ὁ ἐξουθενηθεὶς ὑφʼ ὑμῶν τῶν ⸀οἰκοδόμων ὁ γενόμενος εἰς κεφαλὴν γωνίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","καὶ οὐκ ἔστιν ἐν ἄλλῳ οὐδενὶ ἡ σωτηρία, ⸀οὐδὲγὰρ ὄνομά ἐστιν ἕτερον ⸂ὑπὸ τὸν οὐρανὸν τὸ δεδομένον ἐν ἀνθρώποις ἐν ᾧ δεῖ σωθῆναι ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Θεωροῦντες δὲ τὴν τοῦ Πέτρου παρρησίαν καὶ Ἰωάννου καὶ καταλαβόμενοι ὅτι ἄνθρωποι ἀγράμματοί εἰσιν καὶ ἰδιῶται, ἐθαύμαζον, ἐπεγίνωσκόν τε αὐτοὺς ὅτι σὺν τῷ Ἰησοῦ ἦσαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","τόν ⸀τεἄνθρωπον βλέποντες σὺν αὐτοῖς ἑστῶτα τὸν τεθεραπευμένον οὐδὲν εἶχον ἀντειπεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","κελεύσαντες δὲ αὐτοὺς ἔξω τοῦ συνεδρίου ἀπελθεῖν συνέβαλλον πρὸς ἀλλήλους ");
INSERT INTO grcsbl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","λέγοντες· Τί ⸀ποιήσωμεντοῖς ἀνθρώποις τούτοις; ὅτι μὲν γὰρ γνωστὸν σημεῖον γέγονεν διʼ αὐτῶν πᾶσιν τοῖς κατοικοῦσιν Ἰερουσαλὴμ φανερόν, καὶ οὐ δυνάμεθα ⸀ἀρνεῖσθαι ");
INSERT INTO grcsbl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ἀλλʼ ἵνα μὴ ἐπὶ πλεῖον διανεμηθῇ εἰς τὸν λαόν, ⸀ἀπειλησώμεθααὐτοῖς μηκέτι λαλεῖν ἐπὶ τῷ ὀνόματι τούτῳ μηδενὶ ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","καὶ καλέσαντες αὐτοὺς παρήγγειλαν ⸀τὸκαθόλου μὴ φθέγγεσθαι μηδὲ διδάσκειν ἐπὶ τῷ ὀνόματι τοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ὁ δὲ Πέτρος καὶ Ἰωάννης ἀποκριθέντες ⸂εἶπον πρὸς αὐτούς· Εἰ δίκαιόν ἐστιν ἐνώπιον τοῦ θεοῦ ὑμῶν ἀκούειν μᾶλλον ἢ τοῦ θεοῦ, κρίνατε, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","οὐ δυνάμεθα γὰρ ἡμεῖς ἃ εἴδαμεν καὶ ἠκούσαμεν μὴ λαλεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","οἱ δὲ προσαπειλησάμενοι ἀπέλυσαν αὐτούς, μηδὲν εὑρίσκοντες τὸ πῶς ⸀κολάσωνταιαὐτούς, διὰ τὸν λαόν, ὅτι πάντες ἐδόξαζον τὸν θεὸν ἐπὶ τῷ γεγονότι· ");
INSERT INTO grcsbl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ἐτῶν γὰρ ἦν πλειόνων τεσσεράκοντα ὁ ἄνθρωπος ἐφʼ ὃν ⸀γεγόνειτὸ σημεῖον τοῦτο τῆς ἰάσεως. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ἀπολυθέντες δὲ ἦλθον πρὸς τοὺς ἰδίους καὶ ἀπήγγειλαν ὅσα πρὸς αὐτοὺς οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι εἶπαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","οἱ δὲ ἀκούσαντες ὁμοθυμαδὸν ἦραν φωνὴν πρὸς τὸν θεὸν καὶ εἶπαν· Δέσποτα, ⸀σὺὁ ποιήσας τὸν οὐρανὸν καὶ τὴν γῆν καὶ τὴν θάλασσαν καὶ πάντα τὰ ἐν αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ὁ ⸂τοῦ πατρὸς ἡμῶν διὰ ⸂πνεύματος ἁγίου στόματος Δαυὶδ παιδός σου εἰπών· Ἱνατί ἐφρύαξαν ἔθνη καὶ λαοὶ ἐμελέτησαν κενά; ");
INSERT INTO grcsbl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","παρέστησαν οἱ βασιλεῖς τῆς γῆς καὶ οἱ ἄρχοντες συνήχθησαν ἐπὶ τὸ αὐτὸ κατὰ τοῦ κυρίου καὶ κατὰ τοῦ χριστοῦ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","συνήχθησαν γὰρ ἐπʼ ἀληθείας ⸂ἐν τῇ πόλει ταύτῃ ἐπὶ τὸν ἅγιον παῖδά σου Ἰησοῦν, ὃν ἔχρισας, Ἡρῴδης τε καὶ Πόντιος Πιλᾶτος σὺν ἔθνεσιν καὶ λαοῖς Ἰσραήλ, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ποιῆσαι ὅσα ἡ χείρ σου καὶ ἡ ⸀βουλὴπροώρισεν γενέσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","καὶ τὰ νῦν, κύριε, ἔπιδε ἐπὶ τὰς ἀπειλὰς αὐτῶν καὶ δὸς τοῖς δούλοις σου μετὰ παρρησίας πάσης λαλεῖν τὸν λόγον σου, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ἐν τῷ τὴν χεῖρά ⸀σουἐκτείνειν σε εἰς ἴασιν καὶ σημεῖα καὶ τέρατα γίνεσθαι διὰ τοῦ ὀνόματος τοῦ ἁγίου παιδός σου Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","καὶ δεηθέντων αὐτῶν ἐσαλεύθη ὁ τόπος ἐν ᾧ ἦσαν συνηγμένοι, καὶ ἐπλήσθησαν ἅπαντες ⸂τοῦ ἁγίου πνεύματος, καὶ ἐλάλουν τὸν λόγον τοῦ θεοῦ μετὰ παρρησίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Τοῦ δὲ πλήθους τῶν πιστευσάντων ἦν ⸀καρδίακαὶ ⸀ψυχὴμία, καὶ οὐδὲ εἷς τι τῶν ὑπαρχόντων ⸀αὐτῷἔλεγεν ἴδιον εἶναι, ἀλλʼ ἦν αὐτοῖς ⸀πάντακοινά. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","καὶ ⸂δυνάμει μεγάλῃ ἀπεδίδουν τὸ μαρτύριον οἱ ἀπόστολοι ⸂τῆς ἀναστάσεως τοῦ κυρίου Ἰησοῦ, χάρις τε μεγάλη ἦν ἐπὶ πάντας αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","οὐδὲ γὰρ ἐνδεής τις ⸀ἦνἐν αὐτοῖς· ὅσοι γὰρ κτήτορες χωρίων ἢ οἰκιῶν ὑπῆρχον, πωλοῦντες ἔφερον τὰς τιμὰς τῶν πιπρασκομένων ");
INSERT INTO grcsbl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","καὶ ἐτίθουν παρὰ τοὺς πόδας τῶν ἀποστόλων· διεδίδετο δὲ ἑκάστῳ καθότι ἄν τις χρείαν εἶχεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","⸀Ἰωσὴφδὲ ὁ ἐπικληθεὶς Βαρναβᾶς ἀπὸ τῶν ἀποστόλων, ὅ ἐστιν μεθερμηνευόμενον υἱὸς παρακλήσεως, Λευίτης, Κύπριος τῷ γένει, ");
INSERT INTO grcsbl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ὑπάρχοντος αὐτῷ ἀγροῦ πωλήσας ἤνεγκεν τὸ χρῆμα καὶ ἔθηκεν ⸀παρὰτοὺς πόδας τῶν ἀποστόλων. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ἀνὴρ δέ τις Ἁνανίας ὀνόματι σὺν Σαπφίρῃ τῇ γυναικὶ αὐτοῦ ἐπώλησεν κτῆμα ");
INSERT INTO grcsbl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","καὶ ἐνοσφίσατο ἀπὸ τῆς τιμῆς, συνειδυίης καὶ τῆς ⸀γυναικός καὶ ἐνέγκας μέρος τι παρὰ τοὺς πόδας τῶν ἀποστόλων ἔθηκεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","εἶπεν δὲ ⸀ὁΠέτρος· Ἁνανία, διὰ τί ἐπλήρωσεν ὁ Σατανᾶς τὴν καρδίαν σου, ψεύσασθαί σε τὸ πνεῦμα τὸ ἅγιον καὶ ⸀νοσφίσασθαιἀπὸ τῆς τιμῆς τοῦ χωρίου; ");
INSERT INTO grcsbl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","οὐχὶ μένον σοὶ ἔμενεν καὶ πραθὲν ἐν τῇ σῇ ἐξουσίᾳ ὑπῆρχεν; τί ὅτι ἔθου ἐν τῇ καρδίᾳ σου τὸ πρᾶγμα τοῦτο; οὐκ ἐψεύσω ἀνθρώποις ἀλλὰ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ἀκούων δὲ ὁ Ἁνανίας τοὺς λόγους τούτους πεσὼν ἐξέψυξεν· καὶ ἐγένετο φόβος μέγας ἐπὶ πάντας τοὺς ⸀ἀκούοντας ");
INSERT INTO grcsbl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ἀναστάντες δὲ οἱ νεώτεροι συνέστειλαν αὐτὸν καὶ ἐξενέγκαντες ἔθαψαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ἐγένετο δὲ ὡς ὡρῶν τριῶν διάστημα καὶ ἡ γυνὴ αὐτοῦ μὴ εἰδυῖα τὸ γεγονὸς εἰσῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ἀπεκρίθη δὲ ⸂πρὸς αὐτὴν ⸀Πέτρος Εἰπέ μοι, εἰ τοσούτου τὸ χωρίον ἀπέδοσθε; ἡ δὲ εἶπεν· Ναί, τοσούτου. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ὁ δὲ ⸀Πέτροςπρὸς αὐτήν· Τί ὅτι συνεφωνήθη ὑμῖν πειράσαι τὸ πνεῦμα κυρίου; ἰδοὺ οἱ πόδες τῶν θαψάντων τὸν ἄνδρα σου ἐπὶ τῇ θύρᾳ καὶ ἐξοίσουσίν σε. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ἔπεσεν δὲ παραχρῆμα ⸀πρὸςτοὺς πόδας αὐτοῦ καὶ ἐξέψυξεν· εἰσελθόντες δὲ οἱ νεανίσκοι εὗρον αὐτὴν νεκράν, καὶ ἐξενέγκαντες ἔθαψαν πρὸς τὸν ἄνδρα αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","καὶ ἐγένετο φόβος μέγας ἐφʼ ὅλην τὴν ἐκκλησίαν καὶ ἐπὶ πάντας τοὺς ἀκούοντας ταῦτα. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Διὰ δὲ τῶν χειρῶν τῶν ἀποστόλων ἐγίνετο σημεῖα καὶ τέρατα ⸂πολλὰ ἐν τῷ λαῷ· καὶ ἦσαν ὁμοθυμαδὸν ⸀ἅπαντεςἐν τῇ Στοᾷ Σολομῶντος· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","τῶν δὲ λοιπῶν οὐδεὶς ἐτόλμα κολλᾶσθαι αὐτοῖς, ἀλλʼ ἐμεγάλυνεν αὐτοὺς ὁ λαός, ");
INSERT INTO grcsbl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","μᾶλλον δὲ προσετίθεντο πιστεύοντες τῷ κυρίῳ πλήθη ἀνδρῶν τε καὶ γυναικῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ὥστε ⸂καὶ εἰς τὰς πλατείας ἐκφέρειν τοὺς ἀσθενεῖς καὶ τιθέναι ἐπὶ ⸀κλιναρίωνκαὶ κραβάττων, ἵνα ἐρχομένου Πέτρου κἂν ἡ σκιὰ ⸀ἐπισκιάσῃτινὶ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","συνήρχετο δὲ καὶ τὸ πλῆθος τῶν πέριξ ⸀πόλεωνἸερουσαλήμ, φέροντες ἀσθενεῖς καὶ ὀχλουμένους ὑπὸ πνευμάτων ἀκαθάρτων, οἵτινες ἐθεραπεύοντο ἅπαντες. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ἀναστὰς δὲ ὁ ἀρχιερεὺς καὶ πάντες οἱ σὺν αὐτῷ, ἡ οὖσα αἵρεσις τῶν Σαδδουκαίων, ἐπλήσθησαν ζήλου ");
INSERT INTO grcsbl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","καὶ ἐπέβαλον τὰς ⸀χεῖραςἐπὶ τοὺς ἀποστόλους καὶ ἔθεντο αὐτοὺς ἐν τηρήσει δημοσίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ἄγγελος δὲ κυρίου ⸀διὰνυκτὸς ⸀ἤνοιξετὰς θύρας τῆς φυλακῆς ἐξαγαγών τε αὐτοὺς εἶπεν· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Πορεύεσθε καὶ σταθέντες λαλεῖτε ἐν τῷ ἱερῷ τῷ λαῷ πάντα τὰ ῥήματα τῆς ζωῆς ταύτης. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ἀκούσαντες δὲ εἰσῆλθον ὑπὸ τὸν ὄρθρον εἰς τὸ ἱερὸν καὶ ἐδίδασκον. Παραγενόμενος δὲ ὁ ἀρχιερεὺς καὶ οἱ σὺν αὐτῷ συνεκάλεσαν τὸ συνέδριον καὶ πᾶσαν τὴν γερουσίαν τῶν υἱῶν Ἰσραήλ, καὶ ἀπέστειλαν εἰς τὸ δεσμωτήριον ἀχθῆναι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","οἱ δὲ ⸂παραγενόμενοι ὑπηρέται οὐχ εὗρον αὐτοὺς ἐν τῇ φυλακῇ, ἀναστρέψαντες δὲ ἀπήγγειλαν ");
INSERT INTO grcsbl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","λέγοντες ὅτι ⸀Τὸδεσμωτήριον εὕρομεν κεκλεισμένον ἐν πάσῃ ἀσφαλείᾳ καὶ τοὺς φύλακας ἑστῶτας ⸀ἐπὶτῶν θυρῶν, ἀνοίξαντες δὲ ἔσω οὐδένα εὕρομεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ὡς δὲ ἤκουσαν τοὺς λόγους τούτους ὅ ⸀τεστρατηγὸς τοῦ ἱεροῦ καὶ οἱ ἀρχιερεῖς, διηπόρουν περὶ αὐτῶν τί ἂν γένοιτο τοῦτο. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","παραγενόμενος δέ τις ἀπήγγειλεν αὐτοῖς ὅτι Ἰδοὺ οἱ ἄνδρες οὓς ἔθεσθε ἐν τῇ φυλακῇ εἰσὶν ἐν τῷ ἱερῷ ἑστῶτες καὶ διδάσκοντες τὸν λαόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","τότε ἀπελθὼν ὁ στρατηγὸς σὺν τοῖς ὑπηρέταις ⸀ἤγαγεναὐτούς, οὐ μετὰ βίας, ἐφοβοῦντο γὰρ τὸν λαόν, ⸀μὴλιθασθῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ἀγαγόντες δὲ αὐτοὺς ἔστησαν ἐν τῷ συνεδρίῳ. καὶ ἐπηρώτησεν αὐτοὺς ὁ ἀρχιερεὺς ");
INSERT INTO grcsbl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","⸀λέγων Παραγγελίᾳ παρηγγείλαμεν ὑμῖν μὴ διδάσκειν ἐπὶ τῷ ὀνόματι τούτῳ, καὶ ἰδοὺ πεπληρώκατε τὴν Ἰερουσαλὴμ τῆς διδαχῆς ὑμῶν, καὶ βούλεσθε ἐπαγαγεῖν ἐφʼ ἡμᾶς τὸ αἷμα τοῦ ἀνθρώπου τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ἀποκριθεὶς δὲ Πέτρος καὶ οἱ ἀπόστολοι εἶπαν· Πειθαρχεῖν δεῖ θεῷ μᾶλλον ἢ ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ὁ θεὸς τῶν πατέρων ἡμῶν ἤγειρεν Ἰησοῦν, ὃν ὑμεῖς διεχειρίσασθε κρεμάσαντες ἐπὶ ξύλου· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","τοῦον ὁ θεὸς ἀρχηγὸν καὶ σωτῆρα ὕψωσεν τῇ δεξιᾷ αὐτοῦ, ⸀τοῦ δοῦναι μετάνοιαν τῷ Ἰσραὴλ καὶ ἄφεσιν ἁμαρτιῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","καὶ ἡμεῖς ⸀ἐσμενμάρτυρες τῶν ῥημάτων τούτων, καὶ τὸ ⸀πνεῦματὸ ἅγιον ὃ ἔδωκεν ὁ θεὸς τοῖς πειθαρχοῦσιν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Οἱ δὲ ⸀ἀκούσαντεςδιεπρίοντο καὶ ἐβούλοντο ἀνελεῖν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ἀναστὰς δέ τις ἐν τῷ συνεδρίῳ Φαρισαῖος ὀνόματι Γαμαλιήλ, νομοδιδάσκαλος τίμιος παντὶ τῷ λαῷ, ἐκέλευσεν ἔξω ⸀βραχὺτοὺς ⸀ἀνθρώπουςποιῆσαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","εἶπέν τε πρὸς αὐτούς· Ἄνδρες Ἰσραηλῖται, προσέχετε ἑαυτοῖς ἐπὶ τοῖς ἀνθρώποις τούτοις τί μέλλετε πράσσειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","πρὸ γὰρ τούτων τῶν ἡμερῶν ἀνέστη Θευδᾶς, λέγων εἶναί τινα ἑαυτόν, ᾧ ⸀προσεκλίθη⸂ἀνδρῶν ἀριθμὸς ὡς τετρακοσίων· ὃς ἀνῃρέθη, καὶ πάντες ὅσοι ἐπείθοντο αὐτῷ διελύθησαν καὶ ἐγένοντο εἰς οὐδέν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","μετὰ τοῦτον ἀνέστη Ἰούδας ὁ Γαλιλαῖος ἐν ταῖς ἡμέραις τῆς ἀπογραφῆς καὶ ἀπέστησε ⸀λαὸνὀπίσω αὐτοῦ· κἀκεῖνος ἀπώλετο καὶ πάντες ὅσοι ἐπείθοντο αὐτῷ διεσκορπίσθησαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","καὶ τὰ νῦν λέγω ὑμῖν, ἀπόστητε ἀπὸ τῶν ἀνθρώπων τούτων καὶ ⸀ἄφετεαὐτούς· (ὅτι ἐὰν ᾖ ἐξ ἀνθρώπων ἡ βουλὴ ⸀αὕτηἢ τὸ ἔργον τοῦτο, καταλυθήσεται, ");
INSERT INTO grcsbl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","εἰ δὲ ἐκ θεοῦ ἐστιν, οὐ ⸀δυνήσεσθεκαταλῦσαι ⸀αὐτούς) μήποτε καὶ θεομάχοι εὑρεθῆτε. ἐπείσθησαν δὲ αὐτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","καὶ προσκαλεσάμενοι τοὺς ἀποστόλους δείραντες παρήγγειλαν μὴ λαλεῖν ἐπὶ τῷ ὀνόματι τοῦ Ἰησοῦ καὶ ⸀ἀπέλυσαν ");
INSERT INTO grcsbl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","οἱ μὲν οὖν ἐπορεύοντο χαίροντες ἀπὸ προσώπου τοῦ συνεδρίου ὅτι ⸂κατηξιώθησαν ὑπὲρ τοῦ ὀνόματος ἀτιμασθῆναι· ");
INSERT INTO grcsbl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","πᾶσάν τε ἡμέραν ἐν τῷ ἱερῷ καὶ κατʼ οἶκον οὐκ ἐπαύοντο διδάσκοντες καὶ εὐαγγελιζόμενοι ⸂τὸν χριστὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ἐν δὲ ταῖς ἡμέραις ταύταις πληθυνόντων τῶν μαθητῶν ἐγένετο γογγυσμὸς τῶν Ἑλληνιστῶν πρὸς τοὺς Ἑβραίους ὅτι παρεθεωροῦντο ἐν τῇ διακονίᾳ τῇ καθημερινῇ αἱ χῆραι αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","προσκαλεσάμενοι δὲ οἱ δώδεκα τὸ πλῆθος τῶν μαθητῶν εἶπαν· Οὐκ ἀρεστόν ἐστιν ἡμᾶς καταλείψαντας τὸν λόγον τοῦ θεοῦ διακονεῖν τραπέζαις· ");
INSERT INTO grcsbl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ἐπισκέψασθε ⸀δέ ἀδελφοί, ἄνδρας ἐξ ὑμῶν μαρτυρουμένους ἑπτὰ πλήρεις ⸀πνεύματοςκαὶ σοφίας, οὓς ⸀καταστήσομενἐπὶ τῆς χρείας ταύτης· ");
INSERT INTO grcsbl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ἡμεῖς δὲ τῇ προσευχῇ καὶ τῇ διακονίᾳ τοῦ λόγου προσκαρτερήσομεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","καὶ ἤρεσεν ὁ λόγος ἐνώπιον παντὸς τοῦ πλήθους, καὶ ἐξελέξαντο Στέφανον, ἄνδρα ⸀πλήρηςπίστεως καὶ πνεύματος ἁγίου, καὶ Φίλιππον καὶ Πρόχορον καὶ Νικάνορα καὶ Τίμωνα καὶ Παρμενᾶν καὶ Νικόλαον προσήλυτον Ἀντιοχέα, ");
INSERT INTO grcsbl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","οὓς ἔστησαν ἐνώπιον τῶν ἀποστόλων, καὶ προσευξάμενοι ἐπέθηκαν αὐτοῖς τὰς χεῖρας. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Καὶ ὁ λόγος τοῦ θεοῦ ηὔξανεν, καὶ ἐπληθύνετο ὁ ἀριθμὸς τῶν μαθητῶν ἐν Ἰερουσαλὴμ σφόδρα, πολύς τε ὄχλος τῶν ἱερέων ὑπήκουον τῇ πίστει. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Στέφανος δὲ πλήρης ⸀χάριτοςκαὶ δυνάμεως ἐποίει τέρατα καὶ σημεῖα μεγάλα ἐν τῷ λαῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ἀνέστησαν δέ τινες τῶν ἐκ τῆς συναγωγῆς τῆς λεγομένης Λιβερτίνων καὶ Κυρηναίων καὶ Ἀλεξανδρέων καὶ τῶν ἀπὸ Κιλικίας καὶ Ἀσίας συζητοῦντες τῷ Στεφάνῳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","καὶ οὐκ ἴσχυον ἀντιστῆναι τῇ σοφίᾳ καὶ τῷ πνεύματι ᾧ ἐλάλει. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","τότε ὑπέβαλον ἄνδρας λέγοντας ὅτι Ἀκηκόαμεν αὐτοῦ λαλοῦντος ῥήματα βλάσφημα εἰς Μωϋσῆν καὶ τὸν θεόν· ");
INSERT INTO grcsbl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","συνεκίνησάν τε τὸν λαὸν καὶ τοὺς πρεσβυτέρους καὶ τοὺς γραμματεῖς, καὶ ἐπιστάντες συνήρπασαν αὐτὸν καὶ ἤγαγον εἰς τὸ συνέδριον, ");
INSERT INTO grcsbl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ἔστησάν τε μάρτυρας ψευδεῖς λέγοντας· Ὁ ἄνθρωπος οὗτος οὐ παύεται ⸂λαλῶν ῥήματα κατὰ τοῦ τόπου τοῦ ⸀ἁγίουκαὶ τοῦ νόμου, ");
INSERT INTO grcsbl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ἀκηκόαμεν γὰρ αὐτοῦ λέγοντος ὅτι Ἰησοῦς ὁ Ναζωραῖος οὗτος καταλύσει τὸν τόπον τοῦτον καὶ ἀλλάξει τὰ ἔθη ἃ παρέδωκεν ἡμῖν Μωϋσῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","καὶ ἀτενίσαντες εἰς αὐτὸν ⸀πάντεςοἱ καθεζόμενοι ἐν τῷ συνεδρίῳ εἶδον τὸ πρόσωπον αὐτοῦ ὡσεὶ πρόσωπον ἀγγέλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Εἶπεν δὲ ὁ ἀρχιερεύς· ⸀Εἰταῦτα οὕτως ἔχει; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ὁ δὲ ἔφη· Ἄνδρες ἀδελφοὶ καὶ πατέρες, ἀκούσατε· Ὁ θεὸς τῆς δόξης ὤφθη τῷ πατρὶ ἡμῶν Ἀβραὰμ ὄντι ἐν τῇ Μεσοποταμίᾳ πρὶν ἢ κατοικῆσαι αὐτὸν ἐν Χαρράν, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","καὶ εἶπεν πρὸς αὐτόν· Ἔξελθε ἐκτῆς γῆς σου καὶ ⸀ἐκ τῆς συγγενείας σου, καὶ δεῦρο εἰς ⸀τὴνγῆν ἣν ἄν σοι δείξω. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","τότε ἐξελθὼν ἐκ γῆς Χαλδαίων κατῴκησεν ἐν Χαρράν. κἀκεῖθεν μετὰ τὸ ἀποθανεῖν τὸν πατέρα αὐτοῦ μετῴκισεν αὐτὸν εἰς τὴν γῆν ταύτην εἰς ἣν ὑμεῖς νῦν κατοικεῖτε, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","καὶ οὐκ ἔδωκεν αὐτῷ κληρονομίαν ἐν αὐτῇ οὐδὲ βῆμα ποδός, καὶ ἐπηγγείλατο δοῦναι αὐτῷ εἰς κατάσχεσιν αὐτὴν καὶ τῷ σπέρματι αὐτοῦ μετʼ αὐτόν, οὐκ ὄντος αὐτῷ τέκνου. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ἐλάλησεν ⸀δὲοὕτως ὁ θεὸς ὅτι ἔσται τὸ σπέρμα αὐτοῦ πάροικον ἐν γῇ ἀλλοτρίᾳ, καὶ δουλώσουσιν αὐτὸ καὶ κακώσουσιν ἔτη τετρακόσια· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","καὶ τὸ ἔθνος ᾧ ⸀ἐὰν⸀δουλεύσουσινκρινῶ ἐγώ, ⸂ὁ θεὸς εἶπεν, καὶ μετὰ ταῦτα ἐξελεύσονται καὶ λατρεύσουσίν μοι ἐν τῷ τόπῳ τούτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","καὶ ἔδωκεν αὐτῷ διαθήκην περιτομῆς· καὶ οὕτως ἐγέννησεν τὸν Ἰσαὰκ καὶ περιέτεμεν αὐτὸν τῇ ἡμέρᾳ τῇ ὀγδόῃ, ⸀καὶἸσαὰκ τὸν Ἰακώβ, ⸁καὶἸακὼβ τοὺς δώδεκα πατριάρχας. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Καὶ οἱ πατριάρχαι ζηλώσαντες τὸν Ἰωσὴφ ἀπέδοντο εἰς Αἴγυπτον· καὶ ἦν ὁ θεὸς μετʼ αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","καὶἐξείλατο αὐτὸν ἐκ πασῶν τῶν θλίψεων αὐτοῦ, καὶ ἔδωκεν αὐτῷ χάριν καὶ σοφίαν ἐναντίον Φαραὼ βασιλέως Αἰγύπτου, καὶ κατέστησεν αὐτὸν ἡγούμενον ἐπʼ Αἴγυπτον ⸀καὶ ὅλον τὸν οἶκον αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ἦλθεν δὲ λιμὸς ἐφʼ ὅλην τὴν ⸀Αἴγυπτονκαὶ Χανάαν καὶ θλῖψις μεγάλη, καὶ οὐχ ηὕρισκον χορτάσματα οἱ πατέρες ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ἀκούσας δὲ Ἰακὼβ ὄντα ⸂σιτία εἰς Αἴγυπτον ἐξαπέστειλεν τοὺς πατέρας ἡμῶν πρῶτον· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","καὶ ἐν τῷ δευτέρῳ ⸀ἀνεγνωρίσθηἸωσὴφ τοῖς ἀδελφοῖς αὐτοῦ, καὶ φανερὸν ἐγένετο τῷ Φαραὼ τὸ ⸀γένοςἸωσήφ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ἀποστείλας δὲ Ἰωσὴφ μετεκαλέσατο ⸂Ἰακὼβ τὸν πατέρα αὐτοῦ καὶ πᾶσαν τὴν συγγένειαν ἐν ψυχαῖς ἑβδομήκοντα πέντε, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","⸂καὶ κατέβη Ἰακὼβ εἰς Αἴγυπτον. καὶ ἐτελεύτησεν αὐτὸς καὶ οἱ πατέρες ἡμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","καὶ μετετέθησαν εἰς Συχὲμ καὶ ἐτέθησαν ἐν τῷ μνήματι ⸀ᾧὠνήσατο Ἀβραὰμ τιμῆς ἀργυρίου παρὰ τῶν υἱῶν Ἑμμὼρ ⸀ἐνΣυχέμ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Καθὼς δὲ ἤγγιζεν ὁ χρόνος τῆς ἐπαγγελίας ἧς ⸀ὡμολόγησενὁ θεὸς τῷ Ἀβραάμ, ηὔξησεν ὁ λαὸς καὶ ἐπληθύνθη ἐν Αἰγύπτῳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ἄχρι οὗ ἀνέστη βασιλεὺς ἕτερος ⸂ἐπʼ Αἴγυπτον, ὃς οὐκ ᾔδει τὸν Ἰωσήφ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","οὗτος κατασοφισάμενος τὸ γένος ἡμῶν ἐκάκωσεν τοὺς ⸀πατέραςτοῦ ποιεῖν ⸂τὰ βρέφη ἔκθετα αὐτῶν εἰς τὸ μὴ ζῳογονεῖσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ἐν ᾧ καιρῷ ἐγεννήθη Μωϋσῆς, καὶ ἦν ἀστεῖος τῷ θεῷ· ὃς ἀνετράφη μῆνας τρεῖς ἐν τῷ οἴκῳ τοῦ πατρός· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","⸂ἐκτεθέντος δὲ αὐτοῦ ἀνείλατο αὐτὸν ἡ θυγάτηρ Φαραὼ καὶ ἀνεθρέψατο αὐτὸν ἑαυτῇ εἰς υἱόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","καὶ ἐπαιδεύθη ⸀Μωϋσῆςπάσῃ σοφίᾳ Αἰγυπτίων, ἦν δὲ δυνατὸς ἐν λόγοις καὶ ἔργοις ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ὡς δὲ ἐπληροῦτο αὐτῷ τεσσερακονταετὴς χρόνος, ἀνέβη ἐπὶ τὴν καρδίαν αὐτοῦ ἐπισκέψασθαι τοὺς ἀδελφοὺς αὐτοῦ τοὺς υἱοὺς Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","καὶ ἰδών τινα ἀδικούμενον ἠμύνατο καὶ ἐποίησεν ἐκδίκησιν τῷ καταπονουμένῳ πατάξας τὸν Αἰγύπτιον. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ἐνόμιζεν δὲ συνιέναι τοὺς ⸀ἀδελφοὺςὅτι ὁ θεὸς διὰ χειρὸς αὐτοῦ δίδωσιν ⸂σωτηρίαν αὐτοῖς, οἱ δὲ οὐ συνῆκαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","τῇ τε ἐπιούσῃ ἡμέρᾳ ὤφθη αὐτοῖς μαχομένοις καὶ ⸀συνήλλασσεναὐτοὺς εἰς εἰρήνην εἰπών· Ἄνδρες, ἀδελφοί ⸀ἐστε ἱνατί ἀδικεῖτε ἀλλήλους; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ὁ δὲ ἀδικῶν τὸν πλησίον ἀπώσατο αὐτὸν εἰπών· Τίς σε κατέστησεν ἄρχοντα καὶ δικαστὴν ἐφʼ ⸀ἡμῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","μὴ ἀνελεῖν με σὺ θέλεις ὃν τρόπον ἀνεῖλες ⸀ἐχθὲςτὸν Αἰγύπτιον; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ἔφυγεν δὲ Μωϋσῆς ἐν τῷ λόγῳ τούτῳ, καὶ ἐγένετο πάροικος ἐν γῇ Μαδιάμ, οὗ ἐγέννησεν υἱοὺς δύο. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Καὶ πληρωθέντων ἐτῶν τεσσεράκοντα ὤφθη αὐτῷ ἐν τῇ ἐρήμῳ τοῦ ὄρους Σινᾶ ⸀ἄγγελοςἐν φλογὶ πυρὸς βάτου· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ὁ δὲ Μωϋσῆς ἰδὼν ⸀ἐθαύμασεντὸ ὅραμα. προσερχομένου δὲ αὐτοῦ κατανοῆσαι ἐγένετο φωνὴ ⸀κυρίου ");
INSERT INTO grcsbl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ἐγὼ ὁ θεὸς τῶν πατέρων σου, ὁ θεὸς Ἀβραὰμ ⸀καὶἸσαὰκ ⸁καὶἸακώβ. ἔντρομος δὲ γενόμενος Μωϋσῆς οὐκ ἐτόλμα κατανοῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","εἶπεν δὲ αὐτῷ ὁ κύριος· Λῦσον τὸ ὑπόδημα τῶν ποδῶν σου, ὁ γὰρ τόπος ⸀ἐφʼᾧ ἕστηκας γῆ ἁγία ἐστίν. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ἰδὼν εἶδον τὴν κάκωσιν τοῦ λαοῦ μου τοῦ ἐν Αἰγύπτῳ, καὶ τοῦ στεναγμοῦ ⸀αὐτοῦἤκουσα, καὶ κατέβην ἐξελέσθαι αὐτούς· καὶ νῦν δεῦρο ⸀ἀποστείλωσε εἰς Αἴγυπτον. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Τοῦτον τὸν Μωϋσῆν, ὃν ἠρνήσαντο εἰπόντες· Τίς σε κατέστησεν ἄρχοντα καὶδικαστήν, τοῦτον ὁ θεὸς ⸀καὶ ἄρχοντα καὶ λυτρωτὴν ⸂ἀπέσταλκεν σὺν χειρὶ ἀγγέλου τοῦ ὀφθέντος αὐτῷ ἐν τῇ βάτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","οὗτος ἐξήγαγεν αὐτοὺς ποιήσας τέρατα καὶ σημεῖα ἐν ⸀γῇΑἰγύπτῳ καὶ ἐν Ἐρυθρᾷ Θαλάσσῃ καὶ ἐν τῇ ἐρήμῳ ἔτη τεσσεράκοντα. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","οὗτός ἐστιν ὁ Μωϋσῆς ὁ ⸀εἴπαςτοῖς υἱοῖς Ἰσραήλ· Προφήτην ὑμῖν ἀναστήσει ⸂ὁ θεὸς ἐκ τῶν ἀδελφῶν ὑμῶν ὡς ἐμέ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","οὗτός ἐστιν ὁ γενόμενος ἐν τῇ ἐκκλησίᾳ ἐν τῇ ἐρήμῳ μετὰ τοῦ ἀγγέλου τοῦ λαλοῦντος αὐτῷ ἐν τῷ ὄρει Σινᾶ καὶ τῶν πατέρων ἡμῶν, ὃς ἐδέξατο ⸀λόγιαζῶντα δοῦναι ⸀ἡμῖν ");
INSERT INTO grcsbl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ᾧ οὐκ ἠθέλησαν ὑπήκοοι γενέσθαι οἱ πατέρες ἡμῶν, ἀλλὰ ἀπώσαντο καὶ ἐστράφησαν ⸂ἐν ταῖς καρδίαις αὐτῶν εἰς Αἴγυπτον, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","εἰπόντες τῷ Ἀαρών· Ποίησον ἡμῖν θεοὺς οἳ προπορεύσονται ἡμῶν· ὁ γὰρ Μωϋσῆς οὗτος, ὃς ἐξήγαγεν ἡμᾶς ἐκ γῆς Αἰγύπτου, οὐκ οἴδαμεν τί ⸀ἐγένετοαὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","καὶ ἐμοσχοποίησαν ἐν ταῖς ἡμέραις ἐκείναις καὶ ἀνήγαγον θυσίαν τῷ εἰδώλῳ, καὶ εὐφραίνοντο ἐν τοῖς ἔργοις τῶν χειρῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ἔστρεψεν δὲ ὁ θεὸς καὶ παρέδωκεν αὐτοὺς λατρεύειν τῇ στρατιᾷ τοῦ οὐρανοῦ, καθὼς γέγραπται ἐν βίβλῳ τῶν προφητῶν· Μὴ σφάγια καὶ θυσίας προσηνέγκατέ μοι ἔτη τεσσεράκοντα ἐν τῇ ἐρήμῳ, οἶκος Ἰσραήλ; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","καὶ ἀνελάβετε τὴν σκηνὴν τοῦ Μολὸχ καὶ τὸ ἄστρον τοῦ ⸀θεοῦ⸀Ῥαιφάν τοὺς τύπους οὓς ἐποιήσατε προσκυνεῖν αὐτοῖς. καὶ μετοικιῶ ὑμᾶς ἐπέκεινα Βαβυλῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ἡ σκηνὴ τοῦ μαρτυρίου ἦν τοῖς πατράσιν ἡμῶν ἐν τῇ ἐρήμῳ, καθὼς διετάξατο ὁ λαλῶν τῷ Μωϋσῇ ποιῆσαι αὐτὴν κατὰ τὸν τύπον ὃν ἑωράκει, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ἣν καὶ εἰσήγαγον διαδεξάμενοι οἱ πατέρες ἡμῶν μετὰ Ἰησοῦ ἐν τῇ κατασχέσει τῶν ἐθνῶν ὧν ἐξῶσεν ὁ θεὸς ἀπὸ προσώπου τῶν πατέρων ἡμῶν ἕως τῶν ἡμερῶν Δαυίδ· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ὃς εὗρεν χάριν ἐνώπιον τοῦ θεοῦ καὶ ᾐτήσατο εὑρεῖν σκήνωμα τῷ ⸀θεῷἸακώβ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Σολομῶν δὲ οἰκοδόμησεν αὐτῷ οἶκον. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ἀλλʼ οὐχ ὁ ὕψιστος ἐν ⸀χειροποιήτοιςκατοικεῖ· καθὼς ὁ προφήτης λέγει· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ὁ οὐρανός μοι θρόνος, ⸂ἡ δὲ γῆ ὑποπόδιον τῶν ποδῶν μου· ποῖον οἶκον οἰκοδομήσετέ μοι, λέγει κύριος, ἢ τίς τόπος τῆς καταπαύσεώς μου; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","οὐχὶ ἡ χείρ μου ἐποίησεν ταῦτα πάντα; ");
INSERT INTO grcsbl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Σκληροτράχηλοι καὶ ἀπερίτμητοι ⸀καρδίαιςκαὶ τοῖς ὠσίν, ὑμεῖς ἀεὶ τῷ πνεύματι τῷ ἁγίῳ ἀντιπίπτετε, ὡς οἱ πατέρες ὑμῶν καὶ ὑμεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","τίνα τῶν προφητῶν οὐκ ἐδίωξαν οἱ πατέρες ὑμῶν; καὶ ἀπέκτειναν τοὺς προκαταγγείλαντας περὶ τῆς ἐλεύσεως τοῦ δικαίου οὗ νῦν ὑμεῖς προδόται καὶ φονεῖς ⸀ἐγένεσθε ");
INSERT INTO grcsbl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","οἵτινες ἐλάβετε τὸν νόμον εἰς διαταγὰς ἀγγέλων, καὶ οὐκ ἐφυλάξατε. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ἀκούοντες δὲ ταῦτα διεπρίοντο ταῖς καρδίαις αὐτῶν καὶ ἔβρυχον τοὺς ὀδόντας ἐπʼ αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ὑπάρχων δὲ πλήρης πνεύματος ἁγίου ἀτενίσας εἰς τὸν οὐρανὸν εἶδεν δόξαν θεοῦ καὶ Ἰησοῦν ἑστῶτα ἐκ δεξιῶν τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","καὶ εἶπεν· Ἰδοὺ θεωρῶ τοὺς οὐρανοὺς ⸀διηνοιγμένουςκαὶ τὸν υἱὸν τοῦ ἀνθρώπου ἐκ δεξιῶν ἑστῶτα τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","κράξαντες δὲ φωνῇ μεγάλῃ συνέσχον τὰ ὦτα αὐτῶν, καὶ ὥρμησαν ὁμοθυμαδὸν ἐπʼ αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","καὶ ἐκβαλόντες ἔξω τῆς πόλεως ἐλιθοβόλουν. καὶ οἱ μάρτυρες ἀπέθεντο τὰ ἱμάτια ⸀αὐτῶνπαρὰ τοὺς πόδας νεανίου καλουμένου Σαύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","καὶ ἐλιθοβόλουν τὸν Στέφανον ἐπικαλούμενον καὶ λέγοντα· Κύριε Ἰησοῦ, δέξαι τὸ πνεῦμά μου· ");
INSERT INTO grcsbl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","θεὶς δὲ τὰ γόνατα ἔκραξεν φωνῇ μεγάλῃ· Κύριε, μὴ στήσῃς αὐτοῖς ⸂ταύτην τὴν ἁμαρτίαν· καὶ τοῦτο εἰπὼν ἐκοιμήθη. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Σαῦλος δὲ ἦν συνευδοκῶν τῇ ἀναιρέσει αὐτοῦ. Ἐγένετο δὲ ἐν ἐκείνῃ τῇ ἡμέρᾳ διωγμὸς μέγας ἐπὶ τὴν ἐκκλησίαν τὴν ἐν Ἱεροσολύμοις· πάντες δὲ διεσπάρησαν κατὰ τὰς χώρας τῆς Ἰουδαίας καὶ Σαμαρείας πλὴν τῶν ἀποστόλων. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","συνεκόμισαν δὲ τὸν Στέφανον ἄνδρες εὐλαβεῖς καὶ ⸀ἐποίησανκοπετὸν μέγαν ἐπʼ αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Σαῦλος δὲ ἐλυμαίνετο τὴν ἐκκλησίαν κατὰ τοὺς οἴκους εἰσπορευόμενος, σύρων τε ἄνδρας καὶ γυναῖκας παρεδίδου εἰς φυλακήν. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Οἱ μὲν οὖν διασπαρέντες διῆλθον εὐαγγελιζόμενοι τὸν λόγον. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Φίλιππος δὲ κατελθὼν εἰς ⸀τὴνπόλιν τῆς Σαμαρείας ἐκήρυσσεν αὐτοῖς τὸν χριστόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","προσεῖχον ⸀δὲοἱ ὄχλοι τοῖς λεγομένοις ὑπὸ τοῦ Φιλίππου ὁμοθυμαδὸν ἐν τῷ ἀκούειν αὐτοὺς καὶ βλέπειν τὰ σημεῖα ἃ ἐποίει· ");
INSERT INTO grcsbl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","⸀πολλοὶγὰρ τῶν ἐχόντων πνεύματα ἀκάθαρτα βοῶντα φωνῇ μεγάλῃ ⸀ἐξήρχοντο πολλοὶ δὲ παραλελυμένοι καὶ χωλοὶ ἐθεραπεύθησαν· ");
INSERT INTO grcsbl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","⸂ἐγένετο δὲ ⸂πολλὴ χαρὰ ἐν τῇ πόλει ἐκείνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ἀνὴρ δέ τις ὀνόματι Σίμων προϋπῆρχεν ἐν τῇ πόλει μαγεύων καὶ ⸀ἐξιστάνωντὸ ἔθνος τῆς Σαμαρείας, λέγων εἶναί τινα ἑαυτὸν μέγαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ᾧ προσεῖχον ⸀πάντεςἀπὸ μικροῦ ἕως μεγάλου λέγοντες· Οὗτός ἐστιν ἡ Δύναμις τοῦ θεοῦ ἡ ⸀καλουμένηΜεγάλη. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","προσεῖχον δὲ αὐτῷ διὰ τὸ ἱκανῷ χρόνῳ ταῖς μαγείαις ἐξεστακέναι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ὅτε δὲ ἐπίστευσαν τῷ Φιλίππῳ εὐαγγελιζομένῳ ⸀περὶτῆς βασιλείας τοῦ θεοῦ καὶ τοῦ ὀνόματος Ἰησοῦ Χριστοῦ, ἐβαπτίζοντο ἄνδρες τε καὶ γυναῖκες. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ὁ δὲ Σίμων καὶ αὐτὸς ἐπίστευσεν, καὶ βαπτισθεὶς ἦν προσκαρτερῶν τῷ Φιλίππῳ, θεωρῶν τε ⸂σημεῖα καὶ δυνάμεις μεγάλας γινομένας ἐξίστατο. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ἀκούσαντες δὲ οἱ ἐν Ἱεροσολύμοις ἀπόστολοι ὅτι δέδεκται ἡ Σαμάρεια τὸν λόγον τοῦ θεοῦ, ἀπέστειλαν πρὸς ⸀αὐτοὺςΠέτρον καὶ Ἰωάννην, ");
INSERT INTO grcsbl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","οἵτινες καταβάντες προσηύξαντο περὶ αὐτῶν ὅπως λάβωσιν πνεῦμα ἅγιον· ");
INSERT INTO grcsbl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","⸀οὐδέπωγὰρ ἦν ἐπʼ οὐδενὶ αὐτῶν ἐπιπεπτωκός, μόνον δὲ βεβαπτισμένοι ὑπῆρχον εἰς τὸ ὄνομα τοῦ ⸀κυρίουἸησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","τότε ⸀ἐπετίθεσαντὰς χεῖρας ἐπʼ αὐτούς, καὶ ἐλάμβανον πνεῦμα ἅγιον. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","⸀ἰδὼνδὲ ὁ Σίμων ὅτι διὰ τῆς ἐπιθέσεως τῶν χειρῶν τῶν ἀποστόλων δίδοται τὸ ⸀πνεῦμαπροσήνεγκεν αὐτοῖς χρήματα ");
INSERT INTO grcsbl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","λέγων· Δότε κἀμοὶ τὴν ἐξουσίαν ταύτην ἵνα ᾧ ἐὰν ἐπιθῶ τὰς χεῖρας λαμβάνῃ πνεῦμα ἅγιον. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Πέτρος δὲ εἶπεν πρὸς αὐτόν· Τὸ ἀργύριόν σου σὺν σοὶ εἴη εἰς ἀπώλειαν ὅτι τὴν δωρεὰν τοῦ θεοῦ ἐνόμισας διὰ χρημάτων κτᾶσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","οὐκ ἔστιν σοι μερὶς οὐδὲ κλῆρος ἐν τῷ λόγῳ τούτῳ, ἡ γὰρ καρδία σου οὐκ ἔστιν εὐθεῖα ⸀ἔναντιτοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","μετανόησον οὖν ἀπὸ τῆς κακίας σου ταύτης, καὶ δεήθητι τοῦ ⸀κυρίουεἰ ἄρα ἀφεθήσεταί σοι ἡ ἐπίνοια τῆς καρδίας σου· ");
INSERT INTO grcsbl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","εἰς γὰρ χολὴν πικρίας καὶ σύνδεσμον ἀδικίας ὁρῶ σε ὄντα. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ἀποκριθεὶς δὲ ὁ Σίμων εἶπεν· Δεήθητε ὑμεῖς ὑπὲρ ἐμοῦ πρὸς τὸν κύριον ὅπως μηδὲν ἐπέλθῃ ἐπʼ ἐμὲ ὧν εἰρήκατε. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Οἱ μὲν οὖν διαμαρτυράμενοι καὶ λαλήσαντες τὸν λόγον τοῦ κυρίου ⸀ὑπέστρεφονεἰς ⸀Ἱεροσόλυμα πολλάς τε κώμας τῶν Σαμαριτῶν ⸀εὐηγγελίζοντο ");
INSERT INTO grcsbl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ἄγγελος δὲ κυρίου ἐλάλησεν πρὸς Φίλιππον λέγων· Ἀνάστηθι καὶ πορεύου κατὰ μεσημβρίαν ἐπὶ τὴν ὁδὸν τὴν καταβαίνουσαν ἀπὸ Ἰερουσαλὴμ εἰς Γάζαν· αὕτη ἐστὶν ἔρημος. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","καὶ ἀναστὰς ἐπορεύθη, καὶ ἰδοὺ ἀνὴρ Αἰθίοψ εὐνοῦχος δυνάστης ⸀Κανδάκηςβασιλίσσης Αἰθιόπων, ὃς ἦν ἐπὶ πάσης τῆς γάζης αὐτῆς, ὃς ἐληλύθει προσκυνήσων εἰς Ἰερουσαλήμ, ");
INSERT INTO grcsbl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ἦν ⸀τεὑποστρέφων καὶ καθήμενος ἐπὶ τοῦ ἅρματος αὐτοῦ καὶ ἀνεγίνωσκεν τὸν προφήτην Ἠσαΐαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","εἶπεν δὲ τὸ πνεῦμα τῷ Φιλίππῳ· Πρόσελθε καὶ κολλήθητι τῷ ἅρματι τούτῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","προσδραμὼν δὲ ὁ Φίλιππος ἤκουσεν αὐτοῦ ἀναγινώσκοντος ⸂Ἠσαΐαν τὸν προφήτην καὶ εἶπεν· Ἆρά γε γινώσκεις ἃ ἀναγινώσκεις; ");
INSERT INTO grcsbl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ὁ δὲ εἶπεν· Πῶς γὰρ ἂν δυναίμην ἐὰν μή τις ⸀ὁδηγήσειμε; παρεκάλεσέν τε τὸν Φίλιππον ἀναβάντα καθίσαι σὺν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ἡ δὲ περιοχὴ τῆς γραφῆς ἣν ἀνεγίνωσκεν ἦν αὕτη· Ὡς πρόβατον ἐπὶ σφαγὴν ἤχθη, καὶ ὡς ἀμνὸς ἐναντίον τοῦ ⸀κείραντοςαὐτὸν ἄφωνος, οὕτως οὐκ ἀνοίγει τὸ στόμα αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ἐν τῇ ⸀ταπεινώσειἡ κρίσις αὐτοῦ ἤρθη· ⸀τὴνγενεὰν αὐτοῦ τίς διηγήσεται; ὅτι αἴρεται ἀπὸ τῆς γῆς ἡ ζωὴ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ἀποκριθεὶς δὲ ὁ εὐνοῦχος τῷ Φιλίππῳ εἶπεν· Δέομαί σου, περὶ τίνος ὁ προφήτης λέγει ⸀τοῦτο περὶ ἑαυτοῦ ἢ περὶ ἑτέρου τινός; ");
INSERT INTO grcsbl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ἀνοίξας δὲ ὁ Φίλιππος τὸ στόμα αὐτοῦ καὶ ἀρξάμενος ἀπὸ τῆς γραφῆς ταύτης εὐηγγελίσατο αὐτῷ τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ὡς δὲ ἐπορεύοντο κατὰ τὴν ὁδόν, ἦλθον ἐπί τι ὕδωρ, καί φησιν ὁ εὐνοῦχος· Ἰδοὺ ὕδωρ, τί κωλύει με ⸀βαπτισθῆναι; ");
INSERT INTO grcsbl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","καὶ ἐκέλευσεν στῆναι τὸ ἅρμα, καὶ κατέβησαν ἀμφότεροι εἰς τὸ ὕδωρ ὅ τε Φίλιππος καὶ ὁ εὐνοῦχος, καὶ ἐβάπτισεν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ὅτε δὲ ἀνέβησαν ἐκ τοῦ ὕδατος, πνεῦμα κυρίου ἥρπασεν τὸν Φίλιππον, καὶ οὐκ εἶδεν αὐτὸν οὐκέτι ὁ εὐνοῦχος, ἐπορεύετο γὰρ τὴν ὁδὸν αὐτοῦ χαίρων. ");
INSERT INTO grcsbl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Φίλιππος δὲ εὑρέθη εἰς Ἄζωτον, καὶ διερχόμενος εὐηγγελίζετο τὰς πόλεις πάσας ἕως τοῦ ἐλθεῖν αὐτὸν εἰς Καισάρειαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ὁ δὲ Σαῦλος ἔτι ἐμπνέων ἀπειλῆς καὶ φόνου εἰς τοὺς μαθητὰς τοῦ κυρίου, προσελθὼν τῷ ἀρχιερεῖ ");
INSERT INTO grcsbl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ᾐτήσατο παρʼ αὐτοῦ ἐπιστολὰς εἰς Δαμασκὸν πρὸς τὰς συναγωγάς, ὅπως ἐάν τινας εὕρῃ τῆς ὁδοῦ ὄντας, ἄνδρας τε καὶ γυναῖκας, δεδεμένους ἀγάγῃ εἰς Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ἐν δὲ τῷ πορεύεσθαι ἐγένετο αὐτὸν ἐγγίζειν τῇ Δαμασκῷ, ⸂ἐξαίφνης τε αὐτὸν περιήστραψεν φῶς ⸀ἐκτοῦ οὐρανοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","καὶ πεσὼν ἐπὶ τὴν γῆν ἤκουσεν φωνὴν λέγουσαν αὐτῷ Σαοὺλ Σαούλ, τί με διώκεις; ");
INSERT INTO grcsbl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","εἶπεν δέ Τίς εἶ, κύριε; ὁ ⸀δέ· Ἐγώ εἰμι Ἰησοῦς ὃν σὺ διώκεις· ");
INSERT INTO grcsbl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ἀλλὰ ἀνάστηθι καὶ εἴσελθε εἰς τὴν πόλιν, καὶ λαληθήσεταί σοι ⸂ὅ τί σε δεῖ ποιεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","οἱ δὲ ἄνδρες οἱ συνοδεύοντες αὐτῷ εἱστήκεισαν ἐνεοί, ἀκούοντες μὲν τῆς φωνῆς μηδένα δὲ θεωροῦντες. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ἠγέρθη δὲ ⸀Σαῦλοςἀπὸ τῆς γῆς, ἀνεῳγμένων ⸀δὲτῶν ὀφθαλμῶν αὐτοῦ ⸀οὐδὲνἔβλεπεν· χειραγωγοῦντες δὲ αὐτὸν εἰσήγαγον εἰς Δαμασκόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","καὶ ἦν ἡμέρας τρεῖς μὴ βλέπων, καὶ οὐκ ἔφαγεν οὐδὲ ἔπιεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ἦν δέ τις μαθητὴς ἐν Δαμασκῷ ὀνόματι Ἁνανίας, καὶ εἶπεν πρὸς αὐτὸν ⸂ἐν ὁράματι ὁ κύριος· Ἁνανία. ὁ δὲ εἶπεν· Ἰδοὺ ἐγώ, κύριε. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ὁ δὲ κύριος πρὸς αὐτόν· ⸀Ἀναστὰςπορεύθητι ἐπὶ τὴν ῥύμην τὴν καλουμένην Εὐθεῖαν καὶ ζήτησον ἐν οἰκίᾳ Ἰούδα Σαῦλον ὀνόματι Ταρσέα, ἰδοὺ γὰρ προσεύχεται, ");
INSERT INTO grcsbl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","καὶ εἶδεν ⸂ἄνδρα ἐν ὁράματι Ἁνανίαν ὀνόματι εἰσελθόντα καὶ ἐπιθέντα αὐτῷ ⸀χεῖραςὅπως ἀναβλέψῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ἀπεκρίθη δὲ Ἁνανίας· Κύριε, ⸀ἤκουσαἀπὸ πολλῶν περὶ τοῦ ἀνδρὸς τούτου, ὅσα κακὰ ⸂τοῖς ἁγίοις σου ἐποίησεν ἐν Ἰερουσαλήμ· ");
INSERT INTO grcsbl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","καὶ ὧδε ἔχει ἐξουσίαν παρὰ τῶν ἀρχιερέων δῆσαι πάντας τοὺς ἐπικαλουμένους τὸ ὄνομά σου. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","εἶπεν δὲ πρὸς αὐτὸν ὁ κύριος· Πορεύου, ὅτι σκεῦος ἐκλογῆς ⸂ἐστίν μοι οὗτος τοῦ βαστάσαι τὸ ὄνομά μου ἐνώπιον ⸀ἐθνῶν⸀τεκαὶ βασιλέων υἱῶν τε Ἰσραήλ, ");
INSERT INTO grcsbl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ἐγὼ γὰρ ὑποδείξω αὐτῷ ὅσα δεῖ αὐτὸν ὑπὲρ τοῦ ὀνόματός μου παθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ἀπῆλθεν δὲ Ἁνανίας καὶ εἰσῆλθεν εἰς τὴν οἰκίαν, καὶ ἐπιθεὶς ἐπʼ αὐτὸν τὰς χεῖρας εἶπεν· Σαοὺλ ἀδελφέ, ὁ κύριος ἀπέσταλκέν με, ⸀Ἰησοῦςὁ ὀφθείς σοι ἐν τῇ ὁδῷ ᾗ ἤρχου, ὅπως ἀναβλέψῃς καὶ πλησθῇς πνεύματος ἁγίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","καὶ εὐθέως ἀπέπεσαν ⸂αὐτοῦ ἀπὸ τῶν ὀφθαλμῶν ⸀ὡςλεπίδες, ἀνέβλεψέν τε καὶ ἀναστὰς ἐβαπτίσθη, ");
INSERT INTO grcsbl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","καὶ λαβὼν τροφὴν ⸀ἐνίσχυσεν Ἐγένετο ⸀δὲμετὰ τῶν ἐν Δαμασκῷ μαθητῶν ἡμέρας τινὰς, ");
INSERT INTO grcsbl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","καὶ εὐθέως ἐν ταῖς συναγωγαῖς ἐκήρυσσεν τὸν ⸀Ἰησοῦνὅτι οὗτός ἐστιν ὁ υἱὸς τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ἐξίσταντο δὲ πάντες οἱ ἀκούοντες καὶ ἔλεγον· Οὐχ οὗτός ἐστιν ὁ πορθήσας ⸀ἐνἸερουσαλὴμ τοὺς ἐπικαλουμένους τὸ ὄνομα τοῦτο, καὶ ὧδε εἰς τοῦτο ἐληλύθει ἵνα δεδεμένους αὐτοὺς ἀγάγῃ ἐπὶ τοὺς ἀρχιερεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Σαῦλος δὲ μᾶλλον ἐνεδυναμοῦτο καὶ ⸀συνέχυννεν⸀τοὺςἸουδαίους τοὺς κατοικοῦντας ἐν Δαμασκῷ, συμβιβάζων ὅτι οὗτός ἐστιν ὁ χριστός. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ὡς δὲ ἐπληροῦντο ἡμέραι ἱκαναί, συνεβουλεύσαντο οἱ Ἰουδαῖοι ἀνελεῖν αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ἐγνώσθη δὲ τῷ Σαύλῳ ἡ ἐπιβουλὴ αὐτῶν. ⸂παρετηροῦντο δὲ καὶ τὰς πύλας ἡμέρας τε καὶ νυκτὸς ὅπως αὐτὸν ἀνέλωσιν· ");
INSERT INTO grcsbl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","λαβόντες δὲ ⸂οἱ μαθηταὶ αὐτοῦ νυκτὸς ⸂διὰ τοῦ τείχους καθῆκαν αὐτὸν χαλάσαντες ἐν σπυρίδι. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Παραγενόμενος δὲ ⸀εἰςἸερουσαλὴμ ⸀ἐπείραζενκολλᾶσθαι τοῖς μαθηταῖς· καὶ πάντες ἐφοβοῦντο αὐτόν, μὴ πιστεύοντες ὅτι ἐστὶν μαθητής. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Βαρναβᾶς δὲ ἐπιλαβόμενος αὐτὸν ἤγαγεν πρὸς τοὺς ἀποστόλους, καὶ διηγήσατο αὐτοῖς πῶς ἐν τῇ ὁδῷ εἶδεν τὸν κύριον καὶ ὅτι ἐλάλησεν αὐτῷ καὶ πῶς ἐν Δαμασκῷ ἐπαρρησιάσατο ἐν τῷ ὀνόματι ⸀τοῦἸησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","καὶ ἦν μετʼ αὐτῶν εἰσπορευόμενος ⸂καὶ ἐκπορευόμενος εἰς ⸀Ἰερουσαλήμ παρρησιαζόμενος ἐν τῷ ὀνόματι τοῦ ⸀κυρίου ");
INSERT INTO grcsbl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ἐλάλει τε καὶ συνεζήτει πρὸς τοὺς Ἑλληνιστάς· οἱ δὲ ἐπεχείρουν ⸂ἀνελεῖν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ἐπιγνόντες δὲ οἱ ἀδελφοὶ κατήγαγον αὐτὸν εἰς Καισάρειαν καὶ ἐξαπέστειλαν αὐτὸν εἰς Ταρσόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","⸂Ἡ μὲν οὖν ἐκκλησία καθʼ ὅλης τῆς Ἰουδαίας καὶ Γαλιλαίας καὶ Σαμαρείας εἶχεν εἰρήνην οἰκοδομουμένη, καὶ πορευομένη τῷ φόβῳ τοῦ κυρίου καὶ τῇ παρακλήσει τοῦ ἁγίου πνεύματος ἐπληθύνετο. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ἐγένετο δὲ Πέτρον διερχόμενον διὰ πάντων κατελθεῖν καὶ πρὸς τοὺς ἁγίους τοὺς κατοικοῦντας Λύδδα. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","εὗρεν δὲ ἐκεῖ ἄνθρωπόν τινα ⸂ὀνόματι Αἰνέαν ἐξ ἐτῶν ὀκτὼ κατακείμενον ἐπὶ ⸀κραβάττου ὃς ἦν παραλελυμένος. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","καὶ εἶπεν αὐτῷ ὁ Πέτρος· Αἰνέα, ἰᾶταί σε Ἰησοῦς ⸀Χριστός ἀνάστηθι καὶ στρῶσον σεαυτῷ· καὶ εὐθέως ἀνέστη. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","καὶ εἶδαν αὐτὸν πάντες οἱ κατοικοῦντες Λύδδα καὶ τὸν ⸀Σαρῶνα οἵτινες ἐπέστρεψαν ἐπὶ τὸν κύριον. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ἐν Ἰόππῃ δέ τις ἦν μαθήτρια ὀνόματι Ταβιθά, ἣ διερμηνευομένη λέγεται Δορκάς· αὕτη ἦν πλήρης ⸂ἔργων ἀγαθῶν καὶ ἐλεημοσυνῶν ὧν ἐποίει. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ἐγένετο δὲ ἐν ταῖς ἡμέραις ἐκείναις ἀσθενήσασαν αὐτὴν ἀποθανεῖν· λούσαντες δὲ ⸂ἔθηκαν αὐτὴν ἐν ὑπερῴῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ἐγγὺς δὲ οὔσης Λύδδας τῇ Ἰόππῃ οἱ μαθηταὶ ἀκούσαντες ὅτι Πέτρος ἐστὶν ἐν αὐτῇ ἀπέστειλαν ⸂δύο ἄνδρας πρὸς αὐτὸν παρακαλοῦντες· Μὴ ⸀ὀκνήσῃςδιελθεῖν ἕως ⸀ἡμῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ἀναστὰς δὲ Πέτρος συνῆλθεν αὐτοῖς· ὃν παραγενόμενον ἀνήγαγον εἰς τὸ ὑπερῷον, καὶ παρέστησαν αὐτῷ πᾶσαι αἱ χῆραι κλαίουσαι καὶ ἐπιδεικνύμεναι χιτῶνας καὶ ἱμάτια ὅσα ἐποίει μετʼ αὐτῶν οὖσα ἡ Δορκάς. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ἐκβαλὼν δὲ ἔξω πάντας ὁ Πέτρος ⸀καὶθεὶς τὰ γόνατα προσηύξατο, καὶ ἐπιστρέψας πρὸς τὸ σῶμα εἶπεν· Ταβιθά, ἀνάστηθι. ἡ δὲ ἤνοιξεν τοὺς ὀφθαλμοὺς αὐτῆς, καὶ ἰδοῦσα τὸν Πέτρον ἀνεκάθισεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","δοὺς δὲ αὐτῇ χεῖρα ἀνέστησεν αὐτήν, φωνήσας δὲ τοὺς ἁγίους καὶ τὰς χήρας παρέστησεν αὐτὴν ζῶσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","γνωστὸν δὲ ἐγένετο καθʼ ὅλης ⸀τῆςἸόππης, καὶ ⸂ἐπίστευσαν πολλοὶ ἐπὶ τὸν κύριον. ");
INSERT INTO grcsbl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ἐγένετο ⸀δὲἡμέρας ἱκανὰς ⸀μεῖναιἐν Ἰόππῃ παρά τινι Σίμωνι βυρσεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ἀνὴρ δέ ⸀τιςἐν Καισαρείᾳ ὀνόματι Κορνήλιος, ἑκατοντάρχης ἐκ σπείρης τῆς καλουμένης Ἰταλικῆς, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","εὐσεβὴς καὶ φοβούμενος τὸν θεὸν σὺν παντὶ τῷ οἴκῳ αὐτοῦ, ⸀ποιῶνἐλεημοσύνας πολλὰς τῷ λαῷ καὶ δεόμενος τοῦ θεοῦ διὰ παντός, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","εἶδεν ἐν ὁράματι φανερῶς ὡσεὶ ⸀περὶὥραν ἐνάτην τῆς ἡμέρας ἄγγελον τοῦ θεοῦ εἰσελθόντα πρὸς αὐτὸν καὶ εἰπόντα αὐτῷ· Κορνήλιε. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ὁ δὲ ἀτενίσας αὐτῷ καὶ ἔμφοβος γενόμενος εἶπεν· Τί ἐστιν, κύριε; εἶπεν δὲ αὐτῷ· Αἱ προσευχαί σου καὶ αἱ ἐλεημοσύναι σου ἀνέβησαν εἰς μνημόσυνον ⸀ἔμπροσθεντοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","καὶ νῦν πέμψον ⸂ἄνδρας εἰς Ἰόππην καὶ μετάπεμψαι Σίμωνά ⸂τινα ὃς ἐπικαλεῖται Πέτρος· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","οὗτος ξενίζεται παρά τινι Σίμωνι βυρσεῖ, ᾧ ἐστιν οἰκία παρὰ θάλασσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ὡς δὲ ἀπῆλθεν ὁ ἄγγελος ὁ λαλῶν ⸀αὐτῷ φωνήσας δύο τῶν ⸀οἰκετῶνκαὶ στρατιώτην εὐσεβῆ τῶν προσκαρτερούντων αὐτῷ ");
INSERT INTO grcsbl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","καὶ ἐξηγησάμενος ⸂ἅπαντα αὐτοῖς ἀπέστειλεν αὐτοὺς εἰς τὴν Ἰόππην. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Τῇ δὲ ἐπαύριον ὁδοιπορούντων ἐκείνων καὶ τῇ πόλει ἐγγιζόντων ἀνέβη Πέτρος ἐπὶ τὸ δῶμα προσεύξασθαι περὶ ὥραν ἕκτην. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ἐγένετο δὲ πρόσπεινος καὶ ἤθελεν γεύσασθαι· παρασκευαζόντων δὲ ⸀αὐτῶν⸀ἐγένετοἐπʼ αὐτὸν ἔκστασις, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","καὶ θεωρεῖ τὸν οὐρανὸν ἀνεῳγμένον καὶ ⸀καταβαῖνονσκεῦός τι ὡς ὀθόνην μεγάλην τέσσαρσιν ⸀ἀρχαῖςκαθιέμενον ἐπὶ τῆς γῆς, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ἐν ᾧ ὑπῆρχεν πάντα τὰ τετράποδα ⸂καὶ ἑρπετὰ τῆς γῆς καὶ πετεινὰ τοῦ οὐρανοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","καὶ ἐγένετο φωνὴ πρὸς αὐτόν· Ἀναστάς, Πέτρε, θῦσον καὶ φάγε. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ὁ δὲ Πέτρος εἶπεν· Μηδαμῶς, κύριε, ὅτι οὐδέποτε ἔφαγον πᾶν κοινὸν ⸀καὶἀκάθαρτον. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","καὶ φωνὴ πάλιν ἐκ δευτέρου πρὸς αὐτόν· Ἃ ὁ θεὸς ἐκαθάρισεν σὺ μὴ κοίνου. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","τοῦτο δὲ ἐγένετο ἐπὶ τρίς, καὶ ⸀εὐθὺςἀνελήμφθη τὸ σκεῦος εἰς τὸν οὐρανόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ὡς δὲ ἐν ἑαυτῷ διηπόρει ὁ Πέτρος τί ἂν εἴη τὸ ὅραμα ὃ εἶδεν, ⸀ἰδοὺοἱ ἄνδρες οἱ ἀπεσταλμένοι ⸀ὑπὸτοῦΚορνηλίου διερωτήσαντες τὴν οἰκίαν ⸀τοῦ Σίμωνος ἐπέστησαν ἐπὶ τὸν πυλῶνα, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","καὶ φωνήσαντες ⸀ἐπυνθάνοντοεἰ Σίμων ὁ ἐπικαλούμενος Πέτρος ἐνθάδε ξενίζεται. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","τοῦ δὲ Πέτρου διενθυμουμένου περὶ τοῦ ὁράματος εἶπεν ⸂αὐτῷ τὸ πνεῦμα· Ἰδοὺ ⸀ἄνδρες⸀ζητοῦντέςσε· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ἀλλὰ ἀναστὰς κατάβηθι καὶ πορεύου σὺν αὐτοῖς μηδὲν διακρινόμενος, ⸀ὅτιἐγὼ ἀπέσταλκα αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","καταβὰς δὲ Πέτρος πρὸς τοὺς ἄνδρας εἶπεν· Ἰδοὺ ἐγώ εἰμι ὃν ζητεῖτε· τίς ἡ αἰτία διʼ ἣν πάρεστε; ");
INSERT INTO grcsbl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","οἱ δὲ εἶπαν· Κορνήλιος ἑκατοντάρχης, ἀνὴρ δίκαιος καὶ φοβούμενος τὸν θεὸν μαρτυρούμενός τε ὑπὸ ὅλου τοῦ ἔθνους τῶν Ἰουδαίων, ἐχρηματίσθη ὑπὸ ἀγγέλου ἁγίου μεταπέμψασθαί σε εἰς τὸν οἶκον αὐτοῦ καὶ ἀκοῦσαι ῥήματα παρὰ σοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","εἰσκαλεσάμενος οὖν αὐτοὺς ἐξένισεν. Τῇ δὲ ἐπαύριον ⸀ἀναστὰς ἐξῆλθεν σὺν αὐτοῖς, καί τινες τῶν ἀδελφῶν τῶν ἀπὸ Ἰόππης συνῆλθον αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","⸂τῇ δὲ ἐπαύριον ⸀εἰσῆλθενεἰς τὴν Καισάρειαν. ὁ δὲ Κορνήλιος ἦν προσδοκῶν αὐτοὺς συγκαλεσάμενος τοὺς συγγενεῖς αὐτοῦ καὶ τοὺς ἀναγκαίους φίλους. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ὡς δὲ ἐγένετο τοῦ εἰσελθεῖν τὸν Πέτρον, συναντήσας αὐτῷ ὁ Κορνήλιος πεσὼν ἐπὶ τοὺς πόδας προσεκύνησεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ὁ δὲ Πέτρος ⸂ἤγειρεν αὐτὸν λέγων· Ἀνάστηθι· καὶ ἐγὼ αὐτὸς ἄνθρωπός εἰμι. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","καὶ συνομιλῶν αὐτῷ εἰσῆλθεν, καὶ εὑρίσκει συνεληλυθότας πολλούς, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ἔφη τε πρὸς αὐτούς· Ὑμεῖς ἐπίστασθε ὡς ἀθέμιτόν ἐστιν ἀνδρὶ Ἰουδαίῳ κολλᾶσθαι ἢ προσέρχεσθαι ἀλλοφύλῳ· κἀμοὶ ὁ θεὸς ἔδειξεν μηδένα κοινὸν ἢ ἀκάθαρτον λέγειν ἄνθρωπον· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","διὸ καὶ ἀναντιρρήτως ἦλθον μεταπεμφθείς. πυνθάνομαι οὖν τίνι λόγῳ μετεπέμψασθέ με. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Καὶ ὁ Κορνήλιος ἔφη· Ἀπὸ τετάρτης ἡμέρας μέχρι ταύτης τῆς ὥρας ⸀ἤμηντὴν ⸀ἐνάτηνπροσευχόμενος ἐν τῷ οἴκῳ μου, καὶ ἰδοὺ ἀνὴρ ἔστη ἐνώπιόν μου ἐν ἐσθῆτι λαμπρᾷ ");
INSERT INTO grcsbl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","καὶ φησί· Κορνήλιε, εἰσηκούσθη σου ἡ προσευχὴ καὶ αἱ ἐλεημοσύναι σου ἐμνήσθησαν ἐνώπιον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","πέμψον οὖν εἰς Ἰόππην καὶ μετακάλεσαι Σίμωνα ὃς ἐπικαλεῖται Πέτρος· οὗτος ξενίζεται ἐν οἰκίᾳ Σίμωνος βυρσέως παρὰ ⸀θάλασσαν ");
INSERT INTO grcsbl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ἐξαυτῆς οὖν ἔπεμψα πρὸς σέ, σύ τε καλῶς ἐποίησας παραγενόμενος. νῦν οὖν πάντες ἡμεῖς ἐνώπιον τοῦ θεοῦ πάρεσμεν ἀκοῦσαι πάντα τὰ προστεταγμένα σοι ὑπὸ τοῦ ⸀κυρίου ");
INSERT INTO grcsbl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ἀνοίξας δὲ Πέτρος τὸ στόμα εἶπεν· Ἐπʼ ἀληθείας καταλαμβάνομαι ὅτι οὐκ ἔστιν προσωπολήμπτης ὁ θεός, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ἀλλʼ ἐν παντὶ ἔθνει ὁ φοβούμενος αὐτὸν καὶ ἐργαζόμενος δικαιοσύνην δεκτὸς αὐτῷ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","τὸν λόγον ⸀ὃνἀπέστειλεν τοῖς υἱοῖς Ἰσραὴλ εὐαγγελιζόμενος εἰρήνην διὰ Ἰησοῦ Χριστοῦ· οὗτός ἐστιν πάντων κύριος. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ὑμεῖς οἴδατε τὸ γενόμενον ῥῆμα καθʼ ὅλης τῆς Ἰουδαίας, ⸀ἀρξάμενοςἀπὸ τῆς Γαλιλαίας μετὰ τὸ βάπτισμα ὃ ἐκήρυξεν Ἰωάννης, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ἰησοῦν τὸν ἀπὸ Ναζαρέθ, ὡς ἔχρισεν αὐτὸν ὁ θεὸς πνεύματι ἁγίῳ καὶ δυνάμει, ὃς διῆλθεν εὐεργετῶν καὶ ἰώμενος πάντας τοὺς καταδυναστευομένους ὑπὸ τοῦ διαβόλου, ὅτι ὁ θεὸς ἦν μετʼ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","καὶ ⸀ἡμεῖςμάρτυρες πάντων ὧν ἐποίησεν ἔν τε τῇ χώρᾳ τῶν Ἰουδαίων ⸀καὶἸερουσαλήμ· ὃν καὶ ἀνεῖλαν κρεμάσαντες ἐπὶ ξύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","τοῦτον ὁ θεὸς ἤγειρεν ⸀τῇτρίτῃ ἡμέρᾳ καὶ ἔδωκεν αὐτὸν ἐμφανῆ γενέσθαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","οὐ παντὶ τῷ λαῷ ἀλλὰ μάρτυσι τοῖς προκεχειροτονημένοις ὑπὸ τοῦ θεοῦ, ἡμῖν, οἵτινες συνεφάγομεν καὶ συνεπίομεν αὐτῷ μετὰ τὸ ἀναστῆναι αὐτὸν ἐκ νεκρῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","καὶ παρήγγειλεν ἡμῖν κηρύξαι τῷ λαῷ καὶ διαμαρτύρασθαι ὅτι ⸀οὗτόςἐστιν ὁ ὡρισμένος ὑπὸ τοῦ θεοῦ κριτὴς ζώντων καὶ νεκρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","τούτῳ πάντες οἱ προφῆται μαρτυροῦσιν, ἄφεσιν ἁμαρτιῶν λαβεῖν διὰ τοῦ ὀνόματος αὐτοῦ πάντα τὸν πιστεύοντα εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ἔτι λαλοῦντος τοῦ Πέτρου τὰ ῥήματα ταῦτα ἐπέπεσε τὸ πνεῦμα τὸ ἅγιον ἐπὶ πάντας τοὺς ἀκούοντας τὸν λόγον. ");
INSERT INTO grcsbl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","καὶ ἐξέστησαν οἱ ἐκ περιτομῆς πιστοὶ ⸀ὅσοισυνῆλθαν τῷ Πέτρῳ, ὅτι καὶ ἐπὶ τὰ ἔθνη ἡ δωρεὰ τοῦ ⸂ἁγίου πνεύματος ἐκκέχυται· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ἤκουον γὰρ αὐτῶν λαλούντων γλώσσαις καὶ μεγαλυνόντων τὸν θεόν. τότε ⸀ἀπεκρίθηΠέτρος· ");
INSERT INTO grcsbl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Μήτι τὸ ὕδωρ ⸂δύναται κωλῦσαί τις τοῦ μὴ βαπτισθῆναι τούτους οἵτινες τὸ πνεῦμα τὸ ἅγιον ἔλαβον ⸀ὡςκαὶ ἡμεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","προσέταξεν ⸀δὲαὐτοὺς ⸂ἐν τῷ ὀνόματι Ἰησοῦ Χριστοῦ βαπτισθῆναι. τότε ἠρώτησαν αὐτὸν ἐπιμεῖναι ἡμέρας τινάς. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ἤκουσαν δὲ οἱ ἀπόστολοι καὶ οἱ ἀδελφοὶ οἱ ὄντες κατὰ τὴν Ἰουδαίαν ὅτι καὶ τὰ ἔθνη ἐδέξαντο τὸν λόγον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","⸂ὅτε δὲ ἀνέβη Πέτρος εἰς ⸀Ἰερουσαλήμ διεκρίνοντο πρὸς αὐτὸν οἱ ἐκ περιτομῆς ");
INSERT INTO grcsbl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","λέγοντες ὅτι ⸂Εἰσῆλθες πρὸς ἄνδρας ἀκροβυστίαν ἔχοντας καὶ συνέφαγες αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ἀρξάμενος ⸀δὲΠέτρος ἐξετίθετο αὐτοῖς καθεξῆς λέγων· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ἐγὼ ἤμην ἐν πόλει Ἰόππῃ προσευχόμενος καὶ εἶδον ἐν ἐκστάσει ὅραμα, καταβαῖνον σκεῦός τι ὡς ὀθόνην μεγάλην τέσσαρσιν ἀρχαῖς καθιεμένην ἐκ τοῦ οὐρανοῦ, καὶ ἦλθεν ἄχρι ἐμοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","εἰς ἣν ἀτενίσας κατενόουν καὶ εἶδον τὰ τετράποδα τῆς γῆς καὶ τὰ θηρία καὶ τὰ ἑρπετὰ καὶ τὰ πετεινὰ τοῦ οὐρανοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ἤκουσα δὲ ⸀καὶφωνῆς λεγούσης μοι· Ἀναστάς, Πέτρε, θῦσον καὶ φάγε. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","εἶπον δέ· Μηδαμῶς, κύριε, ⸀ὅτικοινὸν ἢ ἀκάθαρτον οὐδέποτε εἰσῆλθεν εἰς τὸ στόμα μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ἀπεκρίθη δὲ ⸂φωνὴ ἐκ δευτέρου ἐκ τοῦ οὐρανοῦ· Ἃ ὁ θεὸς ἐκαθάρισεν σὺ μὴ κοίνου. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","τοῦτο δὲ ἐγένετο ἐπὶ τρίς, καὶ ⸂ἀνεσπάσθη πάλιν ἅπαντα εἰς τὸν οὐρανόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","καὶ ἰδοὺ ἐξαυτῆς τρεῖς ἄνδρες ἐπέστησαν ἐπὶ τὴν οἰκίαν ἐν ᾗ ⸀ἦμεν ἀπεσταλμένοι ἀπὸ Καισαρείας πρός με. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","εἶπεν δὲ ⸂τὸ πνεῦμά μοι συνελθεῖν αὐτοῖς μηδὲν ⸀διακρίναντα ἦλθον δὲ σὺν ἐμοὶ καὶ οἱ ἓξ ἀδελφοὶ οὗτοι, καὶ εἰσήλθομεν εἰς τὸν οἶκον τοῦ ἀνδρός. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ἀπήγγειλεν ⸀δὲἡμῖν πῶς εἶδεν τὸν ἄγγελον ἐν τῷ οἴκῳ αὐτοῦ σταθέντα καὶ ⸀εἰπόντα Ἀπόστειλον εἰς ⸀Ἰόππηνκαὶ μετάπεμψαι Σίμωνα τὸν ἐπικαλούμενον Πέτρον, ");
INSERT INTO grcsbl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ὃς λαλήσει ῥήματα πρὸς σὲ ἐν οἷς σωθήσῃ σὺ καὶ πᾶς ὁ οἶκός σου. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ἐν δὲ τῷ ἄρξασθαί με λαλεῖν ἐπέπεσεν τὸ πνεῦμα τὸ ἅγιον ἐπʼ αὐτοὺς ὥσπερ καὶ ἐφʼ ἡμᾶς ἐν ἀρχῇ. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ἐμνήσθην δὲ τοῦῥήματος ⸀τοῦ κυρίου ὡς ἔλεγεν· Ἰωάννης μὲν ἐβάπτισεν ὕδατι, ὑμεῖς δὲ βαπτισθήσεσθε ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","εἰ οὖν τὴν ἴσην δωρεὰν ἔδωκεν αὐτοῖς ὁ θεὸς ὡς καὶ ἡμῖν πιστεύσασιν ἐπὶ τὸν κύριον Ἰησοῦν Χριστόν, ⸀ἐγὼτίς ἤμην δυνατὸς κωλῦσαι τὸν θεόν; ");
INSERT INTO grcsbl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ἀκούσαντες δὲ ταῦτα ἡσύχασαν καὶ ⸀ἐδόξασαντὸν θεὸν λέγοντες· ⸀Ἄρακαὶ τοῖς ἔθνεσιν ὁ θεὸς τὴν μετάνοιαν ⸂εἰς ζωὴν ἔδωκεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Οἱ μὲν οὖν διασπαρέντες ἀπὸ τῆς θλίψεως τῆς γενομένης ἐπὶ Στεφάνῳ διῆλθον ἕως Φοινίκης καὶ Κύπρου καὶ Ἀντιοχείας μηδενὶ λαλοῦντες τὸν λόγον εἰ μὴ μόνον Ἰουδαίοις. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ἦσαν δέ τινες ἐξ αὐτῶν ἄνδρες Κύπριοι καὶ Κυρηναῖοι, οἵτινες ⸀ἐλθόντεςεἰς Ἀντιόχειαν ἐλάλουν ⸀καὶπρὸς τοὺς ⸀Ἑλληνιστάς εὐαγγελιζόμενοι τὸν κύριον Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","καὶ ἦν χεὶρ κυρίου μετʼ αὐτῶν, πολύς τε ἀριθμὸς ⸀ὁπιστεύσας ἐπέστρεψεν ἐπὶ τὸν κύριον. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ἠκούσθη δὲ ὁ λόγος εἰς τὰ ὦτα τῆς ἐκκλησίας τῆς ⸀οὔσηςἐν ⸀Ἰερουσαλὴμπερὶ αὐτῶν, καὶ ἐξαπέστειλαν ⸀Βαρναβᾶνἕως Ἀντιοχείας· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ὃς παραγενόμενος καὶ ἰδὼν τὴνχάριν ⸀τὴν τοῦ θεοῦ, ἐχάρη καὶ παρεκάλει πάντας τῇ προθέσει τῆς καρδίας ⸀προσμένειντῷ κυρίῳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ὅτι ἦν ἀνὴρ ἀγαθὸς καὶ πλήρης πνεύματος ἁγίου καὶ πίστεως. καὶ προσετέθη ὄχλος ἱκανὸς τῷ κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ἐξῆλθεν δὲ εἰς ⸀Ταρσὸνἀναζητῆσαι Σαῦλον, ");
INSERT INTO grcsbl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","καὶ εὑρὼν ⸀ἤγαγενεἰς Ἀντιόχειαν. ἐγένετο δὲ ⸂αὐτοῖς καὶ ἐναυτὸν ὅλον συναχθῆναι ⸀ἐν τῇ ἐκκλησίᾳ καὶ διδάξαι ὄχλον ἱκανόν, χρηματίσαι τε ⸀πρώτωςἐν Ἀντιοχείᾳ τοὺς μαθητὰς Χριστιανούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ἐν ταύταις δὲ ταῖς ἡμέραις κατῆλθον ἀπὸ Ἱεροσολύμων προφῆται εἰς Ἀντιόχειαν· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ἀναστὰς δὲ εἷς ἐξ αὐτῶν ὀνόματι Ἅγαβος ἐσήμανεν διὰ τοῦ πνεύματος λιμὸν ⸀μεγάληνμέλλειν ἔσεσθαι ἐφʼ ὅλην τὴν οἰκουμένην· ⸀ἥτιςἐγένετο ἐπὶ ⸀Κλαυδίου ");
INSERT INTO grcsbl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","τῶν δὲ μαθητῶν καθὼς εὐπορεῖτό τις ὥρισαν ἕκαστος αὐτῶν εἰς διακονίαν πέμψαι τοῖς κατοικοῦσιν ἐν τῇ Ἰουδαίᾳ ἀδελφοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ὃ καὶ ἐποίησαν ἀποστείλαντες πρὸς τοὺς πρεσβυτέρους διὰ χειρὸς Βαρναβᾶ καὶ Σαύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Κατʼ ἐκεῖνον δὲ τὸν καιρὸν ἐπέβαλεν Ἡρῴδης ὁ βασιλεὺς τὰς χεῖρας κακῶσαί τινας τῶν ἀπὸ τῆς ἐκκλησίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ἀνεῖλεν δὲ Ἰάκωβον τὸν ἀδελφὸν Ἰωάννου μαχαίρῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","⸂ἰδὼν δὲ ὅτι ἀρεστόν ἐστιν τοῖς Ἰουδαίοις προσέθετο συλλαβεῖν καὶ Πέτρον (ἦσαν ⸀δὲἡμέραι τῶν ἀζύμων), ");
INSERT INTO grcsbl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ὃν καὶ πιάσας ἔθετο εἰς φυλακήν, παραδοὺς τέσσαρσιν τετραδίοις στρατιωτῶν φυλάσσειν αὐτόν, βουλόμενος μετὰ τὸ πάσχα ἀναγαγεῖν αὐτὸν τῷ λαῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ὁ μὲν οὖν Πέτρος ἐτηρεῖτο ἐν τῇ φυλακῇ· προσευχὴ δὲ ἦν ⸀ἐκτενῶςγινομένη ὑπὸ τῆς ἐκκλησίας πρὸς τὸν θεὸν ⸀περὶαὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ὅτε δὲ ἤμελλεν ⸂προαγαγεῖν αὐτὸν ὁ Ἡρῴδης, τῇ νυκτὶ ἐκείνῃ ἦν ὁ Πέτρος κοιμώμενος μεταξὺ δύο στρατιωτῶν δεδεμένος ἁλύσεσιν δυσίν, φύλακές τε πρὸ τῆς θύρας ἐτήρουν τὴν φυλακήν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","καὶ ἰδοὺ ἄγγελος κυρίου ἐπέστη, καὶ φῶς ἔλαμψεν ἐν τῷ οἰκήματι· πατάξας δὲ τὴν πλευρὰν τοῦ Πέτρου ἤγειρεν αὐτὸν λέγων· Ἀνάστα ἐν τάχει· καὶ ἐξέπεσαν αὐτοῦ αἱ ἁλύσεις ἐκ τῶν χειρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","εἶπεν ⸀δὲὁ ἄγγελος πρὸς αὐτόν· ⸀Ζῶσαικαὶ ὑπόδησαι τὰ σανδάλιά σου· ἐποίησεν δὲ οὕτως. καὶ λέγει αὐτῷ· Περιβαλοῦ τὸ ἱμάτιόν σου καὶ ἀκολούθει μοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","καὶ ἐξελθὼν ⸀ἠκολούθει καὶ οὐκ ᾔδει ὅτι ἀληθές ἐστιν τὸ γινόμενον διὰ τοῦ ἀγγέλου, ἐδόκει δὲ ὅραμα βλέπειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","διελθόντες δὲ πρώτην φυλακὴν καὶ δευτέραν ἦλθαν ἐπὶ τὴν πύλην τὴν σιδηρᾶν τὴν φέρουσαν εἰς τὴν πόλιν, ἥτις αὐτομάτη ἠνοίγη αὐτοῖς, καὶ ἐξελθόντες προῆλθον ῥύμην μίαν, καὶ εὐθέως ἀπέστη ὁ ἄγγελος ἀπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","καὶ ὁ Πέτρος ⸂ἐν ἑαυτῷ γενόμενος εἶπεν· Νῦν οἶδα ἀληθῶς ὅτι ἐξαπέστειλεν ⸀ὁκύριος τὸν ἄγγελον αὐτοῦ καὶ ἐξείλατό με ἐκ χειρὸς Ἡρῴδου καὶ πάσης τῆς προσδοκίας τοῦ λαοῦ τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Συνιδών τε ἦλθεν ἐπὶ τὴν οἰκίαν ⸀τῆςΜαρίας τῆς μητρὸς Ἰωάννου τοῦ ἐπικαλουμένου Μάρκου, οὗ ἦσαν ἱκανοὶ συνηθροισμένοι καὶ προσευχόμενοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","κρούσαντος δὲ ⸀αὐτοῦτὴν θύραν τοῦ πυλῶνος προσῆλθε παιδίσκη ὑπακοῦσαι ὀνόματι Ῥόδη, ");
INSERT INTO grcsbl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","καὶ ἐπιγνοῦσα τὴν φωνὴν τοῦ Πέτρου ἀπὸ τῆς χαρᾶς οὐκ ἤνοιξεν τὸν πυλῶνα, εἰσδραμοῦσα δὲ ἀπήγγειλεν ἑστάναι τὸν Πέτρον πρὸ τοῦ πυλῶνος. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","οἱ δὲ πρὸς αὐτὴν εἶπαν· Μαίνῃ. ἡ δὲ διϊσχυρίζετο οὕτως ἔχειν. οἱ δὲ ἔλεγον· Ὁ ἄγγελός ⸂ἐστιν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ὁ δὲ Πέτρος ἐπέμενεν κρούων· ἀνοίξαντες δὲ εἶδαν αὐτὸν καὶ ἐξέστησαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","κατασείσας δὲ αὐτοῖς τῇ χειρὶ σιγᾶν διηγήσατο αὐτοῖς πῶς ὁ κύριος αὐτὸν ἐξήγαγεν ἐκ τῆς φυλακῆς, εἶπέν ⸀τε Ἀπαγγείλατε Ἰακώβῳ καὶ τοῖς ἀδελφοῖς ταῦτα. καὶ ἐξελθὼν ἐπορεύθη εἰς ἕτερον τόπον. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Γενομένης δὲ ἡμέρας ἦν τάραχος οὐκ ὀλίγος ἐν τοῖς στρατιώταις, τί ἄρα ὁ Πέτρος ἐγένετο. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ἡρῴδης δὲ ἐπιζητήσας αὐτὸν καὶ μὴ εὑρὼν ἀνακρίνας τοὺς φύλακας ἐκέλευσεν ἀπαχθῆναι, καὶ κατελθὼν ἀπὸ τῆς Ἰουδαίας ⸀εἰςΚαισάρειαν διέτριβεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ἦν ⸀δὲθυμομαχῶν Τυρίοις καὶ Σιδωνίοις· ὁμοθυμαδὸν δὲ παρῆσαν πρὸς αὐτόν, καὶ πείσαντες Βλάστον τὸν ἐπὶ τοῦ κοιτῶνος τοῦ βασιλέως ᾐτοῦντο εἰρήνην διὰ τὸ τρέφεσθαι αὐτῶν τὴν χώραν ἀπὸ τῆς βασιλικῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","τακτῇ δὲ ἡμέρᾳ ὁ Ἡρῴδης ἐνδυσάμενος ἐσθῆτα βασιλικὴν ⸀καὶκαθίσας ἐπὶ τοῦ βήματος ἐδημηγόρει πρὸς αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ὁ δὲ δῆμος ἐπεφώνει· ⸂Θεοῦ φωνὴ καὶ οὐκ ἀνθρώπου. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","παραχρῆμα δὲ ἐπάταξεν αὐτὸν ἄγγελος κυρίου ἀνθʼ ὧν οὐκ ἔδωκεν ⸀τὴνδόξαν τῷ θεῷ, καὶ γενόμενος σκωληκόβρωτος ἐξέψυξεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ὁ δὲ λόγος τοῦ ⸀θεοῦηὔξανεν καὶ ἐπληθύνετο. ");
INSERT INTO grcsbl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Βαρναβᾶς δὲ καὶ Σαῦλος ὑπέστρεψαν, ⸀εἰςἸερουσαλὴμ πληρώσαντες τὴν διακονίαν, ⸀συμπαραλαβόντεςἸωάννην τὸν ἐπικληθέντα Μᾶρκον. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ἦσαν ⸀δὲἐν Ἀντιοχείᾳ κατὰ τὴν οὖσαν ἐκκλησίαν προφῆται καὶ διδάσκαλοι ὅ τε Βαρναβᾶς καὶ Συμεὼν ὁ καλούμενος Νίγερ, καὶ Λούκιος ὁ Κυρηναῖος, Μαναήν τε Ἡρῴδου τοῦ τετραάρχου σύντροφος καὶ Σαῦλος. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","λειτουργούντων δὲ αὐτῶν τῷ κυρίῳ καὶνηστευόντων εἶπεν τὸ πνεῦμα τὸ ἅγιον· Ἀφορίσατε δή μοι τὸν Βαρναβᾶν ⸀καὶ Σαῦλον εἰς τὸ ἔργον ὃ προσκέκλημαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","τότε νηστεύσαντες καὶ προσευξάμενοι καὶ ἐπιθέντες τὰς χεῖρας αὐτοῖς ἀπέλυσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","⸀Αὐτοὶμὲν οὖν ἐκπεμφθέντες ὑπὸ τοῦ ⸂ἁγίου πνεύματος κατῆλθον ⸀εἰςΣελεύκειαν, ἐκεῖθέν ⸀τεἀπέπλευσαν ⸁εἰςΚύπρον, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","καὶ γενόμενοι ἐν Σαλαμῖνι κατήγγελλον τὸν λόγον τοῦ θεοῦ ἐν ταῖς συναγωγαῖς τῶν Ἰουδαίων· εἶχον δὲ καὶ Ἰωάννην ὑπηρέτην. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","διελθόντες δὲ ⸀ὅληντὴν νῆσον ἄχρι Πάφου εὗρον ⸀ἄνδρατινὰ μάγον ψευδοπροφήτην Ἰουδαῖον ᾧ ὄνομα ⸀Βαριησοῦ ");
INSERT INTO grcsbl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ὃς ἦν σὺν τῷ ἀνθυπάτῳ Σεργίῳ Παύλῳ, ἀνδρὶ συνετῷ. οὗτος προσκαλεσάμενος Βαρναβᾶν καὶ Σαῦλον ἐπεζήτησεν ἀκοῦσαι τὸν λόγον τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ἀνθίστατο δὲ αὐτοῖς Ἐλύμας ὁ μάγος, οὕτως γὰρ μεθερμηνεύεται τὸ ὄνομα αὐτοῦ, ζητῶν διαστρέψαι τὸν ἀνθύπατον ἀπὸ τῆς πίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Σαῦλος δέ, ὁ καὶ Παῦλος, πλησθεὶς πνεύματος ⸀ἁγίουἀτενίσας εἰς αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","εἶπεν· Ὦ πλήρης παντὸς δόλου καὶ πάσης ῥᾳδιουργίας, υἱὲ διαβόλου, ἐχθρὲ πάσης δικαιοσύνης, οὐ παύσῃ διαστρέφων τὰς ⸀ὁδοὺςκυρίου τὰς εὐθείας; ");
INSERT INTO grcsbl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","καὶ νῦν ἰδοὺ χεὶρ κυρίου ἐπὶ σέ, καὶ ἔσῃ τυφλὸς μὴ βλέπων τὸν ἥλιον ἄχρι καιροῦ. παραχρῆμα ⸀δὲ⸀ἔπεσενἐπʼ αὐτὸν ἀχλὺς καὶ σκότος, καὶ περιάγων ἐζήτει χειραγωγούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","τότε ἰδὼν ὁ ἀνθύπατος τὸ γεγονὸς ἐπίστευσεν ἐκπλησσόμενος ἐπὶ τῇ διδαχῇ τοῦ κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ἀναχθέντες δὲ ἀπὸ τῆς Πάφου οἱ ⸀περὶΠαῦλον ἦλθον εἰς Πέργην τῆς Παμφυλίας· Ἰωάννης δὲ ἀποχωρήσας ἀπʼ αὐτῶν ὑπέστρεψεν εἰς Ἱεροσόλυμα. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","αὐτοὶ δὲ διελθόντες ἀπὸ τῆς Πέργης παρεγένοντο εἰς Ἀντιόχειαν ⸂τὴν Πισιδίαν, καὶ ⸀εἰσελθόντεςεἰς τὴν συναγωγὴν τῇ ἡμέρᾳ τῶν σαββάτων ἐκάθισαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","μετὰ δὲ τὴν ἀνάγνωσιν τοῦ νόμου καὶ τῶν προφητῶν ἀπέστειλαν οἱ ἀρχισυνάγωγοι πρὸς αὐτοὺς λέγοντες· Ἄνδρες ἀδελφοί, εἴ ⸀τίςἐστιν ⸂ἐν ὑμῖν λόγος παρακλήσεως πρὸς τὸν λαόν, λέγετε. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ἀναστὰς δὲ Παῦλος καὶ κατασείσας τῇ χειρὶ εἶπεν· Ἄνδρες Ἰσραηλῖται καὶ οἱ φοβούμενοι τὸν θεόν, ἀκούσατε. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ὁ θεὸς τοῦ λαοῦ τούτου ⸀Ἰσραὴλἐξελέξατο τοὺς πατέρας ἡμῶν, καὶ τὸν λαὸν ὕψωσεν ἐν τῇ παροικίᾳ ἐν γῇ ⸀Αἰγύπτου καὶ μετὰ βραχίονος ὑψηλοῦ ἐξήγαγεν αὐτοὺς ἐξ αὐτῆς, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","καί, ὡς τεσσερακονταετῆ χρόνον ἐτροποφόρησεν αὐτοὺς ἐν τῇ ἐρήμῳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","⸀καὶκαθελὼν ἔθνη ἑπτὰ ἐν γῇ Χανάαν ⸀κατεκληρονόμησεντὴν γῆν αὐτῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","⸂ὡς ἔτεσι τετρακοσίοις καὶ πεντήκοντα. καὶ μετὰ ταῦτα⸃ ἔδωκεν κριτὰς ἕως Σαμουὴλ ⸀τοῦ προφήτου. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","κἀκεῖθεν ᾐτήσαντο βασιλέα, καὶ ἔδωκεν αὐτοῖς ὁ θεὸς τὸν Σαοὺλ υἱὸν Κίς, ἄνδρα ἐκ φυλῆς Βενιαμίν, ἔτη τεσσεράκοντα· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","καὶ μεταστήσας αὐτὸν ἤγειρεν ⸂τὸν Δαυὶδ αὐτοῖς εἰς βασιλέα, ᾧ καὶ εἶπεν μαρτυρήσας· Εὗρον Δαυὶδ τὸν τοῦ Ἰεσσαί, ἄνδρα κατὰ τὴν καρδίαν μου, ὃς ποιήσει πάντα τὰ θελήματά μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","τούτου ὁ θεὸς ἀπὸ τοῦ σπέρματος κατʼ ἐπαγγελίαν ἤγαγεν τῷ Ἰσραὴλ ⸂σωτῆρα Ἰησοῦν, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","προκηρύξαντος Ἰωάννου πρὸ προσώπου τῆς εἰσόδου αὐτοῦ βάπτισμα μετανοίας ⸂παντὶ τῷ λαῷ Ἰσραήλ. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ὡς δὲ ἐπλήρου ⸀Ἰωάννηςτὸν δρόμον, ἔλεγεν· ⸂Τί ἐμὲ ὑπονοεῖτε εἶναι; οὐκ εἰμὶ ἐγώ· ἀλλʼ ἰδοὺ ἔρχεται μετʼ ἐμὲ οὗ οὐκ εἰμὶ ἄξιος τὸ ὑπόδημα τῶν ποδῶν λῦσαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ἄνδρες ἀδελφοί, υἱοὶ γένους Ἀβραὰμ καὶ οἱ ἐν ὑμῖν φοβούμενοι τὸν θεόν, ⸀ἡμῖνὁ λόγος τῆς σωτηρίας ταύτης ⸀ἐξαπεστάλη ");
INSERT INTO grcsbl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","οἱ γὰρ κατοικοῦντες ἐν Ἰερουσαλὴμ καὶ οἱ ἄρχοντες αὐτῶν τοῦτον ἀγνοήσαντες καὶ τὰς φωνὰς τῶν προφητῶν τὰς κατὰ πᾶν σάββατον ἀναγινωσκομένας κρίναντες ἐπλήρωσαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","καὶ μηδεμίαν αἰτίαν θανάτου εὑρόντες ᾐτήσαντο Πιλᾶτον ἀναιρεθῆναι αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ὡς δὲ ἐτέλεσαν πάντα τὰ περὶ αὐτοῦ γεγραμμένα, καθελόντες ἀπὸ τοῦ ξύλου ἔθηκαν εἰς μνημεῖον. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ὁ δὲ θεὸς ἤγειρεν αὐτὸν ἐκ νεκρῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ὃς ὤφθη ἐπὶ ἡμέρας πλείους τοῖς συναναβᾶσιν αὐτῷ ἀπὸ τῆς Γαλιλαίας εἰς Ἰερουσαλήμ, οἵτινες ⸀νῦνεἰσὶ μάρτυρες αὐτοῦ πρὸς τὸν λαόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","καὶ ἡμεῖς ὑμᾶς εὐαγγελιζόμεθα τὴν πρὸς τοὺς πατέρας ἐπαγγελίαν γενομένην ");
INSERT INTO grcsbl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ὅτι ταύτην ὁ θεὸς ἐκπεπλήρωκεν τοῖς τέκνοις ⸀ἡμῶνἀναστήσας Ἰησοῦν, ὡς καὶ ἐν τῷ ⸂ψαλμῷ γέγραπται τῷ δευτέρῳ· Υἱός μου εἶ σύ, ἐγὼ σήμερον γεγέννηκά σε. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ὅτι δὲ ἀνέστησεν αὐτὸν ἐκ νεκρῶν μηκέτι μέλλοντα ὑποστρέφειν εἰς διαφθοράν, οὕτως εἴρηκεν ὅτι Δώσω ὑμῖν τὰ ὅσια Δαυὶδ τὰ πιστά. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","⸀διότικαὶ ἐν ἑτέρῳ λέγει· Οὐ δώσεις τὸν ὅσιόν σου ἰδεῖν διαφθοράν· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Δαυὶδ μὲν γὰρ ἰδίᾳ γενεᾷ ὑπηρετήσας τῇ τοῦ θεοῦ βουλῇ ἐκοιμήθη καὶ προσετέθη πρὸς τοὺς πατέρας αὐτοῦ καὶ εἶδεν διαφθοράν, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ὃν δὲ ὁ θεὸς ἤγειρεν οὐκ εἶδεν διαφθοράν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","γνωστὸν οὖν ἔστω ὑμῖν, ἄνδρες ἀδελφοί, ὅτι διὰ τούτου ὑμῖν ἄφεσις ἁμαρτιῶν καταγγέλλεται, καὶ ἀπὸ πάντων ὧν οὐκ ἠδυνήθητε ⸀ἐννόμῳ Μωϋσέως δικαιωθῆναι ");
INSERT INTO grcsbl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ἐν τούτῳ πᾶς ὁ πιστεύων δικαιοῦται. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","βλέπετε οὖν μὴ ⸀ἐπέλθῃτὸ εἰρημένον ἐν τοῖς προφήταις· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ἴδετε, οἱ καταφρονηταί, καὶ θαυμάσατε καὶ ἀφανίσθητε, ὅτι ἔργον ⸂ἐργάζομαι ἐγὼ ἐν ταῖς ἡμέραις ὑμῶν, ⸀ἔργονὃ οὐ μὴ πιστεύσητε ἐάν τις ἐκδιηγῆται ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ἐξιόντων δὲ ⸀αὐτῶν⸀παρεκάλουνεἰς τὸ μεταξὺ σάββατον λαληθῆναι αὐτοῖς τὰ ῥήματα ⸀ταῦτα ");
INSERT INTO grcsbl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","λυθείσης δὲ τῆς συναγωγῆς ἠκολούθησαν πολλοὶ τῶν Ἰουδαίων καὶ τῶν σεβομένων προσηλύτων τῷ Παύλῳ καὶ τῷ Βαρναβᾷ, οἵτινες προσλαλοῦντες ⸀αὐτοῖςἔπειθον αὐτοὺς ⸀προσμένειντῇ χάριτι τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Τῷ ⸀δὲἐρχομένῳ σαββάτῳ σχεδὸν πᾶσα ἡ πόλις συνήχθη ἀκοῦσαι τὸν λόγον τοῦ ⸀κυρίου ");
INSERT INTO grcsbl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ἰδόντες δὲ οἱ Ἰουδαῖοι τοὺς ὄχλους ἐπλήσθησαν ζήλου καὶ ἀντέλεγον τοῖς ⸀ὑπὸΠαύλου ⸀λαλουμένοις⸀βλασφημοῦντες ");
INSERT INTO grcsbl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","παρρησιασάμενοί ⸀τεὁ Παῦλος καὶ ὁ Βαρναβᾶς εἶπαν· Ὑμῖν ἦν ἀναγκαῖον πρῶτον λαληθῆναι τὸν λόγον τοῦ θεοῦ· ⸀ἐπειδὴἀπωθεῖσθε αὐτὸν καὶ οὐκ ἀξίους κρίνετε ἑαυτοὺς τῆς αἰωνίου ζωῆς, ἰδοὺ στρεφόμεθα εἰς τὰ ἔθνη· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","οὕτως γὰρ ἐντέταλται ἡμῖν ὁ κύριος· Τέθεικά σε εἰς φῶς ἐθνῶν τοῦ εἶναί σε εἰς σωτηρίαν ἕως ἐσχάτου τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ἀκούοντα δὲ τὰ ἔθνη ⸀ἔχαιρονκαὶ ἐδόξαζον τὸν λόγον τοῦ ⸀κυρίου καὶ ἐπίστευσαν ὅσοι ἦσαν τεταγμένοι εἰς ζωὴν αἰώνιον· ");
INSERT INTO grcsbl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","διεφέρετο δὲ ὁ λόγος τοῦ κυρίου διʼ ὅλης τῆς χώρας. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","οἱ δὲ Ἰουδαῖοι παρώτρυναν τὰς σεβομένας ⸀γυναῖκαςτὰς εὐσχήμονας καὶτοὺς πρώτους τῆς πόλεως καὶ ἐπήγειραν διωγμὸν ἐπὶ τὸν Παῦλον ⸀καὶ Βαρναβᾶν, καὶ ἐξέβαλον αὐτοὺς ἀπὸ τῶν ὁρίων αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","οἱ δὲ ἐκτιναξάμενοι τὸν κονιορτὸν τῶν ⸀ποδῶνἐπʼ αὐτοὺς ἦλθον εἰς Ἰκόνιον, ");
INSERT INTO grcsbl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","οἵ ⸀τεμαθηταὶ ἐπληροῦντο χαρᾶς καὶ πνεύματος ἁγίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ἐγένετο δὲ ἐν Ἰκονίῳ κατὰ τὸ αὐτὸ εἰσελθεῖν αὐτοὺς εἰς τὴν συναγωγὴν τῶν Ἰουδαίων καὶ λαλῆσαι οὕτως ὥστε πιστεῦσαι Ἰουδαίων τε καὶ Ἑλλήνων πολὺ πλῆθος. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","οἱ δὲ ⸀ἀπειθήσαντεςἸουδαῖοι ἐπήγειραν καὶ ἐκάκωσαν τὰς ψυχὰς τῶν ἐθνῶν κατὰ τῶν ἀδελφῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ἱκανὸν μὲν οὖν χρόνον διέτριψαν παρρησιαζόμενοι ἐπὶ τῷκυρίῳ τῷ μαρτυροῦντι ⸀τῷ λόγῳ τῆς χάριτος αὐτοῦ, διδόντι σημεῖα καὶ τέρατα γίνεσθαι διὰ τῶν χειρῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ἐσχίσθη δὲ τὸ πλῆθος τῆς πόλεως, καὶ οἱ μὲν ἦσαν σὺν τοῖς Ἰουδαίοις οἱ δὲ σὺν τοῖς ἀποστόλοις. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ὡς δὲ ἐγένετο ὁρμὴ τῶν ἐθνῶν τε καὶ Ἰουδαίων σὺν τοῖς ἄρχουσιν αὐτῶν ὑβρίσαι καὶ λιθοβολῆσαι αὐτούς, ");
INSERT INTO grcsbl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","συνιδόντες κατέφυγον εἰς τὰς πόλεις τῆς Λυκαονίας Λύστραν καὶ Δέρβην καὶ τὴν περίχωρον, ");
INSERT INTO grcsbl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","κἀκεῖ ⸂εὐαγγελιζόμενοι ἦσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Καί τις ἀνὴρ ⸂ἀδύνατος ἐν Λύστροις τοῖς ποσὶν ἐκάθητο, χωλὸς ἐκ κοιλίας μητρὸς ⸀αὐτοῦ ὃς οὐδέποτε ⸀περιεπάτησεν ");
INSERT INTO grcsbl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","οὗτος ⸀ἤκουσεντοῦ Παύλου λαλοῦντος· ὃς ἀτενίσας αὐτῷ καὶ ἰδὼν ὅτι ⸂ἔχει πίστιν τοῦ σωθῆναι ");
INSERT INTO grcsbl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","εἶπεν ⸀μεγάλῃφωνῇ· Ἀνάστηθι ἐπὶ τοὺς πόδας σου ⸀ὀρθός καὶ ⸀ἥλατοκαὶ περιεπάτει. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","οἵ ⸀τεὄχλοι ἰδόντες ὃ ⸀ἐποίησενΠαῦλος ἐπῆραν τὴν φωνὴν αὐτῶν Λυκαονιστὶ λέγοντες· Οἱ θεοὶ ὁμοιωθέντες ἀνθρώποις κατέβησαν πρὸς ἡμᾶς ");
INSERT INTO grcsbl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ἐκάλουν τε ⸀τὸνΒαρναβᾶν Δία, τὸν δὲ Παῦλον Ἑρμῆν, ἐπειδὴ αὐτὸς ἦν ὁ ἡγούμενος τοῦ λόγου. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ὅ ⸀τεἱερεὺς τοῦ Διὸς τοῦ ὄντος πρὸ τῆς ⸀πόλεωςταύρους καὶ στέμματα ἐπὶ τοὺς πυλῶνας ἐνέγκας σὺν τοῖς ὄχλοις ἤθελεν θύειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ἀκούσαντες δὲ οἱ ἀπόστολοι Βαρναβᾶς καὶ Παῦλος, διαρρήξαντες τὰ ἱμάτια ⸀αὐτῶν⸀ἐξεπήδησανεἰς τὸν ὄχλον κράζοντες ");
INSERT INTO grcsbl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","καὶ λέγοντες· Ἄνδρες, τί ταῦτα ποιεῖτε; καὶ ἡμεῖς ὁμοιοπαθεῖς ἐσμεν ὑμῖν ἄνθρωποι, εὐαγγελιζόμενοι ὑμᾶς ἀπὸ τούτων τῶν ματαίων ἐπιστρέφειν ἐπὶ ⸀θεὸνζῶντα ὃς ἐποίησεν τὸν οὐρανὸν καὶ τὴν γῆν καὶ τὴν θάλασσαν καὶ πάντα τὰ ἐν αὐτοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ὃς ἐν ταῖς παρῳχημέναις γενεαῖς εἴασεν πάντα τὰ ἔθνη πορεύεσθαι ταῖς ὁδοῖς αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","⸀καίτοιοὐκ ἀμάρτυρον ⸀αὑτὸνἀφῆκεν ⸀ἀγαθουργῶν οὐρανόθεν ὑμῖν ὑετοὺς διδοὺς καὶ καιροὺς καρποφόρους, ἐμπιπλῶν τροφῆς καὶ εὐφροσύνης τὰς καρδίας ⸀ὑμῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","καὶ ταῦτα λέγοντες μόλις κατέπαυσαν τοὺς ὄχλους τοῦ μὴ θύειν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ἐπῆλθαν δὲ ἀπὸ Ἀντιοχείας καὶ Ἰκονίου Ἰουδαῖοι, καὶ πείσαντες τοὺς ὄχλους καὶ λιθάσαντες τὸν Παῦλον ἔσυρον ἔξω τῆς πόλεως, ⸀νομίζοντεςαὐτὸν τεθνηκέναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","κυκλωσάντων δὲ ⸂τῶν μαθητῶν αὐτὸν ἀναστὰς εἰσῆλθεν εἰς τὴν πόλιν. καὶ τῇ ἐπαύριον ἐξῆλθεν σὺν τῷ Βαρναβᾷ εἰς Δέρβην. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Εὐαγγελισάμενοί τε τὴν πόλιν ἐκείνην καὶ μαθητεύσαντες ἱκανοὺς ὑπέστρεψαν εἰς τὴν Λύστραν καὶ ⸀εἰςἸκόνιον καὶ ⸁εἰςἈντιόχειαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ἐπιστηρίζοντες τὰς ψυχὰς τῶν μαθητῶν, παρακαλοῦντες ἐμμένειν τῇ πίστει καὶ ὅτι διὰ πολλῶν θλίψεων δεῖ ἡμᾶς εἰσελθεῖν εἰς τὴν βασιλείαν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","χειροτονήσαντες δὲ αὐτοῖς ⸂κατʼ ἐκκλησίαν πρεσβυτέρους προσευξάμενοι μετὰ νηστειῶν παρέθεντο αὐτοὺς τῷ κυρίῳ εἰς ὃν πεπιστεύκεισαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","καὶ διελθόντες τὴνΠισιδίαν ἦλθον εἰς ⸀τὴν Παμφυλίαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","καὶ λαλήσαντες ἐν Πέργῃ τὸν λόγον κατέβησαν εἰς Ἀττάλειαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","κἀκεῖθεν ἀπέπλευσαν εἰς Ἀντιόχειαν, ὅθεν ἦσαν παραδεδομένοι τῇ χάριτι τοῦ θεοῦ εἰς τὸ ἔργον ὃ ἐπλήρωσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","παραγενόμενοι δὲ καὶ συναγαγόντες τὴν ἐκκλησίαν ⸀ἀνήγγελλονὅσα ἐποίησεν ὁ θεὸς μετʼ αὐτῶν καὶ ὅτι ἤνοιξεν τοῖς ἔθνεσιν θύραν πίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","διέτριβον ⸀δὲχρόνον οὐκ ὀλίγον σὺν τοῖς μαθηταῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Καί τινες κατελθόντες ἀπὸ τῆς Ἰουδαίας ἐδίδασκον τοὺς ἀδελφοὺς ὅτι Ἐὰν μὴ ⸀περιτμηθῆτετῷἔθει ⸀τῷ Μωϋσέως, οὐ δύνασθε σωθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","γενομένης ⸀δὲστάσεως καὶ ζητήσεως οὐκ ὀλίγης τῷ Παύλῳ καὶ τῷ Βαρναβᾷ πρὸς αὐτοὺς ἔταξαν ἀναβαίνειν Παῦλον καὶ Βαρναβᾶν καί τινας ἄλλους ἐξ αὐτῶν πρὸς τοὺς ἀποστόλους καὶ πρεσβυτέρους εἰς Ἰερουσαλὴμ περὶ τοῦ ζητήματος τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","οἱ μὲν οὖν προπεμφθέντε ὑπὸ τῆς ἐκκλησίας διήρχοντο τήν ⸀τε Φοινίκην καὶ Σαμάρειαν ἐκδιηγούμενοι τὴν ἐπιστροφὴν τῶν ἐθνῶν, καὶ ἐποίουν χαρὰν μεγάλην πᾶσι τοῖς ἀδελφοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","παραγενόμενοι δὲ εἰς ⸀Ἱεροσόλυμα⸀παρεδέχθησαν⸀ἀπὸτῆς ἐκκλησίας καὶ τῶν ἀποστόλων καὶ τῶν πρεσβυτέρων, ἀνήγγειλάν τε ὅσα ὁ θεὸς ἐποίησεν μετʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ἐξανέστησαν δέ τινες τῶν ἀπὸ τῆς αἱρέσεως τῶν Φαρισαίων πεπιστευκότες, λέγοντες ὅτι δεῖ περιτέμνειν αὐτοὺς παραγγέλλειν τε τηρεῖν τὸν νόμον Μωϋσέως. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Συνήχθησάν ⸀τεοἱ ἀπόστολοι καὶ οἱ πρεσβύτεροι ἰδεῖν περὶ τοῦ λόγου τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","πολλῆς δὲ ⸀ζητήσεωςγενομένης ἀναστὰς Πέτρος εἶπεν πρὸς αὐτούς· Ἄνδρες ἀδελφοί, ὑμεῖς ἐπίστασθε ὅτι ἀφʼ ἡμερῶν ἀρχαίων ⸂ἐν ὑμῖν ἐξελέξατο ὁ θεὸς διὰ τοῦ στόματός μου ἀκοῦσαι τὰ ἔθνη τὸν λόγον τοῦ εὐαγγελίου καὶ πιστεῦσαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","καὶ ὁ καρδιογνώστης θεὸς ἐμαρτύρησεν αὐτοῖς ⸀δοὺςτὸ πνεῦμα τὸ ἅγιον καθὼς καὶ ἡμῖν, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","καὶ ⸀οὐθὲνδιέκρινεν μεταξὺ ἡμῶν τε καὶ αὐτῶν, τῇ πίστει καθαρίσας τὰς καρδίας αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","νῦν οὖν τί πειράζετε τὸν θεόν, ἐπιθεῖναι ζυγὸν ἐπὶ τὸν τράχηλον τῶν μαθητῶν ὃν οὔτε οἱ πατέρες ἡμῶν οὔτε ἡμεῖς ἰσχύσαμεν βαστάσαι; ");
INSERT INTO grcsbl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ἀλλὰ διὰ τῆς χάριτος τοῦ κυρίου Ἰησοῦ πιστεύομεν σωθῆναι καθʼ ὃν τρόπον κἀκεῖνοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ἐσίγησεν δὲ πᾶν τὸ πλῆθος, καὶ ἤκουον Βαρναβᾶ καὶ Παύλου ἐξηγουμένων ὅσα ἐποίησεν ὁ θεὸς σημεῖα καὶ τέρατα ἐν τοῖς ἔθνεσιν διʼ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","μετὰ δὲ τὸ σιγῆσαι αὐτοὺς ἀπεκρίθη Ἰάκωβος λέγων· Ἄνδρες ἀδελφοί, ἀκούσατέ μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Συμεὼν ἐξηγήσατο καθὼς πρῶτον ὁ θεὸς ἐπεσκέψατο λαβεῖν ἐξ ἐθνῶν ⸀λαὸντῷ ὀνόματι αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","καὶ τούτῳ συμφωνοῦσιν οἱ λόγοι τῶν προφητῶν, καθὼς γέγραπται· ");
INSERT INTO grcsbl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Μετὰ ταῦτα ἀναστρέψω καὶ ἀνοικοδομήσω τὴν σκηνὴν Δαυὶδ τὴν πεπτωκυῖαν καὶ τὰ ⸀κατεσκαμμένααὐτῆς ἀνοικοδομήσω καὶ ἀνορθώσω αὐτήν, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ὅπως ἂν ἐκζητήσωσιν οἱ κατάλοιποι τῶν ἀνθρώπων τὸν κύριον, καὶ πάντα τὰ ἔθνη ἐφʼ οὓς ἐπικέκληται τὸ ὄνομά μου ἐπʼ αὐτούς, λέγει ⸀κύριοςποιῶν ⸀ταῦτα ");
INSERT INTO grcsbl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","γνωστὰ ἀπʼ ⸀αἰῶνος ");
INSERT INTO grcsbl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","διὸ ἐγὼ κρίνω μὴ παρενοχλεῖν τοῖς ἀπὸ τῶν ἐθνῶν ἐπιστρέφουσιν ἐπὶ τὸν θεόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ἀλλὰ ἐπιστεῖλαι αὐτοῖς τοῦ ⸀ἀπέχεσθαιτῶν ἀλισγημάτων τῶν εἰδώλων καὶ τῆς πορνείας καὶ ⸀τοῦπνικτοῦ καὶ τοῦ αἵματος· ");
INSERT INTO grcsbl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Μωϋσῆς γὰρ ἐκ γενεῶν ἀρχαίων κατὰ πόλιν τοὺς κηρύσσοντας αὐτὸν ἔχει ἐν ταῖς συναγωγαῖς κατὰ πᾶν σάββατον ἀναγινωσκόμενος. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Τότε ἔδοξε τοῖς ἀποστόλοις καὶ τοῖς πρεσβυτέροις σὺν ὅλῃ τῇ ἐκκλησίᾳ ἐκλεξαμένους ἄνδρας ἐξ αὐτῶν πέμψαι εἰς Ἀντιόχειαν σὺν ⸀τῷΠαύλῳ καὶ Βαρναβᾷ, Ἰούδαν τὸν ⸀καλούμενονΒαρσαββᾶν καὶ Σιλᾶν, ἄνδρας ἡγουμένους ἐν τοῖς ἀδελφοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","γράψαντες διὰ χειρὸς ⸀αὐτῶν Οἱ ἀπόστολοι καὶ οἱ ⸀πρεσβύτεροιἀδελφοὶ τοῖς κατὰ τὴν Ἀντιόχειαν καὶ Συρίαν καὶ Κιλικίαν ἀδελφοῖς τοῖς ἐξ ἐθνῶν χαίρειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ἐπειδὴ ἠκούσαμεν ὅτι τινὲς ἐξ ἡμῶν ⸀ἐξελθόντεςἐτάραξαν ὑμᾶς λόγοις ἀνασκευάζοντες τὰς ψυχὰς ⸀ὑμῶνοἷς οὐ διεστειλάμεθα, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ἔδοξεν ἡμῖν γενομένοις ὁμοθυμαδὸν ⸀ἐκλεξαμένοιςἄνδρας πέμψαι πρὸς ὑμᾶς σὺν τοῖς ἀγαπητοῖς ἡμῶν Βαρναβᾷ καὶ Παύλῳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ἀνθρώποις παραδεδωκόσι τὰς ψυχὰς αὐτῶν ὑπὲρ τοῦ ὀνόματος τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ἀπεστάλκαμεν οὖν Ἰούδαν καὶ Σιλᾶν, καὶ αὐτοὺς διὰ λόγου ἀπαγγέλλοντας τὰ αὐτά. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ἔδοξεν γὰρ τῷ ⸂πνεύματι τῷ ἁγίῳ καὶ ἡμῖν μηδὲν πλέον ἐπιτίθεσθαι ὑμῖν βάρος πλὴν ⸂τούτων τῶν ἐπάναγκες, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ἀπέχεσθαι εἰδωλοθύτων καὶ αἵματος καὶ ⸀πνικτῶνκαὶ πορνείας· ἐξ ὧν διατηροῦντες ἑαυτοὺς εὖ πράξετε. ἔρρωσθε. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Οἱ μὲν οὖν ἀπολυθέντες ⸀κατῆλθονεἰς Ἀντιόχειαν, καὶ συναγαγόντες τὸ πλῆθος ἐπέδωκαν τὴν ἐπιστολήν· ");
INSERT INTO grcsbl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ἀναγνόντες δὲ ἐχάρησαν ἐπὶ τῇ παρακλήσει. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ἰούδας τε καὶ Σιλᾶς, καὶ αὐτοὶ προφῆται ὄντες, διὰ λόγου πολλοῦ παρεκάλεσαν τοὺς ἀδελφοὺς καὶ ἐπεστήριξαν· ");
INSERT INTO grcsbl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ποιήσαντες δὲ χρόνον ἀπελύθησαν μετʼ εἰρήνης ἀπὸ τῶν ἀδελφῶν πρὸς τοὺς ⸂ἀποστείλαντας αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Παῦλος δὲ καὶ Βαρναβᾶς διέτριβον ἐν Ἀντιοχείᾳ διδάσκοντες καὶ εὐαγγελιζόμενοι μετὰ καὶ ἑτέρων πολλῶν τὸν λόγον τοῦ κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Μετὰ δέ τινας ἡμέρας εἶπεν ⸂πρὸς Βαρναβᾶν Παῦλος· Ἐπιστρέψαντες δὴ ἐπισκεψώμεθα τοὺς ⸀ἀδελφοὺςκατὰ ⸂πόλιν πᾶσαν ἐν αἷς κατηγγείλαμεν τὸν λόγον τοῦ κυρίου, πῶς ἔχουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Βαρναβᾶς δὲ ⸀ἐβούλετοσυμπαραλαβεῖν ⸀καὶτὸν Ἰωάννην τὸν καλούμενον Μᾶρκον· ");
INSERT INTO grcsbl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Παῦλος δὲ ἠξίου, τὸν ἀποστάντα ἀπʼ αὐτῶν ἀπὸ Παμφυλίας καὶ μὴ συνελθόντα αὐτοῖς εἰς τὸ ἔργον, μὴ ⸀συμπαραλαμβάνειντοῦτον. ");
INSERT INTO grcsbl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ἐγένετο ⸀δὲπαροξυσμὸς ὥστε ἀποχωρισθῆναι αὐτοὺς ἀπʼ ἀλλήλων, τόν τε Βαρναβᾶν παραλαβόντα τὸν Μᾶρκον ἐκπλεῦσαι εἰς Κύπρον, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Παῦλος δὲ ἐπιλεξάμενος Σιλᾶν ἐξῆλθεν παραδοθεὶς τῇ χάριτι τοῦ ⸀κυρίουὑπὸ τῶν ἀδελφῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","διήρχετο δὲ τὴνΣυρίαν καὶ ⸀τὴν Κιλικίαν ἐπιστηρίζων τὰς ἐκκλησίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Κατήντησεν δὲ ⸀καὶεἰςΔέρβην καὶ ⸀εἰς Λύστραν. καὶ ἰδοὺ μαθητής τις ἦν ἐκεῖ ὀνόματι Τιμόθεος, υἱὸς ⸀γυναικὸςἸουδαίας πιστῆς, πατρὸς δὲ Ἕλληνος, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ὃς ἐμαρτυρεῖτο ὑπὸ τῶν ἐν Λύστροις καὶ Ἰκονίῳ ἀδελφῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","τοῦτον ἠθέλησεν ὁ Παῦλος σὺν αὐτῷ ἐξελθεῖν, καὶ λαβὼν περιέτεμεν αὐτὸν διὰ τοὺς Ἰουδαίους τοὺς ὄντας ἐν τοῖς τόποις ἐκείνοις, ᾔδεισαν γὰρ ἅπαντες ⸂ὅτι Ἕλλην ὁ πατὴρ αὐτοῦ ὑπῆρχεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ὡς δὲ διεπορεύοντο τὰς πόλεις, ⸀παρεδίδοσαναὐτοῖς φυλάσσειν τὰ δόγματα τὰ κεκριμένα ὑπὸ τῶν ἀποστόλων ⸀καὶπρεσβυτέρων τῶν ἐν ⸀Ἱεροσολύμοις ");
INSERT INTO grcsbl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","αἱ μὲν οὖν ἐκκλησίαι ἐστερεοῦντο τῇ πίστει καὶ ἐπερίσσευον τῷ ἀριθμῷ καθʼ ἡμέραν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","⸀Διῆλθονδὲ τὴν Φρυγίαν ⸀καὶΓαλατικὴν χώραν, κωλυθέντες ὑπὸ τοῦ ἁγίου πνεύματος λαλῆσαι τὸν λόγον ἐν τῇ Ἀσίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ἐλθόντες ⸀δὲκατὰ τὴν Μυσίαν ἐπείραζον ⸀εἰςτὴν Βιθυνίαν ⸀πορευθῆναικαὶ οὐκ εἴασεν αὐτοὺς τὸ πνεῦμα ⸀Ἰησοῦ ");
INSERT INTO grcsbl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","παρελθόντες δὲ τὴν Μυσίαν κατέβησαν εἰς Τρῳάδα. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","καὶ ὅραμα ⸀διὰνυκτὸς ⸂τῷ Παύλῳ ὤφθη, ἀνὴρ ⸂Μακεδών τις ἦν ἑστὼς ⸀καὶπαρακαλῶν αὐτὸν καὶ λέγων· Διαβὰς εἰς Μακεδονίαν βοήθησον ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ὡς δὲ τὸ ὅραμα εἶδεν, εὐθέως ἐζητήσαμεν ἐξελθεῖν ⸀εἰςΜακεδονίαν, συμβιβάζοντες ὅτι προσκέκληται ἡμᾶς ὁ ⸀θεὸςεὐαγγελίσασθαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ἀναχθέντες ⸀οὖν⸀ἀπὸΤρῳάδος εὐθυδρομήσαμεν εἰς Σαμοθρᾴκην, τῇ ⸀δὲἐπιούσῃ εἰς ⸂Νέαν Πόλιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","⸀κἀκεῖθενεἰς Φιλίππους, ἥτις ἐστὶν ⸂πρώτη τῆς μερίδος Μακεδονίας πόλις, κολωνία. ἦμεν δὲ ἐν ⸀ταύτῃτῇ πόλει διατρίβοντες ἡμέρας τινάς. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","τῇ τε ἡμέρᾳ τῶν σαββάτων ἐξήλθομεν ἔξω τῆς ⸀πύληςπαρὰ ποταμὸν οὗ ⸂ἐνομίζομεν προσευχὴν εἶναι, καὶ καθίσαντες ἐλαλοῦμεν ταῖς συνελθούσαις γυναιξίν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","καί τις γυνὴ ὀνόματι Λυδία, πορφυρόπωλις πόλεως Θυατείρων σεβομένη τὸν θεόν, ἤκουεν, ἧς ὁ κύριος διήνοιξεν τὴν καρδίαν προσέχειν τοῖς λαλουμένοις ὑπὸ ⸀τοῦΠαύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ὡς δὲ ἐβαπτίσθη καὶ ὁ οἶκος αὐτῆς, παρεκάλεσεν λέγουσα· Εἰ κεκρίκατέ με πιστὴν τῷ κυρίῳ εἶναι, εἰσελθόντες εἰς τὸν οἶκόν μου ⸀μένετε καὶ παρεβιάσατο ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ἐγένετο δὲ πορευομένων ἡμῶν εἰς ⸀τὴνπροσευχὴν παιδίσκην τινὰ ἔχουσαν πνεῦμα ⸀πύθωνα⸀ὑπαντῆσαιἡμῖν, ἥτις ἐργασίαν πολλὴν παρεῖχεν τοῖς κυρίοις αὐτῆς μαντευομένη· ");
INSERT INTO grcsbl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","αὕτη ⸀κατακολουθοῦσατῷ Παύλῳ καὶ ἡμῖν ἔκραζεν λέγουσα· Οὗτοι οἱ ἄνθρωποι δοῦλοι τοῦ θεοῦ τοῦ ὑψίστου εἰσίν, οἵτινες καταγγέλλουσιν ⸀ὑμῖνὁδὸν σωτηρίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","τοῦτο δὲἐποίει ἐπὶ πολλὰς ἡμέρας. διαπονηθεὶς ⸀δὲ Παῦλος καὶ ἐπιστρέψας τῷ πνεύματι εἶπεν· Παραγγέλλω σοι ⸀ἐνὀνόματι Ἰησοῦ Χριστοῦ ἐξελθεῖν ἀπʼ αὐτῆς· καὶ ἐξῆλθεν αὐτῇ τῇ ὥρᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ἰδόντες δὲ οἱ κύριοι αὐτῆς ὅτι ἐξῆλθεν ἡ ἐλπὶς τῆς ἐργασίας αὐτῶν ἐπιλαβόμενοι τὸν Παῦλον καὶ τὸν Σιλᾶν εἵλκυσαν εἰς τὴν ἀγορὰν ἐπὶ τοὺς ἄρχοντας, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","καὶ προσαγαγόντες αὐτοὺς τοῖς στρατηγοῖς εἶπαν· Οὗτοι οἱ ἄνθρωποι ἐκταράσσουσιν ἡμῶν τὴν πόλιν Ἰουδαῖοι ὑπάρχοντες, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","καὶ καταγγέλλουσιν ἔθη ἃ οὐκ ἔξεστιν ἡμῖν παραδέχεσθαι οὐδὲ ποιεῖν Ῥωμαίοις οὖσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","καὶ συνεπέστη ὁ ὄχλος κατʼ αὐτῶν, καὶ οἱ στρατηγοὶ περιρήξαντες αὐτῶν τὰ ἱμάτια ἐκέλευον ῥαβδίζειν, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","πολλάς ⸀τεἐπιθέντες αὐτοῖς πληγὰς ἔβαλον εἰς φυλακήν, παραγγείλαντες τῷ δεσμοφύλακι ἀσφαλῶς τηρεῖν αὐτούς· ");
INSERT INTO grcsbl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ὃς παραγγελίαν τοιαύτην ⸀λαβὼνἔβαλεν αὐτοὺς εἰς τὴν ἐσωτέραν φυλακὴν καὶ τοὺς πόδας ⸂ἠσφαλίσατο αὐτῶν εἰς τὸ ξύλον. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Κατὰ δὲ τὸ μεσονύκτιον Παῦλος καὶ Σιλᾶς προσευχόμενοι ὕμνουν τὸν θεόν, ἐπηκροῶντο δὲ αὐτῶν οἱ δέσμιοι· ");
INSERT INTO grcsbl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ἄφνω δὲσεισμὸς ἐγένετο μέγας ὥστε σαλευθῆναι τὰ θεμέλια τοῦ δεσμωτηρίου, ἠνεῴχθησαν ⸀δὲ παραχρῆμα αἱ θύραι πᾶσαι, καὶ πάντων τὰ δεσμὰ ἀνέθη. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ἔξυπνος δὲ γενόμενος ὁ δεσμοφύλαξ καὶ ἰδὼν ἀνεῳγμένας τὰς θύρας τῆς φυλακῆς σπασάμενος ⸀τὴνμάχαιραν ἤμελλεν ἑαυτὸν ἀναιρεῖν, νομίζων ἐκπεφευγέναι τοὺς δεσμίους. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ἐφώνησεν δὲ ⸂φωνῇ μεγάλῃ ὁ Παῦλος λέγων· Μηδὲν πράξῃς σεαυτῷ κακόν, ἅπαντες γάρ ἐσμεν ἐνθάδε. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","αἰτήσας δὲ φῶτα εἰσεπήδησεν καὶ ἔντρομος γενόμενος προσέπεσεν τῷΠαύλῳ καὶ ⸀τῷ Σιλᾷ, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","καὶ προαγαγὼν αὐτοὺς ἔξω ἔφη· Κύριοι, τί με δεῖ ποιεῖν ἵνα σωθῶ; ");
INSERT INTO grcsbl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","οἱ δὲ εἶπαν· Πίστευσον ἐπὶ τὸν κύριον ⸀Ἰησοῦν καὶ σωθήσῃ σὺ καὶ ὁ οἶκός σου. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","καὶ ἐλάλησαν αὐτῷ τὸν λόγον τοῦ ⸀κυρίου⸀σὺνπᾶσι τοῖς ἐν τῇ οἰκίᾳ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","καὶ παραλαβὼν αὐτοὺς ἐν ἐκείνῃ τῇ ὥρᾳ τῆς νυκτὸς ἔλουσεν ἀπὸ τῶν πληγῶν, καὶ ἐβαπτίσθη αὐτὸς καὶ οἱ αὐτοῦ ⸀πάντεςπαραχρῆμα, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ἀναγαγών τε αὐτοὺς εἰς τὸν ⸀οἶκονπαρέθηκεν τράπεζαν καὶ ⸀ἠγαλλιάσατοπανοικεὶ πεπιστευκὼς τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ἡμέρας δὲ γενομένης ἀπέστειλαν οἱ στρατηγοὶ τοὺς ῥαβδούχους λέγοντες· Ἀπόλυσον τοὺς ἀνθρώπους ἐκείνους. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ἀπήγγειλεν δὲ ὁ δεσμοφύλαξ τοὺς λόγους ⸀τούτουςπρὸς τὸν Παῦλον, ὅτι Ἀπέσταλκαν οἱ στρατηγοὶ ἵνα ἀπολυθῆτε· νῦν οὖν ἐξελθόντες πορεύεσθε ἐν εἰρήνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ὁ δὲ Παῦλος ἔφη πρὸς αὐτούς· Δείραντες ἡμᾶςδημοσίᾳ ἀκατακρίτους, ἀνθρώπους Ῥωμαίους ὑπάρχοντας, ἔβαλαν εἰς φυλακήν· καὶ νῦν λάθρᾳ ἡμᾶς ἐκβάλλουσιν; οὐ γάρ, ἀλλὰ ἐλθόντες αὐτοὶ ⸀ἡμᾶς ἐξαγαγέτωσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","⸀ἀπήγγειλανδὲ τοῖς στρατηγοῖς οἱ ῥαβδοῦχοι τὰ ῥήματα ταῦτα· ⸂ἐφοβήθησαν δὲ ἀκούσαντες ὅτι Ῥωμαῖοί εἰσιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","καὶ ἐλθόντες παρεκάλεσαν αὐτούς, καὶ ἐξαγαγόντες ἠρώτων ⸂ἀπελθεῖν ἀπὸ τῆς πόλεως. ");
INSERT INTO grcsbl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ἐξελθόντες δὲ ⸀ἀπὸτῆς φυλακῆς εἰσῆλθον πρὸς τὴν Λυδίαν, καὶ ἰδόντες ⸂παρεκάλεσαν τοὺς ἀδελφοὺς καὶ ἐξῆλθαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Διοδεύσαντες δὲ τὴνἈμφίπολιν καὶ ⸀τὴν Ἀπολλωνίαν ἦλθον εἰς Θεσσαλονίκην, ὅπου ⸀ἦνσυναγωγὴ τῶν Ἰουδαίων. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","κατὰ δὲ τὸ εἰωθὸς τῷ Παύλῳ εἰσῆλθεν πρὸς αὐτοὺς καὶ ἐπὶ σάββατα τρία διελέξατο αὐτοῖς ἀπὸ τῶν γραφῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","διανοίγων καὶ παρατιθέμενος ὅτι τὸν χριστὸν ἔδει παθεῖν καὶ ἀναστῆναι ἐκ νεκρῶν, καὶ ὅτι οὗτός ἐστιν ⸂ὁ χριστός, ὁ Ἰησοῦς ὃν ἐγὼ καταγγέλλω ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","καί τινες ἐξ αὐτῶν ἐπείσθησαν καὶ προσεκληρώθησαν τῷ Παύλῳ καὶ τῷ Σιλᾷ, τῶν τε σεβομένων Ἑλλήνων ⸂πλῆθος πολὺ γυναικῶν τε τῶν πρώτων οὐκ ὀλίγαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","⸂ζηλώσαντες δὲ οἱ Ἰουδαῖοι καὶ προσλαβόμενοι τῶν ἀγοραίων ⸂ἄνδρας τινὰς πονηροὺς καὶ ὀχλοποιήσαντες ἐθορύβουν τὴν πόλιν, ⸂καὶ ἐπιστάντες τῇ οἰκίᾳ Ἰάσονος ἐζήτουν αὐτοὺς ⸀προαγαγεῖνεἰς τὸν δῆμον· ");
INSERT INTO grcsbl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","μὴ εὑρόντες δὲ αὐτοὺς ⸀ἔσυρονἸάσονα καί τινας ἀδελφοὺς ἐπὶ τοὺς πολιτάρχας, βοῶντες ὅτι Οἱ τὴν οἰκουμένην ἀναστατώσαντες οὗτοι καὶ ἐνθάδε πάρεισιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","οὓς ὑποδέδεκται Ἰάσων· καὶ οὗτοι πάντες ἀπέναντι τῶν δογμάτων Καίσαρος πράσσουσι, βασιλέα ⸂ἕτερον λέγοντες εἶναι Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ἐτάραξαν δὲ τὸν ὄχλον καὶ τοὺς πολιτάρχας ἀκούοντας ταῦτα, ");
INSERT INTO grcsbl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","καὶ λαβόντες τὸ ἱκανὸν παρὰ τοῦ Ἰάσονος καὶ τῶν λοιπῶν ἀπέλυσαν αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Οἱ δὲ ἀδελφοὶ εὐθέως ⸀διὰνυκτὸς ἐξέπεμψαν τόν τε Παῦλον καὶ τὸν Σιλᾶν εἰς Βέροιαν, οἵτινες παραγενόμενοι εἰς τὴν συναγωγὴν ⸂τῶν Ἰουδαίων ἀπῄεσαν· ");
INSERT INTO grcsbl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","οὗτοι δὲ ἦσαν εὐγενέστεροι τῶν ἐν Θεσσαλονίκῃ, οἵτινες ἐδέξαντο τὸ λόγον μετὰ πάσης προθυμίας, ⸀τὸ καθʼ ἡμέραν ἀνακρίνοντες τὰς γραφὰς εἰ ἔχοι ταῦτα οὕτως. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","πολλοὶ μὲν οὖν ἐξ αὐτῶν ἐπίστευσαν, καὶ τῶν Ἑλληνίδων γυναικῶν τῶν εὐσχημόνων καὶ ἀνδρῶν οὐκ ὀλίγοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ὡς δὲ ἔγνωσαν οἱ ἀπὸ τῆς Θεσσαλονίκης Ἰουδαῖοι ὅτι καὶ ἐν τῇ Βεροίᾳ κατηγγέλη ὑπὸ τοῦ Παύλου ὁ λόγος τοῦ θεοῦ, ἦλθον κἀκεῖ σαλεύοντες ⸂καὶ ταράσσοντες τοὺς ὄχλους. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","εὐθέως δὲ τότε τὸν Παῦλον ἐξαπέστειλαν οἱ ἀδελφοὶ πορεύεσθαι ⸀ἕωςἐπὶ τὴν θάλασσαν· ⸂ὑπέμεινάν τε ὅ τε Σιλᾶς καὶ ὁ Τιμόθεος ἐκεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","οἱ δὲ ⸀καθιστάνοντεςτὸν Παῦλον ⸀ἤγαγονἕως Ἀθηνῶν, καὶ λαβόντες ἐντολὴν πρὸς τὸνΣιλᾶν καὶ ⸀τὸν Τιμόθεον ἵνα ὡς τάχιστα ἔλθωσιν πρὸς αὐτὸν ἐξῄεσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ἐν δὲ ταῖς Ἀθήναις ἐκδεχομένου αὐτοὺς τοῦ Παύλου, παρωξύνετο τὸ πνεῦμα αὐτοῦ ἐν αὐτῷ ⸀θεωροῦντοςκατείδωλον οὖσαν τὴν πόλιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","διελέγετο μὲν οὖν ἐν τῇ συναγωγῇ τοῖς Ἰουδαίοις καὶ τοῖς σεβομένοις καὶ ἐν τῇ ἀγορᾷ κατὰ πᾶσαν ἡμέραν πρὸς τοὺς παρατυγχάνοντας. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","τινὲς δὲ καὶτῶν Ἐπικουρείων ⸀καὶ Στοϊκῶν φιλοσόφων συνέβαλλον αὐτῷ, καί τινες ἔλεγον· Τί ἂν θέλοι ὁ σπερμολόγος οὗτος λέγειν; οἱ δέ· Ξένων δαιμονίων δοκεῖ καταγγελεὺς εἶναι· ὅτι τὸν Ἰησοῦν καὶ τὴν ἀνάστασιν εὐηγγελίζετο. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ἐπιλαβόμενοί ⸀τεαὐτοῦ ἐπὶ τὸν Ἄρειον Πάγον ἤγαγον, λέγοντες· Δυνάμεθα γνῶναι τίς ἡ καινὴ αὕτη ἡ ὑπὸ σοῦ λαλουμένη διδαχή; ");
INSERT INTO grcsbl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ξενίζοντα γάρ τινα εἰσφέρεις εἰς τὰς ἀκοὰς ἡμῶν· βουλόμεθα οὖν γνῶναι ⸂τίνα θέλει ταῦτα εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ἀθηναῖοι δὲ πάντες καὶ οἱ ἐπιδημοῦντες ξένοι εἰς οὐδὲν ἕτερον ηὐκαίρουν ἢ λέγειν τι⸀ἢ ἀκούειν ⸀τι καινότερον. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Σταθεὶς ⸀δὲΠαῦλος ἐν μέσῳ τοῦ Ἀρείου Πάγου ἔφη· Ἄνδρες Ἀθηναῖοι, κατὰ πάντα ὡς δεισιδαιμονεστέρους ὑμᾶς θεωρῶ· ");
INSERT INTO grcsbl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","διερχόμενος γὰρ καὶ ἀναθεωρῶν τὰ σεβάσματα ὑμῶν εὗρον καὶ βωμὸν ἐν ᾧ ἐπεγέγραπτο· Ἀγνώστῳ θεῷ. ⸀ὃοὖν ἀγνοοῦντες εὐσεβεῖτε, ⸀τοῦτοἐγὼ καταγγέλλω ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ὁ θεὸς ὁ ποιήσας τὸν κόσμον καὶ πάντα τὰ ἐν αὐτῷ, οὗτος οὐρανοῦ καὶ γῆς ⸂ὑπάρχων κύριος οὐκ ἐν χειροποιήτοις ναοῖς κατοικεῖ ");
INSERT INTO grcsbl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","οὐδὲ ὑπὸ χειρῶν ⸀ἀνθρωπίνωνθεραπεύεται προσδεόμενός τινος, αὐτὸς διδοὺς πᾶσι ζωὴν καὶ πνοὴν ⸂καὶ τὰ πάντα· ");
INSERT INTO grcsbl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ἐποίησέν τε ἐξ ⸀ἑνὸςπᾶν ἔθνος ἀνθρώπων κατοικεῖν ἐπὶ ⸂παντὸς προσώπου τῆς γῆς, ὁρίσας προστεταγμένους καιροὺς καὶ τὰς ὁροθεσίας τῆς κατοικίας αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ζητεῖν τὸν ⸀θεὸνεἰ ἄρα γε ψηλαφήσειαν αὐτὸν καὶ εὕροιεν, καί γε οὐ μακρὰν ἀπὸ ἑνὸς ἑκάστου ἡμῶν ὑπάρχοντα. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ἐν αὐτῷ γὰρ ζῶμεν καὶ κινούμεθα καὶ ἐσμέν, ὡς καί τινες τῶν καθʼ ὑμᾶς ποιητῶν εἰρήκασιν· Τοῦ γὰρ καὶ γένος ἐσμέν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","γένος οὖν ὑπάρχοντες τοῦ θεοῦ οὐκ ὀφείλομεν νομίζειν χρυσῷ ἢ ἀργύρῳ ἢ λίθῳ, χαράγματι τέχνης καὶ ἐνθυμήσεως ἀνθρώπου, τὸ θεῖον εἶναι ὅμοιον. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","τοὺς μὲν οὖν χρόνους τῆς ἀγνοίας ὑπεριδὼν ὁ θεὸς τὰ νῦν ⸀παραγγέλλειτοῖς ἀνθρώποις ⸀πάνταςπανταχοῦ μετανοεῖν, ");
INSERT INTO grcsbl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","⸀καθότιἔστησεν ἡμέραν ἐν ᾗ μέλλει κρίνειν τὴν οἰκουμένην ἐν δικαιοσύνῃ ἐν ἀνδρὶ ᾧ ὥρισεν, πίστιν παρασχὼν πᾶσιν ἀναστήσας αὐτὸν ἐκ νεκρῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ἀκούσαντες δὲ ἀνάστασιν νεκρῶν οἱ μὲν ἐχλεύαζον οἱ δὲ εἶπαν Ἀκουσόμεθά σου ⸂περὶ τούτου καὶ πάλιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","⸀οὕτωςὁ Παῦλος ἐξῆλθεν ἐκ μέσου αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","τινὲς δὲ ἄνδρες κολληθέντες αὐτῷ ἐπίστευσαν, ἐν οἷς καὶ Διονύσιος ὁ Ἀρεοπαγίτης καὶ γυνὴ ὀνόματι Δάμαρις καὶ ἕτεροι σὺν αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","⸀Μετὰταῦτα ⸀χωρισθεὶςἐκ τῶν Ἀθηνῶν ἦλθεν εἰς Κόρινθον. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","καὶ εὑρών τινα Ἰουδαῖον ὀνόματι Ἀκύλαν, Ποντικὸν τῷ γένει, προσφάτως ἐληλυθότα ἀπὸ τῆς Ἰταλίας καὶ Πρίσκιλλαν γυναῖκα αὐτοῦ διὰ τὸ ⸀διατεταχέναιΚλαύδιον χωρίζεσθαι πάντας τοὺς Ἰουδαίους ⸀ἀπὸτῆς Ῥώμης, προσῆλθεν αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","καὶ διὰ τὸ ὁμότεχνον εἶναι ἔμενεν παρʼ αὐτοῖς καὶ ⸀ἠργάζετο ἦσαν γὰρ σκηνοποιοὶ ⸂τῇ τέχνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","διελέγετο δὲ ἐν τῇ συναγωγῇ κατὰ πᾶν σάββατον, ἔπειθέν τε Ἰουδαίους καὶ Ἕλληνας. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ὡς δὲ κατῆλθον ἀπὸ τῆς Μακεδονίας ὅ τε Σιλᾶς καὶ ὁ Τιμόθεος, συνείχετο τῷ ⸀λόγῳὁ Παῦλος, διαμαρτυρόμενος τοῖς Ἰουδαίοις ⸀εἶναιτὸν χριστὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ἀντιτασσομένων δὲ αὐτῶν καὶ βλασφημούντων ἐκτιναξάμενος τὰ ἱμάτια εἶπεν πρὸς αὐτούς· Τὸ αἷμα ὑμῶν ἐπὶ τὴν κεφαλὴν ὑμῶν· καθαρὸς ἐγώ· ἀπὸ τοῦ νῦν εἰς τὰ ἔθνη πορεύσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","καὶ μεταβὰς ἐκεῖθεν ⸀εἰσῆλθενεἰς οἰκίαν τινὸς ὀνόματι ⸀ΤιτίουἸούστου σεβομένου τὸν θεόν, οὗ ἡ οἰκία ἦν συνομοροῦσα τῇ συναγωγῇ. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Κρίσπος δὲ ὁ ἀρχισυνάγωγος ἐπίστευσεν τῷ κυρίῳ σὺν ὅλῳ τῷ οἴκῳ αὐτοῦ, καὶ πολλοὶ τῶν Κορινθίων ἀκούοντες ἐπίστευον καὶ ἐβαπτίζοντο. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","εἶπεν δὲ ὁ κύριος ⸂ἐν νυκτὶ διʼ ὁράματος τῷ Παύλῳ· Μὴ φοβοῦ, ἀλλὰ λάλει καὶ μὴ σιωπήσῃς, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","διότι ἐγώ εἰμι μετὰ σοῦ καὶ οὐδεὶς ἐπιθήσεταί σοι τοῦ κακῶσαί σε, διότι λαός ἐστί μοι πολὺς ἐν τῇ πόλει ταύτῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ἐκάθισεν ⸀δὲἐνιαυτὸν καὶ μῆνας ἓξ διδάσκων ἐν αὐτοῖς τὸν λόγον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Γαλλίωνος δὲ ⸂ἀνθυπάτου ὄντος τῆς Ἀχαΐας κατεπέστησαν ⸂ὁμοθυμαδὸν οἱ Ἰουδαῖοι τῷ Παύλῳ καὶ ἤγαγον αὐτὸν ἐπὶ τὸ βῆμα, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","λέγοντες ὅτι Παρὰ τὸν νόμον ⸂ἀναπείθει οὗτος τοὺς ἀνθρώπους σέβεσθαι τὸν θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","μέλλοντος δὲ τοῦ Παύλου ἀνοίγειν τὸ στόμα εἶπεν ὁ Γαλλίων πρὸς τοὺς Ἰουδαίους· Εἰ ⸀μὲνἦν ἀδίκημά τι ἢ ῥᾳδιούργημα πονηρόν, ὦ Ἰουδαῖοι, κατὰ λόγον ἂν ἀνεσχόμην ὑμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","εἰ δὲ ⸀ζητήματάἐστιν περὶ λόγου καὶ ὀνομάτων καὶ νόμου τοῦ καθʼ ὑμᾶς, ὄψεσθε αὐτοί· ⸀κριτὴςἐγὼ τούτων οὐ βούλομαι εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","καὶ ἀπήλασεν αὐτοὺς ἀπὸ τοῦ βήματος. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ἐπιλαβόμενοι δὲ ⸀πάντεςΣωσθένην τὸν ἀρχισυνάγωγον ἔτυπτον ἔμπροσθεν τοῦ βήματος· καὶ οὐδὲν τούτων τῷ Γαλλίωνι ⸀ἔμελεν ");
INSERT INTO grcsbl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ὁ δὲ Παῦλος ἔτι προσμείνας ἡμέρας ἱκανὰς τοῖς ἀδελφοῖς ἀποταξάμενος ἐξέπλει εἰς τὴν Συρίαν, καὶ σὺν αὐτῷ Πρίσκιλλα καὶ Ἀκύλας, κειράμενος ⸂ἐν Κεγχρεαῖς τὴν κεφαλήν, εἶχεν γὰρ εὐχήν. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","⸀κατήντησανδὲ εἰς Ἔφεσον, κἀκείνους κατέλιπεν αὐτοῦ, αὐτὸς δὲ εἰσελθὼν εἰς τὴν συναγωγὴν ⸀διελέξατοτοῖς Ἰουδαίοις. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ἐρωτώντων δὲ αὐτῶν ἐπὶ πλείονα χρόνον ⸀μεῖναιοὐκ ἐπένευσεν, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","⸂ἀλλὰ ἀποταξάμενος καὶ ⸀εἰπών ⸀Πάλιν ἀνακάμψω πρὸς ὑμᾶς τοῦ θεοῦ θέλοντος ἀνήχθη ἀπὸ τῆς Ἐφέσου, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","καὶ κατελθὼν εἰς Καισάρειαν, ἀναβὰς καὶ ἀσπασάμενος τὴν ἐκκλησίαν, κατέβη εἰς Ἀντιόχειαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","καὶ ποιήσας χρόνον τινὰ ἐξῆλθεν, διερχόμενος καθεξῆς τὴν Γαλατικὴν χώραν καὶ Φρυγίαν, ⸀στηρίζωνπάντας τοὺς μαθητάς. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ἰουδαῖος δέ τις Ἀπολλῶς ὀνόματι, Ἀλεξανδρεὺς τῷ γένει, ἀνὴρ λόγιος, κατήντησεν εἰς Ἔφεσον, δυνατὸς ὢν ἐν ταῖς γραφαῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","οὗτος ἦν κατηχημένος τὴν ὁδὸν τοῦ κυρίου, καὶ ζέων τῷ πνεύματι ἐλάλει καὶ ἐδίδασκεν ἀκριβῶς τὰ περὶ τοῦ ⸀Ἰησοῦ ἐπιστάμενος μόνον τὸ βάπτισμα Ἰωάννου. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","οὗτός τε ἤρξατο παρρησιάζεσθαι ἐν τῇ συναγωγῇ· ἀκούσαντες δὲ αὐτοῦ ⸂Πρίσκιλλα καὶ Ἀκύλας προσελάβοντο αὐτὸν καὶ ἀκριβέστερον αὐτῷ ἐξέθεντο τὴν ⸂ὁδὸν τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","βουλομένου δὲ αὐτοῦ διελθεῖν εἰς τὴν Ἀχαΐαν προτρεψάμενοι οἱ ἀδελφοὶ ἔγραψαν τοῖς μαθηταῖς ἀποδέξασθαι αὐτόν· ὃς παραγενόμενος συνεβάλετο πολὺ τοῖς πεπιστευκόσιν διὰ τῆς χάριτος· ");
INSERT INTO grcsbl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","εὐτόνως γὰρ τοῖς Ἰουδαίοις διακατηλέγχετο δημοσίᾳ ἐπιδεικνὺς διὰ τῶν γραφῶν εἶναι τὸν χριστὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ἐγένετο δὲ ἐν τῷ τὸν Ἀπολλῶ εἶναι ἐν Κορίνθῳ Παῦλον διελθόντα τὰ ἀνωτερικὰ μέρη ⸀ἐλθεῖνεἰς Ἔφεσον καὶ ⸀εὑρεῖντινας μαθητάς, ");
INSERT INTO grcsbl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","εἶπέν ⸀τεπρὸς αὐτούς· Εἰ πνεῦμα ἅγιον ἐλάβετε πιστεύσαντες; οἱ ⸀δὲπρὸς αὐτόν· Ἀλλʼ οὐδʼ εἰ πνεῦμα ἅγιον ἔστιν ἠκούσαμεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","εἶπέν ⸀τε Εἰς τί οὖν ἐβαπτίσθητε; οἱ δὲ εἶπαν· Εἰς τὸ Ἰωάννου βάπτισμα. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","εἶπεν δὲ Παῦλος· ⸀Ἰωάννηςἐβάπτισεν βάπτισμα μετανοίας, τῷ λαῷ λέγων εἰς τὸνἐρχόμενον μετʼ αὐτὸν ἵνα πιστεύσωσιν, τοῦτʼ ἔστιν εἰς ⸀τὸν Ἰησοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ἀκούσαντες δὲ ἐβαπτίσθησαν εἰς τὸ ὄνομα τοῦ κυρίου Ἰησοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","καὶ ἐπιθέντος αὐτοῖς τοῦ ⸀Παύλουχεῖρας ἦλθε τὸ πνεῦμα τὸ ἅγιον ἐπʼ αὐτούς, ἐλάλουν τε γλώσσαις καὶ ἐπροφήτευον. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ἦσαν δὲ οἱ πάντες ἄνδρες ὡσεὶ ⸀δώδεκα ");
INSERT INTO grcsbl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Εἰσελθὼν δὲ εἰς τὴν συναγωγὴν ἐπαρρησιάζετο ἐπὶ μῆνας τρεῖς διαλεγόμενος καὶ ⸀πείθωνπερὶ τῆς βασιλείας τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ὡς δέ τινες ἐσκληρύνοντο καὶ ἠπείθουν κακολογοῦντες τὴν ὁδὸν ἐνώπιον τοῦ πλήθους, ἀποστὰς ἀπʼ αὐτῶν ἀφώρισεν τοὺς μαθητάς, καθʼ ἡμέραν διαλεγόμενος ἐν τῇ σχολῇ ⸀Τυράννου ");
INSERT INTO grcsbl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","τοῦτο δὲ ἐγένετο ἐπὶ ἔτη δύο, ὥστε πάντας τοὺς κατοικοῦντας τὴν Ἀσίαν ἀκοῦσαι τὸν λόγον τοῦ ⸀κυρίου Ἰουδαίους τε καὶ Ἕλληνας. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Δυνάμεις τε οὐ τὰς τυχούσας ⸂ὁ θεὸς ἐποίει διὰ τῶν χειρῶν Παύλου, ");
INSERT INTO grcsbl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ὥστε καὶ ἐπὶ τοὺς ἀσθενοῦντας ⸀ἀποφέρεσθαιἀπὸ τοῦ χρωτὸς αὐτοῦ σουδάρια ἢ σιμικίνθια καὶ ἀπαλλάσσεσθαι ἀπʼ αὐτῶν τὰς νόσους, τά τε πνεύματα τὰ πονηρὰ ⸀ἐκπορεύεσθαι ");
INSERT INTO grcsbl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ἐπεχείρησαν δέ τινες ⸀καὶτῶν περιερχομένων Ἰουδαίων ἐξορκιστῶν ὀνομάζειν ἐπὶ τοὺς ἔχοντας τὰ πνεύματα τὰ πονηρὰ τὸ ὄνομα τοῦ κυρίου Ἰησοῦ λέγοντες· ⸀Ὁρκίζωὑμᾶς τὸν Ἰησοῦν ⸀ὃνΠαῦλος κηρύσσει. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ἦσαν δέ ⸀τινοςΣκευᾶ Ἰουδαίου ἀρχιερέως ἑπτὰ ⸀υἱοὶτοῦτο ποιοῦντες. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ἀποκριθὲν δὲ τὸ πνεῦμα τὸ πονηρὸν εἶπεν ⸀αὐτοῖς ⸀ΤὸνἸησοῦν γινώσκω καὶ τὸν Παῦλον ἐπίσταμαι, ὑμεῖς δὲ τίνες ἐστέ; ");
INSERT INTO grcsbl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","καὶ ⸀ἐφαλόμενος⸂ὁ ἄνθρωπος ἐπʼ αὐτοὺς ἐν ᾧ ἦν τὸ πνεῦμα τὸ πονηρὸν ⸂κατακυριεύσας ἀμφοτέρων ἴσχυσεν κατʼ αὐτῶν, ὥστε γυμνοὺς καὶ τετραυματισμένους ἐκφυγεῖν ἐκ τοῦ οἴκου ἐκείνου. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","τοῦτο δὲ ἐγένετο γνωστὸν πᾶσιν Ἰουδαίοις τε καὶ Ἕλλησιν τοῖς κατοικοῦσιν τὴν Ἔφεσον, καὶ ⸀ἐπέπεσενφόβος ἐπὶ πάντας αὐτούς, καὶ ἐμεγαλύνετο τὸ ὄνομα τοῦ κυρίου Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","πολλοί τε τῶν πεπιστευκότων ἤρχοντο ἐξομολογούμενοι καὶ ἀναγγέλλοντες τὰς πράξεις αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ἱκανοὶ δὲ τῶν τὰ περίεργα πραξάντων συνενέγκαντες τὰς βίβλους κατέκαιον ἐνώπιον πάντων· καὶ συνεψήφισαν τὰς τιμὰς αὐτῶν καὶ εὗρον ἀργυρίου μυριάδας πέντε. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","οὕτως κατὰ κράτος ⸂τοῦ κυρίου ὁ λόγος ηὔξανεν καὶ ἴσχυεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ὡς δὲ ἐπληρώθη ταῦτα, ἔθετο ὁ Παῦλος ἐν τῷ πνεύματι διελθὼν τὴν Μακεδονίαν καὶ Ἀχαΐαν πορεύεσθαι εἰς ⸀Ἱεροσόλυμα εἰπὼν ὅτι Μετὰ τὸ γενέσθαι με ἐκεῖ δεῖ με καὶ Ῥώμην ἰδεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ἀποστείλας δὲ εἰς τὴν Μακεδονίαν δύο τῶν διακονούντων αὐτῷ, Τιμόθεον καὶ Ἔραστον, αὐτὸς ἐπέσχεν χρόνον εἰς τὴν Ἀσίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ἐγένετο δὲ κατὰ τὸν καιρὸν ἐκεῖνον τάραχος οὐκ ὀλίγος περὶ τῆς ὁδοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Δημήτριος γάρ τις ὀνόματι, ἀργυροκόπος, ποιῶν ναοὺς ἀργυροῦς Ἀρτέμιδος παρείχετο τοῖς τεχνίταις ⸂οὐκ ὀλίγην ἐργασίαν, ");
INSERT INTO grcsbl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","οὓς συναθροίσας καὶ τοὺς περὶ τὰ τοιαῦτα ἐργάτας εἶπεν· Ἄνδρες, ἐπίστασθε ὅτι ἐκ ταύτης τῆς ἐργασίας ἡ εὐπορία ⸀ἡμῖνἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","καὶ θεωρεῖτε καὶ ἀκούετε ὅτι οὐ μόνον Ἐφέσου ἀλλὰ σχεδὸν πάσης τῆς Ἀσίας ὁ Παῦλος οὗτος πείσας μετέστησεν ἱκανὸν ὄχλον, λέγων ὅτι οὐκ εἰσὶν θεοὶ οἱ διὰ χειρῶν γινόμενοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","οὐ μόνον δὲ τοῦτο κινδυνεύει ἡμῖν τὸ μέρος εἰς ἀπελεγμὸν ἐλθεῖν, ἀλλὰ καὶ τὸ τῆς μεγάλης θεᾶς ⸂Ἀρτέμιδος ἱερὸν εἰς οὐθὲν λογισθῆναι, μέλλειν ⸀τεκαὶ καθαιρεῖσθαι ⸂τῆς μεγαλειότητος αὐτῆς, ἣν ὅλη ἡ Ἀσία καὶ ἡ οἰκουμένη σέβεται. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ἀκούσαντες δὲ καὶ γενόμενοι πλήρεις θυμοῦ ἔκραζον λέγοντες· Μεγάλη ἡ Ἄρτεμις Ἐφεσίων. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","καὶ ἐπλήσθη ἡ ⸀πόλιςτῆς συγχύσεως, ὥρμησάν τε ὁμοθυμαδὸν εἰς τὸ θέατρον συναρπάσαντες Γάϊον καὶ Ἀρίσταρχον Μακεδόνας, συνεκδήμους Παύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","⸂Παύλου δὲ βουλομένου εἰσελθεῖν εἰς τὸν δῆμον οὐκ εἴων αὐτὸν οἱ μαθηταί· ");
INSERT INTO grcsbl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","τινὲς δὲ καὶ τῶν Ἀσιαρχῶν, ὄντες αὐτῷ φίλοι, πέμψαντες πρὸς αὐτὸν παρεκάλουν μὴ δοῦναι ἑαυτὸν εἰς τὸ θέατρον. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ἄλλοι μὲν οὖν ἄλλο τι ἔκραζον, ἦν γὰρ ἡ ἐκκλησία συγκεχυμένη, καὶ οἱ πλείους οὐκ ᾔδεισαν τίνος ἕνεκα συνεληλύθεισαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ἐκ δὲ τοῦ ὄχλου ⸀συνεβίβασανἈλέξανδρον προβαλόντων αὐτὸν τῶν Ἰουδαίων, ὁ δὲ Ἀλέξανδρος κατασείσας τὴν χεῖρα ἤθελεν ἀπολογεῖσθαι τῷ δήμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ἐπιγνόντες δὲ ὅτι Ἰουδαῖός ἐστιν φωνὴ ἐγένετο μία ἐκ πάντων ⸀ὡςἐπὶ ὥρας δύο κραζόντων· Μεγάλη ἡ Ἄρτεμις Ἐφεσίων. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","καταστείλας δὲ ⸂ὁ γραμματεὺς τὸν ὄχλον φησίν· Ἄνδρες Ἐφέσιοι, τίς γάρ ἐστιν ⸀ἀνθρώπωνὃς οὐ γινώσκει τὴν Ἐφεσίων πόλιν νεωκόρον οὖσαν τῆς ⸀μεγάληςἈρτέμιδος καὶ τοῦ διοπετοῦς; ");
INSERT INTO grcsbl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ἀναντιρρήτων οὖν ὄντων τούτων δέον ἐστὶν ὑμᾶς κατεσταλμένους ὑπάρχειν καὶ μηδὲν προπετὲς πράσσειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ἠγάγετε γὰρ τοὺς ἄνδρας τούτους οὔτε ἱεροσύλους οὔτε βλασφημοῦντας τὴν θεὸν ⸀ἡμῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","εἰ μὲν οὖν Δημήτριος καὶ οἱ σὺν αὐτῷ τεχνῖται ἔχουσιν πρός τινα λόγον, ἀγοραῖοι ἄγονται καὶ ἀνθύπατοί εἰσιν, ἐγκαλείτωσαν ἀλλήλοις. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","εἰ δέ τι ⸀περαιτέρωἐπιζητεῖτε, ἐν τῇ ἐννόμῳ ἐκκλησίᾳ ἐπιλυθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","καὶ γὰρ κινδυνεύομεν ἐγκαλεῖσθαι στάσεως περὶ τῆς σήμερον μηδενὸς αἰτίου ὑπάρχοντος περὶ οὗ οὐ δυνησόμεθα ⸀ἀποδοῦναιλόγον ⸀περὶτῆς συστροφῆς ταύτης. καὶ ταῦτα εἰπὼν ἀπέλυσεν τὴν ἐκκλησίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Μετὰ δὲ τὸ παύσασθαι τὸν θόρυβον ⸀μεταπεμψάμενοςὁ Παῦλος τοὺς μαθητὰς καὶ ⸀παρακαλέσας ἀσπασάμενος ἐξῆλθεν ⸀πορεύεσθαι⸀εἰςΜακεδονίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","διελθὼν δὲ τὰ μέρη ἐκεῖνα καὶ παρακαλέσας αὐτοὺς λόγῳ πολλῷ ἦλθεν εἰς τὴν Ἑλλάδα ");
INSERT INTO grcsbl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ποιήσας τε μῆνας τρεῖς· γενομένης ⸂ἐπιβουλῆς αὐτῷ ὑπὸ τῶν Ἰουδαίων μέλλοντι ἀνάγεσθαι εἰς τὴν Συρίαν ἐγένετο ⸀γνώμηςτοῦ ὑποστρέφειν διὰ Μακεδονίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","συνείπετο δὲ ⸀αὐτῷΣώπατρος ⸀ΠύρρουΒεροιαῖος, Θεσσαλονικέων δὲ Ἀρίσταρχος καὶ Σεκοῦνδος, καὶ Γάϊος Δερβαῖος καὶ Τιμόθεος, Ἀσιανοὶ δὲ Τυχικὸς καὶ Τρόφιμος· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","οὗτοι ⸀δὲ⸀προσελθόντεςἔμενον ἡμᾶς ἐν Τρῳάδι· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ἡμεῖς δὲ ἐξεπλεύσαμεν μετὰ τὰς ἡμέρας τῶν ἀζύμων ἀπὸ Φιλίππων, καὶ ἤλθομεν πρὸς αὐτοὺς εἰς τὴν Τρῳάδα ἄχρι ἡμερῶν πέντε, ⸀οὗδιετρίψαμεν ἡμέρας ἑπτά. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ἐν δὲ τῇ μιᾷ τῶν σαββάτων συνηγμένων ⸀ἡμῶνκλάσαι ἄρτον ὁ Παῦλος διελέγετο αὐτοῖς, μέλλων ἐξιέναι τῇ ἐπαύριον, παρέτεινέν τε τὸν λόγον μέχρι μεσονυκτίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ἦσαν δὲ λαμπάδες ἱκαναὶ ἐν τῷ ὑπερῴῳ οὗ ἦμεν συνηγμένοι· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","⸀καθεζόμενοςδέ τις νεανίας ὀνόματι Εὔτυχος ἐπὶ τῆς θυρίδος, καταφερόμενος ὕπνῳ βαθεῖ διαλεγομένου τοῦ Παύλου ἐπὶ πλεῖον, κατενεχθεὶς ἀπὸ τοῦ ὕπνου ἔπεσεν ἀπὸ τοῦ τριστέγου κάτω καὶ ἤρθη νεκρός. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","καταβὰς δὲ ὁ Παῦλος ἐπέπεσεν αὐτῷ καὶ συμπεριλαβὼν εἶπεν· Μὴ θορυβεῖσθε, ἡ γὰρ ψυχὴ αὐτοῦ ἐν αὐτῷ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ἀναβὰς δὲ καὶ κλάσας ⸀τὸνἄρτον καὶ γευσάμενος ἐφʼ ἱκανόν τε ὁμιλήσας ἄχρι αὐγῆς, οὕτως ἐξῆλθεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ἤγαγον δὲ τὸν παῖδα ζῶντα, καὶ παρεκλήθησαν οὐ μετρίως. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ἡμεῖς δὲ ⸀προελθόντες⸀ἐπὶτὸ πλοῖον ἀνήχθημεν ἐπὶ τὴν Ἆσσον, ἐκεῖθεν μέλλοντες ἀναλαμβάνειν τὸν Παῦλον, οὕτως γὰρ ⸂διατεταγμένος ἦν μέλλων αὐτὸς πεζεύειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ὡς δὲ ⸀συνέβαλλενἡμῖν εἰς τὴν Ἆσσον, ἀναλαβόντες αὐτὸν ἤλθομεν εἰς Μιτυλήνην, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","κἀκεῖθεν ἀποπλεύσαντες τῇ ἐπιούσῃ κατηντήσαμεν ⸀ἄντικρυςΧίου, τῇ δὲ ἑτέρᾳ παρεβάλομεν εἰς ⸀Σάμον τῇ ⸀δὲἐχομένῃ ἤλθομεν εἰς Μίλητον· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","⸀κεκρίκειγὰρ ὁ Παῦλος παραπλεῦσαι τὴν Ἔφεσον, ὅπως μὴ γένηται αὐτῷ χρονοτριβῆσαι ἐν τῇ Ἀσίᾳ, ἔσπευδεν γὰρ εἰ δυνατὸν ⸀εἴηαὐτῷ τὴν ἡμέραν τῆς πεντηκοστῆς γενέσθαι εἰς Ἱεροσόλυμα. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ἀπὸ δὲ τῆς Μιλήτου πέμψας εἰς Ἔφεσον μετεκαλέσατο τοὺς πρεσβυτέρους τῆς ἐκκλησίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ὡς δὲ παρεγένοντο πρὸς αὐτὸν εἶπεν αὐτοῖς· Ὑμεῖς ἐπίστασθε ἀπὸ πρώτης ἡμέρας ἀφʼ ἧς ἐπέβην εἰς τὴν Ἀσίαν πῶς μεθʼ ὑμῶν τὸν πάντα χρόνον ἐγενόμην, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","δουλεύων τῷ κυρίῳ μετὰ πάσης ταπεινοφροσύνης ⸀καὶδακρύων καὶ πειρασμῶν τῶν συμβάντων μοι ἐν ταῖς ἐπιβουλαῖς τῶν Ἰουδαίων· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ὡς οὐδὲν ὑπεστειλάμην τῶν συμφερόντων τοῦ μὴ ἀναγγεῖλαι ὑμῖν καὶ διδάξαι ὑμᾶς δημοσίᾳ καὶ κατʼ οἴκους, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","διαμαρτυρόμενος Ἰουδαίοις τε καὶ Ἕλλησιν τὴν ⸀εἰςθεὸν μετάνοιαν καὶ ⸀πίστινεἰς τὸν κύριον ἡμῶν ⸀Ἰησοῦν ");
INSERT INTO grcsbl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","καὶ νῦν ἰδοὺ ⸂δεδεμένος ἐγὼ τῷ πνεύματι πορεύομαι εἰς Ἰερουσαλήμ, τὰ ἐν αὐτῇ συναντήσοντά ⸀μοιμὴ εἰδώς, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","πλὴν ὅτι τὸ πνεῦμα τὸ ἅγιον κατὰ πόλιν διαμαρτύρεταί ⸀μοιλέγον ὅτι δεσμὰ ⸂καὶ θλίψεις με μένουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ἀλλʼ οὐδενὸς ⸀λόγου⸀ποιοῦμαιτὴν ⸀ψυχὴντιμίαν ἐμαυτῷ ὡς ⸀τελειῶσαιτὸν δρόμον ⸀μουκαὶ τὴν διακονίαν ἣν ἔλαβον παρὰ τοῦ κυρίου Ἰησοῦ, διαμαρτύρασθαι τὸ εὐαγγέλιον τῆς χάριτος τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Καὶ νῦν ἰδοὺ ἐγὼ οἶδα ὅτι οὐκέτι ὄψεσθε τὸ πρόσωπόν μου ὑμεῖς πάντες ἐν οἷς διῆλθον κηρύσσων τὴν ⸀βασιλείαν ");
INSERT INTO grcsbl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","⸀διότιμαρτύρομαι ὑμῖν ἐν τῇ σήμερον ἡμέρᾳ ὅτι καθαρός ⸀εἰμιἀπὸ τοῦ αἵματος πάντων, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","οὐ γὰρ ὑπεστειλάμην τοῦ μὴ ἀναγγεῖλαι ⸂πᾶσαν τὴν βουλὴν τοῦ θεοῦ ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","⸀προσέχετεἑαυτοῖς καὶ παντὶ τῷ ποιμνίῳ, ἐν ᾧ ὑμᾶς τὸ πνεῦμα τὸ ἅγιον ἔθετο ἐπισκόπους, ποιμαίνειν τὴν ἐκκλησίαν τοῦ ⸀θεοῦ ἣν περιεποιήσατο διὰ τοῦ ⸂αἵματος τοῦ ἰδίου. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ἐγὼ ⸀οἶδαὅτι εἰσελεύσονται μετὰ τὴν ἄφιξίν μου λύκοι βαρεῖς εἰς ὑμᾶς μὴ φειδόμενοι τοῦ ποιμνίου, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","καὶ ἐξ ὑμῶν αὐτῶν ἀναστήσονται ἄνδρες λαλοῦντες διεστραμμένα τοῦ ἀποσπᾶν τοὺς μαθητὰς ὀπίσω ⸀ἑαυτῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","διὸ γρηγορεῖτε, μνημονεύοντες ὅτι τριετίαν νύκτα καὶ ἡμέραν οὐκ ἐπαυσάμην μετὰ δακρύων νουθετῶν ἕνα ἕκαστον. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","καὶ τὰ νῦν παρατίθεμαι ⸀ὑμᾶςτῷ ⸀θεῷκαὶ τῷ λόγῳ τῆς χάριτος αὐτοῦ, τῷ δυναμένῳ ⸀οἰκοδομῆσαικαὶ δοῦναι ⸀τὴνκληρονομίαν ἐν τοῖς ἡγιασμένοις πᾶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ἀργυρίου ἢ χρυσίου ἢ ἱματισμοῦ οὐδενὸς ἐπεθύμησα· ");
INSERT INTO grcsbl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","αὐτοὶ γινώσκετε ὅτι ταῖς χρείαις μου καὶ τοῖς οὖσι μετʼ ἐμοῦ ὑπηρέτησαν αἱ χεῖρες αὗται. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","πάντα ὑπέδειξα ὑμῖν ὅτι οὕτως κοπιῶντας δεῖ ἀντιλαμβάνεσθαι τῶν ἀσθενούντων, μνημονεύειν τε τῶν λόγων τοῦ κυρίου Ἰησοῦ ὅτι αὐτὸς εἶπεν Μακάριόν ἐστιν μᾶλλον διδόναι ἢ λαμβάνειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Καὶ ταῦτα εἰπὼν θεὶς τὰ γόνατα αὐτοῦ σὺν πᾶσιν αὐτοῖς προσηύξατο. ");
INSERT INTO grcsbl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ἱκανὸς δὲ ⸂κλαυθμὸς ἐγένετο πάντων, καὶ ἐπιπεσόντες ἐπὶ τὸν τράχηλον τοῦ Παύλου κατεφίλουν αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ὀδυνώμενοι μάλιστα ἐπὶ τῷ λόγῳ ᾧ εἰρήκει ὅτι οὐκέτι μέλλουσιν τὸ πρόσωπον αὐτοῦ θεωρεῖν. προέπεμπον δὲ αὐτὸν εἰς τὸ πλοῖον. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ὡς δὲ ἐγένετο ἀναχθῆναι ἡμᾶς ἀποσπασθέντας ἀπʼ αὐτῶν, εὐθυδρομήσαντες ἤλθομεν εἰς τὴν ⸀Κῶ τῇ δὲ ἑξῆς εἰς τὴν Ῥόδον, κἀκεῖθεν εἰς Πάταρα· ");
INSERT INTO grcsbl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","καὶ εὑρόντες πλοῖον διαπερῶν εἰς Φοινίκην ἐπιβάντες ἀνήχθημεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","⸀ἀναφάναντεςδὲ τὴν Κύπρον καὶ καταλιπόντες αὐτὴν εὐώνυμον ἐπλέομεν εἰς Συρίαν, καὶ ⸀κατήλθομενεἰς Τύρον, ἐκεῖσε γὰρ ⸂τὸ πλοῖον ἦν ἀποφορτιζόμενον τὸν γόμον. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","⸂ἀνευρόντες δὲ τοὺς μαθητὰς ἐπεμείναμεν αὐτοῦ ἡμέρας ἑπτά, οἵτινες τῷ Παύλῳ ἔλεγον διὰ τοῦ πνεύματος μὴ ⸀ἐπιβαίνεινεἰς ⸀Ἱεροσόλυμα ");
INSERT INTO grcsbl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ὅτε δὲ ἐγένετο ⸂ἐξαρτίσαι ἡμᾶς τὰς ἡμέρας, ἐξελθόντες ἐπορευόμεθα προπεμπόντων ἡμᾶς πάντων σὺν γυναιξὶ καὶ τέκνοις ἕως ἔξω τῆς πόλεως, καὶ θέντες τὰ γόνατα ἐπὶ τὸν αἰγιαλὸν ⸀προσευξάμενοι ");
INSERT INTO grcsbl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","⸂ἀπησπασάμεθα ἀλλήλους, καὶ⸃ ⸀ἐνέβημεν εἰς τὸ πλοῖον, ἐκεῖνοι δὲ ὑπέστρεψαν εἰς τὰ ἴδια. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ἡμεῖς δὲ τὸν πλοῦν διανύσαντες ἀπὸ Τύρου κατηντήσαμεν εἰς Πτολεμαΐδα, καὶ ἀσπασάμενοι τοὺς ἀδελφοὺς ἐμείναμεν ἡμέραν μίαν παρʼ αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","τῇ δὲ ἐπαύριον ἐξελθόντες ⸀ἤλθομενεἰς Καισάρειαν, καὶ εἰσελθόντες εἰς τὸν οἶκον Φιλίππου τοῦ εὐαγγελιστοῦ ὄντος ἐκ τῶν ἑπτὰ ἐμείναμεν παρʼ αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","τούτῳ δὲ ἦσαν θυγατέρες ⸂τέσσαρες παρθένοι προφητεύουσαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ἐπιμενόντων ⸀δὲἡμέρας πλείους κατῆλθέν τις ἀπὸ τῆς Ἰουδαίας προφήτης ὀνόματι Ἅγαβος, ");
INSERT INTO grcsbl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","καὶ ἐλθὼν πρὸς ἡμᾶς καὶ ἄρας τὴν ζώνην τοῦ Παύλου δήσας ⸀ἑαυτοῦτοὺς πόδας καὶ τὰς χεῖρας εἶπεν· Τάδε λέγει τὸ πνεῦμα τὸ ἅγιον Τὸν ἄνδρα οὗ ἐστιν ἡ ζώνη αὕτη, οὕτως δήσουσιν ἐν Ἰερουσαλὴμ οἱ Ἰουδαῖοι καὶ παραδώσουσιν εἰς χεῖρας ἐθνῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ὡς δὲ ἠκούσαμεν ταῦτα, παρεκαλοῦμεν ἡμεῖς τε καὶ οἱ ἐντόπιοι τοῦ μὴ ἀναβαίνειν αὐτὸν εἰς Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","⸂τότε ἀπεκρίθη ὁ Παῦλος· Τί ποιεῖτε κλαίοντες καὶ συνθρύπτοντές μου τὴν καρδίαν; ἐγὼ γὰρ οὐ μόνον δεθῆναι ἀλλὰ καὶ ἀποθανεῖν εἰς Ἰερουσαλὴμ ἑτοίμως ἔχω ὑπὲρ τοῦ ὀνόματος τοῦ κυρίου Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","μὴ πειθομένου δὲ αὐτοῦ ἡσυχάσαμεν εἰπόντες· ⸂Τοῦ κυρίου τὸ θέλημα ⸀γινέσθω ");
INSERT INTO grcsbl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Μετὰ δὲ τὰς ἡμέρας ταύτας ἐπισκευασάμενοι ἀνεβαίνομεν εἰς ⸀Ἱεροσόλυμα ");
INSERT INTO grcsbl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","συνῆλθον δὲ καὶ τῶν μαθητῶν ἀπὸ Καισαρείας σὺν ἡμῖν, ἄγοντες παρʼ ᾧ ξενισθῶμεν Μνάσωνί τινι Κυπρίῳ, ἀρχαίῳ μαθητῇ. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Γενομένων δὲ ἡμῶν εἰς Ἱεροσόλυμα ἀσμένως ⸀ἀπεδέξαντοἡμᾶς οἱ ἀδελφοί. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","τῇ δὲ ἐπιούσῃ εἰσῄει ὁ Παῦλος σὺν ἡμῖν πρὸς Ἰάκωβον, πάντες τε παρεγένοντο οἱ πρεσβύτεροι. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","καὶ ἀσπασάμενος αὐτοὺς ἐξηγεῖτο καθʼ ἓν ἕκαστον ὧν ἐποίησεν ὁ θεὸς ἐν τοῖς ἔθνεσιν διὰ τῆς διακονίας αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","οἱ δὲ ἀκούσαντες ἐδόξαζον τὸν ⸀θεόν ⸂εἶπόν τε αὐτῷ· Θεωρεῖς, ἀδελφέ, πόσαι μυριάδες εἰσὶν ⸂ἐν τοῖς Ἰουδαίοις τῶν πεπιστευκότων, καὶ πάντες ζηλωταὶ τοῦ νόμου ὑπάρχουσιν· ");
INSERT INTO grcsbl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","κατηχήθησαν δὲ περὶ σοῦ ὅτι ἀποστασίαν διδάσκεις ἀπὸ Μωϋσέως τοὺς κατὰ τὰ ἔθνη πάντας Ἰουδαίους, λέγων μὴ περιτέμνειν αὐτοὺς τὰ τέκνα μηδὲ τοῖς ἔθεσιν περιπατεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","τί οὖν ἐστιν; πάντως ⸀ἀκούσονταιὅτι ἐλήλυθας. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","τοῦτο οὖν ποίησον ὅ σοι λέγομεν· εἰσὶν ἡμῖν ἄνδρες τέσσαρες εὐχὴν ἔχοντες ⸀ἀφʼἑαυτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","τούτους παραλαβὼν ἁγνίσθητι σὺν αὐτοῖς καὶ δαπάνησον ἐπʼ αὐτοῖς ἵνα ⸀ξυρήσονταιτὴν κεφαλήν, καὶ ⸀γνώσονταιπάντες ὅτι ὧν κατήχηνται περὶ σοῦ οὐδέν ἐστιν, ἀλλὰ στοιχεῖς καὶ αὐτὸς ⸂φυλάσσων τὸν νόμον. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","περὶ δὲ τῶν πεπιστευκότων ἐθνῶν ἡμεῖς ⸀ἀπεστείλαμεν⸀κρίναντεςφυλάσσεσθαι αὐτοὺς τό τε εἰδωλόθυτον ⸀καὶαἷμα καὶ πνικτὸν καὶ πορνείαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","τότε ὁ Παῦλος παραλαβὼν τοὺς ἄνδρας τῇ ἐχομένῃ ἡμέρᾳ σὺν αὐτοῖς ἁγνισθεὶς εἰσῄει εἰς τὸ ἱερόν, διαγγέλλων τὴν ἐκπλήρωσιν τῶν ἡμερῶν τοῦ ἁγνισμοῦ ἕως οὗ προσηνέχθη ὑπὲρ ἑνὸς ἑκάστου αὐτῶν ἡ προσφορά. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ὡς δὲ ἔμελλον αἱ ἑπτὰ ἡμέραι συντελεῖσθαι, οἱ ἀπὸ τῆς Ἀσίας Ἰουδαῖοι θεασάμενοι αὐτὸν ἐν τῷ ἱερῷ συνέχεον πάντα τὸν ὄχλον καὶ ἐπέβαλον ⸂ἐπʼ αὐτὸν τὰς χεῖρας, ");
INSERT INTO grcsbl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","κράζοντες· Ἄνδρες Ἰσραηλῖται, βοηθεῖτε· οὗτός ἐστιν ὁ ἄνθρωπος ὁ κατὰ τοῦ λαοῦ καὶ τοῦ νόμου καὶ τοῦ τόπου τούτου πάντας ⸀πανταχῇδιδάσκων, ἔτι τε καὶ Ἕλληνας εἰσήγαγεν εἰς τὸ ἱερὸν καὶ κεκοίνωκεν τὸν ἅγιον τόπον τοῦτον. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ἦσαν γὰρ ⸀προεωρακότεςΤρόφιμον τὸν Ἐφέσιον ἐν τῇ πόλει σὺν αὐτῷ, ὃν ἐνόμιζον ὅτι εἰς τὸ ἱερὸν εἰσήγαγεν ὁ Παῦλος. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ἐκινήθη τε ἡ πόλις ὅλη καὶ ἐγένετο συνδρομὴ τοῦ λαοῦ, καὶ ἐπιλαβόμενοι τοῦ Παύλου εἷλκον αὐτὸν ἔξω τοῦ ἱεροῦ, καὶ εὐθέως ἐκλείσθησαν αἱ θύραι. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ζητούντων ⸀τεαὐτὸν ἀποκτεῖναι ἀνέβη φάσις τῷ χιλιάρχῳ τῆς σπείρης ὅτι ὅλη ⸀συγχύννεταιἸερουσαλήμ, ");
INSERT INTO grcsbl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ὃς ἐξαυτῆς παραλαβὼν στρατιώτας καὶ ἑκατοντάρχας κατέδραμεν ἐπʼ αὐτούς, οἱ δὲ ἰδόντες τὸν χιλίαρχον καὶ τοὺς στρατιώτας ἐπαύσαντο τύπτοντες τὸν Παῦλον. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","⸂τότε ἐγγίσας ὁ χιλίαρχος ἐπελάβετο αὐτοῦ καὶ ἐκέλευσε δεθῆναι ἁλύσεσι δυσί, καὶ ἐπυνθάνετο ⸀τίςεἴη καὶ τί ἐστιν πεποιηκώς. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ἄλλοι δὲ ἄλλο τι ⸀ἐπεφώνουνἐν τῷ ὄχλῳ· μὴ ⸂δυναμένου δὲ αὐτοῦ γνῶναι τὸ ἀσφαλὲς διὰ τὸν θόρυβον ἐκέλευσεν ἄγεσθαι αὐτὸν εἰς τὴν παρεμβολήν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ὅτε δὲ ἐγένετο ἐπὶ τοὺς ἀναβαθμούς, συνέβη βαστάζεσθαι αὐτὸν ὑπὸ τῶν στρατιωτῶν διὰ τὴν βίαν τοῦ ὄχλου, ");
INSERT INTO grcsbl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ἠκολούθει γὰρ τὸ πλῆθος τοῦ λαοῦ ⸀κράζοντες Αἶρε αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Μέλλων τε εἰσάγεσθαι εἰς τὴν παρεμβολὴν ὁ Παῦλος λέγει τῷ χιλιάρχῳ· Εἰ ἔξεστίν μοι εἰπεῖν ⸀τιπρὸς σέ; ὁ δὲ ἔφη· Ἑλληνιστὶ γινώσκεις; ");
INSERT INTO grcsbl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","οὐκ ἄρα σὺ εἶ ὁ Αἰγύπτιος ὁ πρὸ τούτων τῶν ἡμερῶν ἀναστατώσας καὶ ἐξαγαγὼν εἰς τὴν ἔρημον τοὺς τετρακισχιλίους ἄνδρας τῶν σικαρίων; ");
INSERT INTO grcsbl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","εἶπεν δὲ ὁ Παῦλος· Ἐγὼ ἄνθρωπος μέν εἰμι Ἰουδαῖος, Ταρσεὺς τῆς Κιλικίας, οὐκ ἀσήμου πόλεως πολίτης· δέομαι δέ σου, ἐπίτρεψόν μοι λαλῆσαι πρὸς τὸν λαόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ἐπιτρέψαντος δὲ αὐτοῦ ὁ Παῦλος ἑστὼς ἐπὶ τῶν ἀναβαθμῶν κατέσεισε τῇ χειρὶ τῷ λαῷ, πολλῆς δὲ σιγῆς γενομένης ⸀προσεφώνησεντῇ Ἑβραΐδι διαλέκτῳ λέγων ");
INSERT INTO grcsbl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ἄνδρες ἀδελφοὶ καὶ πατέρες, ἀκούσατέ μου τῆς πρὸς ὑμᾶς νυνὶ ἀπολογίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ἀκούσαντες δὲ ὅτι τῇ Ἑβραΐδι διαλέκτῳ προσεφώνει αὐτοῖς μᾶλλον παρέσχον ἡσυχίαν. καὶ φησίν· ");
INSERT INTO grcsbl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","⸀Ἐγώεἰμι ἀνὴρ Ἰουδαῖος, γεγεννημένος ἐν Ταρσῷ τῆς Κιλικίας, ἀνατεθραμμένος δὲ ἐν τῇ πόλει ταύτῃ παρὰ τοὺς πόδας Γαμαλιήλ, πεπαιδευμένος κατὰ ἀκρίβειαν τοῦ πατρῴου νόμου, ζηλωτὴς ὑπάρχων τοῦ θεοῦ καθὼς πάντες ὑμεῖς ἐστε σήμερον, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ὃς ταύτην τὴν ὁδὸν ἐδίωξα ἄχρι θανάτου, δεσμεύων καὶ παραδιδοὺς εἰς φυλακὰς ἄνδρας τε καὶ γυναῖκας, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ὡς καὶ ὁ ἀρχιερεὺς μαρτυρεῖ μοι καὶ πᾶν τὸ πρεσβυτέριον· παρʼ ὧν καὶ ἐπιστολὰς δεξάμενος πρὸς τοὺς ἀδελφοὺς εἰς Δαμασκὸν ἐπορευόμην ἄξων καὶ τοὺς ἐκεῖσε ὄντας δεδεμένους εἰς Ἰερουσαλὴμ ἵνα τιμωρηθῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ἐγένετο δέ μοι πορευομένῳ καὶ ἐγγίζοντι τῇ Δαμασκῷ περὶ μεσημβρίαν ἐξαίφνης ἐκ τοῦ οὐρανοῦ περιαστράψαι φῶς ἱκανὸν περὶ ἐμέ, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ἔπεσά τε εἰς τὸ ἔδαφος καὶ ἤκουσα φωνῆς λεγούσης μοι· Σαοὺλ Σαούλ, τί με διώκεις; ");
INSERT INTO grcsbl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ἐγὼ δὲ ἀπεκρίθην· Τίς εἶ, κύριε; εἶπέν τε πρὸς ⸀ἐμέ Ἐγώ εἰμι Ἰησοῦς ὁ Ναζωραῖος ὃν σὺ διώκεις. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","οἱ δὲ σὺν ἐμοὶ ὄντες τὸ μὲν φῶς ⸀ἐθεάσαντοτὴν δὲ φωνὴν οὐκ ἤκουσαν τοῦ λαλοῦντός μοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","εἶπον δέ· Τί ποιήσω, κύριε; ὁ δὲ κύριος εἶπεν πρός με· Ἀναστὰς πορεύου εἰς Δαμασκόν, κἀκεῖ σοι λαληθήσεται περὶ πάντων ὧν τέτακταί σοι ποιῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ὡς δὲ οὐκ ἐνέβλεπον ἀπὸ τῆς δόξης τοῦ φωτὸς ἐκείνου, χειραγωγούμενος ὑπὸ τῶν συνόντων μοι ἦλθον εἰς Δαμασκόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ἁνανίας δέ τις ἀνὴρ ⸀εὐλαβὴςκατὰ τὸν νόμον μαρτυρούμενος ὑπὸ πάντων τῶν κατοικούντων Ἰουδαίων, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ἐλθὼν πρὸς ⸀ἐμὲκαὶ ἐπιστὰς εἶπέν μοι· Σαοὺλ ἀδελφέ, ἀνάβλεψον· κἀγὼ αὐτῇ τῇ ὥρᾳ ἀνέβλεψα εἰς αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ὁ δὲ εἶπεν· Ὁ θεὸς τῶν πατέρων ἡμῶν προεχειρίσατό σε γνῶναι τὸ θέλημα αὐτοῦ καὶ ἰδεῖν τὸν δίκαιον καὶ ἀκοῦσαι φωνὴν ἐκ τοῦ στόματος αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ὅτι ἔσῃ μάρτυς αὐτῷ πρὸς πάντας ἀνθρώπους ὧν ἑώρακας καὶ ἤκουσας. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","καὶ νῦν τί μέλλεις; ἀναστὰς βάπτισαι καὶ ἀπόλουσαι τὰς ἁμαρτίας σου ἐπικαλεσάμενος τὸ ὄνομα ⸀αὐτοῦ ");
INSERT INTO grcsbl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ἐγένετο δέ μοι ὑποστρέψαντι εἰς Ἰερουσαλὴμ καὶ προσευχομένου μου ἐν τῷ ἱερῷ γενέσθαι με ἐν ἐκστάσει ");
INSERT INTO grcsbl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","καὶ ἰδεῖν αὐτὸν λέγοντά μοι· Σπεῦσον καὶ ἔξελθε ἐν τάχει ἐξ Ἰερουσαλήμ, διότι οὐ παραδέξονταί ⸀σουμαρτυρίαν περὶ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","κἀγὼ εἶπον· Κύριε, αὐτοὶ ἐπίστανται ὅτι ἐγὼ ἤμην φυλακίζων καὶ δέρων κατὰ τὰς συναγωγὰς τοὺς πιστεύοντας ἐπὶ σέ· ");
INSERT INTO grcsbl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","καὶ ὅτε ⸀ἐξεχύννετοτὸ αἷμα Στεφάνου τοῦ μάρτυρός σου, καὶαὐτὸς ἤμην ἐφεστὼς καὶ συνευδοκῶν ⸀καὶ φυλάσσων τὰ ἱμάτια τῶν ἀναιρούντων αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","καὶ εἶπεν πρός με· Πορεύου, ὅτι ἐγὼ εἰς ἔθνη μακρὰν ἐξαποστελῶ σε. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ἤκουον δὲ αὐτοῦ ἄχρι τούτου τοῦ λόγου καὶ ἐπῆραν τὴν φωνὴν αὐτῶν λέγοντες· Αἶρε ἀπὸ τῆς γῆς τὸν τοιοῦτον, οὐ γὰρ καθῆκεν αὐτὸν ζῆν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","⸀κραυγαζόντων⸀τεαὐτῶν καὶ ῥιπτούντων τὰ ἱμάτια καὶ κονιορτὸν βαλλόντων εἰς τὸν ἀέρα, ");
INSERT INTO grcsbl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ἐκέλευσεν ⸂ὁ χιλίαρχος εἰσάγεσθαι αὐτὸν εἰς τὴν παρεμβολήν, ⸀εἴπαςμάστιξιν ἀνετάζεσθαι αὐτὸν ἵνα ἐπιγνῷ διʼ ἣν αἰτίαν οὕτως ἐπεφώνουν αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ὡς δὲ ⸀προέτειναναὐτὸν τοῖς ἱμᾶσιν εἶπεν πρὸς τὸν ἑστῶτα ἑκατόνταρχον ὁ Παῦλος· Εἰ ἄνθρωπον Ῥωμαῖον καὶ ἀκατάκριτον ἔξεστιν ὑμῖν μαστίζειν; ");
INSERT INTO grcsbl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ἀκούσας δὲ ὁ ἑκατοντάρχης προσελθὼν ⸂τῷ χιλιάρχῳ ἀπήγγειλεν λέγων· ⸀Τίμέλλεις ποιεῖν; ὁ γὰρ ἄνθρωπος οὗτος Ῥωμαῖός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","προσελθὼν δὲ ὁ χιλίαρχος εἶπεν αὐτῷ· Λέγε μοι, ⸀σὺῬωμαῖος εἶ; ὁ δὲ ἔφη· Ναί. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ἀπεκρίθη ⸀δὲὁ χιλίαρχος· Ἐγὼ πολλοῦ κεφαλαίου τὴν πολιτείαν ταύτην ἐκτησάμην. ὁ δὲ Παῦλος ἔφη· Ἐγὼ δὲ καὶ γεγέννημαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","εὐθέως οὖν ἀπέστησαν ἀπʼ αὐτοῦ οἱ μέλλοντες αὐτὸν ἀνετάζειν· καὶ ὁ χιλίαρχος δὲ ἐφοβήθη ἐπιγνοὺς ὅτι Ῥωμαῖός ἐστιν καὶ ὅτι ⸂αὐτὸν ἦν δεδεκώς. ");
INSERT INTO grcsbl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Τῇ δὲ ἐπαύριον βουλόμενος γνῶναι τὸ ἀσφαλὲς τὸ τί κατηγορεῖται ⸀ὑπὸτῶν Ἰουδαίων ἔλυσεν ⸀αὐτόν καὶ ἐκέλευσεν ⸀συνελθεῖντοὺς ἀρχιερεῖς καὶ ⸀πᾶντὸ ⸀συνέδριον καὶ καταγαγὼν τὸν Παῦλον ἔστησεν εἰς αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ἀτενίσας δὲ ⸂ὁ Παῦλος τῷ συνεδρίῳ εἶπεν· Ἄνδρες ἀδελφοί, ἐγὼ πάσῃ συνειδήσει ἀγαθῇ πεπολίτευμαι τῷ θεῷ ἄχρι ταύτης τῆς ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ὁ δὲ ἀρχιερεὺς Ἁνανίας ἐπέταξεν τοῖς παρεστῶσιν αὐτῷ τύπτειν αὐτοῦ τὸ στόμα. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","τότε ὁ Παῦλος πρὸς αὐτὸν εἶπεν· Τύπτειν σε μέλλει ὁ θεός, τοῖχε κεκονιαμένε· καὶ σὺ κάθῃ κρίνων με κατὰ τὸν νόμον, καὶ παρανομῶν κελεύεις με τύπτεσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","οἱ δὲ παρεστῶτες εἶπαν· Τὸν ἀρχιερέα τοῦ θεοῦ λοιδορεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ἔφη τε ὁ Παῦλος· Οὐκ ᾔδειν, ἀδελφοί, ὅτιἐστὶν ἀρχιερεύς· γέγραπται γὰρ ⸀ὅτι Ἄρχοντα τοῦ λαοῦ σου οὐκ ἐρεῖς κακῶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Γνοὺς δὲ ὁ Παῦλος ὅτι τὸ ἓν μέρος ἐστὶν Σαδδουκαίων τὸ δὲ ἕτερον Φαρισαίων ⸀ἔκραζενἐν τῷ συνεδρίῳ· Ἄνδρες ἀδελφοί, ἐγὼ Φαρισαῖός εἰμι, υἱὸς ⸀Φαρισαίων περὶ ἐλπίδος καὶ ἀναστάσεως νεκρῶν ⸀ἐγὼκρίνομαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","τοῦτο δὲ αὐτοῦ ⸀λαλοῦντοςἐγένετο στάσις τῶν Φαρισαίων ⸂καὶ Σαδδουκαίων, καὶ ἐσχίσθη τὸ πλῆθος. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Σαδδουκαῖοι ⸀μὲνγὰρ λέγουσιν μὴ εἶναι ἀνάστασιν ⸀μήτεἄγγελον μήτε πνεῦμα, Φαρισαῖοι δὲ ὁμολογοῦσιν τὰ ἀμφότερα. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ἐγένετο δὲ κραυγὴ μεγάλη, καὶ ἀναστάντες ⸂τινὲς τῶν γραμματέων τοῦ μέρους τῶν Φαρισαίων διεμάχοντο λέγοντες· Οὐδὲν κακὸν εὑρίσκομεν ἐν τῷ ἀνθρώπῳ τούτῳ· εἰ δὲ πνεῦμα ἐλάλησεν αὐτῷ ἢ ⸀ἄγγελος ");
INSERT INTO grcsbl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","πολλῆς δὲ ⸀γινομένηςστάσεως ⸀φοβηθεὶςὁ χιλίαρχος μὴ διασπασθῇ ὁ Παῦλος ὑπʼ αὐτῶν ἐκέλευσεν τὸ στράτευμα ⸀καταβὰνἁρπάσαι αὐτὸν ἐκ μέσου αὐτῶν, ἄγειν ⸀τεεἰς τὴν παρεμβολήν. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Τῇ δὲ ἐπιούσῃ νυκτὶ ἐπιστὰς αὐτῷ ὁ κύριος εἶπεν· ⸀Θάρσει ὡς γὰρ διεμαρτύρω τὰ περὶ ἐμοῦ εἰς Ἰερουσαλὴμ οὕτω σε δεῖ καὶ εἰς Ῥώμην μαρτυρῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Γενομένης δὲ ἡμέρας ποιήσαντες ⸂συστροφὴν οἱ Ἰουδαῖοι ἀνεθεμάτισαν ἑαυτοὺς λέγοντες μήτε φαγεῖν μήτε πιεῖν ἕως οὗ ἀποκτείνωσιν τὸν Παῦλον. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ἦσαν δὲ πλείους τεσσεράκοντα οἱ ταύτην τὴν συνωμοσίαν ⸀ποιησάμενοι ");
INSERT INTO grcsbl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","οἵτινες προσελθόντες τοῖς ἀρχιερεῦσιν καὶ τοῖς πρεσβυτέροις εἶπαν· Ἀναθέματι ἀνεθεματίσαμεν ἑαυτοὺς μηδενὸς γεύσασθαι ἕως οὗ ἀποκτείνωμεν τὸν Παῦλον. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","νῦν οὖν ὑμεῖς ἐμφανίσατε τῷ χιλιάρχῳ σὺν τῷ συνεδρίῳ ⸀ὅπως⸂καταγάγῃ αὐτὸν εἰς ὑμᾶς ὡς μέλλοντας διαγινώσκειν ἀκριβέστερον τὰ περὶ αὐτοῦ· ἡμεῖς δὲ πρὸ τοῦ ἐγγίσαι αὐτὸν ἕτοιμοί ἐσμεν τοῦ ἀνελεῖν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ἀκούσας δὲ ὁ υἱὸς τῆς ἀδελφῆς Παύλου ⸂τὴν ἐνέδραν παραγενόμενος καὶ εἰσελθὼν εἰς τὴν παρεμβολὴν ἀπήγγειλεν τῷ Παύλῳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","προσκαλεσάμενος δὲ ὁ Παῦλος ἕνα τῶν ἑκατονταρχῶν ἔφη· Τὸν νεανίαν τοῦτον ⸀ἄπαγεπρὸς τὸν χιλίαρχον, ἔχει γὰρ ⸂ἀπαγγεῖλαί τι αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ὁ μὲν οὖν παραλαβὼν αὐτὸν ἤγαγεν πρὸς τὸν χιλίαρχον καὶ φησίν· Ὁ δέσμιος Παῦλος προσκαλεσάμενός με ἠρώτησεν τοῦτον τὸν ⸀νεανίανἀγαγεῖν πρὸς σέ, ἔχοντά τι λαλῆσαί σοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ἐπιλαβόμενος δὲ τῆς χειρὸς αὐτοῦ ὁ χιλίαρχος καὶ ἀναχωρήσας κατʼ ἰδίαν ἐπυνθάνετο· Τί ἐστιν ὃ ἔχεις ἀπαγγεῖλαί μοι; ");
INSERT INTO grcsbl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","εἶπεν δὲ ὅτι Οἱ Ἰουδαῖοι συνέθεντο τοῦ ἐρωτῆσαί σε ὅπως αὔριον ⸂τὸν Παῦλον καταγάγῃς εἰς τὸ συνέδριον ὡς ⸀μέλλοντι ἀκριβέστερον πυνθάνεσθαι περὶ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","σὺ οὖν μὴ πεισθῇς αὐτοῖς, ἐνεδρεύουσιν γὰρ αὐτὸν ἐξ αὐτῶν ἄνδρες πλείους τεσσεράκοντα, οἵτινες ἀνεθεμάτισαν ἑαυτοὺς μήτε φαγεῖν μήτε πιεῖν ἕως οὗ ἀνέλωσιν αὐτόν, καὶ νῦν ⸂εἰσιν ἕτοιμοι προσδεχόμενοι τὴν ἀπὸ σοῦ ἐπαγγελίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ὁ μὲν οὖν χιλίαρχος ἀπέλυσε τὸν ⸀νεανίσκονπαραγγείλας μηδενὶ ἐκλαλῆσαι ὅτι ταῦτα ἐνεφάνισας πρὸς ⸀ἐμέ ");
INSERT INTO grcsbl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Καὶ προσκαλεσάμενός ⸂τινας δύο τῶν ἑκατονταρχῶν εἶπεν· Ἑτοιμάσατε στρατιώτας διακοσίους ὅπως πορευθῶσιν ἕως Καισαρείας, καὶ ἱππεῖς ἑβδομήκοντα καὶ δεξιολάβους διακοσίους, ἀπὸ τρίτης ὥρας τῆς νυκτός, ");
INSERT INTO grcsbl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","κτήνη τε παραστῆσαι ἵνα ἐπιβιβάσαντες τὸν Παῦλον διασώσωσι πρὸς Φήλικα τὸν ἡγεμόνα, ");
INSERT INTO grcsbl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","γράψας ἐπιστολὴν ⸀ἔχουσαντὸν τύπον τοῦτον· ");
INSERT INTO grcsbl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Κλαύδιος Λυσίας τῷ κρατίστῳ ἡγεμόνι Φήλικι χαίρειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","τὸν ἄνδρα τοῦτον συλλημφθέντα ὑπὸ τῶν Ἰουδαίων καὶ μέλλοντα ἀναιρεῖσθαι ὑπʼ αὐτῶν ἐπιστὰς σὺν τῷ στρατεύματι ⸀ἐξειλάμην μαθὼν ὅτι Ῥωμαῖός ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","βουλόμενός ⸀τε⸀ἐπιγνῶναιτὴν αἰτίαν διʼ ἣν ἐνεκάλουν αὐτῷ, ⸀κατήγαγονεἰς τὸ συνέδριον αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ὃν εὗρον ἐγκαλούμενον περὶ ζητημάτων τοῦ νόμου αὐτῶν, μηδὲ ⸀δὲ ἄξιον θανάτου ἢ δεσμῶν ⸂ἔχοντα ἔγκλημα. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","μηνυθείσης δέ μοι ἐπιβουλῆς εἰς τὸν ⸀ἄνδραἔσεσθαι ⸀ἐξαυτῆςἔπεμψα πρὸς σέ, παραγγείλας καὶ τοῖς κατηγόροις ⸀λέγεινπρὸς αὐτὸν ἐπὶ ⸀σοῦ ");
INSERT INTO grcsbl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Οἱ μὲν οὖν στρατιῶται κατὰ τὸ διατεταγμένον αὐτοῖς ἀναλαβόντες τὸν Παῦλον ἤγαγον ⸀διὰνυκτὸς εἰς τὴν Ἀντιπατρίδα· ");
INSERT INTO grcsbl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","τῇ δὲ ἐπαύριον ἐάσαντες τοὺς ἱππεῖς ⸀ἀπέρχεσθαισὺν αὐτῷ ὑπέστρεψαν εἰς τὴν παρεμβολήν· ");
INSERT INTO grcsbl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","οἵτινες εἰσελθόντες εἰς τὴν Καισάρειαν καὶ ἀναδόντες τὴν ἐπιστολὴν τῷ ἡγεμόνι παρέστησαν καὶ τὸν Παῦλον αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ἀναγνοὺς ⸀δὲκαὶ ἐπερωτήσας ἐκ ποίας ⸀ἐπαρχείαςἐστὶν καὶ πυθόμενος ὅτι ἀπὸ Κιλικίας, ");
INSERT INTO grcsbl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Διακούσομαί σου, ἔφη, ὅταν καὶ οἱ κατήγοροί σου παραγένωνται· ⸀κελεύσαςἐν τῷ πραιτωρίῳ ⸀τοῦἩρῴδου φυλάσσεσθαι ⸀αὐτόν ");
INSERT INTO grcsbl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Μετὰ δὲ πέντε ἡμέρας κατέβη ὁ ἀρχιερεὺς Ἁνανίας μετὰ ⸂πρεσβυτέρων τινῶν καὶ ῥήτορος Τερτύλλου τινός, οἵτινες ἐνεφάνισαν τῷ ἡγεμόνι κατὰ τοῦ Παύλου. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","κληθέντος δὲ αὐτοῦ ἤρξατο κατηγορεῖν ὁ Τέρτυλλος λέγων· Πολλῆς εἰρήνης τυγχάνοντες διὰ σοῦ καὶ ⸀διορθωμάτωνγινομένων τῷ ἔθνει τούτῳ διὰ τῆς σῆς προνοίας ");
INSERT INTO grcsbl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","πάντῃ τε καὶ πανταχοῦ ἀποδεχόμεθα, κράτιστε Φῆλιξ, μετὰ πάσης εὐχαριστίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ἵνα δὲ μὴ ἐπὶ πλεῖόν σε ἐγκόπτω, παρακαλῶ ἀκοῦσαί σε ἡμῶν συντόμως τῇ σῇ ἐπιεικείᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","εὑρόντες γὰρ τὸν ἄνδρα τοῦτον λοιμὸν καὶ κινοῦντα ⸀στάσειςπᾶσι τοῖς Ἰουδαίοις τοῖς κατὰ τὴν οἰκουμένην πρωτοστάτην τε τῆς τῶν Ναζωραίων αἱρέσεως, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ὃς καὶ τὸ ἱερὸν ἐπείρασεν βεβηλῶσαι, ὃν καὶ ⸀ἐκρατήσαμεν ");
INSERT INTO grcsbl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","παρʼ οὗ δυνήσῃ αὐτὸς ἀνακρίνας περὶ πάντων τούτων ἐπιγνῶναι ὧν ἡμεῖς κατηγοροῦμεν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","συνεπέθεντο δὲ καὶ οἱ Ἰουδαῖοι φάσκοντες ταῦτα οὕτως ἔχειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ἀπεκρίθη ⸀τεὁ Παῦλος νεύσαντος αὐτῷ τοῦ ἡγεμόνος λέγειν· Ἐκ πολλῶν ἐτῶν ὄντα σε κριτὴν τῷ ἔθνει τούτῳ ἐπιστάμενος ⸀εὐθύμωςτὰ περὶ ἐμαυτοῦ ἀπολογοῦμαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","δυναμένου σου ⸀ἐπιγνῶναι ὅτι οὐ πλείους εἰσίν μοι ἡμέραι ⸀δώδεκαἀφʼ ἧς ἀνέβην προσκυνήσων ⸀εἰςἸερουσαλήμ, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","καὶ οὔτε ἐν τῷ ἱερῷ εὗρόν με πρός τινα διαλεγόμενον ἢ ⸀ἐπίστασινποιοῦντα ὄχλου οὔτε ἐν ταῖς συναγωγαῖς οὔτε κατὰ τὴν πόλιν, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","⸀οὐδὲ⸀παραστῆσαιδύνανταί ⸀σοιπερὶ ὧν ⸀νυνὶκατηγοροῦσίν μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ὁμολογῶ δὲ τοῦτό σοι ὅτι κατὰ τὴν ὁδὸν ἣν λέγουσιν αἵρεσιν οὕτως λατρεύω τῷ πατρῴῳ θεῷ, πιστεύων πᾶσι τοῖς κατὰ τὸν νόμον καὶ ⸂τοῖς ἐν τοῖς προφήταις γεγραμμένοις, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ἐλπίδα ἔχων εἰς τὸν θεόν, ἣν καὶ αὐτοὶ οὗτοι προσδέχονται, ἀνάστασιν μέλλειν ⸀ἔσεσθαιδικαίων τε καὶ ἀδίκων· ");
INSERT INTO grcsbl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ἐν τούτῳ ⸀καὶαὐτὸς ἀσκῶ ἀπρόσκοπον συνείδησιν ⸀ἔχεινπρὸς τὸν θεὸν καὶ τοὺς ἀνθρώπους διὰ παντός. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","διʼ ἐτῶν δὲ πλειόνων ⸂ἐλεημοσύνας ποιήσων εἰς τὸ ἔθνος μου παρεγενόμην καὶ προσφοράς, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ἐν ⸀αἷςεὗρόν με ἡγνισμένον ἐν τῷ ἱερῷ, οὐ μετὰ ὄχλου οὐδὲ μετὰ θορύβου, ");
INSERT INTO grcsbl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","τινὲς δὲ ἀπὸ τῆς Ἀσίας Ἰουδαῖοι, οὓς ⸀ἔδειἐπὶ σοῦ παρεῖναι καὶ κατηγορεῖν εἴ τι ἔχοιεν πρὸς ⸀ἐμέ ");
INSERT INTO grcsbl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ἢ αὐτοὶ οὗτοι εἰπάτωσαν τί ⸀εὗρονἀδίκημα στάντος μου ἐπὶ τοῦ συνεδρίου ");
INSERT INTO grcsbl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ἢ περὶ μιᾶς ταύτης φωνῆς ἧς ἐκέκραξα ⸂ἐν αὐτοῖς ἑστὼς ὅτι Περὶ ἀναστάσεως νεκρῶν ἐγὼ κρίνομαι σήμερον ⸀ἐφʼὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","⸂Ἀνεβάλετο δὲ αὐτοὺς ὁ Φῆλιξ, ἀκριβέστερον εἰδὼς τὰ περὶ τῆς ὁδοῦ, ⸀εἴπας Ὅταν Λυσίας ὁ χιλίαρχος καταβῇ διαγνώσομαι τὰ καθʼ ὑμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","⸀διαταξάμενοςτῷ ἑκατοντάρχῃ τηρεῖσθαι ⸀αὐτὸνἔχειν τε ἄνεσιν καὶ μηδένα κωλύειν τῶν ἰδίων αὐτοῦ ⸀ὑπηρετεῖναὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Μετὰ δὲ ἡμέρας τινὰς παραγενόμενος ὁ Φῆλιξ σὺν Δρουσίλλῃ τῇ ⸀ἰδίᾳγυναικὶ οὔσῃ Ἰουδαίᾳ μετεπέμψατο τὸν Παῦλον καὶ ἤκουσεν αὐτοῦ περὶ τῆς εἰς Χριστὸν ⸀Ἰησοῦνπίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","διαλεγομένου δὲ αὐτοῦ περὶ δικαιοσύνης καὶ ἐγκρατείας καὶ τοῦ κρίματος τοῦ ⸀μέλλοντοςἔμφοβος γενόμενος ὁ Φῆλιξ ἀπεκρίθη· Τὸ νῦν ἔχον πορεύου, καιρὸν δὲ μεταλαβὼν μετακαλέσομαί σε· ");
INSERT INTO grcsbl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ἅμα καὶ ἐλπίζων ὅτι χρήματα δοθήσεται αὐτῷ ὑπὸ τοῦ ⸀Παύλου διὸ καὶ πυκνότερον αὐτὸν μεταπεμπόμενος ὡμίλει αὐτῷ. ");
INSERT INTO grcsbl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Διετίας δὲ πληρωθείσης ἔλαβεν διάδοχον ὁ Φῆλιξ Πόρκιον Φῆστον· θέλων τε ⸀χάριτακαταθέσθαι τοῖς Ἰουδαίοις ὁ Φῆλιξ κατέλιπε τὸν Παῦλον δεδεμένον. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Φῆστος οὖν ἐπιβὰς τῇ ἐπαρχείᾳ μετὰ τρεῖς ἡμέρας ἀνέβη εἰς Ἱεροσόλυμα ἀπὸ Καισαρείας, ");
INSERT INTO grcsbl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ἐνεφάνισάν ⸀τεαὐτῷ ⸂οἱ ἀρχιερεῖς καὶ οἱ πρῶτοι τῶν Ἰουδαίων κατὰ τοῦ Παύλου, καὶ παρεκάλουν αὐτὸν ");
INSERT INTO grcsbl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","αἰτούμενοι χάριν κατʼ αὐτοῦ ὅπως μεταπέμψηται αὐτὸν εἰς Ἰερουσαλήμ, ἐνέδραν ποιοῦντες ἀνελεῖν αὐτὸν κατὰ τὴν ὁδόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ὁ μὲν οὖν Φῆστος ἀπεκρίθη τηρεῖσθαι τὸν Παῦλον ⸂εἰς Καισάρειαν, ἑαυτὸν δὲ μέλλειν ἐν τάχει ἐκπορεύεσθαι· ");
INSERT INTO grcsbl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Οἱ οὖν ⸂ἐν ὑμῖν, φησίν, δυνατοὶ⸃ συγκαταβάντες εἴ τί ἐστιν ἐν τῷ ἀνδρὶ ⸀ἄτοπον κατηγορείτωσαν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Διατρίψας δὲ ἐν αὐτοῖς ἡμέρας ⸂οὐ πλείους ὀκτὼ ἢ δέκα, καταβὰς εἰς Καισάρειαν, τῇ ἐπαύριον καθίσας ἐπὶ τοῦ βήματος ἐκέλευσεν τὸν Παῦλον ἀχθῆναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","παραγενομένου δὲ αὐτοῦ περιέστησαν ⸀αὐτὸνοἱ ἀπὸ Ἱεροσολύμων καταβεβηκότες Ἰουδαῖοι, πολλὰ καὶ βαρέα αἰτιώματα ⸀καταφέροντεςἃ οὐκ ἴσχυον ἀποδεῖξαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","⸂τοῦ Παύλου ἀπολογουμένου ὅτι Οὔτε εἰς τὸν νόμον τῶν Ἰουδαίων οὔτε εἰς τὸ ἱερὸν οὔτε εἰς Καίσαρά τι ἥμαρτον. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ὁ Φῆστος δὲ ⸂θέλων τοῖς Ἰουδαίοις χάριν καταθέσθαι ἀποκριθεὶς τῷ Παύλῳ εἶπεν· Θέλεις εἰς Ἱεροσόλυμα ἀναβὰς ἐκεῖ περὶ τούτων ⸀κριθῆναιἐπʼ ἐμοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","εἶπεν δὲ ὁ Παῦλος· ⸂Ἐπὶ τοῦ βήματος Καίσαρος ἑστώς εἰμι, οὗ με δεῖ κρίνεσθαι. Ἰουδαίους οὐδὲν ⸀ἠδίκησα ὡς καὶ σὺ κάλλιον ἐπιγινώσκεις. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","εἰ μὲν ⸀οὖνἀδικῶ καὶ ἄξιον θανάτου πέπραχά τι, οὐ παραιτοῦμαι τὸ ἀποθανεῖν· εἰ δὲ οὐδέν ἐστιν ὧν οὗτοι κατηγοροῦσίν μου, οὐδείς με δύναται αὐτοῖς χαρίσασθαι· Καίσαρα ἐπικαλοῦμαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","τότε ὁ Φῆστος συλλαλήσας μετὰ τοῦ συμβουλίου ἀπεκρίθη· Καίσαρα ἐπικέκλησαι, ἐπὶ Καίσαρα πορεύσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ἡμερῶν δὲ διαγενομένων τινῶν Ἀγρίππας ὁ βασιλεὺς καὶ Βερνίκη κατήντησαν εἰς Καισάρειαν ἀσπασάμενοι τὸν Φῆστον. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ὡς δὲ πλείους ἡμέρας ⸀διέτριβονἐκεῖ, ὁ Φῆστος τῷ βασιλεῖ ἀνέθετο τὰ κατὰ τὸν Παῦλον λέγων· Ἀνήρ τίς ἐστιν καταλελειμμένος ὑπὸ Φήλικος δέσμιος, ");
INSERT INTO grcsbl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","περὶ οὗ γενομένου μου εἰς Ἱεροσόλυμα ἐνεφάνισαν οἱ ἀρχιερεῖς καὶ οἱ πρεσβύτεροι τῶν Ἰουδαίων, αἰτούμενοι κατʼ αὐτοῦ ⸀καταδίκην ");
INSERT INTO grcsbl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","πρὸς οὓς ἀπεκρίθην ὅτι οὐκ ἔστιν ἔθος Ῥωμαίοις χαρίζεσθαί τινα ⸀ἄνθρωπονπρὶν ἢ ὁ κατηγορούμενος κατὰ πρόσωπον ἔχοι τοὺς κατηγόρους τόπον τε ἀπολογίας λάβοι περὶ τοῦ ἐγκλήματος. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","συνελθόντων ⸀οὖνἐνθάδε ἀναβολὴν μηδεμίαν ποιησάμενος τῇ ἑξῆς καθίσας ἐπὶ τοῦ βήματος ἐκέλευσα ἀχθῆναι τὸν ἄνδρα· ");
INSERT INTO grcsbl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","περὶ οὗ σταθέντες οἱ κατήγοροι οὐδεμίαν αἰτίαν ⸀ἔφερονὧν ⸂ἐγὼ ὑπενόουν ⸀πονηρῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ζητήματα δέ τινα περὶ τῆς ἰδίας δεισιδαιμονίας εἶχον πρὸς αὐτὸν καὶ περί τινος Ἰησοῦ τεθνηκότος, ὃν ἔφασκεν ὁ Παῦλος ζῆν. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ἀπορούμενος δὲ ἐγὼ τὴν περὶ ⸀τούτωνζήτησιν ἔλεγον εἰ βούλοιτο πορεύεσθαι εἰς ⸀Ἱεροσόλυμακἀκεῖ κρίνεσθαι περὶ τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","τοῦ δὲ Παύλου ἐπικαλεσαμένου τηρηθῆναι αὐτὸν εἰς τὴν τοῦ Σεβαστοῦ διάγνωσιν, ἐκέλευσα τηρεῖσθαι αὐτὸν ἕως οὗ ⸀ἀναπέμψωαὐτὸν πρὸς Καίσαρα. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ἀγρίππας δὲ πρὸς τὸν ⸀Φῆστον Ἐβουλόμην καὶ αὐτὸς τοῦ ἀνθρώπου ἀκοῦσαι. ⸀Αὔριον φησίν, ἀκούσῃ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Τῇ οὖν ἐπαύριον ἐλθόντος τοῦ Ἀγρίππα καὶ τῆς Βερνίκης μετὰ πολλῆς φαντασίας καὶ εἰσελθόντων εἰς τὸ ἀκροατήριον σύν ⸀τεχιλιάρχοις καὶ ἀνδράσιν τοῖς κατʼ ⸀ἐξοχὴντῆς πόλεως καὶ κελεύσαντος τοῦ Φήστου ἤχθη ὁ Παῦλος. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","καί φησιν ὁ Φῆστος· Ἀγρίππα βασιλεῦ καὶ πάντες οἱ συμπαρόντες ἡμῖν ἄνδρες, θεωρεῖτε τοῦτον περὶ οὗ ⸀ἅπαντὸ πλῆθος τῶν Ἰουδαίων ⸀ἐνέτυχόνμοι ἔν τε Ἱεροσολύμοις καὶ ἐνθάδε, ⸀βοῶντεςμὴ δεῖν ⸂αὐτὸν ζῆν μηκέτι. ");
INSERT INTO grcsbl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ἐγὼ δὲ ⸀κατελαβόμηνμηδὲν ἄξιον ⸂αὐτὸν θανάτου πεπραχέναι, ⸀αὐτοῦδὲ τούτου ἐπικαλεσαμένου τὸν Σεβαστὸν ἔκρινα ⸀πέμπειν ");
INSERT INTO grcsbl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","περὶ οὗ ἀσφαλές τι γράψαι τῷ κυρίῳ οὐκ ἔχω· διὸ προήγαγον αὐτὸν ἐφʼ ὑμῶν καὶ μάλιστα ἐπὶ σοῦ, βασιλεῦ Ἀγρίππα, ὅπως τῆς ἀνακρίσεως γενομένης σχῶ τί ⸀γράψω ");
INSERT INTO grcsbl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ἄλογον γάρ μοι δοκεῖ πέμποντα δέσμιον μὴ καὶ τὰς κατʼ αὐτοῦ αἰτίας σημᾶναι. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ἀγρίππας δὲ πρὸς τὸν Παῦλον ἔφη· Ἐπιτρέπεταί σοι ⸀ὑπὲρσεαυτοῦ λέγειν. τότε ὁ Παῦλος ⸂ἐκτείνας τὴν χεῖρα ἀπελογεῖτο· ");
INSERT INTO grcsbl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Περὶ πάντων ὧν ἐγκαλοῦμαι ὑπὸ Ἰουδαίων, βασιλεῦ Ἀγρίππα, ἥγημαι ἐμαυτὸν μακάριον ἐπὶ σοῦ μέλλων ⸂σήμερον ἀπολογεῖσθαι, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","μάλιστα γνώστην ὄντα σε πάντων τῶν κατὰ Ἰουδαίους ⸀ἐθῶντε καὶ ζητημάτων· διὸ ⸀δέομαιμακροθύμως ἀκοῦσαί μου. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Τὴν μὲν οὖν βίωσίν μου ⸀τὴνἐκ νεότητος τὴν ἀπʼ ἀρχῆς γενομένην ἐν τῷ ἔθνει μου ἔν ⸀τεἹεροσολύμοις ἴσασι ⸀πάντεςἸουδαῖοι, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","προγινώσκοντές με ἄνωθεν, ἐὰν θέλωσι μαρτυρεῖν, ὅτι κατὰ τὴν ἀκριβεστάτην αἵρεσιν τῆς ἡμετέρας θρησκείας ἔζησα Φαρισαῖος. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","καὶ νῦν ἐπʼ ἐλπίδι τῆς ⸀εἰςτοὺς πατέρας ⸀ἡμῶνἐπαγγελίας γενομένης ὑπὸ τοῦ θεοῦ ἕστηκα κρινόμενος, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","εἰς ἣν τὸ δωδεκάφυλον ἡμῶν ἐν ἐκτενείᾳ νύκτα καὶ ἡμέραν λατρεῦον ἐλπίζει καταντῆσαι· περὶ ἧς ἐλπίδος ἐγκαλοῦμαι ⸂ὑπὸ Ἰουδαίων, βασιλεῦ⸃· ");
INSERT INTO grcsbl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","τί ἄπιστον κρίνεται παρʼ ὑμῖν εἰ ὁ θεὸς νεκροὺς ἐγείρει; ");
INSERT INTO grcsbl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ἐγὼ μὲν οὖν ἔδοξα ἐμαυτῷ πρὸς τὸ ὄνομα Ἰησοῦ τοῦ Ναζωραίου δεῖν πολλὰ ἐναντία πρᾶξαι· ");
INSERT INTO grcsbl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ὃ καὶ ἐποίησα ἐν Ἱεροσολύμοις, καὶ πολλούς ⸀τετῶν ἁγίων ἐγὼ ⸀ἐνφυλακαῖς κατέκλεισα τὴν παρὰ τῶν ἀρχιερέων ἐξουσίαν λαβών, ἀναιρουμένων τε αὐτῶν κατήνεγκα ψῆφον, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","καὶ κατὰ πάσας τὰς συναγωγὰς πολλάκις τιμωρῶν αὐτοὺς ἠνάγκαζον βλασφημεῖν, περισσῶς τε ἐμμαινόμενος αὐτοῖς ἐδίωκον ἕως καὶ εἰς τὰς ἔξω πόλεις. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ἐν ⸀οἷςπορευόμενος εἰς τὴν Δαμασκὸν μετʼ ἐξουσίας καὶ ἐπιτροπῆς ⸀τῆςτῶν ἀρχιερέων ");
INSERT INTO grcsbl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ἡμέρας μέσης κατὰ τὴν ὁδὸν εἶδον, βασιλεῦ, οὐρανόθεν ὑπὲρ τὴν λαμπρότητα τοῦ ἡλίου περιλάμψαν με φῶς καὶ τοὺς σὺν ἐμοὶ πορευομένους· ");
INSERT INTO grcsbl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","πάντων ⸀τεκαταπεσόντων ἡμῶν εἰς τὴν γῆν ἤκουσα φωνὴν ⸀λέγουσανπρός ⸀μετῇ Ἑβραΐδι διαλέκτῳ· Σαοὺλ Σαούλ, τί με διώκεις; σκληρόν σοι πρὸς κέντρα λακτίζειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ἐγὼ δὲ εἶπα· Τίς εἶ, κύριε; ὁ δὲ ⸀κύριοςεἶπεν· Ἐγώ εἰμι Ἰησοῦς ὃν σὺ διώκεις· ");
INSERT INTO grcsbl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ἀλλὰ ἀνάστηθι καὶ στῆθι ἐπὶ τοὺς πόδας σου· εἰς τοῦτο γὰρ ὤφθην σοι, προχειρίσασθαί σε ὑπηρέτην καὶ μάρτυρα ὧν τε εἶδές ⸀μεὧν τε ὀφθήσομαί σοι, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ἐξαιρούμενός σε ἐκτοῦ λαοῦ καὶ ⸀ἐκ τῶν ἐθνῶν, εἰς οὓς ἐγὼ ⸂ἀποστέλλω σε ");
INSERT INTO grcsbl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ἀνοῖξαι ὀφθαλμοὺς αὐτῶν, τοῦ ⸀ἐπιστρέψαιἀπὸ σκότους εἰς φῶς καὶ τῆς ἐξουσίας τοῦ Σατανᾶ ἐπὶ τὸν θεόν, τοῦ λαβεῖν αὐτοὺς ἄφεσιν ἁμαρτιῶν καὶ κλῆρον ἐν τοῖς ἡγιασμένοις πίστει τῇ εἰς ἐμέ. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ὅθεν, βασιλεῦ Ἀγρίππα, οὐκ ἐγενόμην ἀπειθὴς τῇ οὐρανίῳ ὀπτασίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ἀλλὰ τοῖς ἐν Δαμασκῷ πρῶτόν ⸀τεκαὶ Ἱεροσολύμοις, ⸀πᾶσάντε τὴν χώραν τῆς Ἰουδαίας, καὶ τοῖς ἔθνεσιν ⸀ἀπήγγελλονμετανοεῖν καὶ ἐπιστρέφειν ἐπὶ τὸν θεόν, ἄξια τῆς μετανοίας ἔργα πράσσοντας. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ἕνεκα τούτων ⸂με Ἰουδαῖοι ⸀συλλαβόμενοιἐν τῷ ἱερῷ ἐπειρῶντο διαχειρίσασθαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ἐπικουρίας οὖν τυχὼν τῆς ⸀ἀπὸτοῦ θεοῦ ἄχρι τῆς ἡμέρας ταύτης ἕστηκα μαρτυρόμενος μικρῷ τε καὶ μεγάλῳ, οὐδὲν ἐκτὸς λέγων ὧν τε οἱ προφῆται ἐλάλησαν μελλόντων γίνεσθαι καὶ Μωϋσῆς, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","εἰ παθητὸς ὁ χριστός, εἰ πρῶτος ἐξ ἀναστάσεως νεκρῶν φῶς μέλλει καταγγέλλειν τῷ ⸀τελαῷ καὶ τοῖς ἔθνεσιν. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ταῦτα δὲ αὐτοῦ ἀπολογουμένου ὁ Φῆστος μεγάλῃ τῇ φωνῇ ⸀φησιν Μαίνῃ, Παῦλε· τὰ πολλά σε γράμματα εἰς μανίαν περιτρέπει. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ὁ δὲ ⸀Παῦλος Οὐ μαίνομαι, φησίν, κράτιστε Φῆστε, ἀλλὰ ἀληθείας καὶ σωφροσύνης ῥήματα ἀποφθέγγομαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ἐπίσταται γὰρ περὶ τούτων ὁ βασιλεύς, πρὸς ὃν ⸀καὶπαρρησιαζόμενος λαλῶ· λανθάνειν γὰρ ⸀αὐτὸντούτων οὐ πείθομαι ⸀οὐθέν οὐ γάρ ⸀ἐστινἐν γωνίᾳ πεπραγμένον τοῦτο. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","πιστεύεις, βασιλεῦ Ἀγρίππα, τοῖς προφήταις; οἶδα ὅτι πιστεύεις. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ὁ δὲ Ἀγρίππας πρὸς τὸν ⸀Παῦλον Ἐν ὀλίγῳ με πείθεις Χριστιανὸν ⸀ποιῆσαι ");
INSERT INTO grcsbl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ὁ δὲ ⸀Παῦλος Εὐξαίμην ἂν τῷ θεῷ καὶ ἐν ὀλίγῳ καὶ ἐν ⸀μεγάλῳοὐ μόνον σὲ ἀλλὰ καὶ πάντας τοὺς ἀκούοντάς μου σήμερον γενέσθαι τοιούτους ὁποῖος καὶ ἐγώ εἰμι παρεκτὸς τῶν δεσμῶν τούτων. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","⸀Ἀνέστη⸀τεὁ βασιλεὺς καὶ ὁ ἡγεμὼν ἥ τε Βερνίκη καὶ οἱ συγκαθήμενοι αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","καὶ ἀναχωρήσαντες ἐλάλουν πρὸς ἀλλήλους λέγοντες ὅτι Οὐδὲν θανάτου ⸂ἢ δεσμῶν ἄξιον ⸀τιπράσσει ὁ ἄνθρωπος οὗτος. ");
INSERT INTO grcsbl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ἀγρίππας δὲ τῷ Φήστῳ ἔφη· Ἀπολελύσθαι ἐδύνατο ὁ ἄνθρωπος οὗτος εἰ μὴ ἐπεκέκλητο Καίσαρα. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ὡς δὲ ἐκρίθη τοῦ ἀποπλεῖν ἡμᾶς εἰς τὴν Ἰταλίαν, παρεδίδουν τόν τε Παῦλον καί τινας ἑτέρους δεσμώτας ἑκατοντάρχῃ ὀνόματι Ἰουλίῳ σπείρης Σεβαστῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ἐπιβάντες δὲ πλοίῳ Ἀδραμυττηνῷ ⸀μέλλοντιπλεῖν ⸀εἰςτοὺς κατὰ τὴν Ἀσίαν τόπους ἀνήχθημεν ὄντος σὺν ἡμῖν Ἀριστάρχου Μακεδόνος Θεσσαλονικέως· ");
INSERT INTO grcsbl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","τῇ τε ἑτέρᾳ κατήχθημεν εἰς Σιδῶνα, φιλανθρώπως τε ὁ Ἰούλιος τῷ Παύλῳ χρησάμενος ἐπέτρεψεν πρὸς τοὺς φίλους ⸀πορευθέντιἐπιμελείας τυχεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","κἀκεῖθεν ἀναχθέντες ὑπεπλεύσαμεν τὴν Κύπρον διὰ τὸ τοὺς ἀνέμους εἶναι ἐναντίους, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","τό τε πέλαγος τὸ κατὰ τὴν Κιλικίαν καὶ Παμφυλίαν διαπλεύσαντες κατήλθομεν εἰς Μύρα τῆς Λυκίας. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","κἀκεῖ εὑρὼν ὁ ⸀ἑκατοντάρχηςπλοῖον Ἀλεξανδρῖνον πλέον εἰς τὴν Ἰταλίαν ἐνεβίβασεν ἡμᾶς εἰς αὐτό. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ἐν ἱκαναῖς δὲ ἡμέραις βραδυπλοοῦντες καὶ μόλις γενόμενοι κατὰ τὴν Κνίδον, μὴ προσεῶντος ἡμᾶς τοῦ ἀνέμου, ὑπεπλεύσαμεν τὴν Κρήτην κατὰ Σαλμώνην, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","μόλις τε παραλεγόμενοι αὐτὴν ἤλθομεν εἰς τόπον τινὰ καλούμενον Καλοὺς Λιμένας ᾧ ἐγγὺς ⸂ἦν πόλις ⸀Λασαία ");
INSERT INTO grcsbl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ἱκανοῦ δὲ χρόνου διαγενομένου καὶ ὄντος ἤδη ἐπισφαλοῦς τοῦ πλοὸς διὰ τὸ καὶ τὴν νηστείαν ἤδη παρεληλυθέναι, παρῄνει ὁ Παῦλος ");
INSERT INTO grcsbl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","λέγων αὐτοῖς· Ἄνδρες, θεωρῶ ὅτι μετὰ ὕβρεως καὶ πολλῆς ζημίας οὐ μόνον τοῦ φορτίου καὶ τοῦ πλοίου ἀλλὰ καὶ τῶν ψυχῶν ἡμῶν μέλλειν ἔσεσθαι τὸν πλοῦν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ὁ δὲ ἑκατοντάρχης τῷ κυβερνήτῃ καὶ τῷ ναυκλήρῳ ⸂μᾶλλον ἐπείθετο ἢ τοῖς ⸀ὑπὸΠαύλου λεγομένοις. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ἀνευθέτου δὲ τοῦ λιμένος ὑπάρχοντος πρὸς παραχειμασίαν οἱ πλείονες ἔθεντο βουλὴν ἀναχθῆναι ⸀ἐκεῖθεν εἴ πως δύναιντο καταντήσαντες εἰς Φοίνικα παραχειμάσαι, λιμένα τῆς Κρήτης βλέποντα κατὰ λίβα καὶ κατὰ χῶρον. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ὑποπνεύσαντος δὲ νότου δόξαντες τῆς προθέσεως κεκρατηκέναι ἄραντες ἆσσον παρελέγοντο τὴν Κρήτην. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","μετʼ οὐ πολὺ δὲ ἔβαλεν κατʼ αὐτῆς ἄνεμος τυφωνικὸς ὁ καλούμενος ⸀Εὐρακύλων ");
INSERT INTO grcsbl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","συναρπασθέντος δὲ τοῦ πλοίου καὶ μὴ δυναμένου ἀντοφθαλμεῖν τῷ ἀνέμῳ ἐπιδόντες ἐφερόμεθα. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","νησίον δέ τι ὑποδραμόντες καλούμενον ⸀Καῦδα⸂ἰσχύσαμεν μόλις περικρατεῖς γενέσθαι τῆς σκάφης, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ἣν ἄραντες βοηθείαις ἐχρῶντο ὑποζωννύντες τὸ πλοῖον· φοβούμενοί τε μὴ εἰς τὴν Σύρτιν ἐκπέσωσιν, χαλάσαντες τὸ σκεῦος, οὕτως ἐφέροντο. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","σφοδρῶς δὲ χειμαζομένων ἡμῶν τῇ ἑξῆς ἐκβολὴν ἐποιοῦντο, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","καὶ τῇ τρίτῃ αὐτόχειρες τὴν σκευὴν τοῦ πλοίου ⸀ἔρριψαν ");
INSERT INTO grcsbl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","μήτε δὲ ἡλίου μήτε ἄστρων ἐπιφαινόντων ἐπὶ πλείονας ἡμέρας, χειμῶνός τε οὐκ ὀλίγου ἐπικειμένου, λοιπὸν περιῃρεῖτο ⸂ἐλπὶς πᾶσα τοῦ σῴζεσθαι ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Πολλῆς ⸀τεἀσιτίας ὑπαρχούσης τότε σταθεὶς ὁ Παῦλος ἐν μέσῳ αὐτῶν εἶπεν· Ἔδει μέν, ὦ ἄνδρες, πειθαρχήσαντάς μοι μὴ ἀνάγεσθαι ἀπὸ τῆς Κρήτης κερδῆσαί τε τὴν ὕβριν ταύτην καὶ τὴν ζημίαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","καὶ τὰ νῦν παραινῶ ὑμᾶς εὐθυμεῖν, ἀποβολὴ γὰρ ψυχῆς οὐδεμία ἔσται ἐξ ὑμῶν πλὴν τοῦ πλοίου· ");
INSERT INTO grcsbl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","παρέστη γάρ μοι ταύτῃ τῇ ⸀νυκτὶτοῦ θεοῦ, οὗ ⸀εἰμι ᾧ καὶ λατρεύω, ⸀ἄγγελος ");
INSERT INTO grcsbl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","λέγων· Μὴ φοβοῦ, Παῦλε· Καίσαρί σε δεῖ παραστῆναι, καὶ ἰδοὺ κεχάρισταί σοι ὁ θεὸς πάντας τοὺς πλέοντας μετὰ σοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","διὸ εὐθυμεῖτε, ἄνδρες· πιστεύω γὰρ τῷ θεῷ ὅτι οὕτως ἔσται καθʼ ὃν τρόπον λελάληταί μοι. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","εἰς νῆσον δέ τινα δεῖ ἡμᾶς ἐκπεσεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ὡς δὲ τεσσαρεσκαιδεκάτη νὺξ ἐγένετο διαφερομένων ἡμῶν ἐν τῷ Ἀδρίᾳ, κατὰ μέσον τῆς νυκτὸς ὑπενόουν οἱ ναῦται προσάγειν τινὰ αὐτοῖς χώραν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","καὶ βολίσαντες εὗρον ὀργυιὰς εἴκοσι, βραχὺ δὲ διαστήσαντες καὶ πάλιν βολίσαντες εὗρον ὀργυιὰς δεκαπέντε· ");
INSERT INTO grcsbl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","φοβούμενοί τε ⸂μή που κατὰ τραχεῖς τόπους ἐκπέσωμεν ἐκ πρύμνης ῥίψαντες ἀγκύρας τέσσαρας ηὔχοντο ἡμέραν γενέσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","τῶν δὲ ναυτῶν ζητούντων φυγεῖν ἐκ τοῦ πλοίου καὶ χαλασάντων τὴν σκάφην εἰς τὴν θάλασσαν προφάσει ὡς ἐκ πρῴρης ⸂ἀγκύρας μελλόντων ἐκτείνειν, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","εἶπεν ὁ Παῦλος τῷ ἑκατοντάρχῃ καὶ τοῖς στρατιώταις· Ἐὰν μὴ οὗτοι μείνωσιν ἐν τῷ πλοίῳ, ὑμεῖς σωθῆναι οὐ δύνασθε. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","τότε ⸂ἀπέκοψαν οἱ στρατιῶται τὰ σχοινία τῆς σκάφης καὶ εἴασαν αὐτὴν ἐκπεσεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ἄχρι δὲ οὗ ⸂ἡμέρα ἤμελλεν γίνεσθαι παρεκάλει ὁ Παῦλος ἅπαντας μεταλαβεῖν τροφῆς λέγων· Τεσσαρεσκαιδεκάτην σήμερον ἡμέραν προσδοκῶντες ἄσιτοι διατελεῖτε, μηθὲν προσλαβόμενοι· ");
INSERT INTO grcsbl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","διὸ παρακαλῶ ὑμᾶς ⸀μεταλαβεῖντροφῆς, τοῦτο γὰρ πρὸς τῆς ὑμετέρας σωτηρίας ὑπάρχει· οὐδενὸς γὰρ ὑμῶν θρὶξ ⸀ἀπὸτῆς κεφαλῆς ⸀ἀπολεῖται ");
INSERT INTO grcsbl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","⸀εἴπαςδὲ ταῦτα καὶ λαβὼν ἄρτον εὐχαρίστησεν τῷ θεῷ ἐνώπιον πάντων καὶ κλάσας ἤρξατο ἐσθίειν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","εὔθυμοι δὲ γενόμενοι πάντες καὶ αὐτοὶ προσελάβοντο τροφῆς. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","μεθα δὲ ⸂αἱ πᾶσαι ψυχαὶ ἐν τῷ πλοίῳ⸃ ⸀διακόσιαιἑβδομήκοντα ἕξ. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","κορεσθέντες ⸀δὲτροφῆς ἐκούφιζον τὸ πλοῖον ἐκβαλλόμενοι τὸν σῖτον εἰς τὴν θάλασσαν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ὅτε δὲ ἡμέρα ἐγένετο, τὴν γῆν οὐκ ἐπεγίνωσκον, κόλπον δέ τινα κατενόουν ἔχοντα αἰγιαλὸν εἰς ὃν ⸀ἐβουλεύοντοεἰ ⸀δύναιντο⸀ἐξῶσαιτὸ πλοῖον. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","καὶ τὰς ἀγκύρας περιελόντες εἴων εἰς τὴν θάλασσαν, ἅμα ἀνέντες τὰς ζευκτηρίας τῶν πηδαλίων, καὶ ἐπάραντες τὸν ἀρτέμωνα τῇ πνεούσῃ κατεῖχον εἰς τὸν αἰγιαλόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","περιπεσόντες δὲ εἰς τόπον διθάλασσον ⸀ἐπέκειλαντὴν ναῦν, καὶ ἡ μὲν πρῷρα ἐρείσασα ἔμεινεν ἀσάλευτος, ἡ δὲ πρύμνα ἐλύετο ὑπὸ τῆς ⸀βίας ");
INSERT INTO grcsbl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","τῶν δὲ στρατιωτῶν βουλὴ ἐγένετο ἵνα τοὺς δεσμώτας ἀποκτείνωσιν, μή τις ἐκκολυμβήσας διαφύγῃ· ");
INSERT INTO grcsbl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ὁ δὲ ⸀ἑκατοντάρχηςβουλόμενος διασῶσαι τὸν Παῦλον ἐκώλυσεν αὐτοὺς τοῦ βουλήματος, ἐκέλευσέν τε τοὺς δυναμένους κολυμβᾶν ἀπορίψαντας πρώτους ἐπὶ τὴν γῆν ἐξιέναι, ");
INSERT INTO grcsbl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","καὶ τοὺς λοιποὺς οὓς μὲν ἐπὶ σανίσιν οὓς δὲ ἐπί τινων τῶν ἀπὸ τοῦ πλοίου· καὶ οὕτως ἐγένετο πάντας διασωθῆναι ἐπὶ τὴν γῆν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Καὶ διασωθέντες τότε ⸀ἐπέγνωμενὅτι ⸀Μελίτηἡ νῆσος καλεῖται. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","οἵ ⸀τεβάρβαροι παρεῖχον οὐ τὴν τυχοῦσαν φιλανθρωπίαν ἡμῖν, ⸀ἅψαντεςγὰρ πυρὰν προσελάβοντο πάντας ἡμᾶς διὰ τὸν ὑετὸν τὸν ἐφεστῶτα καὶ διὰ τὸ ψῦχος. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","συστρέψαντος δὲ τοῦ Παύλου φρυγάνων ⸀τιπλῆθος καὶ ἐπιθέντος ἐπὶ τὴν πυράν, ἔχιδνα ⸀ἀπὸτῆς θέρμης ⸀ἐξελθοῦσακαθῆψε τῆς χειρὸς αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ὡς δὲ εἶδον οἱ βάρβαροι κρεμάμενον τὸ θηρίον ἐκ τῆς χειρὸς αὐτοῦ, ⸂πρὸς ἀλλήλους ἔλεγον· Πάντως φονεύς ἐστιν ὁ ἄνθρωπος οὗτος ὃν διασωθέντα ἐκ τῆς θαλάσσης ἡ δίκη ζῆν οὐκ εἴασεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ὁ μὲν οὖν ἀποτινάξας τὸ θηρίον εἰς τὸ πῦρ ἔπαθεν οὐδὲν κακόν· ");
INSERT INTO grcsbl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","οἱ δὲ προσεδόκων αὐτὸν μέλλειν πίμπρασθαι ἢ καταπίπτειν ἄφνω νεκρόν. ἐπὶ πολὺ δὲ αὐτῶν προσδοκώντων καὶ θεωρούντων μηδὲν ἄτοπον εἰς αὐτὸν γινόμενον, ⸀μεταβαλόμενοιἔλεγον ⸂αὐτὸν εἶναι θεόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ἐν δὲ τοῖς περὶ τὸν τόπον ἐκεῖνον ὑπῆρχεν χωρία τῷ πρώτῳ τῆς νήσου ὀνόματι Ποπλίῳ, ὃς ἀναδεξάμενος ἡμᾶς ⸂τρεῖς ἡμέρας φιλοφρόνως ἐξένισεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ἐγένετο δὲ τὸν πατέρα τοῦ Ποπλίου πυρετοῖς καὶ ⸀δυσεντερίῳσυνεχόμενον κατακεῖσθαι, πρὸς ὃν ὁ Παῦλος εἰσελθὼν καὶ προσευξάμενος ἐπιθεὶς τὰς χεῖρας αὐτῷ ἰάσατο αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","τούτου ⸀δὲγενομένου καὶ οἱ λοιποὶ οἱ ⸂ἐν τῇ νήσῳ ἔχοντες ἀσθενείας προσήρχοντο καὶ ἐθεραπεύοντο, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","οἳ καὶ πολλαῖς τιμαῖς ἐτίμησαν ἡμᾶς καὶ ἀναγομένοις ἐπέθεντο τὰ πρὸς ⸂τὰς χρείας. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Μετὰ δὲ τρεῖς μῆνας ⸀ἀνήχθημενἐν πλοίῳ παρακεχειμακότι ἐν τῇ νήσῳ Ἀλεξανδρίνῳ, παρασήμῳ Διοσκούροις. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","καὶ καταχθέντες εἰς Συρακούσας ἐπεμείναμεν ἡμέρας τρεῖς, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ὅθεν ⸀περιελόντεςκατηντήσαμεν εἰς Ῥήγιον. καὶ μετὰ μίαν ἡμέραν ἐπιγενομένου νότου δευτεραῖοι ἤλθομεν εἰς Ποτιόλους, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","οὗ εὑρόντες ἀδελφοὺς παρεκλήθημεν ⸀παρʼαὐτοῖς ἐπιμεῖναι ἡμέρας ἑπτά· καὶ οὕτως εἰς τὴν Ῥώμην ἤλθαμεν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","κἀκεῖθεν οἱ ἀδελφοὶ ἀκούσαντες τὰ περὶ ἡμῶν ⸀ἦλθανεἰς ἀπάντησιν ἡμῖν ἄχρι Ἀππίου Φόρου καὶ Τριῶν Ταβερνῶν, οὓς ἰδὼν ὁ Παῦλος εὐχαριστήσας τῷ θεῷ ἔλαβε θάρσος. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ὅτε δὲ ⸀εἰσήλθομενεἰς Ῥώμην, ⸂ἐπετράπη τῷ Παύλῳ μένειν καθʼ ἑαυτὸν σὺν τῷ φυλάσσοντι αὐτὸν στρατιώτῃ. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ἐγένετο δὲ μετὰ ἡμέρας τρεῖς συγκαλέσασθαι ⸀αὐτὸντοὺς ὄντας τῶν Ἰουδαίων πρώτους· συνελθόντων δὲ αὐτῶν ἔλεγεν πρὸς αὐτούς· ⸂Ἐγώ, ἄνδρες ἀδελφοί⸃, οὐδὲν ἐναντίον ποιήσας τῷ λαῷ ἢ τοῖς ἔθεσι τοῖς πατρῴοις δέσμιος ἐξ Ἱεροσολύμων παρεδόθην εἰς τὰς χεῖρας τῶν Ῥωμαίων, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","οἵτινες ἀνακρίναντές με ἐβούλοντο ἀπολῦσαι διὰ τὸ μηδεμίαν αἰτίαν θανάτου ὑπάρχειν ἐν ἐμοί· ");
INSERT INTO grcsbl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ἀντιλεγόντων δὲ τῶν Ἰουδαίων ἠναγκάσθην ἐπικαλέσασθαι Καίσαρα, οὐχ ὡς τοῦ ἔθνους μου ἔχων τι ⸀κατηγορεῖν ");
INSERT INTO grcsbl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","διὰ ταύτην οὖν τὴν αἰτίαν παρεκάλεσα ὑμᾶς ἰδεῖν καὶ προσλαλῆσαι, ἕνεκεν γὰρ τῆς ἐλπίδος τοῦ Ἰσραὴλ τὴν ἅλυσιν ταύτην περίκειμαι. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","οἱ δὲ πρὸς αὐτὸν εἶπαν· Ἡμεῖς οὔτε γράμματα περὶ σοῦ ἐδεξάμεθα ἀπὸ τῆς Ἰουδαίας, οὔτε παραγενόμενός τις τῶν ἀδελφῶν ἀπήγγειλεν ἢ ἐλάλησέν τι περὶ σοῦ πονηρόν. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ἀξιοῦμεν δὲ παρὰ σοῦ ἀκοῦσαι ἃ φρονεῖς, περὶ μὲν γὰρ τῆς αἱρέσεως ταύτης γνωστὸν ⸂ἡμῖν ἐστιν ὅτι πανταχοῦ ἀντιλέγεται. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ταξάμενοι δὲ αὐτῷ ἡμέραν ⸀ἧκονπρὸς αὐτὸν εἰς τὴν ξενίαν πλείονες, οἷς ἐξετίθετο διαμαρτυρόμενος τὴν βασιλείαν τοῦ θεοῦ πείθων τε ⸀αὐτοὺςπερὶ τοῦ Ἰησοῦ ἀπό τε τοῦ νόμου Μωϋσέως καὶ τῶν προφητῶν ἀπὸ πρωῒ ἕως ἑσπέρας. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","καὶ οἱ μὲν ἐπείθοντο τοῖς λεγομένοις οἱ δὲ ἠπίστουν, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ἀσύμφωνοι δὲ ὄντες πρὸς ἀλλήλους ἀπελύοντο, εἰπόντος τοῦ Παύλου ῥῆμα ἓν ὅτι Καλῶς τὸ πνεῦμα τὸ ἅγιον ἐλάλησεν διὰ Ἠσαΐου τοῦ προφήτου πρὸς τοὺς πατέρας ⸀ὑμῶν ");
INSERT INTO grcsbl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","⸀λέγων Πορεύθητι πρὸς τὸν λαὸν τοῦτον καὶ εἰπόν· Ἀκοῇ ἀκούσετε καὶ οὐ μὴ συνῆτε, καὶ βλέποντες βλέψετε καὶ οὐ μὴ ἴδητε· ");
INSERT INTO grcsbl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ἐπαχύνθη γὰρ ἡ καρδία τοῦ λαοῦ τούτου, καὶ τοῖς ὠσὶν βαρέως ἤκουσαν, καὶ τοὺς ὀφθαλμοὺς αὐτῶν ἐκάμμυσαν· μήποτε ἴδωσιν τοῖς ὀφθαλμοῖς καὶ τοῖς ὠσὶν ἀκούσωσιν καὶ τῇ καρδίᾳ συνῶσιν καὶ ἐπιστρέψωσιν, καὶ ἰάσομαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","γνωστὸν οὖν ⸂ἔστω ὑμῖν ὅτι τοῖς ἔθνεσιν ἀπεστάλη ⸀τοῦτοτὸ σωτήριον τοῦ θεοῦ· αὐτοὶ καὶ ⸀ἀκούσονται ");
INSERT INTO grcsbl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","⸀Ἐνέμεινεν⸀δὲδιετίαν ὅλην ἐν ἰδίῳ μισθώματι, καὶ ἀπεδέχετο πάντας τοὺς εἰσπορευομένους πρὸς αὐτόν, ");
INSERT INTO grcsbl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","κηρύσσων τὴν βασιλείαν τοῦ θεοῦ καὶ διδάσκων τὰ περὶ τοῦ κυρίου Ἰησοῦ Χριστοῦ μετὰ πάσης παρρησίας ἀκωλύτως. ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Παῦλος δοῦλος ⸂Χριστοῦ Ἰησοῦ, κλητὸς ἀπόστολος, ἀφωρισμένος εἰς εὐαγγέλιον θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ὃ προεπηγγείλατο διὰ τῶν προφητῶν αὐτοῦ ἐν γραφαῖς ἁγίαις ");
INSERT INTO grcsbl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","περὶ τοῦ υἱοῦ αὐτοῦ, τοῦ γενομένου ἐκ σπέρματος Δαυὶδ κατὰ σάρκα, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","τοῦ ὁρισθέντος υἱοῦ θεοῦ ἐν δυνάμει κατὰ πνεῦμα ἁγιωσύνης ἐξ ἀναστάσεως νεκρῶν, Ἰησοῦ Χριστοῦ τοῦ κυρίου ἡμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","διʼ οὗ ἐλάβομεν χάριν καὶ ἀποστολὴν εἰς ὑπακοὴν πίστεως ἐν πᾶσιν τοῖς ἔθνεσιν ὑπὲρ τοῦ ὀνόματος αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ἐν οἷς ἐστε καὶ ὑμεῖς κλητοὶ Ἰησοῦ Χριστοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","πᾶσιν τοῖς οὖσιν ἐν Ῥώμῃ ἀγαπητοῖς θεοῦ, κλητοῖς ἁγίοις· χάρις ὑμῖν καὶ εἰρήνη ἀπὸ θεοῦ πατρὸς ἡμῶν καὶ κυρίου Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Πρῶτον μὲν εὐχαριστῶ τῷ θεῷ μου διὰ Ἰησοῦ Χριστοῦ ⸀περὶπάντων ὑμῶν, ὅτι ἡ πίστις ὑμῶν καταγγέλλεται ἐν ὅλῳ τῷ κόσμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","μάρτυς γάρ μού ἐστιν ὁ θεός, ᾧ λατρεύω ἐν τῷ πνεύματί μου ἐν τῷ εὐαγγελίῳ τοῦ υἱοῦ αὐτοῦ, ὡς ἀδιαλείπτως μνείαν ὑμῶν ποιοῦμαι ");
INSERT INTO grcsbl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","πάντοτε ἐπὶ τῶν προσευχῶν μου, δεόμενος εἴ πως ἤδη ποτὲ εὐοδωθήσομαι ἐν τῷ θελήματι τοῦ θεοῦ ἐλθεῖν πρὸς ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ἐπιποθῶ γὰρ ἰδεῖν ὑμᾶς, ἵνα τι μεταδῶ χάρισμα ὑμῖν πνευματικὸν εἰς τὸ στηριχθῆναι ὑμᾶς, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","τοῦτο δέ ἐστιν συμπαρακληθῆναι ἐν ὑμῖν διὰ τῆς ἐν ἀλλήλοις πίστεως ὑμῶν τε καὶ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","οὐ θέλω δὲ ὑμᾶς ἀγνοεῖν, ἀδελφοί, ὅτι πολλάκις προεθέμην ἐλθεῖν πρὸς ὑμᾶς, καὶ ἐκωλύθην ἄχρι τοῦ δεῦρο, ἵνα τινὰ καρπὸν σχῶ καὶ ἐν ὑμῖν καθὼς καὶ ἐν τοῖς λοιποῖς ἔθνεσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ἕλλησίν τε καὶ βαρβάροις, σοφοῖς τε καὶ ἀνοήτοις ὀφειλέτης εἰμί· ");
INSERT INTO grcsbl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","οὕτως τὸ κατʼ ἐμὲ πρόθυμον καὶ ὑμῖν τοῖς ἐν Ῥώμῃ εὐαγγελίσασθαι. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Οὐ γὰρ ἐπαισχύνομαι τὸ ⸀εὐαγγέλιον δύναμις γὰρ θεοῦ ἐστιν εἰς σωτηρίαν παντὶ τῷ πιστεύοντι, Ἰουδαίῳ τε πρῶτον καὶ Ἕλληνι· ");
INSERT INTO grcsbl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","δικαιοσύνη γὰρ θεοῦ ἐν αὐτῷ ἀποκαλύπτεται ἐκ πίστεως εἰς πίστιν, καθὼς γέγραπται· Ὁ δὲ δίκαιος ἐκ πίστεως ζήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ἀποκαλύπτεται γὰρ ὀργὴ θεοῦ ἀπʼ οὐρανοῦ ἐπὶ πᾶσαν ἀσέβειαν καὶ ἀδικίαν ἀνθρώπων τῶν τὴν ἀλήθειαν ἐν ἀδικίᾳ κατεχόντων, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","διότι τὸ γνωστὸν τοῦ θεοῦ φανερόν ἐστιν ἐν αὐτοῖς, ὁ ⸂θεὸς γὰρ αὐτοῖς ἐφανέρωσεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","τὰ γὰρ ἀόρατα αὐτοῦ ἀπὸ κτίσεως κόσμου τοῖς ποιήμασιν νοούμενα καθορᾶται, ἥ τε ἀΐδιος αὐτοῦ δύναμις καὶ θειότης, εἰς τὸ εἶναι αὐτοὺς ἀναπολογήτους, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","διότι γνόντες τὸν θεὸν οὐχ ὡς θεὸν ἐδόξασαν ἢ ηὐχαρίστησαν, ἀλλὰ ἐματαιώθησαν ἐν τοῖς διαλογισμοῖς αὐτῶν καὶ ἐσκοτίσθη ἡ ἀσύνετος αὐτῶν καρδία· ");
INSERT INTO grcsbl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","φάσκοντες εἶναι σοφοὶ ἐμωράνθησαν, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","καὶ ἤλλαξαν τὴν δόξαν τοῦ ἀφθάρτου θεοῦ ἐν ὁμοιώματι εἰκόνος φθαρτοῦ ἀνθρώπου καὶ πετεινῶν καὶ τετραπόδων καὶ ἑρπετῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","⸀Διὸπαρέδωκεν αὐτοὺς ὁ θεὸς ἐν ταῖς ἐπιθυμίαις τῶν καρδιῶν αὐτῶν εἰς ἀκαθαρσίαν τοῦ ἀτιμάζεσθαι τὰ σώματα αὐτῶν ἐν ⸀αὐτοῖς ");
INSERT INTO grcsbl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","οἵτινες μετήλλαξαν τὴν ἀλήθειαν τοῦ θεοῦ ἐν τῷ ψεύδει, καὶ ἐσεβάσθησαν καὶ ἐλάτρευσαν τῇ κτίσει παρὰ τὸν κτίσαντα, ὅς ἐστιν εὐλογητὸς εἰς τοὺς αἰῶνας· ἀμήν. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Διὰ τοῦτο παρέδωκεν αὐτοὺς ὁ θεὸς εἰς πάθη ἀτιμίας· αἵ τε γὰρ θήλειαι αὐτῶν μετήλλαξαν τὴν φυσικὴν χρῆσιν εἰς τὴν παρὰ φύσιν, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ὁμοίως τε καὶ οἱ ἄρσενες ἀφέντες τὴν φυσικὴν χρῆσιν τῆς θηλείας ἐξεκαύθησαν ἐν τῇ ὀρέξει αὐτῶν εἰς ἀλλήλους, ἄρσενες ἐν ἄρσεσιν τὴν ἀσχημοσύνην κατεργαζόμενοι καὶ τὴν ἀντιμισθίαν ἣν ἔδει τῆς πλάνης αὐτῶν ἐν ⸀ἑαυτοῖςἀπολαμβάνοντες. ");
INSERT INTO grcsbl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Καὶ καθὼς οὐκ ἐδοκίμασαν τὸν θεὸν ἔχειν ἐν ἐπιγνώσει, παρέδωκεν αὐτοὺς ὁ θεὸς εἰς ἀδόκιμον νοῦν, ποιεῖν τὰ μὴ καθήκοντα, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","πεπληρωμένους πάσῃ ⸀ἀδικίᾳπονηρίᾳ πλεονεξίᾳ κακίᾳ, μεστοὺς φθόνου φόνου ἔριδος δόλου κακοηθείας, ψιθυριστάς, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","καταλάλους, θεοστυγεῖς, ὑβριστάς, ὑπερηφάνους, ἀλαζόνας, ἐφευρετὰς κακῶν, γονεῦσιν ἀπειθεῖς, ");
INSERT INTO grcsbl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ἀσυνέτους, ἀσυνθέτους, ⸀ἀστόργους ἀνελεήμονας· ");
INSERT INTO grcsbl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","οἵτινες τὸ δικαίωμα τοῦ θεοῦ ἐπιγνόντες, ὅτι οἱ τὰ τοιαῦτα πράσσοντες ἄξιοι θανάτου εἰσίν, οὐ μόνον αὐτὰ ποιοῦσιν ἀλλὰ καὶ συνευδοκοῦσιν τοῖς πράσσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Διὸ ἀναπολόγητος εἶ, ὦ ἄνθρωπε πᾶς ὁ κρίνων· ἐν ᾧ γὰρ κρίνεις τὸν ἕτερον, σεαυτὸν κατακρίνεις, τὰ γὰρ αὐτὰ πράσσεις ὁ κρίνων· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","οἴδαμεν δὲ ὅτι τὸ κρίμα τοῦ θεοῦ ἐστιν κατὰ ἀλήθειαν ἐπὶ τοὺς τὰ τοιαῦτα πράσσοντας. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","λογίζῃ δὲ τοῦτο, ὦ ἄνθρωπε ὁ κρίνων τοὺς τὰ τοιαῦτα πράσσοντας καὶ ποιῶν αὐτά, ὅτι σὺ ἐκφεύξῃ τὸ κρίμα τοῦ θεοῦ; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ἢ τοῦ πλούτου τῆς χρηστότητος αὐτοῦ καὶ τῆς ἀνοχῆς καὶ τῆς μακροθυμίας καταφρονεῖς, ἀγνοῶν ὅτι τὸ χρηστὸν τοῦ θεοῦ εἰς μετάνοιάν σε ἄγει; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","κατὰ δὲ τὴν σκληρότητά σου καὶ ἀμετανόητον καρδίαν θησαυρίζεις σεαυτῷ ὀργὴν ἐν ἡμέρᾳ ὀργῆς καὶ ⸀ἀποκαλύψεωςδικαιοκρισίας τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ὃς ἀποδώσει ἑκάστῳ κατὰ τὰ ἔργα αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","τοῖς μὲν καθʼ ὑπομονὴν ἔργου ἀγαθοῦ δόξαν καὶ τιμὴν καὶ ἀφθαρσίαν ζητοῦσιν ζωὴν αἰώνιον· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","τοῖς δὲ ἐξ ἐριθείας καὶ ⸀ἀπειθοῦσιτῇ ἀληθείᾳ πειθομένοις δὲ τῇ ἀδικίᾳ ⸂ὀργὴ καὶ θυμός, ");
INSERT INTO grcsbl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","θλῖψις καὶ στενοχωρία, ἐπὶ πᾶσαν ψυχὴν ἀνθρώπου τοῦ κατεργαζομένου τὸ κακόν, Ἰουδαίου τε πρῶτον καὶ Ἕλληνος· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","δόξα δὲ καὶ τιμὴ καὶ εἰρήνη παντὶ τῷ ἐργαζομένῳ τὸ ἀγαθόν, Ἰουδαίῳ τε πρῶτον καὶ Ἕλληνι· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","οὐ γάρ ἐστιν προσωπολημψία παρὰ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ὅσοι γὰρ ἀνόμως ἥμαρτον, ἀνόμως καὶ ἀπολοῦνται· καὶ ὅσοι ἐν νόμῳ ἥμαρτον, διὰ νόμου κριθήσονται· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","οὐ γὰρ οἱ ἀκροαταὶ ⸀νόμουδίκαιοι παρὰ ⸀τῷθεῷ, ἀλλʼ οἱ ποιηταὶ ⸁νόμουδικαιωθήσονται. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ὅταν γὰρ ἔθνη τὰ μὴ νόμον ἔχοντα φύσει τὰ τοῦ νόμου ⸀ποιῶσιν οὗτοι νόμον μὴ ἔχοντες ἑαυτοῖς εἰσιν νόμος· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","οἵτινες ἐνδείκνυνται τὸ ἔργον τοῦ νόμου γραπτὸν ἐν ταῖς καρδίαις αὐτῶν, συμμαρτυρούσης αὐτῶν τῆς συνειδήσεως καὶ μεταξὺ ἀλλήλων τῶν λογισμῶν κατηγορούντων ἢ καὶ ἀπολογουμένων, ");
INSERT INTO grcsbl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ἐν ⸂ἡμέρᾳ ὅτε ⸀κρίνειὁ θεὸς τὰ κρυπτὰ τῶν ἀνθρώπων κατὰ τὸ εὐαγγέλιόν μου διὰ ⸂Χριστοῦ Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","⸂Εἰ δὲ σὺ Ἰουδαῖος ἐπονομάζῃ καὶ ἐπαναπαύῃ ⸀νόμῳκαὶ καυχᾶσαι ἐν θεῷ ");
INSERT INTO grcsbl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","καὶ γινώσκεις τὸ θέλημα καὶ δοκιμάζεις τὰ διαφέροντα κατηχούμενος ἐκ τοῦ νόμου, ");
INSERT INTO grcsbl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","πέποιθάς τε σεαυτὸν ὁδηγὸν εἶναι τυφλῶν, φῶς τῶν ἐν σκότει, ");
INSERT INTO grcsbl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","παιδευτὴν ἀφρόνων, διδάσκαλον νηπίων, ἔχοντα τὴν μόρφωσιν τῆς γνώσεως καὶ τῆς ἀληθείας ἐν τῷ νόμῳ— ");
INSERT INTO grcsbl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ὁ οὖν διδάσκων ἕτερον σεαυτὸν οὐ διδάσκεις; ὁ κηρύσσων μὴ κλέπτειν κλέπτεις; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ὁ λέγων μὴ μοιχεύειν μοιχεύεις; ὁ βδελυσσόμενος τὰ εἴδωλα ἱεροσυλεῖς; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ὃς ἐν νόμῳ καυχᾶσαι, διὰ τῆς παραβάσεως τοῦ νόμου τὸν θεὸν ἀτιμάζεις; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","τὸ γὰρ ὄνομα τοῦ θεοῦ διʼ ὑμᾶς βλασφημεῖται ἐν τοῖς ἔθνεσιν, καθὼς γέγραπται. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Περιτομὴ μὲν γὰρ ὠφελεῖ ἐὰν νόμον πράσσῃς· ἐὰν δὲ παραβάτης νόμου ᾖς, ἡ περιτομή σου ἀκροβυστία γέγονεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ἐὰν οὖν ἡ ἀκροβυστία τὰ δικαιώματα τοῦ νόμου φυλάσσῃ, ⸀οὐχἡ ἀκροβυστία αὐτοῦ εἰς περιτομὴν λογισθήσεται; ");
INSERT INTO grcsbl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","καὶ κρινεῖ ἡ ἐκ φύσεως ἀκροβυστία τὸν νόμον τελοῦσα σὲ τὸν διὰ γράμματος καὶ περιτομῆς παραβάτην νόμου. ");
INSERT INTO grcsbl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","οὐ γὰρ ὁ ἐν τῷ φανερῷ Ἰουδαῖός ἐστιν, οὐδὲ ἡ ἐν τῷ φανερῷ ἐν σαρκὶ περιτομή· ");
INSERT INTO grcsbl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ἀλλʼ ὁ ἐν τῷ κρυπτῷ Ἰουδαῖος, καὶ περιτομὴ καρδίας ἐν πνεύματι οὐ γράμματι, οὗ ὁ ἔπαινος οὐκ ἐξ ἀνθρώπων ἀλλʼ ἐκ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Τί οὖν τὸ περισσὸν τοῦ Ἰουδαίου, ἢ τίς ἡ ὠφέλεια τῆς περιτομῆς; ");
INSERT INTO grcsbl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","πολὺ κατὰ πάντα τρόπον. πρῶτον μὲν ⸀γὰρὅτι ἐπιστεύθησαν τὰ λόγια τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","τί γάρ; εἰ ἠπίστησάν τινες, μὴ ἡ ἀπιστία αὐτῶν τὴν πίστιν τοῦ θεοῦ καταργήσει; ");
INSERT INTO grcsbl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","μὴ γένοιτο· γινέσθω δὲ ὁ θεὸς ἀληθής, πᾶς δὲ ἄνθρωπος ψεύστης, ⸀καθὼςγέγραπται· Ὅπως ἂν δικαιωθῇς ἐν τοῖς λόγοις σου καὶ ⸀νικήσειςἐν τῷ κρίνεσθαί σε. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","εἰ δὲ ἡ ἀδικία ἡμῶν θεοῦ δικαιοσύνην συνίστησιν, τί ἐροῦμεν; μὴ ἄδικος ὁ θεὸς ὁ ἐπιφέρων τὴν ὀργήν; κατὰ ἄνθρωπον λέγω. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","μὴ γένοιτο· ἐπεὶ πῶς κρινεῖ ὁ θεὸς τὸν κόσμον; ");
INSERT INTO grcsbl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","εἰ ⸀δὲἡ ἀλήθεια τοῦ θεοῦ ἐν τῷ ἐμῷ ψεύσματι ἐπερίσσευσεν εἰς τὴν δόξαν αὐτοῦ, τί ἔτι κἀγὼ ὡς ἁμαρτωλὸς κρίνομαι, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","καὶ μὴ καθὼς βλασφημούμεθα καὶ καθώς φασίν τινες ἡμᾶς λέγειν ὅτι Ποιήσωμεν τὰ κακὰ ἵνα ἔλθῃ τὰ ἀγαθά; ὧν τὸ κρίμα ἔνδικόν ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Τί οὖν; προεχόμεθα; οὐ πάντως, προῃτιασάμεθα γὰρ Ἰουδαίους τε καὶ Ἕλληνας πάντας ὑφʼ ἁμαρτίαν εἶναι, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","καθὼς γέγραπται ὅτι Οὐκ ἔστιν δίκαιος οὐδὲ εἷς, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","οὐκ ἔστιν ⸀ὁσυνίων, οὐκ ἔστιν ⸁ὁἐκζητῶν τὸν θεόν· ");
INSERT INTO grcsbl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","πάντες ἐξέκλιναν, ἅμα ἠχρεώθησαν· οὐκ ⸀ἔστινποιῶν χρηστότητα, οὐκ ἔστιν ἕως ἑνός. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","τάφος ἀνεῳγμένος ὁ λάρυγξ αὐτῶν, ταῖς γλώσσαις αὐτῶν ἐδολιοῦσαν, ἰὸς ἀσπίδων ὑπὸ τὰ χείλη αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ὧν τὸ στόμα ἀρᾶς καὶ πικρίας γέμει· ");
INSERT INTO grcsbl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ὀξεῖς οἱ πόδες αὐτῶν ἐκχέαι αἷμα, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","σύντριμμα καὶ ταλαιπωρία ἐν ταῖς ὁδοῖς αὐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","καὶ ὁδὸν εἰρήνης οὐκ ἔγνωσαν. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","οὐκ ἔστιν φόβος θεοῦ ἀπέναντι τῶν ὀφθαλμῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Οἴδαμεν δὲ ὅτι ὅσα ὁ νόμος λέγει τοῖς ἐν τῷ νόμῳ λαλεῖ, ἵνα πᾶν στόμα φραγῇ καὶ ὑπόδικος γένηται πᾶς ὁ κόσμος τῷ θεῷ· ");
INSERT INTO grcsbl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","διότι ἐξ ἔργων νόμου οὐ δικαιωθήσεται πᾶσα σὰρξ ἐνώπιον αὐτοῦ, διὰ γὰρ νόμου ἐπίγνωσις ἁμαρτίας. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Νυνὶ δὲ χωρὶς νόμου δικαιοσύνη θεοῦ πεφανέρωται, μαρτυρουμένη ὑπὸ τοῦ νόμου καὶ τῶν προφητῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","δικαιοσύνη δὲ θεοῦ διὰ πίστεως Ἰησοῦ Χριστοῦ, εἰς ⸀πάνταςτοὺς πιστεύοντας, οὐ γάρ ἐστιν διαστολή. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","πάντες γὰρ ἥμαρτον καὶ ὑστεροῦνται τῆς δόξης τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","δικαιούμενοι δωρεὰν τῇ αὐτοῦ χάριτι διὰ τῆς ἀπολυτρώσεως τῆς ἐν Χριστῷ Ἰησοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ὃν προέθετο ὁ θεὸς ἱλαστήριον ⸀διὰπίστεως ἐν τῷ αὐτοῦ αἵματι εἰς ἔνδειξιν τῆς δικαιοσύνης αὐτοῦ διὰ τὴν πάρεσιν τῶν προγεγονότων ἁμαρτημάτων ");
INSERT INTO grcsbl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ἐν τῇ ἀνοχῇ τοῦ θεοῦ, πρὸς ⸀τὴνἔνδειξιν τῆς δικαιοσύνης αὐτοῦ ἐν τῷ νῦν καιρῷ, εἰς τὸ εἶναι αὐτὸν δίκαιον καὶ δικαιοῦντα τὸν ἐκ πίστεως Ἰησοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ποῦ οὖν ἡ καύχησις; ἐξεκλείσθη. διὰ ποίου νόμου; τῶν ἔργων; οὐχί, ἀλλὰ διὰ νόμου πίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","λογιζόμεθα ⸀γὰρ⸂δικαιοῦσθαι πίστει ἄνθρωπον χωρὶς ἔργων νόμου. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ἢ Ἰουδαίων ὁ θεὸς μόνον; ⸀οὐχὶκαὶ ἐθνῶν; ναὶ καὶ ἐθνῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","⸀εἴπερεἷς ὁ θεός, ὃς δικαιώσει περιτομὴν ἐκ πίστεως καὶ ἀκροβυστίαν διὰ τῆς πίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","νόμον οὖν καταργοῦμεν διὰ τῆς πίστεως; μὴ γένοιτο, ἀλλὰ νόμον ⸀ἱστάνομεν ");
INSERT INTO grcsbl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Τί οὖν ἐροῦμεν ⸀εὑρηκέναιἈβραὰμ τὸν ⸀προπάτορα⸀ἡμῶνκατὰ σάρκα; ");
INSERT INTO grcsbl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","εἰ γὰρ Ἀβραὰμ ἐξ ἔργων ἐδικαιώθη, ἔχει καύχημα· ἀλλʼ οὐ ⸀πρὸςθεόν, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","τί γὰρ ἡ γραφὴ λέγει; Ἐπίστευσεν δὲ Ἀβραὰμ τῷ θεῷ καὶ ἐλογίσθη αὐτῷ εἰς δικαιοσύνην. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","τῷ δὲ ἐργαζομένῳ ὁ μισθὸς οὐ λογίζεται κατὰ χάριν ἀλλὰ κατὰ ὀφείλημα· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","τῷ δὲ μὴ ἐργαζομένῳ, πιστεύοντι δὲ ἐπὶ τὸν δικαιοῦντα τὸν ἀσεβῆ, λογίζεται ἡ πίστις αὐτοῦ εἰς δικαιοσύνην, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","καθάπερ καὶ Δαυὶδ λέγει τὸν μακαρισμὸν τοῦ ἀνθρώπου ᾧ ὁ θεὸς λογίζεται δικαιοσύνην χωρὶς ἔργων· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Μακάριοι ὧν ἀφέθησαν αἱ ἀνομίαι καὶ ὧν ἐπεκαλύφθησαν αἱ ἁμαρτίαι, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","μακάριος ἀνὴρ ⸀οὗοὐ μὴ λογίσηται κύριος ἁμαρτίαν. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ὁ μακαρισμὸς οὖν οὗτος ἐπὶ τὴν περιτομὴν ἢ καὶ ἐπὶ τὴν ἀκροβυστίαν; λέγομεν ⸀γάρ Ἐλογίσθη τῷ Ἀβραὰμ ἡ πίστις εἰς δικαιοσύνην. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","πῶς οὖν ἐλογίσθη; ἐν περιτομῇ ὄντι ἢ ἐν ἀκροβυστίᾳ; οὐκ ἐν περιτομῇ ἀλλʼ ἐν ἀκροβυστίᾳ· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","καὶ σημεῖον ἔλαβεν περιτομῆς, σφραγῖδα τῆς δικαιοσύνης τῆς πίστεως τῆς ἐν τῇ ἀκροβυστίᾳ, εἰς τὸ εἶναι αὐτὸν πατέρα πάντων τῶν πιστευόντων διʼ ἀκροβυστίας, εἰς τὸ ⸀λογισθῆναιαὐτοῖς τὴν δικαιοσύνην, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","καὶ πατέρα περιτομῆς τοῖς οὐκ ἐκ περιτομῆς μόνον ἀλλὰ καὶ τοῖς στοιχοῦσιν τοῖς ἴχνεσιν τῆς ⸂ἐν ἀκροβυστίᾳ πίστεως τοῦ πατρὸς ἡμῶν Ἀβραάμ. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Οὐ γὰρ διὰ νόμου ἡ ἐπαγγελία τῷ Ἀβραὰμ ἢ τῷ σπέρματι αὐτοῦ, τὸ κληρονόμον αὐτὸν ⸀εἶναικόσμου, ἀλλὰ διὰ δικαιοσύνης πίστεως· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","εἰ γὰρ οἱ ἐκ νόμου κληρονόμοι, κεκένωται ἡ πίστις καὶ κατήργηται ἡ ἐπαγγελία· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ὁ γὰρ νόμος ὀργὴν κατεργάζεται, οὗ ⸀δὲοὐκ ἔστιν νόμος, οὐδὲ παράβασις. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Διὰ τοῦτο ἐκ πίστεως, ἵνα κατὰ χάριν, εἰς τὸ εἶναι βεβαίαν τὴν ἐπαγγελίαν παντὶ τῷ σπέρματι, οὐ τῷ ἐκ τοῦ νόμου μόνον ἀλλὰ καὶ τῷ ἐκ πίστεως Ἀβραάμ (ὅς ἐστιν πατὴρ πάντων ἡμῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","καθὼς γέγραπται ὅτι Πατέρα πολλῶν ἐθνῶν τέθεικά σε), κατέναντι οὗ ἐπίστευσεν θεοῦ τοῦ ζῳοποιοῦντος τοὺς νεκροὺς καὶ καλοῦντος τὰ μὴ ὄντα ὡς ὄντα· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ὃς παρʼ ἐλπίδα ἐπʼ ἐλπίδι ἐπίστευσεν εἰς τὸ γενέσθαι αὐτὸν πατέρα πολλῶν ἐθνῶν κατὰ τὸ εἰρημένον· Οὕτως ἔσται τὸ σπέρμα σου· ");
INSERT INTO grcsbl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","καὶ μὴ ἀσθενήσας τῇ ⸀πίστεικατενόησεν τὸ ἑαυτοῦ ⸀σῶμανενεκρωμένον, ἑκατονταετής που ὑπάρχων, καὶ τὴν νέκρωσιν τῆς μήτρας Σάρρας, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","εἰς δὲ τὴν ἐπαγγελίαν τοῦ θεοῦ οὐ διεκρίθη τῇ ἀπιστίᾳ ἀλλὰ ἐνεδυναμώθη τῇ πίστει, δοὺς δόξαν τῷ θεῷ ");
INSERT INTO grcsbl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","καὶ πληροφορηθεὶς ὅτι ὃ ἐπήγγελται δυνατός ἐστιν καὶ ποιῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","⸀διὸἐλογίσθη αὐτῷ εἰς δικαιοσύνην. ");
INSERT INTO grcsbl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Οὐκ ἐγράφη δὲ διʼ αὐτὸν μόνον ὅτι ἐλογίσθη αὐτῷ, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ἀλλὰ καὶ διʼ ἡμᾶς οἷς μέλλει λογίζεσθαι, τοῖς πιστεύουσιν ἐπὶ τὸν ἐγείραντα Ἰησοῦν τὸν κύριον ἡμῶν ἐκ νεκρῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ὃς παρεδόθη διὰ τὰ παραπτώματα ἡμῶν καὶ ἠγέρθη διὰ τὴν δικαίωσιν ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Δικαιωθέντες οὖν ἐκ πίστεως εἰρήνην ⸀ἔχομενπρὸς τὸν θεὸν διὰ τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","διʼ οὗ καὶ τὴν προσαγωγὴν ἐσχήκαμεν τῇ πίστει εἰς τὴν χάριν ταύτην ἐν ᾗ ἑστήκαμεν, καὶ καυχώμεθα ἐπʼ ἐλπίδι τῆς δόξης τοῦ θεοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","οὐ μόνον δέ, ἀλλὰ καὶ ⸀καυχώμεθαἐν ταῖς θλίψεσιν, εἰδότες ὅτι ἡ θλῖψις ὑπομονὴν κατεργάζεται, ");
INSERT INTO grcsbl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ἡ δὲ ὑπομονὴ δοκιμήν, ἡ δὲ δοκιμὴ ἐλπίδα. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ἡ δὲ ἐλπὶς οὐ καταισχύνει· ὅτι ἡ ἀγάπη τοῦ θεοῦ ἐκκέχυται ἐν ταῖς καρδίαις ἡμῶν διὰ πνεύματος ἁγίου τοῦ δοθέντος ἡμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","⸂Ἔτι γὰρ Χριστὸς ὄντων ἡμῶν ἀσθενῶν ⸀ἔτικατὰ καιρὸν ὑπὲρ ἀσεβῶν ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","μόλις γὰρ ὑπὲρ δικαίου τις ἀποθανεῖται· ὑπὲρ γὰρ τοῦ ἀγαθοῦ τάχα τις καὶ τολμᾷ ἀποθανεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","συνίστησιν δὲ τὴν ἑαυτοῦ ἀγάπην εἰς ἡμᾶς ὁ θεὸς ὅτι ἔτι ἁμαρτωλῶν ὄντων ἡμῶν Χριστὸς ὑπὲρ ἡμῶν ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","πολλῷ οὖν μᾶλλον δικαιωθέντες νῦν ἐν τῷ αἵματι αὐτοῦ σωθησόμεθα διʼ αὐτοῦ ἀπὸ τῆς ὀργῆς. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","εἰ γὰρ ἐχθροὶ ὄντες κατηλλάγημεν τῷ θεῷ διὰ τοῦ θανάτου τοῦ υἱοῦ αὐτοῦ, πολλῷ μᾶλλον καταλλαγέντες σωθησόμεθα ἐν τῇ ζωῇ αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","οὐ μόνον δέ, ἀλλὰ καὶ καυχώμενοι ἐν τῷ θεῷ διὰ τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ, διʼ οὗ νῦν τὴν καταλλαγὴν ἐλάβομεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Διὰ τοῦτο ὥσπερ διʼ ἑνὸς ἀνθρώπου ἡ ἁμαρτία εἰς τὸν κόσμον εἰσῆλθεν καὶ διὰ τῆς ἁμαρτίας ὁ θάνατος, καὶ οὕτως εἰς πάντας ἀνθρώπους ὁ θάνατος διῆλθεν ἐφʼ ᾧ πάντες ἥμαρτον— ");
INSERT INTO grcsbl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ἄχρι γὰρ νόμου ἁμαρτία ἦν ἐν κόσμῳ, ἁμαρτία δὲ οὐκ ἐλλογεῖται μὴ ὄντος νόμου, ");
INSERT INTO grcsbl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ἀλλὰ ἐβασίλευσεν ὁ θάνατος ἀπὸ Ἀδὰμ μέχρι Μωϋσέως καὶ ἐπὶ τοὺς μὴ ἁμαρτήσαντας ἐπὶ τῷ ὁμοιώματι τῆς παραβάσεως Ἀδάμ, ὅς ἐστιν τύπος τοῦ μέλλοντος. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ἀλλʼ οὐχ ὡς τὸ παράπτωμα, οὕτως καὶ τὸ χάρισμα· εἰ γὰρ τῷ τοῦ ἑνὸς παραπτώματι οἱ πολλοὶ ἀπέθανον, πολλῷ μᾶλλον ἡ χάρις τοῦ θεοῦ καὶ ἡ δωρεὰ ἐν χάριτι τῇ τοῦ ἑνὸς ἀνθρώπου Ἰησοῦ Χριστοῦ εἰς τοὺς πολλοὺς ἐπερίσσευσεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","καὶ οὐχ ὡς διʼ ἑνὸς ἁμαρτήσαντος τὸ δώρημα· τὸ μὲν γὰρ κρίμα ἐξ ἑνὸς εἰς κατάκριμα, τὸ δὲ χάρισμα ἐκ πολλῶν παραπτωμάτων εἰς δικαίωμα. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","εἰ γὰρ τῷ τοῦ ἑνὸς παραπτώματι ὁ θάνατος ἐβασίλευσεν διὰ τοῦ ἑνός, πολλῷ μᾶλλον οἱ τὴν περισσείαν τῆς χάριτος καὶ τῆς δωρεᾶς τῆς δικαιοσύνης λαμβάνοντες ἐν ζωῇ βασιλεύσουσιν διὰ τοῦ ἑνὸς Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ἄρα οὖν ὡς διʼ ἑνὸς παραπτώματος εἰς πάντας ἀνθρώπους εἰς κατάκριμα, οὕτως καὶ διʼ ἑνὸς δικαιώματος εἰς πάντας ἀνθρώπους εἰς δικαίωσιν ζωῆς· ");
INSERT INTO grcsbl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ὥσπερ γὰρ διὰ τῆς παρακοῆς τοῦ ἑνὸς ἀνθρώπου ἁμαρτωλοὶ κατεστάθησαν οἱ πολλοί, οὕτως καὶ διὰ τῆς ὑπακοῆς τοῦ ἑνὸς δίκαιοι κατασταθήσονται οἱ πολλοί. ");
INSERT INTO grcsbl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","νόμος δὲ παρεισῆλθεν ἵνα πλεονάσῃ τὸ παράπτωμα· οὗ δὲ ἐπλεόνασεν ἡ ἁμαρτία, ὑπερεπερίσσευσεν ἡ χάρις, ");
INSERT INTO grcsbl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ἵνα ὥσπερ ἐβασίλευσεν ἡ ἁμαρτία ἐν τῷ θανάτῳ, οὕτως καὶ ἡ χάρις βασιλεύσῃ διὰ δικαιοσύνης εἰς ζωὴν αἰώνιον διὰ Ἰησοῦ Χριστοῦ τοῦ κυρίου ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Τί οὖν ἐροῦμεν; ⸀ἐπιμένωμεντῇ ἁμαρτίᾳ, ἵνα ἡ χάρις πλεονάσῃ; ");
INSERT INTO grcsbl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","μὴ γένοιτο· οἵτινες ἀπεθάνομεν τῇ ἁμαρτίᾳ, πῶς ἔτι ζήσομεν ἐν αὐτῇ; ");
INSERT INTO grcsbl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ἢ ἀγνοεῖτε ὅτι ὅσοι ἐβαπτίσθημεν εἰς Χριστὸν Ἰησοῦν εἰς τὸν θάνατον αὐτοῦ ἐβαπτίσθημεν; ");
INSERT INTO grcsbl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","συνετάφημεν οὖν αὐτῷ διὰ τοῦ βαπτίσματος εἰς τὸν θάνατον, ἵνα ὥσπερ ἠγέρθη Χριστὸς ἐκ νεκρῶν διὰ τῆς δόξης τοῦ πατρός, οὕτως καὶ ἡμεῖς ἐν καινότητι ζωῆς περιπατήσωμεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Εἰ γὰρ σύμφυτοι γεγόναμεν τῷ ὁμοιώματι τοῦ θανάτου αὐτοῦ, ἀλλὰ καὶ τῆς ἀναστάσεως ἐσόμεθα· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","τοῦτο γινώσκοντες ὅτι ὁ παλαιὸς ἡμῶν ἄνθρωπος συνεσταυρώθη, ἵνα καταργηθῇ τὸ σῶμα τῆς ἁμαρτίας, τοῦ μηκέτι δουλεύειν ἡμᾶς τῇ ἁμαρτίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ὁ γὰρ ἀποθανὼν δεδικαίωται ἀπὸ τῆς ἁμαρτίας. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","εἰ δὲ ἀπεθάνομεν σὺν Χριστῷ, πιστεύομεν ὅτι καὶ συζήσομεν αὐτῷ· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","εἰδότες ὅτι Χριστὸς ἐγερθεὶς ἐκ νεκρῶν οὐκέτι ἀποθνῄσκει, θάνατος αὐτοῦ οὐκέτι κυριεύει· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ὃ γὰρ ἀπέθανεν, τῇ ἁμαρτίᾳ ἀπέθανεν ἐφάπαξ· ὃ δὲ ζῇ, ζῇ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","οὕτως καὶ ὑμεῖς λογίζεσθε ἑαυτοὺς ⸂εἶναι νεκροὺς μὲν τῇ ἁμαρτίᾳ ζῶντας δὲ τῷ θεῷ ἐν Χριστῷ ⸀Ἰησοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Μὴ οὖν βασιλευέτω ἡ ἁμαρτία ἐν τῷ θνητῷ ὑμῶν σώματι εἰς τὸ ⸀ὑπακούεινταῖς ἐπιθυμίαις αὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","μηδὲ παριστάνετε τὰ μέλη ὑμῶν ὅπλα ἀδικίας τῇ ἁμαρτίᾳ, ἀλλὰ παραστήσατε ἑαυτοὺς τῷ θεῷ ⸀ὡσεὶἐκ νεκρῶν ζῶντας καὶ τὰ μέλη ὑμῶν ὅπλα δικαιοσύνης τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ἁμαρτία γὰρ ὑμῶν οὐ κυριεύσει, οὐ γάρ ἐστε ὑπὸ νόμον ἀλλὰ ὑπὸ χάριν. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Τί οὖν; ⸀ἁμαρτήσωμενὅτι οὐκ ἐσμὲν ὑπὸ νόμον ἀλλὰ ὑπὸ χάριν; μὴ γένοιτο· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","οὐκ οἴδατε ὅτι ᾧ παριστάνετε ἑαυτοὺς δούλους εἰς ὑπακοήν, δοῦλοί ἐστε ᾧ ὑπακούετε, ἤτοι ἁμαρτίας εἰς θάνατον ἢ ὑπακοῆς εἰς δικαιοσύνην; ");
INSERT INTO grcsbl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","χάρις δὲ τῷ θεῷ ὅτι ἦτε δοῦλοι τῆς ἁμαρτίας ὑπηκούσατε δὲ ἐκ καρδίας εἰς ὃν παρεδόθητε τύπον διδαχῆς, ");
INSERT INTO grcsbl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ἐλευθερωθέντες δὲ ἀπὸ τῆς ἁμαρτίας ἐδουλώθητε τῇ δικαιοσύνῃ· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ἀνθρώπινον λέγω διὰ τὴν ἀσθένειαν τῆς σαρκὸς ὑμῶν· ὥσπερ γὰρ παρεστήσατε τὰ μέλη ὑμῶν δοῦλα τῇ ἀκαθαρσίᾳ καὶ τῇ ἀνομίᾳ εἰς τὴν ἀνομίαν, οὕτως νῦν παραστήσατε τὰ μέλη ὑμῶν δοῦλα τῇ δικαιοσύνῃ εἰς ἁγιασμόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ὅτε γὰρ δοῦλοι ἦτε τῆς ἁμαρτίας, ἐλεύθεροι ἦτε τῇ δικαιοσύνῃ. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","τίνα οὖν καρπὸν εἴχετε τότε ἐφʼ οἷς νῦν ἐπαισχύνεσθε; τὸ γὰρ τέλος ἐκείνων θάνατος· ");
INSERT INTO grcsbl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","νυνὶ δέ, ἐλευθερωθέντες ἀπὸ τῆς ἁμαρτίας δουλωθέντες δὲ τῷ θεῷ, ἔχετε τὸν καρπὸν ὑμῶν εἰς ἁγιασμόν, τὸ δὲ τέλος ζωὴν αἰώνιον. ");
INSERT INTO grcsbl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","τὰ γὰρ ὀψώνια τῆς ἁμαρτίας θάνατος, τὸ δὲ χάρισμα τοῦ θεοῦ ζωὴ αἰώνιος ἐν Χριστῷ Ἰησοῦ τῷ κυρίῳ ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ἢ ἀγνοεῖτε, ἀδελφοί, γινώσκουσιν γὰρ νόμον λαλῶ, ὅτι ὁ νόμος κυριεύει τοῦ ἀνθρώπου ἐφʼ ὅσον χρόνον ζῇ; ");
INSERT INTO grcsbl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ἡ γὰρ ὕπανδρος γυνὴ τῷ ζῶντι ἀνδρὶ δέδεται νόμῳ· ἐὰν δὲ ἀποθάνῃ ὁ ἀνήρ, κατήργηται ἀπὸ τοῦ νόμου τοῦ ἀνδρός. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ἄρα οὖν ζῶντος τοῦ ἀνδρὸς μοιχαλὶς χρηματίσει ἐὰν γένηται ἀνδρὶ ἑτέρῳ· ἐὰν δὲ ἀποθάνῃ ὁ ἀνήρ, ἐλευθέρα ἐστὶν ἀπὸ τοῦ νόμου, τοῦ μὴ εἶναι αὐτὴν μοιχαλίδα γενομένην ἀνδρὶ ἑτέρῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ὥστε, ἀδελφοί μου, καὶ ὑμεῖς ἐθανατώθητε τῷ νόμῳ διὰ τοῦ σώματος τοῦ Χριστοῦ, εἰς τὸ γενέσθαι ὑμᾶς ἑτέρῳ, τῷ ἐκ νεκρῶν ἐγερθέντι ἵνα καρποφορήσωμεν τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ὅτε γὰρ ἦμεν ἐν τῇ σαρκί, τὰ παθήματα τῶν ἁμαρτιῶν τὰ διὰ τοῦ νόμου ἐνηργεῖτο ἐν τοῖς μέλεσιν ἡμῶν εἰς τὸ καρποφορῆσαι τῷ θανάτῳ· ");
INSERT INTO grcsbl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","νυνὶ δὲ κατηργήθημεν ἀπὸ τοῦ νόμου, ἀποθανόντες ἐν ᾧ κατειχόμεθα, ὥστε δουλεύειν ἡμᾶς ἐν καινότητι πνεύματος καὶ οὐ παλαιότητι γράμματος. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Τί οὖν ἐροῦμεν; ὁ νόμος ἁμαρτία; μὴ γένοιτο· ἀλλὰ τὴν ἁμαρτίαν οὐκ ἔγνων εἰ μὴ διὰ νόμου, τήν τε γὰρ ἐπιθυμίαν οὐκ ᾔδειν εἰ μὴ ὁ νόμος ἔλεγεν· Οὐκ ἐπιθυμήσεις· ");
INSERT INTO grcsbl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ἀφορμὴν δὲ λαβοῦσα ἡ ἁμαρτία διὰ τῆς ἐντολῆς κατειργάσατο ἐν ἐμοὶ πᾶσαν ἐπιθυμίαν, χωρὶς γὰρ νόμου ἁμαρτία νεκρά. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ἐγὼ δὲ ἔζων χωρὶς νόμου ποτέ· ἐλθούσης δὲ τῆς ἐντολῆς ἡ ἁμαρτία ἀνέζησεν, ");
INSERT INTO grcsbl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ἐγὼ δὲ ἀπέθανον, καὶ εὑρέθη μοι ἡ ἐντολὴ ἡ εἰς ζωὴν αὕτη εἰς θάνατον· ");
INSERT INTO grcsbl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ἡ γὰρ ἁμαρτία ἀφορμὴν λαβοῦσα διὰ τῆς ἐντολῆς ἐξηπάτησέν με καὶ διʼ αὐτῆς ἀπέκτεινεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ὥστε ὁ μὲν νόμος ἅγιος, καὶ ἡ ἐντολὴ ἁγία καὶ δικαία καὶ ἀγαθή. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Τὸ οὖν ἀγαθὸν ἐμοὶ ⸀ἐγένετοθάνατος; μὴ γένοιτο· ἀλλὰ ἡ ἁμαρτία, ἵνα φανῇ ἁμαρτία διὰ τοῦ ἀγαθοῦ μοι κατεργαζομένη θάνατον· ἵνα γένηται καθʼ ὑπερβολὴν ἁμαρτωλὸς ἡ ἁμαρτία διὰ τῆς ἐντολῆς. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Οἴδαμεν γὰρ ὅτι ὁ νόμος πνευματικός ἐστιν· ἐγὼ δὲ ⸀σάρκινόςεἰμι, πεπραμένος ὑπὸ τὴν ἁμαρτίαν. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ὃ γὰρ κατεργάζομαι οὐ γινώσκω· οὐ γὰρ ὃ θέλω τοῦτο πράσσω, ἀλλʼ ὃ μισῶ τοῦτο ποιῶ. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","εἰ δὲ ὃ οὐ θέλω τοῦτο ποιῶ, σύμφημι τῷ νόμῳ ὅτι καλός. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","νυνὶ δὲ οὐκέτι ἐγὼ κατεργάζομαι αὐτὸ ἀλλὰ ἡ ⸀οἰκοῦσαἐν ἐμοὶ ἁμαρτία. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","οἶδα γὰρ ὅτι οὐκ οἰκεῖ ἐν ἐμοί, τοῦτʼ ἔστιν ἐν τῇ σαρκί μου, ἀγαθόν· τὸ γὰρ θέλειν παράκειταί μοι, τὸ δὲ κατεργάζεσθαι τὸ καλὸν ⸀οὔ ");
INSERT INTO grcsbl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","οὐ γὰρ ὃ θέλω ποιῶ ἀγαθόν, ἀλλὰ ὃ οὐ θέλω κακὸν τοῦτο πράσσω. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","εἰ δὲ ὃ οὐ ⸀θέλωτοῦτο ποιῶ, οὐκέτι ἐγὼ κατεργάζομαι αὐτὸ ἀλλὰ ἡ οἰκοῦσα ἐν ἐμοὶ ἁμαρτία. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Εὑρίσκω ἄρα τὸν νόμον τῷ θέλοντι ἐμοὶ ποιεῖν τὸ καλὸν ὅτι ἐμοὶ τὸ κακὸν παράκειται· ");
INSERT INTO grcsbl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","συνήδομαι γὰρ τῷ νόμῳ τοῦ θεοῦ κατὰ τὸν ἔσω ἄνθρωπον, ");
INSERT INTO grcsbl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","βλέπω δὲ ἕτερον νόμον ἐντοῖς μέλεσίν μου ἀντιστρατευόμενον τῷ νόμῳ τοῦ νοός μου καὶ αἰχμαλωτίζοντά με ⸀ἐν τῷ νόμῳ τῆς ἁμαρτίας τῷ ὄντι ἐν τοῖς μέλεσίν μου. ");
INSERT INTO grcsbl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ταλαίπωρος ἐγὼ ἄνθρωπος· τίς με ῥύσεται ἐκ τοῦ σώματος τοῦ θανάτου τούτου; ");
INSERT INTO grcsbl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","⸀χάριςτῷ θεῷ διὰ Ἰησοῦ Χριστοῦ τοῦ κυρίου ἡμῶν. Ἄρα οὖν αὐτὸς ἐγὼ τῷ μὲν νοῒ δουλεύω νόμῳ θεοῦ, τῇ δὲ σαρκὶ νόμῳ ἁμαρτίας. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Οὐδὲν ἄρα νῦν κατάκριμα τοῖς ἐν Χριστῷ ⸀Ἰησοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ὁ γὰρ νόμος τοῦ πνεύματος τῆς ζωῆς ἐν Χριστῷ Ἰησοῦ ἠλευθέρωσέν ⸀σεἀπὸ τοῦ νόμου τῆς ἁμαρτίας καὶ τοῦ θανάτου. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","τὸ γὰρ ἀδύνατον τοῦ νόμου, ἐν ᾧ ἠσθένει διὰ τῆς σαρκός, ὁ θεὸς τὸν ἑαυτοῦ υἱὸν πέμψας ἐν ὁμοιώματι σαρκὸς ἁμαρτίας καὶ περὶ ἁμαρτίας κατέκρινε τὴν ἁμαρτίαν ἐν τῇ σαρκί, ");
INSERT INTO grcsbl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ἵνα τὸ δικαίωμα τοῦ νόμου πληρωθῇ ἐν ἡμῖν τοῖς μὴ κατὰ σάρκα περιπατοῦσιν ἀλλὰ κατὰ πνεῦμα· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","οἱ γὰρ κατὰ σάρκα ὄντες τὰ τῆς σαρκὸς φρονοῦσιν, οἱ δὲ κατὰ πνεῦμα τὰ τοῦ πνεύματος. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","τὸ γὰρ φρόνημα τῆς σαρκὸς θάνατος, τὸ δὲ φρόνημα τοῦ πνεύματος ζωὴ καὶ εἰρήνη· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","διότι τὸ φρόνημα τῆς σαρκὸς ἔχθρα εἰς θεόν, τῷ γὰρ νόμῳ τοῦ θεοῦ οὐχ ὑποτάσσεται, οὐδὲ γὰρ δύναται· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","οἱ δὲ ἐν σαρκὶ ὄντες θεῷ ἀρέσαι οὐ δύνανται. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ὑμεῖς δὲ οὐκ ἐστὲ ἐν σαρκὶ ἀλλὰ ἐν πνεύματι, εἴπερ πνεῦμα θεοῦ οἰκεῖ ἐν ὑμῖν. εἰ δέ τις πνεῦμα Χριστοῦ οὐκ ἔχει, οὗτος οὐκ ἔστιν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","εἰ δὲ Χριστὸς ἐν ὑμῖν, τὸ μὲν σῶμα νεκρὸν διὰ ἁμαρτίαν, τὸ δὲ πνεῦμα ζωὴ διὰ δικαιοσύνην. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","εἰ δὲ τὸ πνεῦμα τοῦ ἐγείραντος ⸀τὸνἸησοῦν ἐκ νεκρῶν οἰκεῖ ἐν ὑμῖν, ὁ ἐγείρας ⸂ἐκ νεκρῶν Χριστὸν Ἰησοῦν ζῳοποιήσει καὶ τὰ θνητὰ σώματα ὑμῶν διὰ ⸂τὸ ἐνοικοῦν αὐτοῦ πνεῦμα ἐν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ἄρα οὖν, ἀδελφοί, ὀφειλέται ἐσμέν, οὐ τῇ σαρκὶ τοῦ κατὰ σάρκα ζῆν, ");
INSERT INTO grcsbl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","εἰ γὰρ κατὰ σάρκα ζῆτε μέλλετε ἀποθνῄσκειν, εἰ δὲ πνεύματι τὰς πράξεις τοῦ σώματος θανατοῦτε, ζήσεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ὅσοι γὰρ πνεύματι θεοῦ ἄγονται, οὗτοι ⸂υἱοί εἰσιν θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","οὐ γὰρ ἐλάβετε πνεῦμα δουλείας πάλιν εἰς φόβον, ἀλλὰ ἐλάβετε πνεῦμα υἱοθεσίας ἐν ᾧ κράζομεν· Αββα ὁ πατήρ· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","αὐτὸ τὸ πνεῦμα συμμαρτυρεῖ τῷ πνεύματι ἡμῶν ὅτι ἐσμὲν τέκνα θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","εἰ δὲ τέκνα, καὶ κληρονόμοι· κληρονόμοι μὲν θεοῦ, συγκληρονόμοι δὲ Χριστοῦ, εἴπερ συμπάσχομεν ἵνα καὶ συνδοξασθῶμεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Λογίζομαι γὰρ ὅτι οὐκ ἄξια τὰ παθήματα τοῦ νῦν καιροῦ πρὸς τὴν μέλλουσαν δόξαν ἀποκαλυφθῆναι εἰς ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ἡ γὰρ ἀποκαραδοκία τῆς κτίσεως τὴν ἀποκάλυψιν τῶν υἱῶν τοῦ θεοῦ ἀπεκδέχεται· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","τῇ γὰρ ματαιότητι ἡ κτίσις ὑπετάγη, οὐχ ἑκοῦσα ἀλλὰ διὰ τὸν ὑποτάξαντα, ⸀ἐφʼἑλπίδι ");
INSERT INTO grcsbl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ὅτι καὶ αὐτὴ ἡ κτίσις ἐλευθερωθήσεται ἀπὸ τῆς δουλείας τῆς φθορᾶς εἰς τὴν ἐλευθερίαν τῆς δόξης τῶν τέκνων τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","οἴδαμεν γὰρ ὅτι πᾶσα ἡ κτίσις συστενάζει καὶ συνωδίνει ἄχρι τοῦ νῦν· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","οὐ μόνον δέ, ἀλλὰ ⸂καὶ αὐτοὶ τὴν ἀπαρχὴν τοῦ πνεύματος ἔχοντες ⸂ἡμεῖς καὶ αὐτοὶ ἐν ἑαυτοῖς στενάζομεν, υἱοθεσίαν ἀπεκδεχόμενοι τὴν ἀπολύτρωσιν τοῦ σώματος ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","τῇ γὰρ ἐλπίδι ἐσώθημεν· ἐλπὶς δὲ βλεπομένη οὐκ ἔστιν ἐλπίς, ὃ γὰρ βλέπει ⸀τίςἐλπίζει; ");
INSERT INTO grcsbl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","εἰ δὲ ὃ οὐ βλέπομεν ἐλπίζομεν, διʼ ὑπομονῆς ἀπεκδεχόμεθα. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ὡσαύτως δὲ καὶ τὸ πνεῦμα συναντιλαμβάνεται ⸂τῇ ἀσθενείᾳ ἡμῶν· τὸ γὰρ τί ⸀προσευξώμεθακαθὸ δεῖ οὐκ οἴδαμεν, ἀλλὰ αὐτὸ τὸ πνεῦμα ⸀ὑπερεντυγχάνειστεναγμοῖς ἀλαλήτοις, ");
INSERT INTO grcsbl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ὁ δὲ ἐραυνῶν τὰς καρδίας οἶδεν τί τὸ φρόνημα τοῦ πνεύματος, ὅτι κατὰ θεὸν ἐντυγχάνει ὑπὲρ ἁγίων. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Οἴδαμεν δὲ ὅτι τοῖς ἀγαπῶσι τὸν θεὸν πάντα ⸀συνεργεῖεἰς ἀγαθόν, τοῖς κατὰ πρόθεσιν κλητοῖς οὖσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ὅτι οὓς προέγνω, καὶ προώρισεν συμμόρφους τῆς εἰκόνος τοῦ υἱοῦ αὐτοῦ, εἰς τὸ εἶναι αὐτὸν πρωτότοκον ἐν πολλοῖς ἀδελφοῖς· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","οὓς δὲ προώρισεν, τούτους καὶ ἐκάλεσεν· καὶ οὓς ἐκάλεσεν, τούτους καὶ ἐδικαίωσεν· οὓς δὲ ἐδικαίωσεν, τούτους καὶ ἐδόξασεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Τί οὖν ἐροῦμεν πρὸς ταῦτα; εἰ ὁ θεὸς ὑπὲρ ἡμῶν, τίς καθʼ ἡμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ὅς γε τοῦ ἰδίου υἱοῦ οὐκ ἐφείσατο, ἀλλὰ ὑπὲρ ἡμῶν πάντων παρέδωκεν αὐτόν, πῶς οὐχὶ καὶ σὺν αὐτῷ τὰ πάντα ἡμῖν χαρίσεται; ");
INSERT INTO grcsbl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","τίς ἐγκαλέσει κατὰ ἐκλεκτῶν θεοῦ; θεὸς ὁ δικαιῶν· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","τίς ὁ ⸀κατακρινῶν ⸀Χριστὸςὁ ἀποθανών, μᾶλλον ⸀δὲ⸀ἐγερθείς ὅς ⸀καίἐστιν ἐν δεξιᾷ τοῦ θεοῦ, ὃς καὶ ἐντυγχάνει ὑπὲρ ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","τίς ἡμᾶς χωρίσει ἀπὸ τῆς ἀγάπης τοῦ Χριστοῦ; θλῖψις ἢ στενοχωρία ἢ διωγμὸς ἢ λιμὸς ἢ γυμνότης ἢ κίνδυνος ἢ μάχαιρα; ");
INSERT INTO grcsbl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","καθὼς γέγραπται ὅτι Ἕνεκεν σοῦ θανατούμεθα ὅλην τὴν ἡμέραν, ἐλογίσθημεν ὡς πρόβατα σφαγῆς. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ἀλλʼ ἐν τούτοις πᾶσιν ὑπερνικῶμεν διὰ τοῦ ἀγαπήσαντος ἡμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","πέπεισμαι γὰρ ὅτι οὔτε θάνατος οὔτε ζωὴ οὔτε ἄγγελοι οὔτε ἀρχαὶ οὔτε ⸂ἐνεστῶτα οὔτε μέλλοντα οὔτε δυνάμεις ");
INSERT INTO grcsbl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","οὔτε ὕψωμα οὔτε βάθος οὔτε τις κτίσις ἑτέρα δυνήσεται ἡμᾶς χωρίσαι ἀπὸ τῆς ἀγάπης τοῦ θεοῦ τῆς ἐν Χριστῷ Ἰησοῦ τῷ κυρίῳ ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ἀλήθειαν λέγω ἐν Χριστῷ, οὐ ψεύδομαι, συμμαρτυρούσης μοι τῆς συνειδήσεώς μου ἐν πνεύματι ἁγίῳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ὅτι λύπη μοί ἐστιν μεγάλη καὶ ἀδιάλειπτος ὀδύνη τῇ καρδίᾳ μου· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ηὐχόμην γὰρ ⸂ἀνάθεμα εἶναι αὐτὸς ἐγὼ ἀπὸ τοῦ Χριστοῦ ὑπὲρ τῶν ἀδελφῶν μου τῶν συγγενῶν μου κατὰ σάρκα, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","οἵτινές εἰσιν Ἰσραηλῖται, ὧν ἡ υἱοθεσία καὶ ἡ δόξα καὶ αἱ διαθῆκαι καὶ ἡ νομοθεσία καὶ ἡ λατρεία καὶ αἱ ἐπαγγελίαι, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ὧν οἱ πατέρες, καὶ ἐξ ὧν ὁ χριστὸς τὸ κατὰ σάρκα, ὁ ὢν ἐπὶ πάντων, θεὸς εὐλογητὸς εἰς τοὺς αἰῶνας· ἀμήν. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Οὐχ οἷον δὲ ὅτι ἐκπέπτωκεν ὁ λόγος τοῦ θεοῦ. οὐ γὰρ πάντες οἱ ἐξ Ἰσραήλ, οὗτοι Ἰσραήλ· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","οὐδʼ ὅτι εἰσὶν σπέρμα Ἀβραάμ, πάντες τέκνα, ἀλλʼ· Ἐν Ἰσαὰκ κληθήσεταί σοι σπέρμα. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","τοῦτʼ ἔστιν, οὐ τὰ τέκνα τῆς σαρκὸς ταῦτα τέκνα τοῦ θεοῦ, ἀλλὰ τὰ τέκνα τῆς ἐπαγγελίας λογίζεται εἰς σπέρμα· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ἐπαγγελίας γὰρ ὁ λόγος οὗτος· Κατὰ τὸν καιρὸν τοῦτον ἐλεύσομαι καὶ ἔσται τῇ Σάρρᾳ υἱός. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","οὐ μόνον δέ, ἀλλὰ καὶ Ῥεβέκκα ἐξ ἑνὸς κοίτην ἔχουσα, Ἰσαὰκ τοῦ πατρὸς ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","μήπω γὰρ γεννηθέντων μηδὲ πραξάντων τι ἀγαθὸν ἢ ⸀φαῦλον ἵνα ἡ κατʼ ἐκλογὴν πρόθεσις τοῦ θεοῦ μένῃ, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","οὐκ ἐξ ἔργων ἀλλʼ ἐκ τοῦ καλοῦντος, ἐρρέθη αὐτῇ ὅτι Ὁ μείζων δουλεύσει τῷ ἐλάσσονι· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","⸀καθὼςγέγραπται· Τὸν Ἰακὼβ ἠγάπησα, τὸν δὲ Ἠσαῦ ἐμίσησα. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Τί οὖν ἐροῦμεν; μὴ ἀδικία παρὰ τῷ θεῷ; μὴ γένοιτο· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","τῷ ⸂Μωϋσεῖ γὰρ λέγει· Ἐλεήσω ὃν ἂν ἐλεῶ, καὶ οἰκτιρήσω ὃν ἂν οἰκτίρω. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ἄρα οὖν οὐ τοῦ θέλοντος οὐδὲ τοῦ τρέχοντος ἀλλὰ τοῦ ἐλεῶντος θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","λέγει γὰρ ἡ γραφὴ τῷ Φαραὼ ὅτι Εἰς αὐτὸ τοῦτο ἐξήγειρά σε ὅπως ἐνδείξωμαι ἐν σοὶ τὴν δύναμίν μου, καὶ ὅπως διαγγελῇ τὸ ὄνομά μου ἐν πάσῃ τῇ γῇ. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ἄρα οὖν ὃν θέλει ἐλεεῖ, ὃν δὲ θέλει σκληρύνει. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ἐρεῖς ⸂μοι οὖν· Τί ⸀οὖνἔτι μέμφεται; τῷ γὰρ βουλήματι αὐτοῦ τίς ἀνθέστηκεν; ");
INSERT INTO grcsbl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","⸂ὦ ἄνθρωπε, μενοῦνγε⸃ σὺ τίς εἶ ὁ ἀνταποκρινόμενος τῷ θεῷ; μὴ ἐρεῖ τὸ πλάσμα τῷ πλάσαντι Τί με ἐποίησας οὕτως; ");
INSERT INTO grcsbl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ἢ οὐκ ἔχει ἐξουσίαν ὁ κεραμεὺς τοῦ πηλοῦ ἐκ τοῦ αὐτοῦ φυράματος ποιῆσαι ὃ μὲν εἰς τιμὴν σκεῦος ὃ δὲ εἰς ἀτιμίαν; ");
INSERT INTO grcsbl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","εἰ δὲ θέλων ὁ θεὸς ἐνδείξασθαι τὴν ὀργὴν καὶ γνωρίσαι τὸ δυνατὸν αὐτοῦ ἤνεγκεν ἐν πολλῇ μακροθυμίᾳ σκεύη ὀργῆς κατηρτισμένα εἰς ἀπώλειαν, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","⸀καὶἵνα γνωρίσῃ τὸν πλοῦτον τῆς δόξης αὐτοῦ ἐπὶ σκεύη ἐλέους, ἃ προητοίμασεν εἰς δόξαν, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","οὓς καὶ ἐκάλεσεν ἡμᾶς οὐ μόνον ἐξ Ἰουδαίων ἀλλὰ καὶ ἐξ ἐθνῶν;— ");
INSERT INTO grcsbl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ὡς καὶ ἐν τῷ Ὡσηὲ λέγει· Καλέσω τὸν οὐ λαόν μου λαόν μου καὶ τὴν οὐκ ἠγαπημένην ἠγαπημένην· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","καὶ ἔσται ἐν τῷ τόπῳ οὗ ἐρρέθη ⸀αὐτοῖς Οὐ λαός μου ὑμεῖς, ἐκεῖ κληθήσονται υἱοὶ θεοῦ ζῶντος. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ἠσαΐας δὲ κράζει ὑπὲρ τοῦ Ἰσραήλ· Ἐὰν ᾖ ὁ ἀριθμὸς τῶν υἱῶν Ἰσραὴλ ὡς ἡ ἄμμος τῆς θαλάσσης, τὸ ⸀ὑπόλειμμασωθήσεται· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","λόγον γὰρ συντελῶν καὶ ⸀συντέμνωνποιήσει κύριος ἐπὶ τῆς γῆς. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","καὶ καθὼς προείρηκεν Ἠσαΐας· Εἰ μὴ κύριος Σαβαὼθ ἐγκατέλιπεν ἡμῖν σπέρμα, ὡς Σόδομα ἂν ἐγενήθημεν καὶ ὡς Γόμορρα ἂν ὡμοιώθημεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Τί οὖν ἐροῦμεν; ὅτι ἔθνη τὰ μὴ διώκοντα δικαιοσύνην κατέλαβεν δικαιοσύνην, δικαιοσύνην δὲ τὴν ἐκ πίστεως· ");
INSERT INTO grcsbl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ἰσραὴλ δὲ διώκων νόμονδικαιοσύνης εἰς ⸀νόμον οὐκ ἔφθασεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","διὰ τί; ὅτι οὐκ ἐκ πίστεως ἀλλʼ ὡς ἐξ ⸀ἔργων ⸀προσέκοψαντῷ λίθῳ τοῦ προσκόμματος, ");
INSERT INTO grcsbl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","καθὼς γέγραπται· Ἰδοὺ τίθημι ἐν Σιὼν λίθον προσκόμματος καὶπέτραν σκανδάλου, ⸀καὶ ὁ πιστεύων ἐπʼ αὐτῷ οὐ καταισχυνθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ἀδελφοί, ἡ μὲν εὐδοκία τῆς ἐμῆς καρδίας καὶ ἡ ⸀δέησιςπρὸς τὸν θεὸν ὑπὲρ ⸀αὐτῶνεἰς σωτηρίαν. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","μαρτυρῶ γὰρ αὐτοῖς ὅτι ζῆλον θεοῦ ἔχουσιν· ἀλλʼ οὐ κατʼ ἐπίγνωσιν, ");
INSERT INTO grcsbl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ἀγνοοῦντες γὰρ τὴν τοῦ θεοῦ δικαιοσύνην, καὶ τὴν ⸀ἰδίανζητοῦντες στῆσαι, τῇ δικαιοσύνῃ τοῦ θεοῦ οὐχ ὑπετάγησαν· ");
INSERT INTO grcsbl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","τέλος γὰρ νόμου Χριστὸς εἰς δικαιοσύνην παντὶ τῷ πιστεύοντι. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Μωϋσῆς γὰρ γράφει ⸂ὅτι τὴν δικαιοσύνην τὴν ἐκ ⸀τοῦ νόμου ὁ ⸀ποιήσας ἄνθρωπος ζήσεται ἐν ⸀αὐτῇ. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ἡ δὲ ἐκ πίστεως δικαιοσύνη οὕτως λέγει· Μὴ εἴπῃς ἐν τῇ καρδίᾳ σου· Τίς ἀναβήσεται εἰς τὸν οὐρανόν; τοῦτʼ ἔστιν Χριστὸν καταγαγεῖν· ");
INSERT INTO grcsbl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ἤ· Τίς καταβήσεται εἰς τὴν ἄβυσσον; τοῦτʼ ἔστιν Χριστὸν ἐκ νεκρῶν ἀναγαγεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ἀλλὰ τί λέγει; Ἐγγύς σου τὸ ῥῆμά ἐστιν, ἐν τῷ στόματί σου καὶ ἐν τῇ καρδίᾳ σου, τοῦτʼ ἔστιν τὸ ῥῆμα τῆς πίστεως ὃ κηρύσσομεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ὅτι ἐὰν ⸀ὁμολογήσῃςἐν τῷ στόματί ⸀σουκύριον Ἰησοῦν, καὶ πιστεύσῃς ἐν τῇ καρδίᾳ σου ὅτι ὁ θεὸς αὐτὸν ἤγειρεν ἐκ νεκρῶν, σωθήσῃ· ");
INSERT INTO grcsbl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","καρδίᾳ γὰρ πιστεύεται εἰς δικαιοσύνην, στόματι δὲ ὁμολογεῖται εἰς σωτηρίαν· ");
INSERT INTO grcsbl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","λέγει γὰρ ἡ γραφή· Πᾶς ὁ πιστεύων ἐπʼ αὐτῷ οὐ καταισχυνθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","οὐ γάρ ἐστιν διαστολὴ Ἰουδαίου τε καὶ Ἕλληνος, ὁ γὰρ αὐτὸς κύριος πάντων, πλουτῶν εἰς πάντας τοὺς ἐπικαλουμένους αὐτόν· ");
INSERT INTO grcsbl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Πᾶς γὰρ ὃς ἂν ἐπικαλέσηται τὸ ὄνομα κυρίου σωθήσεται. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Πῶς οὖν ⸀ἐπικαλέσωνταιεἰς ὃν οὐκ ἐπίστευσαν; πῶς δὲ ⸀πιστεύσωσινοὗ οὐκ ἤκουσαν; πῶς δὲ ⸀ἀκούσωσινχωρὶς κηρύσσοντος; ");
INSERT INTO grcsbl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","πῶς δὲ ⸀κηρύξωσινἐὰν μὴ ἀποσταλῶσιν; ⸀καθὼςγέγραπται· Ὡς ὡραῖοι οἱ πόδες τῶν ⸀εὐαγγελιζομένων⸀τὰἀγαθά. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ἀλλʼ οὐ πάντες ὑπήκουσαν τῷ εὐαγγελίῳ· Ἠσαΐας γὰρ λέγει· Κύριε, τίς ἐπίστευσεν τῇ ἀκοῇ ἡμῶν; ");
INSERT INTO grcsbl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ἄρα ἡ πίστις ἐξ ἀκοῆς, ἡ δὲ ἀκοὴ διὰ ῥήματος ⸀Χριστοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ἀλλὰ λέγω, μὴ οὐκ ἤκουσαν; μενοῦνγε· Εἰς πᾶσαν τὴν γῆν ἐξῆλθεν ὁ φθόγγος αὐτῶν, καὶ εἰς τὰ πέρατα τῆς οἰκουμένης τὰ ῥήματα αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ἀλλὰ λέγω, μὴ ⸂Ἰσραὴλ οὐκ ἔγνω; πρῶτος Μωϋσῆς λέγει· Ἐγὼ παραζηλώσω ὑμᾶς ἐπʼ οὐκ ἔθνει, ἐπʼ ἔθνει ἀσυνέτῳ παροργιῶ ὑμᾶς. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ἠσαΐας δὲ ἀποτολμᾷ καὶ λέγει· Εὑρέθην ⸀ἐντοῖς ἐμὲ μὴ ζητοῦσιν, ἐμφανὴς ⸀ἐγενόμηντοῖς ἐμὲ μὴ ἐπερωτῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","πρὸς δὲ τὸν Ἰσραὴλ λέγει· Ὅλην τὴν ἡμέραν ἐξεπέτασα τὰς χεῖράς μου πρὸς λαὸν ἀπειθοῦντα καὶ ἀντιλέγοντα. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Λέγω οὖν, μὴ ἀπώσατο ὁ θεὸς τὸν λαὸν αὐτοῦ; μὴ γένοιτο· καὶ γὰρ ἐγὼ Ἰσραηλίτης εἰμί, ἐκ σπέρματος Ἀβραάμ, φυλῆς Βενιαμίν. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","οὐκ ἀπώσατο ὁ θεὸς τὸν λαὸν αὐτοῦ ὃν προέγνω. ἢ οὐκ οἴδατε ἐν Ἠλίᾳ τί λέγει ἡ γραφή, ὡς ἐντυγχάνει τῷ θεῷ κατὰ τοῦ ⸀Ἰσραήλ ");
INSERT INTO grcsbl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Κύριε, τοὺς προφήτας σου ἀπέκτειναν, ⸀τὰθυσιαστήριά σου κατέσκαψαν, κἀγὼ ὑπελείφθην μόνος, καὶ ζητοῦσιν τὴν ψυχήν μου. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ἀλλὰ τί λέγει αὐτῷ ὁ χρηματισμός; Κατέλιπον ἐμαυτῷ ἑπτακισχιλίους ἄνδρας, οἵτινες οὐκ ἔκαμψαν γόνυ τῇ Βάαλ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","οὕτως οὖν καὶ ἐν τῷ νῦν καιρῷ λεῖμμα κατʼ ἐκλογὴν χάριτος γέγονεν· ");
INSERT INTO grcsbl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","εἰ δὲ χάριτι, οὐκέτι ἐξ ἔργων, ἐπεὶ ἡ χάριςοὐκέτι γίνεται ⸀χάρις. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","τί οὖν; ὃ ἐπιζητεῖ Ἰσραήλ, τοῦτο οὐκ ἐπέτυχεν, ἡ δὲ ἐκλογὴ ἐπέτυχεν· οἱ δὲ λοιποὶ ἐπωρώθησαν, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","⸀καθὼςγέγραπται· Ἔδωκεν αὐτοῖς ὁ θεὸς πνεῦμα κατανύξεως, ὀφθαλμοὺς τοῦ μὴ βλέπειν καὶ ὦτα τοῦ μὴ ἀκούειν, ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","καὶ Δαυὶδ λέγει· Γενηθήτω ἡ τράπεζα αὐτῶν εἰς παγίδα καὶ εἰς θήραν καὶ εἰς σκάνδαλον καὶ εἰς ἀνταπόδομα αὐτοῖς, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","σκοτισθήτωσαν οἱ ὀφθαλμοὶ αὐτῶν τοῦ μὴ βλέπειν, καὶ τὸν νῶτον αὐτῶν διὰ παντὸς σύγκαμψον. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Λέγω οὖν, μὴ ἔπταισαν ἵνα πέσωσιν; μὴ γένοιτο· ἀλλὰ τῷ αὐτῶν παραπτώματι ἡ σωτηρία τοῖς ἔθνεσιν, εἰς τὸ παραζηλῶσαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","εἰ δὲ τὸ παράπτωμα αὐτῶν πλοῦτος κόσμου καὶ τὸ ἥττημα αὐτῶν πλοῦτος ἐθνῶν, πόσῳ μᾶλλον τὸ πλήρωμα αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ὑμῖν ⸀δὲλέγω τοῖς ἔθνεσιν. ἐφʼ ὅσον μὲν ⸀οὖνεἰμι ἐγὼ ἐθνῶν ἀπόστολος, τὴν διακονίαν μου δοξάζω, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","εἴ πως παραζηλώσω μου τὴν σάρκα καὶ σώσω τινὰς ἐξ αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","εἰ γὰρ ἡ ἀποβολὴ αὐτῶν καταλλαγὴ κόσμου, τίς ἡ πρόσλημψις εἰ μὴ ζωὴ ἐκ νεκρῶν; ");
INSERT INTO grcsbl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","εἰ δὲ ἡ ἀπαρχὴ ἁγία, καὶ τὸ φύραμα· καὶ εἰ ἡ ῥίζα ἁγία, καὶ οἱ κλάδοι. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Εἰ δέ τινες τῶν κλάδων ἐξεκλάσθησαν, σὺ δὲ ἀγριέλαιος ὢν ἐνεκεντρίσθης ἐν αὐτοῖς καὶ συγκοινωνὸς τῆς ⸀ῥίζηςτῆς πιότητος τῆς ἐλαίας ἐγένου, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","μὴ κατακαυχῶ τῶν κλάδων· εἰ δὲ κατακαυχᾶσαι, οὐ σὺ τὴν ῥίζαν βαστάζεις ἀλλὰ ἡ ῥίζα σέ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ἐρεῖς οὖν· Ἐξεκλάσθησαν κλάδοι ἵνα ἐγὼ ἐγκεντρισθῶ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","καλῶς· τῇ ἀπιστίᾳ ἐξεκλάσθησαν, σὺ δὲ τῇ πίστει ἕστηκας. μὴ ⸂ὑψηλὰ φρόνει, ἀλλὰ φοβοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","εἰ γὰρ ὁ θεὸς τῶν κατὰ φύσιν κλάδων οὐκ ἐφείσατο, ⸀οὐδὲσοῦ φείσεται. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ἴδε οὖν χρηστότητα καὶ ἀποτομία θεοῦ· ἐπὶ μὲν τοὺς πεσόντας ⸀ἀποτομία, ἐπὶ δὲ σὲ ⸂χρηστότης θεοῦ, ἐὰν ⸀ἐπιμένῃςτῇ χρηστότητι, ἐπεὶ καὶ σὺ ἐκκοπήσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","κἀκεῖνοι δέ, ἐὰν μὴ ⸀ἐπιμένωσιτῇ ἀπιστίᾳ, ἐγκεντρισθήσονται· δυνατὸς γάρ ⸂ἐστιν ὁ θεὸς πάλιν ἐγκεντρίσαι αὐτούς. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","εἰ γὰρ σὺ ἐκ τῆς κατὰ φύσιν ἐξεκόπης ἀγριελαίου καὶ παρὰ φύσιν ἐνεκεντρίσθης εἰς καλλιέλαιον, πόσῳ μᾶλλον οὗτοι οἱ κατὰ φύσιν ἐγκεντρισθήσονται τῇ ἰδίᾳ ἐλαίᾳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Οὐ γὰρ θέλω ὑμᾶς ἀγνοεῖν, ἀδελφοί, τὸ μυστήριον τοῦτο, ἵνα μὴ ⸀ἦτεἑαυτοῖς φρόνιμοι, ὅτι πώρωσις ἀπὸ μέρους τῷ Ἰσραὴλ γέγονεν ἄχρι οὗ τὸ πλήρωμα τῶν ἐθνῶν εἰσέλθῃ, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","καὶ οὕτως πᾶς Ἰσραὴλ σωθήσεται· καθὼς γέγραπται· Ἥξει ἐκ Σιὼν ὁ ⸀ῥυόμενος ἀποστρέψει ἀσεβείας ἀπὸ Ἰακώβ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","καὶ αὕτη αὐτοῖς ἡ παρʼ ἐμοῦ διαθήκη, ὅταν ἀφέλωμαι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","κατὰ μὲν τὸ εὐαγγέλιον ἐχθροὶ διʼ ὑμᾶς, κατὰ δὲ τὴν ἐκλογὴν ἀγαπητοὶ διὰ τοὺς πατέρας· ");
INSERT INTO grcsbl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ἀμεταμέλητα γὰρ τὰ χαρίσματα καὶ ἡ κλῆσις τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ὥσπερ ⸀γὰρὑμεῖς ποτε ἠπειθήσατε τῷ θεῷ, νῦν δὲ ἠλεήθητε τῇ τούτων ἀπειθείᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","οὕτως καὶ οὗτοι νῦνἠπείθησαν τῷ ὑμετέρῳ ἐλέει ἵνα καὶ αὐτοὶ ⸀νῦν ἐλεηθῶσιν· ");
INSERT INTO grcsbl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","συνέκλεισεν γὰρ ὁ θεὸς τοὺς πάντας εἰς ἀπείθειαν ἵνα τοὺς πάντας ἐλεήσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ὦ βάθος πλούτου καὶ σοφίας καὶ γνώσεως θεοῦ· ὡς ἀνεξεραύνητα τὰ κρίματα αὐτοῦ καὶ ἀνεξιχνίαστοι αἱ ὁδοὶ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Τίς γὰρ ἔγνω νοῦν κυρίου; ἢ τίς σύμβουλος αὐτοῦ ἐγένετο; ");
INSERT INTO grcsbl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ἢ τίς προέδωκεν αὐτῷ, καὶ ἀνταποδοθήσεται αὐτῷ; ");
INSERT INTO grcsbl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ὅτι ἐξ αὐτοῦ καὶ διʼ αὐτοῦ καὶ εἰς αὐτὸν τὰ πάντα· αὐτῷ ἡ δόξα εἰς τοὺς αἰῶνας, ἀμήν. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Παρακαλῶ οὖν ὑμᾶς, ἀδελφοί, διὰ τῶν οἰκτιρμῶν τοῦ θεοῦ παραστῆσαι τὰ σώματα ὑμῶν θυσίαν ζῶσαν ἁγίαν ⸂εὐάρεστον τῷ θεῷ, τὴν λογικὴν λατρείαν ὑμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","καὶ μὴ ⸀συσχηματίζεσθετῷ αἰῶνι τούτῳ, ἀλλὰ ⸀μεταμορφοῦσθετῇ ἀνακαινώσει τοῦ ⸀νοός εἰς τὸ δοκιμάζειν ὑμᾶς τί τὸ θέλημα τοῦ θεοῦ, τὸ ἀγαθὸν καὶ εὐάρεστον καὶ τέλειον. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Λέγω γὰρ διὰ τῆς χάριτος τῆς δοθείσης μοι παντὶ τῷ ὄντι ἐν ὑμῖν μὴ ὑπερφρονεῖν παρʼ ὃ δεῖ φρονεῖν, ἀλλὰ φρονεῖν εἰς τὸ σωφρονεῖν, ἑκάστῳ ὡς ὁ θεὸς ἐμέρισεν μέτρον πίστεως. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","καθάπερ γὰρ ἐν ἑνὶ σώματι ⸂πολλὰ μέλη ἔχομεν, τὰ δὲ μέλη πάντα οὐ τὴν αὐτὴν ἔχει πρᾶξιν, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","οὕτως οἱ πολλοὶ ἓν σῶμά ἐσμεν ἐν Χριστῷ, ⸀τὸδὲ καθʼ εἷς ἀλλήλων μέλη. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ἔχοντες δὲ χαρίσματα κατὰ τὴν χάριν τὴν δοθεῖσαν ἡμῖν διάφορα, εἴτε προφητείαν κατὰ τὴν ἀναλογίαν τῆς πίστεως, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","εἴτε διακονίαν ἐν τῇ διακονίᾳ, εἴτε ὁ διδάσκων ἐν τῇ διδασκαλίᾳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","εἴτε ὁ παρακαλῶν ἐν τῇ παρακλήσει, ὁ μεταδιδοὺς ἐν ἁπλότητι, ὁ προϊστάμενος ἐν σπουδῇ, ὁ ἐλεῶν ἐν ἱλαρότητι. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ἡ ἀγάπη ἀνυπόκριτος. ἀποστυγοῦντες τὸ πονηρόν, κολλώμενοι τῷ ἀγαθῷ· ");
INSERT INTO grcsbl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","τῇ φιλαδελφίᾳ εἰς ἀλλήλους φιλόστοργοι, τῇ τιμῇ ἀλλήλους προηγούμενοι, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","τῇ σπουδῇ μὴ ὀκνηροί, τῷ πνεύματι ζέοντες, τῷ κυρίῳ δουλεύοντες, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","τῇ ἐλπίδι χαίροντες, τῇ θλίψει ὑπομένοντες, τῇ προσευχῇ προσκαρτεροῦντες, ");
INSERT INTO grcsbl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ταῖς χρείαις τῶν ἁγίων κοινωνοῦντες, τὴν φιλοξενίαν διώκοντες. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","εὐλογεῖτε τοὺς ⸀διώκοντας εὐλογεῖτε καὶ μὴ καταρᾶσθε. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","χαίρειν μετὰ ⸀χαιρόντων κλαίειν μετὰ κλαιόντων. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","τὸ αὐτὸ εἰς ἀλλήλους φρονοῦντες, μὴ τὰ ὑψηλὰ φρονοῦντες ἀλλὰ τοῖς ταπεινοῖς συναπαγόμενοι. μὴ γίνεσθε φρόνιμοι παρʼ ἑαυτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","μηδενὶ κακὸν ἀντὶ κακοῦ ἀποδιδόντες· προνοούμενοι καλὰ ἐνώπιον πάντων ἀνθρώπων· ");
INSERT INTO grcsbl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","εἰ δυνατόν, τὸ ἐξ ὑμῶν μετὰ πάντων ἀνθρώπων εἰρηνεύοντες· ");
INSERT INTO grcsbl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","μὴ ἑαυτοὺς ἐκδικοῦντες, ἀγαπητοί, ἀλλὰ δότε τόπον τῇ ὀργῇ, γέγραπται γάρ· Ἐμοὶ ἐκδίκησις, ἐγὼ ἀνταποδώσω, λέγει κύριος. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","⸂ἀλλὰ ἐὰν πεινᾷ ὁ ἐχθρός σου, ψώμιζε αὐτόν· ἐὰν διψᾷ, πότιζε αὐτόν· τοῦτο γὰρ ποιῶν ἄνθρακας πυρὸς σωρεύσεις ἐπὶ τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","μὴ νικῶ ὑπὸ τοῦ κακοῦ, ἀλλὰ νίκα ἐν τῷ ἀγαθῷ τὸ κακόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Πᾶσα ψυχὴ ἐξουσίαις ὑπερεχούσαις ὑποτασσέσθω, οὐ γὰρ ἔστιν ἐξουσία εἰ μὴ ὑπὸ θεοῦ, αἱ δὲ ⸀οὖσαι⸀ὑπὸθεοῦ τεταγμέναι εἰσίν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ὥστε ὁ ἀντιτασσόμενος τῇ ἐξουσίᾳ τῇ τοῦ θεοῦ διαταγῇ ἀνθέστηκεν, οἱ δὲ ἀνθεστηκότες ἑαυτοῖς κρίμα λήμψονται. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","οἱ γὰρ ἄρχοντες οὐκ εἰσὶν φόβος ⸂τῷ ἀγαθῷ ἔργῳ ἀλλὰ ⸂τῷ κακῷ. θέλεις δὲ μὴ φοβεῖσθαι τὴν ἐξουσίαν; τὸ ἀγαθὸν ποίει, καὶ ἕξεις ἔπαινον ἐξ αὐτῆς· ");
INSERT INTO grcsbl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","θεοῦ γὰρ διάκονός ἐστιν σοὶ εἰς τὸ ἀγαθόν. ἐὰν δὲ τὸ κακὸν ποιῇς, φοβοῦ· οὐ γὰρ εἰκῇ τὴν μάχαιραν φορεῖ· θεοῦ γὰρ διάκονός ἐστιν, ἔκδικος εἰς ὀργὴν τῷ τὸ κακὸν πράσσοντι. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","διὸ ἀνάγκη ὑποτάσσεσθαι, οὐ μόνον διὰ τὴν ὀργὴν ἀλλὰ καὶ διὰ τὴν συνείδησιν, ");
INSERT INTO grcsbl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","διὰ τοῦτο γὰρ καὶ φόρους τελεῖτε, λειτουργοὶ γὰρ θεοῦ εἰσιν εἰς αὐτὸ τοῦτο προσκαρτεροῦντες. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","⸀ἀπόδοτεπᾶσι τὰς ὀφειλάς, τῷ τὸν φόρον τὸν φόρον, τῷ τὸ τέλος τὸ τέλος, τῷ τὸν φόβον τὸν φόβον, τῷ τὴν τιμὴν τὴν τιμήν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Μηδενὶ μηδὲν ὀφείλετε, εἰ μὴ τὸ ⸂ἀλλήλους ἀγαπᾶν· ὁ γὰρ ἀγαπῶν τὸν ἕτερον νόμον πεπλήρωκεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","τὸ γάρ· Οὐ μοιχεύσεις, Οὐ φονεύσεις, Οὐ κλέψεις, Οὐκ ἐπιθυμήσεις, καὶ εἴ τις ἑτέρα ἐντολή, ἐν ⸂τῷ λόγῳ τούτῳ ἀνακεφαλαιοῦται, ⸂ἐν τῷ· Ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ἡ ἀγάπη τῷ πλησίον κακὸν οὐκ ἐργάζεται· πλήρωμα οὖν νόμου ἡ ἀγάπη. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Καὶ τοῦτο εἰδότες τὸν καιρόν, ὅτι ὥρα ⸂ἤδη ὑμᾶς ἐξ ὕπνου ἐγερθῆναι, νῦν γὰρ ἐγγύτερον ἡμῶν ἡ σωτηρία ἢ ὅτε ἐπιστεύσαμεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ἡ νὺξ προέκοψεν, ἡ δὲ ἡμέρα ἤγγικεν. ⸀ἀποβαλώμεθαοὖν τὰ ἔργα τοῦ σκότους, ⸂ἐνδυσώμεθα δὲ τὰ ὅπλα τοῦ φωτός. ");
INSERT INTO grcsbl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ὡς ἐν ἡμέρᾳ εὐσχημόνως περιπατήσωμεν, μὴ κώμοις καὶ μέθαις, μὴ κοίταις καὶ ἀσελγείαις, μὴ ἔριδι καὶ ζήλῳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ἀλλὰ ἐνδύσασθε τὸν κύριον Ἰησοῦν Χριστόν, καὶ τῆς σαρκὸς πρόνοιαν μὴ ποιεῖσθε εἰς ἐπιθυμίας. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Τὸν δὲ ἀσθενοῦντα τῇ πίστει προσλαμβάνεσθε, μὴ εἰς διακρίσεις διαλογισμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ὃς μὲν πιστεύει φαγεῖν πάντα, ὁ δὲ ἀσθενῶν λάχανα ἐσθίει. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ὁ ἐσθίων τὸν μὴ ἐσθίοντα μὴ ἐξουθενείτω, ⸂ὁ δὲ μὴ ἐσθίων τὸν ἐσθίοντα μὴ κρινέτω, ὁ θεὸς γὰρ αὐτὸν προσελάβετο. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","σὺ τίς εἶ ὁ κρίνων ἀλλότριον οἰκέτην; τῷ ἰδίῳ κυρίῳ στήκει ἢ πίπτει· σταθήσεται δέ, ⸂δυνατεῖ γὰρ ὁ ⸀κύριοςστῆσαι αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ὃς ⸀μὲνκρίνει ἡμέραν παρʼ ἡμέραν, ὃς δὲ κρίνει πᾶσαν ἡμέραν· ἕκαστος ἐν τῷ ἰδίῳ νοῒ πληροφορείσθω· ");
INSERT INTO grcsbl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ὁ φρονῶν τὴν ἡμέραν κυρίῳ ⸀φρονεῖ καὶ ὁ ἐσθίων κυρίῳ ἐσθίει, εὐχαριστεῖ γὰρ τῷ θεῷ· καὶ ὁ μὴ ἐσθίων κυρίῳ οὐκ ἐσθίει, καὶ εὐχαριστεῖ τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Οὐδεὶς γὰρ ἡμῶν ἑαυτῷ ζῇ, καὶ οὐδεὶς ἑαυτῷ ἀποθνῄσκει· ");
INSERT INTO grcsbl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ἐάν τε γὰρ ζῶμεν, τῷ κυρίῳ ζῶμεν, ἐάν τε ἀποθνῄσκωμεν, τῷ κυρίῳ ἀποθνῄσκομεν. ἐάν τε οὖν ζῶμεν ἐάν τε ἀποθνῄσκωμεν, τοῦ κυρίου ἐσμέν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","εἰς τοῦτο γὰρ ⸀Χριστὸς⸀ἀπέθανενκαὶ ἔζησεν ἵνα καὶ νεκρῶν καὶ ζώντων κυριεύσῃ. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Σὺ δὲ τί κρίνεις τὸν ἀδελφόν σου; ἢ καὶ σὺ τί ἐξουθενεῖς τὸν ἀδελφόν σου; πάντες γὰρ παραστησόμεθα τῷ βήματι τοῦ ⸀θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","γέγραπται γάρ· Ζῶ ἐγώ, λέγει κύριος, ὅτι ἐμοὶ κάμψει πᾶν γόνυ, καὶ ⸂πᾶσα γλῶσσα ἐξομολογήσεται τῷ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","⸀ἄραἕκαστος ἡμῶν περὶ ἑαυτοῦ λόγον ⸀δώσει ");
INSERT INTO grcsbl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Μηκέτι οὖν ἀλλήλους κρίνωμεν· ἀλλὰ τοῦτο κρίνατε μᾶλλον, τὸ μὴ τιθέναι πρόσκομμα τῷ ἀδελφῷ ἢ σκάνδαλον. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","οἶδα καὶ πέπεισμαι ἐν κυρίῳ Ἰησοῦ ὅτι οὐδὲν κοινὸν διʼ ⸀ἑαυτοῦ εἰ μὴ τῷ λογιζομένῳ τι κοινὸν εἶναι, ἐκείνῳ κοινόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","εἰ ⸀γὰρδιὰ βρῶμα ὁ ἀδελφός σου λυπεῖται, οὐκέτι κατὰ ἀγάπην περιπατεῖς. μὴ τῷ βρώματί σου ἐκεῖνον ἀπόλλυε ὑπὲρ οὗ Χριστὸς ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","μὴ βλασφημείσθω οὖν ὑμῶν τὸ ἀγαθόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","οὐ γάρ ἐστιν ἡ βασιλεία τοῦ θεοῦ βρῶσις καὶ πόσις, ἀλλὰ δικαιοσύνη καὶ εἰρήνη καὶ χαρὰ ἐν πνεύματι ἁγίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ὁ γὰρ ἐν ⸀τούτῳδουλεύων τῷ Χριστῷ εὐάρεστος τῷ θεῷ καὶ δόκιμος τοῖς ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ἄρα οὖν τὰ τῆς εἰρήνης διώκωμεν καὶ τὰ τῆς οἰκοδομῆς τῆς εἰς ἀλλήλους. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","μὴ ἕνεκεν βρώματος κατάλυε τὸ ἔργον τοῦ θεοῦ. πάντα μὲν καθαρά, ἀλλὰ κακὸν τῷ ἀνθρώπῳ τῷ διὰ προσκόμματος ἐσθίοντι. ");
INSERT INTO grcsbl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","καλὸν τὸ μὴ φαγεῖν κρέα μηδὲ πιεῖν οἶνον μηδὲ ἐν ᾧ ὁ ἀδελφός σου προσκόπτει ⸂ἢ σκανδαλίζεται ἢ ἀσθενεῖ· ");
INSERT INTO grcsbl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","σὺ πίστιν ⸀ἣνἔχεις κατὰ σεαυτὸν ἔχε ἐνώπιον τοῦ θεοῦ. μακάριος ὁ μὴ κρίνων ἑαυτὸν ἐν ᾧ δοκιμάζει· ");
INSERT INTO grcsbl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ὁ δὲ διακρινόμενος ἐὰν φάγῃ κατακέκριται, ὅτι οὐκ ἐκ πίστεως· πᾶν δὲ ὃ οὐκ ἐκ πίστεως ἁμαρτία ⸀ἐστίν ");
INSERT INTO grcsbl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Ὀφείλομεν δὲ ἡμεῖς οἱ δυνατοὶ τὰ ἀσθενήματα τῶν ἀδυνάτων βαστάζειν, καὶ μὴ ἑαυτοῖς ἀρέσκειν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ἕκαστος ἡμῶν τῷ πλησίον ἀρεσκέτω εἰς τὸ ἀγαθὸν πρὸς οἰκοδομήν· ");
INSERT INTO grcsbl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","καὶ γὰρ ὁ Χριστὸς οὐχ ἑαυτῷ ἤρεσεν· ἀλλὰ καθὼς γέγραπται· Οἱ ὀνειδισμοὶ τῶν ὀνειδιζόντων σε ἐπέπεσαν ἐπʼ ἐμέ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ὅσα γὰρ προεγράφη, ⸀εἰςτὴν ἡμετέραν διδασκαλίαν ⸀ἐγράφη ἵνα διὰ τῆς ὑπομονῆς καὶ διὰ τῆς παρακλήσεως τῶν γραφῶν τὴν ἐλπίδα ἔχωμεν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ὁ δὲ θεὸς τῆς ὑπομονῆς καὶ τῆς παρακλήσεως δῴη ὑμῖν τὸ αὐτὸ φρονεῖν ἐν ἀλλήλοις κατὰ ⸂Χριστὸν Ἰησοῦν, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ἵνα ὁμοθυμαδὸν ἐν ἑνὶ στόματι δοξάζητε τὸν θεὸν καὶ πατέρα τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Διὸ προσλαμβάνεσθε ἀλλήλους, καθὼς καὶ ὁ Χριστὸς προσελάβετο ⸀ὑμᾶς εἰς δόξαν ⸀τοῦθεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","λέγω ⸀γὰρ⸀Χριστὸνδιάκονον ⸀γεγενῆσθαιπεριτομῆς ὑπὲρ ἀληθείας θεοῦ, εἰς τὸ βεβαιῶσαι τὰς ἐπαγγελίας τῶν πατέρων, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","τὰ δὲ ἔθνη ὑπὲρ ἐλέους δοξάσαι τὸν θεόν· καθὼς γέγραπται· Διὰ τοῦτο ἐξομολογήσομαί σοι ἐν ἔθνεσι, καὶ τῷ ὀνόματί σου ψαλῶ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","καὶ πάλιν λέγει· Εὐφράνθητε, ἔθνη, μετὰ τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","καὶ πάλιν· Αἰνεῖτε, ⸂πάντα τὰ ἔθνη, τὸν κύριον⸃, καὶ ⸀ἐπαινεσάτωσαν αὐτὸν πάντες οἱ λαοί. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","καὶ πάλιν Ἠσαΐας λέγει· Ἔσται ἡ ῥίζα τοῦ Ἰεσσαί, καὶ ὁ ἀνιστάμενος ἄρχειν ἐθνῶν· ἐπʼ αὐτῷ ἔθνη ἐλπιοῦσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ὁ δὲ θεὸς τῆς ἐλπίδος πληρώσαι ὑμᾶς πάσης χαρᾶς καὶ εἰρήνης ἐν τῷ πιστεύειν, εἰς τὸ περισσεύειν ὑμᾶς ἐν τῇ ἐλπίδι ἐν δυνάμει πνεύματος ἁγίου. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Πέπεισμαι δέ, ἀδελφοί μου, καὶ αὐτὸς ἐγὼ περὶ ὑμῶν, ὅτι καὶ αὐτοὶ μεστοί ἐστε ἀγαθωσύνης, πεπληρωμένοι ⸀πάσηςγνώσεως, δυνάμενοι καὶ ⸀ἀλλήλουςνουθετεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","⸀τολμηρότερονδὲ ἔγραψα ⸀ὑμῖνἀπὸ μέρους, ὡς ἐπαναμιμνῄσκων ὑμᾶς, διὰ τὴν χάριν τὴν δοθεῖσάν μοι ⸀ὑπὸτοῦ θεοῦ ");
INSERT INTO grcsbl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","εἰς τὸ εἶναί με λειτουργὸν ⸂Χριστοῦ Ἰησοῦ εἰς τὰ ἔθνη, ἱερουργοῦντα τὸ εὐαγγέλιον τοῦ θεοῦ, ἵνα γένηται ἡ προσφορὰ τῶν ἐθνῶν εὐπρόσδεκτος, ἡγιασμένη ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ἔχω οὖν ⸀τὴνκαύχησιν ἐν Χριστῷ Ἰησοῦ τὰ πρὸς τὸν θεόν· ");
INSERT INTO grcsbl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","οὐ γὰρ τολμήσω ⸂τι λαλεῖν ὧν οὐ κατειργάσατο Χριστὸς διʼ ἐμοῦ εἰς ὑπακοὴν ἐθνῶν, λόγῳ καὶ ἔργῳ, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ἐν δυνάμει σημείων καὶ τεράτων, ἐν δυνάμει ⸀πνεύματος ὥστε με ἀπὸ Ἰερουσαλὴμ καὶ κύκλῳ μέχρι τοῦ Ἰλλυρικοῦ πεπληρωκέναι τὸ εὐαγγέλιον τοῦ Χριστοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","οὕτως δὲ ⸀φιλοτιμούμενονεὐαγγελίζεσθαι οὐχ ὅπου ὠνομάσθη Χριστός, ἵνα μὴ ἐπʼ ἀλλότριον θεμέλιον οἰκοδομῶ, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ἀλλὰ καθὼς γέγραπται· ⸂Οἷς οὐκ ἀνηγγέλη περὶ αὐτοῦ ὄψονται, καὶ οἳ οὐκ ἀκηκόασιν συνήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Διὸ καὶ ἐνεκοπτόμην τὰ πολλὰ τοῦ ἐλθεῖν πρὸς ὑμᾶς· ");
INSERT INTO grcsbl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","νυνὶ δὲ μηκέτι τόπον ἔχων ἐν τοῖς κλίμασι τούτοις, ἐπιποθίαν δὲ ἔχων τοῦ ἐλθεῖν πρὸς ὑμᾶς ἀπὸ ⸀ἱκανῶνἐτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ὡς ⸀ἂνπορεύωμαι εἰς τὴν ⸀Σπανίαν ἐλπίζω γὰρ διαπορευόμενος θεάσασθαι ὑμᾶς καὶ ὑφʼ ὑμῶν προπεμφθῆναι ἐκεῖ ἐὰν ὑμῶν πρῶτον ἀπὸ μέρους ἐμπλησθῶ— ");
INSERT INTO grcsbl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","νυνὶ δὲ πορεύομαι εἰς Ἰερουσαλὴμ διακονῶν τοῖς ἁγίοις. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","εὐδόκησαν γὰρ Μακεδονία καὶ Ἀχαΐα κοινωνίαν τινὰ ποιήσασθαι εἰς τοὺς πτωχοὺς τῶν ἁγίων τῶν ἐν Ἰερουσαλήμ. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","εὐδόκησαν γάρ, καὶ ὀφειλέται ⸂εἰσὶν αὐτῶν· εἰ γὰρ τοῖς πνευματικοῖς αὐτῶν ἐκοινώνησαν τὰ ἔθνη, ὀφείλουσιν καὶ ἐν τοῖς σαρκικοῖς λειτουργῆσαι αὐτοῖς. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","τοῦτο οὖν ἐπιτελέσας, καὶ σφραγισάμενος αὐτοῖς τὸν καρπὸν τοῦτον, ἀπελεύσομαι διʼ ὑμῶν ⸀εἰςΣπανίαν· ");
INSERT INTO grcsbl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","οἶδα δὲ ὅτι ἐρχόμενος πρὸς ὑμᾶς ἐν πληρώματι ⸀εὐλογίαςΧριστοῦ ἐλεύσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, διὰ τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ καὶ διὰ τῆς ἀγάπης τοῦ πνεύματος συναγωνίσασθαί μοι ἐν ταῖς προσευχαῖς ὑπὲρ ἐμοῦ πρὸς τὸν θεόν, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ἵνα ῥυσθῶ ἀπὸ τῶν ἀπειθούντων ἐν τῇ Ἰουδαίᾳ ⸀καὶἡ διακονία μου ἡ εἰς Ἰερουσαλὴμ εὐπρόσδεκτος ⸂τοῖς ἁγίοις γένηται, ");
INSERT INTO grcsbl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ἵνα ἐν χαρᾷ ⸀ἐλθὼνπρὸς ὑμᾶς διὰ θελήματος ⸀θεοῦσυναναπαύσωμαι ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ὁ δὲ θεὸς τῆς εἰρήνης μετὰ πάντων ὑμῶν· ἀμήν. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Συνίστημι δὲ ὑμῖν Φοίβην τὴν ἀδελφὴν ἡμῶν, οὖσαν ⸀καὶδιάκονον τῆς ἐκκλησίας τῆς ἐν Κεγχρεαῖς, ");
INSERT INTO grcsbl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ἵνα ⸂αὐτὴν προσδέξησθε ἐν κυρίῳ ἀξίως τῶν ἁγίων, καὶ παραστῆτε αὐτῇ ἐν ᾧ ἂν ὑμῶν χρῄζῃ πράγματι, καὶ γὰρ αὐτὴ προστάτις πολλῶν ἐγενήθη καὶ ⸂ἐμοῦ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ἀσπάσασθε Πρίσκαν καὶ Ἀκύλαν τοὺς συνεργούς μου ἐν Χριστῷ Ἰησοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","οἵτινες ὑπὲρ τῆς ψυχῆς μου τὸν ἑαυτῶν τράχηλον ὑπέθηκαν, οἷς οὐκ ἐγὼ μόνος εὐχαριστῶ ἀλλὰ καὶ πᾶσαι αἱ ἐκκλησίαι τῶν ἐθνῶν, ");
INSERT INTO grcsbl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","καὶ τὴν κατʼ οἶκον αὐτῶν ἐκκλησίαν. ἀσπάσασθε Ἐπαίνετον τὸν ἀγαπητόν μου, ὅς ἐστιν ἀπαρχὴ τῆς ⸀Ἀσίαςεἰς Χριστόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ἀσπάσασθε ⸀Μαριάμ ἥτις πολλὰ ἐκοπίασεν εἰς ⸀ὑμᾶς ");
INSERT INTO grcsbl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ἀσπάσασθε Ἀνδρόνικον καὶ ⸀Ἰουνίαντοὺς συγγενεῖς μου καὶ συναιχμαλώτους μου, οἵτινές εἰσιν ἐπίσημοι ἐν τοῖς ἀποστόλοις, οἳ καὶ πρὸ ἐμοῦ ⸀γέγονανἐν Χριστῷ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ἀσπάσασθε ⸀Ἀμπλιᾶτοντὸν ἀγαπητόν μου ἐν κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ἀσπάσασθε Οὐρβανὸν τὸν συνεργὸν ἡμῶν ἐν Χριστῷ καὶ Στάχυν τὸν ἀγαπητόν μου. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ἀσπάσασθε Ἀπελλῆν τὸν δόκιμον ἐν Χριστῷ. ἀσπάσασθε τοὺς ἐκ τῶν Ἀριστοβούλου. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ἀσπάσασθε Ἡρῳδίωνα τὸν ⸀συγγενῆμου. ἀσπάσασθε τοὺς ἐκ τῶν Ναρκίσσου τοὺς ὄντας ἐν κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ἀσπάσασθε Τρύφαιναν καὶ Τρυφῶσαν τὰς κοπιώσας ἐν κυρίῳ. ἀσπάσασθε Περσίδα τὴν ἀγαπητήν, ἥτις πολλὰ ἐκοπίασεν ἐν κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ἀσπάσασθε Ῥοῦφον τὸν ἐκλεκτὸν ἐν κυρίῳ καὶ τὴν μητέρα αὐτοῦ καὶ ἐμοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ἀσπάσασθε Ἀσύγκριτον, Φλέγοντα, ⸂Ἑρμῆν, Πατροβᾶν, Ἑρμᾶν⸃ καὶ τοὺς σὺν αὐτοῖς ἀδελφούς. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ἀσπάσασθε Φιλόλογον καὶ Ἰουλίαν, Νηρέα καὶ τὴν ἀδελφὴν αὐτοῦ, καὶ Ὀλυμπᾶν καὶ τοὺς σὺν αὐτοῖς πάντας ἁγίους. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ἀσπάσασθε ἀλλήλους ἐν φιλήματι ἁγίῳ. Ἀσπάζονται ὑμᾶς αἱ ἐκκλησίαι ⸀πᾶσαιτοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, σκοπεῖν τοὺς τὰς διχοστασίας καὶ τὰ σκάνδαλα παρὰ τὴν διδαχὴν ἣν ὑμεῖς ἐμάθετε ποιοῦντας, καὶ ⸀ἐκκλίνετεἀπʼ αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","οἱ γὰρ τοιοῦτοι τῷ κυρίῳ ⸀ἡμῶνΧριστῷ οὐ δουλεύουσιν ἀλλὰ τῇ ἑαυτῶν κοιλίᾳ, καὶ διὰ τῆς χρηστολογίας καὶ εὐλογίας ἐξαπατῶσι τὰς καρδίας τῶν ἀκάκων. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ἡ γὰρ ὑμῶν ὑπακοὴ εἰς πάντας ἀφίκετο· ⸂ἐφʼ ὑμῖν οὖν χαίρω, θέλω δὲ ὑμᾶς ⸀σοφοὺςεἶναι εἰς τὸ ἀγαθόν, ἀκεραίους δὲ εἰς τὸ κακόν. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ὁ δὲ θεὸς τῆς εἰρήνης συντρίψει τὸν Σατανᾶν ὑπὸ τοὺς πόδας ὑμῶν ἐν τάχει. ἡ χάρις τοῦ κυρίου ἡμῶν Ἰησοῦ ⸀Χριστοῦμεθʼ ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","⸀Ἀσπάζεταιὑμᾶς Τιμόθεος ὁ συνεργός μου, καὶ Λούκιος καὶ Ἰάσων καὶ Σωσίπατρος οἱ συγγενεῖς μου. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ἀσπάζομαι ὑμᾶς ἐγὼ Τέρτιος ὁ γράψας τὴν ἐπιστολὴν ἐν κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ἀσπάζεται ὑμᾶς Γάϊος ὁ ξένος μου καὶ ⸂ὅλης τῆς ἐκκλησίας. ἀσπάζεται ὑμᾶς Ἔραστος ὁ οἰκονόμος τῆς πόλεως καὶ Κούαρτος ὁ ἀδελφός. ");
INSERT INTO grcsbl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","⸂Ἡ χάρις τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ μετὰ πάντων ὑμῶν⸃ ⸀Ἀμήν ‘p /’ ‘/book’ ");
INSERT INTO grcsbl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Παῦλος κλητὸς ἀπόστολος ⸂Χριστοῦ Ἰησοῦ διὰ θελήματος θεοῦ καὶ Σωσθένης ὁ ἀδελφὸς ");
INSERT INTO grcsbl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","τῇ ἐκκλησίᾳ τοῦ θεοῦ, ⸂ἡγιασμένοις ἐν Χριστῷ Ἰησοῦ, τῇ οὔσῃ ἐν Κορίνθῳ,⸃ κλητοῖς ἁγίοις, σὺν πᾶσιν τοῖς ἐπικαλουμένοις τὸ ὄνομα τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ ἐν παντὶ τόπῳ ⸀αὐτῶν καὶ ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","χάρις ὑμῖν καὶ εἰρήνη ἀπὸ θεοῦ πατρὸς ἡμῶν καὶ κυρίου Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Εὐχαριστῶ τῷ θεῷ ⸀μουπάντοτε περὶ ὑμῶν ἐπὶ τῇ χάριτι τοῦ θεοῦ τῇ δοθείσῃ ὑμῖν ἐν Χριστῷ Ἰησοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ὅτι ἐν παντὶ ἐπλουτίσθητε ἐν αὐτῷ, ἐν παντὶ λόγῳ καὶ πάσῃ γνώσει, ");
INSERT INTO grcsbl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","καθὼς τὸ μαρτύριον τοῦ Χριστοῦ ἐβεβαιώθη ἐν ὑμῖν, ");
INSERT INTO grcsbl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ὥστε ὑμᾶς μὴ ὑστερεῖσθαι ἐν μηδενὶ χαρίσματι, ἀπεκδεχομένους τὴν ἀποκάλυψιν τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ὃς καὶ βεβαιώσει ὑμᾶς ἕως τέλους ἀνεγκλήτους ἐν τῇ ἡμέρᾳ τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","πιστὸς ὁ θεὸς διʼ οὗ ἐκλήθητε εἰς κοινωνίαν τοῦ υἱοῦ αὐτοῦ Ἰησοῦ Χριστοῦ τοῦ κυρίου ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Παρακαλῶ δὲ ὑμᾶς, ἀδελφοί, διὰ τοῦ ὀνόματος τοῦ κυρίου ἡμῶν Ἰησοῦ Χριστοῦ ἵνα τὸ αὐτὸ λέγητε πάντες, καὶ μὴ ᾖ ἐν ὑμῖν σχίσματα, ἦτε δὲ κατηρτισμένοι ἐν τῷ αὐτῷ νοῒ καὶ ἐν τῇ αὐτῇ γνώμῃ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ἐδηλώθη γάρ μοι περὶ ὑμῶν, ἀδελφοί μου, ὑπὸ τῶν Χλόης ὅτι ἔριδες ἐν ὑμῖν εἰσιν. ");
INSERT INTO grcsbl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","λέγω δὲ τοῦτο ὅτι ἕκαστος ὑμῶν λέγει· Ἐγὼ μέν εἰμι Παύλου, Ἐγὼ δὲ Ἀπολλῶ, Ἐγὼ δὲ Κηφᾶ, Ἐγὼ δὲ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","μεμέρισται ὁ Χριστός; μὴ Παῦλος ἐσταυρώθη ὑπὲρ ὑμῶν, ἢ εἰς τὸ ὄνομα Παύλου ἐβαπτίσθητε; ");
INSERT INTO grcsbl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","⸀εὐχαριστῶὅτι οὐδένα ὑμῶν ἐβάπτισα εἰ μὴ Κρίσπον καὶ Γάϊον, ");
INSERT INTO grcsbl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ἵνα μή τις εἴπῃ ὅτι εἰς τὸ ἐμὸν ὄνομα ⸀ἐβαπτίσθητε ");
INSERT INTO grcsbl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ἐβάπτισα δὲ καὶ τὸν Στεφανᾶ οἶκον· λοιπὸν οὐκ οἶδα εἴ τινα ἄλλον ἐβάπτισα. ");
INSERT INTO grcsbl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","οὐ γὰρ ἀπέστειλέν με Χριστὸς βαπτίζειν ἀλλὰ εὐαγγελίζεσθαι, οὐκ ἐν σοφίᾳ λόγου, ἵνα μὴ κενωθῇ ὁ σταυρὸς τοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ὁ λόγος γὰρ ὁ τοῦ σταυροῦ τοῖς μὲν ἀπολλυμένοις μωρία ἐστίν, τοῖς δὲ σῳζομένοις ἡμῖν δύναμις θεοῦ ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","γέγραπται γάρ· Ἀπολῶ τὴν σοφίαν τῶν σοφῶν, καὶ τὴν σύνεσιν τῶν συνετῶν ἀθετήσω. ");
INSERT INTO grcsbl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ποῦ σοφός; ποῦ γραμματεύς; ποῦ συζητητὴς τοῦ αἰῶνος τούτου; οὐχὶ ἐμώρανεν ὁ θεὸς τὴν σοφίαν τοῦ ⸀κόσμου ");
INSERT INTO grcsbl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ἐπειδὴ γὰρ ἐν τῇ σοφίᾳ τοῦ θεοῦ οὐκ ἔγνω ὁ κόσμος διὰ τῆς σοφίας τὸν θεόν, εὐδόκησεν ὁ θεὸς διὰ τῆς μωρίας τοῦ κηρύγματος σῶσαι τοὺς πιστεύοντας. ");
INSERT INTO grcsbl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ἐπειδὴ καὶ Ἰουδαῖοι ⸀σημεῖααἰτοῦσιν καὶ Ἕλληνες σοφίαν ζητοῦσιν· ");
INSERT INTO grcsbl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ἡμεῖς δὲ κηρύσσομεν Χριστὸν ἐσταυρωμένον, Ἰουδαίοις μὲν σκάνδαλον ⸀ἔθνεσινδὲ μωρίαν, ");
INSERT INTO grcsbl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","αὐτοῖς δὲ τοῖς κλητοῖς, Ἰουδαίοις τε καὶ Ἕλλησιν, Χριστὸν θεοῦ δύναμιν καὶ θεοῦ σοφίαν. ");
INSERT INTO grcsbl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ὅτι τὸ μωρὸν τοῦ θεοῦ σοφώτερον τῶν ἀνθρώπωνἐστίν, καὶ τὸ ἀσθενὲς τοῦ θεοῦ ἰσχυρότερον τῶν ⸀ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Βλέπετε γὰρ τὴν κλῆσιν ὑμῶν, ἀδελφοί, ὅτι οὐ πολλοὶ σοφοὶ κατὰ σάρκα, οὐ πολλοὶ δυνατοί, οὐ πολλοὶ εὐγενεῖς· ");
INSERT INTO grcsbl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ἀλλὰ τὰ μωρὰ τοῦ κόσμου ἐξελέξατο ὁ θεός, ἵνα ⸂καταισχύνῃ τοὺς σοφούς, καὶ τὰ ἀσθενῆ τοῦ κόσμου ἐξελέξατο ὁ θεός, ἵνα καταισχύνῃ τὰ ἰσχυρά, ");
INSERT INTO grcsbl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","καὶ τὰἀγενῆ τοῦ κόσμου καὶ τὰ ἐξουθενημένα ἐξελέξατο ὁ θεός, ⸀τὰ μὴ ὄντα, ἵνα τὰ ὄντα καταργήσῃ, ");
INSERT INTO grcsbl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ὅπως μὴ καυχήσηται πᾶσα σὰρξ ἐνώπιον τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ἐξ αὐτοῦ δὲ ὑμεῖς ἐστε ἐν Χριστῷ Ἰησοῦ, ὃς ἐγενήθη ⸂σοφία ἡμῖν ἀπὸ θεοῦ, δικαιοσύνη τε καὶ ἁγιασμὸς καὶ ἀπολύτρωσις, ");
INSERT INTO grcsbl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ἵνα καθὼς γέγραπται· Ὁ καυχώμενος ἐν κυρίῳ καυχάσθω. ");
INSERT INTO grcsbl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Κἀγὼ ἐλθὼν πρὸς ὑμᾶς, ἀδελφοί, ἦλθον οὐ καθʼ ὑπεροχὴν λόγου ἢ σοφίας καταγγέλλων ὑμῖν τὸ ⸀μαρτύριοντοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","οὐ γὰρ ἔκρινά ⸂τι εἰδέναι ἐν ὑμῖν εἰ μὴ Ἰησοῦν Χριστὸν καὶ τοῦτον ἐσταυρωμένον· ");
INSERT INTO grcsbl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","κἀγὼ ἐν ἀσθενείᾳ καὶ ἐν φόβῳ καὶ ἐν τρόμῳ πολλῷ ἐγενόμην πρὸς ὑμᾶς, ");
INSERT INTO grcsbl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","καὶ ὁ λόγος μου καὶ τὸ κήρυγμά μου οὐκ ἐν ⸂πειθοῖ σοφίας ἀλλʼ ἐν ἀποδείξει πνεύματος καὶ δυνάμεως, ");
INSERT INTO grcsbl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ἵνα ἡ πίστις ὑμῶν μὴ ᾖ ἐν σοφίᾳ ἀνθρώπων ἀλλʼ ἐν δυνάμει θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Σοφίαν δὲ λαλοῦμεν ἐν τοῖς τελείοις, σοφίαν δὲ οὐ τοῦ αἰῶνος τούτου οὐδὲ τῶν ἀρχόντων τοῦ αἰῶνος τούτου τῶν καταργουμένων· ");
INSERT INTO grcsbl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ἀλλὰ λαλοῦμεν ⸂θεοῦ σοφίαν ἐν μυστηρίῳ, τὴν ἀποκεκρυμμένην, ἣν προώρισεν ὁ θεὸς πρὸ τῶν αἰώνων εἰς δόξαν ἡμῶν· ");
INSERT INTO grcsbl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ἣν οὐδεὶς τῶν ἀρχόντων τοῦ αἰῶνος τούτου ἔγνωκεν, εἰ γὰρ ἔγνωσαν, οὐκ ἂν τὸν κύριον τῆς δόξης ἐσταύρωσαν· ");
INSERT INTO grcsbl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ἀλλὰ καθὼς γέγραπται· Ἃ ὀφθαλμὸς οὐκ εἶδεν καὶ οὖς οὐκ ἤκουσεν καὶ ἐπὶ καρδίαν ἀνθρώπου οὐκ ἀνέβη, ⸀ὅσαἡτοίμασεν ὁ θεὸς τοῖς ἀγαπῶσιν αὐτόν. ");
INSERT INTO grcsbl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ἡμῖν ⸀γὰρ⸂ἀπεκάλυψεν ὁ θεὸς διὰ τοῦ ⸀πνεύματος τὸ γὰρ πνεῦμα πάντα ἐραυνᾷ, καὶ τὰ βάθη τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","τίς γὰρ οἶδεν ἀνθρώπων τὰ τοῦ ἀνθρώπου εἰ μὴ τὸ πνεῦμα τοῦ ἀνθρώπου τὸ ἐν αὐτῷ; οὕτως καὶ τὰ τοῦ θεοῦ οὐδεὶς ⸀ἔγνωκενεἰ μὴ τὸ πνεῦμα τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ἡμεῖς δὲ οὐ τὸ πνεῦμα τοῦ κόσμου ἐλάβομεν ἀλλὰ τὸ πνεῦμα τὸ ἐκ τοῦ θεοῦ, ἵνα εἰδῶμεν τὰ ὑπὸ τοῦ θεοῦ χαρισθέντα ἡμῖν· ");
INSERT INTO grcsbl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ἃ καὶ λαλοῦμεν οὐκ ἐν διδακτοῖς ἀνθρωπίνης σοφίας λόγοις, ἀλλʼ ἐν διδακτοῖς ⸀πνεύματος πνευματικοῖς πνευματικὰ συγκρίνοντες. ");
INSERT INTO grcsbl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ψυχικὸς δὲ ἄνθρωπος οὐ δέχεται τὰ τοῦ πνεύματος τοῦ θεοῦ, μωρία γὰρ αὐτῷ ἐστίν, καὶ οὐ δύναται γνῶναι, ὅτι πνευματικῶς ἀνακρίνεται· ");
INSERT INTO grcsbl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ὁ δὲ πνευματικὸς ἀνακρίνει ⸀τὰπάντα, αὐτὸς δὲ ὑπʼ οὐδενὸς ἀνακρίνεται. ");
INSERT INTO grcsbl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","τίς γὰρ ἔγνω νοῦν κυρίου, ὃς συμβιβάσει αὐτόν; ἡμεῖς δὲ νοῦν Χριστοῦ ἔχομεν. ");
INSERT INTO grcsbl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Κἀγώ, ἀδελφοί, οὐκ ἠδυνήθην ⸂λαλῆσαι ὑμῖν ὡς πνευματικοῖς ἀλλʼ ὡς ⸀σαρκίνοις ὡς νηπίοις ἐν Χριστῷ. ");
INSERT INTO grcsbl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","γάλα ὑμᾶς ἐπότισα, ⸀οὐβρῶμα, οὔπω γὰρ ἐδύνασθε. ἀλλʼ ⸀οὐδὲἔτι νῦν δύνασθε, ");
INSERT INTO grcsbl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ἔτι γὰρ σαρκικοί ἐστε. ὅπου γὰρ ἐν ὑμῖν ζῆλος καὶ ⸀ἔρις οὐχὶ σαρκικοί ἐστε καὶ κατὰ ἄνθρωπον περιπατεῖτε; ");
INSERT INTO grcsbl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ὅταν γὰρ λέγῃ τις· Ἐγὼ μέν εἰμι Παύλου, ἕτερος δέ· Ἐγὼ Ἀπολλῶ, ⸂οὐκ ἄνθρωποί ἐστε; ");
INSERT INTO grcsbl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","⸀Τίοὖν ἐστιν ⸂Ἀπολλῶς; τί δέ ἐστιν Παῦλος⸃; ⸀διάκονοι διʼ ὧν ἐπιστεύσατε, καὶ ἑκάστῳ ὡς ὁ κύριος ἔδωκεν. ");
INSERT INTO grcsbl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ἐγὼ ἐφύτευσα, Ἀπολλῶς ἐπότισεν, ἀλλὰ ὁ θεὸς ηὔξανεν· ");
INSERT INTO grcsbl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ὥστε οὔτε ὁ φυτεύων ἐστίν τι οὔτε ὁ ποτίζων, ἀλλʼ ὁ αὐξάνων θεός. ");
INSERT INTO grcsbl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ὁ φυτεύων δὲ καὶ ὁ ποτίζων ἕν εἰσιν, ἕκαστος δὲ τὸν ἴδιον μισθὸν λήμψεται κατὰ τὸν ἴδιον κόπον, ");
INSERT INTO grcsbl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","θεοῦ γάρ ἐσμεν συνεργοί· θεοῦ γεώργιον, θεοῦ οἰκοδομή ἐστε. ");
INSERT INTO grcsbl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Κατὰ τὴν χάριν τοῦ θεοῦ τὴν δοθεῖσάν μοι ὡς σοφὸς ἀρχιτέκτων θεμέλιον ⸀ἔθηκα ἄλλος δὲ ἐποικοδομεῖ. ἕκαστος δὲ βλεπέτω πῶς ἐποικοδομεῖ· ");
INSERT INTO grcsbl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","θεμέλιον γὰρ ἄλλον οὐδεὶς δύναται θεῖναι παρὰ τὸν κείμενον, ὅς ἐστιν Ἰησοῦς Χριστός· ");
INSERT INTO grcsbl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","εἰ δέ τις ἐποικοδομεῖ ἐπὶ τὸν ⸀θεμέλιον⸂χρυσόν, ἄργυρον⸃, λίθους τιμίους, ξύλα, χόρτον, καλάμην, ");
INSERT INTO grcsbl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ἑκάστου τὸ ἔργον φανερὸν γενήσεται, ἡ γὰρ ἡμέρα δηλώσει· ὅτι ἐν πυρὶ ἀποκαλύπτεται, καὶ ἑκάστου τὸ ἔργον ὁποῖόν ἐστιν τὸ πῦρ ⸀αὐτὸδοκιμάσει. ");
INSERT INTO grcsbl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","εἴ τινος τὸ ἔργον μενεῖ ὃ ἐποικοδόμησεν, μισθὸν λήμψεται· ");
INSERT INTO grcsbl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","εἴ τινος τὸ ἔργον κατακαήσεται, ζημιωθήσεται, αὐτὸς δὲ σωθήσεται, οὕτως δὲ ὡς διὰ πυρός. ");
INSERT INTO grcsbl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Οὐκ οἴδατε ὅτι ναὸς θεοῦ ἐστε καὶ τὸ πνεῦμα τοῦ θεοῦ ⸂οἰκεῖ ἐν ὑμῖν; ");
INSERT INTO grcsbl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","εἴ τις τὸν ναὸν τοῦ θεοῦ φθείρει, φθερεῖ τοῦτον ὁ θεός· ὁ γὰρ ναὸς τοῦ θεοῦ ἅγιός ἐστιν, οἵτινές ἐστε ὑμεῖς. ");
INSERT INTO grcsbl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Μηδεὶς ἑαυτὸν ἐξαπατάτω· εἴ τις δοκεῖ σοφὸς εἶναι ἐν ὑμῖν ἐν τῷ αἰῶνι τούτῳ, μωρὸς γενέσθω, ἵνα γένηται σοφός, ");
INSERT INTO grcsbl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ἡ γὰρ σοφία τοῦ κόσμου τούτου μωρία παρὰ τῷ θεῷ ἐστιν· γέγραπται γάρ· Ὁ δρασσόμενος τοὺς σοφοὺς ἐν τῇ πανουργίᾳ αὐτῶν· ");
INSERT INTO grcsbl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","καὶ πάλιν· Κύριος γινώσκει τοὺς διαλογισμοὺς τῶν σοφῶν ὅτι εἰσὶν μάταιοι. ");
INSERT INTO grcsbl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ὥστε μηδεὶς καυχάσθω ἐν ἀνθρώποις· πάντα γὰρ ὑμῶν ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","εἴτε Παῦλος εἴτε Ἀπολλῶς εἴτε Κηφᾶς εἴτε κόσμος εἴτε ζωὴ εἴτε θάνατος εἴτε ἐνεστῶτα εἴτε μέλλοντα, πάντα ⸀ὑμῶν ");
INSERT INTO grcsbl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ὑμεῖς δὲ Χριστοῦ, Χριστὸς δὲ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Οὕτως ἡμᾶς λογιζέσθω ἄνθρωπος ὡς ὑπηρέτας Χριστοῦ καὶ οἰκονόμους μυστηρίων θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","⸀ὧδελοιπὸν ζητεῖται ἐν τοῖς οἰκονόμοις ἵνα πιστός τις εὑρεθῇ. ");
INSERT INTO grcsbl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ἐμοὶ δὲ εἰς ἐλάχιστόν ἐστιν, ἵνα ὑφʼ ὑμῶν ἀνακριθῶ ἢ ὑπὸ ἀνθρωπίνης ἡμέρας· ἀλλʼ οὐδὲ ἐμαυτὸν ἀνακρίνω· ");
INSERT INTO grcsbl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","οὐδὲν γὰρ ἐμαυτῷ σύνοιδα, ἀλλʼ οὐκ ἐν τούτῳ δεδικαίωμαι, ὁ δὲ ἀνακρίνων με κύριός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ὥστε μὴ πρὸ καιροῦ τι κρίνετε, ἕως ἂν ἔλθῃ ὁ κύριος, ὃς καὶ φωτίσει τὰ κρυπτὰ τοῦ σκότους καὶ φανερώσει τὰς βουλὰς τῶν καρδιῶν, καὶ τότε ὁ ἔπαινος γενήσεται ἑκάστῳ ἀπὸ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ταῦτα δέ, ἀδελφοί, μετεσχημάτισα εἰς ἐμαυτὸν καὶ ⸀Ἀπολλῶνδιʼ ὑμᾶς, ἵνα ἐν ἡμῖν μάθητε τό· Μὴ ὑπὲρ ⸀ἃ⸀γέγραπται ἵνα μὴ εἷς ὑπὲρ τοῦ ἑνὸς φυσιοῦσθε κατὰ τοῦ ἑτέρου. ");
INSERT INTO grcsbl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","τίς γάρ σε διακρίνει; τί δὲ ἔχεις ὃ οὐκ ἔλαβες; εἰ δὲ καὶ ἔλαβες, τί καυχᾶσαι ὡς μὴ λαβών; ");
INSERT INTO grcsbl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ἤδη κεκορεσμένοι ἐστέ, ἤδη ἐπλουτήσατε, χωρὶς ἡμῶν ἐβασιλεύσατε· καὶ ὄφελόν γε ἐβασιλεύσατε, ἵνα καὶ ἡμεῖς ὑμῖν συμβασιλεύσωμεν. ");
INSERT INTO grcsbl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","δοκῶ ⸀γάρ ὁ θεὸς ἡμᾶς τοὺς ἀποστόλους ἐσχάτους ἀπέδειξεν ὡς ἐπιθανατίους, ὅτι θέατρον ἐγενήθημεν τῷ κόσμῳ καὶ ἀγγέλοις καὶ ἀνθρώποις. ");
INSERT INTO grcsbl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ἡμεῖς μωροὶ διὰ Χριστόν, ὑμεῖς δὲ φρόνιμοι ἐν Χριστῷ· ἡμεῖς ἀσθενεῖς, ὑμεῖς δὲ ἰσχυροί· ὑμεῖς ἔνδοξοι, ἡμεῖς δὲ ἄτιμοι. ");
INSERT INTO grcsbl_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ἄχρι τῆς ἄρτι ὥρας καὶ πεινῶμεν καὶ διψῶμεν καὶ γυμνιτεύομεν καὶ κολαφιζόμεθα καὶ ἀστατοῦμεν ");
INSERT INTO grcsbl_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","καὶ κοπιῶμεν ἐργαζόμενοι ταῖς ἰδίαις χερσίν· λοιδορούμενοι εὐλογοῦμεν, διωκόμενοι ἀνεχόμεθα, ");
INSERT INTO grcsbl_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","⸀δυσφημούμενοιπαρακαλοῦμεν· ὡς περικαθάρματα τοῦ κόσμου ἐγενήθημεν, πάντων περίψημα ἕως ἄρτι. ");
INSERT INTO grcsbl_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Οὐκ ἐντρέπων ὑμᾶς γράφω ταῦτα, ἀλλʼ ὡς τέκνα μου ἀγαπητὰ ⸀νουθετῶν ");
INSERT INTO grcsbl_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ἐὰν γὰρ μυρίους παιδαγωγοὺς ἔχητε ἐν Χριστῷ, ἀλλʼ οὐ πολλοὺς πατέρας, ἐν γὰρ Χριστῷ Ἰησοῦ διὰ τοῦ εὐαγγελίου ἐγὼ ὑμᾶς ἐγέννησα. ");
INSERT INTO grcsbl_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","παρακαλῶ οὖν ὑμᾶς, μιμηταί μου γίνεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","διὰ τοῦτο ἔπεμψα ὑμῖν Τιμόθεον, ὅς ἐστίν ⸂μου τέκνον ἀγαπητὸν καὶ πιστὸν ἐν κυρίῳ, ὃς ὑμᾶς ἀναμνήσει τὰς ὁδούς μου τὰς ἐν Χριστῷ ⸀Ἰησοῦ καθὼς πανταχοῦ ἐν πάσῃ ἐκκλησίᾳ διδάσκω. ");
INSERT INTO grcsbl_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ὡς μὴ ἐρχομένου δέ μου πρὸς ὑμᾶς ἐφυσιώθησάν τινες· ");
INSERT INTO grcsbl_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ἐλεύσομαι δὲ ταχέως πρὸς ὑμᾶς, ἐὰν ὁ κύριος θελήσῃ, καὶ γνώσομαι οὐ τὸν λόγον τῶν πεφυσιωμένων ἀλλὰ τὴν δύναμιν, ");
INSERT INTO grcsbl_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","οὐ γὰρ ἐν λόγῳ ἡ βασιλεία τοῦ θεοῦ ἀλλʼ ἐν δυνάμει. ");
INSERT INTO grcsbl_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","τί θέλετε; ἐν ῥάβδῳ ἔλθω πρὸς ὑμᾶς, ἢ ἐν ἀγάπῃ πνεύματί τε πραΰτητος; ");
INSERT INTO grcsbl_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Ὅλως ἀκούεται ἐν ὑμῖν πορνεία, καὶ τοιαύτη πορνεία ἥτις οὐδὲ ἐν τοῖς ⸀ἔθνεσιν ὥστε γυναῖκά τινα τοῦ πατρὸς ἔχειν. ");
INSERT INTO grcsbl_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","καὶ ὑμεῖς πεφυσιωμένοι ἐστέ, καὶ οὐχὶ μᾶλλον ἐπενθήσατε, ἵνα ⸀ἀρθῇἐκ μέσου ὑμῶν ὁ τὸ ἔργον τοῦτο ⸀ποιήσας ");
INSERT INTO grcsbl_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ἐγὼ μὲν γάρ, ⸀ἀπὼντῷ σώματι παρὼν δὲ τῷ πνεύματι, ἤδη κέκρικα ὡς παρὼν τὸν οὕτως τοῦτο κατεργασάμενον ");
INSERT INTO grcsbl_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ἐν τῷ ὀνόματι τοῦ κυρίου ἡμῶν ⸀Ἰησοῦ συναχθέντων ὑμῶν καὶ τοῦ ἐμοῦ πνεύματος σὺν τῇ δυνάμει τοῦ κυρίου ἡμῶν ⸁Ἰησοῦ ");
INSERT INTO grcsbl_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","παραδοῦναι τὸν τοιοῦτον τῷ Σατανᾷ εἰς ὄλεθρον τῆς σαρκός, ἵνα τὸ πνεῦμα σωθῇ ἐν τῇ ἡμέρᾳ τοῦ ⸀κυρίου ");
INSERT INTO grcsbl_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Οὐ καλὸν τὸ καύχημα ὑμῶν. οὐκ οἴδατε ὅτι μικρὰ ζύμη ὅλον τὸ φύραμα ζυμοῖ; ");
INSERT INTO grcsbl_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ἐκκαθάρατε τὴν παλαιὰν ζύμην, ἵνα ἦτε νέον φύραμα, καθώς ἐστε ἄζυμοι. καὶ γὰρ τὸ πάσχα ⸀ἡμῶνἐτύθη Χριστός· ");
INSERT INTO grcsbl_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ὥστε ἑορτάζωμεν, μὴ ἐν ζύμῃ παλαιᾷ μηδὲ ἐν ζύμῃ κακίας καὶ πονηρίας, ἀλλʼ ἐν ἀζύμοις εἰλικρινείας καὶ ἀληθείας. ");
INSERT INTO grcsbl_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ἔγραψα ὑμῖν ἐν τῇ ἐπιστολῇ μὴ συναναμίγνυσθαι πόρνοις, ");
INSERT INTO grcsbl_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","⸀οὐπάντως τοῖς πόρνοις τοῦ κόσμου τούτου ἢ τοῖς πλεονέκταις ⸀καὶἅρπαξιν ἢ εἰδωλολάτραις, ἐπεὶ ⸀ὠφείλετεἄρα ἐκ τοῦ κόσμου ἐξελθεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","νῦν δὲ ἔγραψα ὑμῖν μὴ συναναμίγνυσθαι ἐάν τις ἀδελφὸς ὀνομαζόμενος ᾖ πόρνος ἢ πλεονέκτης ἢ εἰδωλολάτρης ἢ λοίδορος ἢ μέθυσος ἢ ἅρπαξ, τῷ τοιούτῳ μηδὲ συνεσθίειν. ");
INSERT INTO grcsbl_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","τί γάρ ⸀μοιτοὺς ἔξω κρίνειν; οὐχὶ τοὺς ἔσω ὑμεῖς κρίνετε, ");
INSERT INTO grcsbl_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","τοὺς δὲ ἔξω ὁ θεὸς ⸀κρίνει ⸀ἐξάρατετὸν πονηρὸν ἐξ ὑμῶν αὐτῶν. ");
INSERT INTO grcsbl_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Τολμᾷ τις ὑμῶν πρᾶγμα ἔχων πρὸς τὸν ἕτερον κρίνεσθαι ἐπὶ τῶν ἀδίκων, καὶ οὐχὶ ἐπὶ τῶν ἁγίων; ");
INSERT INTO grcsbl_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","⸀ἢοὐκ οἴδατε ὅτι οἱ ἅγιοι τὸν κόσμον κρινοῦσιν; καὶ εἰ ἐν ὑμῖν κρίνεται ὁ κόσμος, ἀνάξιοί ἐστε κριτηρίων ἐλαχίστων; ");
INSERT INTO grcsbl_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","οὐκ οἴδατε ὅτι ἀγγέλους κρινοῦμεν, μήτιγε βιωτικά; ");
INSERT INTO grcsbl_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","βιωτικὰ μὲν οὖν κριτήρια ἐὰν ἔχητε, τοὺς ἐξουθενημένους ἐν τῇ ἐκκλησίᾳ, τούτους καθίζετε; ");
INSERT INTO grcsbl_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","πρὸς ἐντροπὴν ὑμῖν λέγω. οὕτως οὐκ ἔνι ἐν ὑμῖν ⸂οὐδεὶς σοφὸς ὃς δυνήσεται διακρῖναι ἀνὰ μέσον τοῦ ⸀ἀδελφοῦαὐτοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ἀλλὰ ἀδελφὸς μετὰ ἀδελφοῦ κρίνεται, καὶ τοῦτο ἐπὶ ἀπίστων; ");
INSERT INTO grcsbl_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ἤδη μὲν ⸀οὖνὅλως ἥττημα ὑμῖν ἐστιν ὅτι κρίματα ἔχετε μεθʼ ἑαυτῶν· διὰ τί οὐχὶ μᾶλλον ἀδικεῖσθε; διὰ τί οὐχὶ μᾶλλον ἀποστερεῖσθε; ");
INSERT INTO grcsbl_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ἀλλὰ ὑμεῖς ἀδικεῖτε καὶ ἀποστερεῖτε, καὶ ⸀τοῦτοἀδελφούς. ");
INSERT INTO grcsbl_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ἢ οὐκ οἴδατε ὅτι ἄδικοι ⸂θεοῦ βασιλείαν οὐ κληρονομήσουσιν; μὴ πλανᾶσθε· οὔτε πόρνοι οὔτε εἰδωλολάτραι οὔτε μοιχοὶ οὔτε μαλακοὶ οὔτε ἀρσενοκοῖται ");
INSERT INTO grcsbl_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","οὔτε ⸂κλέπται οὔτε πλεονέκται, ⸀οὐμέθυσοι, οὐ λοίδοροι, οὐχ ἅρπαγες βασιλείαν ⸀θεοῦκληρονομήσουσιν. ");
INSERT INTO grcsbl_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","καὶ ταῦτά τινες ἦτε· ἀλλὰ ἀπελούσασθε, ἀλλὰ ἡγιάσθητε, ἀλλὰ ἐδικαιώθητε ἐν τῷ ὀνόματι τοῦ κυρίου ⸀Ἰησοῦκαὶ ἐν τῷ πνεύματι τοῦ θεοῦ ἡμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Πάντα μοι ἔξεστιν· ἀλλʼ οὐ πάντα συμφέρει. πάντα μοι ἔξεστιν· ἀλλʼ οὐκ ἐγὼ ἐξουσιασθήσομαι ὑπό τινος. ");
INSERT INTO grcsbl_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","τὰ βρώματα τῇ κοιλίᾳ, καὶ ἡ κοιλία τοῖς βρώμασιν· ὁ δὲ θεὸς καὶ ταύτην καὶ ταῦτα καταργήσει. τὸ δὲ σῶμα οὐ τῇ πορνείᾳ ἀλλὰ τῷ κυρίῳ, καὶ ὁ κύριος τῷ σώματι· ");
INSERT INTO grcsbl_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ὁ δὲ θεὸς καὶ τὸν κύριον ἤγειρεν καὶ ἡμᾶς ἐξεγερεῖ διὰ τῆς δυνάμεως αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","οὐκ οἴδατε ὅτι τὰ σώματα ὑμῶν μέλη Χριστοῦ ἐστιν; ἄρας οὖν τὰ μέλη τοῦ Χριστοῦ ποιήσω πόρνης μέλη; μὴ γένοιτο. ");
INSERT INTO grcsbl_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","⸀ἢοὐκ οἴδατε ὅτι ὁ κολλώμενος τῇ πόρνῃ ἓν σῶμά ἐστιν; Ἔσονται γάρ, φησίν, οἱ δύο εἰς σάρκα μίαν. ");
INSERT INTO grcsbl_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ὁ δὲ κολλώμενος τῷ κυρίῳ ἓν πνεῦμά ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","φεύγετε τὴν πορνείαν· πᾶν ἁμάρτημα ὃ ἐὰν ποιήσῃ ἄνθρωπος ἐκτὸς τοῦ σώματός ἐστιν, ὁ δὲ πορνεύων εἰς τὸ ἴδιον σῶμα ἁμαρτάνει. ");
INSERT INTO grcsbl_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ἢ οὐκ οἴδατε ὅτι τὸ σῶμα ὑμῶν ναὸς τοῦ ἐν ὑμῖν ἁγίου πνεύματός ἐστιν, οὗ ἔχετε ἀπὸ θεοῦ; καὶ οὐκ ἐστὲ ἑαυτῶν, ");
INSERT INTO grcsbl_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ἠγοράσθητε γὰρ τιμῆς· δοξάσατε δὴ τὸν θεὸν ἐν τῷ σώματι ⸀ὑμῶν ");
INSERT INTO grcsbl_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Περὶ δὲ ὧν ⸀ἐγράψατε καλὸν ἀνθρώπῳ γυναικὸς μὴ ἅπτεσθαι· ");
INSERT INTO grcsbl_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","διὰ δὲ τὰς πορνείας ἕκαστος τὴν ἑαυτοῦ γυναῖκα ἐχέτω, καὶ ἑκάστη τὸν ἴδιον ἄνδρα ἐχέτω. ");
INSERT INTO grcsbl_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","τῇ γυναικὶ ὁ ἀνὴρ τὴν ⸀ὀφειλὴνἀποδιδότω, ὁμοίως δὲ καὶ ἡ γυνὴ τῷ ἀνδρί. ");
INSERT INTO grcsbl_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ἡ γυνὴ τοῦ ἰδίου σώματος οὐκ ἐξουσιάζει ἀλλὰ ὁ ἀνήρ· ὁμοίως δὲ καὶ ὁ ἀνὴρ τοῦ ἰδίου σώματος οὐκ ἐξουσιάζει ἀλλὰ ἡ γυνή. ");
INSERT INTO grcsbl_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","μὴ ἀποστερεῖτε ἀλλήλους, εἰ μήτι ἂν ἐκ συμφώνου πρὸς καιρὸν ἵνα ⸀σχολάσητε⸀τῇπροσευχῇ καὶ πάλιν ἐπὶ τὸ αὐτὸ ⸀ἦτε ἵνα μὴ πειράζῃ ὑμᾶς ὁ Σατανᾶς διὰ τὴν ἀκρασίαν ὑμῶν. ");
INSERT INTO grcsbl_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","τοῦτο δὲ λέγω κατὰ συγγνώμην, οὐ κατʼ ἐπιταγήν. ");
INSERT INTO grcsbl_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","θέλω ⸀δὲπάντας ἀνθρώπους εἶναι ὡς καὶ ἐμαυτόν· ἀλλὰ ἕκαστος ἴδιον ⸂ἔχει χάρισμα ἐκ θεοῦ, ⸀ὁμὲν οὕτως, ⸁ὁδὲ οὕτως. ");
INSERT INTO grcsbl_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Λέγω δὲ τοῖς ἀγάμοις καὶ ταῖς χήραις, καλὸν ⸀αὐτοῖςἐὰν μείνωσιν ὡς κἀγώ· ");
INSERT INTO grcsbl_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","εἰ δὲ οὐκ ἐγκρατεύονται, γαμησάτωσαν, κρεῖττον γάρ ἐστιν ⸀γαμῆσαιἢ πυροῦσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Τοῖς δὲ γεγαμηκόσιν παραγγέλλω, οὐκ ἐγὼ ἀλλὰ ὁ κύριος, γυναῖκα ἀπὸ ἀνδρὸς μὴ χωρισθῆναι— ");
INSERT INTO grcsbl_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ἐὰν δὲ καὶ χωρισθῇ, μενέτω ἄγαμος ἢ τῷ ἀνδρὶ καταλλαγήτω— καὶ ἄνδρα γυναῖκα μὴ ἀφιέναι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Τοῖς δὲ λοιποῖς ⸂λέγω ἐγώ, οὐχ ὁ κύριος· εἴ τις ἀδελφὸς γυναῖκα ἔχει ἄπιστον, καὶ αὕτη συνευδοκεῖ οἰκεῖν μετʼ αὐτοῦ, μὴ ἀφιέτω αὐτήν· ");
INSERT INTO grcsbl_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","καὶ γυνὴ ⸂εἴ τις ἔχει ἄνδρα ἄπιστον, καὶ ⸀οὗτοςσυνευδοκεῖ οἰκεῖν μετʼ αὐτῆς, μὴ ἀφιέτω ⸂τὸν ἄνδρα. ");
INSERT INTO grcsbl_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ἡγίασται γὰρ ὁ ἀνὴρ ὁ ἄπιστος ἐν τῇ γυναικί, καὶ ἡγίασται ἡ γυνὴ ἡ ἄπιστος ἐν τῷ ⸀ἀδελφῷ ἐπεὶ ἄρα τὰ τέκνα ὑμῶν ἀκάθαρτά ἐστιν, νῦν δὲ ἅγιά ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","εἰ δὲ ὁ ἄπιστος χωρίζεται, χωριζέσθω· οὐ δεδούλωται ὁ ἀδελφὸς ἢ ἡ ἀδελφὴ ἐν τοῖς τοιούτοις, ἐν δὲ εἰρήνῃ κέκληκεν ⸀ἡμᾶςὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","τί γὰρ οἶδας, γύναι, εἰ τὸν ἄνδρα σώσεις; ἢ τί οἶδας, ἄνερ, εἰ τὴν γυναῖκα σώσεις; ");
INSERT INTO grcsbl_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Εἰ μὴ ἑκάστῳ ὡς ⸀ἐμέρισενὁ ⸀κύριος ἕκαστον ὡς κέκληκεν ὁ ⸀θεός οὕτως περιπατείτω· καὶ οὕτως ἐν ταῖς ἐκκλησίαις πάσαις διατάσσομαι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","περιτετμημένος τις ἐκλήθη; μὴ ἐπισπάσθω· ἐν ἀκροβυστίᾳ ⸂κέκληταί τις; μὴ περιτεμνέσθω. ");
INSERT INTO grcsbl_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ἡ περιτομὴ οὐδέν ἐστιν, καὶ ἡ ἀκροβυστία οὐδέν ἐστιν, ἀλλὰ τήρησις ἐντολῶν θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ἕκαστος ἐν τῇ κλήσει ᾗ ἐκλήθη ἐν ταύτῃ μενέτω. ");
INSERT INTO grcsbl_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Δοῦλος ἐκλήθης; μή σοι μελέτω· ἀλλʼ εἰ καὶ δύνασαι ἐλεύθερος γενέσθαι, μᾶλλον χρῆσαι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ὁ γὰρ ἐν κυρίῳ κληθεὶς δοῦλος ἀπελεύθερος κυρίου ἐστίν· ⸀ὁμοίωςὁ ἐλεύθερος κληθεὶς δοῦλός ἐστιν Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","τιμῆς ἠγοράσθητε· μὴ γίνεσθε δοῦλοι ἀνθρώπων. ");
INSERT INTO grcsbl_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ἕκαστος ἐν ᾧ ἐκλήθη, ἀδελφοί, ἐν τούτῳ μενέτω παρὰ θεῷ. ");
INSERT INTO grcsbl_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Περὶ δὲ τῶν παρθένων ἐπιταγὴν κυρίου οὐκ ἔχω, γνώμην δὲ δίδωμι ὡς ἠλεημένος ὑπὸ κυρίου πιστὸς εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","νομίζω οὖν τοῦτο καλὸν ὑπάρχειν διὰ τὴν ἐνεστῶσαν ἀνάγκην, ὅτι καλὸν ἀνθρώπῳ τὸ οὕτως εἶναι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","δέδεσαι γυναικί; μὴ ζήτει λύσιν· λέλυσαι ἀπὸ γυναικός; μὴ ζήτει γυναῖκα· ");
INSERT INTO grcsbl_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ἐὰν δὲ καὶ ⸀γαμήσῃς οὐχ ἥμαρτες. καὶ ἐὰν γήμῃ ἡ παρθένος, οὐχ ἥμαρτεν. θλῖψιν δὲ τῇ σαρκὶ ἕξουσιν οἱ τοιοῦτοι, ἐγὼ δὲ ὑμῶν φείδομαι. ");
INSERT INTO grcsbl_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","τοῦτο δέ φημι, ἀδελφοί, ὁ καιρὸς συνεσταλμένος ⸂ἐστίν· τὸ λοιπὸν⸃ ἵνα καὶ οἱ ἔχοντες γυναῖκας ὡς μὴ ἔχοντες ὦσιν, ");
INSERT INTO grcsbl_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","καὶ οἱ κλαίοντες ὡς μὴ κλαίοντες, καὶ οἱ χαίροντες ὡς μὴ χαίροντες, καὶ οἱ ἀγοράζοντες ὡς μὴ κατέχοντες, ");
INSERT INTO grcsbl_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","καὶ οἱ χρώμενοι ⸂τὸν κόσμον ὡς μὴ καταχρώμενοι· παράγει γὰρ τὸ σχῆμα τοῦ κόσμου τούτου. ");
INSERT INTO grcsbl_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Θέλω δὲ ὑμᾶς ἀμερίμνους εἶναι. ὁ ἄγαμος μεριμνᾷ τὰ τοῦ κυρίου, πῶς ⸀ἀρέσῃτῷ κυρίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ὁ δὲ γαμήσας μεριμνᾷ τὰ τοῦ κόσμου, πῶς ⸀ἀρέσῃτῇ γυναικί, ");
INSERT INTO grcsbl_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","⸀καὶμεμέρισται. καὶ ἡ γυνὴ ⸂ἡ ἄγαμος καὶ ἡ ⸀παρθένοςμεριμνᾷ τὰ τοῦ κυρίου, ἵνα ᾖ ἁγία καὶ ⸀τῷσώματι καὶ ⸁τῷπνεύματι· ἡ δὲ γαμήσασα μεριμνᾷ τὰ τοῦ κόσμου, πῶς ⸀ἀρέσῃτῷ ἀνδρί. ");
INSERT INTO grcsbl_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","τοῦτο δὲ πρὸς τὸ ὑμῶν αὐτῶν ⸀σύμφορονλέγω, οὐχ ἵνα βρόχον ὑμῖν ἐπιβάλω, ἀλλὰ πρὸς τὸ εὔσχημον καὶ ⸀εὐπάρεδροντῷ κυρίῳ ἀπερισπάστως. ");
INSERT INTO grcsbl_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Εἰ δέ τις ἀσχημονεῖν ἐπὶ τὴν παρθένον αὐτοῦ νομίζει ἐὰν ᾖ ὑπέρακμος, καὶ οὕτως ὀφείλει γίνεσθαι, ὃ θέλει ποιείτω· οὐχ ἁμαρτάνει· γαμείτωσαν. ");
INSERT INTO grcsbl_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ὃς δὲ ἕστηκεν ⸂ἐν τῇ καρδίᾳ αὐτοῦ ἑδραῖος μὴ ἔχων ἀνάγκην, ἐξουσίαν δὲ ἔχει περὶ τοῦ ἰδίου θελήματος, καὶ τοῦτο κέκρικεν ἐν τῇ ⸂ἰδίᾳ καρδίᾳ, ⸀τηρεῖντὴν ἑαυτοῦ παρθένον, καλῶς ⸀ποιήσει ");
INSERT INTO grcsbl_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ὥστε καὶ ὁ ⸀γαμίζων⸂τὴν παρθένον ἑαυτοῦ καλῶς ποιεῖ, ⸂καὶ ὁ μὴ ⸁γαμίζωνκρεῖσσον ⸀ποιήσει ");
INSERT INTO grcsbl_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Γυνὴ ⸀δέδεταιἐφʼ ὅσον χρόνον ζῇ ὁ ἀνὴρ αὐτῆς· ἐὰν ⸀δὲκοιμηθῇ ὁ ἀνήρ, ἐλευθέρα ἐστὶν ᾧ θέλει γαμηθῆναι, μόνον ἐν κυρίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","μακαριωτέρα δέ ἐστιν ἐὰν οὕτως μείνῃ, κατὰ τὴν ἐμὴν γνώμην, δοκῶ ⸀δὲκἀγὼ πνεῦμα θεοῦ ἔχειν. ");
INSERT INTO grcsbl_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Περὶ δὲ τῶν εἰδωλοθύτων, οἴδαμεν ὅτι πάντες γνῶσιν ἔχομεν. ἡ γνῶσις φυσιοῖ, ἡ δὲ ἀγάπη οἰκοδομεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","⸀εἴτις δοκεῖ ⸀ἐγνωκέναιτι, ⸀οὔπω⸀ἔγνωκαθὼς δεῖ γνῶναι· ");
INSERT INTO grcsbl_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","εἰ δέ τις ἀγαπᾷ τὸν θεόν, οὗτος ἔγνωσται ὑπʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Περὶ τῆς βρώσεως οὖν τῶν εἰδωλοθύτων οἴδαμεν ὅτι οὐδὲν εἴδωλον ἐν κόσμῳ, καὶ ὅτι οὐδεὶς ⸀θεὸςεἰ μὴ εἷς. ");
INSERT INTO grcsbl_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","καὶ γὰρ εἴπερ εἰσὶν λεγόμενοι θεοὶ εἴτε ἐν οὐρανῷ εἴτε ἐπὶ γῆς, ὥσπερ εἰσὶν θεοὶ πολλοὶ καὶ κύριοι πολλοί, ");
INSERT INTO grcsbl_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ἀλλʼ ἡμῖν εἷς θεὸς ὁ πατήρ, ἐξ οὗ τὰ πάντα καὶ ἡμεῖς εἰς αὐτόν, καὶ εἷς κύριος Ἰησοῦς Χριστός, διʼ οὗ τὰ πάντα καὶ ἡμεῖς διʼ αὐτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ἀλλʼ οὐκ ἐν πᾶσιν ἡ γνῶσις· τινὲς δὲ τῇ ⸀συνηθείᾳ⸂ἕως ἄρτι τοῦ εἰδώλου ὡς εἰδωλόθυτον ἐσθίουσιν, καὶ ἡ συνείδησις αὐτῶν ἀσθενὴς οὖσα μολύνεται. ");
INSERT INTO grcsbl_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","βρῶμα δὲ ἡμᾶς οὐ ⸀παραστήσειτῷ θεῷ· οὔτε ⸂γὰρ ἐὰν φάγωμεν, περισσεύομεν, οὔτε ἐὰν μὴ φάγωμεν, ὑστερούμεθα. ");
INSERT INTO grcsbl_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","βλέπετε δὲ μή πως ἡ ἐξουσία ὑμῶν αὕτη πρόσκομμα γένηται τοῖς ⸀ἀσθενέσιν ");
INSERT INTO grcsbl_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ἐὰν γάρ τις ἴδῃ σὲ τὸν ἔχοντα γνῶσιν ἐν εἰδωλείῳ κατακείμενον, οὐχὶ ἡ συνείδησις αὐτοῦ ἀσθενοῦς ὄντος οἰκοδομηθήσεται εἰς τὸ τὰ εἰδωλόθυτα ἐσθίειν; ");
INSERT INTO grcsbl_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","⸂ἀπόλλυται γὰρ ὁ ἀσθενῶν ⸀ἐντῇ σῇ γνώσει, ⸂ὁ ἀδελφὸς διʼ ὃν Χριστὸς ἀπέθανεν. ");
INSERT INTO grcsbl_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","οὕτως δὲ ἁμαρτάνοντες εἰς τοὺς ἀδελφοὺς καὶ τύπτοντες αὐτῶν τὴν συνείδησιν ἀσθενοῦσαν εἰς Χριστὸν ἁμαρτάνετε. ");
INSERT INTO grcsbl_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","διόπερ εἰ βρῶμα σκανδαλίζει τὸν ἀδελφόν μου, οὐ μὴ φάγω κρέα εἰς τὸν αἰῶνα, ἵνα μὴ τὸν ἀδελφόν μου σκανδαλίσω. ");
INSERT INTO grcsbl_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Οὐκ εἰμὶ ⸂ἐλεύθερος; οὐκ εἰμὶ ἀπόστολος⸃; οὐχὶ ⸀Ἰησοῦν τὸν κύριον ἡμῶν ἑόρακα; οὐ τὸ ἔργον μου ὑμεῖς ἐστε ἐν κυρίῳ; ");
INSERT INTO grcsbl_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","εἰ ἄλλοις οὐκ εἰμὶ ἀπόστολος, ἀλλά γε ὑμῖν εἰμι, ἡ γὰρ σφραγίς ⸂μου τῆς ἀποστολῆς ὑμεῖς ἐστε ἐν κυρίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Ἡ ἐμὴ ἀπολογία τοῖς ἐμὲ ἀνακρίνουσίν ⸂ἐστιν αὕτη. ");
INSERT INTO grcsbl_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","μὴ οὐκ ἔχομεν ἐξουσίαν φαγεῖν καὶ ⸀πεῖν ");
INSERT INTO grcsbl_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","μὴ οὐκ ἔχομεν ἐξουσίαν ἀδελφὴν γυναῖκα περιάγειν, ὡς καὶ οἱ λοιποὶ ἀπόστολοι καὶ οἱ ἀδελφοὶ τοῦ κυρίου καὶ Κηφᾶς; ");
INSERT INTO grcsbl_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ἢ μόνος ἐγὼ καὶ Βαρναβᾶς οὐκ ἔχομεν ἐξουσίαν ⸀μὴἐργάζεσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","τίς στρατεύεται ἰδίοις ὀψωνίοις ποτέ; τίς φυτεύει ἀμπελῶνα καὶ ⸂τὸν καρπὸν αὐτοῦ οὐκ ἐσθίει; ⸀τίςποιμαίνει ποίμνην καὶ ἐκ τοῦ γάλακτος τῆς ποίμνης οὐκ ἐσθίει; ");
INSERT INTO grcsbl_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Μὴ κατὰ ἄνθρωπον ταῦτα λαλῶ ἢ ⸂καὶ ὁ νόμος ταῦτα οὐ λέγει; ");
INSERT INTO grcsbl_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ἐν γὰρ τῷ Μωϋσέως νόμῳ γέγραπται· Οὐ ⸀κημώσειςβοῦν ἀλοῶντα. μὴ τῶν βοῶν μέλει τῷ θεῷ, ");
INSERT INTO grcsbl_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ἢ διʼ ἡμᾶς πάντως λέγει; διʼ ἡμᾶς γὰρ ἐγράφη, ὅτι ⸂ὀφείλει ἐπʼ ἐλπίδι ὁ ἀροτριῶν ἀροτριᾶν, καὶ ὁ ἀλοῶν ⸂ἐπʼ ἐλπίδι τοῦ μετέχειν. ");
INSERT INTO grcsbl_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","εἰ ἡμεῖς ὑμῖν τὰ πνευματικὰ ἐσπείραμεν, μέγα εἰ ἡμεῖς ὑμῶν τὰ σαρκικὰ θερίσομεν; ");
INSERT INTO grcsbl_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","εἰ ἄλλοι τῆς ⸂ὑμῶν ἐξουσίας μετέχουσιν, οὐ μᾶλλον ἡμεῖς; Ἀλλʼ οὐκ ἐχρησάμεθα τῇ ἐξουσίᾳ ταύτῃ, ἀλλὰ πάντα στέγομεν ἵνα μή ⸂τινα ἐγκοπὴν⸃ δῶμεν τῷ εὐαγγελίῳ τοῦ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","οὐκ οἴδατε ὅτι οἱ τὰἱερὰ ἐργαζόμενοι ⸀τὰ ἐκ τοῦ ἱεροῦ ἐσθίουσιν, οἱ τῷ θυσιαστηρίῳ ⸀παρεδρεύοντεςτῷ θυσιαστηρίῳ συμμερίζονται; ");
INSERT INTO grcsbl_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","οὕτως καὶ ὁ κύριος διέταξεν τοῖς τὸ εὐαγγέλιον καταγγέλλουσιν ἐκ τοῦ εὐαγγελίου ζῆν. ");
INSERT INTO grcsbl_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ἐγὼ δὲ ⸂οὐ κέχρημαι οὐδενὶ τούτων. οὐκ ἔγραψα δὲ ταῦτα ἵνα οὕτως γένηται ἐν ἐμοί, καλὸν γάρ μοι μᾶλλον ἀποθανεῖν ἤ— τὸ καύχημά μου ⸂οὐδεὶς κενώσει. ");
INSERT INTO grcsbl_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ἐὰν γὰρ εὐαγγελίζωμαι, οὐκ ἔστιν μοι καύχημα, ἀνάγκη γάρμοι ἐπίκειται· οὐαὶ ⸀γάρ μοί ἐστιν ἐὰν μὴ ⸀εὐαγγελίσωμαι ");
INSERT INTO grcsbl_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","εἰ γὰρ ἑκὼν τοῦτο πράσσω, μισθὸν ἔχω· εἰ δὲ ἄκων, οἰκονομίαν πεπίστευμαι. ");
INSERT INTO grcsbl_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","τίς οὖν ⸀μούἐστιν ὁ μισθός; ἵνα εὐαγγελιζόμενος ἀδάπανον θήσω τὸ ⸀εὐαγγέλιον εἰς τὸ μὴ καταχρήσασθαι τῇ ἐξουσίᾳ μου ἐν τῷ εὐαγγελίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Ἐλεύθερος γὰρ ὢν ἐκ πάντων πᾶσιν ἐμαυτὸν ἐδούλωσα, ἵνα τοὺς πλείονας κερδήσω· ");
INSERT INTO grcsbl_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","καὶ ἐγενόμην τοῖς Ἰουδαίοις ὡς Ἰουδαῖος, ἵνα Ἰουδαίους κερδήσω· τοῖς ὑπὸ νόμον ὡς ὑπὸ νόμον, ⸂μὴ ὢν αὐτὸς ὑπὸ νόμον, ἵνα τοὺς ὑπὸ νόμον κερδήσω· ");
INSERT INTO grcsbl_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","τοῖς ἀνόμοις ὡς ἄνομος, μὴ ὢν ἄνομος ⸀θεοῦἀλλʼ ἔννομος ⸀Χριστοῦ ἵνα ⸀κερδάνω⸀τοὺςἀνόμους· ");
INSERT INTO grcsbl_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ἐγενόμην τοῖς ⸀ἀσθενέσινἀσθενής, ἵνα τοὺς ἀσθενεῖς κερδήσω· τοῖς πᾶσιν ⸀γέγοναπάντα, ἵνα πάντως τινὰς σώσω. ");
INSERT INTO grcsbl_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","⸀πάνταδὲ ποιῶ διὰ τὸ εὐαγγέλιον, ἵνα συγκοινωνὸς αὐτοῦ γένωμαι. ");
INSERT INTO grcsbl_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Οὐκ οἴδατε ὅτι οἱ ἐν σταδίῳ τρέχοντες πάντες μὲν τρέχουσιν, εἷς δὲ λαμβάνει τὸ βραβεῖον; οὕτως τρέχετε ἵνα καταλάβητε. ");
INSERT INTO grcsbl_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","πᾶς δὲ ὁ ἀγωνιζόμενος πάντα ἐγκρατεύεται, ἐκεῖνοι μὲν οὖν ἵνα φθαρτὸν στέφανον λάβωσιν, ἡμεῖς δὲ ἄφθαρτον. ");
INSERT INTO grcsbl_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ἐγὼ τοίνυν οὕτως τρέχω ὡς οὐκ ἀδήλως, οὕτως πυκτεύω ὡς οὐκ ἀέρα δέρων· ");
INSERT INTO grcsbl_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ἀλλὰ ὑπωπιάζω μου τὸ σῶμα καὶ δουλαγωγῶ, μή πως ἄλλοις κηρύξας αὐτὸς ἀδόκιμος γένωμαι. ");
INSERT INTO grcsbl_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Οὐ θέλω ⸀γὰρὑμᾶς ἀγνοεῖν, ἀδελφοί, ὅτι οἱ πατέρες ἡμῶν πάντες ὑπὸ τὴν νεφέλην ἦσαν καὶ πάντες διὰ τῆς θαλάσσης διῆλθον, ");
INSERT INTO grcsbl_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","καὶ πάντες εἰς τὸν Μωϋσῆν ⸀ἐβαπτίσαντοἐν τῇ νεφέλῃ καὶ ἐν τῇ θαλάσσῃ, ");
INSERT INTO grcsbl_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","καὶ πάντες τὸ αὐτὸ ⸂πνευματικὸν βρῶμα ἔφαγον ");
INSERT INTO grcsbl_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","καὶ πάντες τὸ αὐτὸ ⸂πνευματικὸν ἔπιον πόμα, ἔπινον γὰρ ἐκ πνευματικῆς ἀκολουθούσης πέτρας, ἡ ⸂πέτρα δὲ ἦν ὁ Χριστός· ");
INSERT INTO grcsbl_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ἀλλʼ οὐκ ἐν τοῖς πλείοσιν αὐτῶν ηὐδόκησεν ὁ θεός, κατεστρώθησαν γὰρ ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcsbl_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Ταῦτα δὲ τύποι ἡμῶν ἐγενήθησαν, εἰς τὸ μὴ εἶναι ἡμᾶς ἐπιθυμητὰς κακῶν, καθὼς κἀκεῖνοι ἐπεθύμησαν. ");
INSERT INTO grcsbl_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","μηδὲ εἰδωλολάτραι γίνεσθε, καθώς τινες αὐτῶν· ὥσπερ γέγραπται· Ἐκάθισεν ὁ λαὸς φαγεῖν καὶ πεῖν, καὶ ἀνέστησαν παίζειν. ");
INSERT INTO grcsbl_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","μηδὲ πορνεύωμεν, καθώς τινες αὐτῶν ἐπόρνευσαν, καὶ ἔπεσαν μιᾷ ἡμέρᾳ εἴκοσι τρεῖς χιλιάδες. ");
INSERT INTO grcsbl_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","μηδὲ ἐκπειράζωμεν τὸν ⸀Χριστόν ⸀καθώςτινες αὐτῶν ἐπείρασαν, καὶ ὑπὸ τῶν ὄφεων ⸀ἀπώλλυντο ");
INSERT INTO grcsbl_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","μηδὲ γογγύζετε, ⸀καθάπερτινὲς αὐτῶν ἐγόγγυσαν, καὶ ἀπώλοντο ὑπὸ τοῦ ὀλοθρευτοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ταῦτα ⸀δὲ⸂τυπικῶς συνέβαινεν ἐκείνοις, ἐγράφη δὲ πρὸς νουθεσίαν ἡμῶν, εἰς οὓς τὰ τέλη τῶν αἰώνων ⸀κατήντηκεν ");
INSERT INTO grcsbl_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ὥστε ὁ δοκῶν ἑστάναι βλεπέτω μὴ πέσῃ, ");
INSERT INTO grcsbl_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","πειρασμὸς ὑμᾶς οὐκ εἴληφεν εἰ μὴ ἀνθρώπινος· πιστὸς δὲ ὁ θεός, ὃς οὐκ ἐάσει ὑμᾶς πειρασθῆναι ὑπὲρ ὃ δύνασθε, ἀλλὰ ποιήσει σὺν τῷ πειρασμῷ καὶ τὴν ἔκβασιν τοῦ ⸀δύνασθαιὑπενεγκεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Διόπερ, ἀγαπητοί μου, φεύγετε ἀπὸ τῆς εἰδωλολατρίας. ");
INSERT INTO grcsbl_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ὡς φρονίμοις λέγω· κρίνατε ὑμεῖς ὅ φημι. ");
INSERT INTO grcsbl_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","τὸ ποτήριον τῆς εὐλογίας ὃ εὐλογοῦμεν, οὐχὶ κοινωνία ⸂ἐστὶν τοῦ αἵματος τοῦ Χριστοῦ; τὸν ἄρτον ὃν κλῶμεν, οὐχὶ κοινωνία τοῦ σώματος τοῦ Χριστοῦ ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ὅτι εἷς ἄρτος, ἓν σῶμα οἱ πολλοί ἐσμεν, οἱ γὰρ πάντες ἐκ τοῦ ἑνὸς ἄρτου μετέχομεν. ");
INSERT INTO grcsbl_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","βλέπετε τὸν Ἰσραὴλ κατὰ σάρκα· ⸀οὐχοἱ ἐσθίοντες τὰς θυσίας κοινωνοὶ τοῦ θυσιαστηρίου εἰσίν; ");
INSERT INTO grcsbl_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","τί οὖν φημι; ὅτι ⸂εἰδωλόθυτόν τί ἐστιν, ἢ ὅτι εἴδωλόν τί ἐστιν; ");
INSERT INTO grcsbl_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ἀλλʼ ὅτι ἃ ⸀θύουσιν δαιμονίοις ⸂καὶ οὐ θεῷ θύουσιν, οὐ θέλω δὲ ὑμᾶς κοινωνοὺς τῶν δαιμονίων γίνεσθαι. ");
INSERT INTO grcsbl_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","οὐ δύνασθε ποτήριον κυρίου πίνειν καὶ ποτήριον δαιμονίων· οὐ δύνασθε τραπέζης κυρίου μετέχειν καὶ τραπέζης δαιμονίων. ");
INSERT INTO grcsbl_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ἢ παραζηλοῦμεν τὸν κύριον; μὴ ἰσχυρότεροι αὐτοῦ ἐσμεν; ");
INSERT INTO grcsbl_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","⸀Πάνταἔξεστιν· ἀλλʼ οὐ πάντα συμφέρει. ⸁πάνταἔξεστιν· ἀλλʼ οὐ πάντα οἰκοδομεῖ. ");
INSERT INTO grcsbl_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","μηδεὶς τὸ ἑαυτοῦ ζητείτω ἀλλὰ τὸ τοῦ ⸀ἑτέρου ");
INSERT INTO grcsbl_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","πᾶν τὸ ἐν μακέλλῳ πωλούμενον ἐσθίετε μηδὲν ἀνακρίνοντες διὰ τὴν συνείδησιν, ");
INSERT INTO grcsbl_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","τοῦ ⸂κυρίου γὰρ ἡ γῆ καὶ τὸ πλήρωμα αὐτῆς. ");
INSERT INTO grcsbl_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","⸀εἴτις καλεῖ ὑμᾶς τῶν ἀπίστων καὶ θέλετε πορεύεσθαι, πᾶν τὸ παρατιθέμενον ὑμῖν ἐσθίετε μηδὲν ἀνακρίνοντες διὰ τὴν συνείδησιν· ");
INSERT INTO grcsbl_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ἐὰν δέ τις ὑμῖν εἴπῃ· Τοῦτο ⸀ἱερόθυτόνἐστιν, μὴ ἐσθίετε διʼ ἐκεῖνον τὸν μηνύσαντα καὶ τὴν ⸀συνείδησιν ");
INSERT INTO grcsbl_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","συνείδησιν δὲ λέγω οὐχὶ τὴν ἑαυτοῦ ἀλλὰ τὴν τοῦ ἑτέρου· ἱνατί γὰρ ἡ ἐλευθερία μου κρίνεται ὑπὸ ἄλλης συνειδήσεως; ");
INSERT INTO grcsbl_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","εἰ ἐγὼ χάριτι μετέχω, τί βλασφημοῦμαι ὑπὲρ οὗ ἐγὼ εὐχαριστῶ; ");
INSERT INTO grcsbl_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Εἴτε οὖν ἐσθίετε εἴτε πίνετε εἴτε τι ποιεῖτε, πάντα εἰς δόξαν θεοῦ ποιεῖτε. ");
INSERT INTO grcsbl_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ἀπρόσκοποι ⸂καὶ Ἰουδαίοις γίνεσθε καὶ Ἕλλησιν καὶ τῇ ἐκκλησίᾳ τοῦ θεοῦ, ");
INSERT INTO grcsbl_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","καθὼς κἀγὼ πάντα πᾶσιν ἀρέσκω, μὴ ζητῶν τὸ ἐμαυτοῦ ⸀σύμφορονἀλλὰ τὸ τῶν πολλῶν, ἵνα σωθῶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","μιμηταί μου γίνεσθε, καθὼς κἀγὼ Χριστοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ἐπαινῶ δὲ ⸀ὑμᾶςὅτι πάντα μου μέμνησθε καὶ καθὼς παρέδωκα ὑμῖν τὰς παραδόσεις κατέχετε. ");
INSERT INTO grcsbl_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","θέλω δὲ ὑμᾶς εἰδέναι ὅτι παντὸς ἀνδρὸς ἡ κεφαλὴ ὁ Χριστός ἐστιν, κεφαλὴ δὲ γυναικὸς ὁ ἀνήρ, κεφαλὴ δὲ ⸀τοῦΧριστοῦ ὁ θεός. ");
INSERT INTO grcsbl_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","πᾶς ἀνὴρ προσευχόμενος ἢ προφητεύων κατὰ κεφαλῆς ἔχων καταισχύνει τὴν κεφαλὴν αὐτοῦ· ");
INSERT INTO grcsbl_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","πᾶσα δὲ γυνὴ προσευχομένη ἢ προφητεύουσα ἀκατακαλύπτῳ τῇ κεφαλῇ καταισχύνει τὴν κεφαλὴν ⸀αὐτῆς ἓν γάρ ἐστιν καὶ τὸ αὐτὸ τῇ ἐξυρημένῃ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","εἰ γὰρ οὐ κατακαλύπτεται γυνή, καὶ κειράσθω· εἰ δὲ αἰσχρὸν γυναικὶ τὸ κείρασθαι ἢ ξυρᾶσθαι, κατακαλυπτέσθω. ");
INSERT INTO grcsbl_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ἀνὴρ μὲν γὰρ οὐκ ὀφείλει κατακαλύπτεσθαι τὴν κεφαλήν, εἰκὼν καὶ δόξα θεοῦ ὑπάρχων· ⸀ἡγυνὴ δὲ δόξα ἀνδρός ἐστιν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","οὐ γάρ ἐστιν ἀνὴρ ἐκ γυναικός, ἀλλὰ γυνὴ ἐξ ἀνδρός· ");
INSERT INTO grcsbl_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","καὶ γὰρ οὐκ ἐκτίσθη ἀνὴρ διὰ τὴν γυναῖκα, ἀλλὰ γυνὴ διὰ τὸν ἄνδρα. ");
INSERT INTO grcsbl_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","διὰ τοῦτο ὀφείλει ἡ γυνὴ ἐξουσίαν ἔχειν ἐπὶ τῆς κεφαλῆς διὰ τοὺς ἀγγέλους. ");
INSERT INTO grcsbl_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","πλὴν οὔτε ⸂γυνὴ χωρὶς ἀνδρὸς οὔτε ἀνὴρ χωρὶς γυναικὸς ἐν κυρίῳ· ");
INSERT INTO grcsbl_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ὥσπερ γὰρ ἡ γυνὴ ἐκ τοῦ ἀνδρός, οὕτως καὶ ὁ ἀνὴρ διὰ τῆς γυναικός· τὰ δὲ πάντα ἐκ τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ἐν ὑμῖν αὐτοῖς κρίνατε· πρέπον ἐστὶν γυναῖκα ἀκατακάλυπτον τῷ θεῷ προσεύχεσθαι; ");
INSERT INTO grcsbl_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","⸀οὐδὲ⸂ἡ φύσις αὐτὴ διδάσκει ὑμᾶς ὅτι ἀνὴρ μὲν ἐὰν κομᾷ, ἀτιμία αὐτῷ ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","γυνὴ δὲ ἐὰν κομᾷ, δόξα αὐτῇ ἐστιν; ὅτι ἡ κόμη ἀντὶ περιβολαίου ⸀δέδοται ");
INSERT INTO grcsbl_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","εἰ δέ τις δοκεῖ φιλόνεικος εἶναι, ἡμεῖς τοιαύτην συνήθειαν οὐκ ἔχομεν, οὐδὲ αἱ ἐκκλησίαι τοῦ θεοῦ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Τοῦτο δὲ ⸂παραγγέλλων οὐκ ἐπαινῶ ὅτι οὐκ εἰς τὸ κρεῖσσον ἀλλὰ εἰς τὸ ἧσσον συνέρχεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","πρῶτον μὲν γὰρ συνερχομένων ὑμῶν ἐν ἐκκλησίᾳ ἀκούω σχίσματα ἐν ὑμῖν ὑπάρχειν, καὶ μέρος τι πιστεύω. ");
INSERT INTO grcsbl_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","δεῖ γὰρ καὶαἱρέσεις ἐν ὑμῖν εἶναι, ἵνα ⸀καὶ οἱ δόκιμοι φανεροὶ γένωνται ἐν ὑμῖν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","συνερχομένων οὖν ὑμῶν ἐπὶ τὸ αὐτὸ οὐκ ἔστιν κυριακὸν δεῖπνον φαγεῖν, ");
INSERT INTO grcsbl_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ἕκαστος γὰρ τὸ ἴδιον δεῖπνον προλαμβάνει ἐν τῷ φαγεῖν, καὶ ὃς μὲν πεινᾷ, ὃς δὲ μεθύει. ");
INSERT INTO grcsbl_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","μὴ γὰρ οἰκίας οὐκ ἔχετε εἰς τὸ ἐσθίειν καὶ πίνειν; ἢ τῆς ἐκκλησίας τοῦ θεοῦ καταφρονεῖτε, καὶ καταισχύνετε τοὺς μὴ ἔχοντας; τί ⸂εἴπω ὑμῖν; ἐπαινέσω ὑμᾶς; ἐν τούτῳ οὐκ ἐπαινῶ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Ἐγὼ γὰρ παρέλαβον ἀπὸ τοῦ κυρίου, ὃ καὶ παρέδωκα ὑμῖν, ὅτι ὁ κύριος Ἰησοῦς ἐν τῇ νυκτὶ ᾗ ⸀παρεδίδετοἔλαβεν ἄρτον ");
INSERT INTO grcsbl_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","καὶ εὐχαριστήσας ἔκλασεν καὶ ⸀εἶπεν Τοῦτό μού ἐστιν τὸ σῶμα τὸ ὑπὲρ ⸀ὑμῶν τοῦτο ποιεῖτε εἰς τὴν ἐμὴν ἀνάμνησιν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ὡσαύτως καὶ τὸ ποτήριον μετὰ τὸ δειπνῆσαι, λέγων· Τοῦτο τὸ ποτήριον ἡ καινὴ διαθήκη ἐστὶν ἐν τῷ ἐμῷ αἵματι· τοῦτο ποιεῖτε, ὁσάκις ⸀ἐὰνπίνητε, εἰς τὴν ἐμὴν ἀνάμνησιν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ὁσάκις γὰρ ⸀ἐὰνἐσθίητε τὸν ἄρτον τοῦτον καὶ τὸ ⸀ποτήριονπίνητε, τὸν θάνατον τοῦ κυρίου καταγγέλλετε, ἄχρι ⸀οὗἔλθῃ. ");
INSERT INTO grcsbl_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Ὥστε ὃς ἂν ἐσθίῃ τὸν ⸀ἄρτονἢ πίνῃ τὸ ποτήριον τοῦ κυρίου ⸀ἀναξίως ἔνοχος ἔσται τοῦ σώματος καὶ τοῦ αἵματος τοῦ κυρίου. ");
INSERT INTO grcsbl_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","δοκιμαζέτω δὲ ἄνθρωπος ἑαυτόν, καὶ οὕτως ἐκ τοῦ ἄρτου ἐσθιέτω καὶ ἐκ τοῦ ποτηρίου πινέτω· ");
INSERT INTO grcsbl_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ὁ γὰρ ἐσθίων καὶ ⸀πίνωνκρίμα ἑαυτῷ ἐσθίει καὶ πίνει μὴ διακρίνων τὸ ⸀σῶμα ");
INSERT INTO grcsbl_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","διὰ τοῦτο ἐν ὑμῖν πολλοὶ ἀσθενεῖς καὶ ἄρρωστοι καὶ κοιμῶνται ἱκανοί. ");
INSERT INTO grcsbl_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","εἰ ⸀δὲἑαυτοὺς διεκρίνομεν, οὐκ ἂν ἐκρινόμεθα· ");
INSERT INTO grcsbl_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","κρινόμενοι δὲ ⸀ὑπὸκυρίου παιδευόμεθα, ἵνα μὴ σὺν τῷ κόσμῳ κατακριθῶμεν. ");
INSERT INTO grcsbl_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Ὥστε, ἀδελφοί μου, συνερχόμενοι εἰς τὸ φαγεῖν ἀλλήλους ἐκδέχεσθε. ");
INSERT INTO grcsbl_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","⸀εἴτις πεινᾷ, ἐν οἴκῳ ἐσθιέτω, ἵνα μὴ εἰς κρίμα συνέρχησθε. Τὰ δὲ λοιπὰ ὡς ἂν ἔλθω διατάξομαι. ");
INSERT INTO grcsbl_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Περὶ δὲ τῶν πνευματικῶν, ἀδελφοί, οὐ θέλω ὑμᾶς ἀγνοεῖν. ");
INSERT INTO grcsbl_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","οἴδατε ὅτι ὅτε ἔθνη ἦτε πρὸς τὰ εἴδωλα τὰ ἄφωνα ὡς ἂν ἤγεσθε ἀπαγόμενοι. ");
INSERT INTO grcsbl_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","διὸ γνωρίζω ὑμῖν ὅτι οὐδεὶς ἐν πνεύματι θεοῦ λαλῶν λέγει· Ἀνάθεμα ⸀Ἰησοῦς καὶ οὐδεὶς δύναται εἰπεῖν· ⸂Κύριος Ἰησοῦς εἰ μὴ ἐν πνεύματι ἁγίῳ. ");
INSERT INTO grcsbl_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Διαιρέσεις δὲ χαρισμάτων εἰσίν, τὸ δὲ αὐτὸ πνεῦμα· ");
INSERT INTO grcsbl_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","καὶ διαιρέσεις διακονιῶν εἰσιν, καὶ ὁ αὐτὸς κύριος· ");
INSERT INTO grcsbl_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","καὶ διαιρέσεις ἐνεργημάτων εἰσίν, ⸂ὁ δὲ ⸀αὐτὸςθεός, ὁ ἐνεργῶν τὰ πάντα ἐν πᾶσιν. ");
INSERT INTO grcsbl_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ἑκάστῳ δὲ δίδοται ἡ φανέρωσις τοῦ πνεύματος πρὸς τὸ συμφέρον. ");
INSERT INTO grcsbl_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ᾧ μὲν γὰρ διὰ τοῦ πνεύματος δίδοται λόγος σοφίας, ἄλλῳ δὲ λόγος γνώσεως κατὰ τὸ αὐτὸ πνεῦμα, ");
INSERT INTO grcsbl_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","⸀ἑτέρῳπίστις ἐν τῷ αὐτῷ πνεύματι, ⸀ἄλλῳχαρίσματα ἰαμάτων ἐν τῷ ⸀ἑνὶπνεύματι, ");
INSERT INTO grcsbl_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","⸀ἄλλῳἐνεργήματα δυνάμεων, ⸁ἄλλῳπροφητεία, ⸀1ἄλλῳδιακρίσεις πνευμάτων, ⸀ἑτέρῳγένη γλωσσῶν, ⸀2ἄλλῳἑρμηνεία γλωσσῶν· ");
INSERT INTO grcsbl_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","πάντα δὲ ταῦτα ἐνεργεῖ τὸ ἓν καὶ τὸ αὐτὸ πνεῦμα, διαιροῦν ἰδίᾳ ἑκάστῳ καθὼς βούλεται. ");
INSERT INTO grcsbl_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Καθάπερ γὰρ τὸ σῶμα ἕν ἐστιν καὶ μέλη ⸂πολλὰ ἔχει, πάντα δὲ τὰ μέλη τοῦ ⸀σώματοςπολλὰ ὄντα ἕν ἐστιν σῶμα, οὕτως καὶ ὁ Χριστός· ");
INSERT INTO grcsbl_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","καὶ γὰρ ἐν ἑνὶ πνεύματι ἡμεῖς πάντεςεἰς ἓν σῶμα ἐβαπτίσθημεν, εἴτε Ἰουδαῖοι εἴτε Ἕλληνες, εἴτε δοῦλοι εἴτε ἐλεύθεροι, καὶ ⸀πάντες ἓν πνεῦμα ἐποτίσθημεν. ");
INSERT INTO grcsbl_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Καὶ γὰρ τὸ σῶμα οὐκ ἔστιν ἓν μέλος ἀλλὰ πολλά. ");
INSERT INTO grcsbl_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ἐὰν εἴπῃ ὁ πούς· Ὅτι οὐκ εἰμὶ χείρ, οὐκ εἰμὶ ἐκ τοῦ σώματος, οὐ παρὰ τοῦτο οὐκ ἔστιν ἐκ τοῦ σώματος; ");
INSERT INTO grcsbl_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","καὶ ἐὰν εἴπῃ τὸ οὖς· Ὅτι οὐκ εἰμὶ ὀφθαλμός, οὐκ εἰμὶ ἐκ τοῦ σώματος, οὐ παρὰ τοῦτο οὐκ ἔστιν ἐκ τοῦ σώματος· ");
INSERT INTO grcsbl_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","εἰ ὅλον τὸ σῶμα ὀφθαλμός, ποῦ ἡ ἀκοή; εἰ ὅλον ἀκοή, ποῦ ἡ ὄσφρησις; ");
INSERT INTO grcsbl_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","⸀νυνὶδὲ ὁ θεὸς ἔθετο τὰ μέλη, ἓν ἕκαστον αὐτῶν, ἐν τῷ σώματι καθὼς ἠθέλησεν. ");
INSERT INTO grcsbl_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","εἰ δὲ ἦν τὰ πάντα ἓν μέλος, ποῦ τὸ σῶμα; ");
INSERT INTO grcsbl_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","νῦν δὲ πολλὰ ⸀μὲνμέλη, ἓν δὲ σῶμα. ");
INSERT INTO grcsbl_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","οὐ δύναται δὲ ὁ ὀφθαλμὸς εἰπεῖν τῇ χειρί· Χρείαν σου οὐκ ἔχω, ἢ πάλιν ἡ κεφαλὴ τοῖς ποσίν· Χρείαν ὑμῶν οὐκ ἔχω· ");
INSERT INTO grcsbl_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ἀλλὰ πολλῷ μᾶλλον τὰ δοκοῦντα μέλη τοῦ σώματος ἀσθενέστερα ὑπάρχειν ἀναγκαῖά ἐστιν, ");
INSERT INTO grcsbl_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","καὶ ἃ δοκοῦμεν ἀτιμότερα εἶναι τοῦ σώματος, τούτοις τιμὴν περισσοτέραν περιτίθεμεν, καὶ τὰ ἀσχήμονα ἡμῶν εὐσχημοσύνην περισσοτέραν ἔχει, ");
INSERT INTO grcsbl_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","τὰ δὲ εὐσχήμονα ἡμῶν οὐ χρείαν ⸀ἔχει ἀλλὰ ὁ θεὸς συνεκέρασεν τὸ σῶμα, τῷ ⸀ὑστεροῦντιπερισσοτέραν δοὺς τιμήν, ");
INSERT INTO grcsbl_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ἵνα μὴ ᾖ ⸀σχίσμαἐν τῷ σώματι, ἀλλὰ τὸ αὐτὸ ὑπὲρ ἀλλήλων μεριμνῶσι τὰ μέλη. ");
INSERT INTO grcsbl_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","καὶ ⸀εἴτεπάσχει ἓν μέλος συμπάσχει πάντα τὰ μέλη· εἴτε δοξάζεται ⸀μέλος, συγχαίρει πάντα τὰ μέλη. ");
INSERT INTO grcsbl_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Ὑμεῖς δέ ἐστε σῶμα Χριστοῦ καὶ μέλη ἐκ μέρους. ");
INSERT INTO grcsbl_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","καὶ οὓς μὲν ἔθετο ὁ θεὸς ἐν τῇ ἐκκλησίᾳ πρῶτον ἀποστόλους, δεύτερον προφήτας, τρίτον διδασκάλους, ἔπειταδυνάμεις, ⸀ἔπειτα χαρίσματα ἰαμάτων, ἀντιλήμψεις, κυβερνήσεις, γένη γλωσσῶν. ");
INSERT INTO grcsbl_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","μὴ πάντες ἀπόστολοι; μὴ πάντες προφῆται; μὴ πάντες διδάσκαλοι; μὴ πάντες δυνάμεις; ");
INSERT INTO grcsbl_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","μὴ πάντες χαρίσματα ἔχουσιν ἰαμάτων; μὴ πάντες γλώσσαις λαλοῦσιν; μὴ πάντες διερμηνεύουσιν; ");
INSERT INTO grcsbl_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ζηλοῦτε δὲ τὰ χαρίσματα τὰ ⸀μείζονα καὶ ἔτι καθʼ ὑπερβολὴν ὁδὸ