﻿USE sofia;
DROP TABLE IF EXISTS sofia.grcmt_vpl;
CREATE TABLE grcmt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES grcmt_vpl WRITE;
INSERT INTO grcmt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," βιβλοσ γενεσεωσ ιησου χριστου υιου δαυιδ υιου αβρααμ ");
INSERT INTO grcmt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","αβρααμ εγεννησεν τον ισαακ ισαακ δε εγεννησεν τον ιακωβ ιακωβ δε εγεννησεν τον ιουδαν και τουσ αδελφουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ιουδασ δε εγεννησεν τον φαρεσ και τον ζαρα εκ τησ θαμαρ φαρεσ δε εγεννησεν τον εσρωμ εσρωμ δε εγεννησεν τον αραμ ");
INSERT INTO grcmt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","αραμ δε εγεννησεν τον αμιναδαβ αμιναδαβ δε εγεννησεν τον ναασσων ναασσων δε εγεννησεν τον σαλμων ");
INSERT INTO grcmt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","σαλμων δε εγεννησεν τον βοοζ εκ τησ ραχαβ βοοζ δε εγεννησεν τον ωβηδ εκ τησ ρουθ ωβηδ δε εγεννησεν τον ιεσσαι ");
INSERT INTO grcmt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ιεσσαι δε εγεννησεν τον δαυιδ τον βασιλεα δαυιδ δε ο βασιλευσ εγεννησεν τον σολομωνα εκ τησ του ουριου ");
INSERT INTO grcmt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","σολομων δε εγεννησεν τον ροβοαμ ροβοαμ δε εγεννησεν τον αβια αβια δε εγεννησεν τον ασα ");
INSERT INTO grcmt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ασα δε εγεννησεν τον ιωσαφατ ιωσαφατ δε εγεννησεν τον ιωραμ ιωραμ δε εγεννησεν τον οζιαν ");
INSERT INTO grcmt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","οζιασ δε εγεννησεν τον ιωαθαμ ιωαθαμ δε εγεννησεν τον αχαζ αχαζ δε εγεννησεν τον εζεκιαν ");
INSERT INTO grcmt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","εζεκιασ δε εγεννησεν τον μανασση μανασσησ δε εγεννησεν τον αμων αμων δε εγεννησεν τον ιωσιαν ");
INSERT INTO grcmt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ιωσιασ δε εγεννησεν τον ιεχονιαν και τουσ αδελφουσ αυτου επι τησ μετοικεσιασ βαβυλωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","μετα δε την μετοικεσιαν βαβυλωνοσ ιεχονιασ εγεννησεν τον σαλαθιηλ σαλαθιηλ δε εγεννησεν τον ζοροβαβελ ");
INSERT INTO grcmt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ζοροβαβελ δε εγεννησεν τον αβιουδ αβιουδ δε εγεννησεν τον ελιακειμ ελιακειμ δε εγεννησεν τον αζωρ ");
INSERT INTO grcmt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","αζωρ δε εγεννησεν τον σαδωκ σαδωκ δε εγεννησεν τον αχειμ αχειμ δε εγεννησεν τον ελιουδ ");
INSERT INTO grcmt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ελιουδ δε εγεννησεν τον ελεαζαρ ελεαζαρ δε εγεννησεν τον ματθαν ματθαν δε εγεννησεν τον ιακωβ ");
INSERT INTO grcmt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ιακωβ δε εγεννησεν τον ιωσηφ τον ανδρα μαριασ εξ ησ εγεννηθη ιησουσ ο λεγομενοσ χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","πασαι ουν αι γενεαι απο αβρααμ εωσ δαυιδ γενεαι δεκατεσσαρεσ και απο δαυιδ εωσ τησ μετοικεσιασ βαβυλωνοσ γενεαι δεκατεσσαρεσ και απο τησ μετοικεσιασ βαβυλωνοσ εωσ του χριστου γενεαι δεκατεσσαρεσ ");
INSERT INTO grcmt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","του δε ιησου χριστου η γεννησισ ουτωσ ην μνηστευθεισησ γαρ τησ μητροσ αυτου μαριασ τω ιωσηφ πριν η συνελθειν αυτουσ ευρεθη εν γαστρι εχουσα εκ πνευματοσ αγιου ");
INSERT INTO grcmt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ιωσηφ δε ο ανηρ αυτησ δικαιοσ ων και μη θελων αυτην παραδειγματισαι εβουληθη λαθρα απολυσαι αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ταυτα δε αυτου ενθυμηθεντοσ ιδου αγγελοσ κυριου κατ οναρ εφανη αυτω λεγων ιωσηφ υιοσ δαυιδ μη φοβηθησ παραλαβειν μαριαμ την γυναικα σου το γαρ εν αυτη γεννηθεν εκ πνευματοσ εστιν αγιου ");
INSERT INTO grcmt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","τεξεται δε υιον και καλεσεισ το ονομα αυτου ιησουν αυτοσ γαρ σωσει τον λαον αυτου απο των αμαρτιων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","τουτο δε ολον γεγονεν ινα πληρωθη το ρηθεν υπο του κυριου δια του προφητου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ιδου η παρθενοσ εν γαστρι εξει και τεξεται υιον και καλεσουσιν το ονομα αυτου εμμανουηλ ο εστιν μεθερμηνευομενον μεθ ημων ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","διεγερθεισ δε ο ιωσηφ απο του υπνου εποιησεν ωσ προσεταξεν αυτω ο αγγελοσ κυριου και παρελαβεν την γυναικα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","και ουκ εγινωσκεν αυτην εωσ ου ετεκεν τον υιον αυτησ τον πρωτοτοκον και εκαλεσεν το ονομα αυτου ιησουν ");
INSERT INTO grcmt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","του δε ιησου γεννηθεντοσ εν βηθλεεμ τησ ιουδαιασ εν ημεραισ ηρωδου του βασιλεωσ ιδου μαγοι απο ανατολων παρεγενοντο εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","λεγοντεσ που εστιν ο τεχθεισ βασιλευσ των ιουδαιων ειδομεν γαρ αυτου τον αστερα εν τη ανατολη και ηλθομεν προσκυνησαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ακουσασ δε ηρωδησ ο βασιλευσ εταραχθη και πασα ιεροσολυμα μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","και συναγαγων παντασ τουσ αρχιερεισ και γραμματεισ του λαου επυνθανετο παρ αυτων που ο χριστοσ γενναται ");
INSERT INTO grcmt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","οι δε ειπον αυτω εν βηθλεεμ τησ ιουδαιασ ουτωσ γαρ γεγραπται δια του προφητου ");
INSERT INTO grcmt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","και συ βηθλεεμ γη ιουδα ουδαμωσ ελαχιστη ει εν τοισ ηγεμοσιν ιουδα εκ σου γαρ εξελευσεται ηγουμενοσ οστισ ποιμανει τον λαον μου τον ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","τοτε ηρωδησ λαθρα καλεσασ τουσ μαγουσ ηκριβωσεν παρ αυτων τον χρονον του φαινομενου αστεροσ ");
INSERT INTO grcmt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","και πεμψασ αυτουσ εισ βηθλεεμ ειπεν πορευθεντεσ ακριβωσ εξετασατε περι του παιδιου επαν δε ευρητε απαγγειλατε μοι οπωσ καγω ελθων προσκυνησω αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","οι δε ακουσαντεσ του βασιλεωσ επορευθησαν και ιδου ο αστηρ ον ειδον εν τη ανατολη προηγεν αυτουσ εωσ ελθων εστη επανω ου ην το παιδιον ");
INSERT INTO grcmt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ιδοντεσ δε τον αστερα εχαρησαν χαραν μεγαλην σφοδρα ");
INSERT INTO grcmt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","και ελθοντεσ εισ την οικιαν ειδον το παιδιον μετα μαριασ τησ μητροσ αυτου και πεσοντεσ προσεκυνησαν αυτω και ανοιξαντεσ τουσ θησαυρουσ αυτων προσηνεγκαν αυτω δωρα χρυσον και λιβανον και σμυρναν ");
INSERT INTO grcmt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","και χρηματισθεντεσ κατ οναρ μη ανακαμψαι προσ ηρωδην δι αλλησ οδου ανεχωρησαν εισ την χωραν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","αναχωρησαντων δε αυτων ιδου αγγελοσ κυριου φαινεται κατ οναρ τω ιωσηφ λεγων εγερθεισ παραλαβε το παιδιον και την μητερα αυτου και φευγε εισ αιγυπτον και ισθι εκει εωσ αν ειπω σοι μελλει γαρ ηρωδησ ζητειν το παιδιον του απολεσαι αυτο ");
INSERT INTO grcmt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ο δε εγερθεισ παρελαβεν το παιδιον και την μητερα αυτου νυκτοσ και ανεχωρησεν εισ αιγυπτον ");
INSERT INTO grcmt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","και ην εκει εωσ τησ τελευτησ ηρωδου ινα πληρωθη το ρηθεν υπο του κυριου δια του προφητου λεγοντοσ εξ αιγυπτου εκαλεσα τον υιον μου ");
INSERT INTO grcmt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","τοτε ηρωδησ ιδων οτι ενεπαιχθη υπο των μαγων εθυμωθη λιαν και αποστειλασ ανειλεν παντασ τουσ παιδασ τουσ εν βηθλεεμ και εν πασιν τοισ οριοισ αυτησ απο διετουσ και κατωτερω κατα τον χρονον ον ηκριβωσεν παρα των μαγων ");
INSERT INTO grcmt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","τοτε επληρωθη το ρηθεν υπο ιερεμιου του προφητου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","φωνη εν ραμα ηκουσθη θρηνοσ και κλαυθμοσ και οδυρμοσ πολυσ ραχηλ κλαιουσα τα τεκνα αυτησ και ουκ ηθελεν παρακληθηναι οτι ουκ εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","τελευτησαντοσ δε του ηρωδου ιδου αγγελοσ κυριου κατ οναρ φαινεται τω ιωσηφ εν αιγυπτω ");
INSERT INTO grcmt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","λεγων εγερθεισ παραλαβε το παιδιον και την μητερα αυτου και πορευου εισ γην ισραηλ τεθνηκασιν γαρ οι ζητουντεσ την ψυχην του παιδιου ");
INSERT INTO grcmt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ο δε εγερθεισ παρελαβεν το παιδιον και την μητερα αυτου και ηλθεν εισ γην ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ακουσασ δε οτι αρχελαοσ βασιλευει επι τησ ιουδαιασ αντι ηρωδου του πατροσ αυτου εφοβηθη εκει απελθειν χρηματισθεισ δε κατ οναρ ανεχωρησεν εισ τα μερη τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","και ελθων κατωκησεν εισ πολιν λεγομενην ναζαρετ οπωσ πληρωθη το ρηθεν δια των προφητων οτι ναζωραιοσ κληθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","εν δε ταισ ημεραισ εκειναισ παραγινεται ιωαννησ ο βαπτιστησ κηρυσσων εν τη ερημω τησ ιουδαιασ ");
INSERT INTO grcmt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","και λεγων μετανοειτε ηγγικεν γαρ η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ουτοσ γαρ εστιν ο ρηθεισ υπο ησαιου του προφητου λεγοντοσ φωνη βοωντοσ εν τη ερημω ετοιμασατε την οδον κυριου ευθειασ ποιειτε τασ τριβουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","αυτοσ δε ο ιωαννησ ειχεν το ενδυμα αυτου απο τριχων καμηλου και ζωνην δερματινην περι την οσφυν αυτου η δε τροφη αυτου ην ακριδεσ και μελι αγριον ");
INSERT INTO grcmt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","τοτε εξεπορευετο προσ αυτον ιεροσολυμα και πασα η ιουδαια και πασα η περιχωροσ του ιορδανου ");
INSERT INTO grcmt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","και εβαπτιζοντο εν τω ιορδανη υπ αυτου εξομολογουμενοι τασ αμαρτιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ιδων δε πολλουσ των φαρισαιων και σαδδουκαιων ερχομενουσ επι το βαπτισμα αυτου ειπεν αυτοισ γεννηματα εχιδνων τισ υπεδειξεν υμιν φυγειν απο τησ μελλουσησ οργησ ");
INSERT INTO grcmt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ποιησατε ουν καρπον αξιον τησ μετανοιασ ");
INSERT INTO grcmt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","και μη δοξητε λεγειν εν εαυτοισ πατερα εχομεν τον αβρααμ λεγω γαρ υμιν οτι δυναται ο θεοσ εκ των λιθων τουτων εγειραι τεκνα τω αβρααμ ");
INSERT INTO grcmt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ηδη δε και η αξινη προσ την ριζαν των δενδρων κειται παν ουν δενδρον μη ποιουν καρπον καλον εκκοπτεται και εισ πυρ βαλλεται ");
INSERT INTO grcmt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","εγω μεν βαπτιζω υμασ εν υδατι εισ μετανοιαν ο δε οπισω μου ερχομενοσ ισχυροτεροσ μου εστιν ου ουκ ειμι ικανοσ τα υποδηματα βαστασαι αυτοσ υμασ βαπτισει εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ου το πτυον εν τη χειρι αυτου και διακαθαριει την αλωνα αυτου και συναξει τον σιτον αυτου εισ την αποθηκην το δε αχυρον κατακαυσει πυρι ασβεστω ");
INSERT INTO grcmt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","τοτε παραγινεται ο ιησουσ απο τησ γαλιλαιασ επι τον ιορδανην προσ τον ιωαννην του βαπτισθηναι υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ο δε ιωαννησ διεκωλυεν αυτον λεγων εγω χρειαν εχω υπο σου βαπτισθηναι και συ ερχη προσ με ");
INSERT INTO grcmt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","αποκριθεισ δε ο ιησουσ ειπεν προσ αυτον αφεσ αρτι ουτωσ γαρ πρεπον εστιν ημιν πληρωσαι πασαν δικαιοσυνην τοτε αφιησιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","και βαπτισθεισ ο ιησουσ ανεβη ευθυσ απο του υδατοσ και ιδου ανεωχθησαν αυτω οι ουρανοι και ειδεν το πνευμα του θεου καταβαινον ωσει περιστεραν και ερχομενον επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","και ιδου φωνη εκ των ουρανων λεγουσα ουτοσ εστιν ο υιοσ μου ο αγαπητοσ εν ω ευδοκησα ");
INSERT INTO grcmt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","τοτε ο ιησουσ ανηχθη εισ την ερημον υπο του πνευματοσ πειρασθηναι υπο του διαβολου ");
INSERT INTO grcmt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","και νηστευσασ ημερασ τεσσαρακοντα και νυκτασ τεσσαρακοντα υστερον επεινασεν ");
INSERT INTO grcmt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","και προσελθων αυτω ο πειραζων ειπεν ει υιοσ ει του θεου ειπε ινα οι λιθοι ουτοι αρτοι γενωνται ");
INSERT INTO grcmt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ο δε αποκριθεισ ειπεν γεγραπται ουκ επ αρτω μονω ζησεται ανθρωποσ αλλ επι παντι ρηματι εκπορευομενω δια στοματοσ θεου ");
INSERT INTO grcmt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","τοτε παραλαμβανει αυτον ο διαβολοσ εισ την αγιαν πολιν και ιστησιν αυτον επι το πτερυγιον του ιερου ");
INSERT INTO grcmt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","και λεγει αυτω ει υιοσ ει του θεου βαλε σεαυτον κατω γεγραπται γαρ οτι τοισ αγγελοισ αυτου εντελειται περι σου και επι χειρων αρουσιν σε μηποτε προσκοψησ προσ λιθον τον ποδα σου ");
INSERT INTO grcmt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","εφη αυτω ο ιησουσ παλιν γεγραπται ουκ εκπειρασεισ κυριον τον θεον σου ");
INSERT INTO grcmt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","παλιν παραλαμβανει αυτον ο διαβολοσ εισ οροσ υψηλον λιαν και δεικνυσιν αυτω πασασ τασ βασιλειασ του κοσμου και την δοξαν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","και λεγει αυτω ταυτα παντα σοι δωσω εαν πεσων προσκυνησησ μοι ");
INSERT INTO grcmt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","τοτε λεγει αυτω ο ιησουσ υπαγε οπισω μου σατανα γεγραπται γαρ κυριον τον θεον σου προσκυνησεισ και αυτω μονω λατρευσεισ ");
INSERT INTO grcmt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","τοτε αφιησιν αυτον ο διαβολοσ και ιδου αγγελοι προσηλθον και διηκονουν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ακουσασ δε ο ιησουσ οτι ιωαννησ παρεδοθη ανεχωρησεν εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","και καταλιπων την ναζαρετ ελθων κατωκησεν εισ καπερναουμ την παραθαλασσιαν εν οριοισ ζαβουλων και νεφθαλειμ ");
INSERT INTO grcmt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ινα πληρωθη το ρηθεν δια ησαιου του προφητου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","γη 1093 N-NSF ζαβουλων και γη 1093 N-NSF νεφθαλειμ οδον θαλασσησ περαν του ιορδανου γαλιλαια 1056 N-NSF των εθνων ");
INSERT INTO grcmt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ο λαοσ ο καθημενοσ εν σκοτει ειδεν φωσ μεγα και τοισ καθημενοισ εν χωρα και σκια θανατου φωσ ανετειλεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","απο τοτε ηρξατο ο ιησουσ κηρυσσειν και λεγειν μετανοειτε ηγγικεν γαρ η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","περιπατων δε παρα την θαλασσαν τησ γαλιλαιασ ειδεν δυο αδελφουσ σιμωνα τον λεγομενον πετρον και ανδρεαν τον αδελφον αυτου βαλλοντασ αμφιβληστρον εισ την θαλασσαν ησαν γαρ αλιεισ ");
INSERT INTO grcmt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","και λεγει αυτοισ δευτε οπισω μου και ποιησω υμασ αλιεισ ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","οι δε ευθεωσ αφεντεσ τα δικτυα ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","και προβασ εκειθεν ειδεν αλλουσ δυο αδελφουσ ιακωβον τον του ζεβεδαιου και ιωαννην τον αδελφον αυτου εν τω πλοιω μετα ζεβεδαιου του πατροσ αυτων καταρτιζοντασ τα δικτυα αυτων και εκαλεσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","οι δε ευθεωσ αφεντεσ το πλοιον και τον πατερα αυτων ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","και περιηγεν ολην την γαλιλαιαν ο ιησουσ διδασκων εν ταισ συναγωγαισ αυτων και κηρυσσων το ευαγγελιον τησ βασιλειασ και θεραπευων πασαν νοσον και πασαν μαλακιαν εν τω λαω ");
INSERT INTO grcmt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","και απηλθεν η ακοη αυτου εισ ολην την συριαν και προσηνεγκαν αυτω παντασ τουσ κακωσ εχοντασ ποικιλαισ νοσοισ και βασανοισ συνεχομενουσ και δαιμονιζομενουσ και σεληνιαζομενουσ και παραλυτικουσ και εθεραπευσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","και ηκολουθησαν αυτω οχλοι πολλοι απο τησ γαλιλαιασ και δεκαπολεωσ και ιεροσολυμων και ιουδαιασ και περαν του ιορδανου ");
INSERT INTO grcmt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ιδων δε τουσ οχλουσ ανεβη εισ το οροσ και καθισαντοσ αυτου προσηλθον αυτω οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","και ανοιξασ το στομα αυτου εδιδασκεν αυτουσ λεγων ");
INSERT INTO grcmt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","μακαριοι οι πτωχοι τω πνευματι οτι αυτων εστιν η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","μακαριοι οι πενθουντεσ οτι αυτοι παρακληθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","μακαριοι οι πραεισ οτι αυτοι κληρονομησουσιν την γην ");
INSERT INTO grcmt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","μακαριοι οι πεινωντεσ και διψωντεσ την δικαιοσυνην οτι αυτοι χορτασθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","μακαριοι οι ελεημονεσ οτι αυτοι ελεηθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","μακαριοι οι καθαροι τη καρδια οτι αυτοι τον θεον οψονται ");
INSERT INTO grcmt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","μακαριοι οι ειρηνοποιοι οτι αυτοι υιοι θεου κληθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","μακαριοι οι δεδιωγμενοι ενεκεν δικαιοσυνησ οτι αυτων εστιν η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","μακαριοι εστε οταν ονειδισωσιν υμασ και διωξωσιν και ειπωσιν παν πονηρον ρημα καθ υμων ψευδομενοι ενεκεν εμου ");
INSERT INTO grcmt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","χαιρετε και αγαλλιασθε οτι ο μισθοσ υμων πολυσ εν τοισ ουρανοισ ουτωσ γαρ εδιωξαν τουσ προφητασ τουσ προ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","υμεισ εστε το αλασ τησ γησ εαν δε το αλασ μωρανθη εν τινι αλισθησεται εισ ουδεν ισχυει ετι ει μη βληθηναι εξω και καταπατεισθαι υπο των ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","υμεισ εστε το φωσ του κοσμου ου δυναται πολισ κρυβηναι επανω ορουσ κειμενη ");
INSERT INTO grcmt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ουδε καιουσιν λυχνον και τιθεασιν αυτον υπο τον μοδιον αλλ επι την λυχνιαν και λαμπει πασιν τοισ εν τη οικια ");
INSERT INTO grcmt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ουτωσ λαμψατω το φωσ υμων εμπροσθεν των ανθρωπων οπωσ ιδωσιν υμων τα καλα εργα και δοξασωσιν τον πατερα υμων τον εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","μη νομισητε οτι ηλθον καταλυσαι τον νομον η τουσ προφητασ ουκ ηλθον καταλυσαι αλλα πληρωσαι ");
INSERT INTO grcmt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","αμην γαρ λεγω υμιν εωσ αν παρελθη ο ουρανοσ και η γη ιωτα εν η μια κεραια ου μη παρελθη απο του νομου εωσ αν παντα γενηται ");
INSERT INTO grcmt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","οσ εαν ουν λυση μιαν των εντολων τουτων των ελαχιστων και διδαξη ουτωσ τουσ ανθρωπουσ ελαχιστοσ κληθησεται εν τη βασιλεια των ουρανων οσ δ αν ποιηση και διδαξη ουτοσ μεγασ κληθησεται εν τη βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","λεγω γαρ υμιν οτι εαν μη περισσευση η δικαιοσυνη υμων πλειον των γραμματεων και φαρισαιων ου μη εισελθητε εισ την βασιλειαν των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ηκουσατε οτι ερρεθη τοισ αρχαιοισ ου φονευσεισ οσ δ αν φονευση ενοχοσ εσται τη κρισει ");
INSERT INTO grcmt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","εγω δε λεγω υμιν οτι πασ ο οργιζομενοσ τω αδελφω αυτου εικη ενοχοσ εσται τη κρισει οσ δ αν ειπη τω αδελφω αυτου ρακα ενοχοσ εσται τω συνεδριω οσ δ αν ειπη μωρε ενοχοσ εσται εισ την γεενναν του πυροσ ");
INSERT INTO grcmt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","εαν ουν προσφερησ το δωρον σου επι το θυσιαστηριον και εκει μνησθησ οτι ο αδελφοσ σου εχει τι κατα σου ");
INSERT INTO grcmt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","αφεσ εκει το δωρον σου εμπροσθεν του θυσιαστηριου και υπαγε πρωτον διαλλαγηθι τω αδελφω σου και τοτε ελθων προσφερε το δωρον σου ");
INSERT INTO grcmt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ισθι ευνοων τω αντιδικω σου ταχυ εωσ οτου ει εν τη οδω μετ αυτου μηποτε σε παραδω ο αντιδικοσ τω κριτη και ο κριτησ σε παραδω τω υπηρετη και εισ φυλακην βληθηση ");
INSERT INTO grcmt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","αμην λεγω σοι ου μη εξελθησ εκειθεν εωσ αν αποδωσ τον εσχατον κοδραντην ");
INSERT INTO grcmt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ηκουσατε οτι ερρεθη ου μοιχευσεισ ");
INSERT INTO grcmt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","εγω δε λεγω υμιν οτι πασ ο βλεπων γυναικα προσ το επιθυμησαι αυτην ηδη εμοιχευσεν αυτην εν τη καρδια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ει δε ο οφθαλμοσ σου ο δεξιοσ σκανδαλιζει σε εξελε αυτον και βαλε απο σου συμφερει γαρ σοι ινα αποληται εν των μελων σου και μη ολον το σωμα σου βληθη εισ γεενναν ");
INSERT INTO grcmt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","και ει η δεξια σου χειρ σκανδαλιζει σε εκκοψον αυτην και βαλε απο σου συμφερει γαρ σοι ινα αποληται εν των μελων σου και μη ολον το σωμα σου βληθη εισ γεενναν ");
INSERT INTO grcmt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ερρεθη δε οτι οσ αν απολυση την γυναικα αυτου δοτω αυτη αποστασιον ");
INSERT INTO grcmt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","εγω δε λεγω υμιν οτι οσ αν απολυση την γυναικα αυτου παρεκτοσ λογου πορνειασ ποιει αυτην μοιχασθαι και οσ εαν απολελυμενην γαμηση μοιχαται ");
INSERT INTO grcmt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","παλιν ηκουσατε οτι ερρεθη τοισ αρχαιοισ ουκ επιορκησεισ αποδωσεισ δε τω κυριω τουσ ορκουσ σου ");
INSERT INTO grcmt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","εγω δε λεγω υμιν μη ομοσαι ολωσ μητε εν τω ουρανω οτι θρονοσ εστιν του θεου ");
INSERT INTO grcmt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","μητε εν τη γη οτι υποποδιον εστιν των ποδων αυτου μητε εισ ιεροσολυμα οτι πολισ εστιν του μεγαλου βασιλεωσ ");
INSERT INTO grcmt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","μητε εν τη κεφαλη σου ομοσησ οτι ου δυνασαι μιαν τριχα λευκην η μελαιναν ποιησαι ");
INSERT INTO grcmt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","εστω δε ο λογοσ υμων ναι ναι ου ου το δε περισσον τουτων εκ του πονηρου εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ηκουσατε οτι ερρεθη οφθαλμον αντι οφθαλμου και οδοντα αντι οδοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","εγω δε λεγω υμιν μη αντιστηναι τω πονηρω αλλ οστισ σε ραπισει επι την δεξιαν σιαγονα στρεψον αυτω και την αλλην ");
INSERT INTO grcmt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","και τω θελοντι σοι κριθηναι και τον χιτωνα σου λαβειν αφεσ αυτω και το ιματιον ");
INSERT INTO grcmt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","και οστισ σε αγγαρευσει μιλιον εν υπαγε μετ αυτου δυο ");
INSERT INTO grcmt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","τω αιτουντι σε διδου και τον θελοντα απο σου δανεισασθαι μη αποστραφησ ");
INSERT INTO grcmt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ηκουσατε οτι ερρεθη αγαπησεισ τον πλησιον σου και μισησεισ τον εχθρον σου ");
INSERT INTO grcmt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","εγω δε λεγω υμιν αγαπατε τουσ εχθρουσ υμων ευλογειτε τουσ καταρωμενουσ υμασ καλωσ ποιειτε τοισ μισουσιν υμασ και προσευχεσθε υπερ των επηρεαζοντων υμασ και διωκοντων υμασ ");
INSERT INTO grcmt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","οπωσ γενησθε υιοι του πατροσ υμων του εν τοισ ουρανοισ οτι τον ηλιον αυτου ανατελλει επι πονηρουσ και αγαθουσ και βρεχει επι δικαιουσ και αδικουσ ");
INSERT INTO grcmt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","εαν γαρ αγαπησητε τουσ αγαπωντασ υμασ τινα μισθον εχετε ουχι και οι τελωναι το αυτο ποιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","και εαν ασπασησθε τουσ φιλουσ υμων μονον τι περισσον ποιειτε ουχι και οι τελωναι ουτωσ ποιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","εσεσθε ουν υμεισ τελειοι ωσπερ ο πατηρ υμων ο εν τοισ ουρανοισ τελειοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","προσεχετε την ελεημοσυνην υμων μη ποιειν εμπροσθεν των ανθρωπων προσ το θεαθηναι αυτοισ ει δε μηγε μισθον ουκ εχετε παρα τω πατρι υμων τω εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","οταν ουν ποιησ ελεημοσυνην μη σαλπισησ εμπροσθεν σου ωσπερ οι υποκριται ποιουσιν εν ταισ συναγωγαισ και εν ταισ ρυμαισ οπωσ δοξασθωσιν υπο των ανθρωπων αμην λεγω υμιν απεχουσιν τον μισθον αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","σου δε ποιουντοσ ελεημοσυνην μη γνωτω η αριστερα σου τι ποιει η δεξια σου ");
INSERT INTO grcmt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","οπωσ η σου η ελεημοσυνη εν τω κρυπτω και ο πατηρ σου ο βλεπων εν τω κρυπτω αυτοσ αποδωσει σοι εν τω φανερω ");
INSERT INTO grcmt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","και οταν προσευχη ουκ εση ωσπερ οι υποκριται οτι φιλουσιν εν ταισ συναγωγαισ και εν ταισ γωνιαισ των πλατειων εστωτεσ προσευχεσθαι οπωσ αν φανωσιν τοισ ανθρωποισ αμην λεγω υμιν οτι απεχουσιν τον μισθον αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","συ δε οταν προσευχη εισελθε εισ το ταμιειον σου και κλεισασ την θυραν σου προσευξαι τω πατρι σου τω εν τω κρυπτω και ο πατηρ σου ο βλεπων εν τω κρυπτω αποδωσει σοι εν τω φανερω ");
INSERT INTO grcmt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","προσευχομενοι δε μη βαττολογησητε ωσπερ οι εθνικοι δοκουσιν γαρ οτι εν τη πολυλογια αυτων εισακουσθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","μη ουν ομοιωθητε αυτοισ οιδεν γαρ ο πατηρ υμων ων χρειαν εχετε προ του υμασ αιτησαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ουτωσ ουν προσευχεσθε υμεισ πατερ ημων ο εν τοισ ουρανοισ αγιασθητω το ονομα σου ");
INSERT INTO grcmt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ελθετω η βασιλεια σου γενηθητω το θελημα σου ωσ εν ουρανω και επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","τον αρτον ημων τον επιουσιον δοσ ημιν σημερον ");
INSERT INTO grcmt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","και αφεσ ημιν τα οφειληματα ημων ωσ και ημεισ αφιεμεν τοισ οφειλεταισ ημων ");
INSERT INTO grcmt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","και μη εισενεγκησ ημασ εισ πειρασμον αλλα ρυσαι ημασ απο του πονηρου οτι σου εστιν η βασιλεια και η δυναμισ και η δοξα εισ τουσ αιωνασ αμην ");
INSERT INTO grcmt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","εαν γαρ αφητε τοισ ανθρωποισ τα παραπτωματα αυτων αφησει και υμιν ο πατηρ υμων ο ουρανιοσ ");
INSERT INTO grcmt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","εαν δε μη αφητε τοισ ανθρωποισ τα παραπτωματα αυτων ουδε ο πατηρ υμων αφησει τα παραπτωματα υμων ");
INSERT INTO grcmt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","οταν δε νηστευητε μη γινεσθε ωσπερ οι υποκριται σκυθρωποι αφανιζουσιν γαρ τα προσωπα αυτων οπωσ φανωσιν τοισ ανθρωποισ νηστευοντεσ αμην λεγω υμιν οτι απεχουσιν τον μισθον αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","συ δε νηστευων αλειψαι σου την κεφαλην και το προσωπον σου νιψαι ");
INSERT INTO grcmt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","οπωσ μη φανησ τοισ ανθρωποισ νηστευων αλλα τω πατρι σου τω εν τω κρυπτω και ο πατηρ σου ο βλεπων εν τω κρυπτω αποδωσει σοι ");
INSERT INTO grcmt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","μη θησαυριζετε υμιν θησαυρουσ επι τησ γησ οπου σησ και βρωσισ αφανιζει και οπου κλεπται διορυσσουσιν και κλεπτουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","θησαυριζετε δε υμιν θησαυρουσ εν ουρανω οπου ουτε σησ ουτε βρωσισ αφανιζει και οπου κλεπται ου διορυσσουσιν ουδε κλεπτουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","οπου γαρ εστιν ο θησαυροσ υμων εκει εσται και η καρδια υμων ");
INSERT INTO grcmt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ο λυχνοσ του σωματοσ εστιν ο οφθαλμοσ εαν ουν ο οφθαλμοσ σου απλουσ η ολον το σωμα σου φωτεινον εσται ");
INSERT INTO grcmt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","εαν δε ο οφθαλμοσ σου πονηροσ η ολον το σωμα σου σκοτεινον εσται ει ουν το φωσ το εν σοι σκοτοσ εστιν το σκοτοσ ποσον ");
INSERT INTO grcmt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ουδεισ δυναται δυσιν κυριοισ δουλευειν η γαρ τον ενα μισησει και τον ετερον αγαπησει η ενοσ ανθεξεται και του ετερου καταφρονησει ου δυνασθε θεω δουλευειν και μαμωνα ");
INSERT INTO grcmt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","δια τουτο λεγω υμιν μη μεριμνατε τη ψυχη υμων τι φαγητε και τι πιητε μηδε τω σωματι υμων τι ενδυσησθε ουχι η ψυχη πλειον εστιν τησ τροφησ και το σωμα του ενδυματοσ ");
INSERT INTO grcmt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","εμβλεψατε εισ τα πετεινα του ουρανου οτι ου σπειρουσιν ουδε θεριζουσιν ουδε συναγουσιν εισ αποθηκασ και ο πατηρ υμων ο ουρανιοσ τρεφει αυτα ουχ υμεισ μαλλον διαφερετε αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","τισ δε εξ υμων μεριμνων δυναται προσθειναι επι την ηλικιαν αυτου πηχυν ενα ");
INSERT INTO grcmt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","και περι ενδυματοσ τι μεριμνατε καταμαθετε τα κρινα του αγρου πωσ αυξανει ου κοπια ουδε νηθει ");
INSERT INTO grcmt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","λεγω δε υμιν οτι ουδε σολομων εν παση τη δοξη αυτου περιεβαλετο ωσ εν τουτων ");
INSERT INTO grcmt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ει δε τον χορτον του αγρου σημερον οντα και αυριον εισ κλιβανον βαλλομενον ο θεοσ ουτωσ αμφιεννυσιν ου πολλω μαλλον υμασ ολιγοπιστοι ");
INSERT INTO grcmt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","μη ουν μεριμνησητε λεγοντεσ τι φαγωμεν η τι πιωμεν η τι περιβαλωμεθα ");
INSERT INTO grcmt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","παντα γαρ ταυτα τα εθνη επιζητει οιδεν γαρ ο πατηρ υμων ο ουρανιοσ οτι χρηζετε τουτων απαντων ");
INSERT INTO grcmt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ζητειτε δε πρωτον την βασιλειαν του θεου και την δικαιοσυνην αυτου και ταυτα παντα προστεθησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","μη ουν μεριμνησητε εισ την αυριον η γαρ αυριον μεριμνησει τα εαυτησ αρκετον τη ημερα η κακια αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","μη κρινετε ινα μη κριθητε ");
INSERT INTO grcmt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","εν ω γαρ κριματι κρινετε κριθησεσθε και εν ω μετρω μετρειτε μετρηθησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","τι δε βλεπεισ το καρφοσ το εν τω οφθαλμω του αδελφου σου την δε εν τω σω οφθαλμω δοκον ου κατανοεισ ");
INSERT INTO grcmt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","η πωσ ερεισ τω αδελφω σου αφεσ εκβαλω το καρφοσ απο του οφθαλμου σου και ιδου η δοκοσ εν τω οφθαλμω σου ");
INSERT INTO grcmt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","υποκριτα εκβαλε πρωτον την δοκον εκ του οφθαλμου σου και τοτε διαβλεψεισ εκβαλειν το καρφοσ εκ του οφθαλμου του αδελφου σου ");
INSERT INTO grcmt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","μη δωτε το αγιον τοισ κυσιν μηδε βαλητε τουσ μαργαριτασ υμων εμπροσθεν των χοιρων μηποτε καταπατησωσιν αυτουσ εν τοισ ποσιν αυτων και στραφεντεσ ρηξωσιν υμασ ");
INSERT INTO grcmt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","αιτειτε και δοθησεται υμιν ζητειτε και ευρησετε κρουετε και ανοιγησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","πασ γαρ ο αιτων λαμβανει και ο ζητων ευρισκει και τω κρουοντι ανοιγησεται ");
INSERT INTO grcmt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","η τισ εστιν εξ υμων ανθρωποσ ον εαν αιτηση ο υιοσ αυτου αρτον μη λιθον επιδωσει αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","και εαν ιχθυν αιτηση μη οφιν επιδωσει αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ει ουν υμεισ πονηροι οντεσ οιδατε δοματα αγαθα διδοναι τοισ τεκνοισ υμων ποσω μαλλον ο πατηρ υμων ο εν τοισ ουρανοισ δωσει αγαθα τοισ αιτουσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","παντα ουν οσα αν θελητε ινα ποιωσιν υμιν οι ανθρωποι ουτωσ και υμεισ ποιειτε αυτοισ ουτοσ γαρ εστιν ο νομοσ και οι προφηται ");
INSERT INTO grcmt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","εισελθετε δια τησ στενησ πυλησ οτι πλατεια η πυλη και ευρυχωροσ η οδοσ η απαγουσα εισ την απωλειαν και πολλοι εισιν οι εισερχομενοι δι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","τι στενη η πυλη και τεθλιμμενη η οδοσ η απαγουσα εισ την ζωην και ολιγοι εισιν οι ευρισκοντεσ αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","προσεχετε δε απο των ψευδοπροφητων οιτινεσ ερχονται προσ υμασ εν ενδυμασιν προβατων εσωθεν δε εισιν λυκοι αρπαγεσ ");
INSERT INTO grcmt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","απο των καρπων αυτων επιγνωσεσθε αυτουσ μητι συλλεγουσιν απο ακανθων σταφυλην η απο τριβολων συκα ");
INSERT INTO grcmt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ουτωσ παν δενδρον αγαθον καρπουσ καλουσ ποιει το δε σαπρον δενδρον καρπουσ πονηρουσ ποιει ");
INSERT INTO grcmt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ου δυναται δενδρον αγαθον καρπουσ πονηρουσ ποιειν ουδε δενδρον σαπρον καρπουσ καλουσ ποιειν ");
INSERT INTO grcmt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","παν δενδρον μη ποιουν καρπον καλον εκκοπτεται και εισ πυρ βαλλεται ");
INSERT INTO grcmt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","αρα γε απο των καρπων αυτων επιγνωσεσθε αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ου πασ ο λεγων μοι κυριε κυριε εισελευσεται εισ την βασιλειαν των ουρανων αλλ ο ποιων το θελημα του πατροσ μου του εν ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","πολλοι ερουσιν μοι εν εκεινη τη ημερα κυριε κυριε ου τω σω ονοματι προεφητευσαμεν και τω σω ονοματι δαιμονια εξεβαλομεν και τω σω ονοματι δυναμεισ πολλασ εποιησαμεν ");
INSERT INTO grcmt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","και τοτε ομολογησω αυτοισ οτι ουδεποτε εγνων υμασ αποχωρειτε απ εμου οι εργαζομενοι την ανομιαν ");
INSERT INTO grcmt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","πασ ουν οστισ ακουει μου τουσ λογουσ τουτουσ και ποιει αυτουσ ομοιωσω αυτον ανδρι φρονιμω οστισ ωκοδομησεν την οικιαν αυτου επι την πετραν ");
INSERT INTO grcmt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","και κατεβη η βροχη και ηλθον οι ποταμοι και επνευσαν οι ανεμοι και προσεπεσον τη οικια εκεινη και ουκ επεσεν τεθεμελιωτο γαρ επι την πετραν ");
INSERT INTO grcmt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","και πασ ο ακουων μου τουσ λογουσ τουτουσ και μη ποιων αυτουσ ομοιωθησεται ανδρι μωρω οστισ ωκοδομησεν την οικιαν αυτου επι την αμμον ");
INSERT INTO grcmt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","και κατεβη η βροχη και ηλθον οι ποταμοι και επνευσαν οι ανεμοι και προσεκοψαν τη οικια εκεινη και επεσεν και ην η πτωσισ αυτησ μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","και εγενετο οτε συνετελεσεν ο ιησουσ τουσ λογουσ τουτουσ εξεπλησσοντο οι οχλοι επι τη διδαχη αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ην γαρ διδασκων αυτουσ ωσ εξουσιαν εχων και ουχ ωσ οι γραμματεισ ");
INSERT INTO grcmt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","καταβαντι δε αυτω απο του ορουσ ηκολουθησαν αυτω οχλοι πολλοι ");
INSERT INTO grcmt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","και ιδου λεπροσ ελθων προσεκυνει αυτω λεγων κυριε εαν θελησ δυνασαι με καθαρισαι ");
INSERT INTO grcmt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","και εκτεινασ την χειρα ηψατο αυτου ο ιησουσ λεγων θελω καθαρισθητι και ευθεωσ εκαθαρισθη αυτου η λεπρα ");
INSERT INTO grcmt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","και λεγει αυτω ο ιησουσ ορα μηδενι ειπησ αλλα υπαγε σεαυτον δειξον τω ιερει και προσενεγκε το δωρον ο προσεταξεν μωσησ εισ μαρτυριον αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","εισελθοντι δε αυτω εισ καπερναουμ προσηλθεν αυτω εκατονταρχοσ παρακαλων αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","και λεγων κυριε ο παισ μου βεβληται εν τη οικια παραλυτικοσ δεινωσ βασανιζομενοσ ");
INSERT INTO grcmt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","και λεγει αυτω ο ιησουσ εγω ελθων θεραπευσω αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","και αποκριθεισ ο εκατονταρχοσ εφη κυριε ουκ ειμι ικανοσ ινα μου υπο την στεγην εισελθησ αλλα μονον ειπε λογω και ιαθησεται ο παισ μου ");
INSERT INTO grcmt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","και γαρ εγω ανθρωποσ ειμι υπο εξουσιαν εχων υπ εμαυτον στρατιωτασ και λεγω τουτω πορευθητι και πορευεται και αλλω ερχου και ερχεται και τω δουλω μου ποιησον τουτο και ποιει ");
INSERT INTO grcmt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ακουσασ δε ο ιησουσ εθαυμασεν και ειπεν τοισ ακολουθουσιν αμην λεγω υμιν ουδε εν τω ισραηλ τοσαυτην πιστιν ευρον ");
INSERT INTO grcmt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","λεγω δε υμιν οτι πολλοι απο ανατολων και δυσμων ηξουσιν και ανακλιθησονται μετα αβρααμ και ισαακ και ιακωβ εν τη βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","οι δε υιοι τησ βασιλειασ εκβληθησονται εισ το σκοτοσ το εξωτερον εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","και ειπεν ο ιησουσ τω εκατονταρχη υπαγε και ωσ επιστευσασ γενηθητω σοι και ιαθη ο παισ αυτου εν τη ωρα εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","και ελθων ο ιησουσ εισ την οικιαν πετρου ειδεν την πενθεραν αυτου βεβλημενην και πυρεσσουσαν ");
INSERT INTO grcmt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","και ηψατο τησ χειροσ αυτησ και αφηκεν αυτην ο πυρετοσ και ηγερθη και διηκονει αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","οψιασ δε γενομενησ προσηνεγκαν αυτω δαιμονιζομενουσ πολλουσ και εξεβαλεν τα πνευματα λογω και παντασ τουσ κακωσ εχοντασ εθεραπευσεν ");
INSERT INTO grcmt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","οπωσ πληρωθη το ρηθεν δια ησαιου του προφητου λεγοντοσ αυτοσ τασ ασθενειασ ημων ελαβεν και τασ νοσουσ εβαστασεν ");
INSERT INTO grcmt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ιδων δε ο ιησουσ πολλουσ οχλουσ περι αυτον εκελευσεν απελθειν εισ το περαν ");
INSERT INTO grcmt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","και προσελθων εισ γραμματευσ ειπεν αυτω διδασκαλε ακολουθησω σοι οπου εαν απερχη ");
INSERT INTO grcmt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","και λεγει αυτω ο ιησουσ αι αλωπεκεσ φωλεουσ εχουσιν και τα πετεινα του ουρανου κατασκηνωσεισ ο δε υιοσ του ανθρωπου ουκ εχει που την κεφαλην κλινη ");
INSERT INTO grcmt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ετεροσ δε των μαθητων αυτου ειπεν αυτω κυριε επιτρεψον μοι πρωτον απελθειν και θαψαι τον πατερα μου ");
INSERT INTO grcmt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ο δε ιησουσ ειπεν αυτω ακολουθει μοι και αφεσ τουσ νεκρουσ θαψαι τουσ εαυτων νεκρουσ ");
INSERT INTO grcmt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","και εμβαντι αυτω εισ το πλοιον ηκολουθησαν αυτω οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","και ιδου σεισμοσ μεγασ εγενετο εν τη θαλασση ωστε το πλοιον καλυπτεσθαι υπο των κυματων αυτοσ δε εκαθευδεν ");
INSERT INTO grcmt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","και προσελθοντεσ οι μαθηται ηγειραν αυτον λεγοντεσ κυριε σωσον ημασ απολλυμεθα ");
INSERT INTO grcmt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","και λεγει αυτοισ τι δειλοι εστε ολιγοπιστοι τοτε εγερθεισ επετιμησεν τοισ ανεμοισ και τη θαλασση και εγενετο γαληνη μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","οι δε ανθρωποι εθαυμασαν λεγοντεσ ποταποσ εστιν ουτοσ οτι και οι ανεμοι και η θαλασσα υπακουουσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","και ελθοντι αυτω εισ το περαν εισ την χωραν των γεργεσηνων υπηντησαν αυτω δυο δαιμονιζομενοι εκ των μνημειων εξερχομενοι χαλεποι λιαν ωστε μη ισχυειν τινα παρελθειν δια τησ οδου εκεινησ ");
INSERT INTO grcmt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","και ιδου εκραξαν λεγοντεσ τι ημιν και σοι ιησου υιε του θεου ηλθεσ ωδε προ καιρου βασανισαι ημασ ");
INSERT INTO grcmt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ην δε μακραν απ αυτων αγελη χοιρων πολλων βοσκομενη ");
INSERT INTO grcmt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","οι δε δαιμονεσ παρεκαλουν αυτον λεγοντεσ ει εκβαλλεισ ημασ επιτρεψον ημιν απελθειν εισ την αγελην των χοιρων ");
INSERT INTO grcmt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","και ειπεν αυτοισ υπαγετε οι δε εξελθοντεσ απηλθον εισ την αγελην των χοιρων και ιδου ωρμησεν πασα η αγελη των χοιρων κατα του κρημνου εισ την θαλασσαν και απεθανον εν τοισ υδασιν ");
INSERT INTO grcmt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","οι δε βοσκοντεσ εφυγον και απελθοντεσ εισ την πολιν απηγγειλαν παντα και τα των δαιμονιζομενων ");
INSERT INTO grcmt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","και ιδου πασα η πολισ εξηλθεν εισ συναντησιν τω ιησου και ιδοντεσ αυτον παρεκαλεσαν οπωσ μεταβη απο των οριων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","και εμβασ εισ το πλοιον διεπερασεν και ηλθεν εισ την ιδιαν πολιν ");
INSERT INTO grcmt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","και ιδου προσεφερον αυτω παραλυτικον επι κλινησ βεβλημενον και ιδων ο ιησουσ την πιστιν αυτων ειπεν τω παραλυτικω θαρσει τεκνον αφεωνται σοι αι αμαρτιαι σου ");
INSERT INTO grcmt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","και ιδου τινεσ των γραμματεων ειπον εν εαυτοισ ουτοσ βλασφημει ");
INSERT INTO grcmt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","και ιδων ο ιησουσ τασ ενθυμησεισ αυτων ειπεν ινα τι υμεισ ενθυμεισθε πονηρα εν ταισ καρδιαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","τι γαρ εστιν ευκοπωτερον ειπειν αφεωνται σου αι αμαρτιαι η ειπειν εγειραι και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ινα δε ειδητε οτι εξουσιαν εχει ο υιοσ του ανθρωπου επι τησ γησ αφιεναι αμαρτιασ τοτε λεγει τω παραλυτικω εγερθεισ αρον σου την κλινην και υπαγε εισ τον οικον σου ");
INSERT INTO grcmt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","και εγερθεισ απηλθεν εισ τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ιδοντεσ δε οι οχλοι εθαυμασαν και εδοξασαν τον θεον τον δοντα εξουσιαν τοιαυτην τοισ ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","και παραγων ο ιησουσ εκειθεν ειδεν ανθρωπον καθημενον επι το τελωνιον ματθαιον λεγομενον και λεγει αυτω ακολουθει μοι και αναστασ ηκολουθησεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","και εγενετο αυτου ανακειμενου εν τη οικια και ιδου πολλοι τελωναι και αμαρτωλοι ελθοντεσ συνανεκειντο τω ιησου και τοισ μαθηταισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","και ιδοντεσ οι φαρισαιοι ειπον τοισ μαθηταισ αυτου δια τι μετα των τελωνων και αμαρτωλων εσθιει ο διδασκαλοσ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ο δε ιησουσ ακουσασ ειπεν αυτοισ ου χρειαν εχουσιν οι ισχυοντεσ ιατρου αλλ οι κακωσ εχοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","πορευθεντεσ δε μαθετε τι εστιν ελεον θελω και ου θυσιαν ου γαρ ηλθον καλεσαι δικαιουσ αλλα αμαρτωλουσ εισ μετανοιαν ");
INSERT INTO grcmt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","τοτε προσερχονται αυτω οι μαθηται ιωαννου λεγοντεσ δια τι ημεισ και οι φαρισαιοι νηστευομεν πολλα οι δε μαθηται σου ου νηστευουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","και ειπεν αυτοισ ο ιησουσ μη δυνανται οι υιοι του νυμφωνοσ πενθειν εφ οσον μετ αυτων εστιν ο νυμφιοσ ελευσονται δε ημεραι οταν απαρθη απ αυτων ο νυμφιοσ και τοτε νηστευσουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ουδεισ δε επιβαλλει επιβλημα ρακουσ αγναφου επι ιματιω παλαιω αιρει γαρ το πληρωμα αυτου απο του ιματιου και χειρον σχισμα γινεται ");
INSERT INTO grcmt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ουδε βαλλουσιν οινον νεον εισ ασκουσ παλαιουσ ει δε μηγε ρηγνυνται οι ασκοι και ο οινοσ εκχειται και οι ασκοι απολουνται αλλα βαλλουσιν οινον νεον εισ ασκουσ καινουσ και αμφοτεροι συντηρουνται ");
INSERT INTO grcmt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ταυτα αυτου λαλουντοσ αυτοισ ιδου αρχων εισ ελθων προσεκυνει αυτω λεγων οτι η θυγατηρ μου αρτι ετελευτησεν αλλα ελθων επιθεσ την χειρα σου επ αυτην και ζησεται ");
INSERT INTO grcmt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","και εγερθεισ ο ιησουσ ηκολουθησεν αυτω και οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","και ιδου γυνη αιμορροουσα δωδεκα ετη προσελθουσα οπισθεν ηψατο του κρασπεδου του ιματιου αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ελεγεν γαρ εν εαυτη εαν μονον αψωμαι του ιματιου αυτου σωθησομαι ");
INSERT INTO grcmt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ο δε ιησουσ επιστραφεισ και ιδων αυτην ειπεν θαρσει θυγατερ η πιστισ σου σεσωκεν σε και εσωθη η γυνη απο τησ ωρασ εκεινησ ");
INSERT INTO grcmt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","και ελθων ο ιησουσ εισ την οικιαν του αρχοντοσ και ιδων τουσ αυλητασ και τον οχλον θορυβουμενον ");
INSERT INTO grcmt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","λεγει αυτοισ αναχωρειτε ου γαρ απεθανεν το κορασιον αλλα καθευδει και κατεγελων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","οτε δε εξεβληθη ο οχλοσ εισελθων εκρατησεν τησ χειροσ αυτησ και ηγερθη το κορασιον ");
INSERT INTO grcmt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","και εξηλθεν η φημη αυτη εισ ολην την γην εκεινην ");
INSERT INTO grcmt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","και παραγοντι εκειθεν τω ιησου ηκολουθησαν αυτω δυο τυφλοι κραζοντεσ και λεγοντεσ ελεησον ημασ υιε δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ελθοντι δε εισ την οικιαν προσηλθον αυτω οι τυφλοι και λεγει αυτοισ ο ιησουσ πιστευετε οτι δυναμαι τουτο ποιησαι λεγουσιν αυτω ναι κυριε ");
INSERT INTO grcmt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","τοτε ηψατο των οφθαλμων αυτων λεγων κατα την πιστιν υμων γενηθητω υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","και ανεωχθησαν αυτων οι οφθαλμοι και ενεβριμησατο αυτοισ ο ιησουσ λεγων ορατε μηδεισ γινωσκετω ");
INSERT INTO grcmt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","οι δε εξελθοντεσ διεφημισαν αυτον εν ολη τη γη εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","αυτων δε εξερχομενων ιδου προσηνεγκαν αυτω ανθρωπον κωφον δαιμονιζομενον ");
INSERT INTO grcmt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","και εκβληθεντοσ του δαιμονιου ελαλησεν ο κωφοσ και εθαυμασαν οι οχλοι λεγοντεσ ουδεποτε εφανη ουτωσ εν τω ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","οι δε φαρισαιοι ελεγον εν τω αρχοντι των δαιμονιων εκβαλλει τα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","και περιηγεν ο ιησουσ τασ πολεισ πασασ και τασ κωμασ διδασκων εν ταισ συναγωγαισ αυτων και κηρυσσων το ευαγγελιον τησ βασιλειασ και θεραπευων πασαν νοσον και πασαν μαλακιαν εν τω λαω ");
INSERT INTO grcmt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ιδων δε τουσ οχλουσ εσπλαγχνισθη περι αυτων οτι ησαν εσκυλμενοι και ερριμμενοι ωσει προβατα μη εχοντα ποιμενα ");
INSERT INTO grcmt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","τοτε λεγει τοισ μαθηταισ αυτου ο μεν θερισμοσ πολυσ οι δε εργαται ολιγοι ");
INSERT INTO grcmt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","δεηθητε ουν του κυριου του θερισμου οπωσ εκβαλη εργατασ εισ τον θερισμον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","και προσκαλεσαμενοσ τουσ δωδεκα μαθητασ αυτου εδωκεν αυτοισ εξουσιαν πνευματων ακαθαρτων ωστε εκβαλλειν αυτα και θεραπευειν πασαν νοσον και πασαν μαλακιαν ");
INSERT INTO grcmt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","των δε δωδεκα αποστολων τα ονοματα εστιν ταυτα πρωτοσ σιμων ο λεγομενοσ πετροσ και ανδρεασ ο αδελφοσ αυτου ιακωβοσ ο του ζεβεδαιου και ιωαννησ ο αδελφοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","φιλιπποσ και βαρθολομαιοσ θωμασ και ματθαιοσ ο τελωνησ ιακωβοσ ο του αλφαιου και λεββαιοσ ο επικληθεισ θαδδαιοσ ");
INSERT INTO grcmt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","σιμων ο κανανιτησ και ιουδασ ισκαριωτησ ο και παραδουσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","τουτουσ τουσ δωδεκα απεστειλεν ο ιησουσ παραγγειλασ αυτοισ λεγων εισ οδον εθνων μη απελθητε και εισ πολιν σαμαρειτων μη εισελθητε ");
INSERT INTO grcmt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","πορευεσθε δε μαλλον προσ τα προβατα τα απολωλοτα οικου ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","πορευομενοι δε κηρυσσετε λεγοντεσ οτι ηγγικεν η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ασθενουντασ θεραπευετε λεπρουσ καθαριζετε δαιμονια εκβαλλετε δωρεαν ελαβετε δωρεαν δοτε ");
INSERT INTO grcmt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","μη κτησησθε χρυσον μηδε αργυρον μηδε χαλκον εισ τασ ζωνασ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","μη πηραν εισ οδον μηδε δυο χιτωνασ μηδε υποδηματα μηδε ραβδουσ αξιοσ γαρ ο εργατησ τησ τροφησ αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","εισ ην δ αν πολιν η κωμην εισελθητε εξετασατε τισ εν αυτη αξιοσ εστιν κακει μεινατε εωσ αν εξελθητε ");
INSERT INTO grcmt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","εισερχομενοι δε εισ την οικιαν ασπασασθε αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","και εαν μεν η η οικια αξια ελθετω η ειρηνη υμων επ αυτην εαν δε μη η αξια η ειρηνη υμων προσ υμασ επιστραφητω ");
INSERT INTO grcmt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","και οσ εαν μη δεξηται υμασ μηδε ακουση τουσ λογουσ υμων εξερχομενοι τησ οικιασ η τησ πολεωσ εκεινησ εκτιναξατε τον κονιορτον των ποδων υμων ");
INSERT INTO grcmt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","αμην λεγω υμιν ανεκτοτερον εσται γη σοδομων και γομορρων εν ημερα κρισεωσ η τη πολει εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ιδου εγω αποστελλω υμασ ωσ προβατα εν μεσω λυκων γινεσθε ουν φρονιμοι ωσ οι οφεισ και ακεραιοι ωσ αι περιστεραι ");
INSERT INTO grcmt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","προσεχετε δε απο των ανθρωπων παραδωσουσιν γαρ υμασ εισ συνεδρια και εν ταισ συναγωγαισ αυτων μαστιγωσουσιν υμασ ");
INSERT INTO grcmt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","και επι ηγεμονασ δε και βασιλεισ αχθησεσθε ενεκεν εμου εισ μαρτυριον αυτοισ και τοισ εθνεσιν ");
INSERT INTO grcmt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","οταν δε παραδιδωσιν υμασ μη μεριμνησητε πωσ η τι λαλησητε δοθησεται γαρ υμιν εν εκεινη τη ωρα τι λαλησετε ");
INSERT INTO grcmt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ου γαρ υμεισ εστε οι λαλουντεσ αλλα το πνευμα του πατροσ υμων το λαλουν εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","παραδωσει δε αδελφοσ αδελφον εισ θανατον και πατηρ τεκνον και επαναστησονται τεκνα επι γονεισ και θανατωσουσιν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","και εσεσθε μισουμενοι υπο παντων δια το ονομα μου ο δε υπομεινασ εισ τελοσ ουτοσ σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","οταν δε διωκωσιν υμασ εν τη πολει ταυτη φευγετε εισ την αλλην αμην γαρ λεγω υμιν ου μη τελεσητε τασ πολεισ του ισραηλ εωσ αν ελθη ο υιοσ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ουκ εστιν μαθητησ υπερ τον διδασκαλον ουδε δουλοσ υπερ τον κυριον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","αρκετον τω μαθητη ινα γενηται ωσ ο διδασκαλοσ αυτου και ο δουλοσ ωσ ο κυριοσ αυτου ει τον οικοδεσποτην βεελζεβουλ εκαλεσαν ποσω μαλλον τουσ οικειακουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","μη ουν φοβηθητε αυτουσ ουδεν γαρ εστιν κεκαλυμμενον ο ουκ αποκαλυφθησεται και κρυπτον ο ου γνωσθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ο λεγω υμιν εν τη σκοτια ειπατε εν τω φωτι και ο εισ το ουσ ακουετε κηρυξατε επι των δωματων ");
INSERT INTO grcmt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","και μη φοβεισθε απο των αποκτενοντων το σωμα την δε ψυχην μη δυναμενων αποκτειναι φοβηθητε δε μαλλον τον δυναμενον και την ψυχην και το σωμα απολεσαι εν γεεννη ");
INSERT INTO grcmt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ουχι δυο στρουθια ασσαριου πωλειται και εν εξ αυτων ου πεσειται επι την γην ανευ του πατροσ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","υμων δε και αι τριχεσ τησ κεφαλησ πασαι ηριθμημεναι εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","μη ουν φοβηθητε πολλων στρουθιων διαφερετε υμεισ ");
INSERT INTO grcmt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","πασ ουν οστισ ομολογησει εν εμοι εμπροσθεν των ανθρωπων ομολογησω καγω εν αυτω εμπροσθεν του πατροσ μου του εν ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","οστισ δ αν αρνησηται με εμπροσθεν των ανθρωπων αρνησομαι αυτον καγω εμπροσθεν του πατροσ μου του εν ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","μη νομισητε οτι ηλθον βαλειν ειρηνην επι την γην ουκ ηλθον βαλειν ειρηνην αλλα μαχαιραν ");
INSERT INTO grcmt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ηλθον γαρ διχασαι ανθρωπον κατα του πατροσ αυτου και θυγατερα κατα τησ μητροσ αυτησ και νυμφην κατα τησ πενθερασ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","και εχθροι του ανθρωπου οι οικειακοι αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ο φιλων πατερα η μητερα υπερ εμε ουκ εστιν μου αξιοσ και ο φιλων υιον η θυγατερα υπερ εμε ουκ εστιν μου αξιοσ ");
INSERT INTO grcmt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","και οσ ου λαμβανει τον σταυρον αυτου και ακολουθει οπισω μου ουκ εστιν μου αξιοσ ");
INSERT INTO grcmt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ο ευρων την ψυχην αυτου απολεσει αυτην και ο απολεσασ την ψυχην αυτου ενεκεν εμου ευρησει αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ο δεχομενοσ υμασ εμε δεχεται και ο εμε δεχομενοσ δεχεται τον αποστειλαντα με ");
INSERT INTO grcmt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ο δεχομενοσ προφητην εισ ονομα προφητου μισθον προφητου ληψεται και ο δεχομενοσ δικαιον εισ ονομα δικαιου μισθον δικαιου ληψεται ");
INSERT INTO grcmt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","και οσ εαν ποτιση ενα των μικρων τουτων ποτηριον ψυχρου μονον εισ ονομα μαθητου αμην λεγω υμιν ου μη απολεση τον μισθον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","και εγενετο οτε ετελεσεν ο ιησουσ διατασσων τοισ δωδεκα μαθηταισ αυτου μετεβη εκειθεν του διδασκειν και κηρυσσειν εν ταισ πολεσιν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ο δε ιωαννησ ακουσασ εν τω δεσμωτηριω τα εργα του χριστου πεμψασ δυο των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ειπεν αυτω συ ει ο ερχομενοσ η ετερον προσδοκωμεν ");
INSERT INTO grcmt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","και αποκριθεισ ο ιησουσ ειπεν αυτοισ πορευθεντεσ απαγγειλατε ιωαννη α ακουετε και βλεπετε ");
INSERT INTO grcmt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","τυφλοι αναβλεπουσιν και χωλοι περιπατουσιν λεπροι καθαριζονται και κωφοι ακουουσιν νεκροι εγειρονται και πτωχοι ευαγγελιζονται ");
INSERT INTO grcmt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","και μακαριοσ εστιν οσ εαν μη σκανδαλισθη εν εμοι ");
INSERT INTO grcmt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","τουτων δε πορευομενων ηρξατο ο ιησουσ λεγειν τοισ οχλοισ περι ιωαννου τι εξηλθετε εισ την ερημον θεασασθαι καλαμον υπο ανεμου σαλευομενον ");
INSERT INTO grcmt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","αλλα τι εξηλθετε ιδειν ανθρωπον εν μαλακοισ ιματιοισ ημφιεσμενον ιδου οι τα μαλακα φορουντεσ εν τοισ οικοισ των βασιλειων εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","αλλα τι εξηλθετε ιδειν προφητην ναι λεγω υμιν και περισσοτερον προφητου ");
INSERT INTO grcmt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ουτοσ γαρ εστιν περι ου γεγραπται ιδου εγω αποστελλω τον αγγελον μου προ προσωπου σου οσ κατασκευασει την οδον σου εμπροσθεν σου ");
INSERT INTO grcmt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","αμην λεγω υμιν ουκ εγηγερται εν γεννητοισ γυναικων μειζων ιωαννου του βαπτιστου ο δε μικροτεροσ εν τη βασιλεια των ουρανων μειζων αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","απο δε των ημερων ιωαννου του βαπτιστου εωσ αρτι η βασιλεια των ουρανων βιαζεται και βιασται αρπαζουσιν αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","παντεσ γαρ οι προφηται και ο νομοσ εωσ ιωαννου προεφητευσαν ");
INSERT INTO grcmt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","και ει θελετε δεξασθαι αυτοσ εστιν ηλιασ ο μελλων ερχεσθαι ");
INSERT INTO grcmt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","τινι δε ομοιωσω την γενεαν ταυτην ομοια εστιν παιδιοισ εν αγοραισ καθημενοισ και προσφωνουσιν τοισ εταιροισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","και λεγουσιν ηυλησαμεν υμιν και ουκ ωρχησασθε εθρηνησαμεν υμιν και ουκ εκοψασθε ");
INSERT INTO grcmt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ηλθεν γαρ ιωαννησ μητε εσθιων μητε πινων και λεγουσιν δαιμονιον εχει ");
INSERT INTO grcmt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ηλθεν ο υιοσ του ανθρωπου εσθιων και πινων και λεγουσιν ιδου ανθρωποσ φαγοσ και οινοποτησ τελωνων φιλοσ και αμαρτωλων και εδικαιωθη η σοφια απο των τεκνων αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","τοτε ηρξατο ονειδιζειν τασ πολεισ εν αισ εγενοντο αι πλεισται δυναμεισ αυτου οτι ου μετενοησαν ");
INSERT INTO grcmt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ουαι σοι χοραζιν ουαι σοι βηθσαιδα οτι ει εν τυρω και σιδωνι εγενοντο αι δυναμεισ αι γενομεναι εν υμιν παλαι αν εν σακκω και σποδω μετενοησαν ");
INSERT INTO grcmt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","πλην λεγω υμιν τυρω και σιδωνι ανεκτοτερον εσται εν ημερα κρισεωσ η υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","και συ καπερναουμ η εωσ του ουρανου υψωθεισα εωσ αδου καταβιβασθηση οτι ει εν σοδομοισ εγενοντο αι δυναμεισ αι γενομεναι εν σοι εμειναν αν μεχρι τησ σημερον ");
INSERT INTO grcmt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","πλην λεγω υμιν οτι γη σοδομων ανεκτοτερον εσται εν ημερα κρισεωσ η σοι ");
INSERT INTO grcmt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","εν εκεινω τω καιρω αποκριθεισ ο ιησουσ ειπεν εξομολογουμαι σοι πατερ κυριε του ουρανου και τησ γησ οτι απεκρυψασ ταυτα απο σοφων και συνετων και απεκαλυψασ αυτα νηπιοισ ");
INSERT INTO grcmt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ναι ο πατηρ οτι ουτωσ εγενετο ευδοκια εμπροσθεν σου ");
INSERT INTO grcmt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","παντα μοι παρεδοθη υπο του πατροσ μου και ουδεισ επιγινωσκει τον υιον ει μη ο πατηρ ουδε τον πατερα τισ επιγινωσκει ει μη ο υιοσ και ω εαν βουληται ο υιοσ αποκαλυψαι ");
INSERT INTO grcmt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","δευτε προσ με παντεσ οι κοπιωντεσ και πεφορτισμενοι καγω αναπαυσω υμασ ");
INSERT INTO grcmt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","αρατε τον ζυγον μου εφ υμασ και μαθετε απ εμου οτι πραοσ ειμι και ταπεινοσ τη καρδια και ευρησετε αναπαυσιν ταισ ψυχαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ο γαρ ζυγοσ μου χρηστοσ και το φορτιον μου ελαφρον εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","εν εκεινω τω καιρω επορευθη ο ιησουσ τοισ σαββασιν δια των σποριμων οι δε μαθηται αυτου επεινασαν και ηρξαντο τιλλειν σταχυασ και εσθιειν ");
INSERT INTO grcmt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","οι δε φαρισαιοι ιδοντεσ ειπον αυτω ιδου οι μαθηται σου ποιουσιν ο ουκ εξεστιν ποιειν εν σαββατω ");
INSERT INTO grcmt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ο δε ειπεν αυτοισ ουκ ανεγνωτε τι εποιησεν δαυιδ οτε επεινασεν αυτοσ και οι μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","πωσ εισηλθεν εισ τον οικον του θεου και τουσ αρτουσ τησ προθεσεωσ εφαγεν ουσ ουκ εξον ην αυτω φαγειν ουδε τοισ μετ αυτου ει μη τοισ ιερευσιν μονοισ ");
INSERT INTO grcmt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","η ουκ ανεγνωτε εν τω νομω οτι τοισ σαββασιν οι ιερεισ εν τω ιερω το σαββατον βεβηλουσιν και αναιτιοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","λεγω δε υμιν οτι του ιερου μειζον εστιν ωδε ");
INSERT INTO grcmt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ει δε εγνωκειτε τι εστιν ελεον θελω και ου θυσιαν ουκ αν κατεδικασατε τουσ αναιτιουσ ");
INSERT INTO grcmt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","κυριοσ γαρ εστιν του σαββατου ο υιοσ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","και μεταβασ εκειθεν ηλθεν εισ την συναγωγην αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","και ιδου ανθρωποσ ην την χειρα εχων ξηραν και επηρωτησαν αυτον λεγοντεσ ει εξεστιν τοισ σαββασιν θεραπευειν ινα κατηγορησωσιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ο δε ειπεν αυτοισ τισ εσται εξ υμων ανθρωποσ οσ εξει προβατον εν και εαν εμπεση τουτο τοισ σαββασιν εισ βοθυνον ουχι κρατησει αυτο και εγερει ");
INSERT INTO grcmt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ποσω ουν διαφερει ανθρωποσ προβατου ωστε εξεστιν τοισ σαββασιν καλωσ ποιειν ");
INSERT INTO grcmt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","τοτε λεγει τω ανθρωπω εκτεινον την χειρα σου και εξετεινεν και αποκατεσταθη υγιησ ωσ η αλλη ");
INSERT INTO grcmt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","οι δε φαρισαιοι συμβουλιον ελαβον κατ αυτου εξελθοντεσ οπωσ αυτον απολεσωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ο δε ιησουσ γνουσ ανεχωρησεν εκειθεν και ηκολουθησαν αυτω οχλοι πολλοι και εθεραπευσεν αυτουσ παντασ ");
INSERT INTO grcmt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","και επετιμησεν αυτοισ ινα μη φανερον αυτον ποιησωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","οπωσ πληρωθη το ρηθεν δια ησαιου του προφητου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ιδου ο παισ μου ον ηρετισα ο αγαπητοσ μου εισ ον ευδοκησεν η ψυχη μου θησω το πνευμα μου επ αυτον και κρισιν τοισ εθνεσιν απαγγελει ");
INSERT INTO grcmt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ουκ ερισει ουδε κραυγασει ουδε ακουσει τισ εν ταισ πλατειαισ την φωνην αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","καλαμον συντετριμμενον ου κατεαξει και λινον τυφομενον ου σβεσει εωσ αν εκβαλη εισ νικοσ την κρισιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","και τω ονοματι αυτου εθνη ελπιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","τοτε προσηνεχθη αυτω δαιμονιζομενοσ τυφλοσ και κωφοσ και εθεραπευσεν αυτον ωστε τον τυφλον και κωφον και λαλειν και βλεπειν ");
INSERT INTO grcmt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","και εξισταντο παντεσ οι οχλοι και ελεγον μητι ουτοσ εστιν ο υιοσ δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","οι δε φαρισαιοι ακουσαντεσ ειπον ουτοσ ουκ εκβαλλει τα δαιμονια ει μη εν τω βεελζεβουλ αρχοντι των δαιμονιων ");
INSERT INTO grcmt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ειδωσ δε ο ιησουσ τασ ενθυμησεισ αυτων ειπεν αυτοισ πασα βασιλεια μερισθεισα καθ εαυτησ ερημουται και πασα πολισ η οικια μερισθεισα καθ εαυτησ ου σταθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","και ει ο σατανασ τον σαταναν εκβαλλει εφ εαυτον εμερισθη πωσ ουν σταθησεται η βασιλεια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","και ει εγω εν βεελζεβουλ εκβαλλω τα δαιμονια οι υιοι υμων εν τινι εκβαλλουσιν δια τουτο αυτοι υμων εσονται κριται ");
INSERT INTO grcmt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ει δε εν πνευματι θεου εγω εκβαλλω τα δαιμονια αρα εφθασεν εφ υμασ η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","η πωσ δυναται τισ εισελθειν εισ την οικιαν του ισχυρου και τα σκευη αυτου διαρπασαι εαν μη πρωτον δηση τον ισχυρον και τοτε την οικιαν αυτου διαρπασει ");
INSERT INTO grcmt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ο μη ων μετ εμου κατ εμου εστιν και ο μη συναγων μετ εμου σκορπιζει ");
INSERT INTO grcmt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","δια τουτο λεγω υμιν πασα αμαρτια και βλασφημια αφεθησεται τοισ ανθρωποισ η δε του πνευματοσ βλασφημια ουκ αφεθησεται τοισ ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","και οσ εαν ειπη λογον κατα του υιου του ανθρωπου αφεθησεται αυτω οσ δ αν ειπη κατα του πνευματοσ του αγιου ουκ αφεθησεται αυτω ουτε εν τω νυν αιωνι ουτε εν τω μελλοντι ");
INSERT INTO grcmt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","η ποιησατε το δενδρον καλον και τον καρπον αυτου καλον η ποιησατε το δενδρον σαπρον και τον καρπον αυτου σαπρον εκ γαρ του καρπου το δενδρον γινωσκεται ");
INSERT INTO grcmt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","γεννηματα εχιδνων πωσ δυνασθε αγαθα λαλειν πονηροι οντεσ εκ γαρ του περισσευματοσ τησ καρδιασ το στομα λαλει ");
INSERT INTO grcmt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ο αγαθοσ ανθρωποσ εκ του αγαθου θησαυρου εκβαλλει αγαθα και ο πονηροσ ανθρωποσ εκ του πονηρου θησαυρου εκβαλλει πονηρα ");
INSERT INTO grcmt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","λεγω δε υμιν οτι παν ρημα αργον ο εαν λαλησωσιν οι ανθρωποι αποδωσουσιν περι αυτου λογον εν ημερα κρισεωσ ");
INSERT INTO grcmt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","εκ γαρ των λογων σου δικαιωθηση και εκ των λογων σου καταδικασθηση ");
INSERT INTO grcmt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","τοτε απεκριθησαν τινεσ των γραμματεων και φαρισαιων λεγοντεσ διδασκαλε θελομεν απο σου σημειον ιδειν ");
INSERT INTO grcmt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ο δε αποκριθεισ ειπεν αυτοισ γενεα πονηρα και μοιχαλισ σημειον επιζητει και σημειον ου δοθησεται αυτη ει μη το σημειον ιωνα του προφητου ");
INSERT INTO grcmt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ωσπερ γαρ ην ιωνασ εν τη κοιλια του κητουσ τρεισ ημερασ και τρεισ νυκτασ ουτωσ εσται ο υιοσ του ανθρωπου εν τη καρδια τησ γησ τρεισ ημερασ και τρεισ νυκτασ ");
INSERT INTO grcmt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ανδρεσ νινευιται αναστησονται εν τη κρισει μετα τησ γενεασ ταυτησ και κατακρινουσιν αυτην οτι μετενοησαν εισ το κηρυγμα ιωνα και ιδου πλειον ιωνα ωδε ");
INSERT INTO grcmt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","βασιλισσα νοτου εγερθησεται εν τη κρισει μετα τησ γενεασ ταυτησ και κατακρινει αυτην οτι ηλθεν εκ των περατων τησ γησ ακουσαι την σοφιαν σολομωνοσ και ιδου πλειον σολομωνοσ ωδε ");
INSERT INTO grcmt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","οταν δε το ακαθαρτον πνευμα εξελθη απο του ανθρωπου διερχεται δι ανυδρων τοπων ζητουν αναπαυσιν και ουχ ευρισκει ");
INSERT INTO grcmt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","τοτε λεγει επιστρεψω εισ τον οικον μου οθεν εξηλθον και ελθον ευρισκει σχολαζοντα σεσαρωμενον και κεκοσμημενον ");
INSERT INTO grcmt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","τοτε πορευεται και παραλαμβανει μεθ εαυτου επτα ετερα πνευματα πονηροτερα εαυτου και εισελθοντα κατοικει εκει και γινεται τα εσχατα του ανθρωπου εκεινου χειρονα των πρωτων ουτωσ εσται και τη γενεα ταυτη τη πονηρα ");
INSERT INTO grcmt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ετι δε αυτου λαλουντοσ τοισ οχλοισ ιδου η μητηρ και οι αδελφοι αυτου ειστηκεισαν εξω ζητουντεσ αυτω λαλησαι ");
INSERT INTO grcmt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ειπεν δε τισ αυτω ιδου η μητηρ σου και οι αδελφοι σου εξω εστηκασιν ζητουντεσ σοι λαλησαι ");
INSERT INTO grcmt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ο δε αποκριθεισ ειπεν τω ειποντι αυτω τισ εστιν η μητηρ μου και τινεσ εισιν οι αδελφοι μου ");
INSERT INTO grcmt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","και εκτεινασ την χειρα αυτου επι τουσ μαθητασ αυτου ειπεν ιδου η μητηρ μου και οι αδελφοι μου ");
INSERT INTO grcmt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","οστισ γαρ αν ποιηση το θελημα του πατροσ μου του εν ουρανοισ αυτοσ μου αδελφοσ και αδελφη και μητηρ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","εν δε τη ημερα εκεινη εξελθων ο ιησουσ απο τησ οικιασ εκαθητο παρα την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","και συνηχθησαν προσ αυτον οχλοι πολλοι ωστε αυτον εισ το πλοιον εμβαντα καθησθαι και πασ ο οχλοσ επι τον αιγιαλον ειστηκει ");
INSERT INTO grcmt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","και ελαλησεν αυτοισ πολλα εν παραβολαισ λεγων ιδου εξηλθεν ο σπειρων του σπειρειν ");
INSERT INTO grcmt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","και εν τω σπειρειν αυτον α μεν επεσεν παρα την οδον και ηλθεν τα πετεινα και κατεφαγεν αυτα ");
INSERT INTO grcmt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","αλλα δε επεσεν επι τα πετρωδη οπου ουκ ειχεν γην πολλην και ευθεωσ εξανετειλεν δια το μη εχειν βαθοσ γησ ");
INSERT INTO grcmt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ηλιου δε ανατειλαντοσ εκαυματισθη και δια το μη εχειν ριζαν εξηρανθη ");
INSERT INTO grcmt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","αλλα δε επεσεν επι τασ ακανθασ και ανεβησαν αι ακανθαι και απεπνιξαν αυτα ");
INSERT INTO grcmt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","αλλα δε επεσεν επι την γην την καλην και εδιδου καρπον ο μεν εκατον ο δε εξηκοντα ο δε τριακοντα ");
INSERT INTO grcmt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","και προσελθοντεσ οι μαθηται ειπον αυτω δια τι εν παραβολαισ λαλεισ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ο δε αποκριθεισ ειπεν αυτοισ οτι υμιν δεδοται γνωναι τα μυστηρια τησ βασιλειασ των ουρανων εκεινοισ δε ου δεδοται ");
INSERT INTO grcmt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","οστισ γαρ εχει δοθησεται αυτω και περισσευθησεται οστισ δε ουκ εχει και ο εχει αρθησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","δια τουτο εν παραβολαισ αυτοισ λαλω οτι βλεποντεσ ου βλεπουσιν και ακουοντεσ ουκ ακουουσιν ουδε συνιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","και αναπληρουται αυτοισ η προφητεια ησαιου η λεγουσα ακοη ακουσετε και ου μη συνητε και βλεποντεσ βλεψετε και ου μη ιδητε ");
INSERT INTO grcmt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","επαχυνθη γαρ η καρδια του λαου τουτου και τοισ ωσιν βαρεωσ ηκουσαν και τουσ οφθαλμουσ αυτων εκαμμυσαν μηποτε ιδωσιν τοισ οφθαλμοισ και τοισ ωσιν ακουσωσιν και τη καρδια συνωσιν και επιστρεψωσιν και ιασομαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","υμων δε μακαριοι οι οφθαλμοι οτι βλεπουσιν και τα ωτα υμων οτι ακουει ");
INSERT INTO grcmt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","αμην γαρ λεγω υμιν οτι πολλοι προφηται και δικαιοι επεθυμησαν ιδειν α βλεπετε και ουκ ειδον και ακουσαι α ακουετε και ουκ ηκουσαν ");
INSERT INTO grcmt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","υμεισ ουν ακουσατε την παραβολην του σπειροντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","παντοσ ακουοντοσ τον λογον τησ βασιλειασ και μη συνιεντοσ ερχεται ο πονηροσ και αρπαζει το εσπαρμενον εν τη καρδια αυτου ουτοσ εστιν ο παρα την οδον σπαρεισ ");
INSERT INTO grcmt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ο δε επι τα πετρωδη σπαρεισ ουτοσ εστιν ο τον λογον ακουων και ευθυσ μετα χαρασ λαμβανων αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ουκ εχει δε ριζαν εν εαυτω αλλα προσκαιροσ εστιν γενομενησ δε θλιψεωσ η διωγμου δια τον λογον ευθυσ σκανδαλιζεται ");
INSERT INTO grcmt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ο δε εισ τασ ακανθασ σπαρεισ ουτοσ εστιν ο τον λογον ακουων και η μεριμνα του αιωνοσ τουτου και η απατη του πλουτου συμπνιγει τον λογον και ακαρποσ γινεται ");
INSERT INTO grcmt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ο δε επι την γην την καλην σπαρεισ ουτοσ εστιν ο τον λογον ακουων και συνιων οσ δη καρποφορει και ποιει ο μεν εκατον ο δε εξηκοντα ο δε τριακοντα ");
INSERT INTO grcmt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","αλλην παραβολην παρεθηκεν αυτοισ λεγων ωμοιωθη η βασιλεια των ουρανων ανθρωπω σπειροντι καλον σπερμα εν τω αγρω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","εν δε τω καθευδειν τουσ ανθρωπουσ ηλθεν αυτου ο εχθροσ και εσπειρεν ζιζανια ανα μεσον του σιτου και απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","οτε δε εβλαστησεν ο χορτοσ και καρπον εποιησεν τοτε εφανη και τα ζιζανια ");
INSERT INTO grcmt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","προσελθοντεσ δε οι δουλοι του οικοδεσποτου ειπον αυτω κυριε ουχι καλον σπερμα εσπειρασ εν τω σω αγρω ποθεν ουν εχει ζιζανια ");
INSERT INTO grcmt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ο δε εφη αυτοισ εχθροσ ανθρωποσ τουτο εποιησεν οι δε δουλοι ειπον αυτω θελεισ ουν απελθοντεσ συλλεξομεν αυτα ");
INSERT INTO grcmt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ο δε εφη ου μηποτε συλλεγοντεσ τα ζιζανια εκριζωσητε αμα αυτοισ τον σιτον ");
INSERT INTO grcmt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","αφετε συναυξανεσθαι αμφοτερα μεχρι του θερισμου και εν καιρω του θερισμου ερω τοισ θερισταισ συλλεξατε πρωτον τα ζιζανια και δησατε αυτα εισ δεσμασ προσ το κατακαυσαι αυτα τον δε σιτον συναγαγετε εισ την αποθηκην μου ");
INSERT INTO grcmt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","αλλην παραβολην παρεθηκεν αυτοισ λεγων ομοια εστιν η βασιλεια των ουρανων κοκκω σιναπεωσ ον λαβων ανθρωποσ εσπειρεν εν τω αγρω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ο μικροτερον μεν εστιν παντων των σπερματων οταν δε αυξηθη μειζον των λαχανων εστιν και γινεται δενδρον ωστε ελθειν τα πετεινα του ουρανου και κατασκηνουν εν τοισ κλαδοισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","αλλην παραβολην ελαλησεν αυτοισ ομοια εστιν η βασιλεια των ουρανων ζυμη ην λαβουσα γυνη εκρυψεν εισ αλευρου σατα τρια εωσ ου εζυμωθη ολον ");
INSERT INTO grcmt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ταυτα παντα ελαλησεν ο ιησουσ εν παραβολαισ τοισ οχλοισ και χωρισ παραβολησ ουκ ελαλει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","οπωσ πληρωθη το ρηθεν δια του προφητου λεγοντοσ ανοιξω εν παραβολαισ το στομα μου ερευξομαι κεκρυμμενα απο καταβολησ κοσμου ");
INSERT INTO grcmt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","τοτε αφεισ τουσ οχλουσ ηλθεν εισ την οικιαν ο ιησουσ και προσηλθον αυτω οι μαθηται αυτου λεγοντεσ φρασον ημιν την παραβολην των ζιζανιων του αγρου ");
INSERT INTO grcmt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ο δε αποκριθεισ ειπεν αυτοισ ο σπειρων το καλον σπερμα εστιν ο υιοσ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ο δε αγροσ εστιν ο κοσμοσ το δε καλον σπερμα ουτοι εισιν οι υιοι τησ βασιλειασ τα δε ζιζανια εισιν οι υιοι του πονηρου ");
INSERT INTO grcmt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ο δε εχθροσ ο σπειρασ αυτα εστιν ο διαβολοσ ο δε θερισμοσ συντελεια του αιωνοσ εστιν οι δε θερισται αγγελοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ωσπερ ουν συλλεγεται τα ζιζανια και πυρι καιεται ουτωσ εσται εν τη συντελεια του αιωνοσ τουτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","αποστελει ο υιοσ του ανθρωπου τουσ αγγελουσ αυτου και συλλεξουσιν εκ τησ βασιλειασ αυτου παντα τα σκανδαλα και τουσ ποιουντασ την ανομιαν ");
INSERT INTO grcmt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","και βαλουσιν αυτουσ εισ την καμινον του πυροσ εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","τοτε οι δικαιοι εκλαμψουσιν ωσ ο ηλιοσ εν τη βασιλεια του πατροσ αυτων ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","παλιν ομοια εστιν η βασιλεια των ουρανων θησαυρω κεκρυμμενω εν τω αγρω ον ευρων ανθρωποσ εκρυψεν και απο τησ χαρασ αυτου υπαγει και παντα οσα εχει πωλει και αγοραζει τον αγρον εκεινον ");
INSERT INTO grcmt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","παλιν ομοια εστιν η βασιλεια των ουρανων ανθρωπω εμπορω ζητουντι καλουσ μαργαριτασ ");
INSERT INTO grcmt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","οσ ευρων ενα πολυτιμον μαργαριτην απελθων πεπρακεν παντα οσα ειχεν και ηγορασεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","παλιν ομοια εστιν η βασιλεια των ουρανων σαγηνη βληθειση εισ την θαλασσαν και εκ παντοσ γενουσ συναγαγουση ");
INSERT INTO grcmt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ην οτε επληρωθη αναβιβασαντεσ επι τον αιγιαλον και καθισαντεσ συνελεξαν τα καλα εισ αγγεια τα δε σαπρα εξω εβαλον ");
INSERT INTO grcmt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ουτωσ εσται εν τη συντελεια του αιωνοσ εξελευσονται οι αγγελοι και αφοριουσιν τουσ πονηρουσ εκ μεσου των δικαιων ");
INSERT INTO grcmt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","και βαλουσιν αυτουσ εισ την καμινον του πυροσ εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","λεγει αυτοισ ο ιησουσ συνηκατε ταυτα παντα λεγουσιν αυτω ναι κυριε ");
INSERT INTO grcmt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ο δε ειπεν αυτοισ δια τουτο πασ γραμματευσ μαθητευθεισ εισ την βασιλειαν των ουρανων ομοιοσ εστιν ανθρωπω οικοδεσποτη οστισ εκβαλλει εκ του θησαυρου αυτου καινα και παλαια ");
INSERT INTO grcmt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","και εγενετο οτε ετελεσεν ο ιησουσ τασ παραβολασ ταυτασ μετηρεν εκειθεν ");
INSERT INTO grcmt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","και ελθων εισ την πατριδα αυτου εδιδασκεν αυτουσ εν τη συναγωγη αυτων ωστε εκπληττεσθαι αυτουσ και λεγειν ποθεν τουτω η σοφια αυτη και αι δυναμεισ ");
INSERT INTO grcmt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ουχ ουτοσ εστιν ο του τεκτονοσ υιοσ ουχι η μητηρ αυτου λεγεται μαριαμ και οι αδελφοι αυτου ιακωβοσ και ιωσησ και σιμων και ιουδασ ");
INSERT INTO grcmt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","και αι αδελφαι αυτου ουχι πασαι προσ ημασ εισιν ποθεν ουν τουτω ταυτα παντα ");
INSERT INTO grcmt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","και εσκανδαλιζοντο εν αυτω ο δε ιησουσ ειπεν αυτοισ ουκ εστιν προφητησ ατιμοσ ει μη εν τη πατριδι αυτου και εν τη οικια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","και ουκ εποιησεν εκει δυναμεισ πολλασ δια την απιστιαν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","εν εκεινω τω καιρω ηκουσεν ηρωδησ ο τετραρχησ την ακοην ιησου ");
INSERT INTO grcmt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","και ειπεν τοισ παισιν αυτου ουτοσ εστιν ιωαννησ ο βαπτιστησ αυτοσ ηγερθη απο των νεκρων και δια τουτο αι δυναμεισ ενεργουσιν εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ο γαρ ηρωδησ κρατησασ τον ιωαννην εδησεν αυτον και εθετο εν φυλακη δια ηρωδιαδα την γυναικα φιλιππου του αδελφου αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ελεγεν γαρ αυτω ο ιωαννησ ουκ εξεστιν σοι εχειν αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","και θελων αυτον αποκτειναι εφοβηθη τον οχλον οτι ωσ προφητην αυτον ειχον ");
INSERT INTO grcmt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","γενεσιων δε αγομενων του ηρωδου ωρχησατο η θυγατηρ τησ ηρωδιαδοσ εν τω μεσω και ηρεσεν τω ηρωδη ");
INSERT INTO grcmt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","οθεν μεθ ορκου ωμολογησεν αυτη δουναι ο εαν αιτησηται ");
INSERT INTO grcmt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","η δε προβιβασθεισα υπο τησ μητροσ αυτησ δοσ μοι φησιν ωδε επι πινακι την κεφαλην ιωαννου του βαπτιστου ");
INSERT INTO grcmt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","και ελυπηθη ο βασιλευσ δια δε τουσ ορκουσ και τουσ συνανακειμενουσ εκελευσεν δοθηναι ");
INSERT INTO grcmt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","και πεμψασ απεκεφαλισεν τον ιωαννην εν τη φυλακη ");
INSERT INTO grcmt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","και ηνεχθη η κεφαλη αυτου επι πινακι και εδοθη τω κορασιω και ηνεγκεν τη μητρι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","και προσελθοντεσ οι μαθηται αυτου ηραν το σωμα και εθαψαν αυτο και ελθοντεσ απηγγειλαν τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","και ακουσασ ο ιησουσ ανεχωρησεν εκειθεν εν πλοιω εισ ερημον τοπον κατ ιδιαν και ακουσαντεσ οι οχλοι ηκολουθησαν αυτω πεζη απο των πολεων ");
INSERT INTO grcmt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","και εξελθων ο ιησουσ ειδεν πολυν οχλον και εσπλαγχνισθη επ αυτοισ και εθεραπευσεν τουσ αρρωστουσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","οψιασ δε γενομενησ προσηλθον αυτω οι μαθηται αυτου λεγοντεσ ερημοσ εστιν ο τοποσ και η ωρα ηδη παρηλθεν απολυσον τουσ οχλουσ ινα απελθοντεσ εισ τασ κωμασ αγορασωσιν εαυτοισ βρωματα ");
INSERT INTO grcmt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ο δε ιησουσ ειπεν αυτοισ ου χρειαν εχουσιν απελθειν δοτε αυτοισ υμεισ φαγειν ");
INSERT INTO grcmt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","οι δε λεγουσιν αυτω ουκ εχομεν ωδε ει μη πεντε αρτουσ και δυο ιχθυασ ");
INSERT INTO grcmt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ο δε ειπεν φερετε μοι αυτουσ ωδε ");
INSERT INTO grcmt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","και κελευσασ τουσ οχλουσ ανακλιθηναι επι τουσ χορτουσ λαβων τουσ πεντε αρτουσ και τουσ δυο ιχθυασ αναβλεψασ εισ τον ουρανον ευλογησεν και κλασασ εδωκεν τοισ μαθηταισ τουσ αρτουσ οι δε μαθηται τοισ οχλοισ ");
INSERT INTO grcmt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","και εφαγον παντεσ και εχορτασθησαν και ηραν το περισσευον των κλασματων δωδεκα κοφινουσ πληρεισ ");
INSERT INTO grcmt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","οι δε εσθιοντεσ ησαν ανδρεσ ωσει πεντακισχιλιοι χωρισ γυναικων και παιδιων ");
INSERT INTO grcmt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","και ευθεωσ ηναγκασεν ο ιησουσ τουσ μαθητασ εμβηναι εισ το πλοιον και προαγειν αυτον εισ το περαν εωσ ου απολυση τουσ οχλουσ ");
INSERT INTO grcmt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","και απολυσασ τουσ οχλουσ ανεβη εισ το οροσ κατ ιδιαν προσευξασθαι οψιασ δε γενομενησ μονοσ ην εκει ");
INSERT INTO grcmt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","το δε πλοιον ηδη μεσον τησ θαλασσησ ην βασανιζομενον υπο των κυματων ην γαρ εναντιοσ ο ανεμοσ ");
INSERT INTO grcmt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","τεταρτη δε φυλακη τησ νυκτοσ απηλθεν προσ αυτουσ ο ιησουσ περιπατων επι τησ θαλασσησ ");
INSERT INTO grcmt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","και ιδοντεσ αυτον οι μαθηται επι την θαλασσαν περιπατουντα εταραχθησαν λεγοντεσ οτι φαντασμα εστιν και απο του φοβου εκραξαν ");
INSERT INTO grcmt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ευθεωσ δε ελαλησεν αυτοισ ο ιησουσ λεγων θαρσειτε εγω ειμι μη φοβεισθε ");
INSERT INTO grcmt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","αποκριθεισ δε αυτω ο πετροσ ειπεν κυριε ει συ ει κελευσον με προσ σε ελθειν επι τα υδατα ");
INSERT INTO grcmt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ο δε ειπεν ελθε και καταβασ απο του πλοιου ο πετροσ περιεπατησεν επι τα υδατα ελθειν προσ τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","βλεπων δε τον ανεμον ισχυρον εφοβηθη και αρξαμενοσ καταποντιζεσθαι εκραξεν λεγων κυριε σωσον με ");
INSERT INTO grcmt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ευθεωσ δε ο ιησουσ εκτεινασ την χειρα επελαβετο αυτου και λεγει αυτω ολιγοπιστε εισ τι εδιστασασ ");
INSERT INTO grcmt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","και εμβαντων αυτων εισ το πλοιον εκοπασεν ο ανεμοσ ");
INSERT INTO grcmt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","οι δε εν τω πλοιω ελθοντεσ προσεκυνησαν αυτω λεγοντεσ αληθωσ θεου υιοσ ει ");
INSERT INTO grcmt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","και διαπερασαντεσ ηλθον εισ την γην γεννησαρετ ");
INSERT INTO grcmt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","και επιγνοντεσ αυτον οι ανδρεσ του τοπου εκεινου απεστειλαν εισ ολην την περιχωρον εκεινην και προσηνεγκαν αυτω παντασ τουσ κακωσ εχοντασ ");
INSERT INTO grcmt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","και παρεκαλουν αυτον ινα μονον αψωνται του κρασπεδου του ιματιου αυτου και οσοι ηψαντο διεσωθησαν ");
INSERT INTO grcmt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","τοτε προσερχονται τω ιησου οι απο ιεροσολυμων γραμματεισ και φαρισαιοι λεγοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","δια τι οι μαθηται σου παραβαινουσιν την παραδοσιν των πρεσβυτερων ου γαρ νιπτονται τασ χειρασ αυτων οταν αρτον εσθιωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ο δε αποκριθεισ ειπεν αυτοισ δια τι και υμεισ παραβαινετε την εντολην του θεου δια την παραδοσιν υμων ");
INSERT INTO grcmt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ο γαρ θεοσ ενετειλατο λεγων τιμα τον πατερα και την μητερα και ο κακολογων πατερα η μητερα θανατω τελευτατω ");
INSERT INTO grcmt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","υμεισ δε λεγετε οσ αν ειπη τω πατρι η τη μητρι δωρον ο εαν εξ εμου ωφεληθησ και ου μη τιμηση τον πατερα αυτου η την μητερα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","και ηκυρωσατε την εντολην του θεου δια την παραδοσιν υμων ");
INSERT INTO grcmt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","υποκριται καλωσ προεφητευσεν περι υμων ησαιασ λεγων ");
INSERT INTO grcmt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","εγγιζει μοι ο λαοσ ουτοσ τω στοματι αυτων και τοισ χειλεσιν με τιμα η δε καρδια αυτων πορρω απεχει απ εμου ");
INSERT INTO grcmt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ματην δε σεβονται με διδασκοντεσ διδασκαλιασ ενταλματα ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","και προσκαλεσαμενοσ τον οχλον ειπεν αυτοισ ακουετε και συνιετε ");
INSERT INTO grcmt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ου το εισερχομενον εισ το στομα κοινοι τον ανθρωπον αλλα το εκπορευομενον εκ του στοματοσ τουτο κοινοι τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","τοτε προσελθοντεσ οι μαθηται αυτου ειπον αυτω οιδασ οτι οι φαρισαιοι ακουσαντεσ τον λογον εσκανδαλισθησαν ");
INSERT INTO grcmt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ο δε αποκριθεισ ειπεν πασα φυτεια ην ουκ εφυτευσεν ο πατηρ μου ο ουρανιοσ εκριζωθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","αφετε αυτουσ οδηγοι εισιν τυφλοι τυφλων τυφλοσ δε τυφλον εαν οδηγη αμφοτεροι εισ βοθυνον πεσουνται ");
INSERT INTO grcmt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","αποκριθεισ δε ο πετροσ ειπεν αυτω φρασον ημιν την παραβολην ταυτην ");
INSERT INTO grcmt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ο δε ιησουσ ειπεν ακμην και υμεισ ασυνετοι εστε ");
INSERT INTO grcmt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ουπω νοειτε οτι παν το εισπορευομενον εισ το στομα εισ την κοιλιαν χωρει και εισ αφεδρωνα εκβαλλεται ");
INSERT INTO grcmt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","τα δε εκπορευομενα εκ του στοματοσ εκ τησ καρδιασ εξερχεται κακεινα κοινοι τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","εκ γαρ τησ καρδιασ εξερχονται διαλογισμοι πονηροι φονοι μοιχειαι πορνειαι κλοπαι ψευδομαρτυριαι βλασφημιαι ");
INSERT INTO grcmt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ταυτα εστιν τα κοινουντα τον ανθρωπον το δε ανιπτοισ χερσιν φαγειν ου κοινοι τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","και εξελθων εκειθεν ο ιησουσ ανεχωρησεν εισ τα μερη τυρου και σιδωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","και ιδου γυνη χαναναια απο των οριων εκεινων εξελθουσα εκραυγασεν αυτω λεγουσα ελεησον με κυριε υιε δαυιδ η θυγατηρ μου κακωσ δαιμονιζεται ");
INSERT INTO grcmt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ο δε ουκ απεκριθη αυτη λογον και προσελθοντεσ οι μαθηται αυτου ηρωτων αυτον λεγοντεσ απολυσον αυτην οτι κραζει οπισθεν ημων ");
INSERT INTO grcmt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ο δε αποκριθεισ ειπεν ουκ απεσταλην ει μη εισ τα προβατα τα απολωλοτα οικου ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","η δε ελθουσα προσεκυνησεν αυτω λεγουσα κυριε βοηθει μοι ");
INSERT INTO grcmt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ο δε αποκριθεισ ειπεν ουκ εστιν καλον λαβειν τον αρτον των τεκνων και βαλειν τοισ κυναριοισ ");
INSERT INTO grcmt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","η δε ειπεν ναι κυριε και γαρ τα κυναρια εσθιει απο των ψιχιων των πιπτοντων απο τησ τραπεζησ των κυριων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","τοτε αποκριθεισ ο ιησουσ ειπεν αυτη ω γυναι μεγαλη σου η πιστισ γενηθητω σοι ωσ θελεισ και ιαθη η θυγατηρ αυτησ απο τησ ωρασ εκεινησ ");
INSERT INTO grcmt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","και μεταβασ εκειθεν ο ιησουσ ηλθεν παρα την θαλασσαν τησ γαλιλαιασ και αναβασ εισ το οροσ εκαθητο εκει ");
INSERT INTO grcmt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","και προσηλθον αυτω οχλοι πολλοι εχοντεσ μεθ εαυτων χωλουσ τυφλουσ κωφουσ κυλλουσ και ετερουσ πολλουσ και ερριψαν αυτουσ παρα τουσ ποδασ του ιησου και εθεραπευσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ωστε τουσ οχλουσ θαυμασαι βλεποντασ κωφουσ λαλουντασ κυλλουσ υγιεισ χωλουσ περιπατουντασ και τυφλουσ βλεποντασ και εδοξασαν τον θεον ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ο δε ιησουσ προσκαλεσαμενοσ τουσ μαθητασ αυτου ειπεν σπλαγχνιζομαι επι τον οχλον οτι ηδη ημεραι τρεισ προσμενουσιν μοι και ουκ εχουσιν τι φαγωσιν και απολυσαι αυτουσ νηστεισ ου θελω μηποτε εκλυθωσιν εν τη οδω ");
INSERT INTO grcmt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","και λεγουσιν αυτω οι μαθηται αυτου ποθεν ημιν εν ερημια αρτοι τοσουτοι ωστε χορτασαι οχλον τοσουτον ");
INSERT INTO grcmt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","και λεγει αυτοισ ο ιησουσ ποσουσ αρτουσ εχετε οι δε ειπον επτα και ολιγα ιχθυδια ");
INSERT INTO grcmt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","και εκελευσεν τοισ οχλοισ αναπεσειν επι την γην ");
INSERT INTO grcmt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","και λαβων τουσ επτα αρτουσ και τουσ ιχθυασ ευχαριστησασ εκλασεν και εδωκεν τοισ μαθηταισ αυτου οι δε μαθηται τω οχλω ");
INSERT INTO grcmt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","και εφαγον παντεσ και εχορτασθησαν και ηραν το περισσευον των κλασματων επτα σπυριδασ πληρεισ ");
INSERT INTO grcmt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","οι δε εσθιοντεσ ησαν τετρακισχιλιοι ανδρεσ χωρισ γυναικων και παιδιων ");
INSERT INTO grcmt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","και απολυσασ τουσ οχλουσ ενεβη εισ το πλοιον και ηλθεν εισ τα ορια μαγδαλα ");
INSERT INTO grcmt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","και προσελθοντεσ οι φαρισαιοι και σαδδουκαιοι πειραζοντεσ επηρωτησαν αυτον σημειον εκ του ουρανου επιδειξαι αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ο δε αποκριθεισ ειπεν αυτοισ οψιασ γενομενησ λεγετε ευδια πυρραζει γαρ ο ουρανοσ ");
INSERT INTO grcmt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","και πρωι σημερον χειμων πυρραζει γαρ στυγναζων ο ουρανοσ υποκριται το μεν προσωπον του ουρανου γινωσκετε διακρινειν τα δε σημεια των καιρων ου δυνασθε ");
INSERT INTO grcmt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","γενεα πονηρα και μοιχαλισ σημειον επιζητει και σημειον ου δοθησεται αυτη ει μη το σημειον ιωνα του προφητου και καταλιπων αυτουσ απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","και ελθοντεσ οι μαθηται αυτου εισ το περαν επελαθοντο αρτουσ λαβειν ");
INSERT INTO grcmt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ο δε ιησουσ ειπεν αυτοισ ορατε και προσεχετε απο τησ ζυμησ των φαρισαιων και σαδδουκαιων ");
INSERT INTO grcmt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","οι δε διελογιζοντο εν εαυτοισ λεγοντεσ οτι αρτουσ ουκ ελαβομεν ");
INSERT INTO grcmt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","γνουσ δε ο ιησουσ ειπεν αυτοισ τι διαλογιζεσθε εν εαυτοισ ολιγοπιστοι οτι αρτουσ ουκ ελαβετε ");
INSERT INTO grcmt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ουπω νοειτε ουδε μνημονευετε τουσ πεντε αρτουσ των πεντακισχιλιων και ποσουσ κοφινουσ ελαβετε ");
INSERT INTO grcmt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ουδε τουσ επτα αρτουσ των τετρακισχιλιων και ποσασ σπυριδασ ελαβετε ");
INSERT INTO grcmt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","πωσ ου νοειτε οτι ου περι αρτου ειπον υμιν προσεχειν απο τησ ζυμησ των φαρισαιων και σαδδουκαιων ");
INSERT INTO grcmt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","τοτε συνηκαν οτι ουκ ειπεν προσεχειν απο τησ ζυμησ του αρτου αλλα απο τησ διδαχησ των φαρισαιων και σαδδουκαιων ");
INSERT INTO grcmt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ελθων δε ο ιησουσ εισ τα μερη καισαρειασ τησ φιλιππου ηρωτα τουσ μαθητασ αυτου λεγων τινα με λεγουσιν οι ανθρωποι ειναι τον υιον του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","οι δε ειπον οι μεν ιωαννην τον βαπτιστην αλλοι δε ηλιαν ετεροι δε ιερεμιαν η ενα των προφητων ");
INSERT INTO grcmt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","λεγει αυτοισ υμεισ δε τινα με λεγετε ειναι ");
INSERT INTO grcmt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","αποκριθεισ δε σιμων πετροσ ειπεν συ ει ο χριστοσ ο υιοσ του θεου του ζωντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","και αποκριθεισ ο ιησουσ ειπεν αυτω μακαριοσ ει σιμων βαριωνα οτι σαρξ και αιμα ουκ απεκαλυψεν σοι αλλ ο πατηρ μου ο εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","καγω δε σοι λεγω οτι συ ει πετροσ και επι ταυτη τη πετρα οικοδομησω μου την εκκλησιαν και πυλαι αδου ου κατισχυσουσιν αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","και δωσω σοι τασ κλεισ τησ βασιλειασ των ουρανων και ο εαν δησησ επι τησ γησ εσται δεδεμενον εν τοισ ουρανοισ και ο εαν λυσησ επι τησ γησ εσται λελυμενον εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","τοτε διεστειλατο τοισ μαθηταισ αυτου ινα μηδενι ειπωσιν οτι αυτοσ εστιν ιησουσ ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","απο τοτε ηρξατο ο ιησουσ δεικνυειν τοισ μαθηταισ αυτου οτι δει αυτον απελθειν εισ ιεροσολυμα και πολλα παθειν απο των πρεσβυτερων και αρχιερεων και γραμματεων και αποκτανθηναι και τη τριτη ημερα εγερθηναι ");
INSERT INTO grcmt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","και προσλαβομενοσ αυτον ο πετροσ ηρξατο επιτιμαν αυτω λεγων ιλεωσ σοι κυριε ου μη εσται σοι τουτο ");
INSERT INTO grcmt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ο δε στραφεισ ειπεν τω πετρω υπαγε οπισω μου σατανα σκανδαλον μου ει οτι ου φρονεισ τα του θεου αλλα τα των ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","τοτε ο ιησουσ ειπεν τοισ μαθηταισ αυτου ει τισ θελει οπισω μου ελθειν απαρνησασθω εαυτον και αρατω τον σταυρον αυτου και ακολουθειτω μοι ");
INSERT INTO grcmt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","οσ γαρ αν θελη την ψυχην αυτου σωσαι απολεσει αυτην οσ δ αν απολεση την ψυχην αυτου ενεκεν εμου ευρησει αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","τι γαρ ωφελειται ανθρωποσ εαν τον κοσμον ολον κερδηση την δε ψυχην αυτου ζημιωθη η τι δωσει ανθρωποσ ανταλλαγμα τησ ψυχησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","μελλει γαρ ο υιοσ του ανθρωπου ερχεσθαι εν τη δοξη του πατροσ αυτου μετα των αγγελων αυτου και τοτε αποδωσει εκαστω κατα την πραξιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","αμην λεγω υμιν εισιν τινεσ ωδε εστωτεσ οιτινεσ ου μη γευσωνται θανατου εωσ αν ιδωσιν τον υιον του ανθρωπου ερχομενον εν τη βασιλεια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","και μεθ ημερασ εξ παραλαμβανει ο ιησουσ τον πετρον και ιακωβον και ιωαννην τον αδελφον αυτου και αναφερει αυτουσ εισ οροσ υψηλον κατ ιδιαν ");
INSERT INTO grcmt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","και μετεμορφωθη εμπροσθεν αυτων και ελαμψεν το προσωπον αυτου ωσ ο ηλιοσ τα δε ιματια αυτου εγενοντο λευκα ωσ το φωσ ");
INSERT INTO grcmt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","και ιδου ωφθησαν αυτοισ μωσησ και ηλιασ μετ αυτου συλλαλουντεσ ");
INSERT INTO grcmt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","αποκριθεισ δε ο πετροσ ειπεν τω ιησου κυριε καλον εστιν ημασ ωδε ειναι ει θελεισ ποιησωμεν ωδε τρεισ σκηνασ σοι μιαν και μωση μιαν και μιαν ηλια ");
INSERT INTO grcmt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ετι αυτου λαλουντοσ ιδου νεφελη φωτεινη επεσκιασεν αυτουσ και ιδου φωνη εκ τησ νεφελησ λεγουσα ουτοσ εστιν ο υιοσ μου ο αγαπητοσ εν ω ευδοκησα αυτου ακουετε ");
INSERT INTO grcmt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","και ακουσαντεσ οι μαθηται επεσον επι προσωπον αυτων και εφοβηθησαν σφοδρα ");
INSERT INTO grcmt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","και προσελθων ο ιησουσ ηψατο αυτων και ειπεν εγερθητε και μη φοβεισθε ");
INSERT INTO grcmt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","επαραντεσ δε τουσ οφθαλμουσ αυτων ουδενα ειδον ει μη τον ιησουν μονον ");
INSERT INTO grcmt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","και καταβαινοντων αυτων εκ του ορουσ ενετειλατο αυτοισ ο ιησουσ λεγων μηδενι ειπητε το οραμα εωσ ου ο υιοσ του ανθρωπου εκ νεκρων αναστη ");
INSERT INTO grcmt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","και επηρωτησαν αυτον οι μαθηται αυτου λεγοντεσ τι ουν οι γραμματεισ λεγουσιν οτι ηλιαν δει ελθειν πρωτον ");
INSERT INTO grcmt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ο δε ιησουσ αποκριθεισ ειπεν αυτοισ ηλιασ μεν ερχεται πρωτον και αποκαταστησει παντα ");
INSERT INTO grcmt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","λεγω δε υμιν οτι ηλιασ ηδη ηλθεν και ουκ επεγνωσαν αυτον αλλα εποιησαν εν αυτω οσα ηθελησαν ουτωσ και ο υιοσ του ανθρωπου μελλει πασχειν υπ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","τοτε συνηκαν οι μαθηται οτι περι ιωαννου του βαπτιστου ειπεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","και ελθοντων αυτων προσ τον οχλον προσηλθεν αυτω ανθρωποσ γονυπετων αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","και λεγων κυριε ελεησον μου τον υιον οτι σεληνιαζεται και κακωσ πασχει πολλακισ γαρ πιπτει εισ το πυρ και πολλακισ εισ το υδωρ ");
INSERT INTO grcmt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","και προσηνεγκα αυτον τοισ μαθηταισ σου και ουκ ηδυνηθησαν αυτον θεραπευσαι ");
INSERT INTO grcmt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","αποκριθεισ δε ο ιησουσ ειπεν ω γενεα απιστοσ και διεστραμμενη εωσ ποτε εσομαι μεθ υμων εωσ ποτε ανεξομαι υμων φερετε μοι αυτον ωδε ");
INSERT INTO grcmt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","και επετιμησεν αυτω ο ιησουσ και εξηλθεν απ αυτου το δαιμονιον και εθεραπευθη ο παισ απο τησ ωρασ εκεινησ ");
INSERT INTO grcmt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","τοτε προσελθοντεσ οι μαθηται τω ιησου κατ ιδιαν ειπον δια τι ημεισ ουκ ηδυνηθημεν εκβαλειν αυτο ");
INSERT INTO grcmt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ο δε ιησουσ ειπεν αυτοισ δια την απιστιαν υμων αμην γαρ λεγω υμιν εαν εχητε πιστιν ωσ κοκκον σιναπεωσ ερειτε τω ορει τουτω μεταβηθι εντευθεν εκει και μεταβησεται και ουδεν αδυνατησει υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","τουτο δε το γενοσ ουκ εκπορευεται ει μη εν προσευχη και νηστεια ");
INSERT INTO grcmt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","αναστρεφομενων δε αυτων εν τη γαλιλαια ειπεν αυτοισ ο ιησουσ μελλει ο υιοσ του ανθρωπου παραδιδοσθαι εισ χειρασ ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","και αποκτενουσιν αυτον και τη τριτη ημερα εγερθησεται και ελυπηθησαν σφοδρα ");
INSERT INTO grcmt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ελθοντων δε αυτων εισ καπερναουμ προσηλθον οι τα διδραχμα λαμβανοντεσ τω πετρω και ειπον ο διδασκαλοσ υμων ου τελει τα διδραχμα ");
INSERT INTO grcmt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","λεγει ναι και οτε εισηλθεν εισ την οικιαν προεφθασεν αυτον ο ιησουσ λεγων τι σοι δοκει σιμων οι βασιλεισ τησ γησ απο τινων λαμβανουσιν τελη η κηνσον απο των υιων αυτων η απο των αλλοτριων ");
INSERT INTO grcmt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","λεγει αυτω ο πετροσ απο των αλλοτριων εφη αυτω ο ιησουσ αρα γε ελευθεροι εισιν οι υιοι ");
INSERT INTO grcmt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ινα δε μη σκανδαλισωμεν αυτουσ πορευθεισ εισ την θαλασσαν βαλε αγκιστρον και τον αναβαινοντα πρωτον ιχθυν αρον και ανοιξασ το στομα αυτου ευρησεισ στατηρα εκεινον λαβων δοσ αυτοισ αντι εμου και σου ");
INSERT INTO grcmt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","εν εκεινη τη ωρα προσηλθον οι μαθηται τω ιησου λεγοντεσ τισ αρα μειζων εστιν εν τη βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","και προσκαλεσαμενοσ ο ιησουσ παιδιον εστησεν αυτο εν μεσω αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","και ειπεν αμην λεγω υμιν εαν μη στραφητε και γενησθε ωσ τα παιδια ου μη εισελθητε εισ την βασιλειαν των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","οστισ ουν ταπεινωσει εαυτον ωσ το παιδιον τουτο ουτοσ εστιν ο μειζων εν τη βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","και οσ εαν δεξηται παιδιον τοιουτον εν επι τω ονοματι μου εμε δεχεται ");
INSERT INTO grcmt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","οσ δ αν σκανδαλιση ενα των μικρων τουτων των πιστευοντων εισ εμε συμφερει αυτω ινα κρεμασθη μυλοσ ονικοσ εισ τον τραχηλον αυτου και καταποντισθη εν τω πελαγει τησ θαλασσησ ");
INSERT INTO grcmt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ουαι τω κοσμω απο των σκανδαλων αναγκη γαρ εστιν ελθειν τα σκανδαλα πλην ουαι τω ανθρωπω εκεινω δι ου το σκανδαλον ερχεται ");
INSERT INTO grcmt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ει δε η χειρ σου η ο πουσ σου σκανδαλιζει σε εκκοψον αυτα και βαλε απο σου καλον σοι εστιν εισελθειν εισ την ζωην χωλον η κυλλον η δυο χειρασ η δυο ποδασ εχοντα βληθηναι εισ το πυρ το αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","και ει ο οφθαλμοσ σου σκανδαλιζει σε εξελε αυτον και βαλε απο σου καλον σοι εστιν μονοφθαλμον εισ την ζωην εισελθειν η δυο οφθαλμουσ εχοντα βληθηναι εισ την γεενναν του πυροσ ");
INSERT INTO grcmt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ορατε μη καταφρονησητε ενοσ των μικρων τουτων λεγω γαρ υμιν οτι οι αγγελοι αυτων εν ουρανοισ δια παντοσ βλεπουσιν το προσωπον του πατροσ μου του εν ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ηλθεν γαρ ο υιοσ του ανθρωπου σωσαι το απολωλοσ ");
INSERT INTO grcmt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","τι υμιν δοκει εαν γενηται τινι ανθρωπω εκατον προβατα και πλανηθη εν εξ αυτων ουχι αφεισ τα ενενηκοντα εννεα επι τα ορη πορευθεισ ζητει το πλανωμενον ");
INSERT INTO grcmt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","και εαν γενηται ευρειν αυτο αμην λεγω υμιν οτι χαιρει επ αυτω μαλλον η επι τοισ ενενηκοντα εννεα τοισ μη πεπλανημενοισ ");
INSERT INTO grcmt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ουτωσ ουκ εστιν θελημα εμπροσθεν του πατροσ υμων του εν ουρανοισ ινα αποληται εισ των μικρων τουτων ");
INSERT INTO grcmt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","εαν δε αμαρτηση εισ σε ο αδελφοσ σου υπαγε και ελεγξον αυτον μεταξυ σου και αυτου μονου εαν σου ακουση εκερδησασ τον αδελφον σου ");
INSERT INTO grcmt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","εαν δε μη ακουση παραλαβε μετα σου ετι ενα η δυο ινα επι στοματοσ δυο μαρτυρων η τριων σταθη παν ρημα ");
INSERT INTO grcmt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","εαν δε παρακουση αυτων ειπε τη εκκλησια εαν δε και τησ εκκλησιασ παρακουση εστω σοι ωσπερ ο εθνικοσ και ο τελωνησ ");
INSERT INTO grcmt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","αμην λεγω υμιν οσα εαν δησητε επι τησ γησ εσται δεδεμενα εν τω ουρανω και οσα εαν λυσητε επι τησ γησ εσται λελυμενα εν τω ουρανω ");
INSERT INTO grcmt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","παλιν αμην λεγω υμιν οτι εαν δυο υμων συμφωνησωσιν επι τησ γησ περι παντοσ πραγματοσ ου εαν αιτησωνται γενησεται αυτοισ παρα του πατροσ μου του εν ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ου γαρ εισιν δυο η τρεισ συνηγμενοι εισ το εμον ονομα εκει ειμι εν μεσω αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","τοτε προσελθων αυτω ο πετροσ ειπεν κυριε ποσακισ αμαρτησει εισ εμε ο αδελφοσ μου και αφησω αυτω εωσ επτακισ ");
INSERT INTO grcmt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","λεγει αυτω ο ιησουσ ου λεγω σοι εωσ επτακισ αλλ εωσ εβδομηκοντακισ επτα ");
INSERT INTO grcmt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","δια τουτο ωμοιωθη η βασιλεια των ουρανων ανθρωπω βασιλει οσ ηθελησεν συναραι λογον μετα των δουλων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","αρξαμενου δε αυτου συναιρειν προσηνεχθη αυτω εισ οφειλετησ μυριων ταλαντων ");
INSERT INTO grcmt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","μη εχοντοσ δε αυτου αποδουναι εκελευσεν αυτον ο κυριοσ αυτου πραθηναι και την γυναικα αυτου και τα τεκνα και παντα οσα ειχεν και αποδοθηναι ");
INSERT INTO grcmt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","πεσων ουν ο δουλοσ προσεκυνει αυτω λεγων κυριε μακροθυμησον επ εμοι και παντα σοι αποδωσω ");
INSERT INTO grcmt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","σπλαγχνισθεισ δε ο κυριοσ του δουλου εκεινου απελυσεν αυτον και το δανειον αφηκεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","εξελθων δε ο δουλοσ εκεινοσ ευρεν ενα των συνδουλων αυτου οσ ωφειλεν αυτω εκατον δηναρια και κρατησασ αυτον επνιγεν λεγων αποδοσ μοι ει τι οφειλεισ ");
INSERT INTO grcmt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","πεσων ουν ο συνδουλοσ αυτου εισ τουσ ποδασ αυτου παρεκαλει αυτον λεγων μακροθυμησον επ εμοι και αποδωσω σοι ");
INSERT INTO grcmt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ο δε ουκ ηθελεν αλλα απελθων εβαλεν αυτον εισ φυλακην εωσ ου αποδω το οφειλομενον ");
INSERT INTO grcmt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ιδοντεσ δε οι συνδουλοι αυτου τα γενομενα ελυπηθησαν σφοδρα και ελθοντεσ διεσαφησαν τω κυριω εαυτων παντα τα γενομενα ");
INSERT INTO grcmt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","τοτε προσκαλεσαμενοσ αυτον ο κυριοσ αυτου λεγει αυτω δουλε πονηρε πασαν την οφειλην εκεινην αφηκα σοι επει παρεκαλεσασ με ");
INSERT INTO grcmt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ουκ εδει και σε ελεησαι τον συνδουλον σου ωσ και εγω σε ηλεησα ");
INSERT INTO grcmt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","και οργισθεισ ο κυριοσ αυτου παρεδωκεν αυτον τοισ βασανισταισ εωσ ου αποδω παν το οφειλομενον αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ουτωσ και ο πατηρ μου ο επουρανιοσ ποιησει υμιν εαν μη αφητε εκαστοσ τω αδελφω αυτου απο των καρδιων υμων τα παραπτωματα αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","και εγενετο οτε ετελεσεν ο ιησουσ τουσ λογουσ τουτουσ μετηρεν απο τησ γαλιλαιασ και ηλθεν εισ τα ορια τησ ιουδαιασ περαν του ιορδανου ");
INSERT INTO grcmt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","και ηκολουθησαν αυτω οχλοι πολλοι και εθεραπευσεν αυτουσ εκει ");
INSERT INTO grcmt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","και προσηλθον αυτω οι φαρισαιοι πειραζοντεσ αυτον και λεγοντεσ αυτω ει εξεστιν ανθρωπω απολυσαι την γυναικα αυτου κατα πασαν αιτιαν ");
INSERT INTO grcmt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ο δε αποκριθεισ ειπεν αυτοισ ουκ ανεγνωτε οτι ο ποιησασ απ αρχησ αρσεν και θηλυ εποιησεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","και ειπεν ενεκεν τουτου καταλειψει ανθρωποσ τον πατερα και την μητερα και προσκολληθησεται τη γυναικι αυτου και εσονται οι δυο εισ σαρκα μιαν ");
INSERT INTO grcmt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ωστε ουκετι εισιν δυο αλλα σαρξ μια ο ουν ο θεοσ συνεζευξεν ανθρωποσ μη χωριζετω ");
INSERT INTO grcmt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","λεγουσιν αυτω τι ουν μωσησ ενετειλατο δουναι βιβλιον αποστασιου και απολυσαι αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","λεγει αυτοισ οτι μωσησ προσ την σκληροκαρδιαν υμων επετρεψεν υμιν απολυσαι τασ γυναικασ υμων απ αρχησ δε ου γεγονεν ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","λεγω δε υμιν οτι οσ αν απολυση την γυναικα αυτου μη επι πορνεια και γαμηση αλλην μοιχαται και ο απολελυμενην γαμησασ μοιχαται ");
INSERT INTO grcmt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","λεγουσιν αυτω οι μαθηται αυτου ει ουτωσ εστιν η αιτια του ανθρωπου μετα τησ γυναικοσ ου συμφερει γαμησαι ");
INSERT INTO grcmt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ο δε ειπεν αυτοισ ου παντεσ χωρουσιν τον λογον τουτον αλλ οισ δεδοται ");
INSERT INTO grcmt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","εισιν γαρ ευνουχοι οιτινεσ εκ κοιλιασ μητροσ εγεννηθησαν ουτωσ και εισιν ευνουχοι οιτινεσ ευνουχισθησαν υπο των ανθρωπων και εισιν ευνουχοι οιτινεσ ευνουχισαν εαυτουσ δια την βασιλειαν των ουρανων ο δυναμενοσ χωρειν χωρειτω ");
INSERT INTO grcmt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","τοτε προσηνεχθη αυτω παιδια ινα τασ χειρασ επιθη αυτοισ και προσευξηται οι δε μαθηται επετιμησαν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ο δε ιησουσ ειπεν αφετε τα παιδια και μη κωλυετε αυτα ελθειν προσ με των γαρ τοιουτων εστιν η βασιλεια των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","και επιθεισ αυτοισ τασ χειρασ επορευθη εκειθεν ");
INSERT INTO grcmt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","και ιδου εισ προσελθων ειπεν αυτω διδασκαλε αγαθε τι αγαθον ποιησω ινα εχω ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ο δε ειπεν αυτω τι με λεγεισ αγαθον ουδεισ αγαθοσ ει μη εισ ο θεοσ ει δε θελεισ εισελθειν εισ την ζωην τηρησον τασ εντολασ ");
INSERT INTO grcmt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","λεγει αυτω ποιασ ο δε ιησουσ ειπεν το ου φονευσεισ ου μοιχευσεισ ου κλεψεισ ου ψευδομαρτυρησεισ ");
INSERT INTO grcmt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","τιμα τον πατερα και την μητερα και αγαπησεισ τον πλησιον σου ωσ σεαυτον ");
INSERT INTO grcmt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","λεγει αυτω ο νεανισκοσ παντα ταυτα εφυλαξαμην εκ νεοτητοσ μου τι ετι υστερω ");
INSERT INTO grcmt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","εφη αυτω ο ιησουσ ει θελεισ τελειοσ ειναι υπαγε πωλησον σου τα υπαρχοντα και δοσ πτωχοισ και εξεισ θησαυρον εν ουρανω και δευρο ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ακουσασ δε ο νεανισκοσ τον λογον απηλθεν λυπουμενοσ ην γαρ εχων κτηματα πολλα ");
INSERT INTO grcmt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ο δε ιησουσ ειπεν τοισ μαθηταισ αυτου αμην λεγω υμιν οτι δυσκολωσ πλουσιοσ εισελευσεται εισ την βασιλειαν των ουρανων ");
INSERT INTO grcmt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","παλιν δε λεγω υμιν ευκοπωτερον εστιν καμηλον δια τρυπηματοσ ραφιδοσ διελθειν η πλουσιον εισ την βασιλειαν του θεου εισελθειν ");
INSERT INTO grcmt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ακουσαντεσ δε οι μαθηται αυτου εξεπλησσοντο σφοδρα λεγοντεσ τισ αρα δυναται σωθηναι ");
INSERT INTO grcmt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","εμβλεψασ δε ο ιησουσ ειπεν αυτοισ παρα ανθρωποισ τουτο αδυνατον εστιν παρα δε θεω παντα δυνατα ");
INSERT INTO grcmt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","τοτε αποκριθεισ ο πετροσ ειπεν αυτω ιδου ημεισ αφηκαμεν παντα και ηκολουθησαμεν σοι τι αρα εσται ημιν ");
INSERT INTO grcmt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ο δε ιησουσ ειπεν αυτοισ αμην λεγω υμιν οτι υμεισ οι ακολουθησαντεσ μοι εν τη παλιγγενεσια οταν καθιση ο υιοσ του ανθρωπου επι θρονου δοξησ αυτου καθισεσθε και υμεισ επι δωδεκα θρονουσ κρινοντεσ τασ δωδεκα φυλασ του ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","και πασ οσ αφηκεν οικιασ η αδελφουσ η αδελφασ η πατερα η μητερα η γυναικα η τεκνα η αγρουσ ενεκεν του ονοματοσ μου εκατονταπλασιονα ληψεται και ζωην αιωνιον κληρονομησει ");
INSERT INTO grcmt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","πολλοι δε εσονται πρωτοι εσχατοι και εσχατοι πρωτοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ομοια γαρ εστιν η βασιλεια των ουρανων ανθρωπω οικοδεσποτη οστισ εξηλθεν αμα πρωι μισθωσασθαι εργατασ εισ τον αμπελωνα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","και συμφωνησασ μετα των εργατων εκ δηναριου την ημεραν απεστειλεν αυτουσ εισ τον αμπελωνα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","και εξελθων περι τριτην ωραν ειδεν αλλουσ εστωτασ εν τη αγορα αργουσ ");
INSERT INTO grcmt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","και εκεινοισ ειπεν υπαγετε και υμεισ εισ τον αμπελωνα και ο εαν η δικαιον δωσω υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","οι δε απηλθον παλιν εξελθων περι εκτην και ενατην ωραν εποιησεν ωσαυτωσ ");
INSERT INTO grcmt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","περι δε την ενδεκατην ωραν εξελθων ευρεν αλλουσ εστωτασ αργουσ και λεγει αυτοισ τι ωδε εστηκατε ολην την ημεραν αργοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","λεγουσιν αυτω οτι ουδεισ ημασ εμισθωσατο λεγει αυτοισ υπαγετε και υμεισ εισ τον αμπελωνα και ο εαν η δικαιον ληψεσθε ");
INSERT INTO grcmt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","οψιασ δε γενομενησ λεγει ο κυριοσ του αμπελωνοσ τω επιτροπω αυτου καλεσον τουσ εργατασ και αποδοσ αυτοισ τον μισθον αρξαμενοσ απο των εσχατων εωσ των πρωτων ");
INSERT INTO grcmt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","και ελθοντεσ οι περι την ενδεκατην ωραν ελαβον ανα δηναριον ");
INSERT INTO grcmt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ελθοντεσ δε οι πρωτοι ενομισαν οτι πλειονα ληψονται και ελαβον και αυτοι ανα δηναριον ");
INSERT INTO grcmt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","λαβοντεσ δε εγογγυζον κατα του οικοδεσποτου ");
INSERT INTO grcmt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","λεγοντεσ οτι ουτοι οι εσχατοι μιαν ωραν εποιησαν και ισουσ ημιν αυτουσ εποιησασ τοισ βαστασασιν το βαροσ τησ ημερασ και τον καυσωνα ");
INSERT INTO grcmt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ο δε αποκριθεισ ειπεν ενι αυτων εταιρε ουκ αδικω σε ουχι δηναριου συνεφωνησασ μοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","αρον το σον και υπαγε θελω δε τουτω τω εσχατω δουναι ωσ και σοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","η ουκ εξεστιν μοι ποιησαι ο θελω εν τοισ εμοισ ει ο οφθαλμοσ σου πονηροσ εστιν οτι εγω αγαθοσ ειμι ");
INSERT INTO grcmt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ουτωσ εσονται οι εσχατοι πρωτοι και οι πρωτοι εσχατοι πολλοι γαρ εισιν κλητοι ολιγοι δε εκλεκτοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","και αναβαινων ο ιησουσ εισ ιεροσολυμα παρελαβεν τουσ δωδεκα μαθητασ κατ ιδιαν εν τη οδω και ειπεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ιδου αναβαινομεν εισ ιεροσολυμα και ο υιοσ του ανθρωπου παραδοθησεται τοισ αρχιερευσιν και γραμματευσιν και κατακρινουσιν αυτον θανατω ");
INSERT INTO grcmt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","και παραδωσουσιν αυτον τοισ εθνεσιν εισ το εμπαιξαι και μαστιγωσαι και σταυρωσαι και τη τριτη ημερα αναστησεται ");
INSERT INTO grcmt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","τοτε προσηλθεν αυτω η μητηρ των υιων ζεβεδαιου μετα των υιων αυτησ προσκυνουσα και αιτουσα τι παρ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ο δε ειπεν αυτη τι θελεισ λεγει αυτω ειπε ινα καθισωσιν ουτοι οι δυο υιοι μου εισ εκ δεξιων σου και εισ εξ ευωνυμων σου εν τη βασιλεια σου ");
INSERT INTO grcmt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","αποκριθεισ δε ο ιησουσ ειπεν ουκ οιδατε τι αιτεισθε δυνασθε πιειν το ποτηριον ο εγω μελλω πινειν η το βαπτισμα ο εγω βαπτιζομαι βαπτισθηναι λεγουσιν αυτω δυναμεθα ");
INSERT INTO grcmt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","και λεγει αυτοισ το μεν ποτηριον μου πιεσθε και το βαπτισμα ο εγω βαπτιζομαι βαπτισθησεσθε το δε καθισαι εκ δεξιων μου και εξ ευωνυμων μου ουκ εστιν εμον δουναι αλλ οισ ητοιμασται υπο του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","και ακουσαντεσ οι δεκα ηγανακτησαν περι των δυο αδελφων ");
INSERT INTO grcmt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ο δε ιησουσ προσκαλεσαμενοσ αυτουσ ειπεν οιδατε οτι οι αρχοντεσ των εθνων κατακυριευουσιν αυτων και οι μεγαλοι κατεξουσιαζουσιν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ουχ ουτωσ δε εσται εν υμιν αλλ οσ εαν θελη εν υμιν μεγασ γενεσθαι εσται υμων διακονοσ ");
INSERT INTO grcmt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","και οσ εαν θελη εν υμιν ειναι πρωτοσ εστω υμων δουλοσ ");
INSERT INTO grcmt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ωσπερ ο υιοσ του ανθρωπου ουκ ηλθεν διακονηθηναι αλλα διακονησαι και δουναι την ψυχην αυτου λυτρον αντι πολλων ");
INSERT INTO grcmt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","και εκπορευομενων αυτων απο ιεριχω ηκολουθησεν αυτω οχλοσ πολυσ ");
INSERT INTO grcmt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","και ιδου δυο τυφλοι καθημενοι παρα την οδον ακουσαντεσ οτι ιησουσ παραγει εκραξαν λεγοντεσ ελεησον ημασ κυριε υιοσ δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ο δε οχλοσ επετιμησεν αυτοισ ινα σιωπησωσιν οι δε μειζον εκραζον λεγοντεσ ελεησον ημασ κυριε υιοσ δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","και στασ ο ιησουσ εφωνησεν αυτουσ και ειπεν τι θελετε ποιησω υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","λεγουσιν αυτω κυριε ινα ανοιχθωσιν ημων οι οφθαλμοι ");
INSERT INTO grcmt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","σπλαγχνισθεισ δε ο ιησουσ ηψατο των οφθαλμων αυτων και ευθεωσ ανεβλεψαν αυτων οι οφθαλμοι και ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","και οτε ηγγισαν εισ ιεροσολυμα και ηλθον εισ βηθσφαγη προσ το οροσ των ελαιων τοτε ο ιησουσ απεστειλεν δυο μαθητασ ");
INSERT INTO grcmt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","λεγων αυτοισ πορευθητε εισ την κωμην την απεναντι υμων και ευθεωσ ευρησετε ονον δεδεμενην και πωλον μετ αυτησ λυσαντεσ αγαγετε μοι ");
INSERT INTO grcmt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","και εαν τισ υμιν ειπη τι ερειτε οτι ο κυριοσ αυτων χρειαν εχει ευθεωσ δε αποστελλει αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","τουτο δε ολον γεγονεν ινα πληρωθη το ρηθεν δια του προφητου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ειπατε τη θυγατρι σιων ιδου ο βασιλευσ σου ερχεται σοι πραυσ και επιβεβηκωσ επι ονον και πωλον υιον υποζυγιου ");
INSERT INTO grcmt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","πορευθεντεσ δε οι μαθηται και ποιησαντεσ καθωσ προσεταξεν αυτοισ ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ηγαγον την ονον και τον πωλον και επεθηκαν επανω αυτων τα ιματια αυτων και επεκαθισεν επανω αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ο δε πλειστοσ οχλοσ εστρωσαν εαυτων τα ιματια εν τη οδω αλλοι δε εκοπτον κλαδουσ απο των δενδρων και εστρωννυον εν τη οδω ");
INSERT INTO grcmt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","οι δε οχλοι οι προαγοντεσ και οι ακολουθουντεσ εκραζον λεγοντεσ ωσαννα τω υιω δαυιδ ευλογημενοσ ο ερχομενοσ εν ονοματι κυριου ωσαννα εν τοισ υψιστοισ ");
INSERT INTO grcmt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","και εισελθοντοσ αυτου εισ ιεροσολυμα εσεισθη πασα η πολισ λεγουσα τισ εστιν ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","οι δε οχλοι ελεγον ουτοσ εστιν ιησουσ ο προφητησ ο απο ναζαρετ τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","και εισηλθεν ο ιησουσ εισ το ιερον του θεου και εξεβαλεν παντασ τουσ πωλουντασ και αγοραζοντασ εν τω ιερω και τασ τραπεζασ των κολλυβιστων κατεστρεψεν και τασ καθεδρασ των πωλουντων τασ περιστερασ ");
INSERT INTO grcmt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","και λεγει αυτοισ γεγραπται ο οικοσ μου οικοσ προσευχησ κληθησεται υμεισ δε αυτον εποιησατε σπηλαιον ληστων ");
INSERT INTO grcmt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","και προσηλθον αυτω χωλοι και τυφλοι εν τω ιερω και εθεραπευσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ιδοντεσ δε οι αρχιερεισ και οι γραμματεισ τα θαυμασια α εποιησεν και τουσ παιδασ κραζοντασ εν τω ιερω και λεγοντασ ωσαννα τω υιω δαυιδ ηγανακτησαν ");
INSERT INTO grcmt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","και ειπον αυτω ακουεισ τι ουτοι λεγουσιν ο δε ιησουσ λεγει αυτοισ ναι ουδεποτε ανεγνωτε οτι εκ στοματοσ νηπιων και θηλαζοντων κατηρτισω αινον ");
INSERT INTO grcmt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","και καταλιπων αυτουσ εξηλθεν εξω τησ πολεωσ εισ βηθανιαν και ηυλισθη εκει ");
INSERT INTO grcmt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","πρωιασ δε επαναγων εισ την πολιν επεινασεν ");
INSERT INTO grcmt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","και ιδων συκην μιαν επι τησ οδου ηλθεν επ αυτην και ουδεν ευρεν εν αυτη ει μη φυλλα μονον και λεγει αυτη μηκετι εκ σου καρποσ γενηται εισ τον αιωνα και εξηρανθη παραχρημα η συκη ");
INSERT INTO grcmt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","και ιδοντεσ οι μαθηται εθαυμασαν λεγοντεσ πωσ παραχρημα εξηρανθη η συκη ");
INSERT INTO grcmt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","αποκριθεισ δε ο ιησουσ ειπεν αυτοισ αμην λεγω υμιν εαν εχητε πιστιν και μη διακριθητε ου μονον το τησ συκησ ποιησετε αλλα καν τω ορει τουτω ειπητε αρθητι και βληθητι εισ την θαλασσαν γενησεται ");
INSERT INTO grcmt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","και παντα οσα εαν αιτησητε εν τη προσευχη πιστευοντεσ ληψεσθε ");
INSERT INTO grcmt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","και ελθοντι αυτω εισ το ιερον προσηλθον αυτω διδασκοντι οι αρχιερεισ και οι πρεσβυτεροι του λαου λεγοντεσ εν ποια εξουσια ταυτα ποιεισ και τισ σοι εδωκεν την εξουσιαν ταυτην ");
INSERT INTO grcmt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","αποκριθεισ δε ο ιησουσ ειπεν αυτοισ ερωτησω υμασ καγω λογον ενα ον εαν ειπητε μοι καγω υμιν ερω εν ποια εξουσια ταυτα ποιω ");
INSERT INTO grcmt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","το βαπτισμα ιωαννου ποθεν ην εξ ουρανου η εξ ανθρωπων οι δε διελογιζοντο παρ εαυτοισ λεγοντεσ εαν ειπωμεν εξ ουρανου ερει ημιν δια τι ουν ουκ επιστευσατε αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","εαν δε ειπωμεν εξ ανθρωπων φοβουμεθα τον οχλον παντεσ γαρ εχουσιν τον ιωαννην ωσ προφητην ");
INSERT INTO grcmt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","και αποκριθεντεσ τω ιησου ειπον ουκ οιδαμεν εφη αυτοισ και αυτοσ ουδε εγω λεγω υμιν εν ποια εξουσια ταυτα ποιω ");
INSERT INTO grcmt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","τι δε υμιν δοκει ανθρωποσ ειχεν τεκνα δυο και προσελθων τω πρωτω ειπεν τεκνον υπαγε σημερον εργαζου εν τω αμπελωνι μου ");
INSERT INTO grcmt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ο δε αποκριθεισ ειπεν ου θελω υστερον δε μεταμεληθεισ απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","και προσελθων τω δευτερω ειπεν ωσαυτωσ ο δε αποκριθεισ ειπεν εγω κυριε και ουκ απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","τισ εκ των δυο εποιησεν το θελημα του πατροσ λεγουσιν αυτω ο πρωτοσ λεγει αυτοισ ο ιησουσ αμην λεγω υμιν οτι οι τελωναι και αι πορναι προαγουσιν υμασ εισ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ηλθεν γαρ προσ υμασ ιωαννησ εν οδω δικαιοσυνησ και ουκ επιστευσατε αυτω οι δε τελωναι και αι πορναι επιστευσαν αυτω υμεισ δε ιδοντεσ ου μετεμεληθητε υστερον του πιστευσαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","αλλην παραβολην ακουσατε ανθρωποσ τισ ην οικοδεσποτησ οστισ εφυτευσεν αμπελωνα και φραγμον αυτω περιεθηκεν και ωρυξεν εν αυτω ληνον και ωκοδομησεν πυργον και εξεδοτο αυτον γεωργοισ και απεδημησεν ");
INSERT INTO grcmt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","οτε δε ηγγισεν ο καιροσ των καρπων απεστειλεν τουσ δουλουσ αυτου προσ τουσ γεωργουσ λαβειν τουσ καρπουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","και λαβοντεσ οι γεωργοι τουσ δουλουσ αυτου ον μεν εδειραν ον δε απεκτειναν ον δε ελιθοβολησαν ");
INSERT INTO grcmt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","παλιν απεστειλεν αλλουσ δουλουσ πλειονασ των πρωτων και εποιησαν αυτοισ ωσαυτωσ ");
INSERT INTO grcmt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","υστερον δε απεστειλεν προσ αυτουσ τον υιον αυτου λεγων εντραπησονται τον υιον μου ");
INSERT INTO grcmt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","οι δε γεωργοι ιδοντεσ τον υιον ειπον εν εαυτοισ ουτοσ εστιν ο κληρονομοσ δευτε αποκτεινωμεν αυτον και κατασχωμεν την κληρονομιαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","και λαβοντεσ αυτον εξεβαλον εξω του αμπελωνοσ και απεκτειναν ");
INSERT INTO grcmt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","οταν ουν ελθη ο κυριοσ του αμπελωνοσ τι ποιησει τοισ γεωργοισ εκεινοισ ");
INSERT INTO grcmt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","λεγουσιν αυτω κακουσ κακωσ απολεσει αυτουσ και τον αμπελωνα εκδωσεται αλλοισ γεωργοισ οιτινεσ αποδωσουσιν αυτω τουσ καρπουσ εν τοισ καιροισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","λεγει αυτοισ ο ιησουσ ουδεποτε ανεγνωτε εν ταισ γραφαισ λιθον ον απεδοκιμασαν οι οικοδομουντεσ ουτοσ εγενηθη εισ κεφαλην γωνιασ παρα κυριου εγενετο αυτη και εστιν θαυμαστη εν οφθαλμοισ ημων ");
INSERT INTO grcmt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","δια τουτο λεγω υμιν οτι αρθησεται αφ υμων η βασιλεια του θεου και δοθησεται εθνει ποιουντι τουσ καρπουσ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","και ο πεσων επι τον λιθον τουτον συνθλασθησεται εφ ον δ αν πεση λικμησει αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","και ακουσαντεσ οι αρχιερεισ και οι φαρισαιοι τασ παραβολασ αυτου εγνωσαν οτι περι αυτων λεγει ");
INSERT INTO grcmt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","και ζητουντεσ αυτον κρατησαι εφοβηθησαν τουσ οχλουσ επειδη ωσ προφητην αυτον ειχον ");
INSERT INTO grcmt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","και αποκριθεισ ο ιησουσ παλιν ειπεν αυτοισ εν παραβολαισ λεγων ");
INSERT INTO grcmt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ωμοιωθη η βασιλεια των ουρανων ανθρωπω βασιλει οστισ εποιησεν γαμουσ τω υιω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","και απεστειλεν τουσ δουλουσ αυτου καλεσαι τουσ κεκλημενουσ εισ τουσ γαμουσ και ουκ ηθελον ελθειν ");
INSERT INTO grcmt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","παλιν απεστειλεν αλλουσ δουλουσ λεγων ειπατε τοισ κεκλημενοισ ιδου το αριστον μου ητοιμασα οι ταυροι μου και τα σιτιστα τεθυμενα και παντα ετοιμα δευτε εισ τουσ γαμουσ ");
INSERT INTO grcmt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","οι δε αμελησαντεσ απηλθον ο μεν εισ τον ιδιον αγρον ο δε εισ την εμποριαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","οι δε λοιποι κρατησαντεσ τουσ δουλουσ αυτου υβρισαν και απεκτειναν ");
INSERT INTO grcmt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","και ακουσασ ο βασιλευσ εκεινοσ ωργισθη και πεμψασ τα στρατευματα αυτου απωλεσεν τουσ φονεισ εκεινουσ και την πολιν αυτων ενεπρησεν ");
INSERT INTO grcmt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","τοτε λεγει τοισ δουλοισ αυτου ο μεν γαμοσ ετοιμοσ εστιν οι δε κεκλημενοι ουκ ησαν αξιοι ");
INSERT INTO grcmt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","πορευεσθε ουν επι τασ διεξοδουσ των οδων και οσουσ αν ευρητε καλεσατε εισ τουσ γαμουσ ");
INSERT INTO grcmt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","και εξελθοντεσ οι δουλοι εκεινοι εισ τασ οδουσ συνηγαγον παντασ οσουσ ευρον πονηρουσ τε και αγαθουσ και επλησθη ο γαμοσ ανακειμενων ");
INSERT INTO grcmt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","εισελθων δε ο βασιλευσ θεασασθαι τουσ ανακειμενουσ ειδεν εκει ανθρωπον ουκ ενδεδυμενον ενδυμα γαμου ");
INSERT INTO grcmt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","και λεγει αυτω εταιρε πωσ εισηλθεσ ωδε μη εχων ενδυμα γαμου ο δε εφιμωθη ");
INSERT INTO grcmt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","τοτε ειπεν ο βασιλευσ τοισ διακονοισ δησαντεσ αυτου ποδασ και χειρασ αρατε αυτον και εκβαλετε εισ το σκοτοσ το εξωτερον εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","πολλοι γαρ εισιν κλητοι ολιγοι δε εκλεκτοι ");
INSERT INTO grcmt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","τοτε πορευθεντεσ οι φαρισαιοι συμβουλιον ελαβον οπωσ αυτον παγιδευσωσιν εν λογω ");
INSERT INTO grcmt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","και αποστελλουσιν αυτω τουσ μαθητασ αυτων μετα των ηρωδιανων λεγοντεσ διδασκαλε οιδαμεν οτι αληθησ ει και την οδον του θεου εν αληθεια διδασκεισ και ου μελει σοι περι ουδενοσ ου γαρ βλεπεισ εισ προσωπον ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ειπε ουν ημιν τι σοι δοκει εξεστιν δουναι κηνσον καισαρι η ου ");
INSERT INTO grcmt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","γνουσ δε ο ιησουσ την πονηριαν αυτων ειπεν τι με πειραζετε υποκριται ");
INSERT INTO grcmt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","επιδειξατε μοι το νομισμα του κηνσου οι δε προσηνεγκαν αυτω δηναριον ");
INSERT INTO grcmt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","και λεγει αυτοισ τινοσ η εικων αυτη και η επιγραφη ");
INSERT INTO grcmt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","λεγουσιν αυτω καισαροσ τοτε λεγει αυτοισ αποδοτε ουν τα καισαροσ καισαρι και τα του θεου τω θεω ");
INSERT INTO grcmt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","και ακουσαντεσ εθαυμασαν και αφεντεσ αυτον απηλθον ");
INSERT INTO grcmt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","εν εκεινη τη ημερα προσηλθον αυτω σαδδουκαιοι οι λεγοντεσ μη ειναι αναστασιν και επηρωτησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","λεγοντεσ διδασκαλε μωσησ ειπεν εαν τισ αποθανη μη εχων τεκνα επιγαμβρευσει ο αδελφοσ αυτου την γυναικα αυτου και αναστησει σπερμα τω αδελφω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ησαν δε παρ ημιν επτα αδελφοι και ο πρωτοσ γαμησασ ετελευτησεν και μη εχων σπερμα αφηκεν την γυναικα αυτου τω αδελφω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ομοιωσ και ο δευτεροσ και ο τριτοσ εωσ των επτα ");
INSERT INTO grcmt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","υστερον δε παντων απεθανεν και η γυνη ");
INSERT INTO grcmt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","εν τη ουν αναστασει τινοσ των επτα εσται γυνη παντεσ γαρ εσχον αυτην ");
INSERT INTO grcmt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","αποκριθεισ δε ο ιησουσ ειπεν αυτοισ πλανασθε μη ειδοτεσ τασ γραφασ μηδε την δυναμιν του θεου ");
INSERT INTO grcmt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","εν γαρ τη αναστασει ουτε γαμουσιν ουτε εκγαμιζονται αλλ ωσ αγγελοι του θεου εν ουρανω εισιν ");
INSERT INTO grcmt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","περι δε τησ αναστασεωσ των νεκρων ουκ ανεγνωτε το ρηθεν υμιν υπο του θεου λεγοντοσ ");
INSERT INTO grcmt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","εγω ειμι ο θεοσ αβρααμ και ο θεοσ ισαακ και ο θεοσ ιακωβ ουκ εστιν ο θεοσ θεοσ νεκρων αλλα ζωντων ");
INSERT INTO grcmt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","και ακουσαντεσ οι οχλοι εξεπλησσοντο επι τη διδαχη αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","οι δε φαρισαιοι ακουσαντεσ οτι εφιμωσεν τουσ σαδδουκαιουσ συνηχθησαν επι το αυτο ");
INSERT INTO grcmt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","και επηρωτησεν εισ εξ αυτων νομικοσ πειραζων αυτον και λεγων ");
INSERT INTO grcmt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","διδασκαλε ποια εντολη μεγαλη εν τω νομω ");
INSERT INTO grcmt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ο δε ιησουσ εφη αυτω αγαπησεισ κυριον τον θεον σου εν ολη καρδια σου και εν ολη ψυχη σου και εν ολη τη διανοια σου ");
INSERT INTO grcmt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","αυτη εστιν πρωτη και μεγαλη εντολη ");
INSERT INTO grcmt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","δευτερα δε ομοια αυτη αγαπησεισ τον πλησιον σου ωσ σεαυτον ");
INSERT INTO grcmt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","εν ταυταισ ταισ δυσιν εντολαισ ολοσ ο νομοσ και οι προφηται κρεμανται ");
INSERT INTO grcmt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","συνηγμενων δε των φαρισαιων επηρωτησεν αυτουσ ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","λεγων τι υμιν δοκει περι του χριστου τινοσ υιοσ εστιν λεγουσιν αυτω του δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","λεγει αυτοισ πωσ ουν δαυιδ εν πνευματι κυριον αυτον καλει λεγων ");
INSERT INTO grcmt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ειπεν ο κυριοσ τω κυριω μου καθου εκ δεξιων μου εωσ αν θω τουσ εχθρουσ σου υποποδιον των ποδων σου ");
INSERT INTO grcmt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ει ουν δαυιδ καλει αυτον κυριον πωσ υιοσ αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","και ουδεισ εδυνατο αυτω αποκριθηναι λογον ουδε ετολμησεν τισ απ εκεινησ τησ ημερασ επερωτησαι αυτον ουκετι ");
INSERT INTO grcmt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","τοτε ο ιησουσ ελαλησεν τοισ οχλοισ και τοισ μαθηταισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","λεγων επι τησ μωσεωσ καθεδρασ εκαθισαν οι γραμματεισ και οι φαρισαιοι ");
INSERT INTO grcmt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","παντα ουν οσα εαν ειπωσιν υμιν τηρειν τηρειτε και ποιειτε κατα δε τα εργα αυτων μη ποιειτε λεγουσιν γαρ και ου ποιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","δεσμευουσιν γαρ φορτια βαρεα και δυσβαστακτα και επιτιθεασιν επι τουσ ωμουσ των ανθρωπων τω δε δακτυλω αυτων ου θελουσιν κινησαι αυτα ");
INSERT INTO grcmt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","παντα δε τα εργα αυτων ποιουσιν προσ το θεαθηναι τοισ ανθρωποισ πλατυνουσιν δε τα φυλακτηρια αυτων και μεγαλυνουσιν τα κρασπεδα των ιματιων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","φιλουσιν τε την πρωτοκλισιαν εν τοισ δειπνοισ και τασ πρωτοκαθεδριασ εν ταισ συναγωγαισ ");
INSERT INTO grcmt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","και τουσ ασπασμουσ εν ταισ αγοραισ και καλεισθαι υπο των ανθρωπων ραββι ραββι ");
INSERT INTO grcmt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","υμεισ δε μη κληθητε ραββι εισ γαρ εστιν υμων ο καθηγητησ ο χριστοσ παντεσ δε υμεισ αδελφοι εστε ");
INSERT INTO grcmt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","και πατερα μη καλεσητε υμων επι τησ γησ εισ γαρ εστιν ο πατηρ υμων ο εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","μηδε κληθητε καθηγηται εισ γαρ υμων εστιν ο καθηγητησ ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ο δε μειζων υμων εσται υμων διακονοσ ");
INSERT INTO grcmt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","οστισ δε υψωσει εαυτον ταπεινωθησεται και οστισ ταπεινωσει εαυτον υψωθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ουαι δε υμιν γραμματεισ και φαρισαιοι υποκριται οτι κατεσθιετε τασ οικιασ των χηρων και προφασει μακρα προσευχομενοι δια τουτο ληψεσθε περισσοτερον κριμα ");
INSERT INTO grcmt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι κλειετε την βασιλειαν των ουρανων εμπροσθεν των ανθρωπων υμεισ γαρ ουκ εισερχεσθε ουδε τουσ εισερχομενουσ αφιετε εισελθειν ");
INSERT INTO grcmt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι περιαγετε την θαλασσαν και την ξηραν ποιησαι ενα προσηλυτον και οταν γενηται ποιειτε αυτον υιον γεεννησ διπλοτερον υμων ");
INSERT INTO grcmt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ουαι υμιν οδηγοι τυφλοι οι λεγοντεσ οσ αν ομοση εν τω ναω ουδεν εστιν οσ δ αν ομοση εν τω χρυσω του ναου οφειλει ");
INSERT INTO grcmt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","μωροι και τυφλοι τισ γαρ μειζων εστιν ο χρυσοσ η ο ναοσ ο αγιαζων τον χρυσον ");
INSERT INTO grcmt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","και οσ εαν ομοση εν τω θυσιαστηριω ουδεν εστιν οσ δ αν ομοση εν τω δωρω τω επανω αυτου οφειλει ");
INSERT INTO grcmt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","μωροι και τυφλοι τι γαρ μειζον το δωρον η το θυσιαστηριον το αγιαζον το δωρον ");
INSERT INTO grcmt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ο ουν ομοσασ εν τω θυσιαστηριω ομνυει εν αυτω και εν πασιν τοισ επανω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","και ο ομοσασ εν τω ναω ομνυει εν αυτω και εν τω κατοικησαντι αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","και ο ομοσασ εν τω ουρανω ομνυει εν τω θρονω του θεου και εν τω καθημενω επανω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι αποδεκατουτε το ηδυοσμον και το ανηθον και το κυμινον και αφηκατε τα βαρυτερα του νομου την κρισιν και τον ελεον και την πιστιν ταυτα εδει ποιησαι κακεινα μη αφιεναι ");
INSERT INTO grcmt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","οδηγοι τυφλοι οι διυλιζοντεσ τον κωνωπα την δε καμηλον καταπινοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι καθαριζετε το εξωθεν του ποτηριου και τησ παροψιδοσ εσωθεν δε γεμουσιν εξ αρπαγησ και αδικιασ ");
INSERT INTO grcmt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","φαρισαιε τυφλε καθαρισον πρωτον το εντοσ του ποτηριου και τησ παροψιδοσ ινα γενηται και το εκτοσ αυτων καθαρον ");
INSERT INTO grcmt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι παρομοιαζετε ταφοισ κεκονιαμενοισ οιτινεσ εξωθεν μεν φαινονται ωραιοι εσωθεν δε γεμουσιν οστεων νεκρων και πασησ ακαθαρσιασ ");
INSERT INTO grcmt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ουτωσ και υμεισ εξωθεν μεν φαινεσθε τοισ ανθρωποισ δικαιοι εσωθεν δε μεστοι εστε υποκρισεωσ και ανομιασ ");
INSERT INTO grcmt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι οικοδομειτε τουσ ταφουσ των προφητων και κοσμειτε τα μνημεια των δικαιων ");
INSERT INTO grcmt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","και λεγετε ει ημεν εν ταισ ημεραισ των πατερων ημων ουκ αν ημεν κοινωνοι αυτων εν τω αιματι των προφητων ");
INSERT INTO grcmt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ωστε μαρτυρειτε εαυτοισ οτι υιοι εστε των φονευσαντων τουσ προφητασ ");
INSERT INTO grcmt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","και υμεισ πληρωσατε το μετρον των πατερων υμων ");
INSERT INTO grcmt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","οφεισ γεννηματα εχιδνων πωσ φυγητε απο τησ κρισεωσ τησ γεεννησ ");
INSERT INTO grcmt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","δια τουτο ιδου εγω αποστελλω προσ υμασ προφητασ και σοφουσ και γραμματεισ και εξ αυτων αποκτενειτε και σταυρωσετε και εξ αυτων μαστιγωσετε εν ταισ συναγωγαισ υμων και διωξετε απο πολεωσ εισ πολιν ");
INSERT INTO grcmt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","οπωσ ελθη εφ υμασ παν αιμα δικαιον εκχυνομενον επι τησ γησ απο του αιματοσ αβελ του δικαιου εωσ του αιματοσ ζαχαριου υιου βαραχιου ον εφονευσατε μεταξυ του ναου και του θυσιαστηριου ");
INSERT INTO grcmt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","αμην λεγω υμιν οτι ηξει παντα ταυτα επι την γενεαν ταυτην ");
INSERT INTO grcmt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ιερουσαλημ ιερουσαλημ η αποκτενουσα τουσ προφητασ και λιθοβολουσα τουσ απεσταλμενουσ προσ αυτην ποσακισ ηθελησα επισυναγαγειν τα τεκνα σου ον τροπον επισυναγει ορνισ τα νοσσια εαυτησ υπο τασ πτερυγασ και ουκ ηθελησατε ");
INSERT INTO grcmt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ιδου αφιεται υμιν ο οικοσ υμων ερημοσ ");
INSERT INTO grcmt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","λεγω γαρ υμιν ου μη με ιδητε απ αρτι εωσ αν ειπητε ευλογημενοσ ο ερχομενοσ εν ονοματι κυριου ");
INSERT INTO grcmt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","και εξελθων ο ιησουσ επορευετο απο του ιερου και προσηλθον οι μαθηται αυτου επιδειξαι αυτω τασ οικοδομασ του ιερου ");
INSERT INTO grcmt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ο δε ιησουσ ειπεν αυτοισ ου βλεπετε παντα ταυτα αμην λεγω υμιν ου μη αφεθη ωδε λιθοσ επι λιθον οσ ου καταλυθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","καθημενου δε αυτου επι του ορουσ των ελαιων προσηλθον αυτω οι μαθηται κατ ιδιαν λεγοντεσ ειπε ημιν ποτε ταυτα εσται και τι το σημειον τησ σησ παρουσιασ και τησ συντελειασ του αιωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","και αποκριθεισ ο ιησουσ ειπεν αυτοισ βλεπετε μη τισ υμασ πλανηση ");
INSERT INTO grcmt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","πολλοι γαρ ελευσονται επι τω ονοματι μου λεγοντεσ εγω ειμι ο χριστοσ και πολλουσ πλανησουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","μελλησετε δε ακουειν πολεμουσ και ακοασ πολεμων ορατε μη θροεισθε δει γαρ παντα γενεσθαι αλλ ουπω εστιν το τελοσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","εγερθησεται γαρ εθνοσ επι εθνοσ και βασιλεια επι βασιλειαν και εσονται λιμοι και λοιμοι και σεισμοι κατα τοπουσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","παντα δε ταυτα αρχη ωδινων ");
INSERT INTO grcmt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","τοτε παραδωσουσιν υμασ εισ θλιψιν και αποκτενουσιν υμασ και εσεσθε μισουμενοι υπο παντων των εθνων δια το ονομα μου ");
INSERT INTO grcmt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","και τοτε σκανδαλισθησονται πολλοι και αλληλουσ παραδωσουσιν και μισησουσιν αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","και πολλοι ψευδοπροφηται εγερθησονται και πλανησουσιν πολλουσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","και δια το πληθυνθηναι την ανομιαν ψυγησεται η αγαπη των πολλων ");
INSERT INTO grcmt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ο δε υπομεινασ εισ τελοσ ουτοσ σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","και κηρυχθησεται τουτο το ευαγγελιον τησ βασιλειασ εν ολη τη οικουμενη εισ μαρτυριον πασιν τοισ εθνεσιν και τοτε ηξει το τελοσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","οταν ουν ιδητε το βδελυγμα τησ ερημωσεωσ το ρηθεν δια δανιηλ του προφητου εστωσ εν τοπω αγιω ο αναγινωσκων νοειτω ");
INSERT INTO grcmt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","τοτε οι εν τη ιουδαια φευγετωσαν επι τα ορη ");
INSERT INTO grcmt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ο επι του δωματοσ μη καταβαινετω αραι τα εκ τησ οικιασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","και ο εν τω αγρω μη επιστρεψατω οπισω αραι τα ιματια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ουαι δε ταισ εν γαστρι εχουσαισ και ταισ θηλαζουσαισ εν εκειναισ ταισ ημεραισ ");
INSERT INTO grcmt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","προσευχεσθε δε ινα μη γενηται η φυγη υμων χειμωνοσ μηδε σαββατω ");
INSERT INTO grcmt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","εσται γαρ τοτε θλιψισ μεγαλη οια ου γεγονεν απ αρχησ κοσμου εωσ του νυν ουδ ου μη γενηται ");
INSERT INTO grcmt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","και ει μη εκολοβωθησαν αι ημεραι εκειναι ουκ αν εσωθη πασα σαρξ δια δε τουσ εκλεκτουσ κολοβωθησονται αι ημεραι εκειναι ");
INSERT INTO grcmt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","τοτε εαν τισ υμιν ειπη ιδου ωδε ο χριστοσ η ωδε μη πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","εγερθησονται γαρ ψευδοχριστοι και ψευδοπροφηται και δωσουσιν σημεια μεγαλα και τερατα ωστε πλανησαι ει δυνατον και τουσ εκλεκτουσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ιδου προειρηκα υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","εαν ουν ειπωσιν υμιν ιδου εν τη ερημω εστιν μη εξελθητε ιδου εν τοισ ταμειοισ μη πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ωσπερ γαρ η αστραπη εξερχεται απο ανατολων και φαινεται εωσ δυσμων ουτωσ εσται και η παρουσια του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","οπου γαρ εαν η το πτωμα εκει συναχθησονται οι αετοι ");
INSERT INTO grcmt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ευθεωσ δε μετα την θλιψιν των ημερων εκεινων ο ηλιοσ σκοτισθησεται και η σεληνη ου δωσει το φεγγοσ αυτησ και οι αστερεσ πεσουνται απο του ουρανου και αι δυναμεισ των ουρανων σαλευθησονται ");
INSERT INTO grcmt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","και τοτε φανησεται το σημειον του υιου του ανθρωπου εν τω ουρανω και τοτε κοψονται πασαι αι φυλαι τησ γησ και οψονται τον υιον του ανθρωπου ερχομενον επι των νεφελων του ουρανου μετα δυναμεωσ και δοξησ πολλησ ");
INSERT INTO grcmt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","και αποστελει τουσ αγγελουσ αυτου μετα σαλπιγγοσ φωνησ μεγαλησ και επισυναξουσιν τουσ εκλεκτουσ αυτου εκ των τεσσαρων ανεμων απ ακρων ουρανων εωσ ακρων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","απο δε τησ συκησ μαθετε την παραβολην οταν ηδη ο κλαδοσ αυτησ γενηται απαλοσ και τα φυλλα εκφυη γινωσκετε οτι εγγυσ το θεροσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ουτωσ και υμεισ οταν ιδητε ταυτα παντα γινωσκετε οτι εγγυσ εστιν επι θυραισ ");
INSERT INTO grcmt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","αμην λεγω υμιν ου μη παρελθη η γενεα αυτη εωσ αν παντα ταυτα γενηται ");
INSERT INTO grcmt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ο ουρανοσ και η γη παρελευσονται οι δε λογοι μου ου μη παρελθωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","περι δε τησ ημερασ εκεινησ και ωρασ ουδεισ οιδεν ουδε οι αγγελοι των ουρανων ει μη ο πατηρ μου μονοσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ωσπερ δε αι ημεραι του νωε ουτωσ εσται και η παρουσια του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ωσπερ γαρ ησαν εν ταισ ημεραισ ταισ προ του κατακλυσμου τρωγοντεσ και πινοντεσ γαμουντεσ και εκγαμιζοντεσ αχρι ησ ημερασ εισηλθεν νωε εισ την κιβωτον ");
INSERT INTO grcmt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","και ουκ εγνωσαν εωσ ηλθεν ο κατακλυσμοσ και ηρεν απαντασ ουτωσ εσται και η παρουσια του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","τοτε δυο εσονται εν τω αγρω ο εισ παραλαμβανεται και ο εισ αφιεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","δυο αληθουσαι εν τω μυλωνι μια παραλαμβανεται και μια αφιεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","γρηγορειτε ουν οτι ουκ οιδατε ποια ωρα ο κυριοσ υμων ερχεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","εκεινο δε γινωσκετε οτι ει ηδει ο οικοδεσποτησ ποια φυλακη ο κλεπτησ ερχεται εγρηγορησεν αν και ουκ αν ειασεν διορυγηναι την οικιαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","δια τουτο και υμεισ γινεσθε ετοιμοι οτι η ωρα ου δοκειτε ο υιοσ του ανθρωπου ερχεται ");
INSERT INTO grcmt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","τισ αρα εστιν ο πιστοσ δουλοσ και φρονιμοσ ον κατεστησεν ο κυριοσ αυτου επι τησ θεραπειασ αυτου του διδοναι αυτοισ την τροφην εν καιρω ");
INSERT INTO grcmt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","μακαριοσ ο δουλοσ εκεινοσ ον ελθων ο κυριοσ αυτου ευρησει ποιουντα ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","αμην λεγω υμιν οτι επι πασιν τοισ υπαρχουσιν αυτου καταστησει αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","εαν δε ειπη ο κακοσ δουλοσ εκεινοσ εν τη καρδια αυτου χρονιζει ο κυριοσ μου ελθειν ");
INSERT INTO grcmt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","και αρξηται τυπτειν τουσ συνδουλουσ εσθιειν δε και πινειν μετα των μεθυοντων ");
INSERT INTO grcmt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ηξει ο κυριοσ του δουλου εκεινου εν ημερα η ου προσδοκα και εν ωρα η ου γινωσκει ");
INSERT INTO grcmt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","και διχοτομησει αυτον και το μεροσ αυτου μετα των υποκριτων θησει εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","τοτε ομοιωθησεται η βασιλεια των ουρανων δεκα παρθενοισ αιτινεσ λαβουσαι τασ λαμπαδασ αυτων εξηλθον εισ απαντησιν του νυμφιου ");
INSERT INTO grcmt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","πεντε δε ησαν εξ αυτων φρονιμοι και αι πεντε μωραι ");
INSERT INTO grcmt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","αιτινεσ μωραι λαβουσαι τασ λαμπαδασ αυτων ουκ ελαβον μεθ εαυτων ελαιον ");
INSERT INTO grcmt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","αι δε φρονιμοι ελαβον ελαιον εν τοισ αγγειοισ αυτων μετα των λαμπαδων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","χρονιζοντοσ δε του νυμφιου ενυσταξαν πασαι και εκαθευδον ");
INSERT INTO grcmt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","μεσησ δε νυκτοσ κραυγη γεγονεν ιδου ο νυμφιοσ ερχεται εξερχεσθε εισ απαντησιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","τοτε ηγερθησαν πασαι αι παρθενοι εκειναι και εκοσμησαν τασ λαμπαδασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","αι δε μωραι ταισ φρονιμοισ ειπον δοτε ημιν εκ του ελαιου υμων οτι αι λαμπαδεσ ημων σβεννυνται ");
INSERT INTO grcmt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","απεκριθησαν δε αι φρονιμοι λεγουσαι μηποτε ουκ αρκεση ημιν και υμιν πορευεσθε δε μαλλον προσ τουσ πωλουντασ και αγορασατε εαυταισ ");
INSERT INTO grcmt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","απερχομενων δε αυτων αγορασαι ηλθεν ο νυμφιοσ και αι ετοιμοι εισηλθον μετ αυτου εισ τουσ γαμουσ και εκλεισθη η θυρα ");
INSERT INTO grcmt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","υστερον δε ερχονται και αι λοιπαι παρθενοι λεγουσαι κυριε κυριε ανοιξον ημιν ");
INSERT INTO grcmt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ο δε αποκριθεισ ειπεν αμην λεγω υμιν ουκ οιδα υμασ ");
INSERT INTO grcmt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","γρηγορειτε ουν οτι ουκ οιδατε την ημεραν ουδε την ωραν εν η ο υιοσ του ανθρωπου ερχεται ");
INSERT INTO grcmt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ωσπερ γαρ ανθρωποσ αποδημων εκαλεσεν τουσ ιδιουσ δουλουσ και παρεδωκεν αυτοισ τα υπαρχοντα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","και ω μεν εδωκεν πεντε ταλαντα ω δε δυο ω δε εν εκαστω κατα την ιδιαν δυναμιν και απεδημησεν ευθεωσ ");
INSERT INTO grcmt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","πορευθεισ δε ο τα πεντε ταλαντα λαβων ειργασατο εν αυτοισ και εποιησεν αλλα πεντε ταλαντα ");
INSERT INTO grcmt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ωσαυτωσ και ο τα δυο εκερδησεν και αυτοσ αλλα δυο ");
INSERT INTO grcmt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ο δε το εν λαβων απελθων ωρυξεν εν τη γη και απεκρυψεν το αργυριον του κυριου αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","μετα δε χρονον πολυν ερχεται ο κυριοσ των δουλων εκεινων και συναιρει μετ αυτων λογον ");
INSERT INTO grcmt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","και προσελθων ο τα πεντε ταλαντα λαβων προσηνεγκεν αλλα πεντε ταλαντα λεγων κυριε πεντε ταλαντα μοι παρεδωκασ ιδε αλλα πεντε ταλαντα εκερδησα επ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","εφη δε αυτω ο κυριοσ αυτου ευ δουλε αγαθε και πιστε επι ολιγα ησ πιστοσ επι πολλων σε καταστησω εισελθε εισ την χαραν του κυριου σου ");
INSERT INTO grcmt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","προσελθων δε και ο τα δυο ταλαντα λαβων ειπεν κυριε δυο ταλαντα μοι παρεδωκασ ιδε αλλα δυο ταλαντα εκερδησα επ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","εφη αυτω ο κυριοσ αυτου ευ δουλε αγαθε και πιστε επι ολιγα ησ πιστοσ επι πολλων σε καταστησω εισελθε εισ την χαραν του κυριου σου ");
INSERT INTO grcmt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","προσελθων δε και ο το εν ταλαντον ειληφωσ ειπεν κυριε εγνων σε οτι σκληροσ ει ανθρωποσ θεριζων οπου ουκ εσπειρασ και συναγων οθεν ου διεσκορπισασ ");
INSERT INTO grcmt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","και φοβηθεισ απελθων εκρυψα το ταλαντον σου εν τη γη ιδε εχεισ το σον ");
INSERT INTO grcmt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","αποκριθεισ δε ο κυριοσ αυτου ειπεν αυτω πονηρε δουλε και οκνηρε ηδεισ οτι θεριζω οπου ουκ εσπειρα και συναγω οθεν ου διεσκορπισα ");
INSERT INTO grcmt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","εδει ουν σε βαλειν το αργυριον μου τοισ τραπεζιταισ και ελθων εγω εκομισαμην αν το εμον συν τοκω ");
INSERT INTO grcmt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","αρατε ουν απ αυτου το ταλαντον και δοτε τω εχοντι τα δεκα ταλαντα ");
INSERT INTO grcmt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","τω γαρ εχοντι παντι δοθησεται και περισσευθησεται απο δε του μη εχοντοσ και ο εχει αρθησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","και τον αχρειον δουλον εκβαλετε εισ το σκοτοσ το εξωτερον εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων ");
INSERT INTO grcmt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","οταν δε ελθη ο υιοσ του ανθρωπου εν τη δοξη αυτου και παντεσ οι αγιοι αγγελοι μετ αυτου τοτε καθισει επι θρονου δοξησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","και συναχθησεται εμπροσθεν αυτου παντα τα εθνη και αφοριει αυτουσ απ αλληλων ωσπερ ο ποιμην αφοριζει τα προβατα απο των εριφων ");
INSERT INTO grcmt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","και στησει τα μεν προβατα εκ δεξιων αυτου τα δε εριφια εξ ευωνυμων ");
INSERT INTO grcmt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","τοτε ερει ο βασιλευσ τοισ εκ δεξιων αυτου δευτε οι ευλογημενοι του πατροσ μου κληρονομησατε την ητοιμασμενην υμιν βασιλειαν απο καταβολησ κοσμου ");
INSERT INTO grcmt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","επεινασα γαρ και εδωκατε μοι φαγειν εδιψησα και εποτισατε με ξενοσ ημην και συνηγαγετε με ");
INSERT INTO grcmt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","γυμνοσ και περιεβαλετε με ησθενησα και επεσκεψασθε με εν φυλακη ημην και ηλθετε προσ με ");
INSERT INTO grcmt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","τοτε αποκριθησονται αυτω οι δικαιοι λεγοντεσ κυριε ποτε σε ειδομεν πεινωντα και εθρεψαμεν η διψωντα και εποτισαμεν ");
INSERT INTO grcmt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ποτε δε σε ειδομεν ξενον και συνηγαγομεν η γυμνον και περιεβαλομεν ");
INSERT INTO grcmt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ποτε δε σε ειδομεν ασθενη η εν φυλακη και ηλθομεν προσ σε ");
INSERT INTO grcmt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","και αποκριθεισ ο βασιλευσ ερει αυτοισ αμην λεγω υμιν εφ οσον εποιησατε ενι τουτων των αδελφων μου των ελαχιστων εμοι εποιησατε ");
INSERT INTO grcmt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","τοτε ερει και τοισ εξ ευωνυμων πορευεσθε απ εμου οι κατηραμενοι εισ το πυρ το αιωνιον το ητοιμασμενον τω διαβολω και τοισ αγγελοισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","επεινασα γαρ και ουκ εδωκατε μοι φαγειν εδιψησα και ουκ εποτισατε με ");
INSERT INTO grcmt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ξενοσ ημην και ου συνηγαγετε με γυμνοσ και ου περιεβαλετε με ασθενησ και εν φυλακη και ουκ επεσκεψασθε με ");
INSERT INTO grcmt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","τοτε αποκριθησονται και αυτοι λεγοντεσ κυριε ποτε σε ειδομεν πεινωντα η διψωντα η ξενον η γυμνον η ασθενη η εν φυλακη και ου διηκονησαμεν σοι ");
INSERT INTO grcmt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","τοτε αποκριθησεται αυτοισ λεγων αμην λεγω υμιν εφ οσον ουκ εποιησατε ενι τουτων των ελαχιστων ουδε εμοι εποιησατε ");
INSERT INTO grcmt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","και απελευσονται ουτοι εισ κολασιν αιωνιον οι δε δικαιοι εισ ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","και εγενετο οτε ετελεσεν ο ιησουσ παντασ τουσ λογουσ τουτουσ ειπεν τοισ μαθηταισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","οιδατε οτι μετα δυο ημερασ το πασχα γινεται και ο υιοσ του ανθρωπου παραδιδοται εισ το σταυρωθηναι ");
INSERT INTO grcmt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","τοτε συνηχθησαν οι αρχιερεισ και οι γραμματεισ και οι πρεσβυτεροι του λαου εισ την αυλην του αρχιερεωσ του λεγομενου καιαφα ");
INSERT INTO grcmt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","και συνεβουλευσαντο ινα τον ιησουν δολω κρατησωσιν και αποκτεινωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ελεγον δε μη εν τη εορτη ινα μη θορυβοσ γενηται εν τω λαω ");
INSERT INTO grcmt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","του δε ιησου γενομενου εν βηθανια εν οικια σιμωνοσ του λεπρου ");
INSERT INTO grcmt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","προσηλθεν αυτω γυνη αλαβαστρον μυρου εχουσα βαρυτιμου και κατεχεεν επι την κεφαλην αυτου ανακειμενου ");
INSERT INTO grcmt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ιδοντεσ δε οι μαθηται αυτου ηγανακτησαν λεγοντεσ εισ τι η απωλεια αυτη ");
INSERT INTO grcmt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ηδυνατο γαρ τουτο το μυρον πραθηναι πολλου και δοθηναι πτωχοισ ");
INSERT INTO grcmt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","γνουσ δε ο ιησουσ ειπεν αυτοισ τι κοπουσ παρεχετε τη γυναικι εργον γαρ καλον ειργασατο εισ εμε ");
INSERT INTO grcmt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","παντοτε γαρ τουσ πτωχουσ εχετε μεθ εαυτων εμε δε ου παντοτε εχετε ");
INSERT INTO grcmt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","βαλουσα γαρ αυτη το μυρον τουτο επι του σωματοσ μου προσ το ενταφιασαι με εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","αμην λεγω υμιν οπου εαν κηρυχθη το ευαγγελιον τουτο εν ολω τω κοσμω λαληθησεται και ο εποιησεν αυτη εισ μνημοσυνον αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","τοτε πορευθεισ εισ των δωδεκα ο λεγομενοσ ιουδασ ισκαριωτησ προσ τουσ αρχιερεισ ");
INSERT INTO grcmt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ειπεν τι θελετε μοι δουναι καγω υμιν παραδωσω αυτον οι δε εστησαν αυτω τριακοντα αργυρια ");
INSERT INTO grcmt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","και απο τοτε εζητει ευκαιριαν ινα αυτον παραδω ");
INSERT INTO grcmt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","τη δε πρωτη των αζυμων προσηλθον οι μαθηται τω ιησου λεγοντεσ αυτω που θελεισ ετοιμασομεν σοι φαγειν το πασχα ");
INSERT INTO grcmt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ο δε ειπεν υπαγετε εισ την πολιν προσ τον δεινα και ειπατε αυτω ο διδασκαλοσ λεγει ο καιροσ μου εγγυσ εστιν προσ σε ποιω το πασχα μετα των μαθητων μου ");
INSERT INTO grcmt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","και εποιησαν οι μαθηται ωσ συνεταξεν αυτοισ ο ιησουσ και ητοιμασαν το πασχα ");
INSERT INTO grcmt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","οψιασ δε γενομενησ ανεκειτο μετα των δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","και εσθιοντων αυτων ειπεν αμην λεγω υμιν οτι εισ εξ υμων παραδωσει με ");
INSERT INTO grcmt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","και λυπουμενοι σφοδρα ηρξαντο λεγειν αυτω εκαστοσ αυτων μητι εγω ειμι κυριε ");
INSERT INTO grcmt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ο δε αποκριθεισ ειπεν ο εμβαψασ μετ εμου εν τω τρυβλιω την χειρα ουτοσ με παραδωσει ");
INSERT INTO grcmt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ο μεν υιοσ του ανθρωπου υπαγει καθωσ γεγραπται περι αυτου ουαι δε τω ανθρωπω εκεινω δι ου ο υιοσ του ανθρωπου παραδιδοται καλον ην αυτω ει ουκ εγεννηθη ο ανθρωποσ εκεινοσ ");
INSERT INTO grcmt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","αποκριθεισ δε ιουδασ ο παραδιδουσ αυτον ειπεν μητι εγω ειμι ραββι λεγει αυτω συ ειπασ ");
INSERT INTO grcmt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","εσθιοντων δε αυτων λαβων ο ιησουσ τον αρτον και ευχαριστησασ εκλασεν και εδιδου τοισ μαθηταισ και ειπεν λαβετε φαγετε τουτο εστιν το σωμα μου ");
INSERT INTO grcmt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","και λαβων το ποτηριον και ευχαριστησασ εδωκεν αυτοισ λεγων πιετε εξ αυτου παντεσ ");
INSERT INTO grcmt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","τουτο γαρ εστιν το αιμα μου το τησ καινησ διαθηκησ το περι πολλων εκχυνομενον εισ αφεσιν αμαρτιων ");
INSERT INTO grcmt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","λεγω δε υμιν οτι ου μη πιω απ αρτι εκ τουτου του γεννηματοσ τησ αμπελου εωσ τησ ημερασ εκεινησ οταν αυτο πινω μεθ υμων καινον εν τη βασιλεια του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","και υμνησαντεσ εξηλθον εισ το οροσ των ελαιων ");
INSERT INTO grcmt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","τοτε λεγει αυτοισ ο ιησουσ παντεσ υμεισ σκανδαλισθησεσθε εν εμοι εν τη νυκτι ταυτη γεγραπται γαρ παταξω τον ποιμενα και διασκορπισθησεται τα προβατα τησ ποιμνησ ");
INSERT INTO grcmt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","μετα δε το εγερθηναι με προαξω υμασ εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","αποκριθεισ δε ο πετροσ ειπεν αυτω ει παντεσ σκανδαλισθησονται εν σοι εγω δε ουδεποτε σκανδαλισθησομαι ");
INSERT INTO grcmt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","εφη αυτω ο ιησουσ αμην λεγω σοι οτι εν ταυτη τη νυκτι πριν αλεκτορα φωνησαι τρισ απαρνηση με ");
INSERT INTO grcmt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","λεγει αυτω ο πετροσ καν δεη με συν σοι αποθανειν ου μη σε απαρνησωμαι ομοιωσ δε και παντεσ οι μαθηται ειπον ");
INSERT INTO grcmt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","τοτε ερχεται μετ αυτων ο ιησουσ εισ χωριον λεγομενον γεθσημανη και λεγει τοισ μαθηταισ καθισατε αυτου εωσ ου απελθων προσευξωμαι εκει ");
INSERT INTO grcmt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","και παραλαβων τον πετρον και τουσ δυο υιουσ ζεβεδαιου ηρξατο λυπεισθαι και αδημονειν ");
INSERT INTO grcmt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","τοτε λεγει αυτοισ ο ιησουσ περιλυποσ εστιν η ψυχη μου εωσ θανατου μεινατε ωδε και γρηγορειτε μετ εμου ");
INSERT INTO grcmt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","και προσελθων μικρον επεσεν επι προσωπον αυτου προσευχομενοσ και λεγων πατερ μου ει δυνατον εστιν παρελθετω απ εμου το ποτηριον τουτο πλην ουχ ωσ εγω θελω αλλ ωσ συ ");
INSERT INTO grcmt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","και ερχεται προσ τουσ μαθητασ και ευρισκει αυτουσ καθευδοντασ και λεγει τω πετρω ουτωσ ουκ ισχυσατε μιαν ωραν γρηγορησαι μετ εμου ");
INSERT INTO grcmt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","γρηγορειτε και προσευχεσθε ινα μη εισελθητε εισ πειρασμον το μεν πνευμα προθυμον η δε σαρξ ασθενησ ");
INSERT INTO grcmt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","παλιν εκ δευτερου απελθων προσηυξατο λεγων πατερ μου ει ου δυναται τουτο το ποτηριον παρελθειν απ εμου εαν μη αυτο πιω γενηθητω το θελημα σου ");
INSERT INTO grcmt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","και ελθων ευρισκει αυτουσ παλιν καθευδοντασ ησαν γαρ αυτων οι οφθαλμοι βεβαρημενοι ");
INSERT INTO grcmt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","και αφεισ αυτουσ απελθων παλιν προσηυξατο εκ τριτου τον αυτον λογον ειπων ");
INSERT INTO grcmt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","τοτε ερχεται προσ τουσ μαθητασ αυτου και λεγει αυτοισ καθευδετε 2518 V-PAI-2P το λοιπον και αναπαυεσθε 373 V-PMI-2P ιδου ηγγικεν η ωρα και ο υιοσ του ανθρωπου παραδιδοται εισ χειρασ αμαρτωλων ");
INSERT INTO grcmt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","εγειρεσθε αγωμεν ιδου ηγγικεν ο παραδιδουσ με ");
INSERT INTO grcmt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","και ετι αυτου λαλουντοσ ιδου ιουδασ εισ των δωδεκα ηλθεν και μετ αυτου οχλοσ πολυσ μετα μαχαιρων και ξυλων απο των αρχιερεων και πρεσβυτερων του λαου ");
INSERT INTO grcmt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ο δε παραδιδουσ αυτον εδωκεν αυτοισ σημειον λεγων ον αν φιλησω αυτοσ εστιν κρατησατε αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","και ευθεωσ προσελθων τω ιησου ειπεν χαιρε ραββι και κατεφιλησεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ο δε ιησουσ ειπεν αυτω εταιρε εφ ω παρει τοτε προσελθοντεσ επεβαλον τασ χειρασ επι τον ιησουν και εκρατησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","και ιδου εισ των μετα ιησου εκτεινασ την χειρα απεσπασεν την μαχαιραν αυτου και παταξασ τον δουλον του αρχιερεωσ αφειλεν αυτου το ωτιον ");
INSERT INTO grcmt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","τοτε λεγει αυτω ο ιησουσ αποστρεψον σου την μαχαιραν εισ τον τοπον αυτησ παντεσ γαρ οι λαβοντεσ μαχαιραν εν μαχαιρα αποθανουνται ");
INSERT INTO grcmt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","η δοκεισ οτι ου δυναμαι αρτι παρακαλεσαι τον πατερα μου και παραστησει μοι πλειουσ η δωδεκα λεγεωνασ αγγελων ");
INSERT INTO grcmt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","πωσ ουν πληρωθωσιν αι γραφαι οτι ουτωσ δει γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","εν εκεινη τη ωρα ειπεν ο ιησουσ τοισ οχλοισ ωσ επι ληστην εξηλθετε μετα μαχαιρων και ξυλων συλλαβειν με καθ ημεραν προσ υμασ εκαθεζομην διδασκων εν τω ιερω και ουκ εκρατησατε με ");
INSERT INTO grcmt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","τουτο δε ολον γεγονεν ινα πληρωθωσιν αι γραφαι των προφητων τοτε οι μαθηται παντεσ αφεντεσ αυτον εφυγον ");
INSERT INTO grcmt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","οι δε κρατησαντεσ τον ιησουν απηγαγον προσ καιαφαν τον αρχιερεα οπου οι γραμματεισ και οι πρεσβυτεροι συνηχθησαν ");
INSERT INTO grcmt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ο δε πετροσ ηκολουθει αυτω απο μακροθεν εωσ τησ αυλησ του αρχιερεωσ και εισελθων εσω εκαθητο μετα των υπηρετων ιδειν το τελοσ ");
INSERT INTO grcmt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","οι δε αρχιερεισ και οι πρεσβυτεροι και το συνεδριον ολον εζητουν ψευδομαρτυριαν κατα του ιησου οπωσ θανατωσωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","και ουχ ευρον και πολλων ψευδομαρτυρων προσελθοντων ουχ ευρον ");
INSERT INTO grcmt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","υστερον δε προσελθοντεσ δυο ψευδομαρτυρεσ ειπον ουτοσ εφη δυναμαι καταλυσαι τον ναον του θεου και δια τριων ημερων οικοδομησαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","και αναστασ ο αρχιερευσ ειπεν αυτω ουδεν αποκρινη τι ουτοι σου καταμαρτυρουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ο δε ιησουσ εσιωπα και αποκριθεισ ο αρχιερευσ ειπεν αυτω εξορκιζω σε κατα του θεου του ζωντοσ ινα ημιν ειπησ ει συ ει ο χριστοσ ο υιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","λεγει αυτω ο ιησουσ συ ειπασ πλην λεγω υμιν απ αρτι οψεσθε τον υιον του ανθρωπου καθημενον εκ δεξιων τησ δυναμεωσ και ερχομενον επι των νεφελων του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","τοτε ο αρχιερευσ διερρηξεν τα ιματια αυτου λεγων οτι εβλασφημησεν τι ετι χρειαν εχομεν μαρτυρων ιδε νυν ηκουσατε την βλασφημιαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","τι υμιν δοκει οι δε αποκριθεντεσ ειπον ενοχοσ θανατου εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","τοτε ενεπτυσαν εισ το προσωπον αυτου και εκολαφισαν αυτον οι δε ερραπισαν ");
INSERT INTO grcmt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","λεγοντεσ προφητευσον ημιν χριστε τισ εστιν ο παισασ σε ");
INSERT INTO grcmt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ο δε πετροσ εξω εκαθητο εν τη αυλη και προσηλθεν αυτω μια παιδισκη λεγουσα και συ ησθα μετα ιησου του γαλιλαιου ");
INSERT INTO grcmt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ο δε ηρνησατο εμπροσθεν αυτων παντων λεγων ουκ οιδα τι λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","εξελθοντα δε αυτον εισ τον πυλωνα ειδεν αυτον αλλη και λεγει αυτοισ εκει και ουτοσ ην μετα ιησου του ναζωραιου ");
INSERT INTO grcmt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","και παλιν ηρνησατο μεθ ορκου οτι ουκ οιδα τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","μετα μικρον δε προσελθοντεσ οι εστωτεσ ειπον τω πετρω αληθωσ και συ εξ αυτων ει και γαρ η λαλια σου δηλον σε ποιει ");
INSERT INTO grcmt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","τοτε ηρξατο καταθεματιζειν και ομνυειν οτι ουκ οιδα τον ανθρωπον και ευθεωσ αλεκτωρ εφωνησεν ");
INSERT INTO grcmt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","και εμνησθη ο πετροσ του ρηματοσ του ιησου ειρηκοτοσ αυτω οτι πριν αλεκτορα φωνησαι τρισ απαρνηση με και εξελθων εξω εκλαυσεν πικρωσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","πρωιασ δε γενομενησ συμβουλιον ελαβον παντεσ οι αρχιερεισ και οι πρεσβυτεροι του λαου κατα του ιησου ωστε θανατωσαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","και δησαντεσ αυτον απηγαγον και παρεδωκαν αυτον ποντιω πιλατω τω ηγεμονι ");
INSERT INTO grcmt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","τοτε ιδων ιουδασ ο παραδιδουσ αυτον οτι κατεκριθη μεταμεληθεισ απεστρεψεν τα τριακοντα αργυρια τοισ αρχιερευσιν και τοισ πρεσβυτεροισ ");
INSERT INTO grcmt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","λεγων ημαρτον παραδουσ αιμα αθωον οι δε ειπον τι προσ ημασ συ οψει ");
INSERT INTO grcmt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","και ριψασ τα αργυρια εν τω ναω ανεχωρησεν και απελθων απηγξατο ");
INSERT INTO grcmt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","οι δε αρχιερεισ λαβοντεσ τα αργυρια ειπον ουκ εξεστιν βαλειν αυτα εισ τον κορβαναν επει τιμη αιματοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","συμβουλιον δε λαβοντεσ ηγορασαν εξ αυτων τον αγρον του κεραμεωσ εισ ταφην τοισ ξενοισ ");
INSERT INTO grcmt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","διο εκληθη ο αγροσ εκεινοσ αγροσ αιματοσ εωσ τησ σημερον ");
INSERT INTO grcmt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","τοτε επληρωθη το ρηθεν δια ιερεμιου του προφητου λεγοντοσ και ελαβον 2983 V-2AAI-3P τα τριακοντα αργυρια την τιμην του τετιμημενου ον ετιμησαντο απο υιων ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","και εδωκαν αυτα εισ τον αγρον του κεραμεωσ καθα συνεταξεν μοι κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ο δε ιησουσ εστη εμπροσθεν του ηγεμονοσ και επηρωτησεν αυτον ο ηγεμων λεγων συ ει ο βασιλευσ των ιουδαιων ο δε ιησουσ εφη αυτω συ λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","και εν τω κατηγορεισθαι αυτον υπο των αρχιερεων και των πρεσβυτερων ουδεν απεκρινατο ");
INSERT INTO grcmt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","τοτε λεγει αυτω ο πιλατοσ ουκ ακουεισ ποσα σου καταμαρτυρουσιν ");
INSERT INTO grcmt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","και ουκ απεκριθη αυτω προσ ουδε εν ρημα ωστε θαυμαζειν τον ηγεμονα λιαν ");
INSERT INTO grcmt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","κατα δε εορτην ειωθει ο ηγεμων απολυειν ενα τω οχλω δεσμιον ον ηθελον ");
INSERT INTO grcmt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ειχον δε τοτε δεσμιον επισημον λεγομενον βαραββαν ");
INSERT INTO grcmt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","συνηγμενων ουν αυτων ειπεν αυτοισ ο πιλατοσ τινα θελετε απολυσω υμιν βαραββαν η ιησουν τον λεγομενον χριστον ");
INSERT INTO grcmt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ηδει γαρ οτι δια φθονον παρεδωκαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","καθημενου δε αυτου επι του βηματοσ απεστειλεν προσ αυτον η γυνη αυτου λεγουσα μηδεν σοι και τω δικαιω εκεινω πολλα γαρ επαθον σημερον κατ οναρ δι αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","οι δε αρχιερεισ και οι πρεσβυτεροι επεισαν τουσ οχλουσ ινα αιτησωνται τον βαραββαν τον δε ιησουν απολεσωσιν ");
INSERT INTO grcmt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","αποκριθεισ δε ο ηγεμων ειπεν αυτοισ τινα θελετε απο των δυο απολυσω υμιν οι δε ειπον βαραββαν ");
INSERT INTO grcmt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","λεγει αυτοισ ο πιλατοσ τι ουν ποιησω ιησουν τον λεγομενον χριστον λεγουσιν αυτω παντεσ σταυρωθητω ");
INSERT INTO grcmt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ο δε ηγεμων εφη τι γαρ κακον εποιησεν οι δε περισσωσ εκραζον λεγοντεσ σταυρωθητω ");
INSERT INTO grcmt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ιδων δε ο πιλατοσ οτι ουδεν ωφελει αλλα μαλλον θορυβοσ γινεται λαβων υδωρ απενιψατο τασ χειρασ απεναντι του οχλου λεγων αθωοσ ειμι απο του αιματοσ του δικαιου τουτου υμεισ οψεσθε ");
INSERT INTO grcmt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","και αποκριθεισ πασ ο λαοσ ειπεν το αιμα αυτου εφ ημασ και επι τα τεκνα ημων ");
INSERT INTO grcmt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","τοτε απελυσεν αυτοισ τον βαραββαν τον δε ιησουν φραγελλωσασ παρεδωκεν ινα σταυρωθη ");
INSERT INTO grcmt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","τοτε οι στρατιωται του ηγεμονοσ παραλαβοντεσ τον ιησουν εισ το πραιτωριον συνηγαγον επ αυτον ολην την σπειραν ");
INSERT INTO grcmt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","και εκδυσαντεσ αυτον περιεθηκαν αυτω χλαμυδα κοκκινην ");
INSERT INTO grcmt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","και πλεξαντεσ στεφανον εξ ακανθων επεθηκαν επι την κεφαλην αυτου και καλαμον επι την δεξιαν αυτου και γονυπετησαντεσ εμπροσθεν αυτου ενεπαιζον αυτω λεγοντεσ χαιρε ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","και εμπτυσαντεσ εισ αυτον ελαβον τον καλαμον και ετυπτον εισ την κεφαλην αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","και οτε ενεπαιξαν αυτω εξεδυσαν αυτον την χλαμυδα και ενεδυσαν αυτον τα ιματια αυτου και απηγαγον αυτον εισ το σταυρωσαι ");
INSERT INTO grcmt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","εξερχομενοι δε ευρον ανθρωπον κυρηναιον ονοματι σιμωνα τουτον ηγγαρευσαν ινα αρη τον σταυρον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","και ελθοντεσ εισ τοπον λεγομενον γολγοθα ο εστιν λεγομενοσ κρανιου τοποσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","εδωκαν αυτω πιειν οξοσ μετα χολησ μεμιγμενον και γευσαμενοσ ουκ ηθελεν πιειν ");
INSERT INTO grcmt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","σταυρωσαντεσ δε αυτον διεμερισαντο τα ιματια αυτου βαλλοντεσ κληρον ");
INSERT INTO grcmt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","και καθημενοι ετηρουν αυτον εκει ");
INSERT INTO grcmt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","και επεθηκαν επανω τησ κεφαλησ αυτου την αιτιαν αυτου γεγραμμενην ουτοσ εστιν ιησουσ ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","τοτε σταυρουνται συν αυτω δυο λησται εισ εκ δεξιων και εισ εξ ευωνυμων ");
INSERT INTO grcmt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","οι δε παραπορευομενοι εβλασφημουν αυτον κινουντεσ τασ κεφαλασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","και λεγοντεσ ο καταλυων τον ναον και εν τρισιν ημεραισ οικοδομων σωσον σεαυτον ει υιοσ ει του θεου καταβηθι απο του σταυρου ");
INSERT INTO grcmt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ομοιωσ δε και οι αρχιερεισ εμπαιζοντεσ μετα των γραμματεων και πρεσβυτερων και φαρισαιων ελεγον ");
INSERT INTO grcmt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","αλλουσ εσωσεν εαυτον ου δυναται σωσαι ει βασιλευσ ισραηλ εστιν καταβατω νυν απο του σταυρου και πιστευσομεν επ αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","πεποιθεν επι τον θεον ρυσασθω νυν αυτον ει θελει αυτον ειπεν γαρ οτι θεου ειμι υιοσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","το δ αυτο και οι λησται οι συσταυρωθεντεσ αυτω ωνειδιζον αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","απο δε εκτησ ωρασ σκοτοσ εγενετο επι πασαν την γην εωσ ωρασ ενατησ ");
INSERT INTO grcmt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","περι δε την ενατην ωραν ανεβοησεν ο ιησουσ φωνη μεγαλη λεγων ηλι ηλι λιμα σαβαχθανι τουτ εστιν θεε μου θεε μου ινα τι με εγκατελιπεσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","τινεσ δε των εκει εστωτων ακουσαντεσ ελεγον οτι ηλιαν φωνει ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","και ευθεωσ δραμων εισ εξ αυτων και λαβων σπογγον πλησασ τε οξουσ και περιθεισ καλαμω εποτιζεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","οι δε λοιποι ελεγον αφεσ ιδωμεν ει ερχεται ηλιασ σωσων αυτον ");
INSERT INTO grcmt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ο δε ιησουσ παλιν κραξασ φωνη μεγαλη αφηκεν το πνευμα ");
INSERT INTO grcmt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","και ιδου το καταπετασμα του ναου εσχισθη εισ δυο απο ανωθεν εωσ κατω και η γη εσεισθη και αι πετραι εσχισθησαν ");
INSERT INTO grcmt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","και τα μνημεια ανεωχθησαν και πολλα σωματα των κεκοιμημενων αγιων ηγερθη ");
INSERT INTO grcmt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","και εξελθοντεσ εκ των μνημειων μετα την εγερσιν αυτου εισηλθον εισ την αγιαν πολιν και ενεφανισθησαν πολλοισ ");
INSERT INTO grcmt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ο δε εκατονταρχοσ και οι μετ αυτου τηρουντεσ τον ιησουν ιδοντεσ τον σεισμον και τα γενομενα εφοβηθησαν σφοδρα λεγοντεσ αληθωσ θεου υιοσ ην ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ησαν δε εκει γυναικεσ πολλαι απο μακροθεν θεωρουσαι αιτινεσ ηκολουθησαν τω ιησου απο τησ γαλιλαιασ διακονουσαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","εν αισ ην μαρια η μαγδαληνη και μαρια η του ιακωβου και ιωση μητηρ και η μητηρ των υιων ζεβεδαιου ");
INSERT INTO grcmt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","οψιασ δε γενομενησ ηλθεν ανθρωποσ πλουσιοσ απο αριμαθαιασ τουνομα ιωσηφ οσ και αυτοσ εμαθητευσεν τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ουτοσ προσελθων τω πιλατω ητησατο το σωμα του ιησου τοτε ο πιλατοσ εκελευσεν αποδοθηναι το σωμα ");
INSERT INTO grcmt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","και λαβων το σωμα ο ιωσηφ ενετυλιξεν αυτο σινδονι καθαρα ");
INSERT INTO grcmt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","και εθηκεν αυτο εν τω καινω αυτου μνημειω ο ελατομησεν εν τη πετρα και προσκυλισασ λιθον μεγαν τη θυρα του μνημειου απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ην δε εκει μαρια η μαγδαληνη και η αλλη μαρια καθημεναι απεναντι του ταφου ");
INSERT INTO grcmt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","τη δε επαυριον ητισ εστιν μετα την παρασκευην συνηχθησαν οι αρχιερεισ και οι φαρισαιοι προσ πιλατον ");
INSERT INTO grcmt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","λεγοντεσ κυριε εμνησθημεν οτι εκεινοσ ο πλανοσ ειπεν ετι ζων μετα τρεισ ημερασ εγειρομαι ");
INSERT INTO grcmt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","κελευσον ουν ασφαλισθηναι τον ταφον εωσ τησ τριτησ ημερασ μηποτε ελθοντεσ οι μαθηται αυτου νυκτοσ κλεψωσιν αυτον και ειπωσιν τω λαω ηγερθη απο των νεκρων και εσται η εσχατη πλανη χειρων τησ πρωτησ ");
INSERT INTO grcmt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","εφη δε αυτοισ ο πιλατοσ εχετε κουστωδιαν υπαγετε ασφαλισασθε ωσ οιδατε ");
INSERT INTO grcmt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","οι δε πορευθεντεσ ησφαλισαντο τον ταφον σφραγισαντεσ τον λιθον μετα τησ κουστωδιασ ");
INSERT INTO grcmt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","οψε δε σαββατων τη επιφωσκουση εισ μιαν σαββατων ηλθεν μαρια η μαγδαληνη και η αλλη μαρια θεωρησαι τον ταφον ");
INSERT INTO grcmt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","και ιδου σεισμοσ εγενετο μεγασ αγγελοσ γαρ κυριου καταβασ εξ ουρανου προσελθων απεκυλισεν τον λιθον απο τησ θυρασ και εκαθητο επανω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ην δε η ιδεα αυτου ωσ αστραπη και το ενδυμα αυτου λευκον ωσει χιων ");
INSERT INTO grcmt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","απο δε του φοβου αυτου εσεισθησαν οι τηρουντεσ και εγενοντο ωσει νεκροι ");
INSERT INTO grcmt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","αποκριθεισ δε ο αγγελοσ ειπεν ταισ γυναιξιν μη φοβεισθε υμεισ οιδα γαρ οτι ιησουν τον εσταυρωμενον ζητειτε ");
INSERT INTO grcmt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ουκ εστιν ωδε ηγερθη γαρ καθωσ ειπεν δευτε ιδετε τον τοπον οπου εκειτο ο κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","και ταχυ πορευθεισαι ειπατε τοισ μαθηταισ αυτου οτι ηγερθη απο των νεκρων και ιδου προαγει υμασ εισ την γαλιλαιαν εκει αυτον οψεσθε ιδου ειπον υμιν ");
INSERT INTO grcmt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","και εξελθουσαι ταχυ απο του μνημειου μετα φοβου και χαρασ μεγαλησ εδραμον απαγγειλαι τοισ μαθηταισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ωσ δε επορευοντο απαγγειλαι τοισ μαθηταισ αυτου και ιδου ιησουσ απηντησεν αυταισ λεγων χαιρετε αι δε προσελθουσαι εκρατησαν αυτου τουσ ποδασ και προσεκυνησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","τοτε λεγει αυταισ ο ιησουσ μη φοβεισθε υπαγετε απαγγειλατε τοισ αδελφοισ μου ινα απελθωσιν εισ την γαλιλαιαν και εκει με οψονται ");
INSERT INTO grcmt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","πορευομενων δε αυτων ιδου τινεσ τησ κουστωδιασ ελθοντεσ εισ την πολιν απηγγειλαν τοισ αρχιερευσιν απαντα τα γενομενα ");
INSERT INTO grcmt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","και συναχθεντεσ μετα των πρεσβυτερων συμβουλιον τε λαβοντεσ αργυρια ικανα εδωκαν τοισ στρατιωταισ ");
INSERT INTO grcmt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","λεγοντεσ ειπατε οτι οι μαθηται αυτου νυκτοσ ελθοντεσ εκλεψαν αυτον ημων κοιμωμενων ");
INSERT INTO grcmt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","και εαν ακουσθη τουτο επι του ηγεμονοσ ημεισ πεισομεν αυτον και υμασ αμεριμνουσ ποιησομεν ");
INSERT INTO grcmt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","οι δε λαβοντεσ τα αργυρια εποιησαν ωσ εδιδαχθησαν και διεφημισθη ο λογοσ ουτοσ παρα ιουδαιοισ μεχρι τησ σημερον ");
INSERT INTO grcmt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","οι δε ενδεκα μαθηται επορευθησαν εισ την γαλιλαιαν εισ το οροσ ου εταξατο αυτοισ ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","και ιδοντεσ αυτον προσεκυνησαν αυτω οι δε εδιστασαν ");
INSERT INTO grcmt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","και προσελθων ο ιησουσ ελαλησεν αυτοισ λεγων εδοθη μοι πασα εξουσια εν ουρανω και επι γησ ");
INSERT INTO grcmt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","πορευθεντεσ μαθητευσατε παντα τα εθνη βαπτιζοντεσ αυτουσ εισ το ονομα του πατροσ και του υιου και του αγιου πνευματοσ ");
INSERT INTO grcmt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","διδασκοντεσ αυτουσ τηρειν παντα οσα ενετειλαμην υμιν και ιδου εγω μεθ υμων ειμι πασασ τασ ημερασ εωσ τησ συντελειασ του αιωνοσ αμην ");
INSERT INTO grcmt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","αρχη του ευαγγελιου ιησου χριστου υιου του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ωσ γεγραπται εν τοισ προφηταισ ιδου εγω αποστελλω τον αγγελον μου προ προσωπου σου οσ κατασκευασει την οδον σου εμπροσθεν σου ");
INSERT INTO grcmt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","φωνη βοωντοσ εν τη ερημω ετοιμασατε την οδον κυριου ευθειασ ποιειτε τασ τριβουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","εγενετο ιωαννησ βαπτιζων εν τη ερημω και κηρυσσων βαπτισμα μετανοιασ εισ αφεσιν αμαρτιων ");
INSERT INTO grcmt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","και εξεπορευετο προσ αυτον πασα η ιουδαια χωρα και οι ιεροσολυμιται και εβαπτιζοντο παντεσ εν τω ιορδανη ποταμω υπ αυτου εξομολογουμενοι τασ αμαρτιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ην δε ο ιωαννησ ενδεδυμενοσ τριχασ καμηλου και ζωνην δερματινην περι την οσφυν αυτου και εσθιων ακριδασ και μελι αγριον ");
INSERT INTO grcmt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","και εκηρυσσεν λεγων ερχεται ο ισχυροτεροσ μου οπισω μου ου ουκ ειμι ικανοσ κυψασ λυσαι τον ιμαντα των υποδηματων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","εγω μεν εβαπτισα υμασ εν υδατι αυτοσ δε βαπτισει υμασ εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","και εγενετο εν εκειναισ ταισ ημεραισ ηλθεν ιησουσ απο ναζαρετ τησ γαλιλαιασ και εβαπτισθη υπο ιωαννου εισ τον ιορδανην ");
INSERT INTO grcmt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","και ευθεωσ αναβαινων απο του υδατοσ ειδεν σχιζομενουσ τουσ ουρανουσ και το πνευμα ωσει περιστεραν καταβαινον επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","και φωνη εγενετο εκ των ουρανων συ ει ο υιοσ μου ο αγαπητοσ εν ω ευδοκησα ");
INSERT INTO grcmt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","και ευθυσ το πνευμα αυτον εκβαλλει εισ την ερημον ");
INSERT INTO grcmt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","και ην εκει εν τη ερημω ημερασ τεσσαρακοντα πειραζομενοσ υπο του σατανα και ην μετα των θηριων και οι αγγελοι διηκονουν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","μετα δε το παραδοθηναι τον ιωαννην ηλθεν ο ιησουσ εισ την γαλιλαιαν κηρυσσων το ευαγγελιον τησ βασιλειασ του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","και λεγων οτι πεπληρωται ο καιροσ και ηγγικεν η βασιλεια του θεου μετανοειτε και πιστευετε εν τω ευαγγελιω ");
INSERT INTO grcmt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","περιπατων δε παρα την θαλασσαν τησ γαλιλαιασ ειδεν σιμωνα και ανδρεαν τον αδελφον αυτου του σιμωνοσ βαλλοντασ αμφιβληστρον εν τη θαλασση ησαν γαρ αλιεισ ");
INSERT INTO grcmt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","και ειπεν αυτοισ ο ιησουσ δευτε οπισω μου και ποιησω υμασ γενεσθαι αλιεισ ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","και ευθεωσ αφεντεσ τα δικτυα αυτων ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","και προβασ εκειθεν ολιγον ειδεν ιακωβον τον του ζεβεδαιου και ιωαννην τον αδελφον αυτου και αυτουσ εν τω πλοιω καταρτιζοντασ τα δικτυα ");
INSERT INTO grcmt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","και ευθεωσ εκαλεσεν αυτουσ και αφεντεσ τον πατερα αυτων ζεβεδαιον εν τω πλοιω μετα των μισθωτων απηλθον οπισω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","και εισπορευονται εισ καπερναουμ και ευθεωσ τοισ σαββασιν εισελθων εισ την συναγωγην εδιδασκεν ");
INSERT INTO grcmt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","και εξεπλησσοντο επι τη διδαχη αυτου ην γαρ διδασκων αυτουσ ωσ εξουσιαν εχων και ουχ ωσ οι γραμματεισ ");
INSERT INTO grcmt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","και ην εν τη συναγωγη αυτων ανθρωποσ εν πνευματι ακαθαρτω και ανεκραξεν ");
INSERT INTO grcmt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","λεγων εα τι ημιν και σοι ιησου ναζαρηνε ηλθεσ απολεσαι ημασ οιδα σε τισ ει ο αγιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","και επετιμησεν αυτω ο ιησουσ λεγων φιμωθητι και εξελθε εξ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","και σπαραξαν αυτον το πνευμα το ακαθαρτον και κραξαν φωνη μεγαλη εξηλθεν εξ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","και εθαμβηθησαν παντεσ ωστε συζητειν προσ εαυτουσ λεγοντασ τι εστιν τουτο τισ η διδαχη η καινη αυτη οτι κατ εξουσιαν και τοισ πνευμασιν τοισ ακαθαρτοισ επιτασσει και υπακουουσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","εξηλθεν δε η ακοη αυτου ευθυσ εισ ολην την περιχωρον τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","και ευθεωσ εκ τησ συναγωγησ εξελθοντεσ ηλθον εισ την οικιαν σιμωνοσ και ανδρεου μετα ιακωβου και ιωαννου ");
INSERT INTO grcmt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","η δε πενθερα σιμωνοσ κατεκειτο πυρεσσουσα και ευθεωσ λεγουσιν αυτω περι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","και προσελθων ηγειρεν αυτην κρατησασ τησ χειροσ αυτησ και αφηκεν αυτην ο πυρετοσ ευθεωσ και διηκονει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","οψιασ δε γενομενησ οτε εδυ ο ηλιοσ εφερον προσ αυτον παντασ τουσ κακωσ εχοντασ και τουσ δαιμονιζομενουσ ");
INSERT INTO grcmt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","και η πολισ ολη επισυνηγμενη ην προσ την θυραν ");
INSERT INTO grcmt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","και εθεραπευσεν πολλουσ κακωσ εχοντασ ποικιλαισ νοσοισ και δαιμονια πολλα εξεβαλεν και ουκ ηφιεν λαλειν τα δαιμονια οτι ηδεισαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","και πρωι εννυχον λιαν αναστασ εξηλθεν και απηλθεν εισ ερημον τοπον κακει προσηυχετο ");
INSERT INTO grcmt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","και κατεδιωξαν αυτον ο σιμων και οι μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","και ευροντεσ αυτον λεγουσιν αυτω οτι παντεσ σε ζητουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","και λεγει αυτοισ αγωμεν εισ τασ εχομενασ κωμοπολεισ ινα και εκει κηρυξω εισ τουτο γαρ εξεληλυθα ");
INSERT INTO grcmt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","και ην κηρυσσων εν ταισ συναγωγαισ αυτων εισ ολην την γαλιλαιαν και τα δαιμονια εκβαλλων ");
INSERT INTO grcmt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","και ερχεται προσ αυτον λεπροσ παρακαλων αυτον και γονυπετων αυτον και λεγων αυτω οτι εαν θελησ δυνασαι με καθαρισαι ");
INSERT INTO grcmt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ο δε ιησουσ σπλαγχνισθεισ εκτεινασ την χειρα ηψατο αυτου και λεγει αυτω θελω καθαρισθητι ");
INSERT INTO grcmt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","και ειποντοσ αυτου ευθεωσ απηλθεν απ αυτου η λεπρα και εκαθαρισθη ");
INSERT INTO grcmt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","και εμβριμησαμενοσ αυτω ευθεωσ εξεβαλεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","και λεγει αυτω ορα μηδενι μηδεν ειπησ αλλ υπαγε σεαυτον δειξον τω ιερει και προσενεγκε περι του καθαρισμου σου α προσεταξεν μωσησ εισ μαρτυριον αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ο δε εξελθων ηρξατο κηρυσσειν πολλα και διαφημιζειν τον λογον ωστε μηκετι αυτον δυνασθαι φανερωσ εισ πολιν εισελθειν αλλ εξω εν ερημοισ τοποισ ην και ηρχοντο προσ αυτον πανταχοθεν ");
INSERT INTO grcmt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","και εισηλθεν παλιν εισ καπερναουμ δι ημερων και ηκουσθη οτι εισ οικον εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","και ευθεωσ συνηχθησαν πολλοι ωστε μηκετι χωρειν μηδε τα προσ την θυραν και ελαλει αυτοισ τον λογον ");
INSERT INTO grcmt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","και ερχονται προσ αυτον παραλυτικον φεροντεσ αιρομενον υπο τεσσαρων ");
INSERT INTO grcmt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","και μη δυναμενοι προσεγγισαι αυτω δια τον οχλον απεστεγασαν την στεγην οπου ην και εξορυξαντεσ χαλωσιν τον κραββατον εφ ω ο παραλυτικοσ κατεκειτο ");
INSERT INTO grcmt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ιδων δε ο ιησουσ την πιστιν αυτων λεγει τω παραλυτικω τεκνον αφεωνται σοι αι αμαρτιαι σου ");
INSERT INTO grcmt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ησαν δε τινεσ των γραμματεων εκει καθημενοι και διαλογιζομενοι εν ταισ καρδιαισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","τι ουτοσ ουτωσ λαλει βλασφημιασ τισ δυναται αφιεναι αμαρτιασ ει μη εισ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","και ευθεωσ επιγνουσ ο ιησουσ τω πνευματι αυτου οτι ουτωσ αυτοι διαλογιζονται εν εαυτοισ ειπεν αυτοισ τι ταυτα διαλογιζεσθε εν ταισ καρδιαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","τι εστιν ευκοπωτερον ειπειν τω παραλυτικω αφεωνται σου αι αμαρτιαι η ειπειν εγειραι και αρον σου τον κραββατον και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ινα δε ειδητε οτι εξουσιαν εχει ο υιοσ του ανθρωπου αφιεναι επι τησ γησ αμαρτιασ λεγει τω παραλυτικω ");
INSERT INTO grcmt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","σοι λεγω εγειραι και αρον τον κραββατον σου και υπαγε εισ τον οικον σου ");
INSERT INTO grcmt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","και ηγερθη ευθεωσ και αρασ τον κραββατον εξηλθεν εναντιον παντων ωστε εξιστασθαι παντασ και δοξαζειν τον θεον λεγοντασ οτι ουδεποτε ουτωσ ειδομεν ");
INSERT INTO grcmt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","και εξηλθεν παλιν παρα την θαλασσαν και πασ ο οχλοσ ηρχετο προσ αυτον και εδιδασκεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","και παραγων ειδεν λευι τον του αλφαιου καθημενον επι το τελωνιον και λεγει αυτω ακολουθει μοι και αναστασ ηκολουθησεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","και εγενετο εν τω κατακεισθαι αυτον εν τη οικια αυτου και πολλοι τελωναι και αμαρτωλοι συνανεκειντο τω ιησου και τοισ μαθηταισ αυτου ησαν γαρ πολλοι και ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","και οι γραμματεισ και οι φαρισαιοι ιδοντεσ αυτον εσθιοντα μετα των τελωνων και αμαρτωλων ελεγον τοισ μαθηταισ αυτου τι οτι μετα των τελωνων και αμαρτωλων εσθιει και πινει ");
INSERT INTO grcmt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","και ακουσασ ο ιησουσ λεγει αυτοισ ου χρειαν εχουσιν οι ισχυοντεσ ιατρου αλλ οι κακωσ εχοντεσ ουκ ηλθον καλεσαι δικαιουσ αλλα αμαρτωλουσ εισ μετανοιαν ");
INSERT INTO grcmt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","και ησαν οι μαθηται ιωαννου και οι των φαρισαιων νηστευοντεσ και ερχονται και λεγουσιν αυτω δια τι οι μαθηται ιωαννου και οι των φαρισαιων νηστευουσιν οι δε σοι μαθηται ου νηστευουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","και ειπεν αυτοισ ο ιησουσ μη δυνανται οι υιοι του νυμφωνοσ εν ω ο νυμφιοσ μετ αυτων εστιν νηστευειν οσον χρονον μεθ εαυτων εχουσιν τον νυμφιον ου δυνανται νηστευειν ");
INSERT INTO grcmt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ελευσονται δε ημεραι οταν απαρθη απ αυτων ο νυμφιοσ και τοτε νηστευσουσιν εν εκειναισ ταισ ημεραισ ");
INSERT INTO grcmt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","και ουδεισ επιβλημα ρακουσ αγναφου επιρραπτει επι ιματιω παλαιω ει δε μη αιρει το πληρωμα αυτου το καινον του παλαιου και χειρον σχισμα γινεται ");
INSERT INTO grcmt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","και ουδεισ βαλλει οινον νεον εισ ασκουσ παλαιουσ ει δε μη ρησσει ο οινοσ ο νεοσ τουσ ασκουσ και ο οινοσ εκχειται και οι ασκοι απολουνται αλλα οινον νεον εισ ασκουσ καινουσ βλητεον ");
INSERT INTO grcmt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","και εγενετο παραπορευεσθαι αυτον εν τοισ σαββασιν δια των σποριμων και ηρξαντο οι μαθηται αυτου οδον ποιειν τιλλοντεσ τουσ σταχυασ ");
INSERT INTO grcmt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","και οι φαρισαιοι ελεγον αυτω ιδε τι ποιουσιν εν τοισ σαββασιν ο ουκ εξεστιν ");
INSERT INTO grcmt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","και αυτοσ ελεγεν αυτοισ ουδεποτε ανεγνωτε τι εποιησεν δαυιδ οτε χρειαν εσχεν και επεινασεν αυτοσ και οι μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","πωσ εισηλθεν εισ τον οικον του θεου επι αβιαθαρ αρχιερεωσ και τουσ αρτουσ τησ προθεσεωσ εφαγεν ουσ ουκ εξεστιν φαγειν ει μη τοισ ιερευσιν και εδωκεν και τοισ συν αυτω ουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","και ελεγεν αυτοισ το σαββατον δια τον ανθρωπον εγενετο ουχ ο ανθρωποσ δια το σαββατον ");
INSERT INTO grcmt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ωστε κυριοσ εστιν ο υιοσ του ανθρωπου και του σαββατου ");
INSERT INTO grcmt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","και εισηλθεν παλιν εισ την συναγωγην και ην εκει ανθρωποσ εξηραμμενην εχων την χειρα ");
INSERT INTO grcmt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","και παρετηρουν αυτον ει τοισ σαββασιν θεραπευσει αυτον ινα κατηγορησωσιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","και λεγει τω ανθρωπω τω εξηραμμενην εχοντι την χειρα εγειραι εισ το μεσον ");
INSERT INTO grcmt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","και λεγει αυτοισ εξεστιν τοισ σαββασιν αγαθοποιησαι η κακοποιησαι ψυχην σωσαι η αποκτειναι οι δε εσιωπων ");
INSERT INTO grcmt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","και περιβλεψαμενοσ αυτουσ μετ οργησ συλλυπουμενοσ επι τη πωρωσει τησ καρδιασ αυτων λεγει τω ανθρωπω εκτεινον την χειρα σου και εξετεινεν και αποκατεσταθη η χειρ αυτου υγιησ ωσ η αλλη ");
INSERT INTO grcmt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","και εξελθοντεσ οι φαρισαιοι ευθεωσ μετα των ηρωδιανων συμβουλιον εποιουν κατ αυτου οπωσ αυτον απολεσωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","και ο ιησουσ ανεχωρησεν μετα των μαθητων αυτου προσ την θαλασσαν και πολυ πληθοσ απο τησ γαλιλαιασ ηκολουθησαν αυτω και απο τησ ιουδαιασ ");
INSERT INTO grcmt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","και απο ιεροσολυμων και απο τησ ιδουμαιασ και περαν του ιορδανου και οι περι τυρον και σιδωνα πληθοσ πολυ ακουσαντεσ οσα εποιει ηλθον προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","και ειπεν τοισ μαθηταισ αυτου ινα πλοιαριον προσκαρτερη αυτω δια τον οχλον ινα μη θλιβωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","πολλουσ γαρ εθεραπευσεν ωστε επιπιπτειν αυτω ινα αυτου αψωνται οσοι ειχον μαστιγασ ");
INSERT INTO grcmt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","και τα πνευματα τα ακαθαρτα οταν αυτον εθεωρει προσεπιπτεν αυτω και εκραζεν λεγοντα οτι συ ει ο υιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","και πολλα επετιμα αυτοισ ινα μη φανερον αυτον ποιησωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","και αναβαινει εισ το οροσ και προσκαλειται ουσ ηθελεν αυτοσ και απηλθον προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","και εποιησεν δωδεκα ινα ωσιν μετ αυτου και ινα αποστελλη αυτουσ κηρυσσειν ");
INSERT INTO grcmt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","και εχειν εξουσιαν θεραπευειν τασ νοσουσ και εκβαλλειν τα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","και επεθηκεν τω σιμωνι ονομα πετρον ");
INSERT INTO grcmt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","και ιακωβον τον του ζεβεδαιου και ιωαννην τον αδελφον του ιακωβου και επεθηκεν αυτοισ ονοματα βοανεργεσ ο εστιν υιοι βροντησ ");
INSERT INTO grcmt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","και ανδρεαν και φιλιππον και βαρθολομαιον και ματθαιον και θωμαν και ιακωβον τον του αλφαιου και θαδδαιον και σιμωνα τον κανανιτην ");
INSERT INTO grcmt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","και ιουδαν ισκαριωτην οσ και παρεδωκεν αυτον και ερχονται εισ οικον ");
INSERT INTO grcmt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","και συνερχεται παλιν οχλοσ ωστε μη δυνασθαι αυτουσ μητε αρτον φαγειν ");
INSERT INTO grcmt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","και ακουσαντεσ οι παρ αυτου εξηλθον κρατησαι αυτον ελεγον γαρ οτι εξεστη ");
INSERT INTO grcmt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","και οι γραμματεισ οι απο ιεροσολυμων καταβαντεσ ελεγον οτι βεελζεβουλ εχει και οτι εν τω αρχοντι των δαιμονιων εκβαλλει τα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","και προσκαλεσαμενοσ αυτουσ εν παραβολαισ ελεγεν αυτοισ πωσ δυναται σατανασ σαταναν εκβαλλειν ");
INSERT INTO grcmt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","και εαν βασιλεια εφ εαυτην μερισθη ου δυναται σταθηναι η βασιλεια εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","και εαν οικια εφ εαυτην μερισθη ου δυναται σταθηναι η οικια εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","και ει ο σατανασ ανεστη εφ εαυτον και μεμερισται ου δυναται σταθηναι αλλα τελοσ εχει ");
INSERT INTO grcmt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ουδεισ δυναται τα σκευη του ισχυρου εισελθων εισ την οικιαν αυτου διαρπασαι εαν μη πρωτον τον ισχυρον δηση και τοτε την οικιαν αυτου διαρπαση ");
INSERT INTO grcmt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","αμην λεγω υμιν οτι παντα αφεθησεται τα αμαρτηματα τοισ υιοισ των ανθρωπων και βλασφημιαι οσασ αν βλασφημησωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","οσ δ αν βλασφημηση εισ το πνευμα το αγιον ουκ εχει αφεσιν εισ τον αιωνα αλλ ενοχοσ εστιν αιωνιου κρισεωσ ");
INSERT INTO grcmt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","οτι ελεγον πνευμα ακαθαρτον εχει ");
INSERT INTO grcmt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ερχονται ουν οι αδελφοι και η μητηρ αυτου και εξω εστωτεσ απεστειλαν προσ αυτον φωνουντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","και εκαθητο οχλοσ περι αυτον ειπον δε αυτω ιδου η μητηρ σου και οι αδελφοι σου και αι αδελφαι σου εξω ζητουσιν σε ");
INSERT INTO grcmt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","και απεκριθη αυτοισ λεγων τισ εστιν η μητηρ μου η οι αδελφοι μου ");
INSERT INTO grcmt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","και περιβλεψαμενοσ κυκλω τουσ περι αυτον καθημενουσ λεγει ιδε η μητηρ μου και οι αδελφοι μου ");
INSERT INTO grcmt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","οσ γαρ αν ποιηση το θελημα του θεου ουτοσ αδελφοσ μου και αδελφη μου και μητηρ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","και παλιν ηρξατο διδασκειν παρα την θαλασσαν και συνηχθη προσ αυτον οχλοσ πολυσ ωστε αυτον εμβαντα εισ το πλοιον καθησθαι εν τη θαλασση και πασ ο οχλοσ προσ την θαλασσαν επι τησ γησ ην ");
INSERT INTO grcmt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","και εδιδασκεν αυτουσ εν παραβολαισ πολλα και ελεγεν αυτοισ εν τη διδαχη αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ακουετε ιδου εξηλθεν ο σπειρων του σπειραι ");
INSERT INTO grcmt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","και εγενετο εν τω σπειρειν ο μεν επεσεν παρα την οδον και ηλθεν τα πετεινα και κατεφαγεν αυτο ");
INSERT INTO grcmt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","αλλο δε επεσεν επι το πετρωδεσ οπου ουκ ειχεν γην πολλην και ευθεωσ εξανετειλεν δια το μη εχειν βαθοσ γησ ");
INSERT INTO grcmt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ηλιου δε ανατειλαντοσ εκαυματισθη και δια το μη εχειν ριζαν εξηρανθη ");
INSERT INTO grcmt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","και αλλο επεσεν εισ τασ ακανθασ και ανεβησαν αι ακανθαι και συνεπνιξαν αυτο και καρπον ουκ εδωκεν ");
INSERT INTO grcmt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","και αλλο επεσεν εισ την γην την καλην και εδιδου καρπον αναβαινοντα και αυξανοντα και εφερεν εν τριακοντα και εν εξηκοντα και εν εκατον ");
INSERT INTO grcmt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","και ελεγεν ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","οτε δε εγενετο καταμονασ ηρωτησαν αυτον οι περι αυτον συν τοισ δωδεκα την παραβολην ");
INSERT INTO grcmt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","και ελεγεν αυτοισ υμιν δεδοται γνωναι το μυστηριον τησ βασιλειασ του θεου εκεινοισ δε τοισ εξω εν παραβολαισ τα παντα γινεται ");
INSERT INTO grcmt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ινα βλεποντεσ βλεπωσιν και μη ιδωσιν και ακουοντεσ ακουωσιν και μη συνιωσιν μηποτε επιστρεψωσιν και αφεθη αυτοισ τα αμαρτηματα ");
INSERT INTO grcmt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","και λεγει αυτοισ ουκ οιδατε την παραβολην ταυτην και πωσ πασασ τασ παραβολασ γνωσεσθε ");
INSERT INTO grcmt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ο σπειρων τον λογον σπειρει ");
INSERT INTO grcmt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ουτοι δε εισιν οι παρα την οδον οπου σπειρεται ο λογοσ και οταν ακουσωσιν ευθεωσ ερχεται ο σατανασ και αιρει τον λογον τον εσπαρμενον εν ταισ καρδιαισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","και ουτοι εισιν ομοιωσ οι επι τα πετρωδη σπειρομενοι οι οταν ακουσωσιν τον λογον ευθεωσ μετα χαρασ λαμβανουσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","και ουκ εχουσιν ριζαν εν εαυτοισ αλλα προσκαιροι εισιν ειτα γενομενησ θλιψεωσ η διωγμου δια τον λογον ευθεωσ σκανδαλιζονται ");
INSERT INTO grcmt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","και ουτοι εισιν οι εισ τασ ακανθασ σπειρομενοι οι τον λογον ακουοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","και αι μεριμναι του αιωνοσ τουτου και η απατη του πλουτου και αι περι τα λοιπα επιθυμιαι εισπορευομεναι συμπνιγουσιν τον λογον και ακαρποσ γινεται ");
INSERT INTO grcmt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","και ουτοι εισιν οι επι την γην την καλην σπαρεντεσ οιτινεσ ακουουσιν τον λογον και παραδεχονται και καρποφορουσιν εν τριακοντα και εν εξηκοντα και εν εκατον ");
INSERT INTO grcmt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","και ελεγεν αυτοισ μητι ο λυχνοσ ερχεται ινα υπο τον μοδιον τεθη η υπο την κλινην ουχ ινα επι την λυχνιαν επιτεθη ");
INSERT INTO grcmt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ου γαρ εστιν τι κρυπτον ο εαν μη φανερωθη ουδε εγενετο αποκρυφον αλλ ινα εισ φανερον ελθη ");
INSERT INTO grcmt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ει τισ εχει ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","και ελεγεν αυτοισ βλεπετε τι ακουετε εν ω μετρω μετρειτε μετρηθησεται υμιν και προστεθησεται υμιν τοισ ακουουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","οσ γαρ αν εχη δοθησεται αυτω και οσ ουκ εχει και ο εχει αρθησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","και ελεγεν ουτωσ εστιν η βασιλεια του θεου ωσ εαν ανθρωποσ βαλη τον σπορον επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","και καθευδη και εγειρηται νυκτα και ημεραν και ο σποροσ βλαστανη και μηκυνηται ωσ ουκ οιδεν αυτοσ ");
INSERT INTO grcmt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","αυτοματη γαρ η γη καρποφορει πρωτον χορτον ειτα σταχυν ειτα πληρη σιτον εν τω σταχυι ");
INSERT INTO grcmt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","οταν δε παραδω ο καρποσ ευθεωσ αποστελλει το δρεπανον οτι παρεστηκεν ο θερισμοσ ");
INSERT INTO grcmt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","και ελεγεν τινι ομοιωσωμεν την βασιλειαν του θεου η εν ποια παραβολη παραβαλωμεν αυτην ");
INSERT INTO grcmt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ωσ κοκκον σιναπεωσ οσ οταν σπαρη επι τησ γησ μικροτεροσ παντων των σπερματων εστιν των επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","και οταν σπαρη αναβαινει και γινεται παντων των λαχανων μειζων και ποιει κλαδουσ μεγαλουσ ωστε δυνασθαι υπο την σκιαν αυτου τα πετεινα του ουρανου κατασκηνουν ");
INSERT INTO grcmt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","και τοιαυταισ παραβολαισ πολλαισ ελαλει αυτοισ τον λογον καθωσ εδυναντο ακουειν ");
INSERT INTO grcmt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","χωρισ δε παραβολησ ουκ ελαλει αυτοισ κατ ιδιαν δε τοισ μαθηταισ αυτου επελυεν παντα ");
INSERT INTO grcmt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","και λεγει αυτοισ εν εκεινη τη ημερα οψιασ γενομενησ διελθωμεν εισ το περαν ");
INSERT INTO grcmt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","και αφεντεσ τον οχλον παραλαμβανουσιν αυτον ωσ ην εν τω πλοιω και αλλα δε πλοιαρια ην μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","και γινεται λαιλαψ ανεμου μεγαλη τα δε κυματα επεβαλλεν εισ το πλοιον ωστε αυτο ηδη γεμιζεσθαι ");
INSERT INTO grcmt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","και ην αυτοσ επι τη πρυμνη επι το προσκεφαλαιον καθευδων και διεγειρουσιν αυτον και λεγουσιν αυτω διδασκαλε ου μελει σοι οτι απολλυμεθα ");
INSERT INTO grcmt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","και διεγερθεισ επετιμησεν τω ανεμω και ειπεν τη θαλασση σιωπα πεφιμωσο και εκοπασεν ο ανεμοσ και εγενετο γαληνη μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","και ειπεν αυτοισ τι δειλοι εστε ουτωσ πωσ ουκ εχετε πιστιν ");
INSERT INTO grcmt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","και εφοβηθησαν φοβον μεγαν και ελεγον προσ αλληλουσ τισ αρα ουτοσ εστιν οτι και ο ανεμοσ και η θαλασσα υπακουουσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","και ηλθον εισ το περαν τησ θαλασσησ εισ την χωραν των γαδαρηνων ");
INSERT INTO grcmt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","και εξελθοντι αυτω εκ του πλοιου ευθεωσ απηντησεν αυτω εκ των μνημειων ανθρωποσ εν πνευματι ακαθαρτω ");
INSERT INTO grcmt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","οσ την κατοικησιν ειχεν εν τοισ μνημασιν και ουτε αλυσεσιν ουδεισ εδυνατο αυτον δησαι ");
INSERT INTO grcmt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","δια το αυτον πολλακισ πεδαισ και αλυσεσιν δεδεσθαι και διεσπασθαι υπ αυτου τασ αλυσεισ και τασ πεδασ συντετριφθαι και ουδεισ αυτον ισχυεν δαμασαι ");
INSERT INTO grcmt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","και δια παντοσ νυκτοσ και ημερασ εν τοισ ορεσιν και εν τοισ μνημασιν ην κραζων και κατακοπτων εαυτον λιθοισ ");
INSERT INTO grcmt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ιδων δε τον ιησουν απο μακροθεν εδραμεν και προσεκυνησεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","και κραξασ φωνη μεγαλη ειπεν τι εμοι και σοι ιησου υιε του θεου του υψιστου ορκιζω σε τον θεον μη με βασανισησ ");
INSERT INTO grcmt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ελεγεν γαρ αυτω εξελθε το πνευμα το ακαθαρτον εκ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","και επηρωτα αυτον τι σοι ονομα και απεκριθη λεγων λεγεων ονομα μοι οτι πολλοι εσμεν ");
INSERT INTO grcmt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","και παρεκαλει αυτον πολλα ινα μη αυτουσ αποστειλη εξω τησ χωρασ ");
INSERT INTO grcmt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ην δε εκει προσ τω ορει αγελη χοιρων μεγαλη βοσκομενη ");
INSERT INTO grcmt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","και παρεκαλεσαν αυτον παντεσ οι δαιμονεσ λεγοντεσ πεμψον ημασ εισ τουσ χοιρουσ ινα εισ αυτουσ εισελθωμεν ");
INSERT INTO grcmt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","και επετρεψεν αυτοισ ευθεωσ ο ιησουσ και εξελθοντα τα πνευματα τα ακαθαρτα εισηλθον εισ τουσ χοιρουσ και ωρμησεν η αγελη κατα του κρημνου εισ την θαλασσαν ησαν δε ωσ δισχιλιοι και επνιγοντο εν τη θαλασση ");
INSERT INTO grcmt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","οι δε βοσκοντεσ τουσ χοιρουσ εφυγον και ανηγγειλαν εισ την πολιν και εισ τουσ αγρουσ και εξηλθον ιδειν τι εστιν το γεγονοσ ");
INSERT INTO grcmt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","και ερχονται προσ τον ιησουν και θεωρουσιν τον δαιμονιζομενον καθημενον και ιματισμενον και σωφρονουντα τον εσχηκοτα τον λεγεωνα και εφοβηθησαν ");
INSERT INTO grcmt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","διηγησαντο δε αυτοισ οι ιδοντεσ πωσ εγενετο τω δαιμονιζομενω και περι των χοιρων ");
INSERT INTO grcmt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","και ηρξαντο παρακαλειν αυτον απελθειν απο των οριων αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","και εμβαντοσ αυτου εισ το πλοιον παρεκαλει αυτον ο δαιμονισθεισ ινα η μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ο δε ιησουσ ουκ αφηκεν αυτον αλλα λεγει αυτω υπαγε εισ τον οικον σου προσ τουσ σουσ και αναγγειλον αυτοισ οσα σοι ο κυριοσ πεποιηκεν και ηλεησεν σε ");
INSERT INTO grcmt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","και απηλθεν και ηρξατο κηρυσσειν εν τη δεκαπολει οσα εποιησεν αυτω ο ιησουσ και παντεσ εθαυμαζον ");
INSERT INTO grcmt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","και διαπερασαντοσ του ιησου εν τω πλοιω παλιν εισ το περαν συνηχθη οχλοσ πολυσ επ αυτον και ην παρα την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","και ιδου ερχεται εισ των αρχισυναγωγων ονοματι ιαειροσ και ιδων αυτον πιπτει προσ τουσ ποδασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","και παρεκαλει αυτον πολλα λεγων οτι το θυγατριον μου εσχατωσ εχει ινα ελθων επιθησ αυτη τασ χειρασ οπωσ σωθη και ζησεται ");
INSERT INTO grcmt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","και απηλθεν μετ αυτου και ηκολουθει αυτω οχλοσ πολυσ και συνεθλιβον αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","και γυνη τισ ουσα εν ρυσει αιματοσ ετη δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","και πολλα παθουσα υπο πολλων ιατρων και δαπανησασα τα παρ αυτησ παντα και μηδεν ωφεληθεισα αλλα μαλλον εισ το χειρον ελθουσα ");
INSERT INTO grcmt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ακουσασα περι του ιησου ελθουσα εν τω οχλω οπισθεν ηψατο του ιματιου αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ελεγεν γαρ οτι καν των ιματιων αυτου αψωμαι σωθησομαι ");
INSERT INTO grcmt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","και ευθεωσ εξηρανθη η πηγη του αιματοσ αυτησ και εγνω τω σωματι οτι ιαται απο τησ μαστιγοσ ");
INSERT INTO grcmt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","και ευθεωσ ο ιησουσ επιγνουσ εν εαυτω την εξ αυτου δυναμιν εξελθουσαν επιστραφεισ εν τω οχλω ελεγεν τισ μου ηψατο των ιματιων ");
INSERT INTO grcmt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","και ελεγον αυτω οι μαθηται αυτου βλεπεισ τον οχλον συνθλιβοντα σε και λεγεισ τισ μου ηψατο ");
INSERT INTO grcmt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","και περιεβλεπετο ιδειν την τουτο ποιησασαν ");
INSERT INTO grcmt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","η δε γυνη φοβηθεισα και τρεμουσα ειδυια ο γεγονεν επ αυτη ηλθεν και προσεπεσεν αυτω και ειπεν αυτω πασαν την αληθειαν ");
INSERT INTO grcmt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ο δε ειπεν αυτη θυγατερ η πιστισ σου σεσωκεν σε υπαγε εισ ειρηνην και ισθι υγιησ απο τησ μαστιγοσ σου ");
INSERT INTO grcmt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ετι αυτου λαλουντοσ ερχονται απο του αρχισυναγωγου λεγοντεσ οτι η θυγατηρ σου απεθανεν τι ετι σκυλλεισ τον διδασκαλον ");
INSERT INTO grcmt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ο δε ιησουσ ευθεωσ ακουσασ τον λογον λαλουμενον λεγει τω αρχισυναγωγω μη φοβου μονον πιστευε ");
INSERT INTO grcmt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","και ουκ αφηκεν ουδενα αυτω συνακολουθησαι ει μη πετρον και ιακωβον και ιωαννην τον αδελφον ιακωβου ");
INSERT INTO grcmt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","και ερχεται εισ τον οικον του αρχισυναγωγου και θεωρει θορυβον κλαιοντασ και αλαλαζοντασ πολλα ");
INSERT INTO grcmt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","και εισελθων λεγει αυτοισ τι θορυβεισθε και κλαιετε το παιδιον ουκ απεθανεν αλλα καθευδει ");
INSERT INTO grcmt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","και κατεγελων αυτου ο δε εκβαλων παντασ παραλαμβανει τον πατερα του παιδιου και την μητερα και τουσ μετ αυτου και εισπορευεται οπου ην το παιδιον ανακειμενον ");
INSERT INTO grcmt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","και κρατησασ τησ χειροσ του παιδιου λεγει αυτη ταλιθα κουμι ο εστιν μεθερμηνευομενον το κορασιον σοι λεγω εγειραι ");
INSERT INTO grcmt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","και ευθεωσ ανεστη το κορασιον και περιεπατει ην γαρ ετων δωδεκα και εξεστησαν εκστασει μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","και διεστειλατο αυτοισ πολλα ινα μηδεισ γνω τουτο και ειπεν δοθηναι αυτη φαγειν ");
INSERT INTO grcmt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","και εξηλθεν εκειθεν και ηλθεν εισ την πατριδα αυτου και ακολουθουσιν αυτω οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","και γενομενου σαββατου ηρξατο εν τη συναγωγη διδασκειν και πολλοι ακουοντεσ εξεπλησσοντο λεγοντεσ ποθεν τουτω ταυτα και τισ η σοφια η δοθεισα αυτω και δυναμεισ τοιαυται δια των χειρων αυτου γινονται ");
INSERT INTO grcmt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ουχ ουτοσ εστιν ο τεκτων ο υιοσ μαριασ αδελφοσ δε ιακωβου και ιωση και ιουδα και σιμωνοσ και ουκ εισιν αι αδελφαι αυτου ωδε προσ ημασ και εσκανδαλιζοντο εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ελεγεν δε αυτοισ ο ιησουσ οτι ουκ εστιν προφητησ ατιμοσ ει μη εν τη πατριδι αυτου και εν τοισ συγγενεσιν και εν τη οικια αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","και ουκ ηδυνατο εκει ουδεμιαν δυναμιν ποιησαι ει μη ολιγοισ αρρωστοισ επιθεισ τασ χειρασ εθεραπευσεν ");
INSERT INTO grcmt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","και εθαυμαζεν δια την απιστιαν αυτων και περιηγεν τασ κωμασ κυκλω διδασκων ");
INSERT INTO grcmt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","και προσκαλειται τουσ δωδεκα και ηρξατο αυτουσ αποστελλειν δυο δυο και εδιδου αυτοισ εξουσιαν των πνευματων των ακαθαρτων ");
INSERT INTO grcmt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","και παρηγγειλεν αυτοισ ινα μηδεν αιρωσιν εισ οδον ει μη ραβδον μονον μη πηραν μη αρτον μη εισ την ζωνην χαλκον ");
INSERT INTO grcmt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","αλλ υποδεδεμενουσ σανδαλια και μη ενδυσησθε δυο χιτωνασ ");
INSERT INTO grcmt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","και ελεγεν αυτοισ οπου εαν εισελθητε εισ οικιαν εκει μενετε εωσ αν εξελθητε εκειθεν ");
INSERT INTO grcmt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","και οσοι αν μη δεξωνται υμασ μηδε ακουσωσιν υμων εκπορευομενοι εκειθεν εκτιναξατε τον χουν τον υποκατω των ποδων υμων εισ μαρτυριον αυτοισ αμην λεγω υμιν ανεκτοτερον εσται σοδομοισ η γομορροισ εν ημερα κρισεωσ η τη πολει εκεινη ");
INSERT INTO grcmt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","και εξελθοντεσ εκηρυσσον ινα μετανοησωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","και δαιμονια πολλα εξεβαλλον και ηλειφον ελαιω πολλουσ αρρωστουσ και εθεραπευον ");
INSERT INTO grcmt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","και ηκουσεν ο βασιλευσ ηρωδησ φανερον γαρ εγενετο το ονομα αυτου και ελεγεν οτι ιωαννησ ο βαπτιζων εκ νεκρων ηγερθη και δια τουτο ενεργουσιν αι δυναμεισ εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","αλλοι ελεγον οτι ηλιασ εστιν αλλοι δε ελεγον οτι προφητησ εστιν ωσ εισ των προφητων ");
INSERT INTO grcmt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ακουσασ δε ηρωδησ ειπεν οτι ον εγω απεκεφαλισα ιωαννην ουτοσ εστιν αυτοσ ηγερθη εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","αυτοσ γαρ ο ηρωδησ αποστειλασ εκρατησεν τον ιωαννην και εδησεν αυτον εν φυλακη δια ηρωδιαδα την γυναικα φιλιππου του αδελφου αυτου οτι αυτην εγαμησεν ");
INSERT INTO grcmt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ελεγεν γαρ ο ιωαννησ τω ηρωδη οτι ουκ εξεστιν σοι εχειν την γυναικα του αδελφου σου ");
INSERT INTO grcmt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","η δε ηρωδιασ ενειχεν αυτω και ηθελεν αυτον αποκτειναι και ουκ ηδυνατο ");
INSERT INTO grcmt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ο γαρ ηρωδησ εφοβειτο τον ιωαννην ειδωσ αυτον ανδρα δικαιον και αγιον και συνετηρει αυτον και ακουσασ αυτου πολλα εποιει και ηδεωσ αυτου ηκουεν ");
INSERT INTO grcmt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","και γενομενησ ημερασ ευκαιρου οτε ηρωδησ τοισ γενεσιοισ αυτου δειπνον εποιει τοισ μεγιστασιν αυτου και τοισ χιλιαρχοισ και τοισ πρωτοισ τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","και εισελθουσησ τησ θυγατροσ αυτησ τησ ηρωδιαδοσ και ορχησαμενησ και αρεσασησ τω ηρωδη και τοισ συνανακειμενοισ ειπεν ο βασιλευσ τω κορασιω αιτησον με ο εαν θελησ και δωσω σοι ");
INSERT INTO grcmt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","και ωμοσεν αυτη οτι ο εαν με αιτησησ δωσω σοι εωσ ημισουσ τησ βασιλειασ μου ");
INSERT INTO grcmt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","η δε εξελθουσα ειπεν τη μητρι αυτησ τι αιτησομαι η δε ειπεν την κεφαλην ιωαννου του βαπτιστου ");
INSERT INTO grcmt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","και εισελθουσα ευθεωσ μετα σπουδησ προσ τον βασιλεα ητησατο λεγουσα θελω ινα μοι δωσ εξαυτησ επι πινακι την κεφαλην ιωαννου του βαπτιστου ");
INSERT INTO grcmt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","και περιλυποσ γενομενοσ ο βασιλευσ δια τουσ ορκουσ και τουσ συνανακειμενουσ ουκ ηθελησεν αυτην αθετησαι ");
INSERT INTO grcmt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","και ευθεωσ αποστειλασ ο βασιλευσ σπεκουλατορα επεταξεν ενεχθηναι την κεφαλην αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ο δε απελθων απεκεφαλισεν αυτον εν τη φυλακη και ηνεγκεν την κεφαλην αυτου επι πινακι και εδωκεν αυτην τω κορασιω και το κορασιον εδωκεν αυτην τη μητρι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","και ακουσαντεσ οι μαθηται αυτου ηλθον και ηραν το πτωμα αυτου και εθηκαν αυτο εν μνημειω ");
INSERT INTO grcmt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","και συναγονται οι αποστολοι προσ τον ιησουν και απηγγειλαν αυτω παντα και οσα εποιησαν και οσα εδιδαξαν ");
INSERT INTO grcmt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","και ειπεν αυτοισ δευτε υμεισ αυτοι κατ ιδιαν εισ ερημον τοπον και αναπαυεσθε ολιγον ησαν γαρ οι ερχομενοι και οι υπαγοντεσ πολλοι και ουδε φαγειν ευκαιρουν ");
INSERT INTO grcmt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","και απηλθον εισ ερημον τοπον τω πλοιω κατ ιδιαν ");
INSERT INTO grcmt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","και ειδον αυτουσ υπαγοντασ και επεγνωσαν αυτον πολλοι και πεζη απο πασων των πολεων συνεδραμον εκει και προηλθον αυτουσ και συνηλθον προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","και εξελθων ειδεν ο ιησουσ πολυν οχλον και εσπλαγχνισθη επ αυτοισ οτι ησαν ωσ προβατα μη εχοντα ποιμενα και ηρξατο διδασκειν αυτουσ πολλα ");
INSERT INTO grcmt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","και ηδη ωρασ πολλησ γενομενησ προσελθοντεσ αυτω οι μαθηται αυτου λεγουσιν οτι ερημοσ εστιν ο τοποσ και ηδη ωρα πολλη ");
INSERT INTO grcmt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","απολυσον αυτουσ ινα απελθοντεσ εισ τουσ κυκλω αγρουσ και κωμασ αγορασωσιν εαυτοισ αρτουσ τι γαρ φαγωσιν ουκ εχουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ο δε αποκριθεισ ειπεν αυτοισ δοτε αυτοισ υμεισ φαγειν και λεγουσιν αυτω απελθοντεσ αγορασωμεν δηναριων διακοσιων αρτουσ και δωμεν αυτοισ φαγειν ");
INSERT INTO grcmt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ο δε λεγει αυτοισ ποσουσ αρτουσ εχετε υπαγετε και ιδετε και γνοντεσ λεγουσιν πεντε και δυο ιχθυασ ");
INSERT INTO grcmt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","και επεταξεν αυτοισ ανακλιναι παντασ συμποσια συμποσια επι τω χλωρω χορτω ");
INSERT INTO grcmt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","και ανεπεσον πρασιαι πρασιαι ανα εκατον και ανα πεντηκοντα ");
INSERT INTO grcmt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","και λαβων τουσ πεντε αρτουσ και τουσ δυο ιχθυασ αναβλεψασ εισ τον ουρανον ευλογησεν και κατεκλασεν τουσ αρτουσ και εδιδου τοισ μαθηταισ αυτου ινα παραθωσιν αυτοισ και τουσ δυο ιχθυασ εμερισεν πασιν ");
INSERT INTO grcmt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","και εφαγον παντεσ και εχορτασθησαν ");
INSERT INTO grcmt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","και ηραν κλασματων δωδεκα κοφινουσ πληρεισ και απο των ιχθυων ");
INSERT INTO grcmt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","και ησαν οι φαγοντεσ τουσ αρτουσ πεντακισχιλιοι ανδρεσ ");
INSERT INTO grcmt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","και ευθεωσ ηναγκασεν τουσ μαθητασ αυτου εμβηναι εισ το πλοιον και προαγειν εισ το περαν προσ βηθσαιδαν εωσ αυτοσ απολυση τον οχλον ");
INSERT INTO grcmt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","και αποταξαμενοσ αυτοισ απηλθεν εισ το οροσ προσευξασθαι ");
INSERT INTO grcmt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","και οψιασ γενομενησ ην το πλοιον εν μεσω τησ θαλασσησ και αυτοσ μονοσ επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","και ειδεν αυτουσ βασανιζομενουσ εν τω ελαυνειν ην γαρ ο ανεμοσ εναντιοσ αυτοισ και περι τεταρτην φυλακην τησ νυκτοσ ερχεται προσ αυτουσ περιπατων επι τησ θαλασσησ και ηθελεν παρελθειν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","οι δε ιδοντεσ αυτον περιπατουντα επι τησ θαλασσησ εδοξαν φαντασμα ειναι και ανεκραξαν ");
INSERT INTO grcmt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","παντεσ γαρ αυτον ειδον και εταραχθησαν και ευθεωσ ελαλησεν μετ αυτων και λεγει αυτοισ θαρσειτε εγω ειμι μη φοβεισθε ");
INSERT INTO grcmt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","και ανεβη προσ αυτουσ εισ το πλοιον και εκοπασεν ο ανεμοσ και λιαν εκπερισσου εν εαυτοισ εξισταντο και εθαυμαζον ");
INSERT INTO grcmt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ου γαρ συνηκαν επι τοισ αρτοισ ην γαρ αυτων η καρδια πεπωρωμενη ");
INSERT INTO grcmt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","και διαπερασαντεσ ηλθον επι την γην γεννησαρετ και προσωρμισθησαν ");
INSERT INTO grcmt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","και εξελθοντων αυτων εκ του πλοιου ευθεωσ επιγνοντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","περιδραμοντεσ ολην την περιχωρον εκεινην ηρξαντο επι τοισ κραββατοισ τουσ κακωσ εχοντασ περιφερειν οπου ηκουον οτι εκει εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","και οπου αν εισεπορευετο εισ κωμασ η πολεισ η αγρουσ εν ταισ αγοραισ ετιθουν τουσ ασθενουντασ και παρεκαλουν αυτον ινα καν του κρασπεδου του ιματιου αυτου αψωνται και οσοι αν ηπτοντο αυτου εσωζοντο ");
INSERT INTO grcmt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","και συναγονται προσ αυτον οι φαρισαιοι και τινεσ των γραμματεων ελθοντεσ απο ιεροσολυμων ");
INSERT INTO grcmt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","και ιδοντεσ τινασ των μαθητων αυτου κοιναισ χερσιν τουτ εστιν ανιπτοισ εσθιοντασ αρτουσ εμεμψαντο ");
INSERT INTO grcmt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","οι γαρ φαρισαιοι και παντεσ οι ιουδαιοι εαν μη πυγμη νιψωνται τασ χειρασ ουκ εσθιουσιν κρατουντεσ την παραδοσιν των πρεσβυτερων ");
INSERT INTO grcmt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","και απο αγορασ εαν μη βαπτισωνται ουκ εσθιουσιν και αλλα πολλα εστιν α παρελαβον κρατειν βαπτισμουσ ποτηριων και ξεστων και χαλκιων και κλινων ");
INSERT INTO grcmt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","επειτα επερωτωσιν αυτον οι φαρισαιοι και οι γραμματεισ δια τι οι μαθηται σου ου περιπατουσιν κατα την παραδοσιν των πρεσβυτερων αλλα ανιπτοισ χερσιν εσθιουσιν τον αρτον ");
INSERT INTO grcmt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ο δε αποκριθεισ ειπεν αυτοισ οτι καλωσ προεφητευσεν ησαιασ περι υμων των υποκριτων ωσ γεγραπται ουτοσ ο λαοσ τοισ χειλεσιν με τιμα η δε καρδια αυτων πορρω απεχει απ εμου ");
INSERT INTO grcmt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ματην δε σεβονται με διδασκοντεσ διδασκαλιασ ενταλματα ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","αφεντεσ γαρ την εντολην του θεου κρατειτε την παραδοσιν των ανθρωπων βαπτισμουσ ξεστων και ποτηριων και αλλα παρομοια τοιαυτα πολλα ποιειτε ");
INSERT INTO grcmt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","και ελεγεν αυτοισ καλωσ αθετειτε την εντολην του θεου ινα την παραδοσιν υμων τηρησητε ");
INSERT INTO grcmt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","μωσησ γαρ ειπεν τιμα τον πατερα σου και την μητερα σου και ο κακολογων πατερα η μητερα θανατω τελευτατω ");
INSERT INTO grcmt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","υμεισ δε λεγετε εαν ειπη ανθρωποσ τω πατρι η τη μητρι κορβαν ο εστιν δωρον ο εαν εξ εμου ωφεληθησ ");
INSERT INTO grcmt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","και ουκετι αφιετε αυτον ουδεν ποιησαι τω πατρι αυτου η τη μητρι αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ακυρουντεσ τον λογον του θεου τη παραδοσει υμων η παρεδωκατε και παρομοια τοιαυτα πολλα ποιειτε ");
INSERT INTO grcmt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","και προσκαλεσαμενοσ παντα τον οχλον ελεγεν αυτοισ ακουετε μου παντεσ και συνιετε ");
INSERT INTO grcmt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ουδεν εστιν εξωθεν του ανθρωπου εισπορευομενον εισ αυτον ο δυναται αυτον κοινωσαι αλλα τα εκπορευομενα απ αυτου εκεινα εστιν τα κοινουντα τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ει τισ εχει ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","και οτε εισηλθεν εισ οικον απο του οχλου επηρωτων αυτον οι μαθηται αυτου περι τησ παραβολησ ");
INSERT INTO grcmt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","και λεγει αυτοισ ουτωσ και υμεισ ασυνετοι εστε ου νοειτε οτι παν το εξωθεν εισπορευομενον εισ τον ανθρωπον ου δυναται αυτον κοινωσαι ");
INSERT INTO grcmt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","οτι ουκ εισπορευεται αυτου εισ την καρδιαν αλλ εισ την κοιλιαν και εισ τον αφεδρωνα εκπορευεται καθαριζον παντα τα βρωματα ");
INSERT INTO grcmt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ελεγεν δε οτι το εκ του ανθρωπου εκπορευομενον εκεινο κοινοι τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","εσωθεν γαρ εκ τησ καρδιασ των ανθρωπων οι διαλογισμοι οι κακοι εκπορευονται μοιχειαι πορνειαι φονοι ");
INSERT INTO grcmt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","κλοπαι πλεονεξιαι πονηριαι δολοσ ασελγεια οφθαλμοσ πονηροσ βλασφημια υπερηφανια αφροσυνη ");
INSERT INTO grcmt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","παντα ταυτα τα πονηρα εσωθεν εκπορευεται και κοινοι τον ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","και εκειθεν αναστασ απηλθεν εισ τα μεθορια τυρου και σιδωνοσ και εισελθων εισ οικιαν ουδενα ηθελεν γνωναι και ουκ ηδυνηθη λαθειν ");
INSERT INTO grcmt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ακουσασα γαρ γυνη περι αυτου ησ ειχεν το θυγατριον αυτησ πνευμα ακαθαρτον ελθουσα προσεπεσεν προσ τουσ ποδασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ην δε η γυνη ελληνισ συραφοινικισσα τω γενει και ηρωτα αυτον ινα το δαιμονιον εκβαλη εκ τησ θυγατροσ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ο δε ιησουσ ειπεν αυτη αφεσ πρωτον χορτασθηναι τα τεκνα ου γαρ καλον εστιν λαβειν τον αρτον των τεκνων και βαλειν τοισ κυναριοισ ");
INSERT INTO grcmt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","η δε απεκριθη και λεγει αυτω ναι κυριε και γαρ τα κυναρια υποκατω τησ τραπεζησ εσθιει απο των ψιχιων των παιδιων ");
INSERT INTO grcmt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","και ειπεν αυτη δια τουτον τον λογον υπαγε εξεληλυθεν το δαιμονιον εκ τησ θυγατροσ σου ");
INSERT INTO grcmt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","και απελθουσα εισ τον οικον αυτησ ευρεν το δαιμονιον εξεληλυθοσ και την θυγατερα βεβλημενην επι τησ κλινησ ");
INSERT INTO grcmt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","και παλιν εξελθων εκ των οριων τυρου και σιδωνοσ ηλθεν προσ την θαλασσαν τησ γαλιλαιασ ανα μεσον των οριων δεκαπολεωσ ");
INSERT INTO grcmt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","και φερουσιν αυτω κωφον μογγιλαλον και παρακαλουσιν αυτον ινα επιθη αυτω την χειρα ");
INSERT INTO grcmt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","και απολαβομενοσ αυτον απο του οχλου κατ ιδιαν εβαλεν τουσ δακτυλουσ αυτου εισ τα ωτα αυτου και πτυσασ ηψατο τησ γλωσσησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","και αναβλεψασ εισ τον ουρανον εστεναξεν και λεγει αυτω εφφαθα ο εστιν διανοιχθητι ");
INSERT INTO grcmt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","και ευθεωσ διηνοιχθησαν αυτου αι ακοαι και ελυθη ο δεσμοσ τησ γλωσσησ αυτου και ελαλει ορθωσ ");
INSERT INTO grcmt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","και διεστειλατο αυτοισ ινα μηδενι ειπωσιν οσον δε αυτοσ αυτοισ διεστελλετο μαλλον περισσοτερον εκηρυσσον ");
INSERT INTO grcmt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","και υπερπερισσωσ εξεπλησσοντο λεγοντεσ καλωσ παντα πεποιηκεν και τουσ κωφουσ ποιει ακουειν και τουσ αλαλουσ λαλειν ");
INSERT INTO grcmt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","εν εκειναισ ταισ ημεραισ παμπολλου οχλου οντοσ και μη εχοντων τι φαγωσιν προσκαλεσαμενοσ ο ιησουσ τουσ μαθητασ αυτου λεγει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","σπλαγχνιζομαι επι τον οχλον οτι ηδη ημεραι τρεισ προσμενουσιν μοι και ουκ εχουσιν τι φαγωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","και εαν απολυσω αυτουσ νηστεισ εισ οικον αυτων εκλυθησονται εν τη οδω τινεσ γαρ αυτων μακροθεν ηκουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","και απεκριθησαν αυτω οι μαθηται αυτου ποθεν τουτουσ δυνησεται τισ ωδε χορτασαι αρτων επ ερημιασ ");
INSERT INTO grcmt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","και επηρωτα αυτουσ ποσουσ εχετε αρτουσ οι δε ειπον επτα ");
INSERT INTO grcmt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","και παρηγγειλεν τω οχλω αναπεσειν επι τησ γησ και λαβων τουσ επτα αρτουσ ευχαριστησασ εκλασεν και εδιδου τοισ μαθηταισ αυτου ινα παραθωσιν και παρεθηκαν τω οχλω ");
INSERT INTO grcmt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","και ειχον ιχθυδια ολιγα και ευλογησασ ειπεν παραθειναι και αυτα ");
INSERT INTO grcmt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","εφαγον δε και εχορτασθησαν και ηραν περισσευματα κλασματων επτα σπυριδασ ");
INSERT INTO grcmt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ησαν δε οι φαγοντεσ ωσ τετρακισχιλιοι και απελυσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","και ευθεωσ εμβασ εισ το πλοιον μετα των μαθητων αυτου ηλθεν εισ τα μερη δαλμανουθα ");
INSERT INTO grcmt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","και εξηλθον οι φαρισαιοι και ηρξαντο συζητειν αυτω ζητουντεσ παρ αυτου σημειον απο του ουρανου πειραζοντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","και αναστεναξασ τω πνευματι αυτου λεγει τι η γενεα αυτη σημειον επιζητει αμην λεγω υμιν ει δοθησεται τη γενεα ταυτη σημειον ");
INSERT INTO grcmt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","και αφεισ αυτουσ εμβασ παλιν εισ πλοιον απηλθεν εισ το περαν ");
INSERT INTO grcmt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","και επελαθοντο λαβειν αρτουσ και ει μη ενα αρτον ουκ ειχον μεθ εαυτων εν τω πλοιω ");
INSERT INTO grcmt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","και διεστελλετο αυτοισ λεγων ορατε βλεπετε απο τησ ζυμησ των φαρισαιων και τησ ζυμησ ηρωδου ");
INSERT INTO grcmt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","και διελογιζοντο προσ αλληλουσ λεγοντεσ οτι αρτουσ ουκ εχομεν ");
INSERT INTO grcmt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","και γνουσ ο ιησουσ λεγει αυτοισ τι διαλογιζεσθε οτι αρτουσ ουκ εχετε ουπω νοειτε ουδε συνιετε ετι πεπωρωμενην εχετε την καρδιαν υμων ");
INSERT INTO grcmt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","οφθαλμουσ εχοντεσ ου βλεπετε και ωτα εχοντεσ ουκ ακουετε και ου μνημονευετε ");
INSERT INTO grcmt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","οτε τουσ πεντε αρτουσ εκλασα εισ τουσ πεντακισχιλιουσ ποσουσ κοφινουσ πληρεισ κλασματων ηρατε λεγουσιν αυτω δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","οτε δε τουσ επτα εισ τουσ τετρακισχιλιουσ ποσων σπυριδων πληρωματα κλασματων ηρατε οι δε ειπον επτα ");
INSERT INTO grcmt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","και ελεγεν αυτοισ πωσ ου συνιετε ");
INSERT INTO grcmt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","και ερχεται εισ βηθσαιδαν και φερουσιν αυτω τυφλον και παρακαλουσιν αυτον ινα αυτου αψηται ");
INSERT INTO grcmt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","και επιλαβομενοσ τησ χειροσ του τυφλου εξηγαγεν αυτον εξω τησ κωμησ και πτυσασ εισ τα ομματα αυτου επιθεισ τασ χειρασ αυτω επηρωτα αυτον ει τι βλεπει ");
INSERT INTO grcmt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","και αναβλεψασ ελεγεν βλεπω τουσ ανθρωπουσ οτι ωσ δενδρα ορω περιπατουντασ ");
INSERT INTO grcmt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ειτα παλιν επεθηκεν τασ χειρασ επι τουσ οφθαλμουσ αυτου και εποιησεν αυτον αναβλεψαι και αποκατεσταθη και ενεβλεψεν τηλαυγωσ απαντασ ");
INSERT INTO grcmt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","και απεστειλεν αυτον εισ τον οικον αυτου λεγων μηδε εισ την κωμην εισελθησ μηδε ειπησ τινι εν τη κωμη ");
INSERT INTO grcmt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","και εξηλθεν ο ιησουσ και οι μαθηται αυτου εισ τασ κωμασ καισαρειασ τησ φιλιππου και εν τη οδω επηρωτα τουσ μαθητασ αυτου λεγων αυτοισ τινα με λεγουσιν οι ανθρωποι ειναι ");
INSERT INTO grcmt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","οι δε απεκριθησαν ιωαννην τον βαπτιστην και αλλοι ηλιαν αλλοι δε ενα των προφητων ");
INSERT INTO grcmt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","και αυτοσ λεγει αυτοισ υμεισ δε τινα με λεγετε ειναι αποκριθεισ δε ο πετροσ λεγει αυτω συ ει ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","και επετιμησεν αυτοισ ινα μηδενι λεγωσιν περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","και ηρξατο διδασκειν αυτουσ οτι δει τον υιον του ανθρωπου πολλα παθειν και αποδοκιμασθηναι απο των πρεσβυτερων και των αρχιερεων και των γραμματεων και αποκτανθηναι και μετα τρεισ ημερασ αναστηναι ");
INSERT INTO grcmt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","και παρρησια τον λογον ελαλει και προσλαβομενοσ αυτον ο πετροσ ηρξατο επιτιμαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ο δε επιστραφεισ και ιδων τουσ μαθητασ αυτου επετιμησεν τω πετρω λεγων υπαγε οπισω μου σατανα οτι ου φρονεισ τα του θεου αλλα τα των ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","και προσκαλεσαμενοσ τον οχλον συν τοισ μαθηταισ αυτου ειπεν αυτοισ οστισ θελει οπισω μου ακολουθειν απαρνησασθω εαυτον και αρατω τον σταυρον αυτου και ακολουθειτω μοι ");
INSERT INTO grcmt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","οσ γαρ αν θελη την ψυχην αυτου σωσαι απολεσει αυτην οσ δ αν απολεση την εαυτου ψυχην ενεκεν εμου και του ευαγγελιου ουτοσ σωσει αυτην ");
INSERT INTO grcmt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","τι γαρ ωφελησει ανθρωπον εαν κερδηση τον κοσμον ολον και ζημιωθη την ψυχην αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","η τι δωσει ανθρωποσ ανταλλαγμα τησ ψυχησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","οσ γαρ εαν επαισχυνθη με και τουσ εμουσ λογουσ εν τη γενεα ταυτη τη μοιχαλιδι και αμαρτωλω και ο υιοσ του ανθρωπου επαισχυνθησεται αυτον οταν ελθη εν τη δοξη του πατροσ αυτου μετα των αγγελων των αγιων ");
INSERT INTO grcmt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","και ελεγεν αυτοισ αμην λεγω υμιν οτι εισιν τινεσ των ωδε εστηκοτων οιτινεσ ου μη γευσωνται θανατου εωσ αν ιδωσιν την βασιλειαν του θεου εληλυθυιαν εν δυναμει ");
INSERT INTO grcmt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","και μεθ ημερασ εξ παραλαμβανει ο ιησουσ τον πετρον και τον ιακωβον και ιωαννην και αναφερει αυτουσ εισ οροσ υψηλον κατ ιδιαν μονουσ και μετεμορφωθη εμπροσθεν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","και τα ιματια αυτου εγενοντο στιλβοντα λευκα λιαν ωσ χιων οια γναφευσ επι τησ γησ ου δυναται λευκαναι ");
INSERT INTO grcmt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","και ωφθη αυτοισ ηλιασ συν μωση και ησαν συλλαλουντεσ τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","και αποκριθεισ ο πετροσ λεγει τω ιησου ραββι καλον εστιν ημασ ωδε ειναι και ποιησωμεν σκηνασ τρεισ σοι μιαν και μωση μιαν και ηλια μιαν ");
INSERT INTO grcmt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ου γαρ ηδει τι λαλησει ησαν γαρ εκφοβοι ");
INSERT INTO grcmt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","και εγενετο νεφελη επισκιαζουσα αυτοισ και ηλθεν φωνη εκ τησ νεφελησ ουτοσ εστιν ο υιοσ μου ο αγαπητοσ αυτου ακουετε ");
INSERT INTO grcmt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","και εξαπινα περιβλεψαμενοι ουκετι ουδενα ειδον αλλα τον ιησουν μονον μεθ εαυτων ");
INSERT INTO grcmt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","καταβαινοντων δε αυτων απο του ορουσ διεστειλατο αυτοισ ινα μηδενι διηγησωνται α ειδον ει μη οταν ο υιοσ του ανθρωπου εκ νεκρων αναστη ");
INSERT INTO grcmt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","και τον λογον εκρατησαν προσ εαυτουσ συζητουντεσ τι εστιν το εκ νεκρων αναστηναι ");
INSERT INTO grcmt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","και επηρωτων αυτον λεγοντεσ οτι λεγουσιν οι γραμματεισ οτι ηλιαν δει ελθειν πρωτον ");
INSERT INTO grcmt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ο δε αποκριθεισ ειπεν αυτοισ ηλιασ μεν ελθων πρωτον αποκαθιστα παντα και πωσ γεγραπται επι τον υιον του ανθρωπου ινα πολλα παθη και εξουδενωθη ");
INSERT INTO grcmt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","αλλα λεγω υμιν οτι και ηλιασ εληλυθεν και εποιησαν αυτω οσα ηθελησαν καθωσ γεγραπται επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","και ελθων προσ τουσ μαθητασ ειδεν οχλον πολυν περι αυτουσ και γραμματεισ συζητουντασ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","και ευθεωσ πασ ο οχλοσ ιδων αυτον εξεθαμβηθη και προστρεχοντεσ ησπαζοντο αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","και επηρωτησεν τουσ γραμματεισ τι συζητειτε προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","και αποκριθεισ εισ εκ του οχλου ειπεν διδασκαλε ηνεγκα τον υιον μου προσ σε εχοντα πνευμα αλαλον ");
INSERT INTO grcmt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","και οπου αν αυτον καταλαβη ρησσει αυτον και αφριζει και τριζει τουσ οδοντασ αυτου και ξηραινεται και ειπον τοισ μαθηταισ σου ινα αυτο εκβαλωσιν και ουκ ισχυσαν ");
INSERT INTO grcmt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ο δε αποκριθεισ αυτω λεγει ω γενεα απιστοσ εωσ ποτε προσ υμασ εσομαι εωσ ποτε ανεξομαι υμων φερετε αυτον προσ με ");
INSERT INTO grcmt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","και ηνεγκαν αυτον προσ αυτον και ιδων αυτον ευθεωσ το πνευμα εσπαραξεν αυτον και πεσων επι τησ γησ εκυλιετο αφριζων ");
INSERT INTO grcmt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","και επηρωτησεν τον πατερα αυτου ποσοσ χρονοσ εστιν ωσ τουτο γεγονεν αυτω ο δε ειπεν παιδιοθεν ");
INSERT INTO grcmt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","και πολλακισ αυτον και εισ το πυρ εβαλεν και εισ υδατα ινα απολεση αυτον αλλ ει τι δυνασαι βοηθησον ημιν σπλαγχνισθεισ εφ ημασ ");
INSERT INTO grcmt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ο δε ιησουσ ειπεν αυτω το ει δυνασαι πιστευσαι παντα δυνατα τω πιστευοντι ");
INSERT INTO grcmt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","και ευθεωσ κραξασ ο πατηρ του παιδιου μετα δακρυων ελεγεν πιστευω κυριε βοηθει μου τη απιστια ");
INSERT INTO grcmt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ιδων δε ο ιησουσ οτι επισυντρεχει οχλοσ επετιμησεν τω πνευματι τω ακαθαρτω λεγων αυτω το πνευμα το αλαλον και κωφον εγω σοι επιτασσω εξελθε εξ αυτου και μηκετι εισελθησ εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","και κραξαν και πολλα σπαραξαν αυτον εξηλθεν και εγενετο ωσει νεκροσ ωστε πολλουσ λεγειν οτι απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ο δε ιησουσ κρατησασ αυτον τησ χειροσ ηγειρεν αυτον και ανεστη ");
INSERT INTO grcmt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","και εισελθοντα αυτον εισ οικον οι μαθηται αυτου επηρωτων αυτον κατ ιδιαν οτι ημεισ ουκ ηδυνηθημεν εκβαλειν αυτο ");
INSERT INTO grcmt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","και ειπεν αυτοισ τουτο το γενοσ εν ουδενι δυναται εξελθειν ει μη εν προσευχη και νηστεια ");
INSERT INTO grcmt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","και εκειθεν εξελθοντεσ παρεπορευοντο δια τησ γαλιλαιασ και ουκ ηθελεν ινα τισ γνω ");
INSERT INTO grcmt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","εδιδασκεν γαρ τουσ μαθητασ αυτου και ελεγεν αυτοισ οτι ο υιοσ του ανθρωπου παραδιδοται εισ χειρασ ανθρωπων και αποκτενουσιν αυτον και αποκτανθεισ τη τριτη ημερα αναστησεται ");
INSERT INTO grcmt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","οι δε ηγνοουν το ρημα και εφοβουντο αυτον επερωτησαι ");
INSERT INTO grcmt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","και ηλθεν εισ καπερναουμ και εν τη οικια γενομενοσ επηρωτα αυτουσ τι εν τη οδω προσ εαυτουσ διελογιζεσθε ");
INSERT INTO grcmt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","οι δε εσιωπων προσ αλληλουσ γαρ διελεχθησαν εν τη οδω τισ μειζων ");
INSERT INTO grcmt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","και καθισασ εφωνησεν τουσ δωδεκα και λεγει αυτοισ ει τισ θελει πρωτοσ ειναι εσται παντων εσχατοσ και παντων διακονοσ ");
INSERT INTO grcmt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","και λαβων παιδιον εστησεν αυτο εν μεσω αυτων και εναγκαλισαμενοσ αυτο ειπεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","οσ εαν εν των τοιουτων παιδιων δεξηται επι τω ονοματι μου εμε δεχεται και οσ εαν εμε δεξηται ουκ εμε δεχεται αλλα τον αποστειλαντα με ");
INSERT INTO grcmt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","απεκριθη δε αυτω ιωαννησ λεγων διδασκαλε ειδομεν τινα τω ονοματι σου εκβαλλοντα δαιμονια οσ ουκ ακολουθει ημιν και εκωλυσαμεν αυτον οτι ουκ ακολουθει ημιν ");
INSERT INTO grcmt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ο δε ιησουσ ειπεν μη κωλυετε αυτον ουδεισ γαρ εστιν οσ ποιησει δυναμιν επι τω ονοματι μου και δυνησεται ταχυ κακολογησαι με ");
INSERT INTO grcmt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","οσ γαρ ουκ εστιν καθ υμων υπερ υμων εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","οσ γαρ αν ποτιση υμασ ποτηριον υδατοσ εν ονοματι μου οτι χριστου εστε αμην λεγω υμιν ου μη απολεση τον μισθον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","και οσ εαν σκανδαλιση ενα των μικρων των πιστευοντων εισ εμε καλον εστιν αυτω μαλλον ει περικειται λιθοσ μυλικοσ περι τον τραχηλον αυτου και βεβληται εισ την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","και εαν σκανδαλιζη σε η χειρ σου αποκοψον αυτην καλον σοι εστιν κυλλον εισ την ζωην εισελθειν η τασ δυο χειρασ εχοντα απελθειν εισ την γεενναν εισ το πυρ το ασβεστον ");
INSERT INTO grcmt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","οπου ο σκωληξ αυτων ου τελευτα και το πυρ ου σβεννυται ");
INSERT INTO grcmt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","και εαν ο πουσ σου σκανδαλιζη σε αποκοψον αυτον καλον εστιν σοι εισελθειν εισ την ζωην χωλον η τουσ δυο ποδασ εχοντα βληθηναι εισ την γεενναν εισ το πυρ το ασβεστον ");
INSERT INTO grcmt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","οπου ο σκωληξ αυτων ου τελευτα και το πυρ ου σβεννυται ");
INSERT INTO grcmt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","και εαν ο οφθαλμοσ σου σκανδαλιζη σε εκβαλε αυτον καλον σοι εστιν μονοφθαλμον εισελθειν εισ την βασιλειαν του θεου η δυο οφθαλμουσ εχοντα βληθηναι εισ την γεενναν του πυροσ ");
INSERT INTO grcmt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","οπου ο σκωληξ αυτων ου τελευτα και το πυρ ου σβεννυται ");
INSERT INTO grcmt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","πασ γαρ πυρι αλισθησεται και πασα θυσια αλι αλισθησεται ");
INSERT INTO grcmt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","καλον το αλασ εαν δε το αλασ αναλον γενηται εν τινι αυτο αρτυσετε εχετε εν εαυτοισ αλασ και ειρηνευετε εν αλληλοισ ");
INSERT INTO grcmt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","κακειθεν αναστασ ερχεται εισ τα ορια τησ ιουδαιασ δια του περαν του ιορδανου και συμπορευονται παλιν οχλοι προσ αυτον και ωσ ειωθει παλιν εδιδασκεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","και προσελθοντεσ φαρισαιοι επηρωτησαν αυτον ει εξεστιν ανδρι γυναικα απολυσαι πειραζοντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ο δε αποκριθεισ ειπεν αυτοισ τι υμιν ενετειλατο μωσησ ");
INSERT INTO grcmt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","οι δε ειπον μωσησ επετρεψεν βιβλιον αποστασιου γραψαι και απολυσαι ");
INSERT INTO grcmt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","και αποκριθεισ ο ιησουσ ειπεν αυτοισ προσ την σκληροκαρδιαν υμων εγραψεν υμιν την εντολην ταυτην ");
INSERT INTO grcmt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","απο δε αρχησ κτισεωσ αρσεν και θηλυ εποιησεν αυτουσ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ενεκεν τουτου καταλειψει ανθρωποσ τον πατερα αυτου και την μητερα και προσκολληθησεται προσ την γυναικα αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","και εσονται οι δυο εισ σαρκα μιαν ωστε ουκετι εισιν δυο αλλα μια σαρξ ");
INSERT INTO grcmt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ο ουν ο θεοσ συνεζευξεν ανθρωποσ μη χωριζετω ");
INSERT INTO grcmt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","και εν τη οικια παλιν οι μαθηται αυτου περι του αυτου επηρωτησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","και λεγει αυτοισ οσ εαν απολυση την γυναικα αυτου και γαμηση αλλην μοιχαται επ αυτην ");
INSERT INTO grcmt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","και εαν γυνη απολυση τον ανδρα αυτησ και γαμηθη αλλω μοιχαται ");
INSERT INTO grcmt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","και προσεφερον αυτω παιδια ινα αψηται αυτων οι δε μαθηται επετιμων τοισ προσφερουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ιδων δε ο ιησουσ ηγανακτησεν και ειπεν αυτοισ αφετε τα παιδια ερχεσθαι προσ με μη κωλυετε αυτα των γαρ τοιουτων εστιν η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","αμην λεγω υμιν οσ εαν μη δεξηται την βασιλειαν του θεου ωσ παιδιον ου μη εισελθη εισ αυτην ");
INSERT INTO grcmt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","και εναγκαλισαμενοσ αυτα τιθεισ τασ χειρασ επ αυτα ευλογει αυτα ");
INSERT INTO grcmt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","και εκπορευομενου αυτου εισ οδον προσδραμων εισ και γονυπετησασ αυτον επηρωτα αυτον διδασκαλε αγαθε τι ποιησω ινα ζωην αιωνιον κληρονομησω ");
INSERT INTO grcmt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ο δε ιησουσ ειπεν αυτω τι με λεγεισ αγαθον ουδεισ αγαθοσ ει μη εισ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","τασ εντολασ οιδασ μη μοιχευσησ μη φονευσησ μη κλεψησ μη ψευδομαρτυρησησ μη αποστερησησ τιμα τον πατερα σου και την μητερα ");
INSERT INTO grcmt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ο δε αποκριθεισ ειπεν αυτω διδασκαλε ταυτα παντα εφυλαξαμην εκ νεοτητοσ μου ");
INSERT INTO grcmt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ο δε ιησουσ εμβλεψασ αυτω ηγαπησεν αυτον και ειπεν αυτω εν σοι υστερει υπαγε οσα εχεισ πωλησον και δοσ πτωχοισ και εξεισ θησαυρον εν ουρανω και δευρο ακολουθει μοι αρασ τον σταυρον ");
INSERT INTO grcmt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ο δε στυγνασασ επι τω λογω απηλθεν λυπουμενοσ ην γαρ εχων κτηματα πολλα ");
INSERT INTO grcmt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","και περιβλεψαμενοσ ο ιησουσ λεγει τοισ μαθηταισ αυτου πωσ δυσκολωσ οι τα χρηματα εχοντεσ εισ την βασιλειαν του θεου εισελευσονται ");
INSERT INTO grcmt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","οι δε μαθηται εθαμβουντο επι τοισ λογοισ αυτου ο δε ιησουσ παλιν αποκριθεισ λεγει αυτοισ τεκνα πωσ δυσκολον εστιν τουσ πεποιθοτασ επι χρημασιν εισ την βασιλειαν του θεου εισελθειν ");
INSERT INTO grcmt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ευκοπωτερον εστιν καμηλον δια τησ τρυμαλιασ τησ ραφιδοσ εισελθειν η πλουσιον εισ την βασιλειαν του θεου εισελθειν ");
INSERT INTO grcmt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","οι δε περισσωσ εξεπλησσοντο λεγοντεσ προσ εαυτουσ και τισ δυναται σωθηναι ");
INSERT INTO grcmt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","εμβλεψασ δε αυτοισ ο ιησουσ λεγει παρα ανθρωποισ αδυνατον αλλ ου παρα θεω παντα γαρ δυνατα εστιν παρα τω θεω ");
INSERT INTO grcmt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ηρξατο ο πετροσ λεγειν αυτω ιδου ημεισ αφηκαμεν παντα και ηκολουθησαμεν σοι ");
INSERT INTO grcmt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","αποκριθεισ ο ιησουσ ειπεν αμην λεγω υμιν ουδεισ εστιν οσ αφηκεν οικιαν η αδελφουσ η αδελφασ η πατερα η μητερα η γυναικα η τεκνα η αγρουσ ενεκεν εμου και ενεκεν του ευαγγελιου ");
INSERT INTO grcmt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","εαν μη λαβη εκατονταπλασιονα νυν εν τω καιρω τουτω οικιασ και αδελφουσ και αδελφασ και μητερασ και τεκνα και αγρουσ μετα διωγμων και εν τω αιωνι τω ερχομενω ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","πολλοι δε εσονται πρωτοι εσχατοι και εσχατοι πρωτοι ");
INSERT INTO grcmt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ησαν δε εν τη οδω αναβαινοντεσ εισ ιεροσολυμα και ην προαγων αυτουσ ο ιησουσ και εθαμβουντο και ακολουθουντεσ εφοβουντο και παραλαβων παλιν τουσ δωδεκα ηρξατο αυτοισ λεγειν τα μελλοντα αυτω συμβαινειν ");
INSERT INTO grcmt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","οτι ιδου αναβαινομεν εισ ιεροσολυμα και ο υιοσ του ανθρωπου παραδοθησεται τοισ αρχιερευσιν και γραμματευσιν και κατακρινουσιν αυτον θανατω και παραδωσουσιν αυτον τοισ εθνεσιν ");
INSERT INTO grcmt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","και εμπαιξουσιν αυτω και μαστιγωσουσιν αυτον και εμπτυσουσιν αυτω και αποκτενουσιν αυτον και τη τριτη ημερα αναστησεται ");
INSERT INTO grcmt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","και προσπορευονται αυτω ιακωβοσ και ιωαννησ οι υιοι ζεβεδαιου λεγοντεσ διδασκαλε θελομεν ινα ο εαν αιτησωμεν ποιησησ ημιν ");
INSERT INTO grcmt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ο δε ειπεν αυτοισ τι θελετε ποιησαι με υμιν ");
INSERT INTO grcmt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","οι δε ειπον αυτω δοσ ημιν ινα εισ εκ δεξιων σου και εισ εξ ευωνυμων σου καθισωμεν εν τη δοξη σου ");
INSERT INTO grcmt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ο δε ιησουσ ειπεν αυτοισ ουκ οιδατε τι αιτεισθε δυνασθε πιειν το ποτηριον ο εγω πινω και το βαπτισμα ο εγω βαπτιζομαι βαπτισθηναι ");
INSERT INTO grcmt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","οι δε ειπον αυτω δυναμεθα ο δε ιησουσ ειπεν αυτοισ το μεν ποτηριον ο εγω πινω πιεσθε και το βαπτισμα ο εγω βαπτιζομαι βαπτισθησεσθε ");
INSERT INTO grcmt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","το δε καθισαι εκ δεξιων μου και εξ ευωνυμων ουκ εστιν εμον δουναι αλλ οισ ητοιμασται ");
INSERT INTO grcmt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","και ακουσαντεσ οι δεκα ηρξαντο αγανακτειν περι ιακωβου και ιωαννου ");
INSERT INTO grcmt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ο δε ιησουσ προσκαλεσαμενοσ αυτουσ λεγει αυτοισ οιδατε οτι οι δοκουντεσ αρχειν των εθνων κατακυριευουσιν αυτων και οι μεγαλοι αυτων κατεξουσιαζουσιν αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ουχ ουτωσ δε εσται εν υμιν αλλ οσ εαν θελη γενεσθαι μεγασ εν υμιν εσται υμων διακονοσ ");
INSERT INTO grcmt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","και οσ εαν θελη υμων γενεσθαι πρωτοσ εσται παντων δουλοσ ");
INSERT INTO grcmt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","και γαρ ο υιοσ του ανθρωπου ουκ ηλθεν διακονηθηναι αλλα διακονησαι και δουναι την ψυχην αυτου λυτρον αντι πολλων ");
INSERT INTO grcmt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","και ερχονται εισ ιεριχω και εκπορευομενου αυτου απο ιεριχω και των μαθητων αυτου και οχλου ικανου υιοσ τιμαιου βαρτιμαιοσ ο τυφλοσ εκαθητο παρα την οδον προσαιτων ");
INSERT INTO grcmt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","και ακουσασ οτι ιησουσ ο ναζωραιοσ εστιν ηρξατο κραζειν και λεγειν ο υιοσ δαυιδ ιησου ελεησον με ");
INSERT INTO grcmt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","και επετιμων αυτω πολλοι ινα σιωπηση ο δε πολλω μαλλον εκραζεν υιε δαυιδ ελεησον με ");
INSERT INTO grcmt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","και στασ ο ιησουσ ειπεν αυτον φωνηθηναι και φωνουσιν τον τυφλον λεγοντεσ αυτω θαρσει εγειραι φωνει σε ");
INSERT INTO grcmt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ο δε αποβαλων το ιματιον αυτου αναστασ ηλθεν προσ τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","και αποκριθεισ λεγει αυτω ο ιησουσ τι θελεισ ποιησω σοι ο δε τυφλοσ ειπεν αυτω ραββουνι ινα αναβλεψω ");
INSERT INTO grcmt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ο δε ιησουσ ειπεν αυτω υπαγε η πιστισ σου σεσωκεν σε και ευθεωσ ανεβλεψεν και ηκολουθει τω ιησου εν τη οδω ");
INSERT INTO grcmt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","και οτε εγγιζουσιν εισ ιερουσαλημ εισ βηθσφαγη και βηθανιαν προσ το οροσ των ελαιων αποστελλει δυο των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","και λεγει αυτοισ υπαγετε εισ την κωμην την κατεναντι υμων και ευθεωσ εισπορευομενοι εισ αυτην ευρησετε πωλον δεδεμενον εφ ον ουδεισ ανθρωπων κεκαθικεν λυσαντεσ αυτον αγαγετε ");
INSERT INTO grcmt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","και εαν τισ υμιν ειπη τι ποιειτε τουτο ειπατε οτι ο κυριοσ αυτου χρειαν εχει και ευθεωσ αυτον αποστελλει ωδε ");
INSERT INTO grcmt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","απηλθον δε και ευρον πωλον δεδεμενον προσ την θυραν εξω επι του αμφοδου και λυουσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","και τινεσ των εκει εστηκοτων ελεγον αυτοισ τι ποιειτε λυοντεσ τον πωλον ");
INSERT INTO grcmt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","οι δε ειπον αυτοισ καθωσ ενετειλατο ο ιησουσ και αφηκαν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","και ηγαγον τον πωλον προσ τον ιησουν και επεβαλον αυτω τα ιματια αυτων και εκαθισεν επ αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","πολλοι δε τα ιματια αυτων εστρωσαν εισ την οδον αλλοι δε στοιβαδασ εκοπτον εκ των δενδρων και εστρωννυον εισ την οδον ");
INSERT INTO grcmt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","και οι προαγοντεσ και οι ακολουθουντεσ εκραζον λεγοντεσ ωσαννα ευλογημενοσ ο ερχομενοσ εν ονοματι κυριου ");
INSERT INTO grcmt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ευλογημενη η ερχομενη βασιλεια εν ονοματι κυριου του πατροσ ημων δαυιδ ωσαννα εν τοισ υψιστοισ ");
INSERT INTO grcmt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","και εισηλθεν εισ ιεροσολυμα ο ιησουσ και εισ το ιερον και περιβλεψαμενοσ παντα οψιασ ηδη ουσησ τησ ωρασ εξηλθεν εισ βηθανιαν μετα των δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","και τη επαυριον εξελθοντων αυτων απο βηθανιασ επεινασεν ");
INSERT INTO grcmt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","και ιδων συκην μακροθεν εχουσαν φυλλα ηλθεν ει αρα ευρησει τι εν αυτη και ελθων επ αυτην ουδεν ευρεν ει μη φυλλα ου γαρ ην καιροσ συκων ");
INSERT INTO grcmt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","και αποκριθεισ ο ιησουσ ειπεν αυτη μηκετι εκ σου εισ τον αιωνα μηδεισ καρπον φαγοι και ηκουον οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","και ερχονται εισ ιεροσολυμα και εισελθων ο ιησουσ εισ το ιερον ηρξατο εκβαλλειν τουσ πωλουντασ και αγοραζοντασ εν τω ιερω και τασ τραπεζασ των κολλυβιστων και τασ καθεδρασ των πωλουντων τασ περιστερασ κατεστρεψεν ");
INSERT INTO grcmt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","και ουκ ηφιεν ινα τισ διενεγκη σκευοσ δια του ιερου ");
INSERT INTO grcmt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","και εδιδασκεν λεγων αυτοισ ου γεγραπται οτι ο οικοσ μου οικοσ προσευχησ κληθησεται πασιν τοισ εθνεσιν υμεισ δε εποιησατε αυτον σπηλαιον ληστων ");
INSERT INTO grcmt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","και ηκουσαν οι γραμματεισ και οι αρχιερεισ και εζητουν πωσ αυτον απολεσωσιν εφοβουντο γαρ αυτον οτι πασ ο οχλοσ εξεπλησσετο επι τη διδαχη αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","και οτε οψε εγενετο εξεπορευετο εξω τησ πολεωσ ");
INSERT INTO grcmt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","και πρωι παραπορευομενοι ειδον την συκην εξηραμμενην εκ ριζων ");
INSERT INTO grcmt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","και αναμνησθεισ ο πετροσ λεγει αυτω ραββι ιδε η συκη ην κατηρασω εξηρανται ");
INSERT INTO grcmt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","και αποκριθεισ ο ιησουσ λεγει αυτοισ εχετε πιστιν θεου ");
INSERT INTO grcmt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","αμην γαρ λεγω υμιν οτι οσ αν ειπη τω ορει τουτω αρθητι και βληθητι εισ την θαλασσαν και μη διακριθη εν τη καρδια αυτου αλλα πιστευση οτι α λεγει γινεται εσται αυτω ο εαν ειπη ");
INSERT INTO grcmt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","δια τουτο λεγω υμιν παντα οσα αν προσευχομενοι αιτησθε πιστευετε οτι λαμβανετε και εσται υμιν ");
INSERT INTO grcmt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","και οταν στηκητε προσευχομενοι αφιετε ει τι εχετε κατα τινοσ ινα και ο πατηρ υμων ο εν τοισ ουρανοισ αφη υμιν τα παραπτωματα υμων ");
INSERT INTO grcmt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ει δε υμεισ ουκ αφιετε ουδε ο πατηρ υμων ο εν τοισ ουρανοισ αφησει τα παραπτωματα υμων ");
INSERT INTO grcmt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","και ερχονται παλιν εισ ιεροσολυμα και εν τω ιερω περιπατουντοσ αυτου ερχονται προσ αυτον οι αρχιερεισ και οι γραμματεισ και οι πρεσβυτεροι ");
INSERT INTO grcmt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","και λεγουσιν αυτω εν ποια εξουσια ταυτα ποιεισ και τισ σοι την εξουσιαν ταυτην εδωκεν ινα ταυτα ποιησ ");
INSERT INTO grcmt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ο δε ιησουσ αποκριθεισ ειπεν αυτοισ επερωτησω υμασ και εγω ενα λογον και αποκριθητε μοι και ερω υμιν εν ποια εξουσια ταυτα ποιω ");
INSERT INTO grcmt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","το βαπτισμα ιωαννου εξ ουρανου ην η εξ ανθρωπων αποκριθητε μοι ");
INSERT INTO grcmt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","και ελογιζοντο προσ εαυτουσ λεγοντεσ εαν ειπωμεν εξ ουρανου ερει δια τι ουν ουκ επιστευσατε αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","αλλ ειπωμεν εξ ανθρωπων εφοβουντο τον λαον απαντεσ γαρ ειχον τον ιωαννην οτι οντωσ προφητησ ην ");
INSERT INTO grcmt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","και αποκριθεντεσ λεγουσιν τω ιησου ουκ οιδαμεν και ο ιησουσ αποκριθεισ λεγει αυτοισ ουδε εγω λεγω υμιν εν ποια εξουσια ταυτα ποιω ");
INSERT INTO grcmt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","και ηρξατο αυτοισ εν παραβολαισ λεγειν αμπελωνα εφυτευσεν ανθρωποσ και περιεθηκεν φραγμον και ωρυξεν υποληνιον και ωκοδομησεν πυργον και εξεδοτο αυτον γεωργοισ και απεδημησεν ");
INSERT INTO grcmt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","και απεστειλεν προσ τουσ γεωργουσ τω καιρω δουλον ινα παρα των γεωργων λαβη απο του καρπου του αμπελωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","οι δε λαβοντεσ αυτον εδειραν και απεστειλαν κενον ");
INSERT INTO grcmt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","και παλιν απεστειλεν προσ αυτουσ αλλον δουλον κακεινον λιθοβολησαντεσ εκεφαλαιωσαν και απεστειλαν ητιμωμενον ");
INSERT INTO grcmt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","και παλιν αλλον απεστειλεν κακεινον απεκτειναν και πολλουσ αλλουσ τουσ μεν δεροντεσ τουσ δε αποκτενοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ετι ουν ενα υιον εχων αγαπητον αυτου απεστειλεν και αυτον προσ αυτουσ εσχατον λεγων οτι εντραπησονται τον υιον μου ");
INSERT INTO grcmt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","εκεινοι δε οι γεωργοι ειπον προσ εαυτουσ οτι ουτοσ εστιν ο κληρονομοσ δευτε αποκτεινωμεν αυτον και ημων εσται η κληρονομια ");
INSERT INTO grcmt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","και λαβοντεσ αυτον απεκτειναν και εξεβαλον εξω του αμπελωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","τι ουν ποιησει ο κυριοσ του αμπελωνοσ ελευσεται και απολεσει τουσ γεωργουσ και δωσει τον αμπελωνα αλλοισ ");
INSERT INTO grcmt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ουδε την γραφην ταυτην ανεγνωτε λιθον ον απεδοκιμασαν οι οικοδομουντεσ ουτοσ εγενηθη εισ κεφαλην γωνιασ ");
INSERT INTO grcmt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","παρα κυριου εγενετο αυτη και εστιν θαυμαστη εν οφθαλμοισ ημων ");
INSERT INTO grcmt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","και εζητουν αυτον κρατησαι και εφοβηθησαν τον οχλον εγνωσαν γαρ οτι προσ αυτουσ την παραβολην ειπεν και αφεντεσ αυτον απηλθον ");
INSERT INTO grcmt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","και αποστελλουσιν προσ αυτον τινασ των φαρισαιων και των ηρωδιανων ινα αυτον αγρευσωσιν λογω ");
INSERT INTO grcmt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","οι δε ελθοντεσ λεγουσιν αυτω διδασκαλε οιδαμεν οτι αληθησ ει και ου μελει σοι περι ουδενοσ ου γαρ βλεπεισ εισ προσωπον ανθρωπων αλλ επ αληθειασ την οδον του θεου διδασκεισ εξεστιν κηνσον καισαρι δουναι η ου ");
INSERT INTO grcmt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","δωμεν η μη δωμεν ο δε ειδωσ αυτων την υποκρισιν ειπεν αυτοισ τι με πειραζετε φερετε μοι δηναριον ινα ιδω ");
INSERT INTO grcmt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","οι δε ηνεγκαν και λεγει αυτοισ τινοσ η εικων αυτη και η επιγραφη οι δε ειπον αυτω καισαροσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","και αποκριθεισ ο ιησουσ ειπεν αυτοισ αποδοτε τα καισαροσ καισαρι και τα του θεου τω θεω και εθαυμασαν επ αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","και ερχονται σαδδουκαιοι προσ αυτον οιτινεσ λεγουσιν αναστασιν μη ειναι και επηρωτησαν αυτον λεγοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","διδασκαλε μωσησ εγραψεν ημιν οτι εαν τινοσ αδελφοσ αποθανη και καταλιπη γυναικα και τεκνα μη αφη ινα λαβη ο αδελφοσ αυτου την γυναικα αυτου και εξαναστηση σπερμα τω αδελφω αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","επτα αδελφοι ησαν και ο πρωτοσ ελαβεν γυναικα και αποθνησκων ουκ αφηκεν σπερμα ");
INSERT INTO grcmt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","και ο δευτεροσ ελαβεν αυτην και απεθανεν και ουδε αυτοσ αφηκεν σπερμα και ο τριτοσ ωσαυτωσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","και ελαβον αυτην οι επτα και ουκ αφηκαν σπερμα εσχατη παντων απεθανεν και η γυνη ");
INSERT INTO grcmt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","εν τη αναστασει οταν αναστωσιν τινοσ αυτων εσται γυνη οι γαρ επτα εσχον αυτην γυναικα ");
INSERT INTO grcmt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","και αποκριθεισ ο ιησουσ ειπεν αυτοισ ου δια τουτο πλανασθε μη ειδοτεσ τασ γραφασ μηδε την δυναμιν του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","οταν γαρ εκ νεκρων αναστωσιν ουτε γαμουσιν ουτε γαμισκονται αλλ εισιν ωσ αγγελοι οι εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","περι δε των νεκρων οτι εγειρονται ουκ ανεγνωτε εν τη βιβλω μωσεωσ επι του βατου ωσ ειπεν αυτω ο θεοσ λεγων εγω ο θεοσ αβρααμ και ο θεοσ ισαακ και ο θεοσ ιακωβ ");
INSERT INTO grcmt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ουκ εστιν ο θεοσ νεκρων αλλα θεοσ ζωντων υμεισ ουν πολυ πλανασθε ");
INSERT INTO grcmt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","και προσελθων εισ των γραμματεων ακουσασ αυτων συζητουντων ειδωσ οτι καλωσ αυτοισ απεκριθη επηρωτησεν αυτον ποια εστιν πρωτη παντων εντολη ");
INSERT INTO grcmt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ο δε ιησουσ απεκριθη αυτω οτι πρωτη παντων των εντολων ακουε ισραηλ κυριοσ ο θεοσ ημων κυριοσ εισ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","και αγαπησεισ κυριον τον θεον σου εξ ολησ τησ καρδιασ σου και εξ ολησ τησ ψυχησ σου και εξ ολησ τησ διανοιασ σου και εξ ολησ τησ ισχυοσ σου αυτη πρωτη εντολη ");
INSERT INTO grcmt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","και δευτερα ομοια αυτη αγαπησεισ τον πλησιον σου ωσ σεαυτον μειζων τουτων αλλη εντολη ουκ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","και ειπεν αυτω ο γραμματευσ καλωσ διδασκαλε επ αληθειασ ειπασ οτι εισ εστιν και ουκ εστιν αλλοσ πλην αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","και το αγαπαν αυτον εξ ολησ τησ καρδιασ και εξ ολησ τησ συνεσεωσ και εξ ολησ τησ ψυχησ και εξ ολησ τησ ισχυοσ και το αγαπαν τον πλησιον ωσ εαυτον πλειον εστιν παντων των ολοκαυτωματων και θυσιων ");
INSERT INTO grcmt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","και ο ιησουσ ιδων αυτον οτι νουνεχωσ απεκριθη ειπεν αυτω ου μακραν ει απο τησ βασιλειασ του θεου και ουδεισ ουκετι ετολμα αυτον επερωτησαι ");
INSERT INTO grcmt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","και αποκριθεισ ο ιησουσ ελεγεν διδασκων εν τω ιερω πωσ λεγουσιν οι γραμματεισ οτι ο χριστοσ υιοσ εστιν δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","αυτοσ γαρ δαυιδ ειπεν εν πνευματι αγιω λεγει ο κυριοσ τω κυριω μου καθου εκ δεξιων μου εωσ αν θω τουσ εχθρουσ σου υποποδιον των ποδων σου ");
INSERT INTO grcmt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","αυτοσ ουν δαυιδ λεγει αυτον κυριον και ποθεν υιοσ αυτου εστιν και ο πολυσ οχλοσ ηκουεν αυτου ηδεωσ ");
INSERT INTO grcmt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","και ελεγεν αυτοισ εν τη διδαχη αυτου βλεπετε απο των γραμματεων των θελοντων εν στολαισ περιπατειν και ασπασμουσ εν ταισ αγοραισ ");
INSERT INTO grcmt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","και πρωτοκαθεδριασ εν ταισ συναγωγαισ και πρωτοκλισιασ εν τοισ δειπνοισ ");
INSERT INTO grcmt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","οι κατεσθιοντεσ τασ οικιασ των χηρων και προφασει μακρα προσευχομενοι ουτοι ληψονται περισσοτερον κριμα ");
INSERT INTO grcmt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","και καθισασ ο ιησουσ κατεναντι του γαζοφυλακιου εθεωρει πωσ ο οχλοσ βαλλει χαλκον εισ το γαζοφυλακιον και πολλοι πλουσιοι εβαλλον πολλα ");
INSERT INTO grcmt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","και ελθουσα μια χηρα πτωχη εβαλεν λεπτα δυο ο εστιν κοδραντησ ");
INSERT INTO grcmt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","και προσκαλεσαμενοσ τουσ μαθητασ αυτου λεγει αυτοισ αμην λεγω υμιν οτι η χηρα αυτη η πτωχη πλειον παντων βεβληκεν των βαλλοντων εισ το γαζοφυλακιον ");
INSERT INTO grcmt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","παντεσ γαρ εκ του περισσευοντοσ αυτοισ εβαλον αυτη δε εκ τησ υστερησεωσ αυτησ παντα οσα ειχεν εβαλεν ολον τον βιον αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","και εκπορευομενου αυτου εκ του ιερου λεγει αυτω εισ των μαθητων αυτου διδασκαλε ιδε ποταποι λιθοι και ποταπαι οικοδομαι ");
INSERT INTO grcmt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","και ο ιησουσ αποκριθεισ ειπεν αυτω βλεπεισ ταυτασ τασ μεγαλασ οικοδομασ ου μη αφεθη λιθοσ επι λιθω οσ ου μη καταλυθη ");
INSERT INTO grcmt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","και καθημενου αυτου εισ το οροσ των ελαιων κατεναντι του ιερου επηρωτων αυτον κατ ιδιαν πετροσ και ιακωβοσ και ιωαννησ και ανδρεασ ");
INSERT INTO grcmt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ειπε ημιν ποτε ταυτα εσται και τι το σημειον οταν μελλη παντα ταυτα συντελεισθαι ");
INSERT INTO grcmt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ο δε ιησουσ αποκριθεισ αυτοισ ηρξατο λεγειν βλεπετε μη τισ υμασ πλανηση ");
INSERT INTO grcmt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","πολλοι γαρ ελευσονται επι τω ονοματι μου λεγοντεσ οτι εγω ειμι και πολλουσ πλανησουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","οταν δε ακουσητε πολεμουσ και ακοασ πολεμων μη θροεισθε δει γαρ γενεσθαι αλλ ουπω το τελοσ ");
INSERT INTO grcmt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","εγερθησεται γαρ εθνοσ επι εθνοσ και βασιλεια επι βασιλειαν και εσονται σεισμοι κατα τοπουσ και εσονται λιμοι και ταραχαι αρχαι ωδινων ταυτα ");
INSERT INTO grcmt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","βλεπετε δε υμεισ εαυτουσ παραδωσουσιν γαρ υμασ εισ συνεδρια και εισ συναγωγασ δαρησεσθε και επι ηγεμονων και βασιλεων σταθησεσθε ενεκεν εμου εισ μαρτυριον αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","και εισ παντα τα εθνη δει πρωτον κηρυχθηναι το ευαγγελιον ");
INSERT INTO grcmt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","οταν δε αγαγωσιν υμασ παραδιδοντεσ μη προμεριμνατε τι λαλησητε μηδε μελετατε αλλ ο εαν δοθη υμιν εν εκεινη τη ωρα τουτο λαλειτε ου γαρ εστε υμεισ οι λαλουντεσ αλλα το πνευμα το αγιον ");
INSERT INTO grcmt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","παραδωσει δε αδελφοσ αδελφον εισ θανατον και πατηρ τεκνον και επαναστησονται τεκνα επι γονεισ και θανατωσουσιν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","και εσεσθε μισουμενοι υπο παντων δια το ονομα μου ο δε υπομεινασ εισ τελοσ ουτοσ σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","οταν δε ιδητε το βδελυγμα τησ ερημωσεωσ το ρηθεν υπο δανιηλ του προφητου εστωσ οπου ου δει ο αναγινωσκων νοειτω τοτε οι εν τη ιουδαια φευγετωσαν εισ τα ορη ");
INSERT INTO grcmt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ο δε επι του δωματοσ μη καταβατω εισ την οικιαν μηδε εισελθετω αραι τι εκ τησ οικιασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","και ο εισ τον αγρον ων μη επιστρεψατω εισ τα οπισω αραι το ιματιον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ουαι δε ταισ εν γαστρι εχουσαισ και ταισ θηλαζουσαισ εν εκειναισ ταισ ημεραισ ");
INSERT INTO grcmt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","προσευχεσθε δε ινα μη γενηται η φυγη υμων χειμωνοσ ");
INSERT INTO grcmt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","εσονται γαρ αι ημεραι εκειναι θλιψισ οια ου γεγονεν τοιαυτη απ αρχησ κτισεωσ ησ εκτισεν ο θεοσ εωσ του νυν και ου μη γενηται ");
INSERT INTO grcmt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","και ει μη κυριοσ εκολοβωσεν τασ ημερασ ουκ αν εσωθη πασα σαρξ αλλα δια τουσ εκλεκτουσ ουσ εξελεξατο εκολοβωσεν τασ ημερασ ");
INSERT INTO grcmt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","τοτε εαν τισ υμιν ειπη ιδου ωδε ο χριστοσ η ιδου εκει μη πιστευετε ");
INSERT INTO grcmt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","εγερθησονται γαρ ψευδοχριστοι και ψευδοπροφηται και δωσουσιν σημεια και τερατα προσ το αποπλαναν ει δυνατον και τουσ εκλεκτουσ ");
INSERT INTO grcmt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","υμεισ δε βλεπετε ιδου προειρηκα υμιν παντα ");
INSERT INTO grcmt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","αλλ εν εκειναισ ταισ ημεραισ μετα την θλιψιν εκεινην ο ηλιοσ σκοτισθησεται και η σεληνη ου δωσει το φεγγοσ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","και οι αστερεσ του ουρανου εσονται εκπιπτοντεσ και αι δυναμεισ αι εν τοισ ουρανοισ σαλευθησονται ");
INSERT INTO grcmt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","και τοτε οψονται τον υιον του ανθρωπου ερχομενον εν νεφελαισ μετα δυναμεωσ πολλησ και δοξησ ");
INSERT INTO grcmt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","και τοτε αποστελει τουσ αγγελουσ αυτου και επισυναξει τουσ εκλεκτουσ αυτου εκ των τεσσαρων ανεμων απ ακρου γησ εωσ ακρου ουρανου ");
INSERT INTO grcmt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","απο δε τησ συκησ μαθετε την παραβολην οταν αυτησ ηδη ο κλαδοσ απαλοσ γενηται και εκφυη τα φυλλα γινωσκετε οτι εγγυσ το θεροσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ουτωσ και υμεισ οταν ταυτα ιδητε γινομενα γινωσκετε οτι εγγυσ εστιν επι θυραισ ");
INSERT INTO grcmt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","αμην λεγω υμιν οτι ου μη παρελθη η γενεα αυτη μεχρι ου παντα ταυτα γενηται ");
INSERT INTO grcmt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ο ουρανοσ και η γη παρελευσεται οι δε λογοι μου ου μη παρελθωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","περι δε τησ ημερασ εκεινησ η ωρασ ουδεισ οιδεν ουδε οι αγγελοι οι εν ουρανω ουδε ο υιοσ ει μη ο πατηρ ");
INSERT INTO grcmt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","βλεπετε αγρυπνειτε και προσευχεσθε ουκ οιδατε γαρ ποτε ο καιροσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ωσ ανθρωποσ αποδημοσ αφεισ την οικιαν αυτου και δουσ τοισ δουλοισ αυτου την εξουσιαν και εκαστω το εργον αυτου και τω θυρωρω ενετειλατο ινα γρηγορη ");
INSERT INTO grcmt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","γρηγορειτε ουν ουκ οιδατε γαρ ποτε ο κυριοσ τησ οικιασ ερχεται οψε η μεσονυκτιου η αλεκτοροφωνιασ η πρωι ");
INSERT INTO grcmt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","μη ελθων εξαιφνησ ευρη υμασ καθευδοντασ ");
INSERT INTO grcmt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","α δε υμιν λεγω πασιν λεγω γρηγορειτε ");
INSERT INTO grcmt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ην δε το πασχα και τα αζυμα μετα δυο ημερασ και εζητουν οι αρχιερεισ και οι γραμματεισ πωσ αυτον εν δολω κρατησαντεσ αποκτεινωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ελεγον δε μη εν τη εορτη μηποτε θορυβοσ εσται του λαου ");
INSERT INTO grcmt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","και οντοσ αυτου εν βηθανια εν τη οικια σιμωνοσ του λεπρου κατακειμενου αυτου ηλθεν γυνη εχουσα αλαβαστρον μυρου ναρδου πιστικησ πολυτελουσ και συντριψασα το αλαβαστρον κατεχεεν αυτου κατα τησ κεφαλησ ");
INSERT INTO grcmt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ησαν δε τινεσ αγανακτουντεσ προσ εαυτουσ και λεγοντεσ εισ τι η απωλεια αυτη του μυρου γεγονεν ");
INSERT INTO grcmt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ηδυνατο γαρ τουτο πραθηναι επανω τριακοσιων δηναριων και δοθηναι τοισ πτωχοισ και ενεβριμωντο αυτη ");
INSERT INTO grcmt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ο δε ιησουσ ειπεν αφετε αυτην τι αυτη κοπουσ παρεχετε καλον εργον ειργασατο εν εμοι ");
INSERT INTO grcmt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","παντοτε γαρ τουσ πτωχουσ εχετε μεθ εαυτων και οταν θελητε δυνασθε αυτουσ ευ ποιησαι εμε δε ου παντοτε εχετε ");
INSERT INTO grcmt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ο εσχεν αυτη εποιησεν προελαβεν μυρισαι μου το σωμα εισ τον ενταφιασμον ");
INSERT INTO grcmt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","αμην λεγω υμιν οπου εαν κηρυχθη το ευαγγελιον τουτο εισ ολον τον κοσμον και ο εποιησεν αυτη λαληθησεται εισ μνημοσυνον αυτησ ");
INSERT INTO grcmt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","και ο ιουδασ ο ισκαριωτησ εισ των δωδεκα απηλθεν προσ τουσ αρχιερεισ ινα παραδω αυτον αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","οι δε ακουσαντεσ εχαρησαν και επηγγειλαντο αυτω αργυριον δουναι και εζητει πωσ ευκαιρωσ αυτον παραδω ");
INSERT INTO grcmt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","και τη πρωτη ημερα των αζυμων οτε το πασχα εθυον λεγουσιν αυτω οι μαθηται αυτου που θελεισ απελθοντεσ ετοιμασωμεν ινα φαγησ το πασχα ");
INSERT INTO grcmt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","και αποστελλει δυο των μαθητων αυτου και λεγει αυτοισ υπαγετε εισ την πολιν και απαντησει υμιν ανθρωποσ κεραμιον υδατοσ βασταζων ακολουθησατε αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","και οπου εαν εισελθη ειπατε τω οικοδεσποτη οτι ο διδασκαλοσ λεγει που εστιν το καταλυμα οπου το πασχα μετα των μαθητων μου φαγω ");
INSERT INTO grcmt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","και αυτοσ υμιν δειξει ανωγεον μεγα εστρωμενον ετοιμον εκει ετοιμασατε ημιν ");
INSERT INTO grcmt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","και εξηλθον οι μαθηται αυτου και ηλθον εισ την πολιν και ευρον καθωσ ειπεν αυτοισ και ητοιμασαν το πασχα ");
INSERT INTO grcmt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","και οψιασ γενομενησ ερχεται μετα των δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","και ανακειμενων αυτων και εσθιοντων ειπεν ο ιησουσ αμην λεγω υμιν οτι εισ εξ υμων παραδωσει με ο εσθιων μετ εμου ");
INSERT INTO grcmt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","οι δε ηρξαντο λυπεισθαι και λεγειν αυτω εισ καθ εισ μητι εγω και αλλοσ μητι εγω ");
INSERT INTO grcmt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ο δε αποκριθεισ ειπεν αυτοισ εισ εκ των δωδεκα ο εμβαπτομενοσ μετ εμου εισ το τρυβλιον ");
INSERT INTO grcmt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ο μεν υιοσ του ανθρωπου υπαγει καθωσ γεγραπται περι αυτου ουαι δε τω ανθρωπω εκεινω δι ου ο υιοσ του ανθρωπου παραδιδοται καλον ην αυτω ει ουκ εγεννηθη ο ανθρωποσ εκεινοσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","και εσθιοντων αυτων λαβων ο ιησουσ αρτον ευλογησασ εκλασεν και εδωκεν αυτοισ και ειπεν λαβετε φαγετε τουτο εστιν το σωμα μου ");
INSERT INTO grcmt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","και λαβων το ποτηριον ευχαριστησασ εδωκεν αυτοισ και επιον εξ αυτου παντεσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","και ειπεν αυτοισ τουτο εστιν το αιμα μου το τησ καινησ διαθηκησ το περι πολλων εκχυνομενον ");
INSERT INTO grcmt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","αμην λεγω υμιν οτι ουκετι ου μη πιω εκ του γενηματοσ τησ αμπελου εωσ τησ ημερασ εκεινησ οταν αυτο πινω καινον εν τη βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","και υμνησαντεσ εξηλθον εισ το οροσ των ελαιων ");
INSERT INTO grcmt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","και λεγει αυτοισ ο ιησουσ οτι παντεσ σκανδαλισθησεσθε εν εμοι εν τη νυκτι ταυτη οτι γεγραπται παταξω τον ποιμενα και διασκορπισθησεται τα προβατα ");
INSERT INTO grcmt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","αλλα μετα το εγερθηναι με προαξω υμασ εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ο δε πετροσ εφη αυτω και ει παντεσ σκανδαλισθησονται αλλ ουκ εγω ");
INSERT INTO grcmt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","και λεγει αυτω ο ιησουσ αμην λεγω σοι οτι συ σημερον εν τη νυκτι ταυτη πριν η δισ αλεκτορα φωνησαι τρισ απαρνηση με ");
INSERT INTO grcmt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ο δε εκπερισσου ελεγεν μαλλον εαν με δεη συναποθανειν σοι ου μη σε απαρνησωμαι ωσαυτωσ δε και παντεσ ελεγον ");
INSERT INTO grcmt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","και ερχονται εισ χωριον ου το ονομα γεθσημανη και λεγει τοισ μαθηταισ αυτου καθισατε ωδε εωσ προσευξωμαι ");
INSERT INTO grcmt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","και παραλαμβανει τον πετρον και ιακωβον και ιωαννην μεθ εαυτου και ηρξατο εκθαμβεισθαι και αδημονειν ");
INSERT INTO grcmt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","και λεγει αυτοισ περιλυποσ εστιν η ψυχη μου εωσ θανατου μεινατε ωδε και γρηγορειτε ");
INSERT INTO grcmt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","και προσελθων μικρον επεσεν επι τησ γησ και προσηυχετο ινα ει δυνατον εστιν παρελθη απ αυτου η ωρα ");
INSERT INTO grcmt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","και ελεγεν αββα ο πατηρ παντα δυνατα σοι παρενεγκε το ποτηριον απ εμου τουτο αλλ ου τι εγω θελω αλλα τι συ ");
INSERT INTO grcmt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","και ερχεται και ευρισκει αυτουσ καθευδοντασ και λεγει τω πετρω σιμων καθευδεισ ουκ ισχυσασ μιαν ωραν γρηγορησαι ");
INSERT INTO grcmt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","γρηγορειτε και προσευχεσθε ινα μη εισελθητε εισ πειρασμον το μεν πνευμα προθυμον η δε σαρξ ασθενησ ");
INSERT INTO grcmt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","και παλιν απελθων προσηυξατο τον αυτον λογον ειπων ");
INSERT INTO grcmt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","και υποστρεψασ ευρεν αυτουσ παλιν καθευδοντασ ησαν γαρ οι οφθαλμοι αυτων βεβαρημενοι και ουκ ηδεισαν τι αυτω αποκριθωσιν ");
INSERT INTO grcmt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","και ερχεται το τριτον και λεγει αυτοισ καθευδετε 2518 V-PAI-2P λοιπον και αναπαυεσθε 373 V-PMI-2P απεχει ηλθεν η ωρα ιδου παραδιδοται ο υιοσ του ανθρωπου εισ τασ χειρασ των αμαρτωλων ");
INSERT INTO grcmt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","εγειρεσθε αγωμεν ιδου ο παραδιδουσ με ηγγικεν ");
INSERT INTO grcmt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","και ευθεωσ ετι αυτου λαλουντοσ παραγινεται ιουδασ εισ ων των δωδεκα και μετ αυτου οχλοσ πολυσ μετα μαχαιρων και ξυλων παρα των αρχιερεων και των γραμματεων και των πρεσβυτερων ");
INSERT INTO grcmt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","δεδωκει δε ο παραδιδουσ αυτον συσσημον αυτοισ λεγων ον αν φιλησω αυτοσ εστιν κρατησατε αυτον και απαγαγετε ασφαλωσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","και ελθων ευθεωσ προσελθων αυτω λεγει αυτω ραββι ραββι και κατεφιλησεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","οι δε επεβαλον επ αυτον τασ χειρασ αυτων και εκρατησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","εισ δε τισ των παρεστηκοτων σπασαμενοσ την μαχαιραν επαισεν τον δουλον του αρχιερεωσ και αφειλεν αυτου το ωτιον ");
INSERT INTO grcmt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","και αποκριθεισ ο ιησουσ ειπεν αυτοισ ωσ επι ληστην εξηλθετε μετα μαχαιρων και ξυλων συλλαβειν με ");
INSERT INTO grcmt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","καθ ημεραν ημην προσ υμασ εν τω ιερω διδασκων και ουκ εκρατησατε με αλλ ινα πληρωθωσιν αι γραφαι ");
INSERT INTO grcmt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","και αφεντεσ αυτον παντεσ εφυγον ");
INSERT INTO grcmt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","και εισ τισ νεανισκοσ ηκολουθησεν αυτω περιβεβλημενοσ σινδονα επι γυμνου και κρατουσιν αυτον οι νεανισκοι ");
INSERT INTO grcmt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ο δε καταλιπων την σινδονα γυμνοσ εφυγεν απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","και απηγαγον τον ιησουν προσ τον αρχιερεα και συνερχονται αυτω παντεσ οι αρχιερεισ και οι πρεσβυτεροι και οι γραμματεισ ");
INSERT INTO grcmt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","και ο πετροσ απο μακροθεν ηκολουθησεν αυτω εωσ εσω εισ την αυλην του αρχιερεωσ και ην συγκαθημενοσ μετα των υπηρετων και θερμαινομενοσ προσ το φωσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","οι δε αρχιερεισ και ολον το συνεδριον εζητουν κατα του ιησου μαρτυριαν εισ το θανατωσαι αυτον και ουχ ευρισκον ");
INSERT INTO grcmt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","πολλοι γαρ εψευδομαρτυρουν κατ αυτου και ισαι αι μαρτυριαι ουκ ησαν ");
INSERT INTO grcmt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","και τινεσ ανασταντεσ εψευδομαρτυρουν κατ αυτου λεγοντεσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","οτι ημεισ ηκουσαμεν αυτου λεγοντοσ οτι εγω καταλυσω τον ναον τουτον τον χειροποιητον και δια τριων ημερων αλλον αχειροποιητον οικοδομησω ");
INSERT INTO grcmt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","και ουδε ουτωσ ιση ην η μαρτυρια αυτων ");
INSERT INTO grcmt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","και αναστασ ο αρχιερευσ εισ μεσον επηρωτησεν τον ιησουν λεγων ουκ αποκρινη ουδεν τι ουτοι σου καταμαρτυρουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ο δε εσιωπα και ουδεν απεκρινατο παλιν ο αρχιερευσ επηρωτα αυτον και λεγει αυτω συ ει ο χριστοσ ο υιοσ του ευλογητου ");
INSERT INTO grcmt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ο δε ιησουσ ειπεν εγω ειμι και οψεσθε τον υιον του ανθρωπου εκ δεξιων καθημενον τησ δυναμεωσ και ερχομενον μετα των νεφελων του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ο δε αρχιερευσ διαρρηξασ τουσ χιτωνασ αυτου λεγει τι ετι χρειαν εχομεν μαρτυρων ");
INSERT INTO grcmt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ηκουσατε τησ βλασφημιασ τι υμιν φαινεται οι δε παντεσ κατεκριναν αυτον ειναι ενοχον θανατου ");
INSERT INTO grcmt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","και ηρξαντο τινεσ εμπτυειν αυτω και περικαλυπτειν το προσωπον αυτου και κολαφιζειν αυτον και λεγειν αυτω προφητευσον και οι υπηρεται ραπισμασιν αυτον εβαλλον ");
INSERT INTO grcmt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","και οντοσ του πετρου εν τη αυλη κατω ερχεται μια των παιδισκων του αρχιερεωσ ");
INSERT INTO grcmt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","και ιδουσα τον πετρον θερμαινομενον εμβλεψασα αυτω λεγει και συ μετα του ναζαρηνου ιησου ησθα ");
INSERT INTO grcmt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ο δε ηρνησατο λεγων ουκ οιδα ουδε επισταμαι τι συ λεγεισ και εξηλθεν εξω εισ το προαυλιον και αλεκτωρ εφωνησεν ");
INSERT INTO grcmt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","και η παιδισκη ιδουσα αυτον παλιν ηρξατο λεγειν τοισ παρεστηκοσιν οτι ουτοσ εξ αυτων εστιν ");
INSERT INTO grcmt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ο δε παλιν ηρνειτο και μετα μικρον παλιν οι παρεστωτεσ ελεγον τω πετρω αληθωσ εξ αυτων ει και γαρ γαλιλαιοσ ει και η λαλια σου ομοιαζει ");
INSERT INTO grcmt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ο δε ηρξατο αναθεματιζειν και ομνυναι οτι ουκ οιδα τον ανθρωπον τουτον ον λεγετε ");
INSERT INTO grcmt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","και εκ δευτερου αλεκτωρ εφωνησεν και ανεμνησθη ο πετροσ το ρημα ο ειπεν αυτω ο ιησουσ οτι πριν αλεκτορα φωνησαι δισ απαρνηση με τρισ και επιβαλων εκλαιεν ");
INSERT INTO grcmt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","και ευθεωσ επι το πρωι συμβουλιον ποιησαντεσ οι αρχιερεισ μετα των πρεσβυτερων και γραμματεων και ολον το συνεδριον δησαντεσ τον ιησουν απηνεγκαν και παρεδωκαν τω πιλατω ");
INSERT INTO grcmt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","και επηρωτησεν αυτον ο πιλατοσ συ ει ο βασιλευσ των ιουδαιων ο δε αποκριθεισ ειπεν αυτω συ λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","και κατηγορουν αυτου οι αρχιερεισ πολλα ");
INSERT INTO grcmt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ο δε πιλατοσ παλιν επηρωτησεν αυτον λεγων ουκ αποκρινη ουδεν ιδε ποσα σου καταμαρτυρουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ο δε ιησουσ ουκετι ουδεν απεκριθη ωστε θαυμαζειν τον πιλατον ");
INSERT INTO grcmt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","κατα δε εορτην απελυεν αυτοισ ενα δεσμιον ονπερ ητουντο ");
INSERT INTO grcmt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ην δε ο λεγομενοσ βαραββασ μετα των συστασιαστων δεδεμενοσ οιτινεσ εν τη στασει φονον πεποιηκεισαν ");
INSERT INTO grcmt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","και αναβοησασ ο οχλοσ ηρξατο αιτεισθαι καθωσ αει εποιει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ο δε πιλατοσ απεκριθη αυτοισ λεγων θελετε απολυσω υμιν τον βασιλεα των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","εγινωσκεν γαρ οτι δια φθονον παραδεδωκεισαν αυτον οι αρχιερεισ ");
INSERT INTO grcmt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","οι δε αρχιερεισ ανεσεισαν τον οχλον ινα μαλλον τον βαραββαν απολυση αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ο δε πιλατοσ αποκριθεισ παλιν ειπεν αυτοισ τι ουν θελετε ποιησω ον λεγετε βασιλεα των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","οι δε παλιν εκραξαν σταυρωσον αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ο δε πιλατοσ ελεγεν αυτοισ τι γαρ κακον εποιησεν οι δε περισσοτερωσ εκραξαν σταυρωσον αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ο δε πιλατοσ βουλομενοσ τω οχλω το ικανον ποιησαι απελυσεν αυτοισ τον βαραββαν και παρεδωκεν τον ιησουν φραγελλωσασ ινα σταυρωθη ");
INSERT INTO grcmt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","οι δε στρατιωται απηγαγον αυτον εσω τησ αυλησ ο εστιν πραιτωριον και συγκαλουσιν ολην την σπειραν ");
INSERT INTO grcmt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","και ενδυουσιν αυτον πορφυραν και περιτιθεασιν αυτω πλεξαντεσ ακανθινον στεφανον ");
INSERT INTO grcmt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","και ηρξαντο ασπαζεσθαι αυτον χαιρε ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","και ετυπτον αυτου την κεφαλην καλαμω και ενεπτυον αυτω και τιθεντεσ τα γονατα προσεκυνουν αυτω ");
INSERT INTO grcmt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","και οτε ενεπαιξαν αυτω εξεδυσαν αυτον την πορφυραν και ενεδυσαν αυτον τα ιματια τα ιδια και εξαγουσιν αυτον ινα σταυρωσωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","και αγγαρευουσιν παραγοντα τινα σιμωνα κυρηναιον ερχομενον απ αγρου τον πατερα αλεξανδρου και ρουφου ινα αρη τον σταυρον αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","και φερουσιν αυτον επι γολγοθα τοπον ο εστιν μεθερμηνευομενον κρανιου τοποσ ");
INSERT INTO grcmt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","και εδιδουν αυτω πιειν εσμυρνισμενον οινον ο δε ουκ ελαβεν ");
INSERT INTO grcmt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","και σταυρωσαντεσ αυτον διαμεριζονται τα ιματια αυτου βαλλοντεσ κληρον επ αυτα τισ τι αρη ");
INSERT INTO grcmt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ην δε ωρα τριτη και εσταυρωσαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","και ην η επιγραφη τησ αιτιασ αυτου επιγεγραμμενη ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","και συν αυτω σταυρουσιν δυο ληστασ ενα εκ δεξιων και ενα εξ ευωνυμων αυτου ");
INSERT INTO grcmt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","και επληρωθη η γραφη η λεγουσα και μετα ανομων ελογισθη ");
INSERT INTO grcmt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","και οι παραπορευομενοι εβλασφημουν αυτον κινουντεσ τασ κεφαλασ αυτων και λεγοντεσ ουα ο καταλυων τον ναον και εν τρισιν ημεραισ οικοδομων ");
INSERT INTO grcmt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","σωσον σεαυτον και καταβα απο του σταυρου ");
INSERT INTO grcmt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ομοιωσ και οι αρχιερεισ εμπαιζοντεσ προσ αλληλουσ μετα των γραμματεων ελεγον αλλουσ εσωσεν εαυτον ου δυναται σωσαι ");
INSERT INTO grcmt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ο χριστοσ ο βασιλευσ του ισραηλ καταβατω νυν απο του σταυρου ινα ιδωμεν και πιστευσωμεν αυτω και οι συνεσταυρωμενοι αυτω ωνειδιζον αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","γενομενησ δε ωρασ εκτησ σκοτοσ εγενετο εφ ολην την γην εωσ ωρασ ενατησ ");
INSERT INTO grcmt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","και τη ωρα τη ενατη εβοησεν ο ιησουσ φωνη μεγαλη λεγων ελωι ελωι λιμα σαβαχθανι ο εστιν μεθερμηνευομενον ο θεοσ μου ο θεοσ μου εισ τι με εγκατελιπεσ ");
INSERT INTO grcmt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","και τινεσ των παρεστηκοτων ακουσαντεσ ελεγον ιδου ηλιαν φωνει ");
INSERT INTO grcmt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","δραμων δε εισ και γεμισασ σπογγον οξουσ περιθεισ τε καλαμω εποτιζεν αυτον λεγων αφετε ιδωμεν ει ερχεται ηλιασ καθελειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ο δε ιησουσ αφεισ φωνην μεγαλην εξεπνευσεν ");
INSERT INTO grcmt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","και το καταπετασμα του ναου εσχισθη εισ δυο απο ανωθεν εωσ κατω ");
INSERT INTO grcmt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ιδων δε ο κεντυριων ο παρεστηκωσ εξ εναντιασ αυτου οτι ουτωσ κραξασ εξεπνευσεν ειπεν αληθωσ ο ανθρωποσ ουτοσ υιοσ ην θεου ");
INSERT INTO grcmt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ησαν δε και γυναικεσ απο μακροθεν θεωρουσαι εν αισ ην και μαρια η μαγδαληνη και μαρια η του ιακωβου του μικρου και ιωση μητηρ και σαλωμη ");
INSERT INTO grcmt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","αι και οτε ην εν τη γαλιλαια ηκολουθουν αυτω και διηκονουν αυτω και αλλαι πολλαι αι συναναβασαι αυτω εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","και ηδη οψιασ γενομενησ επει ην παρασκευη ο εστιν προσαββατον ");
INSERT INTO grcmt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ηλθεν ιωσηφ ο απο αριμαθαιασ ευσχημων βουλευτησ οσ και αυτοσ ην προσδεχομενοσ την βασιλειαν του θεου τολμησασ εισηλθεν προσ πιλατον και ητησατο το σωμα του ιησου ");
INSERT INTO grcmt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ο δε πιλατοσ εθαυμασεν ει ηδη τεθνηκεν και προσκαλεσαμενοσ τον κεντυριωνα επηρωτησεν αυτον ει παλαι απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","και γνουσ απο του κεντυριωνοσ εδωρησατο το σωμα τω ιωσηφ ");
INSERT INTO grcmt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","και αγορασασ σινδονα και καθελων αυτον ενειλησεν τη σινδονι και κατεθηκεν αυτον εν μνημειω ο ην λελατομημενον εκ πετρασ και προσεκυλισεν λιθον επι την θυραν του μνημειου ");
INSERT INTO grcmt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","η δε μαρια η μαγδαληνη και μαρια ιωση εθεωρουν που τιθεται ");
INSERT INTO grcmt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","και διαγενομενου του σαββατου μαρια η μαγδαληνη και μαρια ιακωβου και σαλωμη ηγορασαν αρωματα ινα ελθουσαι αλειψωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","και λιαν πρωι τησ μιασ σαββατων ερχονται επι το μνημειον ανατειλαντοσ του ηλιου ");
INSERT INTO grcmt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","και ελεγον προσ εαυτασ τισ αποκυλισει ημιν τον λιθον εκ τησ θυρασ του μνημειου ");
INSERT INTO grcmt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","και αναβλεψασαι θεωρουσιν οτι αποκεκυλισται ο λιθοσ ην γαρ μεγασ σφοδρα ");
INSERT INTO grcmt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","και εισελθουσαι εισ το μνημειον ειδον νεανισκον καθημενον εν τοισ δεξιοισ περιβεβλημενον στολην λευκην και εξεθαμβηθησαν ");
INSERT INTO grcmt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ο δε λεγει αυταισ μη εκθαμβεισθε ιησουν ζητειτε τον ναζαρηνον τον εσταυρωμενον ηγερθη ουκ εστιν ωδε ιδε ο τοποσ οπου εθηκαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","αλλ υπαγετε ειπατε τοισ μαθηταισ αυτου και τω πετρω οτι προαγει υμασ εισ την γαλιλαιαν εκει αυτον οψεσθε καθωσ ειπεν υμιν ");
INSERT INTO grcmt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","και εξελθουσαι εφυγον απο του μνημειου ειχεν δε αυτασ τρομοσ και εκστασισ και ουδενι ουδεν ειπον εφοβουντο γαρ ");
INSERT INTO grcmt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","αναστασ δε πρωι πρωτη σαββατου εφανη πρωτον μαρια τη μαγδαληνη αφ ησ εκβεβληκει επτα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","εκεινη πορευθεισα απηγγειλεν τοισ μετ αυτου γενομενοισ πενθουσιν και κλαιουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","κακεινοι ακουσαντεσ οτι ζη και εθεαθη υπ αυτησ ηπιστησαν ");
INSERT INTO grcmt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","μετα δε ταυτα δυσιν εξ αυτων περιπατουσιν εφανερωθη εν ετερα μορφη πορευομενοισ εισ αγρον ");
INSERT INTO grcmt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","κακεινοι απελθοντεσ απηγγειλαν τοισ λοιποισ ουδε εκεινοισ επιστευσαν ");
INSERT INTO grcmt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","υστερον ανακειμενοισ αυτοισ τοισ ενδεκα εφανερωθη και ωνειδισεν την απιστιαν αυτων και σκληροκαρδιαν οτι τοισ θεασαμενοισ αυτον εγηγερμενον ουκ επιστευσαν ");
INSERT INTO grcmt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","και ειπεν αυτοισ πορευθεντεσ εισ τον κοσμον απαντα κηρυξατε το ευαγγελιον παση τη κτισει ");
INSERT INTO grcmt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ο πιστευσασ και βαπτισθεισ σωθησεται ο δε απιστησασ κατακριθησεται ");
INSERT INTO grcmt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","σημεια δε τοισ πιστευσασιν ταυτα παρακολουθησει εν τω ονοματι μου δαιμονια εκβαλουσιν γλωσσαισ λαλησουσιν καιναισ ");
INSERT INTO grcmt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","οφεισ αρουσιν καν θανασιμον τι πιωσιν ου μη αυτουσ βλαψη επι αρρωστουσ χειρασ επιθησουσιν και καλωσ εξουσιν ");
INSERT INTO grcmt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ο μεν ουν κυριοσ μετα το λαλησαι αυτοισ ανεληφθη εισ τον ουρανον και εκαθισεν εκ δεξιων του θεου ");
INSERT INTO grcmt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","εκεινοι δε εξελθοντεσ εκηρυξαν πανταχου του κυριου συνεργουντοσ και τον λογον βεβαιουντοσ δια των επακολουθουντων σημειων αμην ");
INSERT INTO grcmt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","επειδηπερ πολλοι επεχειρησαν αναταξασθαι διηγησιν περι των πεπληροφορημενων εν ημιν πραγματων ");
INSERT INTO grcmt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","καθωσ παρεδοσαν ημιν οι απ αρχησ αυτοπται και υπηρεται γενομενοι του λογου ");
INSERT INTO grcmt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","εδοξεν καμοι παρηκολουθηκοτι ανωθεν πασιν ακριβωσ καθεξησ σοι γραψαι κρατιστε θεοφιλε ");
INSERT INTO grcmt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ινα επιγνωσ περι ων κατηχηθησ λογων την ασφαλειαν ");
INSERT INTO grcmt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","εγενετο εν ταισ ημεραισ ηρωδου του βασιλεωσ τησ ιουδαιασ ιερευσ τισ ονοματι ζαχαριασ εξ εφημεριασ αβια και η γυνη αυτου εκ των θυγατερων ααρων και το ονομα αυτησ ελισαβετ ");
INSERT INTO grcmt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ησαν δε δικαιοι αμφοτεροι ενωπιον του θεου πορευομενοι εν πασαισ ταισ εντολαισ και δικαιωμασιν του κυριου αμεμπτοι ");
INSERT INTO grcmt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","και ουκ ην αυτοισ τεκνον καθοτι η ελισαβετ ην στειρα και αμφοτεροι προβεβηκοτεσ εν ταισ ημεραισ αυτων ησαν ");
INSERT INTO grcmt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","εγενετο δε εν τω ιερατευειν αυτον εν τη ταξει τησ εφημεριασ αυτου εναντι του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","κατα το εθοσ τησ ιερατειασ ελαχεν του θυμιασαι εισελθων εισ τον ναον του κυριου ");
INSERT INTO grcmt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","και παν το πληθοσ ην του λαου προσευχομενον εξω τη ωρα του θυμιαματοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ωφθη δε αυτω αγγελοσ κυριου εστωσ εκ δεξιων του θυσιαστηριου του θυμιαματοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","και εταραχθη ζαχαριασ ιδων και φοβοσ επεπεσεν επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ειπεν δε προσ αυτον ο αγγελοσ μη φοβου ζαχαρια διοτι εισηκουσθη η δεησισ σου και η γυνη σου ελισαβετ γεννησει υιον σοι και καλεσεισ το ονομα αυτου ιωαννην ");
INSERT INTO grcmt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","και εσται χαρα σοι και αγαλλιασισ και πολλοι επι τη γεννησει αυτου χαρησονται ");
INSERT INTO grcmt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","εσται γαρ μεγασ ενωπιον του κυριου και οινον και σικερα ου μη πιη και πνευματοσ αγιου πλησθησεται ετι εκ κοιλιασ μητροσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","και πολλουσ των υιων ισραηλ επιστρεψει επι κυριον τον θεον αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","και αυτοσ προελευσεται ενωπιον αυτου εν πνευματι και δυναμει ηλιου επιστρεψαι καρδιασ πατερων επι τεκνα και απειθεισ εν φρονησει δικαιων ετοιμασαι κυριω λαον κατεσκευασμενον ");
INSERT INTO grcmt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","και ειπεν ζαχαριασ προσ τον αγγελον κατα τι γνωσομαι τουτο εγω γαρ ειμι πρεσβυτησ και η γυνη μου προβεβηκυια εν ταισ ημεραισ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","και αποκριθεισ ο αγγελοσ ειπεν αυτω εγω ειμι γαβριηλ ο παρεστηκωσ ενωπιον του θεου και απεσταλην λαλησαι προσ σε και ευαγγελισασθαι σοι ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","και ιδου εση σιωπων και μη δυναμενοσ λαλησαι αχρι ησ ημερασ γενηται ταυτα ανθ ων ουκ επιστευσασ τοισ λογοισ μου οιτινεσ πληρωθησονται εισ τον καιρον αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","και ην ο λαοσ προσδοκων τον ζαχαριαν και εθαυμαζον εν τω χρονιζειν αυτον εν τω ναω ");
INSERT INTO grcmt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","εξελθων δε ουκ ηδυνατο λαλησαι αυτοισ και επεγνωσαν οτι οπτασιαν εωρακεν εν τω ναω και αυτοσ ην διανευων αυτοισ και διεμενεν κωφοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","και εγενετο ωσ επλησθησαν αι ημεραι τησ λειτουργιασ αυτου απηλθεν εισ τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","μετα δε ταυτασ τασ ημερασ συνελαβεν ελισαβετ η γυνη αυτου και περιεκρυβεν εαυτην μηνασ πεντε λεγουσα ");
INSERT INTO grcmt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","οτι ουτωσ μοι πεποιηκεν ο κυριοσ εν ημεραισ αισ επειδεν αφελειν το ονειδοσ μου εν ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","εν δε τω μηνι τω εκτω απεσταλη ο αγγελοσ γαβριηλ υπο του θεου εισ πολιν τησ γαλιλαιασ η ονομα ναζαρετ ");
INSERT INTO grcmt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","προσ παρθενον μεμνηστευμενην ανδρι ω ονομα ιωσηφ εξ οικου δαυιδ και το ονομα τησ παρθενου μαριαμ ");
INSERT INTO grcmt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","και εισελθων ο αγγελοσ προσ αυτην ειπεν χαιρε κεχαριτωμενη ο κυριοσ μετα σου ευλογημενη συ εν γυναιξιν ");
INSERT INTO grcmt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","η δε ιδουσα διεταραχθη επι τω λογω αυτου και διελογιζετο ποταποσ ειη ο ασπασμοσ ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","και ειπεν ο αγγελοσ αυτη μη φοβου μαριαμ ευρεσ γαρ χαριν παρα τω θεω ");
INSERT INTO grcmt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","και ιδου συλληψη εν γαστρι και τεξη υιον και καλεσεισ το ονομα αυτου ιησουν ");
INSERT INTO grcmt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ουτοσ εσται μεγασ και υιοσ υψιστου κληθησεται και δωσει αυτω κυριοσ ο θεοσ τον θρονον δαυιδ του πατροσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","και βασιλευσει επι τον οικον ιακωβ εισ τουσ αιωνασ και τησ βασιλειασ αυτου ουκ εσται τελοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ειπεν δε μαριαμ προσ τον αγγελον πωσ εσται τουτο επει ανδρα ου γινωσκω ");
INSERT INTO grcmt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","και αποκριθεισ ο αγγελοσ ειπεν αυτη πνευμα αγιον επελευσεται επι σε και δυναμισ υψιστου επισκιασει σοι διο και το γεννωμενον αγιον κληθησεται υιοσ θεου ");
INSERT INTO grcmt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","και ιδου ελισαβετ η συγγενησ σου και αυτη συνειληφυια υιον εν γηρει αυτησ και ουτοσ μην εκτοσ εστιν αυτη τη καλουμενη στειρα ");
INSERT INTO grcmt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","οτι ουκ αδυνατησει παρα τω θεω παν ρημα ");
INSERT INTO grcmt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ειπεν δε μαριαμ ιδου η δουλη κυριου γενοιτο μοι κατα το ρημα σου και απηλθεν απ αυτησ ο αγγελοσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","αναστασα δε μαριαμ εν ταισ ημεραισ ταυταισ επορευθη εισ την ορεινην μετα σπουδησ εισ πολιν ιουδα ");
INSERT INTO grcmt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","και εισηλθεν εισ τον οικον ζαχαριου και ησπασατο την ελισαβετ ");
INSERT INTO grcmt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","και εγενετο ωσ ηκουσεν η ελισαβετ τον ασπασμον τησ μαριασ εσκιρτησεν το βρεφοσ εν τη κοιλια αυτησ και επλησθη πνευματοσ αγιου η ελισαβετ ");
INSERT INTO grcmt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","και ανεφωνησεν φωνη μεγαλη και ειπεν ευλογημενη συ εν γυναιξιν και ευλογημενοσ ο καρποσ τησ κοιλιασ σου ");
INSERT INTO grcmt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","και ποθεν μοι τουτο ινα ελθη η μητηρ του κυριου μου προσ με ");
INSERT INTO grcmt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ιδου γαρ ωσ εγενετο η φωνη του ασπασμου σου εισ τα ωτα μου εσκιρτησεν το βρεφοσ εν αγαλλιασει εν τη κοιλια μου ");
INSERT INTO grcmt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","και μακαρια η πιστευσασα οτι εσται τελειωσισ τοισ λελαλημενοισ αυτη παρα κυριου ");
INSERT INTO grcmt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","και ειπεν μαριαμ μεγαλυνει η ψυχη μου τον κυριον ");
INSERT INTO grcmt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","και ηγαλλιασεν το πνευμα μου επι τω θεω τω σωτηρι μου ");
INSERT INTO grcmt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","οτι επεβλεψεν επι την ταπεινωσιν τησ δουλησ αυτου ιδου γαρ απο του νυν μακαριουσιν με πασαι αι γενεαι ");
INSERT INTO grcmt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","οτι εποιησεν μοι μεγαλεια ο δυνατοσ και αγιον το ονομα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","και το ελεοσ αυτου εισ γενεασ γενεων τοισ φοβουμενοισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","εποιησεν κρατοσ εν βραχιονι αυτου διεσκορπισεν υπερηφανουσ διανοια καρδιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","καθειλεν δυναστασ απο θρονων και υψωσεν ταπεινουσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","πεινωντασ ενεπλησεν αγαθων και πλουτουντασ εξαπεστειλεν κενουσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","αντελαβετο ισραηλ παιδοσ αυτου μνησθηναι ελεουσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","καθωσ ελαλησεν προσ τουσ πατερασ ημων τω αβρααμ και τω σπερματι αυτου εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","εμεινεν δε μαριαμ συν αυτη ωσει μηνασ τρεισ και υπεστρεψεν εισ τον οικον αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","τη δε ελισαβετ επλησθη ο χρονοσ του τεκειν αυτην και εγεννησεν υιον ");
INSERT INTO grcmt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","και ηκουσαν οι περιοικοι και οι συγγενεισ αυτησ οτι εμεγαλυνεν κυριοσ το ελεοσ αυτου μετ αυτησ και συνεχαιρον αυτη ");
INSERT INTO grcmt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","και εγενετο εν τη ογδοη ημερα ηλθον περιτεμειν το παιδιον και εκαλουν αυτο επι τω ονοματι του πατροσ αυτου ζαχαριαν ");
INSERT INTO grcmt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","και αποκριθεισα η μητηρ αυτου ειπεν ουχι αλλα κληθησεται ιωαννησ ");
INSERT INTO grcmt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","και ειπον προσ αυτην οτι ουδεισ εστιν εν τη συγγενεια σου οσ καλειται τω ονοματι τουτω ");
INSERT INTO grcmt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ενενευον δε τω πατρι αυτου το τι αν θελοι καλεισθαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","και αιτησασ πινακιδιον εγραψεν λεγων ιωαννησ εστιν το ονομα αυτου και εθαυμασαν παντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ανεωχθη δε το στομα αυτου παραχρημα και η γλωσσα αυτου και ελαλει ευλογων τον θεον ");
INSERT INTO grcmt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","και εγενετο επι παντασ φοβοσ τουσ περιοικουντασ αυτουσ και εν ολη τη ορεινη τησ ιουδαιασ διελαλειτο παντα τα ρηματα ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","και εθεντο παντεσ οι ακουσαντεσ εν τη καρδια αυτων λεγοντεσ τι αρα το παιδιον τουτο εσται και χειρ κυριου ην μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","και ζαχαριασ ο πατηρ αυτου επλησθη πνευματοσ αγιου και προεφητευσεν λεγων ");
INSERT INTO grcmt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ευλογητοσ κυριοσ ο θεοσ του ισραηλ οτι επεσκεψατο και εποιησεν λυτρωσιν τω λαω αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","και ηγειρεν κερασ σωτηριασ ημιν εν τω οικω δαυιδ του παιδοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","καθωσ ελαλησεν δια στοματοσ των αγιων των απ αιωνοσ προφητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","σωτηριαν εξ εχθρων ημων και εκ χειροσ παντων των μισουντων ημασ ");
INSERT INTO grcmt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ποιησαι ελεοσ μετα των πατερων ημων και μνησθηναι διαθηκησ αγιασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ορκον ον ωμοσεν προσ αβρααμ τον πατερα ημων του δουναι ημιν ");
INSERT INTO grcmt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","αφοβωσ εκ χειροσ των εχθρων ημων ρυσθεντασ λατρευειν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","εν οσιοτητι και δικαιοσυνη ενωπιον αυτου πασασ τασ ημερασ τησ ζωησ ημων ");
INSERT INTO grcmt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","και συ παιδιον προφητησ υψιστου κληθηση προπορευση γαρ προ προσωπου κυριου ετοιμασαι οδουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","του δουναι γνωσιν σωτηριασ τω λαω αυτου εν αφεσει αμαρτιων αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","δια σπλαγχνα ελεουσ θεου ημων εν οισ επεσκεψατο ημασ ανατολη εξ υψουσ ");
INSERT INTO grcmt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","επιφαναι τοισ εν σκοτει και σκια θανατου καθημενοισ του κατευθυναι τουσ ποδασ ημων εισ οδον ειρηνησ ");
INSERT INTO grcmt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","το δε παιδιον ηυξανεν και εκραταιουτο πνευματι και ην εν ταισ ερημοισ εωσ ημερασ αναδειξεωσ αυτου προσ τον ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","εγενετο δε εν ταισ ημεραισ εκειναισ εξηλθεν δογμα παρα καισαροσ αυγουστου απογραφεσθαι πασαν την οικουμενην ");
INSERT INTO grcmt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","αυτη η απογραφη πρωτη εγενετο ηγεμονευοντοσ τησ συριασ κυρηνιου ");
INSERT INTO grcmt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","και επορευοντο παντεσ απογραφεσθαι εκαστοσ εισ την ιδιαν πολιν ");
INSERT INTO grcmt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ανεβη δε και ιωσηφ απο τησ γαλιλαιασ εκ πολεωσ ναζαρετ εισ την ιουδαιαν εισ πολιν δαυιδ ητισ καλειται βηθλεεμ δια το ειναι αυτον εξ οικου και πατριασ δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","απογραψασθαι συν μαριαμ τη μεμνηστευμενη αυτω γυναικι ουση εγκυω ");
INSERT INTO grcmt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","εγενετο δε εν τω ειναι αυτουσ εκει επλησθησαν αι ημεραι του τεκειν αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","και ετεκεν τον υιον αυτησ τον πρωτοτοκον και εσπαργανωσεν αυτον και ανεκλινεν αυτον εν τη φατνη διοτι ουκ ην αυτοισ τοποσ εν τω καταλυματι ");
INSERT INTO grcmt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","και ποιμενεσ ησαν εν τη χωρα τη αυτη αγραυλουντεσ και φυλασσοντεσ φυλακασ τησ νυκτοσ επι την ποιμνην αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","και ιδου αγγελοσ κυριου επεστη αυτοισ και δοξα κυριου περιελαμψεν αυτουσ και εφοβηθησαν φοβον μεγαν ");
INSERT INTO grcmt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","και ειπεν αυτοισ ο αγγελοσ μη φοβεισθε ιδου γαρ ευαγγελιζομαι υμιν χαραν μεγαλην ητισ εσται παντι τω λαω ");
INSERT INTO grcmt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","οτι ετεχθη υμιν σημερον σωτηρ οσ εστιν χριστοσ κυριοσ εν πολει δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","και τουτο υμιν το σημειον ευρησετε βρεφοσ εσπαργανωμενον κειμενον εν φατνη ");
INSERT INTO grcmt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","και εξαιφνησ εγενετο συν τω αγγελω πληθοσ στρατιασ ουρανιου αινουντων τον θεον και λεγοντων ");
INSERT INTO grcmt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","δοξα εν υψιστοισ θεω και επι γησ ειρηνη εν ανθρωποισ ευδοκια ");
INSERT INTO grcmt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","και εγενετο ωσ απηλθον απ αυτων εισ τον ουρανον οι αγγελοι και οι ανθρωποι οι ποιμενεσ ειπον προσ αλληλουσ διελθωμεν δη εωσ βηθλεεμ και ιδωμεν το ρημα τουτο το γεγονοσ ο ο κυριοσ εγνωρισεν ημιν ");
INSERT INTO grcmt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","και ηλθον σπευσαντεσ και ανευρον την τε μαριαμ και τον ιωσηφ και το βρεφοσ κειμενον εν τη φατνη ");
INSERT INTO grcmt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ιδοντεσ δε διεγνωρισαν περι του ρηματοσ του λαληθεντοσ αυτοισ περι του παιδιου τουτου ");
INSERT INTO grcmt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","και παντεσ οι ακουσαντεσ εθαυμασαν περι των λαληθεντων υπο των ποιμενων προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","η δε μαριαμ παντα συνετηρει τα ρηματα ταυτα συμβαλλουσα εν τη καρδια αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","και υπεστρεψαν οι ποιμενεσ δοξαζοντεσ και αινουντεσ τον θεον επι πασιν οισ ηκουσαν και ειδον καθωσ ελαληθη προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","και οτε επλησθησαν ημεραι οκτω του περιτεμειν αυτον και εκληθη το ονομα αυτου ιησουσ το κληθεν υπο του αγγελου προ του συλληφθηναι αυτον εν τη κοιλια ");
INSERT INTO grcmt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","και οτε επλησθησαν αι ημεραι του καθαρισμου αυτων κατα τον νομον μωσεωσ ανηγαγον αυτον εισ ιεροσολυμα παραστησαι τω κυριω ");
INSERT INTO grcmt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","καθωσ γεγραπται εν νομω κυριου οτι παν αρσεν διανοιγον μητραν αγιον τω κυριω κληθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","και του δουναι θυσιαν κατα το ειρημενον εν νομω κυριου ζευγοσ τρυγονων η δυο νεοσσουσ περιστερων ");
INSERT INTO grcmt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","και ιδου ην ανθρωποσ εν ιερουσαλημ ω ονομα συμεων και ο ανθρωποσ ουτοσ δικαιοσ και ευλαβησ προσδεχομενοσ παρακλησιν του ισραηλ και πνευμα ην αγιον επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","και ην αυτω κεχρηματισμενον υπο του πνευματοσ του αγιου μη ιδειν θανατον πριν η ιδη τον χριστον κυριου ");
INSERT INTO grcmt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","και ηλθεν εν τω πνευματι εισ το ιερον και εν τω εισαγαγειν τουσ γονεισ το παιδιον ιησουν του ποιησαι αυτουσ κατα το ειθισμενον του νομου περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","και αυτοσ εδεξατο αυτο εισ τασ αγκαλασ αυτου και ευλογησεν τον θεον και ειπεν ");
INSERT INTO grcmt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","νυν απολυεισ τον δουλον σου δεσποτα κατα το ρημα σου εν ειρηνη ");
INSERT INTO grcmt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","οτι ειδον οι οφθαλμοι μου το σωτηριον σου ");
INSERT INTO grcmt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ο ητοιμασασ κατα προσωπον παντων των λαων ");
INSERT INTO grcmt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","φωσ εισ αποκαλυψιν εθνων και δοξαν λαου σου ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","και ην ιωσηφ και η μητηρ αυτου θαυμαζοντεσ επι τοισ λαλουμενοισ περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","και ευλογησεν αυτουσ συμεων και ειπεν προσ μαριαμ την μητερα αυτου ιδου ουτοσ κειται εισ πτωσιν και αναστασιν πολλων εν τω ισραηλ και εισ σημειον αντιλεγομενον ");
INSERT INTO grcmt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","και σου δε αυτησ την ψυχην διελευσεται ρομφαια οπωσ αν αποκαλυφθωσιν εκ πολλων καρδιων διαλογισμοι ");
INSERT INTO grcmt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","και ην αννα προφητισ θυγατηρ φανουηλ εκ φυλησ ασηρ αυτη προβεβηκυια εν ημεραισ πολλαισ ζησασα ετη μετα ανδροσ επτα απο τησ παρθενιασ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","και αυτη χηρα ωσ ετων ογδοηκοντα τεσσαρων η ουκ αφιστατο απο του ιερου νηστειαισ και δεησεσιν λατρευουσα νυκτα και ημεραν ");
INSERT INTO grcmt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","και αυτη αυτη τη ωρα επιστασα ανθωμολογειτο τω κυριω και ελαλει περι αυτου πασιν τοισ προσδεχομενοισ λυτρωσιν εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","και ωσ ετελεσαν απαντα τα κατα τον νομον κυριου υπεστρεψαν εισ την γαλιλαιαν εισ την πολιν εαυτων ναζαρετ ");
INSERT INTO grcmt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","το δε παιδιον ηυξανεν και εκραταιουτο πνευματι πληρουμενον σοφιασ και χαρισ θεου ην επ αυτο ");
INSERT INTO grcmt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","και επορευοντο οι γονεισ αυτου κατ ετοσ εισ ιερουσαλημ τη εορτη του πασχα ");
INSERT INTO grcmt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","και οτε εγενετο ετων δωδεκα αναβαντων αυτων εισ ιεροσολυμα κατα το εθοσ τησ εορτησ ");
INSERT INTO grcmt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","και τελειωσαντων τασ ημερασ εν τω υποστρεφειν αυτουσ υπεμεινεν ιησουσ ο παισ εν ιερουσαλημ και ουκ εγνω ιωσηφ και η μητηρ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","νομισαντεσ δε αυτον εν τη συνοδια ειναι ηλθον ημερασ οδον και ανεζητουν αυτον εν τοισ συγγενεσιν και εν τοισ γνωστοισ ");
INSERT INTO grcmt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","και μη ευροντεσ αυτον υπεστρεψαν εισ ιερουσαλημ ζητουντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","και εγενετο μεθ ημερασ τρεισ ευρον αυτον εν τω ιερω καθεζομενον εν μεσω των διδασκαλων και ακουοντα αυτων και επερωτωντα αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","εξισταντο δε παντεσ οι ακουοντεσ αυτου επι τη συνεσει και ταισ αποκρισεσιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","και ιδοντεσ αυτον εξεπλαγησαν και προσ αυτον η μητηρ αυτου ειπεν τεκνον τι εποιησασ ημιν ουτωσ ιδου ο πατηρ σου καγω οδυνωμενοι εζητουμεν σε ");
INSERT INTO grcmt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","και ειπεν προσ αυτουσ τι οτι εζητειτε με ουκ ηδειτε οτι εν τοισ του πατροσ μου δει ειναι με ");
INSERT INTO grcmt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","και αυτοι ου συνηκαν το ρημα ο ελαλησεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","και κατεβη μετ αυτων και ηλθεν εισ ναζαρετ και ην υποτασσομενοσ αυτοισ και η μητηρ αυτου διετηρει παντα τα ρηματα ταυτα εν τη καρδια αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","και ιησουσ προεκοπτεν σοφια και ηλικια και χαριτι παρα θεω και ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","εν ετει δε πεντεκαιδεκατω τησ ηγεμονιασ τιβεριου καισαροσ ηγεμονευοντοσ ποντιου πιλατου τησ ιουδαιασ και τετραρχουντοσ τησ γαλιλαιασ ηρωδου φιλιππου δε του αδελφου αυτου τετραρχουντοσ τησ ιτουραιασ και τραχωνιτιδοσ χωρασ και λυσανιου τησ αβιληνησ τετραρχουντοσ ");
INSERT INTO grcmt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","επι αρχιερεωσ αννα και καιαφα εγενετο ρημα θεου επι ιωαννην τον ζαχαριου υιον εν τη ερημω ");
INSERT INTO grcmt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","και ηλθεν εισ πασαν την περιχωρον του ιορδανου κηρυσσων βαπτισμα μετανοιασ εισ αφεσιν αμαρτιων ");
INSERT INTO grcmt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ωσ γεγραπται εν βιβλω λογων ησαιου του προφητου λεγοντοσ φωνη βοωντοσ εν τη ερημω ετοιμασατε την οδον κυριου ευθειασ ποιειτε τασ τριβουσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","πασα φαραγξ πληρωθησεται και παν οροσ και βουνοσ ταπεινωθησεται και εσται τα σκολια εισ ευθειαν και αι τραχειαι εισ οδουσ λειασ ");
INSERT INTO grcmt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","και οψεται πασα σαρξ το σωτηριον του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ελεγεν ουν τοισ εκπορευομενοισ οχλοισ βαπτισθηναι υπ αυτου γεννηματα εχιδνων τισ υπεδειξεν υμιν φυγειν απο τησ μελλουσησ οργησ ");
INSERT INTO grcmt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ποιησατε ουν καρπουσ αξιουσ τησ μετανοιασ και μη αρξησθε λεγειν εν εαυτοισ πατερα εχομεν τον αβρααμ λεγω γαρ υμιν οτι δυναται ο θεοσ εκ των λιθων τουτων εγειραι τεκνα τω αβρααμ ");
INSERT INTO grcmt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ηδη δε και η αξινη προσ την ριζαν των δενδρων κειται παν ουν δενδρον μη ποιουν καρπον καλον εκκοπτεται και εισ πυρ βαλλεται ");
INSERT INTO grcmt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","και επηρωτων αυτον οι οχλοι λεγοντεσ τι ουν ποιησομεν ");
INSERT INTO grcmt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","αποκριθεισ δε λεγει αυτοισ ο εχων δυο χιτωνασ μεταδοτω τω μη εχοντι και ο εχων βρωματα ομοιωσ ποιειτω ");
INSERT INTO grcmt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ηλθον δε και τελωναι βαπτισθηναι και ειπον προσ αυτον διδασκαλε τι ποιησομεν ");
INSERT INTO grcmt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ο δε ειπεν προσ αυτουσ μηδεν πλεον παρα το διατεταγμενον υμιν πρασσετε ");
INSERT INTO grcmt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","επηρωτων δε αυτον και στρατευομενοι λεγοντεσ και ημεισ τι ποιησομεν και ειπεν προσ αυτουσ μηδενα διασεισητε μηδε συκοφαντησητε και αρκεισθε τοισ οψωνιοισ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","προσδοκωντοσ δε του λαου και διαλογιζομενων παντων εν ταισ καρδιαισ αυτων περι του ιωαννου μηποτε αυτοσ ειη ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","απεκρινατο ο ιωαννησ απασιν λεγων εγω μεν υδατι βαπτιζω υμασ ερχεται δε ο ισχυροτεροσ μου ου ουκ ειμι ικανοσ λυσαι τον ιμαντα των υποδηματων αυτου αυτοσ υμασ βαπτισει εν πνευματι αγιω και πυρι ");
INSERT INTO grcmt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ου το πτυον εν τη χειρι αυτου και διακαθαριει την αλωνα αυτου και συναξει τον σιτον εισ την αποθηκην αυτου το δε αχυρον κατακαυσει πυρι ασβεστω ");
INSERT INTO grcmt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","πολλα μεν ουν και ετερα παρακαλων ευηγγελιζετο τον λαον ");
INSERT INTO grcmt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ο δε ηρωδησ ο τετραρχησ ελεγχομενοσ υπ αυτου περι ηρωδιαδοσ τησ γυναικοσ του αδελφου αυτου και περι παντων ων εποιησεν πονηρων ο ηρωδησ ");
INSERT INTO grcmt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","προσεθηκεν και τουτο επι πασιν και κατεκλεισεν τον ιωαννην εν τη φυλακη ");
INSERT INTO grcmt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","εγενετο δε εν τω βαπτισθηναι απαντα τον λαον και ιησου βαπτισθεντοσ και προσευχομενου ανεωχθηναι τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","και καταβηναι το πνευμα το αγιον σωματικω ειδει ωσει περιστεραν επ αυτον και φωνην εξ ουρανου γενεσθαι λεγουσαν συ ει ο υιοσ μου ο αγαπητοσ εν σοι ευδοκησα ");
INSERT INTO grcmt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","και αυτοσ ην ο ιησουσ ωσει ετων τριακοντα αρχομενοσ ων ωσ ενομιζετο υιοσ ιωσηφ του ηλι ");
INSERT INTO grcmt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","του ματθατ του λευι του μελχι του ιαννα του ιωσηφ ");
INSERT INTO grcmt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","του ματταθιου του αμωσ του ναουμ του εσλι του ναγγαι ");
INSERT INTO grcmt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","του μααθ του ματταθιου του σεμει του ιωσηφ του ιουδα ");
INSERT INTO grcmt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","του ιωαναν του ρησα του ζοροβαβελ του σαλαθιηλ του νηρι ");
INSERT INTO grcmt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","του μελχι του αδδι του κωσαμ του ελμωδαμ του ηρ ");
INSERT INTO grcmt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","του ιωση του ελιεζερ του ιωρειμ του ματθατ του λευι ");
INSERT INTO grcmt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","του συμεων του ιουδα του ιωσηφ του ιωναν του ελιακειμ ");
INSERT INTO grcmt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","του μελεα του μαιναν του ματταθα του ναθαν του δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","του ιεσσαι του ωβηδ του βοοζ του σαλμων του ναασσων ");
INSERT INTO grcmt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","του αμιναδαβ του αραμ του εσρωμ του φαρεσ του ιουδα ");
INSERT INTO grcmt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","του ιακωβ του ισαακ του αβρααμ του θαρα του ναχωρ ");
INSERT INTO grcmt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","του σερουχ του ραγαυ του φαλεγ του εβερ του σαλα ");
INSERT INTO grcmt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","του καιναν του αρφαξαδ του σημ του νωε του λαμεχ ");
INSERT INTO grcmt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","του μαθουσαλα του ενωχ του ιαρεδ του μαλελεηλ του καιναν ");
INSERT INTO grcmt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","του ενωσ του σηθ του αδαμ του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ιησουσ δε πνευματοσ αγιου πληρησ υπεστρεψεν απο του ιορδανου και ηγετο εν τω πνευματι εισ την ερημον ");
INSERT INTO grcmt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ημερασ τεσσαρακοντα πειραζομενοσ υπο του διαβολου και ουκ εφαγεν ουδεν εν ταισ ημεραισ εκειναισ και συντελεσθεισων αυτων υστερον επεινασεν ");
INSERT INTO grcmt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","και ειπεν αυτω ο διαβολοσ ει υιοσ ει του θεου ειπε τω λιθω τουτω ινα γενηται αρτοσ ");
INSERT INTO grcmt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","και απεκριθη ιησουσ προσ αυτον λεγων γεγραπται οτι ουκ επ αρτω μονω ζησεται ανθρωποσ αλλ επι παντι ρηματι θεου ");
INSERT INTO grcmt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","και αναγαγων αυτον ο διαβολοσ εισ οροσ υψηλον εδειξεν αυτω πασασ τασ βασιλειασ τησ οικουμενησ εν στιγμη χρονου ");
INSERT INTO grcmt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","και ειπεν αυτω ο διαβολοσ σοι δωσω την εξουσιαν ταυτην απασαν και την δοξαν αυτων οτι εμοι παραδεδοται και ω εαν θελω διδωμι αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","συ ουν εαν προσκυνησησ ενωπιον εμου εσται σου πασα ");
INSERT INTO grcmt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","και αποκριθεισ αυτω ειπεν ο ιησουσ υπαγε οπισω μου σατανα γεγραπται προσκυνησεισ κυριον τον θεον σου και αυτω μονω λατρευσεισ ");
INSERT INTO grcmt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","και ηγαγεν αυτον εισ ιερουσαλημ και εστησεν αυτον επι το πτερυγιον του ιερου και ειπεν αυτω ει υιοσ ει του θεου βαλε σεαυτον εντευθεν κατω ");
INSERT INTO grcmt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","γεγραπται γαρ οτι τοισ αγγελοισ αυτου εντελειται περι σου του διαφυλαξαι σε ");
INSERT INTO grcmt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","και επι χειρων αρουσιν σε μηποτε προσκοψησ προσ λιθον τον ποδα σου ");
INSERT INTO grcmt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","και αποκριθεισ ειπεν αυτω ο ιησουσ οτι ειρηται ουκ εκπειρασεισ κυριον τον θεον σου ");
INSERT INTO grcmt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","και συντελεσασ παντα πειρασμον ο διαβολοσ απεστη απ αυτου αχρι καιρου ");
INSERT INTO grcmt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","και υπεστρεψεν ο ιησουσ εν τη δυναμει του πνευματοσ εισ την γαλιλαιαν και φημη εξηλθεν καθ ολησ τησ περιχωρου περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","και αυτοσ εδιδασκεν εν ταισ συναγωγαισ αυτων δοξαζομενοσ υπο παντων ");
INSERT INTO grcmt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","και ηλθεν εισ την ναζαρετ ου ην τεθραμμενοσ και εισηλθεν κατα το ειωθοσ αυτω εν τη ημερα των σαββατων εισ την συναγωγην και ανεστη αναγνωναι ");
INSERT INTO grcmt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","και επεδοθη αυτω βιβλιον ησαιου του προφητου και αναπτυξασ το βιβλιον ευρεν τον τοπον ου ην γεγραμμενον ");
INSERT INTO grcmt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","πνευμα κυριου επ εμε ου εινεκεν εχρισεν με ευαγγελισασθαι πτωχοισ απεσταλκεν με ιασασθαι τουσ συντετριμμενουσ την καρδιαν κηρυξαι αιχμαλωτοισ αφεσιν και τυφλοισ αναβλεψιν αποστειλαι τεθραυσμενουσ εν αφεσει ");
INSERT INTO grcmt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","κηρυξαι ενιαυτον κυριου δεκτον ");
INSERT INTO grcmt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","και πτυξασ το βιβλιον αποδουσ τω υπηρετη εκαθισεν και παντων εν τη συναγωγη οι οφθαλμοι ησαν ατενιζοντεσ αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ηρξατο δε λεγειν προσ αυτουσ οτι σημερον πεπληρωται η γραφη αυτη εν τοισ ωσιν υμων ");
INSERT INTO grcmt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","και παντεσ εμαρτυρουν αυτω και εθαυμαζον επι τοισ λογοισ τησ χαριτοσ τοισ εκπορευομενοισ εκ του στοματοσ αυτου και ελεγον ουχ ουτοσ εστιν ο υιοσ ιωσηφ ");
INSERT INTO grcmt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","και ειπεν προσ αυτουσ παντωσ ερειτε μοι την παραβολην ταυτην ιατρε θεραπευσον σεαυτον οσα ηκουσαμεν γενομενα εν τη καπερναουμ ποιησον και ωδε εν τη πατριδι σου ");
INSERT INTO grcmt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ειπεν δε αμην λεγω υμιν οτι ουδεισ προφητησ δεκτοσ εστιν εν τη πατριδι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","επ αληθειασ δε λεγω υμιν πολλαι χηραι ησαν εν ταισ ημεραισ ηλιου εν τω ισραηλ οτε εκλεισθη ο ουρανοσ επι ετη τρια και μηνασ εξ ωσ εγενετο λιμοσ μεγασ επι πασαν την γην ");
INSERT INTO grcmt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","και προσ ουδεμιαν αυτων επεμφθη ηλιασ ει μη εισ σαρεπτα τησ σιδωνοσ προσ γυναικα χηραν ");
INSERT INTO grcmt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","και πολλοι λεπροι ησαν επι ελισσαιου του προφητου εν τω ισραηλ και ουδεισ αυτων εκαθαρισθη ει μη νεεμαν ο συροσ ");
INSERT INTO grcmt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","και επλησθησαν παντεσ θυμου εν τη συναγωγη ακουοντεσ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","και ανασταντεσ εξεβαλον αυτον εξω τησ πολεωσ και ηγαγον αυτον εωσ οφρυοσ του ορουσ εφ ου η πολισ αυτων ωκοδομητο εισ το κατακρημνισαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","αυτοσ δε διελθων δια μεσου αυτων επορευετο ");
INSERT INTO grcmt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","και κατηλθεν εισ καπερναουμ πολιν τησ γαλιλαιασ και ην διδασκων αυτουσ εν τοισ σαββασιν ");
INSERT INTO grcmt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","και εξεπλησσοντο επι τη διδαχη αυτου οτι εν εξουσια ην ο λογοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","και εν τη συναγωγη ην ανθρωποσ εχων πνευμα δαιμονιου ακαθαρτου και ανεκραξεν φωνη μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","λεγων εα τι ημιν και σοι ιησου ναζαρηνε ηλθεσ απολεσαι ημασ οιδα σε τισ ει ο αγιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","και επετιμησεν αυτω ο ιησουσ λεγων φιμωθητι και εξελθε εξ αυτου και ριψαν αυτον το δαιμονιον εισ μεσον εξηλθεν απ αυτου μηδεν βλαψαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","και εγενετο θαμβοσ επι παντασ και συνελαλουν προσ αλληλουσ λεγοντεσ τισ ο λογοσ ουτοσ οτι εν εξουσια και δυναμει επιτασσει τοισ ακαθαρτοισ πνευμασιν και εξερχονται ");
INSERT INTO grcmt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","και εξεπορευετο ηχοσ περι αυτου εισ παντα τοπον τησ περιχωρου ");
INSERT INTO grcmt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","αναστασ δε εκ τησ συναγωγησ εισηλθεν εισ την οικιαν σιμωνοσ πενθερα δε του σιμωνοσ ην συνεχομενη πυρετω μεγαλω και ηρωτησαν αυτον περι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","και επιστασ επανω αυτησ επετιμησεν τω πυρετω και αφηκεν αυτην παραχρημα δε αναστασα διηκονει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","δυνοντοσ δε του ηλιου παντεσ οσοι ειχον ασθενουντασ νοσοισ ποικιλαισ ηγαγον αυτουσ προσ αυτον ο δε ενι εκαστω αυτων τασ χειρασ επιθεισ εθεραπευσεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","εξηρχετο δε και δαιμονια απο πολλων κραζοντα και λεγοντα οτι συ ει ο χριστοσ ο υιοσ του θεου και επιτιμων ουκ εια αυτα λαλειν οτι ηδεισαν τον χριστον αυτον ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","γενομενησ δε ημερασ εξελθων επορευθη εισ ερημον τοπον και οι οχλοι επεζητουν αυτον και ηλθον εωσ αυτου και κατειχον αυτον του μη πορευεσθαι απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ο δε ειπεν προσ αυτουσ οτι και ταισ ετεραισ πολεσιν ευαγγελισασθαι με δει την βασιλειαν του θεου οτι εισ τουτο απεσταλμαι ");
INSERT INTO grcmt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","και ην κηρυσσων εν ταισ συναγωγαισ τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","εγενετο δε εν τω τον οχλον επικεισθαι αυτω του ακουειν τον λογον του θεου και αυτοσ ην εστωσ παρα την λιμνην γεννησαρετ ");
INSERT INTO grcmt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","και ειδεν δυο πλοια εστωτα παρα την λιμνην οι δε αλιεισ αποβαντεσ απ αυτων απεπλυναν τα δικτυα ");
INSERT INTO grcmt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","εμβασ δε εισ εν των πλοιων ο ην του σιμωνοσ ηρωτησεν αυτον απο τησ γησ επαναγαγειν ολιγον και καθισασ εδιδασκεν εκ του πλοιου τουσ οχλουσ ");
INSERT INTO grcmt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ωσ δε επαυσατο λαλων ειπεν προσ τον σιμωνα επαναγαγε εισ το βαθοσ και χαλασατε τα δικτυα υμων εισ αγραν ");
INSERT INTO grcmt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","και αποκριθεισ ο σιμων ειπεν αυτω επιστατα δι ολησ τησ νυκτοσ κοπιασαντεσ ουδεν ελαβομεν επι δε τω ρηματι σου χαλασω το δικτυον ");
INSERT INTO grcmt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","και τουτο ποιησαντεσ συνεκλεισαν πληθοσ ιχθυων πολυ διερρηγνυτο δε το δικτυον αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","και κατενευσαν τοισ μετοχοισ τοισ εν τω ετερω πλοιω του ελθοντασ συλλαβεσθαι αυτοισ και ηλθον και επλησαν αμφοτερα τα πλοια ωστε βυθιζεσθαι αυτα ");
INSERT INTO grcmt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ιδων δε σιμων πετροσ προσεπεσεν τοισ γονασιν ιησου λεγων εξελθε απ εμου οτι ανηρ αμαρτωλοσ ειμι κυριε ");
INSERT INTO grcmt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","θαμβοσ γαρ περιεσχεν αυτον και παντασ τουσ συν αυτω επι τη αγρα των ιχθυων η συνελαβον ");
INSERT INTO grcmt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ομοιωσ δε και ιακωβον και ιωαννην υιουσ ζεβεδαιου οι ησαν κοινωνοι τω σιμωνι και ειπεν προσ τον σιμωνα ο ιησουσ μη φοβου απο του νυν ανθρωπουσ εση ζωγρων ");
INSERT INTO grcmt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","και καταγαγοντεσ τα πλοια επι την γην αφεντεσ απαντα ηκολουθησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","και εγενετο εν τω ειναι αυτον εν μια των πολεων και ιδου ανηρ πληρησ λεπρασ και ιδων τον ιησουν πεσων επι προσωπον εδεηθη αυτου λεγων κυριε εαν θελησ δυνασαι με καθαρισαι ");
INSERT INTO grcmt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","και εκτεινασ την χειρα ηψατο αυτου ειπων θελω καθαρισθητι και ευθεωσ η λεπρα απηλθεν απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","και αυτοσ παρηγγειλεν αυτω μηδενι ειπειν αλλα απελθων δειξον σεαυτον τω ιερει και προσενεγκε περι του καθαρισμου σου καθωσ προσεταξεν μωσησ εισ μαρτυριον αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","διηρχετο δε μαλλον ο λογοσ περι αυτου και συνηρχοντο οχλοι πολλοι ακουειν και θεραπευεσθαι υπ αυτου απο των ασθενειων αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","αυτοσ δε ην υποχωρων εν ταισ ερημοισ και προσευχομενοσ ");
INSERT INTO grcmt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","και εγενετο εν μια των ημερων και αυτοσ ην διδασκων και ησαν καθημενοι φαρισαιοι και νομοδιδασκαλοι οι ησαν εληλυθοτεσ εκ πασησ κωμησ τησ γαλιλαιασ και ιουδαιασ και ιερουσαλημ και δυναμισ κυριου ην εισ το ιασθαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","και ιδου ανδρεσ φεροντεσ επι κλινησ ανθρωπον οσ ην παραλελυμενοσ και εζητουν αυτον εισενεγκειν και θειναι ενωπιον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","και μη ευροντεσ ποιασ εισενεγκωσιν αυτον δια τον οχλον αναβαντεσ επι το δωμα δια των κεραμων καθηκαν αυτον συν τω κλινιδιω εισ το μεσον εμπροσθεν του ιησου ");
INSERT INTO grcmt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","και ιδων την πιστιν αυτων ειπεν αυτω ανθρωπε αφεωνται σοι αι αμαρτιαι σου ");
INSERT INTO grcmt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","και ηρξαντο διαλογιζεσθαι οι γραμματεισ και οι φαρισαιοι λεγοντεσ τισ εστιν ουτοσ οσ λαλει βλασφημιασ τισ δυναται αφιεναι αμαρτιασ ει μη μονοσ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","επιγνουσ δε ο ιησουσ τουσ διαλογισμουσ αυτων αποκριθεισ ειπεν προσ αυτουσ τι διαλογιζεσθε εν ταισ καρδιαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","τι εστιν ευκοπωτερον ειπειν αφεωνται σοι αι αμαρτιαι σου η ειπειν εγειραι και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ινα δε ειδητε οτι εξουσιαν εχει ο υιοσ του ανθρωπου επι τησ γησ αφιεναι αμαρτιασ ειπεν τω παραλελυμενω σοι λεγω εγειραι και αρασ το κλινιδιον σου πορευου εισ τον οικον σου ");
INSERT INTO grcmt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","και παραχρημα αναστασ ενωπιον αυτων αρασ εφ ο κατεκειτο απηλθεν εισ τον οικον αυτου δοξαζων τον θεον ");
INSERT INTO grcmt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","και εκστασισ ελαβεν απαντασ και εδοξαζον τον θεον και επλησθησαν φοβου λεγοντεσ οτι ειδομεν παραδοξα σημερον ");
INSERT INTO grcmt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","και μετα ταυτα εξηλθεν και εθεασατο τελωνην ονοματι λευιν καθημενον επι το τελωνιον και ειπεν αυτω ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","και καταλιπων απαντα αναστασ ηκολουθησεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","και εποιησεν δοχην μεγαλην λευισ αυτω εν τη οικια αυτου και ην οχλοσ τελωνων πολυσ και αλλων οι ησαν μετ αυτων κατακειμενοι ");
INSERT INTO grcmt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","και εγογγυζον οι γραμματεισ αυτων και οι φαρισαιοι προσ τουσ μαθητασ αυτου λεγοντεσ δια τι μετα των τελωνων και αμαρτωλων εσθιετε και πινετε ");
INSERT INTO grcmt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","και αποκριθεισ ο ιησουσ ειπεν προσ αυτουσ ου χρειαν εχουσιν οι υγιαινοντεσ ιατρου αλλ οι κακωσ εχοντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ουκ εληλυθα καλεσαι δικαιουσ αλλα αμαρτωλουσ εισ μετανοιαν ");
INSERT INTO grcmt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","οι δε ειπον προσ αυτον δια τι οι μαθηται ιωαννου νηστευουσιν πυκνα και δεησεισ ποιουνται ομοιωσ και οι των φαρισαιων οι δε σοι εσθιουσιν και πινουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ο δε ειπεν προσ αυτουσ μη δυνασθε τουσ υιουσ του νυμφωνοσ εν ω ο νυμφιοσ μετ αυτων εστιν ποιησαι νηστευειν ");
INSERT INTO grcmt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ελευσονται δε ημεραι και οταν απαρθη απ αυτων ο νυμφιοσ τοτε νηστευσουσιν εν εκειναισ ταισ ημεραισ ");
INSERT INTO grcmt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ελεγεν δε και παραβολην προσ αυτουσ οτι ουδεισ επιβλημα ιματιου καινου επιβαλλει επι ιματιον παλαιον ει δε μηγε και το καινον σχιζει και τω παλαιω ου συμφωνει το απο του καινου ");
INSERT INTO grcmt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","και ουδεισ βαλλει οινον νεον εισ ασκουσ παλαιουσ ει δε μηγε ρηξει ο νεοσ οινοσ τουσ ασκουσ και αυτοσ εκχυθησεται και οι ασκοι απολουνται ");
INSERT INTO grcmt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","αλλα οινον νεον εισ ασκουσ καινουσ βλητεον και αμφοτεροι συντηρουνται ");
INSERT INTO grcmt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","και ουδεισ πιων παλαιον ευθεωσ θελει νεον λεγει γαρ ο παλαιοσ χρηστοτεροσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","εγενετο δε εν σαββατω δευτεροπρωτω διαπορευεσθαι αυτον δια των σποριμων και ετιλλον οι μαθηται αυτου τουσ σταχυασ και ησθιον ψωχοντεσ ταισ χερσιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","τινεσ δε των φαρισαιων ειπον αυτοισ τι ποιειτε ο ουκ εξεστιν ποιειν εν τοισ σαββασιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","και αποκριθεισ προσ αυτουσ ειπεν ο ιησουσ ουδε τουτο ανεγνωτε ο εποιησεν δαυιδ οποτε επεινασεν αυτοσ και οι μετ αυτου οντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ωσ εισηλθεν εισ τον οικον του θεου και τουσ αρτουσ τησ προθεσεωσ ελαβεν και εφαγεν και εδωκεν και τοισ μετ αυτου ουσ ουκ εξεστιν φαγειν ει μη μονουσ τουσ ιερεισ ");
INSERT INTO grcmt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","και ελεγεν αυτοισ οτι κυριοσ εστιν ο υιοσ του ανθρωπου και του σαββατου ");
INSERT INTO grcmt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","εγενετο δε και εν ετερω σαββατω εισελθειν αυτον εισ την συναγωγην και διδασκειν και ην εκει ανθρωποσ και η χειρ αυτου η δεξια ην ξηρα ");
INSERT INTO grcmt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","παρετηρουν δε οι γραμματεισ και οι φαρισαιοι ει εν τω σαββατω θεραπευσει ινα ευρωσιν κατηγοριαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","αυτοσ δε ηδει τουσ διαλογισμουσ αυτων και ειπεν τω ανθρωπω τω ξηραν εχοντι την χειρα εγειραι και στηθι εισ το μεσον ο δε αναστασ εστη ");
INSERT INTO grcmt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ειπεν ουν ο ιησουσ προσ αυτουσ επερωτησω υμασ τι εξεστιν τοισ σαββασιν αγαθοποιησαι η κακοποιησαι ψυχην σωσαι η αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","και περιβλεψαμενοσ παντασ αυτουσ ειπεν αυτω εκτεινον την χειρα σου ο δε εποιησεν και αποκατεσταθη η χειρ αυτου υγιησ ωσ η αλλη ");
INSERT INTO grcmt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","αυτοι δε επλησθησαν ανοιασ και διελαλουν προσ αλληλουσ τι αν ποιησειαν τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","εγενετο δε εν ταισ ημεραισ ταυταισ εξηλθεν εισ το οροσ προσευξασθαι και ην διανυκτερευων εν τη προσευχη του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","και οτε εγενετο ημερα προσεφωνησεν τουσ μαθητασ αυτου και εκλεξαμενοσ απ αυτων δωδεκα ουσ και αποστολουσ ωνομασεν ");
INSERT INTO grcmt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","σιμωνα ον και ωνομασεν πετρον και ανδρεαν τον αδελφον αυτου ιακωβον και ιωαννην φιλιππον και βαρθολομαιον ");
INSERT INTO grcmt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ματθαιον και θωμαν ιακωβον τον του αλφαιου και σιμωνα τον καλουμενον ζηλωτην ");
INSERT INTO grcmt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ιουδαν ιακωβου και ιουδαν ισκαριωτην οσ και εγενετο προδοτησ ");
INSERT INTO grcmt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","και καταβασ μετ αυτων εστη επι τοπου πεδινου και οχλοσ μαθητων αυτου και πληθοσ πολυ του λαου απο πασησ τησ ιουδαιασ και ιερουσαλημ και τησ παραλιου τυρου και σιδωνοσ οι ηλθον ακουσαι αυτου και ιαθηναι απο των νοσων αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","και οι οχλουμενοι υπο πνευματων ακαθαρτων και εθεραπευοντο ");
INSERT INTO grcmt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","και πασ ο οχλοσ εζητει απτεσθαι αυτου οτι δυναμισ παρ αυτου εξηρχετο και ιατο παντασ ");
INSERT INTO grcmt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","και αυτοσ επαρασ τουσ οφθαλμουσ αυτου εισ τουσ μαθητασ αυτου ελεγεν μακαριοι οι πτωχοι οτι υμετερα εστιν η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","μακαριοι οι πεινωντεσ νυν οτι χορτασθησεσθε μακαριοι οι κλαιοντεσ νυν οτι γελασετε ");
INSERT INTO grcmt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","μακαριοι εστε οταν μισησωσιν υμασ οι ανθρωποι και οταν αφορισωσιν υμασ και ονειδισωσιν και εκβαλωσιν το ονομα υμων ωσ πονηρον ενεκα του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","χαρητε εν εκεινη τη ημερα και σκιρτησατε ιδου γαρ ο μισθοσ υμων πολυσ εν τω ουρανω κατα ταυτα γαρ εποιουν τοισ προφηταισ οι πατερεσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","πλην ουαι υμιν τοισ πλουσιοισ οτι απεχετε την παρακλησιν υμων ");
INSERT INTO grcmt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ουαι υμιν οι εμπεπλησμενοι οτι πεινασετε ουαι υμιν οι γελωντεσ νυν οτι πενθησετε και κλαυσετε ");
INSERT INTO grcmt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ουαι οταν καλωσ υμασ ειπωσιν οι ανθρωποι κατα ταυτα γαρ εποιουν τοισ ψευδοπροφηταισ οι πατερεσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","αλλ υμιν λεγω τοισ ακουουσιν αγαπατε τουσ εχθρουσ υμων καλωσ ποιειτε τοισ μισουσιν υμασ ");
INSERT INTO grcmt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ευλογειτε τουσ καταρωμενουσ υμιν προσευχεσθε υπερ των επηρεαζοντων υμασ ");
INSERT INTO grcmt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","τω τυπτοντι σε επι την σιαγονα παρεχε και την αλλην και απο του αιροντοσ σου το ιματιον και τον χιτωνα μη κωλυσησ ");
INSERT INTO grcmt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","παντι δε τω αιτουντι σε διδου και απο του αιροντοσ τα σα μη απαιτει ");
INSERT INTO grcmt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","και καθωσ θελετε ινα ποιωσιν υμιν οι ανθρωποι και υμεισ ποιειτε αυτοισ ομοιωσ ");
INSERT INTO grcmt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","και ει αγαπατε τουσ αγαπωντασ υμασ ποια υμιν χαρισ εστιν και γαρ οι αμαρτωλοι τουσ αγαπωντασ αυτουσ αγαπωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","και εαν αγαθοποιητε τουσ αγαθοποιουντασ υμασ ποια υμιν χαρισ εστιν και γαρ οι αμαρτωλοι το αυτο ποιουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","και εαν δανειζητε παρ ων ελπιζετε απολαβειν ποια υμιν χαρισ εστιν και γαρ αμαρτωλοι αμαρτωλοισ δανειζουσιν ινα απολαβωσιν τα ισα ");
INSERT INTO grcmt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","πλην αγαπατε τουσ εχθρουσ υμων και αγαθοποιειτε και δανειζετε μηδεν απελπιζοντεσ και εσται ο μισθοσ υμων πολυσ και εσεσθε υιοι υψιστου οτι αυτοσ χρηστοσ εστιν επι τουσ αχαριστουσ και πονηρουσ ");
INSERT INTO grcmt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","γινεσθε ουν οικτιρμονεσ καθωσ και ο πατηρ υμων οικτιρμων εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","και μη κρινετε και ου μη κριθητε μη καταδικαζετε και ου μη καταδικασθητε απολυετε και απολυθησεσθε ");
INSERT INTO grcmt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","διδοτε και δοθησεται υμιν μετρον καλον πεπιεσμενον και σεσαλευμενον και υπερεκχυνομενον δωσουσιν εισ τον κολπον υμων τω γαρ αυτω μετρω ω μετρειτε αντιμετρηθησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ειπεν δε παραβολην αυτοισ μητι δυναται τυφλοσ τυφλον οδηγειν ουχι αμφοτεροι εισ βοθυνον πεσουνται ");
INSERT INTO grcmt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ουκ εστιν μαθητησ υπερ τον διδασκαλον αυτου κατηρτισμενοσ δε πασ εσται ωσ ο διδασκαλοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","τι δε βλεπεισ το καρφοσ το εν τω οφθαλμω του αδελφου σου την δε δοκον την εν τω ιδιω οφθαλμω ου κατανοεισ ");
INSERT INTO grcmt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","η πωσ δυνασαι λεγειν τω αδελφω σου αδελφε αφεσ εκβαλω το καρφοσ το εν τω οφθαλμω σου αυτοσ την εν τω οφθαλμω σου δοκον ου βλεπων υποκριτα εκβαλε πρωτον την δοκον εκ του οφθαλμου σου και τοτε διαβλεψεισ εκβαλειν το καρφοσ το εν τω οφθαλμω του αδελφου σου ");
INSERT INTO grcmt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ου γαρ εστιν δενδρον καλον ποιουν καρπον σαπρον ουδε δενδρον σαπρον ποιουν καρπον καλον ");
INSERT INTO grcmt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","εκαστον γαρ δενδρον εκ του ιδιου καρπου γινωσκεται ου γαρ εξ ακανθων συλλεγουσιν συκα ουδε εκ βατου τρυγωσιν σταφυλην ");
INSERT INTO grcmt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ο αγαθοσ ανθρωποσ εκ του αγαθου θησαυρου τησ καρδιασ αυτου προφερει το αγαθον και ο πονηροσ ανθρωποσ εκ του πονηρου θησαυρου τησ καρδιασ αυτου προφερει το πονηρον εκ γαρ του περισσευματοσ τησ καρδιασ λαλει το στομα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","τι δε με καλειτε κυριε κυριε και ου ποιειτε α λεγω ");
INSERT INTO grcmt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","πασ ο ερχομενοσ προσ με και ακουων μου των λογων και ποιων αυτουσ υποδειξω υμιν τινι εστιν ομοιοσ ");
INSERT INTO grcmt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ομοιοσ εστιν ανθρωπω οικοδομουντι οικιαν οσ εσκαψεν και εβαθυνεν και εθηκεν θεμελιον επι την πετραν πλημμυρασ δε γενομενησ προσερρηξεν ο ποταμοσ τη οικια εκεινη και ουκ ισχυσεν σαλευσαι αυτην τεθεμελιωτο γαρ επι την πετραν ");
INSERT INTO grcmt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ο δε ακουσασ και μη ποιησασ ομοιοσ εστιν ανθρωπω οικοδομησαντι οικιαν επι την γην χωρισ θεμελιου η προσερρηξεν ο ποταμοσ και ευθεωσ επεσεν και εγενετο το ρηγμα τησ οικιασ εκεινησ μεγα ");
INSERT INTO grcmt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","επει δε επληρωσεν παντα τα ρηματα αυτου εισ τασ ακοασ του λαου εισηλθεν εισ καπερναουμ ");
INSERT INTO grcmt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","εκατονταρχου δε τινοσ δουλοσ κακωσ εχων εμελλεν τελευταν οσ ην αυτω εντιμοσ ");
INSERT INTO grcmt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ακουσασ δε περι του ιησου απεστειλεν προσ αυτον πρεσβυτερουσ των ιουδαιων ερωτων αυτον οπωσ ελθων διασωση τον δουλον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","οι δε παραγενομενοι προσ τον ιησουν παρεκαλουν αυτον σπουδαιωσ λεγοντεσ οτι αξιοσ εστιν ω παρεξει τουτο ");
INSERT INTO grcmt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","αγαπα γαρ το εθνοσ ημων και την συναγωγην αυτοσ ωκοδομησεν ημιν ");
INSERT INTO grcmt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ο δε ιησουσ επορευετο συν αυτοισ ηδη δε αυτου ου μακραν απεχοντοσ απο τησ οικιασ επεμψεν προσ αυτον ο εκατονταρχοσ φιλουσ λεγων αυτω κυριε μη σκυλλου ου γαρ ειμι ικανοσ ινα υπο την στεγην μου εισελθησ ");
INSERT INTO grcmt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","διο ουδε εμαυτον ηξιωσα προσ σε ελθειν αλλ ειπε λογω και ιαθησεται ο παισ μου ");
INSERT INTO grcmt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","και γαρ εγω ανθρωποσ ειμι υπο εξουσιαν τασσομενοσ εχων υπ εμαυτον στρατιωτασ και λεγω τουτω πορευθητι και πορευεται και αλλω ερχου και ερχεται και τω δουλω μου ποιησον τουτο και ποιει ");
INSERT INTO grcmt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ακουσασ δε ταυτα ο ιησουσ εθαυμασεν αυτον και στραφεισ τω ακολουθουντι αυτω οχλω ειπεν λεγω υμιν ουτε εν τω ισραηλ τοσαυτην πιστιν ευρον ");
INSERT INTO grcmt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","και υποστρεψαντεσ οι πεμφθεντεσ εισ τον οικον ευρον τον ασθενουντα δουλον υγιαινοντα ");
INSERT INTO grcmt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","και εγενετο εν τω εξησ επορευετο εισ πολιν καλουμενην ναιν και συνεπορευοντο αυτω οι μαθηται αυτου ικανοι και οχλοσ πολυσ ");
INSERT INTO grcmt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ωσ δε ηγγισεν τη πυλη τησ πολεωσ και ιδου εξεκομιζετο τεθνηκωσ υιοσ μονογενησ τη μητρι αυτου και αυτη χηρα και οχλοσ τησ πολεωσ ικανοσ συν αυτη ");
INSERT INTO grcmt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","και ιδων αυτην ο κυριοσ εσπλαγχνισθη επ αυτη και ειπεν αυτη μη κλαιε ");
INSERT INTO grcmt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","και προσελθων ηψατο τησ σορου οι δε βασταζοντεσ εστησαν και ειπεν νεανισκε σοι λεγω εγερθητι ");
INSERT INTO grcmt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","και ανεκαθισεν ο νεκροσ και ηρξατο λαλειν και εδωκεν αυτον τη μητρι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ελαβεν δε φοβοσ παντασ και εδοξαζον τον θεον λεγοντεσ οτι προφητησ μεγασ εγηγερται εν ημιν και οτι επεσκεψατο ο θεοσ τον λαον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","και εξηλθεν ο λογοσ ουτοσ εν ολη τη ιουδαια περι αυτου και εν παση τη περιχωρω ");
INSERT INTO grcmt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","και απηγγειλαν ιωαννη οι μαθηται αυτου περι παντων τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","και προσκαλεσαμενοσ δυο τινασ των μαθητων αυτου ο ιωαννησ επεμψεν προσ τον ιησουν λεγων συ ει ο ερχομενοσ η αλλον προσδοκωμεν ");
INSERT INTO grcmt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","παραγενομενοι δε προσ αυτον οι ανδρεσ ειπον ιωαννησ ο βαπτιστησ απεσταλκεν ημασ προσ σε λεγων συ ει ο ερχομενοσ η αλλον προσδοκωμεν ");
INSERT INTO grcmt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","εν αυτη δε τη ωρα εθεραπευσεν πολλουσ απο νοσων και μαστιγων και πνευματων πονηρων και τυφλοισ πολλοισ εχαρισατο το βλεπειν ");
INSERT INTO grcmt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","και αποκριθεισ ο ιησουσ ειπεν αυτοισ πορευθεντεσ απαγγειλατε ιωαννη α ειδετε και ηκουσατε οτι τυφλοι αναβλεπουσιν χωλοι περιπατουσιν λεπροι καθαριζονται κωφοι ακουουσιν νεκροι εγειρονται πτωχοι ευαγγελιζονται ");
INSERT INTO grcmt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","και μακαριοσ εστιν οσ εαν μη σκανδαλισθη εν εμοι ");
INSERT INTO grcmt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","απελθοντων δε των αγγελων ιωαννου ηρξατο λεγειν τοισ οχλοισ περι ιωαννου τι εξεληλυθατε εισ την ερημον θεασασθαι καλαμον υπο ανεμου σαλευομενον ");
INSERT INTO grcmt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","αλλα τι εξεληλυθατε ιδειν ανθρωπον εν μαλακοισ ιματιοισ ημφιεσμενον ιδου οι εν ιματισμω ενδοξω και τρυφη υπαρχοντεσ εν τοισ βασιλειοισ εισιν ");
INSERT INTO grcmt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","αλλα τι εξεληλυθατε ιδειν προφητην ναι λεγω υμιν και περισσοτερον προφητου ");
INSERT INTO grcmt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ουτοσ εστιν περι ου γεγραπται ιδου εγω αποστελλω τον αγγελον μου προ προσωπου σου οσ κατασκευασει την οδον σου εμπροσθεν σου ");
INSERT INTO grcmt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","λεγω γαρ υμιν μειζων εν γεννητοισ γυναικων προφητησ ιωαννου του βαπτιστου ουδεισ εστιν ο δε μικροτεροσ εν τη βασιλεια του θεου μειζων αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","και πασ ο λαοσ ακουσασ και οι τελωναι εδικαιωσαν τον θεον βαπτισθεντεσ το βαπτισμα ιωαννου ");
INSERT INTO grcmt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","οι δε φαρισαιοι και οι νομικοι την βουλην του θεου ηθετησαν εισ εαυτουσ μη βαπτισθεντεσ υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","τινι ουν ομοιωσω τουσ ανθρωπουσ τησ γενεασ ταυτησ και τινι εισιν ομοιοι ");
INSERT INTO grcmt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ομοιοι εισιν παιδιοισ τοισ εν αγορα καθημενοισ και προσφωνουσιν αλληλοισ και λεγουσιν ηυλησαμεν υμιν και ουκ ωρχησασθε εθρηνησαμεν υμιν και ουκ εκλαυσατε ");
INSERT INTO grcmt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","εληλυθεν γαρ ιωαννησ ο βαπτιστησ μητε αρτον εσθιων μητε οινον πινων και λεγετε δαιμονιον εχει ");
INSERT INTO grcmt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","εληλυθεν ο υιοσ του ανθρωπου εσθιων και πινων και λεγετε ιδου ανθρωποσ φαγοσ και οινοποτησ φιλοσ τελωνων και αμαρτωλων ");
INSERT INTO grcmt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","και εδικαιωθη η σοφια απο των τεκνων αυτησ παντων ");
INSERT INTO grcmt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ηρωτα δε τισ αυτον των φαρισαιων ινα φαγη μετ αυτου και εισελθων εισ την οικιαν του φαρισαιου ανεκλιθη ");
INSERT INTO grcmt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","και ιδου γυνη εν τη πολει ητισ ην αμαρτωλοσ επιγνουσα οτι ανακειται εν τη οικια του φαρισαιου κομισασα αλαβαστρον μυρου ");
INSERT INTO grcmt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","και στασα παρα τουσ ποδασ αυτου οπισω κλαιουσα ηρξατο βρεχειν τουσ ποδασ αυτου τοισ δακρυσιν και ταισ θριξιν τησ κεφαλησ αυτησ εξεμασσεν και κατεφιλει τουσ ποδασ αυτου και ηλειφεν τω μυρω ");
INSERT INTO grcmt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ιδων δε ο φαρισαιοσ ο καλεσασ αυτον ειπεν εν εαυτω λεγων ουτοσ ει ην προφητησ εγινωσκεν αν τισ και ποταπη η γυνη ητισ απτεται αυτου οτι αμαρτωλοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","και αποκριθεισ ο ιησουσ ειπεν προσ αυτον σιμων εχω σοι τι ειπειν ο δε φησιν διδασκαλε ειπε ");
INSERT INTO grcmt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","δυο χρεωφειλεται ησαν δανειστη τινι ο εισ ωφειλεν δηναρια πεντακοσια ο δε ετεροσ πεντηκοντα ");
INSERT INTO grcmt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","μη εχοντων δε αυτων αποδουναι αμφοτεροισ εχαρισατο τισ ουν αυτων ειπε πλειον αυτον αγαπησει ");
INSERT INTO grcmt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","αποκριθεισ δε ο σιμων ειπεν υπολαμβανω οτι ω το πλειον εχαρισατο ο δε ειπεν αυτω ορθωσ εκρινασ ");
INSERT INTO grcmt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","και στραφεισ προσ την γυναικα τω σιμωνι εφη βλεπεισ ταυτην την γυναικα εισηλθον σου εισ την οικιαν υδωρ επι τουσ ποδασ μου ουκ εδωκασ αυτη δε τοισ δακρυσιν εβρεξεν μου τουσ ποδασ και ταισ θριξιν τησ κεφαλησ αυτησ εξεμαξεν ");
INSERT INTO grcmt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","φιλημα μοι ουκ εδωκασ αυτη δε αφ ησ εισηλθον ου διελιπεν καταφιλουσα μου τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ελαιω την κεφαλην μου ουκ ηλειψασ αυτη δε μυρω ηλειψεν μου τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ου χαριν λεγω σοι αφεωνται αι αμαρτιαι αυτησ αι πολλαι οτι ηγαπησεν πολυ ω δε ολιγον αφιεται ολιγον αγαπα ");
INSERT INTO grcmt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ειπεν δε αυτη αφεωνται σου αι αμαρτιαι ");
INSERT INTO grcmt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","και ηρξαντο οι συνανακειμενοι λεγειν εν εαυτοισ τισ ουτοσ εστιν οσ και αμαρτιασ αφιησιν ");
INSERT INTO grcmt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ειπεν δε προσ την γυναικα η πιστισ σου σεσωκεν σε πορευου εισ ειρηνην ");
INSERT INTO grcmt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","και εγενετο εν τω καθεξησ και αυτοσ διωδευεν κατα πολιν και κωμην κηρυσσων και ευαγγελιζομενοσ την βασιλειαν του θεου και οι δωδεκα συν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","και γυναικεσ τινεσ αι ησαν τεθεραπευμεναι απο πνευματων πονηρων και ασθενειων μαρια η καλουμενη μαγδαληνη αφ ησ δαιμονια επτα εξεληλυθει ");
INSERT INTO grcmt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","και ιωαννα γυνη χουζα επιτροπου ηρωδου και σουσαννα και ετεραι πολλαι αιτινεσ διηκονουν αυτοισ απο των υπαρχοντων αυταισ ");
INSERT INTO grcmt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","συνιοντοσ δε οχλου πολλου και των κατα πολιν επιπορευομενων προσ αυτον ειπεν δια παραβολησ ");
INSERT INTO grcmt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","εξηλθεν ο σπειρων του σπειραι τον σπορον αυτου και εν τω σπειρειν αυτον ο μεν επεσεν παρα την οδον και κατεπατηθη και τα πετεινα του ουρανου κατεφαγεν αυτο ");
INSERT INTO grcmt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","και ετερον επεσεν επι την πετραν και φυεν εξηρανθη δια το μη εχειν ικμαδα ");
INSERT INTO grcmt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","και ετερον επεσεν εν μεσω των ακανθων και συμφυεισαι αι ακανθαι απεπνιξαν αυτο ");
INSERT INTO grcmt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","και ετερον επεσεν εισ την γην την αγαθην και φυεν εποιησεν καρπον εκατονταπλασιονα ταυτα λεγων εφωνει ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","επηρωτων δε αυτον οι μαθηται αυτου λεγοντεσ τισ ειη η παραβολη αυτη ");
INSERT INTO grcmt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ο δε ειπεν υμιν δεδοται γνωναι τα μυστηρια τησ βασιλειασ του θεου τοισ δε λοιποισ εν παραβολαισ ινα βλεποντεσ μη βλεπωσιν και ακουοντεσ μη συνιωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","εστιν δε αυτη η παραβολη ο σποροσ εστιν ο λογοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","οι δε παρα την οδον εισιν οι ακουοντεσ ειτα ερχεται ο διαβολοσ και αιρει τον λογον απο τησ καρδιασ αυτων ινα μη πιστευσαντεσ σωθωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","οι δε επι τησ πετρασ οι οταν ακουσωσιν μετα χαρασ δεχονται τον λογον και ουτοι ριζαν ουκ εχουσιν οι προσ καιρον πιστευουσιν και εν καιρω πειρασμου αφιστανται ");
INSERT INTO grcmt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","το δε εισ τασ ακανθασ πεσον ουτοι εισιν οι ακουσαντεσ και υπο μεριμνων και πλουτου και ηδονων του βιου πορευομενοι συμπνιγονται και ου τελεσφορουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","το δε εν τη καλη γη ουτοι εισιν οιτινεσ εν καρδια καλη και αγαθη ακουσαντεσ τον λογον κατεχουσιν και καρποφορουσιν εν υπομονη ");
INSERT INTO grcmt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ουδεισ δε λυχνον αψασ καλυπτει αυτον σκευει η υποκατω κλινησ τιθησιν αλλ επι λυχνιασ επιτιθησιν ινα οι εισπορευομενοι βλεπωσιν το φωσ ");
INSERT INTO grcmt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ου γαρ εστιν κρυπτον ο ου φανερον γενησεται ουδε αποκρυφον ο ου γνωσθησεται και εισ φανερον ελθη ");
INSERT INTO grcmt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","βλεπετε ουν πωσ ακουετε οσ γαρ εαν εχη δοθησεται αυτω και οσ εαν μη εχη και ο δοκει εχειν αρθησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","παρεγενοντο δε προσ αυτον η μητηρ και οι αδελφοι αυτου και ουκ ηδυναντο συντυχειν αυτω δια τον οχλον ");
INSERT INTO grcmt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","και απηγγελη αυτω λεγοντων η μητηρ σου και οι αδελφοι σου εστηκασιν εξω ιδειν σε θελοντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ο δε αποκριθεισ ειπεν προσ αυτουσ μητηρ μου και αδελφοι μου ουτοι εισιν οι τον λογον του θεου ακουοντεσ και ποιουντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","και εγενετο εν μια των ημερων και αυτοσ ενεβη εισ πλοιον και οι μαθηται αυτου και ειπεν προσ αυτουσ διελθωμεν εισ το περαν τησ λιμνησ και ανηχθησαν ");
INSERT INTO grcmt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","πλεοντων δε αυτων αφυπνωσεν και κατεβη λαιλαψ ανεμου εισ την λιμνην και συνεπληρουντο και εκινδυνευον ");
INSERT INTO grcmt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","προσελθοντεσ δε διηγειραν αυτον λεγοντεσ επιστατα επιστατα απολλυμεθα ο δε εγερθεισ επετιμησεν τω ανεμω και τω κλυδωνι του υδατοσ και επαυσαντο και εγενετο γαληνη ");
INSERT INTO grcmt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ειπεν δε αυτοισ που εστιν η πιστισ υμων φοβηθεντεσ δε εθαυμασαν λεγοντεσ προσ αλληλουσ τισ αρα ουτοσ εστιν οτι και τοισ ανεμοισ επιτασσει και τω υδατι και υπακουουσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","και κατεπλευσαν εισ την χωραν των γαδαρηνων ητισ εστιν αντιπεραν τησ γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","εξελθοντι δε αυτω επι την γην υπηντησεν αυτω ανηρ τισ εκ τησ πολεωσ οσ ειχεν δαιμονια εκ χρονων ικανων και ιματιον ουκ ενεδιδυσκετο και εν οικια ουκ εμενεν αλλ εν τοισ μνημασιν ");
INSERT INTO grcmt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ιδων δε τον ιησουν και ανακραξασ προσεπεσεν αυτω και φωνη μεγαλη ειπεν τι εμοι και σοι ιησου υιε του θεου του υψιστου δεομαι σου μη με βασανισησ ");
INSERT INTO grcmt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","παρηγγειλεν γαρ τω πνευματι τω ακαθαρτω εξελθειν απο του ανθρωπου πολλοισ γαρ χρονοισ συνηρπακει αυτον και εδεσμειτο αλυσεσιν και πεδαισ φυλασσομενοσ και διαρρησσων τα δεσμα ηλαυνετο υπο του δαιμονοσ εισ τασ ερημουσ ");
INSERT INTO grcmt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","επηρωτησεν δε αυτον ο ιησουσ λεγων τι σοι εστιν ονομα ο δε ειπεν λεγεων οτι δαιμονια πολλα εισηλθεν εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","και παρεκαλει αυτον ινα μη επιταξη αυτοισ εισ την αβυσσον απελθειν ");
INSERT INTO grcmt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ην δε εκει αγελη χοιρων ικανων βοσκομενων εν τω ορει και παρεκαλουν αυτον ινα επιτρεψη αυτοισ εισ εκεινουσ εισελθειν και επετρεψεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","εξελθοντα δε τα δαιμονια απο του ανθρωπου εισηλθον εισ τουσ χοιρουσ και ωρμησεν η αγελη κατα του κρημνου εισ την λιμνην και απεπνιγη ");
INSERT INTO grcmt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ιδοντεσ δε οι βοσκοντεσ το γεγενημενον εφυγον και απηγγειλαν εισ την πολιν και εισ τουσ αγρουσ ");
INSERT INTO grcmt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","εξηλθον δε ιδειν το γεγονοσ και ηλθον προσ τον ιησουν και ευρον καθημενον τον ανθρωπον αφ ου τα δαιμονια εξεληλυθει ιματισμενον και σωφρονουντα παρα τουσ ποδασ του ιησου και εφοβηθησαν ");
INSERT INTO grcmt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","απηγγειλαν δε αυτοισ και οι ιδοντεσ πωσ εσωθη ο δαιμονισθεισ ");
INSERT INTO grcmt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","και ηρωτησαν αυτον απαν το πληθοσ τησ περιχωρου των γαδαρηνων απελθειν απ αυτων οτι φοβω μεγαλω συνειχοντο αυτοσ δε εμβασ εισ το πλοιον υπεστρεψεν ");
INSERT INTO grcmt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","εδεετο δε αυτου ο ανηρ αφ ου εξεληλυθει τα δαιμονια ειναι συν αυτω απελυσεν δε αυτον ο ιησουσ λεγων ");
INSERT INTO grcmt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","υποστρεφε εισ τον οικον σου και διηγου οσα εποιησεν σοι ο θεοσ και απηλθεν καθ ολην την πολιν κηρυσσων οσα εποιησεν αυτω ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","εγενετο δε εν τω υποστρεψαι τον ιησουν απεδεξατο αυτον ο οχλοσ ησαν γαρ παντεσ προσδοκωντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","και ιδου ηλθεν ανηρ ω ονομα ιαειροσ και αυτοσ αρχων τησ συναγωγησ υπηρχεν και πεσων παρα τουσ ποδασ του ιησου παρεκαλει αυτον εισελθειν εισ τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","οτι θυγατηρ μονογενησ ην αυτω ωσ ετων δωδεκα και αυτη απεθνησκεν εν δε τω υπαγειν αυτον οι οχλοι συνεπνιγον αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","και γυνη ουσα εν ρυσει αιματοσ απο ετων δωδεκα ητισ ιατροισ προσαναλωσασα ολον τον βιον ουκ ισχυσεν υπ ουδενοσ θεραπευθηναι ");
INSERT INTO grcmt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","προσελθουσα οπισθεν ηψατο του κρασπεδου του ιματιου αυτου και παραχρημα εστη η ρυσισ του αιματοσ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","και ειπεν ο ιησουσ τισ ο αψαμενοσ μου αρνουμενων δε παντων ειπεν ο πετροσ και οι μετ αυτου επιστατα οι οχλοι συνεχουσιν σε και αποθλιβουσιν και λεγεισ τισ ο αψαμενοσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ο δε ιησουσ ειπεν ηψατο μου τισ εγω γαρ εγνων δυναμιν εξελθουσαν απ εμου ");
INSERT INTO grcmt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ιδουσα δε η γυνη οτι ουκ ελαθεν τρεμουσα ηλθεν και προσπεσουσα αυτω δι ην αιτιαν ηψατο αυτου απηγγειλεν αυτω ενωπιον παντοσ του λαου και ωσ ιαθη παραχρημα ");
INSERT INTO grcmt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ο δε ειπεν αυτη θαρσει θυγατερ η πιστισ σου σεσωκεν σε πορευου εισ ειρηνην ");
INSERT INTO grcmt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ετι αυτου λαλουντοσ ερχεται τισ παρα του αρχισυναγωγου λεγων αυτω οτι τεθνηκεν η θυγατηρ σου μη σκυλλε τον διδασκαλον ");
INSERT INTO grcmt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ο δε ιησουσ ακουσασ απεκριθη αυτω λεγων μη φοβου μονον πιστευε και σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ελθων δε εισ την οικιαν ουκ αφηκεν εισελθειν ουδενα ει μη πετρον και ιωαννην και ιακωβον και τον πατερα τησ παιδοσ και την μητερα ");
INSERT INTO grcmt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","εκλαιον δε παντεσ και εκοπτοντο αυτην ο δε ειπεν μη κλαιετε ουκ απεθανεν αλλα καθευδει ");
INSERT INTO grcmt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","και κατεγελων αυτου ειδοτεσ οτι απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","αυτοσ δε εκβαλων εξω παντασ και κρατησασ τησ χειροσ αυτησ εφωνησεν λεγων η παισ εγειρου ");
INSERT INTO grcmt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","και επεστρεψεν το πνευμα αυτησ και ανεστη παραχρημα και διεταξεν αυτη δοθηναι φαγειν ");
INSERT INTO grcmt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","και εξεστησαν οι γονεισ αυτησ ο δε παρηγγειλεν αυτοισ μηδενι ειπειν το γεγονοσ ");
INSERT INTO grcmt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","συγκαλεσαμενοσ δε τουσ δωδεκα εδωκεν αυτοισ δυναμιν και εξουσιαν επι παντα τα δαιμονια και νοσουσ θεραπευειν ");
INSERT INTO grcmt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","και απεστειλεν αυτουσ κηρυσσειν την βασιλειαν του θεου και ιασθαι τουσ ασθενουντασ ");
INSERT INTO grcmt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","και ειπεν προσ αυτουσ μηδεν αιρετε εισ την οδον μητε ραβδουσ μητε πηραν μητε αρτον μητε αργυριον μητε ανα δυο χιτωνασ εχειν ");
INSERT INTO grcmt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","και εισ ην αν οικιαν εισελθητε εκει μενετε και εκειθεν εξερχεσθε ");
INSERT INTO grcmt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","και οσοι εαν μη δεξωνται υμασ εξερχομενοι απο τησ πολεωσ εκεινησ και τον κονιορτον απο των ποδων υμων αποτιναξατε εισ μαρτυριον επ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","εξερχομενοι δε διηρχοντο κατα τασ κωμασ ευαγγελιζομενοι και θεραπευοντεσ πανταχου ");
INSERT INTO grcmt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ηκουσεν δε ηρωδησ ο τετραρχησ τα γινομενα υπ αυτου παντα και διηπορει δια το λεγεσθαι υπο τινων οτι ιωαννησ εγηγερται εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","υπο τινων δε οτι ηλιασ εφανη αλλων δε οτι προφητησ εισ των αρχαιων ανεστη ");
INSERT INTO grcmt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","και ειπεν ηρωδησ ιωαννην εγω απεκεφαλισα τισ δε εστιν ουτοσ περι ου εγω ακουω τοιαυτα και εζητει ιδειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","και υποστρεψαντεσ οι αποστολοι διηγησαντο αυτω οσα εποιησαν και παραλαβων αυτουσ υπεχωρησεν κατ ιδιαν εισ τοπον ερημον πολεωσ καλουμενησ βηθσαιδαν ");
INSERT INTO grcmt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","οι δε οχλοι γνοντεσ ηκολουθησαν αυτω και δεξαμενοσ αυτουσ ελαλει αυτοισ περι τησ βασιλειασ του θεου και τουσ χρειαν εχοντασ θεραπειασ ιατο ");
INSERT INTO grcmt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","η δε ημερα ηρξατο κλινειν προσελθοντεσ δε οι δωδεκα ειπον αυτω απολυσον τον οχλον ινα απελθοντεσ εισ τασ κυκλω κωμασ και τουσ αγρουσ καταλυσωσιν και ευρωσιν επισιτισμον οτι ωδε εν ερημω τοπω εσμεν ");
INSERT INTO grcmt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ειπεν δε προσ αυτουσ δοτε αυτοισ υμεισ φαγειν οι δε ειπον ουκ εισιν ημιν πλειον η πεντε αρτοι και ιχθυεσ δυο ει μητι πορευθεντεσ ημεισ αγορασωμεν εισ παντα τον λαον τουτον βρωματα ");
INSERT INTO grcmt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ησαν γαρ ωσει ανδρεσ πεντακισχιλιοι ειπεν δε προσ τουσ μαθητασ αυτου κατακλινατε αυτουσ κλισιασ ανα πεντηκοντα ");
INSERT INTO grcmt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","και εποιησαν ουτωσ και ανεκλιναν απαντασ ");
INSERT INTO grcmt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","λαβων δε τουσ πεντε αρτουσ και τουσ δυο ιχθυασ αναβλεψασ εισ τον ουρανον ευλογησεν αυτουσ και κατεκλασεν και εδιδου τοισ μαθηταισ παρατιθεναι τω οχλω ");
INSERT INTO grcmt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","και εφαγον και εχορτασθησαν παντεσ και ηρθη το περισσευσαν αυτοισ κλασματων κοφινοι δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","και εγενετο εν τω ειναι αυτον προσευχομενον καταμονασ συνησαν αυτω οι μαθηται και επηρωτησεν αυτουσ λεγων τινα με λεγουσιν οι οχλοι ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","οι δε αποκριθεντεσ ειπον ιωαννην τον βαπτιστην αλλοι δε ηλιαν αλλοι δε οτι προφητησ τισ των αρχαιων ανεστη ");
INSERT INTO grcmt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ειπεν δε αυτοισ υμεισ δε τινα με λεγετε ειναι αποκριθεισ δε ο πετροσ ειπεν τον χριστον του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ο δε επιτιμησασ αυτοισ παρηγγειλεν μηδενι ειπειν τουτο ");
INSERT INTO grcmt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ειπων οτι δει τον υιον του ανθρωπου πολλα παθειν και αποδοκιμασθηναι απο των πρεσβυτερων και αρχιερεων και γραμματεων και αποκτανθηναι και τη τριτη ημερα αναστηναι ");
INSERT INTO grcmt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ελεγεν δε προσ παντασ ει τισ θελει οπισω μου ελθειν απαρνησασθω εαυτον και αρατω τον σταυρον αυτου και ακολουθειτω μοι ");
INSERT INTO grcmt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","οσ γαρ εαν θελη την ψυχην αυτου σωσαι απολεσει αυτην οσ δ αν απολεση την ψυχην αυτου ενεκεν εμου ουτοσ σωσει αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","τι γαρ ωφελειται ανθρωποσ κερδησασ τον κοσμον ολον εαυτον δε απολεσασ η ζημιωθεισ ");
INSERT INTO grcmt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","οσ γαρ αν επαισχυνθη με και τουσ εμουσ λογουσ τουτον ο υιοσ του ανθρωπου επαισχυνθησεται οταν ελθη εν τη δοξη αυτου και του πατροσ και των αγιων αγγελων ");
INSERT INTO grcmt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","λεγω δε υμιν αληθωσ εισιν τινεσ των ωδε εστωτων οι ου μη γευσωνται θανατου εωσ αν ιδωσιν την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","εγενετο δε μετα τουσ λογουσ τουτουσ ωσει ημεραι οκτω και παραλαβων πετρον και ιωαννην και ιακωβον ανεβη εισ το οροσ προσευξασθαι ");
INSERT INTO grcmt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","και εγενετο εν τω προσευχεσθαι αυτον το ειδοσ του προσωπου αυτου ετερον και ο ιματισμοσ αυτου λευκοσ εξαστραπτων ");
INSERT INTO grcmt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","και ιδου ανδρεσ δυο συνελαλουν αυτω οιτινεσ ησαν μωσησ και ηλιασ ");
INSERT INTO grcmt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","οι οφθεντεσ εν δοξη ελεγον την εξοδον αυτου ην εμελλεν πληρουν εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ο δε πετροσ και οι συν αυτω ησαν βεβαρημενοι υπνω διαγρηγορησαντεσ δε ειδον την δοξαν αυτου και τουσ δυο ανδρασ τουσ συνεστωτασ αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","και εγενετο εν τω διαχωριζεσθαι αυτουσ απ αυτου ειπεν πετροσ προσ τον ιησουν επιστατα καλον εστιν ημασ ωδε ειναι και ποιησωμεν σκηνασ τρεισ μιαν σοι και μιαν μωση και μιαν ηλια μη ειδωσ ο λεγει ");
INSERT INTO grcmt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ταυτα δε αυτου λεγοντοσ εγενετο νεφελη και επεσκιασεν αυτουσ εφοβηθησαν δε εν τω εκεινουσ εισελθειν εισ την νεφελην ");
INSERT INTO grcmt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","και φωνη εγενετο εκ τησ νεφελησ λεγουσα ουτοσ εστιν ο υιοσ μου ο αγαπητοσ αυτου ακουετε ");
INSERT INTO grcmt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","και εν τω γενεσθαι την φωνην ευρεθη ο ιησουσ μονοσ και αυτοι εσιγησαν και ουδενι απηγγειλαν εν εκειναισ ταισ ημεραισ ουδεν ων εωρακασιν ");
INSERT INTO grcmt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","εγενετο δε εν τη εξησ ημερα κατελθοντων αυτων απο του ορουσ συνηντησεν αυτω οχλοσ πολυσ ");
INSERT INTO grcmt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","και ιδου ανηρ απο του οχλου ανεβοησεν λεγων διδασκαλε δεομαι σου επιβλεψαι επι τον υιον μου οτι μονογενησ εστιν μοι ");
INSERT INTO grcmt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","και ιδου πνευμα λαμβανει αυτον και εξαιφνησ κραζει και σπαρασσει αυτον μετα αφρου και μογισ αποχωρει απ αυτου συντριβον αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","και εδεηθην των μαθητων σου ινα εκβαλωσιν αυτο και ουκ ηδυνηθησαν ");
INSERT INTO grcmt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","αποκριθεισ δε ο ιησουσ ειπεν ω γενεα απιστοσ και διεστραμμενη εωσ ποτε εσομαι προσ υμασ και ανεξομαι υμων προσαγαγε τον υιον σου ωδε ");
INSERT INTO grcmt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ετι δε προσερχομενου αυτου ερρηξεν αυτον το δαιμονιον και συνεσπαραξεν επετιμησεν δε ο ιησουσ τω πνευματι τω ακαθαρτω και ιασατο τον παιδα και απεδωκεν αυτον τω πατρι αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","εξεπλησσοντο δε παντεσ επι τη μεγαλειοτητι του θεου παντων δε θαυμαζοντων επι πασιν οισ εποιησεν ο ιησουσ ειπεν προσ τουσ μαθητασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","θεσθε υμεισ εισ τα ωτα υμων τουσ λογουσ τουτουσ ο γαρ υιοσ του ανθρωπου μελλει παραδιδοσθαι εισ χειρασ ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","οι δε ηγνοουν το ρημα τουτο και ην παρακεκαλυμμενον απ αυτων ινα μη αισθωνται αυτο και εφοβουντο ερωτησαι αυτον περι του ρηματοσ τουτου ");
INSERT INTO grcmt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","εισηλθεν δε διαλογισμοσ εν αυτοισ το τισ αν ειη μειζων αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ο δε ιησουσ ιδων τον διαλογισμον τησ καρδιασ αυτων επιλαβομενοσ παιδιου εστησεν αυτο παρ εαυτω ");
INSERT INTO grcmt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","και ειπεν αυτοισ οσ εαν δεξηται τουτο το παιδιον επι τω ονοματι μου εμε δεχεται και οσ εαν εμε δεξηται δεχεται τον αποστειλαντα με ο γαρ μικροτεροσ εν πασιν υμιν υπαρχων ουτοσ εσται μεγασ ");
INSERT INTO grcmt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","αποκριθεισ δε ο ιωαννησ ειπεν επιστατα ειδομεν τινα επι τω ονοματι σου εκβαλλοντα δαιμονια και εκωλυσαμεν αυτον οτι ουκ ακολουθει μεθ ημων ");
INSERT INTO grcmt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","και ειπεν προσ αυτον ο ιησουσ μη κωλυετε οσ γαρ ουκ εστιν καθ ημων υπερ ημων εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","εγενετο δε εν τω συμπληρουσθαι τασ ημερασ τησ αναληψεωσ αυτου και αυτοσ το προσωπον αυτου εστηριξεν του πορευεσθαι εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","και απεστειλεν αγγελουσ προ προσωπου αυτου και πορευθεντεσ εισηλθον εισ κωμην σαμαρειτων ωστε ετοιμασαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","και ουκ εδεξαντο αυτον οτι το προσωπον αυτου ην πορευομενον εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ιδοντεσ δε οι μαθηται αυτου ιακωβοσ και ιωαννησ ειπον κυριε θελεισ ειπωμεν πυρ καταβηναι απο του ουρανου και αναλωσαι αυτουσ ωσ και ηλιασ εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","στραφεισ δε επετιμησεν αυτοισ και ειπεν ουκ οιδατε οιου πνευματοσ εστε υμεισ ");
INSERT INTO grcmt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ο γαρ υιοσ του ανθρωπου ουκ ηλθεν ψυχασ ανθρωπων απολεσαι αλλα σωσαι και επορευθησαν εισ ετεραν κωμην ");
INSERT INTO grcmt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","εγενετο δε πορευομενων αυτων εν τη οδω ειπεν τισ προσ αυτον ακολουθησω σοι οπου αν απερχη κυριε ");
INSERT INTO grcmt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","και ειπεν αυτω ο ιησουσ αι αλωπεκεσ φωλεουσ εχουσιν και τα πετεινα του ουρανου κατασκηνωσεισ ο δε υιοσ του ανθρωπου ουκ εχει που την κεφαλην κλινη ");
INSERT INTO grcmt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ειπεν δε προσ ετερον ακολουθει μοι ο δε ειπεν κυριε επιτρεψον μοι απελθοντι πρωτον θαψαι τον πατερα μου ");
INSERT INTO grcmt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ειπεν δε αυτω ο ιησουσ αφεσ τουσ νεκρουσ θαψαι τουσ εαυτων νεκρουσ συ δε απελθων διαγγελλε την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ειπεν δε και ετεροσ ακολουθησω σοι κυριε πρωτον δε επιτρεψον μοι αποταξασθαι τοισ εισ τον οικον μου ");
INSERT INTO grcmt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ειπεν δε ο ιησουσ προσ αυτον ουδεισ επιβαλων την χειρα αυτου επ αροτρον και βλεπων εισ τα οπισω ευθετοσ εστιν εισ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","μετα δε ταυτα ανεδειξεν ο κυριοσ και ετερουσ εβδομηκοντα και απεστειλεν αυτουσ ανα δυο προ προσωπου αυτου εισ πασαν πολιν και τοπον ου εμελλεν αυτοσ ερχεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ελεγεν ουν προσ αυτουσ ο μεν θερισμοσ πολυσ οι δε εργαται ολιγοι δεηθητε ουν του κυριου του θερισμου οπωσ εκβαλη εργατασ εισ τον θερισμον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","υπαγετε ιδου εγω αποστελλω υμασ ωσ αρνασ εν μεσω λυκων ");
INSERT INTO grcmt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","μη βασταζετε βαλαντιον μη πηραν μηδε υποδηματα και μηδενα κατα την οδον ασπασησθε ");
INSERT INTO grcmt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","εισ ην δ αν οικιαν εισερχησθε πρωτον λεγετε ειρηνη τω οικω τουτω ");
INSERT INTO grcmt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","και εαν η εκει υιοσ ειρηνησ επαναπαυσεται επ αυτον η ειρηνη υμων ει δε μηγε εφ υμασ ανακαμψει ");
INSERT INTO grcmt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","εν αυτη δε τη οικια μενετε εσθιοντεσ και πινοντεσ τα παρ αυτων αξιοσ γαρ ο εργατησ του μισθου αυτου εστιν μη μεταβαινετε εξ οικιασ εισ οικιαν ");
INSERT INTO grcmt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","και εισ ην αν πολιν εισερχησθε και δεχωνται υμασ εσθιετε τα παρατιθεμενα υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","και θεραπευετε τουσ εν αυτη ασθενεισ και λεγετε αυτοισ ηγγικεν εφ υμασ η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","εισ ην δ αν πολιν εισερχησθε και μη δεχωνται υμασ εξελθοντεσ εισ τασ πλατειασ αυτησ ειπατε ");
INSERT INTO grcmt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","και τον κονιορτον τον κολληθεντα ημιν εκ τησ πολεωσ υμων απομασσομεθα υμιν πλην τουτο γινωσκετε οτι ηγγικεν εφ υμασ η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","λεγω υμιν οτι σοδομοισ εν τη ημερα εκεινη ανεκτοτερον εσται η τη πολει εκεινη ");
INSERT INTO grcmt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ουαι σοι χοραζιν ουαι σοι βηθσαιδα οτι ει εν τυρω και σιδωνι εγενοντο αι δυναμεισ αι γενομεναι εν υμιν παλαι αν εν σακκω και σποδω καθημεναι μετενοησαν ");
INSERT INTO grcmt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","πλην τυρω και σιδωνι ανεκτοτερον εσται εν τη κρισει η υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","και συ καπερναουμ η εωσ του ουρανου υψωθεισα εωσ αδου καταβιβασθηση ");
INSERT INTO grcmt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ο ακουων υμων εμου ακουει και ο αθετων υμασ εμε αθετει ο δε εμε αθετων αθετει τον αποστειλαντα με ");
INSERT INTO grcmt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","υπεστρεψαν δε οι εβδομηκοντα μετα χαρασ λεγοντεσ κυριε και τα δαιμονια υποτασσεται ημιν εν τω ονοματι σου ");
INSERT INTO grcmt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ειπεν δε αυτοισ εθεωρουν τον σαταναν ωσ αστραπην εκ του ουρανου πεσοντα ");
INSERT INTO grcmt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ιδου διδωμι υμιν την εξουσιαν του πατειν επανω οφεων και σκορπιων και επι πασαν την δυναμιν του εχθρου και ουδεν υμασ ου μη αδικηση ");
INSERT INTO grcmt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","πλην εν τουτω μη χαιρετε οτι τα πνευματα υμιν υποτασσεται χαιρετε δε οτι τα ονοματα υμων εγραφη εν τοισ ουρανοισ ");
INSERT INTO grcmt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","εν αυτη τη ωρα ηγαλλιασατο τω πνευματι ο ιησουσ και ειπεν εξομολογουμαι σοι πατερ κυριε του ουρανου και τησ γησ οτι απεκρυψασ ταυτα απο σοφων και συνετων και απεκαλυψασ αυτα νηπιοισ ναι ο πατηρ οτι ουτωσ εγενετο ευδοκια εμπροσθεν σου ");
INSERT INTO grcmt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","και στραφεισ προσ τουσ μαθητασ ειπεν παντα μοι παρεδοθη υπο του πατροσ μου και ουδεισ γινωσκει τισ εστιν ο υιοσ ει μη ο πατηρ και τισ εστιν ο πατηρ ει μη ο υιοσ και ω εαν βουληται ο υιοσ αποκαλυψαι ");
INSERT INTO grcmt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","και στραφεισ προσ τουσ μαθητασ κατ ιδιαν ειπεν μακαριοι οι οφθαλμοι οι βλεποντεσ α βλεπετε ");
INSERT INTO grcmt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","λεγω γαρ υμιν οτι πολλοι προφηται και βασιλεισ ηθελησαν ιδειν α υμεισ βλεπετε και ουκ ειδον και ακουσαι α ακουετε και ουκ ηκουσαν ");
INSERT INTO grcmt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","και ιδου νομικοσ τισ ανεστη εκπειραζων αυτον και λεγων διδασκαλε τι ποιησασ ζωην αιωνιον κληρονομησω ");
INSERT INTO grcmt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ο δε ειπεν προσ αυτον εν τω νομω τι γεγραπται πωσ αναγινωσκεισ ");
INSERT INTO grcmt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ο δε αποκριθεισ ειπεν αγαπησεισ κυριον τον θεον σου εξ ολησ τησ καρδιασ σου και εξ ολησ τησ ψυχησ σου και εξ ολησ τησ ισχυοσ σου και εξ ολησ τησ διανοιασ σου και τον πλησιον σου ωσ σεαυτον ");
INSERT INTO grcmt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ειπεν δε αυτω ορθωσ απεκριθησ τουτο ποιει και ζηση ");
INSERT INTO grcmt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ο δε θελων δικαιουν εαυτον ειπεν προσ τον ιησουν και τισ εστιν μου πλησιον ");
INSERT INTO grcmt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","υπολαβων δε ο ιησουσ ειπεν ανθρωποσ τισ κατεβαινεν απο ιερουσαλημ εισ ιεριχω και λησταισ περιεπεσεν οι και εκδυσαντεσ αυτον και πληγασ επιθεντεσ απηλθον αφεντεσ ημιθανη τυγχανοντα ");
INSERT INTO grcmt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","κατα συγκυριαν δε ιερευσ τισ κατεβαινεν εν τη οδω εκεινη και ιδων αυτον αντιπαρηλθεν ");
INSERT INTO grcmt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ομοιωσ δε και λευιτησ γενομενοσ κατα τον τοπον ελθων και ιδων αντιπαρηλθεν ");
INSERT INTO grcmt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","σαμαρειτησ δε τισ οδευων ηλθεν κατ αυτον και ιδων αυτον εσπλαγχνισθη ");
INSERT INTO grcmt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","και προσελθων κατεδησεν τα τραυματα αυτου επιχεων ελαιον και οινον επιβιβασασ δε αυτον επι το ιδιον κτηνοσ ηγαγεν αυτον εισ πανδοχειον και επεμεληθη αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","και επι την αυριον εξελθων εκβαλων δυο δηναρια εδωκεν τω πανδοχει και ειπεν αυτω επιμεληθητι αυτου και ο τι αν προσδαπανησησ εγω εν τω επανερχεσθαι με αποδωσω σοι ");
INSERT INTO grcmt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","τισ ουν τουτων των τριων πλησιον δοκει σοι γεγονεναι του εμπεσοντοσ εισ τουσ ληστασ ");
INSERT INTO grcmt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ο δε ειπεν ο ποιησασ το ελεοσ μετ αυτου ειπεν ουν αυτω ο ιησουσ πορευου και συ ποιει ομοιωσ ");
INSERT INTO grcmt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","εγενετο δε εν τω πορευεσθαι αυτουσ και αυτοσ εισηλθεν εισ κωμην τινα γυνη δε τισ ονοματι μαρθα υπεδεξατο αυτον εισ τον οικον αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","και τηδε ην αδελφη καλουμενη μαρια η και παρακαθισασα παρα τουσ ποδασ του ιησου ηκουεν τον λογον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","η δε μαρθα περιεσπατο περι πολλην διακονιαν επιστασα δε ειπεν κυριε ου μελει σοι οτι η αδελφη μου μονην με κατελειπεν διακονειν ειπε ουν αυτη ινα μοι συναντιλαβηται ");
INSERT INTO grcmt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","αποκριθεισ δε ειπεν αυτη ο ιησουσ μαρθα μαρθα μεριμνασ και τυρβαζη περι πολλα ");
INSERT INTO grcmt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ενοσ δε εστιν χρεια μαρια δε την αγαθην μεριδα εξελεξατο ητισ ουκ αφαιρεθησεται απ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","και εγενετο εν τω ειναι αυτον εν τοπω τινι προσευχομενον ωσ επαυσατο ειπεν τισ των μαθητων αυτου προσ αυτον κυριε διδαξον ημασ προσευχεσθαι καθωσ και ιωαννησ εδιδαξεν τουσ μαθητασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ειπεν δε αυτοισ οταν προσευχησθε λεγετε πατερ ημων ο εν τοισ ουρανοισ αγιασθητω το ονομα σου ελθετω η βασιλεια σου γενηθητω το θελημα σου ωσ εν ουρανω και επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","τον αρτον ημων τον επιουσιον διδου ημιν το καθ ημεραν ");
INSERT INTO grcmt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","και αφεσ ημιν τασ αμαρτιασ ημων και γαρ αυτοι αφιεμεν παντι οφειλοντι ημιν και μη εισενεγκησ ημασ εισ πειρασμον αλλα ρυσαι ημασ απο του πονηρου ");
INSERT INTO grcmt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","και ειπεν προσ αυτουσ τισ εξ υμων εξει φιλον και πορευσεται προσ αυτον μεσονυκτιου και ειπη αυτω φιλε χρησον μοι τρεισ αρτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","επειδη φιλοσ παρεγενετο εξ οδου προσ με και ουκ εχω ο παραθησω αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","κακεινοσ εσωθεν αποκριθεισ ειπη μη μοι κοπουσ παρεχε ηδη η θυρα κεκλεισται και τα παιδια μου μετ εμου εισ την κοιτην εισιν ου δυναμαι αναστασ δουναι σοι ");
INSERT INTO grcmt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","λεγω υμιν ει και ου δωσει αυτω αναστασ δια το ειναι αυτου φιλον δια γε την αναιδειαν αυτου εγερθεισ δωσει αυτω οσον χρηζει ");
INSERT INTO grcmt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","καγω υμιν λεγω αιτειτε και δοθησεται υμιν ζητειτε και ευρησετε κρουετε και ανοιγησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","πασ γαρ ο αιτων λαμβανει και ο ζητων ευρισκει και τω κρουοντι ανοιγησεται ");
INSERT INTO grcmt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","τινα δε υμων τον πατερα αιτησει ο υιοσ αρτον μη λιθον επιδωσει αυτω η και ιχθυν μη αντι ιχθυοσ οφιν επιδωσει αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","η και εαν αιτηση ωον μη επιδωσει αυτω σκορπιον ");
INSERT INTO grcmt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ει ουν υμεισ πονηροι υπαρχοντεσ οιδατε δοματα αγαθα διδοναι τοισ τεκνοισ υμων ποσω μαλλον ο πατηρ ο εξ ουρανου δωσει πνευμα αγιον τοισ αιτουσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","και ην εκβαλλων δαιμονιον και αυτο ην κωφον εγενετο δε του δαιμονιου εξελθοντοσ ελαλησεν ο κωφοσ και εθαυμασαν οι οχλοι ");
INSERT INTO grcmt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","τινεσ δε εξ αυτων ειπον εν βεελζεβουλ αρχοντι των δαιμονιων εκβαλλει τα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ετεροι δε πειραζοντεσ σημειον παρ αυτου εζητουν εξ ουρανου ");
INSERT INTO grcmt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","αυτοσ δε ειδωσ αυτων τα διανοηματα ειπεν αυτοισ πασα βασιλεια εφ εαυτην διαμερισθεισα ερημουται και οικοσ επι οικον πιπτει ");
INSERT INTO grcmt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ει δε και ο σατανασ εφ εαυτον διεμερισθη πωσ σταθησεται η βασιλεια αυτου οτι λεγετε εν βεελζεβουλ εκβαλλειν με τα δαιμονια ");
INSERT INTO grcmt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ει δε εγω εν βεελζεβουλ εκβαλλω τα δαιμονια οι υιοι υμων εν τινι εκβαλλουσιν δια τουτο κριται υμων αυτοι εσονται ");
INSERT INTO grcmt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ει δε εν δακτυλω θεου εκβαλλω τα δαιμονια αρα εφθασεν εφ υμασ η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","οταν ο ισχυροσ καθωπλισμενοσ φυλασση την εαυτου αυλην εν ειρηνη εστιν τα υπαρχοντα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","επαν δε ο ισχυροτεροσ αυτου επελθων νικηση αυτον την πανοπλιαν αυτου αιρει εφ η επεποιθει και τα σκυλα αυτου διαδιδωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ο μη ων μετ εμου κατ εμου εστιν και ο μη συναγων μετ εμου σκορπιζει ");
INSERT INTO grcmt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","οταν το ακαθαρτον πνευμα εξελθη απο του ανθρωπου διερχεται δι ανυδρων τοπων ζητουν αναπαυσιν και μη ευρισκον λεγει υποστρεψω εισ τον οικον μου οθεν εξηλθον ");
INSERT INTO grcmt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","και ελθον ευρισκει σεσαρωμενον και κεκοσμημενον ");
INSERT INTO grcmt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","τοτε πορευεται και παραλαμβανει επτα ετερα πνευματα πονηροτερα εαυτου και ελθοντα κατοικει εκει και γινεται τα εσχατα του ανθρωπου εκεινου χειρονα των πρωτων ");
INSERT INTO grcmt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","εγενετο δε εν τω λεγειν αυτον ταυτα επαρασα τισ γυνη φωνην εκ του οχλου ειπεν αυτω μακαρια η κοιλια η βαστασασα σε και μαστοι ουσ εθηλασασ ");
INSERT INTO grcmt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","αυτοσ δε ειπεν μενουνγε μακαριοι οι ακουοντεσ τον λογον του θεου και φυλασσοντεσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","των δε οχλων επαθροιζομενων ηρξατο λεγειν η γενεα αυτη πονηρα εστιν σημειον επιζητει και σημειον ου δοθησεται αυτη ει μη το σημειον ιωνα του προφητου ");
INSERT INTO grcmt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","καθωσ γαρ εγενετο ιωνασ σημειον τοισ νινευιταισ ουτωσ εσται και ο υιοσ του ανθρωπου τη γενεα ταυτη ");
INSERT INTO grcmt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","βασιλισσα νοτου εγερθησεται εν τη κρισει μετα των ανδρων τησ γενεασ ταυτησ και κατακρινει αυτουσ οτι ηλθεν εκ των περατων τησ γησ ακουσαι την σοφιαν σολομωνοσ και ιδου πλειον σολομωνοσ ωδε ");
INSERT INTO grcmt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ανδρεσ νινευι αναστησονται εν τη κρισει μετα τησ γενεασ ταυτησ και κατακρινουσιν αυτην οτι μετενοησαν εισ το κηρυγμα ιωνα και ιδου πλειον ιωνα ωδε ");
INSERT INTO grcmt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ουδεισ δε λυχνον αψασ εισ κρυπτην τιθησιν ουδε υπο τον μοδιον αλλ επι την λυχνιαν ινα οι εισπορευομενοι το φεγγοσ βλεπωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ο λυχνοσ του σωματοσ εστιν ο οφθαλμοσ οταν ουν ο οφθαλμοσ σου απλουσ η και ολον το σωμα σου φωτεινον εστιν επαν δε πονηροσ η και το σωμα σου σκοτεινον ");
INSERT INTO grcmt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","σκοπει ουν μη το φωσ το εν σοι σκοτοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ει ουν το σωμα σου ολον φωτεινον μη εχον τι μεροσ σκοτεινον εσται φωτεινον ολον ωσ οταν ο λυχνοσ τη αστραπη φωτιζη σε ");
INSERT INTO grcmt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","εν δε τω λαλησαι ηρωτα αυτον φαρισαιοσ τισ οπωσ αριστηση παρ αυτω εισελθων δε ανεπεσεν ");
INSERT INTO grcmt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ο δε φαρισαιοσ ιδων εθαυμασεν οτι ου πρωτον εβαπτισθη προ του αριστου ");
INSERT INTO grcmt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ειπεν δε ο κυριοσ προσ αυτον νυν υμεισ οι φαρισαιοι το εξωθεν του ποτηριου και του πινακοσ καθαριζετε το δε εσωθεν υμων γεμει αρπαγησ και πονηριασ ");
INSERT INTO grcmt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","αφρονεσ ουχ ο ποιησασ το εξωθεν και το εσωθεν εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","πλην τα ενοντα δοτε ελεημοσυνην και ιδου παντα καθαρα υμιν εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","αλλ ουαι υμιν τοισ φαρισαιοισ οτι αποδεκατουτε το ηδυοσμον και το πηγανον και παν λαχανον και παρερχεσθε την κρισιν και την αγαπην του θεου ταυτα εδει ποιησαι κακεινα μη αφιεναι ");
INSERT INTO grcmt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ουαι υμιν τοισ φαρισαιοισ οτι αγαπατε την πρωτοκαθεδριαν εν ταισ συναγωγαισ και τουσ ασπασμουσ εν ταισ αγοραισ ");
INSERT INTO grcmt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ουαι υμιν γραμματεισ και φαρισαιοι υποκριται οτι εστε ωσ τα μνημεια τα αδηλα και οι ανθρωποι περιπατουντεσ επανω ουκ οιδασιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","αποκριθεισ δε τισ των νομικων λεγει αυτω διδασκαλε ταυτα λεγων και ημασ υβριζεισ ");
INSERT INTO grcmt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ο δε ειπεν και υμιν τοισ νομικοισ ουαι οτι φορτιζετε τουσ ανθρωπουσ φορτια δυσβαστακτα και αυτοι ενι των δακτυλων υμων ου προσψαυετε τοισ φορτιοισ ");
INSERT INTO grcmt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ουαι υμιν οτι οικοδομειτε τα μνημεια των προφητων οι δε πατερεσ υμων απεκτειναν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","αρα μαρτυρειτε και συνευδοκειτε τοισ εργοισ των πατερων υμων οτι αυτοι μεν απεκτειναν αυτουσ υμεισ δε οικοδομειτε αυτων τα μνημεια ");
INSERT INTO grcmt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","δια τουτο και η σοφια του θεου ειπεν αποστελω εισ αυτουσ προφητασ και αποστολουσ και εξ αυτων αποκτενουσιν και εκδιωξουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ινα εκζητηθη το αιμα παντων των προφητων το εκχυνομενον απο καταβολησ κοσμου απο τησ γενεασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","απο του αιματοσ αβελ εωσ του αιματοσ ζαχαριου του απολομενου μεταξυ του θυσιαστηριου και του οικου ναι λεγω υμιν εκζητηθησεται απο τησ γενεασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ουαι υμιν τοισ νομικοισ οτι ηρατε την κλειδα τησ γνωσεωσ αυτοι ουκ εισηλθετε και τουσ εισερχομενουσ εκωλυσατε ");
INSERT INTO grcmt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","λεγοντοσ δε αυτου ταυτα προσ αυτουσ ηρξαντο οι γραμματεισ και οι φαρισαιοι δεινωσ ενεχειν και αποστοματιζειν αυτον περι πλειονων ");
INSERT INTO grcmt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ενεδρευοντεσ αυτον ζητουντεσ θηρευσαι τι εκ του στοματοσ αυτου ινα κατηγορησωσιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","εν οισ επισυναχθεισων των μυριαδων του οχλου ωστε καταπατειν αλληλουσ ηρξατο λεγειν προσ τουσ μαθητασ αυτου πρωτον προσεχετε εαυτοισ απο τησ ζυμησ των φαρισαιων ητισ εστιν υποκρισισ ");
INSERT INTO grcmt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ουδεν δε συγκεκαλυμμενον εστιν ο ουκ αποκαλυφθησεται και κρυπτον ο ου γνωσθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ανθ ων οσα εν τη σκοτια ειπατε εν τω φωτι ακουσθησεται και ο προσ το ουσ ελαλησατε εν τοισ ταμειοισ κηρυχθησεται επι των δωματων ");
INSERT INTO grcmt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","λεγω δε υμιν τοισ φιλοισ μου μη φοβηθητε απο των αποκτενοντων το σωμα και μετα ταυτα μη εχοντων περισσοτερον τι ποιησαι ");
INSERT INTO grcmt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","υποδειξω δε υμιν τινα φοβηθητε φοβηθητε τον μετα το αποκτειναι εξουσιαν εχοντα εμβαλειν εισ την γεενναν ναι λεγω υμιν τουτον φοβηθητε ");
INSERT INTO grcmt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ουχι πεντε στρουθια πωλειται ασσαριων δυο και εν εξ αυτων ουκ εστιν επιλελησμενον ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","αλλα και αι τριχεσ τησ κεφαλησ υμων πασαι ηριθμηνται μη ουν φοβεισθε πολλων στρουθιων διαφερετε ");
INSERT INTO grcmt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","λεγω δε υμιν πασ οσ αν ομολογηση εν εμοι εμπροσθεν των ανθρωπων και ο υιοσ του ανθρωπου ομολογησει εν αυτω εμπροσθεν των αγγελων του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ο δε αρνησαμενοσ με ενωπιον των ανθρωπων απαρνηθησεται ενωπιον των αγγελων του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","και πασ οσ ερει λογον εισ τον υιον του ανθρωπου αφεθησεται αυτω τω δε εισ το αγιον πνευμα βλασφημησαντι ουκ αφεθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","οταν δε προσφερωσιν υμασ επι τασ συναγωγασ και τασ αρχασ και τασ εξουσιασ μη μεριμνατε πωσ η τι απολογησησθε η τι ειπητε ");
INSERT INTO grcmt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","το γαρ αγιον πνευμα διδαξει υμασ εν αυτη τη ωρα α δει ειπειν ");
INSERT INTO grcmt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ειπεν δε τισ αυτω εκ του οχλου διδασκαλε ειπε τω αδελφω μου μερισασθαι μετ εμου την κληρονομιαν ");
INSERT INTO grcmt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ο δε ειπεν αυτω ανθρωπε τισ με κατεστησεν δικαστην η μεριστην εφ υμασ ");
INSERT INTO grcmt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ειπεν δε προσ αυτουσ ορατε και φυλασσεσθε απο τησ πλεονεξιασ οτι ουκ εν τω περισσευειν τινι η ζωη αυτω εστιν εκ των υπαρχοντων αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ειπεν δε παραβολην προσ αυτουσ λεγων ανθρωπου τινοσ πλουσιου ευφορησεν η χωρα ");
INSERT INTO grcmt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","και διελογιζετο εν εαυτω λεγων τι ποιησω οτι ουκ εχω που συναξω τουσ καρπουσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","και ειπεν τουτο ποιησω καθελω μου τασ αποθηκασ και μειζονασ οικοδομησω και συναξω εκει παντα τα γενηματα μου και τα αγαθα μου ");
INSERT INTO grcmt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","και ερω τη ψυχη μου ψυχη εχεισ πολλα αγαθα κειμενα εισ ετη πολλα αναπαυου φαγε πιε ευφραινου ");
INSERT INTO grcmt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ειπεν δε αυτω ο θεοσ αφρον ταυτη τη νυκτι την ψυχην σου απαιτουσιν απο σου α δε ητοιμασασ τινι εσται ");
INSERT INTO grcmt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ουτωσ ο θησαυριζων εαυτω και μη εισ θεον πλουτων ");
INSERT INTO grcmt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ειπεν δε προσ τουσ μαθητασ αυτου δια τουτο υμιν λεγω μη μεριμνατε τη ψυχη υμων τι φαγητε μηδε τω σωματι τι ενδυσησθε ");
INSERT INTO grcmt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","η ψυχη πλειον εστιν τησ τροφησ και το σωμα του ενδυματοσ ");
INSERT INTO grcmt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","κατανοησατε τουσ κορακασ οτι ου σπειρουσιν ουδε θεριζουσιν οισ ουκ εστιν ταμειον ουδε αποθηκη και ο θεοσ τρεφει αυτουσ ποσω μαλλον υμεισ διαφερετε των πετεινων ");
INSERT INTO grcmt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","τισ δε εξ υμων μεριμνων δυναται προσθειναι επι την ηλικιαν αυτου πηχυν ενα ");
INSERT INTO grcmt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ει ουν ουτε ελαχιστον δυνασθε τι περι των λοιπων μεριμνατε ");
INSERT INTO grcmt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","κατανοησατε τα κρινα πωσ αυξανει ου κοπια ουδε νηθει λεγω δε υμιν ουδε σολομων εν παση τη δοξη αυτου περιεβαλετο ωσ εν τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ει δε τον χορτον εν τω αγρω σημερον οντα και αυριον εισ κλιβανον βαλλομενον ο θεοσ ουτωσ αμφιεννυσιν ποσω μαλλον υμασ ολιγοπιστοι ");
INSERT INTO grcmt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","και υμεισ μη ζητειτε τι φαγητε η τι πιητε και μη μετεωριζεσθε ");
INSERT INTO grcmt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ταυτα γαρ παντα τα εθνη του κοσμου επιζητει υμων δε ο πατηρ οιδεν οτι χρηζετε τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","πλην ζητειτε την βασιλειαν του θεου και ταυτα παντα προστεθησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","μη φοβου το μικρον ποιμνιον οτι ευδοκησεν ο πατηρ υμων δουναι υμιν την βασιλειαν ");
INSERT INTO grcmt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","πωλησατε τα υπαρχοντα υμων και δοτε ελεημοσυνην ποιησατε εαυτοισ βαλαντια μη παλαιουμενα θησαυρον ανεκλειπτον εν τοισ ουρανοισ οπου κλεπτησ ουκ εγγιζει ουδε σησ διαφθειρει ");
INSERT INTO grcmt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","οπου γαρ εστιν ο θησαυροσ υμων εκει και η καρδια υμων εσται ");
INSERT INTO grcmt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","εστωσαν υμων αι οσφυεσ περιεζωσμεναι και οι λυχνοι καιομενοι ");
INSERT INTO grcmt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","και υμεισ ομοιοι ανθρωποισ προσδεχομενοισ τον κυριον εαυτων ποτε αναλυση εκ των γαμων ινα ελθοντοσ και κρουσαντοσ ευθεωσ ανοιξωσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","μακαριοι οι δουλοι εκεινοι ουσ ελθων ο κυριοσ ευρησει γρηγορουντασ αμην λεγω υμιν οτι περιζωσεται και ανακλινει αυτουσ και παρελθων διακονησει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","και εαν ελθη εν τη δευτερα φυλακη και εν τη τριτη φυλακη ελθη και ευρη ουτωσ μακαριοι εισιν οι δουλοι εκεινοι ");
INSERT INTO grcmt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","τουτο δε γινωσκετε οτι ει ηδει ο οικοδεσποτησ ποια ωρα ο κλεπτησ ερχεται εγρηγορησεν αν και ουκ αν αφηκεν διορυγηναι τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","και υμεισ ουν γινεσθε ετοιμοι οτι η ωρα ου δοκειτε ο υιοσ του ανθρωπου ερχεται ");
INSERT INTO grcmt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ειπεν δε αυτω ο πετροσ κυριε προσ ημασ την παραβολην ταυτην λεγεισ η και προσ παντασ ");
INSERT INTO grcmt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ειπεν δε ο κυριοσ τισ αρα εστιν ο πιστοσ οικονομοσ και φρονιμοσ ον καταστησει ο κυριοσ επι τησ θεραπειασ αυτου του διδοναι εν καιρω το σιτομετριον ");
INSERT INTO grcmt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","μακαριοσ ο δουλοσ εκεινοσ ον ελθων ο κυριοσ αυτου ευρησει ποιουντα ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","αληθωσ λεγω υμιν οτι επι πασιν τοισ υπαρχουσιν αυτου καταστησει αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","εαν δε ειπη ο δουλοσ εκεινοσ εν τη καρδια αυτου χρονιζει ο κυριοσ μου ερχεσθαι και αρξηται τυπτειν τουσ παιδασ και τασ παιδισκασ εσθιειν τε και πινειν και μεθυσκεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ηξει ο κυριοσ του δουλου εκεινου εν ημερα η ου προσδοκα και εν ωρα η ου γινωσκει και διχοτομησει αυτον και το μεροσ αυτου μετα των απιστων θησει ");
INSERT INTO grcmt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","εκεινοσ δε ο δουλοσ ο γνουσ το θελημα του κυριου εαυτου και μη ετοιμασασ μηδε ποιησασ προσ το θελημα αυτου δαρησεται πολλασ ");
INSERT INTO grcmt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ο δε μη γνουσ ποιησασ δε αξια πληγων δαρησεται ολιγασ παντι δε ω εδοθη πολυ πολυ ζητηθησεται παρ αυτου και ω παρεθεντο πολυ περισσοτερον αιτησουσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","πυρ ηλθον βαλειν εισ την γην και τι θελω ει ηδη ανηφθη ");
INSERT INTO grcmt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","βαπτισμα δε εχω βαπτισθηναι και πωσ συνεχομαι εωσ ου τελεσθη ");
INSERT INTO grcmt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","δοκειτε οτι ειρηνην παρεγενομην δουναι εν τη γη ουχι λεγω υμιν αλλ η διαμερισμον ");
INSERT INTO grcmt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","εσονται γαρ απο του νυν πεντε εν οικω ενι διαμεμερισμενοι τρεισ επι δυσιν και δυο επι τρισιν ");
INSERT INTO grcmt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","διαμερισθησεται πατηρ επι υιω και υιοσ επι πατρι μητηρ επι θυγατρι και θυγατηρ επι μητρι πενθερα επι την νυμφην αυτησ και νυμφη επι την πενθεραν αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ελεγεν δε και τοισ οχλοισ οταν ιδητε την νεφελην ανατελλουσαν απο δυσμων ευθεωσ λεγετε ομβροσ ερχεται και γινεται ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","και οταν νοτον πνεοντα λεγετε οτι καυσων εσται και γινεται ");
INSERT INTO grcmt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","υποκριται το προσωπον τησ γησ και του ουρανου οιδατε δοκιμαζειν τον δε καιρον τουτον πωσ ου δοκιμαζετε ");
INSERT INTO grcmt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","τι δε και αφ εαυτων ου κρινετε το δικαιον ");
INSERT INTO grcmt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ωσ γαρ υπαγεισ μετα του αντιδικου σου επ αρχοντα εν τη οδω δοσ εργασιαν απηλλαχθαι απ αυτου μηποτε κατασυρη σε προσ τον κριτην και ο κριτησ σε παραδω τω πρακτορι και ο πρακτωρ σε βαλη εισ φυλακην ");
INSERT INTO grcmt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","λεγω σοι ου μη εξελθησ εκειθεν εωσ ου και τον εσχατον λεπτον αποδωσ ");
INSERT INTO grcmt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","παρησαν δε τινεσ εν αυτω τω καιρω απαγγελλοντεσ αυτω περι των γαλιλαιων ων το αιμα πιλατοσ εμιξεν μετα των θυσιων αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","και αποκριθεισ ο ιησουσ ειπεν αυτοισ δοκειτε οτι οι γαλιλαιοι ουτοι αμαρτωλοι παρα παντασ τουσ γαλιλαιουσ εγενοντο οτι τοιαυτα πεπονθασιν ");
INSERT INTO grcmt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ουχι λεγω υμιν αλλ εαν μη μετανοητε παντεσ ωσαυτωσ απολεισθε ");
INSERT INTO grcmt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","η εκεινοι οι δεκα και οκτω εφ ουσ επεσεν ο πυργοσ εν τω σιλωαμ και απεκτεινεν αυτουσ δοκειτε οτι ουτοι οφειλεται εγενοντο παρα παντασ ανθρωπουσ τουσ κατοικουντασ εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ουχι λεγω υμιν αλλ εαν μη μετανοητε παντεσ ομοιωσ απολεισθε ");
INSERT INTO grcmt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ελεγεν δε ταυτην την παραβολην συκην ειχεν τισ εν τω αμπελωνι αυτου πεφυτευμενην και ηλθεν ζητων καρπον εν αυτη και ουχ ευρεν ");
INSERT INTO grcmt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ειπεν δε προσ τον αμπελουργον ιδου τρια ετη ερχομαι ζητων καρπον εν τη συκη ταυτη και ουχ ευρισκω εκκοψον αυτην ινα τι και την γην καταργει ");
INSERT INTO grcmt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ο δε αποκριθεισ λεγει αυτω κυριε αφεσ αυτην και τουτο το ετοσ εωσ οτου σκαψω περι αυτην και βαλω κοπρια ");
INSERT INTO grcmt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","καν μεν ποιηση καρπον ει δε μηγε εισ το μελλον εκκοψεισ αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ην δε διδασκων εν μια των συναγωγων εν τοισ σαββασιν ");
INSERT INTO grcmt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","και ιδου γυνη ην πνευμα εχουσα ασθενειασ ετη δεκα και οκτω και ην συγκυπτουσα και μη δυναμενη ανακυψαι εισ το παντελεσ ");
INSERT INTO grcmt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ιδων δε αυτην ο ιησουσ προσεφωνησεν και ειπεν αυτη γυναι απολελυσαι τησ ασθενειασ σου ");
INSERT INTO grcmt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","και επεθηκεν αυτη τασ χειρασ και παραχρημα ανωρθωθη και εδοξαζεν τον θεον ");
INSERT INTO grcmt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","αποκριθεισ δε ο αρχισυναγωγοσ αγανακτων οτι τω σαββατω εθεραπευσεν ο ιησουσ ελεγεν τω οχλω εξ ημεραι εισιν εν αισ δει εργαζεσθαι εν ταυταισ ουν ερχομενοι θεραπευεσθε και μη τη ημερα του σαββατου ");
INSERT INTO grcmt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","απεκριθη ουν αυτω ο κυριοσ και ειπεν υποκριται εκαστοσ υμων τω σαββατω ου λυει τον βουν αυτου η τον ονον απο τησ φατνησ και απαγαγων ποτιζει ");
INSERT INTO grcmt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ταυτην δε θυγατερα αβρααμ ουσαν ην εδησεν ο σατανασ ιδου δεκα και οκτω ετη ουκ εδει λυθηναι απο του δεσμου τουτου τη ημερα του σαββατου ");
INSERT INTO grcmt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","και ταυτα λεγοντοσ αυτου κατησχυνοντο παντεσ οι αντικειμενοι αυτω και πασ ο οχλοσ εχαιρεν επι πασιν τοισ ενδοξοισ τοισ γινομενοισ υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ελεγεν δε τινι ομοια εστιν η βασιλεια του θεου και τινι ομοιωσω αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ομοια εστιν κοκκω σιναπεωσ ον λαβων ανθρωποσ εβαλεν εισ κηπον εαυτου και ηυξησεν και εγενετο εισ δενδρον μεγα και τα πετεινα του ουρανου κατεσκηνωσεν εν τοισ κλαδοισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","παλιν ειπεν τινι ομοιωσω την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ομοια εστιν ζυμη ην λαβουσα γυνη ενεκρυψεν εισ αλευρου σατα τρια εωσ ου εζυμωθη ολον ");
INSERT INTO grcmt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","και διεπορευετο κατα πολεισ και κωμασ διδασκων και πορειαν ποιουμενοσ εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ειπεν δε τισ αυτω κυριε ει ολιγοι οι σωζομενοι ο δε ειπεν προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","αγωνιζεσθε εισελθειν δια τησ στενησ πυλησ οτι πολλοι λεγω υμιν ζητησουσιν εισελθειν και ουκ ισχυσουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","αφ ου αν εγερθη ο οικοδεσποτησ και αποκλειση την θυραν και αρξησθε εξω εσταναι και κρουειν την θυραν λεγοντεσ κυριε κυριε ανοιξον ημιν και αποκριθεισ ερει υμιν ουκ οιδα υμασ ποθεν εστε ");
INSERT INTO grcmt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","τοτε αρξεσθε λεγειν εφαγομεν ενωπιον σου και επιομεν και εν ταισ πλατειαισ ημων εδιδαξασ ");
INSERT INTO grcmt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","και ερει λεγω υμιν ουκ οιδα υμασ ποθεν εστε αποστητε απ εμου παντεσ οι εργαται τησ αδικιασ ");
INSERT INTO grcmt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","εκει εσται ο κλαυθμοσ και ο βρυγμοσ των οδοντων οταν οψησθε αβρααμ και ισαακ και ιακωβ και παντασ τουσ προφητασ εν τη βασιλεια του θεου υμασ δε εκβαλλομενουσ εξω ");
INSERT INTO grcmt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","και ηξουσιν απο ανατολων και δυσμων και βορρα και νοτου και ανακλιθησονται εν τη βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","και ιδου εισιν εσχατοι οι εσονται πρωτοι και εισιν πρωτοι οι εσονται εσχατοι ");
INSERT INTO grcmt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","εν αυτη τη ημερα προσηλθον τινεσ φαρισαιοι λεγοντεσ αυτω εξελθε και πορευου εντευθεν οτι ηρωδησ θελει σε αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","και ειπεν αυτοισ πορευθεντεσ ειπατε τη αλωπεκι ταυτη ιδου εκβαλλω δαιμονια και ιασεισ επιτελω σημερον και αυριον και τη τριτη τελειουμαι ");
INSERT INTO grcmt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","πλην δει με σημερον και αυριον και τη εχομενη πορευεσθαι οτι ουκ ενδεχεται προφητην απολεσθαι εξω ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ιερουσαλημ ιερουσαλημ η αποκτενουσα τουσ προφητασ και λιθοβολουσα τουσ απεσταλμενουσ προσ αυτην ποσακισ ηθελησα επισυναξαι τα τεκνα σου ον τροπον ορνισ την εαυτησ νοσσιαν υπο τασ πτερυγασ και ουκ ηθελησατε ");
INSERT INTO grcmt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ιδου αφιεται υμιν ο οικοσ υμων ερημοσ λεγω δε υμιν οτι ου μη με ιδητε εωσ αν ηξει οτε ειπητε ευλογημενοσ ο ερχομενοσ εν ονοματι κυριου ");
INSERT INTO grcmt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","και εγενετο εν τω ελθειν αυτον εισ οικον τινοσ των αρχοντων των φαρισαιων σαββατω φαγειν αρτον και αυτοι ησαν παρατηρουμενοι αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","και ιδου ανθρωποσ τισ ην υδρωπικοσ εμπροσθεν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","και αποκριθεισ ο ιησουσ ειπεν προσ τουσ νομικουσ και φαρισαιουσ λεγων ει εξεστιν τω σαββατω θεραπευειν ");
INSERT INTO grcmt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","οι δε ησυχασαν και επιλαβομενοσ ιασατο αυτον και απελυσεν ");
INSERT INTO grcmt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","και αποκριθεισ προσ αυτουσ ειπεν τινοσ υμων υιοσ η βουσ εισ φρεαρ εμπεσειται και ουκ ευθεωσ ανασπασει αυτον εν τη ημερα του σαββατου ");
INSERT INTO grcmt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","και ουκ ισχυσαν ανταποκριθηναι αυτω προσ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ελεγεν δε προσ τουσ κεκλημενουσ παραβολην επεχων πωσ τασ πρωτοκλισιασ εξελεγοντο λεγων προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","οταν κληθησ υπο τινοσ εισ γαμουσ μη κατακλιθησ εισ την πρωτοκλισιαν μηποτε εντιμοτεροσ σου η κεκλημενοσ υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","και ελθων ο σε και αυτον καλεσασ ερει σοι δοσ τουτω τοπον και τοτε αρξη μετ αισχυνησ τον εσχατον τοπον κατεχειν ");
INSERT INTO grcmt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","αλλ οταν κληθησ πορευθεισ αναπεσε εισ τον εσχατον τοπον ινα οταν ελθη ο κεκληκωσ σε ειπη σοι φιλε προσαναβηθι ανωτερον τοτε εσται σοι δοξα ενωπιον των συνανακειμενων σοι ");
INSERT INTO grcmt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","οτι πασ ο υψων εαυτον ταπεινωθησεται και ο ταπεινων εαυτον υψωθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ελεγεν δε και τω κεκληκοτι αυτον οταν ποιησ αριστον η δειπνον μη φωνει τουσ φιλουσ σου μηδε τουσ αδελφουσ σου μηδε τουσ συγγενεισ σου μηδε γειτονασ πλουσιουσ μηποτε και αυτοι σε αντικαλεσωσιν και γενηται σοι ανταποδομα ");
INSERT INTO grcmt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","αλλ οταν ποιησ δοχην καλει πτωχουσ αναπηρουσ χωλουσ τυφλουσ ");
INSERT INTO grcmt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","και μακαριοσ εση οτι ουκ εχουσιν ανταποδουναι σοι ανταποδοθησεται γαρ σοι εν τη αναστασει των δικαιων ");
INSERT INTO grcmt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ακουσασ δε τισ των συνανακειμενων ταυτα ειπεν αυτω μακαριοσ οσ φαγεται αριστον εν τη βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ο δε ειπεν αυτω ανθρωποσ τισ εποιησεν δειπνον μεγα και εκαλεσεν πολλουσ ");
INSERT INTO grcmt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","και απεστειλεν τον δουλον αυτου τη ωρα του δειπνου ειπειν τοισ κεκλημενοισ ερχεσθε οτι ηδη ετοιμα εστιν παντα ");
INSERT INTO grcmt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","και ηρξαντο απο μιασ παραιτεισθαι παντεσ ο πρωτοσ ειπεν αυτω αγρον ηγορασα και εχω αναγκην εξελθειν και ιδειν αυτον ερωτω σε εχε με παρητημενον ");
INSERT INTO grcmt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","και ετεροσ ειπεν ζευγη βοων ηγορασα πεντε και πορευομαι δοκιμασαι αυτα ερωτω σε εχε με παρητημενον ");
INSERT INTO grcmt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","και ετεροσ ειπεν γυναικα εγημα και δια τουτο ου δυναμαι ελθειν ");
INSERT INTO grcmt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","και παραγενομενοσ ο δουλοσ εκεινοσ απηγγειλεν τω κυριω αυτου ταυτα τοτε οργισθεισ ο οικοδεσποτησ ειπεν τω δουλω αυτου εξελθε ταχεωσ εισ τασ πλατειασ και ρυμασ τησ πολεωσ και τουσ πτωχουσ και αναπηρουσ και χωλουσ και τυφλουσ εισαγαγε ωδε ");
INSERT INTO grcmt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","και ειπεν ο δουλοσ κυριε γεγονεν ωσ επεταξασ και ετι τοποσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","και ειπεν ο κυριοσ προσ τον δουλον εξελθε εισ τασ οδουσ και φραγμουσ και αναγκασον εισελθειν ινα γεμισθη ο οικοσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","λεγω γαρ υμιν οτι ουδεισ των ανδρων εκεινων των κεκλημενων γευσεται μου του δειπνου πολλοι γαρ εισιν κλητοι ολιγοι δε εκλεκτοι ");
INSERT INTO grcmt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","συνεπορευοντο δε αυτω οχλοι πολλοι και στραφεισ ειπεν προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ει τισ ερχεται προσ με και ου μισει τον πατερα αυτου και την μητερα και την γυναικα και τα τεκνα και τουσ αδελφουσ και τασ αδελφασ ετι δε και την εαυτου ψυχην ου δυναται μου μαθητησ ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","και οστισ ου βασταζει τον σταυρον αυτου και ερχεται οπισω μου ου δυναται ειναι μου μαθητησ ");
INSERT INTO grcmt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","τισ γαρ εξ υμων ο θελων πυργον οικοδομησαι ουχι πρωτον καθισασ ψηφιζει την δαπανην ει εχει τα εισ απαρτισμον ");
INSERT INTO grcmt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ινα μηποτε θεντοσ αυτου θεμελιον και μη ισχυοντοσ εκτελεσαι παντεσ οι θεωρουντεσ αρξωνται εμπαιζειν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","λεγοντεσ οτι ουτοσ ο ανθρωποσ ηρξατο οικοδομειν και ουκ ισχυσεν εκτελεσαι ");
INSERT INTO grcmt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","η τισ βασιλευσ πορευομενοσ συμβαλειν ετερω βασιλει εισ πολεμον ουχι καθισασ πρωτον βουλευεται ει δυνατοσ εστιν εν δεκα χιλιασιν απαντησαι τω μετα εικοσι χιλιαδων ερχομενω επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ει δε μηγε ετι πορρω αυτου οντοσ πρεσβειαν αποστειλασ ερωτα τα προσ ειρηνην ");
INSERT INTO grcmt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ουτωσ ουν πασ εξ υμων οσ ουκ αποτασσεται πασιν τοισ εαυτου υπαρχουσιν ου δυναται μου ειναι μαθητησ ");
INSERT INTO grcmt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","καλον το αλασ εαν δε το αλασ μωρανθη εν τινι αρτυθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ουτε εισ γην ουτε εισ κοπριαν ευθετον εστιν εξω βαλλουσιν αυτο ο εχων ωτα ακουειν ακουετω ");
INSERT INTO grcmt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ησαν δε εγγιζοντεσ αυτω παντεσ οι τελωναι και οι αμαρτωλοι ακουειν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","και διεγογγυζον οι φαρισαιοι και οι γραμματεισ λεγοντεσ οτι ουτοσ αμαρτωλουσ προσδεχεται και συνεσθιει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ειπεν δε προσ αυτουσ την παραβολην ταυτην λεγων ");
INSERT INTO grcmt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","τισ ανθρωποσ εξ υμων εχων εκατον προβατα και απολεσασ εν εξ αυτων ου καταλειπει τα ενενηκοντα εννεα εν τη ερημω και πορευεται επι το απολωλοσ εωσ ευρη αυτο ");
INSERT INTO grcmt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","και ευρων επιτιθησιν επι τουσ ωμουσ εαυτου χαιρων ");
INSERT INTO grcmt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","και ελθων εισ τον οικον συγκαλει τουσ φιλουσ και τουσ γειτονασ λεγων αυτοισ συγχαρητε μοι οτι ευρον το προβατον μου το απολωλοσ ");
INSERT INTO grcmt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","λεγω υμιν οτι ουτωσ χαρα εσται εν τω ουρανω επι ενι αμαρτωλω μετανοουντι η επι ενενηκοντα εννεα δικαιοισ οιτινεσ ου χρειαν εχουσιν μετανοιασ ");
INSERT INTO grcmt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","η τισ γυνη δραχμασ εχουσα δεκα εαν απολεση δραχμην μιαν ουχι απτει λυχνον και σαροι την οικιαν και ζητει επιμελωσ εωσ οτου ευρη ");
INSERT INTO grcmt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","και ευρουσα συγκαλειται τασ φιλασ και τασ γειτονασ λεγουσα συγχαρητε μοι οτι ευρον την δραχμην ην απωλεσα ");
INSERT INTO grcmt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ουτωσ λεγω υμιν χαρα γινεται ενωπιον των αγγελων του θεου επι ενι αμαρτωλω μετανοουντι ");
INSERT INTO grcmt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ειπεν δε ανθρωποσ τισ ειχεν δυο υιουσ ");
INSERT INTO grcmt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","και ειπεν ο νεωτεροσ αυτων τω πατρι πατερ δοσ μοι το επιβαλλον μεροσ τησ ουσιασ και διειλεν αυτοισ τον βιον ");
INSERT INTO grcmt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","και μετ ου πολλασ ημερασ συναγαγων απαντα ο νεωτεροσ υιοσ απεδημησεν εισ χωραν μακραν και εκει διεσκορπισεν την ουσιαν αυτου ζων ασωτωσ ");
INSERT INTO grcmt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","δαπανησαντοσ δε αυτου παντα εγενετο λιμοσ ισχυροσ κατα την χωραν εκεινην και αυτοσ ηρξατο υστερεισθαι ");
INSERT INTO grcmt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","και πορευθεισ εκολληθη ενι των πολιτων τησ χωρασ εκεινησ και επεμψεν αυτον εισ τουσ αγρουσ αυτου βοσκειν χοιρουσ ");
INSERT INTO grcmt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","και επεθυμει γεμισαι την κοιλιαν αυτου απο των κερατιων ων ησθιον οι χοιροι και ουδεισ εδιδου αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","εισ εαυτον δε ελθων ειπεν ποσοι μισθιοι του πατροσ μου περισσευουσιν αρτων εγω δε λιμω απολλυμαι ");
INSERT INTO grcmt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","αναστασ πορευσομαι προσ τον πατερα μου και ερω αυτω πατερ ημαρτον εισ τον ουρανον και ενωπιον σου ");
INSERT INTO grcmt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","και ουκετι ειμι αξιοσ κληθηναι υιοσ σου ποιησον με ωσ ενα των μισθιων σου ");
INSERT INTO grcmt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","και αναστασ ηλθεν προσ τον πατερα αυτου ετι δε αυτου μακραν απεχοντοσ ειδεν αυτον ο πατηρ αυτου και εσπλαγχνισθη και δραμων επεπεσεν επι τον τραχηλον αυτου και κατεφιλησεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ειπεν δε αυτω ο υιοσ πατερ ημαρτον εισ τον ουρανον και ενωπιον σου και ουκετι ειμι αξιοσ κληθηναι υιοσ σου ");
INSERT INTO grcmt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ειπεν δε ο πατηρ προσ τουσ δουλουσ αυτου εξενεγκατε την στολην την πρωτην και ενδυσατε αυτον και δοτε δακτυλιον εισ την χειρα αυτου και υποδηματα εισ τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","και ενεγκαντεσ τον μοσχον τον σιτευτον θυσατε και φαγοντεσ ευφρανθωμεν ");
INSERT INTO grcmt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","οτι ουτοσ ο υιοσ μου νεκροσ ην και ανεζησεν και απολωλωσ ην και ευρεθη και ηρξαντο ευφραινεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ην δε ο υιοσ αυτου ο πρεσβυτεροσ εν αγρω και ωσ ερχομενοσ ηγγισεν τη οικια ηκουσεν συμφωνιασ και χορων ");
INSERT INTO grcmt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","και προσκαλεσαμενοσ ενα των παιδων επυνθανετο τι ειη ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ο δε ειπεν αυτω οτι ο αδελφοσ σου ηκει και εθυσεν ο πατηρ σου τον μοσχον τον σιτευτον οτι υγιαινοντα αυτον απελαβεν ");
INSERT INTO grcmt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ωργισθη δε και ουκ ηθελεν εισελθειν ο ουν πατηρ αυτου εξελθων παρεκαλει αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ο δε αποκριθεισ ειπεν τω πατρι ιδου τοσαυτα ετη δουλευω σοι και ουδεποτε εντολην σου παρηλθον και εμοι ουδεποτε εδωκασ εριφον ινα μετα των φιλων μου ευφρανθω ");
INSERT INTO grcmt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","οτε δε ο υιοσ σου ουτοσ ο καταφαγων σου τον βιον μετα πορνων ηλθεν εθυσασ αυτω τον μοσχον τον σιτευτον ");
INSERT INTO grcmt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ο δε ειπεν αυτω τεκνον συ παντοτε μετ εμου ει και παντα τα εμα σα εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ευφρανθηναι δε και χαρηναι εδει οτι ο αδελφοσ σου ουτοσ νεκροσ ην και ανεζησεν και απολωλωσ ην και ευρεθη ");
INSERT INTO grcmt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ελεγεν δε και προσ τουσ μαθητασ αυτου ανθρωποσ τισ ην πλουσιοσ οσ ειχεν οικονομον και ουτοσ διεβληθη αυτω ωσ διασκορπιζων τα υπαρχοντα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","και φωνησασ αυτον ειπεν αυτω τι τουτο ακουω περι σου αποδοσ τον λογον τησ οικονομιασ σου ου γαρ δυνηση ετι οικονομειν ");
INSERT INTO grcmt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ειπεν δε εν εαυτω ο οικονομοσ τι ποιησω οτι ο κυριοσ μου αφαιρειται την οικονομιαν απ εμου σκαπτειν ουκ ισχυω επαιτειν αισχυνομαι ");
INSERT INTO grcmt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","εγνων τι ποιησω ινα οταν μετασταθω τησ οικονομιασ δεξωνται με εισ τουσ οικουσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","και προσκαλεσαμενοσ ενα εκαστον των χρεωφειλετων του κυριου εαυτου ελεγεν τω πρωτω ποσον οφειλεισ τω κυριω μου ");
INSERT INTO grcmt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ο δε ειπεν εκατον βατουσ ελαιου και ειπεν αυτω δεξαι σου το γραμμα και καθισασ ταχεωσ γραψον πεντηκοντα ");
INSERT INTO grcmt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","επειτα ετερω ειπεν συ δε ποσον οφειλεισ ο δε ειπεν εκατον κορουσ σιτου και λεγει αυτω δεξαι σου το γραμμα και γραψον ογδοηκοντα ");
INSERT INTO grcmt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","και επηνεσεν ο κυριοσ τον οικονομον τησ αδικιασ οτι φρονιμωσ εποιησεν οτι οι υιοι του αιωνοσ τουτου φρονιμωτεροι υπερ τουσ υιουσ του φωτοσ εισ την γενεαν την εαυτων εισιν ");
INSERT INTO grcmt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","καγω υμιν λεγω ποιησατε εαυτοισ φιλουσ εκ του μαμωνα τησ αδικιασ ινα οταν εκλιπητε δεξωνται υμασ εισ τασ αιωνιουσ σκηνασ ");
INSERT INTO grcmt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ο πιστοσ εν ελαχιστω και εν πολλω πιστοσ εστιν και ο εν ελαχιστω αδικοσ και εν πολλω αδικοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ει ουν εν τω αδικω μαμωνα πιστοι ουκ εγενεσθε το αληθινον τισ υμιν πιστευσει ");
INSERT INTO grcmt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","και ει εν τω αλλοτριω πιστοι ουκ εγενεσθε το υμετερον τισ υμιν δωσει ");
INSERT INTO grcmt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ουδεισ οικετησ δυναται δυσιν κυριοισ δουλευειν η γαρ τον ενα μισησει και τον ετερον αγαπησει η ενοσ ανθεξεται και του ετερου καταφρονησει ου δυνασθε θεω δουλευειν και μαμωνα ");
INSERT INTO grcmt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ηκουον δε ταυτα παντα και οι φαρισαιοι φιλαργυροι υπαρχοντεσ και εξεμυκτηριζον αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","και ειπεν αυτοισ υμεισ εστε οι δικαιουντεσ εαυτουσ ενωπιον των ανθρωπων ο δε θεοσ γινωσκει τασ καρδιασ υμων οτι το εν ανθρωποισ υψηλον βδελυγμα ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ο νομοσ και οι προφηται εωσ ιωαννου απο τοτε η βασιλεια του θεου ευαγγελιζεται και πασ εισ αυτην βιαζεται ");
INSERT INTO grcmt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ευκοπωτερον δε εστιν τον ουρανον και την γην παρελθειν η του νομου μιαν κεραιαν πεσειν ");
INSERT INTO grcmt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","πασ ο απολυων την γυναικα αυτου και γαμων ετεραν μοιχευει και πασ ο απολελυμενην απο ανδροσ γαμων μοιχευει ");
INSERT INTO grcmt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ανθρωποσ δε τισ ην πλουσιοσ και ενεδιδυσκετο πορφυραν και βυσσον ευφραινομενοσ καθ ημεραν λαμπρωσ ");
INSERT INTO grcmt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","πτωχοσ δε τισ ην ονοματι λαζαροσ οσ εβεβλητο προσ τον πυλωνα αυτου ηλκωμενοσ ");
INSERT INTO grcmt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","και επιθυμων χορτασθηναι απο των ψιχιων των πιπτοντων απο τησ τραπεζησ του πλουσιου αλλα και οι κυνεσ ερχομενοι απελειχον τα ελκη αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","εγενετο δε αποθανειν τον πτωχον και απενεχθηναι αυτον υπο των αγγελων εισ τον κολπον αβρααμ απεθανεν δε και ο πλουσιοσ και εταφη ");
INSERT INTO grcmt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","και εν τω αδη επαρασ τουσ οφθαλμουσ αυτου υπαρχων εν βασανοισ ορα τον αβρααμ απο μακροθεν και λαζαρον εν τοισ κολποισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","και αυτοσ φωνησασ ειπεν πατερ αβρααμ ελεησον με και πεμψον λαζαρον ινα βαψη το ακρον του δακτυλου αυτου υδατοσ και καταψυξη την γλωσσαν μου οτι οδυνωμαι εν τη φλογι ταυτη ");
INSERT INTO grcmt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ειπεν δε αβρααμ τεκνον μνησθητι οτι απελαβεσ συ τα αγαθα σου εν τη ζωη σου και λαζαροσ ομοιωσ τα κακα νυν δε ωδε παρακαλειται συ δε οδυνασαι ");
INSERT INTO grcmt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","και επι πασιν τουτοισ μεταξυ ημων και υμων χασμα μεγα εστηρικται οπωσ οι θελοντεσ διαβηναι ενθεν προσ υμασ μη δυνωνται μηδε οι εκειθεν προσ ημασ διαπερωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ειπεν δε ερωτω ουν σε πατερ ινα πεμψησ αυτον εισ τον οικον του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","εχω γαρ πεντε αδελφουσ οπωσ διαμαρτυρηται αυτοισ ινα μη και αυτοι ελθωσιν εισ τον τοπον τουτον τησ βασανου ");
INSERT INTO grcmt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","λεγει αυτω αβρααμ εχουσιν μωσεα και τουσ προφητασ ακουσατωσαν αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ο δε ειπεν ουχι πατερ αβρααμ αλλ εαν τισ απο νεκρων πορευθη προσ αυτουσ μετανοησουσιν ");
INSERT INTO grcmt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ειπεν δε αυτω ει μωσεωσ και των προφητων ουκ ακουουσιν ουδε εαν τισ εκ νεκρων αναστη πεισθησονται ");
INSERT INTO grcmt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ειπεν δε προσ τουσ μαθητασ ανενδεκτον εστιν του μη ελθειν τα σκανδαλα ουαι δε δι ου ερχεται ");
INSERT INTO grcmt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","λυσιτελει αυτω ει μυλοσ ονικοσ περικειται περι τον τραχηλον αυτου και ερριπται εισ την θαλασσαν η ινα σκανδαλιση ενα των μικρων τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","προσεχετε εαυτοισ εαν δε αμαρτη εισ σε ο αδελφοσ σου επιτιμησον αυτω και εαν μετανοηση αφεσ αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","και εαν επτακισ τησ ημερασ αμαρτη εισ σε και επτακισ τησ ημερασ επιστρεψη λεγων μετανοω αφησεισ αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","και ειπον οι αποστολοι τω κυριω προσθεσ ημιν πιστιν ");
INSERT INTO grcmt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ειπεν δε ο κυριοσ ει εχετε πιστιν ωσ κοκκον σιναπεωσ ελεγετε αν τη συκαμινω ταυτη εκριζωθητι και φυτευθητι εν τη θαλασση και υπηκουσεν αν υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","τισ δε εξ υμων δουλον εχων αροτριωντα η ποιμαινοντα οσ εισελθοντι εκ του αγρου ερει ευθεωσ παρελθων αναπεσε ");
INSERT INTO grcmt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","αλλ ουχι ερει αυτω ετοιμασον τι δειπνησω και περιζωσαμενοσ διακονει μοι εωσ φαγω και πιω και μετα ταυτα φαγεσαι και πιεσαι συ ");
INSERT INTO grcmt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","μη χαριν εχει τω δουλω εκεινω οτι εποιησεν τα διαταχθεντα ου δοκω ");
INSERT INTO grcmt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ουτωσ και υμεισ οταν ποιησητε παντα τα διαταχθεντα υμιν λεγετε οτι δουλοι αχρειοι εσμεν οτι ο οφειλομεν ποιησαι πεποιηκαμεν ");
INSERT INTO grcmt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","και εγενετο εν τω πορευεσθαι αυτον εισ ιερουσαλημ και αυτοσ διηρχετο δια μεσου σαμαρειασ και γαλιλαιασ ");
INSERT INTO grcmt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","και εισερχομενου αυτου εισ τινα κωμην απηντησαν αυτω δεκα λεπροι ανδρεσ οι εστησαν πορρωθεν ");
INSERT INTO grcmt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","και αυτοι ηραν φωνην λεγοντεσ ιησου επιστατα ελεησον ημασ ");
INSERT INTO grcmt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","και ιδων ειπεν αυτοισ πορευθεντεσ επιδειξατε εαυτουσ τοισ ιερευσιν και εγενετο εν τω υπαγειν αυτουσ εκαθαρισθησαν ");
INSERT INTO grcmt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","εισ δε εξ αυτων ιδων οτι ιαθη υπεστρεψεν μετα φωνησ μεγαλησ δοξαζων τον θεον ");
INSERT INTO grcmt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","και επεσεν επι προσωπον παρα τουσ ποδασ αυτου ευχαριστων αυτω και αυτοσ ην σαμαρειτησ ");
INSERT INTO grcmt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","αποκριθεισ δε ο ιησουσ ειπεν ουχι οι δεκα εκαθαρισθησαν οι δε εννεα που ");
INSERT INTO grcmt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ουχ ευρεθησαν υποστρεψαντεσ δουναι δοξαν τω θεω ει μη ο αλλογενησ ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","και ειπεν αυτω αναστασ πορευου η πιστισ σου σεσωκεν σε ");
INSERT INTO grcmt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","επερωτηθεισ δε υπο των φαρισαιων ποτε ερχεται η βασιλεια του θεου απεκριθη αυτοισ και ειπεν ουκ ερχεται η βασιλεια του θεου μετα παρατηρησεωσ ");
INSERT INTO grcmt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ουδε ερουσιν ιδου ωδε η ιδου εκει ιδου γαρ η βασιλεια του θεου εντοσ υμων εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ειπεν δε προσ τουσ μαθητασ ελευσονται ημεραι οτε επιθυμησετε μιαν των ημερων του υιου του ανθρωπου ιδειν και ουκ οψεσθε ");
INSERT INTO grcmt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","και ερουσιν υμιν ιδου ωδε η ιδου εκει μη απελθητε μηδε διωξητε ");
INSERT INTO grcmt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ωσπερ γαρ η αστραπη η αστραπτουσα εκ τησ υπ ουρανον εισ την υπ ουρανον λαμπει ουτωσ εσται ο υιοσ του ανθρωπου εν τη ημερα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","πρωτον δε δει αυτον πολλα παθειν και αποδοκιμασθηναι απο τησ γενεασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","και καθωσ εγενετο εν ταισ ημεραισ νωε ουτωσ εσται και εν ταισ ημεραισ του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ησθιον επινον εγαμουν εξεγαμιζοντο αχρι ησ ημερασ εισηλθεν νωε εισ την κιβωτον και ηλθεν ο κατακλυσμοσ και απωλεσεν απαντασ ");
INSERT INTO grcmt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ομοιωσ και ωσ εγενετο εν ταισ ημεραισ λωτ ησθιον επινον ηγοραζον επωλουν εφυτευον ωκοδομουν ");
INSERT INTO grcmt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","η δε ημερα εξηλθεν λωτ απο σοδομων εβρεξεν πυρ και θειον απ ουρανου και απωλεσεν απαντασ ");
INSERT INTO grcmt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","κατα ταυτα εσται η ημερα ο υιοσ του ανθρωπου αποκαλυπτεται ");
INSERT INTO grcmt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","εν εκεινη τη ημερα οσ εσται επι του δωματοσ και τα σκευη αυτου εν τη οικια μη καταβατω αραι αυτα και ο εν τω αγρω ομοιωσ μη επιστρεψατω εισ τα οπισω ");
INSERT INTO grcmt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","μνημονευετε τησ γυναικοσ λωτ ");
INSERT INTO grcmt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","οσ εαν ζητηση την ψυχην αυτου σωσαι απολεσει αυτην και οσ εαν απολεση αυτην ζωογονησει αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","λεγω υμιν ταυτη τη νυκτι εσονται δυο επι κλινησ μιασ εισ παραληφθησεται και ο ετεροσ αφεθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","δυο εσονται αληθουσαι επι το αυτο μια παραληφθησεται και η ετερα αφεθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37"," και αποκριθεντεσ λεγουσιν αυτω που κυριε ο δε ειπεν αυτοισ οπου το σωμα εκει συναχθησονται οι αετοι ");
INSERT INTO grcmt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ελεγεν δε και παραβολην αυτοισ προσ το δειν παντοτε προσευχεσθαι και μη εκκακειν ");
INSERT INTO grcmt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","λεγων κριτησ τισ ην εν τινι πολει τον θεον μη φοβουμενοσ και ανθρωπον μη εντρεπομενοσ ");
INSERT INTO grcmt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","χηρα δε ην εν τη πολει εκεινη και ηρχετο προσ αυτον λεγουσα εκδικησον με απο του αντιδικου μου ");
INSERT INTO grcmt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","και ουκ ηθελησεν επι χρονον μετα δε ταυτα ειπεν εν εαυτω ει και τον θεον ου φοβουμαι και ανθρωπον ουκ εντρεπομαι ");
INSERT INTO grcmt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","δια γε το παρεχειν μοι κοπον την χηραν ταυτην εκδικησω αυτην ινα μη εισ τελοσ ερχομενη υποπιαζη με ");
INSERT INTO grcmt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ειπεν δε ο κυριοσ ακουσατε τι ο κριτησ τησ αδικιασ λεγει ");
INSERT INTO grcmt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ο δε θεοσ ου μη ποιηση την εκδικησιν των εκλεκτων αυτου των βοωντων προσ αυτον ημερασ και νυκτοσ και μακροθυμων επ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","λεγω υμιν οτι ποιησει την εκδικησιν αυτων εν ταχει πλην ο υιοσ του ανθρωπου ελθων αρα ευρησει την πιστιν επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ειπεν δε προσ τινασ τουσ πεποιθοτασ εφ εαυτοισ οτι εισιν δικαιοι και εξουθενουντασ τουσ λοιπουσ την παραβολην ταυτην ");
INSERT INTO grcmt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ανθρωποι δυο ανεβησαν εισ το ιερον προσευξασθαι ο εισ φαρισαιοσ και ο ετεροσ τελωνησ ");
INSERT INTO grcmt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ο φαρισαιοσ σταθεισ προσ εαυτον ταυτα προσηυχετο ο θεοσ ευχαριστω σοι οτι ουκ ειμι ωσπερ οι λοιποι των ανθρωπων αρπαγεσ αδικοι μοιχοι η και ωσ ουτοσ ο τελωνησ ");
INSERT INTO grcmt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","νηστευω δισ του σαββατου αποδεκατω παντα οσα κτωμαι ");
INSERT INTO grcmt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","και ο τελωνησ μακροθεν εστωσ ουκ ηθελεν ουδε τουσ οφθαλμουσ εισ τον ουρανον επαραι αλλ ετυπτεν εισ το στηθοσ αυτου λεγων ο θεοσ ιλασθητι μοι τω αμαρτωλω ");
INSERT INTO grcmt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","λεγω υμιν κατεβη ουτοσ δεδικαιωμενοσ εισ τον οικον αυτου η γαρ εκεινοσ οτι πασ ο υψων εαυτον ταπεινωθησεται ο δε ταπεινων εαυτον υψωθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","προσεφερον δε αυτω και τα βρεφη ινα αυτων απτηται ιδοντεσ δε οι μαθηται επετιμησαν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ο δε ιησουσ προσκαλεσαμενοσ αυτα ειπεν αφετε τα παιδια ερχεσθαι προσ με και μη κωλυετε αυτα των γαρ τοιουτων εστιν η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","αμην λεγω υμιν οσ εαν μη δεξηται την βασιλειαν του θεου ωσ παιδιον ου μη εισελθη εισ αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","και επηρωτησεν τισ αυτον αρχων λεγων διδασκαλε αγαθε τι ποιησασ ζωην αιωνιον κληρονομησω ");
INSERT INTO grcmt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ειπεν δε αυτω ο ιησουσ τι με λεγεισ αγαθον ουδεισ αγαθοσ ει μη εισ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","τασ εντολασ οιδασ μη μοιχευσησ μη φονευσησ μη κλεψησ μη ψευδομαρτυρησησ τιμα τον πατερα σου και την μητερα σου ");
INSERT INTO grcmt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ο δε ειπεν ταυτα παντα εφυλαξαμην εκ νεοτητοσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ακουσασ δε ταυτα ο ιησουσ ειπεν αυτω ετι εν σοι λειπει παντα οσα εχεισ πωλησον και διαδοσ πτωχοισ και εξεισ θησαυρον εν ουρανω και δευρο ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ο δε ακουσασ ταυτα περιλυποσ εγενετο ην γαρ πλουσιοσ σφοδρα ");
INSERT INTO grcmt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ιδων δε αυτον ο ιησουσ περιλυπον γενομενον ειπεν πωσ δυσκολωσ οι τα χρηματα εχοντεσ εισελευσονται εισ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ευκοπωτερον γαρ εστιν καμηλον δια τρυμαλιασ ραφιδοσ εισελθειν η πλουσιον εισ την βασιλειαν του θεου εισελθειν ");
INSERT INTO grcmt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ειπον δε οι ακουσαντεσ και τισ δυναται σωθηναι ");
INSERT INTO grcmt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ο δε ειπεν τα αδυνατα παρα ανθρωποισ δυνατα εστιν παρα τω θεω ");
INSERT INTO grcmt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ειπεν δε πετροσ ιδου ημεισ αφηκαμεν παντα και ηκολουθησαμεν σοι ");
INSERT INTO grcmt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ο δε ειπεν αυτοισ αμην λεγω υμιν οτι ουδεισ εστιν οσ αφηκεν οικιαν η γονεισ η αδελφουσ η γυναικα η τεκνα ενεκεν τησ βασιλειασ του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","οσ ου μη απολαβη πολλαπλασιονα εν τω καιρω τουτω και εν τω αιωνι τω ερχομενω ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","παραλαβων δε τουσ δωδεκα ειπεν προσ αυτουσ ιδου αναβαινομεν εισ ιεροσολυμα και τελεσθησεται παντα τα γεγραμμενα δια των προφητων τω υιω του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","παραδοθησεται γαρ τοισ εθνεσιν και εμπαιχθησεται και υβρισθησεται και εμπτυσθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","και μαστιγωσαντεσ αποκτενουσιν αυτον και τη ημερα τη τριτη αναστησεται ");
INSERT INTO grcmt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","και αυτοι ουδεν τουτων συνηκαν και ην το ρημα τουτο κεκρυμμενον απ αυτων και ουκ εγινωσκον τα λεγομενα ");
INSERT INTO grcmt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","εγενετο δε εν τω εγγιζειν αυτον εισ ιεριχω τυφλοσ τισ εκαθητο παρα την οδον προσαιτων ");
INSERT INTO grcmt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ακουσασ δε οχλου διαπορευομενου επυνθανετο τι ειη τουτο ");
INSERT INTO grcmt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","απηγγειλαν δε αυτω οτι ιησουσ ο ναζωραιοσ παρερχεται ");
INSERT INTO grcmt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","και εβοησεν λεγων ιησου υιε δαυιδ ελεησον με ");
INSERT INTO grcmt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","και οι προαγοντεσ επετιμων αυτω ινα σιωπηση αυτοσ δε πολλω μαλλον εκραζεν υιε δαυιδ ελεησον με ");
INSERT INTO grcmt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","σταθεισ δε ο ιησουσ εκελευσεν αυτον αχθηναι προσ αυτον εγγισαντοσ δε αυτου επηρωτησεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","λεγων τι σοι θελεισ ποιησω ο δε ειπεν κυριε ινα αναβλεψω ");
INSERT INTO grcmt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","και ο ιησουσ ειπεν αυτω αναβλεψον η πιστισ σου σεσωκεν σε ");
INSERT INTO grcmt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","και παραχρημα ανεβλεψεν και ηκολουθει αυτω δοξαζων τον θεον και πασ ο λαοσ ιδων εδωκεν αινον τω θεω ");
INSERT INTO grcmt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","και εισελθων διηρχετο την ιεριχω ");
INSERT INTO grcmt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","και ιδου ανηρ ονοματι καλουμενοσ ζακχαιοσ και αυτοσ ην αρχιτελωνησ και ουτοσ ην πλουσιοσ ");
INSERT INTO grcmt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","και εζητει ιδειν τον ιησουν τισ εστιν και ουκ ηδυνατο απο του οχλου οτι τη ηλικια μικροσ ην ");
INSERT INTO grcmt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","και προδραμων εμπροσθεν ανεβη επι συκομωραιαν ινα ιδη αυτον οτι εκεινησ εμελλεν διερχεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","και ωσ ηλθεν επι τον τοπον αναβλεψασ ο ιησουσ ειδεν αυτον και ειπεν προσ αυτον ζακχαιε σπευσασ καταβηθι σημερον γαρ εν τω οικω σου δει με μειναι ");
INSERT INTO grcmt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","και σπευσασ κατεβη και υπεδεξατο αυτον χαιρων ");
INSERT INTO grcmt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","και ιδοντεσ παντεσ διεγογγυζον λεγοντεσ οτι παρα αμαρτωλω ανδρι εισηλθεν καταλυσαι ");
INSERT INTO grcmt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","σταθεισ δε ζακχαιοσ ειπεν προσ τον κυριον ιδου τα ημιση των υπαρχοντων μου κυριε διδωμι τοισ πτωχοισ και ει τινοσ τι εσυκοφαντησα αποδιδωμι τετραπλουν ");
INSERT INTO grcmt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ειπεν δε προσ αυτον ο ιησουσ οτι σημερον σωτηρια τω οικω τουτω εγενετο καθοτι και αυτοσ υιοσ αβρααμ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ηλθεν γαρ ο υιοσ του ανθρωπου ζητησαι και σωσαι το απολωλοσ ");
INSERT INTO grcmt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ακουοντων δε αυτων ταυτα προσθεισ ειπεν παραβολην δια το εγγυσ αυτον ειναι ιερουσαλημ και δοκειν αυτουσ οτι παραχρημα μελλει η βασιλεια του θεου αναφαινεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ειπεν ουν ανθρωποσ τισ ευγενησ επορευθη εισ χωραν μακραν λαβειν εαυτω βασιλειαν και υποστρεψαι ");
INSERT INTO grcmt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","καλεσασ δε δεκα δουλουσ εαυτου εδωκεν αυτοισ δεκα μνασ και ειπεν προσ αυτουσ πραγματευσασθε εωσ ερχομαι ");
INSERT INTO grcmt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","οι δε πολιται αυτου εμισουν αυτον και απεστειλαν πρεσβειαν οπισω αυτου λεγοντεσ ου θελομεν τουτον βασιλευσαι εφ ημασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","και εγενετο εν τω επανελθειν αυτον λαβοντα την βασιλειαν και ειπεν φωνηθηναι αυτω τουσ δουλουσ τουτουσ οισ εδωκεν το αργυριον ινα γνω τισ τι διεπραγματευσατο ");
INSERT INTO grcmt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","παρεγενετο δε ο πρωτοσ λεγων κυριε η μνα σου προσειργασατο δεκα μνασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","και ειπεν αυτω ευ αγαθε δουλε οτι εν ελαχιστω πιστοσ εγενου ισθι εξουσιαν εχων επανω δεκα πολεων ");
INSERT INTO grcmt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","και ηλθεν ο δευτεροσ λεγων κυριε η μνα σου εποιησεν πεντε μνασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ειπεν δε και τουτω και συ γινου επανω πεντε πολεων ");
INSERT INTO grcmt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","και ετεροσ ηλθεν λεγων κυριε ιδου η μνα σου ην ειχον αποκειμενην εν σουδαριω ");
INSERT INTO grcmt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","εφοβουμην γαρ σε οτι ανθρωποσ αυστηροσ ει αιρεισ ο ουκ εθηκασ και θεριζεισ ο ουκ εσπειρασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","λεγει δε αυτω εκ του στοματοσ σου κρινω σε πονηρε δουλε ηδεισ οτι εγω ανθρωποσ αυστηροσ ειμι αιρων ο ουκ εθηκα και θεριζων ο ουκ εσπειρα ");
INSERT INTO grcmt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","και δια τι ουκ εδωκασ το αργυριον μου επι τραπεζαν και εγω ελθων συν τοκω αν επραξα αυτο ");
INSERT INTO grcmt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","και τοισ παρεστωσιν ειπεν αρατε απ αυτου την μναν και δοτε τω τασ δεκα μνασ εχοντι ");
INSERT INTO grcmt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","και ειπον αυτω κυριε εχει δεκα μνασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","λεγω γαρ υμιν οτι παντι τω εχοντι δοθησεται απο δε του μη εχοντοσ και ο εχει αρθησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","πλην τουσ εχθρουσ μου εκεινουσ τουσ μη θελησαντασ με βασιλευσαι επ αυτουσ αγαγετε ωδε και κατασφαξατε εμπροσθεν μου ");
INSERT INTO grcmt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","και ειπων ταυτα επορευετο εμπροσθεν αναβαινων εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","και εγενετο ωσ ηγγισεν εισ βηθσφαγη και βηθανιαν προσ το οροσ το καλουμενον ελαιων απεστειλεν δυο των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ειπων υπαγετε εισ την κατεναντι κωμην εν η εισπορευομενοι ευρησετε πωλον δεδεμενον εφ ον ουδεισ πωποτε ανθρωπων εκαθισεν λυσαντεσ αυτον αγαγετε ");
INSERT INTO grcmt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","και εαν τισ υμασ ερωτα δια τι λυετε ουτωσ ερειτε αυτω οτι ο κυριοσ αυτου χρειαν εχει ");
INSERT INTO grcmt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","απελθοντεσ δε οι απεσταλμενοι ευρον καθωσ ειπεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","λυοντων δε αυτων τον πωλον ειπον οι κυριοι αυτου προσ αυτουσ τι λυετε τον πωλον ");
INSERT INTO grcmt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","οι δε ειπον ο κυριοσ αυτου χρειαν εχει ");
INSERT INTO grcmt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","και ηγαγον αυτον προσ τον ιησουν και επιρριψαντεσ εαυτων τα ιματια επι τον πωλον επεβιβασαν τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","πορευομενου δε αυτου υπεστρωννυον τα ιματια αυτων εν τη οδω ");
INSERT INTO grcmt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","εγγιζοντοσ δε αυτου ηδη προσ τη καταβασει του ορουσ των ελαιων ηρξαντο απαν το πληθοσ των μαθητων χαιροντεσ αινειν τον θεον φωνη μεγαλη περι πασων ων ειδον δυναμεων ");
INSERT INTO grcmt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","λεγοντεσ ευλογημενοσ ο ερχομενοσ βασιλευσ εν ονοματι κυριου ειρηνη εν ουρανω και δοξα εν υψιστοισ ");
INSERT INTO grcmt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","και τινεσ των φαρισαιων απο του οχλου ειπον προσ αυτον διδασκαλε επιτιμησον τοισ μαθηταισ σου ");
INSERT INTO grcmt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","και αποκριθεισ ειπεν αυτοισ λεγω υμιν οτι εαν ουτοι σιωπησωσιν οι λιθοι κεκραξονται ");
INSERT INTO grcmt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","και ωσ ηγγισεν ιδων την πολιν εκλαυσεν επ αυτη ");
INSERT INTO grcmt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","λεγων οτι ει εγνωσ και συ και γε εν τη ημερα σου ταυτη τα προσ ειρηνην σου νυν δε εκρυβη απο οφθαλμων σου ");
INSERT INTO grcmt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","οτι ηξουσιν ημεραι επι σε και περιβαλουσιν οι εχθροι σου χαρακα σοι και περικυκλωσουσιν σε και συνεξουσιν σε παντοθεν ");
INSERT INTO grcmt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","και εδαφιουσιν σε και τα τεκνα σου εν σοι και ουκ αφησουσιν εν σοι λιθον επι λιθω ανθ ων ουκ εγνωσ τον καιρον τησ επισκοπησ σου ");
INSERT INTO grcmt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","και εισελθων εισ το ιερον ηρξατο εκβαλλειν τουσ πωλουντασ εν αυτω και αγοραζοντασ ");
INSERT INTO grcmt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","λεγων αυτοισ γεγραπται ο οικοσ μου οικοσ προσευχησ εστιν υμεισ δε αυτον εποιησατε σπηλαιον ληστων ");
INSERT INTO grcmt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","και ην διδασκων το καθ ημεραν εν τω ιερω οι δε αρχιερεισ και οι γραμματεισ εζητουν αυτον απολεσαι και οι πρωτοι του λαου ");
INSERT INTO grcmt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","και ουχ ευρισκον το τι ποιησωσιν ο λαοσ γαρ απασ εξεκρεματο αυτου ακουων ");
INSERT INTO grcmt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","και εγενετο εν μια των ημερων εκεινων διδασκοντοσ αυτου τον λαον εν τω ιερω και ευαγγελιζομενου επεστησαν οι ιερεισ και οι γραμματεισ συν τοισ πρεσβυτεροισ ");
INSERT INTO grcmt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","και ειπον προσ αυτον λεγοντεσ ειπε ημιν εν ποια εξουσια ταυτα ποιεισ η τισ εστιν ο δουσ σοι την εξουσιαν ταυτην ");
INSERT INTO grcmt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","αποκριθεισ δε ειπεν προσ αυτουσ ερωτησω υμασ καγω ενα λογον και ειπατε μοι ");
INSERT INTO grcmt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","το βαπτισμα ιωαννου εξ ουρανου ην η εξ ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","οι δε συνελογισαντο προσ εαυτουσ λεγοντεσ οτι εαν ειπωμεν εξ ουρανου ερει δια τι ουκ επιστευσατε αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","εαν δε ειπωμεν εξ ανθρωπων πασ ο λαοσ καταλιθασει ημασ πεπεισμενοσ γαρ εστιν ιωαννην προφητην ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","και απεκριθησαν μη ειδεναι ποθεν ");
INSERT INTO grcmt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","και ο ιησουσ ειπεν αυτοισ ουδε εγω λεγω υμιν εν ποια εξουσια ταυτα ποιω ");
INSERT INTO grcmt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ηρξατο δε προσ τον λαον λεγειν την παραβολην ταυτην ανθρωποσ εφυτευσεν αμπελωνα και εξεδοτο αυτον γεωργοισ και απεδημησεν χρονουσ ικανουσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","και εν καιρω απεστειλεν προσ τουσ γεωργουσ δουλον ινα απο του καρπου του αμπελωνοσ δωσιν αυτω οι δε γεωργοι δειραντεσ αυτον εξαπεστειλαν κενον ");
INSERT INTO grcmt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","και προσεθετο πεμψαι ετερον δουλον οι δε κακεινον δειραντεσ και ατιμασαντεσ εξαπεστειλαν κενον ");
INSERT INTO grcmt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","και προσεθετο πεμψαι τριτον οι δε και τουτον τραυματισαντεσ εξεβαλον ");
INSERT INTO grcmt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ειπεν δε ο κυριοσ του αμπελωνοσ τι ποιησω πεμψω τον υιον μου τον αγαπητον ισωσ τουτον ιδοντεσ εντραπησονται ");
INSERT INTO grcmt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ιδοντεσ δε αυτον οι γεωργοι διελογιζοντο προσ εαυτουσ λεγοντεσ ουτοσ εστιν ο κληρονομοσ δευτε αποκτεινωμεν αυτον ινα ημων γενηται η κληρονομια ");
INSERT INTO grcmt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","και εκβαλοντεσ αυτον εξω του αμπελωνοσ απεκτειναν τι ουν ποιησει αυτοισ ο κυριοσ του αμπελωνοσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ελευσεται και απολεσει τουσ γεωργουσ τουτουσ και δωσει τον αμπελωνα αλλοισ ακουσαντεσ δε ειπον μη γενοιτο ");
INSERT INTO grcmt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ο δε εμβλεψασ αυτοισ ειπεν τι ουν εστιν το γεγραμμενον τουτο λιθον ον απεδοκιμασαν οι οικοδομουντεσ ουτοσ εγενηθη εισ κεφαλην γωνιασ ");
INSERT INTO grcmt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","πασ ο πεσων επ εκεινον τον λιθον συνθλασθησεται εφ ον δ αν πεση λικμησει αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","και εζητησαν οι αρχιερεισ και οι γραμματεισ επιβαλειν επ αυτον τασ χειρασ εν αυτη τη ωρα και εφοβηθησαν εγνωσαν γαρ οτι προσ αυτουσ την παραβολην ταυτην ειπεν ");
INSERT INTO grcmt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","και παρατηρησαντεσ απεστειλαν εγκαθετουσ υποκρινομενουσ εαυτουσ δικαιουσ ειναι ινα επιλαβωνται αυτου λογου εισ το παραδουναι αυτον τη αρχη και τη εξουσια του ηγεμονοσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","και επηρωτησαν αυτον λεγοντεσ διδασκαλε οιδαμεν οτι ορθωσ λεγεισ και διδασκεισ και ου λαμβανεισ προσωπον αλλ επ αληθειασ την οδον του θεου διδασκεισ ");
INSERT INTO grcmt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","εξεστιν ημιν καισαρι φορον δουναι η ου ");
INSERT INTO grcmt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","κατανοησασ δε αυτων την πανουργιαν ειπεν προσ αυτουσ τι με πειραζετε ");
INSERT INTO grcmt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","επιδειξατε μοι δηναριον τινοσ εχει εικονα και επιγραφην αποκριθεντεσ δε ειπον καισαροσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ο δε ειπεν αυτοισ αποδοτε τοινυν τα καισαροσ καισαρι και τα του θεου τω θεω ");
INSERT INTO grcmt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","και ουκ ισχυσαν επιλαβεσθαι αυτου ρηματοσ εναντιον του λαου και θαυμασαντεσ επι τη αποκρισει αυτου εσιγησαν ");
INSERT INTO grcmt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","προσελθοντεσ δε τινεσ των σαδδουκαιων οι αντιλεγοντεσ αναστασιν μη ειναι επηρωτησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","λεγοντεσ διδασκαλε μωσησ εγραψεν ημιν εαν τινοσ αδελφοσ αποθανη εχων γυναικα και ουτοσ ατεκνοσ αποθανη ινα λαβη ο αδελφοσ αυτου την γυναικα και εξαναστηση σπερμα τω αδελφω αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","επτα ουν αδελφοι ησαν και ο πρωτοσ λαβων γυναικα απεθανεν ατεκνοσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","και ελαβεν ο δευτεροσ την γυναικα και ουτοσ απεθανεν ατεκνοσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","και ο τριτοσ ελαβεν αυτην ωσαυτωσ ωσαυτωσ δε και οι επτα ου κατελιπον τεκνα και απεθανον ");
INSERT INTO grcmt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","υστερον δε παντων απεθανεν και η γυνη ");
INSERT INTO grcmt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","εν τη ουν αναστασει τινοσ αυτων γινεται γυνη οι γαρ επτα εσχον αυτην γυναικα ");
INSERT INTO grcmt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","και αποκριθεισ ειπεν αυτοισ ο ιησουσ οι υιοι του αιωνοσ τουτου γαμουσιν και εκγαμισκονται ");
INSERT INTO grcmt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","οι δε καταξιωθεντεσ του αιωνοσ εκεινου τυχειν και τησ αναστασεωσ τησ εκ νεκρων ουτε γαμουσιν ουτε εκγαμιζονται ");
INSERT INTO grcmt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ουτε γαρ αποθανειν ετι δυνανται ισαγγελοι γαρ εισιν και υιοι εισιν του θεου τησ αναστασεωσ υιοι οντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","οτι δε εγειρονται οι νεκροι και μωσησ εμηνυσεν επι τησ βατου ωσ λεγει κυριον τον θεον αβρααμ και τον θεον ισαακ και τον θεον ιακωβ ");
INSERT INTO grcmt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","θεοσ δε ουκ εστιν νεκρων αλλα ζωντων παντεσ γαρ αυτω ζωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","αποκριθεντεσ δε τινεσ των γραμματεων ειπον διδασκαλε καλωσ ειπασ ");
INSERT INTO grcmt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ουκετι δε ετολμων επερωταν αυτον ουδεν ");
INSERT INTO grcmt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ειπεν δε προσ αυτουσ πωσ λεγουσιν τον χριστον υιον δαυιδ ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","και αυτοσ δαυιδ λεγει εν βιβλω ψαλμων ειπεν ο κυριοσ τω κυριω μου καθου εκ δεξιων μου ");
INSERT INTO grcmt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","εωσ αν θω τουσ εχθρουσ σου υποποδιον των ποδων σου ");
INSERT INTO grcmt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","δαυιδ ουν κυριον αυτον καλει και πωσ υιοσ αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ακουοντοσ δε παντοσ του λαου ειπεν τοισ μαθηταισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","προσεχετε απο των γραμματεων των θελοντων περιπατειν εν στολαισ και φιλουντων ασπασμουσ εν ταισ αγοραισ και πρωτοκαθεδριασ εν ταισ συναγωγαισ και πρωτοκλισιασ εν τοισ δειπνοισ ");
INSERT INTO grcmt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","οι κατεσθιουσιν τασ οικιασ των χηρων και προφασει μακρα προσευχονται ουτοι ληψονται περισσοτερον κριμα ");
INSERT INTO grcmt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","αναβλεψασ δε ειδεν τουσ βαλλοντασ τα δωρα αυτων εισ το γαζοφυλακιον πλουσιουσ ");
INSERT INTO grcmt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ειδεν δε τινα και χηραν πενιχραν βαλλουσαν εκει δυο λεπτα ");
INSERT INTO grcmt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","και ειπεν αληθωσ λεγω υμιν οτι η χηρα η πτωχη αυτη πλειον παντων εβαλεν ");
INSERT INTO grcmt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","απαντεσ γαρ ουτοι εκ του περισσευοντοσ αυτοισ εβαλον εισ τα δωρα του θεου αυτη δε εκ του υστερηματοσ αυτησ απαντα τον βιον ον ειχεν εβαλεν ");
INSERT INTO grcmt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","και τινων λεγοντων περι του ιερου οτι λιθοισ καλοισ και αναθημασιν κεκοσμηται ειπεν ");
INSERT INTO grcmt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ταυτα α θεωρειτε ελευσονται ημεραι εν αισ ουκ αφεθησεται λιθοσ επι λιθω οσ ου καταλυθησεται ");
INSERT INTO grcmt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","επηρωτησαν δε αυτον λεγοντεσ διδασκαλε ποτε ουν ταυτα εσται και τι το σημειον οταν μελλη ταυτα γινεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ο δε ειπεν βλεπετε μη πλανηθητε πολλοι γαρ ελευσονται επι τω ονοματι μου λεγοντεσ οτι εγω ειμι και ο καιροσ ηγγικεν μη ουν πορευθητε οπισω αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","οταν δε ακουσητε πολεμουσ και ακαταστασιασ μη πτοηθητε δει γαρ ταυτα γενεσθαι πρωτον αλλ ουκ ευθεωσ το τελοσ ");
INSERT INTO grcmt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","τοτε ελεγεν αυτοισ εγερθησεται εθνοσ επι εθνοσ και βασιλεια επι βασιλειαν ");
INSERT INTO grcmt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","σεισμοι τε μεγαλοι κατα τοπουσ και λιμοι και λοιμοι εσονται φοβητρα τε και σημεια απ ουρανου μεγαλα εσται ");
INSERT INTO grcmt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","προ δε τουτων παντων επιβαλουσιν εφ υμασ τασ χειρασ αυτων και διωξουσιν παραδιδοντεσ εισ συναγωγασ και φυλακασ αγομενουσ επι βασιλεισ και ηγεμονασ ενεκεν του ονοματοσ μου ");
INSERT INTO grcmt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","αποβησεται δε υμιν εισ μαρτυριον ");
INSERT INTO grcmt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","θεσθε ουν εισ τασ καρδιασ υμων μη προμελεταν απολογηθηναι ");
INSERT INTO grcmt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","εγω γαρ δωσω υμιν στομα και σοφιαν η ου δυνησονται αντειπειν ουδε αντιστηναι παντεσ οι αντικειμενοι υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","παραδοθησεσθε δε και υπο γονεων και συγγενων και φιλων και αδελφων και θανατωσουσιν εξ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","και εσεσθε μισουμενοι υπο παντων δια το ονομα μου ");
INSERT INTO grcmt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","και θριξ εκ τησ κεφαλησ υμων ου μη αποληται ");
INSERT INTO grcmt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","εν τη υπομονη υμων κτησασθε τασ ψυχασ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","οταν δε ιδητε κυκλουμενην υπο στρατοπεδων την ιερουσαλημ τοτε γνωτε οτι ηγγικεν η ερημωσισ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","τοτε οι εν τη ιουδαια φευγετωσαν εισ τα ορη και οι εν μεσω αυτησ εκχωρειτωσαν και οι εν ταισ χωραισ μη εισερχεσθωσαν εισ αυτην ");
INSERT INTO grcmt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","οτι ημεραι εκδικησεωσ αυται εισιν του πλησθηναι παντα τα γεγραμμενα ");
INSERT INTO grcmt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ουαι δε ταισ εν γαστρι εχουσαισ και ταισ θηλαζουσαισ εν εκειναισ ταισ ημεραισ εσται γαρ αναγκη μεγαλη επι τησ γησ και οργη εν τω λαω τουτω ");
INSERT INTO grcmt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","και πεσουνται στοματι μαχαιρασ και αιχμαλωτισθησονται εισ παντα τα εθνη και ιερουσαλημ εσται πατουμενη υπο εθνων αχρι πληρωθωσιν καιροι εθνων ");
INSERT INTO grcmt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","και εσται σημεια εν ηλιω και σεληνη και αστροισ και επι τησ γησ συνοχη εθνων εν απορια ηχουσησ θαλασσησ και σαλου ");
INSERT INTO grcmt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","αποψυχοντων ανθρωπων απο φοβου και προσδοκιασ των επερχομενων τη οικουμενη αι γαρ δυναμεισ των ουρανων σαλευθησονται ");
INSERT INTO grcmt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","και τοτε οψονται τον υιον του ανθρωπου ερχομενον εν νεφελη μετα δυναμεωσ και δοξησ πολλησ ");
INSERT INTO grcmt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","αρχομενων δε τουτων γινεσθαι ανακυψατε και επαρατε τασ κεφαλασ υμων διοτι εγγιζει η απολυτρωσισ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","και ειπεν παραβολην αυτοισ ιδετε την συκην και παντα τα δενδρα ");
INSERT INTO grcmt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","οταν προβαλωσιν ηδη βλεποντεσ αφ εαυτων γινωσκετε οτι ηδη εγγυσ το θεροσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ουτωσ και υμεισ οταν ιδητε ταυτα γινομενα γινωσκετε οτι εγγυσ εστιν η βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","αμην λεγω υμιν οτι ου μη παρελθη η γενεα αυτη εωσ αν παντα γενηται ");
INSERT INTO grcmt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ο ουρανοσ και η γη παρελευσονται οι δε λογοι μου ου μη παρελθωσιν ");
INSERT INTO grcmt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","προσεχετε δε εαυτοισ μηποτε βαρηθωσιν υμων αι καρδιαι εν κραιπαλη και μεθη και μεριμναισ βιωτικαισ και αιφνιδιοσ εφ υμασ επιστη η ημερα εκεινη ");
INSERT INTO grcmt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ωσ παγισ γαρ επελευσεται επι παντασ τουσ καθημενουσ επι προσωπον πασησ τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","αγρυπνειτε ουν εν παντι καιρω δεομενοι ινα καταξιωθητε εκφυγειν παντα τα μελλοντα γινεσθαι και σταθηναι εμπροσθεν του υιου του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ην δε τασ ημερασ εν τω ιερω διδασκων τασ δε νυκτασ εξερχομενοσ ηυλιζετο εισ το οροσ το καλουμενον ελαιων ");
INSERT INTO grcmt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","και πασ ο λαοσ ωρθριζεν προσ αυτον εν τω ιερω ακουειν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ηγγιζεν δε η εορτη των αζυμων η λεγομενη πασχα ");
INSERT INTO grcmt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","και εζητουν οι αρχιερεισ και οι γραμματεισ το πωσ ανελωσιν αυτον εφοβουντο γαρ τον λαον ");
INSERT INTO grcmt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","εισηλθεν δε σατανασ εισ ιουδαν τον επικαλουμενον ισκαριωτην οντα εκ του αριθμου των δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","και απελθων συνελαλησεν τοισ αρχιερευσιν και στρατηγοισ το πωσ αυτον παραδω αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","και εχαρησαν και συνεθεντο αυτω αργυριον δουναι ");
INSERT INTO grcmt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","και εξωμολογησεν και εζητει ευκαιριαν του παραδουναι αυτον αυτοισ ατερ οχλου ");
INSERT INTO grcmt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ηλθεν δε η ημερα των αζυμων εν η εδει θυεσθαι το πασχα ");
INSERT INTO grcmt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","και απεστειλεν πετρον και ιωαννην ειπων πορευθεντεσ ετοιμασατε ημιν το πασχα ινα φαγωμεν ");
INSERT INTO grcmt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","οι δε ειπον αυτω που θελεισ ετοιμασομεν ");
INSERT INTO grcmt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ο δε ειπεν αυτοισ ιδου εισελθοντων υμων εισ την πολιν συναντησει υμιν ανθρωποσ κεραμιον υδατοσ βασταζων ακολουθησατε αυτω εισ την οικιαν ου εισπορευεται ");
INSERT INTO grcmt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","και ερειτε τω οικοδεσποτη τησ οικιασ λεγει σοι ο διδασκαλοσ που εστιν το καταλυμα οπου το πασχα μετα των μαθητων μου φαγω ");
INSERT INTO grcmt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","κακεινοσ υμιν δειξει ανωγεον μεγα εστρωμενον εκει ετοιμασατε ");
INSERT INTO grcmt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","απελθοντεσ δε ευρον καθωσ ειρηκεν αυτοισ και ητοιμασαν το πασχα ");
INSERT INTO grcmt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","και οτε εγενετο η ωρα ανεπεσεν και οι δωδεκα αποστολοι συν αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","και ειπεν προσ αυτουσ επιθυμια επεθυμησα τουτο το πασχα φαγειν μεθ υμων προ του με παθειν ");
INSERT INTO grcmt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","λεγω γαρ υμιν οτι ουκετι ου μη φαγω εξ αυτου εωσ οτου πληρωθη εν τη βασιλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","και δεξαμενοσ ποτηριον ευχαριστησασ ειπεν λαβετε τουτο και διαμερισατε εαυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","λεγω γαρ υμιν οτι ου μη πιω απο του γενηματοσ τησ αμπελου εωσ οτου η βασιλεια του θεου ελθη ");
INSERT INTO grcmt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","και λαβων αρτον ευχαριστησασ εκλασεν και εδωκεν αυτοισ λεγων τουτο εστιν το σωμα μου το υπερ υμων διδομενον τουτο ποιειτε εισ την εμην αναμνησιν ");
INSERT INTO grcmt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ωσαυτωσ και το ποτηριον μετα το δειπνησαι λεγων τουτο το ποτηριον η καινη διαθηκη εν τω αιματι μου το υπερ υμων εκχυνομενον ");
INSERT INTO grcmt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","πλην ιδου η χειρ του παραδιδοντοσ με μετ εμου επι τησ τραπεζησ ");
INSERT INTO grcmt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","και ο μεν υιοσ του ανθρωπου πορευεται κατα το ωρισμενον πλην ουαι τω ανθρωπω εκεινω δι ου παραδιδοται ");
INSERT INTO grcmt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","και αυτοι ηρξαντο συζητειν προσ εαυτουσ το τισ αρα ειη εξ αυτων ο τουτο μελλων πρασσειν ");
INSERT INTO grcmt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","εγενετο δε και φιλονεικια εν αυτοισ το τισ αυτων δοκει ειναι μειζων ");
INSERT INTO grcmt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ο δε ειπεν αυτοισ οι βασιλεισ των εθνων κυριευουσιν αυτων και οι εξουσιαζοντεσ αυτων ευεργεται καλουνται ");
INSERT INTO grcmt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","υμεισ δε ουχ ουτωσ αλλ ο μειζων εν υμιν γενεσθω ωσ ο νεωτεροσ και ο ηγουμενοσ ωσ ο διακονων ");
INSERT INTO grcmt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","τισ γαρ μειζων ο ανακειμενοσ η ο διακονων ουχι ο ανακειμενοσ εγω δε ειμι εν μεσω υμων ωσ ο διακονων ");
INSERT INTO grcmt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","υμεισ δε εστε οι διαμεμενηκοτεσ μετ εμου εν τοισ πειρασμοισ μου ");
INSERT INTO grcmt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","καγω διατιθεμαι υμιν καθωσ διεθετο μοι ο πατηρ μου βασιλειαν ");
INSERT INTO grcmt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ινα εσθιητε και πινητε επι τησ τραπεζησ μου και καθισεσθε επι θρονων κρινοντεσ τασ δωδεκα φυλασ του ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ειπεν δε ο κυριοσ σιμων σιμων ιδου ο σατανασ εξητησατο υμασ του σινιασαι ωσ τον σιτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","εγω δε εδεηθην περι σου ινα μη εκλιπη η πιστισ σου και συ ποτε επιστρεψασ στηριξον τουσ αδελφουσ σου ");
INSERT INTO grcmt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ο δε ειπεν αυτω κυριε μετα σου ετοιμοσ ειμι και εισ φυλακην και εισ θανατον πορευεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ο δε ειπεν λεγω σοι πετρε ου μη φωνηση σημερον αλεκτωρ πριν η τρισ απαρνηση μη ειδεναι με ");
INSERT INTO grcmt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","και ειπεν αυτοισ οτε απεστειλα υμασ ατερ βαλαντιου και πηρασ και υποδηματων μη τινοσ υστερησατε οι δε ειπον ουθενοσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ειπεν ουν αυτοισ αλλα νυν ο εχων βαλαντιον αρατω ομοιωσ και πηραν και ο μη εχων πωλησει το ιματιον αυτου και αγορασει μαχαιραν ");
INSERT INTO grcmt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","λεγω γαρ υμιν οτι ετι τουτο το γεγραμμενον δει τελεσθηναι εν εμοι το και μετα ανομων ελογισθη και γαρ τα περι εμου τελοσ εχει ");
INSERT INTO grcmt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","οι δε ειπον κυριε ιδου μαχαιραι ωδε δυο ο δε ειπεν αυτοισ ικανον εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","και εξελθων επορευθη κατα το εθοσ εισ το οροσ των ελαιων ηκολουθησαν δε αυτω και οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","γενομενοσ δε επι του τοπου ειπεν αυτοισ προσευχεσθε μη εισελθειν εισ πειρασμον ");
INSERT INTO grcmt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","και αυτοσ απεσπασθη απ αυτων ωσει λιθου βολην και θεισ τα γονατα προσηυχετο ");
INSERT INTO grcmt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","λεγων πατερ ει βουλει παρενεγκειν το ποτηριον τουτο απ εμου πλην μη το θελημα μου αλλα το σον γενεσθω ");
INSERT INTO grcmt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ωφθη δε αυτω αγγελοσ απ ουρανου ενισχυων αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","και γενομενοσ εν αγωνια εκτενεστερον προσηυχετο εγενετο δε ο ιδρωσ αυτου ωσει θρομβοι αιματοσ καταβαινοντεσ επι την γην ");
INSERT INTO grcmt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","και αναστασ απο τησ προσευχησ ελθων προσ τουσ μαθητασ ευρεν αυτουσ κοιμωμενουσ απο τησ λυπησ ");
INSERT INTO grcmt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","και ειπεν αυτοισ τι καθευδετε ανασταντεσ προσευχεσθε ινα μη εισελθητε εισ πειρασμον ");
INSERT INTO grcmt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ετι δε αυτου λαλουντοσ ιδου οχλοσ και ο λεγομενοσ ιουδασ εισ των δωδεκα προηρχετο αυτουσ και ηγγισεν τω ιησου φιλησαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ο δε ιησουσ ειπεν αυτω ιουδα φιληματι τον υιον του ανθρωπου παραδιδωσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ιδοντεσ δε οι περι αυτον το εσομενον ειπον αυτω κυριε ει παταξομεν εν μαχαιρα ");
INSERT INTO grcmt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","και επαταξεν εισ τισ εξ αυτων τον δουλον του αρχιερεωσ και αφειλεν αυτου το ουσ το δεξιον ");
INSERT INTO grcmt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","αποκριθεισ δε ο ιησουσ ειπεν εατε εωσ τουτου και αψαμενοσ του ωτιου αυτου ιασατο αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ειπεν δε ο ιησουσ προσ τουσ παραγενομενουσ επ αυτον αρχιερεισ και στρατηγουσ του ιερου και πρεσβυτερουσ ωσ επι ληστην εξεληλυθατε μετα μαχαιρων και ξυλων ");
INSERT INTO grcmt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","καθ ημεραν οντοσ μου μεθ υμων εν τω ιερω ουκ εξετεινατε τασ χειρασ επ εμε αλλ αυτη υμων εστιν η ωρα και η εξουσια του σκοτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","συλλαβοντεσ δε αυτον ηγαγον και εισηγαγον αυτον εισ τον οικον του αρχιερεωσ ο δε πετροσ ηκολουθει μακροθεν ");
INSERT INTO grcmt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","αψαντων δε πυρ εν μεσω τησ αυλησ και συγκαθισαντων αυτων εκαθητο ο πετροσ εν μεσω αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ιδουσα δε αυτον παιδισκη τισ καθημενον προσ το φωσ και ατενισασα αυτω ειπεν και ουτοσ συν αυτω ην ");
INSERT INTO grcmt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ο δε ηρνησατο αυτον λεγων γυναι ουκ οιδα αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","και μετα βραχυ ετεροσ ιδων αυτον εφη και συ εξ αυτων ει ο δε πετροσ ειπεν ανθρωπε ουκ ειμι ");
INSERT INTO grcmt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","και διαστασησ ωσει ωρασ μιασ αλλοσ τισ διισχυριζετο λεγων επ αληθειασ και ουτοσ μετ αυτου ην και γαρ γαλιλαιοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ειπεν δε ο πετροσ ανθρωπε ουκ οιδα ο λεγεισ και παραχρημα ετι λαλουντοσ αυτου εφωνησεν αλεκτωρ ");
INSERT INTO grcmt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","και στραφεισ ο κυριοσ ενεβλεψεν τω πετρω και υπεμνησθη ο πετροσ του λογου του κυριου ωσ ειπεν αυτω οτι πριν αλεκτορα φωνησαι απαρνηση με τρισ ");
INSERT INTO grcmt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","και εξελθων εξω ο πετροσ εκλαυσεν πικρωσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","και οι ανδρεσ οι συνεχοντεσ τον ιησουν ενεπαιζον αυτω δεροντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","και περικαλυψαντεσ αυτον ετυπτον αυτου το προσωπον και επηρωτων αυτον λεγοντεσ προφητευσον τισ εστιν ο παισασ σε ");
INSERT INTO grcmt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","και ετερα πολλα βλασφημουντεσ ελεγον εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","και ωσ εγενετο ημερα συνηχθη το πρεσβυτεριον του λαου αρχιερεισ και γραμματεισ και ανηγαγον αυτον εισ το συνεδριον αυτων λεγοντεσ ");
INSERT INTO grcmt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ει συ ει ο χριστοσ ειπε ημιν ειπεν δε αυτοισ εαν υμιν ειπω ου μη πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","εαν δε και ερωτησω ου μη αποκριθητε μοι η απολυσητε ");
INSERT INTO grcmt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","απο του νυν εσται ο υιοσ του ανθρωπου καθημενοσ εκ δεξιων τησ δυναμεωσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ειπον δε παντεσ συ ουν ει ο υιοσ του θεου ο δε προσ αυτουσ εφη υμεισ λεγετε οτι εγω ειμι ");
INSERT INTO grcmt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","οι δε ειπον τι ετι χρειαν εχομεν μαρτυριασ αυτοι γαρ ηκουσαμεν απο του στοματοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","και ανασταν απαν το πληθοσ αυτων ηγαγον αυτον επι τον πιλατον ");
INSERT INTO grcmt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ηρξαντο δε κατηγορειν αυτου λεγοντεσ τουτον ευρομεν διαστρεφοντα το εθνοσ και κωλυοντα καισαρι φορουσ διδοναι λεγοντα εαυτον χριστον βασιλεα ειναι ");
INSERT INTO grcmt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ο δε πιλατοσ επηρωτησεν αυτον λεγων συ ει ο βασιλευσ των ιουδαιων ο δε αποκριθεισ αυτω εφη συ λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ο δε πιλατοσ ειπεν προσ τουσ αρχιερεισ και τουσ οχλουσ ουδεν ευρισκω αιτιον εν τω ανθρωπω τουτω ");
INSERT INTO grcmt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","οι δε επισχυον λεγοντεσ οτι ανασειει τον λαον διδασκων καθ ολησ τησ ιουδαιασ αρξαμενοσ απο τησ γαλιλαιασ εωσ ωδε ");
INSERT INTO grcmt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","πιλατοσ δε ακουσασ γαλιλαιαν επηρωτησεν ει ο ανθρωποσ γαλιλαιοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","και επιγνουσ οτι εκ τησ εξουσιασ ηρωδου εστιν ανεπεμψεν αυτον προσ ηρωδην οντα και αυτον εν ιεροσολυμοισ εν ταυταισ ταισ ημεραισ ");
INSERT INTO grcmt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ο δε ηρωδησ ιδων τον ιησουν εχαρη λιαν ην γαρ θελων εξ ικανου ιδειν αυτον δια το ακουειν πολλα περι αυτου και ηλπιζεν τι σημειον ιδειν υπ αυτου γινομενον ");
INSERT INTO grcmt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","επηρωτα δε αυτον εν λογοισ ικανοισ αυτοσ δε ουδεν απεκρινατο αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ειστηκεισαν δε οι αρχιερεισ και οι γραμματεισ ευτονωσ κατηγορουντεσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","εξουθενησασ δε αυτον ο ηρωδησ συν τοισ στρατευμασιν αυτου και εμπαιξασ περιβαλων αυτον εσθητα λαμπραν ανεπεμψεν αυτον τω πιλατω ");
INSERT INTO grcmt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","εγενοντο δε φιλοι ο τε πιλατοσ και ο ηρωδησ εν αυτη τη ημερα μετ αλληλων προυπηρχον γαρ εν εχθρα οντεσ προσ εαυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","πιλατοσ δε συγκαλεσαμενοσ τουσ αρχιερεισ και τουσ αρχοντασ και τον λαον ");
INSERT INTO grcmt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ειπεν προσ αυτουσ προσηνεγκατε μοι τον ανθρωπον τουτον ωσ αποστρεφοντα τον λαον και ιδου εγω ενωπιον υμων ανακρινασ ουδεν ευρον εν τω ανθρωπω τουτω αιτιον ων κατηγορειτε κατ αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","αλλ ουδε ηρωδησ ανεπεμψα γαρ υμασ προσ αυτον και ιδου ουδεν αξιον θανατου εστιν πεπραγμενον αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","παιδευσασ ουν αυτον απολυσω ");
INSERT INTO grcmt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","αναγκην δε ειχεν απολυειν αυτοισ κατα εορτην ενα ");
INSERT INTO grcmt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ανεκραξαν δε παμπληθει λεγοντεσ αιρε τουτον απολυσον δε ημιν βαραββαν ");
INSERT INTO grcmt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","οστισ ην δια στασιν τινα γενομενην εν τη πολει και φονον βεβλημενοσ εισ φυλακην ");
INSERT INTO grcmt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","παλιν ουν ο πιλατοσ προσεφωνησεν θελων απολυσαι τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","οι δε επεφωνουν λεγοντεσ σταυρωσον σταυρωσον αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ο δε τριτον ειπεν προσ αυτουσ τι γαρ κακον εποιησεν ουτοσ ουδεν αιτιον θανατου ευρον εν αυτω παιδευσασ ουν αυτον απολυσω ");
INSERT INTO grcmt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","οι δε επεκειντο φωναισ μεγαλαισ αιτουμενοι αυτον σταυρωθηναι και κατισχυον αι φωναι αυτων και των αρχιερεων ");
INSERT INTO grcmt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ο δε πιλατοσ επεκρινεν γενεσθαι το αιτημα αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","απελυσεν δε τον δια στασιν και φονον βεβλημενον εισ την φυλακην ον ητουντο τον δε ιησουν παρεδωκεν τω θεληματι αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","και ωσ απηγαγον αυτον επιλαβομενοι σιμωνοσ τινοσ κυρηναιου ερχομενου απ αγρου επεθηκαν αυτω τον σταυρον φερειν οπισθεν του ιησου ");
INSERT INTO grcmt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ηκολουθει δε αυτω πολυ πληθοσ του λαου και γυναικων αι και εκοπτοντο και εθρηνουν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","στραφεισ δε προσ αυτασ ο ιησουσ ειπεν θυγατερεσ ιερουσαλημ μη κλαιετε επ εμε πλην εφ εαυτασ κλαιετε και επι τα τεκνα υμων ");
INSERT INTO grcmt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","οτι ιδου ερχονται ημεραι εν αισ ερουσιν μακαριαι αι στειραι και κοιλιαι αι ουκ εγεννησαν και μαστοι οι ουκ εθηλασαν ");
INSERT INTO grcmt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","τοτε αρξονται λεγειν τοισ ορεσιν πεσετε εφ ημασ και τοισ βουνοισ καλυψατε ημασ ");
INSERT INTO grcmt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","οτι ει εν τω υγρω ξυλω ταυτα ποιουσιν εν τω ξηρω τι γενηται ");
INSERT INTO grcmt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ηγοντο δε και ετεροι δυο κακουργοι συν αυτω αναιρεθηναι ");
INSERT INTO grcmt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","και οτε απηλθον επι τον τοπον τον καλουμενον κρανιον εκει εσταυρωσαν αυτον και τουσ κακουργουσ ον μεν εκ δεξιων ον δε εξ αριστερων ");
INSERT INTO grcmt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ο δε ιησουσ ελεγεν πατερ αφεσ αυτοισ ου γαρ οιδασιν τι ποιουσιν διαμεριζομενοι δε τα ιματια αυτου εβαλον κληρον ");
INSERT INTO grcmt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","και ειστηκει ο λαοσ θεωρων εξεμυκτηριζον δε και οι αρχοντεσ συν αυτοισ λεγοντεσ αλλουσ εσωσεν σωσατω εαυτον ει ουτοσ εστιν ο χριστοσ ο του θεου εκλεκτοσ ");
INSERT INTO grcmt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ενεπαιζον δε αυτω και οι στρατιωται προσερχομενοι και οξοσ προσφεροντεσ αυτω ");
INSERT INTO grcmt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","και λεγοντεσ ει συ ει ο βασιλευσ των ιουδαιων σωσον σεαυτον ");
INSERT INTO grcmt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ην δε και επιγραφη γεγραμμενη επ αυτω γραμμασιν ελληνικοισ και ρωμαικοισ και εβραικοισ ουτοσ εστιν ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","εισ δε των κρεμασθεντων κακουργων εβλασφημει αυτον λεγων ει συ ει ο χριστοσ σωσον σεαυτον και ημασ ");
INSERT INTO grcmt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","αποκριθεισ δε ο ετεροσ επετιμα αυτω λεγων ουδε φοβη συ τον θεον οτι εν τω αυτω κριματι ει ");
INSERT INTO grcmt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","και ημεισ μεν δικαιωσ αξια γαρ ων επραξαμεν απολαμβανομεν ουτοσ δε ουδεν ατοπον επραξεν ");
INSERT INTO grcmt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","και ελεγεν τω ιησου μνησθητι μου κυριε οταν ελθησ εν τη βασιλεια σου ");
INSERT INTO grcmt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","και ειπεν αυτω ο ιησουσ αμην λεγω σοι σημερον μετ εμου εση εν τω παραδεισω ");
INSERT INTO grcmt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ην δε ωσει ωρα εκτη και σκοτοσ εγενετο εφ ολην την γην εωσ ωρασ ενατησ ");
INSERT INTO grcmt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","και εσκοτισθη ο ηλιοσ και εσχισθη το καταπετασμα του ναου μεσον ");
INSERT INTO grcmt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","και φωνησασ φωνη μεγαλη ο ιησουσ ειπεν πατερ εισ χειρασ σου παραθησομαι το πνευμα μου και ταυτα ειπων εξεπνευσεν ");
INSERT INTO grcmt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ιδων δε ο εκατονταρχοσ το γενομενον εδοξασεν τον θεον λεγων οντωσ ο ανθρωποσ ουτοσ δικαιοσ ην ");
INSERT INTO grcmt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","και παντεσ οι συμπαραγενομενοι οχλοι επι την θεωριαν ταυτην θεωρουντεσ τα γενομενα τυπτοντεσ εαυτων τα στηθη υπεστρεφον ");
INSERT INTO grcmt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ειστηκεισαν δε παντεσ οι γνωστοι αυτου μακροθεν και γυναικεσ αι συνακολουθησασαι αυτω απο τησ γαλιλαιασ ορωσαι ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","και ιδου ανηρ ονοματι ιωσηφ βουλευτησ υπαρχων ανηρ αγαθοσ και δικαιοσ ");
INSERT INTO grcmt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ουτοσ ουκ ην συγκατατεθειμενοσ τη βουλη και τη πραξει αυτων απο αριμαθαιασ πολεωσ των ιουδαιων οσ και προσεδεχετο και αυτοσ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ουτοσ προσελθων τω πιλατω ητησατο το σωμα του ιησου ");
INSERT INTO grcmt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","και καθελων αυτο ενετυλιξεν αυτο σινδονι και εθηκεν αυτο εν μνηματι λαξευτω ου ουκ ην ουδεπω ουδεισ κειμενοσ ");
INSERT INTO grcmt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","και ημερα ην παρασκευη σαββατον επεφωσκεν ");
INSERT INTO grcmt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","κατακολουθησασαι δε γυναικεσ αιτινεσ ησαν συνεληλυθυιαι αυτω εκ τησ γαλιλαιασ εθεασαντο το μνημειον και ωσ ετεθη το σωμα αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","υποστρεψασαι δε ητοιμασαν αρωματα και μυρα και το μεν σαββατον ησυχασαν κατα την εντολην ");
INSERT INTO grcmt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","τη δε μια των σαββατων ορθρου βαθεοσ ηλθον επι το μνημα φερουσαι α ητοιμασαν αρωματα και τινεσ συν αυταισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ευρον δε τον λιθον αποκεκυλισμενον απο του μνημειου ");
INSERT INTO grcmt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","και εισελθουσαι ουχ ευρον το σωμα του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","και εγενετο εν τω διαπορεισθαι αυτασ περι τουτου και ιδου ανδρεσ δυο επεστησαν αυταισ εν εσθησεσιν αστραπτουσαισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","εμφοβων δε γενομενων αυτων και κλινουσων το προσωπον εισ την γην ειπον προσ αυτασ τι ζητειτε τον ζωντα μετα των νεκρων ");
INSERT INTO grcmt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ουκ εστιν ωδε αλλ ηγερθη μνησθητε ωσ ελαλησεν υμιν ετι ων εν τη γαλιλαια ");
INSERT INTO grcmt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","λεγων οτι δει τον υιον του ανθρωπου παραδοθηναι εισ χειρασ ανθρωπων αμαρτωλων και σταυρωθηναι και τη τριτη ημερα αναστηναι ");
INSERT INTO grcmt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","και εμνησθησαν των ρηματων αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","και υποστρεψασαι απο του μνημειου απηγγειλαν ταυτα παντα τοισ ενδεκα και πασιν τοισ λοιποισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ησαν δε η μαγδαληνη μαρια και ιωαννα και μαρια ιακωβου και αι λοιπαι συν αυταισ αι ελεγον προσ τουσ αποστολουσ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","και εφανησαν ενωπιον αυτων ωσει ληροσ τα ρηματα αυτων και ηπιστουν αυταισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ο δε πετροσ αναστασ εδραμεν επι το μνημειον και παρακυψασ βλεπει τα οθονια κειμενα μονα και απηλθεν προσ εαυτον θαυμαζων το γεγονοσ ");
INSERT INTO grcmt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","και ιδου δυο εξ αυτων ησαν πορευομενοι εν αυτη τη ημερα εισ κωμην απεχουσαν σταδιουσ εξηκοντα απο ιερουσαλημ η ονομα εμμαουσ ");
INSERT INTO grcmt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","και αυτοι ωμιλουν προσ αλληλουσ περι παντων των συμβεβηκοτων τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","και εγενετο εν τω ομιλειν αυτουσ και συζητειν και αυτοσ ο ιησουσ εγγισασ συνεπορευετο αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","οι δε οφθαλμοι αυτων εκρατουντο του μη επιγνωναι αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ειπεν δε προσ αυτουσ τινεσ οι λογοι ουτοι ουσ αντιβαλλετε προσ αλληλουσ περιπατουντεσ και εστε σκυθρωποι ");
INSERT INTO grcmt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","αποκριθεισ δε ο εισ ω ονομα κλεοπασ ειπεν προσ αυτον συ μονοσ παροικεισ ιερουσαλημ και ουκ εγνωσ τα γενομενα εν αυτη εν ταισ ημεραισ ταυταισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","και ειπεν αυτοισ ποια οι δε ειπον αυτω τα περι ιησου του ναζωραιου οσ εγενετο ανηρ προφητησ δυνατοσ εν εργω και λογω εναντιον του θεου και παντοσ του λαου ");
INSERT INTO grcmt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","οπωσ τε παρεδωκαν αυτον οι αρχιερεισ και οι αρχοντεσ ημων εισ κριμα θανατου και εσταυρωσαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ημεισ δε ηλπιζομεν οτι αυτοσ εστιν ο μελλων λυτρουσθαι τον ισραηλ αλλα γε συν πασιν τουτοισ τριτην ταυτην ημεραν αγει σημερον αφ ου ταυτα εγενετο ");
INSERT INTO grcmt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","αλλα και γυναικεσ τινεσ εξ ημων εξεστησαν ημασ γενομεναι ορθριαι επι το μνημειον ");
INSERT INTO grcmt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","και μη ευρουσαι το σωμα αυτου ηλθον λεγουσαι και οπτασιαν αγγελων εωρακεναι οι λεγουσιν αυτον ζην ");
INSERT INTO grcmt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","και απηλθον τινεσ των συν ημιν επι το μνημειον και ευρον ουτωσ καθωσ και αι γυναικεσ ειπον αυτον δε ουκ ειδον ");
INSERT INTO grcmt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","και αυτοσ ειπεν προσ αυτουσ ω ανοητοι και βραδεισ τη καρδια του πιστευειν επι πασιν οισ ελαλησαν οι προφηται ");
INSERT INTO grcmt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ουχι ταυτα εδει παθειν τον χριστον και εισελθειν εισ την δοξαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","και αρξαμενοσ απο μωσεωσ και απο παντων των προφητων διηρμηνευεν αυτοισ εν πασαισ ταισ γραφαισ τα περι εαυτου ");
INSERT INTO grcmt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","και ηγγισαν εισ την κωμην ου επορευοντο και αυτοσ προσεποιειτο πορρωτερω πορευεσθαι ");
INSERT INTO grcmt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","και παρεβιασαντο αυτον λεγοντεσ μεινον μεθ ημων οτι προσ εσπεραν εστιν και κεκλικεν η ημερα και εισηλθεν του μειναι συν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","και εγενετο εν τω κατακλιθηναι αυτον μετ αυτων λαβων τον αρτον ευλογησεν και κλασασ επεδιδου αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","αυτων δε διηνοιχθησαν οι οφθαλμοι και επεγνωσαν αυτον και αυτοσ αφαντοσ εγενετο απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","και ειπον προσ αλληλουσ ουχι η καρδια ημων καιομενη ην εν ημιν ωσ ελαλει ημιν εν τη οδω και ωσ διηνοιγεν ημιν τασ γραφασ ");
INSERT INTO grcmt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","και ανασταντεσ αυτη τη ωρα υπεστρεψαν εισ ιερουσαλημ και ευρον συνηθροισμενουσ τουσ ενδεκα και τουσ συν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","λεγοντασ οτι ηγερθη ο κυριοσ οντωσ και ωφθη σιμωνι ");
INSERT INTO grcmt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","και αυτοι εξηγουντο τα εν τη οδω και ωσ εγνωσθη αυτοισ εν τη κλασει του αρτου ");
INSERT INTO grcmt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ταυτα δε αυτων λαλουντων αυτοσ ο ιησουσ εστη εν μεσω αυτων και λεγει αυτοισ ειρηνη υμιν ");
INSERT INTO grcmt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","πτοηθεντεσ δε και εμφοβοι γενομενοι εδοκουν πνευμα θεωρειν ");
INSERT INTO grcmt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","και ειπεν αυτοισ τι τεταραγμενοι εστε και δια τι διαλογισμοι αναβαινουσιν εν ταισ καρδιαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ιδετε τασ χειρασ μου και τουσ ποδασ μου οτι αυτοσ εγω ειμι ψηλαφησατε με και ιδετε οτι πνευμα σαρκα και οστεα ουκ εχει καθωσ εμε θεωρειτε εχοντα ");
INSERT INTO grcmt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","και τουτο ειπων επεδειξεν αυτοισ τασ χειρασ και τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ετι δε απιστουντων αυτων απο τησ χαρασ και θαυμαζοντων ειπεν αυτοισ εχετε τι βρωσιμον ενθαδε ");
INSERT INTO grcmt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","οι δε επεδωκαν αυτω ιχθυοσ οπτου μεροσ και απο μελισσιου κηριου ");
INSERT INTO grcmt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","και λαβων ενωπιον αυτων εφαγεν ");
INSERT INTO grcmt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ειπεν δε αυτοισ ουτοι οι λογοι ουσ ελαλησα προσ υμασ ετι ων συν υμιν οτι δει πληρωθηναι παντα τα γεγραμμενα εν τω νομω μωσεωσ και προφηταισ και ψαλμοισ περι εμου ");
INSERT INTO grcmt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","τοτε διηνοιξεν αυτων τον νουν του συνιεναι τασ γραφασ ");
INSERT INTO grcmt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","και ειπεν αυτοισ οτι ουτωσ γεγραπται και ουτωσ εδει παθειν τον χριστον και αναστηναι εκ νεκρων τη τριτη ημερα ");
INSERT INTO grcmt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","και κηρυχθηναι επι τω ονοματι αυτου μετανοιαν και αφεσιν αμαρτιων εισ παντα τα εθνη αρξαμενον απο ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","υμεισ δε εστε μαρτυρεσ τουτων ");
INSERT INTO grcmt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","και ιδου εγω αποστελλω την επαγγελιαν του πατροσ μου εφ υμασ υμεισ δε καθισατε εν τη πολει ιερουσαλημ εωσ ου ενδυσησθε δυναμιν εξ υψουσ ");
INSERT INTO grcmt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","εξηγαγεν δε αυτουσ εξω εωσ εισ βηθανιαν και επαρασ τασ χειρασ αυτου ευλογησεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","και εγενετο εν τω ευλογειν αυτον αυτουσ διεστη απ αυτων και ανεφερετο εισ τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","και αυτοι προσκυνησαντεσ αυτον υπεστρεψαν εισ ιερουσαλημ μετα χαρασ μεγαλησ ");
INSERT INTO grcmt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","και ησαν δια παντοσ εν τω ιερω αινουντεσ και ευλογουντεσ τον θεον αμην ");
INSERT INTO grcmt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","εν αρχη ην ο λογοσ και ο λογοσ ην προσ τον θεον και θεοσ ην ο λογοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ουτοσ ην εν αρχη προσ τον θεον ");
INSERT INTO grcmt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","παντα δι αυτου εγενετο και χωρισ αυτου εγενετο ουδε εν ο γεγονεν ");
INSERT INTO grcmt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","εν αυτω ζωη ην και η ζωη ην το φωσ των ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","και το φωσ εν τη σκοτια φαινει και η σκοτια αυτο ου κατελαβεν ");
INSERT INTO grcmt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","εγενετο ανθρωποσ απεσταλμενοσ παρα θεου ονομα αυτω ιωαννησ ");
INSERT INTO grcmt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ουτοσ ηλθεν εισ μαρτυριαν ινα μαρτυρηση περι του φωτοσ ινα παντεσ πιστευσωσιν δι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ουκ ην εκεινοσ το φωσ αλλ ινα μαρτυρηση περι του φωτοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ην το φωσ το αληθινον ο φωτιζει παντα ανθρωπον ερχομενον 2064 V-PNP-ASM εισ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","εν τω κοσμω ην και ο κοσμοσ δι αυτου εγενετο και ο κοσμοσ αυτον ουκ εγνω ");
INSERT INTO grcmt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","εισ τα ιδια ηλθεν και οι ιδιοι αυτον ου παρελαβον ");
INSERT INTO grcmt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","οσοι δε ελαβον αυτον εδωκεν αυτοισ εξουσιαν τεκνα θεου γενεσθαι τοισ πιστευουσιν εισ το ονομα αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","οι ουκ εξ αιματων ουδε εκ θεληματοσ σαρκοσ ουδε εκ θεληματοσ ανδροσ αλλ εκ θεου εγεννηθησαν ");
INSERT INTO grcmt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","και ο λογοσ σαρξ εγενετο και εσκηνωσεν εν ημιν και εθεασαμεθα την δοξαν αυτου δοξαν ωσ μονογενουσ παρα πατροσ πληρησ χαριτοσ και αληθειασ ");
INSERT INTO grcmt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ιωαννησ μαρτυρει περι αυτου και κεκραγεν λεγων ουτοσ ην ον ειπον ο οπισω μου ερχομενοσ εμπροσθεν μου γεγονεν οτι πρωτοσ μου ην ");
INSERT INTO grcmt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","και εκ του πληρωματοσ αυτου ημεισ παντεσ ελαβομεν και χαριν αντι χαριτοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","οτι ο νομοσ δια μωσεωσ εδοθη η χαρισ και η αληθεια δια ιησου χριστου εγενετο ");
INSERT INTO grcmt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","θεον ουδεισ εωρακεν πωποτε ο μονογενησ υιοσ ο ων εισ τον κολπον του πατροσ εκεινοσ εξηγησατο ");
INSERT INTO grcmt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","και αυτη εστιν η μαρτυρια του ιωαννου οτε απεστειλαν οι ιουδαιοι εξ ιεροσολυμων ιερεισ και λευιτασ ινα ερωτησωσιν αυτον συ τισ ει ");
INSERT INTO grcmt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","και ωμολογησεν και ουκ ηρνησατο και ωμολογησεν οτι ουκ ειμι εγω ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","και ηρωτησαν αυτον τι ουν ηλιασ ει συ και λεγει ουκ ειμι ο προφητησ ει συ και απεκριθη ου ");
INSERT INTO grcmt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ειπον ουν αυτω τισ ει ινα αποκρισιν δωμεν τοισ πεμψασιν ημασ τι λεγεισ περι σεαυτου ");
INSERT INTO grcmt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","εφη εγω φωνη βοωντοσ εν τη ερημω ευθυνατε την οδον κυριου καθωσ ειπεν ησαιασ ο προφητησ ");
INSERT INTO grcmt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","και οι απεσταλμενοι ησαν εκ των φαρισαιων ");
INSERT INTO grcmt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","και ηρωτησαν αυτον και ειπον αυτω τι ουν βαπτιζεισ ει συ ουκ ει ο χριστοσ ουτε ηλιασ ουτε ο προφητησ ");
INSERT INTO grcmt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","απεκριθη αυτοισ ο ιωαννησ λεγων εγω βαπτιζω εν υδατι μεσοσ δε υμων εστηκεν ον υμεισ ουκ οιδατε ");
INSERT INTO grcmt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","αυτοσ εστιν ο οπισω μου ερχομενοσ οσ εμπροσθεν μου γεγονεν ου εγω ουκ ειμι αξιοσ ινα λυσω αυτου τον ιμαντα του υποδηματοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ταυτα εν βηθανια εγενετο περαν του ιορδανου οπου ην ιωαννησ βαπτιζων ");
INSERT INTO grcmt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","τη επαυριον βλεπει τον ιησουν ερχομενον προσ αυτον και λεγει ιδε ο αμνοσ του θεου ο αιρων την αμαρτιαν του κοσμου ");
INSERT INTO grcmt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ουτοσ εστιν περι ου εγω ειπον οπισω μου ερχεται ανηρ οσ εμπροσθεν μου γεγονεν οτι πρωτοσ μου ην ");
INSERT INTO grcmt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","καγω ουκ ηδειν αυτον αλλ ινα φανερωθη τω ισραηλ δια τουτο ηλθον εγω εν τω υδατι βαπτιζων ");
INSERT INTO grcmt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","και εμαρτυρησεν ιωαννησ λεγων οτι τεθεαμαι το πνευμα καταβαινον ωσει περιστεραν εξ ουρανου και εμεινεν επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","καγω ουκ ηδειν αυτον αλλ ο πεμψασ με βαπτιζειν εν υδατι εκεινοσ μοι ειπεν εφ ον αν ιδησ το πνευμα καταβαινον και μενον επ αυτον ουτοσ εστιν ο βαπτιζων εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","καγω εωρακα και μεμαρτυρηκα οτι ουτοσ εστιν ο υιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","τη επαυριον παλιν ειστηκει ο ιωαννησ και εκ των μαθητων αυτου δυο ");
INSERT INTO grcmt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","και εμβλεψασ τω ιησου περιπατουντι λεγει ιδε ο αμνοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","και ηκουσαν αυτου οι δυο μαθηται λαλουντοσ και ηκολουθησαν τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","στραφεισ δε ο ιησουσ και θεασαμενοσ αυτουσ ακολουθουντασ λεγει αυτοισ τι ζητειτε οι δε ειπον αυτω ραββι ο λεγεται ερμηνευομενον διδασκαλε που μενεισ ");
INSERT INTO grcmt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","λεγει αυτοισ ερχεσθε και ιδετε ηλθον και ειδον που μενει και παρ αυτω εμειναν την ημεραν εκεινην ωρα ην ωσ δεκατη ");
INSERT INTO grcmt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ην ανδρεασ ο αδελφοσ σιμωνοσ πετρου εισ εκ των δυο των ακουσαντων παρα ιωαννου και ακολουθησαντων αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ευρισκει ουτοσ πρωτοσ τον αδελφον τον ιδιον σιμωνα και λεγει αυτω ευρηκαμεν τον μεσιαν ο εστιν μεθερμηνευομενον χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","και ηγαγεν αυτον προσ τον ιησουν εμβλεψασ αυτω ο ιησουσ ειπεν συ ει σιμων ο υιοσ ιωνα συ κληθηση κηφασ ο ερμηνευεται πετροσ ");
INSERT INTO grcmt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","τη επαυριον ηθελησεν εξελθειν εισ την γαλιλαιαν και ευρισκει φιλιππον και λεγει αυτω ο ιησουσ ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ην δε ο φιλιπποσ απο βηθσαιδα εκ τησ πολεωσ ανδρεου και πετρου ");
INSERT INTO grcmt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ευρισκει φιλιπποσ τον ναθαναηλ και λεγει αυτω ον εγραψεν μωσησ εν τω νομω και οι προφηται ευρηκαμεν ιησουν τον υιον του ιωσηφ τον απο ναζαρετ ");
INSERT INTO grcmt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","και ειπεν αυτω ναθαναηλ εκ ναζαρετ δυναται τι αγαθον ειναι λεγει αυτω φιλιπποσ ερχου και ιδε ");
INSERT INTO grcmt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ειδεν ο ιησουσ τον ναθαναηλ ερχομενον προσ αυτον και λεγει περι αυτου ιδε αληθωσ ισραηλιτησ εν ω δολοσ ουκ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","λεγει αυτω ναθαναηλ ποθεν με γινωσκεισ απεκριθη ιησουσ και ειπεν αυτω προ του σε φιλιππον φωνησαι οντα υπο την συκην ειδον σε ");
INSERT INTO grcmt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","απεκριθη ναθαναηλ και λεγει αυτω ραββι συ ει ο υιοσ του θεου συ ει ο βασιλευσ του ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","απεκριθη ιησουσ και ειπεν αυτω οτι ειπον σοι ειδον σε υποκατω τησ συκησ πιστευεισ μειζω τουτων οψει ");
INSERT INTO grcmt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","και λεγει αυτω αμην αμην λεγω υμιν απ αρτι οψεσθε τον ουρανον ανεωγοτα και τουσ αγγελουσ του θεου αναβαινοντασ και καταβαινοντασ επι τον υιον του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","και τη ημερα τη τριτη γαμοσ εγενετο εν κανα τησ γαλιλαιασ και ην η μητηρ του ιησου εκει ");
INSERT INTO grcmt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","εκληθη δε και ο ιησουσ και οι μαθηται αυτου εισ τον γαμον ");
INSERT INTO grcmt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","και υστερησαντοσ οινου λεγει η μητηρ του ιησου προσ αυτον οινον ουκ εχουσιν ");
INSERT INTO grcmt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","λεγει αυτη ο ιησουσ τι εμοι και σοι γυναι ουπω ηκει η ωρα μου ");
INSERT INTO grcmt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","λεγει η μητηρ αυτου τοισ διακονοισ ο τι αν λεγη υμιν ποιησατε ");
INSERT INTO grcmt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ησαν δε εκει υδριαι λιθιναι εξ κειμεναι κατα τον καθαρισμον των ιουδαιων χωρουσαι ανα μετρητασ δυο η τρεισ ");
INSERT INTO grcmt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","λεγει αυτοισ ο ιησουσ γεμισατε τασ υδριασ υδατοσ και εγεμισαν αυτασ εωσ ανω ");
INSERT INTO grcmt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","και λεγει αυτοισ αντλησατε νυν και φερετε τω αρχιτρικλινω και ηνεγκαν ");
INSERT INTO grcmt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ωσ δε εγευσατο ο αρχιτρικλινοσ το υδωρ οινον γεγενημενον και ουκ ηδει ποθεν εστιν οι δε διακονοι ηδεισαν οι ηντληκοτεσ το υδωρ φωνει τον νυμφιον ο αρχιτρικλινοσ ");
INSERT INTO grcmt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","και λεγει αυτω πασ ανθρωποσ πρωτον τον καλον οινον τιθησιν και οταν μεθυσθωσιν τοτε τον ελασσω συ τετηρηκασ τον καλον οινον εωσ αρτι ");
INSERT INTO grcmt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ταυτην εποιησεν την αρχην των σημειων ο ιησουσ εν κανα τησ γαλιλαιασ και εφανερωσεν την δοξαν αυτου και επιστευσαν εισ αυτον οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","μετα τουτο κατεβη εισ καπερναουμ αυτοσ και η μητηρ αυτου και οι αδελφοι αυτου και οι μαθηται αυτου και εκει εμειναν ου πολλασ ημερασ ");
INSERT INTO grcmt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","και εγγυσ ην το πασχα των ιουδαιων και ανεβη εισ ιεροσολυμα ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","και ευρεν εν τω ιερω τουσ πωλουντασ βοασ και προβατα και περιστερασ και τουσ κερματιστασ καθημενουσ ");
INSERT INTO grcmt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","και ποιησασ φραγελλιον εκ σχοινιων παντασ εξεβαλεν εκ του ιερου τα τε προβατα και τουσ βοασ και των κολλυβιστων εξεχεεν το κερμα και τασ τραπεζασ ανεστρεψεν ");
INSERT INTO grcmt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","και τοισ τασ περιστερασ πωλουσιν ειπεν αρατε ταυτα εντευθεν μη ποιειτε τον οικον του πατροσ μου οικον εμποριου ");
INSERT INTO grcmt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","εμνησθησαν δε οι μαθηται αυτου οτι γεγραμμενον εστιν ο ζηλοσ του οικου σου καταφαγεται με ");
INSERT INTO grcmt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","απεκριθησαν ουν οι ιουδαιοι και ειπον αυτω τι σημειον δεικνυεισ ημιν οτι ταυτα ποιεισ ");
INSERT INTO grcmt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","απεκριθη ιησουσ και ειπεν αυτοισ λυσατε τον ναον τουτον και εν τρισιν ημεραισ εγερω αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ειπον ουν οι ιουδαιοι τεσσαρακοντα και εξ ετεσιν ωκοδομηθη ο ναοσ ουτοσ και συ εν τρισιν ημεραισ εγερεισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","εκεινοσ δε ελεγεν περι του ναου του σωματοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","οτε ουν ηγερθη εκ νεκρων εμνησθησαν οι μαθηται αυτου οτι τουτο ελεγεν και επιστευσαν τη γραφη και τω λογω ω ειπεν ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ωσ δε ην εν τοισ ιεροσολυμοισ εν τω πασχα εν τη εορτη πολλοι επιστευσαν εισ το ονομα αυτου θεωρουντεσ αυτου τα σημεια α εποιει ");
INSERT INTO grcmt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","αυτοσ δε ο ιησουσ ουκ επιστευεν εαυτον αυτοισ δια το αυτον γινωσκειν παντασ ");
INSERT INTO grcmt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","και οτι ου χρειαν ειχεν ινα τισ μαρτυρηση περι του ανθρωπου αυτοσ γαρ εγινωσκεν τι ην εν τω ανθρωπω ");
INSERT INTO grcmt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ην δε ανθρωποσ εκ των φαρισαιων νικοδημοσ ονομα αυτω αρχων των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ουτοσ ηλθεν προσ αυτον νυκτοσ και ειπεν αυτω ραββι οιδαμεν οτι απο θεου εληλυθασ διδασκαλοσ ουδεισ γαρ ταυτα τα σημεια δυναται ποιειν α συ ποιεισ εαν μη η ο θεοσ μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","απεκριθη ο ιησουσ και ειπεν αυτω αμην αμην λεγω σοι εαν μη τισ γεννηθη ανωθεν ου δυναται ιδειν την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","λεγει προσ αυτον ο νικοδημοσ πωσ δυναται ανθρωποσ γεννηθηναι γερων ων μη δυναται εισ την κοιλιαν τησ μητροσ αυτου δευτερον εισελθειν και γεννηθηναι ");
INSERT INTO grcmt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","απεκριθη ιησουσ αμην αμην λεγω σοι εαν μη τισ γεννηθη εξ υδατοσ και πνευματοσ ου δυναται εισελθειν εισ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","το γεγεννημενον εκ τησ σαρκοσ σαρξ εστιν και το γεγεννημενον εκ του πνευματοσ πνευμα εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","μη θαυμασησ οτι ειπον σοι δει υμασ γεννηθηναι ανωθεν ");
INSERT INTO grcmt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","το πνευμα οπου θελει πνει και την φωνην αυτου ακουεισ αλλ ουκ οιδασ ποθεν ερχεται και που υπαγει ουτωσ εστιν πασ ο γεγεννημενοσ εκ του πνευματοσ ");
INSERT INTO grcmt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","απεκριθη νικοδημοσ και ειπεν αυτω πωσ δυναται ταυτα γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","απεκριθη ιησουσ και ειπεν αυτω συ ει ο διδασκαλοσ του ισραηλ και ταυτα ου γινωσκεισ ");
INSERT INTO grcmt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","αμην αμην λεγω σοι οτι ο οιδαμεν λαλουμεν και ο εωρακαμεν μαρτυρουμεν και την μαρτυριαν ημων ου λαμβανετε ");
INSERT INTO grcmt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ει τα επιγεια ειπον υμιν και ου πιστευετε πωσ εαν ειπω υμιν τα επουρανια πιστευσετε ");
INSERT INTO grcmt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","και ουδεισ αναβεβηκεν εισ τον ουρανον ει μη ο εκ του ουρανου καταβασ ο υιοσ του ανθρωπου ο ων εν τω ουρανω ");
INSERT INTO grcmt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","και καθωσ μωσησ υψωσεν τον οφιν εν τη ερημω ουτωσ υψωθηναι δει τον υιον του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ινα πασ ο πιστευων εισ αυτον μη αποληται αλλ εχη ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ουτωσ γαρ ηγαπησεν ο θεοσ τον κοσμον ωστε τον υιον αυτου τον μονογενη εδωκεν ινα πασ ο πιστευων εισ αυτον μη αποληται αλλ εχη ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ου γαρ απεστειλεν ο θεοσ τον υιον αυτου εισ τον κοσμον ινα κρινη τον κοσμον αλλ ινα σωθη ο κοσμοσ δι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ο πιστευων εισ αυτον ου κρινεται ο δε μη πιστευων ηδη κεκριται οτι μη πεπιστευκεν εισ το ονομα του μονογενουσ υιου του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","αυτη δε εστιν η κρισισ οτι το φωσ εληλυθεν εισ τον κοσμον και ηγαπησαν οι ανθρωποι μαλλον το σκοτοσ η το φωσ ην γαρ πονηρα αυτων τα εργα ");
INSERT INTO grcmt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","πασ γαρ ο φαυλα πρασσων μισει το φωσ και ουκ ερχεται προσ το φωσ ινα μη ελεγχθη τα εργα αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ο δε ποιων την αληθειαν ερχεται προσ το φωσ ινα φανερωθη αυτου τα εργα οτι εν θεω εστιν ειργασμενα ");
INSERT INTO grcmt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","μετα ταυτα ηλθεν ο ιησουσ και οι μαθηται αυτου εισ την ιουδαιαν γην και εκει διετριβεν μετ αυτων και εβαπτιζεν ");
INSERT INTO grcmt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ην δε και ιωαννησ βαπτιζων εν αινων εγγυσ του σαλημ οτι υδατα πολλα ην εκει και παρεγινοντο και εβαπτιζοντο ");
INSERT INTO grcmt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ουπω γαρ ην βεβλημενοσ εισ την φυλακην ο ιωαννησ ");
INSERT INTO grcmt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","εγενετο ουν ζητησισ εκ των μαθητων ιωαννου μετα ιουδαιου περι καθαρισμου ");
INSERT INTO grcmt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","και ηλθον προσ τον ιωαννην και ειπον αυτω ραββι οσ ην μετα σου περαν του ιορδανου ω συ μεμαρτυρηκασ ιδε ουτοσ βαπτιζει και παντεσ ερχονται προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","απεκριθη ιωαννησ και ειπεν ου δυναται ανθρωποσ λαμβανειν ουδεν εαν μη η δεδομενον αυτω εκ του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","αυτοι υμεισ μαρτυρειτε οτι ειπον ουκ ειμι εγω ο χριστοσ αλλ οτι απεσταλμενοσ ειμι εμπροσθεν εκεινου ");
INSERT INTO grcmt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ο εχων την νυμφην νυμφιοσ εστιν ο δε φιλοσ του νυμφιου ο εστηκωσ και ακουων αυτου χαρα χαιρει δια την φωνην του νυμφιου αυτη ουν η χαρα η εμη πεπληρωται ");
INSERT INTO grcmt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","εκεινον δει αυξανειν εμε δε ελαττουσθαι ");
INSERT INTO grcmt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ο ανωθεν ερχομενοσ επανω παντων εστιν ο ων εκ τησ γησ εκ τησ γησ εστιν και εκ τησ γησ λαλει ο εκ του ουρανου ερχομενοσ επανω παντων εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","και ο εωρακεν και ηκουσεν τουτο μαρτυρει και την μαρτυριαν αυτου ουδεισ λαμβανει ");
INSERT INTO grcmt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ο λαβων αυτου την μαρτυριαν εσφραγισεν οτι ο θεοσ αληθησ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ον γαρ απεστειλεν ο θεοσ τα ρηματα του θεου λαλει ου γαρ εκ μετρου διδωσιν ο θεοσ το πνευμα ");
INSERT INTO grcmt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ο πατηρ αγαπα τον υιον και παντα δεδωκεν εν τη χειρι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ο πιστευων εισ τον υιον εχει ζωην αιωνιον ο δε απειθων τω υιω ουκ οψεται ζωην αλλ η οργη του θεου μενει επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ωσ ουν εγνω ο κυριοσ οτι ηκουσαν οι φαρισαιοι οτι ιησουσ πλειονασ μαθητασ ποιει και βαπτιζει η ιωαννησ ");
INSERT INTO grcmt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","καιτοιγε ιησουσ αυτοσ ουκ εβαπτιζεν αλλ οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","αφηκεν την ιουδαιαν και απηλθεν εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","εδει δε αυτον διερχεσθαι δια τησ σαμαρειασ ");
INSERT INTO grcmt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ερχεται ουν εισ πολιν τησ σαμαρειασ λεγομενην συχαρ πλησιον του χωριου ο εδωκεν ιακωβ ιωσηφ τω υιω αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ην δε εκει πηγη του ιακωβ ο ουν ιησουσ κεκοπιακωσ εκ τησ οδοιποριασ εκαθεζετο ουτωσ επι τη πηγη ωρα ην ωσει εκτη ");
INSERT INTO grcmt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ερχεται γυνη εκ τησ σαμαρειασ αντλησαι υδωρ λεγει αυτη ο ιησουσ δοσ μοι πιειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","οι γαρ μαθηται αυτου απεληλυθεισαν εισ την πολιν ινα τροφασ αγορασωσιν ");
INSERT INTO grcmt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","λεγει ουν αυτω η γυνη η σαμαρειτισ πωσ συ ιουδαιοσ ων παρ εμου πιειν αιτεισ ουσησ γυναικοσ σαμαρειτιδοσ ου γαρ συγχρωνται ιουδαιοι σαμαρειταισ ");
INSERT INTO grcmt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","απεκριθη ιησουσ και ειπεν αυτη ει ηδεισ την δωρεαν του θεου και τισ εστιν ο λεγων σοι δοσ μοι πιειν συ αν ητησασ αυτον και εδωκεν αν σοι υδωρ ζων ");
INSERT INTO grcmt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","λεγει αυτω η γυνη κυριε ουτε αντλημα εχεισ και το φρεαρ εστιν βαθυ ποθεν ουν εχεισ το υδωρ το ζων ");
INSERT INTO grcmt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","μη συ μειζων ει του πατροσ ημων ιακωβ οσ εδωκεν ημιν το φρεαρ και αυτοσ εξ αυτου επιεν και οι υιοι αυτου και τα θρεμματα αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","απεκριθη ιησουσ και ειπεν αυτη πασ ο πινων εκ του υδατοσ τουτου διψησει παλιν ");
INSERT INTO grcmt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","οσ δ αν πιη εκ του υδατοσ ου εγω δωσω αυτω ου μη διψηση εισ τον αιωνα αλλα το υδωρ ο δωσω αυτω γενησεται εν αυτω πηγη υδατοσ αλλομενου εισ ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","λεγει προσ αυτον η γυνη κυριε δοσ μοι τουτο το υδωρ ινα μη διψω μηδε ερχομαι ενθαδε αντλειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","λεγει αυτη ο ιησουσ υπαγε φωνησον τον ανδρα σου και ελθε ενθαδε ");
INSERT INTO grcmt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","απεκριθη η γυνη και ειπεν ουκ εχω ανδρα λεγει αυτη ο ιησουσ καλωσ ειπασ οτι ανδρα ουκ εχω ");
INSERT INTO grcmt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","πεντε γαρ ανδρασ εσχεσ και νυν ον εχεισ ουκ εστιν σου ανηρ τουτο αληθεσ ειρηκασ ");
INSERT INTO grcmt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","λεγει αυτω η γυνη κυριε θεωρω οτι προφητησ ει συ ");
INSERT INTO grcmt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","οι πατερεσ ημων εν τω ορει τουτω προσεκυνησαν και υμεισ λεγετε οτι εν ιεροσολυμοισ εστιν ο τοποσ οπου δει προσκυνειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","λεγει αυτη ο ιησουσ γυναι πιστευσον μοι οτι ερχεται ωρα οτε ουτε εν τω ορει τουτω ουτε εν ιεροσολυμοισ προσκυνησετε τω πατρι ");
INSERT INTO grcmt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","υμεισ προσκυνειτε ο ουκ οιδατε ημεισ προσκυνουμεν ο οιδαμεν οτι η σωτηρια εκ των ιουδαιων εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","αλλ ερχεται ωρα και νυν εστιν οτε οι αληθινοι προσκυνηται προσκυνησουσιν τω πατρι εν πνευματι και αληθεια και γαρ ο πατηρ τοιουτουσ ζητει τουσ προσκυνουντασ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","πνευμα ο θεοσ και τουσ προσκυνουντασ αυτον εν πνευματι και αληθεια δει προσκυνειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","λεγει αυτω η γυνη οιδα οτι μεσιασ ερχεται ο λεγομενοσ χριστοσ οταν ελθη εκεινοσ αναγγελει ημιν παντα ");
INSERT INTO grcmt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","λεγει αυτη ο ιησουσ εγω ειμι ο λαλων σοι ");
INSERT INTO grcmt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","και επι τουτω ηλθον οι μαθηται αυτου και εθαυμασαν οτι μετα γυναικοσ ελαλει ουδεισ μεντοι ειπεν τι ζητεισ η τι λαλεισ μετ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","αφηκεν ουν την υδριαν αυτησ η γυνη και απηλθεν εισ την πολιν και λεγει τοισ ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","δευτε ιδετε ανθρωπον οσ ειπεν μοι παντα οσα εποιησα μητι ουτοσ εστιν ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","εξηλθον εκ τησ πολεωσ και ηρχοντο προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","εν δε τω μεταξυ ηρωτων αυτον οι μαθηται λεγοντεσ ραββι φαγε ");
INSERT INTO grcmt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ο δε ειπεν αυτοισ εγω βρωσιν εχω φαγειν ην υμεισ ουκ οιδατε ");
INSERT INTO grcmt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ελεγον ουν οι μαθηται προσ αλληλουσ μη τισ ηνεγκεν αυτω φαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","λεγει αυτοισ ο ιησουσ εμον βρωμα εστιν ινα ποιω το θελημα του πεμψαντοσ με και τελειωσω αυτου το εργον ");
INSERT INTO grcmt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ουχ υμεισ λεγετε οτι ετι τετραμηνοσ εστιν και ο θερισμοσ ερχεται ιδου λεγω υμιν επαρατε τουσ οφθαλμουσ υμων και θεασασθε τασ χωρασ οτι λευκαι εισιν προσ θερισμον ηδη ");
INSERT INTO grcmt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","και ο θεριζων μισθον λαμβανει και συναγει καρπον εισ ζωην αιωνιον ινα και ο σπειρων ομου χαιρη και ο θεριζων ");
INSERT INTO grcmt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","εν γαρ τουτω ο λογοσ εστιν ο αληθινοσ οτι αλλοσ εστιν ο σπειρων και αλλοσ ο θεριζων ");
INSERT INTO grcmt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","εγω απεστειλα υμασ θεριζειν ο ουχ υμεισ κεκοπιακατε αλλοι κεκοπιακασιν και υμεισ εισ τον κοπον αυτων εισεληλυθατε ");
INSERT INTO grcmt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","εκ δε τησ πολεωσ εκεινησ πολλοι επιστευσαν εισ αυτον των σαμαρειτων δια τον λογον τησ γυναικοσ μαρτυρουσησ οτι ειπεν μοι παντα οσα εποιησα ");
INSERT INTO grcmt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ωσ ουν ηλθον προσ αυτον οι σαμαρειται ηρωτων αυτον μειναι παρ αυτοισ και εμεινεν εκει δυο ημερασ ");
INSERT INTO grcmt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","και πολλω πλειουσ επιστευσαν δια τον λογον αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","τη τε γυναικι ελεγον οτι ουκετι δια την σην λαλιαν πιστευομεν αυτοι γαρ ακηκοαμεν και οιδαμεν οτι ουτοσ εστιν αληθωσ ο σωτηρ του κοσμου ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","μετα δε τασ δυο ημερασ εξηλθεν εκειθεν και απηλθεν εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","αυτοσ γαρ ο ιησουσ εμαρτυρησεν οτι προφητησ εν τη ιδια πατριδι τιμην ουκ εχει ");
INSERT INTO grcmt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","οτε ουν ηλθεν εισ την γαλιλαιαν εδεξαντο αυτον οι γαλιλαιοι παντα εωρακοτεσ α εποιησεν εν ιεροσολυμοισ εν τη εορτη και αυτοι γαρ ηλθον εισ την εορτην ");
INSERT INTO grcmt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ηλθεν ουν παλιν ο ιησουσ εισ την κανα τησ γαλιλαιασ οπου εποιησεν το υδωρ οινον και ην τισ βασιλικοσ ου ο υιοσ ησθενει εν καπερναουμ ");
INSERT INTO grcmt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ουτοσ ακουσασ οτι ιησουσ ηκει εκ τησ ιουδαιασ εισ την γαλιλαιαν απηλθεν προσ αυτον και ηρωτα αυτον ινα καταβη και ιασηται αυτου τον υιον εμελλεν γαρ αποθνησκειν ");
INSERT INTO grcmt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ειπεν ουν ο ιησουσ προσ αυτον εαν μη σημεια και τερατα ιδητε ου μη πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","λεγει προσ αυτον ο βασιλικοσ κυριε καταβηθι πριν αποθανειν το παιδιον μου ");
INSERT INTO grcmt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","λεγει αυτω ο ιησουσ πορευου ο υιοσ σου ζη και επιστευσεν ο ανθρωποσ τω λογω ω ειπεν αυτω ο ιησουσ και επορευετο ");
INSERT INTO grcmt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ηδη δε αυτου καταβαινοντοσ οι δουλοι αυτου απηντησαν αυτω και απηγγειλαν λεγοντεσ οτι ο παισ σου ζη ");
INSERT INTO grcmt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","επυθετο ουν παρ αυτων την ωραν εν η κομψοτερον εσχεν και ειπον αυτω οτι χθεσ ωραν εβδομην αφηκεν αυτον ο πυρετοσ ");
INSERT INTO grcmt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","εγνω ουν ο πατηρ οτι εν εκεινη τη ωρα εν η ειπεν αυτω ο ιησουσ οτι ο υιοσ σου ζη και επιστευσεν αυτοσ και η οικια αυτου ολη ");
INSERT INTO grcmt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","τουτο παλιν δευτερον σημειον εποιησεν ο ιησουσ ελθων εκ τησ ιουδαιασ εισ την γαλιλαιαν ");
INSERT INTO grcmt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","μετα ταυτα ην η εορτη των ιουδαιων και ανεβη ο ιησουσ εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","εστιν δε εν τοισ ιεροσολυμοισ επι τη προβατικη κολυμβηθρα η επιλεγομενη εβραιστι βηθεσδα πεντε στοασ εχουσα ");
INSERT INTO grcmt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","εν ταυταισ κατεκειτο πληθοσ πολυ των ασθενουντων τυφλων χωλων ξηρων εκδεχομενων την του υδατοσ κινησιν ");
INSERT INTO grcmt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","αγγελοσ γαρ κατα καιρον κατεβαινεν εν τη κολυμβηθρα και εταρασσεν το υδωρ ο ουν πρωτοσ εμβασ μετα την ταραχην του υδατοσ υγιησ εγινετο ω δηποτε κατειχετο νοσηματι ");
INSERT INTO grcmt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ην δε τισ ανθρωποσ εκει τριακοντα οκτω ετη εχων εν τη ασθενεια ");
INSERT INTO grcmt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","τουτον ιδων ο ιησουσ κατακειμενον και γνουσ οτι πολυν ηδη χρονον εχει λεγει αυτω θελεισ υγιησ γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","απεκριθη αυτω ο ασθενων κυριε ανθρωπον ουκ εχω ινα οταν ταραχθη το υδωρ βαλη με εισ την κολυμβηθραν εν ω δε ερχομαι εγω αλλοσ προ εμου καταβαινει ");
INSERT INTO grcmt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","λεγει αυτω ο ιησουσ εγειραι αρον τον κραββατον σου και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","και ευθεωσ εγενετο υγιησ ο ανθρωποσ και ηρεν τον κραββατον αυτου και περιεπατει ην δε σαββατον εν εκεινη τη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ελεγον ουν οι ιουδαιοι τω τεθεραπευμενω σαββατον εστιν ουκ εξεστιν σοι αραι τον κραββατον ");
INSERT INTO grcmt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","απεκριθη αυτοισ ο ποιησασ με υγιη εκεινοσ μοι ειπεν αρον τον κραββατον σου και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ηρωτησαν ουν αυτον τισ εστιν ο ανθρωποσ ο ειπων σοι αρον τον κραββατον σου και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ο δε ιαθεισ ουκ ηδει τισ εστιν ο γαρ ιησουσ εξενευσεν οχλου οντοσ εν τω τοπω ");
INSERT INTO grcmt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","μετα ταυτα ευρισκει αυτον ο ιησουσ εν τω ιερω και ειπεν αυτω ιδε υγιησ γεγονασ μηκετι αμαρτανε ινα μη χειρον τι σοι γενηται ");
INSERT INTO grcmt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","απηλθεν ο ανθρωποσ και ανηγγειλεν τοισ ιουδαιοισ οτι ιησουσ εστιν ο ποιησασ αυτον υγιη ");
INSERT INTO grcmt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","και δια τουτο εδιωκον τον ιησουν οι ιουδαιοι και εζητουν αυτον αποκτειναι οτι ταυτα εποιει εν σαββατω ");
INSERT INTO grcmt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ο δε ιησουσ απεκρινατο αυτοισ ο πατηρ μου εωσ αρτι εργαζεται καγω εργαζομαι ");
INSERT INTO grcmt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","δια τουτο ουν μαλλον εζητουν αυτον οι ιουδαιοι αποκτειναι οτι ου μονον ελυεν το σαββατον αλλα και πατερα ιδιον ελεγεν τον θεον ισον εαυτον ποιων τω θεω ");
INSERT INTO grcmt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","απεκρινατο ουν ο ιησουσ και ειπεν αυτοισ αμην αμην λεγω υμιν ου δυναται ο υιοσ ποιειν αφ εαυτου ουδεν εαν μη τι βλεπη τον πατερα ποιουντα α γαρ αν εκεινοσ ποιη ταυτα και ο υιοσ ομοιωσ ποιει ");
INSERT INTO grcmt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ο γαρ πατηρ φιλει τον υιον και παντα δεικνυσιν αυτω α αυτοσ ποιει και μειζονα τουτων δειξει αυτω εργα ινα υμεισ θαυμαζητε ");
INSERT INTO grcmt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ωσπερ γαρ ο πατηρ εγειρει τουσ νεκρουσ και ζωοποιει ουτωσ και ο υιοσ ουσ θελει ζωοποιει ");
INSERT INTO grcmt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ουδε γαρ ο πατηρ κρινει ουδενα αλλα την κρισιν πασαν δεδωκεν τω υιω ");
INSERT INTO grcmt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ινα παντεσ τιμωσιν τον υιον καθωσ τιμωσιν τον πατερα ο μη τιμων τον υιον ου τιμα τον πατερα τον πεμψαντα αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","αμην αμην λεγω υμιν οτι ο τον λογον μου ακουων και πιστευων τω πεμψαντι με εχει ζωην αιωνιον και εισ κρισιν ουκ ερχεται αλλα μεταβεβηκεν εκ του θανατου εισ την ζωην ");
INSERT INTO grcmt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","αμην αμην λεγω υμιν οτι ερχεται ωρα και νυν εστιν οτε οι νεκροι ακουσονται τησ φωνησ του υιου του θεου και οι ακουσαντεσ ζησονται ");
INSERT INTO grcmt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ωσπερ γαρ ο πατηρ εχει ζωην εν εαυτω ουτωσ εδωκεν και τω υιω ζωην εχειν εν εαυτω ");
INSERT INTO grcmt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","και εξουσιαν εδωκεν αυτω και κρισιν ποιειν οτι υιοσ ανθρωπου εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","μη θαυμαζετε τουτο οτι ερχεται ωρα εν η παντεσ οι εν τοισ μνημειοισ ακουσονται τησ φωνησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","και εκπορευσονται οι τα αγαθα ποιησαντεσ εισ αναστασιν ζωησ οι δε τα φαυλα πραξαντεσ εισ αναστασιν κρισεωσ ");
INSERT INTO grcmt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ου δυναμαι εγω ποιειν απ εμαυτου ουδεν καθωσ ακουω κρινω και η κρισισ η εμη δικαια εστιν οτι ου ζητω το θελημα το εμον αλλα το θελημα του πεμψαντοσ με πατροσ ");
INSERT INTO grcmt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","εαν εγω μαρτυρω περι εμαυτου η μαρτυρια μου ουκ εστιν αληθησ ");
INSERT INTO grcmt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","αλλοσ εστιν ο μαρτυρων περι εμου και οιδα οτι αληθησ εστιν η μαρτυρια ην μαρτυρει περι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","υμεισ απεσταλκατε προσ ιωαννην και μεμαρτυρηκεν τη αληθεια ");
INSERT INTO grcmt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","εγω δε ου παρα ανθρωπου την μαρτυριαν λαμβανω αλλα ταυτα λεγω ινα υμεισ σωθητε ");
INSERT INTO grcmt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","εκεινοσ ην ο λυχνοσ ο καιομενοσ και φαινων υμεισ δε ηθελησατε αγαλλιαθηναι προσ ωραν εν τω φωτι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","εγω δε εχω την μαρτυριαν μειζω του ιωαννου τα γαρ εργα α εδωκεν μοι ο πατηρ ινα τελειωσω αυτα αυτα τα εργα α εγω ποιω μαρτυρει περι εμου οτι ο πατηρ με απεσταλκεν ");
INSERT INTO grcmt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","και ο πεμψασ με πατηρ αυτοσ μεμαρτυρηκεν περι εμου ουτε φωνην αυτου ακηκοατε πωποτε ουτε ειδοσ αυτου εωρακατε ");
INSERT INTO grcmt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","και τον λογον αυτου ουκ εχετε μενοντα εν υμιν οτι ον απεστειλεν εκεινοσ τουτω υμεισ ου πιστευετε ");
INSERT INTO grcmt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ερευνατε 2045 V-PAI-2P τασ γραφασ οτι υμεισ δοκειτε εν αυταισ ζωην αιωνιον εχειν και εκειναι εισιν αι μαρτυρουσαι περι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","και ου θελετε ελθειν προσ με ινα ζωην εχητε ");
INSERT INTO grcmt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","δοξαν παρα ανθρωπων ου λαμβανω ");
INSERT INTO grcmt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","αλλ εγνωκα υμασ οτι την αγαπην του θεου ουκ εχετε εν εαυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","εγω εληλυθα εν τω ονοματι του πατροσ μου και ου λαμβανετε με εαν αλλοσ ελθη εν τω ονοματι τω ιδιω εκεινον ληψεσθε ");
INSERT INTO grcmt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","πωσ δυνασθε υμεισ πιστευσαι δοξαν παρα αλληλων λαμβανοντεσ και την δοξαν την παρα του μονου θεου ου ζητειτε ");
INSERT INTO grcmt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","μη δοκειτε οτι εγω κατηγορησω υμων προσ τον πατερα εστιν ο κατηγορων υμων μωσησ εισ ον υμεισ ηλπικατε ");
INSERT INTO grcmt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ει γαρ επιστευετε μωση επιστευετε αν εμοι περι γαρ εμου εκεινοσ εγραψεν ");
INSERT INTO grcmt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ει δε τοισ εκεινου γραμμασιν ου πιστευετε πωσ τοισ εμοισ ρημασιν πιστευσετε ");
INSERT INTO grcmt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","μετα ταυτα απηλθεν ο ιησουσ περαν τησ θαλασσησ τησ γαλιλαιασ τησ τιβεριαδοσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","και ηκολουθει αυτω οχλοσ πολυσ οτι εωρων αυτου τα σημεια α εποιει επι των ασθενουντων ");
INSERT INTO grcmt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ανηλθεν δε εισ το οροσ ο ιησουσ και εκει εκαθητο μετα των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ην δε εγγυσ το πασχα η εορτη των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","επαρασ ουν ο ιησουσ τουσ οφθαλμουσ και θεασαμενοσ οτι πολυσ οχλοσ ερχεται προσ αυτον λεγει προσ τον φιλιππον ποθεν αγορασομεν αρτουσ ινα φαγωσιν ουτοι ");
INSERT INTO grcmt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","τουτο δε ελεγεν πειραζων αυτον αυτοσ γαρ ηδει τι εμελλεν ποιειν ");
INSERT INTO grcmt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","απεκριθη αυτω φιλιπποσ διακοσιων δηναριων αρτοι ουκ αρκουσιν αυτοισ ινα εκαστοσ αυτων βραχυ τι λαβη ");
INSERT INTO grcmt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","λεγει αυτω εισ εκ των μαθητων αυτου ανδρεασ ο αδελφοσ σιμωνοσ πετρου ");
INSERT INTO grcmt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","εστιν παιδαριον εν ωδε ο εχει πεντε αρτουσ κριθινουσ και δυο οψαρια αλλα ταυτα τι εστιν εισ τοσουτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ειπεν δε ο ιησουσ ποιησατε τουσ ανθρωπουσ αναπεσειν ην δε χορτοσ πολυσ εν τω τοπω ανεπεσον ουν οι ανδρεσ τον αριθμον ωσει πεντακισχιλιοι ");
INSERT INTO grcmt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ελαβεν δε τουσ αρτουσ ο ιησουσ και ευχαριστησασ διεδωκεν τοισ μαθηταισ οι δε μαθηται τοισ ανακειμενοισ ομοιωσ και εκ των οψαριων οσον ηθελον ");
INSERT INTO grcmt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ωσ δε ενεπλησθησαν λεγει τοισ μαθηταισ αυτου συναγαγετε τα περισσευσαντα κλασματα ινα μη τι αποληται ");
INSERT INTO grcmt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","συνηγαγον ουν και εγεμισαν δωδεκα κοφινουσ κλασματων εκ των πεντε αρτων των κριθινων α επερισσευσεν τοισ βεβρωκοσιν ");
INSERT INTO grcmt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","οι ουν ανθρωποι ιδοντεσ ο εποιησεν σημειον ο ιησουσ ελεγον οτι ουτοσ εστιν αληθωσ ο προφητησ ο ερχομενοσ εισ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ιησουσ ουν γνουσ οτι μελλουσιν ερχεσθαι και αρπαζειν αυτον ινα ποιησωσιν αυτον βασιλεα ανεχωρησεν εισ το οροσ αυτοσ μονοσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ωσ δε οψια εγενετο κατεβησαν οι μαθηται αυτου επι την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","και εμβαντεσ εισ το πλοιον ηρχοντο περαν τησ θαλασσησ εισ καπερναουμ και σκοτια ηδη εγεγονει και ουκ εληλυθει προσ αυτουσ ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","η τε θαλασσα ανεμου μεγαλου πνεοντοσ διηγειρετο ");
INSERT INTO grcmt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","εληλακοτεσ ουν ωσ σταδιουσ εικοσι πεντε η τριακοντα θεωρουσιν τον ιησουν περιπατουντα επι τησ θαλασσησ και εγγυσ του πλοιου γινομενον και εφοβηθησαν ");
INSERT INTO grcmt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ο δε λεγει αυτοισ εγω ειμι μη φοβεισθε ");
INSERT INTO grcmt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ηθελον ουν λαβειν αυτον εισ το πλοιον και ευθεωσ το πλοιον εγενετο επι τησ γησ εισ ην υπηγον ");
INSERT INTO grcmt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","τη επαυριον ο οχλοσ ο εστηκωσ περαν τησ θαλασσησ ιδων οτι πλοιαριον αλλο ουκ ην εκει ει μη εν εκεινο εισ ο ενεβησαν οι μαθηται αυτου και οτι ου συνεισηλθεν τοισ μαθηταισ αυτου ο ιησουσ εισ το πλοιαριον αλλα μονοι οι μαθηται αυτου απηλθον ");
INSERT INTO grcmt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","αλλα δε ηλθεν πλοιαρια εκ τιβεριαδοσ εγγυσ του τοπου οπου εφαγον τον αρτον ευχαριστησαντοσ του κυριου ");
INSERT INTO grcmt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","οτε ουν ειδεν ο οχλοσ οτι ιησουσ ουκ εστιν εκει ουδε οι μαθηται αυτου ενεβησαν αυτοι εισ τα πλοια και ηλθον εισ καπερναουμ ζητουντεσ τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","και ευροντεσ αυτον περαν τησ θαλασσησ ειπον αυτω ραββι ποτε ωδε γεγονασ ");
INSERT INTO grcmt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","απεκριθη αυτοισ ο ιησουσ και ειπεν αμην αμην λεγω υμιν ζητειτε με ουχ οτι ειδετε σημεια αλλ οτι εφαγετε εκ των αρτων και εχορτασθητε ");
INSERT INTO grcmt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","εργαζεσθε μη την βρωσιν την απολλυμενην αλλα την βρωσιν την μενουσαν εισ ζωην αιωνιον ην ο υιοσ του ανθρωπου υμιν δωσει τουτον γαρ ο πατηρ εσφραγισεν ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ειπον ουν προσ αυτον τι ποιωμεν ινα εργαζωμεθα τα εργα του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","απεκριθη ιησουσ και ειπεν αυτοισ τουτο εστιν το εργον του θεου ινα πιστευσητε εισ ον απεστειλεν εκεινοσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ειπον ουν αυτω τι ουν ποιεισ συ σημειον ινα ιδωμεν και πιστευσωμεν σοι τι εργαζη ");
INSERT INTO grcmt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","οι πατερεσ ημων το μαννα εφαγον εν τη ερημω καθωσ εστιν γεγραμμενον αρτον εκ του ουρανου εδωκεν αυτοισ φαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ειπεν ουν αυτοισ ο ιησουσ αμην αμην λεγω υμιν ου μωσησ δεδωκεν υμιν τον αρτον εκ του ουρανου αλλ ο πατηρ μου διδωσιν υμιν τον αρτον εκ του ουρανου τον αληθινον ");
INSERT INTO grcmt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ο γαρ αρτοσ του θεου εστιν ο καταβαινων εκ του ουρανου και ζωην διδουσ τω κοσμω ");
INSERT INTO grcmt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ειπον ουν προσ αυτον κυριε παντοτε δοσ ημιν τον αρτον τουτον ");
INSERT INTO grcmt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ειπεν δε αυτοισ ο ιησουσ εγω ειμι ο αρτοσ τησ ζωησ ο ερχομενοσ προσ με ου μη πειναση και ο πιστευων εισ εμε ου μη διψηση πωποτε ");
INSERT INTO grcmt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","αλλ ειπον υμιν οτι και εωρακατε με και ου πιστευετε ");
INSERT INTO grcmt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","παν ο διδωσιν μοι ο πατηρ προσ εμε ηξει και τον ερχομενον προσ με ου μη εκβαλω εξω ");
INSERT INTO grcmt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","οτι καταβεβηκα εκ του ουρανου ουχ ινα ποιω το θελημα το εμον αλλα το θελημα του πεμψαντοσ με ");
INSERT INTO grcmt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","τουτο δε εστιν το θελημα του πεμψαντοσ με πατροσ ινα παν ο δεδωκεν μοι μη απολεσω εξ αυτου αλλα αναστησω αυτο τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","τουτο δε εστιν το θελημα του πεμψαντοσ με ινα πασ ο θεωρων τον υιον και πιστευων εισ αυτον εχη ζωην αιωνιον και αναστησω αυτον εγω τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","εγογγυζον ουν οι ιουδαιοι περι αυτου οτι ειπεν εγω ειμι ο αρτοσ ο καταβασ εκ του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","και ελεγον ουχ ουτοσ εστιν ιησουσ ο υιοσ ιωσηφ ου ημεισ οιδαμεν τον πατερα και την μητερα πωσ ουν λεγει ουτοσ οτι εκ του ουρανου καταβεβηκα ");
INSERT INTO grcmt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","απεκριθη ουν ο ιησουσ και ειπεν αυτοισ μη γογγυζετε μετ αλληλων ");
INSERT INTO grcmt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ουδεισ δυναται ελθειν προσ με εαν μη ο πατηρ ο πεμψασ με ελκυση αυτον και εγω αναστησω αυτον εν τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","εστιν γεγραμμενον εν τοισ προφηταισ και εσονται παντεσ διδακτοι θεου πασ ουν ο ακουων παρα του πατροσ και μαθων ερχεται προσ με ");
INSERT INTO grcmt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ουχ οτι τον πατερα τισ εωρακεν ει μη ο ων παρα του θεου ουτοσ εωρακεν τον πατερα ");
INSERT INTO grcmt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","αμην αμην λεγω υμιν ο πιστευων εισ εμε εχει ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","εγω ειμι ο αρτοσ τησ ζωησ ");
INSERT INTO grcmt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","οι πατερεσ υμων εφαγον το μαννα εν τη ερημω και απεθανον ");
INSERT INTO grcmt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ουτοσ εστιν ο αρτοσ ο εκ του ουρανου καταβαινων ινα τισ εξ αυτου φαγη και μη αποθανη ");
INSERT INTO grcmt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","εγω ειμι ο αρτοσ ο ζων ο εκ του ουρανου καταβασ εαν τισ φαγη εκ τουτου του αρτου ζησεται εισ τον αιωνα και ο αρτοσ δε ον εγω δωσω η σαρξ μου εστιν ην εγω δωσω υπερ τησ του κοσμου ζωησ ");
INSERT INTO grcmt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","εμαχοντο ουν προσ αλληλουσ οι ιουδαιοι λεγοντεσ πωσ δυναται ουτοσ ημιν δουναι την σαρκα φαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ειπεν ουν αυτοισ ο ιησουσ αμην αμην λεγω υμιν εαν μη φαγητε την σαρκα του υιου του ανθρωπου και πιητε αυτου το αιμα ουκ εχετε ζωην εν εαυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ο τρωγων μου την σαρκα και πινων μου το αιμα εχει ζωην αιωνιον και εγω αναστησω αυτον τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","η γαρ σαρξ μου αληθωσ εστιν βρωσισ και το αιμα μου αληθωσ εστιν ποσισ ");
INSERT INTO grcmt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ο τρωγων μου την σαρκα και πινων μου το αιμα εν εμοι μενει καγω εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","καθωσ απεστειλεν με ο ζων πατηρ καγω ζω δια τον πατερα και ο τρωγων με κακεινοσ ζησεται δι εμε ");
INSERT INTO grcmt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ουτοσ εστιν ο αρτοσ ο εκ του ουρανου καταβασ ου καθωσ εφαγον οι πατερεσ υμων το μαννα και απεθανον ο τρωγων τουτον τον αρτον ζησεται εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ταυτα ειπεν εν συναγωγη διδασκων εν καπερναουμ ");
INSERT INTO grcmt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","πολλοι ουν ακουσαντεσ εκ των μαθητων αυτου ειπον σκληροσ εστιν ουτοσ ο λογοσ τισ δυναται αυτου ακουειν ");
INSERT INTO grcmt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ειδωσ δε ο ιησουσ εν εαυτω οτι γογγυζουσιν περι τουτου οι μαθηται αυτου ειπεν αυτοισ τουτο υμασ σκανδαλιζει ");
INSERT INTO grcmt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","εαν ουν θεωρητε τον υιον του ανθρωπου αναβαινοντα οπου ην το προτερον ");
INSERT INTO grcmt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","το πνευμα εστιν το ζωοποιουν η σαρξ ουκ ωφελει ουδεν τα ρηματα α εγω λαλω υμιν πνευμα εστιν και ζωη εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","αλλ εισιν εξ υμων τινεσ οι ου πιστευουσιν ηδει γαρ εξ αρχησ ο ιησουσ τινεσ εισιν οι μη πιστευοντεσ και τισ εστιν ο παραδωσων αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","και ελεγεν δια τουτο ειρηκα υμιν οτι ουδεισ δυναται ελθειν προσ με εαν μη η δεδομενον αυτω εκ του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","εκ τουτου πολλοι απηλθον των μαθητων αυτου εισ τα οπισω και ουκετι μετ αυτου περιεπατουν ");
INSERT INTO grcmt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ειπεν ουν ο ιησουσ τοισ δωδεκα μη και υμεισ θελετε υπαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","απεκριθη ουν αυτω σιμων πετροσ κυριε προσ τινα απελευσομεθα ρηματα ζωησ αιωνιου εχεισ ");
INSERT INTO grcmt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","και ημεισ πεπιστευκαμεν και εγνωκαμεν οτι συ ει ο χριστοσ ο υιοσ του θεου του ζωντοσ ");
INSERT INTO grcmt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","απεκριθη αυτοισ ο ιησουσ ουκ εγω υμασ τουσ δωδεκα εξελεξαμην και εξ υμων εισ διαβολοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ελεγεν δε τον ιουδαν σιμωνοσ ισκαριωτην ουτοσ γαρ εμελλεν αυτον παραδιδοναι εισ ων εκ των δωδεκα ");
INSERT INTO grcmt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","και περιεπατει ο ιησουσ μετα ταυτα εν τη γαλιλαια ου γαρ ηθελεν εν τη ιουδαια περιπατειν οτι εζητουν αυτον οι ιουδαιοι αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ην δε εγγυσ η εορτη των ιουδαιων η σκηνοπηγια ");
INSERT INTO grcmt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ειπον ουν προσ αυτον οι αδελφοι αυτου μεταβηθι εντευθεν και υπαγε εισ την ιουδαιαν ινα και οι μαθηται σου θεωρησωσιν τα εργα σου α ποιεισ ");
INSERT INTO grcmt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ουδεισ γαρ εν κρυπτω τι ποιει και ζητει αυτοσ εν παρρησια ειναι ει ταυτα ποιεισ φανερωσον σεαυτον τω κοσμω ");
INSERT INTO grcmt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ουδε γαρ οι αδελφοι αυτου επιστευον εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","λεγει ουν αυτοισ ο ιησουσ ο καιροσ ο εμοσ ουπω παρεστιν ο δε καιροσ ο υμετεροσ παντοτε εστιν ετοιμοσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ου δυναται ο κοσμοσ μισειν υμασ εμε δε μισει οτι εγω μαρτυρω περι αυτου οτι τα εργα αυτου πονηρα εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","υμεισ αναβητε εισ την εορτην ταυτην εγω ουπω αναβαινω εισ την εορτην ταυτην οτι ο καιροσ ο εμοσ ουπω πεπληρωται ");
INSERT INTO grcmt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ταυτα δε ειπων αυτοισ εμεινεν εν τη γαλιλαια ");
INSERT INTO grcmt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ωσ δε ανεβησαν οι αδελφοι αυτου τοτε και αυτοσ ανεβη εισ την εορτην ου φανερωσ αλλ ωσ εν κρυπτω ");
INSERT INTO grcmt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","οι ουν ιουδαιοι εζητουν αυτον εν τη εορτη και ελεγον που εστιν εκεινοσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","και γογγυσμοσ πολυσ περι αυτου ην εν τοισ οχλοισ οι μεν ελεγον οτι αγαθοσ εστιν αλλοι ελεγον ου αλλα πλανα τον οχλον ");
INSERT INTO grcmt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ουδεισ μεντοι παρρησια ελαλει περι αυτου δια τον φοβον των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ηδη δε τησ εορτησ μεσουσησ ανεβη ο ιησουσ εισ το ιερον και εδιδασκεν ");
INSERT INTO grcmt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","και εθαυμαζον οι ιουδαιοι λεγοντεσ πωσ ουτοσ γραμματα οιδεν μη μεμαθηκωσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","απεκριθη ουν αυτοισ ο ιησουσ και ειπεν η εμη διδαχη ουκ εστιν εμη αλλα του πεμψαντοσ με ");
INSERT INTO grcmt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","εαν τισ θελη το θελημα αυτου ποιειν γνωσεται περι τησ διδαχησ ποτερον εκ του θεου εστιν η εγω απ εμαυτου λαλω ");
INSERT INTO grcmt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ο αφ εαυτου λαλων την δοξαν την ιδιαν ζητει ο δε ζητων την δοξαν του πεμψαντοσ αυτον ουτοσ αληθησ εστιν και αδικια εν αυτω ουκ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ου μωσησ δεδωκεν υμιν τον νομον και ουδεισ εξ υμων ποιει τον νομον τι με ζητειτε αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","απεκριθη ο οχλοσ και ειπεν δαιμονιον εχεισ τισ σε ζητει αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","απεκριθη ιησουσ και ειπεν αυτοισ εν εργον εποιησα και παντεσ θαυμαζετε ");
INSERT INTO grcmt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","δια τουτο μωσησ δεδωκεν υμιν την περιτομην ουχ οτι εκ του μωσεωσ εστιν αλλ εκ των πατερων και εν σαββατω περιτεμνετε ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ει περιτομην λαμβανει ανθρωποσ εν σαββατω ινα μη λυθη ο νομοσ μωσεωσ εμοι χολατε οτι ολον ανθρωπον υγιη εποιησα εν σαββατω ");
INSERT INTO grcmt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","μη κρινετε κατ οψιν αλλα την δικαιαν κρισιν κρινατε ");
INSERT INTO grcmt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ελεγον ουν τινεσ εκ των ιεροσολυμιτων ουχ ουτοσ εστιν ον ζητουσιν αποκτειναι ");
INSERT INTO grcmt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","και ιδε παρρησια λαλει και ουδεν αυτω λεγουσιν μηποτε αληθωσ εγνωσαν οι αρχοντεσ οτι ουτοσ εστιν αληθωσ ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","αλλα τουτον οιδαμεν ποθεν εστιν ο δε χριστοσ οταν ερχηται ουδεισ γινωσκει ποθεν εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","εκραξεν ουν εν τω ιερω διδασκων ο ιησουσ και λεγων καμε οιδατε και οιδατε ποθεν ειμι και απ εμαυτου ουκ εληλυθα αλλ εστιν αληθινοσ ο πεμψασ με ον υμεισ ουκ οιδατε ");
INSERT INTO grcmt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","εγω οιδα αυτον οτι παρ αυτου ειμι κακεινοσ με απεστειλεν ");
INSERT INTO grcmt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","εζητουν ουν αυτον πιασαι και ουδεισ επεβαλεν επ αυτον την χειρα οτι ουπω εληλυθει η ωρα αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","πολλοι δε εκ του οχλου επιστευσαν εισ αυτον και ελεγον οτι ο χριστοσ οταν ελθη μητι πλειονα σημεια τουτων ποιησει ων ουτοσ εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ηκουσαν οι φαρισαιοι του οχλου γογγυζοντοσ περι αυτου ταυτα και απεστειλαν υπηρετασ οι φαρισαιοι και οι αρχιερεισ ινα πιασωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ειπεν ουν ο ιησουσ ετι μικρον χρονον μεθ υμων ειμι και υπαγω προσ τον πεμψαντα με ");
INSERT INTO grcmt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ζητησετε με και ουχ ευρησετε και οπου ειμι εγω υμεισ ου δυνασθε ελθειν ");
INSERT INTO grcmt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ειπον ουν οι ιουδαιοι προσ εαυτουσ που ουτοσ μελλει πορευεσθαι οτι ημεισ ουχ ευρησομεν αυτον μη εισ την διασποραν των ελληνων μελλει πορευεσθαι και διδασκειν τουσ ελληνασ ");
INSERT INTO grcmt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","τισ εστιν ουτοσ ο λογοσ ον ειπεν ζητησετε με και ουχ ευρησετε και οπου ειμι εγω υμεισ ου δυνασθε ελθειν ");
INSERT INTO grcmt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","εν δε τη εσχατη ημερα τη μεγαλη τησ εορτησ ειστηκει ο ιησουσ και εκραξεν λεγων εαν τισ διψα ερχεσθω προσ με και πινετω ");
INSERT INTO grcmt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ο πιστευων εισ εμε καθωσ ειπεν η γραφη ποταμοι εκ τησ κοιλιασ αυτου ρευσουσιν υδατοσ ζωντοσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","τουτο δε ειπεν περι του πνευματοσ ου εμελλον λαμβανειν οι πιστευοντεσ εισ αυτον ουπω γαρ ην πνευμα αγιον οτι ιησουσ ουδεπω εδοξασθη ");
INSERT INTO grcmt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","πολλοι ουν εκ του οχλου ακουσαντεσ τον λογον ελεγον ουτοσ εστιν αληθωσ ο προφητησ ");
INSERT INTO grcmt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","αλλοι ελεγον ουτοσ εστιν ο χριστοσ αλλοι ελεγον μη γαρ εκ τησ γαλιλαιασ ο χριστοσ ερχεται ");
INSERT INTO grcmt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ουχι η γραφη ειπεν οτι εκ του σπερματοσ δαυιδ και απο βηθλεεμ τησ κωμησ οπου ην δαυιδ ο χριστοσ ερχεται ");
INSERT INTO grcmt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","σχισμα ουν εν τω οχλω εγενετο δι αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","τινεσ δε ηθελον εξ αυτων πιασαι αυτον αλλ ουδεισ επεβαλεν επ αυτον τασ χειρασ ");
INSERT INTO grcmt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ηλθον ουν οι υπηρεται προσ τουσ αρχιερεισ και φαρισαιουσ και ειπον αυτοισ εκεινοι δια τι ουκ ηγαγετε αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","απεκριθησαν οι υπηρεται ουδεποτε ουτωσ ελαλησεν ανθρωποσ ωσ ουτοσ ο ανθρωποσ ");
INSERT INTO grcmt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","απεκριθησαν ουν αυτοισ οι φαρισαιοι μη και υμεισ πεπλανησθε ");
INSERT INTO grcmt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","μη τισ εκ των αρχοντων επιστευσεν εισ αυτον η εκ των φαρισαιων ");
INSERT INTO grcmt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","αλλ ο οχλοσ ουτοσ ο μη γινωσκων τον νομον επικαταρατοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","λεγει νικοδημοσ προσ αυτουσ ο ελθων νυκτοσ προσ αυτον εισ ων εξ αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","μη ο νομοσ ημων κρινει τον ανθρωπον εαν μη ακουση παρ αυτου προτερον και γνω τι ποιει ");
INSERT INTO grcmt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","απεκριθησαν και ειπον αυτω μη και συ εκ τησ γαλιλαιασ ει ερευνησον και ιδε οτι προφητησ εκ τησ γαλιλαιασ ουκ εγηγερται ");
INSERT INTO grcmt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","και επορευθη εκαστοσ εισ τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ιησουσ δε επορευθη εισ το οροσ των ελαιων ");
INSERT INTO grcmt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ορθρου δε παλιν παρεγενετο εισ το ιερον και πασ ο λαοσ ηρχετο και καθισασ εδιδασκεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","αγουσιν δε οι γραμματεισ και οι φαρισαιοι προσ αυτον γυναικα εν μοιχεια καταληφθεισαν και στησαντεσ αυτην εν μεσω ");
INSERT INTO grcmt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","λεγουσιν αυτω πειραζοντεσ διδασκαλε αυτη η γυνη κατεληφθη επ αυτοφορω μοιχευομενη ");
INSERT INTO grcmt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","εν δε τω νομω μωσησ ημιν ενετειλατο τασ τοιαυτασ λιθοβολεισθαι συ ουν τι λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","τουτο δε ελεγον πειραζοντεσ αυτον ινα εχωσιν κατηγορειν αυτου ο δε ιησουσ κατω κυψασ τω δακτυλω εγραφεν εισ την γην μη προσποιουμενοσ ");
INSERT INTO grcmt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ωσ δε επεμενον ερωτωντεσ αυτον ανακυψασ ειπεν προσ αυτουσ ο αναμαρτητοσ υμων πρωτον επ αυτην τον λιθον βαλετω ");
INSERT INTO grcmt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","και παλιν κατω κυψασ εγραφεν εισ την γην ");
INSERT INTO grcmt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","οι δε ακουσαντεσ και υπο τησ συνειδησεωσ ελεγχομενοι εξηρχοντο εισ καθ εισ αρξαμενοι απο των πρεσβυτερων και κατελειφθη μονοσ ο ιησουσ και η γυνη εν μεσω ουσα ");
INSERT INTO grcmt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ανακυψασ δε ο ιησουσ και μηδενα θεασαμενοσ πλην τησ γυναικοσ ειπεν αυτη που εισιν εκεινοι οι κατηγοροι σου ουδεισ σε κατεκρινεν ");
INSERT INTO grcmt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","η δε ειπεν ουδεισ κυριε ειπεν δε ο ιησουσ ουδε εγω σε κρινω πορευου και μηκετι αμαρτανε ");
INSERT INTO grcmt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","παλιν ουν αυτοισ ο ιησουσ ελαλησεν λεγων εγω ειμι το φωσ του κοσμου ο ακολουθων εμοι ου μη περιπατηση εν τη σκοτια αλλ εξει το φωσ τησ ζωησ ");
INSERT INTO grcmt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ειπον ουν αυτω οι φαρισαιοι συ περι σεαυτου μαρτυρεισ η μαρτυρια σου ουκ εστιν αληθησ ");
INSERT INTO grcmt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","απεκριθη ιησουσ και ειπεν αυτοισ καν εγω μαρτυρω περι εμαυτου αληθησ εστιν η μαρτυρια μου οτι οιδα ποθεν ηλθον και που υπαγω υμεισ δε ουκ οιδατε ποθεν ερχομαι και που υπαγω ");
INSERT INTO grcmt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","υμεισ κατα την σαρκα κρινετε εγω ου κρινω ουδενα ");
INSERT INTO grcmt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","και εαν κρινω δε εγω η κρισισ η εμη αληθησ εστιν οτι μονοσ ουκ ειμι αλλ εγω και ο πεμψασ με πατηρ ");
INSERT INTO grcmt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","και εν τω νομω δε τω υμετερω γεγραπται οτι δυο ανθρωπων η μαρτυρια αληθησ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","εγω ειμι ο μαρτυρων περι εμαυτου και μαρτυρει περι εμου ο πεμψασ με πατηρ ");
INSERT INTO grcmt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ελεγον ουν αυτω που εστιν ο πατηρ σου απεκριθη ιησουσ ουτε εμε οιδατε ουτε τον πατερα μου ει εμε ηδειτε και τον πατερα μου ηδειτε αν ");
INSERT INTO grcmt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ταυτα τα ρηματα ελαλησεν ο ιησουσ εν τω γαζοφυλακιω διδασκων εν τω ιερω και ουδεισ επιασεν αυτον οτι ουπω εληλυθει η ωρα αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ειπεν ουν παλιν αυτοισ ο ιησουσ εγω υπαγω και ζητησετε με και εν τη αμαρτια υμων αποθανεισθε οπου εγω υπαγω υμεισ ου δυνασθε ελθειν ");
INSERT INTO grcmt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ελεγον ουν οι ιουδαιοι μητι αποκτενει εαυτον οτι λεγει οπου εγω υπαγω υμεισ ου δυνασθε ελθειν ");
INSERT INTO grcmt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","και ειπεν αυτοισ υμεισ εκ των κατω εστε εγω εκ των ανω ειμι υμεισ εκ του κοσμου τουτου εστε εγω ουκ ειμι εκ του κοσμου τουτου ");
INSERT INTO grcmt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ειπον ουν υμιν οτι αποθανεισθε εν ταισ αμαρτιαισ υμων εαν γαρ μη πιστευσητε οτι εγω ειμι αποθανεισθε εν ταισ αμαρτιαισ υμων ");
INSERT INTO grcmt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ελεγον ουν αυτω συ τισ ει και ειπεν αυτοισ ο ιησουσ την αρχην ο τι και λαλω υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","πολλα εχω περι υμων λαλειν και κρινειν αλλ ο πεμψασ με αληθησ εστιν καγω α ηκουσα παρ αυτου ταυτα λεγω εισ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ουκ εγνωσαν οτι τον πατερα αυτοισ ελεγεν ");
INSERT INTO grcmt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ειπεν ουν αυτοισ ο ιησουσ οταν υψωσητε τον υιον του ανθρωπου τοτε γνωσεσθε οτι εγω ειμι και απ εμαυτου ποιω ουδεν αλλα καθωσ εδιδαξεν με ο πατηρ μου ταυτα λαλω ");
INSERT INTO grcmt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","και ο πεμψασ με μετ εμου εστιν ουκ αφηκεν με μονον ο πατηρ οτι εγω τα αρεστα αυτω ποιω παντοτε ");
INSERT INTO grcmt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ταυτα αυτου λαλουντοσ πολλοι επιστευσαν εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ελεγεν ουν ο ιησουσ προσ τουσ πεπιστευκοτασ αυτω ιουδαιουσ εαν υμεισ μεινητε εν τω λογω τω εμω αληθωσ μαθηται μου εστε ");
INSERT INTO grcmt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","και γνωσεσθε την αληθειαν και η αληθεια ελευθερωσει υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","απεκριθησαν αυτω σπερμα αβρααμ εσμεν και ουδενι δεδουλευκαμεν πωποτε πωσ συ λεγεισ οτι ελευθεροι γενησεσθε ");
INSERT INTO grcmt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","απεκριθη αυτοισ ο ιησουσ αμην αμην λεγω υμιν οτι πασ ο ποιων την αμαρτιαν δουλοσ εστιν τησ αμαρτιασ ");
INSERT INTO grcmt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ο δε δουλοσ ου μενει εν τη οικια εισ τον αιωνα ο υιοσ μενει εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","εαν ουν ο υιοσ υμασ ελευθερωση οντωσ ελευθεροι εσεσθε ");
INSERT INTO grcmt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","οιδα οτι σπερμα αβρααμ εστε αλλα ζητειτε με αποκτειναι οτι ο λογοσ ο εμοσ ου χωρει εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","εγω ο εωρακα παρα τω πατρι μου λαλω και υμεισ ουν ο εωρακατε παρα τω πατρι υμων ποιειτε ");
INSERT INTO grcmt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","απεκριθησαν και ειπον αυτω ο πατηρ ημων αβρααμ εστιν λεγει αυτοισ ο ιησουσ ει τεκνα του αβρααμ ητε τα εργα του αβρααμ εποιειτε ");
INSERT INTO grcmt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","νυν δε ζητειτε με αποκτειναι ανθρωπον οσ την αληθειαν υμιν λελαληκα ην ηκουσα παρα του θεου τουτο αβρααμ ουκ εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","υμεισ ποιειτε τα εργα του πατροσ υμων ειπον ουν αυτω ημεισ εκ πορνειασ ου γεγεννημεθα ενα πατερα εχομεν τον θεον ");
INSERT INTO grcmt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ειπεν ουν αυτοισ ο ιησουσ ει ο θεοσ πατηρ υμων ην ηγαπατε αν εμε εγω γαρ εκ του θεου εξηλθον και ηκω ουδε γαρ απ εμαυτου εληλυθα αλλ εκεινοσ με απεστειλεν ");
INSERT INTO grcmt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","δια τι την λαλιαν την εμην ου γινωσκετε οτι ου δυνασθε ακουειν τον λογον τον εμον ");
INSERT INTO grcmt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","υμεισ εκ του πατροσ του διαβολου εστε και τασ επιθυμιασ του πατροσ υμων θελετε ποιειν εκεινοσ ανθρωποκτονοσ ην απ αρχησ και εν τη αληθεια ουχ εστηκεν οτι ουκ εστιν αληθεια εν αυτω οταν λαλη το ψευδοσ εκ των ιδιων λαλει οτι ψευστησ εστιν και ο πατηρ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","εγω δε οτι την αληθειαν λεγω ου πιστευετε μοι ");
INSERT INTO grcmt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","τισ εξ υμων ελεγχει με περι αμαρτιασ ει δε αληθειαν λεγω δια τι υμεισ ου πιστευετε μοι ");
INSERT INTO grcmt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ο ων εκ του θεου τα ρηματα του θεου ακουει δια τουτο υμεισ ουκ ακουετε οτι εκ του θεου ουκ εστε ");
INSERT INTO grcmt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","απεκριθησαν ουν οι ιουδαιοι και ειπον αυτω ου καλωσ λεγομεν ημεισ οτι σαμαρειτησ ει συ και δαιμονιον εχεισ ");
INSERT INTO grcmt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","απεκριθη ιησουσ εγω δαιμονιον ουκ εχω αλλα τιμω τον πατερα μου και υμεισ ατιμαζετε με ");
INSERT INTO grcmt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","εγω δε ου ζητω την δοξαν μου εστιν ο ζητων και κρινων ");
INSERT INTO grcmt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","αμην αμην λεγω υμιν εαν τισ τον λογον τον εμον τηρηση θανατον ου μη θεωρηση εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ειπον ουν αυτω οι ιουδαιοι νυν εγνωκαμεν οτι δαιμονιον εχεισ αβρααμ απεθανεν και οι προφηται και συ λεγεισ εαν τισ τον λογον μου τηρηση ου μη γευσηται θανατου εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","μη συ μειζων ει του πατροσ ημων αβρααμ οστισ απεθανεν και οι προφηται απεθανον τινα σεαυτον συ ποιεισ ");
INSERT INTO grcmt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","απεκριθη ιησουσ εαν εγω δοξαζω εμαυτον η δοξα μου ουδεν εστιν εστιν ο πατηρ μου ο δοξαζων με ον υμεισ λεγετε οτι θεοσ ημων εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","και ουκ εγνωκατε αυτον εγω δε οιδα αυτον και εαν ειπω οτι ουκ οιδα αυτον εσομαι ομοιοσ υμων ψευστησ αλλ οιδα αυτον και τον λογον αυτου τηρω ");
INSERT INTO grcmt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","αβρααμ ο πατηρ υμων ηγαλλιασατο ινα ιδη την ημεραν την εμην και ειδεν και εχαρη ");
INSERT INTO grcmt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ειπον ουν οι ιουδαιοι προσ αυτον πεντηκοντα ετη ουπω εχεισ και αβρααμ εωρακασ ");
INSERT INTO grcmt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ειπεν αυτοισ ο ιησουσ αμην αμην λεγω υμιν πριν αβρααμ γενεσθαι εγω ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ηραν ουν λιθουσ ινα βαλωσιν επ αυτον ιησουσ δε εκρυβη και εξηλθεν εκ του ιερου διελθων δια μεσου αυτων και παρηγεν ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","και παραγων ειδεν ανθρωπον τυφλον εκ γενετησ ");
INSERT INTO grcmt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","και ηρωτησαν αυτον οι μαθηται αυτου λεγοντεσ ραββι τισ ημαρτεν ουτοσ η οι γονεισ αυτου ινα τυφλοσ γεννηθη ");
INSERT INTO grcmt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","απεκριθη ιησουσ ουτε ουτοσ ημαρτεν ουτε οι γονεισ αυτου αλλ ινα φανερωθη τα εργα του θεου εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","εμε δει εργαζεσθαι τα εργα του πεμψαντοσ με εωσ ημερα εστιν ερχεται νυξ οτε ουδεισ δυναται εργαζεσθαι ");
INSERT INTO grcmt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","οταν εν τω κοσμω ω φωσ ειμι του κοσμου ");
INSERT INTO grcmt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ταυτα ειπων επτυσεν χαμαι και εποιησεν πηλον εκ του πτυσματοσ και επεχρισεν τον πηλον επι τουσ οφθαλμουσ του τυφλου ");
INSERT INTO grcmt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","και ειπεν αυτω υπαγε νιψαι εισ την κολυμβηθραν του σιλωαμ ο ερμηνευεται απεσταλμενοσ απηλθεν ουν και ενιψατο και ηλθεν βλεπων ");
INSERT INTO grcmt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","οι ουν γειτονεσ και οι θεωρουντεσ αυτον το προτερον οτι τυφλοσ ην ελεγον ουχ ουτοσ εστιν ο καθημενοσ και προσαιτων ");
INSERT INTO grcmt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","αλλοι ελεγον οτι ουτοσ εστιν αλλοι δε οτι ομοιοσ αυτω εστιν εκεινοσ ελεγεν οτι εγω ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ελεγον ουν αυτω πωσ ανεωχθησαν σου οι οφθαλμοι ");
INSERT INTO grcmt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","απεκριθη εκεινοσ και ειπεν ανθρωποσ λεγομενοσ ιησουσ πηλον εποιησεν και επεχρισεν μου τουσ οφθαλμουσ και ειπεν μοι υπαγε εισ την κολυμβηθραν του σιλωαμ και νιψαι απελθων δε και νιψαμενοσ ανεβλεψα ");
INSERT INTO grcmt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ειπον ουν αυτω που εστιν εκεινοσ λεγει ουκ οιδα ");
INSERT INTO grcmt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","αγουσιν αυτον προσ τουσ φαρισαιουσ τον ποτε τυφλον ");
INSERT INTO grcmt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ην δε σαββατον οτε τον πηλον εποιησεν ο ιησουσ και ανεωξεν αυτου τουσ οφθαλμουσ ");
INSERT INTO grcmt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","παλιν ουν ηρωτων αυτον και οι φαρισαιοι πωσ ανεβλεψεν ο δε ειπεν αυτοισ πηλον επεθηκεν μου επι τουσ οφθαλμουσ και ενιψαμην και βλεπω ");
INSERT INTO grcmt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ελεγον ουν εκ των φαρισαιων τινεσ ουτοσ ο ανθρωποσ ουκ εστιν παρα του θεου οτι το σαββατον ου τηρει αλλοι ελεγον πωσ δυναται ανθρωποσ αμαρτωλοσ τοιαυτα σημεια ποιειν και σχισμα ην εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","λεγουσιν τω τυφλω παλιν συ τι λεγεισ περι αυτου οτι ηνοιξεν σου τουσ οφθαλμουσ ο δε ειπεν οτι προφητησ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ουκ επιστευσαν ουν οι ιουδαιοι περι αυτου οτι τυφλοσ ην και ανεβλεψεν εωσ οτου εφωνησαν τουσ γονεισ αυτου του αναβλεψαντοσ ");
INSERT INTO grcmt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","και ηρωτησαν αυτουσ λεγοντεσ ουτοσ εστιν ο υιοσ υμων ον υμεισ λεγετε οτι τυφλοσ εγεννηθη πωσ ουν αρτι βλεπει ");
INSERT INTO grcmt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","απεκριθησαν δε αυτοισ οι γονεισ αυτου και ειπον οιδαμεν οτι ουτοσ εστιν ο υιοσ ημων και οτι τυφλοσ εγεννηθη ");
INSERT INTO grcmt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","πωσ δε νυν βλεπει ουκ οιδαμεν η τισ ηνοιξεν αυτου τουσ οφθαλμουσ ημεισ ουκ οιδαμεν αυτοσ ηλικιαν εχει αυτον ερωτησατε αυτοσ περι εαυτου λαλησει ");
INSERT INTO grcmt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ταυτα ειπον οι γονεισ αυτου οτι εφοβουντο τουσ ιουδαιουσ ηδη γαρ συνετεθειντο οι ιουδαιοι ινα εαν τισ αυτον ομολογηση χριστον αποσυναγωγοσ γενηται ");
INSERT INTO grcmt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","δια τουτο οι γονεισ αυτου ειπον οτι ηλικιαν εχει αυτον ερωτησατε ");
INSERT INTO grcmt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","εφωνησαν ουν εκ δευτερου τον ανθρωπον οσ ην τυφλοσ και ειπον αυτω δοσ δοξαν τω θεω ημεισ οιδαμεν οτι ο ανθρωποσ ουτοσ αμαρτωλοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","απεκριθη ουν εκεινοσ και ειπεν ει αμαρτωλοσ εστιν ουκ οιδα εν οιδα οτι τυφλοσ ων αρτι βλεπω ");
INSERT INTO grcmt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ειπον δε αυτω παλιν τι εποιησεν σοι πωσ ηνοιξεν σου τουσ οφθαλμουσ ");
INSERT INTO grcmt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","απεκριθη αυτοισ ειπον υμιν ηδη και ουκ ηκουσατε τι παλιν θελετε ακουειν μη και υμεισ θελετε αυτου μαθηται γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ελοιδορησαν αυτον και ειπον συ ει μαθητησ εκεινου ημεισ δε του μωσεωσ εσμεν μαθηται ");
INSERT INTO grcmt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ημεισ οιδαμεν οτι μωση λελαληκεν ο θεοσ τουτον δε ουκ οιδαμεν ποθεν εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","απεκριθη ο ανθρωποσ και ειπεν αυτοισ εν γαρ τουτω θαυμαστον εστιν οτι υμεισ ουκ οιδατε ποθεν εστιν και ανεωξεν μου τουσ οφθαλμουσ ");
INSERT INTO grcmt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","οιδαμεν δε οτι αμαρτωλων ο θεοσ ουκ ακουει αλλ εαν τισ θεοσεβησ η και το θελημα αυτου ποιη τουτου ακουει ");
INSERT INTO grcmt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","εκ του αιωνοσ ουκ ηκουσθη οτι ηνοιξεν τισ οφθαλμουσ τυφλου γεγεννημενου ");
INSERT INTO grcmt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ει μη ην ουτοσ παρα θεου ουκ ηδυνατο ποιειν ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","απεκριθησαν και ειπον αυτω εν αμαρτιαισ συ εγεννηθησ ολοσ και συ διδασκεισ ημασ και εξεβαλον αυτον εξω ");
INSERT INTO grcmt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ηκουσεν ο ιησουσ οτι εξεβαλον αυτον εξω και ευρων αυτον ειπεν αυτω συ πιστευεισ εισ τον υιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","απεκριθη εκεινοσ και ειπεν και τισ εστιν κυριε ινα πιστευσω εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ειπεν δε αυτω ο ιησουσ και εωρακασ αυτον και ο λαλων μετα σου εκεινοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ο δε εφη πιστευω κυριε και προσεκυνησεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","και ειπεν ο ιησουσ εισ κριμα εγω εισ τον κοσμον τουτον ηλθον ινα οι μη βλεποντεσ βλεπωσιν και οι βλεποντεσ τυφλοι γενωνται ");
INSERT INTO grcmt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","και ηκουσαν εκ των φαρισαιων ταυτα οι οντεσ μετ αυτου και ειπον αυτω μη και ημεισ τυφλοι εσμεν ");
INSERT INTO grcmt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ειπεν αυτοισ ο ιησουσ ει τυφλοι ητε ουκ αν ειχετε αμαρτιαν νυν δε λεγετε οτι βλεπομεν η ουν αμαρτια υμων μενει ");
INSERT INTO grcmt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","αμην αμην λεγω υμιν ο μη εισερχομενοσ δια τησ θυρασ εισ την αυλην των προβατων αλλα αναβαινων αλλαχοθεν εκεινοσ κλεπτησ εστιν και ληστησ ");
INSERT INTO grcmt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ο δε εισερχομενοσ δια τησ θυρασ ποιμην εστιν των προβατων ");
INSERT INTO grcmt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","τουτω ο θυρωροσ ανοιγει και τα προβατα τησ φωνησ αυτου ακουει και τα ιδια προβατα καλει κατ ονομα και εξαγει αυτα ");
INSERT INTO grcmt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","και οταν τα ιδια προβατα εκβαλη εμπροσθεν αυτων πορευεται και τα προβατα αυτω ακολουθει οτι οιδασιν την φωνην αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","αλλοτριω δε ου μη ακολουθησωσιν αλλα φευξονται απ αυτου οτι ουκ οιδασιν των αλλοτριων την φωνην ");
INSERT INTO grcmt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ταυτην την παροιμιαν ειπεν αυτοισ ο ιησουσ εκεινοι δε ουκ εγνωσαν τινα ην α ελαλει αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ειπεν ουν παλιν αυτοισ ο ιησουσ αμην αμην λεγω υμιν οτι εγω ειμι η θυρα των προβατων ");
INSERT INTO grcmt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","παντεσ οσοι ηλθον κλεπται εισιν και λησται αλλ ουκ ηκουσαν αυτων τα προβατα ");
INSERT INTO grcmt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","εγω ειμι η θυρα δι εμου εαν τισ εισελθη σωθησεται και εισελευσεται και εξελευσεται και νομην ευρησει ");
INSERT INTO grcmt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ο κλεπτησ ουκ ερχεται ει μη ινα κλεψη και θυση και απολεση εγω ηλθον ινα ζωην εχωσιν και περισσον εχωσιν ");
INSERT INTO grcmt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","εγω ειμι ο ποιμην ο καλοσ ο ποιμην ο καλοσ την ψυχην αυτου τιθησιν υπερ των προβατων ");
INSERT INTO grcmt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ο μισθωτοσ δε και ουκ ων ποιμην ου ουκ εισιν τα προβατα ιδια θεωρει τον λυκον ερχομενον και αφιησιν τα προβατα και φευγει και ο λυκοσ αρπαζει αυτα και σκορπιζει τα προβατα ");
INSERT INTO grcmt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ο δε μισθωτοσ φευγει οτι μισθωτοσ εστιν και ου μελει αυτω περι των προβατων ");
INSERT INTO grcmt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","εγω ειμι ο ποιμην ο καλοσ και γινωσκω τα εμα και γινωσκομαι υπο των εμων ");
INSERT INTO grcmt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","καθωσ γινωσκει με ο πατηρ καγω γινωσκω τον πατερα και την ψυχην μου τιθημι υπερ των προβατων ");
INSERT INTO grcmt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","και αλλα προβατα εχω α ουκ εστιν εκ τησ αυλησ ταυτησ κακεινα με δει αγαγειν και τησ φωνησ μου ακουσουσιν και γενησεται μια ποιμνη εισ ποιμην ");
INSERT INTO grcmt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","δια τουτο ο πατηρ με αγαπα οτι εγω τιθημι την ψυχην μου ινα παλιν λαβω αυτην ");
INSERT INTO grcmt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ουδεισ αιρει αυτην απ εμου αλλ εγω τιθημι αυτην απ εμαυτου εξουσιαν εχω θειναι αυτην και εξουσιαν εχω παλιν λαβειν αυτην ταυτην την εντολην ελαβον παρα του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","σχισμα ουν παλιν εγενετο εν τοισ ιουδαιοισ δια τουσ λογουσ τουτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ελεγον δε πολλοι εξ αυτων δαιμονιον εχει και μαινεται τι αυτου ακουετε ");
INSERT INTO grcmt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","αλλοι ελεγον ταυτα τα ρηματα ουκ εστιν δαιμονιζομενου μη δαιμονιον δυναται τυφλων οφθαλμουσ ανοιγειν ");
INSERT INTO grcmt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","εγενετο δε τα εγκαινια εν ιεροσολυμοισ και χειμων ην ");
INSERT INTO grcmt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","και περιεπατει ο ιησουσ εν τω ιερω εν τη στοα σολομωνοσ ");
INSERT INTO grcmt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","εκυκλωσαν ουν αυτον οι ιουδαιοι και ελεγον αυτω εωσ ποτε την ψυχην ημων αιρεισ ει συ ει ο χριστοσ ειπε ημιν παρρησια ");
INSERT INTO grcmt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","απεκριθη αυτοισ ο ιησουσ ειπον υμιν και ου πιστευετε τα εργα α εγω ποιω εν τω ονοματι του πατροσ μου ταυτα μαρτυρει περι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","αλλ υμεισ ου πιστευετε ου γαρ εστε εκ των προβατων των εμων καθωσ ειπον υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","τα προβατα τα εμα τησ φωνησ μου ακουει καγω γινωσκω αυτα και ακολουθουσιν μοι ");
INSERT INTO grcmt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","καγω ζωην αιωνιον διδωμι αυτοισ και ου μη απολωνται εισ τον αιωνα και ουχ αρπασει τισ αυτα εκ τησ χειροσ μου ");
INSERT INTO grcmt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ο πατηρ μου οσ δεδωκεν μοι μειζων παντων εστιν και ουδεισ δυναται αρπαζειν εκ τησ χειροσ του πατροσ μου ");
INSERT INTO grcmt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","εγω και ο πατηρ εν εσμεν ");
INSERT INTO grcmt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","εβαστασαν ουν παλιν λιθουσ οι ιουδαιοι ινα λιθασωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","απεκριθη αυτοισ ο ιησουσ πολλα καλα εργα εδειξα υμιν εκ του πατροσ μου δια ποιον αυτων εργον λιθαζετε με ");
INSERT INTO grcmt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","απεκριθησαν αυτω οι ιουδαιοι λεγοντεσ περι καλου εργου ου λιθαζομεν σε αλλα περι βλασφημιασ και οτι συ ανθρωποσ ων ποιεισ σεαυτον θεον ");
INSERT INTO grcmt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","απεκριθη αυτοισ ο ιησουσ ουκ εστιν γεγραμμενον εν τω νομω υμων εγω ειπα θεοι εστε ");
INSERT INTO grcmt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ει εκεινουσ ειπεν θεουσ προσ ουσ ο λογοσ του θεου εγενετο και ου δυναται λυθηναι η γραφη ");
INSERT INTO grcmt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ον ο πατηρ ηγιασεν και απεστειλεν εισ τον κοσμον υμεισ λεγετε οτι βλασφημεισ οτι ειπον υιοσ του θεου ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ει ου ποιω τα εργα του πατροσ μου μη πιστευετε μοι ");
INSERT INTO grcmt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ει δε ποιω καν εμοι μη πιστευητε τοισ εργοισ πιστευσατε ινα γνωτε και πιστευσητε οτι εν εμοι ο πατηρ καγω εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","εζητουν ουν παλιν αυτον πιασαι και εξηλθεν εκ τησ χειροσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","και απηλθεν παλιν περαν του ιορδανου εισ τον τοπον οπου ην ιωαννησ το πρωτον βαπτιζων και εμεινεν εκει ");
INSERT INTO grcmt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","και πολλοι ηλθον προσ αυτον και ελεγον οτι ιωαννησ μεν σημειον εποιησεν ουδεν παντα δε οσα ειπεν ιωαννησ περι τουτου αληθη ην ");
INSERT INTO grcmt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","και επιστευσαν πολλοι εκει εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ην δε τισ ασθενων λαζαροσ απο βηθανιασ εκ τησ κωμησ μαριασ και μαρθασ τησ αδελφησ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ην δε μαρια η αλειψασα τον κυριον μυρω και εκμαξασα τουσ ποδασ αυτου ταισ θριξιν αυτησ ησ ο αδελφοσ λαζαροσ ησθενει ");
INSERT INTO grcmt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","απεστειλαν ουν αι αδελφαι προσ αυτον λεγουσαι κυριε ιδε ον φιλεισ ασθενει ");
INSERT INTO grcmt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ακουσασ δε ο ιησουσ ειπεν αυτη η ασθενεια ουκ εστιν προσ θανατον αλλ υπερ τησ δοξησ του θεου ινα δοξασθη ο υιοσ του θεου δι αυτησ ");
INSERT INTO grcmt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ηγαπα δε ο ιησουσ την μαρθαν και την αδελφην αυτησ και τον λαζαρον ");
INSERT INTO grcmt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ωσ ουν ηκουσεν οτι ασθενει τοτε μεν εμεινεν εν ω ην τοπω δυο ημερασ ");
INSERT INTO grcmt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","επειτα μετα τουτο λεγει τοισ μαθηταισ αγωμεν εισ την ιουδαιαν παλιν ");
INSERT INTO grcmt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","λεγουσιν αυτω οι μαθηται ραββι νυν εζητουν σε λιθασαι οι ιουδαιοι και παλιν υπαγεισ εκει ");
INSERT INTO grcmt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","απεκριθη ιησουσ ουχι δωδεκα εισιν ωραι τησ ημερασ εαν τισ περιπατη εν τη ημερα ου προσκοπτει οτι το φωσ του κοσμου τουτου βλεπει ");
INSERT INTO grcmt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","εαν δε τισ περιπατη εν τη νυκτι προσκοπτει οτι το φωσ ουκ εστιν εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ταυτα ειπεν και μετα τουτο λεγει αυτοισ λαζαροσ ο φιλοσ ημων κεκοιμηται αλλα πορευομαι ινα εξυπνισω αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ειπον ουν οι μαθηται αυτου κυριε ει κεκοιμηται σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ειρηκει δε ο ιησουσ περι του θανατου αυτου εκεινοι δε εδοξαν οτι περι τησ κοιμησεωσ του υπνου λεγει ");
INSERT INTO grcmt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","τοτε ουν ειπεν αυτοισ ο ιησουσ παρρησια λαζαροσ απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","και χαιρω δι υμασ ινα πιστευσητε οτι ουκ ημην εκει αλλα αγωμεν προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ειπεν ουν θωμασ ο λεγομενοσ διδυμοσ τοισ συμμαθηταισ αγωμεν και ημεισ ινα αποθανωμεν μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ελθων ουν ο ιησουσ ευρεν αυτον τεσσαρασ ημερασ ηδη εχοντα εν τω μνημειω ");
INSERT INTO grcmt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ην δε η βηθανια εγγυσ των ιεροσολυμων ωσ απο σταδιων δεκαπεντε ");
INSERT INTO grcmt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","και πολλοι εκ των ιουδαιων εληλυθεισαν προσ τασ περι μαρθαν και μαριαν ινα παραμυθησωνται αυτασ περι του αδελφου αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","η ουν μαρθα ωσ ηκουσεν οτι ιησουσ ερχεται υπηντησεν αυτω μαρια δε εν τω οικω εκαθεζετο ");
INSERT INTO grcmt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ειπεν ουν μαρθα προσ τον ιησουν κυριε ει ησ ωδε ο αδελφοσ μου ουκ αν ετεθνηκει ");
INSERT INTO grcmt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","αλλα και νυν οιδα οτι οσα αν αιτηση τον θεον δωσει σοι ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","λεγει αυτη ο ιησουσ αναστησεται ο αδελφοσ σου ");
INSERT INTO grcmt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","λεγει αυτω μαρθα οιδα οτι αναστησεται εν τη αναστασει εν τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ειπεν αυτη ο ιησουσ εγω ειμι η αναστασισ και η ζωη ο πιστευων εισ εμε καν αποθανη ζησεται ");
INSERT INTO grcmt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","και πασ ο ζων και πιστευων εισ εμε ου μη αποθανη εισ τον αιωνα πιστευεισ τουτο ");
INSERT INTO grcmt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","λεγει αυτω ναι κυριε εγω πεπιστευκα οτι συ ει ο χριστοσ ο υιοσ του θεου ο εισ τον κοσμον ερχομενοσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","και ταυτα ειπουσα απηλθεν και εφωνησεν μαριαν την αδελφην αυτησ λαθρα ειπουσα ο διδασκαλοσ παρεστιν και φωνει σε ");
INSERT INTO grcmt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","εκεινη ωσ ηκουσεν εγειρεται ταχυ και ερχεται προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ουπω δε εληλυθει ο ιησουσ εισ την κωμην αλλ ην εν τω τοπω οπου υπηντησεν αυτω η μαρθα ");
INSERT INTO grcmt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","οι ουν ιουδαιοι οι οντεσ μετ αυτησ εν τη οικια και παραμυθουμενοι αυτην ιδοντεσ την μαριαν οτι ταχεωσ ανεστη και εξηλθεν ηκολουθησαν αυτη λεγοντεσ οτι υπαγει εισ το μνημειον ινα κλαυση εκει ");
INSERT INTO grcmt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","η ουν μαρια ωσ ηλθεν οπου ην ο ιησουσ ιδουσα αυτον επεσεν αυτου εισ τουσ ποδασ λεγουσα αυτω κυριε ει ησ ωδε ουκ αν απεθανεν μου ο αδελφοσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ιησουσ ουν ωσ ειδεν αυτην κλαιουσαν και τουσ συνελθοντασ αυτη ιουδαιουσ κλαιοντασ ενεβριμησατο τω πνευματι και εταραξεν εαυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","και ειπεν που τεθεικατε αυτον λεγουσιν αυτω κυριε ερχου και ιδε ");
INSERT INTO grcmt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","εδακρυσεν ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ελεγον ουν οι ιουδαιοι ιδε πωσ εφιλει αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","τινεσ δε εξ αυτων ειπον ουκ ηδυνατο ουτοσ ο ανοιξασ τουσ οφθαλμουσ του τυφλου ποιησαι ινα και ουτοσ μη αποθανη ");
INSERT INTO grcmt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ιησουσ ουν παλιν εμβριμωμενοσ εν εαυτω ερχεται εισ το μνημειον ην δε σπηλαιον και λιθοσ επεκειτο επ αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","λεγει ο ιησουσ αρατε τον λιθον λεγει αυτω η αδελφη του τεθνηκοτοσ μαρθα κυριε ηδη οζει τεταρταιοσ γαρ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","λεγει αυτη ο ιησουσ ουκ ειπον σοι οτι εαν πιστευσησ οψει την δοξαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ηραν ουν τον λιθον ου ην ο τεθνηκωσ κειμενοσ ο δε ιησουσ ηρεν τουσ οφθαλμουσ ανω και ειπεν πατερ ευχαριστω σοι οτι ηκουσασ μου ");
INSERT INTO grcmt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","εγω δε ηδειν οτι παντοτε μου ακουεισ αλλα δια τον οχλον τον περιεστωτα ειπον ινα πιστευσωσιν οτι συ με απεστειλασ ");
INSERT INTO grcmt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","και ταυτα ειπων φωνη μεγαλη εκραυγασεν λαζαρε δευρο εξω ");
INSERT INTO grcmt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","και εξηλθεν ο τεθνηκωσ δεδεμενοσ τουσ ποδασ και τασ χειρασ κειριαισ και η οψισ αυτου σουδαριω περιεδεδετο λεγει αυτοισ ο ιησουσ λυσατε αυτον και αφετε υπαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","πολλοι ουν εκ των ιουδαιων οι ελθοντεσ προσ την μαριαν και θεασαμενοι α εποιησεν ο ιησουσ επιστευσαν εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","τινεσ δε εξ αυτων απηλθον προσ τουσ φαρισαιουσ και ειπον αυτοισ α εποιησεν ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","συνηγαγον ουν οι αρχιερεισ και οι φαρισαιοι συνεδριον και ελεγον τι ποιουμεν οτι ουτοσ ο ανθρωποσ πολλα σημεια ποιει ");
INSERT INTO grcmt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","εαν αφωμεν αυτον ουτωσ παντεσ πιστευσουσιν εισ αυτον και ελευσονται οι ρωμαιοι και αρουσιν ημων και τον τοπον και το εθνοσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","εισ δε τισ εξ αυτων καιαφασ αρχιερευσ ων του ενιαυτου εκεινου ειπεν αυτοισ υμεισ ουκ οιδατε ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ουδε διαλογιζεσθε οτι συμφερει ημιν ινα εισ ανθρωποσ αποθανη υπερ του λαου και μη ολον το εθνοσ αποληται ");
INSERT INTO grcmt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","τουτο δε αφ εαυτου ουκ ειπεν αλλα αρχιερευσ ων του ενιαυτου εκεινου προεφητευσεν οτι εμελλεν ιησουσ αποθνησκειν υπερ του εθνουσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","και ουχ υπερ του εθνουσ μονον αλλ ινα και τα τεκνα του θεου τα διεσκορπισμενα συναγαγη εισ εν ");
INSERT INTO grcmt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","απ εκεινησ ουν τησ ημερασ συνεβουλευσαντο ινα αποκτεινωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ιησουσ ουν ουκετι παρρησια περιεπατει εν τοισ ιουδαιοισ αλλα απηλθεν εκειθεν εισ την χωραν εγγυσ τησ ερημου εισ εφραιμ λεγομενην πολιν κακει διετριβεν μετα των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ην δε εγγυσ το πασχα των ιουδαιων και ανεβησαν πολλοι εισ ιεροσολυμα εκ τησ χωρασ προ του πασχα ινα αγνισωσιν εαυτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","εζητουν ουν τον ιησουν και ελεγον μετ αλληλων εν τω ιερω εστηκοτεσ τι δοκει υμιν οτι ου μη ελθη εισ την εορτην ");
INSERT INTO grcmt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","δεδωκεισαν δε και οι αρχιερεισ και οι φαρισαιοι εντολην ινα εαν τισ γνω που εστιν μηνυση οπωσ πιασωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ο ουν ιησουσ προ εξ ημερων του πασχα ηλθεν εισ βηθανιαν οπου ην λαζαροσ ο τεθνηκωσ ον ηγειρεν εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","εποιησαν ουν αυτω δειπνον εκει και η μαρθα διηκονει ο δε λαζαροσ εισ ην των ανακειμενων συν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","η ουν μαρια λαβουσα λιτραν μυρου ναρδου πιστικησ πολυτιμου ηλειψεν τουσ ποδασ του ιησου και εξεμαξεν ταισ θριξιν αυτησ τουσ ποδασ αυτου η δε οικια επληρωθη εκ τησ οσμησ του μυρου ");
INSERT INTO grcmt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","λεγει ουν εισ εκ των μαθητων αυτου ιουδασ σιμωνοσ ισκαριωτησ ο μελλων αυτον παραδιδοναι ");
INSERT INTO grcmt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","δια τι τουτο το μυρον ουκ επραθη τριακοσιων δηναριων και εδοθη πτωχοισ ");
INSERT INTO grcmt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ειπεν δε τουτο ουχ οτι περι των πτωχων εμελεν αυτω αλλ οτι κλεπτησ ην και το γλωσσοκομον ειχεν και τα βαλλομενα εβασταζεν ");
INSERT INTO grcmt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ειπεν ουν ο ιησουσ αφεσ αυτην εισ την ημεραν του ενταφιασμου μου τετηρηκεν αυτο ");
INSERT INTO grcmt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","τουσ πτωχουσ γαρ παντοτε εχετε μεθ εαυτων εμε δε ου παντοτε εχετε ");
INSERT INTO grcmt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","εγνω ουν οχλοσ πολυσ εκ των ιουδαιων οτι εκει εστιν και ηλθον ου δια τον ιησουν μονον αλλ ινα και τον λαζαρον ιδωσιν ον ηγειρεν εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","εβουλευσαντο δε οι αρχιερεισ ινα και τον λαζαρον αποκτεινωσιν ");
INSERT INTO grcmt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","οτι πολλοι δι αυτον υπηγον των ιουδαιων και επιστευον εισ τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","τη επαυριον οχλοσ πολυσ ο ελθων εισ την εορτην ακουσαντεσ οτι ερχεται ιησουσ εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ελαβον τα βαια των φοινικων και εξηλθον εισ υπαντησιν αυτω και εκραζον ωσαννα ευλογημενοσ ο ερχομενοσ εν ονοματι κυριου βασιλευσ του ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ευρων δε ο ιησουσ οναριον εκαθισεν επ αυτο καθωσ εστιν γεγραμμενον ");
INSERT INTO grcmt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","μη φοβου θυγατερ σιων ιδου ο βασιλευσ σου ερχεται καθημενοσ επι πωλον ονου ");
INSERT INTO grcmt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ταυτα δε ουκ εγνωσαν οι μαθηται αυτου το πρωτον αλλ οτε εδοξασθη ιησουσ τοτε εμνησθησαν οτι ταυτα ην επ αυτω γεγραμμενα και ταυτα εποιησαν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","εμαρτυρει ουν ο οχλοσ ο ων μετ αυτου οτε τον λαζαρον εφωνησεν εκ του μνημειου και ηγειρεν αυτον εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","δια τουτο και υπηντησεν αυτω ο οχλοσ οτι ηκουσεν τουτο αυτον πεποιηκεναι το σημειον ");
INSERT INTO grcmt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","οι ουν φαρισαιοι ειπον προσ εαυτουσ θεωρειτε οτι ουκ ωφελειτε ουδεν ιδε ο κοσμοσ οπισω αυτου απηλθεν ");
INSERT INTO grcmt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ησαν δε τινεσ ελληνεσ εκ των αναβαινοντων ινα προσκυνησωσιν εν τη εορτη ");
INSERT INTO grcmt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ουτοι ουν προσηλθον φιλιππω τω απο βηθσαιδα τησ γαλιλαιασ και ηρωτων αυτον λεγοντεσ κυριε θελομεν τον ιησουν ιδειν ");
INSERT INTO grcmt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ερχεται φιλιπποσ και λεγει τω ανδρεα και παλιν ανδρεασ και φιλιπποσ λεγουσιν τω ιησου ");
INSERT INTO grcmt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ο δε ιησουσ απεκρινατο αυτοισ λεγων εληλυθεν η ωρα ινα δοξασθη ο υιοσ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","αμην αμην λεγω υμιν εαν μη ο κοκκοσ του σιτου πεσων εισ την γην αποθανη αυτοσ μονοσ μενει εαν δε αποθανη πολυν καρπον φερει ");
INSERT INTO grcmt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ο φιλων την ψυχην αυτου απολεσει αυτην και ο μισων την ψυχην αυτου εν τω κοσμω τουτω εισ ζωην αιωνιον φυλαξει αυτην ");
INSERT INTO grcmt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","εαν εμοι διακονη τισ εμοι ακολουθειτω και οπου ειμι εγω εκει και ο διακονοσ ο εμοσ εσται και εαν τισ εμοι διακονη τιμησει αυτον ο πατηρ ");
INSERT INTO grcmt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","νυν η ψυχη μου τεταρακται και τι ειπω πατερ σωσον με εκ τησ ωρασ ταυτησ αλλα δια τουτο ηλθον εισ την ωραν ταυτην ");
INSERT INTO grcmt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","πατερ δοξασον σου το ονομα ηλθεν ουν φωνη εκ του ουρανου και εδοξασα και παλιν δοξασω ");
INSERT INTO grcmt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ο ουν οχλοσ ο εστωσ και ακουσασ ελεγεν βροντην γεγονεναι αλλοι ελεγον αγγελοσ αυτω λελαληκεν ");
INSERT INTO grcmt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","απεκριθη ιησουσ και ειπεν ου δι εμε αυτη η φωνη γεγονεν αλλα δι υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","νυν κρισισ εστιν του κοσμου τουτου νυν ο αρχων του κοσμου τουτου εκβληθησεται εξω ");
INSERT INTO grcmt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","καγω εαν υψωθω εκ τησ γησ παντασ ελκυσω προσ εμαυτον ");
INSERT INTO grcmt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","τουτο δε ελεγεν σημαινων ποιω θανατω εμελλεν αποθνησκειν ");
INSERT INTO grcmt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","απεκριθη αυτω ο οχλοσ ημεισ ηκουσαμεν εκ του νομου οτι ο χριστοσ μενει εισ τον αιωνα και πωσ συ λεγεισ δει υψωθηναι τον υιον του ανθρωπου τισ εστιν ουτοσ ο υιοσ του ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ειπεν ουν αυτοισ ο ιησουσ ετι μικρον χρονον το φωσ μεθ υμων εστιν περιπατειτε εωσ το φωσ εχετε ινα μη σκοτια υμασ καταλαβη και ο περιπατων εν τη σκοτια ουκ οιδεν που υπαγει ");
INSERT INTO grcmt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","εωσ το φωσ εχετε πιστευετε εισ το φωσ ινα υιοι φωτοσ γενησθε ταυτα ελαλησεν ο ιησουσ και απελθων εκρυβη απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","τοσαυτα δε αυτου σημεια πεποιηκοτοσ εμπροσθεν αυτων ουκ επιστευον εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ινα ο λογοσ ησαιου του προφητου πληρωθη ον ειπεν κυριε τισ επιστευσεν τη ακοη ημων και ο βραχιων κυριου τινι απεκαλυφθη ");
INSERT INTO grcmt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","δια τουτο ουκ ηδυναντο πιστευειν οτι παλιν ειπεν ησαιασ ");
INSERT INTO grcmt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","τετυφλωκεν αυτων τουσ οφθαλμουσ και πεπωρωκεν αυτων την καρδιαν ινα μη ιδωσιν τοισ οφθαλμοισ και νοησωσιν τη καρδια και επιστραφωσιν και ιασωμαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ταυτα ειπεν ησαιασ οτε ειδεν την δοξαν αυτου και ελαλησεν περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ομωσ μεντοι και εκ των αρχοντων πολλοι επιστευσαν εισ αυτον αλλα δια τουσ φαρισαιουσ ουχ ωμολογουν ινα μη αποσυναγωγοι γενωνται ");
INSERT INTO grcmt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ηγαπησαν γαρ την δοξαν των ανθρωπων μαλλον ηπερ την δοξαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ιησουσ δε εκραξεν και ειπεν ο πιστευων εισ εμε ου πιστευει εισ εμε αλλ εισ τον πεμψαντα με ");
INSERT INTO grcmt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","και ο θεωρων εμε θεωρει τον πεμψαντα με ");
INSERT INTO grcmt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","εγω φωσ εισ τον κοσμον εληλυθα ινα πασ ο πιστευων εισ εμε εν τη σκοτια μη μεινη ");
INSERT INTO grcmt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","και εαν τισ μου ακουση των ρηματων και μη πιστευση εγω ου κρινω αυτον ου γαρ ηλθον ινα κρινω τον κοσμον αλλ ινα σωσω τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ο αθετων εμε και μη λαμβανων τα ρηματα μου εχει τον κρινοντα αυτον ο λογοσ ον ελαλησα εκεινοσ κρινει αυτον εν τη εσχατη ημερα ");
INSERT INTO grcmt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","οτι εγω εξ εμαυτου ουκ ελαλησα αλλ ο πεμψασ με πατηρ αυτοσ μοι εντολην εδωκεν τι ειπω και τι λαλησω ");
INSERT INTO grcmt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","και οιδα οτι η εντολη αυτου ζωη αιωνιοσ εστιν α ουν λαλω εγω καθωσ ειρηκεν μοι ο πατηρ ουτωσ λαλω ");
INSERT INTO grcmt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","προ δε τησ εορτησ του πασχα ειδωσ ο ιησουσ οτι εληλυθεν αυτου η ωρα ινα μεταβη εκ του κοσμου τουτου προσ τον πατερα αγαπησασ τουσ ιδιουσ τουσ εν τω κοσμω εισ τελοσ ηγαπησεν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","και δειπνου γενομενου του διαβολου ηδη βεβληκοτοσ εισ την καρδιαν ιουδα σιμωνοσ ισκαριωτου ινα αυτον παραδω ");
INSERT INTO grcmt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ειδωσ ο ιησουσ οτι παντα δεδωκεν αυτω ο πατηρ εισ τασ χειρασ και οτι απο θεου εξηλθεν και προσ τον θεον υπαγει ");
INSERT INTO grcmt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","εγειρεται εκ του δειπνου και τιθησιν τα ιματια και λαβων λεντιον διεζωσεν εαυτον ");
INSERT INTO grcmt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ειτα βαλλει υδωρ εισ τον νιπτηρα και ηρξατο νιπτειν τουσ ποδασ των μαθητων και εκμασσειν τω λεντιω ω ην διεζωσμενοσ ");
INSERT INTO grcmt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ερχεται ουν προσ σιμωνα πετρον και λεγει αυτω εκεινοσ κυριε συ μου νιπτεισ τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","απεκριθη ιησουσ και ειπεν αυτω ο εγω ποιω συ ουκ οιδασ αρτι γνωση δε μετα ταυτα ");
INSERT INTO grcmt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","λεγει αυτω πετροσ ου μη νιψησ τουσ ποδασ μου εισ τον αιωνα απεκριθη αυτω ο ιησουσ εαν μη νιψω σε ουκ εχεισ μεροσ μετ εμου ");
INSERT INTO grcmt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","λεγει αυτω σιμων πετροσ κυριε μη τουσ ποδασ μου μονον αλλα και τασ χειρασ και την κεφαλην ");
INSERT INTO grcmt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","λεγει αυτω ο ιησουσ ο λελουμενοσ ου χρειαν εχει η τουσ ποδασ νιψασθαι αλλ εστιν καθαροσ ολοσ και υμεισ καθαροι εστε αλλ ουχι παντεσ ");
INSERT INTO grcmt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ηδει γαρ τον παραδιδοντα αυτον δια τουτο ειπεν ουχι παντεσ καθαροι εστε ");
INSERT INTO grcmt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","οτε ουν ενιψεν τουσ ποδασ αυτων και ελαβεν τα ιματια αυτου αναπεσων παλιν ειπεν αυτοισ γινωσκετε τι πεποιηκα υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","υμεισ φωνειτε με ο διδασκαλοσ και ο κυριοσ και καλωσ λεγετε ειμι γαρ ");
INSERT INTO grcmt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ει ουν εγω ενιψα υμων τουσ ποδασ ο κυριοσ και ο διδασκαλοσ και υμεισ οφειλετε αλληλων νιπτειν τουσ ποδασ ");
INSERT INTO grcmt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","υποδειγμα γαρ εδωκα υμιν ινα καθωσ εγω εποιησα υμιν και υμεισ ποιητε ");
INSERT INTO grcmt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","αμην αμην λεγω υμιν ουκ εστιν δουλοσ μειζων του κυριου αυτου ουδε αποστολοσ μειζων του πεμψαντοσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ει ταυτα οιδατε μακαριοι εστε εαν ποιητε αυτα ");
INSERT INTO grcmt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ου περι παντων υμων λεγω εγω οιδα ουσ εξελεξαμην αλλ ινα η γραφη πληρωθη ο τρωγων μετ εμου τον αρτον επηρεν επ εμε την πτερναν αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","απ αρτι λεγω υμιν προ του γενεσθαι ινα οταν γενηται πιστευσητε οτι εγω ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","αμην αμην λεγω υμιν ο λαμβανων εαν τινα πεμψω εμε λαμβανει ο δε εμε λαμβανων λαμβανει τον πεμψαντα με ");
INSERT INTO grcmt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ταυτα ειπων ο ιησουσ εταραχθη τω πνευματι και εμαρτυρησεν και ειπεν αμην αμην λεγω υμιν οτι εισ εξ υμων παραδωσει με ");
INSERT INTO grcmt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","εβλεπον ουν εισ αλληλουσ οι μαθηται απορουμενοι περι τινοσ λεγει ");
INSERT INTO grcmt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ην δε ανακειμενοσ εισ των μαθητων αυτου εν τω κολπω του ιησου ον ηγαπα ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","νευει ουν τουτω σιμων πετροσ πυθεσθαι τισ αν ειη περι ου λεγει ");
INSERT INTO grcmt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","επιπεσων δε εκεινοσ ουτωσ επι το στηθοσ του ιησου λεγει αυτω κυριε τισ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","αποκρινεται ο ιησουσ εκεινοσ εστιν ω εγω βαψασ το ψωμιον επιδωσω και εμβαψασ το ψωμιον διδωσιν ιουδα σιμωνοσ ισκαριωτη ");
INSERT INTO grcmt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","και μετα το ψωμιον τοτε εισηλθεν εισ εκεινον ο σατανασ λεγει ουν αυτω ο ιησουσ ο ποιεισ ποιησον ταχιον ");
INSERT INTO grcmt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","τουτο δε ουδεισ εγνω των ανακειμενων προσ τι ειπεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","τινεσ γαρ εδοκουν επει το γλωσσοκομον ειχεν ο ιουδασ οτι λεγει αυτω ο ιησουσ αγορασον ων χρειαν εχομεν εισ την εορτην η τοισ πτωχοισ ινα τι δω ");
INSERT INTO grcmt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","λαβων ουν το ψωμιον εκεινοσ ευθεωσ εξηλθεν ην δε νυξ ");
INSERT INTO grcmt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","οτε εξηλθεν λεγει ο ιησουσ νυν εδοξασθη ο υιοσ του ανθρωπου και ο θεοσ εδοξασθη εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ει ο θεοσ εδοξασθη εν αυτω και ο θεοσ δοξασει αυτον εν εαυτω και ευθυσ δοξασει αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","τεκνια ετι μικρον μεθ υμων ειμι ζητησετε με και καθωσ ειπον τοισ ιουδαιοισ οτι οπου υπαγω εγω υμεισ ου δυνασθε ελθειν και υμιν λεγω αρτι ");
INSERT INTO grcmt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","εντολην καινην διδωμι υμιν ινα αγαπατε αλληλουσ καθωσ ηγαπησα υμασ ινα και υμεισ αγαπατε αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","εν τουτω γνωσονται παντεσ οτι εμοι μαθηται εστε εαν αγαπην εχητε εν αλληλοισ ");
INSERT INTO grcmt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","λεγει αυτω σιμων πετροσ κυριε που υπαγεισ απεκριθη αυτω ο ιησουσ οπου υπαγω ου δυνασαι μοι νυν ακολουθησαι υστερον δε ακολουθησεισ μοι ");
INSERT INTO grcmt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","λεγει αυτω πετροσ κυριε δια τι ου δυναμαι σοι ακολουθησαι αρτι την ψυχην μου υπερ σου θησω ");
INSERT INTO grcmt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","απεκριθη αυτω ο ιησουσ την ψυχην σου υπερ εμου θησεισ αμην αμην λεγω σοι ου μη αλεκτωρ φωνηση εωσ ου απαρνηση με τρισ ");
INSERT INTO grcmt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","μη ταρασσεσθω υμων η καρδια πιστευετε εισ τον θεον και εισ εμε πιστευετε ");
INSERT INTO grcmt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","εν τη οικια του πατροσ μου μοναι πολλαι εισιν ει δε μη ειπον αν υμιν πορευομαι ετοιμασαι τοπον υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","και εαν πορευθω ετοιμασω υμιν τοπον παλιν ερχομαι και παραληψομαι υμασ προσ εμαυτον ινα οπου ειμι εγω και υμεισ ητε ");
INSERT INTO grcmt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","και οπου εγω υπαγω οιδατε και την οδον οιδατε ");
INSERT INTO grcmt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","λεγει αυτω θωμασ κυριε ουκ οιδαμεν που υπαγεισ και πωσ δυναμεθα την οδον ειδεναι ");
INSERT INTO grcmt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","λεγει αυτω ο ιησουσ εγω ειμι η οδοσ και η αληθεια και η ζωη ουδεισ ερχεται προσ τον πατερα ει μη δι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ει εγνωκειτε με και τον πατερα μου εγνωκειτε αν και απ αρτι γινωσκετε αυτον και εωρακατε αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","λεγει αυτω φιλιπποσ κυριε δειξον ημιν τον πατερα και αρκει ημιν ");
INSERT INTO grcmt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","λεγει αυτω ο ιησουσ τοσουτον χρονον μεθ υμων ειμι και ουκ εγνωκασ με φιλιππε ο εωρακωσ εμε εωρακεν τον πατερα και πωσ συ λεγεισ δειξον ημιν τον πατερα ");
INSERT INTO grcmt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ου πιστευεισ οτι εγω εν τω πατρι και ο πατηρ εν εμοι εστιν τα ρηματα α εγω λαλω υμιν απ εμαυτου ου λαλω ο δε πατηρ ο εν εμοι μενων αυτοσ ποιει τα εργα ");
INSERT INTO grcmt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","πιστευετε μοι οτι εγω εν τω πατρι και ο πατηρ εν εμοι ει δε μη δια τα εργα αυτα πιστευετε μοι ");
INSERT INTO grcmt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","αμην αμην λεγω υμιν ο πιστευων εισ εμε τα εργα α εγω ποιω κακεινοσ ποιησει και μειζονα τουτων ποιησει οτι εγω προσ τον πατερα μου πορευομαι ");
INSERT INTO grcmt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","και ο τι αν αιτησητε εν τω ονοματι μου τουτο ποιησω ινα δοξασθη ο πατηρ εν τω υιω ");
INSERT INTO grcmt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","εαν τι αιτησητε με εν τω ονοματι μου εγω ποιησω ");
INSERT INTO grcmt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","εαν αγαπατε με τασ εντολασ τασ εμασ τηρησατε ");
INSERT INTO grcmt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","και εγω ερωτησω τον πατερα και αλλον παρακλητον δωσει υμιν ινα μενη μεθ υμων εισ τον αιωνα ");
INSERT INTO grcmt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","το πνευμα τησ αληθειασ ο ο κοσμοσ ου δυναται λαβειν οτι ου θεωρει αυτο ουδε γινωσκει αυτο υμεισ δε γινωσκετε αυτο οτι παρ υμιν μενει και εν υμιν εσται ");
INSERT INTO grcmt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ουκ αφησω υμασ ορφανουσ ερχομαι προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ετι μικρον και ο κοσμοσ με ουκετι θεωρει υμεισ δε θεωρειτε με οτι εγω ζω και υμεισ ζησεσθε ");
INSERT INTO grcmt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","εν εκεινη τη ημερα γνωσεσθε υμεισ οτι εγω εν τω πατρι μου και υμεισ εν εμοι και εγω εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ο εχων τασ εντολασ μου και τηρων αυτασ εκεινοσ εστιν ο αγαπων με ο δε αγαπων με αγαπηθησεται υπο του πατροσ μου και εγω αγαπησω αυτον και εμφανισω αυτω εμαυτον ");
INSERT INTO grcmt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","λεγει αυτω ιουδασ ουχ ο ισκαριωτησ κυριε και τι γεγονεν οτι ημιν μελλεισ εμφανιζειν σεαυτον και ουχι τω κοσμω ");
INSERT INTO grcmt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","απεκριθη ιησουσ και ειπεν αυτω εαν τισ αγαπα με τον λογον μου τηρησει και ο πατηρ μου αγαπησει αυτον και προσ αυτον ελευσομεθα και μονην παρ αυτω ποιησομεν ");
INSERT INTO grcmt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ο μη αγαπων με τουσ λογουσ μου ου τηρει και ο λογοσ ον ακουετε ουκ εστιν εμοσ αλλα του πεμψαντοσ με πατροσ ");
INSERT INTO grcmt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ταυτα λελαληκα υμιν παρ υμιν μενων ");
INSERT INTO grcmt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ο δε παρακλητοσ το πνευμα το αγιον ο πεμψει ο πατηρ εν τω ονοματι μου εκεινοσ υμασ διδαξει παντα και υπομνησει υμασ παντα α ειπον υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ειρηνην αφιημι υμιν ειρηνην την εμην διδωμι υμιν ου καθωσ ο κοσμοσ διδωσιν εγω διδωμι υμιν μη ταρασσεσθω υμων η καρδια μηδε δειλιατω ");
INSERT INTO grcmt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ηκουσατε οτι εγω ειπον υμιν υπαγω και ερχομαι προσ υμασ ει ηγαπατε με εχαρητε αν οτι ειπον πορευομαι προσ τον πατερα οτι ο πατηρ μου μειζων μου εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","και νυν ειρηκα υμιν πριν γενεσθαι ινα οταν γενηται πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ουκετι πολλα λαλησω μεθ υμων ερχεται γαρ ο του κοσμου αρχων και εν εμοι ουκ εχει ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","αλλ ινα γνω ο κοσμοσ οτι αγαπω τον πατερα και καθωσ ενετειλατο μοι ο πατηρ ουτωσ ποιω εγειρεσθε αγωμεν εντευθεν ");
INSERT INTO grcmt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","εγω ειμι η αμπελοσ η αληθινη και ο πατηρ μου ο γεωργοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","παν κλημα εν εμοι μη φερον καρπον αιρει αυτο και παν το καρπον φερον καθαιρει αυτο ινα πλειονα καρπον φερη ");
INSERT INTO grcmt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ηδη υμεισ καθαροι εστε δια τον λογον ον λελαληκα υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","μεινατε εν εμοι καγω εν υμιν καθωσ το κλημα ου δυναται καρπον φερειν αφ εαυτου εαν μη μεινη εν τη αμπελω ουτωσ ουδε υμεισ εαν μη εν εμοι μεινητε ");
INSERT INTO grcmt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","εγω ειμι η αμπελοσ υμεισ τα κληματα ο μενων εν εμοι καγω εν αυτω ουτοσ φερει καρπον πολυν οτι χωρισ εμου ου δυνασθε ποιειν ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","εαν μη τισ μεινη εν εμοι εβληθη εξω ωσ το κλημα και εξηρανθη και συναγουσιν αυτα και εισ το πυρ βαλλουσιν και καιεται ");
INSERT INTO grcmt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","εαν μεινητε εν εμοι και τα ρηματα μου εν υμιν μεινη ο εαν θελητε αιτησεσθε και γενησεται υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","εν τουτω εδοξασθη ο πατηρ μου ινα καρπον πολυν φερητε και γενησεσθε εμοι μαθηται ");
INSERT INTO grcmt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","καθωσ ηγαπησεν με ο πατηρ καγω ηγαπησα υμασ μεινατε εν τη αγαπη τη εμη ");
INSERT INTO grcmt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","εαν τασ εντολασ μου τηρησητε μενειτε εν τη αγαπη μου καθωσ εγω τασ εντολασ του πατροσ μου τετηρηκα και μενω αυτου εν τη αγαπη ");
INSERT INTO grcmt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ταυτα λελαληκα υμιν ινα η χαρα η εμη εν υμιν μεινη και η χαρα υμων πληρωθη ");
INSERT INTO grcmt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","αυτη εστιν η εντολη η εμη ινα αγαπατε αλληλουσ καθωσ ηγαπησα υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","μειζονα ταυτησ αγαπην ουδεισ εχει ινα τισ την ψυχην αυτου θη υπερ των φιλων αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","υμεισ φιλοι μου εστε εαν ποιητε οσα εγω εντελλομαι υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ουκετι υμασ λεγω δουλουσ οτι ο δουλοσ ουκ οιδεν τι ποιει αυτου ο κυριοσ υμασ δε ειρηκα φιλουσ οτι παντα α ηκουσα παρα του πατροσ μου εγνωρισα υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ουχ υμεισ με εξελεξασθε αλλ εγω εξελεξαμην υμασ και εθηκα υμασ ινα υμεισ υπαγητε και καρπον φερητε και ο καρποσ υμων μενη ινα ο τι αν αιτησητε τον πατερα εν τω ονοματι μου δω υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ταυτα εντελλομαι υμιν ινα αγαπατε αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ει ο κοσμοσ υμασ μισει γινωσκετε 1097 V-PAI-2P οτι εμε πρωτον υμων μεμισηκεν ");
INSERT INTO grcmt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ει εκ του κοσμου ητε ο κοσμοσ αν το ιδιον εφιλει οτι δε εκ του κοσμου ουκ εστε αλλ εγω εξελεξαμην υμασ εκ του κοσμου δια τουτο μισει υμασ ο κοσμοσ ");
INSERT INTO grcmt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","μνημονευετε του λογου ου εγω ειπον υμιν ουκ εστιν δουλοσ μειζων του κυριου αυτου ει εμε εδιωξαν και υμασ διωξουσιν ει τον λογον μου ετηρησαν και τον υμετερον τηρησουσιν ");
INSERT INTO grcmt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","αλλα ταυτα παντα ποιησουσιν υμιν δια το ονομα μου οτι ουκ οιδασιν τον πεμψαντα με ");
INSERT INTO grcmt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ει μη ηλθον και ελαλησα αυτοισ αμαρτιαν ουκ ειχον νυν δε προφασιν ουκ εχουσιν περι τησ αμαρτιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ο εμε μισων και τον πατερα μου μισει ");
INSERT INTO grcmt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ει τα εργα μη εποιησα εν αυτοισ α ουδεισ αλλοσ πεποιηκεν αμαρτιαν ουκ ειχον νυν δε και εωρακασιν και μεμισηκασιν και εμε και τον πατερα μου ");
INSERT INTO grcmt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","αλλ ινα πληρωθη ο λογοσ ο γεγραμμενοσ εν τω νομω αυτων οτι εμισησαν με δωρεαν ");
INSERT INTO grcmt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","οταν δε ελθη ο παρακλητοσ ον εγω πεμψω υμιν παρα του πατροσ το πνευμα τησ αληθειασ ο παρα του πατροσ εκπορευεται εκεινοσ μαρτυρησει περι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","και υμεισ δε μαρτυρειτε οτι απ αρχησ μετ εμου εστε ");
INSERT INTO grcmt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ταυτα λελαληκα υμιν ινα μη σκανδαλισθητε ");
INSERT INTO grcmt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","αποσυναγωγουσ ποιησουσιν υμασ αλλ ερχεται ωρα ινα πασ ο αποκτεινασ υμασ δοξη λατρειαν προσφερειν τω θεω ");
INSERT INTO grcmt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","και ταυτα ποιησουσιν οτι ουκ εγνωσαν τον πατερα ουδε εμε ");
INSERT INTO grcmt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","αλλα ταυτα λελαληκα υμιν ινα οταν ελθη η ωρα μνημονευητε αυτων οτι εγω ειπον υμιν ταυτα δε υμιν εξ αρχησ ουκ ειπον οτι μεθ υμων ημην ");
INSERT INTO grcmt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","νυν δε υπαγω προσ τον πεμψαντα με και ουδεισ εξ υμων ερωτα με που υπαγεισ ");
INSERT INTO grcmt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","αλλ οτι ταυτα λελαληκα υμιν η λυπη πεπληρωκεν υμων την καρδιαν ");
INSERT INTO grcmt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","αλλ εγω την αληθειαν λεγω υμιν συμφερει υμιν ινα εγω απελθω εαν γαρ εγω μη απελθω ο παρακλητοσ ουκ ελευσεται προσ υμασ εαν δε πορευθω πεμψω αυτον προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","και ελθων εκεινοσ ελεγξει τον κοσμον περι αμαρτιασ και περι δικαιοσυνησ και περι κρισεωσ ");
INSERT INTO grcmt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","περι αμαρτιασ μεν οτι ου πιστευουσιν εισ εμε ");
INSERT INTO grcmt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","περι δικαιοσυνησ δε οτι προσ τον πατερα μου υπαγω και ουκετι θεωρειτε με ");
INSERT INTO grcmt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","περι δε κρισεωσ οτι ο αρχων του κοσμου τουτου κεκριται ");
INSERT INTO grcmt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ετι πολλα εχω λεγειν υμιν αλλ ου δυνασθε βασταζειν αρτι ");
INSERT INTO grcmt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","οταν δε ελθη εκεινοσ το πνευμα τησ αληθειασ οδηγησει υμασ εισ πασαν την αληθειαν ου γαρ λαλησει αφ εαυτου αλλ οσα αν ακουση λαλησει και τα ερχομενα αναγγελει υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","εκεινοσ εμε δοξασει οτι εκ του εμου ληψεται και αναγγελει υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","παντα οσα εχει ο πατηρ εμα εστιν δια τουτο ειπον οτι εκ του εμου λαμβανει και αναγγελει υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","μικρον και ου θεωρειτε με και παλιν μικρον και οψεσθε με οτι υπαγω προσ τον πατερα ");
INSERT INTO grcmt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ειπον ουν εκ των μαθητων αυτου προσ αλληλουσ τι εστιν τουτο ο λεγει ημιν μικρον και ου θεωρειτε με και παλιν μικρον και οψεσθε με και οτι εγω υπαγω προσ τον πατερα ");
INSERT INTO grcmt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ελεγον ουν τουτο τι εστιν ο λεγει το μικρον ουκ οιδαμεν τι λαλει ");
INSERT INTO grcmt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","εγνω ουν ο ιησουσ οτι ηθελον αυτον ερωταν και ειπεν αυτοισ περι τουτου ζητειτε μετ αλληλων οτι ειπον μικρον και ου θεωρειτε με και παλιν μικρον και οψεσθε με ");
INSERT INTO grcmt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","αμην αμην λεγω υμιν οτι κλαυσετε και θρηνησετε υμεισ ο δε κοσμοσ χαρησεται υμεισ δε λυπηθησεσθε αλλ η λυπη υμων εισ χαραν γενησεται ");
INSERT INTO grcmt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","η γυνη οταν τικτη λυπην εχει οτι ηλθεν η ωρα αυτησ οταν δε γεννηση το παιδιον ουκετι μνημονευει τησ θλιψεωσ δια την χαραν οτι εγεννηθη ανθρωποσ εισ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","και υμεισ ουν λυπην μεν νυν εχετε παλιν δε οψομαι υμασ και χαρησεται υμων η καρδια και την χαραν υμων ουδεισ αιρει αφ υμων ");
INSERT INTO grcmt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","και εν εκεινη τη ημερα εμε ουκ ερωτησετε ουδεν αμην αμην λεγω υμιν οτι οσα αν αιτησητε τον πατερα εν τω ονοματι μου δωσει υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","εωσ αρτι ουκ ητησατε ουδεν εν τω ονοματι μου αιτειτε και ληψεσθε ινα η χαρα υμων η πεπληρωμενη ");
INSERT INTO grcmt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ταυτα εν παροιμιαισ λελαληκα υμιν αλλ ερχεται ωρα οτε ουκετι εν παροιμιαισ λαλησω υμιν αλλα παρρησια περι του πατροσ αναγγελω υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","εν εκεινη τη ημερα εν τω ονοματι μου αιτησεσθε και ου λεγω υμιν οτι εγω ερωτησω τον πατερα περι υμων ");
INSERT INTO grcmt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","αυτοσ γαρ ο πατηρ φιλει υμασ οτι υμεισ εμε πεφιληκατε και πεπιστευκατε οτι εγω παρα του θεου εξηλθον ");
INSERT INTO grcmt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","εξηλθον παρα του πατροσ και εληλυθα εισ τον κοσμον παλιν αφιημι τον κοσμον και πορευομαι προσ τον πατερα ");
INSERT INTO grcmt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","λεγουσιν αυτω οι μαθηται αυτου ιδε νυν παρρησια λαλεισ και παροιμιαν ουδεμιαν λεγεισ ");
INSERT INTO grcmt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","νυν οιδαμεν οτι οιδασ παντα και ου χρειαν εχεισ ινα τισ σε ερωτα εν τουτω πιστευομεν οτι απο θεου εξηλθεσ ");
INSERT INTO grcmt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","απεκριθη αυτοισ ο ιησουσ αρτι πιστευετε ");
INSERT INTO grcmt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ιδου ερχεται ωρα και νυν εληλυθεν ινα σκορπισθητε εκαστοσ εισ τα ιδια και εμε μονον αφητε και ουκ ειμι μονοσ οτι ο πατηρ μετ εμου εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ταυτα λελαληκα υμιν ινα εν εμοι ειρηνην εχητε εν τω κοσμω θλιψιν εχετε αλλα θαρσειτε εγω νενικηκα τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ταυτα ελαλησεν ο ιησουσ και επηρεν τουσ οφθαλμουσ αυτου εισ τον ουρανον και ειπεν πατερ εληλυθεν η ωρα δοξασον σου τον υιον ινα και ο υιοσ σου δοξαση σε ");
INSERT INTO grcmt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","καθωσ εδωκασ αυτω εξουσιαν πασησ σαρκοσ ινα παν ο δεδωκασ αυτω δωσει αυτοισ ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","αυτη δε εστιν η αιωνιοσ ζωη ινα γινωσκωσιν σε τον μονον αληθινον θεον και ον απεστειλασ ιησουν χριστον ");
INSERT INTO grcmt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","εγω σε εδοξασα επι τησ γησ το εργον ετελειωσα ο δεδωκασ μοι ινα ποιησω ");
INSERT INTO grcmt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","και νυν δοξασον με συ πατερ παρα σεαυτω τη δοξη η ειχον προ του τον κοσμον ειναι παρα σοι ");
INSERT INTO grcmt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","εφανερωσα σου το ονομα τοισ ανθρωποισ ουσ δεδωκασ μοι εκ του κοσμου σοι ησαν και εμοι αυτουσ δεδωκασ και τον λογον σου τετηρηκασιν ");
INSERT INTO grcmt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","νυν εγνωκαν οτι παντα οσα δεδωκασ μοι παρα σου εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","οτι τα ρηματα α δεδωκασ μοι δεδωκα αυτοισ και αυτοι ελαβον και εγνωσαν αληθωσ οτι παρα σου εξηλθον και επιστευσαν οτι συ με απεστειλασ ");
INSERT INTO grcmt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","εγω περι αυτων ερωτω ου περι του κοσμου ερωτω αλλα περι ων δεδωκασ μοι οτι σοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","και τα εμα παντα σα εστιν και τα σα εμα και δεδοξασμαι εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","και ουκετι ειμι εν τω κοσμω και ουτοι εν τω κοσμω εισιν και εγω προσ σε ερχομαι πατερ αγιε τηρησον αυτουσ εν τω ονοματι σου ω δεδωκασ μοι ινα ωσιν εν καθωσ ημεισ ");
INSERT INTO grcmt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","οτε ημην μετ αυτων εν τω κοσμω εγω ετηρουν αυτουσ εν τω ονοματι σου ουσ δεδωκασ μοι εφυλαξα και ουδεισ εξ αυτων απωλετο ει μη ο υιοσ τησ απωλειασ ινα η γραφη πληρωθη ");
INSERT INTO grcmt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","νυν δε προσ σε ερχομαι και ταυτα λαλω εν τω κοσμω ινα εχωσιν την χαραν την εμην πεπληρωμενην εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","εγω δεδωκα αυτοισ τον λογον σου και ο κοσμοσ εμισησεν αυτουσ οτι ουκ εισιν εκ του κοσμου καθωσ εγω ουκ ειμι εκ του κοσμου ");
INSERT INTO grcmt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ουκ ερωτω ινα αρησ αυτουσ εκ του κοσμου αλλ ινα τηρησησ αυτουσ εκ του πονηρου ");
INSERT INTO grcmt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","εκ του κοσμου ουκ εισιν καθωσ εγω εκ του κοσμου ουκ ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","αγιασον αυτουσ εν τη αληθεια σου ο λογοσ ο σοσ αληθεια εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","καθωσ εμε απεστειλασ εισ τον κοσμον καγω απεστειλα αυτουσ εισ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","και υπερ αυτων εγω αγιαζω εμαυτον ινα και αυτοι ωσιν ηγιασμενοι εν αληθεια ");
INSERT INTO grcmt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ου περι τουτων δε ερωτω μονον αλλα και περι των πιστευοντων δια του λογου αυτων εισ εμε ");
INSERT INTO grcmt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ινα παντεσ εν ωσιν καθωσ συ πατερ εν εμοι καγω εν σοι ινα και αυτοι εν ημιν εν ωσιν ινα ο κοσμοσ πιστευση οτι συ με απεστειλασ ");
INSERT INTO grcmt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","και εγω την δοξαν ην δεδωκασ μοι δεδωκα αυτοισ ινα ωσιν εν καθωσ ημεισ εν εσμεν ");
INSERT INTO grcmt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","εγω εν αυτοισ και συ εν εμοι ινα ωσιν τετελειωμενοι εισ εν και ινα γινωσκη ο κοσμοσ οτι συ με απεστειλασ και ηγαπησασ αυτουσ καθωσ εμε ηγαπησασ ");
INSERT INTO grcmt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","πατερ ουσ δεδωκασ μοι θελω ινα οπου ειμι εγω κακεινοι ωσιν μετ εμου ινα θεωρωσιν την δοξαν την εμην ην εδωκασ μοι οτι ηγαπησασ με προ καταβολησ κοσμου ");
INSERT INTO grcmt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","πατερ δικαιε και ο κοσμοσ σε ουκ εγνω εγω δε σε εγνων και ουτοι εγνωσαν οτι συ με απεστειλασ ");
INSERT INTO grcmt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","και εγνωρισα αυτοισ το ονομα σου και γνωρισω ινα η αγαπη ην ηγαπησασ με εν αυτοισ η καγω εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ταυτα ειπων ο ιησουσ εξηλθεν συν τοισ μαθηταισ αυτου περαν του χειμαρρου των κεδρων οπου ην κηποσ εισ ον εισηλθεν αυτοσ και οι μαθηται αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ηδει δε και ιουδασ ο παραδιδουσ αυτον τον τοπον οτι πολλακισ συνηχθη ο ιησουσ εκει μετα των μαθητων αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ο ουν ιουδασ λαβων την σπειραν και εκ των αρχιερεων και φαρισαιων υπηρετασ ερχεται εκει μετα φανων και λαμπαδων και οπλων ");
INSERT INTO grcmt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ιησουσ ουν ειδωσ παντα τα ερχομενα επ αυτον εξελθων ειπεν αυτοισ τινα ζητειτε ");
INSERT INTO grcmt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","απεκριθησαν αυτω ιησουν τον ναζωραιον λεγει αυτοισ ο ιησουσ εγω ειμι ειστηκει δε και ιουδασ ο παραδιδουσ αυτον μετ αυτων ");
INSERT INTO grcmt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ωσ ουν ειπεν αυτοισ οτι εγω ειμι απηλθον εισ τα οπισω και επεσον χαμαι ");
INSERT INTO grcmt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","παλιν ουν αυτουσ επηρωτησεν τινα ζητειτε οι δε ειπον ιησουν τον ναζωραιον ");
INSERT INTO grcmt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","απεκριθη ιησουσ ειπον υμιν οτι εγω ειμι ει ουν εμε ζητειτε αφετε τουτουσ υπαγειν ");
INSERT INTO grcmt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ινα πληρωθη ο λογοσ ον ειπεν οτι ουσ δεδωκασ μοι ουκ απωλεσα εξ αυτων ουδενα ");
INSERT INTO grcmt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","σιμων ουν πετροσ εχων μαχαιραν ειλκυσεν αυτην και επαισεν τον του αρχιερεωσ δουλον και απεκοψεν αυτου το ωτιον το δεξιον ην δε ονομα τω δουλω μαλχοσ ");
INSERT INTO grcmt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ειπεν ουν ο ιησουσ τω πετρω βαλε την μαχαιραν εισ την θηκην το ποτηριον ο δεδωκεν μοι ο πατηρ ου μη πιω αυτο ");
INSERT INTO grcmt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","η ουν σπειρα και ο χιλιαρχοσ και οι υπηρεται των ιουδαιων συνελαβον τον ιησουν και εδησαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","και απηγαγον αυτον προσ ανναν πρωτον ην γαρ πενθεροσ του καιαφα οσ ην αρχιερευσ του ενιαυτου εκεινου ");
INSERT INTO grcmt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ην δε καιαφασ ο συμβουλευσασ τοισ ιουδαιοισ οτι συμφερει ενα ανθρωπον απολεσθαι υπερ του λαου ");
INSERT INTO grcmt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ηκολουθει δε τω ιησου σιμων πετροσ και ο αλλοσ μαθητησ ο δε μαθητησ εκεινοσ ην γνωστοσ τω αρχιερει και συνεισηλθεν τω ιησου εισ την αυλην του αρχιερεωσ ");
INSERT INTO grcmt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ο δε πετροσ ειστηκει προσ τη θυρα εξω εξηλθεν ουν ο μαθητησ ο αλλοσ οσ ην γνωστοσ τω αρχιερει και ειπεν τη θυρωρω και εισηγαγεν τον πετρον ");
INSERT INTO grcmt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","λεγει ουν η παιδισκη η θυρωροσ τω πετρω μη και συ εκ των μαθητων ει του ανθρωπου τουτου λεγει εκεινοσ ουκ ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ειστηκεισαν δε οι δουλοι και οι υπηρεται ανθρακιαν πεποιηκοτεσ οτι ψυχοσ ην και εθερμαινοντο ην δε μετ αυτων ο πετροσ εστωσ και θερμαινομενοσ ");
INSERT INTO grcmt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ο ουν αρχιερευσ ηρωτησεν τον ιησουν περι των μαθητων αυτου και περι τησ διδαχησ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","απεκριθη αυτω ο ιησουσ εγω παρρησια ελαλησα τω κοσμω εγω παντοτε εδιδαξα εν συναγωγη και εν τω ιερω οπου παντοτε οι ιουδαιοι συνερχονται και εν κρυπτω ελαλησα ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","τι με επερωτασ επερωτησον τουσ ακηκοοτασ τι ελαλησα αυτοισ ιδε ουτοι οιδασιν α ειπον εγω ");
INSERT INTO grcmt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ταυτα δε αυτου ειποντοσ εισ των υπηρετων παρεστηκωσ εδωκεν ραπισμα τω ιησου ειπων ουτωσ αποκρινη τω αρχιερει ");
INSERT INTO grcmt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","απεκριθη αυτω ο ιησουσ ει κακωσ ελαλησα μαρτυρησον περι του κακου ει δε καλωσ τι με δερεισ ");
INSERT INTO grcmt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","απεστειλεν αυτον ο αννασ δεδεμενον προσ καιαφαν τον αρχιερεα ");
INSERT INTO grcmt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ην δε σιμων πετροσ εστωσ και θερμαινομενοσ ειπον ουν αυτω μη και συ εκ των μαθητων αυτου ει ηρνησατο ουν εκεινοσ και ειπεν ουκ ειμι ");
INSERT INTO grcmt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","λεγει εισ εκ των δουλων του αρχιερεωσ συγγενησ ων ου απεκοψεν πετροσ το ωτιον ουκ εγω σε ειδον εν τω κηπω μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","παλιν ουν ηρνησατο ο πετροσ και ευθεωσ αλεκτωρ εφωνησεν ");
INSERT INTO grcmt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","αγουσιν ουν τον ιησουν απο του καιαφα εισ το πραιτωριον ην δε πρωι και αυτοι ουκ εισηλθον εισ το πραιτωριον ινα μη μιανθωσιν αλλ ινα φαγωσιν το πασχα ");
INSERT INTO grcmt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","εξηλθεν ουν ο πιλατοσ προσ αυτουσ και ειπεν τινα κατηγοριαν φερετε κατα του ανθρωπου τουτου ");
INSERT INTO grcmt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","απεκριθησαν και ειπον αυτω ει μη ην ουτοσ κακοποιοσ ουκ αν σοι παρεδωκαμεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ειπεν ουν αυτοισ ο πιλατοσ λαβετε αυτον υμεισ και κατα τον νομον υμων κρινατε αυτον ειπον ουν αυτω οι ιουδαιοι ημιν ουκ εξεστιν αποκτειναι ουδενα ");
INSERT INTO grcmt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ινα ο λογοσ του ιησου πληρωθη ον ειπεν σημαινων ποιω θανατω εμελλεν αποθνησκειν ");
INSERT INTO grcmt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","εισηλθεν ουν εισ το πραιτωριον παλιν ο πιλατοσ και εφωνησεν τον ιησουν και ειπεν αυτω συ ει ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","απεκριθη αυτω ο ιησουσ αφ εαυτου συ τουτο λεγεισ η αλλοι σοι ειπον περι εμου ");
INSERT INTO grcmt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","απεκριθη ο πιλατοσ μητι εγω ιουδαιοσ ειμι το εθνοσ το σον και οι αρχιερεισ παρεδωκαν σε εμοι τι εποιησασ ");
INSERT INTO grcmt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","απεκριθη ιησουσ η βασιλεια η εμη ουκ εστιν εκ του κοσμου τουτου ει εκ του κοσμου τουτου ην η βασιλεια η εμη οι υπηρεται αν οι εμοι ηγωνιζοντο ινα μη παραδοθω τοισ ιουδαιοισ νυν δε η βασιλεια η εμη ουκ εστιν εντευθεν ");
INSERT INTO grcmt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ειπεν ουν αυτω ο πιλατοσ ουκουν βασιλευσ ει συ απεκριθη ιησουσ συ λεγεισ οτι βασιλευσ ειμι εγω εγω εισ τουτο γεγεννημαι και εισ τουτο εληλυθα εισ τον κοσμον ινα μαρτυρησω τη αληθεια πασ ο ων εκ τησ αληθειασ ακουει μου τησ φωνησ ");
INSERT INTO grcmt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","λεγει αυτω ο πιλατοσ τι εστιν αληθεια και τουτο ειπων παλιν εξηλθεν προσ τουσ ιουδαιουσ και λεγει αυτοισ εγω ουδεμιαν αιτιαν ευρισκω εν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","εστιν δε συνηθεια υμιν ινα ενα υμιν απολυσω εν τω πασχα βουλεσθε ουν υμιν απολυσω τον βασιλεα των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","εκραυγασαν ουν παλιν παντεσ λεγοντεσ μη τουτον αλλα τον βαραββαν ην δε ο βαραββασ ληστησ ");
INSERT INTO grcmt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","τοτε ουν ελαβεν ο πιλατοσ τον ιησουν και εμαστιγωσεν ");
INSERT INTO grcmt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","και οι στρατιωται πλεξαντεσ στεφανον εξ ακανθων επεθηκαν αυτου τη κεφαλη και ιματιον πορφυρουν περιεβαλον αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","και ελεγον χαιρε ο βασιλευσ των ιουδαιων και εδιδουν αυτω ραπισματα ");
INSERT INTO grcmt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","εξηλθεν ουν παλιν εξω ο πιλατοσ και λεγει αυτοισ ιδε αγω υμιν αυτον εξω ινα γνωτε οτι εν αυτω ουδεμιαν αιτιαν ευρισκω ");
INSERT INTO grcmt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","εξηλθεν ουν ο ιησουσ εξω φορων τον ακανθινον στεφανον και το πορφυρουν ιματιον και λεγει αυτοισ ιδε ο ανθρωποσ ");
INSERT INTO grcmt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","οτε ουν ειδον αυτον οι αρχιερεισ και οι υπηρεται εκραυγασαν λεγοντεσ σταυρωσον σταυρωσον αυτον λεγει αυτοισ ο πιλατοσ λαβετε αυτον υμεισ και σταυρωσατε εγω γαρ ουχ ευρισκω εν αυτω αιτιαν ");
INSERT INTO grcmt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","απεκριθησαν αυτω οι ιουδαιοι ημεισ νομον εχομεν και κατα τον νομον ημων οφειλει αποθανειν οτι εαυτον υιον θεου εποιησεν ");
INSERT INTO grcmt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","οτε ουν ηκουσεν ο πιλατοσ τουτον τον λογον μαλλον εφοβηθη ");
INSERT INTO grcmt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","και εισηλθεν εισ το πραιτωριον παλιν και λεγει τω ιησου ποθεν ει συ ο δε ιησουσ αποκρισιν ουκ εδωκεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","λεγει ουν αυτω ο πιλατοσ εμοι ου λαλεισ ουκ οιδασ οτι εξουσιαν εχω σταυρωσαι σε και εξουσιαν εχω απολυσαι σε ");
INSERT INTO grcmt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","απεκριθη ιησουσ ουκ ειχεσ εξουσιαν ουδεμιαν κατ εμου ει μη ην σοι δεδομενον ανωθεν δια τουτο ο παραδιδουσ με σοι μειζονα αμαρτιαν εχει ");
INSERT INTO grcmt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","εκ τουτου εζητει ο πιλατοσ απολυσαι αυτον οι δε ιουδαιοι εκραζον λεγοντεσ εαν τουτον απολυσησ ουκ ει φιλοσ του καισαροσ πασ ο βασιλεα εαυτον ποιων αντιλεγει τω καισαρι ");
INSERT INTO grcmt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ο ουν πιλατοσ ακουσασ τουτον τον λογον ηγαγεν εξω τον ιησουν και εκαθισεν επι του βηματοσ εισ τοπον λεγομενον λιθοστρωτον εβραιστι δε γαββαθα ");
INSERT INTO grcmt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ην δε παρασκευη του πασχα ωρα δε ωσει εκτη και λεγει τοισ ιουδαιοισ ιδε ο βασιλευσ υμων ");
INSERT INTO grcmt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","οι δε εκραυγασαν αρον αρον σταυρωσον αυτον λεγει αυτοισ ο πιλατοσ τον βασιλεα υμων σταυρωσω απεκριθησαν οι αρχιερεισ ουκ εχομεν βασιλεα ει μη καισαρα ");
INSERT INTO grcmt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","τοτε ουν παρεδωκεν αυτον αυτοισ ινα σταυρωθη παρελαβον δε τον ιησουν και ηγαγον ");
INSERT INTO grcmt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","και βασταζων τον σταυρον αυτου εξηλθεν εισ τοπον λεγομενον κρανιου τοπον οσ λεγεται εβραιστι γολγοθα ");
INSERT INTO grcmt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","οπου αυτον εσταυρωσαν και μετ αυτου αλλουσ δυο εντευθεν και εντευθεν μεσον δε τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","εγραψεν δε και τιτλον ο πιλατοσ και εθηκεν επι του σταυρου ην δε γεγραμμενον ιησουσ ο ναζωραιοσ ο βασιλευσ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","τουτον ουν τον τιτλον πολλοι ανεγνωσαν των ιουδαιων οτι εγγυσ ην ο τοποσ τησ πολεωσ οπου εσταυρωθη ο ιησουσ και ην γεγραμμενον εβραιστι ελληνιστι ρωμαιστι ");
INSERT INTO grcmt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ελεγον ουν τω πιλατω οι αρχιερεισ των ιουδαιων μη γραφε ο βασιλευσ των ιουδαιων αλλ οτι εκεινοσ ειπεν βασιλευσ ειμι των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","απεκριθη ο πιλατοσ ο γεγραφα γεγραφα ");
INSERT INTO grcmt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","οι ουν στρατιωται οτε εσταυρωσαν τον ιησουν ελαβον τα ιματια αυτου και εποιησαν τεσσαρα μερη εκαστω στρατιωτη μεροσ και τον χιτωνα ην δε ο χιτων αραφοσ εκ των ανωθεν υφαντοσ δι ολου ");
INSERT INTO grcmt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ειπον ουν προσ αλληλουσ μη σχισωμεν αυτον αλλα λαχωμεν περι αυτου τινοσ εσται ινα η γραφη πληρωθη η λεγουσα διεμερισαντο τα ιματια μου εαυτοισ και επι τον ιματισμον μου εβαλον κληρον οι μεν ουν στρατιωται ταυτα εποιησαν ");
INSERT INTO grcmt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ειστηκεισαν δε παρα τω σταυρω του ιησου η μητηρ αυτου και η αδελφη τησ μητροσ αυτου μαρια η του κλωπα και μαρια η μαγδαληνη ");
INSERT INTO grcmt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ιησουσ ουν ιδων την μητερα και τον μαθητην παρεστωτα ον ηγαπα λεγει τη μητρι αυτου γυναι ιδου ο υιοσ σου ");
INSERT INTO grcmt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ειτα λεγει τω μαθητη ιδου η μητηρ σου και απ εκεινησ τησ ωρασ ελαβεν ο μαθητησ αυτην εισ τα ιδια ");
INSERT INTO grcmt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","μετα τουτο ιδων ο ιησουσ οτι παντα ηδη τετελεσται ινα τελειωθη η γραφη λεγει διψω ");
INSERT INTO grcmt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","σκευοσ ουν εκειτο οξουσ μεστον οι δε πλησαντεσ σπογγον οξουσ και υσσωπω περιθεντεσ προσηνεγκαν αυτου τω στοματι ");
INSERT INTO grcmt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","οτε ουν ελαβεν το οξοσ ο ιησουσ ειπεν τετελεσται και κλινασ την κεφαλην παρεδωκεν το πνευμα ");
INSERT INTO grcmt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","οι ουν ιουδαιοι ινα μη μεινη επι του σταυρου τα σωματα εν τω σαββατω επει παρασκευη ην ην γαρ μεγαλη η ημερα εκεινου του σαββατου ηρωτησαν τον πιλατον ινα κατεαγωσιν αυτων τα σκελη και αρθωσιν ");
INSERT INTO grcmt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ηλθον ουν οι στρατιωται και του μεν πρωτου κατεαξαν τα σκελη και του αλλου του συσταυρωθεντοσ αυτω ");
INSERT INTO grcmt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","επι δε τον ιησουν ελθοντεσ ωσ ειδον αυτον ηδη τεθνηκοτα ου κατεαξαν αυτου τα σκελη ");
INSERT INTO grcmt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","αλλ εισ των στρατιωτων λογχη αυτου την πλευραν ενυξεν και ευθεωσ εξηλθεν αιμα και υδωρ ");
INSERT INTO grcmt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","και ο εωρακωσ μεμαρτυρηκεν και αληθινη εστιν αυτου η μαρτυρια κακεινοσ οιδεν οτι αληθη λεγει ινα υμεισ πιστευσητε ");
INSERT INTO grcmt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","εγενετο γαρ ταυτα ινα η γραφη πληρωθη οστουν ου συντριβησεται απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","και παλιν ετερα γραφη λεγει οψονται εισ ον εξεκεντησαν ");
INSERT INTO grcmt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","μετα ταυτα ηρωτησεν τον πιλατον ιωσηφ ο απο αριμαθαιασ ων μαθητησ του ιησου κεκρυμμενοσ δε δια τον φοβον των ιουδαιων ινα αρη το σωμα του ιησου και επετρεψεν ο πιλατοσ ηλθεν ουν και ηρεν το σωμα του ιησου ");
INSERT INTO grcmt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ηλθεν δε και νικοδημοσ ο ελθων προσ τον ιησουν νυκτοσ το πρωτον φερων μιγμα σμυρνησ και αλοησ ωσ λιτρασ εκατον ");
INSERT INTO grcmt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ελαβον ουν το σωμα του ιησου και εδησαν αυτο εν οθονιοισ μετα των αρωματων καθωσ εθοσ εστιν τοισ ιουδαιοισ ενταφιαζειν ");
INSERT INTO grcmt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ην δε εν τω τοπω οπου εσταυρωθη κηποσ και εν τω κηπω μνημειον καινον εν ω ουδεπω ουδεισ ετεθη ");
INSERT INTO grcmt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","εκει ουν δια την παρασκευην των ιουδαιων οτι εγγυσ ην το μνημειον εθηκαν τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","τη δε μια των σαββατων μαρια η μαγδαληνη ερχεται πρωι σκοτιασ ετι ουσησ εισ το μνημειον και βλεπει τον λιθον ηρμενον εκ του μνημειου ");
INSERT INTO grcmt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","τρεχει ουν και ερχεται προσ σιμωνα πετρον και προσ τον αλλον μαθητην ον εφιλει ο ιησουσ και λεγει αυτοισ ηραν τον κυριον εκ του μνημειου και ουκ οιδαμεν που εθηκαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","εξηλθεν ουν ο πετροσ και ο αλλοσ μαθητησ και ηρχοντο εισ το μνημειον ");
INSERT INTO grcmt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ετρεχον δε οι δυο ομου και ο αλλοσ μαθητησ προεδραμεν ταχιον του πετρου και ηλθεν πρωτοσ εισ το μνημειον ");
INSERT INTO grcmt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","και παρακυψασ βλεπει κειμενα τα οθονια ου μεντοι εισηλθεν ");
INSERT INTO grcmt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ερχεται ουν σιμων πετροσ ακολουθων αυτω και εισηλθεν εισ το μνημειον και θεωρει τα οθονια κειμενα ");
INSERT INTO grcmt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","και το σουδαριον ο ην επι τησ κεφαλησ αυτου ου μετα των οθονιων κειμενον αλλα χωρισ εντετυλιγμενον εισ ενα τοπον ");
INSERT INTO grcmt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","τοτε ουν εισηλθεν και ο αλλοσ μαθητησ ο ελθων πρωτοσ εισ το μνημειον και ειδεν και επιστευσεν ");
INSERT INTO grcmt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ουδεπω γαρ ηδεισαν την γραφην οτι δει αυτον εκ νεκρων αναστηναι ");
INSERT INTO grcmt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","απηλθον ουν παλιν προσ εαυτουσ οι μαθηται ");
INSERT INTO grcmt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","μαρια δε ειστηκει προσ το μνημειον κλαιουσα εξω ωσ ουν εκλαιεν παρεκυψεν εισ το μνημειον ");
INSERT INTO grcmt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","και θεωρει δυο αγγελουσ εν λευκοισ καθεζομενουσ ενα προσ τη κεφαλη και ενα προσ τοισ ποσιν οπου εκειτο το σωμα του ιησου ");
INSERT INTO grcmt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","και λεγουσιν αυτη εκεινοι γυναι τι κλαιεισ λεγει αυτοισ οτι ηραν τον κυριον μου και ουκ οιδα που εθηκαν αυτον ");
INSERT INTO grcmt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","και ταυτα ειπουσα εστραφη εισ τα οπισω και θεωρει τον ιησουν εστωτα και ουκ ηδει οτι ιησουσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","λεγει αυτη ο ιησουσ γυναι τι κλαιεισ τινα ζητεισ εκεινη δοκουσα οτι ο κηπουροσ εστιν λεγει αυτω κυριε ει συ εβαστασασ αυτον ειπε μοι που εθηκασ αυτον καγω αυτον αρω ");
INSERT INTO grcmt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","λεγει αυτη ο ιησουσ μαρια στραφεισα εκεινη λεγει αυτω ραββουνι ο λεγεται διδασκαλε ");
INSERT INTO grcmt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","λεγει αυτη ο ιησουσ μη μου απτου ουπω γαρ αναβεβηκα προσ τον πατερα μου πορευου δε προσ τουσ αδελφουσ μου και ειπε αυτοισ αναβαινω προσ τον πατερα μου και πατερα υμων και θεον μου και θεον υμων ");
INSERT INTO grcmt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ερχεται μαρια η μαγδαληνη απαγγελλουσα τοισ μαθηταισ οτι εωρακεν τον κυριον και ταυτα ειπεν αυτη ");
INSERT INTO grcmt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ουσησ ουν οψιασ τη ημερα εκεινη τη μια των σαββατων και των θυρων κεκλεισμενων οπου ησαν οι μαθηται συνηγμενοι δια τον φοβον των ιουδαιων ηλθεν ο ιησουσ και εστη εισ το μεσον και λεγει αυτοισ ειρηνη υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","και τουτο ειπων εδειξεν αυτοισ τασ χειρασ και την πλευραν αυτου εχαρησαν ουν οι μαθηται ιδοντεσ τον κυριον ");
INSERT INTO grcmt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ειπεν ουν αυτοισ ο ιησουσ παλιν ειρηνη υμιν καθωσ απεσταλκεν με ο πατηρ καγω πεμπω υμασ ");
INSERT INTO grcmt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","και τουτο ειπων ενεφυσησεν και λεγει αυτοισ λαβετε πνευμα αγιον ");
INSERT INTO grcmt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","αν τινων αφητε τασ αμαρτιασ αφιενται αυτοισ αν τινων κρατητε κεκρατηνται ");
INSERT INTO grcmt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","θωμασ δε εισ εκ των δωδεκα ο λεγομενοσ διδυμοσ ουκ ην μετ αυτων οτε ηλθεν ο ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ελεγον ουν αυτω οι αλλοι μαθηται εωρακαμεν τον κυριον ο δε ειπεν αυτοισ εαν μη ιδω εν ταισ χερσιν αυτου τον τυπον των ηλων και βαλω τον δακτυλον μου εισ τον τυπον των ηλων και βαλω την χειρα μου εισ την πλευραν αυτου ου μη πιστευσω ");
INSERT INTO grcmt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","και μεθ ημερασ οκτω παλιν ησαν εσω οι μαθηται αυτου και θωμασ μετ αυτων ερχεται ο ιησουσ των θυρων κεκλεισμενων και εστη εισ το μεσον και ειπεν ειρηνη υμιν ");
INSERT INTO grcmt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ειτα λεγει τω θωμα φερε τον δακτυλον σου ωδε και ιδε τασ χειρασ μου και φερε την χειρα σου και βαλε εισ την πλευραν μου και μη γινου απιστοσ αλλα πιστοσ ");
INSERT INTO grcmt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","και απεκριθη θωμασ και ειπεν αυτω ο κυριοσ μου και ο θεοσ μου ");
INSERT INTO grcmt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","λεγει αυτω ο ιησουσ οτι εωρακασ με πεπιστευκασ μακαριοι οι μη ιδοντεσ και πιστευσαντεσ ");
INSERT INTO grcmt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","πολλα μεν ουν και αλλα σημεια εποιησεν ο ιησουσ ενωπιον των μαθητων αυτου α ουκ εστιν γεγραμμενα εν τω βιβλιω τουτω ");
INSERT INTO grcmt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ταυτα δε γεγραπται ινα πιστευσητε οτι ιησουσ εστιν ο χριστοσ ο υιοσ του θεου και ινα πιστευοντεσ ζωην εχητε εν τω ονοματι αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","μετα ταυτα εφανερωσεν εαυτον παλιν ο ιησουσ τοισ μαθηταισ επι τησ θαλασσησ τησ τιβεριαδοσ εφανερωσεν δε ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ησαν ομου σιμων πετροσ και θωμασ ο λεγομενοσ διδυμοσ και ναθαναηλ ο απο κανα τησ γαλιλαιασ και οι του ζεβεδαιου και αλλοι εκ των μαθητων αυτου δυο ");
INSERT INTO grcmt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","λεγει αυτοισ σιμων πετροσ υπαγω αλιευειν λεγουσιν αυτω ερχομεθα και ημεισ συν σοι εξηλθον και ενεβησαν εισ το πλοιον ευθυσ και εν εκεινη τη νυκτι επιασαν ουδεν ");
INSERT INTO grcmt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","πρωιασ δε ηδη γενομενησ εστη ο ιησουσ εισ τον αιγιαλον ου μεντοι ηδεισαν οι μαθηται οτι ιησουσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","λεγει ουν αυτοισ ο ιησουσ παιδια μη τι προσφαγιον εχετε απεκριθησαν αυτω ου ");
INSERT INTO grcmt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ο δε ειπεν αυτοισ βαλετε εισ τα δεξια μερη του πλοιου το δικτυον και ευρησετε εβαλον ουν και ουκετι αυτο ελκυσαι ισχυσαν απο του πληθουσ των ιχθυων ");
INSERT INTO grcmt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","λεγει ουν ο μαθητησ εκεινοσ ον ηγαπα ο ιησουσ τω πετρω ο κυριοσ εστιν σιμων ουν πετροσ ακουσασ οτι ο κυριοσ εστιν τον επενδυτην διεζωσατο ην γαρ γυμνοσ και εβαλεν εαυτον εισ την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","οι δε αλλοι μαθηται τω πλοιαριω ηλθον ου γαρ ησαν μακραν απο τησ γησ αλλ ωσ απο πηχων διακοσιων συροντεσ το δικτυον των ιχθυων ");
INSERT INTO grcmt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ωσ ουν απεβησαν εισ την γην βλεπουσιν ανθρακιαν κειμενην και οψαριον επικειμενον και αρτον ");
INSERT INTO grcmt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","λεγει αυτοισ ο ιησουσ ενεγκατε απο των οψαριων ων επιασατε νυν ");
INSERT INTO grcmt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ανεβη σιμων πετροσ και ειλκυσεν το δικτυον επι τησ γησ μεστον ιχθυων μεγαλων εκατον πεντηκοντα τριων και τοσουτων οντων ουκ εσχισθη το δικτυον ");
INSERT INTO grcmt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","λεγει αυτοισ ο ιησουσ δευτε αριστησατε ουδεισ δε ετολμα των μαθητων εξετασαι αυτον συ τισ ει ειδοτεσ οτι ο κυριοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ερχεται ουν ο ιησουσ και λαμβανει τον αρτον και διδωσιν αυτοισ και το οψαριον ομοιωσ ");
INSERT INTO grcmt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","τουτο ηδη τριτον εφανερωθη ο ιησουσ τοισ μαθηταισ αυτου εγερθεισ εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","οτε ουν ηριστησαν λεγει τω σιμωνι πετρω ο ιησουσ σιμων ιωνα αγαπασ με πλειον τουτων 3778 D-GPM λεγει αυτω ναι κυριε συ οιδασ οτι φιλω σε λεγει αυτω βοσκε τα αρνια μου ");
INSERT INTO grcmt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","λεγει αυτω παλιν δευτερον σιμων ιωνα αγαπασ με λεγει αυτω ναι κυριε συ οιδασ οτι φιλω σε λεγει αυτω ποιμαινε τα προβατα μου ");
INSERT INTO grcmt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","λεγει αυτω το τριτον σιμων ιωνα φιλεισ με ελυπηθη ο πετροσ οτι ειπεν αυτω το τριτον φιλεισ με και ειπεν αυτω κυριε συ παντα οιδασ συ γινωσκεισ οτι φιλω σε λεγει αυτω ο ιησουσ βοσκε τα προβατα μου ");
INSERT INTO grcmt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","αμην αμην λεγω σοι οτε ησ νεωτεροσ εζωννυεσ σεαυτον και περιεπατεισ οπου ηθελεσ οταν δε γηρασησ εκτενεισ τασ χειρασ σου και αλλοσ σε ζωσει και οισει οπου ου θελεισ ");
INSERT INTO grcmt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","τουτο δε ειπεν σημαινων ποιω θανατω δοξασει τον θεον και τουτο ειπων λεγει αυτω ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","επιστραφεισ δε ο πετροσ βλεπει τον μαθητην ον ηγαπα ο ιησουσ ακολουθουντα οσ και ανεπεσεν εν τω δειπνω επι το στηθοσ αυτου και ειπεν κυριε τισ εστιν ο παραδιδουσ σε ");
INSERT INTO grcmt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","τουτον ιδων ο πετροσ λεγει τω ιησου κυριε ουτοσ δε τι ");
INSERT INTO grcmt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","λεγει αυτω ο ιησουσ εαν αυτον θελω μενειν εωσ ερχομαι τι προσ σε συ ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","εξηλθεν ουν ο λογοσ ουτοσ εισ τουσ αδελφουσ οτι ο μαθητησ εκεινοσ ουκ αποθνησκει και ουκ ειπεν αυτω ο ιησουσ οτι ουκ αποθνησκει αλλ εαν αυτον θελω μενειν εωσ ερχομαι τι προσ σε ");
INSERT INTO grcmt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ουτοσ εστιν ο μαθητησ ο μαρτυρων περι τουτων και γραψασ ταυτα και οιδαμεν οτι αληθησ εστιν η μαρτυρια αυτου ");
INSERT INTO grcmt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","εστιν δε και αλλα πολλα οσα εποιησεν ο ιησουσ ατινα εαν γραφηται καθ εν ουδε αυτον οιμαι τον κοσμον χωρησαι τα γραφομενα βιβλια αμην ");
INSERT INTO grcmt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","τον μεν πρωτον λογον εποιησαμην περι παντων ω θεοφιλε ων ηρξατο ο ιησουσ ποιειν τε και διδασκειν ");
INSERT INTO grcmt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","αχρι ησ ημερασ εντειλαμενοσ τοισ αποστολοισ δια πνευματοσ αγιου ουσ εξελεξατο ανεληφθη ");
INSERT INTO grcmt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","οισ και παρεστησεν εαυτον ζωντα μετα το παθειν αυτον εν πολλοισ τεκμηριοισ δι ημερων τεσσαρακοντα οπτανομενοσ αυτοισ και λεγων τα περι τησ βασιλειασ του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","και συναλιζομενοσ παρηγγειλεν αυτοισ απο ιεροσολυμων μη χωριζεσθαι αλλα περιμενειν την επαγγελιαν του πατροσ ην ηκουσατε μου ");
INSERT INTO grcmt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","οτι ιωαννησ μεν εβαπτισεν υδατι υμεισ δε βαπτισθησεσθε εν πνευματι αγιω ου μετα πολλασ ταυτασ ημερασ ");
INSERT INTO grcmt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","οι μεν ουν συνελθοντεσ επηρωτων αυτον λεγοντεσ κυριε ει εν τω χρονω τουτω αποκαθιστανεισ την βασιλειαν τω ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ειπεν δε προσ αυτουσ ουχ υμων εστιν γνωναι χρονουσ η καιρουσ ουσ ο πατηρ εθετο εν τη ιδια εξουσια ");
INSERT INTO grcmt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","αλλα ληψεσθε δυναμιν επελθοντοσ του αγιου πνευματοσ εφ υμασ και εσεσθε μοι μαρτυρεσ εν τε ιερουσαλημ και εν παση τη ιουδαια και σαμαρεια και εωσ εσχατου τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","και ταυτα ειπων βλεποντων αυτων επηρθη και νεφελη υπελαβεν αυτον απο των οφθαλμων αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","και ωσ ατενιζοντεσ ησαν εισ τον ουρανον πορευομενου αυτου και ιδου ανδρεσ δυο παρειστηκεισαν αυτοισ εν εσθητι λευκη ");
INSERT INTO grcmt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","οι και ειπον ανδρεσ γαλιλαιοι τι εστηκατε εμβλεποντεσ εισ τον ουρανον ουτοσ ο ιησουσ ο αναληφθεισ αφ υμων εισ τον ουρανον ουτωσ ελευσεται ον τροπον εθεασασθε αυτον πορευομενον εισ τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","τοτε υπεστρεψαν εισ ιερουσαλημ απο ορουσ του καλουμενου ελαιωνοσ ο εστιν εγγυσ ιερουσαλημ σαββατου εχον οδον ");
INSERT INTO grcmt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","και οτε εισηλθον ανεβησαν εισ το υπερωον ου ησαν καταμενοντεσ ο τε πετροσ και ιακωβοσ και ιωαννησ και ανδρεασ φιλιπποσ και θωμασ βαρθολομαιοσ και ματθαιοσ ιακωβοσ αλφαιου και σιμων ο ζηλωτησ και ιουδασ ιακωβου ");
INSERT INTO grcmt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ουτοι παντεσ ησαν προσκαρτερουντεσ ομοθυμαδον τη προσευχη και τη δεησει συν γυναιξιν και μαρια τη μητρι του ιησου και συν τοισ αδελφοισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","και εν ταισ ημεραισ ταυταισ αναστασ πετροσ εν μεσω των μαθητων ειπεν ην τε οχλοσ ονοματων επι το αυτο ωσ εκατον εικοσι ");
INSERT INTO grcmt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ανδρεσ αδελφοι εδει πληρωθηναι την γραφην ταυτην ην προειπεν το πνευμα το αγιον δια στοματοσ δαυιδ περι ιουδα του γενομενου οδηγου τοισ συλλαβουσιν τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","οτι κατηριθμημενοσ ην συν ημιν και ελαχεν τον κληρον τησ διακονιασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ουτοσ μεν ουν εκτησατο χωριον εκ μισθου τησ αδικιασ και πρηνησ γενομενοσ ελακησεν μεσοσ και εξεχυθη παντα τα σπλαγχνα αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","και γνωστον εγενετο πασιν τοισ κατοικουσιν ιερουσαλημ ωστε κληθηναι το χωριον εκεινο τη ιδια διαλεκτω αυτων ακελδαμα τουτ εστιν χωριον αιματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","γεγραπται γαρ εν βιβλω ψαλμων γενηθητω η επαυλισ αυτου ερημοσ και μη εστω ο κατοικων εν αυτη και την επισκοπην αυτου λαβοι ετεροσ ");
INSERT INTO grcmt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","δει ουν των συνελθοντων ημιν ανδρων εν παντι χρονω εν ω εισηλθεν και εξηλθεν εφ ημασ ο κυριοσ ιησουσ ");
INSERT INTO grcmt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","αρξαμενοσ απο του βαπτισματοσ ιωαννου εωσ τησ ημερασ ησ ανεληφθη αφ ημων μαρτυρα τησ αναστασεωσ αυτου γενεσθαι συν ημιν ενα τουτων ");
INSERT INTO grcmt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","και εστησαν δυο ιωσηφ τον καλουμενον βαρσαβαν οσ επεκληθη ιουστοσ και ματθιαν ");
INSERT INTO grcmt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","και προσευξαμενοι ειπον συ κυριε καρδιογνωστα παντων αναδειξον ον εξελεξω εκ τουτων των δυο ενα ");
INSERT INTO grcmt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","λαβειν τον κληρον τησ διακονιασ ταυτησ και αποστολησ εξ ησ παρεβη ιουδασ πορευθηναι εισ τον τοπον τον ιδιον ");
INSERT INTO grcmt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","και εδωκαν κληρουσ αυτων και επεσεν ο κληροσ επι ματθιαν και συγκατεψηφισθη μετα των ενδεκα αποστολων ");
INSERT INTO grcmt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","και εν τω συμπληρουσθαι την ημεραν τησ πεντηκοστησ ησαν απαντεσ ομοθυμαδον επι το αυτο ");
INSERT INTO grcmt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","και εγενετο αφνω εκ του ουρανου ηχοσ ωσπερ φερομενησ πνοησ βιαιασ και επληρωσεν ολον τον οικον ου ησαν καθημενοι ");
INSERT INTO grcmt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","και ωφθησαν αυτοισ διαμεριζομεναι γλωσσαι ωσει πυροσ εκαθισεν τε εφ ενα εκαστον αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","και επλησθησαν απαντεσ πνευματοσ αγιου και ηρξαντο λαλειν ετεραισ γλωσσαισ καθωσ το πνευμα εδιδου αυτοισ αποφθεγγεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ησαν δε εν ιερουσαλημ κατοικουντεσ ιουδαιοι ανδρεσ ευλαβεισ απο παντοσ εθνουσ των υπο τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","γενομενησ δε τησ φωνησ ταυτησ συνηλθεν το πληθοσ και συνεχυθη οτι ηκουον εισ εκαστοσ τη ιδια διαλεκτω λαλουντων αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","εξισταντο δε παντεσ και εθαυμαζον λεγοντεσ προσ αλληλουσ ουκ ιδου παντεσ ουτοι εισιν οι λαλουντεσ γαλιλαιοι ");
INSERT INTO grcmt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","και πωσ ημεισ ακουομεν εκαστοσ τη ιδια διαλεκτω ημων εν η εγεννηθημεν ");
INSERT INTO grcmt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","παρθοι και μηδοι και ελαμιται και οι κατοικουντεσ την μεσοποταμιαν ιουδαιαν τε και καππαδοκιαν ποντον και την ασιαν ");
INSERT INTO grcmt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","φρυγιαν τε και παμφυλιαν αιγυπτον και τα μερη τησ λιβυησ τησ κατα κυρηνην και οι επιδημουντεσ ρωμαιοι ιουδαιοι τε και προσηλυτοι ");
INSERT INTO grcmt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","κρητεσ και αραβεσ ακουομεν λαλουντων αυτων ταισ ημετεραισ γλωσσαισ τα μεγαλεια του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","εξισταντο δε παντεσ και διηπορουν αλλοσ προσ αλλον λεγοντεσ τι αν θελοι τουτο ειναι ");
INSERT INTO grcmt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ετεροι δε χλευαζοντεσ ελεγον οτι γλευκουσ μεμεστωμενοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","σταθεισ δε πετροσ συν τοισ ενδεκα επηρεν την φωνην αυτου και απεφθεγξατο αυτοισ ανδρεσ ιουδαιοι και οι κατοικουντεσ ιερουσαλημ απαντεσ τουτο υμιν γνωστον εστω και ενωτισασθε τα ρηματα μου ");
INSERT INTO grcmt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ου γαρ ωσ υμεισ υπολαμβανετε ουτοι μεθυουσιν εστιν γαρ ωρα τριτη τησ ημερασ ");
INSERT INTO grcmt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","αλλα τουτο εστιν το ειρημενον δια του προφητου ιωηλ ");
INSERT INTO grcmt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","και εσται εν ταισ εσχαταισ ημεραισ λεγει ο θεοσ εκχεω απο του πνευματοσ μου επι πασαν σαρκα και προφητευσουσιν οι υιοι υμων και αι θυγατερεσ υμων και οι νεανισκοι υμων ορασεισ οψονται και οι πρεσβυτεροι υμων ενυπνια ενυπνιασθησονται ");
INSERT INTO grcmt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","και γε επι τουσ δουλουσ μου και επι τασ δουλασ μου εν ταισ ημεραισ εκειναισ εκχεω απο του πνευματοσ μου και προφητευσουσιν ");
INSERT INTO grcmt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","και δωσω τερατα εν τω ουρανω ανω και σημεια επι τησ γησ κατω αιμα και πυρ και ατμιδα καπνου ");
INSERT INTO grcmt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ο ηλιοσ μεταστραφησεται εισ σκοτοσ και η σεληνη εισ αιμα πριν η ελθειν την ημεραν κυριου την μεγαλην και επιφανη ");
INSERT INTO grcmt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","και εσται πασ οσ αν επικαλεσηται το ονομα κυριου σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ανδρεσ ισραηλιται ακουσατε τουσ λογουσ τουτουσ ιησουν τον ναζωραιον ανδρα απο του θεου αποδεδειγμενον εισ υμασ δυναμεσιν και τερασιν και σημειοισ οισ εποιησεν δι αυτου ο θεοσ εν μεσω υμων καθωσ και αυτοι οιδατε ");
INSERT INTO grcmt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","τουτον τη ωρισμενη βουλη και προγνωσει του θεου εκδοτον λαβοντεσ δια χειρων ανομων προσπηξαντεσ ανειλετε ");
INSERT INTO grcmt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ον ο θεοσ ανεστησεν λυσασ τασ ωδινασ του θανατου καθοτι ουκ ην δυνατον κρατεισθαι αυτον υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","δαυιδ γαρ λεγει εισ αυτον προωρωμην τον κυριον ενωπιον μου δια παντοσ οτι εκ δεξιων μου εστιν ινα μη σαλευθω ");
INSERT INTO grcmt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","δια τουτο ευφρανθη η καρδια μου και ηγαλλιασατο η γλωσσα μου ετι δε και η σαρξ μου κατασκηνωσει επ ελπιδι ");
INSERT INTO grcmt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","οτι ουκ εγκαταλειψεισ την ψυχην μου εισ αδου ουδε δωσεισ τον οσιον σου ιδειν διαφθοραν ");
INSERT INTO grcmt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","εγνωρισασ μοι οδουσ ζωησ πληρωσεισ με ευφροσυνησ μετα του προσωπου σου ");
INSERT INTO grcmt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ανδρεσ αδελφοι εξον ειπειν μετα παρρησιασ προσ υμασ περι του πατριαρχου δαυιδ οτι και ετελευτησεν και εταφη και το μνημα αυτου εστιν εν ημιν αχρι τησ ημερασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","προφητησ ουν υπαρχων και ειδωσ οτι ορκω ωμοσεν αυτω ο θεοσ εκ καρπου τησ οσφυοσ αυτου το κατα σαρκα αναστησειν τον χριστον καθισαι επι του θρονου αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","προιδων ελαλησεν περι τησ αναστασεωσ του χριστου οτι ου κατελειφθη η ψυχη αυτου εισ αδου ουδε η σαρξ αυτου ειδεν διαφθοραν ");
INSERT INTO grcmt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","τουτον τον ιησουν ανεστησεν ο θεοσ ου παντεσ ημεισ εσμεν μαρτυρεσ ");
INSERT INTO grcmt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","τη δεξια ουν του θεου υψωθεισ την τε επαγγελιαν του αγιου πνευματοσ λαβων παρα του πατροσ εξεχεεν τουτο ο νυν υμεισ βλεπετε και ακουετε ");
INSERT INTO grcmt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ου γαρ δαυιδ ανεβη εισ τουσ ουρανουσ λεγει δε αυτοσ ειπεν ο κυριοσ τω κυριω μου καθου εκ δεξιων μου ");
INSERT INTO grcmt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","εωσ αν θω τουσ εχθρουσ σου υποποδιον των ποδων σου ");
INSERT INTO grcmt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ασφαλωσ ουν γινωσκετω πασ οικοσ ισραηλ οτι και κυριον και χριστον αυτον ο θεοσ εποιησεν τουτον τον ιησουν ον υμεισ εσταυρωσατε ");
INSERT INTO grcmt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ακουσαντεσ δε κατενυγησαν τη καρδια ειπον τε προσ τον πετρον και τουσ λοιπουσ αποστολουσ τι ποιησομεν ανδρεσ αδελφοι ");
INSERT INTO grcmt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","πετροσ δε εφη προσ αυτουσ μετανοησατε και βαπτισθητω εκαστοσ υμων επι τω ονοματι ιησου χριστου εισ αφεσιν αμαρτιων και ληψεσθε την δωρεαν του αγιου πνευματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","υμιν γαρ εστιν η επαγγελια και τοισ τεκνοισ υμων και πασιν τοισ εισ μακραν οσουσ αν προσκαλεσηται κυριοσ ο θεοσ ημων ");
INSERT INTO grcmt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ετεροισ τε λογοισ πλειοσιν διεμαρτυρετο και παρεκαλει λεγων σωθητε απο τησ γενεασ τησ σκολιασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","οι μεν ουν ασμενωσ αποδεξαμενοι τον λογον αυτου εβαπτισθησαν και προσετεθησαν τη ημερα εκεινη ψυχαι ωσει τρισχιλιαι ");
INSERT INTO grcmt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ησαν δε προσκαρτερουντεσ τη διδαχη των αποστολων και τη κοινωνια και τη κλασει του αρτου και ταισ προσευχαισ ");
INSERT INTO grcmt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","εγενετο δε παση ψυχη φοβοσ πολλα τε τερατα και σημεια δια των αποστολων εγινετο ");
INSERT INTO grcmt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","παντεσ δε οι πιστευοντεσ ησαν επι το αυτο και ειχον απαντα κοινα ");
INSERT INTO grcmt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","και τα κτηματα και τασ υπαρξεισ επιπρασκον και διεμεριζον αυτα πασιν καθοτι αν τισ χρειαν ειχεν ");
INSERT INTO grcmt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","καθ ημεραν τε προσκαρτερουντεσ ομοθυμαδον εν τω ιερω κλωντεσ τε κατ οικον αρτον μετελαμβανον τροφησ εν αγαλλιασει και αφελοτητι καρδιασ ");
INSERT INTO grcmt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","αινουντεσ τον θεον και εχοντεσ χαριν προσ ολον τον λαον ο δε κυριοσ προσετιθει τουσ σωζομενουσ καθ ημεραν τη εκκλησια ");
INSERT INTO grcmt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","επι το αυτο δε πετροσ και ιωαννησ ανεβαινον εισ το ιερον επι την ωραν τησ προσευχησ την ενατην ");
INSERT INTO grcmt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","και τισ ανηρ χωλοσ εκ κοιλιασ μητροσ αυτου υπαρχων εβασταζετο ον ετιθουν καθ ημεραν προσ την θυραν του ιερου την λεγομενην ωραιαν του αιτειν ελεημοσυνην παρα των εισπορευομενων εισ το ιερον ");
INSERT INTO grcmt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","οσ ιδων πετρον και ιωαννην μελλοντασ εισιεναι εισ το ιερον ηρωτα ελεημοσυνην ");
INSERT INTO grcmt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ατενισασ δε πετροσ εισ αυτον συν τω ιωαννη ειπεν βλεψον εισ ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ο δε επειχεν αυτοισ προσδοκων τι παρ αυτων λαβειν ");
INSERT INTO grcmt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ειπεν δε πετροσ αργυριον και χρυσιον ουχ υπαρχει μοι ο δε εχω τουτο σοι διδωμι εν τω ονοματι ιησου χριστου του ναζωραιου εγειραι και περιπατει ");
INSERT INTO grcmt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","και πιασασ αυτον τησ δεξιασ χειροσ ηγειρεν παραχρημα δε εστερεωθησαν αυτου αι βασεισ και τα σφυρα ");
INSERT INTO grcmt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","και εξαλλομενοσ εστη και περιεπατει και εισηλθεν συν αυτοισ εισ το ιερον περιπατων και αλλομενοσ και αινων τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","και ειδεν αυτον πασ ο λαοσ περιπατουντα και αινουντα τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","επεγινωσκον τε αυτον οτι ουτοσ ην ο προσ την ελεημοσυνην καθημενοσ επι τη ωραια πυλη του ιερου και επλησθησαν θαμβουσ και εκστασεωσ επι τω συμβεβηκοτι αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","κρατουντοσ δε του ιαθεντοσ χωλου τον πετρον και ιωαννην συνεδραμεν προσ αυτουσ πασ ο λαοσ επι τη στοα τη καλουμενη σολομωντοσ εκθαμβοι ");
INSERT INTO grcmt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ιδων δε πετροσ απεκρινατο προσ τον λαον ανδρεσ ισραηλιται τι θαυμαζετε επι τουτω η ημιν τι ατενιζετε ωσ ιδια δυναμει η ευσεβεια πεποιηκοσιν του περιπατειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ο θεοσ αβρααμ και ισαακ και ιακωβ ο θεοσ των πατερων ημων εδοξασεν τον παιδα αυτου ιησουν ον υμεισ μεν παρεδωκατε και ηρνησασθε αυτον κατα προσωπον πιλατου κριναντοσ εκεινου απολυειν ");
INSERT INTO grcmt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","υμεισ δε τον αγιον και δικαιον ηρνησασθε και ητησασθε ανδρα φονεα χαρισθηναι υμιν ");
INSERT INTO grcmt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","τον δε αρχηγον τησ ζωησ απεκτεινατε ον ο θεοσ ηγειρεν εκ νεκρων ου ημεισ μαρτυρεσ εσμεν ");
INSERT INTO grcmt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","και επι τη πιστει του ονοματοσ αυτου τουτον ον θεωρειτε και οιδατε εστερεωσεν το ονομα αυτου και η πιστισ η δι αυτου εδωκεν αυτω την ολοκληριαν ταυτην απεναντι παντων υμων ");
INSERT INTO grcmt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","και νυν αδελφοι οιδα οτι κατα αγνοιαν επραξατε ωσπερ και οι αρχοντεσ υμων ");
INSERT INTO grcmt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ο δε θεοσ α προκατηγγειλεν δια στοματοσ παντων των προφητων αυτου παθειν τον χριστον επληρωσεν ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","μετανοησατε ουν και επιστρεψατε εισ το εξαλειφθηναι υμων τασ αμαρτιασ οπωσ αν ελθωσιν καιροι αναψυξεωσ απο προσωπου του κυριου ");
INSERT INTO grcmt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","και αποστειλη τον προκεχειρισμενον υμιν χριστον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ον δει ουρανον μεν δεξασθαι αχρι χρονων αποκαταστασεωσ παντων ων ελαλησεν ο θεοσ δια στοματοσ παντων των αγιων αυτου προφητων απ αιωνοσ ");
INSERT INTO grcmt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","μωσησ μεν γαρ προσ τουσ πατερασ ειπεν οτι προφητην υμιν αναστησει κυριοσ ο θεοσ ημων εκ των αδελφων υμων ωσ εμε αυτου ακουσεσθε κατα παντα οσα αν λαληση προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","εσται δε πασα ψυχη ητισ εαν μη ακουση του προφητου εκεινου εξολοθρευθησεται εκ του λαου ");
INSERT INTO grcmt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","και παντεσ δε οι προφηται απο σαμουηλ και των καθεξησ οσοι ελαλησαν και κατηγγειλαν τασ ημερασ ταυτασ ");
INSERT INTO grcmt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","υμεισ εστε υιοι των προφητων και τησ διαθηκησ ησ διεθετο ο θεοσ προσ τουσ πατερασ ημων λεγων προσ αβρααμ και εν τω σπερματι σου ενευλογηθησονται πασαι αι πατριαι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","υμιν πρωτον ο θεοσ αναστησασ τον παιδα αυτου ιησουν απεστειλεν αυτον ευλογουντα υμασ εν τω αποστρεφειν εκαστον απο των πονηριων υμων ");
INSERT INTO grcmt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","λαλουντων δε αυτων προσ τον λαον επεστησαν αυτοισ οι ιερεισ και ο στρατηγοσ του ιερου και οι σαδδουκαιοι ");
INSERT INTO grcmt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","διαπονουμενοι δια το διδασκειν αυτουσ τον λαον και καταγγελλειν εν τω ιησου την αναστασιν των νεκρων ");
INSERT INTO grcmt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","και επεβαλον αυτοισ τασ χειρασ και εθεντο εισ τηρησιν εισ την αυριον ην γαρ εσπερα ηδη ");
INSERT INTO grcmt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","πολλοι δε των ακουσαντων τον λογον επιστευσαν και εγενηθη ο αριθμοσ των ανδρων ωσει χιλιαδεσ πεντε ");
INSERT INTO grcmt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","εγενετο δε επι την αυριον συναχθηναι αυτων τουσ αρχοντασ και πρεσβυτερουσ και γραμματεισ εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","και ανναν τον αρχιερεα και καιαφαν και ιωαννην και αλεξανδρον και οσοι ησαν εκ γενουσ αρχιερατικου ");
INSERT INTO grcmt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","και στησαντεσ αυτουσ εν μεσω επυνθανοντο εν ποια δυναμει η εν ποιω ονοματι εποιησατε τουτο υμεισ ");
INSERT INTO grcmt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","τοτε πετροσ πλησθεισ πνευματοσ αγιου ειπεν προσ αυτουσ αρχοντεσ του λαου και πρεσβυτεροι του ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ει ημεισ σημερον ανακρινομεθα επι ευεργεσια ανθρωπου ασθενουσ εν τινι 5101 I-DSN ουτοσ σεσωσται ");
INSERT INTO grcmt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","γνωστον εστω πασιν υμιν και παντι τω λαω ισραηλ οτι εν τω ονοματι ιησου χριστου του ναζωραιου ον υμεισ εσταυρωσατε ον ο θεοσ ηγειρεν εκ νεκρων εν τουτω ουτοσ παρεστηκεν ενωπιον υμων υγιησ ");
INSERT INTO grcmt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ουτοσ εστιν ο λιθοσ ο εξουθενηθεισ υφ υμων των οικοδομουντων ο γενομενοσ εισ κεφαλην γωνιασ ");
INSERT INTO grcmt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","και ουκ εστιν εν αλλω ουδενι η σωτηρια ουτε γαρ ονομα εστιν ετερον το δεδομενον εν ανθρωποισ εν ω δει σωθηναι ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","θεωρουντεσ δε την του πετρου παρρησιαν και ιωαννου και καταλαβομενοι οτι ανθρωποι αγραμματοι εισιν και ιδιωται εθαυμαζον επεγινωσκον τε αυτουσ οτι συν τω ιησου ησαν ");
INSERT INTO grcmt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","τον δε ανθρωπον βλεποντεσ συν αυτοισ εστωτα τον τεθεραπευμενον ουδεν ειχον αντειπειν ");
INSERT INTO grcmt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","κελευσαντεσ δε αυτουσ εξω του συνεδριου απελθειν συνεβαλλον προσ αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","λεγοντεσ τι ποιησομεν τοισ ανθρωποισ τουτοισ οτι μεν γαρ γνωστον σημειον γεγονεν δι αυτων πασιν τοισ κατοικουσιν ιερουσαλημ φανερον και ου δυναμεθα αρνησασθαι ");
INSERT INTO grcmt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","αλλ ινα μη επι πλειον διανεμηθη εισ τον λαον απειλη απειλησομεθα αυτοισ μηκετι λαλειν επι τω ονοματι τουτω μηδενι ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","και καλεσαντεσ αυτουσ παρηγγειλαν αυτοισ το καθολου μη φθεγγεσθαι μηδε διδασκειν επι τω ονοματι του ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ο δε πετροσ και ιωαννησ αποκριθεντεσ προσ αυτουσ ειπον ει δικαιον εστιν ενωπιον του θεου υμων ακουειν μαλλον η του θεου κρινατε ");
INSERT INTO grcmt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ου δυναμεθα γαρ ημεισ α ειδομεν και ηκουσαμεν μη λαλειν ");
INSERT INTO grcmt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","οι δε προσαπειλησαμενοι απελυσαν αυτουσ μηδεν ευρισκοντεσ το πωσ κολασονται αυτουσ δια τον λαον οτι παντεσ εδοξαζον τον θεον επι τω γεγονοτι ");
INSERT INTO grcmt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ετων γαρ ην πλειονων τεσσαρακοντα ο ανθρωποσ εφ ον εγεγονει το σημειον τουτο τησ ιασεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","απολυθεντεσ δε ηλθον προσ τουσ ιδιουσ και απηγγειλαν οσα προσ αυτουσ οι αρχιερεισ και οι πρεσβυτεροι ειπον ");
INSERT INTO grcmt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","οι δε ακουσαντεσ ομοθυμαδον ηραν φωνην προσ τον θεον και ειπον δεσποτα συ ο θεοσ ο ποιησασ τον ουρανον και την γην και την θαλασσαν και παντα τα εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ο δια στοματοσ δαυιδ παιδοσ σου ειπων ινα τι εφρυαξαν εθνη και λαοι εμελετησαν κενα ");
INSERT INTO grcmt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","παρεστησαν οι βασιλεισ τησ γησ και οι αρχοντεσ συνηχθησαν επι το αυτο κατα του κυριου και κατα του χριστου αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","συνηχθησαν γαρ επ αληθειασ επι τον αγιον παιδα σου ιησουν ον εχρισασ ηρωδησ τε και ποντιοσ πιλατοσ συν εθνεσιν και λαοισ ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ποιησαι οσα η χειρ σου και η βουλη σου προωρισεν γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","και τα νυν κυριε επιδε επι τασ απειλασ αυτων και δοσ τοισ δουλοισ σου μετα παρρησιασ πασησ λαλειν τον λογον σου ");
INSERT INTO grcmt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","εν τω την χειρα σου εκτεινειν σε εισ ιασιν και σημεια και τερατα γινεσθαι δια του ονοματοσ του αγιου παιδοσ σου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","και δεηθεντων αυτων εσαλευθη ο τοποσ εν ω ησαν συνηγμενοι και επλησθησαν απαντεσ πνευματοσ αγιου και ελαλουν τον λογον του θεου μετα παρρησιασ ");
INSERT INTO grcmt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","του δε πληθουσ των πιστευσαντων ην η καρδια και η ψυχη μια και ουδε εισ τι των υπαρχοντων αυτων ελεγεν ιδιον ειναι αλλ ην αυτοισ απαντα κοινα ");
INSERT INTO grcmt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","και μεγαλη δυναμει απεδιδουν το μαρτυριον οι αποστολοι τησ αναστασεωσ του κυριου ιησου χαρισ τε μεγαλη ην επι παντασ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ουδε γαρ ενδεησ τισ υπηρχεν εν αυτοισ οσοι γαρ κτητορεσ χωριων η οικιων υπηρχον πωλουντεσ εφερον τασ τιμασ των πιπρασκομενων ");
INSERT INTO grcmt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","και ετιθουν παρα τουσ ποδασ των αποστολων διεδιδοτο δε εκαστω καθοτι αν τισ χρειαν ειχεν ");
INSERT INTO grcmt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ιωσησ δε ο επικληθεισ βαρναβασ απο των αποστολων ο εστιν μεθερμηνευομενον υιοσ παρακλησεωσ λευιτησ κυπριοσ τω γενει ");
INSERT INTO grcmt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","υπαρχοντοσ αυτω αγρου πωλησασ ηνεγκεν το χρημα και εθηκεν παρα τουσ ποδασ των αποστολων ");
INSERT INTO grcmt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ανηρ δε τισ ανανιασ ονοματι συν σαπφειρη τη γυναικι αυτου επωλησεν κτημα ");
INSERT INTO grcmt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","και ενοσφισατο απο τησ τιμησ συνειδυιασ και τησ γυναικοσ αυτου και ενεγκασ μεροσ τι παρα τουσ ποδασ των αποστολων εθηκεν ");
INSERT INTO grcmt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ειπεν δε πετροσ ανανια δια τι επληρωσεν ο σατανασ την καρδιαν σου ψευσασθαι σε το πνευμα το αγιον και νοσφισασθαι σε απο τησ τιμησ του χωριου ");
INSERT INTO grcmt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ουχι μενον σοι εμενεν και πραθεν εν τη ση εξουσια υπηρχεν τι οτι εθου εν τη καρδια σου το πραγμα τουτο ουκ εψευσω ανθρωποισ αλλα τω θεω ");
INSERT INTO grcmt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ακουων δε ο ανανιασ τουσ λογουσ τουτουσ πεσων εξεψυξεν και εγενετο φοβοσ μεγασ επι παντασ τουσ ακουοντασ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ανασταντεσ δε οι νεωτεροι συνεστειλαν αυτον και εξενεγκαντεσ εθαψαν ");
INSERT INTO grcmt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","εγενετο δε ωσ ωρων τριων διαστημα και η γυνη αυτου μη ειδυια το γεγονοσ εισηλθεν ");
INSERT INTO grcmt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","απεκριθη δε αυτη ο πετροσ ειπε μοι ει τοσουτου το χωριον απεδοσθε η δε ειπεν ναι τοσουτου ");
INSERT INTO grcmt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ο δε πετροσ ειπεν προσ αυτην τι οτι συνεφωνηθη υμιν πειρασαι το πνευμα κυριου ιδου οι ποδεσ των θαψαντων τον ανδρα σου επι τη θυρα και εξοισουσιν σε ");
INSERT INTO grcmt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","επεσεν δε παραχρημα παρα τουσ ποδασ αυτου και εξεψυξεν εισελθοντεσ δε οι νεανισκοι ευρον αυτην νεκραν και εξενεγκαντεσ εθαψαν προσ τον ανδρα αυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","και εγενετο φοβοσ μεγασ εφ ολην την εκκλησιαν και επι παντασ τουσ ακουοντασ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","δια δε των χειρων των αποστολων εγινετο σημεια και τερατα εν τω λαω πολλα και ησαν ομοθυμαδον απαντεσ εν τη στοα σολομωντοσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","των δε λοιπων ουδεισ ετολμα κολλασθαι αυτοισ αλλ εμεγαλυνεν αυτουσ ο λαοσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","μαλλον δε προσετιθεντο πιστευοντεσ τω κυριω πληθη ανδρων τε και γυναικων ");
INSERT INTO grcmt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ωστε κατα τασ πλατειασ εκφερειν τουσ ασθενεισ και τιθεναι επι κλινων και κραββατων ινα ερχομενου πετρου καν η σκια επισκιαση τινι αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","συνηρχετο δε και το πληθοσ των περιξ πολεων εισ ιερουσαλημ φεροντεσ ασθενεισ και οχλουμενουσ υπο πνευματων ακαθαρτων οιτινεσ εθεραπευοντο απαντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","αναστασ δε ο αρχιερευσ και παντεσ οι συν αυτω η ουσα αιρεσισ των σαδδουκαιων επλησθησαν ζηλου ");
INSERT INTO grcmt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","και επεβαλον τασ χειρασ αυτων επι τουσ αποστολουσ και εθεντο αυτουσ εν τηρησει δημοσια ");
INSERT INTO grcmt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","αγγελοσ δε κυριου δια τησ νυκτοσ ηνοιξεν τασ θυρασ τησ φυλακησ εξαγαγων τε αυτουσ ειπεν ");
INSERT INTO grcmt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","πορευεσθε και σταθεντεσ λαλειτε εν τω ιερω τω λαω παντα τα ρηματα τησ ζωησ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ακουσαντεσ δε εισηλθον υπο τον ορθρον εισ το ιερον και εδιδασκον παραγενομενοσ δε ο αρχιερευσ και οι συν αυτω συνεκαλεσαν το συνεδριον και πασαν την γερουσιαν των υιων ισραηλ και απεστειλαν εισ το δεσμωτηριον αχθηναι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","οι δε υπηρεται παραγενομενοι ουχ ευρον αυτουσ εν τη φυλακη αναστρεψαντεσ δε απηγγειλαν ");
INSERT INTO grcmt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","λεγοντεσ οτι το μεν δεσμωτηριον ευρομεν κεκλεισμενον εν παση ασφαλεια και τουσ φυλακασ εστωτασ προ των θυρων ανοιξαντεσ δε εσω ουδενα ευρομεν ");
INSERT INTO grcmt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ωσ δε ηκουσαν τουσ λογουσ τουτουσ ο τε ιερευσ και ο στρατηγοσ του ιερου και οι αρχιερεισ διηπορουν περι αυτων τι αν γενοιτο τουτο ");
INSERT INTO grcmt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","παραγενομενοσ δε τισ απηγγειλεν αυτοισ οτι ιδου οι ανδρεσ ουσ εθεσθε εν τη φυλακη εισιν εν τω ιερω εστωτεσ και διδασκοντεσ τον λαον ");
INSERT INTO grcmt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","τοτε απελθων ο στρατηγοσ συν τοισ υπηρεταισ ηγαγεν αυτουσ ου μετα βιασ εφοβουντο γαρ τον λαον ινα μη λιθασθωσιν ");
INSERT INTO grcmt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","αγαγοντεσ δε αυτουσ εστησαν εν τω συνεδριω και επηρωτησεν αυτουσ ο αρχιερευσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","λεγων ου παραγγελια παρηγγειλαμεν υμιν μη διδασκειν επι τω ονοματι τουτω και ιδου πεπληρωκατε την ιερουσαλημ τησ διδαχησ υμων και βουλεσθε επαγαγειν εφ ημασ το αιμα του ανθρωπου τουτου ");
INSERT INTO grcmt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","αποκριθεισ δε πετροσ και οι αποστολοι ειπον πειθαρχειν δει θεω μαλλον η ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ο θεοσ των πατερων ημων ηγειρεν ιησουν ον υμεισ διεχειρισασθε κρεμασαντεσ επι ξυλου ");
INSERT INTO grcmt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","τουτον ο θεοσ αρχηγον και σωτηρα υψωσεν τη δεξια αυτου δουναι μετανοιαν τω ισραηλ και αφεσιν αμαρτιων ");
INSERT INTO grcmt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","και ημεισ εσμεν αυτου μαρτυρεσ των ρηματων τουτων και το πνευμα δε το αγιον ο εδωκεν ο θεοσ τοισ πειθαρχουσιν αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","οι δε ακουοντεσ διεπριοντο και εβουλευοντο ανελειν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","αναστασ δε τισ εν τω συνεδριω φαρισαιοσ ονοματι γαμαλιηλ νομοδιδασκαλοσ τιμιοσ παντι τω λαω εκελευσεν εξω βραχυ τι τουσ αποστολουσ ποιησαι ");
INSERT INTO grcmt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ειπεν τε προσ αυτουσ ανδρεσ ισραηλιται προσεχετε εαυτοισ επι τοισ ανθρωποισ τουτοισ τι μελλετε πρασσειν ");
INSERT INTO grcmt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","προ γαρ τουτων των ημερων ανεστη θευδασ λεγων ειναι τινα εαυτον ω προσεκληθη αριθμοσ ανδρων ωσει τετρακοσιων οσ ανηρεθη και παντεσ οσοι επειθοντο αυτω διελυθησαν και εγενοντο εισ ουδεν ");
INSERT INTO grcmt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","μετα τουτον ανεστη ιουδασ ο γαλιλαιοσ εν ταισ ημεραισ τησ απογραφησ και απεστησεν λαον ικανον οπισω αυτου κακεινοσ απωλετο και παντεσ οσοι επειθοντο αυτω διεσκορπισθησαν ");
INSERT INTO grcmt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","και τα νυν λεγω υμιν αποστητε απο των ανθρωπων τουτων και εασατε αυτουσ οτι εαν η εξ ανθρωπων η βουλη η το εργον τουτο καταλυθησεται ");
INSERT INTO grcmt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ει δε εκ θεου εστιν ου δυνασθε καταλυσαι αυτο μηποτε και θεομαχοι ευρεθητε ");
INSERT INTO grcmt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","επεισθησαν δε αυτω και προσκαλεσαμενοι τουσ αποστολουσ δειραντεσ παρηγγειλαν μη λαλειν επι τω ονοματι του ιησου και απελυσαν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","οι μεν ουν επορευοντο χαιροντεσ απο προσωπου του συνεδριου οτι υπερ του ονοματοσ του ιησου κατηξιωθησαν ατιμασθηναι ");
INSERT INTO grcmt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","πασαν τε ημεραν εν τω ιερω και κατ οικον ουκ επαυοντο διδασκοντεσ και ευαγγελιζομενοι ιησουν τον χριστον ");
INSERT INTO grcmt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","εν δε ταισ ημεραισ ταυταισ πληθυνοντων των μαθητων εγενετο γογγυσμοσ των ελληνιστων προσ τουσ εβραιουσ οτι παρεθεωρουντο εν τη διακονια τη καθημερινη αι χηραι αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","προσκαλεσαμενοι δε οι δωδεκα το πληθοσ των μαθητων ειπον ουκ αρεστον εστιν ημασ καταλειψαντασ τον λογον του θεου διακονειν τραπεζαισ ");
INSERT INTO grcmt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","επισκεψασθε ουν αδελφοι ανδρασ εξ υμων μαρτυρουμενουσ επτα πληρεισ πνευματοσ αγιου και σοφιασ ουσ καταστησωμεν επι τησ χρειασ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ημεισ δε τη προσευχη και τη διακονια του λογου προσκαρτερησομεν ");
INSERT INTO grcmt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","και ηρεσεν ο λογοσ ενωπιον παντοσ του πληθουσ και εξελεξαντο στεφανον ανδρα πληρησ πιστεωσ και πνευματοσ αγιου και φιλιππον και προχορον και νικανορα και τιμωνα και παρμεναν και νικολαον προσηλυτον αντιοχεα ");
INSERT INTO grcmt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ουσ εστησαν ενωπιον των αποστολων και προσευξαμενοι επεθηκαν αυτοισ τασ χειρασ ");
INSERT INTO grcmt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","και ο λογοσ του θεου ηυξανεν και επληθυνετο ο αριθμοσ των μαθητων εν ιερουσαλημ σφοδρα πολυσ τε οχλοσ των ιερεων υπηκουον τη πιστει ");
INSERT INTO grcmt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","στεφανοσ δε πληρησ πιστεωσ και δυναμεωσ εποιει τερατα και σημεια μεγαλα εν τω λαω ");
INSERT INTO grcmt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ανεστησαν δε τινεσ των εκ τησ συναγωγησ τησ λεγομενησ λιβερτινων και κυρηναιων και αλεξανδρεων και των απο κιλικιασ και ασιασ συζητουντεσ τω στεφανω ");
INSERT INTO grcmt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","και ουκ ισχυον αντιστηναι τη σοφια και τω πνευματι ω ελαλει ");
INSERT INTO grcmt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","τοτε υπεβαλον ανδρασ λεγοντασ οτι ακηκοαμεν αυτου λαλουντοσ ρηματα βλασφημα εισ μωσην και τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","συνεκινησαν τε τον λαον και τουσ πρεσβυτερουσ και τουσ γραμματεισ και επισταντεσ συνηρπασαν αυτον και ηγαγον εισ το συνεδριον ");
INSERT INTO grcmt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","εστησαν τε μαρτυρασ ψευδεισ λεγοντασ ο ανθρωποσ ουτοσ ου παυεται ρηματα βλασφημα λαλων κατα του τοπου του αγιου και του νομου ");
INSERT INTO grcmt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ακηκοαμεν γαρ αυτου λεγοντοσ οτι ιησουσ ο ναζωραιοσ ουτοσ καταλυσει τον τοπον τουτον και αλλαξει τα εθη α παρεδωκεν ημιν μωσησ ");
INSERT INTO grcmt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","και ατενισαντεσ εισ αυτον απαντεσ οι καθεζομενοι εν τω συνεδριω ειδον το προσωπον αυτου ωσει προσωπον αγγελου ");
INSERT INTO grcmt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ειπεν δε ο αρχιερευσ ει αρα ταυτα ουτωσ εχει ");
INSERT INTO grcmt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ο δε εφη ανδρεσ αδελφοι και πατερεσ ακουσατε ο θεοσ τησ δοξησ ωφθη τω πατρι ημων αβρααμ οντι εν τη μεσοποταμια πριν η κατοικησαι αυτον εν χαρραν ");
INSERT INTO grcmt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","και ειπεν προσ αυτον εξελθε εκ τησ γησ σου και εκ τησ συγγενειασ σου και δευρο εισ γην ην αν σοι δειξω ");
INSERT INTO grcmt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","τοτε εξελθων εκ γησ χαλδαιων κατωκησεν εν χαρραν κακειθεν μετα το αποθανειν τον πατερα αυτου μετωκισεν αυτον εισ την γην ταυτην εισ ην υμεισ νυν κατοικειτε ");
INSERT INTO grcmt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","και ουκ εδωκεν αυτω κληρονομιαν εν αυτη ουδε βημα ποδοσ και επηγγειλατο δουναι αυτω εισ κατασχεσιν αυτην και τω σπερματι αυτου μετ αυτον ουκ οντοσ αυτω τεκνου ");
INSERT INTO grcmt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ελαλησεν δε ουτωσ ο θεοσ οτι εσται το σπερμα αυτου παροικον εν γη αλλοτρια και δουλωσουσιν αυτο και κακωσουσιν ετη τετρακοσια ");
INSERT INTO grcmt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","και το εθνοσ ω εαν δουλευσωσιν κρινω εγω ειπεν ο θεοσ και μετα ταυτα εξελευσονται και λατρευσουσιν μοι εν τω τοπω τουτω ");
INSERT INTO grcmt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","και εδωκεν αυτω διαθηκην περιτομησ και ουτωσ εγεννησεν τον ισαακ και περιετεμεν αυτον τη ημερα τη ογδοη και ο ισαακ τον ιακωβ και ο ιακωβ τουσ δωδεκα πατριαρχασ ");
INSERT INTO grcmt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","και οι πατριαρχαι ζηλωσαντεσ τον ιωσηφ απεδοντο εισ αιγυπτον και ην ο θεοσ μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","και εξειλετο αυτον εκ πασων των θλιψεων αυτου και εδωκεν αυτω χαριν και σοφιαν εναντιον φαραω βασιλεωσ αιγυπτου και κατεστησεν αυτον ηγουμενον επ αιγυπτον και ολον τον οικον αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ηλθεν δε λιμοσ εφ ολην την γην αιγυπτου και χανααν και θλιψισ μεγαλη και ουχ ευρισκον χορτασματα οι πατερεσ ημων ");
INSERT INTO grcmt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ακουσασ δε ιακωβ οντα σιτα εν αιγυπτω εξαπεστειλεν τουσ πατερασ ημων πρωτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","και εν τω δευτερω ανεγνωρισθη ιωσηφ τοισ αδελφοισ αυτου και φανερον εγενετο τω φαραω το γενοσ του ιωσηφ ");
INSERT INTO grcmt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","αποστειλασ δε ιωσηφ μετεκαλεσατο τον πατερα αυτου ιακωβ και πασαν την συγγενειαν εν ψυχαισ εβδομηκοντα πεντε ");
INSERT INTO grcmt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","κατεβη δε ιακωβ εισ αιγυπτον και ετελευτησεν αυτοσ και οι πατερεσ ημων ");
INSERT INTO grcmt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","και μετετεθησαν εισ συχεμ και ετεθησαν εν τω μνηματι ο ωνησατο αβρααμ τιμησ αργυριου παρα των υιων εμμορ του συχεμ ");
INSERT INTO grcmt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","καθωσ δε ηγγιζεν ο χρονοσ τησ επαγγελιασ ησ ωμοσεν ο θεοσ τω αβρααμ ηυξησεν ο λαοσ και επληθυνθη εν αιγυπτω ");
INSERT INTO grcmt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","αχρι ου ανεστη βασιλευσ ετεροσ οσ ουκ ηδει τον ιωσηφ ");
INSERT INTO grcmt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ουτοσ κατασοφισαμενοσ το γενοσ ημων εκακωσεν τουσ πατερασ ημων του ποιειν εκθετα τα βρεφη αυτων εισ το μη ζωογονεισθαι ");
INSERT INTO grcmt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","εν ω καιρω εγεννηθη μωσησ και ην αστειοσ τω θεω οσ ανετραφη μηνασ τρεισ εν τω οικω του πατροσ ");
INSERT INTO grcmt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","εκτεθεντα δε αυτον ανειλετο η θυγατηρ φαραω και ανεθρεψατο αυτον εαυτη εισ υιον ");
INSERT INTO grcmt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","και επαιδευθη μωσησ παση σοφια αιγυπτιων ην δε δυνατοσ εν λογοισ και εργοισ ");
INSERT INTO grcmt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ωσ δε επληρουτο αυτω τεσσαρακονταετησ χρονοσ ανεβη επι την καρδιαν αυτου επισκεψασθαι τουσ αδελφουσ αυτου τουσ υιουσ ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","και ιδων τινα αδικουμενον ημυνατο και εποιησεν εκδικησιν τω καταπονουμενω παταξασ τον αιγυπτιον ");
INSERT INTO grcmt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ενομιζεν δε συνιεναι τουσ αδελφουσ αυτου οτι ο θεοσ δια χειροσ αυτου διδωσιν αυτοισ σωτηριαν οι δε ου συνηκαν ");
INSERT INTO grcmt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","τη τε επιουση ημερα ωφθη αυτοισ μαχομενοισ και συνηλασεν αυτουσ εισ ειρηνην ειπων ανδρεσ αδελφοι εστε υμεισ ινα τι αδικειτε αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ο δε αδικων τον πλησιον απωσατο αυτον ειπων τισ σε κατεστησεν αρχοντα και δικαστην εφ ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","μη ανελειν με συ θελεισ ον τροπον ανειλεσ χθεσ τον αιγυπτιον ");
INSERT INTO grcmt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","εφυγεν δε μωσησ εν τω λογω τουτω και εγενετο παροικοσ εν γη μαδιαμ ου εγεννησεν υιουσ δυο ");
INSERT INTO grcmt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","και πληρωθεντων ετων τεσσαρακοντα ωφθη αυτω εν τη ερημω του ορουσ σινα αγγελοσ κυριου εν φλογι πυροσ βατου ");
INSERT INTO grcmt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ο δε μωσησ ιδων εθαυμαζεν το οραμα προσερχομενου δε αυτου κατανοησαι εγενετο φωνη κυριου προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","εγω ο θεοσ των πατερων σου ο θεοσ αβρααμ και ο θεοσ ισαακ και ο θεοσ ιακωβ εντρομοσ δε γενομενοσ μωσησ ουκ ετολμα κατανοησαι ");
INSERT INTO grcmt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ειπεν δε αυτω ο κυριοσ λυσον το υποδημα των ποδων σου ο γαρ τοποσ εν ω εστηκασ γη αγια εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ιδων ειδον την κακωσιν του λαου μου του εν αιγυπτω και του στεναγμου αυτων ηκουσα και κατεβην εξελεσθαι αυτουσ και νυν δευρο αποστελω σε εισ αιγυπτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","τουτον τον μωσην ον ηρνησαντο ειποντεσ τισ σε κατεστησεν αρχοντα και δικαστην τουτον ο θεοσ αρχοντα και λυτρωτην απεστειλεν εν χειρι αγγελου του οφθεντοσ αυτω εν τη βατω ");
INSERT INTO grcmt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ουτοσ εξηγαγεν αυτουσ ποιησασ τερατα και σημεια εν γη αιγυπτω και εν ερυθρα θαλασση και εν τη ερημω ετη τεσσαρακοντα ");
INSERT INTO grcmt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ουτοσ εστιν ο μωσησ ο ειπων τοισ υιοισ ισραηλ προφητην υμιν αναστησει κυριοσ ο θεοσ ημων εκ των αδελφων υμων ωσ εμε ");
INSERT INTO grcmt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ουτοσ εστιν ο γενομενοσ εν τη εκκλησια εν τη ερημω μετα του αγγελου του λαλουντοσ αυτω εν τω ορει σινα και των πατερων ημων οσ εδεξατο λογον ζωντα δουναι ημιν ");
INSERT INTO grcmt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ω ουκ ηθελησαν υπηκοοι γενεσθαι οι πατερεσ ημων αλλ απωσαντο και εστραφησαν τη καρδια αυτων εισ αιγυπτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ειποντεσ τω ααρων ποιησον ημιν θεουσ οι προπορευσονται ημων ο γαρ μωσησ ουτοσ οσ εξηγαγεν ημασ εκ γησ αιγυπτου ουκ οιδαμεν τι γεγονεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","και εμοσχοποιησαν εν ταισ ημεραισ εκειναισ και ανηγαγον θυσιαν τω ειδωλω και ευφραινοντο εν τοισ εργοισ των χειρων αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","εστρεψεν δε ο θεοσ και παρεδωκεν αυτουσ λατρευειν τη στρατια του ουρανου καθωσ γεγραπται εν βιβλω των προφητων μη σφαγια και θυσιασ προσηνεγκατε μοι ετη τεσσαρακοντα εν τη ερημω οικοσ ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","και ανελαβετε την σκηνην του μολοχ και το αστρον του θεου υμων ρεμφαν τουσ τυπουσ ουσ εποιησατε προσκυνειν αυτοισ και μετοικιω υμασ επεκεινα βαβυλωνοσ ");
INSERT INTO grcmt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","η σκηνη του μαρτυριου ην τοισ πατρασιν ημων εν τη ερημω καθωσ διεταξατο ο λαλων τω μωση ποιησαι αυτην κατα τον τυπον ον εωρακει ");
INSERT INTO grcmt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ην και εισηγαγον διαδεξαμενοι οι πατερεσ ημων μετα ιησου εν τη κατασχεσει των εθνων ων εξωσεν ο θεοσ απο προσωπου των πατερων ημων εωσ των ημερων δαυιδ ");
INSERT INTO grcmt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","οσ ευρεν χαριν ενωπιον του θεου και ητησατο ευρειν σκηνωμα τω θεω ιακωβ ");
INSERT INTO grcmt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","σολομων δε ωκοδομησεν αυτω οικον ");
INSERT INTO grcmt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","αλλ ουχ ο υψιστοσ εν χειροποιητοισ ναοισ κατοικει καθωσ ο προφητησ λεγει ");
INSERT INTO grcmt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ο ουρανοσ μοι θρονοσ η δε γη υποποδιον των ποδων μου ποιον οικον οικοδομησετε μοι λεγει κυριοσ η τισ τοποσ τησ καταπαυσεωσ μου ");
INSERT INTO grcmt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ουχι η χειρ μου εποιησεν ταυτα παντα ");
INSERT INTO grcmt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","σκληροτραχηλοι και απεριτμητοι τη καρδια και τοισ ωσιν υμεισ αει τω πνευματι τω αγιω αντιπιπτετε ωσ οι πατερεσ υμων και υμεισ ");
INSERT INTO grcmt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","τινα των προφητων ουκ εδιωξαν οι πατερεσ υμων και απεκτειναν τουσ προκαταγγειλαντασ περι τησ ελευσεωσ του δικαιου ου νυν υμεισ προδοται και φονεισ γεγενησθε ");
INSERT INTO grcmt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","οιτινεσ ελαβετε τον νομον εισ διαταγασ αγγελων και ουκ εφυλαξατε ");
INSERT INTO grcmt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ακουοντεσ δε ταυτα διεπριοντο ταισ καρδιαισ αυτων και εβρυχον τουσ οδοντασ επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","υπαρχων δε πληρησ πνευματοσ αγιου ατενισασ εισ τον ουρανον ειδεν δοξαν θεου και ιησουν εστωτα εκ δεξιων του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","και ειπεν ιδου θεωρω τουσ ουρανουσ ανεωγμενουσ και τον υιον του ανθρωπου εκ δεξιων εστωτα του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","κραξαντεσ δε φωνη μεγαλη συνεσχον τα ωτα αυτων και ωρμησαν ομοθυμαδον επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","και εκβαλοντεσ εξω τησ πολεωσ ελιθοβολουν και οι μαρτυρεσ απεθεντο τα ιματια παρα τουσ ποδασ νεανιου καλουμενου σαυλου ");
INSERT INTO grcmt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","και ελιθοβολουν τον στεφανον επικαλουμενον και λεγοντα κυριε ιησου δεξαι το πνευμα μου ");
INSERT INTO grcmt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","θεισ δε τα γονατα εκραξεν φωνη μεγαλη κυριε μη στησησ αυτοισ την αμαρτιαν ταυτην και τουτο ειπων εκοιμηθη ");
INSERT INTO grcmt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","σαυλοσ δε ην συνευδοκων τη αναιρεσει αυτου εγενετο δε εν εκεινη τη ημερα διωγμοσ μεγασ επι την εκκλησιαν την εν ιεροσολυμοισ παντεσ δε διεσπαρησαν κατα τασ χωρασ τησ ιουδαιασ και σαμαρειασ πλην των αποστολων ");
INSERT INTO grcmt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","συνεκομισαν δε τον στεφανον ανδρεσ ευλαβεισ και εποιησαντο κοπετον μεγαν επ αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","σαυλοσ δε ελυμαινετο την εκκλησιαν κατα τουσ οικουσ εισπορευομενοσ συρων τε ανδρασ και γυναικασ παρεδιδου εισ φυλακην ");
INSERT INTO grcmt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","οι μεν ουν διασπαρεντεσ διηλθον ευαγγελιζομενοι τον λογον ");
INSERT INTO grcmt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","φιλιπποσ δε κατελθων εισ πολιν τησ σαμαρειασ εκηρυσσεν αυτοισ τον χριστον ");
INSERT INTO grcmt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","προσειχον τε οι οχλοι τοισ λεγομενοισ υπο του φιλιππου ομοθυμαδον εν τω ακουειν αυτουσ και βλεπειν τα σημεια α εποιει ");
INSERT INTO grcmt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","πολλων γαρ των εχοντων πνευματα ακαθαρτα βοωντα φωνη μεγαλη εξηρχετο πολλοι δε παραλελυμενοι και χωλοι εθεραπευθησαν ");
INSERT INTO grcmt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","και εγενετο χαρα μεγαλη εν τη πολει εκεινη ");
INSERT INTO grcmt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ανηρ δε τισ ονοματι σιμων προυπηρχεν εν τη πολει μαγευων και εξιστων το εθνοσ τησ σαμαρειασ λεγων ειναι τινα εαυτον μεγαν ");
INSERT INTO grcmt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ω προσειχον απο μικρου εωσ μεγαλου λεγοντεσ ουτοσ εστιν η δυναμισ του θεου η μεγαλη ");
INSERT INTO grcmt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","προσειχον δε αυτω δια το ικανω χρονω ταισ μαγειαισ εξεστακεναι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","οτε δε επιστευσαν τω φιλιππω ευαγγελιζομενω τα περι τησ βασιλειασ του θεου και του ονοματοσ ιησου χριστου εβαπτιζοντο ανδρεσ τε και γυναικεσ ");
INSERT INTO grcmt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ο δε σιμων και αυτοσ επιστευσεν και βαπτισθεισ ην προσκαρτερων τω φιλιππω θεωρων τε δυναμεισ και σημεια γινομενα εξιστατο ");
INSERT INTO grcmt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ακουσαντεσ δε οι εν ιεροσολυμοισ αποστολοι οτι δεδεκται η σαμαρεια τον λογον του θεου απεστειλαν προσ αυτουσ τον πετρον και ιωαννην ");
INSERT INTO grcmt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","οιτινεσ καταβαντεσ προσηυξαντο περι αυτων οπωσ λαβωσιν πνευμα αγιον ");
INSERT INTO grcmt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ουπω γαρ ην επ ουδενι αυτων επιπεπτωκοσ μονον δε βεβαπτισμενοι υπηρχον εισ το ονομα του χριστου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","τοτε επετιθουν τασ χειρασ επ αυτουσ και ελαμβανον πνευμα αγιον ");
INSERT INTO grcmt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","θεασαμενοσ δε ο σιμων οτι δια τησ επιθεσεωσ των χειρων των αποστολων διδοται το πνευμα το αγιον προσηνεγκεν αυτοισ χρηματα ");
INSERT INTO grcmt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","λεγων δοτε καμοι την εξουσιαν ταυτην ινα ω εαν επιθω τασ χειρασ λαμβανη πνευμα αγιον ");
INSERT INTO grcmt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","πετροσ δε ειπεν προσ αυτον το αργυριον σου συν σοι ειη εισ απωλειαν οτι την δωρεαν του θεου ενομισασ δια χρηματων κτασθαι ");
INSERT INTO grcmt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ουκ εστιν σοι μερισ ουδε κληροσ εν τω λογω τουτω η γαρ καρδια σου ουκ εστιν ευθεια ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","μετανοησον ουν απο τησ κακιασ σου ταυτησ και δεηθητι του θεου ει αρα αφεθησεται σοι η επινοια τησ καρδιασ σου ");
INSERT INTO grcmt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","εισ γαρ χολην πικριασ και συνδεσμον αδικιασ ορω σε οντα ");
INSERT INTO grcmt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","αποκριθεισ δε ο σιμων ειπεν δεηθητε υμεισ υπερ εμου προσ τον κυριον οπωσ μηδεν επελθη επ εμε ων ειρηκατε ");
INSERT INTO grcmt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","οι μεν ουν διαμαρτυραμενοι και λαλησαντεσ τον λογον του κυριου υπεστρεψαν εισ ιερουσαλημ πολλασ τε κωμασ των σαμαρειτων ευηγγελισαντο ");
INSERT INTO grcmt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","αγγελοσ δε κυριου ελαλησεν προσ φιλιππον λεγων αναστηθι και πορευου κατα μεσημβριαν επι την οδον την καταβαινουσαν απο ιερουσαλημ εισ γαζαν αυτη εστιν ερημοσ ");
INSERT INTO grcmt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","και αναστασ επορευθη και ιδου ανηρ αιθιοψ ευνουχοσ δυναστησ κανδακησ τησ βασιλισσησ αιθιοπων οσ ην επι πασησ τησ γαζησ αυτησ οσ εληλυθει προσκυνησων εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ην τε υποστρεφων και καθημενοσ επι του αρματοσ αυτου και ανεγινωσκεν τον προφητην ησαιαν ");
INSERT INTO grcmt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ειπεν δε το πνευμα τω φιλιππω προσελθε και κολληθητι τω αρματι τουτω ");
INSERT INTO grcmt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","προσδραμων δε ο φιλιπποσ ηκουσεν αυτου αναγινωσκοντοσ τον προφητην ησαιαν και ειπεν αρα γε γινωσκεισ α αναγινωσκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ο δε ειπεν πωσ γαρ αν δυναιμην εαν μη τισ οδηγηση με παρεκαλεσεν τε τον φιλιππον αναβαντα καθισαι συν αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","η δε περιοχη τησ γραφησ ην ανεγινωσκεν ην αυτη ωσ προβατον επι σφαγην ηχθη και ωσ αμνοσ εναντιον του κειροντοσ αυτον αφωνοσ ουτωσ ουκ ανοιγει το στομα αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","εν τη ταπεινωσει αυτου η κρισισ αυτου ηρθη την δε γενεαν αυτου τισ διηγησεται οτι αιρεται απο τησ γησ η ζωη αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","αποκριθεισ δε ο ευνουχοσ τω φιλιππω ειπεν δεομαι σου περι τινοσ ο προφητησ λεγει τουτο περι εαυτου η περι ετερου τινοσ ");
INSERT INTO grcmt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ανοιξασ δε ο φιλιπποσ το στομα αυτου και αρξαμενοσ απο τησ γραφησ ταυτησ ευηγγελισατο αυτω τον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ωσ δε επορευοντο κατα την οδον ηλθον επι τι υδωρ και φησιν ο ευνουχοσ ιδου υδωρ τι κωλυει με βαπτισθηναι ");
INSERT INTO grcmt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38"," και εκελευσεν στηναι το αρμα και κατεβησαν αμφοτεροι εισ το υδωρ ο τε φιλιπποσ και ο ευνουχοσ και εβαπτισεν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","οτε δε ανεβησαν εκ του υδατοσ πνευμα κυριου ηρπασεν τον φιλιππον και ουκ ειδεν αυτον ουκετι ο ευνουχοσ επορευετο γαρ την οδον αυτου χαιρων ");
INSERT INTO grcmt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","φιλιπποσ δε ευρεθη εισ αζωτον και διερχομενοσ ευηγγελιζετο τασ πολεισ πασασ εωσ του ελθειν αυτον εισ καισαρειαν ");
INSERT INTO grcmt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ο δε σαυλοσ ετι εμπνεων απειλησ και φονου εισ τουσ μαθητασ του κυριου προσελθων τω αρχιερει ");
INSERT INTO grcmt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ητησατο παρ αυτου επιστολασ εισ δαμασκον προσ τασ συναγωγασ οπωσ εαν τινασ ευρη τησ οδου οντασ ανδρασ τε και γυναικασ δεδεμενουσ αγαγη εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","εν δε τω πορευεσθαι εγενετο αυτον εγγιζειν τη δαμασκω και εξαιφνησ περιηστραψεν αυτον φωσ απο του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","και πεσων επι την γην ηκουσεν φωνην λεγουσαν αυτω σαουλ σαουλ τι με διωκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ειπεν δε τισ ει κυριε ο δε κυριοσ ειπεν εγω ειμι ιησουσ ον συ διωκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","αλλα αναστηθι και εισελθε εισ την πολιν και λαληθησεται σοι τι σε δει ποιειν ");
INSERT INTO grcmt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","οι δε ανδρεσ οι συνοδευοντεσ αυτω ειστηκεισαν ενεοι ακουοντεσ μεν τησ φωνησ μηδενα δε θεωρουντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ηγερθη δε ο σαυλοσ απο τησ γησ ανεωγμενων τε των οφθαλμων αυτου ουδενα εβλεπεν χειραγωγουντεσ δε αυτον εισηγαγον εισ δαμασκον ");
INSERT INTO grcmt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","και ην ημερασ τρεισ μη βλεπων και ουκ εφαγεν ουδε επιεν ");
INSERT INTO grcmt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ην δε τισ μαθητησ εν δαμασκω ονοματι ανανιασ και ειπεν προσ αυτον ο κυριοσ εν οραματι ανανια ο δε ειπεν ιδου εγω κυριε ");
INSERT INTO grcmt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ο δε κυριοσ προσ αυτον αναστασ πορευθητι επι την ρυμην την καλουμενην ευθειαν και ζητησον εν οικια ιουδα σαυλον ονοματι ταρσεα ιδου γαρ προσευχεται ");
INSERT INTO grcmt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","και ειδεν εν οραματι ανδρα ονοματι ανανιαν εισελθοντα και επιθεντα αυτω χειρα οπωσ αναβλεψη ");
INSERT INTO grcmt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","απεκριθη δε ανανιασ κυριε ακηκοα απο πολλων περι του ανδροσ τουτου οσα κακα εποιησεν τοισ αγιοισ σου εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","και ωδε εχει εξουσιαν παρα των αρχιερεων δησαι παντασ τουσ επικαλουμενουσ το ονομα σου ");
INSERT INTO grcmt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ειπεν δε προσ αυτον ο κυριοσ πορευου οτι σκευοσ εκλογησ μοι εστιν ουτοσ του βαστασαι το ονομα μου ενωπιον εθνων και βασιλεων υιων τε ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","εγω γαρ υποδειξω αυτω οσα δει αυτον υπερ του ονοματοσ μου παθειν ");
INSERT INTO grcmt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","απηλθεν δε ανανιασ και εισηλθεν εισ την οικιαν και επιθεισ επ αυτον τασ χειρασ ειπεν σαουλ αδελφε ο κυριοσ απεσταλκεν με ο οφθεισ σοι εν τη οδω η ηρχου οπωσ αναβλεψησ και πλησθησ πνευματοσ αγιου ");
INSERT INTO grcmt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","και ευθεωσ απεπεσον απο των οφθαλμων αυτου ωσει λεπιδεσ ανεβλεψεν τε και αναστασ εβαπτισθη ");
INSERT INTO grcmt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","και λαβων τροφην ενισχυσεν εγενετο δε ο σαυλοσ μετα των εν δαμασκω μαθητων ημερασ τινασ ");
INSERT INTO grcmt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","και ευθεωσ εν ταισ συναγωγαισ εκηρυσσεν τον χριστον οτι ουτοσ εστιν ο υιοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","εξισταντο δε παντεσ οι ακουοντεσ και ελεγον ουχ ουτοσ εστιν ο πορθησασ εν ιερουσαλημ τουσ επικαλουμενουσ το ονομα τουτο και ωδε εισ τουτο εληλυθεν ινα δεδεμενουσ αυτουσ αγαγη επι τουσ αρχιερεισ ");
INSERT INTO grcmt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","σαυλοσ δε μαλλον ενεδυναμουτο και συνεχυνεν τουσ ιουδαιουσ τουσ κατοικουντασ εν δαμασκω συμβιβαζων οτι ουτοσ εστιν ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ωσ δε επληρουντο ημεραι ικαναι συνεβουλευσαντο οι ιουδαιοι ανελειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","εγνωσθη δε τω σαυλω η επιβουλη αυτων παρετηρουν τε τασ πυλασ ημερασ τε και νυκτοσ οπωσ αυτον ανελωσιν ");
INSERT INTO grcmt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","λαβοντεσ δε αυτον οι μαθηται νυκτοσ καθηκαν δια του τειχουσ χαλασαντεσ εν σπυριδι ");
INSERT INTO grcmt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","παραγενομενοσ δε ο σαυλοσ εν ιερουσαλημ επειρατο κολλασθαι τοισ μαθηταισ και παντεσ εφοβουντο αυτον μη πιστευοντεσ οτι εστιν μαθητησ ");
INSERT INTO grcmt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","βαρναβασ δε επιλαβομενοσ αυτον ηγαγεν προσ τουσ αποστολουσ και διηγησατο αυτοισ πωσ εν τη οδω ειδεν τον κυριον και οτι ελαλησεν αυτω και πωσ εν δαμασκω επαρρησιασατο εν τω ονοματι του ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","και ην μετ αυτων εισπορευομενοσ εισ ιερουσαλημ και παρρησιαζομενοσ εν τω ονοματι του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ελαλει τε και συνεζητει προσ τουσ ελληνιστασ οι δε επεχειρουν αυτον ανελειν ");
INSERT INTO grcmt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","επιγνοντεσ δε οι αδελφοι κατηγαγον αυτον εισ καισαρειαν και εξαπεστειλαν αυτον εισ ταρσον ");
INSERT INTO grcmt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","αι μεν ουν εκκλησιαι καθ ολησ τησ ιουδαιασ και γαλιλαιασ και σαμαρειασ ειχον ειρηνην οικοδομουμεναι και πορευομεναι τω φοβω του κυριου και τη παρακλησει του αγιου πνευματοσ επληθυνοντο ");
INSERT INTO grcmt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","εγενετο δε πετρον διερχομενον δια παντων κατελθειν και προσ τουσ αγιουσ τουσ κατοικουντασ λυδδαν ");
INSERT INTO grcmt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ευρεν δε εκει ανθρωπον τινα αινεαν ονοματι εξ ετων οκτω κατακειμενον επι κραββατω οσ ην παραλελυμενοσ ");
INSERT INTO grcmt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","και ειπεν αυτω ο πετροσ αινεα ιαται σε ιησουσ ο χριστοσ αναστηθι και στρωσον σεαυτω και ευθεωσ ανεστη ");
INSERT INTO grcmt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","και ειδον αυτον παντεσ οι κατοικουντεσ λυδδαν και τον ασσαρωνα οιτινεσ επεστρεψαν επι τον κυριον ");
INSERT INTO grcmt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","εν ιοππη δε τισ ην μαθητρια ονοματι ταβηθα η διερμηνευομενη λεγεται δορκασ αυτη ην πληρησ αγαθων εργων και ελεημοσυνων ων εποιει ");
INSERT INTO grcmt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","εγενετο δε εν ταισ ημεραισ εκειναισ ασθενησασαν αυτην αποθανειν λουσαντεσ δε αυτην εθηκαν εν υπερωω ");
INSERT INTO grcmt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","εγγυσ δε ουσησ λυδδησ τη ιοππη οι μαθηται ακουσαντεσ οτι πετροσ εστιν εν αυτη απεστειλαν προσ αυτον παρακαλουντεσ μη οκνησαι διελθειν εωσ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","αναστασ δε πετροσ συνηλθεν αυτοισ ον παραγενομενον ανηγαγον εισ το υπερωον και παρεστησαν αυτω πασαι αι χηραι κλαιουσαι και επιδεικνυμεναι χιτωνασ και ιματια οσα εποιει μετ αυτων ουσα η δορκασ ");
INSERT INTO grcmt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","εκβαλων δε εξω παντασ ο πετροσ θεισ τα γονατα προσηυξατο και επιστρεψασ προσ το σωμα ειπεν ταβηθα αναστηθι η δε ηνοιξεν τουσ οφθαλμουσ αυτησ και ιδουσα τον πετρον ανεκαθισεν ");
INSERT INTO grcmt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","δουσ δε αυτη χειρα ανεστησεν αυτην φωνησασ δε τουσ αγιουσ και τασ χηρασ παρεστησεν αυτην ζωσαν ");
INSERT INTO grcmt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","γνωστον δε εγενετο καθ ολησ τησ ιοππησ και πολλοι επιστευσαν επι τον κυριον ");
INSERT INTO grcmt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","εγενετο δε ημερασ ικανασ μειναι αυτον εν ιοππη παρα τινι σιμωνι βυρσει ");
INSERT INTO grcmt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ανηρ δε τισ ην εν καισαρεια ονοματι κορνηλιοσ εκατονταρχησ εκ σπειρησ τησ καλουμενησ ιταλικησ ");
INSERT INTO grcmt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ευσεβησ και φοβουμενοσ τον θεον συν παντι τω οικω αυτου ποιων τε ελεημοσυνασ πολλασ τω λαω και δεομενοσ του θεου δια παντοσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ειδεν εν οραματι φανερωσ ωσει ωραν ενατην τησ ημερασ αγγελον του θεου εισελθοντα προσ αυτον και ειποντα αυτω κορνηλιε ");
INSERT INTO grcmt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ο δε ατενισασ αυτω και εμφοβοσ γενομενοσ ειπεν τι εστιν κυριε ειπεν δε αυτω αι προσευχαι σου και αι ελεημοσυναι σου ανεβησαν εισ μνημοσυνον ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","και νυν πεμψον εισ ιοππην ανδρασ και μεταπεμψαι σιμωνα τον επικαλουμενον πετρον ");
INSERT INTO grcmt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ουτοσ ξενιζεται παρα τινι σιμωνι βυρσει ω εστιν οικια παρα θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ωσ δε απηλθεν ο αγγελοσ ο λαλων τω κορνηλιω φωνησασ δυο των οικετων αυτου και στρατιωτην ευσεβη των προσκαρτερουντων αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","και εξηγησαμενοσ αυτοισ απαντα απεστειλεν αυτουσ εισ την ιοππην ");
INSERT INTO grcmt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","τη δε επαυριον οδοιπορουντων εκεινων και τη πολει εγγιζοντων ανεβη πετροσ επι το δωμα προσευξασθαι περι ωραν εκτην ");
INSERT INTO grcmt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","εγενετο δε προσπεινοσ και ηθελεν γευσασθαι παρασκευαζοντων δε εκεινων επεπεσεν επ αυτον εκστασισ ");
INSERT INTO grcmt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","και θεωρει τον ουρανον ανεωγμενον και καταβαινον επ αυτον σκευοσ τι ωσ οθονην μεγαλην τεσσαρσιν αρχαισ δεδεμενον και καθιεμενον επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","εν ω υπηρχεν παντα τα τετραποδα τησ γησ και τα θηρια και τα ερπετα και τα πετεινα του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","και εγενετο φωνη προσ αυτον αναστασ πετρε θυσον και φαγε ");
INSERT INTO grcmt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ο δε πετροσ ειπεν μηδαμωσ κυριε οτι ουδεποτε εφαγον παν κοινον η ακαθαρτον ");
INSERT INTO grcmt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","και φωνη παλιν εκ δευτερου προσ αυτον α ο θεοσ εκαθαρισεν συ μη κοινου ");
INSERT INTO grcmt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","τουτο δε εγενετο επι τρισ και παλιν ανεληφθη το σκευοσ εισ τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ωσ δε εν εαυτω διηπορει ο πετροσ τι αν ειη το οραμα ο ειδεν και ιδου οι ανδρεσ οι απεσταλμενοι απο του κορνηλιου διερωτησαντεσ την οικιαν σιμωνοσ επεστησαν επι τον πυλωνα ");
INSERT INTO grcmt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","και φωνησαντεσ επυνθανοντο ει σιμων ο επικαλουμενοσ πετροσ ενθαδε ξενιζεται ");
INSERT INTO grcmt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","του δε πετρου διενθυμουμενου περι του οραματοσ ειπεν αυτω το πνευμα ιδου ανδρεσ ζητουσιν σε ");
INSERT INTO grcmt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","αλλα αναστασ καταβηθι και πορευου συν αυτοισ μηδεν διακρινομενοσ διοτι εγω απεσταλκα αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","καταβασ δε πετροσ προσ τουσ ανδρασ ειπεν ιδου εγω ειμι ον ζητειτε τισ η αιτια δι ην παρεστε ");
INSERT INTO grcmt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","οι δε ειπον κορνηλιοσ εκατονταρχησ ανηρ δικαιοσ και φοβουμενοσ τον θεον μαρτυρουμενοσ τε υπο ολου του εθνουσ των ιουδαιων εχρηματισθη υπο αγγελου αγιου μεταπεμψασθαι σε εισ τον οικον αυτου και ακουσαι ρηματα παρα σου ");
INSERT INTO grcmt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","εισκαλεσαμενοσ ουν αυτουσ εξενισεν τη δε επαυριον ο πετροσ εξηλθεν συν αυτοισ και τινεσ των αδελφων των απο ιοππησ συνηλθον αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","και τη επαυριον εισηλθον εισ την καισαρειαν ο δε κορνηλιοσ ην προσδοκων αυτουσ συγκαλεσαμενοσ τουσ συγγενεισ αυτου και τουσ αναγκαιουσ φιλουσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ωσ δε εγενετο του εισελθειν τον πετρον συναντησασ αυτω ο κορνηλιοσ πεσων επι τουσ ποδασ προσεκυνησεν ");
INSERT INTO grcmt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ο δε πετροσ αυτον ηγειρεν λεγων αναστηθι καγω αυτοσ ανθρωποσ ειμι ");
INSERT INTO grcmt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","και συνομιλων αυτω εισηλθεν και ευρισκει συνεληλυθοτασ πολλουσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","εφη τε προσ αυτουσ υμεισ επιστασθε ωσ αθεμιτον εστιν ανδρι ιουδαιω κολλασθαι η προσερχεσθαι αλλοφυλω και εμοι ο θεοσ εδειξεν μηδενα κοινον η ακαθαρτον λεγειν ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","διο και αναντιρρητωσ ηλθον μεταπεμφθεισ πυνθανομαι ουν τινι λογω μετεπεμψασθε με ");
INSERT INTO grcmt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","και ο κορνηλιοσ εφη απο τεταρτησ ημερασ μεχρι ταυτησ τησ ωρασ ημην νηστευων και την ενατην ωραν προσευχομενοσ εν τω οικω μου και ιδου ανηρ εστη ενωπιον μου εν εσθητι λαμπρα ");
INSERT INTO grcmt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","και φησιν κορνηλιε εισηκουσθη σου η προσευχη και αι ελεημοσυναι σου εμνησθησαν ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","πεμψον ουν εισ ιοππην και μετακαλεσαι σιμωνα οσ επικαλειται πετροσ ουτοσ ξενιζεται εν οικια σιμωνοσ βυρσεωσ παρα θαλασσαν οσ παραγενομενοσ λαλησει σοι ");
INSERT INTO grcmt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","εξαυτησ ουν επεμψα προσ σε συ τε καλωσ εποιησασ παραγενομενοσ νυν ουν παντεσ ημεισ ενωπιον του θεου παρεσμεν ακουσαι παντα τα προστεταγμενα σοι υπο του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ανοιξασ δε πετροσ το στομα ειπεν επ αληθειασ καταλαμβανομαι οτι ουκ εστιν προσωποληπτησ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","αλλ εν παντι εθνει ο φοβουμενοσ αυτον και εργαζομενοσ δικαιοσυνην δεκτοσ αυτω εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","τον λογον ον απεστειλεν τοισ υιοισ ισραηλ ευαγγελιζομενοσ ειρηνην δια ιησου χριστου ουτοσ εστιν παντων κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","υμεισ οιδατε το γενομενον ρημα καθ ολησ τησ ιουδαιασ αρξαμενον απο τησ γαλιλαιασ μετα το βαπτισμα ο εκηρυξεν ιωαννησ ");
INSERT INTO grcmt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ιησουν τον απο ναζαρετ ωσ εχρισεν αυτον ο θεοσ πνευματι αγιω και δυναμει οσ διηλθεν ευεργετων και ιωμενοσ παντασ τουσ καταδυναστευομενουσ υπο του διαβολου οτι ο θεοσ ην μετ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","και ημεισ εσμεν μαρτυρεσ παντων ων εποιησεν εν τε τη χωρα των ιουδαιων και εν ιερουσαλημ ον και ανειλον κρεμασαντεσ επι ξυλου ");
INSERT INTO grcmt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","τουτον ο θεοσ ηγειρεν τη τριτη ημερα και εδωκεν αυτον εμφανη γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ου παντι τω λαω αλλα μαρτυσιν τοισ προκεχειροτονημενοισ υπο του θεου ημιν οιτινεσ συνεφαγομεν και συνεπιομεν αυτω μετα το αναστηναι αυτον εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","και παρηγγειλεν ημιν κηρυξαι τω λαω και διαμαρτυρασθαι οτι αυτοσ εστιν ο ωρισμενοσ υπο του θεου κριτησ ζωντων και νεκρων ");
INSERT INTO grcmt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","τουτω παντεσ οι προφηται μαρτυρουσιν αφεσιν αμαρτιων λαβειν δια του ονοματοσ αυτου παντα τον πιστευοντα εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ετι λαλουντοσ του πετρου τα ρηματα ταυτα επεπεσεν το πνευμα το αγιον επι παντασ τουσ ακουοντασ τον λογον ");
INSERT INTO grcmt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","και εξεστησαν οι εκ περιτομησ πιστοι οσοι συνηλθον τω πετρω οτι και επι τα εθνη η δωρεα του αγιου πνευματοσ εκκεχυται ");
INSERT INTO grcmt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ηκουον γαρ αυτων λαλουντων γλωσσαισ και μεγαλυνοντων τον θεον τοτε απεκριθη ο πετροσ ");
INSERT INTO grcmt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","μητι το υδωρ κωλυσαι δυναται τισ του μη βαπτισθηναι τουτουσ οιτινεσ το πνευμα το αγιον ελαβον καθωσ και ημεισ ");
INSERT INTO grcmt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","προσεταξεν τε αυτουσ βαπτισθηναι εν τω ονοματι του κυριου τοτε ηρωτησαν αυτον επιμειναι ημερασ τινασ ");
INSERT INTO grcmt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ηκουσαν δε οι αποστολοι και οι αδελφοι οι οντεσ κατα την ιουδαιαν οτι και τα εθνη εδεξαντο τον λογον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","και οτε ανεβη πετροσ εισ ιεροσολυμα διεκρινοντο προσ αυτον οι εκ περιτομησ ");
INSERT INTO grcmt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","λεγοντεσ οτι προσ ανδρασ ακροβυστιαν εχοντασ εισηλθεσ και συνεφαγεσ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","αρξαμενοσ δε ο πετροσ εξετιθετο αυτοισ καθεξησ λεγων ");
INSERT INTO grcmt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","εγω ημην εν πολει ιοππη προσευχομενοσ και ειδον εν εκστασει οραμα καταβαινον σκευοσ τι ωσ οθονην μεγαλην τεσσαρσιν αρχαισ καθιεμενην εκ του ουρανου και ηλθεν αχρι εμου ");
INSERT INTO grcmt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","εισ ην ατενισασ κατενοουν και ειδον τα τετραποδα τησ γησ και τα θηρια και τα ερπετα και τα πετεινα του ουρανου ");
INSERT INTO grcmt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ηκουσα δε φωνησ λεγουσησ μοι αναστασ πετρε θυσον και φαγε ");
INSERT INTO grcmt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ειπον δε μηδαμωσ κυριε οτι παν κοινον η ακαθαρτον ουδεποτε εισηλθεν εισ το στομα μου ");
INSERT INTO grcmt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","απεκριθη δε μοι φωνη εκ δευτερου εκ του ουρανου α ο θεοσ εκαθαρισεν συ μη κοινου ");
INSERT INTO grcmt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","τουτο δε εγενετο επι τρισ και παλιν ανεσπασθη απαντα εισ τον ουρανον ");
INSERT INTO grcmt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","και ιδου εξαυτησ τρεισ ανδρεσ επεστησαν επι την οικιαν εν η ημην απεσταλμενοι απο καισαρειασ προσ με ");
INSERT INTO grcmt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ειπεν δε μοι το πνευμα συνελθειν αυτοισ μηδεν διακρινομενον ηλθον δε συν εμοι και οι εξ αδελφοι ουτοι και εισηλθομεν εισ τον οικον του ανδροσ ");
INSERT INTO grcmt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","απηγγειλεν τε ημιν πωσ ειδεν τον αγγελον εν τω οικω αυτου σταθεντα και ειποντα αυτω αποστειλον εισ ιοππην ανδρασ και μεταπεμψαι σιμωνα τον επικαλουμενον πετρον ");
INSERT INTO grcmt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","οσ λαλησει ρηματα προσ σε εν οισ σωθηση συ και πασ ο οικοσ σου ");
INSERT INTO grcmt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","εν δε τω αρξασθαι με λαλειν επεπεσεν το πνευμα το αγιον επ αυτουσ ωσπερ και εφ ημασ εν αρχη ");
INSERT INTO grcmt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","εμνησθην δε του ρηματοσ κυριου ωσ ελεγεν ιωαννησ μεν εβαπτισεν υδατι υμεισ δε βαπτισθησεσθε εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ει ουν την ισην δωρεαν εδωκεν αυτοισ ο θεοσ ωσ και ημιν πιστευσασιν επι τον κυριον ιησουν χριστον εγω δε τισ ημην δυνατοσ κωλυσαι τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ακουσαντεσ δε ταυτα ησυχασαν και εδοξαζον τον θεον λεγοντεσ αρα γε και τοισ εθνεσιν ο θεοσ την μετανοιαν εδωκεν εισ ζωην ");
INSERT INTO grcmt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","οι μεν ουν διασπαρεντεσ απο τησ θλιψεωσ τησ γενομενησ επι στεφανω διηλθον εωσ φοινικησ και κυπρου και αντιοχειασ μηδενι λαλουντεσ τον λογον ει μη μονον ιουδαιοισ ");
INSERT INTO grcmt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ησαν δε τινεσ εξ αυτων ανδρεσ κυπριοι και κυρηναιοι οιτινεσ εισελθοντεσ εισ αντιοχειαν ελαλουν προσ τουσ ελληνιστασ ευαγγελιζομενοι τον κυριον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","και ην χειρ κυριου μετ αυτων πολυσ τε αριθμοσ πιστευσασ επεστρεψεν επι τον κυριον ");
INSERT INTO grcmt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ηκουσθη δε ο λογοσ εισ τα ωτα τησ εκκλησιασ τησ εν ιεροσολυμοισ περι αυτων και εξαπεστειλαν βαρναβαν διελθειν εωσ αντιοχειασ ");
INSERT INTO grcmt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","οσ παραγενομενοσ και ιδων την χαριν του θεου εχαρη και παρεκαλει παντασ τη προθεσει τησ καρδιασ προσμενειν τω κυριω ");
INSERT INTO grcmt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","οτι ην ανηρ αγαθοσ και πληρησ πνευματοσ αγιου και πιστεωσ και προσετεθη οχλοσ ικανοσ τω κυριω ");
INSERT INTO grcmt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","εξηλθεν δε εισ ταρσον ο βαρναβασ αναζητησαι σαυλον ");
INSERT INTO grcmt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","και ευρων ηγαγεν αυτον εισ αντιοχειαν εγενετο δε αυτουσ ενιαυτον ολον συναχθηναι τη εκκλησια και διδαξαι οχλον ικανον χρηματισαι τε πρωτον εν αντιοχεια τουσ μαθητασ χριστιανουσ ");
INSERT INTO grcmt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","εν ταυταισ δε ταισ ημεραισ κατηλθον απο ιεροσολυμων προφηται εισ αντιοχειαν ");
INSERT INTO grcmt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","αναστασ δε εισ εξ αυτων ονοματι αγαβοσ εσημανεν δια του πνευματοσ λιμον μεγαν μελλειν εσεσθαι εφ ολην την οικουμενην οστισ και εγενετο επι κλαυδιου καισαροσ ");
INSERT INTO grcmt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","των δε μαθητων καθωσ ευπορειτο τισ ωρισαν εκαστοσ αυτων εισ διακονιαν πεμψαι τοισ κατοικουσιν εν τη ιουδαια αδελφοισ ");
INSERT INTO grcmt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ο και εποιησαν αποστειλαντεσ προσ τουσ πρεσβυτερουσ δια χειροσ βαρναβα και σαυλου ");
INSERT INTO grcmt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","κατ εκεινον δε τον καιρον επεβαλεν ηρωδησ ο βασιλευσ τασ χειρασ κακωσαι τινασ των απο τησ εκκλησιασ ");
INSERT INTO grcmt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ανειλεν δε ιακωβον τον αδελφον ιωαννου μαχαιρα ");
INSERT INTO grcmt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","και ιδων οτι αρεστον εστιν τοισ ιουδαιοισ προσεθετο συλλαβειν και πετρον ησαν δε αι ημεραι των αζυμων ");
INSERT INTO grcmt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ον και πιασασ εθετο εισ φυλακην παραδουσ τεσσαρσιν τετραδιοισ στρατιωτων φυλασσειν αυτον βουλομενοσ μετα το πασχα αναγαγειν αυτον τω λαω ");
INSERT INTO grcmt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ο μεν ουν πετροσ ετηρειτο εν τη φυλακη προσευχη δε ην εκτενησ γινομενη υπο τησ εκκλησιασ προσ τον θεον υπερ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","οτε δε εμελλεν αυτον προαγειν ο ηρωδησ τη νυκτι εκεινη ην ο πετροσ κοιμωμενοσ μεταξυ δυο στρατιωτων δεδεμενοσ αλυσεσιν δυσιν φυλακεσ τε προ τησ θυρασ ετηρουν την φυλακην ");
INSERT INTO grcmt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","και ιδου αγγελοσ κυριου επεστη και φωσ ελαμψεν εν τω οικηματι παταξασ δε την πλευραν του πετρου ηγειρεν αυτον λεγων αναστα εν ταχει και εξεπεσον αυτου αι αλυσεισ εκ των χειρων ");
INSERT INTO grcmt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ειπεν τε ο αγγελοσ προσ αυτον περιζωσαι και υποδησαι τα σανδαλια σου εποιησεν δε ουτωσ και λεγει αυτω περιβαλου το ιματιον σου και ακολουθει μοι ");
INSERT INTO grcmt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","και εξελθων ηκολουθει αυτω και ουκ ηδει οτι αληθεσ εστιν το γινομενον δια του αγγελου εδοκει δε οραμα βλεπειν ");
INSERT INTO grcmt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","διελθοντεσ δε πρωτην φυλακην και δευτεραν ηλθον επι την πυλην την σιδηραν την φερουσαν εισ την πολιν ητισ αυτοματη ηνοιχθη αυτοισ και εξελθοντεσ προηλθον ρυμην μιαν και ευθεωσ απεστη ο αγγελοσ απ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","και ο πετροσ γενομενοσ εν εαυτω ειπεν νυν οιδα αληθωσ οτι εξαπεστειλεν κυριοσ τον αγγελον αυτου και εξειλετο με εκ χειροσ ηρωδου και πασησ τησ προσδοκιασ του λαου των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","συνιδων τε ηλθεν επι την οικιαν μαριασ τησ μητροσ ιωαννου του επικαλουμενου μαρκου ου ησαν ικανοι συνηθροισμενοι και προσευχομενοι ");
INSERT INTO grcmt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","κρουσαντοσ δε του πετρου την θυραν του πυλωνοσ προσηλθεν παιδισκη υπακουσαι ονοματι ροδη ");
INSERT INTO grcmt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","και επιγνουσα την φωνην του πετρου απο τησ χαρασ ουκ ηνοιξεν τον πυλωνα εισδραμουσα δε απηγγειλεν εσταναι τον πετρον προ του πυλωνοσ ");
INSERT INTO grcmt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","οι δε προσ αυτην ειπον μαινη η δε διισχυριζετο ουτωσ εχειν οι δε ελεγον ο αγγελοσ αυτου εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ο δε πετροσ επεμενεν κρουων ανοιξαντεσ δε ειδον αυτον και εξεστησαν ");
INSERT INTO grcmt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","κατασεισασ δε αυτοισ τη χειρι σιγαν διηγησατο αυτοισ πωσ ο κυριοσ αυτον εξηγαγεν εκ τησ φυλακησ ειπεν δε απαγγειλατε ιακωβω και τοισ αδελφοισ ταυτα και εξελθων επορευθη εισ ετερον τοπον ");
INSERT INTO grcmt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","γενομενησ δε ημερασ ην ταραχοσ ουκ ολιγοσ εν τοισ στρατιωταισ τι αρα ο πετροσ εγενετο ");
INSERT INTO grcmt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ηρωδησ δε επιζητησασ αυτον και μη ευρων ανακρινασ τουσ φυλακασ εκελευσεν απαχθηναι και κατελθων απο τησ ιουδαιασ εισ την καισαρειαν διετριβεν ");
INSERT INTO grcmt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ην δε ο ηρωδησ θυμομαχων τυριοισ και σιδωνιοισ ομοθυμαδον δε παρησαν προσ αυτον και πεισαντεσ βλαστον τον επι του κοιτωνοσ του βασιλεωσ ητουντο ειρηνην δια το τρεφεσθαι αυτων την χωραν απο τησ βασιλικησ ");
INSERT INTO grcmt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","τακτη δε ημερα ο ηρωδησ ενδυσαμενοσ εσθητα βασιλικην και καθισασ επι του βηματοσ εδημηγορει προσ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ο δε δημοσ επεφωνει φωνη θεου και ουκ ανθρωπου ");
INSERT INTO grcmt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","παραχρημα δε επαταξεν αυτον αγγελοσ κυριου ανθ ων ουκ εδωκεν δοξαν τω θεω και γενομενοσ σκωληκοβρωτοσ εξεψυξεν ");
INSERT INTO grcmt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ο δε λογοσ του θεου ηυξανεν και επληθυνετο ");
INSERT INTO grcmt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","βαρναβασ δε και σαυλοσ υπεστρεψαν εισ ιερουσαλημ πληρωσαντεσ την διακονιαν συμπαραλαβοντεσ και ιωαννην τον επικληθεντα μαρκον ");
INSERT INTO grcmt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ησαν δε τινεσ εν αντιοχεια κατα την ουσαν εκκλησιαν προφηται και διδασκαλοι ο τε βαρναβασ και συμεων ο καλουμενοσ νιγερ και λουκιοσ ο κυρηναιοσ μαναην τε ηρωδου του τετραρχου συντροφοσ και σαυλοσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","λειτουργουντων δε αυτων τω κυριω και νηστευοντων ειπεν το πνευμα το αγιον αφορισατε δη μοι τον βαρναβαν και τον σαυλον εισ το εργον ο προσκεκλημαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","τοτε νηστευσαντεσ και προσευξαμενοι και επιθεντεσ τασ χειρασ αυτοισ απελυσαν ");
INSERT INTO grcmt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ουτοι μεν ουν εκπεμφθεντεσ υπο του πνευματοσ του αγιου κατηλθον εισ την σελευκειαν εκειθεν δε απεπλευσαν εισ την κυπρον ");
INSERT INTO grcmt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","και γενομενοι εν σαλαμινι κατηγγελλον τον λογον του θεου εν ταισ συναγωγαισ των ιουδαιων ειχον δε και ιωαννην υπηρετην ");
INSERT INTO grcmt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","διελθοντεσ δε την νησον αχρι παφου ευρον τινα μαγον ψευδοπροφητην ιουδαιον ω ονομα βαριησουσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","οσ ην συν τω ανθυπατω σεργιω παυλω ανδρι συνετω ουτοσ προσκαλεσαμενοσ βαρναβαν και σαυλον επεζητησεν ακουσαι τον λογον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ανθιστατο δε αυτοισ ελυμασ ο μαγοσ ουτωσ γαρ μεθερμηνευεται το ονομα αυτου ζητων διαστρεψαι τον ανθυπατον απο τησ πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","σαυλοσ δε ο και παυλοσ πλησθεισ πνευματοσ αγιου και ατενισασ εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ειπεν ω πληρησ παντοσ δολου και πασησ ραδιουργιασ υιε διαβολου εχθρε πασησ δικαιοσυνησ ου παυση διαστρεφων τασ οδουσ κυριου τασ ευθειασ ");
INSERT INTO grcmt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","και νυν ιδου χειρ κυριου επι σε και εση τυφλοσ μη βλεπων τον ηλιον αχρι καιρου παραχρημα δε επεπεσεν επ αυτον αχλυσ και σκοτοσ και περιαγων εζητει χειραγωγουσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","τοτε ιδων ο ανθυπατοσ το γεγονοσ επιστευσεν εκπλησσομενοσ επι τη διδαχη του κυριου ");
INSERT INTO grcmt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","αναχθεντεσ δε απο τησ παφου οι περι τον παυλον ηλθον εισ περγην τησ παμφυλιασ ιωαννησ δε αποχωρησασ απ αυτων υπεστρεψεν εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","αυτοι δε διελθοντεσ απο τησ περγησ παρεγενοντο εισ αντιοχειαν τησ πισιδιασ και εισελθοντεσ εισ την συναγωγην τη ημερα των σαββατων εκαθισαν ");
INSERT INTO grcmt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","μετα δε την αναγνωσιν του νομου και των προφητων απεστειλαν οι αρχισυναγωγοι προσ αυτουσ λεγοντεσ ανδρεσ αδελφοι ει εστιν λογοσ εν υμιν παρακλησεωσ προσ τον λαον λεγετε ");
INSERT INTO grcmt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","αναστασ δε παυλοσ και κατασεισασ τη χειρι ειπεν ανδρεσ ισραηλιται και οι φοβουμενοι τον θεον ακουσατε ");
INSERT INTO grcmt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ο θεοσ του λαου τουτου εξελεξατο τουσ πατερασ ημων και τον λαον υψωσεν εν τη παροικια εν γη αιγυπτω και μετα βραχιονοσ υψηλου εξηγαγεν αυτουσ εξ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","και ωσ τεσσαρακονταετη χρονον ετροποφορησεν αυτουσ εν τη ερημω ");
INSERT INTO grcmt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","και καθελων εθνη επτα εν γη χανααν κατεκληρονομησεν αυτοισ την γην αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","και μετα ταυτα ωσ ετεσιν τετρακοσιοισ και πεντηκοντα εδωκεν κριτασ εωσ σαμουηλ του προφητου ");
INSERT INTO grcmt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","κακειθεν ητησαντο βασιλεα και εδωκεν αυτοισ ο θεοσ τον σαουλ υιον κισ ανδρα εκ φυλησ βενιαμιν ετη τεσσαρακοντα ");
INSERT INTO grcmt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","και μεταστησασ αυτον ηγειρεν αυτοισ τον δαυιδ εισ βασιλεα ω και ειπεν μαρτυρησασ ευρον δαυιδ τον του ιεσσαι ανδρα κατα την καρδιαν μου οσ ποιησει παντα τα θεληματα μου ");
INSERT INTO grcmt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","τουτου ο θεοσ απο του σπερματοσ κατ επαγγελιαν ηγαγεν τω ισραηλ σωτηριαν ");
INSERT INTO grcmt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","προκηρυξαντοσ ιωαννου προ προσωπου τησ εισοδου αυτου βαπτισμα μετανοιασ τω ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ωσ δε επληρου ο ιωαννησ τον δρομον ελεγεν τινα με υπονοειτε ειναι ουκ ειμι εγω αλλ ιδου ερχεται μετ εμε ου ουκ ειμι αξιοσ το υποδημα των ποδων λυσαι ");
INSERT INTO grcmt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ανδρεσ αδελφοι υιοι γενουσ αβρααμ και οι εν υμιν φοβουμενοι τον θεον υμιν ο λογοσ τησ σωτηριασ ταυτησ απεσταλη ");
INSERT INTO grcmt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","οι γαρ κατοικουντεσ εν ιερουσαλημ και οι αρχοντεσ αυτων τουτον αγνοησαντεσ και τασ φωνασ των προφητων τασ κατα παν σαββατον αναγινωσκομενασ κριναντεσ επληρωσαν ");
INSERT INTO grcmt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","και μηδεμιαν αιτιαν θανατου ευροντεσ ητησαντο πιλατον αναιρεθηναι αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ωσ δε ετελεσαν παντα τα περι αυτου γεγραμμενα καθελοντεσ απο του ξυλου εθηκαν εισ μνημειον ");
INSERT INTO grcmt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ο δε θεοσ ηγειρεν αυτον εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","οσ ωφθη επι ημερασ πλειουσ τοισ συναναβασιν αυτω απο τησ γαλιλαιασ εισ ιερουσαλημ οιτινεσ εισιν μαρτυρεσ αυτου προσ τον λαον ");
INSERT INTO grcmt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","και ημεισ υμασ ευαγγελιζομεθα την προσ τουσ πατερασ επαγγελιαν γενομενην οτι ταυτην ο θεοσ εκπεπληρωκεν τοισ τεκνοισ αυτων ημιν αναστησασ ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ωσ και εν τω ψαλμω τω δευτερω γεγραπται υιοσ μου ει συ εγω σημερον γεγεννηκα σε ");
INSERT INTO grcmt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","οτι δε ανεστησεν αυτον εκ νεκρων μηκετι μελλοντα υποστρεφειν εισ διαφθοραν ουτωσ ειρηκεν οτι δωσω υμιν τα οσια δαυιδ τα πιστα ");
INSERT INTO grcmt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","διο και εν ετερω λεγει ου δωσεισ τον οσιον σου ιδειν διαφθοραν ");
INSERT INTO grcmt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","δαυιδ μεν γαρ ιδια γενεα υπηρετησασ τη του θεου βουλη εκοιμηθη και προσετεθη προσ τουσ πατερασ αυτου και ειδεν διαφθοραν ");
INSERT INTO grcmt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ον δε ο θεοσ ηγειρεν ουκ ειδεν διαφθοραν ");
INSERT INTO grcmt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","γνωστον ουν εστω υμιν ανδρεσ αδελφοι οτι δια τουτου υμιν αφεσισ αμαρτιων καταγγελλεται ");
INSERT INTO grcmt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","και απο παντων ων ουκ ηδυνηθητε εν τω νομω μωυσεωσ δικαιωθηναι εν τουτω πασ ο πιστευων δικαιουται ");
INSERT INTO grcmt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","βλεπετε ουν μη επελθη εφ υμασ το ειρημενον εν τοισ προφηταισ ");
INSERT INTO grcmt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ιδετε οι καταφρονηται και θαυμασατε και αφανισθητε οτι εργον εγω εργαζομαι εν ταισ ημεραισ υμων ο ου μη πιστευσητε εαν τισ εκδιηγηται υμιν ");
INSERT INTO grcmt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","εξιοντων δε εκ τησ συναγωγησ των ιουδαιων παρεκαλουν τα εθνη εισ το μεταξυ σαββατον λαληθηναι αυτοισ τα ρηματα ");
INSERT INTO grcmt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","λυθεισησ δε τησ συναγωγησ ηκολουθησαν πολλοι των ιουδαιων και των σεβομενων προσηλυτων τω παυλω και τω βαρναβα οιτινεσ προσλαλουντεσ επειθον αυτουσ επιμενειν τη χαριτι του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","τω τε ερχομενω σαββατω σχεδον πασα η πολισ συνηχθη ακουσαι τον λογον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ιδοντεσ δε οι ιουδαιοι τουσ οχλουσ επλησθησαν ζηλου και αντελεγον τοισ υπο του παυλου λεγομενοισ αντιλεγοντεσ και βλασφημουντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","παρρησιασαμενοι δε ο παυλοσ και ο βαρναβασ ειπον υμιν ην αναγκαιον πρωτον λαληθηναι τον λογον του θεου επειδη δε απωθεισθε αυτον και ουκ αξιουσ κρινετε εαυτουσ τησ αιωνιου ζωησ ιδου στρεφομεθα εισ τα εθνη ");
INSERT INTO grcmt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ουτωσ γαρ εντεταλται ημιν ο κυριοσ τεθεικα σε εισ φωσ εθνων του ειναι σε εισ σωτηριαν εωσ εσχατου τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ακουοντα δε τα εθνη εχαιρεν και εδοξαζον τον λογον του κυριου και επιστευσαν οσοι ησαν τεταγμενοι εισ ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","διεφερετο δε ο λογοσ του κυριου δι ολησ τησ χωρασ ");
INSERT INTO grcmt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","οι δε ιουδαιοι παρωτρυναν τασ σεβομενασ γυναικασ και τασ ευσχημονασ και τουσ πρωτουσ τησ πολεωσ και επηγειραν διωγμον επι τον παυλον και τον βαρναβαν και εξεβαλον αυτουσ απο των οριων αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","οι δε εκτιναξαμενοι τον κονιορτον των ποδων αυτων επ αυτουσ ηλθον εισ ικονιον ");
INSERT INTO grcmt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","οι δε μαθηται επληρουντο χαρασ και πνευματοσ αγιου ");
INSERT INTO grcmt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","εγενετο δε εν ικονιω κατα το αυτο εισελθειν αυτουσ εισ την συναγωγην των ιουδαιων και λαλησαι ουτωσ ωστε πιστευσαι ιουδαιων τε και ελληνων πολυ πληθοσ ");
INSERT INTO grcmt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","οι δε απειθουντεσ ιουδαιοι επηγειραν και εκακωσαν τασ ψυχασ των εθνων κατα των αδελφων ");
INSERT INTO grcmt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ικανον μεν ουν χρονον διετριψαν παρρησιαζομενοι επι τω κυριω τω μαρτυρουντι τω λογω τησ χαριτοσ αυτου διδοντι σημεια και τερατα γινεσθαι δια των χειρων αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","εσχισθη δε το πληθοσ τησ πολεωσ και οι μεν ησαν συν τοισ ιουδαιοισ οι δε συν τοισ αποστολοισ ");
INSERT INTO grcmt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ωσ δε εγενετο ορμη των εθνων τε και ιουδαιων συν τοισ αρχουσιν αυτων υβρισαι και λιθοβολησαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","συνιδοντεσ κατεφυγον εισ τασ πολεισ τησ λυκαονιασ λυστραν και δερβην και την περιχωρον ");
INSERT INTO grcmt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","κακει ησαν ευαγγελιζομενοι ");
INSERT INTO grcmt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","και τισ ανηρ εν λυστροισ αδυνατοσ τοισ ποσιν εκαθητο χωλοσ εκ κοιλιασ μητροσ αυτου υπαρχων οσ ουδεποτε περιπεπατηκει ");
INSERT INTO grcmt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ουτοσ ηκουσεν του παυλου λαλουντοσ οσ ατενισασ αυτω και ιδων οτι πιστιν εχει του σωθηναι ");
INSERT INTO grcmt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ειπεν μεγαλη τη φωνη αναστηθι επι τουσ ποδασ σου ορθωσ και ηλλετο και περιεπατει ");
INSERT INTO grcmt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","οι δε οχλοι ιδοντεσ ο εποιησεν ο παυλοσ επηραν την φωνην αυτων λυκαονιστι λεγοντεσ οι θεοι ομοιωθεντεσ ανθρωποισ κατεβησαν προσ ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","εκαλουν τε τον μεν βαρναβαν δια τον δε παυλον ερμην επειδη αυτοσ ην ο ηγουμενοσ του λογου ");
INSERT INTO grcmt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ο δε ιερευσ του διοσ του οντοσ προ τησ πολεωσ αυτων ταυρουσ και στεμματα επι τουσ πυλωνασ ενεγκασ συν τοισ οχλοισ ηθελεν θυειν ");
INSERT INTO grcmt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ακουσαντεσ δε οι αποστολοι βαρναβασ και παυλοσ διαρρηξαντεσ τα ιματια αυτων εισεπηδησαν εισ τον οχλον κραζοντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","και λεγοντεσ ανδρεσ τι ταυτα ποιειτε και ημεισ ομοιοπαθεισ εσμεν υμιν ανθρωποι ευαγγελιζομενοι υμασ απο τουτων των ματαιων επιστρεφειν επι τον θεον τον ζωντα οσ εποιησεν τον ουρανον και την γην και την θαλασσαν και παντα τα εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","οσ εν ταισ παρωχημεναισ γενεαισ ειασεν παντα τα εθνη πορευεσθαι ταισ οδοισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","καιτοιγε ουκ αμαρτυρον εαυτον αφηκεν αγαθοποιων ουρανοθεν υμιν υετουσ διδουσ και καιρουσ καρποφορουσ εμπιπλων τροφησ και ευφροσυνησ τασ καρδιασ ημων ");
INSERT INTO grcmt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","και ταυτα λεγοντεσ μολισ κατεπαυσαν τουσ οχλουσ του μη θυειν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","επηλθον δε απο αντιοχειασ και ικονιου ιουδαιοι και πεισαντεσ τουσ οχλουσ και λιθασαντεσ τον παυλον εσυρον εξω τησ πολεωσ νομισαντεσ αυτον τεθναναι ");
INSERT INTO grcmt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","κυκλωσαντων δε αυτον των μαθητων αναστασ εισηλθεν εισ την πολιν και τη επαυριον εξηλθεν συν τω βαρναβα εισ δερβην ");
INSERT INTO grcmt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ευαγγελισαμενοι τε την πολιν εκεινην και μαθητευσαντεσ ικανουσ υπεστρεψαν εισ την λυστραν και ικονιον και αντιοχειαν ");
INSERT INTO grcmt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","επιστηριζοντεσ τασ ψυχασ των μαθητων παρακαλουντεσ εμμενειν τη πιστει και οτι δια πολλων θλιψεων δει ημασ εισελθειν εισ την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","χειροτονησαντεσ δε αυτοισ πρεσβυτερουσ κατ εκκλησιαν προσευξαμενοι μετα νηστειων παρεθεντο αυτουσ τω κυριω εισ ον πεπιστευκεισαν ");
INSERT INTO grcmt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","και διελθοντεσ την πισιδιαν ηλθον εισ παμφυλιαν ");
INSERT INTO grcmt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","και λαλησαντεσ εν περγη τον λογον κατεβησαν εισ ατταλειαν ");
INSERT INTO grcmt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","κακειθεν απεπλευσαν εισ αντιοχειαν οθεν ησαν παραδεδομενοι τη χαριτι του θεου εισ το εργον ο επληρωσαν ");
INSERT INTO grcmt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","παραγενομενοι δε και συναγαγοντεσ την εκκλησιαν ανηγγειλαν οσα εποιησεν ο θεοσ μετ αυτων και οτι ηνοιξεν τοισ εθνεσιν θυραν πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","διετριβον δε εκει χρονον ουκ ολιγον συν τοισ μαθηταισ ");
INSERT INTO grcmt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","και τινεσ κατελθοντεσ απο τησ ιουδαιασ εδιδασκον τουσ αδελφουσ οτι εαν μη περιτεμνησθε τω εθει μωυσεωσ ου δυνασθε σωθηναι ");
INSERT INTO grcmt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","γενομενησ ουν στασεωσ και ζητησεωσ ουκ ολιγησ τω παυλω και τω βαρναβα προσ αυτουσ εταξαν αναβαινειν παυλον και βαρναβαν και τινασ αλλουσ εξ αυτων προσ τουσ αποστολουσ και πρεσβυτερουσ εισ ιερουσαλημ περι του ζητηματοσ τουτου ");
INSERT INTO grcmt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","οι μεν ουν προπεμφθεντεσ υπο τησ εκκλησιασ διηρχοντο την φοινικην και σαμαρειαν εκδιηγουμενοι την επιστροφην των εθνων και εποιουν χαραν μεγαλην πασιν τοισ αδελφοισ ");
INSERT INTO grcmt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","παραγενομενοι δε εισ ιερουσαλημ απεδεχθησαν υπο τησ εκκλησιασ και των αποστολων και των πρεσβυτερων ανηγγειλαν τε οσα ο θεοσ εποιησεν μετ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","εξανεστησαν δε τινεσ των απο τησ αιρεσεωσ των φαρισαιων πεπιστευκοτεσ λεγοντεσ οτι δει περιτεμνειν αυτουσ παραγγελλειν τε τηρειν τον νομον μωυσεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","συνηχθησαν δε οι αποστολοι και οι πρεσβυτεροι ιδειν περι του λογου τουτου ");
INSERT INTO grcmt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","πολλησ δε συζητησεωσ γενομενησ αναστασ πετροσ ειπεν προσ αυτουσ ανδρεσ αδελφοι υμεισ επιστασθε οτι αφ ημερων αρχαιων ο θεοσ εν ημιν εξελεξατο δια του στοματοσ μου ακουσαι τα εθνη τον λογον του ευαγγελιου και πιστευσαι ");
INSERT INTO grcmt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","και ο καρδιογνωστησ θεοσ εμαρτυρησεν αυτοισ δουσ αυτοισ το πνευμα το αγιον καθωσ και ημιν ");
INSERT INTO grcmt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","και ουδεν διεκρινεν μεταξυ ημων τε και αυτων τη πιστει καθαρισασ τασ καρδιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","νυν ουν τι πειραζετε τον θεον επιθειναι ζυγον επι τον τραχηλον των μαθητων ον ουτε οι πατερεσ ημων ουτε ημεισ ισχυσαμεν βαστασαι ");
INSERT INTO grcmt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","αλλα δια τησ χαριτοσ του κυριου ιησου πιστευομεν σωθηναι καθ ον τροπον κακεινοι ");
INSERT INTO grcmt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","εσιγησεν δε παν το πληθοσ και ηκουον βαρναβα και παυλου εξηγουμενων οσα εποιησεν ο θεοσ σημεια και τερατα εν τοισ εθνεσιν δι αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","μετα δε το σιγησαι αυτουσ απεκριθη ιακωβοσ λεγων ανδρεσ αδελφοι ακουσατε μου ");
INSERT INTO grcmt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","συμεων εξηγησατο καθωσ πρωτον ο θεοσ επεσκεψατο λαβειν εξ εθνων λαον επι τω ονοματι αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","και τουτω συμφωνουσιν οι λογοι των προφητων καθωσ γεγραπται ");
INSERT INTO grcmt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","μετα ταυτα αναστρεψω και ανοικοδομησω την σκηνην δαυιδ την πεπτωκυιαν και τα κατεσκαμμενα αυτησ ανοικοδομησω και ανορθωσω αυτην ");
INSERT INTO grcmt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","οπωσ αν εκζητησωσιν οι καταλοιποι των ανθρωπων τον κυριον και παντα τα εθνη εφ ουσ επικεκληται το ονομα μου επ αυτουσ λεγει κυριοσ ο ποιων ταυτα παντα ");
INSERT INTO grcmt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","γνωστα απ αιωνοσ εστιν τω θεω παντα τα εργα αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","διο εγω κρινω μη παρενοχλειν τοισ απο των εθνων επιστρεφουσιν επι τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","αλλα επιστειλαι αυτοισ του απεχεσθαι απο των αλισγηματων των ειδωλων και τησ πορνειασ και του πνικτου και του αιματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","μωυσησ γαρ εκ γενεων αρχαιων κατα πολιν τουσ κηρυσσοντασ αυτον εχει εν ταισ συναγωγαισ κατα παν σαββατον αναγινωσκομενοσ ");
INSERT INTO grcmt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","τοτε εδοξεν τοισ αποστολοισ και τοισ πρεσβυτεροισ συν ολη τη εκκλησια εκλεξαμενουσ ανδρασ εξ αυτων πεμψαι εισ αντιοχειαν συν παυλω και βαρναβα ιουδαν τον επικαλουμενον βαρσαββαν και σιλαν ανδρασ ηγουμενουσ εν τοισ αδελφοισ ");
INSERT INTO grcmt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","γραψαντεσ δια χειροσ αυτων ταδε οι αποστολοι και οι πρεσβυτεροι και οι αδελφοι τοισ κατα την αντιοχειαν και συριαν και κιλικιαν αδελφοισ τοισ εξ εθνων χαιρειν ");
INSERT INTO grcmt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","επειδη ηκουσαμεν οτι τινεσ εξ ημων εξελθοντεσ εταραξαν υμασ λογοισ ανασκευαζοντεσ τασ ψυχασ υμων λεγοντεσ περιτεμνεσθαι και τηρειν τον νομον οισ ου διεστειλαμεθα ");
INSERT INTO grcmt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","εδοξεν ημιν γενομενοισ ομοθυμαδον εκλεξαμενουσ ανδρασ πεμψαι προσ υμασ συν τοισ αγαπητοισ ημων βαρναβα και παυλω ");
INSERT INTO grcmt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ανθρωποισ παραδεδωκοσιν τασ ψυχασ αυτων υπερ του ονοματοσ του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","απεσταλκαμεν ουν ιουδαν και σιλαν και αυτουσ δια λογου απαγγελλοντασ τα αυτα ");
INSERT INTO grcmt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","εδοξεν γαρ τω αγιω πνευματι και ημιν μηδεν πλεον επιτιθεσθαι υμιν βαροσ πλην των επαναγκεσ τουτων ");
INSERT INTO grcmt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","απεχεσθαι ειδωλοθυτων και αιματοσ και πνικτου και πορνειασ εξ ων διατηρουντεσ εαυτουσ ευ πραξετε ερρωσθε ");
INSERT INTO grcmt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","οι μεν ουν απολυθεντεσ ηλθον εισ αντιοχειαν και συναγαγοντεσ το πληθοσ επεδωκαν την επιστολην ");
INSERT INTO grcmt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","αναγνοντεσ δε εχαρησαν επι τη παρακλησει ");
INSERT INTO grcmt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ιουδασ τε και σιλασ και αυτοι προφηται οντεσ δια λογου πολλου παρεκαλεσαν τουσ αδελφουσ και επεστηριξαν ");
INSERT INTO grcmt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ποιησαντεσ δε χρονον απελυθησαν μετ ειρηνησ απο των αδελφων προσ τουσ αποστολουσ ");
INSERT INTO grcmt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35"," παυλοσ δε και βαρναβασ διετριβον εν αντιοχεια διδασκοντεσ και ευαγγελιζομενοι μετα και ετερων πολλων τον λογον του κυριου ");
INSERT INTO grcmt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","μετα δε τινασ ημερασ ειπεν παυλοσ προσ βαρναβαν επιστρεψαντεσ δη επισκεψωμεθα τουσ αδελφουσ ημων κατα πασαν πολιν εν αισ κατηγγειλαμεν τον λογον του κυριου πωσ εχουσιν ");
INSERT INTO grcmt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","βαρναβασ δε εβουλευσατο συμπαραλαβειν τον ιωαννην τον καλουμενον μαρκον ");
INSERT INTO grcmt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","παυλοσ δε ηξιου τον αποσταντα απ αυτων απο παμφυλιασ και μη συνελθοντα αυτοισ εισ το εργον μη συμπαραλαβειν τουτον ");
INSERT INTO grcmt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","εγενετο ουν παροξυσμοσ ωστε αποχωρισθηναι αυτουσ απ αλληλων τον τε βαρναβαν παραλαβοντα τον μαρκον εκπλευσαι εισ κυπρον ");
INSERT INTO grcmt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","παυλοσ δε επιλεξαμενοσ σιλαν εξηλθεν παραδοθεισ τη χαριτι του θεου υπο των αδελφων ");
INSERT INTO grcmt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","διηρχετο δε την συριαν και κιλικιαν επιστηριζων τασ εκκλησιασ ");
INSERT INTO grcmt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","κατηντησεν δε εισ δερβην και λυστραν και ιδου μαθητησ τισ ην εκει ονοματι τιμοθεοσ υιοσ γυναικοσ τινοσ ιουδαιασ πιστησ πατροσ δε ελληνοσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","οσ εμαρτυρειτο υπο των εν λυστροισ και ικονιω αδελφων ");
INSERT INTO grcmt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","τουτον ηθελησεν ο παυλοσ συν αυτω εξελθειν και λαβων περιετεμεν αυτον δια τουσ ιουδαιουσ τουσ οντασ εν τοισ τοποισ εκεινοισ ηδεισαν γαρ απαντεσ τον πατερα αυτου οτι ελλην υπηρχεν ");
INSERT INTO grcmt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ωσ δε διεπορευοντο τασ πολεισ παρεδιδουν αυτοισ φυλασσειν τα δογματα τα κεκριμενα υπο των αποστολων και των πρεσβυτερων των εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","αι μεν ουν εκκλησιαι εστερεουντο τη πιστει και επερισσευον τω αριθμω καθ ημεραν ");
INSERT INTO grcmt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","διελθοντεσ δε την φρυγιαν και την γαλατικην χωραν κωλυθεντεσ υπο του αγιου πνευματοσ λαλησαι τον λογον εν τη ασια ");
INSERT INTO grcmt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ελθοντεσ κατα την μυσιαν επειραζον κατα την βιθυνιαν πορευεσθαι και ουκ ειασεν αυτουσ το πνευμα ");
INSERT INTO grcmt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","παρελθοντεσ δε την μυσιαν κατεβησαν εισ τρωαδα ");
INSERT INTO grcmt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","και οραμα δια τησ νυκτοσ ωφθη τω παυλω ανηρ τισ ην μακεδων εστωσ παρακαλων αυτον και λεγων διαβασ εισ μακεδονιαν βοηθησον ημιν ");
INSERT INTO grcmt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ωσ δε το οραμα ειδεν ευθεωσ εζητησαμεν εξελθειν εισ την μακεδονιαν συμβιβαζοντεσ οτι προσκεκληται ημασ ο κυριοσ ευαγγελισασθαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","αναχθεντεσ ουν απο τησ τρωαδοσ ευθυδρομησαμεν εισ σαμοθρακην τη τε επιουση εισ νεαπολιν ");
INSERT INTO grcmt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","εκειθεν τε εισ φιλιππουσ ητισ εστιν πρωτη τησ μεριδοσ τησ μακεδονιασ πολισ κολωνεια ημεν δε εν αυτη τη πολει διατριβοντεσ ημερασ τινασ ");
INSERT INTO grcmt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","τη τε ημερα των σαββατων εξηλθομεν εξω τησ πολεωσ παρα ποταμον ου ενομιζετο προσευχη ειναι και καθισαντεσ ελαλουμεν ταισ συνελθουσαισ γυναιξιν ");
INSERT INTO grcmt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","και τισ γυνη ονοματι λυδια πορφυροπωλισ πολεωσ θυατειρων σεβομενη τον θεον ηκουεν ησ ο κυριοσ διηνοιξεν την καρδιαν προσεχειν τοισ λαλουμενοισ υπο του παυλου ");
INSERT INTO grcmt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ωσ δε εβαπτισθη και ο οικοσ αυτησ παρεκαλεσεν λεγουσα ει κεκρικατε με πιστην τω κυριω ειναι εισελθοντεσ εισ τον οικον μου μεινατε και παρεβιασατο ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","εγενετο δε πορευομενων ημων εισ προσευχην παιδισκην τινα εχουσαν πνευμα πυθωνοσ απαντησαι ημιν ητισ εργασιαν πολλην παρειχεν τοισ κυριοισ αυτησ μαντευομενη ");
INSERT INTO grcmt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","αυτη κατακολουθησασα τω παυλω και ημιν εκραζεν λεγουσα ουτοι οι ανθρωποι δουλοι του θεου του υψιστου εισιν οιτινεσ καταγγελλουσιν ημιν οδον σωτηριασ ");
INSERT INTO grcmt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","τουτο δε εποιει επι πολλασ ημερασ διαπονηθεισ δε ο παυλοσ και επιστρεψασ τω πνευματι ειπεν παραγγελλω σοι εν τω ονοματι ιησου χριστου εξελθειν απ αυτησ και εξηλθεν αυτη τη ωρα ");
INSERT INTO grcmt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ιδοντεσ δε οι κυριοι αυτησ οτι εξηλθεν η ελπισ τησ εργασιασ αυτων επιλαβομενοι τον παυλον και τον σιλαν ειλκυσαν εισ την αγοραν επι τουσ αρχοντασ ");
INSERT INTO grcmt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","και προσαγαγοντεσ αυτουσ τοισ στρατηγοισ ειπον ουτοι οι ανθρωποι εκταρασσουσιν ημων την πολιν ιουδαιοι υπαρχοντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","και καταγγελλουσιν εθη α ουκ εξεστιν ημιν παραδεχεσθαι ουδε ποιειν ρωμαιοισ ουσιν ");
INSERT INTO grcmt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","και συνεπεστη ο οχλοσ κατ αυτων και οι στρατηγοι περιρρηξαντεσ αυτων τα ιματια εκελευον ραβδιζειν ");
INSERT INTO grcmt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","πολλασ τε επιθεντεσ αυτοισ πληγασ εβαλον εισ φυλακην παραγγειλαντεσ τω δεσμοφυλακι ασφαλωσ τηρειν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","οσ παραγγελιαν τοιαυτην ειληφωσ εβαλεν αυτουσ εισ την εσωτεραν φυλακην και τουσ ποδασ αυτων ησφαλισατο εισ το ξυλον ");
INSERT INTO grcmt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","κατα δε το μεσονυκτιον παυλοσ και σιλασ προσευχομενοι υμνουν τον θεον επηκροωντο δε αυτων οι δεσμιοι ");
INSERT INTO grcmt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","αφνω δε σεισμοσ εγενετο μεγασ ωστε σαλευθηναι τα θεμελια του δεσμωτηριου ανεωχθησαν τε παραχρημα αι θυραι πασαι και παντων τα δεσμα ανεθη ");
INSERT INTO grcmt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","εξυπνοσ δε γενομενοσ ο δεσμοφυλαξ και ιδων ανεωγμενασ τασ θυρασ τησ φυλακησ σπασαμενοσ μαχαιραν εμελλεν εαυτον αναιρειν νομιζων εκπεφευγεναι τουσ δεσμιουσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","εφωνησεν δε φωνη μεγαλη ο παυλοσ λεγων μηδεν πραξησ σεαυτω κακον απαντεσ γαρ εσμεν ενθαδε ");
INSERT INTO grcmt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","αιτησασ δε φωτα εισεπηδησεν και εντρομοσ γενομενοσ προσεπεσεν τω παυλω και τω σιλα ");
INSERT INTO grcmt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","και προαγαγων αυτουσ εξω εφη κυριοι τι με δει ποιειν ινα σωθω ");
INSERT INTO grcmt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","οι δε ειπον πιστευσον επι τον κυριον ιησουν χριστον και σωθηση συ και ο οικοσ σου ");
INSERT INTO grcmt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","και ελαλησαν αυτω τον λογον του κυριου και πασιν τοισ εν τη οικια αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","και παραλαβων αυτουσ εν εκεινη τη ωρα τησ νυκτοσ ελουσεν απο των πληγων και εβαπτισθη αυτοσ και οι αυτου παντεσ παραχρημα ");
INSERT INTO grcmt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","αναγαγων τε αυτουσ εισ τον οικον αυτου παρεθηκεν τραπεζαν και ηγαλλιατο πανοικι πεπιστευκωσ τω θεω ");
INSERT INTO grcmt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ημερασ δε γενομενησ απεστειλαν οι στρατηγοι τουσ ραβδουχουσ λεγοντεσ απολυσον τουσ ανθρωπουσ εκεινουσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","απηγγειλεν δε ο δεσμοφυλαξ τουσ λογουσ τουτουσ προσ τον παυλον οτι απεσταλκασιν οι στρατηγοι ινα απολυθητε νυν ουν εξελθοντεσ πορευεσθε εν ειρηνη ");
INSERT INTO grcmt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ο δε παυλοσ εφη προσ αυτουσ δειραντεσ ημασ δημοσια ακατακριτουσ ανθρωπουσ ρωμαιουσ υπαρχοντασ εβαλον εισ φυλακην και νυν λαθρα ημασ εκβαλλουσιν ου γαρ αλλα ελθοντεσ αυτοι εξαγαγετωσαν ");
INSERT INTO grcmt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ανηγγειλαν δε τοισ στρατηγοισ οι ραβδουχοι τα ρηματα ταυτα και εφοβηθησαν ακουσαντεσ οτι ρωμαιοι εισιν ");
INSERT INTO grcmt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","και ελθοντεσ παρεκαλεσαν αυτουσ και εξαγαγοντεσ ηρωτων εξελθειν τησ πολεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","εξελθοντεσ δε εκ τησ φυλακησ εισηλθον προσ την λυδιαν και ιδοντεσ τουσ αδελφουσ παρεκαλεσαν αυτουσ και εξηλθον ");
INSERT INTO grcmt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","διοδευσαντεσ δε την αμφιπολιν και απολλωνιαν ηλθον εισ θεσσαλονικην οπου ην η συναγωγη των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","κατα δε το ειωθοσ τω παυλω εισηλθεν προσ αυτουσ και επι σαββατα τρια διελεξατο αυτοισ απο των γραφων ");
INSERT INTO grcmt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","διανοιγων και παρατιθεμενοσ οτι τον χριστον εδει παθειν και αναστηναι εκ νεκρων και οτι ουτοσ εστιν ο χριστοσ ιησουσ ον εγω καταγγελλω υμιν ");
INSERT INTO grcmt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","και τινεσ εξ αυτων επεισθησαν και προσεκληρωθησαν τω παυλω και τω σιλα των τε σεβομενων ελληνων πολυ πληθοσ γυναικων τε των πρωτων ουκ ολιγαι ");
INSERT INTO grcmt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","προσλαβομενοι δε οι ιουδαιοι οι απειθουντεσ των αγοραιων τινασ ανδρασ πονηρουσ και οχλοποιησαντεσ εθορυβουν την πολιν επισταντεσ τε τη οικια ιασονοσ εζητουν αυτουσ αγαγειν εισ τον δημον ");
INSERT INTO grcmt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","μη ευροντεσ δε αυτουσ εσυρον τον ιασονα και τινασ αδελφουσ επι τουσ πολιταρχασ βοωντεσ οτι οι την οικουμενην αναστατωσαντεσ ουτοι και ενθαδε παρεισιν ");
INSERT INTO grcmt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ουσ υποδεδεκται ιασων και ουτοι παντεσ απεναντι των δογματων καισαροσ πρασσουσιν βασιλεα λεγοντεσ ετερον ειναι ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","εταραξαν δε τον οχλον και τουσ πολιταρχασ ακουοντασ ταυτα ");
INSERT INTO grcmt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","και λαβοντεσ το ικανον παρα του ιασονοσ και των λοιπων απελυσαν αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","οι δε αδελφοι ευθεωσ δια τησ νυκτοσ εξεπεμψαν τον τε παυλον και τον σιλαν εισ βεροιαν οιτινεσ παραγενομενοι εισ την συναγωγην απηεσαν των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ουτοι δε ησαν ευγενεστεροι των εν θεσσαλονικη οιτινεσ εδεξαντο τον λογον μετα πασησ προθυμιασ το καθ ημεραν ανακρινοντεσ τασ γραφασ ει εχοι ταυτα ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","πολλοι μεν ουν εξ αυτων επιστευσαν και των ελληνιδων γυναικων των ευσχημονων και ανδρων ουκ ολιγοι ");
INSERT INTO grcmt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ωσ δε εγνωσαν οι απο τησ θεσσαλονικησ ιουδαιοι οτι και εν τη βεροια κατηγγελη υπο του παυλου ο λογοσ του θεου ηλθον κακει σαλευοντεσ τουσ οχλουσ ");
INSERT INTO grcmt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ευθεωσ δε τοτε τον παυλον εξαπεστειλαν οι αδελφοι πορευεσθαι ωσ επι την θαλασσαν υπεμενον δε ο τε σιλασ και ο τιμοθεοσ εκει ");
INSERT INTO grcmt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","οι δε καθιστωντεσ τον παυλον ηγαγον αυτον εωσ αθηνων και λαβοντεσ εντολην προσ τον σιλαν και τιμοθεον ινα ωσ ταχιστα ελθωσιν προσ αυτον εξηεσαν ");
INSERT INTO grcmt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","εν δε ταισ αθηναισ εκδεχομενου αυτουσ του παυλου παρωξυνετο το πνευμα αυτου εν αυτω θεωρουντι κατειδωλον ουσαν την πολιν ");
INSERT INTO grcmt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","διελεγετο μεν ουν εν τη συναγωγη τοισ ιουδαιοισ και τοισ σεβομενοισ και εν τη αγορα κατα πασαν ημεραν προσ τουσ παρατυγχανοντασ ");
INSERT INTO grcmt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","τινεσ δε και των επικουρειων και των στοικων φιλοσοφων συνεβαλλον αυτω και τινεσ ελεγον τι αν θελοι ο σπερμολογοσ ουτοσ λεγειν οι δε ξενων δαιμονιων δοκει καταγγελευσ ειναι οτι τον ιησουν και την αναστασιν ευηγγελιζετο ");
INSERT INTO grcmt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","επιλαβομενοι τε αυτου επι τον αρειον παγον ηγαγον λεγοντεσ δυναμεθα γνωναι τισ η καινη αυτη η υπο σου λαλουμενη διδαχη ");
INSERT INTO grcmt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ξενιζοντα γαρ τινα εισφερεισ εισ τασ ακοασ ημων βουλομεθα ουν γνωναι τι αν θελοι ταυτα ειναι ");
INSERT INTO grcmt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","αθηναιοι δε παντεσ και οι επιδημουντεσ ξενοι εισ ουδεν ετερον ευκαιρουν η λεγειν τι και ακουειν καινοτερον ");
INSERT INTO grcmt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","σταθεισ δε ο παυλοσ εν μεσω του αρειου παγου εφη ανδρεσ αθηναιοι κατα παντα ωσ δεισιδαιμονεστερουσ υμασ θεωρω ");
INSERT INTO grcmt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","διερχομενοσ γαρ και αναθεωρων τα σεβασματα υμων ευρον και βωμον εν ω επεγεγραπτο αγνωστω θεω ον ουν αγνοουντεσ ευσεβειτε τουτον εγω καταγγελλω υμιν ");
INSERT INTO grcmt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ο θεοσ ο ποιησασ τον κοσμον και παντα τα εν αυτω ουτοσ ουρανου και γησ κυριοσ υπαρχων ουκ εν χειροποιητοισ ναοισ κατοικει ");
INSERT INTO grcmt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ουδε υπο χειρων ανθρωπων θεραπευεται προσδεομενοσ τινοσ αυτοσ διδουσ πασιν ζωην και πνοην κατα παντα ");
INSERT INTO grcmt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","εποιησεν τε εξ ενοσ αιματοσ παν εθνοσ ανθρωπων κατοικειν επι παν το προσωπον τησ γησ ορισασ προστεταγμενουσ καιρουσ και τασ οροθεσιασ τησ κατοικιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ζητειν τον κυριον ει αρα γε ψηλαφησειαν αυτον και ευροιεν και γε ου μακραν απο ενοσ εκαστου ημων υπαρχοντα ");
INSERT INTO grcmt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","εν αυτω γαρ ζωμεν και κινουμεθα και εσμεν ωσ και τινεσ των καθ υμασ ποιητων ειρηκασιν του γαρ και γενοσ εσμεν ");
INSERT INTO grcmt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","γενοσ ουν υπαρχοντεσ του θεου ουκ οφειλομεν νομιζειν χρυσω η αργυρω η λιθω χαραγματι τεχνησ και ενθυμησεωσ ανθρωπου το θειον ειναι ομοιον ");
INSERT INTO grcmt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","τουσ μεν ουν χρονουσ τησ αγνοιασ υπεριδων ο θεοσ τα νυν παραγγελλει τοισ ανθρωποισ πασιν πανταχου μετανοειν ");
INSERT INTO grcmt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","διοτι εστησεν ημεραν εν η μελλει κρινειν την οικουμενην εν δικαιοσυνη εν ανδρι ω ωρισεν πιστιν παρασχων πασιν αναστησασ αυτον εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ακουσαντεσ δε αναστασιν νεκρων οι μεν εχλευαζον οι δε ειπον ακουσομεθα σου παλιν περι τουτου ");
INSERT INTO grcmt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","και ουτωσ ο παυλοσ εξηλθεν εκ μεσου αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","τινεσ δε ανδρεσ κολληθεντεσ αυτω επιστευσαν εν οισ και διονυσιοσ ο αρεοπαγιτησ και γυνη ονοματι δαμαρισ και ετεροι συν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","μετα δε ταυτα χωρισθεισ ο παυλοσ εκ των αθηνων ηλθεν εισ κορινθον ");
INSERT INTO grcmt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","και ευρων τινα ιουδαιον ονοματι ακυλαν ποντικον τω γενει προσφατωσ εληλυθοτα απο τησ ιταλιασ και πρισκιλλαν γυναικα αυτου δια το τεταχεναι κλαυδιον χωριζεσθαι παντασ τουσ ιουδαιουσ εκ τησ ρωμησ προσηλθεν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","και δια το ομοτεχνον ειναι εμενεν παρ αυτοισ και ειργαζετο ησαν γαρ σκηνοποιοι την τεχνην ");
INSERT INTO grcmt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","διελεγετο δε εν τη συναγωγη κατα παν σαββατον επειθεν τε ιουδαιουσ και ελληνασ ");
INSERT INTO grcmt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ωσ δε κατηλθον απο τησ μακεδονιασ ο τε σιλασ και ο τιμοθεοσ συνειχετο τω πνευματι ο παυλοσ διαμαρτυρομενοσ τοισ ιουδαιοισ τον χριστον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","αντιτασσομενων δε αυτων και βλασφημουντων εκτιναξαμενοσ τα ιματια ειπεν προσ αυτουσ το αιμα υμων επι την κεφαλην υμων καθαροσ εγω απο του νυν εισ τα εθνη πορευσομαι ");
INSERT INTO grcmt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","και μεταβασ εκειθεν ηλθεν εισ οικιαν τινοσ ονοματι ιουστου σεβομενου τον θεον ου η οικια ην συνομορουσα τη συναγωγη ");
INSERT INTO grcmt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","κρισποσ δε ο αρχισυναγωγοσ επιστευσεν τω κυριω συν ολω τω οικω αυτου και πολλοι των κορινθιων ακουοντεσ επιστευον και εβαπτιζοντο ");
INSERT INTO grcmt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ειπεν δε ο κυριοσ δι οραματοσ εν νυκτι τω παυλω μη φοβου αλλα λαλει και μη σιωπησησ ");
INSERT INTO grcmt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","διοτι εγω ειμι μετα σου και ουδεισ επιθησεται σοι του κακωσαι σε διοτι λαοσ εστιν μοι πολυσ εν τη πολει ταυτη ");
INSERT INTO grcmt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","εκαθισεν τε ενιαυτον και μηνασ εξ διδασκων εν αυτοισ τον λογον του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","γαλλιωνοσ δε ανθυπατευοντοσ τησ αχαιασ κατεπεστησαν ομοθυμαδον οι ιουδαιοι τω παυλω και ηγαγον αυτον επι το βημα ");
INSERT INTO grcmt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","λεγοντεσ οτι παρα τον νομον ουτοσ αναπειθει τουσ ανθρωπουσ σεβεσθαι τον θεον ");
INSERT INTO grcmt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","μελλοντοσ δε του παυλου ανοιγειν το στομα ειπεν ο γαλλιων προσ τουσ ιουδαιουσ ει μεν ουν ην αδικημα τι η ραδιουργημα πονηρον ω ιουδαιοι κατα λογον αν ηνεσχομην υμων ");
INSERT INTO grcmt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ει δε ζητημα εστιν περι λογου και ονοματων και νομου του καθ υμασ οψεσθε αυτοι κριτησ γαρ εγω τουτων ου βουλομαι ειναι ");
INSERT INTO grcmt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","και απηλασεν αυτουσ απο του βηματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","επιλαβομενοι δε παντεσ οι ελληνεσ σωσθενην τον αρχισυναγωγον ετυπτον εμπροσθεν του βηματοσ και ουδεν τουτων τω γαλλιωνι εμελλεν ");
INSERT INTO grcmt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ο δε παυλοσ ετι προσμεινασ ημερασ ικανασ τοισ αδελφοισ αποταξαμενοσ εξεπλει εισ την συριαν και συν αυτω πρισκιλλα και ακυλασ κειραμενοσ την κεφαλην εν κεγχρεαισ ειχεν γαρ ευχην ");
INSERT INTO grcmt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","κατηντησεν δε εισ εφεσον και εκεινουσ κατελιπεν αυτου αυτοσ δε εισελθων εισ την συναγωγην διελεχθη τοισ ιουδαιοισ ");
INSERT INTO grcmt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ερωτωντων δε αυτων επι πλειονα χρονον μειναι παρ αυτοισ ουκ επενευσεν ");
INSERT INTO grcmt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","αλλ απεταξατο αυτοισ ειπων δει με παντωσ την εορτην την ερχομενην ποιησαι εισ ιεροσολυμα παλιν δε ανακαμψω προσ υμασ του θεου θελοντοσ ανηχθη απο τησ εφεσου ");
INSERT INTO grcmt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","και κατελθων εισ καισαρειαν αναβασ και ασπασαμενοσ την εκκλησιαν κατεβη εισ αντιοχειαν ");
INSERT INTO grcmt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","και ποιησασ χρονον τινα εξηλθεν διερχομενοσ καθεξησ την γαλατικην χωραν και φρυγιαν επιστηριζων παντασ τουσ μαθητασ ");
INSERT INTO grcmt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ιουδαιοσ δε τισ απολλωσ ονοματι αλεξανδρευσ τω γενει ανηρ λογιοσ κατηντησεν εισ εφεσον δυνατοσ ων εν ταισ γραφαισ ");
INSERT INTO grcmt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ουτοσ ην κατηχημενοσ την οδον του κυριου και ζεων τω πνευματι ελαλει και εδιδασκεν ακριβωσ τα περι του κυριου επισταμενοσ μονον το βαπτισμα ιωαννου ");
INSERT INTO grcmt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ουτοσ τε ηρξατο παρρησιαζεσθαι εν τη συναγωγη ακουσαντεσ δε αυτου ακυλασ και πρισκιλλα προσελαβοντο αυτον και ακριβεστερον αυτω εξεθεντο την του θεου οδον ");
INSERT INTO grcmt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","βουλομενου δε αυτου διελθειν εισ την αχαιαν προτρεψαμενοι οι αδελφοι εγραψαν τοισ μαθηταισ αποδεξασθαι αυτον οσ παραγενομενοσ συνεβαλετο πολυ τοισ πεπιστευκοσιν δια τησ χαριτοσ ");
INSERT INTO grcmt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ευτονωσ γαρ τοισ ιουδαιοισ διακατηλεγχετο δημοσια επιδεικνυσ δια των γραφων ειναι τον χριστον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","εγενετο δε εν τω τον απολλω ειναι εν κορινθω παυλον διελθοντα τα ανωτερικα μερη ελθειν εισ εφεσον και ευρων τινασ μαθητασ ");
INSERT INTO grcmt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ειπεν προσ αυτουσ ει πνευμα αγιον ελαβετε πιστευσαντεσ οι δε ειπον προσ αυτον αλλ ουδε ει πνευμα αγιον εστιν ηκουσαμεν ");
INSERT INTO grcmt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ειπεν τε προσ αυτουσ εισ τι ουν εβαπτισθητε οι δε ειπον εισ το ιωαννου βαπτισμα ");
INSERT INTO grcmt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ειπεν δε παυλοσ ιωαννησ μεν εβαπτισεν βαπτισμα μετανοιασ τω λαω λεγων εισ τον ερχομενον μετ αυτον ινα πιστευσωσιν τουτ εστιν εισ τον χριστον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ακουσαντεσ δε εβαπτισθησαν εισ το ονομα του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","και επιθεντοσ αυτοισ του παυλου τασ χειρασ ηλθεν το πνευμα το αγιον επ αυτουσ ελαλουν τε γλωσσαισ και προεφητευον ");
INSERT INTO grcmt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ησαν δε οι παντεσ ανδρεσ ωσει δεκαδυο ");
INSERT INTO grcmt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","εισελθων δε εισ την συναγωγην επαρρησιαζετο επι μηνασ τρεισ διαλεγομενοσ και πειθων τα περι τησ βασιλειασ του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ωσ δε τινεσ εσκληρυνοντο και ηπειθουν κακολογουντεσ την οδον ενωπιον του πληθουσ αποστασ απ αυτων αφωρισεν τουσ μαθητασ καθ ημεραν διαλεγομενοσ εν τη σχολη τυραννου τινοσ ");
INSERT INTO grcmt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","τουτο δε εγενετο επι ετη δυο ωστε παντασ τουσ κατοικουντασ την ασιαν ακουσαι τον λογον του κυριου ιησου ιουδαιουσ τε και ελληνασ ");
INSERT INTO grcmt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","δυναμεισ τε ου τασ τυχουσασ εποιει ο θεοσ δια των χειρων παυλου ");
INSERT INTO grcmt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ωστε και επι τουσ ασθενουντασ επιφερεσθαι απο του χρωτοσ αυτου σουδαρια η σιμικινθια και απαλλασσεσθαι απ αυτων τασ νοσουσ τα τε πνευματα τα πονηρα εξερχεσθαι απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","επεχειρησαν δε τινεσ απο των περιερχομενων ιουδαιων εξορκιστων ονομαζειν επι τουσ εχοντασ τα πνευματα τα πονηρα το ονομα του κυριου ιησου λεγοντεσ ορκιζομεν υμασ τον ιησουν ον ο παυλοσ κηρυσσει ");
INSERT INTO grcmt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ησαν δε τινεσ υιοι σκευα ιουδαιου αρχιερεωσ επτα οι τουτο ποιουντεσ ");
INSERT INTO grcmt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","αποκριθεν δε το πνευμα το πονηρον ειπεν τον ιησουν γινωσκω και τον παυλον επισταμαι υμεισ δε τινεσ εστε ");
INSERT INTO grcmt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","και εφαλλομενοσ επ αυτουσ ο ανθρωποσ εν ω ην το πνευμα το πονηρον και κατακυριευσαν αυτων ισχυσεν κατ αυτων ωστε γυμνουσ και τετραυματισμενουσ εκφυγειν εκ του οικου εκεινου ");
INSERT INTO grcmt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","τουτο δε εγενετο γνωστον πασιν ιουδαιοισ τε και ελλησιν τοισ κατοικουσιν την εφεσον και επεπεσεν φοβοσ επι παντασ αυτουσ και εμεγαλυνετο το ονομα του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","πολλοι τε των πεπιστευκοτων ηρχοντο εξομολογουμενοι και αναγγελλοντεσ τασ πραξεισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ικανοι δε των τα περιεργα πραξαντων συνενεγκαντεσ τασ βιβλουσ κατεκαιον ενωπιον παντων και συνεψηφισαν τασ τιμασ αυτων και ευρον αργυριου μυριαδασ πεντε ");
INSERT INTO grcmt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ουτωσ κατα κρατοσ ο λογοσ του κυριου ηυξανεν και ισχυεν ");
INSERT INTO grcmt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ωσ δε επληρωθη ταυτα εθετο ο παυλοσ εν τω πνευματι διελθων την μακεδονιαν και αχαιαν πορευεσθαι εισ ιερουσαλημ ειπων οτι μετα το γενεσθαι με εκει δει με και ρωμην ιδειν ");
INSERT INTO grcmt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","αποστειλασ δε εισ την μακεδονιαν δυο των διακονουντων αυτω τιμοθεον και εραστον αυτοσ επεσχεν χρονον εισ την ασιαν ");
INSERT INTO grcmt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","εγενετο δε κατα τον καιρον εκεινον ταραχοσ ουκ ολιγοσ περι τησ οδου ");
INSERT INTO grcmt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","δημητριοσ γαρ τισ ονοματι αργυροκοποσ ποιων ναουσ αργυρουσ αρτεμιδοσ παρειχετο τοισ τεχνιταισ εργασιαν ουκ ολιγην ");
INSERT INTO grcmt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ουσ συναθροισασ και τουσ περι τα τοιαυτα εργατασ ειπεν ανδρεσ επιστασθε οτι εκ ταυτησ τησ εργασιασ η ευπορια ημων εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","και θεωρειτε και ακουετε οτι ου μονον εφεσου αλλα σχεδον πασησ τησ ασιασ ο παυλοσ ουτοσ πεισασ μετεστησεν ικανον οχλον λεγων οτι ουκ εισιν θεοι οι δια χειρων γινομενοι ");
INSERT INTO grcmt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ου μονον δε τουτο κινδυνευει ημιν το μεροσ εισ απελεγμον ελθειν αλλα και το τησ μεγαλησ θεασ ιερον αρτεμιδοσ εισ ουθεν λογισθηναι μελλειν δε και καθαιρεισθαι την μεγαλειοτητα αυτησ ην ολη η ασια και η οικουμενη σεβεται ");
INSERT INTO grcmt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ακουσαντεσ δε και γενομενοι πληρεισ θυμου εκραζον λεγοντεσ μεγαλη η αρτεμισ εφεσιων ");
INSERT INTO grcmt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","και επλησθη η πολισ ολη τησ συγχυσεωσ ωρμησαν τε ομοθυμαδον εισ το θεατρον συναρπασαντεσ γαιον και αρισταρχον μακεδονασ συνεκδημουσ παυλου ");
INSERT INTO grcmt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","του δε παυλου βουλομενου εισελθειν εισ τον δημον ουκ ειων αυτον οι μαθηται ");
INSERT INTO grcmt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","τινεσ δε και των ασιαρχων οντεσ αυτω φιλοι πεμψαντεσ προσ αυτον παρεκαλουν μη δουναι εαυτον εισ το θεατρον ");
INSERT INTO grcmt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","αλλοι μεν ουν αλλο τι εκραζον ην γαρ η εκκλησια συγκεχυμενη και οι πλειουσ ουκ ηδεισαν τινοσ ενεκεν συνεληλυθεισαν ");
INSERT INTO grcmt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","εκ δε του οχλου προεβιβασαν αλεξανδρον προβαλοντων αυτον των ιουδαιων ο δε αλεξανδροσ κατασεισασ την χειρα ηθελεν απολογεισθαι τω δημω ");
INSERT INTO grcmt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","επιγνοντεσ δε οτι ιουδαιοσ εστιν φωνη εγενετο μια εκ παντων ωσ επι ωρασ δυο κραζοντων μεγαλη η αρτεμισ εφεσιων ");
INSERT INTO grcmt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","καταστειλασ δε ο γραμματευσ τον οχλον φησιν ανδρεσ εφεσιοι τισ γαρ εστιν ανθρωποσ οσ ου γινωσκει την εφεσιων πολιν νεωκορον ουσαν τησ μεγαλησ θεασ αρτεμιδοσ και του διοπετουσ ");
INSERT INTO grcmt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","αναντιρρητων ουν οντων τουτων δεον εστιν υμασ κατεσταλμενουσ υπαρχειν και μηδεν προπετεσ πρασσειν ");
INSERT INTO grcmt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ηγαγετε γαρ τουσ ανδρασ τουτουσ ουτε ιεροσυλουσ ουτε βλασφημουντασ την θεον υμων ");
INSERT INTO grcmt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ει μεν ουν δημητριοσ και οι συν αυτω τεχνιται εχουσιν προσ τινα λογον αγοραιοι αγονται και ανθυπατοι εισιν εγκαλειτωσαν αλληλοισ ");
INSERT INTO grcmt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ει δε τι περι ετερων επιζητειτε εν τη εννομω εκκλησια επιλυθησεται ");
INSERT INTO grcmt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","και γαρ κινδυνευομεν εγκαλεισθαι στασεωσ περι τησ σημερον μηδενοσ αιτιου υπαρχοντοσ περι ου ου δυνησομεθα δουναι λογον τησ συστροφησ ταυτησ ");
INSERT INTO grcmt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","και ταυτα ειπων απελυσεν την εκκλησιαν ");
INSERT INTO grcmt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","μετα δε το παυσασθαι τον θορυβον προσκαλεσαμενοσ ο παυλοσ τουσ μαθητασ και ασπασαμενοσ εξηλθεν πορευθηναι εισ την μακεδονιαν ");
INSERT INTO grcmt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","διελθων δε τα μερη εκεινα και παρακαλεσασ αυτουσ λογω πολλω ηλθεν εισ την ελλαδα ");
INSERT INTO grcmt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ποιησασ τε μηνασ τρεισ γενομενησ αυτω επιβουλησ υπο των ιουδαιων μελλοντι αναγεσθαι εισ την συριαν εγενετο γνωμη του υποστρεφειν δια μακεδονιασ ");
INSERT INTO grcmt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","συνειπετο δε αυτω αχρι τησ ασιασ σωπατροσ βεροιαιοσ θεσσαλονικεων δε αρισταρχοσ και σεκουνδοσ και γαιοσ δερβαιοσ και τιμοθεοσ ασιανοι δε τυχικοσ και τροφιμοσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ουτοι προσελθοντεσ εμενον ημασ εν τρωαδι ");
INSERT INTO grcmt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ημεισ δε εξεπλευσαμεν μετα τασ ημερασ των αζυμων απο φιλιππων και ηλθομεν προσ αυτουσ εισ την τρωαδα αχρι ημερων πεντε ου διετριψαμεν ημερασ επτα ");
INSERT INTO grcmt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","εν δε τη μια των σαββατων συνηγμενων των μαθητων κλασαι αρτον ο παυλοσ διελεγετο αυτοισ μελλων εξιεναι τη επαυριον παρετεινεν τε τον λογον μεχρι μεσονυκτιου ");
INSERT INTO grcmt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ησαν δε λαμπαδεσ ικαναι εν τω υπερωω ου ημεν συνηγμενοι ");
INSERT INTO grcmt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","καθημενοσ δε τισ νεανιασ ονοματι ευτυχοσ επι τησ θυριδοσ καταφερομενοσ υπνω βαθει διαλεγομενου του παυλου επι πλειον κατενεχθεισ απο του υπνου επεσεν απο του τριστεγου κατω και ηρθη νεκροσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","καταβασ δε ο παυλοσ επεπεσεν αυτω και συμπεριλαβων ειπεν μη θορυβεισθε η γαρ ψυχη αυτου εν αυτω εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","αναβασ δε και κλασασ αρτον και γευσαμενοσ εφ ικανον τε ομιλησασ αχρι αυγησ ουτωσ εξηλθεν ");
INSERT INTO grcmt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ηγαγον δε τον παιδα ζωντα και παρεκληθησαν ου μετριωσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ημεισ δε προσελθοντεσ επι το πλοιον ανηχθημεν εισ την ασσον εκειθεν μελλοντεσ αναλαμβανειν τον παυλον ουτωσ γαρ ην διατεταγμενοσ μελλων αυτοσ πεζευειν ");
INSERT INTO grcmt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ωσ δε συνεβαλεν ημιν εισ την ασσον αναλαβοντεσ αυτον ηλθομεν εισ μιτυληνην ");
INSERT INTO grcmt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","κακειθεν αποπλευσαντεσ τη επιουση κατηντησαμεν αντικρυ χιου τη δε ετερα παρεβαλομεν εισ σαμον και μειναντεσ εν τρωγυλλιω τη εχομενη ηλθομεν εισ μιλητον ");
INSERT INTO grcmt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","εκρινεν γαρ ο παυλοσ παραπλευσαι την εφεσον οπωσ μη γενηται αυτω χρονοτριβησαι εν τη ασια εσπευδεν γαρ ει δυνατον ην αυτω την ημεραν τησ πεντηκοστησ γενεσθαι εισ ιεροσολυμα ");
INSERT INTO grcmt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","απο δε τησ μιλητου πεμψασ εισ εφεσον μετεκαλεσατο τουσ πρεσβυτερουσ τησ εκκλησιασ ");
INSERT INTO grcmt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ωσ δε παρεγενοντο προσ αυτον ειπεν αυτοισ υμεισ επιστασθε απο πρωτησ ημερασ αφ ησ επεβην εισ την ασιαν πωσ μεθ υμων τον παντα χρονον εγενομην ");
INSERT INTO grcmt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","δουλευων τω κυριω μετα πασησ ταπεινοφροσυνησ και πολλων δακρυων και πειρασμων των συμβαντων μοι εν ταισ επιβουλαισ των ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ωσ ουδεν υπεστειλαμην των συμφεροντων του μη αναγγειλαι υμιν και διδαξαι υμασ δημοσια και κατ οικουσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","διαμαρτυρομενοσ ιουδαιοισ τε και ελλησιν την εισ τον θεον μετανοιαν και πιστιν την εισ τον κυριον ημων ιησουν ");
INSERT INTO grcmt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","και νυν ιδου εγω δεδεμενοσ τω πνευματι πορευομαι εισ ιερουσαλημ τα εν αυτη συναντησοντα μοι μη ειδωσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","πλην οτι το πνευμα το αγιον κατα πολιν διαμαρτυρεται λεγον οτι δεσμα με και θλιψεισ μενουσιν ");
INSERT INTO grcmt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","αλλ ουδενοσ λογον ποιουμαι ουδε εχω την ψυχην μου τιμιαν εμαυτω ωσ τελειωσαι τον δρομον μου μετα χαρασ και την διακονιαν ην ελαβον παρα του κυριου ιησου διαμαρτυρασθαι το ευαγγελιον τησ χαριτοσ του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","και νυν ιδου εγω οιδα οτι ουκετι οψεσθε το προσωπον μου υμεισ παντεσ εν οισ διηλθον κηρυσσων την βασιλειαν του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","διοτι μαρτυρομαι υμιν εν τη σημερον ημερα οτι καθαροσ εγω απο του αιματοσ παντων ");
INSERT INTO grcmt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ου γαρ υπεστειλαμην του μη αναγγειλαι υμιν πασαν την βουλην του θεου ");
INSERT INTO grcmt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","προσεχετε ουν εαυτοισ και παντι τω ποιμνιω εν ω υμασ το πνευμα το αγιον εθετο επισκοπουσ ποιμαινειν την εκκλησιαν του κυριου και θεου ην περιεποιησατο δια του ιδιου αιματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","εγω γαρ οιδα τουτο οτι εισελευσονται μετα την αφιξιν μου λυκοι βαρεισ εισ υμασ μη φειδομενοι του ποιμνιου ");
INSERT INTO grcmt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","και εξ υμων αυτων αναστησονται ανδρεσ λαλουντεσ διεστραμμενα του αποσπαν τουσ μαθητασ οπισω αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","διο γρηγορειτε μνημονευοντεσ οτι τριετιαν νυκτα και ημεραν ουκ επαυσαμην μετα δακρυων νουθετων ενα εκαστον ");
INSERT INTO grcmt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","και τα νυν παρατιθεμαι υμασ αδελφοι τω θεω και τω λογω τησ χαριτοσ αυτου τω δυναμενω εποικοδομησαι και δουναι υμιν κληρονομιαν εν τοισ ηγιασμενοισ πασιν ");
INSERT INTO grcmt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","αργυριου η χρυσιου η ιματισμου ουδενοσ επεθυμησα ");
INSERT INTO grcmt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","αυτοι γινωσκετε οτι ταισ χρειαισ μου και τοισ ουσιν μετ εμου υπηρετησαν αι χειρεσ αυται ");
INSERT INTO grcmt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","παντα υπεδειξα υμιν οτι ουτωσ κοπιωντασ δει αντιλαμβανεσθαι των ασθενουντων μνημονευειν τε των λογων του κυριου ιησου οτι αυτοσ ειπεν μακαριον εστιν μαλλον διδοναι η λαμβανειν ");
INSERT INTO grcmt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","και ταυτα ειπων θεισ τα γονατα αυτου συν πασιν αυτοισ προσηυξατο ");
INSERT INTO grcmt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ικανοσ δε εγενετο κλαυθμοσ παντων και επιπεσοντεσ επι τον τραχηλον του παυλου κατεφιλουν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","οδυνωμενοι μαλιστα επι τω λογω ω ειρηκει οτι ουκετι μελλουσιν το προσωπον αυτου θεωρειν προεπεμπον δε αυτον εισ το πλοιον ");
INSERT INTO grcmt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ωσ δε εγενετο αναχθηναι ημασ αποσπασθεντασ απ αυτων ευθυδρομησαντεσ ηλθομεν εισ την κων τη δε εξησ εισ την ροδον κακειθεν εισ παταρα ");
INSERT INTO grcmt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","και ευροντεσ πλοιον διαπερων εισ φοινικην επιβαντεσ ανηχθημεν ");
INSERT INTO grcmt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","αναφανεντεσ δε την κυπρον και καταλιποντεσ αυτην ευωνυμον επλεομεν εισ συριαν και κατηχθημεν εισ τυρον εκεισε γαρ ην το πλοιον αποφορτιζομενον τον γομον ");
INSERT INTO grcmt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","και ανευροντεσ μαθητασ επεμειναμεν αυτου ημερασ επτα οιτινεσ τω παυλω ελεγον δια του πνευματοσ μη αναβαινειν εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","οτε δε εγενετο ημασ εξαρτισαι τασ ημερασ εξελθοντεσ επορευομεθα προπεμποντων ημασ παντων συν γυναιξιν και τεκνοισ εωσ εξω τησ πολεωσ και θεντεσ τα γονατα επι τον αιγιαλον προσηυξαμεθα ");
INSERT INTO grcmt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","και ασπασαμενοι αλληλουσ επεβημεν εισ το πλοιον εκεινοι δε υπεστρεψαν εισ τα ιδια ");
INSERT INTO grcmt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ημεισ δε τον πλουν διανυσαντεσ απο τυρου κατηντησαμεν εισ πτολεμαιδα και ασπασαμενοι τουσ αδελφουσ εμειναμεν ημεραν μιαν παρ αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","τη δε επαυριον εξελθοντεσ οι περι τον παυλον ηλθον εισ καισαρειαν και εισελθοντεσ εισ τον οικον φιλιππου του ευαγγελιστου οντοσ εκ των επτα εμειναμεν παρ αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","τουτω δε ησαν θυγατερεσ παρθενοι τεσσαρεσ προφητευουσαι ");
INSERT INTO grcmt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","επιμενοντων δε ημων ημερασ πλειουσ κατηλθεν τισ απο τησ ιουδαιασ προφητησ ονοματι αγαβοσ ");
INSERT INTO grcmt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","και ελθων προσ ημασ και αρασ την ζωνην του παυλου δησασ τε αυτου τουσ ποδασ και τασ χειρασ ειπεν ταδε λεγει το πνευμα το αγιον τον ανδρα ου εστιν η ζωνη αυτη ουτωσ δησουσιν εν ιερουσαλημ οι ιουδαιοι και παραδωσουσιν εισ χειρασ εθνων ");
INSERT INTO grcmt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ωσ δε ηκουσαμεν ταυτα παρεκαλουμεν ημεισ τε και οι εντοπιοι του μη αναβαινειν αυτον εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","απεκριθη τε ο παυλοσ τι ποιειτε κλαιοντεσ και συνθρυπτοντεσ μου την καρδιαν εγω γαρ ου μονον δεθηναι αλλα και αποθανειν εισ ιερουσαλημ ετοιμωσ εχω υπερ του ονοματοσ του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","μη πειθομενου δε αυτου ησυχασαμεν ειποντεσ το θελημα του κυριου γενεσθω ");
INSERT INTO grcmt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","μετα δε τασ ημερασ ταυτασ επισκευασαμενοι ανεβαινομεν εισ ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","συνηλθον δε και των μαθητων απο καισαρειασ συν ημιν αγοντεσ παρ ω ξενισθωμεν μνασωνι τινι κυπριω αρχαιω μαθητη ");
INSERT INTO grcmt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","γενομενων δε ημων εισ ιεροσολυμα ασμενωσ εδεξαντο ημασ οι αδελφοι ");
INSERT INTO grcmt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","τη δε επιουση εισηει ο παυλοσ συν ημιν προσ ιακωβον παντεσ τε παρεγενοντο οι πρεσβυτεροι ");
INSERT INTO grcmt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","και ασπασαμενοσ αυτουσ εξηγειτο καθ εν εκαστον ων εποιησεν ο θεοσ εν τοισ εθνεσιν δια τησ διακονιασ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","οι δε ακουσαντεσ εδοξαζον τον κυριον ειποντεσ αυτω θεωρεισ αδελφε ποσαι μυριαδεσ εισιν ιουδαιων των πεπιστευκοτων και παντεσ ζηλωται του νομου υπαρχουσιν ");
INSERT INTO grcmt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","κατηχηθησαν δε περι σου οτι αποστασιαν διδασκεισ απο μωυσεωσ τουσ κατα τα εθνη παντασ ιουδαιουσ λεγων μη περιτεμνειν αυτουσ τα τεκνα μηδε τοισ εθεσιν περιπατειν ");
INSERT INTO grcmt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","τι ουν εστιν παντωσ δει πληθοσ συνελθειν ακουσονται γαρ οτι εληλυθασ ");
INSERT INTO grcmt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","τουτο ουν ποιησον ο σοι λεγομεν εισιν ημιν ανδρεσ τεσσαρεσ ευχην εχοντεσ εφ εαυτων ");
INSERT INTO grcmt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","τουτουσ παραλαβων αγνισθητι συν αυτοισ και δαπανησον επ αυτοισ ινα ξυρησωνται την κεφαλην και γνωσιν παντεσ οτι ων κατηχηνται περι σου ουδεν εστιν αλλα στοιχεισ και αυτοσ τον νομον φυλασσων ");
INSERT INTO grcmt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","περι δε των πεπιστευκοτων εθνων ημεισ επεστειλαμεν κριναντεσ μηδεν τοιουτον τηρειν αυτουσ ει μη φυλασσεσθαι αυτουσ το τε ειδωλοθυτον και το αιμα και πνικτον και πορνειαν ");
INSERT INTO grcmt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","τοτε ο παυλοσ παραλαβων τουσ ανδρασ τη εχομενη ημερα συν αυτοισ αγνισθεισ εισηει εισ το ιερον διαγγελλων την εκπληρωσιν των ημερων του αγνισμου εωσ ου προσηνεχθη υπερ ενοσ εκαστου αυτων η προσφορα ");
INSERT INTO grcmt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ωσ δε εμελλον αι επτα ημεραι συντελεισθαι οι απο τησ ασιασ ιουδαιοι θεασαμενοι αυτον εν τω ιερω συνεχεον παντα τον οχλον και επεβαλον τασ χειρασ επ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","κραζοντεσ ανδρεσ ισραηλιται βοηθειτε ουτοσ εστιν ο ανθρωποσ ο κατα του λαου και του νομου και του τοπου τουτου παντασ πανταχου διδασκων ετι τε και ελληνασ εισηγαγεν εισ το ιερον και κεκοινωκεν τον αγιον τοπον τουτον ");
INSERT INTO grcmt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ησαν γαρ εωρακοτεσ τροφιμον τον εφεσιον εν τη πολει συν αυτω ον ενομιζον οτι εισ το ιερον εισηγαγεν ο παυλοσ ");
INSERT INTO grcmt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","εκινηθη τε η πολισ ολη και εγενετο συνδρομη του λαου και επιλαβομενοι του παυλου ειλκον αυτον εξω του ιερου και ευθεωσ εκλεισθησαν αι θυραι ");
INSERT INTO grcmt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ζητουντων δε αυτον αποκτειναι ανεβη φασισ τω χιλιαρχω τησ σπειρησ οτι ολη συγκεχυται ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","οσ εξαυτησ παραλαβων στρατιωτασ και εκατονταρχουσ κατεδραμεν επ αυτουσ οι δε ιδοντεσ τον χιλιαρχον και τουσ στρατιωτασ επαυσαντο τυπτοντεσ τον παυλον ");
INSERT INTO grcmt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","εγγισασ δε ο χιλιαρχοσ επελαβετο αυτου και εκελευσεν δεθηναι αλυσεσιν δυσιν και επυνθανετο τισ αν ειη και τι εστιν πεποιηκωσ ");
INSERT INTO grcmt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","αλλοι δε αλλο τι εβοων εν τω οχλω μη δυναμενοσ δε γνωναι το ασφαλεσ δια τον θορυβον εκελευσεν αγεσθαι αυτον εισ την παρεμβολην ");
INSERT INTO grcmt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","οτε δε εγενετο επι τουσ αναβαθμουσ συνεβη βασταζεσθαι αυτον υπο των στρατιωτων δια την βιαν του οχλου ");
INSERT INTO grcmt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ηκολουθει γαρ το πληθοσ του λαου κραζον αιρε αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","μελλων τε εισαγεσθαι εισ την παρεμβολην ο παυλοσ λεγει τω χιλιαρχω ει εξεστιν μοι ειπειν προσ σε ο δε εφη ελληνιστι γινωσκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ουκ αρα συ ει ο αιγυπτιοσ ο προ τουτων των ημερων αναστατωσασ και εξαγαγων εισ την ερημον τουσ τετρακισχιλιουσ ανδρασ των σικαριων ");
INSERT INTO grcmt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ειπεν δε ο παυλοσ εγω ανθρωποσ μεν ειμι ιουδαιοσ ταρσευσ τησ κιλικιασ ουκ ασημου πολεωσ πολιτησ δεομαι δε σου επιτρεψον μοι λαλησαι προσ τον λαον ");
INSERT INTO grcmt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","επιτρεψαντοσ δε αυτου ο παυλοσ εστωσ επι των αναβαθμων κατεσεισεν τη χειρι τω λαω πολλησ δε σιγησ γενομενησ προσεφωνει τη εβραιδι διαλεκτω λεγων ");
INSERT INTO grcmt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ανδρεσ αδελφοι και πατερεσ ακουσατε μου τησ προσ υμασ νυνι απολογιασ ");
INSERT INTO grcmt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ακουσαντεσ δε οτι τη εβραιδι διαλεκτω προσεφωνει αυτοισ μαλλον παρεσχον ησυχιαν και φησιν ");
INSERT INTO grcmt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","εγω μεν ειμι ανηρ ιουδαιοσ γεγεννημενοσ εν ταρσω τησ κιλικιασ ανατεθραμμενοσ δε εν τη πολει ταυτη παρα τουσ ποδασ γαμαλιηλ πεπαιδευμενοσ κατα ακριβειαν του πατρωου νομου ζηλωτησ υπαρχων του θεου καθωσ παντεσ υμεισ εστε σημερον ");
INSERT INTO grcmt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","οσ ταυτην την οδον εδιωξα αχρι θανατου δεσμευων και παραδιδουσ εισ φυλακασ ανδρασ τε και γυναικασ ");
INSERT INTO grcmt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ωσ και ο αρχιερευσ μαρτυρει μοι και παν το πρεσβυτεριον παρ ων και επιστολασ δεξαμενοσ προσ τουσ αδελφουσ εισ δαμασκον επορευομην αξων και τουσ εκεισε οντασ δεδεμενουσ εισ ιερουσαλημ ινα τιμωρηθωσιν ");
INSERT INTO grcmt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","εγενετο δε μοι πορευομενω και εγγιζοντι τη δαμασκω περι μεσημβριαν εξαιφνησ εκ του ουρανου περιαστραψαι φωσ ικανον περι εμε ");
INSERT INTO grcmt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","επεσα τε εισ το εδαφοσ και ηκουσα φωνησ λεγουσησ μοι σαουλ σαουλ τι με διωκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","εγω δε απεκριθην τισ ει κυριε ειπεν τε προσ με εγω ειμι ιησουσ ο ναζωραιοσ ον συ διωκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","οι δε συν εμοι οντεσ το μεν φωσ εθεασαντο και εμφοβοι εγενοντο την δε φωνην ουκ ηκουσαν του λαλουντοσ μοι ");
INSERT INTO grcmt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ειπον δε τι ποιησω κυριε ο δε κυριοσ ειπεν προσ με αναστασ πορευου εισ δαμασκον κακει σοι λαληθησεται περι παντων ων τετακται σοι ποιησαι ");
INSERT INTO grcmt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ωσ δε ουκ ενεβλεπον απο τησ δοξησ του φωτοσ εκεινου χειραγωγουμενοσ υπο των συνοντων μοι ηλθον εισ δαμασκον ");
INSERT INTO grcmt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ανανιασ δε τισ ανηρ ευσεβησ κατα τον νομον μαρτυρουμενοσ υπο παντων των κατοικουντων ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ελθων προσ με και επιστασ ειπεν μοι σαουλ αδελφε αναβλεψον καγω αυτη τη ωρα ανεβλεψα εισ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ο δε ειπεν ο θεοσ των πατερων ημων προεχειρισατο σε γνωναι το θελημα αυτου και ιδειν τον δικαιον και ακουσαι φωνην εκ του στοματοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","οτι εση μαρτυσ αυτω προσ παντασ ανθρωπουσ ων εωρακασ και ηκουσασ ");
INSERT INTO grcmt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","και νυν τι μελλεισ αναστασ βαπτισαι και απολουσαι τασ αμαρτιασ σου επικαλεσαμενοσ το ονομα του κυριου ");
INSERT INTO grcmt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","εγενετο δε μοι υποστρεψαντι εισ ιερουσαλημ και προσευχομενου μου εν τω ιερω γενεσθαι με εν εκστασει ");
INSERT INTO grcmt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","και ιδειν αυτον λεγοντα μοι σπευσον και εξελθε εν ταχει εξ ιερουσαλημ διοτι ου παραδεξονται σου την μαρτυριαν περι εμου ");
INSERT INTO grcmt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","καγω ειπον κυριε αυτοι επιστανται οτι εγω ημην φυλακιζων και δερων κατα τασ συναγωγασ τουσ πιστευοντασ επι σε ");
INSERT INTO grcmt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","και οτε εξεχειτο το αιμα στεφανου του μαρτυροσ σου και αυτοσ ημην εφεστωσ και συνευδοκων τη αναιρεσει αυτου φυλασσων τα ιματια των αναιρουντων αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","και ειπεν προσ με πορευου οτι εγω εισ εθνη μακραν εξαποστελω σε ");
INSERT INTO grcmt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ηκουον δε αυτου αχρι τουτου του λογου και επηραν την φωνην αυτων λεγοντεσ αιρε απο τησ γησ τον τοιουτον ου γαρ καθηκεν αυτον ζην ");
INSERT INTO grcmt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","κραζοντων δε αυτων και ριπτουντων τα ιματια και κονιορτον βαλλοντων εισ τον αερα ");
INSERT INTO grcmt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","εκελευσεν αυτον ο χιλιαρχοσ αγεσθαι εισ την παρεμβολην ειπων μαστιξιν ανεταζεσθαι αυτον ινα επιγνω δι ην αιτιαν ουτωσ επεφωνουν αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ωσ δε προετεινεν αυτον τοισ ιμασιν ειπεν προσ τον εστωτα εκατονταρχον ο παυλοσ ει ανθρωπον ρωμαιον και ακατακριτον εξεστιν υμιν μαστιζειν ");
INSERT INTO grcmt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ακουσασ δε ο εκατονταρχοσ προσελθων απηγγειλεν τω χιλιαρχω λεγων ορα τι μελλεισ ποιειν ο γαρ ανθρωποσ ουτοσ ρωμαιοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","προσελθων δε ο χιλιαρχοσ ειπεν αυτω λεγε μοι ει συ ρωμαιοσ ει ο δε εφη ναι ");
INSERT INTO grcmt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","απεκριθη τε ο χιλιαρχοσ εγω πολλου κεφαλαιου την πολιτειαν ταυτην εκτησαμην ο δε παυλοσ εφη εγω δε και γεγεννημαι ");
INSERT INTO grcmt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ευθεωσ ουν απεστησαν απ αυτου οι μελλοντεσ αυτον ανεταζειν και ο χιλιαρχοσ δε εφοβηθη επιγνουσ οτι ρωμαιοσ εστιν και οτι ην αυτον δεδεκωσ ");
INSERT INTO grcmt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","τη δε επαυριον βουλομενοσ γνωναι το ασφαλεσ το τι κατηγορειται παρα των ιουδαιων ελυσεν αυτον απο των δεσμων και εκελευσεν ελθειν τουσ αρχιερεισ και ολον το συνεδριον αυτων και καταγαγων τον παυλον εστησεν εισ αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ατενισασ δε ο παυλοσ τω συνεδριω ειπεν ανδρεσ αδελφοι εγω παση συνειδησει αγαθη πεπολιτευμαι τω θεω αχρι ταυτησ τησ ημερασ ");
INSERT INTO grcmt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ο δε αρχιερευσ ανανιασ επεταξεν τοισ παρεστωσιν αυτω τυπτειν αυτου το στομα ");
INSERT INTO grcmt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","τοτε ο παυλοσ προσ αυτον ειπεν τυπτειν σε μελλει ο θεοσ τοιχε κεκονιαμενε και συ καθη κρινων με κατα τον νομον και παρανομων κελευεισ με τυπτεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","οι δε παρεστωτεσ ειπον τον αρχιερεα του θεου λοιδορεισ ");
INSERT INTO grcmt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","εφη τε ο παυλοσ ουκ ηδειν αδελφοι οτι εστιν αρχιερευσ γεγραπται γαρ αρχοντα του λαου σου ουκ ερεισ κακωσ ");
INSERT INTO grcmt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","γνουσ δε ο παυλοσ οτι το εν μεροσ εστιν σαδδουκαιων το δε ετερον φαρισαιων εκραξεν εν τω συνεδριω ανδρεσ αδελφοι εγω φαρισαιοσ ειμι υιοσ φαρισαιου περι ελπιδοσ και αναστασεωσ νεκρων εγω κρινομαι ");
INSERT INTO grcmt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","τουτο δε αυτου λαλησαντοσ εγενετο στασισ των φαρισαιων και εσχισθη το πληθοσ ");
INSERT INTO grcmt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","σαδδουκαιοι μεν γαρ λεγουσιν μη ειναι αναστασιν μηδε αγγελον μητε πνευμα φαρισαιοι δε ομολογουσιν τα αμφοτερα ");
INSERT INTO grcmt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","εγενετο δε κραυγη μεγαλη και ανασταντεσ οι γραμματεισ του μερουσ των φαρισαιων διεμαχοντο λεγοντεσ ουδεν κακον ευρισκομεν εν τω ανθρωπω τουτω ει δε πνευμα ελαλησεν αυτω η αγγελοσ μη θεομαχωμεν ");
INSERT INTO grcmt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","πολλησ δε γενομενησ στασεωσ ευλαβηθεισ ο χιλιαρχοσ μη διασπασθη ο παυλοσ υπ αυτων εκελευσεν το στρατευμα καταβηναι και αρπασαι αυτον εκ μεσου αυτων αγειν τε εισ την παρεμβολην ");
INSERT INTO grcmt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","τη δε επιουση νυκτι επιστασ αυτω ο κυριοσ ειπεν θαρσει παυλε ωσ γαρ διεμαρτυρω τα περι εμου εισ ιερουσαλημ ουτωσ σε δει και εισ ρωμην μαρτυρησαι ");
INSERT INTO grcmt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","γενομενησ δε ημερασ ποιησαντεσ τινεσ των ιουδαιων συστροφην ανεθεματισαν εαυτουσ λεγοντεσ μητε φαγειν μητε πιειν εωσ ου αποκτεινωσιν τον παυλον ");
INSERT INTO grcmt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ησαν δε πλειουσ τεσσαρακοντα οι ταυτην την συνωμοσιαν πεποιηκοτεσ ");
INSERT INTO grcmt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","οιτινεσ προσελθοντεσ τοισ αρχιερευσιν και τοισ πρεσβυτεροισ ειπον αναθεματι ανεθεματισαμεν εαυτουσ μηδενοσ γευσασθαι εωσ ου αποκτεινωμεν τον παυλον ");
INSERT INTO grcmt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","νυν ουν υμεισ εμφανισατε τω χιλιαρχω συν τω συνεδριω οπωσ αυριον αυτον καταγαγη προσ υμασ ωσ μελλοντασ διαγινωσκειν ακριβεστερον τα περι αυτου ημεισ δε προ του εγγισαι αυτον ετοιμοι εσμεν του ανελειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ακουσασ δε ο υιοσ τησ αδελφησ παυλου το ενεδρον παραγενομενοσ και εισελθων εισ την παρεμβολην απηγγειλεν τω παυλω ");
INSERT INTO grcmt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","προσκαλεσαμενοσ δε ο παυλοσ ενα των εκατονταρχων εφη τον νεανιαν τουτον απαγαγε προσ τον χιλιαρχον εχει γαρ τι απαγγειλαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ο μεν ουν παραλαβων αυτον ηγαγεν προσ τον χιλιαρχον και φησιν ο δεσμιοσ παυλοσ προσκαλεσαμενοσ με ηρωτησεν τουτον τον νεανιαν αγαγειν προσ σε εχοντα τι λαλησαι σοι ");
INSERT INTO grcmt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","επιλαβομενοσ δε τησ χειροσ αυτου ο χιλιαρχοσ και αναχωρησασ κατ ιδιαν επυνθανετο τι εστιν ο εχεισ απαγγειλαι μοι ");
INSERT INTO grcmt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ειπεν δε οτι οι ιουδαιοι συνεθεντο του ερωτησαι σε οπωσ αυριον εισ το συνεδριον καταγαγησ τον παυλον ωσ μελλοντα τι ακριβεστερον πυνθανεσθαι περι αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","συ ουν μη πεισθησ αυτοισ ενεδρευουσιν γαρ αυτον εξ αυτων ανδρεσ πλειουσ τεσσαρακοντα οιτινεσ ανεθεματισαν εαυτουσ μητε φαγειν μητε πιειν εωσ ου ανελωσιν αυτον και νυν ετοιμοι εισιν προσδεχομενοι την απο σου επαγγελιαν ");
INSERT INTO grcmt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ο μεν ουν χιλιαρχοσ απελυσεν τον νεανιαν παραγγειλασ μηδενι εκλαλησαι οτι ταυτα ενεφανισασ προσ με ");
INSERT INTO grcmt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","και προσκαλεσαμενοσ δυο τινασ των εκατονταρχων ειπεν ετοιμασατε στρατιωτασ διακοσιουσ οπωσ πορευθωσιν εωσ καισαρειασ και ιππεισ εβδομηκοντα και δεξιολαβουσ διακοσιουσ απο τριτησ ωρασ τησ νυκτοσ ");
INSERT INTO grcmt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","κτηνη τε παραστησαι ινα επιβιβασαντεσ τον παυλον διασωσωσιν προσ φηλικα τον ηγεμονα ");
INSERT INTO grcmt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","γραψασ επιστολην περιεχουσαν τον τυπον τουτον ");
INSERT INTO grcmt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","κλαυδιοσ λυσιασ τω κρατιστω ηγεμονι φηλικι χαιρειν ");
INSERT INTO grcmt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","τον ανδρα τουτον συλληφθεντα υπο των ιουδαιων και μελλοντα αναιρεισθαι υπ αυτων επιστασ συν τω στρατευματι εξειλομην αυτον μαθων οτι ρωμαιοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","βουλομενοσ δε γνωναι την αιτιαν δι ην ενεκαλουν αυτω κατηγαγον αυτον εισ το συνεδριον αυτων ");
INSERT INTO grcmt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ον ευρον εγκαλουμενον περι ζητηματων του νομου αυτων μηδεν αξιον θανατου η δεσμων εγκλημα εχοντα ");
INSERT INTO grcmt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","μηνυθεισησ δε μοι επιβουλησ εισ τον ανδρα μελλειν εσεσθαι υπο των ιουδαιων εξαυτησ επεμψα προσ σε παραγγειλασ και τοισ κατηγοροισ λεγειν τα προσ αυτον επι σου ερρωσο ");
INSERT INTO grcmt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","οι μεν ουν στρατιωται κατα το διατεταγμενον αυτοισ αναλαβοντεσ τον παυλον ηγαγον δια τησ νυκτοσ εισ την αντιπατριδα ");
INSERT INTO grcmt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","τη δε επαυριον εασαντεσ τουσ ιππεισ πορευεσθαι συν αυτω υπεστρεψαν εισ την παρεμβολην ");
INSERT INTO grcmt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","οιτινεσ εισελθοντεσ εισ την καισαρειαν και αναδοντεσ την επιστολην τω ηγεμονι παρεστησαν και τον παυλον αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","αναγνουσ δε ο ηγεμων και επερωτησασ εκ ποιασ επαρχιασ εστιν και πυθομενοσ οτι απο κιλικιασ ");
INSERT INTO grcmt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","διακουσομαι σου εφη οταν και οι κατηγοροι σου παραγενωνται εκελευσεν τε αυτον εν τω πραιτωριω ηρωδου φυλασσεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","μετα δε πεντε ημερασ κατεβη ο αρχιερευσ ανανιασ μετα των πρεσβυτερων και ρητοροσ τερτυλλου τινοσ οιτινεσ ενεφανισαν τω ηγεμονι κατα του παυλου ");
INSERT INTO grcmt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","κληθεντοσ δε αυτου ηρξατο κατηγορειν ο τερτυλλοσ λεγων πολλησ ειρηνησ τυγχανοντεσ δια σου και κατορθωματων γινομενων τω εθνει τουτω δια τησ σησ προνοιασ ");
INSERT INTO grcmt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","παντη τε και πανταχου αποδεχομεθα κρατιστε φηλιξ μετα πασησ ευχαριστιασ ");
INSERT INTO grcmt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ινα δε μη επι πλειον σε εγκοπτω παρακαλω ακουσαι σε ημων συντομωσ τη ση επιεικεια ");
INSERT INTO grcmt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ευροντεσ γαρ τον ανδρα τουτον λοιμον και κινουντα στασιν πασιν τοισ ιουδαιοισ τοισ κατα την οικουμενην πρωτοστατην τε τησ των ναζωραιων αιρεσεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","οσ και το ιερον επειρασεν βεβηλωσαι ον και εκρατησαμεν ");
INSERT INTO grcmt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8"," παρ ου δυνηση αυτοσ ανακρινασ περι παντων τουτων επιγνωναι ων ημεισ κατηγορουμεν αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","συνεπεθεντο δε και οι ιουδαιοι φασκοντεσ ταυτα ουτωσ εχειν ");
INSERT INTO grcmt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","απεκριθη δε ο παυλοσ νευσαντοσ αυτω του ηγεμονοσ λεγειν εκ πολλων ετων οντα σε κριτην τω εθνει τουτω επισταμενοσ ευθυμοτερον τα περι εμαυτου απολογουμαι ");
INSERT INTO grcmt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","δυναμενου σου γνωναι οτι ου πλειουσ εισιν μοι ημεραι δεκαδυο αφ ησ ανεβην προσκυνησων εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","και ουτε εν τω ιερω ευρον με προσ τινα διαλεγομενον η επισυστασιν ποιουντα οχλου ουτε εν ταισ συναγωγαισ ουτε κατα την πολιν ");
INSERT INTO grcmt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ουτε παραστησαι με δυνανται περι ων νυν κατηγορουσιν μου ");
INSERT INTO grcmt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ομολογω δε τουτο σοι οτι κατα την οδον ην λεγουσιν αιρεσιν ουτωσ λατρευω τω πατρωω θεω πιστευων πασιν τοισ κατα τον νομον και τοισ προφηταισ γεγραμμενοισ ");
INSERT INTO grcmt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ελπιδα εχων εισ τον θεον ην και αυτοι ουτοι προσδεχονται αναστασιν μελλειν εσεσθαι νεκρων δικαιων τε και αδικων ");
INSERT INTO grcmt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","εν τουτω δε αυτοσ ασκω απροσκοπον συνειδησιν εχων προσ τον θεον και τουσ ανθρωπουσ δια παντοσ ");
INSERT INTO grcmt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","δι ετων δε πλειονων παρεγενομην ελεημοσυνασ ποιησων εισ το εθνοσ μου και προσφορασ ");
INSERT INTO grcmt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","εν οισ ευρον με ηγνισμενον εν τω ιερω ου μετα οχλου ουδε μετα θορυβου τινεσ απο τησ ασιασ ιουδαιοι ");
INSERT INTO grcmt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ουσ δει επι σου παρειναι και κατηγορειν ει τι εχοιεν προσ με ");
INSERT INTO grcmt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","η αυτοι ουτοι ειπατωσαν τι ευρον εν εμοι αδικημα σταντοσ μου επι του συνεδριου ");
INSERT INTO grcmt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","η περι μιασ ταυτησ φωνησ ησ εκραξα εστωσ εν αυτοισ οτι περι αναστασεωσ νεκρων εγω κρινομαι σημερον υφ υμων ");
INSERT INTO grcmt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ακουσασ δε ταυτα ο φηλιξ ανεβαλετο αυτουσ ακριβεστερον ειδωσ τα περι τησ οδου ειπων οταν λυσιασ ο χιλιαρχοσ καταβη διαγνωσομαι τα καθ υμασ ");
INSERT INTO grcmt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","διαταξαμενοσ τε τω εκατονταρχη τηρεισθαι τον παυλον εχειν τε ανεσιν και μηδενα κωλυειν των ιδιων αυτου υπηρετειν η προσερχεσθαι αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","μετα δε ημερασ τινασ παραγενομενοσ ο φηλιξ συν δρουσιλλη τη γυναικι ουση ιουδαια μετεπεμψατο τον παυλον και ηκουσεν αυτου περι τησ εισ χριστον πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","διαλεγομενου δε αυτου περι δικαιοσυνησ και εγκρατειασ και του κριματοσ του μελλοντοσ εσεσθαι εμφοβοσ γενομενοσ ο φηλιξ απεκριθη το νυν εχον πορευου καιρον δε μεταλαβων μετακαλεσομαι σε ");
INSERT INTO grcmt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","αμα και ελπιζων οτι χρηματα δοθησεται αυτω υπο του παυλου οπωσ λυση αυτον διο και πυκνοτερον αυτον μεταπεμπομενοσ ωμιλει αυτω ");
INSERT INTO grcmt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","διετιασ δε πληρωθεισησ ελαβεν διαδοχον ο φηλιξ πορκιον φηστον θελων τε χαριτασ καταθεσθαι τοισ ιουδαιοισ ο φηλιξ κατελιπεν τον παυλον δεδεμενον ");
INSERT INTO grcmt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","φηστοσ ουν επιβασ τη επαρχια μετα τρεισ ημερασ ανεβη εισ ιεροσολυμα απο καισαρειασ ");
INSERT INTO grcmt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ενεφανισαν δε αυτω ο αρχιερευσ και οι πρωτοι των ιουδαιων κατα του παυλου και παρεκαλουν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","αιτουμενοι χαριν κατ αυτου οπωσ μεταπεμψηται αυτον εισ ιερουσαλημ ενεδραν ποιουντεσ ανελειν αυτον κατα την οδον ");
INSERT INTO grcmt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ο μεν ουν φηστοσ απεκριθη τηρεισθαι τον παυλον εν καισαρεια εαυτον δε μελλειν εν ταχει εκπορευεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","οι ουν δυνατοι εν υμιν φησιν συγκαταβαντεσ ει τι εστιν εν τω ανδρι τουτω κατηγορειτωσαν αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","διατριψασ δε εν αυτοισ ημερασ πλειουσ η δεκα καταβασ εισ καισαρειαν τη επαυριον καθισασ επι του βηματοσ εκελευσεν τον παυλον αχθηναι ");
INSERT INTO grcmt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","παραγενομενου δε αυτου περιεστησαν οι απο ιεροσολυμων καταβεβηκοτεσ ιουδαιοι πολλα και βαρεα αιτιωματα φεροντεσ κατα του παυλου α ουκ ισχυον αποδειξαι ");
INSERT INTO grcmt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","απολογουμενου αυτου οτι ουτε εισ τον νομον των ιουδαιων ουτε εισ το ιερον ουτε εισ καισαρα τι ημαρτον ");
INSERT INTO grcmt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ο φηστοσ δε τοισ ιουδαιοισ θελων χαριν καταθεσθαι αποκριθεισ τω παυλω ειπεν θελεισ εισ ιεροσολυμα αναβασ εκει περι τουτων κρινεσθαι επ εμου ");
INSERT INTO grcmt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ειπεν δε ο παυλοσ επι του βηματοσ καισαροσ εστωσ ειμι ου με δει κρινεσθαι ιουδαιουσ ουδεν ηδικησα ωσ και συ καλλιον επιγινωσκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ει μεν γαρ αδικω και αξιον θανατου πεπραχα τι ου παραιτουμαι το αποθανειν ει δε ουδεν εστιν ων ουτοι κατηγορουσιν μου ουδεισ με δυναται αυτοισ χαρισασθαι καισαρα επικαλουμαι ");
INSERT INTO grcmt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","τοτε ο φηστοσ συλλαλησασ μετα του συμβουλιου απεκριθη καισαρα επικεκλησαι επι καισαρα πορευση ");
INSERT INTO grcmt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ημερων δε διαγενομενων τινων αγριππασ ο βασιλευσ και βερνικη κατηντησαν εισ καισαρειαν ασπασαμενοι τον φηστον ");
INSERT INTO grcmt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ωσ δε πλειουσ ημερασ διετριβεν εκει ο φηστοσ τω βασιλει ανεθετο τα κατα τον παυλον λεγων ανηρ τισ εστιν καταλελειμμενοσ υπο φηλικοσ δεσμιοσ ");
INSERT INTO grcmt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","περι ου γενομενου μου εισ ιεροσολυμα ενεφανισαν οι αρχιερεισ και οι πρεσβυτεροι των ιουδαιων αιτουμενοι κατ αυτου δικην ");
INSERT INTO grcmt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","προσ ουσ απεκριθην οτι ουκ εστιν εθοσ ρωμαιοισ χαριζεσθαι τινα ανθρωπον εισ απωλειαν πριν η ο κατηγορουμενοσ κατα προσωπον εχοι τουσ κατηγορουσ τοπον τε απολογιασ λαβοι περι του εγκληματοσ ");
INSERT INTO grcmt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","συνελθοντων ουν αυτων ενθαδε αναβολην μηδεμιαν ποιησαμενοσ τη εξησ καθισασ επι του βηματοσ εκελευσα αχθηναι τον ανδρα ");
INSERT INTO grcmt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","περι ου σταθεντεσ οι κατηγοροι ουδεμιαν αιτιαν επεφερον ων υπενοουν εγω ");
INSERT INTO grcmt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ζητηματα δε τινα περι τησ ιδιασ δεισιδαιμονιασ ειχον προσ αυτον και περι τινοσ ιησου τεθνηκοτοσ ον εφασκεν ο παυλοσ ζην ");
INSERT INTO grcmt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","απορουμενοσ δε εγω την περι τουτου ζητησιν ελεγον ει βουλοιτο πορευεσθαι εισ ιερουσαλημ κακει κρινεσθαι περι τουτων ");
INSERT INTO grcmt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","του δε παυλου επικαλεσαμενου τηρηθηναι αυτον εισ την του σεβαστου διαγνωσιν εκελευσα τηρεισθαι αυτον εωσ ου πεμψω αυτον προσ καισαρα ");
INSERT INTO grcmt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","αγριππασ δε προσ τον φηστον εφη εβουλομην και αυτοσ του ανθρωπου ακουσαι ο δε αυριον φησιν ακουση αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","τη ουν επαυριον ελθοντοσ του αγριππα και τησ βερνικησ μετα πολλησ φαντασιασ και εισελθοντων εισ το ακροατηριον συν τε τοισ χιλιαρχοισ και ανδρασιν τοισ κατ εξοχην ουσιν τησ πολεωσ και κελευσαντοσ του φηστου ηχθη ο παυλοσ ");
INSERT INTO grcmt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","και φησιν ο φηστοσ αγριππα βασιλευ και παντεσ οι συμπαροντεσ ημιν ανδρεσ θεωρειτε τουτον περι ου παν το πληθοσ των ιουδαιων ενετυχον μοι εν τε ιεροσολυμοισ και ενθαδε επιβοωντεσ μη δειν ζην αυτον μηκετι ");
INSERT INTO grcmt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","εγω δε καταλαβομενοσ μηδεν αξιον θανατου αυτον πεπραχεναι και αυτου δε τουτου επικαλεσαμενου τον σεβαστον εκρινα πεμπειν αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","περι ου ασφαλεσ τι γραψαι τω κυριω ουκ εχω διο προηγαγον αυτον εφ υμων και μαλιστα επι σου βασιλευ αγριππα οπωσ τησ ανακρισεωσ γενομενησ σχω τι γραψαι ");
INSERT INTO grcmt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","αλογον γαρ μοι δοκει πεμποντα δεσμιον μη και τασ κατ αυτου αιτιασ σημαναι ");
INSERT INTO grcmt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","αγριππασ δε προσ τον παυλον εφη επιτρεπεται σοι υπερ σεαυτου λεγειν τοτε ο παυλοσ απελογειτο εκτεινασ την χειρα ");
INSERT INTO grcmt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","περι παντων ων εγκαλουμαι υπο ιουδαιων βασιλευ αγριππα ηγημαι εμαυτον μακαριον επι σου μελλων απολογεισθαι σημερον ");
INSERT INTO grcmt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","μαλιστα γνωστην οντα σε παντων των κατα ιουδαιουσ ηθων τε και ζητηματων διο δεομαι σου μακροθυμωσ ακουσαι μου ");
INSERT INTO grcmt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","την μεν ουν βιωσιν μου την εκ νεοτητοσ την απ αρχησ γενομενην εν τω εθνει μου εν ιεροσολυμοισ ισασιν παντεσ οι ιουδαιοι ");
INSERT INTO grcmt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","προγινωσκοντεσ με ανωθεν εαν θελωσιν μαρτυρειν οτι κατα την ακριβεστατην αιρεσιν τησ ημετερασ θρησκειασ εζησα φαρισαιοσ ");
INSERT INTO grcmt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","και νυν επ ελπιδι τησ προσ τουσ πατερασ επαγγελιασ γενομενησ υπο του θεου εστηκα κρινομενοσ ");
INSERT INTO grcmt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","εισ ην το δωδεκαφυλον ημων εν εκτενεια νυκτα και ημεραν λατρευον ελπιζει καταντησαι περι ησ ελπιδοσ εγκαλουμαι βασιλευ αγριππα υπο ιουδαιων ");
INSERT INTO grcmt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","τι απιστον κρινεται παρ υμιν ει ο θεοσ νεκρουσ εγειρει ");
INSERT INTO grcmt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","εγω μεν ουν εδοξα εμαυτω προσ το ονομα ιησου του ναζωραιου δειν πολλα εναντια πραξαι ");
INSERT INTO grcmt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ο και εποιησα εν ιεροσολυμοισ και πολλουσ των αγιων εγω φυλακαισ κατεκλεισα την παρα των αρχιερεων εξουσιαν λαβων αναιρουμενων τε αυτων κατηνεγκα ψηφον ");
INSERT INTO grcmt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","και κατα πασασ τασ συναγωγασ πολλακισ τιμωρων αυτουσ ηναγκαζον βλασφημειν περισσωσ τε εμμαινομενοσ αυτοισ εδιωκον εωσ και εισ τασ εξω πολεισ ");
INSERT INTO grcmt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","εν οισ και πορευομενοσ εισ την δαμασκον μετ εξουσιασ και επιτροπησ τησ παρα των αρχιερεων ");
INSERT INTO grcmt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ημερασ μεσησ κατα την οδον ειδον βασιλευ ουρανοθεν υπερ την λαμπροτητα του ηλιου περιλαμψαν με φωσ και τουσ συν εμοι πορευομενουσ ");
INSERT INTO grcmt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","παντων δε καταπεσοντων ημων εισ την γην ηκουσα φωνην λαλουσαν προσ με και λεγουσαν τη εβραιδι διαλεκτω σαουλ σαουλ τι με διωκεισ σκληρον σοι προσ κεντρα λακτιζειν ");
INSERT INTO grcmt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","εγω δε ειπον τισ ει κυριε ο δε ειπεν εγω ειμι ιησουσ ον συ διωκεισ ");
INSERT INTO grcmt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","αλλα αναστηθι και στηθι επι τουσ ποδασ σου εισ τουτο γαρ ωφθην σοι προχειρισασθαι σε υπηρετην και μαρτυρα ων τε ειδεσ ων τε οφθησομαι σοι ");
INSERT INTO grcmt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","εξαιρουμενοσ σε εκ του λαου και των εθνων εισ ουσ εγω σε αποστελλω ");
INSERT INTO grcmt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ανοιξαι οφθαλμουσ αυτων του υποστρεψαι απο σκοτουσ εισ φωσ και τησ εξουσιασ του σατανα επι τον θεον του λαβειν αυτουσ αφεσιν αμαρτιων και κληρον εν τοισ ηγιασμενοισ πιστει τη εισ εμε ");
INSERT INTO grcmt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","οθεν βασιλευ αγριππα ουκ εγενομην απειθησ τη ουρανιω οπτασια ");
INSERT INTO grcmt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","αλλα τοισ εν δαμασκω πρωτον και ιεροσολυμοισ εισ πασαν τε την χωραν τησ ιουδαιασ και τοισ εθνεσιν απαγγελλων μετανοειν και επιστρεφειν επι τον θεον αξια τησ μετανοιασ εργα πρασσοντασ ");
INSERT INTO grcmt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ενεκα τουτων οι ιουδαιοι με συλλαβομενοι εν τω ιερω επειρωντο διαχειρισασθαι ");
INSERT INTO grcmt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","επικουριασ ουν τυχων τησ παρα του θεου αχρι τησ ημερασ ταυτησ εστηκα μαρτυρομενοσ μικρω τε και μεγαλω ουδεν εκτοσ λεγων ων τε οι προφηται ελαλησαν μελλοντων γινεσθαι και μωυσησ ");
INSERT INTO grcmt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ει παθητοσ ο χριστοσ ει πρωτοσ εξ αναστασεωσ νεκρων φωσ μελλει καταγγελλειν τω λαω και τοισ εθνεσιν ");
INSERT INTO grcmt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ταυτα δε αυτου απολογουμενου ο φηστοσ μεγαλη τη φωνη εφη μαινη παυλε τα πολλα σε γραμματα εισ μανιαν περιτρεπει ");
INSERT INTO grcmt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ο δε ου μαινομαι φησιν κρατιστε φηστε αλλα αληθειασ και σωφροσυνησ ρηματα αποφθεγγομαι ");
INSERT INTO grcmt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","επισταται γαρ περι τουτων ο βασιλευσ προσ ον και παρρησιαζομενοσ λαλω λανθανειν γαρ αυτον τι τουτων ου πειθομαι ουδεν ου γαρ εν γωνια πεπραγμενον τουτο ");
INSERT INTO grcmt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","πιστευεισ βασιλευ αγριππα τοισ προφηταισ οιδα οτι πιστευεισ ");
INSERT INTO grcmt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ο δε αγριππασ προσ τον παυλον εφη εν ολιγω με πειθεισ χριστιανον γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ο δε παυλοσ ειπεν ευξαιμην αν τω θεω και εν ολιγω και εν πολλω ου μονον σε αλλα και παντασ τουσ ακουοντασ μου σημερον γενεσθαι τοιουτουσ οποιοσ καγω ειμι παρεκτοσ των δεσμων τουτων ");
INSERT INTO grcmt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","και ταυτα ειποντοσ αυτου ανεστη ο βασιλευσ και ο ηγεμων η τε βερνικη και οι συγκαθημενοι αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","και αναχωρησαντεσ ελαλουν προσ αλληλουσ λεγοντεσ οτι ουδεν θανατου αξιον η δεσμων πρασσει ο ανθρωποσ ουτοσ ");
INSERT INTO grcmt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","αγριππασ δε τω φηστω εφη απολελυσθαι εδυνατο ο ανθρωποσ ουτοσ ει μη επεκεκλητο καισαρα ");
INSERT INTO grcmt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ωσ δε εκριθη του αποπλειν ημασ εισ την ιταλιαν παρεδιδουν τον τε παυλον και τινασ ετερουσ δεσμωτασ εκατονταρχη ονοματι ιουλιω σπειρησ σεβαστησ ");
INSERT INTO grcmt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","επιβαντεσ δε πλοιω αδραμυττηνω μελλοντεσ πλειν τουσ κατα την ασιαν τοπουσ ανηχθημεν οντοσ συν ημιν αρισταρχου μακεδονοσ θεσσαλονικεωσ ");
INSERT INTO grcmt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","τη τε ετερα κατηχθημεν εισ σιδωνα φιλανθρωπωσ τε ο ιουλιοσ τω παυλω χρησαμενοσ επετρεψεν προσ τουσ φιλουσ πορευθεντα επιμελειασ τυχειν ");
INSERT INTO grcmt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","κακειθεν αναχθεντεσ υπεπλευσαμεν την κυπρον δια το τουσ ανεμουσ ειναι εναντιουσ ");
INSERT INTO grcmt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","το τε πελαγοσ το κατα την κιλικιαν και παμφυλιαν διαπλευσαντεσ κατηλθομεν εισ μυρα τησ λυκιασ ");
INSERT INTO grcmt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","κακει ευρων ο εκατονταρχοσ πλοιον αλεξανδρινον πλεον εισ την ιταλιαν ενεβιβασεν ημασ εισ αυτο ");
INSERT INTO grcmt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","εν ικαναισ δε ημεραισ βραδυπλοουντεσ και μολισ γενομενοι κατα την κνιδον μη προσεωντοσ ημασ του ανεμου υπεπλευσαμεν την κρητην κατα σαλμωνην ");
INSERT INTO grcmt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","μολισ τε παραλεγομενοι αυτην ηλθομεν εισ τοπον τινα καλουμενον καλουσ λιμενασ ω εγγυσ ην πολισ λασαια ");
INSERT INTO grcmt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ικανου δε χρονου διαγενομενου και οντοσ ηδη επισφαλουσ του πλοοσ δια το και την νηστειαν ηδη παρεληλυθεναι παρηνει ο παυλοσ ");
INSERT INTO grcmt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","λεγων αυτοισ ανδρεσ θεωρω οτι μετα υβρεωσ και πολλησ ζημιασ ου μονον του φορτιου και του πλοιου αλλα και των ψυχων ημων μελλειν εσεσθαι τον πλουν ");
INSERT INTO grcmt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ο δε εκατονταρχησ τω κυβερνητη και τω ναυκληρω επειθετο μαλλον η τοισ υπο του παυλου λεγομενοισ ");
INSERT INTO grcmt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ανευθετου δε του λιμενοσ υπαρχοντοσ προσ παραχειμασιαν οι πλειουσ εθεντο βουλην αναχθηναι κακειθεν ει πωσ δυναιντο καταντησαντεσ εισ φοινικα παραχειμασαι λιμενα τησ κρητησ βλεποντα κατα λιβα και κατα χωρον ");
INSERT INTO grcmt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","υποπνευσαντοσ δε νοτου δοξαντεσ τησ προθεσεωσ κεκρατηκεναι αραντεσ ασσον παρελεγοντο την κρητην ");
INSERT INTO grcmt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","μετ ου πολυ δε εβαλεν κατ αυτησ ανεμοσ τυφωνικοσ ο καλουμενοσ ευροκλυδων ");
INSERT INTO grcmt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","συναρπασθεντοσ δε του πλοιου και μη δυναμενου αντοφθαλμειν τω ανεμω επιδοντεσ εφερομεθα ");
INSERT INTO grcmt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","νησιον δε τι υποδραμοντεσ καλουμενον κλαυδην μολισ ισχυσαμεν περικρατεισ γενεσθαι τησ σκαφησ ");
INSERT INTO grcmt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ην αραντεσ βοηθειαισ εχρωντο υποζωννυντεσ το πλοιον φοβουμενοι τε μη εισ την συρτην εκπεσωσιν χαλασαντεσ το σκευοσ ουτωσ εφεροντο ");
INSERT INTO grcmt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","σφοδρωσ δε χειμαζομενων ημων τη εξησ εκβολην εποιουντο ");
INSERT INTO grcmt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","και τη τριτη αυτοχειρεσ την σκευην του πλοιου ερριψαμεν ");
INSERT INTO grcmt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","μητε δε ηλιου μητε αστρων επιφαινοντων επι πλειονασ ημερασ χειμωνοσ τε ουκ ολιγου επικειμενου λοιπον περιηρειτο πασα ελπισ του σωζεσθαι ημασ ");
INSERT INTO grcmt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","πολλησ δε ασιτιασ υπαρχουσησ τοτε σταθεισ ο παυλοσ εν μεσω αυτων ειπεν εδει μεν ω ανδρεσ πειθαρχησαντασ μοι μη αναγεσθαι απο τησ κρητησ κερδησαι τε την υβριν ταυτην και την ζημιαν ");
INSERT INTO grcmt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","και τα νυν παραινω υμασ ευθυμειν αποβολη γαρ ψυχησ ουδεμια εσται εξ υμων πλην του πλοιου ");
INSERT INTO grcmt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","παρεστη γαρ μοι ταυτη τη νυκτι αγγελοσ του θεου ου ειμι ω και λατρευω ");
INSERT INTO grcmt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","λεγων μη φοβου παυλε καισαρι σε δει παραστηναι και ιδου κεχαρισται σοι ο θεοσ παντασ τουσ πλεοντασ μετα σου ");
INSERT INTO grcmt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","διο ευθυμειτε ανδρεσ πιστευω γαρ τω θεω οτι ουτωσ εσται καθ ον τροπον λελαληται μοι ");
INSERT INTO grcmt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","εισ νησον δε τινα δει ημασ εκπεσειν ");
INSERT INTO grcmt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ωσ δε τεσσαρεσκαιδεκατη νυξ εγενετο διαφερομενων ημων εν τω αδρια κατα μεσον τησ νυκτοσ υπενοουν οι ναυται προσαγειν τινα αυτοισ χωραν ");
INSERT INTO grcmt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","και βολισαντεσ ευρον οργυιασ εικοσι βραχυ δε διαστησαντεσ και παλιν βολισαντεσ ευρον οργυιασ δεκαπεντε ");
INSERT INTO grcmt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","φοβουμενοι τε μηπωσ εισ τραχεισ τοπουσ εκπεσωμεν εκ πρυμνησ ριψαντεσ αγκυρασ τεσσαρασ ηυχοντο ημεραν γενεσθαι ");
INSERT INTO grcmt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","των δε ναυτων ζητουντων φυγειν εκ του πλοιου και χαλασαντων την σκαφην εισ την θαλασσαν προφασει ωσ εκ πρωρασ μελλοντων αγκυρασ εκτεινειν ");
INSERT INTO grcmt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ειπεν ο παυλοσ τω εκατονταρχη και τοισ στρατιωταισ εαν μη ουτοι μεινωσιν εν τω πλοιω υμεισ σωθηναι ου δυνασθε ");
INSERT INTO grcmt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","τοτε οι στρατιωται απεκοψαν τα σχοινια τησ σκαφησ και ειασαν αυτην εκπεσειν ");
INSERT INTO grcmt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","αχρι δε ου ημελλεν ημερα γινεσθαι παρεκαλει ο παυλοσ απαντασ μεταλαβειν τροφησ λεγων τεσσαρεσκαιδεκατην σημερον ημεραν προσδοκωντεσ ασιτοι διατελειτε μηδεν προσλαβομενοι ");
INSERT INTO grcmt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","διο παρακαλω υμασ προσλαβειν τροφησ τουτο γαρ προσ τησ υμετερασ σωτηριασ υπαρχει ουδενοσ γαρ υμων θριξ εκ τησ κεφαλησ πεσειται ");
INSERT INTO grcmt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ειπων δε ταυτα και λαβων αρτον ευχαριστησεν τω θεω ενωπιον παντων και κλασασ ηρξατο εσθιειν ");
INSERT INTO grcmt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ευθυμοι δε γενομενοι παντεσ και αυτοι προσελαβοντο τροφησ ");
INSERT INTO grcmt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ημεν δε εν τω πλοιω αι πασαι ψυχαι διακοσιαι εβδομηκοντα εξ ");
INSERT INTO grcmt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","κορεσθεντεσ δε τησ τροφησ εκουφιζον το πλοιον εκβαλλομενοι τον σιτον εισ την θαλασσαν ");
INSERT INTO grcmt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","οτε δε ημερα εγενετο την γην ουκ επεγινωσκον κολπον δε τινα κατενοουν εχοντα αιγιαλον εισ ον εβουλευσαντο ει δυνατον εξωσαι το πλοιον ");
INSERT INTO grcmt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","και τασ αγκυρασ περιελοντεσ ειων εισ την θαλασσαν αμα ανεντεσ τασ ζευκτηριασ των πηδαλιων και επαραντεσ τον αρτεμονα τη πνεουση κατειχον εισ τον αιγιαλον ");
INSERT INTO grcmt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","περιπεσοντεσ δε εισ τοπον διθαλασσον επωκειλαν την ναυν και η μεν πρωρα ερεισασα εμεινεν ασαλευτοσ η δε πρυμνα ελυετο υπο τησ βιασ των κυματων ");
INSERT INTO grcmt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","των δε στρατιωτων βουλη εγενετο ινα τουσ δεσμωτασ αποκτεινωσιν μη τισ εκκολυμβησασ διαφυγη ");
INSERT INTO grcmt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ο δε εκατονταρχοσ βουλομενοσ διασωσαι τον παυλον εκωλυσεν αυτουσ του βουληματοσ εκελευσεν τε τουσ δυναμενουσ κολυμβαν απορριψαντασ πρωτουσ επι την γην εξιεναι ");
INSERT INTO grcmt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","και τουσ λοιπουσ ουσ μεν επι σανισιν ουσ δε επι τινων των απο του πλοιου και ουτωσ εγενετο παντασ διασωθηναι επι την γην ");
INSERT INTO grcmt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","και διασωθεντεσ τοτε επεγνωσαν οτι μελιτη η νησοσ καλειται ");
INSERT INTO grcmt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","οι δε βαρβαροι παρειχον ου την τυχουσαν φιλανθρωπιαν ημιν αναψαντεσ γαρ πυραν προσελαβοντο παντασ ημασ δια τον υετον τον εφεστωτα και δια το ψυχοσ ");
INSERT INTO grcmt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","συστρεψαντοσ δε του παυλου φρυγανων πληθοσ και επιθεντοσ επι την πυραν εχιδνα εκ τησ θερμησ διεξελθουσα καθηψεν τησ χειροσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ωσ δε ειδον οι βαρβαροι κρεμαμενον το θηριον εκ τησ χειροσ αυτου ελεγον προσ αλληλουσ παντωσ φονευσ εστιν ο ανθρωποσ ουτοσ ον διασωθεντα εκ τησ θαλασσησ η δικη ζην ουκ ειασεν ");
INSERT INTO grcmt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ο μεν ουν αποτιναξασ το θηριον εισ το πυρ επαθεν ουδεν κακον ");
INSERT INTO grcmt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","οι δε προσεδοκων αυτον μελλειν πιμπρασθαι η καταπιπτειν αφνω νεκρον επι πολυ δε αυτων προσδοκωντων και θεωρουντων μηδεν ατοπον εισ αυτον γινομενον μεταβαλλομενοι ελεγον θεον αυτον ειναι ");
INSERT INTO grcmt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","εν δε τοισ περι τον τοπον εκεινον υπηρχεν χωρια τω πρωτω τησ νησου ονοματι ποπλιω οσ αναδεξαμενοσ ημασ τρεισ ημερασ φιλοφρονωσ εξενισεν ");
INSERT INTO grcmt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","εγενετο δε τον πατερα του ποπλιου πυρετοισ και δυσεντερια συνεχομενον κατακεισθαι προσ ον ο παυλοσ εισελθων και προσευξαμενοσ επιθεισ τασ χειρασ αυτω ιασατο αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","τουτου ουν γενομενου και οι λοιποι οι εχοντεσ ασθενειασ εν τη νησω προσηρχοντο και εθεραπευοντο ");
INSERT INTO grcmt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","οι και πολλαισ τιμαισ ετιμησαν ημασ και αναγομενοισ επεθεντο τα προσ την χρειαν ");
INSERT INTO grcmt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","μετα δε τρεισ μηνασ ηχθημεν εν πλοιω παρακεχειμακοτι εν τη νησω αλεξανδρινω παρασημω διοσκουροισ ");
INSERT INTO grcmt_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","και καταχθεντεσ εισ συρακουσασ επεμειναμεν ημερασ τρεισ ");
INSERT INTO grcmt_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","οθεν περιελθοντεσ κατηντησαμεν εισ ρηγιον και μετα μιαν ημεραν επιγενομενου νοτου δευτεραιοι ηλθομεν εισ ποτιολουσ ");
INSERT INTO grcmt_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ου ευροντεσ αδελφουσ παρεκληθημεν επ αυτοισ επιμειναι ημερασ επτα και ουτωσ εισ την ρωμην ηλθομεν ");
INSERT INTO grcmt_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","κακειθεν οι αδελφοι ακουσαντεσ τα περι ημων εξηλθον εισ απαντησιν ημιν αχρι αππιου φορου και τριων ταβερνων ουσ ιδων ο παυλοσ ευχαριστησασ τω θεω ελαβεν θαρσοσ ");
INSERT INTO grcmt_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","οτε δε ηλθομεν εισ ρωμην ο εκατονταρχοσ παρεδωκεν τουσ δεσμιουσ τω στρατοπεδαρχη τω δε παυλω επετραπη μενειν καθ εαυτον συν τω φυλασσοντι αυτον στρατιωτη ");
INSERT INTO grcmt_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","εγενετο δε μετα ημερασ τρεισ συγκαλεσασθαι τον παυλον τουσ οντασ των ιουδαιων πρωτουσ συνελθοντων δε αυτων ελεγεν προσ αυτουσ ανδρεσ αδελφοι εγω ουδεν εναντιον ποιησασ τω λαω η τοισ εθεσιν τοισ πατρωοισ δεσμιοσ εξ ιεροσολυμων παρεδοθην εισ τασ χειρασ των ρωμαιων ");
INSERT INTO grcmt_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","οιτινεσ ανακριναντεσ με εβουλοντο απολυσαι δια το μηδεμιαν αιτιαν θανατου υπαρχειν εν εμοι ");
INSERT INTO grcmt_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","αντιλεγοντων δε των ιουδαιων ηναγκασθην επικαλεσασθαι καισαρα ουχ ωσ του εθνουσ μου εχων τι κατηγορησαι ");
INSERT INTO grcmt_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","δια ταυτην ουν την αιτιαν παρεκαλεσα υμασ ιδειν και προσλαλησαι ενεκεν γαρ τησ ελπιδοσ του ισραηλ την αλυσιν ταυτην περικειμαι ");
INSERT INTO grcmt_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","οι δε προσ αυτον ειπον ημεισ ουτε γραμματα περι σου εδεξαμεθα απο τησ ιουδαιασ ουτε παραγενομενοσ τισ των αδελφων απηγγειλεν η ελαλησεν τι περι σου πονηρον ");
INSERT INTO grcmt_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","αξιουμεν δε παρα σου ακουσαι α φρονεισ περι μεν γαρ τησ αιρεσεωσ ταυτησ γνωστον εστιν ημιν οτι πανταχου αντιλεγεται ");
INSERT INTO grcmt_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ταξαμενοι δε αυτω ημεραν ηκον προσ αυτον εισ την ξενιαν πλειονεσ οισ εξετιθετο διαμαρτυρομενοσ την βασιλειαν του θεου πειθων τε αυτουσ τα περι του ιησου απο τε του νομου μωυσεωσ και των προφητων απο πρωι εωσ εσπερασ ");
INSERT INTO grcmt_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","και οι μεν επειθοντο τοισ λεγομενοισ οι δε ηπιστουν ");
INSERT INTO grcmt_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ασυμφωνοι δε οντεσ προσ αλληλουσ απελυοντο ειποντοσ του παυλου ρημα εν οτι καλωσ το πνευμα το αγιον ελαλησεν δια ησαιου του προφητου προσ τουσ πατερασ ημων ");
INSERT INTO grcmt_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","λεγον πορευθητι προσ τον λαον τουτον και ειπον ακοη ακουσετε και ου μη συνητε και βλεποντεσ βλεψετε και ου μη ιδητε ");
INSERT INTO grcmt_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","επαχυνθη γαρ η καρδια του λαου τουτου και τοισ ωσιν βαρεωσ ηκουσαν και τουσ οφθαλμουσ αυτων εκαμμυσαν μηποτε ιδωσιν τοισ οφθαλμοισ και τοισ ωσιν ακουσωσιν και τη καρδια συνωσιν και επιστρεψωσιν και ιασομαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","γνωστον ουν εστω υμιν οτι τοισ εθνεσιν απεσταλη το σωτηριον του θεου αυτοι και ακουσονται ");
INSERT INTO grcmt_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","και ταυτα αυτου ειποντοσ απηλθον οι ιουδαιοι πολλην εχοντεσ εν εαυτοισ συζητησιν ");
INSERT INTO grcmt_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","εμεινεν δε ο παυλοσ διετιαν ολην εν ιδιω μισθωματι και απεδεχετο παντασ τουσ εισπορευομενουσ προσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","κηρυσσων την βασιλειαν του θεου και διδασκων τα περι του κυριου ιησου χριστου μετα πασησ παρρησιασ ακωλυτωσ ");
INSERT INTO grcmt_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","παυλοσ δουλοσ ιησου χριστου κλητοσ αποστολοσ αφωρισμενοσ εισ ευαγγελιον θεου ");
INSERT INTO grcmt_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ο προεπηγγειλατο δια των προφητων αυτου εν γραφαισ αγιαισ ");
INSERT INTO grcmt_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","περι του υιου αυτου του γενομενου εκ σπερματοσ δαυιδ κατα σαρκα ");
INSERT INTO grcmt_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","του ορισθεντοσ υιου θεου εν δυναμει κατα πνευμα αγιωσυνησ εξ αναστασεωσ νεκρων ιησου χριστου του κυριου ημων ");
INSERT INTO grcmt_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","δι ου ελαβομεν χαριν και αποστολην εισ υπακοην πιστεωσ εν πασιν τοισ εθνεσιν υπερ του ονοματοσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","εν οισ εστε και υμεισ κλητοι ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","πασιν τοισ ουσιν εν ρωμη αγαπητοισ θεου κλητοισ αγιοισ χαρισ υμιν και ειρηνη απο θεου πατροσ ημων και κυριου ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","πρωτον μεν ευχαριστω τω θεω μου δια ιησου χριστου υπερ παντων υμων οτι η πιστισ υμων καταγγελλεται εν ολω τω κοσμω ");
INSERT INTO grcmt_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","μαρτυσ γαρ μου εστιν ο θεοσ ω λατρευω εν τω πνευματι μου εν τω ευαγγελιω του υιου αυτου ωσ αδιαλειπτωσ μνειαν υμων ποιουμαι ");
INSERT INTO grcmt_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","παντοτε επι των προσευχων μου δεομενοσ ει πωσ ηδη ποτε ευοδωθησομαι εν τω θεληματι του θεου ελθειν προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","επιποθω γαρ ιδειν υμασ ινα τι μεταδω χαρισμα υμιν πνευματικον εισ το στηριχθηναι υμασ ");
INSERT INTO grcmt_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","τουτο δε εστιν συμπαρακληθηναι εν υμιν δια τησ εν αλληλοισ πιστεωσ υμων τε και εμου ");
INSERT INTO grcmt_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ου θελω δε υμασ αγνοειν αδελφοι οτι πολλακισ προεθεμην ελθειν προσ υμασ και εκωλυθην αχρι του δευρο ινα τινα καρπον σχω και εν υμιν καθωσ και εν τοισ λοιποισ εθνεσιν ");
INSERT INTO grcmt_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ελλησιν τε και βαρβαροισ σοφοισ τε και ανοητοισ οφειλετησ ειμι ");
INSERT INTO grcmt_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ουτωσ το κατ εμε προθυμον και υμιν τοισ εν ρωμη ευαγγελισασθαι ");
INSERT INTO grcmt_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ου γαρ επαισχυνομαι το ευαγγελιον του χριστου δυναμισ γαρ θεου εστιν εισ σωτηριαν παντι τω πιστευοντι ιουδαιω τε πρωτον και ελληνι ");
INSERT INTO grcmt_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","δικαιοσυνη γαρ θεου εν αυτω αποκαλυπτεται εκ πιστεωσ εισ πιστιν καθωσ γεγραπται ο δε δικαιοσ εκ πιστεωσ ζησεται ");
INSERT INTO grcmt_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","αποκαλυπτεται γαρ οργη θεου απ ουρανου επι πασαν ασεβειαν και αδικιαν ανθρωπων των την αληθειαν εν αδικια κατεχοντων ");
INSERT INTO grcmt_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","διοτι το γνωστον του θεου φανερον εστιν εν αυτοισ ο γαρ θεοσ αυτοισ εφανερωσεν ");
INSERT INTO grcmt_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","τα γαρ αορατα αυτου απο κτισεωσ κοσμου τοισ ποιημασιν νοουμενα καθοραται η τε αιδιοσ αυτου δυναμισ και θειοτησ εισ το ειναι αυτουσ αναπολογητουσ ");
INSERT INTO grcmt_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","διοτι γνοντεσ τον θεον ουχ ωσ θεον εδοξασαν η ευχαριστησαν αλλ εματαιωθησαν εν τοισ διαλογισμοισ αυτων και εσκοτισθη η ασυνετοσ αυτων καρδια ");
INSERT INTO grcmt_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","φασκοντεσ ειναι σοφοι εμωρανθησαν ");
INSERT INTO grcmt_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","και ηλλαξαν την δοξαν του αφθαρτου θεου εν ομοιωματι εικονοσ φθαρτου ανθρωπου και πετεινων και τετραποδων και ερπετων ");
INSERT INTO grcmt_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","διο και παρεδωκεν αυτουσ ο θεοσ εν ταισ επιθυμιαισ των καρδιων αυτων εισ ακαθαρσιαν του ατιμαζεσθαι τα σωματα αυτων εν εαυτοισ ");
INSERT INTO grcmt_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","οιτινεσ μετηλλαξαν την αληθειαν του θεου εν τω ψευδει και εσεβασθησαν και ελατρευσαν τη κτισει παρα τον κτισαντα οσ εστιν ευλογητοσ εισ τουσ αιωνασ αμην ");
INSERT INTO grcmt_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","δια τουτο παρεδωκεν αυτουσ ο θεοσ εισ παθη ατιμιασ αι τε γαρ θηλειαι αυτων μετηλλαξαν την φυσικην χρησιν εισ την παρα φυσιν ");
INSERT INTO grcmt_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ομοιωσ τε και οι αρρενεσ αφεντεσ την φυσικην χρησιν τησ θηλειασ εξεκαυθησαν εν τη ορεξει αυτων εισ αλληλουσ αρσενεσ εν αρσεσιν την ασχημοσυνην κατεργαζομενοι και την αντιμισθιαν ην εδει τησ πλανησ αυτων εν εαυτοισ απολαμβανοντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","και καθωσ ουκ εδοκιμασαν τον θεον εχειν εν επιγνωσει παρεδωκεν αυτουσ ο θεοσ εισ αδοκιμον νουν ποιειν τα μη καθηκοντα ");
INSERT INTO grcmt_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","πεπληρωμενουσ παση αδικια πορνεια πονηρια πλεονεξια κακια μεστουσ φθονου φονου εριδοσ δολου κακοηθειασ ψιθυριστασ ");
INSERT INTO grcmt_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","καταλαλουσ θεοστυγεισ υβριστασ υπερηφανουσ αλαζονασ εφευρετασ κακων γονευσιν απειθεισ ");
INSERT INTO grcmt_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ασυνετουσ ασυνθετουσ αστοργουσ ασπονδουσ ανελεημονασ ");
INSERT INTO grcmt_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","οιτινεσ το δικαιωμα του θεου επιγνοντεσ οτι οι τα τοιαυτα πρασσοντεσ αξιοι θανατου εισιν ου μονον αυτα ποιουσιν αλλα και συνευδοκουσιν τοισ πρασσουσιν ");
INSERT INTO grcmt_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","διο αναπολογητοσ ει ω ανθρωπε πασ ο κρινων εν ω γαρ κρινεισ τον ετερον σεαυτον κατακρινεισ τα γαρ αυτα πρασσεισ ο κρινων ");
INSERT INTO grcmt_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","οιδαμεν δε οτι το κριμα του θεου εστιν κατα αληθειαν επι τουσ τα τοιαυτα πρασσοντασ ");
INSERT INTO grcmt_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","λογιζη δε τουτο ω ανθρωπε ο κρινων τουσ τα τοιαυτα πρασσοντασ και ποιων αυτα οτι συ εκφευξη το κριμα του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","η του πλουτου τησ χρηστοτητοσ αυτου και τησ ανοχησ και τησ μακροθυμιασ καταφρονεισ αγνοων οτι το χρηστον του θεου εισ μετανοιαν σε αγει ");
INSERT INTO grcmt_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","κατα δε την σκληροτητα σου και αμετανοητον καρδιαν θησαυριζεισ σεαυτω οργην εν ημερα οργησ και αποκαλυψεωσ και δικαιοκρισιασ του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","οσ αποδωσει εκαστω κατα τα εργα αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","τοισ μεν καθ υπομονην εργου αγαθου δοξαν και τιμην και αφθαρσιαν ζητουσιν ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","τοισ δε εξ εριθειασ και απειθουσιν μεν τη αληθεια πειθομενοισ δε τη αδικια θυμοσ και οργη ");
INSERT INTO grcmt_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","θλιψισ και στενοχωρια επι πασαν ψυχην ανθρωπου του κατεργαζομενου το κακον ιουδαιου τε πρωτον και ελληνοσ ");
INSERT INTO grcmt_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","δοξα δε και τιμη και ειρηνη παντι τω εργαζομενω το αγαθον ιουδαιω τε πρωτον και ελληνι ");
INSERT INTO grcmt_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ου γαρ εστιν προσωποληψια παρα τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","οσοι γαρ ανομωσ ημαρτον ανομωσ και απολουνται και οσοι εν νομω ημαρτον δια νομου κριθησονται ");
INSERT INTO grcmt_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ου γαρ οι ακροαται του νομου δικαιοι παρα τω θεω αλλ οι ποιηται του νομου δικαιωθησονται ");
INSERT INTO grcmt_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","οταν γαρ εθνη τα μη νομον εχοντα φυσει τα του νομου ποιη ουτοι νομον μη εχοντεσ εαυτοισ εισιν νομοσ ");
INSERT INTO grcmt_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","οιτινεσ ενδεικνυνται το εργον του νομου γραπτον εν ταισ καρδιαισ αυτων συμμαρτυρουσησ αυτων τησ συνειδησεωσ και μεταξυ αλληλων των λογισμων κατηγορουντων η και απολογουμενων ");
INSERT INTO grcmt_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","εν ημερα οτε κρινει ο θεοσ τα κρυπτα των ανθρωπων κατα το ευαγγελιον μου δια ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ιδε συ ιουδαιοσ επονομαζη και επαναπαυη τω νομω και καυχασαι εν θεω ");
INSERT INTO grcmt_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","και γινωσκεισ το θελημα και δοκιμαζεισ τα διαφεροντα κατηχουμενοσ εκ του νομου ");
INSERT INTO grcmt_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","πεποιθασ τε σεαυτον οδηγον ειναι τυφλων φωσ των εν σκοτει ");
INSERT INTO grcmt_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","παιδευτην αφρονων διδασκαλον νηπιων εχοντα την μορφωσιν τησ γνωσεωσ και τησ αληθειασ εν τω νομω ");
INSERT INTO grcmt_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ο ουν διδασκων ετερον σεαυτον ου διδασκεισ ο κηρυσσων μη κλεπτειν κλεπτεισ ");
INSERT INTO grcmt_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ο λεγων μη μοιχευειν μοιχευεισ ο βδελυσσομενοσ τα ειδωλα ιεροσυλεισ ");
INSERT INTO grcmt_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","οσ εν νομω καυχασαι δια τησ παραβασεωσ του νομου τον θεον ατιμαζεισ ");
INSERT INTO grcmt_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","το γαρ ονομα του θεου δι υμασ βλασφημειται εν τοισ εθνεσιν καθωσ γεγραπται ");
INSERT INTO grcmt_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","περιτομη μεν γαρ ωφελει εαν νομον πρασσησ εαν δε παραβατησ νομου ησ η περιτομη σου ακροβυστια γεγονεν ");
INSERT INTO grcmt_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","εαν ουν η ακροβυστια τα δικαιωματα του νομου φυλασση ουχι η ακροβυστια αυτου εισ περιτομην λογισθησεται ");
INSERT INTO grcmt_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","και κρινει η εκ φυσεωσ ακροβυστια τον νομον τελουσα σε τον δια γραμματοσ και περιτομησ παραβατην νομου ");
INSERT INTO grcmt_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ου γαρ ο εν τω φανερω ιουδαιοσ εστιν ουδε η εν τω φανερω εν σαρκι περιτομη ");
INSERT INTO grcmt_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","αλλ ο εν τω κρυπτω ιουδαιοσ και περιτομη καρδιασ εν πνευματι ου γραμματι ου ο επαινοσ ουκ εξ ανθρωπων αλλ εκ του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","τι ουν το περισσον του ιουδαιου η τισ η ωφελεια τησ περιτομησ ");
INSERT INTO grcmt_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","πολυ κατα παντα τροπον πρωτον μεν γαρ οτι επιστευθησαν τα λογια του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","τι γαρ ει ηπιστησαν τινεσ μη η απιστια αυτων την πιστιν του θεου καταργησει ");
INSERT INTO grcmt_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","μη γενοιτο γινεσθω δε ο θεοσ αληθησ πασ δε ανθρωποσ ψευστησ καθωσ γεγραπται οπωσ αν δικαιωθησ εν τοισ λογοισ σου και νικησησ εν τω κρινεσθαι σε ");
INSERT INTO grcmt_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ει δε η αδικια ημων θεου δικαιοσυνην συνιστησιν τι ερουμεν μη αδικοσ ο θεοσ ο επιφερων την οργην κατα ανθρωπον λεγω ");
INSERT INTO grcmt_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","μη γενοιτο επει πωσ κρινει ο θεοσ τον κοσμον ");
INSERT INTO grcmt_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ει γαρ η αληθεια του θεου εν τω εμω ψευσματι επερισσευσεν εισ την δοξαν αυτου τι ετι καγω ωσ αμαρτωλοσ κρινομαι ");
INSERT INTO grcmt_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","και μη καθωσ βλασφημουμεθα και καθωσ φασιν τινεσ ημασ λεγειν οτι ποιησωμεν τα κακα ινα ελθη τα αγαθα ων το κριμα ενδικον εστιν ");
INSERT INTO grcmt_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","τι ουν προεχομεθα ου παντωσ προητιασαμεθα γαρ ιουδαιουσ τε και ελληνασ παντασ υφ αμαρτιαν ειναι ");
INSERT INTO grcmt_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","καθωσ γεγραπται οτι ουκ εστιν δικαιοσ ουδε εισ ");
INSERT INTO grcmt_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ουκ εστιν ο συνιων ουκ εστιν ο εκζητων τον θεον ");
INSERT INTO grcmt_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","παντεσ εξεκλιναν αμα ηχρειωθησαν ουκ εστιν ποιων χρηστοτητα ουκ εστιν εωσ ενοσ ");
INSERT INTO grcmt_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ταφοσ ανεωγμενοσ ο λαρυγξ αυτων ταισ γλωσσαισ αυτων εδολιουσαν ιοσ ασπιδων υπο τα χειλη αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ων το στομα αρασ και πικριασ γεμει ");
INSERT INTO grcmt_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","οξεισ οι ποδεσ αυτων εκχεαι αιμα ");
INSERT INTO grcmt_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","συντριμμα και ταλαιπωρια εν ταισ οδοισ αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","και οδον ειρηνησ ουκ εγνωσαν ");
INSERT INTO grcmt_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ουκ εστιν φοβοσ θεου απεναντι των οφθαλμων αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","οιδαμεν δε οτι οσα ο νομοσ λεγει τοισ εν τω νομω λαλει ινα παν στομα φραγη και υποδικοσ γενηται πασ ο κοσμοσ τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","διοτι εξ εργων νομου ου δικαιωθησεται πασα σαρξ ενωπιον αυτου δια γαρ νομου επιγνωσισ αμαρτιασ ");
INSERT INTO grcmt_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","νυνι δε χωρισ νομου δικαιοσυνη θεου πεφανερωται μαρτυρουμενη υπο του νομου και των προφητων ");
INSERT INTO grcmt_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","δικαιοσυνη δε θεου δια πιστεωσ ιησου χριστου εισ παντασ και επι παντασ τουσ πιστευοντασ ου γαρ εστιν διαστολη ");
INSERT INTO grcmt_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","παντεσ γαρ ημαρτον και υστερουνται τησ δοξησ του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","δικαιουμενοι δωρεαν τη αυτου χαριτι δια τησ απολυτρωσεωσ τησ εν χριστω ιησου ");
INSERT INTO grcmt_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ον προεθετο ο θεοσ ιλαστηριον δια τησ πιστεωσ εν τω αυτου αιματι εισ ενδειξιν τησ δικαιοσυνησ αυτου δια την παρεσιν των προγεγονοτων αμαρτηματων ");
INSERT INTO grcmt_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","εν τη ανοχη του θεου προσ ενδειξιν τησ δικαιοσυνησ αυτου εν τω νυν καιρω εισ το ειναι αυτον δικαιον και δικαιουντα τον εκ πιστεωσ ιησου ");
INSERT INTO grcmt_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","που ουν η καυχησισ εξεκλεισθη δια ποιου νομου των εργων ουχι αλλα δια νομου πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","λογιζομεθα ουν πιστει δικαιουσθαι ανθρωπον χωρισ εργων νομου ");
INSERT INTO grcmt_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","η ιουδαιων ο θεοσ μονον ουχι δε και εθνων ναι και εθνων ");
INSERT INTO grcmt_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","επειπερ εισ ο θεοσ οσ δικαιωσει περιτομην εκ πιστεωσ και ακροβυστιαν δια τησ πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","νομον ουν καταργουμεν δια τησ πιστεωσ μη γενοιτο αλλα νομον ιστωμεν ");
INSERT INTO grcmt_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","τι ουν ερουμεν αβρααμ τον πατερα ημων ευρηκεναι κατα σαρκα ");
INSERT INTO grcmt_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ει γαρ αβρααμ εξ εργων εδικαιωθη εχει καυχημα αλλ ου προσ τον θεον ");
INSERT INTO grcmt_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","τι γαρ η γραφη λεγει επιστευσεν δε αβρααμ τω θεω και ελογισθη αυτω εισ δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","τω δε εργαζομενω ο μισθοσ ου λογιζεται κατα χαριν αλλα κατα οφειλημα ");
INSERT INTO grcmt_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","τω δε μη εργαζομενω πιστευοντι δε επι τον δικαιουντα τον ασεβη λογιζεται η πιστισ αυτου εισ δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","καθαπερ και δαυιδ λεγει τον μακαρισμον του ανθρωπου ω ο θεοσ λογιζεται δικαιοσυνην χωρισ εργων ");
INSERT INTO grcmt_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","μακαριοι ων αφεθησαν αι ανομιαι και ων επεκαλυφθησαν αι αμαρτιαι ");
INSERT INTO grcmt_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","μακαριοσ ανηρ ω ου μη λογισηται κυριοσ αμαρτιαν ");
INSERT INTO grcmt_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ο μακαρισμοσ ουν ουτοσ επι την περιτομην η και επι την ακροβυστιαν λεγομεν γαρ οτι ελογισθη τω αβρααμ η πιστισ εισ δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","πωσ ουν ελογισθη εν περιτομη οντι η εν ακροβυστια ουκ εν περιτομη αλλ εν ακροβυστια ");
INSERT INTO grcmt_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","και σημειον ελαβεν περιτομησ σφραγιδα τησ δικαιοσυνησ τησ πιστεωσ τησ εν τη ακροβυστια εισ το ειναι αυτον πατερα παντων των πιστευοντων δι ακροβυστιασ εισ το λογισθηναι και αυτοισ την δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","και πατερα περιτομησ τοισ ουκ εκ περιτομησ μονον αλλα και τοισ στοιχουσιν τοισ ιχνεσιν τησ πιστεωσ τησ εν τη ακροβυστια του πατροσ ημων αβρααμ ");
INSERT INTO grcmt_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ου γαρ δια νομου η επαγγελια τω αβρααμ η τω σπερματι αυτου το κληρονομον αυτον ειναι του κοσμου αλλα δια δικαιοσυνησ πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ει γαρ οι εκ νομου κληρονομοι κεκενωται η πιστισ και κατηργηται η επαγγελια ");
INSERT INTO grcmt_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ο γαρ νομοσ οργην κατεργαζεται ου γαρ ουκ εστιν νομοσ ουδε παραβασισ ");
INSERT INTO grcmt_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","δια τουτο εκ πιστεωσ ινα κατα χαριν εισ το ειναι βεβαιαν την επαγγελιαν παντι τω σπερματι ου τω εκ του νομου μονον αλλα και τω εκ πιστεωσ αβρααμ οσ εστιν πατηρ παντων ημων ");
INSERT INTO grcmt_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","καθωσ γεγραπται οτι πατερα πολλων εθνων τεθεικα σε κατεναντι ου επιστευσεν θεου του ζωοποιουντοσ τουσ νεκρουσ και καλουντοσ τα μη οντα ωσ οντα ");
INSERT INTO grcmt_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","οσ παρ ελπιδα επ ελπιδι επιστευσεν εισ το γενεσθαι αυτον πατερα πολλων εθνων κατα το ειρημενον ουτωσ εσται το σπερμα σου ");
INSERT INTO grcmt_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","και μη ασθενησασ τη πιστει ου κατενοησεν το εαυτου σωμα ηδη νενεκρωμενον εκατονταετησ που υπαρχων και την νεκρωσιν τησ μητρασ σαρρασ ");
INSERT INTO grcmt_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","εισ δε την επαγγελιαν του θεου ου διεκριθη τη απιστια αλλ ενεδυναμωθη τη πιστει δουσ δοξαν τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","και πληροφορηθεισ οτι ο επηγγελται δυνατοσ εστιν και ποιησαι ");
INSERT INTO grcmt_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","διο και ελογισθη αυτω εισ δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ουκ εγραφη δε δι αυτον μονον οτι ελογισθη αυτω ");
INSERT INTO grcmt_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","αλλα και δι ημασ οισ μελλει λογιζεσθαι τοισ πιστευουσιν επι τον εγειραντα ιησουν τον κυριον ημων εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","οσ παρεδοθη δια τα παραπτωματα ημων και ηγερθη δια την δικαιωσιν ημων ");
INSERT INTO grcmt_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","δικαιωθεντεσ ουν εκ πιστεωσ ειρηνην εχομεν προσ τον θεον δια του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","δι ου και την προσαγωγην εσχηκαμεν τη πιστει εισ την χαριν ταυτην εν η εστηκαμεν και καυχωμεθα επ ελπιδι τησ δοξησ του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ου μονον δε αλλα και καυχωμεθα εν ταισ θλιψεσιν ειδοτεσ οτι η θλιψισ υπομονην κατεργαζεται ");
INSERT INTO grcmt_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","η δε υπομονη δοκιμην η δε δοκιμη ελπιδα ");
INSERT INTO grcmt_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","η δε ελπισ ου καταισχυνει οτι η αγαπη του θεου εκκεχυται εν ταισ καρδιαισ ημων δια πνευματοσ αγιου του δοθεντοσ ημιν ");
INSERT INTO grcmt_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ετι γαρ χριστοσ οντων ημων ασθενων κατα καιρον υπερ ασεβων απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","μολισ γαρ υπερ δικαιου τισ αποθανειται υπερ γαρ του αγαθου ταχα τισ και τολμα αποθανειν ");
INSERT INTO grcmt_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","συνιστησιν δε την εαυτου αγαπην εισ ημασ ο θεοσ οτι ετι αμαρτωλων οντων ημων χριστοσ υπερ ημων απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","πολλω ουν μαλλον δικαιωθεντεσ νυν εν τω αιματι αυτου σωθησομεθα δι αυτου απο τησ οργησ ");
INSERT INTO grcmt_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ει γαρ εχθροι οντεσ κατηλλαγημεν τω θεω δια του θανατου του υιου αυτου πολλω μαλλον καταλλαγεντεσ σωθησομεθα εν τη ζωη αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ου μονον δε αλλα και καυχωμενοι εν τω θεω δια του κυριου ημων ιησου χριστου δι ου νυν την καταλλαγην ελαβομεν ");
INSERT INTO grcmt_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","δια τουτο ωσπερ δι ενοσ ανθρωπου η αμαρτια εισ τον κοσμον εισηλθεν και δια τησ αμαρτιασ ο θανατοσ και ουτωσ εισ παντασ ανθρωπουσ ο θανατοσ διηλθεν εφ ω παντεσ ημαρτον ");
INSERT INTO grcmt_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","αχρι γαρ νομου αμαρτια ην εν κοσμω αμαρτια δε ουκ ελλογειται μη οντοσ νομου ");
INSERT INTO grcmt_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","αλλ εβασιλευσεν ο θανατοσ απο αδαμ μεχρι μωυσεωσ και επι τουσ μη αμαρτησαντασ επι τω ομοιωματι τησ παραβασεωσ αδαμ οσ εστιν τυποσ του μελλοντοσ ");
INSERT INTO grcmt_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","αλλ ουχ ωσ το παραπτωμα ουτωσ και το χαρισμα ει γαρ τω του ενοσ παραπτωματι οι πολλοι απεθανον πολλω μαλλον η χαρισ του θεου και η δωρεα εν χαριτι τη του ενοσ ανθρωπου ιησου χριστου εισ τουσ πολλουσ επερισσευσεν ");
INSERT INTO grcmt_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","και ουχ ωσ δι ενοσ αμαρτησαντοσ το δωρημα το μεν γαρ κριμα εξ ενοσ εισ κατακριμα το δε χαρισμα εκ πολλων παραπτωματων εισ δικαιωμα ");
INSERT INTO grcmt_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ει γαρ τω του ενοσ παραπτωματι ο θανατοσ εβασιλευσεν δια του ενοσ πολλω μαλλον οι την περισσειαν τησ χαριτοσ και τησ δωρεασ τησ δικαιοσυνησ λαμβανοντεσ εν ζωη βασιλευσουσιν δια του ενοσ ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","αρα ουν ωσ δι ενοσ παραπτωματοσ εισ παντασ ανθρωπουσ εισ κατακριμα ουτωσ και δι ενοσ δικαιωματοσ εισ παντασ ανθρωπουσ εισ δικαιωσιν ζωησ ");
INSERT INTO grcmt_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ωσπερ γαρ δια τησ παρακοησ του ενοσ ανθρωπου αμαρτωλοι κατεσταθησαν οι πολλοι ουτωσ και δια τησ υπακοησ του ενοσ δικαιοι κατασταθησονται οι πολλοι ");
INSERT INTO grcmt_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","νομοσ δε παρεισηλθεν ινα πλεοναση το παραπτωμα ου δε επλεονασεν η αμαρτια υπερεπερισσευσεν η χαρισ ");
INSERT INTO grcmt_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ινα ωσπερ εβασιλευσεν η αμαρτια εν τω θανατω ουτωσ και η χαρισ βασιλευση δια δικαιοσυνησ εισ ζωην αιωνιον δια ιησου χριστου του κυριου ημων ");
INSERT INTO grcmt_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","τι ουν ερουμεν επιμενομεν τη αμαρτια ινα η χαρισ πλεοναση ");
INSERT INTO grcmt_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","μη γενοιτο οιτινεσ απεθανομεν τη αμαρτια πωσ ετι ζησομεν εν αυτη ");
INSERT INTO grcmt_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","η αγνοειτε οτι οσοι εβαπτισθημεν εισ χριστον ιησουν εισ τον θανατον αυτου εβαπτισθημεν ");
INSERT INTO grcmt_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","συνεταφημεν ουν αυτω δια του βαπτισματοσ εισ τον θανατον ινα ωσπερ ηγερθη χριστοσ εκ νεκρων δια τησ δοξησ του πατροσ ουτωσ και ημεισ εν καινοτητι ζωησ περιπατησωμεν ");
INSERT INTO grcmt_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ει γαρ συμφυτοι γεγοναμεν τω ομοιωματι του θανατου αυτου αλλα και τησ αναστασεωσ εσομεθα ");
INSERT INTO grcmt_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","τουτο γινωσκοντεσ οτι ο παλαιοσ ημων ανθρωποσ συνεσταυρωθη ινα καταργηθη το σωμα τησ αμαρτιασ του μηκετι δουλευειν ημασ τη αμαρτια ");
INSERT INTO grcmt_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ο γαρ αποθανων δεδικαιωται απο τησ αμαρτιασ ");
INSERT INTO grcmt_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ει δε απεθανομεν συν χριστω πιστευομεν οτι και συζησομεν αυτω ");
INSERT INTO grcmt_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ειδοτεσ οτι χριστοσ εγερθεισ εκ νεκρων ουκετι αποθνησκει θανατοσ αυτου ουκετι κυριευει ");
INSERT INTO grcmt_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ο γαρ απεθανεν τη αμαρτια απεθανεν εφαπαξ ο δε ζη ζη τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ουτωσ και υμεισ λογιζεσθε εαυτουσ νεκρουσ μεν ειναι τη αμαρτια ζωντασ δε τω θεω εν χριστω ιησου τω κυριω ημων ");
INSERT INTO grcmt_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","μη ουν βασιλευετω η αμαρτια εν τω θνητω υμων σωματι εισ το υπακουειν αυτη εν ταισ επιθυμιαισ αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","μηδε παριστανετε τα μελη υμων οπλα αδικιασ τη αμαρτια αλλα παραστησατε εαυτουσ τω θεω ωσ εκ νεκρων ζωντασ και τα μελη υμων οπλα δικαιοσυνησ τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","αμαρτια γαρ υμων ου κυριευσει ου γαρ εστε υπο νομον αλλ υπο χαριν ");
INSERT INTO grcmt_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","τι ουν αμαρτησομεν οτι ουκ εσμεν υπο νομον αλλ υπο χαριν μη γενοιτο ");
INSERT INTO grcmt_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ουκ οιδατε οτι ω παριστανετε εαυτουσ δουλουσ εισ υπακοην δουλοι εστε ω υπακουετε ητοι αμαρτιασ εισ θανατον η υπακοησ εισ δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","χαρισ δε τω θεω οτι ητε δουλοι τησ αμαρτιασ υπηκουσατε δε εκ καρδιασ εισ ον παρεδοθητε τυπον διδαχησ ");
INSERT INTO grcmt_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ελευθερωθεντεσ δε απο τησ αμαρτιασ εδουλωθητε τη δικαιοσυνη ");
INSERT INTO grcmt_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ανθρωπινον λεγω δια την ασθενειαν τησ σαρκοσ υμων ωσπερ γαρ παρεστησατε τα μελη υμων δουλα τη ακαθαρσια και τη ανομια εισ την ανομιαν ουτωσ νυν παραστησατε τα μελη υμων δουλα τη δικαιοσυνη εισ αγιασμον ");
INSERT INTO grcmt_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","οτε γαρ δουλοι ητε τησ αμαρτιασ ελευθεροι ητε τη δικαιοσυνη ");
INSERT INTO grcmt_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","τινα ουν καρπον ειχετε τοτε εφ οισ νυν επαισχυνεσθε το γαρ τελοσ εκεινων θανατοσ ");
INSERT INTO grcmt_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","νυνι δε ελευθερωθεντεσ απο τησ αμαρτιασ δουλωθεντεσ δε τω θεω εχετε τον καρπον υμων εισ αγιασμον το δε τελοσ ζωην αιωνιον ");
INSERT INTO grcmt_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","τα γαρ οψωνια τησ αμαρτιασ θανατοσ το δε χαρισμα του θεου ζωη αιωνιοσ εν χριστω ιησου τω κυριω ημων ");
INSERT INTO grcmt_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","η αγνοειτε αδελφοι γινωσκουσιν γαρ νομον λαλω οτι ο νομοσ κυριευει του ανθρωπου εφ οσον χρονον ζη ");
INSERT INTO grcmt_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","η γαρ υπανδροσ γυνη τω ζωντι ανδρι δεδεται νομω εαν δε αποθανη ο ανηρ κατηργηται απο του νομου του ανδροσ ");
INSERT INTO grcmt_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","αρα ουν ζωντοσ του ανδροσ μοιχαλισ χρηματισει εαν γενηται ανδρι ετερω εαν δε αποθανη ο ανηρ ελευθερα εστιν απο του νομου του μη ειναι αυτην μοιχαλιδα γενομενην ανδρι ετερω ");
INSERT INTO grcmt_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ωστε αδελφοι μου και υμεισ εθανατωθητε τω νομω δια του σωματοσ του χριστου εισ το γενεσθαι υμασ ετερω τω εκ νεκρων εγερθεντι ινα καρποφορησωμεν τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","οτε γαρ ημεν εν τη σαρκι τα παθηματα των αμαρτιων τα δια του νομου ενηργειτο εν τοισ μελεσιν ημων εισ το καρποφορησαι τω θανατω ");
INSERT INTO grcmt_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","νυνι δε κατηργηθημεν απο του νομου αποθανοντεσ εν ω κατειχομεθα ωστε δουλευειν ημασ εν καινοτητι πνευματοσ και ου παλαιοτητι γραμματοσ ");
INSERT INTO grcmt_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","τι ουν ερουμεν ο νομοσ αμαρτια μη γενοιτο αλλα την αμαρτιαν ουκ εγνων ει μη δια νομου την τε γαρ επιθυμιαν ουκ ηδειν ει μη ο νομοσ ελεγεν ουκ επιθυμησεισ ");
INSERT INTO grcmt_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","αφορμην δε λαβουσα η αμαρτια δια τησ εντολησ κατειργασατο εν εμοι πασαν επιθυμιαν χωρισ γαρ νομου αμαρτια νεκρα ");
INSERT INTO grcmt_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","εγω δε εζων χωρισ νομου ποτε ελθουσησ δε τησ εντολησ η αμαρτια ανεζησεν εγω δε απεθανον ");
INSERT INTO grcmt_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","και ευρεθη μοι η εντολη η εισ ζωην αυτη εισ θανατον ");
INSERT INTO grcmt_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","η γαρ αμαρτια αφορμην λαβουσα δια τησ εντολησ εξηπατησεν με και δι αυτησ απεκτεινεν ");
INSERT INTO grcmt_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ωστε ο μεν νομοσ αγιοσ και η εντολη αγια και δικαια και αγαθη ");
INSERT INTO grcmt_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","το ουν αγαθον εμοι γεγονεν θανατοσ μη γενοιτο αλλα η αμαρτια ινα φανη αμαρτια δια του αγαθου μοι κατεργαζομενη θανατον ινα γενηται καθ υπερβολην αμαρτωλοσ η αμαρτια δια τησ εντολησ ");
INSERT INTO grcmt_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","οιδαμεν γαρ οτι ο νομοσ πνευματικοσ εστιν εγω δε σαρκικοσ ειμι πεπραμενοσ υπο την αμαρτιαν ");
INSERT INTO grcmt_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ο γαρ κατεργαζομαι ου γινωσκω ου γαρ ο θελω τουτο πρασσω αλλ ο μισω τουτο ποιω ");
INSERT INTO grcmt_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ει δε ο ου θελω τουτο ποιω συμφημι τω νομω οτι καλοσ ");
INSERT INTO grcmt_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","νυνι δε ουκετι εγω κατεργαζομαι αυτο αλλ η οικουσα εν εμοι αμαρτια ");
INSERT INTO grcmt_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","οιδα γαρ οτι ουκ οικει εν εμοι τουτ εστιν εν τη σαρκι μου αγαθον το γαρ θελειν παρακειται μοι το δε κατεργαζεσθαι το καλον ουχ ευρισκω ");
INSERT INTO grcmt_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ου γαρ ο θελω ποιω αγαθον αλλ ο ου θελω κακον τουτο πρασσω ");
INSERT INTO grcmt_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ει δε ο ου θελω εγω τουτο ποιω ουκετι εγω κατεργαζομαι αυτο αλλ η οικουσα εν εμοι αμαρτια ");
INSERT INTO grcmt_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ευρισκω αρα τον νομον τω θελοντι εμοι ποιειν το καλον οτι εμοι το κακον παρακειται ");
INSERT INTO grcmt_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","συνηδομαι γαρ τω νομω του θεου κατα τον εσω ανθρωπον ");
INSERT INTO grcmt_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","βλεπω δε ετερον νομον εν τοισ μελεσιν μου αντιστρατευομενον τω νομω του νοοσ μου και αιχμαλωτιζοντα με τω νομω τησ αμαρτιασ τω οντι εν τοισ μελεσιν μου ");
INSERT INTO grcmt_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ταλαιπωροσ εγω ανθρωποσ τισ με ρυσεται εκ του σωματοσ του θανατου τουτου ");
INSERT INTO grcmt_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ευχαριστω τω θεω δια ιησου χριστου του κυριου ημων αρα ουν αυτοσ εγω τω μεν νοι δουλευω νομω θεου τη δε σαρκι νομω αμαρτιασ ");
INSERT INTO grcmt_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ουδεν αρα νυν κατακριμα τοισ εν χριστω ιησου μη κατα σαρκα περιπατουσιν αλλα κατα πνευμα ");
INSERT INTO grcmt_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ο γαρ νομοσ του πνευματοσ τησ ζωησ εν χριστω ιησου ηλευθερωσεν με απο του νομου τησ αμαρτιασ και του θανατου ");
INSERT INTO grcmt_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","το γαρ αδυνατον του νομου εν ω ησθενει δια τησ σαρκοσ ο θεοσ τον εαυτου υιον πεμψασ εν ομοιωματι σαρκοσ αμαρτιασ και περι αμαρτιασ κατεκρινεν την αμαρτιαν εν τη σαρκι ");
INSERT INTO grcmt_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ινα το δικαιωμα του νομου πληρωθη εν ημιν τοισ μη κατα σαρκα περιπατουσιν αλλα κατα πνευμα ");
INSERT INTO grcmt_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","οι γαρ κατα σαρκα οντεσ τα τησ σαρκοσ φρονουσιν οι δε κατα πνευμα τα του πνευματοσ ");
INSERT INTO grcmt_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","το γαρ φρονημα τησ σαρκοσ θανατοσ το δε φρονημα του πνευματοσ ζωη και ειρηνη ");
INSERT INTO grcmt_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","διοτι το φρονημα τησ σαρκοσ εχθρα εισ θεον τω γαρ νομω του θεου ουχ υποτασσεται ουδε γαρ δυναται ");
INSERT INTO grcmt_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","οι δε εν σαρκι οντεσ θεω αρεσαι ου δυνανται ");
INSERT INTO grcmt_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","υμεισ δε ουκ εστε εν σαρκι αλλ εν πνευματι ειπερ πνευμα θεου οικει εν υμιν ει δε τισ πνευμα χριστου ουκ εχει ουτοσ ουκ εστιν αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ει δε χριστοσ εν υμιν το μεν σωμα νεκρον δια αμαρτιαν το δε πνευμα ζωη δια δικαιοσυνην ");
INSERT INTO grcmt_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ει δε το πνευμα του εγειραντοσ ιησουν εκ νεκρων οικει εν υμιν ο εγειρασ τον χριστον εκ νεκρων ζωοποιησει και τα θνητα σωματα υμων δια το ενοικουν αυτου πνευμα εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","αρα ουν αδελφοι οφειλεται εσμεν ου τη σαρκι του κατα σαρκα ζην ");
INSERT INTO grcmt_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ει γαρ κατα σαρκα ζητε μελλετε αποθνησκειν ει δε πνευματι τασ πραξεισ του σωματοσ θανατουτε ζησεσθε ");
INSERT INTO grcmt_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","οσοι γαρ πνευματι θεου αγονται ουτοι εισιν υιοι θεου ");
INSERT INTO grcmt_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ου γαρ ελαβετε πνευμα δουλειασ παλιν εισ φοβον αλλ ελαβετε πνευμα υιοθεσιασ εν ω κραζομεν αββα ο πατηρ ");
INSERT INTO grcmt_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","αυτο το πνευμα συμμαρτυρει τω πνευματι ημων οτι εσμεν τεκνα θεου ");
INSERT INTO grcmt_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ει δε τεκνα και κληρονομοι κληρονομοι μεν θεου συγκληρονομοι δε χριστου ειπερ συμπασχομεν ινα και συνδοξασθωμεν ");
INSERT INTO grcmt_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","λογιζομαι γαρ οτι ουκ αξια τα παθηματα του νυν καιρου προσ την μελλουσαν δοξαν αποκαλυφθηναι εισ ημασ ");
INSERT INTO grcmt_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","η γαρ αποκαραδοκια τησ κτισεωσ την αποκαλυψιν των υιων του θεου απεκδεχεται ");
INSERT INTO grcmt_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","τη γαρ ματαιοτητι η κτισισ υπεταγη ουχ εκουσα αλλα δια τον υποταξαντα επ ελπιδι ");
INSERT INTO grcmt_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","οτι και αυτη η κτισισ ελευθερωθησεται απο τησ δουλειασ τησ φθορασ εισ την ελευθεριαν τησ δοξησ των τεκνων του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","οιδαμεν γαρ οτι πασα η κτισισ συστεναζει και συνωδινει αχρι του νυν ");
INSERT INTO grcmt_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ου μονον δε αλλα και αυτοι την απαρχην του πνευματοσ εχοντεσ και ημεισ αυτοι εν εαυτοισ στεναζομεν υιοθεσιαν απεκδεχομενοι την απολυτρωσιν του σωματοσ ημων ");
INSERT INTO grcmt_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","τη γαρ ελπιδι εσωθημεν ελπισ δε βλεπομενη ουκ εστιν ελπισ ο γαρ βλεπει τισ τι και ελπιζει ");
INSERT INTO grcmt_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ει δε ο ου βλεπομεν ελπιζομεν δι υπομονησ απεκδεχομεθα ");
INSERT INTO grcmt_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ωσαυτωσ δε και το πνευμα συναντιλαμβανεται ταισ ασθενειαισ ημων το γαρ τι προσευξομεθα καθο δει ουκ οιδαμεν αλλ αυτο το πνευμα υπερεντυγχανει υπερ ημων στεναγμοισ αλαλητοισ ");
INSERT INTO grcmt_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ο δε ερευνων τασ καρδιασ οιδεν τι το φρονημα του πνευματοσ οτι κατα θεον εντυγχανει υπερ αγιων ");
INSERT INTO grcmt_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","οιδαμεν δε οτι τοισ αγαπωσιν τον θεον παντα 3956 A-APN συνεργει εισ αγαθον τοισ κατα προθεσιν κλητοισ ουσιν ");
INSERT INTO grcmt_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","οτι ουσ προεγνω και προωρισεν συμμορφουσ τησ εικονοσ του υιου αυτου εισ το ειναι αυτον πρωτοτοκον εν πολλοισ αδελφοισ ");
INSERT INTO grcmt_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ουσ δε προωρισεν τουτουσ και εκαλεσεν και ουσ εκαλεσεν τουτουσ και εδικαιωσεν ουσ δε εδικαιωσεν τουτουσ και εδοξασεν ");
INSERT INTO grcmt_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","τι ουν ερουμεν προσ ταυτα ει ο θεοσ υπερ ημων τισ καθ ημων ");
INSERT INTO grcmt_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","οσ γε του ιδιου υιου ουκ εφεισατο αλλ υπερ ημων παντων παρεδωκεν αυτον πωσ ουχι και συν αυτω τα παντα ημιν χαρισεται ");
INSERT INTO grcmt_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","τισ εγκαλεσει κατα εκλεκτων θεου θεοσ ο δικαιων ");
INSERT INTO grcmt_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","τισ ο κατακρινων χριστοσ ο αποθανων μαλλον δε και εγερθεισ οσ και εστιν εν δεξια του θεου οσ και εντυγχανει υπερ ημων ");
INSERT INTO grcmt_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","τισ ημασ χωρισει απο τησ αγαπησ του χριστου θλιψισ η στενοχωρια η διωγμοσ η λιμοσ η γυμνοτησ η κινδυνοσ η μαχαιρα ");
INSERT INTO grcmt_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","καθωσ γεγραπται οτι ενεκεν σου θανατουμεθα ολην την ημεραν ελογισθημεν ωσ προβατα σφαγησ ");
INSERT INTO grcmt_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","αλλ εν τουτοισ πασιν υπερνικωμεν δια του αγαπησαντοσ ημασ ");
INSERT INTO grcmt_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","πεπεισμαι γαρ οτι ουτε θανατοσ ουτε ζωη ουτε αγγελοι ουτε αρχαι ουτε δυναμεισ ουτε ενεστωτα ουτε μελλοντα ");
INSERT INTO grcmt_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ουτε υψωμα ουτε βαθοσ ουτε τισ κτισισ ετερα δυνησεται ημασ χωρισαι απο τησ αγαπησ του θεου τησ εν χριστω ιησου τω κυριω ημων ");
INSERT INTO grcmt_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","αληθειαν λεγω εν χριστω ου ψευδομαι συμμαρτυρουσησ μοι τησ συνειδησεωσ μου εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","οτι λυπη μοι εστιν μεγαλη και αδιαλειπτοσ οδυνη τη καρδια μου ");
INSERT INTO grcmt_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ευχομην γαρ αυτοσ εγω αναθεμα ειναι απο του χριστου υπερ των αδελφων μου των συγγενων μου κατα σαρκα ");
INSERT INTO grcmt_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","οιτινεσ εισιν ισραηλιται ων η υιοθεσια και η δοξα και αι διαθηκαι και η νομοθεσια και η λατρεια και αι επαγγελιαι ");
INSERT INTO grcmt_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ων οι πατερεσ και εξ ων ο χριστοσ το κατα σαρκα ο ων επι παντων θεοσ ευλογητοσ εισ τουσ αιωνασ αμην ");
INSERT INTO grcmt_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ουχ οιον δε οτι εκπεπτωκεν ο λογοσ του θεου ου γαρ παντεσ οι εξ ισραηλ ουτοι ισραηλ ");
INSERT INTO grcmt_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ουδ οτι εισιν σπερμα αβρααμ παντεσ τεκνα αλλ εν ισαακ κληθησεται σοι σπερμα ");
INSERT INTO grcmt_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","τουτ εστιν ου τα τεκνα τησ σαρκοσ ταυτα τεκνα του θεου αλλα τα τεκνα τησ επαγγελιασ λογιζεται εισ σπερμα ");
INSERT INTO grcmt_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","επαγγελιασ γαρ ο λογοσ ουτοσ κατα τον καιρον τουτον ελευσομαι και εσται τη σαρρα υιοσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ου μονον δε αλλα και ρεβεκκα εξ ενοσ κοιτην εχουσα ισαακ του πατροσ ημων ");
INSERT INTO grcmt_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","μηπω γαρ γεννηθεντων μηδε πραξαντων τι αγαθον η κακον ινα η κατ εκλογην προθεσισ του θεου μενη ουκ εξ εργων αλλ εκ του καλουντοσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ερρηθη αυτη οτι ο μειζων δουλευσει τω ελασσονι ");
INSERT INTO grcmt_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","καθωσ γεγραπται τον ιακωβ ηγαπησα τον δε ησαυ εμισησα ");
INSERT INTO grcmt_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","τι ουν ερουμεν μη αδικια παρα τω θεω μη γενοιτο ");
INSERT INTO grcmt_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","τω γαρ μωυση λεγει ελεησω ον αν ελεω και οικτειρησω ον αν οικτειρω ");
INSERT INTO grcmt_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","αρα ουν ου του θελοντοσ ουδε του τρεχοντοσ αλλα του ελεουντοσ θεου ");
INSERT INTO grcmt_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","λεγει γαρ η γραφη τω φαραω οτι εισ αυτο τουτο εξηγειρα σε οπωσ ενδειξωμαι εν σοι την δυναμιν μου και οπωσ διαγγελη το ονομα μου εν παση τη γη ");
INSERT INTO grcmt_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","αρα ουν ον θελει ελεει ον δε θελει σκληρυνει ");
INSERT INTO grcmt_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ερεισ ουν μοι τι ετι μεμφεται τω γαρ βουληματι αυτου τισ ανθεστηκεν ");
INSERT INTO grcmt_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","μενουνγε ω ανθρωπε συ τισ ει ο ανταποκρινομενοσ τω θεω μη ερει το πλασμα τω πλασαντι τι με εποιησασ ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","η ουκ εχει εξουσιαν ο κεραμευσ του πηλου εκ του αυτου φυραματοσ ποιησαι ο μεν εισ τιμην σκευοσ ο δε εισ ατιμιαν ");
INSERT INTO grcmt_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ει δε θελων ο θεοσ ενδειξασθαι την οργην και γνωρισαι το δυνατον αυτου ηνεγκεν εν πολλη μακροθυμια σκευη οργησ κατηρτισμενα εισ απωλειαν ");
INSERT INTO grcmt_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","και ινα γνωριση τον πλουτον τησ δοξησ αυτου επι σκευη ελεουσ α προητοιμασεν εισ δοξαν ");
INSERT INTO grcmt_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ουσ και εκαλεσεν ημασ ου μονον εξ ιουδαιων αλλα και εξ εθνων ");
INSERT INTO grcmt_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ωσ και εν τω ωσηε λεγει καλεσω τον ου λαον μου λαον μου και την ουκ ηγαπημενην ηγαπημενην ");
INSERT INTO grcmt_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","και εσται εν τω τοπω ου ερρηθη αυτοισ ου λαοσ μου υμεισ εκει κληθησονται υιοι θεου ζωντοσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ησαιασ δε κραζει υπερ του ισραηλ εαν η ο αριθμοσ των υιων ισραηλ ωσ η αμμοσ τησ θαλασσησ το καταλειμμα σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","λογον γαρ συντελων και συντεμνων εν δικαιοσυνη οτι λογον συντετμημενον ποιησει κυριοσ επι τησ γησ ");
INSERT INTO grcmt_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","και καθωσ προειρηκεν ησαιασ ει μη κυριοσ σαβαωθ εγκατελιπεν ημιν σπερμα ωσ σοδομα αν εγενηθημεν και ωσ γομορρα αν ωμοιωθημεν ");
INSERT INTO grcmt_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","τι ουν ερουμεν οτι εθνη τα μη διωκοντα δικαιοσυνην κατελαβεν δικαιοσυνην δικαιοσυνην δε την εκ πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ισραηλ δε διωκων νομον δικαιοσυνησ εισ νομον δικαιοσυνησ ουκ εφθασεν ");
INSERT INTO grcmt_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","δια τι οτι ουκ εκ πιστεωσ αλλ ωσ εξ εργων νομου προσεκοψαν γαρ τω λιθω του προσκομματοσ ");
INSERT INTO grcmt_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","καθωσ γεγραπται ιδου τιθημι εν σιων λιθον προσκομματοσ και πετραν σκανδαλου και πασ ο πιστευων επ αυτω ου καταισχυνθησεται ");
INSERT INTO grcmt_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","αδελφοι η μεν ευδοκια τησ εμησ καρδιασ και η δεησισ η προσ τον θεον υπερ του ισραηλ εστιν εισ σωτηριαν ");
INSERT INTO grcmt_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","μαρτυρω γαρ αυτοισ οτι ζηλον θεου εχουσιν αλλ ου κατ επιγνωσιν ");
INSERT INTO grcmt_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","αγνοουντεσ γαρ την του θεου δικαιοσυνην και την ιδιαν δικαιοσυνην ζητουντεσ στησαι τη δικαιοσυνη του θεου ουχ υπεταγησαν ");
INSERT INTO grcmt_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","τελοσ γαρ νομου χριστοσ εισ δικαιοσυνην παντι τω πιστευοντι ");
INSERT INTO grcmt_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","μωυσησ γαρ γραφει την δικαιοσυνην την εκ του νομου οτι ο ποιησασ αυτα ανθρωποσ ζησεται εν αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","η δε εκ πιστεωσ δικαιοσυνη ουτωσ λεγει μη ειπησ εν τη καρδια σου τισ αναβησεται εισ τον ουρανον τουτ εστιν χριστον καταγαγειν ");
INSERT INTO grcmt_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","η τισ καταβησεται εισ την αβυσσον τουτ εστιν χριστον εκ νεκρων αναγαγειν ");
INSERT INTO grcmt_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","αλλα τι λεγει εγγυσ σου το ρημα εστιν εν τω στοματι σου και εν τη καρδια σου τουτ εστιν το ρημα τησ πιστεωσ ο κηρυσσομεν ");
INSERT INTO grcmt_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","οτι εαν ομολογησησ εν τω στοματι σου κυριον ιησουν και πιστευσησ εν τη καρδια σου οτι ο θεοσ αυτον ηγειρεν εκ νεκρων σωθηση ");
INSERT INTO grcmt_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","καρδια γαρ πιστευεται εισ δικαιοσυνην στοματι δε ομολογειται εισ σωτηριαν ");
INSERT INTO grcmt_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","λεγει γαρ η γραφη πασ ο πιστευων επ αυτω ου καταισχυνθησεται ");
INSERT INTO grcmt_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ου γαρ εστιν διαστολη ιουδαιου τε και ελληνοσ ο γαρ αυτοσ κυριοσ παντων πλουτων εισ παντασ τουσ επικαλουμενουσ αυτον ");
INSERT INTO grcmt_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","πασ γαρ οσ αν επικαλεσηται το ονομα κυριου σωθησεται ");
INSERT INTO grcmt_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","πωσ ουν επικαλεσονται εισ ον ουκ επιστευσαν πωσ δε πιστευσουσιν ου ουκ ηκουσαν πωσ δε ακουσουσιν χωρισ κηρυσσοντοσ ");
INSERT INTO grcmt_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","πωσ δε κηρυξουσιν εαν μη αποσταλωσιν καθωσ γεγραπται ωσ ωραιοι οι ποδεσ των ευαγγελιζομενων ειρηνην των ευαγγελιζομενων τα αγαθα ");
INSERT INTO grcmt_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","αλλ ου παντεσ υπηκουσαν τω ευαγγελιω ησαιασ γαρ λεγει κυριε τισ επιστευσεν τη ακοη ημων ");
INSERT INTO grcmt_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","αρα η πιστισ εξ ακοησ η δε ακοη δια ρηματοσ θεου ");
INSERT INTO grcmt_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","αλλα λεγω μη ουκ ηκουσαν μενουνγε εισ πασαν την γην εξηλθεν ο φθογγοσ αυτων και εισ τα περατα τησ οικουμενησ τα ρηματα αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","αλλα λεγω μη ουκ εγνω ισραηλ πρωτοσ μωυσησ λεγει εγω παραζηλωσω υμασ επ ουκ εθνει επι εθνει ασυνετω παροργιω υμασ ");
INSERT INTO grcmt_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ησαιασ δε αποτολμα και λεγει ευρεθην τοισ εμε μη ζητουσιν εμφανησ εγενομην τοισ εμε μη επερωτωσιν ");
INSERT INTO grcmt_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","προσ δε τον ισραηλ λεγει ολην την ημεραν εξεπετασα τασ χειρασ μου προσ λαον απειθουντα και αντιλεγοντα ");
INSERT INTO grcmt_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","λεγω ουν μη απωσατο ο θεοσ τον λαον αυτου μη γενοιτο και γαρ εγω ισραηλιτησ ειμι εκ σπερματοσ αβρααμ φυλησ βενιαμιν ");
INSERT INTO grcmt_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ουκ απωσατο ο θεοσ τον λαον αυτου ον προεγνω η ουκ οιδατε εν ηλια τι λεγει η γραφη ωσ εντυγχανει τω θεω κατα του ισραηλ λεγων ");
INSERT INTO grcmt_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","κυριε τουσ προφητασ σου απεκτειναν και τα θυσιαστηρια σου κατεσκαψαν καγω υπελειφθην μονοσ και ζητουσιν την ψυχην μου ");
INSERT INTO grcmt_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","αλλα τι λεγει αυτω ο χρηματισμοσ κατελιπον εμαυτω επτακισχιλιουσ ανδρασ οιτινεσ ουκ εκαμψαν γονυ τη βααλ ");
INSERT INTO grcmt_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ουτωσ ουν και εν τω νυν καιρω λειμμα κατ εκλογην χαριτοσ γεγονεν ");
INSERT INTO grcmt_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ει δε χαριτι ουκετι εξ εργων επει η χαρισ ουκετι γινεται χαρισ ει δε εξ εργων ουκετι εστιν χαρισ επει το εργον ουκετι εστιν εργον ");
INSERT INTO grcmt_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","τι ουν ο επιζητει ισραηλ τουτο ουκ επετυχεν η δε εκλογη επετυχεν οι δε λοιποι επωρωθησαν ");
INSERT INTO grcmt_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","καθωσ γεγραπται εδωκεν αυτοισ ο θεοσ πνευμα κατανυξεωσ οφθαλμουσ του μη βλεπειν και ωτα του μη ακουειν εωσ τησ σημερον ημερασ ");
INSERT INTO grcmt_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","και δαυιδ λεγει γενηθητω η τραπεζα αυτων εισ παγιδα και εισ θηραν και εισ σκανδαλον και εισ ανταποδομα αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","σκοτισθητωσαν οι οφθαλμοι αυτων του μη βλεπειν και τον νωτον αυτων δια παντοσ συγκαμψον ");
INSERT INTO grcmt_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","λεγω ουν μη επταισαν ινα πεσωσιν μη γενοιτο αλλα τω αυτων παραπτωματι η σωτηρια τοισ εθνεσιν εισ το παραζηλωσαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ει δε το παραπτωμα αυτων πλουτοσ κοσμου και το ηττημα αυτων πλουτοσ εθνων ποσω μαλλον το πληρωμα αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","υμιν γαρ λεγω τοισ εθνεσιν εφ οσον μεν ειμι εγω εθνων αποστολοσ την διακονιαν μου δοξαζω ");
INSERT INTO grcmt_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ει πωσ παραζηλωσω μου την σαρκα και σωσω τινασ εξ αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ει γαρ η αποβολη αυτων καταλλαγη κοσμου τισ η προσληψισ ει μη ζωη εκ νεκρων ");
INSERT INTO grcmt_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ει δε η απαρχη αγια και το φυραμα και ει η ριζα αγια και οι κλαδοι ");
INSERT INTO grcmt_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ει δε τινεσ των κλαδων εξεκλασθησαν συ δε αγριελαιοσ ων ενεκεντρισθησ εν αυτοισ και συγκοινωνοσ τησ ριζησ και τησ πιοτητοσ τησ ελαιασ εγενου ");
INSERT INTO grcmt_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","μη κατακαυχω των κλαδων ει δε κατακαυχασαι ου συ την ριζαν βασταζεισ αλλ η ριζα σε ");
INSERT INTO grcmt_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ερεισ ουν εξεκλασθησαν κλαδοι ινα εγω εγκεντρισθω ");
INSERT INTO grcmt_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","καλωσ τη απιστια εξεκλασθησαν συ δε τη πιστει εστηκασ μη υψηλοφρονει αλλα φοβου ");
INSERT INTO grcmt_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ει γαρ ο θεοσ των κατα φυσιν κλαδων ουκ εφεισατο μηπωσ ουδε σου φεισεται ");
INSERT INTO grcmt_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ιδε ουν χρηστοτητα και αποτομιαν θεου επι μεν τουσ πεσοντασ αποτομιαν επι δε σε χρηστοτητα εαν επιμεινησ τη χρηστοτητι επει και συ εκκοπηση ");
INSERT INTO grcmt_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","και εκεινοι δε εαν μη επιμεινωσιν τη απιστια εγκεντρισθησονται δυνατοσ γαρ ο θεοσ εστιν παλιν εγκεντρισαι αυτουσ ");
INSERT INTO grcmt_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ει γαρ συ εκ τησ κατα φυσιν εξεκοπησ αγριελαιου και παρα φυσιν ενεκεντρισθησ εισ καλλιελαιον ποσω μαλλον ουτοι οι κατα φυσιν εγκεντρισθησονται τη ιδια ελαια ");
INSERT INTO grcmt_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ου γαρ θελω υμασ αγνοειν αδελφοι το μυστηριον τουτο ινα μη ητε παρ εαυτοισ φρονιμοι οτι πωρωσισ απο μερουσ τω ισραηλ γεγονεν αχρι ου το πληρωμα των εθνων εισελθη ");
INSERT INTO grcmt_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","και ουτωσ πασ ισραηλ σωθησεται καθωσ γεγραπται ηξει εκ σιων ο ρυομενοσ και αποστρεψει ασεβειασ απο ιακωβ ");
INSERT INTO grcmt_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","και αυτη αυτοισ η παρ εμου διαθηκη οταν αφελωμαι τασ αμαρτιασ αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","κατα μεν το ευαγγελιον εχθροι δι υμασ κατα δε την εκλογην αγαπητοι δια τουσ πατερασ ");
INSERT INTO grcmt_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","αμεταμελητα γαρ τα χαρισματα και η κλησισ του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ωσπερ γαρ και υμεισ ποτε ηπειθησατε τω θεω νυν δε ηλεηθητε τη τουτων απειθεια ");
INSERT INTO grcmt_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ουτωσ και ουτοι νυν ηπειθησαν τω υμετερω ελεει ινα και αυτοι ελεηθωσιν ");
INSERT INTO grcmt_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","συνεκλεισεν γαρ ο θεοσ τουσ παντασ εισ απειθειαν ινα τουσ παντασ ελεηση ");
INSERT INTO grcmt_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ω βαθοσ πλουτου και σοφιασ και γνωσεωσ θεου ωσ ανεξερευνητα τα κριματα αυτου και ανεξιχνιαστοι αι οδοι αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","τισ γαρ εγνω νουν κυριου η τισ συμβουλοσ αυτου εγενετο ");
INSERT INTO grcmt_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","η τισ προεδωκεν αυτω και ανταποδοθησεται αυτω ");
INSERT INTO grcmt_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","οτι εξ αυτου και δι αυτου και εισ αυτον τα παντα αυτω η δοξα εισ τουσ αιωνασ αμην ");
INSERT INTO grcmt_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","παρακαλω ουν υμασ αδελφοι δια των οικτιρμων του θεου παραστησαι τα σωματα υμων θυσιαν ζωσαν αγιαν ευαρεστον τω θεω την λογικην λατρειαν υμων ");
INSERT INTO grcmt_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","και μη συσχηματιζεσθαι τω αιωνι τουτω αλλα μεταμορφουσθαι τη ανακαινωσει του νοοσ υμων εισ το δοκιμαζειν υμασ τι το θελημα του θεου το αγαθον και ευαρεστον και τελειον ");
INSERT INTO grcmt_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","λεγω γαρ δια τησ χαριτοσ τησ δοθεισησ μοι παντι τω οντι εν υμιν μη υπερφρονειν παρ ο δει φρονειν αλλα φρονειν εισ το σωφρονειν εκαστω ωσ ο θεοσ εμερισεν μετρον πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","καθαπερ γαρ εν ενι σωματι μελη πολλα εχομεν τα δε μελη παντα ου την αυτην εχει πραξιν ");
INSERT INTO grcmt_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ουτωσ οι πολλοι εν σωμα εσμεν εν χριστω ο δε καθ εισ αλληλων μελη ");
INSERT INTO grcmt_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","εχοντεσ δε χαρισματα κατα την χαριν την δοθεισαν ημιν διαφορα ειτε προφητειαν κατα την αναλογιαν τησ πιστεωσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ειτε διακονιαν εν τη διακονια ειτε ο διδασκων εν τη διδασκαλια ");
INSERT INTO grcmt_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ειτε ο παρακαλων εν τη παρακλησει ο μεταδιδουσ εν απλοτητι ο προισταμενοσ εν σπουδη ο ελεων εν ιλαροτητι ");
INSERT INTO grcmt_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","η αγαπη ανυποκριτοσ αποστυγουντεσ το πονηρον κολλωμενοι τω αγαθω ");
INSERT INTO grcmt_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","τη φιλαδελφια εισ αλληλουσ φιλοστοργοι τη τιμη αλληλουσ προηγουμενοι ");
INSERT INTO grcmt_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","τη σπουδη μη οκνηροι τω πνευματι ζεοντεσ τω κυριω δουλευοντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","τη ελπιδι χαιροντεσ τη θλιψει υπομενοντεσ τη προσευχη προσκαρτερουντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ταισ χρειαισ των αγιων κοινωνουντεσ την φιλοξενιαν διωκοντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ευλογειτε τουσ διωκοντασ υμασ ευλογειτε και μη καταρασθε ");
INSERT INTO grcmt_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","χαιρειν μετα χαιροντων και κλαιειν μετα κλαιοντων ");
INSERT INTO grcmt_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","το αυτο εισ αλληλουσ φρονουντεσ μη τα υψηλα φρονουντεσ αλλα τοισ ταπεινοισ συναπαγομενοι μη γινεσθε φρονιμοι παρ εαυτοισ ");
INSERT INTO grcmt_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","μηδενι κακον αντι κακου αποδιδοντεσ προνοουμενοι καλα ενωπιον παντων ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ει δυνατον το εξ υμων μετα παντων ανθρωπων ειρηνευοντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","μη εαυτουσ εκδικουντεσ αγαπητοι αλλα δοτε τοπον τη οργη γεγραπται γαρ εμοι εκδικησισ εγω ανταποδωσω λεγει κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","εαν ουν πεινα ο εχθροσ σου ψωμιζε αυτον εαν διψα ποτιζε αυτον τουτο γαρ ποιων ανθρακασ πυροσ σωρευσεισ επι την κεφαλην αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","μη νικω υπο του κακου αλλα νικα εν τω αγαθω το κακον ");
INSERT INTO grcmt_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","πασα ψυχη εξουσιαισ υπερεχουσαισ υποτασσεσθω ου γαρ εστιν εξουσια ει μη υπο θεου αι δε ουσαι εξουσιαι υπο του θεου τεταγμεναι εισιν ");
INSERT INTO grcmt_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ωστε ο αντιτασσομενοσ τη εξουσια τη του θεου διαταγη ανθεστηκεν οι δε ανθεστηκοτεσ εαυτοισ κριμα ληψονται ");
INSERT INTO grcmt_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","οι γαρ αρχοντεσ ουκ εισιν φοβοσ των αγαθων εργων αλλα των κακων θελεισ δε μη φοβεισθαι την εξουσιαν το αγαθον ποιει και εξεισ επαινον εξ αυτησ ");
INSERT INTO grcmt_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","θεου γαρ διακονοσ εστιν σοι εισ το αγαθον εαν δε το κακον ποιησ φοβου ου γαρ εικη την μαχαιραν φορει θεου γαρ διακονοσ εστιν εκδικοσ εισ οργην τω το κακον πρασσοντι ");
INSERT INTO grcmt_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","διο αναγκη υποτασσεσθαι ου μονον δια την οργην αλλα και δια την συνειδησιν ");
INSERT INTO grcmt_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","δια τουτο γαρ και φορουσ τελειτε λειτουργοι γαρ θεου εισιν εισ αυτο τουτο προσκαρτερουντεσ ");
INSERT INTO grcmt_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","αποδοτε ουν πασιν τασ οφειλασ τω τον φορον τον φορον τω το τελοσ το τελοσ τω τον φοβον τον φοβον τω την τιμην την τιμην ");
INSERT INTO grcmt_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","μηδενι μηδεν οφειλετε ει μη το αγαπαν αλληλουσ ο γαρ αγαπων τον ετερον νομον πεπληρωκεν ");
INSERT INTO grcmt_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","το γαρ ου μοιχευσεισ ου φονευσεισ ου κλεψεισ ουκ επιθυμησεισ και ει τισ ετερα εντολη εν τουτω τω λογω ανακεφαλαιουται εν τω αγαπησεισ τον πλησιον σου ωσ σεαυτον ");
INSERT INTO grcmt_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","η αγαπη τω πλησιον κακον ουκ εργαζεται πληρωμα ουν νομου η αγαπη ");
INSERT INTO grcmt_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","και τουτο ειδοτεσ τον καιρον οτι ωρα ημασ ηδη εξ υπνου εγερθηναι νυν γαρ εγγυτερον ημων η σωτηρια η οτε επιστευσαμεν ");
INSERT INTO grcmt_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","η νυξ προεκοψεν η δε ημερα ηγγικεν αποθωμεθα ουν τα εργα του σκοτουσ και ενδυσωμεθα τα οπλα του φωτοσ ");
INSERT INTO grcmt_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ωσ εν ημερα ευσχημονωσ περιπατησωμεν μη κωμοισ και μεθαισ μη κοιταισ και ασελγειαισ μη εριδι και ζηλω ");
INSERT INTO grcmt_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","αλλ ενδυσασθε τον κυριον ιησουν χριστον και τησ σαρκοσ προνοιαν μη ποιεισθε εισ επιθυμιασ ");
INSERT INTO grcmt_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","τον δε ασθενουντα τη πιστει προσλαμβανεσθε μη εισ διακρισεισ διαλογισμων ");
INSERT INTO grcmt_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","οσ μεν πιστευει φαγειν παντα ο δε ασθενων λαχανα εσθιει ");
INSERT INTO grcmt_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ο εσθιων τον μη εσθιοντα μη εξουθενειτω και ο μη εσθιων τον εσθιοντα μη κρινετω ο θεοσ γαρ αυτον προσελαβετο ");
INSERT INTO grcmt_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","συ τισ ει ο κρινων αλλοτριον οικετην τω ιδιω κυριω στηκει η πιπτει σταθησεται δε δυνατοσ γαρ εστιν ο θεοσ στησαι αυτον ");
INSERT INTO grcmt_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","οσ μεν κρινει ημεραν παρ ημεραν οσ δε κρινει πασαν ημεραν εκαστοσ εν τω ιδιω νοι πληροφορεισθω ");
INSERT INTO grcmt_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ο φρονων την ημεραν κυριω φρονει και ο μη φρονων την ημεραν κυριω ου φρονει και ο εσθιων κυριω εσθιει ευχαριστει γαρ τω θεω και ο μη εσθιων κυριω ουκ εσθιει και ευχαριστει τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ουδεισ γαρ ημων εαυτω ζη και ουδεισ εαυτω αποθνησκει ");
INSERT INTO grcmt_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","εαν τε γαρ ζωμεν τω κυριω ζωμεν εαν τε αποθνησκωμεν τω κυριω αποθνησκομεν εαν τε ουν ζωμεν εαν τε αποθνησκωμεν του κυριου εσμεν ");
INSERT INTO grcmt_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","εισ τουτο γαρ χριστοσ και απεθανεν και ανεστη και εζησεν ινα και νεκρων και ζωντων κυριευση ");
INSERT INTO grcmt_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","συ δε τι κρινεισ τον αδελφον σου η και συ τι εξουθενεισ τον αδελφον σου παντεσ γαρ παραστησομεθα τω βηματι του χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","γεγραπται γαρ ζω εγω λεγει κυριοσ οτι εμοι καμψει παν γονυ και πασα γλωσσα εξομολογησεται τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","αρα ουν εκαστοσ ημων περι εαυτου λογον δωσει τω θεω ");
INSERT INTO grcmt_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","μηκετι ουν αλληλουσ κρινωμεν αλλα τουτο κρινατε μαλλον το μη τιθεναι προσκομμα τω αδελφω η σκανδαλον ");
INSERT INTO grcmt_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","οιδα και πεπεισμαι εν κυριω ιησου οτι ουδεν κοινον δι αυτου ει μη τω λογιζομενω τι κοινον ειναι εκεινω κοινον ");
INSERT INTO grcmt_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ει δε δια βρωμα ο αδελφοσ σου λυπειται ουκετι κατα αγαπην περιπατεισ μη τω βρωματι σου εκεινον απολλυε υπερ ου χριστοσ απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","μη βλασφημεισθω ουν υμων το αγαθον ");
INSERT INTO grcmt_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ου γαρ εστιν η βασιλεια του θεου βρωσισ και ποσισ αλλα δικαιοσυνη και ειρηνη και χαρα εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ο γαρ εν τουτοισ δουλευων τω χριστω ευαρεστοσ τω θεω και δοκιμοσ τοισ ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","αρα ουν τα τησ ειρηνησ διωκωμεν και τα τησ οικοδομησ τησ εισ αλληλουσ ");
INSERT INTO grcmt_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","μη ενεκεν βρωματοσ καταλυε το εργον του θεου παντα μεν καθαρα αλλα κακον τω ανθρωπω τω δια προσκομματοσ εσθιοντι ");
INSERT INTO grcmt_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","καλον το μη φαγειν κρεα μηδε πιειν οινον μηδε εν ω ο αδελφοσ σου προσκοπτει η σκανδαλιζεται η ασθενει ");
INSERT INTO grcmt_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","συ πιστιν εχεισ κατα σεαυτον εχε ενωπιον του θεου μακαριοσ ο μη κρινων εαυτον εν ω δοκιμαζει ");
INSERT INTO grcmt_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ο δε διακρινομενοσ εαν φαγη κατακεκριται οτι ουκ εκ πιστεωσ παν δε ο ουκ εκ πιστεωσ αμαρτια εστιν ");
INSERT INTO grcmt_vpl VALUES ("RM14_24","075_14_24","ROM","14","24","24","τω δε δυναμενω υμασ στηριξαι κατα το ευαγγελιον μου και το κηρυγμα ιησου χριστου κατα αποκαλυψιν μυστηριου χρονοισ αιωνιοισ σεσιγημενου ");
INSERT INTO grcmt_vpl VALUES ("RM14_25","075_14_25","ROM","14","25","25","φανερωθεντοσ δε νυν δια τε γραφων προφητικων κατ επιταγην του αιωνιου θεου εισ υπακοην πιστεωσ εισ παντα τα εθνη γνωρισθεντοσ ");
INSERT INTO grcmt_vpl VALUES ("RM14_26","075_14_26","ROM","14","26","26","μονω σοφω θεω δια ιησου χριστου ω η δοξα εισ τουσ αιωνασ αμην ");
INSERT INTO grcmt_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","οφειλομεν δε ημεισ οι δυνατοι τα ασθενηματα των αδυνατων βασταζειν και μη εαυτοισ αρεσκειν ");
INSERT INTO grcmt_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","εκαστοσ ημων τω πλησιον αρεσκετω εισ το αγαθον προσ οικοδομην ");
INSERT INTO grcmt_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","και γαρ ο χριστοσ ουχ εαυτω ηρεσεν αλλα καθωσ γεγραπται οι ονειδισμοι των ονειδιζοντων σε επεπεσον επ εμε ");
INSERT INTO grcmt_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","οσα γαρ προεγραφη εισ την ημετεραν διδασκαλιαν προεγραφη ινα δια τησ υπομονησ και δια τησ παρακλησεωσ των γραφων την ελπιδα εχωμεν ");
INSERT INTO grcmt_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ο δε θεοσ τησ υπομονησ και τησ παρακλησεωσ δωη υμιν το αυτο φρονειν εν αλληλοισ κατα χριστον ιησουν ");
INSERT INTO grcmt_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ινα ομοθυμαδον εν ενι στοματι δοξαζητε τον θεον και πατερα του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","διο προσλαμβανεσθε αλληλουσ καθωσ και ο χριστοσ προσελαβετο υμασ εισ δοξαν θεου ");
INSERT INTO grcmt_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","λεγω δε χριστον ιησουν διακονον γεγενησθαι περιτομησ υπερ αληθειασ θεου εισ το βεβαιωσαι τασ επαγγελιασ των πατερων ");
INSERT INTO grcmt_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","τα δε εθνη υπερ ελεουσ δοξασαι τον θεον καθωσ γεγραπται δια τουτο εξομολογησομαι σοι εν εθνεσιν και τω ονοματι σου ψαλω ");
INSERT INTO grcmt_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","και παλιν λεγει ευφρανθητε εθνη μετα του λαου αυτου ");
INSERT INTO grcmt_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","και παλιν αινειτε τον κυριον παντα τα εθνη και επαινεσατε αυτον παντεσ οι λαοι ");
INSERT INTO grcmt_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","και παλιν ησαιασ λεγει εσται η ριζα του ιεσσαι και ο ανισταμενοσ αρχειν εθνων επ αυτω εθνη ελπιουσιν ");
INSERT INTO grcmt_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ο δε θεοσ τησ ελπιδοσ πληρωσαι υμασ πασησ χαρασ και ειρηνησ εν τω πιστευειν εισ το περισσευειν υμασ εν τη ελπιδι εν δυναμει πνευματοσ αγιου ");
INSERT INTO grcmt_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","πεπεισμαι δε αδελφοι μου και αυτοσ εγω περι υμων οτι και αυτοι μεστοι εστε αγαθωσυνησ πεπληρωμενοι πασησ γνωσεωσ δυναμενοι και αλλουσ νουθετειν ");
INSERT INTO grcmt_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","τολμηροτερον δε εγραψα υμιν αδελφοι απο μερουσ ωσ επαναμιμνησκων υμασ δια την χαριν την δοθεισαν μοι υπο του θεου ");
INSERT INTO grcmt_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","εισ το ειναι με λειτουργον ιησου χριστου εισ τα εθνη ιερουργουντα το ευαγγελιον του θεου ινα γενηται η προσφορα των εθνων ευπροσδεκτοσ ηγιασμενη εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","εχω ουν καυχησιν εν χριστω ιησου τα προσ τον θεον ");
INSERT INTO grcmt_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ου γαρ τολμησω λαλειν τι ων ου κατειργασατο χριστοσ δι εμου εισ υπακοην εθνων λογω και εργω ");
INSERT INTO grcmt_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","εν δυναμει σημειων και τερατων εν δυναμει πνευματοσ θεου ωστε με απο ιερουσαλημ και κυκλω μεχρι του ιλλυρικου πεπληρωκεναι το ευαγγελιον του χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ουτωσ δε φιλοτιμουμενον ευαγγελιζεσθαι ουχ οπου ωνομασθη χριστοσ ινα μη επ αλλοτριον θεμελιον οικοδομω ");
INSERT INTO grcmt_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","αλλα καθωσ γεγραπται οισ ουκ ανηγγελη περι αυτου οψονται και οι ουκ ακηκοασιν συνησουσιν ");
INSERT INTO grcmt_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","διο και ενεκοπτομην τα πολλα του ελθειν προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","νυνι δε μηκετι τοπον εχων εν τοισ κλιμασιν τουτοισ επιποθιαν δε εχων του ελθειν προσ υμασ απο πολλων ετων ");
INSERT INTO grcmt_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ωσ εαν πορευωμαι εισ την σπανιαν ελευσομαι προσ υμασ ελπιζω γαρ διαπορευομενοσ θεασασθαι υμασ και υφ υμων προπεμφθηναι εκει εαν υμων πρωτον απο μερουσ εμπλησθω ");
INSERT INTO grcmt_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","νυνι δε πορευομαι εισ ιερουσαλημ διακονων τοισ αγιοισ ");
INSERT INTO grcmt_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ευδοκησαν γαρ μακεδονια και αχαια κοινωνιαν τινα ποιησασθαι εισ τουσ πτωχουσ των αγιων των εν ιερουσαλημ ");
INSERT INTO grcmt_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ευδοκησαν γαρ και οφειλεται αυτων εισιν ει γαρ τοισ πνευματικοισ αυτων εκοινωνησαν τα εθνη οφειλουσιν και εν τοισ σαρκικοισ λειτουργησαι αυτοισ ");
INSERT INTO grcmt_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","τουτο ουν επιτελεσασ και σφραγισαμενοσ αυτοισ τον καρπον τουτον απελευσομαι δι υμων εισ την σπανιαν ");
INSERT INTO grcmt_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","οιδα δε οτι ερχομενοσ προσ υμασ εν πληρωματι ευλογιασ του ευαγγελιου του χριστου ελευσομαι ");
INSERT INTO grcmt_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","παρακαλω δε υμασ αδελφοι δια του κυριου ημων ιησου χριστου και δια τησ αγαπησ του πνευματοσ συναγωνισασθαι μοι εν ταισ προσευχαισ υπερ εμου προσ τον θεον ");
INSERT INTO grcmt_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ινα ρυσθω απο των απειθουντων εν τη ιουδαια και ινα η διακονια μου η εισ ιερουσαλημ ευπροσδεκτοσ γενηται τοισ αγιοισ ");
INSERT INTO grcmt_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ινα εν χαρα ελθω προσ υμασ δια θεληματοσ θεου και συναναπαυσωμαι υμιν ");
INSERT INTO grcmt_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ο δε θεοσ τησ ειρηνησ μετα παντων υμων αμην ");
INSERT INTO grcmt_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","συνιστημι δε υμιν φοιβην την αδελφην ημων ουσαν διακονον τησ εκκλησιασ τησ εν κεγχρεαισ ");
INSERT INTO grcmt_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ινα αυτην προσδεξησθε εν κυριω αξιωσ των αγιων και παραστητε αυτη εν ω αν υμων χρηζη πραγματι και γαρ αυτη προστατισ πολλων εγενηθη και αυτου εμου ");
INSERT INTO grcmt_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ασπασασθε πρισκαν και ακυλαν τουσ συνεργουσ μου εν χριστω ιησου ");
INSERT INTO grcmt_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","οιτινεσ υπερ τησ ψυχησ μου τον εαυτων τραχηλον υπεθηκαν οισ ουκ εγω μονοσ ευχαριστω αλλα και πασαι αι εκκλησιαι των εθνων ");
INSERT INTO grcmt_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","και την κατ οικον αυτων εκκλησιαν ασπασασθε επαινετον τον αγαπητον μου οσ εστιν απαρχη τησ αχαιασ εισ χριστον ");
INSERT INTO grcmt_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ασπασασθε μαριαμ ητισ πολλα εκοπιασεν εισ ημασ ");
INSERT INTO grcmt_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ασπασασθε ανδρονικον και ιουνιαν τουσ συγγενεισ μου και συναιχμαλωτουσ μου οιτινεσ εισιν επισημοι εν τοισ αποστολοισ οι και προ εμου γεγονασιν εν χριστω ");
INSERT INTO grcmt_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ασπασασθε αμπλιαν τον αγαπητον μου εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ασπασασθε ουρβανον τον συνεργον ημων εν χριστω και σταχυν τον αγαπητον μου ");
INSERT INTO grcmt_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ασπασασθε απελλην τον δοκιμον εν χριστω ασπασασθε τουσ εκ των αριστοβουλου ");
INSERT INTO grcmt_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ασπασασθε ηρωδιωνα τον συγγενη μου ασπασασθε τουσ εκ των ναρκισσου τουσ οντασ εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ασπασασθε τρυφαιναν και τρυφωσαν τασ κοπιωσασ εν κυριω ασπασασθε περσιδα την αγαπητην ητισ πολλα εκοπιασεν εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ασπασασθε ρουφον τον εκλεκτον εν κυριω και την μητερα αυτου και εμου ");
INSERT INTO grcmt_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ασπασασθε ασυγκριτον φλεγοντα ερμαν πατροβαν ερμην και τουσ συν αυτοισ αδελφουσ ");
INSERT INTO grcmt_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ασπασασθε φιλολογον και ιουλιαν νηρεα και την αδελφην αυτου και ολυμπαν και τουσ συν αυτοισ παντασ αγιουσ ");
INSERT INTO grcmt_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ασπασασθε αλληλουσ εν φιληματι αγιω ασπαζονται υμασ αι εκκλησιαι του χριστου ");
INSERT INTO grcmt_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","παρακαλω δε υμασ αδελφοι σκοπειν τουσ τασ διχοστασιασ και τα σκανδαλα παρα την διδαχην ην υμεισ εμαθετε ποιουντασ και εκκλινατε απ αυτων ");
INSERT INTO grcmt_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","οι γαρ τοιουτοι τω κυριω ημων ιησου χριστω ου δουλευουσιν αλλα τη εαυτων κοιλια και δια τησ χρηστολογιασ και ευλογιασ εξαπατωσιν τασ καρδιασ των ακακων ");
INSERT INTO grcmt_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","η γαρ υμων υπακοη εισ παντασ αφικετο χαιρω ουν το εφ υμιν θελω δε υμασ σοφουσ μεν ειναι εισ το αγαθον ακεραιουσ δε εισ το κακον ");
INSERT INTO grcmt_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ο δε θεοσ τησ ειρηνησ συντριψει τον σαταναν υπο τουσ ποδασ υμων εν ταχει η χαρισ του κυριου ημων ιησου χριστου μεθ υμων ");
INSERT INTO grcmt_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ασπαζονται υμασ τιμοθεοσ ο συνεργοσ μου και λουκιοσ και ιασων και σωσιπατροσ οι συγγενεισ μου ");
INSERT INTO grcmt_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ασπαζομαι υμασ εγω τερτιοσ ο γραψασ την επιστολην εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ασπαζεται υμασ γαιοσ ο ξενοσ μου και τησ εκκλησιασ ολησ ασπαζεται υμασ εραστοσ ο οικονομοσ τησ πολεωσ και κουαρτοσ ο αδελφοσ ");
INSERT INTO grcmt_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","η χαρισ του κυριου ημων ιησου χριστου μετα παντων υμων αμην ");
INSERT INTO grcmt_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","παυλοσ κλητοσ αποστολοσ ιησου χριστου δια θεληματοσ θεου και σωσθενησ ο αδελφοσ ");
INSERT INTO grcmt_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","τη εκκλησια του θεου τη ουση εν κορινθω ηγιασμενοισ εν χριστω ιησου κλητοισ αγιοισ συν πασιν τοισ επικαλουμενοισ το ονομα του κυριου ημων ιησου χριστου εν παντι τοπω αυτων τε και ημων ");
INSERT INTO grcmt_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","χαρισ υμιν και ειρηνη απο θεου πατροσ ημων και κυριου ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ευχαριστω τω θεω μου παντοτε περι υμων επι τη χαριτι του θεου τη δοθειση υμιν εν χριστω ιησου ");
INSERT INTO grcmt_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","οτι εν παντι επλουτισθητε εν αυτω εν παντι λογω και παση γνωσει ");
INSERT INTO grcmt_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","καθωσ το μαρτυριον του χριστου εβεβαιωθη εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ωστε υμασ μη υστερεισθαι εν μηδενι χαρισματι απεκδεχομενουσ την αποκαλυψιν του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","οσ και βεβαιωσει υμασ εωσ τελουσ ανεγκλητουσ εν τη ημερα του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","πιστοσ ο θεοσ δι ου εκληθητε εισ κοινωνιαν του υιου αυτου ιησου χριστου του κυριου ημων ");
INSERT INTO grcmt_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","παρακαλω δε υμασ αδελφοι δια του ονοματοσ του κυριου ημων ιησου χριστου ινα το αυτο λεγητε παντεσ και μη η εν υμιν σχισματα ητε δε κατηρτισμενοι εν τω αυτω νοι και εν τη αυτη γνωμη ");
INSERT INTO grcmt_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","εδηλωθη γαρ μοι περι υμων αδελφοι μου υπο των χλοησ οτι εριδεσ εν υμιν εισιν ");
INSERT INTO grcmt_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","λεγω δε τουτο οτι εκαστοσ υμων λεγει εγω μεν ειμι παυλου εγω δε απολλω εγω δε κηφα εγω δε χριστου ");
INSERT INTO grcmt_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","μεμερισται ο χριστοσ μη παυλοσ εσταυρωθη υπερ υμων η εισ το ονομα παυλου εβαπτισθητε ");
INSERT INTO grcmt_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ευχαριστω τω θεω οτι ουδενα υμων εβαπτισα ει μη κρισπον και γαιον ");
INSERT INTO grcmt_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ινα μη τισ ειπη οτι εισ το εμον ονομα εβαπτισα ");
INSERT INTO grcmt_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","εβαπτισα δε και τον στεφανα οικον λοιπον ουκ οιδα ει τινα αλλον εβαπτισα ");
INSERT INTO grcmt_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ου γαρ απεστειλεν με χριστοσ βαπτιζειν αλλ ευαγγελιζεσθαι ουκ εν σοφια λογου ινα μη κενωθη ο σταυροσ του χριστου ");
INSERT INTO grcmt_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ο λογοσ γαρ ο του σταυρου τοισ μεν απολλυμενοισ μωρια εστιν τοισ δε σωζομενοισ ημιν δυναμισ θεου εστιν ");
INSERT INTO grcmt_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","γεγραπται γαρ απολω την σοφιαν των σοφων και την συνεσιν των συνετων αθετησω ");
INSERT INTO grcmt_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","που σοφοσ που γραμματευσ που συζητητησ του αιωνοσ τουτου ουχι εμωρανεν ο θεοσ την σοφιαν του κοσμου τουτου ");
INSERT INTO grcmt_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","επειδη γαρ εν τη σοφια του θεου ουκ εγνω ο κοσμοσ δια τησ σοφιασ τον θεον ευδοκησεν ο θεοσ δια τησ μωριασ του κηρυγματοσ σωσαι τουσ πιστευοντασ ");
INSERT INTO grcmt_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","επειδη και ιουδαιοι σημειον αιτουσιν και ελληνεσ σοφιαν ζητουσιν ");
INSERT INTO grcmt_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ημεισ δε κηρυσσομεν χριστον εσταυρωμενον ιουδαιοισ μεν σκανδαλον ελλησιν δε μωριαν ");
INSERT INTO grcmt_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","αυτοισ δε τοισ κλητοισ ιουδαιοισ τε και ελλησιν χριστον θεου δυναμιν και θεου σοφιαν ");
INSERT INTO grcmt_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","οτι το μωρον του θεου σοφωτερον των ανθρωπων εστιν και το ασθενεσ του θεου ισχυροτερον των ανθρωπων εστιν ");
INSERT INTO grcmt_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","βλεπετε γαρ την κλησιν υμων αδελφοι οτι ου πολλοι σοφοι κατα σαρκα ου πολλοι δυνατοι ου πολλοι ευγενεισ ");
INSERT INTO grcmt_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","αλλα τα μωρα του κοσμου εξελεξατο ο θεοσ ινα τουσ σοφουσ καταισχυνη και τα ασθενη του κοσμου εξελεξατο ο θεοσ ινα καταισχυνη τα ισχυρα ");
INSERT INTO grcmt_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","και τα αγενη του κοσμου και τα εξουθενημενα εξελεξατο ο θεοσ και τα μη οντα ινα τα οντα καταργηση ");
INSERT INTO grcmt_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","οπωσ μη καυχησηται πασα σαρξ ενωπιον του θεου ");
INSERT INTO grcmt_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","εξ αυτου δε υμεισ εστε εν χριστω ιησου οσ εγενηθη ημιν σοφια απο θεου δικαιοσυνη τε και αγιασμοσ και απολυτρωσισ ");
INSERT INTO grcmt_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ινα καθωσ γεγραπται ο καυχωμενοσ εν κυριω καυχασθω ");
INSERT INTO grcmt_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","καγω ελθων προσ υμασ αδελφοι ηλθον ου καθ υπεροχην λογου η σοφιασ καταγγελλων υμιν το μαρτυριον του θεου ");
INSERT INTO grcmt_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ου γαρ εκρινα του ειδεναι τι εν υμιν ει μη ιησουν χριστον και τουτον εσταυρωμενον ");
INSERT INTO grcmt_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","και εγω εν ασθενεια και εν φοβω και εν τρομω πολλω εγενομην προσ υμασ ");
INSERT INTO grcmt_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","και ο λογοσ μου και το κηρυγμα μου ουκ εν πειθοισ ανθρωπινησ σοφιασ λογοισ αλλ εν αποδειξει πνευματοσ και δυναμεωσ ");
INSERT INTO grcmt_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ινα η πιστισ υμων μη η εν σοφια ανθρωπων αλλ εν δυναμει θεου ");
INSERT INTO grcmt_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","σοφιαν δε λαλουμεν εν τοισ τελειοισ σοφιαν δε ου του αιωνοσ τουτου ουδε των αρχοντων του αιωνοσ τουτου των καταργουμενων ");
INSERT INTO grcmt_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","αλλα λαλουμεν σοφιαν θεου εν μυστηριω την αποκεκρυμμενην ην προωρισεν ο θεοσ προ των αιωνων εισ δοξαν ημων ");
INSERT INTO grcmt_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ην ουδεισ των αρχοντων του αιωνοσ τουτου εγνωκεν ει γαρ εγνωσαν ουκ αν τον κυριον τησ δοξησ εσταυρωσαν ");
INSERT INTO grcmt_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","αλλα καθωσ γεγραπται α οφθαλμοσ ουκ ειδεν και ουσ ουκ ηκουσεν και επι καρδιαν ανθρωπου ουκ ανεβη α ητοιμασεν ο θεοσ τοισ αγαπωσιν αυτον ");
INSERT INTO grcmt_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ημιν δε ο θεοσ απεκαλυψεν δια του πνευματοσ αυτου το γαρ πνευμα παντα ερευνα και τα βαθη του θεου ");
INSERT INTO grcmt_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","τισ γαρ οιδεν ανθρωπων τα του ανθρωπου ει μη το πνευμα του ανθρωπου το εν αυτω ουτωσ και τα του θεου ουδεισ οιδεν ει μη το πνευμα του θεου ");
INSERT INTO grcmt_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ημεισ δε ου το πνευμα του κοσμου ελαβομεν αλλα το πνευμα το εκ του θεου ινα ειδωμεν τα υπο του θεου χαρισθεντα ημιν ");
INSERT INTO grcmt_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","α και λαλουμεν ουκ εν διδακτοισ ανθρωπινησ σοφιασ λογοισ αλλ εν διδακτοισ πνευματοσ αγιου πνευματικοισ 4152 A-DPN πνευματικα συγκρινοντεσ ");
INSERT INTO grcmt_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ψυχικοσ δε ανθρωποσ ου δεχεται τα του πνευματοσ του θεου μωρια γαρ αυτω εστιν και ου δυναται γνωναι οτι πνευματικωσ ανακρινεται ");
INSERT INTO grcmt_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ο δε πνευματικοσ ανακρινει μεν παντα αυτοσ δε υπ ουδενοσ ανακρινεται ");
INSERT INTO grcmt_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","τισ γαρ εγνω νουν κυριου οσ συμβιβασει αυτον ημεισ δε νουν χριστου εχομεν ");
INSERT INTO grcmt_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","και εγω αδελφοι ουκ ηδυνηθην υμιν λαλησαι ωσ πνευματικοισ αλλ ωσ σαρκικοισ ωσ νηπιοισ εν χριστω ");
INSERT INTO grcmt_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","γαλα υμασ εποτισα και ου βρωμα ουπω γαρ εδυνασθε αλλ ουτε ετι νυν δυνασθε ");
INSERT INTO grcmt_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ετι γαρ σαρκικοι εστε οπου γαρ εν υμιν ζηλοσ και ερισ και διχοστασιαι ουχι σαρκικοι εστε και κατα ανθρωπον περιπατειτε ");
INSERT INTO grcmt_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","οταν γαρ λεγη τισ εγω μεν ειμι παυλου ετεροσ δε εγω απολλω ουχι σαρκικοι εστε ");
INSERT INTO grcmt_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","τισ ουν εστιν παυλοσ τισ δε απολλωσ αλλ η διακονοι δι ων επιστευσατε και εκαστω ωσ ο κυριοσ εδωκεν ");
INSERT INTO grcmt_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","εγω εφυτευσα απολλωσ εποτισεν αλλ ο θεοσ ηυξανεν ");
INSERT INTO grcmt_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ωστε ουτε ο φυτευων εστιν τι ουτε ο ποτιζων αλλ ο αυξανων θεοσ ");
INSERT INTO grcmt_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ο φυτευων δε και ο ποτιζων εν εισιν εκαστοσ δε τον ιδιον μισθον ληψεται κατα τον ιδιον κοπον ");
INSERT INTO grcmt_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","θεου γαρ εσμεν συνεργοι θεου γεωργιον θεου οικοδομη εστε ");
INSERT INTO grcmt_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","κατα την χαριν του θεου την δοθεισαν μοι ωσ σοφοσ αρχιτεκτων θεμελιον τεθεικα αλλοσ δε εποικοδομει εκαστοσ δε βλεπετω πωσ εποικοδομει ");
INSERT INTO grcmt_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","θεμελιον γαρ αλλον ουδεισ δυναται θειναι παρα τον κειμενον οσ εστιν ιησουσ χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ει δε τισ εποικοδομει επι τον θεμελιον τουτον χρυσον αργυρον λιθουσ τιμιουσ ξυλα χορτον καλαμην ");
INSERT INTO grcmt_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","εκαστου το εργον φανερον γενησεται η γαρ ημερα δηλωσει οτι εν πυρι αποκαλυπτεται και εκαστου το εργον οποιον εστιν το πυρ δοκιμασει ");
INSERT INTO grcmt_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ει τινοσ το εργον μενει ο εποικοδομησεν μισθον ληψεται ");
INSERT INTO grcmt_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ει τινοσ το εργον κατακαησεται ζημιωθησεται αυτοσ δε σωθησεται ουτωσ δε ωσ δια πυροσ ");
INSERT INTO grcmt_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ουκ οιδατε οτι ναοσ θεου εστε και το πνευμα του θεου οικει εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ει τισ τον ναον του θεου φθειρει φθερει τουτον ο θεοσ ο γαρ ναοσ του θεου αγιοσ εστιν οιτινεσ εστε υμεισ ");
INSERT INTO grcmt_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","μηδεισ εαυτον εξαπατατω ει τισ δοκει σοφοσ ειναι εν υμιν εν τω αιωνι τουτω μωροσ γενεσθω ινα γενηται σοφοσ ");
INSERT INTO grcmt_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","η γαρ σοφια του κοσμου τουτου μωρια παρα τω θεω εστιν γεγραπται γαρ ο δρασσομενοσ τουσ σοφουσ εν τη πανουργια αυτων ");
INSERT INTO grcmt_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","και παλιν κυριοσ γινωσκει τουσ διαλογισμουσ των σοφων οτι εισιν ματαιοι ");
INSERT INTO grcmt_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ωστε μηδεισ καυχασθω εν ανθρωποισ παντα γαρ υμων εστιν ");
INSERT INTO grcmt_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ειτε παυλοσ ειτε απολλωσ ειτε κηφασ ειτε κοσμοσ ειτε ζωη ειτε θανατοσ ειτε ενεστωτα ειτε μελλοντα παντα υμων εστιν ");
INSERT INTO grcmt_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","υμεισ δε χριστου χριστοσ δε θεου ");
INSERT INTO grcmt_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ουτωσ ημασ λογιζεσθω ανθρωποσ ωσ υπηρετασ χριστου και οικονομουσ μυστηριων θεου ");
INSERT INTO grcmt_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ο δε λοιπον ζητειται εν τοισ οικονομοισ ινα πιστοσ τισ ευρεθη ");
INSERT INTO grcmt_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","εμοι δε εισ ελαχιστον εστιν ινα υφ υμων ανακριθω η υπο ανθρωπινησ ημερασ αλλ ουδε εμαυτον ανακρινω ");
INSERT INTO grcmt_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ουδεν γαρ εμαυτω συνοιδα αλλ ουκ εν τουτω δεδικαιωμαι ο δε ανακρινων με κυριοσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ωστε μη προ καιρου τι κρινετε εωσ αν ελθη ο κυριοσ οσ και φωτισει τα κρυπτα του σκοτουσ και φανερωσει τασ βουλασ των καρδιων και τοτε ο επαινοσ γενησεται εκαστω απο του θεου ");
INSERT INTO grcmt_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ταυτα δε αδελφοι μετεσχηματισα εισ εμαυτον και απολλω δι υμασ ινα εν ημιν μαθητε το μη υπερ ο γεγραπται φρονειν ινα μη εισ υπερ του ενοσ φυσιουσθε κατα του ετερου ");
INSERT INTO grcmt_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","τισ γαρ σε διακρινει τι δε εχεισ ο ουκ ελαβεσ ει δε και ελαβεσ τι καυχασαι ωσ μη λαβων ");
INSERT INTO grcmt_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ηδη κεκορεσμενοι εστε ηδη επλουτησατε χωρισ ημων εβασιλευσατε και οφελον γε εβασιλευσατε ινα και ημεισ υμιν συμβασιλευσωμεν ");
INSERT INTO grcmt_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","δοκω γαρ οτι ο θεοσ ημασ τουσ αποστολουσ εσχατουσ απεδειξεν ωσ επιθανατιουσ οτι θεατρον εγενηθημεν τω κοσμω και αγγελοισ και ανθρωποισ ");
INSERT INTO grcmt_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ημεισ μωροι δια χριστον υμεισ δε φρονιμοι εν χριστω ημεισ ασθενεισ υμεισ δε ισχυροι υμεισ ενδοξοι ημεισ δε ατιμοι ");
INSERT INTO grcmt_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","αχρι τησ αρτι ωρασ και πεινωμεν και διψωμεν και γυμνητευομεν και κολαφιζομεθα και αστατουμεν ");
INSERT INTO grcmt_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","και κοπιωμεν εργαζομενοι ταισ ιδιαισ χερσιν λοιδορουμενοι ευλογουμεν διωκομενοι ανεχομεθα ");
INSERT INTO grcmt_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","βλασφημουμενοι παρακαλουμεν ωσ περικαθαρματα του κοσμου εγενηθημεν παντων περιψημα εωσ αρτι ");
INSERT INTO grcmt_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ουκ εντρεπων υμασ γραφω ταυτα αλλ ωσ τεκνα μου αγαπητα νουθετω ");
INSERT INTO grcmt_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","εαν γαρ μυριουσ παιδαγωγουσ εχητε εν χριστω αλλ ου πολλουσ πατερασ εν γαρ χριστω ιησου δια του ευαγγελιου εγω υμασ εγεννησα ");
INSERT INTO grcmt_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","παρακαλω ουν υμασ μιμηται μου γινεσθε ");
INSERT INTO grcmt_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","δια τουτο επεμψα υμιν τιμοθεον οσ εστιν τεκνον μου αγαπητον και πιστον εν κυριω οσ υμασ αναμνησει τασ οδουσ μου τασ εν χριστω καθωσ πανταχου εν παση εκκλησια διδασκω ");
INSERT INTO grcmt_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ωσ μη ερχομενου δε μου προσ υμασ εφυσιωθησαν τινεσ ");
INSERT INTO grcmt_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ελευσομαι δε ταχεωσ προσ υμασ εαν ο κυριοσ θεληση και γνωσομαι ου τον λογον των πεφυσιωμενων αλλα την δυναμιν ");
INSERT INTO grcmt_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ου γαρ εν λογω η βασιλεια του θεου αλλ εν δυναμει ");
INSERT INTO grcmt_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","τι θελετε εν ραβδω ελθω προσ υμασ η εν αγαπη πνευματι τε πραοτητοσ ");
INSERT INTO grcmt_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ολωσ ακουεται εν υμιν πορνεια και τοιαυτη πορνεια ητισ ουδε εν τοισ εθνεσιν ονομαζεται ωστε γυναικα τινα του πατροσ εχειν ");
INSERT INTO grcmt_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","και υμεισ πεφυσιωμενοι εστε και ουχι μαλλον επενθησατε ινα εξαρθη εκ μεσου υμων ο το εργον τουτο ποιησασ ");
INSERT INTO grcmt_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","εγω μεν γαρ ωσ απων τω σωματι παρων δε τω πνευματι ηδη κεκρικα ωσ παρων τον ουτωσ τουτο κατεργασαμενον ");
INSERT INTO grcmt_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","εν τω ονοματι του κυριου ημων ιησου χριστου συναχθεντων υμων και του εμου πνευματοσ συν τη δυναμει του κυριου ημων ιησου χριστου ");
INSERT INTO grcmt_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","παραδουναι τον τοιουτον τω σατανα εισ ολεθρον τησ σαρκοσ ινα το πνευμα σωθη εν τη ημερα του κυριου ιησου ");
INSERT INTO grcmt_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ου καλον το καυχημα υμων ουκ οιδατε οτι μικρα ζυμη ολον το φυραμα ζυμοι ");
INSERT INTO grcmt_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","εκκαθαρατε την παλαιαν ζυμην ινα ητε νεον φυραμα καθωσ εστε αζυμοι και γαρ το πασχα ημων υπερ ημων ετυθη χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ωστε εορταζωμεν μη εν ζυμη παλαια μηδε εν ζυμη κακιασ και πονηριασ αλλ εν αζυμοισ ειλικρινειασ και αληθειασ ");
INSERT INTO grcmt_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","εγραψα υμιν εν τη επιστολη μη συναναμιγνυσθαι πορνοισ ");
INSERT INTO grcmt_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","και ου παντωσ τοισ πορνοισ του κοσμου τουτου η τοισ πλεονεκταισ η αρπαξιν η ειδωλολατραισ επει οφειλετε αρα εκ του κοσμου εξελθειν ");
INSERT INTO grcmt_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","νυν δε εγραψα υμιν μη συναναμιγνυσθαι εαν τισ αδελφοσ ονομαζομενοσ η πορνοσ η πλεονεκτησ η ειδωλολατρησ η λοιδοροσ η μεθυσοσ η αρπαξ τω τοιουτω μηδε συνεσθιειν ");
INSERT INTO grcmt_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","τι γαρ μοι και τουσ εξω κρινειν ουχι τουσ εσω υμεισ κρινετε ");
INSERT INTO grcmt_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","τουσ δε εξω ο θεοσ κρινει και εξαρειτε τον πονηρον εξ υμων αυτων ");
INSERT INTO grcmt_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","τολμα τισ υμων πραγμα εχων προσ τον ετερον κρινεσθαι επι των αδικων και ουχι επι των αγιων ");
INSERT INTO grcmt_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ουκ οιδατε οτι οι αγιοι τον κοσμον κρινουσιν και ει εν υμιν κρινεται ο κοσμοσ αναξιοι εστε κριτηριων ελαχιστων ");
INSERT INTO grcmt_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ουκ οιδατε οτι αγγελουσ κρινουμεν μητι γε βιωτικα ");
INSERT INTO grcmt_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","βιωτικα μεν ουν κριτηρια εαν εχητε τουσ εξουθενημενουσ εν τη εκκλησια τουτουσ καθιζετε ");
INSERT INTO grcmt_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","προσ εντροπην υμιν λεγω ουτωσ ουκ ενι εν υμιν σοφοσ ουδε εισ οσ δυνησεται διακριναι ανα μεσον του αδελφου αυτου ");
INSERT INTO grcmt_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","αλλα αδελφοσ μετα αδελφου κρινεται και τουτο επι απιστων ");
INSERT INTO grcmt_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ηδη μεν ουν ολωσ ηττημα υμιν εστιν οτι κριματα εχετε μεθ εαυτων δια τι ουχι μαλλον αδικεισθε δια τι ουχι μαλλον αποστερεισθε ");
INSERT INTO grcmt_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","αλλα υμεισ αδικειτε και αποστερειτε και ταυτα αδελφουσ ");
INSERT INTO grcmt_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","η ουκ οιδατε οτι αδικοι βασιλειαν θεου ου κληρονομησουσιν μη πλανασθε ουτε πορνοι ουτε ειδωλολατραι ουτε μοιχοι ουτε μαλακοι ουτε αρσενοκοιται ");
INSERT INTO grcmt_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ουτε πλεονεκται ουτε κλεπται ουτε μεθυσοι ου λοιδοροι ουχ αρπαγεσ βασιλειαν θεου ου κληρονομησουσιν ");
INSERT INTO grcmt_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","και ταυτα τινεσ ητε αλλα απελουσασθε αλλα ηγιασθητε αλλ εδικαιωθητε εν τω ονοματι του κυριου ιησου και εν τω πνευματι του θεου ημων ");
INSERT INTO grcmt_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","παντα μοι εξεστιν αλλ ου παντα συμφερει παντα μοι εξεστιν αλλ ουκ εγω εξουσιασθησομαι υπο τινοσ ");
INSERT INTO grcmt_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","τα βρωματα τη κοιλια και η κοιλια τοισ βρωμασιν ο δε θεοσ και ταυτην και ταυτα καταργησει το δε σωμα ου τη πορνεια αλλα τω κυριω και ο κυριοσ τω σωματι ");
INSERT INTO grcmt_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ο δε θεοσ και τον κυριον ηγειρεν και ημασ εξεγερει δια τησ δυναμεωσ αυτου ");
INSERT INTO grcmt_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ουκ οιδατε οτι τα σωματα υμων μελη χριστου εστιν αρασ ουν τα μελη του χριστου ποιησω πορνησ μελη μη γενοιτο ");
INSERT INTO grcmt_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ουκ οιδατε οτι ο κολλωμενοσ τη πορνη εν σωμα εστιν εσονται γαρ φησιν οι δυο εισ σαρκα μιαν ");
INSERT INTO grcmt_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ο δε κολλωμενοσ τω κυριω εν πνευμα εστιν ");
INSERT INTO grcmt_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","φευγετε την πορνειαν παν αμαρτημα ο εαν ποιηση ανθρωποσ εκτοσ του σωματοσ εστιν ο δε πορνευων εισ το ιδιον σωμα αμαρτανει ");
INSERT INTO grcmt_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","η ουκ οιδατε οτι το σωμα υμων ναοσ του εν υμιν αγιου πνευματοσ εστιν ου εχετε απο θεου και ουκ εστε εαυτων ");
INSERT INTO grcmt_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ηγορασθητε γαρ τιμησ δοξασατε δη τον θεον εν τω σωματι υμων και εν τω πνευματι υμων ατινα εστιν του θεου ");
INSERT INTO grcmt_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","περι δε ων εγραψατε μοι καλον ανθρωπω γυναικοσ μη απτεσθαι ");
INSERT INTO grcmt_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","δια δε τασ πορνειασ εκαστοσ την εαυτου γυναικα εχετω και εκαστη τον ιδιον ανδρα εχετω ");
INSERT INTO grcmt_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","τη γυναικι ο ανηρ την οφειλομενην ευνοιαν αποδιδοτω ομοιωσ δε και η γυνη τω ανδρι ");
INSERT INTO grcmt_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","η γυνη του ιδιου σωματοσ ουκ εξουσιαζει αλλ ο ανηρ ομοιωσ δε και ο ανηρ του ιδιου σωματοσ ουκ εξουσιαζει αλλ η γυνη ");
INSERT INTO grcmt_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","μη αποστερειτε αλληλουσ ει μητι αν εκ συμφωνου προσ καιρον ινα σχολαζητε τη νηστεια και τη προσευχη και παλιν επι το αυτο συνερχησθε ινα μη πειραζη υμασ ο σατανασ δια την ακρασιαν υμων ");
INSERT INTO grcmt_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","τουτο δε λεγω κατα συγγνωμην ου κατ επιταγην ");
INSERT INTO grcmt_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","θελω γαρ παντασ ανθρωπουσ ειναι ωσ και εμαυτον αλλ εκαστοσ ιδιον χαρισμα εχει εκ θεου οσ μεν ουτωσ οσ δε ουτωσ ");
INSERT INTO grcmt_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","λεγω δε τοισ αγαμοισ και ταισ χηραισ καλον αυτοισ εστιν εαν μεινωσιν ωσ καγω ");
INSERT INTO grcmt_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ει δε ουκ εγκρατευονται γαμησατωσαν κρεισσον γαρ εστιν γαμησαι η πυρουσθαι ");
INSERT INTO grcmt_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","τοισ δε γεγαμηκοσιν παραγγελλω ουκ εγω αλλ ο κυριοσ γυναικα απο ανδροσ μη χωρισθηναι ");
INSERT INTO grcmt_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","εαν δε και χωρισθη μενετω αγαμοσ η τω ανδρι καταλλαγητω και ανδρα γυναικα μη αφιεναι ");
INSERT INTO grcmt_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","τοισ δε λοιποισ εγω λεγω ουχ ο κυριοσ ει τισ αδελφοσ γυναικα εχει απιστον και αυτη συνευδοκει οικειν μετ αυτου μη αφιετω αυτην ");
INSERT INTO grcmt_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","και γυνη ητισ εχει ανδρα απιστον και αυτοσ συνευδοκει οικειν μετ αυτησ μη αφιετω αυτον ");
INSERT INTO grcmt_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ηγιασται γαρ ο ανηρ ο απιστοσ εν τη γυναικι και ηγιασται η γυνη η απιστοσ εν τω ανδρι επει αρα τα τεκνα υμων ακαθαρτα εστιν νυν δε αγια εστιν ");
INSERT INTO grcmt_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ει δε ο απιστοσ χωριζεται χωριζεσθω ου δεδουλωται ο αδελφοσ η η αδελφη εν τοισ τοιουτοισ εν δε ειρηνη κεκληκεν ημασ ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","τι γαρ οιδασ γυναι ει τον ανδρα σωσεισ η τι οιδασ ανερ ει την γυναικα σωσεισ ");
INSERT INTO grcmt_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ει μη εκαστω ωσ εμερισεν ο θεοσ εκαστον ωσ κεκληκεν ο κυριοσ ουτωσ περιπατειτω και ουτωσ εν ταισ εκκλησιαισ πασαισ διατασσομαι ");
INSERT INTO grcmt_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","περιτετμημενοσ τισ εκληθη μη επισπασθω εν ακροβυστια τισ εκληθη μη περιτεμνεσθω ");
INSERT INTO grcmt_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","η περιτομη ουδεν εστιν και η ακροβυστια ουδεν εστιν αλλα τηρησισ εντολων θεου ");
INSERT INTO grcmt_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","εκαστοσ εν τη κλησει η εκληθη εν ταυτη μενετω ");
INSERT INTO grcmt_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","δουλοσ εκληθησ μη σοι μελετω αλλ ει και δυνασαι ελευθεροσ γενεσθαι μαλλον χρησαι ");
INSERT INTO grcmt_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ο γαρ εν κυριω κληθεισ δουλοσ απελευθεροσ κυριου εστιν ομοιωσ και ο ελευθεροσ κληθεισ δουλοσ εστιν χριστου ");
INSERT INTO grcmt_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","τιμησ ηγορασθητε μη γινεσθε δουλοι ανθρωπων ");
INSERT INTO grcmt_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","εκαστοσ εν ω εκληθη αδελφοι εν τουτω μενετω παρα θεω ");
INSERT INTO grcmt_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","περι δε των παρθενων επιταγην κυριου ουκ εχω γνωμην δε διδωμι ωσ ηλεημενοσ υπο κυριου πιστοσ ειναι ");
INSERT INTO grcmt_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","νομιζω ουν τουτο καλον υπαρχειν δια την ενεστωσαν αναγκην οτι καλον ανθρωπω το ουτωσ ειναι ");
INSERT INTO grcmt_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","δεδεσαι γυναικι μη ζητει λυσιν λελυσαι απο γυναικοσ μη ζητει γυναικα ");
INSERT INTO grcmt_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","εαν δε και γημησ ουχ ημαρτεσ και εαν γημη η παρθενοσ ουχ ημαρτεν θλιψιν δε τη σαρκι εξουσιν οι τοιουτοι εγω δε υμων φειδομαι ");
INSERT INTO grcmt_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","τουτο δε φημι αδελφοι ο καιροσ συνεσταλμενοσ το λοιπον εστιν ινα και οι εχοντεσ γυναικασ ωσ μη εχοντεσ ωσιν ");
INSERT INTO grcmt_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","και οι κλαιοντεσ ωσ μη κλαιοντεσ και οι χαιροντεσ ωσ μη χαιροντεσ και οι αγοραζοντεσ ωσ μη κατεχοντεσ ");
INSERT INTO grcmt_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","και οι χρωμενοι τω κοσμω τουτω ωσ μη καταχρωμενοι παραγει γαρ το σχημα του κοσμου τουτου ");
INSERT INTO grcmt_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","θελω δε υμασ αμεριμνουσ ειναι ο αγαμοσ μεριμνα τα του κυριου πωσ αρεσει τω κυριω ");
INSERT INTO grcmt_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ο δε γαμησασ μεριμνα τα του κοσμου πωσ αρεσει τη γυναικι ");
INSERT INTO grcmt_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","μεμερισται και η γυνη και η παρθενοσ η αγαμοσ μεριμνα τα του κυριου ινα η αγια και σωματι και πνευματι η δε γαμησασα μεριμνα τα του κοσμου πωσ αρεσει τω ανδρι ");
INSERT INTO grcmt_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","τουτο δε προσ το υμων αυτων συμφερον λεγω ουχ ινα βροχον υμιν επιβαλω αλλα προσ το ευσχημον και ευπροσεδρον τω κυριω απερισπαστωσ ");
INSERT INTO grcmt_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ει δε τισ ασχημονειν επι την παρθενον αυτου νομιζει εαν η υπερακμοσ 5230 A-NSM και ουτωσ οφειλει γινεσθαι ο θελει ποιειτω ουχ αμαρτανει γαμειτωσαν ");
INSERT INTO grcmt_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","οσ δε εστηκεν εδραιοσ εν τη καρδια μη εχων αναγκην εξουσιαν δε εχει περι του ιδιου θεληματοσ και τουτο κεκρικεν εν τη καρδια αυτου του τηρειν την εαυτου παρθενον καλωσ ποιει ");
INSERT INTO grcmt_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ωστε και ο εκγαμιζων καλωσ ποιει ο δε μη εκγαμιζων κρεισσον ποιει ");
INSERT INTO grcmt_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","γυνη δεδεται νομω εφ οσον χρονον ζη ο ανηρ αυτησ εαν δε και κοιμηθη ο ανηρ ελευθερα εστιν ω θελει γαμηθηναι μονον εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","μακαριωτερα δε εστιν εαν ουτωσ μεινη κατα την εμην γνωμην δοκω δε καγω πνευμα θεου εχειν ");
INSERT INTO grcmt_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","περι δε των ειδωλοθυτων οιδαμεν οτι παντεσ γνωσιν εχομεν η γνωσισ φυσιοι η δε αγαπη οικοδομει ");
INSERT INTO grcmt_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ει δε τισ δοκει ειδεναι τι ουδεπω ουδεν εγνωκεν καθωσ δει γνωναι ");
INSERT INTO grcmt_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ει δε τισ αγαπα τον θεον ουτοσ εγνωσται υπ αυτου ");
INSERT INTO grcmt_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","περι τησ βρωσεωσ ουν των ειδωλοθυτων οιδαμεν οτι ουδεν ειδωλον εν κοσμω και οτι ουδεισ θεοσ ετεροσ ει μη εισ ");
INSERT INTO grcmt_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","και γαρ ειπερ εισιν λεγομενοι θεοι ειτε εν ουρανω ειτε επι γησ ωσπερ εισιν θεοι πολλοι και κυριοι πολλοι ");
INSERT INTO grcmt_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","αλλ ημιν εισ θεοσ ο πατηρ εξ ου τα παντα και ημεισ εισ αυτον και εισ κυριοσ ιησουσ χριστοσ δι ου τα παντα και ημεισ δι αυτου ");
INSERT INTO grcmt_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","αλλ ουκ εν πασιν η γνωσισ τινεσ δε τη συνειδησει του ειδωλου εωσ αρτι ωσ ειδωλοθυτον εσθιουσιν και η συνειδησισ αυτων ασθενησ ουσα μολυνεται ");
INSERT INTO grcmt_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","βρωμα δε ημασ ου παριστησιν τω θεω ουτε γαρ εαν φαγωμεν περισσευομεν ουτε εαν μη φαγωμεν υστερουμεθα ");
INSERT INTO grcmt_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","βλεπετε δε μηπωσ η εξουσια υμων αυτη προσκομμα γενηται τοισ ασθενουσιν ");
INSERT INTO grcmt_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","εαν γαρ τισ ιδη σε τον εχοντα γνωσιν εν ειδωλειω κατακειμενον ουχι η συνειδησισ αυτου ασθενουσ οντοσ οικοδομηθησεται εισ το τα ειδωλοθυτα εσθιειν ");
INSERT INTO grcmt_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","και απολειται ο ασθενων αδελφοσ επι τη ση γνωσει δι ον χριστοσ απεθανεν ");
INSERT INTO grcmt_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ουτωσ δε αμαρτανοντεσ εισ τουσ αδελφουσ και τυπτοντεσ αυτων την συνειδησιν ασθενουσαν εισ χριστον αμαρτανετε ");
INSERT INTO grcmt_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","διοπερ ει βρωμα σκανδαλιζει τον αδελφον μου ου μη φαγω κρεα εισ τον αιωνα ινα μη τον αδελφον μου σκανδαλισω ");
INSERT INTO grcmt_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ουκ ειμι αποστολοσ ουκ ειμι ελευθεροσ ουχι ιησουν χριστον τον κυριον ημων εωρακα ου το εργον μου υμεισ εστε εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ει αλλοισ ουκ ειμι αποστολοσ αλλα γε υμιν ειμι η γαρ σφραγισ τησ εμησ αποστολησ υμεισ εστε εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","η εμη απολογια τοισ εμε ανακρινουσιν αυτη εστιν ");
INSERT INTO grcmt_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","μη ουκ εχομεν εξουσιαν φαγειν και πιειν ");
INSERT INTO grcmt_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","μη ουκ εχομεν εξουσιαν αδελφην γυναικα περιαγειν ωσ και οι λοιποι αποστολοι και οι αδελφοι του κυριου και κηφασ ");
INSERT INTO grcmt_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","η μονοσ εγω και βαρναβασ ουκ εχομεν εξουσιαν του μη εργαζεσθαι ");
INSERT INTO grcmt_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","τισ στρατευεται ιδιοισ οψωνιοισ ποτε τισ φυτευει αμπελωνα και εκ του καρπου αυτου ουκ εσθιει η τισ ποιμαινει ποιμνην και εκ του γαλακτοσ τησ ποιμνησ ουκ εσθιει ");
INSERT INTO grcmt_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","μη κατα ανθρωπον ταυτα λαλω η ουχι και ο νομοσ ταυτα λεγει ");
INSERT INTO grcmt_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","εν γαρ τω μωυσεωσ νομω γεγραπται ου φιμωσεισ βουν αλοωντα μη των βοων μελει τω θεω ");
INSERT INTO grcmt_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","η δι ημασ παντωσ λεγει δι ημασ γαρ εγραφη οτι επ ελπιδι οφειλει ο αροτριων αροτριαν και ο αλοων τησ ελπιδοσ αυτου μετεχειν επ ελπιδι ");
INSERT INTO grcmt_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ει ημεισ υμιν τα πνευματικα εσπειραμεν μεγα ει ημεισ υμων τα σαρκικα θερισομεν ");
INSERT INTO grcmt_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ει αλλοι τησ εξουσιασ υμων μετεχουσιν ου μαλλον ημεισ αλλ ουκ εχρησαμεθα τη εξουσια ταυτη αλλα παντα στεγομεν ινα μη εγκοπην τινα δωμεν τω ευαγγελιω του χριστου ");
INSERT INTO grcmt_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ουκ οιδατε οτι οι τα ιερα εργαζομενοι εκ του ιερου εσθιουσιν οι τω θυσιαστηριω προσεδρευοντεσ τω θυσιαστηριω συμμεριζονται ");
INSERT INTO grcmt_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ουτωσ και ο κυριοσ διεταξεν τοισ το ευαγγελιον καταγγελλουσιν εκ του ευαγγελιου ζην ");
INSERT INTO grcmt_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","εγω δε ουδενι εχρησαμην τουτων ουκ εγραψα δε ταυτα ινα ουτωσ γενηται εν εμοι καλον γαρ μοι μαλλον αποθανειν η το καυχημα μου ινα τισ κενωση ");
INSERT INTO grcmt_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","εαν γαρ ευαγγελιζωμαι ουκ εστιν μοι καυχημα αναγκη γαρ μοι επικειται ουαι δε μοι εστιν εαν μη ευαγγελιζωμαι ");
INSERT INTO grcmt_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ει γαρ εκων τουτο πρασσω μισθον εχω ει δε ακων οικονομιαν πεπιστευμαι ");
INSERT INTO grcmt_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","τισ ουν μοι εστιν ο μισθοσ ινα ευαγγελιζομενοσ αδαπανον θησω το ευαγγελιον του χριστου εισ το μη καταχρησασθαι τη εξουσια μου εν τω ευαγγελιω ");
INSERT INTO grcmt_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ελευθεροσ γαρ ων εκ παντων πασιν εμαυτον εδουλωσα ινα τουσ πλειονασ κερδησω ");
INSERT INTO grcmt_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","και εγενομην τοισ ιουδαιοισ ωσ ιουδαιοσ ινα ιουδαιουσ κερδησω τοισ υπο νομον ωσ υπο νομον ινα τουσ υπο νομον κερδησω ");
INSERT INTO grcmt_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","τοισ ανομοισ ωσ ανομοσ μη ων ανομοσ θεω αλλ εννομοσ χριστω ινα κερδησω ανομουσ ");
INSERT INTO grcmt_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","εγενομην τοισ ασθενεσιν ωσ ασθενησ ινα τουσ ασθενεισ κερδησω τοισ πασιν γεγονα τα παντα ινα παντωσ τινασ σωσω ");
INSERT INTO grcmt_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","τουτο δε ποιω δια το ευαγγελιον ινα συγκοινωνοσ αυτου γενωμαι ");
INSERT INTO grcmt_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ουκ οιδατε οτι οι εν σταδιω τρεχοντεσ παντεσ μεν τρεχουσιν εισ δε λαμβανει το βραβειον ουτωσ τρεχετε ινα καταλαβητε ");
INSERT INTO grcmt_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","πασ δε ο αγωνιζομενοσ παντα εγκρατευεται εκεινοι μεν ουν ινα φθαρτον στεφανον λαβωσιν ημεισ δε αφθαρτον ");
INSERT INTO grcmt_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","εγω τοινυν ουτωσ τρεχω ωσ ουκ αδηλωσ ουτωσ πυκτευω ωσ ουκ αερα δερων ");
INSERT INTO grcmt_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","αλλ υπωπιαζω μου το σωμα και δουλαγωγω μηπωσ αλλοισ κηρυξασ αυτοσ αδοκιμοσ γενωμαι ");
INSERT INTO grcmt_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ου θελω δε υμασ αγνοειν αδελφοι οτι οι πατερεσ ημων παντεσ υπο την νεφελην ησαν και παντεσ δια τησ θαλασσησ διηλθον ");
INSERT INTO grcmt_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","και παντεσ εισ τον μωυσην εβαπτισαντο εν τη νεφελη και εν τη θαλασση ");
INSERT INTO grcmt_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","και παντεσ το αυτο βρωμα πνευματικον εφαγον ");
INSERT INTO grcmt_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","και παντεσ το αυτο πομα πνευματικον επιον επινον γαρ εκ πνευματικησ ακολουθουσησ πετρασ η δε πετρα ην ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","αλλ ουκ εν τοισ πλειοσιν αυτων ευδοκησεν ο θεοσ κατεστρωθησαν γαρ εν τη ερημω ");
INSERT INTO grcmt_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ταυτα δε τυποι ημων εγενηθησαν εισ το μη ειναι ημασ επιθυμητασ κακων καθωσ κακεινοι επεθυμησαν ");
INSERT INTO grcmt_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","μηδε ειδωλολατραι γινεσθε καθωσ τινεσ αυτων ωσπερ γεγραπται εκαθισεν ο λαοσ φαγειν και πιειν και ανεστησαν παιζειν ");
INSERT INTO grcmt_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","μηδε πορνευωμεν καθωσ τινεσ αυτων επορνευσαν και επεσον εν μια ημερα εικοσι τρεισ χιλιαδεσ ");
INSERT INTO grcmt_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","μηδε εκπειραζωμεν τον χριστον καθωσ και τινεσ αυτων επειρασαν και υπο των οφεων απωλοντο ");
INSERT INTO grcmt_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","μηδε γογγυζετε καθωσ και τινεσ αυτων εγογγυσαν και απωλοντο υπο του ολοθρευτου ");
INSERT INTO grcmt_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ταυτα δε παντα τυποι συνεβαινον εκεινοισ εγραφη δε προσ νουθεσιαν ημων εισ ουσ τα τελη των αιωνων κατηντησεν ");
INSERT INTO grcmt_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ωστε ο δοκων εσταναι βλεπετω μη πεση ");
INSERT INTO grcmt_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","πειρασμοσ υμασ ουκ ειληφεν ει μη ανθρωπινοσ πιστοσ δε ο θεοσ οσ ουκ εασει υμασ πειρασθηναι υπερ ο δυνασθε αλλα ποιησει συν τω πειρασμω και την εκβασιν του δυνασθαι υμασ υπενεγκειν ");
INSERT INTO grcmt_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","διοπερ αγαπητοι μου φευγετε απο τησ ειδωλολατρειασ ");
INSERT INTO grcmt_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ωσ φρονιμοισ λεγω κρινατε υμεισ ο φημι ");
INSERT INTO grcmt_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","το ποτηριον τησ ευλογιασ ο ευλογουμεν ουχι κοινωνια του αιματοσ του χριστου εστιν τον αρτον ον κλωμεν ουχι κοινωνια του σωματοσ του χριστου εστιν ");
INSERT INTO grcmt_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","οτι εισ αρτοσ εν σωμα οι πολλοι εσμεν οι γαρ παντεσ εκ του ενοσ αρτου μετεχομεν ");
INSERT INTO grcmt_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","βλεπετε τον ισραηλ κατα σαρκα ουχι οι εσθιοντεσ τασ θυσιασ κοινωνοι του θυσιαστηριου εισιν ");
INSERT INTO grcmt_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","τι ουν φημι οτι ειδωλον τι εστιν η οτι ειδωλοθυτον τι εστιν ");
INSERT INTO grcmt_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","αλλ οτι α θυει τα εθνη δαιμονιοισ θυει και ου θεω ου θελω δε υμασ κοινωνουσ των δαιμονιων γινεσθαι ");
INSERT INTO grcmt_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ου δυνασθε ποτηριον κυριου πινειν και ποτηριον δαιμονιων ου δυνασθε τραπεζησ κυριου μετεχειν και τραπεζησ δαιμονιων ");
INSERT INTO grcmt_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","η παραζηλουμεν τον κυριον μη ισχυροτεροι αυτου εσμεν ");
INSERT INTO grcmt_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","παντα μοι εξεστιν αλλ ου παντα συμφερει παντα μοι εξεστιν αλλ ου παντα οικοδομει ");
INSERT INTO grcmt_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","μηδεισ το εαυτου ζητειτω αλλα το του ετερου εκαστοσ ");
INSERT INTO grcmt_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","παν το εν μακελλω πωλουμενον εσθιετε μηδεν ανακρινοντεσ δια την συνειδησιν ");
INSERT INTO grcmt_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","του γαρ κυριου η γη και το πληρωμα αυτησ ");
INSERT INTO grcmt_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ει δε τισ καλει υμασ των απιστων και θελετε πορευεσθαι παν το παρατιθεμενον υμιν εσθιετε μηδεν ανακρινοντεσ δια την συνειδησιν ");
INSERT INTO grcmt_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","εαν δε τισ υμιν ειπη τουτο ειδωλοθυτον εστιν μη εσθιετε δι εκεινον τον μηνυσαντα και την συνειδησιν του γαρ κυριου η γη και το πληρωμα αυτησ ");
INSERT INTO grcmt_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","συνειδησιν δε λεγω ουχι την εαυτου αλλα την του ετερου ινα τι γαρ η ελευθερια μου κρινεται υπο αλλησ συνειδησεωσ ");
INSERT INTO grcmt_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ει εγω χαριτι μετεχω τι βλασφημουμαι υπερ ου εγω ευχαριστω ");
INSERT INTO grcmt_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ειτε ουν εσθιετε ειτε πινετε ειτε τι ποιειτε παντα εισ δοξαν θεου ποιειτε ");
INSERT INTO grcmt_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","απροσκοποι γινεσθε και ιουδαιοισ και ελλησιν και τη εκκλησια του θεου ");
INSERT INTO grcmt_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","καθωσ καγω παντα πασιν αρεσκω μη ζητων το εμαυτου συμφερον αλλα το των πολλων ινα σωθωσιν ");
INSERT INTO grcmt_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","μιμηται μου γινεσθε καθωσ καγω χριστου ");
INSERT INTO grcmt_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","επαινω δε υμασ αδελφοι οτι παντα μου μεμνησθε και καθωσ παρεδωκα υμιν τασ παραδοσεισ κατεχετε ");
INSERT INTO grcmt_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","θελω δε υμασ ειδεναι οτι παντοσ ανδροσ η κεφαλη ο χριστοσ εστιν κεφαλη δε γυναικοσ ο ανηρ κεφαλη δε χριστου ο θεοσ ");
INSERT INTO grcmt_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","πασ ανηρ προσευχομενοσ η προφητευων κατα κεφαλησ εχων καταισχυνει την κεφαλην αυτου ");
INSERT INTO grcmt_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","πασα δε γυνη προσευχομενη η προφητευουσα ακατακαλυπτω τη κεφαλη καταισχυνει την κεφαλην εαυτησ εν γαρ εστιν και το αυτο τη εξυρημενη ");
INSERT INTO grcmt_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ει γαρ ου κατακαλυπτεται γυνη και κειρασθω ει δε αισχρον γυναικι το κειρασθαι η ξυρασθαι κατακαλυπτεσθω ");
INSERT INTO grcmt_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ανηρ μεν γαρ ουκ οφειλει κατακαλυπτεσθαι την κεφαλην εικων και δοξα θεου υπαρχων γυνη δε δοξα ανδροσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ου γαρ εστιν ανηρ εκ γυναικοσ αλλα γυνη εξ ανδροσ ");
INSERT INTO grcmt_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","και γαρ ουκ εκτισθη ανηρ δια την γυναικα αλλα γυνη δια τον ανδρα ");
INSERT INTO grcmt_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","δια τουτο οφειλει η γυνη εξουσιαν εχειν επι τησ κεφαλησ δια τουσ αγγελουσ ");
INSERT INTO grcmt_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","πλην ουτε ανηρ χωρισ γυναικοσ ουτε γυνη χωρισ ανδροσ εν κυριω ");
INSERT INTO grcmt_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ωσπερ γαρ η γυνη εκ του ανδροσ ουτωσ και ο ανηρ δια τησ γυναικοσ τα δε παντα εκ του θεου ");
INSERT INTO grcmt_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","εν υμιν αυτοισ κρινατε πρεπον εστιν γυναικα ακατακαλυπτον τω θεω προσευχεσθαι ");
INSERT INTO grcmt_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","η ουδε αυτη η φυσισ διδασκει υμασ οτι ανηρ μεν εαν κομα ατιμια αυτω εστιν ");
INSERT INTO grcmt_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","γυνη δε εαν κομα δοξα αυτη εστιν οτι η κομη αντι περιβολαιου δεδοται ");
INSERT INTO grcmt_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ει δε τισ δοκει φιλονεικοσ ειναι ημεισ τοιαυτην συνηθειαν ουκ εχομεν ουδε αι εκκλησιαι του θεου ");
INSERT INTO grcmt_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","τουτο δε παραγγελλων ουκ επαινω οτι ουκ εισ το κρειττον αλλ εισ το ηττον συνερχεσθε ");
INSERT INTO grcmt_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","πρωτον μεν γαρ συνερχομενων υμων εν εκκλησια ακουω σχισματα εν υμιν υπαρχειν και μεροσ τι πιστευω ");
INSERT INTO grcmt_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","δει γαρ και αιρεσεισ εν υμιν ειναι ινα οι δοκιμοι φανεροι γενωνται εν υμιν ");
INSERT INTO grcmt_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","συνερχομενων ουν υμων επι το αυτο ουκ εστιν κυριακον δειπνον φαγειν ");
INSERT INTO grcmt_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","εκαστοσ γαρ το ιδιον δειπνον προλαμβανει εν τω φαγειν και οσ μεν πεινα οσ δε μεθυει ");
INSERT INTO grcmt_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","μη γαρ οικιασ ουκ εχετε εισ το εσθιειν και πινειν η τησ εκκλησιασ του θεου καταφρονειτε και καταισχυνετε τουσ μη εχοντασ τι υμιν ειπω επαινεσω υμασ εν τουτω ουκ επαινω ");
INSERT INTO grcmt_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","εγω γαρ παρελαβον απο του κυριου ο και παρεδωκα υμιν οτι ο κυριοσ ιησουσ εν τη νυκτι η παρεδιδοτο ελαβεν αρτον ");
INSERT INTO grcmt_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","και ευχαριστησασ εκλασεν και ειπεν λαβετε φαγετε τουτο μου εστιν το σωμα το υπερ υμων κλωμενον τουτο ποιειτε εισ την εμην αναμνησιν ");
INSERT INTO grcmt_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ωσαυτωσ και το ποτηριον μετα το δειπνησαι λεγων τουτο το ποτηριον η καινη διαθηκη εστιν εν τω εμω αιματι τουτο ποιειτε οσακισ αν πινητε εισ την εμην αναμνησιν ");
INSERT INTO grcmt_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","οσακισ γαρ αν εσθιητε τον αρτον τουτον και το ποτηριον τουτο πινητε τον θανατον του κυριου καταγγελλετε αχρι ου αν ελθη ");
INSERT INTO grcmt_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ωστε οσ αν εσθιη τον αρτον τουτον η πινη το ποτηριον του κυριου αναξιωσ του κυριου ενοχοσ εσται του σωματοσ και του αιματοσ του κυριου ");
INSERT INTO grcmt_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","δοκιμαζετω δε ανθρωποσ εαυτον και ουτωσ εκ του αρτου εσθιετω και εκ του ποτηριου πινετω ");
INSERT INTO grcmt_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ο γαρ εσθιων και πινων αναξιωσ κριμα εαυτω εσθιει και πινει μη διακρινων το σωμα του κυριου ");
INSERT INTO grcmt_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","δια τουτο εν υμιν πολλοι ασθενεισ και αρρωστοι και κοιμωνται ικανοι ");
INSERT INTO grcmt_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ει γαρ εαυτουσ διεκρινομεν ουκ αν εκρινομεθα ");
INSERT INTO grcmt_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","κρινομενοι δε υπο κυριου παιδευομεθα ινα μη συν τω κοσμω κατακριθωμεν ");
INSERT INTO grcmt_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ωστε αδελφοι μου συνερχομενοι εισ το φαγειν αλληλουσ εκδεχεσθε ");
INSERT INTO grcmt_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ει δε τισ πεινα εν οικω εσθιετω ινα μη εισ κριμα συνερχησθε τα δε λοιπα ωσ αν ελθω διαταξομαι ");
INSERT INTO grcmt_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","περι δε των πνευματικων αδελφοι ου θελω υμασ αγνοειν ");
INSERT INTO grcmt_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","οιδατε οτι οτε εθνη ητε προσ τα ειδωλα τα αφωνα ωσ αν ηγεσθε απαγομενοι ");
INSERT INTO grcmt_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","διο γνωριζω υμιν οτι ουδεισ εν πνευματι θεου λαλων λεγει αναθεμα ιησουν και ουδεισ δυναται ειπειν κυριον ιησουν ει μη εν πνευματι αγιω ");
INSERT INTO grcmt_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","διαιρεσεισ δε χαρισματων εισιν το δε αυτο πνευμα ");
INSERT INTO grcmt_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","και διαιρεσεισ διακονιων εισιν και ο αυτοσ κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","και διαιρεσεισ ενεργηματων εισιν ο δε αυτοσ εστιν θεοσ ο ενεργων τα παντα εν πασιν ");
INSERT INTO grcmt_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","εκαστω δε διδοται η φανερωσισ του πνευματοσ προσ το συμφερον ");
INSERT INTO grcmt_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ω μεν γαρ δια του πνευματοσ διδοται λογοσ σοφιασ αλλω δε λογοσ γνωσεωσ κατα το αυτο πνευμα ");
INSERT INTO grcmt_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ετερω δε πιστισ εν τω αυτω πνευματι αλλω δε χαρισματα ιαματων εν τω αυτω πνευματι ");
INSERT INTO grcmt_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","αλλω δε ενεργηματα δυναμεων αλλω δε προφητεια αλλω δε διακρισεισ πνευματων ετερω δε γενη γλωσσων αλλω δε ερμηνεια γλωσσων ");
INSERT INTO grcmt_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","παντα δε ταυτα ενεργει το εν και το αυτο πνευμα διαιρουν ιδια εκαστω καθωσ βουλεται ");
INSERT INTO grcmt_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","καθαπερ γαρ το σωμα εν εστιν και μελη εχει πολλα παντα δε τα μελη του σωματοσ του ενοσ πολλα οντα εν εστιν σωμα ουτωσ και ο χριστοσ ");
INSERT INTO grcmt_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","και γαρ εν ενι πνευματι ημεισ παντεσ εισ εν σωμα εβαπτισθημεν ειτε ιουδαιοι ειτε ελληνεσ ειτε δουλοι ειτε ελευθεροι και παντεσ εισ εν πνευμα εποτισθημεν ");
INSERT INTO grcmt_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","και γαρ το σωμα ουκ εστιν εν μελοσ αλλα πολλα ");
INSERT INTO grcmt_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","εαν ειπη ο πουσ οτι ουκ ειμι χειρ ουκ ειμι εκ του σωματοσ ου παρα τουτο ουκ εστιν εκ του σωματοσ ");
INSERT INTO grcmt_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","και εαν ειπη το ουσ οτι ουκ ειμι οφθαλμοσ ουκ ειμι εκ του σωματοσ ου παρα τουτο ουκ εστιν εκ του σωματοσ ");
INSERT INTO grcmt_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ει ολον το σωμα οφθαλμοσ που η ακοη ει ολον ακοη που η οσφρησισ ");
INSERT INTO grcmt_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","νυνι δε ο θεοσ εθετο τα μελη εν εκαστον αυτων εν τω σωματι καθωσ ηθελησεν ");
INSERT INTO grcmt_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ει δε ην τα παντα εν μελοσ που το σωμα ");
INSERT INTO grcmt_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","νυν δε πολλα μεν μελη εν δε σωμα ");
INSERT INTO grcmt_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ου δυναται δε ο οφθαλμοσ ειπειν τη χειρι χρειαν σου ουκ εχω η παλιν η κεφαλη τοισ ποσιν χρειαν υμων ουκ εχω ");
INSERT INTO grcmt_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","αλλα πολλω μαλλον τα δοκουντα μελη του σωματοσ ασθενεστερα υπαρχειν αναγκαια εστιν ");
INSERT INTO grcmt_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","και α δοκουμεν ατιμοτερα ειναι του σωματοσ τουτοισ τιμην περισσοτεραν περιτιθεμεν και τα ασχημονα ημων ευσχημοσυνην περισσοτεραν εχει ");
INSERT INTO grcmt_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","τα δε ευσχημονα ημων ου χρειαν εχει αλλ ο θεοσ συνεκερασεν το σωμα τω υστερουντι περισσοτεραν δουσ τιμην ");
INSERT INTO grcmt_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ινα μη η σχισματα εν τω σωματι αλλα το αυτο υπερ αλληλων μεριμνωσιν τα μελη ");
INSERT INTO grcmt_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","και ειτε πασχει εν μελοσ συμπασχει παντα τα μελη ειτε δοξαζεται εν μελοσ συγχαιρει παντα τα μελη ");
INSERT INTO grcmt_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","υμεισ δε εστε σωμα χριστου και μελη εκ μερουσ ");
INSERT INTO grcmt_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","και ουσ μεν εθετο ο θεοσ εν τη εκκλησια πρωτον αποστολουσ δευτερον προφητασ τριτον διδασκαλουσ επειτα δυναμεισ ειτα χαρισματα ιαματων αντιληψεισ κυβερνησεισ γενη γλωσσων ");
INSERT INTO grcmt_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","μη παντεσ αποστολοι μη παντεσ προφηται μη παντεσ διδασκαλοι μη παντεσ δυναμεισ ");
INSERT INTO grcmt_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","μη παντεσ χαρισματα εχουσιν ιαματων μη παντεσ γλωσσαισ λαλουσιν μη παντεσ διερμηνευουσιν ");
INSERT INTO grcmt_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ζηλουτε δε τα χαρισματα τα κρειττονα και ετι καθ υπερβολην οδον υμιν δεικνυμι ");
INSERT INTO grcmt_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","εαν ταισ γλωσσαισ των ανθρωπων λαλω και των αγγελων αγαπην δε μη εχω γεγονα χαλκοσ ηχων η κυμβαλον αλαλαζον ");
INSERT INTO grcmt_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","και εαν εχω προφητειαν και ειδω τα μυστηρια παντα και πασαν την γνωσιν και εαν εχω πασαν την πιστιν ωστε ορη μεθιστανειν αγαπην δε μη εχω ουθεν ειμι ");
INSERT INTO grcmt_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","και εαν ψωμισω παντα τα υπαρχοντα μου και εαν παραδω το σωμα μου ινα καυθησωμαι αγαπην δε μη εχω ουδεν ωφελουμαι ");
INSERT INTO grcmt_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","η αγαπη μακροθυμει χρηστευεται η αγαπη ου ζηλοι η αγαπη ου περπερευεται ου φυσιουται ");
INSERT INTO grcmt_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ουκ ασχημονει ου ζητει τα εαυτησ ου παροξυνεται ου λογιζεται το κακον ");
INSERT INTO grcmt_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ου χαιρει επι τη αδικια συγχαιρει δε τη αληθεια ");
INSERT INTO grcmt_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","παντα στεγει παντα πιστευει παντα ελπιζει παντα υπομενει ");
INSERT INTO grcmt_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","η αγαπη ουδεποτε εκπιπτει ειτε δε προφητειαι καταργηθησονται ειτε γλωσσαι παυσονται ειτε γνωσισ καταργηθησεται ");
INSERT INTO grcmt_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","εκ μερουσ δε γινωσκομεν και εκ μερουσ προφητευομεν ");
INSERT INTO grcmt_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","οταν δε ελθη το τελειον τοτε το εκ μερουσ καταργηθησεται ");
INSERT INTO grcmt_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","οτε ημην νηπιοσ ωσ νηπιοσ ελαλουν ωσ νηπιοσ εφρονουν ωσ νηπιοσ ελογιζομην οτε δε γεγονα ανηρ κατηργηκα τα του νηπιου ");
INSERT INTO grcmt_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","βλεπομεν γαρ αρτι δι εσοπτρου εν αινιγματι τοτε δε προσωπον προσ προσωπον αρτι γινωσκω εκ μερουσ τοτε δε επιγνωσομαι καθωσ και επεγνωσθην ");
INSERT INTO grcmt_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","νυνι δε μενει πιστισ ελπισ αγαπη τα τρια ταυτα μειζων δε τουτων η αγαπη ");
INSERT INTO grcmt_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","διωκετε την αγαπην ζηλουτε δε τα πνευματικα μαλλον δε ινα προφητευητε ");
INSERT INTO grcmt_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ο γαρ λαλων γλωσση ουκ ανθρωποισ λαλει αλλα τω θεω ουδεισ γαρ ακουει πνευματι δε λαλει μυστηρια ");
INSERT INTO grcmt_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ο δε προφητευων ανθρωποισ λαλει οικοδομην και παρακλησιν και παραμυθιαν ");
INSERT INTO grcmt_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ο λαλων γλωσση εαυτον οικοδομει ο δε προφητευων εκκλησιαν οικοδομει ");
INSERT INTO grcmt_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","θελω δε παντασ υμασ λαλειν γλωσσαισ μαλλον δε ινα προφητευητε μειζων γαρ ο προφητευων η ο λαλων γλωσσαισ εκτοσ ει μη διερμηνευει ινα η εκκλησια οικοδομην λαβη ");
INSERT INTO grcmt_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","νυνι δε αδελφοι εαν ελθω προσ υμασ γλωσσαισ λαλων τι υμασ ωφελησω εαν μη υμιν λαλησω η εν αποκαλυψει η εν γνωσει η εν προφητεια η εν διδαχη ");
INSERT INTO grcmt_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ομωσ τα αψυχα φωνην διδοντα ειτε αυλοσ ειτε κιθαρα εαν διαστολην τοισ φθογγοισ μη διδω πωσ γνωσθησεται το αυλουμενον η το κιθαριζομενον ");
INSERT INTO grcmt_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","και γαρ εαν αδηλον φωνην σαλπιγξ δω τισ παρασκευασεται εισ πολεμον ");
INSERT INTO grcmt_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ουτωσ και υμεισ δια τησ γλωσσησ εαν μη ευσημον λογον δωτε πωσ γνωσθησεται το λαλουμενον εσεσθε γαρ εισ αερα λαλουντεσ ");
INSERT INTO grcmt_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","τοσαυτα ει τυχοι γενη φωνων εστιν εν κοσμω και ουδεν αυτων αφωνον ");
INSERT INTO grcmt_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","εαν ουν μη ειδω την δυναμιν τησ φωνησ εσομαι τω λαλουντι βαρβαροσ και ο λαλων εν εμοι βαρβαροσ ");
INSERT INTO grcmt_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ουτωσ και υμεισ επει ζηλωται εστε πνευματων προσ την οικοδομην τησ εκκλησιασ ζητειτε ινα περισσευητε ");
INSERT INTO grcmt_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","διοπερ ο λαλων γλωσση προσευχεσθω ινα διερμηνευη ");
INSERT INTO grcmt_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","εαν γαρ προσευχωμαι γλωσση το πνευμα μου προσευχεται ο δε νουσ μου ακαρποσ εστιν ");
INSERT INTO grcmt_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","τι ουν εστιν προσευξομαι τω πνευματι προσευξομαι δε και τω νοι ψαλω τω πνευματι ψαλω δε και τω νοι ");
INSERT INTO grcmt_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","επει εαν ευλογησησ τω πνευματι ο αναπληρων τον τοπον του ιδιωτου πωσ ερει το αμην επι τη ση ευχαριστια επειδη τι λεγεισ ουκ οιδεν ");
INSERT INTO grcmt_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","συ μεν γαρ καλωσ ευχαριστεισ αλλ ο ετεροσ ουκ οικοδομειται ");
INSERT INTO grcmt_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ευχαριστω τω θεω μου παντων υμων μαλλον γλωσσαισ λαλων ");
INSERT INTO grcmt_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","αλλ εν εκκλησια θελω πεντε λογουσ δια του νοοσ μου λαλησαι ινα και αλλουσ κατηχησω η μυριουσ λογουσ εν γλωσση ");
INSERT INTO grcmt_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","αδελφοι μη παιδια γινεσθε ταισ φρεσιν αλλα τη κακια νηπιαζετε ταισ δε φρεσιν τελειοι γινεσθε ");
INSERT INTO grcmt_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","εν τω νομω γεγραπται οτι εν ετερογλωσσοισ και εν χειλεσιν ετεροισ λαλησω τω λαω τουτω και ουδ ουτωσ εισακουσονται μου λεγει κυριοσ ");
INSERT INTO grcmt_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ωστε αι γλωσσαι εισ σημειον εισιν ου τοισ πιστευουσιν αλλα τοισ απιστοισ η δε προφητεια ου τοισ απιστοισ αλλα τοισ πιστευουσιν ");
INSERT INTO grcmt_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","εαν ουν συνελθη η εκκλησια ολη επι το αυτο και παντεσ γλωσσαισ λαλωσιν εισελθωσιν δε ιδιωται η απιστοι ουκ ερουσιν οτι μαινεσθε ");
INSERT INTO grcmt_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","εαν δε παντεσ προφητευωσιν εισελθη δε τισ απιστοσ η ιδιωτησ ελεγχεται υπο παντων ανακρινεται υπο παντων ");
INSERT INTO grcmt_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","και ουτωσ τα κρυπτα τησ καρδιασ αυτου φανερα γινεται και ουτωσ πεσων επι προσωπον προσκυνησει τω θεω απαγγελλων οτι ο θεοσ οντωσ εν υμιν εστιν ");
INSERT INTO grcmt_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","τι ουν εστιν αδελφοι οταν συνερχησθε εκαστοσ υμων ψαλμον εχει διδαχην εχει γλωσσαν εχει αποκαλυψιν εχει ερμηνειαν εχει παντα προσ οικοδομην γινεσθω ");
INSERT INTO grcmt_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ειτε γλωσση τισ λαλει κατα δυο η το πλειστον τρεισ και ανα μεροσ και εισ διερμηνευετω ");
INSERT INTO grcmt_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","εαν δε μη η διερμηνευτησ σιγατω εν εκκλησια εαυτω δε λαλειτω και τω θεω ");
INSERT INTO grcmt_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","προφηται δε δυο η τρεισ λαλειτωσαν και οι αλλοι διακρινετωσαν ");
INSERT INTO grcmt_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","εαν δε αλλω αποκαλυφθη καθημενω ο πρωτοσ σιγατω ");
INSERT INTO grcmt_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","δυνασθε γαρ καθ ενα παντεσ προφητευειν ινα παντεσ μανθανωσιν και παντεσ παρακαλωνται ");
INSERT INTO grcmt_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","και πνευματα προφητων προφηταισ υποτασσεται ");
INSERT INTO grcmt_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ου γαρ εστιν ακαταστασιασ ο θεοσ αλλα ειρηνησ ωσ εν πασαισ ταισ εκκλησιαισ των αγιων ");
INSERT INTO grcmt_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","αι γυναικεσ υμων εν ταισ εκκλησιαισ σιγατωσαν ου γαρ επιτετραπται αυταισ λαλειν αλλ υποτασσεσθαι καθωσ και ο νομοσ λεγει ");
INSERT INTO grcmt_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ει δε τι μαθειν θελουσιν εν οικω τουσ ιδιουσ ανδρασ επερωτατωσαν αισχρον γαρ εστιν γυναιξιν εν εκκλησια λαλειν ");
INSERT INTO grcmt_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","η αφ υμων ο λογοσ του θεου εξηλθεν η εισ υμασ μονουσ κατηντησεν ");
INSERT INTO grcmt_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ει τισ δοκει προφητησ ειναι η πνευματικοσ επιγινωσκετω α γραφω υμιν οτι κυριου εισιν εντολαι ");
INSERT INTO grcmt_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ει δε τισ αγνοει αγνοειτω ");
INSERT INTO grcmt_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ωστε αδελφοι ζηλουτε το προφητευειν και το λαλειν γλωσσαισ μη κωλυετε ");
INSERT INTO grcmt_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","παντα ευσχημονωσ και κατα ταξιν γινεσθω ");
INSERT INTO grcmt_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","γνωριζω δε υμιν αδελφοι το ευαγγελιον ο ευηγγελισαμην υμιν ο και παρελαβετε εν ω και εστηκατε ");
INSERT INTO grcmt_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","δι ου και σωζεσθε τινι λογω ευηγγελισαμην υμιν ει κατεχετε εκτοσ ει μη εικη επιστευσατε ");
INSERT INTO grcmt_v