﻿USE sofia;
DROP TABLE IF EXISTS sofia.grcbrent_vpl;
CREATE TABLE grcbrent_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES grcbrent_vpl WRITE;
INSERT INTO grcbrent_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ἘΝ ἀρχῇ ἐποίησεν ὁ Θεὸς τὸν οὐρανὸν καὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ἡ δὲ γῆ ἦν ἀόρατος καὶ ἀκατασκεύαστος, καὶ σκότος ἐπάνω τῆς ἀβύσσου· καὶ πνεῦμα Θεοῦ ἐπεφέρετο ἐπάνω τοῦ ὕδατος. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Καὶ εἶπεν ὁ Θεὸς, γενηθήτω φῶς· καὶ ἐγένετο φῶς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Καὶ εἶδεν ὁ Θεὸς τὸ φῶς, ὅτι καλόν· καὶ διεχώρισεν ὁ Θεὸς ἀνὰ μέσον τοῦ φωτὸς, καὶ ἀνὰ μέσον τοῦ σκότους. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Καὶ ἐκάλεσεν ὁ Θεὸς τὸ φῶς ἡμέραν, καὶ τὸ σκότος ἐκάλεσε νύκτα. Καὶ ἐγένετο ἑσπέρα, καὶ ἐγένετο πρωῒ, ἡμέρα μία. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Καὶ εἶπεν ὁ Θεὸς, γενηθήτω στερέωμα ἐν μέσῳ τοῦ ὕδατος· καὶ ἔστω διαχωρίζον ἀνὰ μέσον ὕδατος καὶ ὕδατος· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Καὶ ἐποίησεν ὁ Θεὸς τὸ στερέωμα· καὶ διεχώρισεν ὁ Θεὸς ἀνὰ μέσον τοῦ ὕδατος, ὃ ἦν ὑποκάτω τοῦ στερεώματος, καὶ ἀνὰ μέσον τοῦ ὕδατος, τοῦ ἐπάνω τοῦ στερεώματος. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Καὶ ἐκάλεσεν ὁ Θεὸς τὸ στερέωμα οὐρανόν· καὶ εἶδεν ὁ Θεὸς ὅτι καλόν· καὶ ἐγένετο ἑσπέρα, καὶ ἐγένετο πρωῒ, ἡμέρα δευτέρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Καὶ εἶπεν ὁ Θεὸς, συναχθήτω τὸ ὕδωρ τὸ ὑποκάτω τοῦ οὐρανοῦ εἰς συναγωγὴν μίαν, καὶ ὀφθήτω ἡ ξηρά· καὶ ἐγένετο οὕτως· καὶ συνήχθη τὸ ὕδωρ τὸ ὑποκάτω τοῦ οὐρανοῦ εἰς τὰς συναγωγὰς αὐτῶν, καὶ ὤφθη ἡ ξηρά. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Καὶ ἐκάλεσεν ὁ Θεὸς τὴν ξηρὰν, γῆν· καὶ τὰ συστήματα τῶν ὑδάτων ἐκάλεσε θαλάσσας· καὶ εἶδεν ὁ Θεὸς ὅτι καλόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Καὶ εἶπεν ὁ Θεὸς, βλαστησάτω ἡ γῆ βοτάνην χόρτου, σπεῖρον σπέρμα κατὰ γένος καὶ καθʼ ὁμοιότητα, καὶ ξύλον κάρπιμον ποιοῦν καρπὸν, οὗ τὸ σπέρμα αὐτοῦ ἐν αὐτῷ κατὰ γένος ἐπὶ τῆς γῆς· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Καὶ ἐξήνεγκεν ἡ γῆ βοτάνην χόρτου, σπεῖρον σπέρμα κατὰ γένος καὶ καθʼ ὁμοιότητα, καὶ ξύλον κάρπιμον ποιοῦν καρπὸν, οὗ τὸ σπέρμα αὐτοῦ ἐν αὐτῷ κατὰ γένος ἐπὶ τῆς γῆς· καὶ εἶδεν ὁ Θεὸς ὅτι καλόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Καὶ ἐγένετο ἑσπέρα, καὶ ἐγένετο πρωῒ, ἡμέρα τρίτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Καὶ εἶπεν ὁ Θεὸς, γενηθήτωσαν φωστῆρες ἐν τῷ στερεώματι τοῦ οὐρανοῦ εἰς φαῦσιν ἐπὶ τῆς γῆς, τοῦ διαχωρίζειν ἀνὰ μέσον τῆς ἡμέρας καὶ ἀνὰ μέσον τῆς νυκτός· καὶ ἔστωσαν εἰς σημεῖα, καὶ εἰς καιροὺς, καὶ εἰς ἡμέρας, καὶ εἰς ἐνιαυτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Καὶ ἔστωσαν εἰς φαῦσιν ἐν τῷ στερεώματι τοῦ οὐρανοῦ, ὥστε φαίνειν ἐπὶ τῆς γῆς· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Καὶ ἐποίησεν ὁ Θεὸς τοὺς δύο φωστῆρας τοὺς μεγάλους· τὸν φωστῆρα τὸν μέγαν εἰς ἀρχὰς τῆς ἡμέρας, καὶ τὸν φωστῆρα τὸν ἐλάσσω εἰς ἀρχὰς τῆς νυκτὸς, καὶ τοὺς ἀστέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Καὶ ἔθετο αὐτοὺς ὁ Θεὸς ἐν τῷ στερεώματι τοῦ οὐρανοῦ, ὥστε φαίνειν ἐπὶ τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","καὶ ἄρχειν τῆς ἡμέρας καὶ τῆς νυκτὸς, καὶ διαχωρίζειν ἀνὰ μέσον τοῦ φωτὸς, καὶ ἀνὰ μέσον τοῦ σκότους· καὶ εἶδεν ὁ Θεὸς ὅτι καλόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Καὶ ἐγένετο ἑσπέρα καὶ ἐγένετο πρωῒ, ἡμέρα τετάρτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Καὶ εἶπεν ὁ Θεὸς, ἐξαγαγέτω τὰ ὕδατα ἑρπετὰ ψυχῶν ζωσῶν, καὶ πετεινὰ πετόμενα ἐπὶ τῆς γῆς κατὰ τὸ στερέωμα τοῦ οὐρανοῦ· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Καὶ ἐποίησεν ὁ Θεὸς τὰ κήτη τὰ μεγάλα, καὶ πᾶσαν ψυχὴν ζώων ἑρπετῶν, ἃ ἐξήγαγε τὰ ὕδατα κατὰ γένη αὐτῶν, καὶ πᾶν πετεινὸν πτερωτὸν κατὰ γένος· καὶ εἶδεν ὁ Θεὸς ὅτι καλά. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Καὶ εὐλόγησεν αὐτὰ ὁ Θεὸς, λέγων, αὐξάνεσθε καὶ πληθύνεσθε, καὶ πληρώσατε τὰ ὕδατα ἐν ταῖς θαλάσσαις, καὶ τὰ πετεινὰ πληθυνέσθωσαν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Καὶ ἐγένετο ἑσπέρα, καὶ ἐγένετο πρωῒ, ἡμέρα πέμπτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Καὶ εἶπεν ὁ Θεὸς, ἐξαγαγέτω ἡ γῆ ψυχὴν ζῶσαν κατὰ γένος, τετράποδα, καὶ ἑρπετὰ, καὶ θηρία τῆς γῆς κατὰ γένος· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Καὶ ἐποίησεν ὁ Θεὸς τὰ θηρία τῆς γῆς κατὰ γένος, καὶ τὰ κτήνη κατὰ γένος αὐτῶν, καὶ πάντα τὰ ἑρπετὰ τῆς γῆς κατὰ γένος· καὶ εἶδεν ὁ Θεὸς ὅτι καλά. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Καὶ εἶπεν ὁ Θεός, Ποιήσωμεν ἄνθρωπον κατʼ εἰκόνα ἡμετέραν καὶ καθʼ ὁμοίωσιν· καὶ ἀρχέτωσαν τῶν ἰχθύων τῆς θαλάσσης, καὶ τῶν πετεινῶν τοῦ οὐρανοῦ, καὶ τῶν κτηνῶν, καὶ πάσης τῆς γῆς, καὶ πάντων τῶν ἑρπετῶν τῶν ἑρπόντων ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Καὶ ἐποιήσεν ὁ Θεὸς τὸν ἄνθρωπον· κατʼ εἰκόνα Θεοῦ ἐποίησεν αὐτόν· ἄρσεν καὶ θῆλυ ἐποίησεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Καὶ εὐλόγησεν αὐτοὺς ὁ Θεὸς, λέγων, αὐξάνεσθε καὶ πληθύνεσθε, καὶ πληρώσατε τὴν γῆν, καὶ κατακυριεύσατε αὐτῆς· καὶ ἄρχετε τῶν ἰχθύων τῆς θαλάσσης, καὶ τῶν πετεινῶν τοῦ οὐρανοῦ, καὶ πάντων τῶν κτηνῶν, καὶ πάσης τῆς γῆς, καὶ πάντων τῶν ἑρπετῶν τῶν ἑρπόντων ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Καὶ εἶπεν ὁ Θεός, Ἰδοὺ δέδωκα ὑμῖν πάντα χόρτον σπόριμον σπεῖρον σπέρμα, ὅ ἐστιν ἐπάνω πάσης τῆς γῆς· καὶ πᾶν ξύλον, ὃ ἔχει ἐν ἑαυτῷ καρπὸν σπέρματος σπορίμου, ὑμῖν ἔσται εἰς βρῶσιν, ");
INSERT INTO grcbrent_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","καὶ πᾶσι τοῖς θηρίοις τῆς γῆς, καὶ πᾶσι τοῖς πετεινοῖς τοῦ οὐρανοῦ, καὶ παντὶ ἑρπετῷ ἕρποντι ἐπὶ τῆς γῆς, ὃ ἔχει ἐν ἑαυτῷ ψυχὴν ζωῆς, καὶ πάντα χόρτον χλωρὸν εἰς βρῶσιν· καὶ ἐγένετο οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Καὶ εἶδεν ὁ Θεὸς τὰ πάντα, ὅσα ἐποίησε, καὶ ἰδοὺ καλὰ λίαν· καὶ ἐγένετο ἑσπέρα, καὶ ἐγένετο πρωῒ, ἡμέρα ἕκτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Καὶ συνετελέσθησαν ὁ οὐρανὸς καὶ ἡ γῆ, καὶ πᾶς ὁ κόσμος αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Καὶ συνετέλεσεν ὁ Θεὸς ἐν τῇ ἡμέρᾳ τῇ ἕκτῃ τὰ ἔργα αὐτοῦ, ἃ ἐποίησε· καὶ κατέπαυσε τῇ ἡμέρᾳ τῇ ἑβδόμῃ ἀπὸ πάντων τῶν ἔργων αὐτοῦ, ὧν ἐποίησε. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Καὶ εὐλόγησεν ὁ Θεὸς τὴν ἡμέραν τὴν ἑβδόμην, καὶ ἡγίασεν αὐτήν, ὅτι ἐν αὐτῇ κατέπαυσεν ἀπὸ πάντων τῶν ἔργων αὐτοῦ, ὧν ἤρξατο ὁ Θεὸς ποιῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Αὕτη ἡ βίβλος γενέσεως οὐρανοῦ καὶ γῆς, ὅτε ἐγένετο, ᾗ ἡμέρᾳ ἐποίησε Κύριος ὁ Θεὸς τὸν οὐρανὸν καὶ τὴν γῆν, ");
INSERT INTO grcbrent_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","καὶ πᾶν χλωρὸν ἀγροῦ πρὸ τοῦ γενέσθαι ἐπὶ τῆς γῆς, καὶ πάντα χόρτον ἀγροῦ πρὸ τοῦ ἀνατεῖλαι· οὐ γὰρ ἔβρεξεν ὁ Θεὸς ἐπὶ τὴν γῆν, καὶ ἄνθρωπος οὐκ ἦν ἐργάζεσθαι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Πηγὴ δὲ ἀνέβαινεν ἐκ τῆς γῆς, καὶ ἐπότιζε πᾶν τὸ πρόσωπον τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Καὶ ἔπλασεν ὁ Θεὸς τὸν ἄνθρωπον, χοῦν ἀπὸ τῆς γῆς· καὶ ἐνεφύσησεν εἰς τὸ πρόσωπον αὐτοῦ πνοὴν ζωῆς, καὶ ἐγένετο ὁ ἄνθρωπος εἰς ψυχὴν ζῶσαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Καὶ ἐφύτευσεν ὁ Θεὸς παράδεισον ἐν Ἐδὲμ κατὰ ἀνατολάς· καὶ ἔθετο ἐκεῖ τὸν ἄνθρωπον, ὃν ἔπλασε. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Καὶ ἐξανέτειλεν ὁ Θεὸς ἔτι ἐκ τῆς γῆς πᾶν ξύλον ὡραῖον εἰς ὅρασιν, καὶ καλὸν εἰς βρῶσιν, καὶ τὸ ξύλον τῆς ζωῆς ἐν μέσῳ τοῦ παραδείσου, καὶ τὸ ξύλον τοῦ εἰδέναι γνωστὸν καλοῦ καὶ πονηροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ποταμὸς δὲ ἐκπορεύεται ἐξ Ἐδὲμ ποτίζειν τὸν παράδεισον· ἐκεῖθεν ἀφορίζεται εἰς τέσσαρας ἀρχάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ὄνομα τῷ ἑνὶ, Φισῶν· οὗτος ὁ κυκλῶν πᾶσαν τὴν γῆν Εὐιλάτ· ἐκεῖ οὗ ἐστι τὸ χρυσίον. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Τὸ δὲ χρυσίον τῆς γῆς ἐκείνης καλόν· καὶ ἐκεῖ ἐστιν ὁ ἄνθραξ, καὶ ὁ λίθος ὁ πράσινος. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Καὶ ὄνομα τῷ ποταμῷ τῷ δευτέρῳ, Γεῶν· οὗτος ὁ κυκλῶν πᾶσαν τὴν γὴν Αἰθιοπίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Καὶ ὁ ποταμὸς ὁ τρίτος, Τίγρις· οὗτος ὁ προπορευόμενος κατέναντι Ἀσσυρίων· ὁ δὲ ποταμὸς ὁ τέταρτος, Εὐφράτης. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Καὶ ἔλαβε Κύριος ὁ Θεὸς τὸν ἄνθρωπον ὃν ἔπλασε, καὶ ἔθετο αὐτὸν ἐν τῷ παραδείσῳ τῆς τρυφῆς, ἐργάζεσθαι αὐτὸν καὶ φυλάσσειν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Καὶ ἐνετείλατο Κύριος ὁ Θεὸς τῷ Ἀδὰμ, λέγων, ἀπὸ παντὸς ξύλου τοῦ ἐν τῷ παραδείσῳ βρώσει φαγῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ἀπὸ δὲ τοῦ ξύλου τοῦ γινώσκειν καλὸν καὶ πονηρὸν, οὐ φάγεσθε ἀπʼ αὐτοῦ· ᾗ δʼ ἂν ἡμέρᾳ φάγητε ἀπʼ αὐτοῦ, θανάτῳ ἀποθανεῖσθε. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Καὶ εἶπε Κύριος ὁ Θεὸς, οὐ καλὸν εἶναι τὸν ἄνθρωπον μόνον· ποιήσωμεν αὐτῷ βοηθὸν κατʼ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Καὶ ἔπλασεν ὁ Θεὸς ἔτι ἐκ τῆς γῆς πάντα τὰ θηρία τοῦ ἀγροῦ, καὶ πάντα τὰ πετεινὰ τοῦ οὐρανοῦ· καὶ ἤγαγεν αὐτὰ πρὸς τὸν Ἀδὰμ, ἰδεῖν τί καλέσει αὐτά· καὶ πᾶν ὃ ἐὰν ἐκάλεσεν αὐτὸ Ἀδὰμ ψυχὴν ζῶσαν, τοῦτο ὄνομα αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Καὶ ἐκάλεσεν Ἀδὰμ ὀνόματα πᾶσι τοῖς κτήνεσι, καὶ πᾶσι τοῖς πετεινοῖς τοῦ οὐρανοῦ, καὶ πᾶσι τοῖς θηρίοις τοῦ ἀγροῦ· τῷ δὲ Ἀδὰμ οὐχ εὑρέθη βοηθὸς ὅμοιος αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Καὶ ἐπέβαλεν ὁ Θεὸς ἔκστασιν ἐπὶ τὸν Ἀδὰμ, καὶ ὕπνωσε· καὶ ἔλαβε μίαν τῶν πλευρῶν αὐτοῦ, καὶ ἀνεπλήρωσε σάρκα ἀντʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Καὶ ᾠκοδόμησεν ὁ Θεὸς τὴν πλευρὰν, ἣν ἔλαβεν ἀπὸ τοῦ Ἀδὰμ εἰς γυναῖκα· καὶ ἤγαγεν αὐτὴν πρὸς τὸν Ἀδάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Καὶ εἶπεν Ἀδάμ· τοῦτο νῦν ὀστοῦν ἐκ τῶν ὀστέων μου, καὶ σὰρξ ἐκ τῆς σαρκός μου· αὕτη κληθήσεται γυνὴ, ὅτι ἐκ τοῦ ἀνδρὸς αὐτῆς ἐλήφθη. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ἕνεκεν τούτου καταλείψει ἄνθρωπος τὸν πατέρα αὐτοῦ καὶ τὴν μητέρα, καὶ προσκολληθήσεται πρὸς τὴν γυναῖκα αὐτοῦ· καὶ ἔσονται οἱ δύο εἰς σάρκα μίαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Καὶ ἦσαν οἱ δύο γυμνοὶ, ὅ, τε Ἀδὰμ καὶ ἡ γυνὴ αὐτοῦ, καὶ οὐκ ᾐσχύνοντο. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ὁ δὲ ὄφις ἦν φρονιμώτατος πάντων τῶν θηρίων τῶν ἐπὶ τῆς γῆς, ὧν ἐποίησε Κύριος ὁ Θεός· καὶ εἶπεν ὁ ὄφις τῇ γυναικὶ, τί ὅτι εἶπεν ὁ Θεός, οὐ μὴ φάγητε ἀπὸ παντὸς ξύλου τοῦ παραδείσου; ");
INSERT INTO grcbrent_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Καὶ εἶπεν ἡ γυνὴ τῷ ὄφει, ἀπὸ καρποῦ τοῦ ξύλου τοῦ παραδείσου φαγούμεθα· ");
INSERT INTO grcbrent_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ἀπὸ δὲ τοῦ καρποῦ τοῦ ξύλου, ὅ ἐστιν ἐν μέσῳ τοῦ παραδείσου, εἶπεν ὁ Θεός, οὐ φάγεσθε ἀπʼ αὐτοῦ, οὐδὲ μὴ ἅψησθε αὐτοῦ, ἵνα μὴ ἀποθάνητε. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Καὶ εἶπεν ὁ ὄφις τῇ γυναικί· οὐ θανάτῳ ἀποθανεῖσθε· ");
INSERT INTO grcbrent_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ἤδει γὰρ ὁ Θεὸς, ὅτι ᾗ ἂν ἡμέρᾳ φάγητε ἀπʼ αὐτοῦ, διανοιχθήσονται ὑμῶν οἱ ὀφθαλμοί, καὶ ἔσεσθε ὡς θεοί, γινώσκοντες καλὸν καὶ πονηρόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Καὶ εἶδεν ἡ γυνὴ, ὅτι καλὸν τὸ ξύλον εἰς βρῶσιν, καὶ ὅτι ἀρεστὸν τοῖς ὀφθαλμοῖς ἰδεῖν, καὶ ὡραῖόν ἐστι τοῦ κατανοῆσαι· καὶ λαβοῦσα ἀπὸ τοῦ καρποῦ αὐτοῦ, ἔφαγε· καὶ ἔδωκε καὶ τῷ ἀνδρὶ αὐτῆς μετʼ αὐτῆς, καὶ ἔφαγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Καὶ διηνοίχθησαν οἱ ὀφθαλμοὶ τῶν δύο, καὶ ἔγνωσαν ὅτι γυμνοὶ ἦσαν· καὶ ἔῤῥαψαν φύλλα συκῆς, καὶ ἐποίησαν ἑαυτοῖς περιζώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Καὶ ἤκουσαν τὴς φωνὴς Κυρίου τοῦ Θεοῦ περιπατοῦντος ἐν τῷ παραδείσῳ τὸ δειλινόν· καὶ ἐκρύβησαν ὅ, τε Ἀδὰμ καὶ ἡ γυνὴ αὐτοῦ ἀπὸ προσώπου Κυρίου τοῦ Θεοῦ ἐν μέσῳ τοῦ ξύλου τοῦ παραδείσου. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Καὶ ἐκάλεσεν Κύριος ὁ Θεὸς τὸν Ἀδὰμ, καὶ εἶπεν αὐτῷ· Ἀδὰμ ποῦ εἶ; ");
INSERT INTO grcbrent_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Καὶ εἶπεν αὐτῷ· τὴς φωνῆς σου ἤκουσα περιπατοῦντος ἐν τῷ παραδείσῳ, καὶ ἐφοβήθην ὅτι γυμνός εἰμι, καὶ ἐκρύβην. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Καὶ εἶπεν αὐτῷ ὁ Θεὸς, τὶς ἀνήγγειλέ σοι ὅτι γυμνὸς εἶ, εἰ μὴ ἀπὸ τοῦ ξύλου, οὗ ἐνετειλάμην σοι τούτου μόνου μὴ φαγεῖν, ἀπʼ αὐτοῦ ἔφαγες; ");
INSERT INTO grcbrent_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Καὶ εἶπεν ὁ Ἀδάμ· ἡ γυνή, ἣν ἔδωκας μετʼ ἐμοῦ, αὕτη μοι ἔδωκεν ἀπὸ τοῦ ξύλου, καὶ ἔφαγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Καὶ εἶπε Κύριος ὁ Θεὸς τῇ γυναικί· τί τοῦτο ἐποιήσας; καὶ εἶπεν ἡ γυνὴ, ὁ ὄφις ἠπάτησέ με, καὶ ἔφαγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Καὶ εἶπε Κύριος ὁ Θεὸς τῷ ὄφει· ὅτι ἐποίησας τοῦτο, ἐπικατάρατος σὺ ἀπὸ πάντων τῶν κτηνῶν, καὶ ἀπὸ πάντων τῶν θηρίων τῶν ἐπὶ τῆς γῆς· ἐπὶ τῷ στήθει σου καὶ τῇ κοιλίᾳ πορεύσῃ, καὶ γῆν φαγῃ πάσας τὰς ἡμέρας τῆς ζωῆς σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Καὶ ἔχθραν θήσω ἀνὰ μέσον σοῦ καὶ ἀνὰ μέσον τῆς γυναικὸς, καὶ ἀνὰ μέσον τοῦ σπέρματός σου, καὶ ἀνὰ μέσον τοῦ σπέρματος αὐτῆς· αὐτός σοῦ τηρήσει κεφαλὴν, καὶ σὺ τηρήσεις αὐτοῦ πτέρναν. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Καὶ τῇ γυναικὶ εἶπε· πληθύνων πληθυνῶ τὰς λύπας σου, καὶ τὸν στεναγμόν σου· ἐν λύπαις τέξῃ τέκνα, καὶ πρὸς τὸν ἄνδρα σου ἡ ἀποστροφή σου· καὶ αὐτός σου κυριεύσει. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Τῷ δὲ Ἀδὰμ εἶπεν· ὅτι ἤκουσας τῆς φωνῆς τῆς γυναικός σου, καὶ ἔφαγες ἀπὸ τοῦ ξύλου, οὗ ἐνετειλάμην σοι τούτου μόνου μὴ φαγεῖν, ἀπʼ αὐτοῦ ἔφαγες, ἐπικατάρατος ἡ γῆ ἐν τοῖς ἔργοις σου· ἐν λύπαις φάγῃ αὐτὴν πάσας τὰς ἡμέρας τῆς ζωῆς σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ἀκάνθας καὶ τριβόλους ἀνατελεῖ σοι, καὶ φαγῇ τὸν χόρτον τοῦ ἀγροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ἐν ἱδρῶτι τοῦ προσώπου σου φαγῃ τὸν ἄρτον σου, ἕως τοῦ ἀποστρέψαι σε εἰς τὴν γῆν ἐξ ἧς ἐλήμφθης· ὅτι γῆ εἶ, καὶ εἰς γῆν ἀπελεύσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Καὶ ἐκάλεσεν Ἀδὰμ τὸ ὄνομα τῆς γυναικὸς αὐτοῦ Ζωή, ὅτι μήτηρ πάντων τῶν ζώντων. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Καὶ ἐποίησε Κύριος ὁ Θεὸς τῷ Ἀδὰμ, καὶ τῇ γυναικὶ αὐτοῦ χιτῶνας δερματίνους, καὶ ἐνέδυσεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Καὶ εἶπεν ὁ Θεός, ἰδοὺ Ἀδὰμ γέγονεν ὡς εἷς ἐξ ἡμῶν, τοῦ γινώσκειν καλὸν καὶ πονηρόν· καὶ νῦν μή ποτε ἐκτείνῃ τὴν χεῖρα αὐτοῦ, καὶ λάβῃ τοῦ ξύλου τῆς ζωῆς καὶ φάγῃ, καὶ ζήσεται εἰς τὸν αἰῶνα. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Καὶ ἐξαπέστειλεν αὐτὸν Κύριος ὁ Θεὸς ἐκ τοῦ παραδείσου τῆς τρυφῆς, ἐργάζεσθαι τὴν γῆν ἐξ ἧς ἐλήμφθη. ");
INSERT INTO grcbrent_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Καὶ ἐξέβαλεν τὸν Ἀδὰμ, καὶ κατῴκισεν αὐτὸν ἀπέναντι τοῦ παραδείσου τῆς τρυφῆς· καὶ ἔταξε τὰ χερουβὶμ· καὶ τὴν φλογίνην ῥομφαίαν τὴν στρεφομένην, φυλάσσειν τὴν ὁδὸν τοῦ ξύλου τῆς ζωῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ἀδὰμ δὲ ἔγνω Εὔαν τὴν γυναῖκα αὐτοῦ, καὶ συλλαβοῦσα ἔτεκε τὸν Κάϊν· καὶ εἶπεν, ἐκτησάμην ἄνθρωπον διὰ τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Καὶ προσέθηκε τεκεῖν τὸν ἀδελφὸν αὐτοῦ τὸν Ἄβελ· καὶ ἐγένετο Ἄβελ ποιμὴν προβάτων, Κάϊν δὲ ἦν ἐργαζόμενος τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Καὶ ἐγένετο μεθʼ ἡμέρας ἤνεγκε Κάϊν ἀπὸ τῶν καρπῶν τῆς γῆς θυσίαν τῷ Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Καὶ Ἄβελ ἤνεγκε καὶ αὐτὸς ἀπὸ τῶν πρωτοτόκων τῶν προβάτων αὐτοῦ, καὶ ἀπὸ τῶν στεάτων αὐτῶν· καὶ ἐπεῖδεν ὁ Θεὸς ἐπὶ Ἄβελ, καὶ ἐπὶ τοῖς δώροις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ἐπὶ δὲ Κάϊν, καὶ ἐπὶ ταῖς θυσίαις αὐτοῦ, οὐ προσέσχε· καὶ ἐλυπήθη Κάϊν λίαν, καὶ συνέπεσε τῷ προσώπῳ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Καὶ εἶπε Κύριος ὁ Θεὸς τῷ Κάϊν, ἵνα τί περίλυπος ἐγένου, καὶ ἵνα τί συνέπεσε τὸ πρόσωπόν σου; ");
INSERT INTO grcbrent_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Οὐκ ἐὰν ὀρθῶς προσενέγκῃς, ὀρθῶς δὲ μὴ διέλῃς, ἥμαρτες; ἡσυχασον· πρός σὲ ἡ ἀποστροφὴ αὐτοῦ, καὶ σὺ ἄρξεις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Καὶ εἶπεν Κάϊν πρὸς Ἄβελ τὸν ἀδελφὸν αὐτοῦ, διέλθωμεν εἰς τὸ πεδίον· καὶ ἐγένετο ἐν τῷ εἶναι αὐτοὺς ἐν τῷ πεδίῳ, ἀνέστη Κάϊν ἐπὶ Ἄβελ τὸν ἀδελφὸν αὐτοῦ, καὶ ἀπέκτεινεν αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Καὶ εἶπε Κύριος ὁ Θεὸς πρὸς Κάϊν· ποῦ ἔστιν Ἄβελ ὁ ἀδελφός σου; καὶ εἶπεν, οὐ γινώσκω· μὴ φύλαξ τοῦ ἀδελφοῦ μου εἰμὶ ἐγώ; ");
INSERT INTO grcbrent_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Καὶ εἶπε Κύριος, τί πεποίηκας; φωνὴ αἵματος τοῦ ἀδελφοῦ σου βοᾷ πρός με ἐκ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Καὶ νῦν ἐπικατάρατος σὺ ἀπὸ τῆς γῆς, ἣ ἔχανε τὸ στόμα αὐτῆς δέξασθαι τὸ αἷμα τοῦ ἀδελφοῦ σου ἐκ τῆς χειρός σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ὅτε ἐργᾷ τὴν γῆν, καὶ οὐ προσθήσει τὴν ἰσχὺν αὐτῆς δοῦναί σοι· στένων καὶ τρέμων ἐσῃ ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Καὶ εἶπε Κάϊν πρὸς Κύριον τὸν Θεὸν, μείζων ἡ αἰτία μου τοῦ ἀφεθῆναί με. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Εἰ ἐκβάλλεις με σήμερον ἀπὸ προσώπου τῆς γῆς, καὶ ἀπὸ τοῦ προσώπου σου κρυβήσομαι, καὶ ἔσομαι στένων καὶ τρέμων ἐπὶ τῆς γῆς, καὶ ἔσται πᾶς ὁ εὑρίσκων με, ἀποκτενεῖ με. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Καὶ εἴπεν αὐτῷ Κύριος ὁ Θεὸς, οὐχ οὕτω· πᾶς ὁ ἀποκτείνας Κάϊν, ἑπτὰ ἐκδικούμενα παραλύσει. Καὶ ἔθετο Κύριος ὁ Θεὸς σημεῖον τῷ Κάϊν, τοῦ μὴ ἀνελεῖν αὐτὸν πάντα τὸν εὑρίσκοντα αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ἐξῆλθεν δὲ Κάϊν ἀπὸ προσώπου τοῦ Θεοῦ, καὶ ᾤκησεν ἐν γῇ Ναὶδ κατέναντι Ἐδέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Καὶ ἔγνω Κάϊν τὴν γυναῖκα αὐτοῦ· καὶ συλλαβοῦσα ἔτεκε τὸν Ἐνώχ. Καὶ ἦν οἰκοδομῶν πόλιν· καὶ ἐπῳνόμασε τὴν πόλιν ἐπὶ τῷ ὀνόματι τοῦ υἱοῦ αὐτοῦ, Ἐνώχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ἐγενήθη δὲ τῷ Ἐνὼχ Γαϊδάδ· καὶ Γαϊδὰδ ἐγέννησε τὸν Μαλελεὴλ· καὶ Μαλελεὴλ ἐγέννησε τὸν Μαθουσάλα· καὶ Μαθουσάλα ἐγέννησε τὸν Λάμεχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Καὶ ἔλαβεν ἑαυτῷ Λάμεχ δύο γυναῖκας· ὄνομα τῇ μιᾷ, Ἀδά· καὶ ὄνομα τῇ δευτέρᾳ, Σελλά. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Καὶ ἔτεκεν Ἀδὰ τὸν Ἰωβήλ· οὗτος ἦν πατὴρ οἰκούντων ἐν σκηναῖς κτηνοτρόφων. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Καὶ ὄνομα τῷ ἀδελφῷ αὐτοῦ, Ἰουβάλ· οὗτος ἦν ὁ καταδείξας ψαλτήριον καὶ κιθάραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Σελλὰ δὲ καὶ αὐτὴ ἔτεκε τὸν Θόβελ· καὶ ἦν σφυροκόπος χαλκεὺς χαλκοῦ καὶ σιδήρου. ἀδελφὴ δὲ Θόβελ, Νοεμά. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Εἶπε δὲ Λάμεχ ταῖς ἑαυτοῦ γυναιξίν, Ἀδὰ καὶ Σελλὰ, ἀκούσατέ μου τῆς φωνῆς, γυναῖκες Λάμεχ, ἐνωτίσασθέ μου τοὺς λόγους· ὅτι ἄνδρα ἀπέκτεινα εἰς τραῦμα ἐμοὶ, καὶ νεανίσκον εἰς μώλωπα ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ὅτι ἑπτάκις ἐκδεδίκηται ἐκ Κάϊν· ἐκ δὲ Λάμεχ, ἑβδομηκοντάκις ἑπτά. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ἔγνω δὲ Ἀδὰμ Εὔαν τὴν γυναῖκα αὐτοῦ· καὶ συλλαβοῦσα ἔτεκεν υἱόν· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ Σὴθ, λέγουσα, ἐξανέστησε γάρ μοι ὁ Θεὸς σπέρμα ἕτερον ἀντὶ Ἄβελ, ὃν ἀπέκτεινε Κάϊν. ");
INSERT INTO grcbrent_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Καὶ τῷ Σὴθ ἐγένετο υἱός· ἐπωνόμασε δὲ τὸ ὄνομα αὐτοῦ, Ἑνώς· οὗτος ἤλπισεν ἐπικαλεῖσθαι τὸ ὄνομα Κυρίου τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Αὕτη ἡ βίβλος γενέσεως ἀνθρώπων· ᾗ ἡμέρᾳ ἐποίησεν ὁ Θεὸς τὸν Ἀδὰμ, κατʼ εἰκόνα Θεοῦ ἐποίησεν αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ἄρσεν καὶ θῆλυ ἐποίησεν αὐτούς· καὶ εὐλόγησεν αὐτούς· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ Ἀδὰμ, ᾗ ἡμέρᾳ ἐποίησεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ἔζησεν δὲ Ἀδὰμ τριάκοντα καὶ διακόσια ἔτη, καὶ ἐγέννησε κατὰ τὴν ἰδέαν αὐτοῦ, καὶ κατὰ τὴν εἰκόνα αὐτοῦ, καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ, Σήθ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ἐγένοντο δὲ αἱ ἡμέραι Ἀδὰμ, ἃς ἔζησε μετὰ τὸ γεννῆσαι αὐτὸν τὸν Σὴθ, ἔτη ἑπτακόσια· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Ἀδὰμ, ἃς ἔζησε, τριάκοντα καὶ ἐννακόσια ἔτη· καὶ ἀπέθανεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ἔζησε δὲ Σὴθ πέντε καὶ διακόσια ἔτη· καὶ ἐγέννησε τὸν Ἐνώς. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Καὶ ἔζησε Σὴθ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ἐνὼς, ἑπτὰ ἔτη καὶ ἑπτακόσια· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Σὴθ δώδεκα καὶ ἐννακόσια ἔτη· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Καὶ ἔζησεν Ἐνὼς ἔτη ἑκατὸν ἐννεήκοντα· καὶ ἐγέννησε τὸν Καϊνᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Καὶ ἔζησεν Ἐνὼς μετὰ τὸ γεννῆσαι αὐτὸν τὸν Καϊνᾶν, πεντεκαίδεκα ἔτη καὶ ἑπτκόσια· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Ἐνὼς πέντε ἔτη καὶ ἐννακόσια· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Καὶ ἔζησεν Καϊνᾶν ἑβδομήκοντα καὶ ἑκατὸν ἔτη· καὶ ἐγέννησε τὸν Μαλελεήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Καὶ ἔζησε Καϊνᾶν μετὰ τὸ γεννῆσαι αὐτὸν τὸν Μαλελεὴλ, τεσσεράκοντα καὶ ἑπτακόσια ἔτη· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Καϊνᾶν δέκα ἔτη καὶ ἐννακόσια· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Καὶ ἔζησε Μαλελεὴλ πέντε καὶ ἑξήκοντα καὶ ἑκατὸν ἔτη· καὶ ἐγέννησε τὸν Ἰάρεδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Καὶ ἔζησε Μαλελεὴλ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ἰάρεδ, ἔτη τριάκοντα καὶ ἑπτακόσια· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Μαλελεὴλ, ἔτη πέντε καὶ ἐννενήκοντα καὶ ὀκτακόσια· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Καὶ ἔζησεν Ἰάρεδ δύο καὶ ἑξήκοντα ἔτη καὶ ἑκατὸν· καὶ ἐγέννησε τὸν Ἐνώχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Καὶ ἔζησεν Ἰάρεδ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ἐνὼχ, ὀκτακόσια ἔτη· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Ἰάρεδ, δύο καὶ ἑξήκοντα καὶ ἐννακόσια ἔτη· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Καὶ ἔζησεν Ἐνὼχ πέντε καὶ ἑξήκοντα καὶ ἑκατὸν ἔτη· καὶ ἐγέννησε τὸν Μαθουσάλα. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Εὐηρέστησε δὲ Ἐνὼχ τῷ Θεῷ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Μαθουσάλα, διακόσια ἔτη· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Ἐνὼχ, πέντε καὶ ἑξήκοντα καὶ τριακόσια ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Καὶ εὐηρέστησεν Ἐνὼχ τῷ Θεῷ· καὶ οὐχ εὑρίσκετο, ὅτι μετέθηκεν αὐτὸν ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Καὶ ἔζησε Μαθουσάλα ἑπτὰ ἔτη καὶ ἑξήκοντα καὶ ἑκατόν· καὶ ἐγέννησε τὸν Λάμεχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Καὶ ἔζησε Μαθουσάλα μετὰ τὸ γεννῆσαι αὐτὸν τὸν Λάμεχ, δύο καὶ ὀκτακόσια ἔτη· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Μαθουσάλα ἃς ἔζησεν, ἐννέα καὶ ἑξήκοντα καὶ ἐννακόσια ἔτη· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Καὶ ἔζησε Λάμεχ ὀκτὼ καὶ ὀγδοήκοντα καὶ ἑκατὸν ἔτη· καὶ ἐγέννησεν υἱόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ Νῶε, λέγων, οὗτος διαναπαύσει ἡμᾶς ἀπὸ τῶν ἔργων ἡμῶν, καὶ ἀπὸ τῶν λυπῶν τῶν χειρῶν ἡμῶν, καὶ ἀπὸ τῆς γῆς, ἧς κατηράσατο Κύριος ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Καὶ ἔζησε Λάμεχ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Νῶε, πεντακόσια καὶ ἑξήκοντα καὶ πέντε ἔτη· καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Λάμεχ, ἑπτακόσια καὶ πεντήκοντα τρία ἔτη· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Καὶ ἦν Νῶε ἐτῶν πεντακοσίων· καὶ ἐγέννησε τρεῖς υἱοὺς, τὸν Σὴμ, τὸν Χὰμ, τὸν Ἰάφεθ. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Καὶ ἐγένετο ἡνίκα ἤρξαντο οἱ ἄνθρωποι πολλοὶ γίνεσθαι ἐπὶ τῆς γῆς, καὶ θυγατέρες ἐγεννήθησαν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ἰδόντες δὲ υἱοὶ τοῦ Θεοῦ τὰς θυγατέρας τῶν ἀνθρώπων, ὅτι καλαί εἰσιν, ἔλαβον ἑαυτοῖς γυναῖκας ἀπὸ πασῶν, ὧν ἐξελέξαντο. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Καὶ εἶπε Κύριος ὁ Θεὸς, οὐ μὴ καταμείνῃ τὸ πνεῦμά μου ἐν τοῖς ἀνθρώποις τούτοις εἰς τὸν αἰῶνα, διὰ τὸ εἶναι αὐτοὺς σάρκας· ἔσονται δὲ αἱ ἡμέραι αὐτῶν, ἑκατὸν εἴκοσιν ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Οἱ δὲ γίγαντες ἦσαν ἐπὶ τῆς γῆς ἐν ταῖς ἡμέραις ἐκείναις, καὶ μετʼ ἐκεῖνο, ὡς ἂν εἰσεπορεύοντο οἱ υἱοὶ τοῦ Θεοῦ πρὸς τὰς θυγατέρας τῶν ἀνθρώπων, καὶ ἐγεννῶσαν αὐτοῖς· ἐκεῖνοι ἦσαν οἱ γίγαντες οἱ ἀπʼ αἰῶνος, οἱ ἄνθρωποι οἱ ὀνομαστοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ἰδὼν δὲ Κύριος ὁ Θεὸς, ὅτι ἐπληθύνθησαν αἱ κακίαι τῶν ἀνθρώπων ἐπὶ τῆς γῆς, καὶ πᾶς τις διανοεῖται ἐν τῇ καρδίᾳ αὐτοῦ ἐπιμελῶς ἐπὶ τὰ πονηρὰ πάσας τὰς ἡμέρας· ");
INSERT INTO grcbrent_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Καὶ ἐνεθυμήθη ὁ Θεὸς, ὅτι ἐποίησε τὸν ἄνθρωπον ἐπὶ τῆς γῆς, καὶ διενοήθη. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Καὶ εἶπεν ὁ Θεὸς, ἀπαλείψω τὸν ἄνθρωπον, ὃν ἐποίησα, ἀπὸ προσώπου τῆς γῆς, ἀπὸ ἀνθρώπου ἕως κτήνους, καὶ ἀπὸ ἑρπετῶν ἕως πετεινῶν τοῦ οὐρανοῦ· ὅτι ἐνεθυμήθην, ὅτι ἐποίησα αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Νῶε δὲ εὗρε χάριν ἐναντίον Κυρίου τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Αὗται δὲ αἱ γενέσεις Νῶε. Νῶε ἄνθρωπος δίκαιος, τέλειος ὢν ἐν τῇ γενεᾷ αὐτοῦ, τῷ Θεῷ εὐηρέστησε Νῶε. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ἐγέννησε δὲ Νῶε τρεῖς υἱοὺς, τὸν Σὴμ, τὸν Χὰμ, τὸν Ἰάφεθ. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ἐφθάρη δὲ ἡ γῆ ἐναντίον τοῦ Θεοῦ, καὶ ἐπλήσθη ἡ γῆ ἀδικίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Καὶ εἶδε Κύριος ὁ Θεὸς τὴν γῆν, καὶ ἦν κατεφθαρμένη· ὅτι κατέφθειρε πᾶσα σὰρξ τὴν ὁδὸν αὐτοῦ ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Καὶ εἶπε Κύριος ὁ Θεὸς τῷ Νῶε, καιρὸς παντὸς ἀνθρώπου ἥκει ἐναντίον μου, ὅτι ἐπλήσθη ἡ γῆ ἀδικίας ἀπʼ αὐτῶν· καὶ ἰδοὺ ἐγὼ καταφθείρω αὐτοὺς καὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ποίησον οὖν σεαυτῷ κιβωτὸν ἐκ ξύλων τετραγώνων· νοσσιὰς ποιήσεις τὴν κιβωτόν· καὶ ἀσφαλτώσεις αὐτὴν ἔσωθεν καὶ ἔξωθεν τῇ ἀσφάλτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Καὶ οὕτω ποιήσεις τὴν κιβωτόν· τριακοσίων πήχεων τὸ μῆκος τῆς κιβωτοῦ, καὶ πεντήκοντα πήχεων τὸ πλάτος, καὶ τριάκοντα πήχεων τὸ ὕψος αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ἐπισυνάγων ποιήσεις τὴν κιβωτὸν, καὶ εἰς πῆχυν συντελέσεις αὐτὴν ἄνωθεν· τὴν δὲ θύραν τῆς κιβωτοῦ ποιήσεις ἐκ πλαγίων· κατάγαια διώροφα καὶ τριώροφα ποιήσεις αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ἐγὼ δὲ ἰδοὺ ἐπάγω τὸν κατακλυσμὸν, ὕδωρ ἐπὶ τὴν γῆν, καταφθεῖραι πᾶσαν σάρκα, ἐν ᾗ ἐστι πνεῦμα ζωῆς ὑποκάτω τοῦ οὐρανοῦ· καὶ ὅσα ἂν ᾖ ἐπὶ τῆς γῆς, τελευτήσει. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Καὶ στήσω τὴν διαθήκην μου μετά σου· εἰσελεύσῃ δὲ εἰς τὴν κιβωτὸν σὺ, καὶ οἱ υἱοί σου, καὶ ἡ γυνή σου, καὶ αἱ γυναῖκες τῶν υἱῶν σου μετά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Καὶ ἀπὸ πάντων τῶν κτηνῶν, καὶ ἀπὸ πάντων τῶν ἑρπετῶν, καὶ ἀπὸ πάντων τῶν θηρίων, καὶ ἀπὸ πάσης σαρκὸς δύο δύο ἀπὸ πάντων εἰσάξεις εἰς τὴν κιβωτὸν, ἵνα τρέφῃς μετὰ σεαυτοῦ· ἄρσεν καὶ θῆλυ ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ἀπὸ πάντων τῶν ὀρνέων τῶν πετεινῶν κατὰ γένος, καὶ ἀπὸ πάντων τῶν κτηνῶν κατὰ γένος, καὶ ἀπὸ πάντων τῶν ἑρπετῶν τῶν ἑρπόντων ἐπὶ τῆς γῆς κατὰ γένος αὐτῶν, δύο δύο ἀπὸ πάντων εἰσελεύσονται πρὸς σὲ τρέφεσθαι μετά σου, ἄρσεν καὶ θῆλυ. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Σὺ δὲ λήψῃ σεαυτῷ ἀπὸ πάντων τῶν βρωμάτων ἃ ἔδεσθε, καὶ συνάξεις πρὸς σεαυτὸν, καὶ ἔσται σοι καὶ ἐκείνοις φαγεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Καὶ ἐποίησε Νῶε πάντα ὅσα ἐνετείλατο αὐτῷ Κύριος ὁ Θεὸς, οὕτως ἐποίησε. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Καὶ εἶπε Κύριος ὁ Θεὸς πρὸς Νῶε, εἴσελθε σὺ καὶ πᾶς ὁ οἶκός σου εἰς τὴν κιβωτὸν, ὅτι σὲ εἶδον δίκαιον ἐναντίον μου ἐν τῇ γενεᾷ ταύτῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ἀπὸ δὲ τῶν κτηνῶν τῶν καθαρῶν εἰσάγαγε πρὸς σὲ ἑπτὰ ἑπτὰ ἄρσεν καὶ θῆλυ, ἀπὸ δὲ τῶν κτηνῶν τῶν μὴ καθαρῶν δύο δύο ἄρσεν καὶ θῆλυ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Καὶ ἀπὸ τῶν πετεινῶν τοῦ οὐρανοῦ τῶν καθαρῶν ἑπτὰ ἑπτὰ ἄρσεν καὶ θῆλυ, καὶ ἀπὸ πάντων τῶν πετεινῶν τῶν μὴ καθαρῶν δύο δύο ἄρσεν καὶ θῆλυ, διαθρέψαι σπέρμα ἐπὶ πᾶσαν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ἔτι γὰρ ἡμερῶν ἑπτὰ ἐγὼ ἐπάγω ὑετὸν ἐπὶ τὴν γῆν, τεσσαράκοντα ἡμέρας καὶ τεσσαράκοντα νύκτας· καὶ ἐξαλείψω πᾶν τὸ ἀνάστημα, ὃ ἐποίησα ἀπὸ προσώπου πάσης τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Καὶ ἐποίησε Νῶε πάντα, ὅσα ἐνετείλατο αὐτῷ Κύριος ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Νῶε δὲ ἦν ἐτῶν ἑξακοσίων, καὶ ὁ κατακλυσμὸς τοῦ ὕδατος ἐγένετο ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Εἰσῆλθε δὲ Νῶε καὶ οἱ υἱοὶ αὐτοῦ, καὶ ἡ γυνὴ αὐτοῦ, καὶ αἱ γυναῖκες τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ εἰς τὴν κιβωτὸν, διὰ τὸ ὕδωρ τοῦ κατακλυσμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Καὶ ἀπὸ τῶν πετεινῶν τῶν καθαρῶν, καὶ ἀπὸ τῶν πετεινῶν τῶν μὴ καθαρῶν, καὶ ἀπὸ τῶν κτηνῶν τῶν καθαρῶν, καὶ ἀπὸ τῶν κτηνῶν τῶν μὴ καθαρῶν, καὶ ἀπὸ πάντων τῶν ἑρπόντων ἐπὶ τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","δύο δύο εἰσῆλθον πρὸς Νῶε εἰς τὴν κιβωτὸν ἄρσεν καὶ θῆλυ, καθὰ ἐνετείλατο ὁ Θεὸς τῷ Νῶε. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Καὶ ἐγένετο μετὰ τὰς ἑπτὰ ἡμέρας, καὶ τὸ ὕδωρ τοῦ κατακλυσμοῦ ἐγένετο ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ἐν τῷ ἑξακοσιοστῷ ἔτει ἐν τῇ ζωῇ τοῦ Νῶε, τοῦ δευτέρου μηνὸς, ἑβδόμῃ καὶ εἰκάδι τοῦ μηνὸς, τῇ ἡμέρᾳ ταύτῃ ἐῤῥάγησαν πᾶσαι αἱ πηγαὶ τῆς ἀβύσσου, καὶ οἱ καταῤῥάκται τοῦ οὐρανοῦ ἠνεῴχθησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Καὶ ἐγένετο ὁ ὑετὸς ἐπὶ τῆς γῆς τεσσαράκοντα ἡμέρας καὶ τεσσαράκοντα νύκτας. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ἐν τῇ ἡμέρᾳ ταύτῃ εἰσῆλθε Νῶε, Σὴμ, Χὰμ, Ἰάφεθ, οἱ υἱοὶ Νῶε, καὶ ἡ γυνὴ Νῶε, καὶ αἱ τρεῖς γυναῖκες τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ, εἰς τὴν κιβωτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Καὶ πάντα τὰ θηρία κατὰ γένος, καὶ πάντα τὰ κτήνη κατὰ γένος, καὶ πᾶν ἑρπετὸν κινούμενον ἐπὶ τῆς γῆς κατὰ γένος, καὶ πᾶν ὄρνεον πετεινὸν κατὰ γένος αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","εἰσῆλθον πρὸς Νῶε εἰς τὴν κιβωτὸν, δύο δύο ἄρσεν καὶ θῆλυ ἀπὸ πάσης σαρκὸς, ἐν ᾧ ἐστι πνεῦμα ζωῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Καὶ τὰ εἰσπορευόμενα ἄρσεν καὶ θῆλυ ἀπὸ πάσης σαρκὸς εἰσῆλθε, καθὰ ἐνετείλατο ὁ Θεὸς τῷ Νῶε· καὶ ἔκλεισε Κύριος ὁ Θεὸς τὴν κιβωτὸν ἔξωθεν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Καὶ ἐγένετο ὁ κατακλυσμὸς τεσσαράκοντα ἡμέρας καὶ τεσσαράκοντα νύκτας ἐπὶ τῆς γῆς· καὶ ἐπεπληθύνθη τὸ ὕδωρ· καὶ ἐπῇρε τὴν κιβωτὸν, καὶ ὑψώθη ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Καὶ ἐπεκράτει τὸ ὕδωρ, καὶ ἐπληθύνετο σφόδρα ἐπὶ τῆς γῆς· καὶ ἐπεφέρετο ἡ κιβωτὸς ἐπάνω τοῦ ὕδατος. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Τὸ δὲ ὕδωρ ἐπεκράτει σφόδρα σφόδρα ἐπὶ τῆς γῆς· καὶ ἐκάλυψε πάντα τὰ ὄρη τὰ ὑψηλὰ, ἃ ἦν ὑποκάτω τοῦ οὐρανοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Πεντεκαίδεκα πήχεις ὑπεράνω ὑψώθη τὸ ὕδωρ· καὶ ἐπεκάλυψε πάντα τὰ ὄρη τὰ ὑψηλά. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Καὶ ἀπέθανε πᾶσα σὰρξ κινουμένη ἐπὶ τῆς γῆς τῶν πετεινῶν, καὶ τῶν κτηνῶν, καὶ τῶν θηρίων· καὶ πᾶν ἑρπετὸν κινούμενον ἐπὶ τῆς γῆς, καὶ πᾶς ἄνθρωπος. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Καὶ πάντα ὅσα ἔχει πνοὴν ζωῆς, καὶ πᾶν ὃ ἦν ἐπὶ τῆς ξηρᾶς, ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Καὶ ἐξήλειψε πᾶν τὸ ἀνάστημα, ὃ ἦν ἐπὶ προσώπου τῆς γῆς, ἀπὸ ἀνθρώπου ἕως κτήνους, καὶ ἑρπετῶν, καὶ τῶν πετεινῶν τοῦ οὐρανοῦ· καὶ ἐξηλείφησαν ἀπὸ τῆς γῆς· καὶ κατελείφθη μόνος Νῶε, καὶ οἱ μετʼ αὐτοῦ ἐν τῇ κιβωτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Καὶ ὑψώθη τὸ ὕδωρ ἐπὶ τῆς γῆς ἡμέρας ἑκατὸν πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Καὶ ἀνεμνήσθη ὁ Θεὸς τοῦ Νῶε, καὶ πάντων τῶν θηρίων, καὶ πάντων τῶν κτηνῶν, καὶ πάντων τῶν πετεινῶν, καὶ πάντων τῶν ἑρπετῶν τῶν ἑρπόντων, ὅσα ἦν μετʼ αὐτοῦ ἐν τῇ κιβωτῷ· καὶ ἐπήγαγεν ὁ Θεὸς πνεῦμα ἐπὶ τὴν γῆν, καὶ ἐκόπασε τὸ ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Καὶ ἐπεκαλύφθησαν αἱ πηγαὶ τῆς ἀβύσσου, καὶ οἱ καταῤῥάκται τοῦ οὐρανοῦ, καὶ συνεσχέθη ὁ ὑετὸς ἀπὸ τοῦ οὐρανοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Καὶ ἐνεδίδου τὸ ὕδωρ πορευόμενον ἀπὸ τῆς γῆς· καὶ ἠλαττονοῦτο τὸ ὕδωρ μετὰ πεντήκοντα καὶ ἑκατὸν ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Καὶ ἐκάθισεν ἡ κιβωτὸς ἐν μηνὶ τῷ ἑβδόμῳ, ἑβδόμῃ καὶ εἰκάδι τοῦ μηνὸς, ἐπὶ τὰ ὄρη τὰ Ἀραράτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Τὸ δὲ ὕδωρ ἠλαττονοῦτο ἕως τοῦ δεκάτου μηνός. Καὶ ἐν τῷ δεκάτῳ μηνὶ, τῇ πρώτῃ τοῦ μηνὸς, ὤφθησαν αἱ κεφαλαὶ τῶν ὀρέων. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Καὶ ἐγένετο μετὰ τεσσαράκοντα ἡμέρας ἠνέῳξε Νῶε τὴν θυρίδα τῆς κιβωτοῦ, ἣν ἐποίησε. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Καὶ ἀπέστειλε τὸν κόρακα· καὶ ἐξελθὼν, οὐκ ἀνέστρεψεν ἕως τοῦ ξηρανθῆναι τὸ ὕδωρ ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Καὶ ἀπέστειλε τὴν περιστερὰν ὀπίσω αὐτοῦ, ἰδεῖν εἰ κεκόπακε τὸ ὕδωρ ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Καὶ οὐχ εὑροῦσα ἡ περιστερὰ ἀνάπαυσιν τοῖς ποσὶν αὐτῆς, ἀνέστρεψε πρὸς αὐτὸν εἰς τὴν κιβωτὸν, ὅτι ὕδωρ ἦν ἐπὶ πᾶν τὸ πρόσωπον τῆς γῆς· καὶ ἐκτείνας τὴν χεῖρα ἔλαβεν αὐτὴν, καὶ εἰσήγαγεν αὐτὴν πρὸς ἑαυτὸν εἰς τὴν κιβωτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Καὶ ἐπισχὼν ἔτι ἡμέρας ἑπτὰ ἑτέρας, πάλιν ἐξαπέστειλε τὴν περιστερὰν ἐκ τῆς κιβωτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Καὶ ἀνέστρεψε πρὸς αὐτὸν ἡ περιστερὰ τὸ πρὸς ἑσπέραν· καὶ εἶχε φύλλον ἐλαίας κάρφος ἐν τῷ στόματι αὐτῆς· καὶ ἔγνω Νῶε, ὅτι κεκόπακε τὸ ὕδωρ ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Καὶ ἐπισχὼν ἔτι ἡμέρας ἑπτὰ ἑτέρας, πάλιν ἐξαπέστειλε τὴν περιστερὰν, καὶ οὐ προσέθετο τοῦ ἐπιστρέψαι πρὸς αὐτὸν ἔτι. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Καὶ ἐγένετο ἐν τῷ ἑνὶ καὶ ἑξακοσιοστῷ ἔτει ἐν τῇ ζωῇ τοῦ Νῶε, τοῦ πρώτου μηνὸς, μιᾷ τοῦ μηνὸς, ἐξέλιπε τὸ ὕδωρ ἀπὸ τῆς γῆς. Καὶ ἀπεκάλυψε Νῶε τὴν στέγην τῆς κιβωτοῦ, ἣν ἐποίησε· καὶ εἶδεν ὅτι ἐξέλιπε τὸ ὕδωρ ἀπὸ προσώπου τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ἐν δὲ τῷ δευτέρῳ μηνὶ ἐξηράνθη ἡ γῆ, ἑβδόμῃ καὶ εἰκάδι τοῦ μηνός. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Καὶ εἶπε Κύριος ὁ Θεὸς πρὸς Νῶε, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ἔξελθε ἐκ τῆς κιβωτοῦ σὺ, καὶ ἡ γυνή σου, καὶ οἱ υἱοί σου, καὶ αἱ γυναῖκες τῶν υἱῶν σου μετὰ σοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Καὶ πάντα τὰ θηρία ὅσα ἐστὶ μετὰ σοῦ, καὶ πᾶσα σὰρξ ἀπὸ πετεινῶν ἕως κτηνῶν, καὶ πᾶν ἑρπετὸν κινούμενον ἐπὶ τῆς γῆς, ἐξάγαγε μετὰ σεαυτοῦ. καὶ αὐξάνεσθε καὶ πληθύνεσθε ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Καὶ ἐξῆλθε Νῶε, καὶ ἡ γυνὴ αὐτοῦ, καὶ οἱ υἱοὶ αὐτοῦ, καὶ αἱ γυναῖκες τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Καὶ πάντα τὰ θηρία, καὶ πάντα τὰ κτήνη, καὶ πᾶν πετεινὸν, καὶ πᾶν ἑρπετὸν κινούμενον ἐπὶ τῆς γῆς κατὰ γένος αὐτῶν, ἐξήλθοσαν ἐκ τῆς κιβωτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Καὶ ᾠκοδόμησε Νῶε θυσιαστήριον τῷ Κυρίῳ· καὶ ἔλαβεν ἀπὸ πάντων τῶν κτηνῶν τῶν καθαρῶν, καὶ ἀπὸ πάντων τῶν πετεινῶν τῶν καθαρῶν, καὶ ἀνήνεγκεν εἰς ὁλοκάρπωσιν ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Καὶ ὠσφράνθη Κύριος ὁ Θεὸς ὀσμὴν εὐωδίας. Καὶ εἶπε Κύριος ὁ Θεὸς διανοηθείς, οὐ προσθήσω ἔτι καταράσασθαι τὴν γῆν διὰ τὰ ἔργα τῶν ἀνθρώπων· ὅτι ἔγκειται ἡ διάνοια τοῦ ἀνθρώπου ἐπιμελῶς ἐπὶ τὰ πονηρὰ ἐκ νεότητος αὐτοῦ· οὐ προσθήσω οὖν ἔτι πατάξαι πᾶσαν σάρκα ζῶσαν, καθὼς ἐποίησα. ");
INSERT INTO grcbrent_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Πάσας τὰς ἡμέρας τῆς γῆς, σπέρμα καὶ θερισμὸς, ψύχος καὶ καῦμα, θέρος καὶ ἔαρ, ἡμέραν καὶ νύκτα, οὐ καταπαύσουσι. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Καὶ εὐλόγησεν ὁ Θεὸς τὸν Νῶε, καὶ τοὺς υἱοὺς αὐτοῦ· καὶ εἶπεν αὐτοῖς· αὐξάνεσθε καὶ πληθύνεσθε, καὶ πληρώσατε τὴν γῆν, καὶ κατακυριεύσατε αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Καὶ ὁ τρόμος, καὶ ὁ φόβος ὑμῶν, ἔσται ἐπὶ πᾶσι τοῖς θηρίοις τῆς γῆς, ἐπὶ πάντα τὰ πετεινὰ τοῦ οὐρανοῦ, καὶ ἐπὶ πάντα τὰ κινούμενα ἐπὶ τῆς γῆς, καὶ ἐπὶ πάντας τοὺς ἰχθύας τῆς θαλάσσης· ὑπὸ χεῖρας ὑμῖν δέδωκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Καὶ πᾶν ἑρπετὸν, ὅ ἐστι ζῶν, ὑμῖν ἔσται εἰς βρῶσιν· ὡς λάχανα χόρτου δέδωκα ὑμῖν τὰ πάντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Πλὴν κρέας ἐν αἵματι ψυχῆς οὐ φάγεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Καὶ γὰρ τὸ ὑμέτερον αἷμα τῶν ψυχῶν ὑμῶν ἐκ χειρὸς πάντων τῶν θηρίων ἐκζητήσω αὐτό· καὶ ἐκ χειρὸς ἀνθρώπου ἀδελφοῦ ἐκζητήσω τὴν ψυχὴν τοῦ ἀνθρώπου. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ὁ ἐκχέων αἷμα ἀνθρώπου, ἀντὶ τοῦ αἵματος αὐτοῦ ἐκχυθήσεται, ὅτι ἐν εἰκόνι Θεοῦ ἐποίησα τὸν ἄνθρωπον. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ὑμεῖς δὲ αὐξάνεσθε, καὶ πληθύνεσθε, καὶ πληρώσατε τὴν γῆν, καὶ κατακυριεύσατε αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Καὶ εἶπεν ὁ Θεὸς τῷ Νῶε καὶ τοῖς υἱοῖς αὐτοῦ, μετʼ αὐτοῦ λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","καὶ ἰδοὺ ἐγὼ ἀνίστημι τὴν διαθήκην μου ὑμῖν, καὶ τῷ σπέρματι ὑμῶν μεθʼ ὑμᾶς, ");
INSERT INTO grcbrent_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","καὶ πάσῃ ψυχῇ ζώσῃ μεθʼ ὑμῶν, ἀπὸ ὀρνέων, καὶ ἀπὸ κτηνῶν· καὶ πᾶσι τοῖς θηρίοις τῆς γῆς, ὅσα ἐστὶ μεθʼ ὑμῶν ἀπὸ πάντων τῶν ἐξελθόντων ἐκ τῆς κιβωτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Καὶ στήσω τὴν διαθήκην μου πρὸς ὑμᾶς· καὶ οὐκ ἀποθανεῖται πᾶσα σὰρξ ἔτι ἀπὸ τοῦ ὕδατος τοῦ κατακλυσμοῦ· καὶ οὐκ ἔτι ἔσται κατακλυσμὸς ὕδατος, καταφθεῖραι πᾶσαν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Καὶ εἶπε Κύριος ὁ Θεὸς πρὸς Νῶε· τοῦτο τὸ σημεῖον τῆς διαθήκης, ὃ ἐγὼ δίδωμι ἀνὰ μέσον ἐμοῦ καὶ ὑμῶν, καὶ ἀνὰ μέσον πάσης ψυχῆς ζώσης, ἥ ἐστι μεθʼ ὑμῶν εἰς γενεὰς αἰωνίους. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Τὸ τόξον μου τίθημι ἐν τῇ νεφέλῃ, καὶ ἔσται εἰς σημεῖον διαθήκης ἀνὰ μέσον ἐμοῦ καὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Καὶ ἔσται ἐν τῷ συννεφεῖν με νεφέλας ἐπὶ τὴν γῆν, ὀφθήσεται τὸ τόξον ἐν τῇ νεφέλῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Καὶ μνησθήσομαι τῆς διαθήκης μου, ἥ ἐστιν ἀνὰ μέσον ἐμοῦ καὶ ὑμῶν, καὶ ἀνὰ μέσον πάσης ψυχῆς ζώσης ἐν πάσῃ σαρκί· καὶ οὐκ ἔσται ἔτι τὸ ὕδωρ εἰς κατακλυσμὸν, ὥστε ἐξαλεῖψαι πᾶσαν σάρκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Καὶ ἔσται τὸ τόξον μου ἐν τῇ νεφέλῃ· καὶ ὄψομαι τοῦ μνησθῆναι διαθήκην αἰώνιον ἀνὰ μέσον ἐμοῦ καὶ τῆς γῆς, καὶ ἀνὰ μέσον ψυχῆς ζώσης ἐν πάσῃ σαρκὶ, ἥ ἐστιν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Καὶ εἶπεν ὁ Θεὸς τῷ Νῶε, τοῦτο τὸ σημεῖον τῆς διαθήκης, ἧς διεθέμην ἀνὰ μέσον ἐμοῦ, καὶ ἀνὰ μέσον πάσης σαρκὸς, ἥ ἐστιν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ἦσαν δὲ οἱ υἱοὶ Νῶε, οἱ ἐξελθόντες ἐκ τῆς κιβωτοῦ, Σὴμ, Χὰμ, Ἰάφεθ. Χὰμ δὲ ἦν πατὴρ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Τρεῖς οὗτοί εἰσιν υἱοὶ Νῶε· ἀπὸ τούτων διεσπάρησαν ἐπὶ πᾶσαν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Καὶ ἤρξατο Νῶε ἄνθρωπος γεωργὸς γῆς, καὶ ἐφύτευσεν ἀμπελῶνα. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Καὶ ἔπιεν ἐκ τοῦ οἴνου, καὶ ἐμεθύσθη, καὶ ἐγυμνώθη ἐν τῷ οἴκῳ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Καὶ εἶδε Χὰμ ὁ πατὴρ Χαναὰν τὴν γύμνωσιν τοῦ πατρὸς αὐτοῦ, καὶ ἐξελθὼν ἀνήγγειλε τοῖς δυσὶν ἀδελφοῖς αὐτοῦ ἔξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Καὶ λαβόντες Σὴμ καὶ Ἰάφεθ τὸ ἱμάτιον, ἐπέθεντο ἐπὶ τὰ δύο νῶτα αὐτῶν, καὶ ἐπορεύθησαν ὀπισθοφανῶς, καὶ συνεκάλυψαν τὴν γύμνωσιν τοῦ πατρὸς αὐτῶν· καὶ τὸ πρόσωπον αὐτῶν ὀπισθοφανῶς, καὶ τὴν γύμνωσιν τοῦ πατρὸς αὐτῶν οὐκ εἶδον. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ἐξένηψε δὲ Νῶε ἀπὸ τοῦ οἴνου, καὶ ἔγνω ὅσα ἐποίησεν αὐτῷ ὁ υἱὸς αὐτοῦ ὁ νεώτερος. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Καὶ εἶπεν, ἐπικατάρατος Χαναὰν παῖς· οἰκέτης ἔσται τοῖς ἀδελφοῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Καὶ εἶπεν, εὐλογητὸς Κύριος ὁ Θεὸς τοῦ Σήμ· καὶ ἔσται Χαναὰν παῖς οἰκέτης αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Πλατύναι ὁ Θεὸς τῷ Ἰάφεθ, καὶ κατοικησάτω ἐν τοῖς οἴκοις τοῦ Σήμ· καὶ γενηθήτω Χαναὰν παῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ἔζησε δὲ Νῶε μετὰ τὸν κατακλυσμὸν ἔτη τριακόσια πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Νῶε ἐννακόσια πεντήκοντα ἔτη· καὶ ἀπέθανεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Αὗται δὲ αἱ γενέσεις τῶν υἱῶν Νῶε, Σὴμ, Χὰμ, Ἰάφεθ· καὶ ἐγεννήθησαν αὐτοῖς υἱοὶ μετὰ τὸν κατακλυσμόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Υἱοὶ Ἰάφεθ, Γαμὲρ, καὶ Μαγὼγ, καὶ Μαδοὶ, καὶ Ἰωύαν, καὶ Ἐλισὰ, καὶ Θοβὲλ, καὶ Μοσὸχ, καὶ Θείρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Καὶ υἱοὶ Γαμὲρ, Ἀσχανὰζ, καὶ Ῥιφὰθ, καὶ Θοργαμά. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Καὶ υἱοὶ Ἰωύαν, Ἐλισὰ, καὶ Θάρσεις, Κήτιοι, Ῥόδὶοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ἐκ τούτων ἀφωρίσθησαν νῆσοι τῶν ἐθνῶν ἐν τῇ γῇ αὐτῶν· ἕκαστος κατὰ γλῶσσαν ἐν ταῖς φυλαῖς αὐτῶν, καὶ ἐν τοῖς ἔθνεσιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Υἱοὶ δὲ Χὰμ, Χοὺς, καὶ Μεσραῒν, Φοὺδ, καὶ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Υἱοὶ δὲ Χοὺς, Σαβὰ, καὶ Εὐϊλὰ, καὶ Σαβαθὰ, καὶ Ῥεγμὰ, καὶ Σαβαθακά· υἱοὶ δὲ Ῥεγμὰ, Σαβὰ, καὶ Δαδάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Χοὺς δὲ ἐγέννησε τὸν Νεβρώδ· οὗτος ἤρξατο εἶναι γίγας ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Οὗτος ἦν γίγας κυνηγὸς ἐναντίον Κυρίου τοῦ Θεοῦ· διὰ τοῦτο ἐροῦσιν, ὡς Νεβρὼδ γίγας κυνηγὸς ἐναντίον Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Καὶ ἐγένετο ἀρχὴ τῆς βασιλείας αὐτοῦ Βαβυλὼν, καὶ Ὀρὲχ, καὶ Ἀρχὰδ, καὶ Χαλάννη, ἐν τῇ γῇ Σεναάρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ἐκ τῆς γῆς ἐκείνης ἐξῆλθεν Ἀσσούρ· καὶ ᾠκοδόμησε τὴν Νινευῒ, καὶ τὴν Ῥοωβὼθ πόλιν, καὶ τὴν Χαλὰχ, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","καὶ τὴν Δασὴ ἀνὰ μέσον Νινευῒ, καὶ ἀνὰ μέσον Χαλάχ· αὕτη ἡ πόλις μεγάλη. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Καὶ Μεσραῒν ἐγέννησε τοὺς Λουδιεὶμ, καὶ τοὺς Νεφθαλεὶμ, καὶ τοὺς Ἐνεμετιεὶμ, καὶ τοὺς Λαβιεὶμ, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","καὶ τοὺς Πατροσωνιεὶμ, καὶ τοὺς Χασμωνιεὶμ, ὅθεν ἐξῆλθε Φυλιστιεὶμ, καὶ τοὺς Γαφθοριείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Χαναὰν δὲ ἐγέννησε τὸν Σιδῶνα πρωτότοκον αὐτοῦ, καὶ τὸν Χετταῖον, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","καὶ τὸν Ἰεβουσαῖον, καὶ τὸν Ἀμοῤῥαῖον, καὶ τὸν Γεργεσαῖον, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","καὶ τὸν Εὐαῖον, καὶ τὸν Ἀρουκαῖον, καὶ τὸν Ἀσενναῖον, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","καὶ τον Ἀράδιον, καὶ τὸν Σαμαραῖον, καὶ τὸν Ἀμαθί. Καὶ μετὰ τοῦτο διεσπάρησαν αἱ φυλαὶ τῶν Χαναναίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Καὶ ἐγένετο τὰ ὅρια τῶν Χαναναίων ἀπὸ Σιδῶνος ἕως ἐλθεῖν εἰς Γεραρὰ καὶ Γαζὰν, ἕως ἐλθεῖν ἕως Σοδόμων καὶ Γομόῤῥας, Ἀδαμὰ καὶ Σεβωῒμ ἕως Δασά. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Οὗτοι υἱοὶ Χὰμ, ἐν ταῖς φυλαῖς αὐτῶν, κατὰ γλώσσας αὐτῶν, ἐν ταῖς χώραις αὐτῶν, καὶ ἐν τοῖς ἔθνεσιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Καὶ τῷ Σὴμ ἐγεννήθη καὶ αὐτῷ πατρὶ πάντων τῶν υἱῶν Ἕβερ, ἀδελφῷ Ἰάφεθ τοῦ μείζονος. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Υἱοὶ Σὴμ, Ἐλὰμ, καὶ Ἀσσοὺρ, καὶ Ἀρφαξὰδ, καὶ Λοὺδ, καὶ Ἀρὰμ, καὶ Καϊνᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Καὶ υἱοὶ Ἀρὰμ, Οὒζ, καὶ Οὒλ, καὶ Γατὲρ, καὶ Μοσόχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Καὶ Ἀρφαξὰδ ἐγέννησε τὸν Καϊνᾶν, καὶ Καϊνᾶν ἐγέννησε τὸν Σαλά· Σαλὰ δὲ ἐγέννησε τὸν Ἕβερ. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Καὶ τῷ Ἕβερ ἐγεννήθησαν δύο υἱοί· ὄνομα τῷ ἑνὶ, Φαλὲγ, ὅτι ἐν ταῖς ἡμέραις αὐτοῦ διεμερίσθη ἡ γῆ· καὶ ὄνομα τῷ ἀδελφῷ αὐτοῦ Ἰεκτάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ἰεκτὰν δὲ ἐγέννησε τὸν Ἐλμωδὰδ, καὶ Σαλὲθ, καὶ τὸν Σαρμὼθ, καὶ Ἰαρὰχ, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","καὶ Ὁδοῤῥὰ, καὶ Αἰβὴλ, καὶ Δεκλὰ, καὶ Εὐὰλ, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","καὶ Ἀβιμαὲλ, καὶ Σαβὰ, ");
INSERT INTO grcbrent_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","καὶ Οὐφεὶρ, καὶ Εὑεϊλὰ, καὶ Ἰωβάβ· πάντες οὗτοι υἱοὶ Ἰεκτάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Καὶ ἐγένετο ἡ κατοίκησις αὐτῶν, ἀπὸ Μασσῆ ἕως ἐλθεῖν εἰς Σαφηρὰ ὄρος ἀνατολῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Οὗτοι υἱοὶ Σὴμ, ἐν ταῖς φυλαῖς αὐτῶν, κατὰ γλώσσας αὐτῶν, ἐν ταῖς χώραις αὐτῶν, καὶ ἐν τοῖς ἔθνεσιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Αὗται αἱ φυλαὶ υἱῶν Νῶε κατὰ γενέσεις αὐτῶν, κατὰ ἔθνη αὐτῶν· ἀπὸ τούτων διεσπάρησαν νῆσοι τῶν ἐθνῶν ἐπὶ τῆς γῆς μετὰ τὸν κατακλυσμόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Καὶ ἦν πᾶσα ἡ γῆ χεῖλος ἓν, καὶ φωνὴ μία πᾶσι. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Καὶ ἐγένετο ἐν τῷ κινῆσαι αὐτοὺς ἀπὸ ἀνατολῶν, εὗρον πεδίον ἐν γῇ Σεναὰρ, καὶ κατῴκησαν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Καὶ εἶπεν ἄνθρωπος τῷ πλησίον αὐτοῦ, δεῦτε πλινθεύσωμεν πλίνθους, καὶ ὀπτήσωμεν αὐτὰς πυρί· καὶ ἐγένετο αὐτοῖς ἡ πλίνθος εἰς λίθον, καὶ ἄσφαλτος ἦν αὐτοῖς ὁ πηλός. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Καὶ εἶπαν, δεῦτε οἰκοδομήσωμεν ἑαυτοῖς πόλιν καὶ πύργον, οὗ ἔσται ἡ κεφαλὴ ἕως τοῦ οὐρανοῦ, καὶ ποιήσωμεν ἑαυτοῖς ὄνομα, πρὸ τοῦ διασπαρῆναι ἡμᾶς ἐπὶ προσώπου πάσης τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Καὶ κατέβη Κύριος ἰδεῖν τὴν πόλιν καὶ τὸν πύργον, ὃν ᾠκοδόμησαν οἱ υἱοὶ τῶν ἀνθρώπων. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Καὶ εἶπε Κύριος, ἰδοὺ γένος ἓν, καὶ χεῖλος ἓν πάντων, καὶ τοῦτο ἤρξαντο ποιῆσαι, καὶ νῦν οὐκ ἐκλείψει ἀπʼ αὐτῶν πάντα ὅσα ἂν ἐπιθῶνται ποιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Δεῦτε, καὶ καταβάντες συγχέωμεν αὐτῶν ἐκεῖ τὴν γλῶσσαν, ἵνα μὴ ἀκούσωσιν ἕκαστος τὴν φωνὴν τοῦ πλησίον. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Καὶ διέσπειρεν αὐτοὺς Κύριος ἐκεῖθεν ἐπὶ πρόσωπον πάσης τῆς γῆς· καὶ ἐπαύσαντο οἰκοδομοῦντες τῆν πόλιν καὶ τὸν πύργον. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Διὰ τοῦτο ἐκλήθη τὸ ὄνομα αὐτῆς, Σύγχυσις, ὅτι ἐκεῖ συνέχεε Κύριος τὰ χείλη πάσης τῆς γῆς, καὶ ἐκεῖθεν διέσπειρεν αὐτοὺς Κύριος ἐπὶ πρόσωπον πάσης τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Καὶ αὗται αἱ γενέσεις Σήμ· καὶ ἦν Σὴμ υἱὸς ἑκατὸν ἐτῶν, ὅτε ἐγέννησε τὸν Ἀρφαξὰδ, δευτέρου ἔτους μετὰ τὸν κατακλυσμόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Καὶ ἔζησε Σὴμ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ἀρφαξὰδ, ἔτη πεντακόσια, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Καὶ ἔζησεν Ἀρφαξὰδ ἑκατὸν τριακονταπέντε ἔτη, καὶ ἐγέννησε τὸν Καϊνᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Καὶ ἔζησεν Ἀρφαξὰδ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Καϊνᾶν, ἔτη τετρακόσια, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. Καὶ ἔζησε Καϊνᾶν ἑκατὸν καὶ τριάκοντα ἔτη, καὶ ἐγέννησε τὸν Σαλά· καὶ ἔξησε Καϊνᾶν, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Σαλὰ, ἔτη τριακόσια τριάκοντα, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Καὶ ἔζησε Σαλὰ ἑκατὸν τριάκοντα ἔτη, καὶ ἐγέννησε τὸν Ἕβερ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Καὶ ἔζησε Σαλὰ μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ἕβερ, τριακόσια τριάκοντα ἔτη, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας· καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Καὶ ἔζησεν Ἕβερ ἑκατὸν τριάκοντα τέσσαρα ἔτη, καὶ ἐγέννησε τὸν Φαλέγ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Καὶ ἔξησεν Ἕβερ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Φαλὲγ, ἔτη διακόσια ἑβδομήκοντα, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Καὶ ἔζησε Φαλὲγ τριάκοντα καὶ ἑκατὸν ἔτη, καὶ ἐγέννησε τὸν Ῥαγαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Καὶ ἔζησε Φαλὲγ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ῥαγαῦ, ἐννέα καὶ διακόσια ἔτη, καὶ ἐγέννησεν υἱοὺς και θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Καὶ ἔζησε Ῥαγαὺ ἑκατὸν τριάκοντα καὶ δύο ἔτη, καὶ ἐγέννησε τὸν Σερούχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Καὶ ἔζησε Ῥαγαῦ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Σεροὺχ, διακόσια ἑπτὰ ἔτη, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Καὶ ἔζησε Σεροὺχ ἑκατὸν τριάκοντα ἔτη, καὶ ἐγέννησε τὸν Ναχώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Καὶ ἔζησε Σεροὺχ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Ναχὼρ, ἔτη διακόσια, καὶ ἐγέννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Καὶ ἔζησε Ναχὼρ ἔτη ἑκατὸν ἑβδομηκονταεννέα, καὶ ἐγέννησε τὸν Θάῤῥα. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Καὶ ἔζησε Ναχὼρ, μετὰ τὸ γεννῆσαι αὐτὸν τὸν Θάῤῥα, ἔτη ἑκατὸν εἰκοσιπὲντε, καὶ ἐγεννησεν υἱοὺς καὶ θυγατέρας, καὶ ἀπέθανε. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Καὶ ἔζησε Θάῤῥα ἑβδομήκοντα ἔτη, καὶ ἐγέννησε τὸν Ἄβραμ, καὶ τὸν Ναχὼρ, καὶ τὸν Ἀῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Αὗται δὲ αἱ γενέσεις Θάῤῥα· Θάῤῥα ἐγέννησε τὸν Ἅβραμ, καὶ τὸν Ναχὼρ, καὶ τὸν Ἀῤῥάν· καὶ Ἀῤῥὰν ἐγέννησε τὸν Λώτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Καὶ ἀπέθανεν Ἀῤῥὰν ἐνώπιον Θάῤῥα τοῦ πατρὸς αὐτοῦ ἐν τῇ γῇ ᾗ ἐγενήθη, ἐν τῇ χώρᾳ τῶν Χαλδαίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Καὶ ἔλαβον Ἅβραμ καὶ Ναχὼρ ἑαυτοῖς γυναῖκας· ὄνομα τῇ γυναικὶ Ἅβραμ, Σάρα, καὶ ὄνομα τῇ γυναικὶ Ναχὼρ, Μελχά, θυγάτηρ Ἀῤῥάν· καὶ πατὴρ Μελχὰ, καὶ πατὴρ Ἰεσχά. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Καὶ ἦν Σάρα στεῖρα, καὶ οὐκ ἐτεκνοποίει. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Καὶ ἔλαβε Θάῤῥα τὸν Ἅβραμ υἱὸν αὐτοῦ, καὶ τὸν Λὼτ υἱὸν Ἀῤῥάν, υἱὸν τοῦ υἱοῦ αὐτοῦ, καὶ τὴν Σάραν τὴν νύμφην αὐτοῦ, γυναῖκα Ἅβραμ τοῦ υἱοῦ αὐτοῦ, καὶ ἐξήγαγεν αὐτοὺς ἐκ τῆς χώρας τῶν Χαλδαίων, πορευθῆναι εἰς γῆν Χαναάν· καὶ ἦλθον ἕως Χαῤῥὰν, καὶ κατῴκησεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Καὶ ἐγένοντο πᾶσαι αἱ ἡμέραι Θάῤῥα ἐν γῇ Χαῤῥὰν, διακόσια πέντε ἔτη· καὶ ἀπέθανε Θάῤῥα ἐν Χαῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Καὶ εἶπε Κύριος τῷ Ἅβραμ, ἔξελθε ἐκ τῆς γῆς σου, καὶ ἐκ τῆς συγγενείας σου, καὶ ἐκ τοῦ οἴκου τοῦ πατρός σου, καὶ δεῦρο εἰς τὴν γῆν, ἣν ἄν σοι δείξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Καὶ ποιήσω σε εἰς ἔθνος μέγα, καὶ εὐλογήσω σε, καὶ μεγαλυνῶ τὸ ὄνομά σου, καὶ ἔσῃ εὐλογημένος. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Καὶ εὐλογήσω τοὺς εὐλογοῦντάς σε, καὶ τοὺς καταρωμένους σε καταράσομαι, καὶ ἐνευλογηθήσονται ἐν σοὶ πᾶσαι αἱ φυλαὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Καὶ ἐπορεύθη Ἅβραμ, καθάπερ ἐλάλησεν αὐτῷ Κύριος, καὶ ᾤχετο μετʼ αὐτοῦ Λώτ· Ἅβραμ δὲ ἦν ἐτῶν ἑβδομηκονταπέντε, ὅτε ἐξῆλθεν ἐκ Χαῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Καὶ ἔλαβεν Ἅβραμ Σάραν τὴν γυναῖκα αὐτοῦ, καὶ τὸν Λὼτ υἱὸν τοῦ ἀδελφοῦ αὐτοῦ, καὶ πάντα τὰ ὑπάρχοντα αὐτῶν ὅσα ἐκτήσαντο, καὶ πᾶσαν ψυχὴν ἣν ἐκτήσαντο, ἐκ Χαῤῥάν, καὶ ἐξήλθοσαν πορευθῆναι εἰς γῆν Χανάαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Καὶ διώδευσεν Ἅβραμ τὴν γῆν εἰς τὸ μῆκος αὐτῆς ἕως τοῦ τόπου Συχέμ, ἐπὶ τὴν δρῦν τὴν ὑψηλήν· οἱ δὲ Χαναναῖοι τότε κατῴκουν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Καὶ ὤφθη Κύριος τῷ Ἅβραμ, καὶ εἶπεν αὐτῷ, τῷ σπέρματί σου δώσω τὴν γῆν ταύτην· καὶ ᾠκοδόμησεν ἐκεῖ Ἅβραμ θυσιαστήριον Κυρίῳ τῷ ὀφθέντι αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Καὶ ἀπέστη ἐκεῖθεν εἰς τὸ ὄρος κατὰ ἀνατολὰς Βαιθήλ· καὶ ἔστησεν ἐκεῖ τὴν σκηνὴν αὐτοῦ ἐν Βαιθὴλ κατὰ θάλασσαν, καὶ Ἀγγαὶ κατὰ ἀνατολάς· καὶ ᾠκοδόμησεν ἐκεῖ θυσιαστήριον τῷ Κυρίῳ, καὶ ἐπεκαλέσατο ἐπὶ τῷ ὀνόματι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Καὶ ἀπῇρεν Ἅβραμ, καὶ πορευθεὶς ἐστρατοπέδευσεν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Καὶ ἐγένετο λιμὸς ἐπὶ τῆς γῆς· καὶ κατέβη Ἅβραμ εἰς Αἴγυπτον παροικῆσαι ἐκεῖ, ὅτι ἐνίσχυσεν ὁ λιμὸς ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ἐγένετο δὲ ἡνίκα ἤγγισεν Ἅβραμ εἰσελθεῖν εἰς Αἴγυπτον, εἶπεν Ἅβραμ Σάρα τῇ γυναικὶ, γινώσκω ἐγὼ, ὅτι γυνὴ εὐπρόσωπος εἶ. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ἔσται οὖν ὡς ἂν ἴδωσί σε οἱ Αἰγύπτιοι, ἐροῦσιν ὅτι γυνὴ αὐτοῦ ἐστιν αὐτὴ, καὶ ἀποκτενοῦσί με, σὲ δὲ περιποιήσονται. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Εἶπον οὖν, ὅτι ἀδελφὴ αὐτοῦ εἰμι, ὅπως ἄν εὖ μοι γένηται διὰ σὲ, καὶ ζήσεται ἡ ψυχή μου ἕνεκέν σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ἐγένετο δὲ, ἡνίκα εἰσῆλθεν Ἅβραμ εἰς Αἴγυπτον, ἰδόντες οἱ Αἰγύπτιοι τὴν γυναῖκα αὐτοῦ, ὅτι καλὴ ἦν σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Καὶ ἴδον αὐτὴν οἱ ἄρχοντες Φαραὼ, καὶ ἐπῄνεσαν αὐτὴν πρὸς Φαραὼ, καὶ εἰσήγαγον αὐτὴν εἰς τὸν οἶκον Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Καὶ τῷ Ἅβραμ εὖ ἐχρήσαντο διʼ αὐτήν· καὶ ἐγένοντο αὐτῷ πρόβατα, καὶ μόσχοι, καὶ ὄνοι, καὶ παῖδες, καὶ παιδίσκαι, καὶ ἡμίονοι, καὶ κάμηλοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Καὶ ἤτασεν ὁ Θεὸς τὸν Φαραὼ ἐτασμοῖς μεγάλοις καὶ πονηροῖς, καὶ τὸν οἶκον αὐτοῦ, περὶ Σάρας τῆς γυναικὸς Ἅβραμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Καλέσας δὲ Φαραὼ τὸν Ἅβραμ, εἶπεν, τί τοῦτο ἐποίησάς μοι, ὅτι οὐκ ἀπήγγειλάς μοι, ὅτι γυνή σου ἐστίν; ");
INSERT INTO grcbrent_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ἱνατί εἶπας ὅτι ἀδελφή μου ἐστίν; καὶ ἔλαβον αὐτὴν ἐμαυτῷ γυναῖκα· καὶ νῦν ἰδοὺ ἡ γυνή σου ἔναντί σου, λαβὼν ἀπότρεχε. ");
INSERT INTO grcbrent_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Καὶ ἐνετείλατο Φαραὼ ἀνδράσι περὶ Ἅβραμ συμπροπέμψαι αὐτὸν, καὶ τὴν γυναῖκα αὐτοῦ, καὶ πάντα ὅσα ἦν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ἀνέβη δὲ Ἅβραμ ἐξ Αἰγύπτου αὐτὸς, καὶ ἡ γυνὴ αὐτοῦ, καὶ πάντα τὰ αὐτοῦ, καὶ Λὼτ μετʼ αὐτοῦ, εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ἅβραμ δὲ ἦν πλούσιος σφόδρα κτήνεσι, καὶ ἀργυρίῳ, καὶ χρυσίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Καὶ ἐπορεύθη ὅθεν ἦλθεν εἰς τὴν ἔρημον ἕως Βαιθὴλ, ἕως τοῦ τόπου οὗ ἦν ἡ σκηνὴ αὐτοῦ τὸ πρότερον, ἀνὰ μέσον Βαιθὴλ καὶ ἀνὰ μέσον Ἀγγαί, ");
INSERT INTO grcbrent_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","εἰς τὸν τόπον τοῦ θυσιαστηρίου, οὗ ἐποίησεν ἐκεῖ τὴν ἀρχὴν, καὶ ἐπεκαλέσατο ἐκεῖ Ἅβραμ τὸ ὄνομα τοῦ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Καὶ Λὼτ τῷ συμπορευομένῳ μετὰ Ἅβραμ ἦν πρόβατα, καὶ βόες, καὶ σκηναί. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Καὶ οὐκ ἐχώρει αὐτοὺς ἡ γῆ κατοικεῖν ἅμα, ὅτι ἦν τὰ ὑπάρχοντα αὐτῶν πολλά· καὶ οὐκ ἐχώρει αὐτοὺδ ἡ γῆ κατοικεῖν ἅμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Καὶ ἐγενετο μάχη ἀνὰ μέσον τῶν ποιμένων τῶν κτηνῶν τοῦ Ἅβραμ, καὶ ἀνὰ μέσον τῶν ποιμένων τῶν κτηνῶν τοῦ Λώτ· οἱ δὲ Χαναναῖοι καὶ οἱ Φερεζαῖοι τότε κατῴκουν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Εἶπε δὲ Ἅβραμ τῷ Λὼτ, μὴ ἔστω μάχη ἀνὰ μέσον ἐμοῦ καὶ σοῦ, καὶ ἀνὰ μέσον τῶν ποιμένων μου καὶ ἀνὰ μέσον τῶν ποιμένων σοῦ, ὅτι ἄνθρωποι ἀδελφοὶ ἐσμὲν ἡμεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Οὐκ ἰδοὺ πᾶσα ἡ γῆ ἐναντίον σου ἐστί; διαχωρίσθητι ἀπʼ ἐμοῦ· εἰ σὺ εἰς ἀριστερὰ, ἐγὼ εἰς δεξιά· εἰ δὲ σὺ εἰς δεξιὰ, ἐγὼ εἰς ἀριστερά. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Καὶ ἐπάρας Λὼτ τοὺς ὀφθαλμοὺς αὐτοῦ, ἐπεῖδε πᾶσαν τὴν περίχωρον τοῦ Ἰορδάνου, ὅτι πᾶσα ἦν ποτιζομένη, πρὸ τοῦ καταστρέψαι τὸν Θεὸν Σόδομα καὶ Γόμοῤῥα, ὡς ὁ παράδεισος τοῦ Θεοῦ, καὶ ὡς ἡ γῆ Αἰγύπτου, ἕως ἐλθεῖν εἰς Ζόγορα. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Καὶ ἐξελέξατο ἑαυτῷ Λὼτ πᾶσαν τὴν περίχωρον τοῦ Ἰορδάνου· καὶ ἀπῇρε Λὼτ ἀπὸ ἀνατολῶν· καὶ διεχωρίσθησαν ἕκαστος ἀπὸ τοῦ ἀδελφοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ἅβραμ δὲ κατῴκησεν ἐν γῇ Χαναάν· Λὼτ δὲ κατῴκησεν ἐν πόλει τῶν περιχώρων, καὶ ἐσκήνωσεν ἐν Σοδόμοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Οἱ δὲ ἄνθρωποι οἱ ἐν Σοδόμοις πονηροὶ καὶ ἁμαρτωλοὶ ἐναντίον τοῦ Θεοῦ σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ὁ δὲ Θεὸς εἶπε τῷ Ἅβραμ μετὰ τὸ διαχωρισθῆναι τὸν Λὼτ ἀπʼ αὐτοῦ, ἀνάβλεψον τοῖς ὀφθαλμοῖς σου, καὶ ἴδε ἀπὸ τοῦ τόπου οὗ νῦν σὺ εἶ πρὸς βοῤῥὰν καὶ λίβα καὶ ἀνατολὰς καὶ θάλασσαν· ");
INSERT INTO grcbrent_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ὅτι πᾶσαν τὴν γῆν, ἣν σὺ ὁρᾷς, σοὶ δώσω αὐτὴν καὶ τῷ σπέρματί σου ἕως αἰῶνος. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Καὶ ποιήσω τὸ σπέρμα σου, ὡς τὴν ἄμμον τῆς γῆς· εἰ δύναταί τις ἐξαριθμῆσαι τὴν ἄμμον τῆς γῆς, καὶ τὸ σπέρμα σου ἐξαριθμηθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ἀναστὰς διόδευσον τὴν γῆν εἴς τε τὸ μῆκος αὐτῆς καὶ εἰς τὸ πλάτος· ὅτι σοι δώσω αὐτὴν καὶ τῷ σπέρματί σου εἰς τὸν αἰῶνα. ");
INSERT INTO grcbrent_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Καὶ ἀποσκηνώσας Ἅβραμ, ἐλθὼν κατῴκησε παρὰ τὴν δρῦν τὴν Μαμβρῆ, ἣ ἦν ἐν Χεβρὼμ, καὶ ᾠκοδόμησεν ἐκεῖ θυσιαστήριον τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ἐγένετο δὲ ἐν τῇ βασιλείᾳ τῇ Ἀμαρφὰλ βασιλέως Σενναὰρ, καὶ Ἀριὼχ βασιλέως Ἑλλασὰρ, Χοδολλογομὸρ βασιλεὺς Ἐλὰμ, καὶ Θαργὰλ βασιλεὺς ἐθνῶν, ");
INSERT INTO grcbrent_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ἐποίησαν πόλεμον μετὰ Βαλλὰ βασιλέως Σοδόμων, καὶ μετὰ Βαρσὰ βασιλέως Γομόῤῥας, καὶ μετὰ Σενναὰρ βασιλέως Ἀδαμὰ, καὶ μετὰ Συμοβὸρ βασιλέως Σεβωεὶμ, καὶ βασιλέως Βαλάκ· αὕτη ἐστὶ Σηγώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Πάντες οὗτοι συνεφώνησαν ἐπὶ τὴν φάραγγα τὴν ἁλυκήν· αὕτη ἡ θάλασσα τῶν ἁλῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Δώδεκα ἔτη αὐτοὶ ἐδούλευσαν τῷ Χοδολλογομόρ· τῷ δὲ τρισκαιδεκάτῳ ἔτει ἀπέστησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ἐν δὲ τῷ τεσσαρεσκαιδεκάτῳ ἔτει ἦλθε Χοδολλογομὸρ καὶ οἱ βασιλεῖς μετʼ αὐτοῦ, καὶ κατέκοψαν τοὺς γίγαντας τοὺς ἐν Ἀσταρὼθ, καὶ Καρναῒν, καὶ ἔθνη ἰσχυρὰ ἅμα αὐτοῖς, καὶ τοὺς Ὀμμαίους τοὺς ἐν Σαυῇ τῇ πόλει. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Καὶ τοὺς Χοῤῥαίους τοὺς ἐν τοῖς ὄρεσι Σηεὶρ, ἕως τῆς τερεβίνθου τῆς Φαρὰν, ἥ ἐστιν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Καὶ ἀναστρέψαντες ἦλθον ἐπὶ τὴν πηγὴν τῆς κρίσεως· αὕτη ἐστὶ Κάδης· καὶ κατέκοψαν πάντας τοὺς ἄρχοντας Ἀμαλὴκ, καὶ τοὺς Ἀμοῤῥαίους τοὺς κατοικοῦντας ἐν ʼΑσασονθαμὰρ ");
INSERT INTO grcbrent_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ἐξῆλθε δὲ βασιλεὺς Σοδόμων, καὶ βασιλεὺς Γομόῤῥας, καὶ βασιλεὺς Ἀδαμὰ, καὶ βασιλεὺς Σεβωεὶμ, καὶ βασιλεὺς Βαλάκ· αὕτη ἐστὶ Σηγώρ· καὶ παρετάξαντο αὐτοῖς εἰς πόλεμον ἐν τῇ κοιλάδι, τῇ ἁλυκῇ, ");
INSERT INTO grcbrent_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","πρὸς Χοδολλογομὸρ βασιλέα Ἐλὰμ, καὶ Θαπγὰλ βασιλέα ἐθνῶν, καὶ Ἀμαρφὰλ βασιλέα Σενναὰρ, καὶ Ἀριὼχ βασιλέα Ἑλλασὰρ, οἱ τέσσαρες βασιλεῖς πρὸς τοὺς πέντε. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ἡ δὲ κοιλὰς ἡ ἁλυκὴ, φρέατα ἀσφάλτου· ἔφυγε δὲ βασιλεὺς Σοδόμων καὶ βασιλεὺς Γομόῤῥας, καὶ ἐνέπεσαν ἐκεῖ· οἱ δὲ καταλειφθέντες εἰς τὴν ὀρεινὴν ἔφυγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ἔλαβον δὲ τὴν ἵππον πᾶσαν τὴν Σοδόμων καὶ Γομόῤῥας, καὶ πάντα τὰ βρώματα αὐτῶν, καὶ ἀπῆλθον. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ἔλαβον δὲ καὶ τὸν Λὼτ τὸν υἱὸν τοῦ ἀδελφοῦ Ἅβραμ, καὶ τὴν ἀποσκευὴν αὐτοῦ, καὶ ἀπῴχοντο· ἦν γὰρ κατοικῶν ἐν Σοδόμοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Παραγενόμενος δὲ τῶν ἀνασωθέντων τις ἀπήγγειλεν Ἅβραμ τῷ περάτῃ· αὐτὸς δὲ κατῴκει παρὰ τῇ δρυῒ τῇ Μαμβρῇ Ἀμοῤῥαίου τοῦ ἀδελφοῦ Ἐσχὼλ, καὶ τοῦ ἀδελφοῦ Αὐνὰν, οἳ ἦσαν συνωμόται τοῦ Ἅβραμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ἀκούσας δὲ Ἅβραμ ὅτι ᾐχμαλώτευται Λὼτ ὁ ἀδελφοῦς αὐτοῦ, ἠρίθμησε τοὺς ἰδίους οἰκογενεῖς αὐτοῦ τριακοσίους δέκα καὶ ὀκτώ· καὶ κατεδίωξεν ὀπίσω αὐτῶν ἕως Δάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Καὶ ἐπέπεσεν ἐπʼ αὐτοὺς τὴν νύκτα αὐτὸς, καὶ οἱ παῖδες αὐτοῦ, καὶ ἐπάταξεν αὐτοὺς, καὶ κατεδίωξεν αὐτοὺς ἕως Χοβὰ, ἥ ἐστιν ἐν ἀριστερᾷ Δαμασκοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Καὶ ἀπέστρεψε πᾶσαν τὴν ἵππον Σοδόμων· καὶ Λὼτ τὸν ἀδελφιδοῦν αὐτοῦ ἀπέστρεψε, καὶ πάντα τὰ ὑπάρχοντα αὐτοῦ, καὶ τὰς γυναῖκας, καὶ τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ἐξῆλθε δὲ βασιλεὺς Σοδόμων εἰς συνάντησιν αὐτῷ, μετὰ τὸ ὑποστρέψαι αὐτὸν ἀπὸ τῆς κοπῆς τοῦ Χοδολλογομὸρ, καὶ τῶν βασιλέων τῶν μετʼ αὐτοῦ εἰς τὴν κοιλάδα τοῦ Σαβύ· τοῦτο ἦν τὸ πεδίον τῶν βασιλέων. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Καὶ Μελχισεδὲκ βασιλεὺς Σαλὴμ ἐξήνεγκεν ἄρτους καὶ οἶνον· ἦν δὲ ἱερεὺς τοῦ Θεοῦ τοῦ ὑψίστου. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Καὶ εὐλόγησε τὸν Ἅβραμ, καὶ εἶπεν, εὐλογημένος Ἅβραμ τῷ Θεῷ τῷ ὑψίστῳ, ὃς ἔκτισε τὸν οὐρανὸν καὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Καὶ εὐλογητὸς ὁ Θεὸς ὁ ὕψιστος, ὃς παρέδωκε τοὺς ἐχθρούς σου ὑποχειρίους σοι· καὶ ἔδωκεν αὐτῷ Ἅβραμ δεκάτην ἀπὸ πάντων. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Εἶπε δὲ βασιλεὺς Σοδόμων πρὸς Ἅβραμ, δός μοι τοὺς ἄνδρας, τὴν δὲ ἵππον λάβε σεαυτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Εἶπε δὲ Ἅβραμ πρὸς τὸν βασιλέα Σοδόμων, ἐκτενῶ τὴν χεῖρά μου πρὸς Κύριον τὸν Θεὸν τὸν ὕψιστον, ὃς ἔκτισε τὸν οὐρανὸν καὶ τὴν γῆν, ");
INSERT INTO grcbrent_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","εἰ ἀπὸ σπαρτίου ἕως σφυρωτῆρος ὑποδήματος λήψομαι ἀπὸ πάντων τῶν σῶν, ἵνα μὴ εἴπῃς, ὅτι ἐγὼ ἐπλούτισα τὸν Ἅβραμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Πλὴν ὧν ἔφαγον οἱ νεανίσκοι, καὶ τῆς μερίδος τῶν ἀνδρῶν τῶν συμπορευθέντων μετʼ ἐμοῦ Ἐσχὼλ, Αὐνᾶν, Μαμβρῆ· οὗτοι λήψονται μερίδα. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Μετὰ δὲ τὰ ῥήματα ταῦτα ἐγενήθη ῥῆμα Κυρίου πρὸς Ἅβραμ ἐν ὁράματι, λέγων, μὴ φοβοῦ Ἅβραμ· ἐγὼ ὑπερασπίζω σου· ὁ μισθός σου πολὺς ἔσται σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Δέγει δὲ Ἅβραμ, Δέσποτα Κύριε, τί μοι δώσεις; ἐγὼ δὲ ἀπολύομαι ἄτεκνος· ὁ δὲ υἱὸς Μασὲκ τῆς οἰκογενοῦς μου, οὗτος Δαμασκὸς Ἐλιέζερ. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Καὶ εἶπεν Ἅβραμ, ἐπειδὴ ἐμοὶ οὐκ ἔδωκας σπέρμα, ὁ δὲ οἰκογενής μου κληρονομήσει με. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Καὶ εὐθὺς φωνὴ Κυρίου ἐγένετο πρὸς αὐτὸν, λέγουσα, οὐ κληρονομήσει σε οὗτος· ἀλλʼ ὃς ἐξελεύσεται ἐκ σοῦ, οὗτος κληρονομήσει σε. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ἐξήγαγε δὲ αὐτὸν ἔξω, καὶ εἶπεν αὐτῷ, ἀνάβλεψον δὴ εἰς τὸν οὐρανὸν, καὶ ἀρίθμησον τοὺς ἀστέρας, εἰ δυνήσῃ ἐξαριθμῆσαι αὐτούς· καὶ εἶπεν, οὕτως ἔσται τὸ σπέρμα σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Καὶ ἐπίστευσεν Ἅβραμ τῷ Θεῷ, καὶ ἐλογίσθη αὐτῷ εἰς δικαιοσύνην. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Εἶπε δὲ πρὸς αὐτὸν, ἐγὼ ὁ Θεὸς ὁ ἐξαγαγών σε ἐκ χώρας Χαλδαίων, ὥστε δοῦναί σοι τὴν γῆν ταύτην κληρονομῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Εἶπε δέ, Δέσποτα Κύριε, κατὰ τί γνώσομαι, ὅτι κληρονομήσω αὐτήν; ");
INSERT INTO grcbrent_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Εἶπε δὲ αὐτῷ, λάβε μοι δάμαλιν τριετίζουσαν, καὶ αἶγα τριετίζουσαν, καὶ κριὸν τριετίζοντα, καὶ τρυγόνα, καὶ περιστεράν. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ἔλαβε δὲ αὐτῷ πάντα ταῦτα, καὶ διεῖλεν αὐτὰ μέσα, καὶ ἔθηκεν αὐτὰ ἀντιπρόσωπα ἀλλήλοις· τὰ δὲ ὄρνεα οὐ διεῖλε. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Κατέβη δὲ ὄρνεα ἐπὶ τὰ σώματα, ἐπὶ τὰ διχοτομήματα αὐτῶν· καὶ συνεκάθισεν αὐτοῖς Ἅβραμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Περὶ δὲ ἡλίου δυσμὰς ἔκστασις ἐπέπεσε τῷ Ἅβραμ, καὶ ἰδοὺ φόβος σκοτεινὸς μέγας ἐπιπίπτει αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Καὶ ἐῤῥέθη πρὸς Ἅβραμ· γινώσκων γνώσῃ ὅτι πάροικον ἔσται τὸ σπέρμα σου ἐν γῇ οὐκ ἰδίᾳ, καὶ δουλώσουσιν αὐτοὺς, καὶ κακώσουσιν αὐτοὺς, καὶ ταπεινώσουσιν αὐτοὺς, τετρακόσια ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Τὸ δὲ ἔθνος, ᾧ ἐὰν δουλεύσωσι, κρινῶ ἐγώ· μετὰ δὲ ταῦτα, ἐξελεύσονται ὧδε μετὰ ἀποσκευῆς πολλῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Σὺ δὲ ἀπελεύσῃ πρὸς τοὺς πατέρας σου ἐν εἰρήνῃ, τραφεὶς ἐν γήρᾳ καλῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Τετάρτῃ δὲ γενεᾷ ἀποστραφήσονται ὧδε· οὔπω γὰρ ἀναπεπλήρωνται αἱ ἁμαρτίαι τῶν Ἀμοῤῥαίων ἕως τοῦ νῦν. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ἐπεὶ δὲ ὁ ἥλιος ἐγένετο πρὸς δυσμὰς, φλὸξ ἐγένετο· καὶ ἰδοὺ κλίβανος καπνιζόμενος καὶ λαμπάδες πυρός, αἳ διῆλθον ἀνὰ μέσον τῶν διχοτομημάτων τούτων. ");
INSERT INTO grcbrent_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ἐν τῇ ἡμέρᾳ ἐκείνῃ διέθετο Κύριος τῷ Ἅβραμ διαθήκην, λέγων, τῷ σπέρματί σου δώσω τὴν γῆν ταύτην, ἀπὸ τοῦ ποταμοῦ Αἰγύπτου ἕως τοῦ ποταμοῦ τοῦ μεγάλου Εὐφράτου· ");
INSERT INTO grcbrent_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Τοὺς Κεναίους, καὶ τοὺς Κενεζαίους, καὶ τοὺς Κεδμωναίους, ");
INSERT INTO grcbrent_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","καὶ τοὺς Χετταίους, καὶ τοὺς Φερεζαίους, καὶ τοὺς ʼΡαφαεὶν, ");
INSERT INTO grcbrent_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","καὶ τοὺς Ἀμοῤῥαίους, καὶ τοὺς Χαναναίους, καὶ τοὺς Εὐαίους, καὶ τοὺς Γεργεσαίους, καὶ τοὺς Ἰεβουσαίους. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Σάρα δὲ ἡ γυνὴ Ἅβραμ οὐκ ἔτικτεν αὐτῷ· ἦν δὲ αὐτῇ παιδίσκη Αἰγυπτία, ᾗ ὄνομα Ἄγαρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Εἶπε δὲ Σάρα πρὸς Ἅβραμ, ἰδοὺ συνέκλεισέ με Κύριος τοῦ μὴ τίκτειν· εἴσελθε οὖν πρὸς τὴν παιδίσκην μου, ἵνα τεκνοποιήσωμαι ἐξ αὐτῆς· ὑπήκουσελ δὲ Ἅβραμ τῆς φωνῆς Σάρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Καὶ λαβοῦσα Σάρα ἡ γυνὴ Ἅβραμ Ἄγαρ τὴν Αἰγυπτίαν τὴν ἑαυτῆς παιδίσκην, μετὰ δέκα ἔτη τοῦ οἰκῆσαι Ἅβραμ ἐν γῇ Χαναὰν, ἔδωκεν αὐτὴν τῷ Ἅβραμ ἀνδρὶ αὐτῆς αὐτῷ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Καὶ εἰσῆλθε πρὸς Ἄγαρ, καὶ συνέλαβε· καὶ εἶδεν ὅτι ἐν γαστρὶ ἔχει, καὶ ἠτιμάσθη ἡ κυρία ἐναντίον αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Εἶπε δὲ Σάρα πρὸς Ἅβραμ, ἀδικοῦμαι ἐκ σοῦ· ἐγὼ δέδωκα τὴν παιδίσκην μου εἰς τὸν κόλπον σου, ἰδοῦσα δὲ ὅτι ἐν γαστρὶ ἔχει, ἠτιμάσθην ἐναντίον αὐτῆς. κρίναι ὁ Θεὸς ἀνὰ μέσον ἐμοῦ καὶ σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Εἶπε δὲ Ἅβραμ πρὸς Σάραν, ἰδοὺ ἡ παιδίσκη σου ἐν ταῖς χερσί σου, χρῶ αὐτῇ ὡς ἄν σοι ἀρεστὸν ᾖ. καὶ ἐκάκωσεν αὐτὴν Σάρα, καὶ ἀπέδρα ἀπὸ προσώπου αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Εὗρε δὲ αὐτὴν ἄγγελος Κυρίου ἐπὶ τῆς πηγῆς τοῦ ὕδατος ἐν τῇ ἐρήμῳ, ἐπὶ τῆς πηγῆς ἐν τῇ ὁδῷ Σούρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Καὶ εἶπεν αὐτῇ ὁ ἄγγελος Κυρίου, Ἄγαρ παιδίσκη Σάρας, πόθεν ἔρχῃ; καὶ ποῦ πορεύῃ; καὶ εἶπεν· ἀπὸ προσώπου Σάρας τῆς κυρίας μου ἐγὼ ἀποδιδράσκω. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Εἶπε δὲ αὐτῇ ὁ ἄγγελος Κυρίου, ἀποστράφηθι πρὸς τὴν κυρίαν σου, καὶ ταπεινώθητι ὑπὸ τὰς χεῖρας αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Καὶ εἶπεν αὐτῇ ὁ ἄγγελος Κυρίου, πληθύνων πληθυνῶ τὸ σπέρμα σου, καὶ οὐκ ἀριθμηθήσεται ὑπὸ τοῦ πλήθους. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Καὶ εἶπεν αὐτῇ ὁ ἄγγελος Κυρίου, ἰδοὺ σὺ ἐν γαστρὶ ἔχεις, καὶ τέξῃ υἱὸν, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰσμαὴλ, ὅτι ἐπήκουσε Κύριος τῇ ταπεινώσει σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Οὗτος ἔσται ἄγροικος ἄνθρωπος· αἱ χεῖρες αὐτοῦ ἐπὶ πάντας, καὶ αἱ χεῖρες πάντων ἐπʼ αὐτόν· καὶ κατὰ πρόσωπον πάντων τῶν ἀδελφῶν αὐτοῦ κατοικήσει. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Καὶ ἐκάλεσε τὸ ὄνομα Κυρίου τοῦ λαλοῦντος πρὸς αὐτὴν, σὺ ὁ Θεὸς ὁ ἐτιδών με· ὅτι εἶπε, καὶ γὰρ ἐνώπιον εἶδον ὀφθέντα μοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ἕνεκεν τούτου ἐκάλεσε τὸ φρέαρ, φρέαρ οὗ ἐνώπιον εἶδον· ἰδοὺ ἀνὰ μέσον Κάδης καὶ ἀνὰ μέσον Βαράδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Καὶ ἔτεκεν Ἄγαρ τῷ Ἅβραμ υἱὸν, καὶ ἐκάλεσεν Ἅβραμ τὸ ὄνομα τοῦ υἱοῦ αὐτοῦ, ὃν ἔτεκεν αὐτῷ Ἄγαρ, Ἰσμαήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ἅβραμ δὲ ἦν ἐτῶν ὀγδοηκονταὲξ, ἡνίκα ἔτεκεν Ἄγαρ τῷ Ἅβραμ τὸν Ἰσμαήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ἐγένετο δὲ Ἅβραμ ἐτῶν ἐννενηκονταεννέα. Καὶ ὤφθη Κύριος τῷ Ἅβραμ, καὶ εἶπεν αὐτῷ, ἐγώ εἰμι ὁ Θεός σου· εὐαρέστει ἐνώπιον ἐμοῦ, καὶ γίνου ἄμεμπτος. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Καὶ θήσομαι τὴν διαθήκην μου ἀνὰ μέσον ἐμοῦ, καὶ ἀνὰ μέσον σου, καὶ πληθυνῶ σε σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Καὶ ἔπεσεν Ἅβραμ ἐπὶ πρόσωπον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Καὶ ἐλάλησεν αὐτῷ ὁ Θεὸς, λέγων, Καὶ ἐγὼ ἰδοὺ ἡ διαθήκη μου μετὰ σοῦ· καὶ ἔσῃ πατὴρ πλήθους ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Καὶ οὐ κληθήσεται ἔτι τὸ ὄνομά σου Ἅβραμ, ἀλλʼ ἔσται τὸ ὄνομά σου Ἁβραὰμ, ὅτι πατέρα πολλῶν ἐθνῶν τέθεικά σε. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Καὶ αὐξανῶ σε σφόδρα σφόδρα, καὶ θήσω σε εἰς ἔθνη· καὶ βασιλεῖς ἐκ σοῦ ἐξελεύσονται. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Καὶ στήσω τὴν διαθήκην μου ἀνὰ μέσον σου, καὶ ἀνὰ μέσον τοῦ σπέρματός σου μετὰ σὲ εἰς τὰς γενεὰς αὐτῶν, εἰς διαθήκην αἰώνιον εἶναί σου Θεὸς, καὶ τοῦ σπέρματός σου μετὰ σέ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Καὶ δώσω σοι καὶ τῷ σπέρματί σου μετὰ σὲ τὴν γῆν, ἣν παροικεῖς, πᾶσαν τὴν γῆν Χαναὰν, εἰς κατάσχεσιν αἰώνιον· καὶ ἔσομαι αὐτοῖς εἰς Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Καὶ εἶπεν ὁ Θεὸς πρὸς Ἁβραὰμ, σὺ δὲ τὴν. διαθήκην μου διατηρήσεις, σὺ καὶ τὸ σπέρμα σου μετὰ σὲ εἰς τὰς γενεὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Καὶ αὕτη ἡ διαθήκη, ἣν διατηρήσεις, ἀνὰ μέσον ἐμοῦ καὶ ὑμῶν, καὶ ἀνὰ μέσον τοῦ σπέρματός σου μετὰ σὲ εἰς τὰς γενεὰς αὐτῶν· περιτμηθήσεται ὑμῶν πᾶν ἀρσενικόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Καὶ περιτμηθήσεσθε τὴν σάρκα τῆς ἀκροβυστίας ὑμῶν, καὶ ἔσται εἰς σημεῖον διαθήκης ἀνὰ μέσον ἐμοῦ καὶ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Καὶ παιδίον ὀκτὼ ἡμερῶν περιτμηθήσεται ὑμῖν, πᾶν ἀρσενικὸν εἰς τὰς γενεὰς ὑμῶν· καὶ οἰκογενὴς καὶ ὁ ἀργυρώνητος ἀπὸ παντὸς υἱοῦ ἀλλοτρίου, ὃς οὐκ ἔστιν ἐκ τοῦ σπέρματός σου, ");
INSERT INTO grcbrent_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Περιτομῇ περιτμηθήσεται ὁ οἰκογενὴς τῆς οἰκίας σου, καὶ ὁ ἀργυρώνητος· καὶ ἔσται ἡ διαθήκη μου ἐπὶ τῆς σαρκὸς ὑμῶν εἰς διαθήκην αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Καὶ ἀπερίτμητος ἄρσην, ὃς οὐ περιτμηθήσεται τὴν σάρκα τῆς ἀκροβυστίας αὐτοῦ τῇ ἡμέρᾳ τῇ ὀγδόῃ, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ τοῦ γένους αὐτῆς, ὅτι τὴν διαθήκην μου διεσκέδασε. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Καὶ εἶπεν ὁ Θεὸς τῷ Ἁβραὰμ, Σάρα ἡ γυνή σου, οὐ κληθήσεται τὸ ὄνομα αὐτῆς Σάρα, Σάῤῥα ἔσται τὸ ὄνομα αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Εὐλογήσω δὲ αὐτὴν, καὶ δώσω σοι ἐξ αὐτῆς τέκνον, καὶ εὐλογήσω αὐτὸ, καὶ ἔσται εἰς ἔθνη, καὶ βασιλεῖς ἐθνῶν ἐξ αὐτοῦ ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Καὶ ἔπεσεν Ἁβραὰμ ἐπὶ πρόσωπον αὐτοῦ, καὶ ἐγέλασε· καὶ εἶπεν ἐν τῇ διανοίᾳ αὐτοῦ, λέγων, εἰ τῷ ἑκατονταετεῖ γενήσεται υἱός; καὶ εἰ ἡ Σάῤῥα ἐννενήκοντα ἐτῶν τέξεται; ");
INSERT INTO grcbrent_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Εἶπε δὲ Ἁβραὰμ πρὸς τὸν Θεόν· Ἰσμαὴλ οὗτος ζήτω ἐναντίον σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Εἶπε δὲ ὁ Θεὸς πρὸς Ἁβραὰμ, ναί· ἰδοὺ Σάῤῥα ἡ γυνή σου τέξεταί σοι υἱὸν, καὶ καλέσεις τὸ ὄνομα αὐτοῦ Ἰσαάκ· καὶ στήσω τὴν διαθήκην μου πρὸς αὐτὸν, εἰς διαθήκην αἰώνιον, εἶναι αὐτῷ Θεὸς καὶ τῷ σπέρματι αὐτοῦ μετʼ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Περὶ δὲ Ἰσμαὴλ ἰδοὺ ἐπήκουσά σου· καὶ ἰδοὺ εὐλόγηκα αὐτὸν, καὶ αὐξανῶ αὐτὸν, καὶ πληθυνῶ αὐτὸν σφόδρα δώδεκα ἔθνη γεννήσει, καὶ δώσω αὐτὸν εἰς ἔθνος μέγα. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Τὴν δὲ διαθήκην μου στήσω πρὸς Ἰσαὰκ, ὃν τέξεταί σοι Σάῤῥα εἰς τὸν καιρὸν τοῦτον, ἐν τῷ ἐνιαυτῷ τῷ ἑτέρῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Συνετέλεσε δὲ λαλῶν πρὸς αὐτὸν, καὶ ἀνέβη ὁ Θεὸς ἀπὸ Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Καὶ ἔλαβεν Ἁβραὰμ Ἰσμαὴλ τὸν υἱὸν ἑαυτοῦ, καὶ πάντας τοὺς οἰκογενεῖς αὐτοῦ, καὶ πάντας τοὺς ἀργυρωνήτους, καὶ πᾶν ἄρσεν τῶν ἀνδρῶν τῶν ἐν τῷ οἴκῳ Ἁβραὰμ, καὶ περιέτεμε τὰς ἀκροβυστίας αὐτῶν, ἐν τῷ καιρῷ τῆς ἡμέρας ἐκείνης, καθὰ ἐλάλησεν αὐτῷ ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ἁβραὰμ δὲ ἐννενηκονταεννέα ἦν ἐτῶν, ἡνίκα περιετέμετο τὴν σάρκα τῆς ἀκροβυστίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ἰσμαὴλ δὲ ὁ υἱὸς αὐτοῦ ἦν ἐτῶν δεκατριῶν, ἡνίκα περιετέμετο τὴν σάρκα τῆς ἀκροβυστίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ἐν δὲ τῷ καιρῷ τῆς ἡμέρας ἐκείνης, περιετμήθη Ἁβραὰμ, καὶ Ἰσμαὴλ ὁ υἱὸς αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","καὶ πάντες οἱ ἄνδρες τοῦ οἴκου αὐτοῦ, καὶ οἱ οἰκογενεῖς αὐτοῦ, καὶ οἱ ἀργυρώνητοι ἐξ ἀλλογενῶν ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ὤφθη δὲ αὐτῷ ὁ Θεὸς πρὸς τῇ δρυῒ τῇ Μαμβρῇ, καθημένου αὐτοῦ ἐπὶ τῆς θύρας τῆς σκηνῆς αὐτοῦ μεσημβρίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ἀναβλέψας δὲ τοῖς ὀφθαλμοῖς αὐτοῦ εἶδε, καὶ ἰδοὺ τρεῖς ἄνδρες εἱστήκεισαν ἐπάνω αὐτοῦ· καὶ ἰδὼν, προσέδραμεν εἰς συνάντησιν αὐτοῖς ἀπὸ τῆς θύρας τῆς σκηνῆς αὐτοῦ, καὶ προσεκύνησεν ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Καὶ εἶπε, Κύριε, εἰ ἄρα εὗρον χάριν ἐναντίον σου, μὴ παρέλθῃς τὸν παῖδά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ληφθήτω δὴ ὕδωρ, καὶ νιψάτωσαν τοὺς πόδας ὑμῶν, καὶ καταψύξατε ὑπὸ τὸ δένδρον. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Καὶ λήψομαι ἄρτον, καὶ φάγεσθε. Καὶ μετὰ τοῦτο παρελεύσεσθε εἰς τὴν ὁδὸν ὑμῶν, οὗ ἕνεκεν ἐξεκλίνατε πρὸς τὸν παῖδα ὑμῶν. Καὶ εἶπεν, οὕτω ποίησον, καθὼς εἴρηκας. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Καὶ ἔσπευσεν Ἁβραὰμ ἐπὶ τὴν σκηνὴν πρὸς Σάῤῥαν, καὶ εἶπεν αὐτῇ, σπεῦσον, καὶ φύρασον τρία μέτρα σεμιδάλεως, καὶ ποίησον ἐγκρυφίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Καὶ εἰς τὰς βόας ἔδραμεν Ἁβραὰμ, καὶ ἔλαβεν ἁπαλὸν μοσχάριον καὶ καλὸν, καὶ ἔδωκε τῷ παιδὶ, καὶ ἐτάχυνε τοῦ ποιῆσαι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ἔλαβε δὲ βούτυρον, καὶ γάλα, καὶ τὸ μοσχάριον ὃ ἐποίησε, καὶ παρέθηκεν αὐτοῖς, καὶ ἔφαγον· αὐτὸς δὲ παρειστήκει αὐτοῖς ὑπὸ τὸ δένδρον. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Εἶπε δὲ πρὸς αὐτὸν, ποῦ Σάῤῥα ἡ γυνή σου; ὁ δὲ ἀποκριθεὶς εἶπεν, ἰδοὺ ἐν τῇ σκηνῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Εἶπε δὲ, ἐπαναστρέφων ἥξω πρὸς σὲ κατὰ τὸν καιρὸν τοῦτον εἰς ὥρας, καὶ ἕξει υἱὸν Σάῤῥα ἡ γυνή σου. Σάῤῥα δὲ ἤκουσε πρὸς τῇ θύρᾳ τῆς σκηνῆς οὖσα ὄπισθεν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ἁβραὰμ δὲ καὶ Σάῤῥα πρεσβύτεροι προβεβηκότες ἡμερῶν· ἐξέλιπε δὲ τῇ Σάῤῥᾳ γίνεσθαι τὰ γυναικεια. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ἐγέλασε δὲ Σάῤῥα ἐν ἑαυτῇ λέγουσα, οὔπω μέν μοι γέγονεν ἕως τοῦ νῦν· ὁ δὲ κύριός μου πρεσβύτερος. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Καὶ εἶπε Κύριος πρὸς Ἁβραὰμ, τί ὅτι ἐγέλασε Σάῤῥα ἐν ἑαυτῇ, λέγουσα, ἆρά γε ἀληθῶς τέξομαι; ἐγὼ δὲ γεγήρακα. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Μὴ ἀδυνατήσει παρὰ τῷ Θεῷ ῥῆμα; εἰς τὸν καιρὸν τοῦτον ἀναστρέψω πρὸς σὲ εἰς ὥρας, καὶ ἔσται τῇ Σάῤῥᾳ υἱός. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ἠρνήσατο δὲ Σάῤῥα, λέγουσα, οὐκ ἐγέλασα· ἐφοβήθη γάρ. Καὶ εἶπεν αὐτῇ, οὐχὶ, ἀλλὰ ἐγέλασας. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ἐξαναστάντες δὲ ἐκεῖθεν οἱ ἄνδρες κατέβλεψαν ἐπὶ πρόσωπον Σοδόμων καὶ Γομόῤῥας. Ἁβραὰμ δὲ συνεπορεύετο μετʼ αὐτῶν, συμπροπέμπων αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ὁ δὲ Κύριος εἶπε, οὐ μὴ κρύψω ἐγὼ ἀπὸ Ἁβραὰμ τοῦ παιδός μου ἃ ἐγὼ ποιῶ. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ἁβραὰμ δὲ γινόμενος ἔσται εἰς ἔθνος μέγα καὶ πολὺ, καὶ ἐνευλογηθήσονται ἐν αὐτῷ πάντα τὰ ἔθνη τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ἤδειν γὰρ ὅτι συντάξει τοῖς υἱοῖς αὐτοῦ, καὶ τῷ οἴκῳ αὐτοῦ μετʼ αὐτὸν, καὶ φυλάξουσι τὰς ὁδοὺς Κυρίου, ποιεῖν δικαιοσύνην καὶ κρίσιν, ὅπως ἂν ἐπαγάγῃ Κύριος ἐπὶ Ἁβραὰμ πάντα ὅσα ἐλάλησε πρὸς αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Εἶπε δὲ Κύριος, κραυγὴ Σοδόμων καὶ Γομόῤῥας πεπλήθυνται πρὸς μὲ, καὶ αἱ ἁμαρτίαι αὐτῶν μεγάλαι σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Καταβὰς οὖν ὄψομαι, εἰ κατὰ τὴν κραυγὴν αὐτῶν τὴν ἐρχομενεην πρὸς μὲ, συντελοῦνται· εἰ δὲ μὴ, ἵνα γνῶ. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Καὶ ἀποστρέψαντες ἐκεῖθεν οἱ ἄνδρες, ἦλθον εἰς Σόδομα· Ἁβραὰμ δὲ ἔτι ἦν ἑστηκὼς ἐναντίον Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Καὶ ἐγγίσας Ἁβραὰμ, εἶπε, μὴ συναπολέσῃς δίκαιον μετὰ ἀσεβοῦς· καὶ ἔσται ὁ δίκαιος ὡς ὁ ἀσεβής. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ἐὰν ὦσι πεντήκοντα δίκαιοι ἐν τῇ πόλει, ἀπολεῖς αὐτούς; οὐκ ἀνήσεις πάντα τὸν τόπον ἕνεκεν τῶν πεντήκοντα δικαίων, ἐὰν ὦσιν ἐν αὐτῇ; ");
INSERT INTO grcbrent_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Μηδαμῶς σὺ ποιήσεις ὡς τὸ ῥῆμα τοῦτο, τοῦ ἀποκτεῖναι δίκαιον μετὰ ἀσεβοῦς, καὶ ἔσται ὁ δίκαιος ὡς ὁ ἀσεβής· μηδαμῶς· ὁ κρίνων πᾶσαν τὴν γῆν, οὐ ποιήσεις κρίσιν; ");
INSERT INTO grcbrent_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Εἶπε δὲ Κύριος, ἐὰν ὦσιν ἐν Σοδόμοις πεντήκοντα δίκαιοι ἐν τῇ πόλει, ἀφήσω ὅλην τὴν πόλιν, καὶ πάντα τὸν τόπον διʼ αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Καὶ ἀποκριθεὶς Ἁβραὰμ εἶπε, νῦν ἠρξάμην λαλῆσαι πρὸς τὸν Κύριόν μου· ἐγὼ δὲ εἰμὶ γῆ καὶ σποδός. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ἐὰν δὲ ἐλαττονωθῶσιν οἱ πεντήκοντα δίκαιοι εἰς τεσσαρακονταπέντε, ἀπολεῖς ἕνεκεν τῶν πέντε πᾶσαν τὴν πόλιν; καὶ εἶπεν, οὐ μὴ ἀπολέσω, ἐὰν εὕρω ἐκεῖ τεσσαρακονταπέντε. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Καὶ προσέθηκεν ἔτι λαλῆσαι πρὸς αὐτὸν, καὶ εἶπεν, ἐὰν δὲ εὑρεθῶσιν ἐκεῖ τεσσαράκοντα· καὶ εἶπεν, οὐ μὴ ἀπολέσω ἕνεκεν τῶν τεσσαράκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Καὶ εἶπε, μή τι Κύριε ἐὰν λαλήσω; ἐὰν δὲ εὑρεθῶσιν ἐκεῖ τριάκοντα; καὶ εἶπεν, οὐ μὴ ἀπολέσω ἕνεκεν τῶν τριάκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Καὶ εἶπεν, ἐπειδὴ ἔχω λαλῆσαι πρὸς τὸν Κύριον, ἐὰν δὲ εὑρεθῶσιν ἐκεῖ εἴκοσι; καὶ εἶπεν, οὐ μὴ ἀπολέσω, ἐὰν εὕρω ἐκεῖ εἴκοσι. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Καὶ εἶπε, μή τι Κύριε ἐὰν λαλήσω ἔτι ἅπαξ; ἐὰν δὲ εὑρεθῶσιν ἐκεῖ δέκα; καὶ εἶπεν, οὐ μὴ ἀπολέσω ἕνεκεν τῶν δέκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ἀπῆλθε δὲ ὁ Κύριος, ὡς ἐπαύσατο λαλῶν τῷ Ἁβραάμ· καὶ Ἁβραὰμ ἀπέστρεψεν εἰς τὸν τόπον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ἦλθον δε οἱ δύο ἄγγελοι εἰς Σόδομα ἑσπέρας. Λὼτ δὲ ἐκάθητο παρὰ τὴν πύλην Σοδόμων· ἰδὸν δὲ Λὼτ, ἐξανέστη εἰς συνάντησιν αὐτοῖς, καὶ προσεκύνησε τῷ προσώπῳ ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Καὶ εἶπεν, ἰδοὺ, Κύριοι, ἐκκλίνατε εἰς τὸν οἶκον τοῦ παιδὸς ὑμῶν, καὶ καταλύσατε, καὶ νίψασθε τοὺς πόδας ὑμῶν, καὶ ὀρθρίσαντες ἀπελεύσεσθε εἰς τὴν ὁδὸν ὑμῶν. Καὶ εἶπαν, οὐχὶ, ἀλλʼ ἐν τῇ πλατείᾳ καταλύσομεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Καὶ κατεβιάσατο αὐτοὺς, καὶ ἐξέκλιναν πρὸς αὐτὸν, καὶ εἰσῆλθον εἰς τὸν οἶκον αὐτοῦ· καὶ ἐποίησεν αὐτοῖς πότον, καὶ ἀζύμους ἔπεψεν αὐτοῖς, καὶ ἔφαγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Πρὸ τοῦ κοιμηθῆναι δὲ, οἱ ἄνδρες τῆς πόλεως, οἱ Σοδομῖται περιεκύκλωσαν τὴν οἰκίαν, ἀπὸ νεανίσκου ἕως πρεσβυτέρου, ἅπας ὁ λαὸς ἅμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Καὶ ἐξεκαλοῦντο τὸν Λὼτ, καὶ ἔλεγον πρὸς αὐτὸν, ποῦ εἰσιν οἱ ἄνδρες οἱ εἰσελθόντες πρὸς σὲ τὴν νύκτα; ἐξάγαγε αὐτοὺς πρὸς ἡμᾶς, ἵνα συγγενώμεθα αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ἐξῆλθε δὲ Λὼτ πρὸς αὐτοὺς πρὸς τὸ πρόθυρον, τὴν δὲ θύραν προσέῳξεν ὀπίσω αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Εἶπε δὲ πρὸς αὐτοὺς, μηδαμῶς ἀδελφοὶ μὴ πονηρεύσησθε. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Εἰσὶ δέ μοι δύο θυγατέρες, αἳ οὐκ ἔγνωσαν ἄνδρα· ἐξάξω αὐτὰς πρὸς ὑμᾶς, καὶ χρᾶσθε αὐταῖς καθὰ ἂν ἀρέσκοι ὑμῖν· μόνον εἰς τοὺς ἄνδρας τούτους μὴ ποιήσητε ἄδικον, οὗ εἵνεκεν εἰσῆλθον ὑπὸ τὴν σκέπην τῶν δοκῶν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Εἶπαν δὲ αὐτῷ, ἀπόστα ἐκεῖ· εἰσῆλθες παροικεῖν, μὴ καὶ κρίσιν κρίνειν; νῦν οὖν σε κακώσωμεν μᾶλλον ἢ ἐκείνους. Καὶ παρεβιάζοντο τὸν ἄνδρα τὸν Λὼτ σφόδρα, καὶ ἤγγισαν συντρίψαι τὴν θύραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ἐκτείναντες δὲ οἱ ἄνδρες τὰς χεῖρας εἰσεσπάσαντο τὸν Λὼτ πρὸς ἑαυτοὺς εἰς τὸν οἶκον, καὶ τὴν θύραν τοῦ οἴκου ἀπέκλεισαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Τοὺς δὲ ἄνδρας τοὺς ὄντας ἐπὶ τῆς θύρας τοῦ οἴκου ἐπάταξαν ἐν ἀορασίᾳ ἀπὸ μικροῦ ἕως μεγάλου· καὶ παρελύθησαν ζητοῦντες τὴν θύραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Εἶπαν δὲ οἱ ἄνδρες πρὸς τὸν Λὼτ, εἰσί σοι ὧδε γαμβροὶ, ἢ υἱοὶ, ἢ θυγατέρες; ἢ εἴτις σοι ἄλλος ἐστὶν ἐν τῇ πόλει, ἐξάγαγε ἐκ τοῦ τόπου τούτου, ");
INSERT INTO grcbrent_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ὅτι ἡμεῖς ἀπόλλυμεν τὸν τόπον τοῦτον· ὅτι ὑψώθη ἡ κραυγὴ αὐτῶν ἔναντι Κυρίου, καὶ ἀπέστειλεν ἡμᾶς Κύριος ἐκτρίψαι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ἐξῆλθε δὲ Λῶτ, καὶ ἐλάλησε πρὸς τοὺς γαμβροὺς αὐτοῦ τοὺς εἰληφότας τὰς θυγατέρας αὐτοῦ, καὶ εἶπεν, ἀνάστητε, καὶ ἐξέλθετε ἐκ τοῦ τόπου τούτου, ὅτι ἐκτρίβει Κύριος τὴν πόλιν· ἔδοξε δὲ γελοιάζειν ἐναντίον τῶν γαμβρῶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ἡνίκα δὲ ὄρθρος ἐγένετο, ἐσπούδαζον οἱ ἄγγελοι τὸν Λὼτ, λέγοντες, ἀναστὰς λάβε τὴν γυναῖκά σου, καὶ τὰς δύο θυγατέρας σου, ἃς ἔχεις, καὶ ἔξελθε, ἵνα μὴ καὶ σὺ συναπόλῃ ταῖς ἀνομίαις τῆς πόλεως. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Καὶ ἐταράχθησαν, καὶ ἐκράτησαν οἱ ἄγγελοι τῆς χειρὸς αὐτοῦ, καὶ τῆς χειρὸς τῆς γυναικὸς αὐτοῦ, καὶ τῶν χειρῶν τῶν δύο θυγατέρων αὐτοῦ, ἐν τῷ φείσασθαι Κύριον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Καὶ ἐγένετο ἡνίκα ἐξήγαγον αὐτοὺς ἔξω, καὶ εἶπαν, σώζων σῶζε τὴν σεαυτοῦ ψυχήν· μὴ περιβλέψῃ εἰς τὰ ὀπίσω, μηδὲ στῇς ἐν πάσῃ τῇ περιχώρῳ· εἰς τὸ ὄρος σώζου, μή ποτε συμπαραληφθῇς. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Εἶπε δὲ Λὼτ πρὸς αὐτοὺς, δέομαι ");
INSERT INTO grcbrent_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Κύριε, ἐπειδὴ εὗρεν ὁ παῖς σου ἔλεος ἐναντίον σου, καὶ ἐμεγάλυνας τὴν δικαιοσύνην σου, ὃ ποιεῖς ἐπʼ ἐμὲ, τοῦ ζῆν τὴν ψυχήν μου· ἐγὼ δὲ οὐ δυνήσομαι διασωθῆναι εἰς τὸ ὄρος, μή ποτε καταλάβῃ με τὰ κακὰ, καὶ ἀποθάνω. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ἰδοὺ πόλις αὕτη ἐγγὺς τοῦ καταφυγεῖν με ἐκεῖ, ἥ ἐστι μικρά· καὶ ἐκεῖ διασωθήσομαι· οὐ μικρά ἐστι; καὶ ζήσεται ἡ ψυχή μου ἕνεκέν σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Καὶ εἶπεν αὐτῷ, ἰδοὺ ἐθαύμασά σου τὸ πρόσωπον καὶ ἐπὶ τῷ ῥήματι τούτῳ, τοῦ μὴ καταστρέψαι τὴν πόλιν περὶ ἧς ἐλάλησας. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Σπεῦσον οὖν τοῦ σωθῆναι ἐκεῖ, οὐ γὰρ δυνήσομαι ποιῆσαι πρᾶγμα, ἕως τοῦ ἐλθεῖν σε ἐκεῖ. διὰ τοῦτο ἐκάλεσε τὸ ὄνομα τῆς πόλεως ἐκείνης, Σηγώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ὁ ἥλιος ἐξῆλθεν ἐπὶ τὴν γῆν, καὶ Λὼτ εἰσῆλθεν εἰς Σηγώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Καὶ Κύριος ἔβρεξεν ἐπὶ Σόδομα καὶ Γόμοῤῥα θεῖον καὶ πῦρ παρὰ Κυρίου ἐξ οὐρανοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Καὶ κατέστρεψε τὰς πόλεις ταύτας, καὶ πᾶσαν τὴν περίχωρον, καὶ πάντας τοὺς κατοικοῦντας ἐν ταῖς πόλεσι, καὶ τὰ ἀνατέλλοντα ἐκ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Καὶ ἐπέβλεψεν ἡ γυνὴ αὐτοῦ εἰς τὰ ὀπίσω, καὶ ἐγένετο στήλη ἁλός. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ὤρθρισε δὲ Ἁβραὰμ τῷ πρωῒ εἰς τὸν τόπον, οὗ εἱστήκει ἐναντίον Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Καὶ ἐπέβλεψεν ἐπὶ πρόσωπον Σοδόμων καὶ Γομόῤῥας, καὶ ἐπὶ πρόσωπον τῆς περιχώρου, καὶ εἶδε, καὶ ἰδοὺ ἀνέβαινεν φλὸξ ἐκ τῆς γῆς, ὡσεὶ ἀτμὶς καμίνου. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Καὶ ἐγένετο ἐν τῷ ἐκτρίψαι τὸν Θεὸν πάσας τὰς πόλεις τῆς περιοίκου, ἐμνήσθη ὁ Θεὸς τοῦ Ἁβραάμ· καὶ ἐξαπέστειλε τὸν Λὼτ ἐκ μέσου τῆς καταστροφῆς, ἐν τῷ καταστρέψαι Κύριον τὰς πόλεις, ἐν αἷς κατῴκει ἐν αὐταῖς Λώτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ἀνέβη δὲ Λὼτ ἐκ Σηγὼρ, καὶ ἐκάθητο ἐν τῷ ὄρει αὐτὸς, καὶ αἱ δύο θυγατέρες αὐτοῦ μετʼ αὐτοῦ· ἐφοβήθη γὰρ κατοικῆσαι ἐν Σηγώρ· καὶ κατῴκησεν ἐν τῷ σπηλαίῳ αὐτὸς, καὶ αἱ δύο θυγατέρες αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Εἶπε δὲ ἡ πρεσβυτέρα πρὸς τὴν νεωτέραν, ὁ πατὴρ ἡμῶν πρεσβύτερος, καὶ οὐδείς ἐστιν ἐπὶ τῆς γῆς, ὃς εἰσελεύσεται πρὸς ἡμᾶς, ὡς καθήκει πάσῃ τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Δεῦρο καὶ ποτίσωμεν τὸν πατέρα ἡμῶν οἶνον, καὶ κοιμηθῶμεν μετʼ αὐτοῦ, καὶ ἐξαναστήσωμεν ἐκ τοῦ πατρὸς ἡμῶν σπέρμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ἐπότισαν δὲ τὸν πατέρα αὐτῶν οἶνον ἐν τῇ νυκτὶ ἐκείνῃ, καὶ εἰσελθοῦσα ἡ πρεσβυτέρα ἐκοιμήθη μετὰ τοῦ πατρὸς αὐτῆς ἐν τῇ νυκτὶ ἐκείνῃ· καὶ οὐκ ᾔδει ἐν τῷ κοιμηθῆναι αὐτὸν, καὶ ἐν τῷ ἀναστῆναι. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ἐγένετο δὲ ἐν τῇ ἐπαύριον, καὶ εἶπεν ἡ πρεσβυτέρα πρὸς τὴν νεωτέραν, ἰδοὺ ἐκοιμήθην χθὲς μετὰ τοῦ πατρὸς ἡμῶν· ποτίσωμεν αὐτὸν οἶνον καὶ ἐν τῇ νυκτὶ ταύτῃ, καὶ εἰσελθοῦσα κοιμήθητι μετʼ αὐτοῦ, καὶ ἐξαναστήσωμεν ἐκ τοῦ πατρὸς ἡμῶν σπέρμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ἐπότισαν δὲ καὶ ἐν τῇ νυκτὶ ἐκείνῃ τὸν πατέρα αὐτῶν οἶνον, καὶ εἰσελθοῦσα ἡ νεωτέρα ἐκοιμήθη μετὰ τοῦ πατρὸς αὐτῆς· καὶ οὐκ ᾔδει ἐν τῷ κοιμηθῆναι αὐτὸν, καὶ ἀναστῆναι. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Καὶ συνέλαβον αἱ δύο θυγατέρες Λὼτ ἐκ τοῦ πατρὸς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Καὶ ἔτεκεν ἡ πρεσβυτέρα υἱὸν, καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ Μωὰβ, λέγουσα, ἐκ τοῦ πατρός μου· οὗτος πατὴρ Μωαβιτῶν ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ἔτεκε δὲ καὶ ἡ νεωτέρα υἱὸν, καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ Ἀμμὰν, λέγουσα, υἱὸς γένους μου· οὗτος πατὴρ Ἀμμανιτῶν ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Καὶ ἐκίνησεν ἐκεῖθεν Ἁβραὰμ εἰς γῆν πρὸς Λίβα· καὶ ᾤκησεν ἀνὰ μέσον Κάδης, καὶ ἀνὰ μέσον Σούρ· καὶ παρῴκησεν ἐν Γεράροις. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Εἶπε δὲ Ἁβραὰμ περὶ Σάῤῥας τῆς γυναικὸς αὐτοῦ, ὅτι ἀδελφή μου ἐστίν· ἐφοβήθη γὰρ εἰπεῖν ὅτι γυνή μου ἐστὶ, μή ποτε ἀποκτείνωσιν αὐτὸν οἱ ἄνδρες τῆς πόλεως διʼ αὐτήν· ἀπέστειλε δὲ Ἀβιμέλεχ βασιλεὺς Γεράρων, καὶ ἔλαβε τὴν Σάῤῥαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Καὶ εἰσῆλθεν ὁ Θεὸς πρὸς Ἀβιμέλεχ ἐν ὕπνῳ τὴν νύκτα, καὶ εἶπεν, ἰδοὺ σὺ ἀποθνήσκεις περὶ τῆς γυναικὸς, ἧς ἔλαβες· αὕτη δέ ἐστι συνῳκηκυῖα ἀνδρί. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ἀβιμέλεχ δὲ οὐχ ἥψατο αὐτῆς· καὶ εἶπε, Κύριε, ἔθνος ἀγνοοῦν καὶ δίκαιον ἀπολεῖς; ");
INSERT INTO grcbrent_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Οὐκ αὐτός μοι εἶπεν, ἀδφή μου ἐστί; καὶ αὕτη μοι εἶπεν, ἀδελφός μου ἐστίν; ἐν καθαρᾷ καρδίᾳ καὶ ἐν δικαιοσύνῃ χειρῶν ἐποίησα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Εἶπε δὲ αὐτῷ ὁ Θεὸς καθʼ ὕπνον, κᾀγὼ ἔγνων ὅτι ἐν καθαρᾷ καρδίᾳ ἐποίησας τοῦτο, καὶ ἐφεισάμην σου τοῦ μὴ ἁμαρτεῖν σε εἰς ἐμέ· ἕνεκα τούτου οὐκ ἀφῆκά σε ἅψασθαι αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Νῦν δὲ ἀπόδος τὴν γυναῖκα τῷ ἀνθρώπῳ, ὅτι προφήτης ἐστὶ, καὶ προσεύξεται περὶ σοῦ, καὶ ζήσῃ· εἰ δὲ μὴ ἀποδίδως, γνώσῃ ὅτι ἀποθανῇ σὺ καὶ πάντα τὰ σὰ. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Καὶ ὤρθρισεν Ἀβιμέλεχ τῷ πρωῒ, καὶ ἐκάλεσε πάντας τοὺς παῖδας αὐτοῦ, καὶ ἐλάλησε πάντα τὰ ῥήματα ταῦτα εἰς τὰ ὦτα αὐτῶν· ἐφοβήθησαν δὲ πάντες οἱ ἄνθρωποι σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Καὶ ἐκάλεσεν Ἀβιμέλεχ τὸν Ἁβραὰμ καὶ εἶπεν αὐτῷ, τί τοῦτο ἐποίησας ἡμῖν; μήτι ἡμάρτομεν εἰς σὲ, ὅτι ἐπήγαγες ἐπʼ ἐμὲ καὶ ἐπὶ τὴν βασιλείαν μου ἁμαρτίαν μεγάλην; ἔργον ὃ οὐδεὶς ποιήσει, πεποίηκάς μοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Εἶπε δὲ Ἀβιμέλεχ τῷ Ἁβραὰμ, τί ἐνιδὼν ἐποίησας τοῦτο; ");
INSERT INTO grcbrent_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Εἶπε δὲ Ἁβραὰμ, εἶπα γὰρ, ἄρα οὐκ ἔστι θεοσέβεια ἐν τῷ τόπῳ τούτῳ, ἐμέ τε ἀποκτενοῦσιν ἕνεκεν τῆς γυναικός μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Καὶ γὰρ ἀληθῶς, ἀδελφή μου ἐστὶν ἐκ πατρὸς, ἀλλʼ οὐκ ἐκ μητρός· ἐγενήθη δέ μοι εἰς γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ἐγένετο δὲ ἡνίκα ἐξήγαγέ με ὁ Θεὸς ἐκ τοῦ οἴκου τοῦ πατρός μου, καὶ εἶπα αὐτῇ, ταύτην τὴν δικαιοσύνην ποιήσεις εἰς ἐμὲ, εἰς πάντα τόπον οὗ ἐὰν εἰσέλθωμεν ἐκεῖ, εἶπον ἐμὲ, ὅτι ἀδελφός μου ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ἔλαβε δὲ Ἀβιμέλεχ χίλια δίδραγμα, καὶ πρόβατα, καὶ μόσχους, καὶ παῖδας, καὶ παιδίσκας, καὶ ἔδωκε τῷ Ἁβραάμ· καὶ ἀπέδωκεν αὐτῷ Σάῤῥαν τὴν γυναῖκα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Καὶ εἶπεν Ἀβιμέλεχ τῷ Ἁβραὰμ, ἰδοὺ ἡ γῆ μου ἐναντίον σου· οὗ ἄν σοι ἀρέσκῃ, κατοίκει. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Τῇ δὲ Σάῤῥᾳ εἶπεν, ἰδοὺ δέδωκα χίλια δίδραγμα τῷ ἀδελφῷ σου· ταῦτα ἔσται σοι εἰς τιμὴν τοῦ προσώπου σου, καὶ πάσαις ταῖς μετὰ σοῦ· καὶ πάντα ἀλήθευσον. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Προσηύξατο δὲ Ἁβραὰμ πρὸς τὸν Θεὸν, καὶ ἰάσατο ὁ Θεὸς τὸν Ἀβιμέλεχ, καὶ τὴν γυναῖκα αὐτοῦ, καὶ τὰς παιδίσκας αὐτοῦ· καὶ ἔτεκον. ");
INSERT INTO grcbrent_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ὅτι συγκλείων συνέκλεισε Κύριος ἔξωθεν πᾶσαν μήτραν ἐν τῷ οἴκῳ Ἀβιμέλεχ, ἕνεκεν Σάῤῥας τῆς γυναικὸς Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Καὶ Κύριος ἐπεσκέψατο τὴν Σάῤῥαν, καθὰ εἶπε· καὶ ἐποίησε Κύριος τῇ Σάῥῥᾳ, καθὰ ἐλάλησε. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Καὶ συλλαβοῦσα ἔτεκε τῷ Ἁβραὰμ υἱὸν εἰς τὸ γῆρας, εἰς τὸν καιρὸν καθὰ ἐλάλησεν αὐτῷ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Καὶ ἐκάλεσεν Ἁβραὰμ τὸ ὄνομα τοῦ υἱοῦ αὐτοῦ τοῦ γενομένου αὐτῷ, ὃν ἔτεκεν αὐτῷ Σάῤῥα, Ἰσαάκ· ");
INSERT INTO grcbrent_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Περιέτεμε δὲ Ἁβραὰμ τὸν Ἰσαὰκ τῇ ἡμέρᾳ τῇ ὀγδόῃ, καθὰ ἐνετείλατο αὐτῷ ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Καὶ Ἁβραὰμ ἦν ἑκατὸν ἐτῶν, ηνίκα ἐγένετο αὐτῷ Ἰσαὰκ ὁ υἱὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Εἶπε δὲ Σάῤῥα, γέλωτά μοι ἐποίησε Κύριος· ὃς γὰρ ἂν ἀκούσῃ συγχαρεῖταί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Καὶ εἶπε τίς ἀναγγελεῖ τῷ Ἁβραὰμ ὅτι θηλάζει παιδίον Σάῤῥα; ὅτι ἔτεκον υἱὸν ἐν τῷ γήρᾳ μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Καὶ ηὐξήθη τὸ παιδίον, καὶ ἀπεγαλακτίσθη· καὶ ἐποίησεν Ἁβραὰμ δοχὴν μεγάλην, ᾗ ἡμέρᾳ ἀπεκγαλακτίσθη Ἰσαὰκ ὁ υἱὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ἰδοῦσα δὲ Σάῥῥα τὸν υἱὸν Ἄγαρ τῆς Αἰγυπτίας, ὃς ἐγένετο τῷ Ἁβραὰμ, παίζοντα μετὰ Ἰσαὰκ τοῦ υἱοῦ αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","καὶ εἶπε τῷ Ἁβραὰμ, ἔκβαλε τὴν παιδίσκην ταύτην, καὶ τὸν υἱὸν αὐτῆς· οὐ γὰρ μὴ κληρονομήσει ὁ υἱὸς τῆς παιδίσκης ταύτης μετὰ τοῦ υἱοῦ μου Ἰσαάκ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Σκληρὸν δὲ ἐφάνη τὸ ῥῆμα σφόδρα ἐνατίον Ἁβραὰμ περὶ τοῦ υἱοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Εἶπε δὲ ὁ Θεὸς τῷ Ἁβραὰμ, μὴ σκληρὸν ἔστω ἐναντίον σου περὶ τοῦ παιδίου, καὶ περὶ τῆς παιδίσκης· πάντα ὅσα ἂν εἴπῃ σοι Σάῤῥα, ἄκουε τῆς φωνῆς αὐτῆς· ὅτι ἐν Ἰσαὰκ κληθήσεταί σοι σπέρμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Καὶ τὸν υἱὸν δὲ τῆς παιδίσκης ταύτης εἰς ἔθνος μέγα ποιήσω αὐτὸν, ὅτι σπέρμα σόν ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ἀνέστη δὲ Ἁβραὰμ τὸ πρωῒ, καὶ ἔλαβεν ἄρτους καὶ ἀσκὸν ὕδατος, καὶ ἔδωκεν τῇ Ἄγαρ· καὶ ἐπέθηκεν ἐπὶ τὸν ὦμον αὐτῆς τὸ παιδίον, καὶ ἀπέστειλεν αὐτήν· Ἀπελθοῦσα δὲ ἐπλανᾶτο κατὰ τὴν ἔρημον, κατὰ τὸ φρέαρ τοῦ ὅρκου. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ἐξέλιπε δὲ τὸ ὕδωρ ἐκ τοῦ ἀσκου· καὶ ἔῤῥιψε τὸ παιδίον ὑποκάτω μιᾶς ἐλάτης· ");
INSERT INTO grcbrent_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ἀπελθοῦσα δὲ ἐκάθητο ἀπέναντι αὐτοῦ μακρόθεν, ὡσεὶ τόξου βολήν· εἶπε γὰρ, οὐ μὴ ἴδω τὸν θάνατον τοῦ παιδίου μου. καὶ ἐκάθισεν ἀπέναντι αὐτοῦ· ἀναβοῆσαν δὲ τὸ παιδίον ἔκλαυσεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Εἰσήκουσε δὲ ὁ Θεὸς τῆς φωνῆς τοῦ παιδίου ἐκ τοῦ τόπου οὗ ἦν· καὶ ἐκάλεσεν ἄγγελος Θεοῦ τὴν Ἄγαρ ἐκ τοῦ οὐρανοῦ, καὶ εἶπεν αὐτῇ, τί ἐστιν Ἄγαρ; μὴ φοβοῦ· ἐπακήκοε γὰρ ὁ Θεὸς τῆς φωνῆς τοῦ παιδίου ἐκ τοῦ τόπου οὗ ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ἀνάστηθι καὶ λάβε τὸ παιδίον, καὶ κράτησον τῇ χειρί σου αὐτό· εἰς γὰρ ἔθνος μέγα ποιήσω αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Καὶ ἀνέῳξεν ὁ Θεὸς τοὺς ὀφθαλμοὺς αὐτῆς· καὶ εἶδε φρέαρ ὕδατος ζῶντος, καὶ ἐπορεύθη, καὶ ἔπλησε τὸν ἀσκὸν ὕδατος, καὶ ἐπότισε τὸ παιδίον. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Καὶ ἦν ὁ Θεὸς μετὰ τοῦ παιδίου· καὶ ηὐξήθη, καὶ κατῴκησεν ἐν τῇ ἐρήμῳ· ἐγένετο δὲ τοξότης. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Καὶ κατῴκησεν ἐν τῇ ἐρήμῳ· καὶ ἔλαβεν αὐτῷ ἡ μήτηρ γυναῖκα ἐκ Φαρὰν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ἐγένετο δὲ ἐν τῷ καιρῷ ἐκείνῳ, καὶ εἶπεν Ἀβιμέλεχ, καὶ Ὁχοζὰθ ὁ νυμφαγωγὸς αὐτοῦ, καὶ Φιχὸλ ὁ ἀρχιστράτηγος τῆς δυνάμεως αὐτοῦ, πρὸς Ἁβραὰμ, λέγων, ὁ Θεὸς μετὰ σοῦ ἐν πᾶσιν, οἷς ἐὰν ποιῇς. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Νῦν οὖν ὄμοσόν μοι τὸν Θεὸν μὴ ἀδικήσειν με, μηδὲ τὸ σπέρμα μου, μηδὲ τὸ ὄνομά μου· ἀλλὰ κατὰ τὴν δικαιοσύνην ἣν ἐποίησα μετὰ σοῦ, ποιήσεις μετʼ ἐμοῦ, καὶ τῇ γᾗ, ᾗ σὺ παρῴκησας ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Καὶ εἶπεν Ἁβραὰμ, ἐγὼ ὀμοῦμαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Καὶ ἤλεγξεν Ἁβραὰμ τὸν Ἀβιμέλεχ περὶ τῶν φρεάτων τοῦ ὕδατος, ὧν ἀφείλοντο οἱ παῖδες τοῦ Ἀβιμέλεχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Καὶ εἶπεν αὐτῷ Ἀβιμέλεχ, οὐκ ἔγνων τίς ἐποίησέ σοι τὸ ῥῆμα τοῦτο· οὐδὲ σύ μοι ἀπήγγειλας, οὐδὲ ἐγὼ ἤκουσα, ἀλλʼ ἢ σήμερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Καὶ ἔλαβεν Ἁβραὰμ πρόβατα καὶ μόσχους, καὶ ἔδωκε τῷ Ἀβιμέλεχ· καὶ διέθεντο ἀμφότεροι διαθήκην. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Καὶ ἔστησεν Ἁβραὰμ, ἑπτὰ ἀμνάδας προβάτων μόνας. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Καὶ εἶπεν Ἀβιμέλεχ τῷ Ἁβραὰμ, τί εἰσιν αἱ ἑπτὰ ἀμνάδες τῶν προβάτων τούτων, ἃς ἔστησας μόνας; ");
INSERT INTO grcbrent_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Καὶ εἶπεν Ἁβραὰμ, ὅτι τὰς ἑπτὰ ἀμνάδας λήψῃ παρʼ ἐμοῦ, ἵνα ὦσι μοι εἰς μαρτύριον, ὅτι ἐγὼ ὤρυξα τό φρέαρ τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Διὰ τοῦτο ἐπωνόμασε τὸ ὄνομα τοῦ τόπου ἐκείνου, Φρέαρ ὁρκισμοῦ· ὅτι ἐκεῖ ὤμοσαν ἀμφότεροι. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Καὶ διέθεντο διαθήκην ἐν τῷ φρέατι τοῦ ὁρκισμου· ἀνέστη δὲ Ἀβιμέλεχ, Ὁχοζὰθ ὁ νυμφαγωγὸς αὐτοῦ, καὶ Φίχολ ὁ ἀρχιστράτηγος τῆς δυνάμεως αὐτοῦ, καὶ ἐπέστρεψαν εἰς τὴν γῆν τῶν Φυλιστιείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Καὶ ἐφύτευσεν Ἁβραὰμ ἄρουραν ἐπὶ τῷ φρέατι τοῦ ὅρκου· καὶ ἐπεκαλέσατο ἐκεῖ τὸ ὄνομα Κυρίου, Θεὸς αἰώνιος. ");
INSERT INTO grcbrent_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Παρῴκησε δὲ Ἁβραὰμ ἐν τῇ γῇ τῶν Φυλιστιεὶμ ἡμέρας πολλάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Καὶ ἐγένετο μετὰ τὰ ῥήματα ταῦτα ὁ Θεὸς ἐπείρασε τὸν Ἁβραὰμ, καὶ εἶπεν αὐτῷ, Ἁβραὰμ, Ἁβραάμ· καὶ εἶπεν, ἰδοὺ ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Καὶ εἶπε, λάβε τὸν υἱόν σου τὸν ἀγαπητὸν, ὃν ἠγάπησας, τὸν Ἰσαὰκ, καὶ πορεύθητι εἰς τὴν γῆν τὴν ὑψηλὴν, καὶ ἀνένεγκε αὐτὸν ἐκεῖ εἰς ὁλοκάρπωσιν ἐφʼ ἓν τῶν ὀρέων ὧν ἄν σοι εἴπω. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ἀναστὰς δὲ Ἁβραὰμ τὸ πρωῒ, ἐπέσαξε τὴν ὄνον αὐτοῦ· παρέλαβε δὲ μεθʼ ἑαυτοῦ δύο παῖδας, καὶ Ἰσαὰκ τὸν υἱὸν αὐτοῦ· καὶ σχίσας ξύλα εἰς ὁλοκάρπωσιν, ἀναστὰς ἐπορεύθη, καὶ ἦλθεν ἐπὶ τὸν τόπον, ὃν εἶπεν αὐτῷ ὁ Θεὸς, τῇ ἡμέρᾳ τῇ τρίτῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Καὶ ἀναβλέψας Ἁβραὰμ τοῖς ὀφθαλμοῖς αὐτοῦ, εἶδε τὸν τόπον μακρόθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Καὶ εἶπεν Ἁβραὰμ τοῖς παισὶν αὐτοῦ, καθίσατε αὐτοῦ μετὰ τῆς ὄνου· ἐγὼ δὲ καὶ τὸ παιδάριον διελευσόμεθα ἕως ὧδε· καὶ προσκυνήσαντες ἀναστρέψομεν πρὸς ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ἔλαβε δὲ Ἁβραὰμ τὰ ξύλα τῆς ὁλοκαρπώσεως, καὶ ἐπέθηκεν Ἰσαὰκ τῷ υἱῷ αὐτοῦ· ἔλαβε δὲ μετὰ χεῖρας καὶ τὸ πῦρ καὶ τὴν μάχαιραν, καὶ ἐπορεύθησαν οἱ δύο ἅμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Εἶπε δὲ Ἰσαὰκ πρὸς Ἁβραὰμ τὸν πατέρα αὐτοῦ, πάτερ· ὁ δὲ εἶπε, τί ἐστι, τέκνον; εἶπε, δὲ, ἰδοὺ τὸ πῦρ καὶ τὰ ξύλα, ποῦ ἐστὶ τὸ πρόβατον τὸ εἰς ὁλοκάρπωσιν; ");
INSERT INTO grcbrent_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Εἶπε δὲ Ἁβραὰμ, ὁ Θεὸς ὄψεται ἑαυτῷ πρόβατον εἰς ὁλοκάρπωσιν, τέκνον. πορευθέντες δὲ ἀμφότεροι ἅμα, ");
INSERT INTO grcbrent_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ἦλθον ἐπὶ τὸν τόπον, ὃν εἶπεν αὐτῷ ὁ Θεός· καὶ ᾠκοδόμησεν ἐκεῖ Ἁβραὰμ τὸ θυσιαστήριον, καὶ ἐπέθηκε τὰ ξύλα· καὶ συμποδίσας Ἰσαὰκ τὸν υἱὸν αὐτοῦ, ἐπέθηκεν αὐτὸν ἐπὶ τὸ θυσιαστήριον ἐπάνω τῶν ξύλων. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Καὶ ἐξέτεινεν Ἁβραὰμ τὴν χεῖρα αὐτοῦ λαβεῖν τὴν μάχαιραν, σφάξαι τὸν υἱὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Καὶ ἐκάλεσεν αὐτὸν Ἄγγελος Κυρίου ἐκ τοῦ οὐρανοῦ, καὶ εἶπεν, Ἁβραὰμ, Ἁβραάμ· ὁ δὲ εἶπεν, ἰδοὺ ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Καὶ εἶπε, μὴ ἐπιβάλῃς τὴν χεῖρά σου ἐπὶ τὸ παιδάριον, μηδὲ ποιήσῃς αὐτῷ μηδέν· νῦν γὰρ ἔγνων, ὅτι φοβῇ σὺ τὸν Θεόν· καὶ οὐκ ἐφείσω τοῦ υἱοῦ σου τοῦ ἀγαπητοῦ διʼ ἐμέ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Καὶ ἀναβλέψας Ἁβραὰμ τοῖς ὀφθαλμοῖς αὐτοῦ εἶδε, καὶ ἰδοὺ κριὸς εἷς κατεχόμενος ἐν φυτῷ Σαβὲκ τῶν κεράτων. Καὶ ἐπορεύθη Ἁβραὰμ, καὶ ἔλαβε τὸν κριὸν, καὶ ἁνήνεγκεν αὐτὸν εἰς ὁλοκάρπωσιν ἀντὶ Ἰσαὰκ τοῦ υἱοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Καὶ ἐκάλεσεν Ἁβραὰμ τὸ ὄνομα τοῦ τόπου ἐκείνου, Κύριος εἶδεν· ἵνα εἴπωσιν σήμερον, ἐν τῷ ὄρει Κύριος ὤφθη. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Καὶ ἐκάλεσεν Ἄγγελος Κυρίου τὸν Ἁβραὰμ δεύτερον ἐκ τοῦ οὐρανοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","λέγων, Κατʼ ἐμαυτοῦ ὤμοσα, λέγει Κύριος, οὗ εἵνεκεν ἐποίησας τὸ ῥῆμα τοῦτο, καὶ οὐκ ἐφείσω τοῦ υἱοῦ σου τοῦ ἀγαπτοῦ διʼ ἐμὲ, ");
INSERT INTO grcbrent_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ἦ μὴν εὐλογῶν εὐλογήσω σε, καὶ πληθύνων πληθυνῶ τὸ σπέρμα σου, ὡς τοὺς ἀστέρας τοῦ οὐρανοῦ, καὶ ὡς τὴν ἄμμον τὴν παρὰ τὸ χεῖλος τῆς θαλάσσης· καὶ κληρονομήσει τὸ σπέρμα σου τὰς πόλεις τῶν ὑπεναντίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Καὶ ἐνευλογηθήσονται ἐν τῷ σπέρματί σου πάντα τὰ ἔθνη τῆς γῆς, ἀνθʼ ὧν ὑπήκουσας τῆς ἐμῆς φωνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ἀπεστράφη δὲ Ἁβραὰμ πρὸς τοὺς παῖδας αὐτοῦ· καὶ ἀναστάντες ἐπορεύθησαν ἅμα ἐπὶ τὸ φρέαρ τοῦ ὅρκου. Καὶ κατῴκησεν Ἁβραὰμ ἐπὶ τὸ φρέαρ τοῦ ὅρκου. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ἐγένετο δὲ μετὰ τὰ ῥήματα ταῦτα, καὶ ἀνηγγέλη τῷ Ἁβραὰμ, λέγοντες, ἰδοὺ τέτοκε Μελχὰ καὶ αὐτὴ υἱοὺς τῷ Ναχὼρ τῷ ἀδελφῷ σου, ");
INSERT INTO grcbrent_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","τὸν Οὒζ πρωτότοκον, καὶ τὸν Βαὺξ ἀδελφὸν αὐτοῦ, καὶ τὸν Καμουὴλ πατέρα Σύρων, ");
INSERT INTO grcbrent_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","καὶ τὸν Χαζὰδ, καὶ Ἀζαῦ, καὶ τὸν Φαλδὲς, καὶ τὸν Ἰελδὰφ, καὶ τὸν Βαθουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Βαθουὴλ δὲ ἐγέννησε τὴν Ῥεβέκκαν. ὀκτὼ οὗτοι υἱοὶ, οὓς ἔτεκε Μελχὰ τῷ Ναχὼρ τῷ ἀδελφῷ Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Καὶ ἡ παλλακὴ αὐτοῦ, ᾗ ὄνομα Ῥεύμα, ἔτεκε καὶ αὐτὴ τὸν Ταβὲκ, καὶ τὸν Ταὰμ, καὶ τὸν Τοχός, καὶ τὸν Μοχά. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ἐγένετο δὲ ἡ ζωὴ Σάῤῥας, ἔτη ἑκατὸν εἰκοσιεπτά. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Καὶ ἀπέθανε Σάῤῥα ἐν πόλει Ἀρβὸκ, ἥ ἐστιν ἐν τῷ κοιλώματι· αὕτη ἔστι Χεβρὼν ἐν τῇ γῇ Χαναάν ἦλθε δὲ Ἁβραὰμ κόψασθαι Σάῤῥαν, καὶ πενθῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Καὶ ἀνέστη Ἁβραὰμ ἀπὸ τοῦ νεκροῦ αὐτοῦ· καὶ εἶπεν Ἁβραὰμ τοῖς υἱοῖς τοῦ Χὲτ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Πάροικος καὶ παρεπίδημος ἐγώ εἰμι μεθʼ ὑμῶν· δότε μοι οὖν κτῆσιν τάφου μεθʼ ὑμῶν, καὶ θάψω τὸν νεκρόν μου ἀπʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ἀπεκρίθησαν δὲ οἱ υἱοὶ Χὲτ πρὸς Ἁβραὰμ, λέγοντες, μὴ, κύριε. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ἄκουσον δὲ ἡμῶν· βασιλεὺς παρὰ Θεοῦ σὺ εἶ ἐν ἡμῖν· ἐν τοῖς ἐκλεκτοῖς μνημείοις ἡμῶν θάψον τὸν νεκρόν σου· οὐδεὶς γὰρ ἡμῶν οὐ μὴ κωλύσει τὸ μνημεῖον αὐτοῦ ἀπὸ σοῦ, τοῦ θάψαι τὸν νεκρόν σου ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ἀναστὰς δὲ Ἁβραὰμ προσεκύνησε τῷ λαῷ τῆς γῆς, τοῖς υἱοῖς τοῦ Χέτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Καὶ ἐλάλησε πρὸς αὐτοὺς Ἁβραὰμ, λέγων, εἰ ἔχετε τῇ ψυχῇ ὑμῶν, ὥστε θάψαι τὸν νεκρόν μου ἀπὸ προσώπου μου, ἀκούσατέ μου, καὶ λαλήσατε περὶ ἐμοῦ Ἐφρὼν τῷ τοῦ Σαάρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Καὶ δότω μοι τὸ σπήλαιον τὸ διπλοῦν, ὅ ἐστιν αὐτῷ, τὸ ὂν ἐν μέρει τοῦ ἀγροῦ αὐτοῦ· ἀργυρίου τοῦ ἀξίου δότε μοι αὐτὸ ἐν ὑμῖν εἰς κτῆσιν μνημείου. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ἐφρὼν δὲ ἐκάθητο ἐν μέσῳ τῶν υἱῶν Χέτ· ἀποκριθεὶς δὲ Ἐφρὼν ὁ Χετταῖος πρὸς Ἁβραὰμ εἶπεν, ἀκουόντων τῶν υἱῶν Χὲτ, καὶ τῶν εἰσπορευομένων εἰς τὴν πόλιν πάντων, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Παρʼ ἐμοὶ γενοῦ, κύριε, καὶ ἄκουσόν μου· τὸν ἀγρὸν, καὶ τὸ σπήλαιον τὸ ἐν αὐτῷ, σοὶ δίδωμι· ἐναντίον πάντων τῶν πολιτῶν μου δέδωκά σοι· θάψον τὸν νεκρόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Καὶ προσεκύνησεν Ἁβραὰμ ἐναντίον τοῦ λαοῦ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Καὶ εἶπε τῷ Ἐφρὼν εἰς τὰ ὦτα ἐναντίον τοῦ λαοῦ τῆς γῆς, ἐπειδὴ πρὸς ἐμοῦ εἶ, ἄκουσόν μου· τὸ ἀργύριον τοῦ ἀγροῦ λάβε παρʼ ἐμοῦ, καὶ θάψω τὸν νεκρόν μου ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ἀπεκρίθη δὲ Ἐφρὼν τῷ Ἁβραὰμ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Οὐχὶ, κύριε· ἀκήκοα γὰρ, γῆ τετρακοσίων διδράχμων ἀργύριου· ἀλλὰ τί ἂν εἴη τοῦτο ἀνὰ μέσον ἐμοῦ καὶ σοῦ; σὺ δὲ τὸν νεκρόν σου θάψον. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","καὶ ἤκουσεν Ἁβραὰμ τοῦ Ἐφρών· καὶ ἀπεκατέστησεν Ἁβραὰμ τῷ Ἐφρὼν τὸ ἀργύριον, ὃ ἐλάλησεν εἰς τὰ ὦτα τῶν υἱῶν Χὲτ, τετρακόσια δίδραχμα ἀργυρίου δοκίμου ἐμπόροις. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Καὶ ἔστη ὁ ἀγρὸς Ἐφρών, ὃς ἦν ἐν τῷ διπλῷ σπηλαίῳ, ὅς ἐστι κατὰ πρόσωπον Μαμβρῆ, ὁ ἀγρὸς καὶ τὸ σπήλαιον, ὃ ἦν ἐν αὐτῷ, καὶ πᾶν δένδρον, ὃ ἦν ἐν τῷ ἀγρῷ, καὶ πᾶν ὅ ἐστιν ἐν τοῖς ὁρίοις αὐτοῦ κύκλῳ, ");
INSERT INTO grcbrent_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","τῷ Ἁβραὰμ, εἰς κτῆσιν ἐναντίον τῶν υἱῶν Χὲτ, καὶ πάντων τῶν εἰσπορευομένων εἰς τὴν πόλιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Μετὰ ταῦτα ἔθαψεν Ἁβραὰμ Σάῤῥαν τὴν γυναῖκα αὐτοῦ ἐν τῷ σπηλαίῳ τοῦ ἀγροῦ τῷ διπλῷ, ὅ ἐστιν ἀπέναντι Μαμβρῆ· αὕτη ἐστὶ Χεβρὼν ἐν τῇ γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Καὶ ἐκυρώθη ὁ ἀγρὸς καὶ τὸ σπήλαιον ὃ ἦν ἐν αὐτῷ τῷ Ἁβραὰμ εἰς κτῆσιν τάφου, παρὰ τῶν υἱῶν Χέτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Καὶ Ἁβραὰμ ἦν πρεσβύτερος προβεβηκὼς ἡμερῶν· καὶ Κύριος ηὐλόγησε τὸν Ἁβραὰμ κατὰ πάντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Καὶ εἶπεν Ἁβραὰμ τῷ παιδὶ αὐτοῦ τῷ πρεσβυτέρῳ τῆς οἰκίας αὐτοῦ, τῷ ἄρχοντι πάντων τῶν αὐτοῦ, θὲς τὴν χεῖρά σου ὑπὸ τὸν μηρόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Καὶ ἐξορκιῶ σε Κύριον τὸν Θεὸν τοῦ οὐρανοῦ καὶ τὸν Θεὸν τῆς γῆς, ἵνα μὴ λάβῃς γυναῖκα τῷ υἱῷ μου Ἰσαὰκ ἀπὸ τῶν θυγατέρων τῶν Χαναναίων, μεθʼ ὧν ἐγὼ οἰκῶ ἐν αὐτοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ἀλλʼ ἢ εἰς τὴν γῆν μου, οὗ ἐγεννήθην, πορεύσῃ, καὶ εἰς τὴν φυλήν μου, καὶ λήψῃ γυναῖκα τῷ υἱῷ μου Ἰσαὰκ ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Εἶπε δὲ πρὸς αὐτὸν ὁ παῖς, μή ποτε οὐ βούληται ἡ γυνὴ πορευθῆναι μετʼ ἐμοῦ ὀπίσω εἰς τὴν γῆν ταύτην, ἀποστρέψω τὸν υἱόν σου εἰς τὴν γῆν, ὅθεν ἐξῆλθες ἐκεῖθεν; ");
INSERT INTO grcbrent_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Εἶπε δὲ πρὸς αὐτὸν Ἁβραάμ, πρόσεχε σεαυτῷ μὴ ἀποστρέψῃς τὸν υἱόν μου ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Κύριος ὁ Θεὸς τοῦ οὐρανοῦ καὶ ὁ Θεὸς τῆς γῆς, ὃς ἔλαβέ με ἐκ τοῦ οἴκου τοῦ πατρός μου, καἰ ἐκ τῆς γῆς ἧς ἐγεννήθην, ὃς ἐλάλησέ μοι, καὶ ὃς ὤμοσέ μοι, λέγων, σοὶ δώσω τὴν γῆν ταύτην καὶ τῷ σπέρματί σου, αὐτὸς ἀποστελεῖ τὸν Ἄγγελον αὐτοῦ ἔμπροσθέν σου, καὶ λήψῃ γυναῖκα τῷ υἱῷ μου ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ἐὰν δὲ μὴ θέλῃ ἡ γυνὴ πορευθῆναι μετὰ σοῦ εἰς τὴν γῆν ταύτην, καθαρὸς ἔσῃ ἀπὸ τοῦ ὅρκου μου· μόνον τὸν υἱόν μου μὴ ἀποστρέψῃς ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Καὶ ἔθηκεν ὁ παῖς τὴν χεῖρα αὐτοῦ ὑπὸ τὸν μηρὸν Ἁβραὰμ τοῦ κυρίου αὐτοῦ, καὶ ὤμοσεν αὐτῷ περὶ τοῦ ῥήματος τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Καὶ ἔλαβεν ὁ παῖς δέκα καμήλους ἀπὸ τῶν καμήλων τοῦ κυρίου αὐτοῦ, καὶ ἀπὸ πάντων τῶν ἀγαθῶν τοῦ κυρίου αὐτοῦ μεθʼ ἑαυτοῦ· καὶ ἀναστὰς ἐπορεύθη εἰς τὴν Μεσοποταμίαν εἰς τὴν πόλιν Ναχώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Καὶ ἐκοίμησε τὰς καμήλους ἔξω τῆς πόλεως παρὰ τὸ φρέαρ τοῦ ὕδατος τὸ πρὸς ὀψέ, ἡνίκα ἐκπορεύονται αἱ ὑδρευόμεναι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Καὶ εἶπε, Κύριε ὁ Θεὸς τοῦ κυρίου μου Ἁβραάμ, εὐόδωσον ἐναντίον ἐμοῦ σήμερον, καὶ ποίησον ἔλεος μετὰ τοῦ κυρίου μου Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ἰδοὺ ἐγὼ ἕστηκα ἐπὶ τῆς πηγῆς τοῦ ὕδατος· αἱ δὲ θυγατέρες τῶν οἰκούντων τὴν πόλιν ἐκπορεύονται ἀντλῆσαι ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Καὶ ἔσται ἡ παρθένος ᾗ ἂν ἐγὼ εἴπω, ἐπίκλινον τὴν ὑδρίαν σου, ἵνα πίω, καὶ εἴπῃ μοι, πίε σύ, καὶ τὰς καμήλους σου ποτιῶ, ἕως ἂν παύσωνται πίνουσαι, ταύτην ἡτοίμασας τῷ παιδί σου τῷ Ἰσαάκ· καὶ ἐν τούτῳ γνώσομαι, ὅτι ἐποίησας ἔλεος μετὰ τοῦ κυρίου μου Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Καὶ ἐγένετο πρὸ τοῦ συντελέσαι αὐτὸν λαλοῦντα ἐν τῇ διανοίᾳ αὐτοῦ, καὶ ἰδοὺ Ῥεβέκκα ἐξεπορεύετο ἡ τεχθεῖσα Βαθουήλ, υἱῷ Μελχὰς τῆς γυναικὸς Ναχώρ, ἀδελφοῦ δὲ Ἁβραάμ, ἔχουσα τὴν ὑδρίαν ἐπὶ τῶν ὤμων αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ἡ δὲ παρθένος ἦν καλὴ τῇ ὄψει σφόδρα· παρθένος ἦν, ἀνὴρ οὐκ ἔγνω αὐτήν· καταβᾶσα δὲ ἐπὶ τὴν πηγὴν, ἔπλησε τὴν ὑδρίαν αὐτῆς, καὶ ἀνέβη. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ἐπέδραμε δὲ ὁ παῖς εἰς συνάντησιν αὐτῆς, καὶ εἶπε, Πότισόν με μικρὸν ὕδωρ ἐκ τῆς ὑδρίας σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ἡ δὲ εἶπε, πίε, κύριε· καὶ ἔσπευσε καὶ καθεῖλε τὴν ὑδρίαν ἐπὶ τὸν βραχίονα αὐτῆς, καὶ ἐπότισεν αὐτὸν, ἕων ἐπαύσατο πίνων. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Καὶ εἶπε, καὶ ταῖς καμήλοις σου ὑδρεύσομαι, ἕως ἂν πᾶσαι πίωσι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Καὶ ἔσπευσε καὶ ἐξεκένωσε τὴν ὑδρίαν εἰς τὸ ποτιστήριον· καὶ ἔδραμεν ἐπὶ τὸ φρέαρ ἀντλῆσαι πάλιν· καὶ ὑδρεύσατο πάσαις ταῖς καμήλοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ὁ δὲ ἄνθρωπος κατεμάνθανεν αὐτήν· καὶ παρεσιώπα τοῦ γνῶναι εἰ εὐώδωκε Κύριος τὴν ὁδὸν αὐτοῦ, ἢ οὔ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ἐγένετο δὲ ἡνίκα ἐπαύσαντο πᾶσαι αἱ κάμηλοι πίνουσαι, ἔλαβεν ὁ ἄνθρωπος ἐνώτια χρυσᾶ ἀνὰ δραχμὴν ὁλκῆς, καὶ δύο ψέλλια ἐπὶ τὰς χεῖρας αὐτῆς, δέκα χρυσῶν ὁλκὴ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Καὶ ἐπηρώτησεν αὐτὴν, καὶ εἶπε, θυγάτηρ τίνος εἶ; ἀνάγγειλόν μοι, εἰ ἔστι παρὰ τῷ πατρί σου τόπος ἡμῖν του καταλῦσαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ἡ δὲ εἶπεν αὐτῷ, θυγάτηρ Βαθουήλ εἰμι τοῦ Μελχάς, ὃν ἔτεκε τῷ Ναχώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Καὶ εἶπεν αὐτῷ, Καὶ ἄχυρα καὶ χορτάσματα πολλὰ παρʼ ἡμῖν, καὶ τόπος τοῦ καταλῦσαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Καὶ εὐδοκήσας ὁ ἄνθρωπος προσεκύνησε τῷ Κυρίῳ ");
INSERT INTO grcbrent_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Καὶ εἶπεν, εὐλογητὸς Κύριος ὁ Θεὸς τοῦ κυρίου μου Ἁβραάμ, ὃς οὐκ ἐγκατέλειπε τὴν δικαιοσύνην αὐτοῦ, καὶ τὴν ἀλήθειαν, ἀπὸ τοῦ κυρίου μου· ἐμὲ τʼ εὐώδωκε Κύριος εἰς οἶκον τοῦ ἀδελφοῦ τοῦ κυρίου μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Καὶ δραμοῦσα ἡ παῖς ἀνήγγειλεν εἰς τὸν οἶκον τῆς μητρὸς αὐτῆς, κατὰ τὰ ῥήματα ταῦτα. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Τῇ δὲ Ῥεβέκκᾷ ἀδελφὸς ἦν, ᾧ ὄνομα Λάβαν· καὶ ἔδραμε Λάβαν πρὸς τὸν ἄνθρωπον ἔξω ἐπὶ τὴν πηγήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Καὶ ἐγένετο ἡνίκα εἶδε τὰ ἐνώτια, καὶ τὰ ψέλλια ἐν ταῖς χερσὶ τῆς ἀδελφῆς αὐτοῦ, καὶ ὅτε ἤκουσε τὰ ῥήματα Ῥεβέκκας τῆς ἀδελφῆς αὐτοῦ, λεγούσης, οὕτω λελάληκέ μοι ὁ ἄνθρωπος, καὶ ἦλθε πρὸς τὸν ἄνθρωπον, ἑστηκότος αὐτοῦ ἐπὶ τῶν καμήλων ἐπὶ τῆς πηγῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Καὶ εἶπεν αὐτῷ, δεῦρο εἴσελθε, εὐλογητὸς Κυροίυ· ἱνατί ἕστηκας ἔξω; ἐγὼ δὲ ἡτοίμασα τὴν οἰκίαν, καὶ τόπον ταῖς καμήλοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Εἰσῆλθε δὲ ὁ ἄνθρωπος εἰς τὴν οἰκίαν, καὶ ἀπέσαξε τὰς καμήλους· καὶ ἔδωκεν ἄχυρα καὶ χορτάσματα ταῖς καμήλοις, καὶ ὕδωρ νίψασθαι τοῖς ποσὶν αὐτοῦ, καὶ τοῖς ποσὶ τῶν ἀνδρῶν τῶν μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Καὶ παρέθηκεν αὐτοῖς ἄρτους φαγεῖν· καὶ εἶπεν, οὐ μὴ φάγω, ἕως τοῦ λαλῆσαί με τὰ ῥήματά μου· καὶ εἶπεν, λάλησον. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Καὶ εἶπε, παῖς Ἁβραὰμ ἐγώ εἰμι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Κύριος δὲ ηὐλόγησε τὸν κύριόν μου σφόδρα, καὶ ὑψώθη· καὶ ἔδωκεν αὐτῷ πρόβατα, καὶ μόσχους, καὶ ἀργύριον, καὶ χρυσίον, παῖδας, καὶ παιδίσκας, καμήλους, καὶ ὄνους. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Καὶ ἔτεκε Σάῤῥα ἡ γυνὴ τοῦ κυρίου μου υἱὸν ἕνα τῷ κυρίῳ μου μετὰ τὸ γηράσαι αὐτόν· καὶ ἔδωκεν αὐτῷ ὅσα ἦν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Καὶ ὥρκισέ με ὁ κύριός μου, λέγων, οὐ λήμψῃ γυναῖκα τῷ υἱῷ μου ἀπὸ τῶν θυγατέρων τῶν Χαναναίων, ἐν οἷς ἐγὼ παροικῶ ἐν τῇ γῇ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ἀλλʼ εἰς τὸν οἶκον τοῦ πατρός μου πορεύσῃ, καὶ εἰς τὴν φυλήν μου, καὶ λήψῃ γυναῖκα τῷ υἱῷ μου ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Εἶπα δὲ τῷ κυρίῳ μου, μήποτε οὐ πορεύσεται ἡ γυνὴ μετʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Καὶ εἶπέ μοι, Κύριος ὁ Θεὸς ᾧ εὐηρέστησα ἐναντίον αὐτοῦ, αὐτὸς ἐξαποστελεῖ τὸν Ἀγγελον αὐτοῦ μετὰ σοῦ, καὶ εὐοδώσει τὴν ὁδόν σου· καὶ λήψῃ γυναῖκα τῷ υἱῷ μου ἐκ τῆς φυλῆς μου, καὶ ἐκ τοῦ οἴκου τοῦ πατρός μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Τότε ἀθῷος ἔσῃ ἀπὸ τῆς ἀρᾶς μου· ἡνίκα γὰρ ἐὰν ἔλθῃς εἰς τὴν φυλήν μου, καὶ μή σοι δῶσι, καὶ ἔσῃ ἀθῷος ἀπὸ τοῦ ὁρκισμοῦ μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Καὶ ἐλθὼν σήμερον ἐπὶ τὴν πηγὴν εἶπα, Κύριε ὁ Θεὸς τοῦ κυρίου μου Ἁβραὰμ, εἰ σὺ εὐοδοῖς τὴν ὁδόν μου, ἐν ᾗ νῦν ἐγὼ πορεύομαι ἐν αὐτῇ, ");
INSERT INTO grcbrent_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ἰδοὺ ἐγὼ ἐφέστηκα ἐπὶ τῆς πηγῆς τοῦ ὕδατος, καὶ αἱ θυγατέρες τῶν ἀνθρώπων τῆς πόλεως ἐκπορεύονται ἀντλῆσαι ὕδωρ· καὶ ἔσται ἡ παρθένος, ᾗ ἂν ἐγὼ εἴπω, πότισόν με ἐκ τῆς ὑδρίας σου μικρὸν ὕδωρ, ");
INSERT INTO grcbrent_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","καὶ εἴπῃ μοι, καὶ σὺ πίε, καὶ ταῖς καμήλοις σου ὑδρεύσομαι, αὕτη ἡ γυνὴ ἣν ἡτοίμασε Κύριος τῷ ἑαυτοῦ θεράποντι Ἰσαάκ· καὶ ἐν τούτῳ γνώσομαι, ὅτι πεποίηκας ἔλεος τῷ κυρίῳ μου Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Καὶ ἐγένετο πρὸ τοῦ συντελέσαι με λαλοῦντα ἐν τῇ διανοίᾳ μου, εὐθὺς Ῥεβέκκα ἐξεπορεύετο, ἔχουσα τὴν ὑδρίαν ἐπὶ τῶν ὤμων· καὶ κατέβη ἐπὶ τὴν πηγὴν, καὶ ὑδρεύσατο· εἶπα δὲ αὐτῇ, πότισόν με. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Καὶ σπεύσασα καθεῖλε τὴν ὑδρίαν ἐπὶ τὸν βραχίονα αὐτῆς ἀφʼ ἑαυτῆς, καὶ εἶπε, πίε σὺ, καὶ τὰς καμήλους σου ποτιῶ· καὶ ἔπιον, καὶ τὰς καμήλους ἐπότισε. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Καὶ ἠρώτησα αὐτὴν, καὶ εἶπα, θυγάτηρ τίνος εἶ, ἀναγγειλόν μοι· ἡ δὲ ἔφη, θυγάτηρ Βαθουὴλ εἰμὶ υἱοῦ τοῦ Ναχὼρ, ὃν ἔτεκεν αὐτῷ Μελχά· καὶ περιέθηκα αὐτῇ τὰ ἐνώτια, καὶ τὰ ψέλλια περὶ τὰς χεῖρας αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Καὶ εὐδοκήσας προσεκύνησα τῷ Κυρίῳ, καὶ εὐλόγησα Κύριον τὸν Θεὸν τοῦ κυρίου μου Ἁβραὰμ, ὃς εὐώδωσέ με ἐν ὁδῷ ἀληθείας λαβεῖν τὴν θυγατέρα τοῦ ἀδελφοῦ τοῦ κυρίου μου τῷ υἱῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Εἰ οὖν ποιεῖτε ὑμεῖς ἔλεος καὶ δικαιοσύνην πρὸς τὸν κύριόν μου· εἰ δὲ μὴ, ἀπαγγείλατέ μοι, ἵνα ἐπιστρέψω εἰς δεξιὰν ἤ ἀριστεράν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ἀποκριθεὶς δὲ Λάβαν καὶ Βαθουὴλ εἶπαν, παρὰ κυρίου ἐξῆλθε τὸ πρᾶγμα τοῦτο· οὐ δυνησόμεθά σοι ἀντειπεῖν κακὸν ἢ καλόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ἰδοὺ Ῥεβέκκα ἐνώπιόν σου· λαβὼν ἀπότρεχε· καὶ ἔστω γυνὴ τῷ υἱῷ τοῦ κυρίου σου, καθὰ ἐλάλησε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ἐγένετο δὲ ἐν τῷ ἀκοῦσαι τὸν παῖδα τοῦ Ἁβραὰμ τῶν ῥημάτων αὐτῶν, προσεκύνησεν ἐπὶ τὴν γῆν τῷ κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","καὶ ἐξενέγκας ὁ παῖς σκεύη ἀργυρᾶ καὶ χρυσᾶ καὶ ἱματισμὸν, ἔδωκε τῇ Ῥεβέκκᾳ· καὶ δῶρα ἔδωκε τῷ ἀδελφῷ αὐτῆς, καὶ τῇ μητρὶ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Καὶ ἔφαγον καὶ ἔπιον καὶ αὐτὸς καὶ οἱ ἄνδρες οἱ μετʼ αὐτοῦ ὄντες, καὶ ἐκοιμήθησαν· καὶ ἀναστὰς τὸ πρωῒ εἶπεν, ἐκπέμψατέ με, ἵνα ἀπέλθω πρὸς τὸν κύριόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Εἶπαν δὲ οἱ ἀδελφοὶ αὐτῆς, καὶ ἡ μήτηρ, μεινάτω ἡ παρθένος μεθʼ ἡμῶν ἡμέρας ὡσεὶ δέκα, καὶ μετὰ ταῦτα ἀπελεύσεται. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ὁ δὲ εἶπε πρὸς αὐτοὺς, μὴ κατέχετέ με· καὶ Κύριος εὐώδωσε τὴν ὁδόν μου ἐν ἐμοί· ἐκπέμψατέ με, ἵνα ἀπέλθω πρὸς τὸν κύριόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Οἱ δὲ εἶπαν, Καλέσωμεν τὴν παῖδα, καὶ ἐρωτήσωμεν τὸ στόμα αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Καὶ ἐκάλεσαν τὴν Ῥεβέκκαν, καὶ εἶπαν αὐτῇ, πορεύσῃ μετὰ τοῦ ἀνθρώπου τούτου; ἡ δὲ εἶπε, πορεύσομαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Καὶ ἐξέπεμψαν Ῥεβέκκαν τὴν ἀδελφὴν αὐτῶν, καὶ τὰ ὑπάρχοντα αὐτῆς, καὶ τὸν παῖδα τοῦ Ἁβραὰμ, καὶ τοὺς μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Καὶ εὐλόγησαν Ῥεβέκκαν, καὶ εἶπαν αὐτῇ, ἀδελφὴ ἡμῶν εἶ, γίνου εἰς χιλιάδας μυριάδων, καὶ κληρονομησάτω τὸ σπέρμα σου τὰς πόλεις τῶν ὑπεναντίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ἀναστᾶσα δὲ Ῥεβέκκα καὶ αἱ ἅβραι αὐτῆς, ἐπέβησαν ἐπὶ τὰς καμήλους, καὶ ἐπορεύθησαν μετὰ τοῦ ἀνθρώπου· καὶ ἀναλαβὼν ὁ παῖς τὴν Ῥεβέκκαν ἀπῆλθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ἰσαὰκ δὲ διεπορεύετο διὰ τῆς ἐρήμου κατὰ τὸ φρέαρ τῆς ὁράσεως· αὐτὸς δὲ κατῴκει ἐν τῇ γῇ τῇ πρὸς Λίβα. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Καὶ ἐξῆλθεν Ἰσαὰκ ἀδολεσχῆσαι εἰς τὸ πεδίον τὸ πρὸς δείλης, καὶ ἀναβλέψας τοῖς ὀφθαλμοῖς αὐτοῦ εἶδε καμήλους ἐρχομένας. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Καὶ ἀναβλέψασα Ῥεβέκκα τοῖς ὀφθαλμοῖς εἶδε τὸν Ἰσαάκ· καὶ κατεπήδησεν ἀπὸ τῆς καμήλου. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Καὶ εἶπε τῷ παιδὶ, τίς ἐστιν ὁ ἄνθρωπος ἐκεῖνος ὁ πορευόμενος ἐν τῷ πεδίῳ εἰς συνάντησιν ἡμῖν; εἶπε δὲ ὁ παῖς, οὗτός ἐστιν ὁ κύριός μου· ἡ δὲ λαβοῦσα τὸ θέριστρον, περιεβάλετο. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Καὶ διηγήσατο ὁ παῖς τῷ Ἰσαὰκ πάντα τὰ ῥήματα, ἃ ἐποίησεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Εἰσῆλθε δὲ Ἰσαὰκ εἰς τὸν οἶκον τῆς μητρὸς αὐτοῦ, καὶ ἔλαβε τὴν Ῥεβέκκαν, καὶ ἐγένετο αὐτοῦ γυνὴ, καὶ ἠγάπησεν αὐτήν· καὶ παρεκλήθη Ἰσαὰκ περὶ Σάῤῥας τῆς μητρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Προσθέμενος δὲ Ἁβραὰμ ἔλαβε γυναῖκα, ᾗ ὄνομα Χεττούρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ἔτεκε δὲ αὐτῷ τὸν Ζομβρᾶν, καὶ τὸν Ἰεζὰν, καὶ τὸν Μαδὰλ, καὶ τὸν Μαδιὰμ, καὶ τὸν Ἰεσβὼκ, καὶ τὸν Σωίε. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ἰεζὰν δὲ ἐγέννησε τὸν Σαβὰ, καὶ τὸν Δεδάν· υἱοὶ δὲ Δεδὰν Ἀσσουριεὶμ, καὶ Λατουσιεὶμ, καὶ Λαωμείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Υἱοὶ δὲ Μαδιὰμ Γεφὰρ, καὶ Ἀφεὶρ, καὶ Ἐνὼχ, καὶ Ἀβειδὰ, καὶ Ἐλδαγά· πάντες οὗτοι ἦσαν υἱοὶ Χεττούρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ἔδωκε δὲ Ἁβραὰμ πάντα τὰ ὑπάρχοντα αὐτοῦ Ἰσαὰκ τῷ υἱῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Καὶ τοῖς υἱοῖς τῶν παλλακῶν αὐτοῦ ἔδωκεν Ἁβραὰμ δόματα, καὶ ἐξαπέστειλεν αὐτοὺς ἀπὸ Ἰσαὰκ τοῦ υἱοῦ αὐτοῦ, ἔτι ζῶντος αὐτοῦ, πρὸς ἀνατολὰς εἰς γῆν ἀνατολῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ταῦτα δὲ τὰ ἔτη ἡμερῶν τῆς ζωῆς Ἁβραὰμ ὅσα ἔζησεν, ἑκατὸν ἑβδομηκονταπεντε ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Καὶ ἐκλείπων ἀπέθανεν Ἁβραὰμ ἐν γήρᾳ καλῷ πρεσβύτης, καὶ πλήρης ἡμερῶν, καὶ προσετέθη πρὸς τὸν λαὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Καὶ ἔθαψαν αὐτὸν Ἰσαὰκ καὶ Ἰσμαὴλ οἱ υἱοὶ αὐτοῦ εἰς τὸ σπήλαιον τὸ διπλοῦν, εἰς τὸν ἀγρὸν Ἐφρων τοῦ Σαὰρ τοῦ Χετταίου, ὅς ἐστιν ἀπέναντι Μαμβρῆ, ");
INSERT INTO grcbrent_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","τὸν ἀγρὸν καὶ τὸ σπήλαιον, ὃ ἐκτήσατο Ἁβραὰμ παρὰ τῶν υἱῶν τοῦ Χέτ· ἐκεῖ ἔθαψαν Ἁβραὰμ, καὶ Σάῤῥαν τὴν γυναῖκα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ἐγένετο δὲ μετὰ τὸ ἀποθανεῖν Ἁβραὰμ, εὐλόγησεν ὁ Θεὸς τὸν Ἰσαὰκ υἱὸν αὐτοῦ· καὶ κατῴκησεν Ἰσαὰκ παρὰ τὸ φρέαρ τῆς ὁράσεως. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Αὗται δὲ αἱ γενέσεις Ἰσμαὴλ τοῦ υἱοῦ Ἁβραὰμ, ὃν ἔτεκεν Ἄγαρ ἡ Αἰγυπτία, ἡ παιδίσκη Σάῤῥας, τῷ Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Καὶ ταῦτα τὰ ὀνόματα τῶν υἱῶν Ἰσμαὴλ, κατʼ ὀνόματα τῶν γενεῶν αὐτοῦ· πρωτότοκος Ἰσμαὴλ, καὶ Ναβαϊὼθ, καὶ Κηδὰρ, καὶ Ναβδεὴλ, καὶ Μασσὰμ, ");
INSERT INTO grcbrent_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","καὶ Μασμὰ, καὶ Δουμὰ, καὶ Μασσῆ, ");
INSERT INTO grcbrent_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","καὶ Χοδδὰν, καὶ Θαιμὰν, καὶ Ἰετοὺρ, καὶ Ναφὲς, καὶ Κεδμά. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","οὗτοί εἰσιν οἱ υἱοὶ Ἰσμαὴλ, καὶ ταῦτα τὰ ὀνόματα αὐτῶν ἐν ταῖς σκηναῖς αὐτῶν, καὶ ἐν ταῖς ἐπαύλεσιν αὐτῶν· δώδεκα ἄρχοντες κατὰ ἔθνη αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Καὶ ταῦτα τὰ ἔτη τῆς ζωῆς Ἰσμαὴλ, ἑκατὸν τριακονταεπτὰ ἔτη· καὶ ἐκλείπων ἀπέθανε, καὶ προσετέθη πρὸς τὸ γένος αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Κατῴκησε δὲ ἀπὸ Εὐϊλὰτ ἕως Σοὺρ, ἥ ἐστι κατὰ πρόσωπον Αἰγύπτου ἕως ἐλθεῖν πρὸς Ἀσσυρίους· κατὰ πρόσωπον πάντων τῶν ἀδελφῶν αὐτοῦ κατῴκησε. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Καὶ αὗται αἱ γενέσεις Ἰσαὰκ τοῦ υἱοῦ Ἁβραάμ· Ἁβραάμ ἐγέννησε τὸν Ἰσαάκ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ἦν δὲ Ἰσαὰκ ἐτῶν τεσσαράκοντα ὅτε ἔλαβε τὴν Ῥεβέκκαν θυγατέρα Βαθουὴλ τοῦ Σύρου ἐκ τῆς Μεσοποταμίας Συρίας, ἀδελφὴν Λάβαν τοῦ Σύρου, ἑαυτῷ εἰς γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ἐδέετο δὲ Ἰσαὰκ Κυρίου περὶ Ῥεβέκκας τῆς γυναικὸς αὐτοῦ, ὅτι στεῖρα ἦν· ἐπήκουσε δὲ αὐτοῦ ὁ Θεὸς, καὶ συνέλαβεν ἐν γαστρὶ Ῥεβέκκα ἡ γυνὴ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ἐσκίρτων δὲ τὰ παιδία ἐν αὐτῇ· εἶπε δὲ, εἰ οὕτω μοι μέλλει γίνεσθαι, ἵνα τί μοι τοῦτο; ἐπορεύθη δὲ πυθέσθαι παρὰ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Καὶ εἶπε Κύριος αὐτῇ, δύο ἔθνη ἐν γαστρί σου εἰσὶ, καὶ δύο λαοὶ ἐκ τῆς κοιλίας σου διασταλήσονται· καὶ λαὸς λαοῦ ὑπερέξει, καὶ ὁ μείζων δουλεύσει τῷ ἐλάσσονι. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Καὶ ἐπληρώθησαν αἱ ἡμέραι τοῦ τεκεῖν αὐτήν· καὶ τῇδε ἦν δίδυμα ἐν τῇ κοιλίᾳ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ἐξῆλθε δὲ ὁ πρωτότοκος πυῤῥάκης· ὅλος, ὡσεὶ δορὰ, δασύς· ἐπωνόμασε δὲ τὸ ὄνομα αὐτοῦ, Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Καὶ μετὰ τοῦτο ἐξῆλθεν ὁ ἀδελφὸς αὐτοῦ, καὶ ἡ χεὶρ αὐτοῦ ἐπειλημμένη τῆς πτέρνης Ἡσαῦ· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ἰακώβ. Ἰσαὰκ δὲ ἦν ἐτῶν ἑξήκοντα, ὅτε ἔτεκεν αὐτοὺς Ῥεβέκκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ηὐξήθησαν δὲ οἱ νεανίσκοι· καὶ ἦν Ἡσαῦ ἄνθρωπος εἰδὼς κυνηγεῖν, ἄγροικος· Ἰακὼβ δὲ ἄνθρωπος ἄπλαστος, οἰκῶν οἰκίαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ἠγάπησε δὲ Ἰσαὰκ τὸν Ἡσαῦ, ὅτι ἡ θήρα αὐτοῦ βρῶσις αὐτῷ· Ῥεβέκκα δὲ ἠγάπα τὸν Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ἥψησε δὲ Ἰακὼβ ἕψημα· ἦλθε δὲ Ἡσαῦ ἐκ τοῦ πεδίου ἐκλείπων. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Καὶ εἶπεν Ἡσαῦ τῷ Ἰακὼβ, γεῦσόν με ἀπὸ τοῦ ἑψήματος πυῤῥου τούτου, ὅτι ἐκλείπω· διὰ τοῦτο ἐκλήθη τὸ ὄνομα αὐτοῦ, Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Εἶπε δὲ Ἰακὼβ τῷ Ἡσαῦ, ἀπόδου μοι σήμερον τὰ πρωτοτόκιά σου ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Καὶ εἶπεν Ἡσαῦ, ἰδοὺ ἐγὼ πορεύομαι τελευτᾷν· καὶ ἵνα τί μοι ταῦτα τὰ πρωτοτόκια; ");
INSERT INTO grcbrent_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Καὶ εἶπεν αὐτῷ Ἰακὼβ, ὄμοσόν μοι σήμερον· καὶ ὤμοσεν αὐτῷ· ἀπέδοτο δὲ Ἡσαῦ τὰ πρωτοτόκια τῷ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ἰακὼβ δὲ ἔδωκε τῷ Ἠσαῦ ἄρτον, καὶ ἕψημα φακοῦ· καὶ ἔφαγε καὶ ἔπιε, καὶ ἀναστὰς ᾤχετο· καὶ ἐφαύλισεν Ἡσαῦ τὰ πρωτοτόκια. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ἐγένετο δὲ λιμὸς ἐπὶ τῆς γῆς, χωρὶς τοῦ λιμοῦ τοῦ πρότερον, ὃς ἐγένετο ἐν τῷ καιρῷ τοῦ Ἁβραάμ· ἐπορεύθη δὲ Ἰσαὰκ πρὸς Ἀβιμέλεχ βασιλέα Φυλιστιεὶμ εἰς Γέραρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ὤφθη δὲ αὐτῷ Κύριος, καὶ εἶπε, μὴ καταβῇς εἰς Αἴγυπτον· κατοίκησον δὲ ἐν τῇ γῇ, ᾗ ἄν σοι εἴπω. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Καὶ παροίκει ἐν τῇ γῇ ταύτῃ, καὶ ἔσομαι μετὰ σοῦ, καὶ εὐλογήσω σε· σοὶ γὰρ καὶ τῷ σπέρματί σου δώσω πᾶσαν τὴν γῆν ταύτην· καὶ στήσω τὸν ὅρκον μου, ὅν ὤμοσα τῷ Ἁβραὰμ τῷ πατρί σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Καὶ πληθυνῶ τὸ σπέρμα σου, ὡς τοὺς ἀστέρας τοῦ οὐρανοῦ· καὶ δώσω τῷ σπέρματί σου πᾶσαν τὴν γῆν ταύτην· καὶ εὐλογηθήσονται ἐν τῷ σπέρματί σου πάντα τὰ ἔθνη τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ἀνθʼ ὧν ὑπήκουσεν Ἁβραὰμ ὁ πατήρ σου τῆς ἐμῆς φωνῆς, καὶ ἐφύλαξε τὰ προστάγματά μου, καὶ τὰς ἐντολάς μου, καὶ τὰ δικαιώματά μου, καὶ τὰ νόμιμά μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Κατῴκησε δὲ Ἰσαὰκ ἐν Γεράροις. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ἐπηρώτησαν δὲ οἱ ἄνδρες τοῦ τόπου περὶ Ῥεβέκκας τῆς γυναικὸς αὐτοῦ, καὶ εἶπεν, ἀδελφή μου ἐστίν· ἐφοβήθη γὰρ εἰπεῖν, ὅτι γυνή μου ἐστὶ, μή ποτε ἀποκτείνωσιν αὐτὸν οἱ ἄνδρες τοῦ τόπου περὶ Ῥεβέκκας, ὅτι ὡραία τῇ ὄψει ἦν. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ἐγένετο δὲ πολυχρόνιος ἐκεῖ· καὶ παρακύψας Ἀβιμέλεχ ὁ βασιλεὺς Γεράρων διὰ τῆς θυρίδος, εἶδε τὸν Ἰσαὰκ παίζοντα μετὰ Ῥεβέκκας τῆς γυναικὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ἐκάλεσε δὲ Ἀβιμέλεχ τὸν Ἰσαὰκ, καὶ εἶπεν αὐτῷ, ἆρά γε γυνή σου ἐστί; τί ὅτι εἶπας, ἀδελφή μου ἐστίν; εἶπε δὲ αὐτῷ Ἰσαὰκ, εἶπα γὰρ, μή ποτε ἀποθάνω διʼ αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Εἶπε δὲ αὐτῷ Ἀβιμέλεχ, τί τοῦτο ἐποίησας ἡμῖν; μικροῦ ἐκοιμήθη τις ἐκ τοῦ γένους μου μετὰ τῆς γυναικός σου, καὶ ἐπήγαγες ἂν ἐφʼ ἡμᾶς ἄγνοιαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Συνέταξε δὲ Ἀβιμέλεχ παντὶ τῷ λαῷ αὐτοῦ, λέγων, πᾶς ὁ ἁψάμενος τοῦ ἀνθρώπου τούτου καὶ τῆς γυναικὸς αὐτοῦ, θανάτῳ ἔνοχος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ἔσπειρε δὲ Ἰσαὰκ ἐν τῇ γῇ ἐκείνῃ, καὶ εὗρεν ἐν τῷ ἐνιαυτῷ ἐκείνῳ ἑκατοστεύουσαν κριθήν· εὐλόγησε δὲ αὐτὸν Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Καὶ ὑψώθη ὁ ἄνθρωπος, καὶ προβαίνων μείζων ἐγένετο, ἕως οὗ μέγας ἐγένετο σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ἐγένετο δὲ αὐτῷ κτήνη προβάτων, καὶ κτήνη βοῶν, καὶ γεώργια πολλά. ἐζήλωσαν δὲ αὐτὸν οἱ Φυλιστιείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Καὶ πάντα τὰ φρέατα, ἃ ὤρυξαν οἱ παῖδες τοῦ πατρὸς αὐτοῦ ἐν τῷ χρόνῳ τοῦ πατρὸς αὐτοῦ, ἐνέφραξαν αὐτὰ οἱ Φυλιστιεὶμ, καὶ ἔπλησαν αὐτὰ γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Εἶπε δὲ Ἀβιμέλεχ πρὸς Ἰσαὰκ, ἄπελθε ἀφʼ ἡμῶν, ὅτι δυνατώτερος ἡμῶν ἐγένου σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Καὶ ἀπῆλθεν ἐκεῖθεν Ἰσαάκ· καὶ κατέλυσεν ἐν τῇ φάραγγι Γεράρων, καὶ κατῴκησεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Καὶ πάλιν Ἰσαὰκ ὤρυξε τὰ φρέατα τοῦ ὕδατος, ἃ ὤρυξαν οἱ παῖδες Ἁβραὰμ τοῦ πατρὸς αὐτοῦ, καὶ ἐνέφραξαν αὐτὰ οἱ Φυλιστιεὶμ μετὰ τὸ ἀποθανεῖν Ἁβραὰμ τὸν πατέρα αὐτοῦ· καὶ ἐπωνόμασεν αὐτοῖς ὀνόματα κατὰ τὰ ὀνόματα, ἃ ὠνόμασεν ὁ πατὴρ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Καὶ ὤρυξαν οἱ παῖδες Ἰσαὰκ ἐν τῇ φάραγγι Γεράρων· καὶ εὗρον ἐκεῖ φρέαρ ὕδατος ζῶντος. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Καὶ ἐμαχέσαντο οἱ ποιμένες Γεράρων μετὰ τῶν ποιμένων Ἰσαὰκ, φάσκοντες αὐτῶν εἶναι τὸ ὕδωρ· καὶ ἐκάλεσαν τὸ ὄνομα τοῦ φρέατος, Ἀδικία· ἠδίκησαν γὰρ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ἀπᾴρας δὲ ἐκεῖθεν ὤρυξε φρέαρ ἕτερον· ἐκρίνοντο δὲ καὶ περὶ ἐκείνου· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ, Ἐχθρία. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ἀπᾴρας δὲ ἐκεῖθεν ὤρυξε φρέαρ ἕτερον· καὶ οὐκ ἐμαχέσαντο περὶ αὐτοῦ· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ, Εὐρυχωρία, λέγων, διότι νῦν ἐπλάτυνε Κύριος ἡμῖν, καὶ ηὔξησεν ἡμᾶς ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ἀνέβη δὲ ἐκεῖθεν ἐπὶ τὸ φρέαρ τοῦ ὅρκου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Καὶ ὤφθη αὐτῷ Κύριος ἐν τῇ νυκτὶ ἐκείνῃ, καὶ εἶπεν, ἐγώ εἰμι ὁ Θεὸς Ἁβραὰμ τοῦ πατρός σου· μὴ φοβοῦ, μετὰ σοῦ γάρ εἰμι, καὶ εὐλογήσω σε, καὶ πληθυνῶ τὸ σπέρμα σου διʼ Ἁβραὰμ τὸν πατέρα σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Καὶ ᾠκοδόμησεν ἐκεῖ θυσιαστήριον, καὶ ἐπεκαλέσατο τὸ ὄνομα Κυρίου, καὶ ἔπηξεν ἐκεῖ τὴν σκηνὴν αὐτοῦ· ὤρυξαν δὲ ἐκεῖ οἱ παῖδες Ἰσαὰκ φρέαρ ἐν τῇ φάραγγι Γεράρων. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Καὶ Ἀβιμέλεχ ἐπορεύθη πρὸς αὐτὸν ἀπὸ Γεράρων, καὶ Ὁχοζὰθ ὁ νυμφαγωγὸς αὐτοῦ, καὶ Φιχὼλ ὁ ἀρχιστράτηγος τῆς δυνάμεως αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Καὶ εἶπεν αὐτοῖς Ἰσαὰκ, ἵνα τί ἤλθετε πρός με; ὑμεῖς δὲ ἐμισήσατέ με, καὶ ἐξαπεστείλατέ με ἀφʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Οἱ δὲ εἶπαν, ἰδόντες ἑωράκαμεν ὅτι ἦν Κύριος μετὰ σοῦ· καὶ εἴπαμεν, γενέσθω ἀρὰ ἀνὰ μέσον ἡμῶν καὶ ἀνὰ μέσον σου, καὶ διαθησόμεθα μετὰ σοῦ διαθήκην, ");
INSERT INTO grcbrent_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Μὴ ποιήσαι μεθʼ ἡμῶν κακὸν, καθότι οὐκ ἐβδελυξάμεθά σε ἡμεῖς, καὶ ὃν τρόπον ἐχρησάμεθά σοι καλῶς, καὶ ἐξαπεστείλαμέν σε μετʼ εἰρήνης· καὶ νῦν εὐλογημένος σὺ ὑπὸ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Καὶ ἐποίησεν αὐτοῖς δοχὴν, καὶ ἔφαγον καὶ ἔπιον. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Καὶ ἀναστάντες τὸ πρωῒ, ὤμοσεν ἕκαστος τῷ πλησίον· καὶ ἐξαπέστειλεν αὐτοὺς Ἰσαάκ· καὶ ἀπῴχοντο ἀπʼ αὐτοῦ μετὰ σωτηρίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ἐγένετο δὲ ἐν τῇ ἡμέρᾳ ἐκείνῃ, καὶ παραγενόμενοι οἱ παῖδες Ἰσαὰκ ἀπήγγειλαν αὐτῷ περὶ τοῦ φρέατος οὗ ὤρυξαν, καὶ εἶπαν, οὐχ εὕρομεν ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Καὶ ἐκάλεσεν αὐτὸ, Ὅρκος· διὰ τοῦτο ἐκάλεσεν ὄνομα τῇ πόλει ἐκείνῃ, Φρέαρ Ὅρκου, ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ἦν δὲ Ἡσαῦ ἐτῶν τεσσαράκοντα, καὶ ἔλαβε γυναῖκα Ἰουδὶθ, θυγατέρα Βεὼχ τοῦ Χετταίου, καὶ τὴν Βασεμὰθ, θυγατέρα Ἑλὼν Χετταίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Καὶ ἦσαν ἐρίζουσαι τῷ Ἰσαὰκ καὶ τῇ Ῥεβέκκᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ἐγένετο δὲ μετὰ τὸ γηράσαι τὸν Ἰσαὰκ, καὶ ἠμβλύνθησαν οἱ ὀφθαλμοὶ αὐτοῦ τοῦ ὁρᾷν, καὶ ἐκάλεσεν Ἡσαῦ τὸν υἱὸν αὐτοῦ τὸν πρεσβύτερον, καὶ εἶπεν αὐτῷ, υἱέ μου· καὶ εἶπεν, ἰδοὺ ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Καὶ εἶπεν, ἰδοὺ γεγήρακα, καὶ οὐ γινώσκω τὴν ἡμέραν τῆς τελευτῆς μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Νῦν οὖν λάβε τὸ σκεῦός σου, τήν τε φαρέτραν, καὶ τὸ τόξον, καὶ ἔξελθε εἰς τὸ πεδίον, καὶ θήρευσόν μοι θήραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Καὶ ποίησόν μοι ἐδέσματα, ὡς φιλῶ ἐγὼ, καὶ ἔνεγκέ μοι, ἵνα φάγω, ὅπως εὐλογήσῃ σε ἡ ψυχή μου πρὶν ἀποθανεῖν με. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ῥεβέκκα δὲ ἤκουσε λαλοῦντος Ἰσαὰκ πρὸς Ἡσαῦ τὸν υἱὸν αὐτοῦ· ἐπορεύθη δὲ Ἡσαῦ εἰς τὸ πεδίον θηρεῦσαι θήραν τῷ πατρὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ῥεβέκκα δὲ εἶπε πρὸς τὸν Ἰακὼβ τὸν υἱὸν αὐτῆς τὸν ἐλάσσω, ἴδε, ἤκουσα τοῦ πατρός σου λαλοῦντος πρὸς Ἡσαῦ τὸν ἀδελφόν σου, λέγοντος, ");
INSERT INTO grcbrent_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ἔνεγκόν μοι θήραν, καὶ ποίησόν μοι ἐδέσματα, ἵνα φαγὼν εὐλογήσω σε ἐναντίον Κυρίου πρὸ τοῦ ἀποθανεῖν με. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Νῦν οὖν, υἱέ μου, ἄκουσόν μου, καθὰ ἐγώ σοι ἐντέλλομαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Καὶ πορευθεὶς εἰς τὰ πρόβατα, λάβε μοι ἐκεῖθεν δύο ἐρίφους ἁπαλοὺς καὶ καλοὺς, καὶ ποιήσω αὐτοὺς ἐδέσματα τῷ πατρί σου, ὡς φιλεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Καὶ εἰσοίσεις τῷ πατρί σου, καὶ φάγεται, ὅπως εὐλογήσῃ σε ὁ πατήρ σου πρὸ τοῦ ἀποθανεῖν αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Εἶπε δὲ Ἰακὼβ πρὸς Ῥεβέκκαν τὴν μητέρα αὐτοῦ, ἔστιν Ἡσαῦ ὁ ἀδελφός μου ἀνὴρ δασὺς, ἐγὼ δὲ ἀνὴρ λεῖος. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Μή ποτε ψηλαφήσῃ με ὁ πατὴρ, καὶ ἔσομαι ἐναντίον αὐτοῦ ὡς καταφρονῶν, καὶ ἐπάξω ἐπʼ ἐμαυτὸν κατάραν, καὶ οὐκ εὐλογίαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Εἶπε δὲ αὐτῷ ἡ μήτηρ, ἐπʼ ἐμὲ ἡ κατάρα σου, τέκνον· μόνον ἐπάκουσόν μου τῆς φωνῆς, καὶ πορευθεὶς ἔνεγκέ μοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Πορευθεὶς δὲ ἔλαβε, καὶ ἤνεγκε τῇ μητρί· καὶ ἐποίησεν ἡ μήτηρ αὐτοῦ ἐδέσματα, καθὰ ἐφίλει ὁ πατὴρ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Καὶ λαβοῦσα Ῥεβέκκα τὴν στολὴν Ἡσαῦ τοῦ υἱοῦ αὐτῆς τοῦ πρεσβυτέρου τὴν καλὴν, ἣ ἦν παρʼ αὐτῇ ἐν τῷ οἴκῳ, ἐνέδυσεν αὐτὴν Ἰακὼβ τὸν υἱὸν αὐτῆς τὸν νεώτερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Καὶ τὰ δέρματα τῶν ἐρίφων περιέθηκεν ἐπὶ τοὺς βραχίονας αὐτοῦ, καὶ ἐπὶ τὰ γυμνὰ τοῦ τραχήλου αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Καὶ ἔδωκε τὰ ἐδέσματα, καὶ τοὺς ἄρτους οὓς ἐποίησεν, εἰς τὰς χεῖρας Ἰακὼβ τοῦ υἱοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Καὶ εἰσήνεγκε τῷ πατρὶ αὐτοῦ· εἶπε δὲ, πάτερ· ὁ δὲ εἶπεν, ἰδοὺ ἐγώ· τίς εἶ σὺ, τέκνον; ");
INSERT INTO grcbrent_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Καὶ εἶπεν Ἰακὼβ τῷ πατρὶ, ἐγὼ Ἡσαῦ ὁ πρωτότοκός σου πεποίηκα καθὰ ἐλάλησάς μοι· ἀναστὰς κάθισον, καὶ φάγε ἀπὸ τῆς θήρας μου, ὅπως εὐλογήσῃ με ἡ ψυχή σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Εἶπε δὲ Ἰσαὰκ τῷ υἱῷ αὐτοῦ, τί τοῦτο, ὃ ταχὺ εὗρες, ὦ τέκνον; ὁ δὲ εἶπεν, ὃ παρέδωκε Κύριος ὁ Θεός σου ἐναντίον μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Εἶπε δὲ Ἰσαὰκ τῷ Ἰακὼβ, ἔγγισόν μοι, καὶ ψηλαφήσω σε, τέκνον, εἰ σὺ εἶ ὁ υἱός μου Ἡσαῦ, ἢ οὔ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ἤγγισε δὲ Ἰακὼβ πρὸς Ἰσαὰκ τὸν πατέρα αὐτοῦ· καὶ ἐψηλάφησεν αὐτὸν, καὶ εἶπεν, ἡ μὲν φωνὴ, φωνὴ Ἰακὼβ, αἱ δὲ χεῖρες, χεῖρες Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Καὶ οὐκ ἐπέγνω αὐτὸν, ἦσαν γὰρ αἱ χεῖρες αὐτοῦ, ὡς αἱ χεῖρες Ἡσαῦ τοῦ ἀδελφοῦ αὐτοῦ, δασεῖαι· καὶ εὐλόγησεν αὐτὸν, ");
INSERT INTO grcbrent_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","καὶ εἶπε, σὺ εἶ ὁ υἱός μου Ἡσαῦ; ὁ δὲ εἶπεν, ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Καὶ εἶπε, προσάγαγέ μοι, καὶ φάγομαι ἀπὸ τῆς θήρας σου, τέκνον, ἵνα εὐλογήσῃ σε ἡ ψυχή μου· καὶ προσήνεγκεν αὐτῷ, καὶ ἔφαγε· καὶ εἰσήνεγκεν αὐτῷ οἶνον, καὶ ἔπιε. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Καὶ εἴπεν αὐτῷ Ἰσαὰκ ὁ πατὴρ αὐτοῦ, ἔγγισόν μοι, καὶ φίλησόν με, τέκνον. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Καὶ ἐγγίσας ἐφίλησεν αὐτόν· καὶ ὠσφράνθη τὴν ὀσμὴν τῶν ἱματίων αὐτοῦ, καὶ εὐλόγησεν αὐτὸν, καὶ εἶπεν, ἰδοὺ ὀσμὴ τοῦ υἱοῦ μου, ὡς ὀσμὴ ἀγροῦ πλήρους, ὃν εὐλόγησε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Καὶ δῴη σοι ὁ Θεὸς ἀπὸ τῆς δρόσου τοῦ οὐρανοῦ, καὶ ἀπὸ τῆς πιότητος τῆς γῆς, καὶ πλῆθος σίτου καὶ οἴνου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Καὶ δουλευσάτωσάν σοι ἔθνη, καὶ προσκυνησάτωσάν σοι ἄρχοντες· καὶ γίνου κύριος τοῦ ἀδελφοῦ σου, καὶ προσκυνήσουσί σοι οἱ υἱοὶ τοῦ πατρός σου· ὁ καταρώμενός σε, ἐπικατάρατος· ὁ δὲ εὐλογῶν σε, εὐλογημένος. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Καὶ ἐγένετο μετὰ τὸ παύσασθαι Ἰσαὰκ εὐλογοῦντα Ἰακὼβ τὸν υἱὸν αὐτοῦ, καὶ ἐγένετο, ὡς ἂν ἐξῆλθεν Ἰακὼβ ἀπὸ προσώπου Ἰσαὰκ τοῦ πατρὸς αὐτοῦ, καὶ Ἡσαῦ ὁ ἀδελφὸς αὐτοῦ ἦλθεν ἀπὸ τῆς θήρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Καὶ ἐποίησε καὶ αὐτὸς ἐδέσματα, καὶ προσήνεγκε τῷ πατρὶ αὐτοῦ· καὶ εἶπε τῷ πατρὶ, ἀναστήτω ὁ πατήρ μου, καὶ φαγέτω ἀπὸ τῆς θήρας τοῦ υἱοῦ αὐτοῦ, ὅπως εὐλογήσῃ με ἡ ψυχή σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Καὶ εἶπεν αὐτῷ Ἰσαὰκ ὁ πατὴρ αὐτοῦ, τίς εἶ σύ; ὁ δὲ εἶπεν, ἐγώ εἰμι ὁ υἱός σου ὁ πρωτότοκος Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ἐξέστη δὲ Ἰσαὰκ ἔκστασιν μεγάλην σφόδρα, καὶ εἶπε, τίς οὖν ὁ θηρεύσας μοι θήραν καὶ εἰσενέγκας μοι, καὶ ἔφαγον ἀπὸ πάντων πρὸ τοῦ ἐλθεῖν σε; καὶ εὐλόγησα αὐτὸν, καὶ εὐλογημένος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ἐγένετο δὲ ἡνίκα ἤκουσεν Ἡσαῦ τὰ ῥήματα τοῦ πατρὸς αὐτοῦ Ἰσαὰκ, ἀνεβόησε φωνὴν μεγάλην καὶ πικρὰν σφόδρα· καὶ εἶπεν, εὐλόγησον δὴ κᾀμὲ, πάτερ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Εἶπε δὲ αὐτῷ, ἐλθὼν ὁ ἀδελφός σου μετὰ δόλου ἔλαβε τὴν εὐλογίαν σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Καὶ εἶπε, δικαίως ἐκλήθη τὸ ὄνομα αὐτοῦ Ἰακὼβ, ἐπτέρνικε γάρ με ἰδοὺ δεύτερον τοῦτο· τά τε πρωτοτόκιά μου εἴληφε, καὶ νῦν ἔλαβε τὴν εὐλογίαν μου· καὶ εἶπεν Ἡσαῦ τῷ πατρὶ αὐτοῦ, οὐχ ὑπελίπου μοι εὐλογίαν, πάτερ; ");
INSERT INTO grcbrent_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ἀποκριθεὶς δὲ Ἰσαὰκ εἶπε τῷ Ἡσαῦ, εἰ κύριον αὐτὸν πεποίηκά σου, καὶ πάντας τοὺς ἀδελφοὺς αὐτοῦ πεποίηκα αὐτοῦ οἰκέτας· σίτῳ καὶ οἴνῳ ἐστήριξα αὐτόν· σοὶ δὲ τί ποιήσω, τέκνον; ");
INSERT INTO grcbrent_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Εἶπε δὲ Ἡσαῦ πρὸς τὸν πατέρα αὐτοῦ, μὴ εὐλογία μία σοι ἔστι, πάτερ; εὐλόγησον δὴ κᾀμὲ, πάτερ· κατανυχθέντος δὲ Ἰσαὰκ, ἀνεβόησε φωνῇ Ἡσαῦ, καὶ ἔκλαυσεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ἀποκοιθεὶς δὲ Ἰσαὰκ ὁ πατὴρ αὐτοῦ εἶπεν αὐτῷ, ἰδοὺ ἀπὸ τῆς πιότητος τῆς γῆς ἔσται ἡ κατοίκησίς σου, καὶ ἀπὸ τῆς δρόσου τοῦ οὐρανοῦ ἄνωθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Καὶ ἐπὶ τῇ μαχαίρᾳ σου ζήσῃ, καὶ τῷ ἀδελφῷ σου δουλεύσεις· ἔσται δὲ ἡνίκα ἐὰν καθέλῃς καὶ ἐκλύσῃς τὸν ζυγὸν αὐτοῦ ἀπὸ τοῦ τραχήλου σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Καὶ ἐνεκότει Ἡσαῦ τῷ Ἰακὼβ περὶ τῆς εὐλογίας, ἧς εὐλόγησεν αὐτὸν ὁ πατὴρ αὐτοῦ· εἶπε δὲ Ἡσαῦ ἐν τῇ διανοίᾳ αὐτοῦ, ἐγγισάτωσαν αἱ ἡμέραι τοῦ πένθους τοῦ πατρός μου, ἵνα ἀποκτείνω Ἰακὼβ τὸν ἀδελφόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ἀπηγγέλη δὲ Ῥεβέκκᾳ τὰ ῥήματα Ἡσαῦ τοῦ υἱοῦ αὐτῆς τοῦ πρεσβυτέρου· καὶ πέμψασα ἐκάλεσεν Ἰακὼβ τὸν υἱὸν αὐτῆς τὸν νεώτερον, καὶ εἶπεν αὐτῷ, ἰδοὺ Ἡσαῦ ὁ ἀδελφός σου ἀπειλεῖ σοι τοῦ ἀποκτεῖναί σε. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Νῦν οὖν, τέκνον, ἄκουσόν μου τῆς φωνῆς, καὶ ἀναστὰς ἀπόδραθι εἰς τὴν Μεσοποταμίαν πρὸς Λάβαν τὸν ἀδελφόν μου εἰς Χαῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Καὶ οἴκησον μετʼ αὐτοῦ ἡμέρας τινὰς, ἕως τοῦ ἀποστρέψαι τὸν θυμὸν, ");
INSERT INTO grcbrent_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","καὶ τὴν ὀργὴν τοῦ ἀδελφοῦ σου ἀπὸ σοῦ, καὶ ἐπιλάθηται ἃ πεποίηκας αὐτῷ· καὶ ἀποστείλασα μεταπέμψομαί σε ἐκεῖθεν, μή ποτε ἀποτεκνωθῶ ἀπὸ τῶν δύο ὑμῶν ἐν ἡμέρᾳ μιᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Εἶπε δὲ Ῥεβέκκα πρὸς Ἰσαὰκ, προσώχθικα τῇ ζωῇ μου διὰ τὰς θυγατέρας τῶν υἱῶν Χέτ· εἰ λήψεται Ἰακὼβ γυναῖκα ἀπὸ τῶν θυγατέρων τῆς γῆς ταύτης, ἵνα τί μοι τὸ ζῇν; ");
INSERT INTO grcbrent_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Προσκαλεσάμενος δὲ Ἰσαὰκ τὸν Ἰακὼβ, εὐλόγησεν αὐτὸν, καὶ ἐνετείλατο αὐτῷ, λέγων, οὐ λήψῃ γυναῖκα ἐκ τῶν θυγατέρων τῶν Χαναναίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ἀναστὰς ἀπόδραθι εἰς τὴν Μεσοποταμίαν, εἰς τὸν οἶκον Βαθουὴλ τοῦ πατρὸς τῆς μητρός σου, καὶ λάβε σεαυτῷ ἐκεῖθεν γυναῖκα ἐκ τῶν θυγατέρων Λάβαν τοῦ ἀδελφοῦ τῆς μητρός σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ὁ δὲ Θεός μου εὐλογήσαι σε, καὶ αὐξήσαι σε, καὶ πληθύναι σε· καὶ ἔσῃ εἰς συναγωγὰς ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Καὶ δῴη σοι τὴν εὐλόγιαν Ἁβραὰμ τοῦ πατρός μου, σοὶ καὶ τῷ σπέρματί σου μετὰ σὲ, κληρονομῆσαι τὴν γῆν τῆς παροικήσεώς σου, ἣν ἔδωκεν ὁ Θεὸς τῷ Ἁβραάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Καὶ ἀπέστειλεν Ἰσαὰκ τὸν Ἰακώβ· καὶ ἐπορεύθη εἰς τὴν Μεσοποταμίαν πρὸς Λάβαν τὸν υἱὸν Βαθουὴλ τοῦ Σύρου, ἀδελφὸν Ῥεβέκκας τῆς μητρὸς Ἰακὼβ καὶ Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ἴδε δὲ Ἡσαῦ ὅτι εὐλόγησεν Ἰσαὰκ τὸν Ἰακὼβ, καὶ ἀπέστειλεν εἰς τὴν Μεσοποταμίαν Συρίας, λαβεῖν ἑαυτῷ γυναῖκα ἐκεῖθεν, ἐν τῷ εὐλογεῖν αὐτόν· καὶ ἐνετείλατο αὐτῷ, λέγων, οὐ λήψῃ γυναῖκα ἐκ τῶν θυγατέρων τῶν Χαναναίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Καὶ ἤκουσεν Ἰακὼβ τοῦ πατρὸς καὶ τῆς μητρὸς αὐτοῦ· καὶ ἐπορεύθη εἰς τὴν Μεσοποταμίαν Συρίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ἰδὼν δὲ καὶ Ἡσαῦ ὅτι πονηραί εἰσιν αἱ θυγατέρες Χαναὰν ἐναντίον Ἰσαὰκ τοῦ πατρὸς αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ἐπορεύθη Ἡσαῦ πρὸς Ἰσμαήλ· καὶ ἔλαβε τὴν Μαελὲθ, θυγατέρα Ἰσμαὴλ τοῦ υἱοῦ Ἁβραὰμ, ἀδελφὴν Ναβεὼθ, πρὸς ταῖς γυναιξὶν αὐτοῦ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Καὶ ἐξῆλθεν Ἰακὼβ ἀπὸ τοῦ φρέατος τοῦ ὅρκου, καὶ ἐπορεύθη εἰς Χαῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Καὶ ἀπήντησε τόπῳ, καὶ ἐκοιμήθη ἐκεῖ, ἔδυ γὰρ ὁ ἥλιος· καὶ ἔλαβεν ἀπὸ τῶν λίθων τοῦ τόπου, καὶ ἔθηκε πρὸς κεφαλῆς αὐτοῦ· καὶ ἐκοιμήθη ἐν τῷ τόπῳ ἐκείνῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Καὶ ἐνυπνιάσθη· καὶ ἰδοὺ κλίμαξ ἐστηριγμένη ἐν τῇ γῇ, ἧς ἡ κεφαλὴ ἀφικνεῖτο εἰς τὸν οὐρανόν· καὶ οἱ ἄγγελοι τοῦ θεοῦ ἀνέβαινον καὶ κατέβαινον ἐπʼ αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ὁ δὲ Κύριος ἐπεστήρικτο ἐπʼ αὐτῆς· καὶ εἶπεν, ἐγώ εἰμι ὁ Θεὸς Ἁβραὰμ τοῦ πατρός σου, καὶ ὁ Θεὸς Ἰσαάκ· μὴ φοβοῦ· ἡ γῆ ἐφʼ ἧς σὺ καθεύδεις ἐπʼ αὐτῆς, σοὶ δώσω αὐτὴν, καὶ τῷ σπέρματί σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Καὶ ἔσται τὸ σπέρμα σου ὡς ἡ ἄμμος τῆς γῆς, καὶ πλατυνθήσεται ἐπὶ θάλασσαν, καὶ Λίβα, καὶ Βοῤῥὰν, καὶ ἐπὶ ἀνατολάς· καὶ ἐνευλογηθήσονται ἐν σοὶ πᾶσαι αἱ φυλαὶ τῆς γῆς, καὶ ἐν τῷ σπέρματί σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Καὶ ἰδοὺ ἐγώ εἰμι μετὰ σοῦ, διαφυλάσσων σε ἐν τῇ ὁδῷ πάσῃ, οὗ ἂν πορευθῇς· καὶ ἀποστρέψω σε εἰς τὴν γῆν ταύτην· ὅτι οὐ μή σε ἐγκαταλίπω, ἕως τοῦ ποιῆσαί με πάντα ὅσα ἐλάλησά σοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Καὶ ἐξηγέρθη Ἰακὼβ ἐκ τοῦ ὕπνου αὐτοῦ, καὶ εἶπεν, ὅτι ἔστι Κύριος ἐν τῷ τόπῳ τούτῳ, ἐγὼ δὲ οὐκ ᾔδειν. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Καὶ ἐφοβήθη, καὶ εἶπεν, ὡς φοβερὸς ὁ τόπος οὗτος· οὐκ ἔστι τοῦτο ἀλλʼ ἢ οἶκος Θεοῦ, καὶ αὕτη ἡ πύλη τοῦ οὐρανοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Καὶ ἀνέστη Ἰακὼβ τὸ πρωῒ, καὶ ἔλαβε τὸν λίθον, ὃν ὑπέθηκεν ἐκεῖ πρὸς κεφαλῆς αὐτοῦ, καὶ ἔστησεν αὐτὸν στήλην, καὶ ἐπέχεεν ἔλαιον ἐπὶ τὸ ἄκρον αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Καὶ ἐκάλεσε τὸ ὄνομα τοῦ τόπου ἐκείνου, οἶκος Θεοῦ· καὶ Οὐλαμλοὺζ ἦν ὄνομα τῇ πόλει τὸ πρότερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Καὶ ηὔξατο Ἰακὼβ εὐχὴν, λέγων, ἐὰν ᾖ Κύριος ὁ Θεὸς μετʼ ἐμοῦ, καὶ διαφυλάξῃ με ἐν τῇ ὁδῷ ταύτῃ, ᾗ ἐγὼ πορεύομαι, καὶ δῷ μοι ἄρτον φαγεῖν, καὶ ἱμάτιον περιβαλέσθαι, ");
INSERT INTO grcbrent_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","καὶ ἀποστρέψῃ με μετὰ σωτηρίας εἰς τὸν οἶκον τοῦ πατρός μου, καὶ ἔσται Κύριός μοι εἰς Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Καὶ ὁ λίθος οὗτος, ὃν ἔστησα στήλην, ἔσται μοι οἶκος Θεοῦ· καὶ πάντων ὧν ἐάν μοι δῷς, δεκάτην ἀποδεκατώσω αὐτά σοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Καὶ ἐξᾴρας Ἰακὼβ τοὺς πόδας ἐπορεύθη εἰς γῆν ἀνατολῶν, πρὸς Λάβαν τὸν υἱὸν Βαθουὴλ τοῦ Σύρου, ἀδελφὸν δὲ Ῥεβέκκας, μητρὸς Ἰακὼβ καὶ Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Καὶ ὁρᾷ, καὶ ἰδοὺ φρέαρ ἐν τῷ πεδίῳ· ἦσαν δὲ ἐκεῖ τρία ποίμνια προβάτων ἀναπαυόμενα ἐπʼ αὐτοῦ· ἐκ γὰρ τοῦ φρέατος ἐκείνου ἐπότιζον τὰ ποίμνια· λίθος δὲ ἦν μέγας ἐπὶ τῷ στόματι τοῦ φρέατος. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Καὶ συνήγοντο ἐκεῖ πάντα τὰ ποίμνια· καὶ ἀπεκύλιον τὸν λίθον ἀπὸ τοῦ στόματος τοῦ φρέατος, καὶ ἐπότιζον τὰ πρόβατα, καὶ ἀπεκαθίστων τὸν λίθον ἐπὶ τὸ στόμα τοῦ φρέατος εἰς τὸν τόπον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Εἶπε δὲ αὐτοῖς Ἰακὼβ, ἀδελφοὶ, πόθεν ἐστὲ ὑμεῖς; οἱ δὲ εἶπαν, ἐκ Χαῤῥὰν ἐσμέν. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Εἶπε δὲ αὐτοῖς, γινώσκετε Λάβαν τὸν υἱὸν Ναχώρ; οἱ δὲ εἶπαν, γινώσκομεν· ");
INSERT INTO grcbrent_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Εἶπε δὲ αὐτοῖς, ὑγιαίνει; οἱ δὲ εἶπαν, ὑγιαίνει· καὶ ἰδοὺ Ῥαχὴλ ἡ θυγάτηρ αὐτοῦ ἤρχετο μετὰ τῶν προβάτων. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Καὶ εἶπεν Ἰακὼβ, ἔτι ἐστὶν ἡμέρα πολλὴ· οὔπω ὥρα συναχθῆναι τὰ κτήνη· ποτίσαντες τὰ πρόβατα, ἀπελθόντες βόσκετε. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Οἱ δὲ εἶπαν, οὐ δυνησόμεθα, ἕως τοῦ συναχθῆναι πάντας τοὺς ποιμένας, καὶ ἀποκυλίσουσι τὸν λίθον ἀπὸ τοῦ στόματος τοῦ φρέατος, καὶ ποτιοῦμεν τὰ πρόβατα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ἔτι αὐτοῦ λαλοῦντος αὐτοῖς, καὶ ἰδοὺ Ῥαχὴλ ἡ θυγάτηρ Λάβαν ἤρχετο μετὰ τῶν προβάτων τοῦ πατρὸς αὐτῆς· αὐτὴ γὰρ ἔβοσκε τὰ πρόβατα τοῦ πατρὸς αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ἐγένετο δὲ ὡς εἶδεν Ἰακὼβ τὴν Ῥαχὴλ τὴν θυγατέρα Λάβαν, τοῦ ἀδελφοῦ τῆς μητρὸς αὐτοῦ, καὶ τὰ πρόβατα Λάβαν τοῦ ἀδελφοῦ τῆς μητρὸς αὐτοῦ, καὶ προσελθὼν Ἰακὼβ ἀπεκύλισε τὸν λίθον ἀπὸ τοῦ στόματος τοῦ φρέατος, καὶ ἐπότιζε τὰ πρόβατα Λάβαν τοῦ ἀδελφοῦ τῆς μητρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Καὶ ἐφίλησεν Ἰακὼβ τὴν Ῥαχὴλ, καὶ βοήσας τῇ φωνῇ αὐτοῦ ἔκλαυσε. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Καὶ ἀπήγγειλε τῇ Ῥαχὴλ, ὅτι ἀδελφὸς τοῦ πατρὸς αὐτῆς ἐστι, καὶ ὅτι υἱὸς Ῥεβέκκας ἐστί· καὶ δραμοῦσα ἀπήγγειλε τῷ πατρὶ αὐτῆς κατὰ τὰ ῥήματα ταῦτα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ἐγένετο δὲ ὡς ἤκουσε Λάβαν τὸ ὄνομα Ἰακὼβ τοῦ υἱοῦ τῆς ἀδελφῆς αὐτοῦ, ἔδραμεν εἰς συνάντησιν αὐτῷ, καὶ περιλαβὼν αὐτὸν ἐφίλησε, καὶ εἰσήγαγεν αὐτὸν εἰς τὸν οἶκον αὐτοῦ· καὶ διηγήσατο τῷ Λάβαν πάντας τοὺς λόγους τούτους. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Καὶ εἶπεν αὐτῷ Λάβαν, ἐκ τῶν ὀστῶν μου καὶ ἐκ τῆς σαρκός μου εἶ σύ· καὶ ἦν μετʼ αὐτοῦ μῆνα ἡμερῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Εἶπε δὲ Λάβαν τῷ Ἰακὼβ, ὅτι γὰρ ἀδελφός μου εἶ, οὐ δουλεύσεις μοι δωρεάν· ἀπάγγειλόν μοι τίς ὁ μισθός σου ἐστί; ");
INSERT INTO grcbrent_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Τῷ δὲ Λάβαν ἦσαν δύο θυγατέρες· ὄνομα τῇ μείζονι, Λεία, καὶ ὄνομα τῇ νεωτέρᾳ, Ῥαχήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Οἱ δὲ ὀφθάλμοὶ Λείας, ἀσθενεῖς· Ῥαχῆλ δὲ ἦν καλὴ τῷ εἴδει, καὶ ὡραία τῇ ὄψει σφάδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ἠγάπησε δὲ Ἰακὼβ τὴν Ῥαχήλ· καὶ εἶπε, δουλεύσω σοι ἑπτὰ ἔτη περὶ τῆς Ῥαχὴλ τῆς θυγατρός σου τῆς νεωτέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Εἶπε δὲ αὐτῷ Λάβαν, βέλτιον δοῦναί με αὐτήν σοι, ἢ δοῦναί με αὐτὴν ἀνδρὶ ἑτέρῳ· οἴκησον μετʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Καὶ ἐδούλευσεν Ἰακὼβ περὶ Ῥαχὴλ ἑπτὰ ἔτη· καὶ ἤσαν ἐναντίον αὐτοῦ ὡς ἡμέραι ὀλίγαι, παρὰ τὸ ἀγαπᾷν αὐτὸν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Εἶπε δὲ Ἰακὼβ τῷ Λάβαν, δός μοι τὴν γυναῖκά μου, πεπλήρωνται γὰρ αἱ ἡμέραι ὅπως εἰσέλθω πρὸς αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Συνήγαγε δὲ Λάβαν πάντας τοὺς ἄνδρας τοῦ τόπου, καὶ ἐποίησε γάμον. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Καὶ ἐγένετο ἑσπέρα, καὶ λαβὼν Λείαν τὴν θυγατέρα αὐτοῦ, εἰσήγαγεν πρὸς Ἰακὼβ, καὶ εἰσῆλθε πρὸς αὐτὴν Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ἔδωκε δὲ Λάβαν Λείᾳ τῇ θυγατρὶ αὐτοῦ Ζελφὰν τὴν παιδίσκην αὐτοῦ, αὐτῇ παιδίσκην. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ἐγένετο δὲ πρωῒ, καὶ ἰδοὺ ἦν Λεία· εἶπε δὲ Ἰακὼβ τῷ Λάβαν, τί τοῦτο ἐποίησάς μοι; οὐ περὶ Ῥαχὴλ ἐδούλευσα παρὰ σοι; καὶ ἱνατί παρελογίσω με; ");
INSERT INTO grcbrent_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ἀπεκρίθη δὲ Λάβαν, οὐκ ἔστιν οὕτως ἐν τῷ τόπῳ ἡμῶν, δοῦναι τὴν νεωτέραν πρινὴ τὴν πρεσβυτέραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Συντέλεσον οὖν τὰ ἕβδομα ταύτης, καὶ δώσω σοι καὶ ταύτην ἀντὶ τῆς ἐργασίας, ἧς ἐργᾷ παρʼ ἐμοὶ ἔτι ἑπτὰ ἔτη ἕτερα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ἐποίησε δὲ Ἰακὼβ οὕτως, καὶ ἀνεπλήρωσε τὰ ἕβδομα ταύτης· καὶ ἔδωκεν αὐτῷ Λάβαν Ῥαχὴλ τὴν θυγατέρα αὐτοῦ αὐτῷ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ἔδωκε δὲ Λάβαν τῇ θυγατρὶ αὐτοῦ Βαλλὰν τὴν παιδίσκην αὐτοῦ, αὐτῇ παιδίσκην. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Καὶ εἰσῆλθε πρὸς Ῥαχήλ· ἠγάπησε δὲ Ῥαχὴλ μᾶλλον ἢ Λείαν· καὶ ἐδούλευσεν αὐτῷ ἑπτὰ ἔτη ἕτερα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ἰδὼν δὲ Κύριος ὁ Θεὸς ὅτι ἐμισεῖτο Λεία, ἤνοιξε τὴν μήτραν αὐτῆς· Ῥαχὴλ δὲ ἦν στεῖρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Καὶ συνέλαβε Λεία, καὶ ἔτεκεν υἱὸν τῷ Ἰακώβ· ἐκάλεσε δὲ τὸ ὄνομα αὐτοῦ Ῥουβὴν, λέγουσα, διότι εἶδέ μου Κύριος τὴν ταπείνωσιν, καὶ ἔδωκέ μοι υἱόν· νῦν οὖν ἀγαπήσει με ὁ ἀνήρ μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Καὶ συνέλαβε πάλιν, καὶ ἔτεκεν υἱὸν δεύτερον τῷ Ἰακὼβ, καὶ εἶπεν, ὅτι ἤκουσε Κύριος ὅτι μισοῦμαι, καὶ προσέδωκέ μοι καὶ τοῦτον· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Συμεών. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Καὶ συνέλαβεν ἔτι, καὶ ἔτεκεν υἱὸν, καὶ εἶπεν, ἐν τῷ νῦν καιρῷ πρὸς ἐμοῦ ἔσται ὁ ἀνήρ μου, τέτοκα γὰρ αὐτῷ τρεῖς υἱούς· διὰ τοῦτο ἐκάλεσε τὸ ὄνομα αὐτοῦ, Λευεί. ");
INSERT INTO grcbrent_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Καὶ συλλαβοῦσα ἔτι ἔτεκεν υἱὸν, καὶ εἶπε, νῦν ἔτι τοῦτο ἐξομολογήσομαι Κυρίῳ· διὰ τοῦτο ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ἰούδαν· καὶ ἔστη τοῦ τίκτειν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ἰδοῦσα δὲ Ῥαχὴλ, ὅτι οὐ τέτοκε τῷ Ἱακώβ· καὶ ἐζήλωσε Ῥαχὴλ τὴν ἀδελφὴν αὐτῆς· καὶ εἶπε τῷ Ἰακὼβ, δός μοι τέκνα· εἰ δὲ μὴ, τελευτήσω ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Θυμωθεὶς δὲ Ἰακὼβ τῇ Ῥαχὴλ εἶπεν αὐτῇ, μὴ ἀντὶ Θεοῦ ἐγώ εἰμι, ὃς ἐστέρησέ σε καρπὸν κοιλίας; ");
INSERT INTO grcbrent_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Εἶπε δὲ Ῥαχὴλ τῷ Ἰακὼβ, ἰδοὺ ἡ παιδίσκη μου Βαλλά· εἴσελθε πρὸς αὐτήν· καὶ τέξεται ἐπὶ τῶν γονάτων μου, καὶ τεκνοποιήσομαι κᾀγὼ ἐξ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Καὶ ἔδωκεν αὐτῷ Βαλλὰν τὴν παιδίσκην αὐτῆς, αὐτῷ γυναῖκα· καὶ εἰσῆλθε πρὸς αὐτὴν Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Καὶ συνέλαβε Βαλλὰ ἡ παιδίσκη Ῥαχὴλ, καὶ ἔτεκε τῷ Ἰακὼβ υἱόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Καὶ εἶπε Ῥαχὴλ, ἔκρινέ μοι ὁ Θεὸς, καὶ ἐπήκουσε τῆς φωνῆς μου, καὶ ἔδωκε μοι υἱόν· διὰ τοῦτο ἐκάλεσε τὸ ὄνομα αὐτοῦ, Δάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Καὶ συνέλαβεν ἔτι Βαλλὰ ἡ παιδίσκη Ῥαχὴλ, καὶ ἔτεκεν υἱὸν δεύτερον τῷ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Καὶ εἶπε Ῥαχὴλ, συναντελάβετό μου ὁ Θεὸς, καὶ συνανεστράφην τῇ ἀδελφῇ μου, καὶ ἠδυνάσθην· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Νεφθαλεί. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Εἶδε δὲ Λεία ὅτι ἔστη τοῦ τίκτειν· καὶ ἔλαβε Ζελφὰν τὴν παιδίσκην αὐτῆς, καὶ ἔδωκεν αὐτὴν τῷ Ἰακὼβ γυναῖκα· καὶ εἰσῆλθε πρὸς αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Καὶ συνέλαβε Ζελφὰ ἡ παιδίσκη Λείας, καὶ ἔτεκε τῷ Ἰακὼβ υἱόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Καὶ εἶπε Λεία, ἐν τύχῃ· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ, Γάδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Καὶ συνέλαβεν ἔτι Ζελφὰ ἡ παιδίσκη Λείας, καὶ ἔτεκε τῷ Ἰακὼβ υἱὸν δεύτερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Καὶ εἶπε Λεία, μακαρία ἐγὼ, ὅτι μακαριοῦσί με αἱ γυναῖκες· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ἀσήρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ἐπορεύθη δὲ Ῥουβὴν ἐν ἡμέρᾳ θερισμοῦ πυρῶν, καὶ εὗρε μῆλα μανδραγορῶν ἐν τῷ ἀγρῷ, καὶ ἤνεγκεν αὐτὰ πρὸς Λείαν τὴν μητέρα αὐτοῦ· εἶπε δὲ Ῥαχὴλ τῇ Λείᾳ τῇ ἀδελφῇ αὐτῆς, δός μοι τῶν μανδραγορῶν τοῦ υἱοῦ σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Εἶπε δὲ Λεία, οὐχ ἱκανόν σοι ὅτι ἔλαβες τὸν ἄνδρα μου; μὴ καὶ τοὺς μανδραγόρας τοῦ υἱοῦ μου λήψῃ; εἶπε δὲ Ῥαχὴλ, οὐχ οὕτως· κοιμηθήτω μετὰ σοῦ τὴν νύκτα ταύτην ἀντὶ τῶν μανδραγορῶν τοῦ υἱοῦ σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Εἰσῆλθεν δὲ Ἰακὼβ ἐξ ἀγροῦ ἑσπέρας· καὶ ἐξῆλθε Λεία εἰς συνάντησιν αὐτῷ, καὶ εἶπε, πρὸς ἐμὲ εἰσελεύσῃ σήμερον· μεμίσθωμαι γάρ σε ἀντὶ τῶν μανδραγορῶν τοῦ υἱοῦ μου· καὶ ἐκοιμήθη μετʼ αὐτῆς τὴν νύκτα ἐκείνην. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Καὶ ἐπήκουσεν ὁ Θεὸς Λείας· καὶ συλλαβοῦσα ἔτεκε τῷ Ἰακὼβ υἱὸν πέμπτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Καὶ εἶπε Λεία, δέδωκέ μοι ὁ Θεὸς τὸν μισθόν μου, ἀνθʼ οὗ ἔδωκα τὴν παιδίσκην μου τῷ ἀνδρί μου· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ἰσσάχαρ, ὅ ἐστι μισθός. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Καὶ συνέλαβεν ἔτι Λεία, καὶ ἔτεκεν υἱὸν ἕκτον τῷ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Καὶ εἶπε Λεία, δεδώρηται ὁ Θεός μοι δῶρον καλὸν ἐν τῷ νῦν καιρῷ· αἱρετιεῖ με ὁ ἀνήρ μου, τέτοκα γὰρ αὐτῷ υἱοὺς ἕξ· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ζαβουλών. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Καὶ μετὰ τοῦτο ἔτεκε θυγατέρα, καὶ ἐκάλεσε τὸ ὄνομα αὐτῆς, Δεῖνα. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ἐμνήσθη δὲ ὁ Θεὸς τῆς Ῥαχὴλ, καὶ ἔπήκουσεν αὐτῆς ὁ Θεός· καὶ ἀνέῳξεν αὐτῆς τὴν μήτραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Καὶ συλλαβοῦσα ἔτεκε τῷ Ἰακὼβ υἱόν· εἶπε δὲ Ῥαχὴλ, ἀφεῖλεν ὁ Θεός μου τὸ ὄνειδος. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ Ἰωσὴφ, λέγουσα, προσθέτω ὁ Θεός μοι υἱὸν ἕτερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ἐγένετο δὲ ὡς ἔτεκε Ῥαχὴλ τὸν Ἰωσὴφ, εἶπεν Ἰακὼβ τῷ Λάβαν, ἀπόστειλόν με, ἵνα ἀπέλθω εἰς τὸν τόπον μου, καὶ εἰς τὴν γῆν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ἀπόδος τὰς γυναῖκας μου, καὶ τὰ παιδία μου, περὶ ὧν δεδούλευκά σοι, ἵνα ἀπέλθω· σὺ γὰρ γινώσκεις τὴν δουλείαν, ἣν δεδούλευκά σοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Εἶπε δὲ αὐτῷ Λάβαν, εἰ εὗρον χάριν ἐναντίον σου, οἰωνισάμην ἄν· εὐλόγησε γάρ με ὁ Θεὸς ἐπὶ τῇ σῇ εἰσόδῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Διάστειλον τὸν μισθόν σου πρός με, καὶ δώσω. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Εἶπε δὲ Ἰακὼβ, σὺ γινώσκεις ἃ δεδούλευκά σοι, καὶ ὅσα ἦν κτήνη σου μετʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Μικρὰ γὰρ ἦν ὅσα σοι ἐναντίον ἐμοῦ, καὶ ηὐξήθη εἰς πλῆθος· καὶ εὐλόγησέ σε Κύριος ὁ Θεὸς ἐπὶ τῷ ποδί μου· νῦν οὖν πότε ποιήσω κᾀγὼ ἐμαυτῷ οἶκον; ");
INSERT INTO grcbrent_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Καὶ εἶπεν αὐτῷ Λάβαν, τί σοι δώσω; Εἶπε δὲ αὐτῷ Ἰακὼβ, οὐ δώσεις μοι οὐθὲν, ἐὰν ποιήσῃς μοι τὸ ῥῆμα τοῦτο, πάλιν ποιμανῶ τὰ πρόβατά σου, καὶ φυλάξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Παρελθέτω πάντα τὰ πρόβατά σου σήμερον, καὶ διαχώρισον ἐκεῖθεν πᾶν πρόβατον φαιὸν ἐν τοῖς ἄρνασι, καὶ πᾶν διάλευκον καὶ ῥαντὸν ἐν ταῖς αἰξὶν, ἔσται μοι μισθός. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Καὶ ἐπακούσεταί μοι ἡ δικαιοσύνη μου ἐν τῇ ἡμέρᾳ τῇ ἐπαύριον, ὅτι ἐστὶν ὁ μισθός μου ἐνώπιόν σου· πᾶν ὃ ἐὰν μὴ ᾖ ῥαντὸν καὶ διάλευκον ἐν ταῖς αἰξὶ, καὶ φαιὸν ἐν τοῖς ἄρνασι, κεκλεμμένον ἔσται παρʼ ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Εἶπε δὲ αὐτῷ Λάβαν, ἔστω κατὰ τὸ ῥῆμά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Καὶ διέστειλεν ἐν τῇ ἡμέρᾳ ἐκείνῃ τοὺς τράγους τοὺς ῥαντοὺς καὶ τοὺς διαλεύκους, καὶ πάσας τὰς αἶγας τὰς ῥαντὰς καὶ τὰς διαλεύκους, καὶ πᾶν ὃ ἦν φαιὸν ἐν τοῖς ἄρνασι, καὶ πᾶν ὃ ἦν λευκὸν ἐν αὐτοῖς, καὶ ἔδωκε διὰ χειρὸς τῶν υἱῶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Καὶ ἀπέστησεν ὁδὸν τριῶν ἡμερῶν, καὶ ἀνὰ μέσον αὐτῶν καὶ ἀνὰ μέσον Ἰακώβ· Ἰακὼβ δὲ ἐποίμαινε τὰ πρόβατα Λάβαν τὰ ὑπολειφθέντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ἔλαβε δὲ ἑαυτῷ Ἰακὼβ ῥάβδον στυρακίνην χλωρὰν καὶ καρυΐνην καὶ πλατάνου· καὶ ἐλέπισεν αὐτὰς Ἰακὼβ λεπίσματα λευκά· καὶ περισύρων τὸ χλωρὸν, ἐφαίνετο ἐπὶ ταῖς ῥάβδοις τὸ λευκὸν, ὃ ἐλέπισε, ποικίλον. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Καὶ παρέθηκε τὰς ῥάβδους, ἃς ἐλέπισεν, ἐν τοῖς ληνοῖς τῶν ποτιστηρίων τοῦ ὕδατος, ἵνα ὡς ἂν ἔλθωσι τὰ πρόβατα πιεῖν, ἐνώπιον τῶν ῥάβδων ἐλθόντων αὐτῶν εἰς τὸ πιεῖν, ἐγκισσήσωσι τὰ πρόβατα εἰς τὰς ῥάβδους. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Καὶ ἐνεκίσσων τὰ πρόβατα εἰς τὰς ῥάβδους· καὶ ἔτικτον τὰ πρόβατα διάλευκα καὶ ποικίλα καὶ σποδοειδῆ ῥαντά. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Τοὺς δὲ ἀμνοὺς διέστειλεν Ἰακὼβ, καὶ ἔστησεν ἐναντίον τῶν προβάτων κριὸν διάλευκον, καὶ πᾶν ποικίλον ἐν τοῖς ἀμνοῖς· καὶ διεχώρισεν ἑαυτῷ ποίμνια καθʼ ἑαυτὸν, καὶ οὐκ ἔμιξεν αὐτὰ εἰς τὰ πρόβατα Λάβαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ἐγένετο δὲ ἐν τῷ καιρῷ ᾧ ἐνεκίσσων τὰ πρόβατα ἐν γαστρὶ λαμβάνοντα, ἔθηκεν Ἰακὼβ τὰς ῥάβδους ἐναντίον τῶν προβάτων ἐν τοῖς ληνοῖς, τοῦ ἐγκισσῆσαι αὐτὰ κατὰ τὰς ῥάβδους. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ἡνίκα δʼ ἂν ἔτεκε τὰ πρόβατα, οὐκ ἐτίθει· ἐγένετο δὲ τὰ μὲν ἄσημα τοῦ Λάβαν, τὰ δὲ ἐπίσημα τοῦ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Καὶ ἐπλούτησεν ὁ ἄνθρωπος σφόδρα σφόδρα· καὶ ἐγένετο αὐτῷ κτήνη πολλὰ, καὶ βόες, καὶ παῖδες, καὶ παιδίσκαι, καὶ κάμηλοι, καὶ ὄνοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ἤκουσε δὲ Ἰακὼβ τὰ ῥήματα τῶν υἱῶν Λάβαν, λεγόντων, εἴληφεν Ἰακὼβ πάντα τὰ τοῦ πατρὸς ἡμῶν, καὶ ἐκ τῶν τοῦ πατρὸς ἡμῶν πεποίηκε πᾶσαν τὴν δόξαν ταύτην. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Καὶ εἶδεν Ἰακὼβ τὸ πρόσωπον τοῦ Λάβαν, καὶ ἰδοὺ οὐκ ἦν πρὸς αὐτὸν ὡσεὶ χθὲς καὶ τρίτην ἡμέραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Εἶπε δὲ Κύριος πρὸς Ἰακὼβ, ἀποστρέφου εἰς τὴν γῆν τοῦ πατρός σου, καὶ εἰς τὴν γενεάν σου, καὶ ἔσομαι μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ἀποστείλας δὲ Ἰακὼβ ἐκάλεσε Λείαν καὶ Ῥαχὴλ εἰς τὸ πεδίον, οὗ ἦν τὰ ποίμνια. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Καὶ εἶπεν αὐταῖς, ὁρῶ ἐγὼ τὸ πρόσωπον τοῦ πατρὸς ὑμῶν, ὅτι οὐκ ἔστι πρὸς ἐμοῦ, ὡς ἐχθὲς καὶ τρίτην ἡμέραν· ὁ δὲ Θεὸς τοῦ πατρός μου ἦν μετʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Καὶ αὐταὶ δὲ οἴδατε, ὅτι ἐν πάσῃ τῇ ἰσχύϊ μου δεδούλευκα τῷ πατρὶ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ὁ δὲ πατὴρ ὑμῶν παρεκρούσατό με, καὶ ἤλλαξε τὸν μισθόν μου τῶν δέκα ἀμνῶν· καὶ οὐκ ἔδωκεν αὐτῷ ὁ Θεὸς κακοποιῆσαί με. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ἐὰν οὕτως εἴπῃ, τὰ ποικίλα ἔσται σου μισθὸς, καὶ τέξεται πάντα τὰ πρόβατα ποικίλα· ἐὰν δὲ εἴπῃ, τὰ λευκὰ ἔσται σου μισθὸς, καὶ τέξεται πάντα τὰ πρόβατα λευκά. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Καὶ ἀφείλετο ὁ Θεὸς πάντα τὰ κτήνη τοῦ πατρὸς ὑμῶν, καὶ ἔδωκέ μοι αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Καὶ ἐγένετο ἡνίκα ἐνεκίσσων τὰ πρόβατα ἐν γαστρὶ λαμβάνοντα, καὶ εἶδον τοῖς ὀφθαλμοῖς μου ἐν τῷ ὕπνῳ· καὶ ἰδοὺ οἱ τράγοι καὶ οἱ κριοὶ ἀναβαίνοντες ἐπὶ τὰ πρόβατα καὶ τὰς αἶγας, διάλευκοι καὶ ποικίλοι καὶ σποδοειδεῖς ῥαντοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Καὶ εἶπέ μοι ὁ Ἄγγελος τοῦ Θεοῦ καθʼ ὕπνον, Ἰακώβ· ἐγὼ δὲ εἶπα, τί ἐστι; ");
INSERT INTO grcbrent_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Καὶ εἶπεν, ἀνάβλεψον τοῖς ὀφθαλμοῖς σου, καὶ ἴδε τοὺς τράγους καὶ τοὺς κριοὺς ἀναβαίνοντας ἐπὶ τὰ πρόβατα καὶ τὰς αἶγας διαλεύκους καὶ ποικίλους καὶ σποδοειδεῖς ῥαντούς· ἑώρακα γὰρ ὅσα σοι Λάβαν ποιεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ἐγώ εἰμι ὁ Θεὸς ὁ ὀφθείς σοι ἐν τόπῳ Θεοῦ, οὗ ἤλειψάς μοι ἐκεῖ στήλην, καὶ ηὔξω μοι ἐκεῖ εὐχήν· νῦν οὖν ἀνάστηθι, καὶ ἔξελθε ἐκ τῆς γῆς ταύτης, καὶ ἄπελθε εἰς τὴν γῆν τῆς γενέσεώς σου, καὶ ἔσομαι μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Καὶ ἀποκριθεῖσαι Ῥαχὴλ καὶ Λεία εἶπαν αὐτῷ, μὴ ἔστιν ἡμῖν ἔτι μερὶς ἢ κληρονομία ἐν τῷ οἴκῳ τοῦ πατρὸς ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Οὐχ ὡς αἱ ἀλλότριαι λελογίσμεθα αὐτῷ; πέπρακε γὰρ ἡμᾶς, καὶ καταβρώσει κατέφαγε τὸ ἀργύριον ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Πάντα τὸν πλοῦτον καὶ τὴν δόξαν, ἣν ἀφείλετο ὁ Θεὸς τοῦ πατρὸς ἡμῶν, ἡμῖν ἔσται καὶ τοῖς τέκνοις ἡμῶν· νῦν οὖν ὅσα σοι εἴρηκεν ὁ Θεὸς, ποίει. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ἀναστὰς δὲ Ἰακὼβ ἔλαβε τὰς γυναῖκας αὐτοῦ καὶ τὰ παιδία αὐτοῦ ἐπὶ τὰς καμήλους· ");
INSERT INTO grcbrent_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Καὶ ἀπήγαγε πάντα τὰ ὑπάρχοντα αὐτῷ, καὶ πᾶσαν τὴν ἀποσκευὴν αὐτοῦ, ἣν περιεποιήσατο ἐν τῇ Μεσοποταμίᾳ, καὶ πάντα τὰ αὐτοῦ, ἀπελθεῖν πρὸς Ἰσαὰκ τὸν πατέρα αὐτοῦ εἰς γῆν Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Λάβαν δὲ ᾤχετο κεῖραι τὰ πρόβατα αὐτοῦ· ἔκλεψε δὲ Ῥαχὴλ τὰ εἴδωλα τοῦ πατρὸς αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ἔκρυψε δὲ Ἰακὼβ Λάβαν τὸν Σύρον, τοῦ μὴ ἀναγγεῖλαι αὐτῷ, ὅτι ἀποδιδράσκει. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Καὶ ἀπέδρα αὐτὸς, καὶ τὰ αὐτοῦ πάντα, καὶ διέβη τὸν ποταμὸν, καὶ ὥρμησεν εἰς τὸ ὄρος Γαλαάδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ἀνηγγέλη δὲ Λάβαν τῷ Σύρῳ τῇ ἡμέρᾳ τῇ τρίτῃ, ὅτι ἀπέδρα Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Καὶ παραλαβὼν τοὺς ἀδελφοὺς αὐτοῦ μεθʼ ἑαντοῦ, ἐδίωξεν ὀπίσω αὐτοῦ ὁδὸν ἡμερῶν ἑπτά· καὶ κατέλαβεν αὐτὸν ἐν τῷ ὄρει Γαλαάδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ἦλθε δὲ ὁ Θεὸς πρὸς Λάβαν τὸν Σύρον καθʼ ὕπνον τὴν νύκτα, καὶ εἶπεν αὐτῷ, Φύλαξαι σεαυτὸν μή ποτε λαλήσῃς μετὰ Ἰακὼβ πονηρά. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Καὶ κατέλαβε Λάβαν τὸν Ἰακώβ· Ἰακὼβ δὲ ἔπηξεν τὴν σκηνὴν αὐτοῦ ἐν τῷ ὄρει· Λάβαν δὲ ἔστησε τοὺς ἀδελφοὺς αὐτοῦ ἐν τῷ ὄρει Γαλαάδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Εἶπε δὲ Λάβαν τῷ Ἰακὼβ, τί ἐποίησας; ἱνατί κρυφῇ ἀπέδρας, καὶ ἐκλοποφόρησάς με, καὶ ἀπήγαγες τὰς θυγατέρας μου, ὡς αἰχμαλώτιδας μαχαίρᾳ; ");
INSERT INTO grcbrent_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Καὶ εἰ ἀνήγγειλάς μοι, ἐξαπέστειλα ἄν σε μετʼ εὐφροσύνης, καὶ μετὰ μουσικῶν, καὶ τυμπάνων, καὶ κιθάρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Καὶ οὐκ ἠξιώθην καταφιλῆσαι τὰ παιδία μου, καὶ τὰς θυγατέρας μου· νῦν δὲ ἀφρόνως ἔπραξας. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Καὶ νῦν ἰσχύει ἡ χείρ μου κακοποιῆσαί σε· ὁ δὲ Θεὸς τοῦ πατρός σου χθὲς εἶπε πρός με, λέγων, Φύλαξαι σεαυτὸν μή ποτε λαλήσῃς μετὰ Ἰακὼβ πονηρά. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Νῦν οὖν πεπόρευσαι· ἐπιθυμίᾳ γὰρ ἐπεθύμησας ἀπελθεῖν εἰς τὸν οἶκον τοῦ πατρός σου· ἱνατί ἔκλεψας τοὺς θεούς μου; ");
INSERT INTO grcbrent_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ἀποκριθεὶς δὲ Ἰακὼβ εἶπε τῷ Λάβαν, ὅτι ἐφοβήθην· εἶπα γὰρ, μή ποτε ἀφέλῃ τὰς θυγατέρας σου ἀπʼ ἐμοῦ, καὶ πάντα τὰ ἐμά. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Καὶ εἶπεν Ἰακὼβ, παρʼ ᾧ ἂν εὕρῃς τοὺς θεούς σου, οὐ ζήσεται ἐναντίον τῶν ἀδελφῶν ἡμῶν· ἐπίγνωθι τί ἐστι παρʼ ἐμοὶ τῶν σῶν, καὶ λάβε· καὶ οὐκ ἐπέγνω παρʼ αὐτῷ οὐθέν· οὐκ ᾔδει δὲ Ἰακὼβ, ὅτι Ῥαχὴλ ἡ γυνὴ αὐτοῦ ἔκλεψεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Εἰσελθὼν δὲ Λάβαν ἠρεύνησεν εἰς τὸν οἶκον Λείας, καὶ οὐχ εὗρεν· καὶ ἐξῆλθεν ἐκ τοῦ οἴκου Λείας, καὶ ἠρεύνησε τὸν οἶκον Ἰακὼβ, καὶ ἐν τῷ οἴκῳ τῶν δύο παιδισκῶν, καὶ οὐχ εὗρεν· εἰσῆλθε δὲ καὶ εἰς τὸν οἶκον Ῥαχήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ῥαχὴλ δὲ ἔλαβε τὰ εἴδωλα, καὶ ἐνέβαλεν αὐτὰ εἰς τὰ σάγματα τῆς καμήλου, καὶ ἐπεκάθισεν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Καὶ εἶπε τῷ πατρὶ αὐτῆς, μὴ βαρέως φέρε, κύριε· οὐ δυνάμαι ἀναστῆναι ἐνώπιόν σου, ὅτι τὰ κατʼ ἐθισμὸν τῶν γυναικῶν μοι ἐστίν· ἠρεύνησε Λάβαν ἐν ὅλῳ τῷ οἴκῳ, καὶ οὐχ εὗρε τὰ εἴδωλα. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ὠργίσθη δὲ Ἰακὼβ, καὶ ἐμαχέσατο τῷ Λάβαν· ἀποκριθεὶς δὲ Ἰακὼβ εἶπε τῷ Λάβαν, τί τὸ ἀδίκημά μου; καὶ τί τὸ ἁμάρτημά μου, ὅτι κατεδίωξας ὀπίσω μου, ");
INSERT INTO grcbrent_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","καὶ ὅτι ἠρεύνησας πάντα τὰ σκεύη τοῦ οἴκου μου; τί εὗρες ἀπὸ πάντων τῶν σκευῶν τοῦ οἴκου σου; θὲς ὧδε ἐνώπιον τῶν ἀδελφῶν σου καὶ τῶν ἀδελφῶν μου, καὶ ἐλεγξάτωσαν ἀνὰ μέσον τῶν δύο ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ταῦτά μοι εἴκοσι ἔτη ἐγώ εἰμι μετὰ σοῦ· τὰ πρόβατά σου καὶ αἱ αἶγές σου οὐκ ἠτεκνώθησαν· κριοὺς τῶν προβάτων σου οὐ κατέφαγον. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Θηριάλωτον οὐκ ἐνήνοχά σοι· ἐγὼ ἀπετίννυον παρʼ ἐμαυτοῦ κλέμματα ἡμέρας, καὶ κλέμματα νυκτός. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ἐγενόμην τῆς ἡμέρας συγκαιόμενος τῷ καύματι, καὶ τῷ παγετῷ τῆς νυκτός· καὶ ἀφίστατο ὁ ὕπνος μου ἀπὸ τῶν ὀφθαλμῶν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ταῦτά μοι εἴκοσι ἔτη ἐγώ εἰμι ἐν τῇ οἰκίᾳ σου· ἐδούλευσά σοι δεκατέσσαρα ἔτη ἀντὶ τῶν δύο θυγατέρων σου, καὶ ἓξ ἔτη ἐν τοῖς προβάτοις σου, καὶ παρελογίσω τὸν μισθόν μου δέκα ἀμνάσιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Εἰ μὴ ὁ Θεὸς τοῦ πατρός μου Ἁβραὰμ, καὶ ὁ φόβος Ἰσαὰκ, ἦν μοι, νῦν ἂν κενόν με ἐξαπέστειλας· τὴν ταπείνωσίν μου, καὶ τὸν κόπον τῶν χειρῶν μου, εἶδεν ὁ Θεός· καὶ ἤλεγξέ σε χθές. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ἀποκριθεὶς δὲ Λάβαν εἶπε τῷ Ἰακὼβ, αἱ θυγατέρες, θυγατέρες μου, καὶ υἱοὶ, υἱοί μου, καὶ τὰ κτήνη, κτήνη μου· καὶ πάντα ὅσα σὺ ὁρᾷς, ἐμά ἐστι, καὶ τῶν θυγατέρων μου· τί ποιήσω ταύταις σήμερον ἢ τοῖς τέκνοις αὐτῶν, οἷς ἔτεκον; ");
INSERT INTO grcbrent_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Νῦν οὖν δεῦρο διαθῶμαι διαθήκην ἐγώ τε καὶ σύ· καὶ ἔσται εἰς μαρτύριον ἀνὰ μέσον ἐμοῦ καὶ σοῦ· εἶπε δὲ αὐτῷ, ἰδοὺ οὐθεὶς μεθʼ ἡμῶν ἐστιν· ἴδε ὁ Θεὸς μάρτυς ἀνὰ μέσον ἐμοῦ καὶ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Λαβὼν δὲ Ἰακὼβ λίθον, ἔστησεν αὐτὸν στήλην. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Εἶπε δὲ Ἰακὼβ τοῖς ἀδελφοῖς αὐτοῦ, συλλέγετε λίθους· καὶ συνέλεξαν λίθους, καὶ ἐποίησαν βουνόν· καὶ ἔφαγον ἐκεῖ ἐπὶ τοῦ βουνοῦ· καὶ εἶπεν αὐτῷ Λάβαν, ὁ βουνὸς οὗτος μαρτυρεῖ ἀνὰ μέσον ἐμοῦ καὶ σοῦ σήμερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Καὶ ἐκάλεσεν αὐτὸν Λάβαν, βουνὸς τῆς μαρτυρίας· Ἰακὼβ δὲ ἐκάλεσεν αὐτὸν, βουνὸς μάρτυς. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Εἶπε δὲ Λάβαν τῷ Ἰακὼβ, ἰδοὺ ὁ βουνὸς οὗτος καὶ ἡ στήλη, ἣν ἔστησα ἀνὰ μέσον ἐμοῦ καὶ σοῦ· μαρτυρεῖ ὁ βουνὸς οὗτος, καὶ μαρτυρεῖ ἡ στήλη αὕτη· διὰ τοῦτο ἐκλήθη τὸ ὄνομα, βουνὸς μαρτυρεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Καὶ ἡ ὅρασις, ἣν εἶπεν, ἐπίδοι ὁ Θεὸς ἀνὰ μέσον ἐμοῦ καὶ σοῦ· ὅτι ἀποστησόμεθα ἕτερος ἀφʼ ἑτέρου. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Εἰ ταπεινώσεις τὰς θυγατέρας μου, εἰ λάβῃς γυναῖκας πρὸς ταῖς θυγατράσι μου, ὅρα, οὐθεὶς μεθʼ ἡμῶν ἐστιν ὁρῶν· Θεὸς μάρτυς μεταξὺ ἐμοῦ καὶ μεταξὺ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_50a","002_31_50a","GEN","31","50a","50a","Καὶ εἶπε Λάβαν τῷ Ἰακὼβ, ἰδοὺ ὁ βουνὸς οὗτος καὶ μάρτυς ἡ στήλη αὕτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ἐάν τε γὰρ ἐγὼ μὴ διαβῶ πρός σε, μήτε σὺ διαβῇς πρός με τὸν βουνὸν τοῦτον καὶ τὴν στήλην ταύτην ἐπὶ κακίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ὁ Θεὸς Ἁβραὰμ καὶ ὁ Θεὸς Ναχὼρ κρίναι ἀνὰ μέσον ἡμῶν· καὶ ὤμοσεν Ἰακὼβ κατὰ τοῦ φόβου τοῦ πατρὸς αὐτοῦ Ἰσαάκ. ");
INSERT INTO grcbrent_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Καὶ ἔθυσεν θυσίαν ἐν τῷ ὄρει· καὶ ἐκάλεσε τοὺς ἀδελφοὺς αὐτοῦ, καὶ ἔφαγον καὶ ἔπιον, καὶ ἐκοιμήθησαν ἐν τῷ ὄρει. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ἀναστὰς δὲ Λάβαν τὸ πρωῒ, κατεφίλησε τοὺς υἱοὺς καὶ τὰς θυγατέρας αὐτοῦ, καὶ εὐλόγησεν αὐτούς· καὶ ἀποστραφεὶς Λάβαν ἀπῆλθεν εἰς τὸν τόπον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Καὶ Ἰακὼβ ἀπῆλθεν εἰς τὴν ὁδὸν ἑαυτοῦ· καὶ ἀναβλέψας εἶδε παρεμβολὴν Θεοῦ παρεμβεβληκυῖαν· καὶ συνήντησαν αὐτῷ οἱ Ἄγγελοι τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Εἶπε δὲ Ἰακὼβ, ἡνίκα εἶδεν αὐτοὺς, παρεμβολὴ Θεοῦ αὕτη· καὶ ἐκάλεσε τὸ ὄνομα τοῦ τόπου ἐκείνου, Παρεμβολαί. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ἀπέστειλε δὲ Ἰακὼβ ἀγγέλους ἔμπροσθεν αὐτοῦ πρὸς Ἡσαῦ τὸν ἀδελφὸν αὐτοῦ εἰς γῆν Σηεὶρ, εἰς χώραν Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Καὶ ἐνετείλατο αὐτοῖς, λέγων, οὕτως ἐρεῖτε τῷ κυρίῳ μου Ἡσαῦ· οὕτως λέγει ὁ παῖς σου Ἰακώβ· μετὰ Λάβαν παρῴκησα, καὶ ἐχρόνισα ἕως τοῦ νῦν. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Καὶ ἐγένοντό μοι βόες, καὶ ὄνοι, καὶ πρόβατα, καὶ παῖδες, καὶ παιδίσκαι· καὶ ἀπέστειλα ἀναγγεῖλαι τῷ κυρίῳ μου Ἡσαῦ, ἵνα εὕρῃ ὁ παῖς σου χάριν ἐναντίον σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Καὶ ἀνέστρεψαν οἱ ἄγγελοι πρὸς Ἰακὼβ, λέγοντες, ἤλθομεν πρὸς τὸν ἀδελφόν σου Ἡσαυ· καὶ ἰδοὺ αὐτὸς ἔρχεται εἰς συνάντησίν σου, καὶ τετρακόσιοι ἄνδρες μεθʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ἐφοβήθη δὲ Ἰακὼβ σφόδρα, καὶ ἠπορεῖτο· καὶ διεῖλε τὸν λαὸν τὸν μεθʼ ἑαυτοῦ, καὶ τοὺς βόας, καὶ τὰς καμήλους, καὶ τὰ πρόβατα, εἰς δύο παρεμβολάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Καὶ εἶπεν Ἰακὼβ, ἐὰν ἔλθῃ Ἡσαῦ εἰς παρεμβολὴν μίαν, καὶ κόψῃ αὐτὴν, ἔσται ἡ παρεμβολὴ ἡ δευτέρα εἰς τὸ σώζεσθαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Εἶπε δὲ Ἰακὼβ, ὁ Θεὸς τοῦ πατρός μου Ἁβραὰμ, καὶ ὁ Θεὸς τοῦ πατρός μου Ἰσαὰκ, Κύριε σὺ ὁ εἰπών μοι, ἀπότρεχε εἰς τὴν γῆν τῆς γενέσεώς σου, καὶ εὖ σε ποιήσω· ");
INSERT INTO grcbrent_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ἱκανούσθω μοι ἀπὸ πάσης δικαιοσύνης, καὶ ἀπὸ πάσης ἀληθείας, ἧς ἐποίησας τῷ παιδί σου· ἐν γὰρ τῇ ῥάβδῳ μου ταύτῃ διέβην τὸν Ἰορδάνην τοῦτον· νυνὶ δὲ γέγονα εἰς δύο παρεμβολάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ἐξελοῦ με ἐκ χειρὸς τοῦ ἀδελφοῦ μου, ἐκ χειρὸς Ἡσαῦ· ὅτι φοβοῦμαι ἐγὼ αὐτὸν, μή ποτε ἐλθὼν πατάξῃ με, καὶ μητέρα ἐπὶ τέκνοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Σὺ δὲ εἶπας, εὐ σε ποιήσω, καὶ θήσω τὸ σπέρμα σου ὡς τὴν ἄμμον τῆς θαλάσσης, ἣ οὐκ ἀριθμηθήσεται ὑπὸ τοῦ πλήθους. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Καὶ ἐκοιμήθη ἐκεῖ τὴν νύκτα ἐκείνην· καὶ ἔλαβεν ὧν ἔφερεν δῶρα· καὶ ἐξαπέστειλεν Ἡσαῦ τῷ ἀδελφῷ αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","αἶγας διακοσίας, τράγους εἴκοσι, πρόβατα διακόσια, κριοὺς εἴκοσι, ");
INSERT INTO grcbrent_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","καμήλους θηλαζούσας καὶ τὰ παιδία αὐτῶν τριάκοντα, βόας τεσσαράκοντα, ταύρους δέκα, ὄνους εἴκοσι, καὶ πώλους δέκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Καὶ ἔδωκεν αὐτὰ τοῖς παισὶν αὐτοῦ ποίμνιον κατὰ μόνας· εἶπε δὲ τοῖς παισὶν αὐτοῦ, προπορεύεσθε ἔμπροσθέν μου, καὶ διάστημα ποιεῖτε ἀνὰ μέσον ποίμνης καὶ ποίμνης. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Καὶ ἐνετείλατο τῷ πρώτῳ, λέγων, ἐάν σοι συναντήσῃ Ἡσαῦ ὁ ἀδελφός μου, καὶ ἐρωτᾷ σε, λέγων, τίνος εἶ; καὶ ποῦ πορεύῃ; καὶ τίνος ταῦτα τὰ προπορευόμενά σου; ");
INSERT INTO grcbrent_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ἐρεῖς, τοῦ παιδός σου Ἰακώβ· δῶρα ἀπέσταλκε τῷ κυρίῳ μου Ἡσαῦ· καὶ ἰδοὺ αὐτὸς ὀπίσω ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Καὶ ἐνετείλατο τῷ πρώτῳ, καὶ τῷ δευτέρῳ, καὶ τῷ τρίτῳ, καὶ πᾶσι τοῖς προπορευομένοις ὀπίσω τῶν ποιμνίων τούτων, λέγων, κατὰ τὸ ῥῆμα τοῦτο λαλήσατε Ἡσαῦ ἐν τῷ εὑρεῖν ὑμᾶς αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Καὶ ἐρεῖτε, ἰδοὺ ὁ παῖς σου Ἰακὼβ παραγίνεται ὀπίσω ἡμῶν· εἶπε γὰρ, ἐξιλάσομαι τὸ πρόσωπον αὐτοῦ ἐν τοῖς δώροις τοῖς προπορευομένοις αὐτοῦ, καὶ μετὰ τοῦτο ὄψομαι τὸ πρόσωπον αὐτοῦ· ἴσως γὰρ προσδέξεται τὸ πρόσωπόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Καὶ προεπορεύετο τὰ δῶρα κατὰ πρόσωπον αὐτοῦ· αὐτὸς δὲ ἐκοιμήθη τὴν νύκτα ἐκείνην ἐν τῇ παρεμβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ἀναστὰς δὲ τὴν νύκτα ἐκείνην, ἔλαβε τὰς δύο γυναῖκας, καὶ τὰς δύο παιδίσκας, καὶ τὰ ἕνδεκα παιδία αὐτοῦ, καὶ διέβη τὴν διάβασιν τοῦ Ἰαβώχ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Καὶ ἔλαβεν αὐτοὺς, καὶ διέβη τὸν χειμάῤῥουν, καὶ διεβίβασε πάντα τὰ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ὑπελείφθη δὲ Ἰακὼβ μόνος· καὶ ἐπάλαιεν ἄνθρωπος μετʼ αὐτοῦ ἕως πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Εἶδε δὲ ὅτι οὐ δύναται πρὸς αὐτόν· καὶ ἥψατο τοῦ πλάτους τοῦ μηροῦ αὐτοῦ, καὶ ἐνάρκησε τὸ πλάτος τοῦ μηροῦ Ἰακὼβ ἐν τῷ παλαίειν αὐτὸν μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Καὶ εἶπεν αὐτῷ, ἀπόστειλόν με, ἀνέβη γὰρ ὁ ὄρθρος. ὁ δὲ εἶπεν, οὐ μή σε ἀποστείλω, ἐὰν μή με εὐλογήσῃς. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Εἶπε δὲ αὐτῷ, τί τὸ ὄνομά σου ἐστίν; ὁ δὲ εἶπεν, Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Καὶ εἶπεν αὐτῷ, οὐ κληθήσεται ἔτι τὸ ὄνομά σου Ἰακὼβ, ἀλλʼ Ἰσραὴλ ἔσται τὸ ὄνομά σου· ὅτι ἐνίσχυσας μετὰ Θεοῦ, καὶ μετὰ ἀνθρώπων δυνατὸς ἔσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ἠρώτησε δὲ Ἰακὼβ, καὶ εἶπεν, ἀνάγγειλόν μοι τὸ ὄνομά σου· καὶ εἶπεν, ἱνατί τοῦτο ἐρωτᾷς σὺ τὸ ὄνομά μου; καὶ εὐλόγησεν αὐτὸν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Καὶ ἐκάλεσεν Ἰακὼβ τὸ ὄνομα τοῦ τόπου ἐκείνου, εἶδος Θεοῦ· εἶδον γὰρ Θεὸν πρόσωπον πρὸς πρὸσωπον, καὶ ἐσώθη μου ἡ ψυχή. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ἀνέτειλεν δὲ αὐτῷ ὁ ἥλιος, ἡνίκα παρῆλθε τὸ εἶδος τοῦ Θεοῦ· αὐτὸς δὲ ἐπέσκαζε τῷ μηρῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Ἕνεκεν τούτου οὐ μὴ φάγωσιν υἱοὶ Ἰσραὴλ τὸ νεῦρον, ὃ ἐνάρκησεν, ὅ ἐστιν ἐπὶ τοῦ πλάτους τοῦ μηροῦ, ἕως τῆς ἡμέρας ταύτης, ὅτι ἥψατο τοῦ πλάτους τοῦ μηροῦ Ἰακὼβ τοῦ νεύρου, ὃ ἐνάρκησεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ἀναβλέψας δὲ Ἰακὼβ τοῖς ὀφθαλμοῖς αὐτοῦ εἶδε· καὶ ἰδοὺ Ἡσαῦ ὁ ἀδελφὸς αὐτοῦ ἐρχόμενος, καὶ τετρακόσιοι ἄνδρες μετʼ αὐτοῦ· καὶ διεῖλεν Ἰακὼβ τὰ παιδία ἐπὶ Λείαν, καὶ ἐπὶ Ῥαχὴλ, καὶ τὰς δύο παιδίσκας. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Καὶ ἔθετο τὰς δύο παιδίσκας καὶ τοὺς υἱοὺς αὐτῶν ἐν πρώτοις, καὶ Λείαν καὶ τὰ παιδία αὐτῆς ὀπίσω, καὶ Ῥαχὴλ καὶ Ἰωσὴφ ἐσχάτους. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Αὐτὸς δὲ προῆλθεν ἔμπροσθεν αὐτῶν· καὶ προσεκύνησεν ἐπὶ τὴν γῆν ἑπτάκις, ἕως τοῦ ἐγγίσαι τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Καὶ προσέδραμεν Ἡσαῦ εἰς συνάντησιν αὐτῷ· καὶ περιλαβὼν αὐτὸν προσέπεσεν ἐπὶ τὸν τράχηλον αὐτοῦ, καὶ κατεφίλησεν αὐτόν· καὶ ἔκλαυσαν ἀμφότεροι. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Καὶ ἀναβλέψας Ἡσαῦ εἶδε τὰς γυναῖκας καὶ τὰ παιδία· καὶ εἶπε, τί ταῦτά σοι ἐστίν; ὁ δὲ εἶπε, τὰ παιδία, οἷς ἠλέησεν ὁ Θεὸς τὸν παῖδά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Καὶ προσήγγισαν αἱ παιδίσκαι καὶ τὰ τέκνα αὐτῶν, καὶ προσεκύνησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Καὶ προσήγγισε Λεία καὶ τὰ τέκνα αὐτῆς, καὶ προσεκύνησαν· καὶ μετὰ ταῦτα προσήγγισε Ῥαχὴλ καὶ Ἰωσὴφ, καὶ προσεκύνησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Καὶ εἶπε, τί ταῦτά σοι ἐστὶν, πᾶσαι αἱ παρεμβολαὶ αὗται, αἷς ἀπήντηκα; ὁ δὲ εἶπεν, ἵνα εὕρῃ ὁ παῖς σου χάριν ἐναντίον σου, κύριε. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Εἶπε δὲ Ἡσαῦ, ἔστι μοι πολλὰ, ἀδελφέ· ἔστω σοι τὰ σά. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Εἶπε δὲ Ἰακὼβ, εἰ εὓρον χάριν ἐναντίον σου, δέξαι τὰ δῶρα διὰ τῶν ἐμῶν χειρῶν· ἕνεκεν τούτου εἶδον τὸ πρόσωπόν σου, ὡς ἄν τις ἴδοι πρόσωπον Θεοῦ, καὶ εὐδοκήσεις με. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Λάβε τὰς εὐλογίας μου, ἃς ἤνεγκά σοι, ὅτι ἠλέησέ με ὁ Θεὸς, καὶ ἔστι μοι πάντα· καὶ ἐβιάσατο αὐτὸν, καὶ ἔλαβε. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Καὶ εἶπεν, ἀπάραντες πορευσώμεθα ἐπʼ εὐθεῖαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Εἶπε δὲ αὐτῷ, ὁ κύριός μου γινώσκει, ὅτι τὰ παιδία ἁπαλώτερα, καὶ τὰ πρόβατα καὶ αἱ βόες λοχεύονται ἐπʼ ἐμέ· ἐὰν οὖν καταδιώξω αὐτὰ ἡμέραν μίαν, ἀποθανοῦνται πάντα τὰ κτήνη. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Προελθέτω ὁ κύριός μου ἔμπροσθεν τοῦ παιδὸς αὐτοῦ· ἐγὼ δὲ ἐνισχύσω ἐν τῇ ὁδῷ κατὰ σχολὴν τῆς πορεύσεως τῆς ἐναντίον μου, καὶ κατὰ πόδα τῶν παιδαρίων, ἕως τοῦ ἐλθεῖν με πρὸς τὸν κύριόν μου εἰς Σηείρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Εἶπε δὲ Ἡσαῦ, καταλείψω μετὰ σοῦ ἀπὸ τοῦ λαοῦ τοῦ μετʼ ἐμοῦ· ὁ δὲ εἶπεν, ἱνατί τοῦτο; ἱκανὸν ὅτι εὗρον χάριν ἐναντίον σου, κύριε. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ἀπέστρεψε δὲ Ἡσαῦ ἐν τῇ ἡμέρᾳ ἐκείνῃ εἰς τὴν ὁδὸν αὐτοῦ εἰς Σηείρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Καὶ Ἰακὼβ ἀπαίρει εἰς σκηνὰς, καὶ ἐποίησεν ἑαυτῷ ἐκεῖ οἰκίας, καὶ τοῖς κτήνεσιν αὐτοῦ ἐποίησε σκηνάς· διὰ τοῦτο ἐκάλεσε τὸ ὄνομα τοῦ τόπου ἐκείνου, Σκηναί. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Καὶ ἦλθεν Ἰακὼβ εἰς Σαλὴμ, πόλιν Σηκίμων, ἥ ἐστιν ἐν γῇ Χαναὰν, ὅτε ἐπανῆλθεν ἐκ τῆς Μεσοποταμίας Συρίας· καὶ παρενέλαβε κατὰ πρόσωπον τῆς πόλεως. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Καὶ ἐκτήσατο τὴν μερίδα τοῦ ἀγροῦ, οὗ ἔστησεν ἐκεῖ τὴν σκηνὴν αὐτοῦ, παρὰ Ἐμμὼρ πατρὸς Συχὲμ, ἑκατὸν ἀμνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Καὶ ἔστησεν ἐκεῖ θυσιαστήριον, καὶ ἐπεκαλέσατο τὸν Θεὸν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ἐξῆλθε δὲ Δείνα, ἡ θυγάτηρ Λείας, ἣν ἔτεκε τῷ Ἰακώβ, καταμαθεῖν τὰς θυγατέρας τῶν ἐγχωρίων. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Καὶ εἶδεν αὐτὴν Συχὲμ ὁ υἱὸς Ἐμμὼρ ὁ Εὐαῖος, ὁ ἄρχων τῆς γῆς· καὶ λαβὼν αὐτὴν, ἐκοιμήθη μετʼ αὐτῆς, καὶ ἐταπείνωσεν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Καὶ προσέσχε τῇ ψυχῇ Δείνας τῆς θυγατρὸς Ἰακώβ· καὶ ἠγάπησε τὴν παρθένον· καὶ ἐλάλησε κατὰ τὴν διάνοιαν τῆς παρθένου αυτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Εἶπε Συχὲμ πρὸς Ἐμμὼρ τὸν πατέρα αὐτοῦ, λέγων, λάβε μοι τὴν παῖδα ταύτην εἰς γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ἰακὼβ δὲ ἤκουσεν, ὅτι ἐμίανεν ὁ υἱὸς Ἐμμὼρ Δείναν τὴν θυγατέρα αὐτοῦ· οἱ δὲ υἱοὶ αὐτοῦ ἦσαν μετὰ τῶν κτηνῶν αὐτοῦ ἐν τῷ πεδίῳ· παρεσιώπησε δὲ Ἰακὼβ, ἕως τοῦ ἐλθεῖν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ἐξῆλθε δὲ Ἐμμὼρ ὁ πατὴρ Συχὲμ πρὸς Ἰακὼβ, λαλῆσαι αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Οἱ δὲ υἱοὶ Ἰακὼβ ἦλθον ἐκ τοῦ πεδίου· ὡς δὲ ἤκουσαν, κατενύγησαν οἱ ἄνδρες, καὶ λυπηρὸν ἦν αὐτοῖς σφόδρα· ὅτι ἄσχημον ἐποίησεν ἐν Ἰσραὴλ, κοιμηθεὶς μετὰ τῆς θυγατρὸς Ἰακώβ· καὶ οὐχ οὕτως ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Καὶ ἐλάλησεν Ἐμμὼρ αὐτοῖς, λέγων, Συχὲμ ὁ υἱός μου προείλετο τῇ ψυχῇ τὴν θυγατέρα ὑμῶν· δότε οὖν αὐτὴν αὐτῷ γυναῖκα, ");
INSERT INTO grcbrent_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","καὶ ἐπιγαμβρεύσασθε ἡμῖν· τὰς θυγατέρας ὑμῶν δότε ἡμῖν, καὶ τὰς θυγατέρας ἡμῶν λάβετε τοῖς υἱοῖς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Καὶ ἐν ἡμῖν κατοικεῖτε· καὶ ἡ γῆ ἰδοὺ πλατεῖα ἐναντίον ὑμῶν· κατοικεῖτε, καὶ ἐμπορεύεσθε ἐπʼ αὐτῆς, καὶ ἐγκτᾶσθε ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Εἶπε δὲ Συχὲμ πρὸς τὸν πατέρα αὐτῆς, καὶ πρὸς τοὺς ἀδελφοὺς αὐτῆς, εὕροιμι χάριν ἐναντίον ὑμῶν· καὶ ὃ ἐὰν εἴπητε, δώσομεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Πληθύνατε τὴν φερνὴν σφόδρα, καὶ δώσω καθότι ἂν εἴπητέ μοι, καὶ δώσετέ μοι τὴν παῖδα ταύτην εἰς γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ἀπεκρίθησαν δὲ οἱ υἱοὶ Ἰακὼβ τῷ Συχὲμ, καὶ Ἐμμὼρ τῷ πατρὶ αὐτοῦ, μετὰ δόλου· καὶ ἐλάλησαν αὐτοῖς, ὅτι ἐμίαναν Δείναν τὴν ἀδελφὴν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Καὶ εἶπαν αὐτοῖς Συμεὼν καὶ Λευὶ οἱ ἀδελφοὶ Δείνας, οὐ δυνησόμεθα ποιῆσαι τὸ ῥῆμα τοῦτο, δοῦναι τὴν ἀδελφὴν ἡμῶν ἀνθρώπῳ, ὃς ἔχει ἀκροβυστίαν· ἔστι γὰρ ὄνειδος ἡμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Μόνον ἐν τούτῳ ὁμοιωθησόμεθα ὑμῖν, καὶ κατοικήσομεν ἐν ὑμῖν, ἐὰν γένησθε ὡς ἡμεῖς καὶ ὑμεῖς, ἐν τῷ περιτμηθῆναι ὑμῶν πᾶν ἀρσενικόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Καὶ δώσομεν τὰς θυγατέρας ἡμῶν ὑμῖν, καὶ ἀπὸ τῶν θυγατέρων ὑμῶν ληψόμεθα ἡμῖν γυναῖκας, καὶ οἰκήσομεν παρʼ ὑμῖν, καὶ ἐσόμεθα ὡς γένος ἕν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ἐὰν δὲ μὴ εἰσακούσητε ἡμῶν τοῦ περιτεμέσθαι, λαβόντες τὴν θυγατέρα ἡμῶν ἀπελευσόμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Καὶ ἤρεσαν οἱ λόγοι ἐναντίον Ἐμμὼρ, καὶ ἐναντίον Συχὲμ τοῦ υἱοῦ Ἐμμώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Καὶ οὐκ ἐχρόνισεν ὁ νεανίσκος τοῦ ποιῆσαι τὸ ῥῆμα τοῦτο· ἐνέκειτο γὰρ τῇ θυγατρὶ Ἰακώβ· αὐτὸς δὲ ἦν ἐνδοξότατος πάντων τῶν ἐν τῷ οἴκῳ τοῦ πατρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ἦλθε δὲ Ἐμμὼρ καὶ Συχὲμ ὁ υἱὸς αὐτοῦ πρὸς τὴν πύλην τῆς πόλεως αὐτῶν, καὶ ἐλάλησαν πρὸς τοὺς ἄνδρας τῆς πόλεως αὐτῶν, λέγοντες, ");
INSERT INTO grcbrent_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Οἱ ἄνθρωποι οὗτοι εἰρήνικοί εἰσι, μεθʼ ἡμῶν οἰκείτωσαν επὶ τῆς γῆς, καὶ ἐμπορευέσθωσαν αὐτήν· ἡ δὲ γῆ ἰδοὺ πλατεῖα ἐναντίον αὐτῶν· τὰς θυγατέρας αὐτῶν ληψόμεθα ἡμῖν γυναῖκας, καὶ τὰς θυγατέρας ἡμῶν δώσομεν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ἐν τούτῳ μόνον ὁμοιωθήσονται ἡμῖν οἱ ἄνθρωποι τοῦ κατοικεῖν μεθʼ ἡμῶν, ὥστε εἶναι λαὸν ἕνα, ἐν τῷ περιτεμέσθαι ἡμῶν πᾶν ἀρσενικὸν, καθὰ καὶ αὐτοὶ περιτέτμηνται. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Καὶ τὰ κτήνη αὐτῶν, καὶ τὰ τετράποδα, καὶ τὰ ὑπάρχοντα αὐτῶν, οὐχ ἡμῶν ἔσται; μόνον ἐν τούτῳ ὁμοιωθῶμεν αὐτοῖς, καὶ οἰκήσουσι μεθʼ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Καὶ εἰσήκουσαν Ἐμμὼρ καὶ Συχὲμ τοῦ υἱοῦ αὐτοῦ πάντες οἱ ἐμπορευόμενοι τὴν πύλην τῆς πόλεως αὐτῶν· καὶ περιετέμοντο τὴν σάρκα τῆς ἀκροβυστίας αὐτῶν πᾶς ἄρσην. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ἐγένετο δὲ ἐν τῇ ἡμέρᾳ τῇ τρίτῃ, ὅτε ἦσαν ἐν τῷ πόνῳ, ἔλαβον οἱ δύο υἱοὶ Ἰακὼβ Συμεὼν καὶ Λευὶ, ἀδελφοὶ Δείνας, ἕκαστος τὴν μάχαιραν αὐτοῦ, καὶ εἰσῆλθον εἰς τὴν πόλιν ἀσφαλὼς, καὶ ἀπέκτειναν πᾶν ἀρσενικόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Τόν τε Ἐμμὼρ καὶ Συχὲμ τὸν υἱὸν αὐτοῦ ἀπέκτειναν ἐν στόματι μαχαίρας· καὶ ἔλαβον τὴν Δείναν ἐκ τοῦ οἴκου τοῦ Συχὲμ, καὶ ἐξῆλθον. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Οἱ δὲ υἱοὶ Ἰακὼβ εἰσῆλθον ἐπὶ τοὺς τραυματίας, καὶ διήρπασαν τὴν πόλιν, ἐν ᾗ ἐμίαναν Δείναν τὴν ἀδελφὴν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Καὶ τὰ πρόβατα αὐτῶν, καὶ τοὺς βόας αὐτῶν, καὶ τοὺς ὄνους αὐτῶν, ὅσα τε ἦν ἐν τῇ πόλει, καὶ ὅσα ἦν ἐν τῷ πεδίῳ, ἔλαβον. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Καὶ πάντα τὰ σώματα αὐτῶν, καὶ πᾶσαν τὴν ἀποσκευὴν αὐτῶν, καὶ τὰς γυναῖκας αὐτῶν ἠχμαλώτευσαν· καὶ διήρπασαν ὅσα τε ἦν ἐν τῇ πόλει, καὶ ὅσα ἦν ἐν ταῖς οἰκίαις. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Εἶπε δὲ Ἰακὼβ πρὸς Συμεὼν καὶ Λευὶ, μισητόν με πεποιήκατε, ὥστε πονηρόν με εἶναι πᾶσι τοῖς κατοικοῦσι τὴν γῆν, ἔν τε τοῖς Χαναναίοις, καὶ ἐν τοῖς Φερεζαίοις· ἐγὼ δὲ ὀλιγοστός εἰμι ἐν ἀριθμῷ· καὶ συναχθέντες ἐπʼ ἐμὲ συγκόψουσί με, καὶ ἐκτριβήσομαι ἐγὼ, καὶ ὁ οἶκός μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Οἱ δὲ εἶπαν, ἀλλʼ ὡσεὶ πόρνῃ χρήσονται τῇ ἀδελφῇ ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Εἶπε δὲ ὁ Θεὸς πρὸς Ἰακὼβ, ἀναστὰς ἀνάβηθι εἰς τὸν τόπον Βαιθὴλ, καὶ οἴκει ἐκεῖ· καὶ ποίησον ἐκεῖ θυσιαστήριον τῷ Θεῷ τῷ ὀφθέντι σοι, ἐν τῷ ἀποδιδράσκειν σε ἀπὸ προσώπου Ἡσαῦ τοῦ ἀδελφοῦ σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Εἶπε δὲ Ἰακὼβ τῷ οἴκῳ αὐτοῦ, καὶ πᾶσι τοῖς μετʼ αὐτοῦ, ἄρατε τοὺς θεοὺς τοὺς ἀλλοτρίους τοὺς μεθʼ ὑμῶν ἐκ μέσου ὑμῶν, καὶ καθαρίσθητε, καὶ ἀλλάξατε τὰς στολὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Καὶ ἀναστάντες ἀναβῶμεν εἰς Βαιθὴλ, καὶ ποιήσωμεν ἐκεῖ θυσιαστήριον τῷ Θεῷ τῷ ἐπακούσαντί μου ἐν ἡμέρᾳ θλίψεως, ὃς ἦν μετʼ ἐμοῦ, καὶ διέσωσέ με ἐν τῇ ὁδῷ, ᾗ ἐπορεύθην. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Καὶ ἔδωκαν τῷ Ἰακὼβ τοὺς θεοὺς τοὺς ἀλλοτρίους, οἳ ἦσαν ἐν ταῖς χερσὶν αὐτῶν, καὶ τὰ ἐνώτια τὰ ἐν τοῖς ὠσὶν αὐτῶν· καὶ κατέκρυψεν αὐτὰ Ἰακὼβ ὑπὸ τὴν τερέβινθον τὴν ἐν Σηκίμοις· καὶ ἀπώλεσεν αὐτὰ, ἕως τῆς σήμερον ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Καὶ ἐξῇρεν Ἰσραὴλ ἐκ Σηκίμων· καὶ ἐγένετο φόβος Θεοῦ ἐπὶ τὰς πόλεις τὰς κύκλῳ αὐτῶν, καὶ οὐ κατεδίωξαν ὀπίσω τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ἦλθε δὲ Ἰακὼβ εἰς Λουζὰ ἥ ἐστιν ἐν γῇ Χαναὰν, ἥ ἐστι Βαιθὴλ, αὐτὸς, καὶ πᾶς ὁ λαὸς, ὃς ἦν μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Καὶ ᾠκοδόμησεν ἐκεῖ θυσιαστήριον, καὶ ἐκάλεσε τὸ ὄνομα τοῦ τόπου, Βαιθήλ· ἐκεῖ γὰρ ἐφάνη αὐτῷ ὁ Θεὸς, ἐν τῷ ἀποδιδράσκειν αὐτὸν ἀπὸ προσώπου Ἡσαῦ τοῦ ἀδελφοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ἀπέθανε δὲ Δεβόῤῥα, ἡ τρόφος Ῥεβέκκας, καὶ ἐτάφη κατώτερον Βαιθὴλ ὑπὸ τὴν βάλανον· καὶ ἐκάλεσεν Ἰακὼβ τὸ ὄνομα αὐτῆς, βάλανος πένθους. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ὤφθη δὲ ὁ Θεὸς τῷ Ἰακὼβ ἔτι ἐν Λουζᾷ, ὅτε παρεγένετο ἐκ Μεσοποταμίας τῆς Συρίας· καὶ εὐλόγησεν αὐτὸν ὁ Θεὸς. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Καὶ εἶπεν αὐτῷ ὁ Θεὸς, τὸ ὄνομά σου οὐ κληθήσεται ἔτι Ἰακὼβ, ἀλλʼ Ἰσραὴλ ἔσται τὸ ὄνομά σου· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Εἶπε δὲ αὐτῷ ὁ Θεὸς, ἐγὼ ὁ Θεός σου· αὐξάνου, καὶ πληθύνου· ἔθνη καὶ συναγωγαὶ ἐθνῶν ἔσονται ἐκ σοῦ, καὶ βασιλεῖς ἐκ τῆς ὀσφύος σου ἐξελεύσονται. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Καὶ τὴν γῆν, ἣν ἔδωκα Ἁβραὰμ καὶ Ἰσαὰκ, σοὶ δέδωκα αὐτήν· σοὶ ἔσται· καὶ τῷ σπέρματί σου μετὰ σὲ δώσω τῆν γῆν ταύτην. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ἀνέβη δὲ ὁ Θεὸς ἀπʼ αὐτοῦ ἐκ τοῦ τόπου, οὗ ἐλάλησε μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Καὶ ἔστησεν Ἰακὼβ στήλην ἐν τῷ τόπῳ, ᾧ ἐλάλησε μετʼ αὐτοῦ ὁ Θεὸς, στήλην λιθίνην· καὶ ἔσπεισεν ἐπʼ αὐτὴν σπονδὴν, καὶ ἐπέχεεν ἐπʼ αὐτὴν ἔλαιον. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Καὶ ἐκάλεσεν Ἰακὼβ τὸ ὄνομα τοῦ τόπου, ἐν ᾧ ἐλάλησε μετʼ αὐτοῦ ἐκεῖ ὁ Θεὸς, Βαιθήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ἀπάρας δὲ Ἰακὼβ ἐκ Βαιθὴλ, ἔπηξε τὴν σκηνὴν αὐτοῦ ἐπέκεινα τοῦ πύργου Γαδέρ· ἐγένετο δὲ ἡνίκα ἤγγισεν εἰς Χαβραθὰ τοῦ ἐλθεῖν εἰς τὴν Ἐφραθᾶ, ἔτεκε Ῥαχήλ· καὶ ἐδυστόκησεν ἐν τῷ τοκετῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ἐγένετο δὲ ἐν τῷ σκληρὼς αὐτὴν τίκτειν, εἶπεν αὐτῇ ἡ μαῖα, θάρσει, καὶ γὰρ οὗτός σοι ἐστὶν υἱός. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ἐγένετο δὲ ἐν τῷ ἀφιέναι αὐτὴν τὴν ψυχὴν, ἀπέθνησκε γὰρ, ἐκάλεσε τὸ ὄνομα αὐτοῦ, υἱὸς ὀδύνης μου· ὁ δὲ πατὴρ ἐκάλεσεν τὸ ὄνομα αὐτοῦ, Βενιαμίν. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ἀπέθανε δὲ Ῥαχὴλ, καὶ ἐτάφη ἐν τῇ ὁδῷ τοῦ ἱπποδρόμου Ἐφραθᾶ· αὕτη ἐστὶ Βηθλεέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Καὶ ἔστησεν Ἰακὼβ στήλην ἐπὶ τοῦ μνημείου αὐτῆς· αὕτη ἐστὶν ἡ στήλη ἐπὶ τοῦ μνημείου Ῥαχὴλ ἕως τῆς ἡμέρας ταύτης. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ἐγένετο δὲ ἡνίκα κατῴκησεν Ἰσραὴλ ἐν τῇ γῇ ἐκείνῃ, ἐπορεύθη Ῥουβὴν, καὶ ἐκοιμήθη μετὰ Βαλλὰς, τῆς παλλακῆς τοῦ πατρὸς αὐτοῦ Ἰακώβ· καὶ ἤκουσεν Ἰσραὴλ, καὶ πονηρὸν ἐφάνη ἐναντίον αὐτοῦ. Ἦσαν δὲ οἱ υἱοὶ Ἰακὼβ, δώδεκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Υἱοὶ Λείας, πρωτότοκος Ἰακὼβ, Ῥουβὴν, Συμεὼν, Λευὶ, Ἰούδας, Ἰσσάχαρ, Ζαβουλών. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Υἱοὶ δὲ Ῥαχὴλ, Ἰωσὴφ, καὶ Βενιαμίν. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Υἱοὶ δὲ Βαλλᾶς παιδίσκης Ῥαχὴλ, Δαν, καὶ Νεφθαλείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Υἱοὶ δὲ Ζελφᾶς παιδίσκης Λείας, Γὰδ, καὶ Ἀσήρ· οὗτοι υἱοὶ Ἰακὼβ, οἳ ἐγένοντο αὐτῷ ἐν Μεσοποταμίᾳ τῆς Συρίας. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ἦλθε δὲ Ἰακὼβ πρὸς Ἰσαὰκ τὸν πατέρα αὐτοῦ εἰς Μαμβρῆ, εἰς πόλιν τοῦ πεδίου· αὕτη ἐστὶ Χεβρὼν ἐν γῇ Χαναὰν, οὗ παρῴκησεν Ἁβραὰμ καὶ Ἰσαάκ. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ἐγένοντο δὲ αἱ ἡμέραι Ἰσαὰκ, ἃς ἔζησεν, ἔτη ἑκατὸν ὀγδοήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Καὶ ἐκλείπων Ἰσαὰκ ἀπέθανε, καὶ προσετέθη πρὸς τὸ γένος αὐτοῦ πρεσβύτερος καὶ πλήρης ἡμερῶν· καὶ ἔθαψαν αὐτὸν Ἡσαῦ καὶ Ἰακὼβ οἱ υἱοὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Αὗται δὲ αἱ γενέσεις Ἡσαῦ· αὐτός ἐστιν Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ἡσαῦ δὲ ἔλαβε τὰς γυναῖκας ἑαυτῷ ἀπὸ τῶν θυγατέρων τῶν Χαναναίων· τὴν Ἀδὰ, θυγατέρα Αἰλὼμ τοῦ Χετταίου· καὶ τὴν Ὀλιβεμὰ, θυγατέρα Ἀνὰ τοῦ υἱοῦ Σεβεγὼν τοῦ Εὐαίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Καὶ τὴν Βασεμὰθ, θυγατέρα Ἰσμαὴλ, ἀδελφὴν Ναβαιώθ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ἔτεκε δὲ αὐτῷ Ἀδὰ τὸν Ἑλιφάς· καὶ Βασεμὰθ ἔτεκε τὸν Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Καὶ Ὀλιβεμὰ ἔτεκε τὸν Ἰεοὺς, καὶ τὸν Ἰεγλὸμ, καὶ τὸν Κορέ· οὗτοι υἱοὶ Ἡσαῦ, οἳ ἐγένοντο αὐτῷ ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ἔλαβε δὲ Ἡσαῦ τὰς γυναῖκας αὐτοῦ, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ τὰς θυγατέρας αὐτοῦ, καὶ πάντα τὰ σώματα τοῦ οἴκου αὐτοῦ, καὶ πάντα τὰ ὑπάρχοντα αὐτοῦ, καὶ πάντα τὰ κτήνη, καὶ πάντα ὅσα ἐκτήσατο, καὶ πάντα ὅσα περιεποιήσατο ἐν γῇ Χαναάν· καὶ ἐπορεύθη Ἡσαῦ ἐκ τῆς γῆς Χαναὰν ἀπὸ προσώπου Ἰακὼβ τοῦ ἀδελφοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ἦν γὰρ αὐτῶν τὰ ὑπάρχοντα πολλὰ, τοῦ οἰκεῖν ἅμα· καὶ οὐκ ἠδύνατο ἡ γῆ τῆς παροικήσεως αὐτῶν φέρειν αὐτοὺς, ἀπὸ τοῦ πλήθους τῶν ὑπαρχόντων αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Κατῴκησε δὲ Ἡσαῦ ἐν τῷ ὄρει Σηείρ· Ἡσαῦ αὐτός ἐστιν Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Αὗται δὲ αἱ γενέσεις Ἡσαῦ πατρὸς Ἐδὼμ ἐν τῷ ὄρει Σηείρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Καὶ ταῦτα τὰ ὀνόματα τῶν υἱῶν Ἡσαῦ· Ἑλιφὰς υἱὸς Ἀδὰς γυναικὸς Ἡσαῦ· καὶ Ῥαγουὴλ υἱὸς Βασεμὰθ γυναικὸς Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ἐγένοντο δὲ Ἑλιφὰς υἱοὶ, Θαιμὰν, Ὠμὰρ, Σωφὰρ, Γοθὼμ, καὶ Κενέζ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Θαμνὰ δὲ ἦν παλλακὴ Ἑλιφὰς τοῦ υἱοῦ Ἡσαῦ· καὶ ἔτεκε τῷ Ἑλιφὰς τὸν Ἀμαλήκ· οὗτοι υἱοὶ Ἀδὰς γυναικὸς Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Οὗτοι δὲ υἱοὶ Ῥαγουὴλ, Ναχὼθ, Ζαρὲ, Σομὲ, καὶ Μοζέ· οὗτοι ἦσαν υἱοὶ Βασεμὰθ γυναικὸς Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Οὗτοι δὲ υἱοὶ Ὀλιβεμὰς θυγατρὸς Ἀνὰ τοῦ υἱοῦ Σεβεγὼν, γυναικὸς Ἡσαῦ· ἔτεκε δὲ τῷ Ἡσαῦ τὸν Ἰεοὺς, καὶ τὸν Ἰεγλὸμ, καὶ τὸν Κορέ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Οὗτοι ἡγεμόνες υἱοὶ Ἡσαῦ· υἱοὶ Ἑλιφὰς πρωτοτόκου Ἡσαῦ· ἡγεμὼν Θαιμὰν, ἡγεμὼν Ὠμὰρ, ἡγεμὼν Σωφὰρ, ἡγεμὼν Κενὲζ, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ἡγεμὼν Κορὲ, ἡγεμὼν Γοθὼμ, ἡγεμὼν Ἀμαλήκ· οὗτοι ἡγεμόνες Ἑλιφὰς ἐν γῇ Ἰδουμαίᾳ· οὗτοι υἱοὶ Ἀδάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Καὶ οὗτοι υἱοὶ Ῥαγουὴλ υἱοῦ Ἡσαῦ· ἡγεμὼν Ναχὼθ, ἡγεμὼν Ζαρὲ, ἡγεμὼν Σομὲ, ἡγεμὼν Μοζέ· οὗτοι ἡγεμόνες Ῥαγουὴλ ἐν γῇ Ἐδώμ· οὗτοι υἱοὶ Βασεμὰθ γυναικὸς Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Οὗτοι δὲ υἱοὶ Ὀλιβεμὰς γυναικὸς Ἡσαῦ· ἡγεμὼν Ἰεοὺς, ἡγεμὼν Ἰεγλὸμ, ἡγεμὼν Κορέ· οὗτοι ἡγεμόνες Ὀλιβεμὰς θυγατρὸς Ἀνὰ γυναικὸς Ἡσαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Οὗτοι υἱοὶ Ἡσαῦ, καὶ οὗτοι ἡγεμόνες αὐτῶν· οὗτοί εἰσιν υἱοὶ Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Οὗτοι δὲ υἱοὶ Σηεὶρ τοῦ Χοῤῥαίου, τοῦ κατοικοῦντος τὴν γῆν· Λωτὰν, Σωβὰλ, Σεβεγὼν, Ἀνὰ, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","καὶ Δησὼν, καὶ Ἀσὰρ, καὶ Ῥισών· οὗτοι ἡγεμόνες τοῦ Χοῤῥαίου, τοῦ υἱοῦ Σηεὶρ ἐν τῇ γῇ Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ἐγένοντο δὲ υἱοὶ Λωτάν· Χοῤῥὶ, καὶ Αἱμάν· ἀδελφὴ δὲ Λωτὰν, Θαμνά. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Οὗτοι δὲ υἱοὶ Σωβάλ· Γωλὰμ, καὶ Μαναχὰθ, καὶ Γαιβὴλ, καὶ Σωφὰρ, καὶ Ὠμάρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Καὶ οὗτοι υἱοὶ Σεβεγὼν, Ἀϊὲ, καὶ Ἀνά· οὗτός ἐστιν Ἀνὰ, ὃς εὗρε τὸν Ἰαμεὶν ἐν τῇ ἐρήμῳ, ὅτε ἔνεμε τὰ ὑποζύγια Σεβεγὼν τοῦ πατρὸς αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Οὗτοι δὲ υἱοὶ Ἀνά· Δησὼν, καὶ Ὀλιβεμὰ θυγάτηρ Ἀνά. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Οὗτοι δὲ υἱοὶ Δησών· Ἀμαδὰ, καὶ Ἀσβὰν, καὶ Ἰθρὰν, καὶ Χαῤῥάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Οὗτοι δὲ υἱοὶ Ἀσάρ· Βαλαὰμ, καὶ Ζουκὰμ, καὶ Ἰουκάμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Οὗτοι δὲ υἱοὶ Ῥισὼν, Ὧς, καὶ Ἀράν. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Οὗτοι δὲ ἡγεμόνες Χοῤῥί· ἡγεμὼν Λωτὰν, ἡγεμὼν Σωβὰλ, ἡγεμὼν Σεβεγὼν, ἡγεμὼν Ἀνὰ, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ἡγεμὼν Δησὼν, ἡγεμὼν Ἀσὰρ, ἡγεμὼν Ῥισών· οὗτοι ἡγεμόνες Χοῤῥὶ ἐν ταῖς ἡγεμονίαις αὐτῶν ἐν γῇ Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Καὶ οὗτοι οἱ βασιλεῖς οἱ βασιλεύσαντες ἐν Ἐδὼμ, πρὸ τοῦ βασιλεῦσαι βασιλέα ἐν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Καὶ ἐβασίλευσεν ἐν Ἐδὼμ Βαλὰκ υἱὸς Βεώρ· καὶ ὄνομα τῇ πόλει αὐτοῦ, Δενναβά. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ἀπέθανε δὲ Βαλὰκ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Ἰωβὰβ υἱὸς Ζαρὰ ἐκ Βοσόῤῥας. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ἀπέθανε δὲ Ἰωβὰβ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Ἀσὼμ ἐκ τῆς γῆς Θαιμανών. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ἀπέθανε δὲ Ἀσὼμ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Ἀδὰδ υἱὸς Βαρὰδ ὁ ἐκκόψας Μαδιὰμ ἐν τῷ πεδίῳ Μωάβ· καὶ ὄνομα τῇ πόλει αὐτοῦ Γετθαίμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ἀπέθανε δὲ Ἀδὰδ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Σαμαδὰ ἐκ Μασσεκκάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ἀπέθανε δὲ Σαμαδὰ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Σαοὺλ ἐκ Ῥοωβὼθ τῆς παρὰ ποταμόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ἀπέθανε δὲ Σαοὺλ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Βαλλενὼν υἱὸς Ἀχοβώρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ἀπέθανε δὲ Βαλλενὼν υἱὸς Ἀχοβὼρ, καὶ ἐβασίλευσεν ἀντʼ αὐτοῦ Ἀρὰδ υἱὸς Βαράδ· καὶ ὄνομα τῇ πόλει αὐτοῦ Φογώρ· ὄνομα δὲ τῇ γυναικὶ αὐτοῦ Μετεβεὴλ, θυγάτηρ Ματραῒθ, υἱοῦ Μαιζοώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ταῦτα τὰ ὀνόματα τῶν ἡγεμόνων Ἡσαῦ, ἐν ταῖς φυλαῖς αὐτῶν, κατὰ τόπον αὐτῶν, ἐν ταῖς χώραις αὐτῶν, καὶ ἐν τοῖς ἔθνεσιν αὐτῶν· ἡγεμὼν Θαμνὰ, ἡγεμὼν Γωλὰ, ἡγεμὼν Ἰεθὲρ, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ἡγεμὼν Ὁλιβεμὰς, ἡγεμὼν Ἡλὰς, ἡγεμὼν Φινὼν, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ἡγεμὼν Κενὲζ, ἡγεμὼν Θαιμὰν, ἡγεμὼν Μαζὰρ, ");
INSERT INTO grcbrent_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ἡγεμὼν Μαγεδιὴλ, ἡγεμὼν Ζαφωίν· οὗτοι ἡγεμόνες Ἐδὼμ, ἐν ταῖς κατῳκοδομημέναις ἐν τῇ γῇ τῆς κτήσεως αὐτῶν· οὗτος Ἡσαῦ πατὴρ Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Κατῴκει δὲ Ἰακὼβ ἐν τῇ γῇ, οὗ παρῴκησεν ὁ πατὴρ αὐτοῦ ἐν γῇ Χαναάν· αὗται δὲ αἱ γενέσεις Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ἰωσὴφ δὲ δέκα καὶ ἑπτὰ ἐτῶν ἦν, ποιμαίνων τὰ πρόβατα τοῦ πατρὸς αὐτοῦ μετὰ τῶν ἀδελφῶν αὐτοῦ, ὢν νέος, μετὰ τῶν υἱῶν Βαλλᾶς, καὶ μετὰ τῶν υἱῶν Ζελφᾶς, τῶν γυναικῶν τοῦ πατρὸς αὐτοῦ· κατήνεγκαν δὲ Ἰωσὴφ ψόγον πονηρὸν πρὸς Ἰσραὴλ τὸν πατέρα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ἰακὼβ δὲ ἠγάπα τὸν Ἰωσὴφ παρὰ πάντας τοὺς υἱοὺς αὐτοῦ, ὅτι υἱὸς γήρως ἦν αὐτῷ· ἐποίησε δὲ αὐτῷ χιτῶνα ποικίλον. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ἰδόντες δὲ οἱ ἀδελφοὶ αὐτοῦ, ὅτι αὐτὸν ὁ πατὴρ φιλεῖ ἐκ πάντων τῶν υἱῶν αὐτοῦ, ἐμίσησαν αὐτὸν, καὶ οὐκ ἠδύναντο λαλεῖν αὐτῷ οὐδὲν εἰρηνικόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ἐνυπνιασθεὶς δὲ Ἰωσὴφ ἐνύπνιον, ἀπήγγειλεν αὐτὸ τοῖς ἀδελφοῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Καὶ εἶπεν αὐτοῖς, ἀκούσατε τοῦ ἐνυπνίου τούτου, οὗ ἐνυπνιάσθην. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ὤμην ὑμᾶς δεσμεύειν δράγματα ἐν μέσῳ τῷ πεδίῳ· καὶ ἀνέστη τὸ ἐμὸν δράγμα, καὶ ὠρθώθη· περιστραφέντα δὲ τὰ δράγματα ὑμῶν, προσεκύνησαν τὸ ἐμὸν δράγμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Εἶπαν δὲ αὐτῷ οἱ ἀδελφοὶ αὐτοῦ, μὴ βασιλεύων βασιλεύσεις ἐφʼ ἡμᾶς, ἢ κυριεύων κυριεύσεις ἡμῶν, καὶ προσέθεντο ἔτι μισεῖν αὐτὸν ἕνεκεν τῶν ἐνυπνίων αὐτοῦ, καὶ ἕνεκεν τῶν ῥημάτων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Εἶδε δὲ ἐνύπνιον ἕτερον, καὶ διηγήσατο αὐτὸ τῷ πατρὶ αὐτοῦ, καὶ τοῖς ἀδελφοῖς αὐτοῦ· καὶ εἶπεν, ἰδοὺ ἐνυπνιασάμην ἐνύπνιον ἕτερον· ὥσπερ ὁ ἥλιος, καὶ ἡ σελήνη, καὶ ἕνδεκα ἀστέρες προσεκύνουν με. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Καὶ ἐπετίμησεν αὐτῷ ὁ πατὴρ αὐτοῦ, καὶ εἶπεν αὐτῷ, τί τὸ ἐνύπνιον τοῦτο, ὃ ἐνυπνιάσθης; ἆρά γε ἐλθόντες ἐλευσόμεθα ἐγώ τε καὶ ἡ μήτηρ σου καὶ οἱ ἀδελφοί σου προσκυνῆσαί σοι ἐπὶ τὴν γῆν; ");
INSERT INTO grcbrent_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ἐζήλωσαν δὲ αὐτὸν οἱ ἀδελφοὶ αὐτοῦ· ὁ δὲ πατὴρ αὐτοῦ διετήρησε τὸ ῥῆμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ἐπορεύθησαν δὲ οἱ ἀδελφοὶ αὐτοῦ βόσκειν τὰ πρόβατα τοῦ πατρὸς αὐτῶν εἰς Συχέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Καὶ εἶπεν Ἰσραὴλ πρὸς Ἰωσὴφ, οὐχὶ οἱ ἀδελφοί σου ποιμαίνουσιν εἰς Συχέμ; δεῦρο ἀποστείλω σε πρὸς αὐτούς· εἶπε δὲ αὐτῷ, ἰδοὺ ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Εἶπε δὲ αὐτῷ Ἰσραὴλ, πορευθεὶς ἴδε, εἰ ὑγιαίνουσιν οἱ ἀδελφοί σου, καὶ τὰ πρόβατα, καὶ ἀνάγγειλόν μοι· καὶ ἀπέστειλεν αὐτὸν ἐκ τῆς κοιλάδος τῆς Χεβρών· καὶ ἦλθεν εἰς Συχέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Καὶ εὗρεν αὐτὸν ἄνθρωπος πλανώμενον ἐν τῷ πεδίῳ· ἠρώτησε δὲ αὐτὸν ὁ ἄνθρωπος, λέγων, τί ζητεῖς; ");
INSERT INTO grcbrent_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ὁ δὲ εἶπε, τοὺς ἀδελφούς μου ζητῶ· ἀπάγγειλόν μοι ποῦ βόσκουσιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Εἶπε δὲ αὐτῷ ὁ ἄνθρωπος, ἀπῄρκασιν ἐντεῦθεν· ἤκουσα γὰρ αὐτῶν λεγόντων, πορευθῶμεν εἰς Δωθαείμ· καὶ ἐπορεύθη Ἰωσὴφ κατόπισθε τῶν ἀδελφῶν αὐτοῦ, καὶ εὗρεν αὐτοὺς ἐν Δωθαείμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Προεῖδον δὲ αὐτὸν μακρόθεν πρὸ τοῦ ἐγγίσαι αὐτὸν πρὸς αὐτούς· καὶ ἐπονηρεύοντο τοῦ ἀποκτεῖναι αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Εἶπε δὲ ἕκαστος πρὸς τὸν ἀδελφὸν αὐτοῦ, ἰδοὺ ὁ ἐνυπνιαστὴς ἐκεῖνος ἔρχεται. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Νῦν οὖν δεῦτε ἀποκτείνωμεν αὐτὸν, καὶ ῥίψωμεν αὐτὸν εἰς ἕνα τῶν λάκκων· καὶ ἐροῦμεν, θηρίον πονηρὸν κατέφαγεν αὐτόν· καὶ ὀψόμεθα, τί ἔσται τὰ ἐνύπνια αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ἀκούσας δὲ Ῥουβὴν, ἐξείλετο αὐτὸν ἐκ τῶν χειρῶν αὐτῶν· καὶ εἶπεν, οὐ πατάξωμεν αὐτὸν εἰς ψυχήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Εἶπε δὲ αὐτοῖς Ῥουβὴν, μὴ ἐκχέητε αἷμα· ἐμβάλλετε αὐτὸν εἰς ἕνα τῶν λάκκων τούτων τῶν ἐν τῇ ἐρήμῳ, χεῖρα δὲ μὴ ἐπενέγκητε αὐτῷ· ὅπως ἐξέληται αὐτὸν ἐκ τῶν χειρῶν αὐτῶν, καὶ ἀποδῷ αὐτὸν τῷ πατρὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ἐγένετο δὲ ἡνίκα ἦλθεν Ἰωσὴφ πρὸς τοὺς ἀδελφοὺς αὐτοῦ, ἐξέδυσαν Ἰωσὴφ τὸν χιτῶνα τὸν ποικίλον τὸν περὶ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Καὶ λαβόντες αὐτὸν, ἔῤῥιψαν εἰς τὸν λάκκον· ὁ δὲ λάκκος κενὸς, ὕδωρ οὐκ εἶχε. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ἐκάθισαν δὲ φαγεῖν ἄρτον· καὶ ἀναβλέψαντες τοῖς ὀφθαλμοῖς εἶδον, καὶ ἰδοὺ ὁδοιπόροι Ἰσμαηλῖται ἤρχοντο ἐκ Γαλαάδ· καὶ αἱ κάμηλοι αὐτῶν ἔγεμον θυμιαμάτων καὶ ῥητίνης καὶ στακτῆς. ἐπορεύοντο δὲ καταγαγεῖν εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Εἶπε δὲ Ἰούδας πρὸς τοὺς ἀδελφοὺς αὐτοῦ, τί χρήσιμον, ἐὰν ἀποκτείνωμεν τὸν ἀδελφὸν ἡμῶν, καὶ κρύψωμεν τὸ αἷμα αὐτοῦ; ");
INSERT INTO grcbrent_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Δεῦτε ἀποδώμεθα αὐτὸν τοῖς Ἰσμαηλίταις τούτοις· αἱ δὲ χεῖρες ἡμῶν μὴ ἔστωσαν ἐπʼ αὐτὸν, ὅτι ἀδελφὸς ἡμῶν καὶ σὰρξ ἡμῶν ἐστίν. Ἤκουσαν δὲ οἱ ἀδελφοὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Καὶ παρεπορεύοντο οἱ ἄνθρωποι οἱ Μαδιηναῖοι ἔμποροι, καὶ ἐξείλκυσαν καὶ ἀνεβίβασαν τὸν Ἰωσὴφ ἐκ τοῦ λάκκου· καὶ ἀπέδοντο τὸν Ἰωσὴφ τοῖς Ἰσμαηλίταις εἴκοσι χρυσῶν. Καὶ κατήγαγον τὸν Ἰωσὴφ εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ἀνέστρεψε δὲ Ῥουβὴν ἐπὶ τὸν λάκκον, καὶ οὐχ ὁρᾷ τὸν Ἰωσὴφ ἐν τῷ λάκκῳ· καὶ διέῤῥηξε τὰ ἱμάτια αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Καὶ ἐπέστρεψε πρὸς τοὺς ἀδελφοὺς αὐτοῦ, καὶ εἶπε, τὸ παιδάριον οὐκ ἔστιν· ἐγὼ δὲ ποῦ πορεύομαι ἔτι; ");
INSERT INTO grcbrent_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Λαβόντες δὲ τὸν χιτῶνα τοῦ Ἰωσὴφ, ἔσφαξαν ἔριφον αἰγῶν, καὶ ἐμόλυναν τὸν χιτῶνα τῷ αἵματι. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Καὶ ἀπέστειλαν τὸν χιτῶνα τὸν ποικίλον, καὶ εἰσήνεγκαν τῷ πατρὶ αὐτῶν· καὶ εἶπαν, τοῦτον εὕρομεν, ἐπίγνωθι εἰ χιτὼν τοῦ υἱοῦ σου ἐστὶν, ἢ οὔ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Καὶ ἐπέγνω αὐτὸν, καὶ εἶπε, χιτὼν τοῦ υἱοῦ μου ἐστί· θηρίον πονηρὸν κατέφαγεν αὐτόν· θηρίον ἥρπασε τὸν Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Διέῤῥηξε δὲ Ἰακὼβ τὰ ἱμάτια αὐτοῦ, καὶ ἐπέθετο σάκκον ἐπὶ τὴν ὀσφῦν αὐτοῦ, καὶ ἐπένθει τὸν υἱὸν αὐτοῦ ἡμέρας πολλάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Συνήχθησαν δὲ πάντες οἱ υἱοὶ αὐτοῦ καὶ αἱ θυγατέρες, καὶ ἦλθον παρακαλέσαι αὐτόν· καὶ οὐκ ἤθελε παρακαλεῖσθαι, λέγων, ὅτι καταβήσομαι πρὸς τὸν υἱόν μου πενθῶν εἰς ᾅδου· καὶ ἔκλαυσεν αὐτὸν ὁ πατὴρ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Οἱ δὲ Μαδιηναῖοι ἀπέδοντο τὸν Ἰωσὴφ εἰς Αἴγυπτον τῷ Πετεφρῇ τῷ σπάδοντι Φαραὼ ἀρχιμαγείρῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ἐγένετο δὲ ἐν τῷ καιρῷ ἐκείνῳ, κατέβη Ἰούδας ἀπὸ τῶν ἀδελφῶν αὐτοῦ, καὶ ἀφίκετο ἕως πρὸς ἄνθρωπον τινὰ Ὀδολλαμίτην, ᾧ ὄνομα Εἰράς. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Καὶ εἶδεν ἐκεῖ Ἰούδας θυγατέρα ἀνθρώπου Χαναναίου, ᾗ ὄνομα Σαυά· καὶ ἔλαβεν αὐτὴν, καὶ εἰσῆλθε πρὸς αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Καὶ συλλαβοῦσα ἔτεκεν υἱὸν, καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ἤρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Καὶ συλλαβοῦσα ἔτεκεν υἱὸν ἔτι, καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Αὐνάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Καὶ προσθεῖσα ἔτεκεν υἱὸν, καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Σηλώμ· αὕτη δὲ ἦν ἐν Χασβὶ, ἡνίκα ἔτεκεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Καὶ ἔλαβεν Ἰούδας γυναῖκα Ἢρ τῷ πρωτοτόκῳ αὐτοῦ, ᾗ ὄνομα Θάμαρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ἐγένετο δὲ Ἢρ πρωτότοκος Ἰούδα πονηρὸς ἔναντι Κυρίου· καὶ ἀπέκτεινεν αὐτὸν ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Εἶπε δὲ Ἰούδας τῷ Αὐνάν· εἴσελθε πρὸς τὴν γυναῖκα τοῦ ἀδελφοῦ σου, καὶ ἐπιγάμβρευσαι αὐτὴν, καὶ ἀνάστησον σπέρμα τῷ ἀδελφῷ σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Γνοὺς δὲ Αὐνὰν, ὅτι οὐκ αὐτῷ ἔσται τὸ σπέρμα, ἐγένετο ὅταν εἰσήρχετο πρὸς τὴν γυναῖκα τοῦ ἀδελφοῦ αὐτου, ἐξέχεεν ἐπὶ τὴν γῆν, τοῦ μὴ δοῦναι σπέρμα τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Πονηρὸν δὲ ἐφάνη ἐναντίον τοῦ Θεοῦ, ὅτι ἐποίησε τοῦτο· καὶ ἐθανάτωσε καὶ τοῦτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Εἶπε δὲ Ἰούδας Θάμαρ τῇ νύμφῃ αὐτοῦ, κάθου χήρα ἐν τῷ οἴκῳ τοῦ πατρός σου, ἕως μέγας γένηται Σηλὼμ ὁ υἱός μου· εἶπε γάρ, μή ποτε ἀποθάνῃ καὶ οὗτος, ὥσπερ καὶ οἱ ἀδελφοὶ αὐτοῦ. Ἀπελθοῦσα δὲ Θάμαρ ἐκάθητο ἐν τῷ οἴκῳ τοῦ πατρὸς αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ἐπληθύνθησαν δὲ αἱ ἡμέραι, καὶ ἀπέθανε Σαυὰ ἡ γυνὴ Ἰούδα· καὶ παρακληθεὶς Ἰούδας ἀνέβη ἐπὶ τοὺς κείροντας τὰ πρόβατα αὐτοῦ, αὐτὸς καὶ Εἰρὰς ὁ ποιμὴν αὐτοῦ ὁ Ὀδολλαμίτης εἰς Θαμνά. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Καὶ ἀπηγγέλε Θάμαρ τῇ νύμφῃ αὐτοῦ, λέγοντες, ἰδοὺ ὁ πενθερός σου ἀναβαίνει εἰς Θαμνὰ, κεῖραι τὰ πρόβατα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Καὶ περιελομένη τὰ ἱμάτια τῆς χηρεύσεως ἀφʼ ἑαυτῆς, περιέβαλε τὸ θέριστρον, καὶ ἐκαλλωπίσατο, καὶ ἐκάθισε πρὸς ταῖς πύλαις Αἰνὰν, ἥ ἐστιν ἐν παρόδῳ Θαμνά· ἴδε γὰρ ὅτι μέγας γέγονε Σηλὼμ, αὐτὸς δὲ οὐκ ἔδωκεν αὐτὴν αὐτῷ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Καὶ ἰδὼν αὐτὴν Ἰούδας ἔδοξεν αὐτὴν πόρνην εἶναι· κατεκαλύψατο γὰρ τὸ πρόσωπον αὐτῆς καὶ οὐκ ἐπέγνω αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ἐξέκλινε δὲ πρὸς αὐτὴν τὴν ὁδόν· καὶ εἶπεν αὐτῇ, ἔασόν με εἰσελθεῖν πρός σε· οὐ γὰρ ἔγνω, ὅτι νύμφη αὐτοῦ ἐστίν· ἡ δὲ εἶπε, τί μοι δώσεις, ἐὰν εἰσέλθῃς πρός με; ");
INSERT INTO grcbrent_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ὁ δὲ εἶπεν, ἐγώ σοι ἀποστελλῶ ἔριφον αἰγῶν ἐκ τῶν προβάτων μον· ἡ δὲ εἶπεν, ἐὰν δῷς μοι ἀῤῥαβῶνα, ἕως τοῦ ἀποστεῖλαί σε. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ὁ δὲ εἶπε, τίνα τὸν ἀῤῥαβῶνά σοι δώσω; ἡ δὲ εἶπε, τὸν δακτύλιόν σου, καὶ τὸν ὁρμίσκον, καὶ τὴν ῥάβδον τὴν ἐν τῇ χειρίσου. Καὶ ἔδωκεν αὐτῇ, καὶ εἰσῆλθε πρὸς αὐτήν· καὶ ἐν γαστρὶ ἔλαβεν ἐξ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Καὶ ἀναστᾶσα ἀπῆλθε, καὶ περιείλετο τὸ θέριστρον αὐτῆς ἀφʼ ἑαυτῆς, καὶ ἐνεδύσατο τὰ ἱμάτια τῆς χηρεύσεως αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ἀπέστειλε δὲ Ἰούδας τὸν ἔριφον ἐξ αἰγῶν ἐν χειρὶ τοῦ ποιμένος αὐτοῦ τοῦ Ὀδολλαμείτου, κομίσασθαι παρὰ τῆς γυναικὸς τὸν ἀῤῥαβῶνα· καὶ οὐχ εὗρεν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ἐπηρώτησε δὲ τοὺς ἄνδρας τοὺς ἐκ τοῦ τόπου, ποῦ ἐστιν ἡ πόρνη ἡ γενομένη ἐν Αἰνὰν ἐπὶ τῆς ὁδοῦ; καὶ εἶπαν, οὐκ ἦν ἐνταῦθα πόρνη. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Καὶ ἀπεστράφη πρὸς Ἰούδαν, καὶ εἶπεν, οὐχ εὗρον· καὶ οἱ ἄνθρωποι οἱ ἐκ τοῦ τόπου λέγουσι, μὴ εἶναι ὧδε πόρνην. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Εἶπε δὲ Ἰούδας, ἐχέτω αὐτά· ἀλλὰ μή ποτε καταγελασθῶμεν· ἐγὼ μὲν ἀπέσταλκα τὸν ἔριφον τοῦτον, σὺ δὲ οὐχ εὕρηκας. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ἐγένετο δὲ μετὰ τρίμηνον ἀνηγγέλη τῷ Ἰούδα, λέγοντες, ἐκπεπόρνευκε Θάμαρ ἡ νύμφη σου, καὶ ἰδοὺ ἐν γαστρὶ ἔχει ἐκ πορνείας· Εἶπε δὲ Ἰούδας, ἐξαγάγετε αὐτὴν, καὶ κατακαυθήτω. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Αὐτὴ δὲ ἀγομένη ἀπέστειλε πρὸς τὸν πενθερὸν αὐτὴς, λέγουσα, ἐκ τοῦ ἀνθρώπου οὕτινος ταῦτά ἐστιν, ἐγὼ ἐν γαστρὶ ἔχω· καὶ εἶπεν, ἐπίγνωθι τίνος ὁ δακτύλιος, καὶ ὁ ὁρμίσκος καὶ ἡ ῥάβδος αὕτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ἐπέγνω δὲ Ἰούδας, καὶ εἶπε, δεδικαίωται Θάμαρ ἢ ἐγώ· οὗ ἕνεκεν οὐκ ἔδωκα αὐτὴν Σηλὼμ τῷ υἱῷ μου· Καὶ οὐ προσέθετο ἔτι τοῦ γνῶναι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ἐγένετο δὲ ἡνίκα ἔτικτε, καὶ τῇδε ἦν δίδυμα ἐν τῇ γαστρὶ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ἐγένετο δὲ ἐν τῷ τίκτειν αὐτὴν, ὁ εἷς προεξήνεγκεν τὴν χεῖρα· λαβοῦσα δὲ ἡ μαῖα, ἔδησεν ἐπὶ τὴν χεῖρα αὐτοῦ κόκκινον, λέγουσα, οὗτος ἐξελεύσεται πρότερος. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ὡς δὲ ἐπισυνήγαγε τὴν χεῖρα, καὶ εὐθὺς ἐξῆλθεν ὁ ἀδελφὸς αὐτοῦ· ἡ δὲ εἶπε, τί διεκόπη διὰ σὲ φραγμός; καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Φαρές. ");
INSERT INTO grcbrent_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Καὶ μετὰ τοῦτο ἐξῆλθεν ὁ ἀδελφὸς αὐτοῦ, ἐφʼ ᾧ ἦν ἐπὶ τῇ χειρὶ αὐτοῦ τὸ κόκκινον· καὶ ἐκάλεσε τὸ ὄνομα αὐτοῦ, Ζαρά. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ἰωσὴφ δὲ κατήχθη εἰς Αἴγυπτον· καὶ ἐκτήσατο αὐτὸν Πετεφρὴς ὁ εὐνοῦχος Φαραὼ, ὁ ἀρχιμάγειρος, ἀνὴρ Αἰγύπτιος, ἐκ χειρῶν τῶν Ἰσμαηλιτῶν, οἳ κατήγαγον αὐτὸν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Καὶ ἦν Κύριος μετὰ Ἰωσήφ· καὶ ἦν ἀνὴρ ἐπιτυγχάνων· καὶ ἐγένετο ἐν τῷ οἴκῳ παρὰ τῷ κυρίῳ αὐτοῦ τῷ Αἰγυπτίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ἤδει δὲ ὁ κύριος αὐτοῦ, ὅτι ὁ Κύριος ἦν μετʼ αὐτοῦ, καὶ ὅσα ἐὰν ποιῇ, Κύριος εὐοδοῖ ἐν ταῖς χερσὶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Καὶ εὗρεν Ἰωσὴφ χάριν ἐναντίον τοῦ κυρίου αὐτοῦ, καὶ εὐηρέστησεν αὐτῷ. Καὶ κατέστησε αὐτὸν ἐπὶ τοῦ οἴκου αὐτοῦ· καὶ πάντα ὅσα ἦν αὐτῷ, ἔδωκε διὰ χειρὸς Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ἐγένετο δὲ μετὰ τὸ καταστῆναι αὐτὸν ἐπὶ τοῦ οἴκου αὐτοῦ, καὶ ἐπὶ πάντα ὅσα ἦν αὐτῷ, καὶ ηὐλόγησε Κύριος τὸν οἶκον τοῦ Αἰγυπτίου διὰ Ἰωσήφ· καὶ ἐγενήθη εὐλογία Κυρίου ἐν πᾶσι τοῖς ὑπάρχουσιν αὐτῷ ἐν τῷ οἴκῳ, καὶ ἐν τῷ ἀγρῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Καὶ ἐπέτρεψε πάντα ὅσα ἦν αὐτῷ, εἰς χεῖρας Ἰωσήφ· καὶ οὐκ ᾔδει τῶν καθʼ αὑτὸν οὐδὲν, πλὴν τοῦ ἄρτου, οὗ ἤσθιεν αὐτός. Καὶ ἦν Ἰωσὴφ καλὸς τῷ εἴδει, καὶ ὡραῖος τῇ ὄψει σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Καὶ ἐγένετο μετὰ τὰ ῥήματα ταῦτα, καὶ ἐπέβαλεν ἡ γυνὴ τοῦ κυρίου αὐτοῦ τοὺς ὀφθαλμοὺς αὐτῆς ἐπὶ Ἰωσήφ· καὶ εἶπεν, κοιμήθητι μετʼ ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ὁ δὲ οὐκ ἤθελεν· εἶπε δὲ τῇ γυναικὶ τοῦ κυρίου αὐτοῦ, εἰ ὁ κύριός μου οὐ γινώσκει διʼ ἐμὲ οὐδὲν ἐν τῷ οἴκῳ αὐτοῦ, καὶ πάντα ὅσα ἐστὶν αὐτῷ ἔδωκεν εἰς τὰς χεῖράς μου, ");
INSERT INTO grcbrent_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","καὶ οὐχ ὑπερέχει ἐν τῇ οἰκίᾳ ταύτῆ οὐθὲν ἐμοῦ, οὐδὲ ὑπεξῄρηται ἀπʼ ἐμοῦ οὐδὲν, πλὴν σοῦ, διὰ τὸ σὲ γυναῖκα αὐτοῦ εἶναι, καὶ πῶς ποιήσω τὸ ῥῆμα τὸ πονηρὸν τοῦτο, καὶ ἁμαρτήσομαι ἐναντίον τοῦ Θεοῦ; ");
INSERT INTO grcbrent_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ἡνίκα δὲ ἐλάλει τῷ Ἰωσὴφ ἡμέραν ἐξ ἡμέρας, καὶ οὐχ ὑπήκουεν αὐτῇ καθεύδειν μετʼ αὐτῆς, τοῦ συγγενέσθαι αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ἐγένετο δὲ τοιαύτη τις ἡμέρα, καὶ εἰσῆλθεν Ἰωσὴφ εἰς τὴν οἰκίαν ποιεῖν τὰ ἔργα αὐτοῦ, καὶ οὐθεὶς ἦν τῶν ἐν τῇ οἰκίᾳ ἔσω. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Καὶ ἐπεσπάσατο αὐτὸν τῶν ἱματίων, λέγουσα, κοιμήθητι μετʼ ἐμοῦ· καὶ καταλιπὼν τὰ ἱμάτια αὐτοῦ ἐν ταῖς χερσὶν αὐτῆς ἔφυγε, καὶ ἐξῆλθεν ἔξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Καὶ ἐγένετο ὡς εἶδεν ὅτι καταλιπὼν τὰ ἱμάτια αὐτοῦ ἐν ταῖς χερσὶν αὐτῆς ἔφυγε, καὶ ἐξῆλθεν ἔξω, ");
INSERT INTO grcbrent_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","καὶ ἐκάλεσε τοὺς ὄντας ἐν τῇ οἰκίᾳ, καὶ εἶπεν αὐτοῖς, λέγουσα, ἴδετε, εἰσήγαγε ἡμῖν παῖδα Ἐβραῖον, ἐμπαίζειν ἡμῖν· εἰσῆλθε πρός με, λέγων, κοιμήθητι μετʼ ἐμοῦ· καὶ ἐβόησα φωνῇ μεγάλῃ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ἐν δὲ τῷ ἀκοῦσαι αὐτὸν, ὅτι ὕψωσα τὴν φωνήν μου καὶ ἐβόησα, καταλιπὼν τὰ ἱμάτια αὐτοῦ παρʼ ἐμοὶ ἔφυγε, καὶ ἐξῆλθεν ἔξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Καὶ καταλιμπάνει τὰ ἱμάτια παρʼ ἑαυτῇ, ἕως ἦλθεν ὁ κύριος εἰς τὸν οἶκον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Καὶ ἐλάλησεν αὐτῷ κατὰ τὰ ῥήματα ταῦτα, λέγουσα, εἰσῆλθε πρός με ὁ παῖς ὁ Ἑβραῖος, ὃν εἰσήγαγες πρὸς ἡμᾶς, ἐμπαῖξαί μοι· καὶ εἶπέ μοι, κοιμηθήσομαι μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ὡς δὲ ἤκοῦσεν, ὅτι ὕψωσα τὴν φωνήν μου καὶ ἐβόησα, καταλιπὼν τὰ ἱμάτια αὐτοῦ παρʼ ἐμοὶ ἔφυγε, καὶ ἐξῆλθεν ἔξω. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ἐγένετο δὲ, ὡς ἤκουσεν ὁ κύριος τὰ ῥήματα τῆς γυναικὸς αὐτοῦ, ὅσα ἐλάλησε πρὸς αὐτὸν, λέγουσα, οὕτως ἐποίησέ μοι ὁ παῖς σου, καὶ ἐθυμώθη ὀργῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Καὶ λαβὼν ὁ κύριος Ἰωσὴφ, ἐνέβαλε αὐτὸν εἰς τὸ ὀχύρωμα, εἰς τὸν τόπον ἐν ᾧ οἱ δεσμῶται τοῦ βασιλέως κατέχονται ἐκεῖ ἐν τῷ ὀχυρώματι. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Καὶ ἦν Κύριος μετὰ Ἰωσὴφ, καὶ κατέχεεν αὐτοῦ ἔλεος· καὶ ἔδωκεν αὐτῷ χάριν ἐναντίον τοῦ ἀρχιδεσμοφύλακος. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Καὶ ἔδωκεν ὁ ἀρχιδεσμοφύλαξ τὸ δεσμωτήριον διὰ χειρὸς Ἰωσὴφ, καὶ πάντας τοὺς ἀπηγμένους ὅσοι ἐν τῷ δεσμωτηρίῳ, καὶ πάντα ὅσα ποιοῦσιν ἐκεῖ, αὐτὸς ἦν ποιῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Οὐκ ἦν ὁ ἀρχιδεσμοφύλαξ τοῦ δεσμωτηρίου γινώσκον διʼ αὐτὸν οὐθέν· πάντα γὰρ ἦν διὰ χειρὸς Ἰωσὴφ, διὰ τὸ τὸν Κύριον μετʼ αὐτοῦ εἶναι· καὶ ὅσα αὐτὸς ἐποίει, ὁ Κύριος εὐώδο ἐν ταῖς χερσὶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ἐγένετο δὲ μετὰ τὰ ῥήματα ταῦτα, ἥμαρτεν ὁ ἀρχιοινοχόος τοῦ βασιλέως Αἰγύπτου, καὶ ὁ ἀρχισιτοποιὸς, τῷ κυρίῳ αὐτῶν βασιλεῖ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Καὶ ὠργίσθη Φαραὼ ἐπὶ τοῖς δυσὶν εὐνούχοις αὐτοῦ, ἐπὶ τῷ ἀρχιοινοχόῳ, καὶ ἐπὶ τῷ ἀρχισιτοποιῷ· ");
INSERT INTO grcbrent_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Καὶ ἔθετο αὐτοὺς ἐν φυλακῇ εἰς τὸ δεσμωτήριον, εἰς τὸν τόπον, οὗ Ἰωσὴφ ἀπῆκτο ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Καὶ συνέστησεν ὁ ἀρχιδεσμώτης τῷ Ἰωσὴφ αὐτούς· καὶ παρέστη αὐτοῖς· ἦσαν δὲ ἡμέρας ἐν τῇ φυλακῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Καὶ εἶδον ἀμφότεροι ἐνύπνιον ἐν μιᾷ νυκτί· ἡ δὲ ὅρασις τοῦ ἐνυπνίου τοῦ ἀρχιοινοχόου καὶ ἀρχισιτοποιοῦ, οἳ ἦσαν τῷ βασιλεῖ Αἰγύπτου, οἱ ὄντες ἐν τῷ δεσμωτηρίῳ, ἦν αὕτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Εἰσῆλθε πρὸς αὐτοὺς Ἰωσὴφ τὸ πρωῒ, καὶ εἶδεν αὐτοὺς, καὶ ἦσαν τεταραγμένοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Καὶ ἠρώτα τοὺς εὐνούχους Φαραὼ, οἳ ἦσαν μετʼ αὐτοῦ ἐν τῇ φυλακῇ παρὰ τῷ κυρίῳ αὐτοῦ, λέγων, τί ὅτι τὰ πρόσωπα ὑμῶν σκυθρωπὰ σήμερον; ");
INSERT INTO grcbrent_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Οἱ δὲ εἶπαν αὐτῷ, ἐνύπνιον εἴδομεν, καὶ ὁ συγκρίνων οὐκ ἔστιν αὐτό· εἶπε δὲ αὐτοῖς Ἰωσὴφ, οὐχὶ διὰ τοῦ Θεοῦ ἡ διασάφησις αὐτῶν ἐστι; διηγήσασθε οὖν μοὶ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Καὶ διηγήσατο ὁ ἀρχιοινοχόος τὸ ἐνύπνιον αὐτοῦ τῷ Ἰωσήφ· καὶ εἶπεν, ἐν τῷ ὕπνῳ μου ἦν ἄμπελος ἐναντίον μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ἐν δὲ τῇ ἀμπέλῳ τρεῖς πυθμένες, καὶ αὐτὴ θάλλουσα, ἀνενηνοχυῖα βλαστούς· πέπειροι οἱ βότρυες σταφυλῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Καὶ τὸ ποτήριον Φαραὼ ἐν τῇ χειρί μου· καὶ ἔλαβον τὴν σταφυλὴν, καὶ ἐξέθλιψα αὐτὴν εἰς τὸ ποτήριον, καὶ ἔδωκα τὸ ποτήριον εἰς τὴν χεῖρα Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Καὶ εἶπεν αὐτῷ Ἰωσὴφ, τοῦτο ἡ σύγκρίσις αὐτοῦ· οἱ τρεῖς πυθμένες, τρεῖς ἡμέραι εἰσίν. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ετι τρεῖς ἡμέραι, καὶ μνησθήσεται Φαραὼ τῆς ἀρχῆς σου, καὶ ἀποκαταστήσει σε ἐπὶ τὴν ἀρχιοινοχοΐαν σου, καὶ δώσεις τὸ ποτήριον Φαραὼ εἰς τὴν χεῖρα αὐτοῦ κατὰ τὴν ἀρχήν σου τὴν προτέραν, ὡς ἦσθα οἰνοχοῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ἀλλὰ μνήσθητί μου διὰ σεαυτοῦ, ὅταν εὖ γενηταί σοι· καὶ ποιήσεις ἐν ἐμοὶ ἔλεος· καὶ μνησθήσῃ περὶ ἐμοῦ πρὸς Φαραὼ, καὶ ἐξάξεις με ἐκ τοῦ ὀχυρώματος τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ὅτι κλοπῇ ἐκλάπην ἐκ γῆς Ἑβραίων, καὶ ὧδε οὐκ ἐποίησα οὐδὲν, ἀλλʼ ἐνέβαλόν με εἰς τὸν λάκκον τοῦτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Καὶ εἶδεν ὁ ἀρχισιτοποιὸς ὅτι ὀρθῶς συνέκριεν· καὶ εἶπε τῷ Ἰωσὴφ, κᾀγὼ εἶδον ἐνύπνιον· καὶ ᾤμην τρία κανᾶ χονδριτῶν αἴρειν ἐπὶ τῆς κεφαλῆς μου· ");
INSERT INTO grcbrent_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ἐν δὲ κανῷ τῷ ἐπάνω ἀπὸ πάντων τῶν γενῶν, ὧν Φαραὼ ἐσθίει, ἔργον σιτοποιοῦ, καὶ τὰ πετεινὰ τοῦ οὐρανου κατήσθιεν αὐτὰ ἀπὸ τοῦ κανοῦ τοῦ ἐπάνω τῆς κεφαλῆς μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ἀποκριθεὶς δὲ Ἰωσὴφ εἶπεν αὐτῷ, αὕτη ἡ σύγκρισις αὐτοῦ· τὰ τρία κανᾶ, τρεῖς ἡμέραι εἰσίν· ");
INSERT INTO grcbrent_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ἔτι τριῶν ἡμερῶν, καὶ ἀφελεῖ Φαραὼ τὴν κεφαλήν σου ἀπὸ σου· καὶ κρεμάσει σε ἐπὶ ξύλου, καὶ φάγεται τὰ ὄρνεα τοῦ οὐρανοῦ τὰς σάρκας σου ἀπὸ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ἐγένετο δὲ ἐν τῇ ἡμέρᾳ τῇ τρίτῃ, ἡμέρα γενέσεως ἦν Φαραὼ, καὶ ἐποίει πότον πᾶσι τοῖς παισὶν αὐτοῦ· καὶ ἐμνήσθη τῆς ἀρχῆς τοῦ οἰνοχόου καὶ τῆς ἀρχῆς τοῦ σιτοποιοῦ ἐν μέσῳ τῶν παίδων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Καὶ ἀποκατέστησε τὸν ἀρχιοινοχόον ἐπὶ τὴν ἀρχὴν αὐτοῦ· καὶ ἔδωκε τὸ ποτήριον εἰς τὴν χεῖρα Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Τὸν δὲ ἀρχισιτοποιὸν ἐκρέμασεν, καθὰ συνέκρινεν αὐτοῖς Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Καὶ οὐκ ἐμνήσθη ὁ ἀρχιοινοχόος τοῦ Ἰωσὴφ, ἀλλαʼ ἐπελάθετο αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ἐγένετο δὲ μετὰ δύο ἔτη ἡμερῶν, Φαραὼ εἶδεν ἐνύπνιον· ᾤετο ἑστάναι ἐπὶ τοῦ ποταμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Καὶ ἰδοὺ ὥσπερ ἐκ τοῦ ποταμοῦ ἀνέβαινον ἐπτὰ βόες, καλαὶ τῷ εἴδει, καὶ ἐκλεκταὶ ταῖς σαρξὶ, καὶ ἐβόσκοντο ἐν τῷ Ἄχει. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ἄλλαι δὲ ἑπτὰ βόες ἀνέβαινον μετὰ ταύτας ἐκ τοῦ ποταμοῦ, αἰσχραὶ τῷ εἴδει, καὶ λεπταὶ ταῖς σαρξὶ, καὶ ἐνέμοντο παρὰ τὰς βόας ἐπὶ τὸ χεῖλος τοῦ ποταμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Καὶ κατέφαγον αἱ ἑπτὰ βόες αἱ αἰσχραὶ καὶ λεπταὶ ταῖς σαρξὶ τὰς ἑπτὰ βόας τὰς καλὰς τῷ εἴδει καὶ τὰς ἐκλεκτὰς ταῖς σαρξί· ἠγέρθη δὲ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Καὶ ἐνυπνιάσθη τὸ δεύτερον· καὶ ἰδοὺ ἑπτὰ στάχυες ἀνέβαινον ἐν τῷ πυθμένι ἑνὶ ἐκλεκτοὶ καὶ καλοί. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Καὶ ἰδοὺ ἑπτὰ στάχυες λεπτοὶ καὶ ἀνεμόφθοροι ἀνεφύοντο μετʼ αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Καὶ κατέπιον οἱ ἑπτὰ στάχυες οἱ λεπτοὶ καὶ ἀνεμόφθοροι τοὺς ἑπτὰ στάχυας τοὺς ἐκλεκτοὺς καὶ τοὺς πλήρεις· ἠγέρθη δὲ Φαραὼ, καὶ ἦν ἐνύπνιον. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ἐγένετο δὲ πρωῒ, καὶ ἐταράχθη ἡ ψυχὴ αὐτοῦ, καὶ ἀποστείλας ἐκάλεσε πάντας τοὺς ἐξηγητὰς Αἰγύπτου, καὶ πάντας τοὺς σοφοὺς αὐτῆς· καὶ διηγήσατο αὐτοῖς Φαραὼ τὸ ἐνύπνιον αὐτοῦ, καὶ οὐκ ἦν ὁ ἀπαγγέλλων αὐτὸ τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Καὶ ἐλάλησεν ὁ ἀρχιοινοχόος πρὸς Φαραὼ, λέγων, τὴν ἁμαρτίαν μου ἀναμιμνήσκω σήμερον. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Φαραὼ ὠργίσθη τοῖς παισὶν αὐτοῦ, καὶ ἔθετο ἡμᾶς ἐν φυλακῇ, ἐν τῷ οἴκῳ τοῦ ἀρχιμαγείρου, ἐμέ τε καὶ τὸν ἀρχισιτοποιόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Καὶ εἴδομεν ἐνύπνιον ἀμφότεροι ἐν νυκτὶ μιᾷ ἐγὼ καὶ αὐτὸς, ἕκαστος κατὰ τὸ αὐτοῦ ἐνύπνιον εἴδομεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ἦν δὲ ἐκεῖ μεθʼ ἡμῶν νεανίσκος παῖς Ἑβραῖος τοῦ ἀρχιμαγείρου, καὶ διηγησάμεθα αὐτῷ, καὶ συνέκρινεν ἡμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ἐγενήθη δὲ, καθὼς συνέκρινεν ἡμῖν οὕτω καὶ συνέβη, ἐμέ τε ἀποκατασταθῆναι ἐπὶ τὴν ἀρχήν μου, ἐκεῖνον δὲ κρεμασθῆναι. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ἀποστείλας δὲ Φαραὼ ἐκάλεσε τὸν Ἰωσήφ· καὶ ἐξήγαγον αὐτὸν ἀπὸ τοῦ ὀχυρώματος, καὶ ἐξύρησαν αὐτὸν, καὶ ἤλλαξαν τὴν στολὴν αὐτοῦ· καὶ ἦλθε πρὸς Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Εἶπε δὲ Φαραὼ πρὸς Ἰωσὴφ, ἐνύπνιον ἑώρακα, καὶ ὁ συγκρίνων οὐκ ἔστιν αὐτό· ἐγὼ δὲ ἀκήκοα περὶ σοῦ λεγόντων, ἀκούσαντά σε ἐνύπνια, συγκρῖναι αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ἀποκριθεὶς δὲ Ἰωσὴφ τῷ Φαραὼ εἶπεν, ἄνευ τοῦ Θεοῦ οὐκ ἀποκριθήσεται τὸ σωτήριον Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ἐλάλησε δὲ Φαραὼ τῷ Ἰωσὴφ, λέγων, ἐν τῷ ὕπνῳ μου ᾤμην ἑστάναι παρὰ τὸ χεῖλος τοῦ ποταμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Καὶ ὥσπερ ἐκ τοῦ ποταμοῦ ἀνέβαινον ἑπτὰ βόες καλαὶ τῷ εἴδει καὶ ἐκλεκταὶ ταῖς σαρξὶ, καὶ ἐνέμοντο ἐν τῷ Ἄχει. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Καὶ ἰδοὺ ἑπτὰ βόες ἕτεραι ἀνέβαινον ὀπίσω αὐτῶν ἐκ τοῦ ποταμοῦ, πονηραὶ καὶ αἰσχραὶ τῷ εἴδει, καὶ λεπταὶ ταῖς σαρξὶν, οἵας οὐκ εἶδον τοιαύτας ἐν ὅλῃ γῇ Αἰγύπτου αἰσχροτέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Καὶ κατέφαγον αἱ ἑπτὰ βόες αἱ αἰσχραὶ καὶ λεπταὶ τὰς ἑπτὰ βόας τὰς πρώτας τὰς καλὰς καὶ τὰς ἐκλεκτάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Καὶ εἰσῆλθον εἰς τὰς κοιλίας αὐτῶν· καὶ οὑ διάδηλοι ἐγένοντο, ὅτι εἰσῆλθον εἰς τὰς κοιλίας αὐτῶν· καὶ αἱ ὄψεις αὐτῶν αἰσχραὶ, καθὰ καὶ τὴν ἀρχήν· ἐξεγερθεὶς δὲ ἐκοιμήθην. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Καὶ εἶδον πάλιν ἐν τῷ ὕπνῳ μου, καὶ ὥσπερ ἑπτὰ στάχυες ἀνέβαινον ἐν πυθμένι ἑνὶ πλήρεις καὶ καλοί· ");
INSERT INTO grcbrent_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ἄλλοι δὲ ἑπτὰ στάχυες λεπτοὶ καὶ ἀνεμόφθοροι ἀνεφύοντο ἐχόμενοι αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Καὶ κατέπιον οἱ ἑπτὰ στάχυες οἱ λεπτοὶ καὶ ἀνεμόφθοροι τοὺς ἑπτὰ στάχυας τοὺς καλοὺς καὶ τοὺς πλήρεις· εἶπα οὖν τοῖς ἐξῆγηταῖς, καὶ οὐκ ἦν ὁ ἀπαγγέλλων μοι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Καὶ εἶπεν Ἰωσὴφ τῷ Φαραὼ, τὸ ἐνύπνιον Φαραὼ ἕν ἐστιν· ὅσα ὁ Θεὸς ποιεῖ, ἔδειξε τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Αἱ ἑπτὰ βόες αἱ καλαὶ, ἑπτὰ ἔτη ἐστί· καὶ οἱ ἑπτὰ στάχυες οἱ καλοὶ, ἑπτὰ ἔτη ἐστί· τὸ ἐνύπνιον Φαραὼ ἕν ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Καὶ αἱ ἑπτὰ βόες αἱ λεπταὶ, αἱ ἀναβαίνουσαι ὀπίσω αὐτῶν, ἑπτὰ ἔτη ἐστί· καὶ οἱ ἑπτὰ στάχυες οἱ λεπτοὶ καὶ ἀνεμόφθοροι, ἑπτὰ ἔτη ἐστί· ἔσονται ἑπτὰ ἔτη λιμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Τὸ δὲ ῥῆμα ὃ εἴρηκα Φαραὼ, ὅσα ὁ Θεὸς ποιεῖ, ἔδειξε τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ἰδοὺ ἑπτὰ ἔτη ἔρχεται εὐθηνία πολλὴ ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ἥξει δὲ ἑπτὰ ἔτη λιμοῦ μετὰ ταῦτα· καὶ ἐπιλήσονται τῆς πλησμονῆς τῆς ἐσομένης ἐν ὅλῃ Αἰγύπτῳ· καὶ ἀναλώσει ὁ λιμὸς τῆν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Καὶ οὐκ ἐπιγνωσθήσεται ἡ εὐθηνία ἐπὶ τῆς γῆς ἀπὸ τοῦ λιμοῦ τοῦ ἐσομένου μετὰ ταῦτα· ἰσχυρὸς γὰρ ἔσται σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Περὶ δὲ τοῦ δευτερῶσαι τὸ ἐνύπνιον Φαραὼ δὶς, ὅτι ἀληθὲς ἔσται τὸ ῥῆμα τὸ παρὰ τοῦ Θεοῦ· καὶ ταχυνεῖ ὁ Θεὸς τοῦ ποιῆσαι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Νῦν οὖν σκέψαι ἄνθρωπον φρόνιμον καὶ συνετὸν, καὶ κατάστησον αὐτὸν ἐπὶ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Καὶ ποιησάτω Φαραὼ καὶ καταστησάτω τοπάρχας ἐπὶ τῆς γῆς· καὶ ἀποπεμπτωσάτωσαν πάντα τὰ γεννήματα τῆς γῆς Αἰγύπτου τῶν ἑπτὰ ἐτῶν τῆς εὐθηνίας, ");
INSERT INTO grcbrent_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","καὶ συναγαγέτωσαν πάντα τὰ βρώματα τῶν ἑπτὰ ἐτῶν τῶν ἐρχομένων τῶν καλῶν τούτων· καὶ συναχθήτω ὁ σῖτος ὑπὸ χεῖρα Φαραώ· βρώματα ἐν ταῖς πόλεσι φυλαχθήτω. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Καὶ ἔσται τὰ βρώματα τὰ πεφυλαγμένα τῇ γῇ εἰς τὰ ἑπτὰ ἔτη τοῦ λιμοῦ, ἃ ἔσονται ἐν γῇ Αἰγύπτου, καὶ οὐκ ἐκτριβήσεται ἡ γῆ ἐν τῷ λιμῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ἤρεσε δὲ τὸ ῥῆμα ἐναντίον Φαραὼ, καὶ ἐναντίον πάντων τῶν παίδων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Καὶ εἶπε Φαραὼ πᾶσι τοῖς παισὶν αὐτοῦ, μῆ εὑρήσομεν ἄνθρωπον τοιοῦτον, ὃς ἔχει πνεῦμα Θεοῦ ἐν αὐτῷ; ");
INSERT INTO grcbrent_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Εἶπε δὲ Φαραὼ τῷ Ἰωσὴφ, ἐπειδὴ ἔδειξεν ὁ Θεός σοι πάντα ταῦτα, οὐκ ἔστιν ἄνθρωπος φρονιμώτερος καὶ συνετώτερός σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Σὺ ἔσῃ ἐπὶ τῷ οἴκῳ μου, καὶ ἐπὶ τῷ στόματί σου ὑπακούσεται πᾶς ὁ λαός μου· πλὴν τὸν θρόνον ὑπερέξω σου ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Εἶπε δὲ Φαραὼ τῷ Ἰωσὴφ, ἰδοὺ καθίστημί σε σήμερον ἐπὶ πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Καὶ περιελόμενος Φαραὼ τὸν δακτύλιον ἀπὸ τῆς χειρὸς αὐτοῦ, περίεθηκεν αὐτὸν ἐπὶ τὴν χεῖρα Ἰωσὴφ, καὶ ἐνέδυσεν αὐτὸν στολὴν βυσσίνην, καὶ περιέθηκε κλοιὸν χρυσοῦν περὶ τὸν τράχηλον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Καὶ ἀνεβίβασεν αὐτὸν ἐπὶ τὸ ἅρμα τὸ δεύτερον τῶν αὐτοῦ· καὶ ἐκήρυξεν ἔμπροσθεν αὐτοῦ κήρυξ· καὶ κατέστησεν αὐτὸν ἐφʼ ὅλης γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Εἶπε δὲ Φαραὼ τῷ Ἰωσὴφ, ἐγὼ Φαραώ· ἄνευ σοῦ οὐκ ἐξαρεῖ οὐθεὶς τὴν χεῖρα αὐτοῦ ἐπὶ πάσης γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Καὶ ἐκάλεσε Φαραὼ τὸ ὄνομα Ἰωσὴφ, Ψονθομφανήχ· καὶ ἔδωκεν αὐτῷ τὴν Ἀσενὲθ θυγατέρα Πετεφρῆ ἱερέως Ἡλιουπόλεως αὐτῷ εἰς γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ἰωσὴφ δὲ ἦν ἐτῶν τριάκοντα, ὅτε ἔστη ἐναντίον Φαραὼ βασιλέως Αἰγύπτου· ἐξῆλθε δὲ Ἰωσὴφ ἀπὸ προσώπου Φαραὼ, καὶ διῆλθε πᾶσαν γῆν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Καὶ ἐποίησεν ἡ γῆ ἐν τοῖς ἑπτὰ ἔτεσι τῆς εὐθηνίας δράγματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Καὶ συνήγαγε πάντα τὰ βρώματα τῶν ἑπτὰ ἐτῶν, ἐν οἷς ἦν ἡ εὐθηνία ἐν τῇ γῇ Αἰγύπτου· καὶ ἔθηκε τὰ βρώματα ἐν ταῖς πόλεσι· βρώματα τῶν πεδίων τῆς πόλεως τῶν κύκλῳ αὐτῆς ἔθηκεν ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Καὶ συνήγαγεν Ἰωσὴφ σῖτον ὡσεὶ τὴν ἄμμον τῆς θαλάσσης πολὺν σφόδρα, ἕως οὐκ ἠδύνατο ἀριθμηθῆναι, οὐ γὰρ ἦν ἀριθμός. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Τῷ δὲ Ἰωσὴφ ἐγένοντο υἱοὶ δύο πρὸ τοῦ ἐλθεῖν τὰ ἑπτὰ ἔτη τοῦ λιμοῦ, οὓς ἔτεκεν αὐτῷ Ἀσενὲθ ἡ θυγάτηρ Πετεφρῆ ἱερέως Ἡλιουπόλεως. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ἐκάλεσε δὲ Ἰωσὴφ τὸ ὄνομα τοῦ πρωτοτόκου, Μανασσῆ· ὅτι ἐπιλαθέσθαι με ἐποίησεν ὁ Θεὸς πάντων τῶν πόνων μου, καὶ πάντων τῶν τοῦ πατρός μου· ");
INSERT INTO grcbrent_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Τὸ δὲ ὄνομα τοῦ δευτέρου ἐκάλεσεν, Ἐφραίμ· ὅτι ηὔξησέ με ὁ Θεὸς ἐν γῇ ταπεινώσεώς μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Παρῆλθον δὲ τὰ ἑπτὰ ἔτη τῆς εὐθηνίας, ἃ ἐγένοντο ἐν τῇ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Καὶ ἤρξατο τὰ ἑπτὰ ἔτη τοῦ λιμοῦ ἔρχεσθαι, καθὰ εἶπεν Ἰωσήφ· καὶ ἐγένετο λιμὸς ἐν πάσῃ τῇ γῇ· ἐν δὲ πάσῃ τῇ γῇ Αἰγύπτου ἦσαν ἄρτοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Καὶ ἐπείνασε πᾶσα ἡ γῆ Αἰγύπτου· ἔκραξε δὲ ὁ λαὸς πρὸς Φαραὼ περὶ ἄρτων· εἶπε δὲ Φαραὼ πᾶσι τοῖς Αἰγυπτίοις, πορεύεσθε πρὸς Ἰωσὴφ, καὶ ὃ ἐὰν εἴπῃ ὑμῖν, ποιήσατε. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Καὶ ὁ λιμὸς ἦν ἐπὶ προσώπου πάσης τῆς γῆς· ἀνέῳξε δὲ Ἰωσὴφ πάντας τοὺς σιτοβολῶνας, καὶ ἐπώλει πᾶσι τοῖς Αἰγυπτίοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Καὶ πᾶσαι αἱ χῶραι ἦλθον εἰς Αἴγυπτον, ἀγοράζειν πρὸς Ἰωσήφ· ἐπεκράτησε γὰρ ὁ λιμὸς ἐν πάσῃ τῇ γῇ· ");
INSERT INTO grcbrent_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ἰδὼν δὲ Ἰακὼβ ὅτι ἐστὶ πράσις ἐν Αἰγύπτῳ, εἶπε τοῖς υἱοῖς αὐτοῦ, ἱνατί ῥαθυμεῖτε; ");
INSERT INTO grcbrent_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ἰδοὺ ἀκήκοα, ὅτι ἐστὶ σῖτος ἐν Αἰγύπτῳ· κατάβητε ἐκεὶ, καὶ πρίασθε ἡμῖν μικρὰ βρώματα, ἵνα ζήσωμεν καὶ μὴ ἀποθάνωμεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Κατέβησαν δὲ οἱ ἀδελφοὶ Ἰωσὴφ οἱ δέκα, πρίασθαι σῖτον ἐξ Αἰγύπτου· ");
INSERT INTO grcbrent_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Τὸν δὲ Βενιαμὶν, τὸν ἀδελφὸν Ἰωσὴφ, οὐκ ἀπέστειλε μετὰ τῶν ἀδελφῶν αὐτοῦ· εἶπε γὰρ, μή ποτε συμβῇ αὐτῷ μαλακία. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ἦλθον δὲ οἱ υἱοὶ Ἰσραὴλ ἀγοράζειν μετὰ τῶν ἐρχομένων· ἦν γὰρ ὁ λιμὸς ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ἰωσὴφ δὲ ἦν ὁ ἄρχων τῆς γῆς· οὗτος ἐπώλει παντὶ τῷ λαῷ τῆς γῆς· ἐλθόντες δὲ οἱ ἀδελφοὶ Ἰωσὴφ προσεκύνησαν αὐτῷ ἐπὶ πρόσωπον ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ἰδὼν δὲ Ἰωσὴφ τοὺς ἀδελφοὺς αὐτοῦ, ἐπέγνω· καὶ ἠλλοτριοῦτο ἀπʼ αὐτῶν, καὶ ἐλάλησεν αὐτοῖς σκληρά· καὶ εἶπεν αὐτοῖς, πόθεν ἥκατε; οἱ δὲ εἶπον, ἐκ γῆς Χαναὰν, ἀγοράσαι βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ἐπέγνω δὲ Ἰωσὴφ τοὺς ἀδελφοὺς αὐτοῦ· αὐτοὶ δὲ οὐκ ἐπέγνωσαν αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Καὶ ἐμνήσθη Ἰωσὴφ τῶν ἐνυπνίων αὐτοῦ, ὧν εἶδεν αὐτός· καὶ εἶπεν αὐτοῖς, κατάσκοποί ἐστε, κατανοῆσαι τὰ ἴχνη τῆς χώρας ἥκατε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Οἱ δὲ εἶπαν, οὐχὶ, κύριε· οἱ παῖδές σου ἤλθομεν πρίασθαι βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Πάντες ἐσμὲν υἱοὶ ἑνὸς ἀνθρώπου· εἰρηνικοί ἐσμεν, οὐκ εἰσιν οἱ παῖδές σου κατάσκοποι. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Εἶπε δὲ αὐτοῖς, οὐχί· ἀλλὰ τὰ ἴχνη τῆς γῆς ἤλθετε ἰδεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Οἱ δὲ εἶπαν, δώδεκά ἐσμεν οἱ παῖδές σου ἀδελφοὶ ἐν γῇ Χαναάν· καὶ ἰδοὺ ὁ νεώτερος μετὰ τοῦ πατρὸς ἡμῶν σήμερον· ὁ δὲ ἕτερος οὐχ ὑπάρχει. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Εἶπε δὲ αὐτοῖς Ἰωσὴφ, τοῦτό ἐστιν ὃ εἴρηκα ὑμῖν, λέγων, ὅτι κατάσκοποί ἐστε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ἐν τούτῳ φανεῖσθε· νὴ τὴν ὑγίειαν Φαραὼ, οὐ μὴ ἐξέλθητε ἐντεῦθεν, ἐὰν μὴ ὁ ἀδελφὸς ὑμῶν ὁ νεώτερος ἔλθῃ ὧδε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ἀποστείλατε ἐξ ὑμῶν ἕνα, καὶ λάβετε τὸν ἀδελφὸν ὑμῶν· ὑμεῖς δὲ ἀπάχθητε ἕως τοῦ φανερὰ γενέσθαι τὰ ῥήματα ὑμῶν, εἰ ἀληθεύετε ἢ οὔ· εἰ δὲ μὴ, νὴ τὴν ὑγίειαν Φαραὼ, ἦ μὴν κατάσκοποί ἐστε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Καὶ ἔθετο αὐτοὺς ἐν φυλακῇ ἡμέρας τρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Εἶπε δὲ αὐτοῖς τῇ ἡμέρᾳ τῇ τρίτῃ, τοῦτο ποιήσατε, καὶ ζήσεσθε· τὸν Θεὸν γὰρ ἐγὼ φοβοῦμαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Εἰ εἰρηνικοί ἐστε, ἀδελφὸς ὑμῶν κατασχεθήτω εἷς ἐν τῇ φυλακῇ· αὐτοὶ δὲ βαδίσατε, καὶ ἀπαγάγετε τὸν ἀγορασμὸν τῆς σιτοδοσίας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Καὶ τὸν ἀδελφὸν ὑμῶν τὸν νεώτερον ἀγάγετε πρός με, καὶ πιστευθήσονται τὰ ῥήματα ὑμῶν· εἰ δὲ μὴ, ἀποθανεῖσθε. Ἐποίησαν δὲ οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Καὶ εἶπεν ἕκαστος πρὸς τὸν ἀδελφὸν αὐτοῦ, ναὶ, ἐν ἁμαρτίαις γάρ ἐσμεν περὶ τοῦ ἀδελφοῦ ἡμῶν, ὅτι ὑπερίδομεν τὴν θλίψιν τῆς ψυχῆς αὐτοῦ, ὅτε κατεδέετο ἡμῶν, καὶ οὐκ εἰσηκούσαμεν αὐτοῦ· καὶ ἕνεκεν τούτου ἐπῆλθεν ἐφʼ ἡμᾶς ἡ θλίψις αὕτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ἀποκριθεὶς δὲ Ῥουβὴν εἶπεν αὐτοῖς, οὐκ ἐλάλησα ὑμῖν, λέγων, μὴ ἀδικήσητε τὸ παιδάριον, καὶ οὐκ εἰσηκούσατέ μου; καὶ ἰδοὺ τὸ αἷμα αὐτοῦ ἐκζητεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Αὐτοὶ δὲ οὐκ ᾔδεισαν, ὅτι ἀκούει Ἰωσήφ· ὁ γὰρ ἑρμηνευτὴς ἀνὰ μέσον αὐτῶν ἦν· ");
INSERT INTO grcbrent_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ἀποστραφεὶς δὲ ἀπʼ αὐτῶν ἔκλαυσεν Ἰωσήφ· καὶ πάλιν προσῆλθε πρὸς αὐτοὺς, καὶ εἶπεν αὐτοῖς· καὶ ἔλαβε τὸν Συμεὼν ἀπʼ αὐτῶν, καὶ ἔδησεν αὐτὸν ἐναντίον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ἐνετείλατο δὲ Ἰωσὴφ ἐμπλῆσαι τὰ ἀγγεῖα αὐτῶν σίτου, καὶ ἀποδοῦναι τὸ ἀργύριον αὐτῶν ἑκάστῳ εἰς τὸν σάκκον αὐτοῦ, καὶ δοῦναι αὐτοῖς ἐπισιτισμὸν εἰς τὴν ὁδόν· καὶ ἐγενήθη αὐτοῖς οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Καὶ ἐπιθέντες τὸν σῖτον ἐπὶ τοῦς ὄνους αὐτῶν, ἀπῆλθον ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Λύσας δὲ εἷς τὸν μάρσιππον αὐτοῦ, δοῦναι χορτάσματα τοῖς ὄνοις αὐτοῦ, οὗ κατέλυσαν, καὶ εἶδε τὸν δεσμὸν τοῦ ἀργυρίου αὐτοῦ, καὶ ἦν ἐπάνω τοῦ στόματος τοῦ μαρσίππου. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Καὶ εἶπε τοῖς ἀδελφοῖς αὐτοῦ, ἀπεδόθη μοι τὸ ἀργύριον, καὶ ἰδοὺ τοῦτο ἐν τῷ μαρσίππῳ μου· καὶ ἐξέστη ἡ καρδία αὐτῶν, καὶ ἐταράχθησαν πρὸς ἀλλήλους, λέγοντες, τί τοῦτο ἐποίησεν ὁ Θεὸς ἡμῖν; ");
INSERT INTO grcbrent_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ἦλθον δὲ πρὸς Ἰακὼβ τὸν πατέρα αὐτῶν εἰς γὴν Χαναὰν, καὶ ἀπήγγειλαν αὐτῷ πάντα τὰ συμβάντα αὐτοῖς, λέγοντες, ");
INSERT INTO grcbrent_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Λελάληκεν ὁ ἄνθρωπος ὁ κύριος τῆς γῆς πρὸς ἡμᾶς σκληρὰ, καὶ ἔθετο ἡμᾶς ἐν φυλακῇ, ὡς κατασκοπεύοντας τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Εἴπαμεν δὲ αὐτῷ, εἰρήνικοί ἐσμεν, οὐκ ἐσμὲν κατάσκοποι. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Δώδεκα ἀδελφοί ἐσμεν, υἱοὶ τοῦ πατρὸς ἡμῶν· ὁ εἷς οὐχ ὑπάρχει· ὁ δὲ μικρὸς μετὰ τοῦ πατρὸς ἡμῶν σήμερον ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Εἶπε δὲ ἡμῖν ὁ ἄνθρωπος ὁ κύριος τῆς γῆς, ἐν τούτῳ γνώσομαι, ὅτι εἰρηνικοί ἐστε· ἀδελφὸν ἕνα ἄφετε ὧδε μετʼ ἐμοῦ· τὸν δὲ ἀγορασμὸν τῆς σιτοδοσίας τοῦ οἴκου ὑμῶν λαβόντες ἀπέλθατε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Καὶ ἀγάγετε πρός με τὸν ἀδελφὸν ὑμῶν τὸν νεώτερον· καὶ γνώσομαι ὅτι οὐ κατάσκοποί ἐστε, ἀλλʼ ὅτι εἰρηνικοί ἐστε· καὶ τὸν ἀδελφὸν ὑμῶν ἀποδώσω ὑμῖν, καὶ τῇ γῇ ἐμπορεύσεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ἐγένετο δὲ ἐν τῷ κατακενοῦν αὐτοὺς τοὺς σάκκους αὐτῶν, καὶ ἦν ἑκάστου ὁ δεσμὸς τοῦ ἀργυρίου ἐν τῷ σάκκῳ αὐτῶν· καὶ εἶδον τοὺς δεσμοὺς τοῦ ἀργυρίου αὐτῶν αὐτοὶ, καὶ ὁ πατὴρ αὐτῶν, καὶ ἐφοβήθησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Εἶπε δὲ αὐτοῖς Ἰακὼβ ὁ πατὴρ αὐτῶν, ἐμὲ ἠτεκνώσατε· Ἰωσὴφ οὐκ ἔστι, Συμεὼν οὐκ ἔστι, καὶ τὸν Βενιαμὶν λήψεσθε; ἐπʼ ἐμὲ ἐγένετο ταῦτα πάντα. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Εἶπε δὲ Ῥουβὴν τῷ πατρὶ αὐτῶν, λέγων, τοὺς δύο υἱούς μου ἀπόκτεινον, ἐὰν μὴ ἀγάγω αὐτὸν πρὸς σέ· δὸς αὐτὸν εἰς τὴν χεῖρά μου, κᾀγὼ ἀνάξω αὐτὸν πρὸς σέ. ");
INSERT INTO grcbrent_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ὁ δὲ εἶπεν, οὐ καταβήσεται ὁ υἱός μου μεθʼ ὑμῶν, ὅτι ὁ ἀδελφὸς αὐτοῦ ἀπέθανε, καὶ αὐτὸς μόνος καταλέλειπται· καὶ συμβήσεται αὐτὸν μαλακισθῆναι ἐν τῇ ὁδῷ, ᾗ ἐὰν πορεύησθε, καὶ κατάξετέ μου τὸ γῆρας μετὰ λύπης εἰς ᾅδοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ὁ δὲ λιμὸς ἐνίσχυσεν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ἐγένετο δὲ ἡνίκα συνετέλεσαν καταφαγεῖν τὸν σῖτον, ὃν ἤνεγκαν ἐξ Αἰγύπτου, καὶ εἶπεν αὐτοῖς ὁ πατὴρ αὐτῶν, πάλιν πορευθέντες πρίασθε ἡμῖν μικρὰ βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Εἶπε δὲ αὐτῷ Ἰούδας, λέγων, διαμαρτυρίᾳ μεμαρτύρηται ἡμῖν ὁ ἄνθρωπος ὁ κύριος τῆς γῆς, λέγων, οὐκ ὄψεσθε τὸ πρόσωπόν μου, ἐὰν μὴ ὁ ἀδελφὸς ὑμῶν ὁ νεώτερος μεθʼ ὑμῶν ᾖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Εἰ μὲν οὖν ἀποστέλλῃς τὸν ἀδελφὸν ἡμῶν μεθʼ ἡμῶν, καταβησόμεθα, καὶ ἀγοράσομέν σοι βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Εἰ δὲ μὴ ἀποστέλλῃς τὸν ἀδελφὸν ἡμῶν μεθʼ ἡμῶν, οὐ πορευσόμεθα· ὁ γὰρ ἄνθρωπος εἶπεν ἡμῖν, λέγων, οὐκ ὄψεσθέ μου τὸ πρόσωπον, ἐὰν μὴ ὁ ἀδελφὸς ὑμῶν ὁ νεώτερος μεθʼ ὑμῶν ᾖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Εἶπε δὲ Ἰσραὴλ, τί ἐκακοποιήσατέ με, ἀναγγείλαντες τῷ ἀνθρώπῳ ὅτι ἐστὶν ὑμῖν ἀδελφός; ");
INSERT INTO grcbrent_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Οἱ δὲ εἶπαν, ἐρωτῶν ἐπηρώτησεν ἡμᾶς ὁ ἄνθρωπος καὶ τὴν γενεὰν ἡμῶν, λέγων, εἰ ἔτι ὁ πατὴρ ὑμῶν ζῇ, καὶ εἰ ἔστιν ὑμῖν ἀδελφός· καὶ ἀπηγγείλαμεν αὐτῷ κατὰ τὴν ἐπερώτησιν ταύτην· μὴ ᾔδειμεν ὅτι ἐρεῖ ἡμῖν, ἀγάγετε τὸν ἀδελφὸν ὑμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Εἶπε δὲ Ἰούδας πρὸς Ἰσραὴλ τὸν πατέρα αὐτοῦ, ἀπόστειλον τὸ παιδάριον μετʼ ἐμοῦ· καὶ ἀναστάντες πορευσόμεθα, ἵνα ζῶμεν καὶ μὴ ἀποθάνωμεν καὶ ἡμεῖς, καὶ σὺ, καὶ ἡ ἀποσκευὴ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ἐγὼ δὲ ἐκδέχομαι αὐτόν· ἐκ χειρός μου ζήτησον αὐτόν· ἐὰν μὴ ἀγάγω αὐτὸν πρός σε, καὶ στήσω αὐτὸν ἐναντίον σου, ἡμαρτηκὼς ἔσομαι εἰς σὲ πάσας τὰς ἡμέραν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Εἰ μὴ γὰρ ἐβραδύναμεν, ἤδη ἂν ὑπεστρέψαμεν δίς. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Εἶπε δὲ αὐτοῖς Ἰσραὴλ ὁ πατὴρ αὐτῶν, εἰ οὕτως ἐστὶ, τοῦτο ποιήσατε· λάβετε ἀπὸ τῶν καρπῶν τῆς γῆς ἐν τοῖς ἀγγείοις ὑμῶν, καὶ καταγάγετε τῷ ἀνθρώπῳ δῶρα τῆς ῥητίνης, καὶ τοῦ μέλιτος, θυμίαμά τε καὶ στακτὴν, καὶ τερέινθον, καὶ κάρυα. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Καὶ τὸ ἀργύριον δισσὸν λάβετε ἐν ταῖς χερσὶν ὑμῶν· τὸ ἀργύριον τὸ ἀποστραφὲν ἐν τοῖς μαρσίπποις ὑμῶν ἀποστρέψατε μεθʼ ὑμῶν· μή ποτε ἀγνόημά ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Καὶ τὸν ἀδελφὸν ὑμῶν λάβετε· καὶ ἀναστάντες κατάβητε πρὸς τὸν ἄνθρωπον. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ὁ δὲ Θεός μου δώῃ ὑμῖν χάριν ἐναντίον τοῦ ἀνθρώπου καὶ ἀποστείλαι τὸν ἀδελφὸν ὑμῶν τὸν ἕνα, καὶ τὸν Βενιαμίν· ἐγὼ μὲν γὰρ καθάπερ ἠτέκνωμαι, ἠτέκνωμαι. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Λαβόντες δὲ οἱ ἄνδρες τὰ δῶρα ταῦτα καὶ τὸ ἀργύριον διπλοῦν, ἔλαβον ἐν ταῖς χερσὶν αὐτῶν καὶ τὸν Βενιαμείν· καὶ ἀναστάντες κατέβησαν εἰς Αἴγυπτον· καὶ ἔστησαν ἐναντίον Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Εἶδε δὲ Ἰωσὴφ αὐτοὺς, καὶ τὸν Βενιαμὶν τὸν ἀδελφὸν αὐτοῦ τὸν ὁμομήτριον· καὶ εἶπε τῷ ἐπὶ τῆς οἰκίας αὐτοῦ, εἰσάγαγε τοὺς ἀνθρώπους εἰς τὴν οἰκίαν, καὶ σφάξον θύματα, καὶ ἑτοίμασον· μετʼ ἐμοῦ γὰρ φάγονται οἱ ἄνθρωποι ἄρτους τὴν μεσημβρίαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ἐποίησε δὲ ὁ ἄνθρωπος καθὰ εἶπεν Ἰωσήφ· καὶ εἰσήγαγε τοὺς ἀνθρώπους εἰς τὸν οἶκον Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ἰδόντες δὲ οἱ ἄνδρες ὅτι εἰσήχθησαν εἰς τὸν οἶκον τοῦ Ἰωσήφ, εἶπαν, διὰ τὸ ἀργύριον τὸ ἀποστραφὲν ἐν τοῖς μαρσίπποις ἡμῶν τὴν ἀρχὴν, ἡμεῖς εἰσαγόμεθα, τοῦ συκοφαντῆσαι ἡμᾶς καὶ ἐπιθέσθαι ἡμῖν, τοῦ λαβεῖν ἡμᾶς εἰς παῖδας, καὶ τοὺς ὄνους ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Προσελθόντες δὲ πρὸς τὸν ἄνθρωπον τὸν ἐπὶ τοῦ οἴκου τοῦ Ἰωσὴφ, ἐλάλησαν αὐτῷ ἐν τῷ πυλῶνι τοῦ οἴκου, ");
INSERT INTO grcbrent_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","λέγοντες, δεόμεθα, κύριε· κατέβηεν τὴν ἀρχὴν πρίασθαι βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ἐγένετο δὲ ἡνίκα ἤλθομεν εἰς τὸ καταλῦσαι, καὶ ἠνοίξαμεν τοὺς μαρσίππους ἡμῶν, καὶ τόδε τὸ ἀργύριον ἑκάστου ἐν τῷ μαρσίππῳ αὐτοῦ· τὸ ἀργύριον ἡμῶν ἐν σταθμῷ ἀπεστρέψαμεν νῦν ἐν ταῖς χερσὶν ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Καὶ ἀργύριον ἕτερον ἠνέγκαμεν μεθʼ ἑαυτῶν, ἀγοράσαι βρώματα· οὐκ οἴδαμεν τίς ἐνέβαλεν τὸ ἀργύριον εἰς τοὺς μαρσίππους ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Εἶπε δὲ αὐτοῖς, ἵλεως ὑμῖν, μὴ φοβεῖσθε· ὁ Θεὸς ὑμῶν, καὶ ὁ Θεὸς τῶν πατέρων ὑμῶν, ἔδωκεν ὑμῖν θησαυροὺς ἐν τοῖς μαρσίπποις ὑμῶν· καὶ τὸ ἀργύριον ὑμῶν εὐδοκιμοῦν ἀπέχω· καὶ ἐξήγαγε πρὸς αὐτοὺς τὸν Συμεών. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Καὶ ἤνεγκεν ὕδωρ νίψαι τοὺς πόδας αὐτῶν· καὶ ἔδωκε χορτάσματα τοῖς ὄνοις αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ἡτοίμασαν δὲ τὰ δῶρα, ἕως τοῦ ἐλθεῖν τὸν Ἰωσὴφ μεσημβρίας· ἤκουσαν γὰρ ὅτι ἐκεῖ μέλλει ἀριστᾷν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Εἰσῆλθε δὲ Ἰωσὴφ εἰς τὴν οἰκίαν, καὶ προσήνεγκαν αὐτῷ τὰ δῶρα, ἃ εἶχον ἐν ταῖς χερσὶν αὐτῶν, εἰς τὸν οἶκον· καὶ προσεκύνησαν αὐτῷ ἐπὶ πρόσωπον ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ἠρώτησε δὲ αὐτοὺς, πῶς ἔχετε; καὶ εἶπεν αὐτοῖς, εἰ ὑγιαίνει ὁ πατὴρ ὑμῶν ὁ πρεσβύτης, ὃν εἴπατε; ἔτι ζῇ; ");
INSERT INTO grcbrent_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Οἱ δὲ εἶπαν, ὑγιαίνει ὁ παῖς σου ὁ πατὴρ ἡμῶν, ἔτι ζῇ. Καὶ εἶπεν, εὐλογημένος ὁ ἄνθρωπος ἐκεῖνος τῷ Θεῷ· καὶ κύψαντες προσεκύνησαν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ἀναβλέψας δὲ τοῖς ὀφθαλμοῖς αὐτοῦ Ἰωσὴφ, εἶδε Βενιαμὶν τὸν ἀδελφὸν αὐτοῦ τὸν ὁμομήτριον· καὶ εἶπεν, οὗτος ὁ ἀδελφὸς ὑμῶν ὁ νεώτερος, ὃν εἴπατε πρός με ἀγαγεῖν; καὶ εἶπεν, ὁ Θεὸς ἐλεήσαι σε, τέκνον. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ἐταράχθη δὲ Ἰωσήφ· συνεστρέφετο γὰρ τὰ ἔγκατα αὐτοῦ ἐπὶ τῷ ἀδελφῷ αὐτοῦ, καὶ ἐζήτει κλαῦσαι· εἰσελθὼν δὲ εἰς τὸ ταμεῖον, ἔκλαυσεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Καὶ νιψάμενος τὸ πρόσωπον, ἐξελθὼν ἐνεκρατεύσατο· καὶ εἶπε, παράθετε ἄρτους. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Καὶ παρέθηκαν αὐτῷ μόνῳ, καὶ αὐτοῖς καθʼ ἑαυτούς, καὶ τοῖς Αἰγυπτίοις τοῖς συνδειπνοῦσι μετʼ αὐτοῦ καθʼ ἑαυτούς· οὐ γὰρ ἐδύναντο οἱ Αἰγύπτιοι συνεσθίειν μετὰ τῶν Ἐβραίων ἄρτους· βδέλυγμα γάρ ἐστι τοῖς Αἰγυπτίοις. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ἐκάθισαν δὲ ἐναντίον αὐτοῦ, ὁ πρωτότοκος κατὰ τὰ πρεσβεῖα αὐτοῦ, καὶ ὁ νεώτερος κατὰ τὴν νεότητα αὐτοῦ· ἐξίσταντο δὲ οἱ ἄνθρωποι ἕκαστος πρὸς τὸν ἀδελφὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ἦραν δὲ μερίδα παρʼ αὐτοῦ πρὸς ἑαυτούς· ἐμεγαλύνθη δὲ ἡ μερὶς Βενιαμεὶν παρὰ τὰς μερίδας πάντων πενταπλασίως πρὸς τὰς ἐκείνων· ἔπιον δὲ καὶ ἐμεθύσθησαν μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Καὶ ἐνετείλατο ὁ Ἰωσὴφ τῷ ὄντι ἐπὶ τῆς οἰκίας αὐτοῦ, λέγων, πλήσατε τοὺς μαρσίππους τῶν ἀνθρώπων βρωμάτων, ὅσα ἐὰν δύνωνται ἆραι· καὶ ἐμβάλετε ἑκάστου τὸ ἀργύριον ἐπὶ τοῦ στόματος τοῦ μαρσίππου. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Καὶ τὸ κόνδυ μου τὸ ἀργυροῦν ἐμβάλετε εἰς τὸν μάρσιππον τοῦ νεωτέρου, καὶ τὴν τιμὴν τοῦ σίτου αὐτοῦ· ἐγενήθη δὲ κατὰ τὸ ῥῆμα Ἰωσὴφ, καθὼς εἶπε. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Τὸ πρωῒ διέφαυσε· καὶ οἱ ἄνθρωποι ἀπεστάλησαν, αὐτοὶ καὶ οἱ ὄνοι αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ἐξελθόντων δὲ αὐτῶν τὴν πόλιν, οὐκ ἀπέσχον μακράν· καὶ Ἰωσὴφ εἶπε τῷ ἐπὶ τῆς οἰκίας αὐτοῦ, ἀναστὰς ἐπιδίωξον ὀπίσω τῶν ἀνθρώπων, καὶ καταλήμψῃ αὐτοὺς, καὶ ἐρεῖς αὐτοῖς τί ὅτι ἀνταπεδώκατε πονηρὰ ἀντὶ καλῶν; ");
INSERT INTO grcbrent_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ἱνατί ἐκλέψατέ μου τὸ κόνδυ τὸ ἀργυροῦν; οὐ τοῦτό ἐστιν, ἐν ᾧ πίνει ὁ κύριός μου; αὐτὸς δὲ οἰωνισμῷ οἰωνίζεται ἐν αὐτῷ. πονηρὰ συντετελέκατε ἃ πεποιήκατε. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Εὑρὼν δὲ αὐτοὺς, εἶπεν αὐτοῖς κατὰ τὰ ῥήματα ταῦτα. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Οἱ δὲ εἶπαν αὐτῷ, ἱνατί λαλεῖ ὁ κύριος κατὰ τὰ ῥήματα ταῦτα; μὴ γένοιτο τοῖς παισίν σου ποιῆσαι κατὰ τὸ ῥῆμα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Εἰ τὸ μὲν ἀργύριον, ὃ εὕρομεν ἐν τοῖς μαρσίπποις ἡμῶν, ἀπεστρέψαμεν πρὸς σὲ ἐκ γῆς Χαναὰν, πῶς ἂν κλέψαιμεν ἐκ τοῦ οἴκου τοῦ κυρίου σου ἀργύριον ἢ χρυσίον; ");
INSERT INTO grcbrent_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Παρʼ ᾧ ἂν εὕρῃς τὸ κόνδυ τῶν παιδων σου, ἀποθνησκέτω· καὶ ἡμεῖς δὲ ἐσόμεθα παῖδες τῷ κυρίῳ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ὁ δὲ εἶπε, καὶ νῦν, ὡς λέγετε, οὕτως ἔσται· παρʼ ᾧ ἂν εὑρεθῇ τὸ κόνδυ, ἔσται μου παῖς ὑμεῖς δὲ ἔσεσθε καθαροί. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Καὶ ἔσπευσαν, καὶ καθεῖλαν ἕκαστος τὸν μάρσιππον αὐτοῦ ἐπὶ τὴν γῆν· καὶ ἤνοιξαν ἕκαστος τὸν μάρσιππον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ἠρεύνησε δὲ ἀπὸ τοῦ πρεσβυτέρου ἀρξάμενος, ἕως ἦλθεν ἐπὶ τὸν νεώτερον. καὶ εὗρε τὸ κόνδυ ἐν τῷ μαρσίππῳ τοῦ Βενιαμίν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Καὶ διέῤῥηξαν τὰ ἱμάτια αὐτῶν, καὶ ἐπέθηκαν ἕκαστος τὸν μαρσίππον αὐτοῦ ἐπὶ τὸν ὄνον αὐτοῦ, καὶ ἐπέστρεψαν εἰς τὴν πόλιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Εἰσῆλθε δὲ Ἰούδας καὶ οἱ ἀδελφοὶ αὐτοῦ πρὸς Ἰωσὴφ ἔτι αὐτοῦ ὄντος ἐκεῖ, καὶ ἔπεσον ἐναντίον αὐτοῦ ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Εἶπε δὲ αὐτοῖς Ἰωσὴφ, τί τὸ πρᾶγμα τοῦτο ἐποιήσατε; οὐκ οἴδατε ὅτι οἰωνισμῷ οἰωνιεῖται ὁ ἄνθρωπος, οἷος ἐγώ; ");
INSERT INTO grcbrent_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Εἶπε δὲ Ἰούδας, τί ἀντεροῦμεν τῷ κυρίῳ, ἢ τί λαλήσομεν, ἢ τί δικαιωθῶμεν; ὁ Θεὸς δὲ εὗρε τὴν ἀδικίαν τῶν παίδων σου· ἰδού ἐσμεν οἰκέται τῷ κυρίῳ ἡμῶν, καὶ ἡμεῖς, καὶ παρʼ ᾧ εὑρέθη τὸ κόνδυ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Εἶπε δὲ Ἰωσὴφ, μή μοι γένοιτο ποιῆσαι τὸ ῥῆμα τοῦτο· ὁ ἄνθρωπος παρʼ ᾧ εὑρέθη τὸ κόνδυ, αὐτὸς ἔσται μου παῖς· ὑμεῖς δὲ ἀνάβητε μετὰ σωτηρίας πρὸς τὸν πατέρα ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ἐγγίσας δὲ αὐτῷ Ἰούδας εἶπε, δέομαι, κύριε· λαλησάτω ὁ παῖς σου ῥῆμα ἐναντίον σου, καὶ μὴ θυμωθῇς τῷ παιδί σου, ὅτι σὺ εἶ μετὰ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Κύριε, σὺ ἠρώτησας τοὺς παῖδάς σου, λέγων, εἰ ἔχετε πατέρα ἢ ἀδελφόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Καὶ εἴπαμεν τῷ κυρίῳ, ἔστιν ἡμῖν πατὴρ πρεσβύτερος, καὶ παιδίον γήρως νεώτερον αὐτῷ, καὶ ὁ ἀδελφὸς αὐτοῦ ἀπέθανεν, αὐτὸς δὲ μόνος ὑπελείφθη τῇ μητρὶ αὐτοῦ, ὁ δὲ πατὴρ αὐτὸν ἠγάπησεν· ");
INSERT INTO grcbrent_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Εἶπας δὲ τοῖς παισί σου, καταγάγετε αὐτὸν πρὸς μέ, καὶ ἐπιμελοῦμαι αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Καὶ εἴπαμεν τῷ κυρίῳ, οὐ δυνήσεται τὸ παιδίον καταλιπεῖν τὸν πατέρα αὐτοῦ· ἐὰν δὲ καταλείπῃ τὸν πατέρα, ἀποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Σὺ δὲ εἶπας τοῖς παισί σου, ἐὰν μὴ καταβῇ ὁ ἀδελφὸς ὑμῶν ὁ νεώτερος μεθʼ ὑμῶν, οὐ προσθήσεσθε ἰδεῖν τὸ πρόσωπόν μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ἐγένετο δὲ ἡνίκα ἀνέβημεν πρὸς τὸν παῖδά σου πατέρα ἡμῶν, ἀπηγγείλαμεν αὐτῷ τὰ ῥήματα τοῦ κυρίου ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Εἶπε δὲ ὁ πατὴρ ἡμῶν, βαδίσατε πάλιν καὶ ἀγοράσατε ἡμῖν μικρὰ βρώματα. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ἡμεῖς δὲ εἴπομεν, οὐ δυνησόμεθα καταβῆναι· ἀλλʼ εἰ μὲν ὁ ἀδελφὸς ἡμῶν ὁ νεώτερος καταβαίνει μεθʼ ἡμῶν, καταβησόμεθα· οὐ γὰρ δυνησόμεθα ἰδεῖν τὸ πρόσωπον τοῦ ἀνθρώπου, τοῦ ἀδελφοῦ ἡμῶν τοῦ νεωτέρου μὴ ὄντος μεθʼ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Εἶπε δὲ ὁ παῖς σου πατὴρ ἡμῶν πρὸς ἡμᾶς, ὑμεῖς γινώσκετε ὅτι δύο ἔτεκέ μοι ἡ γυνὴ, ");
INSERT INTO grcbrent_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","καὶ ἐξῆλθεν ὁ εἷς ἀπʼ ἐμοῦ· καὶ εἴπατε ὅτι θηριόβρωτος γέγονεν, καὶ οὐκ ἴδον αὐτὸν ἄχρι νῦν. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ἐὰν οὖν λάβητε καὶ τοῦτον ἐκ τοῦ προσώπου μου, καὶ συμβῇ αὐτῷ μαλακία ἐν τῇ ὁδῷ, καὶ κατάξετέ μου τὸ γῆρας μετὰ λύπης εἰς ᾅδου. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Νῦν οὖν ἐὰν εἰσπορεύωμαι πρὸς τὸν παῖδά σου, πατέρα δὲ ἡμῶν, καὶ τὸ παιδίον μὴ ᾖ μεθʼ ἡμῶν, ἡ δὲ ψυχὴ αὐτοῦ ἐκκρέμαται ἐκ τῆς τούτου ψυχῆς, ");
INSERT INTO grcbrent_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","καὶ ἔσται ἐν τῷ ἰδεῖν αὐτὸν μὴ ὂν τὸ παιδίον μεθʼ ἡμῶν, τελευτήσει, καὶ κατάξουσιν οἱ παῖδές σου τὸ γῆρας τοῦ παιδός σου, πατρὸς δὲ ἡμῶν, μετὰ λύπης εἰς ᾅδου. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ὁ γὰρ παῖς σου παρὰ τοῦ πατρὸς ἐκδέδεκται τὸ παιδίον, λέγων, ἐὰν μὴ ἀγάγω αὐτὸν πρὸς σὲ, καὶ στήσω αὐτὸν ἐνώπιόν σου, ἡμαρτηκὼς ἔσομαι εἰς τὸν πατέρα πάσας τὰς ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Νῦν οὖν παραμενῶ σοι παῖς ἀντὶ τοῦ παιδίου, οἰκέτης τοῦ κυρίου· τὸ δὲ παιδίον ἀναβήτω μετὰ τῶν ἀδελφῶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Πῶς γὰρ ἀναβήσομαι πρὸς τὸν πατέρα, τοῦ παιδίου μὴ ὄντος μεθʼ ἡμῶν; ἵνα μὴ ἴδω τὰ κακὰ, ἃ εὑρήσει τὸν πατέρα μου. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Καὶ οὐκ ἠδύνατο Ἰωσὴφ ἀνέχεσθαι πάντων τῶν παρεστηκότων αὐτῷ, ἀλλʼ εἶπεν, ἐξαποστείλατε πάντας ἀπʼ ἐμοῦ· καὶ οὐ παρειστήκει οὐδεὶς τῷ Ἰωσὴφ, ἡνίκα ἀνεγνωρίζετο τοῖς ἀδελφοῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Καὶ ἀφῆκε φωνὴν μετὰ κλαυθμοῦ· ἤκουσαν δὲ πάντες οἱ Αἰγύπτιοι, καὶ ἀκουστὸν ἐγένετο εἰς τὸν οἶκον Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Εἶπε δὲ Ἰωσὴφ πρὸς τοὺς ἀδελφοὺς αὐτοῦ, ἐγώ εἰμι Ἰωσήφ· ἔτι ὁ πατήρ μου ζῇ; καὶ οὐκ ἠδύναντο οἱ ἀδελφοὶ ἀποκριθῆναι αὐτῷ· ἐταράχθησαν γάρ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Εἶπε δὲ Ἰωσὴφ πρὸς τοὺς ἀδελφοὺς αὐτοῦ, ἐγγίσατε πρὸς μέ· καὶ ἤγγισαν· καὶ εἶπεν, ἐγώ εἰμι Ἰωσὴφ ὁ ἀδελφὸς ὑμῶν, ὃν ἀπέδοσθε εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Νῦν οὖν μὴ λυπεῖσθε, μηδὲ σκληρὸν ὑμῖν φανήτω, ὅτι ἀπέδοσθέ με ὧδε· εἰς γὰρ ζωὴν ἀπέστειλέ με ὁ Θεὸς ἔμπροσθεν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Τοῦτο γὰρ δεύτερον ἔτος λιμὸς ἐπὶ τῆς γῆς, καὶ ἔτι λοιπὰ πέντε ἔτη, ἐν οἷς οὐκ ἔσται ἀροτρίασις, οὐδὲ ἀμητός· ");
INSERT INTO grcbrent_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ἀπέστειλε γάρ με ὁ Θεὸς ἔμπροσθεν ὑμῶν, ὑπολείπεσθαι ὑμῶν κατάλειμμα ἐπὶ τῆς γῆς, καὶ ἐκθρέψαι ὑμῶν κατάλειψιν μεγάλην. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Νῦν οὖν οὐχ ὑμεῖς με ἀπεστάλκατε ὧδε, ἀλλὰ ὁ Θεός· καὶ ἐποίησέ με ὡς πατέρα Φαραὼ, καὶ κύριον παντὸς τοῦ οἴκου αὐτοῦ, καὶ ἄρχοντα πάσης γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Σπεύσαντες οὖν ἀνάβητε πρὸς τὸν πατέρα μου, καὶ εἴπατε αὐτῷ, τάδε λέγει ὁ υἱός σου Ἰωσήφ· ἐποίησέ με ὁ Θεὸς κύριον πάσης γῆς Αἰγύπτου· κατάβηθι οὖν πρός με, καὶ μὴ μείνῃς· ");
INSERT INTO grcbrent_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Καὶ κατοικήσεις ἐν γῇ Γεσὲμ Ἀραβίας· καὶ ἔσῃ ἐγγύς μου σὺ, καὶ οἱ υἱοί σου, καὶ οἱ υἱοὶ τῶν υἱῶν σου, τὰ πρόβατά σου, καὶ αἱ βόες σου, καὶ ὅσα σοι ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Καὶ ἐκθρέψω σε ἐκεῖ· ἔτι γὰρ πέντε ἔτη λιμός· ἵνα μὴ ἐκτριβῇς σὺ, καὶ οἱ υἱοί σου, καὶ πάντα τὰ ὑπάρχοντά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ἰδοὺ οἱ ὀφθαλμοὶ ὑμῶν βλέπουσι, καὶ οἱ ὀφθαλμοὶ Βενιαμεὶν τοῦ ἀδελφοῦ μου, ὅτι τὸ στόμα μου τὸ λαλοῦν πρὸς ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ἀπαγγείλατε οὖν τῷ πατρί μου πᾶσαν τὴν δόξαν μου τὴν ἐν Αἰγύπτῳ, καὶ ὅσα ἴδετε· καὶ ταχύναντες καταγάγετε τὸν πατέρα μου ὧδε. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Καὶ ἐπιπεσὼν ἐπὶ τὸν τράχηλον Βενιαμὶν τοῦ ἀδελφοῦ αὐτοῦ, ἔκλαυσεν ἐπʼ αὐτῷ· καὶ Βενιαμὶν ἔκλαυσεν ἐπὶ τῷ τραχήλῳ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Καὶ καταφιλήσας πάντας τοὺς ἀδελφοὺς αὐτοῦ, ἔκλαυσεν ἐπʼ αὐτοῖς· καὶ μετὰ ταῦτα ἐλάλησαν οἱ ἀδελφοὶ αὐτοῦ πρὸς αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Καὶ διεβοήθη ἡ φωνὴ εἰς τὸν οἶκον Φαραὼ, λέγοντες, ἥκασιν οἱ ἀδελφοὶ Ἰωσήφ· ἐχάρη δὲ Φαραὼ καὶ ἡ θεραπεία αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Εἶπε δὲ Φαραὼ πρὸς Ἰωσὴφ, εἰπον τοῖς ἀδελφοῖς σου, τοῦτο ποιήσατε, γεμίσατε τὰ φορεῖα ὑμῶν, καὶ ἀπέλθετε εἰς γῆν Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Καὶ ἀναλαβόντες τὸν πατέρα ὑμῶν, καὶ τὰ ὑπάρχοντα ὑμῶν, ἥκετε πρός με· καὶ δώσω ὑμῖν πάντων τῶν ἀγαθῶν Αἰγύπτου, καὶ φάγεσθε τὸν μυελὸν τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Σὺ δὲ ἔντειλαι ταῦτα· λαβεῖν αὐτοῖς ἁμάξας ἐκ γῆς Αἰγύπτου τοῖς παιδίοις ὑμῶν, καὶ ταῖς γυναιξὶν ὑμῶν· καὶ ἀναλαβόντες τὸν πατέρα ὑμῶν παραγίνεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Καὶ μὴ φείσησθε τοῖς ὀφθαλμοῖς τῶν σκευῶν ὑμῶν· τὰ γὰρ πάντα ἀγαθὰ Αἰγύπτου ὑμῖν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ἐποίησαν δὲ οὕτως οἱ υἱοὶ Ἰσραήλ· ἔδωκε δὲ Ἰωσὴφ αὐτοῖς ἁμάξας κατὰ τὰ εἰρημένα ὑπὸ Φαραὼ τοῦ βασιλέως· καὶ ἔδωκεν αὐτοῖς ἐπισιτισμὸν εἰς τὴν ὁδόν· ");
INSERT INTO grcbrent_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Καὶ πᾶσιν ἔδωκε δισσὰς στολάς· τῷ δὲ Βενιαμὶν ἔδωκε τριακοσίους χρυσοὺς, καὶ πέντε ἐξαλλασσούσας στολάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Καὶ τῷ πατρὶ αὐτοῦ ἀπέστειλε κατὰ τὰ αὐτά· καὶ δέκα ὄνους, αἴροντας ἀπὸ πάντων τῶν ἀγαθῶν Αἰγύπτου, καὶ δέκα ἡμιόνους, αἰρούσας ἄρτους τῷ πατρὶ αὐτοῦ εἰς ὁδόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ἐξαπέστειλε δὲ τοὺς ἀδελφοὺς αὐτοῦ, καὶ ἐπορεύθησαν· καὶ εἶπεν αὐτοῖς, μὴ ὀργίζεσθε ἐν τῇ ὁδῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Καὶ ἀνέβησαν ἐξ Αἰγυπτου, καὶ ἦλθον εἰς γῆν Χαναὰν πρὸς Ἰακὼβ τὸν πατέρα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Καὶ ἀνήγγειλαν αὐτῷ λέγοντες, ὅτι ὁ υἱός σου Ἰωσὴφ ζῇ, καὶ αὐτὸς ἄρχει πάσης γῆς Αἰγύπτου· καὶ ἐξέστη τῇ διανοίᾳ Ἰακὼβ, οὐ γὰρ ἐπίστευσεν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ἐλάλησαν δὲ αὐτῷ πάντα τὰ ῥηθέντα ὑπὸ Ἰωσὴφ, ὅσα εἶπεν αὐτοῖς. Ἰδὼν δὲ τὰς ἁμάξας, ἃς ἀπέστειλεν Ἰωσὴφ ὥστε ἀναλαβεῖν αὐτὸν, ἀνεζωπύρησε τὸ πνεῦμα Ἰακὼβ τοῦ πατρὸς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Εἶπε δὲ Ἰσραὴλ, μέγα μοι ἐστὶν, εἰ ἔτι Ἰωσὴφ ὁ υἱός μου ζῇ· πορευθεὶς ὄψομαι αὐτὸν πρὸ τοῦ ἀποθανεῖν με. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ἀπᾴρας δὲ Ἰσραὴλ, αὐτὸς καὶ πάντα τὰ αὐτοῦ, ἦλθεν ἐπὶ τὸ φρέαρ τοῦ ὅρκου· καὶ ἔθυσε θυσίαν τῷ Θεῷ τοῦ πατρὸς αὐτοῦ Ἰσαάκ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Εἶπε δὲ ὁ Θεὸς τῷ Ἰσραὴλ ἐν ὁράματι τῆς νυκτὸς, εἰπὼν, Ἰακὼβ, Ἰακώβ· ὁ δὲ εἶπε, τί ἐστιν; ");
INSERT INTO grcbrent_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ὁ δὲ λέγει αὐτῷ, ἐγώ εἰμι ὁ Θεὸς τῶν πατέρων σου· μὴ φοβοῦ καταβῆναι εἰς Αἴγυπτον· εἰς γὰρ ἔθνος μέγα ποιήσω σε ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Καὶ ἐγὼ καταβήσομαι μετὰ σοῦ εἰς Αἴγυπτον, καὶ ἐγὼ ἀναβιβάσω σε εἰς τέλος· καὶ Ἰωσὴφ ἐπιβαλεῖ τὰς χεῖρας ἐπὶ τοὺς ὀφθαλμούς σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ἀνέστη δὲ Ἰακὼβ ἀπὸ τοῦ φρέατος τοῦ ὅρκου· καὶ ἀνέλαβον οἱ υἱοὶ Ἰσραὴλ τὸν πατέρα αὐτῶν, καὶ τὴν ἀποσκευὴν, καὶ τὰς γυναῖκας αὐτῶν, ἐπὶ τὰς ἁμάξας, ἃς ἀπέστειλεν Ἰωσὴφ ἆραι αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Καὶ ἀναλαβόντες τὰ ὑπάρχοντα αὐτῶν, καὶ πᾶσαν τὴν κτῆσιν, ἣν ἐκτήσαντο ἐκ γῇ Χαναὰν, εἰσῆλθον εἰς Αἴγυπτον, Ἰακὼβ, καὶ πᾶν τὸ σπέρμα αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Υἱοὶ, καὶ υἱοὶ τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ· θυγατέρες, καὶ θυγατέρες τῶν θυγατέρων αὐτοῦ· καὶ πᾶν τὸ σπέρμα αὐτοῦ ἤγαγεν εἰς Αἴγυπτον· ");
INSERT INTO grcbrent_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ταῦτα δὲ τὰ ὀνόματα τῶν υἱῶν Ἰσραὴλ τῶν εἰσελθόντων εἰς Αἴγυπτον ἅμα Ἰακὼβ τῷ πατρὶ αὐτῶν. Ἰακὼβ καὶ οἱ υἱοὶ αὐτοῦ· πρωτότοκος Ἰακὼβ, Ῥουβήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","γἱοὶ δὲ Ῥουβὴν, Ἑνὼχ, καὶ Φαλλὸς, Ἀσρὼν, καὶ Χαρμί. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Υἱοὶ δὲ Συμεὼν, Ἰεμουὴλ, καὶ Ἰαμεὶν, καὶ Ἀὼδ, καὶ Ἀχεὶν, καὶ Σαὰρ, καὶ Σαοὺλ υἱὸς τῆς Χανανίτιδος. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Υἱοὶ δὲ Λευὶ, Γηρσὼν, Κὰθ, καὶ Μεραρί. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Υἱοὶ δὲ Ἰούδα, Ἢρ, καὶ Αὐνὰν, καὶ Σηλὼμ, καὶ Φαρὲς, καὶ Ζαρά· ἀπέθανε δὲ Ἢρ καὶ Αὐνὰν ἐν γῇ Χαναάν· ἐγένοντο δὲ υἱοὶ Φαρὲς, Ἑσρὼν, καὶ Ἰεμουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Υἱοὶ δὲ Ἰσσάχαρ, Θωλὰ, καὶ Φουὰ, καὶ Ἀσοὺμ, καὶ Σαμβράν. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Υἱοὶ δὲ Ζαβουλὼν, Σερὲδ, καὶ Ἀλλὼν, καὶ Ἀχοήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Οὗτοι υἱοὶ Λείας, οὓς ἔτεκε τῷ Ἰακὼβ ἐν Μεσοποταμίᾳ τῆς Συρίας, καὶ Δείναν τὴν θυγατέρα αὐτοῦ· πᾶσαι αἱ ψυχαί, υἱοὶ καὶ θυγατέρες, τριάκοντα τρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Υἱοὶ δὲ Γάδ, Σαφὼν, καὶ Ἀγγὶς, καὶ Σαννὶς, καὶ Θασοβὰν, καὶ Ἀηδεὶς, καὶ Ἀροηδεὶς, καὶ Ἀρεηλείς. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Υἱοὶ δὲ Ἀσὴρ, Ἰεμνα, Ἰεσσουὰ, καὶ Ἰεοὺλ, καὶ βαριὰ, καὶ Σάρα ἀδελφὴ αὐτῶν. Υἱοὶ δὲ βαριὰ, Χοβὸρ, καὶ Μελχιΐλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Οὗτοι υἱοὶ Ζελφᾶς, ἣν ἔδωκε Λάβαν Λείᾳ τῇ θυγατρὶ αὐτοῦ, ἣ ἔτεκε τούτους τῷ Ἰακὼβ, δεκαὲξ ψυχάς. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Υἱοὶ δὲ Ῥαχὴλ γυναικὸς Ἰακὼβ, Ἰωσὴφ, καὶ Βενιαμείν. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ἐγένοντο δὲ υἱοὶ Ἰωσὴφ ἐν γῇ Αἰγύπτου, οὓς ἔτεκεν αὐτῷ Ἀσενὲθ θυγάτηρ Πετεφρῆ ἱερέως Ἡλιουπόλεως, τὸν Μανασσῆ, καὶ τὸν Ἐφραίμ· ἐγένοντο δὲ υἱοὶ Μανασσῆ, οὓς ἔτεκεν αὐτῷ ἡ παλλακὴ ἡ Σύρα, τὸν Μαχίρ· Μαχὶρ δὲ ἐγέννησε τὸν Γαλαάδ· υἱοὶ δὲ Ἐφραὶμ ἀδελφοῦ Μανασσῆ, Σουταλαὰμ, καὶ Ταάμ· υἱοὶ δὲ Σουταλαὰμ, Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Υἱοὶ δὲ Βενιαμεὶν, Βαλὰ καὶ Βοχὸρ, καὶ Ἀσβήλ. Ἐγένοντο δὲ υἱοὶ Βαλὰ, Γηρὰ, καὶ Νοεμὰν, καὶ Ἀγχὶς, καὶ Ῥὼς, καὶ Μαμφίμ· Γηρὰ δὲ ἐγέννησε τὸν Ἀράδ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Οὗτοι υἱοὶ Ῥαχὴλ, οὓς ἔτεκε τῷ Ἰακώβ· πᾶσαι αἱ ψυχαὶ δεκαοκτώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Υἱοὶ δὲ Δὰν, Ἀσόμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Καὶ υἱοὶ Νεφθαλὶ, Ἀσιὴλ, καὶ Γωνὶ, καὶ Ἰσσάαρ, καὶ Σολλήμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Οὗτοι υἱοὶ Βαλλὰς, ἣν ἔδωκε Λάβαν Ῥαχὴλ τῇ θυγατρὶ αὐτοῦ, ἣ ἔτεκε τούτους τῷ Ἰακὼβ, πᾶσαι αἱ ψυχαὶ ἑπτά. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Πᾶσαι δὲ ψυχαὶ αἱ εἰσελθοῦσαι μετὰ Ἰακὼβ εἰς Αἴγυπτον, οἱ ἐξελθόντες ἐκ τῶν μηρῶν αὐτοῦ, χωρὶς τῶν γυναικῶν υἱῶν Ἰακὼβ, πᾶσαι αἱ ψυχαὶ, ἑξηκονταέξ· ");
INSERT INTO grcbrent_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Υἱοὶ δὲ Ἰωσὴφ οἱ γενόμενοι αὐτῷ ἐν γῇ Αἰγύπτῳ, ψυχαὶ ἐννέα. Πᾶσαι ψυχαὶ οἴκου Ἰακὼβ, αἱ εἰσελθοῦσαι μετὰ Ἰακὼβ εἰς Αἴγυπτον, ψυχαὶ ἑβδομηκονταπέντε. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Τὸν δὲ Ἰούδαν ἀπέστειλεν ἔμπροσθεν αὐτοῦ πρὸς Ἰωσὴφ, συναντῆσαι αὐτῷ καθʼ Ἡρώων πόλιν, εἰς γῆν Ῥαμεσσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ζεύξας δὲ Ἰωσὴφ τὰ ἅρματα αὐτοῦ, ἀνέβη εἰς συνάντησιν Ἰσραὴλ τῷ πατρὶ αὐτοῦ, καθʼ Ἡρώων πόλιν· καὶ ὀφθεὶς αὐτῷ ἐπέπεσεν ἐπὶ τὸν τράχηλον αὐτοῦ, καὶ ἔκλαυσε κλαυθμῷ πίονι. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Καὶ εἶπεν Ἰσραήλ πρὸς Ἰωσὴφ, ἀποθανοῦμαι ἀπὸ τοῦ νῦν, ἐπεὶ ἑώρακα τὸ πρόσωπόν σου· ἔτι γὰρ σὺ ζῇς. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Εἶπε δὲ Ἰωσὴφ πρὸς τοὺς ἀδελφοὺς αὐτοῦ, ἀναβὰς ἀπαγγελῶ τῷ Φαραῷ, καὶ ἐρῶ αὐτῷ, οἱ ἀδελφοί μου, καὶ ὁ οἶκος τοῦ πατρός μου, οἳ ἦσαν ἐν γῇ χαναὰν, ἥκασι πρός με. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Οἱ δὲ ἄνδρες εἰσὶ ποιμένες· ἄνδρες γὰρ κτηνοτρόφοι ἦσαν· καὶ τὰ κτήνη, καὶ τοὺς βόας, καὶ πάντα τὰ αὐτῶν ἀγηόχασιν. ");
INSERT INTO grcbrent_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ἐὰν οὖν καλέσῃ ὑμᾶς Φαραὼ, καὶ εἴπῃ ὑμῖν, τί τὸ ἔργον ὑμῶν ἐστι; ");
INSERT INTO grcbrent_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ἐρεῖτε, ἄνδρες κτηνοτρόφοι ἐσμὲν οἱ παῖδές σου ἐκ παιδὸς ἕως τοῦ νῦν, καὶ ἡμεῖς, καὶ οἱ πατέρες ἡμῶν· ἵνα κατοικήσητε ἐν γῇ Γεσὲμ Ἀραβίας· βδέλυγμα γάρ ἐστιν Αἰγυπτίοις πᾶς ποιμὴν προβάτων. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ἐλθῶν δὲ Ἰωσὴφ ἀπήγγειλε τῷ Φαραῶ, λέγων, ὁ πατὴρ μου, καὶ οἱ ἀδελφοί μου, καὶ τὰ κτήνη, καὶ οἱ βόες αὐτῶν, καὶ πάντα τὰ αὐτῶν, ἦλθον ἐκ γῆς Χαναάν· καὶ ἰδού εἰσιν ἐν γῇ Γεσέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ἀπὸ δὲ τῶν ἀδελφῶν αὐτοῦ παρέλαβε πέντε ἄνδρας, καὶ ἔστησεν αὐτοὺς ἐναντίον Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Καὶ εἶπε Φαραὼ τοῖς ἀδελφοῖς Ἰωσὴφ, Τί τὸ ἔργον ὑμῶν; οἱ δὲ εἶπαν τῷ Φαραῷ, ποιμένες προβάτων οἱ παῖδές σου, καὶ ἡμεῖς καὶ οἱ πατέρες ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Εἶπαν δὲ τῷ Φαραῷ, παροικεῖν ἐν τῇ γῇ ἥκαμεν, οὐ γάρ ἐστι νομὴ τοῖς κτήνεσι τῶν παιδων σου, ἐνίσχυσε γὰρ ὁ λιμὸς ἐν γῇ Χανάαν· νῦν οὖν κατοικήσομεν ἐν γῇ Γεσέμ. Εἶπε δὲ Φαραὼ τῷ Ἰωσὴφ, Κατοικείτωσαν ἐν γῇ Γεσέμ· εἰ δὲ ἐπίστῃ, ὅτι εἰσὶν ἐν αὐτοῖς ἄνδρες δυνατοὶ, κατάστησον αὐτοὺς ἄρχοντας τῶν ἐμῶν κτηνῶν. Ἦλθον δὲ εἰς Αἴγυπτον πρὸς Ἰωσὴφ Ἰακὼβ, καὶ οἱ υἱοὶ αὐτοῦ· καὶ ἤκουσε Φαραὼ βασιλεὺς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Καὶ εἶπε Φαραὼ πρὸς Ἰωσὴφ, λέγων, ὁ πατήρ σου, καὶ οἱ ἀδελφοί σου, ἥκασι πρὸς σέ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ἰδοὺ ἡ γῆ Αἰγύπτου ἐναντίον σου ἐστίν· ἐν τῇ βελτίστῃ γῇ κατοίκισον τὸν πατέρα σου, καὶ τοὺς ἀδελφούς σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Εἰσήγαγε δὲ Ἰωσὴφ Ἰακὼβ τὸν πατέρα αὐτοῦ, καὶ ἔστησεν αὐτὸν ἐναντίον Φαραώ· καὶ ηὐλόγησεν Ἰακὼβ τὸν Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Εἶπε δὲ Φαραὼ τῷ Ἰακὼβ, πόσα ἔτη ἡμερῶν τῆς ζωῆς σου; ");
INSERT INTO grcbrent_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Καὶ εἶπεν Ἰακὼβ τῷ Φαραῷ, αἱ ἡμέραι τῶν ἐτῶν τῆς ζωῆς μου, ἃς παροικῶ, ἑκατὸν τριάκοντα ἔτη· μικραὶ καὶ πονηραὶ γεγόνασιν αἱ ἡμέραι τῶν ἐτῶν τῆς ζωῆς μου· οὐκ ἀφίκοντο εἰς τὰς ἡμέρας τῶν ἐτῶν τῆς ζῶης τῶν πατέρων μου, ἃς ἡμέρας παρῴκησαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Καὶ εὐλογήσας Ἰακὼβ τὸν Φαραὼ, ἐξῆλθεν ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Καὶ κατῴκισεν Ἰωσὴφ τὸν πατέρα αὐτοῦ, καὶ τοὺς ἀδελφοὺς αὐτοῦ, καὶ ἔδωκεν αὐτοῖς κατάσχεσιν ἐν γῇ Αἰγύπτῳ, ἐν τῇ βελτίστῃ γῇ, ἐν γῇ Ῥαμεσσῆ, καθὰ προσέταξε Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Καὶ ἐσιτομέτρει Ἰωσὴφ τῷ πατρὶ αὐτοῦ, καὶ τοῖς ἀδελφοῖς, καὶ παντὶ τῷ οἴκῳ τοῦ πατρὸς αὐτοῦ, σῖτον κατὰ σῶμα. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Σῖτος δὲ οὐκ ἦν ἐν πάσῃ τῇ γῇ, ἐνίσχυσε γὰρ ὁ λιμὸς σφόδρα· ἐξέλιπε δὲ ἡ γῆ Αἰγύπτου καὶ ἡ γῆ Χαναὰν ἀπὸ τοῦ λιμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Συνήγαγε δὲ Ἰωσὴφ πᾶν τὸ ἀργύριον τὸ εὑρεθὲν ἐν γῇ Αἰγύπτου καὶ ἐν γῇ Χαναὰν, τοῦ σίτου, οὗ ἠγόραζον, καὶ ἐσιτομέτρει αὐτοῖς, καὶ εἰσήνεγκεν Ἰωσὴφ πᾶν τὸ ἀργύριον εἰς τὸν οἶκον Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Καὶ ἐξέλιπε πᾶν τὸ ἀργύριον ἐκ γῆς Αἰγύπτου καὶ ἐκ γῆς Χαναάν· ἦλθον δὲ πάντες οἱ Αἰγύπτιοι πρὸς Ἰωσὴφ, λέγοντες, δὸς ἡμῖν ἄρτους, καὶ ἱνατί ἀποθνήσκομεν ἐναντίον σου; ἐκλέλοιπε γὰρ τὸ ἀργύριον ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Εἶπε δὲ αὐτοῖς Ἰωσὴφ, φέρετε τὰ κτήνη ὑμῶν, καὶ δώσω ὑμῖν ἄρτους, ἀντὶ τῶν κτηνῶν ὑμῶν, εἰ ἐκλέλοιπε τὸ ἀργύριον ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ἤγαγον δὲ τὰ κτήνη αὐτῶν πρὸς Ἰωσήφ· καὶ ἔδωκεν αὐτοῖς Ἰωσὴφ ἄρτους ἀντὶ τῶν ἵππων, καὶ ἀντὶ τῶν προβάτων, καὶ ἀντὶ τῶν βοῶν, καὶ ἀντὶ τῶν ὄνων· καὶ ἐξέθρεψεν αὐτοὺς ἐν ἄρτοις ἀντὶ πάντων τῶν κτηνῶν αὐτῶν ἐν τῷ ἐνιαυτῷ ἐκείνῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ἐξῆλθε δὲ τὸ ἔτος ἐκεῖνο, καὶ ἦλθον πρὸς αὐτὸν ἐν τῷ ἔτει τῷ δευτέρῳ, καὶ εἶπαν αὐτῷ, μή ποτε ἐκτριβῶμεν ἀπὸ τοῦ κυρίου ἡμῶν; εἰ γὰρ ἐκλέλοιπε τὸ ἀργύριον ἡμῶν, καὶ τὰ ὑπάρχοντα καὶ τὰ κτήνη πρός σε τὸν κύριον, καὶ οὐχ ὑπολέλειπται ἡμῖν ἐναντίον τοῦ κυρίου ἡμῶν, ἀλλʼ ἢ τὸ ἴδιον σῶμα καὶ ἡ γῆ ἡμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ἵνα οὖν μὴ ἀποθάνωμεν ἐναντίον σου, καὶ ἡ γῆ ἐρημωθῇ, κτῆσαι ἡμᾶς καὶ τὴν γῆν ἡμῶν ἀντὶ ἄρτων, καὶ ἐσόμεθα ἡμεῖς καὶ ἡ γῆ ἡμῶν παῖδες τῷ Φαραώ· δὸς σπέρμα, ἵνα σπείρωμεν, καὶ ζῶμεν καὶ μὴ ἀποθάνωμεν, καὶ ἡ γῆ οὐκ ἐρημωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Καὶ ἐκτήσατο Ἰωσὴφ πᾶσαν τὴν γῆν τῶν Αἰγυπτίων τῷ Φαραώ· ἀπέδοντο γὰρ οἱ Αἰγύπτιοι τὴν γῆν αὐτῶν τῷ Φαραώ· ἐπεκράτησε γὰρ αὐτῶν ὁ λιμός· καὶ ἐγένετο ἡ γῆ τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Καὶ τὸν λαὸν κατεδουλώσατο αὐτῷ εἰς παῖδας, ἀπʼ ἄκρων ὁρίων Αἰγύπτου ἕως τῶν ἄκρων, ");
INSERT INTO grcbrent_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","χωρὶς τῆς γῆς τῶν ἱερέων μόνον· οὐκ ἐκτήσατο ταύτην Ἰωσήφ· ἐν δόσει γὰρ ἔδωκε δόμα τοῖς ἱερεῦσι Φαραὼ, καὶ ἤσθιον τὴν δόσιν, ἣν ἔδωκεν αὐτοῖς Φαραώ· διὰ τοῦτο οὐκ ἀπέδοντο τὴν γῆν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Εἶπε δὲ Ἰωσὴφ πᾶσι τοῖς Αἰγυπτίοις, ἰδοὺ κέκτημαι ὑμᾶς καὶ τὴν γῆν ὑμῶν σήμερον τῷ Φαραῷ· λάβετε ἑαυτοῖς σπέρμα, καὶ σπείρατε τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Καὶ ἔσται τὰ γεννήματα αὐτῆς· καὶ δώσετε τὸ πεμπτὸν μέρος τῷ Φαραώ· τὰ δὲ τέσσαρα μέρη ἔσται ὑμῖν αὐτοῖς εἰς σπέρμα τῇ γῇ, καὶ εἰς βρῶσιν ὑμῖν, καὶ πᾶσι τοῖς ἐν τοῖς οἴκοις ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Καὶ εἶπαν, σέσωκας ἡμᾶς· εὕρομεν χάριν ἐναντίον τοῦ κυρίου ἡμῶν, καὶ ἐσόμεθα παῖδες τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Καὶ ἔθετο αὐτοῖς Ἰωσὴφ εἰς πρόσταγμα ἕως τῆς ἡμέρας ταύτης, ἐπὶ γῆς Αἰγύπτου τῷ Φαραὼ ἀποπεμπτοῦν, χωρὶς τῆς γῆς τῶν ἱερέων μόνον· οὐκ ἧν τῷ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Κατῶκησε δὲ Ἰσραὴλ ἐν γῇ Αἰγύπτῳ ἐπὶ γῆς Γεσὲμ, καὶ ἐκληρονόμησαν ἐπʼ αὐτῆς· καὶ ηὐξήθησαν καὶ ἐπληθύνθησαν σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ἐπέζησε δὲ Ἰακὼβ ἐν γῇ Αἰγύπτῳ δεκαεπτὰ ἔτη· καὶ ἐγένοντο αἱ ἡμέραι Ἰακὼβ ἐνιαυτῶν τῆς ζωῆς αὐτοῦ ἑκατὸν τεσσαρακονταεπτὰ ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ἤγγισαν δὲ αἱ ἡμέραι Ἰσραὴλ τοῦ ἀποθανεῖν· καὶ ἐκάλεσε τὸν υἱὸν αὐτοῦ Ἰωσὴφ, καὶ εἶπεν αὐτῷ, εἰ εὕρηκα χάριν ἐναντίον σου, ὑπόθες τὴν χεῖρά σου ὑπὸ τὸν μηρόν μου, καὶ ποιήσεις ἐπʼ ἐμὲ ἐλεημοσύνην, καὶ ἀλήθειαν, τοῦ μή με θάψαι ἐν Αἰγύπτῳ· ");
INSERT INTO grcbrent_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ἀλλὰ κοιμηθήσομαι μετὰ τῶν πατέρων μου· καὶ ἀρεῖς με ἐξ Αἰγύπτου, καὶ θάψεις με ἐν τῷ τάφῳ αὐτῶν· ὁ δὲ εἶπεν, ἐγὼ ποιήσω κατὰ τὸ ῥῆμά σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Εἶπε δὲ, ὄμοσόν μοι· καὶ ὤμοσεν αὐτῷ· καὶ προσεκύνησεν Ἰσραὴλ ἐπὶ τὸ ἄκρον τῆς ῥάβδου αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ἐγένετο δὲ μετὰ τὰ ῥήματα ταῦτα, καὶ ἀπηγγέλη τῷ Ἰωσὴφ, ὅτι ὁ πατήρ σου ἐνοχλεῖται· καὶ ἀναλαβὼν τοὺς δύο υἱοὺς αὐτοῦ τὸν Μανασσῆ καὶ τὸν Ἐφραὶμ, ἦλθε πρὸς Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ἀπηγγέλη δὲ τῷ Ἰακὼβ, λέγοντες, ἰδοὺ ὁ υἱός σου Ἰωσὴφ ἔρχεται πρὸς σέ· καὶ ἐνισχύσας Ἰσραὴλ ἐκάθισεν ἐπὶ τὴν κλίνην. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Καὶ εἶπεν Ἰακὼβ τῷ Ἰωσὴφ, ὁ Θεός μου ὤφθη μοι ἐν Λουζᾷ ἐν γῇ Χαναὰν, καὶ εὐλόγησέ με, ");
INSERT INTO grcbrent_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","καὶ εἶπέ μοι, ἰδοὺ ἐγὼ αὐξανῶ σε, καὶ πληθυνῶ σε, καὶ ποιήσω σε εἰς συναγωγὰς ἐθνῶν· καὶ δώσω σοι τὴν γῆν ταύτην, καὶ τῷ σπέρματί σου μετὰ σὲ, εἰς κατάσχεσιν αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Νῦν οὖν οἱ δύο υἱοί σου, οἱ γενόμενοί σοι ἐν γῇ Αἰγύπτῳ πρὸ τοῦ με ἐλθεῖν πρός σε εἰς Αἴγυπτον, ἐμοί εἰσιν, Ἐφραὶμ καὶ Μανασσῆ· ὡς Ῥουβὴν καὶ Συμεὼν ἔσονταί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Τὰ δὲ ἔκγονα, ἃ ἐὰν γεννήσῃς μετὰ ταῦτα, ἔσονται ἐπὶ τῷ ὀνόματι τῶν ἀδελφῶν αὐτῶν· κληθήσονται ἐπὶ τοῖς ἐκείνων κλήροις. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ἐγὼ δὲ ἡνίκα ἠρχόμην ἐκ Μεσοποταμίας τῆς Συρίας, ἀπέθανε Ῥαχὴλ ἡ μήτηρ σου ἐν γῇ Χαναὰν, ἐγγίζοντός μου κατὰ τὸν ἱππόδρομον Χαβραθὰ τῆς γῆς, τοῦ ἐλθεῖν Ἐφραθά· καὶ κατώρυξα αὐτὴν ἐν τῇ ὁδῷ τοῦ ἱπποδρόμου· αὕτη ἐστὶ Βηθλεέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ἰδὼν δὲ Ἰσραὴλ τοὺς υἱοὺς Ἰωσὴφ, εἶπε, τίνες σοι οὗτοι; ");
INSERT INTO grcbrent_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Εἶπε δὲ Ἰωσὴφ τῷ πατρὶ αὐτοῦ, υἱοί μου εἰσὶν, οὓς ἔδωκε μοι ὁ Θεὸς ἐνταῦθα. Καὶ εἶπεν Ἰακὼβ, προσάγαγέ μοι αὐτοὺς, ἵνα εὐλογήσω αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Οἱ ὀφθαλμοὶ δὲ Ἰσραὴλ ἐβαρυώπησαν ἀπὸ τοῦ γήρως, καὶ οὐκ ἠδύνατο βλέπειν· καὶ ἤγγισεν αὐτοὺς πρὸς αὐτὸν, καὶ ἐφίλησεν αὐτοὺς, καὶ περιέλαβεν αὐτους. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Καὶ εἶπεν Ἰσραὴλ πρὸς Ἰωσὴφ, ἰδοὺ τοῦ προσώπου σου οὐκ ἐστερήθην, καὶ ἰδοὺ ἔδειξέ μοι ὁ Θεὸς καὶ τὸ σπέρμα σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Καὶ ἐξήγαγεν αὐτοὺς Ἰωσὴφ ἀπὸ τῶν γονάτων αὐτοῦ· καὶ προσεκύνησαν αὐτῷ ἐπὶ πρόσωπον ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Λαβὼν δὲ Ἰωσὴφ τοὺς δύο υἱοὺς αὐτοῦ, τόν τε Ἐφραὶμ ἐν τῇ δεξιᾷ, ἐξ ἀριστερῶν δὲ Ἰσραὴλ, τὸν δὲ Μανασσῆ ἐξ ἀριστερῶν, ἐκ δεξιῶν δὲ Ἰσραὴλ, ἤγγισεν αὐτοὺς αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ἐκτείνας δὲ Ἰσραὴλ τὴν χεῖρα τὴν δεξιὰν, ἐπέβαλεν ἐπὶ τὴν κεφαλὴν Ἐφραὶμ, οὗτος δὲ ἦν ὁ νεώτερος, καὶ τὴν ἀριστερὰν ἐπὶ τὴν κεφαλὴν Μανασσῆ, ἐναλλὰξ τὰς χεῖρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Καὶ εὐλόγησεν αὐτοὺς, καὶ εἶπεν, ὁ Θεὸς, ᾧ εὐηρέστησαν οἱ πατέρες μου ἐνώπιον αὐτοῦ, Ἁβραὰμ καὶ Ἰσαὰκ, ὁ Θεὸς ὁ τρέφων με ἐκ νεότητος ἕως τῆς ἡμέρας ταύτης, ");
INSERT INTO grcbrent_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ὁ Ἄγγελος ὁ ῥυόμενός με ἐκ πάντων τῶν κακῶν, εὐλογήσαι τὰ παιδία ταῦτα· καὶ ἐπικληθήσεται ἐν αὐτοις τὸ ὄνομά μου, καὶ τὸ ὄνομα τῶν πατέρων μου Ἁβραὰμ καὶ Ἰσαάκ· καὶ πληθυνθείησαν εἰς πλῆθος πολὺ ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ἰδὼν δὲ Ἰωσὴφ ὅτι ἐπέβαλεν ὁ πατὴρ αὐτοῦ τὴν χεῖρα τὴν δεξιὰν αὐτοῦ ἐπὶ τὴν κεφαλὴν Ἐφραὶμ, βαρὺ αὐτῷ κατεφάνη· καὶ ἀντελάβετο Ἰωσὴφ τῆς χειρὸς τοῦ πατρὸς αὐτοῦ, ἀφελεῖν αὐτὴν ἀπὸ τῆς κεφαλῆς Ἐφραὶμ ἐπὶ τὴν κεφαλὴν Μανασσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Εἶπε δὲ Ἰωσὴφ τῷ πατρὶ αὐτοῦ, οὐχ οὕτως, πατὴρ, οὗτος γὰρ ὁ πρωτότοκος· ἐπίθες τὴν δεξιάν σου ἐπὶ τὴν κεφαλὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Καὶ οὐκ ἠθέλησεν, ἀλλʼ εἶπεν, οἶδα, τέκνον, οἶδα· καὶ οὗτος ἔσται εἰς λαὸν, καὶ οὗτος ὑψωθήσεται· ἀλλʼ ὁ ἀδελφὸς αὐτοῦ ὁ νεώτερος μείζον αὐτοῦ ἔσται, καὶ τὸ σπέρμα αὐτοῦ ἔσται εἰς πλῆθος ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Καὶ εὐλόγησεν αὐτοὺς ἐν τῇ ἡμέρᾳ ἐκείνῃ, λέγων, ἐν ὑμῖν εὐλογηθήσεται Ἰσραὴλ, λέγοντες, ποιήσαι σε ὁ Θεὸς ὡς Ἐφραὶμ καὶ ὡς Μανασσῆ· καὶ ἔθηκε τὸν Ἐφραὶμ ἔμπροσθεν τοῦ Μανασσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Εἶπε δὲ Ἰσραὴλ τῷ Ἰωσὴφ, ἰδοὺ ἐγὼ ἀποθνήσκω· καὶ ἔσται ὁ Θεὸς μεθʼ ὑμῶν, καὶ ἀποστρέψει ὑμᾶς εἰς τὴν γῆν τῶν πατέρων ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ἐγὼ δὲ δίδωμί σοι Σίκιμα ἐξαίρετον ὑπὲρ τοὺς ἀδελφούς σου, ἣν ἔλαβον ἐκ χειρὸς Ἀμοῤῥαίων ἐν μαχαίρᾳ μου καὶ τόξῳ. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ἐκάλεσε δὲ Ἰακὼβ τοὺς υἱοὺς αὐτοῦ, καὶ εἶπεν αὐτοῖς, συνάχθητε, ἵνα ἀναγγείλω ὑμῖν, τί ἀπαντήσει ὑμῖν ἐπʼ ἐσχάτων τῶν ἡμέρων. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Συνάχθητε, καὶ ἀκούσατέ μου, υἱοὶ Ἰακώβ· ἀκούσατε Ἰσραὴλ, ἀκούσατε τοῦ πατρὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ῥουβὴν πρωτότοκός μου, σὺ ἰσχύς μου, καὶ ἀρχὴ τέκνων μου, σκληρὸς φέρεσθαι, καὶ σκληρὸς αὐθάδης. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ἐξύβρισας ὡς ὕδωρ, μὴ ἐκζέσῃς, ἀνέβης γὰρ ἐπὶ τὴν κοίτην τοῦ πατρός σου· τότε ἐμίανας τὴν στρωμνὴν, οὗ ἀνέβης. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Συμεὼν καὶ Λευὶ ἀδελφοὶ συνετέλεσαν ἀδικίαν ἐξαιρέσεως αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Εἰς βουλὴν αὐτῶν μὴ ἔλθοι ἡ ψυχή μου, καὶ ἐπὶ τῇ συστάσει αὐτῶν μὴ ἐρίσαι τὰ ἥπατά μου· ὅτι ἐν τῷ θυμῷ αὐτῶν ἀπέκτειναν ἀνθρώπους, καὶ ἐν τῇ ἐπιθυμίᾳ αὐτῶν ἐνευροκόπησαν ταῦρον. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ἐπικατάρατος ὁ θυμὸς αὐτὼν, ὅτι αὐθάδης· καὶ ἡ μῆνις αὐτῶν, ὅτι ἐσκληρύνθη· διαμεριῷ αὐτοὺς ἐν Ἰακὼβ, καὶ διασπερῷ αὐτοὺς ἐν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ἰούδα, σὲ αἰνέσαισαν οἱ ἀδελφοί σου· αἱ χεῖρές σου ἐπὶ νώτου τῶν ἐχθρῶν σου· προσκυνήσουσί σοι οἱ υἱοὶ τοῦ πατρός σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Σκύμνος λέοντος Ἰούδα· ἐκ βλαστοῦ, υἱέ μου, ἀνέβης· ἀναπεσὼν ἐκοιμήθης ὡς λέων καὶ ὡς σκύμνος· τίς ἐγερεῖ αὐτόν; ");
INSERT INTO grcbrent_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Οὐκ ἐκλείψει ἄρχων ἐξ Ἰούδα, καὶ ἡγούμενος ἐκ τῶν μηρῶν αὐτοῦ, ἕως ἐὰν ἔλθῃ τὰ ἀποκείμενα αὐτῷ· καὶ αὐτὸς προσδοκία ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Δεσμεύων πρὸς ἄμπελον τὸν πῶλον αὐτοῦ, καὶ τῇ ἕλικι τὸν πῶλον τῆς ὄνου αὐτοῦ, πλυνεῖ ἐν οἴνῳ τὴν στολὴν αὐτοῦ, καὶ ἐν αἵματι σταφυλῆς τὴν περιβολὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Χαροποιοὶ οἱ ὀφθαλμοὶ αὐτοῦ ὑπὲρ οἶνον· καὶ λευκοὶ οἱ ὀδόντες αὐτοῦ ἢ γάλα. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ζαβουλὼν παράλιος κατοικήσει καὶ αὐτὸς παρʼ ὅρμον πλοίων, καὶ παρατενεῖ ἕως Σιδῶνος. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ἰσσάχαρ τὸ καλὸν ἐπεθύμησεν, ἀναπαυόμενος ἀνὰ μέσον τῶν κλήρων. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Καὶ ἰδὼν τὴν ἀνάπαυσιν ὅτι καλὴ, καὶ τὴν γῆν ὅτι πίων, ὑπέθηκε τὸν ὦμον αὐτοῦ εἰς τὸ πονεῖν, καὶ ἐγενήθη ἀνὴρ γεωργός. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Δὰν κρινεῖ τὸν λαὸν αὐτοῦ, ὡσεὶ καὶ μία φυλὴ ἐν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Καὶ γενηθητω Δὰν ὄφις ἐφʼ ὁδοῦ, ἐγκαθήμενος ἐπὶ τρίβου, δάκνων πτέρναν ἵππου· καὶ πεσεῖται ὁ ἱππεὺς εἰς τὰ ὀπίσω, ");
INSERT INTO grcbrent_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","τὴν σωτηρίαν περιμένων Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Γὰδ, πειρατήριον πειρατεύσει αὐτόν· αὐτὸς δὲ πειράτεύσει αὐτὸν κατὰ πόδας. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ἀσὴρ, πίων αὐτοῦ ὁ ἄρτος· καὶ αὐτὸς δώσει τρυφὴν ἄρχουσι. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Νεφθαλὶ στέλεχος ἀνειμένον, ἐπιδιδοὺς ἐν τῷ γεννήματι κάλλος. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Υἱὸς ηὐξημένος Ἰωσὴφ, υἱὸς ηὐξημένος μου ζηλωτὸς, υἱός μου νεώτατος· πρός με ἀνάστρεψον. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Εἰς ὃν διαβουλευόμενοι ἐλοιδόρουν, καὶ ἐνεῖχον αὐτῷ κύριοι τοξευμάτων. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Καὶ συνετρίβη μετὰ κράτους τὰ τόξα αὐτῶν· καὶ ἐξελύθη τὰ νεῦρα βραχιόνων χειρὸς αὐτῶν, διὰ χεῖρα δυνάστου Ἰακώβ· ἐκεῖθεν ὁ κατισχύσας Ἰσραὴλ παρὰ Θεοῦ τοῦ πατρός σου. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Καὶ ἐβοήθησέ σοι ὁ Θεὸς ὁ ἐμὸς, καὶ εὐλόγησέ σε εὐλογίαν οὐρανοῦ ἄνωθεν, καὶ εὐλογίαν γῆς ἐχούσης πάντα, εἵνεκεν εὐλογίας μαστῶν καὶ μήτρας, ");
INSERT INTO grcbrent_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","εὐλογίας πατρός σου καὶ μητρός σου· ὑπερίσχυσεν ὑπὲρ εὐλογίας ὀρέων μονίμων, καὶ ἐπʼ εὐλογίαις θινῶν ἀενάων· ἔσονται ἐπὶ κεφαλὴν Ἰωσὴφ, καὶ ἐπὶ κορυφῆς ὧν ἡγήσατο ἀδελφῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Βενιαμὶν λύκος ἅρπαξ, τὸ πρωϊνὸν ἔδεται ἔτι, καὶ εἰς τὸ ἑσπέρας δίδωσι τροφήν. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Πάντες οὕτοι υἱοὶ Ἰακὼβ δώδεκα· καὶ ταῦτα ἐλάλησεν αὐτοῖς ὁ πατὴρ αὐτῶν· καὶ εὐλόγησεν αὐτούς· ἕκαστον κατὰ τὴν εὐλογίαν αὐτοῦ εὐλόγησεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Καὶ εἶπεν αὐτοῖς, ἐγὼ προστίθεμαι πρὸς τὸν ἐμὸν λαόν· θάψτέ με μετὰ τῶν πατέρων μου ἐν τῷ σπηλαίῳ, ὅ ἐστιν ἐν τῷ ἀγρῷ Ἐφρὼν τοῦ Χετταίου, ");
INSERT INTO grcbrent_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ἐν τῷ σπηλαίῳ τῷ διπλῷ, τῷ ἀπέναντι Μαμβρῆ, ἐν γῇ Χαναὰν, ὃ ἐκτήσατο Ἁβραὰμ τὸ σπήλαιον παρὰ Ἐφρὼν τοῦ Χετταίου ἐν κτήσει μνημείου. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ἐκεῖ ἔθαψαν Ἁβραὰμ καὶ Σάῤῥαν τὴν γυναῖκα αὐτοῦ· ἐκεῖ ἔθαψαν Ἰσαὰκ καὶ Ῥεβέκκαν τὴν γυναῖκα αὐτοῦ· ἐκεῖ ἔθαψαν Λείαν· ");
INSERT INTO grcbrent_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ἐν κτήσει τοῦ ἀγροῦ καὶ τοῦ σπηλαίου τοῦ ὄντος ἐν αὐτῷ, παρὰ τῶν υἱῶν Χέτ. ");
INSERT INTO grcbrent_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Καὶ κατέπαυσεν Ἰακὼβ ἐπιτάσσων τοῖς υἱοῖς αὐτοῦ· καὶ ἐξᾴρας τοὺς πόδας αὐτοῦ ἐπὶ τὴν κλίνην, ἐξέλιπε· καὶ προσετέθη πρὸς τὸν λαὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Καὶ ἐπιπεσὼν Ἰωσὴφ ἐπὶ πρόσωπον τοῦ πατρὸς αὐτοῦ ἔκλαυσεν αὐτὸν, καὶ ἐφίλησεν αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Καὶ προσέταξεν Ἰωσὴφ τοῖς παισὶν αὐτοῦ τοῖς ἐνταφιασταῖς, ἐνταφιάσαι τὸν πατέρα αὐτοῦ· καὶ ἐνεταφίασαν οἱ ἐνταφιασταὶ τὸν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Καὶ ἐπλήρωσαν αὐτοῦ τεσσαράκοντα ἡμέρας· οὕτω γὰρ καταριθμοῦνται αἱ ἡμέραι τῆς ταφῆς· καὶ ἐπένθησεν αὐτὸν Αἴγυπτος ἑβδομήκοντα ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ἐπεὶ δὲ παρῆλθον αἱ ἡμέραι τοῦ πένθους, ἐλάλησεν Ἰωσὴφ πρὸς τοὺς δυνάστας Φαραὼ, λέγων, εἰ εὗρον χάριν ἐναντίον ὑμῶν, λαλήσατε περὶ ἐμοῦ εἰς τὰ ὦτα Φαραὼ, λέγοντες, ");
INSERT INTO grcbrent_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ὁ πατήρ μου ὥρκισέ με, λέγων, ἐν τῷ μνημείῳ, ᾧ ὤρυξα ἐμαυτῷ ἐν γῇ Χαναὰν, ἐκεῖ με θάψεις· νῦν οὖν ἀναβὰς· θάψω τὸν πατέρα μου, καὶ ἐπανελεύσομαι· ");
INSERT INTO grcbrent_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Καὶ εἶπε Φαραὼ τῷ Ἰωσὴφ, ἀνάβηθι, θάψον τὸν πατέρα σου, καθάπερ ὥρκισέ σε. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Καὶ ἀνέβη Ἰωσὴφ θάψαι τὸν πατέρα αὐτοῦ· καὶ συνανέβησαν μετʼ αὐτοῦ πάντες οἱ παῖδες Φαραὼ, καὶ οἱ πρεσβύτεροι τοῦ οἴκου αὐτοῦ, καὶ πάντες οἱ πρεσβύτεροι τῆς γῆς Αἰγύπτου, ");
INSERT INTO grcbrent_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","καὶ πᾶσα ἡ πανοικία Ἰωσὴφ, καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ πᾶσα ἡ οἰκία ἡ πατρικὴ αὐτοῦ, καὶ ἡ συγγένεια αὐτοῦ· καὶ τὰ πρόβατα, καὶ τοὺς βόας ὑπελίποντο ἐν γῇ Γεσέμ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Καὶ συνανέβησαν μετʼ αὐτοῦ καὶ ἅρματα καὶ ἱππεῖς, καὶ ἐγένετο ἡ παρεμβολὴ μεγάλη σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Καὶ παρεγένοντο εἰς ἅλωνα Ἀτὰδ, ὅ ἐστι πέραν τοῦ Ἰορδάνου· καὶ ἐκόψαντο αὐτὸν κοπετὸν μέγαν καὶ ἰσχυρὸν σφόδρα· καὶ ἐποίησε τὸ πένθος τῷ πατρὶ αὐτοῦ ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Καὶ εἶδον οἱ κάτοικοι τῆς γῆς Χαναὰν τὸ πένθος ἐπὶ ἅλωνι Ἀτὰδ, καὶ εἶπαν, πένθος μέγα τοῦτό ἐστι τοῖς Αἰγυπτίοις· διὰ τοῦτο ἐκάλεσε τὸ ὄνομα αὐτοῦ, Πένθος Αἰγύπτου, ὅ ἐστι πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Καὶ ἐποίησαν αὐτῷ οὕτως οἱ υἱοὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Καὶ ἀνέλαβον αὐτὸν οἱ υἱοὶ αὐτοῦ εἰς γῆν Χαναάν· καὶ ἔθαψαν αὐτὸν εἰς τὸ σπήλαιον τὸ διπλοῦν, ὃ ἐκτήσατο Ἁβραὰμ τὸ σπήλαιον ἐν κτήσει μνημείου παρὰ Ἐφρὼν τοῦ Χετταίου, κατέναντι Μαμβρή. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Καὶ ὑπέστρεψεν Ἰωσὴφ εἰς Αἴγυπτον, αὐτὸς καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ οἱ συναναβάντες θάψαι τὸν πατέρα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ἰδόντες δὲ οἱ ἀδελφοὶ Ἰωσὴφ, ὅτι τέθνηκεν ὁ πατὴρ αὐτῶν, εἶπαν, μή ποτε μνησικακήσῃ ἡμῖν Ἰωσὴφ, καὶ ἀνταπόδομα ἀνταποδῷ ἡμῖν πάντα τὰ κακὰ, ἃ ἐνεδειξάμεθα εἰς αὐτὸν. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Καὶ παραγενόμενοι πρὸς Ἰωσὴφ εἶπαν, ὁ πατήρ σου ὥρκισε πρὸ τοῦ τελευτῆσαι αὐτὸν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","οὕτως εἴπατε Ἰωσήφ· ἄφες αὐτοῖς τὴν ἀδικίαν καὶ τὴν ἁμαρτίαν αὐτῶν, ὅτι πονηρά σοι ἐνεδείξαντο· καὶ νῦν δέξαι τὴν ἀδικίαν τῶν θεραπόντων τοῦ Θεοῦ τοῦ πατρός σου· καὶ ἔκλαυσεν Ἰωσὴφ λαλούντων αὐτῶν πρὸς αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Καὶ ἐλθόντες πρὸς αὐτὸν εἶπαν, οἵδε ἡμεῖς σοὶ οἰκέται. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Καὶ εἶπεν αὐτοῖς Ἰωσὴφ, μὴ φοβεῖσθε, τοῦ γὰρ Θεοῦ εἰμι ἐγώ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ὑμεῖς ἐβουλεύσασθε κατʼ ἐμοῦ εἰς πονηρὰ, ὁ δὲ Θεὸς ἐβουλεύσατο περὶ ἐμοῦ εἰς ἀγαθὰ, ὅπως ἂν γενηθῇ ὡς σήμερον, καὶ τραφῇ λαὸς πολύς. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Καὶ εἶπεν αὐτοῖς, μὴ φοβεῖσθε· ἐγὼ διαθρέψω ὑμᾶς, καὶ τὰς οἰκίας ὑμῶν· καὶ παρεκάλεσεν αὐτοὺς, καὶ ἐλάλησεν αὐτῶν εἰς τὴν καρδίαν. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Καὶ κατῴκησεν Ἰωσὴφ ἐν Αἰγύπτῳ, αὐτὸς καὶ οἱ ἀδελφοὶ αὐτοῦ, καὶ πᾶσα ἡ πανοικία τοῦ πατρὸς αὐτοῦ· καὶ ἔζησεν Ἰωσὴφ ἔτη ἑκατὸν δέκα. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Καὶ εἶδεν Ἰωσὴφ Ἐφραὶμ παιδία, ἕως τρίτης γενεᾶς· καὶ οἱ υἱοὶ Μαχεὶρ τοῦ υἱοῦ Μανασσῆ ἐτέχθησαν ἐπὶ μηρῶν Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Καὶ εἶπεν Ἰωσὴφ τοῖς ἀδελφοῖς αὐτοῦ, λέγων, ἐγὼ ἀποθνήσκω· ἐπισκοπῇ δὲ ἐπισκέψεται ὁ Θεὸς ὑμᾶς, καὶ ἀνάξει ὑμᾶς ἐκ τῆς γῆς ταύτης εἰς τὴν γῆν, ἣν ὤμοσεν ὁ Θεὸς τοῖς πατράσιν ἡμῶν, Ἁβραὰμ, Ἰσαὰκ, καὶ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Καὶ ὥρκισεν Ἰωσὴφ τοὺς υἱοὺς Ἰσραὴλ, λέγων, ἐν τῇ ἐπισκοπῇ ᾗ ἐπισκέψηται ὁ Θεὸς ὑμᾶς, καὶ συνανοίσετε τὰ ὀστᾶ μου ἐντεῦθεν μεθʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Καὶ ἐτελεύτησεν Ἰωσὴφ ἐτῶν ἑκατὸν δέκα· καὶ ἔθαψαν αὐτὸν, καὶ ἔθηκαν ἐν τῇ σορῷ ἐν Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ΤΑΥΤΑ τὰ ὀνόματα τῶν υἱῶν Ἰσραὴλ τῶν εἰσπεπορευμένων εἰς Αἴγυπτον ἅμα Ἰακὼβ τῷ πατρὶ αὐτῶν, ἕκαστος πανοικὶ αὐτῶν εἰσήλθοσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ῥουβὴν, Συμεών, Λευὶ, Ἰούδας, ");
INSERT INTO grcbrent_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ἰσσάχαρ, Ζαβουλὼν, Βενιαμὶν, ");
INSERT INTO grcbrent_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Δὰν, καὶ Νεφθαλὶ, Γὰδ, καὶ Ἀσήρ. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ἰωσὴφ δὲ ἦν ἐν Αἰγύπτῳ· ἦσαν δὲ πᾶσαι ψυχαὶ ἐξ Ἰακὼβ, πέντε καὶ ἑβδομήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ἐτελεύτησε δὲ Ἰωσὴφ, καὶ πάντες οἱ ἀδελφοὶ αὐτοῦ, καὶ πᾶσα ἡ γενεὰ ἐκείνη. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Οἱ δὲ υἱοὶ Ἰσραὴλ ηὐξήθησαν, καὶ ἐπληθύνθησαν, καὶ χυδαῖοι ἐγένοντο, καὶ κατίσχυον σφόδρα σφόδρα· ἐπλήθυνε δὲ ἡ γῆ αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ἀνέστη δὲ βασιλεὺς ἕτερος ἐπʼ Αἴγυπτον, ὃς οὐκ ᾔδει τὸν Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Εἶπε δὲ τῷ ἔθνει αὐτοῦ, ἰδοὺ τὸ γένος τῶν υἱῶν Ἰσραὴλ μέγα πλῆθος, καὶ ἰσχύει ὑπὲρ ἡμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Δεῦτε οὖν κατασοφισώμεθα αὐτοὺς, μήποτε πληθυνθῇ, καὶ ἡνίκα ἂν συμβῇ ἡμῖν πόλεμος, προστεθήσονται καὶ οὗτοι πρὸς τοὺς ὑπεναντίους, καὶ ἐκπολεμήσαντες ἡμᾶς, ἐξελεύσονται ἐκ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Καὶ ἐπέστησεν αὐτοῖς ἐπιστάτας τῶν ἔργων, ἵνα κακώσωσιν αὐτοὺς ἐν τοῖς ἔργοις. Καὶ ᾠκοδόμησαν πόλεις ὀχυρὰς τῷ Φαραῷ, τήν τε Πειθὼ, καὶ Ῥαμεσσῆ, καὶ Ὢν, ἥ ἐστιν Ἡλιού πολις. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Καθότι δὲ αὐτοὺς ἐταπείνουν, τοσούτῳ πλείους ἐγίνοντο, καὶ ἴσχυον σφόδρα σφόδρα· καὶ ἐβδελύσσοντο οἱ Αἰγύπτιοι ἀπὸ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Καὶ κατεδυνάστευον οἱ Αἰγύπτιοι τοὺς υἱοὺς Ἰσραὴλ βίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Καὶ κατωδύνων αὐτῶν τὴν ζωὴν ἐν τοῖς ἔργοις τοῖς σκληροῖς, τῷ πηλῷ καὶ τῇ πλινθείᾳ, καὶ πᾶσι τοῖς ἔργοις τοῖς ἐν τοῖς πεδίοις, κατὰ πάντα τὰ ἔργα, ὧν κατεδουλοῦντο αὐτοὺς μετὰ βίας. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Καὶ εἶπεν ὁ βασιλεὺς τῶν Αἰγυπτίων ταῖς μαίαις τῶν Ἐβραίων, τῇ μιᾷ αὐτῶν ὄνομα Σεπφώρα, καὶ τὸ ὄνομα τῆς δευτέρας Φουά· ");
INSERT INTO grcbrent_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Καὶ εἶπεν, ὅταν μαιοῦσθε τὰς Ἐβραίας, καὶ ὦσι πρὸς τῷ τίκτειν, ἐὰν μὲν ἄρσεν ᾖ, ἀποκτείνατε αὐτό· ἐὰν δὲ θῆλυ, περιποιεῖσθε αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ἐφοβήθησαν δὲ αἱ μαῖαι τὸν Θεὸν, καὶ οὐκ ἐποίησαν καθότι συνέταξεν αὐταῖς ὁ βασιλεὺς Αἰγύπτου, καὶ ἐζωογόνουν τὰ ἄρσενα. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ἐκάλεσε δὲ ὁ βασιλεὺς Αἰγύπτου τὰς μαίας, καὶ εἶπεν αὐταῖς, τί ὅτι ἐποιήσατε τὸ πρᾶγμα τοῦτο, καὶ ἐζωογονεῖτε τὰ ἄρσενα; ");
INSERT INTO grcbrent_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Εἶπαν δὲ αἱ μαῖαι τῷ Φαραῷ, οὐχ ὡς γυναῖκες Αἰγύπτου αἱ Ἐβραῖαι· τίκτουσι γὰρ πρὶν ἢ εἰσελθεῖν πρὸς αὐτὰς τὰς μαίας· καὶ ἔτικτον. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Εὖ δὲ ἐποίει ὁ Θεὸς ταῖς μαίαις· καὶ ἐπλήθυνεν ὁ λαὸς, καὶ ἴσχυε σφόδπα. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ἐπεὶ δὲ ἐφοβοῦντο αἱ μαῖαι τὸν Θεὸν, ἐποίησαν ἑαυταῖς οἰκίας. ");
INSERT INTO grcbrent_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Συνέταξε δὲ Φαραὼ παντὶ τῷ λαῷ αὐτοῦ, λέγων, πᾶν ἄρσεν, ὃ ἐὰν τεχθῇ τοῖς Ἑβραίοις, εἰς τὸν ποταμὸν ῥίψατε, καὶ πᾶν θῆλυ, ζωογονεῖτε αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ἦν δέ τις ἐκ τῆς φυλῆς Λευὶ, ὃς ἔλαβεν τῶν θυγατέρων Λευί. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Καὶ ἐν γαστρὶ ἔλαβε, καὶ ἔτεκεν ἄρσεν· ἰδόντες δὲ αὐτὸ ἀστεῖον, ἐσπέπασαν αὐτὸ μῆνας τρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ἐπεὶ δὲ οὐκ ἐδύναντο αὐτὸ ἔτι κρύπτειν, ἔλαβεν αὐτῷ ἡ μήτηρ αὐτοῦ θῖβιν, καὶ κατέχρισεν αὐτὴν ἀσφαλτοπίσσῃ, καὶ ἐνέβαλε τὸ παιδίον εἰς αὐτήν, καὶ ἔθηκεν αὐτὴν εἰς τὸ ἕλος παρὰ τὸν ποταμόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Καὶ κατεσκόπευεν ἡ ἀδελφὴ αὐτοῦ μακρόθεν, μαθεῖν τί τὸ ἀποβησόμενον αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Κατέβη δὲ ἡ θυγάτηρ Φαραὼ λούσασθαι ἐπὶ τὸν ποταμὸν, καὶ αἱ ἅβραι αὐτῆς παρεπορεύοντο παρὰ τὸν ποταμόν· καὶ ἰδοῦσα τὴν θίβιν ἐν τῷ ἕλει, ἀποστείλασα τὴν ἅβραν, ἀνείλατο αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ἀνοίξασα δὲ ὁρᾷ παιδίον κλαῖον ἐν τῇ θίβει· καὶ ἐφείσατο αὐτοῦ ἡ θυγάτηρ Φαραὼ, καὶ ἔφη, ἀπὸ τῶν παιδίων τῶν Ἐβραίων τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Καὶ εἶπεν ἡ ἀδελφὴ αὐτοῦ τῇ θυγατρὶ Φαραὼ, θέλεις καλέσω σοι γυναῖκα τροφεύουσαν ἐκ τῶν Ἐβραίων, καὶ θηλάσει σαι τὸ παιδὶον σοι τὸ παιδίον; ");
INSERT INTO grcbrent_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ἡ δὲ εἶπεν ἡ θυγάτηρ Φαραὼ, πορεύου· ἐλθοῦσα δὲ νεᾶνις ἐκάλεσε τὴν μητέρα τοῦ παιδίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Εἶπεν δὲ πρὸς αὐτὴν ἡ θυγάτηρ Φαραὼ, διατήρησόν μοι τὸ παιδίον τοῦτο, καὶ θήλασόν μοι αὐτὸ, ἐγὼ δὲ δώσω σοι τὸν μισθόν· ἔλαβε δὲ ἡ γυνὴ τὸ παιδίον, καὶ ἐθήλαζεν αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ἁδρυνθέντος δὲ τοῦ παιδίου, εἰσήγαγεν αὐτὸ πρὸς τὴν θυγατέρα Φαραὼ, καὶ ἐγενήθη αὐτῇ εἰς υἱόν· ἐπωνόμασε δὲ τὸ ὄνομα αὐτοῦ Μωυσῆν, λέγουσα, ἐκ τοῦ ὕδατος αὐτὸν ἀνειλόμην. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ἐγένετο δὲ ἐν ταῖς ἡμέραις ταῖς πολλαῖς ἐκείναις μέγας γενόμενος Μωυσῆς, ἐξῆλθε πρὸς τοὺς ἀδελφοὺς αὐτοῦ τοὺς υἱοὺς Ἰσραήλ· κατανοήσας δὲ τὸν πόνον αὐτῶν, ὁρᾷ ἄνθρωπον Αἰγύπτιον τύπτοντα τινὰ Ἐβραῖον, τῶν ἑαυτοῦ ἀδελφῶν τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Περιβλεψάμενος δὲ ὧδε καὶ ὧδε οὐχ ὁρᾷ οὐδένα, καὶ πατάξας τὸν Αἰγύπτιον, ἔκρυψεν αὐτὸν ἐν τῇ ἄμμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ἐξελθὼν δὲ τῇ ἡμέρᾳ τῇ δευτέρᾳ, ὁρᾷ δύο ἄνδρας Ἐβραίους διαπληκτιζομένους· καὶ λέγει τῷ ἀδικοῦντι, διὰ τί σὺ τύπτεις τὸν πλησίον; ");
INSERT INTO grcbrent_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ὁ δὲ εἶπε, τίς σε κατέστησεν ἄρχοντα καὶ δικαστὴν ἐφʼ ἡμῶν; μὴ ἀνελεῖν με σὺ θέλεις, ὃν τρόπον ἀνεῖλες χθὲς τὸν Αἰγύπτιον; ἐφοβήθη δὲ Μωυσῆς, καὶ εἶπεν, εἰ οὕτως ἐμφανὲς γέγονε τὸ ῥῆμα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ἤκουσε δὲ Φαραὼ τὸ ῥῆμα τοῦτο, καὶ ἐζήτει ἀνελεῖν Μωυσῆν. Ἀνεχώρησε δὲ Μωυσῆς ἀπὸ προσώπου Φαραὼ, καὶ ᾤκησεν ἐν γῇ Μαδιάμ· ἐλθὼν δὲ εἰς γῆν Μαδιὰμ, ἐκάθισεν ἐπὶ τοῦ φρέατος. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Τῷ δὲ ἱερεῖ Μαδιὰμ ἦσαν ἑπτὰ θυγατέρες, ποιμαίνουσαι τὰ πρόβατα τοῦ πατρὸς αὐτῶν Ἰοθόρ· παραγενόμεναι δὲ ἤντλουν, ἕως ἔπλησαν τὰς δεξαμενάς, ποτίσαι τὰ πρόβατα τοῦ πατρὸς αὐτῶν Ἰοθόρ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Παραγενόμενοι δὲ οἱ ποιμένες ἐξέβαλλον αὐτάς· ἀναστὰς δὲ Μωυσῆς ἐῤῥύσατο αὐτὰς, καὶ ἤντλησεν αὐταῖς, καὶ ἐπότισε τὰ πρόβατα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Παρεγένοντο δὲ πρὸς Ῥαγουὴλ τὸν πατέρα αὐτῶν· ὁ δὲ εἶπεν αὐταῖς, διατί ἐταχύνατε τοῦ παραγενέσθαι σήμερον; ");
INSERT INTO grcbrent_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Αἱ δὲ εἶπαν, ἄνθρωπος Αἰγύπτιος ἐῤῥύσατο ἡμᾶς ἀπὸ τῶν ποιμένων, καὶ ἤντλησεν ἡμῖν, καὶ ἐπότισε τὰ πρόβατα ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ὁ δὲ εἶπε ταῖς θυγατράσιν αὐτοῦ, καὶ ποῦ ἐστιν; καὶ ἱνατί καταλελοίπατε τὸν ἄνθρωπον; καλέσατε οὖν αὐτὸν, ὅπως φάγῃ ἄρτον. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Κατῳκίσθη δὲ Μωυσῆς παρὰ τῷ ἀνθρώπῳ· καὶ ἐξέδοτο Σεπφώραν τὴν θυγατέρα αὐτοῦ Μωυσῇ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ἐν γαστρὶ δὲ λαβοῦσα ἡ γυνὴ ἔτεκεν υἱόν· καὶ ἐπωνόμασε Μωυσῆς τὸ ὄνομα αὐτοῦ Γηρσάμ, λέγων, ὅτι παροικός εἰμι ἐν γῇ ἀλλοτρίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Μετὰ δὲ τὰς ἡμέρας τὰς πολλὰς ἐκείνας, ἐτελεύτησεν ὁ βασιλεὺς Αἰγύπτου, καὶ κατεστέναξαν οἱ υἱοὶ Ἰσραὴλ ἀπὸ τῶν ἔργων, καὶ ἀνεβόησαν· καὶ ἀνέβη ἡ βοὴ αὐτῶν πρὸς τὸν Θεὸν ἀπὸ τῶν ἔργων. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Καὶ εἰσήκουσεν ὁ Θεὸς τὸν στεναγμὸν αὐτῶν· καὶ ἐμνήσθη ὁ Θεὸς τῆς διαθήκης αὐτοῦ τῆς πρὸς Ἀβραὰμ, καὶ Ἰσαὰκ, καὶ Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Καὶ ἐπεῖδεν ὁ Θεὸς τοὺς υἱοὺς Ἰσραὴλ, καὶ ἐγνώσθη αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Καὶ Μωυσῆς ἦν ποιμαίνων τὰ πρόβατα Ἰοθὸρ τοῦ γαμβροῦ αὐτοῦ, τοῦ ἱερέως Μαδιὰμ, καὶ ἤγαγεν τὰ πρόβατα ὑπὸ τὴν ἔρημον, καὶ ἦλθεν εἰς τὸ ὄρος Χωρήβ. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ὤφθη δὲ αὐτῷ Ἄγγελος Κυρίου ἐν πυρὶ φλογὸς ἐκ τοῦ βάτου· καὶ ὁρᾷ ὅτι ὁ βάτος καίεται πυρί, ὁ δὲ βάτος οὐ κατεκαίετο. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Εἶπε δὲ Μωυσῆς, παρελθὼν ὄψομαι τὸ ὅραμα τὸ μέγα τοῦτο, ὅτι οὐ κατακαίεται ὁ βάτος. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ὡς δὲ εἶδεν Κύριος ὅτι προσάγει ἰδεῖν, ἐκάλεσεν αὐτὸν Κύριος ἐκ τοῦ βάτου, λέγων, Μωυσῆ, Μωυσῆ· ὁ δὲ εἶπε, τί ἐστιν; ");
INSERT INTO grcbrent_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ὁ δὲ εἶπε, μὴ ἐγγίσῃς ὧδε· λύσαι τὸ ὑπόδημα ἐκ τῶν ποδῶν σου, ὁ γὰρ τόπος. ἐν ᾧ σὺ ἕστηκας, γῆ ἁγία ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Καὶ εἶπεν, ἐγώ εἰμι ὁ Θεὸς τοῦ πατρός σου, Θεὸς Ἁβραὰμ, καὶ Θεὸς Ἰσαὰκ, καὶ Θεὸς Ἰακώβ· ἀπέστρεψε δὲ Μωυσῆς τὸ πρόσωπον αὐτοῦ, εὐλαβεῖτο γὰρ κατεμβλέψαι ἐνώπιον τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἰδὼν εἶδον τὴν κάκωσιν τοῦ λαοῦ μου τοῦ ἐν Αἰγύπτῳ, καὶ τῆς κραυγῆς αὐτῶν ἀκήκοα ἀπὸ τῶν ἐργοδιωκτῶν· οἶδα γὰρ τὴν ὀδύνην αὐτων, ");
INSERT INTO grcbrent_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","καὶ κατέβην ἐξελέσθαι αὐτοὺς ἐκ χειρὸς τῶν Αἰγυπτίων, καὶ ἐξαγαγεῖν αὐτοὺς ἐκ τῆς γῆς ἐκείνης, καὶ εἰσαγαγεῖν αὐτοὺς εἰς γῆν ἀγαθὴν καὶ πολλήν, εἰς γῆν ῥέουσαν γάλα καὶ μέλι, εἰς τὸν τόπον τῶν Χαναναίων, καὶ Χετταίων, καὶ Ἀμοῤῥαίων, καὶ Φερεζαίων, καὶ Γεργεσαὶων, καὶ Εὐαίων, καὶ Ἰεβουσαίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Καὶ νῦν ἰδοὺ κραυγὴ τῶν υἱῶν Ἰσραὴλ ἥκει πρὸς με· κᾀγὼ ἑώρακα τὸν θλιμμὸν, ὃν οἱ Αἰγύπτιοι θλίβουσιν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Καὶ νῦν δεῦρο, ἀποστείλω σε πρὸς Φαραὼ βασιλέα Αἰγύπτου, καὶ ἐξάξεις τὸν λαόν μου τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Καὶ εἶπε Μωυσῆς πρὸς τὸν Θεὸν, τίς εἰμι ἐγὼ, ὅτι πορεύσομαι πρὸς Φαραὼ βασιλέα Αἰγύπτου, καὶ ὅτι ἐξάξω τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου; ");
INSERT INTO grcbrent_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Εἶπε δὲ ὁ Θεὸς Μωυσῇ, λέγων, ὅτι ἔσομαι μετὰ σοῦ· καὶ τοῦτό σοι τὸ σημεῖον ὅτι ἐγώ σε ἐξαποστελῶ, ἐν τῷ ἐξαγαγεῖν σε τὸν λαόν μου ἐξ Αἰγύπτου, καὶ λατρεύσετε τῷ Θεῷ ἐν τῷ ὄρει τοῦτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Καὶ εἶπε Μωυσῆς πρὸς τὸν Θεὸν, ἰδοὺ ἐγὼ ἐξελεύσομαι πρὸς τοὺς υἱοὺς Ἰσραὴλ, καὶ ἐρῶ πρὸς αὐτοὺς, ὁ Θεὸς τῶν πατέρων ἡμῶν ἀπέσταλκέ με πρὸς ὑμᾶς· ἐρωτήσουσί με, τί ὄνομα αὐτῷ; τί ἐρῶ πρὸς αὐτούς; ");
INSERT INTO grcbrent_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Καὶ εἶπεν ὁ Θεὸς πρὸς Μωυσῆν, λέγων, ἐγώ εἰμι ὁ Ὤν· καὶ εἶπεν, οὕτως ἐρεῖς τοῖς υἱοῖς Ἰσραὴλ, ὁ Ὢν ἀπέσταλκέ με πρὸς ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Καὶ εἶπεν ὁ Θεὸς πάλιν πρὸς Μωυσῆν, οὕτως ἐρεῖς τοῖς υἱοῖς Ἰσραήλ, Κύριος ὁ Θεὸς τῶν πατέρων ἡμῶν, Θεὸς Ἀβραὰμ, καὶ Θεὸς Ἰσαὰκ, καὶ Θεὸς Ἰακὼβ, ἀπέσταλκέ με πρὸς ὑμᾶς· τοῦτό μου ἐστὶν ὄνομα αἰώνιον, καὶ μνημόσυνον γενεῶν γενεαῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ἐλθὼν οὐν συνάγαγε τὴν γερουσίαν τῶν υἱῶν Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, Κύριος ὁ Θεὸς τῶν πατέρων ἡμων ὦπταί μοι, Θεὸς Ἀβραὰμ, καὶ Θεὸς Ἰσαὰκ, καὶ Θεὸς Ἰακὼβ, λέγων, ἐπισκοπῇ ἐπέσκεμμαι ὑμᾶς, καὶ ὅσα συμβέβηκεν ὑμῖν ἐν Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Καὶ εἶπεν, ἀναβιβάσω ὑμᾶς ἐκ τῆς κακώσεως τῶν Αἰγυπτίων, εἰς τὴν γῆν τῶν Χαναναίων, καὶ Χετταίων, καὶ Ἀμοῤῥαίων, καὶ Φερεζαίων, καὶ Γεργεσαίων, καὶ Εὑαίων, καὶ Ἰεβουσαίων, εἰς γῆν ῥέουσαν γάλα καὶ μέλι. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Καὶ εἰσακούσονταί σου τῆς φωνῆς· καὶ εἰσελεύσῃ σὺ, καὶ ἡ γερουσία Ἰσραὴλ, πρὸς Φαραὼ βασιλέα Αἰγύπτου, καὶ ἐρεῖς πρὸς αὐτὸν ὁ Θεὸς τῶν Ἑβραίων προσκέκληται ἡμᾶς· πορευσόμεθα οὖν ὁδὸν τριῶν ἡμερῶν εἰς τὴν ἔρημον, ἵνα θύσωμεν τῷ Θεῷ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ἐγὼ δὲ οἶδα ὅτι οὐ προήσεται ὑμᾶς Φαραὼ βασιλεὺς Αἰγύπτου πορευθῆναι, ἐὰν μὴ μετὰ χειρὸς κραταιᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Καὶ ἐκτείνας τὴν χεῖρα, πατάξω τοὺς Αἰγυπτίους ἐν πᾶσι τοῖς θαυμασίοις μου, οἷς ποιήσω ἐν αὐτοῖς· καὶ μετὰ ταῦτα ἐξαποστελεῖ ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Καὶ δώσω χάριν τῷ λαῷ τούτῳ ἐναντίον τῶν Αἰγυπτίων· ὅταν δὲ ἀποτρέχητε, οὐκ ἀπελεύσεσθε κενοί· ");
INSERT INTO grcbrent_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ἀλλὰ αἰτήσει γυνὴ παρὰ γείτονος καὶ συσκήνου αὐτῆς σκεύη ἀργυρᾶ, καὶ χρυσᾶ, καὶ ἱματισμόν· καὶ ἐπιθήσετε ἐπὶ τοὺς υἱοὺς ὑμῶν, καὶ ἐπὶ τὰς θυγατέρας ὑμῶν, καὶ σκυλεύσατε τοὺς Αἰγυπτίους. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ἀπεκρίθη δὲ Μωυσῆς, καὶ εἶπεν, ἐὰν μὴ πιστεύσωσί μοι, μηδὲ εἰσακούσωσι τῆς φωνῆς μου, ἐροῦσι γὰρ, ὅτι οὐκ ὦπταί σοι ὁ Θεὸς, τί ἐρῶ πρὸς αὐτούς; ");
INSERT INTO grcbrent_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Εἶπε δὲ αὐτῳ Κύριος, τί τοῦτό ἐστι τὸ ἐν τῇ χειρί σου; ὁ δὲ εἶπε, ῥάβδος. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Καὶ εἶπε, ῥίψον αὐτὴν ἐπὶ τὴν γῆν· καὶ ἔῤῥιψεν αὐτὴν ἐπὶ τὴν γῆν, καὶ ἐγένετο ὄφις· καὶ ἔφυγε Μωυσῆς ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἔκτεινον τῆν χεῖρα, καὶ ἐπιλαβοῦ τῆς κέρκου· ἐκτείνας οὖν τὴν χεῖρα ἐπελάβετο τῆς κέρκου· καὶ ἐγένετο ῥάβδος ἐν τῇ χειρὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ἵνα πιστεύσωσί σοι, ὅτι ὦπταί σοι ὁ Θεὸς τῶν πατέρων αὐτῶν, Θεὸς Ἀβραὰμ, καὶ Θεὸς Ἰσαὰκ, καὶ Θεὸς Ἰακώβ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Εἶπε δὲ αὐτῷ Κύριος πάλιν, εἰσένεγκον τὴν χεῖρά σου εἰς τὸν κόλπον σου· καὶ εἰσήνεγκε τὴν χεῖρα αὐτοῦ εἰς τὸν κόλπον αὐτοῦ· καὶ ἐξήνεγκεν τὴν χεῖρα αὐτοῦ ἐκ τοῦ κόλπου αὐτοῦ, καὶ ἐγενήθη ἡ χεὶρ αὐτοῦ ὡσεὶ χιών. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Καὶ εἶπεν πάλιν, εἰσένεγκον τὴν χεῖρά σου εἰς τὸν κόλπον σου· καὶ εἰσήνεγκε τὴν χεῖρα εἰς τὸν κόλπον αὐτοῦ· καὶ ἐξήνεγκεν αὐτὴν ἐκ τοῦ κόλπου αὐτοῦ, καὶ πάλιν ἀπεκατέστη εἰς τὴν χρόαν τῆς σαρκὸς αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ἐὰν δὲ μὴ πιστεύσωσί σοι, μηδὲ εἰσακούσωσι τῆς φωνῆς τοῦ σημείου τοῦ πρώτου, πιστεύσουσί σοι τῆς φωνῆς τοῦ σημείου τοῦ δετέρου. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Καὶ ἔσται ἐὰν μὴ πιστεύσωσί σοι τοῖς δυσὶ σημείοις τούτοις, μηδὲ εἰσακούσωσι τῆς φωνῆς σου, λήψῃ ἀπὸ τοῦ ὕδατος τοῦ ποταμοῦ, καὶ ἐκχεεῖς ἐπὶ τὸ ξηρόν· καὶ ἔσται τὸ ὕδωρ, ὃ ἐὰν λάβῃς ἀπὸ τοῦ ποταμοῦ, αἷμα ἐπὶ τοῦ ξηροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Εἶπε δὲ Μωυσῆς πρὸς Κύριον, δέομαι, Κύριε· οὐχ ἱκανός εἰμι πρὸ τῆς χθὲς οὐδὲ πρὸ τῆς τρίτης ἡμέρας, οὐδὲ ἀφʼ οὗ ἤρξω λαλεῖν τῷ θεράποντί σου· ἰσχνόφωνος καὶ βραδύγλωσσος ἐγώ εἰμι. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, τίς ἔδωκε στόμα ἀνθρώπῳ; καὶ τίς ἐποιήσε δύσκωφον καὶ κωφὸν, βλέποντα καὶ τυφλόν; οὐκ ἐγὼ ὁ Θεός; ");
INSERT INTO grcbrent_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Καὶ νῦν πορεύου, καὶ ἐγὼ ἀνοίξω τὸ στόμα σου, καὶ συμβιβάσω σε ὃ μέλλεις λαλῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Καὶ εἶπε Μωυσῆς, δέομαι, Κύριε· προχείρισαι δυνάμενον ἄλλον, ὃν ἀποστελεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Καὶ θυμωθεὶς ὀργῇ Κύριος ἐπὶ Μωυσῆν, εἶπεν, οὐκ ἰδοὺ Ἀαρὼν ὁ ἄδελφός σου ὁ Λευίτης; ἐπίσταμαι ὅτι λαλῶν λαλήσει αὐτός σοι· καὶ ἰδοὺ αὐτὸς ἐξελεύσεται εἰς συνάντησίν σοι, καὶ ἰδών σε χαρήσεται ἐν ἑαυτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Καὶ ἐρεῖς πρὸς αὐτὸν, καὶ δώσεις τὰ ῥήματά μου εἰς τὸ στόμα αὐτοῦ, καὶ ἐγὼ ἀνοίξω τὸ στόμα σου καὶ τὸ στόμα αὐτοῦ, καί συμβιβάσω ὑμᾶς ἃ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Καὶ αὐτός σοι λαλήσει πρὸς τὸν λαὸν, καὶ αὐτὸς ἔσται σου στόμα· σὺ δὲ αὐτῷ ἔσῃ τὰ πρὸς τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Καὶ τὴν ῥάβδον ταύτην, τὴν στραφεῖσαν εἰς ὄφιν, λήψῃ ἐν τῇ χειρί σου, ἐν ᾗ ποιήσεις ἐν αὐτῇ τὰ σημεῖα. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ἐπορεύθη δὲ Μωυσῆς, καὶ ἀπέστρεψε πρὸς Ἰοθὸρ τὸν γαμβρὸν αὐτοῦ, καὶ λέγει, πορεύσομαι καὶ ἀποστρέψω πρὸς τοὺς ἀδελφούς μου τοὺς ἐν Αἰγύπτῳ, καὶ ὄψομαι εἰ ἔτι ζῶσι· καὶ εἶπεν Ἰοθὸρ Μωυσῇ, βάδιζε ὑγιαίνων· μετὰ δὲ τὰς ἡμέρας τὰς πολλὰς ἐκείνας ἐτελεύτησεν ὁ βασιλεὺς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Εἶπε δὲ Κύριος πρὸς Μωυσῆν ἐν Μαδιὰμ, βάδιζε, ἄπελθε εἰς Αἴγυπτον, τεθνήκασι γὰρ πάντες οἱ ζητοῦντες σου τὴν ψυχήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ἀναλαβὼν δὲ Μωυσῆς τὴν γυναῖκα καὶ τὰ παιδία, ἀνεβίβασεν αὐτὰ ἐπὶ τὰ ὑποζύγια, καὶ ἐπέστρεψεν εἰς Αἴγυπτον· ἔλαβε δὲ Μωυσῆς τὴν ῥάβδον τὴν παρὰ τοῦ Θεοῦ ἐν τῇ χειρὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, πορευομένου σου καὶ ἀποστρέφοντος εἰς Αἴγυπτον, ὅρα πάντα τὰ τέρατα ἃ δέδωκα ἐν ταῖς χερσί σου, ποιήσεις αὐτὰ ἐναντίον Φαραώ· ἐγὼ δὲ σκληρυνῶ τὴν καρδίαν αὐτοῦ, καὶ οὐ μὴ ἐξαποστείλῃ τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Σὺ δὲ ἐρεῖς τῷ Φαραῴ, τάδε λέγει Κύριος, υἱὸς πρωτότοκός μου Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Εἶπα δέ σοι, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι λατρεύσῃ· εἰ μὲν οὖν μὴ βούλει ἐξαποστεῖλαι αὐτούς, ὅρα οὖν, ἐγὼ ἀποκτένῶ τὸν υἱόν σου τὸν πρωτότοκον. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ἐγένετο δὲ ἐν τῇ ὁδῷ ἐν τῷ καταλύματι συνήντησεν αὐτῷ Ἄγγελος Κυρίου, καὶ ἐζήτει αὐτὸν ἀποκτεῖναι. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Καὶ λαβοῦσα Σεπφώρα ψῆφον, περιέτεμε τὴν ἀκροβυστίαν τοῦ υἱοῦ αὐτῆς· καὶ προσέπεσε πρὸς τοὺς πόδας αὐτοῦ, καὶ εἶπεν, ἔστη τὸ αἷμα τῆς περιτομῆς τοῦ παιδίου μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Καὶ ἀπῆλθεν ἀπʼ αὐτοῦ, διότι εἶπεν, ἔστη τὸ αἷμα τῆς περιτομῆς τοῦ παιδίου μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Εἶπε δὲ Κύριος πρὸς Ἀαρὼν, πορεύθητι εἰς συνάντησιν Μωυσῇ εἰς τὴν ἔρημον· καὶ ἐπορεύθη, καὶ συνήντησεν αὐτῷ ἐν τῷ ὄρει τοῦ Θεοῦ, καὶ κατεφίλησαν ἀλλήλους. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Καὶ ἀνήγγειλε Μωυσῆς τῷ Ἀαρὼν πάντας τοὺς λόγους Κυρίου, οὓς ἀπέστειλε, καὶ πάντα τὰ ῥήματα, ἃ ἐνετείλατο αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ἐπορεύθη δὲ Μωυσῆς καὶ Ἀαρὼν, καὶ συνήγαγον τὴν γερουσίαν τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Καὶ ἐλάλησεν Ἀαρὼν πάντα τὰ ῥήματα ταῦτα, ἃ ἐλάλησεν ὁ Θεὸς πρὸς Μωυσῆν, καὶ ἐποίησε τὰ σημεῖα ἐναντίον τοῦ λαοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Καὶ ἐπίστευσεν ὁ λαὸς καὶ ἐχάρη, ὅτι ἐπεσκέψατο ὁ Θεὸς τοὺς υἱοὺς Ἰσραὴλ, καὶ ὅτι εἶδεν αὐτῶν τὴν θλίψιν· κύψας δὲ ὁ λαὸς προσεκύνησε. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Καὶ μετὰ ταῦτα εἰσῆλθε Μωυσῆς καὶ Ἀαρὼν πρὸς Φαραὼ, καὶ εἶπαν αὐτῷ, τάδε λέγει Κύριος ὁ Θεὸς Ἰσραὴλ, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι ἑορτάσωσιν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Καὶ εἶπε Φαραὼ, τίς ἐστιν οὗ εἰσακούσομαι τῆς φωνῆς αὐτοῦ, ὥστε ἐξαποστεῖλαι τοὺς υἱοὺς Ἰσραήλ; οὐκ οἶδα τὸν Κύριον, καὶ τὸν Ἰσραὴλ οὐκ ἐξαποστέλλω. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Καὶ λέγουσιν αὐτῷ, ὁ Θεὸς τῶν Ἐβραίων προσκέκληται ἡμᾶς· πορευσόμεθα οὖν ὁδὸν τριῶν ἡμερῶν εἰς τὴν ἔρημον, ὅπως θύσωμεν Κυρίῳ τῷ Θεῷ ἡμῶν, μή ποτε συναντήσῃ ἡμῖν θάνατος ἢ φόνος. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Καὶ εἶπεν αὐτοῖς ὁ βασιλεὺς Αἰγύπτου, ἱνατί Μωυσῆς καὶ Ἀαρών διαστρέφετε τὸν λαὸν ἀπὸ τῶν ἔργων; ἀπέλθατε ἕκαστος ὑμῶν πρὸς τὰ ἔργα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Καὶ εἶπεν Φαραὼ, ἰδοὺ νῦν πολυπληθεῖ ὁ λαὸς, μὴ οὖν καταπαύσωμεν αὐτοὺς ἀπὸ τῶν ἔργων. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Συνέταξε δὲ Φαραὼ τοῖς ἐργοδιώκταις τοῦ λαοῦ, καὶ τοῖς γραμματεῦσι, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","οὐκέτι προστεθήσεσθε διδόναι ἄχυρον τῷ λαῷ εἰς τὴν πλινθουργίαν, καθάπερ χθὲς καὶ τρίτην ἡμέραν· ἀλλ αὐτοὶ πορευέσθωσαν καὶ συναγαγέτωσαν ἑαυτοῖς ἄχυρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Καὶ τὴν σύνταξιν τῆς πλινθείας, ἧς αὐτοὶ ποιοῦσι, καθʼ ἑκάστην ἡμέραν ἐπιβαλεῖς αὐτοῖς· οὐκ ἀφελεῖς οὐδέν· σχολάζουσι γάρ· διὰ τοῦτο κεκράγασι, λέγοντες, ἐγερθῶμεν, καὶ θύσωμεν τῷ Θεῷ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Βαρυνέσθω τὰ ἔργα τῶν ἀνθρώπων τούτων, καὶ μεριμνάτωσαν ταῦτα, καὶ μὴ μεριμνάτωσαν ἐν λόγοις κενοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Κατέσπευδον δὲ αὐτοὺς οἱ ἐργοδιῶκται καὶ οἱ γραμματεῖς, καὶ ἔλεγον πρὸς τὸν λαὸν, λέγοντες, τάδε λέγει Φαραὼ, οὐκέτι δίδωμι ὑμῖν ἄχυρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Αὐτοὶ ὑμεῖς πορευόμενοι συλλέγετε ἑαυτοῖς ἄχυρα, ὅθεν ἐὰν εὕρητε· οὐ γὰρ ἀφαιρεῖται ἀπὸ τῆς συντάξεως ὑμῶν οὐθέν. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Καὶ διεσπάρη ὁ λαὸς ἐν ὅλῃ γῇ Αἰγύπτῳ συναγαγεῖν καλάμην εἰς ἄχυρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Οἱ δὲ ἐργοδιῶκται κατέσπευδον αὐτοὺς, λέγοντες, συντελεῖτε τὰ ἔργα τὰ καθήκοντα καθʼ ἡμέραν, καθάπερ καὶ ὅτε τὸ ἄχυρον ἐδίδοτο ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Καὶ ἐμαστιγώθησαν οἱ γραμματεῖς τοῦ γένους τῶν υἱῶν Ἰσραὴλ, οἱ κατασταθέντες ἐπʼ αὐτοὺς, ὑπὸ τῶν ἐπιστατῶν τοῦ Φαραὼ, λέγοντες, διατί οὐ συνετελέσατε τὰς συντάξεις ὑμῶν τῆς πλινθείας καθάπερ χθὲς καὶ τρίτην ἡμέραν, καὶ τὸ τῆς σήμερον; ");
INSERT INTO grcbrent_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Εἰσελθόντες δὲ οἱ γραμματεῖς τῶν υἱῶν Ἰσραὴλ κατεβόησαν πρὸς Φαραὼ, λέγοντες, ἱνατί σὺ οὕτως ποιεῖς τοῖς σοῖς οἰκέταις; ");
INSERT INTO grcbrent_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ἄχυρον οὐ δίδοται τοῖς οἰκέταις σου, καὶ τὴν πλίνθον ἡμῖν λέγουσι ποιεῖν· καὶ ἰδοὺ οἱ παῖδές σου μεμαστίγωνται, ἀδικήσεις οὖν τὸν λαόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Καὶ εἶπεν αὐτοῖς, σχολάζετε, σχολασταί ἐστε· διὰ τοῦτο λέγετε, πορευθῶμεν, θύσωμεν τῷ Θεῷ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Νῦν οὖν πορευθέντες, ἐργάζεσθε· τὸ γὰρ ἄχυρον οὐ δοθήσεται ὑμῖν, καὶ τὴν σύνταξιν τῆς πλινθείας ἀποδώσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ἑώρων δὲ οἱ γραμματεῖς τῶν υἱῶν Ἰσραὴλ ἑαυτοὺς ἐν κακοῖς, λέγοντες, οὐκ ἀπολείψετε τῆς πλινθείας τὸ καθῆκον τῇ ἡμέρᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Συνήντησαν δὲ Μωυσῇ καὶ Ἀαρὼν ἐρχομένοις εἰς συνάντησιν αὐτοῖς, ἐκπορευομένων αὐτῶν ἀπὸ Φαραώ, ");
INSERT INTO grcbrent_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Καὶ εἶπαν αὐτοῖς, ἴδοι ὁ Θεὸς ὑμᾶς καὶ κρίναι, ὅτι ἐβδελύξατε τὴν ὀσμὴν ἡμῶν ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραπόντων αὐτοῦ, δοῦναι ῥομφαίαν εἰς τὰς χεῖρας αὐτοῦ, ἀποκτεῖναι ἡμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ἐπέστρεψε δὲ Μωυσῆς πρὸς Κύριον, καὶ εἶπε, δέομαι, Κύριε· τί ἐκάκωσας τὸν λαὸν τοῦτον; καὶ ἱνατί ἀπέσταλκάς με; ");
INSERT INTO grcbrent_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Καὶ ἀφʼ οὗ πεπόρευμαι πρὸς Φαραὼ, λαλῆσαι ἐπὶ τῷ σῷ ὀνόματι, ἐκάκωσε τὸν λαὸν τοῦτον· καὶ οὐκ ἐῤῥύσω τὸν λαόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἤδη ὄψει ἃ ποιήσω τῷ Φαραῷ· ἐν γὰρ χειρὶ κραταίᾳ ἐξαποστελεῖ αὐτούς, καὶ ἐν βραχίονι ὑψηλῷ ἐκβαλεῖ αὐτοὺς ἐκ τῆς γῆς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ἐλάλησε δὲ ὁ Θεὸς πρὸς Μωυσῆν, καὶ εἶπε πρὸς αὐτὸν, ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Καὶ ὤφθην πρὸς Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ, Θεὸς ὢν αὐτῶν· καὶ τὸ ὄνομά μου Κύριος οὐκ ἐδήλωσα αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Καὶ ἔστησα τὴν διαθήκην μου πρὸς αὐτοὺς, ὥστε δοῦναι αὐτοῖς τὴν γῆν τῶν Χαναναίων, τὴν γῆν ἣν παρῳκήκασιν, ἐν ᾗ καὶ παρῴκησαν ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Καὶ ἐγὼ εἰσήκουσα τὸν στεναγμὸν τῶν υἱῶν Ἰσραήλ, ὃν οἱ Αἰγύπτιοι καταδουλοῦνται αὐτούς, καὶ ἐμνήσθην τῆς διαθήκης ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Βάδιζε, εἶπον τοῖς υἱοῖς Ἰσραὴλ, λέγων, ἐγὼ Κύριος· καὶ ἐξάξω ὑμᾶς ἀπὸ τῆς δυναστείας τῶν Αἰγυπτίων, καὶ ῥύσομαι ὑμᾶς ἐκ τῆς δουλείας, καὶ λυτρώσομαι ὑμᾶς ἐν βραχίονι ὑψηλῷ καὶ κρίσει μεγάλῃ· ");
INSERT INTO grcbrent_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Καὶ λὴψομαι ἐμαυτῷ ὑμᾶς λαὸν ἐμοὶ, καὶ ἔσομαι ὑμῶν Θεός· καὶ γνώσεσθε ὅτι ἐγὼ Κύριος ὁ Θεὸς ὑμῶν, ὁ ἐξαγαγὼν ὑμᾶς ἐκ τῆς καταδυναστείας τῶν Αἰγυπτίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Καὶ εἰσάξω ὑμᾶς εἰς τὴν γῆν, εἰς ἣν ἐξέτεινα τὴν χεῖρά μου, δοῦναι αὐτὴν τῷ Ἀβραὰμ, καὶ Ἰσαὰκ, καὶ Ἰακὼβ, καὶ δώσω ὑμῖν αὐτὴν ἐν κληρῷ· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ἐλάλησε δὲ Μωυσῆς οὕτω τοῖς υἱοῖς Ἰσραήλ· καὶ οὐκ εἰσήκουσαν Μωυσῇ ἀπὸ τῆς ὀλιγοψυχίας, καὶ ἀπὸ τῶν ἔργων τῶν σκληρῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Εἶπε δὲ Κύριος πρὸς Μωυσῆν λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","εἴσελθε, λάλησον Φαραῷ βασιλεῖ Αἰγύπτου, ἵνα ἐξαποστείλῃ τοὺς υἱοὺς Ἰσραὴλ ἐκ τῆς γῆς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ἐλάλησε δὲ Μωυσῆς ἔναντι Κυρίου, λέγων, ἰδοὺ οἱ υἱοὶ Ἰσραὴλ οὐκ εἰσήκουσάν μου, καὶ πῶς εἰσακούσεταί μου Φαραώ; ἐγὼ δὲ ἄλογός εἰμι. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Εἶπε δὲ Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, καὶ συνέταξεν αὐτοῖς πρὸς Φαραὼ βασιλέα Αἰγύπτου, ὥστε ἐξαποστεῖλαι τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Καὶ οὗτοι ἀρχηγοὶ οἴκων πατριῶν αὐτῶν· υἱοὶ Ῥουβὴν, πρωτοτόκου Ἰσραήλ· Ἑνὼχ, καὶ Φαλλοὺς, Ἀσρὼν, καὶ Χαρμεί· αὕτη ἡ συγγένεια Ῥουβήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Καὶ υἱοὶ Συμεών· Ἰεμουὴλ, καὶ Ἰαμεὶμ, καὶ Ἀὼδ, καὶ Ἰαχεὶν, καὶ Σαὰρ, καὶ Σαοὺλ ὁ ἐκ τῆς Φοινίσσης· αὗται αἱ πατριαὶ τῶν υἱῶν Συμεών. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Καὶ ταῦτα τὰ ὀνόματα τῶν υἱῶν Λευὶ κατὰ συγγενείας αὐτῶν· Γεδσὼν, Καὰθ, καὶ Μεραρεί· καὶ τὰ ἔτη τῆς ζωῆς Λευὶ ἑκατὸν τριάκοντα ἑπτά. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Καὶ οὗτοι υἱοὶ Γεδσών· Λοβενεὶ, καὶ Σεμεεί· οἶκοι πατριᾶς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Καὶ υἱοὶ Καάθ· Ἀμβρὰμ, καὶ Ἰσσαάρ, Χεβρὼν, καὶ Ὀζειήλ· καὶ τὰ ἔτη τῆς ζωῆς Καὰθ ἑκατὸν τριάκοντα τρία ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Καὶ υἱοὶ Μεραρεί· Μοολεὶ, καὶ Ὀμουσεί. οὗτοι οἱ οἶκοι πατριῶν Λευὶ κατὰ συγγενείας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Καὶ ἔλαβεν Ἀμβρὰν τὴν Ἰωχαβὲδ, θυγατέρα τοῦ ἀδελφοῦ τοῦ πατρὸς αὐτοῦ, ἑαυτῷ εἰς γυναῖκα· καὶ ἐγέννησεν αὐτῷ τόν τε Ἀαρὼν καὶ τὸν Μωυσῆν, καὶ Μαριὰμ τὴν ἀδελφὴν αὐτῶν· τὰ δὲ ἔτη τῆς ζωῆς Ἀμβρὰμ, ἑκατὸν τριάκοντα δύο ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Καὶ υἱοὶ Ἰσσαάρ· Κορὲ, καὶ Ναφὲκ, καὶ Ζεχρεί. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Καὶ υἱοὶ Ὀζειήλ· Μισαὴλ, καὶ Ἐλισαφὰν, καὶ Σεγρεί. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ἔλαβε δὲ Ἀαρὼν τὴν Ἐλισαβὲθ θυγατέρα Ἀμιναδὰβ, ἀδελφὴν Ναασσὼν, αὐτῷ γυναῖκα· καὶ ἔτεκεν αὐτῷ τόν τε Ναδὰβ, καὶ Ἀβιοὺδ, καὶ τὸν Ἐλεάζαρ, καὶ Ἰθάμαρ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Υἱοὶ δὲ Κορέ· Ἀσεὶρ, καὶ Ἑλκανὰ, καὶ Ἀβιασάρ· αὗται αἱ γενέσεις Κορέ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Καὶ Ἐλεάζαρ ὁ τοῦ Ἀαρὼν ἔλαβε τῶν θυγατέρων Φουτιὴλ αὐτῷ γυναῖκα· καὶ ἔτεκεν αὐτῷ τὸν Φινεές· αὗται αἱ ἀρχαὶ πατριᾶς Λευιτῶν, κατὰ γενέσεις αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Οὗτος Ἀαρὼν καὶ Μωυσῆς, οἷς εἶπεν αὐτοῖς ὁ Θεὸς ἐξαγαγεῖν τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου σὺν δυνάμει αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Οὗτοί εἰσιν οἱ διαλεγόμενοι πρὸς Φαραὼ βασιλέα Αἰγύπτου· καὶ ἐξήγαγον τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου αὐτὸς Ἀαρὼν καὶ Μωυσὴς, ");
INSERT INTO grcbrent_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ᾗ ἡμέρᾳ ἐλάλησε Κύριος Μωυσῇ ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ἐγὼ Κύριος· λάλησον πρὸς Φαραὼ βασιλέα Αἰγύπτου ὅσα ἐγὼ λέγω πρὸς σέ. ");
INSERT INTO grcbrent_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Καὶ εἶπε Μωυσῆς ἐναντίον Κυρίου, ἰδοὺ ἐγὼ ἰσχνόφωνός εἰμι, καὶ πῶς εἰσακούσεταί μου Φαραώ, ");
INSERT INTO grcbrent_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ἰδοὺ δέδωκά σε θεὸν Φαραὼ, καὶ Ἀαρὼν ὁ ἀδελφός σου ἔσται σου προφήτης. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Σὺ δὲ λαλήσεις αὐτῷ πάντα ὅσα σοι ἐντέλλομαι· ὁ δὲ Ἀαρὼν ὁ ἀδελφός σου λαλήσει πρὸς Φαραὼ, ὥστε ἐξαποστεῖλαι τοὺς υἱοὺς Ἰσραὴλ ἐκ τῆς γῆς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ἐγὼ δὲ σκληρυνῶ τὴν καρδίαν Φαραὼ, καὶ πληθυνῶ τὰ σημεῖά μου καὶ τὰ τέρατα ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Καὶ οὐκ εἰσακούσεται ὑμῶν Φαραώ· καὶ ἐπιβαλῶ τὴν χεῖρά μου ἐπʼ Αἴγυπτον, καὶ ἐξάξω σὺν δυνάμει μου τὸν λαόν μου τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου σὺν ἐκδικήσει μεγάλῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Καὶ γνώσονται πάντες οἱ Αἰγύπτιοι ὅτι ἐγώ εἰμι Κύριος, ἐκτείνων τὴν χεῖρά μου ἐπʼ Αἴγυπτον, καὶ ἐξάξω τοὺς υἱοὺς Ἰσραὴλ ἐκ μέσον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ἐποίησε δὲ Μωυσῆς καὶ Ἀαρὼν καθάπερ ἐνετείλατο αὐτοῖς Κύριος, οὕτως ἐποίησαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Μωυσῆς δὲ ἦν ἐτῶν ὀγδοήκοντα, Ἀαρὼν δὲ ὁ ἀδελφὸς αὐτοῦ ἐτῶν ὀγδοήκοντατριῶν, ἡνίκα ἐλάλησεν πρὸς Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Καὶ εἶπε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","καὶ ἐὰν λαλήσῃ πρὸς ὑμᾶς Φαραὼ, λέγων, δότε ἡμῖν σημεῖον ἢ τέρας, καὶ ἐρεῖς Ἀαρὼν τῷ ἀδελφῷ σου, λάβε τὴν ῥάβδον, καὶ ῥίψον ἐπὶ τὴν γῆν ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραπόντων αὐτοῦ, καὶ ἔσται δράκων. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Εἰσῆλθε δὲ Μωυσῆς καὶ Ἀαρὼν ἐναντίον Φαραὼ, καὶ τῶν θεραπόντων αὐτοῦ· καὶ ἐποίησαν οὕτως, καθάπερ ἐνετείλατο αὐτοῖς Κύριος· καὶ ἔῤῥιψεν Ἀαρὼν τὴν ῥάβδον ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραποντων αὐτοῦ, καὶ ἐγένετο δράκων. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Συνεκάλεσε δὲ Φαραὼ τοὺς σοφιστὰς Αἰγύπτου, καὶ τοὺς φαρμακούς· καὶ ἐποίησαν καὶ οἱ ἐπαοιδοὶ τῶν Αἰγυπτίων ταῖς φαρμακίαις αὐτῶν ὡσαύτως. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Καὶ ἔῤῥιψαν ἔκαστος τὴν ῥάβδον αὐτῶν, καὶ ἐγένοντο δράκοντες· καὶ κατέπιεν ἡ ῥάβδος ἡ Ἀαρὼν τὰς ἐκείνων ῥάβδους. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Καὶ κατίσχυσεν ἡ καρδία Φαραὼ, καὶ οὐκ εἰσήκουσεν αὐτῶν, καθάπερ ἐνετείλατο αὐτοῖς Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, βεβάρηται ἡ καρδία Φαραὼ, τοῦ μὴ ἐξαποστεῖλαι τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Βάδισον πρὸς Φαραὼ τὸ πρωΐ· ἰδοὺ αὐτὸς ἐκπορεύεται ἐπὶ τὸ ὕδωρ, καὶ ἔσῃ συναντῶν αὐτῷ ἐπὶ τὸ χεῖλος τοῦ ποταμοῦ· καὶ τὴν ῥάβδον τὴν στραφεῖσαν εἰς ὄφιν λήψῃ ἐν τῇ χειρί σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Καὶ ἐρεῖς πρὸς αὐτὸν, Κύριος ὁ Θεὸς τῶν Ἐβραίων ἀπέσταλκέ με πρὸς σὲ, λέγων, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι λατρεύσῃ ἐν τῇ ἐρήμῳ· καὶ ἰδοὺ οὐκ εἰσήκουσας ἕως τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Τάδε λέγει Κύριος, ἐν τούτῳ γνώσῃ ὅτι ἐγὼ Κύριος· ἰδοὺ ἑγὼ τύπτω τῇ ῥάβδῳ τῇ ἐν τῇ χειρί μου ἐπὶ τὸ ὕδωρ τὸ ἐν τῷ ποταμῷ, καὶ μεταβαλεῖ εἰς αἷμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Καὶ οἱ ἰχθύες οἱ ἐν τῷ ποταμῷ τελευτήσουσι· καὶ ἐποζέσει ὁ ποταμὸς, καὶ οὐ δυνήσονται οἱ Αἰγύπτιοι πιεῖν ὕδωρ ἀπὸ τοῦ ποταμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, εἶπὸν Ἀαρὼν τῷ ἀδελφῷ σου, λάβε τὴν ῥάβδον σου ἐν τῇ χειρί σου, καὶ ἔκτεινον τὴν χεῖρά σου ἐπὶ τὰ ὕδατα Αἰγύπτου, καὶ ἐπὶ τοὺς ποταμοὺς αὐτῶν, καὶ ἐπὶ τὰς διώρυγας αὐτῶν, καὶ ἐπὶ τὰ ἕλη αὐτῶν, καὶ ἐπὶ πᾶν συνεστηκὸς ὕδωρ αὐτῶν, καὶ ἔσται αἷμα· καὶ ἐγένετο αἷμα ἐν πάσῃ γῇ Αἰγύπτου, ἔν τε τοῖς ξύλοις καὶ ἐν τοῖς λίθοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Καὶ ἐποίησαν οὕτως Μωυσῆς καὶ Ἀαρὼν, καθάπερ ἐνετείλατο αὐτοῖς Κύριος· καὶ ἐπάρας τῇ ῥάβδῳ αὐτοῦ ἐπάταξε τὸ ὕδωρ τὸ ἐν τῷ ποταμῷ ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραπόντων αὐτοῦ· καὶ μετέβαλε πᾶν τὸ ὕδωρ τὸ ἐν τῷ ποταμῷ εἰς αἷμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Καὶ οἱ ἰχθύες οἱ ἐν τῷ ποταμῷ ἐτελεύτησαν· καὶ ἐπώζεσεν ὁ ποταμὸς, καὶ οὐκ ἠδύναντο οἱ Αἰγύπτιοι πιεῖν ὕδωρ ἐκ τοῦ ποταμοῦ· καὶ ἦν τὸ αἷμα ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ἐποίησαν δὲ ὡσαύτως καὶ οἱ ἐπαοιδοὶ τῶν Αἰγυπτίων ταῖς φαρμακίαις αὐτῶν· καὶ ἐσκληρύνθη ἡ καρδία Φαραὼ, καὶ οὐκ εἰσήκουσεν αὐτῶν, καθάπερ εἶπε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ἐπιστραφεὶς δὲ Φαραὼ εἰσῆλθεν εἰς τὸν οἶκον αὐτοῦ· καὶ οὐκ ἐπέστησε τὸν νοῦν αὐτοῦ οὐδὲ ἐπὶ τούτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ὤρυξαν δὲ πάντες οἱ Αἰγύπτιοι κύκλῳ τοῦ ποταμοῦ, ὥστε πιεῖν ὕδωρ· καὶ οὐκ ἠδύναντο πιεῖν ὕδωρ ἀπὸ τοῦ ποταμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Καὶ ἀνεπληρώθησαν ἑπτὰ ἡμέραι, μετὰ τὸ πατάξαι Κύριον τὸν ποταμόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Εἶπε δὲ Κύριος πρὸς Μωυσὴν, εἴσελθε πρὸς Φαραὼ, καὶ ἐρεῖς πρὸς αὐτὸν, τάδε λεγέι Κύριος, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι λατρεύσωσιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Εἰ δὲ μὴ βούλει σὺ ἐξαποστεῖλαι, ἰδοὺ ἐγὼ τύπτω πάντα τὰ ὅριά σου τοῖς βατράχοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Καὶ ἐξερεύξεται ὁ ποταμὸς βατράχους· καὶ ἀναβάντες εἰσελεύσονται εἰς τοὺς οἴκους σου, καὶ εἰς τὰ ταμιεῖα τῶν κοιτώνων σου, καὶ ἐπὶ τῶν κλινῶν σου, καὶ ἐπὶ τοὺς οἴκους τῶν θεραπόντων σου, καὶ τοῦ λαοῦ σου, καὶ ἐν τοῖς φυράμασί σου, καὶ ἐν τοῖς κλιβάνοις σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Καὶ ἐπὶ σὲ, καὶ ἐπὶ τοὺς θεράποντάς σου, καὶ ἐπὶ τὸν λαόν σου, ἀναβήσονται οἱ βάτραχοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, εἶπον Ἀαρὼν τῷ ἀδελφῷ σου, ἔκτεινον τῇ χειρὶ τὴν ῥάβδον σου ἐπὶ τοὺς ποταμοὺς, καὶ ἐπὶ τὰς διώρυγας, καὶ ἐπὶ τὰ ἕλη, καὶ ἀνάγαγε τοὺς βατράχους. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Καὶ ἐξέτεινεν Ἀαρὼν τὴν χεῖρα ἐπὶ τὰ ὕδατα Αἰγύπτου, καὶ ἀνήγαγε τοὺς βατράχους· καὶ ἀνεβιβάσθη ὁ βάτραχος, καὶ ἐκάλυψε τὴν γῆν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ἐποίησαν δὲ ὡσαύτως καὶ οἱ ἐπαοιδοὶ τῶν Αἰγυπτίων ταῖς φαρμακίαις αὐτῶν, καὶ ἀνήγαγον τοὺς βατράχους ἐπὶ γῆν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Καὶ ἐκάλεσε Φαραὼ Μωυσῆν καὶ Ἀαρὼν, καὶ εἶπεν, εὔξασθε περὶ ἐμοῦ πρὸς Κύριον, καὶ περιελέτω τοὺς βατράχους ἀπʼ ἐμοῦ, καὶ ἀπὸ τοῦ ἐμοῦ λαοῦ· καὶ ἐξαποστελῶ αὐτοὺς, καὶ θύσωσι τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Εἶπε δὲ Μωυσῆς πρὸς Φαραὼ, τάξαι πρὸς με πότε εὔξομαι περὶ σοῦ, καὶ περὶ τῶν θεραπόντων σου, καὶ τοῦ λαοῦ σου, ἀφανίσαι τοὺς βατράχους ἀπὸ σοῦ, καὶ ἀπὸ τοῦ λαοῦ σου, καὶ ἐκ τῶν οἰκιῶν ὑμῶν, πλὴν ἐν τῷ ποταμῷ ὑπολειφθήσονται. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ὁ δὲ εἶπεν, εἰς αὔριον· εἶπεν οὖν, ὡς εἴρηκας· ἵνα εἰδῇς ὅτι οὐκ ἔστιν ἄλλος πλὴν Κυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Καὶ περιαιρεθήσονται οἱ βάτραχοι ἀπὸ σοῦ, καὶ ἀπὸ τῶν οἰκιῶν ὑμῶν, καὶ ἀπὸ τῶν ἐπαύλεων, καὶ ἀπὸ τῶν θεραπόντων σου, καὶ ἀπὸ τοῦ λαοῦ σου, πλὴν ἐν τῷ ποταμῷ ὑπολειφθήσονται. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ἐξῆλθε δὲ Μωυσῆς καὶ Ἀαρὼν ἀπὸ Φαραώ· καὶ ἐβόησε Μωυσῆς πρὸς Κύριον περὶ τοῦ ὁρισμοῦ τῶν βατράχων, ὡς ἐτάξατο Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ἐποιήσε δὲ Κύριος καθάπερ εἶπε Μωυσῆς· καὶ ἐτελεύτησαν οἱ βάτραχοι ἐκ τῶν οἰκιῶν, καὶ ἐκ τῶν ἐπαύλεων, καὶ ἐκ τῶν ἀγρῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Καὶ συνήγαγον αὐτοὺς, θημωνίας θημωνίας· καὶ ὤζεσεν ἡ γῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ἰδὼν δὲ Φαραὼ ὅτι γέγονεν ἀνάψυξις, ἐβαρύνθη ἡ καρδία αὐτοῦ, καὶ οὐκ εἰσήκουσεν αὐτῶν, καθάπερ ἐλάλησε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, εἶπον Ἀαρὼν, ἔκτεινον τῇ χειρὶ τὴν ῥάβδον σου, καὶ πάταξον τὸ χῶμα τῆς γῆς· καὶ ἔσονται σκνίφες ἔν τε τοῖς ἀνθρώποις, καὶ ἐν τοῖς τετράποσι, καὶ ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ἐξέτεινεν οὖν Ἀαρὼν τῇ χειρὶ τὴν ῥάβδον, καὶ ἐπάταξε τὸ χῶμα τῆς γῆς· καὶ ἐγένοντο οἱ σκνίφες ἐν τοῖς ἀνθρώποις, ἔν τε τοῖς τετράποσι, καὶ ἐν παντὶ χώματι τῆς γῆς ἐγένοντο οἱ σκνίφες. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ἐποίησαν δὲ ὡσαύτως καὶ οἱ ἐπαοιδοὶ ταῖς φαρμακίαις αὐτῶν, ἐξαγαγεῖν τὸν σκνῖφα, καὶ οὐκ ἠδύναντο· καὶ ἐγένοντο οἱ σκνίφες ἔν τε τοῖς ἀνθρώποις, καὶ ἐν τοῖς τετράποσιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Εἶπαν οὖν οἱ ἐπαοιδοὶ τῷ Φαραῷ, δάκτυλος Θεοῦ ἐστι τοῦτο· καὶ ἐσκληρύνθη ἡ καρδία Φαραὼ, καὶ οὐκ εἰσήκουσεν αὐτῶν, καθάπερ ἐλάλησε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ὄρθρισον τὸ πρωΐ, καὶ στῆθι ἐναντίον Φαραώ· καὶ ἰδοὺ αὐτὸς ἐξελεύσεται ἐπὶ τὸ ὕδωρ· καὶ ἐρεῖς πρὸς αὐτὸν, τάδε λέγει Κύριος, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι λατρεύσωσιν ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ἐὰν δὲ μὴ βούλει ἐξαποστεῖλαι τὸν λαόν μου, ἰδοὺ ἐγὼ ἐξαποστέλλω ἐπὶ σὲ, καὶ ἐπὶ τοὺς θεράποντάς σου, καὶ ἐπὶ τὸν λαόν σου, καὶ ἐπὶ τοὺς οἴκους ὑμῶν, κυνόμυιαν· καὶ πλησθήσονται αἱ οἰκίαι τῶν Αἰγυπτίων τῆς κυνομυίης, καὶ εἰς τὴν γῆν ἐφʼ ἧς εἰσιν ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Καὶ παραδοξάσω ἐν τῇ ἡμέρᾳ ἐκείνῃ τὴν γῆν Γεσὲμ, ἐφʼ ἧς ὁ λαός μου ἔπεστιν ἐπʼ αὐτῆς, ἐφʼ ἧς οὐκ ἔσται ἐκεῖ ἡ κυνόμυια· ἵνα εἰδῇς ὅτι ἐγώ εἰμι Κύριος ὁ Θεὸς πάσης τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Καὶ δώσω διαστολὴν ἀνὰ μέσον τοῦ ἐμοῦ λαοῦ, καὶ ἀνὰ μέσον τοῦ σου λαοῦ· ἐν δὲ τῇ αὔριον ἔσται τοῦτο ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ἐποίησε δὲ Κύριος οὕτως· καὶ παρεγένετο ἡ κυνόμυια πλῆθος εἰς τοὺς οἴκους Φαραὼ, καὶ εἰς τοὺς οἴκους τῶν θεραπόντων αὐτοῦ, καὶ εἰς πᾶσαν τὴν γῆν Αἰγύπτου· καὶ ἐξωλοθρεύθη ἡ γῆ ἀπὸ τῆς κυνομυίης. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ἐκάλεσε δὲ Φαραὼ Μωυσῆν καὶ Ἀαρὼν, λέγων, ἐλθόντες θύσατε Κυρίῳ τῷ Θεῷ ὑμῶν ἐν τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Καὶ εἶπε Μωυσῆς, οὐ δυνατὸν γενέσθαι οὕτως· τὰ γὰρ βδελύγματα τῶν Αἰγυπτίων θύσομεν Κυρίῳ τῷ Θεῷ ἡμῶν· ἐὰν γὰρ θύσωμεν τὰ βδελύγματα τῶν Αἰγυπτίων ἐναντίον αὐτῶν, λιθοβοληθησόμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ὁδὸν τριῶν ἡμερῶν πορευσόμεθα εἰς τὴν ἔρημον· καὶ θύσομεν τῷ Θεῷ ἡμῶν, καθάπερ εἶπεν Κύριος ἡμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Καὶ εἶπε Φαραὼ, ἐγὼ ἀποστέλλω ὑμᾶς, καὶ θύσατε τῷ Θεῷ ὑμῶν ἐν τῇ ἐρήμῳ· ἀλλʼ οὐ μακρὰν ἀποτενεῖτε πορευθῆναι· εὔξασθε οὖν περὶ ἐμοῦ πρὸς Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Εἶπε δὲ Μωυσῆς, ὁ δὲ ἐγὼ ἐξελεύσομαι ἀπὸ σοῦ, καὶ εὔξομαι πρὸς τὸν Θεὸν, καὶ ἀπελεύσεται ἡ κυνόμυια καὶ ἀπὸ τῶν θεραπόντων σου, καὶ ἀπὸ τοῦ λαοῦ σου αὔριον· μὴ προσθῇς ἔτι Φαραὼ ἐξαπατῆσαι, τοῦ μὴ ἐξαποστεῖλαι τὸν λαὸν θῦσαι Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ἐξῆλθε δὲ Μωυσῆς ἀπὸ Φαραὼ, καὶ ηὔξατο πρὸς τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ἐποίησε δὲ Κύριος καθάπερ εἶπε Μωυσῆς· καὶ περιεῖλε τὴν κυνόμυιαν ἀπὸ Φαραὼ, καὶ τῶν θεραπόντων αὐτοῦ, καὶ τοῦ λαοῦ αὐτοῦ, καὶ οὐ κατελείφθη οὐδεμία. ");
INSERT INTO grcbrent_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Καὶ ἐβάρυνε Φαραὼ τὴν καρδίαν αὐτοῦ καὶ ἐπὶ τοῦ καιροῦ τούτου, καὶ οὐκ ἠθέλησεν ἐξαποστεῖλαι τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, εἴσελθε πρὸς Φαραὼ, καὶ ἐρεῖς αὐτῷ, τάδε λέγει Κύριος ὁ Θεὸς τῶν Ἑβραίων, ἐξαπόστειλον τὸν λαόν μου, ἵνα μοι λατρεύσωσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Εἰ μὲν οὖν μὴ βούλει ἐξαποστεῖλαι τὸν λαόν μου, ἀλλὰ ἔτι ἐγκρατεῖς αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Ἰδοὺ, χεὶρ Κυρίου ἐπέσται ἐν τοῖς κτήνεσί σου τοῖς ἐν τοῖς πεδίοις, ἔν τε τοῖς ἵπποις, καὶ ἐν τοῖς ὑποζυγίοις, καὶ ταῖς καμήλοις, καὶ βουσὶ, καὶ προβάτοις, θάνατος μέγας σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Καὶ παραδοξάσω ἐγὼ ἐν τῷ καιρῷ ἐκείνῳ ἀνὰ μέσον τῶν κτηνῶν τῶν Αἰγυπτίων, καὶ ἀνὰ μέσον τῶν κτηνῶν τῶν υἱῶν Ἰσραήλ· οὐ τελευτήσει ἀπὸ πάντων τῶν τοῦ Ἰσραὴλ υἱῶν ῥητόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Καὶ ἔδωκεν ὁ Θεὸς ὅρον, λέγων, ἐν τῇ αὔριον ποιήσει Κύριος τὸ ῥῆμα τοῦτο ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Καὶ ἐποίησε Κύριος τὸ ῥῆμα τοῦτο τῇ ἐπαύριον· καὶ ἐτελεύτησε πάντα τὰ κτήνη τῶν Αἰγυπτίων· ἀπὸ δὲ τῶν κτηνῶν τῶν υἱῶν Ἰσραὴλ οὐκ ἐτελεύτησεν οὐδέν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ἰδὼν δὲ Φαραὼ ὅτι οὐκ ἐτελεύτησεν ἀπὸ πάντων τῶν κτηνῶν τῶν υἱῶν Ἰσραὴλ οὐδὲν, ἐβαρύνθη ἡ καρδία Φαραὼ, καὶ οὐκ ἐξαπέστειλε τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Εἶπε δὲ Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, λάβετε ὑμεῖς πληρεῖς τὰς χεῖρας αἰθάλης καμιναίας, καὶ πασάτω Μωυσῆς εἰς τὸν οὐρανὸν ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραπόντων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Καὶ γενηθήτω κονιορτὸς ἐπὶ πᾶσαν τὴν γῆν Αἰγύπτου· καὶ ἔσται ἐπὶ τοὺς ἀνθρώπους, καὶ ἐπὶ τὰ τετράποδα, ἕλκη, φλυκτίδες ἀναζέουσαι ἔν τε τοῖς ἀνθρώποις, καὶ ἐν τοῖς τετράποσιν, ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Καὶ ἔλαβεν τὴν αἰθάλην τῆς καμιναίας ἐναντίον Φαραὼ, καὶ ἔπασεν αὐτὴν Μωυσῆς εἰς τὸν οὐρανόν· καὶ ἐγένετο ἕλκη, φλυκτίδες ἀναζέουσαι, ἔν τε τοῖς ἀνθρώποις, καὶ ἐν τοῖς τετράποσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Καὶ οὐκ ἠδύναντο οἱ φαρμακοὶ στῆναι ἐναντίον Μωυσῆ διὰ τὰ ἕλκη· ἐγένετο γὰρ τὰ ἕλκη ἐν τοῖς φαρμακοῖς, καὶ ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ἐσκλήρυνε δὲ Κύριος τὴν καρδίαν Φαραὼ, καὶ οὐκ εἰσήκουσεν αὐτῶν, καθὰ συνέταξε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ὄρθρισον τὸ πρωῒ, καὶ στῆθι ἐναντίον Φαραὼ, καὶ ἐρεῖς πρὸς αὐτὸν, τάδε λέγει Κύριος ὁ Θεὸς τῶν Ἑβραίων, ἐξαπόστειλον τὸν λαόν μου, ἵνα λατρεύσωσί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ἐν τῷ γὰρ νῦν καιρῷ ἐγὼ ἐξαποστέλλω πάντα τὰ συναντήματά μου εἰς τὴν καρδίαν σου, καὶ τῶν θεραπόντων σου, καὶ τοῦ λαοῦ σου, ἵνα εἴδῇς ὅτι οὐκ ἔστιν, ὡς ἐγὼ, ἄλλος ἐν πάσῃ τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Νῦν γὰρ ἀποστείλας τὴν χεῖρα πατάξω σε, καὶ τὸν λαόν σου θανατώσω, καὶ ἐκτριβήσῃ ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Καὶ ἕνεκεν τούτου διετηρήθης, ἵνα ἐνδείξωμαι ἐν σοὶ τὴν ἰσχύν μου, καὶ ὅπως διαγγελῇ τὸ ὄνομά μου ἐν πάσῃ τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ἔτι οὖν σὺ ἐνποιῇ τοῦ λαοῦ μου, τοῦ μὴ ἐξαποστεῖλαι αὐτούς; ");
INSERT INTO grcbrent_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ἰδοὺ ἐγὼ ὕω ταύτην τὴν ὥραν αὔριον χάλαζαν πολλὴν σφόδρα, ἥτις τοιαύτη οὐ γέγονεν ἐν Αἰγύπτῳ, ἀφʼ ἧς ἡμέρας ἔκτισται, ἕως τῆς ἡμέρας ταύτης. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Νῦν οὖν κατάσπευσον συναγαγεῖν τὰ κτήνη σου, καὶ ὅσα σοι ἐστὶν ἐν τῷ πεδίῳ· πάντες γὰρ οἱ ἄνθρωποι, καὶ τὰ κτήνη, ὅσα σοί ἐστιν ἐν τῷ πεδίῳ· πὰντες γὰρ οἱ ἄνθρωποι, καὶ τὰ κτήνη, ὅσα ἐὰν εὑρεθῇ ἐν τοῖς πεδίοις, καὶ μὴ εἰσέλθῃ εἰς οἰκίαν, πεσῇ δὲ ἐπʼ αὐτὰ ἡ χάλαζα, τελευτήσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ὁ φοβούμενος τὸ ῥῆμα Κυρίου τῶν θεραπόντων Φαραὼ, συνήγαγε τὰ κτήνη αὐτοῦ εἰς τοὺς οἴκους. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ὃς δὲ μὴ πρόσεσχεν τῇ διανοίᾳ εἰς τὸ ῥῆμα Κυρίου, ἀφῆκε τὰ κτήνη ἐν τοῖς πεδίοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἔκτεινον τὴν χεῖρά σου εἰς τὸν οὐρανὸν, καὶ ἔσται χάλαζα ἐπὶ πᾶσαν γῆν Αἰγύπτου, ἐπί τε τοὺς ἀνθρώπους, καὶ τὰ κτήνη, καὶ ἐπὶ πᾶσαν βοτάνην τὴν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ἐξέτεινε δὲ Μωυσῆς τὴν χεῖρα εἰς τὸν οὐρανὸν, καὶ Κύριος ἔδωκε φωνὰς καὶ χάλαζαν· καὶ διέτρεχε τὸ πῦρ ἐπὶ τῆς γῆς· καὶ ἔβρεξε Κύριος χάλαζαν ἐπὶ πᾶσαν γῆν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ἦν δὲ ἡ χάλαζα καὶ τὸ πῦρ φλογίζον ἐν τῇ χαλάζῃ· ἡ δὲ χάλαζα πολλὴ σφόδρα, ἥτις τοιαύτη οὐ γέγονεν ἐν Αἰγύπτῳ, ἀφʼ ἧς ἡμέρας γεγένηται ἐπʼ αὐτῆς ἔθνος. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ἐπάταξε δὲ ἡ χάλαζα ἐν πάσῃ γῇ Αἰγύπτου, ἀπὸ ἀνθρώπου ἕως κτήνους· καὶ πᾶσαν βοτάνην τὴν ἐν τῷ πεδίῳ ἐπάταξεν ἡ χάλαζα· καὶ πάντα τὰ ξύλα τὰ ἐν τοῖς πεδίοις συνέτριψεν ἡ χάλαζα. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Πλὴν ἐν γῇ Γεσὲμ, οὗ ἦσαν οἱ υἱοὶ Ἰσραὴλ, οὐκ ἐγένετο ἡ χάλαζα. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ἀποστείλας δὲ Φαραὼ ἐκάλεσε Μωυσῆν καὶ Ἀαρὼν, καὶ εἶπεν αὐτοῖς, ἡμάρτηκα τὸ νῦν· ὁ Κύριος δίκαιος, ἐγὼ δὲ καὶ ὁ λαός μου ἀσεβεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Εὔξασθε οὖν περὶ ἐμοῦ πρὸς Κύριον, καὶ παυσάσθω τοῦ γενηθῆναι φωνὰς Θεοῦ, καὶ χάλαζαν, καὶ πῦρ· καὶ ἐξαποστελῶ ὑμᾶς, καὶ οὐκέτι προστεθήσεσθε μένειν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Εἶπε δὲ αὐτῷ Μωυσῆς, ὡς ἂν ἐξέλθω τὴν πόλιν, ἐκπετάσω τὰς χεῖράς μου πρὸς τὸν Κύριον, καὶ αἱ φωναὶ παύσονται, καὶ ἡ χὰλαζα καὶ ὁ ὑετὸς οὐκ ἔσται ἔτι, ἵνα γνῷς ὅτι τοῦ Κυρίου ἡ γῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Καὶ σὺ καὶ οἱ θεράποντές σου, ἐπίσταμαι ὅτι οὐδέπω πεφόβησθε τὸν Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Τὸ δὲ λίνον καὶ ἡ κριθὴ ἐπλήγη· ἡ γὰρ κριθὴ παρεστηκυῖα, τὸ δὲ λίνον σπερματίζον. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ὁ δὲ πυρὸς καὶ ἡ ὀλύρα οὐκ ἐπληγησαν, ὄψιμα γὰρ ἦν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ἐξῆλθε δὲ Μωυσῆς ἀπὸ Φαραὼ ἐκτὸς τῆς πόλεως, καὶ ἐξέτεινε τὰς χεῖρας πρὸς Κύριον· καὶ αἱ φωναὶ ἐπαύσαντο, καὶ ἡ χάλαζα καὶ ὁ ὑετὸς οὐκ ἔσταξεν ἔτι ἐπὶ τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ἰδὼν δὲ Φαραὼ ὅτι πέπαυται ὁ ὑετὸς καὶ ἡ χάλαζα καὶ αἱ φωναὶ, προσέθετο τοῦ ἁμαρτάνειν· καὶ ἐβάρυνεν αὐτοῦ τὴν καρδίαν, καὶ τῶν θεραπόντων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Καὶ ἐσκληρύνθη ἡ καρδία Φαραὼ, καὶ οὐκ ἐξαπέστειλε τοὺς υἱοὺς Ἰσραὴλ, καθάπερ ἐλάλησε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, λέγων, εἴσελθε πρὸς Φαραὼ, ἐγὼ γὰρ ἐσκλήρυνα αὐτοῦ τὴν καρδίαν καὶ τῶν θεραπόντων αὐτοῦ, ἵνα ἑξῆς ἐπέλθῃ τὰ σημεῖα ταῦτα ἐπʼ αὐτούς· ");
INSERT INTO grcbrent_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ὅπως διηγήσησθε εἰς τὰ ὦτα τῶν τέκνων ὑμῶν, καὶ τοῖς τέκνοις τῶν τέκνων ὑμῶν, ὅσα ἐμπέπαιχα τοῖς Αἰγυπτίοις, καὶ τὰ σημεῖά μου, ἃ ἐποίησα ἐν αὐτοῖς· καὶ γνώσεσθε ὅτι ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Εἰσῆλθε δὲ Μωυσῆς καὶ Ἀαρὼν ἐναντίον Φαραὼ, καὶ εἶπαν αὐτῷ, τάδε λέγει Κύριος ὁ Θεὸς τῶν Ἐβραίων, ἕως τίνος οὐ βούλει ἐντραπῆναί με; ἔξαπόστειλον τὸν λαόν μου, ἵνα λατρεύσωσί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ἐὰν δὲ μὴ θέλῃς σὺ ἐξαποστεῖλαι τὸν λαόν μου, ἰδοὺ ἐγὼ ἐπάγω ταύτην τὴν ὥραν αὔριον ἀκρίδα πολλὴν ἐπὶ πάντα τὰ ὅριά σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Καὶ καλύψει τὴν ὄψιν τῆς γῆς, καὶ οὐ δυνήσῃ κατιδεῖν τὴν γῆν· καὶ κατέδεται πᾶν τὸ περισσὸν τῆς γῆς τὸ καταλειφθὲν, ὃ κατέλιπεν ὑμῖν ἡ χάλαζα, καὶ κατέδεται πᾶν ξύλον τὸ φυόμενον ὑμῖν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Καὶ πλησθήσονταί σου αἱ οἰκίαι, καὶ αἱ οἰκίαι τῶν θεραπόντων σου, καὶ πᾶσαι αἱ οἰκίαι ἐν πάσῃ γῇ τῶν Αἰγυπτίων· ἃ οὐδέποτε ἑωράκασιν οἱ πατέρες σου, οὐδʼ οἱ πρόπαπποι αὐτῶν, ἀφʼ ἧς ἡμέρας γεγόνασιν ἐπὶ τῆς γῆς, ἔως τῆς ἡμέρας ταύτης· καὶ ἐκκλίνας Μωυσῆς ἐξῆλθεν ἀπὸ Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Καὶ λέγουσιν οἱ θεράποντες Φαραὼ πρὸς αὐτὸν, ἕως τίνος ἔσται τοῦτο ἡμῖν σκῶλον; ἐξαπόστειλον τοὺς ἀνθρώπους, ὅπως λατρεύσωσι τῷ Θεῷ αὐτῶν· ἢ εἰδέναι βούλει ὅτι ἀπόλωλεν Αἴγυπτος; ");
INSERT INTO grcbrent_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Καὶ ἀπέστρεψαν τόν τε Μωυσῆν καὶ Ἀαρὼν πρὸς Φαραὼ, καὶ εἶπεν αὐτοῖς, πορεύεσθε καὶ λατρεύσατε Κυρίῳ τῷ Θεῷ ὑμῶν· τίνες δὲ καὶ τίνες εἰσιν οἱ πορευόμενοι; ");
INSERT INTO grcbrent_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Καὶ λέγει Μωυσῆς, σὺν τοῖς νεανίσκοις καὶ πρεσβυτέροις πορευσόμεθα, σὺν τοῖς υἱοῖς καὶ θυγατράσι, καὶ προβάτοις, καὶ βουσὶν ἡμῶν· ἔστι γὰρ ἑορτὴ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Καὶ εἶπε πρὸς αὐτοὺς, ἔστω οὕτω Κύριος μεθʼ ὑμῶν· καθότι ἀποστέλλω ὑμᾶς, μὴ καὶ τὴν ἀποσκευὴν ὑμῶν; ἴδετε ὅτι πονηρία πρόσκειται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Μὴ οὕτως· πορευέσθωσαν δὲ οἱ ἄνδρες, καὶ λατρευσάτωσαν τῷ Θεῷ· τοῦτο γὰρ αὐτοὶ ἐκζητεῖτε· ἐξέβαλον δὲ αὐτοὺς ἀπὸ προσώπου Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἔκτεινον τὴν χεῖρα ἐπὶ γῆν Αἰγύπτου· καὶ ἀναβήτω ἀκρὶς ἐπὶ τὴν γῆν, καὶ κατέδεται πᾶσαν βοτάνην τῆς γῆς, καὶ πάντα τὸν καρπὸν τῶν ξύλων, ὃν ὑπελίπετο ἡ χάλαζα. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Καὶ ἐπῇρε Μωυσῆς τὴν ῥάβδον εἰς τὸν οὐρανὸν, καὶ Κύριος ἐπήγαγεν ἄνεμον νότον ἐπὶ τὴν γῆν, ὅλην τὴν ἡμέραν ἐκείνην, καὶ ὅλην τὴν νύκτα· τὸ πρωῒ ἐγενήθη, καὶ ὁ ἄνεμος ὁ νότος ἀνέλαβεν τὴν ἀκρίδα, ");
INSERT INTO grcbrent_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","καὶ ἀνήγαγεν αὐτὴν ἐπὶ πᾶσαν γῆν Αἰγύπτου· καὶ κατέπαυσεν ἐπὶ πάντα τὰ ὅρια Αἰγύπτου πολλὴ σφόδρα· προτέρα αὐτῆς οὐ γέγονε τοιαύτη ἀκρὶς, καὶ μετὰ ταῦτα οὐκ ἔσται οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Καὶ ἐκάλυψε τὴν ὄψιν τῆς γῆς, καὶ ἐφθάρη ἡ γῆ· καὶ κατέφαγε πᾶσαν βοτάνην τῆς γῆς, καὶ πάντα τόν καρπὸν τῶν ξύλων, ὃς ὑπελείφθη ἀπὸ τῆς χαλάζης· οὐχ ὑπελείφθη χλωρὸν οὐδὲν ἐν τοῖς ξύλοις, καὶ ἐν πάσῃ βοτάνῃ τοῦ πεδίου, ἐν πάσηῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Κατέσπευδε δὲ Φαραὼ καλέσαι Μωυσῆν καὶ Ἀαρὼν, λέγων, ἡμάρτηκα ἐναντίον Κυρίου τοῦ Θεοῦ ὑμῶν, καὶ εἰς ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Προσδέξασθε οὖν μου τὴν ἁμαρτίαν ἔτι νῦν, καὶ προσεύξασθε πρὸς Κύριον τὸν Θεὸν ὑμῶν, καὶ περιελέτω ἀπʼ ἐμοῦ τὸν θάνατον τοῦτον. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ἐξῆλθε δὲ Μωυσῆς ἀπὸ Φαραὼ, καὶ ηὔξατο πρὸς τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Καὶ μετέβαλε Κύριος ἄνεμον ἀπὸ θαλάσσης σφοδρὸν, καὶ ἀνέλαβε τὴν ἀκρίδα, καὶ ἔβαλεν αὐτὴν εἰς τὴν ἐρυθρὰν θαλάσσαν· καὶ οὐχ ὑπελείφη ἀκρὶς μία ἐν πάσῃ γῇ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Καὶ ἐσκλήρυνε Κύριος τὴν καρδίαν Φαραὼ, καὶ οὐκ ἐξαπέστειλε τοὺς υἱοὺς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἔκτεινον τὴν χεῖρά σου εἰς τὸν οὐρανὸν, καὶ γενηθήτω σκότος ἐπὶ γῆς Αἰγύπτου, ψηλαφητὸν σκότος. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ἐξέτεινε δὲ Μωυσῆς τὴν χεῖρα εἰς τὸν οὐρανόν· καὶ ἐγένετο σκότος γνόφος, θύελλα ἐπὶ πᾶσαν γῆν Αἰγύπτου τρεῖς ἡμέρας· ");
INSERT INTO grcbrent_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Καὶ οὐκ εἶδεν οὐδεὶς τὸν ἀδελφὸν αὐτοῦ τρεῖς ἡμέρας· καὶ οὐκ ἐξανέστη οὐδεὶς ἐκ τῆς κοίτης αὐτοῦ τρεῖς ἡμέρας· πᾶσι δὲ τοῖς υἱοῖς Ἰσραὴλ φῶς ἦν ἐν πᾶσιν οἷς κατεγίνοντο. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Καὶ ἐκάλεσε Φαραὼ Μωυσῆν καὶ Ἀαρὼν, λέγων, Βαδίζετε, λατρεύσατε Κυρίῳ τῷ Θεῷ ὑμῶν, πλὴν τῶν προβάτων καὶ τῶν βοῶν ὑπολείπεσθε· καὶ ἡ ἀποσκευὴ ὑμῶν ἀποτρεχέτω μεθʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Καὶ εἶπε Μωυσῆς, ἀλλὰ καὶ σὺ δώσεις ἡμῖν ὁλοκαυτώματα καὶ θυσίας, ἂ ποιήσομεν Κυρίῳ τῷ Θεῷ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Καὶ τὰ κτήνη ἡμῶν πορεύσεται μεθʼ ἡμῶν, καὶ οὐχ ὑπολειψόμεθα ὁπλήν· ἀπʼ αὐτῶν γὰρ ληψόμεθα λατρεῦσαι Κυρίῳ τῷ Θεῷ ἡμῶν· ἡμεῖς δὲ οὐκ οἴδαμεν τί λατρεύσομεν Κυρίῳ τῷ Θεῷ ἡμῶν, ἕως τοῦ ἐλθεῖν ἡμᾶς ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ἐσκλήρυνε δὲ Κύριος τὴν καρδίαν Φαραὼ, καὶ οὐκ ἐβουλήθη ἐξαποστεῖλαι αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Καὶ λέγει Φαραὼ, ἄπελθε ἀπʼ ἐμοῦ· πρόσεχε σεαυτῷ ἔτι προσθεῖναι ἰδεῖν μου τὸ πρόσωπον· ᾗ δʼ ἂν ἡμέρᾳ ὀφθῇς μοι, ἀποθανῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Λέγει δὲ Μωυσῆς, εἴρηκας· οὐκ ἔτι ὀφθήσομαί σοι εἰς πρόσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἔτι μίαν πληγὴν ἐγὼ ἐπάξω ἐπὶ Φαραὼ, καὶ ἐπʼ Αἴγυπτον, καὶ μετὰ ταῦτα ἐξαποστελεῖ ὑμᾶς ἐντεῦθεν· ὅταν δὲ ἐξαποστέλλῃ ὑμᾶς σὺν παντὶ, ἐκβαλεῖ ὑμᾶς ἐκβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Λάλησον οὖν κρυφῇ εἰς τὰ ὦτα τοῦ λαοῦ, καὶ αἰτησάτω ἕκαστος παρὰ τοῦ πλησίον σκεύη ἀργυρᾶ καὶ χρυσὰ καὶ ἱματισμόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Κύριος δὲ ἔδωκε τὴν χάριν τῷ λαῷ αὐτοῦ ἐναντίον τῶν Αἰγυπτίων, καὶ ἔχρησαν αὐτοῖς· καὶ ὁ ἄνθρωπος Μωυσῆς μέγας ἐγενήθη σφόδρα ἐναντίον τῶν Αἰγυπτίων, καὶ ἐναντίον Φαραὼ, καὶ ἐναντίον τῶν θεραπόντων ἀτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Καὶ εἶπε Μωυσῆς, τάδε λέγει Κύριος, περὶ μέσας νύκτας ἐγὼ εἰσπορεύομαι εἰς μέσον Αἰγύπτου· ");
INSERT INTO grcbrent_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Καὶ τελευτήσει πᾶν πρωτότοκον ἐν γῇ Αἰγύπτῳ, ἀπὸ πρωτοτόκου Φαραὼ, ὃς κάθηται ἐπὶ τοῦ θρόνου, καὶ ἕως πρωτοτόκου τῆς θεραπαίνης τῆς παρὰ τὸν μύλον, καὶ ἕως πρωτοτοκου παντος κτήνους. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Καὶ ἔσται κραυγὴ μεγάλη κατὰ πᾶσαν γῆν Αἰγύπτου, ἥτις τοιαύτη οὐ γέγονε, καὶ τοιαύτη οὐκ ἔτι προστεθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Καὶ ἐν πᾶσι τοῖς υἱοῖς Ἰσραὴλ οὐ γρύξει κύων τῇ γλώσσῃ αὐτοῦ, ἀπὸ ἀνθρώπου ἕως κτήνους· ὅπως εἰδῇς ὅσα παραδοξάσει Κύριος ἀνὰ μέσον τῶν Αἰγυπτίων καὶ τοῦ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Καὶ καταβήσονται πάντες οἱ παῖδές σου οὗτοι πρός με, καὶ προσκυνήσουσί με, λέγοντες, ἔξελθε σὺ, καὶ πᾶς ὁ λαός σου, οὗ σὺ ἀφηγῇ· καὶ μετὰ ταῦτα ἐξελεύσομαι· ἐξῆλθε δὲ Μωυσῆς ἀπὸ Φαραὼ μετὰ θυμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, οὐκ εἰσακούσεται ὑμῶν Φαραὼ, ἵνα πληθύνων πληθυνῶ μου τὰ σημεῖα, καὶ τὰ τέρατα ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Μωσῆς δὲ καὶ Ἀαρὼν ἐποίησαν πάντα τὰ σημεῖα καὶ τὰ τέρατα ταῦτα ἐν γῇ Αἰγύπτῳ ἐναντίον Φαραώ· ἐσκλήρυνε δὲ Κύριος τὴν καρδίαν Φαραὼ, καὶ οὐκ εἰσήκουσεν ἐξαποστεῖλαι τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Εἶπε δὲ Κύριος πρὸς Μευσῆν καὶ Ἀαρὼν ἐν γῇ Αἰγύπτου, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","ὁ μὴν οὗτος ὑμῖν ἀρχὴ μηνῶν· πρῶτός ἐστιν ὑμῖν ἐν τοῖς μησὶ τοῦ ἐνιαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Λάλησον πρὸς πᾶσαν συναγωγὴν υἱῶν Ἰσραὴλ, λέγων, τῇ δεκάτῃ τοῦ μηνὸς τούτου λαβέτωσαν ἕκαστος πρόβατον κατʼ οἴκους πατριῶν, ἕκαστος πρόβατον κατʼ οἰκίαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ἐὰν δὲ ὀλιγοστοὶ ὦσιν ἐν τῇ οἰκίᾳ, ὥστε μὴ εἶναι ἱκανοὺς εἰς πρόβατον, συλλήψεται μεθʼ ἑαυτοῦ τὸν γείτονα τὸν πλησίον αὐτοῦ· κατὰ ἀριθμὸν ψυχῶν, ἕκαστος τὸ ἀρκοῦν αὐτῷ συναριθμήσεται εἰς πρόβατον. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Πρόβατον τέλειον, ἄρσεν, ἐνιαύσιον ἔσται ὑμῖν· ἀπὸ τῶν ἀρνῶν καὶ τῶν ἐρίφων λὴψεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Καὶ ἔσται ὑμῖν διατετηρημένον ἕως τῆς τεσσαρεσκαιδεκάτης τοῦ μηνὸς τούτου· καὶ σφάξουσιν αὐτὸ πᾶν τὸ πλῆθος συναγωγῆς υἱῶν Ἰσραὴλ πρὸς ἑσπέραν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Καὶ λήψονται ἀπὸ τοῦ αἵματος, καὶ θήσουσιν ἐπὶ τῶν δύο σταθμῶν καὶ ἐπὶ τὴν φλιὰν, ἐν τοῖς οἴκοις ἐν οἷς ἐὰν φάγωσιν αὐτὰ ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Καὶ φάγονται τὰ κρέα τῇ νυκτὶ ταύτῃ ὀπτὰ πυρὶ, καὶ ἄζυμα ἐπὶ πικρίδων ἔδονται. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Οὐκ ἔδεσθε ἀπʼ αὐτῶν ὠμὸν, οὐδὲ ἡψημένον ἐν ὕδατι, ἀλλʼ ἢ ὀπτὰ πυρὶ, κεφαλὴν σὺν τοῖς ποσὶ καὶ τοῖς ἐνδοσθίοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Οὐκ ἀπολείψεται ἀπʼ αὐτοῦ ἕως πρωΐ· καὶ ὀστοῦν οὐ συντρίψετε ἀπʼ αὐτοῦ· τὰ δὲ καταλειπόμενα ἀπʼ αὐτοῦ ἕως πρωῒ ἐν πυρὶ κατακαύσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Οὕτω δὲ φάγεσθε αὐτό· αἱ ὀσφύες ὑμῶν περιεζωσμέναι, καὶ τὰ ὑποδήματα ἐν τοῖς ποσὶν ὑμῶν, καὶ αἱ βακτηρίαι ἐν ταῖς χερσὶν ὑμῶν· καὶ ἔδεσθε αὐτὸ μετὰ σπουδῆς· Πάσχα ἐστὶ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Καὶ διελεύσομαι ἐν γῇ Αἰγύπτῳ ἐν τῇ νυκτὶ ταύτῃ, καὶ πατάξω πᾶν πρωτότοκον ἐν γῇ Αἰγύπτῳ ἀπὸ ἀνθρώπου ἕως κτήνους· καὶ ἐν πᾶσι τοῖς θεοῖς τῶν Αἰγυπτίων ποιήσω τὴν ἐκδίκησιν· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Καὶ ἔσται τὸ αἷμα ὑμῖν ἐν σημείῳ ἐπὶ τῶν οἰκιῶν, ἐν αἷς ὑμεῖς ἔστε ἐκεῖ· καὶ ὄψομαι τὸ αἷμα, καὶ σκεπάσω ὑμᾶς, καὶ οὐκ ἔσται ἐν ὑμῖν πληγὴ τοῦ ἐκτριβῆναι ὅταν παίω ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Καὶ ἔσται ἡ ἡμέρα ὑμῖν αὕτη μνημόσυνον, καὶ ἑορτάσετε αὐτὴν ἑορτὴν Κυρίῳ εἰς πάσας τὰς γενεὰς ὑμῶν· νόμιμον αἰώνιον ἑορτάσετε αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ἑπτὰ ἡμέρας ἄζυμα ἔδεσθε· ἀπὸ δὲ τῆς ἡμέρας τῆς πρώτης, ἀφανιεῖτε ζύμην ἐκ τῶν οἰκιῶν ὑμῶν· πᾶς ὃς ἂν φάγῃ ζύμην, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐξ Ἰσραήλ, ἀπὸ τῆς ἡμέρας τῆς πρώτης ἕως τῆς ἡμέρας τῆς ἑβδόμης. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Καὶ ἡ ἡμέρα ἡ πρώτη, κληθήσεται ἁγία· καὶ ἡ ἡμέρα ἡ ἑβδόμη, κλητὴ ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε ἐν αὐταῖς, πλὴν ὅσα ποιηθήσεται πάσῃ ψυχῇ, τοῦτο μόνον ποιηθήσεται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Καὶ φυλάξετε τὴν ἐντολὴν ταύτην· ἐν γὰρ τῇ ἡμέρᾳ ταύτῃ ἐξάξω τὴν δύναμιν ὑμῶν ἐκ γῆς Αἰγύπτου, καὶ ποιήσετε τὴν ἡμέραν ταύτην εἰς γενεὰς ὑμῶν νόμιμον αἰώνιον, ");
INSERT INTO grcbrent_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ἐναρχόμενοι τῇ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τοῦ πρώτου, ἀφʼ ἑσπέρας ἔδεσθε ἄζυμα, ἕως ἡμέρας μίας καὶ εἰκάδος τοῦ μηνὸς, ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ἑπτὰ ἡμέρας ζύμη οὐχ εὑρεθήσεται ἐν ταῖς οἰκιαῖς ὑμῶν· πᾶς ὃς ἂν φάγῃ ζυμωτὸν, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ συναγωγῆς Ἰσραήλ· ἔν τε τοῖς γειώραις, καὶ αὐτόχθοσι τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Πᾶν ζυμωτὸν οὐκ ἔδεσθε, ἐν παντὶ δὲ κατοικητηρίῳ ὑμῶν ἔδεσθε ἄζυμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ἐκάλεσε δὲ Μωυσῆς πᾶσαν γερουσίαν υἱῶν Ἰσραὴλ, καὶ εἶπε πρὸς αὐτοὺς, ἀπελθόντες λάβετε ὑμῖν αὐτοῖς πρόβατον κατὰ συγγενείας ὑμῶν, καὶ θύσατε τὸ πάσχα. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Λήψεσθε δὲ δέσμην ὑσσώπου, καὶ βάψαντες ἀπὸ τοῦ αἵματος τοῦ παρὰ τὴν θύραν, καθίξετε τῆς φλιᾶς, καὶ ἐπʼ ἀμφοτέρων τῶν σταθμῶν, ἀπὸ τοῦ αἵματος ὅ ἐστι παρὰ τὴν θύραν· ὑμεῖς δὲ οὐκ ἐξελεύσεσθε ἕκαστος τὴν θύραν τοῦ οἴκου αὐτοῦ ἕως πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Καὶ παρελεύσεται Κύριος πατάξαι τοὺς Αἰγυπτίους, καὶ ὄψεται τὸ αἷμα ἐπὶ τῆς φλιᾶς, καὶ ἐπʼ ἀμφοτέρων τῶν σταθμῶν· καὶ παρελεύσεται Κύριος τὴν θύραν, καὶ οὐκ ἀφήσει τὸν ὀλοθρεύοντα εἰσελθεῖν εἰς τὰς οἰκίας ὑμῶν πατάξαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Καὶ φυλάξασθε τὸ ῥῆμα τοῦτο νόμιμον σεαυτῷ, καὶ τοῖς υἱοῖς σου, ἕως αἰῶνος. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ἐὰν δὲ εἰσέλθητε εἰς τὴν γῆν, ἣν ἂν δῷ Κύριος ὑμῖν, καθότι ἐλάλησε, φυλάξασθε τὴν λατρείαν ταύτην. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Καὶ ἐσται ἐὰν λέγωσι πρὸς ὑμᾶς οἱ υἱοὶ ὑμῶν, τίς ἡ λατρεία αὕτη; ");
INSERT INTO grcbrent_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Καὶ ἐρεῖτε αὐτοῖς, θυσία τὸ πάσχα τοῦτο Κυρίῳ, ὡς ἐσκέπασε τοὺς οἴκους τῶν υἱῶν Ἰσραὴλ ἐν Αἰγύπτῳ, ἡνίκα ἐπάταξε τοὺς Αἰγυπτίους, τοὺς δὲ οἴκους ἡμῶν ἐῤῥύσατο· καὶ κύψας ὁ λαὸς προσεκύνησε. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Καὶ ἀπελθόντες ἐποίησαν οἱ υἱοὶ Ἰσραὴλ, καθὰ ἐνετείλατο Κύριος τῷ Μωυσῇ καὶ Ἀαρῶν, οὕτως ἐποίησαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ἐγενήθη δὲ μεσούσης τῆς νυκτὸς, καὶ Κύριος ἐπάταξε πᾶν πρωτότοκον ἐν γῇ Αἰγύπτῳ, ἀπὸ πρωτοτόκου Φαραὼ τοῦ καθημένου ἐπὶ τοῦ θρόνου, ἕως πρωτοτόκου τῆς αἰχμαλωτίδος τῆς ἐν τῷ λάκκῳ, καὶ ἕως πρωτοτόκου παντὸς κτήνους. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Καὶ ἀναστὰς Φαραὼ νυκτὸς, καὶ οἱ θεράποντες αὐτοῦ, καὶ πάντες οἱ Αἰγύπτιοι, καὶ ἔγενήθη κραυγὴ μεγάλη ἐν πάσῃ γῇ Αἰγύπτῳ· οὐ γὰρ ἦν οἰκία, ἐν ᾗ οὐκ ἦν ἐν αὐτῇ τεθνηκώς. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Καὶ ἐκάλεσε Φαραὼ Μωυσῆν καὶ Ἀαρὼν νυκτὸς, καὶ εἶπεν αὐτοῖς, ἀνάστητε, καὶ ἐξέλθατε ἐκ τοῦ λαοῦ μου, καὶ ὑμεῖς, καὶ οἱ υἱοὶ Ἰσραήλ· βαδίζετε καὶ λατρεύσατε Κυρίῳ τῷ Θεῷ ὑμῶν, καθὰ λέγετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Καὶ τὰ πρόβατα καὶ τοὺς βόας ὑμῶν ἀναλαβόντες πορεύεσθε· εὐλογήσατε δὴ κᾀμέ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Καὶ κατεβιάζοντο οἱ Αἰγύπτιοι τὸν λαὸν σπουδῇ ἐκβαλεῖν αὐτοὺς ἐν τῆς γῆς· εἶπαν γὰρ, ὅτι πάντες ἡμεῖς ἀποθνήσκομεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ἀνέλαβε δὲ ὁ λαὸς τὸ σταῖς αὐτῶν, πρὸ τοῦ ζυμωθῆναι τὰ φυράματα αὐτῶν, ἐνδεδεμένα ἐν τοῖς ἱματίοις αὐτῶν ἐπὶ τῶν ὤμαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Οἱ δὲ υἱοὶ Ἰσραὴλ ἐποίησαν, καθὰ συνέταξεν αὐτοῖς Μωυσῆς, καὶ ᾔτησαν παρὰ τῶν Αἰγυπτίων σκεύη ἀργυρᾶ καὶ χρυσᾶ καὶ ἱματισμόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Καὶ ἔδωκε Κύριος τὴν χάριν τῷ λαῷ αὐτοῦ ἐναντίον τῶν Αἰγυπτίων, καὶ ἔχρησαν αὐτοῖς· καὶ ἐσκύλευσαν τοὺς Αἰγυπτίους. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ἀπάραντες δὲ υἱοὶ Ἰσραὴλ ἐκ Ῥαμεσσῆ εἰς Σοκχὼθ εἰς ἑξακοσίας χιλιάδας πεζῶν, οἱ ἄνδρες, πλὴν τῆς ἀποσκευῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Καὶ ἐπίμικτος πολὺς συνανέβη αὐτοῖς, καὶ πρόβατα, καὶ βόες, καὶ κτήνη πολλὰ σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Καὶ ἔπεψαν τὸ σταῖς ὃ ἐξήνεγκαν ἐξ Αἰγύπτου, ἐγκρυφίας ἀζύμους, οὐ γὰρ ἐζυμώθη· ἐξέβαλον γὰρ αὐτοὺς οἱ Αἰγύπτιοι, καὶ οὐκ ἠδυνήθησαν ἐπιμεῖναι, οὐδὲ ἐπισιτισμὸν ἐποίησαν ἑαυτοῖς εἰς τὴν ὁδόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ἡ δὲ κατοίκησις τῶν υἱῶν Ἰσραὴλ, ἣν κατῴκησαν ἐν γῇ Αἰγύπτῳ καὶ ἐν γῇ Χαναὰν, ἔτη τετρακόσια τριάκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Καὶ ἐγένετο μετὰ τὰ τετρακόσια τριάκοντα ἔτη, ἐξῆλθε πᾶσα ἡ δύναμις Κυρίου ἐκ γῆς Αἰγύπτου νυκτός. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Προφυλακή ἐστι τῷ Κυρίῳ, ὥστε ἐξαγαγεῖν αὐτοὺς ἐκ γῆς Αἰγύπτου· ἐκείνη ἡ νὺξ αὕτη, προφυλακὴ Κυρίῳ, ὥστε πᾶσι τοῖς υἱοῖς Ἰσραὴλ εἶναι εἰς γενεὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Εἶπε δὲ Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, οὗτος ὁ νόμος τοῦ πάσχα· πᾶς ἀλλογενὴς οὐκ ἔδεται ἀπʼ αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Καὶ πάντα οἰκέτην ἢ ἀργυρώνητον περιτεμεῖς αὐτόν· καὶ τότε φάγεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Πάροικος ἢ μισθωτὸς οὐκ ἔδεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ἐν οἰκίᾳ μιᾷ βρωθήσεται, καὶ οὐκ ἐξοίσετε ἐκ τῆς οἰκίας τῶν κρεῶν ἔξω· καὶ ὀστοῦν οὐ συντρίψετε ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Πᾶσα συναγωγὴ υἱῶν Ἰσραὴλ ποιήσει αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ἐὰν δέ τις προσέλθῃ πρὸς ὑμᾶς προσήλυτος ποιῆσαι τὸ πάσχα Κυρίῳ, περιτεμεῖς αὐτοῦ πᾶν ἀρσενικόν, καὶ τότε προσελεύσεται ποιῆσαι αὐτό· καὶ ἔσται ὥσπερ καὶ ὁ αὐτόχθων τῆς γῆς· πᾶς ἀπερίτμητος οὐκ ἔδεται ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Νόμος εἷς ἔσται τῷ ἐγχωρίῳ, καὶ τῷ προσελθόντι προσηλύτῳ ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Καὶ ἐποίησαν οἱ υἱοὶ Ἰσραὴλ καθὰ ἐνετείλατο Κύριος τῷ Μωυσῇ καὶ Ἀαρὼν πρὸς αὐτούς, οὕτως ἐποίησαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Καὶ ἐγένετο ἐν τῇ ἡμέρᾳ ἐκείνῃ, ἐξήγαγε Κύριος τοὺς υἱοὺς Ἰσραὴλ ἐκ γῆς Αἰγύπτου σὺν δυνάμει αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","ἁγίασόν μοι πᾶν πρωτότοκον πρωτογενὲς διανοῖγον πᾶσαν μήτραν ἐν τοῖς υἱοῖς Ἰσραὴλ ἀπὸ ἀνθρώπου ἕως κτήνους, ἐμοί ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Εἶπε δὲ Μωυσῆς πρὸς τὸν λαὸν, μνημονεύετε τὴν ἡμέραν ταύτην, ἐν ᾗ ἐξήλθατε ἐκ γῆς Αἰγύπτου, ἐξ οἴκου δουλείας· ἐν γὰρ χειρὶ κραταιᾷ ἐξήγαγεν ὑμᾶς Κύριος ἐντεῦθεν· καὶ οὐ βρωθήσεται ζύμη. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ἐν γὰρ τῇ σήμερον ὑμεῖς ἐκπορεύεσθε ἐν μηνὶ τῶν νέων. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Καὶ ἔσται ἡνίκα ἐὰν εἰσαγάγῃ σε Κύριος ὁ Θεός σου εἰς τὴν γῆν τῶν Χαναναίων, καὶ Χετταίων, καὶ Ἀμοῤῥαίων, καὶ Εὐαίων, καὶ Ἰεβουσαίων, καὶ Γεργεσαίων, καὶ Φερεζαίων, ἣν ὤμοσε τοῖς πατράσι σου, δοῦναί σοι γῆν ῥέουσαν γάλα καὶ μέλι· καὶ ποιήσεις τὴν λατρείαν ταύτην ἐν τῷ μηνὶ τούτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ἓξ ἡμέρας ἔδεσθε ἄζυμα, τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ ἑορτὴ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ἄζυμα ἔδεσθε ἑπτὰ ἡμέρας· οὐκ ὀφθήσεταί σοι ζυμωτὸν, οὐδὲ ἔσται σοι ζύμη ἐν πᾶσι τοῖς ὁρίοις σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Καὶ ἀναγγελεῖς τῷ υἱῷ σου ἐν τῇ ἡμέρᾳ ἐκείνῃ, λέγων, διὰ τοῦτο ἐποίησε Κύριος ὁ Θεός μοι, ὡς ἐξεπορευόμην ἐξ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Καὶ ἔσται σοι σημεῖον ἐπὶ τῆς χειρός σου, καὶ μνημόσυνον πρὸ ὀφθαλμῶν σου, ὅπως ἂν γένηται ὁ νόμος Κυρίου ἐν τῷ στόματί σου· ἐν γὰρ χειρὶ κραταιᾷ ἐξήγαγέ σε Κύριος ὁ Θεὸς ἐξ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Καὶ φυλάξασθε τὸν νόμον τοῦτον κατὰ καιροὺς ὡρῶν, ἀφʼ ἡμερῶν εἰς ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Καὶ ἔσται ὡς ἂν εἰσαγάγῃ σε Κύριος ὁ Θεός σου εἰς τὴν γῆν τῶν Χαναναίων, ὃν τρόπον ὤμοσε τοῖς πατράσι σου, καὶ δώσει σοι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Καὶ ἀφελεῖς πᾶν διανοῖγον μήτραν, τὰ ἀρσενικὰ τῷ Κυρίῳ· πᾶν διανοῖγον μήτραν ἐκ βουκολίων ἢ ἐν τοῖς κτήνεσί σου, ὅσα ἐὰν γένηταί σοι, τὰ ἀρσενικὰ ἁγιάσεις τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Πᾶν διανοῖγον μήτραν ὄνου, ἀλλάξεις προβάτῳ· ἐὰν δὲ μὴ ἀλλάξῃς, λυτρώσῃ αὐτό· πᾶν πρωτότοκον ἀνθρώπου τῶν υἱῶν σου λυτρώσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ἐὰν δὲ ἐρωτήσῃ σε ὁ υἱός σου μετὰ ταῦτα, λέγων, τί τοῦτο; καὶ ἐρεῖς αὐτῷ, ὅτι ἐν χειρὶ κραταιᾷ ἐξήγαγεν Κύριος ἡμᾶς ἐκ γῆς Αἰγύπτου, ἐξ οἴκου δουλείας. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ἡνίκα δὲ ἐσκλήρυνε Φαραὼ ἐξαποστεῖλαι ἡμᾶς, ἀπέκτεινε πᾶν πρωτότοκον ἐν γῇ Αἰγύπτῳ, ἀπὸ πρωτοτόκων ἀνθρώπων ἕως πρωτοτόκων κτηνῶν· διὰ τοῦτο ἐγὼ θύω πᾶν διανοῖγον μήτραν, τὰ ἀρσενικὰ τῷ Κυρίῳ, καὶ πᾶν πρωτότοκον τῶν υἱῶν μου λυτρώσομαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Καὶ ἔσται εἰς σημεῖον ἐπὶ τῆς χειρός σου, καὶ ἀσαλευτον πρὸ ὀφθαλμων σου· ἐν γὰρ χειρὶ κραταιᾷ ἐξήγαγέ σε Κύριος ἐξ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ὡς δὲ ἐξαπέστειλε Φαραὼ τὸν λαὸν, οὐχ ὡδήγησεν αὐτοὺς ὁ Θεὸς ὁδὸν γῆς· Φυλιστιεὶμ, ὅτι ἐγγὺς ἦν· εἶπε γὰρ ὁ Θεὸς, μήποτε μεταμελήσῃ τῷ λαῷ ἰδόντι πόλεμον, καὶ ἀποστρέψῃ εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Καὶ ἐκύκλωσεν ὁ Θεὸς τὸν λαὸν ὁδὸν τὴν εἰς τὴν ἔρημον, εἰς τὴν ἐρυθρὰν θάλασσαν· πέμπτῃ δὲ γενεᾷ ἀνέβησαν οἱ υἱοὶ Ἰσραὴλ ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Καὶ ἔλαβε Μωυσῆς τὰ ὀστᾶ Ἰωσὴφ μεθʼ ἑαυτοῦ· ὅρκῳ γὰρ ὥρκισεν τοὺς υἱοὺς Ἰσραὴλ, λέγων, ἐπισκοπῇ ἐπισκέψεται ὑμᾶς Κύριος, καὶ συνανοίσετε μου τὰ ὀστᾶ ἐντεῦθεν μεθʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ἐξάραντες δὲ οἱ υἱοὶ Ἰσραὴλ ἐκ Σοκχὼθ, ἐστρατοπέδευσαν ἐν Ὀθὼμ παρὰ τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ὁ δὲ Θεὸς ἡγεῖτο αὐτῶν, ἡμέρας μὲν ἐν στύλῳ νεφέλης, δεῖξαι αὐτοῖς τὴν ὁδόν· τὴν δὲ νύκτα ἐν στύλῳ πυρός. ");
INSERT INTO grcbrent_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Οὐκ ἐξέλιπεν δὲ ὁ στύλος τῆς νεφέλης ἡμέρας, καὶ ὁ στύλος τοῦ πυρὸς νυκτὸς, ἐναντίον τοῦ λαοῦ παντός. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἀποστρέψαντες στρατοπεδευσάτωσαν ἀπέναντι τῆς ἐπαύλεως, ἀνὰ μέσον Μαγδώλου καὶ ἀνὰ μέσον τῆς θαλάσσης, ἐξεναντίας Βεελσεπφῶν· ἐνώπιον αὐτῶν στρατοπεδεύσεις ἐπὶ τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Καὶ ἐρεῖ Φαραὼ τῷ λαῷ αὐτοῦ, οἱ υἱοὶ Ἰσραὴλ πλανῶνται οὗτοι ἐν τῇ γῇ, συγκέκλεικε γὰρ αὐτοὺς ἡ ἔρημος. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ἐγὼ δὲ σκληρυνῶ τὴν καρδίαν Φαραὼ, καὶ καταδιώξεται ὀπίσω αὐτῶν· καὶ ἐνδοξασθήσομαι ἐν Φαραῷ, καὶ ἐν πάσῃ τῇ στρατίᾳ αὐτοῦ· καὶ γνώσονται πάντες οἱ Αἰγύπτιοι ὅτι ἐγώ εἰμι Κύριος· καὶ ἐποίησαν οὕτως. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Καὶ ἀνηγγέλη τῷ βασιλεῖ τῶν Αἰγυπτίων ὅτι πέφευγεν ὁ λαός· καὶ μετεστράφη ἡ καρδία Φαραὼ, καὶ τῶν θεραπόντων αὐτοῦ, ἐπὶ τὸν λαὸν, καὶ εἶπαν, τί τοῦτο ἐποιήσαμεν, τοῦ ἐξαποστεῖλαι τοὺς υἱοὺς Ἰσραὴλ, τοῦ μὴ δουλεύειν ἡμῖν; ");
INSERT INTO grcbrent_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ἔζευξεν οὖν Φαραὼ τὰ ἅρματα αὐτοῦ, καὶ πάντα τὸν λαὸν αὐτοῦ συναπήγαγε μεθʼ ἑαυτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","καὶ λαβὼν ἑξακόσια ἅρματα ἐκλεκτὰ, καὶ πᾶσαν τὴν ἵππον τῶν Αἰγυπτίων, καὶ τριστάτας ἐπὶ πάντων. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Καὶ ἐσκλήρυνε Κύριος τὴν καρδίαν Φαραὼ βασιλέως Αἰγύπτου, καὶ τῶν θεραπόντων αὐτοῦ, καὶ κατεδίωξεν ὀπίσω τῶν υἱῶν Ἰσραήλ· οἱ δὲ υἱοὶ Ἰσραὴλ ἐξεπορεύοντο ἐν χειρὶ ὑψηλῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Καὶ κατεδίωξαν οἱ Αἰγύπτιοι ὀπίσω αὐτῶν, καὶ εὕροσαν αὐτοὺς παρεμβεβληκότας παρὰ τὴν θάλασσαν· καὶ πᾶσα ἡ ἵππος καὶ τὰ ἅρματα Φαραὼ, καὶ οἱ ἱππεῖς, καὶ ἡ στρατιὰ αὐτοῦ ἀπέναντι τῆς ἐπαύλεως, ἐξεναντίας Βεελσεπφῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Καὶ Φαραὼ προσῆγε· καὶ ἀναβλέψαντες οἱ υἱοὶ Ἰσραὴλ τοῖς ὀφθαλμοῖς ὁρῶσι, καὶ οἱ Αἰγύπτιοι ἐστρατοπέδευσαν ὀπίσω αὐτῶν· καὶ ἐφοβήθησαν σφόδρα· ἀνεβόησαν δὲ οἱ υἱοὶ Ἰσραὴλ πρὸς Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Καὶ εἶπαν πρὸς Μωυσῆν, παρὰ τὸ μὴ ὑπάρχειν μνήματα ἐν γῇ Αἰγύπτῳ, ἐξήγαγες ἡμᾶς θανατῶσαι ἐν τῇ ἐρήμῳ· τί τοῦτο ἐποίησας ἡμῖν, ἐξαγαγὼν ἐξ Αἰγύπτου; ");
INSERT INTO grcbrent_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Οὐ τοῦτο ἦν τὸ ῥῆμα, ὃ ἐλαλήσαμεν πρὸς σὲ ἐν Αἰγύπτῳ, λέγοντες, πάρες ἡμᾶς, ὅπως δουλεύσωμεν τοῖς Αἰγυπτίοις; κρεῖσσον γὰρ ἡμᾶς δουλεύειν τοῖς Αἰγυπτίοις, ἢ ἀποθανεῖν ἐν τῇ ἐρήμῳ ταύτῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Εἶπε δὲ Μωυσῆς πρὸς τὸν λαὸν, θαρσεῖτε, στῆτε καὶ ὁρᾶτε τὴν σωτηρίαν τὴν παρὰ τοῦ Κυρίου, ἣν ποιήσει ἡμῖν σήμερον· ὃν τρόπον γὰρ ἑωράκατε τοὺς Αἰγυπτίους σήμερον, οὐ προσθήσεσθε ἔτι ἰδεῖν αὐτοὺς εἰς τὸν αἰῶνα χρόνον· ");
INSERT INTO grcbrent_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Κύριος πολεμήσει περὶ ὑμῶν, καὶ ὑμεῖς σιγήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, τί βοᾷς πρός με; λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἀναζευξάτωσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Καὶ σὺ ἔπαρον τῇ ῥάβδῳ σου, καὶ ἔκτεινον τὴν χεῖρά σου ἐπὶ τὴν θάλασσαν, καὶ ῥῆξον αὐτήν· καὶ εἰσελθάτωσαν οἱ υἱοὶ Ἰσραὴλ εἰς μέσον τῆς θαλάσσης κατὰ τὸ ξηρόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Καὶ ἰδοὺ ἐγὼ σκληρυνῶ τὴν καρδίαν Φαραὼ, καὶ τῶν Αἰγυπτίων πάντων, καὶ εἰσελεύσονται ὀπίσω αὐτῶν· καὶ ἐνδοξασθήσομαι ἐν Φαραῷ, καὶ ἐν πάσῃ τῇ στρατιᾷ αὐτοῦ, καὶ ἐν τοῖς ἅρμασι, καὶ ἐν τοῖς ἵπποις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Καὶ γνώσονται πάντες οἱ Αἰγύπτιοι ὅτι ἐγώ εἰμὶ Κύριος, ἐνδοξαζομένου μου ἐν Φαραῷ, καὶ ἐν τοῖς ἅρμασι, καὶ ἵπποις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ἐξῇρε δὲ ὁ Ἄγγελος τοῦ Θεοῦ ὁ προπορευόμενος τῆς παρεμβολῆς τῶν υἱῶν Ἰσραὴλ, καὶ ἐπορεύθη ἐκ τῶν ὄπισθεν· ἐξῇρε δὲ καὶ ὁ στύλος τὴς νεφέλης ἀπὸ προσώπου αὐτῶν, καὶ ἔστη ἐκ τῶν ὀπίσω αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Καὶ εἰσῆλθεν ἀνὰ μέσον τῆς παρεμβολῆς τῶν Αἰγυπτίων, καὶ ἀνὰ μέσον τῆς παρεμβολῆς τῶν Αἰγυπίων, καὶ ἀνὰ μέσον τῆς παρεμβολῆς Ἰσραὴλ, καὶ ἔστη· καὶ ἐγένετο σκότος καὶ γνόφος· καὶ διῆλθεν ἡ νύξ· καὶ οὐ συνέμιξαν ἀλλήλοις ὅλην τὴν νύκτα. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ἐξέτεινε δὲ Μωυσῆς τὴν χεῖρα ἐπὶ τὴν θάλασσαν· καὶ ὑπήγαγε Κύριος τὴν θάλασσαν ἐν ἀνέμῳ νότῳ βιαίῳ ὅλην τὴν νύκτα, καὶ ἐποίησε τὴν θάλασσαν ξηράν· καὶ ἐσχίσθη τὸ ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Καὶ εἰσῆλθον οἱ υἱοὶ Ἰσραὴλ εἰς μέσον τῆς θαλάσσης κατὰ τὸ ξηρόν· καὶ τὸ ὕδωρ αὐτῆς τεῖχος ἐκ δεξιῶν, καὶ τεῖχος ἐξ εὐωνύμων. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Καὶ κάτεδίωξαν οἱ Αἰγύπτιοι, καὶ εἰσῆλθον ὀπίσω αὐτῶν καὶ πᾶς ἵππος Φαραὼ, καὶ τὰ ἅρματα, καὶ οἱ ἀναβάται, εἰς μέσον τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ἐγενήθη δὲ ἐν τῇ φυλακῇ τῇ ἑωθινῇ, καὶ ἐπίβλεψε Κύριος ἐπὶ τὴν παρεμβολὴν τῶν Αἰγυπτίων ἐν στύλῳ πυρὸς καὶ νεφέλης, καὶ συνετάραξε τὴν παρεμβολὴν τῶν Αἰγυπτίων, ");
INSERT INTO grcbrent_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","καὶ συνέδησε τοὺς ἄξονας τῶν ἁρμάτων αὐτῶν, καὶ ἤγαγεν αὐτοὺς μετὰ βίας· καὶ εἶπαν οἱ Αἰγύπτιοι, φυγωμεν ἀπὸ προσώπου Ἰσραήλ· ὁ γὰρ Κύριος πολεμεῖ περὶ αὐτῶν τοὺς Αἰγυπτίους. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἔκτεινον τὴν χεῖρά σου ἐπὶ τὴν θάλασσαν, καὶ ἀποκαταστήτω τὸ ὕδωρ, καὶ ἐπικαλυψάτω τοὺς Αἰγυπτίους, ἐπί τε τὰ ἅρματα καὶ τοὺς ἀναβάτας. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ἐξέτεινε δὲ Μωυσῆς τὴν χεῖρα ἐπὶ τὴν θάλασσαν, καὶ ἀπεκατέστη τὸ ὕδωρ πρὸς ἡμέραν ἐπὶ χώρας· οἱ δὲ Αἰγύπτιοι ἔφυγον ὑπὸ τὸ ὕδωρ· καὶ ἐξετίναξε Κύριος τοὺς Αἰγυπτίους μέσον τῆς θαλάσοης. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Καὶ ἐπαναστραφὲν τὸ ὕδωρ ἐκάλυψε τὰ ἅρματα καὶ τοὺς ἀναβάτας, καὶ πᾶσαν τὴν δύναμιν Φαραὼ, τοὺς εἰσπεπορευμένους ὀπίσω αὐτῶν εἰς τὴν θάλασσαν· καὶ οὐ κατελείφθη ἐξ αὐτῶν οὐδὲ εἷς. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Οἱ δὲ υἱοὶ Ἰσραὴλ ἐπορεύθησαν διὰ ξηρᾶς ἐν μέσῳ τῆς θάλασσης· τὸ δὲ ὕδωρ αὐτοῖς τεῖχος ἐκ δεξιῶν, καὶ τεῖχος ἐξ εὐωνύμων. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Καὶ ἐῤῥύσατο Κύριος τὸν Ἰσραὴλ ἐν τῇ ἡμέρᾳ ἐκείνῃ ἐκ χειρὸς τῶν Αἰγυπτίων· καὶ εἶδεν Ἰσραὴλ τοὺς Αἰγυπτίους τεθνηκότας παρὰ τὸ χεῖλος τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Εἶδε δὲ Ἰσραὴλ τὴν χεῖρα τὴν μεγάλην, ἃ ἐποίησε Κύριος τοῖς Αἰγυπτίοις· ἐφοβήθη δὲ ὁ λαὸς τὸν Κύριον, καὶ ἐπίστευσαν τῷ Θεῷ, καὶ Μωυσῇ τῷ θεράποντι αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Τότε ᾖσε Μωυσῆς καὶ οἱ υἱοὶ Ἰσραὴλ τὴν ᾠδὴν ταύτην τῷ Θεῷ, καὶ εἶπαν, λέγοντες, ᾄσωμεν τῷ Κυρίῳ, ἐνδόξως γὰρ δεδόξασται· ἵππον καὶ ἀναβάτην ἔῤῥιψεν εἰς θάλασσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Βοηθὸς καὶ σκεπαστὴς ἐγένετό μοι εἰς σωτηρίαν· οὗτός μου Θεὸς, καὶ δοξάσω αὐτόν· Θεὸς τοῦ πατρός μου, καὶ ὑψώσω αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Κύριος συντρίβων πολέμους, Κύριος ὄνομα αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ἅρματα Φαραὼ, καὶ τὴν δύναμιν αὐτοῦ, ἔῤῥιψεν εἰς θάλασσαν, ἐπιλέκτους ἀναβάτας τριστάτας· κατεπόθησαν ἐν ἐρυθρᾷ θαλάσσῃ· ");
INSERT INTO grcbrent_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Πόντῳ ἐκάλυψεν αὐτούς· κατέδυσαν εἰς βυθὸν ὡσεὶ λίθος. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ἡ δεξιά σου, Κύριε, δεδόξασται ἐν ἰσχύϊ· ἡ δεξιά σου χεὶρ, Κύριε, ἔθραυσεν ἐχθρούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Καὶ τῷ πλήθει τῆς δόξης σου συνέτριψας τοὺς ὑπεναντίους· ἀπέστειλας τὴν ὀργήν σου κατέφαγεν αὐτοὺς ὡς καλάμην. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Καὶ διὰ πνεύματος τοῦ θυμοῦ σου διέστη τὸ ὕδωρ· ἐπάγη ὡσεὶ τεῖχος τὰ ὕδατα· ἐπάγη τὰ κύματα ἐν μέσῳ τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Εἶπεν ὁ ἐχθρὸς, διώξας καταλήψομαι, μεριῶ σκῦλα· ἐμπλήσω ψυχήν μου, ἀνελῶ τῇ μαχαίρῃ μου, κυριεύσει ἡ χείρ μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ἀπέστειλας τὸ πνεῦμά σου· ἐκάλυψεν αὐτοὺς θάλασσα· ἔδυσαν ὡσεὶ μόλιβος ἐν ὕδατι σφοδρῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Τίς ὅμοιός σοι ἐν θεοῖς, Κύριε; τίς ὅμοιός σοι; δεδοξασμένος ἐν ἁγίοις, θαυμαστὸς ἐν δόξαις, ποιῶν τέρατα. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ἐξέτεινας τὴν δεξιάν σου· κατέπιεν αὐτοὺς γῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ὡδήγησας τῇ δικαιοσύνῃ σου τὸν λαόν σου τοῦτον, ὃν ἐλυτρώσω· παρεκάλεσας τῇ ἰσχύϊ σου εἰς κατάλυμα ἅγιόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ἤκουσαν ἔθνη, καὶ ὠργίσθησαν· ὠδῖνες ἔλαβον κατοικοῦντας Φυλιστιείμ. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Τότε ἔσπευσαν ἡγεμόνες Ἐδὼμ, καὶ ἄρχοντες Μωαβιτῶν· ἔλαβεν αὐτοὺς τρόμος· ἐτάκησαν πάντες οἱ κατοικοῦντες Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ἐπιπέσοι ἐπʼ αὐτοὺς τρόμος καὶ φόβος· μεγέθει βραχίονός σου ἀπολιθωθήτωσαν, ἕως ἂν παρέλθῃ ὁ λαός σου, Κύριε· ἕως ἂν παρέλθῃ ὁ λαός σου οὗτος, ὃν ἐκτήσω. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Εἰσαγαγὼν καταφύτευσον αὐτοὺς εἰς ὄρος κληρονομίας σου, εἰς ἕτοιμον κατοικητήριόν σου, ὃ κατηρτίσω, Κύριε, ἁγίασμα, Κύριε, ὃ ἡτοίμασαν αἱ χεῖρές σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Κύριος βασιλεύων τὸν αἰῶνα, καὶ ἐπʼ αἰῶνα, καὶ ἔτι. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ὅτι εἰσῆλθεν ἵππος Φαραὼ σὺν ἅρμασιν καὶ ἀναβάταις εἰς θάλασσαν, καὶ ἐπήγαγεν ἐπʼ αὐτοὺς Κύριος τὸ ὕδωρ τῆς θαλάσσης· οἱ δὲ υἱοὶ Ἰσραὴλ ἐπορεύθησαν διὰ ξηρᾶς ἐν μέσῳ τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Λαβοῦσα δὲ Μαριὰμ ἡ προφῆτις ἡ ἀδελφὴ Ἀαρὼν τὸ τύμπανον ἐν τῇ χειρὶ αὐτῆς, καὶ ἐξήλθοσαν πᾶσαι αἱ γυναῖκες ὀπίσω αὐτῆς μετὰ τυμπάνων καὶ χορῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ἐξῆρχε δὲ αὐτῶν Μαριὰμ, λέγουσα, ᾄσωμεν τῷ Κυρίῳ, ἐνδόξως γὰρ δεδόξασται· ἵππον καὶ ἀναβάτην ἔῤῥιψεν εἰς θάλασσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ἐξῆρε δὲ Μωυσῆς τοὺς υἱοὺς Ἰσραὴλ ἀπὸ θαλάσσης ἐρυθρᾶς, καὶ ἤγαγεν αὐτοὺς εἰς τὴν ἔρημον Σούρ· καὶ ἐπορεύοντο τρεῖς ἡμέρας ἐν τῇ ἐρήμῳ, καὶ οὐχ ηὕρισκον ὕδωρ, ὥστε πιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ἦλθον δὲ εἰς Μεῤῥᾶ, καὶ οὐκ ἠδύναντο πιεῖν ἐκ Μεῤῥᾶς· πικρὸν γὰρ ἦν· διὰ τοῦτο ἐπωνόμασε τὸ ὄνομα τοῦ τόπου ἐκείνου, Πικρία. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Καὶ διεγόγγυζεν ὁ λαὸς ἐπὶ Μωυσῇ, λέγοντες, τί πιόμεθα; ");
INSERT INTO grcbrent_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ἐβόησε δὲ Μωυσῆς πρὸς Κύριον· καὶ ἔδειξεν αὐτῷ Κύριος ξύλον, καὶ ἐνέβαλεν αὐτὸ εἰς τὸ ὕδωρ, καὶ ἐγλυκάνθη τὸ ὕδωρ· ἐκεῖ ἔθετο αὐτῷ δικαιώματα καὶ κρίσεις· καὶ ἐκεῖ αὐτὸν ἐπείρασε, ");
INSERT INTO grcbrent_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","καὶ εἶπεν, ἐὰν ἀκοῇ ἀκούσῃς τῆς φωνῆς Κυρίου τοῦ Θεοῦ σου, καὶ τὰ ἀρεστὰ ἐναντίον αὐτοῦ ποιήσῃς, καὶ ἐνωτίσῃ ταῖς ἐντολαῖς αὐτοῦ, καὶ φυλάξῃς πάντα τὰ δικαιώματα αὐτοῦ, πᾶσαν νόσον, ἣν ἐπήγαγον τοῖς Αἰγυπτίοις, οὐκ ἐπάξω ἐπὶ σέ· ἐγὼ γάρ εἰμι Κύριος ὁ Θεός σου ὁ ἰώμενός σε. ");
INSERT INTO grcbrent_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Καὶ ἤλθοσαν εἰς Αἰλείμ· καὶ ἦσαν ἐκεῖ δώδεκα πηγαὶ ὑδάτων, καὶ ἑβδομήκοντα στελέχη φοινίκων· παρενέβαλον δὲ ἐκεῖ παρὰ τὰ ὕδατα. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ἀπῄραν δὲ ἐξ Αἰλεὶμ, καὶ ἤλθοσαν πᾶσα συναγωγὴ υἱῶν Ἰσραὴλ εἰς τὴν ἔρημον Σὶν, ὅ ἐστιν ἀνὰ μέσον Αἰλεὶμ, καὶ ἀνὰ μέσον Σινά. τῇ δὲ πεντεκαιδεκάτῃ ἡμέρᾳ, τῷ μηνὶ τῷ δευτέρῳ ἐξεληλυθότων αὐτῶν ἐκ γῆς Αἰγύπτου, ");
INSERT INTO grcbrent_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","διεγόγγυζε πᾶσα συναγωγὴ υἱῶν Ἰσραὴλ ἐπὶ Μωυσὴν καὶ Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Καὶ εἶπεν πρὸς αὐτοὺς οἱ υἱοὶ Ἰσραήλ, ὄφελον ἀπεθάνομεν πληγέντες ὑπὸ Κυρίου ἐν γῇ Αἰγύπτῳ, ὅταν ἐκαθίσαμεν ἐπὶ τῶν λεβήτων τῶν κρεῶν, καὶ ἠσθίομεν ἄρτους εἰς πλησμονήν· ὅτι ἐξηγάγετε ἡμᾶς εἰς τὴν ἔρημον ταύτην, ἀποκτεῖναι πᾶσαν τὴν συναγωγὴν ταύτην ἐν λιμῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἰδοὺ ἐγὼ ὕω ὑμῖν ἄρτους ἐκ τοῦ οὐρανοῦ· καὶ ἐξελεύσεται ὁ λαὸς, καὶ συλλέξουσι τὸ τῆς ἡμέρας εἰς ἡμέραν, ὅπως πειράσω αὐτοὺς εἰ πορεύσονται τῷ νόμῳ μου, ἢ οὔ· ");
INSERT INTO grcbrent_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Καὶ ἔσται ἐν τῇ ἡμέρᾳ τῇ ἕκτῃ, καὶ ἑτοιμάσουσιν ὃ ἐὰν εἰσενέγκωσι· καὶ ἔσται διπλοῦν ὃ ἐὰν συναγάγωσι τὸ καθʼ ἡμέραν εἰς ἡμέραν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Καὶ εἶπε Μωυσῆς καὶ Ἀαρὼν πρὸς πάσαν συναγωγὴν υἱῶν Ἰσραὴλ, ἑσπέρας γνώσεσθε, ὅτι Κύριος ἐξήγαγεν ὑμᾶς ἐκ γῆς Αἰγύπτου, ");
INSERT INTO grcbrent_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","καὶ πρωῒ ὄψεσθε τὴν δόξαν Κυρίου ἐν τῷ εἰσακοῦσαι τὸν γογγυσμὸν ὑμῶν ἐπὶ τῷ Θεῷ· ἡμεῖς δὲ τί ἐσμεν, ὅτι διαγογγύζετε καθʼ ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Καὶ εἶπε Μωυσῆς, ἐν τῷ διδόναι Κύριον ὑμῖν ἑσπέρας κρέα φαγεῖν, καὶ ἄρτους τὸ πρωῒ εἰς πλησμονὴν, διὰ τὸ εἰσακοῦσαι Κύριον τὸν γογγυσμὸν ὑμῶν, ὃν ὑμεῖς διαγογγύζετε καθʼ ἡμῶν· ἡμεῖς δὲ τί ἐσμεν; οὐ γὰρ καθʼ ἡμῶν ἐστιν ὁ γογγυσμὸς ὑμῶν, ἀλλʼ ἢ κατὰ τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Εἶπε δὲ Μωυσῆς πρὸς Ἀαρὼν, εἶπον πάσῃ συναγωγῇ υἱῶν Ἰσραὴλ, προσέλθετε ἐναντίον τοῦ Θεοῦ· εἰσακήκοε γὰρ τὸν γογγυσμὸν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ἡνίκα δὲ ἐλάλει Ἀαρὼν πάσῃ συναγωγῇ υἱῶν Ἰσραὴλ, καὶ ἐπεστράφησαν εἰς τὴν ἔρημον, καὶ ἡ δόξα Κυρίου ὤφθη ἐν νεφέλῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","εἰσακήκοα τὸν γογγυσμὸν τῶν υἱῶν Ἰσραήλ· λάλησον πρὸς αὐτοὺς, λέγων, τὸ πρὸς ἑσπέραν ἔδεσθε κρέα, καὶ τὸ πρωῒ πλησθήσεσθε ἄρτων· καὶ γνώσεσθε, ὅτι ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ἐγένετο δὲ ἑσπέρα· καὶ ἀνέβη ὀρτυγομήτρα, καὶ ἐκάλυψε τὴν παρεμβολήν· τὸ πρωῒ ἐγένετο καταπαυομένης τῆς δρόσου κύκλῳ τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Καὶ ἰδοὺ ἐπὶ πρόσωπον τῆς ἐρήμου λεπτὸν ὡσεὶ κόριον λευκὸν, ὡσεὶ πάγος ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ἰδόντες δὲ αὐτὸ οἱ υἱοὶ Ἰσραὴλ, εἶπαν ἕτερος τῷ ἑτέρῳ, τί ἐστι τοῦτο; οὐ γὰρ ᾔδεισαν τί ἦν· εἶπε δὲ Μωυσῆς αὐτοῖς, οὗτος ὁ ἄρτος, ὃν ἔδωκε Κύριος ὑμῖν φαγεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Τοῦτο τὸ ῥῆμα ὃ συνέταξε Κύριος· συναγάγετε ἀπʼ αὐτοῦ ἕκαστος εἰς τοὺς καθήκοντας γομὸρ, κατὰ κεφαλὴν κατὰ ἀριθμὸν ψυχῶν ὑμῶν, ἕκαστος σὺν τοῖς συσκηνίοις ὑμῶν συλλέξατε. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ἐποίησαν δὲ οὕτως οἱ υἱοὶ Ἰσραήλ· καὶ συνέλεξαν ὁ τὸ πολὺ καὶ ὁ τὸ ἔλαττον. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Καὶ μετρήσαντες γομὸρ, οὐκ ἐπλεόνασεν ὁ τὸ πόλυ, καὶ ὁ τὸ ἔλαττον οὐκ ἠλαττόνησεν· ἕκαστος εἰς τοὺς καθήκοντας παρʼ ἑαυτῷ συνέλεξαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Εἶπε δὲ Μωυσῆς πρὸς αὐτοὺς, μηδεὶς καταλειπέτω ἀπʼ αὐτοῦ εἰς τὸ πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Καὶ οὐκ εἰσήκουσαν Μωυσῆ, ἀλλὰ κατέλιπόν τινες ἀπʼ αὐτοῦ εἰς τὸ πρωΐ· καὶ ἐξέζεσε σκώληκας, καὶ ἐπώζεσε· καὶ ἐπικράνθη ἐπʼ αὐτοῖς Μωυσῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Καὶ συνέλεξαν αὐτὸ πρωῒ πρωῒ, ἕκαστος τὸ καθῆκον αὐτῷ· ἡνίκα δὲ διεθέρμαινεν ὁ ἥλιος, ἐτήκετο. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ἐγένετο δὲ τῇ ἡμέρᾳ τῇ ἕκτῃ, συνέλεξαν τὰ δέοντα διπλᾶ, δύο γομὸρ τῷ ἑνί· εἰσήλθοσαν δὲ πάντες οἱ ἄρχοντες τῆς συναγωγῆς, καὶ ἀνήγγειλαν Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Εἶπε δὲ Μωυσῆς πρὸς αὐτούς, οὐ τοῦτο τὸ ῥῆμά ἐστιν ὃ ἐλάλησε Κύριος; σάββατα ἀνάπαυσις ἁγία τῷ Κυρίῳ αὔριον· ὅσα ἐὰν πέσσητε, πέσσετε· καὶ ὅσα ἐὰν ἕψητε, ἕψετε· καὶ πᾶν τὸ πλεονάζον καταλείπετε αὐτὸ εἰς ἀποθήκην εἰς τὸ πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Καὶ κατελίποσαν ἀπʼ αὐτοῦ εἰς ἕως πρωῒ, καθὼς συνέταξεν αὐτοῖς Μωυσῆς· καὶ οὐκ ἐπώζεσεν, οὐδὲ σκώληξ ἐγένετο ἐν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Εἶπε δὲ Μωυσῆς, φάγετε σήμερον· ἔστι γὰρ σάββατα αήμερον τῷ Κυρίῳ· οὐχ εὑρεθήσεται ἐν τῷ πεδίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ἓξ ἡμέρας συλλέξετε· τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ σάββατα, ὅτι οὐκ ἔσται ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ἐγένετο δὲ ἐν τῇ ἡμέρᾳ τῇ ἑβδόμῃ ἐξήθλοσάν τινες ἐκ τοῦ λαοῦ συλλέξαι, καὶ οὐχ εὗρον. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἕως τίνος οὐ βούλεσθε εἰσακούειν τὰς ἐντολάς μου, καὶ τὸν νόμον μου; ");
INSERT INTO grcbrent_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ἴδετε, ὁ γὰρ Κύριος ἔδωκεν ὑμῖν σάββατα τὴν ἡμέραν ταύτην· διὰ τοῦτο αὐτὸς ἔδωκεν ὑμῖν τῇ ἡμέρᾳ τῇ ἕκτῃ ἄρτους δύο ἡμερῶν· καθίσεσθε ἕκαστος εἰς τοὺς οἴκους ὑμῶν· μηδεὶς ἐκπορευέσθω ἐκ τοῦ τόπου αὐτοῦ τῇ ἡμέρᾳ τῇ ἑβδόμῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Καὶ ἐσαββάτισεν ὁ λαὸς τῇ ἡμέρᾳ τῇ ἑβδόμῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Καὶ ἐπωνόμασαν αὐτὸ οἱ υἱοὶ Ἰσραὴλ τὸ ὄνομα αὐτοῦ, Μάν· ἦν δὲ ὡσεὶ σπέρμα κορίου λευκόν· τὸ δὲ γεῦμα αὐτοῦ ὡς ἐγκρὶς ἐν μέλιτι. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Εἶπε δὲ Μωυσῆς, τοῦτο τὸ ῥῆμα, ὃ συνέταξε Κύριος, πλήσατε τὸ γομὸρ τοῦ μὰν, εἰς ἀποθήκην εἰς τὰς γενεὰς ὑμῶν· ἵνα ἴδωσι τὸν ἄρτον, ὃν ἐφάγετε ὑμεῖς ἐν τῇ ἐρήμῳ, ὡς ἐξήγαγεν ὑμᾶς Κύριος ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν, λάβε στάμνον χρυσοῦν ἕνα, καὶ ἔμβαλε εἰς αὐτὸν πλῆρες τὸ γομὸρ τοῦ μὰν, καὶ ἀποθήσεις αὐτὸ ἐναντίον τοῦ Θεοῦ, εἰς διατήρησιν εἰς τὰς γενεὰς ὑμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ· καὶ ἀπέθηκεν Ἀαρὼν ἐναντίον τοῦ μαρτυρίου εἰς διατήρησιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Οἱ δὲ υἱοὶ Ἰσραὴλ ἔφαγον τὸ μὰν ἔτη τεσσαράκοντα, ἕως ἦλθον εἰς τὴν οἰκουμένην ἐφάγοσαν τὸ μὰν, ἕως παρεγένοντο εἰς μέρος τῆς Φοινίκης. ");
INSERT INTO grcbrent_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Τὸ δὲ γομὸρ τὸ δέκατον τῶν τριῶν μέτρων ἦν. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Καὶ ἀπῇρε πᾶσα συναγωγὴ υἱῶν Ἰσραὴλ ἐκ τῆς ἐρήμου Σὶν κατὰ παρεμβολὰς αὐτῶν, διὰ ῥήματος Κυρίου· καὶ παρενεβάλοσαν ἐν Ῥαφιδείν· οὐκ ἦν δὲ ὕδωρ τῷ λαῷ πιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Καὶ ἐλοιδορεῖτο ὁ λαὸς πρὸς Μωυσῆν, λέγοντες, δὸς ἡμῖν ὕδωρ, ἵνα πίωμεν· καὶ εἶπεν αὐτοῖς Μωυσῆς, τί λοιδορεῖσθέ μοι, καὶ τί πειράζετε Κύριον; ");
INSERT INTO grcbrent_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ἐδίψησε δὲ ἐκεῖ ὁ λαὸς ὕδατι· καὶ διεγόγγυσεν ἐκεῖ ὁ λαὸς πρὸς Μωυσῆν, λέγοντες, ἱνατί τοῦτο; ἀνεβίβασας ἡμᾶς ἐξ Αἰγύπτου ἀποκτεῖναι ἡμᾶς καὶ τὰ τέκνα ἡμῶν καὶ τὰ κτήνη τῷ δίψει; ");
INSERT INTO grcbrent_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ἐβόησε δὲ Μωυσῆς πρὸς Κύριον, λέγων, τί ποιήσω τῷ λαῷ τούτῳ; ἔτι μικρὸν, καὶ καταλιθοβολὴσουσί με. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, προπορεύου τοῦ λαοῦ τούτου· λάβε δὲ σεαυτῷ ἀπὸ τῶν πρεσβυτέρων τοῦ λαοῦ· καὶ τὴν ῥάβδον, ἐν ᾗ ἐπάταξας τὸν ποταμὸν, λάβε ἐν τῇ χειρί σου, καὶ πορεύσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ὅδε ἐγὼ ἕστηκα ἐκεῖ πρὸ τοῦ σὲ ἐπὶ τῆς πέτρας ἐν Χωρήβ· καὶ πατάξεις τὴν πέτραν, καὶ ἐξελεύσεται ἐξ αὐτῆς ὕδωρ, καὶ πίεται ὁ λαός. Ἐποίησε δὲ Μωυσῆς οὕτως ἐναντίον τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Καὶ ἐπωνόμασε τὸ ὄνομα τοῦ τόπου ἐκείνου, Πειρασμὸς, καὶ Λοιδόρησις, διὰ τὴν λοιδορίαν τῶν υἱῶν Ἰσραὴλ, καὶ διὰ τὸ πειράζειν Κύριον, λέγοντας, εἰ ἔστι Κύριος ἐν ἡμῖν, ἢ οὔ; ");
INSERT INTO grcbrent_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ἦλθε δὲ Ἀμαλὴκ καὶ ἐπολέμει Ἰσραὴλ ἐν Ῥαφιδείν. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Εἶπε δὲ Μωυσῆς τῷ Ἰησοῖ, Ἐπίλεξον σεαυτῷ ἄνδρας δυνατοὺς, καὶ ἐξελθὼν παράταξαι τῷ Ἀμαλὴκ αὔριον· καὶ ἰδοὺ ἐγὼ ἕστηκα ἐπὶ τῆς κορυφῆς τοῦ βουνοῦ, καὶ ἡ ῥάβδος τοῦ Θεοῦ ἐν τῇ χειρί μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Καὶ ἐποίησεν Ἰησοῦς καθάπερ εἶπεν αὐτῷ Μωυσῆς, καὶ ἐξελθὼν παρετάξατο τῷ Ἀμαλήκ· καὶ Μωυσῆς καὶ Ἀαρὼν καὶ Ὢρ ἀνέβησαν ἐπὶ τὴν κορυφὴν τοῦ βουνοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Καὶ ἐγένετο ὅταν ἐπῇρε Μωυσῆς τὰς χεῖρας, κατίσχυεν Ἰσραήλ· ὅταν δὲ καθῆκε τὰς χεῖρας, κατίσχυεν Ἀμαλήκ. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Αἱ δὲ χεῖρες Μωυσῆ βαρεῖαι· καὶ λαβόντες λίθον ὑπέθηκαν ὑπʼ αὐτὸν, καὶ ἐκάθητο ἐπʼ αὐτοῦ· καὶ Ἀαρὼν καὶ Ὢρ ἐστήριζον τὰς χεῖρας αὐτοῦ ἐντεῦθεν εἷς, καὶ ἐντεῦθεν εἷς· καὶ ἐγένοντο αἱ χεῖρες Μωυσῆ ἐστηριγμέναι ἕως δυσμῶν ἡλίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Καὶ ἐτρέψατο Ἰησοῦς τὸν Ἀμαλὴκ, καὶ πάντα τὸν λαὸν αὐτοῦ ἐν φόνῳ μαχαίρας. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, Κατάγραψον τοῦτο εἰς μνημόσυνον εἰς βιβλίον, καὶ δὸς εἰς τὰ ὦτα Ἰησοῖ· ὅτι ἀλοιφῇ ἐξαλείψω τὸ μνημόσυνον Ἀμαλὴκ ἐκ τῆς ὑπὸ τὸν οὐρανόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Καὶ ᾠκοδόμησε Μωυσῆς θυσιαστήριον Κυρίῳ· καὶ ἐπωνόμασε τὸ ὄνομα αὐτοῦ, Κύριος καταφυγή μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ὅτι ἐν χειρὶ κρυφαίᾳ πολεμεῖ Κύριος ἐπὶ Ἀμαλὴκ ἀπὸ γενεῶν εἰς γενεάς. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ἤκουσε δὲ Ἰοθὸρ ἱερεὺς Μαδιὰμ ὁ γαμβρὸς Μωυσῆ πάντα ὅσα ἐποίησε Κύριος Ἰσραὴλ τῷ ἑαυτοῦ λαῷ· ἐξήγαγε γὰρ Κύριος τὸν Ἰσραὴλ ἐξ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ἔλαβε δὲ Ἰοθὸρ ὁ γαμβρὸς Μωυσῆ Σεπφώραν τὴν γυναῖκα Μωυσῆ μετὰ τὴν ἄφεσιν αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","καὶ τοὺς δύο υἱοὺς αὐτῆς· ὄνομα τῷ ἑνὶ αὐτῶν Γηρσάμ, λέγων, πάροικος ἤμην ἐν γῇ ἀλλοτρίᾳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","καὶ τὸ ὄνομα τοῦ δευτέρου Ἐλίεζερ, λέγων, ὁ γὰρ Θεὸς τοῦ πατρός μου βοηθός μου, καὶ ἐξείλατό με ἐκ χειρὸς Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Καὶ ἐξῆλθεν Ἰοθὸρ ὁ γαμβρὸς Μωυσῆ καὶ οἱ υἱοὶ καὶ ἡ γυνὴ πρὸς Μωυσῆν εἰς τὴν ἔρημον, οὗ παρενέβαλεν ἐπʼ ὄρους τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ἀνηγγέλη δὲ Μωυσῇ, λέγοντες, ἰδοὺ ὁ γαμβρός σου Ἰοθὸρ παραγίνεται πρὸς σέ, καὶ ἡ γυνὴ καὶ οἱ δύο υἱοί σου μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ἐξῆλθε δὲ Μωυσῆς εἰς συνάντησιν τῷ γαμβρῷ, καὶ προσεκύνησεν αὐτῷ, καὶ ἐφίλησεν αυτὸν, καὶ ἠσπάσαντο ἀλλήλους, καὶ εἰσήγαγεν αὐτοὺς εἰς τὴν σκηνήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Καὶ διηγήσατο Μωυσῆς τῷ γαμβρῷ πάντα ὅσα ἐποίησε Κύριος τῷ Φαραῷ καὶ πᾶσι τοῖς Αἰγυπτίοις ἕνεκεν τοῦ Ἰσραήλ, καὶ πάντα τὸν μόχθον τὸν γενόμενον αὐτοῖς ἐν τῇ ὁδῷ, καὶ ὅτι ἐξείλατο αὐτοὺς Κύριος ἐκ χειρὸς Φαραὼ, καὶ ἐκ χειρὸς τῶν Αἰγυπτίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ἐξέστη δὲ Ἰοθὸρ ἐπὶ πᾶσι τοῖς ἀγαθοῖς οἷς ἐποίησεν αὐτοῖς Κύριος, ὅτι ἐξείλατο αὐτοὺς ἐκ χειρὸς Αἰγυπτίων καὶ ἐκ χειρὸς Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Καὶ εἶπεν Ἰοθὸρ, εὐλογητὸς Κύριος, ὅτι ἐξείλατο αὐτοὺς ἐκ χειρὸς Αἰγυπτίων καὶ ἐκ χειρὸς Φαραώ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Νῦν ἔγνων ὅτι μέγας Κύριος παρὰ πάντας τοὺς θεούς ἕνεκεν τούτου, ὅτι ἐπέθεντο αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Καὶ ἔλαβεν Ἰοθὸρ ὁ γαμβρὸς Μωυσῆ ὁλοκαυτώματα καὶ θυσίας τῷ Θεῷ· παρεγένετο δὲ Ἀαρὼν καὶ πάντες οἱ πρεσβύτεροι Ἰσραὴλ συμφαγεῖν ἄρτον μετὰ τοῦ γαμβροῦ Μωυσῆ, ἐναντίον τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Καὶ ἐγένετο μετὰ τὴν ἐπαύριον συνεκάθισε Μωυσῆς κρίνειν τὸν λαόν· παρειστήκει δὲ πᾶς ὁ λαὸς Μωυσῇ ἀπὸ πρωΐθεν ἕως δείλης. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Καὶ ἰδὼν Ἰοθὸρ πάντα ὅσα ποιεῖ τῷ λαῷ, λέγει, τί τοῦτο ὃ σὺ ποιεῖς τῷ λαῷ; διατί σὺ κάθησαι μόνος, πᾶς δὲ ὁ λαὸς παρέστηκέ σοι ἀπὸ πρωΐθεν ἕως δείλης; ");
INSERT INTO grcbrent_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Καὶ λέγει Μωυσῆς τῷ γαμβρῶ, Ὅτι παραγίνεται πρός με ὁ λαὸς ἐκζητῆσαι κρίσιν παρὰ τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ὅταν γὰρ γένηται αὐτοῖς ἀντιλογία, καὶ ἔλθωσι πρός με, διακρίνω ἕκαστον, καὶ συμβιβάζω αὐτοὺς τὰ προστάγματα τοῦ Θεοῦ καὶ τὸν νόμον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Εἶπε δὲ ὁ γαμβρὸς Μωυσῆ πρὸς αὐτὸν, οὐκ ὀρθῶς σὺ ποιεῖς τὸ ῥῆμα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Φθορᾷ καταφθαρήσῃ ἀνυπομονήτῳ καὶ σὺ, καὶ πᾶς ὁ λαὸς οὗτος, ὅς ἐστι μετὰ σοῦ· βαρύ σοι τὸ ῥῆμα τοῦτο· οὐ δυνήσῃ ποιεῖν σὺ μόνος. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Νῦν οὖν ἄκουσόν μου, καὶ συμβουλεύσω σοι, καὶ ἔσται ὁ Θεὸς μετὰ σοῦ· γίνου σὺ τῷ λαῷ τὰ πρὸς τὸν Θεὸν, καὶ ἀνοίσεις τοὺς λόγους αὐτῶν πρὸς τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Καὶ διαμαρτύρῇ αὐτοῖς τὰ προστάγματα τοῦ Θεοῦ καὶ τὸν νόμον αὐτοῦ, καὶ σημανεῖς αὐτοῖς τὰς ὁδοὺς ἐν αἷς πορεύσονται ἐν αὐταῖς, καὶ τὰ ἔργα ἃ ποιήσουσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Καὶ σὺ σεαυτῷ σκέψαι ἀπὸ παντὸς τοῦ λαοῦ ἄνδρας δυνατοὺς, θεοσεβεῖς, ἄνδρας δικαίους, μισοῦντας ὑπερηφανίαν, καὶ καταστήσεις ἐπʼ αὐτῶν χιλιάρχους καὶ ἑκατοντάρχους καὶ πεντηκοντάρχους καὶ δεκαδάρχους. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Καὶ κρινοῦσι τὸν λαὸν πᾶσαν ὥραν· τὸ δὲ ῥῆμα τὸ ὑπέρογκον ἀνοίσουσιν ἐπὶ σὲ· τὰ δὲ βραχέα τῶν κριμάτων κρινοῦσιν αὐτοί· καὶ κουφιοῦσιν ἀπὸ σοῦ, καὶ συναντιλήψονταί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ἐὰν τὸ ῥῆμα τοῦτο ποιήσῃς, κατισχύσει σε ὁ Θεὸς, καὶ δυνήσῃ παραστῆναι, καὶ πᾶς ὁ λαὸς οὗτος εἰς τὸν ἑαυτοῦ τόπον μετʼ εἰρήνης ἥξει. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ἤκουσε δὲ Μωυσῆς τῆς φωνῆς τοῦ γαμβροῦ, καὶ ἐποίησεν ὅσα εἶπεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Καὶ ἐπέλεξε Μωυσῆς ἄνδρας δυνατοὺς ἀπὸ παντὸς Ἰσραὴλ, καὶ ἐποίησεν αὐτοὺς ἐπʼ αὐτῶν χιλιάρχους καὶ ἑκατοντάρχους καὶ πεντηκοντάρχους καὶ δεκαδάρχους. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Καὶ ἐκρίνοσαν τὸν λαὸν πᾶσαν ὥραν· πᾶν δὲ ῥῆμα ὑπέρογκον ἀνεφέροσαν ἐπὶ Μωυσῆν· πᾶν δὲ ῥῆμα ἐλαφρὸν ἐκρίνοσαν αὐτοί. ");
INSERT INTO grcbrent_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ἐξαπέστειλε δὲ Μωυσῆς τὸν ἑαυτοῦ γαμβρὸν, καὶ ἀπῆλθεν εἰς τὴν γῆν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Τοῦ δὲ μηνὸς τοῦ τρίτου τῆς ἐξόδου τῶν υἱῶν Ἰσραὴλ ἐκ γῆς Αἰγύπτου τῇ ἡμέρᾳ ταύτῃ, ἤλθοσαν εἰς τὴν ἔρημον τοῦ Σινά. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Καὶ ἀπῆραν ἐκ Ῥαφιδεὶν, καὶ ἤλθοσαν εἰς τὴν ἔρημον τοῦ Σινὰ, καὶ παρενέβαλεν ἐκεῖ Ἰσραὴλ κατέναντι τοῦ ὄρους. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Καὶ Μωυσῆς ἀνέβη εἰς τὸ ὄρος τοῦ Θεοῦ· καὶ ἐκάλεσεν αὐτὸν ὁ Θεὸς ἐκ τοῦ ὄρους, λέγων, τάδε ἐρεῖς τῷ οἴκῳ Ἰακὼβ, καὶ ἀναγγελεῖς τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Αὐτοὶ ἑωράκατε ὅσα πεποίηκα τοῖς Αἱγυπτίοις, καὶ ἀνέλαβον ὑμᾶς ὡσεὶ ἐπὶ πτερύγων ἀετῶν, καὶ προσηγαγόμην ὑμᾶς πρὸς ἐμαυτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Καὶ νῦν ἐὰν ἀκοῇ ἀκούσητε τῆς ἐμῆς φωνῆς, καὶ φυλάξητε τὴν διαθήκην μου, ἔσεσθέ μοι λαὸς περιούσιος ἀπὸ πάντων τῶν ἐθνῶν· ἐμὴ γάρ ἐστι πᾶσα ἡ γῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ὑμεῖς δὲ ἔσεσθέ μοι βασίλειον ἱεράτευμα καὶ ἔθνος ἅγιον· ταῦτα τὰ ῥήματα ἐρεῖς τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ἦλθε δὲ Μωυσῆς, καὶ ἐκάλεσεν τοὺς πρεσβυτέρους τοῦ λαοῦ· καὶ παρέθηκεν αὐτοῖς πάντας τοὺς λόγους τούτους, οὓς συνέταξεν αὐτοῖς ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ἀπεκρίθη δὲ πᾶς ὁ λαὸς ὁμοθυμαδὸν, καὶ εἶπαν, πάντα ὅσα εἶπεν ὁ Θεὸς, ποιήσομεν καὶ ἀκουσόμεθα· ἀνήνεγκε δὲ Μωυσῆς τοὺς λόγους τούτους πρὸς τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, ἰδοὺ ἐγὼ παραγίνομαι πρὸς σὲ ἐν στύλῳ νεφέλης, ἵνα ἀκούσῃ ὁ λαὸς λαλοῦντός μου πρὸς σὲ, καὶ σοὶ πιστεύσωσιν εἰς τὸν αἰῶνα· ἀνήγγειλε δὲ Μωυσῆς τὰ ῥήματα τοῦ λαοῦ πρὸς Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, Καταβὰς διαμάρτυραι τῷ λαῷ, καὶ ἅγνισον αὐτοὺς σήμερον καὶ αὔριον, καὶ πλυνάτωσαν τὰ ἱμάτια, ");
INSERT INTO grcbrent_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","καὶ ἔστωσαν ἕτοιμοι εἰς τὴν ἡμέραν τὴν τρίτην· τῇ γὰρ ἡμέρᾳ τῇ τρίτῃ καταβήσεται Κύριος ἐπὶ τὸ ὄρος τὸ Σινὰ, ἐναντίον παντὸς τοῦ λαοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Καὶ ἀφοριεῖς τὸν λαὸν κύκλῳ, λέγων, προσέχετε ἑαυτοῖς τοῦ ἀναβῆναι εἰς τὸ ὄρος, καὶ θίγειν τι αὐτοῦ· πᾶς ὁ ἁψάμενος τοῦ ὄρους, θανάτῳ τελευτήσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Οὐχ ἅψεται αὐτοῦ χείρ· ἐν γὰρ λίθοις λιθοβοληθήσεται, ἢ βολίδι κατατοξευθήσεται· ἐάν τε κτῆνος ἐάν τε ἄνθρωπος, οὐ ζήσεται· ὅταν αἱ φωναὶ καὶ αἱ σάλπιγγες καὶ ἡ νεφέλη ἀπέλθῃ ἀπὸ τοῦ ὄρους, ἐκεῖνοι ἀναβήσονται ἐπὶ τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Κατέβη δὲ Μωυσῆς ἐκ τοῦ ὄρους πρὸς τὸν λαὸν, καὶ ἡγίασεν αὐτούς· καὶ ἔπλυναν τὰ ἱμάτια. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Καὶ εἶπε τῷ λαῷ, γίνεσθε ἕτοιμοι, τρεῖς ἡμέρας μὴ προσέλθητε γυναικί. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ἐγένετο δὲ τῇ ἡμέρᾳ τῇ τρίτῃ γενηθέντος πρὸς ὄρθρον, καὶ ἐγένοντο φωναὶ καὶ ἀστραπαὶ καὶ νεφέλη γνοφώδης ἐπʼ ὄρους Σινά· φωνὴ τῆς σάλπιγγος ἤχει μέγα· καὶ ἐπτοήθη πᾶς ὁ λαὸς ὁ ἐν τῇ παρεμβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Καὶ ἐξήγαγε Μωυσῆς τὸν λαὸν εἰς συνάντησιν τοῦ Θεοῦ ἐκ τῆς παρεμβολῆς· καὶ παρέστησαν ὑπὸ τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Τὸ ὄρος τὸ Σινὰ ἐκαπνίζετο ὅλον, διὰ τὸ καταβεβηκέναι ἐπʼ αὐτὸ τὸν Θεὸν ἐν πυρί· καὶ ἀνέβαινεν ὁ καπνὸς, ὡσεὶ καπνὸς καμίνου· καὶ ἐξέστη πᾶς ὁ λαὸς σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ἐγίνοντο δὲ αἱ φωναὶ τῆς σάλπιγγος προβαίνουσαι ἰσχυρότεραι σφόδρα. Μωυσῆς ἐλάλησεν, ὁ δὲ Θεὸς ἀπεκρίνατο αὐτῷ φωνῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Κατέβη δὲ Κύριος ἐπὶ τὸ ὄρος τὸ Σινὰ ἐπὶ τὴν κορυφὴν τοῦ ὄρους· καὶ ἐκάλεσε Κύριος Μωυσῆν ἐπὶ τὴν κορυφὴν τοῦ ὄρους· καὶ ἀνέβη Μωυσῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Καὶ εἶπεν ὁ Θεὸς πρὸς Μωυσῆν, λέγων, καταβὰς διαμάρτυραι τῷ λαῷ, μή ποτε ἐγγίσωσι πρὸς τὸν Θεὸν κατανοῆσαι, καὶ πέσωσιν ἐξ αὐτῶν πλῆθος· ");
INSERT INTO grcbrent_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Καὶ οἱ ἱερεῖς οἱ ἐγγίζοντες Κυρίῳ τῷ Θεῷ ἁγιασθήτωσαν, μήποτε ἀπαλλάξῃ ἀπʼ αὐτῶν Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Καὶ εἶπε Μωυσῆς πρὸς τὸν Θεὸν, οὐ δυνήσεται ὁ λαὸς προσαναβῆναι πρὸς τὸ ὄρος τὸ Σινά· σὺ γὰρ διαμεμαρτύρησαι ἡμῖν, λέγων, ἀφόρισαι τὸ ὄρος, καὶ ἁγίασαι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Εἴπε δὲ αὐτῷ Κύριος, βάδιζε, κατάβηθι, καὶ ἀνάβηθι σὺ καὶ Ἀαρὼν μετὰ σοῦ· οἱ δὲ ἱερεῖς καὶ ὁ λαὸς μὴ βιαζέσθωσαν ἀναβῆναι πρὸς τὸν Θεὸν, μὴ ποτε ἀπολέσῃ ἀπʼ αὐτῶν Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Κατέβη δὲ Μωυσῆς πρὸς τὸν λαὸν, καὶ εἶπεν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Καὶ ἐλάλησε Κύριος πάντας τοὺς λόγους τούτους, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","ἐγώ εἰμι Κύριος ὁ Θεός σου, ὅστις ἐξήγαγόν σε ἐκ γῆς Αἰγύπτου, ἐξ οἴκου δουλείας. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Οὐκ ἔσονταί σοι θεοὶ ἕτεροι πλὴν ἐμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Οὐ ποιήσεις σεαυτῷ εἴδωλον, οὐδὲ παντὸς ὁμοίωμα, ὅσα ἐν τῷ οὐρανῷ ἄνω, καὶ ὅσα ἐν τῇ γῇ κάτω, καὶ ὅσα ἐν τοῖς ὕδασιν ὑποκάτω τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Οὐ προσκυνήσεις αὐτοῖς, οὐδὲ μὴ λατρεύσεις αὐτοῖς· ἐγὼ γάρ εἰμι Κύριος ὁ Θεός σου, Θεὸς ζηλωτὴς, ἀποδιδοὺς ἁμαρτίας πατέρων ἐπὶ τέκνα, ἕως τρίτης καὶ τετάρτης γενεᾶς τοῖς μισοῦσί με, ");
INSERT INTO grcbrent_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","καὶ ποιῶν ἔλεος εἰς χιλιάδας τοῖς ἀγαπῶσί με, καὶ τοῖς φυλάσσουσι τὰ προστάγματά μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Οὐ λήψῃ τὸ ὄνομα Κυρίου τοῦ Θεοῦ σου ἐπὶ ματαίῳ· οὐ γὰρ μὴ καθαρίσῃ Κύριος ὁ Θεός σου τὸν λαμβάνοντα τὸ ὄνομα αὐτοῦ ἐπὶ ματαίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Μνήσθητι τὴν ἡμέραν τῶν σαββάτων ἁγιάζειν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ἓξ ἡμέρας ἐργᾷ, καὶ ποιήσεις πάντα τὰ ἔργα σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ, σάββατα Κυρίῳ τῷ Θεῷ σου· οὐ ποιήσεις ἐν αὐτῇ πᾶν ἔργον σὺ, καὶ ὁ υἱός σου, καὶ ἡ θυγάτηρ σου, ὁ παῖς σου, καὶ ἡ παιδίσκη σου, ὁ βοῦς σου, καὶ τὸ ὑποζύγιόν σου, καὶ πᾶν κτῆνός σου, καὶ ὁ προσήλυτος ὁ παροικῶν ἐν σοί. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ἐν γὰρ ἓξ ἡμέραις ἐποίησε Κύριος τὸν οὐρανὸν καὶ τὴν γῆν καὶ τὴν θὰλασσαν καὶ πάντα τὰ ἐν αὐτοῖς, καὶ κατέπαυσε τῇ ἡμέρᾳ τῇ ἑβδόμῃ· διὰ τοῦτο εὐλόγησε Κύριος τὴν ἡμέραν τὴν ἑβδόμην, καὶ ἡγίασεν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Τίμα τὸν πατέρα σου, καὶ τὴν μητέρα σου, ἵνα εὖ σοι γένηται, καὶ ἵνα μακροχρόνιος γένῃ ἐπὶ τῆς γῆς τῆς ἀγαθῆς, ἧς Κύριος ὁ Θεός σου δίδωσί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Οὐ μοιχεύσεις. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Οὐ κλέψεις. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Οὐ φονεύσεις. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Οὐ ψευδομαρτυρήσεις κατὰ τοῦ πλησίον σου μαρτυρίαν ψευδῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Οὐκ ἐπιθυμήσεις τὴν γυναῖκα τοῦ πλησίον σου· οὐκ ἐπιθυμήσεις τὴν οἰκίαν τοῦ πλησίον σου, οὔτε τὸν ἀγρὸν αὐτοῦ, οὔτε τὸν παῖδα αὐτοῦ, οὔτε τὴν παιδίσκην αὐτοῦ, οὔτε τοῦ βοὸς αὐτοῦ, οὔτε τοῦ ὑποζυγίου αὐτοῦ, οὔτε παντὸς κτήνους αὐτοῦ, οὔτε ὅσα τῷ πλησίον σου ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Καὶ πᾶς ὁ λαὸς ἑώρα τὴν φωνὴν, καὶ τὰς λαμπάδας, καὶ τὴν φωνὴν τῆς σάλπιγγος, καὶ τὸ ὄρος τὸ καπνίζον· φοβηθέντες δὲ πᾶς ὁ λαὸς ἔστησαν μακρόθεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Καὶ εἶπαν πρὸς Μωυσῆν, λάλησον σὺ ἡμῖν, καὶ μὴ λαλείτω πρὸς ἡμᾶς ὁ Θεὸς, μὴ ἀποθάνωμεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Καὶ λέγει αὐτοῖς Μωυσῆς, θαρσεῖτε· ἕνεκεν γὰρ τοῦ πειράσαι ὑμᾶς παρεγενήθη ὁ Θεὸς πρὸς ὑμᾶς, ὅπως ἂν γένηται ὁ φόβος αὐτοῦ ἐν ὑμῖν, ἵνα μὴ ἁμαρτάνητε. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Εἱστήκει δὲ ὁ λαὸς μακρόθεν, Μωυσῆς δὲ εἰσῆλθεν εἰς τὸν γνόφον, οὗ ἦν ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Εἶπε δὲ Κύριος πρὸς Μωυσῆν, τάδε ἐρεῖς τῷ οἴκῳ Ἰακὼβ, καὶ ἀναγγελεῖς τοῖς υἱοῖς Ἰσραήλ· ὑμεῖς ἑωράκατε, ὅτι ἐκ τοῦ οὐρανοῦ λελάληκα πρὸς ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Οὐ ποιήσετε ὑμῖν αὐτοῖς θεοὺς ἀργυροῦς, καὶ θεοὺς χρυσοῦς οὐ ποιήσετε ὑμῖν αὑτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Θυσιαστήριον ἐκ γῆς ποιήσετέ μοι, καὶ θύσετε ἐπʼ αὐτοῦ τὰ ὁλοκαυτώματα ὑμῶν, καὶ τὰ σωτήρια ὑμῶν, καὶ τὰ πρόβατα, καὶ τοὺς μόσχους ὑμῶν ἐν παντὶ τόπῳ, οὗ ἐὰν ἐπονομάσω τὸ ὄνομά μου ἐκεῖ, καὶ ἥξω πρὸς σὲ, καὶ εὐλογήσω σε. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ἐὰν δὲ θυσιαστήριον ἐκ λίθων ποιῇς μοι, οὐκ οἰκοδομήσεις αὐτοὺς τμητούς· τὸ γὰρ ἐγχειρίδιόν σου ἐπιβέβληκας ἐπʼ αὐτοὺς, καὶ μεμίανται. ");
INSERT INTO grcbrent_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Οὐκ ἀναβήσῃ ἐν ἀναβαθμίσιν ἐπὶ τὸ θυσιαστήριόν μου, ὅπως ἂν μὴ ἀποκαλύψῃς τὴν ἀσχημοσύνην σου ἐπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Καὶ ταῦτα τὰ δικαιώματα, ἃ παραθήσῃ ἐνώπιον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ἐὰν κτήσῃ παῖδα Ἐβραῖον, ἓξ ἔτη δουλεύσει σοι· τῷ δὲ ἑβδόμῳ ἔτει ἀπελεύσεται ἐλεύθερος δωρεάν. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ἐὰν αὐτὸς μόνος εἰσέλθῃ, καὶ μόνος ἐξελεύσεται· ἐὰν δὲ γυνὴ συνεισέλθῃ μετʼ αὐτοῦ, ἐξελεύσεται καὶ ἡ γυνὴ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Καὶ ἐὰν δὲ ὁ κύριος δῷ αὐτῷ γυναῖκα, καὶ τέκῃ αὐτῷ υἱοὺς ἢ θυγατέρας, ἡ γυνὴ καὶ τὰ παιδία ἔσται τῷ κυρίῳ αὐτοῦ, αὐτὸς δὲ μόνος ἐξελεύσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ἐὰν δὲ ἀποκριθεὶς εἴπῃ ὁ παῖς, ἠγάπηκα τὸν κύριόν μου, καὶ τὴν γυναῖκα, καὶ τὰ παιδία, οὐκ ἀποτρέχω ἐλεύθερος· ");
INSERT INTO grcbrent_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","προσάξει αὐτὸν ὁ κύριος αὐτοῦ πρὸς τὸ κριτήριον τοῦ Θεοῦ, καὶ τότε προσάξει αὐτὸν ἐπὶ τὴν θύραν ἐπὶ τὸν σταθμὸν, καὶ τρυπήσει ὁ κύριος αὐτοῦ τὸ οὖς τῷ ὀπητίῳ, καὶ δουλεύσει αὐτῷ εἰς τὸν αἰῶνα. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ἐὰν δέ τις ἀποδῶται τὴν ἑαυτοῦ θυγατέρα οἰκέτιν, οὐκ ἀπελεύσεται, ὥσπερ ἀποτρέχουσιν αἱ δοῦλαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ἐὰν μὴ εὐαρεστήσῃ τῷ κυρίῳ αὐτῆς, ἣ αὐτῷ καθωμολογήσατο, ἀπολυτρώσει αὐτήν· ἔθνει δὲ ἀλλοτρίῳ οὐ κύριός ἐστι πωλεῖν αὐτὴν, ὅτι ἠθέτησεν ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ἐὰν δὲ τῷ υἱῷ καθομολογήσηται αὐτὴν, κατὰ τὸ δικαίωμα τῶν θυγατέρων ποιήσει αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ἐὰν δὲ ἄλλην λάβῃ ἑαυτῷ, τὰ δέοντα καὶ τὸν ἱματισμὸν καὶ τὴν ὁμιλίαν αὐτῆς οὐκ ἀποστερήσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ἐὰν δὲ τὰ τρία ταῦτα μὴ ποιήσῃ αὐτῇ, ἐξελεύσεται δωρεὰν ἄνευ ἀργυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ἐὰν δὲ πατάξῃ τις τινὰ, καὶ ἀποθάνῃ, θανάτῳ θανατούσθω. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ὁ δὲ οὐχ ἑκὼν, ἀλλὰ ὁ Θεὸς παρέδωκεν εἰς τὰς χεῖρας αὐτοῦ, δώσω σοι τόπον οὗ φεύξεται ἐκεῖ ὁ φονεύσας. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ἐὰν δέ τις ἐπιθῆται τῷ πλησίον ἀποκτεῖναι αὐτὸν δόλῳ, καὶ καταφύγῃ, ἀπὸ τοῦ θυσιαστηρίου μου λήψῃ αὐτὸν θανατῶσαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ὃς τύπτει πατέρα αὐτοῦ ἢ μητέρα αὐτοῦ, θανάτῳ θανατούσθω. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ὁ κακολογῶν πατέρα αὐτοῦ ἢ μητέρα αὐτοῦ, τελευτήσει θανάτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ὃς ἐὰν κλέψῃ τις τινὰ τῶν υἱῶν Ἰσραὴλ, καὶ καταδυναστεύσας αὐτὸν ἀποδῶται, καὶ εὑρεθῇ ἐν αὐτῷ, θανάτῳ τελευτάτω. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Ἐὰν δὲ λοιδορῶνται δύο ἄνδρες, καὶ πατάξωσι τὸν πλησίον λίθῳ ἢ πυγμῇ, καὶ μὴ ἀποθάνῃ, κατακλιθῇ δὲ ἐπὶ τὴν κοίτην, ");
INSERT INTO grcbrent_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ἐὰν ἐξαναστὰς ὁ ἄνθρωπος περιπατήσῃ ἔξω ἐπὶ ῥάβδου, ἀθῶος ἔσται ὁ πατάξας· πλὴν τῆς ἀργείας αὐτοῦ ἀποτίσει, καὶ τὰ ἰατρεῖα. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ἐὰν δέ τις πατάξῃ τὸν παῖδα αὐτοῦ ἢ τὴν παιδίσκην αὐτοῦ ἐν ῥάβδῳ, καὶ ἀποθάνῃ ὑπὸ τὰς χεῖρας αὐτοῦ, δίκῃ ἐκδικηθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ἐὰν δὲ διαβιώσῃ ἡμέραν μίαν ἢ δύο, οὐκ ἐκδικηθήτω· τὸ γὰρ ἀργύριον αὐτοῦ ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ἐὰν δὲ μάχωνται δύο ἄνδρες, καὶ πατάξωσι γυναῖκα ἐν γαστρὶ ἔχουσαν, καὶ ἐξέλθῃ τὸ παιδίον αὐτῆς μὴ ἐξεικονισμένον, ἐπιζήμιον ζημιωθήσεται· καθότι ἂν ἐπιβάλῃ ὁ ἀνὴρ τῆς γυναικὸς, δώσει μετὰ ἀξιώματος. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ἐὰν δὲ ἐξεικονισμένον ᾖ, δώσει ψυχὴν ἀντὶ ψυχῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ὀφθαλμὸν ἀντὶ ὀφθαλμοῦ, ὀδόντα ἀντὶ ὀδόντος, χεῖρα ἀντὶ χειρὸς, πόδα ἀντὶ ποδὸς, ");
INSERT INTO grcbrent_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","κατάκαυμα ἀντὶ κατακαύματος, τραῦμα ἀντὶ τραύματος, μώλωπα ἀντὶ μώλωπος. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ἐὰν δέ τις πατάξῃ τὸν ὀφθαλμὸν τοῦ οἰκέτου αὐτοῦ, ἢ τὸν ὀφθαλμὸν τῆς θεραπαίνης αὐτοῦ, καὶ ἐκτυφλώσῃ, ἐλευθέρους ἐξαποστελεῖ αὐτοὺς ἀντὶ τοῦ ὀφθαλμοῦ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ἐὰν δὲ τὸν ὀδόντα τοῦ οἰκέτου, ἢ τὸν ὀδόντα τῆς θεραπαίνης αὐτοῦ ἐκκόψῃ, ἐλευθέρους ἐξαποστελεῖ αὐτοὺς ἀντὶ τοῦ ὀδόντος αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ἐὰν δὲ κερατίσῃ ταῦρος ἄνδρα ἢ γυναῖκα καὶ ἀποθάνῃ, λίθοις λιθοβοληθήσεται ὁ ταῦρος, καὶ οὐ βρωθήσεται τὰ κρέα αὐτοῦ· ὁ δὲ κύριος τοῦ ταύρου ἀθῶος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ἐὰν δὲ ὁ ταῦρος κερατιστὴς ᾖ πρὸ τῆς χθὲς καὶ πρὸ τῆς τρίτης, καὶ διαμαρτύρωνται τῷ κυρίῳ αὐτοῦ, καὶ μὴ ἀφανίσῃ αὐτὸν, ἀνέλῃ δὲ ἄνδρα ἢ γυναῖκα, ὁ ταῦρος λιθοβοληθήσεται, καὶ ὁ κύριος αὐτοῦ προσαποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ἐὰν δὲ λύτρα ἐπιβληθῇ αὐτῷ, δώσει λύτρα τῆς ψυχῆς αὐτοῦ ὅσα ἐὰν ἐπιβάλωσιν αὐτῶ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ἐὰν δὲ υἱὸν ἢ θυγατέρα κερατίσῃ, κατὰ τὸ δικαίωμα τοῦτο ποιήσωσιν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ἐὰν δὲ παῖδα κερατίσῃ ὁ ταῦρος ἢ παιδίσκην, ἀργυρίου τριάκοντα δίδραχμα δώσει τῷ κυρίῳ αὐτῶν, καὶ ὁ ταῦρος λιθοβοληθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ἐὰν δέ τις ἀνοίξῃ λάκκον ἢ λατομήσῃ λάκκον, καὶ μὴ καλύψῃ αὐτὸν, καὶ ἐμπέσῃ ἐκεῖ μόσχος ἢ ὄνος, ");
INSERT INTO grcbrent_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ὁ κύριος τοῦ λάκκου ἀποτίσει, ἀργύριον δώσει τῷ κυρίῳ αὐτῶν· τὸ δὲ τετελευτηκὸς αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ἐὰν δὲ κερατίσῃ τινὸς ταῦρος τόν ταῦρον τοῦ πλησίον, καὶ τελευτήσῃ, ἀποδώσονται τὸν ταῦρον τὸν ζῶντα, καὶ διελοῦνται τὸ ἀργύριον αὐτοῦ, καὶ τὸν ταῦρον τὸν τεθνηκότα διελοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ἐὰν δὲ γνωρίζηται ὁ ταῦρος ὅτι κερατιστής ἐστι πρὸ τῆς χθὲς καὶ πρὸ τῆς τρίτης ἡμέρας, καὶ διαμεμαρτυρημένοι ὦσι τῷ κυρίῳ αὐτοῦ· καὶ μὴ ἀφανίσῃ αὐτὸν, ἀποτίσει ταῦρον ἀντὶ ταύρου, ὁ δὲ τετελευτηκὼς αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Ἐὰν δέ τις κλέψῃ μόσχον ἢ πρόβατον, καὶ σφάξῃ ἢ ἀποδῶται, πέντε μόσχους ἀποτίσει ἀντὶ τοῦ μόσχου, καὶ τέσσερα πρόβατα ἀντὶ τοῦ προβάτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ἐὰν δὲ ἐν τῷ διορύγματι εὑρεθῇ ὁ κλέπτης, καὶ πληγεὶς ἀποθάνῃ, οὐκ ἔστιν αὐτῷ φόνος. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ἐὰν δὲ ἀνατείλῃ ὁ ἥλιος ἐπʼ αὐτῷ, ἔνοχός ἐστιν, ἀνταποθανεῖται· ἐὰν δὲ μὴ ὑπάρχῃ αὐτῷ, πραθήτω ἀντὶ τοῦ κλέμματος. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ἐὰν δὲ καταλειφθῇ καὶ εὑρεθῇ ἐν τῇ χειρὶ αὐτοῦ τὸ κλέμμα ἀπό τε ὄνου ἕως προβάτου ζῶντα, διπλᾶ αὐτὰ ἀποτίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ἐὰν δὲ καταβοσκήσῃ τις ἀγρὸν ἢ ἀμπελῶνα, καὶ ἀφῇ τὸ κτῆνος αὐτοῦ καταβοσκῆσαι ἀγρὸν ἕτερον, ἀποτίσει ἐκ τοῦ ἀγροῦ αὐτοῦ κατὰ τὸ γέννημα αὐτοῦ· ἐὰν δὲ πάντα τὸν ἀγρὸν καταβοσκήσῃ, τὰ βέλτιστα τοῦ ἀγροῦ αὐτοῦ καὶ τὰ βέλτιστα τοῦ ἀμπελῶνος αὐτοῦ ἀποτίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ἐὰν δὲ ἐξελθὸν πῦρ εὕρῃ ἀκάνθας, καὶ προσεμπρήσῃ ἅλωνας ἢ στάχυς ἢ πεδίον, ἀποτίσει ὁ τὸ πῦρ ἐκκαύσας. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ἐὰν δέ τις δῷ τῷ πλησίον ἀργύριον ἢ σκεύη φυλάξαι, καὶ κλαπῇ ἐκ τῆς οἰκίας τοῦ ἀνθρώπου, ἐὰν εὑρεθῇ ὁ κλέψας, ἀποτίσει τὸ διπλοῦν. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ἐὰν δὲ μὴ εὑρεθῇ ὁ κλέψας, προσελεύσεται ὁ κύριος τῆς οἰκίας ἐνώπιον τοῦ Θεοῦ, καὶ ὀμεῖται ἦ μὴν μὴ αὐτὸν πεπονηρεῦσθαι ἐφʼ ὅλης τῆς παρακαταθήκης τοῦ πλησίον, ");
INSERT INTO grcbrent_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","κατὰ πᾶν ῥητὸν ἀδίκημα, περί τε μόσχου, καὶ ὑποζυγίου, καὶ προβάτου, καὶ ἱματίου, καὶ πάσης ἀπωλίας τῆς ἐνκαλουμένης· ὅ, τι οὖν ἂν ᾖ, ἐνώπιον τοῦ Θεοῦ ἐλεύσεται ἡ κρίσις ἀμφοτέρων, καὶ ὁ ἁλοὺς διὰ τοῦ Θεοῦ, ἀποτίσει διπλοῦν τῷ πλησίον. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ἐὰν δέ τις δῷ τῷ πλησίον ὑποζύγιον ἢ μόσχον ἢ πρόβατον ἢ πᾶν κτῆνος φυλάξαι, καὶ συντριβῇ ἢ τελευτήσῃ ἢ αἰχμάλωτον γένηται, καὶ μηδεὶς γνῷ, ");
INSERT INTO grcbrent_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ὅρκος ἔσται τοῦ Θεοῦ ἀνὰ μέσον ἀμφοτέρων, ἦ μὴν μὴ αὐτὸν πεπονηρεῦσθαι καθόλου τῆς παρακαταθήκης τοῦ πλησίον· καὶ οὕτως προσδέξεται ὁ κύριος αὐτοῦ, καὶ οὐκ ἀποτίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ἐὰν δὲ κλαπῇ παρʼ αὐτοῦ, ἀποτίσει τῷ κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ἐὰν δὲ θηριάλωτον γένηται, ἄξει αὐτὸν ἐπὶ τὴν θήραν, καὶ οὐκ ἀποτίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ἐὰν δὲ αἰτήσῃ τις παρὰ τοῦ πλησίον, καὶ συντριβῇ ἢ ἀποθάνῃ ἢ αἰχμάλωτον γένηται, ὁ δὲ κύριος μὴ ᾖ μετʼ αὐτοῦ, ἀποτίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ἐὰν δὲ ὁ κύριος ᾖ μετʼ αὐτοῦ, οὐκ ἀποτίσει· ἐὰν δὲ μισθωτὸς ᾖ, ἔσται αὐτῷ ἀντὶ τοῦ μισθοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ἐὰν δὲ ἀπατήσῃ τις παρθένον ἀμνήστευτον, καὶ κοιμηθῇ μετʼ αὐτῆς, φερνῇ φερνιεῖ αὐτὴν αὐτῷ γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ἐὰν δὲ ἀνανεύων ἀνανεύσῃ, καὶ μὴ βούληται ὁ πατὴρ αὐτῆς δοῦναι αὐτὴν αὐτῷ γυναῖκα, ἀργύριον ἀποτίσει τῷ πατρὶ καθʼ ὅσον ἐστὶν ἡ φερνὴ τῶν παρθένων. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Φαρμακοὺς οὐ περιποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Πᾶν κοιμώμενον μετὰ κτήνους θανάτῳ ἀποκτενεῖτε αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ὁ θυσιάζων θεοῖς θανάτῳ ἐξολοθρευθήσεται, πλὴν Κυρίῳ μόνῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Καὶ προσήλυτον οὐ κακώσετε, οὐδὲ μὴ θλίψητε αὐτόν· ἦτε γάρ προσήλυτοι ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Πᾶσαν χήραν καὶ ὀρφανὸν οὐ κακώσετε. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ἐὰν δὲ κακίᾳ κακώσητε αὐτοὺς, καὶ κεκράξαντες καταβοήσωσι πρός με, ἀκοῇ εἰσακούσομαι τῆς φωνῆς αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","καὶ ὀργισθήσομαι θυμῷ, καὶ ἀποκτενῶ ὑμᾶς μαχαίρᾳ, καὶ ἔσονται αἱ γυναῖκες ὑμῶν χῆραι, καὶ τὰ παιδία ὑμῶν ὀρφανά. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ἐὰν δὲ ἀργύριον ἐκδανείσῃς τῷ ἀδελφῷ τῷ πενιχρῷ παρὰ σοὶ, οὐκ ἔσῃ αὐτὸν κατεπείγων, οὐκ ἐπιθήσεις αὐτῷ τόκον. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ἐὰν δὲ ἐνεχύρασμα ἐνεχυράσῃς τὸ ἱμάτιον τοῦ πλησίον, πρὸ δυσμῶν ἡλίου ἀποδώσεις αὐτῷ· ");
INSERT INTO grcbrent_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ἔστι γὰρ τοῦτο περιβόλαιον αὐτοῦ, μόνον τοῦτο τὸ ἱμάτιον ἀσχημοσύνης αὐτοῦ· ἐν τίνι κοιμηθήσεται; Ἐὰν οὖν καταβοήσῃ πρός μέ, εἰσακούσομαι αὐτοῦ· ἐλεήμων γάρ εἰμι. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Θεοὺς οὐ κακολογήσεις, καὶ ἄρχοντα τοῦ λαοῦ σου οὐ κακῶς ἐρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ἀπαρχὰς ἅλωνος καὶ ληνοῦ σου οὐ καθυστερήσεις· τὰ πρωτότοκα τῶν υἱῶν σου δώσεις ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Οὕτω ποιήσεις τὸν μόσχον σου καὶ τὸ πρόβατόν σου καὶ τὸ ὑποζύγιόν σου· ἑπτὰ ἡμέρας ἔσται ὑπὸ τὴν μητέρα, τῇ δὲ ὀγδόῃ ἡμέρᾳ ἀποδώσεις μοι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Καὶ ἄνδρες ἅγιοι ἔσεσθέ μοι· καὶ κρέας θηριάλωτον οὐκ ἔδεσθε, τῷ κυνὶ ἀποῤῥίψατε αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Οὐ παραδέξῃ ἀκοὴν ματαίαν· οὐ συγκαταθήσῃ μετὰ τοῦ ἀδίκου γενέσθαι μάρτυς ἄδικος. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Οὐκ ἔσῃ μετὰ πλειόνων ἐπὶ κακίᾳ· οὐ προστεθήσῃ μετὰ πλήθους ἐκκλῖναι μετὰ τῶν πλειόνων, ὥστε ἑκκλεῖσαι κρίσιν. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Καὶ πένητα οὐκ ἐλεήσεις ἐν κρίσει. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ἐὰν δὲ συναντήσῃς τῷ βοῒ τοῦ ἐχθροῦ σου, ἢ τῷ ὑποζυγίῳ αὐτοῦ πλανωμένοις, ἀποστρέψας ἀποδώσεις αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ἐὰν δὲ ἴδῃς τὸ ὑποζύγιον τοῦ ἐχθροῦ σου πεπτωκὸς ὑπὸ τὸν γόμον αὐτοῦ, οὐ παρελεύσῃ αὐτὸ, ἀλλὰ συναρεῖς αὐτὸ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Οὐ διαστρέψεις κρίμα πένητος ἐν κρίσει αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ἀπὸ παντὸς ῥήματος ἀδίκου ἀποστήσῃ· ἀθῷον καὶ δίκαιον οὐκ ἀποκτενεῖς· καὶ οὐ δικαιώσεις τὸν ἀσεβῆ ἕνεκεν δώρων. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Καὶ δῶρα οὐ λήψῃ· τὰ γὰρ δῶρα ἐκτυφλοῖ ὀφθαλμοὺς βλεπόντων, καὶ λυμαῖνεται ῥήματα δίκαια. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Καὶ προσήλυτον οὐ θλίψετε· ὑμεῖς γὰρ οἴδατε τὴν ψυχὴν τοῦ προσηλύτου· αὐτοὶ γὰρ προσήλυτοι ἦτε ἐν γῇ Αἰγύπτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ἓξ ἔτη σπερεῖς τὴν γῆν σου, καὶ συνάξεις τὰ γεννήματα αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Τῷ δὲ ἑβδόμῳ ἄφεσιν ποιήσεις, καὶ ἀνήσεις αὐτὴν, καὶ ἔδονται οἱ πτωχοὶ τοῦ ἔθνους σου· τὰ δὲ ὑπολειπόμενα ἔδεται τὰ ἄγρια θηρία· οὕτως ποιήσεις τὸν ἀμπελῶνά σου, καὶ τὸν ἐλαιῶνά σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ἓξ ἡμέρας ποιήσεις τὰ ἔργα σου, τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ, ἀνάπαυσις· ἵνα ἀναπαύσηται ὁ βοῦς σου, καὶ τὸ ὑποζύγιόν σου, καὶ ἵνα ἀναψύξῃ ὁ υἱὸς τῆς παιδίσκης σου καὶ ὁ προσήλυτος. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Πάντα ὅσα εἴρηκα πρὸς ὑμᾶς, φυλάξασθε· καὶ ὄνομα θεῶν ἑτέρων οὐκ ἀναμνησθήσεσθε, οὐδὲ μὴ ἀκουσθῇ ἐκ τοῦ στόματος ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Τρεῖς καιροὺς τοῦ ἐνιαυτοῦ ἑορτάσατέ μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Τὴν ἑορτὴν τῶν ἀζύμων φυλάξασθε ποιεῖν· ἑπτὰ ἡμέρας ἔδεσθε ἄζυμα, καθάπερ ἐνετειλάμην σοι κατὰ τὸν καιρὸν τοῦ μηνὸς τῶν νέων· ἐν γὰρ αὐτῷ ἐξῆλθες ἐξ Αἰγύπτου· οὐκ ὀφθήσῃ ἐνώπίον μου κενός. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Καὶ ἑορτὴν θερισμοῦ πρωτογεννημάτων ποιήσεις τῶν ἔργων σου, ὧν ἐὰν σπείρῃς ἐν τῷ ἀγρῷ σου, καὶ ἑορτὴν συντελείας ἐπʼ ἐξόδου τοῦ ἐνιαυτοῦ ἐν τῇ συναγωγῇ τῶν ἔργων σου τῶν ἐκ τοῦ ἀγροῦ σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Τρεῖς καιροὺς τοῦ ἐνιαυτοῦ ὀφθήσεται πᾶν ἀρσενικόν σου ἐνώπιον Κυρίου τοῦ Θεοῦ σου. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ὅταν γὰρ ἐκβάλω τὰ ἔθνη ἀπὸ προσώπου σου, καὶ ἐμπλατύνω τὰ ὅριά σου, οὐ θύσεις ἐπὶ ζύμῃ αἷμα θυμιάματός μου, οὐδὲ μὴ κοιμηθῇ στέαρ τῆς ἑορτῆς μου ἕως πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Τὰς ἀπαρχὰς τῶν πρωτογενημάτων τῆς γνς σου εἰσοίσεις εἰς τὸν οἶκον Κυρίου τοῦ Θεοῦ σου· οὐχ ἑψήσεις ἄρνα ἐν γάλακτι μητρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Καὶ ἰδοὺ ἐγὼ ἀποστέλλω τὸν ἄγγελόν μου πρὸ προσώπου σου, ἵνα φυλάξῃ σε ἐν τῇ ὁδῷ, ὅπως εἰσαγάγῃ σε εἰς τὴν γῆν, ἣν ἡτοίμασά σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Πρόσεχε σεαυτῷ, καὶ εἰσάκουε αὐτοῦ, καὶ μὴ ἀπείθει αὐτῷ, οὐ γὰρ μὴ ὑποστείληταί σε· τὸ γὰρ ὄνομά μου ἐστὶν ἐπʼ αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ἐὰν ἀκοῇ ἀκούσητε τῆς ἐμῆς φωνῆς, καὶ ποιήσῃς πάντα ὅσα ἂν ἐντείλωμαί σοι, καὶ φυλάξητε τὴν διαθήκην μου, ἔσεσθέ μοι λαὸς περιούσιος ἀπὸ πάντων τῶν ἐθνῶν· ἐμὴ γάρ ἐστι πᾶσα ἡ γῆ· ὑμεῖς δὲ ἔσεσθέ μοι βασίλειον ἱεράτευμα, καὶ ἔθνος ἅγιον· ταῦτα τὰ ῥήματα ἐρεῖς τοῖς υἱοῖς Ἰσραὴλ, ἐὰν ἀκοῇ ἀκούσητε τῆς φωνῆς μου, καὶ ποιήσητε πάντα ὅσα ἂν εἴπω σοι, ἐχθρεύσω τοῖς ἐχθροῖς σου, καὶ ἀντικείσομαι τοῖς ἀντικειμένοις σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Πορεύσεται γὰρ ὁ ἄγγελός μου ἡγούμενός σου, καὶ εἰσάξει σε πρὸς τὸν Ἀμοῤῥαῖον, καὶ Χετταῖον, καὶ Φερεζαῖον, καὶ Χαναναῖον, καὶ Γεργεσαῖον, καὶ Εὑαῖον, καὶ Ἰεβουσαῖον, καὶ ἐκτρίψω αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Οὐ προσκυνήσεις τοῖς θεοῖς αὐτῶν, οὐδὲ μὴ λατρεύσῃς αὐτοῖς· οὐ ποιήσεις κατὰ τὰ ἔργα αὐτῶν· ἀλλὰ καθαιρέσει καθελεῖς, καὶ συντρίβων συντρίψεις τὰς στήλας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Καὶ λατρεύσεις Κυρίῳ τῷ Θεῷ σου· καὶ εὐλογήσω τὸν ἄρτον σου καὶ τὸν οἶνόν σου καὶ τὸ ὕδωρ σου, καὶ ἀποστρέψω μαλακίαν ἀφʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Οὐκ ἔσται ἄγονος, οὐδὲ στεῖρα ἐπὶ τῆς γῆς σου· τὸν ἀριθμὸν τῶν ἡμερῶν σου ἀναπληρῶν ἀναπληρώσω. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Καὶ τὸν φόβον ἀποστελῶ ἡγούμενόν σου, καὶ ἐκστήσω πάντα τὰ ἔθνη, εἰς οὓς σὺ εἰσπορεύῃ εἰς αὐτούς· καὶ δώσω πάντας τοὺς ὑπεναντίους σου φυγάδας. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Καὶ ἀποστελῶ τὰς σφηκίας προτέρας σου· καὶ ἐκβαλεῖς τοὺς Ἀμοῤῥαίους, καὶ τοὺς Εὑαίους, καὶ τοὺς Χαναναίους, καὶ τοὺς Χετταίους ἀπὸ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Οὐκ ἐκβαλῶ αὐτοὺς ἐν ἐνιαυτῷ ἑνὶ, ἵνα μὴ γένηται ἡ γῆ ἔρημος, καὶ πολλὰ γένηται ἐπὶ σὲ τὰ θηρία τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Κατὰ μικρὸν ἐκβαλῶ αὐτοὺς ἀπὸ σοῦ, ἕως ἂν αὐξηθῇς καὶ κληρονομήσῃς τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Καὶ θήσω τὰ ὅριά σου ἀπὸ τῆς ἐρυθρᾶς θαλάσσης, ἕως τῆς θαλάσσης τῆς Φυλιστιείμ· καὶ ἀπὸ τῆς ἐρήμου, ἕως τοῦ μεγάλου ποταμοῦ Εὐφράτου· καὶ παραδώσω εἰς τὰς χεῖρας ὑμῶν τοὺς ἐγκαθημένους ἐν τῇ γῇ, καὶ ἐκβαλῶ αὐτοὺς ἀπὸ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Οὐ συγκαταθήσῃ αὐτοῖς καὶ τοῖς θεοῖς αὐτῶν διαθήκην. ");
INSERT INTO grcbrent_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Καὶ οὐκ ἐνκαθήσονται ἐν τῇ γῇ σου, ἵνα μὴ ἁμαρτεῖν σε ποιήσωσι πρὸς μέ· ἐὰν γὰρ δουλεύσῃς τοῖς θεοῖς αὐτῶν, οὗτοι ἔσονταί σοι πρόσκομμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Καὶ Μωυσῇ εἶπεν, ἀνάβηθι πρὸς τὸν Κύριον σὺ καὶ Ἀαρὼν, καὶ Ναδὰβ, καὶ Ἀβιοὺδ, καὶ ἑβδομήκοντα τῶν πρεσβυτέρων Ἰσραήλ· καὶ προσκυνήσουσι μακρόθεν τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Καὶ ἐγγιεῖ Μωσῆς μόνος πρὸς τὸν Θεὸν, αὐτοὶ δὲ οὐκ ἐγγιοῦσιν, ὁ δὲ λαὸς οὐ συναναβήσεται μετʼ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Εἰσῆλθε δὲ Μωυσῆς, καὶ διηγήσατο τῷ λαῷ πάντα τὰ ῥήματα τοῦ Θεοῦ καὶ τὰ δικαιώματα· ἀπεκρίθη δὲ πᾶς ὁ λαὸς φωνῇ μιᾷ, λέγοντες, πάντας τοὺς λόγους, οὓς ἐλάλησε Κύριος, ποιήσομεν, καὶ ἀκουσόμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Καὶ ἔγραψε Μωυσῆς πάντα τὰ ῥήματα Κυρίου· ὀρθρίσας δὲ Μωυσῆς τὸ πρωῒ ᾠκοδόμησε θυσιαστήριον ὑπὸ τὸ ὄρος, καὶ δώδεκα λίθους εἰς τὰς δώδεκα φυλὰς τοῦ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Καὶ ἐξαπέστειλε τοὺς νεανίσκους τῶν υἱῶν Ἰσραήλ, καὶ ἀνήνεγκαν ὁλοκαυτώματα· καὶ ἔθυσαν θυσίαν σωτηρίου τῷ Θεῷ μοσχάρια. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Λαβὼν δὲ Μωυσῆς τὸ ἥμισυ τοῦ αἵματος, ἐνέχεεν εἰς κρατῆρας, τὸ δὲ ἥμισυ τοῦ αἵματος προσέχεε πρὸς τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Καὶ λαβὼν τὸ βιβλίον τῆς διαθήκης, ἀνέγνω εἰς τὰ ὦτα τοῦ λαοῦ· καὶ εἶπαν, πάντα ὅσα ἐλάλησε Κύριος, ποιήσομεν καὶ ἀκουσόμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Λαβὼν δὲ Μωυσῆς τὸ αἷμα, κατεσκέδασε τοῦ λαοῦ, καὶ εἶπεν, ἰδοὺ τὸ αἷμα τῆς διαθήκης, ἧς διέθετο Κύριος πρὸς ὑμᾶς περὶ πάντων τῶν λόγων τούτων. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Καὶ ἀνέβη Μωυσῆς καὶ Ἀαρὼν, καὶ Ναδὰβ, καὶ Ἀβιοῦδ, καὶ ἑβδομήκοντα τῆς γερουσίας Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Καὶ εἶδον τὸν τόπον οὗ εἱστήκει ὁ Θεὸς τοῦ Ἰσραήλ· καὶ τὰ ὑπὸ τοὺς πόδας αὐτοῦ, ὡσεὶ ἔργον πλίνθου σαπφείρου, καὶ ὥσπερ εἶδος στερεώματος τοῦ οὐρανοῦ τῇ καθαριότητι. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Καὶ τῶν ἐπιλέκτων τοῦ Ἰσραὴλ οὐ διεφώνησεν οὐδὲ εἷς· καὶ ὤφθησαν ἐν τῷ τόπῳ τοῦ Θεοῦ, καὶ ἔφαγον καὶ ἔπιον. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἀνάβηθι πρὸς με εἰς τὸ ὄρος, καὶ ἴσθι ἐκεῖ· καὶ δώσω σοι τὰ πυξία τὰ λίθινα, τὸν νόμον καὶ τὰς ἐντολας, ἃς ἔγραψα νομοθετῆσαι αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Καὶ ἀναστὰς Μωυσῆς καὶ Ἰησοῦς ὁ παρεστηκὼς αὐτῷ, ἀνέβησαν εἰς τὸ ὄρος τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Καὶ τοῖς πρεσβυτέροις εἶπαν, ἡσυχάζετε αὐτοῦ, ἕως ἀναστρέψωμεν πρὸς ὑμᾶς· καὶ ἰδοὺ Ἀαρὼν καὶ Ὢρ μεθʼ ὑμῶν· ἐάν τινι συμβῇ κρίσις, προσπορευέσθωσαν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Καὶ ἀνέβη Μωυσῆς καὶ Ἰησοῦς εἰς τὸ ὄρος· καὶ ἐκάλυψεν ἡ νεφέλη τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Καὶ κατέβη ἡ δόξα τοῦ Θεοῦ ἐπὶ τὸ ὄρος τὸ Σινὰ, καὶ ἐκάλυψεν αὐτὸ ἡ νεφέλη ἓξ ἡμέρας· καὶ ἐκάλεσε Κύριος τὸν Μωυσῆν τῇ ἡμέρᾳ τῇ ἑβδόμῃ ἐκ μέσου τῆς νεφέλης. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Τὸ δὲ εἶδος τῆς δόξης Κυρίου, ὡσεὶ πῦρ φλέγον ἐπὶ τῆς κορυφῆς τοῦ ὄρους, ἐναντίον τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Καὶ εἰσῆλθε Μωυσῆς εἰς τὸ μέσον τῆς νεφέλης, καὶ ἀνέβη εἰς τὸ ὄρος· καὶ ἦν ἐκεῖ ἐν τῷ ὄρει τεσσεράκοντα ἡμέρας καὶ τεσσαράκοντα νύκτας. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","εἶπον τοῖς υἱοῖς Ἰσραὴλ, καὶ λάβετε ἀπαρχὰς παρὰ πάντων, οἷς ἂν δόξῃ τῇ καρδίᾳ, καὶ λήψεσθε τὰς ἀπαρχάς μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Καὶ αὕτη ἐστὶν ἡ ἀπαρχὴ, ἣν λήψεσθε παρʼ αὐτῶν· χρυσίον, καὶ ἀργύριον, καὶ χαλκὸν, ");
INSERT INTO grcbrent_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","καὶ ὑάκινθον, καὶ πορφύραν, καὶ κόκκινον διπλοῦν, καὶ βύσσον κεκλωσμένην, καὶ τρίχας αἰγείας, ");
INSERT INTO grcbrent_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","καὶ δέρματα κριῶν ἠρυθροδανωμένα, καὶ δέρματα ὑακίνθινα, καὶ ξύλα ἄσηπτα, ");
INSERT INTO grcbrent_vpl VALUES ("EX25_5a","003_25_5a","EXO","25","5a","5a","καὶ ἔλαιον εἰς τὴν φαῦσιν, θυμιάματα εἰς τὸ ἔλαιον τῆς χρίσεως, καὶ εἰς τὴν σύνθεσιν τοῦ θυμιάματος, ");
INSERT INTO grcbrent_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","καὶ λίθους Σαρδίου, καὶ λίθους εἰς τὴν γλυφὴν εἰς τὴν ἐπωμίδα, καὶ τὸν ποδήρη. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Καὶ ποιήεις μοι ἁγίασμα, καὶ ὀφθήσομαι ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Καὶ ποιήσεις μοι κατὰ πάντα ὅσα σοι δεικνύω ἐν τῷ ὄρει, τὸ παράδειγμα τῆς σκηνῆς, καὶ τὸ παράδειγμα πάντων τῶν σκευῶν αὐτῆς· οὕτω ποιήσεις. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Καὶ ποιήσεις κιβωτὸν μαρτυρίου ἐκ ξύλων ἀσήπτων, δύο πήχεων καὶ ἡμίσους τὸ μῆκος, καὶ πήχεος καὶ ἡμίσους τὸ πλάτος, καὶ πήχεως καὶ ἡμίσους τὸ ὕψος. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Καὶ καταχρυσώσεις αὐτὴν χρυσίῳ καθαρῷ, ἔσωθεν καὶ ἔξωθεν χρυσώσεις αὐτήν· καὶ ποιήσεις αὐτῇ κυμάτια χρυσᾶ στρεπτὰ κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Καὶ ἐλάσεις αὐτῇ τέσσαρας δακτυλίους χρυσοῦς, καὶ ἐπιθήσεις ἐπὶ τὰ τέσσαρα κλίτη· δύο δακτυλίους ἐπὶ τὸ κλίτος τὸ ἓν, καὶ δύο δακτυλίους ἐπὶ τὸ κλίτος τὸ δεύτερον. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ποιήσεις δὲ ἀναφορεῖς ξύλα ἄσηπτα, καὶ καταχρυσώσεις αὐτὰ χρυσίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Καὶ εἰσάξεις τοὺς ἀναφορεῖς εἰς τοὺς δακτυλίους τοὺς ἐν τοῖς κλίτεσι τῆς κιβωτοῦ, αἴρειν τὴν κιβωτὸν ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ἐν τοῖς δακτυλίοις τῆς κιβωτοῦ ἔσονται οἱ ἀναφορεῖς ἀκίνητοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Καὶ ἐμβαλεῖς εἰς τὴν κιβωτὸν τὰ μαρτύρια, ἃ ἂν δῶ σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Καὶ ποιήσεις ἱλαστήριον ἐπίθεμα χρυσίου καθαροῦ, δύο πήχεων καὶ ἡμίσους τὸ μῆκος, καὶ πήχεως καὶ ἡμίσους τὸ πλάτος. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Καὶ ποιήσεις δύο χερουβὶμ χρυσοτορευτὰ, καὶ ἐπιθήσεις αὐτὰ ἐξ ἀμφοτέρων τῶν κλιτῶν τοῦ ἱλαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ποιηθήσονται χεροὺβ εἷς ἐκ τοῦ κλίτους τούτου, καὶ χεροὺβ εἷς ἐκ τοῦ κλίτους τοῦ δευτέρου τοῦ ἱλαστηρίου· καὶ ποιήσεις τοὺς δύο χερουβὶμ ἐπὶ τὰ δύο κλίτη. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ἔσονται οἱ χερουβὶμ ἐκτείνοντες τὰς πτέρυγας ἐπάνωθεν, συσκιάζοντες ἐν ταῖς πτέρυξιν αὐτῶν ἐπὶ τοῦ ἱλαστηρίου, καὶ τὰ πρόσωπα αὐτῶν εἰς ἄλληλα, εἰς τὸ ἱλαστήριον ἔσονται τὰ πρόσωπα τῶν χερουβίμ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Καὶ ἐπιθήσεις τὸ ἱλαστήριον ἐπὶ τὴν κιβωτὸν ἄνωθεν, καὶ εἰς τὴν κιβωτὸν ἐμβαλεῖς τὰ μαρτύρια, ἃ ἂν δῶ σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Καὶ γνωσθήσομαί σοι ἐκεῖθεν, καὶ λαλήσω σοι ἄνωθεν τοῦ ἱλαστηρίου ἀνὰ μέσον τῶν δύο χερουβὶμ, τῶν ὄντων ἐπὶ τῆς κιβωτοῦ τοῦ μαρτυρίου, καὶ κατὰ πάντα ὅσα ἐὰν ἐντείλωμαί σοι πρὸς τοὺς υἱοὺς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Καὶ ποιήσεις τράπεζαν χρυσῆν χρυσίου καθαροῦ, δύο πήχεων τὸ μῆκος, καὶ πήχεως τὸ εὖρος, καὶ πήχεως καὶ ἡμίσους τὸ ὕψος. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Καὶ ποιήσεις αὐτῇ στρεπτὰ κυμάτια χρυσᾶ κύκλῳ· καὶ ποιήσεις αὐτῇ στεφάνην παλαιστοῦ κύκλῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Καὶ ποιήσεις στρεπτὸν κυμάτιον τῇ στεφάνῃ κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Καὶ ποιήσεις τέσσαρας δακτυλίους χρυσοῦς, καὶ ἐπιθήσεις τοὺς τέσσαρας δακτυλίους ἐπὶ τὰ τέσσαρα μέρη τῶν ποδῶν αὐτῆς ὑπὸ τὴν στεφάνην. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Καὶ ἔσονται οἱ δακτύλιοι εἰς θήκας τοῖς ἀναφορεῦσιν, ὥστε αἴρειν ἐν αὐτοῖς τὴν τράπεζαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Καὶ ποιήσεις τοὺς ἀναφορεῖς ἐκ ξύλων ἀσήπτων, καὶ καταχρυσώσεις αὐτοὺς χρυσίῳ καθαρῷ, καὶ ἀρθήσεται ἐν αὐτοῖς ἡ τράπεζα. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Καὶ ποιήσεις τὰ τρυβλία αὐτῆς, καὶ τὰς θυΐσκας, καὶ τὰ σπονδεῖα, καὶ τοὺς κυάθους, ἐν οἷς σπείσεις ἐν αὐτοῖς, ἐκ χρυσίου καθαροῦ ποιήσεις αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Καὶ ἐπιθήσεις ἐπὶ τὴν τράπεζαν ἄρτους ἐνωπίους ἐναντίον μου διαπαντός. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Καὶ ποιήσεις λυχνίαν ἐκ χρυσίου καθαροῦ, τορευτὴν ποιήσεις τὴν λυχνίαν· ὁ καυλὸς αὐτῆς, καὶ ὁ καλαμίσκοι, καὶ οἱ κρατῆρες, καὶ οἱ σφαιρωτῆρες, καὶ τὰ κρίνα ἐξ αὐτῆς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ἓξ δὲ καλαμίσκοι ἐκπορευόμενοι ἐκ πλαγίων, τρεῖς καλαμίσκοι τῆς λυχνίας ἐκ τοῦ κλίτους τοῦ ἑνὸς αὐτῆς, καὶ τρεῖς καλαμίσκοι τῆς λυχνίας ἐκ τοῦ κλίτους τοῦ δευτέρου. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Καὶ τρεῖς κρατῆρες ἐκτετυπωμένοι καρυΐσκους· ἐν τῷ ἑνὶ καλαμίσκῳ σφαιρωτὴρ καὶ κρίνον· οὕτω τοῖς ἓξ καλαμίσκοις τοῖς ἐκπορευομένοις ἐκ τῆς λυχνίας. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Καὶ ἐν τῇ λυχνίᾳ τέσσαρες κρατῆρες ἐκτετυπωμένοι καρυΐσκους· ἐν τῷ ἑνὶ καλαμίσκῳ σφαιρωτῆρες, καὶ τὰ κρίνα αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ὁ σφαιρωτὴρ ὑπὸ τοὺς δύο καλαμίσκους ἐξ αὐτῆς· καὶ σφαιρωτὴρ ὑπὸ τοὺς τέσσαρας καλαμίσκους ἐξ αὐτῆς· οὕτω τοῖς ἓξ καλαμίσκοις τοῖς ἐκπορευομένοις ἐκ τῆς λυχνίας· καὶ ἐν τῇ λυχνίᾳ τέσσαρες κρατῆρες ἐκτετυπωμένοι καρυΐσκους. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Οἱ σφαιρωτῆρες καὶ οἱ καλαμίσκοι ἐξ αὐτῆς ἔστωσαν· ὅλη τορευτὴ ἐξ ἑνὸς χρυσίου καθαροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Καὶ ποιήσεις τοὺς λύχνους αὐτῆς ἑπτά· καὶ ἐπιθήσεις τοὺς λύχνους, καὶ φανοῦσιν ἐκ τοῦ ἑνὸς προσώπου. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Καὶ τὸν ἐπαρυστῆρα αὐτῆς, καὶ τὰ ὑποθέματα αὐτῆς ἐκ χρυσίου καθαροῦ ποιήσεις. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Πάντα τὰ σκεύη ταῦτα τάλαντον χρυσίου καθαροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ὅρα, ποιήσεις κατὰ τὸν τύπον τὸν δεδειγμένον σοι ἐν τῷ ὄρει. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Καὶ τὴν σκηνὴν ποιήσεις, δέκα αὐλαίας ἐκ βύσσου κεκλωσμένης, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου κεκλωσμένου χερουβὶμ· ἐργασίᾳ ὑφάντου ποιήσεις αὐτάς. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Μῆκος τῆς αὐλαίας τῆς μιᾶς ὀκτὼ καὶ εἴκοσι πήχεων, καὶ εὖρος τεσσάρων πήχεων ἡ αὐλαία ἡ μία ἔσται· μέτρον τὸ αὐτὸ ἔσται πάσαις ταῖς αὐλαίαις. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Πέντε δὲ αὐλαῖαι ἔσονται ἐξ ἀλλήλων ἐχόμεναι ἡ ἑτέρα ἐκ τῆς ἑτέρας· καὶ πέντε αὐλαῖαι ἔσονται συνεχόμεναι ἑτέρα τῇ ἑτέρᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Καὶ ποιήσεις αὐταῖς ἀγκύλας ὑακινθίνας ἐπὶ τοῦ χείλους τῆς αὐλαίας τῆς μιᾶς, ἐκ τοῦ ἑνὸς μέρους εἰς τὴν συμβολήν· καὶ οὕτω ποιήσεις ἐπὶ τοῦ χείλους τῆς αὐλαίας τῆς ἐξωτέρας πρὸς τῇ συμβολῇ τῇ δευτέρᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Πεντήκοντα ἀγκύλας ποιήσεις τῇ αὐλαίᾳ τῇ μιᾷ, καὶ πεντήκοντα ἀγκύλας ποιήσεις ἐκ τοῦ μέρους τῆς αὐλαίας κατὰ τὴν συμβολὴν τῆς δευτέρας, ἀντιπρόσωποι ἀντιπίπτουσαι ἀλλήλαις εἰς ἑκάστην. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Καὶ ποιήσεις κρίκους πεντήκοντα χρυσοῦς· καὶ συνάψεις τὰς αὐλαίας ἑτέραν τῇ ἑτέρα τοῖς κρίκοις· καὶ ἔσται ἡ σκηνὴ μία. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Καὶ ποιήσεις δέῤῥεις τριχίνας σκέπην ἐπὶ τῆς σκηνῆς, ἕνδεκα δέῤῥεις ποιήσεις αὐτάς. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Τὸ μῆκος τῆς δέῤῥεως τῆς μιᾶς, τριάκοντα πήχεων, καὶ τεσσάρων πήχεων τὸ εὖρος τῆς δέῤῥεως τῆς μιᾶς· τὸ αὐτὸ μέτρον ἔσται ταῖς ἕνδεκα δέῤῥεσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Καὶ συνάψεις τὰς πέντε δέῤῥεις ἐπὶ τὸ αὐτὸ, καὶ τὰς ἓξ δέῤῥεις ἐπὶ τὸ αὐτό· καὶ ἐπιδιπλώσεις τὴν δέῤῥιν τὴν ἕκτην κατὰ πρόσωπον τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Καὶ ποιήσεις ἀγκύλας πεντήκοντα ἐπὶ τοῦ χείλους τῆς δέῤῥεως τῆς μιᾶς, τῆς ἀναμέσον κατὰ συμβολήν· καὶ πεντήκοντα ἀγκύλας ποιήσεις ἐπὶ τοῦ χείλους τῆς δέῤῥεως, τῆς συναπτούσης τῆς δευτέρας. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Καὶ ποιήσεις κρίκους χαλκοῦς πεντήκοντα· καὶ συνάψεις τοὺς κρίκους ἐκ τῶν ἀγκυλῶν, καὶ συνάψεις τὰς δέῤῥεις, καὶ ἔσται ἕν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Καὶ ὑποθήσεις τὸ πλεονάζον ἐν ταῖς δέῤῥεσι τῆς σκηνῆς· τὸ ἥμισυ τῆς δέῤῥεως τὸ ὑπολελειμμένον ὑποκαλύψεις εἰς τὸ πλεονάζον τῶν δέῤῥεων τῆς σκηνῆς, ὑποκαλύψεις ὀπίσω τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Πῆχυν ἐκ τούτου, καὶ πῆχυν ἐκ τούτου, ἐκ τοῦ ὑπερέχοντος τῶν δέῤῥεων, ἐκ τοῦ μήκους τῶν δέῤῥεων τῆς σκηνῆς· ἔσται συγκαλύπτον ἐπὶ τὰ πλάγια τῆς σκηνῆς ἔνθεν καὶ ἔνθεν, ἵνα καλύπτῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Καὶ ποιήσεις κατακάλυμμα τῇ σκηνῇ δέρματα κριῶν ἠρυθροδανωμένα, καὶ ἐπικαλύμματα δέρματα ὑακίνθινα ἐπάνωθεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Καὶ ποιήσεις στύλους τῆς σκηνῆς ἐκ ξύλων ἀσήπτων. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Δέκα πήχεων ποιήσεις τὸν στύλον τὸν ἕνα, καὶ πήχεως ἑνὸς καὶ ἡμίσους τὸ πλάτος τοῦ στύλου τοῦ ἑνός. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Δύο ἀγκωνίσκους τῷ στύλῳ τῷ ἑνὶ, ἀντιπίπτοντας ἕτερον τῷ ἑτέρῳ· οὕτω ποιήσεις πᾶσι τοῖς στύλοις τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Καὶ ποιήσεις στύλους τῇ σκηνῇ, εἴκοσι στύλους ἐκ τοῦ κλίτους τοῦ πρὸς Βοῤῥᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Καὶ τεσσαράκοντα βάσεις ἀργυρᾶς ποιήσεις τοῖς εἴκοσι στύλοις· δύο βάσεις τῷ στύλῳ τῷ ἑνὶ εἰς ἀμφότερα τὰ μέρη αὐτοῦ· και δύο βάσεις τῷ στύλῳ τῷ ἑνὶ εἰς ἀμφοτέρα τὰ μέρη αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Καὶ τὸ κλίτος τὸ δεύτερον τὸ πρὸς Νότον, εἴκοσι στύλους, ");
INSERT INTO grcbrent_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","καὶ τεσσαράκοντα βάσεις αὐτῶν ἀργυρᾶς· δύο βάσεις τῷ στύλῳ τῷ ἑνὶ εἰς ἀμφότερα τὰ μέρη αὐτοῦ, καὶ δύο βάσεις τῷ στύλῳ τῷ ἑνὶ εἰς ἀμφότερα τὰ μέρη αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Καὶ ἐκ τῶν ὀπίσω τῆς σκηνῆς κατὰ τὸ μέρος τὸ πρὸς θάλασσαν ποιήσεις ἓξ στύλους. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Καὶ δύο στύλους ποιήσεις ἐπὶ τῶν γωνιῶν τῆς σκηνῆς ἐκ τῶν ὀπισθίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Καὶ ἔσται ἐξ ἴσου κάτωθεν· κατὰ τὸ αὐτὸ ἔσονται ἴσοι ἐκ τῶν κεφαλῶν εἰς σύμβλησιν μίαν· οὕτω ποιήσεῖς ἀμφοτέραις ταῖς δυσὶ γωνίαις· ἴσαι ἔστωσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Καὶ ἔσονται ὀκτὼ στύλοι, καὶ αἱ βάσεις αὐτῶν ἀργυραῖ δεκαέξ· δύο βάσεις τῷ ἑνὶ στύλῳ εἰς ἀμφότερα τὰ μέρη αὐτοῦ, καὶ δύο βάσεις τῷ στύλῳ τῷ ἑνί. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Καὶ ποιήσεις μοχλοὺς ἐκ ξύλων ἀσήπτων· πέντε τῷ ἑνὶ στύλῳ ἐκ τοῦ ἑνὸς μέρους τῆς σκηνῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","καὶ πέντε μοχλοὺς τῷ στύλῳ τῷ ἑνὶ κλίτει τῆς σκηνῆς τῷ δευτέρῳ, καὶ πέντε μοχλοὺς τῷ στύλῳ τῷ ὀπισθίῳ τῷ κλίτει τῆς σκηνῆς τῷ πρὸς θάλασσαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Καὶ ὁ μοχλὸς ὁ μέσος ἀναμέσον τῶν στύλων διϊκνείσθω ἀπὸ τοῦ ἑνὸς κλίτους εἰς τὸ ἕτερον κλίτος. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Καὶ τοὺς στύλους καταχρυσώσεις χρυσίῳ· καὶ τοὺς δακτυλίους ποιήσεις χρυσοῦς, εἰς οὓς εἰσάξεις τούς μοχλούς· καὶ καταχρυσώσεις τοὺς μοχλοὺς χρυσίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Καὶ ἀναστήσεις τὴν σκηνὴν κατὰ τὸ εἶδος τὸ δεδειγμένον σοι ἐν τῷ ὄρει. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Καὶ ποιήσεις καταπέτασμα ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου κεκλωσμένου, καὶ βύσσου νενησμένης· ἔργον ὑφαντὸν ποιήσεις αὐτὸ χερουβίμ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Καὶ ἐπιθήσεις αὐτὸ ἐπὶ τεσσάρων στύλων ἀσήπτων κεχρυσωμένων χρυσίῳ· καὶ αἱ κεφαλίδες αὐτῶν χρυσαῖ, καὶ αἱ βάσεις αὐτῶν τέσσαρες ἀργυραῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Καὶ θήσεις τὸ καταπέτασμα ἐπὶ τῶν στύλων· καὶ εἰσοίσεις ἐκεῖ ἐσώτερον τοῦ καταπετάσματος τὴν κιβωτὸν τοῦ μαρτυρίου· καὶ διοριεῖ τὸ καταπέτασμα ὑμῖν ἀναμέσον τοῦ ἁγίου καὶ ἀναμέσον τοῦ ἁγίου τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Καὶ κατακαλύψεις τῷ καταπετάσματι τὴν κιβωτὸν τοῦ μαρτυρίου ἐν τῷ ἁγίῳ τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Καὶ ἐπιθήσεις τὴν τράπεζαν ἔξωθεν τοῦ καταπετάσματος, καὶ τὴν λυχνίαν ἀπέναντι τῆς τραπέζης ἐπὶ μέρους τῆς σκηνῆς τὸ πρὸς Νότον· καὶ τὴν τράπεζαν θήσεις ἐπὶ μέρους τῆς σκηνῆς τὸ πρὸς Βοῤῥᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Καὶ ποιήσεις ἐπίσπαστρον τῇ θύρᾳ τῆς σκηνῆς ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου κεκλωσμένου, καὶ βύσσου κεκλωσμένης, ἔργον ποικιλτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Καὶ ποιήσεις τῷ καταπετάσματι πέντε στύλους, καὶ χρυσώσεις αὐτοὺς χρυσίῳ· καὶ αἱ κεφαλίδες αὐτῶν χρυσαῖ· καὶ χωνεύσεις αὐτοῖς πέντε βάσεις χαλκᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Καὶ ποιήσεις θυσιαστήριον ἐκ ξύλων ἀσήπτων, πέντε πήχεων τὸ μῆκος, καὶ πέντε πήχεων τὸ εὖρος· τετράγωνον ἔσται τὸ θυσιαστήριον, καὶ τριῶν πήχεων τὸ ὕψος αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Καὶ ποιήσεις τὰ κέρατα ἐπὶ τῶν τεσσάρων γωνιῶν· ἐξ αὐτοῦ ἔσται τὰ κέρατα, καὶ καλύψεις αὐτὰ χαλκῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Καὶ ποιήσεις στεφάνην τῷ θυσιαστηρίῳ· καὶ τὸν καλυπτῆρα αὐτοῦ, καὶ τὰς φιάλας αὐτοῦ, καὶ τὰς κρεάγρας αὐτοῦ, καὶ τὸ πυρεῖον αὐτοῦ, καὶ πάντα τὰ σκεύη αὐτοῦ ποιήσεις χαλκᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Καὶ ποιήσεις αὐτῷ ἐσχάραν ἔργῳ δικτυωτῷ χαλκῆν· καὶ ποιήσεις τῇ ἐσχάρᾳ τέσσαρες δακτυλίους χαλκοῦς ὑπὸ τὰ τέσσαρα κλίτη. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Καὶ ὑποθήσεις αὐτοὺς ὑπὸ τὴν ἐσχάραν τοῦ θυσιαστήριου κάτωθεν· ἔσται δὲ ἡ ἐσχάρα ἕως τοῦ ἡμίσους τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Καὶ ποιήσεις τῷ θυσιαστηρίῳ ἀναφορεῖς ἐκ ξύλων ἀσήπτων, καὶ περιχαλκώσεις αὐτοὺς χαλκῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Καὶ εἰσάξεις τοὺς ἀναφορεῖς εἰς τοὺς δακτυλίους· καὶ ἔστωσαν ἀναφορεῖς κατὰ πλευρὰ τοῦ θυσιαστηρίου ἐν τῷ αἴρειν αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Κοῖλον συνιδωτὸν ποιήσεις αὐτό· κατὰ τὸ παραδειχθέν σοι ἐν τῷ ὄρει, οὕτω ποιήσεις αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Καὶ ποιήσεις αὐλὴν τῇ σκηνῇ· εἰς τὸ κλίτος τὸ πρὸς Λίβα ἱστία τῆς αὐλῆς ἐκ βύσσου κεκλωσμένης· μῆκος ἑκατὸν πήχεων τῷ ἑνὶ κλίτει. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Καὶ οἱ στύλοι αὐτῶν εἴκοσι, καὶ αἱ βάσεις αὐτῶν εἴκοσι χαλκαῖ, καὶ οἱ κρίκοι αὐτῶν καὶ αἱ ψαλίδες ἀργυραῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Οὕτως τῷ κλίτει τῷ πρὸς ἀπηλιώτην ἱστία ἑκατὸν πήχεων μῆκος· καὶ οἱ στύλοι αὐτῶν εἴκοσι, καὶ αἱ βάσεις αὐτῶν εἴκοσι χαλκαῖ· καὶ οἱ κρίκοι καὶ αἱ ψαλίδες τῶν στύλων, καὶ αἱ βάσεις αὐτῶν περιηργυρωμέναι ἀργυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Τὸ δὲ εὖρος τῆς αὐλῆς τὸ κατὰ θάλασσαν ἱστία πεντήκοντα πήχεων· στύλοι αὐτῶν δέκα, καὶ βάσεις αὐτῶν δέκα. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Καὶ εὖρος τῆς αὐλῆς τῆς πρὸς Νότον ἱστία πεντήκοντα πήχεων· στύλοι αὐτῶν δέκα, καὶ βάσεις αὐτῶν δέκα. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Καὶ πεντεκαίδεκα πήχεων τὸ ὕψος τῶν ἱστίων τῷ κλίτει τῷ ἑνί· στύλοι αὐτῶν τρεῖς, καὶ αἱ βάσεις αὐτῶν τρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Καὶ τὸ κλίτος τὸ δεύτερον δεκαπέντε πήχεων τῶν ἱστίων τὸ ὕψος· στύλοι αὐτῶν τρεῖς, καὶ αἱ βάσεις αὐτῶν τρεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Καὶ τῇ πύλῃ τῆς αὐλῆς κάλυμμα· εἴκοσι πήχεων τὸ ὕψος ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου κεκλωσμένου, καὶ βύσσου κεκλωσμένης τῇ ποικιλίᾳ τοῦ ῥαφιδευτοῦ· στύλοι αὐτῶν τέσσαρες, καὶ αἱ βάσεις αὐτῶν τέσσαρες. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Πάντες οἱ στύλοι τῆς αὐλῆς κύκλῳ κατηργυρωμένοι ἀργυρίῳ, καὶ αἱ κεφαλίδες αὐτῶν ἀργυραῖ, καὶ αἱ βάσεις αὐτῶν χαλκαῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Τὸ δὲ μῆκος τῆς αὐλῆς ἑκατὸν ἐφʼ ἑκατόν· καὶ εὖρος πεντήκοντα ἐπὶ πεντήκοντα· καὶ ὕψος πέντε πήχεῶν ἐκ βύσσου κεκλωσμένης, καὶ βάσεις αὐτῶν χαλκαῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Καὶ πᾶσα ἡ κατασκευὴ καὶ πάντα τὰ ἐργαλεῖα καὶ οἱ πάσσαλοι τῆς αὐλῆς χαλκοῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Καὶ σὺ σύνταξον τοῖς υἱοῖς Ἰσραὴλ, καὶ λαβέτωσάν σοι ἔλαιον ἐξ ἐλαιῶν ἀτρυγον καθαρὸν κεκομμένον εἰς φῶς καῦσαι, ἵνα καίηται λύχνος διαπαντός ");
INSERT INTO grcbrent_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ἐν τῇ σκηνῇ τοῦ μαρτυρίου· ἔξωθεν τοῦ καταπετάσματος τοῦ ἐπὶ τῆς διαθήκης καύσει αὐτὸ Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ ἀφʼ ἑσπέρας ἕως πρωῒ, ἐναντίον Κυρίου, νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν παρὰ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Καὶ σὺ προσαγάγου πρὸς σεαυτὸν τόν τε Ἀαρὼν τὸν ἀδελφόν σου, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ ἐκ τῶν υἱῶν Ἰσραὴλ, ἱερατεύειν μοι Ἀαρὼν, καὶ Ναδὰβ, καὶ Ἀβιοὺδ, καὶ Ἐλεάζαρ, καὶ Ἰθάμαρ, υἱοὺς Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Καὶ ποιήσεις στολὴν ἁγίαν Ἀαρὼν τῷ ἀδελφῷ σου εἰς τιμὴν καὶ δόξαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Καὶ σύ λάλησον πᾶσι τοῖς σοφοῖς τῇ διανοίᾳ, οὓς ἐνέπλησα πνεύματος σοφίας καὶ αἰσθήσεως· καὶ ποιήσουσι τὴν στολὴν τὴν ἁγίαν Ἀαρὼν εἰς τὸ ἅγιον, ἐν ᾗ ἱερατεύσει μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Καὶ αὗται αἱ στολαὶ, ἃς ποιησουσι· τὸ περιστήθιον, καὶ τὴν ἐπωμίδα, καὶ τὸν ποδήρη, καὶ χιτῶνα κοσυμβωτὸν, καὶ κίδαριν, καὶ ζώνην· καὶ ποιήσουσι στολὰς ἁγίας Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ εἰς τὸ ἱερατεύειν μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Καὶ αὐτοὶ λήψονται τὸ χρυσίον, καὶ τὸν ὑάκινθον, καὶ τὴν πορφύραν, καὶ τὸ κόκκινον, καὶ τὴν βύσσον. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Καὶ ποιήσουσι τὴν ἐπωμίδα ἐκ βύσσου κεκλωσμένης, ἔργον ὑφαντὸν ποικιλτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Δύο ἐπωμίδες συνέχουσαι ἔσονται αὐτῷ ἑτέρα τὴν ἑτέραν, ἐπὶ τοῖς δυσὶ μέρεσιν ἐξηρτισμέναι. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Καὶ τὸ ὕφασμα τῶν ἐπωμίδων ὅ ἐστιν ἐπʼ αὐτῷ, κατὰ τὴν ποίησιν ἐξ αὐτοῦ ἔσται ἐκ χρυσίου καθαροῦ, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου διανενησμένου, καὶ βύσσου κεκλωσμένης. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Καὶ λήψῃ τοὺς δύο λίθους, λίθους σμαράγδου, καὶ γλύψεις ἐν αὐτοῖς τὰ ὀνόματα τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ἓξ ὀνόματα ἐπὶ τὸν λίθον τὸν ἕνα, καὶ τὰ ἓξ ὀνόματα τὰ λοιπὰ ἐπὶ τὸν λίθον τὸν δεύτερον κατὰ τὰς γενέσεις αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ἔργον λιθουργικῆς τέχνης· γλύμμα σφραγίδος διαγλύψεις τοὺς δύο λίθους ἐπὶ τοῖς ὀνόμασι τῶς υἱῶν Ἰσρσήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Καὶ θήσεις τοὺς δύο λίθους ἐπὶ τῶς ὤμων τῆς ἐπωμίδος· λίθοι μνημοσύνου εἰσὶ τοῖς υἱοῖς Ἰσραήλ· καὶ ἀναλήψεται Ἀαρὼν τὰ ὀνόματα τῶν υἱῶν Ἰσραὴλ ἔναντι Κυρίου ἐπὶ τῶν δύο ὤμων αὐτοῦ, μνημόσυνον πεπὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Καὶ ποιήσεις ἀσπιδίσκας ἐκ χρυσίου καθαροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Καὶ ποιήσεις δύο κροσωτὰ ἐκ χρυσίου καθαροῦ, καταμεμιγμένα ἐν ἄνθεσιν, ἔργον πλοκῆς· καὶ ἐπιθήσεις τὰ κροσσωτὰ τὰ πεπλεγμένα ἐπὶ τὰς ἀσπιδίσκας, κατὰ τὰς παρωμίδας αὐτῶν ἐκ τῶν ἐμπροσθίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Καὶ ποιήσεις λογεῖον τῶν κρίσεων, ἔργον ποικιλτοῦ· κατὰ τὸν ῥυθμὸν τῆς ἐπωμίδος ποιήσεις αὐτὸ ἐκ χρυσίου, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου κεκλωσμένου, καὶ βύσσου κεκλωσμένης. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ποιήσεις αὐτό τετράγωνον· ἔσται διπλοῦν, σπιθαμῆς τὸ μῆκος αὐτοῦ, καὶ σπιθαμῆς τὸ εὖρος. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Καὶ καθυφανεῖς ἐν αὐτῷ ὕφασμα κατάλιθον τετράστιχον· στίχος λίθων ἔσται, σάρδιον, τοπάζιον, καὶ σμαράγδος, ὁ στίχος ὁ εἷς. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Καὶ ὁ στίχος ὁ δεύτερος, ἄνθραξ, καὶ σάπφειρος, καὶ ἴασπις. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Καὶ ὁ στίχος ὁ τρίτος, λιγύριον, ἀχάτης, ἀμέθυστος. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Καὶ ὁ στίχος ὁ τέταρτος, χρυσόλιθος, καὶ βηρύλλιον, καὶ ὀνύχιον, περικεκαλυμμένα χρυσίῳ, συνδεδεμένα ἐν χρυσίῳ· ἔστωσαν κατὰ στίχον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Καὶ οἱ λίθοι ἔστωσαν ἐκ τῶν ὀνομάτων τῶν υἱῶν Ἰσραὴλ δεκαδύο κατὰ τὰ ὀνόματα αὐτῶν· γλυφαὶ σφραγίδων, ἕκαστος κατὰ τὸ ὄνομα ἔστωσαν εἰς δεκαδύο φυλάς. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Καὶ ποιήσεις ἐπὶ τὸ λογιον κρωσσοὺς συμπεπλεγμένους, ἔργον ἁλυσιδωτὸν ἐκ χρυσίου καθαροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Καὶ λήψεται Ἀαρὼν τὰ ὀνόματα τῶν υἱῶν Ἰσραὴλ ἐπὶ τοῦ λογείου τῆς κρίσεως ἐπὶ τοῦ στήθους, εἰσιόντι εἰς τὸ ἅγιον μνημόσυνου ἐναντίον τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_29a","003_28_29a","EXO","28","29a","29a","Καὶ θήσεις ἐπὶ τὸ λογεῖον τῆς κρίσεως τοὺς κρωσσούς· τὰ ἁλυσιδωτὰ ἐπʼ ἀμφοτέρων τῶν κλιτῶν τοῦ λογείου ἐπιθήσεις. Καὶ τὰς δύο ἀσπιδίσκας ἐπιθήσεις ἐπʼ ἀμφοτέρους τοὺς ὤμους τῆς ἐπωμίδος κατὰ πρόσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Καὶ ἐπιθήσεις ἐπὶ τὸ λογεῖον τῆς κρίσεως τὴν δήλωσιν καὶ τὴν ἀλήθειαν· καὶ ἔσται ἐπὶ τοῦ στήθους Ἀαρὼν, ὃταν εἰσπορεύεται εἰς τὸ ἅγιον ἔναντὶ Κυρίου· καὶ οἴσει Ἀαρὼν τὰς κρίσεις τῶν υἱῶν Ἰσραὴλ ἐπὶ τοῦ στήθους ἔναντι Κυρίου διαπαντός. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Καὶ ποιήσεις ὑποδύτην ποδήρη ὅλον ὑακίνθινον. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Καὶ ἔσται τὸ περιστόμιον ἐξ αὐτοῦ μέσον, ὤαν ἔχον κύκλῳ τοῦ περιστομίου, ἔργον ὑφαντου, τὴν συμβολὴν συνυφασμένην ἐξ αὐτοῦ, ἵνα μὴ ῥαγῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Καὶ ποιήσεις ὑπὸ τὸ λῶμα τοῦ ὑποδύτου κάτωθεν, ὡσεὶ ἐξανθούσης ῥόας ῥοΐσκους ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου διανενησμένου, καὶ βύσσου κεκλωσμένης, ὑπὸ τοῦ λώματος τοῦ ὑποδύτου κύκλῳ· τὸ αὐτὸ εἶδος ῥοΐσκους χρυσοῦς, καὶ κώδωνας ἀναμέσον τούτων περικύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Παρὰ ῥοΐσκον χρυσοῦν δώδωνα, καὶ ἄνθινον ἐπὶ τοῦ λώματος τοῦ ὑποδύτου κύκλῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Καὶ ἔσται Ἀαρὼν ἐν τῷ λειτουργεῖν ἀκουστὴ ἡ φωνὴ αὐτοῦ, εἰσιόντι εἰς τὸ ἅγιον ἔναντι Κυρίου, καὶ ἐξιόντι, ἵνα μὴ ἀποθάνῃ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Καὶ ποιήσεις πέταλον χρυσοῦν καθαρόν· καὶ ἐκτυπώσεις ἐν αὐτῷ ἐκτύπωμα σφραγίδος, Ἁγίασμα Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Καὶ ἐπιθήσεις αὐτὸ ἐπὶ ὑακίνθου κεκλωσμένης· καὶ ἔσται ἐπὶ τῆς μίτρας, κατὰ πρόσωπον τῆς μίτρας ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Καὶ ἔσται ἐπὶ τοῦ μετώπου Ἀαρών· καὶ ἐξαρεῖ Ἀαρὼν τὰ ἁμαρτήματα τῶν ἁγίων, ὅσα ἂν ἁγιάσωσιν οἱ υἱοὶ Ἰσραὴλ παντὸς δόματος τῶν ἁγίων αὐτῶν· καὶ ἔσται ἐπὶ τοῦ μετώπου Ἀαρὼν διαπαντὸς δεκτὸν αὐτοῖς ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Καὶ οἱ κοσυμβωτοὶ τῶν χιτώνων ἐκ βύσσου· καὶ ποιήσεις κίδαριν βυσσίνην· καὶ ζώνην ποιήσεις, ἔργον ποικιλτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Καὶ τοῖς υἱοῖς Ἀαρὼν ποιήσεις χιτῶνας καὶ ζώνας, καὶ κιδάρεις ποιήσεις αὐτοῖς εἰς τιμὴν καὶ δόξαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Καὶ ἐνδύσεις αὐτὰ Ἀαρὼν τὸν ἀδελφόν σου, καὶ τοὺς υἱοὺς αὐτοῦ μετʼ αὐτοῦ· καὶ χρίσεις αὐτοὺς, καὶ ἐμπλήσεις αὐτῶν τὰς χεῖρας· καὶ ἁγιάσεις αὐτοὺς, ἵνα ἱερατεύωσί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Καὶ ποιήσεις αὐτοῖς περισκελῆ λινᾶ καλύψαι ἀσχημοσύνην χρωτὸς αὐτῶν, ἀπὸ ὀσφύος ἕως μηρῶν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Καὶ ἕξει Ἀαρὼν αὐτὰ καὶ οἱ υἱοὶ αὐτοῦ, ὅταν εἰσπορεύωνται εἰς τὴν σκηνὴν τοῦ μαρτυρίου, ἢ ὅταν προσπορεύωνται λειτουργεῖν πρὸς τὸ θυσιαστήριον τοῦ ἁγίου· καὶ οὐκ ἐπάξονται πρὸς ἑαυτοὺς ἁμαρτίαν, ἵνα μὴ ἀποθάνωσι· νόμιμον αἰώνιον αὐτῷ, καὶ τῷ σπέρματι αὐτοῦ μετʼ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Καὶ ταῦτά ἐστιν, ἃ ποιήσεις αὐτοῖς· ἁγιάσεις αὐτοὺς, ὥστε ἱερατεύειν μοι αὐτούς· λήψῃ δὲ μοσχάριον ἐκ βοῶν ἓν, καὶ κριοὺς ἀμώμους δύο, ");
INSERT INTO grcbrent_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","καὶ ἄρτους ἀζύμους πεφυραμένους ἑν ἐλαίῳ, καὶ λάγανα ἄζυμα κεχρισμένα ἐν ἐλαίῳ· σεμίδαλιν ἐκ πυρῶν ποιήσεις αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Καὶ ἐπιθήσεις αὐτὰ ἐπὶ κανοῦν ἕν· καὶ προσοίσεις αὐτὰ ἐπὶ τῷ κανῷ· καὶ τὸ μοσχάριον, καὶ τοὺς δύο κριούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Καὶ Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ προσάξεις ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, καὶ λούσεις αὐτοὺς ἐν ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Καὶ λαβὼν τὰς στολὰς, ἐνδύσεις Ἀαρὼν τὸν ἀδελφόν σου καὶ τὸν χιτῶνα τὸν ποδήρη, καὶ τὴν ἐπωμίδα, καὶ τὸ λογεῖον· καὶ συνάψεις αὐτῷ τὸ λογεῖον πρὸς τὴν ἐπωμίδα. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Καὶ ἐπιθήσεις τὴν μίτραν ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ ἐπιθήσεις τὸ πέταλον τὸ ἁγίασμα ἐπὶ τὴν μίτραν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Καὶ λήψῃ τοῦ ἐλαίου τοῦ χρίσματος· καὶ ἐπιχεεῖς αὐτὸ ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ χρίσεις αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Καὶ τοὺς υἱοὺς αὐτοῦ προσάξεις, καὶ ἐνδύσεις αὐτοὺς χιτῶνας. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Καὶ ζώσεις αὐτοὺς ταῖς ζωναῖς, καὶ περιθήσεις αὐτοῖς τὰς κιδάρεις· καὶ ἔσται αὐτοῖς ἱερατῖα μοι εἰς τὸν αἰῶνα· καὶ τελειώσεις Ἀαρὼν τὰς χεῖρας αὐτοῦ, καὶ τὰς χεῖρας τῶν υἱῶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Καὶ προσάξεις τὸν μόσχον ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ ἐπιθήσουσιν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ μόσχου, ἔναντι Κυρίου, παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Καὶ σφάξεις τὸν μόσχον ἔναντι Κυρίου, παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Καὶ λήψῃ ἀπὸ τοῦ αἵματος τοῦ μόσχου, καὶ θήσεις ἐπὶ τῶν κεράτων τοῦ θυσιαστηρίου τῷ δακτύλῳ σου· τὸ δὲ λοιπὸν πᾶν αἷμα ἐκχεεῖς παρὰ τὴν βάσιν τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Καὶ λήψῃ πᾶν τὸ στέαρ τὸ ἐπὶ τῆς κοιλίας, καὶ τὸν λοβὸν τοῦ ἥπατος, καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, καὶ ἐπιθήσεις ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Τὰ δὲ κρέατα τοῦ μόσχου, καὶ τὸ δέρμα, καὶ τὴν κόπρον κατακαύσεις πυρὶ ἔξω τῆς παρεμβολῆς· ἁμαρτίας γάρ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Καὶ τὸν κριὸν λήψῃ τὸν ἕνα, καὶ ἐπιθήσουσιν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ κριοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Καὶ σφάξεις αὐτὸν, καὶ λαβὼν τὸ αἷμα προσχεεῖς πρὸς τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Καὶ τὸν κριὸν διχοτομήσεις κατὰ μέλη· καὶ πλυνεῖς τὰ ἐνδόσθια καὶ τοὺς πόδας ὕδατι, καὶ ἐπιθήσεις ἐπὶ τὰ διχοτομήματα σὺν τῇ κεφαλῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Καὶ ἀνοίσεις ὅλον τὸν κριὸν ἐπὶ τὸ θυσιαστήριον, ὁλοκαύτωμα τῷ Κυρίῳ εἰς ὀσμὴν εὐωδίας· θυμίαμα Κυρίῳ ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Καὶ λήψῃ τὸν κριὸν τὸν δεύτερον, καὶ ἐπιθήσει Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ κριοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Καὶ σφάξεις αὐτὸν, καὶ λήψῃ τοῦ αἵματος αὐτοῦ, καὶ ἐπιθήσεις ἐπὶ τὸν λοβὸν τοῦ ὠτὸς Ἀαρὼν τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς δεξιᾶς χειρὸς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς τοῦ δεξιοῦ, καὶ ἐπὶ τοὺς λοβοὺς τῶν ὤτων τῶν υἱῶν αὐτοῦ τῶν δεξιῶν, καὶ ἐπὶ τὰ ἄκρα τῶν χειρῶν αὐτῶν τῶν δεξιῶν, καὶ ἐπὶ τὰ ἄκρα τῶν ποδῶν αὐτῶν τῶν δεξιῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Καὶ λήψῃ ἀπὸ τοῦ αἵματος τοῦ ἀπὸ τοῦ θυσιαστηρίου, καὶ ἀπὸ τοῦ ἐλαίου τῆς χρίσεως, καὶ ῥανεῖς ἐπὶ Ἀαρὼν καὶ ἐπὶ τὴν στολὴν αὐτοῦ, καὶ ἐπὶ τοὺς υἱοὺς αὐτοῦ καὶ ἐπὶ τὰς στολὰς τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ· καὶ ἁγιασθήσεται αὐτὸς καὶ ἡ στολὴ αὐτοῦ, καὶ οἱ υἱοὶ αὐτοῦ καὶ αἱ στολαὶ τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ· τὸ δὲ αἷμα τοῦ κριοῦ προσχεεῖς πρὸς τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Καὶ λήψῃ ἀπὸ τοῦ κριοῦ τὸ στέαρ αὐτοῦ, καὶ τὸ στέαρ τὸ κατακαλύπτον τὴν κοιλίαν, καὶ τὸν λοβὸν τοῦ ἥπατος, καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, καὶ τὸν βραχίονα τὸν δεξιόν· ἔστι γὰρ τελείωσις αὕτη. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Καὶ ἄρτον ἕνα ἐξ ἐλαίου, καὶ λάγανον ἓν ἀπὸ τοῦ κανοῦ τῶν ἀζύμων τῶν προτεθειμένων ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Καὶ ἐπιθήσεις τὰ πάντα ἐπὶ τὰς χεῖρας Ἀαρὼν, καὶ ἐπὶ τὰς χεῖρας τῶν υἱῶν αὐτοῦ· καὶ ἀφοριεῖς αὐτὰ ἀφόρισμα ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Καὶ λήψῃ αὐτὰ ἐκ τῶν χειρῶν αὐτῶν, καὶ ἀνοίσεις ἐπὶ τὸ θυσιαστήριον τῆς ὁλοκαυτώσεως εἰς ὀσμὴν εὐωδίας ἔναντι Κύριου· κάρπωμά ἐστι Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Καὶ λήψῃ τὸ στηθύνιον ἀπὸ τοῦ κριοῦ τῆς τελειώσεως, ὅ ἐστιν Ἀαρών· καὶ ἀφοριεῖς αὐτὸ ἀφόρισμα ἔναντι Κυρίου· καὶ ἔσται σοι ἐν μερίδι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Καὶ ἁγιάσεις τὸ στηθύνιον ἀφόρισμα, καὶ τὸν βραχίονα τοῦ ἀφαιρέματος, ὃς ἀφώρισται, καὶ ὃς ἀφῄρηται ἀπὸ τοῦ κριοῦ τῆς τελειώσεως ἀπὸ τοῦ Ἀαρὼν, καὶ ἀπὸ τῶν υἱῶν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Καὶ ἔσται Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ νόμιμον αἰώνιον παρὰ τῶν υἱῶν Ἰσραήλ· ἔστι γὰρ ἀφόρισμα τοῦτο· καὶ ἀφαίρεμα ἕσται παρὰ τῶν υἱῶν Ἰσραὴλ ἀπὸ τῶν θυμάτων τῶν σωτηρίων τῶν υἱῶν Ἰσραὴλ, ἀφαίρεμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Καὶ ἡ στολὴ τοῦ ἁγίου, ἥ ἐστιν Ἀαρὼν, ἔσται τοῖς υἱοῖς αὐτοῦ μετʼ αὐτὸν, χρισθῆναι αὐτοὺς ἐν αὐτοῖς, καὶ τελειῶσαι τὰς χεῖρας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ἑπτὰ ἡμέρας ἐνδύσεται αὐτὰ ὁ ἱερεὺς ὁ ἀντʼ αὐτοῦ ἐκ τῶν υἱῶν αὐτοῦ, ὃς εἰσελεύσεται εἰς τὴν σκηνὴν τοῦ μαρτυρίου λειτουργεῖν ἐν τοῖς ἁγίοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Καὶ τὸν κριὸν τῆς τελειώσεως λήψῃ· καὶ ἑψήσεις τὰ κρέα ἐν τόπῳ ἁγίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Καὶ ἔδονται Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰ κρέα τοῦ κριοῦ, καὶ τοὺς ἄρτους τοὺς ἐν τῷ κανῷ, παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ἔδονται αὐτὰ ἐν οἷς ἡγιάσθησαν ἐν αὐτοῖς τελειῶσαι τὰς χεῖρας αὐτῶν, ἁγιάσαι αὐτούς· καὶ ἀλλογενὴς οὐκ ἔδεται ἀπʼ αὐτῶν· ἔστι γὰρ ἅγια. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ἐὰν δὲ καταλειφθῇ ἀπὸ τῶν κρεῶν τῆς θυσίας τῆς τελειώσεως καὶ τῶν ἄρτων ἕως πρωῒ, κατακαύσεις τὰ λοιπὰ πυρί· οὐ βρωθήσεται· ἁγίασμα γάρ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Καὶ ποιήσεις Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ οὕτω κατὰ πάντα ὅσα ἐνετειλάμην σοι· ἑπτὰ ἡμέρας τελειώσεις τὰς χεῖρας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Καὶ τὸ μοσχάριον τῆς ἁμαρτίας ποιήσεις τῇ ἡμέρᾳ τοῦ καθαρισμοῦ· καὶ καθαριεῖς τὸ θυσιαστήριον ἐν τῷ ἁγιάζειν σε ἐπʼ αὐτῷ· καὶ χρίσεις αὐτὸ ὥστε ἁγιάσαι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ἑπτὰ ἡμέρας καθαριεῖς τὸ θυσιαστήριον, καὶ ἁγιάσεις αὐτό· καὶ ἔσται τὸ θυσιαστήριον, ἅγιον τοῦ ἁγίου· πᾶς ὁ ἁπτόμενος τοῦ θυσιαστηρίου, ἁγιασθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Καὶ ταῦτά ἐστιν, ἃ ποιήσεις ἐπὶ τοῦ θυσιαστηρίου· ἀμνοὺς ἐνιαυσίους ἀμώμους δύο τὴν ἡμέραν ἐπὶ τὸ θυσιαστήριον ἐνδελεχῶς, κάρπωμα ἐνδελεχισμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Τὸν ἀμνὸν τὸν ἕνα ποιήσεις τὸ πρωῒ, καὶ τὸν ἀμνὸν τὸν δεύτερον ποιήσεις τὸ δειλινόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Καὶ δέκατον σεμιδάλεως πεφυραμένης ἐν ἐλαίῳ κεκομμένῳ τῷ τετάρτῳ τοῦ εἴν· καὶ σπονδὴν τὸ τέταρτον τοῦ εἲν οἴνου τῷ ἀμνῷ τῷ ἑνί. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Καὶ τὸν ἀμνὸν τὸν δεύτερον ποιήσεις τὸ δειλινὸν, κατὰ τὴν θυσίαν τὴν πρωϊνὴν, καὶ κατὰ τὴν σπονδὴν αὐτοῦ· ποιήσεις εἰς ὀσμὴν εὐωδίας κάρπωμα Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","θυσίαν ἐνδελεχισμοῦ εἰς γενεὰς ὑμῶν, ἐπὶ θύρας τῆς σκηνῆς τοῦ μαρτυρίου ἔναντι Κυρίου, ἐν οἷς γνωσθήσομαί σοι ἐκεῖθεν, ὥστε λαλῆσαί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Καὶ τάξομαι ἐκεῖ τοῖς υἱοῖς Ἰσραὴλ, καὶ ἁγιασθήσομαι ἐν δόξῃ μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Καὶ ἁγιάσω τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὸ θυσιαστήριον· καὶ Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ ἁγιάσω, ἱερατεύειν μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Καὶ ἐπικληθήσομαι ἐν τοῖς υἱοῖς Ἰσραὴλ, καὶ ἔσομαι αὐτῶν Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Καὶ γνώσονται, ὅτι ἐγώ εἰμι Κύριος ὁ Θεὸς αὐτῶν, ὁ ἐξαγαγὼν αὐτοὺς ἐκ γῆς Αἰγύπτου, ἐπικληθῆναι αὐτοῖς, καὶ εἶναι αὐτῶν Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Καὶ ποιήσεις θυσιαστήριον θυμιάματος ἐκ ξύλων ἀσήπτων. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Καὶ ποιήσεις αὐτὸ πήχεος τὸ μῆκος, καὶ πήχεος τὸ εὖρος· τετράγωνον ἔσται· καὶ δύο πήχεων τὸ ὕψος· ἐξ αὐτοῦ ἔσται τὰ κέρατα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Καὶ καταχρυσώσεις χρυσίῳ καθαρῷ τὴν ἐσχάραν αὐτοῦ, καὶ τοὺς τοίχους αὐτοῦ κύκλῳ, καὶ τὰ κέρατα αὐτοῦ· καὶ ποιήσεις αὐτῷ στρεπτὴν στεφάνην χρυσῆν κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Καὶ δύο δακτυλίους χρυσοῦς καθαροὺς ποιήσεις ὑπὸ τὴν στρεπτὴν στεφάνην αὐτοῦ, εἰς τὰ δύο κλίτη ποιήσεις ἐν τοῖς δυσὶ πλευροῖς· καὶ ἔσονται ψαλίδες ταῖς σκυτάλαις, ὥστε αἴρειν αὐτὸ ἐν αὐταῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Καὶ ποιήσεις σκυτάλας ἐκ ξύλων ἀσήπτων, καὶ καταχρυσώσεις αὐτὰς χρυσίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Καὶ θήσεις αὐτὸ ἀπέναντι τοῦ καταπετάσματος, τοῦ ὄντος ἐπὶ τῆς κιβωτοῦ τῶν μαρτυρίων, ἐν οἷς γνωσθήσομαί σοι ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Καὶ θυμιάσει ἐπʼ αὐτοῦ Ἀαρὼν θυμίαμα σύνθετον λεπτὸν τὸ πρωῒ πρωΐ· ὅταν ἐπισκευάζῃ τοὺς λύχνους, θυμιάσει ἐπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Καὶ ὅταν ἐξάπτῃ Ἀαρὼν τοὺς λύχνους ὀψὲ, θυμιάσει ἐπʼ αὐτοῦ. θυμίαμα ἐνδελεχισμοῦ διαπαντὸς ἔναντι Κυρίου εἰς γενεὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Καὶ οὐκ ἀνοίσει ἐπʼ αὐτοῦ θυμίαμα ἕτερον· κάρπωμα, θυσίαν, και σπονδὴν οὐ σπείσεις ἐπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Καὶ ἐξιλάσεται ἐπʼ αὐτοῦ Ἀαρὼν ἐπὶ τῶν κεράτων αὐτοῦ ἅπαξ τοῦ ἐνιαυτοῦ· ἀπὸ τοῦ αἵματος τοῦ καθαρισμοῦ καθαριεῖ αὐτὸ εἰς γενεὰς αὐτῶν· ἅγιον τῶν ἁγίων ἐστὶ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Καὶ ἑλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","ἐὰν λάβῃς τὸν συλλογισμὸν τῶν υἱῶν Ἰσραὴλ ἐν τῇ ἐπισκοπῇ αὐτῶν, καὶ δώσουσιν ἕκαστος λύτρα τῆς ψυχῆς αὐτοῦ Κυρίῳ, καὶ οὐκ ἔσται ἐν αὐτοῖς πτῶσις ἐν τῇ ἐπισκοπῇ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Καὶ τοῦτό ἐστιν ὅ δώσουσιν ὅσοι ἂν παραπορεύωνται τὴν ἐπίσκεψιν· τὸ ἥμισυ τοῦ διδράχμου ὅ ἐστιν κατὰ τὸ δίδραχμον τὸ ἅγιον, εἴκοσι ὀβολοὶ τὸ δίδραχμον, τὸ δὲ ἥμισυ τοῦ διδράχμου εἰσφορὰ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Πᾶς ὁ παραπορευόμενος εἰς τὴν ἐπίσκεψιν ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, δώσουσι τὴν εἰσφορὰν Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ὁ πλουτῶν οὐ προσθήσει, καὶ ὁ πενόμενος οὐκ ἐλαττονήσει ἀπὸ τοῦ ἡμίσεως τοῦ διδράχμου ἐν τῷ διδόναι τὴν εἰσφορὰν Κυρίῳ, ἐξιλάσασθαι περὶ τῶν ψυχῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Καὶ λήψῃ τὸ ἀργύριον τῆς εἰσφορᾶς παρὰ τῶν υἱῶν Ἰσραήλ, καὶ δώσεις αὐτὸ εἰς τὸ κάτεργον τῆς σκηνῆς τοῦ μαρτυρίου· καὶ ἔσται τοῖς υἱοῖς Ἰσραὴλ μνημόσυνον ἔναντι Κυρίου, ἐξιλάσασθαι περὶ τῶν ψυχῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","ποίησον λουτῆρα χαλκοῦν, καὶ βάσιν αὐτῷ χαλκῆν, ὥστε νίπτεσθαι· καὶ θήσεις αὐτὸν ἀνὰ μέσον τῆς σκηνῆς τοῦ μαρτυρίου καὶ ἀνὰ μέσον τοῦ θυσιαστηρίου· καὶ ἐκχεεῖς εἰς αὐτὸν ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Καὶ νίψεται Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ ἑξ αὐτοῦ τὰς χεῖρας, καὶ τοὺς πόδας ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ὅταν εἰσπορεύωνται εἰς τὴν σκηνὴν τοῦ μαρτυρίου, νίψονται ὕδατι, καὶ οὐ μὴ ἀποθάνωσιν, ὅταν προσπορεύωνται πρὸς τὸ θυσιαστήριον λειτουργεῖν καὶ ἀναφέρειν τὰ ὁλοκαυτώματα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Νίψονται τὰς χεῖρας καὶ τοὺς πόδας ὕδατι, ὅταν εἰσπορεύωνται εἰς τὴν σκηνὴν τοῦ μαρτυρίου, νίψονται ὕδατι, ἵνα μὴ ἀποθάνωσι· καὶ ἔσται αὐτοῖς νόμιμον αἰώνιον, αὐτῷ καὶ ταῖς γενεαῖς αὐτοῦ μετʼ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","καὶ σὺ λάβε ἡδύσματα, τὸ ἄνθος σμύρνης ἐκλεκτῆς πεντακοσίους σίκλους, καὶ κινναμώμου εὐώδους τὸ ἥμισυ τούτου διακοσίους πεντήκοντα, καὶ καλάμου εὐώδους διακοσίους πεντήκοντα, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","καὶ ἴρεως πεντακοσίους σίκλους τοῦ ἁγίου, καὶ ἔλαιον ἐξ ἐλαιῶν εἵν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Καὶ ποιήσεις αὐτὸ ἔλαιον χρίσμα ἅγιον, μύρον μυρεψικὸν τέχνῃ μυρεψοῦ· ἔλαιον χρίσμα ἅγιον ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Καὶ χρίσεις ἐξ αὐτοῦ τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὴν κιβωτὸν τῆς σκηνῆς τοῦ μαρτυρίου, καὶ πάντα τὰ σκεύη αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","καὶ τὴν λυχνίαν καὶ πάντα τὰ σκεύη αὐτῆς, καὶ τὸ θυσιαστήριον τοῦ θυμιάματος, ");
INSERT INTO grcbrent_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","καὶ τὸ θυσιαστήριον τῶν ὁλοκαυτωμάτων καὶ πάντα αὐτοῦ τὰ σκεύη, καὶ τὴν τράπεζαν καὶ πάντα τὰ σκεύη αὐτῆς, καὶ τὸν λουτῆρα. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Καὶ ἁγιάσεις αὐτά· καὶ ἔσται ἅγια τῶν ἁγίων· πᾶς ὁ ἁπτόμενος αὐτῶν, ἁγιασθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Καὶ Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ χρίσεις, καὶ ἁγιάσεις αὐτοὺς ἱερατεύειν μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Καὶ τοῖς υἱοῖς Ἰσραὴλ λαλήσεις, λέγων, ἔλαιον ἄλειμμα χρίσεως ἅγιον ἔσται τοῦτο ὑμῖν εἰς τὰς γενεὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ἐπὶ σάρκα ἀνθρώπου οὐ χρισθήσεται· καὶ κατὰ τὴν σύνθεσιν ταύτην οὐ ποιήσετε ὑμῖν ἑαυτοῖς ὡσαύτως· ἅγιόν ἐστιν, καὶ ἁγίασμα ἔσται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ὃς ἂν ποιήσῃ ὡσαύτως, καὶ ὃς ἂν δῷ ἀπʼ αὐτοῦ ἀλλογενεῖ, ἐξολοθρευθήσεται ἐκ τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λάβε σεαυτῷ ἡδύσματα, στακτήν, ὄνυχα, χαλβάνην ἡδυσμοῦ καὶ λίβανον διαφανῆ· ἴσον ἴσῳ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Καὶ ποιήσουσιν ἐν αὐτῷ θυμίαμα μυρεψικὸν ἔργον μυρεψοῦ μεμιγμένον, καθαρὸν ἔργον ἅγιον. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Καὶ συνκόψεις ἐκ τούτων λεπτόν, καὶ θήσεις ἀπέναντι τῶν μαρτυρίων ἐν τῇ σκηνῇ τοῦ μαρτυρίου, ὅθεν γνωσθήσομαί σοι ἐκεῖθεν· ἅγιον τῶν ἁγίων ἔσται ὑμῖν θυμίαμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Κατὰ τὴν σύνθεσιν ταύτην οὐ ποιήσετε ὑμῖν ἐαυτοῖς· ἁγίασμα ἔσται ὑμῖν Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ὃς ἂν ποιήσῃ ὡσαύτως ὥστε ὀσφραίνεσθαι ἐν αὐτῷ, ἀπολεῖται ἐκ τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","ἰδοὺ ἀνακέκλημαι ἐξ ὀνόματος τὸν Βεσελεὴλ τὸν τοῦ Οὐρείου τὸν Ὣρ, ἐκ τῆς φυλῆς Ἰούδα. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Καὶ ἐνέπλησα αὐτὸν πνεῦμα θεῖον σοφίας καὶ συνέσεως καὶ ἐπιστήμης, ἐν παντὶ ἔργῳ διανοεῖσθαι, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","καὶ ἀρχιτεκτονῆσαι, ἐργάζεσθαι τὸ χρυσίον, καὶ τὸ ἀργύριον, καὶ τὸν χαλκὸν, καὶ τὴν ὑάκινθον, καὶ τὴν πορφύραν, καὶ τὸ κόκκινον τὸ νηστὸν, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","καὶ τὰ λιθουργικὰ, καὶ εἰς τὰ ἔργα τὰ τεκτονικὰ τῶν ξύλων, ἐργάζεσθαι κατὰ πάντα τὰ ἔργα. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Καὶ ἐγὼ ἔδωκα αὐτὸν καὶ τὸν Ἐλιὰβ τὸν τοῦ Ἀχισαμὰχ ἐκ φυλῆς Δάν· καὶ παντὶ συνετῷ καρδίᾳ δέδωκα σύνεσιν· ");
INSERT INTO grcbrent_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","καὶ πονήσουσι πάντα ὅσα συνέταξά σοι, τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὴν κιβωτὸν τῆς διαθήκης, καὶ τὸ ἱλαστήριον τὸ ἐπʼ αὐτῆς, καὶ τὴν διασκευὴν τῆς σκηνῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","καὶ τὰ θυσιαστήρια, καὶ τὴν τράπεζαν καὶ πάντα τὰ σκεύη αὐτῆς, καὶ τὴν λυχνίαν τὴν καθαρὰν καὶ πάντα τὰ σκεύη αὐτῆς ");
INSERT INTO grcbrent_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","καὶ τὸν λουτῆρα καὶ τὴν βάσιν αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","καὶ τὰς στολὰς τὰς λειτουργικὰς Ἀαρὼν, καὶ τὰς στολὰς τῶν υἱῶν αὐτοῦ ἱερατεύειν μοι, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","καὶ τὸ ἔλαιον τῆς χρίσεως, καὶ τὸ θυμίαμα τῆς συνθέσεως τοῦ ἁγίου· κατὰ πάντα ὅσα ἐγὼ ἐνετειλάμην σοι, ποιήσουσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Καὶ σὺ σύνταξον τοῖς υἱοῖς Ἰσραὴλ, λέγων, Ὁρᾶτε, καὶ τὰ σάββατά μου φυλάξεσθε· σημεῖόν ἐστι παρʼ ἐμοὶ καὶ ἐν ὑμῖν εἰς τὰς γενεὰς ὑμῶν, ἵνα γνῶτε ὅτι ἐγὼ Κύριος ὁ ἁγιάξων ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","καὶ φυλάξεσθε τὰ σάββατα, ὅτι ἅγιον τοῦτό ἐστι Κυρίῳ ὑμῖν· ὁ βεβηλῶν αὐτὸ, θανάτῳ θανατωθήσεται· πᾶς ὃς ποιήσει ἐν αὐτῷ ἔργον, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ μέσου τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ἓξ ἡμέρας ποιήσεις ἔργα, τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ σάββατα, ἀνάπαυσις ἁγία τῷ κυρίῳ· πᾶς ὃς ποιήσει ἔργον τῇ ἡμέρᾳ τῇ ἑβδόμῃ θανατωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Καὶ φυλάξουσιν οἱ υἱοὶ Ἰσραὴλ τὰ σάββατα, ποιεῖν αὐτὰ εἰς τὰς γενεὰς αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Διαθήκη αἰώνιος ἐν ἐμοὶ καὶ τοῖς υἱοῖς Ἰσραὴλ, σημεῖόν ἐστιν ἐν ἐμοὶ αἰώνιον· ὅτι ἓξ ἡμεραις ἐποίησε Κύριος τὸν οὐρανὸν καὶ τὴν γῆν, καὶ τῇ ἡμέρᾳ τῇ ἑβδόμῃ κατέπαυσε, καὶ ἐπαύσατο. ");
INSERT INTO grcbrent_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Καὶ ἔδωκε Μωυσῇ ἡνίκα κατέπαυσε λαλῶν αὐτῷ ἐν τῷ ὄρει τῷ Σινὰ, τὰς δύο πλάκας τοῦ μαρτυρίου, πλάκας λιθίνας γεγραμμένας τῷ δακτύλῳ τοῦ Θεοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Καὶ ἰδὼν ὁ λαὸς, ὅτι κεχρόνικε Μωυσῆς καταβῆναι ἐκ τοῦ ὄρους, συνέστη ὁ λαὸς ἐπὶ Ἀαρὼν, καὶ λέγουσιν αὐτῷ ἀνάστηθι, καὶ ποίησον ἡμῖν θεοὺς, οἳ προπορεύσονται ἡμῶν· ὁ γὰρ Μωυσῆς οὗτος ὁ ἄνθρωπος ὃς ἐξήγαγεν ἡμᾶς ἐκ γῆς Αἰγύπτου, οὐκ οἴδαμεν τί γέγονεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Καὶ λέγει αὐτοῖς Ἀαρὼν Περιέλεσθε τὰ ἐνώτια τὰ χρυσᾶ τὰ ἐν τοῖς ὠσὶ τῶν γυναικῶν ὑμῶν καὶ θυγατέρων, καὶ ἐνέγκατε πρός με. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Καὶ περιείλαντο πᾶς ὁ λαὸς τὰ ἐνώτια τὰ χρυσᾶ τὰ ἐν τοῖς ὠσὶν αὐτῶν, καὶ ἤνεγκαν πρὸς Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Καὶ ἐδέξατο ἐκ τῶν χειρῶν αὐτῶν, καὶ ἔπλασεν αὐτὰ ἐν τῇ γραφίδι· καὶ ἐποίησεν αὐτὰ μόσχον χωνευτὸν καὶ εἶπεν, Οὗτοι οἱ θεοί σου Ἰσραὴλ, οἵτινες ἀνεβίβασάν σε ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Καὶ ἰδὼν Ἀαρὼν ᾠκοδόμησε θυσιαστήριον κατέναντι αὐτοῦ· καὶ ἐκήρυξεν Ἀαρὼν λέγων, ἑορτὴ τοῦ κυρίου αὔριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Καὶ ὀρθρίσας τῇ ἐπαύριον ἀνεβίβασεν ὁλοκαυτώματα, καὶ προσήνεγκε θυσίαν σωτηρίου· καὶ ἐκάθισεν ὁ λαὸς φαγεῖν καὶ πιεῖν, καὶ ἀνέστησαν παίζειν. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, βάδιζε τὸ τάχος, κατάβηθι ἐντεύθεν· ἠνόμησε γὰρ ὁ λαός σου ὃν ἐξήγαγες ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Παρέβησαν ταχὺ ἐκ τῆς ὁδοῦ, ἧς ἐνετείλω αὐτοῖς· ἐποίησαν ἑαυτοῖς μόσχον, καὶ προσκεκυνήκασιν αὐτῷ, καὶ τεθύκασιν αὐτῷ, καὶ εἶπαν, Οὗτοι οἱ θεοί σου Ἰσραὴλ, οἵτινες ἀνεβίβασάν σε ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","καὶ νῦν ἔασόν με, καὶ θυμωθεὶς ὀργῇ εἰς αὐτοὺς, ἐκτρίψω αὐτούς· καὶ ποιήσω σὲ εἰς ἔθνος μέγα. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","καὶ ἐδεήθη Μωυσῆς ἔναντι Κυρίου τοῦ Θεοῦ, καὶ εἶπεν, ἱνατί, Κύριε, θυμοῖ ὀργῇ εἰς τὸν λαόν σου, οὓς ἐξήγαγες ἐκ γῆς Αἰγύπτου ἐν ἰσχύϊ μεγάλῃ, καὶ ἐν τῷ βραχίονί σου τῷ ὑψηλῷ; ");
INSERT INTO grcbrent_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Μή ποτε εἴπωσιν οἱ Αἰγύπτιοι λέγοντες Μετὰ πονηρίας ἐξήγαγεν αὐτοὺς ἀποκτεῖναι ἐν τοῖς ὄρεσιν καὶ ἐξαναλῶσαι αὐτοὺς ἀπὸ τῆς γῆς. παῦσαι τῆς ὀργῆς τοῦ θυμοῦ σου, καὶ ἵλεως γενοῦ ἐπὶ τῇ κακίᾳ τοῦ λαοῦ σου, ");
INSERT INTO grcbrent_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","μνησθεὶς Ἀβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ τῶν σῶν οἰκετῶν, οἷς ὤμοσας κατὰ σεαυτοῦ, καὶ ἐλάλησας πρὸς αὐτοὺς, λέγων, πολυπληθυνῶ τὸ σπέρμα ὑμῶν ὡσεὶ τὰ ἄστρα τοῦ οὐρανοῦ τῷ πλήθει· καὶ πᾶσαν τὴν γῆν ταύτην ἣν εἶπας δοῦναι αὐτοῖς, καὶ καθέξουσιν αὐτὴν εἰς τὸν αἰῶνα. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Καὶ ἱλάσθη Κύριος περιποιῆσαι τὸν λαὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Καὶ ἀποστρέψας Μωυσῆς, κατέβη ἀπὸ τοῦ ὄρους· καὶ αἱ δύο πλάκες τοῦ μαρτυρίου ἐν ταῖς χερσὶν αὐτοῦ, πλάκες λίθιναι καταγεγραμμέναι ἐξ ἀμφοτέρων τῶν μερῶν αὐτῶν, ἔνθεν καὶ ἔνθεν ἦσανς γεγραμμέναι· ");
INSERT INTO grcbrent_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","καὶ αἱ πλάκες ἔργον Θεοῦ ἦσαν, καὶ ἡ γραφὴ γραφὴ Θεοῦ κεκολαμμένη ἐν ταῖς πλαξί. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","καὶ ἀκούσας Ἰησοῦς τῆς φωνῆς τοῦ λαοῦ κραζόντων, λέγει πρὸς Μωυσὴν, Φωνὴ πολέμου ἐν τῇ παρεμβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","καὶ λέγει Οὐκ ἔστι φωνὴ ἐξαρχόντων κατʼ ἰσχὺν, οὐδὲ φωνὴ ἐξαρχόντων τροπῆς, ἀλλὰ φωνὴν ἐξαρχόντων οἴνου ἐγὼ ἀκούω. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","καὶ ἡνίκα ἤγγιζε τῇ παρεμβολῇ, ὁρᾷ τὸν μόσχον καὶ τοὺς χορούς· καὶ ὀργισθεὶς θυμῷ Μωυσῆς ἔῤῥιψεν ἀπὸ τῶν χειρῶν αὐτοῦ τὰς δύο πλάκας, καὶ συνέτριψεν αὐτὰς ὑπὸ τὸ ὄρος· ");
INSERT INTO grcbrent_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","καὶ λαβὼν τὸν μόσχον ὃν ἐποίησαν, κατέκαυσεν αὐτὸν ἐν πυρὶ, καὶ κατήλεσεν αὐτὸν λεπτὸν, καὶ ἔσπειρεν αὐτὸν ὑπὸ τὸ ὕδωρ, καὶ ἐπότισεν αὐτὸ τοὺς υἱοὺς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","καὶ εἶπε Μωυσῆς τῷ Ἀαρὼν, Τί ἐποίησέ σοι ὁ λαὸς οὗτος, ὅτι ἐπήγαγες ἐπʼ αὐτοὺς ἁμαρτίαν μεγάλην; ");
INSERT INTO grcbrent_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","καὶ εἶπεν Ἀαρὼν πρὸς Μωυσῆν, μὴ ὀργίζου, κύριε· σὺ γὰρ οἶδας τὸ ὅρμημα τοῦ λαοῦ τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Λέγουσι γάρ μοι, ποιήσον ἡμῖν θεοὺς, οἳ προπορεύσονται ἡμῶν· ὁ γὰρ Μωυσῆς οὗτος ὁ ἄνθρωπος, ὃς ἐξήγαγεν ἡμᾶς ἐξ Αἰγύπτου, οὐκ οἴδαμεν τί γέγονεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","καὶ εἶπα αὐτοῖς, εἴ τινι ὑπάρχει χρυσία, περιέλεσθε· καὶ ἔδωκάν μοι· καὶ ἔῤῥιψα εἰς τὸ πῦρ· καὶ ἐξῆλθεν ὁ μόσχος οὗτος. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Καὶ ἰδὼν Μωυσῆς τὸν λαὸν ὅτι διεσκέδασται· (διεσκέδασε γὰρ αὐτοὺς Ἀαρών ἐπίχαρμα τοῖς ὑπεναντίοις αὐτῶν) ");
INSERT INTO grcbrent_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ἔστη δὲ Μωυσῆς ἑπὶ τῆς πύλης τῆς παρεμβολῆς, καὶ εἶπε, τίς πρὸς Κύριον; ἴτω πρός με. Συνῆλθον οὖν πρὸς αὐτὸν πάντες οἱ υἱοὶ Λευί. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Καὶ λέγει αὐτοῖς τάδε λέγει Κύριος ὁ Θεὸς Ἰσραήλ θέσθε ἕκαστος τὴν ἑαυτοῦ ῥομφαίανν ἐπὶ τὸν μηρὸν, καὶ διέλθατε καὶ ἀνακάμψατε ἀπὸ πύλης ἐπὶ πύλην διὰ τῆς παρεμβολῆς, καὶ ἀποκτείνατε ἕκαστος τὸν ἀδελφὸν αὐτοῦ, καὶ ἕκαστος τὸν πλησίον αὐτοῦ, καὶ ἓκαστος τὸν ἔγγιστα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Καὶ ἐποίησαν οἱ υἱοὶ Λευεὶ καθὰ ἐλάλησεν αὐτοῖς Μωυσῆς· καὶ ἔπεσαν ἐκ τοῦ λαοῦ ἐν ἐκείνῃ τῇ ἡμέρᾳ εἰς τρισχιλίους ἄνδρας. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Καὶ εἶπεν αὐτοῖς Μωυσῆς, ἐπληρώσατε τὰς χεῖρας ὑμῶν σήμερον Κυρίῳ ἕκαστος ἐν τῷ υἱῷ ἢ ἐν τῷ ἀδελφῷ αὐτοῦ, δοθῆναι ἐφʼ ὑμᾶς εὐλογίαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Καὶ ἐγένετο μετὰ τὴν αὔριον εἶπε Μωυσῆς πρὸς τὸν λαὸν, ὑμεῖς ἡμαρτήκατε ἁμαρτίαν μεγάλη· καὶ νῦν ἀναβήσομαι πρὸς τὸν Θεὸν, ἵνα ἐξιλάσωμαι περὶ τῆς ἁμαρτίας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ὑπέστρεψε δὲ Μωυσῆς πρὸς Κύριον, καὶ εἶπε, δέομαι, κύριε· ἡμάρτηκεν ὁ λαὸς οὗτος ἁμαρτίαν μεγάλην, καὶ ἐποίησαν ἑαυτοῖς θεοὺς χρυσοῦς. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Καὶ νῦν εἰ μὲν ἀφεῖς αὐτοῖς τὴν ἁμαρτίαν αὐτῶν, ἄφες· εἰ δὲ μή, ἐξάλειψόν με ἐκ τῆς βίβλου σου, ἧς ἔγραψας. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, εἴ τις ἡμάρτηκεν ἐνώπιόν μου, ἐξαλείψω αὐτοὺς ἐκ τῆς βίβλου μου. ");
INSERT INTO grcbrent_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Νυνὶ δὲ βάδιζε, κατάβηθι, καὶ ὁδήγησον τὸν λαὸν τοῦτον εἰς τὸν τόπον, ὃν εἶπά σοι· ἰδοὺ ὁ ἄγγελός μου προπορεύσεται πρὸ προσώπου σου· ᾖ δʼ ἂν ἡμέρᾳ ἐπισκέπτωμαι, ἐπάξω ἐπʼ αὐτοὺς τὴν ἁμαρτίαν αὐτῶν ");
INSERT INTO grcbrent_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Καὶ ἐπάταξε Κύριος τὸν λαὸν περὶ τῆς ποιήσεως τοῦ μόσχου, οὗ ἐποίησεν Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆς, προπορεύου, ἀνάβηθι ἐντεῦθεν σὺ καὶ ὁ λαός σου, οὓς ἐξήγαγες ἐκ γῆς Αἰγύπτου, εἰς τὴν γῆν, ἣν ὤμοσα τῷ Ἀβραὰμ, καὶ Ἰσαὰκ, καὶ Ἰακὼβ, λέγων, Τῷ σπέρματι ὑμῶν δώσω αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Καὶ συναποστελῶ τὸν ἄγγελόν μου πρὸ προσώπου σου· καὶ ἐκβαλεῖ τὸν Ἀμοῤῥαῖον, καὶ Χετταῖον, καὶ Φερεζαῖον, καὶ Γεργεσαῖον, καὶ Εὐαῖον, καὶ Ἰεβουσαῖον, καὶ Χαναναῖον. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Καὶ εἰσάξω σε εἰς γῆν ῥέουσαν γάλα καὶ μέλι· οὐ γὰρ μὴ συναναβῶ μετὰ σου, διὰ τὸ λαὸν σκληροτράχηλόν σε εἶναι, ἵνα μὴ ἐξαναλώσω σεε ἐν τῇ ὁδῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Καὶ ἀκούσας ὁ λαὸς τὸ ῥῆμα τὸ πονηρὸν τοῦτο, κατεπένθησεν ἐν πενθικοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Καὶ εἶπε Κύριος τοῖς υἱοῖς Ἰσραὴλ, ὑμεῖς λαὸς σκληροτράχηλος· ὁρᾶτε, μὴ πληγὴν ἄλλην ἐπάξω ἐγὼ ἐφʼ ὑμᾶς, καὶ ἐξαναλώσω ὑμᾶς· νῦν οὖν ἀφέλεσθε τὰς στολὰς τῶν δοξῶν ὑμῶν, καὶ τὸν κόσμον, καὶ δείξω σοι ἃ ποιήσω σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Καὶ περιέλαντο οἱ υἱοὶ Ἰσραὴλ τὸν κόσμον αὐτῶν, καὶ τὴν περιστολὴν ἀπὸ τοῦ ὄρους τοῦ Χωρήβ. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Καὶ λαβὼν Μωυσῆς τὴν σκηνὴν αὐτοῦ, ἔπηξεν ἔξω τῆς παρεμβολῆς, μακρὰν ἀπὸ τῆς παρεμβολῆς· καὶ ἐκλήθν Σκηνὴ μαρτυρίου· καὶ ἐγένετο, πᾶς ὁ ζητῶν Κύριον ἐξεπορεύετο εἰς τὴν σκηνὴν τὴν ἔξω τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ἡνίκα δʼ ἂν εἰσεπορεύετο Μωυσῆς εἰς τὴν σκηνὴν ἔξω τῆς παρεμβολῆς, εἱστήκει πᾶς ὁ λαὸς σκοπεύοντες ἕκαστος παρὰ τὰς θύρας τῆς σκηνῆς αὐτοῦ· καὶ κατενοοῦσαν ἀπιόντος Μωυσῆ ἕως τοῦ εἰσελθεῖν αὐτὸν εἰς τὴν σκηνὴν. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ὡς δʼ ἂν εἰσῆλθε Μωσῆς εἰς τὴν σκηνήν, κατέβαινεν ὁ στύλος τῆς νεφέλης, καὶ ἵστατο ἐπὶ τὴν θύραν τῆς σκηνῆς, καὶ ἐλάλει Μωσῇ· ");
INSERT INTO grcbrent_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","καὶ ἐλάλει Μωυσῇ. Καὶ ἑώρα πᾶς ὁ λαὸς τὸν στύλον τῆς νεφέλης ἑστῶτα ἐπὶ τῆς θύρας τῆς σκηνῆς· καὶ στάντες πᾶς ὁ λαὸς, προσεκύνησαν ἕκαστος ἀπὸ τῆς θύρας τῆς σκηνῆς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, ἐνώπιος ἐνωπίῳ, ὡς εἴτις λαλήσει πρὸς τὸν ἑαυτοῦ φίλον· καὶ ἀπελύετο εἰς τὴν παρεμβολήν· ὁ δὲ θεράπων Ἰησοῦς υἱὸς Ναυὴ νέος οὐκ ἐξεπορεύετο ἐκ τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Καὶ εἶπε Μωυσῆς, πρὸς Κύριον, Ἰδοὺ σύ μοι λέγεις, ἀνάγαγε τὸν λαὸν τοῦτον, σὺ δὲ οὐκ ἐδήλωσάς μοι, ὃν συναποστελεῖς μετʼ ἐμοῦ· σὺ δέ μοι εἶπας, Οἶδά σε παρὰ πάντας, καὶ χάριν ἔχεις παρʼ ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Εἰ οὖν εὕρηκα χάριν ἐναντίον σου, ἐμφάνισόν μοι σεαυτόν· γνωστῶς ἴδω ἴδω σε, ὅπως ἂν ὦ εὑρηκὼς χάριν ἐναντίον σου,, καὶ ἵνα γνῶ, ὅτι λαός σου τὸ ἔθνος τὸ μέγα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Καὶ λέγει, αὐτὸς προπορεύσομαί σου, καὶ καταπαύσω σε. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Καὶ λέγει πρὸς αὐτόν, εἰ μὴ αὐτὸς σὺ σνμπορεύῃ, μή με ἀναγάγῃς ἐντεῦθεν. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Καὶ πῶς γνωστὸν ἔσται ἀληθῶς, ὅτι εὕρηκα χάριν παρὰ σοί ἐγώ τε καὶ ὁ λαός σου, ἀλλʼ ἢ συμπορευομένου σου μεθʼ ἡμῶν; καὶ ἐνδοξασθήσομαι ἐγώ τε καὶ ὁ λαός σου παρὰ πάντα τὰ ἔθνη, ὅσα ἐπὶ τῆς γῆς ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, Καὶ τοῦτόν σοι τὸν λόγον, ὃν εἴρηκας ποιήσω· εὕρηκας, ποιήσω· εὕρηκας γὰρ χάριν ἐνώπιον ἐμοῦ, καὶ οἶδά σε παρὰ πάντας. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Καὶ λέγει, ἐμφάνισόν μοι σεαυτόν. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Καὶ εἶπεν, ἐγὼ παρελεύσομαι πρότερός σου τῇ δόξῃ μου, καὶ καλέσω τῷ ὀνόματί μου, Κύριος ἐναντίον σου· καὶ ἐλεήσω, ὃν ἂν ἐλεῶ, καὶ οἰκτειρήσω, ὃν ἂν οἰκτείρῶ. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Καὶ εἶπε, οὐ δυνήσῃ ἰδεῖν τὸ πρόσωπόν μου· οὐ γὰρ μὴ ἴδῃ ἄνθρωπος τὸ πρόσωπόν μου, καὶ ζήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Καὶ εἶπεν Κύριος, Ἰδοὺ τόπος παρʼ ἐμοί, στήσῃ ἐπὶ τῆς πέτρας· ");
INSERT INTO grcbrent_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ἡνίκα δʼ ἂν παρέλθηνᾑ ᾑ δόξα μου, καί θήσω σε εἰς ὀπὴν τῆς πέτρας, καὶ σκεπάσω τῇ χειρί μου ἐπὶ σὲ, ἕως ἂν παρέλθω. ");
INSERT INTO grcbrent_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Καὶ ἀφελῶ τὴν χεῖρα, καὶ τότε ὄψει τὰ ὀπίσω μου· τὸ δὲ πρόσωπόν μου οὐκ ὀφθήσεταί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν λαξευσον σεαυτῷ δύο πλάκας λιθίνας, καθὼς καὶ αἱ πρῶται, καὶ ἀνάβηθι πρὸς μὲ εἰς τὸ ὄρος, καὶ γράψω ἐπὶ τῶν πλακῶν τὰ ῥήματα ἃ ἦν ἐν ταῖς πλαξὶ ταῖς πρώταις, αἷς συνέτριψας. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Καὶ γίνου ἕτοιμος εἰς τὸ πρωί, καὶ ἀναβήσῃ ἐπὶ τὸ ὄρος τὸ Σινά, καὶ στήσῃ μοι ἐκεῖ ἐπʼ ἄκρου τοῦ ὄρους. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Καὶ μηδεὶς ἀναβήτω μετὰ σοῦ μηδὲ ὀφθήτω ἐν παντὶ τῷ ὄρει· καὶ τὰ πρόβατα καὶ βόες μὴ νεμέσθωσαν πλησίον τοῦ ὄρους ἐκείνου. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Καὶ ἐλάξευσε δύο πλάκας λιθίνας, καθάπερ καὶ αἱ πρῶται· καὶ ὀρθρίσας Μωυσῆς, ἀνέβη εἰς τὸ ὄρος τὸ Σινὰ, καθότι συνέταξεν αὐτῷ Κύριος· καὶ ἔλαβε Μωυσῆς τὰς δύο πλάκας τὰς λιθίνας. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Καὶ κατέβη Κύριος ἐν νεφέλῃ, καὶ παρέστη αὐτῷ ἐκεῖ, καὶ ἐκάλεσε τῷ ὀνόματι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Καὶ παρῆλθε Κύριος πρὸ προσώπου αὐτοῦ, καὶ ἐκάλεσε κύριος ὁ Θεὸς οἰκτείρμων καὶ ἐλεήμων, μακρόθυμος καὶ πολυέλεος καὶ ἀληθινός, ");
INSERT INTO grcbrent_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","καὶ δικαιοσύνην διατηρῶν καὶ ἔλεος εἰς χιλιάδας, ἀφαιρῶν ἀνομίας καὶ ἀδικίας καὶ ἁμαρτίας, καὶ οὐ καθαριεῖ τὸν ἔνοχον, ἐπάγων ἀνομίας πατέρων ἐπὶ τέκνα καὶ ἐπὶ τέκνα τέκνων ἐπὶ τρίτην καὶ τετάρτην γενεάν. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Καὶ σπεύσας Μωσῆς κύψας ἐπὶ τὴν γῆν προσεκύνησε· ");
INSERT INTO grcbrent_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","καὶ εἶπεν, εἰ εὕρηκα χάριν ἐνώπιόν σου, συμπορευθήτω ὁ Κύριός μου μεθʼ ἡμῶν· ὁ λαὸς γὰρ σκληροτράχηλός ἐστι, καὶ ἀφελεῖς σὺ τὰς ἁμαρτίας ἡμῶν, καὶ τὰς ἀνομίας ἡμῶν, καὶ ἐσόμεθά σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, Ἰδοὺ, ἐγὼ τίθημί σοι διαθήκην ἐνώπιον παντὸς τοῦ λαοῦ σοῦ, ποιήσω ἔνδοξα, ἃ οὐ γέγονεν ἐν πάσῃ τῇ γῇ, καὶ ἐν παντὶ ἔθνει· καὶ ὄψεται πᾶς ὁ λαὸς, ἐν οἷς εἶ σὺ, τὰ ἔργα Κυρίου, ὅτι θαυμαστά ἐστιν, ἃ ἐγὼ ποιήσω σοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Πρόσεχε σὺ πάντα ὅσα ἐγὼ ἐντέλλομαί σοι· ἰδοὺ ἐγὼ ἐκβάλλω πρὸ προσώπου ὑμῶν τὸν Ἀμοῤῥαῖον, καὶ Χαναναῖον, καὶ Φερεζαῖον, καὶ Χετταῖον, καὶ Εὑαῖον, καὶ Γεργεσαῖον, καὶ Ἰεβουσαῖον. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Πρόσεχε σεαυτῷ, μή ποτε θῇς διαθήκην τοῖς ἐγκαθημένοις ἐπὶ τῆς γῆς, εἰς ἣν εἰσπορεύῃ εἰς αὐτὴν, μή σοι γένηται πρόσκομμα ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Τοὺς βωμοὺς αὐτῶν καθελεῖτε, καὶ τὰς στήλας αὐτῶν συντρίψετε, καὶ τὰ ἄλση αὐτῶν ἐκκόψετε, καὶ τὰ γλυπτὰ τῶν θεῶν αὐτῶν κατακαύσετε ἐν πυρί. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Οὐ γὰρ μὴ προσκυνήσητε θεοῖς ἑτέροις· ὁ γὰρ Κύριος ὁ Θεὸς, ζηλωτὸν ὄνομα, Θεὸς ζηλωτής ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Μή ποτε θῇς διαθήκην τοῖς ἔγκαθημένοις ἐπὶ τῆς γῆς, καὶ ἐκπορνεύσωσιν ὀπίσω τῶν θεῶν αὐτῶν, καὶ θύσωσι τοῖς θεοῖς αὐτῶν, καὶ καλέσωσίν σε, καὶ φάγῃς τῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","καὶ λάβῃς τῶν θυγατέρων αὐτῶν τοῖς υἱοῖς σου, καὶ τῶν θυγατέρων σου δῷς τοῖς υἱοῖς αὐτῶν, καὶ ἐκπορνεύσωσιν αἱ θυγατέρες σου ὀπίσω τῶν θεῶν αὐτῶν, καὶ ἐκπορνεύσωσιν οἱ υἱοί σου ὀπίσω τῶν θεῶν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Καὶ θεοὺς χωνευτοὺς οὐ ποιήσεις σεαυτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Καὶ τὴν ἑσρτὴν τῶν ἀζύμων φυλάξῃ· ἑπτὰ ἡμέρας φαγῃ ἄζυμα, καθάπερ ἐντέταλμαί σοι, εἰς τὸν καιρὸν ἐν μηνὶ τῶν νέων· ἐν γὰρ μηνὶ τῶν νέων ἐξῆλθες ἐξ Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Πᾶν διανοῖγον μήτραν, ἐμοὶ τὰ ἀρσενικὰ, πᾶν πρωτότοκον μόσχου, καὶ πρωτότοκον προβάτου. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Καὶ πρωτότοκον ὑποζυγίου λυτρώσῃ προβάτῳ· ἐὰν δὲ μὴ λυτρώσῃ αὐτὸ, τιμὴν δώσεις. πᾶν πρωτότοκον τῶν υἱῶν σου λυτρώσῃ· οὐκ ὀφθήσῃ ἐνώπιόν μου κενός. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ἓξ ἡμέρας ἐργᾷ, τῇ δὲ ἑβδόμῃ καταπαύσεις· τῷ σπόρῳ καὶ τῷ ἀμητῷ κατάπαυσις. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Καὶ ἑορτὴν ἑβδομάδων ποιήσεις μοι, ἀρχὴν θερισμοῦ πυροῦ· καὶ ἐορτὴν συναγωγῆς μεσοῦντος τοῦ ἐνιαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Τρεῖς καιροὺς τοῦ ἐνιαυτοῦ ὀφθήσεται πᾶν ἀρσενικόν σου ἐνώπιον Κυρίου τοῦ Θεοῦ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ὅταν γὰρ ἐκβάλω τὰ ἔθνη πρὸ προσώπου σου, καὶ πλατυνῶ τὰ ὅριά σου, οὐκ ἐπιθυμήσει οὐδεὶς τῆς γῆς σου, ἡνίκα ἂν ἀναβαίνῃς ὀφθῆναι ἐναντίον Κυρίου τοῦ Θεοῦ σου, τρεῖς καιροὺς τοῦ ἐνιαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Οὐ σφάξεις ἐπὶ ζύμῃ αἷμα θυμιαμάτων μου, καὶ οὐ κοιμηθήσεται εἰς τὸ πρωῒ θύματα ἑορτῆς τοῦ πάσχα. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Τὰ πρωτογεννήματα τῆς γῆς σου θήσεις εἰς τὸν οἶκον Κυρίου τοῦ Θεοῦ σου· οὐχ ἑψήσεις ἄρνα ἐν γάλακτι μητρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, γράψον σεαυτῷ τὰ ῥήματα ταῦτα· ἐπὶ γὰρ τῶν λόγων τούτων τέθειμαί σοι διαθήκην, καὶ τῷ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Καὶ ἦν ἐκεῖ Μωυσῆς ἐναντίον Κυρίου τεσσεράκοντα ἡμέρας, καὶ τεσσεράκοντα νύκτας· ἄρτον οὐκ ἔφαγε, καὶ ὕδωρ οὐκ ἔπιε· καὶ ἔγραψεν ἐπὶ τῶν πλακῶν τὰ ῥήματα ταῦτα τῆς διαθήκης, τοὺς δέκα λόγους. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ὡς δὲ κατέβαινε Μωυσῆς ἐκ τοῦ ὄρους, καὶ αἱ δύο πλάκες ἐπὶ τῶν χειρῶν Μωυσῆ· καταβαίνοντος δὲ αὐτοῦ ἐκ τοῦ ὄρους, Μωυσῆς οὐκ ᾔδει ὅτι δεδόξασται ἡ ὄψις τοῦ χρώματος τοῦ προσώπου αὐτοῦ ἐν τῷ λαλεῖν αὐτὸν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Καὶ εἶδεν Ἀαρὼν καὶ πάντες οἱ πρεσβύτεροι Ἰσραὴλ τὸν Μωυσῆν, καὶ ἦν δεδοξασμένη ἡ ὄψις τοῦ χρώματος τοῦ προσώπου αὐτοῦ. καὶ ἐφοβήθησαν ἐγγίσαι αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Καὶ ἐκάλεσεν αὐτοὺς Μωυσῆς, καὶ ἐπεστράφησαν πρὸς αὐτὸν Ἀαρὼν καὶ πάντες οἱ ἄρχοντες τῆς συναγωγῆς· καὶ ἐλάλησεν αὐτοῖς Μωυσῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Καὶ μετὰ ταῦτα προσῆλθον πρὸς αὐτὸν πάντες οἱ υἱοὶ Ἰσραήλ. καὶ ἐνετείλατο αὐτοῖς πάντα, ὅσα ἐνετείλατο Κύριος πρὸς αὐτὸν ἐν τῷ ὄρει Σινά. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Καὶ ἐπειδὴ κατέπαυσε λαλῶν πρὸς αὐτοὺς, ἐπέθηκεν ἐπὶ τὸ πρόσωπον αὐτοῦ κάλυμμα. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ἡνίκα δʼ ἂν εἰσεπορεύετο Μωυσῆς, ἔναντι Κυρίου λαλεῖν αὐτῷ, περιῃρεῖτο τὸ κάλυμμα ἕως τοῦ ἐκπορεύεσθαι· καὶ ἐξελθὼν ἐλάλει πᾶσι τοῖς υἱοῖς Ἰσραὴλ ὅσα ἐνετείλατο αὐτῷ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Καὶ εἶδον οἱ υἱοὶ Ἰσραὴλ τὸ πρόσωπον Μωυσέως, ὅτι δεδόξασται· καὶ περιέθηκε Μωυσῆς κάλυμμα ἐπὶ τὸ πρόσωπον ἑαυτοῦ, ἕως ἂν εἰσέλθῃ συλλαλεῖν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Καὶ συνήθροισε Μωυσῆς πᾶσαν συναγωγὴν υἱῶν Ἰσραὴλ, καὶ εἶπεν, οὗτοι οἱ λόγοι, οὓς εἶπε Κύριος ποιῆσαι αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ἓξ ἡμέρας ποιήσεις ἔργα, τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ κατάπαυσις· ἅγια, σάββατα· ἀνάπαυσις Κυρίῳ· πᾶς ὁ ποιῶν ἔργον ἐν αὐτῇ, τελευτάτω. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Οὐ καύσετε πῦρ ἐν πάσῃ κατοικίᾳ ὑμῶν τῇ ἡμέρᾳ τῶν σαββάτων· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Καὶ εἶπε Μωυσῆς πρὸς πᾶσαν συναγωγὴν υἱῶν Ἰσραὴλ, λέγων, τοῦτο τὸ ῥῆμα, ὃ συνέταξε Κύριος, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","λάβετε παρʼ ὑμῶν αὐτῶν ἀφαίρεμα Κυρίῳ· πᾶς ὁ καταδεχόμενος τῇ καρδίᾳ, οἴσουσι τὰς ἀπαρχὰς Κυρίῳ, χρυσίον, ἀργύριον, χαλκὸν, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ὑάκινθον, πορφύραν, κόκκινον διπλοῦν διανενησμένον, καὶ βύσσον κεκλωσμένην, καὶ τρίχας αἰγείας, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","καὶ δέρματα κριῶν ἠρυθροδανωμένα, καὶ δέρματα ὑακινθινα, καὶ ξύλα ἄσηπτα, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","καὶ λίθους σαρδίου, καὶ λίθους εἰς τὴν γλυφὴν εἰς τὴν ἐπωμίδα καὶ τὸν ποδήρη. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Καὶ πᾶς σοφὸς τῇ καρδίᾳ ἐν ὑμῖν, ἐλθὼν ἐργαζέσθω πάντα ὅσα συνέταξε Κύριος· ");
INSERT INTO grcbrent_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Τὴν σκηνὴν, καὶ τὰ παραρύματα, καὶ τὰ κατακαλύμματα, καὶ τὰ διατόνια, καὶ τοὺς μοχλοὺς, καὶ τοὺς στύλους, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","καὶ τὴν κιβωτὸν τοῦ μαρτυρίου, καὶ τοὺς ἀναφορεῖς αὐτῆς, καὶ τὸ ἱλαστήριον αὐτῆς, καὶ τὸ καταπέτασμα, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_12a","003_35_12a","EXO","35","12a","12a","καὶ τὰ ἱστία τῆς αὐλῆς, καὶ τοὺς στύλους αὐτῆς, καὶ τοὺς λίθους τοὺς τῆς σμαράγδου, καὶ τὸ θυμίαμα, καὶ τὸ ἔλαιον τοῦ χρίσματος, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","καὶ τὴν τράπεζαν καὶ πάντα τὰ σκεύη αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","καὶ τὴν λυχνίαν τοῦ φωτὸς καὶ πάντα τὰ σκεύη αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","καὶ τὸ θυσιαστήριον καὶ πάντα τὰ σκεύη αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","καὶ τὰς στολὰς τὰς ἁγίας Ἀαρὼν τοῦ ἱερέως, καὶ τὰς στολὰς ἐν αἷς λειτουργήσουσιν ἐν αὐταῖς, καὶ τοὺς χιτῶνας τοῖς υἱοῖς Ἀαρὼν τῆς ἱερατίας, καὶ τὸ ἔλαιον τοῦ χρίσματος, καὶ τὸ θυμίαμα τῆς συνθέσεως. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Καὶ ἐξῆλθε πᾶσα συναγωγὴ υἱῶν Ἰσραὴλ ἀπὸ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Καὶ ἤνεγκαν ἕκαστος, ὧν ἔφερεν ἡ καρδία αὐτῶν, καὶ ὅσοις ἔδοξε τῇ ψυχῇ αὐτῶν, ἀφαίρεμα· καὶ ἤνεγκαν ἀφαίρεμα Κυρίῳ εἰς πάντα τὰ ἔργα τῆς σκηνῆς τοῦ μαρτυρίου, καὶ εἰς πάντα τὰ κάτεργα αὐτῆς καὶ εἰς πάσας τὰς στολὰς τοῦ ἁγίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Καὶ ἤνεγκαν οἱ ἄνδρες παρὰ τῶν γυναικῶν, πᾶς ᾧ ἔδοξε τῇ διανοίᾳ, ἤνεγκαν σφραγίδας, καὶ ἐνώτια, καὶ δακτυλίους, καὶ ἐμπλόκια, καὶ περιδέξια, πᾶν σκεῦος χρυσοῦν. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Καὶ πάντες ὅσοι ἤνεγκαν ἀφαιρέματα χρυσίου Κυρίῳ, καὶ παρʼ ᾧ εὑρέθη βύσσος· καὶ δέρματα ὑακίνθινα καὶ δέρματα κριῶν ἠρυθροδανωμένα ἤνεγκαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Καὶ πᾶς ὁ ἀφαιρῶν ἀφαίρεμα, ἤνεγκαν ἀργύριον καὶ χαλκὸν, τὰ ἀφαιρέματα Κυρίῳ· καὶ παρʼ οἷς εὑρέθη ξύλα ἄσηπτα· καὶ εἰς πάντα τὰ ἔργα τῆς παρασκευῆς ἤνεγκαν. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Καὶ πᾶσα γυνὴ σοφὴ τῇ διανοίᾳ ταῖς χερσὶ νήθειν, ἤνεγκαν νενησμένα, τὴν ὑάκινθον, καὶ τὴν πορφύραν, καὶ τὸ κόκκινον, καὶ τὴν βύσσον. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Καὶ πᾶσαι αἱ γυναῖκες, αἷς ἔδοξε τῇ διανοίᾳ αὐτῶν ἐν σοφίᾳ, ἔνησαν τὰς τρίχας τὰς αἰγείας. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Καὶ οἱ ἄρχοντες ἤνεγκαν τοὺς λίθους τῆς σμαράγδου, καὶ τοὺς λίθους τῆς πληρώσεως εἰς τὴν ἐπωμίδα, καὶ τὸ λογεῖον, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","καὶ τὰς συνθέσεις, καὶ εἰς τὸ ἔλαιον τῆς χρίσεως, καὶ τὴν συνθεσιν τοῦ θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Καὶ πᾶς ἀνὴρ καὶ γυνὴ, ὧν ἔφερεν ἡ διάνοια αὐτῶν εἰσελθόντας ποιεῖν πάντα τὰ ἔργα, ὅσα συνέταξε Κύριος ποιῆσαι αὐτὰ διὰ Μωυσῆ, ἤνεγκαν οἱ υἱοὶ Ἰσραὴλ, ἀφαίρεμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Καὶ εἶπε Μωυσῆς τοῖς υἱοῖς Ἰσραὴλ, Ἰδοὺ ἀνακέκληκεν ὁ Θεὸς ἐξ ὀνόματος τὸν Βεσελεὴλ τὸν τοῦ Οὐρείου τὸν Ὢρ, ἐκ τῆς φυλῆς Ἰούδα, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","καὶ ἐνέπλησεν αὐτὸν πνεῦμα θεῖον σοφίας καὶ συνέσεως, καὶ ἐπιστήμης πάντων, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ἀρχιτεκτονεῖν κατὰ πάντα τὰ ἔργα τῆς ἀρχιτεκτονίας, ποιεῖν τὸ χρυσίον καὶ τὸ ἀργύριον καὶ τὸν χαλκόν, ");
INSERT INTO grcbrent_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","καὶ λιθουργῆσαι τὸν λίθον, καὶ κατεργάζεσθαι τὰ ξύλα, καὶ ποιεῖν ἐν παντὶ ἔργῳ σοφίας. ");
INSERT INTO grcbrent_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Καὶ προβιβάσαι γε ἔδωκεν ἐν τῇ διανοίᾳ αὐτῷ τε, καὶ τῷ Ἐλιὰβ τῷ τοῦ Ἀχισαμὰκ, ἐκ φυλῆς Δάν· ");
INSERT INTO grcbrent_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Καὶ ἐνέπλησεν αὐτοὺς σοφίας, συνέσεως, διανοίας, πάντα συνιέναι ποιῆσαι τὰ ἔργα τοῦ ἁγίου, καὶ τὰ ὑφαντὰ καὶ ποικιλτὰ ὑφάναι τῷ κοκκίνῳ, καὶ τῇ βύσσῳ, ποιεῖν πᾶν ἔργον ἀρχιτεκτονίας, ποικιλίας. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Καὶ ἐποίησε Βεσελεὴλ καὶ Ἐλιὰβ, καὶ πᾶς σοφὸς τῇ διανοὶᾳ, ᾧ ἐδόθη σοφία καὶ ἐπιστήμη ἐν αὑτοῖς, συνιέναι ποιεῖν πάντα τὰ ἔργα, κατὰ τὰ ἅγια καθήκοντα, κατὰ πάντα ὅσα συνέταξε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Καὶ ἐκάλεσε Μωυσῆς Βεσελεὴλ καὶ Ἐλιὰβ, καὶ πάντας τοὺς ἔχοντας τὴν σοφίαν, ᾧ ἔδωκεν ὁ Θεὸς ἐπιστήμην ἐν τῇ καρδίᾳ, καὶ πάντας τοὺς ἑκουσίως βουλομένους προσπορεύεσθαι πρὸς τὰ ἔργα, ὥστε συντελεῖν αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Καὶ ἔλαβον παρὰ Μωσῆ πάντα τὰ ἀφαιρέματα, ἃ ἤνεγκαν οἱ υἱοὶ Ἰσραὴλ εἰς πάντα τὰ ἔργα τοῦ ἁγίου ποιεῖν αὐτά· καὶ αὐτοὶ προσεδέχοντο ἔτι τὰ προσφερόμενα παρὰ τῶν φερόντων τὸ πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Καὶ παρεγίνοντο πάντες οἱ σοφοὶ οἱ ποιοῦντες τὰ ἔργα τοῦ ἁγίου, ἕκαστος κατὰ τὸ αὐτοῦ ἔργον, ὃ εἰργάζοντο αὐτοί. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Καὶ εἶπε πρὸς Μωυσῆν, ὅτι πλῆθος φέρει ὁ λαὸς κατὰ τὰ ἔργα ὅσα συνέταξε Κύριος ποιῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Καὶ προσέταξε Μωυσῆς, καὶ ἐκήρυξεν ἐν τῇ παρεμβολῇ, λέγων, ἀνὴρ καὶ γυνὴ μηκέτι ἐργαζέσθωσαν εἰς τάς ἀπαρχὰς τοῦ ἁγίου· καὶ ἐκωλύθη ὁ λαὸς ἔτι προσφέρειν. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Καὶ τὰ ἔργα ἦν αὐτοῖς ἱκανὰ εἰς τὴν κατασκευὴν ποιῆσαι, καὶ προσκατέλιπον. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Καὶ ἐποίησε πᾶς σοφὸς ἐν τοῖς ἐργαζομένοις τὰς στολὰς τῶν ἁγίων, αἵ εἰσιν Ἀαρὼν τῷ ἱερεῖ, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Καὶ ἐποίησε τὴν ἐπωμίδα ἐκ χρυσίου, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, καὶ βύσσου κεκλωσμένης· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","καὶ ἐτμήθη τὰ πέταλα τοῦ χρυσίου τρίχες, ὥστε συνυφάναι σὺν τῇ ὑακίνθῳ, καὶ τῇ πορφύρᾳ, καὶ σὺν τῷ κοκκίνῳ τῷ διανενησμένῳ, καὶ τῇ βύσσῳ τῇ κεκλωσμένῃ· ἔργον ὑφαντὸν ἐποίησαν αὐτό· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ἐπωμίδας συνεχούσας ἐξ ἀμφοτέρων τῶν μερῶν, ἔργον ὑφαντὸν εἰς ἄλληλα συμπεπλεγμένα καθʼ ἑαυτό. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ἐξ αὐτοῦ ἐποίησαν αὐτὸ κατὰ τὴν αὐτοῦ ποίησιν, ἐκ χρυσίου, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου διανενησμένου, καὶ βύσσου κεκλωσμένης, καθὰ συνέταξε Κύριος τῷ Μωυσῇ· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","καὶ ἐποίησαν ἀμφοτέρους τοὺς λίθους τῆς σμαράγδου συνπεπορπημένους καὶ περισεσιαλωμένους χρυσίῳ, γεγλυμμένους καὶ ἐκκεκολαμμένους ἐγκόλαμμα σφραγίδος ἐκ τῶν ὀνομάτων τῶν υἱῶν Ἰσραήλ· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","καὶ ἐπέθηκεν αὐτοὺς ἐπὶ τοὺς ὤμους τῆς ἐπωμίδος, λίθους μνημοσύνου τῶν υἱῶν Ἰσραὴλ, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Καὶ ἐποίησαν λογεῖον, ἔργον ὑφαντὸν ποικιλίᾳ κατὰ τὸ ἔργον τῆς ἐπωμίδος, ἐκ χρυσίου, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου διανενησμένου, καὶ βύσσου κεκλωσμένης· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","τετράγωνον διπλοῦν ἐπόησαν τὸ λογεῖον· σπιθαμῆς τὸ μῆκος, καὶ σπιθαμῆς τὸ εὖρος διπλοῦν. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Καὶ συνυφάνθη ἐν αὐτῷ ὕφασμα κατάλιθον τετράστιχον· στίχος λίθων, σάρδιον καὶ τοπάζιον καὶ σμάραγδος, ὁ στίχος ὁ εἷς· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","καὶ ὁ στίχος ὁ δεύτερος, ἄνθραξ καὶ σάπφειρος καὶ ἴασπις· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","καὶ ὁ στίχος ὁ τρίτος, λιγύριον καὶ ἀχάτης καὶ ἀμέθυστος· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","καὶ ὁ στίχος ὁ τέταρτος, χρυσόλιθος καὶ βηρύλλιον καὶ ὀνύχιον περικεκυκλωμένα χρυσίῳ, καὶ συνδεδεμένα χρυσίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Καὶ οἱ λίθοι ἦσαν ἐκ τῶν ὀνομάτων τῶν υἱῶν Ἰσραὴλ δώδεκα, ἐκ τῶν ὀνομάτων αὐτῶν ἐγγεγλυμμένα εἰς σφραγίδας, ἕκαστος ἐκ τοῦ ἑαυτοῦ ὀνόματος εἰς τὰς δώδεκα φυλάς. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Καὶ ἐποίησαν ἐπὶ τὸ λογεῖον κρωσσοὺς συμπεπλεγμένους, ἔργον ἐμπλοκίου, ἐκ χρυσίου καθαροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Καὶ ἐποίησαν δύο ἀσπιδίσκας χρυσᾶς, καὶ δύο δακτυλίους χρυσοῦς· καὶ ἐπέθηκαν τοὺς δύο δακτυλίους τοὺς χρυσοῦς ἐπʼ ἀμφοτέρας τὰς ἀρχὰς τοῦ λογείου. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Καὶ ἐπέθηκαν τὰ ἐμπλόκια ἐκ χρυσίου ἐπὶ τοὺς δακτυλίους ἐπʼ ἀμφοτέρων τῶν μερῶν τοῦ λογείου· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","καὶ εἰς τὰς δύο συμβολὰς τὰ δύο ἐμπλόκια. Καὶ ἐπέθηκαν ἐπὶ τὰς δύο ἀσπιδίσκας· καὶ ἐπέθηκαν ἐπὶ τοὺς ὤμους τῆς ἐπωμίδος ἐξεναντίας κατὰ πρόσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Καὶ ἐποίησαν δύο δακτυλίους χρυσοῦς, καὶ ἐπέθηκαν ἐπὶ τὰ δύο πτερύγια ἐπʼ ἄκρου τοῦ λογείου, καὶ ἐπὶ τὸ ἄκρον τοῦ ὀπισθίου τῆς ἐπωμίδος ἔσωθεν· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Καὶ ἐποίησαν δύο δακτυλίους χρυσοῦς, καὶ ἐπέθηκαν ἐπʼ ἀμφοτέρους τοὺς ὤμους τῆς ἐπωμίδος κάτωθεν αὐτοῦ, κατὰ πρόσωπον κατὰ τὴν συμβολὴν ἄνωθεν τῆς συνυφῆς τῆς ἐπωμίδος· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","καὶ συνέσφιγξε τὸ λογεῖον ἀπὸ τῶν δακτυλίων τῶν ἐπʼ αὐτοῦ εἰς τοὺς δακτυλίους τῆς ἐπωμίδος, συνεχομένους ἐκ τῆς ὑακίνθου, συμπεπλεγμένους εἰς τὸ ὕφασμα τῆς ἐπωμίδος, ἵνα μὴ χαλᾶται τὸ λογεῖον ἀπὸ τῆς ἐπωμίδος, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Καὶ ἐποίησαν τὸν ὑποδύτην ὑπὸ τὴν ἐπωμίδα, ἔργον ὑφαντὸν, ὅλον ὑακίνθινον· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","τὸ δὲ περιστόμιον τοῦ ὑποδύτου ἐν τῷ μέσῳ διυφασμένον συμπλεκτὸν, ὤαν ἔχον κύκλῳ τὸ περιστόμιονν ἀδιάλυτον· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Καὶ ἐποίησαν ἐπὶ τοῦ λώματος τοῦ ὑποδύτου κάτωθεν ὡς ἐξανθούσης ῥόας ῥοΐσκους, ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, καὶ βύσσου κεκλωσμένης. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Καὶ ἐποίησαν κώδωνας χρυσοῦς, καὶ ἐπέθηκαν τοὺς κώδωνας ἐπὶ τὸ λῶμα τοῦ ὑποδύτου κύκλῳ ἀνὰ μέσον τῶν ῥοΐσκων· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","κώδων χρυσοῦς καὶ ῥοΐσκος ἐπὶ τοῦ λώματος τοῦ ὑποδύτου κύκλῳ, εἰς τὸ λειτουργεῖν, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Καὶ ἐποίησαν χιτῶνας βυσσίνους, ἔργον ὑφαντὸν, Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","καὶ τὰς κιδάρεις ἐκ βύσσου, καὶ τὴν μίτραν ἐκ βύσσου, καὶ τὰ περισκελῆ ἐκ βύσσου κεκλωσμένης, ");
INSERT INTO grcbrent_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","καὶ τὰς ζώνας αὐτῶν ἐκ βύσσου, καὶ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, ἔργον ποικιλτοῦ, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Καὶ ἐποίησαν τὸ πέταλον τὸ χρυσοῦν, ἀφόρισμα τοῦ ἁγίου, χρυσίου καθαροῦ· καὶ ἔγραψεν ἐπʼ αὐτοῦ γράμματα ἐκτετυπωμένα, σφραγίδος, Ἁγίασμα Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Καὶ ἐπέθηκαν ἐπὶ τὸ λῶμα ὑακίνθινον, ὥστε ἐπικεῖσθαι ἐπὶ τὴν μίτραν ἄνωθεν, ὅν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Καὶ ἐποίησαν τῇ σκηνῇ δέκα αὐλαίας· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ὀκτὼ καὶ εἴκοσι πήχεων μῆκος τῆς αὐλαίας τῆς μιᾶς· τὸ αὐτὸ ἦν πάσαις· καὶ τεσσάρων πήχεων τὸ εὖρος τῆς αὐλαίας τῆς μιᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","καὶ ἐποίησαν τὸ καταπέτασμα ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, καὶ βύσσου κεκλωσμένης, ἔργον ὑφαντὸυ χερουβείμ· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","καὶ ἐπέθηκαν αὐτὸ ἐπὶ τέσσαρας στύλους ἀσήπτους κατακεχρυσωμένους ἐν χρυσίῳ· καὶ αἱ κεφαλίδες αὐτῶν χρυσαῖ, καὶ αἱ βάσεις αὐτῶν τέσσαρες ἀργυραῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","καὶ ἐποίησαν τὸ καταπέτασμα τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, καὶ βύσσου κεκλωσμένης, ἔργον ὑφαντὸντοῦ χερουβείμ· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","καὶ τοὺς στύλους αὐτῶν πέντε, καὶ τοὺς κρίκους· καὶ τὰς κεφαλίδας αὐτῶν, καὶ τὰς ψαλίδας αὐτῶν κατεχρύσωσαν χρυσίῳ· καὶ αἱ βάσεις αὐτῶν πέντε χαλκαῖ. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Καὶ ἐποίησαν τὴν αὐλῆν τὰ πρὸς Λίβα, ἱστία τῆς αὐλῆς ἐκ βύσσου κεκλωσμένης ἑκατὸν ἐφʼ ἑκατόν· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","καὶ οἱ στύλοι αὐτῶν εἴκοσι, καὶ αἱ βάσεις αὐτῶν εἴκοσι. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","καὶ τὸ κλίτος τὸ πρὸς Βοῤῥᾶν, ἑκατὸν ἐφʼ ἑκατόν· καὶ τὸ κλίτος τὸ πρὸς Νότον, ἑκατὸν ἐφʼ ἑκατόν· καὶ οἱ στύλοι αὐτῶν εἴκοσι, καὶ αἱ βάσεις αὐτῶν εἴκοσι· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Καὶ τὸ κλίτος τὸ πρὸς θάλασσαν αὐλαῖαι πεντήκοντα πήχεων· στύλοι αὐτῶν δέκα, καὶ αἱ βάσεις αὐτῶν δέκα· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Καὶ τὸ κλίτος τὸ πρὸς ἀνατολὰς πεντήκοντα πήχεων ἱστία, πεντεαίδεκα πήχεων τὸ κατὰ νώτου· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","καὶ οἱ στύλοι αὐτῶν τρεῖς, καὶ αἱ βάσεις αὐτῶν τρεῖς· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Καὶ ἐπὶ τοῦ νώτου τοῦ δευτέρου ἔνθεν καὶ ἔνθεν κατὰ τὴν πύλην τῆς αὐλῆς, αὐλαῖαι πεντεκαίδεκα πήχεων· στύλοι αὐτῶν τρεῖς, καὶ αἱ βάσεις αὐτῶν τρεῖς· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","πᾶσαι αἱ αὐλαῖαι τῆς σκηνῆς ἐκ βύσσου κεκλωσμένης. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Καὶ αἱ βάσεις τῶν στύλων αὐτῶν χαλκαῖ, καὶ αἱ ἀγκύλαι αὐτῶν ἀργυραῖ, καὶ αἱ κεφαλίδες αὐτῶν περιηργυρωμέναι ἀργυρίῳ, καὶ οἱ στύλοι περιηργυρωμένοι ἀργυρίῳ πάντες οἱ στύλοι τῆς αὐλῆς· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","καὶ τὸ καταπέτασμα τῆς πύλης τῆς αὐλῆς ἔργον ποικιλτοῦ ἐξ ὑακίνθου, καὶ πορφύρας, καὶ κοκκίνου νενησμένου, καὶ βύσσου κεκλωσμένης· εἴκοσι πήχεων τὸ μῆκος, καὶ τὸ ὕψος καὶ τὸ εὖρος πέντε πήχεων ἐξισούμενον τοῖς ἱστίοις τῆς αὐλῆς· ");
INSERT INTO grcbrent_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","καὶ οἱ στύλοι αὐτῶν τέσσαρες, καὶ αἱ βάσεις αὐτῶν τέσσαρες χαλκαῖ, καὶ αἱ ἀγκύλαι αὐτῶν ἀργυραῖ, καὶ αἱ κεφαλίδες αὐτῶν περιηργυρωμέναι ἀργυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Καὶ πάντες οἱ πάσσαλοι τῆς αὐλῆς κύκλῳ χαλκοῖ, καὶ αὐτοὶ περιηργυρωμένοι ἀργυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Καὶ αὕτη ἡ σύνταξις τῆς σκηνῆς τοῦ μαρτυρίου, καθὰ συνετάγη Μωυσῇ, τὴν λειτουργίαν εἶναι τῶν Λευιτῶν διὰ Ἰθάμαρ τοῦ υἱοῦ Ἀαρὼν τοῦ ἱερέως. ");
INSERT INTO grcbrent_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Καὶ Βεσελεὴλ ὁ τοῦ Οὐρείου, ἐκ φυλῆς Ἰούδα, ἐποίησε καθὰ συνέταξε Κύριος τῷ Μωυσῇ, ");
INSERT INTO grcbrent_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","καὶ Ἐλιὰβ ὁ τοῦ Ἀχισαμὰχ ἐκ φυλῆς Δὰν, ὅς ἠρχιτεκτόνησε τὰ ὑφαντὰ καὶ τὰ ῥαφιδευτὰ καὶ ποικιλτικά, ὑφάναι τῷ κοκκίνῳ καὶ τῇ βύσσῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Καὶ ἐποίησε Βεσελεὴλ τὴν κιβωτόν, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","καὶ κατεχρύσωσεν αὐτὴν χρωσίῳ καθαρῷ ἔσωθεν καὶ ἔξωθεν· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","καὶ ἐχώνευσεν αὐτῇ τέσσαρας δακτυλίους χρυσοῦς· δύο ἐπὶ τὸ κλίτος τὸ ἓν, καὶ δύο ἐπὶ τὸ κλίτος τὸ δεύτερον, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","εὐρεῖς τοῖς διωστῆρσιν, ὥστε αἴρειν αὐτὴν ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Καὶ ἐποίησε τὸ ἱλαστήριον ἐπάνωθεν τῆς κιβωτοῦ ἐκ χρυσίου καθαροῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","καὶ τοὺς δύο χερουβεὶμ χρυσοῦς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","χεροὺβ ἕνα ἐπὶ τὸ ἄκρον τοῦ ἱλαστηρίου τὸ ἓν, καὶ χεροὺβ ἕνα ἐπὶ τὸ ἄκρον τοῦ ἱλαστηρίου τὸ δεύτερον, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","σκιάζοντα ταῖς πτέρυξιν αὐτῶν ἐπὶ τὸ ἱλαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Καὶ ἐποίησε τὴν τράπεζαν τὴν προκειμένην ἐκ χρυσίου καθαροῦ, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","καὶ ἐχώνευσεν αὐτῇ τέσσαρας δακτυλίους, δύο ἐπὶ τοῦ κλίτους τοῦ ἑνὸς, καὶ δύο ἐπὶ τοῦ κλίτους τοῦ δευτέρου, εὐρεῖς, ὥστε αἴρειν τοῖς διωστῆρσιν ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Καὶ τοὺς διωστῆρας τῆς κιβωτοῦ καὶ τῆς τραπέζης ἐποίησε, καὶ κατεχρύσωσεν αὐτοὺς χρυσίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Καὶ ἐποίησε τὰ σκεύη τῆς τραπέζης, τά τε τρυβλία, καὶ τὰς θυίσκας, καὶ τοὺς κυάθους, καὶ τὰ σπονδεῖα, ἐν οἷς σπείσει ἐν αὐτοῖς, χρυσᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Καὶ ἐποίησε τὴν λυχνίαν ἣ φωτίζει, χρυσῆν, ");
INSERT INTO grcbrent_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","στερεὰν τὸν καυλόν, καὶ τοὺς καλαμίσκους ἐξ ἀμφοτέρων τῶν μερῶν αὐτῆς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ἐκ τῶν καλαμίσκων αὐτῆς οἱ βλαστοὶ ἐκ τῶν καλαμίσκων αὐτῆς οἱ βλαστοὶ ἐξέχοντες· τρεῖς ἐκ τούτου, καὶ τρεῖς ἐκ τούτου, ἐξισούμενοι ἀλλήλοις. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Καὶ τὰ λαμπάδια αὐτῶν, ἅ ἐστιν ἐπὶ τῶν ἄκρων, καρυωτὰ ἐξ αὐτῶν· καὶ τὰ ἐνθέμια ἐξ αὐτῶν, ἵνα ὦσιν οἱ λύχνοι ἐπʼ αὐτῶν· καὶ τὸ ἐνθέμιον τὸ ἕβδομον, τὸ ἐπʼ ἄκρου τοῦ λαμπαδίου, ἐπὶ τῆς κορυφῆς ἄνωθεν, στερεὸν ὅλον χρυσοῦν· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Καὶ ἑπτὰ λύχνους ἐπʼ αὐτῆς χρυσοῦς, καὶ τὰς λαβίδας αὐτῆς χρυσᾶς, καὶ τὰς ἐπαρυστρίδας αὐτῶν χρυσᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Οὗτος περιηργύρωσε τοὺς στύλους, καὶ ἐχώνευσε τῷ στύλῳ δακτυλίους χρυσοῦς, καὶ ἐχρύσωσε τοὺς μοχλοὺς χρυσίῳ, καὶ κατεχρύσωσε τοὺς στύλους τοῦ καταπετάσματος χρυσίῳ, καὶ ἐποίησε τὰς ἀγκύλας χρυσᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Οὗτος ἐποίησε καὶ τοὺς κρίκους τῆς σκηνῆς χρυσοῦς, καὶ τοὺς κρίκους τῆς αὐλῆς, καὶ κρίκους εἰς τὸ ἐκτείνειν τὸ κατακάλυμμα ἄνωθεν χαλκοῦς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Οὗτος ἐχώνευσε τὰς κεφαλίδας τὰς ἀργυρᾶς τῆς σκηνῆς, καὶ τὰς κεφαλίδας τὰς χαλκᾶς τῆς θύρας τῆς σκηνῆς, καὶ τὴν πύλην τῆς αὐλῆς· καὶ ἀγκύλας ἐποίησε τοῖς στύλοις ἀργυρᾶς, ἐπὶ τῶν στύλων οὗτος περιηργύρωσεν αὐτάς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Οὗτος ἐποίησε τοὺς πασσάλους τῆς σκηνῆς, καὶ τοὺς πασσάλους τῆς αὐλῆς χαλκοῦς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Οὗτος ἐποίησε τὸ θυσιαστήριον τὸ χαλκοῦν ἐκ τῶν πυρείων τῶν χαλκῶν, ἃ ἦσαν τοῖς ἀνδράσιν τοῖς καταστασιάσασι μετὰ τῆς Κορὲ συναγωγῆς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Οὗτος ἐποίησε πάντα τὰ σκεύη τοῦ θυσιαστηρίου, καὶ τὸ πυρεῖον αὐτοῦ, καὶ τὴν βάσιν, καὶ τὰς φιάλας, καὶ τὰς κρεάγρας τὰς χαλκᾶς· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Οὗτος ἐποίησε θυσιαστηρίῳ παράθεμα, ἔργον δικτυωτὸν κάτωθεν τοῦ πυρείου ὑπὸ αὐτὸ ἕως τοῦ ἡμίσους αὐτοῦ· καὶ ἐπέθηκεν αὐτῷ τέσσαρας δακτυλίους ἐκ τῶν τεσσάρων μερῶν τοῦ παραθέματος τοῦ θυσιαστηρίου χαλκοῦς, εὐρεῖς τοῖς μοχλοῖς, ὥστε αἴρειν ἐν αὐτοῖς τὸ θυσιαστήριον· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Οὗτος ἐποίησε τὸ ἔλαιον τῆς χρίσεως τὸ ἅγιον, καὶ τὴν σύνθεσιν τοῦ θυμιάματος καθαρὸν ἔργον μυρεψοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Οὗτος ἐποίησε τὸν λουτῆρα τὸν χαλκοῦν, καὶ τὴν βάσιν αὐτοῦ χαλκῆν ἐκ τῶν κατόπτρων τῶν νηστευσασῶν, αἳ ἐνήστευσαν παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, ἐν ᾗ ἡμέρᾳ ἔπηξεν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Καὶ ἐποίησε τὸν λουτῆρα, ἵνα νίπτωνται ἐξ αὐτοῦ Μωυσῆς καὶ Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν καὶ τοὺς πόδας, εἰσπορευομένων αὐτῶν εἰς τὴν σκηνὴν τοῦ μαρτυρίου, ἢ ὅταν προσπορεύωνται πρὸς τὸ θυσιαστήριον λειτουργεῖν, ἐνίπτοντο ἐξ αὐτοῦ, καθάπερ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Πᾶν τὸ χρυσίον, ὃ κατειργάσθη εἰς τὰ ἔργα κατὰ πᾶσαν τὴν ἐργασίαν τῶν ἁγίων, ἐγένετο χρυσίου τοῦ τῆς ἀπαρχῆς, ἐννέα καὶ εἴκοσι τάλαντα, καὶ ἑπτακόσιοι εἴκοσι σίκλοι κατὰ τὸν σίκλον τὸν ἅγιον· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Καὶ ἀργυρίου ἀφαίρεμα παρὰ τῶν ἐπεσκεμμένων ἀνδρῶν τῆς συναγωγῆς ἑκατὸν τάλαντα, καὶ χίλιοι ἑπτακόσιοι ἑβδομηκονταπέντε σίκλοι· δραχμὴ μία τῇ κεφαλῇ τὸ ἥμισυ τοῦ σίκλου, κατὰ τὸν σίκλον τὸν ἅγιον· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Πᾶς ὁ παραπορευόμενος τὴν ἐπίσκεψιν ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω εἰς τὰς ἑξήκοντα μυριάδας, καὶ τρισχίλιοι πεντακόσιοι καὶ πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Καὶ ἐγενήθη τὰ ἑκατὸν τάλαντα τοῦ ἀργυρίου εἰς τὴν χώνευσιν τῶν ἑκατὸν κεφαλίδων τῆς σκηνῆς, καὶ εἰς τὰς κεφαλίδας τοῦ καταπετάσματος, ");
INSERT INTO grcbrent_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ἑκατὸν κεφαλίδες εἰς τὰ ἑκατὸν τάλαντα, τάλαντον τῇ κεφαλίδι· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Καὶ τοὺς χιλίους ἑπτακοσίους ἑβδομηκοντα πέντε σίκλους ἐποίησεν εἰς τὰς ἀγκύλας τοῖς στύλοις· καὶ κατεχρύσωσε τὰς κεφαλίδας αὐτῶν, καὶ κατεκόσμησεν αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Καὶ ὁ χαλκὸς τοῦ ἀφαιρέματος ἑβδομήκοντα τάλαντα, καὶ χίλιοι πεντακόσιοι σίκλοι· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Καὶ ἐποίησαν ἐξ αὐτον τὰς βάσεις τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, ");
INSERT INTO grcbrent_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","καὶ τὰς βάσεις τῆς αὐλῆς κύκλῳ, καὶ τὰς βάσεις τῆς πύλης τῆς αὐλῆς, καὶ τοὺς πασσάλους τῆς σκηνῆς, καὶ τοὺς πασσάλους τῆς αὐλῆς κύκλῳ, ");
INSERT INTO grcbrent_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","καὶ τὸ παράθεμα τὸ χαλκοῦν τοῦ θυσιαστηρίου, καὶ πάντα τὰ σκεύη τοῦ θυσιαστηρίου, καὶ πάντα τὰ ἐργαλεῖα τῆς σκηνῆς τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Καὶ ἐποίησαν οἱ υἱοὶ Ἰσραὴλ, καθὰ συνέταξε Κύριος τῷ Μωυσῇ, οὕτως ἐποίησαν· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Τὸ δὲ λοιπὸν χρυσίον τοῦ ἀφαιρέματος ἐποίησαν σκεύη εἰς τὸ λειτουργεῖν ἐν αὐτοῖς ἔναντι Κυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Καὶ τὴν καταλειφθεῖσαν ὑάκινθον, καὶ πορφύραν, καὶ τὸ κόκκινον ἐποίησαν στολὰς λειτουργικὰς Ἀαρών, ὥστε λειτουργεῖν ἐν αὐταῖς ἐν τῷ ἁγίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Καὶ ἤνεγκαν τὰς στολὰς πρὸς Μωυσῆν, καὶ τὴν σκηνὴν, καὶ τὰ σκεύη αὐτῆς, τὰς βάσεις καὶ τοὺς μοχλοὺς αὐτῆς, καὶ τοὺς στύλους· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","καὶ τὸ θυσιαστήριον, καὶ πάντα τὰ σκεύη αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Καὶ τὸ ἔλαιον τῆς χρίσεως, καὶ τὸ θυμίαμα τῆς συνθέσεως, καὶ τὴν λυχνίαν τὴν καθαρὰν, ");
INSERT INTO grcbrent_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","καὶ τοὺς λύχνους αὐτῆς, λύχνους τῆς καύσεως, καὶ τὸ ἔλαιον τοῦ φωτός· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Καὶ τὴν τράπεζαν τῆς προθέσεως, καὶ πάντα τὰ σκεύη αὐτῆς· καὶ τοὺς ἄρτους τοὺς προκειμένους· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Καὶ τὰς στολὰς τοῦ ἁγίου, αἵ εἰσιν Ἀαρών, καὶ τὰς στολὰς τῶν υἱῶν αὐτοῦ, εἰς τὴν ἱερατείαν· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Καὶ τὰ ἱστία τῆς αὐλῆς, καὶ τοὺς στύλους· καὶ τὸ καταπέτασμα τῆς θύρας τῆς σκηνῆς, καὶ τῆς πύλης τῆς αὐλῆς· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Καὶ πάντα τὰ σκεύη τῆς σκηνῆς, καὶ πάντα τὰ ἐργαλεῖα αὐτῆς· καὶ τὰς διφθέρας δέρματα κριῶν ἠρυθροδανωμένα, καὶ τὰ καλύμματα ὑακίνθινα, καὶ τῶν λοιπῶν τὰ ἐπικαλύμματα· καὶ τοὺς πασσάλους, καὶ πάντα τὰ ἐργαλεῖα τὰ εἰς τὰ ἔργα τῆς σκηνῆς τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ὃσα συνέταξε Κύριος τῷ Μωυσῇ, οὕτως ἐποίησαν οἱ υἱοὶ Ἰσραὴλ πᾶσαν τὴν ἀποσκευήν· ");
INSERT INTO grcbrent_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Καὶ εἶδε Μωυσῆς πάντα τὰ ἔργα, καὶ ἦσαν πεποιηκότες αὐτὰ ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ, οὕτως ἐποίησαν αὐτὰ, καὶ εὐλόγησεν αὐτοὺς Μωυσῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","ἐν ἡμέρᾳ μιᾷ τοῦ μηνὸς τοῦ πρώτου νουμηνίᾳ, στήσεις τὴν σκηνὴν τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Καὶ θήσεις τὴν κιβωτὸν τοῦ μαρτυρίου, καὶ σκεπάσεις τὴν κιβωτὸν τῷ καταπετάσματι. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Καὶ εἰσοίσεις τὴν τράπεζαν, καὶ προθήσεις τὴν πρόθεσιν αὐτῆς· καὶ εἰσοίσεις τὴν λυχνίαν, καὶ ἐπιθήσεις τοὺς λύχνους αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Καὶ θήσεις τὸ θυσιαστήριον τὸ χρυσοῦν, εἰς τὸ θυμιᾷν ἐναντίον τῆς κιβωτοῦ· καὶ ἐπιθήσεις κάλυμμα καταπετάσματος ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Καὶ τὸ θυσιαστήριον τῶν καρπωμάτων θήσεις παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","καὶ περιθήσεις τὴν σκηνήν, καὶ πάντα τὰ αὐτῆς ἁγιάσεις κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Καὶ λήψῃ τὸ ἔλαιον τοῦ χρίσματος, καὶ χρίσεις τὴν σκηνὴν, καὶ πάντα τὰ ἐν αὐτῇ, καὶ ἁγιάσεις αὐτὴν, καὶ πάντα τὰ σκεύη αὐτῆς, καὶ ἔσται ἁγία. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Καὶ χρίσεις τὸ θυσιαστήριον τῶν καρπωμάτων, καὶ πάντα τὰ σκεύη αὐτοῦ· καὶ ἁγιάσεις τὸ θυσιαστήριον, καὶ ἔσται τὸ θυσιαστήριον ἅγιον τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Καὶ προσάξεις Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, καὶ λούσεις αὐτοὺς ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Καὶ ἐνδύσεις Ἀαρὼν τὰς στολὰς τὰς ἁγίας, καὶ χρίσεις αὐτὸν, καὶ ἁγιάσεις αὐτὸν, καὶ ἱερατεύει μοι. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Καὶ τοὺς υἱοὺς αὐτοῦ προσάξεις, καὶ ἐνδύσεις αὐτοὺς χιτῶνας. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Καὶ ἀλείψεις αὐτοὺς ὃν τρόπον ἤλειψας τὸν πατέρα αὐτῶν, καὶ ἱερατεύσουσί μοι· καὶ ἔσται, ὥστε εἶναι αὐτοῖς χρίσμα ἱερατείας εἰς τὸν αἰῶνα, εἰς τὰς γενεὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Καὶ ἐποίησε Μωυσῆς πάντα, ὅσα ἐνετείλατο αὐτῷ Κύριος, οὕτως ἐποίησε. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Καὶ ἐγένετο ἐν τῷ μηνὶ τῷ πρώτῳ, τῷ δευτέρῳ ἔτει, ἐκπορευομένων αὐτῶν ἐξ Αἰγύπτου, νουμηνίᾳ ἐστάθη ἡ σκηνή. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Καὶ ἔστησε Μωυσῆς τὴν σκηνὴν, καὶ ἐπέθηκε τὰς κεφαλιδας, καὶ διενέβαλε τοὺς μοχλοὺς, καὶ ἔστησε τοὺς στύλους. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Καὶ ἐξέτεινε τὰς αὐλαίας ἐπὶ τὴν σκηνὴν, καὶ ἐπέθηκε τὸ κατακάλυμμα τῆς σκηνῆς ἐπʼ αὐτὴν ἄνωθεν, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Καὶ λαβὼν τὰ μαρτύρια ἐνέβαλεν εἰς τὴν κιβωτόν· καὶ ὑπέθηκε τοὺς διωστῆρας ὑπὸ τὴν κιβωτὸν, ");
INSERT INTO grcbrent_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","καὶ εἰσήνεγκε τὴν κιβωτὸν εἰς τὴν σκηνὴν, καὶ ἐπέθηκε τὸ κατακάλυμμα τοῦ καταπετάσματος, καὶ ἐσκέπασε τὴν κιβωτὸν τοῦ μαρτυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ· ");
INSERT INTO grcbrent_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Καὶ ἐπέθηκε τὴν τράπεζαν εἰς τὴν σκηνὴν τοῦ μαρτυρίου, τὸ πρὸς Βοῤῥᾶν ἔξωθεν τοῦ καταπετάσματος τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Καὶ προσέθηκεν ἐπʼ αὐτῆς ἄρτους τῆς προθέσεως ἔναντι Κυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Καὶ ἔθηκε τὴν λυχνίαν εἰς τὴν σκηνὴν τοῦ μαρτυρίου, εἰς τὸ κλίτος τῆς σκηνῆς τὸ πρὸς Νότον. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Καὶ ἐπέθηκε τοὺς λύχνους αὐτῆς ἔναντι Κυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Καὶ ἔθηκε τὸ θυσιαστήριον τὸ χρυσοῦν ἐν τῇ σκηνῇ τοῦ μαρτυρίου ἀπέναντι τοῦ καταπετάσματος, ");
INSERT INTO grcbrent_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","καὶ ἐθυμίασεν ἐνʼ αὐτοῦ θυμίαμα τῆς συνθέσεως, καθάπερ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Καὶ τὸ θυσιαστήριον τῶν καρπωμάτων ἔθηκε παρὰ τὰς θύρας τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Καὶ ἔστησε τὴν αὐλὴν κύκλῳ τῆς σκηνῆς, και τοῦ θυσιαστηρίου· καὶ συνετέλεσε Μωυσῆς πάντα τὰ ἔργα. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Καὶ ἐκάλυψεν ἡ νεφέλη τὴν σκηνὴν τοῦ μαρτυρίου· καὶ δόξης Κυρίου ἐπλήσθη ἡ σκηνή. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Καὶ οὐκ ἠδυνάσθη Μωυσῆς εἰσελθεῖν εἰς τὴν σκηνὴν τοῦ μαρτυρίου, ὅτι ἐπεσκίαζεν ἐπʼ αὐτὴν ἡ νεφέλη, καὶ δόξης Κυρίου ἐνεπλήσθη ἡ σκηνή. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ἡνίκα δʼ ἂν ἀνέβη ἡ νεφέλη ἀπὸ τῆς σκηνῆς, ἀνεζεύγνυσαν οἱ υἱοὶ Ἰσραὴλ σὺν τῇ ἀπαρτίᾳ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Εἰ δὲ μὴ ἀνέβη ἡ νεφέλη, οὐκ ἀνεζεύγνυσαν ἕως ἡμέρας, ἧς ἀνέβη ἡ νεφέλη. ");
INSERT INTO grcbrent_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Νεφέλη γὰρ ἦν ἐπὶ τῆς σκηνῆς ἡμέρας, καὶ πῦρ ἦν ἐπʼ αὐτῆς νυκτὸς ἐναντίον παντὸς Ἰσραὴλ, ἐν πάσαις ταῖς ἀναζυγαῖς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ΚΑΙ ἀνεκάλεσε Μωυσῆν, καὶ ἐλάλησε Κύριος αὐτῷ ἐκ τῆς σκηνῆς τοῦ μαρτυρίου, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ἄνθρωπος ἐξ ὑμῶν ἐὰν προσαγάγῃ δῶρα τῷ Κυρίῳ, ἀπὸ τῶν κτηνῶν καὶ ἀπὸ τῶν βοῶν καὶ ἀπὸ τῶν προβάτων προσοίσετε τὰ δῶρα ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ἐὰν ὁλοκαύτωμα τὸ δῶρον αὐτοῦ, ἐκ τῶν βοῶν ἄρσεν ἄμωμον προσάξει πρὸς τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου, προσοίσει αὐτὸ δεκτὸν ἐναντίον Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Καὶ ἐπιθήσει τὴν χεῖρα ἐπὶ τὴν κεφαλὴν τοῦ καρπώματος δεκτὸν αὐτῷ, ἐξιλάσασθαι περὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Καὶ σφάξουσι τὸν μόσχον ἔναντι Κυρίου· καὶ προσοίσουσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὸ αἷμα, καὶ προσχεοῦσι τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ τὸ ἐπὶ τῶν θυρῶν τῆς σκηνῆς τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","καὶ ἐκδείραντες τὸ ὁλοκαύτωμα, μελιοῦσιν αὐτὸ κατὰ μέλη. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Καὶ ἐπιθήσουσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς πῦρ ἐπὶ τὸ θυσιαστήριον, καὶ ἐπιστοιβάσουσι ξύλα ἐπὶ τὸ πῦρ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Καὶ ἐπιστοιβάσουσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὰ διχοτομήματα, καὶ τὴν κεφαλὴν, καὶ τὸ στέαρ ἐπὶ τὰ ξύλα τὰ ἐπὶ τοῦ πυρὸς τὰ ὄντα ἐπὶ τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Τὰ δὲ ἐγκοίλια καὶ τοὺς πόδας πλυνοῦσιν ὕδατι· καὶ ἐπιθήσουσιν οἱ ἱερεῖς τὰ πάντα ἐπὶ τὸ θυσιαστήριον· κάρπωμά ἐστι θυσία ὀσμὴ εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ἐὰν δὲ ἀπὸ τῶν προβάτων τὸ δῶρον αὐτοῦ τῷ Κυρίῳ, ἀπό τε τῶν ἀρνῶν, καὶ τῶν ἐρίφων εἰς ὁλοκαυτώματα, ἄρσεν ἄμωμον προσάξει αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Καὶ ἐπιθήσει τὴν χεῖρα ἐπὶ τὴν κεφαλὴν αὐτοῦ· καὶ σφάξουσιν αὐτὸ ἐκ πλαγίων τοῦ θυσιαστηρίου πρὸς βοῤῥᾶν ἔναντι Κυρίου· καὶ προσχεοῦσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὸ αἷμα αὐτοῦ ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Καὶ διελουσιν αὐτὸ κατὰ μέλη, καὶ τὴν κεφαλὴν, καὶ τὸ στέαρ· καὶ ἐπιστοιβάσουσιν οἱ ἱερεῖς αὐτὰ ἐπὶ τὰ ξύλα τὰ ἐπὶ τοῦ πυρὸς τὰ ἐπὶ τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Καὶ τὰ ἐγκοίλια, καὶ τοὺς πόδας πλυνοῦσιν ὕδατι· καὶ προσοίσει ὁ ἱερεὺς τὰ πάντα, καὶ ἐπιθήσει ἐπὶ τὸ θυσιαστήριον· κάρπωμά ἐστι θυσία ὀσμὴ εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ἐὰν δὲ ἀπὸ τῶν πετεινῶν κάρπωμα προσφέρει δῶρον αὐτοῦ τῷ κυρίῳ, καὶ προσοίσει ἀπὸ τῶν τρυγόνων, ἢ ἀπὸ τῶν περιστερῶν τὸ δῶρον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Καὶ προσοίσει αὐτὸ ὁ ἱερεὺς πρὸς τὸ θυσιαστήριον, καὶ ἀποκνίσει τὴν κεφαλήν, καὶ ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον, καὶ στραγγιεῖ τὸ αἷμα πρὸς τὴν βάσιν τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Καὶ ἀφελεῖ τὸν πρόλοβον σὺν τοῖς πτεροῖς, καὶ ἐκβαλεῖ αὐτὸ παρὰ τὸ θυσιαστήριον κατʼ ἀνατολὰς εἰς τὸν τόπον τῆς σποδοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Καὶ ἐκκλάσει αὐτὸ ἐκ τῶν πτερύγων, καὶ οὐ διελεῖ, καὶ ἐπιθήσει αὐτὸ ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον ἐπὶ τὰ ξύλα τὰ ἐπὶ τοῦ πυρός· κάρπωμά ἐστι θυσία ὀσμὴ εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ἐὰν δὲ ψυχὴ προσφέρῃ δῶρον θυσίαν τῷ Κυρίῳ, σεμίδαλις ἔσται τὸ δῶρον αὐτοῦ, καὶ ἐπιχεεῖ ἐπʼ αὐτὸ ἔλαιον, καὶ ἐπιθήσει ἐπʼ αὐτὸ λίβανον· θυσία ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Καὶ οἴσει πρὸς τοὺς υἱοὺς Ἀαρὼν τοὺς ἱερεῖς· καὶ δραξάμενος ἀπʼ αὐτῆς πλήρη τὴν δράκα ἀπὸ τῆς σεμιδάλεως σὺν τῷ ἐλαίῳ, καὶ πάντα τὸν λίβανον αὐτῆς, καὶ ἐπιθήσει ὁ ἱερεὺς τὸ μνημόσυνον αὐτῆς ἐπὶ τὸ θυσιαστήριον· θυσία ὀσμὴ εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Καὶ τὸ λοιπὸν ἀπὸ τῆς θυσίας Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, ἅγιον τῶν ἁγίων ἀπὸ τῶν θυσιῶν Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ἐὰν δὲ προσφέρῃ δῶρον θυσίαν πεπεμμένην ἐκ κλιβάνου δῶρον Κυρίῳ ἐκ σεμιδάλεως, ἄρτους ἀζύμους πεφυραμένους ἐν ἐλαίῳ, καὶ λάγανα ἄζυμα διακεχρισμένα ἐν ἐλαίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ἐὰν δὲ θυσία ἀπὸ τηγάνου τὸ δῶρόν σου, σεμίδαλις πεφυραμένη ἐν ἐλαίῳ ἄζυμά ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Καὶ διαθρύψεις αὐτὰ κλάσματα, καὶ ἐπιχεεῖς ἐπʼ αὐτὰ ἔλαιον· θυσία ἐστὶ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ἐὰν δὲ θυσία ἀπὸ ἐσχάρας τὸ δῶρόν σου, σεμίδαλις ἐν ἐλαίῳ ποιηθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Καὶ προσοίσει τὴν θυσίαν ἣν ἂν ποιήσῃ ἐκ τούτων τῷ Κυρίῳ, καὶ προσοίσει πρὸς τὸν ἱερέα. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Καὶ προσεγγίσας πρὸς τὸ θυσιαστήριον, ἀφελεῖ ὁ ἱερεὺς ἀπὸ τῆς θυσίας τὸ μνημόσυνον αὐτῆς, καὶ ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον, κάρπωμα· ὀσμὴ εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Τὸ δὲ καταλειφθὲν ἀπὸ τῆς θυσίας, Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, ἅγια τῶν ἁγίων ἀπὸ τῶν καρπωμάτων Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Πᾶσαν θυσίαν, ἣν ἂν προσφέρητε Κυρίῳ, οὐ ποιήσετε ζυμωτόν· πᾶσαν γὰρ ζύμην, καὶ πᾶν μέλι οὐ προσοίσετε ἀπʼ αὐτοῦ, καρπῶσαι Κυρίῳ δῶρον. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ἀπαρχῆς προσοίσετε αὐτὰ Κυρίῳ, ἐπὶ δὲ τὸ θυσιαστήριον οὐκ ἀναβιβασθήσεται εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Καὶ πᾶν δῶρον θυσίας ὑμῶν ἁλὶ ἁλισθήσεται· οὐ διαπαύσατε ἅλας διαθήκης Κυρίου ἀπὸ θυσιασμάτων ὑμῶν· ἐπὶ παντὸς δώρου ὑμῶν προσοίσετε Κυρίῳ τῷ Θεῷ ὑμῶν ἅλας. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ἐὰν δὲ προσφέρῃς θυσίαν πρωτογεννημάτων τῷ Κυρίῳ, νέα πεφρυγμένα χίδρα ἐρικτὰ τῷ Κυρίῳ· καὶ προσοίσεις τὴν θυσίαν τῶν πρωτογεννημάτων. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Καὶ ἐπιχεεῖς ἐπʼ αὐτὴν ἔλαιον, καὶ ἐπιθήσεις ἐπʼ αὐτὴν λίβανον· θυσία ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Καὶ ἀνοίσει ὁ ἱερεὺς τὸ μνημόσυνον αὐτῆς ἀπὸ τῶν χίδρων σὺν τῷ ἐλαίῳ, καὶ πάντα τὸν λίβανον αὐτῆς· κάρπωμά ἐστι Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ἐὰν δὲ θυσία σωτηρίου τὸ δῶρον αὐτοῦ τῷ Κυρίῳ, ἐὰν μὲν ἐκ τῶν βοῶν αὐτὸ προσαγάγῃ, ἐάν τω ἄρσεν, ἐάν τε θῆλυ, ἄμωμον προσάξει αὐτὸ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Καὶ ἐπιθήσει τὰς χεῖρας ἐπὶ τὴν κεφαλὴν τοῦ δώρου, καὶ σφάξει αὐτὸ ἐναντίον Κυρίου παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ προσχεοῦσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον τῶν ὁλοκαυτωμάτων κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Καὶ προσάξουσιν ἀπὸ τῆς θυσίας τοῦ σωτηρίου κάρπωμα Κυρίῳ, τὸ στέαρ τὸ κατακαλύπτον τὴν κοιλίαν, καὶ πᾶν τὸ στέαρ τὸ ἐπὶ τῆς κοιλίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, τὸ ἐπὶ τῶν μηρίων, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος σὺν τοῖς νεφροῖς περιελεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Καὶ ἀνοίσουσιν αὐτὰ οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς ἐπὶ τὸ θυσιαστήριον ἐπὶ τὰ ὁλοκαυτώματα ἐπὶ τὰ ξύλα, τὰ ἐπὶ τοῦ πυρὸς ἐπὶ τοῦ θυσιαστηρίου· κάρπωμα ὀσμὴ εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ἐὰν δὲ ἀπὸ τῶν προβάτων τὸ δῶρον αὐτοῦ θυσία σωτηρίου τῷ Κυρίῳ, ἄρσεν ἢ θῆλυ, ἄμωμον προσοίσει αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ἐὰν ἄρνα προσαγάγῃ τὸ δῶρον αὐτοῦ, προσάξει αὐτὸ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Καὶ ἐπιθήσει τὰς χεῖρας ἐπὶ τὴν κεφαλὴν τοῦ δώρου αὐτοῦ, καὶ σφάξει αὐτὸ παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ προσχεοῦσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Καὶ προσοίσει ἀπὸ τῆς θυσίας τοῦ σωτηρίου κάρπωμα τῷ Κυρίῷ· τὸ στέαρ καὶ τὴν ὀσφὺν ἄμωμον σὺν ταῖς ψόαις περιελεῖ αὐτό· καὶ πᾶν τὸ στέαρ τὸ κατακαλύπτον τὴν κοιλίαν, καὶ πᾶν τὸ στέαρ τὸ ἐπὶ τῆς κοιλίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Καὶ ἀμφοτέρους τοὺς νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, τὸ ἐπὶ τῶν μηρίων, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος σὺν τοῖς νεφροῖς περιελὼν, ");
INSERT INTO grcbrent_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ἀνοίσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον· ὀσμὴ εὐωδίας κάρπωμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ἐὰν δὲ ἀπὸ τῶν αἰγῶν τὸ δῶρον αὐτοῦ, καὶ προσάξει ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Καὶ ἐπιθήσει τὰς χεῖρας ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ σφάξουσιν αὐτὸ ἔναντι Κυρίου παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ προσχεοῦσιν οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Καὶ ἀνοίσει ἀπʼ αὐτοῦ κάρπωμα Κυρίῳ τὸ στέαρ τὸ κατακαλύπτον τὴν κοιλίαν, καὶ πᾶν τὸ στέαρ τὸ ἐπὶ τῆς κοιλίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Καὶ ἀμφοτέρους τοὺς νεφροὺς, καὶ πᾶν τὸ στέαρ τὸ ἐπʼ αὐτῶν, τὸ ἐπὶ τῶν μηρίων, καὶ τὸν λοβὸν τοῦ ἥπατος σὺν τοῖς νεφροῖς περιελεῖ, ");
INSERT INTO grcbrent_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","καὶ ἀνοίσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον· κάρπωμα ὀσμὴ εὐωδίας τῷ Κυρίῳ· πᾶν τὸ στέαρ τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Νόμιμον εἰς τὸν αἰῶνα εἰς τὰς γενεὰς ὑμῶν, ἐν πάσῃ κατοικίᾳ ὑμῶν· πᾶν στέαρ καὶ πᾶν αἷμα οὐκ ἔδεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Λάλησον πρὸς τοὺς υἱοὺς Ἰσραὴλ, λέγων, ψυχὴ ἐὰν ἁμάρτῃ ἔναντι Κυρίου ἀκουσίως ἀπὸ πάντων τῶν προσταγμάτων Κυρίου, ὧν οὐ δεῖ ποιεῖν, καὶ ποιήσῃ ἕν τι ἀπʼ αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ἐὰν μὲν ὁ ἀρχιερεὺς ὁ κεχρισμένος ἁμάρτῃ τοῦ τὸν λαὸν ἁμαρτεῖν, καὶ προσάξει περὶ τῆς ἁμαρτίας αὐτοῦ, ἧς ἥμαρτε, μόσχον ἐκ βοῶν ἄμωμον τῷ Κυρίῳ περὶ τῆς ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Καὶ προσάξει τὸν μόσχον παρὰ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου ἔναντι Κυρίου, καὶ ἐπιθήσει τὴν χεῖρα αὐτοῦ ἐπὶ τὴν κεφαλὴν τοῦ μόσχου ἔναντι Κυρίου, καὶ σφάξει τὸν μόσχον ἐνώπιον Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Καὶ λαβὼν ὁ ἱερεὺς ὁ χριστὸς ὁ τετελειωμένος τὰς χεῖρας ἀπὸ τοῦ αἵματος τοῦ μόσχου, καὶ εἰσοίσει αὐτὸ εἰς τὴν σκηνὴν τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Καὶ βάψει ὁ ἱερεὺς τὸν δάκτυλον εἰς τὸ αἷμα, καὶ προσρανεῖ ἀπὸ τοῦ αἵματος ἑπτάκις ἔναντι Κυρίου, κατὰ τὸ καταπέτασμα τὸ ἅγιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Καὶ ἐπιθήσει ὁ ἱερεὺς ἀπὸ τοῦ αἵματος τοῦ μόσχου ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου τοῦ θυμιάματος τῆς συνθέσεως τοῦ ἐναντίον Κυρίου, ὅ ἐστιν ἐν τῇ σκηνῇ τοῦ μαρτυρίου· καὶ πᾶν τὸ αἷμα τοῦ μόσχου ἐκχεεῖ παρὰ τὴν βάσιν τοῦ θυσιαστηρίου τῶν ὁλοκαυτωμάτων, ὅ ἐστι παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Καὶ πὰν τὸ στέαρ τοῦ μόσχου τοῦ τῆς ἁμαρτίας περιελεῖ ἀπʼ αὐτοῦ, τὸ στέαρ τὸ κατακαλύπτον τὰ ἐνδόσθια, καὶ πᾶν τὸ στέαρ τὸ ἐπὶ τῶν ἐνδοσθίων, ");
INSERT INTO grcbrent_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, ὅ ἐστιν ἐπὶ τῶν μηρίων, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος σὺν τοῖς νεφροῖς περιελεῖ αὐτό, ");
INSERT INTO grcbrent_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ὃν τρόπον ἀφαιρεῖται αὐτὸ ἀπὸ τοῦ μόσχου τοῦ τῆς θυσίας τοῦ σωτηρίου, καὶ ἀνοίσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον τῆς καρπώσεως. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Καὶ τὸ δέρμα τοῦ μόσχου, καὶ πᾶσαν αὐτοῦ τὴν σάρκα σὺν τῇ κεφαλῇ καὶ τοῖς ἀκρωτηρίοις καὶ τῇ κοιλίᾳ καὶ τῇ κόπρῳ· ");
INSERT INTO grcbrent_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","καὶ ἐξοίσουσιν ὅλον τὸν μόσχον ἔξω τῆς παρεμβολῆς εἰς τόπον καθαρὸν, οὗ ἐκχεοῦσι τὴν σποδιὰν, καὶ κατακαύσουσιν αὐτὸν ἐπὶ ξύλων ἐν πυρί· ἐπὶ τῆς ἐκχύσεως τῆς σποδιᾶς καυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ἐὰν δὲ πᾶσα συναγωγὴ Ἰσραὴλ ἀγνοήσῃ ἀκουσίως, καὶ λάθῃ ῥῆμα ἐξ ὀφθαλμῶν τῆς συναγωγῆς, καὶ ποιήσωσι μίαν ἀπὸ πασῶν τῶν ἐντολῶν Κυρίου, ἣ οὐ ποιηθήσεται, καὶ πλήμμελήσωσι, ");
INSERT INTO grcbrent_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","καὶ γνωσθῇ αὐτοῖς ἡ ἁμαρτία, ἣν ἥμαρτον ἐν αὐτῇ, καὶ προσάξει ἡ συναγωγὴ μόσχον ἐκ βοῶν ἄμωμον περὶ τῆς ἁμαρτίας, καὶ προσάξει αὐτὸν παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Καὶ ἐπιθήσουσιν οἱ πρεσβύτεροι τῆς συναγωγῆς τὰς χείρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ μόσχου ἔναντι Κυρίου, καὶ σφάξουσιν τὸν μόσχον ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Καὶ εἰσοίσει ὁ ἱερεὺς ὁ χριστὸς ἀπὸ τοῦ αἵματος τοὺ μόσχου εἰς τὴν σκηνὴν τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Καὶ βάψει ὁ ἱερεὺς τὸν δάκτυλον ἀπὸ τοῦ αἵματος τοῦ μόσχου, καὶ ῥανεῖ ἑπτάκις ἔναντι Κυρίου, κατενώπιον τοῦ καταπετάσματος τοῦ ἁγίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Καὶ ἀπὸ τοῦ αἵματος ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου τῶν θυμιαμάτων τῆς συνθέσεως, ὅ ἐστιν ἐνώπιον Κυρίου, ὅ ἐστιν ἐν τῇ σκηνῇ τοῦ μαρτυρίου· καὶ τὸ πᾶν αἷμα ἐκχεεῖ πρὸς τὴν βάσιν τοῦ θυσιαστηρίου τῶν καρπώσεων, τοῦ πρὸς τῇ θύρᾳ τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Καὶ τὸ πᾶν στέαρ περιελεῖ ἀπʼ αὐτοῦ, καὶ ἀνοίσει ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Καὶ ποιήσει τὸν μόσχον, ὃν τρόπον ἐποίησε τὸν μόσχον τὸν τῆς ἁμαρτίας, οὕτω ποιηθήσεται· καὶ ἐξιλάσεται περὶ αὐτῶν ὁ ἱερεὺς, καὶ ἀφεθήσεται αὐτοῖς ἡ ἁμαρτία. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Καὶ ἐξοίσουσι τὸν μόσχον ὅλον ἔξω τῆς παρεμβολῆς, καὶ κατακαύσουσι τὸν μόσχον, ὃν τρόπον κατέκαυσαν τὸν μόσχον τὸν πρότερον· ἁμαρτία συναγωγῆς ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ἐὰν δὲ ὁ ἄρχων ἁμάρτῃ, καὶ ποιήσῃ μίαν ἀπὸ πασῶν τῶν ἐντολῶν Κυρίου τοῦ Θεοῦ αὐτοῦ, ἣ οὐ ποιηθήσεται, ἀκουσίως, καὶ ἁμάρτῃ καὶ πλημμελήσῃ, ");
INSERT INTO grcbrent_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","καὶ γνωσθῇ αὐτῷ ἡ ἁμαρτία, ἣν ἥμαρτεν ἐν αὐτῇ, καὶ προσοίσει τὸ δῶρον αὐτοῦ χίμαρον ἐξ αἰγῶν, ἄρσεν ἄμωμον. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Καὶ ἐπιθήσει τὴν χεῖρα ἐπὶ τὴν κεφαλὴν τοῦ χιμάρου· καὶ σφάξουσιν αὐτὸν ἐν τόπῳ οὗ σφάζουσι τὰ ὁλοκαυτώματα ἐνώπιον Κυρίου· ἁμαρτία ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Καὶ ἐπιθήσει ὁ ἱερεὺς ἀπὸ τοῦ αἵματος τοῦ τῆς ἁμαρτίας τῷ δακτύλῳ ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου τῶν ὁλοκαυτωμάτων· καὶ τὸ πᾶν αἷμα αὐτοῦ ἐκχεεῖ παρὰ τὴν βάσιν τοῦ θυσιαστηρίου τῶν ὁλοκαυτωμάτων. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Καὶ τὸ πᾶν στέαρ αὐτοῦ ἀνοίσει ἐπὶ τὸ θυσιαστήριον, ὥσπερ τὸ στέαρ θυσίας σωτηρίου· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἀπὸ τῆς ἁμαρτίας αὐτοῦ, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ἐὰν δὲ ψυχὴ μία ἁμάρτῃ ἀκουσίως ἐκ τοῦ λαοῦ τῆς γῆς, ἐν τῷ ποιῆσαι μίαν ἀπὸ πασῶν τῶν ἐντολῶν Κυρίου, ἣ οὐ ποιηθήσεται, καὶ πλημμελήσῃ· ");
INSERT INTO grcbrent_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","καὶ γνωσθῇ αὐτῷ ἡ ἁμαρτία, ἣν ἥμαρτεν ἐν αὐτῇ, καὶ οἴσει χίμαιραν ἐξ αἰγῶν, θήλειαν ἄμωμον οἴσει περὶ τῆς ἁμαρτίας, ἧς ἥμαρτε. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Καὶ ἐπιθήσει τὴν χεῖρα ἐπὶ τὴν κεφαλὴν τοῦ ἁμαρτήματος αὐτοῦ· καὶ σφάξουσιν τὴν χίμαιραν τὴν τῆς ἁμαρτίας ἐν τῷ τόπῳ, οὗ σφάζουσι τὰ ὁλοκαυτώματα. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Καὶ λήψεται ὁ ἱερεὺς ἀπὸ τοῦ αἵματος αὐτῆς τῷ δακτύλῳ, καὶ ἐπιθήσει ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου τῶν ὁλοκαυτωμάτων· καὶ πᾶν τὸ αἷμα αὐτῆς ἐκχεεῖ παρὰ τὴν βάσιν τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Καὶ πᾶν τὸ στέαρ περιελεῖ, ὃν τρόπον περιαιρεῖται στέαρ ἀπὸ θυσίας σωτηρίου· καὶ ἀνοίσει ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον εἰς ὀσμὴν εὐωδίας Κυρίῳ· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Εὰν δὲ πρόβατον προσενέγκῃ τὸ δῶρον αὐτοῦ περὶ τῆς ἁμαρτίας, θῆλυ ἄμωμον προσοίσει αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Καὶ ἐπιθήσει τὴν χεῖρα ἐπὶ τῆν κεφαλὴν τοῦ τῆς ἁμαρτίας· καὶ σφάξουσιν αὐτὸ ἐν τόπῳ, οὗ σφάζουσι τὰ ὁλοκαυτώματα. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Καὶ λαβὼν ὁ ἱερεὺς ἀπὸ τοῦ αἵματος τοῦ τῆς ἁμαρτίας τῷ δακτύλῳ, ἐπιθήσει ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου τῆς ὁλοκαρπώσεως· καὶ πᾶν αὐτοῦ τὸ αἷμα ἐκχεεῖ παρὰ τὴν βάσιν τοῦ θυσιαστηρίου τῆς ὁλοκαυτώσεως. ");
INSERT INTO grcbrent_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Καὶ πᾶν αὐτοῦ τὸ στέαρ περιελεῖ, ὃν τρόπον περιαιρεῖται στέαρ προβάτου ἐκ τῆς θυσίας τοῦ σωτηρίου· καὶ ἐπιθήσει αὐτὸ ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον ἐπὶ τὸ ὁλοκαύτωμα Κυρίου· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς περὶ τῆς ἁμαρτίας ἧς ἥμαρτε, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ἐὰν δὲ ψυχὴ ἁμάρτῃ, καὶ ἀκούσῃ φωνὴν ὁρκισμοῦ, καὶ οὗτος μάρτυς ἢ ἑώρακεν ἢ σύνοιδεν, ἐὰν μὴ ἀπαγγείλῃ, λήψεται τὴν ἁμαρτίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ἡ ψυχὴ ἐκείνη ἥτις ἐὰν ἅψηται παντὸς πράγματος ἀκαθάρτου, ἢ θνησιμαίου, ἢ θηριαλώτου ἀκαθάρτου, ἢ τῶν θνησιμαίων βδελυγμάτων τῶν ἀκαθάρτων, ἢ τῶν θνησιμαίων κτηνῶν τῶν ἀκαθάρτων, ");
INSERT INTO grcbrent_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ἢ ἅψηται ἀπὸ ἀκαθαρσίας ἀνθρώπου, ἀπὸ πάσης ἀκαθαρσίας αὐτοῦ, ἧς ἂν ἁψάμενος μιανθῇ καὶ ἔλαθεν αὐτόν, μετὰ τοῦτο δὲ γνῷ, καὶ πλημμελήσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ἡ ψυχὴ ἡ ἄνομος, ἡ διαστέλλουσα τοῖς χείλεσι κακοποιῆσαι ἢ καλῶς ποιῆσαι κατὰ πάντα ὅσα ἐὰν διαστείλῃ ὁ ἄνθρωπος μεθʼ ὅρκου, καὶ λάθῃ αὐτὸν πρὸ ὀφθαλμῶν, καὶ οὗτος γνῷ, καὶ ἁμάρτῃ ἕν τι τούτων. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Καὶ ἐξαγορεύσει τὴν ἁμαρτίαν περὶ ὧν ἡμάρτηκε κατʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Καὶ οἴσει περὶ ὧν ἐπλημμέλησε Κυρίῳ, περὶ τῆς ἁμαρτίας ἧς ἥμαρτε, θῆλυ ἀπὸ τῶν προβάτων ἀμνάδα, ἢ χίμαιραν ἐξ αἰγῶν, περὶ ἁμαρτίας· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς περὶ τῆς ἁμαρτίας αὐτοῦ, ἧς ἥμαρτε, καὶ ἀφεθήσεται αὐτῷ ἡ ἁμαρτία. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ἐὰν δὲ μὴ ἰσχύῃ ἡ χεὶρ αὐτοῦ τὸ ἱκανὸν εἰς τὸ πρόβατον, οἴσει περὶ τῆς ἁμαρτίας αὐτοῦ, ἧς ἥμαρτε, δύο τρυγόνας, ἢ δύο νοσσοὺς περιστερῶν Κυρίῳ, ἕνα περὶ ἁμαρτίας, καὶ ἕνα εἰς ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Καὶ οἴσει αὐτὰ πρὸς τὸν ἱερέα· καὶ προσάξει ὁ ἱερεὺς τὸ περὶ τῆς ἁμαρτίας πρότερον· καὶ ἀποκνίσει ὁ ἱερεὺς τὴν κεφαλὴν αὐτοῦ ἀπὸ τοῦ σφονδύλου, καὶ οὐ διελεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Καὶ ῥανεῖ ἀπὸ τοῦ αἵματος τοῦ περὶ τῆς ἁμαρτίας ἐπὶ τὸν τοῖχον τοῦ θυσιαστηρίου· τὸ δὲ κατάλοιπον τοῦ αἵματος καταστραγγιεῖ ἐπὶ τὴν βάσιν τοῦ θυσιαστηρίου· ἁμαρτία γάρ ἐστι· ");
INSERT INTO grcbrent_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Καὶ τὸ δεύτερον ποιήσει ὁλοκάρπωμα, ὡς καθήκει· καὶ ἐξιλάσεται ὁ ἱερεὺς περὶ τῆς ἁμαρτίας αὐτοῦ, ἧς ἥμαρτε, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ἐὰν δὲ μὴ εὑρίσκῃ ἡ χεὶρ αὐτοῦ ζεῦγος τρυγόνων, ἢ δύο νοσσούς περιστερῶν, καὶ οἴσει τὸ δῶρον αὐτοῦ, περὶ οὗ ἥμαρτε, τὸ δέκατον τοῦ οἰφὶ σεμιδάλεως περὶ ἁμαρτίας· οὐκ ἐπιχεεῖ ἐπʼ αὐτὸ ἔλαιον, οὐδὲ ἐπιθήσει ἐπʼ αὐτῷ λίβανον, ὅτι περὶ ἁμαρτίας ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Καὶ οἴσει αὐτὸ πρὸς τὸν ἱερέα· καὶ δραξάμενος ὁ ἱερεὺς ἀπʼ αὐτῆς πλήρη τὴν δράκα, τὸ μνημόσυνον αὐτῆς ἐπιθήσει ἐπὶ τὸ θυσιαστήριον τῶν ὁλοκαυτωμάτων Κυρίῳ· ἁμαρτία ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς περὶ τῆς ἁμαρτίας αὐτοῦ, ἧς ἥμαρτεν ἀφʼ ἑνὸς τούτων, καὶ ἀφεθήσεται αὐτῷ. τὸ δὲ καταλειφθὲν ἔσται τῷ ἱερεῖ, ὡς θυσία τῆς σεμιδάλεως. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","ψυχὴ ἣ ἂν λάθῃ αὐτὸν λήθῃ, καὶ ἁμάρτῃ ἀκουσίως ἀπὸ τῶν ἁγίων Κυρίου, καὶ οἴσει τῆς πλημμελείας αὐτοῦ τῷ Κυρίῳ κριὸν ἄμωμον ἐκ τῶν προβάτων, τιμῆς ἀργυρίου σίκλων, τῷ σίκλῳ τῶν ἁγίων, περὶ οὗ ἐπλημμέλησε. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Καὶ ὃ ἥμαρτεν ἀπὸ τῶν ἁγίων ἀποτίσει αὐτὸ, καὶ τὸ ἐπίπεμπτον προσθήσει ἐπʼ αὐτὸ, καὶ δώσει αὐτὸ τῷ ἱερεῖ· καὶ ὁ ἱερεὺς ἐξιλάσεται περὶ αὐτοῦ ἐν τῷ κριῷ τῆς πλημμελείας, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Καὶ ἡ ψυχὴ ἣ ἂν ἁμάρτῃ, καὶ ποιήσει μίαν ἀπὸ πασῶν τῶν ἐντολῶν Κυρίου, ὧν οὐ δεῖ ποιεῖν, καὶ οὐκ ἔγνω, καὶ πλημμελήσῃ, καὶ λάβῃ τὴν ἁμαρτίαν, ");
INSERT INTO grcbrent_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","καὶ οἴσει κριὸν ἄμωμον ἐκ τῶν προβάτων, τιμῆς ἀργυρίου εἰς πλημμέλειαν πρὸς τὸν ἱερέα· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς περὶ τῆς ἀγνοίας αὐτοῦ, ἧς ἠγνόησε, καὶ αὐτὸς οὐκ ᾔδει, καὶ ἀφεθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ἐπλημμέλησε γὰρ πλημμελείᾳ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","ψυχὴ ἣ ἂν ἁμάρτῃ, καὶ παριδὼν παρίδῃ τὰς ἐντολὰς Κυρίου, καὶ ψεύσηται τὰ πρὸς τὸν πλησίον ἐν παραθήκῃ, ἢ περὶ κοινωνίας, ἢ περὶ ἁρπαγῆς, ἢ ἠδίκησέ τι τὸν πλησίον, ");
INSERT INTO grcbrent_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ἢ εὗρεν ἀπωλίαν, καὶ ψεύσηται περὶ αὐτῆς, καὶ ὀμόσῃ ἀδίκως περὶ ἑνὸς ἀπὸ πάντων, ὧν ἐὰν ποιήσῃ ὁ ἄνθρωπος, ὥστε ἁμαρτεῖν ἐν τούτοις· ");
INSERT INTO grcbrent_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","Καὶ ἔσται ἡνίκα ἐὰν ἁμάρτῃ, καὶ πλημμελήσῃ, καὶ ἀποδῷ τὸ ἅρπαγμα, ὃ ἥρπασεν, ἢ τὸ ἀδίκημα, ὃ ἠδίκησεν, ἢ τὴν παραθήκην, ἥτις παρετέθη αὐτῷ, ἢ τὴν ἀπώλειαν, ἣν εὗρεν ");
INSERT INTO grcbrent_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ἀπὸ παντὸς πράγματος, οὗ ὤμοσε περὶ αὐτοῦ ἀδίκως, καὶ ἀποτίσει αὐτὸ τὸ κεφάλαιον, καὶ τὸ ἐπίπεμπτον προσθήσει ἐπʼ αὐτὸ, τίνος ἐστίν, αὐτῷ ἀποδώσει ᾗ ἡμέρᾳ ἐλεγχθῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Καὶ τῆς πλημμελείας αὐτου οἴσει τῷ Κυρίῳ κριὸν ἀπὸ τῶν προβάτων ἄμωμον, τιμῆς, εἰς ὃ ἐπλημμέλησε. ");
INSERT INTO grcbrent_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἔναντι Κυρίου, καὶ ἀφεθήσεται αὐτῷ περὶ ἑνὸς ἀπὸ πάντων ὧν ἐποίησε καὶ ἐπλημμέλησεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ἔντειλαι τῷ Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, λέγων, οὗτος ὁ νόμος τῆς ὁλοκαυτώσεως· αὕτη ἡ ὁλοκαύτωσις ἐπὶ τῆς καύσεως αὐτῆς ἐπὶ τοῦ θυσιαστηρίου ὅλην τὴν νύκτα ἕως τοπρωῒ, καὶ τὸ πῦρ τοῦ θυσιαστηρίου καυθήσεται ἐπʼ αὐτοῦ, οὐ σβεσθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Καὶ ἐνδύσεται ὁ ἱερεὺς χιτῶνα λινοῦν, καὶ περισκελὲς λινοῦν ἐνδύσεται περὶ τὸ σῶμα αὐτοῦ, καὶ ἀφελεῖ τὴν κατακάρπωσιν, ἣν ἂν καταναλώσῃ τὸ πῦρ, τὴν ὁλοκαύτωσιν ἀπὸ τοῦ θυσιαστηρίου· καὶ παραθήσει αὐτὸ ἐχόμενον τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Καὶ ἐκδύσεται τὴν στολὴν αὐτοῦ, καὶ ἐνδύσεται στολὴν ἄλλην· καὶ ἐξοίσει τὴν κατακάρπωσιν ἔξω τῆς παρεμβολῆς εἰς τόπον καθαρόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Καὶ πῦρ ἐπὶ τὸ θυσιαστήριον καυθήσεται ἀπʼ αὐτοῦ, καὶ οὐ σβεσθήσεται· καὶ καύσει ἐπʼ αὐτοῦ ὁ ἱερεὺς ξύλα τοπρωῒ πρωῒ, καὶ στοιβάσει ἐπʼ αὐτοῦ τὴν ὁλοκαύτωσιν, καὶ ἐπιθήσει ἐπʼ αὐτὸ τὸ στέαρ τοῦ σωτηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Καὶ πῦρ διαπαντὸς καυθήσεται ἐπὶ τὸ θυσιαστήριον, οὐ σβεσθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Οὗτος ὁ νόμος τῆς θυσίας, ἣν προσάξουσιν αὐτὴν οἱ υἱοὶ Ἀαρὼν ἔναντι Κυρίου, ἀπέναντι τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Καὶ ἀφελεῖ ἀπʼ αὐτοῦ τῇ δρακὶ ἀπὸ τῆς σεμιδάλεως τῆς θυσίας σὺν τῷ ἐλαίῳ αὐτῆς, καὶ σὺν παντὶ τῷ λιβάνῳ αὐτῆς, τὰ ὄντα ἐπὶ τῆς θυσίας· καὶ ἀνοίσει ἐπὶ τὸ θυσιαστήριον κάρπωμα ὀσμὴν εὐωδίας, τὸ μνημόσυνον αὐτῆς τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Τὸ δὲ καταλειφθὲν ἀπʼ αὐτῆς ἔδεται Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ· ἄζυμα βρωθήσεται ἐν τόπῳ ἁγίῳ· ἐν αὐλῇ τῆς σκηνῆς τοῦ μαρτυρίου ἔδονται αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Οὐ πεφθήσεται ἐζυμωμένη· μερίδα αὐτὴν ἔδωκα αὐτοῖς ἀπὸ τῶν καρπωμάτων Κυρίου· ἅγια ἁγίων ἐστὶν, ὥσπερ τὸ τῆς ἁμαρτίας, καὶ ὥσπερ τὸ τῆς πλημμελείας. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Πᾶν ἀρσενικὸν τῶν ἱερέων ἔδονται αὐτήν· νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν ἀπὸ τῶν καρπωμάτων Κυρίου· πᾶς ὃς ἐὰν ἅψηται αὐτῶν, ἁγιασθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","τοῦτο τὸ δῶρον Ἀαρὼν καὶ τῶν υἱῶν αὐτοῦ, ὃ προσοίσουσι Κυρίῳ ἐν τῇ ἡμέρᾳ, ᾗ ἂν χρίσῃς αὐτόν· τὸ δέκατον τοῦ οἰφὶ σεμιδάλεως εἰς θυσίαν διαπαντὸς, τὸ ἥμισυ αὐτῆς τὸπρωῒ, καὶ τὸ ἥμισυ αὐτῆς τοδειλινόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ἐπὶ τηγάνου ἐν ἐλαίῳ ποιηθήσεται, πεφυραμένην οἴσει αὐτήν ἑλικτά, θυσίαν ἐκ κλασμάτων, θυσίαν εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ὁ ἱερεὺς ὁ χριστὸς ὁ ἀντʼ αὐτοῦ ἐκ τῶν υἱῶν αὐτοῦ ποιήσει αὐτήν· νόμος αἰώνιος· ἅπαν ἐπιτελεσθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Καὶ πᾶσα θυσία ἱερέως ὁλόκαυτος ἔσται, καὶ οὐ βρωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","λάλησον τῷ Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, λέγων, οὗτος ὁ νόμος τῆς ἁμαρτίας· ἐν τόπῳ οὗ σφάζουσι τὸ ὁλοκαύτωμα, σφάξουσι τὰ περὶ τῆς ἁμαρτίας ἔναντι Κυρίου· ἅγια ἁγίων ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ὁ ἱερεὺς ὁ ἀναφέρων αὐτὴν, ἔδεται αὐτήν· ἐν τόπῳ ἁγίῳ βρωθήσεται, ἐν αὐλῇ τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Πᾶς ὁ ἁπτόμενος τῶν κρεῶν αὐτῆς, ἁγιασθήσεται· καὶ ᾧ ἐὰν ἐπιῤῥαντισθῇ ἀπὸ τοῦ αἵματος αὐτῆς ἐπὶ τὸ ἱμάτιον, ὃς ἐὰν ῥαντισθῇ ἐπʼ αὐτὸ, πλυθήσεται ἐν τόπῳ ἁγίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Καὶ σκεῦος ὀστράκινον, οὗ ἐὰν ἑψεθῇ ἐν αὐτῷ, συντριβήσεται· ἐὰν δὲ ἐν σκεύει χαλκῷ ἑψηθῇ, ἐκτρίψει αὐτὸ, καὶ ἐκκλύσει ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Πᾶς ἄρσην ἐν τοῖς ἱερεῦσιν φάγεται αὐτά ἅγια ἁγίων ἐστὶ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Καὶ πάντα τὰ περὶ τῆς ἁμαρτίας, ὧν ἐὰν εἰσενεχθῇ ἀπὸ τοῦ αἵματος αὐτῶν εἰς τὴν σκηνὴν τοῦ μαρτυρίου ἐξιλάσασθαι ἐν τῷ ἁγίῳ, οὐ βρωθήσεται· ἐν πυρὶ κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Καὶ οὗτος ὁ νόμος τοῦ κριοῦ τοῦ περὶ τῆς πλημμελείας· ἅγια ἁγίων ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ἐν τόπῳ οὗ σφάζουσι τὸ ὁλοκαύτωμα, σφάξουσι τὸν κριὸν τῆς πλημμελείας ἔναντι Κυρίου· καὶ τὸ αἷμα προσχεεῖ ἐπὶ τὴν βάσιν τοῦ θυσιαστηρίου κύκλῳ· ");
INSERT INTO grcbrent_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Καὶ πᾶν τὸ στέαρ αὐτοῦ προσοίσει ἀπʼ αὐτοῦ, καὶ τὴν ὀσφὺν, καὶ πᾶν τὸ στέαρ τὸ κατακαλύπτον τὰ ἐνδόσθια, καὶ πᾶν τὸ στέαρ τὸ ἐπὶ τῶν ἐνδοσθίων, ");
INSERT INTO grcbrent_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, τὸ ἐπὶ τῶν μηρίων, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος σὺν τοῖς νεφροῖς, περιελεῖ αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Καὶ ἀνοίσει αὐτὰ ὁ ἱερεὺς ἐπὶ τὸ θυσιαστήριον κάρπωμα τῷ Κυρίῳ· περὶ πλημμελείας ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Πᾶς ἄρσην ἐκ τῶν ἱερέων ἔδεται αὐτά· ἐν τόπῳ ἁγίῳ ἔδονται αὐτά ἅγια ἁγίων ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ὥσπερ τὸ περὶ τῆς ἁμαρτίας, οὕτω καὶ τὸ τῆς πλημμελείας· νόμος εἷς αὐτῶν· ὁ ἱερεὺς ὅστις ἐξιλάσεται ἐν αὐτῷ, αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Καὶ ὁ ἱερεὺς ὁ προσάγων ὁλοκαύτωμα ἀνθρώπου, τὸ δέρμα τῆς ὁλοκαυτώσεως, ἧς προσφέρει αὐτὸς, αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Καὶ πᾶσα θυσία ἥτις ποιηθήσεται ἐν τῷ κλιβάνῳ, καὶ πᾶσα ἥτις ποιηθήσεται ἐπʼ ἐσχάρας, ἢ ἐπὶ τηγάνου, τοῦ ἱερέως τοῦ προσφέροντος αὐτὴν, αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Καὶ πᾶσα θυσία ἀναπεποιημένη ἐν ἐλαίῳ, καὶ μὴ ἀναπεποιημένη, πᾶσι τοῖς υἱοῖς Ἀαρὼν ἔσται, ἑκάστῳ τὸ ἶσον. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Οὗτος ὁ νόμος θυσίας σωτηρίου, ἣν προσοίσουσι Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ἐὰν μὲν περὶ αἰνέσεως προσφέρῃ αὐτήν, καὶ προσοίσει ἐπὶ τῆς θυσίας τῆς αἰνέσεως ἄρτους ἐκ σεμιδάλεως ἀναπεποιημένους ἐν ἐλαίῳ, καὶ λάγανα ἄζυμα διακεχρισμένα ἐν ἐλαίῳ, καὶ σεμίδαλιν πεφυραμένην ἐν ἐλαίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ἐπʼ ἄρτοις ζυμίταις προσοίσει τὰ δῶρα αὐτοῦ ἐπὶ θυσίᾳ αἰνέσεως σωτηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Καὶ προσάξει ἓν ἀπὸ πάντων τῶν δώρων αὐτοῦ, ἀφαίρεμα Κυρίῳ· τῷ ἱερεῖ τῷ προσχέοντι τὸ αἷμα τοῦ σωτηρίου, αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Καὶ τὰ κρέα θυαίας αἰνέσεως σωτηρίου αὐτῷ ἔσται· καὶ ἐν ᾗ ἡμέρᾳ δωρεῖται, βρωθήσεται· οὐ καταλείψουσιν ἀπʼ αὐτοῦ εἰς τὸ πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Καὶ ἐὰν εὐχὴ ᾖ, ἢ ἑκούσιον θυσιάζῃ τὸ δῶρον αὐτοῦ, ᾗ ἂν ἡμέρᾳ προσαγάγῃ τὴν θυσίαν αὐτοῦ, βρωθήσεται, καὶ τῇ αὔριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Καὶ τὸ καταλειφθὲν ἀπὸ τῶν κρεῶν τῆς θυσίας ἕως ἡμέρας τρίτης, ἐν πυρὶ κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ἐὰν δὲ φαγὼν φάγῃ ἀπὸ τῶν κρεῶν τῇ ἡμέρᾳ τῇ τρίτῃ, οὐ δεχθήσεται αὐτῷ τῷ προσφέροντι αὐτό· οὐ λογισθήσεται αὐτῷ, μίασμά ἐστιν· ἡ δὲ ψυχὴ ἥτις ἐὰν φάγῃ ἀπʼ αὐτοῦ, τὴν ἁμαρτίαν λήψεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Καὶ κρέα ὅσα ἐὰν ἅψηται παντὸς ἀκαθάρτου, οὐ βρωθήσεται, ἐν πυρὶ κατακαυθήσεται· πᾶς καθαρὸς φάγεται κρέα. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ἡ δὲ ψυχὴ ἥτις ἐὰν φάγῃ ἀπὸ τῶν κρεῶν τῆς θυσίας τοῦ σωτηρίου, ὅ ἐστι Κυρίου, καὶ ἡ ἀκαθαρσία αὐτοῦ ἐπʼ αὐτῷ, ἀπολεῖται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Καὶ ἡ ψυχὴ ἣ ἂν ἅψηται παντὸς πράγματος ἀκαθάρτου, ἢ ἀπὸ ἀκαθαρσίας ἀνθρώπου, ἢ τῶν τετραπόδων τῶν ἀκαθάρτω ἢ παντὸς βδελύγματος ἀκαθάρτου, καὶ φάγῃ ἀπὸ τῶν κρεῶν τῆς θυσίας τοῦ σωτηρίου, ὅ ἐστι Κυρίου, ἀπολεῖται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, πᾶν στέαρ βοῶν, καὶ προβάτων, καὶ αἰγῶν οὐκ ἔδεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Καὶ στέαρ θνησιμαίων καὶ θηριαλώτων ποιηθήσεται εἰς πᾶν ἔργον, καὶ εἰς βρῶσιν οὐ βρωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Πᾶς ὁ ἔσθων στέαρ ἀπὸ τῶν κτηνῶν, ὧν προσάξει ἀπʼ αὐτῶν κάρπωμα Κυρίῳ, ἀπολεῖται ἡ ψυχὴ ἐκείνη ἀπὸ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Πᾶν αἷμα οὐκ ἔδεσθε ἐν πάσῃ τῇ κατοικίᾳ ὑμῶν, ἀπό τε τῶν κτηνῶν καὶ ἀπὸ τῶν πετεινῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Πᾶσα ψυχὴ ἣ ἂν φάγῃ αἷμα, ἀπολεῖται ἡ ψυχὴ ἐκείνη ἀπὸ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","καὶ τοῖς υἱοῖς Ἰσραὴλ λαλήσεις, λέγων, ὁ προσφέρων θυσίαν σωτηρίου, οἴσει τὸ δῶρον αὐτοῦ Κυρίῳ καὶ ἀπὸ τῆς θυσίας τοῦ σωτηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Αἱ χεῖρες αὐτοῦ προσοίσουσι τὰ καρπώματα Κυρίῳ· τὸ στέαρ τὸ ἐπὶ τοῦ στηθυνίου, καὶ τὸν λοβὸν τοῦ ἥπατος προσοίσει αὐτὰ, ὥστε ἐπιτιθέναι δόμα ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Καὶ ἀνοίσει ὁ ἱερεὺς τὸ στέαρ ἐπὶ τοῦ θυσιαστηρίου· καὶ ἔσται τὸ στηθύνιον Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Καὶ τὸν βραχίονα τὸν δεξιὸν δώσετε ἀφαίρεμα τῷ ἱερεῖ ἀπὸ τῶν θυσιῶν τοῦ σωτηρίου ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ὁ προσφέρων τὸ αἷμα τοῦ σωτηρίου, καὶ τὸ στέαρ τὸ ἀπὸ τῶν υἱῶν Ἀαρὼν, αὐτῷ ἔσται ὁ βραχίων ὁ δεξιὸς ἐν μερίδι. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Τὸ γὰρ στηθύνιον τοῦ ἐπιθέματος καὶ τὸν βραχίονα τοῦ ἀφαιρέματος εἴληφα παρὰ τῶν υἱῶν Ἰσραὴλ ἀπὸ τῶν θυσιῶν τοῦ σωτηρίου ὑμῶν, καὶ ἔδωκα αὐτὰ Ἀαρὼν τῷ ἱερεῖ καὶ τοῖς υἱοῖς αὐτοῦ, νόμιμον αἰώνιον παρὰ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Αὕτη ἡ χρίσις Ἀαρὼν, καὶ ἡ χρίσις τῶν υἱῶν αὐτοῦ ἀπὸ τῶν καρπωμάτων Κυρίου, ἐν ᾗ ἡμέρᾳ προσηγάγετο αὐτοὺς τοῦ ἱερατεύειν τῷ Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","καθὰ ἐνετείλατο Κύριος δοῦναι αὐτοῖς ᾗ ἡμέρᾳ ἔχρισεν αὐτοὺς παρὰ τῶν υἱῶν Ἰσραὴλ, νόμιμον αἰώνιον εἰς τὰς γενεὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Οὗτος ὁ νόμος τῶν ὁλοκαυτωμάτων, καὶ θυσίας, καὶ περὶ ἁμαρτίας, καὶ τῆς πλημμελείας καὶ τῆς τελειώσεως, καὶ τῆς θυσίας τοῦ σωτηρίου, ");
INSERT INTO grcbrent_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ὃν τρόπον ἐνετείλατο Κύριος τῷ Μωυσῇ ἐν τῷ ὄρει Σινᾷ, ᾗ ἡμέρᾳ ἐνετείλατο τοῖς υἱοῖς Ἰσραὴλ προσφέρειν τὰ δῶρα αὐτῶν ἔναντι Κυρίου ἐν τῇ ἐρήμῳ Σινᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","λάβε Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ, καὶ τὰς στολὰς αὐτοῦ, καὶ τὸ ἔλαιον τῆς χρίσεως, καὶ τὸν μόσχον τὸν περὶ τῆς ἁμαρτίας, καὶ τοὺς δύο κριοὺς, καὶ τὸ κανοῦν τῶν ἀζύμων, ");
INSERT INTO grcbrent_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","καὶ πᾶσαν τὴν συναγωγὴν ἐκκλησίασον ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Καὶ ἐποίησε Μωυσῆς ὃν τρόπον συνέταξεν αὐτῷ Κύριος· καὶ ἐξεκκλησίασε τὴν συναγωγὴν ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Καὶ εἶπε Μωυσῆς τῇ συναγωγῇ, τοῦτό ἐστι τὸ ῥῆμα, ὃ ἐνετείλατο Κύριος ποιῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Καὶ προσήνεγκε Μωυσῆς τὸν Ἀαρὼν, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ ἔλουσεν αὐτοὺς ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Καὶ ἐνέδυσεν αὐτὸν τὸν χιτῶνα, καὶ ἔζωσεν αὐτὸν τὴν ζώνην, καὶ ἐνέδυσεν αὐτὸν τὸν ὑποδύτην, καὶ ἐπέθηκεν ἐπʼ αὐτὸν τὴν ἐπωμίδα. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Καὶ συνέζωσεν αὐτὸν κατὰ τὴν ποίησιν τῆς ἐπωμίδος, καὶ συνέσφιγξεν αὐτὸν ἐν αὐτῇ· καὶ ἐπέθηκεν ἐπʼ αὐτὴν τὸ λογεῖον, καὶ ἐπέθηκεν ἐπὶ τὸ λογεῖον τὴν δήλωσιν καὶ τὴν ἀλήθειαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Καὶ ἐπέθηκε τὴν μίτραν ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ ἐπέθηκεν ἐπὶ τὴν μίτραν κατὰ πρόσωπον αὐτοῦ τὸ πέταλον τὸ χρυσοῦν τὸ καθηγιασμένον ἅγιον, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Καὶ ἔλαβε Μωυσῆς ἀπὸ τοῦ ἐλαίου τῆς χρίσεως, ");
INSERT INTO grcbrent_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","καὶ ἔῤῥανεν ἀπʼ αὐτοῦ ἐπὶ τὸ θυσιαστήριον ἑπτάκις· καὶ ἔχρισε τὸ θυσιαστήριον, καὶ ἡγίασεν αὐτὸ, καὶ πάντα τὰ ἐν αὐτῷ, καὶ τὸν λουτῆρα, καὶ τὴν βάσιν αὐτοῦ, καὶ ἡγίασεν αὐτά· καὶ ἔχρισε τὴν σκηνὴν, καὶ πάντα τὰ σκεύη αὐτῆς, καὶ ἡγίασεν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Καὶ ἐπέχεε Μωυσῆς ἀπὸ τοῦ ἐλαίου τῆς χρίσεως ἐπὶ τὴν κεφαλὴν Ἀαρών· καὶ ἔχρισεν αὐτὸν, καὶ ἡγίασεν αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Καὶ προσήγαγε Μωυσῆς τοὺς υἱοὺς Ἀαρὼν, καὶ ἐνέδυσεν αὐτοὺς χιτῶνας, καὶ ἔζωσεν αὐτοὺς ζώνας, καὶ περιέθηκεν αὐτοῖς κιδάρεις, καθάπερ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Καὶ προσήγαγε Μωυσῆς τὸν μόσχον τὸν περὶ τῆς ἁμαρτίας· καὶ ἐπέθηκεν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας ἐπὶ τὴν κεφαλὴν τοῦ μόσχου τοῦ τῆς ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Καὶ ἔσφαξεν αὐτόν· καὶ ἔλαβε Μωυσῆς ἀπὸ τοῦ αἵματος, καὶ ἐπέθηκεν ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου κύκλῳ τῷ δακτύλῳ, καὶ ἐκαθάρισε τὸ θυσιαστήριον· καὶ τὸ αἷμα ἐξέχεεν ἐπὶ τὴν βάσιν τοῦ θυσιαστηρίου, καὶ ἡγίασεν αὐτὸ, τοῦ ἐξιλάσασθαι ἐπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Καὶ ἔλαβε Μωυσῆς πᾶν τὸ στέαρ τὸ ἐπὶ τῶν ἐνδοσθίων, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος, καὶ ἀμφοτέρους τοὺς νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, καὶ ἀνήνεγκε Μωυσῆς ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Καὶ τὸν μόσχον, καὶ τὴν βύρσαν αὐτοῦ, καὶ τὰ κρέα αὐτοῦ, καὶ τὴν κόπρον αὐτοῦ, κατέκαυσεν αὐτὰ πυρὶ ἔξω τῆς παρεμβολῆς, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Καὶ προσήγαγε Μωυσῆς τὸν κριὸν τὸν εἰς ὁλοκαύτωμα· καὶ ἐπέθηκεν Ἀαρὼν καὶ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ κριοῦ. Καὶ ἔσφαξε Μωυσῆς τὸν κριόν· καὶ προσέχεε Μωυσῆς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Καὶ τὸν κριὸν ἐκρεανόμησε κατὰ μέλη· καὶ ἀνήνεγκε Μωυσῆς τὴν κεφαλὴν, καὶ τὰ μέλη, καὶ τὸ στέαρ· καὶ τὴν κοιλίαν, καὶ τοὺς πόδας ἔπλυνεν ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Καὶ ἀνήνεγκε Μωυσῆς ὅλον τὸν κριὸν ἐπὶ τὸ θυσιαστήριον· ὁλοκαύτωμά ἐστιν εἰς ὀσμὴν εὐωδίας· κάρπωμά ἐστι τῷ Κυρίῳ, καθάπερ ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Καὶ προσήγαγε Μωυσῆς τὸν κριὸν τὸν δεύτερον, κριὸν τελειώσεως· καὶ ἐπέθηκεν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν τοῦ κριοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Καὶ ἔσφαξεν αὐτόν· καὶ ἔλαβε Μωυσῆς ἀπὸ τοῦ αἵματος αὐτοῦ, καὶ ἐπέθηκεν ἐπὶ τὸν λοβὸν τοῦ ὠτὸς Ἀαρὼν τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς χειρὸς τῆς δεξιᾶς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς τοῦ δεξιοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Καὶ προσήγαγε Μωυσῆς τοὺς υἱοὺς Ἀαρών· καὶ ἐπέθηκε Μωυσῆς ἀπὸ τοῦ αἵματος ἐπὶ τοὺς λοβοὺς τῶν ὤτων τῶν δεξιῶν, καὶ ἐπὶ τὰ ἄκρα τῶν χειρῶν αὐτῶν τῶν δεξιῶν· καὶ ἐπὶ τὰ ἄκρα τῶν ποδῶν αὐτῶν τῶν δεξιῶν· καὶ προσέχεε Μωυσῆς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Καὶ ἔλαβε τὸ στέαρ, καὶ τὴν ὀσφὺν, καὶ τὸ στέαρ τὸ ἐπὶ τῆς κοιλίας, καὶ τὸν λοβὸν τοῦ ἥπατος, καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, καὶ τὸν βραχίονα τὸν δεξιόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Καὶ ἀπὸ τοῦ κανοῦ τῆς τελειώσεως, τοῦ ὄντος ἔναντι Κυρίου, καὶ ἔλαβεν ἄρτον ἕνα ἄζυμον, καὶ ἄρτον ἐξ ἐλαίου ἕνα, καὶ λάγανον ἓν, καὶ ἐπέθηκεν ἐπὶ τὸ στέαρ, καὶ τὸν βραχίονα τὸν δεξιόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Καὶ ἐπέθηκεν ἅπαντα ἐπὶ τὰς χεῖρας Ἀαρὼν, καὶ ἐπὶ τὰς χεῖρας τῶν υἱῶν αὐτοῦ, καὶ ἀνήνεγκεν αὐτὰ ἀφαίρεμα ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Καὶ ἔλαβε Μωυσῆς ἀπὸ τῶν χειρῶν αὐτῶν, καὶ ἀνήνεγκεν αὐτὰ Μωυσῆς ἐπὶ τὸ θυσιαστήριον, ἐπὶ τὸ ὁλοκαύτωμα τῆς τελειώσεως, ὅ ἐστι ὀσμὴ εὐωδίας· κάρπωμά ἐστιν τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Καὶ λαβὼν Μωυσῆς τὸ στηθύνιον, ἀφεῖλεν αὐτὸ ἐπίθεμα ἔναντι Κυρίου, ἀπὸ τοῦ κριοῦ τῆς τελειώσεως· καὶ ἐγένετο Μωυσῇ ἐν μεριδι, καθὰ ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Καὶ ἔλαβε Μωυσῆς ἀπὸ τοῦ ἐλαίου τῆς χρίσεως, καὶ ἀπὸ τοῦ αἵματος τοῦ ἐπὶ τοῦ θυσιαστηρίου, καὶ προσέῤῥνεν ἐπὶ Ἀαρὼν, καὶ τὰς στολὰς αὐτοῦ, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ τὰς στολὰς τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Καὶ ἡγίασεν Ἀαρὼν, καὶ τὰς στολάς αὐτοῦ, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ τὰς στολὰς τῶν υἱῶν αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν, καὶ τοὺς υἱοὺς αὐτοῦ, ἑψήσατε τὰ κρέα ἐν τῇ αὐλῇ τῆς σκηνῆς τοῦ μαρτυρίου ἐν τόπῳ ἁγίῳ· καὶ ἐκεῖ φάγεσθε αὐτὰ, καὶ τοὺς ἄρτους τοὺς ἐν τῷ κανῷ τῆς τελειώσεως, ὃν τρόπον συντέτακταί μοι, λέγων, Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ φάγονται αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Καὶ τὸ καταλειφθὲν τῶν κρεῶν καὶ τῶν ἄρτων ἐν πυρὶ κατακαύσατε. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Καὶ ἀπὸ τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου οὐκ ἐξελεύσεσθε ἑπτὰ ἡμέρας, ἕως ἡμέρα πληρωθῇ, ἡμέρα τελειώσεως ὑμῶν· ἑπτὰ γὰρ ἡμέρας τελειώσει τὰς χεῖρας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Καθάπερ ἐποίησεν ἐν τῇ ἡμέρᾳ ταύτῃ, ᾗ ἐνετείλατο Κύριος τοῦ ποιῆσαι, ὥστε ἐξιλάσασθαι περὶ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Καὶ ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου καθήσεσθε ἑπτὰ ἡμέρας, ἡμέραν καὶ νύκτα· φυλάξεσθε τὰ φυλάγματα Κυρίου, ἵνα μὴ ἀποθάνητε· οὕτω γὰρ ἐνετείλατό μοι Κύριος ὁ Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Καὶ ἐποίησεν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ πάντας τοὺς λόγους, οὓς συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Καὶ ἐγενήθη τῇ ἡμέρᾳ τῇ ὀγδόῃ, ἐκάλεσε Μωυσῆς Ἀαρὼν, καὶ τοὺς υἱοὺς αὐτοῦ, καὶ τὴν γερουσίαν Ἰσραὴλ, ");
INSERT INTO grcbrent_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","καὶ εἶπε Μωυσῆς πρὸς Ἀαρών, λάβε σεαυτῷ μοσχάριον ἐκ βοῶν περὶ ἁμαρτίας, καὶ κριὸν εἰς ὁλοκαύτωμα, ἄμωμα, καὶ προσένεγκε αὐτὰ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Καὶ τῇ γερουσίᾳ Ἰσραὴλ λάλησον, λέγων, λάβετε χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, καὶ μοσχάριον, καὶ ἀμνὸν ἐνιαύσιον εἰς ὁλοκάρπωσιν, ἄμωμα, ");
INSERT INTO grcbrent_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","καὶ μόσχον, καὶ κριὸν εἰς θυσίαν σωτηρίου ἔναντι Κυρίου, καὶ σεμίδαλιν πεφυραμένην ἐν ἐλαίῳ· ὅτι σήμερον Κύριος ὀφθήσεται ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Καὶ ἔλαβον καθὸ ἐνετείλατο Μωυσῆς ἀπέναντι τῆς σκηνῆς τοῦ μαρτυρίου· καὶ προσῆλθε πᾶσα συναγωγὴ, καὶ ἔστησαν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Καὶ εἶπε Μωυσῆς, τοῦτο τὸ ῥῆμα, ὃ εἶπε Κύριος, ποιήσατε, καὶ ὀφθήσεται ἐν ὑμῖν ἡ δόξα Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Καὶ εἶπε Μωυσῆς τῷ Ἀαρὼν, πρόσελθε πρὸς τὸ θυσιαστήριον, καὶ ποίησον τὸ περὶ τῆς ἁμαρτίας σου, καὶ τὸ ὁλοκαύτωμά σου, καὶ ἐξίλασαι περὶ σεαυτοῦ, καὶ τοῦ οἴκου σου· καὶ ποίησον τὰ δῶρα τοῦ λαοῦ, καὶ ἐξίλασαι περὶ αὐτῶν, καθάπερ ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Καὶ προσῆλθεν Ἀαρὼν πρὸς τὸ θυσιαστήριον, καὶ ἔσφαξε τὸ μοσχάριον τὸ περὶ τῆς ἁμαρτίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Καὶ προσήνεγκαν οἱ υἱοὶ Ἀαρὼν τὸ αἷμα πρὸς αὐτόν· καὶ ἔβαψε τὸν δάκτυλον εἰς τὸ αἷμα, καὶ ἐπέθηκεν ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου· καὶ τὸ αἷμα ἐξέχεεν ἐπὶ τὴν βάσιν τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Καὶ τὸ στέαρ καὶ τοὺς νεφροὺς καὶ τὸν λοβὸν τοῦ ἥπατος τοῦ περὶ τῆς ἁμαρτίας ἀνήνεγκεν ἐπὶ τὸ θυσιαστήριον, ὃν τρόπον ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Καὶ τὰ κρέα καὶ τὴν βύρσαν κατέκαυσεν αὐτὰ πυρὶ, ἔξω τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Καὶ ἔσφαξε τὸ ὁλοκαύτωμα· καὶ προσήνεγκαν οἱ υἱοὶ Ἀαρὼν τὸ αἷμα πρὸς αὐτόν· καὶ προσέχεεν ἐπὶ τὸ θυσιαστήριον κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Καὶ τὸ ὁλοκαύτωμα προσήνεγκαν αὐτὸ κατὰ μέλη· αὐτὰ καὶ τὴν κεφαλὴν ἐπέθηκεν ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Καὶ ἔπλυνε τὴν κοιλίαν καὶ τοὺς πόδας ὕδατι· καὶ ἐπέθηκεν ἐπὶ τὸ ὁλοκαύτωμα ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Καὶ προσήνεγκε τὸ δῶρον τοῦ λαοῦ, καὶ ἔλαβε τὸν χίμαρον τὸν περὶ τῆς ἁμαρτίας τοῦ λαοῦ, καὶ ἔσφαξεν αὐτὸν, καὶ ἐκαθάρισεν αὐτὸν, καθὰ καὶ τὸν πρῶτον. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Καὶ προσήνεγκε τὸ ὁλοκαύτωμα, καὶ ἐποίησεν αὐτὸ ὡς καθήκει. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Καὶ προσήνεγκε τὴν θυσίαν, καὶ ἔπλησε τὰς χεῖρας ἀπʼ αὐτῆς, καὶ ἐπέθηκεν ἐπὶ τὸ θυσιαστήριον χωρὶς τοῦ ὁλοκαυτώματος τοῦ πρωϊνοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Καὶ ἔσφαξε τὸν μόσχον, καὶ τὸν κριὸν τῆς θυσίας τοῦ σωτηρίου τῆς τοῦ λαοῦ· καὶ προσήνεγκαν οἱ υἱοὶ Ἀαρὼν τὸ αἷμα πρὸς αὐτόν, καὶ προσέχεε πρὸς τὸ θυσιαστήριον κύκλῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","καὶ τὸ στέαρ τὸ ἀπὸ τοῦ μόσχου, καὶ τοῦ κριοῦ τὴν ὀσφὺν, καὶ τὸ στέαρ τὸ κατακαλύπτον ἐπὶ τῆς κοιλίας, καὶ τοὺς δύο νεφροὺς, καὶ τὸ στέαρ τὸ ἐπʼ αὐτῶν, καὶ τὸν λοβὸν τὸν ἐπὶ τοῦ ἥπατος. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Καὶ ἐπέθηκε τὰ στέατα ἐπὶ τὰ στηθύνια καὶ ἀνήνεγκε τὰ στέατα ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Καὶ τὸ στηθύνιον, καὶ τὸν βραχίονα τὸν δεξιὸν ἀφεῖλεν Ἀαρὼν ἀφαίρεμα ἔναντι Κυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Καὶ ἐξάρας Ἀαρὼν τὰς χεῖρας ἐπὶ τὸν λαὸν, εὐλόγησεν αὐτούς· καὶ κατέβη ποιήσας τὸ περὶ τῆς ἁμαρτίας, καὶ τὰ ὁλοκαυτώματα, καὶ τὰ τοῦ σωτηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Καὶ εἰσῆλθε Μωυσῆς καὶ Ἀαρὼν εἰς τὴν σκηνὴν τοῦ μαρτυρίου· καὶ ἐξελθόντες εὐλόγησαν πάντα τὸν λαὸν· καὶ ὤφθη δόξα Κυρίου παντὶ τῷ λαῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Καὶ ἐξῆλθε πῦρ παρὰ Κυρίου, καὶ κατέφαγε τὰ ἐπὶ τοῦ θυσιαστηρίου, τά τε ὁλοκαυτώματα, καὶ τὰ στέατα· καὶ εἶδε πᾶς ὁ λαὸς, καὶ ἐξέστη, καὶ ἔπεσαν ἐπὶ πρόσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Καὶ λαβόντες οἱ δύο υἱοὶ Ἀαρὼν Ναδὰβ καὶ Ἀβιοὺδ, ἕκαστος τὸ πυρεῖον αὐτοῦ, ἐπέθηκαν ἐπʼ αὐτὸ πῦρ, καὶ ἐπέβαλον ἐπʼ αὐτὸ θυμίαμα, καὶ προσήνεγκαν ἔναντι Κυρίου πῦρ ἀλλότριον, ὃ οὐ προσέταξε Κύριος αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Καὶ ἐξῆλθε πῦρ παρὰ Κυρίου, καὶ κατέφαγεν αὐτοὺς, καὶ ἀπέθανον ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν, τοῦτό ἐστιν, ὃ εἶπε Κύριος, λέγων, ἐν τοῖς ἐγγίζουσί μοι ἁγιασθήσομαι, καὶ ἐν πάσῃ τῇ συναγωγῇ δοξασθήοσμαι· καὶ κατενύχθη Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Καὶ ἐκάλεσε Μωυσῆς τὸν Μισαδάη, καὶ τὸν Ἐλισαφὰν, υἱοὺς Ὀζιὴλ, υἱοὺς τοῦ ἀδελφοῦ τοῦ πατρὸς Ἀαρὼν, καὶ εἶπεν αὐτοῖς, προσέλθατε καὶ ἄρατε τοὺς ἀδελφοὺς ὑμῶν ἐκ προσώπου τῶν ἁγίων ἔξω τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Καὶ προσῆλθον, καὶ ᾖραν αὐτοὺς ἐν τοῖς χιτῶσιν αὐτῶν ἔξω τῆς παρεμβολῆς, ὃν τρόπον εἶπε Μωυσῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν καὶ Ἐλεάζαρ καὶ Ἰθάμαρ τοὺς υἱοὺς αὐτοῦ τοὺς καταλελειμμένους, τὴν κεφαλὴν ὑμῶν οὐκ ἀποκιδαρώσετε, καὶ τὰ ἱμάτια ὑμῶν οὐ διαῤῥήξετε, ἵνα μὴ ἀποθάνητε, καὶ ἐπὶ πᾶσαν τὴν συναγωγὴν ἔσται θυμός· οἱ δὲ ἀδελφοὶ ὑμῶν, πᾶς ὁ οἶκος Ἰσραὴλ, κλαύσονται τὸν ἐμπυρισμὸν, ὃν ἐνεπυρίσθησαν ὑπὸ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Καὶ ἀπὸ τὴς θύρας τῆς σκηνῆς τοῦ μαρτυρίου οὐκ ἐξελεύσεσθε, ἵνα μὴ ἀποθάνητε· τὸ ἔλαιον γὰρ τῆς χρίσεως, τὸ παρὰ Κυρίου, ἐφʼ ὑμῖν, καὶ ἐποίησαν κατὰ τὸ ῥῆμα Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Καὶ ἐλάλησε Κύριος τῷ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","οἶνον καὶ σίκερα οὐ πίεσθε σὺ καὶ οἱ υἱοί σου μετὰ σοῦ, ἡνίκα ἐὰν εἰσπορεύησθε εἰς τὴν σκηνὴν τοῦ μαρτυρίου, ἢ προσπορευομένων ὑμῶν πρὸς τὸ θυσιαστήριον, καὶ οὐ μὴ ἀποθάνητε· νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","διαστεῖλαι ἀναμέσον τῶν ἁγίων καὶ τῶν βεβήλων, καὶ ἀναμέσον τῶν ἀκαθάρτων καὶ τῶν καθαρῶν, ");
INSERT INTO grcbrent_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","καὶ συμβιβάξειν τοὺς υἱοὺς Ἰσραὴλ ἅπαντα τὰ νόμιμα, ἃ ἐλάλησε Κύριος πρὸς αὐτοὺς διὰ χειρὸς Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν καὶ πρὸς Ἐλεάζαρ καὶ Ἰθάμαρ τοὺς υἱοὺς Ἀαρὼν τοὺς καταλειφθέντας, λάβετε τὴν θυσίαν τὴν καταλειφθεῖσαν ἀπὸ τῶν καρπωμάτων Κυρίου, καὶ φάγεσθε ἄζυμα παρὰ τὸ θυσιαστήριον· ἅγια ἁγίων ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Καὶ φάγεσθε αὐτὴν ἐν τόπῳ ἁγίῳ· νόμιμον γάρ σοι ἐστὶ, καὶ νόμιμον τοῖς υἱοῖς σου τοῦτο ἀπὸ τῶν καρπωμάτων Κυρίου· οὕτω γὰρ ἐντέταλταί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Καὶ τὸ στηθύνιον τοῦ ἀφορίσματος, καὶ τὸν βραχίονα τοῦ ἀφαιρέματος φάγεσθε ἐν τόπῳ ἁγίῳ, σὺ καὶ οἱ υἱοί σου καὶ ὁ οἶκός σου μετὰ σοῦ· νόμιμον γὰρ σοι, καὶ νόμιμον τοῖς υἱοῖς σου ἐδόθη ἀπὸ τῶν θυσιῶν τοῦ σωτηρίου τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Τὸν βραχίονα τοῦ ἀφαιρέματος, καὶ τὸ στηθύνιον τοῦ ἀφορίσματος ἐπὶ τῶν καρπωμάτων τῶν στεάτωι· προσοίσουσιν ἀφόρισμα ἀφορίσαι ἔναντι Κυρίου· καὶ ἔσται σοι καὶ τοῖς υἱοῖς σου καὶ ταῖς θυγατράσι σου μετὰ σοῦ νόμιμον αἰώνιον, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Καὶ τὸν χίμαρον τὸν περὶ τῆς ἁμαρτίας ζητῶν ἐξεζήτησε Μωυσῆς· καὶ ὁ δὲ ἐνπεπύριστο· καὶ ἐθυμώθη Μωυσῆς ἐπὶ Ἐλεάζαρ καὶ Ἰθάμαρ τοὺς υἱοὺς Ἀαρὼν τοὺς καταλελειμμένους, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","διατί οὐκ ἐφάγετε τὸ περὶ τῆς ἁμαρτίας ἐν τόπῳ ἁγίῳ; ὅτι γὰρ ἅγια ἁγίων ἐστι, τοῦτο ἔδωκεν ὑμῖν φαγεῖν, ἵνα ἀφέλητε τὴν ἁμαρτίαν τῆς συναγωγῆς, καὶ ἐξιλάσησθε περὶ αὐτῶν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Οὐ γὰρ εἰσήχθη τοῦ αἵματος αὐτοῦ εἰς τὸ ἅγιον· κατὰ πρόσωπον ἔσω φάγεσθε αὐτὸ ἐν τόπῳ ἁγίῳ, ὃν τρόπον μοι συνέταξε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Καὶ ἐλάλησεν Ἀαρὼν πρὸς Μωυσῆν, λέγων, εἰ σήμερον προσαγιόχασι τὰ περὶ τῆς ἁμαρτίας αὐτῶν, καὶ τὰ ὁλοκαυτώματα αὐτῶν ἔναντι Κυρίου, καὶ συμβέβηκέ μοι τοιαῦτα, καὶ φάγομαι τὰ περὶ τῆς ἁμαρτίας σήμερον, μὴ ἀρεστὸν ἔται Κυρίῳ; ");
INSERT INTO grcbrent_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Καὶ ἤκουσε Μωυσῆς, καὶ ἤρεσεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","λαλήσατε τοῖς υἱοῖς Ἰσραὴλ, λέγοντες, ταῦτα τὰ κτήνη, ἃ φάγεσθε ἀπὸ πάντων τῶν κτηνῶν τῶν ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Πᾶν κτῆνος διχηλοῦν ὁπλὴν καὶ ὀνυχιστῆρας ὀνυχίζον δύο χηλῶν, καὶ ἀνάγον μηρυκισμὸν ἐν τοῖς κτήνεσι, ταῦτα φάγεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Πλὴν ἀπὸ τούτων οὐ φάγεσθε, ἀπὸ τῶν ἀναγόντων μηρυκισμὸν, καὶ ἀπὸ τῶν διχηλούντων τὰς ὁπλὰς, καὶ ὀνυχιζόντων ὀνυχιστῆρας· τὸν κάμηλον, ὅτι ἀνάγει μηρυκισμὸν τοῦτο, ὁπλὴν δὲ οὐ διχηλεῖ, ἀκάθαρτον τοῦτο ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Καὶ τὸν δασύποδα, ὅτι ἀνάγει μηρυκισμὸν τοῦτο, καὶ ὁπλὴν οὐ διχηλεῖ, ἀκάθαρτον τοῦτο ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Καὶ τὸν χοιρογρύλλιον, ὅτι οὐκ ἀνάγει μηρυκισμὸν τοῦτο, καὶ ὁπλὴν οὐ διχηλεῖ, ἀκάθαρτον τοῦτο ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Καὶ τὸν ὗν, ὅτι διχηλεῖ ὁπλὴν τοῦτο, καὶ ὀνυχίζει ὄνυχας ὁπλῆς, καὶ τοῦτο οὐκ ἀνάγει μηρυκισμὸν, ἀκάθαρτον τοῦτο ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ἀπὸ τῶν κρεῶν αὐτῶν οὐ φάγεσθε, καὶ τῶν θνησιμαίων αὐτῶν οὐχ ἅψεσθε· ἀκάθαρτα ταῦτα ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Καὶ ταῦτα, ἃ φάγεσθε ἀπὸ πάντων τῶν ἐν τοῖς ὕδασι· πάντα ὅσα ἐστὶν αὐτοῖς πτερύγια καὶ λεπίδες ἐν τοῖς ὕδασι, καὶ ἐν ταῖς θαλάσσαις, καὶ ἐν τοῖς χειμάῤῥοις, ταῦτα φάγεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Καὶ πάντα ὅσα οὐκ ἔστιν αὐτοῖς πτερύγια, οὐδὲ λεπίδες ἐν τῷ ὕδατι, ἢ ἐν ταῖς θαλάσσαις, καὶ ἐν τοῖς χειμάῤῥοις, ἀπὸ πάντων ὧν ἐρεύγεται τὰ ὕδατα, καὶ ἀπὸ πάσης ψυχῆς τῆς ζώσης ἐν τῷ ὕδατι, βδέλυγμά ἐστι, καὶ βδελύγματα ἔσονται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ἀπὸ τῶν κρεῶν αὐτῶν οὐκ ἔδεσθε, καὶ τὰ θνησιμαῖα αὐτῶν βδελύξεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Καὶ πάντα ὅσα οὐκ ἔστιν αὐτοῖς πτερύγια, οὐδὲ λεπίδες τῶν ἐν τοῖς ὕδασι, βδέλυγμα τοῦτό ἐστιν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Καὶ ταῦτα, ἃ βδελύξεσθε ἀπὸ τῶν πετεινῶν, καὶ οὐ βρωθήσεται, βδέλυγμά ἐστι· τὸν ἀετὸν, καὶ τὸν γρύπα, καὶ τὸν ἁλιαίετον, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","καὶ τὸν γύπα, καὶ τὸν ἴκτινον καὶ τὰ ὅμοια αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Καὶ στρουθὸν, καὶ γλαῦκα, καὶ λάρον, καὶ τὰ ὅμοια αὐτῷ· ");
INSERT INTO grcbrent_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Καὶ πάντα κόρακα, καὶ τὰ ὅμοια αὐτῷ· καὶ ἱέρακα, καὶ τὰ ὅμοια αὐτῷ· ");
INSERT INTO grcbrent_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","καὶ νυκτικόρακα, καὶ καταράκτην, καὶ ἴβιν, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","καὶ πορφυρίωνα, καὶ πελεκᾶνα, καὶ κύκνον, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","καὶ ἐρωδιὸν, καὶ χαράδριον, καὶ τὰ ὅμοια αὐτῷ· καὶ ἔποπα, καὶ νυκτερίδα. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Καὶ πάντα τὰ ἑρπετὰ τῶν πετεινῶν, ἃ πορεύεται ἐπὶ τέσσαρα, βδελύγματά ἐστιν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ἀλλὰ ταῦτα φάγεσθε ἀπὸ τῶν ἑρπετῶν τῶν πετεινῶν, ἃ πορεύεται ἐπὶ τέσσαρα, ἃ ἔχει σκέλη ἀνώτερον τῶν ποδῶν αὐτοῦ, πηδᾷν ἐν αὐτοῖς ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Καὶ ταῦτα φάγεσθε ἀπʼ αὐτῶν· τὸν βροῦχον, καὶ τὰ ὅμοια αὐτῷ· καὶ τὸν ἀττάκην, καὶ τὰ ὅμοια αὐτῷ· καὶ ὀφιομάχην, καὶ τὰ ὅμοια αὐτῷ· καὶ τὴν ἀκρίδα, καὶ τὰ ὅμοια αὐτῇ· ");
INSERT INTO grcbrent_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Πᾶν ἑρπετὸν ἀπὸ τῶν πετεινῶν, οἷς εἰσι τέσσαρες πόδες, βδελύγματά ἐστιν ὑμῖν, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","καὶ ἐν τούτοις μιανθήσεσθε· πᾶς ὁ ἁπτόμενος τῶν θνησιμαίων αὐτῶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Καὶ πᾶς ὁ αἴρων τῶν θνησιμαίων αὐτῶν, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Καὶ ἐν πᾶσι τοῖς κτήνεσιν ὅ ἐστι διχηλοῦν ὁπλὴν, καὶ ὀνυχιστῆρας ὀνυχίζει, καὶ μηρυκισμὸν οὐ μηρυκᾶται, ἀκάθαρτα ἔσονται ὑμῖν· πᾶς ὁ ἁπτόμενος τῶν θνησιμαίων αὐτῶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Καὶ πᾶς ὃς πορεύεται ἐπὶ χειρῶν ἐν πᾶσι τοῖς θηρίοις, ἃ πορεύεται ἐπὶ τέσσαρα, ἀκάθαρτά ἐστιν ὑμῖν· πᾶς ὁ ἁπτόμενος τῶν θνησιμαίων αὐτῶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Καὶ ὁ αἴρων τῶν θνησιμαίων αὐτῶν, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας· ἀκάθαρτα ταῦτά ἔστιν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Καὶ ταῦτα ὑμῖν ἀκάθαρτα ἀπὸ τῶν ἑρπετῶν τῶν ἐπὶ τῆς γῆς· ἡ γαλὴ, καὶ ὁ μῦς, καὶ ὁ κροκόδειλος ὁ χερσαῖος, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","μυγάλη, καὶ χαμαιλέων, καὶ χαλαβώτης, καὶ σαῦρα, καὶ ἀσπάλαξ. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ταῦτα ἀκάθαρτα ὑμῖν ἀπὸ πάντων τῶν ἑρπετῶν τῶν ἐπὶ τῆς γῆς· πᾶς ὁ ἁπτόμενος αὐτῶν τεθνηκότων, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Καὶ πᾶν ἐφʼ ὃ ἂν ἐπιπέσῃ ἀπʼ αὐτῶν ἐπʼ αὐτὸ τεθνηκότων αὐτῶν, ἀκάθαρτον ἔσται ἀπὸ παντὸς σκεύους ξυλίνου ἢ ἱματίου ἢ δέρματος ἢ σάκκου· πᾶν σκεῦος ὃ ἂν ποιηθῇ ἔργον ἐν αὐτῷ, εἰς ὕδωρ βαφήσεται, καὶ ἀκάθαρτον ἔσται ἕως ἑσπέρας· καὶ καθαρὸν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Καὶ πᾶν σκεῦος ὀστράκινον εἰς ὃ ἐὰν πέσῃ ἀπὸ τούτων ἔνδον, ὅσα ἐὰν ἔνδον ᾖ, ἀκάθαρτα ἔσται, καὶ αὐτὸ συντριβήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Καὶ πᾶν βρῶμα, ὃ ἔσθεται, εἰς ὃ ἂν ἐπέλθῃ ἐπʼ αὐτὸ ὕδωρ, ἀκάθαρτον ἔσται· καὶ πᾶν ποτὸν, ὃ πίνεται ἐν παντὶ ἀγγείῳ, ἀκάθαρτον ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Καὶ πᾶν ὃ ἐὰν ἐπιπέσῃ ἀπὸ τῶν θνησιμαίων αὐτῶν ἐπʼ αὐτό, ἀκάθαρτον ἔσται· κλίβανοι καὶ χυτρόποδες καθαιρεθήσονται· ἀκάθαρτα ταῦτά ἐστι, καὶ ἀκάθαρτα ταῦτα ὑμῖν ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Πλὴν πηγῶν ὑδάτων καὶ λάκκου καὶ συναγωγῆς ὕδατος, ἔσται καθαρόν· ὁ δὲ ἁπτόμενος τῶν θνησιμαίων αὐτῶν, ἀκάθαρτος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ἐὰν δὲ ἐπιπέσῃ ἀπὸ τῶν θνησιμαίων αὐτῶν ἐπὶ πᾶν σπέρμα σπόριμον, ὃ σπαρήσεται, καθαρὸν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ἐὰν δὲ ἐπιχυθῇ ὕδωρ ἐπὶ πᾶν σπέρμα, καὶ ἐπιπέσῃ τῶν θνησιμαίων αὐτῶν ἐπʼ αὐτό, ἀκάθαρτόν ἐστιν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ἐὰν δὲ ἀποθάνῃ τῶν κτηνῶν, ὅ ἐστιν ὑμῖν φαγεῖν τοῦτο, ὁ ἁπτόμενος τῶν θνησιμαίων αὐτῶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας· ");
INSERT INTO grcbrent_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","καὶ ὁ ἐσθίων ἀπὸ τῶν θνησιμαίων τούτων, πλυνεῖ τὰ ἱμάτια, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας· καὶ ὁ αἴρων ἀπὸ θνησιμαίων αὐτῶν, πλυνεῖ τὰ ἱμάτια, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Καὶ πᾶν ἑρπετὸν, ὃ ἕρπει ἐπὶ τῆς γῆς, βδέλυγμα ἔσται τοῦτο ὑμῖν· οὐ βρωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Καὶ πᾶς ὁ πορευόμενος ἐπὶ κοιλίας, καὶ πᾶς ὁ πορευόμενος ἐπὶ τέσσαρα διαπαντός, ὃ πολυπληθεῖ ποσὶν ἐν πᾶσι τοῖς ἑρπετοῖς τοῖς ἕρπουσιν ἐπὶ τῆς γῆς, οὐ φάγεσθε αὐτὸ, ὅτι βδέλυγμα ὑμῖν ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Καὶ οὐ μὴ βδελύξητε τὰς ψυχὰς ὑμῶν ἐν πᾶσι τοῖς ἑρπετοῖς τοῖς ἕρπουσιν ἐπὶ τῆς γῆς, καὶ οὐ μιανθήσεσθε ἐν τούτοις, καὶ οὐκ ἀκάθαρτοι ἔσεσθε ἐν αὐτοῖς, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ὅτι ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν· καὶ ἁγιασθήσεσθε, καὶ ἅγιοι ἔσεσθε, ὅτι ἅγιός εἰμι ἐγὼ Κύριος ὁ Θεὸς ὑμῶν· καὶ οὐ μιανεῖτε τὰς ψυχὰς ὑμῶν ἐν πᾶσι τοῖς ἑρπετοῖς τοῖς κινουμένοις ἐπὶ τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ὅτι ἐγώ εἰμι Κύριος ὁ ἀναγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου εἶναι ὑμῶν Θεός· καὶ ἔσεσθε ἅγιοι, ὅτι ἅγιός εἰμι ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Οὗτος ὁ νόμος περὶ τῶν κτηνῶν καὶ τῶν πετεινῶν καὶ πάσης ψυχῆς τῆς κινουμένης ἐν τῷ ὕδατι, καὶ πάσης ψυχῆς ἑρπούσης ἐπὶ τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","διαστεῖλαι ἀναμέσον τῶν ἀκαθάρτων καὶ ἀναμέσον τῶν καθαρῶν, καὶ ἀναμέσον τῶν ζωογονούντων τὰ ἐσθιόμενα καὶ ἀναμέσον τῶν ζωογονούντων τὰ μὴ ἐσθιόμενα. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, γυνὴ ἥτις ἐὰν σπερματισθῇ, καὶ τέκῃ ἄρσεν, καὶ ἀκάθαρτος ἔσται ἑπτὰ ἡμέρας· κατὰ τὰς ἡμέρας τοῦ χωρισμοῦ τῆς ἀφέδρου αὐτῆς, ἀκάθαρτος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ περιτεμεῖ τὴν σάρκα τῆς ἀκροβυστίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Καὶ τριάκοντα καὶ τρεῖς ἡμέρας καθήσεται ἐν αἵματι ἀκαθάρτῳ αὐτῆς· παντὸς ἁγίου οὐξ ἅψεται, καὶ εἰς τὸ ἁγιαστήριον οὐκ εἰσελεύσεται, ἕως ἂν πληρωθῶσιν αἱ ἡμέραι καθάρσεως αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ἐὰν δὲ θῆλυ τέκῃ, καὶ ἀκάθαρτος ἔσται δὶς ἑπτὰ ἡμέρας, κατὰ τὴν ἄφεδρον αὐτῆς· καὶ ἑξήκοντα ἡμέρας καὶ ἓξ καθεσθήσεται ἐν αἵματι ἀκαθάρτῳ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Καὶ ὅταν ἀναπληρωθῶσιν αἱ ἡμέραι καθάρσεως αὐτῆς ἐφʼ υἱῷ ἢ ἐπὶ θυγατρι, προσοίσει ἀμνὸν ἐνιαύσιον ἄμωμον εἰς ὁλοκαύτωμα, καὶ νοσσὸν περιστερᾶς ἢ τρυγόνα περὶ ἁμαρτίας ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου, πρὸς τὸν ἱερέα. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Καὶ προσοίσει αὐτὸν ἔναντι Κυρίου· καὶ ἐξιλάσεται περὶ αὐτῆς ὁ ἱερεὺς, καὶ καθαριεῖ αὐτὴν ἀπὸ τῆς πηγῆς τοῦ αἵματος αὐτῆς· οὗτος ὁ νόμος τῆς τικτούσης ἄρσεν ἢ θῆλυ. ");
INSERT INTO grcbrent_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ἐὰν δὲ μὴ εὑρίσκῃ ἡ χεὶρ αὐτῆς τὸ ἱκανὸν εἰς ἀμνὸν, καὶ λήψεται δύο τρυγόνας ἢ δύο νοσσοὺς περιστερῶν, μίαν εἰς ὁλοκαύτωμα, καὶ μίαν περὶ ἁμαρτίας· καὶ ἐξιλάσεται περὶ αὐτῆς ὁ ἱερεὺς, καὶ καθαρισθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","ἀνθρώπῳ ἐάν τινι γένηται ἐν δέρματι χρωτὸς αὐτοῦ οὐλὴ σημασίας τηλαυγὴς, καὶ γένηται ἐν δέρματι χρωτὸς αὐτοῦ ἁφὴ λέπρας, ἀχθήσεται πρὸς Ἀαρὼν τὸν ἱερέα, ἢ ἕνα τῶν υἱῶν αὐτοῦ τῶν ἱερέων. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφὴν ἐν δέρματι τοῦ χρωτὸς αὐτοῦ, καὶ ἡ θρὶξ ἐν τῇ ἁφῇ μεταβάλῃ λευκὴ, καὶ ἡ ὄψις τῆς ἁφῆς ταπεινὴ ἀπὸ τοῦ δέρματος τοῦ χρωτὸς, ἁφὴ λέπρας ἐστί· καὶ ὄψεται ὁ ἱερεὺς, καὶ μιανεῖ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ἐὰν δὲ καὶ τηλαυγὴς λευκὴ ἦ ἐν τῷ δέρματι τοῦ χρωτὸς αὐτοῦ, καὶ ταπεινὴ μὴ ἦ ἡ ὄψις αὐτῆς ἀπὸ τοῦ δέρματος, καὶ ἡ θρὶξ αὐτοῦ οὐ μετέβαλε τρίχα λευκὴν, αὐτὴ δέ ἐστιν ἀμαυρὰ, καὶ ἀφοριεῖ ὁ ἱερεὺς τὴν ἁφὴν ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφὴν τῇ ἡμέρᾳ τῇ ἑβδόμῃ· καὶ ἰδοὺ ἡ ἁφὴ μένει ἐναντίον αὐτοῦ, οὐ μετέπεσεν ἡ ἁφὴ ἐν τῷ δέρματι, καὶ ἀφοριεῖ αὐτὸν ὁ ἱερεὺς ἑπτὰ ἡμέρας τοδεύτερον. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Καὶ ὄψεται ὁ ἱερεὺς αὐτὸν τῇ ἡμέρᾳ τῇ ἑβδόμῃ τοδεύτερον· καὶ ἰδοὺ ἀμαυρὰ ἡ ἁφή, οὐ μετέπεσεν ἡ ἁφὴ ἐν τῷ δέρματι· καὶ καθαριεῖ αὐτὸν ὁ ἱερεύς, σημασία γάρ ἐστι· καὶ πλυνάμενος τὰ ἱμάτια αὐτοῦ, καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ἐὰν δὲ μεταβαλοῦσα μεταπέσῃ ἡ σημασία ἐν τῷ δέρματι, μετὰ τὸ ἰδεῖν αὐτὸν τὸν ἱερέα τοῦ καθαρίσαι αὐτόν, καὶ ὀφθήσεται τοδεύτερον τῷ ἱερεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Καὶ ὄψεται αὐτὸν ὁ ἱερεύς, καὶ ἰδοὺ μετέπεσεν ἡ σημασία ἐν τῷ δέρματι, καὶ μιανεῖ αὐτὸν ὁ ἱερεύς· λέπρα ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Καὶ ἁφὴ λέπρας ἐὰν γένηται ἐν ἀνθρώπῳ, και ἥξει πρὸς τὸν ἱερέα· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ οὐλὴ λευκὴ ἐν τῷ δέρματι, καὶ αὕτη μετέβαλε τρίχα λευκὴν, καὶ ἀπὸ τοῦ ὑγιοῦς τῆς σαρκὸς τῆς ζώσης ἐν τῇ οὐλῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Λέπρα παλαιουμένη ἐστὶν ἐν τῷ δέρματι τοῦ χρωτός, καὶ μιανεῖ αὐτὸν ὁ ἱερεὺς, καὶ ἀφοριεῖ αὐτὸν, ὅτι ἀκάθαρτός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ἐὰν δὲ ἀνθοῦσα ἐξανθήσῃ λέπρα ἐν τῷ δέρματι, καὶ καλύψῃ ἡ λέπρα πᾶν τὸ δέρμα τῆς ἁφῆς ἀπὸ κεφαλῆς ἕως ποδῶν, καθʼ ὅλην τὴν ὅρασιν τοῦ ἱερέως· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ ἐκάλυψεν ἡ λέπρα πᾶν τὸ δέρμα τοῦ χρωτός· καὶ καθαριεῖ αὐτὸν ὁ ἱερεὺς τὴν ἁφήν, ὅτι πᾶν μετέβαλε λευκὸν, καθαρόν ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Καὶ ᾗ ἂν ἡμέρᾳ ὀφθῇ ἐν αὐτῷ χρὼς ζῶν, μιανθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Καὶ ὅψεται ὁ ἱερεὺς τὸν χρῶτα τὸν ὑγιῆ, καὶ μιανεῖ αὐτὸν ὁ χρὼς ὁ ὑγιὴς, ὅτι ἀκάθαρτός ἐστι· λέπρα ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ἐὰν δὲ ἀποκαταστῇ ὁ χρὼς ὁ ὑγιὴς, καὶ μεταβάλῃ λευκὴ, καὶ ἐλεύσεται πρὸς τὸν ἱερέα· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ μετέβαλεν ἡ ἁφὴ εἰς τὸ λευκόν, καὶ καθαριεῖ ὁ ἱερεὺς τὴν ἁφήν· καθαρός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Καὶ σὰρξ ἐὰν γένηται ἐν τῷ δέρματι αὐτοῦ ἕλκος, καὶ ὑγιασθῇ, ");
INSERT INTO grcbrent_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","καὶ γένηται ἐν τῷ τόπῳ τοῦ ἕλκους οὐλὴ λευκὴ, ἢ τηλαυγὴς λευκαίνουσα, ἢ πυῤῥίζουσα, καὶ ὀφθήσεται τῷ ἱερεῖ· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ ἡ ὄψις ταπεινοτέρα τοῦ δέρματος, καὶ ἡ θρὶξ αὐτῆς μετέβαλεν εἰς λευκὴν, καὶ μιανεῖ αὐτὸν ὁ ἱερεὺς, ὅτι λέπρα ἐστίν· ἐν τῷ ἕλκει ἐξήνθησεν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ἐὰν δὲ ἴδῃ ὁ ἱερεὺς, καὶ ἰδοὺ οὐκ ἔστιν ἐν αὐτῷ θρὶξ λευκὴ, καὶ ταπεινὸν μὴ ᾖ ἀπὸ τοῦ δέρματος τοῦ χρωτὸς, καὶ αὐτὴ ᾖ ἀμαυρά, καὶ ἀφοριεῖ αὐτὸν ὁ ἱερεὺς ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ἐὰν δὲ διαχύσει διαχέηται ἐν τῷ δέρματι, καὶ μιανεῖ αὐτὸν ὁ ἱερεὺς, ἁφὴ λέπρας ἐστίν· ἐν τῷ ἕλκει ἐξήνθησεν· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ἐὰν δὲ κατὰ χώραν μείνῃ τὸ τηλαύγημα καὶ μὴ διαχέηται, οὐλὴ τοῦ ἕλκους ἐστὶ, καὶ καθαριεῖ αὐτὸν ὁ ἱερεύς. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Καὶ σὰρξ ἐὰν γένηται ἐν τῷ δέρματι αὐτοῦ κατάκαυμα πυρὸς, καὶ γένηται ἐν τῷ δέρματι αὐτοῦ τὸ ὑγιασθὲν τοῦ κατακαύματος αὐγάζον τηλαυγὲς λευκὸν, ὑποπυῤῥίζον, ἢ ἔκλευκον· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Καὶ ὄψεται αὐτὸν ὁ ἱερεὺς, καὶ ἰδοὺ μετέβαλε θρὶξ λευκὴ εἰς τὸ αὐγάζον, καὶ ἡ ὄψις αὐτοῦ ταπεινὴ ἀπὸ τοῦ δέρματος, λέπρα ἐστίν· ἐν τῷ κατακαύματι ἐξήνθησε· καὶ μιανεῖ αὐτὸν ὁ ἱερεὺς, ἁφὴ λέπρας ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ἐὰν δὲ ἴδῃ ὁ ἱερεὺς, καὶ ἰδοὺ οὐκ ἔστιν ἐν τῷ· αὐγάζοντι θρὶξ λευκή, καὶ ταπεινὸν μὴ ᾖ ἀπὸ τοῦ δέρματος, αὐτὸ δὲ ἀμαυρὸν, καὶ ἀφοριεῖ αὐτὸν ὁ ἱερεὺς ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Καὶ ὄψεται αὐτὸν ὁ ἱερεὺς τῇ ἡμέρᾳ τῇ ἑβδόμῃ· ἐὰν δὲ διαχύσει διαχέηται ἐν τῷ δέρματι, καὶ μιανεῖ αὐτὸν ὁ ἱερεὺς, ἁφὴ λέπρας ἐστίν· ἐν τῷ ἕλκει ἐξήνθησεν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ἐὰν δὲ κατὰ χώραν μείνῃ τὸ αὐγάζον, καὶ μὴ διαχυθῇ ἐν τῷ δέρματι, αὐτὴ δὲ ἀμαυρὰ ᾖ, οὐλὴ τοῦ κατακαύματός ἐστι, καὶ καθαριεῖ αὐτὸν ὁ ἱερεύς· ὁ γὰρ χαρακτὴρ τοῦ κατακαύματός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Καὶ ἀνδρὶ ἢ γυναικὶ ἐὰν γένηται ἐν αὐτοῖς ἁφὴ λέπρας ἐν τῇ κεφαλῇ ἢ ἐν τῷ πώγωνι· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφὴν, καὶ ἰδοὺ ἡ ὄψις αὐτῆς ἐγκοιλοτέρα τοῦ δέρματος, ἐν αὐτῇ δὲ θρὶξ ξανθίζουσα λεπτὴ, καὶ μιανεῖ αὐτὸν ὁ ἱερεύς· θραῦσμά ἐστι, λέπρα τῆς κεφαλῆς ἢ λέπρα τοῦ πώγωνός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Καὶ ἐὰν ἴδῃ ὁ ἱερεὺς τὴν ἁφὴν τοῦ θραύσματος, καὶ ἰδοὺ οὐχ ἡ ὄψις ἐγκοιλοτέρα τοῦ δέρματος, καὶ θρὶξ ξανθίζουσα οὐκ ἔστιν ἐν αὐτῇ, καὶ ἀφοριεῖ ὁ ἱερεὺς τὴν ἁφὴν τοῦ θραύσματος ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφὴν τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ ἰδοὺ οὐ διεχύθη τὸ θραῦσμα, καὶ θρὶξ ξανθίζουσα οὐκ ἔστιν ἐν αὐτῇ, καὶ ἡ ὄψις τοῦ θραύσματος οὐκ ἔστι κοίλη ἀπὸ τοῦ δέρματος· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Καὶ ξυρηθήσεται τὸ δέρμα, τὸ δὲ θραῦσμα οὐ ξυρηθήσεται, καὶ ἀφοριεῖ ὁ ἱερεὺς τὸ θραῦσμα ἑπτὰ ἡμέρας τὸ δεύτερον. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Καὶ ὄψεται ὁ ἱερεὺς τὸ θραῦσμα τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ ἰδοὺ οὐ διεχύθη τὸ θραῦσμα ἐν τῷ δέρματι μετὰ τὸ ξυρηθῆναι αὐτόν, καὶ ἡ ὄψις τοῦ θραύσματος οὐκ ἔστιν κοίλη ἀπὸ τοῦ δέρματος, καὶ καθαριεῖ αὐτὸν ὁ ἱερεὺς, καὶ πλυνάμενος τὰ ἱμάτια, καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ἐὰν δὲ διαχύσει διαχέηται τὸ θραῦσμα ἐν τῷ δέρματι μετὰ τὸ καθαρισθῆναι αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ διακέχυται τὸ θραῦσμα ἐν τῷ δέρματι, οὐκ ἐπισκέψεται ὁ ἱερεὺς περὶ τῆς τριχὸς τῆς ξανθῆς, ὅτι ἀκάθαρτός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ἐὰν δὲ ἐνώπιον μείνῃ ἐπὶ χώρας τὸ θραῦσμα, καὶ θρὶξ μέλαινα ἀνατείλῃ ἐν αὐτῷ, ὑγίακε τὸ θραῦσμα, καθαρός ἐστι, καὶ καθαριεῖ αὐτὸν ὁ ἱερεύς. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Καὶ ἀνδρὶ ἢ γυναικὶ ἐὰν γένηται ἐν δέρματι τῆς σαρκὸς αὐτοῦ αὐγάματα αὐγάζοντα λευκανθίζοντα· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ ἐν δέρματι τῆς σαρκὸς αὐτοῦ αὐγάσματα αὐγάζοντα λευκαθίζοντα, ἀλφός ἐστιν· ἐξανθεῖ ἐν τῷ δέρματι τῆς σαρκὸς αὐτοῦ, καθαρός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Ἐὰν δέ τινι μαδήσῃ ἡ κεφαλὴ αὐτοῦ, φαλακρός ἐστι, καθαρός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ἐὰν δὲ κατὰ πρόσωπον μαδήσῃ ἡ κεφαλὴ αὐτοῦ, ἀναφάλαντός ἐστι, καθαρός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ἐὰν δὲ γένηται ἐν τῷ φαλακρώματι αὐτοῦ ἢ ἐν τῷ ἀναφαλαντώματι αὐτοῦ ἁφὴ λευκὴ ἢ πυῤῥίζουσα, λέπρα ἐστὶν ἐν τῷ φαλακρώματι αὐτοὺ, ἢ ἐν τῷ ἀναφαλαντώματι αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","καὶ ὄψεται αὐτὸν ὁ ἱερεύς, καὶ ἰδοὺ ἡ ὄψις τῆς ἁφῆς λευκὴ ἢ πυῤῥίζουσα ἐν τῷ φαλακρώματι αὐτοῦ ἢ ἐν τῷ ἀναφαλαντώματι αὐτοῦ, ὡς ωἶδος λέπρας ἐν δέρματι τῆς σαρκὸς αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Ἄνθρωπος λεπρός ἐστι· μιάνσει μιανεῖ αὐτὸν ὁ ἱερεὺς, ἐν τῇ κεφαλῇ αὐτοῦ ἡ ἁφὴ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Καὶ ὁ λεπρὸς ἐν ᾧ ἐστιν ἡ ἁφὴ, τὰ ἱμάτια αὐτοῦ ἔστω παραλελυμένα, καὶ ἡ κεφαλὴ αὐτοῦ ἀκάλυπτος, καὶ περὶ τὸ στόμα αὐτοῦ περιβαλέσθω, καὶ ἀκάθαρτος κεκλήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Πάσας τὰς ἡμέρας, ὅσας ἐὰν ᾖ ἐπʼ αὐτὸν ἡ ἁφὴ, ἀκάθαρτος ὢν ἀκάθαρτος ἔσται· κεχωρισμένος καθήσεται, ἔξω τῆς παρεμβολῆς αὐτοῦ ἔσται ἡ διατριβή. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Καὶ ἱματίῳ ἐὰν γένηται ἁφὴ ἐν αὐτῷ λέπρας, ἐν ἱματίῳ ἐρέῳ, ἢ ἐν ἱματίῳ στυππυίνῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ἢ ἐν στήμονι, ἢ ἐν κρόκῃ, ἢ ἐν τοῖς λινοῖς, ἢ ἐν τοῖς ἐρέοις, ἢ ἐν δέρματι, ἢ ἐν παντὶ ἐργασίμῳ δέρματι, ");
INSERT INTO grcbrent_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","καὶ γένηται ἡ ἁφὴ χλωρίζουσα ἢ πυῤῥίζουσα ἐν τῷ δέρματι, ἢ ἐν τῷ ἱματίῳ, ἢ ἐν τῷ στήμονι, ἢ ἐν τῇ κρόκῃ, ἢ ἐν παντὶ σκεύει ἐργασίμῳ δέρματος, ἁφὴ λέπρας ἐστί· καὶ δείξει τῷ ἱερεῖ· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφήν, καὶ ἀφοριεῖ ὁ ἱερεὺς τὴν ἁφὴν ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Καὶ ὄψεται ὁ ἱερεὺς τὴν ἁφὴν τῇ ἡμέρᾳ τῇ ἑβδόμῃ· ἐὰν δὲ διαχέηται ἡ ἁφὴ ἐν τῷ ἱματίῳ, ἢ ἐν τῷ στήμονι, ἢ ἐν τῇ κρόκῃ, ἢ ἐν τῷ δέρματι, κατὰ πάντα ὅσα ἐὰν ποιηθῇ δέρματα ἐν τῇ ἐργασίᾳ, λέπρα ἔμμονός ἐστιν ἡ ἁφὴ, ἀκάθαρτός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Κατακαύσει τὸ ἱμάτιον, ἢ τὸν στήμονα, ἢ τὴν κρόκην ἐν τοῖς ἐρέοις, ἢ ἐν τοῖς λινοῖς, ἢ ἐν παντὶ σκεύει δερματίνῳ, ἐν ᾧ ἂν ᾖ ἐν αὐτῷ ἡ ἁφὴ, ὅτι λέπρα ἔμμονός ἐστιν, ἐν πυρὶ κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ἐὰν δὲ ἴδῃ ὁ ἱερεὺς, καὶ μὴ διαχέηται ἡ ἁφὴ ἐν τῷ ἱματίῳ, ἢ ἐν τῷ στήμονι, ἢ ἐν τῇ κρόκῃ, ἢ ἐν παντὶ σκεύει δερματίνῳ· ");
INSERT INTO grcbrent_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Καὶ συντάξει ὁ ἱερεύς, καὶ πλυνεῖ ἐφʼ οὗ ἐὰν ᾖ ἐπʼ αὐτοῦ ἡ ἁφὴ, καὶ ἀφοριεῖ ὁ ἱερεὺς τὴν ἁφὴν ἑπτὰ ἡμέρας τοδέυτερον. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Καὶ ὄψεται ὁ ἱερεὺς μετὰ τὸ πλυθῆναι αὐτὸ τὴν ἁφὴν, καὶ ἥδε οὐ μὴ μετέβαλεν ἡ ἁφὴ τὴν ὄψιν, καὶ ἡ ἁφὴ οὐ διαχεῖται, ἀκάθαρτόν ἐστιν, ἐν πυρὶ κατακαυθήσεται· ἐστήρικται ἐν τῷ ἱματίῳ, ἢ ἐν τῷ στήμονι, ἢ ἐν τῇ κρόκη. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Καὶ ἐὰν ἴδῃ ὁ ἱερεὺς, καὶ ᾖ ἀμαυρὰ ἡ ἁφὴ μετὰ τὸ πλυθήναι αὐτὸ, ἀποῤῥήξει αὐτὸ ἀπὸ τοῦ ἱματίου, ἢ ἀπὸ τοῦ στήμονος, ἢ ἀπὸ τῆς κρόκης, ἢ ἀπὸ τοῦ δέρματος. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ἐὰν δὲ ὀφθῇ ἔτι ἐν τῷ ἱματίῳ, ἢ ἐν τῷ στήμονι, ἢ ἐν τῇ κρόκῃ, ἢ ἐν παντὶ σκεύει δερματίνῳ, λέπρα ἐξανθοῦσά ἐστιν ἐν πυρὶ κατακαυθήσεται ἐν ᾧ ἐστιν ἡ ἁφή. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Καὶ τὸ ἱμάτιον, ἢ ὁ στήμων, ἢ ἡ κρόκη, ἢ πᾶν σκεῦος δερμάτινον, ὃ πλυθήσεται, καὶ ἀποστήσεται ἀπʼ αὐτοῦ ἡ ἁφὴ, καὶ πλυθήσεται τὸ δέυτερον, καὶ καθαρὸν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Οὗτος ὁ νόμος ἁφῆς λέπρας ἱματίου ἐρέου, ἢ στυππυίνου, ἢ στήμονος, ἢ κρόκης, ἢ παντὸς σκεύους δερματίνου, εἰς τὸ καθαρίσαι αὐτὸ, ἢ μιᾶναι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","οὗτος ὁ νὁμος τοῦ λεπροῦ· ᾗ ἂν ἡμέρᾳ καθαρισθῇ, καὶ προσαχθήσεται πρὸς τὸν ἱερέα. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Καὶ ἐξελεύσεται ὁ ἱερεὺς ἔξω τῆς παρεμβολῆς, καὶ ὄψεται ὁ ἱερεὺς, καὶ ἰδοὺ ἰᾶται ἡ ἁφὴ τῆς λέπρας ἀπὸ τοῦ λεπροῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Καὶ προστάξει ὁ ἱερεὺς, καὶ λήψονται τῷ κεκαθαρισμένῳ δύο ὀρνίθια ζῶντα καθαρὰ, καὶ ξύλον κέδρινον, καὶ κεκλωσμένον κόκκινον, καὶ ὕσσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Καὶ προστάξει ὁ ἱερεὺς, καὶ σφάξουσι τὸ ὀρνίθιον τὸ ἓν εἰς ἀγγεῖον ὀστράκινον ἐφʼ ὕδατι ζῶντι. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Καὶ τὸ ὀρνίθιον τὸ ζῶν λήμψεται αὐτὸ, καὶ τὸ ξύλον τὸ κέδρινον, καὶ τὸ κλωστὸν κόκκινον, καὶ τὸν ὕσσωπον, καὶ βάψει αὐτὰ καὶ τὸ ὀρνίθιον τὸ ζῶν εἰς τὸ αἷμα τοῦ ὀρνιθίου τοῦ σφαγέντος ἐφʼ ὕδατι ζῶντι. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Καὶ περιῤῥανεῖ ἐπὶ τὸν καθαρισθέντα ἀπὸ τῆς λέπρας ἑπτάκις, καὶ καθαρὸς ἔσται· καὶ ἐξαποστελεῖ τὸ ὀρνίθιον τὸ ζῶν εἰς τὸ πεδίον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Καὶ πλυνεῖ ὁ καθαρισθεὶς τὰ ἱμάτια αὐτοῦ, καὶ ξυρηθήσεται αὐτοῦ πᾶσαν τὴν τρίχα, καὶ λούσεται ἐν ὕδατι, καὶ καθαρὸς ἔσται· καὶ μετὰ ταῦτα εἰσελεύσεται εἰς τὴν παρεμβολὴν, καὶ διατρίψει ἔξω τοῦ οἴκου αὐτοῦ ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Καὶ ἔσται τῇ ἡμέρᾳ τῇ ἑβδόμῃ, ξυρηθήσεται πᾶσαν τὴν τρίχα αὐτοῦ, τὴν κεφαλὴν αὐτοῦ, καὶ τὸν πώγωνα, καὶ τὰς ὀφρῦς, καὶ πᾶσαν τὴς τρίχα αὐτοῦ ξυρηθήσεται· καὶ πλυνεῖ τὰ ἱμάτια, καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι, καὶ καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ λήψεται δύο ἀμνοὺς ἀμώμους ἑνιαυσίους, καὶ πρόβατον ἄμωμον ἑνιαύσιον, καὶ τρία δέκατα σεμιδάλεως εἰς θυσίαν πεφυραμένης ἐν ἐλαίῳ, καὶ κοτύλην ἐλαίου μίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Καὶ στήσει ὁ ἱερεὺς ὁ καθαρίζων, τὸν ἄνθρωπον τὸν καθαριζόμενον, καὶ ταῦτα ἔναντι Κυρίου, ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Καὶ λήψεται ὁ ἱερεὺς τὸν ἀμνὸν τὸν ἕνα, καὶ προσάξει αὐτὸν τῆς πλημμελείας, καὶ τὴν κοτύλην τοῦ ἐλαίου, καὶ ἀφοριεῖ αὐτὰ ἀφόρισμα ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Καὶ σφάξουσι τὸν ἀμνὸν ἐν τόπῳ, οὗ σφάζουσι τὰ ὁλοκαυτώματα, καὶ τὰ περὶ ἁμαρτίας, ἐν τόπῳ ἁγίῳ· ἔστι γὰρ τὸ περὶ ἁμαρτίας, ὥσπερ τὸ τῆς πλημμελείας ἐστὶ τῷ ἱερει· ἅγια ἁγίων ἐστί. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Καὶ λήψεται ὁ ἱερεὺς ἀπὸ τοῦ αἵματος τοῦ τῆς πλημμελείας, καὶ ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὸν λοβὸν τοῦ ὠτὸς τοῦ καθαριζομένου τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς χειρὸς τῆς δεξιᾶς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς τοῦ δεξιοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Καὶ λαβὼν ὁ ἱερεὺς ἀπὸ τῆς κοτύλης τοῦ ἐλαίου, ἐπιχεεῖ ἐπὶ τὴν χεῖρα τοῦ ἱερέως τὴν ἀριστεράν. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Καὶ βάψει τὸν δάκτυλον τὸν δεξιὸν ἀπὸ τοὺ ἐλαίου τοῦ ὄντος ἐπὶ τῆς χειρὸς αὐτοῦ τῆς ἀριστερᾶς· καὶ ῥανεῖ τῷ δακτύλῳ ἑπτάκις ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Τὸ δὲ καταλειφθὲν ἔλαιον τὸ ὂν ἐν τῇ χειρὶ, ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὸν λοβὸν τοῦ ὠτὸς τοῦ καθαριζομένου τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς χειρὸς τῆς δεξιᾶς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς τοῦ δεξιοῦ, ἐπὶ τὸν τόπον τοῦ αἵματος τοῦ τῆς πλημμελείας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Τὸ δὲ καταλειφθὲν ἔλαιον τὸ ἐπὶ τῆς χειρὸς τοῦ ἱερέως, ἐπιθήσει ὁ ἱερεὺς ἐπὶ τὴν κεφαλὴν τοῦ καθαρισθέντος· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Καὶ ποιήσει ὁ ἱερεὺς τὸ περὶ τῆς ἁμαρτίας, καὶ ἐξιλάσεται ὁ ἱερεὺς περὶ τοῦ καθαριζομένου ἀπὸ τῆς ἁμαρτίας αὐτοῦ· καὶ μετὰ τοῦτο σφάξει ὁ ἱερεὺς τὸ ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Καὶ ἀνοίσει ὁ ἱερεὺς τὸ ὁλοκαύτωμα, καὶ τὴν θυσίαν ἐπὶ τὸ θυσιαστήριον ἔναντι κυρίου· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς, καὶ καθαρισθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ἐὰν δὲ πένηται, καὶ ἡ χεὶρ αὐτοῦ μὴ εὑρίσκῃ, λήψεται ἀμνὸν ἕνα εἰς ὃ ἐπλημμέλησεν εἰς ἀφαίρεμα, ὥστε ἐξιλάσασθαι περὶ αὐτοῦ, καὶ δέκατον σεμιδάλεως πεφυραμένης ἐν ἐλαίῳ εἰς θυσίαν, καὶ κοτύλην ἐλαίου μίαν, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","καὶ δύο τρυγόνας, ἢ δύο νοσσοὺς περιστερῶν, ὅσα εὗρεν ἡ χεὶρ αὐτοῦ, καὶ ἔσται ἡ μία περὶ ἁμαρτίας, καὶ ἡ μία εἰς ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Καὶ προσοίσει αὐτὰ τῇ ἡμέρᾳ τῇ ὀγδόῃ, εἰς τὸ καθαρίσαι αὐτὸν, πρὸς τὸν ἱερέα, ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Καὶ λαβὼν ὁ ἱερεὺς τὸν ἀμνὸν τῆς πλημμελείας, καὶ τὴν κοτύλην τοῦ ἐλαίου, ἐπιθήσει αὐτὰ ἐπίθεμα ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Καὶ σφάξει τὸν ἀμνὸν τὸν τῆς πλημμελείας, καὶ λήψεται ὁ ἱερεὺς ἀπὸ τοῦ αἵματος τοῦ τῆς πλημμελείας, καὶ ἐπιθήσει ἐπὶ τὸν λοβὸν τοῦ ὠτὸς τοῦ καθαριζομένου τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς χειρὸς τῆς δεξιᾶς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς τοῦ δεξιοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Καὶ ἀπὸ τοῦ ἐλαίου ἐπιχεεῖ ὁ ἱερεὺς ἐπὶ τὴν χεῖρα τοῦ ἱερέως τὴν ἀριστεράν. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Καὶ ῥανεῖ ὁ ἱερεὺς τῷ δακτύλῳ τῷ δεξιῷ ἀπὸ τοῦ ἐλαίου τοῦ ἐν τῇ χειρὶ αὐτοῦ τῇ ἀριστερᾷ ἑπτάκις ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Καὶ ἐπιθήσει ὁ ἱερεὺς ἀπὸ τοῦ ἐλαίου τοῦ ἐπὶ τῆς χειρὸς αὐτοῦ ἐπὶ τὸν λοβὸν τοῦ ὠτὸς τοῦ καθαριζομένου τοῦ δεξιοῦ, καὶ ἐπὶ τὸ ἄκρον τῆς χειρὸς αὐτοῦ τῆς δεξιᾶς, καὶ ἐπὶ τὸ ἄκρον τοῦ ποδὸς αὐτοῦ τοῦ δεξιοῦ, ἐπὶ τὸν τόπον τοῦ αἵματος τοῦ τῆς πλημμελείας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Τὸ δὲ καταλειφθὲν ἀπὸ τοῦ ἐλαίου τὸ ὂν ἐπὶ τῆς χειρὸς τοῦ ἱερέως, ἐπιθήσει ἐπὶ τὴν κεφαλὴν τοῦ καθαρισθέντος· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Καὶ ποιήσει μίαν ἀπὸ τῶν τρυγόνων ἢ ἀπὸ τῶν νοσσῶν τῶν περιστερῶν, καθότι εὗρεν αὐτοῦ ἡ χεὶρ, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","τὴν μίαν περὶ ἁμαρτίας, καὶ τὴν μίαν εἰς ὁλοκαύτωμα σὺν τῇ θυσίᾳ· καὶ ἐξιλάσεται ὁ ἱερεὺς περὶ τοῦ καθαριζομένου ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Οὗτος ὁ νόμος ἐν ᾧ ἐστιν ἡ ἁφὴ τῆς λέπρας, καὶ τοῦ μὴ εὑρίσκοντος τῇ χειρὶ εἰς τὸν καθαρισμὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ὡς ἂν εἰσέλθητε εἰς τὴν γῆν τῶν Χαναναίων, ἣν ἐγὼ δίδωμι ὑμῖν ἐν κτήσει, καὶ δώσω ἁφὴν λέπρας ἐν ταῖς οἰκίαις τῆς γῆς τῆς ἐγκτήτου ὑμῖν· ");
INSERT INTO grcbrent_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","καὶ ἥξει τίνος αὐτοῦ ἡ οἰκία, καὶ ἀναγγελεῖ τῷ ἱερεῖ, λέγων, ὥσπερ ἁφὴ ἑώραταί μοι ἐν τῇ οἰκίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Καὶ προστάξει ὁ ἱερεὺς ἀποσκευάσαι τὴν οἰκίαν, πρὸ τοῦ εἰσελθόντα τὸν ἱερέα ἰδεῖν τὴν ἁφὴν, καὶ οὐ μὴ ἀκάθαρτα γένηται ὅσα ἂν ᾖ ἐν τῇ οἰκίᾳ· καὶ μετὰ ταῦτα εἰσελεύσεται ὁ ἱερεὺς καταμαθεῖν τὴν οἰκίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Καὶ ὄψεται τὴν ἁφὴν, καὶ ἰδοὺ ἡ ἁφὴ ἐν τοῖς τοίχοις τῆς οἰκίας, κοιλάδας χλωριζούσας, ἢ πυῤῥιζούσας, καὶ ἡ ὄψις αὐτῶν ταπεινοτέρα τῶν τοίχων. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Καὶ ἐξελθὼν ὁ ἱερεὺς ἐκ τῆς οἰκίας ἐπὶ τὴν θύραν τῆς οἰκίας, καὶ ἀφοριεῖ ὁ ἱερεὺς τὴν οἰκίαν ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Καὶ ἐπανήξει ὁ ἱερεὺς τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ ὄψεται τὴν οἰκίαν, καὶ ἰδοὺ διεχύθη ἡ ἁφὴ ἐν τοῖς τοίχοις τῆς οἰκίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Καὶ προστάξει ὁ ἱερεὺς, καὶ ἐξελοῦσι τοὺς λίθους ἐν οἷς ἐστιν ἡ ἁφὴ, καὶ ἐκβαλοῦσιν αὐτοὺς ἔξω τῆς πόλεως εἰς τόπον ἀκάθαρτον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Καὶ τὴν οἰκίαν ἀποξύσουσιν ἔσωθεν κύκλῳ, καὶ ἐκχεοῦσι τὸν χοῦν τὸν ἀπεξυσμένον ἔξω τῆς πόλεως εἰς τόπον ἀκάθαρτον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Καὶ λήψονται λίθους ἀπεξυσμένους ἑτέρους, καὶ ἀντιθήσουσιν ἀντὶ τῶν λίθων· καὶ χοῦν ἕτερον λήψονται, καὶ ἐξαλείψουσι τὴν οἰκίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ἐὰν δὲ ἐπέλθῃ πάλιν ἡ ἁφὴ, καὶ ἀνατείλῃ ἐν τῇ οἰκίᾳ μετὰ τὸ ἐξελεῖν τοὺς λίθους, καὶ μετὰ τὸ ἀποξυσθῆναι τὴν οἰκίαν, καὶ μετὰ τὸ ἐξαλειφθῆναι, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","καὶ εἰσελεύσεται ὁ ἱερεὺς, καὶ ὄψεται εἰ διακέχυται ἡ ἁφὴ ἐν τῇ οἰκίᾳ, λέπρα ἔμμονός ἐστιν ἐν τῇ οἰκίᾳ, ἀκάθαρτός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Καὶ καθελοῦσι τὴν οἰκίαν, καὶ τὰ ξύλα αὐτῆς, καὶ τοὺς λίθους αὐτῆς, καὶ πάντα τὸν χοῦν ἐξοίσουσιν ἔξω τῆς πόλεως εἰς τόπον ἀκάθαρτον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Καὶ ὁ εἰσπορευόμενος εἰς τὴν οἰκίαν πάσας τὰς ἡμέρας, ἃς ἀφωρισμένη ἐστὶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας· ");
INSERT INTO grcbrent_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Καὶ ὁ κοιμώμενος ἐν τῇ οἰκίᾳ, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας· καὶ ὁ ἔσθων ἐν τῇ οἰκίᾳ, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ἐὰν δὲ παραγενόμενος εἰσέλθῃ ὁ ἱερεὺς καὶ ἴδῃ, καὶ ἰδοὺ οὐ διαχύσει οὐ διαχεῖται ἡ ἁφὴ ἐν τῇ οἰκίᾳ μετὰ τὸ ἐξαλειφθῆναι τὴν οἰκίαν, καὶ καθαριεῖ ὁ ἱερεὺς τὴν οἰκίαν, ὅτι ἰάθη ἡ ἁφή. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Καὶ λήψεται ἀφαγνίσαι τὴν οἰκίαν, δύο ὀρνίθια ζῶντα καθαρὰ, καὶ ξύλον κέδρινον, καὶ κεκλωσμένον κόκκινον, καὶ ὕσσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Καὶ σφάξει τὸ ὀρνίθιον τὸ ἓν εἰς σκεῦος ὀστράκινον ἐφʼ ὕδατι ζῶντι· ");
INSERT INTO grcbrent_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Καὶ λήψεται τὸ ξύλον τὸ κέδρινον, καὶ τὸ κεκλωσμένον κόκκινον, καὶ τὸν ὕσσωπον, καὶ τὸ ὀρνίθιον τὸ ζῶν· καὶ βάψει αὐτὸ εἰς τὸ αἷμα τοῦ ὀρνιθίου τοῦ ἐσφαγμενου ἐφʼ ὕδατι ζῶντι· καὶ περιῤῥανεῖ ἐν αὐτοῖς ἐπὶ τὴν οἰκίαν ἑπτάκις. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Καὶ ἀφαγνιεῖ τὴν οἰκίαν ἐν τῷ αἵματι τοῦ ὀρνιθίου, καὶ ἐν τῷ ὕδατι τῷ ζῶντι, καὶ ἐν τῷ ὀρνιθίῳ τῷ ζῶντι, καὶ ἐν τῷ ξύλῳ τῷ κεδρίνῳ, καὶ ἐν τῷ ὑσσώπῳ, καὶ ἐν τῷ κεκλωσμένῳ κοκκίνῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Καὶ ἐξαποστελεῖ τὸ ὀρνίθιον τὸ ζῶν ἔξω τῆς πόλεως εἰς τὸ πεδίον, καὶ ἐξιλάσεται περὶ τῆς οἰκίας, καὶ καθαρὰ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Οὗτος ὁ νόμος κατὰ πᾶσαν ἁφὴν λέπρας, καὶ θραύσματος, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","καὶ τῆς λέπρας ἱματίου, καὶ οἰκίας, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","καὶ οὐλῆς, καὶ σημασίας, καὶ τοῦ αὐγάζοντος, ");
INSERT INTO grcbrent_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","καὶ τοῦ ἐξηγήσασθαι ᾗ ἡμέρᾳ ἀκάθαρτον, καὶ ᾗ ἡμέρᾳ καθαρισθήσεται· οὗτος ὁ νόμος τῆς λέπρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς αὐτοῖς, ἀνδρὶ ἀνδρὶ ᾧ ἐὰν γένηται ῥύσις ἐκ τοῦ σώματος αὐτοῦ, ἡ ῥύσις αὐτοῦ ἀκάθαρτός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Καὶ οὗτος ὁ νόμος τῆς ἀκαθαρσίας αὐτοῦ· ῥέων γόνον ἐκ σώματος αὐτοῦ, ἐκ τῆς ῥύσεως, ἧς συνέστηκε τὸ σῶμα αὐτοῦ διὰ τῆς ῥύσεως, αὕτη ἡ ἀκαθαρσία αὐτοῦ ἐν αὐτῷ· πᾶσαι αἱ ἡμέραι ῥύσεως σώματος αὐτοῦ, ᾗ συνέστηκε τὸ σῶμα αὐτοῦ διὰ τῆς ῥύσεως, ἀκαθαρσία αὐτοῦ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Πᾶσα κοίτη ἐφʼ ἧς ἂν κοιμηθῇ ἐπʼ αὐτῆς ὁ γονοῤῥυὴς, ἀκάθαρτός ἐστι, καὶ πᾶν σκεῦος ἐφʼ ὃ ἂν καθίσῃ ἐπʼ αὐτὸ ὁ γονοῤῤυὴς, ἀκάθαρτον ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Καὶ ἄνθρωπος, ὃς ἐὰν ἅψηται τῆς κοίτης αὐτοῦ, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Καὶ ὁ καθήμενος ἐπὶ τοῦ σκεύους ἐφʼ ὃ ἂν καθίσῃ ὁ γονοῤῥυὴς, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Καὶ ὁ ἁπτόμενος τοῦ χρωτὸς τοῦ γονοῤῥυοῦς, πλυνεῖ τὰ ἱμάτια, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ἐὰν δὲ προσσιελίσῃ ὁ γονοῤῥυὴς ἐπὶ τὸν καθαρὸν, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Καὶ πᾶν ἐπίσαγμα ὄνου, ἐφʼ ὃ ἂν ἐπιβῇ ἐπʼ αὐτὸ ὁ γονοῤῥυὴς, ἀκάθαρτον ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Καὶ πᾶς ὁ ἁπτόμενος ὅσα ἂν ᾖ ὑποκάτω αὐτοῦ, ἀκάθαρτος ἔσται ἕως ἑσπέρας· καὶ ὁ αἴρων αὐτὰ, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Καὶ ὅσων ἐὰν ἅψηται ὁ γονοῤῥυὴς, καὶ τὰς χεῖρας οὐ νένιπται ὕδατι, πλυνεῖ τὰ ἱμάτια, καὶ λούσεται τὸ σῶμα ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Καὶ σκεῦος ὀστράκινον οὗ ἂν ἅψηται ὁ γονοῤῥυὴς, συντριβήσεται· καὶ σκεῦος ξύλινον νιφήσεται ὕδατι, καὶ καθαρὸν ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ἐὰν δὲ καθαρισθῇ ὁ γονοῤῥυὴς ἐκ τῆς ῥύσεως αὐτοῦ, καὶ ἐξαριθμηθήσεται αὐτῷ ἑπτὰ ἡμέρας εἰς τὸν καθαρισμὸν αὐτοῦ, καὶ πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται τὸ σῶμα ὕδατι, καὶ καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ λήψεται ἑαυτῷ δύο τρυγόνας, ἢ δύο νοσσοὺς περιστερῶν, καὶ οἴσει αὐτὰ ἔναντι Κυρίου ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, καὶ δώσει αὐτὰ τῷ ἱερεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Καὶ ποιήσει αὐτὰ ὁ ἱερεὺς μίαν περὶ ἁμαρτίας, καὶ μίαν εἰς ὁλοκαύτωμα· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἔναντι Κυρίου ἀπὸ τῆς ῥύσεως αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Καὶ ἄνθρωπος ᾧ ἂν ἐξέλθῃ ἐξ αὐτοῦ κοίτη σπέρματος, καὶ λούσεται ὕδατι πᾶν τὸ σῶμα αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Καὶ πᾶν ἱμάτιον, καὶ πᾶν δέρμα ἐφʼ ὃ ἂν ᾖ ἐπʼ αὐτὸ κοίτη σπέρματος, καὶ πλυθήσεται ὕδατι, καὶ ἀκάθαρτον ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Καὶ γυνὴ ἐὰν κοιμηθῇ ἀνὴρ μετʼ αὐτῆς κοίτην σπέρματος, καὶ λούσονται ὕδατι, καὶ ἀκάθαρτοι ἔσονται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Καὶ γυνὴ ἥτις ἂν ᾖ ῥέουσα αἵματι, καὶ ἔσται ἡ ῥύσις αὐτῆς ἐν τῷ σώματι αὐτῆς, ἑπτὰ ἡμέρας ἔσται ἐν τῇ ἀφέδρῳ αὐτῆς· πᾶς ὁ ἁπτόμενος αὐτῆς, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Καὶ πᾶν ἐφʼ ὃ ἂν κοιτάζηται ἐπʼ αὐτὸ ἐν τῇ ἀφέδρῳ αὐτῆς, ἀκάθαρτον ἔσται· καὶ πᾶν ἐφʼ ὃ ἂν ἐπικαθίσῃ ἐπʼ αὐτὸ, ἀκάθαρτον ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Καὶ πᾶς ὃς ἂν ἅψηται τῆς κοίτης αὐτῆς, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Καὶ πᾶς ὁ ἁπτόμενος παντὸς σκεύους οὗ ἐὰν καθίσῃ ἐπʼ αὐτὸ, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ἐὰν δὲ ἐν τῇ κοίτῃ αὐτῆς οὔσης, ἢ ἐπὶ τοῦ σκεύους οὗ ἐὰν καθίσῃ ἐπʼ αὐτῷ ἐν τῷ ἅπτεσθαι αὐτὸν αὐτῆς, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ἐὰν δὲ κοίτῃ κοιμηθῇ τις μετʼ αὐτῆς, καὶ γένηται ἡ ἀκαθαρσία αὐτῆς ἐπʼ αὐτῷ, ἀκάθαρτος ἔσται ἑπτὰ ἡμέρας· καὶ πᾶσα κοίτη ἐφʼ ᾗ ἂν κοιμηθῇ ἐπʼ αὐτῇ, ἀκάθαρτος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Καὶ γυνὴ ἐὰν ῥέῃ ῥύσει αἵματος ἡμέρας πλείους, οὐκ ἐν καιρῷ τῆς ἀφέδρου αὐτῆς, ἐὰν καὶ ῥέῃ μετὰ τὴν ἄφεδρον αὐτῆς, πᾶσαι αἱ ἡμέραι ῥύσεως ἀκαθαρσίας αὐτῆς, καθάπερ αἱ ἡμέραι τῆς ἀφέδρου αὐτῆς, ἔσται ἀκάθαρτος. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Καὶ πᾶσα κοίτη ἐφʼ ἧς ἂν κοιμηθῇ ἐπʼ αὐτῆς πάσας τὰς ἡμέρας τῆς ῥύσεως, κατὰ τὴν κοίτην τῆς ἀφέδρου, ἔσται αὐτῇ· καὶ πᾶν σκεῦος ἐφʼ ὃ ἂν καθίσῃ ἐπʼ αὐτὸ, ἀκάθαρτον ἔσται κατὰ τὴν ἀκαθαρσίαν τῆς ἀφέδρου. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Πᾶς ὁ ἁπτόμενος αὐτῆς ἀκάθαρτος ἔσται, καὶ πλυνεῖ τὰ ἱμάτια καὶ λούσεται τὸ σῶμα ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ἐὰν δὲ καθαρισθῇ ἀπὸ τῆς ῥύσεως, καὶ ἐξαριθμήσεται αὐτῇ ἑπτὰ ἡμέρας, καὶ μετὰ ταῦτα καθαρισθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ λήψεται αὑτῇ δύο τρυγόνας, ἢ δύο νοσσοὺς περιστερῶν, καὶ οἴσει αὐτὰ πρὸς τὸν ἱερέα ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Καὶ ποιήσει ὁ ἱερεὺς τὴν μίαν περὶ ἁμαρτίας, καὶ τὴν μίαν εἰς ὁλοκαύτωμα· καὶ ἐξιλάσεται περὶ αὐτῆς ὁ ἱερεὺς ἔναντι Κυρίου ἀπὸ ῥύσεως ἀκαθαρσίας αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Καὶ εὐλαβεῖς ποιήσετε τοὺς υἱοὺς Ἰσραὴλ ἀπὸ τῶν ἀκαθαρσιῶν αὐτῶν· καὶ οὐκ ἀποθανοῦνται διὰ τὴν ἀκαθαρσίαν αὐτῶν, ἐν τῷ μιαίνειν αὐτοὺς τὴν σκηνήν μου τὴν ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Οὗτος ὁ νόμος τοῦ γονοῤῥυοῦς· καὶ ἐάν τινι ἐξέλθῃ ἐξ αὐτοῦ κοίτη σπέρματος, ὥστε μιανθῆναι ἐν αὐτῇ, ");
INSERT INTO grcbrent_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","καὶ τῇ αἱμοῤῥοούσῃ ἐν τῇ ἀφέδρῳ αὐτῆς, καὶ ὁ γονοῤῥυὴς ἐν τῇ ῥύσει αὐτοῦ τῷ ἄρσενι ἢ τῇ θηλείᾳ, καὶ τῷ ἀνδρὶ, ὃς ἂν κοιμηθῇ μετὰ ἀποκαθημένης. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, μετὰ τὸ τελευτῆσαι τοὺς δύο υἱοὺς Ἀαρὼν ἐν τῷ προσάγειν αὐτοὺς πῦρ ἀλλότριον ἔναντι Κυρίου, καὶ ἐτελεύτησαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λάλησον πρὸς Ἀαρὼν τὸν ἀδελφόν σου, καὶ μὴ εἰσπορευέσθω πᾶσαν ὥραν εἰς τὸ ἅγιον ἐσώτερον τοῦ καταπετάσματος εἰς πρόσωπον τοῦ ἱλαστηρίου, ὅ ἐστιν ἐπὶ τῆς κιβωτοῦ τοῦ μαρτυρίου, καὶ οὐκ ἀποθανεῖται· ἐν γὰρ νεφέλῃ ὀφθήσομαι ἐπὶ τοῦ ἱλαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Οὕτως εἰσελεύσεται Ἀαρὼν εἰς τὸ ἅγιον· ἐν μόσχῳ ἐκ βοῶν περὶ ἁμαρτίας, καὶ κριὸν εἰς ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Καὶ χιτῶνα λινοῦν ἡγιασμένον ἐνδύσεται, καὶ περισκελὲς λινοῦν ἔσται ἐπὶ τοῦ χρωτὸς αὐτοῦ, καὶ ζώνῃ λινῇ ζώσεται, καὶ κίδαριν λινῆν περιθήσεται, ἱμάτια ἅγιά ἐστι· καὶ λούσεται ὕδατι πᾶν τὸ σῶμα αὐτοῦ καὶ ἐνδύσεται αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Καὶ παρὰ τῆς συναγωγῆς τῶν υἱῶν Ἰσραὴλ λήψεται δύο χιμάρους ἐξ αἰγῶν περὶ ἁμαρτίας, καὶ κριὸν ἕνα εἰς ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Καὶ προσάξει Ἀαρὼν τὸν μόσχον τὸν περὶ τῆς ἁμαρτίας αὐτοῦ, καὶ ἐξιλάσεται περὶ αὐτοῦ, καὶ τοῦ οἴκου αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Καὶ λήψεται τοὺς δύο χιμάρους, καὶ στήσει αὐτοὺς ἔναντι Κυρίου παρὰ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Καὶ ἐπιθήσει Ἀαρὼν ἐπὶ τοὺς δύο χιμάρους κλῆρους· κλῆρον ἕνα τῷ Κυρίῳ, καὶ κλῆρον ἕνα τῷ ἀποπομπαίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Καὶ προσάξει Ἀαρὼν τὸν χίμαρον ἐφʼ ὃν ἐπῆλθεν ἐπʼ αὐτὸν ὁ κλῆρος τῷ Κυρίῳ, καὶ προσοίσει περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Καὶ τὸν χίμαρον, ἐφʼ ὃν ἐπῆλθεν ἐπʼ αὐτὸν ὁ κλῆρος τοῦ ἀποπομπαίου, στήσει αὐτὸν ζῶντα ἔναντι Κυρίου, τοῦ ἐξιλάσασθαι ἐπʼ αὐτοῦ, ὥστε ἀποστεῖλαι αὐτὸν εἰς τὴν ἀποπομπήν, καὶ ἀφήσει αὐτὸν εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Καὶ προσάξει Ἀαρὼν τὸν μόσχον τὸν περὶ τῆς ἁμαρτίας αὑτοῦ, καὶ ἐξιλάσεται περὶ ἑαυτοῦ, καὶ τοῦ οἴκου· καὶ σφάξει τὸν μόσχον περὶ τῆς ἁμαρτίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Καὶ λήψεται τὸ πυρεῖον πλῆρες ἀνθράκων πυρὸς ἀπὸ τοῦ θυσιαστηρίου, τοῦ ἀπέναντι Κυρίου· καὶ πλήσει τὰς χεῖρας θυμιάματος συνθέσεως λεπτῆς, καὶ εἰσοίσει ἐσώτερον τοῦ καταπετάσματος. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Καὶ ἐπιθήσει τὸ θυμίαμα ἐπὶ τὸ πῦρ ἔναντι Κυρίου· καὶ καλύψει ἡ ἀτμὶς τοῦ θυμιάματος τὸ ἱλαστήριον τὸ ἐπὶ τῶν μαρτυρίων, καὶ οὐκ ἀποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Καὶ λήψεται ἀπὸ τοῦ αἵματος τοῦ μόσχου, καὶ ῥανεῖ τῷ δακτύλῳ ἐπὶ τὸ ἱλαστήριον κατὰ ἀνατολάς· κατὰ πρόσωπον τοῦ ἱλαστηρίου ῥανεῖ ἑπτάκις ἀπὸ τοῦ αἵματος τῷ δακτύλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Καὶ σφάξει τὸν χίμαρον τὸν περὶ ἁμαρτίας, τὸν περὶ τοῦ λαοῦ, ἔναντι Κυρίου· καὶ εἰσοίσει τοῦ αἵματος αὐτοῦ ἐσώτερον τοῦ καταπετάσματος, καὶ ποιήσει τὸ αἷμα αὐτοῦ, ὃν τρόπον ἐποίησε τὸ αἷμα τοῦ μόσχου· καὶ ῥανεῖ τὸ αἷμα αὐτοῦ ἐπὶ τὸ ἱλαστήριον, κατὰ πρόσωπον τοῦ ἱλαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Καὶ ἐξιλάσεται τὸ ἅγιον ἀπὸ τῶν ἀκαθαρσιῶν τῶν υἱῶν Ἰσραὴλ, καὶ ἀπὸ τῶν ἀδικημάτων αὐτῶν περὶ πασῶν τῶν ἁμαρτιῶς αὐτῶν· καὶ οὕτω ποιήσει τῇ σκηνῇ τοῦ μαρτυρίου τῇ ἐκτισμένῃ ἐν αὐτοῖς ἐν μέσῳ τῆς ἀκαθαρσίας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Καὶ πᾶς ἄνθρώπος οὐκ ἔσται ἐν τῇ σκηνῇ τοῦ μαρτυρίου, εἰσπορευομένου αὐτοῦ ἐξιλάσασθαι ἐν τῷ ἁγίῳ, ἕως ἂν ἐξέλθῃ· καὶ ἐξιλάσεται περὶ ἑαυτοῦ, καὶ τοῦ οἴκου αὐτοῦ, καὶ περὶ πάσης συναγωγῆς υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Καὶ ἐξελεύσεται ἐπὶ τὸ θυσιαστήριον τὸ ὂν ἀπέναντι Κυρίου, καὶ ἐξιλάσεται ἐπʼ αὐτοῦ· καὶ λήψεται ἀπὸ τοῦ αἵματος τοῦ μόσχου, καὶ ἀπὸ τοῦ αἵματος τοῦ χιμάρου, καὶ ἐπιθήσει ἐπὶ τὰ κέρατα τοῦ θυσιαστηρίου κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Καὶ ῥανεῖ ἐπʼ αὐτὸ ἀπὸ τοῦ αἵματος τῷ δακτύλῳ ἑπτάκις, καὶ καθαριεῖ αὐτό, καὶ ἁγιάσει αὐτὸ ἀπὸ τῶν ἀκαθαρσιῶν τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Καὶ συντελέσει ἐξιλασκόμενος τὸ ἅγιον, καὶ τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὸ θυσιαστήριον, καὶ περὶ τῶν ἱερέων καθαριεῖ· καὶ προσάξει τὸν χίμαρον τὸν ζῶντα. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Καὶ ἐπιθήσει Ἀαρὼν τὰς χεῖρας αὐτοῦ ἐπὶ τὴν κεφαλὴν τοῦ χιμάρου τοῦ ζῶντος, καὶ ἐξαγορεύσει ἐπʼ αὐτοῦ πάσας τὰς ἀνομίας τῶν υἱῶν Ἰσραὴλ, καὶ πάσας τὰς ἀδικίας αὐτῶν, καὶ πάσας τὰς ἁμαρτίας αὐτῶν· καὶ ἐπιθήσει αὐτὰς ἐπὶ τὴν κεφαλὴν τοῦ χιμάρου τοῦ ζῶντος· καὶ ἐξαποστελεῖ ἐν χειρὶ ἀνθρώπου ἑτοιμου εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Καὶ λήψεται ὁ χίμαρος ἐφʼ ἑαυτῷ τὰς ἀδικίας αὐτῶν εἰς γῆν ἄβατον· καὶ ἐξαποστελεῖ τὸν χίμαρον εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Καὶ εἰσελεύσεται Ἀαρὼν εἰς τὴν σκηνὴν τοῦ μαρτυρίου, καὶ ἐκδύσεται τὴν στολὴν τὴν λινῆν, ἣν ἐνδεδύκει, εἰσπορευομένου αὐτοῦ εἰς τὸ ἅγιον, καὶ ἀποθήσει αὐτὴν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι ἐν τόπῳ ἁγίῳ, καὶ ἐνδύσεται τὴν στολὴν αὐτοῦ, καὶ ἐξελθὼν ποιήσει τὸ ὁλοκαύτωμα αὐτοῦ καὶ τὸ ὁλοκάρπωμα τοῦ λαοῦ, καὶ ἐξιλάσεται περὶ αὐτοῦ, καὶ περὶ τοῦ οἴκου αὐτοῦ, καὶ περὶ τοῦ λαοῦ, ὡς περὶ τῶν ἱερέων. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Καὶ τὸ στέαρ τὸ περὶ τῶν ἁμαρτιῶν ἀνοίσει ἐπὶ τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Καὶ ὁ ἐξαποστέλλων τὸν χίμαρον τὸν διεσταλμένον εἰς ἄφεσιν, πλυνεῖ τὰ ἱμάτια, καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι, καὶ μετὰ ταῦτα εἰσελεύσεται εἰς τὴν παρεμβολήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Καὶ τὸν μόσχον τὸν περὶ τῆς ἁμαρτίας, καὶ τὸν χίμαρον τὸν περὶ τῆς ἁμαρτίας, ὧν τὸ αἷμα εἰσηνέχθη ἐξιλάσασθαι ἐν τῷ ἁγίῳ, ἐξοίσουσιν αὐτὰ ἔξω τῆς παρεμβολῆς, ταὶ κατακαύσουσιν αὐτὰ ἐν πυρὶ, καὶ τὰ δέρματα αὐτῶν καὶ τὰ κρέα αὐτῶν καὶ τὴν κόπρον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ὁ δὲ κατακαίων αὐτὰ, πλυνεῖ τὰ ἱμάτια, καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι, καὶ μετὰ ταῦτα εἰσελεύσεται εἰς τὴν παρεμβολήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Καὶ ἔσται τοῦτο ὑμῖν νόμιμον αἰώνιον· ἐν τῷ μηνὶ τῷ ἑβδόμῳ, δεκάτῃ τοῦ μηνὸς, ταπεινώσετε τὰς ψυχὰς ὑμῶν, καὶ πᾶν ἔργον οὐ ποιήσετε ὁ αὐτόχθων, καὶ ὁ προσήλυτος ὁ προσκείμενος ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ἐν γὰρ τῇ ἡμέρᾳ ταύτῃ ἐξιλάσεται περὶ ὑμῶν, καθαρίσαι ὑμᾶς ἀπὸ πασῶν τῶν ἁμαρτιῶν ὑμῶν ἔναντι Κυρίου, καὶ καθαρισθήσεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Σάββατα σαββάτων ἀνάπαυσις αὕτη ἔσται ὑμῖν· καὶ ταπεινώσετε τὰς ψυχὰς ὑμῶν, νόμιμον αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ἐξιλάσεται ὁ ἱερεὺς, ὃν ἂν χρίσωσιν αὐτὸν, καὶ ὃν ἂν τελειώσωσι τὰς χεῖρας αὐτοῦ ἱερατεύειν μετὰ τὸν πατέρα αὐτοῦ· καὶ ἐνδύσεται τὴν στολὴν τὴν λινῆν, στολὴν ἁγίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Καὶ ἐξιλάσεται τὸ ἅγιον τοῦ ἁγίου, καὶ τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὸ θυσιαστήριον ἐξιλάσεται, καὶ περὶ τῶν ἱερέων, καὶ περὶ πάσης συναγωγῆς ἐξιλάσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Καὶ ἔσται τοῦτο ὑμῖν νόμιμον αἰώνιον ἐξιλάσκεσθαι περὶ τῶν νἱῶν Ἰσραὴλ ἀπὸ πασῶν τῶν ἁμαρτιῶν αὐτῶν· ἅπαξ τοῦ ἐνιαυτοῦ ποιηθήσεται, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","λάλησον πρὸς Ἀαρὼν καὶ πρὸς τοὺς υἱοὺς αὐτοῦ, καὶ πρὸς πάντας υἱοὺς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, τοῦτο τὸ ῥῆμα ὃ ἐνετείλατο Κύριος, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ἄνθρωπος ἄνθρωπος τῶν υἱῶν Ἰσραὴλ, ἢ τῶν προσηλύτων τῶν προσκειμένων ἐν ὑμῖν, ὃς ἐὰν σφάξῃ μόσχον, ἢ πρόβατον, ἢ αἶγα ἐν τῇ παρεμβολῇ, καὶ ὃς ἂν σφάξῃ ἔξω τῆς παρεμβολῆς, ");
INSERT INTO grcbrent_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","καὶ ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου μὴ ἐνέγκῃ, ὥστε ποιῆσαι αὐτὸ εἰς ὁλοκαύτωμα ἢ σωτήριον Κυρίῳ δεκτὸν εἰς ὀσμὴν εὐωδίας· καὶ ὃς ἂν σφάξῃ ἔξω, καὶ ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου μὴ ἐνέγκῃ αὐτὸ, ὥστε προσενέγκαι δῶρον τῷ Κυρίῳ ἀπέναντι τῆς σκηνῆς Κυρίου· καὶ λογισθήσεται τῷ ἀνθρώπῳ ἐκείνῳ αἷμα· αὶμα ἐξέχεεν· ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ὅπως ἀναφέρωσιν οἱ υἱοὶ Ἰσραὴλ τὰς θυσίας αὐτῶν, ὅσας ἂν αὐτοὶ σφάξουσιν ἐν τοῖς πεδίοις, καὶ οἴσουσι τῷ Κυρίῳ ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου πρὸς τὸν ἱερέα· καὶ θύσουσι θυσίαν σωτηρίου τῷ Κυρίῳ αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Καὶ προσχεεῖ ὁ ἱερεὺς τὸ αἷμα ἐπὶ τὸ θυσιαστήριον κύκλῳ ἀπέναντι Κυρίου παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ ἀνοίσει τὸ στέαρ εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Καὶ οὐ θύσουσιν ἔτι τὰς θυσίας αὐτῶν τοῖς ματαίοις, οἷς αὐτοὶ ἐκπορνεύουσιν ὀπίσω αὐτῶν· νόμιμον αἰώνιον ἔσται ὑμῖν εἰς τὰς γενεὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Καὶ ἐρεῖς πρὸς αὐτοὺς, ἄνθρωπος ἄνθρωπος τῶν υἱῶν Ἰσραὴλ, ἢ ἀπὸ τῶν υἱῶν τῶν προσηλύτων τῶν προσκειμένων ἐν ὑμῖν, ὃς ἂν ποιήσῃ ὁλοκαύτωμα ἢ θυσίαν, ");
INSERT INTO grcbrent_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","καὶ ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου μὴ ἐνέγκῃ ποιῆσαι αὐτὸ τῷ Κυρίῳ, ἐξολοθρευθήσεται ὁ ἄνθρωπος ἐκεῖνος ἐκ τοῦ λαοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Καὶ ἄνθρωπος ἄνθρωπος τῶν υἱῶν Ἰσραὴλ, ἢ τῶν προσηλύτων τῶν προσκειμένων ἐν ὑμῖν, ὃς ἂν φάγῃ πᾶν αἷμα· καὶ ἐπιστήσω τὸ πρόσωπόν μου ἐπὶ τὴν ψυχὴν τὴν ἔσθουσαν τὸ αἷμα, καὶ ἀπολῶ αὐτὴν ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ἡ γὰρ ψυχὴ πάσης σαρκὸς αἷμα αὐτοῦ ἐστι· καὶ ἐγὼ δέδωκα αὐτὸ ὑμῖν ἐπὶ τοῦ θυσιαστηρίου ἐξιλάσκεσθαι περὶ τῶν ψυχῶν ὑμῶν· τὸ γὰρ αἷμα αὐτοῦ ἀντὶ ψυχῆς ἐξιλάσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Διὰ τοῦτο εἴρηκα τοῖς υἱοῖς Ἰσραὴλ, πᾶσα ψυχὴ ἐξ ὑμῶν οὐ φάγεται αἷμα· καὶ ὁ προσήλυτος ὁ προσκείμενος ἐν ὑμῖν οὐ φάγεται αἷμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Καὶ ἄνθρωπος ἄνθρωπος τῶν υἱῶν Ἰσραὴλ, ἢ τῶν προσηλύτων τῶν προσκειμένων ἐν ὑμῖν, ὃς ἂν θηρεύσῃ θήρευμα θηρίον ἢ πετεινὸν, ὃ ἔσθεται, καὶ ἐκχεεῖ τὸ αἷμα, καὶ καλύψει αὐτὸ τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ἡ γὰρ ψυχὴ πάσης σαρκὸς αἷμα αὐτοῦ ἐστι· καὶ εἶπα τοῖς υἱοῖς Ἰσραὴλ, αἷμα πάσης σαρκὸς οὐ φάγεσθε, ὅτι ἡ ψυχὴ πάσης σαρκὸς αἷμα αὐτοῦ ἐστί· πᾶς ὁ ἔσθων αὐτὸ, ἐξολοθρευθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Καὶ πᾶσα ψυχὴ, ἥτις φάγεται θνησιμαῖον, ἢ θηριάλωτον ἐν τοῖς αὐτόχθοσιν, ἢ ἐν τοῖς προσηλύτοις, πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας, καὶ καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ἐὰν δὲ μὴ πλύνῃ τὰ ἱμάτια, καὶ τὸ σῶμα μὴ λούσηται ὕδατι, καὶ λήψεται ἀνόμημα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Κατὰ τὰ ἐπιτηδεύματα Αἰγύπτου, ἐν ᾗ κατῳκήσατε ἐπʼ αὐτῇ, οὐ ποιήσετε· καὶ κατὰ τὰ ἐπιτηδεύματα γῆς Χαναὰν, εἰς ἣν ἐγὼ εἰσάγω ὑμᾶς ἐκεῖ, οὐ ποιήσετε, καὶ τοῖς νομίμοις αὐτῶν οὐ πορεύσεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Τὰ κρίματά μου ποιήσετε, καὶ τὰ προστάγματά μου φυλάξεσθε, καὶ πορεύεσθε ἐν αὐτοῖς· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Καὶ φυλάξεσθε πάντα τὰ προστάγματά μου, καὶ πάντα τὰ κρίματά μου, καὶ ποιήσετε αὐτά· ἃ ποιήσας αὐτὰ ἄνθρωπος, ζήσεται ἐν αὐτοῖς· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ἄνθρωπος ἄνθρωπος πρὸς πάντα οἰκεῖα σαρκὸς αὐτοῦ οὐ προσελεύσεται ἀποκαλύψαι ἀσχημοσύνην· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ἀσχημοσύνην πατρός σου καὶ ἀσχημοσύνην μητρός σου οὐκ ἀποκαλύψεις, μήτηρ γάρ σου ἐστὶν, οὐκ ἀποκαλύψεις τὴν ἀσχημοσύνην αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ἀσχημοσύνην γυναικὸς πατρός σου οὐκ ἀποκαλύψεις, ἀσχημοσύνη πατρός σου ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ἀσχημοσύνην τῆς ἀδελφῆς σου ἐκ πατρός σου ἢ ἐκ μητρός σου, ἐνδογενοῦς ἢ γεγεννημένης ἔξω, οὐκ ἀποκαλύψεις ἀσχημοσύνην αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ἀσχημοσύνην θυγατρὸς υἱοῦ σου, ἢ θυγατρὸς θυγατρός σου, οὐκ ἀποκαλύψεις τὴν ἀσχημοσύνην αὐτῶν, ὅτι σὴ ἀσχημοσύνη ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ἀσχημοσύνην θυγατρὸς γυναικὸς πατρός σου οὐκ ἀποκαλύψεις, ὁμοπατρία ἀδελφή σου ἐστὶν, οὐκ ἀποκαλύψεις τὴν ἀσχημοσύνην αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ἀσχημοσύνην ἀδελφῆς πατρός σου οὐκ ἀποκαλύψεις, οἰκεία γὰρ πατρός σου ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ἀσχημοσύνην ἀδελφῆς μητρός σου οὐκ ἀποκαλύψεις, οἰκεία γὰρ μητρός σου ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ἀσχημοσύνην ἀδελφοῦ τοῦ πατρός σου οὐκ ἀποκαλύψεις, καὶ πρὸς τὴν γυναῖκα αὐτοῦ οὐκ εἰσελεύσῃ, συγγενὴς γάρ σου ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ἀσχημοσύνην νύμφης σου οὐκ ἀποκαλύψεις, γυνὴ γὰρ υἱοῦ σου ἐστὶν, οὐκ ἀποκαλύψεις τὴν ἀσχημοσύνην αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ἀσχημοσύνην γυναικὸς ἀδελφοῦ σου οὐκ ἀποκαλύψεις, ἀσχημοσύνη ἀδελφοῦ σου ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ἀσχημοσύνην γυναικὸς καὶ θυγατρὸς αὐτῆς οὐκ ἀποκαλύψεις· τὴν θυγατέρα τοῦ υἱοῦ αὐτῆς, καὶ τὴν θυγατέρα τῆς θυγατρὸς αὐτῆς οὐ λήψῃ ἀποκαλύψαι τὴν ἀσχημοσύνην αὐτῶν, οἰκεῖαι γάρ σου εἰσίν· ἀσέβημα ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Γυναῖκα ἐπʼ ἀδελφῇ αὐτῆς οὐ λήψῃ ἀντίζηλον ἀποκαλύψαι τὴν ἀσχημοσύνην αὐτῆς ἐπʼ αὐτῇ, ἔτι ζώσης αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Καὶ πρὸς γυναῖκα ἐν χωρισμῷ ἀκαθαρσίας αὐτῆς οὐκ εἰσελεύσῃ ἀποκαλύψαι τὴν ἀσχημοσύνην αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Καὶ πρὸς τὴν γυναῖκα τοῦ πλησίον σου οὐ δώσεις κοίτην σπέρματός σου, ἐκμιανθῆναι πρὸς αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Καὶ ἀπὸ τοῦ σπέρματός σου οὐ δώσεις λατρεύειν ἄρχοντι· καὶ οὐ βεβηλώσεις τὸ ὄνομα τὸ ἅγιον· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Καὶ μετὰ ἄρσενος οὐ κοιμηθήσῃ κοίτην γυναικείαν, βδέλυγμα γάρ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Καὶ πρὸς πᾶν τετράπουν οὐ δώσεις τὴν κοίτην σου εἰς σπερματισμὸν, ἐκμιανθῆναι πρὸς αὐτό· καὶ γυνὴ οὐ στήσεται πρὸς πᾶν τετράπουν βιβασθῆναι· μυσαρὸν γάρ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Μὴ μιαίνεσθε ἐν πᾶσι τούτοις· ἐν πᾶσι γὰρ τούτοις ἐμίανθησαν τὰ ἔθνη, ἃ ἐγὼ ἐξαποστέλλω πρὸ προσώπου ὑμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","καὶ ἐξεμιάνθη ἡ γῆ καὶ ἀνταπέδωκα ἀδικίαν αὐτοῖς διʼ αὐτὴν, καὶ προσώχθισεν ἡ γῆ τοῖς ἐγκαθημένοις ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Καὶ φυλάξεσθε πάντα τὰ νόμιμά μου, καὶ πάντα τὰ προστάγματά μου, καὶ οὐ ποιήσετε ἀπὸ πάντων τῶν βδελυγμάτων τούτων ὁ ἐγχώριος, καὶ ὁ προσγενόμενος προσήλυτος ἐν ὑμῖν· ");
INSERT INTO grcbrent_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Πάντα γὰρ τὰ βδελύγματα ταῦτα ἐποίησαν οἱ ἄνθρωποι τῆς γῆς, οἱ ὄντες πρότερον ὑμῶν, καὶ ἐμιάνθη ἡ γῆ·) ");
INSERT INTO grcbrent_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","καὶ ἵνα μὴ προσοχθίσῃ ὑμῖν ἡ γῆ ἐν τῷ μιαίνειν ὑμᾶς αὐτὴν, ὃν τρόπον προσώχθισε τοῖς ἔθνεσι τοῖς πρὸ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ὅτι πᾶς ὃς ἐὰν ποιήσῃ ἀπὸ πάντων τῶν βδελυγμάτων τούτων, ἐξολοθρευθήσονται αἱ ψυχαὶ αἱ ποιοῦσαι ἐκ τοῦ λαοῦ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Καὶ φυλάξετε τὰ προστάγματά μου, ὅπως μὴ ποιήσητε ἀπὸ πάντων τῶν νομίμων τῶν ἐβδελυγμένων, ἃ γέγονε πρὸ τοῦ ὑμᾶς· καὶ οὐ μιανθήσεσθε ἐν αὐτοῖς, ὅτι ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","λάλησον τῇ συναγωγῇ τῶν υἱῶν Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοῦς, ἅγιοι ἔσεσθε, ὅτι ἅγιος ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ἕκαστος πατέρα αὐτοῦ καὶ μητέρα αὐτοῦ φοβείσθω, καὶ τὰ σάββατά μου φυλάξεσθε· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Οὐκ ἐπακολουθήσετε εἰδώλοις, καὶ θεοὺς χωνευτοὺς οὐ ποιήσετε ὑμῖν· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Καὶ ἐὰν θύσητε θυσίαν σωτηρίου τῷ Κυρίῳ, δεκτὴν ὑμῶν θύσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ᾟ ἂν ἡμέρᾳ θύσετε, βρωθήσεται, καὶ τῇ αὔριον· καὶ ἐὰν καταλειφθῇ ἕως ἡμέρας τρίτης, ἐν πυρὶ κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ἐὰν δὲ βρώσει βρωθῇ τῇ ἡμέρᾳ τῇ τρίτῃ, ἄθυτόν ἐστιν, οὐ δεχθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ὁ δὲ ἔσθων αὐτὸ, ἁμαρτίαν λήψεται, ὅτι τὰ ἅγια Κυρίου ἐβεβήλωσε· καὶ ἐξολοθρευθήσονται αἱ ψυχαὶ αἱ ἔσθουσαι ἐκ τοῦ λαοῦ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Καὶ ἐκθεριζόντων ὑμῶν τὸν θερισμὸν τῆς γῆς ὑμῶν, οὐ συντελέσετε τὸν θερισμὸν ὑμῶν τοῦ ἀγροῦ σου ἐκθερίσαι· καὶ τὰ ἀποπίπτοντα τοῦ θερισμοῦ σου οὐ συλλέξεις, ");
INSERT INTO grcbrent_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","καὶ τὸν ἀμπελῶνά σου οὐκ ἐπανατρυγήσεις, οὐδὲ τὰς ῥῶγας τοῦ ἀμπελῶνός σου συλλέξεις· τῷ πτωχῷ καὶ τῷ προσηλύτῳ καταλείψεις αὐτά. ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Οὐ κλέψετε, οὐ ψεύσεσθε, οὐδὲ συκοφαντήσει ἕκαστος τὸν πλησίον. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Καὶ οὐκ ὀμεῖσθε τῷ ὀνόματί μου ἐπʼ ἀδίκῳ, καὶ οὐ βεβηλώσετε τὸ ὄνομα τὸ ἅγιον τοῦ Θεοῦ ὑμῶν· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Οὐκ ἀδικήσεις τὸν πλησίον, καὶ οὐχ ἁρπᾷ· καὶ οὐ μὴ κοιμηθήσεται ὁ μισθὸς τοῦ μισθωτοῦ σου παρὰ σοὶ ἕως πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Οὐ κακῶς ἐρεῖς κωφόν, καὶ ἀπέναντι τυφλοῦ οὐ προσθήσεις σκάνδαλον· καὶ φοβηθήσῃ Κύριον τὸν Θεόν σου· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Οὐ ποιήσετε ἄδικον ἐν κρίσει· οὐ λήψῃ πρόσωπον πτωχοῦ, οὐδὲ μὴ θαυμάσῃς πρόσωπον δυνάστου· ἐν δικαιοσύνῃ κρίνεις τὸν πλησίον σου. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Οὐ πορεύσῃ δόλῳ ἐν τῷ ἔθνει σου· οὐκ ἐπιστήσῃ ἐφʼ αἷμα τοῦ πλησίον σου· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Οὐ μισήσεις τὸν ἀδελφόν σου τῇ διανοίᾳ σου· ἐλεγμῷ ἐλέγξεις τὸν πλησίον σου, καὶ οὐ λήψῃ διʼ αὐτὸν ἁμαρτίαν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Καὶ οὐκ ἐκδικᾶταί σου ἡ χείρ· καὶ οὐ μηνιεῖς τοῖς υἱοῖς τοῦ λαοῦ σου· καὶ ἀγαπήσεις τὸν πλησίον σου ὡς σεαυτόν· ἐγώ εἰμι Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Τὸν νόμον μου φυλάξεσθε· τὰ κτήνη σου οὐ κατοχεύσεις ἑτεροζύγῳ· καὶ τὸν ἀμπελῶνά σου οὐ κατασπερεῖς διάφορον· καὶ ἱμάτιον ἐκ δύο ὑφασμένον κίβδηλον οὐκ ἐπιβαλεῖς σεαυτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Καὶ ἐάν τις κοιμηθῇ μετὰ γυναικὸς κοίτην σπέρματος, καὶ αὕτη ᾖ οἰκέτις διαπεφυλαγμένη ἀνθρώπῳ, καὶ αὕτη λύτροις οὐ λελύτρωται, ἢ ἐλευθερία οὐκ ἐδόθη αὐτῇ, ἐπισκοπὴ ἔσται αὐτοῖς· οὐκ ἀποθανοῦνται, ὅτι οὐκ ἀπηλευθερώθη. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Καὶ προσάξει τῆς πλημμελείας αὐτοῦ τῷ Κυρίῳ παρὰ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου κριὸν πλημμελείας. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς ἐν τῷ κριῷ τῆς πλημμελείας ἔναντι Κυρίου περὶ τῆς ἁμαρτίας ἧς ἥμαρτε, καὶ ἀφεθήσεται αὐτῷ ἡ ἁμαρτία ἣν ἥμαρτεν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ὅταν δὲ εἰσέλθητε εἰς τὴν γῆν, ἣν Κύριος ὁ Θεὸς ὑμῶν δίδωσιν ὑμῖν, καὶ καταφυτεύσετε πᾶν ξύλον βρώσιμον, καὶ περικαθαριεῖτε τὴν ἀκαθαρσίαν αὐτοῦ· ὁ καρπὸς αὐτοῦ τρία ἔτη ἔσται ὑμῖν ἀπερικάθαρτος, οὐ βρωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Καὶ τῷ ἔτει τῷ τετάρτῳ ἔσται πᾶς ὁ καρπὸς αὐτοῦ ἅγιος αἰνετὸς τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ἐν δὲ τῷ ἔτει τῷ πέμπτῳ φάγεσθε τὸν καρπόν, πρόσθεμα ὑμῖν τὰ γεννήματα αὐτοῦ· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Μὴ ἔσθετε ἐπὶ τῶν ὀρέων, καὶ οὐκ οἰωνιεῖσθε, οὐδὲ ὀρνιθοσκοπήσεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Οὐ ποιήσετε σισόην ἐκ τῆς κόμης τῆς κεφαλῆς ὑμῶν, οὐδὲ φθερεῖτε τὴν ὄψιν τοῦ πώγωνος ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Καὶ ἐντομίδας οὐ ποιήσετε ἐπὶ ψυχῇ ἐν τῷ σώματι ὑμῶν· καὶ γράμματα στικτὰ οὐ ποιήσετε ἐν ὑμῖν· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Οὐ βεβηλώσεις τὴν θυγατέρα σου ἐκπορνεῦσαι αὐτήν· καὶ οὐκ ἐκπορνεύσει ἡ γῆ, καὶ ἡ γῆ πλησθήσεται ἀνομίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Τὰ σάββατά μον φυλάξεσθε, καὶ ἀπὸ τῶν ἁγίων μου φοβηθήσεσθε· ἐγώ εἰμι Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Οὐκ ἐπακολουθήσετε ἐγγαστριμύθοις, καὶ τοῖς ἐπαοιδοῖς οὐ προσκολληθήσεσθε, ἐκμιανθῆναι ἐν αὐτοῖς· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ἀπὸ προσώπου πολιοῦ ἐξαναστήσῃ, καὶ τιμήσεις πρόσωπον πρεσβυτέρου, καὶ φοβηθήσῃ τὸν Θεόν σου· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ἐὰν δέ τις προσέλθῃ ὑμῖν προσήλυτος ἐν τῇ γῇ ὑμῶν, οὐ θλίψετε αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ὡς ὁ αὐτόχθων ἐν ὑμῖν ἔσται ὁ προσήλυτος ὁ προσπορευόμενος πρὸς ὑμᾶς, καὶ ἀγαπήσεις αὐτὸν ὡς σεαυτόν· ὅτι προσήλυτοι ἐγενήθητε ἐν γῇ Αἰγύπτῳ· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Οὐ ποιήσετε ἄδικον ἐν κρίσει, ἐν μέτροις καὶ ἐν σταθμίοις καὶ ἐν ζυγοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ζυγὰ δίκαια καὶ σταθμία δίκαια καὶ χοῦς δίκαιος ἔσται ἐν ὑμιν· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν, ὁ ἐξαγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Καὶ φυλάξεσθε πάντα τὸν νόμον μου, καὶ πάντα τὰ προστάγματά μου, καὶ ποιήσετε αὐτά· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, καὶ τοῖς υἱοῖς Ἰσραὴλ λαλήσεις, ");
INSERT INTO grcbrent_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ἐάν τις ἀπὸ τῶν υἱῶν Ἰσραὴλ, ἢ ἀπὸ τῶν γεγενημένων προσηλύτων ἐν Ἰσραὴλ, ὃς ἂν δῷ τοῦ σπέρματος αὐτοῦ ἄρχοντι, θανάτῳ θανατούσθω· τὸ ἔθνος τὸ ἐπὶ τῆς γῆς λιθοβολήσουσιν αὐτὸν ἐν λίθοις. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Καὶ ἐγὼ ἐπιστήσω τὸ πρόσωπόν μου ἐπὶ τὸν ἄνθρωπον ἐκεῖνον, καὶ ἀπολῶ αὐτὸν ἐκ τοῦ λαοῦ αὐτοῦ, ὅτι τοῦ σπέρματος αὐτοῦ ἔδωκεν ἄρχοντι, ἵνα μιάνῃ τὰ ἅγιά μου, καὶ βεβηλώσῃ τὸ ὄνομα τῶν ἡγιασμένων μοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ἐὰν δὲ ὑπερόψει ὑπερίδωσιν οἱ αὐτόχθονες τῆς γῆς τοῖς ὀφθαλμοῖς αὐτῶν ἀπὸ τοῦ ἀνθρώπου ἐκείνου, ἐν τῷ δοῦναι αὐτὸν τοῦ σπέρματος αὐτοῦ ἄρχοντι, τοῦ μὴ ἀποκτεῖναι αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","καὶ ἐπιστήσω τὸ πρόσωπόν μου ἐπὶ τὸν ἄνθρωπον ἐκεῖνον, καὶ τὴν συγγένειαν αὐτοῦ, καὶ ἀπολῶ αὐτὸν, καὶ πάντας τοὺς ὁμονοοῦντας αὐτῷ, ὥστε ἐκπορνεύειν αὐτὸν εἰς τοὺς ἄρχοντας, ἐκ τοῦ λαοῦ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Καὶ ψυχὴ ἣ ἂν ἐπακολουθήσῃ ἐγγαστριμύθοις ἢ ἐπαοιδοῖς, ὥστε ἐκπορνεῦσαι ὀπίσω αὐτῶν, ἐπιστήσω τὸ πρόσωπόν μου ἐπὶ τὴν ψυχὴν ἐκείνην, καὶ ἀπολῶ αὐτῆν ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Καὶ ἔσεσθε ἅγιοι, ὅτι ἅγιος ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Καὶ φυλάξεσθε τὰ προστάγματά μου, καὶ ποιήσετε αὐτά· ἐγὼ Κύριος ὁ ἁγιάζεν ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ἄνθρωπος ἄνθρωπος, ὃς ἂν κακῶς εἴπῃ τὸν πατέρα αὐτοῦ ἢ τὴν μητέρα αὐτοῦ, θανάτῳ θανατούσθω· πατέρα αὐτοῦ ἢ μητέρα αὐτοῦ κακῶς εἶπεν; ἔνοχος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ἄνθρωπος ὃς ἂν μοιχεύσηται γυναῖκα ἀνδρός, ἢ ὃς ἂν μοιχεύσηται γυναῖκα τοῦ πλησίον, θανάτῳ θανατούσθωσαν, ὁ μοιχεύων καὶ ἡ μοιχευομένη. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Καὶ ἐάν τις κοιμηθῇ μετὰ γυναικὸς τοῦ πατρὸς αὐτοῦ, ἀσχημοσύνην τοῦ πατρὸς αὐτοῦ ἀπεκάλυσε· θανάτῳ θανατούσθωσαν ἀμφότεροι, ἔνοχοί εἰσι. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Καὶ ἐάν τις κοιμηθῇ μετὰ νύμφης αὐτοῦ, θανάτῳ θανατούσθωσαν ἀμφότεροι· ἠσεβήκασι γάρ, ἔνοχοί εἰσι. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Καὶ ὃς ἂν κοιμηθῇ μετὰ ἄρσενος κοίτην γυναικὸς, βδέλυγμα ἐποίησαν ἀμφότεροι· θανάτῳ θανατούσθωσαν, ἔνοχοι εἰσιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Ὃς ἂν λάβῃ γυναῖκα καὶ τὴν μητέρα αὐτῆς, ἀνόμημά ἐστιν· ἐν πυρὶ κατακαύσουσιν αὐτὸν καὶ αὐτὰς, καὶ οὐκ ἔσται ἀνομία ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Καὶ ὃς ἂν δῷ κοιτασίαν αὐτοῦ ἐν τετράποδι, θανάτῳ θανάτούσθω, καὶ τὸ τετράπουν ἀποκτενεῖτε. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Καὶ γυνὴ ἥτις προσελεύσεται πρὸς πᾶν κτῆνος βιβασθῆναι αὐτὴν ὑπʼ αὐτοὺ, ἀποκτενεῖτε τὴν γυναῖκα καὶ τὸ κτῆνος· θανάτῳ θανατούσθωσαν, ἔνοχοί εἰσιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ὃς ἂν λάβῃ τὴν ἀδελφὴν αὐτοῦ ἐκ πατρὸς αὐτοῦ ἢ ἐκ μητρὸς αὐτοῦ, καὶ ἴδῃ τὴν ἀσχημοσύνην αὐτῆς, καὶ αὕτη ἴδῃ τὴν ἀσχημοσύνην αὐτοῦ, ὄνειδός ἐστιν, ἐξολοθρευθήσονται ἐνωπιον υἱῶν γένους αὐτῶν· ἀσχημοσύνην ἀδελφῆς αὐτοῦ ἀπεκάλυψεν, ἁμαρτίαν κομιοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Καὶ ἀνὴρ ὃς ἂν κοιμηθῇ μετὰ γυναικὸς ἀποκαθημένης, καὶ ἀποκαλύψῃ τὴν ἀσχημοσύνην αὐτῆς, τὴν πηγὴν αὐτῆς ἀπεκάλυψε, καὶ αὕτη ἀπεκάλυψε τὴν ῥύσιν τοῦ αἵματος αὐτῆς· ἐξολοθρευθήσονται ἀμφότεροι ἐκ τῆς γενεᾶς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Καὶ ἀσχημοσύνην ἀδελφῆς πατρὸς σου, καὶ ἀδελφῆς μητρός σου οὐκ ἀποκαλύψεις· τὴν γὰρ οἰκειότητα ἀπεκάλυψεν, ἁμαρτίαν ἀποίσονται. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ὃς ἂν κοιμηθῇ μετὰ τῆς συγγενοῦς αὐτοῦ, ἀσχημοσύνην τῆς συγγενείας αὐτοῦ ἀπεκάλυψεν, ἄτεκνοι ἀποθανοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ὃς ἐὰς λάβῃ γυναῖκα τοῦ ἀδελφοῦ αὐτοῦ, ἀκαθαρσία ἐστίν· ἀσχημοσύνην τοῦ ἀδελφοῦ αὐτοῦ ἀπεκάλυψεν, ἄτεκνοι ἀποθανοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Καὶ φυλάξασθε πάντα τὰ προστάγματά μου, καὶ τὰ κρίματά μου, καὶ ποιήσετε αὐτὰ, καὶ οὐ μὴ προσοχθίσῃ ὑμῖν ἡ γῆ, εἰς ἣν ἐγὼ εἰσάγω ὑμᾶς ἐκεῖ κατοικεῖν ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Καὶ οὐχὶ πορεύεσθε τοῖς νομίμοις τῶν ἐθνῶν, οὓς ἐξαποστέλλω ἀφʼ ὑμῶν· ὅτι ταῦτα πάντα ἐποίησαν, καὶ ἐβδελυξάμην αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Καὶ εἶπα ὑμῖν, ὑμεῖς κληρονομήσετε τὴν γῆν αὐτῶν, καὶ ἐγὼ δώσω ὑμῖν αὐτὴν ἐν κτήσει, γῆν ῥέουσαν γάλα καὶ μέλι· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν, ὃς διώρισα ὑμᾶς ἀπὸ πάντων τῶν ἐθνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Καὶ ἀφοριεῖτε αὐτοὺς ἀναμέσον τῶν κτηνῶν τῶν καθαρῶν καὶ ἀναμέσον τῶν κτηνῶν τῶν ἀκαθάρτων, καὶ ἀναμέσον τῶν πετεινῶν τῶν καθαρῶν καὶ τῶν ἀκαθάρτων· καὶ οὐ βδελύξετε τὰς ψυχὰς ὑμῶν ἐν τοῖς κτήνεσι, καὶ ἐν τοῖς πετεινοῖς, καὶ ἐν πᾶσι τοῖς ἑρπετοῖς τῆς γῆς ἃ ἐγὼ ἀφώρισα ὑμῖν ἐν ἀκαθαρσίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Καὶ ἔσεσθέ μοι ἅγιοι, ὅτι ἐγὼ ἅγιός εἶμι Κύριος ὁ Θεὸς ὑμῶν, ὁ ἀφορίσας ὑμᾶς ἀπὸ πάντων τῶν ἐθνῶν, εἶναί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Καὶ ἀνὴρ ἢ γυνὴ ὃς ἂν γένηται αὐτῶν ἐγγαστρίμυθος ἢ ἐπαοιδός, θανάτῳ θανατούσθωσαν ἀμφότεροι· λίθοις λιθοβολήσετε αὐτοὺς, ἔνοχοί εἰσι. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, εἶπον τοῖς ἱερεύσι τοῖς υἱοῖς Ἀαρὼν, καὶ ἐρεῖς πρὸς αὐτούς, ἐν ταῖς ψυχαῖς οὐ μιανθήσονται ἐν τῷ ἔθνει αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ἀλλʼ ἢ ἐν τῷ οἰκείῳ τῷ ἔγγιστα αὐτῶν, ἐπὶ πατρὶ καὶ μητρὶ, καὶ υἱοῖς, καὶ θυγατράσιν, ἐπʼ ἀδελφῷ, ");
INSERT INTO grcbrent_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","καὶ ἐπʼ ἀδελφῇ παρθένῳ τῇ ἐγγιζούσῃ αὐτῷ, τῇ μὴ ἐκδεδομένῃ ἀνδρί, ἐπὶ τούτοις μιανθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Οὐ μιανθήσεται ἐξάπινα ἐν τῷ λαῷ αὐτοῦ εἰς βεβήλωσιν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Καὶ φαλάκρωμα οὐ ξυρηθήσεσθε τὴν κεφαλὴν ἐπὶ νεκρῷ· καὶ τὴν ὄψιν τοῦ πώγωνος οὐ ξυρήσονται· καὶ ἐπὶ τὰς σάρκας αὐτῶν οὐ κατατεμοῦσιν ἐντομίδας. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ἅγιοι ἔσονται τῷ Θεῷ αὐτῶν, καὶ οὐ βεβηλώσουσι τὸ ὄνομα τοῦ Θεοῦ αὐτῶν· τὰς γὰρ θυσίας Κυρίου δῶρα τοῦ Θεοῦ αὐτῶν αὐτοὶ προσφέρουσι, καὶ ἔσονται ἅγιοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Γυναῖκα πόρνην καὶ βεβηλωμένην οὐ λήψονται, καὶ γυναῖκα ἐκβεβλημένην ἀπὸ ἀνδρὸς αὐτῆς, ὅτι ἅγιός ἐστι Κυρίῳ τῷ Θεῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Καὶ ἁγιάσεις αὐτόν· τὰ δῶρα Κυρίου τοῦ Θεοῦ ὑμῶν οὗτος προσφέρει, ἅγιος ἔσται· ὅτι ἅγιος ἐγὼ Κύριος ὁ ἁγιάζων αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Καὶ θυγάτηρ ἀνθρώπου ἱερέως ἐὰν βεβηλωθῇ τοῦ ἐκπορνεύσαι, τὸ ὄνομα τοῦ πατρὸς αὐτῆς αὐτὴ βεβηλοῖ· ἐπὶ πυρὸς κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Καὶ ὁ ἱερεὺς ὁ μέγας ἀπὸ τῶν ἀδελφῶν αὐτοῦ, τοῦ ἐπικεχυμένου ἐπὶ τὴν κεφαλὴν τοῦ ἐλαίου τοῦ χριστοῦ, καὶ τετελειωμένου ἐνδύσασθαι τὰ ἱμάτια, τὴν κεφαλὴν οὐκ ἀποκιδαρώσει, καὶ τὰ ἱμάτια οὐ διαῤῥήξει, ");
INSERT INTO grcbrent_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","καὶ ἐπὶ πάσῃ ψυχῇ τετελευτηκυίᾳ οὐκ εἰσελεύσεται, ἐπὶ πατρὶ αὐτοῦ οὐδὲ ἐπὶ μητρὶ αὐτοῦ οὐ μιανθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Καὶ ἐκ τῶν ἁγίων οὐκ ἐξελεύσεται, καὶ οὐ βεβηλώσει τὸ ἡγιασμένον τοῦ Θεοῦ αὐτοῦ, ὅτι τὸ ἅγιον ἔλαιον τὸ χριστὸν τοῦ Θεοῦ ἐπʼ αὐτῷ· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Οὗτος γυναῖκα παρθένον ἐκ τοῦ γένους αὐτοῦ λήψεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Χήραν δὲ καὶ ἐκβεβλημένην καὶ βεβηλωμένην καὶ πόρνην, ταύτας οὐ λήψεται, ἀλλʼ ἢ παρθένον ἐκ τοῦ λαοῦ αὐτοῦ λήψεται γυναῖκα. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Καὶ οὐ βεβηλώσει τὸ σπέρμα αὐτοῦ ἐν τῷ λαῷ αὐτοῦ· ἐγὼ Κύριος ὁ ἁγιάζων αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","εἶπον Ἀαρὼν, ἄνθρωπος ἐκ τοῦ γένους σου εἰς τὰς γενεὰς ὑμῶν, τινὶ ἐὰν ᾖ ἐν αὐτῷ μῶμος, οὐ προσελεύσεται προσφέρειν τὰ δῶρα τοῦ Θεοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","πᾶς ἄνθρωπος ᾧ ἐστιν ἐν αὐτῷ μῶμος, οὐ προσελεύσεται· ἄνθρωπος τυφλὸς. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ἢ χωλὸς, ἢ κολοβόριν, ἢ ὠτότμητος, ἢ ἄνθρωπος ᾧ ἂν ᾖ ἐν αὐτῳ σύντριμμα χειρὸς, ἢ σύντριμμα ποδὸς, ");
INSERT INTO grcbrent_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ἢ κυρτὸς, ἢ ἔφηλος, ἢ πτίλλος τοὺς ὀφθαλμούς, ἢ ἄνθρωπος ᾧ ἂν ᾖ ἐν αὐτῷ ψώρα ἀγρία, ἢ λειχὴν, ἢ μονόρχις. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Πᾶς ᾧ ἐστιν ἐν αὐτῷ μῶμος, ἐκ τοῦ σπέρματος Ἀαρὼν τοῦ ἱερέως, οὐκ ἐγγιεῖ τοῦ προσενεγκεῖν τὰς θυσίας τῷ Θεῷ σου, ὅτι μῶμος ἐν αὐτῷ· τὰ δῶρα τοῦ Θεοῦ οὐ προσελεύσεται προσενεγκεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Τὰ δῶρα τοῦ Θεοῦ τὰ ἅγια τῶν ἁγίων, καὶ ἀπὸ τῶν ἁγίων φάγεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Πλὴν πρὸς τὸ καταπέτασμα οὐ προσελεύσεται, καὶ πρὸς τὸ θυσιαστήριον οὐκ ἐγγιεῖ, ὅτι μῶμον ἔχει· καὶ οὐ βεβηλώσει τὸ ἅγιον τοῦ Θεοῦ αὐτοῦ, ὅτι ἐγώ εἰμι Κύριος ὁ ἁγιάζων αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Καὶ ἐλάλησε Μωυσῆς πρὸς Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ, καὶ πρὸς πάντας υἱοὺς Ἱσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","εἶπον Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ· καὶ προσεχέτωσαν ἀπὸ τῶν ἁγίων τῶν υἱῶν Ἰσραὴλ, καὶ οὐ βεβηλώσουσι τὸ ὄνομα τὸ ἅγιόν μου, ὅσα αὐτοὶ ἁγιάζουσί μοι· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Εἶπον αὐτοῖς, εἰς τὰς γενεὰς ὑμῶν πᾶς ἄνθρωπος, ὃς ἂν προσέλθῃ ἀπὸ παντὸς τοῦ σπέρματος ὑμῶν πρὸς τὰ ἅγια, ὅσα ἂν ἁγιάζωσιν οἱ υἱοὶ Ἰσραὴλ τῷ Κυρίῳ, καὶ ἡ ἀκαθαρσία αὐτοῦ ἐπʼ αὐτῷ ᾖ, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἀπʼ ἐμοῦ· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Καὶ ἄνθρωπος ἐκ τοῦ σπέρματος Ἀαρὼν τοῦ ἱερέως, καὶ οὗτος λεπρᾷ ἢ γονοῤῥυεῖ, τῶν ἁγίων οὐκ ἔδεται, ἕως ἂν καθαρισθῇ· καὶ ὁ ἁπτόμενος πάσης ἀκαθαρσίας ψυχῆς, ἢ ἄνθρωπος ᾧ ἂν ἐξέλθῃ ἐξ αὐτοῦ κοίτη σπέρματος, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ἢ ὅστις ἂν ἅψηται παντὸς ἑρπετοῦ ἀκαθάρτου, ὃ μιανεῖ αὐτὸν, ἢ ἐπʼ ἀνθρώπῳ, ἐν ᾧ μιανεῖ αὐτὸν κατὰ πᾶσαν ἀκαθαρσίαν αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ψυχὴ ἥτις ἐὰν ἅψηται αὐτῶν, ἀκάθαρτος ἔσται ἕως ἑσπέρας· οὐκ ἔδεται ἀπὸ τῶν ἁγίων, ἐὰν μὴ λούσηται τὸ σῶμα αὐτοῦ ὕδατι. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Καὶ δύῃ ὁ ἥλιος, καὶ καθαρὸς ἔσται· καὶ τότε φάγεται τῶν ἁγίων, ὅτι ἄρτος αὐτοῦ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Θνησιμαῖον καὶ θηριάλωτον οὐ φάγεται, μιανθῆναι αὐτὸν ἐν αὐτοῖς· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Καὶ φυλάξονται τὰ φυλάγματά μου, ἵνα μὴ λάβωσι διʼ αὐτὰ ἁμαρτίαν, καὶ ἀποθάνωσι διʼ αὐτὰ, ἐὰν βεβηλώσουσιν αὐτά· ἐγὼ Κύριος ὁ Θεὸς ὁ ἁγιάζων αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Καὶ πᾶς ἀλλογενὴς οὐ φάγεται ἅγια· πάροικος ἱερέως, ἢ μισθωτὸς, οὐ φάγεται ἅγια. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ἐὰν δὲ ἱερεὺς κτήσηται ψυχὴν ἔγκτητον ἀργυρίου, οὗτος φάγεται ἐκ τῶν ἄρτων αὐτοῦ· καὶ οἱ οἰκογενεῖς αὐτοῦ, καὶ οὗτοι φάγονται τῶν ἄρτων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Καὶ θυγάτηρ ἀνθρώπου ἱερέως ἐὰν γένηται ἀνδρὶ ἀλλογενεῖ, αὐτὴ τῶν ἀπαρχῶν ἁγίου οὐ φάγεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Καὶ θυγάτηρ ἱερέως ἐὰν γένηται χήρα ἢ ἐκβεβλημένη, σπέρμα δὲ μὴ ᾖ αὐτῇ, ἐπαναστρέψει ἐπὶ τὸν οἶκον τὸν πατρικὸν κατὰ τὴν νεότητα αὐτῆς· ἀπὸ τῶν ἄρτων τοῦ πατρὸς αὐτῆς φάγεται· καὶ πᾶς ἀλλογενὴς οὐ φάγεται ἀπʼ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Καὶ ἄνθρωπος ὃς ἂν φάγῃ ἅγια κατʼ ἄγνοιαν, καὶ προσθήσει τὸ ἐπίπεμπτον αὐτοῦ ἐπʼ αὐτὸ, καὶ δώσει τῷ ἱερεῖ τὸ ἅγιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Καὶ οὐ βεβηλώσουσι τὰ ἅγια τῶν υἱῶν Ἰσραὴλ, ἃ αὐτοὶ ἀφαιροῦσι τῷ Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","καὶ ἐπάξουσιν ἐφʼ ἑαυτοὺς ἀνομίαν πλημμελείας ἐν τῷ ἐσθίειν αὐτοὺς τὰ ἅγια αὐτῶν, ὅτι ἐγὼ Κύριος ὁ ἁγιάζων αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","λάλησον Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, καὶ πάσῃ συναγωγῇ Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ἄνθρωπος ἄνθρωπος ἀπὸ τῶν υἱῶν Ἰσραὴλ, ἢ τῶν προσηλύτων τῶν προσκειμένων πρὸς αὐτοὺς ἐν Ἰσραὴλ, ὃς ἂν προσενέγκῃ τὰ δῶρα αὐτοῦ κατὰ πᾶσαν ὁμολογίαν αὐτῶν, ἢ κατὰ πᾶσαν αἵρεσιν αὐτῶν, ὅσα ἂν προσενέγκωσι τῷ Θεῷ εἰς ὁλοκαύτωμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Δεκτὰ ὑμῖν ἄμωμα ἄρσενα ἐκ τῶν βουκολίων, ἢ ἐκ τῶν προβάτων, καὶ ἐκ τῶν αἰγῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Πάντα ὅσα ἂν ἔχῃ μῶμον ἐν αὐτῷ οὐ προσάξουσι Κυρίῳ, διότι οὐ δεκτὸν ἔσται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Καὶ ἄνθρωπος ὃς ἂν προσενέγκῃ θυσίαν σωτηρίου τῷ Κυρίῳ, διαστείλας εὐχὴν ἢ κατὰ αἵρεσιν ἢ ἐν ταῖς ἑορταῖς ὑμῶν, ἐκ τῶν βουκολίων ἢ ἐκ τῶν προβάτων, ἄμωμον ἔσται εἰσδεκτὸν, πᾶς μῶμος οὐκ ἔσται ἐν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Τυφλὸν ἢ συντετριμμένον ἢ γλωσσότμητον ἢ μυρμηκιῶντα ἢ ψωραγριῶντα ἢ λειχῆνας ἔχοντα, οὐ προσάξουσι ταῦτα τῷ Κυρίῳ, καὶ εἰς κάρπωσιν οὐ δώσετε ἀπʼ αὐτῶν ἐπὶ τὸ θυσιαστήριον τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Καὶ μόσχον ἢ πρόβατον ὠτότμητον ἢ κολοβόκερκον, σφάγια ποιήσεις αὐτὰ σεαυτῷ, εἰς δὲ εὐχήν σου οὐ δεχθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Θλαδίαν καὶ ἐκτεθλιμμένον καὶ ἐκτομίαν καὶ ἀπεσπασμένον, οὐ προσάξεις αὐτὰ τῷ Κυρίῳ, καὶ ἐπὶ τῆς γῆς ὑμῶν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Καὶ ἐκ χειρὸς ἀλλογενοῦς οὐ προσοίσετε τὰ δῶρα τοῦ Θεοῦ ὑμῶν ἀπὸ πάντων τούτων· ὅτι φθάρματά ἐστιν ἐν αὐτοῖς, μῶμος ἐν αὐτοῖς οὐ δεχθήσεται ταῦτα ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","μόσχον ἢ πρόβατον ἢ αἶγα, ὡς ἂν τεχθῇ, καὶ ἔσται ἑπτὰ ἡμέρας ὑπὸ τὴν μητέρα, τῇ δὲ ἡμέρᾳ τῇ ὀγδόῃ καὶ ἐπέκεινα δεχθήσεται εἰς δῶρα, κάρπωμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Καὶ μόσχον καὶ πρόβατον, αὐτὴν καὶ τὰ παιδία αὐτῆς, οὐ σφάξεις ἐν ἡμέρᾳ μιᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ἐὰν δὲ θύσῃς θυσίαν εὐχὴν χαρμοσύνης Κυρίῳ, εἰσδεκτὸν ὑμῖν θύσετε αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Αὐτῇ τῇ ἡμέρᾳ ἐκείνῃ βρωθήσεται· οὐκ ἀπολείψετε ἀπὸ τῶν κρεῶν εἰς τοπρωΐ· ἐγώ εἰμι Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Καὶ φυλάξετε τὰς ἐντολάς μου, καὶ ποιήσετε αὐτάς. ");
INSERT INTO grcbrent_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Καὶ οὐ βεβηλώσετε τὸ ὄνομα τοῦ ἁγίου, καὶ ἁγιασθήσομαι ἐν μέσῳ τῶν υἱῶν Ἰσραήλ· ἐγὼ Κύριος ὁ ἁγιάζων ὑμᾶς, ");
INSERT INTO grcbrent_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ὁ ἐξαγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου, ὥστε εἶναι ὑμῶν Θεός· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτούς, αἱ ἑορταὶ Κυρίου ἃς καλέσετε αὐτὰς κλητὰς ἁγίας, αὗταί εἰσιν αἱ ἑορταί μου. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ἓξ ἡμέρας ποιήσεις ἔργα, τῇ δὲ ἡμέρᾳ τῇ ἑβδόμῃ σάββατα, ἀνάπαυσις, κλητὴ ἁγία τῷ Κυρίῳ· πᾶν ἔργον οὐ ποιήσεις· σάββατά ἐστι τῷ Κυρίῳ ἐν πάσῃ κατοικίᾳ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Αὗται αἱ ἑορταὶ τῷ Κυρίῳ κληταὶ ἅγιαι, ἃς καλέσετε αὐτὰς ἐν τοῖς καιροῖς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ἐν τῷ πρώτῳ μηνὶ, ἐν τῇ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς, ἀναμέσον τῶν ἑσπερινῶν πάσχα τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Καὶ ἐν τῇ πεντεκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τούτου ἑορτὴ τῶν ἀζύμων τῷ Κυρίῳ· ἑπτὰ ἡμέρας ἄζυμα ἔδεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Καὶ ἡμέρα ἡ πρώτη κλητὴ ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Καὶ προσάξετε ὁλοκαυτώματα τῷ Κυρίῳ ἑπτὰ ἡμέρας· καὶ ἡ ἡμέρα ἡ ἑβδόμη κλητὴ ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","εἶπον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ὅταν εἰσέλθητε εἰς τὴν γῆν, ἣν ἐγὼ δίδωμι ὑμῖν, καὶ θερίζητε τὸν θερισμὸν αὐτῆς, καὶ οἴσετε τὸ δράγμα ἀπαρχὴν τοῦ θερισμοῦ ὑμῶν πρὸς τὸν ἱερέα· ");
INSERT INTO grcbrent_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Καὶ ἀνοίσει τὸ δράγμα ἔναντι Κυρίου δεκτὸν ὑμῖν· τῇ ἐπαύριον τῆς πρώτης ἀνοίσει αὐτό ὁ ἱερεύς. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Καὶ ποιήσετε ἐν τῇ ἡμέρᾳ ἐν ᾗ ἂν φέρητε τὸ δράγμα, πρόβατον ἄμωμον ἐνιαύσιον εἰς ὁλοκαύτωμα τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Καὶ τὴν θυσίαν αὐτοῦ δύο δέκατα σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ· θυσία τῷ Κυρίῳ, ὀσμὴ εὐωδίας Κυρίῳ· καὶ σπονδὴν αὐτοῦ τὸ τέταρτον τοῦ ἳν οἴνου. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Καὶ ἄρτον, καὶ πεφρυγμένα χίδρα νέα οὐ φάγεσθε ἕως εἰς αὐτὴν τὴν ἡμέραν ταύτην, ἕως ἂν προσενέγκητε ὑμεῖς τὰ δῶρα τῷ Θεῷ ὑμῶν· νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν ἐν πάσῃ κατοικίᾳ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Καὶ ἀριθμήσετε ὑμῖν ἀπὸ τῆς ἐπαύριον τῶν σαββάτων, ἀπὸ τῆς ἡμέρας ἧς ἂν προσενέγκητε τὸ δράγμα τοῦ ἐπιθέματος, ἑπτὰ ἑβδομάδας ὁλοκλήρους, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ἕως τῆς ἐπαύριον τῆς ἐσχάτης ἑβδομάδος ἀριθμήσετε πεντήκοντα ἡμέρας, καὶ προσοίσετε θυσίαν νέαν τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ἀπὸ τῆς κατοικίας ὑμῶν προσοίσετε ἄρτους ἐπίθεμα, δύο ἄρτους· ἐκ δύο δεκάτων σεμιδάλεως ἔσονται, ἐζυμωμένοι πεφθήσονται πρωτογεννημάτων τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Καὶ προσάξετε μετὰ τῶν ἄρτων ἑπτὰ ἀμνοὺς ἀμώμους ἐνιαυσίους, καὶ μόσχον ἕνα ἐκ βουκολίου, καὶ κριοὺς δύο ἀμώμους, καὶ ἔσονται ὁλοκαύτωμα τῷ Κυρίῳ· καὶ αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν θυσία ὀσμὴ εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Καὶ ποιήσουσι χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, καὶ δύο ἀμνοὺς ἐνιαυσίους εἰς θυσίαν σωτηρίου μετὰ τῶν ἄρτων τοῦ πρωτογεννήματος. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Καὶ ἐπιθήσει αὐτὰ ὁ ἱερεὺς μετὰ τῶν ἄρτων τοῦ πρωτογεννήματος ἐπίθεμα ἐναντίον Κυρίου μετὰ τῶν δύο ἀμνῶν, ἅγια ἔσονται τῷ Κυρίῳ· τῷ ἱερεῖ τῷ προσφέροντι αὐτὰ αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Καὶ καλέσετε ταύτην τὴν ἡμέραν κλητήν· ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε ἐν αὐτῇ· νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν ἐν πάσῃ τῇ κατοικίᾳ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Καὶ ὅταν θερίζητε τὸν θερισμὸν τῆς γῆς ὑμῶν, οὐ συντελέσετε τὸ λοιπὸν τοῦ θερισμοῦ τοῦ ἀγροῦ σου ἐν τῷ θερίζειν σε, καὶ τὰ ἀποπίπτοντα τοῦ θερισμοῦ σου οὐ συλλέξεις· τῷ πτωχῷ καὶ τῷ προσηλύτῳ ὑπολείψεις αὐτά· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, τοῦ μηνὸς τοῦ ἐβδόμου μιᾷ τοῦ μηνὸς ἔσται ὑμῖν ἀνάπαυσις, μνημόσυνον σαλπίγγων· κλητὴ ἁγία ἔσται ὑμῖν· ");
INSERT INTO grcbrent_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Πᾶν ἔργον λατρευτὸν οὐ ποιήσετε· καὶ προσάξετε ὁλοκαύτωμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","καὶ τῇ δεκάτῃ τοῦ μηνὸς τοῦ ἐβδόμου τούτου, ἡμέρα ἐξιλασμοῦ, κλητὴ ἁγία ἔσται ὑμῖν· καὶ ταπεινώσετε τὰς ψυχὰς ὑμῶν, καὶ προσάξετε ὁλοκαύτωμα τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Πᾶν ἔργον οὐ ποιήσετε ἐν αὐτῇ τῇ ἡμέρᾳ ταύτῃ· ἔστι γὰρ ἡμέρα ἐξιλασμοῦ αὕτη ὑμῖν, ἐξιλάσασθαι περὶ ὑμῶν ἔναντι Κυρίου τοῦ Θεοῦ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Πᾶσα ψυχὴ, ἥτις μὴ ταπεινωθήσεται ἐν αὐτῇ τῇ ἡμέρᾳ ταύτῃ, ἐξολοθρευθήσεται ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Καὶ πᾶσα ψυχὴ, ἥτις ποιήσει ἔργον ἐν αὐτῇ τῇ ἡμέρᾳ ταύτῃ, ἀπολεῖται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Πᾶν ἔργον οὐ ποιήσετε· νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν ἐν πάσαις κατοικίαις ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Σάββατα σαββάτων ἔσται ὑμῖν· καὶ ταπεινώσετε τὰς ψυχὰς ὑμῶν· ἀπὸ ἐνάτης τοῦ μηνὸς, ἀπὸ ἑσπέρας ἕως ἑσπέρας σαββατιεῖτε τὰ σάββατα ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, τῇ πεντεκαιδεκάτῃ τοῦ μηνὸς τοῦ ἐβδόμου τούτου, ἑορτὴ σκηνῶν ἑπτὰ ἡμέρας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Καὶ ἡ ἡμέρα ἡ πρώτη κλητὴ ἁγία· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ἑπτὰ ἡμέρας προσάξετε ὁλοκαυτώματα τῷ Κυρίῳ, καὶ ἡ ἡμέρα ἡ ὀγδόη κλητὴ ἁγία ἔσται ὑμῖν· καὶ προσάξετε ὁλοκαυτώματα Κυρίῳ· ἐξόδιόν ἐστι· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Αὗται ἑορταὶ Κυρὶῳ, ἃς καλέσετε κλητὰς ἁγίας, ὥστε προσενέγκαι καρπώματα τῷ Κυρίῳ, ὁλοκαυτώματα καὶ θυσίας αὐτῶν, καὶ σπονδὰς αὐτῶν τὸ καθʼ ἡμέραν εἰς ἡμέραν· ");
INSERT INTO grcbrent_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","πλὴν τῶν σαββάτων Κυρίου, καὶ πλὴν τῶν δομάτων ὑμῶν, καὶ πλὴν πασῶν τῶν εὐχῶν ὑμῶν, καὶ πλὴν τῶν ἐκουσίων ὑμῶν, ἃ ἂν δώτε τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Καὶ ἐν τῇ πεντεκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τοῦ ἑβδόμου τούτου, ὅταν συντελέσητε τὰ γεννήματα τῆς γῆς, ἑορτάσατε τῷ Κυρίῳ ἑπτὰ ἡμέρας· τῇ ἡμέρᾳ τῇ πρώτῃ ἀνάπαυσις, καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ ἀνάπαυσις. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Καὶ λήψεσθε τῇ ἡμέρᾳ τῇ πρώτῃ καρπὸν ξύλου ὡραῖου, καὶ κάλλυνθρα φοινίκων, καὶ κλάδους ξύλου δασεῖς, καὶ ἰτέας, καὶ ἄγνου κλάδους ἐκ χειμάῤῥου, εὐφρανθῆναι ἔναντι Κυρίου τοῦ Θεοῦ ὑμῶν ἑπτὰ ἡμέρας τοῦ ἐνιαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν· ἐν τῷ μηνὶ τῷ ἑβδόμῳ ἑορτάσετε αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ἐν σκηναῖς κατοικήσετε ἑπτὰ ἡμέρας· πᾶς ὁ αὐτόχθων ἐν Ἰσραὴλ κατοικήσει ἐν σκηναῖς, ");
INSERT INTO grcbrent_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ὅπως ἴδωσιν αἱ γενεαὶ ὑμῶν, ὅτι ἐν σκηναῖς κατῴκισα τοὺς υἱοὺς Ἰσραὴλ, ἐν τῷ ἐξαγαγεῖν με αὐτοὺς ἐκ γῆς Αἰγύπτου· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Καὶ ἐλάλησε Μωυσῆς τὰς ἑορτὰς Κυρίου τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ἔντειλαι τοῖς υἱοῖς Ἰσραὴλ, καὶ λαβέτωσάν σοι ἔλαιον ἐλάϊνον καθαρὸν κεκομμένον εἰς φῶς, καῦσαι λύχνον διαπαντὸς, ");
INSERT INTO grcbrent_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ἔξωθεν τοῦ καταπετάσματος ἐν τῇ σκηνῇ τοῦ μαρτυρίου· καὶ καύσουσιν αὐτὸ Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ ἀπὸ ἑσπέρας ἕως πρωῒ ἐνώπιον Κυρίου ἐνδελεχῶς, νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ἐπὶ τῆς λυχνίας τῆς καθαρᾶς καύσετε τοὺς λύχνους ἐναντίον Κυρίου ἕως εἰς τοπρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Καὶ λήμψεσθε σεμίδαλιν, καὶ ποιήσετε αὐτὴν δώδεκα ἄρτους· δύο δεκάτων ἔσται ὁ ἄρτος ὁ εἷς. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Καὶ ἐπιθήσετε αὐτοὺς δύο θέματα, ἓξ ἄρτους τὸ ἓν θέμα ἐπὶ τὴν τράπεζαν τὴν καθαρὰν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Καὶ ἐπιθήσετε ἐπὶ τὸ θέμα λίβανον καθαρὸν καὶ ἅλα, καὶ ἔσονται εἰς ἄρτους εἰς ἀνάμνησιν προκείμενα τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Τῇ ἡμέρᾳ τῶν σαββάτων προσθήσεται ἔναντι Κυρίου διαπαντὸς ἐνώπιον τῶν υἱῶν Ἰσραὴλ, διαθήκην αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Καὶ ἔσται Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ· καὶ φάγονται αὐτὰ ἐν τόπῳ ἁγίῳ· ἔστι γὰρ ἅγια τῶν ἁγίῳν τοῦτο αὐτῶν ἀπὸ τῶν θυσιαζομένων τῷ Κυρίῳ, νόμιμον αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Καὶ ἐξῆλθεν υἱὸς γυναικὸς Ἰσραηλίτιδος, καὶ οὗτος ἦν υἱὸς Αἰγυπτίου ἐν τοῖς υἱοῖς Ἰσραήλ· καὶ ἐμαχέσαντο ἐν τῇ παρεμβολῇ ὁ ἐκ τῆς Ἰσραηλίτιδος, καὶ ὁ ἄνθρωπος ὁ Ἰσραηλίτης. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Καὶ ἐπονομάσας ὁ υἱὸς τῆς γυναικὸς τῆς Ἰσραηλίτιδος τὸ ὄνομα κατηράσατο· καὶ ἤγαγον αὐτὸν πρὸς Μωυσῆν· καὶ τὸ ὄνομα τῆς μητρὸς αὐτοῦ Σαλωμεὶθ θυγάτηρ Δαβρεὶ ἐκ τῆς φυλῆς Δάν. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Καὶ ἀπέθεντο αὐτὸν εἰς φυλακὴν διακρῖναι αὐτὸν διὰ προστάγματος Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","ἐξάγαγε τὸν καταρασάμενον ἔξω τῆς παρεμβολῆς, καὶ ἐπιθήσουσι πάντες οἱ ἀκούσαντες τὰς χεῖρας αὐτῶν ἐπὶ τὴν κεφαλὴν αὐτοῦ, καὶ λιθοβολήσουσιν αὐτὸν πᾶσα ἡ συναγωγή. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Καὶ τοῖς υἱοῖς Ἰσραὴλ λάλησον, καὶ ἐρεῖς πρὸς αὐτοὺς, ἄνθρωπος ὃς ἐὰν καταράσηται Θεὸν, ἁμαρτίαν λήψεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ὀνομάζων δὲ τὸ ὄνομα Κυρίου, θανάτῳ θανατούσθω· λίθοις λιθοβολείτω αὐτὸν πᾶσα ἡ συναγωγὴ Ἰσραήλ· ἐάν τε προσήλυτος ἐάν τε αὐτόχθων, ἐν τῷ ὀνομάσαι αὐτὸν τὸ ὄνομα Κυρίου, τελευτάτω. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Καὶ ἄνθρωπος ὃς ἂν πατάξῃ ψυχὴν ἀνθρώπου, καὶ ἀποθάνῃ, θανάτῳ θανατούσθω. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Καὶ ὃς ἂν πατάξῃ κτῆνος, καὶ ἀποθάνῃ, ἀποτισάτω ψυχὴν ἀντὶ ψυχῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Καὶ ἐάν τις δῷ μῶμον τῷ πλησίον, ὡς ἐποίησεν αὐτῷ, ὡσαύτως ἀντιποιηθήσεται αὐτῷ· ");
INSERT INTO grcbrent_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Σύντριμμα ἀντὶ συντρίμματος, ὀφθαλμὸν ἀντὶ ὀφθαλμοῦ, ὀδόντα ἀντὶ ὀδόντος, καθότι ἂν δῷ μῶμον τῷ ἀνθρώπῳ, οὕτω δοθήσεται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ὃς ἂν πατάξῃ ἄνθρωπον, καὶ ἀποθάνῃ, θανάτῳ θανατούσθω. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Δικαίωσις μία ἔσται τῷ προσηλύτῳ καὶ τῷ ἐγχωρίῳ, ὅτι ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Καὶ ἐλάλησε Μωυσῆς τοῖς υἱοῖς Ἰσραήλ· καὶ ἐξήγαγον τὸν καταρασάμενον ἔξω τῆς παρεμβολῆς, καὶ ἐλιθοβόλησαν αὐτὸν ἐν λίθοις· καὶ οἱ υἱοὶ Ἰσραὴλ ἐποίησαν καθάπερ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν ἐν τῷ ὄρει Σινᾷ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ὅταν εἰσέλθητε εἰς τὴν γῆν, ἣν ἐγὼ δίδωμι ὑμῖν, καὶ ἀναπαύσεται ἡ γῆ, ἣν ἐγὼ δίδωμι ὑμῖν, σάββατα τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ἓξ ἔτη σπερεῖς τὸν ἀγρόν σου, καὶ ἓξ ἔτη τεμεῖς τὴν ἄμπελόν σου, καὶ συνάξεις τὸν καρπὸν αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Τῷ δὲ ἔτει τῷ ἑβδόμῳ σάββατα· ἀνάπαυσις ἔσται τῇ γῇ, σάββατα τῷ Κυρίῳ· τὸν ἀγρόν σου οὐ σπερεῖς, καὶ τὴν ἄμπελόν σου οὐ τεμεῖς, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","καὶ τὰ αὐτόματα ἀναβαίνοντα τοῦ ἀγροῦ σου οὐκ ἐκθερίσεις, καἰ τὴν σταφυλὴν τοῦ ἁγιάσματός σου οὐκ ἐκτρυγήσεις· ἐνιαυτὸς ἀναπαύσεως ἔσται τῇ γῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Καὶ ἔσται τὰ σάββατα τῆς γῆς βρώματά σοι, καὶ τῷ παιδί σου, καὶ τῇ παιδίσκῃ σου, καὶ τῷ μισθωτῷ σου, καὶ τῷ παροίκῳ τῷ προσκειμένῳ πρὸς σέ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Καὶ τοῖς κτήνεσί σου, καὶ τοῖς θηρίοις τοῖς ἐν τῇ γῇ σου ἔσται πᾶν τὸ γέννημα αὐτοῦ εἰς βρῶσιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Καὶ ἐξαριθμήσεις σεαυτῷ ἑπτὰ ἀναπαύσεις ἐτῶν, ἑπτὰ ἔτη ἑπτάκις· καὶ ἔσονταί σοι ἑπτὰ ἑβδομάδες ἐτῶν ἐννέα καὶ τεσσαράκοντα ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Διαγγελεῖτε σάλπιγγος φωνῇ ἐν πάσῃ τῇ γῇ ὑμῶν ἐν τῷ μηνὶ τῷ ἑβδόμῳ τῇ δεκάτῃ τοῦ μηνός· τῇ ἡμέρᾳ τοῦ ἱλασμοῦ διαγγελεῖτε σάλπιγγι ἐν πάσῃ τῇ γῇ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Καὶ ἁγιάσετε τὸ ἔτος τὸν πεντηκοστὸν ἐνιαυτὸν, καὶ διαβοήσετε ἄφεσιν ἐπὶ τῆς γῆς πᾶσι τοῖς κατοικοῦσιν αὐτήν· ἐνιαυτὸς ἀφέσεως σημασία αὕτη ἔσται ὑμῖν· καὶ ἀπελεύσεται εἷς ἕκαστος εἰς τὴν κτῆσιν αὐτοῦ, καὶ ἕκαστος εἰς τὴν πατριὰν αὐτοῦ ἀπελεύσεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ἀφέσεως σημασία αὕτη, τὸ ἔτος τὸ πεντηκοστὸν ἐνιαυτὸς ἔσται ὑμῖν· οὐ σπερεῖτε, οὐδὲ ἀμήσετε τὰ αὐτόματα ἀναβαίνοντα αὐτῆς, καὶ οὐ τρυγήσετε τὰ ἡγιασμένα αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ὅτι ἀφέσεως σημασία ἐστίν· ἅγιον ἔσται ὑμῖν· ἀπὸ τῶν πεδίων φάγεσθε τὰ γεννήματα αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ἐν τῷ ἔτει τῆς ἀφέσεως σημασίας αὐτῆς ἐπανελεύσεται εἰς τὴν ἔγκτησιν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ἐὰν δὲ ἀποδῷ πράσιν τῷ πλησίον σου, ἐὰν δὲ καὶ κτήσῃ παρὰ τοῦ πλησίον σου, μὴ θλιβέτω ἄνθρωπος τὸν πλησίον. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Κατὰ ἀριθμὸν ἐτῶν μετὰ τὴν σημασίαν κτήσῃ παρὰ τοῦ πλησίον, κατὰ ἀριθμὸν ἐνιαυτῶν γεννημάτων ἀποδώσεταί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Καθότι ἂν πλεῖον τῶν ἐτῶν πληθυνεῖ τὴν ἔγκτησιν αὐτοῦ, καὶ καθότι ἂν ἔλαττον τῶν ἐτῶν ἐλαττονώσει τὴν ἔγκτησιν αὐτοῦ· ὅτι ἀριθμὸν γεννημάτων αὐτοῦ, οὕτως ἀποδώσεταί σοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Μὴ θλιβέτω ἄνθρωπος τὸν πλησίον· καὶ φοβηθήσῃ Κύριον τὸν Θεόν σου· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Καὶ ποιήσετε πάντα τὰ δικαιώματά μου, καὶ πάσας τὰς κρίσεις μου, καὶ φυλάξασθε, καὶ ποιήσετε αὐτὰ, καὶ κατοικήσετε ἐπὶ τῆς γῆς πεποιθότες. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Καὶ δώσει ἡ γῆ τὰ ἐκφόρια αὐτῆς, καὶ φάγεσθε εἰς πλησμονὴν, καὶ κατοικήσετε πεποιθότες ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ἐὰν δὲ λέγητε, τί φαγόμεθα ἐν τῷ ἔτει τῷ ἑβδόμῳ τούτῳ, ἐὰν μὴ σπείρωμεν μηδὲ συναγάγωμεν τὰ γεννήματα ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Καὶ ἀποστέλλω τὴν εὐλογίαν μου ὑμῖν ἐν τῷ ἔτει τῷ ἕκτῳ, καὶ ποιήσει τὰ γεννήματα αὐτῆς εἰς τὰ τρία ἔτη. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Καὶ σπερεῖτε τὸ ἔτος τὸ ὄγδοον, καὶ φάγεσθε ἀπὸ τῶν γεννημάτων παλαιὰ ἕως τοῦ ἔτους τοῦ ἐνάτου· ἕως ἂν ἔλθῃ τὸ γέννημα αὐτῆς, φάγεσθε παλαιὰ παλαιῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Καὶ ἡ γῆ οὐ πραθήσεται εἰς βεβαίωσιν· ἐμὴ γάρ ἐστιν ἡ γῆ, διότι προσήλυτοι καὶ πάροικοι ὑμεῖς ἐστε ἐναντίον μου. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Καὶ κατὰ πᾶσαν γῆν κατασχέσεως ὑμῶν, λύτρα δώσετε τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ἐὰν δὲ πένηται ὁ ἀδελφός σου ὁ μετὰ σοῦ, καὶ ἀποδῶται ἀπὸ τῆς κατασχέσεως αὐτοῦ, καὶ ἔλθῃ ὁ ἀγχιστεύων ὁ ἐγγίζων αὐτῷ, καὶ λυτρώσεται τὴν πρᾶσιν τοῦ ἀδελφοῦ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ἐὰν δὲ μὴ ᾖ τινι ὁ ἀγχιστεύων, καὶ εὐπορηθῇ τῇ χειρὶ, καὶ εὑρεθῇ αὐτῷ τὸ ἱκανὸν, λύτρα αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","καὶ συλλογιεῖται τὰ ἔτη τῆς πράσεως αὐτοῦ, καὶ ἀποδώσει ὅ ὑπερέχει τῷ ἀνθρώπῳ, ᾧ ἀπέδοτο αὐτὸ αὐτῷ, καὶ ἀπελεύσεται εἰς τὴν κατάσχεσιν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ἐὰν δὲ μὴ εὑπορηθῇ αὐτοῦ ἡ χεὶρ τὸ ἱκανὸν, ὥστε ἀποδοῦναι αὐτῷ, καὶ ἔσται ἡ πράσις τῷ κτησαμένῳ αὐτὰ ἕως τοῦ ἕκτου ἔτους τῆς ἀφέσεως, καὶ ἐξελεύσεται ἐν τῇ ἀφέσει, καὶ ἀπελεύσεται εἰς τὴν κατάσχεσιν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ἐὰν δέ τις ἀποδῶται οἰκίαν οἰκητὴν ἐν πόλει τετειχισμένῃ, καὶ ἔσται ἡ λύτρωσις αὐτῆς, ἕως πληρωθῇ· ἐνιαυτὸς ἡμερῶν ἔσται ἡ λύτρωσις αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ἐὰν δὲ μὴ λυτρωθῇ ἕως ἂν πληρωθῇ αὐτῆς ἐνιαυτὸς ὅλος, κυρωθήσεται ἡ οἰκία ἡ οὖσα ἐν πόλει τῇ ἐχούσῃ τεῖχος, βεβαίως τῷ κτησαμένῳ αὐτὴν εἰς τὰς γενεὰς αὐτοῦ, καὶ οὐκ ἐξελεύσεται ἐν τῇ ἀφέσει. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Αἱ δὲ οἰκίαι αἱ ἐν ἐπαύλεσιν, αἷς οὐκ ἔστιν ἐν αὐταῖς τεῖχος κύκλῳ, πρὸς τὸν ἀγρὸν τῆς γῆς λογισθήσονται· λυτρωταὶ διαπαντὸς ἔσονται, καὶ ἐν τῇ ἀφέσει ἐξελεύσονται. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Καὶ αἱ πόλεις τῶν Λευιτῶν, οἰκίαι τῶν πόλεων κατασχέσεως αὐτῶν, λυτρωταὶ διαπαντὸς ἔσονται τοῖς Λευίταις. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Καὶ ὃς ἂν λυτρώσηται παρὰ τῶν Λευιτῶν, καὶ ἐξελεύσεται ἡ διάπρασις αὐτῶν οἰκιῶν πόλεως κατασχέσεως αὐτῶν ἐν τῇ ἀφέσει, ὅτι οἰκίαι τῶν πόλεων τῶν Λευιτῶν κατάσχεσις αὐτῶν ἐν μέσῳ υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Καὶ οἱ ἀγροὶ ἀφωρισμένοι ταῖς πόλεσιν αὐτῶν οὐ πραθήσονται, ὅτι κατάσχεσις αἰωνία τοῦτο αὐτῶν ἐστον. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ἐὰν δὲ πένηται ὁ ἀδελφός σοῦ ὁ μετὰ σοῦ, καὶ ἀδυνατήσῃ ταῖς χερσὶ παρὰ σοὺ, ἀντιλήψῃ αὐτοῦ ὡς προσηλύτου καὶ παροίκου, καὶ ζήσεται ὁ ἀδελφός σου μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Οὐ λήψῃ παρʼ αὐτοῦ τόκον, οὐδὲ ἐπὶ πλήθει· καὶ φοβηθήσῃ τὸν Θεόν σου· ἐγὼ Κύριος· καὶ ζήσεται ὁ ἀδελφός σου μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Τὸ ἀργύριόν σου οὐ δώσεις αὐτῷ ἐπὶ τὸκῳ, καὶ ἐπὶ πλεονασμῷ οὐ δώσεις αὐτῷ τὰ βρώματά σου. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ἐγὼ Κύριος ὁ Θεὸς ὑμῶν, ὁ ἐξαγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου, δοῦναι ὑμῖν τὴν γῆν Χαναὰν, ὥστε εἶναι ὑμῶν Θεός. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ἐὰν δὲ ταπεινωθῇ ὁ ἀδελφός σου παρὰ σοὶ, καὶ πραθῇ σοι, οὐ δουλεύσει σοι δουλείαν οἰκέτου. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ὡς μισθωτὸς ἢ πάροικος ἔσται σοι· ἕως τοῦ ἔτους τῆς ἀφέσεως ἐργᾶται παρὰ σοί, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","καὶ ἐξελεύσεται τῇ ἀφέσει, καὶ τὰ τέκνα αὐτοῦ μετʼ αὐτοῦ, καὶ ἀπελεύσεται εἰς τὴν γενεὰν αὐτοῦ, εἰς τὴν κατάσχεσιν τὴν πατρικὴν ἀποδραμεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Διότι οἰκέται μου εἰσὶν οὗτοι, οὓς ἐξήγαγον ἐκ γῆς Αἰγύπτου· οὐ πραθήσεται ἐν πράσει οἰκέτου. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Οὐ κατατενεῖς αὐτὸν ἐν τῷ μόχθῳ, καὶ φοβηθήσῃ Κύριον τὸν Θεόν σου, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","καὶ παῖς καὶ παιδίσκη ὅσοι ἂν γένωνταί σοι, ἀπὸ τῶν ἐθνῶν ὅσοι κύκλῳ σου εἰσὶν, ἀπʼ αὐτῶν κτήσεσθε δοῦλον καὶ δούλην, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","καὶ ἀπὸ τῶν υἱῶν τῶν παροίκων τῶν ὄντων ἐν ὑμῖν, ἀπὸ τούτων κτήσεσθε καὶ ἀπὸ τῶν συγγενῶν αὐτῶν, ὅσοι ἂν γένωνται ἐν τῇ γῇ ὑμῶν, ἔστωσαν ὑμῖν εἰς κατάσχεσιν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Καὶ καταμεριεῖτε αὐτοὺς τοῖς τέκνοις ὑμῶν μεθʼ ὑμᾶς· καὶ ἔσονται ὑμῖν κατόχιμοι εἰς τὸν αἰῶνα· τῶν δὲ ἀδελφῶν ὑμῶν τῶν υἱῶν Ἰσραὴλ, ἕκαστος τὸν ἀδελφὸν αὐτοῦ οὐ κατατενεῖ αὐτὸν ἐν τοῖς μόχθοις. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ἐὰν δὲ εὕρῃ ἡ χεὶρ τοὺ προσηλύτου ἢ τοῦ παροίκου τοῦ παρὰ σοὶ, καὶ ἀπορηθεὶς ὁ ἀδελφός σου πραθῇ τῷ προσηλύτῳ ἢ τῷ παροίκῳ τῷ παρὰ σοὶ, ἢ ἐκ γενετῆς προσηλύτῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","μετὰ τὸ πραθῆναι αὐτῷ, λύτρωσις ἔσται αὐτοῦ· εἷς τῶν ἀδελφῶν αὐτοῦ λυτρώσεται αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ἀδελφὸς πατρὸς αὐτοῦ, ἢ υἱὸς ἀδελφοῦ πατρὸς λυτρώσεται αὐτόν, ἢ ἀπὸ τῶν οἰκείων τῶν σαρκῶν αὐτοῦ ἐκ τῆς φυλῆς αὐτοῦ λυτρῶται αὐτόν· ἐὰν δὲ εὐπορηθεὶς ταῖς χερσὶ λυτρῶται ἑαυτὸν, ");
INSERT INTO grcbrent_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","καὶ συλλογιεῖται πρὸς τὸν κεκτημένον αὐτὸν ἀπὸ τοῦ ἔτους οὗ ἀπέδοτο ἑαυτὸν αὐτῷ ἕως τοῦ ἐνιαυτοῦ τῆς ἀφέσεως· καὶ ἔσται τὸ ἀργύριον τῆς πράσεως αὐτοῦ ὡς μισθίου· ἔτος ἐξ ἔτους ἔσται μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ἐὰν δέ τινι πλεῖον τῶν ἐτῶν ᾖ, πρὸς ταῦτα ἀποδώσει τὰ λύτρα αὐτοῦ ἀπὸ τοῦ ἀργυρίου τῆς πράσεως αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ἐὰν δὲ ὀλίγον καταλειφθῇ ἀπὸ τῶν ἐτῶν εἰς τὸν ἐνιαυτὸν τῆς ἀφέσεως, καὶ συλλογιεῖται αὐτῷ κατὰ τὰ ἔτη αὐτοῦ, καὶ ἀποδώσει τὰ λύτρα αὐτοῦ ὡς μισθωτός· ");
INSERT INTO grcbrent_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ἐνιαυτὸς ἐξ ἐνιαυτοῦ ἔσται μετʼ αὐτοῦ· οὐ κατατενεῖς αὐτὸν ἐν τῷ μόχθῳ ἐνώπιόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ἐὰν δὲ μὴ λυτρῶται κατὰ ταῦτα, ἐξελεύσεται ἐν τῷ ἔτει τῆς ἀφέσεως αὐτὸς καὶ τὰ παιδία αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ὅτι ἐμοὶ οἱ υἱοὶ Ἰσραὴλ οἰκέται εἰσὶ, παῖδές μου οὗτοί εἰσιν, οὓς ἐξήγαγον ἐκ γῆς Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ἐγὼ Κύριος ὁ Θεὸς ὑμῶν· οὐ ποιήσετε ὑμῖν αὐτοῖς χειροποίητα, οὐδὲ γλυπτὰ, οὐδὲ στήλην ἀναστήσετε ὑμῖν, οὐδὲ λίθον σκοπὸν θήσετε ἐν τῇ γῇ ὑμῶν προσκυνῆσαι αὐτῷ· ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Τὰ σάββατά μου φυλάξεσθε, καὶ ἀπὸ τῶν ἁγίων μου φοβηθήσεσθε· ἐγώ εἰμι Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ἐὰν τοῖς προστάγμασί μου πορεύησθε, καὶ τὰς ἐντολάς μου φυλάσσησθε, καὶ ποιήσητε αὐτὰς, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","καὶ δώσω τὸν ὑετὸν ὑμῖν ἐν καιρῷ αὐτοῦ, καὶ ἡ γῆ δώσει τὰ γεννήματα αὐτῆς, καὶ τὰ ξύλα τῶν πεδίων ἀποδώσει τὸν καρπὸν αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Καὶ καταλήψεται ὑμῖν ὁ ἁλοητὸς τὸν τρυγητὸν, καὶ ὁ τρυγητὸς καταλήψεται τὸν σπόρον· καὶ φάγεσθε τὸν ἄρτον ὑμῶν εἰς πλησμονήν· καὶ κατοικήσετε μετὰ ἀσφαλείας ἐπὶ τῆς γῆς ὑμῶν, καὶ πόλεμος οὐ διελεύσεται διὰ τῆς γῆς ὑμῶν· ");
INSERT INTO grcbrent_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Καὶ δώσω εἰρήνην ἐν τῇ γῇ ὑμῶν· καὶ κοιμηθήσεσθε, καὶ οὐκ ἔσται ὑμᾶς ὁ ἐκφοβῶν· καὶ ἀπολῶ θηρία πονηρὰ ἐκ τῆς γῆς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Καὶ διώξεσθε τοὺς ἐχθροὺς ὑμῶν, καὶ πεσοῦνται ἐναντίον ὑμῶν φόνῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Καὶ διώξονται ἐξ ὑμῶν πέντε ἑκατὸν, καὶ ἑκατὸν ὑμῶν διώξονται μυριάδας· καὶ πεσοῦνται οἱ ἐχθροὶ ὑμῶν ἐναντίον ὑμῶν μαχαίρᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Καὶ ἐπιβλέψω ἐφʼ ὑμᾶς, καὶ αὐξανῶ ὑμᾶς, καὶ πληθυνῶ ὑμᾶς, καὶ στήσω τὴν διαθήκην μου μεθʼ ὑμῶν· ");
INSERT INTO grcbrent_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Καὶ φάγεσθε παλαιὰ καὶ παλαιὰ παλαιῶν, καὶ παλαιὰ ἐκ προσώπου νέων ἐξοίσετε. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Καὶ θήσω τὴν σκηνήν μου ἐν ὑμῖν, καὶ οὐ βδελύξεται ἡ ψυχή μου ὑμᾶς, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","καὶ ἐμπεριπατήσω ἐν ὑμῖν· καὶ ἔσομαι ὑμῶν Θεὸς, καὶ ὑμεῖς ἔσεσθέ μοι λαός. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ἐγώ εἰμι Κύριος ὁ Θεὸς ὑμῶν, ὁ ἐξαγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου, ὄντων ὑμῶν δούλων· καὶ συνέτριψα τὸν δεσμὸν τοῦ ζυγοῦ ὑμῶν, καὶ ἤγαγον ὑμᾶς μετὰ παῤῥησίας. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ἐὰν δὲ μὴ ὑπακούσητέ μου, μηδὲ ποιήσητε τὰ προστάγματά μου ταῦτα, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ἀλλὰ ἀπειθήσητε αὐτοῖς, καὶ τοῖς κρίμασί μου προσοχθίσῃ ἡ ψυχὴ ὑμῶν, ὥστε ὑμᾶς μὴ ποιεῖν πάσας τὰς ἐντολάς μου, ὥστε διασκεδάσαι τὴν διαθήκην μου, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","καὶ ἐγὼ ποιήσω οὕτως ὑμῖν· καὶ ἐπιστήσω ἐφʼ ὑμᾶς τὴν ἀπορίαν, τήν τε ψώραν, καὶ τὸν ἴκτερα σφακελίζοντα τοὺς ὀφθαλμοὺς ὑμῶν, καὶ τὴν ψυχὴν ὑμῶν ἐκτήκουσαν· καὶ σπερεῖτε διακενῆς τὰ σπέρματα ὑμῶν, καὶ ἔδονται οἱ ὑπεναντίοι ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Καὶ ἐπιστήσω τὸ πρόσωπόν μου ἐφʼ ὑμᾶς, καὶ πεσεῖσθε ἐναντίον τῶν ἐχθρῶν ὑμῶν, καὶ διώξονται ὑμᾶς οἱ μισοῦντες ὑμᾶς, καὶ φεύξεσθε οὐδενὸς διώκοντος ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Καὶ ἐὰν ἕως τούτου μὴ ὑπακούσητέ μου, καὶ προσθήσω τοῦ παιδεῦσαι ὑμᾶς ἑπτάκις ἐπὶ ταῖς ἁμαρτίαις ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Καὶ συντρίψω τὴν ὕβριν τῆς ὑπερηφανίας ὑμῶν· καὶ θήσω τὸν οὐρανὸν ὑμῖν σιδηροῦν, καὶ τὴν γῆν ὑμῶν ὡσεὶ χαλκῆν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Καὶ ἔσται εἰς κενὸν ἡ ἰσχὺς ὑμῶν· καὶ οὐ δώσει ἡ γῆ ὑμῶν τὸν σπόρον αὐτῆς, καὶ τὸ ξύλον τοῦ ἀγρου ὑμῶν οὐ δώσει τὸν καρπὸν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Καὶ ἐὰν μετὰ ταῦτα πορεύησθε πλάγιοι, καὶ μὴ βούλησθε ὑπακούειν μου, προσθήσω ὑμῖν πληγὰς ἑπτὰ κατὰ τὰς ἁμαρτίας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Καὶ ἀποστέλλω ἐφʼ ὑμᾶς τὰ θηρία τὰ ἄγρια τῆς γῆς, καὶ κατέδεται ὑμᾶς, καὶ ἐξαναλώσει τὰ κτήνη ὑμῶν, καὶ ὀλιγοστοὺς ποιήσω ὑμᾶς, καὶ ἐρημωθήσονται αἱ ὁδοὶ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Καὶ ἐπὶ τούτοις ἐὰν μὴ παιδευθῆτε, ἀλλὰ πορεύησθε πρός με πλάγιοι, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","πορεύσομαι κᾀγὼ μεθʼ ὑμῶν θυμῷ πλαγίῳ, καὶ πατάξω ὑμᾶς κᾀγὼ ἑπτάκις ἀντὶ τῶν ἁμαρτιῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Καὶ ἐπάξω ἐφʼ ὑμᾶς μάχαιραν ἐκδικοῦσαν δίκην διαθήκης, καὶ καταφεύξεσθε εἰς τὰς πόλεις ὑμῶν· καὶ ἐξαποστελῶ θάνατον εἰς ὑμᾶς, καὶ παραδοθήσεσθε εἰς χεῖρας τῶν ἐχθρῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ἐν τῷ θλίψαι ὑμᾶς σιτοδείᾳ ἄρτων, καὶ πέψουσι δέκα γυναῖκες τοὺς ἄρτους ὑμῶν ἐν κλιβάνῳ ἑνὶ, καὶ ἀποδώσουσι τοὺς ἄρτους ὑμῶν ἐν σταθμῷ, καὶ φάγεσθε, καὶ οὐ μὴ ἐμπλησθῆτε. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ἐὰν δὲ ἐπὶ τούτοις μὴ ὑπακούσητέ μου, καὶ πορεύησθε πρός με πλάγιοι, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","καὶ αὐτὸς πορεύσομαι μεθʼ ὑμῶν ἐν θυμῷ πλαγίῳ, καὶ παιδεύσω ὑμᾶς ἐγὼ ἑπτάκις κατὰ τὰς ἁμαρτίας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Καὶ φάγεσθε τὰς σάρκας τῶν υἱῶν ὑμῶν, καὶ τὰς σάρκας τῶν θυγατέρων ὑμῶν φάγεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Καὶ ἐρημώσω τὰς στήλας ὑμῶν, καὶ ἐξολοθρεύσω τὰ ξύλινα χειροποίητα ὑμῶν, καὶ θήσω τὰ κῶλα ὑμῶν ἐπὶ τὰ κῶλα τῶν εἰδώλων ὑμῶν, καὶ προσοχθιεῖ ἡ ψυχή μου ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Καὶ θήσω τὰς πόλεις ὑμῶν ἐρήμους, καὶ ἐξερημώσω τὰ ἅγια ὑμῶν, καὶ οὐ μὴ ὀσφρανθῶ τῆς ὀσμῆς τῶν θυσιῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Καὶ ἐξερημώσω ἐγὼ τὴν γῆν ὑμῶν, καὶ θαυμάσονται ἐπʼ αὐτῇ οἱ ἐχθροὶ ὑμῶν, οἱ ἐνοικοῦντες ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Καὶ διασπερῶ ὑμᾶς εἰς τὰ ἔθνη, καὶ ἐξαναλώσει ὑμᾶς ἐπιπορευομένη ἡ μάχαιρα, καὶ ἔσται ἡ γῆ ὑμῶν ἔρημος, καὶ αἱ πόλεις ὑμῶν ἔσονται ἔρημοι. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Τότε εὐδοκήσει ἡ γῆ τὰ σάββατα αὐτῆς πάσας τὰς ἡμέρας τῆς ἐρημώσεως αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","καὶ ὑμεῖς ἔσεσθε ἐν τῇ γῇ τῶν ἐχθρῶν ὑμῶν· τότε σαββατιεῖ ἡ γη, καὶ εὐδοκήσει ἡ γῆ τὰ σάββατα αὐτῆς πάσας τὰς ἡμέρας τῆς ἐρημώσεως αὐτῆς· σαββατιεῖ ἃ οὐκ ἐσαββάτισεν ἐν τοῖς σαββάτοις ὑμῶν, ἡνίκα κατῳκεῖτε αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Καὶ τοῖς καταλειφθεῖσιν ἐξ ὑμῶν ἐπάξω δουλείαν εἰς τὴν καρδίαν αὐτῶν ἐν τῇ γῇ τῶν ἐχθρῶν αὐτῶν· καὶ διώξεται αὐτοὺς φωνὴ φύλλου φερομένου, καὶ φεύξονται ὡς φεύγοντες ἀπὸ πολέμου, καὶ πεσοῦνται οὐθενὸς διώκοντος. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Καὶ ὑπερόψεται ὁ ἀδελφὸς τὸν ἀδελφὸν ὡσεὶ ἐν πολέμῳ, οὐθενὸς κατατρέχοντος· καὶ οὐ δυνήσεσθε ἀντιστῆναι τοῖς ἐχθροῖς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Καὶ ἀπολεῖσθε ἐν τοῖς ἔθνεσι, καὶ κατέδεται ὑμᾶς ἡ γῆ τῶν ἐχθρῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Καὶ οἱ καταλειφθέντες ἀφʼ ὑμῶν, καταφθαρήσονται διὰ τὰς ἁμαρτίας αὐτῶν, καὶ διὰ τὰς ἁμαρτίας τῶν πατέρων αὐτῶν· ἐν τῇ γῇ τῶν ἐχθρῶν αὐτῶν τακήσονται. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Καὶ ἐξαγορεύσουσι τὰς ἁμαρτίας αὐτῶν, καὶ τὰς ἁμαρτίας τῶν πατέρων αὐτῶν, ὅτι παρέβησαν καὶ ὑπερεῖδόν με, καὶ ὅτι ἐπορεύθησαν ἐναντίον μου πλάγιοι, ");
INSERT INTO grcbrent_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","καὶ ἐγὼ ἐπορεύθην μετʼ αὐτῶν ἐν θυμῷ πλαγίῳ· καὶ ἀπολῶ αὐτοὺς ἐν τῇ γῇ τῶν ἐχθρῶν αὐτῶν· τότε ἐντραπήσεται ἡ καρδία αὐτῶν ἡ ἀπερίτμητος, καὶ τότε εὐδοκήσουσι τὰς ἁμαρτίας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Καὶ μνησθήσομαι τῆς διαθήκης Ἰακὼβ, καὶ τῆς διαθήκης Ἰσαὰκ, καὶ τῆς διαθήκης Ἁβραὰμ μνησθήσομαι. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Καὶ τῆς γῆς μνησθήσομαι, καὶ ἡ γῆ ἐγκαταλειφθήσεται ἀπʼ αὐτῶν· τότε προσδέξεται ἡ γῆ τὰ σάββατα αὐτῆς, ἐν τῷ ἐρημωθῆναι αὐτὴν διʼ αὐτούς· καὶ αὐτοὶ προσδέξονται τὰς αὐτῶν ἀνομίας, ἀνθʼ ὧν τὰ κρίματά μου ὑπερεῖδον, καὶ τοῖς προστάγμασί μου προσώχθισαν τῇ ψυχῇ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Καὶ οὐδʼ ὡς ὄντων αὐτῶν ἐν τῇ γῇ τῶν ἐχθρῶν αὐτῶν, οὐχ ὑπερεῖδον αὐτούς, οὐδὲ προσώχθισα αὐτοῖς ὥστε ἐξαναλῶσαι αὐτούς τοῦ διασκεδάσαι τὴν διαθήκην μου τὴν πρὸς αὐτούς· ἐγὼ γάρ εἰμι Κύριος ὁ Θεὸς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Καὶ μνησθήσομαι διαθήκης αὐτῶν τῆς προτέρας, ὅτε ἐξήγαγον αὐτοὺς ἐκ γῆς Αἰγύπτου, ἐξ οἴκου δουλείας ἔναντι τῶν ἐθνῶν, τοῦ εἶναι αὐτῶν Θεός· ἐγώ εἰμι Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ταῦτα τὰ κρίματά μου, καὶ τὰ προστάγματά μου, καὶ ὁ νόμος ὃν ἔδωκε Κύριος ἀναμέσον αὐτοῦ καὶ ἀναμέσον τῶν υἱῶν Ἰσραὴλ, ἐν τῷ ὄρει Σινᾷ ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς αὐτοῖς, ὃς ἂν εὔξηται εὐχὴν ὥστε τιμὴν τῆς ψυχῆς αὐτοῦ τῷ Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ἔσται ἡ τιμὴ τοῦ ἄρσενος ἀπὸ εἰκοσαετοῦς, ἕως ἑξηκονταετοῦς, ἔσται αὐτοῦ ἡ τιμὴ πεντήκοντα δίδραχμα ἀργυρίου τῷ σταθμῷ τῷ ἁγίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Τῆς δὲ θηλείας ἔσται ἡ συντίμησις τριάκοντα δίδραχμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ἐὰν δὲ ἀπὸ πενταετοῦς ἕως εἴκοσι ἐτῶν, ἔσται ἡ τιμὴ τοῦ ἄρσενος εἴκοσι δίδραχμα· τῆς δὲ θηλείας, δέκα δίδραχμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ἀπὸ δὲ μηνιαίου ἕως πενταετοῦς, ἔσται ἡ τιμὴ τοῦ ἄρσενος πέντε δίδραχμα· τῆς δὲ θηλείας, τρία δίδραχμα ἀργυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ἐὰν δὲ ἀπὸ ἑξήκοντα ἐτῶν καὶ ἐπάνω, ἐὰν μὲν ἄρσεν ᾖ, ἔσται ἡ τιμὴ αὐτοῦ πεντεκαίδεκα δίδραχμα ἀργυρίου· ἐὰν δὲ θήλεια, δέκα δίδραχμα. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ἐὰν δὲ ταπεινὸς ᾖ τῇ τιμῇ, στήσεται ἐναντίον τοῦ ἱερέως· καὶ τιμήσεται αὐτὸν ὁ ἱερεύς· καθάπερ ἰσχύει ἡ χεὶρ τοῦ εὐξαμένου, τιμήσεται αὐτὸν ὁ ἱερεύς. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ἐὰν δὲ ἀπὸ τῶν κτηνῶν τῶν προσφερομένων ἀπʼ αὐτῶν δῶρον τῷ Κυρίῳ, ὃς ἂν δῷ ἀπὸ τούτων τῷ Κυρίῳ, ἔσται ἅγιον. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Οὐκ ἀλλάξει αὐτὸ καλὸν πονηρῷ, οὐδὲ πονηρὸν καλῷ· ἐὰν δὲ ἀλλάσσων ἀλλάξῃ αὐτὸ κτῆνος κτήνει, ἔσται αὐτὸ καὶ τὸ ἄλλαγμα ἅγια. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ἐὰν δὲ πᾶν κτῆνος ἀκάθαρτον, ἀφʼ ὧν οὐ προσφέρεται ἀπʼ αὐτῶν δῶρον τῷ Κυρίῳ, στήσει τὸ κτῆνος ἔναντι τοῦ ἱερέως, ");
INSERT INTO grcbrent_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","καὶ τιμήσεται αὐτὸ ὁ ἱερεὺς ἀναμέσον καλοῦ καὶ ἀναμέσον πονηροῦ· καὶ καθότι ἂν τιμήσηται αὐτὸ ὁ ἱερεὺς, οὕτω στήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ἐὰν δὲ λυτρούμενος λυτρώσηται αὐτὸ, προσθήσει τὸ ἐπίπεμπτον πρὸς τὴν τιμὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Καὶ ἄνθρωπος ὃς ἂν ἁγιάσῃ τὴν οἰκίαν αὐτοῦ ἁγίαν τῷ Κυρίῳ, καὶ τιμήσεται αὐτὴν ὁ ἱερεὺς ἀναμέσον καλῆς καὶ ἀναμέσον πονηρᾶς· ὡς ἂν τιμήσηται αὐτὴν ὁ ἱερεὺς, οὕτω σταθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ἐὰν δὲ ὁ ἁγιάσας αὐτὴν λυτρῶται τὴν οἰκίαν αὐτοῦ, προσθήσει ἐπʼ αὐτὸ τὸ ἐπίπεμπτον τοῦ ἀργυρίου τῆς τιμῆς, καὶ ἔσται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ἐὰν δὲ ἀπὸ τοῦ ἀγροῦ τῆς κατασχέσεως αὐτοῦ ἁγιάσῃ ἄνθρωπος τῷ Κυρίῳ, καὶ ἔσται ἡ τιμὴ κατὰ τὸν σπόρον αὐτοῦ, κόρου κριθῶν πεντήκοντα δίδραχμα ἀργυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ἐὰν δὲ ἀπὸ τοῦ ἐνιαυτοῦ τῆς ἀφέσεως ἁγιάσῃ τὸν ἀγρὸν αὐτοῦ, κατὰ τὴν τιμὴν αὐτοῦ στήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ἐὰν δὲ ἔσχατον μετὰ τὴν ἄφεσιν ἁγιάσῃ τὸν ἀγρὸν αὐτοῦ, προσλογιεῖται αὐτῷ ὁ ἱερεὺς τὸ ἀργύριον ἐπὶ τὰ ἔτη τὰ ἐπίλοιπα, ἕως εἰς τὸν ἐνιαυτὸν τῆς ἀφέσεως, καὶ ἀνθυφαιρεθήσεται ἀπὸ τῆς συντιμήσεως αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ἐὰν δὲ λυτρῶται τὸν ἀγρὸν ὁ ἁγιάσας αὐτὸν, προσθήσει τὸ ἐπίπεμπτον τοῦ ἀργυρίου πρὸς τὴν τιμὴν αὐτοῦ, καὶ ἔσται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ἐὰν δὲ μὴ λυτρῶται τὸν ἀγρὸν, καὶ ἀποδῶται τὸν ἀγρὸν ἀνθρώπῳ ἑτέρῳ, οὐκέτι μὴ λυτρώσηται αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ἀλλʼ ἔσται ὁ ἀγρὸς ἐξεληλυθυίας τῆς ἀφέσεως ἅγιος τῷ Κυρίῳ, ὥσπερ ἡ γῆ ἡ ἀφωρισμένη τῷ ἱερεῖ ἔσται κατάσχεσις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ἐὰν δὲ ἀπὸ τοῦ ἀγροῦ οὗ κέκτηται, ὃς οὐκ ἔστιν ἀπὸ τοῦ ἀγροῦ τῆς κατασχέσεως αὐτοῦ, ἁγιάσῃ τῷ Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","λογιεῖται πρὸς αὐτὸν ὁ ἱερεὺς τὸ τέλος τῆς τιμῆς ἐκ τοῦ ἐνιαυτοῦ τῆς ἀφέσεως, καὶ ἀποδώσει τὴν τιμὴν ἐν τῇ ἡμέρᾳ ἐκείνῃ ἁγίαν τῷ Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Καὶ ἐν τῷ ἐνιαυτῷ τῆς ἀφέσεως ἀποδοθήσεται ὁ ἀγρὸς τῷ ἀνθρώπῳ παρʼ οὗ κέκτηται αὐτὸν, οὗ ἦν ἡ κατάσχεσις τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Καὶ πᾶσα τιμὴ ἔσται σταθμίοις ἁγίοις· εἴκοσι ὀβολοὶ ἔσται τὸ δίδραχμον. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Καὶ πᾶν πρωτότοκον ὃ ἐὰν γένηται ἐν τοῖς κτήνεσί σου, ἔσται τῷ Κυρίῳ, καὶ οὐ καθαγιάσει αὐτὸ οὐδείς· ἐάν τε μόσχον, ἐάν τε πρόβατον, τῷ Κυρίῳ ἐστίν. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ἐὰν δὲ τῶν τετραπόδων τῶν ἀκαθάρτων ἀλλάξῃ κατὰ τὴν τιμὴν αὐτοῦ, καὶ προσθήσει τὸ ἐπίπεμπτον πρὸς αὐτὸ, καὶ ἔσται αὐτῷ· ἐὰν δὲ μὴ λυτρῶται, πραθήσεται κατὰ τὸ τίμημα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Πᾶν δὲ ἀνάθεμα, ὃ ἂν ἀναθῇ ἄνθρωπος τῷ Κυρίῳ ἀπὸ πάντων, ὅσα αὐτῷ ἐστιν, ἀπὸ ἀνθρώπου ἕως κτήνους, καὶ ἀπὸ ἀγροῦ κατασχέσεως αὐτοῦ, οὐκ ἀποδώσεται οὐδὲ λυτρώσεται· πᾶν ἀνάθεμα ἅγιον ἁγίων ἔσται τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Καὶ πᾶν ὃ ἐὰν ἀνατεθῇ ἀπὸ τῶν ἀνθρώπων, οὐ λυτρωθήσεται, ἀλλὰ θανάτῳ θανατωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Πᾶσα δεκάτη τῆς γῆς, ἀπὸ τοῦ σπέρματος τῆς γῆς, καὶ τοῦ καρποῦ τοῦ ξυλίνου, τῷ. Κυρίῳ ἐστίν, ἅγιον τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ἐὰν δὲ λυτρῶται λύτρῳ ἄνθρωπος τὴν δεκάτην αὐτοῦ, τὸ ἐπίπεμπτον προσθήσει πρὸς αὐτὸν, καὶ ἔσται αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Καὶ πᾶσα δεκάτη βοῶν, καὶ προβάτων, καὶ πᾶν ὃ ἂν ἔλθῃ ἐν τῷ ἀριθμῷ ὑπὸ τὴν ῥάβδον, τὸ δέκατον ἔσται ἅγιον τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Οὐκ ἀλλάξεις καλὸν πονηρῷ, οὐδὲ πονηρὸν καλῷ· ἐὰν δὲ ἀλλάσσων ἀλλάξῃς αὐτό, καὶ τὸ ἄλλαγμα αὐτοῦ ἔσται ἅγιον, οὐ λυτρωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Αὗταί εἰσιν αἱ ἐντολαὶ ἃς ἐνετείλατο Κύριος τῷ Μωυσῇ πρὸς τοὺς υἱοὺς Ἰσραὴλ ἐν τῷ ὄρει Σινᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ΚΑΙ ἐλάλησε Κύριος πρὸς Μωυσῆν ἐν τῇ ἐρήμῳ τῇ Σινᾷ, ἐν τῇ σκηνῇ τοῦ μαρτυρίου, ἐν μιᾷ τοῦ μηνὸς τοῦ δευτέρου, ἔτους δευτέρου ἐξελθόντων αὐτῶν ἐκ γῆς Αἰγύπτου, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","λάβετε ἀρχὴν πάσης συναγωγῆς Ἰσραὴλ κατὰ συγγενείας, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ἐξ ὀνόματος αὐτῶν, κατὰ κεφαλὴν αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","πᾶς ἄρσην ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν δυνάμει Ἰσραήλ, ἐπισκέψασθε αὐτοὺς σὺν δυνάμει αὐτῶν· σὺ καὶ Ἀαρὼν ἐπισκέψασθε αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Καὶ μεθʼ ὑμῶν ἔσονται ἕκαστος κατὰ φυλὴν ἑκάστου ἀρχόντων, κατʼ οἴκους πατριῶν ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Καὶ ταῦτα τὰ ὀνόματα τῶν ἀνδρῶν, οἵτινες παραστήσονται μεθʼ ὑμῶν· τῶν Ῥουβὴν, Ἐλισοὺρ υἱὸς Σεδιούρ· ");
INSERT INTO grcbrent_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Τῶν Συμεὼν, Σαλαμιὴλ υἱὸς Σουρισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Τῶν Ἰούδα, Ναασσὼν υἱὸς Ἀμιναδάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Τῶν Ἰσσάχαρ, Ναθαναὴλ υἱὸς Σωγάρ· ");
INSERT INTO grcbrent_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Τῶν Ζαβουλὼν, Ἐλιὰβ υἱὸς Χαιλών· Τῶν υἱῶν Ἰωσὴφ τῶν Ἐφραὶμ, Ἐλισαμὰ υἱὸς Ἐμιούδ· ");
INSERT INTO grcbrent_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","τῶν Μανασσῆ, Γαμαλιὴλ υἱὸς Φαδασούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Τῶν Βενιαμὶν, Ἀβιδὰν υἱὸς Γαδεωνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Τῶν Δὰν, Ἀχιέζερ υἱὸς Ἀμισαδαΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Τῶν Ἀσὴρ, Φαγαϊὴλ, υἱὸς Ἐχράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Τῶν Γὰδ, Ἐλισὰφ υἱὸς Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Τῶν Νεφθαλὶ, Ἀχιρὲ υἱὸς Αἰνάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Οὗτοι ἐπίκλητοι τῆς συναγωγῆς, ἄρχοντες τῶν φυλῶν κατὰ πατριὰς αὐτῶν, χιλίαρχοι Ἰσραήλ εἰσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Καὶ ἔλαβε Μωυσῆς καὶ Ἀαρὼν τοὺς ἄνδρας τούτους τοὺς ἀνακληθέντας ἐξ ὀνόματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Καὶ πᾶσαν τὴν συναγωγὴν συνήγαγον ἐν μιᾷ τοῦ μηνὸς τοῦ δευτέρου ἔτους· καὶ ἐπηξονοῦσαν κατὰ γενέσεις αὐτῶν, κατὰ πατριὰς αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶν ἀρσενικὸν κατὰ κεφαλὴν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ· καὶ ἐπεσκέπησαν ἐν τῇ ἐρήμῳ τοῦ Σινά. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Καὶ ἐγένοντο οἱ υἱοὶ Ῥουβὴν πρωτοτόκου Ἰσραὴλ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Ῥουβὴν, ἓξ καὶ τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Τοῖς υἱοῖς Συμεὼν κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Συμεὼν, ἐννέα καὶ πεντήκοντα χιλιάδες καὶ τριακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Τοῖς υἱοῖς Ἰούδα κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Ἰούδα, τέσσαρες καὶ ἑβδομήκοντα χιλιάδες καὶ ἑξακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Τοῖς υἱοῖς Ἰσσάχαρ κατὰ συγγενίας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Ἰσσάχαρ, τέσσαρες καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Τοῖς υἱοῖς Ζαβουλὼν κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Ζαβουλὼν, ἑπτὰ καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Τοῖς υἱοῖς Ἰωσὴφ υἱοῖς Ἐφραὶμ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ἡ ἐπίσκέψις αὐτῶν ἐκ τῆς φυλῆς Ἐφραὶμ, τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Τοῖς υἱοῖς Μανασσὴ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ, ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Μανασσὴ, δύο καὶ τριάκοντα χιλιάδες καὶ διακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Τοῖς υἱοῖς Βενιαμὶν κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Βενιαμὶν, πέντε καὶ τριάκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Τοῖς υἱοῖς Γὰδ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ἡ ἐπίσκεψις αὐτῶν· ἐκ τῆς φυλῆς Γὰδ, πέντε καὶ τεσσαράκοντα χιλιάδες καὶ ἑξακόσιοι καὶ πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Τοῖς υἱοῖς Δὰν κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Δὰν, δύο καὶ ἑξήκοντα χιλιάδες καὶ ἑπτακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Τοῖς υἱοῖς Ἀσὴρ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Ἀσὴρ, μία καὶ τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Τοῖς υἱοῖς Νεφθαλὶ κατὰ συγγενείας αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, κατὰ ἀριθμὸν ὀνομάτων αὐτῶν, κατὰ κεφαλὴν αὐτῶν, πάντα ἀρσενικὰ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος ἐν τῇ δυνάμει, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ἡ ἐπίσκεψις αὐτῶν ἐκ τῆς φυλῆς Νεφθαλὶ, τρεῖς καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Αὕτη ἡ ἐπίσκεψις, ἣν ἐπεσκέψαντο Μωυσῆς καὶ Ἀαρὼν καὶ οἱ ἄρχοντες Ἰσραὴλ δώδεκα ἄνδρες· ἀνὴρ εἷς κατὰ φυλὴν μίαν, κατὰ φυλὴν οἴκων πατριᾶς ἦσαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Καὶ ἐγένετο πᾶσα ἡ ἐπίσκεψις υἱῶν Ἰσραὴλ σὺν δυνάμει αὐτῶν ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, πᾶς ὁ ἐκπορευόμενος παρατάξασθαι ἐν Ἰσραὴλ ");
INSERT INTO grcbrent_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ἑξακόσιαι χιλιάδες καὶ τρισχίλιοι καὶ πεντακόσιοι καὶ πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Οἱ δὲ Λευῖται ἐκ τῆς φυλῆς πατριᾶς αὐτῶν οὐκ ἐπεσκέπησαν ἐν τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","ὅρα, τὴν φυλὴν Λευὶ οὐ συνεπισκέψῃ, καὶ τὸν ἀριθμὸν αὐτῶν οὐ λήμῃ, ἐν μέσῳ υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Καὶ σὺ ἐπίστησον τοὺς Λευίτας ἐπὶ τὴν σκηνὴν τοῦ μαρτυρίου, καὶ ἐπὶ πάντα τὰ σκεύη αὐτῆς, καὶ ἐπὶ πάντα ὅσα ἐστὶν ἐν αὐτῇ· ἀροῦσιν αὐτοὶ τὴν σκηνὴν, καὶ πάντα τὰ σκεύη αὐτῆς· καὶ αὐτοὶ λειτουργήσουσιν ἐν αὐτῇ, καὶ κύκλῳ τῆς σκηνῆς παρεμβαλοῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Καὶ ἐν τῷ ἐξαίρειν τὴν σκηνὴν, καθελοῦσιν αὐτὴν οἱ Λευῖται, καὶ ἐν τῷ παρεμβάλλειν τὴν σκηνὴν, ἀναστήσουσι· καὶ ὁ ἀλλογενῆς ὁ προσπορευόμενος ἀποθανέτω. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Καὶ παρεμβαλοῦσιν οἱ υἱοὶ Ἰσραὴλ, ἀνὴρ ἐν τῇ ἑαυτοῦ τάξει, καὶ ἀνὴρ κατὰ τὴν ἑαυτοῦ ἡγεμονίαν, σὺν δυνάμει αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Οἱ δὲ Λευῖται παρεμβαλλέτωσαν ἐναντίοι κύκλῳ τῆς σκηνῆς τοῦ μαρτυρίου, καὶ οὐκ ἔσται ἁμάρτημα ἐν υἱοῖς Ἰσραήλ. καὶ φυλάξουσιν οἱ Λευῖται αὐτοὶ τὴν φυλακὴν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Καὶ ἐποίησαν οἱ υἱοὶ Ἰσραὴλ, κατὰ πάντα ἃ ἐνετείλατο Κύριος τῷ Μωυσῇ καὶ Ἀαρὼν, οὕτως ἐποίησαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ἄνθρωπος ἐχόμενος αὐτοῦ κατὰ τάγμα, κατὰ σημαίας, κατʼ οἴκους πατριῶν αὐτῶν, παρεμβαλλέτωσαν οἱ υἱοὶ Ἰσραήλ ἐναντίοι· κύκλῳ τῆς σκηνῆς τοῦ μαρτυρίου παρεμβαλοῦσιν οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Καὶ οἱ παρεμβάλλοντες πρῶτοι κατὰ ἀνατολὰς, τάγμα παρεμβολῆς Ἰούδα σὺν δυνάμει αὐτῶν, καὶ ὁ ἄρχων τῶν υἱῶν Ἰούδα, Ναασσὼν υἱὸς Ἀμιναδάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, τέσσαρες καὶ ἑβδομήκοντα χιλιάδες καὶ ἑξακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι φυλῆς Ἰσσάχαρ, καὶ ὁ ἄρχων τῶν υἱῶν Ἰσσάχαρ, Ναθαναὴλ υἱὸς Σωγάρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, τέσσαρες καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι φυλῆς Ζαβουλὼν, καὶ ὁ ἄρχων τῶν υἱῶν Ζαβουλὼν, Ἑλιὰβ υἱὸς Χαιλών. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, ἑπτὰ καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Πάντες οἱ ἐπεσκεμμένοι ἐκ τῆς παρεμβολῆς Ἰούδα, ἑκατὸν ὀγδοήκοντα χιλιάδες καὶ ἑξακισχίλιοι καὶ τετρακόσιοι, σὺν δυνάμει αὐτῶν πρῶτον ἐξαροῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Τάγματα παρεμβολῆς Ῥουβὴν, πρὸς λίβα δύναμις αὐτῶν, καὶ ὁ ἄρχων τῶν υἱῶν ʼΡουβὴν, Ἐλισοὺρ υἱὸς Σεδιούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, ἓξ καὶ τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι αὐτοῦ φυλῆς Συμεὼν, καὶ ὁ ἄρχων τῶν υἱῶν Συμεὼν, Σαλαμιὴλ υἱὸς Σουρισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, ἐννέα καὶ πεντήκοντα χιλιάδες καὶ τριακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Καὶ οἱ παρεμβάλοντες ἐχόμενοι αὐτοῦ φυλὴ Γὰδ, καὶ ὁ ἄρχων τῶν υἱῶν Γὰδ, Ἑλισὰφ υἱὸς Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, πέντε καὶ τεσσαράκοντα χιλιάδες καὶ ἑξακόσιοι καὶ πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Πάντες οἱ ἐπεσκεμμένοι τῆς παρεμβολῆς Ῥουβὴν, ἑκατὸν πεντήκοντα μία χιλιάδες καὶ τετρακόσιοι καὶ πεντήκοντα, σὺν δυνάμει αὐτῶν δεύτεροι ἐξαροῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Καὶ ἀρθήσεται ἡ σκηνὴ τοῦ μαρτυρίου, καὶ ἡ παρεμβολὴ τῶν Λευιτῶν μέσον τῶν παρεμβολῶν· ὡς καὶ παρεμβαλοῦσιν, οὕτω καὶ ἐξαροῦσιν ἕκαστος ἐχόμενος καθʼ ἡγεμονίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Τάγμα παρεμβολῆς Ἐφραὶμ παρὰ θάλασσαν σὺν δυνάμει αὐτῶν, καὶ ὁ ἄρχων τῶν υἱῶν Ἐφραὶμ, Ἐλισαμὰ υἱὸς Ἐμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι φυλῆς Μανασσῆ, καὶ ὁ ἄρχων τῶν υἱῶν Μανασσῆ, Γαμαλιὴλ υἱὸς Φαδασσούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, δύο καὶ τριάκοντα χιλιάδες καὶ διακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι φυλῆς Βενιαμὶν, καὶ ὁ ἄρχων τῶν υἱῶν Βενιαμὶν, Ἀβιδὰν υἱὸς Γαδεωνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, πέντε καὶ τριάκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Πάντες οἱ ἐπεσκεμμένοι τῆς παρεμβολῆς Ἐφραὶμ, ἑκατὸν χιλιάδες καὶ ὀκτακισχίλιοι καὶ ἑκατὸν· σὺν δυνάμει αὐτῶν τρίτοι ἐξαροῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Τάγμα παρεμβολῆς Δὰν πρὸς βοῤῥᾶν σὺν δυνάμει αὐτῶν, καὶ ὁ ἄρχων τῶν υἱῶν Δὰν, Ἀχιέζερ υἱὸς Ἀμισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, δύο καὶ ἑξήκοντα χιλιάδες καὶ ἑπτακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι αὐτοῦ φυλὴ Ἀσὴρ, καὶ ὁ ἄρχων τῶν υἱῶν Ἀσὴρ, Φαγεὴλ υἱὸς Ἐχράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, μία καὶ τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Καὶ οἱ παρεμβάλλοντες ἐχόμενοι φυλῆς Νεφθαλί, καὶ ὁ ἄρχων τῶν υἱῶν Νεφθαλὶ, Ἀχιρὲ υἱὸς Αἰνάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Δύναμις αὐτοῦ οἱ ἐπεσκεμμένοι, τρεῖς καὶ πεντήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Πάντες οἱ ἐπεσκεμμένοι τῆς παρεμβολῆς Δὰν, ἑκατὸν καὶ πεντηκονταεπτὰ χιλιάδες καὶ ἑξακόσιοι· ἔσχατοι ἐξαροῦσι κατὰ τάγμα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Αὕτη ἡ ἐπίσκεψις τῶν υἱῶν Ἰσραὴλ κατʼ οἴκους πατριῶν αὐτῶν· πᾶσα ἡ ἐπίσκεψις τῶν παρεμβολῶν σὺν ταῖς δυνάμεσιν αὐτῶν, ἑξακόσιαι χιλιάδες καὶ τρισχίλιοι πεντακόσιοι πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Οἱ δὲ Λευῖται οὐ συνεπεσκέπησαν ἐν αὐτοῖς, καθὰ ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Καὶ ἐποίησαν οἱ υἱοὶ Ἰσραὴλ πάντα ὅσα συνέταξε Κύριος τῷ Μωυσῇ· οὕτω παρενέβαλον κατὰ τάγμα αὐτῶν, καὶ οὕτως ἐξῇρον ἕκαστος ἐχόμενοι κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Καὶ αὗται αἱ γενέσεις Ἀαρὼν καὶ Μωυσῆ, ἐν ᾗ ἡμέρᾳ ἐλάλησε Κύριος τῷ Μωυσῇ ἐν ὄρει Σινᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Καὶ ταῦτα τὰ ὀνόματα τῶν υἱῶν Ἀαρών· πρωτότοκος Ναδάβ, καὶ Ἀβιοὺδ, Ἐλεάζαρ, καὶ Ἰθάμαρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ταῦτα τὰ ὀνόματα τῶν υἱῶν Ἀαρὼν, οἱ ἱερεῖς οἱ ἠλειμμένοι, οὓς ἐτελείωσαν τὰς χεῖρας αὐτῶν ἱερατεύειν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Καὶ ἐτελεύτησε Ναδὰβ καὶ Ἀβιοὺδ ἔναντι Κυρίου, προσφερόντων αὐτῶν πῦρ ἀλλότριον ἔναντι Κυρίου, ἐν τῇ ἐρήμῳ Σινᾷ, καὶ παιδία οὐκ ἦν αὐτοῖς· καὶ ἱεράτευσεν Ἐλεάζαρ καὶ Ἰθάμαρ μετὰ Ἀαρὼν τοῦ πατρὸς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","λάβε τὴν φυλὴν Λευὶ, καὶ στήσεις αὐτοὺς ἐναντίον Ἀαρὼν τοῦ ἱερέως, καὶ λειτουργήσουσιν αὐτῷ, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","καὶ φυλάξουσι τὰς φυλακὰς αὐτοῦ, καὶ τὰς φυλακὰς τῶν υἱῶν Ἰσραὴλ ἔναντι τῆς σκηνῆς τοῦ μαρτυρίου, ἐργάζεσθαι τὰ ἔργα τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Καὶ φυλάξουσι πάντα τὰ σκεύη τῆς σκηνῆς τοῦ μαρτυρίου, καὶ τὰς φυλακὰς τῶν υἱῶν Ἰσραὴλ κατὰ πάντα τὰ ἔργα τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Καὶ δώσεις τοὺς Λευίτας Ἀαρὼν, καὶ τοῖς υἱοῖς αὐτοῦ τοῖς ἱερεῦσι· δεδομένοι δόμα οὗτοί μοι εἰσὶν ἀπὸ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Καὶ Ἀαρὼν καὶ τοὺς υἱοὺς αὐτοῦ καταστήσεις ἐπὶ τῆς σκηνῆς τοῦ μαρτυρίου· καὶ φυλάξουσι τὴν ἱερατείαν αὐτῶν, καὶ πάντα τὰ κατὰ τὸν βωμὸν, καὶ ἔσω τοῦ καταπετάσματος· καὶ ὁ ἀλλογενὴς ὁ ἁπτόμενος ἀποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","καὶ ἰδοὺ ἐγὼ εἴληφα τοὺς Λευίτας ἐκ μέσου τῶν υἱῶν Ἰσραὴλ ἀντὶ παντὸς πρωτοτόκου διανοίγοντος μήτραν παρὰ τῶν υἱῶν Ἰσραήλ· λύτρα αὐτῶν ἔσονται, καὶ ἔσονται ἐμοὶ οἱ Λευῖται. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ἐμοὶ γὰρ πᾶν προτότοκον· ἐν ᾗ ἡμέρᾳ ἐπάταξα πᾶν πρωτότοκον ἐν γῇ Αἰγύπτου, ἡγίασα ἐμοὶ πᾶν πρωτότοκον ἐν Ἰσραήλ· ἀπὸ ἀνθρώπου ἕως κτήνους ἐμοὶ ἔσονται· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν ἐν τῇ ἐρήμῳ Σινᾷ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ἐπίσκεψαι τοὺς υἱοὺς Λευὶ κατʼ οἴκους πατριῶν αὐτῶν, κατὰ δήμους αὐτῶν· πᾶν ἀρσενικὸν ἀπὸ μηνιαίου καὶ ἐπάνω, ἐπισκέψασθε αὐοτύς. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Καὶ ἐπεσκέψαντο αὐτοὺς Μωυσῆς καὶ Ἀαρὼν διὰ φωνῆς Κυρίου, ὃν τρόπον συνέταξεν αὐτοῖς Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Καὶ ἦσαν οὗτοι οἱ υἱοὶ Λευὶ ἐξ ὀνομάτων αὐτῶν· Γεδσὼν, Καὰθ, καὶ Μεραρί. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Καὶ ταῦτα τὰ ὀνόματα τῶν υἱῶν Γεδσὼν κατὰ δήμους αὐτῶν· Λοβενὶ καὶ Σεμεΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Καὶ υἱοὶ Καὰθ κατὰ δήμους αὐτῶν· Ἀμρὰμ καὶ Ἰσσαὰρ, Χεβρὼν καὶ Ὀζιήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Καὶ υἱοὶ Μεραρὶ κατὰ δήμους αὐτῶν· Μοολὶ καὶ Μουσί· οὗτοί εἰσι δῆμοι τῶν Λευιτῶν κατʼ οἴκους πατριῶν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Τῷ Γεδσὼν δῆμος τοῦ Λοβενὶ, καὶ δῆμος τοῦ Σεμεΐ· οὗτοι δῆμοι τοῦ Γεδσών. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ἡ ἐπίσκεψις αὐτῶν κατὰ ἀριθμὸν παντὸς ἀρσενικοῦ ἀπὸ μηνιαίου καὶ ἐπάνω, ἡ ἐπίσκεψις αὐτῶν, ἑπτακισχίλιοι καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Καὶ οἱ υἱοὶ Γεδσὼν ὀπίσω τῆς σκηνῆς παρεμβαλοῦσι παρὰ θάλασσαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Καὶ ὁ ἄρχων οἴκου πατριᾶς τοῦ δήμου τοῦ Γεδσὼν, Ἑλισὰφ υἱὸς Δαήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Καὶ ἡ φυλακὴ υἱῶν Γεδσὼν ἐν τῇ σκηνῇ τοῦ μαρτυρίου, ἡ σκηνὴ καὶ τὸ κάλυμμα, καὶ τὸ κατακάλυμμα τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","καὶ τὰ ἱστία τῆς αὐλῆς, καὶ τὸ καταπέτασμα τῆς πύλης τῆς αὐλῆς τῆς οὔσης ἐπὶ τῆς σκηνῆς, καὶ τὰ κατάλοιπα πάντων τῶν ἔργων αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Τῷ Καὰθ δῆμος ὁ Ἀμρὰμ εἷς, καὶ δῆμος ὁ Ἰσσαὰρ εἷς, καὶ δῆμος ὁ Χεβρων εἷς, καὶ δῆμος ὁ Ὀζιὴλ εἷς· οὗτοί εἰσιν οἱ δῆμοι τοῦ Καὰθ, κατὰ ἀριθμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Πᾶν ἀρσενικὸν ἀπὸ μηνιαίου καὶ ἐπάνω, ὀκτακισχίλιοι καὶ ἑξακόσιοι, φυλάσσοντες τὰς φυλακὰς τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Οἱ δῆμοι τῶν υἱῶν Καὰθ παρεμβαλοῦσιν ἐκ πλαγίων τῆς σκηνῆς κατὰ Λίβα. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Καὶ ὁ ἄρχων οἴκου πατριῶν τῶν δήμων τοῦ Καὰθ, Ἑλισαφὰν υἱὸς Ὀζιήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Καὶ ἡ φυλακὴ αὐτῶν ἡ κιβωτὸς, καὶ ἡ τράπεζα, καὶ ἡ λυχνία, καὶ τὰ θυσιαστήρια, καὶ τὰ σκεύη τοῦ ἁγίου ὅσα λειτουργοῦσιν ἐν αὐτοῖς, καὶ τὸ κατακάλυμμα, καὶ πάντα τὰ ἔργα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Καὶ ὁ ἄρχων ἐπὶ τῶν ἀρχόντων τῶν Λευιτῶν, Ἐλεάζαρ ὁ υἱὸς Ἀαρὼν τοῦ ἱερέως, καθεσταμένος φυλάσσειν τὰς φυλακὰς τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Τῷ Μεραρὶ δῆμος ὁ Μοολὶ, καὶ δῆμος ὁ Μουσί· οὗτοί εἰσι δῆμοι τοῦ Μεραρί. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ἡ ἐπίσκεψις αὐτῶν κατὰ ἀριθμὸν, πᾶν ἀρσενικὸν ἀπὸ μηνιαίου καὶ ἐπάνω, ἑξακισχίλιοι καὶ πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Καὶ ὁ ἄρχων οἴκου πατριῶν τοῦ δήμου τοῦ Μεραρὶ, Σουριὴλ υἱὸς Ἀβιχαίλ· ἐκ πλαγίων τῆς σκηνῆς παρεμβαλοῦσι πρὸς βοῤῥᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ἡ ἐπίσκεψις τῆς φυλακῆς υἱῶν Μεραρὶ, τὰς κεφαλίδας τῆς σκηνῆς, καὶ τοὺς μοχλοὺς αὐτῆς, καὶ τοὺς στύλους αὐτῆς, καὶ τὰς βάσεις αὐτῆς, καὶ πάντα τὰ σκεύη αὐτῶν, καὶ τὰ ἔργα αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","καὶ τοὺς στύλους τῆς αὐλῆς κύκλῳ, καὶ τὰς βάσεις αὐτῶν, καὶ τοὺς πασσάλους, καὶ τοὺς κάλους αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Οἱ παρεμβάλλοντες κατὰ πρόσωπον τῆς σκηνῆς τοῦ μαρτυρίου ἀπὸ ἀνατολῆς, Μωυσῆς καὶ Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ, φυλάσσοντες τὰς φυλακὰς τοῦ ἁγίου εἰς τὰς φυλακὰς τῶν υἱῶν Ἰηραήλ· καὶ ὁ ἀλλογενὴς ὁ ἁπτόμενος, ἀποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Πᾶσα ἡ ἐπίσκεψις τῶν Λευιτῶν, οὓς ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν διὰ φωνῆς Κυρίου κατὰ δήμους αὐτῶν, πᾶν ἀρσενικὸν ἀπὸ μηνιαίου καὶ ἐπάνω, δύο καὶ εἴκοσι χιλιάδες. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ἐπίσκεψαι πᾶν πρωτότοκον ἄρσεν τῶν υἱῶν Ἰσραὴλ ἀπὸ μηνιαίου καὶ ἐπάνω· καὶ λάβετε τὸν ἀριθμὸν ἐξ ὀνόματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Καὶ λήψῃ τοὺς Λευίτας ἐμοί, ἐγὼ Κύριος, ἀντὶ πάντων τῶν πρωτοτόκων τῶν υἱῶν Ἰσραήλ, καὶ τὰ κτήνη τῶν Λευιτῶν ἀντὶ πάντων τῶν πρωτοτόκων ἐν τοῖς κτήνεσι τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Καὶ ἐπεσκέψατο Μωυσῆς ὃν τρόπον ἐνετείλατο Κύριος πᾶν πρωτότοκον ἐν τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Καὶ ἐγένοντο πάντα τὰ πρωτότοκα τὰ ἀρσενικὰ κατὰ ἀριθμὸν ἐξ ὀνόματος ἀπὸ μηνιαίου καὶ ἐπάνω ἐκ τῆς ἐπισκέψεως αὐτῶν, δύο καὶ εἴκοσι χιλιάδες καὶ τρεῖς καὶ ἑβδομήκοντα καὶ διακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","λάβε τοὺς Λευίτας ἀντὶ πάντων τῶν πρωτοτόκων υἱῶν Ἰσραὴλ, καὶ τὰ κτήνη τῶν Λευιτῶν ἀντὶ τῶν κτηνῶν αὐτῶν, καὶ ἔσονται ἐμοὶ οἱ Λευῖται· ἐγὼ Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Καὶ τὰ λύτρα τριῶν καὶ ἑβδομήκοντα καὶ διακοσίων οἱ πλεονάζοντες παρὰ τοὺς Λευίτας ἀπὸ τῶν πρωτοτόκων τῶν υἱῶν Ἰσραήλ· ");
INSERT INTO grcbrent_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Καὶ λήψῃ πέντε σίκλους κατὰ κεφαλὴν, κατὰ τὸ δίδραχμον τὸ ἅγιον λήψῃ, εἴκοσι ὀβολοὺς τοῦ σίκλου. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Καὶ δώσεις τὸ ἀργύριον Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, λύτρα τῶν πλεοναζόντων ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Καὶ ἔλαβε Μωυσῆς τὸ ἀργύριον τὰ λύτρα τῶν πλεοναζόντων εἰς τὴν ἐκλύτρωσιν τῶν Λευιτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Παρὰ τῶν πρωτοτόκων τῶν υἱῶν Ἰσραὴλ ἔλαβε τὸ ἀργύριον, χιλίους τριακοσίους ἑξηκονταπέντε σίκλους, κατὰ τὸν σίκλον τὸν ἅγιον. ");
INSERT INTO grcbrent_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Καὶ ἔδωκε Μωυσῆς τὰ λύτρα τῶν πλεοναζόντων Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, διὰ φωνῆς Κυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγεν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","λάβε τὸ κεφάλαιον τῶν υἱῶν Καὰθ ἐκ μέσου υἱῶν Λευὶ, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ἀπὸ εἴκοσι καὶ πέντε ἐτῶν καὶ ἐπάνω ἕως πεντήκοντα ἐτῶν, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν, ποιῆσαι πάντα τὰ ἔργα ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Καὶ ταῦτα τὰ ἔργα τῶν υἱῶν Καὰθ ἐν τῇ σκηνῇ τοῦ μαρτυρίου· ἅγιον τῶν ἁγίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Καὶ εἰσελεύσεται Ἀαρὼν καὶ υἱοὶ αὐτοῦ, ὅταν ἐξαίρῃ ἡ παρεμβολὴ, καὶ καθελοῦσι τὸ καταπέτασμα τὸ συσκιάζον, καὶ κατακαλύψουσιν ἐν αὐτῷ τὴν κιβωτὸν τοῦ μαρτυρίου, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","καὶ ἐπιθήσουσιν ἐπʼ αὐτὸ κατακάλυμμα δέρμα ὑακίνθινον, καὶ ἐπιβαλοῦσιν ἐπʼ αὐτὴν ἱμάτιον ὅλον ὑακίνθινον ἄνωθεν, καὶ διεμβαλοῦσι τοὺς ἀναφορεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Καὶ ἐπί τὴν τράπεζαν τὴν προκειμένην ἐπιβαλοῦσιν ἐπʼ αὐτὴν ἱμάτιον ὁλοπόρφυρον, καὶ τὰ τρυβλία, καὶ τὰς θυΐσκας, καὶ τοὺς κυάθους, καὶ τὰ σπονδεῖα ἐν οἷς σπένδει, καὶ οἱ ἄρτοι οἳ διαπαντὸς ἐπʼ αὐτῆς ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Καὶ ἐπιβαλοῦσιν ἐπʼ αὐτὴν ἱμάτιον κόκκινον, καὶ καλύψουσιν αὐτὴν καλύμματι δερματίνῳ ὑακινθίνῳ, καὶ διεμβαλοῦσι διʼ αὐτῆς τοὺς ἀναφορεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Καὶ λήψονται ἱμάτιον ὑακίνθινον, καὶ καλύψουσι τὴν λυχνίαν τὴν φωτίζουσαν, καὶ τοὺς λύχνους αὐτῆς, καὶ τὰς λαβίδας αὐτῆς, καὶ τὰς ἐπαρυστρίδας αὐτῆς, καὶ πάντα τὰ ἀγγεῖα τοῦ ἐλαίου οἷς λειτουργοῦσιν ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Καὶ ἐμβαλοῦσιν αὐτὴν, καὶ πάντα τὰ σκεύη αὐτῆς, εἰς κάλυμμα δερμάτινον ὑακίνθινον, καὶ ἐπιθήσουσιν αὐτὴν ἐπʼ ἀναφορέων. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Καὶ ἐπὶ τὸ θυσιαστήριον τὸ χρυσοῦν ἐπικαλύψουσιν ἱμάτιον ὑακίνθινον, καὶ καλύψουσιν αὐτὸ καλύμματι δερματίνῳ ὑακινθίνῳ, καὶ διεμβαλοῦσι τοὺς ἀναφορεῖς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","καὶ λήψονται πάντα τὰ σκεύη τὰ λειτουργικὰ ὅσα λειτουργοῦσιν ἐν αὐτοῖς ἐν τοῖς ἁγίοις· καὶ ἐμβαλοῦσιν εἰς ἱμάτιον ὑακίνθινον, καὶ καλύψουσιν αὐτὰ καλύμματι δερματίνῳ ὑακινθίνῳ, καὶ ἐπιθήσουσιν ἐπὶ ἀναφορεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Καὶ τὸν καλυπτῆρα ἐπιθήσει ἐπὶ τὸ θυσιαστήριον, καὶ ἐπικαλύψουσιν ἐπʼ αὐτὸ ἱμάτιον ὁλοπόρφυρον. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Καὶ ἐπιθήσουσιν ἐπʼ αὐτὸ πάντα τὰ σκεύη ὅσοις λειτουργοῦσιν ἐπʼ αὐτῷ ἐν αὐτοῖς, καὶ τὰ πυρεῖα, καὶ τὰς κρεάγρας, καὶ τὰς φιάλας, καὶ τὸν καλυπτῆρα, καὶ πάντα τὰ σκεύη τοῦ θυσιαστηρίου· καὶ ἐπιβαλοῦσιν ἐπʼ αὐτὸ κάλυμμα δερμάτινον ὑακίνθινον, καὶ διεμβαλοῦσι τοὺς ἀναφορεῖς αὐτοῦ· καὶ λήψονται ἱμάτιον πορφυροῦν, καὶ συγκαλύψουσι τὸν λουτῆρα καὶ τὴν βάσιν αὐτοῦ, καὶ ἐμβαλοῦσιν αὐτὸ εἰς κάλυμμα δερμάτινον ὑακίνθινον, καὶ ἐπιθήσουσιν ἐπὶ ἀναφορεῖς, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","καὶ συντελέσουσιν Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ, καλύπτοντες τὰ ἅγια, καὶ πάντα τὰ σκεύη τὰ ἅγια, ἐν τῷ ἐξαίρειν τὴν παρεμβολήν· καὶ μετὰ ταῦτα εἰσελεύσονται υἱοὶ Καὰθ αἴρειν, καὶ οὐχ ἅψονται τῶν ἁγίων, ἵνα μὴ ἀποθάνωσι· ταῦτα ἀροῦσιν οἱ υἱοὶ Καὰθ ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ἐπίσκοπος Ἐλεάζαρ υἱὸς Ἀαρὼν τοῦ ἱερέως, τὸ ἔλαιον τοῦ φωτὸς, καὶ τὸ θυμίαμα τῆς συνθέσεως, καὶ ἡ θυσία ἡ καθʼ ἡμέραν, καὶ τὸ ἔλαιον τῆς χρίσεως, ἡ ἐπισκοπὴ ὅλης τῆς σκηνῆς, καὶ ὅσα ἐστὶν ἐν αὐτῇ ἐν τῷ ἁγίῳ, ἐν πᾶσι τοῖς ἔργοις. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","μὴ ὀλοθρεύσητε τῆς φυλῆς τὸν δῆμον τὸν Καὰθ ἐκ μέσου τῶν Λευιτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Τοῦτο ποιήσατε αὐτοῖς, καὶ ζήσονται καὶ οὐ μὴ ἀποθάνωσι, προσπορευομένων αὐτῶν πρὸς τὰ ἅγια τῶν ἁγίων· Ἀαρὼν καὶ οἱ υἱοὶ αὐτοῦ προσπορεύεσθωσαν, καὶ καταστήσουσιν αὐτοὺς ἕκαστον κατὰ τὴν ἀναφορὰν αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","καὶ οὐ μὴ εἰσέλθωσιν ἰδεῖν ἐξάπινα τὰ ἅγια, καὶ ἀποθανοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","λάβε τὴν ἀρχὴν τῶν υἱῶν Γεδσὼν, καὶ τούτους κατʼ οἴκους πατριῶν αὐτῶν, κατὰ δήμους αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς ἐπίσκεψαι αὐτοὺς, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν, ποιεῖν τὰ ἔργα αὐτοῦ ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Αὕτη ἡ λειτουργία τοῦ δήμου τοῦ Γεδσὼν, λειτουργεῖν καὶ αἴρειν. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Καὶ ἀρεῖ τὰς δέῤῥεις τῆς σκηνῆς, καὶ τὴν σκηνὴν τοῦ μαρτυρίου, καὶ τὸ κάλυμμα αὐτῆς, καὶ τὸ κατακάλυμμα τὸ ὑακίνθινον τὸ ὂν ἐπʼ αὐτῆς ἄνωθεν, καὶ τὸ κάλυμμα τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","καὶ τὰ ἱστία τῆς αὐλῆς, ὅσα ἐπὶ τῆς σκηνῆς τοῦ μαρτυρίου, καὶ τὰ περισσὰ, καὶ πάντα τὰ σκεύη τὰ λειτουργικὰ ὅσα λειτουργοῦσιν ἐν αὐτοῖς ποιήσουσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Κατὰ στόμα Ἀαρὼν καὶ τῶν υἱῶν αὐτοῦ ἔσται ἡ λειτουργία τῶν υἱῶν Γεδσὼν κατὰ πάσας τὰς λειτουργίας αὐτῶν, καὶ κατὰ πάντα τὰ ἔργα αὐτῶν· καὶ ἐπισκέψῃ αὐτοὺς ἐξ ὀνόματος πάντα τὰ ἀρτὰ ὑπʼ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Αὕτη ἡ λειτουργία τῶν υἱῶν Γεδσὼν ἐν τῇ σκηνῇ τοῦ μαρτυρίου, καὶ ἡ φυλακὴ αὐτῶν ἐν χειρὶ Ἰθάμαρ τοῦ υἱοῦ Ἀαρὼν τοῦ ἱερέως. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Οἱ υἱοὶ Μεραρὶ κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, ἐπισκέψασθε αὐτοὺς, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς ἐπισκέψασθε αὐτοὺς, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν τὰ ἔργα τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Καὶ ταῦτα τὰ φυλάγματα τῶν αἰρομένων ὑπʼ αὐτῶν κατὰ πάντα τὰ ἔργα αὐτῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου· τὰς κεφαλίδας τῆς σκηνῆς, καὶ τοὺς μοχλοὺς, καὶ τοὺς στύλους αὐτῆς, καὶ τὰς βάσεις αὐτῆς, καὶ τὸ κατακάλυμμα, καὶ αἱ βάσεις αὐτῶν, καὶ οἱ στύλοι αὐτῶν, καὶ τὸ κατακάλυμμα τῆς θύρας τῆς σκηνῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","καὶ τοὺς στύλους τῆς αὐλῆς κύκλῳ, καὶ αἱ βάσεις αὐτῶν, καὶ τοὺς στύλους τοῦ καταπετάσματος τῆς πύλης τῆς αὐλῆς, καὶ τὰς βάσεις αὐτῶν, καὶ τοὺς πασσάλους αὐτῶν, καὶ τοὺς κάλους αὐτῶν, καὶ πάντα τὰ σκεύη αὐτῶν, καὶ πάντα τὰ λειτουργήματα αὐτῶν· ἐξ ὀνομάτων ἐπισκέψασθε αὐτοὺς, καὶ πάντα τὰ σκεύη τῆς φυλακῆς τῶν αἰρομένων ὑπʼ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Αὕτη ἡ λειτουργία δήμου υἱῶν Μεραρὶ ἐν πᾶσι τοῖς ἔργοις αὐτῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου ἐν χειρὶ Ἰθάμαρ τοῦ υἱοῦ Ἀαρὼν τοῦ ἱερέως. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Καὶ ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν καὶ οἱ ἄρχοντες Ἰσραὴλ τοὺς υἱοὺς Καὰθ κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν καὶ ποιεῖν ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Καὶ ἐγένετο ἡ ἐπίσκεψις αὐτῶν κατὰ δήμους αὐτῶν, δισχίλιοι ἑπτακόσιοι πεντήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Αὕτη ἡ ἐπίσκεψις δήμου Καάθ, πᾶς ὁ λειτουργῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου, καθὰ ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν διὰ φωνῆς Κυρίου, ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Καὶ ἐπεσκέπησαν υἱοὶ Γεδσὼν κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν καὶ ποιεῖν τὰ ἔργα ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Καὶ ἐγένετο ἡ ἐπίσκεψις αὐτῶν, κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, δισχίλιοι ἑξακόσιοι τριάκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Αὕτη ἡ ἐπίσκεψις δήμου υἱῶν Γεδσὼν, πᾶς ὁ λειτουργῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου, οὓς ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν διὰ φωνῆς Κυρίου, ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ἐπεσκέπησαν δὲ καὶ δῆμος υἱῶν Μεραρὶ κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς, πᾶς ὁ εἰσπορευόμενος λειτουργεῖν πρὸς τὰ ἔργα τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Καὶ ἐγενήθη ἡ ἐπίσκεψις αὐτῶν κατὰ δήμους αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, τρισχίλιοι καὶ διακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Αὕτη ἡ ἐπίσκεψις δήμου υἱῶν Μεραρὶ, οὓς ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν διὰ φωνῆς Κυρίου, ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Πάντες οἱ ἐπεσκεμμένοι, οὓς ἐπεσκέψατο Μωυσῆς καὶ Ἀαρὼν καὶ οἱ ἄρχοντες Ἰσραὴλ τοὺς Λευίτας, κατὰ δήμους καὶ κατʼ οἴκους πατριῶν αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω ἕως πεντηκονταετοῦς, πᾶς ὁ εἰσπορευόμενος πρὸς τὸ ἔργον τῶν ἔργων, καὶ τὰ ἔργα τὰ αἰρόμενα ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Καὶ ἐγενήθησαν οἱ ἐπισκεπέντες, ὀκτακισχίλιοι πεντακόσιοι ὀγδοήκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Διὰ φωνῆς Κυρίου ἐπεσκέψατο αὐτοὺς ἐν χειρὶ Μωυσῆ, ἄνδρα κατὰ ἄνδρα ἐπὶ τῶν ἔργων αὐτῶν, καὶ ἐπὶ ὧν αἴρουσιν αὐτοί· καὶ ἐπεσκέπησαν, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","πρόσταξον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐξαποστειλάτωσαν ἐκ τῆς παρεμβολῆς πάντα λεπρὸν, καὶ πάντα γονοῤῥυῆ, καὶ πάντα ἀκάθαρτον ἐπὶ ψυχῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ἀπὸ ἀρσενικοῦ ἕως θηλυκοῦ, ἐξαποστείλατε ἔξω τῆς παρεμβολῆς, καὶ οὐ μὴ μιανοῦσι τὰς παρεμβολὰς αὐτῶν, ἐν οἷς ἐγὼ καταγίνομαι ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Καὶ ἐποίησαν οὕτως οἱ υἱοὶ Ἰσραὴλ, καὶ ἐξαπέστειλαν αὐτοὺς ἔξω τῆς παρεμβολῆς· καθὰ ἐλάλησε Κύριος Μωυσῇ, οὕτως ἐποίησαν οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, ἀνὴρ ἢ γυνὴ, ὅστις ἂν ποιήσῃ ἀπὸ πασῶν τῶν ἁμαρτιῶν τῶν ἀνθρωπίνων, καὶ παριδὼν παρίδῃ καὶ πλημμελήσῃ ἡ ψυχὴ ἐκείνη, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ἐξαγορεύσει τὴν ἁμαρτίαν, ἣν ἐποίησε, καὶ ἀποδώσει τὴν πλημμέλειαν· τὸ κεφάλαιον, καὶ τὸ ἐπίπεμπτον αὐτοῦ προσθήσει ἐπʼ αὐτὸ, καὶ ἀποδώσει τίνι ἐπλημμέλησεν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ἐὰν δὲ μὴ ᾖ τῷ ἀνθρώπῳ ὁ ἀγχιστεύων, ὥστε ἀποδοῦναι αὐτῷ τὸ πλημμέλημα πρὸς αὐτὸν, τὸ πλημμέλημα τὸ ἀποδιδόμενον Κυρίῳ, τῷ ἱερεῖ ἔσται, πλὴν τοῦ κριοῦ τοῦ ἱλασμοῦ, διʼ οὗ ἐξιλάσεται ἐν αὐτῷ περὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Καὶ πᾶσα ἀπαρχὴ κατὰ πάντα τὰ ἁγιαζόμενα ἐν υἱοῖς Ἰσραὴλ, ὅσα ἐὰν προσφέρωσι κυρίῳ, τῷ ἱερεῖ αὐτῷ ἔσται· ");
INSERT INTO grcbrent_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Καὶ ἑκάστου τὰ ἡγιασμένα, αὐτοῦ ἔσται· καὶ ἀνὴρ, ὃς ἂν δῷ τῷ ἱερεῖ, αὐτῷ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ἀνδρὸς ἀνδρὸς ἐὰν παραβῇ ἡ γυνὴ αὐτοῦ, καὶ ὑπεριδοῦσα παρίδῃ αὐτὸν, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","καὶ κοιμηθῇ τις μετʼ αὐτῆς κοίτην σπέρματος, καὶ λάθῃ ἐξ ὀφθαλμῶν τοῦ ἀνδρὸς αὐτῆς, καὶ κρύψῃ, αὐτὴ δὲ ᾖ μεμιασμένη, καὶ μάρτυς μὴ ἦν μετʼ αὐτῆς, καὶ αὐτὴ μὴ ᾖ συνειλημμένη, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","καὶ ἐπέλθῃ αὐτῷ πνεῦμα ζηλώσεως, καὶ ζηλώσῃ τὴν γυναῖκα αὐτοῦ, αὐτὴ δὲ μεμίανται, ἢ ἐπέλθῃ αὐτῷ πνεῦμα ζηλώσεως, καὶ ζηλώσῃ τὴν γυναῖκα αὐτοῦ, αὐτὴ δὲ μὴ ᾖ μεμιασμένη, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","καὶ ἄξει ὁ ἄνθρωπος τὴν γυναῖκα αὐτοῦ πρὸς τὸν ἱερέα, καὶ προσοίσει τὸ δῶρον περὶ αὐτῆς, τὸ δέκατον τοῦ οἰφὶ ἄλευρον κρίθινον· οὐκ ἐπιχεεῖ ἐπʼ αὐτὸ ἔλαιον, οὐδὲ ἐπιθήσει ἐπʼ αὐτὸ λίβανον· ἔστι γὰρ θυσία ζηλοτυπίας, θυσία μνημοσύνου, ἀναμιμνήσκουσα ἁμαρτίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Καὶ προσάξει αὐτὴν ὁ ἱερεὺς, καὶ στήσει αὐτὴν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Καὶ λήψεται ὁ ἱερεὺς ὕδωρ καθαρὸν ζῶν ἐν ἀγγείῳ ὀστρακίνῳ, καὶ τῆς γῆς τῆς οὔσης ἐπὶ τοῦ ἐδάφους τῆς σκηνῆς τοῦ μαρτυρίου, καὶ λαβὼν ὁ ἱερεὺς ἐμβαλεῖ εἰς τὸ ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Καὶ στήσει ὁ ἱερεὺς τὴν γυναῖκα ἔναντι Κυρίου, καὶ ἀποκαλύψει τὴν κεφαλὴν τῆς γυναικὸς, καὶ δώσει ἐπὶ τὰς χεῖρας αὐτῆς τὴν θυσίαν τοῦ μνημοσύνου, τὴν θυσίαν τῆς ζηλοτυπίας· ἐν δὲ τῇ χειρὶ τοῦ ἱερέως ἔσται τὸ ὕδωρ τοῦ ἐλεγμοῦ τοῦ ἐπικαταρωμένου τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Καὶ ὁρκιεῖ αὐτὴν ὁ ἱερεὺς, καὶ ἐρεῖ τῇ γυναικὶ, εἰ μὴ κεκοίμηταί τις μετὰ σοῦ, εἰ μὴ παραβέβηκας μιανθῆναι ὑπὸ τὸν ἄνδρα τὸν σεαυτῆς, ἀθῶα ἴσθι ἀπὸ τοῦ ὕδατος τοῦ ἐλεγμοῦ τοῦ ἐπικαταρωμένου τούτου. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Εἰ δὲ σὺ παραβέβηκας ὕπανδρος οὖσα, ἢ μεμίανσαι, καὶ ἔδωκέ τις τὴν κοίτην αὐτοῦ ἐν σοὶ, πλὴν τοῦ ἀνδρός σου· ");
INSERT INTO grcbrent_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Καὶ ὁρκιεῖ ὁ ἱερεὺς τὴν γυναῖκα ἐν τοῖς ὅρκοις τῆς ἀρᾶς ταύτης, καὶ ἐρεῖ ὁ ἱερεὺς τῇ γυναικὶ, δῴη σε Κύριος ἐν ἀρᾷ καὶ ἐνόρκιον ἐν μέσῳ τοῦ λαοῦ σου, ἐν τῷ δοῦναι Κύριον τὸν μηρόν σου διαπεπτωκότα, καὶ τὴν κοιλίαν σου πεπρησμένην. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Καὶ εἰσελεύσεται τὸ ὕδωρ τὸ ἐπικαταρώμενον τοῦτο εἰς τὴν κοιλίαν σου πρῆσαι γαστέρα, καὶ διαπεσεῖν μηρόν σου· καὶ ἐρεῖ ἡ γυνὴ, γένοιτο, γένοιτο. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Καὶ γράψει ὁ ἱερεὺς τὰς ἀρὰς ταύτας εἰς βιβλίον, καὶ ἐξαλείψει εἰς τὸ ὕδωρ τοῦ ἐλεγμοῦ τοῦ ἐπικαταρωμένου. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Καὶ ποτιεῖ τὴν γυναῖκα τὸ ὕδωρ τοῦ ἐλεγμοῦ τοῦ ἐπικαταρωμένου· καὶ εἰσελεύσεται εἰς αὐτὴν τὸ ὕδωρ τὸ ἐπικαταρώμενον τοῦ ἐλεγμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Καὶ λήψεται ὁ ἱερεὺς ἐκ χειρὸς τῆς γυναικὸς τὴν θυσίαν τῆς ζηλοτυπίας, καὶ ἐπιθήσει τὴν θυσίαν ἔναντι Κυρίου, καὶ προσοίσει αὐτὴν πρὸς τὸ θυσιαστήριον. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Καὶ δράξεται ὁ ἱερεὺς ἀπὸ τῆς θυσίας τὸ μνημόσυνον αὐτῆς, καὶ ἀνοίσεται αὐτὸ ἐπὶ τὸ θυσιαστήριον, καὶ μετὰ. ταῦτα ποτιεῖ τὴν γυναῖκα τὸ ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Καὶ ἔσται ἐὰν ᾖ μεμιασμένη καὶ λήθῃ λάθῃ τὸν ἄνδρα αὐτῆς, καὶ εἰσελεύσεται εἰς αὐτὴν τὸ ὕδωρ τοῦ ἐλεγμοῦ τὸ ἐπικαταρώμενον, καὶ πρησθήσεται τὴν κοιλίαν, καὶ διαπεσεῖται ὁ μηρὸς αὐτῆς, καὶ ἔσται ἡ γυνὴ εἰς ἀρὰν τῷ λαῷ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ἐὰν δὲ μὴ μιανθῇ ἡ γυνὴ, καὶ καθαρὰ ᾖ, καὶ ἀθῶα ἔσται καὶ ἐκσπερματιεῖ σπέρμα. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Οὗτος ὁ νόμος τῆς ζηλοτυπίας, ᾧ ἂν παραβῇ ἡ γυνὴ ὕπανδρος οὖσα, καὶ μιανθῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Ἢ ἄνθρωπος ὃς ἐὰν ἐπέλθῃ ἐπʼ αὐτὸν πνεῦμα ζηλώσεως, καὶ ζηλώσῃ τὴν γυναῖκα αὐτοῦ, καὶ στήσῃ τὴν γυναῖκα αὐτοῦ ἔναντι Κυρίου, καὶ ποιήσει αὐτῇ ὁ ἱερεὺς πάντα τὸν νόμον τοῦτον, ");
INSERT INTO grcbrent_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","καὶ ἀθῶος ἔσται ὁ ἄνθρωπος ἀπὸ ἁμαρτίας· καὶ γυνὴ ἐκείνη λήψεται τὴν ἁμαρτίαν αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, λάλησον τοῖς υἱοῖς Ἰσραὴλ, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","καὶ ἐρεῖς πρὸς αὐτοὺς, ἀνὴρ ἢ γυνὴ, ὃς ἂν μεγάλως εὔξηται εὐχὴν ἀφαγνίσασθαι ἁγνείαν Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ἀπὸ οἴνου καὶ σίκερα ἁγνισθήσεται· καὶ ὄξος ἐξ οἴνου καὶ ὄξος ἐκ σίκερα οὐ πίεται· καὶ ὅσα κατεργάζεται ἐκ σταφυλῆς οὐ πίεται· καὶ σταφυλὴν πρόσφατον καὶ σταφίδα οὐ φάγεται πάσας τὰς ἡμέρας τῆς εὐχῆς αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ἀπὸ πάντων ὅσα γίνεται ἐξ ἀμπέλου, οἶνον ἀπὸ στεμφύλων ἕως γιγάρτου οὐ φάγεται πάσας τὰς ἡμέρας τοῦ ἁγνισμοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ξυρὸν οὐκ ἐπελεύσεται ἐπὶ τὴν κεφαλὴν αὐτοῦ, ἓως ἄν πληρωθῶσιν αἱ ἡμέραι, ὅσας ηὐξατο Κυρίῳ· ἅγιος ἔσται τρέφων κόμην τρίχα κεφαλῆς πάσας τὰς ἡμέρας τῆς εὐχῆς Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ἐπὶ πάσῃ ψυχῇ τετελευτηκυίᾳ οὐκ εἰσελεύσεται ἐπὶ πατρὶ καὶ μητρὶ, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","καὶ ἐπʼ ἀδελφῷ καὶ ἐπʼ ἀδελφῇ, οὐ μιανφήσεται ἐπʼ αὐτοὶς ἀποφανόντων αὐτῶν, ὅτι εὐχὴ Θεοῦ αὐτοῦ ἐπʼ αὐτῷ ἐπὶ κεφαλῆς αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Πάσας τὰς ἡμέρας τῆς εὐχῆς αὐτοῦ ἅγιος ἔσται Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ἐὰν δέ τις ἀποθάνῃ ἐπʼ αὐτῷ ἐξάπινα, παραχρῆμα μιανθήσεται ἡ κεφαλὴ εὐχῆς αὐτοῦ· καὶ ξυρήσεται τὴν κεφαλὴν αὐτοῦ ᾗ ἂν ἡμέρᾳ καθαρισθῇ· τῇ ἡμέρᾳ τῇ ἑβδόμῃ ξυρηθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ οἴσει δύο τρυγόνας, ἢ δύο νοσσοὺς περιστερῶν πρὸς τὸν ἱερέα, ἐπὶ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Καὶ ποιήσει ὁ ἱερεὺς μίαν περὶ ἁμαρτίας, καὶ μίαν εἰς ὁλοκαύτωμα· καὶ ἐξιλάσεται περὶ αὐτοῦ ὁ ἱερεὺς περὶ ὧν ἥμαρτε περὶ τῆς ψυχῆς· καὶ ἁγιάσει τὴν κεφαλὴν αὐτοῦ ἐν ἐκείνῃ τῇ ἡμέρᾳ, ᾗ ἡγιάσθη Κυρίῳ, τὰς ἡμέρας τῆς εὐχῆς· ");
INSERT INTO grcbrent_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","καὶ προσάξει ἀμνὸν ἐνιαύσιον εἰς πλημμέλειαν· καὶ αἱ ἡμέραι αἱ πρότεραι ἄλογοι ἔσονται, ὅτι ἐμιάνθη ἡ κεφαλὴ εὐχῆς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Καὶ οὗτος ὁ νόμος τοῦ εὐξαμένου· ᾗ ἂν ἡμέρᾳ πληρώσῃ ἡμέρας εὐχῆς αὐτοῦ, προσοίσει αὐτὸς παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Καὶ προσάξει τὸ δῶρον αὐτοῦ Κυρίῳ ἀμνὸν ἐνιαύσιον ἄμωμον ἕνα εἰς ὁλοκαύτωσιν, καὶ ἀμνάδα ἐνιαυσίαν μίαν ἄμωμον εἰς ἁμαρτίαν, καὶ κριὸν ἕνα ἄμωμον εἰς σωτήριον, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","καὶ κανοῦν ἀζύμων σεμιδάλεως ἄρτους ἀναπεποιημένους ἐν ἐλαίῳ, καὶ λάγανα ἄζυμα κεχρισμένα ἐν ἐλαίῳ, καὶ θυσίαν αὐτῶν, καὶ σπονδὴν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Καὶ προσοίσει ὁ ἱερεὺς ἔναντι Κυρίου, καὶ ποιήσει τὸ περὶ ἁμαρτίας αὐτοῦ, καὶ τὸ ὁλοκαύτωμα αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Καὶ τὸν κριὸν ποιήσει θυσίαν σωτηρίου τῷ Κυρίῳ ἐπὶ τῷ κανῷ τῶν ἀζύμων· καὶ ποιήσει ὁ ἱερεὺς τὴν θυσίαν αὐτοῦ, καὶ τὴν σπονδὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Καὶ ξυρήσεται ὁ ηὐγμένος παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου τὴν κεφαλὴν τῆς εὐχῆς αὐτοῦ, καὶ ἐπιθήσει τὰς τρίχας ἐπὶ τὸ πῦρ, ὅ ἐστιν ὑπὸ τὴν θυσίαν τοῦ σωτηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Καὶ λήψεται ὁ ἱερεὺς τὸν βραχίονα ἐφθὸν ἀπὸ τοῦ κριοῦ, καὶ ἄρτον ἕνα ἄζυμον ἀπὸ τοῦ κανοῦ, καὶ λάγανον ἄζυμον ἕν, καὶ ἐπιθήσει ἐπὶ τὰς χεῖρας τοῦ ηὐγμένου μετὰ τὸ ξυρήσασθαι αὐτὸν τὴν εὐχὴν αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","καὶ προσοίσει αὐτὰ ὁ ἱερεὺς ἐπίθεμα ἔναντι Κυρίου· ἅγιον ἔσται τῷ ἱερεῖ ἐπὶ τοῦ στηθηνίου τοῦ ἐπιθέματος, καὶ ἐπὶ τοῦ βραχίονος τοῦ ἀφαιρέματος· καὶ μετὰ ταῦτα πίεται ὁ ηὐγμένος οἶνον. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Οὗτος ὁ νόμος τοῦ εὐξαμένου, ὃς ἂν εὔξηται Κυρίῳ δῶρον αὐτοῦ Κυρίῳ περὶ τῆς εὐχῆς, χωρὶς ὧν ἂν εὕρῃ ἡ χεὶρ αὐτοῦ, κατὰ δύναμιν τῆς εὐχῆς αὐτοῦ, ἣν ἂν εὔξηται κατὰ νόμον ἁγνείας. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","λάλησον Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ, λέγων, οὕτως εὐλογήσετε τοὺς υἱοὺς Ἰσραὴλ, λέγοντες αὐτοῖς, ");
INSERT INTO grcbrent_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","εὐλογήσαι σε Κύριος, καὶ φυλάξαι, σε. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ἐπιφάναι Κύριος τὸ πρόσωπον αὐτοῦ ἐπὶ σὲ, καὶ ἐλεήσαι σε. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ἐπάραι Κύριος τὸ πρόσωπον αὐτοῦ ἐπὶ σὲ, καὶ δῴη σοι εἰρήνην. ");
INSERT INTO grcbrent_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Καὶ ἐπιθήσουσι τὸ ὄνομά μου ἐπὶ τοὺς υἱοὺς Ἰσραὴλ, καὶ ἐγὼ Κύριος εὐλογήσω αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Καὶ ἐγένετο ᾗ ἡμέρᾳ συνετέλεσε Μωυσῆς, ὥστε ἀναστῆσαι τὴν σκηνήν, καὶ ἔχρισεν αὐτὴν, καὶ ἡγίασεν αὐτὴν, καὶ πάντα τὰ σκεύη αὐτῆς, καὶ τὸ θυσιαστήριον, καὶ πάντα τὰ σκεύη αὐτοῦ, καὶ ἔχρισεν αὐτὰ, καὶ ἡγίασεν αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Καὶ προσήνεγκαν οἱ ἄρχοντες Ἰσραὴλ, δώδεκα ἄρχοντες οἴκων πατριῶν αὐτῶν· οὗτοι οἱ ἄρχοντες φυλῶν, οὗτοι οἱ παρεστηκότες ἐπὶ τῆς ἐπισκοπῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Καὶ ἤνεγκαν τὸ δῶρον αὐτῶν ἔναντι Κυρίου, ἓξ ἁμάξας λαμπηνίκας, καὶ δώδεκα βόας· ἅμαξαν παρὰ δύο ἀρχόντων, καὶ μόσχον παρὰ ἑκάστου· καὶ προσήγαγον ἐναντίον τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","λάβε παρʼ αὐτῶν, καὶ ἔσονται πρὸς τὰ ἔργα τὰ λειτουργικὰ τῆς σκηνῆς τοῦ μαρτυρίου· καὶ δώσεις αὐτὰ τοῖς Λευίταις, ἑκάστῳ κατὰ τὴν αὐτοῦ λειτουργίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Καὶ λαβὼν Μωυσῆς τὰς ἁμάξας καὶ τοὺς βόας, ἔδωκεν αὐτὰ τοῖς Λευίταις. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Καὶ τὰς δύο ἁμάξας καὶ τοὺς τέσσαρας βόας ἔδωκε τοῖς υἱοῖς Γεδσὼν κατὰ τὰς λειτουργίας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Καὶ τὰς τέσσαρας ἁμάξας καὶ τοὺς ὀκτὼ βόας ἔδωκε τοῖς υἱοῖς Μεραρὶ κατὰ τὰς λειτουργίας αὐτῶν, διὰ Ἰθάμαρ υἱοῦ Ἀαρὼν τοῦ ἱερέως. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Καὶ τοῖς υἱοῖς Καὰθ οὐ δέδωκεν, ὅτι τὰ λειτουργήματα τοῦ ἁγίου ἔχουσιν· ἐπʼ ὤμων ἀροῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Καὶ προσήνεγκαν οἱ ἄρχοντες εἰς τὸν ἐγκαινισμὸν τοῦ θυσιαστηρίου, ἐν τῇ ἡμέρᾳ ᾗ ἔχρισεν αὐτὸ, καὶ προσήνεγκαν οἱ ἄρχοντες τὰ δῶρα αὐτῶν ἀπέναντι τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἄρχων εἷς καθʼ ἡμέραν, ἄρχων καθʼ ἡμέραν προσοίσουσι τὰ δῶρα αὐτῶν εἰς τὸν ἐγκαινισμὸν τοῦ θυσιαστηρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Καὶ ἦν ὁ προσφέρων ἐν τῇ ἡμέρᾳ τῇ πρώτῃ τὸ δῶρον αὐτοῦ, Ναασσὼν υἱὸς Ἀμιναδὰβ, ἄρχων τῆς φυλῆς Ἰούδα. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Καὶ προσήνεγκε τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἕν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφοτέρα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο δῶρον Ναασσὼν υἱοῦ Ἀμιναδάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Τῇ ἡμέρᾳ τῇ δευτέρᾳ προσήνεγκε Ναθαναὴλ υἱὸς Σωγὰρ, ὅ ἄρχων τῆς φυλῆς Ἰσσάχαρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Καὶ προσήνεγκε τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Μόσχον ἔνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ναθαναὴλ υἱοῦ Σωγάρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Τῇ ἡμέρᾳ τῇ τρίτῃ ἄρχων τῶν υἱῶν Σαβουλὼν, Ἑλιὰβ υἱὸς Χαιλών. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἕν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν· ");
INSERT INTO grcbrent_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἑλιὰβ υἱοῦ Χαιλών. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Τῇ ἡμέρᾳ τῇ τετάρτῃ ἄρχων τῶν υἱῶν Ῥουβὴν, Ἑλισοῦρ υἱὸς Σεδιούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν· ");
INSERT INTO grcbrent_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἑλισοὺρ υἱοῦ Σεδιούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Τῇ ἡμέρᾳ τῇ πέμπτῃ ἄρχων τῶν υἱῶν Συμεὼν, Σαλαμιὴλ υἱὸς Σουρισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἐναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Θυϊσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Σαλαμιὴλ υἱοῦ Σουρισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Τῇ ἡμέρᾳ τῇ ἕκτῃ ἄρχων τῶν υἱῶν Γὰδ, Ἐλεισὰφ υἱὸς Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἕν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἐλισὰφ υἱοῦ Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Τῇ ἡμέρᾳ τῇ ἑβδόμῃ ἄρχων τῶν υἱῶν Ἐφραὶμ, Ἐλισαμὰ υἱὸς Ἐμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἐλισαμὰ υἱοῦ Ἐμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Τῇ ἡμέρᾳ τῇ ὀγδόῃ ἄρχων τῶν υἱῶν Μανασσῆ, Γαμαλιὴλ υἱὸς Φαδασσούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· ");
INSERT INTO grcbrent_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Γαμαλιὴλ υἱοὺ Φαδασσούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Τῇ ἡμέρᾳ τῇ ἐνάτῃ ἄρχων τῶν υἱῶν Βενιαμὶν, Ἀβιδὰν υἱὸς Γαδεωνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην, μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν· ");
INSERT INTO grcbrent_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἀβιδὰν υἱοῦ Γαδεωνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Τῇ ἡμέρᾳ τῇ δεκάτῃ ἄρχων τῶν υἱῶν Δὰν, Ἀχιέζερ υἱὸς Ἀμισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἕν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἀχιέζερ υἱοῦ Ἀμισαδαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Τῇ ἡμέρᾳ τῇ ἑνδέκατῃ ἄρχων τῶν υἱῶν Ἀσὴρ, Φαγεὴλ υἱὸς Ἐχράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἐνιαύσιον ἕνα εἰς ὁλοκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Φαγεὴλ υἱοῦ Ἐχράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Τῇ ἡμέρᾳ τῇ δωδεκάτῃ ἄρχων τῶν υἱῶν Νεφθαλί, Ἀχιρὲ υἱὸς Αἰνάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Τὸ δῶρον αὐτοῦ, τρυβλίον ἀργυροῦν ἓν, τριάκοντα καὶ ἑκατὸν ὁλκὴ αὐτοῦ· φιάλην μίαν ἀργυρᾶν, ἑβδομήκοντα σίκλων κατὰ τὸν σίκλον τὸν ἅγιον· ἀμφότερα πλήρη σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Θυΐσκην μίαν δέκα χρυσῶν, πλήρη θυμιάματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνὸν ἕνα ἐνιαύσιον εἰς ὁλόκαύτωμα, ");
INSERT INTO grcbrent_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Καὶ εἰς θυσίαν σωτηρίου δαμάλεις δύο, κριοὺς πέντε, τράγους πέντε, ἀμνάδας ἐνιαυσίας πέντε· τοῦτο τὸ δῶρον Ἀχιρὲ υἱοῦ Αἰνάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Οὗτος ὁ ἐγκαινισμὸς τοῦ θυσιαστηρίου ᾗ ἡμέρᾳ ἔχρισεν αὐτὸ, παρὰ τῶν ἀρχόντων τῶν υἱῶν Ἰσραὴλ· τρυβλία ἀργυρᾶ δώδεκα, φιάλαι ἀργυραῖ δώδεκα, θυΐσκαι χρυσαῖ δώδεκα. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Τριάκοντα καὶ ἑκατὸν σίκλων, τὸ τρυβλίον τὸ ἕν, καὶ ἑβδομήκοντα σίκλων ἡ φιάλη ἡ μία· πᾶν τὸ ἀργύριον τῶν σκευῶν, δισχίλιοι καὶ τετρακόσιοι σίκλοι· σίκλοι, ἐν τῷ σίκλῳ τῷ ἁγίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Θυΐσκαι χρυσαῖ δώδεκα πλήρεις θυμιάματος· πᾶν τὸ χρυσίον τῶν θυϊσκῶν, εἴκοσι καὶ ἑκατὸν χρυσοῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Πᾶσαι αἱ βόες αἱ εἰς ὁλοκαύτωσιν, μόσχοι δώδεκα, κριοὶ δώδεκα, ἀμνοὶ ἐνιαύσιοι δώδεκα, καὶ αἱ θυσίαι αὐτῶν, καὶ αἱ σπονδαὶ αὐτῶν· καὶ χίμαροι ἐξ αἰγῶν δώδεκα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Πᾶσαι αἱ βόες εἰς θυσίαν σωτηρίου, δαμάλεις εἰκοσιτέσσαρες, κριοὶ ἑξήκοντα, τράγοι ἑξήκοντα ἐνιαύσιαι, ἀμνάδες ἑξήκοντα ἐνιαύσιοι ἄμωμοι· αὕτη ἡ ἐγκαίνωσις τοῦ θυσιαστηρίου, μετὰ τὸ πληρῶσαι τὰς χεῖρας αὐτοῦ, καὶ μετὰ τὸ χρίσαι αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ἐν τῷ εἰσπορεύεσθαι Μωυσῆν εἰς τὴν σκηνὴν τοῦ μαρτυρίου λαλῆσαι αὐτῷ, καὶ ἤκουσε τὴν φωνὴν Κυρίου λαλοῦντος πρὸς αὐτὸν ἄνωθεν τοῦ ἱλαστηρίου, ὅ ἐστιν ἐπὶ τῆς κιβωτοῦ τοῦ μαρτυρίου, ἀναμέσον τῶν δύο χερουβίμ· καὶ ἐλάλει πρὸς αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, λάλησον τῷ Ἀαρὼν, ");
INSERT INTO grcbrent_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","καὶ ἐρεῖς πρὸς αὐτὸν, ὅταν ἐπιτιθῇς τοὺς λύχνους ἐκ μέρους, κατὰ πρόσωπον τῆς λυχνίας φωτιοῦσιν οἱ ἑπτὰ λύχνοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Καὶ ἐποίησεν οὕτως Ἀαρών· ἐκ τοῦ ἑνὸς μέρους κατὰ πρόσωπον τῆς λυχνίας ἐξῆψε τοὺς λύχνους αὐτῆς, καθὰ συνέταξε Κύριος τῷ Μωυσῇ· ");
INSERT INTO grcbrent_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Καὶ αὕτη ἡ κατασκευὴ τῆς λυχνίας· στερεὰ, χρυσῆ, ὁ καυλὸς αὐτῆς, καὶ τὰ κρίνα αὐτῆς, στερεὰ ὅλη· κατὰ τὸ εἶδος ὃ ἔδειξε Κύριος τῷ Μωυσῇ, οὕτως ἐποίησε τὴν λυχνίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","λάβε τοὺς Λευίτας ἐκ μέσου υἱῶν Ἰσραὴλ, καὶ ἀφαγνιεῖς αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Καὶ οὕτω ποιήσεις αὐτοῖς τὸν ἁγνισμὸν αὐτῶν· περιῤῥανεῖς αὐτοὺς ὕδωρ ἁγνισμοῦ· καὶ ἐπελεύσεται ξυρὸν ἐπὶ πᾶν τὸ σῶμα αὐτῶν, καὶ πλυνοῦσι τὰ ἱμάτια αὐτῶν, καὶ καθαροὶ ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Καὶ λήμψονται μόσχον ἕνα ἐκ βοῶν, καὶ τούτου θυσίαν σεμίδαλιν ἀναπεποιημένην ἐν ἐλαίῳ· καὶ μόσχον ἐνιαύσιον ἐκ βοῶν λήψῃ περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Καὶ προσάξεις τοὺς Λευίτας ἔναντι τῆς σκηνῆς τοῦ μαρτυρίου· καὶ συνάξεις πᾶσαν συναγωγὴν υἱῶν Ἰσραήλ· ");
INSERT INTO grcbrent_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Καὶ προσάξεις τοὺς Λευίτας ἔναντι Κυρίου, καὶ ἐπιθήσουσιν οἱ υἱοὶ Ἰσραὴλ τὰς χεῖρας αὐτῶν ἐπὶ τοὺς Λευίτας· ");
INSERT INTO grcbrent_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Καὶ ἀφοριεῖ Ἀαρὼν τοὺς Λευίτας ἀπόδομα ἔναντι Κυρίου παρὰ τῶν υἱῶν Ἰσραήλ· καὶ ἔσονται ὥστε ἐργάζεσθαι τὰ ἔργα Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Οἱ δὲ Λευῖται ἐπιθήσονσι τὰς χεῖρας ἐπὶ τὰς κεφαλὰς τῶν μόσχων· καὶ ποιήσεις τὸν ἕνα περὶ ἁμαρτίας, καὶ τὸν ἕνα εἰς ὁλοκαύτωμα Κυρίῳ, ἐξιλάσασθαι περὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Καὶ στήσεις τοὺς Λευίτας ἔναντι Κυρίου, καὶ ἔναντι Ἀαρὼν, καὶ ἔναντι τῶν υἱῶν αὐτοῦ, καὶ ἀποδώσεις αὐτοὺς ἀπόδομα ἔναντι Κυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Καὶ διαστελεῖς τοὺς Λευίτας ἐκ μέσου υἱῶν Ἰσραήλ· καὶ ἔσονταί μοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Καὶ μετὰ ταῦτα εἰσελεύσονται οἱ Λευῖται ἐργάζεσθαι τὰ ἔργα τῆς σκηνῆς τοῦ μαρτυρίον· καὶ καθαριεῖς αὐτοὺς, καὶ ἀποδώσεις αὐτοὺς ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ὅτι ἀπόδομα ἀποδεδομένοι οὗτοί μοι εἰσὶν ἐκ μέσου υἱῶν Ἰσραήλ· ἀντὶ τῶν διανοιγόντων πᾶσαν μήτραν πρωτοτόκων πάντων ἐκ τῶν υἱῶν Ἰσραὴλ εἴληφα αὐτοὺς ἐμοί. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ὅτι ἐμοὶ πᾶν πρωτότοκον ἐν υἱοῖς Ἰσραὴλ ἀπὸ ἀνθρώπων ἕως κτήνους· ᾗ ἡμέρᾳ ἐπάταξα πᾶν πρωτότοκον ἐν γῇ Αἰγύπτου, ἡγίασα αὐτοὺς ἐμοὶ, ");
INSERT INTO grcbrent_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","καὶ ἔλαβον τοὺς Λευίτας ἀντὶ παντὸς πρωτοτόκου ἐν υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Καὶ ἀπέδωκα τοὺς Λευίτας ἀπόδομα δεδομένους Ἀαρὼν καὶ τοῖς υἱοῖς αὐτοῦ ἐκ μέσου υἱῶν Ἰσραὴλ, ἐργάζεσθαι τὰ ἔργα τῶν υἱῶν Ἰσραὴλ ἐν τῇ σκηνῇ τοῦ μαρτυρίου, καὶ ἐξιλάσκεσθαι περὶ τῶν υἱῶν Ἰσραήλ· καὶ οὐκ ἔσται ἐν τοῖς υἱοῖς Ἰσραὴλ προσεγγίζων πρὸς τὰ ἅγια. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Καὶ ἐποίησε Μωυσῆς καὶ Ἀαρὼν καὶ πᾶσα ἡ συναγωγὴ υἱῶν Ἰσραὴλ τοῖς Λευίταις καθὰ ἐνετείλατο Κύριος τῷ Μωυσῇ περὶ τῶν Λευιτῶν, οὕτως ἐποίησαν αὐτοῖς οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Καὶ ἡγνίσαντο οἱ Λευῖται, καὶ ἐπλύναντο τὰ ἱμάτια· καὶ ἀπέδωκεν αὐτοὺς Ἀαρὼν ἀπόδομα ἔναντι Κυρίου, καὶ ἐξιλάσατο περὶ αὐτῶν Ἀαρὼν ἀφαγνίσασθαι αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Καὶ μετὰ ταῦτα εἰσῆλθον οἱ Λευῖται λειτουργεῖν τὴν λειτουργίαν αὐτῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου ἔναντι Ἀαρὼν, καὶ ἔναντι τῶν υἱῶν αὐτοῦ· καθὰ συνέταξε Κύριος τῷ Μωυσῇ περὶ τῶν Λευιτῶν, οὕτως ἐποίησαν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","τοῦτό ἐστι τὸ περὶ τῶν Λευιτῶν· ἀπὸ πέντε καὶ εἰκοσαετοῦς καὶ ἐπάνω, εἰσελεύσονται ἐνεργεῖν ἐν τῇ σκηνῇ τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Καὶ ἀπὸ πεντηκονταετοῦς ἀποστήσεται ἀπὸ τῆς λειτουργίας, καὶ οὐκ ἐργᾶται ἔτι. ");
INSERT INTO grcbrent_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Καὶ λειτουργήσει ὁ ἀδελφὸς αὑτοῦ ἐν τῇ σκηνῇ τοῦ μαρτυρίου φυλάσσειν φυλακὰς, ἔργα δὲ οὐκ ἐργᾶται· οὕτως ποιήσεις τοῖς Λευίταις ἐν ταῖς φυλακαῖς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν ἐν τῇ ἐρήμῳ Σινᾷ ἐν τῷ ἔτει τῷ δευτέρῳ, ἐξελθόντων αὐτῶν ἐκ γῆς Αἰγύπτου, ἐν τῷ μηνὶ τῷ πρώτῳ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","εἶπον, καὶ ποιείτωσαν οἱ υἱοὶ Ἰσραὴλ τὸ πάσχα καθʼ ὥραν αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","τῇ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τοῦ πρώτου πρὸς ἑσπέραν, ποιήσεις αὐτὸ κατὰ καιρούς· κατὰ τὸν νόμον αὐτοῦ, καὶ κατὰ τὴν σύγκρισιν αὐτοῦ ποιήσεις αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Καὶ ἐλάλησε Μωυσῆς τοῖς υἱοῖς Ἰσραὴλ ποιῆσαι τὸ πάσχα ἐναρχομένου τῇ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς ἐν τῇ ἐρήμῳ τοῦ Σινᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","καθὰ συνέταξε Κύριος τῷ Μωυσῇ, οὕτως ἐποίησαν οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Καὶ παρεγένοντο οἱ ἄνδρες οἳ ἦσαν ἀκάθαρτοι ἐπὶ ψυχῇ ἀνθρώπου, καὶ οὐκ ἠδύναντο ποιῆσαι τὸ πάσχα ἐν τῇ ἡμέρᾳ ἐκείνῃ· καὶ προσῆλθον ἐναντίον Μωυσῆ καὶ Ἀαρὼν ἐν ἐκείνῃ τῇ ἡμέρᾳ· ");
INSERT INTO grcbrent_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Καὶ εἶπαν οἱ ἄνδρες ἐκεῖνοι πρὸς αὐτὸν, ἡμεῖς ἀκάθαρτοι ἐπὶ ψυχῇ ἀνθρώπου· μὴ οὖν ὑστερήσωμεν προσενέγκαι τὸ δῶρον Κυρίῳ κατὰ καιρὸν αὐτοῦ ἐν μέσῳ υἱῶν Ἰσραήλ; ");
INSERT INTO grcbrent_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Καὶ εἶπε πρὸς αὐτοὺς Μωυσῆς, στῆτε αὐτοῦ, καὶ ἀκούσομαι τί ἐντελεῖται Κύριος περὶ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, ἄνθρωπος ἄνθρωπος, ὃν ἐὰν γένηται ἀκάθαρτος ἐπὶ ψυχῇ, ἀνθρώπου, ἢ ἐν ὁδῷ μακρὰν ὑμῖν, ἢ ἐν ταῖς γενεαῖς ὑμῶν, καὶ ποιήσει τὸ πάσχα Κυρίῳ ἐν τῷ μηνὶ τῷ δευτέρῳ ἐν τῇ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ· ");
INSERT INTO grcbrent_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","τὸ πρὸς ἑσπέραν ποιήσουσιν αὐτὸ, ἐπʼ ἀζύμων καὶ πικρίδων φάγονται αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Οὐ καταλείψουσιν ἀπʼ αὐτοῦ εἰς τὸ πρωῒ, καὶ ὀστοῦν οὐ συντρίψουσιν ἀπʼ αὐτοῦ· κατὰ τὸν νόμον τοῦ πάσχα ποιήσουσιν αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Καὶ ἄνθρωπος ὃς ἐὰν καθαρὸς ᾖ, καὶ ἐν ὁδῷ μακρὰν οὐκ ἔστι, καὶ ὑστερήσῃ ποιῆσαι τὸ πάσχα, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς, ὅτι τὸ δῶρον Κυρίῳ οὐ προσήνεγκε κατὰ τὸν καιρὸν αὐτοῦ· ἁμαρτίαν αὐτοῦ λήψεται ὁ ἄνθρωπος ἐκεῖνος. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ἐὰν δὲ προσέλθῃ πρὸς ὑμᾶς προσήλυτος ἐν τῇ γῇ ὑμῶν, καὶ ποιήσῃ τὸ πάσχα Κυρίῳ, κατὰ τὸν νόμον τοῦ πάσχα, καὶ κατὰ τὴν σύνταξιν αὐτοῦ ποιήσει αὐτό· νόμος εἷς ἔσται ὑμῖν καὶ τῷ προσηλύτῳ καὶ τῷ αὐτόχθονι τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Καὶ τῇ ἡμέρᾳ ᾗ ἐστάθη ἡ σκηνὴ, ἐκάλυψεν ἡ νεφελη τὴν σκηνὴν, τὸν οἶκον τοῦ μαρτυρίου· καὶ τὸ ἑσπέρας ἦν ἐπὶ τῆς σκηνῆς ὡς εἶδος πυρὸς ἕως πρωΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Οὕτως ἐγίνετο διαπαντός· ἡ νεφέλη ἐκάλυπτεν αὐτὴν ἡμέρας, καὶ εἶδος πυρὸς τὴν νύκτα. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Καὶ ἡνίκα ἀνέβη ἡ νεφέλη ἀπὸ τῆς σκηνῆς, καὶ μετὰ ταῦτα ἀπῇραν οἱ υἱοὶ Ἰσραήλ· καὶ ἐν τῷ τόπῳ οὗ ἂν ἔστη ἡ νεφέλη, ἐκεῖ παρενέβαλον οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Διὰ προστάγματος Κυρίου παρεμβαλοῦσιν οἱ υἱοὶ Ἰσραὴλ, καὶ διὰ προστάγματος Κυρίου ἀπαροῦσι· πάσας τὰς ἡμέρας ἐν αἷς σκιάζει ἡ νεφέλη ἐπὶ τῆς σκηνῆς, παρεμβαλοῦσιν οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Καὶ ὅταν ἐφέλκηται ἡ νεφέλη ἐπὶ τῆς σκηνῆς ἡμέρας πλείους, καὶ φυλάξονται οἱ υἱοὶ Ἰσραὴλ τὴν φυλακὴν τοῦ Θεοῦ, καὶ οὐ μὴ ἐξάρωσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Καὶ ἔσται ὅταν σκεπάζῃ ἡ νεφέλη ἡμέρας ἀριθμῷ ἐπὶ τῆς σκηνῆς, διὰ φωνῆς Κυρίου παρεμβαλοῦσι, καὶ διὰ προστάγματος Κυρίου ἀπαροῦσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Καὶ ἔσται ὅταν γένηται ἡ νεφέλη ἀφʼ ἑσπέρας ἕως πρωῒ, καὶ ἀναβῇ ἡ νεφέλη τοπρωῒ, καὶ ἀπαροῦσιν ἡμέρας ἢ νυκτός. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Μηνὸς ἡμέρας πλεοναζούσης τῆς νεφέλης σκιαζούσης ἐπʼ αὐτῆς, παρεμβαλοῦσιν οἱ υἱοὶ Ἰσραὴλ, καὶ οὐ μὴ ἀπάρωσιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ὅτι διὰ προστάγματος Κυρίου ἀπαροῦσι· τὴν φυλακὴν Κυρίου ἐφυλάξαντο διὰ προστάγματος Κυρίου ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ποίησον σεαυτῷ δύο σάλπιγγας ἀγυρᾶς· ");
INSERT INTO grcbrent_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","ἐλατὰς ποιήσεις αὐτάς· καὶ ἔσονταί σοι ἀνακαλεῖν τὴν συναγωγὴν, καὶ ἐξαίρειν τὰς παρεμβολάς. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Καὶ σαλπιεῖς ἐν αὐταῖς, καὶ συναχθήσεται πᾶσα ἡ συναγωγὴ ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου· ");
INSERT INTO grcbrent_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ἐὰν δὲ ἐν μιᾷ σαλπίσωσι, προσελεύσονται πρὸς σὲ πάντες οἱ ἄρχοντες ἀρχηγοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","καὶ σαλπιεῖτε σημασίαν, καὶ ἐξαροῦσιν αἱ παρεμβάλλουσαι αἱ παρεμβαλοῦσαι ἀνατολάς· ");
INSERT INTO grcbrent_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","καὶ σαλπιεῖτε σημασίαν δευτέραν, καὶ ἐξαροῦσιν αἱ παρεμβολαὶ αἱ παρεμβάλλουσαι Λίβα· καὶ σαλπιεῖτε σημασίαν τρίτην, καὶ ἐξαροῦσιν αἱ παρεμβολαὶ αἱ παρεμβάλλουσαι παρὰ θάλασσαν· καὶ σαλπιεῖτε σημασίαν τετάρτην, καὶ ἐξαροῦσιν αἱ παρεμβολαὶ αἱ παρεμβάλλουσαι πρὸς Βοῤῥᾶν· σημασίᾳ σαλπιοῦσιν ἐν τῇ ἐξάρσει αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","καὶ ὅταν συναγάγητε τὴν συναγωγὴν, σαλπιεῖτε, καὶ οὐ σημασίᾳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Καὶ οἱ υἱοὶ Ἀαρὼν οἱ ἱερεῖς σαλπιοῦσι ταῖς σάλπιγξι· καὶ ἔσται ὑμῖν νόμιμον αἰώνιον εἰς τὰς γενεὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ἐὰν δὲ ἐξέλθητε εἰς πόλεμον ἐν τῇ γῇ ὑμῶν πρὸς τοὺς ὑπεναντίους τοὺς ἀνθεστηκότας ὑμῖ, καὶ σημανεῖτε ταῖς σάλπιγξιν, καὶ ἀναμνησθήσεσθε ἔναντι Κυρίου, καὶ διασωθήσεσθε ἀπὸ τῶν ἐχθρῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Καὶ ἐν ταῖς ἡμέραις τῆς εὐφροσύνης ὑμῶν, καὶ ἐν ταῖς ἑορταῖς ὑμῶν, καὶ ἐν ταῖς νουμηνίαις ὑμῶν, σαλπιεῖτε ταῖς σάλπιγξιν ἐπὶ τοῖς ὁλοκαυτώμασι, καὶ ἐπὶ ταῖς θυσίαις τῶν σωτηρίων ὑμῶν· καὶ ἔσται ὑμῖν ἀνάμνησις ἔναντι τοῦ Θεοῦ ὑμῶν· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Καὶ ἐγένετο ἐν τῷ ἐνιαυτῷ τῷ δευτέρῳ ἐν τῷ μηνὶ τῷ δευτέρῳ εἰκάδι τοῦ μηνὸς, ἀνέβη ἡ νεφέλη ἀπὸ τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","καὶ ἐξῇραν οἱ υἱοὶ Ἰσραὴλ σὺν ἀπαρτίαις αὐτῶν ἐν τῇ ἐρήμῳ Σινᾶ· καὶ ἔστη ἡ νεφέλη ἐν τῇ ἐρήμῳ τοῦ Φαράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Καὶ ἐξῆραν πρῶτοι διὰ φωνῆς Κυρίου ἐν χειρὶ Μωυσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Καὶ ἐξῇραν τάγμα παρεμβολῆς υἱῶν Ἰούδα πρῶτοι σὺν δυνάμει αὐτῶν· καὶ ἐπὶ τῆς δυνάμεως αὐτῶν, Ναασσὼν υἱὸς Ἀμιναδάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Ἰσσάχαρ, Ναθαναὴλ υἱὸς Σωγάρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Ζαβουλὼν, Ἐλιὰβ, υἱὸς Χαιλών. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Καὶ καθελοῦσι τὴν σκηνὴν, καὶ ἐξαροῦσιν οἱ υἱοὶ Γεδσὼν, καὶ οἱ υἱοὶ Μεραρὶ, οἱ αἴροντες τὴν σκηνήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Καὶ ἐξῇραν τάγμα παρεμβολῆς Ῥουβὴν σὺν δυνάμει αὐτῶν· καὶ ἐπὶ τῆς δυνάμεως αὐτῶν, Ἐλισοὺρ υἱὸς Σεδιούρ· ");
INSERT INTO grcbrent_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Συμεὼν, Σαλαμιὴλ υἱὸς Σουρισαδαΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Γὰδ, Ἐλισὰφ ὁ τοῦ Ῥαγουήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Καὶ ἐξαροῦσιν οἱ υἱοὶ Καὰθ αἴροντες τὰ ἅγια· καὶ στήσουσι τὴν σκηνὴν ἕως παραγένωνται. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Καὶ ἐξαροῦσι τάγμα παρεμβολῆς Ἐφραὶμ σὺν δυνάμει αὐτῶν· καὶ ἐπὶ τῆς δυνάμεως αὐτῶν, Ἐλισαμὰ υἱὸς Σμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Μανασσῆ, Γαμαλιὴλ ὁ τοῦ Φαδασσούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Βενιαμὶν, Ἀβιδὰν ὁ τοῦ Γαδεωνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Καὶ ἐξαροῦσι τάγμα παρεμβολῆς υἱῶν Δὰν, ἔσχατοι πασῶν τῶν παρεμβολῶν, σὺν δυνάμει αὐτῶν· καὶ ἐπὶ τῆς δυνάμεως αὐτῶν, Ἀχιέζερ ὁ τοῦ Ἀμισαδαΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Ἀσὴρ, Φαγεὴλ υἱὸς Ἐχράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Καὶ ἐπὶ τῆς δυνάμεως φυλῆς υἱῶν Νεφθαλὶ, Ἀχιρὲ υἱὸς Αἰνάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Αὗται αἱ στρατιαὶ υἱῶν Ἰσραήλ· καὶ ἐξῇραν σὺν δυνάμει αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Καὶ εἶπε Μωυσῆς τῷ Ὀβὰβ υἱῷ Ῥαγουὴλ τῷ Μαδιανίτῃ τῷ γαμβρῷ Μωυσῆ, ἐξαίρομεν ἡμεῖς εἰς τὸν τόπον ὃν εἶπε Κύριος, τοῦτον δώσω ὑμῖν· δεῦρο μεθʼ ἡμῶν, καὶ εὖ σε ποιήσομεν, ὅτι Κύριος ἐλάλησε καλὰ περὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Καὶ εἶπε πρὸς αὐτόν, οὐ πορεύσομαι, ἀλλὰ εἰς τὴν γῆν μου, καὶ εἰς τὴν γενεάν μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Καὶ εἶπε, μὴ ἐγκαταλίπῃς ἡμᾶς, οὗ ἕνεκεν ἦσθα μεθʼ ἡμῶν ἐν τῇ ἐρήμῳ, καὶ ἔσῃ ἐν ἡμῖν πρεσβύτης. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Καὶ ἔσται ἐὰν πορευθῇς μεθʼ ἡμῶν, καὶ ἔσται τὰ ἀγαθὰ ἐκεῖνα ὅσα ἂν ἀγαθοποιήσῃ Κύριος ἡμᾶς, καὶ εὖ σε ποιήσομεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Καὶ ἐξῇραν ἐκ τοῦ ὄρους Κυρίου ὁδὸν τριῶν ἡμερῶν· καὶ ἡ κιβωτὸς τῆς διαθήκης Κυρίου προεπορεύετο προτέρα αὐτῶν ὁδὸν τριῶν ἡμερῶν κατασκέψασθαι αὐτοῖς ἀνάπαυσιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Καὶ ἐγένετο ἐν τῷ ἐξαίρειν τὴν κιβωτὸν, καὶ εἶπε Μωυσῆς, ἐξεγέρθητι Κύριε, καὶ διασκορπισθήτωσαν οἱ ἐχθροί σου, φυγέτωσαν πάντες οἱ μισοῦντές σε. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Καὶ ἐν τῇ καταπαύσει εἶπεν, ἐπίστρεφε Κύριε χιλιάδας μυριάδας ἐν τῷ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Καὶ ἡ νεφέλη ἐγένετο σκιάζουσα ἐπʼ αὐτοῖς ἡμέρας, ἐν τῷ ἐξαίρειν αὐτοὺς ἐκ τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Καὶ ἦν ὁ λαὸς γογγύζων πονηρὰ ἔναντι Κυρίου· καὶ ἤκουσε Κύριος, καὶ ἐθυμώθη ὀργῇ· καὶ ἐξεκαύθη ἐν αὐτοῖς πῦρ παρὰ Κυρίου, καὶ κατέφαγε μέρος τι τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Καὶ ἐκέκραξεν ὁ λαὸς πρὸς Μωυσῆν· καὶ ηὔξατο Μωυσῆς πρὸς Κύριον, καὶ ἐκόπασε τὸ πῦρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Καὶ ἐκλήθη τὸ ὄνομα τοῦ τόπου ἐκείνου, Ἐμπυρισμός· ὅτι ἐξεκαύθη ἐν αὐτοῖς παρὰ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Καὶ ὁ ἐπίμικτος ὁ ἐν αὐτοῖς ἐπεθύμησεν ἐπιθυμίαν· καὶ καθίσαντες ἔκλαιον καὶ οἱ υἱοὶ Ἰσραὴλ, καὶ εἶπαν, τίς ἡμᾶς ψωμιεῖ κρέα; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ἐμνήσθημεν τοὺς ἰχθύας, οὓς ἠσθίομεν ἐν Αἰγύπτῳ δωρεὰν. καὶ τοὺς σικύας, καὶ τοὺς πέπονας, καὶ τὰ πράσα, καὶ τὰ κρόμμυα, καὶ τὰ σκόρδα. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Νυνὶ δὲ ἡ ψυχὴ ἡμῶν κατάξηρος· οὐδὲν πλὴν εἰς τὸ μάννα οἱ ὀφθαλμοὶ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Τὸ δὲ μάννα ὡσεὶ σπέρμα κορίου ἐστὶ, καὶ τὸ εἶδος αὐτοῦ εἶδος κρυστάλλου. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Καὶ διεπορεύετο ὁ λαὸς, καὶ συνέλεγον, καὶ ἤληθον αὐτὸ ἐν τῷ μύλῳ, καὶ ἔτριβον ἐν τῇ θυΐᾳ, καὶ ἥψουν αὐτὸ ἐν τῇ χύτρᾳ, καὶ ἐποίουν αὐτὸ ἐνκρυφίας· καὶ ἦν ἡ ἡδονὴ αὐτοῦ ὡσεὶ γεῦμα ἐγκρὶς ἐξ ἐλαίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Καὶ ὅταν κατέβη ἡ δρόσος ἐπὶ τὴν παρεμβολὴν νυκτὸς, κατέβαινε τὸ μάννα ἐπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Καὶ ἤκουσε Μωυσῆς κλαίοντων αὐτῶν κατά δήμους αὐτῶν, ἕκαστον ἐπὶ τῆς θύρας αὐτοῦ· καὶ ἐθυμώθη ὀργῇ Κύριος σφόδρα· καὶ ἔναντι Μωυσῆ ἦν πονηρόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Καὶ εἶπε Μωυσῆς πρὸς Κύριον, ἱνατί ἐκάκωσας τὸν θεράποντά σου, καὶ διατί οὐχ εὕρηκα χάριν ἐναντίον σου, ἐπιθεῖναι τὴν ὁρμὴν τοῦ λαοῦ τούτου ἐπʼ ἐμέ; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Μὴ ἐγὼ ἐν γαστρὶ ἔλαβον πάντα τὸν λαὸν τοῦτον, ἢ ἐγὼ ἔτεκον αὐτούς; ὅτι λέγεις μοι, λάβε αὐτὸν εἰς τὸν κόλπον σου, ὡσεὶ ἄραι τιθηνὸς τὸν θηλάζοντα, εἰς τὴν γῆν ἣν ὤμοσας τοῖς πατράσιν αὐτῶν; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Πόθεν μοι κρέα, δοῦναι παντὶ τῷ λαῷ τούτῳ; ὅτι κλαίουσιν ἐπʼ ἐμοὶ, λέγοντες, δὸς ἡμῖν κρέα, ἵνα φάγωμεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Οὐ δυνήσομαι ἐγὼ μόνος φέρειν τὸν λαὸν τοῦτον, ὅτι βαρύτερόν μοι ἐστὶ τὸ ῥῆμα τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Εἰ δʼ οὕτω σὺ ποιεῖς μοι, ἀπόκτεινόν με ἀναιρέσει, εἰ εὕρηκα ἔλεος παρὰ σοὶ, ἵνα μὴ ἴδω τὴν κάκωσίν μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Καὶ εἶπε Κύριος πρὸς Μωυσῆς, συνάγαγέ μοι ἑβδομήκοντα ἄνδρας ἀπὸ τῶν πρεσβυτέρων Ἰσραήλ, οὓς αὐτὸς σὺ οἶδας, ὅτι οὗτοί εἰσι πρεσβύτεροι τοῦ λαοῦ καὶ γραμματεῖς αὐτῶς· καὶ ἄξεις αὐτοὺς πρὸς τὴν σκηνὴν τοῦ μαρτυρίου, καὶ στήσονται ἐκεῖ μετὰ σοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Καὶ καταβήσομαι, καὶ λαλήσω ἐκεῖ μετὰ σοῦ· καὶ ἀφελῶ ἀπὸ τοῦ πνεύματος τοῦ ἐπὶ σοὶ, καὶ ἐπιθήσω ἐπʼ αὐτούς· καὶ συναντιλήψονται μετὰ σοῦ τὴν ὁρμὴν τοῦ λαοῦ, καὶ οὐκ οἴσεις αὐτὸς σὺ μόνος. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Καὶ τῷ λαῷ ἐρεῖς, ἁγνίσασθε εἰς αὔριον, καὶ φάγεσθε κρέα· ὅτι ἐκλαύσατε ἔναντι Κυρίου, λέγοντες, τίς ἡμᾶς ψωμιεῖ κρέα; ὅτι καλὸν ἡμῖν ἐστιν ἐν Αἰγυπτῳ· καὶ δώσει Κύριος ὑμῖν φαγεῖν κρέα, καὶ φάγεσθε κρέα. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Οὐχ ἡμέραν μίαν φάγεσθε, οὐ δὲ δύο, οὐ δὲ πέντε ἡμέρας, οὐ δὲ δέκα ἡμέρας, οὐ δὲ εἴκοσι ἡμέρας, ");
INSERT INTO grcbrent_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ἕως μηνὸς ἡμερῶν φάγεσθε, ἕως ἂν ἐξέλθῃ ἐκ τῶν μυκτήρων ὑμῶν· καὶ ἔσται ὑμῖν εἰς χολέραν, ὅτι ἠπειθήσατε Κυρίῳ, ὅς ἐστιν ἐν ὑμῖν, καὶ ἐκλαύσατε ἐναντίον αὐτοῦ, λέγοντες, ἱνατί ἡμῖν ἐξελθεῖν ἐξ Αἰγύπτου; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Καὶ εἶπε Μωυσῆς, ἑξακόσιαι χιλιάδες πεζῶν ὁ λαὸς, ἐν οἷς εἰμι ἐν αὐτοῖς· καὶ σὺ εἶπας, κρέα δώσω αὐτοῖς φαγεῖν, καὶ φάγονται μῆνα ἡμερῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Μὴ πρόβατα καὶ βόες σφαγήσονται αὐτοῖς, καὶ ἀρκέσει αὐτοῖς; ἢ πᾶν τὸ ὄψος τῆς θαλάσσης συναχθήσεται αὐτοῖς, καὶ ἀρκέσει αὐτοῖς; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, μὴ χεὶρ Κυρίου οὐκ ἐξαρκέσει; ἤδη γνώσῃ εἰ ἐπικαταλήμψεταί σε ὁ λόγος μου ἢ οὔ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Καὶ ἐξῆλθε Μωυσῆς, καὶ ἐλάλησε πρὸς τὸν λαὸν τὰ ῥήματα Κυρίου· καὶ συνήγαγεν ἑβδομήκοντα ἄνδρας ἀπὸ τῶν πρεσβυτέρων τοῦ λαοῦ, καὶ ἔστησεν αὐτὸς κύκλῳ τῆς σκηνῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Καὶ κατέβη Κύριος ἐν νεφέλῃ, καὶ ἐλάλησε πρὸς αὐτόν· καὶ παρείλατο ἀπὸ τοῦ πνεύματος τοῦ ἐπʼ αὐτῷ, καὶ ἐπέθηκεν ἐπὶ τοὺς ἑβδομήκοντα ἄνδρας τοὺς πρεσβυτέρους· ὡς δὲ ἐπανεπαύσατο πνεῦμα ἐπʼ αὐτοὺς, καὶ ἐπροφήτευσαν, καὶ οὐκ ἔτι προσέθεντο. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Καὶ κατελείφθησαν δύο ἄνδρες ἐν τῇ παρεμβολῇ, ὄνομα τῷ ἑνὶ Ἑλδὰδ, καὶ ὄνομα τῷ δευτέρῳ Μωδάδ· καὶ ἐπανεπαύσατο ἐπʼ αὐτοὺς πνεῦμα· καὶ οὗτοι ἦσαν τῶν καταγεγραμμένων, καὶ οὐκ ἦλθον πρὸς τὴν σκηνήν· καὶ ἐπροφήτευσαν ἐν τῇ παρεμβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Καὶ προσδραμὼν ὁ νεανίσκος, ἀπήγγειλε Μωυσῇ· καὶ εἶπε, λέγων, Ἑλδὰδ καὶ Μωδὰδ προφητεύουσιν ἐν τῇ παρεμβολῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Καὶ ἀποκριθεὶς Ἰησοῦς ὁ τοῦ Ναυὴ, ὁ παρεστηκὼς Μωυσῇ, ὁ ἐκλεκτὸς, εἶπε, κύριε Μωυσῆ, κώλυσον αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Καὶ εἶπε Μωυσῆς αὐτῷ, μὴ ζηλοῖς ἐμέ; καὶ τίς δῴη πάντα τὸν λαὸν Κυρίου προφήτας, ὅταν δῷ Κύριος τὸ πνεῦμα αὐτοῦ ἐπʼ αὐτούς; ");
INSERT INTO grcbrent_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Καὶ ἀπῆλθε Μωυσῆς εἰς τὴν παρεμβολὴν αὐτὸς καὶ οἱ πρεσβύτεροι Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Καὶ πνεῦμα ἐξῆλθε παρὰ Κυρίου, καὶ ἐξεπέρασεν ὀρτυγομήτραν ἀπὸ τῆς θαλάσσης· καὶ ἐπέβαλεν ἐπὶ τὴν παρεμβολὴν ὁδὸν ἡμέρας ἐντεῦθεν, καὶ ὁδὸν ἡμέρας ἐντεῦθεν, κύκλῳ τῆς παρεμβολῆς, ὡσεὶ δίπηχυ ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Καὶ ἀναστὰς ὁ λαὸς ὅλην τὴν ἡμέραν, καὶ ὅλην τὴν νύκτα, καὶ ὅλην τὴν ἡμέραν τὴν ἐπαύριον, καὶ συνήγαγον τὴν ὀρτυγομήτραν· ὁ τὸ ὀλίγον, συνήγαγε δέκα κόρους· καὶ ἔψυξαν ἑαυτοῖς ψυγμοὺς κύκλῳ τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Τὰ κρέα ἔτι ἦν ἐν τοῖς ὀδοῦσιν αὐτῶν πρινὴ ἐκλείπειν, καὶ Κύριος ἐθυμώθη εἰς τὸν λαὸν, καὶ ἐπάταξε Κύριος τὸν λαὸν πληγὴν μεγάλην σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Καὶ ἐκλήθη τὸ ὄνομα τοῦ τόπου ἐκείνου, Μνήματα τῆς ἐπιθυμίας· ὅτι ἐκεῖ ἔθαψαν τὸν λαὸν τὸν ἐπιθυμητήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ἀπὸ Μνημάτων ἐπιθυμίας ἐξῇρεν ὁ λαὸς εἰς Ἀσηρώθ· καὶ ἐγένετο ὁ λαὸς ἐν Ἀσηρώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Καὶ ἐλάλησε Μαριὰμ καὶ Ἀαρὼν κατὰ Μωυσῆ, ἕνεκεν τῆς γυναικὸς τῆς Αἰθιοπίσσης ἣν ἔλαβε Μωυσῆς, ὅτι γυναῖκα Αἰθιόπισσαν ἔλαβε, ");
INSERT INTO grcbrent_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","καὶ εἶπαν, μὴ Μωυσῇ μόνῳ λελάληκε Κύριος; οὐχὶ καὶ ἡμῖν ἐλάλησε; καὶ ἤκουσε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Καὶ ὁ ἄνθρωπος Μωυσῆς πραῢς σφόδρα παρὰ πάντας τοὺς ἀνθρώπους τοὺς ὄντας ἐπὶ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Καὶ εἶπε Κύριος παραχρῆμα πρὸς Μωυσῆν καὶ Ἀαρὼν καὶ Μαριὰμ, ἐξέλθετε ὑμεῖς οἱ τρεῖς εἰς τὴν σκηνὴν τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Καὶ ἐξῆλθον οἱ τρεῖν εἰν τὴν σκηνὴν τοῦ μαρτυρίου· καὶ κατέβη Κύριος ἐν στύλῳ νεφέλης, καὶ ἔστη ἐπὶ τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου· καὶ ἐκλήθησαν Ἀαρὼν καὶ Μαριάμ· καὶ ἐξήλθοσαν ἀμφότεροι. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Καὶ εἶπε πρὸς αὐτοὺς, ἀκούσατε τῶν λόγων μου· ἐὰν γένηται προφήτης ὑμῶν Κυρίῳ, ἐν ὁράματι αὐτῷ γυωσθήσομαι, καὶ ἐν ὕπνῳ λαλήσω αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Οὐχ οὕτως ὁ θεράπων μου Μωυσῆς, ἐν ὅλῳ τῷ οἴκῳ μου πιστός ἐστι· ");
INSERT INTO grcbrent_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Στόμα κατὰ στόμα λαλήσω αὐτῶ, ἐν εἴδει, καὶ οὐ διʼ αἰνιγμάτων, καὶ τὴν δόξαν Κυρίου εἶδε· καὶ διατί οὐκ ἐφοβήθητε καταλαλῆσαι κατὰ τοῦ θεράποντός μου Μωυσῆ; ");
INSERT INTO grcbrent_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Καὶ ὀργὴ θυμοῦ Κυρίου ἐπʼ αὐτοῖς, καὶ ἀπῆλθε. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Καὶ ἡ νεφέλη ἀπέστη ἀπὸ τῆς σκηνῆς· καὶ ἰδοὺ Μαριὰμ λεπρῶσα ὡσεὶ χιών· καὶ ἐπέβλεψεν Ἀαρὼν ἐπὶ Μαριὰμ, καὶ ἰδοὺ λεπρῶσα. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Καὶ εἶπεν Ἀαρὼν πρὸς Μωυσῆν, δέομαι κύριε, μὴ συνεπιθῇ ἡμῖν ἁμαρτίαν, διότι ἠγνοήσαμεν καθʼ ὅτι ἡμάρτομεν· ");
INSERT INTO grcbrent_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Μὴ γένηται ὡσεὶ ἶσον θανάτῳ, ὡσεὶ ἔκτρωμα ἐκπορευόμενον ἐκ μήτρας μητρὸς, καὶ κατεσθίει τὸ ἥμισυ τῶν σαρκῶν αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Καὶ ἐβόησε Μωυσῆς πρὸς Κύριον, λέγων, ὁ Θεὸς δέομαί σου, ἴασαι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, εἰ ὁ πατὴρ αὐτῆς πτύων ἐνέπτυσεν εἰς τὸ πρόσωπον αὐτῆς οὐκ ἐντραπήσεται ἑπτὰ ἡμέρας; ἀφορισθήτω ἑπτὰ ἡμέρας ἔξω τῆς παρεμβολῆς, καὶ μετὰ ταῦτα εἰσελεύσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Καὶ ἀφωρίσθη Μαριὰμ ἔξω τῆς παρεμβολῆς ἑπτὰ ἡμέρας· καὶ ὁ λαὸς οὐκ ἐξῇρεν, ἕως ἐκαθαρίσθη Μαριάμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Καὶ μετὰ ταῦτα ἐξῇρεν ὁ λαὸς ἐξ Ἀσηρὼθ, καὶ παρενέβαλον ἐν τῇ ἐρήμῳ τοῦ Φαράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ἀπόστειλον σεαυτῷ ἄνδρας, ");
INSERT INTO grcbrent_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","καὶ κατασκεψάσθωσαν τὴν γῆν τῶν Χαναναίων, ἣν ἐγὼ δίδωμι τοῖς υἱοῖς Ἰσραὴλ εἰς κατάσχεσιν· ἄνδρα ἕνα κατὰ φυλήν, κατὰ δήμους πατριῶν αὐτῶν ἀποστελεῖς αὐτοὺς, πάντα ἀρχηγὸν ἐξ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Καὶ ἐξαπέστειλεν αὐτοὺς Μωυσῆς ἐκ τῆς ἐρήμου Φαρὰν διὰ φωνῆς Κυρίου· πάντες ἄνδρες ἀρχηγοὶ υἱῶν Ἰσραὴλ οὗτοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Καὶ ταῦτα τὰ ὀνόματα αὐτῶν· τῆς φυλῆς Ῥουβὴν, Σαμουὴλ υἱὸς Ζαχούρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Τῆς φυλῆς Συμεὼν, Σαφὰτ υἱὸς Σουρί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Τῆς φυλῆς Ἰούδα, Χάλεβ υἱὸς Ἰεφοννή. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Τῆς φυλῆς Ἰσσάχαρ, Ἰλαὰλ υἱὸς Ἰωσήφ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Τῆς φυλῆς Ἐφραὶμ, Αὐσὴ υἱὸς Ναυή. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Τῆς φυλῆς Βενιαμὶν, Φαλτὶ υἱὸς Ῥαφοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Τῆς φυλῆς Ζαβουλὼν, Γουδιὴλ υἱὸς Σουδί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Τῆς φυλῆς Ἰωσὴφ τῶν υἱῶν Μανασσῆ, Γαδδὶ υἱὸς Σουσί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Τῆς φυλῆς Δὰν, Ἀμιὴλ υἱὸς Γαμαλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Τῆς φυλῆς Ἀσὴρ, Σαθοὺρ υἱὸς Μιχαήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Τῆς φυλῆς Νεφθαλὶ, Ναβὶ υἱὸς Σαβί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Τῆς φυλῆς Γὰδ, Γουδιὴλ υἱὸς Μακχί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ταῦτα τὰ ὀνόματα τῶν ἀνδρῶν, οὓς ἀπέστειλε Μωυσῆς κατασκέψασθαι τὴν γῆν· καὶ ἐπωνόμασε Μωυσῆς τὸν Αὐσὴ υἱὸν Ναυὴ, Ἰησοῦν. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Καὶ ἀπέστειλεν αὐτοὺς Μωυσῆς κατασκέψασθαι τὴν γῆν Χαναὰν, καὶ εἶπε πρὸς αὐτοὺς, ἀνάβητε ταύτῃ τῇ ἐρήμῳ, καὶ ἀναβήσεσθε εἰς τὸ ὄρος, ");
INSERT INTO grcbrent_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","καὶ ὄψεσθε τὴν γῆν τίς ἐστι, καὶ τὸν λαὸν τὸν ἐγκαθήμενον ἐπʼ αὐτῆς, εἰ ἰσχυρός ἐστιν ἢ ἀσθενὴς, ἢ ὀλίγοι εἰσὶν ἢ πολλοί. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Καὶ τίς ἡ γῆ εἰς ἣν οὗτοι ἐγκάθηνται ἐπʼ αὐτῆς, ἢ καλή ἐστιν ἢ πονηρά· καὶ τίνες αἱ πόλεις ἃς οὗτοι κατοικοῦσιν ἐν αὐταῖς, εἰ ἐν τειχήρεσιν ἢ ἐν ἀτειχίστοις. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Καὶ τίς ἡ γῆ, ἢ πίων ἢ παρειμένη· εἰ ἔστιν ἐν αὐτῇ δένδρα, ἢ οὔ· καὶ προσκαρτερήσαντες λήψεσθε ἀπὸ τῶν καρπῶν τῆς γῆς. καὶ αἱ ἡμέραι, ἡμέραι ἔαρος, πρόδρομοι σταφυλῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Καὶ ἀναβάντες κατεσκέψαντο τὴν γῆν ἀπὸ τῆς ἐρήμου Σὶν ἕως Ῥοὸβ, εἰσπορευομένων Αἰμάθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Καὶ ἀνέβησαν κατὰ τὴν ἔρημον, καὶ ἀπῆλθον ἕως Χεβρὼν, καὶ ἐκεῖ Ἀχιμὰν, καὶ Σεσσὶ, καὶ Θελαμὶ, γενεαὶ Ἐνάχ· καὶ Χεβρὼν ἐπτὰ ἔτεσιν ᾠκοδομήθη πρὸ τοῦ Τανὶν Αἰγύπτου. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Καὶ ἤλθοσαν ἕως φάραγγος βότρυος, καὶ κατεσκέψαντο αὐτήν· καὶ ἔκοψαν ἐκεῖθεν κλῆμα καὶ βότρυν σταφυλῆς ἕνα ἐπʼ αὐτοῦ, καὶ ᾖραν αὐτὸν ἐπʼ ἀναφορεύσι, καὶ ἀπὸ τῶν ῥοῶν, καὶ ἀπὸ τῶν συκῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Καὶ τὸν τόπον ἐκεῖνον ἐπωνόμασαν Φάραγξ βότρυος, διὰ τὸν βότρυν, ὃν ἔκοψαν ἐκεῖθεν οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Καὶ ἀπέστρεψαν ἐκεῖθεν κατασκεψάμενοι τὴν γῆν μετὰ τεσσαράκοντα ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Καὶ πορευθέντες ἦλθον πρὸς Μωυσῆν καὶ Ἀαρὼν καὶ πρὸς πᾶσαν συναγωγὴν υἱῶν Ἰσραὴλ, εἰς τὴν ἔρημον Φαρὰν Κάδης· καὶ ἀπεκρίθησαν αὐτοῖς ῥῆμα καὶ πάσῃ συναγωγῇ, καὶ ἔδειξαν τὸν καρπὸν τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","καὶ διηγήσαντο αὐτῷ, καὶ εἶπαν, ἤλθαμεν εἰς τὴν γῆν εἰς ἣν ἀπέστειλας ἡμᾶς, γῆν ῥέουσαν γάλα καὶ μέλι· καὶ οὗτος ὁ καρπὸς αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ἀλλʼ ἢ ὅτι θρασὺ τὸ ἔθνος τὸ κατοικοῦν ἐπʼ αὐτῆς, καὶ πόλεις ὀχυραὶ τετειχισμέναι μεγάλαι σφόδρα· καὶ τὴν γενεὰν Ἐνὰχ ἑωράκαμεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Καὶ Ἀμαλὴκ κατοικεῖ ἐν τῇ γῇ τῇ πρὸς Νότον· καὶ ὁ Χετταῖος, καὶ ὁ Εὐαῖος, καὶ ὁ Ἰεβουσαῖος, καὶ ὁ Ἀμοῤῥαῖος κατοικεῖ ἐν τῇ ὀρεινῇ· καὶ ὁ Χαναναῖος κατοικεῖ παρὰ θάλασσαν, καὶ παρὰ τὸν Ἰορδάνην ποταμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Καὶ κατεσιώπησε Χάλεβ τὸν λαὸν πρὸς Μωυσῆν, καὶ εἶπεν αὐτῷ, οὐχὶ, ἀλλὰ ἀναβάντες ἀναβησόμεθα, καὶ κατακληρονομήσομεν αὐτὴν, ὅτι δυνατοὶ δυνησόμεθα πρὸς αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Καὶ οἱ ἄνθρωποι οἱ συναναβάντες μετʼ αὐτοῦ, εἶπαν, οὐκ ἀναβαίνομεν, ὅτι οὐ μὴ δυνώμεθα ἀναβῆναι πρὸς τὸ ἔθνος, ὅτι ἰσχυρότερον ἡμῶν ἐστι μᾶλλον. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Καὶ ἐξήνεγκαν ἔκστασιν τῆς γῆς ἣν κατεσκέψαντο αὐτὴν πρὸς τοὺς υἱοὺς Ἰσραὴλ, λέγοντες, τὴν γῆς ἣν παρήλθομεν αὐτὴν κατασκέψασθαι, γῆ κατέσθουσα τοὺς κατοικοῦντας ἐπʼ αὐτῆς ἐστι· καὶ πᾶς ὁ λαὸς ὃν ἑωράκαμεν ἐν αὐτῇ, ἄνδρες ὑπερμήκεις. ");
INSERT INTO grcbrent_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Καὶ ἐκεῖ ἑωράκαμεν τοὺς γίγαντας, καὶ ἦμεν ἐνώπιον αὐτῶν ὡσεὶ ἀκρίδες· ἀλλὰ καὶ οὕτως ἦμεν ἐνώπιον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Καὶ ἀναλαβοῦσα πᾶσα ἡ συναγωγὴ, ἐνέδωκε φωνήν· καὶ ἔκλαιεν ὁ λαὸς ὅλην τὴν νύκτα ἐκείνην. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Καὶ διεγόγγυζον ἐπὶ Μωυσῆν καὶ Ἀαρὼν πάντες οἱ υἱοὶ Ἰσραήλ· καὶ εἶπαν πρὸς αὐτοὺς πᾶσα ἡ συναγωγὴ, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ὄφελον ἀπεθάνομεν ἐν γῇ Αἰγύπτῳ, ἢ ἐν τῇ ἐρήμῳ ταύτῃ, εἰ ἀπεθάνομεν· καὶ ἱνατί Κύριος εἰσάγει ἡμᾶς εἰς τὴν γῆν ταύτην πεσεῖν ἐν πολέμῳ; αἱ γυναῖκες ἡμῶν καὶ τὰ παιδία ἔσονται εἰς διαρπαγήν· νῦν οὖν βέλτιόν ἐστιν ἀποστραφῆναι εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Καὶ εἶπαν ἕτερος τῷ ἑτέρῳ, δῶμεν ἀρχηγὸν, καὶ ἀποστρέψωμεν εἰς Αἴγυπτον. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Καὶ ἔπεσε Μωυσῆς καὶ Ἀαρὼν ἐπὶ πρόσωπον ἐναντίον πάσης συναγωγῆς υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ἰησοῦς δὲ ὁ τοῦ Ναυὴ, καὶ Χάλεβ ὁ τοῦ Ἰεφοννὴ τῶν κατασκεψαμένων τὴν γῆν, διέῤῥηξαν τὰ ἱμάτια αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","καὶ εἶπαν πρὸς πᾶσαν συναγωγὴν υἱῶν Ἰσραὴλ, λέγοντες, ἡ γῆ ἣν κατεσκεψάμεθα αὐτὴν, ἀγαθή ἐστι σφόδρα σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Εἰ αἱρετίζει ἡμᾶς Κύριος, εἰσάξει ἡμᾶς εἰς τὴν γῆν ταύτην, καὶ δώσει αὐτὴν ἡμῖν· γῆ ἥτις ἐστὶ ῥέουσα γάλα καὶ μέλι. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ἀλλὰ ἀπὸ τοῦ Κυρίου μὴ ἀποστάται γίνεσθε· ὑμεῖς δὲ μὴ φοβηθῆτε τὸν λαὸν τῆς γῆς, ὅτι κατάβρωμα ὑμῖν ἐστιν· ἀφέστηκε γὰρ ὁ καιρὸς ἀπʼ αὐτῶν· ὁ δὲ Κύριος ἐν ἡμῖν· μὴ φοβηθήτε αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Καὶ εἶπε πᾶσα ἡ συναγωγὴ καταλιθοβολῆσαι αὐτοὺς ἐν λίθοις· καὶ ἡ δόξα Κυρίου ὤφθη ἐν τῇ νεφέλῃ ἐπὶ τῆς σκηνῆς τοῦ μαρτυρίου πᾶσι τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἕως τίνος παροξύνει με ὁ λαὸς οὗτος; καὶ ἕως τίνος οὐ πιστεύουσί μοι ἐπὶ πᾶσι τοῖς σημείοις, οἷς ἐποίησα ἐν αὐτοῖς; ");
INSERT INTO grcbrent_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Πατάξω αὐτοὺς θανάτῳ, καὶ ἀπολῶ αὐτούς· καὶ ποιήσω σε καὶ τὸν οἶκον τοῦ πατρός σου εἰς ἔθνος μέγα, καὶ πολὺ μᾶλλον ἢ τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Καὶ εἶπε Μωυσῆς πρὸς Κύριον, καὶ ἀκούσεται Αἴγυπτος, ὅτι ἀνήγαγες τῇ ἰσχύϊ σου τὸν λαὸν τοῦτον ἐξ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ἀλλὰ καὶ πάντες οἱ κατοικοῦντες ἐπὶ τῆς γῆς ταύτης ἀκηκόασιν, ὅτι σὺ εἶ Κύριος ἐν τῷ λαῷ τούτῷ, ὅστις ὀφθαλμοῖς κατʼ ὀφθαλμοὺς ὀπτάζῃ Κύριε, καὶ ἡ νεφέλη σου ἐφέστηκεν ἐπʼ αὐτῶν, καὶ ἐν στύλῳ νεφέλης σὺ πορεύῃ πρότερος αὐτῶν τὴν ἡμέραν, καὶ ἐν στύλῳ πυρὸς τὴν νύκτα. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Καὶ ἐκτρίψεις τὸν λαὸν τοῦτον ὡσεὶ ἄνθρωπον ἕνα· καὶ ἐροῦσι τὰ ἔθνη ὅσοι ἀκηκόασι τὸ ὄνομά σου, λέγοντες, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","παρὰ τὸ μὴ δύνασθαι Κύριον εἰσαγαγεῖν τὸν λαὸν τοῦτον εἰς τὴν γῆν ἣν ὤμοσεν αὐτοῖς, κατέστρωσεν αὐτοὺς ἐν τῇ ἐρήμῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Καὶ νῦν ὑψωθήτω ἡ ἰσχύς σου Κύριε, ὃν τρόπον εἶπας, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Κύριος μακρόθυμος, καὶ πολυέλεος, καὶ ἀληθινὸς, ἀφαιρῶν ἀνομίας καὶ ἀδικίας καὶ ἁμαρτίας, καὶ καθαρισμῷ οὐ καθαριεῖ τὸν ἔνοχον, ἀποδιδοὺς ἁμαρτίας πατέρων ἐπὶ τέκνα ἕως τρίτης καὶ τετάρτης γενεᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ἄφες τὴν ἁμαρτίαν τῷ λαῷ τούτῳ κατὰ τὸ μέγα ἔλεός σου, καθάπερ ἵλεως ἐγένου αὐτοῖς ἀπʼ Αἰγύπτου ἕως τοῦ νῦν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἵλεως αὐτοῖς εἰμι κατὰ τὸ ῥῆμά σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ἀλλὰ ζῶ ἐγὼ καὶ ζῶν τὸ ὄνομά μου, καὶ ἐμπλήσει ἡ δόξα Κυρίου πᾶσαν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ὅτι πάντες οἱ ἄνδρες οἱ ὁρώντες τὴν δόξαν μου, καὶ τὰ σημεῖα ἃ ἐποίησα ἐν Αἰγύπτῳ, καὶ ἐν τῇ ἐρήμῳ, καὶ ἐπείρασάν με τοῦτο δέκατον, καὶ οὐκ εἰσήκουσαν τῆς φωνῆς μου, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ἦ μὴν οὐκ ὄψονται τὴν γῆν, ἣν ὤμοσα τοῖς πατράσιν αὐτῶν· ἀλλʼ ἢ τὰ τέκνα αὐτῶν ἅ ἐστι μετʼ ἐμοῦ ὧδε, ὅσοι οὐκ οἴδασιν ἀγαθὸν οὐδὲ κακὸν, πᾶς νεώτερος ἄπειρος, τούτοις δώσω τὴν γῆν· πάντες δὲ οἱ παροξύναντές με, οὐκ ὄψονται αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ὁ δὲ παῖς μου Χάλεβ, ὅτι πνεῦμα ἕτερον ἐν αὐτῷ, καὶ ἐπηκολούθησέ μοι, εἰσάξω αὐτὸν εἰς τὴν γῆν εἰς ἣν εἰσῆλθεν ἐκεῖ, καὶ τὸ σπέρμα αὐτοῦ κληρονομήσει αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ὁ δὲ Ἀμαλὴκ καὶ ὁ Χαναναῖος κατοικοῦσιν ἐν τῇ κοιλάδι· αὔριον ἐπιστράφητε καὶ ἀπάρατε ὑμεῖς εἰς τὴν ἔρημον, ὁδὸν θάλασσαν ἐρυθρᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Καὶ εἶπε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ἕως τίνος τὴν συναγωγὴν τὴν πονηρὰν ταύτην; ἅ αὐτοὶ γογγύζουσιν ἐναντίον μου, τὴν γόγγυσιν τῶν υἱῶν Ἰσραὴλ, ἣν ἐγόγγυσαν περὶ ὑμῶν, ἀκήκοα. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Εἶπον αὐτοῖς, ζῶ ἐγὼ, λέγει Κύριος· ἦ μὴν ὃν τρόπον λελαλήκατε εἰς τὰ ὦτά μου, οὕτω ποιήσω ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ἐν τῇ ἐρήμῳ ταύτῃ πεσεῖται τὰ κῶλα ὑμῶν· καὶ πᾶσα ἡ ἐπισκοπὴ ὑμῶν, καὶ οἱ κατηριθμημένοι ὑμῶν ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, ὅσοι ἐγόγγυσαν ἐπʼ ἐμοί· ");
INSERT INTO grcbrent_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","εἰ ὑμεῖς εἰσελεύσεσθε εἰς τὴν γῆν ἐφʼ ἣν ἐξέτεινα τὴν χεῖρά μου κατασκηνῶσαι ὑμᾶς ἐπʼ αὐτῆς· ἀλλʼ ἢ Χάλεβ υἱὸς Ἰεφοννὴ, καὶ Ἰησοῦς ὁ τοῦ Ναυὴ. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Καὶ τὰ παιδία, ἃ εἴπατε ἐν διαρπαγῇ ἔσεσθαι, εἰσάξω αὐτοὺς εἰς τὴν γῆν· καὶ κληρονομήσουσι τὴν γῆν, ἣν ὑμεῖς ἁπέστητε ἀπʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Καὶ τὰ κῶλα ὑμῶν πεσεῖται ἐν τῇ ἐρήμῳ ταύτῃ. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Οἱ δὲ υἱοὶ ὑμῶν ἔσονται νεμόμενοι ἐν τῇ ἐρήμῳ τεσσαράκοντα ἔτη· καὶ ἀνοίσουσι τὴν πορνείαν ὑμῶν, ἕως ἂν ἀναλωθῇ τὰ κῶλα ὑμῶν ἐν τῇ ἐρήμῳ, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","κατὰ τὸν ἀριθμὸν τῶν ἡμερῶν ὅσας κατεσκέψασθε τὴν γῆν, τεσσαράκοντα ἡμέρας, ἡμέραν τοῦ ἐνιαυτοῦ, λήμψεσθε τὰς ἁμαρτίας ὑμῶν τεσσαράκοντα ἔτη· καὶ γνώσεσθε τὸν θυμὸν τῆς ὀργῆς μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ἐγὼ Κύριος ἐλάλησα, ἦ μὴν οὕτω ποιήσω τῇ συναγωγῇ τῇ πονηρᾷ ταύτῃ, τῇ ἐπισυνισταμένῃ ἐπʼ ἐμέ· ἐν τῇ ἐρήμῳ ταύτη ἐξαναλωθήσονται, καὶ ἐκεῖ ἀποθανοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Καὶ οἱ ἄνθρωποι, οὓς ἀπέστειλεν Μωυσῆς κατασκέψασθαι τὴν γῆν, καὶ παραγενηθέντες διεγόγγυσαν κατʼ αὐτῆς πρὸς τὴν συναγωγὴν ἐξενέγκαι ῥήματα πονηρὰ περὶ τῆς γῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","καὶ ἀπέθανον οἱ ἄνθρωποι οἱ κατείπαντες πονηρὰ κατὰ τῆς γῆς ἐν τῇ πληγῇ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Καὶ Ἰησοῦς υἱὸς Ναυὴ καὶ Χάλεβ υἱὸς Ἰεφοννὴ ἔζησαν ἀπὸ τῶν ἀνθρώπων ἐκείνων τῶν πεπορευμένων κατασκέψασθαι τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Καὶ ἐλάλησε Μωυσῆς τὰ ῥήματα ταῦτα πρὸς πάντας υἱοὺς Ἰσραήλ· καὶ ἐπενθησεν ὁ λαὸς σφόδρα. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Καὶ ὀρθρίσαντες τοπρωῒ ἀνέβησαν εἰς τὴν κορυφὴν τοῦ ὄρους, λέγοντες, ἰδοὺ, οἵδε ἡμεῖς ἀναβησόμεθα εἰς τὸν τόπον ὃν εἶπε Κύριος, ὅτι ἡμάρτομεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Καὶ εἶπε Μωυσῆς, ἱνατί ὑμεῖς παραβαίνετε τὸ ῥῆμα Κυρίου; οὐκ εὔοδα ἔσται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Μὴ ἀναβαίνετε, οὐ γάρ ἐστι Κύριος μεθʼ ὑμῶν· καὶ πεσεῖσθε πρὸ προσώπου τῶν ἐχθρῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ὅτι ὁ Ἀμαλὴκ καὶ ὁ Χαναναῖος ἐκεῖ ἔμπροσθεν ὑμῶν, καὶ πεσεῖσθε μαχαίρᾳ, οὗ εἵνεκεν ἀπεστράφητε ἀπειθοῦντες Κυρίῳ, καὶ οὐκ ἔσται Κύριος ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Καὶ διαβιασάμενοι, ἀνέβησαν ἐπὶ τὴν κορυφὴν τοῦ ὄρους· ἡ δὲ κιβωτὸς τῆς διαθήκης Κυρίου καὶ Μωυσῆς οὐκ ἐκινήθησαν ἐκ τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Καὶ κατέβη ὁ Ἀμαλὴκ καὶ ὁ Χαναναῖος ὁ ἐνκαθήμενος ἐν τῷ ὄρει ἐκείνῳ, καὶ ἐτρέψαντο αὐτοὺς, καὶ κατέκοψαν αὐτοὺς ἕως Ἑρμάν· καὶ ἀπεστράφησαν εἰς τὴν παρεμβολήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, λάλησον τοῖς ὑοῖς Ἰσραὴλ, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","καὶ ἐρεῖς πρὸς αὐτούς, ὅταν εἰσέλθητε εἰς τὴν γῆν τῆς κατοικήσεως ὑμῶν, ἣν ἐγὼ δίδωμι ὑμῖν, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","καὶ ποιήσεις ὁλοκαυτώματα Κυρίῳ, ὁλοκάρπωμα ἢ θυσίαν, μεγαλῦναι εὐχὴν, ἢ καθʼ ἑκούσιον, ἢ ἐν ταῖς ἑορταῖς ὑμῶν ποιῆσαι ὀσμὴν εὐωδίας τῷ Κυρίῳ, εἰ μὲν ἀπὸ τῶν βοῶν ἢ ἀπὸ τῶν προβάτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Καὶ προσοίσει ὁ προσφέρων τὸ δῶρον αὐτοῦ Κυρίῳ, θυσίαν σεμιδάλεως δέκατον τοῦ οἰφί ἀναπεποιημένης ἐν ἐλαίῳ ἐν τετάρτῳ τοῦ ἴν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Καὶ οἶνον εἰς σπονδὴν τὸ τέταρτον τοῦ ἴν ποιήσετε ἐπὶ τῆς ὁλοκαυτώσεως, ἢ ἐπὶ τῆς θυσίας· τῷ ἀμνῷ τῷ ἑνὶ ποιήσεις τοσοῦτο, κάρπωμα ὀσμὴν εὐωδίας τῷ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Καὶ τῷ κριῷ, ὅταν ποιῆτε αὐτὸν εἰς ὁλοκαύτωμα ἢ εἰς θυσίαν, ποιήσεις θυσίαν σεμιδάλεως δύο δέκατα ἀναπεποιημένης ἐν ἐλαίῳ τὸ τρίτον τοῦ ἴν· ");
INSERT INTO grcbrent_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Καὶ οἶνον εἰς σπονδὴν τὸ τρίτον τοῦ ἴν προσοίσετε εἰς ὀσμὴν εὐωδίς Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ἐὰν δὲ ποιῆτε ἀπὸ τῶν βοῶν εἰς ὁλοκαύτωσιν ἤ εἰς θυσίαν μεγαλῦναι εὐχὴν, ἢ εἰς σωτήριον Κυρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","καὶ προσοίσει ἐπὶ τοῦ μόσχου θυσίαν σεμιδάλεως τρία δέκατα ἀναπεποιημένης ἐν ἐλαίῳ ἥμισυ τοῦ ἴν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Καὶ οἶνον εἰς σπονδὴν τὸ ἥμιου τοῦ ἴν, κάρπωμα ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Οὕτω ποιήσεις τῷ μόσχῳ τῷ ἑνὶ, ἢ τῷ κριῷ τῷ ἑνὶ, ἢ τῷ ἀμνῷ τῷ ἑνὶ ἐκ τῶν προβάτων ἢ ἐκ τῶν αἰγῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Κατὰ τὸν ἀριθμὸν ὧν ἐὰν ποιήσντε, οὕτως ποιήσετε τῷ ἑνὶ, κατὰ τὸν ἀριθμὸν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Πᾶς ὁ αὐτόχθων ποιήσει οὕτως τοιαῦτα προσενέγκαι καρπώματα εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ἐὰν δὲ προσήλυτος ἐν ὑμῖν προσγένηται ἐν τῇ γῇ ὑμῶν, ἢ ὂς ἂν γένηται ἐν ὑμῖν ἐν ταῖς γενεαῖς ὑμῶν, καὶ ποιήσει κάρπωμα ὀσμὴν εὐωδίας Κυρίῳ, ὃν τρόπον ποιεῖτε ὑμεῖς, οὕτω ποιήσει ἡ συναγωγὴ Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Νόμος εἷς ἔσται ὑμῖν καὶ τοῖς προσηλύτοις τοῖς προσκειμένοις ἐν ὑμῖν, νὀμος αἰώνιος εἰς τὰς γενεὰς ὑμῶν· ὡς ὑμεῖς, καὶ ὁ προσήλυτος ἔσται ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Νόμος εἷς ἔσται καὶ δικαίωμα ἓν ἔσται ὑμῖν καὶ τῷ προσηλύτῳ τῷ προσκειμένῳ ἐν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ἐν τῷ εἰσπορεύεσθαι ὑμᾶς εἰς τὴν γῆν, εἰς ἣν ἐγὼ εἰσάγω ὑμᾶς ἐκεῖ, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","καὶ ἔσται ὅταν ἔσθητε ὑμεῖς ἀπὸ τῶν ἄρτων τῆς γῆς, ἀφελεῖτε ἀφαίρεμα ἀφόρισμα Κυρίῳ, ἀπαρχὴν φυράματον ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ἄρτον ἀφοριεῖτε ἀφαίρεμα αὐτό· ὡς ἀφαίρεμα ἀπὸ ἅλω, οὕτως ἀφελεῖτε αὐτὸν, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ἀπαρχὴν φυράματος ὑμῶν, καὶ δώσετε Κυρίῳ ἀφαίρεμα εἰς τὰς γενεὰς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Ὅταν δὲ διαμάρτητε καὶ μὴ ποιήσητε πάσας τὰς ἐντολὰς ταύτας, ἅς ἐλάλησε Κύριος πρὸς Μωυσῆν, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","καθὰ συνέταξε Κύριος πρὸς ὑμᾶς ἐν χειρὶ Μωυσῆ, ἀπὸ τῆς ἡμέρας ᾗ συνέταξε Κύριος πρὸς ὑμᾶς καὶ ἐπέκεινα εἰς τὰς γενεὰς ὑμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","καὶ ἔσται ἐὰν ἐξ ὀφθαλμῶν τῆς συναγωγῆς γενηθῇ ἀκουσίως, καὶ ποιήσει πᾶσα ἡ συναγωγὴ μόσχον ἕνα ἐκ βοῶν ἄμωμον εἰς ὁλοκαύτωμα εἰς ὀσμὴν εὐωδίας Κυρίῳ, καὶ θυσίαν τούτου καὶ σπονδὴν αὐτοῦ κατὰ τὴν σύνταξιν, καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Καὶ ἐξιλάσεται ὁ ἱερεὺς περὶ πάσης συναγωγῆς υἱῶν Ἰσραὴλ, καὶ ἀφεθήσεται αὐτοῖς, ὅτι ἀκούσιόν ἐστι· καὶ αὐτοὶ ἤνεγκαν τὸ δῶρον αὐτῶν κάρπωμα Κυρίῳ περὶ τῆς ἁμαρτίας αὐτῶν ἔνατι Κυρίου, περὶ τῶν ἀκουσίων αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Καὶ ἀφεθήσεται κατὰ πᾶσαν συναγωγην υἱῶν Ἰσραὴλ, καὶ τῷ προσηλύτῳ τῷ προσκειμένῳ πρὸς ὑμᾶς, ὅτι παντὶ τῷ λαῷ ἀκούσιον. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ἐάν τε ψυχὴ μία ἁμάρτῃ ἀκουσίως, προσάξει αἶγα μίαν ἐνιαυσίαν περὶ ἁμαρτίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Καὶ ἐξιλάσεται ὁ ἱερεὺς περὶ τῆς ψυχῆς τῆς ἀκουσιασθείσης, καὶ ἁμαρτούσης ἀκουσίως ἔναντι Κυρίου, ἐξιλάσασθαι περὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Τῷ ἐγχωρίῳ ἐν υἱοῖς Ἰσραὴλ, καὶ τῷ προσηλύτῳ τῷ προσκειμένῳ ἐν αὐτοῖς νόμος εἷς ἔσται αὐτοῖς, ὃς ἐὰν ποιήσῃ ἀκουσίως. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Καὶ ψυχὴ ἥτις ποιήσῃ ἐν χειρὶ ὑπερηφανίας ἀπὸ τῶν αὐτοχθόνων ἢ ἀπὸ τῶν προσηλύτων, τὸν Θεὸν οὗτος παροξυνεῖ, ἐξόλοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ τοῦ λαοῦ αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ὅτι τὸ ῥῆμα Κυρίου ἐφαύλισε, καὶ τὰς ἐντολὰς αὐτοῦ διεσκέδασεν· ἐκτρίψει ἐκτριβήσεται ἡ ψυχὴ ἐκείνη, ἡ ἁμαρτία αὐτῆς ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Καὶ ἦσαν οἱ υἱοὶ Ἰσραὴλ ἑν τῇ ἐρήμῳ, καὶ εὗρον ἄνδρα συλλέγοντα ξύλα τῇ ἡμέρᾳ τῶν σαββάτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Καὶ προσήγαγον αὐτὸν οἱ εὐρόντες συλλέγοντα ξύλα τῇ ἡμέρᾳ τῶν σαββάτων πρὸς Μωυσῆν καὶ Ἀαρὼν, καὶ πρὸς πᾶσαν συναγωγὴν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Καὶ ἀπέθεντο αὐτὸν εἰς φυλακὴν, οὐ γὰρ συνέκριναν τί ποιήσωσιν αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, θανάτῳ θανατούσθω ὁ ἄνθρωπος· λιθοβολήσατε αὐτὸν λίθοις πᾶσα ἡ συναγωγή. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Καὶ ἐξήγαγον αὐτὸν πᾶσα ἡ συναγωγὴ ἔξω τῆς παρεμβολῆς· καὶ ἐλιθοβόλησεν αὐτὸν πᾶσα ἡ συναγωγὴ λίθοις ἔξω τῆς παρεμβολῆς, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, καὶ ποιησάτωσαν ἐαυτοῖς κράσπεδα ἐπὶ τὰ πτερύγια τῶν ἱματίων αὐτῶν εἰς τὰς γενεὰς αὐτῶν· καὶ ἐπιθήσετε ἐπὶ τὰ κράσπεδα τῶν πτερυγίων κλῶσμα ὑακίνθινον. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Καὶ ἔσται ὑμῖν ἐν τοῖς κρασπέδοις, καὶ ὄψεσθε αὐτά· καὶ μνησθήσεσθε πασῶν τῶν ἐντολῶν Κυρίου, καὶ ποιήσετε αὐτάς· καὶ οὐ διαστραφήσεσθε ὀπίσω τῶν διανοιῶν ὑμῶν, καὶ τῶν ὀφθαλμῶν ἐν οἷς ὑμεῖς ἐκπορνεύετε ὀπίσω αὐτῶν, ὅπως ἂν μνησθῆτε καὶ ποιήσητε πάσας τὰς ἐντολάς μου, ");
INSERT INTO grcbrent_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","καὶ ἔσεσθε ἅγιοι τῷ Θεῷ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ἐγὼ Κύριος ὁ Θεὸς ὑμῶν ὁ ἐξαγαγὼν ὑμᾶς ἐκ γῆς Αἰγύπτου, εἶναι ὑμῶν Θεός· ἐγὼ Κύριος ὁ Θεὸς ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Καὶ ἐλάλησε Κορὲ υἱὸς Ἰσαὰρ υἱοῦ Καὰθ υἱοῦ Λευί, καὶ Δαθὰν καὶ Ἀβειρὼν υἱοὶ Ἐλιάβ, καὶ Αὒν υἱὸς Φαλὲθ υἱοῦ Ῥουβήν· ");
INSERT INTO grcbrent_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","καὶ ἀνέστησαν ἔναντι Μωυσῆ, καὶ ἄνδρες τῶν υἱῶν Ἰσραὴλ πεντήκοντα καὶ διακόσιοι, ἀρχηγοὶ συναγωγῆς, σύγκλητοι βουλῆς, καὶ ἄνδρες ὀνομαστοί. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Συνέστησαν ἐπὶ Μωυσῆν καὶ Ἀαρὼν, καὶ εἶπαν, ἐχέτω ὑμῖν ὅτι πᾶσα ἡ συναγωγὴ πάντες ἅγιοι, καὶ ἐν αὐτοῖς Κύριος· καὶ διατί κατανίστασθε ἐπὶ τὴν συναγωγὴν Κυρίου; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Καὶ ἀκούσας Μωυσῆς, ἔπεσεν ἐπὶ πρόσωπον. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Καὶ ἐλάλησε πρὸς Κόρε καὶ πρὸς πᾶσαν αὐτοῦ τὴν συναγωγὴν, λέγων, ἐπέσκεπται καὶ ἔγνω ὁ Θεὸς τοὺς ὄντας αὐτοῦ καὶ τοὺς ἁγίους, καὶ προσηγάγετο πρὸς ἑαυτόν· καὶ οὓς ἐξελέξατο ἑαυτῷ, προσηγάγετο πρὸς ἑαυτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Τοῦτο ποιήσατε· λάβετε ὑμῖν αὐτοῖς πυρεῖα Κορὲ, καὶ πᾶσα ἡ συναγωγὴ αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","καὶ ἐπίθετε ἐπʼ αὐτὰ πῦρ, καὶ ἐπίθετε ἐπʼ αὐτὰ θυμίαμα ἔναντι Κυρίου αὔριον· καὶ ἔσται ὁ ἀνὴρ ὃν ἐκλέλεκται Κύριος, οὗτος ἅγιος· ἱκανούσθω ὑμῖν υἱοὶ Λευί. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Καὶ εἶπε Μωυσῆς πρὸς Κορὲ, εἰσακούσατέ μου υἱοὶ Λευί. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Μὴ μικρόν ἐστι τοῦτο ὑμῖν, ὅτι διέστειλεν ὁ Θεὸς Ἰσραὴλ ὑμᾶς ἐκ συναγωγῆς Ἰσραὴλ, καὶ προσηγάγετο ὑμᾶς πρὸς ἑαυτὸν λειτουργεῖν τᾶς λειτουργίας τῆς σκηνῆς Κυρίου, καὶ παρίστασθαι ἔναντι τῆς σκηνῆς λατρεύειν αὐτοῖς; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","καὶ προσηγάγετό σε καὶ πάντας τοὺς ἀδελφούς σου υἱοὺς Λευὶ μετὰ σοῦ, καὶ ζητεῖτε καὶ ἱερατεύειν; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Οὕτως σὺ καὶ πᾶσα ἡ συναγωγή σου ἡ συνηθροισμένη πρὸς τὸν Θεόν· καὶ Ἀαρὼν τίς ἐστιν, ὅτι διαγογγύζετε κατʼ αὐτοῦ; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Καὶ ἀπέστειλε Μωυσῆς καλέσαι Δαθὰν καὶ Ἀβειρὼν υἱοὺς Ἑλιάβ· καὶ εἶπαν, οὐκ ἀναβαίνομεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Μὴ μικρὸν τοῦτο, ὅτι ἀνήγαγες ἡμᾶς εἰς γῆν ῥέουσαν γάλα καὶ μέλι, ἀποκτεῖναι ἡμᾶς ἐν τῇ ἐρήμῳ, ὅτι κατάρχεις ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ἀρχων εἶ· καὶ σὺ εἰς γῆν ῥέουσαν γάλα καὶ μέλι εἰσήγαγες ἡμᾶς, καὶ ἔδωκας ἡμῖν κλῆρον ἀγροῦ καὶ ἀμπελῶνας; τοὺς ὀφθαλμοὺς τῶν ἀνθρώπων ἐκείνων ἄν ἐξέκοψας; οὐκ ἀναβαίνομεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Καὶ ἐβαρυθύμησε Μωυσῆς σφόδρα, καὶ εἶπε πρὸς Κύριον, μὴ πρόσχῃς εἰς τὴν θυσίαν αὐτῶν· οὐκ ἐπιθύμημα οὐδενὸς αὐτῶν εἴληφα, οὐδὲ ἐκάκωσα οὐδένα αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Καὶ εἶπε Μωυσῆς πρὸς Κορὲ, ἁγίασον τὴν συναγωγήν σου, καὶ γίνεσθε ἕτοιμοι ἔναντι Κυρίου σὺ καὶ Ἀαρὼν καὶ αὐτοὶ αὔριον· ");
INSERT INTO grcbrent_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Καὶ λάβετε ἕκαστος τὸ πυρεῖον αὐτοῦ, καὶ ἐπιθήσετε ἐπʼ αὐτὰ θυμίαμα, καὶ προσάξετε ἔναντι Κυρίου ἕκαστος τὸ πυρεῖον αὐτοῦ, πεντήκοντα καὶ διακόσια πυρεῖα, καὶ σὺ καὶ Ἀαρὼν ἕκαστος τὸ πυρεῖον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Καὶ ἔλαβεν ἕκαστος τὸ πυρεῖον αὐτοῦ, καὶ ἐπέθηκαν ἐπʼ αὐτὰ πῦρ, καὶ ἐπέβαλον ἐπʼ αὐτὰ θυμίαμα· καὶ ἔστησαν παρὰ τὰς θύρας τῆς σκηνῆς τοῦ μαρτυρίου Μωυσῆς καὶ Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Καὶ ἐπισυνέστησεν ἐπʼ αὐτοὺς Κορὲ τὴν πᾶσαν αὐτοῦ συναγωγὴν παρὰ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου· καὶ ὤφθη ἡ δόξα Κυρίου πάσῃ τῇ συναγωγῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","ἀποσχίσθητε ἐκ μέσου τῆς συναγωγῆς ταύτης, καὶ ἐξαναλώσω αὐτοὺς εἰσάπαξ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Καὶ ἔπεσαν ἐπὶ πρόσωπον αὐτῶν, καὶ εἶπαν, Θεὸς, Θεὸς τῶν πνευμάτων καὶ πάσης σαρκὸς, εἰ ἄνθρωπος εἷς ἥμαρτεν, ἐπὶ πᾶσαν τὴν συναγωγὴν ὀργὴ Κυρίου; ");
INSERT INTO grcbrent_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","λάλησον τῇ συναγωγῇ, λέγων, ἀναχωρήσατε κύκγῳ ἀπὸ τῆς συναγωγῆς Κορὲ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Καὶ ἀνέστη Μωυσῆς, καὶ ἐπορεύθη πρὸς Δαθὰν καὶ Ἀβειρὼν, καὶ συνεπορεύθησαν μετʼ αὐτοῦ πάντες οἱ πρεσβύτεροι Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Καὶ ἐλάλησε πρὸς τὴν συναγωγὴν, λέγων, ἀποσχίσθητε ἀπὸ τῶν σκηνῶν τῶν ἀνθρώπων τῶν σκληρῶν τούτων, καὶ μὴ ἅπτεσθε ἀπὸ πάντων ὧν ἐστιν αὐτοῖς, μὴ συναπόλησθε ἐν πάσῃ τῇ ἁμαρτίᾳ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Καὶ ἀπέστησαν ἀπὸ τῆς σκηνῆς Κορὲ κύκλῳ· καὶ Δαθὰν καὶ Ἀβειρὼν ἐξῆλθον, καὶ εἱστήκεισαν παρὰ τὰς θύρας τῶν σκηνῶν αὐτῶν, καὶ αἱ γυναῖκες αὐτῶν, καὶ τὰ τέκνα αὐτῶν, καὶ ἡ ἀποσκευὴ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Καὶ εἶπε Μωυσῆς, ἐν τούτῳ γνώσεσθε ὅτι Κύριος ἀπέστειλέ με ποιῆσαι πάντα τὰ ἔργα ταῦτα, ὅτι οὐκ ἀπʼ ἐμαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Εἰ κατὰ θάνατον πάντων ἀνθρώπων ἀποθανοῦνται οὗτοι, εἰ καὶ κατʼ ἐπίσκεψιν πάντων ἀνθρώπων ἐπισκοπὴ ἔσται αὐτῶν, οὐχὶ Κύριος ἀπέσταλκέ με. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ἀλλʼ ἢ ἐν φάσματι δείξει Κύριος, καὶ ἀνοίξασα ἡ γῆ τὸ στόμα αὐτῆς καταπίεται αὐτοὺς, καὶ τοὺς οἴκους αὐτῶν, καὶ τὰς σκηνὰς αὐτῶν, καὶ πάντα ὅσα ἐστὶν αὐτοῖς, καὶ καταβήσονται ζῶντες εἰς ᾅδου, καὶ γνώσεσθε, ὅτι παρώξυναν οἱ ἄνθρωποι οὗτοι τὸν Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ὡς δὲ ἐπαύσατο λαλῶν πάντας τοὺς λόγους τούτους, ἐῤῥάγη ἡ γῆ ὑποκάτω αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Καὶ ἠνοίχθη ἡ γῆ, καὶ κατέπιεν αὐτοὺς, καὶ τοὺς οἴκους αὐτῶν, καὶ πάντας τοὺς ἀνθρώπους τοὺς ὄντας μετὰ Κορὲ, καὶ τὰ κτήνη αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Καὶ κατέβησαν αὐτοὶ, καὶ ὅσα ἐστὶν αὐτῶν ζῶντα εἰς ᾅδου, καὶ ἐκάλυψεν αὐτοὺς ἡ γῆ, καὶ ἀπώλοντο ἐκ μέσου τῆς συναγωγῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Καὶ πᾶς Ἰσραὴλ οἱ κύκλῳ αὐτῶν ἔφυγον ἀπὸ τῆς φωνῆς αὐτῶν, ὅτι λέγοντες, μή ποτε καταπίῃ ἡμᾶς ἡ γῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Καὶ πῦρ ἐξῆλθε παρὰ Κυρίου, καὶ κατέφαγε τοὺς πεντήκοντα καὶ διακοσίους ἄνδρας τοὺς προσφέροντας τὸ θυμίαμα. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ");
INSERT INTO grcbrent_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","καὶ πρὸς Ἐλεάζαρ τὸν υἱὸν Ἀαρὼν τὸν ἱερέα, ἀνέλεσθε τὰ πυρεῖα τὰ χαλκᾶ ἐκ μέσου τῶν κατακεκαυμένων, καὶ τὸ πῦρ τὸ ἀλλότριον τοῦτο σπεῖρον ἐκεῖ, ὅτι ἡγίασαν τὰ πυρεῖα τῶν ἁμαρτωλῶν τούτων ἐν ταῖς ψυχαῖς αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","καὶ ποίησον αὐτὰ λεπίδας ἐλατὰς περίθεμα τῷ θυσιαστηρίῳ, ὅτι προσηνέχθησαν ἔναντι Κυρίου καὶ ἡγιάσθησαν· καὶ ἐγένοντο εἰς σημεῖον τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Καὶ ἔλαβεν Ἐλεάζαρ υἱοὶς Ἀαρὼν τοῦ ἱερέως τὰ πυρεῖα τὰ χαλκᾶ, ὅσα προσήνεγκαν οἱ κατακεκαυμένοι, καὶ προσέθηκαν αὐτὰ περίθεμα τῷ θυσιαστηρίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","μνημόσυνον τοῖς υἱοῖς Ἰσραήλ, ὅπως ἂν μὴ προσέλθῃ μηδὶς ἀλλογενής, ὃς οὐκ ἔστιν ἐκ τοῦ σπέρματος Ἀαρὼν, ἐπιθεῖναι θυμίαμα ἔναντι Κυρίου· καὶ οὐκ ἔσται ὥσπερ Κορὲ, καὶ ἡ ἐπισύστασις αὐτοῦ, καθὰ ἐλάλησε Κύριος ἐν χειρὶ Μωυσῆ αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Καὶ ἐγόγγυσαν οἱ υἱοὶ Ἰσραὴλ τῇ ἐπαύριον ἐπὶ Μωυσῆν καὶ Ἀαρὼν, λέγοντες, ὑμεῖς ἀπεκτάγκατε τὸν λαὸν Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Καὶ ἐγένετο ἐν τῷ ἐπισυστρέφεσθαι τὴν συναγωγὴν ἐπὶ Μωυσῆν καὶ Ἀαρὼν, καὶ ὥρμησαν ἐπὶ τὴν σκηνὴν τοῦ μαρτυρίου· καὶ τήνδε ἐκάλυψεν αὐτὴν ἡ νεφέλη, καὶ ὤφθη ἡ δόξα Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Καὶ εἰσῆλθε Μωυσῆς καὶ Ἀαρὼν κατὰ πρόσωπον τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ἐκχωρήσατε ἐκ μέσου τῆς συναγωγῆς ταύτης, καὶ ἐξαναλώσω αὐτοὺς εἰσάπαξ· καὶ ἔπεσον ἐπὶ πρόσωπον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Καὶ εἶπε Μωυσῆς πρὸς Ἀαρὼν, λάβε τὸ πυρεῖον, καὶ ἐπίθες ἐπʼ αὐτὸ πῦρ ἀπὸ τοῦ θυσιαστηρίου, καὶ ἐπίβαλε ἐπʼ αὐτὸ θυμίαμα, καὶ ἀπένεγκε τοτάχος εἰς τὴν παρεμβολὴν, καὶ ἐξίλασαι περὶ αὐτῶν· ἐξῆλθε γὰρ ὀργὴ ἀπὸ προσώπου Κυρίου, ἦρκται θραύειν τὸν λαόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Καὶ ἔλαβεν Ἀαρὼν καθάπερ ἐλάλησεν αὐτῷ Μωυσῆς, καὶ ἔδραμεν εἰς τὴν συναγωγήν· καὶ ἤδη ἐνῆρκτο ἡ θραῦσις ἐν τῷ λαῷ· καὶ ἐπέβαλε τὸ θυμίαμα καὶ ἐξιλάσατο περὶ τοῦ λαοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Καὶ ἔστη ἀναμέσον τῶν τεθνηκότων καὶ τῶν ζώντων, καὶ ἐκόπασεν ἡ θραῦσις. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Καὶ ἐγένοντο οἱ τεθνηκότες ἐν τῇ θραύσει τεσσαρεσκαίδεκα χιλιάδες καὶ ἑπτακόσιοι, χωρὶς τῶν τεθνηκότων ἕνεκεν Κορέ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Καὶ ἐπέστρεψεν Ἀαρὼν πρὸς Μωυσῆν ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου, καὶ ἐκόπασεν ἡ θραῦσις. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ λάβε παρʼ αὐτῶν ῥάβδον, ῥάβδον κατʼ οἴκους πατριῶν παρὰ πάντων τῶν ἀρχόντων αὐτῶν, κατʼ οἴκους πατριῶν αὐτῶν, δώδεκα ῥάβδους, καὶ ἑκάστου τὸ ὄνομα αὐτοῦ ἐπὶγραψον ἐπὶ τῆς ῥάβδου. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Καὶ τὸ ὄνομα Ἀαρὼν ἐπίγραψον ἐπὶ τῆς ῥάβδου Λευί· ἔστι γὰρ ῥάβδος μία· κατὰ φυλὴν οἴκου πατριῶν αὐτῶν δώσουσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Καὶ θήσεις αὐτὰς ἐν τῇ σκηνῇ τοῦ μαρτυρίου, κατέναντι τοῦ μαρτυρίου, ἐν οἷς γνωσθήσομαί σοι ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Καὶ ἔσται ὁ ἄνθρωπος ὃν ἂν ἐκλέξωμαι αὐτὸν, ἡ ῥάβδος αὐτοῦ ἐκβλαστήσει· καὶ περιελῶ ἀπʼ ἐμοῦ τὸν γογγυσμὸν υἱῶν Ἰσραήλ, ἃ αὐτοὶ γογγύζουσιν ἐφʼ ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Καὶ ἐλάλησε Μωυσῆς τοῖς υἱοῖς Ἰσραήλ· καὶ ἔδωκαν αὐτῷ πάντες οἱ ἄρχοντες αὐτῶν ῥάβδον· τῷ ἄρχοντι τῷ ἑνὶ ῥάβδον κατʼ ἄρχοντα, κατʼ οἴκους πατριῶν αὐτῶν, δώδεκα ῥάβδους· καὶ ἡ ῥάβδος Ἀαρὼν ἀναμέσον τῶν ῥάβδων αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Καὶ ἀπέθηκε Μωυσῆς τὰς ῥάβδους ἔναντι Κυρίου ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Καὶ ἐγενετο τῇ ἐπαύριον, καὶ εἰσῆλθε Μωυσῆς καὶ Ἀαρὼν ἐν τῇ σκηνῇ τοῦ μαρτυρίου· καὶ ἰδοὺ ἐβλάστησεν ἡ ῥάβδος Ἀαρὼν εἰς οἶκον Λευί, καὶ ἐξήνεγκε βλαστὸν, καὶ ἐξήνθησεν ἄνθη, καὶ ἐβλάστησε κάρυα. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Καὶ ἐξήνεγκε Μωυσῆς πάσας τὰς ῥάβδους ἀπὸ προσώπου Κυρίου πρὸς πάντας υἱοὺς Ἰσραήλ· καὶ εἶδον, καὶ ἔλαβον ἕκαστος τὴν ῥάβδον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἀπόθες τὴν ῥάβδον Ἀαρὼν ἐνώπιον τῶν μαρτυρίων εἰς διατήρησιν, σημεῖον τοῖς υἱοῖς τῶν ἀνηκόων· καὶ παυσάσθω ὁ γογγυσμὸς αὐτῶν ἀπʼ ἐμοῦ, καὶ οὐ μὴ ἀποθάνωσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Καὶ ἐποίησε Μωυσῆς καὶ Ἀαρὼν, καθὰ συνέταξε κύριος τῷ Μωυσῇ, οὕτως ἐποίησαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Καὶ εἶπαν οἱ υἱοὶ Ἰσραὴλ πρὸς Μωυσῆν, λέγοντες, ἰδοὺ ἐξανηλώμεθα, ἀπολώλαμεν, παρανηλώμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Πᾶς ὁ ἁπτόμενος τῆς σκηυῆς Κυρίου, ἀποθνήσκει· ἕως εἰς τέλος ἀποθάνωμεν; ");
INSERT INTO grcbrent_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Καὶ εἶπε Κύριος πρὸς Ἀαρὼν, λέγων, σὺ καὶ οἱ υἱοί σου καὶ ὁ οἶκος τοῦ πατρός σου λήψεσθε τὰς ἀμαρτίας τῶν ἁγίων, καὶ σὺ καὶ οἱ υἱοί σου λήψεσθε τὰς ἁμαρτίας τῆς ἱερατείας ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Καὶ τοὺς ἀδελφούς σου φυλὴν Λευὶ, δῆμον τοῦ πατρός σου προσαγάγου πρὸς σεαυτὸν, καὶ προστεθήτωσάν σοι, καὶ λειτουργείτωσάν σοι· καὶ σὺ καὶ οἱ υἱοί σου μετὰ σοῦ ἀπέναντι τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Καὶ φυλάξονται τὰς φυλακάς σου, καὶ τὰς φυλακὰς τῆς σκηνῆς. πλὴν πρὸς τὰ σκεύη τὰ ἅγια, καὶ πρὸς τὸ θυσιαστήριον οὐ προσελεύσονται, καὶ οὐκ ἀποθανοῦνται καὶ οὗτοι καὶ ὑμεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Καὶ προστεθήσονται πρὸς σέ, καὶ φυλάξονται τὰς φυλακὰς τῆς σκηνῆς τοῦ μαρτυρίου, κατὰ πάσας τὰς λειτουργίας τῆς σκηνῆς· καὶ ὁ ἀλλογενὴς οὐ προσελεύσεται πρὸς σέ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Καὶ φυλάξεσθε τὰς φυλακὰς τῶν ἁγίων, καὶ τὰς φυλακὰς τοῦ θυσιαστηρίου, καὶ οὐκ ἔσται θυμὸς ἐν τοῖς υἱοῖς Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Καὶ ἐγὼ εἴληφα τοὺς ἀδελφοὺς ὑμῶν τοὺς Λευίτας ἐκ μέσου τῶν υἱῶν Ἰσραὴλ δόμα δεδομένον Κυρίῳ, λειτουργεῖν τὰς λειτουργίας τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Καὶ σὺ καὶ οἱ υἱοί σου μετὰ σοῦ διατηρήσετε τὴν ἱερατείαν ὑμῶν, κατὰ πάντα τρόπον τοῦ θυσιαστηρίου, καὶ τὸ ἔνδοθεν τοῦ καταπετάσματος· καὶ λειτουργήσετε τὰς λειτουργίας δόμα τῆς ἱερατείας ὑμῶν· καὶ ὁ ἀλλογενὴς ὁ προσπορευόμενος ἀποθανεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Καὶ ἐλάλησε Κύριος πρὸς Ἀαρὼν, καὶ ἰδοὺ ἐγὼ δέδωκα ὑμῖν τὴν διατήρησιν τῶν ἀπαρχῶν ἀπὸ πάντων τῶν ἡγιασμένων μοι παρὰ τῶν υἱῶν Ἰσραήλ· σοὶ δέδωκα αὐτὰ εἰς γέρας, καὶ τοῖς υἱοῖς σου μετὰ σὲ νόμιμον αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Καὶ τοῦτο ἔστω ὑμῖν ἀπὸ τῶν ἡγιασμένων ἁγίων τῶν καρπωμάτων, ἀπὸ πάντων τῶν δώρων αὐτῶν, καὶ ἀπὸ πάντων τῶν θυσιασμάτων αὐτῶν, καὶ ἀπὸ πάσης πλημμελείας αὐτῶν, καὶ ἀπὸ πασῶν τῶν ἁμαρτιῶν αὐτῶν, ὅσα ἀποδιδόασί μοι ἀπὸ πάντων τῶν ἁγίων, σοὶ ἔσται καὶ τοῖς υἱοῖς σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ἐν τῷ ἁγίῳ τῶν ἁγίων φάγεσθε αὐτά· πᾶν ἀρσενικὸν φάγεται αὐτά· σὺ καὶ οἱ υἱοί σου· ἅγια ἔσται σοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Καὶ τοῦτο ἔσται ὑμῖν ἀπαρχῶν δομάτων αὐτῶν, ἀπὸ πάντων τῶν ἐπιθεμάτων τῶν υἱῶν Ἰσραήλ· σοὶ δέδωκα αὐτὰ καὶ τοῖς υἱοῖς σου καὶ ταῖς θυγατράσι σου μετὰ σοῦ, νόμιμον αἰώνιον· πᾶς καθαρὸς ἐν τῷ οἴκῳ σου ἔδεται αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Πᾶσα ἀπαρχὴ ἐλαίου, καὶ πᾶσα ἀπαρχὴ οἴνου, σίτου ἀπαρχὴ αὐτῶν ὅσα ἂν δῶσι τῷ Κυρίῳ, σοὶ δέδωκα αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Τὰ πρωτογεννήματα πάντα ὅσα ἐν τῇ γῇ αὐτῶν, ὅσα ἂν ἐνέγκωσι Κυρίῳ, σοὶ ἔσται· πᾶς καθαρὸς ἐν τῷ οἴκῳ σου ἔδεται αὐτά. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Πᾶν ἀνατεθεματισμένον ἐν υἱοῖς Ἰσραὴλ, σοὶ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Καὶ πᾶν διανοῖγον μήτραν ἀπὸ πάσης σαρκὸς, ὅσα προσφέρουσι Κυρίῳ ἀπὸ ἀνθρώπου ἕως κτήνους, σοὶ ἔσται· ἀλλʼ ἢ λύτροις λυτρωθήσεται τὰ πρωτότοκα τῶν ἀνθρώπων, καὶ τὰ πρωτότοκα τῶν κτηνῶν τῶν ἀκαθάρτων λυτρώσῃ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Καὶ ἡ λύτρωσις αὐτοῦ, ἀπὸ μηνιαίου· ἡ συντίμησις πέντε σίκλων, κατὰ τὸν σίκλον τὸν ἅγιον εἴκοσι ὀβολοί εἰσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Πλὴν πρωτότοκα μόσχων καὶ πρωτότοκα προβάτων, καὶ πρωτότοκα αἰγῶν οὐ λυτρώσῃ· ἅγιά ἐστι· καὶ τὸ αἷμα αὐτῶν προσχεεῖς πρὸς τὸ θυσιαστήριον, καὶ τὸ στέαρ ἀνοίσεις κάρπωμα εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Καὶ τὰ κρέα ἔσται σοι, καθὰ καὶ τὸ στηθύνιον τοῦ ἐπιθέματος· καὶ κατὰ τὸν βραχίονα τὸν δεξιὸν, σοὶ ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Πᾶν ἀφαίρεμα τῶν ἁγίων, ὅσα ἐὰν ἀφέλωσιν οἱ υἱοὶ Ἰσραὴλ Κυρίῳ, δέδωκά σοι καὶ τοῖς υἱοῖς σου καὶ ταῖς θυγατράσι σου μετὰ σοῦ, νόμιμον αἰώνιον· διαθήκη ἁλὸς αἰωνίου ἔστιν ἔναντι Κυρίου, σοὶ καὶ τῷ σπέρματί σου μετὰ σέ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Καὶ ἐλάλησε Κύριος πρὸς Ἀαρὼν, ἐν τῇ γῇ αὐτῶν οὐ κληρονομήσεις, καὶ μερὶς οὐκ ἔσται σοι ἐν αὐτοῖς, ὅτι ἐγὼ μερίς σου καὶ κληρονομία σου ἐν μέσῳ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Καὶ τοῖς υἱοῖς Λευὶ ἰδοὺ δέδωκα πᾶν ἐπιδέκατον ἐν Ἰσραὴλ ἐν κλήρῳ ἀντὶ τῶν λειτουργιῶν αὐτῶν, ὅσα αὐτοὶ λειτουργοῦσι λειτουργίαν ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Καὶ οὐ προσελεύσονται ἔτι οἱ υἱοὶ Ἰσραὴλ εἰς τὴν σκηνὴν τοῦ μαρτυρίου λαβεῖν ἁμαρτίαν θανατηφόρον. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Καὶ λειτουργήσει ὁ Λενίτης αὐτὸς τὴν λειτουργίαν τῆς σκηνῆς τοῦ μαρτυρίου· καὶ αὐτοὶ λήψονται τὰ ἁμαρτήματα αὐτῶν, νόμιμον αἰώνιον εἰς τὰς γενεὰς αὐτῶν· καὶ ἐν μέσῳ υἱῶν Ἰσραὴλ οὐ κληρονομήσουσι κληρονομίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ὅτι τὰ ἐπιδέκατα τῶν υἱῶν Ἰσραὴλ ὅσα ἐὰν ἀφορίσωσι Κυρίῳ, ἀφαίρεμα δέδωκα τοῖς Λευίταις ἐν κλήρῳ· διὰ τοῦτο εἴρηκα αὐτοῖς, ἐν μέσῳ υἱῶν Ἰσραὴλ οὐ κληρονομήσουσι κλῆρον. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","καὶ τοῖς Λενίταις λαλήσεις, καὶ ἐρεῖς πρὸς αὐτοὺς, ἐὰν λάβητε παρὰ τῶν υἱῶν Ἰσραὴλ τὸ ἐπιδέκατον, ὃ δέδωκα ὑμῖν παρʼ αὐτῶν ἐν κλήρῳ, καὶ ἀφελεῖτε ὑμεῖς ἀπʼ αὐτοῦ ἀφαίρεμα Κυρίῳ, ἐπιδέκατον ἀπὸ τοῦ ἐπιδεκάτου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Καὶ λογισθήσεται ὑμῖν τὰ ἀφαιρέματα ὑμῶν ὡς σῖτος ἀπὸ ἅλω, καὶ ἀφαίρεμα ἀπὸ ληνοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Οὕτως ἀφελεῖτε αὐτοὺς καὶ ὑμεῖς ἀπὸ πάντων τῶν ἀφαιρεμάτων Κυρίου ἀπὸ πάντων τῶν ἐπιδεκάτων ὑμῶν, ὅσα ἐὰν λάβητε παρὰ τῶν υἱῶν Ἰσραήλ· καὶ δώσετε ἀπʼ αὐτῶν ἀφαίρεμα Κυρίῳ Ἀαρὼν τῷ ἱερεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ἀπὸ πάντων τῶν δομάτων ὑμῶν ἀφελεῖτε ἀφαιρεμα Κυρίῳ, ἢ ἀπὸ πάντων τῶν ἀπαρχῶν τὸ ἡγιασμένον ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Καὶ ἐρεῖς πρὸς αὐτοὺς, ὅταν ἀφαιρῆτε τὴν ἀπαρχὴν ἀπʼ αὐτοῦ, καὶ λογισθήσεται τοῖς Λευίταις ὡς γέννημα ἀπὸ ἅλω, καὶ ὡς γέννημα ἀπὸ ληνοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Καὶ ἔδεσθε αὐτὸ ἐν παντὶ τόπῳ ὑμεῖς καὶ οἱ οἶκοι ὑμῶν, ὅτι μισθὸς οὗτος ὑμῖν ἐστιν ἀντὶ τῶν λειτουργιῶν ὑμῶν τῶν ἐν τῇ σκηνῇ τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Καὶ οὐ λήψεσθε διʼ αὐτὸ ἁμαρτίαν, ὅτι ἂν ἀφαιρῆτε τὴν ἀπαρχὴν ἀπʼ αὐτοῦ· καὶ τὰ ἅγια τῶν υἱῶν Ἰσραὴλ οὐ βεβηλώσετε, ἵνα μὴ ἀποθάνητε. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","αὕτη ἡ διαστολὴ τοῦ νόμου, ὅσα συνέταξε Κύριος, λέγων, λάλησον τοῖς υἱοῖς Ἰσραήλ· καὶ λαβέτωσαν πρὸς σὲ δάμαλιν πυῤῥὰν ἄμωμου, ἥτις οὐκ ἔχει ἐν αὐτῇ μῶμον, καὶ ᾗ οὐκ ἐπεβλήθη ἐπʼ αὐτὴν ζυγός. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Καὶ δώσεις αὐτὴν πρὸς Ἐλεάζαρ τὸν ἱερέα· καὶ ἐξάξουσιν αὐτὴν ἔξω τῆς παρεμβολῆς εἰς τόπον καθαρὸν, καὶ σφάξουσιν αὐτὴν ἐνώπιον αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Καὶ λήψεται Ἐλεάζαρ ἀπὸ τοῦ αἵματος αὐτῆς, καὶ ῥανεῖ ἀπέναντι τοῦ προσώπου τῆς σκηνῆς τοῦ μαρτυρίου ἀπὸ τοῦ αἵματος αὐτῆς ἑπτάκις. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Καὶ κατακαύσουσιν αὐτὴν ἐναντίον αὐτοῦ· καὶ τὸ δέρμα καὶ τὰ κρέα αὐτῆς καὶ τὸ αἷμα αὐτῆς σὺν τῇ κόπρῳ αὐτῆς κατακαυθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Καὶ λήψεται ὁ ἱερεὺς ξύλον κέδρινον καὶ ὕσσωπον καὶ κόκκινον, καὶ ἐμβαλοῦσιν εἰς μέσον τοῦ κατακαύματος τῆς δαμάλεως. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Καὶ πλυνεῖ τὰ ἱμάτια αὐτοῦ ὁ ἱερεὺς, καὶ λούσεται τὸ σῶμα αὐτοῦ ὕδατι, καὶ μετὰ ταῦτα εἰσελεύσεται εἰς τὴν παρεμβολὴν, καὶ ἀκάθαρτος ἔσται ὁ ἱερεὺς ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Καὶ ὁ κατακαίων αὐτὴν πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται τὸ σῶμα αὐτοῦ, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Καὶ συνάξει ἄνθρωπος καθαρὸς τὴν σποδὸν τῆς δαμάλεως, καὶ ἀποθήσει ἔξω τῆς παρεμβολῆς εἰς τόπον καθαρόν· καὶ ἔσται τῇ συναγωγῇ υἱῶν Ἰσραὴλ εἰς διατήρησιν· ὕδωρ ῥαντισμοῦ ἅγνισμά ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Καὶ ὁ συνάγων τὴν σποδιὰν τῆς δαμάλεως, πλυνεῖ τὰ ἱμάτια αὐτου, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας· καὶ ἔσται τοῖς υἱοῖς Ἰσραὴλ καὶ τοῖς προσηλύτοις προσκειμένοις νόμιμον αἰώνιον. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ὁ ἁπτόμενος τοῦ τεθνηκότος πάσης ψυχῆς ἀνθρώπου, ἀκάθαρτος ἔσται ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Οὗτος ἁγνισθήσεται τῇ ἡμέρᾳ τῇ τρίτῃ καὶ τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ καθαρὸς ἔσται· ἐὰν δὲ μὴ ἀφαγνισθῇ τῇ ἡμέρᾳ τῇ τρίτῃ καὶ τῇ ἡμέρᾳ τῇ ἑβδόμῃ, οὐ καθαρὸς ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Πᾶς ὁ ἁπτόμενος τοῦ τεθνηκότος ἀπὸ ψυχῆς ἀνθρώπου, ἐὰν ἀποθάνῃ, καὶ μὴ ἀφαγνισθῇ, τὴν σκηνὴν Κυρίου ἐμίανεν· ἐκτριβήσεται ἡ ψυχὴ ἐκείνη ἐξ Ἰσραὴλ, ὅτι ὕδωρ ῥαντισμοῦ οὐ περιεῤῥαντίσθη ἐπʼ αὐτόν· ἀκάθαρτός ἐστιν· ἔτι ἡ ἀκαθαρσία αὐτοῦ ἐν αὐτῷ ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Καὶ οὗτος ὁ νόμος· ἄνθρωπος ἐὰν ἀποθάνῃ ἐν οἰκίᾳ, πᾶς ὁ εἰσπορευόμενος εἰς τὴν οἰκίαν, καὶ ὅσα ἐστὶν ἐν τῇ οἰκίᾳ, ἀκάθαρτα ἔσται ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Καὶ πᾶν σκεῦος ἀνεῳγμένον ὅσα οὐχὶ δεσμὸν καταδέδεται ἐπʼ αὐτῷ, ἀκάθαρτά ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Καὶ πᾶς ὃς ἂν ἅψηται ἐπὶ προσώπου τοῦ πεδίου τραυματίου ἢ νεκροῦ ἢ ὀστέου ἀνθρωπίνου ἢ μνήματος, ἑπτὰ ἡμέρας ἀκάθαρτος ἔσται. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Καὶ λήψονται τῷ ἀκαθάρτῳ ἀπὸ τῆς σποδιᾶς τῆς κατακεκαυμένης τοῦ ἁγνισμοῦ, καὶ κέχεοῦσιν ἐπʼ αὐτὴν ὕδωρ ζῶν εἰς σκεῦος. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Καὶ λήψεται ὕσσωπον, καὶ βάψει εἰς τὸ ὕδωρ ἀνὴρ καθαρὸς, καὶ περιῤῥανεῖ ἐπὶ τὸν οἶκον, καὶ ἐπὶ τὰ σκεύη, καὶ ἐπὶ τὰς ψυχὰς, ὅσαι ἂν ὦσιν ἐκεῖ, καὶ ἐπὶ τὸν ἡμμένον τοῦ ὀστέου τοῦ ἀνθρωπίνου, ἢ τοῦ τραυματίου, ἢ τοῦ τεθνηκότος, ἢ τοῦ μνήματος. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Καὶ περιῤῥανεῖ ὁ καθαρὸς ἐπὶ τὸν ἀκάθαρτον ἐν τῇ ἡμέρᾳ τῇ τρίτῃ καὶ ἐν τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ ἀφαγνισθήσεται τῇ ἡμέρᾳ τῇ ἑβδόμῃ· καὶ πλυνεῖ τὰ ἱμάτια αὐτοῦ, καὶ λούσεται ὕδατι, καὶ ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Καὶ ἄνθρωπος ὃς ἂν μιανθῇ, καὶ μὴ ἀφαγνισθῇ, ἐξολοθρευθήσεται ἡ ψυχὴ ἐκείνη ἐκ μέσου τῆς συναγωγῆς, ὅτι τὰ ἅγια Κυρίου ἐμίανεν, ὅτι ὕδωρ ῥαντισμοῦ οὐ περιεῤῥαντίσθη ἐπʼ αὐτόν· ἀκάθαρτός ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Καὶ ἔσται ὑμῖν νόμιμον αἰώνιον· καὶ ὁ περιῤῥαίνων ὕδωρ ῥαντισμοῦ, πλυνεῖ τὰ ἱμάτια αὐτοῦ· καὶ ὁ ἁπτόμενος τοῦ ὕδατος τοῦ ῥαντισμοῦ, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Καὶ παντὸς οὗ ἐὰν ἅψηται αὐτοῦ ὁ ἀκάθαρτος, ἀκάθαρτον ἔσται· καὶ ψυχὴ ἡ ἁπτομένη, ἀκάθαρτος ἔσται ἕως ἑσπέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Καὶ ἦλθον οἱ υἱοὶ Ἰσραὴλ, πᾶσα ἡ συναγωγὴ, εἰς τὴν ἔρημον Σὶν, ἐν τῷ μηνὶ τῷ πρώτῳ, καὶ κατέμεινεν ὁ λαὸς ἐν Κάδης· καὶ ἐτελεύτησεν ἐκεῖ Μαριὰμ, καὶ ἐτάφη ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Καὶ οὐκ ἦν ὕδωρ τῇ συναγωγῇ· καὶ ἠθροίσθησαν ἐπὶ Μωυσῆν καὶ Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Καὶ ἐλοιδορεῖτο ὁ λαὸς πρὸς Μωυσῆν, λέγοντες, ὄφελον ἀπεθάνομεν ἐν τῇ ἀπωλείᾳ τῶν ἀδελφῶν ἡμῶν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Καὶ ἱνατί ἀνηγάγετε τὴν συναγωγὴν Κυρίου εἰς τὴν ἔρημον ταύτην ἀποκτεῖναι ἡμᾶς, καὶ τα κτήνη ἡμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Καὶ ἱνατί τοῦτο; ἀνηγάγετε ἡμᾶς ἐξ Αἰγύπτου, παραγενέσθαι εἰς τὸν τόπον τὸν πονηρὸν τοῦτον· τόπος οὗ οὐ σπείρεται, οὐδὲ συκαῖ, οὐδὲ ἄμπελοι, οὔτε ῥοαὶ, οὔτε ὕδωρ ἐστὶ πιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Καὶ ἦλθε Μωυσῆς καὶ Ἀαρὼν ἀπὸ προσώπου τῆς συναγωγῆς ἐπὶ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου, καὶ ἔπεσον ἐπὶ πρόσωπον· καὶ ὤφθη ἡ δόξα Κυρίου πρὸς αὐτοὺς. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","λάβε τὴν ῥάβδον σου, καὶ ἐκκλησίασον τὴν συναγωγὴν σὺ καὶ Ἀαρὼν ὁ ἀδελφός σου, καὶ λαλήσατε πρὸς τὴν πέτραν ἐναντίον αὐτῶν, καὶ δώσει τὰ ὕδατα αὐτῆς, καὶ ἐξοίσετε αὐτοῖς ὕδωρ ἐκ τῆς πέτρας, καὶ ποτιεῖτε τὴν συναγωγὴν, καὶ τὰ κτήνη αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Καὶ ἔλαβε Μωυσῆς τὴν ῥάβδον τὴν ἀπέναντι Κυρίου, καθὰ συνέταξε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Καὶ ἐξεκκλησίασε Μωυσῆς καὶ Ἀαρὼν τὴν συναγωγὴν ἀπέναντι τῆς πέτρας, καὶ εἶπε πρὸς αὐτοὺς, ἀκούσατέ μου οἱ ἀπειθεῖς· μὴ ἐκ τῆς πέτρας ταύτης ἐξάξομεν ὑμῖν ὕδωρ; ");
INSERT INTO grcbrent_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Καὶ ἐπάρας Μωυσῆς τὴν χεῖρα αὐτοῦ, ἐπάταξε τὴν πέτραν τῇ ῥάβδῳ δίς· καὶ ἐξῆλθεν ὕδωρ πολὺ, καὶ ἔπιεν ἡ συναγωγὴ, καὶ τὰ κτήνη αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Καὶ εἶπε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν, ὅτι οὐκ ἐπιστεύσατε ἁγιάσαι με ἐναντίον τῶν υἱῶν Ἰσραὴλ, διὰ τοῦτο οὐκ εἰσάξετε ὑμεῖς τὴν συναγωγὴν ταύτην εἰς τὴν γῆν ἣν δέδωκα αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Τοῦτο τὸ ὕδωρ Ἀντιλογίας, ὅτι ἐλοιδορήθησαν οἱ υἱοὶ Ἰσραὴλ ἔναντι Κυρίου, καὶ ἡγιάσθη ἐν αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Καὶ ἀπέστειλε Μωυσῆς ἀγγέλους ἐκ Κάδης πρὸς βασιλέα Ἐδὼμ, λέγων, τάδε λέγει ὁ ἀδελφός σου Ἰσραήλ· σὺ ἐπίστῃ πάντα τὸν μόχθον τὸν εὑρόντα ἡμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Καὶ κατέβησαν οἱ πατέρες ἡμῶν εἰς Αἴγυπτον, καὶ παρῳκήσαμεν ἐν Αἰγύπτῳ ἡμέρας πλείους, καὶ ἐκάκωσαν ἡμᾶς οἱ Αἰγύπτιοι καὶ τοὺς πατέρας ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Καὶ ἀνεβοήσαμεν πρὸς Κύριον, καὶ εἰσήκουσε Κύριος τῆς φωνῆς ἡμῶν, καὶ ἀποστείλας ἄγγελον, ἐξήγαγεν ἡμᾶς ἐξ Αἰγύπτου· καὶ νῦν ἐσμὲν ἐν Κάδης πόλει, ἐκ μέρους τῶν ὁρίων σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Παρελευσόμεθα διὰ τῆς γῆς σου· οὐ διελευσόμεθα διʼ ἀγρῶν, οὐδὲ διʼ ἀμπελώνων, οὐδὲ πιόμεθα ὕδωρ ἐκ λάκκου σου· ὁδῷ βασιλικῇ πορευσόμεθα· οὐκ ἐκκλινοῦμεν δεξιὰ οὐδὲ εὐώνυμα, ἕως ἂν παρέλθωμεν τὰ ὅριά σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Καὶ εἶπε πρὸς αὐτὸν Ἐδὼμ, Οὐ διελεύσῃ διʼ ἐμοῦ· εἰ δὲ μὴ, ἐν πολέμῳ ἐξελεύσομαι εἰς συνάντησίν σοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Καὶ λέγουσιν αὐτῷ οἱ υἱοὶ Ἰσραὴλ, παρὰ τὸ ὄρος παρελευσόμεθα· ἐὰν δὲ τοῦ ὕδατός σου πίωμεν ἐγώ τε καὶ τὰ κτήνη μου, δώσω τιμήν σοι· ἀλλὰ τὸ πρᾶγμα οὐδέν ἐστι· παρὰ τὸ ὄρος παρελευσόμεθα. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ὁ δὲ εἶπεν, οὐ διελεύσῃ διʼ ἐμοῦ· καὶ ἐξῆλθεν Ἐδὼμ εἰς συνάντησιν αὐτῷ ἐν ὄχλῳ βαρεῖ, καὶ ἐν χειρὶ ἰσχυρᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Καὶ οὐκ ἠθέλησεν Ἐδὼμ δοῦναι τῷ Ἰσραὴλ παρελθεῖν διὰ τῶν ὁρίων αὐτοῦ· καὶ ἐξέκλινεν Ἰσραὴλ ἀπʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Καὶ ἀπῇραν ἐκ Καδης· καὶ παρεγένοντο οἱ υἱοὶ Ἰσραὴλ πᾶσα ἡ συναγωγὴ εἰς Ὢρ τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Καὶ εἶπε Κύριος πρὸς Μωυσῆν καὶ Ἀαρὼν ἐν Ὢρ τῷ ὄρει ἐπὶ τῶν ὁρίων τῆς γῆς Ἐδὼμ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","προστεθήτω Ἀαρὼν πρὸς τὸν λαὸν αὐτοῦ, ὅτι οὐ μὴ εἰσέλθητε εἰς τὴν γῆν ἣν δέδωκα τοῖς υἱοῖς Ἰσραήλ, διότι παρωξύνατέ με ἐπὶ τοῦ ὕδατος τῆς λοιδορίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Λάβε τὸν Ἀαρὼν, καὶ Ἐλεάζαρ τὸν υἱὸν αὐτοῦ, καὶ ἀναβίβασον αὐτοὺς εἰς Ὢρ τὸ ὄρος, ἔναντι πάσης τῆς συναγωγῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","καὶ ἔκδυσον Ἀαρὼν τὴν στολὴν αὐτοῦ, καὶ ἔνδυσον Ἐλεάζαρ τὸν υἱὸν αὐτοῦ· καὶ Ἀαρὼν προστεθεὶς ἀποθανέτω ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Καὶ ἐποίησε Μωυσῆς καθὰ συνέταξε Κύριος αὐτῷ, καὶ ἀνεβίβασεν αὐτὸν εἰς Ὢρ τὸ ὄρος, ἐναντίον πάσης τῆς συναγωγῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","καὶ ἐξέδυσε τὸν Ἀαρὼν τὰ ἱμάτια αὐτοῦ, καὶ ἐνέδυσεν αὐτὰ Ἐλεάζαρ τὸν υἱὸν αὐτοῦ· καὶ ἀπέθανεν Ἀαρὼν ἐπὶ τῆς κορυφῆς τοῦ ὄρους· καὶ κατέβη Μωυσῆς καὶ Ἐλεάζαρ ἐκ τοῦ ὄρους. ");
INSERT INTO grcbrent_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Καὶ εἶδε πᾶσα ἡ συναγωγὴ ὅτι ἀπελύθη Ἀαρὼν, καὶ ἔκλαυσαν τὸν Ἀαρὼν τριάκοντα ἡμέρας πᾶς οἶκος Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Καὶ ἤκουσεν ὁ Χανανεὶς βασιλεὺς Ἀρὰδ ὁ κατοικῶν κατὰ τὴν ἔρημον, ὅτι ἦλθεν Ἰσραὴλ ὁδὸν Ἀθαρεὶν, καὶ ἐπολέμησε πρὸς Ἰσραὴλ, καὶ κατεπροενόμευσεν ἐξ αὐτῶν αἰχμαλωσίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Καὶ ηὔξατο Ἰσραὴλ εὐχὴν Κυρίῳ, καὶ εἶπεν, ἐάν μοι παραδῷς τὸν λαὸν τοῦτον ὑποχείριον, ἀναθεματιῶ αὐτὸν καὶ τὰς πόλεις αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Καὶ εἰσήκουσε Κύριος τῆς φωνῆς Ἰσραὴλ, καὶ παρέδωκε τὸν Χανανεὶν ὑποχείριον αὐτοῦ· καὶ ἀνεθεμάτισεν αὐτὸν, καὶ τὰς πόλεις αὐτοῦ· καὶ ἐπεκάλεσαν τὸ ὄνομα τοῦ τόπου ἐκείνου, Ἀνάθεμα. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Καὶ ἀπάραντες ἐξ Ὢρ τοῦ ὄρους ὁδὸν ἐπὶ θάλασσαν ἐρυθρᾶν, περιεκύκλωσαν γῆν Ἐδώμ· καὶ ὠλιγοψύχησεν ὁ λαὸς ἐν τῇ ὁδῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Καὶ κατελάλει ὁ λαὸς πρὸς τὸν Θεὸν καὶ κατὰ Μωυσῆ, λέγοντες, ἱνατί τοῦτο; ἐξήγαγες ἡμᾶς ἐξ Αἰγύπτου ἀποκτεῖναι ἐν τῇ ἐρήμῳ; ὅτι οὐκ ἔστιν ἄρτος, οὐδὲ ὕδωρ· ἡ δὲ ψυχὴ ἡμῶν προσώχθισεν ἐν τῷ ἄρτῳ τῷ διακένῳ τούτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Καὶ ἀπέστειλε Κύριος εἰς τὸν λαὸν τοὺς ὄφεις τοὺς θανατοῦντας, καὶ ἔδακνον τὸν λαόν, καὶ ἀπέθανε λαὸς πολὺς τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Καὶ παραγενόμενος ὁ λαὸς πρὸς Μωυσῆν, ἔλεγον, ὅτι ἡμάρτομεν, ὅτι κατελαλήσαμεν κατὰ τοῦ Κυρίου, καὶ κατὰ σοῦ· εὔξαι οὖν πρὸς Κύριον, καὶ ἀφελέτω ἀφʼ ἡμῶν τὸν ὄφιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Καὶ ηὔξατο Μωυσῆς πρὸς Κύριον περὶ τοῦ λαοῦ· καὶ εἰπε Κύριος πρὸς Μωυσῆν, ποίησον σεαυτῷ ὄφιν, καὶ θὲς αὐτὸν ἐπὶ σημείου, καὶ ἔσται ἐὰν δάκῃ ὄφις ἄνθρωπον, πᾶς ὁ δεδηγμένος ἰδὼν αὐτὸν ζήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Καὶ ἐποίησε Μωυσῆς ὄφιν χαλκοῦν, καὶ ἔστησεν αὐτὸν ἐπὶ σημείου· καὶ ἐγένετο ὅταν ἔδακνεν ὄφις ἄνθρωπον, καὶ ἐπέβλεψεν ἐπὶ τὸν ὄφιν τὸν χαλκοῦν, καὶ ἔζη. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Καὶ ἀπῇραν οἱ υἱοὶ Ἰσραὴλ, καὶ παρενέβαλον ἐν Ὠβώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Καὶ ἐξάραντες ἐξ Ὠβὼθ, καὶ παρενέβαλον ἐν Ἀχαλγαὶ ἐκ τοῦ πέραν ἐν τῇ ἐρήμῳ, ἥ ἐστι κατὰ πρόσωπον Μωὰβ, κατʼ ἀνατολὰς ἡλίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Καὶ ἐκεῖθεν ἀπῇραν, καὶ παρενέβαλον εἰς φάραγγα Ζαρέδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Καὶ ἐκεῖθεν ἀπάραντες παρενέβαλον εἰς τὸ πέραν Ἀρνῶν ἐν τῇ ἐρήμῳ, τὸ ἐξέχον ἀπὸ τῶν ὁρίων τῶν Ἀμοῤῥαίων· ἔστι γὰρ Ἀρνῶν ὅρια Μωὰβ, ἀναμέσον Μωὰβ καὶ ἀναμέσον τοῦ Ἀμοῤῥαίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Διὰ τοῦτο λέγεται ἐν βιβλίῳ, πόλεμος τοῦ Κυρίου τὴν Ζωὸβ ἐφλόγισε, καὶ τοὺς χιμάῤῥους Ἀρνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Καὶ τοὺς χιμάῤῥους κατέστησε κατοικίσαι Ἤρ· καὶ πρόσκειται τοῖς ὁρίοις Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Καὶ ἐκεῖθεν τὸ φρέαρ· τοῦτο φρέαρ, ὃ εἶπε Κύριος πρὸς Μωυσῆν, συνάγαγε τὸν λαὸν, καὶ δώσω αὐτοῖς ὕδωρ πιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Τότε ᾖσεν Ἰσραὴλ τὸ ἆσμα τοῦτο ἐπὶ τοῦ φρέατος, ἐξάρχετε αὐτῷ φρέαρ, ");
INSERT INTO grcbrent_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ὤρυξαν αὐτὸ ἄρχοντες, ἐξελατόμησαν αὐτὸ βασιλεῖς ἐθνῶν ἐν τῇ βασιλείᾳ αὐτῶν, ἐν τῷ κυριεῦσαι αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","καὶ ἀπὸ φρέατος εἰς Μανθαναεὶν, καὶ ἀπὸ Μανθαναεὶν εἰς Νααλιὴλ, καὶ ἀπὸ Νααλιὴλ εἰς Βαμὼθ, καὶ ἀπὸ Βαμὼθ εἰς Ἰανὴν, ἥ ἐστιν ἐν τῷ πεδίῳ Μωὰβ, ἀπὸ κορυφῆς τοῦ λελαξευμένου, τὸ βλέπον κατὰ πρόσωπον τῆς ἐρήμου. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Καὶ ἀπέστειλε Μωυσῆς πρέαβεις πρὸς Σηὼν βασιλέα Ἀμοῤῥαίων, λόγοις εἰρηνικοῖς, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","παρελευσόμεθα διὰ τῆς γῆς σου, τῇ ὁδῷ πορευσόμεθα· οὐκ ἐκκλινοῦμεν οὔτε εἰς ἀγρὸν, οὔτε εἰς ἀμπελῶνα· ");
INSERT INTO grcbrent_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Οὐ πιόμεθα ὕδωρ ἐκ φρέατός σου· ὁδῷ βασιλικῇ παρευσόμεθα, ἕως παρέλθωμεν τὰ ὅριά σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Καὶ οὐκ ἔδωκε Σηὼν τῷ Ἰσραὴλ παρελθεῖν διὰ τῶν ὁρίων αὐτοῦ· καὶ συνήγαγε Σηὼν πάντα τὸν λαὸν αὐτοῦ, καὶ ἐξῆλθε παρατάξασθαι τῷ Ἰσραὴλ εἰς τὴν ἔρημον· καὶ ἦλθεν εἰς Ἰασσὰ, καὶ παρετάξατο τῷ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Καὶ ἐπάταξεν αὐτὸν Ἰσραὴλ φόνῳ μαχαίρης, καὶ κατεκυρίευσαν τῆς γῆς αὐτοῦ, ἀπὸ Ἀρνῶν ἕως Ἰαβὸκ, ἕως υἱῶν Ἀμμὰν, ὅτι Ἰαζὴρ ὅρια υἱῶν Ἀμμάν ἐστι. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Καὶ ἔλαβεν Ἰσραὴλ πάσας τὰς πόλεις ταύτας, καὶ κατῷκησεν Ἰσραὴλ ἐν πάσαις ταῖς πόλεσι τῶν Ἀμοῤῥαίων, ἐν Ἑσεβὼν, καὶ ἐν πάσαις ταῖς συγκυρούσαις αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ἔστι γὰρ Ἐσεβὼν, πόλις Σηὼν τοῦ βασιλέως τῶν Ἀμοῤῥαίων ἐστίν· καὶ οὗτος ἐπολέμησε βασιλέα Μωὰβ τὸ πρότερον· καὶ ἔλαβον πᾶσαν τὴν γῆν αὐτοῦ, ἀπὸ Ἀροὴρ ἕως Ἀρνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Διὰ τοῦτο ἐροῦσιν οἱ αἰνιγματισταὶ, ἔλθετε εἰς Ἐσεβὼν, ἵνα οἰκοδομηθῇ καὶ κατασκευασθῇ πόλις Σηών· ");
INSERT INTO grcbrent_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ὅτι πῦρ ἐξῆλθεν ἐξ Ἑσεβὼν, φλὸξ ἐκ πόλεως Σηὼν, καὶ κατέφαγεν ἕως Μωὰβ, καὶ κατέπιε στήλας Ἀρνῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Οὐαί σοι Μωὰβ, ἀπώλου λαὸς Χαμώς· ἀπεδόθησαν οἱ υἱοὶ αὐτῶν διασώζεσθαι, καὶ αἱ θυγατέρες αὐτῶν αἰχμάλωτοι τῷ βασιλεῖ τῶν Ἀμοῤῥαίων Σηὼν, ");
INSERT INTO grcbrent_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","καὶ τὸ σπέρμα αὐτῶν ἀπολεῖται, Ἑσεβὼν ἕως Δαιβών· καὶ αἱ γυναῖκες ἔτι προσεξέκαυσαν πῦρ ἐπὶ Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Κατῴκησε δὲ Ἰσραὴλ ἐν πάσαις ταῖς πόλεσι τῶν Ἀμοῤῥαίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Καὶ ἀπέστειλε Μωυσῆς κατασκέψασθαι τὴν Ἰαζήρ· καὶ κατελάβοντο αὐτὴν, καὶ τὰς κώμας αὐτῆς, καὶ ἐξέβαλον τὸν Ἀμοῤῥαῖον τὸν κατοικοῦντα ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Καὶ ἐπιστρέψαντες, ἀνέβησαν ὁδὸν τὴν εἰς Βασάν· καὶ ἐξῆλθεν Ὢγ βασιλεὺς τῆς Βασὰν εἰς συνάντησιν αὐτοῖς, καὶ πᾶς ὁ λαὸς αὐτοῦ εἰς πόλεμον εἰς Ἐδραείν. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, μὴ φοβηθῇς αὐτὸν, ὅτι εἰς τὰς χεῖράς σου παραδέδωκα αὐτὸν, καὶ πάντα τὸν λαὸν αὐτοῦ, καὶ πᾶσαν τὴν γῆν αὐτοῦ· καὶ ποιήσεις αὐτῷ καθὼς ἐποίησας τῷ Σηὼν βασιλεῖ τῶν Ἀμοῤῥαίων, ὃς κατῴκει ἐν Ἑσεβών. ");
INSERT INTO grcbrent_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Καὶ ἐπάταξεν αὐτὸν καὶ τοὺς υἱοὺς αὐτοῦ, καὶ πάντα τὸν λαὸν αὐτοῦ, ἕως τοῦ μὴ καταλιπεῖν αὐτοῦ ζωγρείαν· καὶ ἐκληρονόμησαν τὴν γῆν αὐτον. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Καὶ ἀπάραντες οἱ υἱοὶ Ἰσραὴλ παρενέβαλον ἐπὶ δυσμῶν Μωὰβ παρὰ τὸν Ἰορδάνην κατὰ Ἰεριχώ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Καὶ ἰδὼν Βαλὰκ υἱὸς Σεπφὼρ πάντα ὅσα ἐποίησεν Ἰσραὴλ τῷ Ἀμοῤῥαίῳ, ");
INSERT INTO grcbrent_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","καὶ ἐφοβήθη Μωὰβ τὸν λαὸν σφόδρα ὅτι πολλοὶ ἦσαν· καὶ προσώχθισε Μωὰβ ἀπὸ προσώπου υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Καὶ εἶπε Μωὰβ τῇ γερουσίᾳ Μαδιὰμ, νῦν ἐκλείξει ἡ συναγωγὴ αὕτη πάντας τοὺς κύκλῳ ἡμῶν, ὡσεὶ ἐκλείξαι ὁ μόσχος τὰ χλωρὰ ἐκ τοῦ πεδίου· καὶ Βαλὰκ υἱὸς Σεπφὼρ βασιλεὺς Μωὰβ ἦν κατὰ τὸν καιρὸν ἐκεῖνον. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Καὶ ἀπέστειλε πρέσβεις πρὸς Βαλαὰμ υἱὸν Βεὼρ Φαθουρὰ, ὅ ἐστιν ἐπὶ τοῦ ποταμοῦ γῆς υἱῶν λαοῦ αὐτοῦ, καλέσαι αὐτὸν, λέγων, ἰδοὺ λαὸς ἐξελήλυθεν ἐξ Αἰγύπτου, καὶ ἰδοὺ κατεκάλυψε τὴν ὄψιν τῆς γῆς, καὶ οὗτος ἐγκάθηται ἐχόμενός μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Καὶ νῦν δεῦρο ἄρασαί μοι τὸν λαὸν τοῦτον, ὅτι ἰσχύει οὗτος ἢ ἡμεῖς, ἐὰν δυνώμεθα πατάξαι ἐξ αὐτῶν, καὶ ἐκβαλῶ αὐτοὺς ἐκ τῆς γῆς· ὅτι οἶδα οὓς ἐὰν εὐλογήσῃς σὺ, εὐλόγηνται, καὶ οὓς ἂν καταράσῃ σὺ, κεκατήρανται. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Καὶ ἐπορεύθη ἡ γερουσία Μωὰβ, καὶ ἡ γερουσία Μαδιὰμ, καὶ τὰ μαντεῖα ἐν ταῖς χερσὶν αὐτῶν· καὶ ἦλθον πρὸς Βαλαὰμ, καὶ εἶπαν αὐτῷ τὰ ῥήματα Βαλάκ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Καὶ εἶπε πρὸς αὐτοὺς, καταλύσατε αὐτοῦ τὴν νύκτα, καὶ ἀποκριθήσομαι ὑμῖν πράγματα ἃ ἂν λαλήσῃ Κύριος πρὸς μέ· καὶ κατέμειναν οἱ ἄρχοντες Μωὰβ παρὰ Βαλαάμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Καὶ ἦλθεν ὁ Θεὸς πρὸς Βαλαὰμ, καὶ εἶπεν αὐτῷ, τί οἱ ἄνθρωποι οὗτοι παρὰ σοί; ");
INSERT INTO grcbrent_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Καὶ εἶπε Βαλαὰμ πρὸς τὸν Θεὸν, Βαλὰκ υἱὸς Σεπφὼρ, βασιλεὺς Μωὰβ, ἀπέστειλεν αὐτοὺς πρὸς μὲ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ἰδοὺ λαὸς ἐξελήλυθεν ἐξ Αἰγύπτου, καὶ κεκάλυφεν τὴν ὄψιν τῆς γῆς, καὶ οὗτος ἐγκάθηται ἐχόμενός μου, καὶ νῦν δεῦρο ἄρασαί μοι αὐτὸν, εἰ ἄρα δυνήσομαι πατάξαι αὐτὸν, καὶ ἐκβαλῶ αὐτὸν ἀπὸ τῆς γῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Καὶ εἶπεν ὁ Θεὸς πρὸς Βαλαὰμ, οὐ πορεύσῃ μετʼ αὐτῶν, οὐδὲ καταράσῃ τὸν λαόν· ἔστι γὰρ εὐλογημένος. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Καὶ ἀναστὰς Βαλαὰμ τοπρωῒ, εἶπε τοῖς ἄρχουσι Βαλὰκ, ἀποτρέχετε πρὸς τὸν κύριον ὑμῶν, οὐκ ἀφίησί με ὁ Θεὸς πορεύεσθαι μεθʼ ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Καὶ ἀναστάντες οἱ ἄρχοντες Μωὰβ, ἦλθον πρὸς Βαλὰκ, καὶ εἶπαν, οὐ θέλει Βαλαὰμ πορευθῆναι μεθʼ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Καὶ προσέθετο Βαλὰκ ἔτι ἀποστεῖλαι ἄρχοντας πλείους, καὶ ἐντιμοτέρους τούτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Καὶ ἦλθον πρὸς Βαλαὰμ, καὶ λέγουσιν αὐτῷ, τάδε λέγει Βαλὰκ ὁ τοῦ Σεπφώρ· ἀξιῶ σε μὴ ὀκνήσῃς ἐλθεῖν πρὸς μέ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ἐντίμως γὰρ τιμήσω σε, καὶ ὅσα ἐὰν εἴπῃς ποιήσω σοι· καὶ δεῦρο ἐπικατάρασαί μοι τὸν λαὸν τοῦτον. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Καὶ ἀπεκρίθη Βαλαὰμ, καὶ εἶπε τοῖς ἄρχουσι Βαλὰκ, ἐὰν δῷ μοι Βαλὰκ πλήρη τὸν οἶκον αὐτοῦ ἀργυρίου καὶ χρυσίου, οὐ δυνήσομαι παραβῆναι τὸ ῥῆμα Κυρίου τοῦ Θεοῦ, ποιῆσαι αὐτὸ μικρὸν ἢ μέγα ἐν τῇ διανοίᾳ μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Καὶ νῦν ὑπομείνατε αὐτοῦ καὶ ὑμεῖς τὴν νύκτα ταύτην, καὶ γνώσομαι τί προσθήσει Κύριος λαλῆσαι πρὸς μέ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Καὶ ἦλθεν ὁ Θεὸς πρὸς Βαλαὰμ νυκτὸς, καὶ εἶπεν αὐτῷ, εἰ καλέσαι σε πάρεισιν οἱ ἄνθρωποι οὗτοι, ἀναστὰς ἀκολούθησον αὐτοῖς· ἀλλὰ τὸ ῥῆμα ὃ ἐὰν λαλήσω πρὸς σὲ, τοῦτο ποιήσεις. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Καὶ ἀναστὰς Βαλαὰμ τοπρωῒ, ἐπέσαξε τὴν ὄνον αὐτοῦ, καὶ ἐπορεύθη μετὰ τῶν ἀρχόντων Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Καὶ ὠργίσθη θυμῷ ὁ Θεὸς ὅτι ἐπορεύθη αὐτός· καὶ ἀνέστη ὁ ἄγγελος τοῦ Θεοῦ διαβαλεῖν αὐτόν· καὶ αὐτὸς ἐπιβεβήκει ἐπὶ τῆς ὄνου αὐτοῦ, καὶ οἱ δύο παῖδες αὐτοῦ μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Καὶ ἰδοῦσα ἡ ὄνος τὸν ἄγγελον τοῦ Θεοῦ ἀνθεστηκότα ἐν τῇ ὁδῷ, καὶ τὴν ῥομφαίαν ἐσπασμένην ἐν τῇ χειρὶ αὐτοῦ, καὶ ἐξέκλινεν ἡ ὄνος ἐκ τῆς ὁδοῦ, καὶ ἐπορεύετο εἰς τὸ πεδίον· καὶ ἐπάταξε τὴν ὄνον ἐν τῇ ῥάβδῳ αὐτοῦ τοῦ εὐθῦναι αὐτὴν ἐν τῇ ὁδῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Καὶ ἔστη ὁ ἄγγελος τοῦ Θεοῦ ἐν ταῖς αὔλαξι τῶν ἀμπέλων, φραγμὸς ἐντεῦθεν καὶ φραγμὸς ἐντεῦθεν· ");
INSERT INTO grcbrent_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Καὶ ἰδοῦσα ἡ ὄνος τὸν ἄγγελον τοῦ Θεοῦ, προσέθλιψεν ἑαυτὴν πρὸς τὸν τοῖχον, καὶ ἀπέθλιψεν τὸν πόδα Βαλαὰμ πρὸς τὸν τοῖχον· καὶ προσέθετο ἔτι μαστίξαι αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Καὶ προσέθετο ὁ ἄγγελος τοῦ Θεοῦ, καὶ ἀπελθὼν ὑπέστη ἐν τόπῳ στενῷ, εἰς ὃν οὐκ ἦν ἐκκλῖναι δεξιὰν ἢ ἀριστεράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Καὶ ἰδοῦσα ἡ ὄνος τὸν ἄγγελον τοῦ Θεοῦ, συνεκάθισεν ὑποκάτω Βαλαάμ· καὶ ἐθυμώθη Βαλαὰμ, καὶ ἔτυπτε τὴν ὄνον τῇ ῥάβδῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Καὶ ἤνοιξεν ὁ Θεὸς τὸ στόμα τῆς ὄνου, καὶ λέγει τῷ Βαλαὰμ, τί ἐποίησά σοι, ὅτι πέπαικάς με τρίτον τοῦτο; ");
INSERT INTO grcbrent_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Καὶ εἶπε Βαλαὰμ τῇ ὄνῳ, ὅτι ἐμπέπαιχάς μοι, καὶ εἰ εἶχον μάχαιραν ἐν τῇ χειρὶ ἤδη ἂν ἐξεκέντησά σε. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Καὶ λέγει ἡ ὄνος τῷ Βαλαὰμ, οὐκ ἐγὼ ἡ ὄνος σου ἐφʼ ἧς ἐπέβαινες ἀπὸ νεότητός σου, ἕως τῆς σήμερον ἡμέρας; μὴ ὑπεροράσει ὑπεριδούσα ἐποίησά σοι οὕτως; ὁ δὲ εἶπεν, οὐχί. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ἀπεκάλυψε δὲ ὁ Θεὸς τοὺς ὀφθαλμοὺς Βαλαὰμ, καὶ ὁρᾷ τὸν ἄγγελον Κυρίου ἀνθεστηκότα ἐν τῇ ὁδῷ, καὶ τὴν μάχαιραν ἐσπασμένην ἐν τῇ χειρὶ αὐτοῦ, καὶ κύψας προσεκύνησε τῷ προσώπῳ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Καὶ εἶπεν αὐτῷ ὁ ἄγγελος τοῦ Θεοῦ, διατί ἐπάταξας τὴν ὄνον σου τοῦτο τρίτον; καὶ ἰδοὺ ἐγὼ ἐξῆλθον εἰς διαβολήν σου, ὅτι οὐκ ἀστεία ἡ ὁδός σου ἐναντίον μου, καὶ ἰδοῦσά με ἡ ὄνος, ἐξέκλινεν ἀπʼ ἐμοῦ τρίτον τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Καὶ εἰ μὴ ἐξέκλινεν, νῦν οὖν σὲ μὲν ἀπέκτεινα, ἐκείνην δʼ ἂν περιεποιησάμην. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Καὶ εἶπε Βαλαὰμ τῷ ἀγγέλῳ Κυρίου, ἡμάρτηκα, οὐ γὰρ ἠπιστάμην ὅτι σύ μοι ἀνθέστηκας ἐν τῇ ὁδῷ εἰς συνάντησιν· καὶ νῦν εἰ μή σοι ἀρκέσει, ἀποστραφήσομαι. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Καὶ εἶπεν ὁ ἄγγελος τοῦ Θεοῦ πρὸς Βαλαὰμ, συμπορεύθητι μετὰ τῶν ἀνθρώπων· πλὴν τὸ ῥῆμα ὃ ἐὰν εἴπω πρὸς σὲ, τοῦτο φυλάξῃ λαλῆσαι. Καὶ ἐπορεύθη Βαλαὰμ μετὰ τῶν ἀρχόντων Βαλάκ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Καὶ ἀκούσας Βαλὰκ ὅτι ἥκει Βαλαὰμ, ἐξῆλθεν εἰς συνάντησιν αὐτῷ, εἰς πόλιν Μωάβ, ἥ ἐστιν ἐπὶ τῶν ὁρίων Ἀρνῶν, ἥ ἐστιν ἐκ μέρους τῶν ὁρίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Καὶ εἶπε Βαλὰκ πρὸς Βαλαὰμ, οὐχὶ ἀπέστειλα πρὸς σὲ καλέσαι σε; διατί οὐκ ἤρχου πρὸς μέ; ὄντως οὐ δυνήσομαι τιμῆσαί σε; ");
INSERT INTO grcbrent_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, ἰδοὺ ἥκω πρὸς σὲ νῦν· δυνατὸς ἔσομαι λαλῆσαί τι; τὸ ῥῆμα ὃ ἐὰν ἐμβάλῃ ὁ Θεὸς εἰς τὸ στόμα μου, τοῦτο λαλήσω. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Καὶ ἐπορεύθη Βαλαὰμ μετὰ Βαλὰκ, καὶ ἦλθον εἰς πόλεις ἐπαύλεων. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Καὶ ἔθυσε Βαλὰκ πρόβατα καὶ μόσχους, καὶ ἀπέστειλε τῷ Βαλαὰμ καὶ τοῖς ἄρχουσι τοῖς μετʼ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Καὶ ἐγενήθη πρωΐ· καὶ παραλαβὼν Βαλὰκ τὸν Βαλαάμ, ἀνεβίβασεν αὐτὸν ἐπὶ τὴν στήλην τοῦ Βαὰλ, καὶ ἔδειξεν αὐτῷ ἐκεῖθεν μέρος τι τοῦ λαοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Καὶ εἶπε Βαλαὰμ τῷ Βαλὰκ οἰκοδόμησόν μοι ἐνταῦθα ἑπτὰ βωμοὺς, καὶ ἐτοίμασόν μοι ἐνταῦθα ἑπτὰ μόσχους, καὶ ἑπτὰ κριούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Καὶ ἐποίησε Βαλὰκ ὃν τρόπον εἶπεν αὐτῷ Βαλαάμ· καὶ ἀνήνεγκε μόσχον καὶ κριὸν ἐπὶ τὸν βωμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, παράστηθι ἐπὶ τῆς θυσίας σου, καὶ πορεύσομαι εἴ μοι φανεῖται ὁ Θεὸς ἐν συναντήσει, καὶ ῥῆμα ὃ ἐάν μοι δείξῃ, ἀναγγελῶ σοι· καὶ παρέστη Βαλὰκ ἐπὶ τῆς θυσίας αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Καὶ Βαλαὰμ ἐπορεύθη ἐπερωτῆσαι τὸν Θεόν· καὶ ἐπορεύθη εὐθεῖαν· καὶ ἐφάνη ὁ Θεὸς τῷ Βαλαὰμ· καὶ εἶπε πρὸς αὐτὸν Βαλαάμ, τοὺς ἑπτὰ βωμοὺς ἡτοίμασα, καὶ ἀνεβίβασα μόσχον καὶ κριὸν ἐπὶ τὸν βωμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Καὶ ἐνέβαλεν ὁ Θεὸς ῥῆμα εἰς τὸ στόμα Βαλαὰμ, καὶ εἶπεν, ἐπιστραφεὶς πρὸς Βαλὰκ, οὕτω λαλήσεις. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Καὶ ἀπεστράφη πρὸς αὐτόν· καὶ ὁ δὲ ἐφιστήκει ἐπὶ τῶν ὁλοκαυτωμάτων αὐτοῦ, καὶ πάντες οἱ ἄρχοντες Μωὰβ μετʼ αὐτοῦ· καὶ ἐγενήθη πνεῦμα Θεοῦ ἐπʼ αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπεν ἐκ Μεσοποταμίας μετεπέμψατό με Βαλὰκ βασιλεὺς Μωὰβ ἐξ ὀρέων ἀπʼ ἀνατολῶν, λέγων, δεῦρο ἄρασαί μοι τὸν Ἰακώβ, καὶ δεῦρο ἐπικατάρασαί μοι τὸν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Τί ἀράσωμαι ὃν μὴ ἀρᾶται Κύριος; ἢ τί καταράσωμαι ὃν μὴ καταρᾶται ὁ Θεός; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ὅτι ἀπὸ κορυφῆς ὀρέων ὄψομαι αὐτὸν, καὶ ἀπὸ βουνῶν προσνοήσω αὐτόν· ἰδοὺ λαὸς μόνος κατοικήσει, καὶ ἐν ἔθνεσιν οὐ συλλογισθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Τίς ἐξηκριβάσατο τὸ σπέρμα Ἰακὼβ, καὶ τίς ἐξαριθμήσεται δήμους Ἰσραήλ; ἀποθάνοι ἡ ψυχή μου ἐν ψυχαῖς δικαίων, καὶ γένοιτο τὸ σπέρμα μου ὡς τὸ σπέρμα τούτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Καὶ εἶπε Βαλὰκ πρὸς Βαλαὰμ, τί πεποίηκάς μοι; εἰς κατάρασιν ἐχθρῶν μου κέκληκά σε, καὶ ἰδοὺ εὐλόγηκας εὐλογίαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, οὐχὶ ὅσα ἂν ἐμβάλῃ ὁ Θεὸς εἰς τὸ στόμα μου, τοῦτο φυλάξω λαλῆσαι; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Καὶ εἶπε πρὸς αὐτὸν Βαλὰκ, δεῦρο ἔτι μετʼ ἐμοῦ εἰς τόπον ἄλλον ἐξ οὗ οὐκ ὄψει αὐτὸν ἐκεῖθεν, ἀλλʼ ἢ μέρος τι αὐτοῦ ὄψει, πάντας δὲ οὐ μὴ ἴδῃς, καὶ κατάρασαί μοι αὐτὸν ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Καὶ παρέλαβεν αὐτὸν εἰς ἀγροῦ σκοπιὰν ἐπὶ κορυφὴν λελαξευμένου· καὶ ᾠκοδόμησεν ἐκεῖ ἑπτὰ βωμοὺς, καὶ ἀνεβίβασε μόσχον καὶ κριὸν ἐπὶ τὸν βωμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, παράστηθι ἐπὶ τῆς θυσίας σου, ἐγὼ δὲ πορεύσομαι ἐπερωτῆσαι τὸν Θεόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Καὶ συνήντησεν ὁ Θεὸς τῷ Βαλαὰμ, καὶ ἐνέβαλε ῥῆμα εἰς τὸ στόμα αὐτοῦ, καὶ εἶπεν, ἀποστράφηθι πρὸς Βαλὰκ, καὶ τάδε λαλήσεις. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Καὶ ἀπεστράφη πρὸς αὐτόν· καὶ ὁ δὲ ἐφειστήκει ἐπὶ τῆς ὁλοκαυτώσεως αὐτοῦ, καὶ πάντες οἱ ἄρχοντες Μωὰβ μετʼ αὐτοῦ· καὶ εἶπεν αὐτῷ Βαλὰκ, τί ἐλάλησε Κύριος; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπεν, ἀνάστηθι Βαλὰκ, καὶ ἄκουε, ἐνώτισαι μάρτυς υἱὸς Σεπφώρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Οὐχ ὡς ἄνθρωπος ὁ Θεὸς διαρτηθῆναι, οὐδʼ ὡς υἱὸς ἀνθρώπου ἀπειληθῆναι, αὐτὸς εἴπας, οὐχὶ ποιήσει; λαλήσει, καὶ οὐχὶ ἐμμενεῖ; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ἰδοὺ εὐλογεῖν παρείλημμαι· εὐλογήσω, καὶ οὐ μὴ ἀποστρέψω. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Οὐκ ἔσται μόχθος ἐν Ἰακὼβ, οὐδὲ ὀφθήσεται πόνος ἐν Ἰσραήλ· Κύριος ὁ θεὸς αὐτοῦ μετʼ αὐτοῦ, τὰ ἔνδοξα ἀρχόντων ἐν αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Θεὸς ὁ ἐξαγαγὼν αὐτὸν ἐξ Αἰγύπτου, ὡς δόξα μονοκέρωτος αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Οὐ γάρ ἐστιν οἰωνισμὸς ἐν Ἰακὼβ, οὐδὲ μαντεία ἐν Ἰσραήλ· κατὰ καιρὸν ῥηθήσεται Ἰακὼβ, καὶ τῷ Ἰσραὴλ, τί ἐπιτελέσει ὁ Θεός; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ἰδοὺ λαὸς ὡς σκύμνος ἀναστήσεται, καὶ ὡς λέων γαυρωθήσεται· οὐ κοιμηθήσεται ἕως φάγῃ θήραν, καὶ αἷμα τραυματιῶν πίεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Καὶ εἶπε Βαλὰκ πρὸς Βαλαὰμ, οὔτε κατάραις καταράσῃ μοι αὐτὸν, οὔτε εὐλογῶν μὴ εὐλογήσῃς αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Καὶ ἀποκριθεὶς Βαλαὰμ, εἶπε τῷ Βαλὰκ, οὐκ ἐλάλησά σοι, λέγων, τὸ ῥῆμα ὃ ἐὰν λαλήσῃ ὁ Θεὸς, τοῦτο ποιήσω; ");
INSERT INTO grcbrent_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Καὶ εἶπε Βαλὰκ πρὸς Βαλαὰμ, δεῦρο παραλάβω σε εἰς τόπον ἄλλον, εἰ ἀρέσει τῷ Θεῷ, καὶ κατάρασαί μοι αὐτὸν ἐκεῖθεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Καὶ παρέλαβε Βαλὰκ τὸν Βαλαὰμ ἐπὶ κορυφὴν τοῦ Φογὼρ, τὸ παρατεῖνον εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, οἰκοδόμησόν μοι ὧδε ἑπτὰ βωμοὺς, καὶ ἑτοίμασόν μοι ὧδε ἑπτὰ μόσχους, καὶ ἑπτὰ κριούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Καὶ ἐποίησε Βαλὰκ καθάπερ εἶπεν αὐτῷ Βαλαάμ, καί ἀνήνεγκε μόσχον καὶ κριὸν ἐπὶ τὸν βωμόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Καὶ ἰδὼν Βαλαὰμ ὅτι καλόν ἐστιν ἐναντίον Κυρίου εὐλογεῖν τὸν Ἰσραὴλ, οὐκ ἐπορεύθη κατὰ τὸ εἰωθὸς αὐτῷ εἰς συνάντησιν τοῖς οἰωνοῖς, καὶ ἀπέστρεψε τὸ πρόσωπον αὐτοῦ εἰς τὴν ἔρημον. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Καὶ ἐξάρας Βαλαὰμ τοὺς ὀφθαλμοὺς αὐτοῦ, καθορᾷ τὸν Ἰσραὴλ ἐστρατοπεδευκότα κατὰ φυλάς· καὶ ἐγένετο ἐπʼ αὐτῷ πνεῦμα Θεου. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπε, φησὶ Βαλαὰμ υἱοῖς Βεὼρ, φησὶν ὁ ἄνθρωπος ὁ ἀληθινῶς ὁρῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","φησὶν ἀκούων λόγια ἰσχυροῦ, ὅστις ὅρασιν Θεοῦ εἶδεν ἐν ὕπνῳ· ἀποκεκαλυμμένοι οἱ ὀφθαλμοὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ὡς καλοὶ οἱ οἶκοί σου Ἰακὼβ, αἱ σκηναί σου Ἰσραήλ· ");
INSERT INTO grcbrent_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ὡσεὶ νάπαι σκιάζουσαι, καὶ ὡσεὶ παράδεισοι ἐπὶ ποταμῷ, καὶ ὡσεὶ, σκηναὶ, ἃς ἔπηξε Κύριος, καί ὡσεὶ κέδροι παρʼ ὕδατα. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ἐξελεύσεται ἄνθρωπος ἐκ τοῦ σπέρματος αὐτοῦ, καὶ κυριεύσει ἐθνῶν πολλῶν· καὶ ὑψωθήσεται ἡ Γὼγ βασιλεία, καὶ αὐξηθήσεται βασιλεία αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Θεὸς ὡδήγησεν αὐτὸν ἐξ Αἰγύπτου· ὡς δόξα μονοκέρωτος αὐτῷ· ἔδεται ἔθνη ἐχθρῶν αὐτοῦ, καὶ τὰ πάχη αὐτῶν ἐκμυελιεῖ, καὶ ταῖς βολίσιν αὐτοῦ κατατοξεύσει ἐχθρόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Κατακλιθεὶς ἀνεπαύσατο ὡς λέων, καὶ ὡς σκύμνος· τίς ἀναστήσει αὐτόν· οἱ εὐλογοῦντές σε, εὐλόγηνται· καὶ οἱ καταρώμενοί σε, κεκατήρανται. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Καὶ ἐθυμώθη Βαλὰκ ἐπὶ Βαλαὰμ, καὶ συνεκρότησε ταῖς χερσὶν αὐτοῦ, καὶ εἶπε Βαλὰκ πρὸς Βαλαὰμ, καταρᾶσθαι τὸν ἐχθρόν μου κέκληκά σε, καὶ ἰδοὺ εὐλογῶν εὐλόγησας τρίτον τοῦτο. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Νῦν οὖν φεῦγε εἰς τὸν τόπον σου· εἶπα, τιμήσω σε, καὶ νῦν ἐστέρησέ σε Κύριος τῆς δόξης. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Καὶ εἶπε Βαλαὰμ πρὸς Βαλὰκ, οὐχὶ καὶ τοῖς ἀγγέλοις σου οὓς ἀπέστειλας πρὸς με ἐλάλησα, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ἐάν μοι δῷ Βαλὰκ πλήρη τὸν οἶκον αὐτοῦ ἀργυρίου καὶ χρυσίου, οὐ δυνήσομαι παραβῆναι τὸ ῥῆμα Κυρίου ποιῆσαι αὐτὸ καλὸν ἤ πονηρὸν παρʼ ἐμαυτοῦ· ὅσα ἂν εἴπῃ ὁ Θεός, ταῦτα ἐρῶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Καὶ νῦν ἰδοὺ ἀποτρέχω εἰς τὸν τόπον μου· δεῦρο, συμβουλεύσω σοι, τί ποιήσει ὁ λαὸς οὗτος τὸν λαόν σου ἐπʼ ἐσχάτου τῶν ἡμερῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπε, ");
INSERT INTO grcbrent_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Φησὶ Βαλαὰμ υἱὸς Βεὼρ, φησὶν ὁ ἄνθρωπος ὁ ἀληθινῶς ὁρῶν, ἀκούων λόγια Θεοῦ, ἐπιστάμενος ἐπιστήμην παρὰ ὑψίστου, καὶ ὅρασιν Θεοῦ ἰδὼν ἐν ὕπνῳ· ἀποκεκαλυμμένοι οἱ ὀφθαλμοὶ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Δείξω αὐτῷ, καὶ οὐχὶ νῦν· μακαρίζω, καὶ οὐκ ἐγγίζει· ἀνατελεῖ ἄστρον ἐξ Ἰακὼβ, ἀναστήσεται ἄνθρωπος ἐξ Ἰσραήλ· καὶ θραύσει τοὺς ἀρχηγοὺς Μωὰβ, καῒ προνομεύσει πάντας υἱοὺς Σήθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Καὶ ἔσται Ἐδὼμ κληρονομία, καὶ ἔσται κληρονομία Ἡσαῦ ὁ ἐχθρὸς αὐτοῦ· καὶ Ἰσραὴλ ἐποίησεν ἐν ἰσχύϊ. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Καὶ ἐξεγερθήσεται ἐξ Ἰακὼβ, καὶ ἀπολεῖ σωζόμενον ἐκ πόλεως. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Καὶ ἰδὼν τὸν Ἀμαλὴκ, καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπεν, ἀρχὴ ἐθνῶν Ἀμαλὴκ, καὶ τὸ σπέρμα αὐτῶν ἀπολεῖται. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Καὶ ἰδὼν τὸν Κεναῖον, καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπεν, ἰσχυρὰ ἡ κατοικία σου· καὶ ἐὰν θῇς ἐν πέτρᾳ τὴν νοσσίαν σου, ");
INSERT INTO grcbrent_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","καὶ ἐὰν γένηται τῷ Βεὼρ νοσσιὰ πανουργίας, Ἀσσύριοι αἰχμαλωτεύσουσί σε. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Καὶ ἰδὼν τὸν Ὢγ, καὶ ἀναλαβὼν τὴν παραβολὴν αὐτοῦ, εἶπεν, ὢ ὢ, τίς ζήσεται, ὅταν θῇ ταῦτα ὁ Θεός; ");
INSERT INTO grcbrent_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Καὶ ἐξελεύσεται ἐκ χειρῶς Κιτιαίων, καὶ κακώσουσιν Ἀσσοὺρ, καὶ κακώσουσιν Ἐβραίους, καὶ αὐτοὶ ὁμοθυμαδὸν ἀπολοῦνται. ");
INSERT INTO grcbrent_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Καὶ ἀναστὰς Βαλαὰμ ἀπῆλθεν, ἀποστραφεὶς εἰς τὸν τόπον αὐτοῦ· καὶ Βαλὰκ ἀπῆλθε πρὸς ἑαυτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Καὶ κατέλυσεν Ἰσραὴλ ἐν Σαττεὶν, καὶ ἐβεβηλώθη ὁ λαὸς ἐκπορνεῦσαι εἰς τὰς θυγατέρας Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Καὶ ἐκάλεσαν αὐτοὺς εἰς τὰς θυσίας τῶν εἰδώλων αὐτῶν· καὶ ἔφαγεν ὁ λαὸς τῶν θυσιῶν αὐτῶν, καὶ προσεκύνησαν τοῖς εἰδώλοις αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Καὶ ἐτελέσθη Ἰσραὴλ τῷ Βεελφεγώρ· καὶ ὠργίσθη θυμῷ Κύριος τῷ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Καὶ εἶπε Κύριος τῷ Μωυσῇ, λάβε πάντας τοὺς ἀρχηγοὺς τοῦ λαοῦ, καὶ παραδειγμάτισον αὐτοὺς Κυρίῳ κατέναντι τοῦ ἡλίου, καὶ ἀποστραφήσεται ὀργὴ θυμοῦ Κυρίου ἀπὸ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Καὶ εἶπε Μωυσῆς ταῖς φυλαῖς Ἰσραήλ, ἀποκτείνατε ἕκαστος τὸν οἰκεῖον αὐτοῦ τὸν τετελεσμένον τῷ Βεελφεγώρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Καὶ ἰδοὺ ἄνθρωπος τῶν υἱῶν Ἰσραὴλ ἐλθὼν προσήγαγε τὸν ἀδελφὸν αὐτοῦ πρὸς τὴν Μαδιανίτιν ἐναντίον Μωυσῆ, καὶ ἐναντίον πάσης συναγωγῆς υἱῶν Ἰσραήλ· αὐτοὶ δὲ ἔκλαιον παρὰ τὴν θύραν τῆς σκηνῆς τοῦ μαρτυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Καὶ ἰδὼν Φινεὲς υἱὸς Ἐλεάζαρ υἱοῦ Ἀαρὼν τοῦ ἱερέως, ἐξανέστη ἐκ μέσου τῆς συναγωγῆς, καὶ λαβὼν σειρομάστην ἐν τῇ χειρὶ, ");
INSERT INTO grcbrent_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","εἰσῆλθεν ὀπίσω τοῦ ἀνθρώπου τοῦ Ἰσραηλίτου εἰς τὴν κάμινον, καὶ ἀπεκέντησεν ἀμφοτέρους, τόν τε ἄνθρωπον τὸν Ἰσραηλίτην, καὶ τὴν γυναῖκα διὰ τῆς μήτρας αὐτῆς· καὶ ἐπαύσατο ἡ πληγὴ ἀπὸ υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Καὶ ἐγένοντο οἱ τεθνηκότες ἐν τῇ πληγῇ, τέσσαρες καὶ εἴκοσι χιλιάδες. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Φινεὲς υἱὸς Ἐλεάζαρ υἱοῦ Ἀαρὼν τοῦ ἱερέως κατέπαυσε τὸν θυμόν μου ἀπὸ υἱῶν Ἰσραὴλ, ἐν τῷ ζηλῶσαί μου τὸν ζῆλον ἐν αὐτοῖς, καὶ οὐκ ἐξανήλωσα τοὺς υἱοὺς Ἰσραὴλ ἐν τῷ ζήλῳ μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Οὕτως εἰπον, ἰδοὺ ἐγὼ δίδωμι αὐτῷ διαθήκην εἰρήνης, ");
INSERT INTO grcbrent_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","καὶ ἔσται αὐτῷ καὶ τῷ σπέρματι αὐτοῦ μετʼ αὐτὸν διαθήκη ἱερατείας αἰωνία, ἀνθʼ ὧν ἐζήλωσεν τῷ Θεῷ αὐτοῦ, καὶ ἐξιλάσατο περὶ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Τὸ δὲ ὄνομα τοῦ ἀνθρώπου τοῦ Ἰσραηλείτου τοῦ πεπληγότος, ὃς ἐπλήγη μετὰ τῆς Μαδιανίτιδος, Ζαμβρὶ, υἱὸς Σαλμὼν, ἄρχων οἴκου πατριᾶς τῶν Συμεών. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Καὶ ὄνομα τῇ γυναικὶ τῇ Μαδιανίτιδι τῇ πεπληγυίᾳ, Χασβὶ, θυγάτηρ Σοὺρ, ἄρχοντος ἔθνους Ὀμμὼθ· οἴκου πατριᾶς ἐστι τῶν Μαδιάμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, λάλησον τοῖς υἱοῖς Ἰσραὴλ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","ἐχθραίνετε τοῖς Μαδιηναίοις καὶ πατάξατε αὐτοὺς, ");
INSERT INTO grcbrent_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ὅτι ἐχθραίνουσιν αὐτοὶ ὑμῖν ἐν δολιότητι, ὅσα δολιοῦσιν ὑμᾶς διὰ Φογὼρ, καὶ διὰ Χασβὶ θυγατέρα ἄρχοντος Μαδιὰμ ἀδελφὴν αὐτῶν, τὴν πεπληγυῖαν ἐν τῇ ἡμέρᾳ τῆς πληγῆς διὰ Φογώρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Καὶ ἐγένετο μετὰ τὴν πληγὴν, καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν καὶ Ἐλεάζαρ τὸν ἱερέα, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","λάβε τὴν ἀρχὴν πάσης συναγωγῆς υἱῶν Ἰσραὴλ ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω κατʼ οἴκους πατριῶν αὐτῶν, πᾶς ὁ ἐκπορευόμενος παρατάξασθαι ἐν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Καὶ ἐλάλησε Μωυσῆς καὶ Ἐλεάζαρ ὁ ἱερεὺς ἐν Ἀραβὼθ Μωἀβ ἐπὶ τοῦ Ἰορδάνου κατὰ Ἱεριχὼ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ· καὶ οἱ υἱοὶ Ἰσραὴλ οἱ ἐξελθόντες ἐξ Αἰγύπτου, ");
INSERT INTO grcbrent_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ῥουβὴν πρωτότοκος Ἰσραήλ· υἱοὶ δὲ Ῥουβὴν Ἐνὼχ, καὶ δῆμος τοῦ Ἐνώχ· τῷ Φαλλοῦ, δῆμος τοῦ Φαλλουί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Τῷ Ἀσρὼν, δῆμος τοῦ Ἀσρωνεί· τῷ Χαρμὶ, δῆμος τοῦ Χαρμί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Οὗτοι δῆμοι Ῥουβήν· καὶ ἐγένετο ἡ ἐπίσκεψις αὐτῶν, τρεῖς καὶ τεσσαράκοντα χιλιάδες καὶ ἑπτακόσιοι καὶ τριάκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Καὶ υἱοῖ Φαλλοὺ, Ἑλιάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Καὶ υἱοὶ Ἑλιὰβ, Ναμουὴλ, καὶ Δαθὰν, καὶ Ἀβειρών· οὗτοι ἐπίκλητοι τῆς συναγωγῆς· οὗτοί εἰσιν οἱ ἐπισυστάντες ἐπὶ Μωυσῆν καὶ Ἀαρὼν ἐν τῇ συναγωγῇ Κορὲ, ἐν τῇ ἐπισυστάσει Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Καὶ ἀνοίξασα ἡ γῆ τὸ στόμα αὐτῆς, κατέπιεν αὐτοὺς καὶ Κορὲ, ἐν τῷ θανάτῳ τῆς συναγωγῆ αὐτοῦ, ὅτε κατέφαγε τὸ πῦρ τοὺς πεντήκοντα καὶ διακοσίους, καὶ ἐγενήθησαν ἐν σημείῳ· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","οἱ δὲ υἱοὶ Κορὲ οὐκ ἀπέθανον. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Καὶ οἱ υἱοὶ Συμεὼν, ὁ δῆμος τῶν υἱῶν Συμεών· τῷ Ναμουὴλ, δῆμος ὁ Ναμουηλί· τῷ Ἰαμὶν, δῆμος ὁ Ἰαμινί· τῷ Ἰαχὶν, δῆμος Ἰαχινί· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Τῷ Ζαρὰ δῆμος ὁ Ζαραΐ· τῷ Σαοὺλ, δῆμος ὁ Σαουλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Οὗτοι δῆμοι Συμεὼν ἐκ τῆς ἐπισκέψεως αὐτῶν, δύο καὶ εἴκοσι χιλιάδες καὶ διακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Υἱοὶ δὲ Ἰούδα, Ἢρ καὶ Αὐνάν· καὶ ἀπέθανον Ἤρ καὶ Αὐνὰν ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Καὶ ἐγένοντο οἱ υἱοὶ Ἰούδα κατὰ δήμους αὐτῶν· τῷ Σηλὼμ, δῆμος ὁ Σηλωνί· τῷ Φαρὲς, δῆμος ὁ Φαρεσί· τῷ Ζαρὰ, δῆμος ὁ Ζαραΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Καὶ ἐγένοντο οἱ υἱοὶ Φαρὲς, τῷ Ἀσρὼν, δῆμος ὁ Ἀσρωνί· τῷ Ἰαμοῦν, δῆμος ὁ Ἰαμουνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Οὗτοι δῆμοι τοῦ Ἰούδα κατὰ τὴν ἐπίσκεψιν αὐτῶν, ἓξ καὶ ἑβδομήκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Καὶ υἱοὶ Ἰσσάχαρ κατὰ δήμους αὐτῶν· τῷ Θωλᾷ, δῆμος ὁ Θωλαΐ· τῷ Φουᾷ, δῆμος ὁ Φουαΐ· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Τῷ Ἰασοὺβ, δῆμος ὁ Ἰασουβί· τῷ Σαμρὰμ, δῆμος ὁ Σαμραμί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Οὗτοι δῆμοι Ἰσσάχαρ ἐξ ἐπισκέψεως αὐτῶν, τέσσαρες καὶ ἑξήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Υἱοὶ Ζαβουλὼν κατὰ δήμους αὐτῶν· τῷ Σαρὲδ, δῆμος ὁ Σαρεδί· τῷ Ἀλλὼν, δῆμος ὁ Ἀλλωνί· τῷ Ἀλλὴλ, δῆμος ὁ Ἀλληλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Οὗτοι δῆμοι Ζαβουλὼν ἐξ ἐπισκέψεως αὐτῶν, ἐξήκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Υἱοὶ Γὰδ κατὰ δήμους αὐτῶν· τῷ Σαφὼν, δῆμος ὁ Σαφωνί· τῷ Ἀγγὶ, δῆμος ὁ Ἀγγί· τῷ Σουνὶ, δῆμος ὁ Σουνί· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","τῷ Ἀζενὶ, δῆμος ὁ Ἀζενί· τῷ Ἀδδὶ, δῆμος ὁ Ἀδδί· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","τῷ Ἀροδὶ, δῆμος ὁ Αροαδί· τῷ Ἀριὴλ, δῆμος ὁ Ἀριηλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Οὗτοι δῆμοι υἱῶν Γὰδ ἐξ ἑπισκέψεως αὐτῶν, τέσσαρες καὶ τεσσαράκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Υἱοὶ Ἀσὴρ κατὰ δήμους αὐτῶν· τῷ Ἰαμὶν, δῆμος ὁ Ἰαμινί· τῷ Ἰεσοὺ, δῆμος ὁ Ἰεσουΐ· τῷ Βαριὰ, δῆμος ὁ Βαριαΐ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Τῷ Χοβὲρ, δῆμος ὁ Χοβερί· τῷ Μελχιὴλ, δῆμος ὁ Μελχιηλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Καὶ τὸ ὄνομα θυγατρὸς Ἀσὴρ, Σάρα. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Οὗτοι δῆμοι Ἀσὴρ ἐξ ἐπισκέψεως αὐτῶν, τρεῖς καὶ τεσσαράκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Υἱοὶ Ἰωσὴφ κατὰ δήμους αὐτῶν, Μανασσῆ καὶ Ἐφραίμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Υἱοὶ Μανασσῆ. Τῷ Μαχὶρ, δῆμος ὁ Μαχιρί· καὶ Μαχὶρ ἐγέννησε τὸν Γαλαάδ· τῷ Γαλαὰδ, δῆμος ὁ Γαλααδί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Καὶ οὗτοι υἱοὶ Γαλαάδ· Ἀχιέζερ, δῆμος ὁ Ἀχιεζερί· τῷ Χελὲγ, δῆμος ὁ Χελεγί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Τῷ Ἐσριὴλ, δῆμος ὁ Ἐσριηλί· τῷ Συχὲμ, δῆμος ὁ Συχεμί· ");
INSERT INTO grcbrent_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Τῷ Συμαὲρ, δῆμος ὁ Συμαερί· καὶ τῷ Ὀφὲρ, δῆμος ὁ Ὀφερὶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Καὶ τῷ Σαλπαὰδ, υἱῷ Ὀφὲρ, οὐκ ἐγένοντο αὐτῷ υἱοὶ, ἀλλʼ ἢ θυγατέρες· καὶ ταῦτα τὰ ὀνόματα τῶν θυγατέρων Σαλπαάδ· Μαλὰ, καὶ Νουὰ, καὶ Ἐγλὰ, καὶ Μελχὰ, καὶ Θερσά. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Οὗτοι δῆμοι Μανασσὴ ἐξ ἐπισκέψεως αὐτῶν, δύο καὶ πεντήκοντα χιλιαδες καὶ ἑπτακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Καὶ οὗτοι υἱοὶ Ἐφραίμ· τῷ Σουθαλὰ, δῆμος ὁ Σουθαλάν· τῷ Τανὰχ, δῆμος ὁ Ταναχί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Οὗτοι υἱοὶ Σουθαλά· τῷ Ἐδὲν, δῆμος ὁ Ἐδενί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Οὗτοι δῆμοι Ἐφραὶμ ἐξ ἐπισκέψεως αὐτῶν, δύο καὶ τριάκοντα χιλιάδες καὶ πεντακόσιοι· οὗτοι δῆμοι υἱῶν Ἰωσὴφ κατὰ δήμους αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Υἱοὶ Βενιαμὶν κατὰ δήμους αὐτῶν· τῷ Βαλὲ, δῆμος ὁ Βαλί· τῷ Ἀσυβὴρ, δῆμος ὁ Ἀσυβηρί· τῷ Ἰαχιρὰν, δῆμος ὁ Ἰαχιρανί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Τῷ Σωφὰν, δῆμος ὁ Σωφανι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Καὶ ἐγένοντο οἱ υἱοὶ Βαλὲ, Ἀδὰρ, καὶ Νοεμάν· τῷ Ἀδὰρ, δῆμος ὁ Αδαρί· καὶ τῷ Νοεμὰν, δῆμος ὁ Νοεμανί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Οὗτοι υἱοὶ Βενιαμὶν κατὰ δήμους αὐτῶν ἐξ ἐπισκέψεως αὐτῶν, πέντε καὶ τριάκοντα χιλιάδες καὶ πεντακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Καὶ υἱοὶ Δὰν κατὰ δήμους αὐτῶν· τῷ Σαμὲ, δῆμος ὁ Σαμεΐ, οὗτοι δῆμοι Δὰν κατὰ δήμους αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Πάντες οἱ δῆμοι Σαμεῒ κατʼ ἐπισκοπὴν αὐτῶν, τέσσαρες καὶ ἑξήκοντα χιλιάδες καὶ τετρακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Υἱοὶ Νεφθαλὶ κατὰ δήμους αὐτῶν· τῷ Ἀσιὴλ· δῆμος ὁ Ἀσιηλί· τῷ Γαυνὶ, δῆμος ὁ Γαυνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Τῷ Ἰεσὲρ, δῆμος ὁ Ἰεσερί· τῷ Σελλὴμ, δῆμος ὁ Σελλημί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Οὗτοι δῆμοι Νεφθαλὶ ἐξ ἐπισκέψεως αὐτῶν, τεσσαράκοντα χιλιάδες καὶ τριακόσιοι. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Αὕτη ἡ ἐπίσκεψις υἱῶν Ἰσραὴλ, ἑξακόσιαι χιλιάδες καὶ χίλιοι καὶ ἑπτακόσιοι καὶ τριάκοντα. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","τούτοις μερισθήσεται ἡ γῆ, κληρονομεῖν ἐξ ἀριθμοῦ ὀνομάτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Τοῖς πλείοσι πλεονάσεις τὴν κληρονομίαν, καὶ τοῖς ἐλάττοσιν ἐλαττώσεις τὴν κληρονομίαν αὐτῶν· ἑκάστῳ, καθὼς ἐπεσκέπησαν, δοθήσεται ἡ κληρονομία αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Διὰ κλήρων μερισθήσεται ἡ γῆ τοῖς ὀνόμασι· κατὰ φυλὰς πατριῶν αὐτῶν κληρονομήσουσιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ἐκ τοῦ κλήρου μεριεῖς τὴν κληρονομίαν αὐτῶν ἀναμέσον πολλῶν καὶ ὀλίγων. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Καὶ υἱοὶ Λευὶ κατὰ δήμους αὐτῶν· τῷ Γεδσὼν, δῆμος ὁ Γεδσωνί· τῷ Καὰθ, δῆμος ὁ Κααθί· τῷ Μεραρὶ, δῆμος ὁ Μεραρί. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Οὗτοι δῆμοι υἱῶν Λευί· δῆμος ὁ Λοβενί, δῆμος ὁ Χεβρωνὶ, δῆμος ὁ Κορὲ, καὶ δῆμος ὁ Μουσί· καὶ Καὰθ ἐγέννησε τὸν Ἁμράμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Τὸ δὲ ὄνομα τῆς γυναικὸς αὐτοῦ Ἰωχαβὲδ, θυγάτηρ Λευὶ, ἣ ἔτεκε τούτους τῷ Λευὶ ἐν Αἰγύπτῳ, καὶ ἔτεκε τῷ Ἀμρὰμ τὸν Ἀαρὼν καὶ Μωυσῆν, καὶ Μαριὰμ τὴν ἀδελφὴν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Καὶ ἐγενήθησαν τῷ Ἀαρὼν, ὅ, τε Ναδὰβ, καὶ Ἀβιοὺδ, καὶ Ἐλεάζαρ, καὶ Ἰθάμαρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Καὶ ἀπέθανε Ναδὰβ καὶ Ἀβιοὺδ ἐν τῷ προσφέρειν αὐτοὺς πῦρ ἀλλότριον ἔναντι Κυρίου ἐν τῇ ἐρήμῳ Σινᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Καὶ ἐγενήθησαν ἐξ ἐπισκέψεως αὐτῶν τρεῖς καὶ εἴκοσι χιλιάδες, πᾶν ἀρσενικὸν ἀπὸ μηνιαίου καὶ ἐπάνω· οὐ γὰρ συνεπεσκέπησαν ἐν μέσῳ υἱῶν Ἰσραὴλ, ὅτι οὐ δίδοται αὐτοῖς κλῆρος ἐν μέσῳ υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Καὶ αὕτη ἡ ἐπίσκεψις Μωυσῆ καὶ Ἐλεάζαρ τοῦ ἱερέως, οἱ ἐπεσκέψαντο τοὺς υἱοὺς Ἰσραὴλ ἐν Ἀραβὼθ Μωὰβ, ἐπὶ τοῦ Ἰορδάνου κατὰ Ἱεριχώ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Καὶ ἐν τούτοις οὐκ ἦν ἄνθρωπος τῶν ἐπεσκεμμένων ὑπὸ Μωυσῆ καὶ Ἀαρὼν, οὓς ἐπεσκέψαντο τοὺς υἱοὺς Ἰσραὴλ ἐν τῇ ἐρήμῳ Σινᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ὅτι εἶπε Κύριος αὐτοῖς, θανάτῳ ἀποθανοῦνται ἐν τῇ ἐρήμῳ· καὶ οὐ κατελείφθη ἐξ αὐτῶν οὐδὲ εἷς, πλὴν Χάλεβ υἱὸς Ἰεφοννὴ, καὶ Ἰησοῦς ὁ τοῦ Ναυή. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Καὶ προσελθοῦσαι αἱ θυγατέρες Σαλπαὰδ υἱοῦ Ὀφὲρ, υἱοῦ Γαλαὰδ, υἱοῦ Μαχιρ, τοῦ δήμου Μανασσῆ, τῶν υἱῶν Ἰωσὴφ, καὶ ταῦτα τὰ ὀνόματα αὐτῶν, Μααλὰ, καὶ Νουὰ, καὶ Ἐγλὰ, καὶ Μελχὰ, καὶ Θερσὰ, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","καὶ στᾶσαι ἔναντι Μωυσῆ, καὶ ἔναντι Ἐλεάζαρ τοῦ ἱερέως, καὶ ἔναντι τῶν ἀρχόντων, καὶ ἔναντι πάσης συναγωγῆς ἐπὶ τῆς θύρας τῆς σκηνῆς τοῦ μαρτυρίου, λέγουσιν, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","ὁ πατὴρ ἡμῶν ἀπέθανεν ἐν τῇ ἐρήμῳ, καὶ αὐτὸς οὐκ ἦν ἐν μέσῳ τῆς συναγωγῆς τῆς ἐπισυστάσης ἔναντι Κυρίου ἐν τῇ συναγωγῇ Κορὲ, ὅτι διʼ ἁμαρτίαν αὐτοῦ ἀπέθανε, καὶ υἱοὶ οὐκ ἐγένοντο αὐτῷ· μὴ ἐξαλειφθήτω τὸ ὄνομα τοῦ πατρὸς ἡμῶν ἐκ μέσου τοῦ δήμου αὐτοῦ, ὅτι οὐκ ἔστιν αὐτῷ υἱός· δότε ἡμῖν κατάσχεσιν ἐν μέσῳ ἀδελφῶν πατρὸς ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Καὶ προσήγαγε Μωυσῆν τὴν κρίσιν αὐτῶν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","λέγεν, ὀρθῶς θυγατέρες Σαλπαὰδ λελαλήκασι· δόμα δώσεις αὐταῖς κατάσχεσιν κληρονομίας ἐν μέσῳ ἀδελφῶν πατρὸς αὐτῶν, καὶ περιθήσεις τὸν κλῆρον τοῦ πατρὸς αὐτῶν αὐταῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Καὶ τοῖς υἱοῖς Ἰσραὴλ λαλήσεις, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","λέγων, ἄνθρωπος ἐὰν ἀποθάνῃ, καὶ υἱὸς μὴ ᾖ αὐτῷ, περιθήσετε τὴν κληρονομίαν αὐτοῦ τῇ θυγατρὶ αὐτοῦ· ");
INSERT INTO grcbrent_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ἐὰν δὲ μὴ ᾖ θυγάτηρ αὐτῷ, δώσετε τὴν κληρονομίαν τῷ ἀδελφῷ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ἐὰν δὲ μὴ ὦσιν αὐτῷ ἀδελφοὶ, δώσετε τὴν κληρονομίαν τῷ ἀδελφῷ τοῦ πατρὸς αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ἐὰν δὲ μὴ ὦσιν ἀδελφοὶ τοῦ πατρὸς αὐτοῦ, δώσετε τὴν κληρονομίαν τῷ οἰκείῳ τῷ ἔγγιστα αὐτοῦ ἐκ τῆς φυλῆς αὐτοῦ, κληρονομῆσαι τὰ αὐτοῦ· καὶ ἔσται τοῦτο τοῖς υἱοῖς Ἰσραὴλ δικαίωμα κρίσεως, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Καὶ εἶπε Κύριος πρὸς Μωυσῆν, ἀνάβηθι εἰς τὸ ὄρος τὸ ἐν τῷ πέραν τοῦ Ἰορδάνου, τοῦτο τὸ ὄρος Ναβαὺ, καὶ ἴδε τὴν γῆν Χαναὰν, ἣν ἐγὼ δίδωμι τοῖς υἱοῖς Ἰσραὴλ ἐν κατασχέσει. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Καὶ ὄψῃ αὐτὴν, καὶ προστεθήσῃ πρὸς τὸν λαόν σου καὶ σὺ, καθὰ προσετέθη Ἀαρὼν ὁ ἀδελφός σου ἐν Ὢρ τῷ ὄρει. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Διότι παρέβητε τὸ ῥῆμά μου ἐν τῇ ἐρήμῳ Σὶν, ἐν τῷ ἀντιπίπτειν τὴν συναγωγὴν ἁγιάσαι με, οὐχ ἡγιάσατέ με ἐπὶ τῷ ὕδατι ἔναντι αὐτῶν· τοῦτʼ ἔστι τὸ ὕδωρ ἀντιλογίας ἐν Κάδης ἐν τῇ ἐρήμῳ Σίν. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Καὶ εἶπε Μωυσῆς πρὸς Κύριον, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","ἐπισκεψάσθω Κύριος ὁ Θεὸς τῶν πνευμάτων καὶ πάσης σαρκὸς ἄνθρωπον ἐπὶ τῆς συναγωγῆς ταύτης, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ὅστις ἐξελεύσεται πρὸ προσώπου αὐτῶν, καὶ ὅστις εἰσελεύσεται πρὸ προσώπου αὐτῶν, καὶ ὅστις ἐξάξει αὐτοὺς, καὶ ὃστις εἰσάξει αὐτοὺς, καὶ οὐκ ἔσται ἡ συναγωγὴ Κυρίου ὡσεὶ πρόβατα οἷς οὐκ ἔστι ποιμήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, λάβε πρὸς σεαυτὸν Ἰησοῦν υἱὸν Ναυὴ, ἄνθρωπον ὃς ἔχει πνεῦμα ἐν ἑαυτῷ, καὶ ἐπιθήσεις τὰς χεῖράς σου ἐπʼ αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Καὶ στήσεις αὐτὸν ἔναντι Ἐλεάζαρ τοῦ ἱερέως, καὶ ἐντελῇ αὐτῷ ἔναντι πάσης συναγωγῆς, καὶ ἐντελῇ περὶ αὐτοῦ ἐναντίον αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Καὶ δώσεις τῆς δόξης σου ἐπʼ αὐτὸν, ὅπως ἂν εἰσακούσωσιν αὐτοῦ οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Καὶ ἔναντι Ἐλεάζαρ τοῦ ἱερέως στήσεται, καὶ ἐπερωτήσουσιν αὐτὸν τὴν κρίσιν τῶν δήλων ἔναντι Κυρίου· ἐπὶ τῷ στόματι αὐτοῦ ἐξελεύσονται, καὶ ἐπὶ τῷ στόματι αὐτοῦ εἰσελεύσονται αὐτὸς καὶ οἱ υἱοὶ Ἰσραὴλ ὁμοθυμαδὸν, καὶ πᾶσα ἡ συναγωγή. ");
INSERT INTO grcbrent_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Καὶ ἐποίησε Μωυσῆς καθὰ ἐνετείλατο αὐτῷ Κύριος· καὶ λαβὼν τὸν Ἰησοῦν, ἔστησεν αὐτὸν ἐναντίον Ἐλεάζαρ τοῦ ἱερέως, καὶ ἐναντίον πάσης συναγωγῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","καὶ ἐπέθηκε τὰς χεῖρας αὐτοῦ ἐπʼ αὐτὸν, καὶ συνέστησεν αὐτὸν καθάπερ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","ἔντειλαι τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, λέγων, τὰ δῶρά μου δόματά μου καρπώματά μου εἰς ὀσμὴν εὐωδίας διατηρήσετε προσφέρειν ἐμοὶ ἐν ταῖς ἑορταῖς μου. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Καὶ ἐρεῖς πρὸς αὐτοὺς, ταῦτα τὰ καρπώματα ὅσα προσάξετε Κυρίῳ, ἀμνοὺς ἐνιαυσίους ἀμώμους δύο τὴν ἡμέραν εἰς ὁλοκαύτωσιν ἐνδελεχῶς. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Τὸν ἀμνὸν τὸν ἕνα ποιήσεις τὸ τοπρωῒ, καὶ τὸν ἀμνὸν τὸν δεύτερον ποιήσεις τὸ πρὸς ἑσπέραν. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Καὶ ποιήσεις τὸ δέκατον τοῦ οἰφὶ σεμίδαλιν εἰς θυσίαν ἀναπεποιημένην ἐν ἐλαίῳ ἐν τετάρτῳ τοῦ ἴν. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ὁλοκαύτωμα ἐνδελεχισμοῦ, ἡ γενομένη ἐν τῷ ὄρει Σινᾷ εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Καὶ σπονδὴν αὐτοῦ τὸ τέταρτον τοῦ ἴν τῷ ἀμνῷ τῷ ἑνί· ἐν τῷ ἁγίῳ σπείσεις σπονδὴν σίκερα Κυρίῳ· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","καὶ τὸν ἀμνὸν τὸν δεύτερον ποιήσεις τὸ πρὸς ἑσπέραν· κατὰ τὴν θυσίαν αὐτοῦ καὶ κατὰ τὴν σπονδὴν αὐτοῦ ποιήσετε εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Καὶ τῇ ἡμέρᾳ τῶν σαββάτων προσάξετε δύο ἀμνοὺς ἐνιαυσίους ἀμώμους, καὶ δύο δέκατα σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ εἰς θυσίαν καὶ σπονδὴν, ");
INSERT INTO grcbrent_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ὁλοκαύτωμα σαββάτων ἐν τοῖς σαββάτοις ἐπὶ τὴς ὁλοκαυτώσεως τῆς διαπαντὸς, καὶ τὴν σπονδὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Καὶ ἐν ταῖς νεομηνίαις προσάξετε ὁλοκαύτωμα τῷ Κυρίῳ, μόσχους ἐκ βοῶν δύο, καὶ κριὸν ἕνα, ἀμνοὺς ἐνιαυσίους ἑπτὰ ἀμώμους· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Τρία δέκατα σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ τῷ μόσχῳ τῷ ἑνὶ, καὶ δύο δέκατα σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ τῷ κριῷ τῷ ἑνί· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Δέκατον δέκατον σεμιδάλεως ἀναπεποιημένης ἐν ἐλαίῳ τῷ ἀμνῷ τῷ ἑνὶ, θυσίαν ὀσμὴν εὐωδίας κάρπωμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ἡ σπονδὴ αὐτῶν τὸ ἥμισυ τοῦ ἴν ἔσται τῷ μόσχῳ τῷ ἑνί· καὶ τὸ τρίτον τοῦ ἴν ἔσται τῷ κριῷ τῷ ἑνί. Καὶ τὸ τέταρτον τοῦ ἴν ἔσται τῷ ἀμνῷ τῷ ἑνὶ οἴνου· τοῦτο τὸ ὁλοκαύτωμα μῆνα ἐκ μηνὸς εἰς τοὺς μῆνας τοῦ ἐνιαυτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας Κυρίῳ, ἐπὶ τῆς ὁλοκαυτώσεως τῆς διαπαντὸς ποιηθήσεται, καὶ ἡ σπονδὴ αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Καὶ ἐν τῷ μηνὶ τῷ πρώτῳ τεσσαρεσκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς πάσχα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Καὶ τῇ πεντεκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τούτου ἑορτή· ἑπτὰ ἡμέρας ἄζυμα ἔδεσθε. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Καὶ ἡ ἡμέρα ἡ πρώτη ἐπίκλητος ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Καὶ προσάξετε ὁλοκαυτώματα κάρπωμα Κυρίῳ, μόσχους ἐκ βοῶν δύο, κριὸν ἕνα, ἀμνοὺς ἐνιαυσίους ἑπτά· ἄμωμοι ἔσονται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Καὶ θυσία αὐτῶν σεμίδαλις ἀναπεποιημένη ἐν ἐλαίῳ· τρία δέκατα τῷ μόσχῳ τῷ ἑνὶ, καὶ δύο δέκατα τῷ κριῷ τῷ ἑνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Δέκατον δέκατον ποιήσεις τῷ ἀμνῷ τῷ ἑνὶ, τοῖς ἑπτὰ ἀμνοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, ἐξιλάσασθαι περὶ ὑμῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντὸς τῆς πρωϊνῆς, ὅ ἐστιν ὁλοκαύτωμα ἐνδελεχισμοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ταῦτα κατὰ ταῦτα ποιήσετε τὴν ἡμέραν εἰς τὰς ἑπτὰ ἡμέρας, δῶρον κάρπωμα εἰς ὀσμὴν εὐωδίας Κυρίῳ, ἐπὶ τοῦ ὁλοκαυτώματος τοῦ διαπαντὸς ποιήσεις τὴν σπονδὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Καὶ ἡμέρα ἡ ἑβδόμη κλητὴ ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Καὶ τῇ ἡμέρᾳ τῶν νέων, ὅταν προσφέρητε θυσίαν νέαν Κυρίῳ τῶν ἑβδομάδων, ἐπίκλητος ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Καὶ προσάξετε ὁλοκαυτώματα εἰς ὀσμὴν εὐωδίας Κυρίῳ, μόσχους ἐκ βοῶν δύο, κριὸν ἕνα, ἀμνοὺς ἐνιαυσίους ἑπτὰ ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ἡ θυσία αὐτῶν σεμίδαλις ἀναπεποιημένη ἐν ἐλαίῳ· τρία δέκατα τῷ μόσχῳ τῷ ἑνὶ, καὶ δύο δέκατα τῷ κριῷ τῷ ἑνί. ");
INSERT INTO grcbrent_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Δέκατον δέκατον τῷ ἀμνῷ τῷ ἑνὶ, τοῖς ἑπτὰ ἀμνοῖς· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, ἐξιλάσασθαι περὶ ὑμῶν· πλὴν τοῦ ὁλοκαυτώματος τοῦ διαπαντός· ");
INSERT INTO grcbrent_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","καὶ τὴν θυσίαν αὐτῶν ποιήσετέ μοι, ἄμωμοι ἔσονται ὑμῖν, καὶ τὰς σπονδὰς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Καὶ τῷ μηνὶ τῷ ἑβδόμῳ, μιᾷ τοῦ μηνὸς, ἐπίκλητος ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε· ἡμέρα σημασίας ἔσται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Καὶ ποιήσετε ὁλοκαυτώματα εἰς ὀσμὴν εὐωδίας Κυρίῳ, μόσχον ἕνα ἐκ βοῶν, κριὸν ἕνα, ἀμνοὺς ἐνιαυσίους ἑπτὰ ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ἡ θυσία αὐτῶν σεμίδαλις ἀναπεποιημένη ἐν ἐλαίῳ· τρία δέκατα τῷ μόσχῳ τῷ ἑνὶ, καὶ δύο δέκατα τῷ κρίῳ τῷ ἑνί· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Δέκατον δέκατον τῷ ἀμνῷ τῷ ἑνὶ, τοῖς ἑπτὰ ἀμνοῖς· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, ἐξιλάσασθαι περὶ ὑμῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Πλὴν τῶν ὁλοκαυτωμάτων τῆς νουμηνίας· καὶ αἱ θυσίαι αὐτῶν, καὶ αἱ σπονδαὶ αὐτῶν, καὶ τὸ ὁλοκαύτωμα τὸ διαπαντός· καί αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν κατὰ τὴν σύγκρισιν αὐτῶν εἰς ὀσμὴν εὐωδίας Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Καὶ τῇ δεκάτῃ τοῦ μηνὸς τούτου ἐπίκλητος ἁγία ἔσται ὑμῖν· καὶ κακώσετε τὰς ψυχὰς ὑμῶν, καὶ πᾶν ἔργον οὐ ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Καὶ προσοίσετε ὁλοκαυτώματα εἰς ὀσμὴν εὐωδίας Κυρίῳ, καρπώματα Κυρίῳ, μόσχον ἐκ βοῶν ἕνα, κριὸν ἕνα, ἀμνους ἐνιαυσίους ἑπτά· ἄμωμοι ἔσονται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ἡ θυσία αὐτῶν σεμίδαλις ἀναπεποιημένη ἐν ἐλαίῳ· τρία δέκατα τῷ μόσχῳ τῷ ἑνὶ, καὶ δύο δέκατα τῷ κριῷ τῷ ἑνί· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Δέκατον δέκατον τῷ ἀμνῷ τῷ ἑνὶ, εἰς τοὺς ἑπτὰ ἀμνούς· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας, ἐξιλάσασθαι περὶ ὑμῶν· πλὴν τὸ περὶ τῆς ἁμαρτίας τῆς ἐξιλάσεως, καὶ ἡ ὁλοκαύτωσις ἡ διαπαντός· ἡ θυσία αὐτῆς, καὶ ἡ σπονδὴ αὐτῆς κατὰ τὴν σύγκρισιν εἰς ὀσμὴν εὐωδίας κάρπωμα Κυρίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Καὶ τῇ πεντεκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τοῦ ἑβδόμου τούτου ἐπίκλητος ἁγία ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιήσετε· καὶ ἑορτάσατε αὐτὴν ἑορτὴν Κυρίῳ ἑπτὰ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Καὶ προσάξετε ὁλοκαυτώματα κάρπωμα εἰς ὀσμὴν εὐωδίας Κυρίῳ, τῇ ἡμέρᾳ τῇ πρώτῃ μόσχους ἐκ βοῶν τρεῖς καὶ δέκα, κριοὺς δυο, ἀμνοὺς ἐνιαυσίους δεκατέσσαρας· ἄμωμοι ἔσονται. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Αἱ θυσίαι αὐτῶν σεμίδαλις ἀναπεποιημένη ἐν ἐλαίῳ· τρία δέκατα τῷ μόσχῳ τῷ ἑνὶ, τοῖς τρισκαίδεκα μόσχοις· καὶ δύο δέκατα τῷ κριῷ τῷ ἑνὶ, ἐπὶ τοὺς δύο κριούς· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Δέκατον δέκατον τῷ ἀμνῷ τῷ ἑνὶ, ἐπὶ τοὺς τέσσαρας καὶ δέκα ἀμνούς· ");
INSERT INTO grcbrent_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Καὶ τῇ ἡμέρᾳ τῇ δευτέρᾳ μόσχους δώδεκα, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους τέσσαρας καὶ δέκα ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ἡ θυσία αὐτῶν καὶ ἡ σπονδὴ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Τῇ ἡμέρᾳ τῇ τρίτῃ μόσχους ἕνδεκα, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους τέσσαρας καὶ δέκα ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ἡ θυσία αὐτῶν καὶ ἡ σπονδὴ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Τῇ ἡμέρᾳ τῇ τετάρτῃ μόσχους δέκα, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους τέσσαρας καὶ δέκα ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Τῇ ἡμέρᾳ τῇ πέμπτῃ μόσχους ἐννέα, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους τέσσαρας καὶ δέκα ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Τῇ ἡμέρᾳ τῇ ἕκτῃ μόσχους ὀκτὼ, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους δεκατέσσαρας ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Τῇ ἡμέρᾳ τῇ ἑβδομῃ μόσχους ἑπτὰ, κριοὺς δύο, ἀμνοὺς ἐνιαυσίους δεκατέσσαρας ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν τοῖς μόσχοις καὶ τοῖς κριοῖς καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύγκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Καὶ τῇ ἡμέρᾳ τῇ ὀγδόῃ ἐξόδιον ἔσται ὑμῖν· πᾶν ἔργον λατρευτὸν οὐ ποιησετε ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Καὶ προσάξετε ὁλοκαυτώματα εἰς ὀσμὴν εὐωδίας καρπώματα τῷ Κυρίῳ, μόσχον ἕνα, κριὸν ἕνα, ἀμνοὺς ἐνιαυσίους ἑπτὰ ἀμώμους. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν τῷ μόσχῳ καὶ τῷ κριῷ καὶ τοῖς ἀμνοῖς κατὰ ἀριθμὸν αὐτῶν, κατὰ τὴν σύνκρισιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Καὶ χίμαρον ἐξ αἰγῶν ἕνα περὶ ἁμαρτίας· πλὴν τῆς ὁλοκαυτώσεως τῆς διαπαντός· αἱ θυσίαι αὐτῶν καὶ αἱ σπονδαὶ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ταῦτα ποιήσετε Κυρίῳ ἐν ταῖς ἑορταῖς ὑμῶν, πλὴν τῶν εὐχῶν ὑμῶν, καὶ τὰ ἑκούσια ὑμῶν, καὶ τὰ ὁλοκαυτώματα ὑμῶν, καὶ τὰς θυσίας ὑμῶν, καὶ τὰς σπονδὰς ὑμῶν, καὶ τὰ σωτήρια ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Καὶ ἐλάλησε Μωυσῆς τοῖς υἱοῖς Ἰσραὴλ κατὰ πάντα ὅσα ἐνετείλατο Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Καὶ ἐλάλησε Μωυσῆς πρὸς τοὺς ἄρχοντας τῶν φυλῶν υἱῶν Ἰσραὴλ, λέγων, τοῦτο τὸ ῥῆμα ὃ συνέταξε Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ἄνθρωπος ἄνθρωπος ὃς ἂν εὔξηται εὐχὴν Κυρίῳ, ἢ ὀμόσῃ ὅρκον, ἢ ὁρίσηται ὁρισμῷ περὶ τῆς ψυχῆς αὐτοῦ, οὐ βεβηλώσει τὸ ῥῆμα αὐτοῦ· πάντα ὅσα ἂν ἐξέλθῃ ἐκ τοῦ στόματος αὐτοῦ, ποιήσει. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Ἐὰν δὲ εὔξηται γυνὴ εὐχὴν Κυρίῳ, ἢ ὁρίσηται ὁρισμὸν ἐν τῷ οἴκῳ τοῦ πατρὸς αὐτῆς ἐν τῇ νεότητι αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","καὶ ἀκούσῃ ὁ πατὴρ αὐτῆς τὰς εὐχὰς αὐτῆς, καὶ τοὺς ὁρισμοὺς αὐτῆς, οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, καὶ παρασιωπήσῃ αὐτῆς ὁ πατὴρ, καὶ στήσονται πᾶσαι αἱ εὐχαὶ αὐτῆς, καὶ πάντες οἱ ὁρισμοὶ οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, μενοῦσιν αὐτῇ· ");
INSERT INTO grcbrent_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ἐὰν δὲ ἀνανεύων ἀνανεύσῃ ὁ πατὴρ αὐτῆς, ᾗ ἂν ἡμέρᾳ ἀκούσῃ πάσας τὰς εὐχὰς αὐτῆς καὶ τοὺς ὁρισμοὺς, οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, οὐ στήσονται· καὶ Κύριος καθαριεῖ αὐτὴν, ὅτι ἀνένευσεν ὁ πατὴρ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Ἐὰν δὲ γενομένη γένηται ἀνδρὶ, καὶ αἱ εὐχαὶ αὐτῆς ἐπʼ αὐτῇ κατὰ τὴν διαστολὴν τῶν χειλέων αὐτῆς, οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, ");
INSERT INTO grcbrent_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","καὶ ἀκούσῃ ὁ ἀνὴρ αὐτῆς, καὶ παρασιωπήσῃ αὐτῇ ᾗ ἂν ἡμέρᾳ ἀκούσῃ, καὶ οὕτω στήσονται πᾶσαι αἱ εὐχαὶ αὐτῆς, καὶ οἱ ὁρισμοὶ αὐτῆς, οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, στήσονται. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ἐὰν δὲ ἀνανεύων ἀνανεύσῃ ὁ ἀνὴρ αὐτῆς ᾗ ἐὰν ἡμέρᾳ ἀκούσῃ, πᾶσαι αἱ εὐχαὶ αὐτῆς, καὶ οἱ ὁρισμοὶ αὐτῆς οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, οὐ μενοῦσιν, ὅτι ὁ ἀνὴρ ἀνένευσεν ἀπʼ αὐτῆς· καὶ Κύριος καθαριεῖ αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Καὶ εὐχὴ χήρας καὶ ἐκβεβλημένης ὅσα ἐὰν εὔξηται κατὰ τῆς ψυχῆς αὐτῆς, μενοῦσιν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Ἐὰν δὲ ἐν τῷ οἴκῳ τοῦ ἀνδρὸς αὐτῆς ἡ εὐχὴ αὐτῆς, ἢ ὁ ὁρισμὸς κατὰ τῆς ψυχῆς αὐτῆς μεθʼ ὅρκου, ");
INSERT INTO grcbrent_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","καὶ ἀκούσῃ ὁ ἀνὴρ αὐτῆς, καὶ παρασιωπήσῃ αὐτῇ, καὶ μὴ ἀνανεύσῃ αὐτῇ, καὶ στήσονται πᾶσαι αἱ εὐχαὶ αὐτῆς, καὶ πάντες οἱ ὁρισμοὶ αὐτῆς οὓς ὡρίσατο κατὰ τῆς ψυχῆς αὐτῆς, στήσονται κατʼ αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ἐὰν δὲ περιελὼν περιέλῃ ὁ ἀνὴρ αὐτῆς ᾗ ἂν ἡμέρᾳ ἀκούσῃ, πάντα ὅσα ἐὰν ἐξέλθῃ ἐκ τῶν χειλέων αὐτῆς κατὰ τὰς εὐχὰς αὐτῆς, καὶ κατὰ τοὺς ὁρισμοὺς τοὺς κατὰ τῆς ψυχῆς αὐτῆς, οὐ μενεῖ αὐτῇ· ὁ ἀνὴρ αὐτῆς περιεῖλε, καὶ Κύριος καθαριεῖ αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Πᾶσα εὐχὴ καὶ πᾶς ὅρκος δεσμοῦ κακῶσαι ψυχὴν, ὁ ἀνὴρ αὐτῆς στήσει αὐτῇ, καὶ ὁ ἀνὴρ αὐτῆς περιελεῖ ");
INSERT INTO grcbrent_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ἐὰν δὲ σιωπῶν παρασιωπήσῃ αὐτῇ ἡμέραν ἐξ ἡμέρας, καὶ στήσει αὐτῇ πάσας τὰς εὐχὰς αὐτῆς, καὶ τοὺς ὁρισμοὺς τοὺς ἐπʼ αὐτῆς στήσει αὐτῇ, ὅτι ἐσιώπησεν αὐτῇ τῇ ἡμέρᾳ ᾗ ἤκουσεν. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ἐὰν δὲ περιελὼν περιέλῃ ὁ ἀνὴρ αὐτῆς μετὰ τὴν ἡμέραν ἣν ἤκουσε, καὶ λήψεται τὴν ἁμαρτίαν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ταῦτα τὰ δικαιώματα ὅσα ἐνετείλατο Κύριος τῷ Μωυσῇ, ἀναμέσον ἀνδρὸς καὶ γυναικὸς αὐτοῦ, καὶ ἀναμέσον πατρὸς καὶ θυγατρὸς ἐν νεότητι ἐ οἴκῳ πατρός. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","ἐκδίκει τὴν ἐκδίκησιν υἱῶν Ἰσραὴλ ἐκ τῶν Μαδιανιτῶν, καὶ ἔσχατον προστεθήσῃ πρὸς τὸν λαόν σου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Καὶ ἐλάλησε Μωυσῆς πρὸς τὸν λαὸν, λέγων, ἐξοπλίσατε ἐξ ὑμῶν ἄνδρας, καὶ παρατάξασθε ἔναντι Κυρίου ἐπὶ Μαδιὰν, ἀποδοῦναι ἐκδίκησιν παρὰ τοῦ Κυρίου τῇ Μαδιάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Χιλίους ἐκ φυλῆς, χιλίους ἐκ φυλῆς, ἐκ πασῶν φυλῶν υἱῶν Ἰσραὴλ, ἀποστείλατε παρατάξασθαι. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Καὶ ἐξηρίθμησαν ἐκ τῶν χιλιάδων Ἰσραὴλ χιλίους ἐκ φυλῆς, δώδεκα χιλιάδας ἐνωπλισμένοι εἰς παράταξιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Καὶ ἀπέστειλεν αὐτοὺς Μωυσῆς χιλίους ἐκ φυλῆς, χιλίους ἐκ φυλῆς σὺν δυνάμει αὐτῶν, καὶ Φινεὲς υἱὸν Ἐλεάζαρ υἱοῦ Ἀαρὼν τοῦ ἱερέως· καὶ τὰ σκεύη τὰ ἅγια, καὶ αἱ σάλπιγγες τῶν σημασιῶν ἐν ταῖς χερσὶν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Καὶ παρετάξαντο ἐπὶ Μαδιὰν, καθὰ ἐνετείλατο Κύριος Μωυσῇ· καὶ ἀπέκτειναν πᾶν ἀρσενικόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Καὶ τοὺς βασιλεῖς Μαδιὰν ἀπέκτειναν ἅμα τοῖς τραυματίαις αὐτῶν· καὶ τὸν Εὐὶν, καὶ τὸν Ῥοκὸν, καὶ τὸν Σοὺρ, καὶ τὸν Οὒρ, καὶ τὸν Ῥοβὸκ, πέντε βασιλεῖς Μαδιάν· καὶ τὸν Βαλαὰμ υἱὸν Βεὼρ ἀπέκτειναν ἐν ῥομφαίᾳ σὺν τοῖς τραυματίαις αὐτῶν· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Καὶ ἐπρονόμευσαν τὰς γυναῖκας Μαδιὰν, καὶ τὴν ἀποσκευὴν αὐτῶν, καὶ τὰ κτήνη αὐτῶν, καὶ πάντα τὰ ἔγκτητα αὐτῶν· καὶ τὴν δύναμιν αὐτῶν ἐπρονόμευσαν· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Καὶ πάσας τὰς πόλεις αὐτῶν τὰς ἐν ταῖς κατοικίαις αὐτῶν, καὶ τὰς ἐπαύλεις αὐτῶν ἐνέπρησαν ἐν πυρί. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Καὶ ἔλαβον πᾶσαν τὴν προνομὴν αὐτῶν, καὶ πάντα τὰ σκῦλα αὐτῶν ἀπὸ ἀνθρώπου ἕως κτήνους. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Καὶ ἤγαγον πρὸς Μωυσῆν καὶ πρὸς Ἐλεάζαρ τὸν ἱερέα, καὶ πρὸς πάντας υἱοὺς Ἰσραὴλ, τὴν αἰχμαλωσίαν, καὶ τὰ σκύλα, καὶ τὴν προνομὴν εἰς τὴν παρεμβολὴν εἰς Ἀραβὼθ Μωὰβ, ἥ ἐστιν ἐπὶ τοῦ Ἰορδάνου κατὰ Ἰεριχώ. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Καὶ ἐξῆλθε Μωυσῆς καὶ Ἐλεάζαρ ὁ ἱερεὺς καὶ πάντες οἱ ἄρχοντες τῆς συναγωγῆς εἰς συνάντησιν αὐτοῖς ἔξω τῆς παρεμβολῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Καὶ ὠργίσθη Μωυσῆς ἐπὶ τοῖς ἐπισκόποις τῆς δυνάμεως, χιλιάρχοις καὶ ἑκατοντάρχοις τοῖς ἐρχομένοις ἐκ τῆς παρατάξεως τοῦ πολέμου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Καὶ εἶπεν αὐτοῖς Μωυσῆς, ἱνατί ἐζωγρήσατε πᾶν θῆλυ; ");
INSERT INTO grcbrent_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Αὗται γὰρ ἦσαν τοῖς υἱοῖς Ἰσραὴλ κατὰ τὸ ῥῆμα Βαλαὰμ τοῦ ἀποστῆσαι καὶ ὑπεριδεῖν τὸ ῥῆμα Κυρίου, ἕνεκεν Φογώρ· καὶ ἐγένετο ἡ πληγὴ ἐν τῇ συναγωγῇ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Καὶ νῦν ἀποκτείνατε πᾶν ἀρσενικὸν ἐν πάσῃ τῇ ἀπαρτίᾳ, πᾶσαν γυναῖκα, ἥτις ἔγυω κοίτην ἄρσενος, ἀποκτείνατε. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Καὶ πᾶσαν τὴν ἀπαρτίαν τῶν γυναικῶν, ἥτις οὐκ οἶδε κοίτην ἄρσενος, ζωγρήσατε αὐτάς. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Καὶ ὑμεῖς παρεμβάλετε ἔξω τῆς παρεμβολῆς ἐπτὰ ἡμέρας· πᾶς ὁ ἀνελὼν καὶ ὁ ἁπτόμενος τοῦ τετρωμένου ἁγνισθήσεται τῇ ἡμέρᾳ τῇ τρίτῃ, καὶ τῇ ἡμέρᾳ τῇ ἑβδόμῃ ὑμεῖς καὶ ἡ αἰχμαλωσία ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Καὶ πᾶν περίβλημα καὶ πᾶν σκεῦος δερμάτινον, καὶ πᾶσαν ἐργασίαν ἐξ αἰγείας, καὶ πᾶν σκεῦος ξύλινον ἀφαγνιεῖτε. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Καὶ εἶπεν Ἐλεάζαρ ὁ ἱερεὺς πρὸς τοὺς ἄνδρας τῆς δυνάμεως τοὺς ἐρχομένους ἐκ τῆς παρατάξεως τοῦ πολέμου, τοῦτο τὸ δικαίωμα τοῦ νόμου ὃ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Πλὴν τοῦ χρυσίου καὶ τοῦ ἀργυρίου καὶ χαλκοῦ καὶ σιδήρου καὶ μολίβου καὶ κασσιτέρου, ");
INSERT INTO grcbrent_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","πᾶν πρᾶγμα ὃ διελεύσεται ἐν πυρὶ, καὶ καθαρισθήσεται, ἀλλʼ ἢ τῷ ὕδατι τοῦ ἁγνισμοῦ ἁγνισθήσεται· καὶ πάντα ὅσα ἐὰν μὴ διαπορεύηται διὰ πυρὸς, διελεύσεται διʼ ὕδατος. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Καὶ πλυνεῖσθε τὰ ἱμάτια τῇ ἡμέρᾳ τῇ ἑβδόμῃ, καὶ καθαρισθήσεσθε· καὶ μετὰ ταῦτα εἰσελεύσεσθε εἰς τὴν παρεμβολήν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","λάβε τὸ κεφάλαιον τῶν σκύλων τῆς αἰχμαλωσίας ἀπὸ ἀνθρώπου ἕως κτήνους σὺ καὶ Ἐλεάζαρ ὁ ἱερεὺς καὶ οἱ ἄρχοντες τῶν πατριῶν τῆς συναγωγῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Καὶ διελεῖτε τὰ σκῦλα ἀναμέσον τῶν πολεμιστῶν τῶν ἐκπεπορευμένων εἰς τὴν παράταξιν, καὶ ἀναμέσον πάσης συναγωγῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Καὶ ἀφελεῖτε τέλος Κυρίῳ παρὰ τῶν ἀνθρώπων τῶν πολεμιστῶν τῶν ἐκπεπορευμένων εἰς τὴν παράταξιν, μίαν ψυχὴν ἀπὸ πεντακοσίων, ἀπὸ τῶν ἀνθρώπων, καὶ ἀπὸ τῶν κτηνῶν, καὶ ἀπὸ τῶν βοῶν, καὶ ἀπὸ τῶν προβάτων, καὶ ἀπὸ τῶν ὄνων· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","καὶ ἀπὸ τοῦ ἡμίσους αὐτῶν λήψεσθε. Καὶ δώσεις Ἐλεάζαρ τῷ ἱερεῖ τὰς ἀπαρχὰς Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Καὶ ἀπὸ τοῦ ἡμίσους τοῦ τῶν υἱῶν Ἰσραὴλ λήψῃ ἕνα ἀπὸ πεντήκοντα ἀπὸ τῶν ἀνθρώπων, καὶ ἀπὸ τῶν βοῶν, καὶ ἀπὸ τῶν προβάτων, καὶ ἀπὸ τῶν ὄνων, καὶ ἀπὸ πάντων τῶν κτηνῶν· καὶ δώσεις αὐτὰ τοῖς Λευίταις τοῖς φυλάσσουσι τὰς φυλακὰς ἐν τῇ σκηνῇ Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Καὶ ἐποίησε Μωυσῆς καὶ Ἐλεάζαρ ὁ ἱερεὺς, καθὰ συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Καὶ ἐγενήθη τὸ πλεόνασμα τῆς προνομῆς ὁ προενόμευσαν οἱ ἄνδρες οἱ πολεμισταὶ, ἀπὸ τῶν προβάτων, ἑξακόσιαι χιλιάδες καὶ ἑβδομήκοντα καὶ πέντε χιλιάδες· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Καὶ βόες, δύο καὶ ἑβδομήκοντα χιλιάδες· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Καὶ ὄνοι, μία καὶ ἑξήκοντα χιλιάδες· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Καὶ ψυχαὶ ἀνθρώπων ἀπὸ τῶν γυναικῶν αἳ οὐκ ἔγνωσαν κοίτην ἀνδρὸς, πᾶσαι ψυχαὶ, δύο καὶ τριάκοντα χιλιάδες. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Καὶ ἐγενήθη τὸ ἡμίσευμα ἡ μερὶς τῶν ἐκπεπορευμένων εἰς τὸν πόλεμον ἐκ τοῦ ἀριθμοῦ τῶν προβάτων, τριακόσιαι καὶ τριάκοντα χιλιάδες καὶ ἑπτακισχίλια καὶ πεντακόσια. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Καὶ ἐγένετο τὸ τέλος Κυρίῳ ἀπὸ τῶν προβάτων, ἑξακόσιαι ἑβδομήκοντα πέντε· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Καὶ βόες, ἓξ καὶ τριάκοντα χιλιάδες, καὶ τὸ τέλος Κυρίῳ, δύο καὶ ἑβδομήκοντα· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Καὶ ὄνοι, τριάκοντα χιλιάδες καὶ πεντακόσιοι, καὶ τὸ τέλος Κυρίῳ, εἷς καὶ ἑξήκοντα· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Καὶ ψυχαὶ ἀνθρώπων, ἑκκαίδεκα χιλιάδες, καὶ τὸ τέλος αὐτῶν Κυρίῳ, δύο καὶ τριάκοντα ψυχαί. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Καὶ ἔδωκε Μωυσῆς τὸ τέλος Κυρίῳ τὸ ἀφαίρεμα τοῦ Θεοῦ Ἐλεάζαρ τῷ ἱερεῖ, καθὰ συνέταξε Κύριος τῷ Μωυσῇ· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ἀπὸ τοῦ ἡμισεύματος τῶν υἱῶν Ἰσραὴλ, οὓς διεῖλε Μωυσῆς ἀπὸ τῶν ἀνδρῶν τῶν πολεμιστῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Καὶ ἐγένετο τὸ ἡμίσευμα ἀπὸ τῆς συναγωγῆς ἀπὸ τῶν προβάων, τριακόσιαι καὶ τριάκοντα χιλιάδες καὶ ἑπτακισχίλια καὶ πεντακόσια· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Καὶ βόες, ἓξ καὶ τριάκοντα χιλιάδες· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Ὄνοι, τριάκοντα χιλιάδες καὶ πεντακόσιοι· ");
INSERT INTO grcbrent_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Καὶ ψυχαὶ ἀνθρώπων, ἓξ καὶ δέκα χιλιάδες. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Καὶ ἔλαβε Μωυσῆς ἀπὸ τοῦ ἡμισεύματος τῶν υἱῶν Ἰσραὴλ τὸ ἓν ἀπὸ τῶν πεντήκοντα, ἀπὸ τῶν ἀνθρώπων καὶ ἀπὸ τῶν κτηνῶν, καὶ ἔδωκεν αὐτὰ τοῖς Λευίταις τοῖς φυλάσσουσι τὰς φυλακὰς τῆς σκηνῆς Κυρίου, ὃν τρόπον συνέταξε Κύριος τῷ Μωυσῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Καὶ προσῆλθον πρὸς Μωυσῆν πάντες οἱ καθεσταμένοι εἰς τὰς χιλιαρχίας τῆς δυνάμεως, χιλίαρχοι καὶ ἑκατόνταρχοι, ");
INSERT INTO grcbrent_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","καὶ εἶπαν πρὸς Μωυσῆν, Οἱ παῖδές σου εἰλήφασι τὸ κεφάλαιον τῶν ἀνδρῶν τῶν πολεμιστῶν τῶν παρʼ ἡμῖν, καὶ οὐ διαπεφώνηκεν ἀπʼ αὐτῶν οὐδὲ εἷς. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Καὶ προσενηνόχαμεν τὸ δῶρον Κυρίῳ, ἀνὴρ ὃ εὗρε σκεῦος χρυσοῦν καὶ χλιδῶνα καὶ ψέλλιον καὶ δακτύλιον καὶ περιδέξιον καὶ ἐμπλοκιον, ἐξιλάσασθαι περὶ ἡμῶν ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Καὶ ἔλαβε Μωυσῆς καὶ Ἐλεάζαρ ὁ ἱερεὺς τὸ χρυσίον παρʼ αὐτῶν πᾶν σκεῦος εἰργασμένον. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Καὶ ἐγένετο πᾶν τὸ χρυσίον τὸ ἀφαίρεμα ὃ ἀφεῖλον Κυρίῳ, ἑκκίδεκα χιλιάδες καὶ ἑπτακόσιοι καὶ πεντήκοντα σίκλοι παρὰ τῶν χιλιάρχων καὶ παρὰ τῶν ἑκατοντάρχων. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Καὶ οἱ ἄνδρες οἱ πολεμισταὶ ἐπρονόμευσαν ἕκαστος ἑαυτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Καὶ ἔλαβε Μωυσῆς καὶ Ἐλεάζαρ ὁ ἱερεὺς τὸ χρυσίον παρὰ τῶν χιλιάρχων καὶ παρὰ τῶν ἑκατοντάρχων, καὶ εἰσήνεγκεν αὐτὰ εἰς τὴν σκηνὴν τοῦ μαρτυρίου, μνημόσυνον τῶν υἱῶν Ἰσραὴλ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Καὶ κτήνη πλῆθος ἦν τοῖς υἱοῖς Ῥουβὴν καὶ τοῖς υἱοῖς Γὰδ, πλῆθος σφόδρα· καὶ εἶδον τὴν χώραν Ἰαζὴρ, καὶ τὴν χώραν Γαλαάδ· καὶ ἦν ὁ τόπος, τόπος κτήνεσι· ");
INSERT INTO grcbrent_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Καὶ προσελθόντες οἱ υἱοὶ Ῥουβὴν καὶ οἱ υἱοὶ Γὰδ, εἶπαν πρὸς Μωυσῆν καὶ πρὸς Ἐλεάζαρ τὸν ἱερέα καὶ πρὸς τοὺς ἄρχοντας τῆς συναγωγῆς, λέγοντες, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Ἀταρὼθ, καὶ Δαιβὼν, καὶ Ἰαζὴρ, καὶ Ναμρὰ, καὶ Ἐσεβὼν, καὶ Ἐλεαλὴ, καὶ Σεβαμὰ, καὶ Ναβαὺ, καὶ Βαιάν, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","τὴν γῆν ἣν παραδέδωκε Κύριος ἐνώπιον τῶν υἱῶν Ἰσραήλ, γῆ κτηνοτρόφος ἐστὶ, καὶ τοῖς παισί σου κτήνη ὑπάρχει. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Καὶ ἔλεγον, εἰ εὕρομεν χάριν ἐνώπιόν σου, δοθήτω ἡ γῆ αὕτη τοῖς οἰκέταις σου ἐν κατασχέσει, καὶ μὴ διαβιβάσῃς ἡμᾶς τὸν Ἰορδάνην. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Καὶ εἶπε Μωυσῆς τοῖς υἱοῖς Γὰδ καὶ τοῖς υἱοῖς Ῥουβὴν, οἱ ἀδελφοὶ ὑμῶν πορεύονται εἰς τὸν πόλεμον, καὶ ὑμεῖς καθήσεσθε αὐτοῦ; ");
INSERT INTO grcbrent_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Καὶ ἱνατί διαστρέφετε τὰς διανοίας τῶν υἱῶν Ἰσραὴλ μὴ διαβῆναι εἰς τὴν γῆν, ἣν Κύριος δίδωσιν αὐτοῖς; ");
INSERT INTO grcbrent_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Οὐχ οὕτως ἐποίησαν οἱ πατέρες ὑμῶν, ὅτε ἀπέστειλα αὐτοὺς ἐκ Κάδης Βαρνὴ κατανοῆσαι τὴν γῆν; ");
INSERT INTO grcbrent_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","καὶ ἀνέβησαν φάραγγα βότρυος, καὶ κατενόησαν τὴν γῆν, καὶ ἀπέστησαν τὴν καρδίαν τῶν υἱῶν Ἰσραὴλ, ὅπως μὴ εἰσέλθωσιν εἰς τὴν γῆν, ἣν ἔδωκε Κύριος αὐτοῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Καὶ ὠργίσθη θυμῷ Κύριος ἐν τῇ ἡμέρᾳ ἐκείνῃ, καὶ ὤμοσε, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","εἰ ὄψονται οἱ ἄνθρωποι οὗτοι οἱ ἀναβάντες ἐξ Αἰγύπτου ἀπὸ εἰκοσαετοῦς καὶ ἐπάνω, οἱ ἐπιστάμενοι τὸ ἀγαθὸν καὶ τὸ κακὸν, τὴν γῆν ἣν ὤμοσα τῷ Ἁβραὰμ καὶ Ἰσαὰκ καὶ Ἰακὼβ, οὐ γὰρ συνεπηκολούθησαν ὀπίσω μου· ");
INSERT INTO grcbrent_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","πλὴν Χάλεβ υἱὸς Ἰεφοννὴ ὁ διακεχωρισμένος, καὶ Ἰησοῦς ὁ τοῦ Ναυὴ, ὅτι συνεπηκολούθησεν ὀπίσω Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Καὶ ὠργίσθη θυμῷ Κύριος ἐπὶ τὸν Ἰσραήλ, καὶ κατερόμβευσεν αὐτοὺς ἐν τῇ ἐρήμῳ τεσσεράκοντα ἔτη, ἕως ἐξανηλώθη πᾶσα ἡ γενεὰ, οἱ ποιοῦντες τὰ πονηρὰ ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ἰδοὺ ἀνέστητε ἀντὶ τῶν πατέρων ὑμῶν, σύντριμμα ἀνθρώπων ἁμαρτωλῶν, προσθεῖναι ἔτι ἐπὶ τὸν θυμὸν τῆς ὀργῆς Κυρίου ἐπὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ὅτι ἀποστραφήσεσθε ἀπʼ αὐτοῦ προσθεῖναι ἔτι καταλιπεῖν αὐτὸν ἐν τῇ ἐρήμῳ, καὶ ἀνομήσετε εἰς ὅλην τὴν συναγωγὴν ταύτην. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Καὶ προσῆλθον αὐτῷ, καὶ ἔλεγον, ἐπαύλεις προβάτων οἰκοδομήσομεν ὧδε τοῖς κτήνεσιν ἡμῶν, καὶ πόλεις ταῖς ἀποσκευαῖς ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Καὶ ἡμεῖς ἐνοπλισάμενοι προφυλακὴν πρότεροι τῶν υἱῶν Ἰσραὴλ, ἕως ἂν ἀγάγωμεν αὐτοὺς εἰς τὸν ἑαυτῶν τόπον· καὶ κατοικήσει ἡ ἀποσκευὴ ἡμῶν ἐν πόλεσι τετειχισμέναις διὰ τοὺς κατοικοῦντας τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Οὐ μὴ ἀποστραφῶμεν εἰς τὰς οἰκίας ἡμῶν ἕως ἂν καταμερισθῶσιν οἱ υἱοὶ Ἰσραὴλ, ἕκαστος εἰς τὴν κληρονομίαν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Καὶ οὐκέτι κληρονομήσομεν ἐν αὐτοῖς ἀπὸ τοῦ πέραν τοῦ Ἰορδάνου καὶ ἐπέκεινα, ὅτι ἀπέχομεν τοὺς κλήρους ἡμῶν ἐν τῷ πέραν τοῦ Ἰορδάνου ἐν ἀνατολαῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Καὶ εἶπε πρὸς αὐτοὺς Μωυσῆς, ἐὰν ποιήσητε κατὰ τὸ ῥῆμα τοῦτο, ἐὰν ἐξοπλίσησθε ἔναντι Κυρίου εἰς πόλεμον, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","καὶ παρελεύσεται ὑμῶν πᾶς ὁπλίτης τὸν Ἰορδάνην ἔναντι Κυρίου, ἕως ἂν ἐκτριβῇ ὁ ἐχθρὸς αὐτοῦ ἀπὸ προσώπου αὐτοῦ, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","καὶ κατακυριευθῇ ἡ γῆ ἔναντι Κυρίου, καὶ μετὰ ταῦτα ἀποστραφήσεσθε, καὶ ἔσεσθε ἀθῶοι ἔναντι Κυρίου, καὶ ἀπὸ Ἰσραήλ· καὶ ἔσται ἡ γῆ αὕτη ὑμῖν ἐν κατασχέσει ἔναντι Κυρίου. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ἐὰν δὲ μὴ ποιήσητε οὕτως, ἁμαρτήσεσθε ἔναντι Κυρίου· καὶ γνώσεσθε τὴν ἁμαρτίαν ὑμῶν, ὅταν ὑμᾶς καταλάβῃ τὰ κακά. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Καὶ οἰκοδομήσετε ὑμῖν ἑαυτοῖς πόλεις τῇ ἀποσκευῇ ὑμῶν, καὶ ἐπαύλεις τοῖς κτήνεσιν ὑμῶν· καὶ τὸ ἐκπορευόμενον ἐκ τοῦ στόματος ὑμῶν ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Καὶ εἶπαν υἱοὶ Ῥουβὴν καὶ υἱοὶ Γὰδ πρὸς Μωυσῆν, λέγοντες, οἱ παῖδές σου ποιήσουσι καθὰ ὁ Κύριος ἡμῶν ἐντέλλεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ἡ ἀποσκευὴ ἡμῶν, καὶ αἱ γυναῖκες ἡμῶν, καὶ πάντα τὰ κτήνη ἡμῶν ἔσονται ἐν ταῖς πόλεσιν Γαλαάδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Οἱ δὲ παῖδές σου παρελεύσονται πάντες ἐνωπλισμένοι καὶ ἐκτεταγμένοι ἔναντι Κυρίου εἰς τὸν πόλεμον, ὃν τρόπον ὁ κύριος λέγει. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Καὶ συνέστησεν αὐτοῖς Μωυσῆς Ἐλεάζαρ τὸν ἱερέα, καὶ Ἰησοῦν υἱὸν Ναυὴ, καὶ τοὺς ἄρχοντας πατριῶν τῶν φυλῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Καὶ εἶπε πρὸς αὐτοὺς Μωυσῆς, ἐὰν διαβῶσιν οἱ υἱοὶ Ῥουβὴν καὶ οἱ υἱοὶ Γὰδ μεθʼ ὑμῶν τὸν Ἰορδάνην, πᾶς ἐνωπλισμένος εἰς πόλεμον ἔναντι Κυρίου, καὶ κατακυριεύσητε τῆς γῆς ἀπέναντι ὑμῶν, καὶ δώσετε αὐτοῖς τὴν γῆν Γαλαὰδ ἐν κατασχέσει. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ἐὰν δὲ μὴ διαβῶσιν ἐνωπλισμένοι μεθʼ ὑμῶν εἰς τὸν πόλεμον ἔναντι Κυρίου, καὶ διαβιβάσετε τὴν ἀποσκευὴν αὐτῶν, καὶ τὰς γυναῖκας αὐτῶν, καὶ τὰ κτήνη αὐτῶν πρότερα ὑμῶν εἰς γῆν Χαναὰν, καὶ συγκατακληρονομηθήσονται ἐν ὑμῖν ἐν τῇ γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Καὶ ἀπεκρίθησαν οἱ υἱοὶ Ῥουβὴν καὶ οἱ υἱοὶ Γὰδ λέγοντες, ὅσα ὁ Κύριος λέγει τοῖς θεράπουσιν, οὕτω ποιήσομεν ἡμεῖς. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Διαβησόμεθα ἐνωπλισμένοι ἔναντι Κυρίου εἰς γῆν Χαναὰν, καὶ δώσετε τὴν κατάσχεσιν ἡμῖν ἐν τῷ πέραν τοῦ Ἰορδάνου. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Καὶ ἔδωκεν αὐτοῖς Μωυσῆς τοῖς υἱοῖς Γὰδ, καὶ τοῖς υἱοῖς Ῥουβὴν, καὶ τῷ ἡμίσει φυλῆς Μανασσῆ υἱῶν Ἰωσὴφ, τὴν βασιλείαν Σηὼν βασιλέως Ἀμοῤῥαίων, καὶ τὴν βασιλείαν Ὢγ βασιλέως τῆς Βασὰν, τὴν γῆν καὶ τὰς πόλεις σὺν τοῖς ὁρίοις αὐτῆς, πόλεις τῆς γῆς κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Καὶ ᾠκοδόμησαν οἱ υἱοὶ Γὰδ τὴν Δαιβὼν, καὶ τὴν Ἀταρὼθ, καὶ τὴν Ἀροὴρ, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","καὶ τὴν Σοφὰρ, καὶ τὴν Ἰαζὴρ, καὶ ὕψωσαν αὐτὰς, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","καὶ τὴν Ναμρὰμ, καὶ τὴν Βαιθαρὰν, πόλεις ὀχυρὰς, καὶ ἐπαύλεις προβάτων. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Καὶ οἱ υἱοὶ Ῥουβὴν ᾠκοδόμησαν τὴν Ἐσεβὼν, καὶ Ἐλεάλην, καὶ Καριαθὰμ, ");
INSERT INTO grcbrent_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","καὶ τὴν Βεελμεὼν, περικεκυκλωμένας, καὶ τὴν Σεβαμά· καὶ ἐπωνόμασαν κατὰ τὰ ὀνόματα αὐτῶν τὰ ὀνόματα τῶν πόλεων, ἃς ᾠκοδόμησαν. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Καὶ ἐπορεύθη υἱὸς Μαχὶρ υἱοῦ Μανασσὴ Γαλαὰδ, καὶ ἔλαβεν αὐτὴν, καὶ ἀπώλεσε τὸν Ἀμοῤῥαῖον τὸν κατοικοῦντα ἐν αὐτῇ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Καὶ ἔδωκε Μωυσῆς τὴν Γαλαὰδ τῷ Μαχὶρ υἱῷ Μανασσῆ, καὶ κατῴκησεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Καὶ Ἰαῒρ ὁ τοῦ Μανασσῆ ἐπορεύθη, καὶ ἔλαβε τὰς ἐπαύλεις αὐτῶν, καὶ ἐπωνόμασεν αὐτὰς ἐπαύλεις Ἰαΐρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Καὶ Ναβαὺ ἐπορεύθη, καὶ ἔλαβε τὴν Καὰθ καὶ τὰς κώμας αὐτῆς, καὶ ἐπωνόμασεν αὐτὰς Ναβὼθ ἐκ τοῦ ὀνόματος αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Καὶ οὗτοι οἱ σταθμοὶ τῶν υἱῶν Ἰσραὴλ, ὡς ἐξῆλθον ἐκ γῆς Αἰγύπτου σὺν δυνάμει αὐτῶν ἐν χειρὶ Μωυσῆ καὶ Ἀαρών. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Καὶ ἔγραψε Μωυσῆς τὰς ἀπάρσεις αὐτῶν, καὶ τοὺς σταθμοὺς αὐτῶν, διὰ ῥήματος Κυρίου· καὶ οὗτοι σταθμοὶ τῆς πορείας αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ἀπῆραν ἐκ Ῥαμεσσὴ τῷ μηνὶ τῷ πρώτῳ, τῇ πεντεκαιδεκάτῃ ἡμέρᾳ τοῦ μηνὸς τοῦ πρώτου· τῇ ἐπαύριον τοῦ πάσχα ἐξῆλθον οἱ υἱοὶ Ἰσραὴλ ἐν χειρὶ ὑψηλῇ ἐναντίον πάντων τῶν Αἰγυπτίων. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Καὶ οἱ Αἰγύπτιοι ἔθαπτον ἐξ αὐτῶν τοὺς τεθνηκότας πάντας οὓς ἐπάταξε Κύριος, πᾶν πρωτότοκον ἐν γῇ Αἰγύπτῳ· καὶ ἐν τοῖς θεοῖς αὐτῶν ἐποίησε τὴν ἐκδίκησιν Κύριος. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Καὶ ἀπάραντες οἱ υἱοὶ Ἰσραὴλ ἐκ Ῥαμεσσῆ, παρενέβαλον εἰς Σοκχώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Καὶ ἀπάραντες ἐκ Σοκχὼθ, παρενέβαλον εἰς Βουθὰν, ὅ ἐστι μέρος τι τῆς ἐρήμου· ");
INSERT INTO grcbrent_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Καὶ ἀπῇραν ἐκ Βουθὰν, καὶ παρενέβαλον ἐπὶ τὸ στόμα Εἰρὼθ, ὅ ἐστιν ἀπέναντι Βεελσεπφὼν, καὶ παρενέβαλον ἀπέναντι Μαγδώλου. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Καὶ ἀπῇραν ἀπέναντι Εἰρὼθ, καὶ διέβησαν μέσον τῆς θαλάσσης εἰς τὴν ἔρημον· καὶ ἐπορεύθησαν ὁδὸν τριῶν ἡμερῶν διὰ τῆς ἐρήμου αὐτοὶ, καὶ παρενέβαλον ἐν Πικρίαις. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Καὶ ἀπῇραν ἐκ Πικριῶν, καὶ ἦλθον εἰς Αἰλίμ· καὶ ἐν Αἰλὶμ δώδεκα πηγαὶ ὑδάτων, καὶ ἑβδομήκοντα στελέχη φοινίκων, καὶ παρενέβαλον ἐκεῖ παρὰ τὸ ὕδωρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Καὶ ἀπῇραν ἐξ Αἰλὶμ, καὶ παρενέβαλον ἐπὶ θάλασσαν ἐρυθράν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Καὶ ἀπῇραν ἀπὸ θαλάσσης ἐρυθρᾶς, καὶ παρενέβαλον εἰς τὴν ἔρημον Σίν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Καὶ ἀπῇραν ἐκ τῆς ἐρήμου Σὶν, καὶ παρενέβαλον εἰς Ῥαφακά. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Καὶ ἀπῇραν ἐκ Ῥαφακὰ, καὶ παρενέβαλον ἐν Αἰλούς. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Καὶ ἀπῇραν ἐξ Αἰλούς, καὶ παρενέβαλον ἐν Ῥαφιδίν· καὶ οὐκ ἦν ἐκεῖ ὕδωρ τῷ λαῷ πιεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Καὶ ἀπῇραν ἐκ Ῥαφιδὶν, καὶ παρενέβαλον ἐν τῇ ἐρήμῳ Σινᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Καὶ ἀπῇραν ἐκ τῆς ἐρήμου Σινᾶ, καὶ παρενέβαλον ἐν μνήμασι τῆς ἐπιθυμίας. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Καὶ ἀπῇραν ἐκ μνημάτων τῆς ἐπιθυμίας, καὶ παρενέβαλον ἐν Ἀσηρώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Καὶ ἀπῇραν ἐξ Ἀσηρὼθ, καὶ παρενέβαλον ἐν Ῥαθαμᾷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Καὶ ἀπῇραν ἐκ Ῥαθαμᾶ, καὶ παρενέβαλον ἐν Ῥεμμὼν Φαρές. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Καὶ ἀπῇραν ἐκ Ῥεμμὼν Φαρὲς, καὶ παρενέβαλον εἰς Λεβωνᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Καὶ ἀπῇραν ἐκ Λεβῶνα, καὶ παρενέβαλον εἰς Ῥεσσάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Καὶ ἀπῇραν ἐκ Ῥεσσὰν, καὶ παρενέβαλον εἰς Μακελλάθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Καὶ ἀπῇραν ἐκ Μακελλὰθ, καὶ παρενέβαλον εἰς Σαφάρ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Καὶ ἀπῇραν ἑκ Σαφὰρ, καὶ παρενέβαλον εἰς Χαραδάθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Καὶ ἀπῇραν ἐκ Χαραδὰθ, καὶ παρενέβαλον εἰς Μακηλώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Καὶ ἀπῇραν ἐκ Μακηλὼθ, καὶ παρενέβαλον εἰς Καταάθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Καὶ ἀπῇραν ἐκ Καταὰθ, καὶ παρενέβαλον εἰς Ταράθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Καὶ ἀπῇραν ἐκ Ταρὰθ, καὶ παρενέβαλον εἰς Μαθεκκά. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Καὶ ἀπῇραν ἐκ Μαθεκκὰ, καὶ παρενέβαλον εἰς Σελμωνᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Καὶ ἀπῇραν ἐκ Σελμωνᾶ, καὶ παρενέβαλον εἰς Μασουρούθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Καὶ ἀπῇραν ἐκ Μασουροὺθ, καὶ παρενέβαλον εἰς Βαναία. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Καὶ ἀπῇραν ἐκ Βαναία, καὶ παρενέβαλον εἰς τὸ ὄρος Γαδγάδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Καὶ ἀπῇραν ἐκ τοῦ ὄρους Γαδγὰδ, καὶ παρενέβαλον εἰς Ἐτεβαθά. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Καὶ ἀπῇραν ἐξ Ἐτεβαθὰ, καὶ παρενέβαλον εἰς Ἐβρωνά. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Καὶ ἀπῇραν ἐξ Ἐβρωνὰ, καὶ παρενέβαλον εἰς Γεσιὼν Γάβερ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Καὶ ἀπῇραν ἐκ Γεσιὼν Γάβερ, καὶ παρενέβαλον ἐν τῇ ἐρήμῳ Σίν· καὶ ἀπῇραν ἐκ τῆς ἐρήμου Σὶν, καὶ παρενέβαλον εἰς τὴν ἔρημον Φαράν· αὕτη ἐστὶ Κάδης. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Καὶ ἀπῇραν ἐκ Κάδης, καὶ παρενέβαλον εἰς Ὢρ τὸ ὄρος πλησίον γῆς Ἐδώμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Καὶ ἀνέβη Ἀαρὼν ὁ ἱερεὺς διὰ προστάγματος Κυρίου, καὶ ἀπέθανεν ἐκεῖ ἐν τῷ τεσσαρακοστῷ ἔτει τῆς ἐξόδου τῶν υἱῶν Ἰσραὴλ ἐκ γῆς Αἰγύπτου, τῷ μηνὶ τῷ πέμπτῳ μιᾷ τοῦ μηνός. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Καὶ Ἀαρὼν ἦν τριῶν καὶ εἴκοσι καὶ ἑκατὸν ἐτῶν, ὅτε ἀπέθνησκεν ἐν Ὢρ τῷ ὄρει. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Καὶ ἀκούσας ὁ Χανανὶς βασιλεὺς Ἀρὰδ, καὶ οὗτος κατῴκει ἐν γῇ Χαναὰν, ὅτε εἰσεπορεύοντο οἱ υἱοὶ Ἰσραήλ· ");
INSERT INTO grcbrent_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","καὶ ἀπῇραν ἐξ Ὢρ τοῦ ὄρους, καὶ παρενέβαλον εἰς Σελμωνᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Καὶ ἀπῇραν ἐκ Σελμωνᾶ, καὶ παρενέβαλον εἰς Φινώ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Καὶ ἀπῇραν ἐκ Φινὼ, καὶ παρενέβαλον ἐν Ὠβώθ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Καὶ ἀπῇραν ἐξ Ὠβὼθ, καὶ παρενέβαλον ἐν Γαῒ, ἐν τῷ πέραν ἐπὶ τῶν ὁρίων Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Καὶ ἀπῇραν ἐκ Γαῒ, καὶ παρενέβαλον εἰς Δαιβὼν Γάδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Καὶ ἀπῇραν ἐκ Δαιβὼν Γὰδ, καὶ παρενέβαλον ἐν Γελμὼν Δεβλαθαίμ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Καὶ ἀπῇραν ἐκ Γελμὼν Δεβλαθαὶμ, καὶ παρενέβαλον ἐπὶ τὰ ὄρη τὰ Ἀβαρὶμ, ἀπέναντι Ναβαῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Καὶ ἀπῇραν ἀπὸ ὀρέων Ἀβαρὶμ, καὶ παρενέβαλον ἐπὶ δυσμῶν Μωὰβ, ἐπὶ τοῦ Ἰορδάνου κατὰ Ἱεριχώ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Καὶ παρενέβαλον παρὰ τὸν Ἰορδάνην ἀναμέσον Αἰσιμώθ, ἕως Βελσᾶ τὸ κατὰ δυσμὰς Μωάβ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Καὶ ἐλάλησε Κύριος πρὸ; Μωυσῆν ἐπὶ δυσμῶν Μωὰβ παρὰ τὸν Ἰορδάνην κατὰ Ἱεριχὼ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ὑμεῖς διαβαίνετε τὸν Ἰορδάνην εἰς γῆν Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Καὶ ἀπολεῖτε πάντας τοὺς κατοικοῦντας ἐν τῇ γῇ πρὸ προσώπου ὑμῶν, καὶ ἐξαρεῖτε τὰς σκοπιὰς αὐτῶν, καὶ πάντα τὰ εἴδωλα τὰ χωνευτὰ αὐτῶν ἀπολεῖτε αὐτὰ, καὶ πάσας τὰς στήλας αὐτῶν ἐξαρεῖτε. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Καὶ ἀπολεῖτε πάντας τοὺς κατοικοῦντας τὴν γῆν, καὶ κατοικήσετε ἐν αὐτῇ, ὑμῖν γὰρ δέδωκα τὴν γῆν αὐτῶν ἐν κλήρῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Καὶ κατακληρονομήσετε τὴν γῆν αὐτῶν ἐν κλήρῳ κατὰ φυλὰς ὑμῶν· τοῖς πλείοσι πληθυνεῖτε τὴν κατάσχεσιν αὐτῶν, καὶ τοῖς ἐλάττοσιν ἐλαττώσετε τὴν κατάσχεσιν αὐτῶν· εἰς ὃ ἂν ἐξέλθῃ τὸ ὄνομα αὐτοῦ, ἐκεῖ αὐτοῦ ἔσται· κατὰ φυλὰς πατριῶν ὑμῶν κληρονομήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ἐὰν δὲ μὴ ἀπολέσητε τοὺς κατοικοῦντας ἐπὶ τῆς γῆς ἀπὸ προσώπου ὑμῶν, καὶ ἔσται οὓς ἐὰν καταλίπητε ἐξ αὐτῶν, σκόλοπες ἐν τοῖς ὀφθαλμοῖς ὑμῶν, καὶ βολίδες ἐν ταῖς πλευραῖς ὑμῶν, καὶ ἐχθρεύσουσιν ὑμῖν ἐπὶ τῆς γῆς, ἐφʼ ἣν ὑμεῖς κατοικήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Καὶ ἔσται καθότι διεγνώκειν ποιῆσαι αὐτοὺς, ποιήσω ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","ἔντειλαι τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ὑμεῖς εἰσπορεύεσθε εἰς τὴν γῆν Χαναὰν· αὕτη ἔσται ὑμῖν εἰς κληρονομίαν, γῆ Χαναὰν σὺν τοῖς ὁρίοις αὐτῆς. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Καὶ ἔσται ὑμῖν τὸ κλίτος τὸ πρὸς Λίβα ἀπὸ ἐρήμου Σὶν ἕως ἐχόμενον Ἐδὼμ, καὶ ἔσται ὑμῖν τὰ ὅρια πρὸς λίβα ἀπὸ μέρους τῆς θαλάσσης τῆς ἁλυκῆς ἀπὸ ἀνατολῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Καὶ κυκλώσει ὑμᾶς τὰ ὅρια ἀπὸ Λιβὸς πρὸς ἀνάβασιν Ἀκραβὶν, καὶ παρελεύσεται Ἐννὰκ, καὶ ἔσται ἡ διέξοδος αὐτοῦ πρὸς Λίβα Κάδης τοῦ Βαρνὴ, καὶ ἐξελεύσεται εἰς ἔπαυλιν Ἀρὰδ, καὶ παρελεύσεται Ἀσεμωνᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Καὶ κυκλώσει τὰ ὅρια ἀπὸ Ἀσεμωνᾶ χειμάῤῥουν Αἰγύπτου, καὶ ἔσται ἡ διέξοδος ἡ θάλασσα. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Καὶ τὰ ὅρια τῆς θαλάσσης ἔσται ὑμῖν, ἡ θάλασσα ἡ μεγάλη ὁριεῖ, τοῦτο ἔσται ὑμῖν τὰ ὅρια τῆς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Καὶ τοῦτο ἔσται ὑμῖν τὰ ὅρια πρὸς βοῤῥᾶν· ἀπὸ τῆς θαλάσσης τῆς μεγάλης καταμετρήσετε ὑμῖν αὐτοῖς παρὰ τὸ ὄρος τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Καὶ ἀπὸ τοῦ ὄρους τὸ ὄρος καταμετρήσετε αὐτοῖς, εἰσπορευομένων εἰς Ἐμὰθ, καὶ ἔσται ἡ διέξοδος αὐτοῦ τὰ ὅρια Σαραδάκ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Καὶ ἐξελεύσεται τὰ ὅρια Δεφρωνὰ, καὶ ἔσται ἡ διέξοδος αὐτοῦ Ἀρσεναΐν· τοῦτο ἔσται ὑμῖν ὅρια ἀπὸ Βοῤῥᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Καὶ καταβήσεται τὰ ὅρια ἀπὸ Σεπεφαμὰρ Βηλὰ ἀπὸ ἀνατολῶν ἐπὶ πηγὰς, και καταβήσεται τὰ ὅρια Βηλὰ ἐπὶ νώτου θαλάσσης Χενερὲθ ἀπὸ ἀνατολῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Καὶ καταβήσεται τὰ ὅρια ἀπὸ Σεπφαμὰρ Βηλὰ ἀπὸ ἀνατολῶν ἐπὶ πηγάς, καὶ καταβήσεται τὰ ὅρια Βηλὰ ἐπὶ νώτου θαλάσσης Χενερὲθ ἀπὸ ἀνατολῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Καὶ καταβήσεται τὰ ὅρια ἐπὶ τὸν Ἰορδάνην, καὶ ἔσται ἡ διέξοδος θάλασσα ἡ ἁλυκή· αὕτη ἔσται ὑμῖν ἡ γῆ καὶ τὰ ὅρια αὐτῆς κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Καὶ ἐνετείλατο Μωυσῆς τοῖς υἱοῖς Ἰσραὴλ, λέγων, αὕτη ἡ γῆ ἣν κατακληρονομήσετε αὐτὴν μετὰ κλήρου, ὃν τρόπον συνέταξε Κύριος δοῦναι αὐτὴν ταῖς ἐννέα φυλαῖς καὶ τῷ ἡμίσει φυλῆς Μανασσῆ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Ὅτι ἔλαβε φυλὴ υἱῶν Ῥουβὴν, καὶ φυλὴ υἱῶν Γὰδ κατʼ οἴκους πατριῶν αὐτῶν· καὶ τὸ ἥμισυ φυλῆς Μανασσῆ ἀπέλαβον τοὺς κλήρους αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Δύο φυλαὶ καὶ ἥμισυ φυλῆς ἔλαβον τοὺς κλήρους αὐτῶν πέραν τοῦ Ἰορδάνου κατὰ Ἱεριχὼ ἀπὸ Νότου κατʼ ἀνατολάς. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","ταῦτα τὰ ὀνόματα τῶν ἀνδρῶν, οἳ κληρονομήσουσιν ὑμῖν τὴν γῆν· Ἐλεάζαρ ὁ ἱερεὺς καὶ Ἰησοῦς ὁ τοῦ Ναυή. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Καὶ ἄρχοντα ἕνα ἐκ φυλῆς λήψεσθε κατακληρονομῆσαι ὑμῖν τὴν γῆν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Καὶ ταῦτα τὰ ὀνόματα τῶν ἀνδρῶν· τῆς φυλῆς Ἰούδα, Χάλεβ υἱὸς Ἰεφοννή. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Τῆς φυλῆς Συμεὼν, Σαλαμιὴλ υἱὸς Σεμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Τῆς φυλῆς Βενιαμὶν, Ἐλδὰδ υἱὸς Χασλών· ");
INSERT INTO grcbrent_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Τῆς φυλῆς Δὰν, ἄρχων Βακχὶρ υἱὸς Ἐγλί. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Τῶν υἱῶν Ἰωσὴφ φυλῆς υἱῶν Μανασσῆ, ἄρχων Ἀνιὴλ υἱὸς Σουφί. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Τῆς φυλῆς υἱῶν Ἐφραὶμ, ἄρχων Καμουὴλ υἱὸς Σαβαθᾶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Τῆς φυλῆς Ζαβουλὼν, ἄρχων Ἐλισαφὰν υἱὸς Φαρνάχ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Τῆς φυλῆς υἱῶν Ἰσσάχαρ, ἄρχων Φαλτιὴλ υἱὸς Ὀζᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Τῆς φυλῆς υἱῶν Ἀσὴρ, ἄρχων Ἀχιὼρ υἱὸς Σελεμί. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Τῆς φυλῆς Νεφθαλὶ, ἄρχων Φαδαὴλ υἱὸς Ἰαμιούδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Τούτοις ἐνετείλατο Κύριος καταμερίσαι τοῖς υἱοῖς Ἰσραὴλ ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν ἐπὶ δυσμῶν Μωὰβ παρὰ τὸν Ἰορδάνην κατὰ Ἱεριχὼ, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","σύνταξον τοῖς υἱοῖς Ἰσραὴλ, καὶ δώσουσι τοῖς Λευίταις ἀπὸ τῶν κλήρων κατασχέσεως αὐτῶν πόλεις κατοικεῖν· καὶ τὰ προάστεια τῶν πόλεων κύκλῳ αὐτῶν δώσουσι τοῖς Λευίταις. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Καὶ ἔσονται αὐτοῖς αἱ πόλεις κατοικεῖν, καὶ τὰ ἀφορίσματα αὐτῶν ἔσται τοῖς κτήνεσιν αὐτῶν, καὶ πᾶσι τοῖς τετράποσιν αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Καὶ τὰ συνκυροῦντα τῶν πόλεων, ἃς δώσετε τοῖς Λευίταις, ἀπὸ τείχους τῆς πόλεως καὶ ἔξω δισχιλίους πήχεις κύκλῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Καὶ μετρήσεις ἔξω τῆς πόλεως τὸ κλίτος τὸ πρὸς ἀνατολὰς δισχιλίους πήχεις, καὶ τὸ κλίτος τὸ πρὸς Λίβα δισχιλίους πήχεις, καὶ τὸ κλίτος τὸ πρὸς θάλασσαν διαχιλίους πήχεις, καὶ τὸ κλίτος τὸ πρὸς Βοῤῥᾶν δισχιλίους πήχεις· καὶ ἡ πόλις μέσον τούτου ἔσται ὑμῖν, καὶ τὰ ὅμορα τῶν πόλεων. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Καὶ τὰς πόλεις δώσετε τοῖς Λευίταις, τὰς ἓξ πόλεις τῶν φυγαδευτηρίων ἃς δώσετε φυγεῖν ἐκεῖ τῷ φονεύσαντι, καὶ πρὸς ταύταις τεσσαράκοντα καὶ δύο πόλεις. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Πάσας τὰς πόλεις δώσετε τοῖς Λευίταις τεσσαράκοντα καὶ ὀκτὼ πόλεις· ταύτας, καὶ τὰ προάστεια αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Καὶ τὰς πόλεις ἃς δώσετε ἀπὸ τῆς κατασχέσεως υἱῶν Ἰσραὴλ, ἀπὸ τῶν τὰ πολλὰ, πολλά· καὶ ἀπὸ τῶν ἐλαττόνων, ἐλάττω· ἕκαστος κατὰ τὴν κληρονομίαν αὐτοῦ ἣν κατακληρονομήσουσι, δώσουσιν ἀπὸ τῶν πόλεων τοῖς Λευίταις. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Καὶ ἐλάλησε Κύριος πρὸς Μωυσῆν, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","λάλησον τοῖς υἱοῖς Ἰσραὴλ, καὶ ἐρεῖς πρὸς αὐτοὺς, ὑμεῖς διαβαίνετε τὸν Ἰορδάνην εἰς γῆν Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","Καὶ διαστελεῖτε ὑμῖν αὐτοῖς πόλεις· φυγαδευτήρια ἔσται ὑμῖν φυγεῖν ἐκεῖ τὸν φονευτὴν, πᾶς ὁ πατάξας ψυχὴν ἀκουσίως. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Καὶ ἔσονται αἱ πόλεις ὑμῖν φυγαδευτήρια ἀπὸ τοῦ ἀγχιστεύοντος τὸ αἷμα, καὶ οὐ μὴ ἀποθάνῃ ὁ φονεύων ἕως ἂν στῇ ἔναντι τῆς συναγωγῆς εἰς κρίσιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Καὶ αἱ πόλεις ἃς δώσετε τὰς ἓξ πόλεις, φυγαδευτήρια ἔσονται ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Τὰς τρεῖς πόλεις δώσετε πέραν τοῦ Ἰορδάνου, καὶ τὰς τρεῖς πόλεις δώσετε ἐν γῇ Χαναάν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Φυγαδεῖον ἔσται τοῖς υἱοῖς Ἰσραήλ, καὶ τῷ προσηλύτῳ, καὶ τῷ παροίκῳ τῷ ἐν ὑμῖν· ἔσονται αἱ πόλεις αὗται εἰς φυγαδευτήριον, φυγεῖν ἐκεῖ παντὶ πατάξαντι ψυχὴν ἀκουσίως. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Ἐὰν δὲ ἐν σκεύει σιδήρου πατάξῃ αὐτὸν, καὶ τελευτήσῃ, φονευτής ἐστι· θανάτῳ θανατούσθω ὁ φονευτής. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ἐὰν δὲ ἐν λίθῳ ἐκ χειρὸς ἐν ᾧ ἀποθανεῖται ἐν αὐτῷ, πατάξῃ αὐτὸν, καὶ ἀποθάνῃ, φονευτής ἐστι· θανάτῳ θανατούσθω ὁ φονευτής. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ἐὰν δὲ ἐν σκεύει ξυλίνῳ ἐκ χειρὸς ἐξ οὗ ἀποθανεῖται ἐν αὐτῷ, πατάξῃ αὐτόν, καὶ ἀποθάνῃ, φονευτής ἐστι· θανάτῳ θανατούσθω ὁ φονευτής. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ὁ ἀγχιστεύων τὸ αἷμα, οὗτος ἀποκτενεῖ τὸν φονεύσαντα· ὅταν συναντήσῃ αὐτῷ οὗτος, ἀποκτενεῖ αὐτόν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ἐὰν δὲ διʼ ἔχθραν ὤσῃ αὐτὸν, καὶ ἐπιῤῥίψῃ ἐπʼ αὐτὸν πᾶν σκεῦος ἐξ ἐνέδρου, καὶ ἀποθάνῃ, ");
INSERT INTO grcbrent_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ἢ διὰ μῆνιν ἐπάταξεν αὐτὸν τῇ χειρί, καὶ ἀποθάνῃ, θανάτῳ θανατούσθω ὁ πατάξας, φονευτής ἐστι· θανάτῳ θανατούσθω ὁ φονεύων· ὁ ἀγχιστεύων τὸ αἷμα ἀποκτενεῖ τὸν φονεύσαντα ἐν τῷ συναντῆσαι αὐτῷ. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ἐὰν δὲ ἐξάπινα, οὐ διʼ ἔχθραν ὤσῃ αὐτὸν, ἢ ἐπιῤῥίψῃ ἐπʼ αὐτὸν πᾶν σκεῦος, οὐκ ἐξ ἐνέδρου, ");
INSERT INTO grcbrent_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ἢ παντὶ λίθῳ, ἐν ᾧ ἀποθανεῖται ἐν αὐτῷ, οὐκ εἰδὼς, καὶ ἐπιπέσῃ ἐπʼ αὐτὸν, καὶ ἀποθάνῃ, αὐτὸς δὲ οὐκ ἐχθρὸς αὐτοῦ ἦν, οὐδὲ ζητῶν κακοποιῆσαι αὐτόν· ");
INSERT INTO grcbrent_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","καὶ κρινεῖ ἡ συναγωγὴ ἀναμέσον τοῦ πατάξαντος καὶ ἀναμέσον τοῦ ἀγχιστεύοντος τὸ αἷμα, κατὰ τὰ κρίματα ταῦτα. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Καὶ ἐξελεῖται ἡ συναγωγὴ τὸν φονεύσαντα ἀπὸ τοῦ ἀγχιστεύοντος τὸ αἷμα, καὶ ἀποκαταστήσουσιν αὐτὸν ἡ συναγωγὴ εἰς τὴν πόλιν τοῦ φυγαδευτηρίου αὐτοῦ, οὗ κατέφυγε, καὶ κατοικήσει ἐκεῖ ἕως ἂν ἀποθάνῃ ὁ ἱερεὺς ὁ μέγας, ὃν ἔχρισαν αὐτὸν τῷ ἐλαίῳ τῷ ἁγίῳ. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ἐὰν δὲ ἐξόδῳ ἐξέλθῃ ὁ φονεύασς τὰ ὅρια τῆς πόλεως εἰς ἣν κατέφυγεν ἐκεῖ, ");
INSERT INTO grcbrent_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","καὶ εὕρῃ αὐτὸν ὁ ἀγχιστεύων τὸ αἷμα ἔξω τῶν ὁρίων τῆς πόλεως καταφυγῆς αὐτοῦ, καὶ φονεύσῃ ὁ ἀγχιστεύων τὸ αἷμα τὸν φονεύσαντα, οὐκ ἔνοχός ἐστιν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ἐν γὰρ τῇ πόλει τῆς καταφυγῆς κατοικείτω ἕως ἂν ἀποθάνῃ ὁ ἱερεὺς ὁ μέγας· καὶ μετὰ τὸ ἀποθανεῖν τὸν ἱερέα τὸν μέγαν, ἐπαναστραφήσεται ὁ φονεύσας εἰς τὴν γῆν τῆς κατασχέσεως αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Καὶ ἔσται ταῦτα ὑμῖν εἰς δικαίωμα κρίματος εἰς τὰς γενεὰς ὑμῶν ἐν πάσαις ταῖς κατοικίαις ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Πᾶς πατάξας ψυχήν, διὰ μαρτύρων φονεύσεις τὸν φονεύσαντα· καὶ μάρτυς εἷς οὐ μαρτυρήσει ἐπὶ ψυχὴν ἀποθανεῖν. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Καὶ οὐ λήψεσθε λύτρα περὶ ψυχῆς παρὰ τοῦ φονεύσαντος τοῦ ἐνόχου ὄντος ἀναιρεθῆναι· θανάτῳ γὰρ θανατωθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Οὐ λήψεσθε λύτρα τοῦ φυγεῖν εἰς πόλιν τῶν φυγαδευτηρίων, τοῦ πάλιν κατοικεῖν ἐπὶ τῆς γῆς, ἕως ἂν ἀποθάνῃ ὁ ἱερεὺς ὁ μέγας. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Καὶ οὐ μὴ φονοκτονήσητε τὴν γῆν εἰς ἣν ὑμεῖς κατοικεῖτε· τὸ γὰρ αἷμα τοῦτο φονοκτονεῖ τὴν γῆν, καὶ οὐκ ἐξιλασθήσεται ἡ γῆ ἀπὸ τοῦ αἵματος τοῦ ἐκχυθέντος ἐπʼ αὐτῆς, ἀλλʼ ἐπὶ τοῦ αἵματος τοῦ ἐκχέοντος. ");
INSERT INTO grcbrent_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Καὶ οὐ μιανεῖτε τὴν γῆν ἐφʼ ἧς κατοικεῖτε ἐπʼ αὐτῆς, ἐφʼ ἧς ἐγὼ κατασκηνώ ἐν ὑμῖν· ἐγὼ γάρ εἰμι Κύριος κατασκηνῶν ἐν μέσῳ τῶν υἱῶν Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Καὶ προσῆλθον οἱ ἄρχοντες φυλῆς υἱῶν Γαλαὰδ υἱοῦ Μαχὶρ υἱοῦ Μανασσῆ ἐκ τῆς φυλῆς υἱῶν Ἰωσὴφ, καὶ ἐλάλησαν ἔναντι Μωυσῆ, καὶ ἔναντι Ἐλεάζαρ τοῦ ἱερέως, καὶ ἔναντι τῶν ἀρχόντων οἴκων πατριῶν τῶν υἱῶν Ἰσραὴλ, ");
INSERT INTO grcbrent_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","καὶ εἶπαν, τῷ κυρῖῳ ἡμῶν ἐνετείλατο Κύριος ἀποδοῦναι τὴν γῆν τῆς κληρονομίας ἐν κλήρῳ τοῖς υἱοῖς Ἰσραήλ· καὶ τῷ κυρίῳ συνέταξε Κύριος δοῦναι τὴν κληρονομίαν Σαλπαὰδ τοῦ ἀδελφοῦ ἡμῶν ταῖς θυγατράσιν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Καὶ ἔσονται ἑνὶ τῶν φυλῶν υἱῶν Ἰσραὴλ γυναῖκες· καὶ ἀφαιρεθήσεται ὁ κλῆρος αὐτῶν ἐκ τῆς κατασχέσεως τῶν πατέρεν ἡμῶν, καὶ προστεθήσεται εἰς κληρονομίαν τῆς φυλῆς, οἷς ἂν γένωνται γυναῖκες, καὶ ἐκ τοῦ κλήρου τῆς κληρονομίας ἡμῶν ἀφαιρεθήσεται. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ἐὰν δὲ γένηται ἡ ἄφεσις τῶν υἱῶν Ἰσραὴλ, καὶ προστεθήσεται ἡ κληρονομία αὐτῶν ἐπὶ τὴν κληρονομίαν τῆς φυλῆς, οἷς ἂν γένωνται γυναῖκες, καὶ ἀπὸ τῆς κληρονομίας φυλῆς πατριᾶς ἡμῶν ἀφαιρεθήσεται ἡ κληρονομία αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Καὶ ἐνετείλατο Μωυσῆς τοῖς υἱοῖς Ἰσραὴλ διὰ προστάγματος Κυρίου, λέγων, οὕτως φυλὴ υἱῶν Ἰωσὴφ λέγουσι. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Τοῦτο τὸ ῥῆμα ὃ συνέταξε Κύριος ταῖς θυγατράσι Σαλπαὰδ, λέγων, οὗ ἀρέσκῃ ἐναντίον αὐτῶν, ἔστωσαν γυναῖκες, πλὴν ἐκ τοῦ δήμου τοῦ πατρὸς αὐτῶν ἔστωσαν γυναῖκες. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Καὶ οὐχὶ περιστραφήσεται κληρονομία τοῖς υἱοῖς Ἰσραὴλ ἀπὸ φυλῆς ἐπὶ φύλην, ὅτι ἕκαστος ἐν τῇ κληρονομίᾳ τῆς φυλῆς τῆς πατριᾶς αὐτοῦ προσκολληθήσονται οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Καὶ πᾶσα θυγάτηρ ἀγχιατεύουσα κληρονομίαν ἐκ τῶν φυλῶν υἱῶν Ἰσραὴλ, ἑνὶ τῶν ἐκ τοῦ δήμου τοῦ πατρὸς αὐτῆς ἔσονται γυναῖκες, ἵνα ἀγχιστεύσωσιν οἱ υἱοὶ Ἰσραὴλ ἕκαστος τὴν κληρονομίαν τὴν πατρικὴν αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Καὶ οὐ περιστραφήσεται ὁ κλῆρος ἐκ φυλῆς ἐπὶ φυλὴν ἑτέραν, ἀλλʼ ἕκαστος ἐν τῇ κληρονομίᾳ αὐτοῦ προσκολληθήσονται οἱ υἱοὶ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Ὃν τρόπον συνέταξε Κύριος Μωυσῇ, οὕτως ἐποίησαν θυγατράσι Σαλπαάδ. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Καὶ ἐγένοντο Θερσὰ καὶ Ἐγλὰ καὶ Μελχὰ καὶ Νούα καὶ Μαλαὰ θυγατέρες Σαλπαὰδ, τοῖς ἀνεψιοῖς αὐτῶν, ");
INSERT INTO grcbrent_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ἐκ τοῦ δήμου τοῦ Μανασσῆ υἱῶν Ἰωσὴφ ἐγενήθησαν γυναῖκες· καὶ ἐγενήθη ἡ κληρονομία αὐτῶν ἐπὶ τὴν φυλὴν δήμου τοῦ πατρὸς αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Αὗται αἱ ἐντολαὶ καὶ τὰ δικαιώματα καὶ τὰ κρίματα, ἃ ἐνετείλατο Κύριος ἐν χειρὶ Μωυσῆ ἐπὶ δυσμῶν Μωὰβ ἐπὶ τοῦ Ἰορδάνου κατὰ Ἰεριχώ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ΟΥΤΟΙ οἱ λόγοι οὓς ἐλάλησε Μωυσῆς παντὶ Ἰσραὴλ πέραν τοῦ Ἰορδάνου ἐν τῇ ἐρήμῳ πρὸς δυσμαῖς πλησίον τῆς ἐρυθρᾶς θαλάσσης ἀναμέσον Φαρὰν Τοφὸλ, καὶ Λοβὸν, καὶ Αὐλῶν, καὶ καταχρύσεα. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Ἕνδεκα ἡμερῶν ἐκ Χωρὴβ ὁδὸς ἐπʼ ὄρος ");
INSERT INTO grcbrent_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Σηεὶρ ἕως Κάδης Βαρνή. Καὶ ἐγενήθη ἐν τῷ τεσσαρακοστῷ ἔτει ἐν τῷ ἑνδεκάτῳ μηνὶ μιᾷ τοῦ μηνὸς, ἐλάλησε Μωυσῆς πρὸς πάντας υἱοὺς Ἰσραὴλ, κατὰ πάντα ὅσα ἐνετείλατο Κύριος αὐτῷ πρὸς αὐτούς· μετὰ τὸ πατάξαι ");
INSERT INTO grcbrent_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Σηὼν βασιλέα Ἀμοῤῥαίων τὸν κατοικήσαντα ἐν Ἐσεβὼν, καὶ τὸν Ὢγ βασιλέα τῆς Βασὰν τὸν κατοικήσαντα ἐν Ἀσταρὼθ καὶ ἐν ");
INSERT INTO grcbrent_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ἐδραῒν, ἐν τῷ πέραν τοῦ Ἰορδάνου ἐν γῇ Μωὰβ, ἤρξατο Μωυσῆς διασαφῆσαι τὸν νόμον τοῦτον, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Κύριος ὁ Θεὸς ἡμῶν ἐλάλησεν ἡμῖν ἐν Χωρὴβ, λέγων, ἰκανούσθω ὑμῖν κατοικεῖν ἐν τῷ ὄρει τούτῳ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ἐπιστράφητε καὶ ἀπάρατε ὑμεῖς καὶ εἰσπορεύεσθε εἰς ὄρος Ἀμοῤῥαίων, καὶ πρὸς πάντας τοὺς περιοίκους Ἄραβα, εἰς ὄρος καὶ πεδίον, καὶ πρὸς Λίβα, καὶ παραλίαν γῆν Χαναναίων, καὶ Ἀντιλίβανον ἕως τοῦ ποταμοῦ τοῦ μεγάλου, ποταμοῦ Εὐφράτου. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ἴδετε, παραδέδωκεν ἐνώπιον ὑμῶν τὴν γῆν· εἰσπορευθέντες κληρονομήσατε τὴν γῆν, ἣν ὤμοσα τοῖς πατράσιν ὑμῶν τῷ Ἁβραὰμ, καὶ Ἰσαὰκ, καὶ Ἰσκὼβ, δοῦναι αὐτοῖς καὶ τῷ σπέρματι αὐτῶν μετʼ αὐτούς. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Καὶ εἶπα πρὸς ὑμᾶς ἐν τῷ καιρῷ ἐκείνῳ, λέγων, οὐ δυνήσομαι μόνος φέρειν ὑμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Κύριος ὁ Θεὸς ὑμῶν ἐπλήθυνεν ὑμᾶς, καὶ ἰδού ἐστε σήμερον ὡσεὶ τὰ ἄστρα τοῦ οὐρανοῦ τῷ πλήθει. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Κύριος ὁ Θεὸς τῶν πατέρων ὑμῶν προσθείῃ ὑμῖν ὡς ἐστὲ χιλιοπλασίως, καὶ εὐλογήσαι ὑμᾶς καθότι ἐλάλησεν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Πῶς δυνήσομαι μόνος φέρειν τὸν κόπον ὑμῶν καὶ τὴν ὑπόστασιν ὑμῶν καὶ τὰς ἀντιλογίας ὑμῶν; ");
INSERT INTO grcbrent_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Δότε ἑαυτοῖς ἄνδρας σοφοὺς καὶ ἐπιστήμονας καὶ συνετοὺς εἰς τὰς φυλὰς ὑμῶν, καὶ καταστήσω ἐφʼ ὑμῶν, ἡγουμένους ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Καὶ ἀπεκρίθητέ μοι, καὶ εἴπατε, καλὸν τὸ ῥῆμα ὃ ἐλάλησας ποιῆσαι. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Καὶ ἔλαβον ἐξ ὑμῶν ἄνδρας σοφοὺς καὶ ἐπιστήμονας καὶ συνετούς, καὶ κατέστησα αὐτοὺς ἡγεῖσθαι ἐφʼ ὑμῶν χιλιάρχους, καὶ ἑκατοντάρχους, καὶ πεντηκοντάρχους, καὶ δεκάρχους, καὶ γραμματοεισαγωγεῖς τοῖς κριταῖς ὑμῶν· ");
INSERT INTO grcbrent_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Καὶ ἐνετειλάμην τοῖς κριταῖς ὑμῶν ἐν τῷ καιρῷ ἐκείνῳ, λέγων, διακούετε ἀναμέσον τῶν ἀδελφῶν ὑμῶν, καὶ κρίνατε δικαίως ἀναμέσον ἀνδρὸς, καὶ ἀναμέσον ἀδελφοῦ, καὶ ἀναμέσον προσηλύτου αὐτοῦ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Οὐκ ἐπιγνώσῃ πρόσωπον ἐν κρίσει, κατὰ τὸν μικρὸν καὶ κατὰ τὸν μέγαν κρινεῖς, οὐ μὴ ὑποστείλῃ πρόσωπον ἀνθρώπου, ὅτι ἡ κρίσις τοῦ Θεοῦ ἐστι· καὶ τὸ ῥῆμα ὃ ἐὰν σκληρὸν ἠ· ἀφʼ ὑμῶν, ἀνοίσετε αὐτὸ ἐπʼ ἐμὲ, καὶ ἀκούσομαι αὐτό. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Καὶ ἐνετειλάμην ὑμῖν ἐν τῷ καιρῷ ἐκείνῳ πάντας τοὺς λόγους, οὓς ποιήσετε. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Καὶ ἀπάραντες ἐκ Χωρὴβ ἐπορεύθημεν πᾶσαν τὴν ἔρημον τὴν μεγάλην καὶ τὴν φοβερὰν ἐκείνην, ἣν εἴδετε, ὁδὸν ὄρους τοῦ Ἀμοῤῥαίου, καθότι ἐνετείλατο Κύριος ὁ Θεὸς ἡμῶν ἡμῖν, καὶ ἤλθομεν ἕως Κάδης Βαρνή. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Καὶ εἶπα πρὸς ὑμᾶς, ἤλθατε ἕως τοῦ ὄρους τοῦ Ἀμοῤῥαίου, ὃ Κύριος ὁ Θεὸς ἡμῶν δίδωσιν ὑμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ἴδετε, παραδέδωκεν ὑμῖν Κύριος ὁ Θεὸς ὑμῶν πρὸ προσώπου ὑμῶν τὴν γῆν· ἀναβάντες κληρονομήσατε ὃν τρόπον εἶπε Κύριος ὁ Θεὸς τῶν πατέρων ὑμῶν ὑμῖν· μὴ φοβεῖσθε, μηδὲ δειλιάσητε. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Καὶ προσήλθατέ μοι πάντες, καὶ εἴπατε, Ἀποστείλωμεν ἄνδρας προτέρους ἡμῶν, καὶ ἐφοδευσάτωσαν ἡμῖν τὴν γῆν, καὶ ἀναγγειλάτωσαν ἡμῖν ἀπόκρισιν τὴν ὁδὸν διʼ ἧς ἀναβησόμεθα ἐν αὐτῇ, καὶ τὰς πόλεις εἰς ἃς εἰσπορευσόμεθα εἰς αὐτάς. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Καὶ ἤρεσεν ἐναντίον μου τὸ ῥῆμα· καὶ ἔλαβον ἐξ ὑμῶν δώδεκα ἄνδρας, ἄνδρα ἕνα κατά φυλήν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Καὶ ἐπιστραφέντες ἀνέβησαν εἰς τὸ ὄρος, καὶ ἤλθοσαν ἕως φάραγγος βότρυος, καὶ κατεσκόπευσαν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Καὶ ἐλάβοσαν ἐν ταῖς χερσὶν αὐτῶν ἀπὸ τοῦ καρποῦ τῆς γῆς, καὶ κατήνεγκαν πρὸς ὑμᾶς, καὶ ἔλεγον, Ἀγαθὴ ἡ γῆ, ἣν Κύριος ὁ Θεὸς ἡμῶν δίδωσιν ἡμῖν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Καὶ οὐκ ἠθελήσατε ἀναβῆναι, ἀλλʼ ἠπειθήσατε τῷ ῥήματι Κυρίου τοῦ Θεοῦ ἡμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Καὶ διεγογγύζετε ἐν ταῖς σκηναῖς ὑμῶν, καὶ εἴπατε, διὰ τὸ μισεῖν Κύριον ἡμᾶς, ἐξήγαγεν ἡμᾶς ἐκ γῆς Αἰγύπτου παραδοῦναι ἡμᾶς εἰς χεῖρας Ἀμοῤῥαίων, ἐξολοθρεῦσαι ἡμᾶς. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ποῦ ἡμεῖς ἀναβαίνομεν; οἱ δὲ ἀδελφοὶ ὑμῶν ἀπέστησαν τὴν καρδίαν ὑμῶν, λέγοντες, ἔθνος μέγα καὶ πολὺ καὶ δυνατώτερον ἡμῶν, καὶ πόλεις μεγάλαι καὶ τετειχισμέναι ἕως τοῦ οὐρανοῦ· ἀλλὰ καὶ υἱοὺς γιγάντων ἑωράκαμεν ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Καὶ εἶπα πρὸς ὑμᾶς, μὴ πτήξητε, μηδὲ φοβηθῆτε ἀπʼ αὐτῶν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Κύριος ὁ Θεὸς ὑμῶν ὁ προπορευόμενος πρὸ προσώπου ὑμῶν, αὐτὸς συνεκπολεμήσει αὐτοὺς μεθʼ ὑμῶν κατὰ πάντα ὅσα ἐποίησεν ὑμῖν ἐν γῇ Αἰγύπτῳ, καὶ ἐν τῇ ἐρήμῳ ταύτῃ ἣν εἴδετε, ὁδὸν ὄρους τοῦ Ἀμοῤῥαίου· ὡς τροφοφορήσαι σε Κύριος ὁ ");
INSERT INTO grcbrent_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Θεός σου, ὡς εἴτις τροφοφορήσαι ἄνθρωπος τὸν υἱὸν αὐτοῦ, κατὰ πᾶσαν τὴν ὁδὸν εἰς ἣν ἐπορεύθητε ἕως ῆλθετε εἰς τὸν τόπον τοῦτον. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Καὶ ἐν τῷ λόγῳ τούτῳ οὐκ ἐνεπιστεύσατε Κυρίῳ τῷ Θεῷ ἡμῶν, ");
INSERT INTO grcbrent_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ὃς προπορεύεται πρότερος ὑμῶν ἐν τῇ ὁδῷ ἐκλέγεσθαι ὑμῖν τόπον, ὁδηγῶν ὑμᾶς ἐν πυρὶ νυκτὸς, δεικνύων ὑμῖν τὴν ὁδὸν καθʼ ἣν πορεύεσθε ἐπʼ αὐτῆς, καὶ ἐν νεφέλῃ ἡμέρας. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Καὶ ἤκουσε Κύριος τὴν φωνὴν τῶν λόγων ὑμῶν, καὶ παροξυνθεὶς ὤμοσε, λέγων, ");
INSERT INTO grcbrent_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","εἰ ὄψεταί τις τῶν ἀνδρῶν τούτων τὴν γῆν ἀγαθὴν ταύτην, ἣν ὤμοσα τοῖς πατράσιν αὐτῶν, πλὴν ");
INSERT INTO grcbrent_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Χάλεβ υἱὸς Ἰεφοννὴ, οὗτος ὄψεται αὐτὴν, καὶ τούτῳ δώσω τὴν γῆν ἐφʼ ἣν ἐπέβη, καὶ τοῖς υἱοῖς αὐτοῦ, διὰ τὸ προσκεῖσθαι αὐτὸν τὰ πρὸς Κύριον. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Καὶ ἐμοὶ ἐθυμώθη Κύριος διʼ ὑμᾶς, λέγων, οὐδὲ σὺ οὐ μὴ εἰσέλθῃς ἐκεῖ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ἰησοῦς υἱὸς Ναυὴ ὁ παρεστηκώς σοι, οὗτος εἰσελεύσεται ἐκεῖ· αὐτὸν κατίσχυσον, ὅτι αὐτὸς κατακληρονομήσει αὐτὴν τῷ Ἰσραήλ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Καὶ πᾶν παιδίον νέον ὅστις οὐκ οἶδε σήμερον ἀγαθὸν ἢ κακόν, οὗτοι εἰσελεύσονται ἐκεῖ, καὶ τούτοις δώσω αὐτήν, καὶ αὐτοὶ κληρονομήσουσιν αὐτήν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Καὶ ὑμεῖς ἐπιστράφεντες ἐστρατοπεδεύσατε εἰς τὴν ἔρημον, ὁδὸν τὴν ἐπὶ τῆς ἐρυθρᾶς θαλάσσης. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Καὶ ἀπεκρίθητε, καὶ εἴπατε, ἡμάρτομεν ἔναντι Κυρίου τοῦ Θεοῦ ἡμῶν· ἡμεῖς ἀναβάντες πολεμήσομεν κατὰ πάντα ὅσα ἐνετείλατο Κύριος ὁ Θεὸς ἡμῶν ἡμῖν· καὶ ἀναλαβόντες ἕκαστος τὰ σκεύη τὰ πολεμικὰ αὐτοῦ, καὶ συναθροισθέντες ἀναβαίνετε εἰς τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Καὶ εἶπε Κύριος πρὸς μὲ, εἶπον αὐτοῖς, οὐκ ἀναβήσεσθε οὐδὲ μὴ πολεμήσετε, οὐ γάρ εἰμι μεθʼ ὑμῶν, καὶ οὐ μὴ συντριβῆτε ἐνώπιον τῶν ἐχθρῶν ὑμῶν. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Καὶ ἐλάλησα ὑμῖν, καὶ οὐκ εἰσηκούσατέ μου· καὶ παρέβητε τὸ ῥῆμα Κυρίου· καὶ παραβιασάμενοι ἀνέβητε εἰς τὸ ὄρος. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Καὶ ἐξῆλθεν ὁ Ἀμοῤῥαῖος ὁ κατοικῶν ἐν τῷ ὄρει ἐκείνῳ εἰς συνάντησιν ὑμῖν, καὶ κατεδίωξεν ὑμᾶς ὡσεὶ ποιήσαισαν αἱ μέλισσαι, καὶ ἐτίτρωσκον ὑμᾶς ἀπὸ Σηεὶρ ἕως Ἑρμᾶ. ");
INSERT INTO grcbrent_vpl VALUES ("DT1_45","